/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x00000000000118f8ULL, 0x0000000000011478ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x00000000000100d0ULL, 0x0000000000000230ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000010300ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000100d000000000ULL, 0x0000a40400000000ULL, 0x0400288080810c00ULL, 0x0000000000003f84ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8a08288080840828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x002880808a920000ULL, 0x0000000000000022ULL, 0x00000034ffffffffULL,
0x0000006800000000ULL, 0x000100d000000000ULL, 0x0000023000000000ULL, 0x0000580400000000ULL,
0x8087288080840900ULL, 0x0900000004042880ULL, 0x288080842880808aULL, 0x0000000e00082f04ULL,
0x0008120400000080ULL, 0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL,
0x000000000000000eULL, 0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000007c00043704ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x00801b0380005003ULL, 0x0000f21000103104ULL, 0x0000f2300000f220ULL,
0x00e429040000f240ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002a05000025ULL, 0x050000250500002aULL, 0x0500002505000025ULL,
0x0500003d0500003dULL, 0x0500003d0500003dULL, 0x0500003d0500003dULL, 0x0500003d0500003dULL,
0x0500003d0500003dULL, 0x00e428040500003dULL, 0x00000140000000e0ULL, 0x00001d1000001c60ULL,
0x00001dc000001d80ULL, 0x0000220000002160ULL, 0x000037e000003760ULL, 0x0000387000003840ULL,
0x00003c0000003be0ULL, 0x0000505000004fc0ULL, 0x000050f0000050b0ULL, 0x0000546000005450ULL,
0x0000689000006810ULL, 0x0000694000006900ULL, 0x0000714000007110ULL, 0x00007c8000007c70ULL,
0x0000a1200000a0f0ULL, 0x0000a7f00000a7d0ULL, 0x0000eb200000eb10ULL, 0x0000eb400000eb30ULL,
0x0000eb900000eb70ULL, 0x0000ebc00000ebb0ULL, 0x0000f2200000f200ULL, 0x0000f2700000f230ULL,
0x0000f2900000f280ULL, 0x0000fc700000fbe0ULL, 0x0000fd300000fcd0ULL, 0x0000fe000000fda0ULL,
0x0000fec00000fe60ULL, 0x0000fff00000ff50ULL, 0x04b0390400010090ULL, 0x000000ff000002e0ULL,
0x000401000000f600ULL, 0x0000000a000003c0ULL, 0x003f01000000f608ULL, 0x0000000a000004d0ULL,
0x003f01000000f688ULL, 0x00000006000005f0ULL, 0x003f01000000f6a8ULL, 0x0000000300000700ULL,
0x003f01000000f6c8ULL, 0x00000002000008c0ULL, 0x003f01070000f600ULL, 0x0000000400000a90ULL,
0x003f01010000f688ULL, 0x000000ff000011b0ULL, 0x0006010700000000ULL, 0x000000ff000011e0ULL,
0x0006010100000000ULL, 0x0000001600001260ULL, 0x003f010100000020ULL, 0x00000052000014f0ULL,
0x003f010500000000ULL, 0x00000054000016f0ULL, 0x003f01090000f6c8ULL, 0x000000ff00001a70ULL,
0x0006010700000000ULL, 0x000000ff00001ad0ULL, 0x0006010100000000ULL, 0x0000003900001b10ULL,
0x003f010500000000ULL, 0x0000005000001b30ULL, 0x003f01010000f608ULL, 0x0000005000001b40ULL,
0x003f01090000f608ULL, 0x0000003900002030ULL, 0x003f010900000000ULL, 0x00000044000030d0ULL,
0x003f01010000f6c8ULL, 0x00000046000030f0ULL, 0x003f01010000f688ULL, 0x0000005200003120ULL,
0x003f010500000000ULL, 0x00000054000031a0ULL, 0x003f01090000f6c8ULL, 0x000000ff00003600ULL,
0x0006010700000000ULL, 0x000000ff00003650ULL, 0x0006010100000000ULL, 0x000000ff00003680ULL,
0x0007010500000000ULL, 0x00000050000036b0ULL, 0x003f01010000f628ULL, 0x00000050000036c0ULL,
0x003f01090000f628ULL, 0x0000002100003b30ULL, 0x003f01090000f6a8ULL, 0x0000004400004a50ULL,
0x003f01010000f6c8ULL, 0x0000004600004a70ULL, 0x003f01010000f690ULL, 0x0000005200004aa0ULL,
0x003f010500000000ULL, 0x0000002100004b60ULL, 0x003f01090000f6a8ULL, 0x000000ff00004ea0ULL,
0x0007010700000000ULL, 0x0000003a00004ef0ULL, 0x003f010100000000ULL, 0x000000ff00004f20ULL,
0x0006010500000000ULL, 0x0000005000004f30ULL, 0x003f01010000f648ULL, 0x0000005000004f40ULL,
0x003f01090000f648ULL, 0x00000023000053a0ULL, 0x003f01090000f6a8ULL, 0x00000044000062d0ULL,
0x003f01010000f6c8ULL, 0x00000046000062e0ULL, 0x003f01010000f698ULL, 0x0000005200006310ULL,
0x003f010500000000ULL, 0x00000054000063d0ULL, 0x003f01090000f6c8ULL, 0x000000ff00006720ULL,
0x0006010700000000ULL, 0x0000005e00006760ULL, 0x003f010100000000ULL, 0x000000ff00006790ULL,
0x0007010500000000ULL, 0x00000050000067a0ULL, 0x003f01010000f668ULL, 0x00000050000067b0ULL,
0x003f01090000f668ULL, 0x0000004f00006bd0ULL, 0x003f01090000f6a8ULL, 0x0000004400007810ULL,
0x003f01010000f6c8ULL, 0x0000004600007840ULL, 0x003f01010000f6a0ULL, 0x000000020000b0d0ULL,
0x003f01010000f600ULL, 0x000000020000bf90ULL, 0x003f01090000f600ULL, 0x000000020000c140ULL,
0x003f01010000f600ULL, 0x000000020000c150ULL, 0x003f01090000f600ULL, 0x0000000a0000e260ULL,
0x003f01010000f688ULL, 0x0000000a0000e3e0ULL, 0x003f01090000f688ULL, 0x0000000b0000f580ULL,
0x003f01010000f608ULL, 0x0000000b0000f590ULL, 0x003f01010000f610ULL, 0x0000000b0000f5a0ULL,
0x003f01010000f618ULL, 0x0000000b0000f5b0ULL, 0x003f01010000f620ULL, 0x000000540000f5e0ULL,
0x003f01090000f6c8ULL, 0x000000500000f640ULL, 0x003f01090000f608ULL, 0x000000390000f6a0ULL,
0x003f010900000000ULL, 0x000000540000f700ULL, 0x003f01090000f6c8ULL, 0x000000500000f760ULL,
0x003f01090000f628ULL, 0x000000210000f7c0ULL, 0x003f01090000f6a8ULL, 0x000000210000f820ULL,
0x003f01090000f6a8ULL, 0x000000500000f880ULL, 0x003f01090000f648ULL, 0x000000230000f8e0ULL,
0x003f01090000f6a8ULL, 0x000000540000f940ULL, 0x003f01090000f6c8ULL, 0x000000500000f9a0ULL,
0x003f01090000f668ULL, 0x0000004f0000fa00ULL, 0x003f01090000f6a8ULL, 0x000000020000fa60ULL,
0x003f01090000f600ULL, 0x000000020000fac0ULL, 0x003f01090000f600ULL, 0x0000000a0000fb20ULL,
0x003f01090000f688ULL, 0x00141c0400053803ULL, 0x0000b0800000ae20ULL, 0x0000c2100000c170ULL,
0x000c05040000f5d0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0058190300000000ULL,
0x0000000f00080a04ULL, 0x0004360400580210ULL, 0x0000000000000008ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x0000000000000000ULL, 0x00000000000000d4ULL, 0x0000000e00000002ULL, 0x00000000000100d0ULL,
0x0000000000000044ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000aaULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x00000000000c7919ULL, 0x000eae0000002300ULL,
0x00008400ff1a7b82ULL, 0x000ee20000000800ULL, 0x0000040000027802ULL, 0x000fe20000000f00ULL,
0x000002e000007945ULL, 0x000fe20003800000ULL, 0x0000000000037919ULL, 0x000ea20000002200ULL,
0x0000000000477919ULL, 0x000f280000002100ULL, 0x00000000000479c3ULL, 0x000f620000002500ULL,
0x00000000000b7919ULL, 0x000f620000008800ULL, 0x0000000000167919ULL, 0x000eec0000002600ULL,
0x00008800ff047b82ULL, 0x000ee20000000a00ULL, 0x00000000000d7919ULL, 0x000eee0000002700ULL,
0x00008e00ff087b82ULL, 0x000ee20000000a00ULL, 0x000000010c007824ULL, 0x004fc400078e0203ULL,
0x00001fff0c0c7589ULL, 0x000fe400000e0000ULL, 0x0000008000037824ULL, 0x110fe200078e0247ULL,
0x00000005ff477819ULL, 0x000fe20000011647ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x000006540b027816ULL, 0x022fe40000000002ULL, 0x0000007f0300780cULL, 0x040fe40003f84070ULL,
0x00001fff47477589ULL, 0x000e6200000e0000ULL, 0x000000ff0300720cULL, 0x000fc40003f05270ULL,
0x0000000f0300780cULL, 0x040fe40003f24070ULL, 0x000000030300780cULL, 0x040fe40003f64070ULL,
0x000000010300780cULL, 0x000fc80003f44070ULL, 0x000000000007c919ULL, 0x000f220000008800ULL,
0x000004000006c802ULL, 0x000fe20000000f00ULL, 0xff317217ff11c424ULL, 0x000fe400078e00ffULL,
0x000000040c0a7824ULL, 0x002fe200078e0247ULL, 0x00000004ff0f7819ULL, 0x004fc60000011600ULL,
0x000000020a0b7824ULL, 0x000fc800078e00ffULL, 0x000000010b127824ULL, 0x040fe200078e020fULL,
0x000000080b107848ULL, 0x000fe40007fe0000ULL, 0x00000654070ec816ULL, 0x010fe20000000006ULL,
0x0000000816067824ULL, 0x008fe400078e00ffULL, 0x000000081a077824ULL, 0x000fc800078e00ffULL,
0x0000000d07077224ULL, 0x000fe400078e0206ULL, 0x000000040306c824ULL, 0x000fe400078e020eULL,
0x00000004ff0e7e24ULL, 0x000fe4000f8e00ffULL, 0x0000000107077824ULL, 0x000fe200078e0212ULL,
0x0000000000240947ULL, 0x000fec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x00f60006043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x00000004030a7c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x000000000a0612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x00f60804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000383947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x00000004030a7c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fca0000000000ULL,
0x000000000a0612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x00f68804063f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00f400110600c388ULL, 0x0007e20000000800ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000383947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000403067c11ULL, 0x008fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fca0000000000ULL,
0x00000000060612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x00f6a804063f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x002e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000403037c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x00cfca0000000000ULL, 0x00000000030612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x00f6c804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x004fe20000010000ULL, 0x00000000020472caULL, 0x002fe200000e0000ULL,
0x00000010000a7824ULL, 0x000fe200078e00ffULL, 0x0000000712037812ULL, 0x000fe200078ec0ffULL,
0x0000000110107824ULL, 0x000fe400078e0a0bULL, 0x0000010007047825ULL, 0x000fe200078e0004ULL,
0x000000f00a077812ULL, 0x000fe200078ec0ffULL, 0x00008200000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000000f03037812ULL, 0x000fe400078e7800ULL, 0x000000100f00720cULL, 0x000fc40003f06070ULL,
0x0000000704067210ULL, 0x008fe20007f3e0ffULL, 0x0000001012037824ULL, 0x000fe200078e0203ULL,
0x0000f60004047890ULL, 0x000fc6000fffe03fULL, 0x000000ffff077224ULL, 0x000fe400008e0605ULL,
0x0000001003037824ULL, 0x000fe400078e0202ULL, 0x000000040d047825ULL, 0x000fc600078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e2000c101c4aULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffffff79a7ULL, 0x000fe40008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000a04047981ULL, 0x000ea2000c1e1900ULL, 0x00000300ff037b82ULL, 0x002e620000000800ULL,
0x000000ff0c00720cULL, 0x000fe40003f05270ULL, 0x00000000040972caULL, 0x004fda00000e0000ULL,
0x0000003f09047890ULL, 0x000fe4000fffe03fULL, 0x000000ff09057890ULL, 0x000fe4000fffe03fULL,
0x000000063f047899ULL, 0x000fe40008011604ULL, 0x000000083f057899ULL, 0x000fe20008011605ULL,
0x000000a400c08947ULL, 0x002ff60003800000ULL, 0x00000002ff0f7819ULL, 0x000fe20000011647ULL,
0x0000000847417824ULL, 0x000fe400078e00ffULL, 0xffffffffff0b7424ULL, 0x000fe200078e00ffULL,
0x03ffffff0f057812ULL, 0x000fe200078ec0ffULL, 0x00000004ff097424ULL, 0x000fe200078e00ffULL,
0x0000000147457812ULL, 0x000fe200078ec0ffULL, 0x00008a00000c7ab9ULL, 0x000fe40000000a00ULL,
0x000000040e117824ULL, 0x000fca00078e0205ULL, 0x0000000411007c0cULL, 0x000fda000bf06070ULL,
0x00009000ff058b82ULL, 0x000e620000000800ULL, 0x000000020d048824ULL, 0x000fce00078e00ffULL,
0x00008c00ff068b82ULL, 0x000ea20000000a00ULL, 0x0000000504048224ULL, 0x002fc800078e0205ULL,
0x0000000111058824ULL, 0x000fe400078e0204ULL, 0x0000000102047824ULL, 0x000fe400078e0241ULL,
0x0000000405068825ULL, 0x004fe400078e0006ULL, 0x00f6880904ff79a7ULL, 0x0003e6000850003fULL,
0x0000000a060b8981ULL, 0x0004e2000c1e1900ULL, 0x0000000311057812ULL, 0x000fc800078ec0ffULL,
0x000000030500780cULL, 0x000fe40003f05270ULL, 0xfffffffd03047811ULL, 0x002fc800078e10ffULL,
0x0000000104707807ULL, 0x000fca0004000000ULL, 0x0000000111707824ULL, 0x000fca00078e0270ULL,
0x0000000470007c0cULL, 0x000fda000bf06070ULL, 0x00009000ff0c8b82ULL, 0x000e620000000800ULL,
0x000000020d058824ULL, 0x000fce00078e00ffULL, 0x00008c00ff088b82ULL, 0x000f220000000a00ULL,
0x00000003ff117819ULL, 0x000fe20000011600ULL, 0x0000001045107824ULL, 0x000fe200078e00ffULL,
0x00000001ff437819ULL, 0x000fc60000011647ULL, 0x0000000411157836ULL, 0x000fe40000000000ULL,
0x0000000c05058224ULL, 0x002fc800078e020cULL, 0x0000000105078824ULL, 0x004fe400078e0270ULL,
0xffffffffff057424ULL, 0x000fe400078e00ffULL, 0x0000000407068825ULL, 0x010fc800078e0008ULL,
0x0000000110137824ULL, 0x040fe200078e0211ULL, 0x0000000a06058981ULL, 0x000362000c1e1900ULL,
0x0000000110177824ULL, 0x000fe200078e0215ULL, 0x00000000430672caULL, 0x000fe200000e0000ULL,
0x0000000813147824ULL, 0x040fe200078e00ffULL, 0x0000000013097212ULL, 0x080fe200078e3cffULL,
0x0000000817187824ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000010e087836ULL, 0x000fe20000000000ULL, 0xfffffff814147812ULL, 0x000fe200078ee209ULL,
0x0000000c111d7836ULL, 0x000fe20000000000ULL, 0x0000000017077212ULL, 0x082fe200078e3cffULL,
0x0000002043067824ULL, 0x000fe200078e00ffULL, 0x0000000508007c0cULL, 0x000fe2000bf06070ULL,
0x00000001101f7824ULL, 0x000fe200078e021dULL, 0xfffffff818187812ULL, 0x000fe200078ee207ULL,
0x000001000e0c7824ULL, 0x000fe200078e0206ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000004016077824ULL, 0x000fe200078e00ffULL, 0x000000001f207212ULL, 0x000fe200078e3cffULL,
0x0000200043087824ULL, 0x000fe200078e0202ULL, 0x000000090c097c48ULL, 0x000fe2000ffe0000ULL,
0x00000001ff317424ULL, 0x000fe200078e00ffULL, 0x0000000000367805ULL, 0x000fc4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000109097824ULL, 0x000fe200078e0a0cULL, 0x00000020070c7812ULL, 0x000fe400078ef80cULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x0000002009097807ULL, 0x000fe20000000000ULL,
0x000000010c1e7824ULL, 0x000fc400078e021fULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0x0000001009097248ULL, 0x000fe20007fe0000ULL, 0x000000010c167824ULL, 0x040fe400078e0217ULL,
0x000000010c127824ULL, 0x000fe200078e0213ULL, 0xfffffff81f207812ULL, 0x000fe200078ee220ULL,
0x0000b00008137836ULL, 0x000fe40000000000ULL, 0x0000000109097824ULL, 0x000fe400078e0a10ULL,
0x0000001014177824ULL, 0x000fc400078e0213ULL, 0x00000010201f7824ULL, 0x000fe200078e0213ULL,
0x000000091100720cULL, 0x080fe40003f06070ULL, 0x000000091500720cULL, 0x000fe40003f46070ULL,
0x000000700a157812ULL, 0x000fe200078ec0ffULL, 0x0000001a0b0b7224ULL, 0x008fe400078e02ffULL,
0x00000008111a7836ULL, 0x000fe40000000000ULL, 0x000000400b0b7824ULL, 0x000fc400078e00ffULL,
0x0000000110197824ULL, 0x000fc600078e021aULL, 0x000000160b167210ULL, 0x000fe20007f9e0ffULL,
0x0000000819227824ULL, 0x040fe200078e00ffULL, 0x00000000191b7212ULL, 0x000fe200078e3cffULL,
0x000000010c1c7824ULL, 0x000fe200078e0219ULL, 0x000000120b127210ULL, 0x000fe20007f3e0ffULL,
0x0000001018197824ULL, 0x100fe200078e0213ULL, 0xfffffff8220c7812ULL, 0x000fe400078ee21bULL,
0x0000000c12147c11ULL, 0x000fe2000f8638ffULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x0000001c0b1c7210ULL, 0x000fe20007fbe0ffULL, 0x000000100c1b7824ULL, 0x000fe200078e0213ULL,
0x000000091a00720cULL, 0x000fe20003f26070ULL, 0x000000ffff137224ULL, 0x000fe200020e06ffULL,
0x0000000c16107c11ULL, 0x000fc4000f8838ffULL, 0x0000000d12187c11ULL, 0x000fe400098f3c11ULL,
0x0000000d16137c11ULL, 0x000fe2000a0f3c13ULL, 0x0000f6a802167836ULL, 0x000fe20000000000ULL,
0x0000001e0b1e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e06ffULL,
0x0000000c1c127c11ULL, 0x000fe4000f8a38ffULL, 0x00000000160772caULL, 0x000fe200000e0000ULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x00000014150a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000843167824ULL, 0x000fe200078e0216ULL, 0x0000000d1c0c7c11ULL, 0x000fc4000a8f3c0bULL,
0x0000000c1e147c11ULL, 0x040fe2000f8a38ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e0618ULL,
0x0000001510107210ULL, 0x000fe40007f7e0ffULL, 0x000000091d00720cULL, 0x000fe40003f86070ULL,
0x0000000d1e097c11ULL, 0x000fe2000a8f3c11ULL, 0x000000ffff117224ULL, 0x000fe200018e0613ULL,
0x0000001512127210ULL, 0x000fe20007fbe0ffULL, 0x0000000706067291ULL, 0x000fe2000f8e203fULL,
0x0000001514147210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a177faeULL, 0x0003e2000c101c4aULL, 0x000000050e007c0cULL, 0x000fe2000bf06070ULL,
0x000000ffff137224ULL, 0x000fc400028e060cULL, 0x000000ffff157224ULL, 0x000fe200018e0609ULL,
0x0000000010197faeULL, 0x0003e2000d101c4aULL, 0xff317217ff097424ULL, 0x000fe400078e00ffULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x00000000121b7faeULL, 0x0003e8000c901c4aULL,
0x00000000141f7faeULL, 0x0003e2000e101c4aULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000031ff7479a7ULL, 0x000ee20008500006ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x00000000001a7805ULL, 0x002fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fc4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00002031163079a7ULL, 0x0002a2000850003fULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x002fe2000001ff00ULL, 0x0000006800080947ULL, 0x000fec0003800000ULL,
0x00009000ff0a7b82ULL, 0x000e620000000800ULL, 0x000000020d0b7824ULL, 0x000fe400078e00ffULL,
0xff317217ff097424ULL, 0x000fe400078e00ffULL, 0x000000ffff737224ULL, 0x000fe400078e00ffULL,
0x000000ffff2b7224ULL, 0x000fe400078e00ffULL, 0x0000000a0b0b7224ULL, 0x002fce00078e020aULL,
0x000001000e567824ULL, 0x000fca00078e00ffULL, 0x0000000956007c0cULL, 0x000fda000bf06070ULL,
0x0000006400d80947ULL, 0x000fea0003800000ULL, 0xffffffe0410d7812ULL, 0x040fe200078ec0ffULL,
0x000000010e207836ULL, 0x000fe20000000000ULL, 0x0000001041087812ULL, 0x000fe200078ec0ffULL,
0x00000004473a7824ULL, 0x040fe200078e00ffULL, 0x00000001ff437819ULL, 0x000fe20000011647ULL,
0x0000001047597824ULL, 0x000fe200078e00ffULL, 0x0000000208087210ULL, 0x000fe20007ffe00dULL,
0x00000008733c7824ULL, 0x000fe200078e00ffULL, 0x00000008410d7812ULL, 0x000fe200078ec0ffULL,
0x00000020436b7824ULL, 0x000fe200078e0256ULL, 0x0000000520007c0cULL, 0x000fe2000bf06070ULL,
0x00008400000c7ab9ULL, 0x000fe20000000800ULL, 0x0000000370207812ULL, 0x000fe200078ec0ffULL,
0x0000000108507824ULL, 0x000fe200078e020dULL, 0xfffffff83a0d7812ULL, 0x000fe200078ec0ffULL,
0x000000406b087836ULL, 0x000fe20000000000ULL, 0x000000032000780cULL, 0x000fe20003f25270ULL,
0x0000000c05057c24ULL, 0x020fe2000f8e02ffULL, 0x00000003ff4c7819ULL, 0x000fe20000011600ULL,
0x0000000102547824ULL, 0x000fe200078e020dULL, 0x0000000104217807ULL, 0x000fe20004800000ULL,
0x0000004005057824ULL, 0x000fe200078e00ffULL, 0x00000009080d7c48ULL, 0x000fe2000ffe0000ULL,
0x0000f6c854527836ULL, 0x000fe20000000000ULL, 0x0000001059597812ULL, 0x000fe200078ec0ffULL,
0x000000044c4a7836ULL, 0x000fe20000000000ULL, 0x000000083c207812ULL, 0x000fe200078e0cffULL,
0x000000084c497836ULL, 0x040fe20000000000ULL, 0x00000031520075a7ULL, 0x004e62000802007fULL,
0x0000000c4c487836ULL, 0x000fe20000000000ULL, 0x00000000200672caULL, 0x000fe200000e0000ULL,
0x000000010d0d7824ULL, 0x000fe200078e0a08ULL, 0x0000002007087812ULL, 0x000fe200078ef808ULL,
0x000000014c577824ULL, 0x000fc400078e0259ULL, 0x000000014a557824ULL, 0x100fe400078e0259ULL,
0x0000000149537824ULL, 0x100fe200078e0259ULL, 0x0000000057647212ULL, 0x080fe200078e3cffULL,
0x0000000148517824ULL, 0x000fe200078e0259ULL, 0x0000000055637212ULL, 0x080fe200078e3cffULL,
0x0000000108207824ULL, 0x040fe200078e0257ULL, 0x0000000053627212ULL, 0x080fe200078e3cffULL,
0x0000000108227824ULL, 0x040fe200078e0255ULL, 0x0000000051607212ULL, 0x000fe200078e3cffULL,
0x0000000108327824ULL, 0x040fe200078e0253ULL, 0x0000002005207210ULL, 0x000fe20007fbe0ffULL,
0x0000000108087824ULL, 0x000fe200078e0251ULL, 0x0000002205227210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff5c7224ULL, 0x000fe200078e0070ULL, 0x0000003205327210ULL, 0x000fe20007f7e0ffULL,
0x0000000170707824ULL, 0x000fe200078e0221ULL, 0x0000000805087210ULL, 0x000fe20007f5e0ffULL,
0x0000000857057824ULL, 0x000fc400078e00ffULL, 0x0000000855387824ULL, 0x000fe400078e00ffULL,
0x0000000853217824ULL, 0x000fe200078e00ffULL, 0xfffffff805647812ULL, 0x000fe200078ee264ULL,
0x0000000851237824ULL, 0x000fe200078e00ffULL, 0xfffffff838637812ULL, 0x000fe400078ee263ULL,
0xfffffff821627812ULL, 0x000fe400078ee262ULL, 0xfffffff823607812ULL, 0x000fe200078ee260ULL,
0x0000000000081947ULL, 0x002fec0003800000ULL, 0x00f6c831540075a7ULL, 0x000e64000802017fULL,
0x000000dc00b49947ULL, 0x002fea0003800000ULL, 0x00008a00000e7ab9ULL, 0x000fe20000000a00ULL,
0x000000ffff237224ULL, 0x000fe200010e06ffULL, 0x0000000e083e7c11ULL, 0x000fe2000f8438ffULL,
0x000000ffff337224ULL, 0x000fe200020e06ffULL, 0x0000000470007c0cULL, 0x000fe2000bf26070ULL,
0x0000100073057824ULL, 0x000fe200078e00ffULL, 0x0000000e22407c11ULL, 0x000fe2000f8838ffULL,
0x000000ffff397224ULL, 0x000fe200028e06ffULL, 0x0000000f08237c11ULL, 0x000fe200090f3c23ULL,
0x00000010004b7824ULL, 0x000fe200078e00ffULL, 0x000000200d087807ULL, 0x000fe20000000000ULL,
0x000000ffff317224ULL, 0x000fe200018e06ffULL, 0x0000000f22337c11ULL, 0x000fc4000a0f3c33ULL,
0x0000005908227248ULL, 0x000fe20007fe0000ULL, 0x0000200043087824ULL, 0x000fe200078e0202ULL,
0x0000000e20387c11ULL, 0x000fe4000f8a38ffULL, 0x00001000050d7812ULL, 0x000fe200078e0cffULL,
0x0000000122057824ULL, 0x000fe200078e0a59ULL, 0x0000000f20397c11ULL, 0x000fe4000a8f3c39ULL,
0x0000000e32307c11ULL, 0x000fe2000f8638ffULL, 0x00008c00ff209b82ULL, 0x000e620000000a00ULL,
0xfffffff0414f7812ULL, 0x000fc400078ec0ffULL, 0x000000704b4b7812ULL, 0x000fe400078ec0ffULL,
0x0000000f32317c11ULL, 0x000fe400098f3c31ULL, 0x0000f6a8024d7810ULL, 0x000fe40007ffe04fULL,
0x000000054c00720cULL, 0x080fe40003f46070ULL, 0x000000054a00720cULL, 0x000fe40003f66070ULL,
0x0000b000086e7810ULL, 0x000fc40007ffe00dULL, 0x0000004b38387210ULL, 0x000fe40007f9e0ffULL,
0x0000004b40327210ULL, 0x000fe20007fbe0ffULL, 0x00000010646a7824ULL, 0x100fe200078e026eULL,
0x000000004d0772caULL, 0x000fe200000e0000ULL, 0x000000ffff397224ULL, 0x000fe200020e0639ULL,
0x000000054800720cULL, 0x080fe20003f86070ULL, 0x000000ffff337224ULL, 0x000fe200028e0633ULL,
0x000000054900720cULL, 0x000fe20003fa6070ULL, 0x0000001063697824ULL, 0x000fe200078e026eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000386a7faeULL, 0x0005e2000d101c4aULL,
0x0000004b30307210ULL, 0x000fe20007f5e0ffULL, 0x000000010b059824ULL, 0x000fc400078e0270ULL,
0x0000000032697faeULL, 0x0009e2000d901c4aULL, 0x0000004b3e227210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fe200010e0631ULL, 0x0000000607067290ULL, 0x000fe2000fffe03fULL,
0x0000001062687824ULL, 0x000fe400078e026eULL, 0x0000000405209825ULL, 0x002fc600078e0020ULL,
0x0000000030687faeULL, 0x0003e2000e901c4aULL, 0x000000ffff237224ULL, 0x000fe400018e0623ULL,
0x0000001060677824ULL, 0x000fe400078e026eULL, 0xffffffffff057424ULL, 0x000fc600078e00ffULL,
0x0000000022677faeULL, 0x0003e2000e101c4aULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000a20059981ULL, 0x000362000c1e1900ULL, 0x00000001ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000014d397824ULL, 0x004fe200078e023cULL, 0x00000000ff0079b0ULL, 0x000fe20008000a46ULL,
0x0000000000007918ULL, 0x010fca0000000000ULL, 0x0000000dff7679a7ULL, 0x0004a20008500006ULL,
0x00000001ff4e7819ULL, 0x000fe20000011600ULL, 0x000000800f227824ULL, 0x002fc600078e0202ULL,
0x0000000c4e4e7812ULL, 0x000fe200078ec0ffULL, 0x00000075390075a7ULL, 0x0084a6000802007fULL,
0x000000224e227210ULL, 0x000fe20007ffe04bULL, 0x00f6080d502079a7ULL, 0x000e64000850003fULL,
0x00f60821500075a7ULL, 0x002e64000804017fULL, 0x000000d800b8a947ULL, 0x006fea0003800000ULL,
0x00f0000022207984ULL, 0x000e620000000800ULL, 0x00001000473f7824ULL, 0x000fe200078e00ffULL,
0x00000008005f7812ULL, 0x000fe400078ec0ffULL, 0x00f20000225d7984ULL, 0x0004a20000000800ULL,
0x000000043a337812ULL, 0x000fe400078ec0ffULL, 0xffffe0003f3f7812ULL, 0x000fe400078ec0ffULL,
0x000000075f587812ULL, 0x000fe400078ec800ULL, 0x0000003300337211ULL, 0x000fe200078fe0ffULL,
0x0000000102307824ULL, 0x000fe200078e023fULL, 0x000000075f5f7812ULL, 0x000fc400078ef800ULL,
0x0000003358657212ULL, 0x000fe200078e3cffULL, 0x0000100073307824ULL, 0x000fc800078e0230ULL,
0x0000b00030317836ULL, 0x000fe40000000000ULL, 0x000000085f3e7824ULL, 0x000fc800078e0265ULL,
0x000000103e387824ULL, 0x000fe200078e0231ULL, 0x000000092000720bULL, 0x002fda0003f5d000ULL,
0x0000000000217806ULL, 0x000fc800010e0100ULL, 0x0000ffff21327812ULL, 0x000fe2000784c0ffULL,
0x00000001ff217424ULL, 0x000fca00078e00ffULL, 0x0000761021307816ULL, 0x000fce0000000030ULL,
0x0000000000dca947ULL, 0x004fea0003800000ULL, 0x000000092000720bULL, 0x000fe40003f54000ULL,
0x00000020093a7209ULL, 0x000fe40007810000ULL, 0x00000002ff227819ULL, 0x000fc60000011600ULL,
0x8000003a09217221ULL, 0x000fe40000010000ULL, 0x0000000822237836ULL, 0x000fe40000000000ULL,
0x3fb8aa3b21217820ULL, 0x000fe40000410000ULL, 0x0000000000097806ULL, 0x000fe400010e0100ULL,
0x000000470f00720cULL, 0x000fe40003f45270ULL, 0x0000ffff09097812ULL, 0x000fe200078e3cffULL,
0x0000002100217308ULL, 0x000e660000000800ULL, 0x0000000932ff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff307807ULL, 0x000fc60001800000ULL, 0x000000804709a824ULL, 0x000fe200078e0202ULL,
0x00001f2321237589ULL, 0x002e6a00000e0000ULL, 0x8000003a20203221ULL, 0x000fe20000010000ULL,
0x000000094e09a210ULL, 0x000fe20007ffe04bULL, 0x000000210c0c7220ULL, 0x000fe20000410000ULL,
0x00001f2221227589ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b20203820ULL, 0x000fc60000410000ULL,
0x00f4003a0900a388ULL, 0x0007e20000000800ULL, 0x00000020000a3308ULL, 0x000f220000000800ULL,
0x000000ffff097224ULL, 0x008fe400078e003aULL, 0x000000232b2b7220ULL, 0x082fe20000410000ULL,
0x000000232a2a7220ULL, 0x080fe20000410000ULL, 0x0000002337377220ULL, 0x080fe20000410000ULL,
0x0000002336367220ULL, 0x080fe20000410000ULL, 0x000000232f2f7220ULL, 0x080fe20000410000ULL,
0x000000232e2e7220ULL, 0x080fe20000410000ULL, 0x0000002327277220ULL, 0x080fe20000410000ULL,
0x0000002326267220ULL, 0x080fe20000410000ULL, 0x000000231b1b7220ULL, 0x080fe20000410000ULL,
0x000000231a1a7220ULL, 0x080fe20000410000ULL, 0x0000002313137220ULL, 0x080fe20000410000ULL,
0x0000002312127220ULL, 0x080fe20000410000ULL, 0x000000231f1f7220ULL, 0x080fe20000410000ULL,
0x000000231e1e7220ULL, 0x080fe20000410000ULL, 0x0000002317177220ULL, 0x080fe20000410000ULL,
0x0000002316167220ULL, 0x000fe20000410000ULL, 0x0000002229297220ULL, 0x084fe20000410000ULL,
0x0000002228287220ULL, 0x080fe20000410000ULL, 0x0000002235357220ULL, 0x080fe20000410000ULL,
0x0000002234347220ULL, 0x080fe20000410000ULL, 0x000000222d2d7220ULL, 0x080fe20000410000ULL,
0x000000222c2c7220ULL, 0x080fe20000410000ULL, 0x0000002225257220ULL, 0x080fe20000410000ULL,
0x0000002224247220ULL, 0x080fe20000410000ULL, 0x0000002219197220ULL, 0x080fe20000410000ULL,
0x0000002218187220ULL, 0x080fe20000410000ULL, 0x0000002211117220ULL, 0x080fe20000410000ULL,
0x0000002210107220ULL, 0x080fe20000410000ULL, 0x000000221d1d7220ULL, 0x080fe20000410000ULL,
0x000000221c1c7220ULL, 0x080fe20000410000ULL, 0x0000002215157220ULL, 0x080fe20000410000ULL,
0x0000002214147220ULL, 0x000fe20000410000ULL, 0x0000000a5d5d3220ULL, 0x010fce0000410000ULL,
0x0000000000081947ULL, 0x000fea0003800000ULL, 0x00000075390075a7ULL, 0x000e64000802017fULL,
0x000000d400949947ULL, 0x002fea0003800000ULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x0000000247447824ULL, 0x000fe200078e00ffULL, 0x0000000700217812ULL, 0x000fe200078ec0ffULL,
0x000008000f3c7824ULL, 0x000fe200078e0202ULL, 0x00000002ff427819ULL, 0x000fe20000011600ULL,
0x0000000233337836ULL, 0x000fe20000000000ULL, 0x00000004445b7812ULL, 0x000fe200078ec0ffULL,
0x0000000c5d0c7221ULL, 0x000fe20000010000ULL, 0x00000008215e7812ULL, 0x000fe200078ef800ULL,
0x0000000842407836ULL, 0x000fe20000000000ULL, 0x0000005b005b7211ULL, 0x000fc400078fe0ffULL,
0x0000000aff32723eULL, 0x000fe400000010ffULL, 0x000000075b217812ULL, 0x000fe400078e785eULL,
0x0000541032717816ULL, 0x000fe40000000032ULL, 0x00009910306c7816ULL, 0x000fe200000000ffULL,
0x000000085e5a7824ULL, 0x000fe200078e0221ULL, 0x0000003358587212ULL, 0x000fe200078e3cffULL,
0x00001f4071467589ULL, 0x000fe200000e0000ULL, 0x000000ff6c00720cULL, 0x000fe20003f25270ULL,
0x000000105a207824ULL, 0x000fcc00078e023cULL, 0x009000002020783bULL, 0x000ea20000000200ULL,
0x00000100383d7824ULL, 0x042fe200078e00ffULL, 0x0000888038667816ULL, 0x040fe200000000ffULL,
0x0000010039307824ULL, 0x040fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe20000011438ULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001143dULL,
0x00001f42713d7589ULL, 0x000e6200000e0000ULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x0000888039327816ULL, 0x000fc400000000ffULL, 0x00000018ff617819ULL, 0x000fe20000011439ULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000006f006f7306ULL, 0x000ee20000202400ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff6c7819ULL, 0x000fca000001143aULL,
0x0000003200327306ULL, 0x000fe20000202400ULL, 0x0000004621219232ULL, 0x004fe40000200000ULL,
0x0000003d20209232ULL, 0x002fca0000200000ULL, 0x0000003000757306ULL, 0x0006620000202400ULL,
0x0000003d22229232ULL, 0x000fe40000200000ULL, 0x0000004623239232ULL, 0x000fca0000200000ULL,
0x0000006d006d7306ULL, 0x000fe20000202400ULL, 0x0000541066307816ULL, 0x008fe2000000006fULL,
0x000000085f667824ULL, 0x000fe200078e0258ULL, 0x000088803a6f7816ULL, 0x000fc600000000ffULL,
0x0000001066337824ULL, 0x000fe200078e0231ULL, 0x0000541032317816ULL, 0x002fe20000000075ULL,
0x0000006100617306ULL, 0x000fec0000202400ULL, 0x000000302014723cULL, 0x000fe20000041814ULL,
0x000000003330783bULL, 0x000e620000004200ULL, 0x0000003800387306ULL, 0x000eb00000202400ULL,
0x0000003900727306ULL, 0x000ee20000202400ULL, 0x0000541038387816ULL, 0x004fe2000000006dULL,
0x000001003a6d7824ULL, 0x000fcc00078e00ffULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x00000018ff717819ULL, 0x000fe4000001146dULL, 0x0000541072397816ULL, 0x008fe40000000061ULL,
0x000088803b617816ULL, 0x000fc600000000ffULL, 0x0000007100727306ULL, 0x0002a20000202400ULL,
0x00000018ff6d7819ULL, 0x000fe2000001143bULL, 0x00000038201c723cULL, 0x000fec000004181cULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x000001003b397824ULL, 0x040fe400078e00ffULL,
0x000000ffff387224ULL, 0x000fe200078e0061ULL, 0x0000888030717816ULL, 0x002fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fc40000011439ULL,
0x0000003800747306ULL, 0x0005e20000202400ULL, 0x00000018ff617819ULL, 0x000fe40000011430ULL,
0x00000018ff787819ULL, 0x000fe4000001143bULL, 0x00008880313b7816ULL, 0x000fc600000000ffULL,
0x0000003900397306ULL, 0x000e620000202400ULL, 0x000054106f387816ULL, 0x004fe20000000072ULL,
0x000100003a6f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fc80000011431ULL,
0x00000018ff6f7819ULL, 0x000fe2000001146fULL, 0x00000072003a7306ULL, 0x0005e20000202400ULL,
0x0000541074397816ULL, 0x002fce0000000039ULL, 0x0000006d006d7306ULL, 0x000fe20000202400ULL,
0x000000382010723cULL, 0x000fee0000041810ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x0000010030387824ULL, 0x040fe400078e00ffULL, 0x0001000030307824ULL, 0x000fca00078e00ffULL,
0x0000007800787306ULL, 0x000e620000202400ULL, 0x00000018ff727819ULL, 0x004fe20000011438ULL,
0x0000010031387824ULL, 0x040fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0001000031317824ULL, 0x000fc600078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011438ULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x00000018ff397819ULL, 0x000fe40000011431ULL,
0x0000541078317816ULL, 0x002fca000000006dULL, 0x0000007200727306ULL, 0x000e620000202400ULL,
0x00000018ff6d7819ULL, 0x000fce0000011433ULL, 0x0000003b003b7306ULL, 0x000ff00000202400ULL,
0x0000007400747306ULL, 0x000eb00000202400ULL, 0x0000003000387306ULL, 0x0007f00000202400ULL,
0x0000006100617306ULL, 0x000f220000202400ULL, 0x000054106f307816ULL, 0x008fc4000000006cULL,
0x000000805f6f7811ULL, 0x000fe400078e18ffULL, 0x00000018ff6c7819ULL, 0x000fc60000011432ULL,
0x0000003900397306ULL, 0x000ee20000202400ULL, 0x000000302018723cULL, 0x000fe20000041818ULL,
0x0000000165657824ULL, 0x100fe400078e026fULL, 0x0000000158587824ULL, 0x000fc800078e026fULL,
0x0000541071307816ULL, 0x002fe20000000072ULL, 0x0000010033727824ULL, 0x000fe200078e00ffULL,
0x000054103b317816ULL, 0x004fe20000000074ULL, 0x00001000733b7824ULL, 0x000fe200078e0208ULL,
0x0000888032717816ULL, 0x040fe200000000ffULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x00000018ff747819ULL, 0x000fe20000011472ULL, 0x0000b0003b5f7836ULL, 0x000fe40000000000ULL,
0x000000302024723cULL, 0x000fe20000041824ULL, 0x0001000032727824ULL, 0x000fc600078e00ffULL,
0x0000006d006d7306ULL, 0x000fe40000202400ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x0000541038307816ULL, 0x010fe20000000061ULL, 0x0000001065387824ULL, 0x000fe200078e025fULL,
0x0000541039317816ULL, 0x008fca000000003aULL, 0x000000003838783bULL, 0x000e640000004200ULL,
0x00000030202c723cULL, 0x000fe2000004182cULL, 0x0000007100307306ULL, 0x0005ec0000202400ULL,
0x0000010032317824ULL, 0x000fe400078e00ffULL, 0x0000007400327306ULL, 0x000fe20000202400ULL,
0x000000025b717836ULL, 0x004fc40000000000ULL, 0x00000018ff617819ULL, 0x000fe20000011431ULL,
0x00010000335b7824ULL, 0x040fe200078e00ffULL, 0x0000888033317816ULL, 0x000fe400000000ffULL,
0x0000000771757812ULL, 0x000fe200078e785eULL, 0x0000007200337306ULL, 0x000fe20000202400ULL,
0x00000018ff717819ULL, 0x000fc6000001145bULL, 0x000000085e5b7824ULL, 0x000fc800078e0275ULL,
0x0000006100617306ULL, 0x000ea20000202400ULL, 0x000000105b3c7824ULL, 0x000fce00078e023cULL,
0x0000003100317306ULL, 0x000ee20000202400ULL, 0x00000018ff757819ULL, 0x002fe40000011438ULL,
0x0000541030307816ULL, 0x004fca0000000061ULL, 0x00000071005e7306ULL, 0x0002a20000202400ULL,
0x00000018ff6f7819ULL, 0x000fe40000011439ULL, 0x0000541031317816ULL, 0x008fe20000000032ULL,
0x0000001058327824ULL, 0x000fc800078e025fULL, 0x0000007500617306ULL, 0x0007e20000202400ULL,
0x00000100385f7824ULL, 0x000fe400078e00ffULL, 0x0000010039717824ULL, 0x002fe200078e00ffULL,
0x000000302034723cULL, 0x000fe40000041834ULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x000000ffff757224ULL, 0x008fe200078e0077ULL, 0x0000541033307816ULL, 0x000fc4000000006cULL,
0x000054105e317816ULL, 0x004fe4000000006dULL, 0x00008880385e7816ULL, 0x040fe400000000ffULL,
0x0000005f005f7306ULL, 0x000fe20000202400ULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001143aULL, 0x000000302020723cULL, 0x000fe20000041828ULL,
0x009000003c28783bULL, 0x0002a40000000200ULL, 0x00000018ff387819ULL, 0x000fc40000011438ULL,
0x0000005e005e7306ULL, 0x000ee20000202400ULL, 0x000000003230783bULL, 0x000f220000004200ULL,
0x00000018ff6c7819ULL, 0x000fe4000001143bULL, 0x00008880393c7816ULL, 0x042fe200000000ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x0000007100717306ULL, 0x000fe40000202400ULL,
0x00000018ff397819ULL, 0x000fcc0000011439ULL, 0x0000003c00727306ULL, 0x0007f00000202400ULL,
0x0000003800387306ULL, 0x000e620000202400ULL, 0x000054105e3c7816ULL, 0x008fce000000005fULL,
0x0000006d006d7306ULL, 0x000fe20000202400ULL, 0x0000003d28289232ULL, 0x084fe40000200000ULL,
0x0000003d2a2a9232ULL, 0x000fe20000200000ULL, 0x0000541038387816ULL, 0x002fe20000000061ULL,
0x0000004629299232ULL, 0x080fe20000200000ULL, 0x00000018ff3d7819ULL, 0x010fe20000011430ULL,
0x000000462b2b9232ULL, 0x000fe40000200000ULL, 0x000001003a617824ULL, 0x000fe200078e00ffULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x00000018ff5e7819ULL, 0x000fc40000011431ULL,
0x00000018ff467819ULL, 0x000fe40000011432ULL, 0x00000018ff617819ULL, 0x000fc60000011461ULL,
0x0000003d005f7306ULL, 0x0003f00000202400ULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x00005410723d7816ULL, 0x002fce0000000071ULL, 0x0000003900727306ULL, 0x000e620000202400ULL,
0x0000003c2814723cULL, 0x000fee0000041814ULL, 0x000088803a3d7816ULL, 0x040fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe20000011433ULL,
0x0000004600467306ULL, 0x000fe60000202400ULL, 0x00000018ff787819ULL, 0x000fe2000001143aULL,
0x00000100303a7824ULL, 0x000fe200078e00ffULL, 0x0000541072397816ULL, 0x002fc4000000006fULL,
0x000088803b6f7816ULL, 0x000fe200000000ffULL, 0x0000003d003d7306ULL, 0x000fe20000202400ULL,
0x00000018ff3a7819ULL, 0x000fc6000001143aULL, 0x00000038281c723cULL, 0x000fe8000004181cULL,
0x0000006100727306ULL, 0x0002a60000202400ULL, 0x000001003b387824ULL, 0x000fe400078e00ffULL,
0x000000ffff397224ULL, 0x000fe200078e006fULL, 0x00008880316f7816ULL, 0x000fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000007800787306ULL, 0x000fe20000202400ULL, 0x0000888030617816ULL, 0x042fe200000000ffULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fc8000001143bULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000003900397306ULL, 0x000ff00000202400ULL,
0x0000003800747306ULL, 0x0004700000202400ULL, 0x0000003b003b7306ULL, 0x000ee20000202400ULL,
0x000054103d387816ULL, 0x004fc40000000072ULL, 0x0000541039397816ULL, 0x002fca0000000074ULL,
0x00000061003d7306ULL, 0x000fe40000202400ULL, 0x000000382810723cULL, 0x000fec0000041810ULL,
0x0000003000727306ULL, 0x0003e20000202400ULL, 0x0000010031387824ULL, 0x040fe400078e00ffULL,
0x0001000031317824ULL, 0x000fca00078e00ffULL, 0x0000003a003a7306ULL, 0x000fe20000202400ULL,
0x0000541078307816ULL, 0x002fe2000000006dULL, 0x0000010032397824ULL, 0x040fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011438ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000888032387816ULL, 0x040fe200000000ffULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0001000032327824ULL, 0x000fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000003100617306ULL, 0x0007f00000202400ULL,
0x0000007400747306ULL, 0x000e620000202400ULL, 0x000054103b317816ULL, 0x008fc4000000006cULL,
0x00008880336c7816ULL, 0x000fca00000000ffULL, 0x000000302818723cULL, 0x000fe20000041818ULL,
0x0000003800387306ULL, 0x000fec0000202400ULL, 0x0000010033307824ULL, 0x000fe200078e00ffULL,
0x000054106f317816ULL, 0x002fe20000000074ULL, 0x0000003900397306ULL, 0x000e620000202400ULL,
0x0001000033337824ULL, 0x000fc400078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x000000ffff747224ULL, 0x000fe400078e0076ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x00000030006d7306ULL, 0x0005f00000202400ULL, 0x0000006c006c7306ULL, 0x000ee20000202400ULL,
0x000054103d307816ULL, 0x004fce000000003aULL, 0x000000302824723cULL, 0x000fe20000041824ULL,
0x00000032003b7306ULL, 0x000eac0000202400ULL, 0x0000541072307816ULL, 0x000fe4000000005fULL,
0x0000541061317816ULL, 0x000fe2000000005eULL, 0x0000003c003c7306ULL, 0x000fec0000202400ULL,
0x00000030282c723cULL, 0x000fe4000004182cULL, 0x0000003300337306ULL, 0x000f2a0000202400ULL,
0x0000541038307816ULL, 0x002fc40000000039ULL, 0x000054106c317816ULL, 0x008fe2000000006dULL,
0x000000ffff6c7224ULL, 0x000fe200078e0073ULL, 0x0000000173737812ULL, 0x000fca00078e0cffULL,
0x000000302834723cULL, 0x000fee0000041834ULL, 0xfffffff844317812ULL, 0x000fe200078ec0ffULL,
0x0000000843447824ULL, 0x000fe200078e0202ULL, 0x000054103b307816ULL, 0x004fc60000000046ULL,
0x0000000102467824ULL, 0x000fe200078e0231ULL, 0x0000541033317816ULL, 0x010fce000000003cULL,
0x000000302828723cULL, 0x000fe20000041820ULL, 0x00f6c80d443079a7ULL, 0x00026c000850003fULL,
0x0000004056207836ULL, 0x000fe20000000000ULL, 0x00f6880d46ff79a7ULL, 0x0003e8000850003fULL,
0x0000000920007c0cULL, 0x000fda000bf26070ULL, 0x00000048005c1947ULL, 0x002fea0003800000ULL,
0x00000031520075a7ULL, 0x000e62000802007fULL, 0x000000035c207812ULL, 0x000fc800078ec0ffULL,
0x000000032000780cULL, 0x000fe20003f45270ULL, 0x000000806b207836ULL, 0x000fc60000000000ULL,
0x0000000104217807ULL, 0x000fe40005000000ULL, 0x0000000920237c48ULL, 0x000fc6000ffe0000ULL,
0x000000015c5c7824ULL, 0x000fe200078e0221ULL, 0x0000000000081947ULL, 0x002fec0003800000ULL,
0x00f6c831540075a7ULL, 0x000e64000802017fULL, 0x000000c400509947ULL, 0x002fea0003800000ULL,
0x000000035c217812ULL, 0x000fe200078ec0ffULL, 0x0000000123237824ULL, 0x000fe200078e0a20ULL,
0x0000002007207812ULL, 0x000fe200078ef820ULL, 0x0000000c05057c24ULL, 0x020fe2000f8e02ffULL,
0x000000032100780cULL, 0x000fe20003f25270ULL, 0x000000086c5f7824ULL, 0x000fe400078e00ffULL,
0x00000040053b7824ULL, 0x000fe200078e00ffULL, 0x0000000104057807ULL, 0x000fe20004800000ULL,
0x0000000157217824ULL, 0x100fe200078e0220ULL, 0x000000085f5e7812ULL, 0x000fe200078ec0ffULL,
0x0000000155227824ULL, 0x000fc400078e0220ULL, 0x0000000153307824ULL, 0x100fe200078e0220ULL,
0x000000213b397210ULL, 0x000fe20007f3e0ffULL, 0x0000000151207824ULL, 0x000fe200078e0220ULL,
0x000000223b227210ULL, 0x000fe20007fbe0ffULL, 0x000000015c707824ULL, 0x000fe200078e0205ULL,
0x000000303b217210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff307224ULL, 0x000fe200008e06ffULL,
0x000000203b3b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff337224ULL, 0x000fe200028e06ffULL,
0x000000085e207812ULL, 0x000fe200078e3cffULL, 0x000010006c3a7824ULL, 0x000fe200078e00ffULL,
0x0000000470007c0cULL, 0x000fe2000bf26070ULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x0000000e22727c11ULL, 0x000fe2000f8a38ffULL, 0x000000ffff327224ULL, 0x000fe200010e06ffULL,
0x00000000200872caULL, 0x000fc400000e0000ULL, 0x0000002023207807ULL, 0x000fe40000000000ULL,
0x0000000f22337c11ULL, 0x000fe4000a8f3c33ULL, 0x0000002059227248ULL, 0x000fe40007fe0000ULL,
0x0000000e39747c11ULL, 0x000fe4000f8838ffULL, 0x0000000e213c7c11ULL, 0x000fe2000f8438ffULL,
0x0000000122237824ULL, 0x000fe200078e0a59ULL, 0x0000000f39397c11ULL, 0x000fc4000a0f3c30ULL,
0x00008c00ff309b82ULL, 0x000e620000000a00ULL, 0x0000000e3b207c11ULL, 0x000fe4000f8638ffULL,
0x000010003a3d7812ULL, 0x000fe400078ec0ffULL, 0x0000000f21217c11ULL, 0x000fe400090f3c38ULL,
0x0000000f3b3b7c11ULL, 0x000fe400098f3c32ULL, 0x000000234c00720cULL, 0x080fe40003f46070ULL,
0x000000234a00720cULL, 0x000fc40003f66070ULL, 0x0000b00008717810ULL, 0x000fe40007ffe03dULL,
0x0000004b74387210ULL, 0x000fe40007f9e0ffULL, 0x0000004b72327210ULL, 0x000fe20007fbe0ffULL,
0x0000001064647824ULL, 0x000fe200078e0271ULL, 0x000000005e0672caULL, 0x000fe200000e0000ULL,
0x000000ffff397224ULL, 0x000fe200020e0639ULL, 0x000000234800720cULL, 0x080fe20003f86070ULL,
0x000000ffff337224ULL, 0x000fe200028e0633ULL, 0x000000234900720cULL, 0x000fe20003fa6070ULL,
0x0000001063637824ULL, 0x100fe200078e0271ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038647faeULL, 0x0005e2000d101c4aULL, 0x0000004b3c227210ULL, 0x000fe20007f5e0ffULL,
0x0000001062627824ULL, 0x000fe200078e0271ULL, 0x000000050b059210ULL, 0x000fe20007ffe05cULL,
0x0000000032637faeULL, 0x0007e2000d901c4aULL, 0x0000004b20207210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff237224ULL, 0x000fe200010e0621ULL, 0x0000000607067290ULL, 0x000fe2000fffe03fULL,
0x0000000405309825ULL, 0x002fc600078e0030ULL, 0x0000000022627faeULL, 0x0005e2000e901c4aULL,
0x000000ffff217224ULL, 0x000fe400018e063bULL, 0x0000001060607824ULL, 0x000fe400078e0271ULL,
0xffffffffff057424ULL, 0x000fc600078e00ffULL, 0x0000000020607faeULL, 0x0005e2000e101c4aULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000a30059981ULL, 0x000562000c1e1900ULL,
0x0000000807077290ULL, 0x000fc6000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a46ULL,
0x0000000000007918ULL, 0x008fd00000000000ULL, 0x0000000dff7479a7ULL, 0x0002620008500006ULL,
0x0000002047617824ULL, 0x000fca00078e00ffULL, 0xffffff8061617812ULL, 0x000fe200078ec0ffULL,
0x00000077ff0075a7ULL, 0x0002660008020047ULL, 0x0000008002227810ULL, 0x004fc80007ffe061ULL,
0x000000224e227210ULL, 0x000fe20007ffe04bULL, 0x00f6280d502079a7ULL, 0x000ea4000850003fULL,
0x00f62821500075a7ULL, 0x004ea4000804017fULL, 0x000000c00020a947ULL, 0x006fea0003800000ULL,
0x00f0000022207984ULL, 0x000e620000000800ULL, 0x000010003a3a7812ULL, 0x000fe200078e0cffULL,
0x00000001ff307424ULL, 0x000fe400078e00ffULL, 0x00f2000022737984ULL, 0x0004a20000000800ULL,
0x000000023a337210ULL, 0x000fca0007ffe03fULL, 0x0000b00033337836ULL, 0x000fc80000000000ULL,
0x000000103e5d7824ULL, 0x000fe200078e0233ULL, 0x000000092000720bULL, 0x002fda0003f5d000ULL,
0x0000000000217806ULL, 0x000fc800010e0100ULL, 0x0000ffff21317812ULL, 0x000fda000784c0ffULL,
0x0000000000d8a947ULL, 0x004fea0003800000ULL, 0x000000092000720bULL, 0x000fe40003f54000ULL,
0x0000002009217209ULL, 0x000fca0007810000ULL, 0x8000002109227221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b22237820ULL, 0x000fe20000410000ULL, 0x000000010f227836ULL, 0x000fe20000000000ULL,
0x0000000000097806ULL, 0x000fc800010e0100ULL, 0x0000ffff09307812ULL, 0x000fe200078e3cffULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x000000472200720cULL, 0x000fe40003f45270ULL,
0x0000003031ff7212ULL, 0x000fd6000786c0ffULL, 0x000000804730a824ULL, 0x000fe200078e0202ULL,
0x00001f4223097589ULL, 0x002e6200000e0000ULL, 0x8000002120223221ULL, 0x000fe20000010000ULL,
0x000000230c0c7220ULL, 0x000fe40000410000ULL, 0x00001f4023207589ULL, 0x000ea200000e0000ULL,
0x3fb8aa3b22223820ULL, 0x000fe20000410000ULL, 0x000000304e30a210ULL, 0x000fc60007ffe04bULL,
0x00000022000a3308ULL, 0x000ee40000000800ULL, 0x00f400213000a388ULL, 0x0009e40000000800ULL,
0x00000001ff307807ULL, 0x010fe20001800000ULL, 0x0000000914147220ULL, 0x082fe20000410000ULL,
0x0000000915157220ULL, 0x080fe20000410000ULL, 0x000000091c1c7220ULL, 0x080fe20000410000ULL,
0x000000091d1d7220ULL, 0x080fe20000410000ULL, 0x0000000910107220ULL, 0x080fe20000410000ULL,
0x0000000911117220ULL, 0x080fe20000410000ULL, 0x0000000918187220ULL, 0x080fe20000410000ULL,
0x0000000919197220ULL, 0x080fe20000410000ULL, 0x0000000924247220ULL, 0x080fe20000410000ULL,
0x0000000925257220ULL, 0x080fe20000410000ULL, 0x000000092c2c7220ULL, 0x080fe20000410000ULL,
0x000000092d2d7220ULL, 0x080fe20000410000ULL, 0x0000000934347220ULL, 0x080fe20000410000ULL,
0x0000000935357220ULL, 0x080fe20000410000ULL, 0x0000000928287220ULL, 0x080fe20000410000ULL,
0x0000000929297220ULL, 0x000fe20000410000ULL, 0x0000002016167220ULL, 0x084fe20000410000ULL,
0x0000002017177220ULL, 0x080fe20000410000ULL, 0x000000201e1e7220ULL, 0x080fe20000410000ULL,
0x000000201f1f7220ULL, 0x080fe20000410000ULL, 0x0000002012127220ULL, 0x080fe20000410000ULL,
0x0000002013137220ULL, 0x080fe20000410000ULL, 0x000000201a1a7220ULL, 0x080fe20000410000ULL,
0x000000201b1b7220ULL, 0x080fe20000410000ULL, 0x0000002026267220ULL, 0x080fe20000410000ULL,
0x0000002027277220ULL, 0x080fe20000410000ULL, 0x000000202e2e7220ULL, 0x080fe20000410000ULL,
0x000000202f2f7220ULL, 0x080fe20000410000ULL, 0x0000002036367220ULL, 0x080fe20000410000ULL,
0x0000002037377220ULL, 0x080fe20000410000ULL, 0x000000202a2a7220ULL, 0x080fe20000410000ULL,
0x000000202b2b7220ULL, 0x000fe20000410000ULL, 0x000000ffff097224ULL, 0x000fc400078e0021ULL,
0x000000730a733220ULL, 0x008fce0000410000ULL, 0x0000000000141947ULL, 0x000fea0003800000ULL,
0x000000085f207812ULL, 0x000fe200078e0cffULL, 0x0000001043217824ULL, 0x000fc800078e0202ULL,
0x0000000120217824ULL, 0x000fc800078e0221ULL, 0x00f6a877210075a7ULL, 0x000e64000802017fULL,
0x000000bc001c9947ULL, 0x002fea0003800000ULL, 0x000000005d38783bULL, 0x000e620000004200ULL,
0x0000020047207824ULL, 0x000fe200078e00ffULL, 0x0000000aff3c723eULL, 0x000fe200000010ffULL,
0x0000000c730c7221ULL, 0x000fe20000010000ULL, 0x0000991030767816ULL, 0x000fe400000000ffULL,
0xfffff80020217812ULL, 0x000fe400078ec0ffULL, 0x000054103c777816ULL, 0x000fe4000000003cULL,
0x000000ff7600720cULL, 0x000fe20003f25270ULL, 0x0000000102727824ULL, 0x000fc400078e0221ULL,
0x00001f42776f7589ULL, 0x000fe400000e0000ULL, 0x000000105a5a7824ULL, 0x100fe400078e0272ULL,
0x00001f40773c7589ULL, 0x0005e200000e0000ULL, 0x000000105b5b7824ULL, 0x000fc600078e0272ULL,
0x009800005a20783bULL, 0x000ee20000000200ULL, 0x0000010038327824ULL, 0x042fe200078e00ffULL,
0x0000888038317816ULL, 0x000fe200000000ffULL, 0x0000010039307824ULL, 0x040fe200078e00ffULL,
0x00008880395c7816ULL, 0x000fe200000000ffULL, 0x000001003b787824ULL, 0x000fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000003100317306ULL, 0x000fe20000202400ULL, 0x00000018ff767819ULL, 0x000fc4000001143aULL,
0x000088803a7a7816ULL, 0x000fe400000000ffULL, 0x000088803b777816ULL, 0x004fe400000000ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000003200327306ULL, 0x000e620000202400ULL,
0x0000006f20209232ULL, 0x088fe40000200000ULL, 0x0000006f22229232ULL, 0x000fca0000200000ULL,
0x0000005c005c7306ULL, 0x000fe20000202400ULL, 0x0000003c21219232ULL, 0x080fe40000200000ULL,
0x0000003c23239232ULL, 0x000fca0000200000ULL, 0x00000030006d7306ULL, 0x0002b00000202400ULL,
0x0000007a007a7306ULL, 0x000fe20000202400ULL, 0x0000541031307816ULL, 0x002fe40000000032ULL,
0x00000018ff327819ULL, 0x000fe20000011438ULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x000054105c317816ULL, 0x004fe2000000006dULL, 0x00000010665c7824ULL, 0x000fc600078e0233ULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000003200327306ULL, 0x000fe20000202400ULL,
0x00000018ff6d7819ULL, 0x000fe2000001143bULL, 0x000000302014723cULL, 0x000fec0000041814ULL,
0x0000003800317306ULL, 0x000e620000202400ULL, 0x00000018ff307819ULL, 0x000fe20000011439ULL,
0x0001000039397824ULL, 0x000fcc00078e00ffULL, 0x0000007700777306ULL, 0x000fe20000202400ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000541031387816ULL, 0x002fca0000000032ULL,
0x0000003000307306ULL, 0x000fe20000202400ULL, 0x000001003a317824ULL, 0x040fe400078e00ffULL,
0x000100003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff797819ULL, 0x000fe40000011431ULL,
0x0000003900397306ULL, 0x000e620000202400ULL, 0x00000018ff7b7819ULL, 0x000fe2000001143aULL,
0x000100003b3a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001143aULL,
0x0000007900797306ULL, 0x000ea20000202400ULL, 0x0000541039397816ULL, 0x002fce0000000030ULL,
0x0000007800787306ULL, 0x000e620000202400ULL, 0x000000005c30783bULL, 0x000ee20000004200ULL,
0x00000038201c723cULL, 0x000fec000004181cULL, 0x0000007600767306ULL, 0x000fe20000202400ULL,
0x000054107a387816ULL, 0x004fe40000000079ULL, 0x0000541077397816ULL, 0x002fca0000000078ULL,
0x0000006d006d7306ULL, 0x000fe40000202400ULL, 0x000000382010723cULL, 0x000fec0000041810ULL,
0x0000007b003b7306ULL, 0x000e700000202400ULL, 0x0000007c003a7306ULL, 0x000ea20000202400ULL,
0x000054103b387816ULL, 0x002fe20000000076ULL, 0x0000010031777824ULL, 0x008fc400078e00ffULL,
0x00000100303b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011477ULL,
0x000054103a397816ULL, 0x004fe4000000006dULL, 0x00008880316d7816ULL, 0x000fe400000000ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000007800787306ULL, 0x000fe20000202400ULL,
0x00000018ff3a7819ULL, 0x000fe20000011430ULL, 0x000000382018723cULL, 0x000fe20000041818ULL,
0x00000018ff777819ULL, 0x000fca0000011432ULL, 0x0000003b00767306ULL, 0x000fe20000202400ULL,
0x0000888030397816ULL, 0x040fe200000000ffULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011431ULL, 0x0001000031317824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000003900397306ULL, 0x000e620000202400ULL,
0x00000018ff317819ULL, 0x000fce0000011431ULL, 0x0000006d006d7306ULL, 0x000eb00000202400ULL,
0x0000003a003a7306ULL, 0x000ff00000202400ULL, 0x0000003800387306ULL, 0x000ff00000202400ULL,
0x0000003000797306ULL, 0x0002f00000202400ULL, 0x00000031003b7306ULL, 0x0005220000202400ULL,
0x0000541039307816ULL, 0x002fc40000000076ULL, 0x00000018ff767819ULL, 0x000fca0000011433ULL,
0x0000007700777306ULL, 0x000fe20000202400ULL, 0x000054106d317816ULL, 0x004fe20000000078ULL,
0x0000010033787824ULL, 0x000fe400078e00ffULL, 0x00000010656d7824ULL, 0x100fe400078e026eULL,
0x00000010586e7824ULL, 0x000fe200078e026eULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x000000302024723cULL, 0x000fe20000041824ULL, 0x0000007600767306ULL, 0x000fec0000202400ULL,
0x0000541079307816ULL, 0x008fc4000000003aULL, 0x000054103b317816ULL, 0x010fe20000000038ULL,
0x0000007800787306ULL, 0x000fe20000202400ULL, 0x0000888032387816ULL, 0x000fca00000000ffULL,
0x00000030202c723cULL, 0x000fee000004182cULL, 0x0000010032317824ULL, 0x040fe400078e00ffULL,
0x000000ffff307224ULL, 0x000fe400078e0038ULL, 0x0001000032327824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011431ULL, 0x000000006d38783bULL, 0x000e620000004200ULL,
0x0000888033317816ULL, 0x040fe200000000ffULL, 0x0001000033337824ULL, 0x000fe200078e00ffULL,
0x0000003000307306ULL, 0x000fe20000202400ULL, 0x00000018ff7a7819ULL, 0x000fc60000011432ULL,
0x00000018ff337819ULL, 0x000fc80000011433ULL, 0x0000007900797306ULL, 0x000eb00000202400ULL,
0x0000003100317306ULL, 0x000ee20000202400ULL, 0x0000541030307816ULL, 0x004fce0000000079ULL,
0x0000007a00327306ULL, 0x000ea20000202400ULL, 0x0000541031317816ULL, 0x008fce0000000078ULL,
0x0000003300337306ULL, 0x000ee20000202400ULL, 0x00000018ff787819ULL, 0x002fe20000011439ULL,
0x000000302034723cULL, 0x000fee0000041834ULL, 0x0000541032307816ULL, 0x004fe40000000077ULL,
0x0000541033317816ULL, 0x008fe20000000076ULL, 0x0000010039767824ULL, 0x000fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fe20000011438ULL, 0x0000007800337306ULL, 0x0003e80000202400ULL,
0x000000302020723cULL, 0x000fe20000041828ULL, 0x009800005b28783bULL, 0x000ea60000000200ULL,
0x0000003200327306ULL, 0x000fe20000202400ULL, 0x00000018ff787819ULL, 0x002fc40000011476ULL,
0x0000010038317824ULL, 0x040fe200078e00ffULL, 0x0000888038307816ULL, 0x040fe200000000ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011431ULL,
0x0000007800787306ULL, 0x000fe20000202400ULL, 0x0000888039317816ULL, 0x040fe400000000ffULL,
0x00000018ff767819ULL, 0x000fe20000011438ULL, 0x0001000039387824ULL, 0x000fc800078e00ffULL,
0x0000003000307306ULL, 0x000fe20000202400ULL, 0x00000018ff387819ULL, 0x000fce0000011438ULL,
0x0000007200777306ULL, 0x0002f00000202400ULL, 0x0000003100317306ULL, 0x000f220000202400ULL,
0x00000018ff727819ULL, 0x002fe2000001143bULL, 0x0000006f28289232ULL, 0x004fc40000200000ULL,
0x0000006f2a2a9232ULL, 0x000fe20000200000ULL, 0x0000541030307816ULL, 0x008fc60000000077ULL,
0x0000007600397306ULL, 0x0002a20000202400ULL, 0x0000003c29299232ULL, 0x080fe40000200000ULL,
0x000001003b777824ULL, 0x000fe400078e00ffULL, 0x0000003c2b2b9232ULL, 0x000fe20000200000ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143aULL, 0x0000541031317816ULL, 0x010fe20000000078ULL,
0x0000003800387306ULL, 0x000ee20000202400ULL, 0x000088803a767816ULL, 0x002fc400000000ffULL,
0x00000018ff787819ULL, 0x000fc60000011477ULL, 0x000000302814723cULL, 0x000fe40000041814ULL,
0x0000003c003c7306ULL, 0x000fea0000202400ULL, 0x0000541039307816ULL, 0x004fe20000000032ULL,
0x000001003a327824ULL, 0x000fe200078e00ffULL, 0x0000541038317816ULL, 0x008fe20000000033ULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000088803b397816ULL, 0x000fe200000000ffULL,
0x0000007600387306ULL, 0x0003e20000202400ULL, 0x00000018ff6f7819ULL, 0x000fc40000011432ULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x00000030281c723cULL, 0x000fe2000004181cULL,
0x000000006e30783bULL, 0x000ea60000004200ULL, 0x0000006f006f7306ULL, 0x000ee20000202400ULL,
0x000100003b767824ULL, 0x002fca00078e00ffULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x0000003900397306ULL, 0x000fe20000202400ULL, 0x0000541038387816ULL, 0x008fce000000006fULL,
0x0000007800787306ULL, 0x000e700000202400ULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x0000541039397816ULL, 0x002fce0000000078ULL, 0x0000003a003b7306ULL, 0x0002e20000202400ULL,
0x00000018ff6f7819ULL, 0x004fe20000011430ULL, 0x000000382810723cULL, 0x000fe20000041810ULL,
0x00008880307c7816ULL, 0x000fca00000000ffULL, 0x0000007600777306ULL, 0x000ea20000202400ULL,
0x00008880317a7816ULL, 0x000fe400000000ffULL, 0x0000888032797816ULL, 0x000fe400000000ffULL,
0x00000018ff3a7819ULL, 0x002fe40000011432ULL, 0x000054103b387816ULL, 0x008fe2000000003cULL,
0x00000100313c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe20000011431ULL,
0x0001000031317824ULL, 0x000fe200078e00ffULL, 0x0000007c007c7306ULL, 0x000fe40000202400ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x0000541077397816ULL, 0x004fe40000000072ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000007a007a7306ULL, 0x000fe60000202400ULL,
0x000000382818723cULL, 0x000fea0000041818ULL, 0x0000003c007d7306ULL, 0x0002a40000202400ULL,
0x0000010030397824ULL, 0x040fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011433ULL,
0x0001000030307824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00008880333c7816ULL, 0x002fca00000000ffULL, 0x00000039007b7306ULL, 0x0002f00000202400ULL,
0x0000003000787306ULL, 0x0008a20000202400ULL, 0x0000010032397824ULL, 0x042fe400078e00ffULL,
0x0001000032327824ULL, 0x000fc600078e00ffULL, 0x00000018ff727819ULL, 0x000fe40000011439ULL,
0x0000003b003b7306ULL, 0x000fe20000202400ULL, 0x0000010033307824ULL, 0x050fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0001000033337824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003100767306ULL, 0x0004620000202400ULL,
0x00000018ff337819ULL, 0x000fce0000011433ULL, 0x0000003000777306ULL, 0x0007e20000202400ULL,
0x000054107a317816ULL, 0x004fce000000007dULL, 0x0000007900797306ULL, 0x000fe20000202400ULL,
0x000054107c307816ULL, 0x008fce000000007bULL, 0x0000007200727306ULL, 0x000ea20000202400ULL,
0x000000302824723cULL, 0x000fee0000041824ULL, 0x0000003c003c7306ULL, 0x000ee20000202400ULL,
0x0000541078307816ULL, 0x000fe4000000006fULL, 0x0000541076317816ULL, 0x002fc4000000003bULL,
0x000000016c6f7812ULL, 0x000fc600078ec0ffULL, 0x0000003a003a7306ULL, 0x000fe40000202400ULL,
0x00000030282c723cULL, 0x000fe2000004182cULL, 0x000000ffff737224ULL, 0x000fca00078e006fULL,
0x0000003800387306ULL, 0x000fe20000202400ULL, 0x0000541079307816ULL, 0x004fe40000000072ULL,
0x000054103c317816ULL, 0x008fca0000000077ULL, 0x0000003200397306ULL, 0x000e640000202400ULL,
0x000000302834723cULL, 0x000fec0000041834ULL, 0x0000003300337306ULL, 0x000ea20000202400ULL,
0x0000541039307816ULL, 0x002fe4000000003aULL, 0x0000541033317816ULL, 0x004fce0000000038ULL,
0x000000302828723cULL, 0x000fe20000041820ULL, 0x00f6c80d443079a7ULL, 0x00026c000850003fULL,
0x0000008056207836ULL, 0x000fe20000000000ULL, 0x00f6900d46ff79a7ULL, 0x0003e8000850003fULL,
0x0000000920007c0cULL, 0x000fda000bf26070ULL, 0x0000002c00fc1947ULL, 0x002fea0003800000ULL,
0x00000031520075a7ULL, 0x000e62000802007fULL, 0x000000c06b207836ULL, 0x000fe20000000000ULL,
0x0000000370227812ULL, 0x000fe200078ec0ffULL, 0x0000000c05237c24ULL, 0x020fc6000f8e02ffULL,
0x0000000920217c48ULL, 0x000fe4000ffe0000ULL, 0x000000032200780cULL, 0x000fc60003f45270ULL,
0x0000000121227824ULL, 0x000fe200078e0a20ULL, 0x0000002007207812ULL, 0x000fe400078ef820ULL,
0x0000000104057807ULL, 0x000fe20005000000ULL, 0x0000000000101947ULL, 0x002fec0003800000ULL,
0x0000000447217811ULL, 0x000fca00078ff8ffULL, 0x0000000821217824ULL, 0x000fc800078e0202ULL,
0x00f6a831210075a7ULL, 0x000e64000802017fULL, 0x000000ac00289947ULL, 0x002fea0003800000ULL,
0x00000001706b7824ULL, 0x000fe400078e0205ULL, 0x00000040233a7824ULL, 0x000fe400078e00ffULL,
0x0000000157217824ULL, 0x100fe200078e0220ULL, 0x000000046b007c0cULL, 0x000fe2000bf26070ULL,
0x0000000155237824ULL, 0x100fe400078e0220ULL, 0x0000000153307824ULL, 0x100fe200078e0220ULL,
0x000000213a327210ULL, 0x000fe20007f5e0ffULL, 0x0000000151317824ULL, 0x000fe200078e0220ULL,
0x000000233a727210ULL, 0x000fc40007f7e0ffULL, 0x0000002022207807ULL, 0x000fe20000000000ULL,
0x000000ffff337224ULL, 0x000fe200010e06ffULL, 0x000000303a3b7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff217224ULL, 0x000fe200018e06ffULL, 0x0000000e32387c11ULL, 0x000fe4000f8038ffULL,
0x0000002059307248ULL, 0x000fe20007fe0000ULL, 0x000000ffff3c7224ULL, 0x000fe200020e06ffULL,
0x0000000e72227c11ULL, 0x000fe4000f8438ffULL, 0x000000313a237210ULL, 0x000fc40007f7e0ffULL,
0x0000000f32317c11ULL, 0x000fe200080f3c33ULL, 0x0000000130337824ULL, 0x000fe200078e0a59ULL,
0x0000000f72727c11ULL, 0x000fe200090f3c21ULL, 0x000000ffff327224ULL, 0x000fe200018e06ffULL,
0x00008c00ff209b82ULL, 0x000e620000000a00ULL, 0x0000000e3b3a7c11ULL, 0x000fe4000f8838ffULL,
0x000000334c00720cULL, 0x080fe40003f06070ULL, 0x000000334a00720cULL, 0x000fe40003f46070ULL,
0x0000004b38307210ULL, 0x000fc40007f7e0ffULL, 0x0000000f3b3b7c11ULL, 0x000fe4000a0f3c3cULL,
0x0000000e23387c11ULL, 0x040fe2000f8a38ffULL, 0x000000ffff317224ULL, 0x000fe200018e0631ULL,
0x0000004b22227210ULL, 0x000fe40007f9e0ffULL, 0x0000000f23397c11ULL, 0x000fe4000a8f3c32ULL,
0x000000334900720cULL, 0x080fe20003f66070ULL, 0x000000ffff237224ULL, 0x000fe200020e0672ULL,
0x000000334800720cULL, 0x000fe20003f86070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000306a7faeULL, 0x0005e2000c101c4aULL, 0x0000004b3a327210ULL, 0x000fc40007f1e0ffULL,
0x000000050b059210ULL, 0x000fe20007ffe070ULL, 0x0000000022697faeULL, 0x0007e2000d101c4aULL,
0x0000004b38387210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e063bULL,
0x000000085e3a7812ULL, 0x000fe200078e3cffULL, 0x0000000405209825ULL, 0x002fc600078e0020ULL,
0x0000000032687faeULL, 0x0005e2000d901c4aULL, 0x000000ffff397224ULL, 0x000fe400010e0639ULL,
0xffffffffff057424ULL, 0x000fc600078e00ffULL, 0x0000000038677faeULL, 0x0005e2000e101c4aULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000a20059981ULL, 0x000562000c1e1900ULL,
0x000000014d3a7824ULL, 0x000fc600078e023aULL, 0x00000000ff0079b0ULL, 0x000fe20008000a47ULL,
0x0000000000007918ULL, 0x008fc60000000000ULL, 0x0000000d3a7679a7ULL, 0x000262000850003fULL,
0x0000010002227810ULL, 0x000fc80007ffe061ULL, 0x000000224e227210ULL, 0x000fe20007ffe04bULL,
0x00000075ff0075a7ULL, 0x0002620008000046ULL, 0x00f6480d502079a7ULL, 0x004ea4000850003fULL,
0x00f64821500075a7ULL, 0x004ea4000802017fULL, 0x000000a800489947ULL, 0x006fea0003800000ULL,
0x00f0000022307984ULL, 0x000e620000000800ULL, 0x000000023d217210ULL, 0x000fc60007ffe03fULL,
0x00f2000022677984ULL, 0x0004a40000000800ULL, 0x0000b00021217836ULL, 0x000fc80000000000ULL,
0x000000103e3e7824ULL, 0x000fe200078e0221ULL, 0x000000093000720bULL, 0x002fda0003f3d000ULL,
0x0000000000207806ULL, 0x000fc800008e0100ULL, 0x0000ffff20317812ULL, 0x000fe2000782c0ffULL,
0x00000001ff207424ULL, 0x000fd800078e00ffULL, 0x0000000000dc9947ULL, 0x004fea0003800000ULL,
0x0000003009227209ULL, 0x000fe40007810000ULL, 0x000000093000720bULL, 0x000fc60003f34000ULL,
0x8000002209207221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b20237820ULL, 0x000fe20000410000ULL,
0x000000020f207836ULL, 0x000fca0000000000ULL, 0x0000000000097806ULL, 0x000fe200008e0100ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x000000472000720cULL, 0x000fe40003f25270ULL,
0x0000ffff09327812ULL, 0x000fc800078e3cffULL, 0x0000003231ff7212ULL, 0x000fce000784c0ffULL,
0x0000008047209824ULL, 0x000fe200078e0202ULL, 0x00001f4223097589ULL, 0x002e6200000e0000ULL,
0x000000230c0c7220ULL, 0x000fc60000410000ULL, 0x000000204e319210ULL, 0x000fe20007ffe04bULL,
0x8000002230302221ULL, 0x100fe20000010000ULL, 0x00001f4023207589ULL, 0x0004e600000e0000ULL,
0x3fb8aa3b30302820ULL, 0x000fe20000410000ULL, 0x00f4002231009388ULL, 0x0009e60000000800ULL,
0x00000030000a2308ULL, 0x000ee20000000800ULL, 0x00000001ff237807ULL, 0x004fe20001000000ULL,
0x0000000914147220ULL, 0x082fe20000410000ULL, 0x0000000915157220ULL, 0x080fe20000410000ULL,
0x000000091c1c7220ULL, 0x080fe20000410000ULL, 0x000000091d1d7220ULL, 0x080fe20000410000ULL,
0x0000000910107220ULL, 0x080fe20000410000ULL, 0x0000000911117220ULL, 0x080fe20000410000ULL,
0x0000000918187220ULL, 0x080fe20000410000ULL, 0x0000000919197220ULL, 0x080fe20000410000ULL,
0x0000000924247220ULL, 0x080fe20000410000ULL, 0x0000000925257220ULL, 0x080fe20000410000ULL,
0x000000092c2c7220ULL, 0x080fe20000410000ULL, 0x000000092d2d7220ULL, 0x080fe20000410000ULL,
0x0000000934347220ULL, 0x080fe20000410000ULL, 0x0000000935357220ULL, 0x080fe20000410000ULL,
0x0000000928287220ULL, 0x080fe20000410000ULL, 0x0000000929297220ULL, 0x000fe20000410000ULL,
0x0000002016167220ULL, 0x088fe20000410000ULL, 0x0000002017177220ULL, 0x080fe20000410000ULL,
0x000000201e1e7220ULL, 0x080fe20000410000ULL, 0x000000201f1f7220ULL, 0x080fe20000410000ULL,
0x0000002012127220ULL, 0x080fe20000410000ULL, 0x0000002013137220ULL, 0x080fe20000410000ULL,
0x000000201a1a7220ULL, 0x080fe20000410000ULL, 0x000000201b1b7220ULL, 0x080fe20000410000ULL,
0x0000002026267220ULL, 0x080fe20000410000ULL, 0x0000002027277220ULL, 0x080fe20000410000ULL,
0x000000202e2e7220ULL, 0x080fe20000410000ULL, 0x000000202f2f7220ULL, 0x080fe20000410000ULL,
0x0000002036367220ULL, 0x080fe20000410000ULL, 0x0000002037377220ULL, 0x080fe20000410000ULL,
0x000000202a2a7220ULL, 0x080fe20000410000ULL, 0x000000202b2b7220ULL, 0x000fe20000410000ULL,
0x000000ffff097224ULL, 0x000fe200078e0022ULL, 0x0000761023207816ULL, 0x000fe20000000020ULL,
0x000000670a672220ULL, 0x010fce0000410000ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x000000085f227812ULL, 0x000fc800078ec0ffULL, 0x0000000222237210ULL, 0x000fc80007ffe04fULL,
0x00f6a875230075a7ULL, 0x000e64000800017fULL, 0x000000a400488947ULL, 0x002fea0003800000ULL,
0x000000003e3c783bULL, 0x000e620000004200ULL, 0x0000001066387824ULL, 0x000fe200078e0221ULL,
0x0000000aff66723eULL, 0x000fe200000010ffULL, 0x000000c056567836ULL, 0x000fe20000000000ULL,
0x00a000005a30783bULL, 0x000fe20000000200ULL, 0x0000991020737816ULL, 0x000fe200000000ffULL,
0x0000000c670c7221ULL, 0x000fe20000010000ULL, 0x0000541066757816ULL, 0x000fe40000000066ULL,
0x000000ff7300720cULL, 0x000fc60003f05270ULL, 0x00001f4275697589ULL, 0x000ea800000e0000ULL,
0x00001f4075667589ULL, 0x000ee200000e0000ULL, 0x000088803c707816ULL, 0x042fe200000000ffULL,
0x000001003d737824ULL, 0x040fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe2000001143cULL,
0x000001003c397824ULL, 0x040fe200078e00ffULL, 0x0000007000217306ULL, 0x0003e20000202400ULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x0000006930308232ULL, 0x084fe20000200000ULL, 0x00000018ff727819ULL, 0x000fe20000011439ULL,
0x0000006932328232ULL, 0x000fe20000200000ULL, 0x00000018ff227819ULL, 0x000fe2000001143dULL,
0x0000006631318232ULL, 0x088fe20000200000ULL, 0x0000007200207306ULL, 0x000ea20000202400ULL,
0x000088803d707816ULL, 0x042fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000006633338232ULL, 0x000fe20000200000ULL,
0x000000003838783bULL, 0x000e620000004200ULL, 0x00000018ff6a7819ULL, 0x000fc4000001143eULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff687819ULL, 0x000fe4000001143fULL, 0x0000541021207816ULL, 0x004fc60000000020ULL,
0x0000007300737306ULL, 0x000eb00000202400ULL, 0x0000002300237306ULL, 0x000fe20000202400ULL,
0x0000541070217816ULL, 0x004fce0000000073ULL, 0x0000003c00727306ULL, 0x0004e20000202400ULL,
0x000001003f737824ULL, 0x000fe200078e00ffULL, 0x000000203014723cULL, 0x000fe80000041814ULL,
0x00000018ff757819ULL, 0x000fe40000011473ULL, 0x0000002200227306ULL, 0x000fe20000202400ULL,
0x000088803e3c7816ULL, 0x044fe200000000ffULL, 0x000100003e737824ULL, 0x000fc400078e00ffULL,
0x000001003e217824ULL, 0x000fe200078e00ffULL, 0x00000018ff707819ULL, 0x002fc60000011438ULL,
0x0000003d003d7306ULL, 0x000e620000202400ULL, 0x0000541072207816ULL, 0x008fe40000000023ULL,
0x000088803f237816ULL, 0x000fe400000000ffULL, 0x00000018ff727819ULL, 0x000fe40000011421ULL,
0x00000018ff747819ULL, 0x000fe20000011473ULL, 0x0000003c003c7306ULL, 0x000fe20000202400ULL,
0x00000018ff3e7819ULL, 0x000fe40000011439ULL, 0x00000018ff737819ULL, 0x000fc4000001143aULL,
0x000054103d217816ULL, 0x002fe20000000022ULL, 0x0000001065227824ULL, 0x000fe400078e0271ULL,
0x00000072003d7306ULL, 0x0002a20000202400ULL, 0x000000ffff657224ULL, 0x000fc600078e0023ULL,
0x00000020301c723cULL, 0x000fe2000004181cULL, 0x000000002220783bULL, 0x000ee60000004200ULL,
0x0000006500657306ULL, 0x000fe20000202400ULL, 0x000100003f727824ULL, 0x002fca00078e00ffULL,
0x00000018ff797819ULL, 0x000fe40000011472ULL, 0x0000007500787306ULL, 0x000e620000202400ULL,
0x000054103c3c7816ULL, 0x004fe4000000003dULL, 0x00000018ff727819ULL, 0x000fca000001143bULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x00005410653d7816ULL, 0x002fce0000000078ULL,
0x0000006800687306ULL, 0x000fe20000202400ULL, 0x0000003c3010723cULL, 0x000fee0000041810ULL,
0x00000074003f7306ULL, 0x000e620000202400ULL, 0x00000018ff657819ULL, 0x008fce0000011420ULL,
0x0000007900797306ULL, 0x000ea20000202400ULL, 0x000054103f3c7816ULL, 0x002fce000000006aULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x00008880383f7816ULL, 0x040fe400000000ffULL,
0x00000018ff6a7819ULL, 0x000fe40000011421ULL, 0x00005410793d7816ULL, 0x004fe20000000068ULL,
0x0000010039687824ULL, 0x000fe400078e00ffULL, 0x0000003e003e7306ULL, 0x000fe60000202400ULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x0000003c3018723cULL, 0x000fe80000041818ULL,
0x0000007300737306ULL, 0x000fe60000202400ULL, 0x00000100383d7824ULL, 0x000fc400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e003fULL, 0x00008880393f7816ULL, 0x040fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000006800687306ULL, 0x000fe20000202400ULL, 0x0001000039397824ULL, 0x000fe400078e00ffULL,
0x00000018ff387819ULL, 0x000fca0000011438ULL, 0x0000003c003c7306ULL, 0x000ff00000202400ULL,
0x0000003d00757306ULL, 0x000e700000202400ULL, 0x0000003f003f7306ULL, 0x000eb00000202400ULL,
0x00000038003d7306ULL, 0x0002f00000202400ULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x000054103c387816ULL, 0x002fe20000000075ULL, 0x0000001058757824ULL, 0x000fe200078e0271ULL,
0x00000018ff3c7819ULL, 0x000fc40000011439ULL, 0x000054103f397816ULL, 0x004fe40000000068ULL,
0x00000018ff687819ULL, 0x000fe20000011422ULL, 0x0000003c003f7306ULL, 0x000e680000202400ULL,
0x000000383024723cULL, 0x000fe80000041824ULL, 0x0000006500657306ULL, 0x000fe60000202400ULL,
0x000054103d387816ULL, 0x008fe20000000070ULL, 0x000001003a3d7824ULL, 0x040fe200078e00ffULL,
0x000088803a397816ULL, 0x040fe200000000ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011423ULL, 0x0000006a006a7306ULL, 0x000fe20000202400ULL,
0x00000018ff717819ULL, 0x000fe2000001143dULL, 0x000000ffff587224ULL, 0x000fe200078e0039ULL,
0x000054103f397816ULL, 0x002fc4000000003eULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x00000000753c783bULL, 0x0002a40000004200ULL, 0x0000005800587306ULL, 0x000fe40000202400ULL,
0x00000038302c723cULL, 0x000fe2000004182cULL, 0x0000888022757816ULL, 0x002fca00000000ffULL,
0x0000007100717306ULL, 0x000e620000202400ULL, 0x000001003b387824ULL, 0x040fe200078e00ffULL,
0x000088803b397816ULL, 0x040fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003900397306ULL, 0x000ff00000202400ULL,
0x0000003800747306ULL, 0x0002f00000202400ULL, 0x0000003a003a7306ULL, 0x000f220000202400ULL,
0x0000541058387816ULL, 0x002fc40000000071ULL, 0x00000018ff717819ULL, 0x000fe4000001143bULL,
0x00000018ff3b7819ULL, 0x004fe4000001143dULL, 0x0000541039397816ULL, 0x008fe40000000074ULL,
0x0000007100717306ULL, 0x000e620000202400ULL, 0x00000018ff747819ULL, 0x000fe4000001143fULL,
0x00000018ff587819ULL, 0x000fe4000001143cULL, 0x000000383034723cULL, 0x000fe60000041834ULL,
0x0000006800687306ULL, 0x000fe80000202400ULL, 0x000054103a387816ULL, 0x010fe20000000073ULL,
0x0000010021737824ULL, 0x000fe200078e00ffULL, 0x0000541071397816ULL, 0x002fc40000000072ULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x0000888020717816ULL, 0x040fe400000000ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143eULL, 0x000000383030723cULL, 0x000fe20000041828ULL,
0x00a000005b28783bULL, 0x000e640000000200ULL, 0x0000007400387306ULL, 0x0005e80000202400ULL,
0x0000010020397824ULL, 0x000fc800078e00ffULL, 0x0000007100717306ULL, 0x000fe20000202400ULL,
0x00000018ff747819ULL, 0x004fe20000011473ULL, 0x0001000020737824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011439ULL, 0x0000888021397816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x0000007400747306ULL, 0x000fe60000202400ULL, 0x00000018ff217819ULL, 0x000fca0000011421ULL,
0x0000007200727306ULL, 0x000eb00000202400ULL, 0x0000003900397306ULL, 0x000ee20000202400ULL,
0x0000541071207816ULL, 0x004fe20000000072ULL, 0x0000006928288232ULL, 0x002fcc0000200000ULL,
0x0000002100717306ULL, 0x0006620000202400ULL, 0x000000692a2a8232ULL, 0x000fe20000200000ULL,
0x0000888023697816ULL, 0x000fe200000000ffULL, 0x0000006629298232ULL, 0x080fe40000200000ULL,
0x000000662b2b8232ULL, 0x000fe40000200000ULL, 0x0000010022667824ULL, 0x000fe200078e00ffULL,
0x0000000956007c0cULL, 0x000fe2000bf06070ULL, 0x0000007300727306ULL, 0x000ea20000202400ULL,
0x0000541039217816ULL, 0x008fe20000000074ULL, 0x000000ffff747224ULL, 0x000fe200078e0076ULL,
0x00000018ff667819ULL, 0x000fca0000011466ULL, 0x000000202814723cULL, 0x000fe20000041814ULL,
0x0000007500397306ULL, 0x000fec0000202400ULL, 0x0000010023207824ULL, 0x040fe400078e00ffULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x0001000023237824ULL, 0x000fc400078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011420ULL, 0x0001000022207824ULL, 0x000fe400078e00ffULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x0000002100227306ULL, 0x0003e20000202400ULL,
0x00000018ff207819ULL, 0x000fce0000011420ULL, 0x0000002000757306ULL, 0x0005e20000202400ULL,
0x0000541071217816ULL, 0x002fe2000000006aULL, 0x000001003c6a7824ULL, 0x000fcc00078e00ffULL,
0x0000006900697306ULL, 0x000e620000202400ULL, 0x0000541072207816ULL, 0x004fe40000000065ULL,
0x00000018ff727819ULL, 0x000fe4000001146aULL, 0x000088803c657816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000088803d6a7816ULL, 0x000fe200000000ffULL,
0x00000020281c723cULL, 0x000fe2000004181cULL, 0x0000002300737306ULL, 0x0004e40000202400ULL,
0x00000018ff3c7819ULL, 0x000fc8000001143cULL, 0x000001003d207824ULL, 0x000fe200078e00ffULL,
0x0000541069217816ULL, 0x002fe20000000022ULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x0000006500657306ULL, 0x000fe20000202400ULL, 0x000088803e237816ULL, 0x004fe400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff3d7819ULL, 0x000fc6000001143dULL,
0x0000002000797306ULL, 0x0003f00000202400ULL, 0x0000007200727306ULL, 0x000ea20000202400ULL,
0x0000541039207816ULL, 0x002fe20000000066ULL, 0x000001003e397824ULL, 0x000fc400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff697819ULL, 0x000fe20000011439ULL,
0x000000202810723cULL, 0x000fe20000041810ULL, 0x0000006a006a7306ULL, 0x000e620000202400ULL,
0x00000018ff397819ULL, 0x000fca000001143eULL, 0x000001003f207824ULL, 0x000fe200078e00ffULL,
0x0000541073217816ULL, 0x008fe20000000070ULL, 0x0000003d00667306ULL, 0x000fe20000202400ULL,
0x000000016c737812ULL, 0x000fe200078e0cffULL, 0x000000ffff707224ULL, 0x000fe200078e006bULL,
0x00000018ff207819ULL, 0x000fca0000011420ULL, 0x00000020003d7306ULL, 0x0007f00000202400ULL,
0x0000005800587306ULL, 0x000fe20000202400ULL, 0x0000541075207816ULL, 0x008fe20000000068ULL,
0x000000ffff757224ULL, 0x000fcc00078e0077ULL, 0x0000003b003b7306ULL, 0x000fe20000202400ULL,
0x000000202818723cULL, 0x000fee0000041818ULL, 0x0000003c00717306ULL, 0x0007220000202400ULL,
0x0000541065207816ULL, 0x004fe40000000072ULL, 0x000054106a217816ULL, 0x002fca0000000079ULL,
0x0000002300227306ULL, 0x0003e20000202400ULL, 0x000088803f3c7816ULL, 0x048fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x000000202824723cULL, 0x000fea0000041824ULL,
0x0000006900697306ULL, 0x000ea20000202400ULL, 0x00000018ff237819ULL, 0x002fe4000001143fULL,
0x0000541071207816ULL, 0x010fc40000000058ULL, 0x0000541066217816ULL, 0x000fc6000000003bULL,
0x0000003c003c7306ULL, 0x000e680000202400ULL, 0x00000020282c723cULL, 0x000fe8000004182cULL,
0x0000003a003a7306ULL, 0x000fe60000202400ULL, 0x0000541022207816ULL, 0x004fc40000000069ULL,
0x000054103c217816ULL, 0x002fc6000000003dULL, 0x0000003900397306ULL, 0x000e680000202400ULL,
0x000000202834723cULL, 0x000fe80000041834ULL, 0x0000002300237306ULL, 0x000ea60000202400ULL,
0x0000541039207816ULL, 0x002fc4000000003aULL, 0x0000541023217816ULL, 0x004fce0000000038ULL,
0x000000202828723cULL, 0x000fe20000041830ULL, 0x00f6c80d443079a7ULL, 0x0002a2000850003fULL,
0x00f6980d46ff79a7ULL, 0x0003e2000850003fULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000001400e00947ULL, 0x000fde0003800000ULL, 0x00000031520075a7ULL, 0x004ea2000800007fULL,
0x0000000103217824ULL, 0x000fe200078e020eULL, 0x000000036b227812ULL, 0x000fe200078ec0ffULL,
0x000000014d5e7824ULL, 0x000fe400078e025eULL, 0x0000000121207836ULL, 0x000fe20000000000ULL,
0x000000032200780cULL, 0x000fc80003f45270ULL, 0x0000000520007c0cULL, 0x000fe2000bf26070ULL,
0x0000010021207824ULL, 0x000fe200078e0206ULL, 0x0000000104707807ULL, 0x000fe20005000000ULL,
0x0000000c05217c24ULL, 0x020fc6000f8e02ffULL, 0x0000000920057c48ULL, 0x000fe2000ffe0000ULL,
0x0000000000080947ULL, 0x004fec0003800000ULL, 0x00f6c831540075a7ULL, 0x000ea4000800017fULL,
0x0000009400548947ULL, 0x004fea0003800000ULL, 0x0000000105057824ULL, 0x000fe200078e0a20ULL,
0x0000002007207812ULL, 0x000fe200078ef820ULL, 0x000000016b707824ULL, 0x000fe400078e0270ULL,
0x0000004021307824ULL, 0x000fe200078e00ffULL, 0x0000002005227807ULL, 0x000fe20000800000ULL,
0x0000000157577824ULL, 0x100fe200078e0220ULL, 0x0000000470007c0cULL, 0x000fe2000bf06070ULL,
0x0000000155557824ULL, 0x100fe200078e0220ULL, 0x0000002259227248ULL, 0x000fe20007fe0000ULL,
0x0000000153537824ULL, 0x100fe200078e0220ULL, 0x0000005730577210ULL, 0x000fe20007f3e0ffULL,
0x0000000151207824ULL, 0x000fe200078e0220ULL, 0x0000005530557210ULL, 0x000fe20007f7e0ffULL,
0x0000000122597824ULL, 0x000fe200078e0a59ULL, 0x0000005330537210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff227224ULL, 0x000fe200008e06ffULL, 0x0000000e573e7c11ULL, 0x000fc4000f8238ffULL,
0x0000002030397210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x00008c00ff208b82ULL, 0x000ea20000000a00ULL, 0x0000000f57237c11ULL, 0x000fe200088f3c22ULL,
0x000000ffff227224ULL, 0x000fe200018e06ffULL, 0x0000000e553c7c11ULL, 0x000fe2000f8638ffULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x000000594c00720cULL, 0x000fe20003f26070ULL,
0x000000010b338824ULL, 0x000fe200078e0270ULL, 0x0000000f55317c11ULL, 0x000fe400098f3c22ULL,
0x0000004b3e227210ULL, 0x000fc40007f7e0ffULL, 0x0000000e39387c11ULL, 0x000fe4000f8438ffULL,
0x0000000e53327c11ULL, 0x000fe2000f8838ffULL, 0x000000ffff237224ULL, 0x000fe200018e0623ULL,
0x0000000f39397c11ULL, 0x000fe400090f3c30ULL, 0x0000004b3c307210ULL, 0x000fe40007fbe0ffULL,
0x0000000f53057c11ULL, 0x000fe2000a0f3c3aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022647faeULL, 0x0007e2000c901c4aULL, 0x000000594a00720cULL, 0x080fe20003f46070ULL,
0x000000ffff317224ULL, 0x000fe200028e0631ULL, 0x000000594900720cULL, 0x080fe20003f86070ULL,
0x0000000433208825ULL, 0x004fe200078e0020ULL, 0x000000594800720cULL, 0x000fc40003f66070ULL,
0x0000004b32327210ULL, 0x000fe40007f3e0ffULL, 0x0000004b38387210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff337224ULL, 0x000fe400008e0605ULL, 0x000000ffff397224ULL, 0x000fe200028e0639ULL,
0x0000000030637faeULL, 0x0005e2000d101c4aULL, 0xffffffffff057424ULL, 0x000fc600078e00ffULL,
0x0000000032627faeULL, 0x0005e8000e101c4aULL, 0x0000000038607faeULL, 0x0005e2000d901c4aULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000a20058981ULL, 0x000568000c1e1900ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a46ULL, 0x0000000000007918ULL, 0x008fe20000000000ULL,
0x0000000d5e7479a7ULL, 0x0006e2000850003fULL, 0x0000018002617810ULL, 0x000fc80007ffe061ULL,
0x000000614e617210ULL, 0x000fe20007ffe04bULL, 0x00000077ff0075a7ULL, 0x0006e20008000047ULL,
0x00f6680d502079a7ULL, 0x004ea4000850003fULL, 0x00f66821500075a7ULL, 0x004ea4000802017fULL,
0x0000009000749947ULL, 0x00efea0003800000ULL, 0x00f0000061207984ULL, 0x000e620000000800ULL,
0x00000001ff547424ULL, 0x000fc600078e00ffULL, 0x00f2000061497984ULL, 0x0004a20000000800ULL,
0x000000092000720bULL, 0x002fda0003f3d000ULL, 0x0000000000217806ULL, 0x000fc800008e0100ULL,
0x0000ffff21237812ULL, 0x000fda000782c0ffULL, 0x0000000000d89947ULL, 0x004fea0003800000ULL,
0x000000092000720bULL, 0x000fe20003f34000ULL, 0x000000030f227836ULL, 0x000fe20000000000ULL,
0x0000002009317209ULL, 0x000fca0007810000ULL, 0x8000003109217221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b21217820ULL, 0x000fe40000410000ULL, 0x0000000000097806ULL, 0x000fe400008e0100ULL,
0x000000472200720cULL, 0x000fe40003f25270ULL, 0x0000ffff09307812ULL, 0x000fe200078e3cffULL,
0x0000002100217308ULL, 0x000e660000000800ULL, 0x0000003023ff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff547807ULL, 0x000fc60001000000ULL, 0x0000008047239824ULL, 0x000fe200078e0202ULL,
0x00001f4221097589ULL, 0x002e6a00000e0000ULL, 0x8000003120222221ULL, 0x000fe20000010000ULL,
0x000000234e4e9210ULL, 0x000fe20007ffe04bULL, 0x000000210c0c7220ULL, 0x000fe20000410000ULL,
0x00001f4021207589ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b22222820ULL, 0x000fc60000410000ULL,
0x00f400314e009388ULL, 0x0007e20000000800ULL, 0x00000022000a2308ULL, 0x000f220000000800ULL,
0x0000000914147220ULL, 0x082fe20000410000ULL, 0x0000000915157220ULL, 0x080fe20000410000ULL,
0x000000091c1c7220ULL, 0x080fe20000410000ULL, 0x000000091d1d7220ULL, 0x080fe20000410000ULL,
0x0000000910107220ULL, 0x080fe20000410000ULL, 0x0000000911117220ULL, 0x080fe20000410000ULL,
0x0000000918187220ULL, 0x080fe20000410000ULL, 0x0000000919197220ULL, 0x080fe20000410000ULL,
0x0000000924247220ULL, 0x080fe20000410000ULL, 0x0000000925257220ULL, 0x080fe20000410000ULL,
0x000000092c2c7220ULL, 0x080fe20000410000ULL, 0x000000092d2d7220ULL, 0x080fe20000410000ULL,
0x0000000934347220ULL, 0x080fe20000410000ULL, 0x0000000935357220ULL, 0x080fe20000410000ULL,
0x0000000928287220ULL, 0x080fe20000410000ULL, 0x0000000929297220ULL, 0x000fe20000410000ULL,
0x0000002016167220ULL, 0x084fe20000410000ULL, 0x0000002017177220ULL, 0x080fe20000410000ULL,
0x000000201e1e7220ULL, 0x080fe20000410000ULL, 0x000000201f1f7220ULL, 0x080fe20000410000ULL,
0x0000002012127220ULL, 0x080fe20000410000ULL, 0x0000002013137220ULL, 0x080fe20000410000ULL,
0x000000201a1a7220ULL, 0x080fe20000410000ULL, 0x000000201b1b7220ULL, 0x080fe20000410000ULL,
0x0000002026267220ULL, 0x080fe20000410000ULL, 0x0000002027277220ULL, 0x080fe20000410000ULL,
0x000000202e2e7220ULL, 0x080fe20000410000ULL, 0x000000202f2f7220ULL, 0x080fe20000410000ULL,
0x0000002036367220ULL, 0x080fe20000410000ULL, 0x0000002037377220ULL, 0x080fe20000410000ULL,
0x000000202a2a7220ULL, 0x080fe20000410000ULL, 0x000000202b2b7220ULL, 0x000fe20000410000ULL,
0x000000ffff097224ULL, 0x000fc400078e0031ULL, 0x000000490a492220ULL, 0x018fce0000410000ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x000000085f5f7812ULL, 0x000fc800078e0cffULL,
0x000000025f4f7210ULL, 0x000fc80007ffe04fULL, 0x00f6a8774f0075a7ULL, 0x000e64000800017fULL,
0x0000008c00848947ULL, 0x002fea0003800000ULL, 0x000000005d38783bULL, 0x000e620000004200ULL,
0x0000000c490c7221ULL, 0x000fc60000010000ULL, 0x000000005c3c783bULL, 0x000ea80000004200ULL,
0x000000006e30783bULL, 0x0007e80000004200ULL, 0x000000006d20783bULL, 0x000f220000004200ULL,
0x00000018ff617819ULL, 0x002fe20000011438ULL, 0x0000010038537824ULL, 0x040fe200078e00ffULL,
0x0000888038787816ULL, 0x040fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011439ULL, 0x0000010039567824ULL, 0x040fe200078e00ffULL,
0x0000888039557816ULL, 0x040fe200000000ffULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000007800787306ULL, 0x000fe20000202400ULL,
0x00000018ff537819ULL, 0x000fc40000011453ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff667819ULL, 0x000fe4000001143aULL, 0x00000018ff6c7819ULL, 0x000fe2000001143bULL,
0x0000003800767306ULL, 0x0003e20000202400ULL, 0x000088803a7d7816ULL, 0x000fe400000000ffULL,
0x000088803b6e7816ULL, 0x008fe400000000ffULL, 0x00000018ff647819ULL, 0x004fc4000001143cULL,
0x000088803c777816ULL, 0x040fe200000000ffULL, 0x0000003900727306ULL, 0x0005e20000202400ULL,
0x000001003b387824ULL, 0x042fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001143dULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000005300577306ULL, 0x0002e20000202400ULL,
0x000001003c397824ULL, 0x044fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fc4000001143eULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000038007b7306ULL, 0x0005e20000202400ULL,
0x000001003a537824ULL, 0x042fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe4000001143fULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x00000039006a7306ULL, 0x0003e20000202400ULL,
0x000001003d387824ULL, 0x004fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fc4000001143aULL,
0x000088803d687816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003a006b7306ULL, 0x000fe20000202400ULL,
0x000001003e397824ULL, 0x042fe200078e00ffULL, 0x000088803e697816ULL, 0x040fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff397819ULL, 0x000fc40000011439ULL, 0x0000003800737306ULL, 0x0003e20000202400ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff507819ULL, 0x010fe40000011420ULL,
0x00000018ff487819ULL, 0x000fe40000011421ULL, 0x00000018ff4a7819ULL, 0x000fe20000011422ULL,
0x0000003b00797306ULL, 0x000fe20000202400ULL, 0x000001003f387824ULL, 0x002fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fc40000011430ULL, 0x0000888030657816ULL, 0x000fe400000000ffULL,
0x00000018ff607819ULL, 0x000fe40000011438ULL, 0x0000003900627306ULL, 0x0003e20000202400ULL,
0x00000018ff4b7819ULL, 0x000fe40000011423ULL, 0x00000018ff4d7819ULL, 0x000fe40000011431ULL,
0x00000018ff4e7819ULL, 0x000fe40000011432ULL, 0x00000018ff4f7819ULL, 0x000fe20000011433ULL,
0x0000003c00717306ULL, 0x0005e20000202400ULL, 0x00a800005a38783bULL, 0x002fee0000000200ULL,
0x0000005300587306ULL, 0x0003e20000202400ULL, 0x00009910543c7816ULL, 0x004fc400000000ffULL,
0x0000541078547816ULL, 0x008fe40000000057ULL, 0x000000ff3c00720cULL, 0x000fe40003f05270ULL,
0x0000000aff3c723eULL, 0x000fe200000010ffULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x000088803f537816ULL, 0x042fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x000054103c5d7816ULL, 0x000fe2000000003cULL, 0x00000100203c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x00001f425d597589ULL, 0x0002a200000e0000ULL,
0x0000005600567306ULL, 0x000ee20000202400ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00001f405d407589ULL, 0x0008aa00000e0000ULL, 0x0000006100617306ULL, 0x000ea20000202400ULL,
0x0000010022427824ULL, 0x042fe200078e00ffULL, 0x00008880225d7816ULL, 0x050fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x0000541055557816ULL, 0x008fc80000000056ULL,
0x0000006300637306ULL, 0x000e620000202400ULL, 0x00000018ff567819ULL, 0x000fe40000011442ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x0000888023427816ULL, 0x000fe200000000ffULL,
0x0000005938388232ULL, 0x084fe40000200000ULL, 0x0000003d006d7306ULL, 0x0005e20000202400ULL,
0x000000593a3a8232ULL, 0x000fe40000200000ULL, 0x0000004039398232ULL, 0x000fc40000200000ULL,
0x000000403b3b8232ULL, 0x000fc60000200000ULL, 0x0000003e00677306ULL, 0x0007e20000202400ULL,
0x00008880203d7816ULL, 0x044fe200000000ffULL, 0x0001000020207824ULL, 0x000fe400078e00ffULL,
0x000000543814723cULL, 0x000fe60000041814ULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000003f005e7306ULL, 0x0005e20000202400ULL, 0x00008880213e7816ULL, 0x008fe400000000ffULL,
0x0000010023547824ULL, 0x000fc400078e00ffULL, 0x0000010031557824ULL, 0x000fe400078e00ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x0000002000577306ULL, 0x0007e20000202400ULL,
0x00000100213f7824ULL, 0x044fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000007d007d7306ULL, 0x000ea20000202400ULL, 0x0000541076207816ULL, 0x008fce0000000061ULL,
0x00000021005f7306ULL, 0x0003f00000202400ULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x0000541072217816ULL, 0x002fce0000000063ULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x00000020381c723cULL, 0x000fee000004181cULL, 0x0000010030207824ULL, 0x040fe200078e00ffULL,
0x0000005400617306ULL, 0x0003e20000202400ULL, 0x0001000030307824ULL, 0x000fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000007700777306ULL, 0x000fe20000202400ULL,
0x00000018ff547819ULL, 0x002fe40000011420ULL, 0x000054107d207816ULL, 0x004fca0000000058ULL,
0x0000006800687306ULL, 0x000ff00000202400ULL, 0x0000006e006e7306ULL, 0x000e700000202400ULL,
0x0000005400587306ULL, 0x0005e20000202400ULL, 0x000054106e217816ULL, 0x002fce000000007bULL,
0x0000006400647306ULL, 0x000e620000202400ULL, 0x000054106b547816ULL, 0x004fe40000000066ULL,
0x00000018ff6b7819ULL, 0x000fe40000011455ULL, 0x0000541079557816ULL, 0x000fe2000000006cULL,
0x000000203810723cULL, 0x000fe40000041810ULL, 0x0000005c005c7306ULL, 0x000ea80000202400ULL,
0x000000543818723cULL, 0x000fe80000041818ULL, 0x0000002200637306ULL, 0x0007e60000202400ULL,
0x0001000031547824ULL, 0x000fca00078e00ffULL, 0x0000003000557306ULL, 0x0009e20000202400ULL,
0x0000888031227816ULL, 0x008fe400000000ffULL, 0x0000541068317816ULL, 0x000fe20000000073ULL,
0x000000ffff737224ULL, 0x000fe200078e006fULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x000000ffff6e7224ULL, 0x000fe400078e0022ULL, 0x0000005300537306ULL, 0x000fe20000202400ULL,
0x0000541077307816ULL, 0x010fce000000006aULL, 0x0000006000607306ULL, 0x000fe20000202400ULL,
0x000000303824723cULL, 0x000fee0000041824ULL, 0x0000005200527306ULL, 0x000ee20000202400ULL,
0x0000541071307816ULL, 0x002fe40000000064ULL, 0x000054106d317816ULL, 0x004fe2000000005cULL,
0x00000100325c7824ULL, 0x000fc800078e00ffULL, 0x0000005100517306ULL, 0x000e620000202400ULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x00000030382c723cULL, 0x000fe2000004182cULL,
0x0000541067527816ULL, 0x008fca0000000052ULL, 0x0000006900697306ULL, 0x000ea20000202400ULL,
0x0000541053317816ULL, 0x000fe40000000060ULL, 0x000054105e537816ULL, 0x002fca0000000051ULL,
0x00000023005a7306ULL, 0x0003e40000202400ULL, 0x000000523828723cULL, 0x000fe20000041828ULL,
0x0000541069307816ULL, 0x004fca0000000062ULL, 0x0000005000507306ULL, 0x000ea20000202400ULL,
0x00a800005b20783bULL, 0x0022e20000000200ULL, 0x000000303834723cULL, 0x000fec0000041834ULL,
0x0000005c00307306ULL, 0x000fe20000202400ULL, 0x00008880325b7816ULL, 0x002fe200000000ffULL,
0x0000010033387824ULL, 0x040fe200078e00ffULL, 0x0000888033317816ULL, 0x040fe200000000ffULL,
0x00010000333a7824ULL, 0x000fc800078e00ffULL, 0x0000005b005b7306ULL, 0x000e620000202400ULL,
0x0000541057507816ULL, 0x004fe40000000050ULL, 0x00000018ff397819ULL, 0x000fe20000011438ULL,
0x0001000032387824ULL, 0x000fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fc6000001143aULL,
0x0000003100317306ULL, 0x000fe20000202400ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x000054105b307816ULL, 0x002fca0000000030ULL, 0x0000003900327306ULL, 0x000e700000202400ULL,
0x0000003d003d7306ULL, 0x000fe20000202400ULL, 0x0000005920208232ULL, 0x088fe40000200000ULL,
0x0000005922228232ULL, 0x000fc40000200000ULL, 0x0000004021218232ULL, 0x080fe40000200000ULL,
0x0000004023238232ULL, 0x000fe20000200000ULL, 0x0000003c003c7306ULL, 0x000ea20000202400ULL,
0x0000541031317816ULL, 0x002fce0000000032ULL, 0x0000004800487306ULL, 0x000e620000202400ULL,
0x000000302034723cULL, 0x000fe20000041834ULL, 0x00f6c80d443079a7ULL, 0x0006e2000850003fULL,
0x000054103d3c7816ULL, 0x004fca000000003cULL, 0x0000004a004a7306ULL, 0x000ea20000202400ULL,
0x00f6a00d46ff79a7ULL, 0x0007e2000850003fULL, 0x000054105f517816ULL, 0x002fcc0000000048ULL,
0x0000004b004b7306ULL, 0x000e620000202400ULL, 0x00000050201c723cULL, 0x000fe2000004181cULL,
0x00005410634a7816ULL, 0x004fcc000000004aULL, 0x0000004c004c7306ULL, 0x000ea20000202400ULL,
0x000054105a4b7816ULL, 0x002fce000000004bULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x0000004a2018723cULL, 0x000fe20000041818ULL, 0x00005410554c7816ULL, 0x004fcc000000004cULL,
0x0000004e004e7306ULL, 0x000ff00000202400ULL, 0x0000004f004f7306ULL, 0x000ff00000202400ULL,
0x0000003e003e7306ULL, 0x000ff00000202400ULL, 0x0000003f003f7306ULL, 0x000e700000202400ULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x000054103e3d7816ULL, 0x002fce000000003fULL,
0x0000005600567306ULL, 0x000e620000202400ULL, 0x0000003c2014723cULL, 0x000fee0000041814ULL,
0x0000004200427306ULL, 0x000ea20000202400ULL, 0x000054105d567816ULL, 0x002fce0000000056ULL,
0x0000006500657306ULL, 0x000e620000202400ULL, 0x0000541042577816ULL, 0x004fce0000000061ULL,
0x0000006e00667306ULL, 0x000fe20000202400ULL, 0x000000562010723cULL, 0x000fe20000041810ULL,
0x0000541065587816ULL, 0x002fcc0000000058ULL, 0x0000006b006b7306ULL, 0x000e700000202400ULL,
0x0000005400547306ULL, 0x000ea20000202400ULL, 0x0000541066597816ULL, 0x002fce000000006bULL,
0x0000003800337306ULL, 0x000e620000202400ULL, 0x000000582024723cULL, 0x000fe20000041824ULL,
0x00005410544d7816ULL, 0x004fcc000000004dULL, 0x0000003a003a7306ULL, 0x000ea20000202400ULL,
0x0000004c202c723cULL, 0x000fe2000004182cULL, 0x00005410334e7816ULL, 0x002fe4000000004eULL,
0x000054103a4f7816ULL, 0x004fce000000004fULL, 0x0000004e2028723cULL, 0x008fde0000041828ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x00000001030e7824ULL, 0x000fca00078e020eULL,
0x000000050e007c0cULL, 0x000fda000bf06070ULL, 0xffffff9800108947ULL, 0x02efea000383ffffULL,
0x00000000000b7919ULL, 0x000e620000002500ULL, 0x000000ffff387224ULL, 0x000fe400078e001dULL,
0x000000ffff327224ULL, 0x000fe400078e001cULL, 0x000000ffff307224ULL, 0x004fe400078e0015ULL,
0x000000ffff227224ULL, 0x000fe200078e0014ULL, 0x000000050b007c0cULL, 0x002fda000bf06070ULL,
0x0000000000d80947ULL, 0x000fea0003800000ULL, 0x018000000c007836ULL, 0x000fe20000000000ULL,
0x000000c000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x00007ba0000a7802ULL, 0x000fce0000000f00ULL, 0x00000084004c7944ULL, 0x028fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0007ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000c00057308ULL, 0x020e640000001000ULL, 0xbf80000005007423ULL, 0x002fc8000000000cULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000005007223ULL, 0x000fce0000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009400ff047b82ULL, 0x000ea40000000a00ULL,
0x0000000a04057981ULL, 0x004ea2000c1e9900ULL, 0x00000000000d7919ULL, 0x000f240000000000ULL,
0x00000002ff077819ULL, 0x010fe4000001160dULL, 0x000000080d0d7811ULL, 0x000fe200078ff0ffULL,
0x0000000005007220ULL, 0x004fca0000410000ULL, 0x00001f0700077589ULL, 0x000ea800000e0000ULL,
0x00001f0d000d7589ULL, 0x000f2200000e0000ULL, 0x0000002207227220ULL, 0x044fe20000410000ULL,
0x0000003007307220ULL, 0x040fe20000410000ULL, 0x0000003207327220ULL, 0x040fe20000410000ULL,
0x0000003807387220ULL, 0x040fe20000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x0000001107117220ULL, 0x040fe20000410000ULL, 0x0000001807187220ULL, 0x040fe20000410000ULL,
0x0000001907197220ULL, 0x040fe20000410000ULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x0000002c072c7220ULL, 0x040fe20000410000ULL,
0x0000002d072d7220ULL, 0x040fe20000410000ULL, 0x0000003407347220ULL, 0x040fe20000410000ULL,
0x0000003507357220ULL, 0x040fe20000410000ULL, 0x0000002807287220ULL, 0x040fe20000410000ULL,
0x0000002907297220ULL, 0x000fe20000410000ULL, 0x000000160d167220ULL, 0x050fe20000410000ULL,
0x000000170d177220ULL, 0x040fe20000410000ULL, 0x0000001e0d1e7220ULL, 0x040fe20000410000ULL,
0x0000001f0d1f7220ULL, 0x040fe20000410000ULL, 0x000000120d127220ULL, 0x040fe20000410000ULL,
0x000000130d137220ULL, 0x040fe20000410000ULL, 0x0000001a0d1a7220ULL, 0x040fe20000410000ULL,
0x0000001b0d1b7220ULL, 0x040fe20000410000ULL, 0x000000260d267220ULL, 0x040fe20000410000ULL,
0x000000270d277220ULL, 0x040fe20000410000ULL, 0x0000002e0d2e7220ULL, 0x040fe20000410000ULL,
0x0000002f0d2f7220ULL, 0x040fe20000410000ULL, 0x000000360d367220ULL, 0x040fe20000410000ULL,
0x000000370d377220ULL, 0x040fe20000410000ULL, 0x0000002a0d2a7220ULL, 0x040fe20000410000ULL,
0x0000002b0d2b7220ULL, 0x000fce0000410000ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x0000100045027824ULL, 0x000fe200078e0202ULL, 0x000000101110723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000181918723eULL, 0x000fe400000010ffULL,
0x000000242524723eULL, 0x000fe400000010ffULL, 0x0000002c2d2c723eULL, 0x000fe400000010ffULL,
0x000000343534723eULL, 0x000fc400000010ffULL, 0x000000282928723eULL, 0x000fe400000010ffULL,
0x000000161716723eULL, 0x000fe400000010ffULL, 0x0000001e1f1e723eULL, 0x000fe400000010ffULL,
0x000000121312723eULL, 0x000fe400000010ffULL, 0x0000001a1b1a723eULL, 0x000fe400000010ffULL,
0x000000262726723eULL, 0x000fc400000010ffULL, 0x0000002e2f13723eULL, 0x000fe400000010ffULL,
0x000000363736723eULL, 0x000fe400000010ffULL, 0x0000002a2b1b723eULL, 0x000fe400000010ffULL,
0x000000010300780cULL, 0x000fe40003f05270ULL, 0x0000000207007812ULL, 0x004fe400078ec0ffULL,
0x00000002ff217819ULL, 0x000fc40000011607ULL, 0x0000000200057811ULL, 0x060fe400078ff8ffULL,
0x00000001ff047819ULL, 0x000fe40000011600ULL, 0x00000007050a7812ULL, 0x000fe400078e7821ULL,
0x00000004000e7811ULL, 0x040fe400078ff8ffULL, 0x00000006001c7811ULL, 0x000fe200078ff8ffULL,
0x0000000821157824ULL, 0x000fe200078e020aULL, 0x0000000807397811ULL, 0x040fe200078ff0ffULL,
0x00000008070a7824ULL, 0x000fe200078e00ffULL, 0x0000000704007812ULL, 0x000fc400078e7821ULL,
0x0000000704047812ULL, 0x000fe400078e7839ULL, 0x0000000705057812ULL, 0x000fe200078e7839ULL,
0x00000008210d7824ULL, 0x000fe200078e0200ULL, 0x000000070e147812ULL, 0x000fe200078e7821ULL,
0x0000080043007824ULL, 0x000fe200078e0202ULL, 0x000000080a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000839237824ULL, 0x040fe200078e0204ULL, 0x000000223004723eULL, 0x000fe200000010ffULL,
0x0000000839317824ULL, 0x000fe200078e0205ULL, 0x000000323805723eULL, 0x000fe200000010ffULL,
0x000000100d0d7824ULL, 0x100fe200078e0200ULL, 0x000000071c207812ULL, 0x000fe200078e7821ULL,
0x0000001015157824ULL, 0x000fe200078e0200ULL, 0x00005410043a7816ULL, 0x140fe20000000005ULL,
0x00000008211d7824ULL, 0x000fe200078e0214ULL, 0x00007632043b7816ULL, 0x000fe20000000005ULL,
0x000000010d0d7824ULL, 0x000fe200078e020aULL, 0x0000541010047816ULL, 0x100fe20000000018ULL,
0x000000010a157824ULL, 0x000fe200078e0215ULL, 0x0000763210057816ULL, 0x000fe20000000018ULL,
0x000000101d1d7824ULL, 0x000fe200078e0200ULL, 0x0000003a0d007388ULL, 0x000fe20000000a00ULL,
0x0000000821217824ULL, 0x000fe200078e0220ULL, 0x000000070e0e7812ULL, 0x000fe200078e7839ULL,
0x000000010a1d7824ULL, 0x000fe200078e021dULL, 0x0000000415007388ULL, 0x0005e20000000a00ULL,
0x0000001021217824ULL, 0x100fe200078e0200ULL, 0x000000071c1c7812ULL, 0x000fe200078e7839ULL,
0x0000001023237824ULL, 0x000fc400078e0200ULL, 0x000000010a217824ULL, 0x040fe400078e0221ULL,
0x0000000839337824ULL, 0x000fe400078e020eULL, 0x000000010a237824ULL, 0x000fe400078e0223ULL,
0x0000001031317824ULL, 0x000fe200078e0200ULL, 0x0000541024047816ULL, 0x044fe2000000002cULL,
0x0000001033337824ULL, 0x000fe200078e0200ULL, 0x0000763224057816ULL, 0x000fe2000000002cULL,
0x0000000839397824ULL, 0x000fc400078e021cULL, 0x000000010a317824ULL, 0x040fe400078e0231ULL,
0x000000041d007388ULL, 0x0005e20000000a00ULL, 0x000000010a337824ULL, 0x000fe400078e0233ULL,
0x0000001039397824ULL, 0x000fe400078e0200ULL, 0x00000001060d7824ULL, 0x000fe400078e0207ULL,
0x000000010a397824ULL, 0x000fe400078e0239ULL, 0x000000100d107824ULL, 0x000fe200078e0202ULL,
0x0000541034047816ULL, 0x004fc40000000028ULL, 0x0000763234057816ULL, 0x000fca0000000028ULL,
0x0000000421007388ULL, 0x0005e40000000a00ULL, 0x0000541016047816ULL, 0x144fe4000000001eULL,
0x0000763216057816ULL, 0x000fca000000001eULL, 0x0000000423007388ULL, 0x0005e40000000a00ULL,
0x0000541012047816ULL, 0x144fe4000000001aULL, 0x0000763212057816ULL, 0x000fe4000000001aULL,
0x0000541026127816ULL, 0x140fe40000000013ULL, 0x0000763226137816ULL, 0x000fe20000000013ULL,
0x0000000431007388ULL, 0x0005e80000000a00ULL, 0x0000001233007388ULL, 0x0009e20000000a00ULL,
0x000000ff00047306ULL, 0x004ea20000202400ULL, 0x0000541036127816ULL, 0x010fc4000000001bULL,
0x0000763236137816ULL, 0x000fca000000001bULL, 0x0000001239007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000010147984ULL, 0x000ea80000000c00ULL,
0x00040000101c7984ULL, 0x000f280000000c00ULL, 0x0008000010187984ULL, 0x000f680000000c00ULL,
0x000c000010207984ULL, 0x000f620000000c00ULL, 0x0000001704177230ULL, 0x004fc40000200800ULL,
0x0000001604167230ULL, 0x040fe40000200800ULL, 0x0000001504157230ULL, 0x040fe40000200800ULL,
0x0000001404147230ULL, 0x040fe40000200800ULL, 0x0000001f041f7230ULL, 0x050fe40000200800ULL,
0x0000001e041e7230ULL, 0x040fe40000200800ULL, 0x0000001d041d7230ULL, 0x000fc40000200800ULL,
0x0000001c04047230ULL, 0x000fe40000200800ULL, 0x0000001b17177230ULL, 0x022fe40000200000ULL,
0x0000001a16167230ULL, 0x000fe40000200000ULL, 0x0000001915157230ULL, 0x000fe40000200000ULL,
0x0000001814147230ULL, 0x000fe40000200000ULL, 0x000000231f1f7230ULL, 0x008fc40000200000ULL,
0x000000221e1e7230ULL, 0x000fe20000200000ULL, 0x0000001410007388ULL, 0x0003e20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000200000ULL, 0x00000020041c7230ULL, 0x000fca0000200000ULL,
0x0004001c10007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000002800188947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x000ea20000002700ULL,
0x00008400ff0a7b82ULL, 0x000ea20000000800ULL, 0x00000400471a7824ULL, 0x000fe200078e00ffULL,
0x0000000143ff7812ULL, 0x000fe2000780f847ULL, 0x0000000000117919ULL, 0x000ea20000002600ULL,
0x00000400001c7802ULL, 0x002fe40000000f00ULL, 0x000004001a1a7812ULL, 0x000fe200078ee2ffULL,
0x0000000000157919ULL, 0x000e620000008800ULL, 0x00009200ff1b7b82ULL, 0x000ef00000000800ULL,
0x00009800ff047b82ULL, 0x000f220000000a00ULL, 0x0000000a0e0e7224ULL, 0x004fc400078e0211ULL,
0x0000000010107984ULL, 0x000ea20000000c00ULL, 0x0000000a030a7224ULL, 0x000fe200078e02ffULL,
0x00000654151c7816ULL, 0x002fe2000000001cULL, 0x000000030e187224ULL, 0x000fe400078e02ffULL,
0x0000001b0a1b7224ULL, 0x008fe400078e02ffULL, 0x00000001181e7824ULL, 0x000fc600078e020bULL,
0x000007ff1b197811ULL, 0x040fe400078e40ffULL, 0x01ffffff1b1b7812ULL, 0x000fe400078ec0ffULL,
0x0000001e190b7211ULL, 0x000fca00078fa8ffULL, 0x000008000b0a7825ULL, 0x010fc600078e0004ULL,
0x0000001a0a167210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e060bULL,
0x000000ff0700720cULL, 0x000fe20000725670ULL, 0x000000100d167825ULL, 0x000fe200078e0016ULL,
0x0000000000380947ULL, 0x000ff60003800000ULL, 0x00009800ff147b82ULL, 0x000e620000000a00ULL,
0x00000010071d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff1f7819ULL, 0x000fe20000011607ULL,
0x000000011e0d7824ULL, 0x000fc600078e021bULL, 0x000000701d1d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c1f1f7812ULL, 0x000fe200078ec0ffULL, 0x000000801e0a7825ULL, 0x002fc800078e0014ULL,
0x000000800d147825ULL, 0x000fe200078e0014ULL, 0x0000000a1f0a7210ULL, 0x140fe40007a1e01dULL,
0x000000141f147210ULL, 0x000fe40007c7e01dULL, 0x0000000bff0b7210ULL, 0x000fe400007e44ffULL,
0x00000015ff157210ULL, 0x000fc60001fe84ffULL, 0x000000090a007986ULL, 0x0003e8000c10190aULL,
0x0000000c14007986ULL, 0x0003e4000c10190aULL, 0x0000001016007986ULL, 0x0045e2000c101d0aULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000004c1947ULL, 0x000fea0003800000ULL,
0x00009600ff0a7b82ULL, 0x002e620000000a00ULL, 0xffffffff03097836ULL, 0x000fe40000000000ULL,
0x000000040e0a7825ULL, 0x002fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0003ec0000008000ULL,
0x0000000000007992ULL, 0x002fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x000000090a0a79a8ULL, 0x000ee800099ee1caULL,
0x00000000ff00798fULL, 0x008fe20002000000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x000000090a00720cULL, 0x000fc80003f05270ULL, 0x00000001ff0c7807ULL, 0x000fca0000000000ULL,
0x0000000cff007988ULL, 0x0003e80008000004ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000001c097984ULL, 0x002e640000000000ULL,
0x000000ff0900720cULL, 0x002fda0003f05270ULL, 0x00000024000c8947ULL, 0x000fea0003800000ULL,
0x000000ff4700720cULL, 0x000fda0003f05270ULL, 0x0000000c00300947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x0000000000d88947ULL, 0x000fea0003800000ULL,
0x0000001007097824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011607ULL,
0x00000001180d7836ULL, 0x040fe40000000000ULL, 0x00000080180a7825ULL, 0x100fe200078e0004ULL,
0x0000000c0c157812ULL, 0x000fe400078ec0ffULL, 0x0000007009137812ULL, 0x004fe200078ec0ffULL,
0x000000800d0c7825ULL, 0x000fc600078e0004ULL, 0x0000000a15107210ULL, 0x140fe4000791e013ULL,
0x0000000c150a7210ULL, 0x000fe40007b5e013ULL, 0x0000000bff117210ULL, 0x000fe400007e24ffULL,
0x0000000dff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000a10097981ULL, 0x000368000c1e1900ULL,
0x0000000a0a0a7981ULL, 0x000362000c1e1900ULL, 0x000000020300780cULL, 0x000fda0003f05270ULL,
0x00000000009c8947ULL, 0x002fea0003800000ULL, 0x00000002180d7836ULL, 0x000fc80000000000ULL,
0x000000800d0c7825ULL, 0x000fc600078e0004ULL, 0x0000000c150c7210ULL, 0x000fc8000791e013ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x0000000a0c0c7981ULL, 0x000362000c1e1900ULL,
0x000000040300780cULL, 0x000fda0003f06070ULL, 0x0000000000808947ULL, 0x002fea0003800000ULL,
0x0000000318117836ULL, 0x000fc80000000000ULL, 0x0000008011107825ULL, 0x000fc600078e0004ULL,
0x0000001015107210ULL, 0x000fc8000791e013ULL, 0x00000011ff117210ULL, 0x000fca00007e24ffULL,
0x0000000a100e7981ULL, 0x000362000c1e1900ULL, 0x000000040300780cULL, 0x000fda0003f05270ULL,
0x0000000000648947ULL, 0x002fea0003800000ULL, 0x0000000418117836ULL, 0x000fc80000000000ULL,
0x0000008011107825ULL, 0x000fc600078e0004ULL, 0x0000001015107210ULL, 0x000fc8000791e013ULL,
0x00000011ff117210ULL, 0x000fca00007e24ffULL, 0x0000000a10127981ULL, 0x000362000c1e1900ULL,
0x000000060300780cULL, 0x000fda0003f06070ULL, 0x0000000000488947ULL, 0x002fea0003800000ULL,
0x0000000518117836ULL, 0x000fc80000000000ULL, 0x0000008011107825ULL, 0x000fc600078e0004ULL,
0x0000001015107210ULL, 0x000fc8000791e013ULL, 0x00000011ff117210ULL, 0x000fca00007e24ffULL,
0x0000000a10147981ULL, 0x000362000c1e1900ULL, 0x000000060300780cULL, 0x000fda0003f05270ULL,
0x00000000002c8947ULL, 0x002fea0003800000ULL, 0x000000080300780cULL, 0x000fe20003f06070ULL,
0x0000000618117836ULL, 0x000fc80000000000ULL, 0x0000008011107825ULL, 0x000fc600078e0004ULL,
0x0000001015107210ULL, 0x000fca0007a3e013ULL, 0x00000007180b0836ULL, 0x000fe20000000000ULL,
0x00000011ff117210ULL, 0x000fc60000fe44ffULL, 0x000000800b040825ULL, 0x000fe400078e0004ULL,
0x0000000a10167981ULL, 0x000362000c1e1900ULL, 0x0000000415040210ULL, 0x000fc80007c7e013ULL,
0x00000005ff050210ULL, 0x000fca0001fe84ffULL, 0x0000000a041e0981ULL, 0x000368000c1e1900ULL,
0x0000000703047836ULL, 0x002fca0000000000ULL, 0x00000003ff137819ULL, 0x004fc80000011604ULL,
0x000000ff1300720cULL, 0x000fda0003f05270ULL, 0x0000000800248947ULL, 0x000fea0003800000ULL,
0x00009800ff047b82ULL, 0x000e620000000a00ULL, 0x000000ffff157224ULL, 0x000fe200078e0018ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff207224ULL, 0x020fe200078e0009ULL,
0x0000003f00057c82ULL, 0x000fcc0008000000ULL, 0x0000000403007c0cULL, 0x000fe2000bf23070ULL,
0x0000000105057890ULL, 0x000fcc000fffe03fULL, 0x0000000513007c0cULL, 0x000fcc000bf03070ULL,
0x0000000400f41947ULL, 0x022fee0003800000ULL, 0x0000000804067890ULL, 0x000fe2000fffe03fULL,
0x0000002009097209ULL, 0x000fe20007810000ULL, 0x0000000104077890ULL, 0x000fc8000fffe03fULL,
0x0000000603007c0cULL, 0x040fe4000bf23070ULL, 0x0000000703007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010070b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011607ULL, 0x0000000815117836ULL, 0x000fc60000000000ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x002fe200078e0004ULL,
0x0000000c0d0d7812ULL, 0x000fc800078ec0ffULL, 0x000000100d107210ULL, 0x000fc80007b3e00bULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x0000000a10207981ULL, 0x000368000c1e1900ULL,
0x0000000400b42947ULL, 0x000fea0003800000ULL, 0x0000000904067890ULL, 0x000fe2000fffe03fULL,
0x0000000a09097209ULL, 0x000fe20007810000ULL, 0x0000000204077890ULL, 0x000fc8000fffe03fULL,
0x0000000603007c0cULL, 0x040fe4000bf23070ULL, 0x0000000703007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010070a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x002fe20000011607ULL, 0x00000009150b7836ULL, 0x000fc60000000000ULL,
0x000000700a0d7812ULL, 0x000fe200078ec0ffULL, 0x000000800b0a7825ULL, 0x000fe200078e0004ULL,
0x0000000c10107812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e00dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x0000000a0a0a7981ULL, 0x000368000c1e1900ULL,
0x0000000400742947ULL, 0x000fea0003800000ULL, 0x0000000a04067890ULL, 0x000fe2000fffe03fULL,
0x0000000c09097209ULL, 0x000fe20007810000ULL, 0x0000000304077890ULL, 0x000fc8000fffe03fULL,
0x0000000603007c0cULL, 0x040fe4000bf23070ULL, 0x0000000703007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010070b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011607ULL, 0x0000000a150d7836ULL, 0x000fc60000000000ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e0004ULL,
0x0000000c10107812ULL, 0x000fc800078ec0ffULL, 0x0000000c100c7210ULL, 0x000fc80007b3e00bULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x0000000a0c0c7981ULL, 0x000368000c1e1900ULL,
0x0000000400342947ULL, 0x000fea0003800000ULL, 0x0000000b04067890ULL, 0x000fe2000fffe03fULL,
0x0000000e09097209ULL, 0x000fe20007810000ULL, 0x0000000404077890ULL, 0x000fc8000fffe03fULL,
0x0000000603007c0cULL, 0x040fe4000bf23070ULL, 0x0000000703007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010070b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011607ULL, 0x0000000b15117836ULL, 0x000fc60000000000ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x000fe200078e0004ULL,
0x0000000c0d0d7812ULL, 0x000fc800078ec0ffULL, 0x000000100d107210ULL, 0x000fc80007b3e00bULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x0000000a100e7981ULL, 0x000368000c1e1900ULL,
0x0000000000f42947ULL, 0x000fea0003800000ULL, 0x0000000c04067890ULL, 0x000fe2000fffe03fULL,
0x0000001209097209ULL, 0x000fe20007810000ULL, 0x0000000504077890ULL, 0x000fc8000fffe03fULL,
0x0000000603007c0cULL, 0x040fe4000bf23070ULL, 0x0000000703007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010070b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011607ULL, 0x0000000c15117836ULL, 0x000fc60000000000ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x000fe200078e0004ULL,
0x0000000c0d0d7812ULL, 0x000fc800078ec0ffULL, 0x000000100d107210ULL, 0x000fc80007b3e00bULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x0000000a10127981ULL, 0x000368000c1e1900ULL,
0x0000000000b42947ULL, 0x000fea0003800000ULL, 0x0000000d04067890ULL, 0x000fe2000fffe03fULL,
0x0000001409097209ULL, 0x000fe20007810000ULL, 0x0000000604077890ULL, 0x000fc8000fffe03fULL,
0x0000000603007c0cULL, 0x040fe4000bf23070ULL, 0x0000000703007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010070b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011607ULL, 0x0000000d15117836ULL, 0x000fc60000000000ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x000fe200078e0004ULL,
0x0000000c0d0d7812ULL, 0x000fc800078ec0ffULL, 0x000000100d107210ULL, 0x000fc80007b3e00bULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x0000000a10147981ULL, 0x000368000c1e1900ULL,
0x0000000000742947ULL, 0x000fea0003800000ULL, 0x0000000e04067890ULL, 0x000fe2000fffe03fULL,
0x0000001609097209ULL, 0x000fe20007810000ULL, 0x0000000704077890ULL, 0x000fc8000fffe03fULL,
0x0000000603007c0cULL, 0x040fe4000bf23070ULL, 0x0000000703007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010070b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011607ULL, 0x0000000e15117836ULL, 0x000fc60000000000ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x000fe200078e0004ULL,
0x0000000c0d0d7812ULL, 0x000fc800078ec0ffULL, 0x000000100d107210ULL, 0x000fc80007b3e00bULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x0000000a10167981ULL, 0x000368000c1e1900ULL,
0x0000000000342947ULL, 0x000fea0003800000ULL, 0x0000000f04067890ULL, 0x000fe2000fffe03fULL,
0x0000001e09097209ULL, 0x000fca0007810000ULL, 0x0000000603007c0cULL, 0x000fda000bf23070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x00000010070b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011607ULL, 0x0000000f15117836ULL, 0x000fc60000000000ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x000fe200078e0004ULL,
0x0000000c0d0d7812ULL, 0x000fc800078ec0ffULL, 0x000000100d107210ULL, 0x000fc80007a3e00bULL,
0x00000011ff117210ULL, 0x000fca0000fe44ffULL, 0x0000000a101e7981ULL, 0x000368000c1e1900ULL,
0x0000000804047890ULL, 0x000fe2000fffe03fULL, 0x0000000815157836ULL, 0x000fe20000000000ULL,
0xfffffff400f08947ULL, 0x000ff4000383ffffULL, 0x0000000000077919ULL, 0x000ea40000000000ULL,
0x0000001007047824ULL, 0x006fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x020fc80000011607ULL,
0x0000007004057812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a047812ULL, 0x000fc800078ec0ffULL,
0x0000001c04047210ULL, 0x000fca0007ffe005ULL, 0x0000000904007388ULL, 0x0003e40000000800ULL,
0x00009800ff0a7b82ULL, 0x000ee20000000a00ULL, 0x000000070700780cULL, 0x000fe20003f04070ULL,
0x00000001430c7824ULL, 0x000fe200078e0218ULL, 0x000000010f097812ULL, 0x042fe200078ec0ffULL,
0x000008000f0f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff1e7819ULL, 0x000fe20000011607ULL,
0x00001000451d7824ULL, 0x000fe200078e0208ULL, 0x0000000c19057211ULL, 0x000fe200078fa8ffULL,
0x00000010071f7824ULL, 0x000fe200078e00ffULL, 0x000008000f087812ULL, 0x000fe400078ec0ffULL,
0x0000000000407805ULL, 0x000fc4000001ff00ULL, 0x0000000c1e1e7812ULL, 0x000fe400078ec0ffULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x000000701f1f7812ULL, 0x000fe200078ec0ffULL,
0x00000200430e8824ULL, 0x140fe200078e021cULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000020043108824ULL, 0x004fe200078e021cULL, 0x0000001c1e207210ULL, 0x000fe20007ffe01fULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000100450e8824ULL, 0x040fe200078e020eULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000010045108824ULL, 0x000fe200078e0210ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000011b0f8824ULL, 0x000fe200078e020cULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x0000080005047825ULL, 0x008fe200078e000aULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000080090e8824ULL, 0x040fe200078e020eULL,
0x0000001a04047210ULL, 0x000fe20007f3e0ffULL, 0x0000008009108824ULL, 0x000fe200078e0210ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000011d087824ULL, 0x000fe200078e0208ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0x000000034300720cULL, 0x000fe20003f26070ULL, 0x0000002007097836ULL, 0x000fe20000000000ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x000000800c0c8825ULL, 0x000fe200078e000aULL,
0x0000000000367805ULL, 0x000fc4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000020207984ULL, 0x000e620000000800ULL, 0x000000800f0a8825ULL, 0x000fe200078e000aULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x00000010070f7824ULL, 0x000fe400078e0208ULL, 0x0000001009087825ULL, 0x000fc800078e0004ULL,
0x0000001007047825ULL, 0x000fc800078e0004ULL, 0x00000010070a8825ULL, 0x040fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000040f7faeULL, 0x0005e6000b901c4aULL,
0x0000001007118824ULL, 0x040fe200078e020eULL, 0x00380000080f7faeULL, 0x0005e2000b901c4aULL,
0x00000010070c8825ULL, 0x000fc600078e000cULL, 0x045800000a118faeULL, 0x0005e2000b901c4aULL,
0x0000001007138824ULL, 0x000fe400078e0210ULL, 0x000000ffff217224ULL, 0x000fc600078e00ffULL,
0x041800000c138faeULL, 0x0005e8000b901c4aULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000800a41947ULL, 0x000fea0003800000ULL, 0x00009800ff047b82ULL, 0x004ea20000000a00ULL,
0x00000003ff087819ULL, 0x000fe20000011607ULL, 0x00000200434c7824ULL, 0x000fe200078e021cULL,
0xfffffff8ff097812ULL, 0x000fe200078ee207ULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x0000000308087812ULL, 0x000fe200078ec0ffULL, 0x000000ffff107224ULL, 0x000fe200078e0043ULL,
0x00000002ff4a7819ULL, 0x000fe20000011607ULL, 0x00000008090d7836ULL, 0x040fe20000000000ULL,
0x00000004080a7812ULL, 0x000fe200078efcffULL, 0x0000000809447824ULL, 0x000fe200078e00ffULL,
0x00000007080b7812ULL, 0x000fe200078e7809ULL, 0x000000080d497824ULL, 0x000fe200078e00ffULL,
0x0000000708467812ULL, 0x000fe200078e780dULL, 0x00000100454c7824ULL, 0x000fe200078e024cULL,
0x000000070a097812ULL, 0x000fe200078e7809ULL, 0x000000084a477836ULL, 0x000fe20000000000ULL,
0x000000070a0a7812ULL, 0x000fc400078e780dULL, 0x000000440b427212ULL, 0x080fe400078efcffULL,
0x0000004946467212ULL, 0x080fe400078efcffULL, 0x0000004409447212ULL, 0x000fe400078efcffULL,
0x000000490a497212ULL, 0x004fce00078efcffULL, 0x0000000210487836ULL, 0x000fca0000000000ULL,
0x000000034800720cULL, 0x000fda0003f06070ULL, 0x00000000008c0947ULL, 0x000fea0003800000ULL,
0x00000001180e7824ULL, 0x000fe200078e0248ULL, 0x000000070700780cULL, 0x040fe20003f24070ULL,
0x00000400480a7824ULL, 0x000fe400078e00ffULL, 0x0000002007137836ULL, 0x000fe20000000000ULL,
0x0000000e19097211ULL, 0x000fe400078fa8ffULL, 0x000008000a0a7812ULL, 0x000fc600078ec0ffULL,
0x0000080009087825ULL, 0x000fc800078e0004ULL, 0x0000020043129824ULL, 0x140fe200078e021cULL,
0x0000001a080c7210ULL, 0x000fe20007f1e0ffULL, 0x0000020043149824ULL, 0x000fe200078e021cULL,
0x00000001ff087819ULL, 0x000fe20000011648ULL, 0x00000100454c9824ULL, 0x000fe400078e0212ULL,
0x000000011b0f9824ULL, 0x000fe200078e020eULL, 0x00000001080b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0d7224ULL, 0x000fe400000e0609ULL, 0x000000011d0a7824ULL, 0x000fc400078e020aULL,
0x000000800b129824ULL, 0x000fe400078e024cULL, 0x00000100454c9824ULL, 0x000fe400078e0214ULL,
0x000000800e089825ULL, 0x000fc800078e0004ULL, 0x000000800f0e9825ULL, 0x000fc800078e0004ULL,
0x0000001007117824ULL, 0x000fe400078e020aULL, 0x000000800b149824ULL, 0x000fe400078e024cULL,
0x00000010130a7825ULL, 0x000fc800078e000cULL, 0x00000010070c7825ULL, 0x000fc800078e000cULL,
0x00000010070e9825ULL, 0x040fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000c117faeULL, 0x0005e6000b901c4aULL, 0x0000001007139824ULL, 0x040fe200078e0212ULL,
0x003800000a117faeULL, 0x0005e2000b901c4aULL, 0x0000001007089825ULL, 0x000fc600078e0008ULL,
0x045800000e139faeULL, 0x0005e2000b901c4aULL, 0x0000001007159824ULL, 0x000fca00078e0214ULL,
0x0418000008159faeULL, 0x0005e4000b901c4aULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000004010087824ULL, 0x004fca00078e00ffULL, 0x0000008008087812ULL, 0x000fc800078ec0ffULL,
0x0000004c1f097210ULL, 0x000fe20007ffe008ULL, 0x0000040010087824ULL, 0x000fc800078e00ffULL,
0x000000011e4b7824ULL, 0x000fe200078e0209ULL, 0x0000080008087812ULL, 0x000fc800078ec0ffULL,
0x000001801d157810ULL, 0x000fe20007ffe008ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180004b117984ULL, 0x000ea20000000800ULL, 0x0000001042087824ULL, 0x100fe400078e0215ULL,
0x00000010440c7824ULL, 0x100fe200078e0215ULL, 0x004580004b4e7984ULL, 0x000fe20000000800ULL,
0x0000001046107824ULL, 0x100fe400078e0215ULL, 0x0000001049157824ULL, 0x000fe200078e0215ULL,
0x000000000808783bULL, 0x000ee80000000200ULL, 0x000000000c0c783bULL, 0x000f220000000200ULL,
0x0000001120147221ULL, 0x006fc60000010100ULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x3fb8aa3b14517820ULL, 0x000fc60000410000ULL, 0x000000001514783bULL, 0x000ea20000000200ULL,
0x00007632094d7816ULL, 0x008fe2000000004dULL, 0x000100000a4f7824ULL, 0x000fe200078e00ffULL,
0x0000005100517308ULL, 0x000ee20000000800ULL, 0x00007632084b7816ULL, 0x000fe2000000004bULL,
0x000100000d547824ULL, 0x050fe200078e00ffULL, 0x000076320d537816ULL, 0x000fe20000000053ULL,
0x000100000e557824ULL, 0x040fe200078e00ffULL, 0x000076320e0d7816ULL, 0x000fe2000000000dULL,
0x0001000008087824ULL, 0x000fe200078e00ffULL, 0x000076320f0e7816ULL, 0x000fe2000000000eULL,
0x000100000b527824ULL, 0x040fe200078e00ffULL, 0x000076320b507816ULL, 0x000fe20000000050ULL,
0x000100000f0f7824ULL, 0x000fc800078e00ffULL, 0x00010000500b7824ULL, 0x000fe400078e00ffULL,
0x0000004e515f7220ULL, 0x008fe20000410000ULL, 0x00010000094e7824ULL, 0x000fe200078e00ffULL,
0x000076320a097816ULL, 0x000fe20000000009ULL, 0x000100004b0a7824ULL, 0x000fe400078e00ffULL,
0x000000405f407221ULL, 0x000fe20000010000ULL, 0x00001f4a5f607589ULL, 0x000ee200000e0000ULL,
0x000076320c517816ULL, 0x000fe20000000051ULL, 0x0001000009097824ULL, 0x000fc400078e00ffULL,
0x00001f475f5f7589ULL, 0x000f2200000e0000ULL, 0x000100000c0c7824ULL, 0x000fe200078e00ffULL,
0x0000763210567816ULL, 0x042fe20000000056ULL, 0x0001000010577824ULL, 0x000fe200078e00ffULL,
0x0000763211107816ULL, 0x000fe20000000010ULL, 0x00010000135a7824ULL, 0x040fe200078e00ffULL,
0x0000763213597816ULL, 0x000fe20000000059ULL, 0x00010000145b7824ULL, 0x044fe200078e00ffULL,
0x0000763214137816ULL, 0x000fe20000000013ULL, 0x00010000165d7824ULL, 0x040fe200078e00ffULL,
0x00007632165c7816ULL, 0x000fe2000000005cULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x0000763212587816ULL, 0x040fe20000000058ULL, 0x0001000012127824ULL, 0x000fc400078e00ffULL,
0x00000060092e7223ULL, 0x088fe2000001002eULL, 0x000100000e097824ULL, 0x000fe400078e00ffULL,
0x0000006008217223ULL, 0x080fe20000010021ULL, 0x000100004d087824ULL, 0x000fe200078e00ffULL,
0x0000763215147816ULL, 0x000fe20000000014ULL, 0x0000006009227223ULL, 0x080fe20000010022ULL,
0x0001000010097824ULL, 0x000fe400078e00ffULL, 0x00000060082f7223ULL, 0x000fe2000001002fULL,
0x000000ffff107224ULL, 0x000fe200078e0048ULL, 0x0000763217167816ULL, 0x000fe20000000016ULL,
0x0001000051087824ULL, 0x000fc400078e00ffULL, 0x000000600a337223ULL, 0x080fe20000010033ULL,
0x000000600b2c7223ULL, 0x080fe2000001002cULL, 0x000000031000720cULL, 0x000fe20003f06070ULL,
0x0000006008297223ULL, 0x080fe20000010029ULL, 0x000100000d087824ULL, 0x000fe400078e00ffULL,
0x0000005f09387223ULL, 0x010fe20000010038ULL, 0x0001000015157824ULL, 0x000fe400078e00ffULL,
0x000000604e3b7223ULL, 0x080fe2000001003bULL, 0x0000006008257223ULL, 0x000fe20000010025ULL,
0x00010000175e7824ULL, 0x000fc400078e00ffULL, 0x000000604f367223ULL, 0x080fe20000010036ULL,
0x00010000530a7824ULL, 0x000fe400078e00ffULL, 0x00000060523f7223ULL, 0x080fe2000001003fULL,
0x0001000056567824ULL, 0x000fe400078e00ffULL, 0x000000600c3d7223ULL, 0x080fe2000001003dULL,
0x0001000058587824ULL, 0x000fe400078e00ffULL, 0x0000006054397223ULL, 0x000fe20000010039ULL,
0x0001000059087824ULL, 0x000fc400078e00ffULL, 0x000000600a277223ULL, 0x080fe20000010027ULL,
0x0001000013137824ULL, 0x000fe400078e00ffULL, 0x00000060553e7223ULL, 0x080fe2000001003eULL,
0x0001000014097824ULL, 0x000fe400078e00ffULL, 0x000000600f3c7223ULL, 0x000fe2000001003cULL,
0x000100005c0b7824ULL, 0x000fe400078e00ffULL, 0x0000005f573a7223ULL, 0x000fe2000001003aULL,
0x0001000016167824ULL, 0x000fc400078e00ffULL, 0x0000005f56317223ULL, 0x080fe20000010031ULL,
0x0000005f11307223ULL, 0x080fe20000010030ULL, 0x0000005f12377223ULL, 0x080fe20000010037ULL,
0x0000005f58357223ULL, 0x080fe20000010035ULL, 0x0000005f5a2d7223ULL, 0x080fe2000001002dULL,
0x0000005f082b7223ULL, 0x080fe2000001002bULL, 0x0000005f5b2a7223ULL, 0x080fe2000001002aULL,
0x0000005f13287223ULL, 0x080fe20000010028ULL, 0x0000005f15347223ULL, 0x080fe20000010034ULL,
0x0000005f09327223ULL, 0x080fe20000010032ULL, 0x0000005f5d267223ULL, 0x080fe20000010026ULL,
0x0000005f0b247223ULL, 0x080fe20000010024ULL, 0x0000005f5e237223ULL, 0x080fe20000010023ULL,
0x0000005f16417223ULL, 0x000fe20000010041ULL, 0xfffffff400b48947ULL, 0x000fec000383ffffULL,
0x0000000000037919ULL, 0x000ee20000000000ULL, 0x000000ff4500720cULL, 0x000fe20003f05270ULL,
0x0000001003047824ULL, 0x00cfe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe20000011603ULL,
0x000049801c037836ULL, 0x000fc60000000000ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000305047210ULL, 0x000fe20007ffe004ULL,
0x0000000000200947ULL, 0x000fec0003800000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x00000080431c7824ULL, 0x000fe400078e021cULL, 0x0000001003057824ULL, 0x004fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007005037812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fc800078ec0ffULL, 0x0000001c07037210ULL, 0x000fca0007ffe003ULL,
0x0049804003007388ULL, 0x0005e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000004037984ULL, 0x004ea80000000800ULL, 0x0000800004087984ULL, 0x000ee20000000800ULL,
0x00000003ff037221ULL, 0x004fc80000010000ULL, 0x0000000803037221ULL, 0x008fc80000010000ULL,
0x0180000003057836ULL, 0x000fca0000000000ULL, 0x7f80000005057812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0500780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0003ULL,
0x0000a720000a7802ULL, 0x000fce0000000f00ULL, 0x00000058006c7944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x000fe200078e0007ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000300047308ULL, 0x000ea40000001000ULL, 0xbf80000003057423ULL, 0x004fc80000000004ULL,
0x800000ff05057221ULL, 0x000fc80000010100ULL, 0x0000000504047223ULL, 0x000fce0000000004ULL,
0x0000000000077919ULL, 0x000ea40000000000ULL, 0x00000002ff0d7819ULL, 0x104fe40000011607ULL,
0x0000000807057811ULL, 0x000fe400078ff0ffULL, 0x00000003ff107819ULL, 0x000fe20000011607ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0d04087589ULL, 0x000ea200000e0000ULL,
0xfffffff8ff197812ULL, 0x000fc600078ee207ULL, 0x00001f0504057589ULL, 0x00072400000e0000ULL,
0x00000008191b7836ULL, 0x000fe20000000000ULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x000000081b1a7824ULL, 0x000fe400078e00ffULL, 0x0000002108217220ULL, 0x044fe20000410000ULL,
0x00000033080a7220ULL, 0x040fe20000410000ULL, 0x0000003b08097220ULL, 0x040fe20000410000ULL,
0x0000002f080c7220ULL, 0x042fe20000410000ULL, 0x0000003608367220ULL, 0x040fe20000410000ULL,
0x0000002e08037220ULL, 0x040fe20000410000ULL, 0x0000003f080b7220ULL, 0x040fe20000410000ULL,
0x0000002c082c7220ULL, 0x040fe20000410000ULL, 0x0000003d083d7220ULL, 0x040fe20000410000ULL,
0x0000002908047220ULL, 0x048fe20000410000ULL, 0x00000039080d7220ULL, 0x040fe20000410000ULL,
0x00000027080e7220ULL, 0x040fe20000410000ULL, 0x0000003e083e7220ULL, 0x040fe20000410000ULL,
0x0000002508257220ULL, 0x040fe20000410000ULL, 0x0000003c080f7220ULL, 0x040fe20000410000ULL,
0x0000002208227220ULL, 0x000fe20000410000ULL, 0x0000000310087812ULL, 0x000fe200078ec0ffULL,
0x0000003a053a7220ULL, 0x050fe20000410000ULL, 0x0000003105317220ULL, 0x040fe20000410000ULL,
0x0000003005307220ULL, 0x040fe20000410000ULL, 0x0000000408187812ULL, 0x000fe200078efcffULL,
0x0000003805117220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000003505107220ULL, 0x040fe20000410000ULL, 0x0000002d052d7220ULL, 0x040fe20000410000ULL,
0x0000002b05127220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002805137220ULL, 0x040fe20000410000ULL, 0x0000003405347220ULL, 0x040fe20000410000ULL,
0x0000003205157220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002405177220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000004105147220ULL, 0x000fe20000410000ULL, 0x0000000819057824ULL, 0x000fe200078e00ffULL,
0x0000000708167812ULL, 0x000fc400078e7819ULL, 0x00000007081d7812ULL, 0x000fe400078e781bULL,
0x0000000718087812ULL, 0x000fe400078e7819ULL, 0x00000007181f7812ULL, 0x000fe400078e781bULL,
0x0000000516197212ULL, 0x080fe400078efcffULL, 0x00000005081b7212ULL, 0x000fe400078efcffULL,
0x0000001a1d1d7212ULL, 0x080fe200078efcffULL, 0x0000001019057824ULL, 0x100fe200078e0200ULL,
0x0000001a1f1f7212ULL, 0x000fe200078efcffULL, 0x000000101b167824ULL, 0x100fe200078e0200ULL,
0x000000210a08723eULL, 0x000fe200000010ffULL, 0x000000101d1c7824ULL, 0x100fe200078e0200ULL,
0x000000090c09723eULL, 0x000fe200000010ffULL, 0x000000101f007824ULL, 0x000fe200078e0200ULL,
0x00000036030a723eULL, 0x000fe200000010ffULL, 0x0000000106037824ULL, 0x000fe200078e0207ULL,
0x0000000b2c0b723eULL, 0x000fc400000010ffULL, 0x0000000d0e0d723eULL, 0x000fe400000010ffULL,
0x0000003d040c723eULL, 0x000fe200000010ffULL, 0x0000000805007844ULL, 0x000fe20000000200ULL,
0x0000003e250e723eULL, 0x000fe200000010ffULL, 0x0000001003047824ULL, 0x000fe200078e0202ULL,
0x0000000f220f723eULL, 0x000fe200000010ffULL, 0x000000ff00037306ULL, 0x000e620000202400ULL,
0x0000003a3118723eULL, 0x000fe400000010ffULL, 0x000000301119723eULL, 0x000fe200000010ffULL,
0x0000000c16007844ULL, 0x000fe20000000200ULL, 0x00000037101a723eULL, 0x000fc400000010ffULL,
0x0000002d121b723eULL, 0x000fe400000010ffULL, 0x0000002a1320723eULL, 0x000fe400000010ffULL,
0x000000341521723eULL, 0x000fe200000010ffULL, 0x000000181c007844ULL, 0x000fe20000000200ULL,
0x000000261722723eULL, 0x000fe400000010ffULL, 0x000000231423723eULL, 0x000fca00000010ffULL,
0x0000002000007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000004107984ULL, 0x000e680000000c00ULL, 0x0004000004287984ULL, 0x000ea80000000c00ULL,
0x0008000004247984ULL, 0x000ee80000000c00ULL, 0x000c0000042c7984ULL, 0x000f220000000c00ULL,
0x0000001303137230ULL, 0x002fc40000200800ULL, 0x0000001203127230ULL, 0x040fe40000200800ULL,
0x0000001103117230ULL, 0x040fe40000200800ULL, 0x0000001003107230ULL, 0x040fe40000200800ULL,
0x0000002b032b7230ULL, 0x044fe40000200800ULL, 0x0000002a032a7230ULL, 0x040fe40000200800ULL,
0x0000002903297230ULL, 0x000fc40000200800ULL, 0x0000002803287230ULL, 0x000fe40000200800ULL,
0x0000002713137230ULL, 0x008fe40000200000ULL, 0x0000002612127230ULL, 0x000fe40000200000ULL,
0x0000002511117230ULL, 0x000fe40000200000ULL, 0x0000002410107230ULL, 0x000fe40000200000ULL,
0x0000002f2b2b7230ULL, 0x010fc40000200000ULL, 0x0000002e2a2a7230ULL, 0x000fe20000200000ULL,
0x0000001004007388ULL, 0x0003e20000000c00ULL, 0x0000002d29297230ULL, 0x000fe40000200000ULL,
0x0000002c28287230ULL, 0x000fca0000200000ULL, 0x0004002804007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff4300720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002007117836ULL, 0x006fe20000000000ULL,
0x0000000000067919ULL, 0x000e620000002600ULL, 0x00000003ff107819ULL, 0x000fe20000011607ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x00000003ff047819ULL, 0x000fe20000011611ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000710007812ULL, 0x000fe200078e4807ULL, 0x0000000845127824ULL, 0x000fe200078e00ffULL,
0x0000000704057812ULL, 0x000fe400078e4811ULL, 0x0ffffff800037812ULL, 0x000fc400078ef807ULL,
0x0ffffff805057812ULL, 0x000fe400078ef811ULL, 0xfffffff812117812ULL, 0x000fe200078ee211ULL,
0x0000001003037824ULL, 0x100fe400078e0202ULL, 0x0000001005057824ULL, 0x000fc600078e0202ULL,
0x0000000003087984ULL, 0x0007280000000c00ULL, 0x00000000050c7984ULL, 0x000b220000000c00ULL,
0x00000005040472a4ULL, 0x004fe2000f8e023fULL, 0x0000000806137824ULL, 0x042fe400078e00ffULL,
0x0000000806157824ULL, 0x000fc600078e00ffULL, 0xfffffff813007812ULL, 0x000fe200078ee210ULL,
0x0000000845107824ULL, 0x000fe200078e00ffULL, 0xfffffff815047812ULL, 0x000fe400078ee204ULL,
0x0000000400067c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000404007c10ULL, 0x000fe2000ff3e0ffULL,
0x0000860000047ab9ULL, 0x000fe20000000a00ULL, 0xfffffff810077812ULL, 0x000fe200078ee207ULL,
0x000000ffff037224ULL, 0x008fe200000e06ffULL, 0x0000000406027c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff057224ULL, 0x020fe200008e06ffULL, 0x0000000400047c11ULL, 0x000fc4000f8240ffULL,
0x0000000506037c11ULL, 0x000fe400080f4403ULL, 0x0000000500057c11ULL, 0x000fe200088f4405ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x010fe8000c101d0aULL, 0x0000000c04007986ULL, 0x000fe2000c101d0aULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000040e047824ULL, 0x000fe200078e0247ULL,
0x00009400ff147b82ULL, 0x000e620000000a00ULL, 0x00000001ff0b7424ULL, 0x000fc600078e00ffULL,
0x0000000404007c0cULL, 0x000fe2000bf06070ULL, 0x00f6000b021079a7ULL, 0x000498000850003fULL,
0x00009000ff068b82ULL, 0x000ee20000000800ULL, 0x000000020d058824ULL, 0x000fe200078e00ffULL,
0x0000000a14087981ULL, 0x00256c000c1e9900ULL, 0x00008c00ff128b82ULL, 0x000e620000000a00ULL,
0x0000000605058224ULL, 0x008fc800078e0204ULL, 0x0000000405128825ULL, 0x002fc800078e0012ULL,
0xffffffffff057424ULL, 0x000fcc00078e00ffULL, 0x0000000a12058981ULL, 0x000ee2000c1e1900ULL,
0x000000010e067836ULL, 0x000fca0000000000ULL, 0x0000000506007c0cULL, 0x000fe2000bf06070ULL,
0x000000401a067824ULL, 0x000fe400078e00ffULL, 0x0000004047077824ULL, 0x000fe400078e00ffULL,
0x0000004016097824ULL, 0x000fe400078e00ffULL, 0x00000006052a7224ULL, 0x008fcc00078e02ffULL,
0x0000000400d08947ULL, 0x004fea0003800000ULL, 0x00000002ff247819ULL, 0x100fe20000011600ULL,
0x000001000e0c7824ULL, 0x000fe200078e0207ULL, 0x00008a0000067ab9ULL, 0x000fe20000000a00ULL,
0x00000003ff1b7819ULL, 0x000fe40000011600ULL, 0x0000004016127824ULL, 0x000fe200078e0224ULL,
0x000000090c0f7c48ULL, 0x000fe2000ffe0000ULL, 0x0000000824267836ULL, 0x000fe20000000000ULL,
0x000000031b1b7812ULL, 0x000fe200078e4800ULL, 0x0000000812137836ULL, 0x040fe20000000000ULL,
0x000000122a1c7210ULL, 0x000fe20007f1e0ffULL, 0x0000001012147836ULL, 0x000fe20000000000ULL,
0x000000300a257812ULL, 0x000fe200078ec0ffULL, 0x000000010f0f7824ULL, 0x000fe200078e0a0cULL,
0x000000132a227210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x000000061c187c11ULL, 0x000fe2000f8038ffULL, 0x00002000470c7824ULL, 0x000fe200078e0202ULL,
0x000000142a147210ULL, 0x000fe20007f5e0ffULL, 0x0000003812167836ULL, 0x000fe20000000000ULL,
0x000000071c1c7c11ULL, 0x000fe200080f3c15ULL, 0x000000ffff157224ULL, 0x000fe200008e06ffULL,
0x0000000622217c11ULL, 0x000fe2000f8038ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x0000000614177c11ULL, 0x000fe2000f8238ffULL, 0x000010000c1d7836ULL, 0x000fe20000000000ULL,
0x0000000f2400720cULL, 0x000fe20003f66070ULL, 0x00000018120c7836ULL, 0x000fe20000000000ULL,
0x0000000722227c11ULL, 0x000fe200080f3c15ULL, 0x0000003012157836ULL, 0x000fe20000000000ULL,
0x00000007141a7c11ULL, 0x000fe200088f3c13ULL, 0x0000002012137836ULL, 0x040fe20000000000ULL,
0x0ffffffc1b0a7812ULL, 0x000fe200078ef800ULL, 0x0000002812147836ULL, 0x000fe20000000000ULL,
0x0000001825127210ULL, 0x000fc40007f1e0ffULL, 0x000000132a237210ULL, 0x000fe20007f5e0ffULL,
0x000000100a1f7824ULL, 0x000fe200078e021dULL, 0x0000000c2a0c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e061cULL, 0x000000142a207210ULL, 0x000fe20007fde0ffULL,
0x00000010240a7836ULL, 0x000fe20000000000ULL, 0x000000060c187c11ULL, 0x000fe2000f8838ffULL,
0x000000ffff197224ULL, 0x000fe200008e06ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121f7faeULL, 0x0003e2000d901c4aULL, 0x0000002521147210ULL, 0x000fe40007f7e0ffULL,
0x000000152a1e7210ULL, 0x000fc40007f1e0ffULL, 0x000000162a1c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff157224ULL, 0x000fe200018e0622ULL, 0x000000070c197c11ULL, 0x000fe2000a0f3c19ULL,
0x00000018240c7836ULL, 0x000fe20000000000ULL, 0x0000002517167210ULL, 0x000fe40007f9e0ffULL,
0x0000000f2600720cULL, 0x0c0fe20003f66070ULL, 0x0000000426267824ULL, 0x000fe200078e00ffULL,
0x0000002518187210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200020e061aULL,
0x0000000f0a00720cULL, 0x040fe20003f86070ULL, 0x000000040a127824ULL, 0x002fe200078e00ffULL,
0xfffffffc260a7812ULL, 0x000fe200078ee21bULL, 0x000000040c287824ULL, 0x000fc400078e00ffULL,
0x000000ffff197224ULL, 0x000fe200028e0619ULL, 0x0000000f0c00720cULL, 0x080fe20003fa6070ULL,
0x000000ffff1a7224ULL, 0x000fe200010e06ffULL, 0xfffffffc120c7812ULL, 0x000fe200078ee21bULL,
0x000000100a137824ULL, 0x100fe200078e021dULL, 0xfffffffc28127812ULL, 0x000fe200078ee21bULL,
0x00000020240a7836ULL, 0x000fe20000000000ULL, 0x0000000623227c11ULL, 0x040fe2000f8438ffULL,
0x000000100c1f7824ULL, 0x100fe200078e021dULL, 0x0000000014137faeULL, 0x0003e2000d901c4aULL,
0x0000001012217824ULL, 0x100fe200078e021dULL, 0x0000000723237c11ULL, 0x000fe200090f3c1aULL,
0x0000003024127836ULL, 0x000fe20000000000ULL, 0x0000000f0a00720cULL, 0x0c0fe20003f46070ULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0x00000000161f7faeULL, 0x0005e2000e101c4aULL,
0x00000028240c7836ULL, 0x000fe20000000000ULL, 0x0000000f1200720cULL, 0x080fe20003f86070ULL,
0x00000038241a7836ULL, 0x000fe20000000000ULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee21bULL,
0x0000000412127824ULL, 0x000fe200078e00ffULL, 0x0000000018217faeULL, 0x0007e2000e901c4aULL,
0x0000000f0c00720cULL, 0x0c0fe20003f66070ULL, 0x000000040c0c7824ULL, 0x000fe200078e00ffULL,
0x0000000f1a00720cULL, 0x000fe20003fa6070ULL, 0x000000100a0f7824ULL, 0x100fe200078e021dULL,
0xfffffffc12127812ULL, 0x000fe200078ee21bULL, 0x000000041a147824ULL, 0x002fe200078e00ffULL,
0xfffffffc0c0c7812ULL, 0x000fe200078ee21bULL, 0x000000ffff177224ULL, 0x004fe200000e06ffULL,
0x000000061e167c11ULL, 0x000fe2000f8038ffULL, 0x00000010121f7824ULL, 0x100fe200078e021dULL,
0xfffffffc14147812ULL, 0x000fe200078ee21bULL, 0x000000ffff197224ULL, 0x008fe200030e06ffULL,
0x00000006200a7c11ULL, 0x000fe2000f8c38ffULL, 0x000000100c1b7824ULL, 0x000fe200078e021dULL,
0x000000071e0c7c11ULL, 0x000fe200080f3c17ULL, 0x00000010141d7824ULL, 0x000fe200078e021dULL,
0x0000000720197c11ULL, 0x000fe2000b0f3c19ULL, 0x000000ffff157224ULL, 0x000fe200008e06ffULL,
0x0000002522127210ULL, 0x000fc40007fde0ffULL, 0x000000250a147210ULL, 0x000fe40007f3e0ffULL,
0x0000002516167210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200030e0623ULL,
0x000000061c187c11ULL, 0x000fc6000f8c38ffULL, 0x000000ffff177224ULL, 0x000fe200000e060cULL,
0x000000071c0a7c11ULL, 0x000fe2000b0f3c15ULL, 0x000000ffff157224ULL, 0x000fe200008e0619ULL,
0x0000002518187210ULL, 0x000fe20007f3e0ffULL, 0x00000000120f7faeULL, 0x0003e8000d101c4aULL,
0x000000ffff197224ULL, 0x000fe200008e060aULL, 0x00000000141b7faeULL, 0x0003e8000d901c4aULL,
0x00000000161f7faeULL, 0x0003e8000e101c4aULL, 0x00000000181d7faeULL, 0x0003e2000e901c4aULL,
0x00000004009c7947ULL, 0x000fea0003800000ULL, 0x00000009000c7211ULL, 0x040fe200078ff0ffULL,
0x00008a0000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000800227811ULL, 0x040fe200078ff0ffULL,
0x0000200047207824ULL, 0x000fe200078e0202ULL, 0x0000000c2a0c7210ULL, 0x000fe40007f1e0ffULL,
0x0000001000127811ULL, 0x000fe200078ff0ffULL, 0x00001000202d7836ULL, 0x000fe20000000000ULL,
0x0000002000167811ULL, 0x000fe200078ff0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x000000060c267c11ULL, 0x000fc4000f8038ffULL, 0x0000002800187811ULL, 0x000fe200078ff0ffULL,
0x0000000109157824ULL, 0x040fe200078e0216ULL, 0x000000070c287c11ULL, 0x000fe200080f3c0fULL,
0x00000001090c7824ULL, 0x040fe200078e0222ULL, 0x0000001800147811ULL, 0x040fe200078ff0ffULL,
0x00000001090f7824ULL, 0x040fe200078e0212ULL, 0x00000003ff237819ULL, 0x000fe20000011600ULL,
0x0000000109177824ULL, 0x040fe200078e0218ULL, 0x00000030001a7811ULL, 0x000fe200078ff0ffULL,
0x0000000412127824ULL, 0x000fe200078e00ffULL, 0x00000038001c7811ULL, 0x000fe200078ff0ffULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0x0000000c2a247210ULL, 0x000fe20007fde0ffULL,
0x0000000109137824ULL, 0x040fe200078e0214ULL, 0x0000000323237812ULL, 0x000fe200078e4800ULL,
0x00000004220c7824ULL, 0x000fe200078e00ffULL, 0x0000000f2a1e7210ULL, 0x000fe20007fbe0ffULL,
0x0000000414147824ULL, 0x000fe200078e00ffULL, 0x000000152a1f7210ULL, 0x000fe20007f3e0ffULL,
0x0000000109197824ULL, 0x040fe200078e021aULL, 0xfffffffc12127812ULL, 0x000fe200078ee223ULL,
0x00000001091b7824ULL, 0x000fe200078e021cULL, 0xfffffffc18157812ULL, 0x000fe200078ee223ULL,
0x0000000416167824ULL, 0x000fe200078e00ffULL, 0x000000132a217210ULL, 0x000fe20007f1e0ffULL,
0x000000041a1a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0c0c7812ULL, 0x000fe200078ee223ULL,
0x000000041c1c7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc23187812ULL, 0x000fe200078ef800ULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0x0000000624227c11ULL, 0x000fe2000f8c38ffULL,
0x0000001015297824ULL, 0x100fe200078e022dULL, 0xfffffffc14137812ULL, 0x000fe200078ee223ULL,
0x0000001018317824ULL, 0x000fe200078e022dULL, 0x000000172a1d7210ULL, 0x000fc40007f5e0ffULL,
0xfffffffc16147812ULL, 0x000fe200078ee223ULL, 0x0000001013257824ULL, 0x100fe200078e022dULL,
0xfffffffc1a167812ULL, 0x000fe200078ee223ULL, 0x000000ffff137224ULL, 0x000fe200028e06ffULL,
0xfffffffc1c177812ULL, 0x000fe200078ee223ULL, 0x0000001012237824ULL, 0x000fe200078e022dULL,
0x0000000724247c11ULL, 0x000fe2000b0f3c0fULL, 0x000000100c0f7824ULL, 0x100fe200078e022dULL,
0x000000300a2f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x0000000621187c11ULL, 0x000fe2000f8038ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x000000061f1a7c11ULL, 0x000fe2000f8238ffULL, 0x00000010162b7824ULL, 0x100fe200078e022dULL,
0x000000192a197210ULL, 0x000fe20007f7e0ffULL, 0x0000001014277824ULL, 0x100fe200078e022dULL,
0x0000001b2a1b7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x000000061e167c11ULL, 0x000fe2000f8a38ffULL, 0x00000010172d7824ULL, 0x000fe200078e022dULL,
0x0000000721217c11ULL, 0x000fe200080f3c12ULL, 0x000000ffff0a7224ULL, 0x000fe200020e06ffULL,
0x000000071f1f7c11ULL, 0x000fe200088f3c0cULL, 0x000000ffff0c7224ULL, 0x000fe200018e06ffULL,
0x000000262f127210ULL, 0x000fc40007f1e0ffULL, 0x000000061d1c7c11ULL, 0x000fe4000f8238ffULL,
0x000000071e177c11ULL, 0x000fe2000a8f3c13ULL, 0x000000ffff137224ULL, 0x000fe200000e0628ULL,
0x00000006191e7c11ULL, 0x000fe4000f8438ffULL, 0x000000061b207c11ULL, 0x000fe4000f8638ffULL,
0x000000071d1d7c11ULL, 0x000fe200088f3c14ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012317faeULL, 0x0003e2000b901c4aULL, 0x000000222f147210ULL, 0x000fc40007f1e0ffULL,
0x00000007190c7c11ULL, 0x000fe400090f3c0cULL, 0x000000162f167210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff157224ULL, 0x000fe200000e0624ULL, 0x000000071b0a7c11ULL, 0x000fe400098f3c0aULL,
0x000000182f187210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0617ULL,
0x0000001a2f1a7210ULL, 0x000fe20007f7e0ffULL, 0x00000000140f7faeULL, 0x0003e2000b901c4aULL,
0x0000001c2f1c7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff197224ULL, 0x000fe200010e0621ULL,
0x0000001e2f1e7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e061fULL,
0x000000202f207210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200020e061dULL,
0x0000000016237faeULL, 0x0003e2000b901c4aULL, 0x000000ffff1f7224ULL, 0x000fc400028e060cULL,
0x000000ffff217224ULL, 0x000fe200000e060aULL, 0x0000000018257faeULL, 0x0003e8000b901c4aULL,
0x000000001a277faeULL, 0x0003e8000b901c4aULL, 0x000000001c297faeULL, 0x0003e8000b901c4aULL,
0x000000001e2b7faeULL, 0x0003e8000b901c4aULL, 0x00000000202d7faeULL, 0x0003e4000b901c4aULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00f60011020075a7ULL, 0x000ea2000800017fULL,
0x00000020470a7824ULL, 0x000fc800078e0200ULL, 0x000000100a127824ULL, 0x002fe200078e00ffULL,
0x00000003ff0c7819ULL, 0x000fc8000001160aULL, 0x1ffffffe0c0f7812ULL, 0x000fe400078ec0ffULL,
0x000000f012127812ULL, 0x000fe400078ec0ffULL, 0x000000010f137812ULL, 0x000fe400078efcffULL,
0x000000070f0f7812ULL, 0x000fe400078e780aULL, 0x0000000713137812ULL, 0x000fc600078e780aULL,
0x000000010f0f7824ULL, 0x000fe400078e0212ULL, 0x0000000112137824ULL, 0x000fe400078e0213ULL,
0x000000100f0f7824ULL, 0x000fe200078e0202ULL, 0x0000003800808947ULL, 0x004fec0003800000ULL,
0x0000001013137824ULL, 0x000fe200078e0202ULL, 0x000000000f187984ULL, 0x000e620000000c00ULL,
0x000000050e007c0cULL, 0x000fc6000bf26070ULL, 0x0000000013147984ULL, 0x000ea20000000c00ULL,
0x000000ffff1c7224ULL, 0x002fe400078e0018ULL, 0x000000ffff187224ULL, 0x000fe400078e0019ULL,
0x000000ffff1d7224ULL, 0x000fe400078e001aULL, 0x000000ffff197224ULL, 0x000fe400078e001bULL,
0x000000ffff1e7224ULL, 0x004fe400078e0014ULL, 0x000000ffff1f7224ULL, 0x000fc400078e0016ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0015ULL, 0x000000ffff1b7224ULL, 0x000fe200078e0017ULL,
0x0000001c0f007388ULL, 0x0003e80000000c00ULL, 0x0000001813007388ULL, 0x0003e20000000c00ULL,
0x00f6000b020a79a7ULL, 0x000ea4000850003fULL, 0x00f6000b020075a7ULL, 0x004ea4000800017fULL,
0x0000003800548947ULL, 0x006fea0003800000ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000900000077ab9ULL, 0x000fe20000000800ULL, 0x3db504f308087820ULL, 0x020fe20000410000ULL,
0x00000008470a7824ULL, 0x140fe200078e0202ULL, 0xffffffff05067890ULL, 0x000fe2000fffe03fULL,
0x00000020470b7824ULL, 0x000fe400078e0202ULL, 0x000000ffff0c7224ULL, 0x000fe400078e00ffULL,
0x000000070d0d7c24ULL, 0x000fce000f8e02ffULL, 0x000001000e0f7824ULL, 0x000fca00078e0207ULL,
0x000000090f007c0cULL, 0x000fda000bf01070ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e000cULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fce000001ff00ULL,
0x000000013c127836ULL, 0x000fe40000000000ULL, 0x000000ffff427224ULL, 0x000fe400078e003cULL,
0x0000000605117224ULL, 0x020fe200078e02ffULL, 0x00000001ff0c7819ULL, 0x100fe20000011612ULL,
0x000000ffff3c7224ULL, 0x000fe200078e0012ULL, 0x000000021200780cULL, 0x040fe40003f06070ULL,
0x0000000112407812ULL, 0x000fe200078ec0ffULL, 0x000000030c147224ULL, 0x000fc800078e020eULL,
0x00000001140c7836ULL, 0x000fca0000000000ULL, 0x000000050c007c0cULL, 0x000fe4000bf26070ULL,
0x00000001100c7812ULL, 0x000fd600078e0cffULL, 0x0000000400bc9947ULL, 0x000fea0003800000ULL,
0x00000002ff3e7819ULL, 0x100fe20000011600ULL, 0x0000010014137824ULL, 0x000fe200078e0207ULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x00000003ff417819ULL, 0x000fe20000011600ULL,
0x0000000440437824ULL, 0x000fe400078e00ffULL, 0x000000083e467836ULL, 0x040fe20000000000ULL,
0x0000000913147c48ULL, 0x000fe2000ffe0000ULL, 0x000000103e507836ULL, 0x000fe20000000000ULL,
0xfffffffc43437812ULL, 0x000fe200078ee200ULL, 0x0000000109127824ULL, 0x000fc400078e023eULL,
0x0000000109167824ULL, 0x040fe400078e0246ULL, 0x00000001091c7824ULL, 0x000fe200078e0250ULL,
0x00000012111d7210ULL, 0x000fe20007f3e0ffULL, 0x000000183e527836ULL, 0x000fe20000000000ULL,
0x0000001611167210ULL, 0x000fe20007f5e0ffULL, 0x00000001143d7824ULL, 0x000fe200078e0a13ULL,
0x0000001c111c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0x0000000c1d487c11ULL, 0x000fe2000f8238ffULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x0000000c16447c11ULL, 0x000fe2000f8438ffULL, 0x000000ffff157224ULL, 0x000fe200018e06ffULL,
0x0000000c1c127c11ULL, 0x000fe2000f8638ffULL, 0x0000000109147824ULL, 0x000fe200078e0252ULL,
0x0000000d1d497c11ULL, 0x000fe200088f3c1eULL, 0x000000203e547836ULL, 0x000fe20000000000ULL,
0x0000000d16457c11ULL, 0x000fe200090f3c17ULL, 0x000000283e567836ULL, 0x000fe20000000000ULL,
0x0000000d1c137c11ULL, 0x000fe200098f3c15ULL, 0x000000303e587836ULL, 0x040fe20000000000ULL,
0x0000003d3e00720cULL, 0x040fe20003f46070ULL, 0x000000383e5a7836ULL, 0x000fe20000000000ULL,
0x0000001411147210ULL, 0x000fe20007f3e0ffULL, 0x0000000109167824ULL, 0x000fc400078e0254ULL,
0x00000001091c7824ULL, 0x040fe400078e0256ULL, 0x00000001091e7824ULL, 0x040fe200078e0258ULL,
0x00000016111f7210ULL, 0x000fe20007fbe0ffULL, 0x00000001093e7824ULL, 0x000fe200078e025aULL,
0x0000001c113f7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x0000001e111d7210ULL, 0x000fe20007f9e0ffULL, 0x0000001043487825ULL, 0x000fe200078e0048ULL,
0x0000000c14167c11ULL, 0x000fe4000f8238ffULL, 0x0000003e11157210ULL, 0x000fe20007f7e0ffULL,
0x0000200047117824ULL, 0x000fe200078e0202ULL, 0x00000000411c7212ULL, 0x000fe200078e3cffULL,
0x00000004463e7824ULL, 0x000fe200078e00ffULL, 0x0000000d14177c11ULL, 0x000fe200088f3c17ULL,
0x000010000c147824ULL, 0x000fe200078e0211ULL, 0x000000031c4f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1c7224ULL, 0x000fe200028e06ffULL, 0x0000003d4600720cULL, 0x000fe20003f26070ULL,
0x0000100014467836ULL, 0x000fe20000000000ULL, 0x0ffffffc4f4b7812ULL, 0x000fe200078ef800ULL,
0x0000001043447825ULL, 0x000fe200078e0044ULL, 0xfffffffc3e4d7812ULL, 0x000fc400078ee24fULL,
0x0000000c1f1e7c11ULL, 0x000fe2000f8a38ffULL, 0x000000104b4b7824ULL, 0x100fe400078e0246ULL,
0x000000104d4d7824ULL, 0x000fe200078e0246ULL, 0x0000000d1f1f7c11ULL, 0x000fe2000a8f3c1cULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0x0000000c15147c11ULL, 0x000fe2000f8638ffULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x0000000c1d1c7c11ULL, 0x000fe2000f8838ffULL,
0x000000ffff4e7224ULL, 0x000fe200030e06ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000484b7faeULL, 0x000fe2000d101c4aULL, 0x0000000c3f3e7c11ULL, 0x000fe2000f8a38ffULL,
0x0000001043127825ULL, 0x000fe200078e0012ULL, 0x0000000d15157c11ULL, 0x000fe200098f3c4aULL,
0x00000000444d7faeULL, 0x0003e2000c901c4aULL, 0x0000003d5000720cULL, 0x0c0fe20003f26070ULL,
0x0000000450507824ULL, 0x000fe200078e00ffULL, 0x0000003d5200720cULL, 0x0c0fe20003f46070ULL,
0x0000000452527824ULL, 0x000fe200078e00ffULL, 0x0000000d1d1d7c11ULL, 0x000fe2000a0f3c4cULL,
0x0000001043167825ULL, 0x000fe200078e0016ULL, 0x0000003d5400720cULL, 0x000fc40003f66070ULL,
0x0000000d3f3f7c11ULL, 0x000fe2000a8f3c4eULL, 0x0000000454547824ULL, 0x000fe200078e00ffULL,
0x0000003d5600720cULL, 0x0c0fe20003f86070ULL, 0x0000000456567824ULL, 0x000fe200078e00ffULL,
0x0000003d5800720cULL, 0x0c0fe20003fa6070ULL, 0x0000000458587824ULL, 0x000fe200078e00ffULL,
0x0000003d5a00720cULL, 0x040fe20003fc6070ULL, 0x000000045a5a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc503d7812ULL, 0x000fe200078ee24fULL, 0x00000010431e7825ULL, 0x000fe200078e001eULL,
0xfffffffc52457812ULL, 0x002fc400078ee24fULL, 0xfffffffc54497812ULL, 0x000fe200078ee24fULL,
0x000000103d3d7824ULL, 0x100fe200078e0246ULL, 0xfffffffc564b7812ULL, 0x000fe200078ee24fULL,
0x0000001045457824ULL, 0x100fe200078e0246ULL, 0xfffffffc584d7812ULL, 0x000fe200078ee24fULL,
0x0000001049497824ULL, 0x100fe200078e0246ULL, 0xfffffffc5a4f7812ULL, 0x000fe200078ee24fULL,
0x000000104b4b7824ULL, 0x000fe200078e0246ULL, 0x00000000123d7faeULL, 0x0003e2000c901c4aULL,
0x00000010433e7825ULL, 0x000fc600078e003eULL, 0x0000000016457faeULL, 0x0003e2000d101c4aULL,
0x000000104d4d7824ULL, 0x000fe400078e0246ULL, 0x00000010431c7825ULL, 0x000fe200078e001cULL,
0x000000001e497faeULL, 0x0003e6000d901c4aULL, 0x000000104f4f7824ULL, 0x000fe200078e0246ULL,
0x000000003e4b7faeULL, 0x0003e2000e101c4aULL, 0x0000001043147825ULL, 0x000fc600078e0014ULL,
0x000000001c4d7faeULL, 0x0003e8000e901c4aULL, 0x00000000144f7faeULL, 0x0003e2000f101c4aULL,
0x0000000400887947ULL, 0x000fea0003800000ULL, 0x0000001000507811ULL, 0x040fe200078ff0ffULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x00000008004e7811ULL, 0x000fe200078ff0ffULL,
0x0000000440557824ULL, 0x000fe200078e00ffULL, 0x0000000900167211ULL, 0x040fe200078ff0ffULL,
0x0000000109127824ULL, 0x040fe200078e0250ULL, 0x0000001800527811ULL, 0x000fe200078ff0ffULL,
0x0000000109147824ULL, 0x000fe200078e024eULL, 0x0000001116167210ULL, 0x000fe20007f3e0ffULL,
0x000000044e4e7824ULL, 0x000fe200078e00ffULL, 0x0000001112127210ULL, 0x000fe20007f7e0ffULL,
0x0000000450507824ULL, 0x000fe200078e00ffULL, 0x0000001114147210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e06ffULL, 0x0000000c16447c11ULL, 0x000fe2000f8238ffULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x0000000c121e7c11ULL, 0x000fe2000f8638ffULL,
0x000000ffff157224ULL, 0x000fe200010e06ffULL, 0x0000000c143e7c11ULL, 0x000fc4000f8438ffULL,
0x0000000d121f7c11ULL, 0x000fe200098f3c13ULL, 0x0000000109127824ULL, 0x040fe200078e0252ULL,
0x0000002000547811ULL, 0x000fe200078ff0ffULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x0000002800567811ULL, 0x040fe400078ff0ffULL, 0x0000003000587811ULL, 0x040fe400078ff0ffULL,
0x00000038005a7811ULL, 0x000fe400078ff0ffULL, 0x0000000d16457c11ULL, 0x000fe200088f3c17ULL,
0x0000000109167824ULL, 0x040fe200078e0256ULL, 0x0000000d143f7c11ULL, 0x000fe200090f3c15ULL,
0x0000000109147824ULL, 0x040fe200078e0254ULL, 0x0000001112127210ULL, 0x000fe20007f3e0ffULL,
0x0000000109467824ULL, 0x040fe200078e0258ULL, 0x0000001116157210ULL, 0x000fe20007fbe0ffULL,
0x0000000109487824ULL, 0x000fe200078e025aULL, 0x0000001114177210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e06ffULL, 0x00000003ff417819ULL, 0x000fe20000011600ULL,
0x000000ffff4a7224ULL, 0x000fe200028e06ffULL, 0x0000001146137210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x0000001148467210ULL, 0x000fe20007f3e0ffULL,
0x0000200047117824ULL, 0x000fe200078e0202ULL, 0x00000000413d7212ULL, 0x000fe200078e3cffULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0x0000000c121c7c11ULL, 0x000fe2000f8638ffULL,
0x0000000456567824ULL, 0x000fe200078e00ffULL, 0x0000000c15147c11ULL, 0x000fe2000f8838ffULL,
0x000010000c437824ULL, 0x000fe200078e0211ULL, 0x000000033d3d7812ULL, 0x000fe200078ec0ffULL,
0x0000000458587824ULL, 0x000fe200078e00ffULL, 0x0000000d121d7c11ULL, 0x000fe200098f3c1dULL,
0x000000045a5a7824ULL, 0x000fe200078e00ffULL, 0x0000000d15157c11ULL, 0x000fe2000a0f3c4aULL,
0x000000ffff487224ULL, 0x000fe200010e06ffULL, 0x0000000c13127c11ULL, 0x000fe2000f8438ffULL,
0x00001000434a7836ULL, 0x000fe20000000000ULL, 0xfffffffc4e437812ULL, 0x000fe200078ee23dULL,
0x000000ffff497224ULL, 0x000fe200008e06ffULL, 0xfffffffc504b7812ULL, 0x000fc400078ee23dULL,
0xfffffffc524d7812ULL, 0x000fe400078ee23dULL, 0xfffffffc544f7812ULL, 0x000fe400078ee23dULL,
0xfffffffc56517812ULL, 0x000fe400078ee23dULL, 0xfffffffc58537812ULL, 0x000fe400078ee23dULL,
0xfffffffc5a597812ULL, 0x000fe400078ee23dULL, 0x0000000c17167c11ULL, 0x000fc4000f8638ffULL,
0xfffffffc55557812ULL, 0x000fe400078ee200ULL, 0x0ffffffc3d3d7812ULL, 0x000fe400078ef800ULL,
0x0000000d13137c11ULL, 0x000fe200090f3c48ULL, 0x0000001055447825ULL, 0x000fe200078e0044ULL,
0x0000000c46487c11ULL, 0x040fe4000f8238ffULL, 0x0000000d17177c11ULL, 0x000fe200098f3c4cULL,
0x000000103d577824ULL, 0x100fe200078e024aULL, 0x0000000d46497c11ULL, 0x000fe200088f3c49ULL,
0x00000010433d7824ULL, 0x000fc400078e024aULL, 0x00000010553e7825ULL, 0x000fe200078e003eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044577faeULL, 0x0003e6000b901c4aULL,
0x000000104b437824ULL, 0x000fe200078e024aULL, 0x000000003e3d7faeULL, 0x0003e2000b901c4aULL,
0x00000010551e7825ULL, 0x000fc800078e001eULL, 0x000000104d4b7824ULL, 0x000fe200078e024aULL,
0x000000001e437faeULL, 0x0003e2000b901c4aULL, 0x00000010551c7825ULL, 0x000fc800078e001cULL,
0x000000104f4d7824ULL, 0x000fe200078e024aULL, 0x000000001c4b7faeULL, 0x0003e2000b901c4aULL,
0x0000001055167825ULL, 0x000fc800078e0016ULL, 0x00000010514f7824ULL, 0x000fe200078e024aULL,
0x00000000164d7faeULL, 0x0003e2000b901c4aULL, 0x0000001055147825ULL, 0x000fc800078e0014ULL,
0x0000001053517824ULL, 0x000fe200078e024aULL, 0x00000000144f7faeULL, 0x0003e2000b901c4aULL,
0x0000001055127825ULL, 0x000fc800078e0012ULL, 0x0000001059537824ULL, 0x000fe200078e024aULL,
0x0000000012517faeULL, 0x0003e2000b901c4aULL, 0x0000001055487825ULL, 0x000fca00078e0048ULL,
0x0000000048537faeULL, 0x0003e4000b901c4aULL, 0x000000ff4000720cULL, 0x000fda0003f25270ULL,
0x0000000000209947ULL, 0x000fea0003800000ULL, 0x0000000403047824ULL, 0x000fe400078e0204ULL,
0xffffffffff057424ULL, 0x000fc600078e00ffULL, 0x0000000404007c0cULL, 0x000fda000bf26070ULL,
0x0000000000101947ULL, 0x000fea0003800000ULL, 0x00008c00ff127b82ULL, 0x002e620000000a00ULL,
0x000000020d057824ULL, 0x000fc800078e0204ULL, 0x0000000405127825ULL, 0x002fca00078e0012ULL,
0x0000000a12057981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002000137836ULL, 0x042fe20000000000ULL, 0xfffffff800437812ULL, 0x000fe200078ec0ffULL,
0x0000100010407824ULL, 0x000fe200078e0211ULL, 0x0000000700457812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ec0ffULL,
0x0000100040407836ULL, 0x000fe20000000000ULL, 0x0000000743437812ULL, 0x000fe400078ef800ULL,
0x0000000713447812ULL, 0x000fc400078ef800ULL, 0x00000001ff3e7819ULL, 0x000fe40000011643ULL,
0x00000001ff467819ULL, 0x000fe40000011644ULL, 0x00000008453f7812ULL, 0x000fe400078ef800ULL,
0x000000033e3e7812ULL, 0x000fe400078ec0ffULL, 0x0000000346467812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fcc0000000000ULL, 0x0000003d3e107212ULL, 0x080fe200078e3cffULL,
0x000000013d497836ULL, 0x000fe20000000000ULL, 0x0000003d46157212ULL, 0x000fe200078e3cffULL,
0x0000000442617824ULL, 0x000fe400078e023dULL, 0x0000000443117824ULL, 0x000fe400078e0210ULL,
0x0000000444157824ULL, 0x000fe400078e0215ULL, 0x0000001011117824ULL, 0x100fe400078e0240ULL,
0x0000001015157824ULL, 0x000fc400078e0240ULL, 0x0000000261617824ULL, 0x000fe400078e00ffULL,
0x000000001110783bULL, 0x000e620000000200ULL, 0x000000023d3d7836ULL, 0x000fc60000000000ULL,
0x000000001514783bULL, 0x000ea40000000200ULL, 0x000000043d00780cULL, 0x000fe40003f25270ULL,
0x00000018ff577819ULL, 0x002fe20000011410ULL, 0x00010000101c7824ULL, 0x040fe200078e00ffULL,
0x0000888010537816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011411ULL, 0x00010000111d7824ULL, 0x040fe200078e00ffULL,
0x0000888011607816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005700577306ULL, 0x000fe20000202400ULL,
0x00000018ff647819ULL, 0x000fc40000011412ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00008880125f7816ULL, 0x000fe400000000ffULL, 0x00000018ff687819ULL, 0x000fe20000011413ULL,
0x00000010005e7306ULL, 0x0003e20000202400ULL, 0x0000888013737816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff677819ULL, 0x004fe20000011414ULL, 0x00000011005d7306ULL, 0x0005e20000202400ULL,
0x0001000012107824ULL, 0x002fe200078e00ffULL, 0x00008880146f7816ULL, 0x000fe200000000ffULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe40000011415ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0001000013117824ULL, 0x044fe200078e00ffULL, 0x0000001c005a7306ULL, 0x000fe20000202400ULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x00008880156d7816ULL, 0x000fc400000000ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000001200757306ULL, 0x0003e20000202400ULL, 0x00000018ff5b7819ULL, 0x000fe40000011416ULL,
0x00000018ff487819ULL, 0x000fe40000011417ULL, 0x0000888016697816ULL, 0x000fe400000000ffULL,
0x0000888017627816ULL, 0x000fe200000000ffULL, 0x0000001300717306ULL, 0x0005e20000202400ULL,
0x000000493e127212ULL, 0x002fc400078e3cffULL, 0x0000004946497212ULL, 0x000fca00078e3cffULL,
0x0000001d00777306ULL, 0x0003e20000202400ULL, 0x0000000443137824ULL, 0x004fe400078e0212ULL,
0x0000000444497824ULL, 0x000fe400078e0249ULL, 0x0000001013137824ULL, 0x100fe400078e0240ULL,
0x0000001049127824ULL, 0x000fe200078e0240ULL, 0x0000001000767306ULL, 0x0005e40000202400ULL,
0x00000000131c783bULL, 0x002e6c0000000200ULL, 0x0000001100747306ULL, 0x0007e20000202400ULL,
0x0001000014107824ULL, 0x004fc400078e00ffULL, 0x0000010014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0001000015117824ULL, 0x048fe200078e00ffULL, 0x0000001000727306ULL, 0x0005e20000202400ULL,
0x0000010015157824ULL, 0x000fc600078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000001400707306ULL, 0x0007e20000202400ULL,
0x0001000016107824ULL, 0x044fe400078e00ffULL, 0x0000010016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe40000011410ULL, 0x00000015006b7306ULL, 0x0003e20000202400ULL,
0x0001000017147824ULL, 0x048fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000010017177824ULL, 0x000fc600078e00ffULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x000100001c157824ULL, 0x002fe200078e00ffULL,
0x0000001400657306ULL, 0x0003e20000202400ULL, 0x00000018ff497819ULL, 0x000fe2000001141cULL,
0x000100001d557824ULL, 0x040fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe2000001141dULL,
0x000100001e597824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011415ULL,
0x000088801c4b7816ULL, 0x000fe200000000ffULL, 0x00000016006a7306ULL, 0x000fe20000202400ULL,
0x0000006100147211ULL, 0x002fe200078fe0ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x000088801d527816ULL, 0x040fe200000000ffULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x0000000714147812ULL, 0x000fe200078e783fULL, 0x0000000261617836ULL, 0x000fe20000000000ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000001700637306ULL, 0x0003e20000202400ULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x000000103f157824ULL, 0x000fe200078e0214ULL,
0x00000018ff507819ULL, 0x000fc4000001141eULL, 0x000088801e787816ULL, 0x040fe200000000ffULL,
0x0000001015157824ULL, 0x000fe200078e0202ULL, 0x00000018ff4f7819ULL, 0x000fe2000001141fULL,
0x0000005300537306ULL, 0x000ea20000202400ULL, 0x000001001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x000000001514783bULL, 0x002e640000000200ULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x00000011006e7306ULL, 0x0007f00000202400ULL,
0x0000001c00567306ULL, 0x0005e20000202400ULL, 0x000000001210783bULL, 0x008eee0000000200ULL,
0x0000001d00587306ULL, 0x0009e20000202400ULL, 0x00005410531c7816ULL, 0x004fc4000000005aULL,
0x00000018ff5a7819ULL, 0x000fca0000011459ULL, 0x0000005c005c7306ULL, 0x000ea20000202400ULL,
0x000054105e1d7816ULL, 0x010fe40000000057ULL, 0x000088801f577816ULL, 0x000fca00000000ffULL,
0x0000006000607306ULL, 0x000f220000202400ULL, 0x0000001c1438723cULL, 0x002fee0000041838ULL,
0x0000006400647306ULL, 0x000e620000202400ULL, 0x000100001f1c7824ULL, 0x000fe200078e00ffULL,
0x000054105d1d7816ULL, 0x004fe2000000005cULL, 0x000001001f1f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000005f005f7306ULL, 0x000ea20000202400ULL,
0x00000018ff4e7819ULL, 0x008fe40000011410ULL, 0x00008880105d7816ULL, 0x000fe400000000ffULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00000018ff4d7819ULL, 0x000fe20000011411ULL,
0x0000001c005e7306ULL, 0x0009e20000202400ULL, 0x00000018ff4c7819ULL, 0x000fc40000011412ULL,
0x00000018ff4a7819ULL, 0x000fca0000011413ULL, 0x0000006800687306ULL, 0x000ee20000202400ULL,
0x00005410601c7816ULL, 0x010fce0000000077ULL, 0x0000001c1434723cULL, 0x000fe20000041834ULL,
0x0000007300737306ULL, 0x000f2c0000202400ULL, 0x00010000101d7824ULL, 0x040fe400078e00ffULL,
0x00000100101c7824ULL, 0x000fe200078e00ffULL, 0x0000006100107211ULL, 0x000fe200078fe0ffULL,
0x0000001e00597306ULL, 0x0003e20000202400ULL, 0x00000018ff607819ULL, 0x000fc4000001141dULL,
0x0000000710107812ULL, 0x000fe400078e783fULL, 0x00000018ff1c7819ULL, 0x000fc6000001141cULL,
0x000000103f1d7824ULL, 0x000fe200078e0210ULL, 0x00008880111e7816ULL, 0x002fe200000000ffULL,
0x0000006f006f7306ULL, 0x000e680000202400ULL, 0x000000ffff107224ULL, 0x000fe400078e001eULL,
0x000000101d1e7824ULL, 0x000fe200078e0202ULL, 0x00005410751d7816ULL, 0x000fe20000000064ULL,
0x0000001c00617306ULL, 0x0005e20000202400ULL, 0x0000010011757824ULL, 0x000fce00078e00ffULL,
0x0000001f005c7306ULL, 0x0003e20000202400ULL, 0x000054105f1c7816ULL, 0x004fce0000000076ULL,
0x0000006700677306ULL, 0x000ea20000202400ULL, 0x00010000111f7824ULL, 0x002fe200078e00ffULL,
0x0000541071117816ULL, 0x008fe20000000068ULL, 0x0000001c1430723cULL, 0x000fe20000041830ULL,
0x00000018ff687819ULL, 0x000fe40000011475ULL, 0x00000018ff647819ULL, 0x000fe4000001141fULL,
0x00000010005f7306ULL, 0x0009e20000202400ULL, 0x000000001e1c783bULL, 0x000e6e0000000200ULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x0000541073107816ULL, 0x010fce0000000074ULL,
0x0000006d006d7306ULL, 0x000ee20000202400ULL, 0x00000010142c723cULL, 0x000fee000004182cULL,
0x0000888012117816ULL, 0x000fe200000000ffULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x000054106f107816ULL, 0x000fc60000000072ULL, 0x000000ffff6f7224ULL, 0x000fe200078e0011ULL,
0x0000541070117816ULL, 0x004fe20000000067ULL, 0x0001000012707824ULL, 0x000fe400078e00ffULL,
0x0000006900697306ULL, 0x000fe60000202400ULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x000000101428723cULL, 0x000fe80000041828ULL, 0x0000006c006c7306ULL, 0x000ea60000202400ULL,
0x000054106d107816ULL, 0x008fc4000000006eULL, 0x000054106b117816ULL, 0x000fc60000000066ULL,
0x0000004800487306ULL, 0x000fe80000202400ULL, 0x000000101424723cULL, 0x000fe80000041824ULL,
0x0000006200627306ULL, 0x000ee60000202400ULL, 0x0000010012117824ULL, 0x000fe200078e00ffULL,
0x0000541069107816ULL, 0x004fc4000000006cULL, 0x0000888013697816ULL, 0x000fe400000000ffULL,
0x00000018ff667819ULL, 0x000fe20000011411ULL, 0x0000005100517306ULL, 0x000ea20000202400ULL,
0x000054106a117816ULL, 0x000fce000000005bULL, 0x000000101420723cULL, 0x000fe20000041820ULL,
0x0000005200527306ULL, 0x000fec0000202400ULL, 0x0000541062107816ULL, 0x008fe40000000065ULL,
0x0000541063117816ULL, 0x000fe20000000048ULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x000000ffff487224ULL, 0x000fca00078e0069ULL, 0x000000101418723cULL, 0x000fe40000041818ULL,
0x0000007800537306ULL, 0x000fea0000202400ULL, 0x0000010013157824ULL, 0x040fe200078e00ffULL,
0x0000541058117816ULL, 0x004fe20000000051ULL, 0x0001000013107824ULL, 0x000fe200078e00ffULL,
0x0000005a005a7306ULL, 0x000ea40000202400ULL, 0x00000018ff157819ULL, 0x000fc40000011415ULL,
0x00000018ff107819ULL, 0x000fc80000011410ULL, 0x0000004900497306ULL, 0x000ee20000202400ULL,
0x0000541053587816ULL, 0x004fce000000005aULL, 0x0000005000507306ULL, 0x000ea20000202400ULL,
0x0000541056497816ULL, 0x008fce0000000049ULL, 0x0000004f004f7306ULL, 0x000fe20000202400ULL,
0x0000541059597816ULL, 0x004fce0000000050ULL, 0x0000004e004e7306ULL, 0x000ea20000202400ULL,
0x000000581c30723cULL, 0x002fee0000041830ULL, 0x0000004d004d7306ULL, 0x000fe20000202400ULL,
0x0000541061617816ULL, 0x004fce000000004eULL, 0x0000004c004c7306ULL, 0x000ff00000202400ULL,
0x0000004a004a7306ULL, 0x000ff00000202400ULL, 0x0000004b004b7306ULL, 0x000ff00000202400ULL,
0x0000005400547306ULL, 0x000ff00000202400ULL, 0x0000005700577306ULL, 0x000ff00000202400ULL,
0x0000005d005d7306ULL, 0x000ff00000202400ULL, 0x0000006000607306ULL, 0x000e700000202400ULL,
0x0000006400647306ULL, 0x000ea20000202400ULL, 0x000054105d607816ULL, 0x002fce0000000060ULL,
0x0000006800687306ULL, 0x000e620000202400ULL, 0x000000601c28723cULL, 0x000fe20000041828ULL,
0x000054105f647816ULL, 0x004fcc0000000064ULL, 0x0000006f00677306ULL, 0x000fe20000202400ULL,
0x0000541068657816ULL, 0x002fce000000004dULL, 0x0000007000127306ULL, 0x000e620000202400ULL,
0x000000641c24723cULL, 0x000fee0000041824ULL, 0x00000066005b7306ULL, 0x000ea20000202400ULL,
0x00005410675a7816ULL, 0x002fce0000000012ULL, 0x0000004800147306ULL, 0x0003e20000202400ULL,
0x000054105b5b7816ULL, 0x004fce000000004cULL, 0x0000001000137306ULL, 0x0004e20000202400ULL,
0x000054104b487816ULL, 0x002fe20000000054ULL, 0x0000005a1c20723cULL, 0x000fec0000041820ULL,
0x0000001500157306ULL, 0x000e620000202400ULL, 0x0000541052107816ULL, 0x004fe20000000055ULL,
0x000000481c38723cULL, 0x000fe20000041838ULL, 0x0000541014147816ULL, 0x008fca0000000013ULL,
0x000000101c34723cULL, 0x000fe20000041834ULL, 0x0000541015157816ULL, 0x002fcc000000004aULL,
0x0000541057107816ULL, 0x000fe4000000005eULL, 0x000054105c117816ULL, 0x000fe2000000004fULL,
0x000000141c18723cULL, 0x000fec0000041818ULL, 0x000000101c2c723cULL, 0x000fe2000004182cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff0002c1947ULL, 0x000fde000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000cULL, 0xffffffe000488947ULL, 0x000fec000383ffffULL,
0x00000001ff3c7424ULL, 0x000fe400078e00ffULL, 0x0000000828167220ULL, 0x080fe20000410000ULL,
0x0000000400127824ULL, 0x000fe400078e00ffULL, 0x000000082d147220ULL, 0x080fe20000410000ULL,
0x00f6883c0a1079a7ULL, 0x000e62000850003fULL, 0x0000008047137824ULL, 0x000fe400078e0202ULL,
0x0000000829177220ULL, 0x080fe20000410000ULL, 0xfffffff012127812ULL, 0x000fe200078ec0ffULL,
0x00000008241c7220ULL, 0x080fe20000410000ULL, 0x00000008251d7220ULL, 0x080fe20000410000ULL,
0x0000000826287220ULL, 0x080fe20000410000ULL, 0x0000000838157220ULL, 0x080fe20000410000ULL,
0x0000000839397220ULL, 0x080fe20000410000ULL, 0x000000083a3a7220ULL, 0x080fe20000410000ULL,
0x000000083b3b7220ULL, 0x080fe20000410000ULL, 0x0000000834347220ULL, 0x080fe20000410000ULL,
0x0000000835357220ULL, 0x080fe20000410000ULL, 0x0000000836367220ULL, 0x080fe20000410000ULL,
0x0000000837377220ULL, 0x080fe20000410000ULL, 0x0000000830307220ULL, 0x080fe20000410000ULL,
0x0000000831317220ULL, 0x080fe20000410000ULL, 0x0000000832327220ULL, 0x080fe20000410000ULL,
0x0000000833337220ULL, 0x080fe20000410000ULL, 0x000000082c2c7220ULL, 0x080fe20000410000ULL,
0x000000082e2e7220ULL, 0x080fe20000410000ULL, 0x000000082f2f7220ULL, 0x080fe20000410000ULL,
0x000000082a2a7220ULL, 0x080fe20000410000ULL, 0x000000082b2b7220ULL, 0x080fe20000410000ULL,
0x00f688110a0075a7ULL, 0x002e62000800017fULL, 0x0000000827277220ULL, 0x080fe20000410000ULL,
0x0000000820207220ULL, 0x080fe20000410000ULL, 0x0000000821217220ULL, 0x080fe20000410000ULL,
0x0000000822257220ULL, 0x080fe20000410000ULL, 0x0000000823267220ULL, 0x000fe20000410000ULL,
0x0000000113247824ULL, 0x000fc400078e0212ULL, 0x0000000818187220ULL, 0x080fe20000410000ULL,
0x0000000819197220ULL, 0x080fe20000410000ULL, 0x000000081a2d7220ULL, 0x080fe20000410000ULL,
0x000000081b297220ULL, 0x000fe20000410000ULL, 0x0000001400a08947ULL, 0x002fec0003800000ULL,
0x00f4000024107984ULL, 0x0002a20000000c00ULL, 0x000000060e007c0cULL, 0x000fda000bf05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x00000002001a7824ULL, 0x000fe200078e00ffULL,
0x000000090f0f7c10ULL, 0x000fc8000fffe1ffULL, 0x000000061a1a7812ULL, 0x000fc800078ec0ffULL,
0x000000011a1e7812ULL, 0x040fe400078efcffULL, 0x000000081a227812ULL, 0x000fe400078efcffULL,
0x0000000f1e00720cULL, 0x080fe40003f26070ULL, 0x000000101a1e7812ULL, 0x000fe400078efcffULL,
0x0000000f2200720cULL, 0x080fe40003f06070ULL, 0x0000000f1e00720cULL, 0x000fc40003fc6070ULL,
0x000000111a227812ULL, 0x040fe400078efcffULL, 0x000000181a1e7812ULL, 0x040fe400078efcffULL,
0x0000000f1a00720cULL, 0x080fe40003f46070ULL, 0x0000000f2200720cULL, 0x080fe40003fa6070ULL,
0x0000000f1e00720cULL, 0x000fe40003f66070ULL, 0x000000091a387812ULL, 0x000fc400078efcffULL,
0x000000191a227812ULL, 0x040fe400078efcffULL, 0x000000201a1e7812ULL, 0x000fe400078efcffULL,
0xff7fffff3a3a7808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff3b3b7808ULL, 0x000fe40004800000ULL, 0xff7fffff39397808ULL, 0x000fc40004800000ULL,
0x0000000f3800720cULL, 0x080fe40003f86070ULL, 0x0000000f2200720cULL, 0x080fe40003f46070ULL,
0x0000000f1e00720cULL, 0x000fe40003f26070ULL, 0x000000211a227812ULL, 0x040fe400078efcffULL,
0x000000281a1e7812ULL, 0x000fe400078efcffULL, 0xff7fffff36367808ULL, 0x000fc40004000000ULL,
0xff7fffff34347808ULL, 0x000fe40004000000ULL, 0xff7fffff37377808ULL, 0x000fe40006000000ULL,
0xff7fffff35357808ULL, 0x000fe40006000000ULL, 0x0000000f2200720cULL, 0x080fe40003f06070ULL,
0x0000000f1e00720cULL, 0x000fe40003f86070ULL, 0x000000291a227812ULL, 0x000fc400078efcffULL,
0x000000301a1e7812ULL, 0x000fe400078efcffULL, 0xff7fffff32327808ULL, 0x000fe40007000000ULL,
0xff7fffff30307808ULL, 0x000fe40007000000ULL, 0xff7fffff33337808ULL, 0x000fe40006800000ULL,
0xff7fffff31317808ULL, 0x000fe40006800000ULL, 0x0000000f2200720cULL, 0x000fc40003fc6070ULL,
0x0000000f1e00720cULL, 0x000fe40003fa6070ULL, 0x000000311a227812ULL, 0x040fe400078efcffULL,
0x000000381a1e7812ULL, 0x040fe400078efcffULL, 0x000000391a1a7812ULL, 0x000fe400078efcffULL,
0xff7fffff2e2e7808ULL, 0x000fe40005800000ULL, 0xff7fffff2c2c7808ULL, 0x000fc40005800000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL, 0xff7fffff14147808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff16167808ULL, 0x000fe40004800000ULL,
0x0000000f2200720cULL, 0x080fe40003f66070ULL, 0x0000000f1e00720cULL, 0x000fc40003f46070ULL,
0x0000000f1a00720cULL, 0x000fe40003f26070ULL, 0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL,
0xff7fffff17177808ULL, 0x000fe40004000000ULL, 0xff7fffff28287808ULL, 0x000fe40006000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40006000000ULL, 0xff7fffff27277808ULL, 0x000fc40007000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40007000000ULL, 0xff7fffff25257808ULL, 0x000fe40006800000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff26267808ULL, 0x000fe40005800000ULL,
0xff7fffff21217808ULL, 0x000fe40005800000ULL, 0xff7fffff2d2d7808ULL, 0x000fc40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40005000000ULL, 0xff7fffff29297808ULL, 0x000fe40004800000ULL,
0xff7fffff19197808ULL, 0x000fce0004800000ULL, 0x0000001510107209ULL, 0x004fe20007810000ULL,
0xffffffff00077882ULL, 0x000fe20000000000ULL, 0x0000003a111a7209ULL, 0x000fe40007810000ULL,
0x00000039100f7209ULL, 0x000fe40007810000ULL, 0x0000003b1a117209ULL, 0x000fe40007810000ULL,
0x000000340f107209ULL, 0x000fe40007810000ULL, 0x00000036111a7209ULL, 0x000fc40007810000ULL,
0x00000035100f7209ULL, 0x000fe40007810000ULL, 0x000000371a117209ULL, 0x000fe40007810000ULL,
0x000000300f107209ULL, 0x000fe40007810000ULL, 0x00000032111a7209ULL, 0x000fe40007810000ULL,
0x00000031100f7209ULL, 0x000fe40007810000ULL, 0x000000331a117209ULL, 0x000fc40007810000ULL,
0x0000002c0f0f7209ULL, 0x000fe40007810000ULL, 0x0000002e11107209ULL, 0x000fe40007810000ULL,
0x000000140f0f7209ULL, 0x000fe40007810000ULL, 0x0000002f10117209ULL, 0x000fe40007810000ULL,
0x000000160f107209ULL, 0x000fe40007810000ULL, 0x0000002a111a7209ULL, 0x000fc40007810000ULL,
0x00000017100f7209ULL, 0x000fe40007810000ULL, 0x0000002b1a117209ULL, 0x000fe40007810000ULL,
0x0000001c0f107209ULL, 0x000fe40007810000ULL, 0x00000028111a7209ULL, 0x000fe40007810000ULL,
0x0000001d100f7209ULL, 0x000fe40007810000ULL, 0x000000271a1a7209ULL, 0x000fc40007810000ULL,
0x000000200f107209ULL, 0x000fe40007810000ULL, 0x000000251a0f7209ULL, 0x000fe40007810000ULL,
0x0000002110117209ULL, 0x000fe40007810000ULL, 0x000000260f107209ULL, 0x000fe40007810000ULL,
0x00000018111a7209ULL, 0x000fe40007810000ULL, 0x0000002d10107209ULL, 0x000fc40007810000ULL,
0x000000191a1a7209ULL, 0x000fe40007810000ULL, 0x0000002910107209ULL, 0x000fe20007810000ULL,
0x00000012071c7947ULL, 0x000fec000b800000ULL, 0x0c401f001a0f7f89ULL, 0x000e6800000e0000ULL,
0x0c401f0010117f89ULL, 0x000ea800000e0000ULL, 0x0c401f00121f7f89ULL, 0x000ee800000e0000ULL,
0x0c401f0013227f89ULL, 0x000f2200000e0000ULL, 0x0000000f1a1b7209ULL, 0x002fc40007810000ULL,
0x00000011101e7209ULL, 0x004fc60007810000ULL, 0x0c201f001b3e7f89ULL, 0x000e6200000e0000ULL,
0x0000001f121f7209ULL, 0x008fc60007810000ULL, 0x0c201f001e117f89ULL, 0x000ea200000e0000ULL,
0x00000022130f7209ULL, 0x010fc60007810000ULL, 0x0c201f001f407f89ULL, 0x000ee800000e0000ULL,
0x0c201f000f387f89ULL, 0x00092200000e0000ULL, 0x0000003e1b107209ULL, 0x002fe40007810000ULL,
0x000000111e117209ULL, 0x004fe40007810000ULL, 0x000000401f127209ULL, 0x008fce0007810000ULL,
0x3fb8aa3b101a7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b11467820ULL, 0x000fe20000410000ULL,
0x3f80000000077882ULL, 0x000fe40000000000ULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b34347823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b18187823ULL, 0x000fe2000001081aULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010846ULL, 0x3fb8aa3b3b3b7823ULL, 0x000fe20000010846ULL,
0x3fb8aa3b39397823ULL, 0x000fe2000001081aULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010846ULL,
0x3fb8aa3b37377823ULL, 0x000fe20000010846ULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001081aULL, 0x00000039001e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b19197823ULL, 0x000fe2000001081aULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010846ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010846ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010846ULL,
0x3fb8aa3b33337823ULL, 0x000fe20000010846ULL, 0x3fb8aa3b20137823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b21217823ULL, 0x000fe2000001081aULL, 0x00000017003e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010846ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010846ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010846ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010846ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010846ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010846ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010846ULL, 0x00000018003f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b29467823ULL, 0x000fce0000010846ULL, 0x0000003400347308ULL, 0x000ff00000000800ULL,
0x0000003500357308ULL, 0x000ff00000000800ULL, 0x0000003a003a7308ULL, 0x000ff00000000800ULL,
0x0000003b003b7308ULL, 0x000ff00000000800ULL, 0x0000003600177308ULL, 0x000ff00000000800ULL,
0x0000003700187308ULL, 0x000e700000000800ULL, 0x00000030001b7308ULL, 0x0005e20000000800ULL,
0x000000171817723eULL, 0x002fce00000010ffULL, 0x0000001400237308ULL, 0x0003e20000000800ULL,
0x00000007ff307e24ULL, 0x004fca000f8e00ffULL, 0x3f8000003030783eULL, 0x000fe400000010ffULL,
0x0000003100227308ULL, 0x0004e20000000800ULL, 0x000000151e14723eULL, 0x002fe400000010ffULL,
0x0000003a3b15723eULL, 0x000fca00000010ffULL, 0x0000001600397308ULL, 0x0003e20000000800ULL,
0x000000ffff317224ULL, 0x004fe200078e0030ULL, 0x0000001b2218723eULL, 0x008fcc00000010ffULL,
0x0000001c003d7308ULL, 0x000fe20000000800ULL, 0x000000343516723eULL, 0x002fce00000010ffULL,
0x0000001d00407308ULL, 0x0003f00000000800ULL, 0x0000001900447308ULL, 0x000fe20000000800ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00000030141c723cULL, 0x002fe400000418ffULL,
0x0000002c002c7308ULL, 0x000e700000000800ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x0000002c231a723eULL, 0x002fce00000010ffULL, 0x0000003300197308ULL, 0x000e700000000800ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x000000321919723eULL, 0x002fce00000010ffULL,
0x0000002f002f7308ULL, 0x000e700000000800ULL, 0x0000002100427308ULL, 0x0005e20000000800ULL,
0x0000002e2f1b723eULL, 0x002fce00000010ffULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x000000301820723cULL, 0x004fee000004181cULL, 0x0000002b002b7308ULL, 0x000e620000000800ULL,
0x000000393e1c723eULL, 0x000fe400000010ffULL, 0x0000003d401e723eULL, 0x000fca00000010ffULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x0000002a2b1d723eULL, 0x002fce00000010ffULL,
0x0000002700277308ULL, 0x000e700000000800ULL, 0x0000001300137308ULL, 0x000ea20000000800ULL,
0x00000028271f723eULL, 0x002fce00000010ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x000000301c28723cULL, 0x000fee0000041820ULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x000000134220723eULL, 0x004fe400000010ffULL, 0x0000003f4422723eULL, 0x000fca00000010ffULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0xfffffffc00137812ULL, 0x000fe400078ec0ffULL,
0x000000252621723eULL, 0x002fca00000010ffULL, 0x0000004600467308ULL, 0x000e620000000800ULL,
0x0000000fff267424ULL, 0x000fca00078e00ffULL, 0x0000001326257219ULL, 0x000fe400000006ffULL,
0x000000380f137209ULL, 0x010fe40007810000ULL, 0x0000002d4623723eULL, 0x002fce00000010ffULL,
0x00000030202c723cULL, 0x000fde0000041828ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x001c1fff2c287589ULL, 0x00026200000e0000ULL, 0x00000000002a7806ULL, 0x000fe200038e0100ULL,
0x00000000252673a1ULL, 0x000eb000000e8000ULL, 0x00000000250773c4ULL, 0x000ee20000004000ULL,
0x0000000000087886ULL, 0x000fc400038e0100ULL, 0x0000000825ff7c12ULL, 0x004fda000f804026ULL,
0x0000000e07248947ULL, 0x00afea000b800000ULL, 0x001c1fff2e297589ULL, 0x0002a800000e0000ULL,
0x001c1fff2a2a7589ULL, 0x000ee800000e0000ULL, 0x001c1fff002b7589ULL, 0x00032400000e0000ULL,
0xfffffff8ff457812ULL, 0x000fe200078ee245ULL, 0x0000080047257824ULL, 0x002fe200078e0202ULL,
0x00000003412e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff317224ULL, 0x000fe200078e0016ULL,
0x0000000300ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000845277836ULL, 0x040fe20000000000ULL,
0x000000042e307812ULL, 0x000fe200078efcffULL, 0x00000008450f7824ULL, 0x000fe200078e00ffULL,
0x000000072e267812ULL, 0x000fe200078e7845ULL, 0x0000900025257836ULL, 0x000fe20000000000ULL,
0x00000007302c7812ULL, 0x000fe200078e7845ULL, 0x000000ffff327224ULL, 0x000fe200078e0018ULL,
0x000000072e2e7812ULL, 0x000fe200078e7827ULL, 0x000000ffff337224ULL, 0x000fe200078e001aULL,
0x0000000730307812ULL, 0x000fe200078e7827ULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x0000000f26267212ULL, 0x080fe200078efcffULL, 0x000000ffff2d7224ULL, 0x000fe200078e001eULL,
0x0000000f2c2c7212ULL, 0x000fe200078efcffULL, 0x000000ffff2f7224ULL, 0x000fe200078e0022ULL,
0x000000272e2e7212ULL, 0x080fe200078efcffULL, 0x0000001026267824ULL, 0x100fe200078e0225ULL,
0x0000002730307212ULL, 0x000fe200078efcffULL, 0x000000102c0f7824ULL, 0x000fc400078e0225ULL,
0x000000102e277824ULL, 0x100fe400078e0225ULL, 0x0000001030257824ULL, 0x000fe400078e0225ULL,
0x000000ffff307224ULL, 0x000fe400078e0014ULL, 0x000000ffff147224ULL, 0x000fe400078e0015ULL,
0x000000ffff2c7224ULL, 0x000fe200078e001cULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000003026007844ULL, 0x0003e20000000200ULL, 0x000000ffff2e7224ULL, 0x000fc400078e0020ULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000ffff167224ULL, 0x000fe200078e0019ULL,
0x0000002c0f007844ULL, 0x0003e20000000200ULL, 0x000000ffff177224ULL, 0x000fe400078e001bULL,
0x000000ffff187224ULL, 0x000fe400078e001dULL, 0x000000ffff197224ULL, 0x000fe200078e001fULL,
0x0000001427007844ULL, 0x0003e20000000200ULL, 0x000000ffff1a7224ULL, 0x000fc400078e0021ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0023ULL, 0x00000001030e7824ULL, 0x000fc600078e020eULL,
0x0000001825007844ULL, 0x0003e80000000200ULL, 0x00f0001024008388ULL, 0x0003e80000000c00ULL,
0x00f2002824008388ULL, 0x01c3e20000000c00ULL, 0x000000050e007c0cULL, 0x000fe2000bf06070ULL,
0x00f6083c0bff79a7ULL, 0x0003e2000850003fULL, 0x00f6103c0bff79a7ULL, 0x0003e2000850003fULL,
0x00f6183c0bff79a7ULL, 0x0003e2000850003fULL, 0x00f6203c0bff79a7ULL, 0x0003f2000850003fULL,
0xffffffcc00088947ULL, 0x022fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00f6c831540075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00f6c831540095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff2000347947ULL, 0x008fea000383ffffULL,
0x00f60821500075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00f608215000a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff2400307947ULL, 0x020fea000383ffffULL,
0x00000075390075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00000075390095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff2800547947ULL, 0x020fea000383ffffULL,
0x00f6c831540075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00f6c831540095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff3800987947ULL, 0x020fea000383ffffULL,
0x00f62821500075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x00f628215000a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff3c00c87947ULL, 0x020fea000383ffffULL,
0x00f6a877210075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00f6a877210095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff4000cc7947ULL, 0x020fea000383ffffULL,
0x00f6a831210075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00f6a831210095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff5000c07947ULL, 0x000fea000383ffffULL,
0x00f64821500075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00f64821500095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff5400a07947ULL, 0x020fea000383ffffULL,
0x00f6a875230075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00f6a875230085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff5800a07947ULL, 0x020fea000383ffffULL,
0x00f6c831540075a7ULL, 0x0004a2000800017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00f6c831540085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff6800947947ULL, 0x002fea000383ffffULL,
0x00f66821500075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00f66821500095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff6c00747947ULL, 0x020fea000383ffffULL,
0x00f6a8774f0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00f6a8774f0085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffff7000647947ULL, 0x020fea000383ffffULL,
0x00f60011020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00f60011020085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffc400687947ULL, 0x020fea000383ffffULL,
0x00f6000b020075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00f6000b020085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffc400947947ULL, 0x020fea000383ffffULL,
0x00f688110a0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00f688110a0085a7ULL, 0x000e64000800007fULL,
0xfffffffc00ec8947ULL, 0x002fea000383ffffULL, 0xffffffe800487947ULL, 0x020fea000383ffffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0x000000ffff427224ULL, 0x000fe400078e001aULL,
0x00000002ff237424ULL, 0x000fe400078e00ffULL, 0x0000001fff447424ULL, 0x000fe400078e00ffULL,
0xffffffffff3d7424ULL, 0x000fce00078e00ffULL, 0x000000003d087348ULL, 0x000fea0003c00000ULL,
0x0c00002342387389ULL, 0x0006e40000000044ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff427224ULL, 0x002fe400078e0010ULL,
0x00000002ff237424ULL, 0x000fe400078e00ffULL, 0x0000001fff447424ULL, 0x000fe400078e00ffULL,
0xffffffffff3d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x004fce00078e0038ULL,
0x000000003d087348ULL, 0x000fea0003c00000ULL, 0x0c00002342387389ULL, 0x0002640000000044ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000000f1a1b7209ULL, 0x000fe20007810000ULL,
0x000000ffff427224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fce00078e0038ULL,
0x000000003d087348ULL, 0x000fea0003c00000ULL, 0x0c00002342387389ULL, 0x0002640000000044ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x00000011101e7209ULL, 0x000fe20007810000ULL,
0x000000ffff427224ULL, 0x000fe400078e0013ULL, 0x000000ffff1f7224ULL, 0x000fce00078e0038ULL,
0x000000003d087348ULL, 0x000fea0003c00000ULL, 0x0c00002342387389ULL, 0x0002640000000044ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001f121f7209ULL, 0x000fe20007810000ULL,
0x000000ffff427224ULL, 0x000fe400078e001bULL, 0x00000001ff237424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x000fce00078e0038ULL, 0x000000003d087348ULL, 0x000fea0003c00000ULL,
0x0c00002342387389ULL, 0x0002640000000044ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x00000022130f7209ULL, 0x000fe20007810000ULL, 0x000000ffff427224ULL, 0x000fe400078e001eULL,
0x000000ffff3e7224ULL, 0x000fce00078e0038ULL, 0x000000003d087348ULL, 0x000fea0003c00000ULL,
0x0c00002342387389ULL, 0x0002640000000044ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000003e1b107209ULL, 0x000fe20007810000ULL, 0x000000ffff427224ULL, 0x000fe400078e001fULL,
0x000000ffff117224ULL, 0x000fce00078e0038ULL, 0x000000003d087348ULL, 0x000fea0003c00000ULL,
0x0c00002342387389ULL, 0x0002640000000044ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x000000111e117209ULL, 0x000fe20007810000ULL, 0x000000ffff427224ULL, 0x000fe400078e000fULL,
0x000000ffff407224ULL, 0x000fce00078e0038ULL, 0x000000003d087348ULL, 0x000fea0003c00000ULL,
0x0c00002342387389ULL, 0x0002640000000044ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x000000401f127209ULL, 0x000fe20007810000ULL, 0xffffffec00407947ULL, 0x020fec000383ffffULL,
0x0000007000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff267424ULL, 0x000fe400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fce00078e0025ULL,
0x000000003d087348ULL, 0x000fea0003c00000ULL, 0x0000002b2e2b7389ULL, 0x0006e40000000026ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff297224ULL, 0x004fe400078e002bULL,
0x000000ffff2e7224ULL, 0x002fe400078e002aULL, 0x000000ffff2b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff267424ULL, 0x000fe400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fce00078e0025ULL,
0x000000003d087348ULL, 0x000fea0003c00000ULL, 0x0000002b2e2b7389ULL, 0x0006e40000000026ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2a7224ULL, 0x004fe400078e002bULL,
0x000000ffff2e7224ULL, 0x002fe400078e0000ULL, 0x000000ffff2b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff267424ULL, 0x000fe400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fce00078e0025ULL,
0x000000003d087348ULL, 0x000fea0003c00000ULL, 0x0000002b2e2b7389ULL, 0x0006e40000000026ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff000747947ULL, 0x026fea000383ffffULL, 0x018000000c047836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000004057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000c00048308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff047807ULL, 0x004fc80004000000ULL, 0x0000000405ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff0cff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff047807ULL, 0x000fc80000000000ULL, 0x0000000405ff7212ULL, 0x000fe4000780c0ffULL,
0x800000000c057812ULL, 0x000fd600078ec0ffULL, 0x0080000005040812ULL, 0x000fe200078efcffULL,
0x000000ffff048224ULL, 0x000fe200078e0005ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000c00047308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x00cfe400078e0004ULL, 0x000000ffff047224ULL, 0x000fe400078e000aULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffffefc04687950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x0000000000000100ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000638ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000680ULL, 0x0000000000000774ULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000df4ULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000e18ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000e18ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000e48ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e90ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e98ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000f00ULL, 0x0000000000010300ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000011200ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000011210ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000011210ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000011210ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x00000000000118f8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000118f8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000e90ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000f00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000010300ULL, 0x0000000000010300ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000011200ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000011210ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_90_cubin_len = 72264;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
