/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000019210ULL, 0x0000000000018d90ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x00000000000173c0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000017530ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000017570ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x00000000000175b0ULL,
0x0000000000000150ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000017700ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000173c000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x005bac0400288080ULL, 0x0000000000000000ULL, 0x000000c4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080940828808081ULL,
0x9a08288080990828ULL, 0x2880809d08288080ULL, 0x80a408288080a308ULL, 0x08288080a5082880ULL,
0x8080a708288080a6ULL, 0xa908288080a80828ULL, 0x288080aa08288080ULL, 0x80ac08288080ab08ULL,
0x08288080ad082880ULL, 0x8080af08288080aeULL, 0xe708288080c00828ULL, 0x288080eb08288080ULL,
0x818408288080ec08ULL, 0x0828808185082880ULL, 0x808196082880818eULL, 0x9f082880819d0828ULL,
0x2880808608288081ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808086ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x000173c000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x000000d4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8f082880808d0828ULL,
0x2880809008288080ULL, 0x8099082880809808ULL, 0x082880809a082880ULL, 0x80809f082880809bULL,
0xa108288080a00828ULL, 0x288080a208288080ULL, 0x80a408288080a308ULL, 0x08288080a5082880ULL,
0x8080a708288080a6ULL, 0xaa08288080a80828ULL, 0x288080ab08288080ULL, 0x80e708288080c008ULL,
0x08288080eb082880ULL, 0x80818408288080ecULL, 0x8e08288081850828ULL, 0x2880819608288081ULL,
0x819f082880819d08ULL, 0x1628808088082880ULL, 0x0000031028808280ULL, 0x8892000000000000ULL,
0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000016800000000ULL, 0x0001753000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000dcffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x8d08288080880828ULL, 0x2880808f08288080ULL, 0x8098082880809008ULL, 0x0828808099082880ULL,
0x80809b082880809aULL, 0xa0082880809f0828ULL, 0x288080a108288080ULL, 0x80a308288080a208ULL,
0x08288080a5082880ULL, 0x8080a708288080a6ULL, 0xa908288080a80828ULL, 0x288080aa08288080ULL,
0x80c008288080ab08ULL, 0x08288080e7082880ULL, 0x8080ec08288080ebULL, 0x8508288081840828ULL,
0x2880818e08288081ULL, 0x819d082880819608ULL, 0x082880819f082880ULL, 0x80828016288080a4ULL,
0x0000000000031028ULL, 0x288080a492000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x0000027000000000ULL, 0x0001757000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x000000dcffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8d08288080880828ULL, 0x2880808f08288080ULL,
0x8098082880809008ULL, 0x0828808099082880ULL, 0x80809b082880809aULL, 0xa0082880809f0828ULL,
0x288080a108288080ULL, 0x80a308288080a208ULL, 0x08288080a4082880ULL, 0x8080a608288080a5ULL,
0xa908288080a70828ULL, 0x288080aa08288080ULL, 0x80c008288080ab08ULL, 0x08288080e7082880ULL,
0x8080ec08288080ebULL, 0x8508288081840828ULL, 0x2880818e08288081ULL, 0x819d082880819608ULL,
0x082880819f082880ULL, 0x80828016288080a8ULL, 0x0000000000031028ULL, 0x288080a892000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x0000038000000000ULL, 0x000175b000000000ULL,
0x0000015000000000ULL, 0x0000180400000000ULL, 0x80a4288080a80900ULL, 0x0000000000002880ULL,
0x0000001200082f04ULL, 0x00081204000000f7ULL, 0x000000000000000dULL, 0x0000000d00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL, 0x0000000e00080a04ULL,
0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x001c310400ff1b03ULL, 0x00015b5000000020ULL, 0x00015da000015d90ULL,
0x00015f2000015f10ULL, 0x0160290400015f30ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001d0500001dULL, 0x0500001d0500001dULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000f001602804ULL, 0x00001ac000000110ULL,
0x00001c0000001b40ULL, 0x0000200000001c30ULL, 0x0000209000002030ULL, 0x00004b00000020f0ULL,
0x00004c6000004b90ULL, 0x000050a000004d80ULL, 0x00005120000050c0ULL, 0x0000789000005180ULL,
0x000079f000007920ULL, 0x00007e2000007b10ULL, 0x00007ea000007e40ULL, 0x0000a60000007f00ULL,
0x0000a7600000a690ULL, 0x0000aba00000a880ULL, 0x0000ac200000abc0ULL, 0x0000ce500000ac80ULL,
0x0000f3c00000ce60ULL, 0x0000fd000000f520ULL, 0x000157b00000fd30ULL, 0x000157f0000157e0ULL,
0x0001582000015800ULL, 0x0001586000015840ULL, 0x00015f0000015870ULL, 0x00015f7000015f60ULL,
0x0001669000015f80ULL, 0x00016740000166e0ULL, 0x00016810000167a0ULL, 0x000168d000016880ULL,
0x0001698000016920ULL, 0x00016a50000169f0ULL, 0x00016b1000016ac0ULL, 0x00016bc000016b60ULL,
0x00016c9000016c30ULL, 0x00016d5000016d00ULL, 0x00016e0000016da0ULL, 0x00016ed000016e70ULL,
0x00016fa000016f40ULL, 0x0001705000017000ULL, 0x000170f0000170a0ULL, 0x0001719000017140ULL,
0x00017250000171e0ULL, 0x00017330000172d0ULL, 0x04c0390400017390ULL, 0x000000ff00000210ULL,
0x003f01000000f600ULL, 0x00000003000002b0ULL, 0x003f01200000f608ULL, 0x00000003000002f0ULL,
0x003f01200000f688ULL, 0x0000000300000370ULL, 0x003f01200000f6a8ULL, 0x00000003000003b0ULL,
0x003f01200000f6c8ULL, 0x000000ff00000460ULL, 0x003f01070000f600ULL, 0x0000003800000630ULL,
0x003f01020000f68cULL, 0x0000003800000750ULL, 0x003f01010000f688ULL, 0x000000ff00000d90ULL,
0x0004010700000000ULL, 0x000000ff00000e20ULL, 0x0004010100000000ULL, 0x0000004200000e80ULL,
0x003f010100000020ULL, 0x0000007900000fd0ULL, 0x003f010500000004ULL, 0x0000004200001040ULL,
0x003f010500000024ULL, 0x00000042000010c0ULL, 0x003f010500000024ULL, 0x0000002d000017b0ULL,
0x003f010700000000ULL, 0x0000002d00001880ULL, 0x003f010100000000ULL, 0x0000002c00001890ULL,
0x003f010500000004ULL, 0x0000004600001900ULL, 0x003f01010000f608ULL, 0x0000004600001920ULL,
0x003f01050000f60cULL, 0x00000027000019d0ULL, 0x003f01050000f60cULL, 0x0000002c00001ef0ULL,
0x003f010500000004ULL, 0x0000002c00001f70ULL, 0x003f010500000004ULL, 0x00000042000040c0ULL,
0x003f010100000020ULL, 0x0000005e00004140ULL, 0x003f01010000f688ULL, 0x0000007900004190ULL,
0x003f010500000004ULL, 0x00000042000041e0ULL, 0x003f010500000024ULL, 0x0000004200004260ULL,
0x003f010500000024ULL, 0x0000006000004830ULL, 0x003f010700000000ULL, 0x00000060000048b0ULL,
0x003f010100000000ULL, 0x0000005f000048c0ULL, 0x003f010500000004ULL, 0x0000004600004930ULL,
0x003f01010000f628ULL, 0x0000004600004950ULL, 0x003f01050000f62cULL, 0x0000004600004a30ULL,
0x003f01050000f62cULL, 0x0000002400004f70ULL, 0x003f01050000f6acULL, 0x0000002400004ff0ULL,
0x003f01050000f6acULL, 0x0000004200006fe0ULL, 0x003f010100000020ULL, 0x0000005e00007050ULL,
0x003f01010000f690ULL, 0x0000007900007090ULL, 0x003f010500000004ULL, 0x00000042000070e0ULL,
0x003f010500000024ULL, 0x0000004200007160ULL, 0x003f010500000024ULL, 0x0000005f00007610ULL,
0x003f010700000000ULL, 0x0000005f00007690ULL, 0x003f010100000000ULL, 0x00000060000076a0ULL,
0x003f010500000004ULL, 0x0000004600007710ULL, 0x003f01010000f648ULL, 0x0000004600007730ULL,
0x003f01050000f64cULL, 0x00000046000077c0ULL, 0x003f01050000f64cULL, 0x0000000000007cf0ULL,
0x003f01050000f6acULL, 0x0000006000007d70ULL, 0x003f010500000004ULL, 0x0000004200009d10ULL,
0x003f010100000020ULL, 0x0000005e00009d80ULL, 0x003f01010000f698ULL, 0x0000007900009dd0ULL,
0x003f010500000004ULL, 0x0000004200009e20ULL, 0x003f010500000024ULL, 0x0000004200009ea0ULL,
0x003f010500000024ULL, 0x000000600000a370ULL, 0x003f010700000000ULL, 0x000000600000a3f0ULL,
0x003f010100000000ULL, 0x0000005f0000a400ULL, 0x003f010500000004ULL, 0x000000460000a470ULL,
0x003f01010000f668ULL, 0x000000460000a490ULL, 0x003f01050000f66cULL, 0x000000460000a530ULL,
0x003f01050000f66cULL, 0x000000250000aa70ULL, 0x003f01050000f6acULL, 0x0000005f0000aaf0ULL,
0x003f010500000004ULL, 0x000000420000ca00ULL, 0x003f010100000020ULL, 0x0000005e0000ca60ULL,
0x003f01010000f6a0ULL, 0x000000ff00010a70ULL, 0x003f01010000f600ULL, 0x000000ff00011870ULL,
0x003f01050000f604ULL, 0x000000ff00011910ULL, 0x003f01050000f604ULL, 0x000000ff00011b20ULL,
0x003f01010000f600ULL, 0x000000ff00011b30ULL, 0x003f01050000f604ULL, 0x000000ff00011bc0ULL,
0x003f01050000f604ULL, 0x0000003f00014c10ULL, 0x003f010100000000ULL, 0x0000003f00014c50ULL,
0x003f010500000004ULL, 0x0000003f000150b0ULL, 0x003f010500000004ULL, 0x00000041000164f0ULL,
0x003f010100000000ULL, 0x0000004100016550ULL, 0x003f010100000008ULL, 0x00000041000165b0ULL,
0x003f010100000010ULL, 0x0000004100016620ULL, 0x003f010100000018ULL, 0x00141c0400053803ULL,
0x0001098000010730ULL, 0x00011cd000011c20ULL, 0x0000040100016660ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x000000000000047cULL, 0x0000001200000002ULL, 0x000000000000036cULL, 0x0000001200000002ULL,
0x000000000000025cULL, 0x0000001200000002ULL, 0x0000000000000154ULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x0000000000000453ULL, 0x0000001200000002ULL,
0x0000000000000343ULL, 0x0000001200000002ULL, 0x0000000000000236ULL, 0x0000001200000002ULL,
0x000000000000012fULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff3b7624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000f7919ULL, 0x000ea20000002300ULL,
0x0000001200067300ULL, 0x000ee200000e0000ULL, 0x00000100ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000000000007919ULL, 0x000ea80000002200ULL, 0x0000000000377919ULL, 0x000f220000000000ULL,
0x0000001200127309ULL, 0x000f660000000000ULL, 0x00000000003d7919ULL, 0x000ee80000002600ULL,
0x0000000000247919ULL, 0x000f620000002700ULL, 0x00000005ff027819ULL, 0x002fc60000011603ULL,
0x0000000000077919ULL, 0x000e680000000000ULL, 0x00001fff02027589ULL, 0x000fe200000e0000ULL,
0x000000010f007824ULL, 0x004fc600078e0200ULL, 0x00001fff0f0f7589ULL, 0x000ea200000e0000ULL,
0x0000008000037824ULL, 0x000fe200078e0203ULL, 0x00000004ff117819ULL, 0x010fe20000011637ULL,
0x000000083b007824ULL, 0x000fe400078e00ffULL, 0x000000083d097824ULL, 0x008fe200078e00ffULL,
0x000000ff0300720cULL, 0x000fe20003f45270ULL, 0x00000010370e7824ULL, 0x000fe200078e00ffULL,
0x0000007f0300780cULL, 0x040fe20003f84070ULL, 0x0000002400007224ULL, 0x020fe200078e0209ULL,
0x0000000f0300780cULL, 0x000fc40003f64070ULL, 0x000000030300780cULL, 0x000fe40003f24070ULL,
0x000000070600720cULL, 0x002fca0003f02070ULL, 0x3fffff80ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff05a424ULL, 0x000fe400078e00ffULL, 0x000000040f087824ULL, 0x004fe400078e0202ULL,
0xff317217ff0cc424ULL, 0x000fe200078e00ffULL, 0x00f60004ff00a388ULL, 0x0003e20000000a00ULL,
0x00000002080a7824ULL, 0x000fe200078e00ffULL, 0x000000010300780cULL, 0x000fe20003f44070ULL,
0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL, 0x00f4000c0300c388ULL, 0x000fe20000004800ULL,
0x000000010a137824ULL, 0x040fe200078e0211ULL, 0x000000080a0b7817ULL, 0x000fe20007800000ULL,
0x7fffffc0ff07b424ULL, 0x000fc400078e00ffULL, 0x3fffff60ff089424ULL, 0x000fe400078e00ffULL,
0x0000000100047824ULL, 0x002fe200078e0213ULL, 0x00f608060300b388ULL, 0x0003e20000008a00ULL,
0x7fffff60ff099424ULL, 0x000fe400078e00ffULL, 0x000000010b007824ULL, 0x000fe400078e0a0aULL,
0x00005c0004047625ULL, 0x000fe200078e000dULL, 0x00f6880803009388ULL, 0x0005e40000008a00ULL,
0x000000001100720cULL, 0x000fe20003f66070ULL, 0x3fffff80ff0a9424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL, 0x0000000713067812ULL, 0x002fe200078ec0ffULL,
0x3fffffc0ff0ca424ULL, 0x000fe200078e00ffULL, 0x000000f00e077812ULL, 0x000fe200078ec0ffULL,
0x7fffffc0ff0da424ULL, 0x000fe200078e00ffULL, 0x00f6a80a03009388ULL, 0x0003e20000008a00ULL,
0x0000000f06107812ULL, 0x000fe200078e7837ULL, 0x000000ffff007224ULL, 0x000fe200078e0a12ULL,
0x0000000704067210ULL, 0x000fe20007f9e0ffULL, 0x00f6c80c0300a388ULL, 0x0003e20000008a00ULL,
0x00000004ff117424ULL, 0x000fc400078e00ffULL, 0x0000001013107824ULL, 0x000fe400078e0210ULL,
0x000000ffff077224ULL, 0x000fe400020e0605ULL, 0x0000001010097824ULL, 0x004fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000620024047625ULL, 0x000fca00078e0011ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604037981ULL, 0x002ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x00000004ff357e24ULL, 0x002fe2000f8e00ffULL,
0x0000003f03347810ULL, 0x004fc40007ffe0ffULL, 0x000000ff03367810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff347819ULL, 0x000fe40000011634ULL, 0x00000008ff367819ULL, 0x000fca0000011636ULL,
0x0001042000008947ULL, 0x000fea0003800000ULL, 0x00000002ff397819ULL, 0x000fe20000011602ULL,
0x0000000802387824ULL, 0x000fe400078e00ffULL, 0x00000003ff077424ULL, 0x000fe200078e00ffULL,
0x03ffffff39007812ULL, 0x000fca00078ec0ffULL, 0x0000000435097824ULL, 0x000fca00078e0200ULL,
0x000000340900720cULL, 0x000fda0003f06070ULL, 0x0000000224008824ULL, 0x000fe400078e00ffULL,
0x00006400ff058624ULL, 0x000fc800078e00ffULL, 0x0000640000048624ULL, 0x000fe400078e0205ULL,
0xffffffffff007424ULL, 0x000fe400078e00ffULL, 0x0000000109048824ULL, 0x000fe200078e0204ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c0738ff738cULL, 0x0003e20000000000ULL,
0x0000600004048625ULL, 0x000fe200078e0011ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000604008981ULL, 0x0004e2000c1e1900ULL, 0x00000003ff3a7424ULL, 0x000fe200078e00ffULL,
0x0000000309067812ULL, 0x000fe200078ec0ffULL, 0xffffffffff3b7424ULL, 0x000fe200078e00ffULL,
0x00000001023c7812ULL, 0x000fe200078ec0ffULL, 0x00000300113a7a24ULL, 0x000fe200078e0a3aULL,
0x000000030600780cULL, 0x000fc40003f05270ULL, 0x00000003ff087819ULL, 0x000fe40000011637ULL,
0x00000001ff497819ULL, 0x000fe20000011602ULL, 0x000000403d3d7824ULL, 0x000fe200078e00ffULL,
0x000000013a477807ULL, 0x000fe20004000000ULL, 0x00f6880038ff7f8cULL, 0x0009e8000c80043fULL,
0x0000000109477824ULL, 0x000fca00078e0247ULL, 0x000000344700720cULL, 0x000fe40003f06070ULL,
0x00000004080b7810ULL, 0x000fd60007ffe0ffULL, 0x0000000224068824ULL, 0x000fe400078e00ffULL,
0x00006400ff078624ULL, 0x002fc800078e00ffULL, 0x0000640006068624ULL, 0x000fc800078e0207ULL,
0x0000000106048824ULL, 0x004fe400078e0247ULL, 0x000000103c067824ULL, 0x000fe400078e00ffULL,
0x0000600004048625ULL, 0x000fc800078e0011ULL, 0x00000001060c7824ULL, 0x000fe200078e020bULL,
0x00000006043b8981ULL, 0x000362000c1e1900ULL, 0x00000020493e7824ULL, 0x000fe200078e00ffULL,
0x0000000808127810ULL, 0x000fe20007ffe0ffULL, 0x0000000106097824ULL, 0x000fe200078e0208ULL,
0x0000000135077810ULL, 0x000fe20007ffe0ffULL, 0x00002000493f7824ULL, 0x000fe200078e00ffULL,
0x0000000c08147810ULL, 0x000fe20007ffe0ffULL, 0x00000001060f7824ULL, 0x000fe200078e0212ULL,
0x000000360700720cULL, 0x000fe20003f06070ULL, 0x00000008090d7824ULL, 0x040fe200078e00ffULL,
0x000000370c047212ULL, 0x0c2fe200078e3cffULL, 0x000000080c057824ULL, 0x000fe200078e00ffULL,
0x00000037090a7212ULL, 0x080fe200078e3cffULL, 0x0000000106157824ULL, 0x000fe200078e0214ULL,
0x000000370f117212ULL, 0x0c0fe200078e3cffULL, 0x000000080f187824ULL, 0x000fe200078e00ffULL,
0xfffffff805107812ULL, 0x000fe200078ee204ULL, 0x0000010035047824ULL, 0x000fe200078e023eULL,
0xfffffff80d0a7812ULL, 0x000fe200078ee20aULL, 0x00000000490473c2ULL, 0x000e6200000e0000ULL,
0x0000003715167212ULL, 0x000fe200078e3cffULL, 0xff317217ff407424ULL, 0x000fe200078e00ffULL,
0x0000000403057217ULL, 0x000fe20007800000ULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x0000b0003f077810ULL, 0x000fe20007ffe0ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000105057824ULL, 0x100fe200078e0a04ULL,
0x000000203d047812ULL, 0x000fe200078ef804ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000002005057807ULL, 0x000fe20000000000ULL, 0x0000000104097824ULL, 0x040fe200078e0209ULL,
0x0000f6a849427811ULL, 0x000fe200078e18ffULL, 0x0000000104177824ULL, 0x040fe200078e0215ULL,
0x0000000605057217ULL, 0x000fe20007800000ULL, 0x00000001040d7824ULL, 0x000fc400078e020cULL,
0x0000000104137824ULL, 0x000fe200078e020fULL, 0xfffffff818047812ULL, 0x000fe200078ee211ULL,
0x0000000815157824ULL, 0x000fe400078e00ffULL, 0x0000000105057824ULL, 0x000fe200078e0a06ULL,
0x0000f6a804047891ULL, 0x002fe2000f8e203fULL, 0x0000001010117824ULL, 0x100fe200078e0207ULL,
0xfffffff815167812ULL, 0x000fe200078ee216ULL, 0x0000001004157824ULL, 0x100fe200078e0207ULL,
0x000000050b00720cULL, 0x080fe20003f26070ULL, 0x000000100a0f7824ULL, 0x100fe200078e0207ULL,
0x000000050800720cULL, 0x080fe20003f46070ULL, 0x0000001016197824ULL, 0x000fe200078e0207ULL,
0x000000051200720cULL, 0x000fe20003f06070ULL, 0x0000580000007a24ULL, 0x008fc800078e02ffULL,
0x0000004000007824ULL, 0x000fca00078e00ffULL, 0x0000000900097210ULL, 0x040fe40007f7e0ffULL,
0x0000000d000d7210ULL, 0x040fe40007f9e0ffULL, 0x0000001300137210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff047224ULL, 0x000fe200018e06ffULL, 0x00005e0009107a11ULL, 0x000fc600078638ffULL,
0x000000ffff067224ULL, 0x000fe200028e06ffULL, 0x00005f00090b7a11ULL, 0x000fe200018f3c04ULL,
0x000000ffff047224ULL, 0x000fe200020e06ffULL, 0x00005e000d087a11ULL, 0x040fe400078638ffULL,
0x0000001700007210ULL, 0x000fe40007fbe0ffULL, 0x00005f000d097a11ULL, 0x000fe400018f3c04ULL,
0x00005e00130a7a11ULL, 0x000fe200078838ffULL, 0x000000ffff077224ULL, 0x000fe200028e06ffULL,
0x000000700e0d7812ULL, 0x000fc400078ec0ffULL, 0x00005f0013067a11ULL, 0x000fe400020f3c06ULL,
0x000000100d047210ULL, 0x000fe40007fbe0ffULL, 0x0000000d08087210ULL, 0x000fe40007f9e0ffULL,
0x00005e00000c7a11ULL, 0x000fe400078c38ffULL, 0x000000051400720cULL, 0x000fe20003f66070ULL,
0x000000ffff057224ULL, 0x000fe200028e060bULL, 0x0000000d0a0a7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200020e0609ULL, 0x00005f0000007a11ULL, 0x000fc400030f3c07ULL,
0x0000000d0c0c7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e0606ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e2000d101c46ULL,
0x0000000000067805ULL, 0x000fe4000001ff00ULL, 0x000000ffff0d7224ULL, 0x000fe200020e0600ULL,
0x0000000008117faeULL, 0x0009e8000c901c46ULL, 0x000000000a157faeULL, 0x0009e2000c101c46ULL,
0x000000363500720cULL, 0x000fc60003f06070ULL, 0x000000000c197faeULL, 0x0005e2000d901c46ULL,
0x0000000000047805ULL, 0x002fc6000001ff00ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000187805ULL, 0x004fc6000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x010fec0000008000ULL,
0x00000000ff667f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200042267f8cULL, 0x0004e2000c80043fULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000002042797810ULL, 0x000fe20007ffe0ffULL,
0x0000bb9000000947ULL, 0x000fea0003800000ULL, 0x0000000224437824ULL, 0x004fe400078e00ffULL,
0x00006400ff007624ULL, 0x000fc400078e00ffULL, 0x000000ffff257224ULL, 0x008fe400078e0027ULL,
0x0000640043437624ULL, 0x000fe400078e0200ULL, 0xff317217ff407424ULL, 0x000fe400078e00ffULL,
0x000000ffff6c7224ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0x0000010035007824ULL, 0x000fca00078e00ffULL, 0x000000030000720cULL, 0x000fda0003f06070ULL,
0x0000bab000000947ULL, 0x006fea0003800000ULL, 0x0000040079007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000fee0000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6a7224ULL, 0x000fe400078e0047ULL,
0x000000ffff447224ULL, 0x000fe200078e006cULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240042007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x0000240042247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000347007812ULL, 0x000fe200078ec0ffULL,
0x000058003b267a24ULL, 0x020fe200078e02ffULL, 0x00000003ff287819ULL, 0x000fe20000011637ULL,
0x0000010035567824ULL, 0x000fe200078e00ffULL, 0x000000030000780cULL, 0x000fe20003f05270ULL,
0xffffffffff3b7424ULL, 0x000fc600078e00ffULL, 0x000000013a007807ULL, 0x000fca0004000000ULL,
0x0000000147477824ULL, 0x000fe400078e0200ULL, 0x0000001002007824ULL, 0x000fc600078e00ffULL,
0x000000344700720cULL, 0x000fe40003f06070ULL, 0x0000001000297812ULL, 0x000fca00078ec0ffULL,
0x0000000128487824ULL, 0x000fe200078e0229ULL, 0x00000001ff497819ULL, 0x000fc60000011602ULL,
0x0000000848007824ULL, 0x040fe200078e00ffULL, 0x00000037484b7212ULL, 0x000fe200078e3cffULL,
0x0000000143248824ULL, 0x000fe200078e0247ULL, 0x0000000428327810ULL, 0x000fe20007ffe0ffULL,
0x00000004ff258424ULL, 0x000fe200078e00ffULL, 0xfffffff8004b7812ULL, 0x000fe200078ee24bULL,
0x0000002049007824ULL, 0x000fe400078e0256ULL, 0x0000600024248625ULL, 0x000fc600078e0025ULL,
0x0000004000007810ULL, 0x000fe20007ffe0ffULL, 0x00000001324a7824ULL, 0x100fe200078e0229ULL,
0x00000006243b8981ULL, 0x000562000c1e1900ULL, 0x0000000c28527810ULL, 0x000fe20007ffe0ffULL,
0x0000004026267824ULL, 0x000fe200078e00ffULL, 0x0000000135277810ULL, 0x000fe20007ffe0ffULL,
0x0000001037517824ULL, 0x000fe200078e00ffULL, 0x000000374a4d7212ULL, 0x080fe200078e3cffULL,
0x00000001524e7824ULL, 0x100fe200078e0229ULL, 0x000000362700720cULL, 0x000fe20003f06070ULL,
0x0000054000007945ULL, 0x000fe20003800000ULL, 0x0000000828467810ULL, 0x000fe20007ffe0ffULL,
0x000000084a247824ULL, 0x004fe200078e00ffULL, 0x0000000003257217ULL, 0x000fe20007800000ULL,
0x000000084e2b7824ULL, 0x040fe200078e00ffULL, 0x000000374e507212ULL, 0x000fe200078e3cffULL,
0x00000001464c7824ULL, 0x000fe200078e0229ULL, 0xfffffff8244d7812ULL, 0x000fe200078ee24dULL,
0x0000000125247824ULL, 0x100fe200078e0a00ULL, 0x000000203d257812ULL, 0x000fe200078ef800ULL,
0x000010006c007824ULL, 0x000fe200078e00ffULL, 0xfffffff82b507812ULL, 0x000fe200078ee250ULL,
0x000000084c2a7824ULL, 0x000fe200078e00ffULL, 0x0000002024247807ULL, 0x000fe20000000000ULL,
0x0000000125277824ULL, 0x040fe200078e0248ULL, 0x0000100000007812ULL, 0x000fe200078e0cffULL,
0x00000001252b7824ULL, 0x040fe200078e024aULL, 0x0000002924247217ULL, 0x000fe20007800000ULL,
0x00000001252d7824ULL, 0x040fe200078e024cULL, 0x0000002726277210ULL, 0x040fe20007f5e0ffULL,
0x0000000125257824ULL, 0x000fe200078e024eULL, 0x0000002b262b7210ULL, 0x000fe20007f7e0ffULL,
0x0000000124297824ULL, 0x000fe200078e0a29ULL, 0x0000002d262d7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e00272f7a11ULL, 0x040fe200078438ffULL,
0x000000ffff2c7224ULL, 0x000fe200018e06ffULL, 0x0000002526257210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200020e06ffULL, 0x00005f0027307a11ULL, 0x000fe200010f3c30ULL,
0x0000200049007824ULL, 0x000fe200078e0200ULL, 0x00005e002b277a11ULL, 0x000fe200078438ffULL,
0x000000ffff267224ULL, 0x000fe200000e06ffULL, 0x000000374c4f7212ULL, 0x000fc400078e3cffULL,
0x00005f002b2c7a11ULL, 0x000fe400010f3c2cULL, 0x000000292800720cULL, 0x000fe40003f46070ULL,
0x00005e002d287a11ULL, 0x000fe400078638ffULL, 0x0000007051317812ULL, 0x000fe400078ec0ffULL,
0xfffffff82a4f7812ULL, 0x000fe400078ee24fULL, 0x00005f002d2e7a11ULL, 0x000fc400018f3c2eULL,
0x00005e00252a7a11ULL, 0x000fe400078038ffULL, 0x000000312f247210ULL, 0x080fe20007f7e0ffULL,
0x000000086c2f7824ULL, 0x000fe200078e00ffULL, 0x0000b00000007810ULL, 0x000fe40007ffe0ffULL,
0x00005f00252b7a11ULL, 0x000fe200000f3c26ULL, 0x000000ffff257224ULL, 0x000fe200018e0630ULL,
0x0000003127267210ULL, 0x000fe20007fbe0ffULL, 0x000000104b587824ULL, 0x100fe200078e0200ULL,
0x000000293200720cULL, 0x000fe20003f06070ULL, 0x000000104d597824ULL, 0x000fe200078e0200ULL,
0x0000003128287210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff277224ULL, 0x000fe200028e062cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024587faeULL, 0x0005e2000d101c46ULL,
0x000000294600720cULL, 0x080fe20003f46070ULL, 0x000000104f5a7824ULL, 0x100fe200078e0200ULL,
0x000000295200720cULL, 0x000fe20003fa6070ULL, 0x00000010505b7824ULL, 0x000fe200078e0200ULL,
0xfffffff038297812ULL, 0x000fc400078ec0ffULL, 0x000000312a2a7210ULL, 0x000fe40007f9e0ffULL,
0x0000f6a8292c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff297224ULL, 0x000fe200018e062eULL,
0x000000082f2d7812ULL, 0x000fe200078e0cffULL, 0x000000ffff2b7224ULL, 0x000fe200020e062bULL,
0x0000000026597faeULL, 0x0007e2000c101c46ULL, 0xffffffe038467812ULL, 0x000fe400078ec0ffULL,
0x000000012c2d7824ULL, 0x000fe200078e022dULL, 0x00000000285a7faeULL, 0x0007e2000d101c46ULL,
0x0000001038007812ULL, 0x000fc400078ec0ffULL, 0x0000000838257812ULL, 0x004fe200078ec0ffULL,
0x000000002a5b7faeULL, 0x0007e2000e901c46ULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x0000004625467210ULL, 0x000fe20007ffe000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000002d0403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000012c2c7824ULL, 0x000fe200078e022fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002d627f8cULL, 0x000528000c80043fULL, 0x000004002c267984ULL, 0x0084e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080046247f8cULL, 0x000fe2000c80043fULL, 0x8000000026ff7812ULL, 0x00afc60007844867ULL,
0x00f60c0046277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000a000000947ULL, 0x000fea0003800000ULL, 0x0000002039277824ULL, 0x000fe400078e0200ULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x000000083c277824ULL, 0x000fe400078e0227ULL,
0x0000000000267305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000260000735dULL, 0x008fe20003800000ULL, 0x00f60c0027297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff527819ULL, 0x000fe20000011637ULL, 0xffffffffff537424ULL, 0x000fe200078e00ffULL,
0x0000007051517812ULL, 0x000fe400078ec0ffULL, 0x0000000c52527812ULL, 0x000fc600078ec0ffULL,
0x0000008039257824ULL, 0x000fc800078e0251ULL, 0x0000000125257824ULL, 0x000fca00078e0252ULL,
0x00f0000025277984ULL, 0x000e680000000800ULL, 0x00f2000025007984ULL, 0x0006a20000000800ULL,
0x000000402700720bULL, 0x002fe20003f1d000ULL, 0x00014bb27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x008fc800000e0100ULL, 0x0000ffff24297812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ffb57424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x000000023900720cULL, 0x000fe40003f65270ULL,
0x000000402700720bULL, 0x000fe20003f14000ULL, 0x00014b827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x000000800225b824ULL, 0x000fe200078e0251ULL,
0x00000027402e7209ULL, 0x000fe40007810000ULL, 0x0000ffff24247812ULL, 0x000fe200078e3cffULL,
0x000000015225b824ULL, 0x000fe200078e0225ULL, 0x00000002ff287819ULL, 0x000fe20000011637ULL,
0x8000002e40267221ULL, 0x000fe20000010000ULL, 0x0000002429ff7212ULL, 0x000fc4000780c0ffULL,
0x00f4002e2500b388ULL, 0x0003e20000000800ULL, 0x3fb8aa3b26267820ULL, 0x000fc80000410000ULL,
0x00000026002a7308ULL, 0x0002e20000000800ULL, 0x00014b127f007947ULL, 0x000fea000b800000ULL,
0x00001f282a267589ULL, 0x00a2e400000e0000ULL, 0x0000000828287810ULL, 0x002fe20007ffe0ffULL,
0x00014b427f007947ULL, 0x000fea000b800000ULL, 0x00001f282a287589ULL, 0x00032400000e0000ULL,
0x8000002e27270221ULL, 0x100fe20000010000ULL, 0x0000002a41417220ULL, 0x000fe20000410000ULL,
0x0000002807077220ULL, 0x090fe20000410000ULL, 0x0000002806067220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL, 0x0000002823237220ULL, 0x080fe20000410000ULL,
0x0000002822227220ULL, 0x080fe20000410000ULL, 0x000000281f1f7220ULL, 0x080fe20000410000ULL,
0x0000002700450308ULL, 0x000f220000000800ULL, 0x000000281e1e7220ULL, 0x080fe20000410000ULL,
0x000000281b1b7220ULL, 0x080fe20000410000ULL, 0x000000281a1a7220ULL, 0x080fe20000410000ULL,
0x0000002817177220ULL, 0x080fe20000410000ULL, 0x0000002816167220ULL, 0x080fe20000410000ULL,
0x0000002813137220ULL, 0x080fe20000410000ULL, 0x0000002812127220ULL, 0x080fe20000410000ULL,
0x000000280f0f7220ULL, 0x080fe20000410000ULL, 0x000000280e0e7220ULL, 0x080fe20000410000ULL,
0x000000280b0b7220ULL, 0x080fe20000410000ULL, 0x000000280a0a7220ULL, 0x000fe20000410000ULL,
0x00000001ffb57807ULL, 0x000fe20000000000ULL, 0x0000002605057220ULL, 0x088fe20000410000ULL,
0x0000002604047220ULL, 0x080fe20000410000ULL, 0x0000002621217220ULL, 0x080fe20000410000ULL,
0x0000002620207220ULL, 0x080fe20000410000ULL, 0x000000261d1d7220ULL, 0x080fe20000410000ULL,
0x000000261c1c7220ULL, 0x080fe20000410000ULL, 0x0000002619197220ULL, 0x080fe20000410000ULL,
0x0000002618187220ULL, 0x080fe20000410000ULL, 0x0000002615157220ULL, 0x080fe20000410000ULL,
0x0000002614147220ULL, 0x080fe20000410000ULL, 0x0000002611117220ULL, 0x080fe20000410000ULL,
0x0000002610107220ULL, 0x080fe20000410000ULL, 0x000000260d0d7220ULL, 0x080fe20000410000ULL,
0x000000260c0c7220ULL, 0x080fe20000410000ULL, 0x0000002609097220ULL, 0x080fe20000410000ULL,
0x0000002608087220ULL, 0x000fe20000410000ULL, 0x000000ffff407224ULL, 0x000fe200078e002eULL,
0x0000004500000220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000004100417221ULL, 0x004fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x000004002c007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000004002c247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000045ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff277819ULL, 0x000fc40000011637ULL,
0x00005410002a7816ULL, 0x002fe20000000000ULL, 0x000147d27f007947ULL, 0x000fea000b800000ULL,
0x00001f272a9d7589ULL, 0x0002a400000e0000ULL, 0x0000000827547810ULL, 0x000fe20007ffe0ffULL,
0x000148127f007947ULL, 0x000fea000b800000ULL, 0x00001f542a8e7589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001027287810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff2b7424ULL, 0x000fe200078e00ffULL, 0x000020a000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x000154d000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001827287810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff2b7424ULL, 0x000fe200078e00ffULL, 0x0000210000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0001547000007944ULL, 0x03cfea0003c00000ULL,
0x0000000202657824ULL, 0x000fe200078e00ffULL, 0x0000000737e27812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x0000000465007812ULL, 0x000fc400078ec0ffULL,
0x00000008e2e27812ULL, 0x000fe400078ef837ULL, 0x0000000037e57211ULL, 0x040fe400078fe0ffULL,
0x0000000837007812ULL, 0x000fe400078ec0ffULL, 0x00000007e5257812ULL, 0x000fca00078e78e2ULL,
0x00000008e2257824ULL, 0x000fc800078e0225ULL, 0x0000001025667824ULL, 0x000fc800078e00ffULL,
0x0000080039b77824ULL, 0x000fe400078e0266ULL, 0x0000000402247824ULL, 0x000fe200078e00ffULL,
0x0000000700257812ULL, 0x100fe200078ec837ULL, 0x0000100002267824ULL, 0x000fe200078e00ffULL,
0x0000000700007812ULL, 0x000fe200078ef837ULL, 0x000010006c287824ULL, 0x002fe200078e023fULL,
0x0000000424247812ULL, 0x000fe400078ec0ffULL, 0xffffe00026277812ULL, 0x000fe400078ec0ffULL,
0x0000002437247211ULL, 0x000fe400078fe0ffULL, 0x00000080002c7811ULL, 0x000fe200078e18ffULL,
0x000010006c267824ULL, 0x000fe200078e0227ULL, 0x0000002425277212ULL, 0x000fc400078e3cffULL,
0x0000000224247810ULL, 0x000fe40007ffe0ffULL, 0x0000b00026267810ULL, 0x000fe20007ffe0ffULL,
0x0000000800557824ULL, 0x000fe200078e0227ULL, 0x00000024255d7212ULL, 0x000fe200078e3cffULL,
0x00000001275c7824ULL, 0x000fe200078e022cULL, 0x0000b000282d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001055307824ULL, 0x100fe200078e0226ULL, 0x00009910b5b57816ULL, 0x000fe200000000ffULL,
0x0000000800577824ULL, 0x000fe200078e025dULL, 0x00000002e5e57810ULL, 0x000fe20007ffe0ffULL,
0x000000105c287824ULL, 0x000fe200078e022dULL, 0x000000ffb500720cULL, 0x000fe20003f45270ULL,
0x000000003030783bULL, 0x000e620000004200ULL, 0x0000001057267824ULL, 0x000fc400078e0226ULL,
0x000000015d5d7824ULL, 0x000fe200078e022cULL, 0x000000002828783bULL, 0x00cea60000004200ULL,
0x000000105d2d7824ULL, 0x000fe200078e022dULL, 0x000000002624783bULL, 0x000eea0000004200ULL,
0x000000002d2c783bULL, 0x000f220000004200ULL, 0x0000010030e67824ULL, 0x042fe200078e00ffULL,
0x0000003000ea7306ULL, 0x000fe20000009400ULL, 0x0001000030e07824ULL, 0x000fe200078e00ffULL,
0x00000018ffdd7819ULL, 0x000fe20000011430ULL, 0x0000010031db7824ULL, 0x040fe200078e00ffULL,
0x00000018ffe67819ULL, 0x000fe200000114e6ULL, 0x0000010032ce7824ULL, 0x040fe200078e00ffULL,
0x00000018ffe07819ULL, 0x000fe200000114e0ULL, 0x0001000031d87824ULL, 0x000fe200078e00ffULL,
0x000000e600ec7306ULL, 0x000fe20000209400ULL, 0x00000018ffdb7819ULL, 0x000fe200000114dbULL,
0x0000010033ca7824ULL, 0x000fe200078e00ffULL, 0x00000018ffce7819ULL, 0x000fe200000114ceULL,
0x0001000032cb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffd87819ULL, 0x000fe200000114d8ULL,
0x0000010028a37824ULL, 0x044fe200078e00ffULL, 0x00000018ffc97819ULL, 0x000fe20000011431ULL,
0x000000e600ed7306ULL, 0x000e620000205400ULL, 0x000000e600b57245ULL, 0x000fe2000020d400ULL,
0x0001000028ac7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe20000011432ULL,
0x0000010029a27824ULL, 0x040fe200078e00ffULL, 0x00000018ffca7819ULL, 0x000fe200000114caULL,
0x0001000029a57824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe20000011428ULL,
0x0000003000e97306ULL, 0x000ea20000005400ULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x0001000033c87824ULL, 0x000fe200078e00ffULL, 0x00000018ffbe7819ULL, 0x000fe20000011433ULL,
0x000001002a857824ULL, 0x040fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011429ULL,
0x000100002a777824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe2000001142aULL,
0x0000003100e77306ULL, 0x000fe20000009400ULL, 0x000000edec00720bULL, 0x002fe20003fbd000ULL,
0x000001002b847824ULL, 0x040fe200078e00ffULL, 0x00000018ffc87819ULL, 0x000fe200000114c8ULL,
0x000100002b7d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fc4000001142bULL,
0x00000018ffb87819ULL, 0x008fe20000011424ULL, 0x0000003100e47306ULL, 0x000e620000005400ULL,
0x000000e9ea00720bULL, 0x004fe40003f7d000ULL, 0x00000018ffb47819ULL, 0x000fe40000011425ULL,
0x00000018ffa97819ULL, 0x000fe40000011426ULL, 0x00000001b5b55812ULL, 0x000fe200078efcffULL,
0x000000e000ee7306ULL, 0x000fe20000209400ULL, 0x00000018ff9f7819ULL, 0x000fc40000011427ULL,
0x00000018ffa37819ULL, 0x000fe400000114a3ULL, 0x00000018ffa27819ULL, 0x000fe400000114a2ULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x000000e000eb7306ULL, 0x000ea20000205400ULL,
0x000000e4e700720bULL, 0x002fe40003f9d000ULL, 0x00000018ffa57819ULL, 0x000fe400000114a5ULL,
0x00000018ff857819ULL, 0x000fc40000011485ULL, 0x00000018ff847819ULL, 0x000fe20000011484ULL,
0x000000db00e17306ULL, 0x000fe20000209400ULL, 0x00000018ff777819ULL, 0x000fe40000011477ULL,
0x00000018ff7d7819ULL, 0x000fca000001147dULL, 0x000000db00e87306ULL, 0x000e620000205400ULL,
0x000000ebee00720bULL, 0x004fe40003f1d000ULL, 0x00000007e5eb7812ULL, 0x000fe200078e78e2ULL,
0x0001000025e57824ULL, 0x000fc800078e00ffULL, 0x000000dd00e37306ULL, 0x000ff00000209400ULL,
0x000000dd00b67306ULL, 0x000ea20000205400ULL, 0x000000e8e100720bULL, 0x002fce0003fbd000ULL,
0x0000003000987306ULL, 0x000870000000d400ULL, 0x0000003100897306ULL, 0x0006e2000000d400ULL,
0x000000b6e300720bULL, 0x004fe40003fdd000ULL, 0x000000e000b67245ULL, 0x000fc4000020d400ULL,
0x00000018ff307819ULL, 0x010fe4000001142cULL, 0x00000001b6b60812ULL, 0x000fe200078efcffULL,
0x0000003200d97306ULL, 0x000fe20000009400ULL, 0x0000000198983812ULL, 0x002fe400078efcffULL,
0x00000018ff317819ULL, 0x008fca000001142dULL, 0x0000003200dc7306ULL, 0x000e620000005400ULL,
0x0000000189894812ULL, 0x000fce00078efcffULL, 0x000000ce00d77306ULL, 0x000ff00000209400ULL,
0x000000ce00d47306ULL, 0x0004e20000205400ULL, 0x000000dcd900720bULL, 0x002fe40003f7d000ULL,
0x000000db00dc7245ULL, 0x000fc4000020d400ULL, 0x000000dd00d97245ULL, 0x000fe2000020d400ULL,
0x0000010026dd7824ULL, 0x000fe200078e00ffULL, 0x00000001dcdc5812ULL, 0x000fe200078efcffULL,
0x000000d800df7306ULL, 0x000fe20000209400ULL, 0x000000ce00ce7245ULL, 0x004fe4000020d400ULL,
0x00000001d9d96812ULL, 0x000fca00078efcffULL, 0x000000d800de7306ULL, 0x0002a20000205400ULL,
0x000000d4d700720bULL, 0x008fce0003f9d000ULL, 0x000000c900d27306ULL, 0x000fe20000209400ULL,
0x000000d800d87245ULL, 0x002fca000020d400ULL, 0x00000001cece4812ULL, 0x000fe400078efcffULL,
0x000000c900d37306ULL, 0x0002e20000205400ULL, 0x000000dedf00720bULL, 0x004fce0003f1d000ULL,
0x0000003300cc7306ULL, 0x000fe20000009400ULL, 0x000000c900c97245ULL, 0x002fca000020d400ULL,
0x00000001d8d80812ULL, 0x000fe400078efcffULL, 0x0000003300cf7306ULL, 0x000e620000005400ULL,
0x000000d3d200720bULL, 0x008fe20003fbd000ULL, 0x0001000026d27824ULL, 0x000fe400078e00ffULL,
0x0000010027d37824ULL, 0x000fc600078e00ffULL, 0x00000018ffd27819ULL, 0x000fe200000114d2ULL,
0x000000c300c77306ULL, 0x000fe20000209400ULL, 0x00000018ffd37819ULL, 0x000fca00000114d3ULL,
0x00000001c9c95812ULL, 0x000fe400078efcffULL, 0x000000c300c67306ULL, 0x000ea20000205400ULL,
0x000000cfcc00720bULL, 0x002fe40003fdd000ULL, 0x00000018ffcc7819ULL, 0x000fca00000114ddULL,
0x0000002800997306ULL, 0x000ff00000009400ULL, 0x0000002800947306ULL, 0x000fe20000005400ULL,
0x000000c6c700720bULL, 0x004fe40003f9d000ULL, 0x000000ca00c77245ULL, 0x000fca000020d400ULL,
0x0000002800687306ULL, 0x0003f0000000d400ULL, 0x000000ca00d57306ULL, 0x000fe20000209400ULL,
0x0000010024287824ULL, 0x002fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x000000ca00da7306ULL, 0x000e700000205400ULL, 0x0000002900a07306ULL, 0x000ff00000009400ULL,
0x00000029008f7306ULL, 0x000fe20000005400ULL, 0x000000dad500720bULL, 0x002fce0003f1d000ULL,
0x0000002900007306ULL, 0x0003ec000000d400ULL, 0x00000001c7c70812ULL, 0x000fe400078efcffULL,
0x000000cb00cd7306ULL, 0x000fe20000209400ULL, 0x0000010025297824ULL, 0x002fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x000000cb00d67306ULL, 0x0002b00000205400ULL,
0x0000003200837306ULL, 0x000ee2000000d400ULL, 0x000000cb00cb7245ULL, 0x002fce000020d400ULL,
0x000000be00c47306ULL, 0x000fe20000209400ULL, 0x000000d6cd00720bULL, 0x004fce0003fbd000ULL,
0x000000be00c57306ULL, 0x000e620000205400ULL, 0x0000000183833812ULL, 0x008fca00078efcffULL,
0x00000001cbcb5812ULL, 0x000fe400078efcffULL, 0x0000003300827306ULL, 0x000eb0000000d400ULL,
0x0000002a009e7306ULL, 0x000fe20000009400ULL, 0x000000c5c400720bULL, 0x002fc40003f7d000ULL,
0x000000c300c47245ULL, 0x000fe4000020d400ULL, 0x000000be00c37245ULL, 0x000fe4000020d400ULL,
0x00000001c4c44812ULL, 0x000fe200078efcffULL, 0x0000002a008d7306ULL, 0x000fe20000005400ULL,
0x0000000182826812ULL, 0x004fca00078efcffULL, 0x00000001c3c33812ULL, 0x000fe400078efcffULL,
0x0000002a00647306ULL, 0x000ff0000000d400ULL, 0x00000028002a7306ULL, 0x000ff00000209400ULL,
0x0000002800e77306ULL, 0x000e700000205400ULL, 0x0000002b009c7306ULL, 0x000ff00000009400ULL,
0x0000002b00937306ULL, 0x000fe20000005400ULL, 0x000000e72a00720bULL, 0x002fce0003fdd000ULL,
0x0000002b00617306ULL, 0x000ff0000000d400ULL, 0x00000029002b7306ULL, 0x000ff00000209400ULL,
0x0000002900e47306ULL, 0x000e700000205400ULL, 0x0000002400bf7306ULL, 0x000ff00000009400ULL,
0x0000002400c07306ULL, 0x000ea20000005400ULL, 0x000000e42b00720bULL, 0x002fce0003f9d000ULL,
0x0000002400707306ULL, 0x0002f0000000d400ULL, 0x000000c800d07306ULL, 0x000fe20000209400ULL,
0x0001000024247824ULL, 0x002fe200078e00ffULL, 0x000000c0bf00720bULL, 0x004fc40003fbd000ULL,
0x0000002800bf7245ULL, 0x000fe4000020d400ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x000000c800d17306ULL, 0x0002a20000205400ULL, 0x00000001bfbf6812ULL, 0x000fcc00078efcffULL,
0x0000000170705812ULL, 0x008fe200078efcffULL, 0x00000025007c7306ULL, 0x000fe20000009400ULL,
0x000000c800c87245ULL, 0x002fce000020d400ULL, 0x0000002500b97306ULL, 0x000e620000005400ULL,
0x000000d1d000720bULL, 0x004fce0003f1d000ULL, 0x0000002500737306ULL, 0x0004ec000000d400ULL,
0x00000001c8c80812ULL, 0x000fe400078efcffULL, 0x0000002600ba7306ULL, 0x000fe20000009400ULL,
0x00000008e2257824ULL, 0x004fe200078e02ebULL, 0x00000018ffe27819ULL, 0x000fc400000114e5ULL,
0x000000b97c00720bULL, 0x002fe20003f1d000ULL, 0x00000010257c7824ULL, 0x000fe200078e00ffULL,
0x0000002400b97245ULL, 0x000fe4000020d400ULL, 0x0000002600bb7306ULL, 0x000e700000005400ULL,
0x0000002400e97306ULL, 0x000fe20000209400ULL, 0x0000000173730812ULL, 0x008fce00078efcffULL,
0x0000002400e67306ULL, 0x0004e20000205400ULL, 0x000000bbba00720bULL, 0x002fe40003f7d000ULL,
0x0000002900ba7245ULL, 0x000fe4000020d400ULL, 0x00900000b728783bULL, 0x000e620000000200ULL,
0x000000b400bb7245ULL, 0x000fe4000020d400ULL, 0x000000e200e07306ULL, 0x000fe20000209400ULL,
0x00000001baba4812ULL, 0x000fe200078efcffULL, 0x0000080039247824ULL, 0x004fcc00078e027cULL,
0x000000e200db7306ULL, 0x0005220000205400ULL, 0x000000e6e900720bULL, 0x008fce0003fdd000ULL,
0x00000026006f7306ULL, 0x000ee2000000d400ULL, 0x000000e200e27245ULL, 0x004fca000020d400ULL,
0x00000001b9b96812ULL, 0x000fe400078efcffULL, 0x000000cc00cf7306ULL, 0x000fe20000209400ULL,
0x000000dbe000720bULL, 0x010fce0003f9d000ULL, 0x000000cc00267306ULL, 0x000ea20000205400ULL,
0x000000016f6f3812ULL, 0x008fe400078efcffULL, 0x000000949900720bULL, 0x000fe40003f7d000ULL,
0x000000d200997245ULL, 0x000fe2000020d400ULL, 0x0000009d2828a231ULL, 0x082fe200003400ffULL,
0x00000001e2e24812ULL, 0x000fe200078efcffULL, 0x0000002700917306ULL, 0x000fe20000009400ULL,
0x0000009d2a2aa231ULL, 0x000fe400003400ffULL, 0x0000008e2929a231ULL, 0x000fc400003400ffULL,
0x0000008e2b2ba231ULL, 0x000fc600003400ffULL, 0x0000002700967306ULL, 0x000e620000005400ULL,
0x00000026cf00720bULL, 0x004fe40003fdd000ULL, 0x0000000168683812ULL, 0x000fca00078efcffULL,
0x0000002700697306ULL, 0x0004f0000000d400ULL, 0x000000b400bc7306ULL, 0x000fe20000209400ULL,
0x0001000027277824ULL, 0x004fe200078e00ffULL, 0x000000969100720bULL, 0x002fc40003f9d000ULL,
0x000000d300967245ULL, 0x000fe4000020d400ULL, 0x00000018ffc07819ULL, 0x000fe40000011427ULL,
0x000000b400bd7306ULL, 0x0002a20000205400ULL, 0x009000002424783bULL, 0x000f220000000200ULL,
0x00000018ff917819ULL, 0x000fca000001142eULL, 0x0000000169694812ULL, 0x008fe200078efcffULL,
0x0000009f00ab7306ULL, 0x000fe20000209400ULL, 0x000000cc00b47245ULL, 0x002fc8000020d400ULL,
0x00000001b4b46812ULL, 0x000fc600078efcffULL, 0x0000009f00a47306ULL, 0x0002e20000205400ULL,
0x000000bdbc00720bULL, 0x004fe40003f1d000ULL, 0x0000006fb4b4723eULL, 0x000fca00000010ffULL,
0x000000b800c17306ULL, 0x000fe20000209400ULL, 0x0000009f009f7245ULL, 0x002fca000020d400ULL,
0x00000001bbbb0812ULL, 0x000fe400078efcffULL, 0x000000b800c27306ULL, 0x0002a20000205400ULL,
0x000000a4ab00720bULL, 0x008fe20003f9d000ULL, 0x000100002cab7824ULL, 0x000fe200078e00ffULL,
0x000000a900a47245ULL, 0x000fca000020d400ULL, 0x000000d200be7306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x002fe2000020d400ULL, 0x0000009d2424a231ULL, 0x090fe400003400ffULL,
0x0000009d2626a231ULL, 0x000fe200003400ffULL, 0x000000a2009d7245ULL, 0x000fe2000020d400ULL,
0x0000008e2525a231ULL, 0x080fe200003400ffULL, 0x000000019f9f4812ULL, 0x000fe200078efcffULL,
0x000000d200c57306ULL, 0x000e620000205400ULL, 0x000000c2c100720bULL, 0x004fe20003fbd000ULL,
0x0000008e2727a231ULL, 0x000fe200003400ffULL, 0x000100002f8e7824ULL, 0x000fca00078e00ffULL,
0x000000a300aa7306ULL, 0x000fe20000209400ULL, 0x00000018ff8e7819ULL, 0x000fca000001148eULL,
0x00000001b8b85812ULL, 0x000fe400078efcffULL, 0x000000a300a17306ULL, 0x0004e20000205400ULL,
0x000000c5be00720bULL, 0x002fe40003f1d000ULL, 0x000000b9b8b8723eULL, 0x000fe400000010ffULL,
0x000000e2bbb9723eULL, 0x000fc600000010ffULL, 0x000000a900b17306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x004fc6000020d400ULL, 0x000000b8281c723cULL, 0x000fe4000004181cULL,
0x0000000199990812ULL, 0x000fe400078efcffULL, 0x000000a900b07306ULL, 0x000e620000205400ULL,
0x000000a1aa00720bULL, 0x008fe20003f9d000ULL, 0x000100002ea17824ULL, 0x000fe200078e00ffULL,
0x0000008fa000720bULL, 0x000fe40003f1d000ULL, 0x000000c000a07245ULL, 0x000fe4000020d400ULL,
0x00000018ffa17819ULL, 0x000fe200000114a1ULL, 0x000000a200a87306ULL, 0x000fec0000209400ULL,
0x00000001a3a34812ULL, 0x000fc400078efcffULL, 0x000000a200ad7306ULL, 0x000ea20000205400ULL,
0x000000b0b100720bULL, 0x002fe20003fdd000ULL, 0x000001002fb07824ULL, 0x000fe200078e00ffULL,
0x0000000100000812ULL, 0x000fe400078efcffULL, 0x00000068a368723eULL, 0x000fe400000010ffULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x000000d300c67306ULL, 0x000fec0000209400ULL,
0x00000001a4a46812ULL, 0x000fc400078efcffULL, 0x000000d300cd7306ULL, 0x000e620000205400ULL,
0x000000ada800720bULL, 0x004fe20003f5d000ULL, 0x000001002da87824ULL, 0x040fe200078e00ffULL,
0x0000008d9e00720bULL, 0x000fe20003fdd000ULL, 0x000001002c9e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001142fULL, 0x000100002dad7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa87819ULL, 0x000fe200000114a8ULL, 0x000000ac00ae7306ULL, 0x000fe20000209400ULL,
0x00000018ff9e7819ULL, 0x000fe4000001149eULL, 0x00000018ffad7819ULL, 0x000fc600000114adULL,
0x000000019d9d2812ULL, 0x000fe400078efcffULL, 0x000000ac00b37306ULL, 0x0004e20000205400ULL,
0x000000cdc600720bULL, 0x002fe40003fbd000ULL, 0x0000000164646812ULL, 0x000fca00078efcffULL,
0x0000008600907306ULL, 0x000fe20000209400ULL, 0x000000ac00ac7245ULL, 0x004fca000020d400ULL,
0x0000000196965812ULL, 0x000fe400078efcffULL, 0x0000008600977306ULL, 0x0002a20000205400ULL,
0x000000b3ae00720bULL, 0x008fe20003f9d000ULL, 0x000001002eae7824ULL, 0x000fca00078e00ffULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x000000a500af7306ULL, 0x000fe20000209400ULL,
0x0000008600867245ULL, 0x002fca000020d400ULL, 0x00000001acac4812ULL, 0x000fe400078efcffULL,
0x000000a500b27306ULL, 0x0002e20000205400ULL, 0x000000979000720bULL, 0x004fce0003f1d000ULL,
0x000000c000c17306ULL, 0x000fe20000209400ULL, 0x000000a500a57245ULL, 0x002fca000020d400ULL,
0x0000000186860812ULL, 0x000fe400078efcffULL, 0x000000c000bc7306ULL, 0x000e620000205400ULL,
0x000000b2af00720bULL, 0x008fe40003f5d000ULL, 0x000000b000af7245ULL, 0x000fca000020d400ULL,
0x0000008c00957306ULL, 0x000fec0000209400ULL, 0x00000001a5a52812ULL, 0x000fe400078efcffULL,
0x0000008c00927306ULL, 0x000ea20000205400ULL, 0x000000bcc100720bULL, 0x002fe40003fbd000ULL,
0x000000a586a5723eULL, 0x000fca00000010ffULL, 0x00000072009a7306ULL, 0x000fec0000209400ULL,
0x00000001a0a05812ULL, 0x000fe400078efcffULL, 0x00000072009b7306ULL, 0x0002e20000205400ULL,
0x000000929500720bULL, 0x004fe40003f7d000ULL, 0x0000008c00957245ULL, 0x000fc4000020d400ULL,
0x000000939c00720bULL, 0x000fe40003fbd000ULL, 0x000000a09f9f723eULL, 0x000fe200000010ffULL,
0x0000008500a67306ULL, 0x000fe20000209400ULL, 0x0000007200727245ULL, 0x002fca000020d400ULL,
0x0000000195953812ULL, 0x000fe400078efcffULL, 0x0000008500a77306ULL, 0x0002a20000205400ULL,
0x0000009b9a00720bULL, 0x008fe40003f9d000ULL, 0x0000000161615812ULL, 0x000fca00078efcffULL,
0x0000008400887306ULL, 0x000fe20000209400ULL, 0x0000008500857245ULL, 0x002fca000020d400ULL,
0x0000000172724812ULL, 0x000fe400078efcffULL, 0x00000084008b7306ULL, 0x0002e20000205400ULL,
0x000000a7a600720bULL, 0x004fce0003f5d000ULL, 0x00000077007e7306ULL, 0x000fe20000209400ULL,
0x0000008400847245ULL, 0x002fca000020d400ULL, 0x0000000185852812ULL, 0x000fe400078efcffULL,
0x00000077007f7306ULL, 0x0002a20000205400ULL, 0x0000008b8800720bULL, 0x008fce0003f1d000ULL,
0x0000006d008a7306ULL, 0x000fe20000209400ULL, 0x0000007700777245ULL, 0x002fca000020d400ULL,
0x0000000184840812ULL, 0x000fe400078efcffULL, 0x0000006d00877306ULL, 0x000e620000205400ULL,
0x0000007f7e00720bULL, 0x004fce0003fdd000ULL, 0x0000002c007b7306ULL, 0x000fec0000009400ULL,
0x0000000177776812ULL, 0x000fe400078efcffULL, 0x0000002c007a7306ULL, 0x000ea20000005400ULL,
0x000000878a00720bULL, 0x002fe40003f7d000ULL, 0x000000777272723eULL, 0x000fca00000010ffULL,
0x0000002c00677306ULL, 0x0002f0000000d400ULL, 0x0000002d00757306ULL, 0x000fe20000009400ULL,
0x00000098b52c723eULL, 0x002fe400000010ffULL, 0x0000007a7b00720bULL, 0x004fc40003f5d000ULL,
0x0000006996b5723eULL, 0x000fe400000010ffULL, 0x000000009d69723eULL, 0x000fe200000010ffULL,
0x0000002d00787306ULL, 0x000e620000005400ULL, 0x0000003100007245ULL, 0x000fc6000020d400ULL,
0x000000b42820723cULL, 0x000fe80000041820ULL, 0x0000002d00607306ULL, 0x000522000000d400ULL,
0x0000000167672812ULL, 0x008fce00078efcffULL, 0x0000009e00a97306ULL, 0x000fe20000209400ULL,
0x00000089dc2d723eULL, 0x004fe400000010ffULL, 0x00000018ff897819ULL, 0x000fe400000114abULL,
0x000000787500720bULL, 0x002fc60003f1d000ULL, 0x0000009e00aa7306ULL, 0x000e620000205400ULL,
0x0000002c2808723cULL, 0x000fee0000041808ULL, 0x0000002e00717306ULL, 0x000fe20000009400ULL,
0x00000083ce2c723eULL, 0x000fe400000010ffULL, 0x00000082c72d723eULL, 0x000fc400000010ffULL,
0x0000000160600812ULL, 0x010fc600078efcffULL, 0x0000002e00767306ULL, 0x000ea20000005400ULL,
0x000000aaa900720bULL, 0x002fe20003f9d000ULL, 0x0000002c2810723cULL, 0x000fec0000041810ULL,
0x0000002e005f7306ULL, 0x0002e2000000d400ULL, 0x00000070bf2c723eULL, 0x000fe200000010ffULL,
0x000000682408723cULL, 0x000fe20000041808ULL, 0x00000073ba2d723eULL, 0x000fc400000010ffULL,
0x0000007d00737245ULL, 0x000fc6000020d400ULL, 0x0000002f006e7306ULL, 0x000fe20000009400ULL,
0x000000b6d92e723eULL, 0x002fe200000010ffULL, 0x0000002c2818723cULL, 0x000fe20000041818ULL,
0x000000767100720bULL, 0x004fca0003fdd000ULL, 0x0000002f006b7306ULL, 0x000fe20000005400ULL,
0x0000006d002c7245ULL, 0x000fc8000020d400ULL, 0x000000012c2c3812ULL, 0x000fc600078efcffULL,
0x0000002f005e7306ULL, 0x0003e2000000d400ULL, 0x000000015f5f6812ULL, 0x008fce00078efcffULL,
0x0000007d00807306ULL, 0x000fe20000209400ULL, 0x000000d8c92f723eULL, 0x002fce00000010ffULL,
0x0000007d00817306ULL, 0x000e620000205400ULL, 0x0000002e280c723cULL, 0x000fee000004180cULL,
0x0000003000337306ULL, 0x000fe20000209400ULL, 0x000000cbc42e723eULL, 0x000fe400000010ffULL,
0x000000c8c32f723eULL, 0x000fca00000010ffULL, 0x0000003000747306ULL, 0x000ea20000205400ULL,
0x000000818000720bULL, 0x002fe20003fbd000ULL, 0x0000002e2814723cULL, 0x000fec0000041814ULL,
0x000000a800927306ULL, 0x000fe20000209400ULL, 0x0000009e002e7245ULL, 0x000fe4000020d400ULL,
0x00000099a49e723eULL, 0x000fc400000010ffULL, 0x000000012e2e4812ULL, 0x000fe400078efcffULL,
0x000000a8002f7245ULL, 0x000fe2000020d400ULL, 0x000000a800977306ULL, 0x000e620000205400ULL,
0x000000743300720bULL, 0x004fe20003f7d000ULL, 0x0000009e2804723cULL, 0x000fe20000041804ULL,
0x0000003000307245ULL, 0x000fe4000020d400ULL, 0x0000000173735812ULL, 0x000fe400078efcffULL,
0x0000006b6e00720bULL, 0x000fe20003fbd000ULL, 0x0000003100327306ULL, 0x000fe20000209400ULL,
0x000000648528723eULL, 0x000fc400000010ffULL, 0x000000618429723eULL, 0x000fe400000010ffULL,
0x000000ac95a4723eULL, 0x000fe400000010ffULL, 0x0000000130303812ULL, 0x000fe200078efcffULL,
0x0000003100b77306ULL, 0x000ea20000205400ULL, 0x000000979200720bULL, 0x002fe20003f9d000ULL,
0x000000282410723cULL, 0x000fe20000041810ULL, 0x000000732c73723eULL, 0x000fe400000010ffULL,
0x000000015e5e5812ULL, 0x000fc400078efcffULL, 0x000000672e2e723eULL, 0x000fe200000010ffULL,
0x0000008900877306ULL, 0x000fe20000209400ULL, 0x0000008e00297245ULL, 0x000fe2000020d400ULL,
0x000000a4240c723cULL, 0x040fe8000004180cULL, 0x000000012f2f4812ULL, 0x000fe400078efcffULL,
0x0000008900887306ULL, 0x0002e20000205400ULL, 0x000000b73200720bULL, 0x004fe20003f5d000ULL,
0x000000722414723cULL, 0x000fe20000041814ULL, 0x000000602f2f723eULL, 0x000fca00000010ffULL,
0x000000ad007a7306ULL, 0x000fe20000209400ULL, 0x0000008900897245ULL, 0x002fe2000020d400ULL,
0x0000002e2418723cULL, 0x000fe80000041818ULL, 0x0000000100002812ULL, 0x000fe400078efcffULL,
0x000000ad00757306ULL, 0x0002a20000205400ULL, 0x000000888700720bULL, 0x008fce0003f9d000ULL,
0x000000ae00707306ULL, 0x000fe20000209400ULL, 0x000000ad00ad7245ULL, 0x002fca000020d400ULL,
0x0000000189894812ULL, 0x000fe400078efcffULL, 0x000000ae00717306ULL, 0x0002e20000205400ULL,
0x000000757a00720bULL, 0x004fe40003f1d000ULL, 0x000000893030723eULL, 0x000fca00000010ffULL,
0x0000009100947306ULL, 0x000fe20000209400ULL, 0x000000ae00ae7245ULL, 0x002fca000020d400ULL,
0x00000001adad0812ULL, 0x000fe400078efcffULL, 0x00000091008f7306ULL, 0x000e620000205400ULL,
0x000000717000720bULL, 0x008fe40003f7d000ULL, 0x000000ad0031723eULL, 0x000fe400000010ffULL,
0x0000009100007245ULL, 0x000fc6000020d400ULL, 0x0000008d00937306ULL, 0x000fe40000209400ULL,
0x00000030241c723cULL, 0x000fe8000004181cULL, 0x00000001aeae3812ULL, 0x000fe400078efcffULL,
0x0000008d009c7306ULL, 0x000ea20000205400ULL, 0x0000008f9400720bULL, 0x002fe40003f9d000ULL,
0x0000005faeae723eULL, 0x000fca00000010ffULL, 0x000000b0006b7306ULL, 0x000fec0000209400ULL,
0x0000000100004812ULL, 0x000fe400078efcffULL, 0x000000b0006e7306ULL, 0x000e620000205400ULL,
0x0000009c9300720bULL, 0x004fce0003f1d000ULL, 0x000000a1002d7306ULL, 0x000ff00000209400ULL,
0x000000a1002a7306ULL, 0x0004e20000205400ULL, 0x0000006e6b00720bULL, 0x002fce0003f5d000ULL,
0x0000008e002b7306ULL, 0x000fe20000209400ULL, 0x000000a100a17245ULL, 0x004fca000020d400ULL,
0x00000001afaf2812ULL, 0x000fe400078efcffULL, 0x0000008e00327306ULL, 0x000e620000205400ULL,
0x0000002a2d00720bULL, 0x008fe40003f7d000ULL, 0x0000008d002a7245ULL, 0x000fe4000020d400ULL,
0x0000005eafaf723eULL, 0x000fe400000010ffULL, 0x000000012a2a0812ULL, 0x000fca00078efcffULL,
0x000000ae2420723cULL, 0x000fe40000041820ULL, 0x00000001a1a13812ULL, 0x000fe400078efcffULL,
0x000000322b00720bULL, 0x002fe40003fdd000ULL, 0x000000a10028723eULL, 0x000fd600000010ffULL,
0x0000000129296812ULL, 0x000fc800078efcffULL, 0x000000292a29723eULL, 0x000fce00000010ffULL,
0x000000282404723cULL, 0x000fe20000041804ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200042247f8cULL, 0x0002a2000c80043fULL, 0xfffffff8655e7812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004056007810ULL, 0x000fe20007ffe0ffULL,
0x00f688005eff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff677224ULL, 0x000fe200078e0063ULL,
0x000000016c6c7812ULL, 0x000fe400078e0cffULL, 0x000000030000720cULL, 0x000fda0003f06070ULL,
0x000088f000000947ULL, 0x000fea0003800000ULL, 0x0000040079007984ULL, 0x008ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240042007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x0000240042247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000036a007812ULL, 0x000fe200078ec0ffULL,
0x000058003b267a24ULL, 0x020fe200078e02ffULL, 0x00000001ff497819ULL, 0x000fe20000011602ULL,
0x0000000844697824ULL, 0x000fe200078e00ffULL, 0x000000030000780cULL, 0x000fe20003f05270ULL,
0xffffffffff3b7424ULL, 0x000fc600078e00ffULL, 0x000000013a257807ULL, 0x000fca0004000000ULL,
0x000000016a6a7824ULL, 0x000fca00078e0225ULL, 0x000000036a007812ULL, 0x000fc800078ec0ffULL,
0x000000030000780cULL, 0x000fc80003f05270ULL, 0x000000013a6b7807ULL, 0x000fca0004000000ULL,
0x000000016a477824ULL, 0x000fca00078e026bULL, 0x000000344700720cULL, 0x000fe20003f06070ULL,
0x0000002049007824ULL, 0x000fe200078e0256ULL, 0xfffffff038287812ULL, 0x000fe400078ec0ffULL,
0x0000000869607812ULL, 0x000fe400078ec0ffULL, 0x0000000135277810ULL, 0x000fce0007ffe0ffULL,
0x0000006b43248210ULL, 0x000fe20007ffe06aULL, 0x00000004ff258424ULL, 0x000fe200078e00ffULL,
0x0000008000007810ULL, 0x000fc60007ffe0ffULL, 0x0000600024248625ULL, 0x000fe200078e0025ULL,
0x0000f6a828287810ULL, 0x000fe40007ffe0ffULL, 0x00000008605f7812ULL, 0x000fe400078e3cffULL,
0x00000006243b8981ULL, 0x000562000c1e1900ULL, 0x000000362700720cULL, 0x000fe20003f06070ULL,
0x0000000128607824ULL, 0x040fe200078e0260ULL, 0x0000000003277217ULL, 0x000fe20007800000ULL,
0x00000001285f7824ULL, 0x000fe200078e025fULL, 0x00000003ff327819ULL, 0x000fe20000011637ULL,
0x00000040262b7824ULL, 0x000fe200078e00ffULL, 0x00000000600473c2ULL, 0x000ee200000e0000ULL,
0x0000000127277824ULL, 0x000fc400078e0a00ULL, 0x0000001002247824ULL, 0x004fe200078e00ffULL,
0x000000203d257812ULL, 0x000fe200078ef800ULL, 0x0000100044687824ULL, 0x000fe200078e00ffULL,
0x0000002027277807ULL, 0x000fe40000000000ULL, 0x0000001024287812ULL, 0x000fe200078ec0ffULL,
0x0000000148007824ULL, 0x100fe400078e0225ULL, 0x000000014a247824ULL, 0x100fe200078e0225ULL,
0x0000002728277217ULL, 0x000fe20007800000ULL, 0x000000014c267824ULL, 0x100fe200078e0225ULL,
0x000000002b007210ULL, 0x040fe20007f1e0ffULL, 0x000000014e257824ULL, 0x000fe200078e0225ULL,
0x000000242b247210ULL, 0x000fe20007f5e0ffULL, 0x0000000127277824ULL, 0x000fe200078e0a28ULL,
0x000000262b267210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200000e06ffULL,
0x00005e0000307a11ULL, 0x000fe200078038ffULL, 0x000000ffff297224ULL, 0x000fe200010e06ffULL,
0x00005e00242c7a11ULL, 0x000fc400078438ffULL, 0x000000252b257210ULL, 0x000fe40007f9e0ffULL,
0x00005f00002d7a11ULL, 0x000fe400000f3c2dULL, 0x00005f00242e7a11ULL, 0x000fe200010f3c29ULL,
0x000000ffff297224ULL, 0x000fe200018e06ffULL, 0x0000100068007812ULL, 0x000fe200078ec0ffULL,
0x000000ffff247224ULL, 0x000fe200020e06ffULL, 0x00005e0026287a11ULL, 0x040fe400078038ffULL,
0x00005e00252a7a11ULL, 0x000fe200078438ffULL, 0x0000200049007824ULL, 0x000fe200078e0200ULL,
0x00005f0026297a11ULL, 0x000fc400000f3c29ULL, 0x0000000432267810ULL, 0x040fe40007ffe0ffULL,
0x000000273200720cULL, 0x000fe40003f86070ULL, 0x00005f00252b7a11ULL, 0x000fe400010f3c24ULL,
0x0000005130247210ULL, 0x000fe40007f5e0ffULL, 0x000000272600720cULL, 0x000fe40003f06070ULL,
0x0000b00000007810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff257224ULL, 0x000fe200010e062dULL,
0x0000000832267810ULL, 0x000fc40007ffe0ffULL, 0x0000000c32327810ULL, 0x000fe20007ffe0ffULL,
0x000000104b2d7824ULL, 0x100fe200078e0200ULL, 0x000000272600720cULL, 0x000fe20003f66070ULL,
0x000000104d2f7824ULL, 0x100fe200078e0200ULL, 0x000000512c267210ULL, 0x000fe20007fbe0ffULL,
0x000000104f317824ULL, 0x000fe200078e0200ULL, 0x000000273200720cULL, 0x000fe20003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242d7faeULL, 0x0005e2000e101c46ULL,
0x0000005128287210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff277224ULL, 0x000fe200028e062eULL,
0x000000512a2a7210ULL, 0x000fe20007fbe0ffULL, 0x0000001050337824ULL, 0x000fc400078e0200ULL,
0x000000ffff297224ULL, 0x000fe200020e0629ULL, 0x00000000262f7faeULL, 0x0005e2000c101c46ULL,
0x000000ffff2b7224ULL, 0x000fc600028e062bULL, 0x0000000028317faeULL, 0x0005e8000d901c46ULL,
0x000000002a337faeULL, 0x0005e8000d101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000060247f8cULL, 0x0044e8000c80043fULL,
0x000004005f297984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6280046267f8cULL, 0x000fe2000c80043fULL,
0x8000000029ff7812ULL, 0x010fc60007844863ULL, 0x00f62c00462b7984ULL, 0x000f240000000800ULL,
0x800000002bff7812ULL, 0x010fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff677224ULL, 0x008fe200078e0025ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0xffffffe038467812ULL, 0x040fe200078ec0ffULL,
0x3e000000ff007424ULL, 0x000fe200078e00ffULL, 0x0000001038257812ULL, 0x040fe400078ec0ffULL,
0x0000000838247812ULL, 0x000fc800078ec0ffULL, 0x0000004624467210ULL, 0x000fe40007ffe025ULL,
0x0000000000247305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000240000735dULL, 0x010fe20003800000ULL, 0x00f62c0046257984ULL, 0x000ee40000000800ULL,
0x8000000025ff7812ULL, 0x008fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002002007824ULL, 0x000fca00078e00ffULL, 0xffffff8000007812ULL, 0x000fc800078ec0ffULL,
0x0000008051257810ULL, 0x000fca0007ffe000ULL, 0x0000000152257824ULL, 0x000fca00078e0225ULL,
0x00f0000025277984ULL, 0x000ee80000000800ULL, 0x00f2000025007984ULL, 0x0008620000000800ULL,
0x000000402700720bULL, 0x008fe20003f1d000ULL, 0x00011db27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x010fc800000e0100ULL, 0x0000ffff24297812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff657424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000139257810ULL, 0x000fe40007ffe0ffULL,
0x000000402700720bULL, 0x000fe40003f14000ULL, 0x000000022500720cULL, 0x000fe20003f65270ULL,
0x00011d727f007947ULL, 0x000ff4000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x0000002740267209ULL, 0x000fe20007810000ULL, 0x00000080022bb824ULL, 0x000fe200078e0251ULL,
0x0000ffff24247812ULL, 0x000fe400078e3cffULL, 0x00000002ff287819ULL, 0x000fe20000011637ULL,
0x00000001522bb824ULL, 0x000fe200078e022bULL, 0x8000002640257221ULL, 0x000fe20000010000ULL,
0x0000002429ff7212ULL, 0x000fc6000780c0ffULL, 0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL,
0x00f400262b00b388ULL, 0x0007e60000000800ULL, 0x00000025002a7308ULL, 0x000f240000000800ULL,
0x0000002a41417220ULL, 0x010fe20000410000ULL, 0x00011cf27f007947ULL, 0x000fea000b800000ULL,
0x00001f282a247589ULL, 0x00872400000e0000ULL, 0x0000002408087220ULL, 0x090fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002420207220ULL, 0x080fe20000410000ULL,
0x0000002421217220ULL, 0x080fe20000410000ULL, 0x0000002404047220ULL, 0x080fe20000410000ULL,
0x0000002405057220ULL, 0x000fe20000410000ULL, 0x00011c327f007947ULL, 0x000fea000b800000ULL,
0x00001f542a247589ULL, 0x0008a400000e0000ULL, 0x8000002627270221ULL, 0x100fe20000010000ULL,
0x00000001ff657807ULL, 0x000fe20000000000ULL, 0x000000240a0a7220ULL, 0x084fe20000410000ULL,
0x000000240b0b7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x000000240f0f7220ULL, 0x080fe20000410000ULL,
0x0000002412127220ULL, 0x080fe20000410000ULL, 0x0000002700450308ULL, 0x000ea20000000800ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x0000002422227220ULL, 0x080fe20000410000ULL,
0x0000002423237220ULL, 0x080fe20000410000ULL, 0x0000002406067220ULL, 0x080fe20000410000ULL,
0x0000002407077220ULL, 0x000fe20000410000ULL, 0x000000ffff407224ULL, 0x000fe200078e0026ULL,
0x0000000045000220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000004100417221ULL, 0x002fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x0000000844007824ULL, 0x000fe200078e00ffULL,
0xfffffff038257812ULL, 0x000fc800078ec0ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000125247824ULL, 0x000fca00078e0200ULL, 0x00f6ac0024257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804863ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000257305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000250000735dULL, 0x004fe40003800000ULL, 0x00f6ac0024257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc40007804863ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff287819ULL, 0x008fe40000011637ULL, 0x00000045ff24723eULL, 0x000fe400000010ffULL,
0x0000001828007810ULL, 0x040fe40007ffe0ffULL, 0x0000001028267810ULL, 0x000fe40007ffe0ffULL,
0x00005410242a7816ULL, 0x010fe20000000024ULL, 0x000119827f007947ULL, 0x000fea000b800000ULL,
0x00001f282a9f7589ULL, 0x0002e400000e0000ULL, 0x000119c27f007947ULL, 0x000fea000b800000ULL,
0x00001f542a967589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff287224ULL, 0x002fe200078e0026ULL, 0x0000513000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0001244000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff287224ULL, 0x002fe200078e0000ULL, 0x0000519000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x000123e000007944ULL, 0x03cfea0003c00000ULL, 0x0000100044007824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100002247824ULL, 0x000fc600078e00ffULL,
0x0000100000007812ULL, 0x000fe400078e0cffULL, 0xffffe00024257812ULL, 0x000fc800078ec0ffULL,
0x0000b00025647810ULL, 0x100fe40007ffe000ULL, 0x0000b0003f007810ULL, 0x000fc60007ffe000ULL,
0x0000001055637824ULL, 0x100fe400078e0264ULL, 0x0000001057647824ULL, 0x000fe400078e0264ULL,
0x000000105c617824ULL, 0x100fe200078e0200ULL, 0x000000006324783bULL, 0x000f220000004200ULL,
0x000000105d627824ULL, 0x000fc600078e0200ULL, 0x000000006428783bULL, 0x016e680000004200ULL,
0x000000006130783bULL, 0x000ea80000004200ULL, 0x00000000622c783bULL, 0x000f220000004200ULL,
0x0000010024b67824ULL, 0x040fe200078e00ffULL, 0x0000002400af7306ULL, 0x000fe20000009400ULL,
0x0001000024b07824ULL, 0x000fe200078e00ffULL, 0x00000018ffbc7819ULL, 0x000fe20000011424ULL,
0x0000010025bf7824ULL, 0x040fe200078e00ffULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x0001000025ea7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb07819ULL, 0x000fe200000114b0ULL,
0x0000010026e77824ULL, 0x040fe200078e00ffULL, 0x000000b600b17306ULL, 0x000fe20000209400ULL,
0x00000018ffe67819ULL, 0x000fe20000011425ULL, 0x0000010027e27824ULL, 0x040fe200078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x0001000026dc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffea7819ULL, 0x000fe200000114eaULL, 0x0001000027d97824ULL, 0x000fe200078e00ffULL,
0x00000018ffe77819ULL, 0x000fe200000114e7ULL, 0x000000b600b27306ULL, 0x0007220000205400ULL,
0x00000018ffe27819ULL, 0x000fe200000114e2ULL, 0x0000010028d27824ULL, 0x002fe200078e00ffULL,
0x00000018ffa77819ULL, 0x000fe2000001142aULL, 0x0000010029d17824ULL, 0x000fe200078e00ffULL,
0x00000018ffa47819ULL, 0x000fe2000001142bULL, 0x0001000031eb7824ULL, 0x004fe200078e00ffULL,
0x00000018ffd07819ULL, 0x000fe20000011426ULL, 0x000000b000ba7306ULL, 0x000fe20000209400ULL,
0x000000b600b67245ULL, 0x008fe2000020d400ULL, 0x0000010032ed7824ULL, 0x000fe200078e00ffULL,
0x00000018ffcd7819ULL, 0x000fc40000011427ULL, 0x00000018ffdc7819ULL, 0x000fe400000114dcULL,
0x00000018ffd97819ULL, 0x000fe200000114d9ULL, 0x000000b000b97306ULL, 0x0002a20000205400ULL,
0x000000b2b100720bULL, 0x010fe20003f9d000ULL, 0x000100002ab17824ULL, 0x000fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe40000011430ULL, 0x00000018ff927819ULL, 0x000fe40000011431ULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x0000002400f27306ULL, 0x000ee20000005400ULL,
0x000000b000b07245ULL, 0x002fc4000020d400ULL, 0x00000018ffd17819ULL, 0x000fe400000114d1ULL,
0x00000018ffbb7819ULL, 0x000fe40000011428ULL, 0x00000001b6b64812ULL, 0x000fe200078efcffULL,
0x000000bc00b47306ULL, 0x000fe20000209400ULL, 0x000000b9ba00720bULL, 0x004fe40003fbd000ULL,
0x00000018ff8a7819ULL, 0x000fe40000011432ULL, 0x00000018ff857819ULL, 0x000fc40000011433ULL,
0x00000018ffa67819ULL, 0x000fe20000011429ULL, 0x000000bc00b57306ULL, 0x000e620000205400ULL,
0x000000f2af00720bULL, 0x008fe20003f7d000ULL, 0x000001002aaf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb17819ULL, 0x000fe400000114b1ULL, 0x00000018ff777819ULL, 0x000fe4000001142cULL,
0x00000001b0b05812ULL, 0x000fe200078efcffULL, 0x0000002600ad7306ULL, 0x000fe20000009400ULL,
0x00000018ffaf7819ULL, 0x000fc400000114afULL, 0x00000018ff727819ULL, 0x000fe4000001142dULL,
0x00000018ff6d7819ULL, 0x000fe4000001142eULL, 0x00000018ff6c7819ULL, 0x000fe2000001142fULL,
0x0000002600b87306ULL, 0x000ea20000005400ULL, 0x000000b5b400720bULL, 0x002fe20003f1d000ULL,
0x0000010030b47824ULL, 0x000fca00078e00ffULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x0000002400937306ULL, 0x000e70000000d400ULL, 0x0000002500f47306ULL, 0x000fe20000009400ULL,
0x000000b8ad00720bULL, 0x004fe20003fdd000ULL, 0x000001002bad7824ULL, 0x000fc400078e00ffULL,
0x000100002bb87824ULL, 0x000fc600078e00ffULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x0000002500d57306ULL, 0x000ea20000005400ULL, 0x0000000193933812ULL, 0x002fe400078efcffULL,
0x00000018ffb87819ULL, 0x000fca00000114b8ULL, 0x000000e600ee7306ULL, 0x000ff00000209400ULL,
0x000000e600b77306ULL, 0x000e620000205400ULL, 0x000000d5f400720bULL, 0x004fce0003f5d000ULL,
0x000000bf00b37306ULL, 0x000ff00000209400ULL, 0x000000bf00f07306ULL, 0x000ea20000205400ULL,
0x000000b7ee00720bULL, 0x002fe40003fbd000ULL, 0x000000bc00b77245ULL, 0x000fc8000020d400ULL,
0x00000001b7b70812ULL, 0x000fe200078efcffULL, 0x000000ea00c07306ULL, 0x000ff00000209400ULL,
0x000000ea00c77306ULL, 0x000e620000205400ULL, 0x000000f0b300720bULL, 0x004fce0003f9d000ULL,
0x0000002a00c47306ULL, 0x000ff00000009400ULL, 0x0000002a00c37306ULL, 0x000fe20000005400ULL,
0x000000c7c000720bULL, 0x002fe20003f1d000ULL, 0x0001000033c77824ULL, 0x000fca00078e00ffULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x0000002a00847306ULL, 0x0003f0000000d400ULL,
0x0000002b00c27306ULL, 0x000fe20000009400ULL, 0x00000200022a7824ULL, 0x002fce00078e00ffULL,
0x0000002b00bd7306ULL, 0x000ff00000005400ULL, 0x0000002b007f7306ULL, 0x0003f0000000d400ULL,
0x0000002500917306ULL, 0x000ea2000000d400ULL, 0x00009910652b7816ULL, 0x002fc800000000ffULL,
0x000000ff2b00720cULL, 0x000fe40003f65270ULL, 0xfffff8002a2b7812ULL, 0x000fe200078ec0ffULL,
0x000000e700c87306ULL, 0x000fe20000209400ULL, 0x00000100312a7824ULL, 0x000fc600078e00ffULL,
0x0000000166657824ULL, 0x100fe400078e022bULL, 0x000000017c667824ULL, 0x000fe200078e022bULL,
0x000000bf007c7245ULL, 0x000fe2000020d400ULL, 0x000000e700c97306ULL, 0x000e620000205400ULL,
0x0000000191912812ULL, 0x004fe200078efcffULL, 0x00010000302b7824ULL, 0x000fe200078e00ffULL,
0x000000017c7c4812ULL, 0x000fe400078efcffULL, 0x00000018ffbf7819ULL, 0x000fe2000001142aULL,
0x00000100332a7824ULL, 0x000fc400078e00ffULL, 0x000000e200e97306ULL, 0x000ff00000209400ULL,
0x000000e200ec7306ULL, 0x000ea20000205400ULL, 0x000000c9c800720bULL, 0x002fe20003f9d000ULL,
0x0001000032c87824ULL, 0x000fca00078e00ffULL, 0x00000018ffc87819ULL, 0x000fe200000114c8ULL,
0x0000002700e07306ULL, 0x000ff00000009400ULL, 0x0000002700e17306ULL, 0x000fe20000005400ULL,
0x000000ece900720bULL, 0x004fce0003f5d000ULL, 0x000000d000da7306ULL, 0x000ff00000209400ULL,
0x000000d000dd7306ULL, 0x000ff00000205400ULL, 0x00000026008c7306ULL, 0x000e70000000d400ULL,
0x000000cd00d77306ULL, 0x000ff00000209400ULL, 0x000000cd00cc7306ULL, 0x000ea20000205400ULL,
0x000000018c8c6812ULL, 0x002fce00078efcffULL, 0x000000dc00e57306ULL, 0x000ff00000209400ULL,
0x000000dc00e87306ULL, 0x000fe20000205400ULL, 0x000000ccd700720bULL, 0x004fe40003fdd000ULL,
0x000000d000d77245ULL, 0x000fc4000020d400ULL, 0x000000dc00cc7245ULL, 0x000fc6000020d400ULL,
0x000000d900e37306ULL, 0x000ff00000209400ULL, 0x000000d900e47306ULL, 0x0003f00000205400ULL,
0x0000003000987306ULL, 0x000fe20000009400ULL, 0x000000d900d97245ULL, 0x002fce000020d400ULL,
0x0000003000a57306ULL, 0x000ff00000005400ULL, 0x00000030007b7306ULL, 0x0003f0000000d400ULL,
0x00000031009a7306ULL, 0x000fe20000009400ULL, 0x000000ea00307245ULL, 0x002fc8000020d400ULL,
0x0000000130300812ULL, 0x000fe400078efcffULL, 0x000000e1e000720bULL, 0x000fe20003f1d000ULL,
0x0000003100957306ULL, 0x000ff00000005400ULL, 0x0000003100007306ULL, 0x0003f0000000d400ULL,
0x00000027008b7306ULL, 0x0004e2000000d400ULL, 0x000000e600317245ULL, 0x002fc4000020d400ULL,
0x00000018ffe67819ULL, 0x000fe4000001142bULL, 0x0000000131315812ULL, 0x000fe400078efcffULL,
0x000000ddda00720bULL, 0x000fe20003fbd000ULL, 0x000000d200de7306ULL, 0x000fe20000209400ULL,
0x0001000029277824ULL, 0x004fe200078e00ffULL, 0x00000018ffda7819ULL, 0x000fc800000114ebULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x000000d200df7306ULL, 0x0002a20000205400ULL,
0x000000018b8b0812ULL, 0x008fc600078efcffULL, 0x00000001d7d75812ULL, 0x000fc800078efcffULL,
0x000000d100d67306ULL, 0x000fe20000209400ULL, 0x000000d200d27245ULL, 0x002fce000020d400ULL,
0x000000d100db7306ULL, 0x0002e20000205400ULL, 0x000000dfde00720bULL, 0x004fce0003f1d000ULL,
0x0000002800ce7306ULL, 0x000fe20000009400ULL, 0x000000d100d17245ULL, 0x002fca000020d400ULL,
0x00000001d2d20812ULL, 0x000fe400078efcffULL, 0x0000002800cf7306ULL, 0x000e620000005400ULL,
0x000000dbd600720bULL, 0x008fe20003fbd000ULL, 0x000001002cd67824ULL, 0x000fcc00078e00ffULL,
0x0000002800897306ULL, 0x0005ec000000d400ULL, 0x00000001d1d15812ULL, 0x000fe400078efcffULL,
0x0000003200a37306ULL, 0x000fe20000009400ULL, 0x0001000028287824ULL, 0x004fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000003200947306ULL, 0x000ff00000005400ULL,
0x0000003200767306ULL, 0x0005f0000000d400ULL, 0x0000003300ae7306ULL, 0x000fe20000009400ULL,
0x000000e200327245ULL, 0x004fc8000020d400ULL, 0x0000000132322812ULL, 0x000fe400078efcffULL,
0x000000e4e300720bULL, 0x000fe20003f5d000ULL, 0x0000003300997306ULL, 0x000ff00000005400ULL,
0x0000003300757306ULL, 0x0005e8000000d400ULL, 0x00000001d9d92812ULL, 0x000fc800078efcffULL,
0x0000002900cb7306ULL, 0x000fe20000009400ULL, 0x000000e700337245ULL, 0x004fc8000020d400ULL,
0x0000000133334812ULL, 0x000fe400078efcffULL, 0x000000e8e500720bULL, 0x000fe20003f9d000ULL,
0x0000002900ca7306ULL, 0x000ea20000005400ULL, 0x0000008c338c723eULL, 0x000fce00000010ffULL,
0x000000bb00c67306ULL, 0x000fe80000209400ULL, 0x00000001cccc4812ULL, 0x000fe400078efcffULL,
0x000000cfce00720bULL, 0x002fe20003f9d000ULL, 0x000100002dcf7824ULL, 0x000fe200078e00ffULL,
0x000000bb00c57306ULL, 0x000e620000205400ULL, 0x000000cacb00720bULL, 0x004fe40003f5d000ULL,
0x000000cd00ce7245ULL, 0x000fc4000020d400ULL, 0x00000018ffca7819ULL, 0x000fe400000114edULL,
0x00000001cece6812ULL, 0x000fe200078efcffULL, 0x0000002800d37306ULL, 0x000fe20000209400ULL,
0x00000018ffcf7819ULL, 0x000fe400000114cfULL, 0x0000000189894812ULL, 0x000fe400078efcffULL,
0x000000c3c400720bULL, 0x000fe40003f9d000ULL, 0x0000002800c37245ULL, 0x000fe2000020d400ULL,
0x0000002800d87306ULL, 0x000ea20000205400ULL, 0x000000c5c600720bULL, 0x002fc40003f1d000ULL,
0x00000018ffc57819ULL, 0x000fe4000001142aULL, 0x000000a600c47245ULL, 0x000fe4000020d400ULL,
0x000000ccd7cc723eULL, 0x000fe200000010ffULL, 0x0000002700d47306ULL, 0x000fe40000209400ULL,
0x0000000184844812ULL, 0x000fcc00078efcffULL, 0x0000002700d57306ULL, 0x000e620000205400ULL,
0x000000d8d300720bULL, 0x004fe20003fdd000ULL, 0x000001002dd87824ULL, 0x000fcc00078e00ffULL,
0x0000002900887306ULL, 0x000eac000000d400ULL, 0x00000001c3c36812ULL, 0x000fe400078efcffULL,
0x000000a600c17306ULL, 0x000fe20000209400ULL, 0x000000d5d400720bULL, 0x002fce0003fbd000ULL,
0x000000a600be7306ULL, 0x0002e20000205400ULL, 0x0000000188882812ULL, 0x004fe400078efcffULL,
0x000000bdc200720bULL, 0x000fe40003f5d000ULL, 0x000000bb00c27245ULL, 0x000fe2000020d400ULL,
0x000100002ebb7824ULL, 0x000fe200078e00ffULL, 0x0000002700bd7245ULL, 0x000fe2000020d400ULL,
0x000000af00247306ULL, 0x000fe20000209400ULL, 0x00000001c2c20812ULL, 0x000fe200078efcffULL,
0x000100002fa67824ULL, 0x002fe200078e00ffULL, 0x00000001bdbd5812ULL, 0x000fc400078efcffULL,
0x00000088d1d1723eULL, 0x000fe400000010ffULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x000000af00257306ULL, 0x0002a20000205400ULL, 0x000000bec100720bULL, 0x008fe20003fdd000ULL,
0x000001002ec17824ULL, 0x000fe200078e00ffULL, 0x000000017f7f2812ULL, 0x000fe200078efcffULL,
0x000001002fbe7824ULL, 0x000fe200078e00ffULL, 0x000000a59800720bULL, 0x000fe40003f5d000ULL,
0x000000a700987245ULL, 0x000fe2000020d400ULL, 0x000000ad00267306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fc4000020d400ULL, 0x00000018ffc17819ULL, 0x000fe400000114c1ULL,
0x00000018ffbe7819ULL, 0x000fe400000114beULL, 0x00000001c4c46812ULL, 0x000fe200078efcffULL,
0x000000ad00297306ULL, 0x000e620000205400ULL, 0x000000252400720bULL, 0x004fe40003f1d000ULL,
0x000000017b7b2812ULL, 0x000fe400078efcffULL, 0x00000099ae00720bULL, 0x000fc40003f5d000ULL,
0x000000aa00997245ULL, 0x000fe2000020d400ULL, 0x000000a7009b7306ULL, 0x000fe20000209400ULL,
0x000000bdc4bd723eULL, 0x000fe400000010ffULL, 0x00000018ffa67819ULL, 0x000fc600000114a6ULL,
0x00000001afaf0812ULL, 0x000fe400078efcffULL, 0x000000a700a27306ULL, 0x000ea20000205400ULL,
0x000000292600720bULL, 0x002fe40003fbd000ULL, 0x009800006528783bULL, 0x000e620000000200ULL,
0x0000000175752812ULL, 0x000fe400078efcffULL, 0x00000084af84723eULL, 0x000fe200000010ffULL,
0x009800006624783bULL, 0x000ee20000000200ULL, 0x000000b800b97306ULL, 0x000ff00000209400ULL,
0x000000b800ba7306ULL, 0x0009220000205400ULL, 0x000000a29b00720bULL, 0x004fc40003fdd000ULL,
0x000000ad00a27245ULL, 0x000fe4000020d400ULL, 0x00000092009b7245ULL, 0x000fe4000020d400ULL,
0x00000001a2a25812ULL, 0x000fe200078efcffULL, 0x000000b400b37306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x010fca000020d400ULL, 0x0000000198986812ULL, 0x000fe400078efcffULL,
0x000000b400bc7306ULL, 0x0005220000205400ULL, 0x000000bab900720bULL, 0x000fe40003fbd000ULL,
0x00000094a300720bULL, 0x000fe40003fdd000ULL, 0x00000018ff947819ULL, 0x000fc600000114d6ULL,
0x000000e600e07306ULL, 0x000fe20000209400ULL, 0x000000b400b47245ULL, 0x004fe2000020d400ULL,
0x0000009f2828b231ULL, 0x082fe400003400ffULL, 0x0000009f2a2ab231ULL, 0x080fe400003400ffULL,
0x00000001b8b85812ULL, 0x000fe200078efcffULL, 0x0000009f2424b231ULL, 0x088fe200003400ffULL,
0x000000e600dd7306ULL, 0x0002a20000205400ULL, 0x000000bcb300720bULL, 0x010fe20003fbd000ULL,
0x0000009f2626b231ULL, 0x000fe200003400ffULL, 0x0000000176766812ULL, 0x000fe200078efcffULL,
0x000000962929b231ULL, 0x080fe200003400ffULL, 0x000000c3c2bc723eULL, 0x000fe200000010ffULL,
0x000000962b2bb231ULL, 0x000fc400003400ffULL, 0x000000aa00ab7306ULL, 0x000fe20000209400ULL,
0x000000962525b231ULL, 0x080fe200003400ffULL, 0x000000e600e67245ULL, 0x002fe2000020d400ULL,
0x000000962727b231ULL, 0x000fe200003400ffULL, 0x00000018ff967819ULL, 0x000fe200000114d8ULL,
0x000000bc281c723cULL, 0x000fe2000004181cULL, 0x00000001b4b45812ULL, 0x000fe400078efcffULL,
0x000000aa009e7306ULL, 0x000e620000205400ULL, 0x000000dde000720bULL, 0x004fe40003f7d000ULL,
0x0000007bb4b4723eULL, 0x000fca00000010ffULL, 0x000000ca00c67306ULL, 0x000fec0000209400ULL,
0x00000001e6e63812ULL, 0x000fe400078efcffULL, 0x000000ca00d57306ULL, 0x000ea20000205400ULL,
0x0000009eab00720bULL, 0x002fce0003fbd000ULL, 0x0000002c00977306ULL, 0x000fec0000009400ULL,
0x0000000199995812ULL, 0x000fe400078efcffULL, 0x0000002c009c7306ULL, 0x000e620000005400ULL,
0x000000d5c600720bULL, 0x004fce0003f7d000ULL, 0x000000b100b27306ULL, 0x000ff00000209400ULL,
0x000000b100b57306ULL, 0x0004e20000205400ULL, 0x0000009c9700720bULL, 0x002fce0003fbd000ULL,
0x000000a4009d7306ULL, 0x000fe20000209400ULL, 0x000000b100b17245ULL, 0x004fce000020d400ULL,
0x000000a400a87306ULL, 0x000e620000205400ULL, 0x000000b5b200720bULL, 0x008fce0003f1d000ULL,
0x000000c500d37306ULL, 0x000fec0000209400ULL, 0x00000001b1b10812ULL, 0x000fe400078efcffULL,
0x000000c500d47306ULL, 0x000fe20000205400ULL, 0x000000a89d00720bULL, 0x002fe40003f9d000ULL,
0x000000959a00720bULL, 0x000fc40003f1d000ULL, 0x000000a400957245ULL, 0x000fc6000020d400ULL,
0x0000002c007a7306ULL, 0x0002ac000000d400ULL, 0x0000000195954812ULL, 0x000fe400078efcffULL,
0x0000008a008d7306ULL, 0x000fe20000209400ULL, 0x000100002c2c7824ULL, 0x002fe200078e00ffULL,
0x0000000100000812ULL, 0x000fc400078efcffULL, 0x000000b89595723eULL, 0x000fe400000010ffULL,
0x00000018ff977819ULL, 0x000fe4000001142cULL, 0x00000093b62c723eULL, 0x000fe200000010ffULL,
0x0000008a008e7306ULL, 0x000e620000205400ULL, 0x000000ca00937245ULL, 0x000fe4000020d400ULL,
0x000000017a7a5812ULL, 0x004fe400078efcffULL, 0x0000000193933812ULL, 0x000fc400078efcffULL,
0x000000d4d300720bULL, 0x000fe20003f7d000ULL, 0x000000bf00c07306ULL, 0x000ff00000209400ULL,
0x000000bf00c97306ULL, 0x0004e20000205400ULL, 0x0000008e8d00720bULL, 0x002fc40003fdd000ULL,
0x0000008b328d723eULL, 0x000fca00000010ffULL, 0x000000c800cd7306ULL, 0x000fe20000209400ULL,
0x000000bf00bf7245ULL, 0x004fe2000020d400ULL, 0x0000008c2810723cULL, 0x000fec0000041810ULL,
0x000000c800b27306ULL, 0x0002a20000205400ULL, 0x000000c9c000720bULL, 0x008fe40003f9d000ULL,
0x000000c700c97245ULL, 0x000fca000020d400ULL, 0x0000002d00a97306ULL, 0x000fe20000009400ULL,
0x000000c800c87245ULL, 0x002fca000020d400ULL, 0x00000001bfbf4812ULL, 0x000fe400078efcffULL,
0x0000002d00a07306ULL, 0x000fe40000005400ULL, 0x00000000bfb5723eULL, 0x000fe400000010ffULL,
0x0000007700007245ULL, 0x000fc8000020d400ULL, 0x0000002d00707306ULL, 0x0003f0000000d400ULL,
0x0000009200ac7306ULL, 0x000fe20000209400ULL, 0x000000917c2d723eULL, 0x002fce00000010ffULL,
0x0000009200a17306ULL, 0x000e620000205400ULL, 0x0000002c2808723cULL, 0x000fee0000041808ULL,
0x000000c5002c7245ULL, 0x000fe2000020d400ULL, 0x000000da00d07306ULL, 0x000fe20000209400ULL,
0x0000008a002d7245ULL, 0x000fc4000020d400ULL, 0x000000012c2c3812ULL, 0x000fe400078efcffULL,
0x000000b2cd00720bULL, 0x004fe40003f7d000ULL, 0x000000a1ac00720bULL, 0x002fe20003f1d000ULL,
0x000000da00cb7306ULL, 0x0002a20000205400ULL, 0x000000012d2d6812ULL, 0x000fe400078efcffULL,
0x000000d9cecd723eULL, 0x000fca00000010ffULL, 0x0000009400a37306ULL, 0x000fe20000209400ULL,
0x000000da00da7245ULL, 0x002fe2000020d400ULL, 0x000000cc2814723cULL, 0x000fe20000041814ULL,
0x00000001c8c83812ULL, 0x000fe400078efcffULL, 0x000000019b9b0812ULL, 0x000fe400078efcffULL,
0x000000c82dc8723eULL, 0x000fe200000010ffULL, 0x0000009400a87306ULL, 0x000e620000205400ULL,
0x000000cbd000720bULL, 0x004fe20003f9d000ULL, 0x000000b42408723cULL, 0x000fe20000041808ULL,
0x00000089d2d0723eULL, 0x000fca00000010ffULL, 0x0000008500877306ULL, 0x000fe40000209400ULL,
0x000000d02818723cULL, 0x000fe80000041818ULL, 0x00000001dada4812ULL, 0x000fe400078efcffULL,
0x0000008500867306ULL, 0x000ea20000205400ULL, 0x000000a8a300720bULL, 0x002fe40003fdd000ULL,
0x000000a0a900720bULL, 0x000fc40003f9d000ULL, 0x000000da9b9b723eULL, 0x000fc600000010ffULL,
0x0000002e008f7306ULL, 0x000ff00000009400ULL, 0x0000002e00907306ULL, 0x000e620000005400ULL,
0x000000868700720bULL, 0x004fe40003f7d000ULL, 0x0000000170704812ULL, 0x000fca00078efcffULL,
0x000000c7009d7306ULL, 0x000ff00000209400ULL, 0x000000c700a47306ULL, 0x000ea20000205400ULL,
0x000000908f00720bULL, 0x002fce0003f1d000ULL, 0x00000096009a7306ULL, 0x000ff00000209400ULL,
0x00000096009f7306ULL, 0x000fe20000205400ULL, 0x000000a49d00720bULL, 0x004fce0003f5d000ULL,
0x0000002e006f7306ULL, 0x0002ac000000d400ULL, 0x00000001c9c92812ULL, 0x000fe400078efcffULL,
0x0000002f00837306ULL, 0x000fe20000009400ULL, 0x000000b0b72e723eULL, 0x002fce00000010ffULL,
0x0000002f00827306ULL, 0x000e620000005400ULL, 0x000000016f6f0812ULL, 0x004fce00078efcffULL,
0x0000002f006e7306ULL, 0x0005f0000000d400ULL, 0x0000007700807306ULL, 0x000fe20000209400ULL,
0x00000030312f723eULL, 0x004fe400000010ffULL, 0x0000009600317245ULL, 0x000fc4000020d400ULL,
0x000000828300720bULL, 0x002fc60003f5d000ULL, 0x0000007700817306ULL, 0x000e620000205400ULL,
0x0000002e280c723cULL, 0x000fee000004180cULL, 0x00000094002f7245ULL, 0x000fe2000020d400ULL,
0x00000072007d7306ULL, 0x000fe20000209400ULL, 0x00000085002e7245ULL, 0x000fc4000020d400ULL,
0x000000012f2f6812ULL, 0x000fe400078efcffULL, 0x0000009f9a00720bULL, 0x000fe40003fdd000ULL,
0x000000012e2e3812ULL, 0x000fe200078efcffULL, 0x00000072007e7306ULL, 0x0004e20000205400ULL,
0x000000818000720bULL, 0x002fe40003f7d000ULL, 0x0000007fa285723eULL, 0x000fe400000010ffULL,
0x000000b19894723eULL, 0x000fc400000010ffULL, 0x000000016e6e2812ULL, 0x000fe200078efcffULL,
0x0000009700927306ULL, 0x000fe20000209400ULL, 0x0000007200727245ULL, 0x004fe2000020d400ULL,
0x000000842820723cULL, 0x040fe20000041820ULL, 0x0000000131316812ULL, 0x000fe400078efcffULL,
0x000000e6999a723eULL, 0x000fe400000010ffULL, 0x0000000100003812ULL, 0x000fe200078efcffULL,
0x00000097008f7306ULL, 0x0002a20000205400ULL, 0x0000007e7d00720bULL, 0x008fe20003fbd000ULL,
0x000000942804723cULL, 0x000fe20000041804ULL, 0x000000c92ec9723eULL, 0x000fc400000010ffULL,
0x0000007a2f7a723eULL, 0x000fe400000010ffULL, 0x00000070317b723eULL, 0x000fe200000010ffULL,
0x000000cf00307306ULL, 0x000fe20000209400ULL, 0x000000752c29723eULL, 0x000fe200000010ffULL,
0x0000009a240c723cULL, 0x040fe2000004180cULL, 0x000000769328723eULL, 0x000fe400000010ffULL,
0x0000009700977245ULL, 0x002fe4000020d400ULL, 0x000000c1002a7245ULL, 0x000fe2000020d400ULL,
0x000000cf00337306ULL, 0x0002e20000205400ULL, 0x0000008f9200720bULL, 0x004fe20003fdd000ULL,
0x000000282410723cULL, 0x000fe20000041810ULL, 0x0000000172725812ULL, 0x000fca00078efcffULL,
0x000000c100327306ULL, 0x000fe20000209400ULL, 0x000000cf00cf7245ULL, 0x002fe2000020d400ULL,
0x000000c82414723cULL, 0x040fe80000041814ULL, 0x0000000197976812ULL, 0x000fe400078efcffULL,
0x000000c100877306ULL, 0x000e620000205400ULL, 0x000000333000720bULL, 0x008fe20003f9d000ULL,
0x0000007a2418723cULL, 0x000fe20000041818ULL, 0x000000970028723eULL, 0x000fc400000010ffULL,
0x0000006d00007245ULL, 0x000fc6000020d400ULL, 0x0000006d00737306ULL, 0x000fec0000209400ULL,
0x00000001cfcf4812ULL, 0x000fe400078efcffULL, 0x0000006d00747306ULL, 0x000ea20000205400ULL,
0x000000873200720bULL, 0x002fe40003f7d000ULL, 0x000000cf7229723eULL, 0x000fca00000010ffULL,
0x0000006c00717306ULL, 0x000fe40000209400ULL, 0x00000028241c723cULL, 0x000fe8000004181cULL,
0x000000012a2a3812ULL, 0x000fe400078efcffULL, 0x0000006c00787306ULL, 0x0002e20000205400ULL,
0x000000747300720bULL, 0x004fe40003fdd000ULL, 0x000000a600297245ULL, 0x000fc4000020d400ULL,
0x0000006f2a2a723eULL, 0x000fc600000010ffULL, 0x000000be00827306ULL, 0x000fe20000209400ULL,
0x0000006c006c7245ULL, 0x002fca000020d400ULL, 0x0000000100006812ULL, 0x000fe400078efcffULL,
0x000000be007f7306ULL, 0x000e620000205400ULL, 0x000000787100720bULL, 0x008fce0003f9d000ULL,
0x000000bb007c7306ULL, 0x000fec0000209400ULL, 0x000000016c6c4812ULL, 0x000fe400078efcffULL,
0x000000bb002b7306ULL, 0x0004e20000205400ULL, 0x0000007f8200720bULL, 0x002fce0003fbd000ULL,
0x000000a6002c7306ULL, 0x000fe20000209400ULL, 0x000000bb00bb7245ULL, 0x004fce000020d400ULL,
0x000000a6002d7306ULL, 0x000e620000205400ULL, 0x0000002b7c00720bULL, 0x008fe40003f7d000ULL,
0x000000be002b7245ULL, 0x000fc8000020d400ULL, 0x000000012b2b5812ULL, 0x000fc800078efcffULL,
0x0000006e2b2b723eULL, 0x000fc600000010ffULL, 0x00000001bbbb3812ULL, 0x000fe400078efcffULL,
0x0000002d2c00720bULL, 0x002fe40003f1d000ULL, 0x000000bb0028723eULL, 0x000fe200000010ffULL,
0x0000002a2420723cULL, 0x000ff40000041820ULL, 0x0000000129290812ULL, 0x000fc800078efcffULL,
0x000000296c29723eULL, 0x000fce00000010ffULL, 0x000000282404723cULL, 0x000fe20000041804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200042247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008056007810ULL, 0x000fe20007ffe0ffULL, 0x00f690005eff7f8cULL, 0x0007e2000c80043fULL,
0x00000001446c7812ULL, 0x000fe400078ec0ffULL, 0x000000030000720cULL, 0x000fda0003f06070ULL,
0x000059f000000947ULL, 0x000fea0003800000ULL, 0x0000040079007984ULL, 0x008ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240042007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x0000240042247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000016a6a7824ULL, 0x000fe400078e026bULL,
0x000058003b287a24ULL, 0x020fe200078e02ffULL, 0x00000001ff497819ULL, 0x000fe20000011602ULL,
0xffffffffff3b7424ULL, 0x000fe200078e00ffULL, 0x000000036a007812ULL, 0x000fc800078ec0ffULL,
0x000000030000780cULL, 0x000fc80003f05270ULL, 0x000000013a477807ULL, 0x000fca0004000000ULL,
0x000000016a477824ULL, 0x000fe400078e0247ULL, 0x0000002049007824ULL, 0x000fc600078e0256ULL,
0x000000344700720cULL, 0x000fe40003f06070ULL, 0x000000c000007810ULL, 0x000fe40007ffe0ffULL,
0x0000000135277810ULL, 0x000fe40007ffe0ffULL, 0x0000000003297217ULL, 0x000fe40007800000ULL,
0x000000362700720cULL, 0x000fe40003f46070ULL, 0x000000203d277812ULL, 0x000fc600078ef800ULL,
0x0000000143248824ULL, 0x000fe400078e0247ULL, 0x00000004ff258424ULL, 0x000fe400078e00ffULL,
0x0000000129297824ULL, 0x000fe400078e0a00ULL, 0x0000600024248625ULL, 0x000fc800078e0025ULL,
0x0000004028287824ULL, 0x000fe200078e00ffULL, 0x00000006243b8981ULL, 0x000562000c1e1900ULL,
0x0000000148007824ULL, 0x000fe200078e0227ULL, 0x0000002029297807ULL, 0x000fe20001000000ULL,
0x0000001002267824ULL, 0x000fe200078e00ffULL, 0x00000003ff307819ULL, 0x000fe20000011637ULL,
0x000000005f0473c2ULL, 0x000ee200000e0000ULL, 0x0000000028007210ULL, 0x000fe40007f1e0ffULL,
0x0000001026267812ULL, 0x000fe200078ec0ffULL, 0x000000014a247824ULL, 0x104fe200078e0227ULL,
0x0000000430327810ULL, 0x000fe20007ffe0ffULL, 0x000000014c257824ULL, 0x100fe200078e0227ULL,
0x0000002926297217ULL, 0x000fe20007800000ULL, 0x000000014e277824ULL, 0x000fe200078e0227ULL,
0x00000024282c7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200000e06ffULL,
0x00005e00002e7a11ULL, 0x000fe200078038ffULL, 0x0000000129297824ULL, 0x000fe200078e0a26ULL,
0x0000002528257210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200010e06ffULL,
0x0000002728277210ULL, 0x000fc40007f9e0ffULL, 0x00005f00002d7a11ULL, 0x000fe200000f3c2dULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x00005e002c267a11ULL, 0x040fe200078038ffULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x00005e0025287a11ULL, 0x000fe400078438ffULL,
0x00005e00272a7a11ULL, 0x000fe400078638ffULL, 0x00005f002c2c7a11ULL, 0x000fe400000f3c2bULL,
0x00005f00252b7a11ULL, 0x000fc400010f3c24ULL, 0x00005f0027007a11ULL, 0x000fe400018f3c00ULL,
0x000000293200720cULL, 0x000fe40003f46070ULL, 0x000000512e247210ULL, 0x000fe40007f9e0ffULL,
0x0000000830327810ULL, 0x040fe40007ffe0ffULL, 0x000000293000720cULL, 0x040fe20003f66070ULL,
0x000000ffff257224ULL, 0x000fe200020e062dULL, 0x0000000c30307810ULL, 0x000fc40007ffe0ffULL,
0x0000005126267210ULL, 0x000fe40007fbe0ffULL, 0x000000293200720cULL, 0x080fe40003f06070ULL,
0x000000293000720cULL, 0x000fe20003f86070ULL, 0x000000ffff277224ULL, 0x000fe200028e062cULL,
0x0000005128287210ULL, 0x080fe40007fde0ffULL, 0x000000512a2a7210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024587faeULL, 0x0005e4000d901c46ULL,
0x000000ffff297224ULL, 0x000fc400030e062bULL, 0x000000ffff2b7224ULL, 0x000fe200028e0600ULL,
0x0000000026597faeULL, 0x0005e8000d101c46ULL, 0x00000000285a7faeULL, 0x0005e8000c101c46ULL,
0x000000002a5b7faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000005f587f8cULL, 0x0044e8000c80043fULL,
0x0000040060007984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480046247f8cULL, 0x000fe2000c80043fULL,
0x8000000000ff7812ULL, 0x010fc60007844867ULL, 0x00f64c0046277984ULL, 0x000f240000000800ULL,
0x8000000027ff7812ULL, 0x010fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x000864000021f000ULL,
0x3fa0000000007823ULL, 0x010fe200000100ffULL, 0x000000260000735dULL, 0x002fe20003800000ULL,
0x00f64c0046277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002002007824ULL, 0x000fca00078e00ffULL,
0xffffff8000007812ULL, 0x000fc800078ec0ffULL, 0x0000010051257810ULL, 0x000fca0007ffe000ULL,
0x0000000152257824ULL, 0x000fca00078e0225ULL, 0x00f0000025277984ULL, 0x000f280000000800ULL,
0x00f2000025007984ULL, 0x0002a20000000800ULL, 0x000000402700720bULL, 0x010fe20003f1d000ULL,
0x0000f2627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x002fc800000e0100ULL,
0x0000ffff24297812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ffc77424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000239257810ULL, 0x000fe40007ffe0ffULL, 0x000000402700720bULL, 0x000fe40003f14000ULL,
0x000000022500720cULL, 0x000fe20003f65270ULL, 0x0000f2227f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x0000002740267209ULL, 0x000fe20007810000ULL,
0x00000080022bb824ULL, 0x000fe200078e0251ULL, 0x0000ffff24247812ULL, 0x000fe400078e3cffULL,
0x00000002ff287819ULL, 0x000fe20000011637ULL, 0x00000001522bb824ULL, 0x000fe200078e022bULL,
0x8000002640257221ULL, 0x000fe20000010000ULL, 0x0000002429ff7212ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL, 0x00f400262b00b388ULL, 0x0003e60000000800ULL,
0x00000025002a7308ULL, 0x000f240000000800ULL, 0x0000002a41417220ULL, 0x010fe20000410000ULL,
0x0000f1a27f007947ULL, 0x000fea000b800000ULL, 0x00001f282a247589ULL, 0x00232400000e0000ULL,
0x0000002408087220ULL, 0x090fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x000000240c0c7220ULL, 0x080fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002420207220ULL, 0x080fe20000410000ULL, 0x0000002421217220ULL, 0x080fe20000410000ULL,
0x0000002404047220ULL, 0x080fe20000410000ULL, 0x0000002405057220ULL, 0x000fe20000410000ULL,
0x0000f0e27f007947ULL, 0x000fea000b800000ULL, 0x00001f542a247589ULL, 0x00086400000e0000ULL,
0x8000002627270221ULL, 0x100fe20000010000ULL, 0x00000001ffc77807ULL, 0x000fe20000000000ULL,
0x000000240a0a7220ULL, 0x082fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL, 0x000000240e0e7220ULL, 0x080fe20000410000ULL,
0x000000240f0f7220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x0000002700450308ULL, 0x000e620000000800ULL, 0x0000002413137220ULL, 0x080fe20000410000ULL,
0x0000002416167220ULL, 0x080fe20000410000ULL, 0x0000002417177220ULL, 0x080fe20000410000ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x000000241e1e7220ULL, 0x080fe20000410000ULL, 0x000000241f1f7220ULL, 0x080fe20000410000ULL,
0x0000002422227220ULL, 0x080fe20000410000ULL, 0x0000002423237220ULL, 0x080fe20000410000ULL,
0x0000002406067220ULL, 0x080fe20000410000ULL, 0x0000002407077220ULL, 0x000fe20000410000ULL,
0x000000ffff407224ULL, 0x000fe200078e0026ULL, 0x0000000045000220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000004100417221ULL, 0x004fe20000010000ULL, 0x000000f000002947ULL, 0x000fea0003800000ULL,
0x0000000869007812ULL, 0x000fe400078ec0ffULL, 0xfffffff038257812ULL, 0x000fca00078ec0ffULL,
0x0000000125007824ULL, 0x000fcc00078e0200ULL, 0x00f6ac0000007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x004fe40003800000ULL, 0x0000040060247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fc40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff287819ULL, 0x000fe40000011637ULL, 0x00000045ff24723eULL, 0x000fe400000010ffULL,
0x0000001828007810ULL, 0x040fe40007ffe0ffULL, 0x0000001028267810ULL, 0x000fe40007ffe0ffULL,
0x00005410242a7816ULL, 0x010fe20000000024ULL, 0x0000ee427f007947ULL, 0x000fea000b800000ULL,
0x00001f282a857589ULL, 0x0002a400000e0000ULL, 0x0000ee827f007947ULL, 0x000fea000b800000ULL,
0x00001f542a847589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff287224ULL, 0x002fe200078e0026ULL, 0x00007eb000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000f6c000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff287224ULL, 0x002fe200078e0000ULL, 0x00007f1000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000f66000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000100002287824ULL, 0x002fe200078e00ffULL, 0x0000100068007812ULL, 0x000fe400078ec0ffULL,
0x00009910c7c77816ULL, 0x000fe400000000ffULL, 0xffffe00028297812ULL, 0x004fe400078ec0ffULL,
0x0000b0003f5a7810ULL, 0x000fc40007ffe000ULL, 0x0000b00029007810ULL, 0x000fe40007ffe000ULL,
0x000000ffc700720cULL, 0x000fe20003f65270ULL, 0x000000105c247824ULL, 0x000fe400078e025aULL,
0x0000001055287824ULL, 0x100fe400078e0200ULL, 0x0000001057307824ULL, 0x000fe400078e0200ULL,
0x000000002424783bULL, 0x000e620000004200ULL, 0x000000105d2c7824ULL, 0x000fc600078e025aULL,
0x000000002828783bULL, 0x010ea80000004200ULL, 0x000000003030783bULL, 0x000f280000004200ULL,
0x000000002c2c783bULL, 0x000ee20000004200ULL, 0x0000002500927306ULL, 0x002fe20000009400ULL,
0x00000018ff8b7819ULL, 0x000fe20000011425ULL, 0x0000010025a57824ULL, 0x000fe200078e00ffULL,
0x00000018ffa47819ULL, 0x000fe20000011424ULL, 0x0000010028e37824ULL, 0x044fe200078e00ffULL,
0x00000018ffd87819ULL, 0x000fe20000011428ULL, 0x0001000028dc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc97819ULL, 0x000fe20000011429ULL, 0x0000002800d17306ULL, 0x000fe20000009400ULL,
0x00000018ffe37819ULL, 0x000fe200000114e3ULL, 0x0000010029db7824ULL, 0x040fe200078e00ffULL,
0x00000018ffdc7819ULL, 0x000fe200000114dcULL, 0x0001000029dd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffba7819ULL, 0x010fe20000011430ULL, 0x000001002ad67824ULL, 0x040fe200078e00ffULL,
0x00000018ffdb7819ULL, 0x000fe200000114dbULL, 0x0000002800d27306ULL, 0x000e620000005400ULL,
0x00000018ffdd7819ULL, 0x000fe200000114ddULL, 0x000001002bcb7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd67819ULL, 0x000fe200000114d6ULL, 0x0001000025b07824ULL, 0x000fe200078e00ffULL,
0x00000018ffc27819ULL, 0x000fe2000001142aULL, 0x000100002acd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffcb7819ULL, 0x000fe200000114cbULL, 0x00000028008d7306ULL, 0x000ea2000000d400ULL,
0x00000018ff9f7819ULL, 0x000fe20000011432ULL, 0x0000010032ea7824ULL, 0x000fe200078e00ffULL,
0x00000018ffad7819ULL, 0x000fe20000011431ULL, 0x0000010024967824ULL, 0x040fe200078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe20000011433ULL, 0x0001000024ab7824ULL, 0x000fe200078e00ffULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x000000e300e77306ULL, 0x000fe20000209400ULL,
0x000000d2d100720bULL, 0x002fe20003f5d000ULL, 0x0000010033ec7824ULL, 0x000fe200078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe2000001142bULL, 0x0000010026aa7824ULL, 0x000fe200078e00ffULL,
0x000000dd00c77245ULL, 0x000fe2000020d400ULL, 0x0000010027867824ULL, 0x000fe200078e00ffULL,
0x00000018ffec7819ULL, 0x000fe200000114ecULL, 0x000000e300287306ULL, 0x000e620000205400ULL,
0x00000018ff7d7819ULL, 0x000fc40000011426ULL, 0x00000018ff7a7819ULL, 0x000fe40000011427ULL,
0x00000018ffab7819ULL, 0x000fe400000114abULL, 0x000000018d8d2812ULL, 0x004fe200078efcffULL,
0x000000d800df7306ULL, 0x000fe20000209400ULL, 0x00000018ffaa7819ULL, 0x000fe400000114aaULL,
0x00000018ff6d7819ULL, 0x008fe4000001142cULL, 0x00000018ff867819ULL, 0x000fc40000011486ULL,
0x00000018ff967819ULL, 0x000fe20000011496ULL, 0x000000d800de7306ULL, 0x000ea20000205400ULL,
0x00000028e700720bULL, 0x002fe20003fdd000ULL, 0x0001000030287824ULL, 0x000fe200078e00ffULL,
0x00000018ffa57819ULL, 0x000fe400000114a5ULL, 0x00000018ffb07819ULL, 0x000fe400000114b0ULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x000000db00e47306ULL, 0x000fe20000209400ULL,
0x00000018ff687819ULL, 0x000fc4000001142dULL, 0x00000018ff577819ULL, 0x000fe4000001142eULL,
0x00000018ff557819ULL, 0x000fc6000001142fULL, 0x000000db00e97306ULL, 0x000e620000205400ULL,
0x000000dedf00720bULL, 0x004fe20003fbd000ULL, 0x0001000033df7824ULL, 0x000fca00078e00ffULL,
0x00000018ffdf7819ULL, 0x000fe200000114dfULL, 0x000000dc00e87306ULL, 0x000ff00000209400ULL,
0x000000dc00ed7306ULL, 0x000ea20000205400ULL, 0x000000e9e400720bULL, 0x002fce0003f9d000ULL,
0x0000002900da7306ULL, 0x000ff00000009400ULL, 0x0000002900d97306ULL, 0x000fe20000005400ULL,
0x000000ede800720bULL, 0x004fe20003f1d000ULL, 0x0001000032e87824ULL, 0x000fca00078e00ffULL,
0x00000018ffe87819ULL, 0x000fe200000114e8ULL, 0x000000dd00e67306ULL, 0x000ff00000209400ULL,
0x000000dd00eb7306ULL, 0x000e700000205400ULL, 0x000000c900d37306ULL, 0x000ff00000209400ULL,
0x000000c900d47306ULL, 0x000fe20000205400ULL, 0x000000ebe600720bULL, 0x002fce0003f5d000ULL,
0x000000d600e17306ULL, 0x000fec0000209400ULL, 0x00000001c7c72812ULL, 0x000fe400078efcffULL,
0x000000d600e27306ULL, 0x000ff00000205400ULL, 0x00000025008f7306ULL, 0x000ff00000005400ULL,
0x0000002500007306ULL, 0x0003f0000000d400ULL, 0x0000003000c67306ULL, 0x000fe20000009400ULL,
0x0000010030257824ULL, 0x002fca00078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000003000c37306ULL, 0x000ff00000005400ULL, 0x00000030007f7306ULL, 0x0003f0000000d400ULL,
0x00000029008a7306ULL, 0x0004e2000000d400ULL, 0x000000e300307245ULL, 0x002fc8000020d400ULL,
0x0000000130306812ULL, 0x000fe400078efcffULL, 0x000000d9da00720bULL, 0x000fe20003fdd000ULL,
0x0000002a00cc7306ULL, 0x000fe20000009400ULL, 0x000100002b297824ULL, 0x004fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002a00d57306ULL, 0x000fe80000005400ULL,
0x000000018a8a6812ULL, 0x008fc800078efcffULL, 0x0000002b00ca7306ULL, 0x000ff00000009400ULL,
0x0000002b00cf7306ULL, 0x000e700000005400ULL, 0x000000cb00e07306ULL, 0x000ff00000209400ULL,
0x000000cb00e57306ULL, 0x000ea20000205400ULL, 0x000000cfca00720bULL, 0x002fc40003fdd000ULL,
0x000000d600ca7245ULL, 0x000fe4000020d400ULL, 0x00000018ffcf7819ULL, 0x000fc600000114eaULL,
0x0000003200b57306ULL, 0x000ff00000009400ULL, 0x0000003200b87306ULL, 0x000fe20000005400ULL,
0x000000e5e000720bULL, 0x004fce0003f5d000ULL, 0x0000003200767306ULL, 0x0003f0000000d400ULL,
0x0000002400877306ULL, 0x000fe20000009400ULL, 0x000000d800327245ULL, 0x002fc8000020d400ULL,
0x0000000132325812ULL, 0x000fe400078efcffULL, 0x000000d4d300720bULL, 0x000fe20003fbd000ULL,
0x00000024008c7306ULL, 0x000fe20000005400ULL, 0x0001000026d37824ULL, 0x000fca00078e00ffULL,
0x00000018ffd37819ULL, 0x000fe400000114d3ULL, 0x0000002400707306ULL, 0x0003f0000000d400ULL,
0x0000003100bd7306ULL, 0x000fe20000009400ULL, 0x0000010031247824ULL, 0x002fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000003100c07306ULL, 0x000ff00000005400ULL,
0x00000031007e7306ULL, 0x0003f0000000d400ULL, 0x0000003300bc7306ULL, 0x000fe20000009400ULL,
0x0001000031317824ULL, 0x002fca00078e00ffULL, 0x00000018ffd97819ULL, 0x000fe40000011431ULL,
0x0000003300b77306ULL, 0x000fe20000005400ULL, 0x000000dc00317245ULL, 0x000fc8000020d400ULL,
0x0000000131310812ULL, 0x000fe400078efcffULL, 0x000000d5cc00720bULL, 0x000fe20003f1d000ULL,
0x0000003300737306ULL, 0x0003e2000000d400ULL, 0x000000c900cc7245ULL, 0x000fe2000020d400ULL,
0x0001000027c97824ULL, 0x000fe200078e00ffULL, 0x000000313232723eULL, 0x000fe400000010ffULL,
0x00000001cccc5812ULL, 0x000fe400078efcffULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x000000c200c57306ULL, 0x000fe20000209400ULL, 0x000000db00337245ULL, 0x002fc4000020d400ULL,
0x000000c900317245ULL, 0x000fe4000020d400ULL, 0x0000000133334812ULL, 0x000fe400078efcffULL,
0x000000e2e100720bULL, 0x000fe20003f9d000ULL, 0x000000c200c87306ULL, 0x0002b00000205400ULL,
0x000000cd00ce7306ULL, 0x000fe20000209400ULL, 0x000000c200c27245ULL, 0x002fc6000020d400ULL,
0x00000001caca4812ULL, 0x000fc800078efcffULL, 0x000000cd00d77306ULL, 0x000e620000205400ULL,
0x000000c8c500720bULL, 0x004fe40003fbd000ULL, 0x000000cb00c57245ULL, 0x000fe2000020d400ULL,
0x000001002dcb7824ULL, 0x000fe200078e00ffULL, 0x0000002500c87245ULL, 0x000fe4000020d400ULL,
0x00000001c5c52812ULL, 0x000fe200078efcffULL, 0x0000002b00807306ULL, 0x000eac000000d400ULL,
0x00000001c2c25812ULL, 0x000fc400078efcffULL, 0x000000bf00c47306ULL, 0x000fe20000209400ULL,
0x000000d7ce00720bULL, 0x002fce0003f9d000ULL, 0x000000bf00c17306ULL, 0x000e620000205400ULL,
0x0000000180806812ULL, 0x004fc800078efcffULL, 0x00000080c5c5723eULL, 0x000fc600000010ffULL,
0x00000029002b7306ULL, 0x000ff00000209400ULL, 0x0000002900d07306ULL, 0x000ea20000205400ULL,
0x000000c1c400720bULL, 0x002fe20003fdd000ULL, 0x000100002cc47824ULL, 0x000fe200078e00ffULL,
0x0000002900c17245ULL, 0x000fca000020d400ULL, 0x0000002a00817306ULL, 0x000e70000000d400ULL,
0x0000002400d27306ULL, 0x000fe20000209400ULL, 0x000000d02b00720bULL, 0x004fce0003f5d000ULL,
0x0000002400e77306ULL, 0x000ea20000205400ULL, 0x0000000181810812ULL, 0x002fe400078efcffULL,
0x000000c3c600720bULL, 0x000fe40003f1d000ULL, 0x000000cd00c37245ULL, 0x000fe2000020d400ULL,
0x000100002dcd7824ULL, 0x000fe200078e00ffULL, 0x000000bf00c67245ULL, 0x000fe2000020d400ULL,
0x00000025002a7306ULL, 0x000fe20000209400ULL, 0x00000001c3c34812ULL, 0x000fe400078efcffULL,
0x00000001c1c12812ULL, 0x000fc400078efcffULL, 0x00000001c6c66812ULL, 0x000fe400078efcffULL,
0x000000c0bd00720bULL, 0x000fe20003f5d000ULL, 0x0000002500d17306ULL, 0x000e620000205400ULL,
0x000000e7d200720bULL, 0x004fe20003fbd000ULL, 0x000001002cc07824ULL, 0x000fe200078e00ffULL,
0x0000002400bd7245ULL, 0x000fe4000020d400ULL, 0x000000017f7f0812ULL, 0x000fe400078efcffULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x0000002800de7306ULL, 0x000fe20000209400ULL,
0x000000c1c6c1723eULL, 0x000fc600000010ffULL, 0x000000017e7e2812ULL, 0x000fe400078efcffULL,
0x00000001bdbd5812ULL, 0x000fe400078efcffULL, 0x0000002800e37306ULL, 0x000ea20000205400ULL,
0x000000d12a00720bULL, 0x002fe40003f9d000ULL, 0x000000b7bc00720bULL, 0x000fe20003f5d000ULL,
0x000001002fb77824ULL, 0x000fc800078e00ffULL, 0x000000ba00bb7306ULL, 0x000fe20000209400ULL,
0x00000018ffb77819ULL, 0x000fca00000114b7ULL, 0x00000001c8c84812ULL, 0x000fe400078efcffULL,
0x000000ba00be7306ULL, 0x0002e20000205400ULL, 0x000000e3de00720bULL, 0x004fe40003fdd000ULL,
0x000000b8b500720bULL, 0x000fe20003f9d000ULL, 0x000001002eb87824ULL, 0x000fe200078e00ffULL,
0x0000002800b57245ULL, 0x000fe4000020d400ULL, 0x0000000173732812ULL, 0x000fe200078efcffULL,
0x000000d900d87306ULL, 0x000fe20000209400ULL, 0x000000ba00ba7245ULL, 0x002fc4000020d400ULL,
0x0000008c8700720bULL, 0x000fe40003f5d000ULL, 0x0000009f008c7245ULL, 0x000fe4000020d400ULL,
0x00000001b5b56812ULL, 0x000fe200078efcffULL, 0x000000d900d57306ULL, 0x000e620000205400ULL,
0x000000bebb00720bULL, 0x008fe40003f1d000ULL, 0x0000000176764812ULL, 0x000fe400078efcffULL,
0x000000df00877245ULL, 0x000fc4000020d400ULL, 0x00000018ffb87819ULL, 0x000fe200000114b8ULL,
0x000000ad00b97306ULL, 0x000fe20000209400ULL, 0x0000000170702812ULL, 0x000fca00078efcffULL,
0x00000001baba0812ULL, 0x000fe400078efcffULL, 0x000000ad00b67306ULL, 0x0004e20000205400ULL,
0x000000d5d800720bULL, 0x002fce0003fbd000ULL, 0x00000026009d7306ULL, 0x000fe20000009400ULL,
0x000000ad00ad7245ULL, 0x004fce000020d400ULL, 0x00000026008e7306ULL, 0x000fe20000005400ULL,
0x000000b6b900720bULL, 0x008fe40003fdd000ULL, 0x000000d900b67245ULL, 0x000fc8000020d400ULL,
0x00000001b6b65812ULL, 0x000fe200078efcffULL, 0x00000026006c7306ULL, 0x000fec000000d400ULL,
0x00000001adad6812ULL, 0x000fe400078efcffULL, 0x0000002700a87306ULL, 0x000fe40000009400ULL,
0x000000b6adad723eULL, 0x000fcc00000010ffULL, 0x0000002700917306ULL, 0x000e700000005400ULL,
0x00000027006b7306ULL, 0x000eb0000000d400ULL, 0x000000cf00267306ULL, 0x000fe20000209400ULL,
0x00000091a800720bULL, 0x002fce0003f5d000ULL, 0x000000cf00277306ULL, 0x0002ec0000205400ULL,
0x000000016b6b2812ULL, 0x004fe400078efcffULL, 0x000000ec002b7306ULL, 0x000fe20000209400ULL,
0x000000cf00cf7245ULL, 0x002fce000020d400ULL, 0x000000ec002a7306ULL, 0x000e620000205400ULL,
0x000000272600720bULL, 0x008fe40003f1d000ULL, 0x00a000006524783bULL, 0x000eaa0000000200ULL,
0x000000ab00ae7306ULL, 0x000fec0000209400ULL, 0x00000001cfcf0812ULL, 0x000fc400078efcffULL,
0x0000002a2b00720bULL, 0x002fe20003fbd000ULL, 0x000000ab00b37306ULL, 0x0003e20000205400ULL,
0x00a000006628783bULL, 0x000ee20000000200ULL, 0x00000076cf76723eULL, 0x000fcc00000010ffULL,
0x0000009f00977306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x002fce000020d400ULL,
0x0000009f009c7306ULL, 0x000e700000205400ULL, 0x000000aa00b27306ULL, 0x000fe20000209400ULL,
0x000000852424b231ULL, 0x084fe400003400ffULL, 0x000000852626b231ULL, 0x000fc400003400ffULL,
0x000000842525b231ULL, 0x000fc600003400ffULL, 0x000000aa00af7306ULL, 0x000ea20000205400ULL,
0x000000842727b231ULL, 0x000fe200003400ffULL, 0x0000009c9700720bULL, 0x002fe40003fdd000ULL,
0x000000ec009c7245ULL, 0x000fc8000020d400ULL, 0x0000002c00907306ULL, 0x000fe20000009400ULL,
0x000000852828b231ULL, 0x088fe200003400ffULL, 0x000000019c9c5812ULL, 0x000fe200078efcffULL,
0x000000852a2ab231ULL, 0x000fe200003400ffULL, 0x0000009600857245ULL, 0x000fe2000020d400ULL,
0x000000842929b231ULL, 0x080fe400003400ffULL, 0x000000842b2bb231ULL, 0x000fe200003400ffULL,
0x000000b3ae00720bULL, 0x000fe20003f7d000ULL, 0x0000002c00937306ULL, 0x000fe20000005400ULL,
0x000000018c8c6812ULL, 0x000fc400078efcffULL, 0x0000008e9d00720bULL, 0x000fe40003fdd000ULL,
0x00000018ff8e7819ULL, 0x000fe400000114c0ULL, 0x00000018ff847819ULL, 0x000fe200000114cbULL,
0x0000002c006f7306ULL, 0x000fe2000000d400ULL, 0x000000c3c2c0723eULL, 0x000fc600000010ffULL,
0x00000001abab3812ULL, 0x000fe400078efcffULL, 0x000000afb200720bULL, 0x004fe40003f7d000ULL,
0x000000df00b97306ULL, 0x000fe20000209400ULL, 0x000000016c6c6812ULL, 0x000fe200078efcffULL,
0x000000c02414723cULL, 0x000fec0000041814ULL, 0x000000df002c7306ULL, 0x000e700000205400ULL,
0x000000e800bf7306ULL, 0x000ff00000209400ULL, 0x000000e800be7306ULL, 0x000ea20000205400ULL,
0x0000002cb900720bULL, 0x002fc40003fbd000ULL, 0x0000008d302c723eULL, 0x000fe400000010ffULL,
0x000000aa008d7245ULL, 0x000fe4000020d400ULL, 0x0000007d00307245ULL, 0x000fe2000020d400ULL,
0x0000008600a17306ULL, 0x000fe20000209400ULL, 0x000000018d8d3812ULL, 0x000fca00078efcffULL,
0x0000000187875812ULL, 0x000fe400078efcffULL, 0x0000008600a27306ULL, 0x000e620000205400ULL,
0x000000bebf00720bULL, 0x004fce0003f1d000ULL, 0x0000009e00957306ULL, 0x000ff00000209400ULL,
0x0000009e00a07306ULL, 0x0004e20000205400ULL, 0x000000a2a100720bULL, 0x002fce0003f7d000ULL,
0x0000007d00827306ULL, 0x000fe20000209400ULL, 0x0000009e009e7245ULL, 0x004fce000020d400ULL,
0x0000007d00837306ULL, 0x000e620000205400ULL, 0x000000a09500720bULL, 0x008fe40003f9d000ULL,
0x000000e800957245ULL, 0x000fc8000020d400ULL, 0x0000000195950812ULL, 0x000fe200078efcffULL,
0x0000009600947306ULL, 0x000fe20000209400ULL, 0x0000008f9200720bULL, 0x000fe40003f1d000ULL,
0x00000018ff8f7819ULL, 0x000fe400000114c4ULL, 0x00000081cac4723eULL, 0x000fe400000010ffULL,
0x000000019e9e4812ULL, 0x000fe200078efcffULL, 0x0000009600997306ULL, 0x000ea20000205400ULL,
0x000000838200720bULL, 0x002fc40003fdd000ULL, 0x0000008600827245ULL, 0x000fe2000020d400ULL,
0x000000c42410723cULL, 0x000fe20000041810ULL, 0x000000958c86723eULL, 0x000fe400000010ffULL,
0x0000000182823812ULL, 0x000fe200078efcffULL, 0x000000d300bb7306ULL, 0x000fe20000209400ULL,
0x0000000100000812ULL, 0x000fe400078efcffULL, 0x000000879e87723eULL, 0x000fc600000010ffULL,
0x0000000130306812ULL, 0x000fe400078efcffULL, 0x000000d300bc7306ULL, 0x0002e20000205400ULL,
0x000000999400720bULL, 0x004fe20003fbd000ULL, 0x000000862404723cULL, 0x000fec0000041804ULL,
0x000000a500a97306ULL, 0x000fe20000209400ULL, 0x000000d300d37245ULL, 0x002fca000020d400ULL,
0x0000000185855812ULL, 0x000fe400078efcffULL, 0x000000a500ac7306ULL, 0x0002a20000205400ULL,
0x000000bcbb00720bULL, 0x008fe40003f7d000ULL, 0x000000708570723eULL, 0x000fca00000010ffULL,
0x000000a400a77306ULL, 0x000fe20000209400ULL, 0x000000a500a57245ULL, 0x002fca000020d400ULL,
0x00000001d3d33812ULL, 0x000fe400078efcffULL, 0x000000a400987306ULL, 0x0002e20000205400ULL,
0x000000aca900720bULL, 0x004fe40003f9d000ULL, 0x000000b5baac723eULL, 0x000fe400000010ffULL,
0x000000d33030723eULL, 0x000fc600000010ffULL, 0x0000008b00a67306ULL, 0x000fe20000209400ULL,
0x000000a400a47245ULL, 0x002fe2000020d400ULL, 0x000000ac241c723cULL, 0x000fe8000004181cULL,
0x00000001a5a54812ULL, 0x000fe400078efcffULL, 0x0000008b009b7306ULL, 0x0002a20000205400ULL,
0x00000098a700720bULL, 0x008fce0003fbd000ULL, 0x0000008e00947306ULL, 0x000fe20000209400ULL,
0x0000008b008b7245ULL, 0x002fca000020d400ULL, 0x00000001a4a45812ULL, 0x000fe400078efcffULL,
0x0000008e00997306ULL, 0x0002e20000205400ULL, 0x0000009ba600720bULL, 0x004fe40003f1d000ULL,
0x000000939000720bULL, 0x000fe40003fbd000ULL, 0x000000aba4a4723eULL, 0x000fc600000010ffULL,
0x0000007a007c7306ULL, 0x000fe20000209400ULL, 0x0000008e008e7245ULL, 0x002fca000020d400ULL,
0x000000018b8b0812ULL, 0x000fe400078efcffULL, 0x0000007a007b7306ULL, 0x0002a20000205400ULL,
0x000000999400720bULL, 0x008fe40003fdd000ULL, 0x000000016f6f5812ULL, 0x000fca00078efcffULL,
0x000000b000b17306ULL, 0x000fe20000209400ULL, 0x0000007a007a7245ULL, 0x002fca000020d400ULL,
0x000000018e8e6812ULL, 0x000fe400078efcffULL, 0x000000b000b47306ULL, 0x0002e20000205400ULL,
0x0000007b7c00720bULL, 0x004fe40003f7d000ULL, 0x0000006f8e8e723eULL, 0x000fca00000010ffULL,
0x000000c900977306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x002fca000020d400ULL,
0x000000017a7a3812ULL, 0x000fe400078efcffULL, 0x000000c900927306ULL, 0x000e620000205400ULL,
0x000000b4b100720bULL, 0x008fce0003f9d000ULL, 0x0000002e00887306ULL, 0x000fec0000009400ULL,
0x00000001b0b04812ULL, 0x000fe400078efcffULL, 0x0000002e00897306ULL, 0x000ea20000005400ULL,
0x000000929700720bULL, 0x002fce0003f5d000ULL, 0x0000008400917306ULL, 0x000fec0000209400ULL,
0x0000000131312812ULL, 0x000fe400078efcffULL, 0x0000008400967306ULL, 0x0002e20000205400ULL,
0x000000898800720bULL, 0x004fe40003f1d000ULL, 0x000000317a31723eULL, 0x000fca00000010ffULL,
0x0000006d00747306ULL, 0x000fe20000209400ULL, 0x0000008400847245ULL, 0x002fe2000020d400ULL,
0x000000302814723cULL, 0x000fec0000041814ULL, 0x0000006d00757306ULL, 0x0002a20000205400ULL,
0x000000969100720bULL, 0x008fce0003fdd000ULL, 0x0000002d00a37306ULL, 0x000fe20000009400ULL,
0x0000006d006d7245ULL, 0x002fca000020d400ULL, 0x0000000184846812ULL, 0x000fe400078efcffULL,
0x0000002d009a7306ULL, 0x000e620000005400ULL, 0x000000757400720bULL, 0x004fce0003f7d000ULL,
0x0000002d005d7306ULL, 0x0004ec000000d400ULL, 0x000000016d6d3812ULL, 0x000fe400078efcffULL,
0x0000002f00787306ULL, 0x000fe20000009400ULL, 0x0000008a332d723eULL, 0x004fe400000010ffULL,
0x000000c7cc33723eULL, 0x000fc400000010ffULL, 0x0000009aa300720bULL, 0x002fc60003f9d000ULL,
0x0000002f00777306ULL, 0x000e620000005400ULL, 0x0000002c2408723cULL, 0x040fee0000041808ULL,
0x0000006800727306ULL, 0x000fe20000209400ULL, 0x00000032240c723cULL, 0x000fe2000004180cULL,
0x0000007fc82c723eULL, 0x000fc400000010ffULL, 0x0000007ebd2d723eULL, 0x000fe400000010ffULL,
0x000000015d5d4812ULL, 0x008fe400078efcffULL, 0x0000006800717306ULL, 0x0004e20000205400ULL,
0x000000777800720bULL, 0x002fe40003f5d000ULL, 0x000000739c77723eULL, 0x000fe200000010ffULL,
0x0000002c2418723cULL, 0x000fe80000041818ULL, 0x0000008f00907306ULL, 0x000fe20000209400ULL,
0x0000006800687245ULL, 0x004fc6000020d400ULL, 0x000000762420723cULL, 0x000fe80000041820ULL,
0x0000008f00897306ULL, 0x0002a20000205400ULL, 0x000000717200720bULL, 0x008fe40003fbd000ULL,
0x00000000a571723eULL, 0x000fe400000010ffULL, 0x0000006c8d24723eULL, 0x000fe400000010ffULL,
0x0000006b8225723eULL, 0x000fe200000010ffULL, 0x000000b800337306ULL, 0x000fe20000209400ULL,
0x0000008f00007245ULL, 0x000fe2000020d400ULL, 0x000000702808723cULL, 0x000fe20000041808ULL,
0x000000b800277245ULL, 0x000fc4000020d400ULL, 0x0000005d848f723eULL, 0x002fe400000010ffULL,
0x0000000168685812ULL, 0x000fe200078efcffULL, 0x000000b8007c7306ULL, 0x000e620000205400ULL,
0x000000899000720bULL, 0x004fe20003fdd000ULL, 0x000000242810723cULL, 0x000fe20000041810ULL,
0x000000b08ba5723eULL, 0x000fca00000010ffULL, 0x000000cd00817306ULL, 0x000fe40000209400ULL,
0x000000a4280c723cULL, 0x040fe8000004180cULL, 0x0000000100006812ULL, 0x000fe400078efcffULL,
0x000000cd00327306ULL, 0x0004e20000205400ULL, 0x0000007c3300720bULL, 0x002fe20003f7d000ULL,
0x0000008e2818723cULL, 0x000fe20000041818ULL, 0x000000006d24723eULL, 0x000fc400000010ffULL,
0x000000b700007245ULL, 0x000fc6000020d400ULL, 0x0000002e005c7306ULL, 0x000322000000d400ULL,
0x000000cd00cd7245ULL, 0x004fca000020d400ULL, 0x0000000127273812ULL, 0x000fe400078efcffULL,
0x0000002f005b7306ULL, 0x000522000000d400ULL, 0x000100002e2e7824ULL, 0x002fe200078e00ffULL,
0x000000328100720bULL, 0x008fc80003f9d000ULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x000000b700787306ULL, 0x000fe20000209400ULL, 0x000100002f2f7824ULL, 0x004fe200078e00ffULL,
0x000000015c5c0812ULL, 0x010fc800078efcffULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x000000b700737306ULL, 0x000e620000205400ULL, 0x00000001cdcd4812ULL, 0x000fe400078efcffULL,
0x000000015b5b2812ULL, 0x000fe400078efcffULL, 0x000000cd6825723eULL, 0x000fe400000010ffULL,
0x0000005c275c723eULL, 0x000fe200000010ffULL, 0x0000005700697306ULL, 0x000fe80000209400ULL,
0x00000024281c723cULL, 0x000fe8000004181cULL, 0x00000057006a7306ULL, 0x0004e20000205400ULL,
0x000000737800720bULL, 0x002fce0003fbd000ULL, 0x0000005500677306ULL, 0x000fe20000209400ULL,
0x0000005700577245ULL, 0x004fca000020d400ULL, 0x0000000100005812ULL, 0x000fe400078efcffULL,
0x00000055006e7306ULL, 0x000e620000205400ULL, 0x0000006a6900720bULL, 0x008fe40003fdd000ULL,
0x0000005b005d723eULL, 0x000fe400000010ffULL, 0x0000005500007245ULL, 0x000fc6000020d400ULL,
0x0000002e002c7306ULL, 0x000fe40000209400ULL, 0x0000005c2820723cULL, 0x000fe80000041820ULL,
0x0000000157576812ULL, 0x000fe400078efcffULL, 0x0000002e002d7306ULL, 0x0004e20000205400ULL,
0x0000006e6700720bULL, 0x002fce0003f9d000ULL, 0x0000002f00267306ULL, 0x000fe20000209400ULL,
0x0000002e002e7245ULL, 0x004fca000020d400ULL, 0x0000000100004812ULL, 0x000fe400078efcffULL,
0x0000002f00337306ULL, 0x0002a20000205400ULL, 0x0000002d2c00720bULL, 0x008fe40003f7d000ULL,
0x0000002f002f7245ULL, 0x002fd6000020d400ULL, 0x000000012e2e3812ULL, 0x000fe400078efcffULL,
0x000000332600720bULL, 0x004fe40003f1d000ULL, 0x0000002e572e723eULL, 0x000fd600000010ffULL,
0x000000012f2f0812ULL, 0x000fc800078efcffULL, 0x0000002f002f723eULL, 0x000fce00000010ffULL,
0x0000002e2804723cULL, 0x000fe20000041804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200042247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c056567810ULL, 0x000fe20007ffe0ffULL,
0x00f698005eff7f8cULL, 0x0007e2000c80043fULL, 0x00000001446c7812ULL, 0x000fe200078e0cffULL,
0x000000ffff677224ULL, 0x000fe200078e0059ULL, 0x000000035600720cULL, 0x000fda0003f06070ULL,
0x00002cb000000947ULL, 0x000fea0003800000ULL, 0x0000040079007984ULL, 0x008ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240042007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x0000240042247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000347007812ULL, 0x000fe200078ec0ffULL,
0x000058003b267a24ULL, 0x020fe200078e02ffULL, 0x0000030035277a10ULL, 0x000fe20007ffe0ffULL,
0xffffffffff3b7424ULL, 0x000fe200078e00ffULL, 0x000000030000780cULL, 0x000fc80003f05270ULL,
0x000000013a007807ULL, 0x000fca0004000000ULL, 0x0000000147477824ULL, 0x000fca00078e0200ULL,
0x000000344700720cULL, 0x000fe20003f06070ULL, 0x0000010027007824ULL, 0x040fe200078e023eULL,
0x0000000127277810ULL, 0x000fd60007ffe0ffULL, 0x0000000143248824ULL, 0x000fe400078e0247ULL,
0x00000004ff258424ULL, 0x000fc800078e00ffULL, 0x0000600024248625ULL, 0x000fe200078e0025ULL,
0x0000000003297217ULL, 0x000fc80007800000ULL, 0x00000006243b8981ULL, 0x000562000c1e1900ULL,
0x000000362700720cULL, 0x000fe20003f06070ULL, 0x00000040262b7824ULL, 0x000fe200078e00ffULL,
0x000000203d277812ULL, 0x100fe200078ef800ULL, 0x0000000129297824ULL, 0x000fe200078e0a00ULL,
0x00000003ff2e7819ULL, 0x000fe20000011637ULL, 0x0000001002007824ULL, 0x000fe200078e00ffULL,
0x00000000600473c2ULL, 0x000ee200000e0000ULL, 0x0000000148487824ULL, 0x100fe200078e0227ULL,
0x0000002029297807ULL, 0x000fe20000000000ULL, 0x000000014a4a7824ULL, 0x100fe200078e0227ULL,
0x0000001000007812ULL, 0x000fe200078ec0ffULL, 0x000000014c4c7824ULL, 0x100fe200078e0227ULL,
0x000000482b487210ULL, 0x040fe20007f5e0ffULL, 0x000000014e277824ULL, 0x000fe200078e0227ULL,
0x0000004a2b4a7210ULL, 0x000fe20007f7e0ffULL, 0x000000104b4b7824ULL, 0x100fe200078e025aULL,
0x00005e0048247a11ULL, 0x004fe200078038ffULL, 0x000000ffff2d7224ULL, 0x000fe200010e06ffULL,
0x0000002900297217ULL, 0x000fe20007800000ULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x0000004c2b4c7210ULL, 0x000fe20007f5e0ffULL, 0x000000104d4d7824ULL, 0x000fe200078e025aULL,
0x000000272b277210ULL, 0x000fe20007f9e0ffULL, 0x0000000129297824ULL, 0x000fe200078e0a00ULL,
0x00005f00482d7a11ULL, 0x000fe200000f3c2dULL, 0x000000ffff2b7224ULL, 0x000fe200010e06ffULL,
0x00005e004a267a11ULL, 0x000fe200078038ffULL, 0x000000ffff007224ULL, 0x000fe200020e06ffULL,
0x00005e004c287a11ULL, 0x000fe200078438ffULL, 0x000000104f4f7824ULL, 0x000fe200078e025aULL,
0x00005e00272a7a11ULL, 0x000fc400078638ffULL, 0x000000042e307810ULL, 0x000fe40007ffe0ffULL,
0x00005f004a2c7a11ULL, 0x000fe400000f3c25ULL, 0x0000005126267210ULL, 0x000fe40007fbe0ffULL,
0x00005f004c2b7a11ULL, 0x000fe400010f3c2bULL, 0x00005f0027007a11ULL, 0x000fe200018f3c00ULL,
0x000000ffff277224ULL, 0x000fe200028e062cULL, 0x000000293000720cULL, 0x000fc40003f46070ULL,
0x0000005124247210ULL, 0x000fe40007f9e0ffULL, 0x000000082e307810ULL, 0x040fe40007ffe0ffULL,
0x000000292e00720cULL, 0x040fe20003f66070ULL, 0x000000ffff257224ULL, 0x000fe200020e062dULL,
0x0000000c2e2e7810ULL, 0x000fe20007ffe0ffULL, 0x00000010502d7824ULL, 0x000fe200078e025aULL,
0x0000005128287210ULL, 0x000fe40007fbe0ffULL, 0x000000293000720cULL, 0x000fc40003f06070ULL,
0x000000292e00720cULL, 0x000fe20003f86070ULL, 0x000000ffff297224ULL, 0x000fe200028e062bULL,
0x000000512a2a7210ULL, 0x000fc60007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000244b7faeULL, 0x0005e4000d901c46ULL, 0x000000ffff2b7224ULL, 0x000fe400028e0600ULL,
0x00000000264d7faeULL, 0x0005e8000d101c46ULL, 0x00000000284f7faeULL, 0x0005e8000c101c46ULL,
0x000000002a2d7faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000060247f8cULL, 0x0044e8000c80043fULL,
0x000004005f297984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6680046267f8cULL, 0x000fe2000c80043fULL,
0x8000000029ff7812ULL, 0x010fc60007844859ULL, 0x00f66c00462b7984ULL, 0x000f240000000800ULL,
0x800000002bff7812ULL, 0x010fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x000000ffff677224ULL, 0x008fe200078e0025ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000240000735dULL, 0x010fe20003800000ULL, 0x00f66c0046257984ULL, 0x000ee40000000800ULL,
0x8000000025ff7812ULL, 0x008fc40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002002007824ULL, 0x000fca00078e00ffULL, 0xffffff8000007812ULL, 0x000fc800078ec0ffULL,
0x0000018051257810ULL, 0x000fca0007ffe000ULL, 0x0000000152257824ULL, 0x000fca00078e0225ULL,
0x00f0000025277984ULL, 0x000ee80000000800ULL, 0x00f2000025007984ULL, 0x0008620000000800ULL,
0x000000402700720bULL, 0x008fe20003f1d000ULL, 0x0000c7327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x010fc800000e0100ULL, 0x0000ffff24297812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff9f7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000339257810ULL, 0x000fe40007ffe0ffULL,
0x000000402700720bULL, 0x000fe40003f14000ULL, 0x000000022500720cULL, 0x000fe20003f65270ULL,
0x0000c6f27f007947ULL, 0x000ff4000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x0000002740267209ULL, 0x000fe20007810000ULL, 0x000000800251b824ULL, 0x000fe200078e0251ULL,
0x0000ffff24247812ULL, 0x000fe400078e3cffULL, 0x00000002ff287819ULL, 0x000fe20000011637ULL,
0x000000015251b824ULL, 0x000fe200078e0251ULL, 0x8000002640257221ULL, 0x000fe20000010000ULL,
0x0000002429ff7212ULL, 0x000fc6000780c0ffULL, 0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL,
0x00f400265100b388ULL, 0x0007e60000000800ULL, 0x00000025002a7308ULL, 0x000f240000000800ULL,
0x0000002a41417220ULL, 0x010fe20000410000ULL, 0x0000c6727f007947ULL, 0x000fea000b800000ULL,
0x00001f282a247589ULL, 0x00872400000e0000ULL, 0x0000002408087220ULL, 0x090fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002420207220ULL, 0x080fe20000410000ULL,
0x0000002421217220ULL, 0x080fe20000410000ULL, 0x0000002404047220ULL, 0x080fe20000410000ULL,
0x0000002405057220ULL, 0x000fe20000410000ULL, 0x0000c5b27f007947ULL, 0x000fea000b800000ULL,
0x00001f542a247589ULL, 0x0008a400000e0000ULL, 0x8000002627270221ULL, 0x100fe20000010000ULL,
0x00000001ff9f7807ULL, 0x000fe20000000000ULL, 0x000000240a0a7220ULL, 0x084fe20000410000ULL,
0x000000240b0b7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x000000240f0f7220ULL, 0x080fe20000410000ULL,
0x0000002412127220ULL, 0x080fe20000410000ULL, 0x0000002700450308ULL, 0x000ea20000000800ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x0000002422227220ULL, 0x080fe20000410000ULL,
0x0000002423237220ULL, 0x080fe20000410000ULL, 0x0000002406067220ULL, 0x080fe20000410000ULL,
0x0000002407077220ULL, 0x000fe20000410000ULL, 0x000000ffff407224ULL, 0x000fe200078e0026ULL,
0x0000000045000220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000004100417221ULL, 0x002fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x0000000844007824ULL, 0x000fe200078e00ffULL,
0xfffffff038257812ULL, 0x000fc800078ec0ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000125257824ULL, 0x000fcc00078e0200ULL, 0x00f6ac0025257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x004fe20003800000ULL, 0x000004005f257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc40007804859ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff287819ULL, 0x008fe40000011637ULL, 0x00000045ff24723eULL, 0x000fe400000010ffULL,
0x0000001828007810ULL, 0x040fe40007ffe0ffULL, 0x0000001028267810ULL, 0x000fe40007ffe0ffULL,
0x00005410242a7816ULL, 0x010fe20000000024ULL, 0x0000c3027f007947ULL, 0x000fea000b800000ULL,
0x00001f282a6b7589ULL, 0x0002e400000e0000ULL, 0x0000c3427f007947ULL, 0x000fea000b800000ULL,
0x00001f542a6c7589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff287224ULL, 0x002fe200078e0026ULL, 0x0000ac3000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000c94000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff287224ULL, 0x002fe200078e0000ULL, 0x0000ac9000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000c8e000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006324783bULL, 0x000f280000004200ULL, 0x000000006130783bULL, 0x000ee80000004200ULL,
0x000000006428783bULL, 0x016e680000004200ULL, 0x00000000622c783bULL, 0x000ea20000004200ULL,
0x00000100248f7824ULL, 0x000fe200078e00ffULL, 0x0000002400b87306ULL, 0x000fe20000009400ULL,
0x00000018ffb97819ULL, 0x000fe20000011424ULL, 0x0000010026c37824ULL, 0x000fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe20000011425ULL, 0x0000010027bf7824ULL, 0x040fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fe2000001148fULL, 0x0000010032d87824ULL, 0x008fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x0000002400bb7306ULL, 0x000ee20000005400ULL,
0x00000018ff687819ULL, 0x000fe20000011432ULL, 0x0001000026b47824ULL, 0x000fe200078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x0001000027af7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe20000011426ULL, 0x000001002aa27824ULL, 0x042fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x0000002400717306ULL, 0x000322000000d400ULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x000100002a907824ULL, 0x000fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe20000011427ULL, 0x000001002b8f7824ULL, 0x040fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fe20000011428ULL, 0x000100002b957824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe20000011429ULL, 0x000000ba00bc7306ULL, 0x000fe20000209400ULL,
0x0001000024247824ULL, 0x002fe200078e00ffULL, 0x000000bbb800720bULL, 0x008fe20003f1d000ULL,
0x0000010033d97824ULL, 0x000fe200078e00ffULL, 0x00000018ffa27819ULL, 0x000fc400000114a2ULL,
0x00000018ffc07819ULL, 0x000fe20000011424ULL, 0x0000010025247824ULL, 0x000fe200078e00ffULL,
0x000000ba00bd7306ULL, 0x000e620000205400ULL, 0x00000018ff847819ULL, 0x000fe4000001142aULL,
0x000000c000b87245ULL, 0x000fe4000020d400ULL, 0x00000018ffcd7819ULL, 0x000fe20000011424ULL,
0x0000010028247824ULL, 0x000fe200078e00ffULL, 0x0000000171710812ULL, 0x010fe200078efcffULL,
0x000000b900c97306ULL, 0x000fe20000209400ULL, 0x000000cd00bb7245ULL, 0x000fc4000020d400ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000018ff807819ULL, 0x000fe4000001142bULL,
0x00000018ff867819ULL, 0x000fe20000011430ULL, 0x000000b900ca7306ULL, 0x0007220000205400ULL,
0x000000bdbc00720bULL, 0x002fe20003f5d000ULL, 0x0001000032bc7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x0000010031bd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd87819ULL, 0x000fc400000114d8ULL, 0x00000018ff907819ULL, 0x000fe20000011490ULL,
0x0000002500cb7306ULL, 0x000fe20000009400ULL, 0x000000b900b97245ULL, 0x008fe4000020d400ULL,
0x00000018ff957819ULL, 0x000fe40000011495ULL, 0x00000018ffd97819ULL, 0x000fe400000114d9ULL,
0x00000018ff507819ULL, 0x004fe2000001142dULL, 0x0000002500cc7306ULL, 0x000fe20000005400ULL,
0x000000cac900720bULL, 0x010fc40003fbd000ULL, 0x00000018ff737819ULL, 0x000fe40000011431ULL,
0x00000018ffbd7819ULL, 0x000fe400000114bdULL, 0x00000018ffbc7819ULL, 0x000fe200000114bcULL,
0x0000002500727306ULL, 0x0003e2000000d400ULL, 0x00000018ff5f7819ULL, 0x000fe40000011433ULL,
0x00000018ff537819ULL, 0x000fe4000001142cULL, 0x00000018ff4b7819ULL, 0x000fc4000001142eULL,
0x00000001b9b95812ULL, 0x000fe200078efcffULL, 0x000000cd00ce7306ULL, 0x000fe20000209400ULL,
0x0001000025257824ULL, 0x002fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fc8000001142fULL,
0x00000018ffd07819ULL, 0x000fe20000011425ULL, 0x0000010029257824ULL, 0x000fe200078e00ffULL,
0x000000cd00cf7306ULL, 0x000e680000205400ULL, 0x00000018ff257819ULL, 0x000fc80000011425ULL,
0x000000c000c77306ULL, 0x000ff00000209400ULL, 0x000000c000c87306ULL, 0x000ea20000205400ULL,
0x000000cfce00720bULL, 0x002fce0003f9d000ULL, 0x000000d000d17306ULL, 0x000fec0000209400ULL,
0x00000001bbbb4812ULL, 0x000fe400078efcffULL, 0x000000d000d27306ULL, 0x000e620000205400ULL,
0x000000c8c700720bULL, 0x004fce0003fdd000ULL, 0x000000aa00ad7306ULL, 0x000fec0000209400ULL,
0x00000001b8b86812ULL, 0x000fe400078efcffULL, 0x000000aa00ae7306ULL, 0x0004e20000205400ULL,
0x000000d2d100720bULL, 0x002fe40003f1d000ULL, 0x000000b8b9b8723eULL, 0x000fca00000010ffULL,
0x0000003200817306ULL, 0x000fe20000009400ULL, 0x000000aa00aa7245ULL, 0x004fce000020d400ULL,
0x0000003200747306ULL, 0x000fe20000005400ULL, 0x000000aead00720bULL, 0x008fe20003fbd000ULL,
0x000001002dae7824ULL, 0x000fcc00078e00ffULL, 0x0000003200467306ULL, 0x0003ec000000d400ULL,
0x00000001aaaa5812ULL, 0x000fe400078efcffULL, 0x000000c300d37306ULL, 0x000fe20000209400ULL,
0x000000ba00327245ULL, 0x002fc8000020d400ULL, 0x0000000132322812ULL, 0x000fe400078efcffULL,
0x000000cccb00720bULL, 0x000fe20003f5d000ULL, 0x000000c300d47306ULL, 0x000e620000205400ULL,
0x000000713232723eULL, 0x000fe400000010ffULL, 0x000000d800717245ULL, 0x000fca000020d400ULL,
0x0000002600ab7306ULL, 0x000fe80000009400ULL, 0x0000000172722812ULL, 0x000fc800078efcffULL,
0x0000002600ac7306ULL, 0x000ea20000005400ULL, 0x000000d4d300720bULL, 0x002fce0003f9d000ULL,
0x000000bf00d67306ULL, 0x000ff00000209400ULL, 0x000000bf00d77306ULL, 0x000e620000205400ULL,
0x000000acab00720bULL, 0x004fe40003fdd000ULL, 0x000000d000ab7245ULL, 0x000fc8000020d400ULL,
0x00000001abab0812ULL, 0x000fe200078efcffULL, 0x0000002700a97306ULL, 0x000fe60000009400ULL,
0x000000abaab9723eULL, 0x000fca00000010ffULL, 0x0000002700a87306ULL, 0x000ea20000005400ULL,
0x000000d7d600720bULL, 0x002fce0003f5d000ULL, 0x000000a300a67306ULL, 0x000ff00000209400ULL,
0x000000a300a77306ULL, 0x0002e20000205400ULL, 0x000000a8a900720bULL, 0x004fe40003f1d000ULL,
0x000000c300a97245ULL, 0x000fc8000020d400ULL, 0x00000001a9a94812ULL, 0x000fe200078efcffULL,
0x000000b400c67306ULL, 0x000fe20000209400ULL, 0x000000a300a37245ULL, 0x002fce000020d400ULL,
0x000000b400d57306ULL, 0x0002a20000205400ULL, 0x000000a7a600720bULL, 0x008fe40003fbd000ULL,
0x000000bf00a67245ULL, 0x000fc8000020d400ULL, 0x00000001a6a62812ULL, 0x000fe200078efcffULL,
0x000000af00c57306ULL, 0x000fe20000209400ULL, 0x000000b400b47245ULL, 0x002fca000020d400ULL,
0x00000001a3a35812ULL, 0x000fe400078efcffULL, 0x000000af00c47306ULL, 0x0002e20000205400ULL,
0x000000d5c600720bULL, 0x004fce0003f9d000ULL, 0x00000026006e7306ULL, 0x000ea2000000d400ULL,
0x000000af00af7245ULL, 0x002fca000020d400ULL, 0x00000001b4b44812ULL, 0x000fe400078efcffULL,
0x0000002700697306ULL, 0x000322000000d400ULL, 0x000000c4c500720bULL, 0x008fce0003f5d000ULL,
0x0000009c00a57306ULL, 0x000fe20000209400ULL, 0x000000016e6e6812ULL, 0x004fe200078efcffULL,
0x0001000029277824ULL, 0x002fc600078e00ffULL, 0x0000006ea96e723eULL, 0x000fe400000010ffULL,
0x00000001afaf2812ULL, 0x000fe200078efcffULL, 0x0000009c00a47306ULL, 0x0002a20000205400ULL,
0x0000000169690812ULL, 0x010fe400078efcffULL, 0x00000018ff277819ULL, 0x000fca0000011427ULL,
0x0000002400c27306ULL, 0x000fe20000209400ULL, 0x0000009c009c7245ULL, 0x002fce000020d400ULL,
0x0000002400c17306ULL, 0x000e620000205400ULL, 0x000000a4a500720bULL, 0x004fce0003fdd000ULL,
0x00000028009d7306ULL, 0x000fec0000009400ULL, 0x000000019c9c6812ULL, 0x000fe400078efcffULL,
0x00000028009e7306ULL, 0x000ea20000005400ULL, 0x000000c1c200720bULL, 0x002fe40003f1d000ULL,
0x000000af9caf723eULL, 0x000fca00000010ffULL, 0x0000002800647306ULL, 0x0002f0000000d400ULL,
0x00000029009b7306ULL, 0x000fe20000009400ULL, 0x0001000028287824ULL, 0x002fe200078e00ffULL,
0x0000009e9d00720bULL, 0x004fe20003f9d000ULL, 0x000100002c9d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000029009a7306ULL, 0x000e620000005400ULL,
0x00000018ff9d7819ULL, 0x000fcc000001149dULL, 0x0000000164644812ULL, 0x008fe200078efcffULL,
0x0000002800b17306ULL, 0x000ff00000209400ULL, 0x0000002800b27306ULL, 0x000ea20000205400ULL,
0x0000009a9b00720bULL, 0x002fc40003f5d000ULL, 0x00000024009b7245ULL, 0x000fc8000020d400ULL,
0x000000019b9b0812ULL, 0x000fe200078efcffULL, 0x0000009100997306ULL, 0x000fe60000209400ULL,
0x000000649b64723eULL, 0x000fca00000010ffULL, 0x0000009100987306ULL, 0x0002e20000205400ULL,
0x000000b2b100720bULL, 0x004fe20003fdd000ULL, 0x000001002eb17824ULL, 0x000fca00078e00ffULL,
0x00000018ffb17819ULL, 0x000fe200000114b1ULL, 0x0000002a00967306ULL, 0x000fe20000009400ULL,
0x0000009100917245ULL, 0x002fce000020d400ULL, 0x0000002a00977306ULL, 0x000e620000005400ULL,
0x000000989900720bULL, 0x008fe40003f1d000ULL, 0x0000002500987245ULL, 0x000fca000020d400ULL,
0x0000002900637306ULL, 0x000eac000000d400ULL, 0x0000000191910812ULL, 0x000fe400078efcffULL,
0x0000002a00607306ULL, 0x000722000000d400ULL, 0x000000979600720bULL, 0x002fe20003f9d000ULL,
0x000001002c977824ULL, 0x000fe200078e00ffULL, 0x0000002800967245ULL, 0x000fc8000020d400ULL,
0x0000000196966812ULL, 0x000fe200078efcffULL, 0x0000008b008e7306ULL, 0x000fe20000209400ULL,
0x000099109f2a7816ULL, 0x008fe400000000ffULL, 0x0000000163632812ULL, 0x004fe400078efcffULL,
0x000000ff2a00720cULL, 0x000fe20003f65270ULL, 0x00000100302a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe20000011497ULL, 0x0000008b008d7306ULL, 0x000e620000205400ULL,
0x0000000160604812ULL, 0x010fce00078efcffULL, 0x000000a200297306ULL, 0x000ff00000209400ULL,
0x000000a200267306ULL, 0x000ea20000205400ULL, 0x0000008d8e00720bULL, 0x002fe40003fdd000ULL,
0x00000027008d7245ULL, 0x000fc4000020d400ULL, 0x0000008b008e7245ULL, 0x000fc6000020d400ULL,
0x0000002b00937306ULL, 0x000fec0000009400ULL, 0x000000018e8e6812ULL, 0x000fe400078efcffULL,
0x0000002b00927306ULL, 0x000e620000005400ULL, 0x000000262900720bULL, 0x004fce0003f1d000ULL,
0x0000002b00597306ULL, 0x0004f0000000d400ULL, 0x0000003000777306ULL, 0x000fe20000009400ULL,
0x00010000302b7824ULL, 0x004fe200078e00ffULL, 0x000000929300720bULL, 0x002fc80003f5d000ULL,
0x00000018ffac7819ULL, 0x000fe4000001142bULL, 0x0000003000827306ULL, 0x000e6e0000005400ULL,
0x0000000159592812ULL, 0x008fe200078efcffULL, 0x0000003000587306ULL, 0x0004f0000000d400ULL,
0x0000002500b77306ULL, 0x000fe20000209400ULL, 0x00000018ff307819ULL, 0x004fe2000001142aULL,
0x00010000312a7824ULL, 0x000fe200078e00ffULL, 0x000000827700720bULL, 0x002fc40003f5d000ULL,
0x0000008400777245ULL, 0x000fe4000020d400ULL, 0x00000018ffa47819ULL, 0x000fe2000001142aULL,
0x0000002500be7306ULL, 0x000e620000205400ULL, 0x00a800006628783bULL, 0x00052e0000000200ULL,
0x0000002700b57306ULL, 0x000fe20000209400ULL, 0x0000008f00667245ULL, 0x004fc4000020d400ULL,
0x0000000158582812ULL, 0x008fca00078efcffULL, 0x0000002700b67306ULL, 0x0004e20000205400ULL,
0x000000beb700720bULL, 0x002fce0003fbd000ULL, 0x000000ac00a87306ULL, 0x000fe20000209400ULL,
0x00a800006524783bULL, 0x004e6a0000000200ULL, 0x0000000198985812ULL, 0x000fe400078efcffULL,
0x000000ac00a57306ULL, 0x0005e20000205400ULL, 0x000000b6b500720bULL, 0x008fce0003fbd000ULL,
0x0000008f00b07306ULL, 0x000fe20000209400ULL, 0x0000006b2828b231ULL, 0x090fe200003400ffULL,
0x000000ac00ac7245ULL, 0x004fe2000020d400ULL, 0x0000006b2a2ab231ULL, 0x000fe400003400ffULL,
0x0000006c2929b231ULL, 0x080fe200003400ffULL, 0x000000018d8d5812ULL, 0x000fe200078efcffULL,
0x0000006c2b2bb231ULL, 0x000fe200003400ffULL, 0x0000008f00b37306ULL, 0x000ea40000205400ULL,
0x0000008d8e8d723eULL, 0x000fcc00000010ffULL, 0x0000008400897306ULL, 0x000ff00000209400ULL,
0x00000084008c7306ULL, 0x000ee20000205400ULL, 0x0000006b2424b231ULL, 0x082fe200003400ffULL,
0x000000b3b000720bULL, 0x004fe20003fbd000ULL, 0x0000006b2626b231ULL, 0x000fe200003400ffULL,
0x000100002db07824ULL, 0x000fe200078e00ffULL, 0x0000006c2525b231ULL, 0x080fe200003400ffULL,
0x00000086006b7245ULL, 0x000fe2000020d400ULL, 0x0000006c2727b231ULL, 0x000fe200003400ffULL,
0x000000d800997306ULL, 0x000fe20000209400ULL, 0x000000a5a800720bULL, 0x000fc40003f7d000ULL,
0x00000018ffb07819ULL, 0x000fc600000114b0ULL, 0x000000b8240c723cULL, 0x000fe2000004180cULL,
0x0000000166665812ULL, 0x000fe200078efcffULL, 0x000000d800927306ULL, 0x000e620000205400ULL,
0x0000008c8900720bULL, 0x008fca0003fdd000ULL, 0x00000001acac3812ULL, 0x000fe400078efcffULL,
0x0000009000947306ULL, 0x000fec0000209400ULL, 0x0000000177776812ULL, 0x000fe400078efcffULL,
0x0000009000a17306ULL, 0x0005e20000205400ULL, 0x000000929900720bULL, 0x002fc40003f7d000ULL,
0x000000748100720bULL, 0x000fca0003fdd000ULL, 0x00000095009f7306ULL, 0x000fe20000209400ULL,
0x0000009000907245ULL, 0x004fca000020d400ULL, 0x0000000171713812ULL, 0x000fe400078efcffULL,
0x0000009500a07306ULL, 0x0002a20000205400ULL, 0x0000000146466812ULL, 0x000fce00078efcffULL,
0x0000002d00857306ULL, 0x000fe20000009400ULL, 0x0000009500957245ULL, 0x002fce000020d400ULL,
0x0000002d007e7306ULL, 0x000fe20000005400ULL, 0x000000a09f00720bULL, 0x004fce0003fbd000ULL,
0x0000002d004e7306ULL, 0x0003ec000000d400ULL, 0x0000000195955812ULL, 0x000fe400078efcffULL,
0x00000080007c7306ULL, 0x000fe20000209400ULL, 0x000000a2002d7245ULL, 0x002fc8000020d400ULL,
0x000000012d2d0812ULL, 0x000fe400078efcffULL, 0x000000a19400720bULL, 0x000fe20003f1d000ULL,
0x0000008000837306ULL, 0x0002a20000205400ULL, 0x000000602d60723eULL, 0x000fce00000010ffULL,
0x000000d900937306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fc6000020d400ULL,
0x0000000190900812ULL, 0x000fc800078efcffULL, 0x000000d9009e7306ULL, 0x0002e20000205400ULL,
0x000000837c00720bULL, 0x004fe40003f9d000ULL, 0x000000907790723eULL, 0x000fca00000010ffULL,
0x0000003100787306ULL, 0x000fe20000009400ULL, 0x000000d900d97245ULL, 0x002fca000020d400ULL,
0x0000000180804812ULL, 0x000fe400078efcffULL, 0x0000003100757306ULL, 0x000e620000005400ULL,
0x0000009e9300720bULL, 0x008fce0003f7d000ULL, 0x0000003100487306ULL, 0x000eac000000d400ULL,
0x00000001d9d93812ULL, 0x000fe400078efcffULL, 0x0000003000317306ULL, 0x000fe20000209400ULL,
0x000000757800720bULL, 0x002fe40003f1d000ULL, 0x00000018ff787819ULL, 0x000fc400000114aeULL,
0x000000b4a3ae723eULL, 0x000fe400000010ffULL, 0x00000078002d7245ULL, 0x000fe2000020d400ULL,
0x0000003000ba7306ULL, 0x000e680000205400ULL, 0x000000ae2414723cULL, 0x000fe40000041814ULL,
0x0000000148480812ULL, 0x004fe400078efcffULL, 0x00000068006d7306ULL, 0x000ff00000209400ULL,
0x00000068006a7306ULL, 0x000ea20000205400ULL, 0x000000ba3100720bULL, 0x002fc40003fbd000ULL,
0x0000003000317245ULL, 0x000fe4000020d400ULL, 0x0000007300307245ULL, 0x000fc6000020d400ULL,
0x000000bd00c07306ULL, 0x000fec0000209400ULL, 0x0000000131315812ULL, 0x000fe400078efcffULL,
0x000000bd00ad7306ULL, 0x0002e20000205400ULL, 0x0000006a6d00720bULL, 0x004fe40003fdd000ULL,
0x000000583158723eULL, 0x000fca00000010ffULL, 0x000000bc00657306ULL, 0x000fe20000209400ULL,
0x000000bd00bd7245ULL, 0x002fce000020d400ULL, 0x000000bc008c7306ULL, 0x0002a20000205400ULL,
0x000000adc000720bULL, 0x008fe40003f9d000ULL, 0x000000a400ad7245ULL, 0x000fca000020d400ULL,
0x0000007300887306ULL, 0x000fe20000209400ULL, 0x000000bc00bc7245ULL, 0x002fca000020d400ULL,
0x00000001bdbd4812ULL, 0x000fe400078efcffULL, 0x00000073007f7306ULL, 0x000e620000205400ULL,
0x0000008c6500720bULL, 0x004fe40003f7d000ULL, 0x000000639865723eULL, 0x000fe400000010ffULL,
0x00000096918c723eULL, 0x000fe400000010ffULL, 0x000000958091723eULL, 0x000fe200000010ffULL,
0x0000003300877306ULL, 0x000fe40000009400ULL, 0x000000642418723cULL, 0x000fe80000041818ULL,
0x00000001bcbc3812ULL, 0x000fc400078efcffULL, 0x00000033007a7306ULL, 0x000ea20000005400ULL,
0x0000007f8800720bULL, 0x002fe20003f1d000ULL, 0x0000008c241c723cULL, 0x040fec000004181cULL,
0x0000003300007306ULL, 0x0002e4000000d400ULL, 0x000000902404723cULL, 0x000fe80000041804ULL,
0x0000000130300812ULL, 0x000fc400078efcffULL, 0x00000086008a7306ULL, 0x000fe20000209400ULL,
0x0001000033337824ULL, 0x002fe200078e00ffULL, 0x0000007a8700720bULL, 0x004fc80003f5d000ULL,
0x00000018ff7c7819ULL, 0x000fe40000011433ULL, 0x00000086007d7306ULL, 0x000e620000205400ULL,
0x00000072bb33723eULL, 0x000fcc00000010ffULL, 0x0000000100002812ULL, 0x008fe200078efcffULL,
0x0000005f00627306ULL, 0x000fe20000209400ULL, 0x000000322408723cULL, 0x000fee0000041808ULL,
0x0000005f00617306ULL, 0x0004e20000205400ULL, 0x0000006800337245ULL, 0x000fc4000020d400ULL,
0x0000007d8a00720bULL, 0x002fe40003fbd000ULL, 0x0000000133336812ULL, 0x000fc600078efcffULL,
0x000000a400a77306ULL, 0x000fe20000209400ULL, 0x0000005f005f7245ULL, 0x004fe4000020d400ULL,
0x000000bc33bc723eULL, 0x000fca00000010ffULL, 0x000000a4009a7306ULL, 0x000e620000205400ULL,
0x000000616200720bULL, 0x008fe40003f7d000ULL, 0x000000016b6b5812ULL, 0x000fe400078efcffULL,
0x000000596661723eULL, 0x000fe400000010ffULL, 0x00000048bd59723eULL, 0x000fe200000010ffULL,
0x0000009700747306ULL, 0x000fe20000209400ULL, 0x000000ac6bac723eULL, 0x000fc600000010ffULL,
0x000000602420723cULL, 0x000fe40000041820ULL, 0x000000015f5f3812ULL, 0x000fe400078efcffULL,
0x0000009700817306ULL, 0x000ea20000205400ULL, 0x0000009aa700720bULL, 0x002fc60003f9d000ULL,
0x000000582808723cULL, 0x000fe80000041808ULL, 0x0000002e006f7306ULL, 0x000fec0000009400ULL,
0x00000001adad4812ULL, 0x000fc400078efcffULL, 0x0000002e00707306ULL, 0x000e620000005400ULL,
0x000000817400720bULL, 0x004fe40003fdd000ULL, 0x0000007e8500720bULL, 0x000fe40003f9d000ULL,
0x000000ad30ad723eULL, 0x000fc600000010ffULL, 0x0000002c00767306ULL, 0x000fe80000009400ULL,
0x000000ac280c723cULL, 0x000fe8000004180cULL, 0x0000002c007b7306ULL, 0x000ea20000005400ULL,
0x000000706f00720bULL, 0x002fe40003f1d000ULL, 0x00000069a66f723eULL, 0x000fc400000010ffULL,
0x000000014e4e4812ULL, 0x000fc600078efcffULL, 0x0000007c00827306ULL, 0x000fe40000209400ULL,
0x0000006e2410723cULL, 0x000fec0000041810ULL, 0x0000007c00757306ULL, 0x0002e20000205400ULL,
0x0000007b7600720bULL, 0x004fe40003fbd000ULL, 0x00000000d925723eULL, 0x000fc400000010ffULL,
0x0000005300007245ULL, 0x000fe4000020d400ULL, 0x000000467124723eULL, 0x000fe200000010ffULL,
0x00000053005a7306ULL, 0x000fe20000209400ULL, 0x0000007c007c7245ULL, 0x002fe4000020d400ULL,
0x000000b100267245ULL, 0x000fca000020d400ULL, 0x00000053005b7306ULL, 0x000e620000205400ULL,
0x000000758200720bULL, 0x008fe20003f5d000ULL, 0x000000242810723cULL, 0x000fec0000041810ULL,
0x00000078007a7306ULL, 0x000fe20000209400ULL, 0x0000005000257245ULL, 0x000fca000020d400ULL,
0x000000017c7c2812ULL, 0x000fe400078efcffULL, 0x00000078007d7306ULL, 0x000fe20000205400ULL,
0x0000005b5a00720bULL, 0x002fe40003f7d000ULL, 0x0000007c5fbd723eULL, 0x000fca00000010ffULL,
0x0000002c00557306ULL, 0x0002a4000000d400ULL, 0x000000bc2814723cULL, 0x000fe80000041814ULL,
0x0000000100003812ULL, 0x000fe400078efcffULL, 0x0000002f005d7306ULL, 0x000fe20000009400ULL,
0x000001002f2c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff647819ULL, 0x000fe4000001142cULL,
0x0000002f005c7306ULL, 0x000e620000005400ULL, 0x00000097002c7245ULL, 0x000fe4000020d400ULL,
0x0000000155555812ULL, 0x004fe400078efcffULL, 0x000000012c2c6812ULL, 0x000fe400078efcffULL,
0x0000007d7a00720bULL, 0x000fe20003fdd000ULL, 0x0000005000577306ULL, 0x000fe20000209400ULL,
0x000000552c2c723eULL, 0x000fce00000010ffULL, 0x0000005000567306ULL, 0x000ea20000205400ULL,
0x0000005c5d00720bULL, 0x002fc60003f5d000ULL, 0x000000012d2d6812ULL, 0x000fc800078efcffULL,
0x0000009d006c7306ULL, 0x000fe20000209400ULL, 0x0000004e2d2d723eULL, 0x000fce00000010ffULL,
0x0000009d00737306ULL, 0x0002e20000205400ULL, 0x000000565700720bULL, 0x004fe20003fbd000ULL,
0x0000002c2818723cULL, 0x000fec0000041818ULL, 0x000000b000327306ULL, 0x000fe20000209400ULL,
0x0000009d009d7245ULL, 0x002fca000020d400ULL, 0x0000000125255812ULL, 0x000fe400078efcffULL,
0x000000b000697306ULL, 0x0002a20000205400ULL, 0x000000736c00720bULL, 0x008fce0003fdd000ULL,
0x000000b100637306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x002fca000020d400ULL,
0x000000019d9d6812ULL, 0x000fe400078efcffULL, 0x000000b100627306ULL, 0x000e620000205400ULL,
0x000000693200720bULL, 0x004fe40003f9d000ULL, 0x0000009d0024723eULL, 0x000fca00000010ffULL,
0x0000002e004d7306ULL, 0x0004ec000000d400ULL, 0x00000001b0b04812ULL, 0x000fe400078efcffULL,
0x0000002f004c7306ULL, 0x0008e2000000d400ULL, 0x000100002e2e7824ULL, 0x004fe200078e00ffULL,
0x000000626300720bULL, 0x002fc40003f7d000ULL, 0x000000b02525723eULL, 0x000fe400000010ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000004b00517306ULL, 0x000fe20000209400ULL,
0x000100002f2f7824ULL, 0x010fe200078e00ffULL, 0x000000014d4d0812ULL, 0x008fe200078efcffULL,
0x00000024281c723cULL, 0x000fe6000004181cULL, 0x00000018ff2f7819ULL, 0x000fc4000001142fULL,
0x0000004b00527306ULL, 0x0002a20000205400ULL, 0x0000000126263812ULL, 0x000fe400078efcffULL,
0x000000014c4c2812ULL, 0x000fe400078efcffULL, 0x0000004d2626723eULL, 0x000fc600000010ffULL,
0x0000004a004f7306ULL, 0x000fe20000209400ULL, 0x0000004b004b7245ULL, 0x002fce000020d400ULL,
0x0000004a00547306ULL, 0x0002e20000205400ULL, 0x000000525100720bULL, 0x004fce0003fdd000ULL,
0x00000064005c7306ULL, 0x000fe20000209400ULL, 0x0000004a004a7245ULL, 0x002fca000020d400ULL,
0x000000014b4b6812ULL, 0x000fe400078efcffULL, 0x00000064005b7306ULL, 0x000e620000205400ULL,
0x000000544f00720bULL, 0x008fce0003f9d000ULL, 0x0000002e00567306ULL, 0x000fec0000209400ULL,
0x000000014a4a4812ULL, 0x000fe400078efcffULL, 0x0000002e00277306ULL, 0x0004e20000205400ULL,
0x0000005b5c00720bULL, 0x002fce0003fbd000ULL, 0x0000002f00307306ULL, 0x000fe20000209400ULL,
0x0000002e002e7245ULL, 0x004fce000020d400ULL, 0x0000002f00317306ULL, 0x0002a20000205400ULL,
0x000000275600720bULL, 0x008fe40003f7d000ULL, 0x0000006400277245ULL, 0x000fc8000020d400ULL,
0x0000000127275812ULL, 0x000fe400078efcffULL, 0x0000002f002f7245ULL, 0x002fe4000020d400ULL,
0x0000004c2727723eULL, 0x000fc600000010ffULL, 0x000000012e2e3812ULL, 0x000fe400078efcffULL,
0x000000313000720bULL, 0x004fe40003f1d000ULL, 0x0000002e4b2e723eULL, 0x000fe200000010ffULL,
0x000000262820723cULL, 0x000ff40000041820ULL, 0x000000012f2f0812ULL, 0x000fc800078efcffULL,
0x0000002f4a2f723eULL, 0x000fce00000010ffULL, 0x0000002e2804723cULL, 0x000fe20000041804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200042247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a0005eff7f8cULL, 0x0007e2000c80043fULL, 0x00000001446c7812ULL, 0x000fc600078ec0ffULL,
0x0000030035357a10ULL, 0x008fc80007ffe0ffULL, 0x000000363500720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff44e000007947ULL, 0x000fea000383ffffULL,
0x00000000000479c3ULL, 0x004ea20000002500ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0022ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0023ULL, 0x000000ffff297224ULL, 0x000fe400078e001fULL,
0x000000ffff287224ULL, 0x000fe400078e001dULL, 0x000000ffff277224ULL, 0x008fe400078e001cULL,
0x000000ffff227224ULL, 0x000fc400078e0016ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0021ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0020ULL, 0x000000ffff2a7224ULL, 0x000fe400078e001eULL,
0x000000ffff257224ULL, 0x000fe400078e001bULL, 0x000000ffff267224ULL, 0x000fe400078e001aULL,
0x000000ffff247224ULL, 0x000fe200078e0019ULL, 0x0000000436007c0cULL, 0x004fe2000bf03070ULL,
0x000000ffff237224ULL, 0x000fc400078e0018ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0014ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0010ULL,
0x000000ffff167224ULL, 0x000fe400078e000eULL, 0x000000ffff317224ULL, 0x000fe400078e0007ULL,
0x000000ffff327224ULL, 0x000fc400078e0006ULL, 0x000000ffff307224ULL, 0x000fe400078e0005ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0004ULL, 0x000000ffff217224ULL, 0x000fe400078e0017ULL,
0x000000ffff207224ULL, 0x000fe400078e0015ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0013ULL,
0x000000ffff187224ULL, 0x000fc400078e0011ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000fULL,
0x000000ffff147224ULL, 0x000fe400078e000dULL, 0x000000ffff1b7224ULL, 0x000fe400078e000cULL,
0x000000ffff127224ULL, 0x000fe400078e000bULL, 0x000000ffff107224ULL, 0x000fe400078e000aULL,
0x000000ffff0e7224ULL, 0x000fc400078e0009ULL, 0x000000ffff197224ULL, 0x000fe200078e0008ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x0180000041007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000cd6000067802ULL, 0x000fe40000000f00ULL, 0x0000a66000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000004100007308ULL, 0x000ea40000001000ULL, 0xbf80000000037423ULL, 0x004fc80000000041ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff057624ULL, 0x000fe400078e00ffULL,
0x00006800ff047624ULL, 0x000fca00078e00ffULL, 0x0000000604057981ULL, 0x000ea8000c1e9900ULL,
0x0000000000037919ULL, 0x000ee80000000000ULL, 0x0000000000087919ULL, 0x000f220000000000ULL,
0x00000002ff077819ULL, 0x008fe40000011603ULL, 0x0000000808037811ULL, 0x010fe200078ff0ffULL,
0x0000000005067220ULL, 0x004fca0000410000ULL, 0x00001f0706007589ULL, 0x000ea800000e0000ULL,
0x00001f0306037589ULL, 0x000ee200000e0000ULL, 0x0000001900197220ULL, 0x044fe20000410000ULL,
0x0000000e000e7220ULL, 0x040fe20000410000ULL, 0x0000001b001b7220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001f001f7220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002300237220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002700277220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002b002b7220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002f002f7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x000fe20000410000ULL, 0x0000001003107220ULL, 0x048fe20000410000ULL,
0x0000001203127220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000001c031c7220ULL, 0x040fe20000410000ULL,
0x0000001e031e7220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002103217220ULL, 0x040fe20000410000ULL, 0x0000002603267220ULL, 0x040fe20000410000ULL,
0x0000002503257220ULL, 0x040fe20000410000ULL, 0x0000002a032a7220ULL, 0x040fe20000410000ULL,
0x0000002903297220ULL, 0x040fe20000410000ULL, 0x0000002e032e7220ULL, 0x040fe20000410000ULL,
0x0000002d032d7220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000003103317220ULL, 0x000fc40000410000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000203007812ULL, 0x004fc400078ec0ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011603ULL, 0x00000001ff047819ULL, 0x000fe40000011600ULL,
0x0000000400087811ULL, 0x040fe400078ff8ffULL, 0x0000000803177811ULL, 0x000fe400078ff0ffULL,
0x0000000200057811ULL, 0x040fe400078ff8ffULL, 0x00000006000b7811ULL, 0x000fc400078ff8ffULL,
0x0000000704007812ULL, 0x100fe400078e780fULL, 0x00000007080a7812ULL, 0x040fe400078e780fULL,
0x0000000708087812ULL, 0x100fe200078e7817ULL, 0x000000080f077824ULL, 0x000fe200078e0200ULL,
0x0000000704047812ULL, 0x000fe200078e7817ULL, 0x000010003c007824ULL, 0x000fe200078e00ffULL,
0x0000000705067812ULL, 0x100fe200078e780fULL, 0x0000000817157824ULL, 0x000fe200078e0208ULL,
0x000000070b0c7812ULL, 0x000fe200078e780fULL, 0x0000000803087824ULL, 0x000fe200078e00ffULL,
0x0000000705057812ULL, 0x100fe200078e7817ULL, 0x0000000817117824ULL, 0x000fe200078e0204ULL,
0x000000070b0b7812ULL, 0x000fe200078e7817ULL, 0x0000080049047824ULL, 0x000fe200078e0200ULL,
0x0000000808087812ULL, 0x000fe200078ec0ffULL, 0x000000080f097824ULL, 0x040fe200078e0206ULL,
0x0000001b1406723eULL, 0x000fe200000010ffULL, 0x000000080f0d7824ULL, 0x000fc400078e020aULL,
0x0000000817137824ULL, 0x000fe200078e0205ULL, 0x000000190e05723eULL, 0x000fe200000010ffULL,
0x000000080f0f7824ULL, 0x000fe400078e020cULL, 0x0000000817177824ULL, 0x000fe200078e020bULL,
0x0000763205197816ULL, 0x000fe20000000006ULL, 0x0000001007077824ULL, 0x100fe400078e0204ULL,
0x00000010090b7824ULL, 0x100fe400078e0204ULL, 0x000000100d0d7824ULL, 0x000fc400078e0204ULL,
0x0000001011117824ULL, 0x100fe400078e0204ULL, 0x0000001013137824ULL, 0x100fe400078e0204ULL,
0x000000100f0f7824ULL, 0x100fe400078e0204ULL, 0x0000001015157824ULL, 0x100fe400078e0204ULL,
0x0000001017177824ULL, 0x000fe400078e0204ULL, 0x0000000107097824ULL, 0x000fe200078e0208ULL,
0x0000001d1807723eULL, 0x000fe200000010ffULL, 0x00000001080b7824ULL, 0x040fe200078e020bULL,
0x0000541005187816ULL, 0x000fe20000000006ULL, 0x00000001080d7824ULL, 0x000fe200078e020dULL,
0x000000232405723eULL, 0x000fe200000010ffULL, 0x0000000108117824ULL, 0x000fe200078e0211ULL,
0x000000272806723eULL, 0x000fe200000010ffULL, 0x0000000108137824ULL, 0x040fe200078e0213ULL,
0x0000001809007388ULL, 0x0005e20000000a00ULL, 0x00000001080f7824ULL, 0x040fe200078e020fULL,
0x00005410050a7816ULL, 0x000fe20000000006ULL, 0x0000000108157824ULL, 0x000fc400078e0215ULL,
0x0000000108177824ULL, 0x000fe200078e0217ULL, 0x0000001f2008723eULL, 0x000fc800000010ffULL,
0x0000541007187816ULL, 0x144fe20000000008ULL, 0x000000013e097824ULL, 0x000fe200078e0203ULL,
0x0000763207197816ULL, 0x000fe40000000008ULL, 0x0000002b2c07723eULL, 0x000fe200000010ffULL,
0x00000010090c7824ULL, 0x000fe200078e0200ULL, 0x0000002f3008723eULL, 0x000fe200000010ffULL,
0x000000180b007388ULL, 0x0005e40000000a00ULL, 0x00007632050b7816ULL, 0x004fe40000000006ULL,
0x000000101205723eULL, 0x000fc400000010ffULL, 0x000000161a06723eULL, 0x000fe200000010ffULL,
0x0000000a0d007388ULL, 0x0005e40000000a00ULL, 0x00005410070a7816ULL, 0x144fe40000000008ULL,
0x00007632070b7816ULL, 0x000fe40000000008ULL, 0x0000001c1e07723eULL, 0x000fe400000010ffULL,
0x000000222108723eULL, 0x000fe200000010ffULL, 0x0000000a0f007388ULL, 0x0005e40000000a00ULL,
0x00005410050a7816ULL, 0x004fc40000000006ULL, 0x00007632050b7816ULL, 0x000fe40000000006ULL,
0x000000262505723eULL, 0x000fe400000010ffULL, 0x0000002a2906723eULL, 0x000fe200000010ffULL,
0x0000000a11007388ULL, 0x0005e40000000a00ULL, 0x00005410070a7816ULL, 0x144fe40000000008ULL,
0x00007632070b7816ULL, 0x000fe40000000008ULL, 0x0000002e2d07723eULL, 0x000fc400000010ffULL,
0x000000323108723eULL, 0x000fe200000010ffULL, 0x0000000a13007388ULL, 0x0005e40000000a00ULL,
0x00005410050a7816ULL, 0x144fe40000000006ULL, 0x00007632050b7816ULL, 0x000fe40000000006ULL,
0x000000ff00057306ULL, 0x000fe60000205400ULL, 0x0000000a15007388ULL, 0x0005ea0000000a00ULL,
0x000000ff00067306ULL, 0x000ee20000209400ULL, 0x00005410070a7816ULL, 0x004fc40000000008ULL,
0x00007632070b7816ULL, 0x000fca0000000008ULL, 0x0000000a17007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000050600720bULL, 0x008fe40003f1d000ULL,
0x000000ff00057245ULL, 0x000fd6000020d400ULL, 0x0000000105050812ULL, 0x000fc800078efcffULL,
0x000000050508723eULL, 0x000fe200000010ffULL, 0x000000000c107984ULL, 0x000ea80000000c00ULL,
0x000800000c187984ULL, 0x000ee80000000c00ULL, 0x000400000c1c7984ULL, 0x000f280000000c00ULL,
0x000c00000c207984ULL, 0x000e620000000c00ULL, 0x3f803f8008107831ULL, 0x004fc40000200010ULL,
0x3f803f8008137831ULL, 0x000fe40000200013ULL, 0x3f803f8010107831ULL, 0x008fe20000200018ULL,
0x00000300ff187624ULL, 0x000fe200078e00ffULL, 0x3f803f8008127831ULL, 0x040fe40000200012ULL,
0x3f803f8008117831ULL, 0x040fe40000200011ULL, 0x000000011800780cULL, 0x000fe20003f05270ULL,
0x3f803f80081f7831ULL, 0x050fe4000020001fULL, 0x3f803f80081e7831ULL, 0x000fc4000020001eULL,
0x3f803f80081d7831ULL, 0x040fe4000020001dULL, 0x3f803f80081c7831ULL, 0x000fe4000020001cULL,
0x3f803f8013137831ULL, 0x000fe4000020001bULL, 0x3f803f8012127831ULL, 0x000fe4000020001aULL,
0x3f803f8011117831ULL, 0x000fe40000200019ULL, 0x3f803f801f1f7831ULL, 0x002fc40000200023ULL,
0x3f803f801e1e7831ULL, 0x000fe20000200022ULL, 0x000000100c007388ULL, 0x0003e20000000c00ULL,
0x3f803f801d1d7831ULL, 0x000fe40000200021ULL, 0x3f803f801c1c7831ULL, 0x000fca0000200020ULL,
0x0004001c0c007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f3000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x002e620000002700ULL,
0x0000580018067a24ULL, 0x000fe200078e02ffULL, 0x0000000149ff7812ULL, 0x000fe2000780f802ULL,
0x00000800ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000000077919ULL, 0x000e620000002600ULL,
0x00006600060d7a24ULL, 0x000fe200078e02ffULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000004003c087824ULL, 0x000fe200078e00ffULL, 0x000000000c147984ULL, 0x0004e20000000c00ULL,
0x000000ff0300720cULL, 0x000fe20000725670ULL, 0x0000580010107a24ULL, 0x002fe200078e0207ULL,
0x000007ff0d077811ULL, 0x000fc600078e40ffULL, 0x0000030010067a24ULL, 0x000fca00078e02ffULL,
0x0000000406127c10ULL, 0x000fc8000fffe0ffULL, 0x00000012070a7211ULL, 0x000fca00078fa8ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000bULL, 0x000000080a0e7210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fc800010e060bULL, 0x00000010090e7825ULL, 0x000fe200078e000eULL,
0x01ffffff0d097812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010030a7824ULL, 0x00cfe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x00000001120c7824ULL, 0x000fe200078e0209ULL,
0x000000700a117812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b137812ULL, 0x000fe200078ec0ffULL,
0x00006c00120a7625ULL, 0x000fc800078e000dULL, 0x00006c000c0c7625ULL, 0x000fe200078e000dULL,
0x0000000a130a7210ULL, 0x000fc80007a1e011ULL, 0x0000000c130c7210ULL, 0x000fe40007c7e011ULL,
0x0000000bff0b7210ULL, 0x000fe400007e44ffULL, 0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL,
0x000000400a007986ULL, 0x0003e8000c101906ULL, 0x000000410c007986ULL, 0x0003e4000c101906ULL,
0x0000000000007941ULL, 0x00cfea0003800000ULL, 0x000000140e007986ULL, 0x0005e2000c101d06ULL,
0x0000011000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0b7424ULL, 0x002fe200078e00ffULL,
0xffffffff180d7810ULL, 0x000fc60007ffe0ffULL, 0x00006a00100a7625ULL, 0x000fe200078e000bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000d0a0a79a8ULL, 0x000ee400099ee1c6ULL, 0x0000000d0a00720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0c7807ULL, 0x000fca0000000000ULL,
0x0000000cff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff0a7984ULL, 0x002e640000000000ULL,
0x000000ff0a00720cULL, 0x002fda0003f05270ULL, 0x00002b8000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff0a7819ULL, 0x000fe20000011603ULL, 0x0000001003027824ULL, 0x000fe200078e00ffULL,
0x00000001060c7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff197424ULL, 0x000fe200078e00ffULL,
0x0000000c0a0e7812ULL, 0x004fe400078ec0ffULL, 0x00000070021b7812ULL, 0x000fe200078ec0ffULL,
0x00006c00060a7625ULL, 0x000fc800078e0019ULL, 0x00006c000c0c7625ULL, 0x000fe200078e0019ULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL, 0x0000000c0e0c7210ULL, 0x000fe40007b5e01bULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x000000060a027981ULL, 0x000368000c1e1900ULL, 0x000000060c0f7981ULL, 0x000362000c1e1900ULL,
0x000000021800780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002060a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a117981ULL, 0x000362000c1e1900ULL, 0x000000041800780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003060a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a137981ULL, 0x000362000c1e1900ULL,
0x000000041800780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004060a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a157981ULL, 0x000362000c1e1900ULL, 0x000000061800780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005060a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a177981ULL, 0x000362000c1e1900ULL,
0x000000061800780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081800780cULL, 0x002fe40003f06070ULL, 0x00000006060a7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a0e0a7210ULL, 0x000fe40007a3e01bULL,
0x00000007060c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006c000c0c0625ULL, 0x000fe400078e0019ULL, 0x000000060a197981ULL, 0x000366000c1e1900ULL,
0x0000000c0e0c0210ULL, 0x000fc80007c7e01bULL, 0x0000000dff0d0210ULL, 0x000fcc0001fe84ffULL,
0x000000060c0d0981ULL, 0x000366000c1e1900ULL, 0x00000007180a7810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0c7819ULL, 0x000fc8000001160aULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x020fe400078e0002ULL, 0x000000081b0e7824ULL, 0x044fe200078e00ffULL,
0x000000011b1b7810ULL, 0x000fc80007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x0000000c1b00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080e0b7810ULL, 0x040fe40007ffe0ffULL, 0x000000010e0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001d02027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x00000070101d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e01dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a1d7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090e0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000020e0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000000f02027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a0f7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0e0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000030e0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001102027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007010117812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a117981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0e0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000040e0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001302027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007010137812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e013ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a137981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0e0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000050e0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001502027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007010157812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e015ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a157981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0e0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000060e0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001702027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007010177812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e017ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a177981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0e0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000070e0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001902027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007010197812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e019ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a197981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0e0b7810ULL, 0x002fe40007ffe0ffULL,
0x0000000d02027209ULL, 0x000fe40007810000ULL, 0x000003000b007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030d7824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fc80007a3e00dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000060a0d7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ee40000000000ULL, 0x00000010030a7824ULL, 0x00afe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011603ULL, 0x000000700a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL, 0x000000010b0b7824ULL, 0x000fca00078e020aULL,
0x000000020b007388ULL, 0x0203e40000000800ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000001003027824ULL, 0x002fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x0000000149127824ULL, 0x000fe200078e0206ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000800ff0f7424ULL, 0x004fe200078e00ffULL, 0x0000007002027812ULL, 0x000fe200078ec0ffULL,
0x000000013f3f7824ULL, 0x000fe200078e0200ULL, 0x0000000c0b0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000012070a7211ULL, 0x000fe200078fa8ffULL,
0x000010d000007945ULL, 0x000fe20003800000ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000010d297824ULL, 0x000fe200078e0202ULL, 0x0000000139027812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000fULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000002490d8824ULL, 0x140fe200078e023cULL, 0x000000080a0a7210ULL, 0x000fe20007f3e0ffULL,
0x00000002490f8824ULL, 0x000fe200078e023cULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000080039397824ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000020d0c8824ULL, 0x000fc400078e0202ULL, 0x000000020f148824ULL, 0x000fe200078e0202ULL,
0x0000080039027812ULL, 0x000fe200078ec0ffULL, 0x0000000109108824ULL, 0x000fe200078e0212ULL,
0x00000020030f7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff118424ULL, 0x000fe200078e00ffULL,
0x0000000029297984ULL, 0x000e620000000800ULL, 0x00000080ff138424ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000030049007a0cULL, 0x000fe20003f26070ULL,
0x000000013f027824ULL, 0x000fc400078e0202ULL, 0x00006c0010108625ULL, 0x000fc800078e0011ULL,
0x00006c0012128625ULL, 0x000fc800078e0013ULL, 0x000000080c178824ULL, 0x100fe400078e0203ULL,
0x0000000814148824ULL, 0x000fe400078e0203ULL, 0x0000001003157824ULL, 0x000fe200078e0202ULL,
0x0000458017178811ULL, 0x000fe200078e20ffULL, 0x00000010030c7825ULL, 0x000fe200078e000aULL,
0x00004180141f8811ULL, 0x000fc600078e20ffULL, 0x000000100f0e7825ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c157faeULL, 0x0005e2000b901c46ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x0000001003108825ULL, 0x040fe200078e0010ULL,
0x003800000e157faeULL, 0x0007e6000b901c46ULL, 0x0000001003128825ULL, 0x000fe200078e0012ULL,
0x0000000010178faeULL, 0x0009e6000b901c46ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00000000121f8faeULL, 0x0003e2000b901c46ULL, 0x00000000000c7805ULL, 0x004fe2000001ff00ULL,
0x000000ffff287224ULL, 0x000fc400078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000e7805ULL, 0x008fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x010fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x002fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000d5000001947ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e00ffULL, 0x000000ffff337224ULL, 0x000fca00078e0049ULL,
0x0000000233357810ULL, 0x000fe20007ffe0ffULL, 0x0000029000017945ULL, 0x000fe60003800000ULL,
0x0000030035007a0cULL, 0x000fda0003f06070ULL, 0x0000026000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x040fe20003f24070ULL, 0x0000000106307824ULL, 0x100fe200078e0235ULL,
0x00000001ff2a7819ULL, 0x000fe20000011635ULL, 0x00000800ff347424ULL, 0x000fe200078e00ffULL,
0x0000002003397810ULL, 0x000fe20007ffe0ffULL, 0x00000400352c7824ULL, 0x000fe200078e00ffULL,
0x00000030072b7211ULL, 0x000fe400078fa8ffULL, 0x000000012a2e7812ULL, 0x000fc600078ec0ffULL,
0x00006c002b2a7625ULL, 0x000fc800078e0034ULL, 0x00000002492f9824ULL, 0x140fe200078e023cULL,
0x000000082a2a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000249319824ULL, 0x000fe400078e023cULL,
0x000000022f349824ULL, 0x100fe400078e022eULL, 0x0000000231389824ULL, 0x000fe200078e022eULL,
0x000008002c2e7812ULL, 0x000fe200078ec0ffULL, 0x00000001092d9824ULL, 0x000fe400078e0230ULL,
0x00000080ff369424ULL, 0x000fc400078e00ffULL, 0x00000080ff319424ULL, 0x000fe400078e00ffULL,
0x00006c002d2c9625ULL, 0x000fc800078e0036ULL, 0x000000013f2e7824ULL, 0x000fe400078e022eULL,
0x000000ffff2b7224ULL, 0x000fe400000e062bULL, 0x00006c0030309625ULL, 0x000fc800078e0031ULL,
0x0000001003377824ULL, 0x040fe400078e022eULL, 0x0000000834349824ULL, 0x000fe400078e0203ULL,
0x00000010032e9825ULL, 0x000fc800078e002cULL, 0x0000000838389824ULL, 0x000fe400078e0203ULL,
0x00000010392c7825ULL, 0x100fe200078e002aULL, 0x0000458034399811ULL, 0x000fe400078e20ffULL,
0x00004180383b9811ULL, 0x020fe200078e20ffULL, 0x00000010032a7825ULL, 0x000fc800078e002aULL,
0x0000001003309825ULL, 0x000fe200078e0030ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800002a377faeULL, 0x0003e8000b901c46ULL, 0x003800002c377faeULL, 0x0003e8000b901c46ULL,
0x000000002e399faeULL, 0x0003e8000b901c46ULL, 0x00000000303b9faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000040332a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff2c7819ULL, 0x100fe20000011603ULL,
0x00000002492d7824ULL, 0x000fe200078e023cULL, 0x00000002ff527819ULL, 0x000fe20000011603ULL,
0x00000010032b7824ULL, 0x000fe200078e00ffULL, 0x000000802a2a7812ULL, 0x000fc400078ec0ffULL,
0x0000000c2c2c7812ULL, 0x000fe200078ec0ffULL, 0x00000008522f7824ULL, 0x040fe200078e00ffULL,
0x000000702b2b7812ULL, 0x000fe200078ec0ffULL, 0x000001002d2a7824ULL, 0x000fe200078e002aULL,
0x0000000752427812ULL, 0x040fe200078ec0ffULL, 0x00000008522d7824ULL, 0x040fe200078e00ffULL,
0x0000000852547810ULL, 0x000fe40007ffe0ffULL, 0x0000002a2c2c7210ULL, 0x000fe20007ffe02bULL,
0x00000008522b7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2a7812ULL, 0x100fe200078ee242ULL,
0x00000008542d7824ULL, 0x040fe200078e00ffULL, 0x00000054ff4e7212ULL, 0x000fe200078e33ffULL,
0x0000000854447824ULL, 0x000fe200078e00ffULL, 0x000000012b2e7812ULL, 0x000fe200078ef642ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180002c3a7984ULL, 0x000e620000000800ULL,
0x000000022b307812ULL, 0x140fe400078ef642ULL, 0x000000032b347812ULL, 0x140fe200078ef642ULL,
0x004580002c507984ULL, 0x0002a20000000800ULL, 0x000000042b367812ULL, 0x140fe400078ef642ULL,
0x000000052b387812ULL, 0x000fe400078ef642ULL, 0xfffffff82d4e7812ULL, 0x000fe200078ee24eULL,
0x00000004032d7824ULL, 0x000fe200078e00ffULL, 0x00000052ff407212ULL, 0x000fc800078e33ffULL,
0x0000000c2d2d7812ULL, 0x000fe400078ec0ffULL, 0xfffffff82f407812ULL, 0x000fe400078ee240ULL,
0x00000007542f7812ULL, 0x000fe200078ec0ffULL, 0x0000003a292c7221ULL, 0x002fe20000010100ULL,
0x000000062b3a7812ULL, 0x000fe200078ef642ULL, 0x00000400332b7824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b2c317820ULL, 0x000fe20000410000ULL, 0x0000000854427824ULL, 0x000fc400078e00ffULL,
0x000008002b2c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff337224ULL, 0x000fe400078e0035ULL,
0x0000000242467812ULL, 0x100fe200078ef62fULL, 0x0000003100317308ULL, 0x000ea20000000800ULL,
0x000001803f2b7810ULL, 0x000fe40007ffe02cULL, 0xfffffff8442c7812ULL, 0x100fe400078ee22fULL,
0x0000000142447812ULL, 0x000fe200078ef62fULL, 0x000000102a2a7824ULL, 0x000fe200078e022bULL,
0x0000000342487812ULL, 0x000fe200078ef62fULL, 0x0000001040407824ULL, 0x000fe200078e022bULL,
0x00000004424a7812ULL, 0x000fe200078ef62fULL, 0x000000012a2a7824ULL, 0x000fe200078e022dULL,
0x00000005424c7812ULL, 0x140fe200078ef62fULL, 0x000000012d407824ULL, 0x000fe200078e0240ULL,
0x0000000642427812ULL, 0x000fe200078ef62fULL, 0x000000102e2e7824ULL, 0x100fe200078e022bULL,
0x000000002a2f7984ULL, 0x000e620000000800ULL, 0x0000001030307824ULL, 0x100fe200078e022bULL,
0x0000005031317220ULL, 0x004fe20000410000ULL, 0x000000012d2e7824ULL, 0x040fe200078e022eULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x000000012d307824ULL, 0x000fe200078e0230ULL,
0x0000030033007a0cULL, 0x000fe20003f06070ULL, 0x0000001034347824ULL, 0x100fe200078e022bULL,
0x00001f52312a7589ULL, 0x000ea200000e0000ULL, 0x0000001036367824ULL, 0x000fe200078e022bULL,
0x0000003231327221ULL, 0x000fe20000010000ULL, 0x000000012d347824ULL, 0x040fe200078e0234ULL,
0x000000002e2e7984ULL, 0x000ee20000000800ULL, 0x000000012d367824ULL, 0x000fc400078e0236ULL,
0x0000001038387824ULL, 0x100fe200078e022bULL, 0x0000000030307984ULL, 0x000f220000000800ULL,
0x000000103a3a7824ULL, 0x100fe400078e022bULL, 0x000000012d387824ULL, 0x000fe200078e0238ULL,
0x0000000034347984ULL, 0x000ee20000000800ULL, 0x000000102c2c7824ULL, 0x100fe400078e022bULL,
0x0000001044447824ULL, 0x100fe200078e022bULL, 0x0000000036367984ULL, 0x000ee20000000800ULL,
0x0000001046467824ULL, 0x000fc400078e022bULL, 0x0000001048487824ULL, 0x100fe200078e022bULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x000000104a4a7824ULL, 0x100fe400078e022bULL,
0x000000104c4c7824ULL, 0x100fe400078e022bULL, 0x0000001042427824ULL, 0x100fe400078e022bULL,
0x000000104e4e7824ULL, 0x000fe400078e022bULL, 0x000000012d3a7824ULL, 0x040fe200078e023aULL,
0x00001f54312b7589ULL, 0x000fe200000e0000ULL, 0x000000012d2c7824ULL, 0x040fe200078e022cULL,
0x00007610ff507816ULL, 0x002fe2000000002fULL, 0x000000012d447824ULL, 0x000fc400078e0244ULL,
0x000000012d467824ULL, 0x040fe200078e0246ULL, 0x000000003a3a7984ULL, 0x000e620000000800ULL,
0x000000012d487824ULL, 0x040fe200078e0248ULL, 0x0000002a50277223ULL, 0x004fe20000010027ULL,
0x000000012d4a7824ULL, 0x040fe200078e024aULL, 0x000000002c2c7984ULL, 0x000ea20000000800ULL,
0x000000012d4c7824ULL, 0x040fe400078e024cULL, 0x000000012d427824ULL, 0x040fe200078e0242ULL,
0x0000000044447984ULL, 0x000e620000000800ULL, 0x000000012d4e7824ULL, 0x000fe200078e024eULL,
0x00005410ff2d7816ULL, 0x000fc4000000002fULL, 0x0000000046467984ULL, 0x000e660000000800ULL,
0x0000002a2d287223ULL, 0x000fe20000010028ULL, 0x00005410ff2d7816ULL, 0x100fe20000000040ULL,
0x0000000048487984ULL, 0x000ea20000000800ULL, 0x00007610ff407816ULL, 0x000fc60000000040ULL,
0x0000002a2d1a7223ULL, 0x080fe2000001001aULL, 0x00005410ff2d7816ULL, 0x108fe2000000002eULL,
0x000000004a4a7984ULL, 0x000ee20000000800ULL, 0x00007610ff2e7816ULL, 0x000fe2000000002eULL,
0x0000002a40197223ULL, 0x080fe40000010019ULL, 0x0000002a2d267223ULL, 0x080fe20000010026ULL,
0x00005410ff2d7816ULL, 0x110fe20000000030ULL, 0x000000004c4c7984ULL, 0x000f220000000800ULL,
0x00007610ff307816ULL, 0x000fe20000000030ULL, 0x0000002a2e257223ULL, 0x000fc40000010025ULL,
0x0000002a2d247223ULL, 0x080fe20000010024ULL, 0x00005410ff2d7816ULL, 0x100fe20000000034ULL,
0x0000000042427984ULL, 0x000ee20000000800ULL, 0x00007610ff347816ULL, 0x000fe20000000034ULL,
0x0000002a30237223ULL, 0x080fe40000010023ULL, 0x0000002a2d227223ULL, 0x080fe20000010022ULL,
0x00005410ff2d7816ULL, 0x100fe20000000036ULL, 0x000000004e4e7984ULL, 0x000ee20000000800ULL,
0x00007610ff367816ULL, 0x000fe20000000036ULL, 0x0000002a34217223ULL, 0x000fc40000010021ULL,
0x0000002a2d207223ULL, 0x080fe20000010020ULL, 0x00005410ff2d7816ULL, 0x100fe20000000038ULL,
0x0000002a361f7223ULL, 0x000fe2000001001fULL, 0x00007610ff387816ULL, 0x000fc60000000038ULL,
0x0000002a2d1e7223ULL, 0x080fe2000001001eULL, 0x00005410ff2d7816ULL, 0x102fe2000000003aULL,
0x0000002a381d7223ULL, 0x000fe2000001001dULL, 0x00007610ff3a7816ULL, 0x000fc6000000003aULL,
0x0000002a2d1c7223ULL, 0x080fe2000001001cULL, 0x00005410ff2d7816ULL, 0x104fe2000000002cULL,
0x0000002a3a1b7223ULL, 0x000fe2000001001bULL, 0x00007610ff2c7816ULL, 0x000fc6000000002cULL,
0x0000002b2d187223ULL, 0x080fe20000010018ULL, 0x00005410ff2d7816ULL, 0x100fe20000000044ULL,
0x0000002b2c177223ULL, 0x000fe20000010017ULL, 0x00007610ff447816ULL, 0x000fc60000000044ULL,
0x0000002b2d167223ULL, 0x080fe20000010016ULL, 0x00005410ff2d7816ULL, 0x100fe20000000046ULL,
0x0000002b44157223ULL, 0x000fe20000010015ULL, 0x00007610ff467816ULL, 0x000fc60000000046ULL,
0x0000002b2d147223ULL, 0x080fe20000010014ULL, 0x00005410ff2d7816ULL, 0x100fe20000000048ULL,
0x0000002b46137223ULL, 0x000fe20000010013ULL, 0x00007610ff487816ULL, 0x000fc60000000048ULL,
0x0000002b2d127223ULL, 0x080fe20000010012ULL, 0x00005410ff2d7816ULL, 0x108fe2000000004aULL,
0x0000002b48117223ULL, 0x000fe20000010011ULL, 0x00007610ff4a7816ULL, 0x000fc6000000004aULL,
0x0000002b2d107223ULL, 0x080fe20000010010ULL, 0x00005410ff2d7816ULL, 0x110fe2000000004cULL,
0x0000002b4a0f7223ULL, 0x000fe2000001000fULL, 0x00007610ff4c7816ULL, 0x000fc6000000004cULL,
0x0000002b2d0e7223ULL, 0x080fe2000001000eULL, 0x00005410ff2d7816ULL, 0x100fe20000000042ULL,
0x0000002b4c0d7223ULL, 0x000fe2000001000dULL, 0x00007610ff427816ULL, 0x000fc60000000042ULL,
0x0000002b2d0c7223ULL, 0x080fe2000001000cULL, 0x00005410ff2d7816ULL, 0x000fe2000000004eULL,
0x0000002b420b7223ULL, 0x000fc8000001000bULL, 0x0000002b2d0a7223ULL, 0x000fe2000001000aULL,
0x00007610ff2d7816ULL, 0x000fca000000004eULL, 0x0000002b2d027223ULL, 0x000fe20000010002ULL,
0xfffff2d000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000000ff3c00720cULL, 0x000fe20003f05270ULL,
0x0000001003067824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fca00078ec0ffULL,
0x0000000103077824ULL, 0x000fe200078e0206ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000001003067824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fe400078ec0ffULL,
0x0000000c03087812ULL, 0x000fc600078ec0ffULL, 0x0000008049037824ULL, 0x000fc800078e0206ULL,
0x0000000108037824ULL, 0x000fca00078e0203ULL, 0x0049803203007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800007037984ULL, 0x002e680000000800ULL, 0x004a000007067984ULL, 0x000ea20000000800ULL,
0x00000003ff037221ULL, 0x002fc80000010000ULL, 0x0000000603037221ULL, 0x004fca0000010000ULL,
0x0180000003067810ULL, 0x000fc80007ffe0ffULL, 0x7f80000006067812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0600780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff417224ULL, 0x000fe200078e0003ULL,
0x0000fc4000067802ULL, 0x000fe40000000f00ULL, 0x0000778000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff067224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000300067308ULL, 0x000e640000001000ULL, 0xbf80000003077423ULL, 0x002fc80000000006ULL,
0x800000ff07077221ULL, 0x000fc80000010100ULL, 0x0000000706067223ULL, 0x000fe40000000006ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000803417811ULL, 0x006fe400078ff0ffULL,
0x00000002ff337819ULL, 0x000fe40000011603ULL, 0x00000041ff437212ULL, 0x000fe200078e33ffULL,
0x00001f4106097589ULL, 0x000e6200000e0000ULL, 0x0000000841087824ULL, 0x000fc400078e00ffULL,
0x0000000833457824ULL, 0x000fe200078e00ffULL, 0x00001f3306077589ULL, 0x0004e400000e0000ULL,
0xfffffff808437812ULL, 0x000fca00078ee243ULL, 0x0000001043437824ULL, 0x000fe200078e0204ULL,
0x00000033ff067212ULL, 0x004fc800078e33ffULL, 0xfffffff845457812ULL, 0x000fe200078ee206ULL,
0x0000000833067824ULL, 0x000fe200078e00ffULL, 0x0000001809187220ULL, 0x042fe20000410000ULL,
0x0000001709177220ULL, 0x040fe20000410000ULL, 0x0000001609167220ULL, 0x040fe20000410000ULL,
0x0000001509157220ULL, 0x040fe20000410000ULL, 0x0000001409147220ULL, 0x040fe20000410000ULL,
0x0000001309137220ULL, 0x040fe20000410000ULL, 0x0000001209127220ULL, 0x040fe20000410000ULL,
0x0000001109117220ULL, 0x040fe20000410000ULL, 0x0000001009107220ULL, 0x040fe20000410000ULL,
0x0000000f090f7220ULL, 0x040fe20000410000ULL, 0x0000000e090e7220ULL, 0x040fe20000410000ULL,
0x0000000d090d7220ULL, 0x040fe20000410000ULL, 0x0000000c090c7220ULL, 0x040fe20000410000ULL,
0x0000000b090b7220ULL, 0x040fe20000410000ULL, 0x0000000a090a7220ULL, 0x040fe20000410000ULL,
0x0000000209097220ULL, 0x000fe20000410000ULL, 0x0000000733027812ULL, 0x000fe200078ec0ffULL,
0x0000002807287220ULL, 0x048fe20000410000ULL, 0x0000002707277220ULL, 0x040fe20000410000ULL,
0x0000002607267220ULL, 0x040fe20000410000ULL, 0x0000002507257220ULL, 0x040fe20000410000ULL,
0x0000002407247220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002107217220ULL, 0x040fe20000410000ULL,
0x0000002007207220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001d071d7220ULL, 0x040fe20000410000ULL,
0x0000001c071c7220ULL, 0x040fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001907077220ULL, 0x000fe20000410000ULL,
0x0000000e0d0d723eULL, 0x000fc400000010ffULL, 0x0000000c0b0b723eULL, 0x000fe400000010ffULL,
0x0000000a0909723eULL, 0x000fe400000010ffULL, 0xfffffff806197812ULL, 0x000fe400078ee233ULL,
0x0000000102067812ULL, 0x040fe400078e3cffULL, 0x0000000202087812ULL, 0x040fe200078e3cffULL,
0x0000001019197824ULL, 0x000fe200078e0204ULL, 0x00000003020a7812ULL, 0x040fe200078e3cffULL,
0x0000000833297824ULL, 0x040fe200078e0206ULL, 0x00000004020c7812ULL, 0x040fe200078e3cffULL,
0x00000008332b7824ULL, 0x040fe200078e0208ULL, 0x00000005020e7812ULL, 0x040fe200078e3cffULL,
0x00000008332d7824ULL, 0x040fe200078e020aULL, 0x0000000602027812ULL, 0x000fe200078e3cffULL,
0x00000008332f7824ULL, 0x000fe200078e020cULL, 0x000000121111723eULL, 0x000fe200000010ffULL,
0x0000000833317824ULL, 0x000fe200078e020eULL, 0x0000000741127812ULL, 0x000fe200078ec0ffULL,
0x0000000833337824ULL, 0x000fe200078e0202ULL, 0x000000141313723eULL, 0x000fe200000010ffULL,
0x0000000841147824ULL, 0x000fe200078e00ffULL, 0x000000100f0f723eULL, 0x000fe200000010ffULL,
0x0000000403107824ULL, 0x000fe200078e00ffULL, 0x0000000112027812ULL, 0x040fe200078e3cffULL,
0x0000001029297824ULL, 0x100fe200078e0204ULL, 0x0000000212067812ULL, 0x040fe200078e3cffULL,
0x000000102b2b7824ULL, 0x000fe200078e0204ULL, 0x0000000312087812ULL, 0x040fe200078e3cffULL,
0x0000000841377824ULL, 0x040fe200078e0202ULL, 0x00000004120a7812ULL, 0x040fe200078e3cffULL,
0x0000000841397824ULL, 0x040fe200078e0206ULL, 0x00000005120c7812ULL, 0x040fe200078e3cffULL,
0x00000008413b7824ULL, 0x060fe200078e0208ULL, 0x00000006120e7812ULL, 0x000fe200078e3cffULL,
0x00000008413d7824ULL, 0x000fe200078e020aULL, 0x0000001c1b1b723eULL, 0x000fe200000010ffULL,
0x00000008413f7824ULL, 0x040fe200078e020cULL, 0xfffffff814357812ULL, 0x000fe200078ee241ULL,
0x0000000841417824ULL, 0x000fe200078e020eULL, 0x0000000c101c7812ULL, 0x000fe200078ec0ffULL,
0x0000001045067824ULL, 0x100fe200078e0204ULL, 0x000000282727723eULL, 0x000fe200000010ffULL,
0x000000102d2d7824ULL, 0x100fe200078e0204ULL, 0x000000262525723eULL, 0x000fe200000010ffULL,
0x0000001035357824ULL, 0x100fe200078e0204ULL, 0x000000242323723eULL, 0x000fe200000010ffULL,
0x000000011c027824ULL, 0x000fe200078e0219ULL, 0x000000222121723eULL, 0x000fe200000010ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0204ULL, 0x000000201f1f723eULL, 0x000fe200000010ffULL,
0x0000001031317824ULL, 0x100fe200078e0204ULL, 0x0000001e1d1d723eULL, 0x000fe200000010ffULL,
0x0000001033337824ULL, 0x100fe200078e0204ULL, 0x0000002702007388ULL, 0x0003e20000000800ULL,
0x0000001037377824ULL, 0x100fe200078e0204ULL, 0x0000001a0707723eULL, 0x000fe200000010ffULL,
0x0000001039397824ULL, 0x100fe200078e0204ULL, 0x000000181717723eULL, 0x000fe200000010ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0204ULL, 0x000000161515723eULL, 0x000fe200000010ffULL,
0x000000103d3d7824ULL, 0x000fc400078e0204ULL, 0x000000103f3f7824ULL, 0x100fe400078e0204ULL,
0x0000001041417824ULL, 0x000fe400078e0204ULL, 0x000000011c107824ULL, 0x040fe400078e0206ULL,
0x000000011c047824ULL, 0x040fe400078e0229ULL, 0x000000011c067824ULL, 0x040fe400078e022bULL,
0x000000011c087824ULL, 0x040fe200078e022dULL, 0x0000002504007388ULL, 0x000fe20000000800ULL,
0x000000011c0a7824ULL, 0x000fc400078e022fULL, 0x000000011c0c7824ULL, 0x040fe200078e0231ULL,
0x0000002306007388ULL, 0x000fe20000000800ULL, 0x000000011c0e7824ULL, 0x040fe400078e0233ULL,
0x000000011c127824ULL, 0x040fe200078e0235ULL, 0x0000002108007388ULL, 0x000fe20000000800ULL,
0x000000011c147824ULL, 0x040fe400078e0237ULL, 0x000000011c027824ULL, 0x042fe200078e0239ULL,
0x0000001f0a007388ULL, 0x000fe20000000800ULL, 0x000000011c167824ULL, 0x000fc400078e023bULL,
0x000000011c187824ULL, 0x040fe200078e023dULL, 0x0000001d0c007388ULL, 0x000fe20000000800ULL,
0x000000011c1e7824ULL, 0x040fe400078e0243ULL, 0x000000011c1a7824ULL, 0x040fe200078e023fULL,
0x0000001b0e007388ULL, 0x000fe20000000800ULL, 0x000000011c1c7824ULL, 0x000fe400078e0241ULL,
0x000000013e197824ULL, 0x000fe200078e0203ULL, 0x0000000710007388ULL, 0x0003e60000000800ULL,
0x0000001019197824ULL, 0x000fe200078e0200ULL, 0x0000001712007388ULL, 0x000fe80000000800ULL,
0x0000001514007388ULL, 0x000fe20000000800ULL, 0x000000050510723eULL, 0x002fc600000010ffULL,
0x0000001302007388ULL, 0x000fe80000000800ULL, 0x0000001116007388ULL, 0x000fe80000000800ULL,
0x0000000f18007388ULL, 0x000fe80000000800ULL, 0x0000000d1a007388ULL, 0x000fe80000000800ULL,
0x0000000b1c007388ULL, 0x000fe80000000800ULL, 0x000000091e007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000019207984ULL, 0x000e680000000c00ULL,
0x0004000019287984ULL, 0x000ea80000000c00ULL, 0x0008000019247984ULL, 0x000ee80000000c00ULL,
0x000c0000192c7984ULL, 0x000f220000000c00ULL, 0x3f803f8010237831ULL, 0x002fc40000200023ULL,
0x3f803f8010227831ULL, 0x040fe40000200022ULL, 0x3f803f8010217831ULL, 0x040fe40000200021ULL,
0x3f803f8010207831ULL, 0x040fe40000200020ULL, 0x3f803f80102b7831ULL, 0x044fe4000020002bULL,
0x3f803f80102a7831ULL, 0x040fe4000020002aULL, 0x3f803f8010297831ULL, 0x000fc40000200029ULL,
0x3f803f8010287831ULL, 0x000fe40000200028ULL, 0x3f803f8023237831ULL, 0x008fe40000200027ULL,
0x3f803f8022227831ULL, 0x000fe40000200026ULL, 0x3f803f8021217831ULL, 0x000fe40000200025ULL,
0x3f803f8020207831ULL, 0x000fe40000200024ULL, 0x3f803f802b2b7831ULL, 0x010fc4000020002fULL,
0x3f803f802a2a7831ULL, 0x000fe2000020002eULL, 0x0000002019007388ULL, 0x0003e20000000c00ULL,
0x3f803f8029297831ULL, 0x000fe4000020002dULL, 0x3f803f8028287831ULL, 0x000fca000020002cULL,
0x0004002819007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff4900720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002003117810ULL, 0x002fe20007ffe0ffULL, 0x0000000000107919ULL, 0x000e620000002600ULL,
0x00000003ff127819ULL, 0x000fe20000011603ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x00000003ff047819ULL, 0x000fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000712027812ULL, 0x000fe200078e4803ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000704067812ULL, 0x000fe400078e4811ULL, 0x0ffffff802057812ULL, 0x000fc400078ef803ULL,
0x0ffffff806077812ULL, 0x000fc600078ef811ULL, 0x0000001005057824ULL, 0x100fe400078e0200ULL,
0x0000001007077824ULL, 0x000fc600078e0200ULL, 0x0000000005087984ULL, 0x0008a80000000c00ULL,
0x00000000070c7984ULL, 0x0044a20000000c00ULL, 0x0000000810137824ULL, 0x042fe400078e00ffULL,
0x0000000810157824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x008fe2000f8e023fULL,
0x000000083c107824ULL, 0x040fe200078e00ffULL, 0xfffffff813007812ULL, 0x000fe200078ee212ULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff815047812ULL, 0x000fc400078ee204ULL,
0x0000000400027c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000404007c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff810037812ULL, 0x000fe200078ee203ULL, 0x000000ffff057224ULL, 0x010fe200000e06ffULL,
0x00005a0002047a11ULL, 0x000fe200078040ffULL, 0x000000ffff077224ULL, 0x004fe200008e06ffULL,
0x00005a0000067a11ULL, 0x000fe400078240ffULL, 0x00005b0002057a11ULL, 0x000fc400000f4405ULL,
0x00005b0000077a11ULL, 0x000fe400008f4407ULL, 0xfffffff83c117812ULL, 0x000fe200078ee211ULL,
0x0000001003027825ULL, 0x000fc800078e0004ULL, 0x0000001011047825ULL, 0x000fe200078e0006ULL,
0x0000000802007986ULL, 0x000fe8000c101d06ULL, 0x0000000c04007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000435397824ULL, 0x000fe400078e0202ULL,
0xffffffffff387424ULL, 0x000fc600078e00ffULL, 0x000000343900720cULL, 0x000fda0003f06070ULL,
0x0000000224068824ULL, 0x000fc800078e00ffULL, 0x0000640006068a24ULL, 0x000fc800078e0239ULL,
0x0000600006068625ULL, 0x000fe200078e0011ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff087624ULL, 0x000fe200078e00ffULL, 0x0000000606388981ULL, 0x000ea2000c1e1900ULL,
0x00006900ff097624ULL, 0x000fc600078e00ffULL, 0x00f60000ff047f8cULL, 0x000e68000c80043fULL,
0x0000000608227981ULL, 0x000762000c1e9900ULL, 0x00000001350b7810ULL, 0x000fe20007ffe0ffULL,
0x000000403b3b7824ULL, 0x000fe400078e00ffULL, 0x00000040023a7824ULL, 0x000fe200078e00ffULL,
0x000000360b00720cULL, 0x000fe20003f06070ULL, 0x000000403d3c7824ULL, 0x000fc400078e00ffULL,
0x0000003b38177224ULL, 0x004fd400078e02ffULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x0000010035007824ULL, 0x00afe200078e023aULL, 0x00000002ff197819ULL, 0x100fe40000011637ULL,
0x00000003ff107819ULL, 0x000fe40000011637ULL, 0x0000000003077217ULL, 0x000fe20007800000ULL,
0x000000403d067824ULL, 0x000fe200078e0219ULL, 0x0000000310107812ULL, 0x000fe400078e4837ULL,
0x000000300e1b7812ULL, 0x000fe200078ec0ffULL, 0x0000000107007824ULL, 0x000fe200078e0a00ULL,
0x0000000806077810ULL, 0x000fc40007ffe0ffULL, 0x0000001006087810ULL, 0x000fe40007ffe0ffULL,
0x0000000717077210ULL, 0x040fe40007f3e0ffULL, 0x0000000617127210ULL, 0x040fe40007f1e0ffULL,
0x0000000817087210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e0007137a11ULL, 0x000fe200078238ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e00120c7a11ULL, 0x000fe200078038ffULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x00005e00080f7a11ULL, 0x000fc400078438ffULL, 0x00005f0007157a11ULL, 0x000fe400008f3c0aULL,
0x0000001806077810ULL, 0x000fe40007ffe0ffULL, 0x000000001900720cULL, 0x000fe40003f66070ULL,
0x00005f0012127a11ULL, 0x000fe400000f3c09ULL, 0x00005f0008117a11ULL, 0x000fe400010f3c11ULL,
0x0000002006087810ULL, 0x000fc40007ffe0ffULL, 0x0000002806097810ULL, 0x040fe40007ffe0ffULL,
0x00000030060a7810ULL, 0x040fe40007ffe0ffULL, 0x00000038060b7810ULL, 0x000fe40007ffe0ffULL,
0x00001000020e7811ULL, 0x000fe400078e68ffULL, 0x0ffffffc10377812ULL, 0x000fe400078ef837ULL,
0x00000007170d7210ULL, 0x000fc40007f3e0ffULL, 0x0000000c1b067210ULL, 0x000fe20007f1e0ffULL,
0x0000001037377824ULL, 0x000fe200078e020eULL, 0x0000000817187210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x00005e000d0c7a11ULL, 0x000fe200078838ffULL,
0x000000ffff077224ULL, 0x000fe200000e0612ULL, 0x0000000917167210ULL, 0x000fe40007fde0ffULL,
0x00005f000d0d7a11ULL, 0x000fe400020f3c08ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006377faeULL, 0x0003e2000d901c46ULL, 0x0000001b13087210ULL, 0x000fc40007f7e0ffULL,
0x0000000a17147210ULL, 0x040fe40007f1e0ffULL, 0x0000000b17127210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200018e0615ULL, 0x0000000819177810ULL, 0x000fe40007ffe0ffULL,
0x0000001b0f0a7210ULL, 0x080fe40007f9e0ffULL, 0x0000001019137810ULL, 0x000fe40007ffe0ffULL,
0x000000001700720cULL, 0x0c0fe20003f66070ULL, 0x0000000417177824ULL, 0x000fe200078e00ffULL,
0x00000018190f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e0611ULL,
0x0000001b0c0c7210ULL, 0x000fe20007fbe0ffULL, 0x0000000413117824ULL, 0x040fe200078e00ffULL,
0x000000001300720cULL, 0x080fe20003f86070ULL, 0x000000040f157824ULL, 0x000fe200078e00ffULL,
0xfffffffc17077812ULL, 0x002fe200078ee210ULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x00005e0018067a11ULL, 0x000fe200078438ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e060dULL,
0x000000000f00720cULL, 0x000fe20003fa6070ULL, 0x0000001007077824ULL, 0x000fe200078e020eULL,
0xfffffffc110f7812ULL, 0x000fc400078ee210ULL, 0xfffffffc15117812ULL, 0x000fe400078ee210ULL,
0x00005f0018187a11ULL, 0x000fe200010f3c13ULL, 0x000000100f0f7824ULL, 0x100fe200078e020eULL,
0x0000002019137810ULL, 0x000fe20007ffe0ffULL, 0x0000001011117824ULL, 0x000fe200078e020eULL,
0x0000000008077faeULL, 0x0003e2000d901c46ULL, 0x0000002819157810ULL, 0x040fe40007ffe0ffULL,
0x0000003019177810ULL, 0x040fe20007ffe0ffULL, 0x000000000a0f7faeULL, 0x0005e2000e101c46ULL,
0x0000003819197810ULL, 0x000fc40007ffe0ffULL, 0x000000001500720cULL, 0x080fe20003f66070ULL,
0x000000000c117faeULL, 0x0007e2000e901c46ULL, 0x000000001300720cULL, 0x080fe40003f46070ULL,
0x000000001700720cULL, 0x080fe20003f86070ULL, 0x0000000413077824ULL, 0x002fe200078e00ffULL,
0x000000001900720cULL, 0x000fe20003fa6070ULL, 0x0000000415097824ULL, 0x000fe400078e00ffULL,
0x00000004170b7824ULL, 0x004fe200078e00ffULL, 0xfffffffc07077812ULL, 0x000fc400078ee210ULL,
0xfffffffc09097812ULL, 0x100fe200078ee210ULL, 0x00000004190d7824ULL, 0x008fe200078e00ffULL,
0xfffffffc0b0b7812ULL, 0x000fe200078ee210ULL, 0x00000010070f7824ULL, 0x000fe400078e020eULL,
0x000000ffff077224ULL, 0x000fe200030e06ffULL, 0xfffffffc0d0d7812ULL, 0x000fe200078ee210ULL,
0x0000001009117824ULL, 0x100fe200078e020eULL, 0x00005e0016087a11ULL, 0x040fe200078c38ffULL,
0x000000100b137824ULL, 0x100fe400078e020eULL, 0x000000100d157824ULL, 0x000fe200078e020eULL,
0x00005f00160d7a11ULL, 0x000fe200030f3c07ULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x0000001b06067210ULL, 0x000fe20007fde0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x00005e00140a7a11ULL, 0x000fc400078038ffULL, 0x0000001b08087210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200030e0618ULL, 0x00005e00120c7a11ULL, 0x000fe400078c38ffULL,
0x00005f00140b7a11ULL, 0x000fe400000f3c0bULL, 0x00005f0012007a11ULL, 0x000fe200030f3c09ULL,
0x000000ffff097224ULL, 0x000fe200008e060dULL, 0x0000001b0a0a7210ULL, 0x080fe20007f1e0ffULL,
0x00000000060f7faeULL, 0x0003e2000d101c46ULL, 0x0000001b0c0c7210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000000008117faeULL, 0x0003e2000d901c46ULL,
0x000000ffff0d7224ULL, 0x000fc600008e0600ULL, 0x000000000a137faeULL, 0x0003e8000e101c46ULL,
0x000000000c157faeULL, 0x0003e2000e901c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000003c37007211ULL, 0x04afe400078ff0ffULL, 0x0000000837157811ULL, 0x000fe400078ff0ffULL,
0x0000000017007210ULL, 0x000fe40007f1e0ffULL, 0x0000001837097811ULL, 0x000fc400078ff0ffULL,
0x00000020370b7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x00005e0000167a11ULL, 0x000fe200078038ffULL, 0x000000013c087824ULL, 0x040fe200078e0209ULL,
0x00000028370d7811ULL, 0x040fe200078ff0ffULL, 0x000000013c0a7824ULL, 0x000fe200078e020bULL,
0x00005f0000207a11ULL, 0x000fe200000f3c07ULL, 0x000000013c007824ULL, 0x040fe200078e0215ULL,
0x0000001037077811ULL, 0x040fe200078ff0ffULL, 0x000000013c0c7824ULL, 0x040fe200078e020dULL,
0x00000030370f7811ULL, 0x000fe200078ff0ffULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0x0000003837117811ULL, 0x000fe200078ff0ffULL, 0x000000013c067824ULL, 0x040fe200078e0207ULL,
0x00000003ff147819ULL, 0x000fe20000011637ULL, 0x000000013c107824ULL, 0x040fe200078e020fULL,
0x00000000171e7210ULL, 0x040fe20007fde0ffULL, 0x000000013c127824ULL, 0x000fe200078e0211ULL,
0x0000000617137210ULL, 0x000fe20007fbe0ffULL, 0x0000000407077824ULL, 0x000fe200078e00ffULL,
0x00000008171a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000415157824ULL, 0x000fe200078e00ffULL,
0x0000000a17187210ULL, 0x000fe20007f3e0ffULL, 0x000000040f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000c170c7210ULL, 0x000fe20007f5e0ffULL, 0x000000040b0b7824ULL, 0x000fe200078e00ffULL,
0x0000001017107210ULL, 0x000fe20007f7e0ffULL, 0x0000000411117824ULL, 0x000fe200078e00ffULL,
0x0000001217127210ULL, 0x000fe20007f9e0ffULL, 0x000000040d177824ULL, 0x000fe200078e00ffULL,
0x0000000314147812ULL, 0x000fe200078e4837ULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0x0000100002237811ULL, 0x000fc400078e68ffULL, 0xfffffffc07067812ULL, 0x100fe400078ee214ULL,
0xfffffffc09077812ULL, 0x100fe400078ee214ULL, 0xfffffffc17097812ULL, 0x100fe200078ee214ULL,
0x0000001006197824ULL, 0x100fe200078e0223ULL, 0x00005e001e1c7a11ULL, 0x040fe200078c38ffULL,
0x00000010071b7824ULL, 0x100fe200078e0223ULL, 0xfffffffc15007812ULL, 0x100fe200078ee214ULL,
0x00000010091f7824ULL, 0x000fe200078e0223ULL, 0xfffffffc0f0a7812ULL, 0x100fe200078ee214ULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005f001e1e7a11ULL, 0x000fe200030f3c0dULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e00180f7a11ULL, 0x000fe200078238ffULL,
0x0000001000177824ULL, 0x000fe200078e0223ULL, 0x0ffffffc14377812ULL, 0x000fe200078ef837ULL,
0x000000100a217824ULL, 0x100fe200078e0223ULL, 0xfffffffc0b087812ULL, 0x100fe200078ee214ULL,
0x000000ffff007224ULL, 0x000fe200028e06ffULL, 0x00005e001a0d7a11ULL, 0x000fe200078038ffULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0xfffffffc110b7812ULL, 0x000fe200078ee214ULL,
0x0000001037377824ULL, 0x100fe200078e0223ULL, 0x000000300e257812ULL, 0x000fe200078ec0ffULL,
0x00000010081d7824ULL, 0x100fe200078e0223ULL, 0x00005e00130a7a11ULL, 0x000fe200078a38ffULL,
0x000000100b237824ULL, 0x000fe200078e0223ULL, 0x00005f0018187a11ULL, 0x000fe200008f3c07ULL,
0x000000ffff077224ULL, 0x000fe200020e06ffULL, 0x00005f001a1a7a11ULL, 0x000fe200000f3c09ULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x00005e0012147a11ULL, 0x000fc400078638ffULL,
0x0000001625067210ULL, 0x000fe40007f1e0ffULL, 0x00005f00130b7a11ULL, 0x000fe400028f3c00ULL,
0x00005e000c117a11ULL, 0x000fe400078238ffULL, 0x00005e0010137a11ULL, 0x000fe400078438ffULL,
0x00005f0012007a11ULL, 0x000fe200018f3c07ULL, 0x000000ffff077224ULL, 0x000fe200000e0620ULL,
0x00005f000c167a11ULL, 0x000fc400008f3c09ULL, 0x0000001c25087210ULL, 0x040fe40007f1e0ffULL,
0x00005f0010157a11ULL, 0x000fe200010f3c15ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006377faeULL, 0x0003e2000b901c46ULL, 0x0000000a250a7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e061eULL, 0x0000000d250c7210ULL, 0x040fe40007f5e0ffULL,
0x0000000f250e7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000001125107210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e061aULL,
0x0000001325127210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e0618ULL,
0x0000001425147210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200020e0616ULL,
0x0000000008177faeULL, 0x0003e2000b901c46ULL, 0x000000ffff137224ULL, 0x000fc400028e0615ULL,
0x000000ffff157224ULL, 0x000fe200000e0600ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x000000000c1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e4000b901c46ULL, 0x00f60400ff077984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000007ff7812ULL, 0x002fc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe20003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002002007824ULL, 0x002fc800078e0205ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7800ULL,
0x0000000707077812ULL, 0x000fc600078e7800ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001005007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff047f8cULL, 0x002fe8000c80043fULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000363500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000377919ULL, 0x000e620000000000ULL,
0x3db504f3223d7820ULL, 0x020fe20000410000ULL, 0x00006400243e7a24ULL, 0x000fe200078e02ffULL,
0x0000f688023f7811ULL, 0x000fe200078e18ffULL, 0x000000ffff437224ULL, 0x000fe200078e00ffULL,
0xffffffff36407810ULL, 0x000fe40007ffe0ffULL, 0x0000f60802417811ULL, 0x000fe400078e28ffULL,
0x0000010035427824ULL, 0x000fe200078e023aULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000420300720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x03cfea0003800000ULL,
0x000000ffff457224ULL, 0x000fe200078e0043ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fc4000001ff00ULL,
0x0000000146007810ULL, 0x000fe20007ffe0ffULL, 0x00000d7000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4e7224ULL, 0x000fe200078e0046ULL, 0x0000000145437812ULL, 0x000fe200078e0cffULL,
0x0000003b38337224ULL, 0x020fe200078e02ffULL, 0x00000001ff247819ULL, 0x100fe20000011600ULL,
0x000000ffff467224ULL, 0x000fe200078e0000ULL, 0x000000020000780cULL, 0x000fc40003f06070ULL,
0x0000000100547812ULL, 0x000fe200078ec0ffULL, 0x0000030024277a24ULL, 0x000fca00078e0235ULL,
0x0000000127257810ULL, 0x000fc80007ffe0ffULL, 0x000000362500720cULL, 0x000fda0003f26070ULL,
0x000006c000009947ULL, 0x000fea0003800000ULL, 0x00000002ff2f7819ULL, 0x002fe20000011637ULL,
0x0000010027007824ULL, 0x000fe400078e023aULL, 0x0000000202447824ULL, 0x000fe200078e0243ULL,
0x000000102f4d7810ULL, 0x040fe20007ffe0ffULL, 0x000000013c247824ULL, 0x040fe200078e022fULL,
0x000000082f477810ULL, 0x040fe40007ffe0ffULL, 0x000000182f4f7810ULL, 0x000fe20007ffe0ffULL,
0x000000013c277824ULL, 0x040fe200078e024dULL, 0x00000024332d7210ULL, 0x000fe20007f3e0ffULL,
0x000000013c267824ULL, 0x000fe200078e0247ULL, 0x0000000003257217ULL, 0x000fe20007800000ULL,
0x00000004474b7824ULL, 0x000fe200078e00ffULL, 0x0000002733297210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x00000026332b7210ULL, 0x000fe20007f5e0ffULL,
0x0000000125007824ULL, 0x000fe200078e0a00ULL, 0x000000202f517810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200018e06ffULL, 0x00005e0029287a11ULL, 0x000fe200078638ffULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x00005e002b267a11ULL, 0x000fc400078438ffULL,
0x00005f0029297a11ULL, 0x000fe200018f3c2aULL, 0x000000013c2a7824ULL, 0x040fe200078e024fULL,
0x000000282f537810ULL, 0x000fe40007ffe0ffULL, 0x00005e002d247a11ULL, 0x000fe400078238ffULL,
0x000000302f557810ULL, 0x040fe40007ffe0ffULL, 0x000000382f577810ULL, 0x000fe40007ffe0ffULL,
0x00005f002b277a11ULL, 0x000fe200010f3c2cULL, 0x000000013c2b7824ULL, 0x040fe200078e0251ULL,
0x00005f002d257a11ULL, 0x000fe200008f3c2eULL, 0x000000013c2c7824ULL, 0x040fe200078e0253ULL,
0x0000002a33327210ULL, 0x000fe20007f3e0ffULL, 0x000000013c2d7824ULL, 0x040fe200078e0255ULL,
0x000000002f00720cULL, 0x000fe20003f46070ULL, 0x000000013c2e7824ULL, 0x000fe200078e0257ULL,
0x0000002b33307210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff2b7224ULL, 0x000fe200008e06ffULL,
0x0000002c332f7210ULL, 0x000fc40007fde0ffULL, 0x00000003ff2c7819ULL, 0x100fe40000011637ULL,
0x00005e00322a7a11ULL, 0x000fe200078238ffULL, 0x000000ffff4c7224ULL, 0x000fe200030e06ffULL,
0x0000002d33317210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200028e06ffULL,
0x0000002e33337210ULL, 0x000fe20007f7e0ffULL, 0x00000004542e7824ULL, 0x000fe200078e00ffULL,
0x000000032c507812ULL, 0x000fe200078e4837ULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x00005f00322b7a11ULL, 0x000fe200008f3c2bULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x000000004700720cULL, 0x000fc40003f26070ULL, 0x0000100044447811ULL, 0x000fe400078e60ffULL,
0x0ffffffc50497812ULL, 0x100fe400078ef837ULL, 0xfffffffc2e477812ULL, 0x000fe400078ee237ULL,
0xfffffffc4b4b7812ULL, 0x000fe200078ee250ULL, 0x0000001049497824ULL, 0x000fe200078e0244ULL,
0x00005e00302c7a11ULL, 0x000fe200078a38ffULL, 0x0000001047247825ULL, 0x000fe200078e0024ULL,
0x00005e0033327a11ULL, 0x000fc400078638ffULL, 0x00005f00302d7a11ULL, 0x000fe200028f3c2dULL,
0x000000104b4b7824ULL, 0x000fe200078e0244ULL, 0x00005e0031307a11ULL, 0x000fe200078838ffULL,
0x0000001047267825ULL, 0x000fe200078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024497faeULL, 0x0003e2000d101c46ULL, 0x00005e002f2e7a11ULL, 0x000fe400078a38ffULL,
0x00005f0033337a11ULL, 0x000fe200018f3c48ULL, 0x00000000264b7faeULL, 0x0005e2000c901c46ULL,
0x000000004d00720cULL, 0x0c0fe20003f26070ULL, 0x000000044d4d7824ULL, 0x000fe200078e00ffULL,
0x000000004f00720cULL, 0x040fe20003f46070ULL, 0x000000044f4f7824ULL, 0x000fe200078e00ffULL,
0x00005f0031317a11ULL, 0x000fc400020f3c4aULL, 0x000000005100720cULL, 0x0c0fe20003f66070ULL,
0x0000000451517824ULL, 0x000fe200078e00ffULL, 0x00005f002f2f7a11ULL, 0x000fe200028f3c4cULL,
0x0000001047247825ULL, 0x002fe200078e0028ULL, 0x000000005300720cULL, 0x080fe40003f86070ULL,
0x000000005500720cULL, 0x080fe20003fa6070ULL, 0x0000000453537824ULL, 0x000fe200078e00ffULL,
0x000000005700720cULL, 0x000fe20003fc6070ULL, 0x0000000455557824ULL, 0x000fe200078e00ffULL,
0xfffffffc4d497812ULL, 0x100fe200078ee250ULL, 0x0000000457577824ULL, 0x000fe200078e00ffULL,
0xfffffffc4f4b7812ULL, 0x004fe200078ee250ULL, 0x0000001047267825ULL, 0x000fe200078e002aULL,
0xfffffffc514d7812ULL, 0x000fc400078ee250ULL, 0xfffffffc534f7812ULL, 0x000fe200078ee250ULL,
0x0000001049497824ULL, 0x000fe200078e0244ULL, 0xfffffffc55517812ULL, 0x000fe200078ee250ULL,
0x000000104b4b7824ULL, 0x000fe200078e0244ULL, 0xfffffffc57537812ULL, 0x000fe200078ee250ULL,
0x000000104d4d7824ULL, 0x000fe200078e0244ULL, 0x0000000024497faeULL, 0x0003e2000c901c46ULL,
0x0000001047287825ULL, 0x000fc600078e002cULL, 0x00000000264b7faeULL, 0x0003e2000d101c46ULL,
0x000000104f4f7824ULL, 0x000fe400078e0244ULL, 0x00000010472a7825ULL, 0x000fe200078e002eULL,
0x00000000284d7faeULL, 0x0003e6000d901c46ULL, 0x0000001051517824ULL, 0x000fe200078e0244ULL,
0x000000002a4f7faeULL, 0x0003e2000e101c46ULL, 0x00000010472c7825ULL, 0x000fc800078e0030ULL,
0x0000001053537824ULL, 0x000fe200078e0244ULL, 0x000000002c517faeULL, 0x0003e2000e901c46ULL,
0x00000010472e7825ULL, 0x000fca00078e0032ULL, 0x000000002e537faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x0000000837477811ULL, 0x042fe200078ff0ffULL,
0x00000002022a7824ULL, 0x000fe200078e0243ULL, 0x0000003c37007211ULL, 0x040fe200078ff0ffULL,
0x0000000454527824ULL, 0x000fe200078e00ffULL, 0x0000001037497811ULL, 0x000fe200078ff0ffULL,
0x000000013c247824ULL, 0x000fe200078e0247ULL, 0x0000003300257210ULL, 0x080fe20007f3e0ffULL,
0x0000000447477824ULL, 0x000fe200078e00ffULL, 0x00000018374b7811ULL, 0x000fe400078ff0ffULL,
0x0000003324007210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff287224ULL, 0x000fe200008e06ffULL,
0x00005e0025247a11ULL, 0x000fe200078238ffULL, 0x000000013c2c7824ULL, 0x000fe200078e024bULL,
0x00000020374d7811ULL, 0x000fe200078ff0ffULL, 0x000000ffff277224ULL, 0x000fe200010e06ffULL,
0x00005e0000267a11ULL, 0x000fe200078438ffULL, 0x000000044b4b7824ULL, 0x000fe200078e00ffULL,
0x00000028374f7811ULL, 0x040fe200078ff0ffULL, 0x000000013c2e7824ULL, 0x000fe200078e024dULL,
0x00005f0000277a11ULL, 0x000fe200010f3c27ULL, 0x000000013c007824ULL, 0x040fe200078e0249ULL,
0x0000003037517811ULL, 0x040fe200078ff0ffULL, 0x000000013c307824ULL, 0x040fe200078e024fULL,
0x0000003837557811ULL, 0x000fe200078ff0ffULL, 0x0000000449497824ULL, 0x000fe200078e00ffULL,
0x00005f0025257a11ULL, 0x000fe200008f3c28ULL, 0x000000013c327824ULL, 0x000fe200078e0251ULL,
0x0000003300297210ULL, 0x080fe20007fde0ffULL, 0x000000013c447824ULL, 0x000fe200078e0255ULL,
0x00000003ff287819ULL, 0x100fe20000011637ULL, 0x000000044d4d7824ULL, 0x000fe200078e00ffULL,
0x000000332c2b7210ULL, 0x080fe20007fbe0ffULL, 0x000000044f4f7824ULL, 0x000fe200078e00ffULL,
0x000010002a537811ULL, 0x000fe200078e60ffULL, 0x0000000451517824ULL, 0x000fe200078e00ffULL,
0x00000003282c7812ULL, 0x000fe200078e4837ULL, 0x0000000455557824ULL, 0x000fe200078e00ffULL,
0x000000332e2d7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200030e06ffULL,
0x00005e0029287a11ULL, 0x000fc400078c38ffULL, 0x00000033302f7210ULL, 0x080fe40007f3e0ffULL,
0x0000003332317210ULL, 0x080fe40007f5e0ffULL, 0x0000003344007210ULL, 0x000fe40007f7e0ffULL,
0xfffffffc47307812ULL, 0x100fe400078ee22cULL, 0xfffffffc49327812ULL, 0x100fe200078ee22cULL,
0x000000ffff337224ULL, 0x000fe200018e06ffULL, 0xfffffffc4b447812ULL, 0x100fe200078ee22cULL,
0x0000001030477824ULL, 0x100fe200078e0253ULL, 0xfffffffc4d487812ULL, 0x100fe200078ee22cULL,
0x0000001032497824ULL, 0x100fe200078e0253ULL, 0xfffffffc4f4a7812ULL, 0x100fe200078ee22cULL,
0x00000010444b7824ULL, 0x100fe200078e0253ULL, 0xfffffffc514c7812ULL, 0x100fe200078ee22cULL,
0x00000010484d7824ULL, 0x000fe200078e0253ULL, 0x0ffffffc2c2e7812ULL, 0x000fe200078ef837ULL,
0x000000104a4f7824ULL, 0x100fe200078e0253ULL, 0xfffffffc55507812ULL, 0x000fe200078ee22cULL,
0x000000ffff2c7224ULL, 0x000fe200028e06ffULL, 0x00005f0029297a11ULL, 0x000fe200030f3c2aULL,
0x000000ffff4a7224ULL, 0x000fe200020e06ffULL, 0x00005e002b2a7a11ULL, 0x040fe200078a38ffULL,
0x000000102e577824ULL, 0x000fe200078e0253ULL, 0xfffffffc52557812ULL, 0x000fe200078ee237ULL,
0x000000ffff487224ULL, 0x000fe200008e06ffULL, 0x00005f002b2b7a11ULL, 0x000fe200028f3c2cULL,
0x000000ffff447224ULL, 0x000fe200010e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe200078838ffULL,
0x0000001055247825ULL, 0x000fe200078e0024ULL, 0x00005e002f2e7a11ULL, 0x000fc400078238ffULL,
0x00005e0031307a11ULL, 0x000fe200078438ffULL, 0x0000001055267825ULL, 0x000fe200078e0026ULL,
0x00005e0000327a11ULL, 0x040fe200078638ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024577faeULL, 0x0003e2000b901c46ULL, 0x00005f002d2d7a11ULL, 0x000fe200020f3c4aULL,
0x0000001055287825ULL, 0x000fe200078e0028ULL, 0x00005f002f2f7a11ULL, 0x000fe200008f3c48ULL,
0x0000000026477faeULL, 0x0003e2000b901c46ULL, 0x00005f0031317a11ULL, 0x000fe200010f3c44ULL,
0x00000010552a7825ULL, 0x040fe200078e002aULL, 0x00005f0000337a11ULL, 0x000fe200018f3c33ULL,
0x0000000028497faeULL, 0x0003e4000b901c46ULL, 0x00000010552c7825ULL, 0x000fc400078e002cULL,
0x000000002a4b7faeULL, 0x0003e4000b901c46ULL, 0x00000010552e7825ULL, 0x040fe400078e002eULL,
0x000000002c4d7faeULL, 0x0003e4000b901c46ULL, 0x000000104c517824ULL, 0x000fe400078e0253ULL,
0x0000001055307825ULL, 0x040fe200078e0030ULL, 0x000000002e4f7faeULL, 0x0003e6000b901c46ULL,
0x0000001050537824ULL, 0x000fe200078e0253ULL, 0x0000000030517faeULL, 0x0003e2000b901c46ULL,
0x0000001055327825ULL, 0x000fca00078e0032ULL, 0x0000000032537faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5400720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x00000004ff257424ULL, 0x002fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000030025397a24ULL, 0x000fca00078e0239ULL, 0x000000343900720cULL, 0x000fda0003f26070ULL,
0x0000003000001947ULL, 0x000fea0003800000ULL, 0x000000023e247824ULL, 0x000fc800078e0239ULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x0000000624387981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000084e4c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff4a7224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff837007812ULL, 0x000fe200078ec0ffULL,
0x0000000202287824ULL, 0x002fe200078e0245ULL, 0x000000014a2a7810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000700007812ULL, 0x000fe400078ef837ULL,
0x0000100028287811ULL, 0x000fc400078e60ffULL, 0x00000001ff247819ULL, 0x000fe40000011600ULL,
0x0000000737d07812ULL, 0x000fe400078ec0ffULL, 0x0000000324257812ULL, 0x000fe400078ec0ffULL,
0x00000008d0d07812ULL, 0x000fe400078ef837ULL, 0x0000004a25277212ULL, 0x040fe400078e3cffULL,
0x0000002a25257212ULL, 0x000fc600078e3cffULL, 0x0000000400277824ULL, 0x040fe400078e0227ULL,
0x0000000400257824ULL, 0x000fe200078e0225ULL, 0x0000002037007810ULL, 0x000fe20007ffe0ffULL,
0x0000001027277824ULL, 0x100fe400078e0228ULL, 0x0000001025257824ULL, 0x000fe200078e0228ULL,
0xfffffff800007812ULL, 0x000fe400078ec0ffULL, 0x000000002730783bULL, 0x000e640000000200ULL,
0x0000000700297812ULL, 0x000fc400078ef837ULL, 0x00000000252c783bULL, 0x0004e40000000200ULL,
0x00000001ff007819ULL, 0x000fc80000011629ULL, 0x00000003002b7812ULL, 0x000fc800078ec0ffULL,
0x0000004a2b007212ULL, 0x040fe400078e3cffULL, 0x0000002a2b2a7212ULL, 0x000fe400078e3cffULL,
0x000000024a4a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000429257824ULL, 0x044fe400078e0200ULL,
0x0000000429297824ULL, 0x000fe400078e022aULL, 0x0000001025257824ULL, 0x100fe400078e0228ULL,
0x0000001029297824ULL, 0x000fc800078e0228ULL, 0x000000002524783bULL, 0x000ea80000000200ULL,
0x000000002928783bULL, 0x000f220000000200ULL, 0x0000003000757306ULL, 0x002fe20000009400ULL,
0x00000018ffac7819ULL, 0x000fe20000011430ULL, 0x0001000030617824ULL, 0x000fe200078e00ffULL,
0x00000018ffa47819ULL, 0x000fe20000011431ULL, 0x0000010032b07824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011433ULL, 0x0000010033ab7824ULL, 0x040fe200078e00ffULL,
0x00000018ffb57819ULL, 0x000fe20000011461ULL, 0x0000003000b47306ULL, 0x000e620000005400ULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x0001000033af7824ULL, 0x000fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011432ULL, 0x000100002c7c7824ULL, 0x048fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x000001002c817824ULL, 0x000fe200078e00ffULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x0000003000607306ULL, 0x000722000000d400ULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x000100002d7f7824ULL, 0x040fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x000001002e6e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe2000001142cULL, 0x000001002d827824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x000000b500b67306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x008fe200078e00ffULL, 0x000000b47500720bULL, 0x002fe20003f9d000ULL,
0x000100002e767824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe2000001142dULL,
0x0001000024c97824ULL, 0x004fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe20000011430ULL,
0x0001000031307824ULL, 0x000fe200078e00ffULL, 0x000000b500b77306ULL, 0x000e620000205400ULL,
0x00000018ff9d7819ULL, 0x000fc40000011424ULL, 0x00000018ff9a7819ULL, 0x000fe40000011425ULL,
0x00000018ffbd7819ULL, 0x000fe20000011430ULL, 0x0001000032307824ULL, 0x000fe200078e00ffULL,
0x0000000160604812ULL, 0x010fe200078efcffULL, 0x000000b800b97306ULL, 0x000fe20000209400ULL,
0x00000018ffc97819ULL, 0x000fe400000114c9ULL, 0x00000018ffc37819ULL, 0x000fe40000011430ULL,
0x00000018ff977819ULL, 0x000fc40000011426ULL, 0x00000018ff887819ULL, 0x000fe20000011427ULL,
0x000000b800ba7306ULL, 0x000ea20000205400ULL, 0x000000b7b600720bULL, 0x002fe20003f5d000ULL,
0x0000010025b67824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001142eULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x0000003100a87306ULL, 0x000fe20000009400ULL, 0x00000018ff827819ULL, 0x000fc40000011482ULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x00000018ff517819ULL, 0x000fc6000001142fULL,
0x0000003100a57306ULL, 0x000e620000005400ULL, 0x000000bab900720bULL, 0x004fce0003f7d000ULL,
0x00000031005f7306ULL, 0x0004f0000000d400ULL, 0x000000ac00bb7306ULL, 0x000fe20000209400ULL,
0x0000010031317824ULL, 0x004fe200078e00ffULL, 0x000000a5a800720bULL, 0x002fc40003f3d000ULL,
0x000000b800a87245ULL, 0x000fe2000020d400ULL, 0x0000010027b87824ULL, 0x000fe200078e00ffULL,
0x00000018ffc07819ULL, 0x000fe40000011431ULL, 0x000000ac00bc7306ULL, 0x000e620000205400ULL,
0x000000b500a57245ULL, 0x000fe4000020d400ULL, 0x00000001a8a83812ULL, 0x000fe400078efcffULL,
0x00000001a5a52812ULL, 0x000fe400078efcffULL, 0x000000015f5f1812ULL, 0x008fe200078efcffULL,
0x000000c000c17306ULL, 0x000fe20000209400ULL, 0x00000018ffb87819ULL, 0x000fce00000114b8ULL,
0x000000c000c27306ULL, 0x000ea20000205400ULL, 0x000000bcbb00720bULL, 0x002fce0003fdd000ULL,
0x0000003200a67306ULL, 0x000ff00000009400ULL, 0x0000003200a77306ULL, 0x000e620000005400ULL,
0x000000c2c100720bULL, 0x004fce0003f7d000ULL, 0x000000bd00be7306ULL, 0x000ff00000209400ULL,
0x000000bd00bf7306ULL, 0x000ea20000205400ULL, 0x000000a7a600720bULL, 0x002fe40003f5d000ULL,
0x000000ac00a77245ULL, 0x000fc4000020d400ULL, 0x000000bd00a67245ULL, 0x000fe4000020d400ULL,
0x00000001a7a76812ULL, 0x000fe200078efcffULL, 0x0000003300a27306ULL, 0x000ff00000009400ULL,
0x0000003300a37306ULL, 0x000e620000005400ULL, 0x000000bfbe00720bULL, 0x004fce0003fbd000ULL,
0x000000a400ae7306ULL, 0x000fec0000209400ULL, 0x00000001a6a65812ULL, 0x000fe400078efcffULL,
0x000000a400ad7306ULL, 0x000ea20000205400ULL, 0x000000a3a200720bULL, 0x002fe40003fdd000ULL,
0x000000c000a27245ULL, 0x000fc4000020d400ULL, 0x0000009400a37245ULL, 0x000fe4000020d400ULL,
0x00000001a2a23812ULL, 0x000fe200078efcffULL, 0x000000b000c67306ULL, 0x000ff00000209400ULL,
0x000000b000c77306ULL, 0x0002e20000205400ULL, 0x000000adae00720bULL, 0x004fe20003f9d000ULL,
0x0001000026ad7824ULL, 0x000fca00078e00ffULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x00000024008e7306ULL, 0x000fe20000009400ULL, 0x000000b000b07245ULL, 0x002fce000020d400ULL,
0x0000002400957306ULL, 0x000fe20000005400ULL, 0x000000c7c600720bULL, 0x008fce0003f7d000ULL,
0x0000002400577306ULL, 0x0003ec000000d400ULL, 0x00000001b0b03812ULL, 0x000fe400078efcffULL,
0x00000032005c7306ULL, 0x0004e2000000d400ULL, 0x0000010024247824ULL, 0x002fca00078e00ffULL,
0x00000018ffcc7819ULL, 0x000fe20000011424ULL, 0x0001000025247824ULL, 0x000fe200078e00ffULL,
0x0000008900967306ULL, 0x000fe20000209400ULL, 0x000001002f327824ULL, 0x004fc600078e00ffULL,
0x00000018ffcf7819ULL, 0x000fe40000011424ULL, 0x0000004c37247211ULL, 0x000fe400078fe0ffULL,
0x0000008900937306ULL, 0x000e620000205400ULL, 0x000000015c5c2812ULL, 0x008fe400078efcffULL,
0x0000000224757810ULL, 0x040fe40007ffe0ffULL, 0x0000000724247812ULL, 0x000fe400078e78d0ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000002c009e7306ULL, 0x000fe20000009400ULL,
0x0000000775757812ULL, 0x000fe200078e78d0ULL, 0x00000010d0247824ULL, 0x000fe200078e0224ULL,
0x000000044c4c7810ULL, 0x000fc60007ffe0ffULL, 0x0000001024247824ULL, 0x000fe400078e00ffULL,
0x0000002c009f7306ULL, 0x000ea20000005400ULL, 0x000000939600720bULL, 0x002fe20003f5d000ULL,
0x00000010d0757824ULL, 0x000fe200078e0275ULL, 0x0000009d00967245ULL, 0x000fe4000020d400ULL,
0x000000cc00937245ULL, 0x000fc6000020d400ULL, 0x000000c300c47306ULL, 0x000ff00000209400ULL,
0x000000c300c57306ULL, 0x000e620000205400ULL, 0x0000009f9e00720bULL, 0x004fe40003f3d000ULL,
0x000000a4009f7245ULL, 0x000fc8000020d400ULL, 0x000000019f9f4812ULL, 0x000fe200078efcffULL,
0x0000009400a07306ULL, 0x000fe60000209400ULL, 0x000000a29f9f723eULL, 0x000fca00000010ffULL,
0x0000009400a17306ULL, 0x0004e20000205400ULL, 0x000000c5c400720bULL, 0x002fce0003fbd000ULL,
0x000000ab00b27306ULL, 0x000fe20000209400ULL, 0x0000008900947245ULL, 0x004fe4000020d400ULL,
0x000000cf00897245ULL, 0x000fe4000020d400ULL, 0x0000000194942812ULL, 0x000fc600078efcffULL,
0x000000ab00b17306ULL, 0x0002a20000205400ULL, 0x000000a1a000720bULL, 0x008fe20003f9d000ULL,
0x0001000027a07824ULL, 0x000fe200078e00ffULL, 0x000000c300a17245ULL, 0x000fc8000020d400ULL,
0x00000001a1a15812ULL, 0x000fe200078efcffULL, 0x00000025008f7306ULL, 0x000fe20000009400ULL,
0x000000ab00ab7245ULL, 0x002fe4000020d400ULL, 0x00000018ffa07819ULL, 0x000fc600000114a0ULL,
0x00000001a3a34812ULL, 0x000fe400078efcffULL, 0x00000025008a7306ULL, 0x000fe20000005400ULL,
0x000000b1b200720bULL, 0x004fce0003f7d000ULL, 0x0000002500567306ULL, 0x000fec000000d400ULL,
0x00000001abab3812ULL, 0x000fe400078efcffULL, 0x000000cf00b47306ULL, 0x000fe40000209400ULL,
0x000000ab94ab723eULL, 0x000fcc00000010ffULL, 0x000000cf00257306ULL, 0x000e700000205400ULL,
0x000000af00b37306ULL, 0x000ff00000209400ULL, 0x000000af00c87306ULL, 0x0004e20000205400ULL,
0x00000025b400720bULL, 0x002fce0003f5d000ULL, 0x0000003300587306ULL, 0x000322000000d400ULL,
0x000000af00af7245ULL, 0x004fca000020d400ULL, 0x0000000189892812ULL, 0x000fe400078efcffULL,
0x0000009d00aa7306ULL, 0x000fe20000209400ULL, 0x000000c8b300720bULL, 0x008fe20003fbd000ULL,
0x000100002f337824ULL, 0x002fca00078e00ffULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0000009d00a97306ULL, 0x000e620000205400ULL, 0x0000000158586812ULL, 0x010fca00078efcffULL,
0x00000001afaf5812ULL, 0x000fe400078efcffULL, 0x000000c900ca7306ULL, 0x000fe20000209400ULL,
0x000000958e00720bULL, 0x000fe40003fbd000ULL, 0x000000c9008e7245ULL, 0x000fe4000020d400ULL,
0x0000009a00957245ULL, 0x000fc6000020d400ULL, 0x000000c900cb7306ULL, 0x000ea20000205400ULL,
0x000000a9aa00720bULL, 0x002fe40003fdd000ULL, 0x00000058afaa723eULL, 0x000fe400000010ffULL,
0x0000003300587245ULL, 0x000fe4000020d400ULL, 0x0000000157575812ULL, 0x000fe200078efcffULL,
0x000000cc00cd7306ULL, 0x000fec0000209400ULL, 0x0000000196966812ULL, 0x000fc400078efcffULL,
0x000000cc00ce7306ULL, 0x000e620000205400ULL, 0x000000cbca00720bULL, 0x004fce0003f9d000ULL,
0x000000ad00ae7306ULL, 0x000fec0000209400ULL, 0x000000018e8e4812ULL, 0x000fe400078efcffULL,
0x000000ad00b77306ULL, 0x000ea20000205400ULL, 0x000000cecd00720bULL, 0x002fe40003f7d000ULL,
0x0000008a8f00720bULL, 0x000fc40003f9d000ULL, 0x000000ad008f7245ULL, 0x000fe4000020d400ULL,
0x000000b6008a7245ULL, 0x000fe2000020d400ULL, 0x0000009a009b7306ULL, 0x000fec0000209400ULL,
0x0000000193933812ULL, 0x000fe400078efcffULL, 0x0000009a009c7306ULL, 0x000e620000205400ULL,
0x000000b7ae00720bULL, 0x004fc40003f5d000ULL, 0x0000000156564812ULL, 0x000fe400078efcffULL,
0x000000939693723eULL, 0x000fe400000010ffULL, 0x000000568956723eULL, 0x000fe200000010ffULL,
0x0000002600867306ULL, 0x000fec0000009400ULL, 0x000000018f8f2812ULL, 0x000fc400078efcffULL,
0x0000002600877306ULL, 0x000ea20000005400ULL, 0x0000009c9b00720bULL, 0x002fce0003fdd000ULL,
0x0000002600507306ULL, 0x0002ec000000d400ULL, 0x0000000195956812ULL, 0x000fe400078efcffULL,
0x00000027007a7306ULL, 0x000fe20000009400ULL, 0x0000010026267824ULL, 0x002fe200078e00ffULL,
0x000000878600720bULL, 0x004fc40003f7d000ULL, 0x00000018ff867819ULL, 0x000fe4000001142aULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000027007b7306ULL, 0x000e6e0000005400ULL,
0x0000000150503812ULL, 0x008fe200078efcffULL, 0x00000027004f7306ULL, 0x000ea6000000d400ULL,
0x000000508f50723eULL, 0x000fca00000010ffULL, 0x0000002600277306ULL, 0x000fe20000209400ULL,
0x0000007b7a00720bULL, 0x002fe40003f5d000ULL, 0x00000026007b7245ULL, 0x000fca000020d400ULL,
0x00000026009e7306ULL, 0x000e6c0000205400ULL, 0x000000014f4f2812ULL, 0x004fe400078efcffULL,
0x000000a000a47306ULL, 0x000ff00000209400ULL, 0x000000a000257306ULL, 0x0004e20000205400ULL,
0x0000009e2700720bULL, 0x002fc40003f9d000ULL, 0x0000005fa69e723eULL, 0x000fe400000010ffULL,
0x00000076005f7245ULL, 0x000fc6000020d400ULL, 0x000000b8009d7306ULL, 0x000fe20000209400ULL,
0x000000a000a07245ULL, 0x004fca000020d400ULL, 0x000000017b7b4812ULL, 0x000fe400078efcffULL,
0x000000b8009c7306ULL, 0x0002a20000205400ULL, 0x00000025a400720bULL, 0x008fe40003fdd000ULL,
0x000000002424783bULL, 0x000eea0000000200ULL, 0x0000007c008d7306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x002fca000020d400ULL, 0x00000001a0a06812ULL, 0x000fe400078efcffULL,
0x0000007c00907306ULL, 0x000e620000205400ULL, 0x0000009c9d00720bULL, 0x004fe40003f7d000ULL,
0x0000004fa0a0723eULL, 0x000fca00000010ffULL, 0x0000008800917306ULL, 0x000fec0000209400ULL,
0x00000001b8b83812ULL, 0x000fe400078efcffULL, 0x0000008800927306ULL, 0x000ea20000205400ULL,
0x000000908d00720bULL, 0x002fce0003f5d000ULL, 0x00000081008c7306ULL, 0x000fe20000209400ULL,
0x0000009e241c723cULL, 0x048fee000004181cULL, 0x00000081008b7306ULL, 0x0002e20000205400ULL,
0x000000929100720bULL, 0x004fe40003fdd000ULL, 0x000000578e92723eULL, 0x000fe200000010ffULL,
0x000000aa2414723cULL, 0x000fe80000041814ULL, 0x0000006700687306ULL, 0x000fe20000209400ULL,
0x0000008100817245ULL, 0x002fc6000020d400ULL, 0x000000922410723cULL, 0x000fe80000041810ULL,
0x00000067006b7306ULL, 0x000e620000205400ULL, 0x0000008b8c00720bULL, 0x008fe20003f7d000ULL,
0x00010000288c7824ULL, 0x000fe200078e00ffULL, 0x0000007c008b7245ULL, 0x000fe2000020d400ULL,
0x00010000297c7824ULL, 0x000fc600078e00ffULL, 0x000000018b8b2812ULL, 0x000fe200078efcffULL,
0x0000002d00747306ULL, 0x000fe20000009400ULL, 0x00000018ff8c7819ULL, 0x000fe4000001148cULL,
0x00000018ff7c7819ULL, 0x000fc6000001147cULL, 0x0000000181813812ULL, 0x000fe400078efcffULL,
0x0000002d00777306ULL, 0x000ea20000005400ULL, 0x0000006b6800720bULL, 0x002fce0003f5d000ULL,
0x0000002c004e7306ULL, 0x0002f0000000d400ULL, 0x000000b600b57306ULL, 0x000fe20000209400ULL,
0x000000777400720bULL, 0x004fe40003f9d000ULL, 0x0000008800777245ULL, 0x000fe2000020d400ULL,
0x000001002b887824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x002fc40000011428ULL,
0x0000000177776812ULL, 0x000fe200078efcffULL, 0x000000b600ac7306ULL, 0x000e620000205400ULL,
0x000000014e4e1812ULL, 0x008fe400078efcffULL, 0x00000018ff747819ULL, 0x000fe4000001142bULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x0000004e8b4e723eULL, 0x000fe200000010ffULL,
0x0000007f00807306ULL, 0x000ff00000209400ULL, 0x0000007f00837306ULL, 0x0004e20000205400ULL,
0x000000acb500720bULL, 0x002fce0003fbd000ULL, 0x0000002f00637306ULL, 0x000fe20000009400ULL,
0x0000007f007f7245ULL, 0x004fca000020d400ULL, 0x000000018a8a5812ULL, 0x000fe400078efcffULL,
0x0000002f00647306ULL, 0x000e620000005400ULL, 0x000000838000720bULL, 0x008fe20003f3d000ULL,
0x0000010029807824ULL, 0x000fe200078e00ffULL, 0x0000008a9557723eULL, 0x000fe200000010ffULL,
0x000100002a837824ULL, 0x000fc600078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x0000006500697306ULL, 0x000fe20000209400ULL, 0x00000018ff837819ULL, 0x000fe20000011483ULL,
0x00000056240c723cULL, 0x000fe8000004180cULL, 0x000000017f7f1812ULL, 0x000fe400078efcffULL,
0x0000006500667306ULL, 0x0004e20000205400ULL, 0x000000646300720bULL, 0x002fc40003fdd000ULL,
0x0000006700647245ULL, 0x000fc8000020d400ULL, 0x0000000164642812ULL, 0x000fe200078efcffULL,
0x0000009700997306ULL, 0x000fe20000209400ULL, 0x0000006500657245ULL, 0x004fe4000020d400ULL,
0x00000081644f723eULL, 0x000fca00000010ffULL, 0x0000009700987306ULL, 0x000e620000205400ULL,
0x000000666900720bULL, 0x008fce0003f5d000ULL, 0x0000005b006d7306ULL, 0x000fec0000209400ULL,
0x0000000165652812ULL, 0x000fe400078efcffULL, 0x0000005b006a7306ULL, 0x0004e20000205400ULL,
0x000000989900720bULL, 0x002fe40003fbd000ULL, 0x0000009700987245ULL, 0x000fca000020d400ULL,
0x00000028005e7306ULL, 0x000fe20000009400ULL, 0x0000005b005b7245ULL, 0x004fca000020d400ULL,
0x0000000198985812ULL, 0x000fe400078efcffULL, 0x00000028005d7306ULL, 0x000fe20000005400ULL,
0x0000006a6d00720bULL, 0x008fce0003f3d000ULL, 0x00000028004d7306ULL, 0x0003ec000000d400ULL,
0x000000015b5b1812ULL, 0x000fe400078efcffULL, 0x0000002d00447306ULL, 0x0004e2000000d400ULL,
0x0000010028287824ULL, 0x002fca00078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011428ULL,
0x00000029005a7306ULL, 0x000fe20000009400ULL, 0x00000018ff2d7819ULL, 0x004fe40000011429ULL,
0x00000060a528723eULL, 0x000fe400000010ffULL, 0x0000006b008d7245ULL, 0x000fc6000020d400ULL,
0x0000002900597306ULL, 0x000fe20000005400ULL, 0x0000000144444812ULL, 0x008fce00078efcffULL,
0x00000029004b7306ULL, 0x0003f0000000d400ULL, 0x0000006e00787306ULL, 0x000fe20000209400ULL,
0x000000a8a729723eULL, 0x002fce00000010ffULL, 0x0000006e00797306ULL, 0x0002a20000205400ULL,
0x000000282420723cULL, 0x000fee0000041820ULL, 0x0000008200847306ULL, 0x000fe20000209400ULL,
0x0000005ca128723eULL, 0x000fe400000010ffULL, 0x000000b0a329723eULL, 0x000fc400000010ffULL,
0x0000006e006e7245ULL, 0x002fe4000020d400ULL, 0x000000b877a1723eULL, 0x000fe200000010ffULL,
0x0000008200857306ULL, 0x0002e20000205400ULL, 0x000000797800720bULL, 0x004fe20003f5d000ULL,
0x000000282418723cULL, 0x040fec0000041818ULL, 0x0000002e00737306ULL, 0x000fe20000009400ULL,
0x0000001075287824ULL, 0x000fe200078e00ffULL, 0x0000008200827245ULL, 0x002fe2000020d400ULL,
0x000000a02404723cULL, 0x000fe60000041804ULL, 0x000000016e6e2812ULL, 0x000fc400078efcffULL,
0x0000002e00727306ULL, 0x000e620000005400ULL, 0x000000858400720bULL, 0x008fe20003f7d000ULL,
0x000001002a847824ULL, 0x000fe200078e00ffULL, 0x000000595a00720bULL, 0x000fe20003f5d000ULL,
0x000100002b857824ULL, 0x000fe200078e00ffULL, 0x0000003200597245ULL, 0x000fe4000020d400ULL,
0x00000018ff847819ULL, 0x000fe20000011484ULL, 0x0000003200617306ULL, 0x000fe20000209400ULL,
0x00000018ff857819ULL, 0x000fca0000011485ULL, 0x0000000182823812ULL, 0x000fe400078efcffULL,
0x0000003200627306ULL, 0x0004e20000205400ULL, 0x000000727300720bULL, 0x002fe40003fbd000ULL,
0x000000014b4b2812ULL, 0x000fca00078efcffULL, 0x00000076007d7306ULL, 0x000fe20000209400ULL,
0x0000005100327245ULL, 0x004fce000020d400ULL, 0x00000076007e7306ULL, 0x000e620000205400ULL,
0x000000626100720bULL, 0x008fce0003f3d000ULL, 0x0000002e00007306ULL, 0x000eac000000d400ULL,
0x0000000159591812ULL, 0x000fe400078efcffULL, 0x00000051006c7306ULL, 0x000fe20000209400ULL,
0x0000007e7d00720bULL, 0x002fe40003f7d000ULL, 0x00000080007d7245ULL, 0x000fca000020d400ULL,
0x00000051006f7306ULL, 0x0002e20000205400ULL, 0x0000000100005812ULL, 0x004fca00078efcffULL,
0x000000015f5f3812ULL, 0x000fe400078efcffULL, 0x0000003300707306ULL, 0x000fe20000209400ULL,
0x0000005d5e00720bULL, 0x000fe40003f7d000ULL, 0x0000007b9851723eULL, 0x002fca00000010ffULL,
0x0000003300717306ULL, 0x000e620000205400ULL, 0x0000006f6c00720bULL, 0x008fe20003f9d000ULL,
0x000000502408723cULL, 0x000fe80000041808ULL, 0x000000014d4d3812ULL, 0x000fe400078efcffULL,
0x0000008c00637306ULL, 0x000fe20000209400ULL, 0x000000447f24723eULL, 0x000fe400000010ffULL,
0x000000826525723eULL, 0x000fc400000010ffULL, 0x000000005f26723eULL, 0x000fe400000010ffULL,
0x0000000132324812ULL, 0x000fe200078efcffULL, 0x0000008c00687306ULL, 0x0004e20000205400ULL,
0x000000717000720bULL, 0x002fe40003fbd000ULL, 0x0000002d00007245ULL, 0x000fe4000020d400ULL,
0x0000006e5b27723eULL, 0x000fe400000010ffULL, 0x000000593259723eULL, 0x000fe200000010ffULL,
0x0000002a00537306ULL, 0x000fe20000009400ULL, 0x0000008c008c7245ULL, 0x004fca000020d400ULL,
0x0000000158585812ULL, 0x000fe400078efcffULL, 0x0000002a00527306ULL, 0x000e620000005400ULL,
0x000000686300720bULL, 0x008fce0003f3d000ULL, 0x0000002a00487306ULL, 0x000eac000000d400ULL,
0x000000018c8c1812ULL, 0x000fe400078efcffULL, 0x0000002b00557306ULL, 0x000fe20000009400ULL,
0x000000525300720bULL, 0x002fe40003fbd000ULL, 0x0000004d8c8c723eULL, 0x000fca00000010ffULL,
0x0000002b00547306ULL, 0x000fec0000005400ULL, 0x0000000148485812ULL, 0x004fe400078efcffULL,
0x0000002b00497306ULL, 0x0003f0000000d400ULL, 0x0000006b00677306ULL, 0x000fe20000209400ULL,
0x000000002828783bULL, 0x002e6e0000000200ULL, 0x0000006b00667306ULL, 0x000eb00000205400ULL,
0x0000002c00307306ULL, 0x000ff00000209400ULL, 0x0000002c00317306ULL, 0x0007220000205400ULL,
0x000000666700720bULL, 0x004fce0003f9d000ULL, 0x0000002f00477306ULL, 0x000ea2000000d400ULL,
0x0000002c002c7245ULL, 0x008fca000020d400ULL, 0x000000018d8d4812ULL, 0x000fe400078efcffULL,
0x0000002d002e7306ULL, 0x000fe20000209400ULL, 0x000000313000720bULL, 0x010fe20003f3d000ULL,
0x00000024281c723cULL, 0x042fec000004181cULL, 0x0000002d002f7306ULL, 0x000e620000205400ULL,
0x0000000147476812ULL, 0x004fe200078efcffULL, 0x000000262818723cULL, 0x000fe20000041818ULL,
0x000000545500720bULL, 0x000fc40003fdd000ULL, 0x000000475858723eULL, 0x000fe400000010ffULL,
0x000000012c2c1812ULL, 0x000fe200078efcffULL, 0x00000080005c7306ULL, 0x000fe20000209400ULL,
0x0000008800277245ULL, 0x000fe2000020d400ULL, 0x0000004e2820723cULL, 0x000fe20000041820ULL,
0x0000008d2c8d723eULL, 0x000fca00000010ffULL, 0x00000080005d7306ULL, 0x000ea20000205400ULL,
0x0000002f2e00720bULL, 0x002fe20003f9d000ULL, 0x000000582814723cULL, 0x000fe20000041814ULL,
0x0000000149496812ULL, 0x000fca00078efcffULL, 0x0000007c00607306ULL, 0x000fe40000209400ULL,
0x0000008c2810723cULL, 0x000fe80000041810ULL, 0x0000000100004812ULL, 0x000fe400078efcffULL,
0x0000007c00697306ULL, 0x0002e20000205400ULL, 0x0000005d5c00720bULL, 0x004fce0003f3d000ULL,
0x0000008300337306ULL, 0x000fe20000209400ULL, 0x0000007c007c7245ULL, 0x002fca000020d400ULL,
0x000000017d7d1812ULL, 0x000fe400078efcffULL, 0x0000008300527306ULL, 0x0002a20000205400ULL,
0x000000696000720bULL, 0x008fe40003f7d000ULL, 0x0000007d007d723eULL, 0x000fe400000010ffULL,
0x0000008500007245ULL, 0x000fc6000020d400ULL, 0x0000007400727306ULL, 0x000fe20000209400ULL,
0x0000008300837245ULL, 0x002fca000020d400ULL, 0x000000017c7c3812ULL, 0x000fe400078efcffULL,
0x0000007400737306ULL, 0x0002e20000205400ULL, 0x000000523300720bULL, 0x004fe40003f5d000ULL,
0x0000004b7c7c723eULL, 0x000fca00000010ffULL, 0x0000008600877306ULL, 0x000fe20000209400ULL,
0x0000007400747245ULL, 0x002fe2000020d400ULL, 0x0000007c280c723cULL, 0x000fe8000004180cULL,
0x0000000183832812ULL, 0x000fe400078efcffULL, 0x00000086007a7306ULL, 0x0002a20000205400ULL,
0x000000737200720bULL, 0x008fe40003f3d000ULL, 0x000000488324723eULL, 0x000fca00000010ffULL,
0x0000008400537306ULL, 0x000fe20000209400ULL, 0x0000008600867245ULL, 0x002fca000020d400ULL,
0x0000000174741812ULL, 0x000fe400078efcffULL, 0x0000008400547306ULL, 0x000e620000205400ULL,
0x0000007a8700720bULL, 0x004fe40003f7d000ULL, 0x000000044a00780cULL, 0x000fca0003f25270ULL,
0x0000008500307306ULL, 0x000fec0000209400ULL, 0x0000000186863812ULL, 0x000fe400078efcffULL,
0x00000085002f7306ULL, 0x000ea20000205400ULL, 0x000000545300720bULL, 0x002fce0003f9d000ULL,
0x00000088002e7306ULL, 0x000ff00000209400ULL, 0x0000008800257306ULL, 0x000e620000205400ULL,
0x0000002f3000720bULL, 0x004fda0003f5d000ULL, 0x0000000100002812ULL, 0x000fe400078efcffULL,
0x000000252e00720bULL, 0x002fe40003fbd000ULL, 0x0000008400257245ULL, 0x000fe4000020d400ULL,
0x000000490026723eULL, 0x000fe400000010ffULL, 0x0000000125254812ULL, 0x000fc800078efcffULL,
0x000000258625723eULL, 0x000fc600000010ffULL, 0x0000000127275812ULL, 0x000fc800078efcffULL,
0x000000277427723eULL, 0x000fe200000010ffULL, 0x000000242808723cULL, 0x040ff00000041808ULL,
0x000000262804723cULL, 0x000fe20000041804ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe12000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff457224ULL, 0x000fe200078e0043ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd25000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000003f247f8cULL, 0x000fe2000c80043fULL,
0x0000001d3d1d7220ULL, 0x040fe20000410000ULL, 0x0000001a3d267220ULL, 0x040fe20000410000ULL,
0x000000153d157220ULL, 0x040fe20000410000ULL, 0x000004003f277984ULL, 0x000e620000000800ULL,
0x0000001e3d1e7220ULL, 0x040fe20000410000ULL, 0x0000000d3d1a7220ULL, 0x040fe20000410000ULL,
0x000000203d207220ULL, 0x040fe20000410000ULL, 0x000000213d217220ULL, 0x040fe20000410000ULL,
0x000000223d227220ULL, 0x040fe20000410000ULL, 0x0000001f3d1f7220ULL, 0x040fe20000410000ULL,
0x000000143d147220ULL, 0x040fe20000410000ULL, 0x000000163d297220ULL, 0x040fe20000410000ULL,
0x000000173d2a7220ULL, 0x040fe20000410000ULL, 0x000000233d237220ULL, 0x040fe20000410000ULL,
0x000000183d187220ULL, 0x040fe20000410000ULL, 0x000000193d197220ULL, 0x040fe20000410000ULL,
0x0000001b3d287220ULL, 0x040fe20000410000ULL, 0x000000113d167220ULL, 0x040fe20000410000ULL,
0x0000000c3d177220ULL, 0x040fe20000410000ULL, 0x0000001c3d1c7220ULL, 0x040fe20000410000ULL,
0x000000103d007220ULL, 0x040fe20000410000ULL, 0x000000123d2b7220ULL, 0x040fe20000410000ULL,
0x000000133d2c7220ULL, 0x040fe20000410000ULL, 0x0000000e3d2d7220ULL, 0x040fe20000410000ULL,
0x0000000f3d2e7220ULL, 0x040fe20000410000ULL, 0x000000083d087220ULL, 0x040fe20000410000ULL,
0x000000093d097220ULL, 0x040fe20000410000ULL, 0x0000000a3d2f7220ULL, 0x040fe20000410000ULL,
0x0000000b3d307220ULL, 0x040fe20000410000ULL, 0x000000043d047220ULL, 0x040fe20000410000ULL,
0x000000053d057220ULL, 0x040fe20000410000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e001dULL,
0x000000063d067220ULL, 0x040fe20000410000ULL, 0x000000ffff117224ULL, 0x000fe200078e0015ULL,
0x000000073d077220ULL, 0x000fe20000410000ULL, 0x000000ffff157224ULL, 0x000fc400078e001aULL,
0x000000ffff1d7224ULL, 0x000fe400078e001eULL, 0x000000ffff0b7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0021ULL, 0x000000ffff107224ULL, 0x000fe200078e0014ULL,
0x8000000027ff7812ULL, 0x002fe20007804825ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0022ULL,
0x000000ffff1e7224ULL, 0x000fc400078e001fULL, 0x000000ffff0e7224ULL, 0x000fe400078e0018ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0019ULL, 0x000000ffff137224ULL, 0x000fe400078e0016ULL,
0x000000ffff147224ULL, 0x000fe400078e0017ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0023ULL,
0x000000ffff1f7224ULL, 0x000fc400078e0026ULL, 0x000000ffff207224ULL, 0x000fe400078e0028ULL,
0x000000ffff217224ULL, 0x000fe400078e0029ULL, 0x000000ffff227224ULL, 0x000fe400078e002aULL,
0x000000ffff0c7224ULL, 0x000fe400078e001cULL, 0x000000ffff127224ULL, 0x000fe400078e0000ULL,
0x000000ffff167224ULL, 0x000fc400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e0009ULL,
0x000000ffff187224ULL, 0x000fe400078e0004ULL, 0x000000ffff197224ULL, 0x000fe400078e0005ULL,
0x000000ffff237224ULL, 0x000fe400078e002bULL, 0x000000ffff267224ULL, 0x000fe400078e002cULL,
0x000000ffff277224ULL, 0x000fc400078e002dULL, 0x000000ffff287224ULL, 0x000fe400078e002eULL,
0x000000ffff297224ULL, 0x000fe400078e002fULL, 0x000000ffff2a7224ULL, 0x000fe200078e0030ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0006ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0007ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x000004003f057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004371c7824ULL, 0x000fe200078e00ffULL, 0x000000403500720cULL, 0x000fc80003f05270ULL,
0xfffffff01c057812ULL, 0x000fca00078ec0ffULL, 0x0000008002007824ULL, 0x000fca00078e0205ULL,
0x00f4000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000237087824ULL, 0x000fe400078e00ffULL, 0x0000000103427824ULL, 0x000fc600078e0a42ULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x0000000109257812ULL, 0x040fe400078efcffULL,
0x00000008092d7812ULL, 0x000fe400078efcffULL, 0x000000422500720cULL, 0x080fe40003f26070ULL,
0x0000001009257812ULL, 0x000fe400078efcffULL, 0x000000422d00720cULL, 0x080fe40003f06070ULL,
0x000000422500720cULL, 0x000fc40003fc6070ULL, 0x00000011092d7812ULL, 0x040fe400078efcffULL,
0x0000001809257812ULL, 0x040fe400078efcffULL, 0x000000420900720cULL, 0x080fe40003f46070ULL,
0x000000422d00720cULL, 0x080fe40003fa6070ULL, 0x000000422500720cULL, 0x000fe40003f66070ULL,
0x00000009092f7812ULL, 0x000fc400078efcffULL, 0x00000019092d7812ULL, 0x040fe400078efcffULL,
0x0000002009257812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x000000422f00720cULL, 0x080fe40003f86070ULL,
0x000000422d00720cULL, 0x080fe40003f46070ULL, 0x000000422500720cULL, 0x000fe40003f26070ULL,
0x00000021092d7812ULL, 0x040fe400078efcffULL, 0x0000002809257812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x000000422d00720cULL, 0x080fe40003f06070ULL, 0x000000422500720cULL, 0x000fe40003f86070ULL,
0x00000029092d7812ULL, 0x000fc400078efcffULL, 0x0000003009257812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x000000422d00720cULL, 0x000fc40003fc6070ULL, 0x000000422500720cULL, 0x000fe40003fa6070ULL,
0x00000031092d7812ULL, 0x040fe400078efcffULL, 0x0000003809257812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x000000422d00720cULL, 0x080fe40003f66070ULL,
0x000000422500720cULL, 0x000fc40003f46070ULL, 0x000000420900720cULL, 0x000fe40003f26070ULL,
0xff7fffff26267808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff27277808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff28287808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff29297808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff2b2b7808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff2c2c7808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0x0000000b04097209ULL, 0x004fe20007810000ULL, 0x0000001fff317424ULL, 0x000fe200078e00ffULL,
0x0000001a05047209ULL, 0x000fe20007810000ULL, 0xffffffffff327424ULL, 0x000fe200078e00ffULL,
0x0000000a09097209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fc40007810000ULL,
0x0000000c09087209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000000d08097209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000000e09087209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fc40007810000ULL,
0x0000000f08097209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000001009087209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fc40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x0000002304057209ULL, 0x000fe40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x0000002605047209ULL, 0x000fe40007810000ULL,
0x0000001409087209ULL, 0x000fe40007810000ULL, 0x0000002704057209ULL, 0x000fc40007810000ULL,
0x0000001508097209ULL, 0x000fe40007810000ULL, 0x0000002805047209ULL, 0x000fe40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x0000002904057209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x0000002a05047209ULL, 0x000fc40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x0000002b04057209ULL, 0x000fe40007810000ULL,
0x00000019082d7209ULL, 0x000fe40007810000ULL, 0x0000002c052f7209ULL, 0x000fe20007810000ULL,
0x000017c27f007947ULL, 0x000fea000b800000ULL, 0x0c401f002d047f89ULL, 0x0004e400000e0000ULL,
0x000000042d2d7209ULL, 0x00cfe20007810000ULL, 0x000017f27f007947ULL, 0x000fea000b800000ULL,
0x0c401f002f047f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006057f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007247f89ULL, 0x000f2200000e0000ULL, 0x000000042f087209ULL, 0x004fc60007810000ULL,
0x0c201f002d047f89ULL, 0x000ea200000e0000ULL, 0x0000000506097209ULL, 0x008fc60007810000ULL,
0x0c201f0008057f89ULL, 0x000ee200000e0000ULL, 0x0000002407247209ULL, 0x010fc60007810000ULL,
0x0c201f00092e7f89ULL, 0x002e6800000e0000ULL, 0x0c201f0024257f89ULL, 0x00092200000e0000ULL,
0x000000042d047209ULL, 0x004fe40007810000ULL, 0x0000000508057209ULL, 0x008fe40007810000ULL,
0x0000002e09067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fc40000000000ULL, 0x00000004ff2e7e24ULL, 0x002fe2000f8e00ffULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x3f8000002e2e783eULL, 0x000fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL,
0x000000ffff2f7224ULL, 0x000fe200078e002eULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010819ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b2c197823ULL, 0x000fe20000010819ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x000000080908723eULL, 0x002fce00000010ffULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x008fce00000010ffULL, 0x0000001d000b7308ULL, 0x0007f00000000800ULL,
0x0000001e001e7308ULL, 0x000f220000000800ULL, 0x0000001a1b09723eULL, 0x002fe200000010ffULL,
0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000b1e0b723eULL, 0x010fce00000010ffULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000002e0830723cULL, 0x000fee00000418ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ee20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000010ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x008fce00000010ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x0000001f200d723eULL, 0x002fce00000010ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x00000021220f723eULL, 0x008fce00000010ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x0000002e0c30723cULL, 0x000fee0000041830ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ee20000000800ULL,
0x000000121310723eULL, 0x002fce00000010ffULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x000000141512723eULL, 0x008fe400000010ffULL,
0xfffffffc37147812ULL, 0x000fc800078ec0ffULL, 0x000000141d1d7219ULL, 0x000fe200000006ffULL,
0x0000002700277308ULL, 0x000fe60000000800ULL, 0x000000001d1e73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f280000004000ULL, 0x0000002800287308ULL, 0x000ea20000000800ULL,
0x000000232611723eULL, 0x002fce00000010ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000272813723eULL, 0x004fce00000010ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000051dff7c12ULL, 0x008fe2000f80401eULL, 0x0000002e1030723cULL, 0x000fec0000041830ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000010ffULL, 0x0000002900297308ULL, 0x000ff00000000800ULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x000000180716723eULL, 0x004fe400000010ffULL,
0x0000002425077209ULL, 0x000fca0007810000ULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x00000019001a7308ULL, 0x000ea20000000800ULL, 0x000000292a15723eULL, 0x002fe400000010ffULL,
0x0000002b1a17723eULL, 0x004fce00000010ffULL, 0x0000002e1430723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000130204008947ULL, 0x010fde000b800000ULL,
0x001c1fff30187589ULL, 0x0002a400000e0000ULL, 0x000000001d1a73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000051dff7c12ULL, 0x008fda000f80401aULL, 0x0000132204008947ULL, 0x010fea000b800000ULL,
0x001c1fff32197589ULL, 0x00072800000e0000ULL, 0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL,
0x001c1fff001b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011637ULL,
0x0000000c1c337812ULL, 0x000fc400078ec0ffULL, 0x000000071d1e7812ULL, 0x040fe200078ec0ffULL,
0x000000081d237824ULL, 0x040fe200078e00ffULL, 0x0000001dff217212ULL, 0x000fe200078e33ffULL,
0x000000081d1f7824ULL, 0x000fe200078e00ffULL, 0x0000000337ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081d2e7824ULL, 0x040fe200078e00ffULL, 0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823207812ULL, 0x100fe400078ee21eULL, 0x000000011f227812ULL, 0x100fe200078ef61eULL,
0x000000081d4c7824ULL, 0x000fe200078e00ffULL, 0x000000021f247812ULL, 0x100fe200078ef61eULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0x000000031f267812ULL, 0x000fc400078ef61eULL,
0x000000041f287812ULL, 0x140fe400078ef61eULL, 0x000000051f2a7812ULL, 0x140fe400078ef61eULL,
0x000000061f2c7812ULL, 0x000fe200078ef61eULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee221ULL, 0x0000001dff217212ULL, 0x000fe400078e33ffULL,
0x000000071d1e7812ULL, 0x000fc400078ec0ffULL, 0x00009000021d7811ULL, 0x000fe400078e58ffULL,
0xfffffff823307812ULL, 0x100fe400078ee21eULL, 0x000000011f327812ULL, 0x140fe200078ef61eULL,
0x00000010201c7824ULL, 0x000fe200078e021dULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee221ULL,
0x0000001024207824ULL, 0x100fe200078e021dULL, 0x000000021f427812ULL, 0x140fe200078ef61eULL,
0x0000001028247824ULL, 0x100fe200078e021dULL, 0x000000031f447812ULL, 0x140fe200078ef61eULL,
0x000000102c287824ULL, 0x100fe200078e021dULL, 0x000000041f467812ULL, 0x140fe200078ef61eULL,
0x00000010322c7824ULL, 0x100fe200078e021dULL, 0x000000051f487812ULL, 0x140fe200078ef61eULL,
0x00000010422d7824ULL, 0x100fe200078e021dULL, 0x000000061f4a7812ULL, 0x000fe200078ef61eULL,
0x00000010221e7824ULL, 0x000fc400078e021dULL, 0x0000001026227824ULL, 0x100fe400078e021dULL,
0x000000102a267824ULL, 0x100fe400078e021dULL, 0x00000001331f7824ULL, 0x000fe400078e021cULL,
0x000000102e2a7824ULL, 0x100fe400078e021dULL, 0x00000010301c7824ULL, 0x100fe200078e021dULL,
0x000000081f007388ULL, 0x0003e20000000800ULL, 0x00000010442e7824ULL, 0x000fc400078e021dULL,
0x00000010462f7824ULL, 0x100fe400078e021dULL, 0x0000001048307824ULL, 0x100fe400078e021dULL,
0x000000104a317824ULL, 0x100fe400078e021dULL, 0x000000104c327824ULL, 0x000fe400078e021dULL,
0x00000001331d7824ULL, 0x040fe400078e021eULL, 0x0000000133217824ULL, 0x000fc400078e0220ULL,
0x0000000133237824ULL, 0x040fe200078e0222ULL, 0x0000000a1d007388ULL, 0x0007e20000000800ULL,
0x0000000133257824ULL, 0x040fe400078e0224ULL, 0x0000000133277824ULL, 0x040fe200078e0226ULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x0000000133297824ULL, 0x040fe400078e0228ULL,
0x00000001332b7824ULL, 0x040fe200078e022aULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x00000001331c7824ULL, 0x000fc400078e021cULL, 0x00000001332c7824ULL, 0x040fe200078e022cULL,
0x0000001025007388ULL, 0x0007e20000000800ULL, 0x00000001331e7824ULL, 0x040fe400078e022dULL,
0x00000001332e7824ULL, 0x040fe200078e022eULL, 0x0000001227007388ULL, 0x0007e20000000800ULL,
0x0000000133087824ULL, 0x042fe400078e022fULL, 0x0000000133307824ULL, 0x040fe200078e0230ULL,
0x0000001429007388ULL, 0x0007e20000000800ULL, 0x0000000133207824ULL, 0x000fc400078e0231ULL,
0x0000000133327824ULL, 0x000fe200078e0232ULL, 0x000000162b007388ULL, 0x0007e80000000800ULL,
0x000000091c007388ULL, 0x0007e80000000800ULL, 0x0000000b2c007388ULL, 0x0007e80000000800ULL,
0x0000000d1e007388ULL, 0x0007e80000000800ULL, 0x0000000f2e007388ULL, 0x0007e80000000800ULL,
0x0000001108007388ULL, 0x0007e80000000800ULL, 0x0000001330007388ULL, 0x0007e80000000800ULL,
0x0000001520007388ULL, 0x0007e80000000800ULL, 0x0000001732007388ULL, 0x0007e80000000800ULL,
0x00f0000400008388ULL, 0x0007e80000000c00ULL, 0x00f2001800008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000041ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080041ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100041ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030035357a10ULL, 0x000fe20007ffe0ffULL,
0x0000180041ff7f8cULL, 0x0003e6000c80043fULL, 0x000000363500720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb64000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff247807ULL, 0x008fe40004000000ULL,
0x000166a000287802ULL, 0x000fe40000000f00ULL, 0x00000f1000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0026ULL, 0xfffeb41000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004000000ULL, 0x000166f000287802ULL, 0x000fe40000000f00ULL,
0x00000ec000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0026ULL,
0xfffeb44000007947ULL, 0x000fea000383ffffULL, 0x0000001fff2b7424ULL, 0x000fe200078e00ffULL,
0x0001675000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x004fe400078e00ffULL,
0x00000e2000007944ULL, 0x03afea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e0029ULL,
0xfffeb4a000007947ULL, 0x000fea000383ffffULL, 0x0000001fff2b7424ULL, 0x000fe200078e00ffULL,
0x000167b000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x004fc400078e00ffULL,
0x00000dc000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff287224ULL, 0x006fe200078e0029ULL,
0xfffeb47000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0027ULL,
0x0001682000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000d5000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff9d7224ULL, 0x004fe200078e0029ULL, 0xfffeb7d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x002fe200078e0054ULL, 0x0001689000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x00000ce000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff8e7224ULL, 0x004fe200078e0029ULL,
0xfffeb79000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x010fe40004000000ULL,
0x000168e000287802ULL, 0x000fe40000000f00ULL, 0x00000cd000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0026ULL, 0xfffee21000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004000000ULL, 0x0001693000287802ULL, 0x000fc40000000f00ULL,
0x00000c8000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0026ULL,
0xfffee25000007947ULL, 0x000fea000383ffffULL, 0x0000001fff2b7424ULL, 0x008fe200078e00ffULL,
0x0001699000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x00000be000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e0029ULL,
0xfffee2c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x00afe200078e0054ULL,
0x00016a0000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000b7000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0029ULL, 0xfffee37000007947ULL, 0x000fea000383ffffULL,
0x0000001fff2b7424ULL, 0x000fe200078e00ffULL, 0x00016a6000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000b1000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff9f7224ULL, 0x004fe200078e0029ULL, 0xfffee63000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x002fe200078e0054ULL, 0x00016ad000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x00000aa000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff967224ULL, 0x004fe200078e0029ULL,
0xfffee5e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x002fe40004000000ULL,
0x00016b2000287802ULL, 0x000fc40000000f00ULL, 0x00000a9000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0026ULL, 0xffff0d6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004000000ULL, 0x00016b7000287802ULL, 0x000fc40000000f00ULL,
0x00000a4000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0026ULL,
0xffff0da000007947ULL, 0x000fea000383ffffULL, 0x0000001fff2b7424ULL, 0x002fe200078e00ffULL,
0x00016bd000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x000009a000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e0029ULL,
0xffff0e1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x002fe200078e0054ULL,
0x00016c4000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0000093000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0029ULL, 0xffff0ec000007947ULL, 0x000fea000383ffffULL,
0x0000001fff2b7424ULL, 0x000fe200078e00ffULL, 0x00016ca000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x000008d000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff857224ULL, 0x004fe200078e0029ULL, 0xffff117000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x002fe200078e0054ULL, 0x00016d1000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000086000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff847224ULL, 0x004fe200078e0029ULL,
0xffff112000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x010fe40004000000ULL,
0x00016d6000287802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0026ULL, 0xffff389000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004000000ULL, 0x00016db000287802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0026ULL,
0xffff38d000007947ULL, 0x000fea000383ffffULL, 0x0000001fff2b7424ULL, 0x008fe200078e00ffULL,
0x00016e1000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x0000076000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e0029ULL,
0xffff394000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x00afe200078e0054ULL,
0x00016e8000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x000006f000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0029ULL, 0xffff39f000007947ULL, 0x000fea000383ffffULL,
0x0000001fff2b7424ULL, 0x000fe200078e00ffULL, 0x00016ee000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0000069000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff6b7224ULL, 0x004fe200078e0029ULL, 0xffff3cb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x002fe200078e0054ULL, 0x00016f5000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000062000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff6c7224ULL, 0x004fe200078e0029ULL,
0xffff3c6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff257224ULL, 0x000fe200078e002dULL,
0x00016fb000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x000fc400078e00ffULL,
0x0000058000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0025ULL,
0xffffe7f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff257224ULL, 0x000fe200078e002fULL,
0x0001701000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000052000007944ULL, 0x020fea0003c00000ULL, 0x000000252f307209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0006ULL, 0x0001706000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x002fc400078e00ffULL, 0x000004d000007944ULL, 0x000fea0003c00000ULL,
0x0000002506067209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0007ULL,
0x000170b000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x0000002507247209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e002dULL, 0x0001710000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x000000252d047209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0030ULL,
0x0001715000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x002fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x0000002530057209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0006ULL, 0x000171a000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000002506067209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0024ULL,
0x000171f000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0xffffe6b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0030ULL, 0x0001726000247802ULL, 0x000fe20000000f00ULL,
0x000000ffff287224ULL, 0x000fc400078e00ffULL, 0x00001c1fff2b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fe400078e001dULL, 0x0000031000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e0029ULL, 0xffffec9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x002fe200078e0032ULL, 0x000172e000247802ULL, 0x000fe20000000f00ULL,
0x000000ffff287224ULL, 0x000fe400078e00ffULL, 0x00001c1fff2b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fe400078e001dULL, 0x0000029000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff287224ULL, 0x002fe200078e00ffULL, 0x0001734000247802ULL, 0x000fe20000000f00ULL,
0x00001c1fff2b7424ULL, 0x000fc400078e00ffULL, 0x000000ffff2d7224ULL, 0x000fe400078e001dULL,
0x000000ffff197224ULL, 0x004fe400078e0029ULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2d7224ULL, 0x002fe200078e001dULL, 0x000173a000247802ULL, 0x000fe20000000f00ULL,
0x000000ffff287224ULL, 0x000fe400078e00ffULL, 0x00001c1fff2b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1a7224ULL, 0x004fe400078e0029ULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0029ULL, 0xffffebd000007947ULL, 0x000fea000383ffffULL,
0x0180000041037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000004100038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff087807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000308ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff41ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000041077812ULL, 0x000fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000308ff7212ULL, 0x000fda000780c0ffULL,
0x0080000007030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0007ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000004100037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffe8ad006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003200007348ULL, 0x000fe80003800000ULL, 0x0c00002e25257389ULL, 0x0002a200000e0031ULL,
0xfffe8a9008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff257424ULL, 0x000fe200078e00ffULL,
0x0000002d00007348ULL, 0x000fe80003800000ULL, 0x000000282a297389ULL, 0x0002a200000e002bULL,
0xfffe8a5024007950ULL, 0x000fea0003c3ffffULL, 0x000000012400780cULL, 0x000fe20003f05070ULL,
0x0000005300007348ULL, 0x000fe80003800000ULL, 0x00000000ff257424ULL, 0x000fd000078e00ffULL,
0x0000000000247806ULL, 0x000fc800040e0100ULL, 0x0000005324267212ULL, 0x000fe200078ec0ffULL,
0x000000ffff247224ULL, 0x000fc800078e0028ULL, 0xfffe89e024007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000004a0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a80ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000b10ULL, 0x0000000000000880ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001390ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000013b0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000013c0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000013e0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001470ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001478ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001488ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001680ULL, 0x0000000000017700ULL, 0xf700001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018d80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000018d90ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018d90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000019210ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001470ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000017910ULL, 0x0000000000017910ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000018d80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000019210ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_89_cubin_len = 103152;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
