/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000019210ULL, 0x0000000000018d90ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000017330ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x00000000000174a0ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x00000000000174e0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000017520ULL,
0x0000000000000160ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000017680ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001733000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x005b880400288080ULL, 0x0000000000000000ULL, 0x00000104ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x9108288080900828ULL, 0x2880809208288080ULL, 0x8094082880809308ULL, 0x0828808095082880ULL,
0x8080990828808098ULL, 0xa0082880809a0828ULL, 0x288080a108288080ULL, 0x80a308288080a208ULL,
0x08288080a4082880ULL, 0x8080a608288080a5ULL, 0xa908288080a70828ULL, 0x288080aa08288080ULL,
0x80ac08288080ab08ULL, 0x08288080ad082880ULL, 0x8080af08288080aeULL, 0xb108288080b00828ULL,
0x288080b208288080ULL, 0x80b408288080b308ULL, 0x08288080b6082880ULL, 0x8081930828808192ULL,
0xb208288081940828ULL, 0x288081b308288081ULL, 0x81bf08288081bc08ULL, 0x08288081c9082880ULL,
0x8082801628808088ULL, 0x0000000000031028ULL, 0x2880808892000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001733000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x000000f4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x9108288080900828ULL,
0x2880809308288080ULL, 0x8095082880809408ULL, 0x0828808098082880ULL, 0x80809a0828808099ULL,
0xa108288080a00828ULL, 0x288080a208288080ULL, 0x80a408288080a308ULL, 0x08288080a5082880ULL,
0x8080a708288080a6ULL, 0xaa08288080a90828ULL, 0x288080ab08288080ULL, 0x80ad08288080ac08ULL,
0x08288080ae082880ULL, 0x8080b008288080afULL, 0xb308288080b10828ULL, 0x288080b408288080ULL,
0x819208288080b608ULL, 0x0828808193082880ULL, 0x8081b20828808194ULL, 0xbc08288081b30828ULL,
0x288081bf08288081ULL, 0x808c08288081c908ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x22002880808c9200ULL, 0x0000001cffffffffULL, 0x000001a800000000ULL, 0x000174a000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000fcffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x90082880808c0828ULL, 0x2880809108288080ULL, 0x8094082880809308ULL, 0x0828808095082880ULL,
0x8080990828808098ULL, 0xa0082880809a0828ULL, 0x288080a108288080ULL, 0x80a308288080a208ULL,
0x08288080a4082880ULL, 0x8080a608288080a5ULL, 0xa908288080a70828ULL, 0x288080aa08288080ULL,
0x80ac08288080ab08ULL, 0x08288080ad082880ULL, 0x8080af08288080aeULL, 0xb208288080b10828ULL,
0x288080b308288080ULL, 0x80b608288080b408ULL, 0x0828808192082880ULL, 0x8081940828808193ULL,
0xb308288081b20828ULL, 0x288081bc08288081ULL, 0x81c908288081bf08ULL, 0x16288080b0082880ULL,
0x0000031028808280ULL, 0xb092000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x000002d000000000ULL, 0x000174e000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x000000f4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x90082880808c0828ULL, 0x2880809108288080ULL,
0x8094082880809308ULL, 0x0828808095082880ULL, 0x8080990828808098ULL, 0xa0082880809a0828ULL,
0x288080a108288080ULL, 0x80a308288080a208ULL, 0x08288080a4082880ULL, 0x8080a608288080a5ULL,
0xa908288080a70828ULL, 0x288080aa08288080ULL, 0x80ac08288080ab08ULL, 0x08288080ad082880ULL,
0x8080af08288080aeULL, 0xb108288080b00828ULL, 0x288080b408288080ULL, 0x819208288080b608ULL,
0x0828808193082880ULL, 0x8081b20828808194ULL, 0xbc08288081b30828ULL, 0x288081bf08288081ULL,
0x80b308288081c908ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080b39200ULL,
0x0000002cffffffffULL, 0x0000040000000000ULL, 0x0001752000000000ULL, 0x0000016000000000ULL,
0x0000140400000000ULL, 0x80b0288080b30900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL,
0x00081204000000ffULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000eULL,
0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x00015b60000156d0ULL, 0x00015ce000015b70ULL,
0x00015d0000015cf0ULL, 0xffffffff01602904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x05000024ffffffffULL, 0x0500002405000024ULL, 0xffffffff05000024ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01602804ffffffffULL, 0x00000110000000f0ULL, 0x00001b3000001ab0ULL,
0x00001c2000001bf0ULL, 0x0000202000001ff0ULL, 0x000020e000002080ULL, 0x00004b8000004af0ULL,
0x00004d7000004c50ULL, 0x000050b000005090ULL, 0x0000517000005110ULL, 0x0000792000007890ULL,
0x00007b10000079f0ULL, 0x00007e4000007e20ULL, 0x00007f0000007ea0ULL, 0x0000a6a00000a610ULL,
0x0000a8900000a770ULL, 0x0000abd00000abb0ULL, 0x0000ac900000ac30ULL, 0x0000cca00000cc90ULL,
0x0000f4b00000f2b0ULL, 0x0000fb900000fb60ULL, 0x000155b000015580ULL, 0x000155d0000155c0ULL,
0x00015610000155f0ULL, 0x0001564000015630ULL, 0x00015d3000015cd0ULL, 0x00015d5000015d40ULL,
0x000164d000016470ULL, 0x000165b000016540ULL, 0x0001669000016620ULL, 0x00016750000166f0ULL,
0x00016820000167b0ULL, 0x000168f000016880ULL, 0x000169b000016950ULL, 0x00016a8000016a10ULL,
0x00016b5000016ae0ULL, 0x00016c1000016bb0ULL, 0x00016ce000016c70ULL, 0x00016db000016d40ULL,
0x00016eb000016e30ULL, 0x00016f9000016f20ULL, 0x0001707000017000ULL, 0x00017150000170e0ULL,
0x00017240000171c0ULL, 0x00017300000172a0ULL, 0x000001f004c03904ULL, 0x0000f600000000ffULL,
0x00000270003f0100ULL, 0x0000f60800000003ULL, 0x000002c0003f0120ULL, 0x0000f68800000003ULL,
0x00000360003f0120ULL, 0x0000f6a800000003ULL, 0x00000390003f0120ULL, 0x0000f6c800000003ULL,
0x00000460003f0120ULL, 0x0000f600000000ffULL, 0x00000630003f0107ULL, 0x0000f68c00000008ULL,
0x00000700003f0102ULL, 0x0000f68800000008ULL, 0x00000d90003f0101ULL, 0x00000000000000ffULL,
0x00000e2000040107ULL, 0x00000000000000ffULL, 0x00000e8000040101ULL, 0x0000002000000016ULL,
0x00000fd0003f0101ULL, 0x0000000400000017ULL, 0x00001040003f0105ULL, 0x0000002400000016ULL,
0x000010c0003f0105ULL, 0x0000002400000016ULL, 0x00001790003f0105ULL, 0x0000000000000072ULL,
0x00001880003f0107ULL, 0x0000000000000072ULL, 0x00001890003f0101ULL, 0x000000040000002eULL,
0x00001900003f0105ULL, 0x0000f60800000028ULL, 0x00001920003f0101ULL, 0x0000f60c00000028ULL,
0x000019d0003f0105ULL, 0x0000f60c00000013ULL, 0x00001ee0003f0105ULL, 0x000000040000002eULL,
0x00001f60003f0105ULL, 0x000000040000002eULL, 0x000040b0003f0105ULL, 0x0000002000000016ULL,
0x00004130003f0101ULL, 0x0000f68800000059ULL, 0x00004180003f0101ULL, 0x0000000400000017ULL,
0x000041d0003f0105ULL, 0x0000002400000016ULL, 0x00004250003f0105ULL, 0x0000002400000016ULL,
0x00004820003f0105ULL, 0x0000000000000065ULL, 0x000048a0003f0107ULL, 0x0000000000000065ULL,
0x000048b0003f0101ULL, 0x0000000400000066ULL, 0x00004920003f0105ULL, 0x0000f62800000028ULL,
0x00004940003f0101ULL, 0x0000f62c00000028ULL, 0x00004a20003f0105ULL, 0x0000f62c00000028ULL,
0x00004f60003f0105ULL, 0x0000f6ac00000014ULL, 0x00004fe0003f0105ULL, 0x0000f6ac00000014ULL,
0x00006fe0003f0105ULL, 0x0000002000000016ULL, 0x00007050003f0101ULL, 0x0000f69000000059ULL,
0x00007090003f0101ULL, 0x0000000400000017ULL, 0x000070e0003f0105ULL, 0x0000002400000016ULL,
0x00007160003f0105ULL, 0x0000002400000016ULL, 0x00007610003f0105ULL, 0x0000000000000066ULL,
0x00007690003f0107ULL, 0x0000000000000066ULL, 0x000076a0003f0101ULL, 0x0000000400000065ULL,
0x00007710003f0105ULL, 0x0000f64800000028ULL, 0x00007730003f0101ULL, 0x0000f64c00000028ULL,
0x000077c0003f0105ULL, 0x0000f64c00000028ULL, 0x00007cf0003f0105ULL, 0x0000f6ac00000015ULL,
0x00007d70003f0105ULL, 0x0000000400000065ULL, 0x00009d10003f0105ULL, 0x0000002000000016ULL,
0x00009d80003f0101ULL, 0x0000f69800000059ULL, 0x00009de0003f0101ULL, 0x0000000400000017ULL,
0x00009e30003f0105ULL, 0x0000002400000016ULL, 0x00009eb0003f0105ULL, 0x0000002400000016ULL,
0x0000a380003f0105ULL, 0x0000000000000065ULL, 0x0000a400003f0107ULL, 0x0000000000000065ULL,
0x0000a410003f0101ULL, 0x0000000400000066ULL, 0x0000a480003f0105ULL, 0x0000f66800000028ULL,
0x0000a4a0003f0101ULL, 0x0000f66c00000028ULL, 0x0000a540003f0105ULL, 0x0000f66c00000028ULL,
0x0000aa80003f0105ULL, 0x0000f6ac00000015ULL, 0x0000ab00003f0105ULL, 0x0000000400000066ULL,
0x0000ca20003f0105ULL, 0x0000002000000016ULL, 0x0000ca80003f0101ULL, 0x0000f6a000000059ULL,
0x000108c0003f0101ULL, 0x0000f600000000ffULL, 0x000116c0003f0101ULL, 0x0000f604000000ffULL,
0x00011760003f0105ULL, 0x0000f604000000ffULL, 0x00011970003f0105ULL, 0x0000f600000000ffULL,
0x00011980003f0101ULL, 0x0000f604000000ffULL, 0x00011a10003f0105ULL, 0x0000f604000000ffULL,
0x00014a60003f0105ULL, 0x000000000000003dULL, 0x00014a90003f0101ULL, 0x000000040000003dULL,
0x00014ea0003f0105ULL, 0x000000040000003dULL, 0x000162c0003f0105ULL, 0x000000000000003fULL,
0x00016320003f0101ULL, 0x000000080000003fULL, 0x00016380003f0101ULL, 0x000000100000003fULL,
0x000163f0003f0101ULL, 0x000000180000003fULL, 0x00053803003f0101ULL, 0x0001058000141c04ULL,
0x00011a70000107d0ULL, 0x0001643000011b20ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x0000000000000514ULL, 0x0000001200000002ULL, 0x00000000000003ecULL, 0x0000001200000002ULL,
0x00000000000002bcULL, 0x0000001200000002ULL, 0x0000000000000194ULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x00000000000004f1ULL, 0x0000001200000002ULL,
0x00000000000003c6ULL, 0x0000001200000002ULL, 0x0000000000000299ULL, 0x0000001200000002ULL,
0x000000000000016bULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff397624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000001200067300ULL, 0x000ee200000e0000ULL, 0x0000000839097824ULL, 0x000fe400078e00ffULL,
0x0000000000027919ULL, 0x000ea20000002200ULL, 0x00000100ff197424ULL, 0x000fc600078e00ffULL,
0x0000000000147919ULL, 0x000f220000002600ULL, 0x0000001200127309ULL, 0x000f660000000000ULL,
0x0000000000137919ULL, 0x000ee80000002700ULL, 0x0000000000077919ULL, 0x000ee20000000000ULL,
0x00000005ff007819ULL, 0x002fcc0000011603ULL, 0x00001fff00007589ULL, 0x000fe200000e0000ULL,
0x000000010d027824ULL, 0x004fc600078e0202ULL, 0x00001fff0d0d7589ULL, 0x000e6200000e0000ULL,
0x0000008002037824ULL, 0x000fc600078e0203ULL, 0x0000000000027919ULL, 0x000ea20000000000ULL,
0x0000000814087824ULL, 0x010fe200078e00ffULL, 0x000000ff0300720cULL, 0x040fe40003f45270ULL,
0x0000000f0300780cULL, 0x000fe20003f64070ULL, 0x00000013090a7224ULL, 0x008fe200078e0208ULL,
0x000000030300780cULL, 0x040fe40003f24070ULL, 0x0000007f0300780cULL, 0x000fe40003f84070ULL,
0x000000070600720cULL, 0x000fca0003f02070ULL, 0x3fffff80ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff05a424ULL, 0x000fe400078e00ffULL, 0x000000040d087824ULL, 0x002fe400078e0200ULL,
0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL, 0x00f60004ff00a388ULL, 0x0003e20000000a00ULL,
0x000000010300780cULL, 0x000fe20003f44070ULL, 0x00000002080b7824ULL, 0x000fe200078e00ffULL,
0x00000004ff0e7819ULL, 0x004fe20000011602ULL, 0x7fffffc0ff07b424ULL, 0x000fc400078e00ffULL,
0x3fffff60ff089424ULL, 0x000fe200078e00ffULL, 0x000000080b0c7817ULL, 0x040fe20007800000ULL,
0x000000010b0f7824ULL, 0x000fe200078e020eULL, 0x00f608060300b388ULL, 0x0005e20000008a00ULL,
0x7fffff60ff099424ULL, 0x000fe400078e00ffULL, 0x000000010a047824ULL, 0x002fe200078e020fULL,
0x000000070f157812ULL, 0x000fe200078ec0ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a0bULL,
0x00f6880803009388ULL, 0x000fe20000008a00ULL, 0xff317217ff10c424ULL, 0x000fc400078e00ffULL,
0x3fffffc0ff0aa424ULL, 0x000fe200078e00ffULL, 0x0000000c0e00720cULL, 0x000fe20003f66070ULL,
0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL, 0x00f400100300c388ULL, 0x0003e20000004800ULL,
0x3fffff80ff069424ULL, 0x004fe400078e00ffULL, 0x7fffff80ff079424ULL, 0x000fe400078e00ffULL,
0x0000001002117824ULL, 0x000fe400078e00ffULL, 0x00005c0004047625ULL, 0x000fe200078e0019ULL,
0x00f6a80603009388ULL, 0x0005e40000008a00ULL, 0x000000f011177812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x020fe200078e0a12ULL, 0x00f6c80a0300a388ULL, 0x0005e20000008a00ULL,
0x0000000f15107812ULL, 0x002fc600078e7802ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000001704047210ULL, 0x000fe20007f9e0ffULL, 0x000000100f107824ULL, 0x000fc800078e0210ULL,
0x000000ffff057224ULL, 0x000fe400020e0605ULL, 0x00000010100f7824ULL, 0x000fe400078e00ffULL,
0x00000004ff107424ULL, 0x000fc800078e00ffULL, 0x0000620013087625ULL, 0x000fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0005e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f6040cffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000608037981ULL, 0x004ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000004ff057e24ULL, 0x002fe2000f8e00ffULL,
0x0000003f03047810ULL, 0x004fc40007ffe0ffULL, 0x000000ff03067810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff047819ULL, 0x000fe40000011604ULL, 0x00000008ff067819ULL, 0x000fca0000011606ULL,
0x0001027000008947ULL, 0x000fea0003800000ULL, 0x00000002ff077819ULL, 0x000fe20000011600ULL,
0x00000003ff0b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff127424ULL, 0x000fe200078e00ffULL,
0x03ffffff07087812ULL, 0x000fca00078ec0ffULL, 0x00000004050e7824ULL, 0x000fca00078e0208ULL,
0x000000040e00720cULL, 0x000fda0003f06070ULL, 0x0000000213088824ULL, 0x000fe400078e00ffULL,
0x00006400ff098624ULL, 0x000fc800078e00ffULL, 0x0000640008098624ULL, 0x000fe400078e0209ULL,
0x0000000800087824ULL, 0x000fe400078e00ffULL, 0x000000010e098824ULL, 0x000fe200078e0209ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c0b08ff738cULL, 0x0003e20000000000ULL,
0x00006000090c8625ULL, 0x000fe200078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000060c128981ULL, 0x0004e2000c1e1900ULL, 0x00000003ff097424ULL, 0x000fe200078e00ffULL,
0x000000030e0a7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff177819ULL, 0x000fe20000011602ULL,
0x0000030010097a24ULL, 0x000fe200078e0a09ULL, 0x000000030a00780cULL, 0x000fe20003f05270ULL,
0x00f6880008ff7f8cULL, 0x0009e6000c80043fULL, 0x00000001090b7807ULL, 0x002fca0004000000ULL,
0x000000010e0b7824ULL, 0x000fca00078e020bULL, 0x000000040b00720cULL, 0x000fe40003f06070ULL,
0x00000001000c7812ULL, 0x004fe400078ec0ffULL, 0x00000004171a7810ULL, 0x000fd20007ffe0ffULL,
0x00000002130a8824ULL, 0x000fe400078e00ffULL, 0x00006400ff0f8624ULL, 0x000fc800078e00ffULL,
0x000064000a0a8624ULL, 0x000fe400078e020fULL, 0x000000100c167824ULL, 0x000fe400078e00ffULL,
0x000000010a0e8824ULL, 0x000fe400078e020bULL, 0xffffffffff0a7424ULL, 0x000fe400078e00ffULL,
0x000060000e0e8625ULL, 0x000fe200078e0010ULL, 0x00000001ff0d7819ULL, 0x000fc60000011600ULL,
0x00000001161d7824ULL, 0x040fe200078e021aULL, 0x000000060e0a8981ULL, 0x000362000c1e1900ULL,
0x0000000105157810ULL, 0x000fe20007ffe0ffULL, 0x0000000116197824ULL, 0x040fe200078e0217ULL,
0x00000008171e7810ULL, 0x000fe20007ffe0ffULL, 0x000000081d1c7824ULL, 0x000fe200078e00ffULL,
0x000000061500720cULL, 0x000fe20003f06070ULL, 0x00000008191b7824ULL, 0x000fe200078e00ffULL,
0x0000000c17227810ULL, 0x000fe20007ffe0ffULL, 0x0000000116217824ULL, 0x040fe200078e021eULL,
0x0000000219107212ULL, 0x080fe200078e3cffULL, 0x000000200d0e7824ULL, 0x002fe200078e00ffULL,
0x000000021d0f7212ULL, 0x080fe200078e3cffULL, 0x0000000116257824ULL, 0x000fe200078e0222ULL,
0xfffffff81b187812ULL, 0x000fe200078ee210ULL, 0x000020000d107824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20fULL, 0x00000040140f7824ULL, 0x000fe200078e00ffULL,
0x0000000225247212ULL, 0x000fe200078e3cffULL, 0x0000010005147824ULL, 0x000fe200078e020eULL,
0x000000000d0473c2ULL, 0x000e6200000e0000ULL, 0x0000000821297824ULL, 0x000fe200078e00ffULL,
0x0000b000101b7810ULL, 0x000fe20007ffe0ffULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000001403157217ULL, 0x000fe20007800000ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000221207212ULL, 0x000fe200078e3cffULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000115157824ULL, 0x100fe200078e0a14ULL,
0x000000200f147812ULL, 0x000fe200078ef814ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0xfffffff829207812ULL, 0x000fe200078ee220ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000002015157807ULL, 0x000fe20000000000ULL, 0x0000000114197824ULL, 0x040fe200078e0219ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000114237824ULL, 0x040fe200078e0221ULL,
0x0000001615157217ULL, 0x000fe20007800000ULL, 0x00000001141f7824ULL, 0x040fe200078e021dULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000000114277824ULL, 0x000fc400078e0225ULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0x0000f6a804047891ULL, 0x002fe2000f8e203fULL,
0x0000000115157824ULL, 0x000fe400078e0a16ULL, 0x000000101c217824ULL, 0x100fe200078e021bULL,
0xfffffff825247812ULL, 0x000fe200078ee224ULL, 0x00000010181d7824ULL, 0x100fe200078e021bULL,
0x000000151e00720cULL, 0x080fe20003f06070ULL, 0x0000001020257824ULL, 0x100fe200078e021bULL,
0x000000151a00720cULL, 0x000fe20003f26070ULL, 0x0000001024297824ULL, 0x000fe200078e021bULL,
0x00000070111b7812ULL, 0x000fc400078ec0ffULL, 0x000000151700720cULL, 0x000fe20003f46070ULL,
0x0000580012127a24ULL, 0x008fc800078e02ffULL, 0x0000004012127824ULL, 0x000fca00078e00ffULL,
0x0000001912197210ULL, 0x040fe40007f7e0ffULL, 0x0000002312237210ULL, 0x040fe40007fbe0ffULL,
0x0000001f121f7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x00005e00191c7a11ULL, 0x000fe200078638ffULL, 0x000000ffff147224ULL, 0x000fe200028e06ffULL,
0x0000002712277210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1a7224ULL, 0x000fe200020e06ffULL,
0x00005e0023187a11ULL, 0x000fc400078838ffULL, 0x00005f00191e7a11ULL, 0x000fe200018f3c1eULL,
0x000000ffff127224ULL, 0x000fe200028e06ffULL, 0x00005e001f167a11ULL, 0x000fe400078638ffULL,
0x00005f0023197a11ULL, 0x000fe400020f3c14ULL, 0x0000001c1b147210ULL, 0x000fe40007fbe0ffULL,
0x00005f001f177a11ULL, 0x000fe400018f3c1aULL, 0x0000001b16167210ULL, 0x000fc40007f9e0ffULL,
0x00005e00271a7a11ULL, 0x040fe400078c38ffULL, 0x000000152200720cULL, 0x000fe20003f66070ULL,
0x000000ffff157224ULL, 0x000fe200028e061eULL, 0x0000001b18187210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200020e0617ULL, 0x00005f0027117a11ULL, 0x000fe200030f3c12ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x0000001b1a1a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff197224ULL, 0x000fe200028e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0009e6000d101c46ULL, 0x000000ffff1b7224ULL, 0x000fe200020e0611ULL,
0x0000000016217faeULL, 0x0003e2000c901c46ULL, 0xff317217ff117424ULL, 0x000fc600078e00ffULL,
0x0000000018257faeULL, 0x0009e2000c101c46ULL, 0x000000060500720cULL, 0x000fc60003f06070ULL,
0x000000001a297faeULL, 0x0009e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000f6a80d167811ULL, 0x002fc600078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff187f8cULL, 0x010e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200016147f8cULL, 0x0004e2000c80043fULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000002016177810ULL, 0x000fe20007ffe0ffULL,
0x0000bbc000000947ULL, 0x000fea0003800000ULL, 0x0000000213187824ULL, 0x006fe400078e00ffULL,
0x00006400ff117624ULL, 0x000fc400078e00ffULL, 0x000000ffff317224ULL, 0x008fe400078e0015ULL,
0x0000640018187624ULL, 0x000fe400078e0211ULL, 0xff317217ff117424ULL, 0x000fe400078e00ffULL,
0x000000ffff157224ULL, 0x000fe400078e00ffULL, 0x000000ffff3b7224ULL, 0x000fe400078e00ffULL,
0x0000010005147824ULL, 0x000fca00078e00ffULL, 0x000000031400720cULL, 0x000fda0003f06070ULL,
0x0000bae000000947ULL, 0x002fea0003800000ULL, 0x0000040017147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000fee0000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x000000ffff5b7224ULL, 0x000fe400078e000bULL,
0x000000ffff1a7224ULL, 0x000fe200078e0015ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240016147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fc40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x0000000d00137305ULL, 0x0002a4000021f000ULL,
0x3fa000000d0d7823ULL, 0x002fe200000100ffULL, 0x000000130000735dULL, 0x004fe20003800000ULL,
0x0000240016147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000030b0d7812ULL, 0x000fe200078ec0ffULL,
0x000058000a237a24ULL, 0x020fe200078e02ffULL, 0x00000003ff2c7819ULL, 0x000fe20000011602ULL,
0xffffffffff0a7424ULL, 0x000fe200078e00ffULL, 0x000000030d00780cULL, 0x000fc80003f05270ULL,
0x0000000109147807ULL, 0x000fca0004000000ULL, 0x000000010b0b7824ULL, 0x000fca00078e0214ULL,
0x000000040b00720cULL, 0x000fe20003f06070ULL, 0x00000010000d7824ULL, 0x000fca00078e00ffULL,
0x000000100d257812ULL, 0x000fce00078ec0ffULL, 0x00000001181e8824ULL, 0x000fe400078e020bULL,
0x00000004ff1f8424ULL, 0x000fe200078e00ffULL, 0x0000000105137810ULL, 0x000fe20007ffe0ffULL,
0x000000012c1b7824ULL, 0x000fe400078e0225ULL, 0x000060001e1e8625ULL, 0x000fe200078e001fULL,
0x00000001ff0d7819ULL, 0x000fc60000011600ULL, 0x00000100051c7824ULL, 0x000fe200078e00ffULL,
0x000000061e0a8981ULL, 0x000362000c1e1900ULL, 0x000000081b217824ULL, 0x000fe200078e00ffULL,
0x000000061300720cULL, 0x000fe20003f06070ULL, 0x000000200d137824ULL, 0x000fe200078e021cULL,
0x000000021b147212ULL, 0x000fe200078e3cffULL, 0x0000001002327824ULL, 0x000fe200078e00ffULL,
0x000000042c347810ULL, 0x040fe20007ffe0ffULL, 0x0000000815337824ULL, 0x000fe200078e00ffULL,
0x0000000c2c587810ULL, 0x000fe20007ffe0ffULL, 0x0000059000007945ULL, 0x000fe20003800000ULL,
0xfffffff8211e7812ULL, 0x002fe200078ee214ULL, 0x00000001341d7824ULL, 0x000fe200078e0225ULL,
0x0000004013147810ULL, 0x000fc40007ffe0ffULL, 0x000000082c367810ULL, 0x000fe20007ffe0ffULL,
0x000000081d217824ULL, 0x000fe200078e00ffULL, 0x0000001403137217ULL, 0x000fe40007800000ULL,
0x000000021d207212ULL, 0x080fe200078e3cffULL, 0x00000001361f7824ULL, 0x100fe400078e0225ULL,
0x0000000113247824ULL, 0x000fe200078e0a14ULL, 0xfffffff821207812ULL, 0x000fe200078ee220ULL,
0x0000000158217824ULL, 0x000fe200078e0225ULL, 0x000000200f147812ULL, 0x000fe200078ef814ULL,
0x0000004023137824ULL, 0x000fe200078e00ffULL, 0x000000021f227212ULL, 0x080fe200078e3cffULL,
0x0000000821287824ULL, 0x040fe200078e00ffULL, 0x0000000221277212ULL, 0x000fe200078e3cffULL,
0x0000000114267824ULL, 0x000fe200078e021bULL, 0x0000002024247807ULL, 0x000fe20000000000ULL,
0x000000081f297824ULL, 0x000fe200078e00ffULL, 0xfffffff828237812ULL, 0x000fe200078ee227ULL,
0x0000000114287824ULL, 0x040fe200078e021dULL, 0x0000002613307210ULL, 0x000fe20007f5e0ffULL,
0x00000001142a7824ULL, 0x040fe200078e021fULL, 0xfffffff829227812ULL, 0x000fe200078ee222ULL,
0x0000000114147824ULL, 0x000fe200078e0221ULL, 0x0000002813267210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff297224ULL, 0x000fe200010e06ffULL, 0x00005e00302f7a11ULL, 0x000fc400078438ffULL,
0x0000001413277210ULL, 0x000fe20007f1e0ffULL, 0x0000100015147824ULL, 0x000fe200078e00ffULL,
0x0000002524247217ULL, 0x000fe40007800000ULL, 0x00005f0030307a11ULL, 0x000fe200010f3c29ULL,
0x000000ffff297224ULL, 0x000fe200018e06ffULL, 0x0000002a132a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000124137824ULL, 0x000fe200078e0a25ULL, 0x00005e0026287a11ULL, 0x000fe200078438ffULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x0000100014147812ULL, 0x000fe200078e0cffULL,
0x000000ffff2d7224ULL, 0x000fe200020e06ffULL, 0x00005f0026257a11ULL, 0x000fc400010f3c29ULL,
0x000000132c00720cULL, 0x000fe20003f46070ULL, 0x000020000d147824ULL, 0x000fe200078e0214ULL,
0x00005e002a2c7a11ULL, 0x000fe400078638ffULL, 0x0000007032297812ULL, 0x000fe400078ec0ffULL,
0x00005f002a2d7a11ULL, 0x000fe400018f3c2dULL, 0x00005e00272e7a11ULL, 0x000fe400078038ffULL,
0x000000292f267210ULL, 0x000fc40007f7e0ffULL, 0x0000b00014317810ULL, 0x000fe40007ffe0ffULL,
0x00005f0027147a11ULL, 0x000fe200000f3c24ULL, 0x000000ffff277224ULL, 0x000fe200018e0630ULL,
0x0000002928287210ULL, 0x080fe20007fbe0ffULL, 0x000000101e247824ULL, 0x000fe200078e0231ULL,
0x000000292c2c7210ULL, 0x080fe40007f7e0ffULL, 0x000000292e2e7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff297224ULL, 0x000fe200028e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026247faeULL, 0x0003e2000d101c46ULL, 0x000000133400720cULL, 0x080fe20003f06070ULL,
0x0000001020257824ULL, 0x000fe200078e0231ULL, 0x000000133600720cULL, 0x080fe20003f46070ULL,
0x000000ffff2d7224ULL, 0x000fe200018e062dULL, 0x000000135800720cULL, 0x000fe20003fa6070ULL,
0x000000ffff2f7224ULL, 0x000fe200020e0614ULL, 0xfffffff008137812ULL, 0x000fc400078ec0ffULL,
0x0000000808147812ULL, 0x000fe400078ec0ffULL, 0x0000f6a8132a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001022267824ULL, 0x102fe200078e0231ULL, 0x0000000833137812ULL, 0x000fe200078e0cffULL,
0x0000001023277824ULL, 0x000fe200078e0231ULL, 0x0000000028257faeULL, 0x0003e2000c101c46ULL,
0x000000000000781cULL, 0x000fe40003f0f070ULL, 0x000000012a727824ULL, 0x000fe200078e0213ULL,
0x000000002c267faeULL, 0x0005e2000d101c46ULL, 0x0000001008137812ULL, 0x000fc600078ec0ffULL,
0x000000002e277faeULL, 0x0005e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0xffffffe008287812ULL, 0x002fc800078ec0ffULL, 0x0000002814287210ULL, 0x000fe40007ffe013ULL,
0x00000000720403c2ULL, 0x000e640000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x002fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000012a2e7824ULL, 0x004fe200078e0233ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000072727f8cULL, 0x000e68000c80043fULL, 0x000004002e147984ULL, 0x0004e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60800282c7f8cULL, 0x000fe2000c80043fULL, 0x8000000014ff7812ULL, 0x008fc60007844819ULL,
0x00f60c0028297984ULL, 0x000ee40000000800ULL, 0x8000000029ff7812ULL, 0x008fe4000780482dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000a000000947ULL, 0x000fea0003800000ULL, 0x0000002007137824ULL, 0x000fe400078e0213ULL,
0x3e000000ff147424ULL, 0x000fe400078e00ffULL, 0x000000080c137824ULL, 0x000fe400078e0213ULL,
0x0000001400297305ULL, 0x000724000021f000ULL, 0x3fa0000014147823ULL, 0x008fe200000100ffULL,
0x000000290000735dULL, 0x010fe40003800000ULL, 0x00f60c0013297984ULL, 0x000ee40000000800ULL,
0x8000000029ff7812ULL, 0x008fc4000780482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff2a7819ULL, 0x000fe40000011602ULL, 0x0000007032297812ULL, 0x000fe400078ec0ffULL,
0x0000000c2a2a7812ULL, 0x000fc600078ec0ffULL, 0x0000008007137824ULL, 0x000fc800078e0229ULL,
0x0000000113137824ULL, 0x000fca00078e022aULL, 0x00f0000013147984ULL, 0x000ee80000000800ULL,
0x00f20000132c7984ULL, 0x0008a20000000800ULL, 0x000000111400720bULL, 0x008fe20003f1d000ULL,
0x000149927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x010fc800000e0100ULL,
0x0000ffff132f7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff907424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x000000000700720cULL, 0x000fe40003f65270ULL, 0x000000111400720bULL, 0x000fe20003f14000ULL,
0x000149727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x000fe400000e0100ULL,
0x00000080002db824ULL, 0x000fe200078e0229ULL, 0x0000001411587209ULL, 0x000fe40007810000ULL,
0x0000ffff13307812ULL, 0x000fe200078e3cffULL, 0x000000012a2db824ULL, 0x000fe200078e022dULL,
0x00000002ff137819ULL, 0x000fe20000011602ULL, 0x8000005811117221ULL, 0x000fe20000010000ULL,
0x000000302fff7212ULL, 0x000fc4000780c0ffULL, 0x00f400582d00b388ULL, 0x0007e20000000800ULL,
0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL, 0x0000001100337308ULL, 0x0007220000000800ULL,
0x000149127f007947ULL, 0x000fea000b800000ULL, 0x00001f1333117589ULL, 0x01872400000e0000ULL,
0x0000000813137810ULL, 0x008fe20007ffe0ffULL, 0x000149527f007947ULL, 0x000fea000b800000ULL,
0x00001f1333137589ULL, 0x00072400000e0000ULL, 0x8000005814140221ULL, 0x000fe20000010000ULL,
0x00000001ff907807ULL, 0x000fe20000000000ULL, 0x0000001139397220ULL, 0x090fe40000410000ULL,
0x3fb8aa3b14140820ULL, 0x000fe40000410000ULL, 0x0000001138387220ULL, 0x080fe40000410000ULL,
0x00000014002b0308ULL, 0x000f220000000800ULL, 0x000000113d3d7220ULL, 0x000fc40000410000ULL,
0x000000113c3c7220ULL, 0x080fe40000410000ULL, 0x0000001141417220ULL, 0x080fe40000410000ULL,
0x0000001140407220ULL, 0x080fe40000410000ULL, 0x0000001145457220ULL, 0x080fe40000410000ULL,
0x0000001144447220ULL, 0x080fe40000410000ULL, 0x0000001149497220ULL, 0x000fc40000410000ULL,
0x0000001148487220ULL, 0x080fe40000410000ULL, 0x000000114d4d7220ULL, 0x080fe40000410000ULL,
0x000000114c4c7220ULL, 0x080fe40000410000ULL, 0x0000001151517220ULL, 0x080fe40000410000ULL,
0x0000001150507220ULL, 0x080fe40000410000ULL, 0x0000001155557220ULL, 0x000fc40000410000ULL,
0x0000001154547220ULL, 0x000fe40000410000ULL, 0x0000003312127220ULL, 0x000fe40000410000ULL,
0x000000133b3b7220ULL, 0x080fe40000410000ULL, 0x000000133a3a7220ULL, 0x080fe40000410000ULL,
0x000000133f3f7220ULL, 0x080fe40000410000ULL, 0x000000133e3e7220ULL, 0x000fc40000410000ULL,
0x0000001343437220ULL, 0x080fe40000410000ULL, 0x0000001342427220ULL, 0x080fe40000410000ULL,
0x0000001347477220ULL, 0x080fe40000410000ULL, 0x0000001346467220ULL, 0x080fe40000410000ULL,
0x000000134b4b7220ULL, 0x080fe40000410000ULL, 0x000000134a4a7220ULL, 0x000fc40000410000ULL,
0x000000134f4f7220ULL, 0x080fe40000410000ULL, 0x000000134e4e7220ULL, 0x080fe40000410000ULL,
0x0000001353537220ULL, 0x080fe40000410000ULL, 0x0000001352527220ULL, 0x080fe40000410000ULL,
0x0000001357577220ULL, 0x080fe40000410000ULL, 0x0000001356567220ULL, 0x000fc40000410000ULL,
0x000000ffff117224ULL, 0x000fe400078e0058ULL, 0x0000002b2c2c0220ULL, 0x014fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000122c127221ULL, 0x004fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x000004002e147984ULL, 0x000ea40000000800ULL, 0x8000000014ff7812ULL, 0x004fe40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff137424ULL, 0x000fc800078e00ffULL, 0x0000001300147305ULL, 0x000524000021f000ULL,
0x3fa0000013137823ULL, 0x004fe200000100ffULL, 0x000000140000735dULL, 0x010fe40003800000ULL,
0x000004002e147984ULL, 0x000ea40000000800ULL, 0x8000000014ff7812ULL, 0x004fc40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002bff13723eULL, 0x000fe400000010ffULL,
0x00000002ff147819ULL, 0x000fe40000011602ULL, 0x0000541013337816ULL, 0x00afe20000000013ULL,
0x000145f27f007947ULL, 0x000fea000b800000ULL, 0x00001f1433bf7589ULL, 0x0002a400000e0000ULL,
0x00000008142c7810ULL, 0x000fe20007ffe0ffULL, 0x000146327f007947ULL, 0x000fea000b800000ULL,
0x00001f2c33bc7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001014347810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x0000209000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0001545000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001814347810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x000020f000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x000153f000007944ULL, 0x03cfea0003c00000ULL, 0x0000000200597824ULL, 0x000fe200078e00ffULL,
0x0000000702db7812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x0000000459137812ULL, 0x000fc400078ec0ffULL, 0x00000008dbdb7812ULL, 0x000fe400078ef802ULL,
0x0000001302dc7211ULL, 0x040fe400078fe0ffULL, 0x0000000802137812ULL, 0x000fe400078ec0ffULL,
0x00000007dc147812ULL, 0x002fca00078e78dbULL, 0x00000008db147824ULL, 0x000fc800078e0214ULL,
0x0000001014ec7824ULL, 0x000fc800078e00ffULL, 0x0000080007d17824ULL, 0x000fe400078e02ecULL,
0x0000000400147824ULL, 0x040fe200078e00ffULL, 0x0000000713357812ULL, 0x140fe200078ec802ULL,
0x00001000002d7824ULL, 0x000fe200078e00ffULL, 0x00000007132f7812ULL, 0x000fe200078ef802ULL,
0x0000100015137824ULL, 0x000fe200078e0210ULL, 0x0000000414197812ULL, 0x000fe400078ec0ffULL,
0xffffe0002d147812ULL, 0x000fe400078ec0ffULL, 0x0000001902347211ULL, 0x000fe400078fe0ffULL,
0x000000802f677811ULL, 0x000fe200078e18ffULL, 0x0000100015147824ULL, 0x000fe200078e0214ULL,
0x00000034352e7212ULL, 0x000fc400078e3cffULL, 0x0000b00013697810ULL, 0x000fe40007ffe0ffULL,
0x0000b00014367810ULL, 0x000fe20007ffe0ffULL, 0x000000082f2d7824ULL, 0x000fe200078e022eULL,
0x0000000234347810ULL, 0x000fe20007ffe0ffULL, 0x000000012e2e7824ULL, 0x000fe200078e0267ULL,
0x00000002dcdc7810ULL, 0x000fe20007ffe0ffULL, 0x000000102d5c7824ULL, 0x000fe200078e0236ULL,
0x0000003435587212ULL, 0x000fe200078e3cffULL, 0x000000102e307824ULL, 0x000fe200078e0269ULL,
0x00000007dcdc7812ULL, 0x000fc400078e78dbULL, 0x0000991090907816ULL, 0x000fe200000000ffULL,
0x000000005c5c783bULL, 0x000e620000004200ULL, 0x000000082f2f7824ULL, 0x000fe400078e0258ULL,
0x0000000158587824ULL, 0x000fe200078e0267ULL, 0x000000003030783bULL, 0x00cea20000004200ULL,
0x000000102f367824ULL, 0x000fe400078e0236ULL, 0x00000008dbdc7824ULL, 0x000fe200078e02dcULL,
0x00000018ff377819ULL, 0x002fe2000001145cULL, 0x0000005c00f77306ULL, 0x000fe20000009400ULL,
0x00000018ff607819ULL, 0x000fc4000001145eULL, 0x00000018ff647819ULL, 0x004fe40000011431ULL,
0x00000018ff617819ULL, 0x000fe4000001145fULL, 0x00000018ff657819ULL, 0x000fe20000011432ULL,
0x0000003700f47306ULL, 0x000fe20000209400ULL, 0x00000018ff5a7819ULL, 0x000fe4000001145dULL,
0x00000018ff627819ULL, 0x000fe40000011430ULL, 0x00000018ff667819ULL, 0x000fc60000011433ULL,
0x00000037007b7306ULL, 0x000e700000205400ULL, 0x0000003700b17306ULL, 0x0004f0000020d400ULL,
0x0000006000807306ULL, 0x000fe20000209400ULL, 0x000000003634783bULL, 0x004ea20000004200ULL,
0x0000007bf400720bULL, 0x002fcc0003fdd000ULL, 0x00000060007f7306ULL, 0x000e6e0000205400ULL,
0x00000001b1b16812ULL, 0x008fe200078efcffULL, 0x0000006000a57306ULL, 0x000ef0000020d400ULL,
0x0000006400b27306ULL, 0x000fe20000209400ULL, 0x0000007f8000720bULL, 0x002fce0003fdd000ULL,
0x0000006400b37306ULL, 0x000fec0000205400ULL, 0x00000001a5a56812ULL, 0x008fe400078efcffULL,
0x0000006400607306ULL, 0x0003e2000020d400ULL, 0x0000010037a37824ULL, 0x004fca00078e00ffULL,
0x00000018fff97819ULL, 0x000fe200000114a3ULL, 0x0001000036a37824ULL, 0x000fe200078e00ffULL,
0x0000005c00a47306ULL, 0x000ea20000005400ULL, 0x000001005c647824ULL, 0x002fc600078e00ffULL,
0x00000018fff87819ULL, 0x000fe400000114a3ULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x0000005c00b87306ULL, 0x0002f0000000d400ULL, 0x0000006100dd7306ULL, 0x000fe20000209400ULL,
0x000100005c5c7824ULL, 0x002fe200078e00ffULL, 0x000000a4f700720bULL, 0x004fc80003f1d000ULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x00000061008c7306ULL, 0x000fee0000205400ULL,
0x00000001b8b80812ULL, 0x008fe200078efcffULL, 0x0000006100a27306ULL, 0x000ff0000020d400ULL,
0x0000006500997306ULL, 0x000ff00000209400ULL, 0x0000006500987306ULL, 0x000ff00000205400ULL,
0x0000006500617306ULL, 0x0003f0000020d400ULL, 0x0000005c00f57306ULL, 0x000fe20000209400ULL,
0x000001005d657824ULL, 0x002fca00078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x0000005c007a7306ULL, 0x000e700000205400ULL, 0x0000005c00b67306ULL, 0x0004f0000020d400ULL,
0x0000005d00977306ULL, 0x000fe20000009400ULL, 0x000001005f5c7824ULL, 0x004fe200078e00ffULL,
0x0000007af500720bULL, 0x002fc80003fbd000ULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000005d00967306ULL, 0x000e6e0000005400ULL, 0x00000001b6b65812ULL, 0x008fe200078efcffULL,
0x0000005d00917306ULL, 0x0004f0000000d400ULL, 0x0000006400f67306ULL, 0x000fe20000209400ULL,
0x000100005d5d7824ULL, 0x004fe200078e00ffULL, 0x000000969700720bULL, 0x002fc80003f9d000ULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x0000006400957306ULL, 0x000e6e0000205400ULL,
0x0000000191914812ULL, 0x008fe200078efcffULL, 0x0000006400c57306ULL, 0x0004f0000020d400ULL,
0x0000005e00ef7306ULL, 0x000fe20000009400ULL, 0x000001005e647824ULL, 0x004fe200078e00ffULL,
0x00000095f600720bULL, 0x002fc80003f7d000ULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x0000005e00867306ULL, 0x000e6e0000005400ULL, 0x00000001c5c53812ULL, 0x008fe200078efcffULL,
0x0000005e00ab7306ULL, 0x0004f0000000d400ULL, 0x0000005c008a7306ULL, 0x000fe20000209400ULL,
0x000100005e5e7824ULL, 0x004fe200078e00ffULL, 0x00000086ef00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000005c00e37306ULL, 0x000fee0000205400ULL,
0x00000001abab3812ULL, 0x008fe200078efcffULL, 0x0000005c00af7306ULL, 0x0003e2000020d400ULL,
0x0000008cdd00720bULL, 0x000fce0003f7d000ULL, 0x0000005f00ea7306ULL, 0x000fe20000009400ULL,
0x00000018ff5c7819ULL, 0x002fca0000011435ULL, 0x00000001a2a23812ULL, 0x000fe400078efcffULL,
0x0000005f00897306ULL, 0x000e700000005400ULL, 0x0000005f00aa7306ULL, 0x0004f0000000d400ULL,
0x0000005d00837306ULL, 0x000fe20000209400ULL, 0x000100005f5f7824ULL, 0x004fe200078e00ffULL,
0x00000089ea00720bULL, 0x002fe20003f1d000ULL, 0x00000010dcea7824ULL, 0x000fc600078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000005d00e87306ULL, 0x000fee0000205400ULL,
0x00000001aaaa0812ULL, 0x008fe200078efcffULL, 0x0000005d00b77306ULL, 0x0003f0000020d400ULL,
0x0000005e00e47306ULL, 0x000fe20000209400ULL, 0x00000018ff5d7819ULL, 0x002fce0000011434ULL,
0x0000005e00e77306ULL, 0x000ff00000205400ULL, 0x0000005e00a87306ULL, 0x0003f0000020d400ULL,
0x0000005c00e07306ULL, 0x000fe20000209400ULL, 0x00000018ff5e7819ULL, 0x002fce0000011436ULL,
0x0000005c00e17306ULL, 0x000e700000205400ULL, 0x0000005c008e7306ULL, 0x0004f0000020d400ULL,
0x0000005d00de7306ULL, 0x000fe20000209400ULL, 0x00000100315c7824ULL, 0x004fe200078e00ffULL,
0x000000e1e000720bULL, 0x002fcc0003f7d000ULL, 0x0000005d00df7306ULL, 0x000e6e0000205400ULL,
0x000000018e8e3812ULL, 0x008fe200078efcffULL, 0x0000005d008f7306ULL, 0x0004f0000020d400ULL,
0x0000005e00c97306ULL, 0x000fe20000209400ULL, 0x00000100305d7824ULL, 0x004fe200078e00ffULL,
0x000000dfde00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x0000005e00ca7306ULL, 0x000e6e0000205400ULL, 0x000000018f8f6812ULL, 0x008fe200078efcffULL,
0x0000005e007e7306ULL, 0x0004f0000020d400ULL, 0x0000005f00e97306ULL, 0x000fe20000209400ULL,
0x00000018ff5e7819ULL, 0x004fe2000001145cULL, 0x00000010585c7824ULL, 0x000fe200078e0269ULL,
0x000000cac900720bULL, 0x002fca0003fdd000ULL, 0x0000005f00e27306ULL, 0x000ff00000205400ULL,
0x0000005f00a97306ULL, 0x0003e2000020d400ULL, 0x000000017e7e6812ULL, 0x008fce00078efcffULL,
0x0000006400e67306ULL, 0x000fe20000209400ULL, 0x00000018ff5f7819ULL, 0x002fce0000011437ULL,
0x0000006400e57306ULL, 0x000e700000205400ULL, 0x0000006400ae7306ULL, 0x000eb0000020d400ULL,
0x0000005f00cb7306ULL, 0x000fe20000209400ULL, 0x000000e5e600720bULL, 0x002fce0003f9d000ULL,
0x0000005f00cc7306ULL, 0x000fec0000205400ULL, 0x00000001aeae4812ULL, 0x004fe400078efcffULL,
0x0000005f007d7306ULL, 0x000fe2000020d400ULL, 0x000000e2e900720bULL, 0x000fce0003f9d000ULL,
0x0000005d00cd7306ULL, 0x000fec0000209400ULL, 0x00000001a9a94812ULL, 0x000fe400078efcffULL,
0x0000005d00ce7306ULL, 0x000ff00000205400ULL, 0x0000005d00687306ULL, 0x000ff0000020d400ULL,
0x0000005e00cf7306ULL, 0x000ff00000209400ULL, 0x0000005e00d07306ULL, 0x000ff00000205400ULL,
0x0000005e00647306ULL, 0x0003f0000020d400ULL, 0x0000006500f27306ULL, 0x000fe20000209400ULL,
0x000000005c5c783bULL, 0x002e6e0000004200ULL, 0x0000006500f37306ULL, 0x000eb00000205400ULL,
0x0000003100c27306ULL, 0x000ff00000009400ULL, 0x0000003100c17306ULL, 0x000fe20000005400ULL,
0x000000f3f200720bULL, 0x004fce0003f5d000ULL, 0x0000003100137306ULL, 0x0005f0000000d400ULL,
0x0000003000bb7306ULL, 0x000fe20000009400ULL, 0x0001000031317824ULL, 0x004fe200078e00ffULL,
0x00000018ff877819ULL, 0x002fc4000001145dULL, 0x00000018ff927819ULL, 0x000fe4000001145fULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003000c07306ULL, 0x000ff00000005400ULL,
0x0000003000637306ULL, 0x0003f0000000d400ULL, 0x0000005a007c7306ULL, 0x000fe20000209400ULL,
0x0001000030307824ULL, 0x002fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000005a00eb7306ULL, 0x000e700000205400ULL, 0x0000005a00b07306ULL, 0x000eb0000020d400ULL,
0x0000006200c37306ULL, 0x000fe20000209400ULL, 0x000000eb7c00720bULL, 0x002fce0003fbd000ULL,
0x0000006200c47306ULL, 0x000fec0000205400ULL, 0x00000001b0b05812ULL, 0x004fe400078efcffULL,
0x00000062005a7306ULL, 0x000fe2000020d400ULL, 0x000000e7e400720bULL, 0x000fce0003fbd000ULL,
0x00000066009b7306ULL, 0x000fec0000209400ULL, 0x00000001a8a85812ULL, 0x000fe400078efcffULL,
0x00000066009a7306ULL, 0x000ff00000205400ULL, 0x0000006600627306ULL, 0x0003f0000020d400ULL,
0x0000003200ba7306ULL, 0x000fe20000009400ULL, 0x0000010032667824ULL, 0x002fca00078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe40000011466ULL, 0x0000003200bd7306ULL, 0x000e700000005400ULL,
0x0000003200197306ULL, 0x0004f0000000d400ULL, 0x0000006500c67306ULL, 0x000f22000020d400ULL,
0x0001000032327824ULL, 0x004fe200078e00ffULL, 0x000000bdba00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003100b47306ULL, 0x000fee0000209400ULL,
0x0000000119196812ULL, 0x008fe200078efcffULL, 0x0000003100b57306ULL, 0x000fe20000205400ULL,
0x00000001c6c62812ULL, 0x010fc400078efcffULL, 0x000000e88300720bULL, 0x000fe40003f5d000ULL,
0x00000091c691723eULL, 0x000fc600000010ffULL, 0x0000003100677306ULL, 0x0003f0000020d400ULL,
0x0000003000c77306ULL, 0x000fe20000209400ULL, 0x00000018ff317819ULL, 0x002fe4000001145cULL,
0x00000001b7b72812ULL, 0x000fc400078efcffULL, 0x000000e38a00720bULL, 0x000fc60003f5d000ULL,
0x0000003000c87306ULL, 0x000ff00000205400ULL, 0x0000003000657306ULL, 0x0003e4000020d400ULL,
0x00000001afaf2812ULL, 0x000fcc00078efcffULL, 0x0000003300be7306ULL, 0x000fe20000009400ULL,
0x0000010033307824ULL, 0x002fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003300b97306ULL, 0x000ff00000005400ULL, 0x0000003300147306ULL, 0x0003f0000000d400ULL,
0x00000031006c7306ULL, 0x000fe20000209400ULL, 0x0001000033337824ULL, 0x002fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x00000031006d7306ULL, 0x000ff00000205400ULL,
0x00000031006e7306ULL, 0x0003f0000020d400ULL, 0x00000032009c7306ULL, 0x000fe20000209400ULL,
0x0000010035317824ULL, 0x002fce00078e00ffULL, 0x00000032009d7306ULL, 0x000e700000205400ULL,
0x00000032006a7306ULL, 0x0004f0000020d400ULL, 0x00000087006f7306ULL, 0x000fe20000209400ULL,
0x00000018ff327819ULL, 0x004fc4000001145eULL, 0x0000009d9c00720bULL, 0x002fca0003fdd000ULL,
0x0000008700707306ULL, 0x000ff00000205400ULL, 0x0000008700717306ULL, 0x0003e2000020d400ULL,
0x000000016a6a6812ULL, 0x008fce00078efcffULL, 0x0000003000a67306ULL, 0x000fe20000209400ULL,
0x00000018ff877819ULL, 0x002fce0000011431ULL, 0x0000003000a77306ULL, 0x000ff00000205400ULL,
0x0000003000697306ULL, 0x0003f0000020d400ULL, 0x0000006b00ac7306ULL, 0x000fe20000209400ULL,
0x0000010034307824ULL, 0x002fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000006b00ad7306ULL, 0x000ff00000205400ULL, 0x0000006b00667306ULL, 0x000ff0000020d400ULL,
0x0000003300887306ULL, 0x000ff00000209400ULL, 0x00000033008b7306ULL, 0x000ff00000205400ULL,
0x00000033006b7306ULL, 0x000ff0000020d400ULL, 0x0000003200747306ULL, 0x000ff00000209400ULL,
0x0000003200757306ULL, 0x000ff00000205400ULL, 0x0000003200767306ULL, 0x000ff0000020d400ULL,
0x0000008700327306ULL, 0x000ff00000209400ULL, 0x0000008700337306ULL, 0x000e700000205400ULL,
0x00000034008d7306ULL, 0x000ff00000009400ULL, 0x0000003400da7306ULL, 0x000ea20000005400ULL,
0x000000333200720bULL, 0x002fe20003f9d000ULL, 0x000001005d327824ULL, 0x000fcc00078e00ffULL,
0x0000003400857306ULL, 0x0002f0000000d400ULL, 0x0000003000f07306ULL, 0x000fe20000209400ULL,
0x0001000034347824ULL, 0x002fe200078e00ffULL, 0x000000da8d00720bULL, 0x004fc40003f1d000ULL,
0x00000018ffda7819ULL, 0x000fe20000011432ULL, 0x0000080007327824ULL, 0x000fe200078e02eaULL,
0x00000018ff317819ULL, 0x000fe40000011434ULL, 0x0000003000f17306ULL, 0x000e6e0000205400ULL,
0x0000000185850812ULL, 0x008fe200078efcffULL, 0x00000030009e7306ULL, 0x0004f0000020d400ULL,
0x0000008700a17306ULL, 0x0008e2000020d400ULL, 0x0000010036307824ULL, 0x004fe200078e00ffULL,
0x000000f1f000720bULL, 0x002fcc0003f5d000ULL, 0x0000003100347306ULL, 0x000fe20000209400ULL,
0x00000018ff877819ULL, 0x010fcc0000011430ULL, 0x000000019e9e2812ULL, 0x008fe200078efcffULL,
0x0000003100ed7306ULL, 0x000e620000205400ULL, 0x00000001a1a14812ULL, 0x000fce00078efcffULL,
0x0000003100a07306ULL, 0x000eb0000020d400ULL, 0x0000003500817306ULL, 0x000fe20000009400ULL,
0x000000ed3400720bULL, 0x002fce0003f5d000ULL, 0x0000003500827306ULL, 0x000e6c0000005400ULL,
0x00000001a0a02812ULL, 0x004fe400078efcffULL, 0x0000003600307306ULL, 0x000ff00000009400ULL,
0x0000003600317306ULL, 0x000ea20000005400ULL, 0x000000828100720bULL, 0x002fce0003fbd000ULL,
0x0000003500847306ULL, 0x0002f0000000d400ULL, 0x0000003600937306ULL, 0x000922000000d400ULL,
0x0001000035357824ULL, 0x002fe200078e00ffULL, 0x000000313000720bULL, 0x004fc40003f9d000ULL,
0x009000003230783bULL, 0x000e640000000200ULL, 0x00000018ff947819ULL, 0x000fe40000011435ULL,
0x0000008700d27306ULL, 0x000fe20000209400ULL, 0x0000000184845812ULL, 0x008fe200078efcffULL,
0x000001005c367824ULL, 0x010fca00078e00ffULL, 0x00000018ffe27819ULL, 0x000fe20000011436ULL,
0x0000008700d37306ULL, 0x000ea20000205400ULL, 0x0000000193934812ULL, 0x000fe400078efcffULL,
0x000000cccb00720bULL, 0x000fca0003f9d000ULL, 0x0000003700d87306ULL, 0x000ff00000009400ULL,
0x0000003700d97306ULL, 0x000ee20000005400ULL, 0x000000d3d200720bULL, 0x004fe40003fbd000ULL,
0x000000017d7d4812ULL, 0x000fc400078efcffULL, 0x000000d0cf00720bULL, 0x000fc60003f9d000ULL,
0x0000003700957306ULL, 0x000530000000d400ULL, 0x0000009400357306ULL, 0x000fe20000209400ULL,
0x0001000037377824ULL, 0x004fe200078e00ffULL, 0x000000d9d800720bULL, 0x008fc40003f5d000ULL,
0x0000000164644812ULL, 0x000fe400078efcffULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000009400ee7306ULL, 0x000ea20000205400ULL, 0x000000c8c700720bULL, 0x000fcc0003f9d000ULL,
0x0000000195952812ULL, 0x010fe200078efcffULL, 0x0000009200777306ULL, 0x000fe20000209400ULL,
0x000000c0bb00720bULL, 0x000fca0003f5d000ULL, 0x0000000165654812ULL, 0x000fe400078efcffULL,
0x0000009200787306ULL, 0x000fe20000205400ULL, 0x000000ee3500720bULL, 0x004fe40003f1d000ULL,
0x000000adac00720bULL, 0x000fc60003f9d000ULL, 0x0000000163632812ULL, 0x000fe400078efcffULL,
0x0000009200797306ULL, 0x000fe2000020d400ULL, 0x000000b3b200720bULL, 0x000fce0003f5d000ULL,
0x0000008700927306ULL, 0x000ea2000020d400ULL, 0x0000000166664812ULL, 0x000fc800078efcffULL,
0x000000196666723eULL, 0x000fe400000010ffULL, 0x0000000160602812ULL, 0x000fe200078efcffULL,
0x000000f800d67306ULL, 0x000fe20000209400ULL, 0x000000a7a600720bULL, 0x000fce0003f5d000ULL,
0x000000f800d77306ULL, 0x000ee20000205400ULL, 0x0000000192925812ULL, 0x004fc800078efcffULL,
0x000000939292723eULL, 0x000fe400000010ffULL, 0x0000000169692812ULL, 0x000fe200078efcffULL,
0x0000003700e57306ULL, 0x000ff00000209400ULL, 0x0000003700e67306ULL, 0x000ea20000205400ULL,
0x000000d7d600720bULL, 0x008fce0003f7d000ULL, 0x00000094009f7306ULL, 0x000ef0000020d400ULL,
0x000000f900d47306ULL, 0x000fe20000209400ULL, 0x000000e6e500720bULL, 0x004fce0003fbd000ULL,
0x000000f900d57306ULL, 0x000ea20000205400ULL, 0x000000019f9f0812ULL, 0x008fce00078efcffULL,
0x00000037008a7306ULL, 0x000730000020d400ULL, 0x000000f800877306ULL, 0x000e62000020d400ULL,
0x00900000d134783bULL, 0x008ee20000000200ULL, 0x000000d5d400720bULL, 0x004fcc0003f1d000ULL,
0x000000f900947306ULL, 0x000ea2000020d400ULL, 0x000000018a8a5812ULL, 0x010fe400078efcffULL,
0x000000cecd00720bULL, 0x000fe40003fbd000ULL, 0x0000000187873812ULL, 0x002fc600078efcffULL,
0x0000005c00a37306ULL, 0x000fe20000009400ULL, 0x000000c1c200720bULL, 0x000fe40003f7d000ULL,
0x0000000194940812ULL, 0x004fca00078efcffULL, 0x0000005c00a47306ULL, 0x000e620000005400ULL,
0x000000ff9000720cULL, 0x000fe40003f05270ULL, 0x0000000168685812ULL, 0x000fe400078efcffULL,
0x000000c4c300720bULL, 0x000fe40003fbd000ULL, 0x0000000113133812ULL, 0x000fe200078efcffULL,
0x0000005c007a7306ULL, 0x000522000000d400ULL, 0x000000b5b400720bULL, 0x000fe40003f7d000ULL,
0x000000b8c590723eULL, 0x000fc400000010ffULL, 0x000000959493723eULL, 0x000fe200000010ffULL,
0x000000bf30308231ULL, 0x080fe400003400ffULL, 0x0000005d00967306ULL, 0x000fe20000009400ULL,
0x000100005c5c7824ULL, 0x004fe200078e00ffULL, 0x000000bf34348231ULL, 0x088fe200003400ffULL,
0x000000015a5a5812ULL, 0x000fe200078efcffULL, 0x000000bf36368231ULL, 0x080fe200003400ffULL,
0x000000989900720bULL, 0x000fe20003fbd000ULL, 0x000000bc35358231ULL, 0x080fe200003400ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000005d00977306ULL, 0x000ea20000005400ULL,
0x000000bc37378231ULL, 0x080fe200003400ffULL, 0x0000000167673812ULL, 0x000fe200078efcffULL,
0x000000bf32328231ULL, 0x000fe200003400ffULL, 0x0000009a9b00720bULL, 0x000fe20003f7d000ULL,
0x000000bc31318231ULL, 0x080fe200003400ffULL, 0x000000a4a300720bULL, 0x002fe20003f9d000ULL,
0x000000bc33338231ULL, 0x000fe200003400ffULL, 0x0000005d007b7306ULL, 0x0003e2000000d400ULL,
0x000000903454723cULL, 0x000fe20000041854ULL, 0x000000b9be00720bULL, 0x000fc40003f1d000ULL,
0x0000000161615812ULL, 0x000fc800078efcffULL, 0x0000005c00c97306ULL, 0x000fe20000209400ULL,
0x000100005d5d7824ULL, 0x002fe200078e00ffULL, 0x000000abae90723eULL, 0x000fe200000010ffULL,
0x000001005e917824ULL, 0x000fe200078e00ffULL, 0x0000000162623812ULL, 0x000fe200078efcffULL,
0x000100005eae7824ULL, 0x000fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe2000001145dULL,
0x00000092343c723cULL, 0x000fe2000004183cULL, 0x0000005c00c07306ULL, 0x000e620000205400ULL,
0x000000b7b05d723eULL, 0x000fe400000010ffULL, 0x00000018ffab7819ULL, 0x000fc40000011491ULL,
0x000000aaaf91723eULL, 0x000fe200000010ffULL, 0x000100005faf7824ULL, 0x000fe200078e00ffULL,
0x000000017a7a4812ULL, 0x010fe200078efcffULL, 0x0000005c00bb7306ULL, 0x000722000020d400ULL,
0x000000979600720bULL, 0x004fe40003f5d000ULL, 0x0000000114140812ULL, 0x000fe200078efcffULL,
0x00000090344c723cULL, 0x000fe2000004184cULL, 0x00000018ffae7819ULL, 0x000fe400000114aeULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x000000e2008c7306ULL, 0x000fe20000209400ULL,
0x000000b6b15c723eULL, 0x008fc400000010ffULL, 0x000000c0c900720bULL, 0x002fe40003f9d000ULL,
0x0000008b8800720bULL, 0x000fe40003f1d000ULL, 0x000000017b7b2812ULL, 0x000fe200078efcffULL,
0x000000e2008d7306ULL, 0x000e620000205400ULL, 0x0000005c3450723cULL, 0x000fe20000041850ULL,
0x000000706f00720bULL, 0x000fe40003f5d000ULL, 0x0000006a616a723eULL, 0x000fc800000010ffULL,
0x000000da00827306ULL, 0x000fe20000209400ULL, 0x000000a8a55c723eULL, 0x000fe400000010ffULL,
0x000000a9a25d723eULL, 0x000fe400000010ffULL, 0x00000001bbbb4812ULL, 0x010fe400078efcffULL,
0x000000016b6b0812ULL, 0x000fe200078efcffULL, 0x000000da00d37306ULL, 0x000ea20000205400ULL,
0x0000008d8c00720bULL, 0x002fe20003fbd000ULL, 0x0000005c3448723cULL, 0x000fe20000041848ULL,
0x0000000171712812ULL, 0x000fc400078efcffULL, 0x0000006b626b723eULL, 0x000fc600000010ffULL,
0x0000005e00867306ULL, 0x000fe20000009400ULL, 0x000000859e5c723eULL, 0x000fe400000010ffULL,
0x00000084a15d723eULL, 0x000fca00000010ffULL, 0x0000005e00897306ULL, 0x000e620000005400ULL,
0x000000d38200720bULL, 0x004fe20003f7d000ULL, 0x0000005c3444723cULL, 0x000fec0000041844ULL,
0x0000005e007c7306ULL, 0x0005e2000000d400ULL, 0x000000877e5c723eULL, 0x000fe200000010ffULL,
0x0000006a3048723cULL, 0x000fe20000041848ULL, 0x0000008a7d5d723eULL, 0x000fca00000010ffULL,
0x000000e200817306ULL, 0x000ee2000020d400ULL, 0x000001005f5e7824ULL, 0x004fe200078e00ffULL,
0x0000005c3438723cULL, 0x000fe20000041838ULL, 0x000000898600720bULL, 0x002fc60003fdd000ULL,
0x00000018ff847819ULL, 0x000fe4000001145eULL, 0x000000da00ca7306ULL, 0x000e62000020d400ULL,
0x000000a08f5e723eULL, 0x000fce00000010ffULL, 0x000000bd00ba7306ULL, 0x000fe20000209400ULL,
0x0000000181815812ULL, 0x008fe400078efcffULL, 0x0000006d6c00720bULL, 0x000fe40003fbd000ULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x0000007a817a723eULL, 0x000fe200000010ffULL,
0x000000bd00b97306ULL, 0x000ea20000205400ULL, 0x00000001caca3812ULL, 0x002fc800078efcffULL,
0x0000007bca7b723eULL, 0x000fc600000010ffULL, 0x000000ab00aa7306ULL, 0x000fe20000209400ULL,
0x000000016e6e5812ULL, 0x000fe400078efcffULL, 0x000000757400720bULL, 0x000fe20003fbd000ULL,
0x0000007a3044723cULL, 0x000fe20000041844ULL, 0x000000bb6e6e723eULL, 0x000fc600000010ffULL,
0x000000ab00917306ULL, 0x000e620000205400ULL, 0x000000b9ba00720bULL, 0x004fce0003f7d000ULL,
0x0000005f00807306ULL, 0x000fe20000009400ULL, 0x0000000176765812ULL, 0x000fce00078efcffULL,
0x0000005f00837306ULL, 0x000ea20000005400ULL, 0x00000091aa00720bULL, 0x002fce0003f9d000ULL,
0x0000005f007f7306ULL, 0x0003f0000000d400ULL, 0x000000bd00b07306ULL, 0x000ee2000020d400ULL,
0x0000009f8e5f723eULL, 0x002fe400000010ffULL, 0x000000838000720bULL, 0x004fca0003f1d000ULL,
0x0000005e3440723cULL, 0x000fe20000041840ULL, 0x000000ab00997306ULL, 0x000e6c000020d400ULL,
0x000000676035723eULL, 0x000fe400000010ffULL, 0x000000146967723eULL, 0x000fe200000010ffULL,
0x0000008400857306ULL, 0x000fe20000209400ULL, 0x000000655a34723eULL, 0x000fc400000010ffULL,
0x00000013645f723eULL, 0x000fe400000010ffULL, 0x00000001b0b03812ULL, 0x008fe200078efcffULL,
0x00000066304c723cULL, 0x040fe2000004184cULL, 0x0000000199994812ULL, 0x002fe200078efcffULL,
0x0000008400887306ULL, 0x000e620000205400ULL, 0x000000787700720bULL, 0x000fe40003f7d000ULL,
0x000000017f7f0812ULL, 0x000fe400078efcffULL, 0x00000063685e723eULL, 0x000fe200000010ffULL,
0x000000343050723cULL, 0x000fe20000041850ULL, 0x000000b0716f723eULL, 0x000fe200000010ffULL,
0x000000ae007d7306ULL, 0x000fe20000209400ULL, 0x0000007c997c723eULL, 0x000fca00000010ffULL,
0x0000000179793812ULL, 0x000fe200078efcffULL, 0x0000005e3054723cULL, 0x000fe20000041854ULL,
0x000000ae00367306ULL, 0x000ea20000205400ULL, 0x000000888500720bULL, 0x002fcc0003f5d000ULL,
0x0000006e3040723cULL, 0x000fe20000041840ULL, 0x000000af00377306ULL, 0x000ff00000209400ULL,
0x000000af00147306ULL, 0x000e620000205400ULL, 0x000000367d00720bULL, 0x004fce0003f9d000ULL,
0x0000008400867306ULL, 0x000eb0000020d400ULL, 0x000000ae00137306ULL, 0x000ee2000020d400ULL,
0x000000143700720bULL, 0x002fce0003fdd000ULL, 0x000000af00347306ULL, 0x000e62000020d400ULL,
0x0000000186862812ULL, 0x004fc800078efcffULL, 0x0000007f867d723eULL, 0x000fe400000010ffULL,
0x0000000113134812ULL, 0x008fc800078efcffULL, 0x000000137676723eULL, 0x000fe200000010ffULL,
0x0000007c303c723cULL, 0x000fe2000004183cULL, 0x0000000134346812ULL, 0x002fc800078efcffULL,
0x000000347977723eULL, 0x000fce00000010ffULL, 0x000000763038723cULL, 0x000fe20000041838ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200016307f8cULL, 0x0002a2000c80043fULL,
0xfffffff859597812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000401c147810ULL, 0x000fe20007ffe0ffULL, 0x00f6880059ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff197224ULL, 0x000fe200078e0073ULL, 0x0000000115157812ULL, 0x000fe400078e0cffULL,
0x000000031400720cULL, 0x000fda0003f06070ULL, 0x0000893000000947ULL, 0x000fea0003800000ULL,
0x0000040017147984ULL, 0x008ee40000000800ULL, 0x8000000014ff7812ULL, 0x00cfe40007804831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000240016147984ULL, 0x000ea40000000800ULL,
0x8000000014ff7812ULL, 0x004fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL,
0x0000000b000d7305ULL, 0x0004e4000021f000ULL, 0x3fa000000b0b7823ULL, 0x004fe200000100ffULL,
0x0000000d0000735dULL, 0x008fe20003800000ULL, 0x0000240016147984ULL, 0x000ea40000000800ULL,
0x8000000014ff7812ULL, 0x004fc40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000035b0b7812ULL, 0x000fe200078ec0ffULL, 0x000058000a197a24ULL, 0x020fe200078e02ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011600ULL, 0xffffffffff0a7424ULL, 0x000fe200078e00ffULL,
0x000000030b00780cULL, 0x000fc80003f05270ULL, 0x0000000109147807ULL, 0x000fca0004000000ULL,
0x000000015b5b7824ULL, 0x000fca00078e0214ULL, 0x000000035b0b7812ULL, 0x000fc800078ec0ffULL,
0x000000030b00780cULL, 0x000fc80003f05270ULL, 0x00000001095a7807ULL, 0x000fca0004000000ULL,
0x000000015b0b7824ULL, 0x000fca00078e025aULL, 0x000000040b00720cULL, 0x000fe20003f06070ULL,
0x000000200d307824ULL, 0x000fe200078e021cULL, 0x0000000105137810ULL, 0x000fc80007ffe0ffULL,
0x0000008030307810ULL, 0x000fce0007ffe0ffULL, 0x0000005a18148210ULL, 0x000fe20007ffe05bULL,
0x00000004ff158424ULL, 0x000fc800078e00ffULL, 0x0000600014148625ULL, 0x000fca00078e0015ULL,
0x00000006140a8981ULL, 0x000562000c1e1900ULL, 0x000000061300720cULL, 0x000fe20003f06070ULL,
0x0000004019357824ULL, 0x000fe200078e00ffULL, 0x0000003003137217ULL, 0x000fe20007800000ULL,
0x000000081a647824ULL, 0x000fe200078e00ffULL, 0xfffffff008317812ULL, 0x000fe200078ec0ffULL,
0x000010001a677824ULL, 0x000fe200078e00ffULL, 0x00000003ff607819ULL, 0x000fe20000011602ULL,
0x0000000113137824ULL, 0x100fe200078e0a30ULL, 0x0000000864657812ULL, 0x000fe200078ec0ffULL,
0x0000001000157824ULL, 0x004fe200078e00ffULL, 0x000000200f147812ULL, 0x000fc400078ef830ULL,
0x0000002013137807ULL, 0x000fe40000000000ULL, 0x0000001015347812ULL, 0x000fe200078ec0ffULL,
0x000000011d197824ULL, 0x100fe200078e0214ULL, 0x0000f6a831317810ULL, 0x000fe20007ffe0ffULL,
0x000000011b157824ULL, 0x100fe200078e0214ULL, 0x0000000865667812ULL, 0x000fe200078e3cffULL,
0x000000011f307824ULL, 0x100fe200078e0214ULL, 0x0000001935197210ULL, 0x000fe20007f5e0ffULL,
0x0000000121147824ULL, 0x000fe200078e0214ULL, 0x0000001535157210ULL, 0x000fe20007f1e0ffULL,
0x0000000131657824ULL, 0x000fe200078e0265ULL, 0x0000003035337210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x0000001334137217ULL, 0x000fe20007800000ULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x00005e00195c7a11ULL, 0x000fe200078438ffULL,
0x0000000131667824ULL, 0x000fe200078e0266ULL, 0x0000001435357210ULL, 0x000fe20007f9e0ffULL,
0x0000000113137824ULL, 0x000fe200078e0a34ULL, 0x00005e00155e7a11ULL, 0x000fe200078038ffULL,
0x000000ffff367224ULL, 0x000fe200018e06ffULL, 0x0000100067147812ULL, 0x000fe200078ec0ffULL,
0x00000000650473c2ULL, 0x000ea200000e0000ULL, 0x00005f0019317a11ULL, 0x000fe200010f3c30ULL,
0x000000ffff307224ULL, 0x000fe200020e06ffULL, 0x00005f0015377a11ULL, 0x000fe200000f3c32ULL,
0x000020000d157824ULL, 0x000fe200078e0214ULL, 0x00005e0035347a11ULL, 0x000fc400078438ffULL,
0x000000136000720cULL, 0x000fe40003f86070ULL, 0x00005e0033327a11ULL, 0x000fe400078038ffULL,
0x00005f0035357a11ULL, 0x000fe400010f3c30ULL, 0x000000295e147210ULL, 0x000fe40007f5e0ffULL,
0x0000b00015197810ULL, 0x000fe40007ffe0ffULL, 0x0000000860307810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200010e0637ULL, 0x00005f0033337a11ULL, 0x000fe200000f3c36ULL,
0x000000101e377824ULL, 0x100fe200078e0219ULL, 0x0000000460367810ULL, 0x000fe20007ffe0ffULL,
0x00000010225d7824ULL, 0x000fe200078e0219ULL, 0x0000000c60607810ULL, 0x000fc40007ffe0ffULL,
0x000000133000720cULL, 0x000fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014377faeULL, 0x0007e2000e101c46ULL, 0x000000295c307210ULL, 0x000fe40007fbe0ffULL,
0x000000133600720cULL, 0x080fe40003f06070ULL, 0x000000136000720cULL, 0x000fe20003f46070ULL,
0x000000ffff317224ULL, 0x000fe200028e0631ULL, 0x0000002932327210ULL, 0x080fe20007f9e0ffULL,
0x0000001020137824ULL, 0x100fe200078e0219ULL, 0x0000002934347210ULL, 0x000fe20007fbe0ffULL,
0x0000001023197824ULL, 0x000fc400078e0219ULL, 0x000000ffff337224ULL, 0x000fe400020e0633ULL,
0x000000ffff357224ULL, 0x000fe400028e0635ULL, 0x0000000030137faeULL, 0x0009e8000c101c46ULL,
0x00000000325d7faeULL, 0x0009e8000d901c46ULL, 0x0000000034197faeULL, 0x0009e8000d101c46ULL,
0x0000000000007918ULL, 0x008fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x004fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000065147f8cULL, 0x0004e8000c80043fULL, 0x0000040066137984ULL, 0x0105220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280028307f8cULL, 0x000fe2000c80043fULL, 0x8000000013ff7812ULL, 0x010fc60007844873ULL,
0x00f62c0028197984ULL, 0x000f240000000800ULL, 0x8000000019ff7812ULL, 0x010fe40007804831ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff197224ULL, 0x008fe200078e0015ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe008287812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff137424ULL, 0x000fe200078e00ffULL,
0x0000001008157812ULL, 0x040fe400078ec0ffULL, 0x0000000808147812ULL, 0x000fc800078ec0ffULL,
0x0000002814287210ULL, 0x000fe40007ffe015ULL, 0x0000001300147305ULL, 0x000724000021f000ULL,
0x3fa0000013137823ULL, 0x008fe200000100ffULL, 0x000000140000735dULL, 0x010fe20003800000ULL,
0x00f62c0028157984ULL, 0x000ee40000000800ULL, 0x8000000015ff7812ULL, 0x008fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000137824ULL, 0x000fca00078e00ffULL,
0xffffff8013147812ULL, 0x000fc800078ec0ffULL, 0x0000008029137810ULL, 0x000fca0007ffe014ULL,
0x000000012a137824ULL, 0x000fca00078e0213ULL, 0x00f0000013147984ULL, 0x000ee80000000800ULL,
0x00f2000013157984ULL, 0x0008620000000800ULL, 0x000000111400720bULL, 0x008fe20003f1d000ULL,
0x00011bd27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x010fc800000e0100ULL,
0x0000ffff13347812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ffe27424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000107137810ULL, 0x000fe40007ffe0ffULL, 0x000000111400720bULL, 0x000fe40003f14000ULL,
0x000000001300720cULL, 0x000fe20003f65270ULL, 0x00011ba27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000137806ULL, 0x000fe400000e0100ULL, 0x0000001411377209ULL, 0x000fe20007810000ULL,
0x000000800031b824ULL, 0x000fe200078e0229ULL, 0x0000ffff13137812ULL, 0x000fc600078e3cffULL,
0x000000012a30b824ULL, 0x000fe200078e0231ULL, 0x0000001334ff7212ULL, 0x000fe2000780c0ffULL,
0x8000003711117221ULL, 0x000fe20000010000ULL, 0x00000002ff347819ULL, 0x000fe40000011602ULL,
0x00f400373000b388ULL, 0x0007e20000000800ULL, 0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL,
0x0000001100337308ULL, 0x000f240000000800ULL, 0x0000003312127220ULL, 0x010fe20000410000ULL,
0x00011b327f007947ULL, 0x000fea000b800000ULL, 0x00001f3433117589ULL, 0x00872400000e0000ULL,
0x0000001154547220ULL, 0x090fe40000410000ULL, 0x0000001155557220ULL, 0x080fe40000410000ULL,
0x0000001150507220ULL, 0x080fe40000410000ULL, 0x0000001151517220ULL, 0x080fe40000410000ULL,
0x000000114c4c7220ULL, 0x000fc40000410000ULL, 0x000000114d4d7220ULL, 0x080fe40000410000ULL,
0x0000001148487220ULL, 0x080fe40000410000ULL, 0x0000001149497220ULL, 0x080fe40000410000ULL,
0x0000001144447220ULL, 0x080fe40000410000ULL, 0x0000001145457220ULL, 0x080fe40000410000ULL,
0x0000001140407220ULL, 0x000fc40000410000ULL, 0x0000001141417220ULL, 0x080fe40000410000ULL,
0x000000113c3c7220ULL, 0x080fe40000410000ULL, 0x000000113d3d7220ULL, 0x080fe40000410000ULL,
0x0000001138387220ULL, 0x080fe40000410000ULL, 0x0000001139397220ULL, 0x000fe20000410000ULL,
0x00011a727f007947ULL, 0x000fea000b800000ULL, 0x00001f2c33117589ULL, 0x0008a400000e0000ULL,
0x8000003714140221ULL, 0x000fe20000010000ULL, 0x00000001ffe27807ULL, 0x000fe20000000000ULL,
0x0000001156567220ULL, 0x004fc40000410000ULL, 0x3fb8aa3b14140820ULL, 0x000fe40000410000ULL,
0x0000001157577220ULL, 0x080fe40000410000ULL, 0x00000014002b0308ULL, 0x000ea20000000800ULL,
0x0000001152527220ULL, 0x080fe40000410000ULL, 0x0000001153537220ULL, 0x080fe40000410000ULL,
0x000000114e4e7220ULL, 0x080fe40000410000ULL, 0x000000114f4f7220ULL, 0x000fc40000410000ULL,
0x000000114a4a7220ULL, 0x080fe40000410000ULL, 0x000000114b4b7220ULL, 0x080fe40000410000ULL,
0x0000001146467220ULL, 0x080fe40000410000ULL, 0x0000001147477220ULL, 0x080fe40000410000ULL,
0x0000001142427220ULL, 0x080fe40000410000ULL, 0x0000001143437220ULL, 0x000fc40000410000ULL,
0x000000113e3e7220ULL, 0x080fe40000410000ULL, 0x000000113f3f7220ULL, 0x080fe40000410000ULL,
0x000000113a3a7220ULL, 0x080fe40000410000ULL, 0x000000113b3b7220ULL, 0x000fe40000410000ULL,
0x000000ffff117224ULL, 0x000fe400078e0037ULL, 0x000000152b150220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000001215127221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x000000081a137824ULL, 0x000fe200078e00ffULL, 0xfffffff008147812ULL, 0x000fc800078ec0ffULL,
0x0000000813137812ULL, 0x000fca00078e0cffULL, 0x0000000114147824ULL, 0x000fca00078e0213ULL,
0x00f6ac0014137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804873ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff137424ULL, 0x000fc800078e00ffULL, 0x0000001300157305ULL, 0x0002a4000021f000ULL,
0x3fa0000013137823ULL, 0x002fe200000100ffULL, 0x000000150000735dULL, 0x004fe40003800000ULL,
0x00f6ac0014157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc40007804873ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff347819ULL, 0x008fe40000011602ULL,
0x0000002bff15723eULL, 0x000fe400000010ffULL, 0x0000001834137810ULL, 0x040fe40007ffe0ffULL,
0x0000001034147810ULL, 0x000fe40007ffe0ffULL, 0x0000541015337816ULL, 0x010fe20000000015ULL,
0x000117c27f007947ULL, 0x000fea000b800000ULL, 0x00001f3433c97589ULL, 0x0002e400000e0000ULL,
0x000118027f007947ULL, 0x000fea000b800000ULL, 0x00001f2c33927589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff347224ULL, 0x002fe200078e0014ULL,
0x0000512000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x000123c000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff347224ULL, 0x002fe200078e0013ULL,
0x0000518000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0001236000007944ULL, 0x03cfea0003c00000ULL,
0x000010001a137824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100000147824ULL, 0x000fe200078e00ffULL, 0x00009910e2e27816ULL, 0x000fe400000000ffULL,
0x0000100013137812ULL, 0x000fe400078e0cffULL, 0xffffe00014147812ULL, 0x000fc400078ec0ffULL,
0x0000b000105f7810ULL, 0x100fe40007ffe013ULL, 0x0000b00014147810ULL, 0x000fc60007ffe013ULL,
0x000000102e137824ULL, 0x000fe400078e025fULL, 0x000000102d687824ULL, 0x100fe400078e0214ULL,
0x000000102f697824ULL, 0x000fe200078e0214ULL, 0x000000001360783bULL, 0x000f280000004200ULL,
0x000000006830783bULL, 0x016e680000004200ULL, 0x000000006934783bULL, 0x000ea20000004200ULL,
0x00000018ff727819ULL, 0x000fe20000011462ULL, 0x0000006100c87306ULL, 0x000fe20000009400ULL,
0x00000018ff6e7819ULL, 0x000fc40000011460ULL, 0x00000018ff147819ULL, 0x002fe20000011430ULL,
0x00000100307e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011431ULL,
0x00000018ff5d7819ULL, 0x000fe20000011432ULL, 0x0000001400f97306ULL, 0x000fe20000209400ULL,
0x00000018ff5e7819ULL, 0x000fe40000011433ULL, 0x00000018ff6c7819ULL, 0x004fe40000011436ULL,
0x00000018ff7e7819ULL, 0x000fc4000001147eULL, 0x00000018ff6a7819ULL, 0x000fe20000011434ULL,
0x0000001400f77306ULL, 0x000e620000205400ULL, 0x00000018ff6b7819ULL, 0x000fe40000011435ULL,
0x00000018ff6f7819ULL, 0x000fe40000011461ULL, 0x00000018ff6d7819ULL, 0x000fe40000011437ULL,
0x00000018ff757819ULL, 0x000fe20000011463ULL, 0x0000001400be7306ULL, 0x000530000020d400ULL,
0x0000005c00f87306ULL, 0x000fe20000209400ULL, 0x0000001058147824ULL, 0x004fe200078e025fULL,
0x000000f7f900720bULL, 0x002fcc0003fbd000ULL, 0x0000005c00877306ULL, 0x000fee0000205400ULL,
0x00000001bebe5812ULL, 0x010fe200078efcffULL, 0x0000005c00ba7306ULL, 0x000ff0000020d400ULL,
0x0000005d00887306ULL, 0x000ff00000209400ULL, 0x0000005d00917306ULL, 0x000ff00000205400ULL,
0x0000005d00ae7306ULL, 0x000ff0000020d400ULL, 0x0000005e00947306ULL, 0x000ff00000209400ULL,
0x0000005e00897306ULL, 0x000ff00000205400ULL, 0x0000005e00aa7306ULL, 0x0003f0000020d400ULL,
0x0000003000ac7306ULL, 0x000fe20000009400ULL, 0x00000000145c783bULL, 0x002e6e0000004200ULL,
0x0000003000817306ULL, 0x000eb00000005400ULL, 0x0000006c00d17306ULL, 0x000ff00000209400ULL,
0x0000006c00ce7306ULL, 0x000fe20000205400ULL, 0x00000081ac00720bULL, 0x004fce0003f5d000ULL,
0x0000006c007c7306ULL, 0x000ff0000020d400ULL, 0x00000072009d7306ULL, 0x000fe20000209400ULL,
0x00000018ff7f7819ULL, 0x002fe4000001145dULL, 0x00000018ff787819ULL, 0x000fc4000001145cULL,
0x00000018ff827819ULL, 0x000fe4000001145fULL, 0x00000018ff807819ULL, 0x000fe2000001145eULL,
0x00000072009e7306ULL, 0x000ff00000205400ULL, 0x00000072006c7306ULL, 0x000ff0000020d400ULL,
0x0000007f00717306ULL, 0x000ff00000209400ULL, 0x0000007f00727306ULL, 0x000ff00000205400ULL,
0x0000007f00737306ULL, 0x0003f0000020d400ULL, 0x0000003100f57306ULL, 0x000fe20000009400ULL,
0x00000100317f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000003100c27306ULL, 0x000e700000005400ULL, 0x0000003100937306ULL, 0x0005f0000000d400ULL,
0x0000003000c47306ULL, 0x0008e2000000d400ULL, 0x0001000031317824ULL, 0x004fe200078e00ffULL,
0x000000c2f500720bULL, 0x002fc80003fdd000ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000007e00a87306ULL, 0x000fe20000209400ULL, 0x0001000030307824ULL, 0x010fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000007e00857306ULL, 0x000e620000205400ULL,
0x00000001c4c42812ULL, 0x008fe400078efcffULL, 0x0000000193936812ULL, 0x000fca00078efcffULL,
0x0000003100f37306ULL, 0x000ff00000209400ULL, 0x0000003100b87306ULL, 0x000ea20000205400ULL,
0x00000085a800720bULL, 0x002fce0003f9d000ULL, 0x0000007e00cd7306ULL, 0x0002f0000020d400ULL,
0x0000003100bf7306ULL, 0x000922000020d400ULL, 0x00000100327e7824ULL, 0x002fe200078e00ffULL,
0x000000b8f300720bULL, 0x004fc80003f5d000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000003200bb7306ULL, 0x000fe20000009400ULL, 0x00000001cdcd4812ULL, 0x008fe200078efcffULL,
0x0000010034317824ULL, 0x010fcc00078e00ffULL, 0x0000003200867306ULL, 0x000e620000005400ULL,
0x00000001bfbf2812ULL, 0x000fe400078efcffULL, 0x000000918800720bULL, 0x000fca0003f5d000ULL,
0x0000003000fb7306ULL, 0x000ff00000209400ULL, 0x0000003000847306ULL, 0x000ea20000205400ULL,
0x00000086bb00720bULL, 0x002fe40003f9d000ULL, 0x00000001aeae2812ULL, 0x000fca00078efcffULL,
0x0000007e00f17306ULL, 0x000ff00000209400ULL, 0x0000007e00fa7306ULL, 0x000e620000205400ULL,
0x00000084fb00720bULL, 0x004fce0003f1d000ULL, 0x0000003200b47306ULL, 0x0004f0000000d400ULL,
0x0000003000c77306ULL, 0x0008e2000020d400ULL, 0x0001000032327824ULL, 0x004fe200078e00ffULL,
0x000000faf100720bULL, 0x002fc80003fbd000ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000007e00bd7306ULL, 0x0002a2000020d400ULL, 0x0000010033307824ULL, 0x010fe200078e00ffULL,
0x00000001b4b44812ULL, 0x008fc800078efcffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003500e77306ULL, 0x000fe20000009400ULL, 0x00000018ff7e7819ULL, 0x002fe40000011431ULL,
0x00000001c7c70812ULL, 0x000fe400078efcffULL, 0x00000087f800720bULL, 0x000fc60003f1d000ULL,
0x0000003500e67306ULL, 0x000e620000005400ULL, 0x00000001bdbd5812ULL, 0x004fe400078efcffULL,
0x000000899400720bULL, 0x000fca0003fbd000ULL, 0x0000003200a27306ULL, 0x000fe40000209400ULL,
0x00000001baba0812ULL, 0x000fcc00078efcffULL, 0x0000003200a37306ULL, 0x000ea20000205400ULL,
0x000000e6e700720bULL, 0x002fe40003f5d000ULL, 0x00000001aaaa5812ULL, 0x000fca00078efcffULL,
0x0000006a00967306ULL, 0x000ff00000209400ULL, 0x0000006a00e37306ULL, 0x000fe20000205400ULL,
0x000000a3a200720bULL, 0x004fce0003f9d000ULL, 0x0000006a009c7306ULL, 0x000ff0000020d400ULL,
0x0000006b00e47306ULL, 0x000ff00000209400ULL, 0x0000006b00e57306ULL, 0x000ff00000205400ULL,
0x0000006b00987306ULL, 0x000ff0000020d400ULL, 0x0000003000ed7306ULL, 0x000ff00000209400ULL,
0x0000003000f67306ULL, 0x000e700000205400ULL, 0x0000003000b57306ULL, 0x0004f0000020d400ULL,
0x0000003300ef7306ULL, 0x000fe20000009400ULL, 0x0000010035307824ULL, 0x004fe200078e00ffULL,
0x000000f6ed00720bULL, 0x002fcc0003f1d000ULL, 0x0000003300a07306ULL, 0x000fee0000005400ULL,
0x00000001b5b50812ULL, 0x008fe200078efcffULL, 0x0000003300b07306ULL, 0x0003f0000000d400ULL,
0x0000006e00c07306ULL, 0x000fe20000209400ULL, 0x0001000033337824ULL, 0x002fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000006e00c37306ULL, 0x000ff00000205400ULL,
0x0000006e006a7306ULL, 0x000ff0000020d400ULL, 0x0000006f00b67306ULL, 0x000ff00000209400ULL,
0x0000006f00b97306ULL, 0x000ff00000205400ULL, 0x0000006f006b7306ULL, 0x000ff0000020d400ULL,
0x00000078006e7306ULL, 0x000ff00000209400ULL, 0x00000078006f7306ULL, 0x000ff00000205400ULL,
0x0000007800707306ULL, 0x000ff0000020d400ULL, 0x0000003400f47306ULL, 0x000ff00000009400ULL,
0x0000003400a17306ULL, 0x000e700000005400ULL, 0x0000003400a67306ULL, 0x0004f0000000d400ULL,
0x0000006d009b7306ULL, 0x000fe20000209400ULL, 0x0001000034347824ULL, 0x004fe200078e00ffULL,
0x000000a1f400720bULL, 0x002fcc0003fdd000ULL, 0x0000006d00907306ULL, 0x000fee0000205400ULL,
0x00000001a6a66812ULL, 0x008fe200078efcffULL, 0x0000006d007b7306ULL, 0x000fe2000020d400ULL,
0x000000e5e400720bULL, 0x000fce0003fdd000ULL, 0x0000008200777306ULL, 0x000fec0000209400ULL,
0x0000000198986812ULL, 0x000fe400078efcffULL, 0x0000008200787306ULL, 0x000fe20000205400ULL,
0x000000ced100720bULL, 0x000fe20003fdd000ULL, 0x000001005ed17824ULL, 0x000fc400078e00ffULL,
0x000001005fce7824ULL, 0x000fc600078e00ffULL, 0x00000018ffd17819ULL, 0x000fe200000114d1ULL,
0x0000008200797306ULL, 0x0003e2000020d400ULL, 0x00000018ffce7819ULL, 0x000fca00000114ceULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x00000075008d7306ULL, 0x000fe20000209400ULL,
0x0000010036827824ULL, 0x002fca00078e00ffULL, 0x00000018ff827819ULL, 0x000fe40000011482ULL,
0x00000075008e7306ULL, 0x000ff00000205400ULL, 0x00000075006d7306ULL, 0x000ff0000020d400ULL,
0x0000008000747306ULL, 0x000ff00000209400ULL, 0x0000008000757306ULL, 0x000ff00000205400ULL,
0x0000008000767306ULL, 0x0003f0000020d400ULL, 0x0000003600e87306ULL, 0x000fe20000009400ULL,
0x00000018ff807819ULL, 0x002fce0000011430ULL, 0x0000003600957306ULL, 0x000ff00000005400ULL,
0x00000036008c7306ULL, 0x0003f0000000d400ULL, 0x0000007f00fc7306ULL, 0x000fe20000209400ULL,
0x0001000036367824ULL, 0x002fca00078e00ffULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000007f00c57306ULL, 0x000e700000205400ULL, 0x0000007f00ca7306ULL, 0x0004f0000020d400ULL,
0x0000008000307306ULL, 0x000fe20000209400ULL, 0x00000018ff7f7819ULL, 0x004fc40000011434ULL,
0x000000c5fc00720bULL, 0x002fca0003f7d000ULL, 0x0000008000317306ULL, 0x000ff00000205400ULL,
0x0000008000a97306ULL, 0x0003e2000020d400ULL, 0x00000001caca3812ULL, 0x008fe400078efcffULL,
0x000000a0ef00720bULL, 0x000fc40003f7d000ULL, 0x00000093ca93723eULL, 0x000fc600000010ffULL,
0x0000003500a47306ULL, 0x0004e2000000d400ULL, 0x0000010037807824ULL, 0x002fca00078e00ffULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x0000003200b37306ULL, 0x000e62000020d400ULL,
0x0001000035357824ULL, 0x004fe200078e00ffULL, 0x00000001b0b03812ULL, 0x000fcc00078efcffULL,
0x0000003300eb7306ULL, 0x000fe20000209400ULL, 0x00000001a4a42812ULL, 0x008fce00078efcffULL,
0x0000003300f27306ULL, 0x000ea20000205400ULL, 0x00000001b3b34812ULL, 0x002fe400078efcffULL,
0x000000313000720bULL, 0x000fe20003f9d000ULL, 0x000001005d307824ULL, 0x000fc800078e00ffULL,
0x0000003300af7306ULL, 0x000e62000020d400ULL, 0x00000018ffe67819ULL, 0x000fce0000011430ULL,
0x0000007f00327306ULL, 0x000fe20000209400ULL, 0x00000001a9a94812ULL, 0x000fe400078efcffULL,
0x000000f2eb00720bULL, 0x004fca0003f1d000ULL, 0x0000007f00337306ULL, 0x000eb00000205400ULL,
0x0000008200e97306ULL, 0x000fe20000209400ULL, 0x00000001afaf0812ULL, 0x002fe400078efcffULL,
0x00000095e800720bULL, 0x000fca0003f1d000ULL, 0x0000008200ee7306ULL, 0x000e620000205400ULL,
0x000000333200720bULL, 0x004fce0003fbd000ULL, 0x00000037008f7306ULL, 0x000fe20000009400ULL,
0x000000018c8c0812ULL, 0x000fe400078efcffULL, 0x000000909b00720bULL, 0x000fe20003f1d000ULL,
0x000100005e9b7824ULL, 0x000fc800078e00ffULL, 0x0000003700d07306ULL, 0x000fe20000005400ULL,
0x000000eee900720bULL, 0x002fe40003f5d000ULL, 0x00000018ff9b7819ULL, 0x000fca000001149bULL,
0x00000037007d7306ULL, 0x0003e2000000d400ULL, 0x000000017b7b0812ULL, 0x000fce00078efcffULL,
0x0000003600dc7306ULL, 0x000fe20000209400ULL, 0x0001000037377824ULL, 0x002fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000003600dd7306ULL, 0x000ff00000205400ULL,
0x0000003600997306ULL, 0x0003f0000020d400ULL, 0x0000008000de7306ULL, 0x000fe20000209400ULL,
0x0001000060367824ULL, 0x002fca00078e00ffULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000008000df7306ULL, 0x000ff00000205400ULL, 0x00000080009a7306ULL, 0x0003f0000020d400ULL,
0x0000007e008b7306ULL, 0x000fe20000209400ULL, 0x0000010062807824ULL, 0x002fca00078e00ffULL,
0x00000018ffab7819ULL, 0x000fe20000011480ULL, 0x0000010063807824ULL, 0x000fe200078e00ffULL,
0x0000007e00f07306ULL, 0x000e680000205400ULL, 0x00000018ffb17819ULL, 0x000fc80000011480ULL,
0x0000007e00ad7306ULL, 0x0005f0000020d400ULL, 0x0000007f00a77306ULL, 0x000722000020d400ULL,
0x00000018ff7e7819ULL, 0x004fe40000011435ULL, 0x000000f08b00720bULL, 0x002fca0003f7d000ULL,
0x00000082009f7306ULL, 0x000e62000020d400ULL, 0x00000100617f7824ULL, 0x008fca00078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000003700e07306ULL, 0x000fe20000209400ULL,
0x00000001a7a75812ULL, 0x010fe400078efcffULL, 0x000000dfde00720bULL, 0x000fe20003fbd000ULL,
0x000000ffffdf7224ULL, 0x000fe200078e00e2ULL, 0x00000001adad3812ULL, 0x000fe200078efcffULL,
0x000100005cde7824ULL, 0x000fe200078e00ffULL, 0x000000e39600720bULL, 0x000fe20003f7d000ULL,
0x0000003700e17306ULL, 0x000ea20000205400ULL, 0x000000019f9f2812ULL, 0x002fc400078efcffULL,
0x000000dddc00720bULL, 0x000fe40003f5d000ULL, 0x00000018ffde7819ULL, 0x000fe400000114deULL,
0x0000008c9f8c723eULL, 0x000fe200000010ffULL, 0x00000037008a7306ULL, 0x0003e2000020d400ULL,
0x000000019a9a5812ULL, 0x000fc600078efcffULL, 0x000000019c9c3812ULL, 0x000fe400078efcffULL,
0x000000ffdf00720cULL, 0x000fe40003f65270ULL, 0x0000006100cb7306ULL, 0x000ee20000005400ULL,
0x0001000061377824ULL, 0x002fe200078e00ffULL, 0x0000000199992812ULL, 0x000fe400078efcffULL,
0x000000e1e000720bULL, 0x004fe40003fbd000ULL, 0x00000018ff377819ULL, 0x000fc40000011437ULL,
0x0000006100157306ULL, 0x000e62000000d400ULL, 0x000000997c7c723eULL, 0x000fce00000010ffULL,
0x0000007e00347306ULL, 0x000fe20000209400ULL, 0x000000cbc800720bULL, 0x008fe40003f5d000ULL,
0x000000018a8a5812ULL, 0x000fca00078efcffULL, 0x0000007e00357306ULL, 0x000eac0000205400ULL,
0x0000000115152812ULL, 0x002fe400078efcffULL, 0x0000007e00a57306ULL, 0x0002e2000020d400ULL,
0x000000b9b600720bULL, 0x000fce0003f5d000ULL, 0x0000003600d27306ULL, 0x000fe20000209400ULL,
0x00000100607e7824ULL, 0x002fe200078e00ffULL, 0x000000353400720bULL, 0x004fc80003f9d000ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000003600d37306ULL, 0x000fe20000205400ULL,
0x000000016b6b2812ULL, 0x000fcc00078efcffULL, 0x00000001a5a54812ULL, 0x008fe200078efcffULL,
0x0000003600617306ULL, 0x0003e2000020d400ULL, 0x000000d08f00720bULL, 0x000fe20003f9d000ULL,
0x000100005dd07824ULL, 0x000fca00078e00ffULL, 0x00000018ffd07819ULL, 0x000fe200000114d0ULL,
0x000000b100b27306ULL, 0x000fe20000209400ULL, 0x0001000062367824ULL, 0x002fca00078e00ffULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x000000b100b77306ULL, 0x000e620000205400ULL,
0x000000017d7d4812ULL, 0x000fce00078efcffULL, 0x000000b100807306ULL, 0x000eb0000020d400ULL,
0x0000007e00d47306ULL, 0x000fe20000209400ULL, 0x000000b7b200720bULL, 0x002fce0003f5d000ULL,
0x0000007e00d57306ULL, 0x000e6c0000205400ULL, 0x0000000180802812ULL, 0x004fe400078efcffULL,
0x0000007e00837306ULL, 0x000ea2000020d400ULL, 0x0000008e8d00720bULL, 0x000fe40003f5d000ULL,
0x0000007d9a8d723eULL, 0x000fc400000010ffULL, 0x0000008a7b7d723eULL, 0x000fc600000010ffULL,
0x0000003600ac7306ULL, 0x000fe20000209400ULL, 0x000000d5d400720bULL, 0x002fca0003fbd000ULL,
0x000000016d6d2812ULL, 0x000fe400078efcffULL, 0x0000003600b17306ULL, 0x000fec0000205400ULL,
0x0000000183835812ULL, 0x004fe400078efcffULL, 0x0000003600857306ULL, 0x0003e2000020d400ULL,
0x000000c3c000720bULL, 0x000fce0003fbd000ULL, 0x0000003700cc7306ULL, 0x000fe20000209400ULL,
0x000001005c367824ULL, 0x002fca00078e00ffULL, 0x00000018ffed7819ULL, 0x000fe20000011436ULL,
0x0000020000367824ULL, 0x000fe200078e00ffULL, 0x0000003700cf7306ULL, 0x000fe20000205400ULL,
0x000000016a6a5812ULL, 0x000fce00078efcffULL, 0x00000037007e7306ULL, 0x0003f0000020d400ULL,
0x0000006000977306ULL, 0x000fe20000009400ULL, 0x0001000063377824ULL, 0x002fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000006000c67306ULL, 0x000e700000005400ULL,
0x00000060007a7306ULL, 0x000eb0000000d400ULL, 0x0000007f00d67306ULL, 0x000fe20000209400ULL,
0x000000c69700720bULL, 0x002fce0003f9d000ULL, 0x0000007f00d77306ULL, 0x000e6c0000205400ULL,
0x000000017a7a4812ULL, 0x004fe400078efcffULL, 0x0000007f00607306ULL, 0x000ea2000020d400ULL,
0x000000d3d200720bULL, 0x000fe40003f9d000ULL, 0x0000007a837a723eULL, 0x000fca00000010ffULL,
0x000000ab00bc7306ULL, 0x000fe20000209400ULL, 0x000000d7d600720bULL, 0x002fca0003f1d000ULL,
0x0000000161614812ULL, 0x000fe400078efcffULL, 0x000000ab00c17306ULL, 0x000e640000205400ULL,
0x000000616a6a723eULL, 0x000fc800000010ffULL, 0x0000000160600812ULL, 0x004fe400078efcffULL,
0x000000ab007f7306ULL, 0x000ea2000020d400ULL, 0x000000cfcc00720bULL, 0x000fe40003f1d000ULL,
0x00000015607b723eULL, 0x000fca00000010ffULL, 0x0000003700a87306ULL, 0x000fe20000209400ULL,
0x000000c1bc00720bULL, 0x002fca0003fbd000ULL, 0x000000017e7e0812ULL, 0x000fe400078efcffULL,
0x0000003700ab7306ULL, 0x000fe40000205400ULL, 0x0000007e6b6b723eULL, 0x000fc800000010ffULL,
0x000000017f7f5812ULL, 0x004fe400078efcffULL, 0x0000003700847306ULL, 0x0003e2000020d400ULL,
0x000000b1ac00720bULL, 0x000fce0003fbd000ULL, 0x0000006200d87306ULL, 0x000fe20000009400ULL,
0xfffff80036377812ULL, 0x002fca00078ec0ffULL, 0x0000000185855812ULL, 0x000fe400078efcffULL,
0x0000006200d97306ULL, 0x000e700000005400ULL, 0x0000006200827306ULL, 0x0004f0000000d400ULL,
0x0000006300da7306ULL, 0x000fe20000009400ULL, 0x00000001ea627824ULL, 0x004fe200078e0237ULL,
0x000000d9d800720bULL, 0x002fc80003fdd000ULL, 0x009800006230783bULL, 0x000e640000000200ULL,
0x0000006300db7306ULL, 0x000fee0000005400ULL, 0x0000000182826812ULL, 0x008fe200078efcffULL,
0x0000006300817306ULL, 0x0005e2000000d400ULL, 0x0000009e9d00720bULL, 0x000fc40003fdd000ULL,
0x000000827f82723eULL, 0x000fca00000010ffULL, 0x0000005c00c27306ULL, 0x000fe20000009400ULL,
0x00000001ec637824ULL, 0x004fca00078e0237ULL, 0x009800006334783bULL, 0x000ea20000000200ULL,
0x000000016c6c6812ULL, 0x000fe200078efcffULL, 0x0000005c00c57306ULL, 0x000ee60000005400ULL,
0x000000856c6c723eULL, 0x000fca00000010ffULL, 0x0000005c00867306ULL, 0x000f22000000d400ULL,
0x000000923131b231ULL, 0x002fce00003400ffULL, 0x0000005d00b87306ULL, 0x000fe20000009400ULL,
0x000000c5c200720bULL, 0x008fe20003f9d000ULL, 0x000000923333b231ULL, 0x000fe400003400ffULL,
0x000000c93030b231ULL, 0x080fe400003400ffULL, 0x000000c93232b231ULL, 0x000fe400003400ffULL,
0x0000005d00bb7306ULL, 0x000e6c0000005400ULL, 0x0000000186864812ULL, 0x010fc400078efcffULL,
0x000000ed00a27306ULL, 0x000fe20000209400ULL, 0x000000923535b231ULL, 0x004fce00003400ffULL,
0x000000ed00a37306ULL, 0x000ea20000205400ULL, 0x000000923737b231ULL, 0x000fe200003400ffULL,
0x000000c4cd92723eULL, 0x000fe200000010ffULL, 0x000000c93434b231ULL, 0x080fe200003400ffULL,
0x000000bbb800720bULL, 0x002fe20003f1d000ULL, 0x000000c93636b231ULL, 0x000fe200003400ffULL,
0x000000dbda00720bULL, 0x000fe40003f7d000ULL, 0x000000e600957306ULL, 0x000fe80000209400ULL,
0x000000923454723cULL, 0x000fe80000041854ULL, 0x000000e600967306ULL, 0x000e620000205400ULL,
0x000000a3a200720bULL, 0x004fc40003fdd000ULL, 0x000000b4bd92723eULL, 0x000fe200000010ffULL,
0x0000008c343c723cULL, 0x040fe2000004183cULL, 0x000000b0b593723eULL, 0x000fe400000010ffULL,
0x0000000181813812ULL, 0x000fe200078efcffULL, 0x000000de008f7306ULL, 0x000fe20000209400ULL,
0x000000aba800720bULL, 0x000fe40003f7d000ULL, 0x000000818083723eULL, 0x000fe200000010ffULL,
0x00000092344c723cULL, 0x000fe8000004184cULL, 0x000000de00907306ULL, 0x000ea20000205400ULL,
0x000000969500720bULL, 0x002fc40003f5d000ULL, 0x000000a6ad92723eULL, 0x000fe200000010ffULL,
0x0000007c3438723cULL, 0x040fe20000041838ULL, 0x000000a4a993723eULL, 0x000fe400000010ffULL,
0x0000000184843812ULL, 0x000fe200078efcffULL, 0x0000005d00877306ULL, 0x0002e6000000d400ULL,
0x000000846d6d723eULL, 0x000fe200000010ffULL, 0x000000923444723cULL, 0x000fe80000041844ULL,
0x0000005e00a07306ULL, 0x000fe20000009400ULL, 0x000100005f5d7824ULL, 0x002fe200078e00ffULL,
0x000000908f00720bULL, 0x004fc40003f9d000ULL, 0x0000007a3054723cULL, 0x040fe40000041854ULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x0000005e00a17306ULL, 0x000e620000005400ULL,
0x0000000187870812ULL, 0x008fe400078efcffULL, 0x000000727100720bULL, 0x000fe20003f1d000ULL,
0x00000082304c723cULL, 0x000fe8000004184cULL, 0x0000005e00887306ULL, 0x0004f0000000d400ULL,
0x0000005f00917306ULL, 0x000fe20000009400ULL, 0x000000c7be5e723eULL, 0x004fc400000010ffULL,
0x000000a1a000720bULL, 0x002fe40003fbd000ULL, 0x0000000173730812ULL, 0x000fc600078efcffULL,
0x0000005f00947306ULL, 0x000e700000005400ULL, 0x0000005f00897306ULL, 0x0005e2000000d400ULL,
0x0000000188885812ULL, 0x008fce00078efcffULL, 0x000000ed008b7306ULL, 0x000ee2000020d400ULL,
0x000000bfba5f723eULL, 0x004fe400000010ffULL, 0x000000949100720bULL, 0x002fca0003f7d000ULL,
0x0000005e3450723cULL, 0x000fe20000041850ULL, 0x000000e6005c7306ULL, 0x000e6c000020d400ULL,
0x000000b3ae5e723eULL, 0x000fe400000010ffULL, 0x000000afaa5f723eULL, 0x000fe200000010ffULL,
0x000000de00977306ULL, 0x000ea2000020d400ULL, 0x000000018b8b6812ULL, 0x008fc400078efcffULL,
0x0000006f6e00720bULL, 0x000fe40003fdd000ULL, 0x0000000189893812ULL, 0x000fe200078efcffULL,
0x0000005e3448723cULL, 0x000fe20000041848ULL, 0x000000015c5c2812ULL, 0x002fe200078efcffULL,
0x000000d000c67306ULL, 0x000fe20000209400ULL, 0x000000868b86723eULL, 0x000fe400000010ffULL,
0x000000875c87723eULL, 0x000fe400000010ffULL, 0x000000a79c5e723eULL, 0x000fe200000010ffULL,
0x0000006a3050723cULL, 0x000fe20000041850ULL, 0x000000a5985f723eULL, 0x000fe200000010ffULL,
0x000000d000c97306ULL, 0x000e620000205400ULL, 0x0000000197974812ULL, 0x004fc400078efcffULL,
0x0000000170706812ULL, 0x000fe400078efcffULL, 0x000000757400720bULL, 0x000fe20003fdd000ULL,
0x0000005e3440723cULL, 0x000fe20000041840ULL, 0x000000977070723eULL, 0x000fe200000010ffULL,
0x000000d100ba7306ULL, 0x000fec0000209400ULL, 0x0000006c3048723cULL, 0x000fe40000041848ULL,
0x000000d100b57306ULL, 0x000ea20000205400ULL, 0x000000c9c600720bULL, 0x002fc40003f5d000ULL,
0x0000000176766812ULL, 0x000fc600078efcffULL, 0x000000863044723cULL, 0x000fe40000041844ULL,
0x000000d000c07306ULL, 0x000e70000020d400ULL, 0x000000d100af7306ULL, 0x000ee2000020d400ULL,
0x000000b5ba00720bULL, 0x004fce0003f9d000ULL, 0x000000ce00a47306ULL, 0x000fe20000209400ULL,
0x00000001c0c02812ULL, 0x002fe400078efcffULL, 0x000000787700720bULL, 0x000fe40003f5d000ULL,
0x000000c07371723eULL, 0x000fc600000010ffULL, 0x000000ce00937306ULL, 0x000e620000205400ULL,
0x00000001afaf4812ULL, 0x008fc600078efcffULL, 0x000000703040723cULL, 0x000fe20000041840ULL,
0x00000088af88723eULL, 0x000fc600000010ffULL, 0x0000009b005e7306ULL, 0x000fe20000209400ULL,
0x0000000179792812ULL, 0x000fce00078efcffULL, 0x0000009b00157306ULL, 0x000ea20000205400ULL,
0x00000093a400720bULL, 0x002fce0003f1d000ULL, 0x0000005d00347306ULL, 0x000ff00000209400ULL,
0x0000005d00357306ULL, 0x000e620000205400ULL, 0x000000155e00720bULL, 0x004fce0003f9d000ULL,
0x000000ce008e7306ULL, 0x000eb0000020d400ULL, 0x0000009b009b7306ULL, 0x000ee2000020d400ULL,
0x000000353400720bULL, 0x002fce0003fbd000ULL, 0x0000005d00367306ULL, 0x000e62000020d400ULL,
0x000000018e8e0812ULL, 0x004fc800078efcffULL, 0x000000898e89723eULL, 0x000fe400000010ffULL,
0x000000019b9b4812ULL, 0x008fc800078efcffULL, 0x0000009b7676723eULL, 0x000fe200000010ffULL,
0x00000088303c723cULL, 0x000fe2000004183cULL, 0x0000000136365812ULL, 0x002fc800078efcffULL,
0x000000367977723eULL, 0x000fce00000010ffULL, 0x000000763038723cULL, 0x000fe20000041838ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200016307f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000801c307810ULL, 0x004fe20007ffe0ffULL, 0x00f6900059ff7f8cULL, 0x0005e2000c80043fULL,
0x000000011a157812ULL, 0x000fe400078ec0ffULL, 0x000000033000720cULL, 0x000fda0003f06070ULL,
0x00005a2000000947ULL, 0x000fea0003800000ULL, 0x0000040017307984ULL, 0x004ea40000000800ULL,
0x8000000030ff7812ULL, 0x004fe40007804831ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240016307984ULL, 0x000ea40000000800ULL, 0x8000000030ff7812ULL, 0x004fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL, 0x0000000b000d7305ULL, 0x0004e4000021f000ULL,
0x3fa000000b0b7823ULL, 0x004fe200000100ffULL, 0x0000000d0000735dULL, 0x008fe20003800000ULL,
0x0000240016307984ULL, 0x000ea40000000800ULL, 0x8000000030ff7812ULL, 0x004fc40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000015b5a7824ULL, 0x000fe400078e025aULL,
0x000058000a357a24ULL, 0x020fe200078e02ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011600ULL,
0xffffffffff0a7424ULL, 0x000fe200078e00ffULL, 0x000000035a0b7812ULL, 0x000fc800078ec0ffULL,
0x000000030b00780cULL, 0x000fc80003f05270ULL, 0x00000001090b7807ULL, 0x000fca0004000000ULL,
0x000000015a0b7824ULL, 0x000fca00078e020bULL, 0x000000040b00720cULL, 0x000fe20003f06070ULL,
0x000000200d327824ULL, 0x000fca00078e021cULL, 0x000000c032327810ULL, 0x000fce0007ffe0ffULL,
0x0000000118308824ULL, 0x000fe400078e020bULL, 0x00000004ff318424ULL, 0x000fe200078e00ffULL,
0x000000200f347812ULL, 0x000fc600078ef832ULL, 0x0000600030308625ULL, 0x000fe200078e0031ULL,
0x0000000105337810ULL, 0x000fe40007ffe0ffULL, 0x0000003203157217ULL, 0x000fe20007800000ULL,
0x0000004035357824ULL, 0x000fe200078e00ffULL, 0x00000006300a8981ULL, 0x000562000c1e1900ULL,
0x000000063300720cULL, 0x000fe20003f46070ULL, 0x0000001000337824ULL, 0x000fe200078e00ffULL,
0x00000003ff607819ULL, 0x000fe20000011602ULL, 0x0000000115157824ULL, 0x000fe200078e0a32ULL,
0x00000000660473c2ULL, 0x000ee200000e0000ULL, 0x000000011f327824ULL, 0x000fe200078e0234ULL,
0x0000001033367812ULL, 0x000fc400078ec0ffULL, 0x0000002015157807ULL, 0x000fe20001000000ULL,
0x000000011b307824ULL, 0x104fe200078e0234ULL, 0x0000003235327210ULL, 0x000fe20007f7e0ffULL,
0x000000011d317824ULL, 0x100fe200078e0234ULL, 0x0000001536157217ULL, 0x000fe20007800000ULL,
0x0000000121347824ULL, 0x000fe200078e0234ULL, 0x0000003035307210ULL, 0x040fe40007f1e0ffULL,
0x0000003135317210ULL, 0x000fe20007f5e0ffULL, 0x0000000115157824ULL, 0x000fe200078e0a36ULL,
0x0000003435347210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff5b7224ULL, 0x000fe200000e06ffULL,
0x00005e00305e7a11ULL, 0x000fe200078038ffULL, 0x000000ffff357224ULL, 0x000fe200018e06ffULL,
0x00005e0034367a11ULL, 0x000fe200078638ffULL, 0x000000ffff377224ULL, 0x000fe200020e06ffULL,
0x00005f00305b7a11ULL, 0x000fe200000f3c5bULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x00005e00325a7a11ULL, 0x000fc400078438ffULL, 0x00005e00315c7a11ULL, 0x040fe400078038ffULL,
0x00005f0032357a11ULL, 0x000fe400010f3c35ULL, 0x0000000860327810ULL, 0x040fe40007ffe0ffULL,
0x00005f0031337a11ULL, 0x000fe400000f3c30ULL, 0x00000004606a7810ULL, 0x000fe40007ffe0ffULL,
0x00005f0034377a11ULL, 0x000fc400018f3c37ULL, 0x000000295e307210ULL, 0x000fe40007f9e0ffULL,
0x000000156000720cULL, 0x080fe40003f66070ULL, 0x000000153200720cULL, 0x000fe20003f06070ULL,
0x000000ffff317224ULL, 0x000fe200020e065bULL, 0x0000000c60607810ULL, 0x000fe40007ffe0ffULL,
0x000000295c327210ULL, 0x000fe40007fbe0ffULL, 0x000000156a00720cULL, 0x000fc40003f46070ULL,
0x000000156000720cULL, 0x000fe20003f86070ULL, 0x000000ffff337224ULL, 0x000fe200028e0633ULL,
0x000000295a347210ULL, 0x080fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030247faeULL, 0x0005e2000d901c46ULL, 0x0000002936367210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff357224ULL, 0x000fe400030e0635ULL, 0x000000ffff377224ULL, 0x000fe400028e0637ULL,
0x0000000032257faeULL, 0x0005e8000d101c46ULL, 0x0000000034267faeULL, 0x0005e8000c101c46ULL,
0x0000000036277faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000665a7f8cULL, 0x000728000c80043fULL,
0x0000040065267984ULL, 0x0046a20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480028247f8cULL, 0x000fe2000c80043fULL,
0x8000000026ff7812ULL, 0x004fc60007844819ULL, 0x00f64c0028157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff157424ULL, 0x000fc800078e00ffULL, 0x0000001500267305ULL, 0x000464000021f000ULL,
0x3fa0000015157823ULL, 0x004fe200000100ffULL, 0x000000260000735dULL, 0x002fe20003800000ULL,
0x00f64c0028277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000157824ULL, 0x000fca00078e00ffULL,
0xffffff8015247812ULL, 0x000fc800078ec0ffULL, 0x0000010029157810ULL, 0x000fca0007ffe024ULL,
0x000000012a157824ULL, 0x000fca00078e0215ULL, 0x00f0000015247984ULL, 0x000ea80000000800ULL,
0x00f2000015257984ULL, 0x0002e20000000800ULL, 0x000000112400720bULL, 0x004fe20003f1d000ULL,
0x0000f0927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000157806ULL, 0x002fc800000e0100ULL,
0x0000ffff15267812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ffce7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000207157810ULL, 0x000fe40007ffe0ffULL, 0x000000112400720bULL, 0x000fe40003f14000ULL,
0x000000001500720cULL, 0x000fe20003f65270ULL, 0x0000f0627f007947ULL, 0x000ff4000b800000ULL,
0x0000000000157806ULL, 0x000fe400000e0100ULL, 0x0000002411277209ULL, 0x000fe20007810000ULL,
0x000000800031b824ULL, 0x000fe200078e0229ULL, 0x0000ffff15157812ULL, 0x000fe400078e3cffULL,
0x00000002ff347819ULL, 0x000fe20000011602ULL, 0x000000012a30b824ULL, 0x000fe200078e0231ULL,
0x0000001526ff7212ULL, 0x000fe2000780c0ffULL, 0x8000002711117221ULL, 0x000fc60000010000ULL,
0x00f400273000b388ULL, 0x0003e20000000800ULL, 0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL,
0x0000001100337308ULL, 0x000ea40000000800ULL, 0x0000003312127220ULL, 0x004fe20000410000ULL,
0x0000eff27f007947ULL, 0x000fea000b800000ULL, 0x00001f3433117589ULL, 0x0022a400000e0000ULL,
0x0000001154547220ULL, 0x084fe40000410000ULL, 0x0000001155557220ULL, 0x080fe40000410000ULL,
0x0000001150507220ULL, 0x080fe40000410000ULL, 0x0000001151517220ULL, 0x080fe40000410000ULL,
0x000000114c4c7220ULL, 0x000fc40000410000ULL, 0x000000114d4d7220ULL, 0x080fe40000410000ULL,
0x0000001148487220ULL, 0x080fe40000410000ULL, 0x0000001149497220ULL, 0x080fe40000410000ULL,
0x0000001144447220ULL, 0x080fe40000410000ULL, 0x0000001145457220ULL, 0x080fe40000410000ULL,
0x0000001140407220ULL, 0x000fc40000410000ULL, 0x0000001141417220ULL, 0x080fe40000410000ULL,
0x000000113c3c7220ULL, 0x080fe40000410000ULL, 0x000000113d3d7220ULL, 0x080fe40000410000ULL,
0x0000001138387220ULL, 0x080fe40000410000ULL, 0x0000001139397220ULL, 0x000fe20000410000ULL,
0x0000ef327f007947ULL, 0x000fea000b800000ULL, 0x00001f2c33117589ULL, 0x00046400000e0000ULL,
0x8000002724240221ULL, 0x000fe20000010000ULL, 0x00000001ffce7807ULL, 0x000fe20000000000ULL,
0x0000001156567220ULL, 0x002fc40000410000ULL, 0x3fb8aa3b24240820ULL, 0x000fe40000410000ULL,
0x0000001157577220ULL, 0x080fe40000410000ULL, 0x00000024002b0308ULL, 0x000e620000000800ULL,
0x0000001152527220ULL, 0x080fe40000410000ULL, 0x0000001153537220ULL, 0x080fe40000410000ULL,
0x000000114e4e7220ULL, 0x080fe40000410000ULL, 0x000000114f4f7220ULL, 0x000fc40000410000ULL,
0x000000114a4a7220ULL, 0x080fe40000410000ULL, 0x000000114b4b7220ULL, 0x080fe40000410000ULL,
0x0000001146467220ULL, 0x080fe40000410000ULL, 0x0000001147477220ULL, 0x080fe40000410000ULL,
0x0000001142427220ULL, 0x080fe40000410000ULL, 0x0000001143437220ULL, 0x000fc40000410000ULL,
0x000000113e3e7220ULL, 0x080fe40000410000ULL, 0x000000113f3f7220ULL, 0x080fe40000410000ULL,
0x000000113a3a7220ULL, 0x080fe40000410000ULL, 0x000000113b3b7220ULL, 0x000fe40000410000ULL,
0x000000ffff117224ULL, 0x000fe400078e0027ULL, 0x000000252b250220ULL, 0x00afc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000001225127221ULL, 0x008fe20000010000ULL, 0x000000f000002947ULL, 0x000fea0003800000ULL,
0x0000000864157812ULL, 0x000fe400078ec0ffULL, 0xfffffff008247812ULL, 0x000fca00078ec0ffULL,
0x0000000124157824ULL, 0x000fca00078e0215ULL, 0x00f6ac0015247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff157424ULL, 0x000fc800078e00ffULL,
0x0000001500247305ULL, 0x0002e4000021f000ULL, 0x3fa0000015157823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x0000040065247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fc40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff347819ULL, 0x000fe40000011602ULL, 0x0000002bff24723eULL, 0x000fe400000010ffULL,
0x0000001834157810ULL, 0x040fe40007ffe0ffULL, 0x0000001034197810ULL, 0x000fe40007ffe0ffULL,
0x0000541024337816ULL, 0x004fe20000000024ULL, 0x0000ec927f007947ULL, 0x000fea000b800000ULL,
0x00001f3433b37589ULL, 0x0002a400000e0000ULL, 0x0000ecd27f007947ULL, 0x000fea000b800000ULL,
0x00001f2c33b27589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff347224ULL, 0x002fe200078e0019ULL, 0x00007eb000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000f63000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff347224ULL, 0x002fe200078e0015ULL, 0x00007f1000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000f5d000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000100067337812ULL, 0x00afe200078ec0ffULL, 0x0000100000327824ULL, 0x004fe200078e00ffULL,
0x00009910cece7816ULL, 0x000fe400000000ffULL, 0x0000b00010617810ULL, 0x000fe40007ffe033ULL,
0xffffe00032327812ULL, 0x000fc600078ec0ffULL, 0x000000102e247824ULL, 0x000fe200078e0261ULL,
0x0000b000325c7810ULL, 0x000fe20007ffe033ULL, 0x0000001058347824ULL, 0x000fc800078e0261ULL,
0x000000002424783bULL, 0x000e680000004200ULL, 0x000000003434783bULL, 0x000ea20000004200ULL,
0x00000018ff307819ULL, 0x002fe20000011424ULL, 0x0000002400b97306ULL, 0x000fe20000009400ULL,
0x00000018ff317819ULL, 0x000fe20000011425ULL, 0x00000100267c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011426ULL, 0x00000018ff6b7819ULL, 0x000fc40000011427ULL,
0x00000018ff6c7819ULL, 0x004fe20000011434ULL, 0x00000030002e7306ULL, 0x000fe20000209400ULL,
0x00000018ff777819ULL, 0x000fe40000011436ULL, 0x00000018ff787819ULL, 0x000fe40000011437ULL,
0x00000018ff7f7819ULL, 0x000fe2000001147cULL, 0x00000100277c7824ULL, 0x000fe400078e00ffULL,
0x0000003000b57306ULL, 0x000ff00000205400ULL, 0x0000003000677306ULL, 0x0003f0000020d400ULL,
0x0000003100ab7306ULL, 0x000fe20000209400ULL, 0x000000102d307824ULL, 0x002fc400078e025cULL,
0x000000102f5c7824ULL, 0x000fe200078e025cULL, 0x00000018ff2f7819ULL, 0x000fc80000011435ULL,
0x0000003100a87306ULL, 0x000ff00000205400ULL, 0x0000003100587306ULL, 0x0003f0000020d400ULL,
0x0000005d008f7306ULL, 0x000fe20000209400ULL, 0x000000003030783bULL, 0x002e6e0000004200ULL,
0x0000005d00907306ULL, 0x000ff00000205400ULL, 0x0000005d00647306ULL, 0x0005f0000020d400ULL,
0x0000006b00857306ULL, 0x000fe20000209400ULL, 0x000000005c5c783bULL, 0x004eae0000004200ULL,
0x0000006b00867306ULL, 0x000ff00000205400ULL, 0x0000006b006a7306ULL, 0x000fe2000020d400ULL,
0x00000018ff7a7819ULL, 0x002fc40000011433ULL, 0x00000018ff797819ULL, 0x000fca0000011432ULL,
0x0000006c002d7306ULL, 0x000ff00000209400ULL, 0x0000006c00767306ULL, 0x000ff00000205400ULL,
0x0000006c00727306ULL, 0x000fe2000020d400ULL, 0x000001005c9d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe4000001149dULL, 0x0000007700707306ULL, 0x000ff00000209400ULL,
0x00000077006b7306ULL, 0x000ff00000205400ULL, 0x0000007700717306ULL, 0x0003f0000020d400ULL,
0x00000078006e7306ULL, 0x000fe20000209400ULL, 0x00000018ff777819ULL, 0x002fce0000011430ULL,
0x0000007800737306ULL, 0x000ff00000205400ULL, 0x00000078006c7306ULL, 0x0003f0000020d400ULL,
0x0000002f006f7306ULL, 0x000fe20000209400ULL, 0x00000018ff787819ULL, 0x002fce0000011431ULL,
0x0000002f00747306ULL, 0x000ff00000205400ULL, 0x0000002f006d7306ULL, 0x000ff0000020d400ULL,
0x0000007700e27306ULL, 0x000ff00000209400ULL, 0x00000077009b7306ULL, 0x000e700000205400ULL,
0x0000007700be7306ULL, 0x0004f0000020d400ULL, 0x0000007800e07306ULL, 0x000fe20000209400ULL,
0x00000018ff777819ULL, 0x004fc4000001145cULL, 0x0000009be200720bULL, 0x002fca0003f5d000ULL,
0x0000007800897306ULL, 0x000ff00000205400ULL, 0x00000078002f7306ULL, 0x0003e2000020d400ULL,
0x00000001bebe2812ULL, 0x008fce00078efcffULL, 0x0000007700db7306ULL, 0x000fe20000209400ULL,
0x00000018ff787819ULL, 0x002fce000001145dULL, 0x0000007700d27306ULL, 0x000ff00000205400ULL,
0x0000007700937306ULL, 0x0003f0000020d400ULL, 0x0000007800d67306ULL, 0x000fe20000209400ULL,
0x0000010024777824ULL, 0x002fca00078e00ffULL, 0x00000018ff777819ULL, 0x000fe40000011477ULL,
0x0000007800dd7306ULL, 0x000ff00000205400ULL, 0x00000078008c7306ULL, 0x0003f0000020d400ULL,
0x0000002400b67306ULL, 0x000fe20000005400ULL, 0x0000010025787824ULL, 0x002fce00078e00ffULL,
0x0000002400757306ULL, 0x0003f0000000d400ULL, 0x0000002500bd7306ULL, 0x000fe20000009400ULL,
0x0001000024247824ULL, 0x002fca00078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000002500ba7306ULL, 0x000ff00000005400ULL, 0x0000002500157306ULL, 0x0003f0000000d400ULL,
0x0000007a00d77306ULL, 0x000fe20000209400ULL, 0x0001000025257824ULL, 0x002fca00078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000007a00dc7306ULL, 0x000ff00000205400ULL,
0x0000007a009e7306ULL, 0x0003f0000020d400ULL, 0x0000007700ca7306ULL, 0x000fe20000209400ULL,
0x00000018ff7a7819ULL, 0x002fce000001145fULL, 0x0000007a00cc7306ULL, 0x000ff00000209400ULL,
0x0000007a00cd7306ULL, 0x000ff00000205400ULL, 0x0000007a007b7306ULL, 0x000ff0000020d400ULL,
0x0000007700c77306ULL, 0x000ff00000205400ULL, 0x00000077007e7306ULL, 0x000ff0000020d400ULL,
0x0000002600bf7306ULL, 0x000ff00000009400ULL, 0x0000002600b87306ULL, 0x000ff00000005400ULL,
0x0000002600607306ULL, 0x0003f0000000d400ULL, 0x0000002400c47306ULL, 0x000fe20000209400ULL,
0x0001000026267824ULL, 0x002fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000002400c37306ULL, 0x000ff00000205400ULL, 0x00000024007a7306ULL, 0x0003f0000020d400ULL,
0x0000002500ae7306ULL, 0x000fe20000209400ULL, 0x00000018ff247819ULL, 0x002fce000001147cULL,
0x0000002500b17306ULL, 0x000ff00000205400ULL, 0x0000002500777306ULL, 0x0003f0000020d400ULL,
0x00000024009f7306ULL, 0x000fe20000209400ULL, 0x0000010034257824ULL, 0x002fca00078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000002400a07306ULL, 0x000ff00000205400ULL,
0x00000024007c7306ULL, 0x0003f0000020d400ULL, 0x0000002600987306ULL, 0x000fe20000209400ULL,
0x0000010035247824ULL, 0x002fce00078e00ffULL, 0x0000002600997306ULL, 0x000ff00000205400ULL,
0x00000026007d7306ULL, 0x0003f0000020d400ULL, 0x00000025008a7306ULL, 0x000fe20000209400ULL,
0x00000018ff267819ULL, 0x002fe20000011424ULL, 0x0000010030247824ULL, 0x000fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x00000025008b7306ULL, 0x000ff00000205400ULL,
0x0000002500807306ULL, 0x0003f0000020d400ULL, 0x0000003100887306ULL, 0x000fe20000009400ULL,
0x0000010031257824ULL, 0x002fca00078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000003100e17306ULL, 0x000e700000005400ULL, 0x0000003100c27306ULL, 0x0004f0000000d400ULL,
0x00000030008e7306ULL, 0x000fe20000009400ULL, 0x0001000031317824ULL, 0x004fe200078e00ffULL,
0x000000e18800720bULL, 0x002fc80003fdd000ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000030008d7306ULL, 0x000e6e0000005400ULL, 0x00000001c2c26812ULL, 0x008fe200078efcffULL,
0x0000003000c57306ULL, 0x0004f0000000d400ULL, 0x0000002400f47306ULL, 0x000fe20000209400ULL,
0x0001000030307824ULL, 0x004fe200078e00ffULL, 0x0000008d8e00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000002400877306ULL, 0x000e6e0000205400ULL,
0x00000001c5c54812ULL, 0x008fe200078efcffULL, 0x0000003100e77306ULL, 0x000ff00000209400ULL,
0x0000003100ea7306ULL, 0x000ea20000205400ULL, 0x00000087f400720bULL, 0x002fce0003fbd000ULL,
0x0000002400d07306ULL, 0x0002f0000020d400ULL, 0x0000003200e47306ULL, 0x000fe20000009400ULL,
0x0000010032247824ULL, 0x002fe200078e00ffULL, 0x000000eae700720bULL, 0x004fc80003f5d000ULL,
0x00000018ff947819ULL, 0x000fe20000011424ULL, 0x0000010033247824ULL, 0x000fe200078e00ffULL,
0x0000003200df7306ULL, 0x000e620000005400ULL, 0x00000001d0d05812ULL, 0x008fc600078efcffULL,
0x00000018ff9a7819ULL, 0x000fc80000011424ULL, 0x0000003200ac7306ULL, 0x0004f0000000d400ULL,
0x0000003000f67306ULL, 0x000fe20000209400ULL, 0x0001000032327824ULL, 0x004fe200078e00ffULL,
0x000000dfe400720bULL, 0x002fc80003fbd000ULL, 0x00000018ff957819ULL, 0x000fe40000011432ULL,
0x0000003000f17306ULL, 0x000e6e0000205400ULL, 0x00000001acac5812ULL, 0x008fe200078efcffULL,
0x0000007900da7306ULL, 0x000fe20000209400ULL, 0x000000dcd700720bULL, 0x000fce0003fbd000ULL,
0x0000007900d37306ULL, 0x000fe20000205400ULL, 0x000000f1f600720bULL, 0x002fca0003f1d000ULL,
0x000000019e9e5812ULL, 0x000fe400078efcffULL, 0x0000007900a37306ULL, 0x0003f0000020d400ULL,
0x0000002500eb7306ULL, 0x000fe20000209400ULL, 0x00000018ff797819ULL, 0x002fce000001145eULL,
0x0000002500ee7306ULL, 0x000e700000205400ULL, 0x0000002700bb7306ULL, 0x000ff00000009400ULL,
0x0000002700bc7306ULL, 0x000fe20000005400ULL, 0x000000eeeb00720bULL, 0x002fce0003f7d000ULL,
0x0000002700197306ULL, 0x0003f0000000d400ULL, 0x0000003000cf7306ULL, 0x000ea2000020d400ULL,
0x0001000027277824ULL, 0x002fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000003100c07306ULL, 0x000e70000020d400ULL, 0x0000009500307306ULL, 0x000fe20000209400ULL,
0x00000001cfcf0812ULL, 0x004fc400078efcffULL, 0x00000089e000720bULL, 0x000fca0003f1d000ULL,
0x0000009500317306ULL, 0x000ea20000205400ULL, 0x00000001c0c02812ULL, 0x002fce00078efcffULL,
0x0000007900cb7306ULL, 0x000fe20000209400ULL, 0x000000012f2f0812ULL, 0x000fe400078efcffULL,
0x000000d3da00720bULL, 0x000fe40003f1d000ULL, 0x000000c02f2f723eULL, 0x000fc600000010ffULL,
0x0000007900c67306ULL, 0x000fe20000205400ULL, 0x000000313000720bULL, 0x004fce0003f5d000ULL,
0x0000007900827306ULL, 0x0003e2000020d400ULL, 0x00000001a3a30812ULL, 0x000fce00078efcffULL,
0x0000002500d17306ULL, 0x000ea2000020d400ULL, 0x00000018ff797819ULL, 0x002fce0000011478ULL,
0x0000009a00257306ULL, 0x000ff00000209400ULL, 0x0000009a00247306ULL, 0x000e620000205400ULL,
0x00000001d1d13812ULL, 0x004fce00078efcffULL, 0x0000009a00af7306ULL, 0x0004f0000020d400ULL,
0x0000003300de7306ULL, 0x000fe20000009400ULL, 0x000001005d9a7824ULL, 0x004fe200078e00ffULL,
0x000000242500720bULL, 0x002fe20003fdd000ULL, 0x000100005e247824ULL, 0x000fc400078e00ffULL,
0x000100005f257824ULL, 0x000fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe4000001149aULL,
0x0000003300977306ULL, 0x000e6e0000005400ULL, 0x00000001afaf6812ULL, 0x008fe200078efcffULL,
0x0000003300a47306ULL, 0x0004f0000000d400ULL, 0x0000007900c87306ULL, 0x000fe20000209400ULL,
0x0001000033337824ULL, 0x004fe200078e00ffULL, 0x00000097de00720bULL, 0x002fcc0003f9d000ULL,
0x0000007900c97306ULL, 0x000fee0000205400ULL, 0x00000001a4a44812ULL, 0x008fe200078efcffULL,
0x0000007900787306ULL, 0x000ff0000020d400ULL, 0x0000007f00a57306ULL, 0x000ff00000209400ULL,
0x0000007f00a67306ULL, 0x000ff00000205400ULL, 0x0000007f00797306ULL, 0x000ff0000020d400ULL,
0x0000002700917306ULL, 0x000ff00000209400ULL, 0x0000002700927306ULL, 0x000ff00000205400ULL,
0x00000027007f7306ULL, 0x000ff0000020d400ULL, 0x0000002600837306ULL, 0x000ff00000209400ULL,
0x0000002600847306ULL, 0x000ff00000205400ULL, 0x0000002600817306ULL, 0x000ff0000020d400ULL,
0x0000009400267306ULL, 0x000ff00000209400ULL, 0x0000009400277306ULL, 0x000e700000205400ULL,
0x0000005d00d87306ULL, 0x000ff00000009400ULL, 0x0000005d00d57306ULL, 0x000ea20000005400ULL,
0x000000272600720bULL, 0x002fe20003f7d000ULL, 0x000001005f267824ULL, 0x000fca00078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000005d00967306ULL, 0x0002f0000000d400ULL,
0x0000009400c17306ULL, 0x0008e2000020d400ULL, 0x000100005d5d7824ULL, 0x002fe200078e00ffULL,
0x000000d5d800720bULL, 0x004fc40003f1d000ULL, 0x00000018ffd57819ULL, 0x000fc80000011425ULL,
0x0000009500b07306ULL, 0x000e62000020d400ULL, 0x00000018ff947819ULL, 0x010fcc0000011433ULL,
0x0000000196960812ULL, 0x008fe200078efcffULL, 0x0000009a00e57306ULL, 0x000fe20000209400ULL,
0x00000001c1c13812ULL, 0x000fce00078efcffULL, 0x0000009a00e87306ULL, 0x000ea20000205400ULL,
0x00000001b0b02812ULL, 0x002fce00078efcffULL, 0x0000009400327306ULL, 0x000ff00000209400ULL,
0x0000009400337306ULL, 0x000e620000205400ULL, 0x000000e8e500720bULL, 0x004fce0003f5d000ULL,
0x0000009400a97306ULL, 0x0004f0000020d400ULL, 0x0000005c00d97306ULL, 0x000fe20000009400ULL,
0x00000018ff947819ULL, 0x004fe2000001145dULL, 0x000001005e5d7824ULL, 0x000fe200078e00ffULL,
0x000000333200720bULL, 0x002fc40003f7d000ULL, 0x00a000006330783bULL, 0x000e640000000200ULL,
0x00000018fff37819ULL, 0x000fe2000001145dULL, 0x0000005c00d47306ULL, 0x000eb00000005400ULL,
0x0000005c009c7306ULL, 0x000862000000d400ULL, 0x00000001a9a93812ULL, 0x008fc400078efcffULL,
0x000000d2db00720bULL, 0x000fca0003f7d000ULL, 0x0000009a00a17306ULL, 0x000ee2000020d400ULL,
0x000100005c5c7824ULL, 0x010fe200078e00ffULL, 0x000000d4d900720bULL, 0x004fc80003f9d000ULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x000000f300ef7306ULL, 0x000fe20000209400ULL,
0x0000000193933812ULL, 0x000fe400078efcffULL, 0x000000ffce00720cULL, 0x000fc80003f65270ULL,
0x000000019c9c4812ULL, 0x002fe200078efcffULL, 0x0000005c00e97306ULL, 0x000fe20000209400ULL,
0x00000001a1a12812ULL, 0x008fce00078efcffULL, 0x0000005c00ec7306ULL, 0x000e620000205400ULL,
0x000000b33030b231ULL, 0x080fe400003400ffULL, 0x000000b33232b231ULL, 0x000fe400003400ffULL,
0x000000b23131b231ULL, 0x080fe400003400ffULL, 0x000000b23333b231ULL, 0x000fe200003400ffULL,
0x000000f300f27306ULL, 0x000eb00000205400ULL, 0x0000005f00de7306ULL, 0x000fe20000009400ULL,
0x000000ece900720bULL, 0x002fce0003fbd000ULL, 0x0000005f00df7306ULL, 0x000fe20000005400ULL,
0x000000f2ef00720bULL, 0x004fce0003f5d000ULL, 0x0000005f00977306ULL, 0x0003f0000000d400ULL,
0x0000009d00e37306ULL, 0x000fe20000209400ULL, 0x00000018ff5f7819ULL, 0x002fce0000011424ULL,
0x0000009d00e67306ULL, 0x000e700000205400ULL, 0x0000005c00a27306ULL, 0x000eb0000020d400ULL,
0x000000f3009a7306ULL, 0x000ee2000020d400ULL, 0x000000e6e300720bULL, 0x002fce0003fdd000ULL,
0x0000009400ed7306ULL, 0x000fe20000209400ULL, 0x00000001a2a25812ULL, 0x004fce00078efcffULL,
0x0000009400f07306ULL, 0x000e620000205400ULL, 0x000000019a9a2812ULL, 0x008fce00078efcffULL,
0x0000002600e07306ULL, 0x000ff00000209400ULL, 0x0000002600e77306ULL, 0x000ea20000205400ULL,
0x000000f0ed00720bULL, 0x002fce0003f9d000ULL, 0x0000005f00d37306ULL, 0x000ff00000209400ULL,
0x0000005f00d47306ULL, 0x000e620000205400ULL, 0x000000e7e000720bULL, 0x004fce0003fbd000ULL,
0x0000009d00a77306ULL, 0x000eb0000020d400ULL, 0x0000005e00e17306ULL, 0x000fe20000009400ULL,
0x000000d4d300720bULL, 0x002fce0003f5d000ULL, 0x0000005e00e27306ULL, 0x000e620000005400ULL,
0x00000001a7a76812ULL, 0x004fe400078efcffULL, 0x000000ddd600720bULL, 0x000fca0003fdd000ULL,
0x0000005e009b7306ULL, 0x000eb0000000d400ULL, 0x00000094009d7306ULL, 0x000ee2000020d400ULL,
0x000000e2e100720bULL, 0x002fe40003f1d000ULL, 0x000000018c8c6812ULL, 0x000fc400078efcffULL,
0x000000c6cb00720bULL, 0x000fe20003fdd000ULL, 0x0000010036cb7824ULL, 0x000fe400078e00ffULL,
0x00000026005e7306ULL, 0x000326000020d400ULL, 0x00000018ffcb7819ULL, 0x000fc600000114cbULL,
0x000000019b9b0812ULL, 0x004fe400078efcffULL, 0x0000005f005f7306ULL, 0x000ea2000020d400ULL,
0x000000019d9d4812ULL, 0x008fe200078efcffULL, 0x00a000006224783bULL, 0x002e620000000200ULL,
0x000000dfde00720bULL, 0x000fe40003f9d000ULL, 0x000000cdcc00720bULL, 0x000fe20003f1d000ULL,
0x0000010037cc7824ULL, 0x000fe200078e00ffULL, 0x0000000182826812ULL, 0x000fe200078efcffULL,
0x000000d500d27306ULL, 0x000fe20000209400ULL, 0x000000015e5e5812ULL, 0x010fc400078efcffULL,
0x000000b8bf00720bULL, 0x000fe40003fdd000ULL, 0x00000018ffcc7819ULL, 0x000fc600000114ccULL,
0x000000d500d77306ULL, 0x000ee20000205400ULL, 0x000000015f5f2812ULL, 0x004fe400078efcffULL,
0x000000babd00720bULL, 0x000fe40003f5d000ULL, 0x0000000197974812ULL, 0x000fe400078efcffULL,
0x000000b6b900720bULL, 0x000fe20003f9d000ULL, 0x000000d500ce7306ULL, 0x000ea2000020d400ULL,
0x000000017b7b0812ULL, 0x000fe400078efcffULL, 0x000000c9c800720bULL, 0x000fc40003f1d000ULL,
0x0000000160606812ULL, 0x000fe400078efcffULL, 0x000000908f00720bULL, 0x000fe20003fdd000ULL,
0x0000003400b47306ULL, 0x000fe20000009400ULL, 0x000000d7d200720bULL, 0x008fe40003fbd000ULL,
0x0000000115152812ULL, 0x000fe400078efcffULL, 0x000000a8ab00720bULL, 0x000fe40003f5d000ULL,
0x0000000175754812ULL, 0x000fe200078efcffULL, 0x0000003400b77306ULL, 0x000ee20000005400ULL,
0x000000c3c400720bULL, 0x000fe20003f9d000ULL, 0x000000b32424b231ULL, 0x082fe200003400ffULL,
0x0000000178780812ULL, 0x000fe200078efcffULL, 0x000000b32626b231ULL, 0x000fe200003400ffULL,
0x000000b1ae00720bULL, 0x000fe20003f1d000ULL, 0x000000b22525b231ULL, 0x080fe200003400ffULL,
0x00000001cece5812ULL, 0x004fe200078efcffULL, 0x00000034005d7306ULL, 0x0002a2000000d400ULL,
0x000000c7ca00720bULL, 0x000fe20003fbd000ULL, 0x000000b22727b231ULL, 0x000fe200003400ffULL,
0x0000000158582812ULL, 0x000fc400078efcffULL, 0x000000a09f00720bULL, 0x000fe40003f5d000ULL,
0x000000017a7a4812ULL, 0x000fe200078efcffULL, 0x0000003500aa7306ULL, 0x000fe20000009400ULL,
0x0001000034347824ULL, 0x002fe200078e00ffULL, 0x000000b7b400720bULL, 0x008fe40003f9d000ULL,
0x0000000164646812ULL, 0x000fe400078efcffULL, 0x000000017e7e5812ULL, 0x000fe400078efcffULL,
0x000000b52e00720bULL, 0x000fe20003fbd000ULL, 0x0000003500ad7306ULL, 0x000e620000005400ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x000000cfbe2e723eULL, 0x000fe400000010ffULL,
0x000000017c7c2812ULL, 0x000fe400078efcffULL, 0x000000868500720bULL, 0x000fe20003f5d000ULL,
0x00000035005c7306ULL, 0x0007e2000000d400ULL, 0x0000008b8a00720bULL, 0x000fe20003fdd000ULL,
0x0000002e3050723cULL, 0x000fe20000041850ULL, 0x0000000177770812ULL, 0x000fe400078efcffULL,
0x0000000167675812ULL, 0x000fc400078efcffULL, 0x000000a6a500720bULL, 0x000fe20003fbd000ULL,
0x0000003400897306ULL, 0x000fe20000209400ULL, 0x0001000035357824ULL, 0x008fe200078e00ffULL,
0x000000b0a32e723eULL, 0x000fe400000010ffULL, 0x000000a99e2f723eULL, 0x000fe400000010ffULL,
0x00000018ffb87819ULL, 0x000fe40000011435ULL, 0x0000003400c67306ULL, 0x000ee20000205400ULL,
0x000000c2d135723eULL, 0x000fc400000010ffULL, 0x0000002e3048723cULL, 0x000fe20000041848ULL,
0x0000000179795812ULL, 0x000fe400078efcffULL, 0x000000016a6a2812ULL, 0x000fe400078efcffULL,
0x0000003400b97306ULL, 0x0008e2000020d400ULL, 0x000000015d5d4812ULL, 0x004fe400078efcffULL,
0x000000a2932e723eULL, 0x000fe400000010ffULL, 0x0000009d8c2f723eULL, 0x000fc400000010ffULL,
0x000000bcbb00720bULL, 0x000fe20003f7d000ULL, 0x0000003600947306ULL, 0x000fe20000009400ULL,
0x000000c5d034723eULL, 0x010fe400000010ffULL, 0x000000adaa00720bULL, 0x002fe20003f1d000ULL,
0x0000002e3040723cULL, 0x000fe20000041840ULL, 0x000000999800720bULL, 0x000fe40003fbd000ULL,
0x000000848300720bULL, 0x000fe20003f5d000ULL, 0x0000003600957306ULL, 0x000e620000005400ULL,
0x000000c68900720bULL, 0x008fc40003f9d000ULL, 0x000000975e97723eULL, 0x000fe200000010ffULL,
0x000000343054723cULL, 0x040fe20000041854ULL, 0x0000005f822e723eULL, 0x000fe400000010ffULL,
0x000000ce7b2f723eULL, 0x000fe200000010ffULL, 0x000000b800b67306ULL, 0x000fe20000209400ULL,
0x0000000180806812ULL, 0x000fe400078efcffULL, 0x000000acc134723eULL, 0x000fe400000010ffULL,
0x000000a4af35723eULL, 0x000fe200000010ffULL, 0x0000002e3038723cULL, 0x000fe20000041838ULL,
0x000000762d00720bULL, 0x000fe20003fdd000ULL, 0x000000b800b37306ULL, 0x000ea20000205400ULL,
0x0000000119193812ULL, 0x000fc400078efcffULL, 0x000000017d7d5812ULL, 0x000fe400078efcffULL,
0x0000000181812812ULL, 0x000fe200078efcffULL, 0x00000034304c723cULL, 0x000fe2000004184cULL,
0x000000015c5c0812ULL, 0x000fe200078efcffULL, 0x000000cb00ae7306ULL, 0x000fe20000209400ULL,
0x00000001b9b94812ULL, 0x000fe400078efcffULL, 0x000000929100720bULL, 0x000fe40003f7d000ULL,
0x0000009ca734723eULL, 0x000fc400000010ffULL, 0x00000096a135723eULL, 0x000fe200000010ffULL,
0x000000cb00ab7306ULL, 0x000ee20000205400ULL, 0x0000009b9a96723eULL, 0x000fe400000010ffULL,
0x000000959400720bULL, 0x002fe40003fbd000ULL, 0x000000b3b600720bULL, 0x004fe20003f5d000ULL,
0x000000343044723cULL, 0x000fe20000041844ULL, 0x000000746f00720bULL, 0x000fe20003f1d000ULL,
0x0000003600877306ULL, 0x0002a2000000d400ULL, 0x000000017f7f3812ULL, 0x000fc400078efcffULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x000000157835723eULL, 0x000fe200000010ffULL,
0x00000096303c723cULL, 0x000fe2000004183cULL, 0x0000006b7000720bULL, 0x000fe20003fdd000ULL,
0x00000037008d7306ULL, 0x000fe20000009400ULL, 0x0001000036367824ULL, 0x002fe200078e00ffULL,
0x000000abae00720bULL, 0x008fe40003f9d000ULL, 0x000000016d6d0812ULL, 0x000fe400078efcffULL,
0x00000018ff367819ULL, 0x000fc40000011436ULL, 0x00000037008e7306ULL, 0x000e620000005400ULL,
0x0000000187875812ULL, 0x004fe400078efcffULL, 0x000000757e34723eULL, 0x000fe400000010ffULL,
0x0000000171716812ULL, 0x000fe400078efcffULL, 0x0000007a6776723eULL, 0x000fe200000010ffULL,
0x0000003700887306ULL, 0x0004e2000000d400ULL, 0x000000775877723eULL, 0x000fe200000010ffULL,
0x000000342454723cULL, 0x000fe20000041854ULL, 0x00000060792e723eULL, 0x000fc400000010ffULL,
0x000000197c2f723eULL, 0x000fe400000010ffULL, 0x0000007d647e723eULL, 0x000fe200000010ffULL,
0x000000b800b27306ULL, 0x000f22000020d400ULL, 0x0001000037377824ULL, 0x004fe200078e00ffULL,
0x0000008e8d00720bULL, 0x002fe20003f7d000ULL, 0x000000762450723cULL, 0x000fe20000041850ULL,
0x0000007f6a7f723eULL, 0x000fe400000010ffULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x000000cb009e7306ULL, 0x000e62000020d400ULL, 0x0000005d8080723eULL, 0x000fc400000010ffULL,
0x0000005c8181723eULL, 0x000fe200000010ffULL, 0x0000002e244c723cULL, 0x040fe2000004184cULL,
0x000000b97272723eULL, 0x000fe400000010ffULL, 0x0000000188883812ULL, 0x008fe200078efcffULL,
0x000000cc00987306ULL, 0x000fe20000209400ULL, 0x00000001b2b22812ULL, 0x010fe400078efcffULL,
0x000000736e00720bULL, 0x000fe20003f5d000ULL, 0x0000007e2448723cULL, 0x000fe20000041848ULL,
0x000000b26d73723eULL, 0x000fc600000010ffULL, 0x000000cc00857306ULL, 0x000ea20000205400ULL,
0x000000019e9e4812ULL, 0x002fc600078efcffULL, 0x000000802444723cULL, 0x000fe20000041844ULL,
0x000000879e9e723eULL, 0x000fc600000010ffULL, 0x00000036005e7306ULL, 0x000fe20000209400ULL,
0x000000016c6c2812ULL, 0x000fc600078efcffULL, 0x000000722440723cULL, 0x000fe80000041840ULL,
0x0000003600157306ULL, 0x000e620000205400ULL, 0x000000859800720bULL, 0x004fce0003f1d000ULL,
0x00000037002d7306ULL, 0x000ff00000209400ULL, 0x0000003700307306ULL, 0x000ea20000205400ULL,
0x000000155e00720bULL, 0x002fce0003f9d000ULL, 0x000000cc009f7306ULL, 0x000e70000020d400ULL,
0x0000003600367306ULL, 0x000ee2000020d400ULL, 0x000000302d00720bULL, 0x004fce0003fbd000ULL,
0x0000003700377306ULL, 0x000ea2000020d400ULL, 0x000000019f9f0812ULL, 0x002fc800078efcffULL,
0x000000889f9f723eULL, 0x000fe400000010ffULL, 0x0000000136364812ULL, 0x008fc800078efcffULL,
0x000000367136723eULL, 0x000fe200000010ffULL, 0x0000009e243c723cULL, 0x000fe2000004183cULL,
0x0000000137375812ULL, 0x004fc800078efcffULL, 0x000000376c37723eULL, 0x000fce00000010ffULL,
0x000000362438723cULL, 0x000fe20000041838ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200016247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c01c1c7810ULL, 0x000fe20007ffe0ffULL,
0x00f6980059ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff317224ULL, 0x004fe200078e0025ULL,
0x000000011a157812ULL, 0x000fe200078e0cffULL, 0x000000ffff197224ULL, 0x000fe200078e005bULL,
0x000000031c00720cULL, 0x000fda0003f06070ULL, 0x00002cd000000947ULL, 0x000fea0003800000ULL,
0x00000400171c7984ULL, 0x008ea40000000800ULL, 0x800000001cff7812ULL, 0x004fe40007804831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x00002400161c7984ULL, 0x000ea40000000800ULL,
0x800000001cff7812ULL, 0x004fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff157424ULL, 0x000fc800078e00ffULL,
0x0000001500197305ULL, 0x0004e4000021f000ULL, 0x3fa0000015157823ULL, 0x004fe200000100ffULL,
0x000000190000735dULL, 0x008fe20003800000ULL, 0x00002400161c7984ULL, 0x000ea40000000800ULL,
0x800000001cff7812ULL, 0x004fc40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000030b157812ULL, 0x000fe200078ec0ffULL, 0x000058000a277a24ULL, 0x020fe400078e02ffULL,
0xffffffffff0a7424ULL, 0x000fe200078e00ffULL, 0x000000031500780cULL, 0x000fc80003f05270ULL,
0x00000001091c7807ULL, 0x000fca0004000000ULL, 0x000000010b0b7824ULL, 0x000fca00078e021cULL,
0x000000040b00720cULL, 0x000fe40003f06070ULL, 0x0000030005157a10ULL, 0x000fca0007ffe0ffULL,
0x00000100151c7824ULL, 0x000fcc00078e020eULL, 0x0000000118248824ULL, 0x000fe400078e020bULL,
0x00000004ff258424ULL, 0x000fe200078e00ffULL, 0x000000200f267812ULL, 0x000fc600078ef81cULL,
0x0000600024248625ULL, 0x000fe200078e0025ULL, 0x0000000115157810ULL, 0x000fe40007ffe0ffULL,
0x0000001c03197217ULL, 0x000fe20007800000ULL, 0x00000040272e7824ULL, 0x000fe200078e00ffULL,
0x00000006240a8981ULL, 0x000562000c1e1900ULL, 0x000000061500720cULL, 0x000fe20003f06070ULL,
0x000000011b1b7824ULL, 0x000fe200078e0226ULL, 0x00000003ff367819ULL, 0x000fe20000011602ULL,
0x0000000119197824ULL, 0x000fe200078e0a1cULL, 0x00000000650473c2ULL, 0x000ee200000e0000ULL,
0x0000001000157824ULL, 0x000fe200078e00ffULL, 0x0000001b2e1b7210ULL, 0x000fe20007f5e0ffULL,
0x000000011f1f7824ULL, 0x100fe200078e0226ULL, 0x0000002019197807ULL, 0x000fe20000000000ULL,
0x000000011d1d7824ULL, 0x100fe200078e0226ULL, 0x0000001015247812ULL, 0x004fe200078ec0ffULL,
0x0000000121217824ULL, 0x000fe200078e0226ULL, 0x00005e001b347a11ULL, 0x000fe200078038ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x0000001924197217ULL, 0x000fe20007800000ULL,
0x0000001023237824ULL, 0x000fe200078e0261ULL, 0x0000001f2e1f7210ULL, 0x000fc40007f5e0ffULL,
0x0000001d2e1d7210ULL, 0x040fe20007f7e0ffULL, 0x0000000119197824ULL, 0x000fe200078e0a24ULL,
0x000000212e217210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0x00005f001b1b7a11ULL, 0x000fe200000f3c1cULL, 0x000000ffff327224ULL, 0x000fe200018e06ffULL,
0x00005e001f267a11ULL, 0x000fe200078438ffULL, 0x000000ffff1c7224ULL, 0x000fe200020e06ffULL,
0x00005e001d307a11ULL, 0x000fe400078038ffULL, 0x00005e00212e7a11ULL, 0x000fc400078638ffULL,
0x00005f001f277a11ULL, 0x000fe400010f3c24ULL, 0x00005f001d157a11ULL, 0x000fe400000f3c32ULL,
0x0000002930247210ULL, 0x080fe40007fbe0ffULL, 0x00005f00211f7a11ULL, 0x000fe400018f3c1cULL,
0x0000000436587810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff257224ULL, 0x000fe200028e0615ULL,
0x00000029341c7210ULL, 0x000fe20007f9e0ffULL, 0x000000101e157824ULL, 0x000fe200078e0261ULL,
0x0000000836327810ULL, 0x000fc40007ffe0ffULL, 0x000000193600720cULL, 0x040fe20003f66070ULL,
0x000000ffff1d7224ULL, 0x000fe200020e061bULL, 0x0000000c36367810ULL, 0x000fe20007ffe0ffULL,
0x00000010221b7824ULL, 0x000fe200078e0261ULL, 0x0000002926267210ULL, 0x000fe40007fbe0ffULL,
0x000000195800720cULL, 0x080fe40003f46070ULL, 0x000000193200720cULL, 0x080fe20003f06070ULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x000000193600720cULL, 0x000fe20003f86070ULL,
0x0000001020197824ULL, 0x000fe200078e0261ULL, 0x000000292e1e7210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c157faeULL, 0x0005e8000d901c46ULL,
0x000000ffff1f7224ULL, 0x000fc400028e061fULL, 0x0000000024197faeULL, 0x0005e8000d101c46ULL,
0x00000000261b7faeULL, 0x0005e8000c101c46ULL, 0x000000001e237faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x008fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000651c7f8cULL, 0x0044e8000c80043fULL, 0x0000040066157984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f66800281e7f8cULL, 0x000fe2000c80043fULL, 0x8000000015ff7812ULL, 0x010fc6000784485bULL,
0x00f66c0028197984ULL, 0x000f240000000800ULL, 0x8000000019ff7812ULL, 0x010fe4000780481fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x000000ffff197224ULL, 0x008fe200078e001dULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff157424ULL, 0x000fc800078e00ffULL, 0x00000015001b7305ULL, 0x000724000021f000ULL,
0x3fa0000015157823ULL, 0x008fe200000100ffULL, 0x0000001b0000735dULL, 0x010fe40003800000ULL,
0x00f66c00281b7984ULL, 0x000ee40000000800ULL, 0x800000001bff7812ULL, 0x008fc4000780481fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000157824ULL, 0x000fca00078e00ffULL,
0xffffff80151c7812ULL, 0x000fc800078ec0ffULL, 0x0000018029157810ULL, 0x000fca0007ffe01cULL,
0x000000012a157824ULL, 0x000fca00078e0215ULL, 0x00f00000151c7984ULL, 0x000ee80000000800ULL,
0x00f20000151b7984ULL, 0x0008620000000800ULL, 0x000000111c00720bULL, 0x008fe20003f1d000ULL,
0x0000c5727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000157806ULL, 0x010fc800000e0100ULL,
0x0000ffff151d7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff977424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000307157810ULL, 0x000fe40007ffe0ffULL, 0x000000111c00720bULL, 0x000fe40003f14000ULL,
0x000000001500720cULL, 0x000fe20003f65270ULL, 0x0000c5427f007947ULL, 0x000ff4000b800000ULL,
0x0000000000157806ULL, 0x000fe400000e0100ULL, 0x0000001c111f7209ULL, 0x000fe20007810000ULL,
0x000000800029b824ULL, 0x000fe200078e0229ULL, 0x0000ffff151e7812ULL, 0x000fe400078e3cffULL,
0x00000002ff347819ULL, 0x000fe20000011602ULL, 0x000000012a2ab824ULL, 0x000fe200078e0229ULL,
0x0000001e1dff7212ULL, 0x000fe2000780c0ffULL, 0x8000001f11117221ULL, 0x000fc60000010000ULL,
0x00f4001f2a00b388ULL, 0x0007e20000000800ULL, 0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL,
0x0000001100337308ULL, 0x000f240000000800ULL, 0x0000003312127220ULL, 0x010fe20000410000ULL,
0x0000c4d27f007947ULL, 0x000fea000b800000ULL, 0x00001f3433117589ULL, 0x00872400000e0000ULL,
0x0000001154547220ULL, 0x090fe40000410000ULL, 0x0000001155557220ULL, 0x080fe40000410000ULL,
0x0000001150507220ULL, 0x080fe40000410000ULL, 0x0000001151517220ULL, 0x080fe40000410000ULL,
0x000000114c4c7220ULL, 0x000fc40000410000ULL, 0x000000114d4d7220ULL, 0x080fe40000410000ULL,
0x0000001148487220ULL, 0x080fe40000410000ULL, 0x0000001149497220ULL, 0x080fe40000410000ULL,
0x0000001144447220ULL, 0x080fe40000410000ULL, 0x0000001145457220ULL, 0x080fe40000410000ULL,
0x0000001140407220ULL, 0x000fc40000410000ULL, 0x0000001141417220ULL, 0x080fe40000410000ULL,
0x000000113c3c7220ULL, 0x080fe40000410000ULL, 0x000000113d3d7220ULL, 0x080fe40000410000ULL,
0x0000001138387220ULL, 0x080fe40000410000ULL, 0x0000001139397220ULL, 0x000fe20000410000ULL,
0x0000c4127f007947ULL, 0x000fea000b800000ULL, 0x00001f2c33117589ULL, 0x0008a400000e0000ULL,
0x8000001f1c1c0221ULL, 0x000fe20000010000ULL, 0x00000001ff977807ULL, 0x000fe20000000000ULL,
0x0000001156567220ULL, 0x004fc40000410000ULL, 0x3fb8aa3b1c1c0820ULL, 0x000fe40000410000ULL,
0x0000001157577220ULL, 0x080fe40000410000ULL, 0x0000001c002b0308ULL, 0x000ea20000000800ULL,
0x0000001152527220ULL, 0x080fe40000410000ULL, 0x0000001153537220ULL, 0x080fe40000410000ULL,
0x000000114e4e7220ULL, 0x080fe40000410000ULL, 0x000000114f4f7220ULL, 0x000fc40000410000ULL,
0x000000114a4a7220ULL, 0x080fe40000410000ULL, 0x000000114b4b7220ULL, 0x080fe40000410000ULL,
0x0000001146467220ULL, 0x080fe40000410000ULL, 0x0000001147477220ULL, 0x080fe40000410000ULL,
0x0000001142427220ULL, 0x080fe40000410000ULL, 0x0000001143437220ULL, 0x000fc40000410000ULL,
0x000000113e3e7220ULL, 0x080fe40000410000ULL, 0x000000113f3f7220ULL, 0x080fe40000410000ULL,
0x000000113a3a7220ULL, 0x080fe40000410000ULL, 0x000000113b3b7220ULL, 0x000fe40000410000ULL,
0x000000ffff117224ULL, 0x000fe400078e001fULL, 0x0000001b2b1b0220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x000000121b127221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x000000081a157824ULL, 0x000fe200078e00ffULL, 0xfffffff0081c7812ULL, 0x000fc800078ec0ffULL,
0x0000000815157812ULL, 0x000fca00078e0cffULL, 0x000000011c157824ULL, 0x000fcc00078e0215ULL,
0x00f6ac0015157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe4000780485bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff157424ULL, 0x000fc800078e00ffULL, 0x00000015001b7305ULL, 0x0002a4000021f000ULL,
0x3fa0000015157823ULL, 0x002fe200000100ffULL, 0x0000001b0000735dULL, 0x004fe40003800000ULL,
0x00000400661b7984ULL, 0x000e640000000800ULL, 0x800000001bff7812ULL, 0x002fc4000780485bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff347819ULL, 0x008fe40000011602ULL,
0x0000002bff1c723eULL, 0x000fe400000010ffULL, 0x0000001834157810ULL, 0x040fe40007ffe0ffULL,
0x00000010341b7810ULL, 0x000fe40007ffe0ffULL, 0x000054101c337816ULL, 0x010fe2000000001cULL,
0x0000c1627f007947ULL, 0x000fea000b800000ULL, 0x00001f3433937589ULL, 0x0002e400000e0000ULL,
0x0000c1a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2c33947589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff347224ULL, 0x002fe200078e001bULL,
0x0000ac4000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000c8a000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff347224ULL, 0x002fe200078e0015ULL,
0x0000aca000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000c84000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000681c783bULL, 0x000f220000004200ULL,
0x0000991097977816ULL, 0x000fc600000000ffULL, 0x000000006920783bULL, 0x000fe80000004200ULL,
0x00000000132c783bULL, 0x010f280000004200ULL, 0x000000001424783bULL, 0x000ee20000004200ULL,
0x00000018ff347819ULL, 0x002fe2000001141eULL, 0x0000001c00d27306ULL, 0x000fe20000009400ULL,
0x00000018ff327819ULL, 0x004fe2000001141cULL, 0x000001001c6d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff337819ULL, 0x000fc4000001141dULL, 0x00000018ff357819ULL, 0x000fe4000001141fULL,
0x00000018ff5b7819ULL, 0x010fe2000001142eULL, 0x0000003400c27306ULL, 0x000fe20000209400ULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x00000018ff6e7819ULL, 0x008fe40000011425ULL,
0x00000018ff367819ULL, 0x000fe4000001142cULL, 0x00000018ff377819ULL, 0x000fe2000001142dULL,
0x0000003400cd7306ULL, 0x000fe20000205400ULL, 0x00000018ff5e7819ULL, 0x000fc4000001142fULL,
0x00000018ff617819ULL, 0x000fe40000011424ULL, 0x00000018ff707819ULL, 0x000fe40000011426ULL,
0x00000018ff747819ULL, 0x000fe20000011427ULL, 0x0000003400867306ULL, 0x0003f0000020d400ULL,
0x0000001c00957306ULL, 0x000ea20000005400ULL, 0x00000018ff347819ULL, 0x002fce0000011422ULL,
0x0000001c009e7306ULL, 0x0002f0000000d400ULL, 0x0000003400a67306ULL, 0x000fe20000209400ULL,
0x000100001c1c7824ULL, 0x002fe200078e00ffULL, 0x00000095d200720bULL, 0x004fcc0003f1d000ULL,
0x0000003400a57306ULL, 0x000fee0000205400ULL, 0x000000019e9e0812ULL, 0x008fe200078efcffULL,
0x00000034006c7306ULL, 0x000ff0000020d400ULL, 0x0000005b00797306ULL, 0x000ff00000209400ULL,
0x0000005b007a7306ULL, 0x000ff00000205400ULL, 0x0000005b00347306ULL, 0x000ff0000020d400ULL,
0x0000006e005a7306ULL, 0x000ff00000209400ULL, 0x0000006e005b7306ULL, 0x000ff00000205400ULL,
0x0000006e005c7306ULL, 0x0003f0000020d400ULL, 0x0000003200d47306ULL, 0x000fe20000209400ULL,
0x00000018ff6e7819ULL, 0x002fce000001141cULL, 0x0000006e00d97306ULL, 0x000ff00000209400ULL,
0x0000006e001c7306ULL, 0x000e700000205400ULL, 0x0000003200d57306ULL, 0x000eb00000205400ULL,
0x0000003200147306ULL, 0x000722000020d400ULL, 0x0000001cd900720bULL, 0x002fe20003f5d000ULL,
0x00000100241c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000003300d37306ULL, 0x000fe20000209400ULL, 0x00000018ff327819ULL, 0x008fe40000011420ULL,
0x000000d5d400720bULL, 0x004fca0003fbd000ULL, 0x0000003300d07306ULL, 0x000ff00000205400ULL,
0x0000003300157306ULL, 0x0003e2000020d400ULL, 0x0000000114145812ULL, 0x010fce00078efcffULL,
0x0000003500ce7306ULL, 0x000fe20000209400ULL, 0x00000018ff337819ULL, 0x002fce0000011421ULL,
0x0000003500cb7306ULL, 0x000ff00000205400ULL, 0x00000035007d7306ULL, 0x0003f0000020d400ULL,
0x0000006e009f7306ULL, 0x0004e2000020d400ULL, 0x00000018ff357819ULL, 0x002fce0000011423ULL,
0x0000006d00d67306ULL, 0x000fe20000209400ULL, 0x000001001f6e7824ULL, 0x004fca00078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x0000006d00d77306ULL, 0x000e620000205400ULL,
0x000000019f9f2812ULL, 0x008fe400078efcffULL, 0x000000d0d300720bULL, 0x000fe40003f5d000ULL,
0x0000009f1414723eULL, 0x000fc600000010ffULL, 0x0000003200c47306ULL, 0x000ff00000209400ULL,
0x0000003200c17306ULL, 0x000fe20000205400ULL, 0x000000d7d600720bULL, 0x002fe40003f9d000ULL,
0x0000000115152812ULL, 0x000fc400078efcffULL, 0x000000cdc200720bULL, 0x000fc60003f5d000ULL,
0x0000003200787306ULL, 0x000ff0000020d400ULL, 0x0000003300c37306ULL, 0x000fe40000209400ULL,
0x0000000186862812ULL, 0x000fcc00078efcffULL, 0x0000003300c67306ULL, 0x000ff00000205400ULL,
0x0000003300717306ULL, 0x000ff0000020d400ULL, 0x0000003500ac7306ULL, 0x000ff00000209400ULL,
0x0000003500ad7306ULL, 0x000ff00000205400ULL, 0x0000003500687306ULL, 0x000ff0000020d400ULL,
0x00000036009c7306ULL, 0x000ff00000209400ULL, 0x00000036009b7306ULL, 0x000ff00000205400ULL,
0x0000003600327306ULL, 0x000ff0000020d400ULL, 0x00000037008e7306ULL, 0x000ff00000209400ULL,
0x00000037008d7306ULL, 0x000ff00000205400ULL, 0x0000003700337306ULL, 0x000ff0000020d400ULL,
0x0000005e00727306ULL, 0x000ff00000209400ULL, 0x0000005e00737306ULL, 0x000ff00000205400ULL,
0x0000005e00357306ULL, 0x000ff0000020d400ULL, 0x0000006100367306ULL, 0x000ff00000209400ULL,
0x0000006100377306ULL, 0x000ff00000205400ULL, 0x0000006100587306ULL, 0x000ff0000020d400ULL,
0x00000070005d7306ULL, 0x000ff00000209400ULL, 0x00000070005e7306ULL, 0x000ff00000205400ULL,
0x00000070005f7306ULL, 0x0003f0000020d400ULL, 0x0000001d00ae7306ULL, 0x000fe20000009400ULL,
0x000001001d707824ULL, 0x002fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000001d00d17306ULL, 0x000e700000005400ULL, 0x0000001d009d7306ULL, 0x0004f0000000d400ULL,
0x0000007400607306ULL, 0x000fe20000209400ULL, 0x000100001d1d7824ULL, 0x004fe200078e00ffULL,
0x000000d1ae00720bULL, 0x002fcc0003f7d000ULL, 0x0000007400617306ULL, 0x000fee0000205400ULL,
0x000000019d9d3812ULL, 0x008fe200078efcffULL, 0x0000007400647306ULL, 0x0003f0000020d400ULL,
0x0000006d00af7306ULL, 0x0004e2000020d400ULL, 0x000001001e747824ULL, 0x002fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000001e00cf7306ULL, 0x000fe20000009400ULL,
0x00000018ff6d7819ULL, 0x004fce000001141dULL, 0x0000006d001d7306ULL, 0x000fe20000209400ULL,
0x00000001afaf4812ULL, 0x008fce00078efcffULL, 0x0000006d00da7306ULL, 0x000e700000205400ULL,
0x0000007400dc7306ULL, 0x000ff00000209400ULL, 0x0000007400dd7306ULL, 0x000ea20000205400ULL,
0x000000da1d00720bULL, 0x002fe20003f9d000ULL, 0x00000100251d7824ULL, 0x000fcc00078e00ffULL,
0x0000001e00967306ULL, 0x000e700000005400ULL, 0x0000001e008f7306ULL, 0x0007e2000000d400ULL,
0x000000dddc00720bULL, 0x004fce0003fbd000ULL, 0x0000007400927306ULL, 0x000522000020d400ULL,
0x000100001e1e7824ULL, 0x008fe200078e00ffULL, 0x00000096cf00720bULL, 0x002fcc0003f1d000ULL,
0x0000006d00987306ULL, 0x0002e2000020d400ULL, 0x0000010020747824ULL, 0x004fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000002100c87306ULL, 0x000fe20000009400ULL,
0x00000018ff6d7819ULL, 0x002fe4000001141eULL, 0x0000000192925812ULL, 0x010fe400078efcffULL,
0x000000cbce00720bULL, 0x000fe40003fbd000ULL, 0x000000018f8f0812ULL, 0x000fe200078efcffULL,
0x0000002100c77306ULL, 0x000e620000005400ULL, 0x0000000198984812ULL, 0x008fc800078efcffULL,
0x000000981515723eULL, 0x000fc600000010ffULL, 0x0000007000db7306ULL, 0x000fe40000209400ULL,
0x000000017d7d5812ULL, 0x000fcc00078efcffULL, 0x0000007000d87306ULL, 0x000ea20000205400ULL,
0x000000c7c800720bULL, 0x002fe40003f5d000ULL, 0x00000018ffc77819ULL, 0x000fca000001141dULL,
0x0000006d001e7306ULL, 0x000ff00000209400ULL, 0x0000006d00e17306ULL, 0x000e620000205400ULL,
0x000000d8db00720bULL, 0x004fce0003fdd000ULL, 0x0000002000c97306ULL, 0x000ff00000009400ULL,
0x0000002000c07306ULL, 0x000fe20000005400ULL, 0x000000e11e00720bULL, 0x002fce0003f9d000ULL,
0x0000002000817306ULL, 0x0003f0000000d400ULL, 0x0000006e00df7306ULL, 0x000fe20000209400ULL,
0x0001000020207824ULL, 0x002fce00078e00ffULL, 0x0000006e00de7306ULL, 0x000ff00000205400ULL,
0x0000006e008c7306ULL, 0x0003f0000020d400ULL, 0x0000007400e27306ULL, 0x000fe20000209400ULL,
0x00000100216e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x0000007400e37306ULL, 0x000ff00000205400ULL, 0x00000074008a7306ULL, 0x0003f0000020d400ULL,
0x0000006d008b7306ULL, 0x0004e2000020d400ULL, 0x0000010022747824ULL, 0x002fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000001f00cc7306ULL, 0x000fe20000009400ULL,
0x00000018ff6d7819ULL, 0x004fce0000011420ULL, 0x0000001f00b37306ULL, 0x000e620000005400ULL,
0x000000018b8b4812ULL, 0x008fc800078efcffULL, 0x0000008b8686723eULL, 0x000fc600000010ffULL,
0x0000001f00877306ULL, 0x0004f0000000d400ULL, 0x0000002100777306ULL, 0x0008e2000000d400ULL,
0x000100001f1f7824ULL, 0x004fe200078e00ffULL, 0x000000b3cc00720bULL, 0x002fcc0003f7d000ULL,
0x0000007000b07306ULL, 0x0002a2000020d400ULL, 0x0001000021217824ULL, 0x010fcc00078e00ffULL,
0x0000000187873812ULL, 0x008fe200078efcffULL, 0x0000006e00e47306ULL, 0x000fe20000209400ULL,
0x00000018ff707819ULL, 0x002fe4000001141fULL, 0x0000000177772812ULL, 0x000fe400078efcffULL,
0x000000e3e200720bULL, 0x000fc60003f7d000ULL, 0x0000006e00e57306ULL, 0x000e620000205400ULL,
0x00000001b0b06812ULL, 0x004fe400078efcffULL, 0x000000dedf00720bULL, 0x000fca0003fdd000ULL,
0x0000006d00207306ULL, 0x000fe40000209400ULL, 0x000000018a8a3812ULL, 0x000fe400078efcffULL,
0x000000c1c400720bULL, 0x000fc80003f7d000ULL, 0x0000006d00e77306ULL, 0x000ea20000205400ULL,
0x000000e5e400720bULL, 0x002fe40003f9d000ULL, 0x000000018c8c6812ULL, 0x000fe400078efcffULL,
0x000000c0c900720bULL, 0x000fc60003fdd000ULL, 0x0000007400e87306ULL, 0x000fe20000209400ULL,
0x0000000178783812ULL, 0x000fce00078efcffULL, 0x0000007400e97306ULL, 0x000e620000205400ULL,
0x000000e72000720bULL, 0x004fe40003fbd000ULL, 0x0000000181816812ULL, 0x000fe400078efcffULL,
0x000000c6c300720bULL, 0x000fe40003fdd000ULL, 0x000000818a8a723eULL, 0x000fe200000010ffULL,
0x0000002200ca7306ULL, 0x000ff00000009400ULL, 0x0000002200c57306ULL, 0x000fe20000005400ULL,
0x000000e9e800720bULL, 0x002fc40003f5d000ULL, 0x0000000171716812ULL, 0x000fe400078efcffULL,
0x000000a5a600720bULL, 0x000fe20003fdd000ULL, 0x0001000026a57824ULL, 0x000fe400078e00ffULL,
0x00000022006f7306ULL, 0x0003e2000000d400ULL, 0x0000010027a67824ULL, 0x000fe400078e00ffULL,
0x00000018ffa57819ULL, 0x000fc600000114a5ULL, 0x00000018ffa67819ULL, 0x000fe400000114a6ULL,
0x0000006e00827306ULL, 0x0004e2000020d400ULL, 0x0001000022227824ULL, 0x002fe200078e00ffULL,
0x000000016c6c6812ULL, 0x000fc800078efcffULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000070001f7306ULL, 0x000fe20000209400ULL, 0x00000100236e7824ULL, 0x004fca00078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x0000007000e07306ULL, 0x000e620000205400ULL,
0x0000000182824812ULL, 0x008fc800078efcffULL, 0x00000077828b723eULL, 0x000fc600000010ffULL,
0x0000007000887306ULL, 0x0005f0000020d400ULL, 0x0000006d00837306ULL, 0x000722000020d400ULL,
0x00000018ff707819ULL, 0x004fe40000011421ULL, 0x000000e01f00720bULL, 0x002fca0003f1d000ULL,
0x00000074007e7306ULL, 0x000e62000020d400ULL, 0x000001002c6d7824ULL, 0x008fca00078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x0000007000217306ULL, 0x000fe20000209400ULL,
0x0000000183835812ULL, 0x010fe400078efcffULL, 0x0000000188880812ULL, 0x000fe400078efcffULL,
0x000000c5ca00720bULL, 0x000fe40003f1d000ULL, 0x000000837878723eULL, 0x000fe200000010ffULL,
0x0000007000e67306ULL, 0x000ea20000205400ULL, 0x000000017e7e2812ULL, 0x002fce00078efcffULL,
0x0000006e00b67306ULL, 0x000fe40000209400ULL, 0x000000016f6f0812ULL, 0x000fe400078efcffULL,
0x000000adac00720bULL, 0x000fe40003f1d000ULL, 0x0000006f7e7e723eULL, 0x000fe400000010ffULL,
0x0000006e00b57306ULL, 0x000e620000205400ULL, 0x000000e62100720bULL, 0x004fce0003f9d000ULL,
0x0000002200b87306ULL, 0x000fe20000209400ULL, 0x0000000168680812ULL, 0x000fce00078efcffULL,
0x0000002200b77306ULL, 0x000ea20000205400ULL, 0x000000b5b600720bULL, 0x002fe20003fbd000ULL,
0x000000ffffb57224ULL, 0x000fca00078e0097ULL, 0x000000ffb500720cULL, 0x000fe20003f65270ULL,
0x0000002300a47306ULL, 0x000ff00000009400ULL, 0x0000002300ab7306ULL, 0x000fe20000005400ULL,
0x000000b7b800720bULL, 0x004fce0003f5d000ULL, 0x0000002300697306ULL, 0x0003f0000000d400ULL,
0x00000070007c7306ULL, 0x000ea2000020d400ULL, 0x0001000023237824ULL, 0x002fca00078e00ffULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x0000006e00767306ULL, 0x0002f0000020d400ULL,
0x00000022007b7306ULL, 0x0008e2000020d400ULL, 0x000001002d6e7824ULL, 0x002fe200078e00ffULL,
0x000000017c7c4812ULL, 0x004fc400078efcffULL, 0x000000aba400720bULL, 0x000fe20003f9d000ULL,
0x0000010026a47824ULL, 0x000fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe2000001146eULL,
0x0001000027ab7824ULL, 0x000fe200078e00ffULL, 0x0000002d00aa7306ULL, 0x000fe20000009400ULL,
0x000100002c227824ULL, 0x010fe200078e00ffULL, 0x0000000176765812ULL, 0x008fe400078efcffULL,
0x00000018ffa47819ULL, 0x000fe400000114a4ULL, 0x00000018ff227819ULL, 0x000fc40000011422ULL,
0x0000002d00a37306ULL, 0x000e620000005400ULL, 0x000000017b7b2812ULL, 0x000fe400078efcffULL,
0x0000000169694812ULL, 0x000fe400078efcffULL, 0x00000018ffab7819ULL, 0x000fc600000114abULL,
0x0000002300be7306ULL, 0x000ff00000209400ULL, 0x0000002300bf7306ULL, 0x000ea20000205400ULL,
0x000000a3aa00720bULL, 0x002fce0003f5d000ULL, 0x0000002300757306ULL, 0x0002f0000020d400ULL,
0x0000006d00bd7306ULL, 0x000fe20000209400ULL, 0x000100002d237824ULL, 0x002fe200078e00ffULL,
0x000000bfbe00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x0000006d00ba7306ULL, 0x000e6e0000205400ULL, 0x0000000175755812ULL, 0x008fe200078efcffULL,
0x0000006d00747306ULL, 0x0004f0000020d400ULL, 0x0000002d00137306ULL, 0x000f22000000d400ULL,
0x000001002e6d7824ULL, 0x004fe200078e00ffULL, 0x000000babd00720bULL, 0x002fc80003fbd000ULL,
0x00000018ffea7819ULL, 0x000fe2000001146dULL, 0x000001002f6d7824ULL, 0x000fe200078e00ffULL,
0x0000002c00a17306ULL, 0x000fe80000009400ULL, 0x00000018ffeb7819ULL, 0x000fc6000001146dULL,
0x0000000174745812ULL, 0x008fe200078efcffULL, 0x0000002c00a07306ULL, 0x000e620000005400ULL,
0x0000000113132812ULL, 0x010fe400078efcffULL, 0x0000008d8e00720bULL, 0x000fe40003f5d000ULL,
0x0000009b9c00720bULL, 0x000fc60003fbd000ULL, 0x0000002e00a97306ULL, 0x000ff00000009400ULL,
0x0000002e00a27306ULL, 0x000ea20000005400ULL, 0x000000a0a100720bULL, 0x002fe40003f9d000ULL,
0x0000000133332812ULL, 0x000fc400078efcffULL, 0x0000000132325812ULL, 0x000fc600078efcffULL,
0x0000002e001b7306ULL, 0x0002f0000000d400ULL, 0x0000002300b17306ULL, 0x000fe20000209400ULL,
0x000100002e2e7824ULL, 0x002fe200078e00ffULL, 0x000000a2a900720bULL, 0x004fcc0003fdd000ULL,
0x0000002300b27306ULL, 0x000fee0000205400ULL, 0x000000011b1b6812ULL, 0x008fe200078efcffULL,
0x00000023006e7306ULL, 0x0003e2000020d400ULL, 0x0000007a7900720bULL, 0x000fe40003fdd000ULL,
0x0000007c7179723eULL, 0x000fca00000010ffULL, 0x0000002200b97306ULL, 0x000fe20000209400ULL,
0x000100002f237824ULL, 0x002fca00078e00ffULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x0000002200b47306ULL, 0x000fe20000205400ULL, 0x0000000134346812ULL, 0x000fce00078efcffULL,
0x00000022002d7306ULL, 0x0003f0000020d400ULL, 0x0000002f00a77306ULL, 0x000fe20000009400ULL,
0x00000018ff227819ULL, 0x002fce000001142eULL, 0x0000002f00a87306ULL, 0x000ff00000005400ULL,
0x0000002f00287306ULL, 0x000ff0000000d400ULL, 0x00000022002e7306ULL, 0x000ff00000209400ULL,
0x0000002200897306ULL, 0x000ff00000205400ULL, 0x00000022002f7306ULL, 0x000ff0000020d400ULL,
0x0000002300957306ULL, 0x000ff00000209400ULL, 0x0000002300ae7306ULL, 0x000ff00000205400ULL,
0x0000002300967306ULL, 0x0003f0000020d400ULL, 0x0000002c00677306ULL, 0x000ea2000000d400ULL,
0x00a800006320783bULL, 0x002e6e0000000200ULL, 0x0000007000bb7306ULL, 0x000ff00000209400ULL,
0x0000007000bc7306ULL, 0x000ee20000205400ULL, 0x0000000167674812ULL, 0x004fc400078efcffULL,
0x000000b4b900720bULL, 0x000fe40003f9d000ULL, 0x000000677474723eULL, 0x000fc600000010ffULL,
0x000000eb00907306ULL, 0x000ff00000209400ULL, 0x000000eb00917306ULL, 0x000ea20000205400ULL,
0x000000bcbb00720bULL, 0x008fe40003f1d000ULL, 0x000000012d2d4812ULL, 0x000fc800078efcffULL,
0x0000002d3232723eULL, 0x000fe200000010ffULL, 0x0000001c00b37306ULL, 0x000fe20000209400ULL,
0x000000932020b231ULL, 0x082fe400003400ffULL, 0x000000932222b231ULL, 0x000fe400003400ffULL,
0x000000942121b231ULL, 0x080fe400003400ffULL, 0x000000942323b231ULL, 0x000fe200003400ffULL,
0x0000001c00c27306ULL, 0x000e620000205400ULL, 0x000000919000720bULL, 0x004fca0003f5d000ULL,
0x000000142050723cULL, 0x040fe40000041850ULL, 0x0000001c00c07306ULL, 0x0004ea000020d400ULL,
0x0000007b6c14723eULL, 0x000fe200000010ffULL, 0x0000008a2044723cULL, 0x000fe20000041844ULL,
0x000000756815723eULL, 0x000fe200000010ffULL, 0x00000070002c7306ULL, 0x000f22000020d400ULL,
0x00a80000621c783bULL, 0x004ea20000000200ULL, 0x000000c2b300720bULL, 0x002fc80003fdd000ULL,
0x000000142038723cULL, 0x040fe40000041838ULL, 0x000000eb006d7306ULL, 0x000e6c000020d400ULL,
0x000000782040723cULL, 0x000fe20000041840ULL, 0x00000001c0c06812ULL, 0x008fe200078efcffULL,
0x0000002400847306ULL, 0x000fe20000009400ULL, 0x000000012c2c0812ULL, 0x010fc400078efcffULL,
0x000000b2b100720bULL, 0x000fe40003f1d000ULL, 0x000000132c75723eULL, 0x000fe400000010ffULL,
0x000000373600720bULL, 0x000fe20003fdd000ULL, 0x0000002400857306ULL, 0x000ee20000005400ULL,
0x000000016d6d2812ULL, 0x002fe400078efcffULL, 0x000000737200720bULL, 0x000fca0003f5d000ULL,
0x000000ea00997306ULL, 0x000fe20000209400ULL, 0x000000016e6e0812ULL, 0x000fc600078efcffULL,
0x0000000158586812ULL, 0x000fe400078efcffULL, 0x0000005e5d00720bULL, 0x000fe40003fdd000ULL,
0x000000ea009a7306ULL, 0x000e620000205400ULL, 0x000000858400720bULL, 0x008fe20003f9d000ULL,
0x000000931c1cb231ULL, 0x084fe200003400ffULL, 0x0000000135352812ULL, 0x000fe200078efcffULL,
0x000000931e1eb231ULL, 0x000fe200003400ffULL, 0x0000006e3333723eULL, 0x000fe200000010ffULL,
0x000000941d1db231ULL, 0x000fc400003400ffULL, 0x0000002400297306ULL, 0x0004e2000000d400ULL,
0x000000941f1fb231ULL, 0x000fe200003400ffULL, 0x000000a8a700720bULL, 0x000fe40003f7d000ULL,
0x000000015f5f6812ULL, 0x000fc800078efcffULL, 0x000000ea00707306ULL, 0x000f22000020d400ULL,
0x0001000024247824ULL, 0x004fe200078e00ffULL, 0x0000009a9900720bULL, 0x002fe20003fbd000ULL,
0x000000321c50723cULL, 0x000fe60000041850ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000025007f7306ULL, 0x000fe20000009400ULL, 0x0000000129294812ULL, 0x008fe400078efcffULL,
0x0000000128283812ULL, 0x000fc400078efcffULL, 0x000000ae9500720bULL, 0x000fe40003f7d000ULL,
0x000000286d6d723eULL, 0x000fe200000010ffULL, 0x0000002500807306ULL, 0x000e620000005400ULL,
0x0000000170705812ULL, 0x010fe400078efcffULL, 0x000000892e00720bULL, 0x000fe40003fbd000ULL,
0x0000001b706c723eULL, 0x000fc600000010ffULL, 0x000000c700c57306ULL, 0x000fe40000209400ULL,
0x0000000196963812ULL, 0x000fc800078efcffULL, 0x000000963535723eULL, 0x000fe400000010ffULL,
0x000000c700c47306ULL, 0x000ea20000205400ULL, 0x000000807f00720bULL, 0x002fe40003f1d000ULL,
0x000000012f2f5812ULL, 0x000fe400078efcffULL, 0x00000069767f723eULL, 0x000fe400000010ffULL,
0x0000002f3434723eULL, 0x000fe200000010ffULL, 0x0000002400627306ULL, 0x000fe20000209400ULL,
0x00000029c096723eULL, 0x000fc600000010ffULL, 0x0000007e203c723cULL, 0x000fe8000004183cULL,
0x0000002400637306ULL, 0x000e620000205400ULL, 0x000000c4c500720bULL, 0x004fce0003f5d000ULL,
0x00000025002a7306ULL, 0x0004f0000000d400ULL, 0x00000026006a7306ULL, 0x000fe20000009400ULL,
0x0001000025257824ULL, 0x004fe200078e00ffULL, 0x000000636200720bULL, 0x002fcc0003f9d000ULL,
0x00000026006b7306ULL, 0x000e620000005400ULL, 0x000000012a2a0812ULL, 0x008fe400078efcffULL,
0x0000005b5a00720bULL, 0x000fca0003f1d000ULL, 0x0000002600307306ULL, 0x0004f0000000d400ULL,
0x0000002700657306ULL, 0x000fe20000009400ULL, 0x00000018ff267819ULL, 0x004fe40000011425ULL,
0x0000009db025723eULL, 0x000fc400000010ffULL, 0x0000006b6a00720bULL, 0x002fe40003fbd000ULL,
0x000000015c5c0812ULL, 0x000fe200078efcffULL, 0x0000002700667306ULL, 0x000e700000005400ULL,
0x0000002700317306ULL, 0x000ea4000000d400ULL, 0x0000000130305812ULL, 0x008fcc00078efcffULL,
0x0000002400277306ULL, 0x000722000020d400ULL, 0x000000666500720bULL, 0x002fce0003f7d000ULL,
0x000000c700977306ULL, 0x000e62000020d400ULL, 0x0000009eaf24723eULL, 0x008fca00000010ffULL,
0x0000000131313812ULL, 0x004fe400078efcffULL, 0x0000002600a07306ULL, 0x000fe20000209400ULL,
0x000000242054723cULL, 0x000fe20000041854ULL, 0x0000000127274812ULL, 0x010fcc00078efcffULL,
0x0000002600937306ULL, 0x000ea20000205400ULL, 0x0000008f9224723eULL, 0x000fe400000010ffULL,
0x000000878c25723eULL, 0x000fe400000010ffULL, 0x0000000197972812ULL, 0x002fe400078efcffULL,
0x000000887d87723eULL, 0x000fe200000010ffULL, 0x000000a400947306ULL, 0x000fe20000209400ULL,
0x0000002a9797723eULL, 0x000fe200000010ffULL, 0x00000024204c723cULL, 0x040fec000004184cULL,
0x000000a400857306ULL, 0x000e620000205400ULL, 0x00000093a000720bULL, 0x004fe20003f5d000ULL,
0x000000862048723cULL, 0x000fec0000041848ULL, 0x00000026009b7306ULL, 0x000ea4000020d400ULL,
0x000000741c54723cULL, 0x040fec0000041854ULL, 0x000000a400257306ULL, 0x000ee2000020d400ULL,
0x000000859400720bULL, 0x002fe20003f9d000ULL, 0x0000006c1c4c723cULL, 0x040fec000004184cULL,
0x000000a600267306ULL, 0x000fe20000209400ULL, 0x000000019b9b2812ULL, 0x004fe200078efcffULL,
0x000000341c48723cULL, 0x000fe20000041848ULL, 0x000000616000720bULL, 0x000fca0003f5d000ULL,
0x000000a600717306ULL, 0x000e620000205400ULL, 0x0000000125254812ULL, 0x008fe200078efcffULL,
0x000000961c44723cULL, 0x000fe60000041844ULL, 0x000000302530723eULL, 0x000fc600000010ffULL,
0x000000a500247306ULL, 0x000fe20000209400ULL, 0x0000000164642812ULL, 0x000fce00078efcffULL,
0x000000a500137306ULL, 0x000ea20000205400ULL, 0x000000712600720bULL, 0x002fce0003f1d000ULL,
0x000000ab00147306ULL, 0x000ff00000209400ULL, 0x000000ab00157306ULL, 0x000e620000205400ULL,
0x000000132400720bULL, 0x004fce0003f9d000ULL, 0x000000a6002e7306ULL, 0x000eb0000020d400ULL,
0x000000a500207306ULL, 0x000ee2000020d400ULL, 0x000000151400720bULL, 0x002fe40003fbd000ULL,
0x000000275814723eULL, 0x000fc400000010ffULL, 0x0000009b5c15723eULL, 0x000fc600000010ffULL,
0x000000ab00217306ULL, 0x000e62000020d400ULL, 0x000000012e2e0812ULL, 0x004fc600078efcffULL,
0x000000141c40723cULL, 0x000fe20000041840ULL, 0x000000312e31723eULL, 0x000fe400000010ffULL,
0x0000000120204812ULL, 0x008fc800078efcffULL, 0x000000205f20723eULL, 0x000fe200000010ffULL,
0x000000301c3c723cULL, 0x000fe2000004183cULL, 0x0000000121215812ULL, 0x002fc800078efcffULL,
0x000000216421723eULL, 0x000fce00000010ffULL, 0x000000201c38723cULL, 0x000fe20000041838ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x00002000161c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a00059ff7f8cULL, 0x0007e2000c80043fULL, 0x000000011a157812ULL, 0x000fe200078ec0ffULL,
0x000000ffff317224ULL, 0x004fe400078e001dULL, 0x0000030005057a10ULL, 0x00cfc80007ffe0ffULL,
0x000000060500720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff44b000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x004ea40000002500ULL,
0x0000000406007c0cULL, 0x004fda000bf03070ULL, 0x0000039000000947ULL, 0x000fea0003800000ULL,
0x0180000012027810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e0012ULL,
0x0000cba000087802ULL, 0x000fe40000000f00ULL, 0x0000a79000007944ULL, 0x02afea0003c00000ULL,
0x000000ffff047224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001200037308ULL, 0x000ea40000001000ULL, 0xbf80000003027423ULL, 0x004fc80000000012ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000203047223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000057919ULL, 0x000f280000000000ULL, 0x0000000000087919ULL, 0x000ee20000000000ULL,
0x00000002ff097819ULL, 0x010fe40000011605ULL, 0x0000000808057811ULL, 0x008fe200078ff0ffULL,
0x0000000403067220ULL, 0x006fca0000410000ULL, 0x00001f0906047589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea200000e0000ULL, 0x0000005404547220ULL, 0x042fe40000410000ULL,
0x0000005504557220ULL, 0x040fe40000410000ULL, 0x0000005004507220ULL, 0x040fe40000410000ULL,
0x0000005104517220ULL, 0x000fc40000410000ULL, 0x0000004c044c7220ULL, 0x040fe40000410000ULL,
0x0000004d044d7220ULL, 0x040fe40000410000ULL, 0x0000004804487220ULL, 0x040fe40000410000ULL,
0x0000004904497220ULL, 0x040fe40000410000ULL, 0x0000004404447220ULL, 0x040fe40000410000ULL,
0x0000004504457220ULL, 0x000fc40000410000ULL, 0x0000004004407220ULL, 0x040fe40000410000ULL,
0x0000004104417220ULL, 0x040fe40000410000ULL, 0x0000003c043c7220ULL, 0x040fe40000410000ULL,
0x0000003d043d7220ULL, 0x040fe40000410000ULL, 0x0000003804387220ULL, 0x040fe40000410000ULL,
0x0000003904397220ULL, 0x000fc40000410000ULL, 0x0000005605567220ULL, 0x044fe40000410000ULL,
0x0000005705577220ULL, 0x040fe40000410000ULL, 0x0000005205527220ULL, 0x040fe40000410000ULL,
0x0000005305537220ULL, 0x040fe40000410000ULL, 0x0000004e054e7220ULL, 0x040fe40000410000ULL,
0x0000004f054f7220ULL, 0x000fc40000410000ULL, 0x0000004a054a7220ULL, 0x040fe40000410000ULL,
0x0000004b054b7220ULL, 0x040fe40000410000ULL, 0x0000004605467220ULL, 0x040fe40000410000ULL,
0x0000004705477220ULL, 0x040fe40000410000ULL, 0x0000004205427220ULL, 0x040fe40000410000ULL,
0x0000004305437220ULL, 0x000fc40000410000ULL, 0x0000003e053e7220ULL, 0x040fe40000410000ULL,
0x0000003f053f7220ULL, 0x040fe40000410000ULL, 0x0000003a053a7220ULL, 0x040fe40000410000ULL,
0x0000003b053b7220ULL, 0x000fe40000410000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000203027812ULL, 0x004fc400078ec0ffULL,
0x00000002ff157819ULL, 0x008fe40000011603ULL, 0x00000001ff047819ULL, 0x000fe40000011602ULL,
0x0000000202057811ULL, 0x040fe400078ff8ffULL, 0x0000000402087811ULL, 0x040fe400078ff8ffULL,
0x00000008031b7811ULL, 0x000fe400078ff0ffULL, 0x0000000602137811ULL, 0x000fc400078ff8ffULL,
0x0000000704027812ULL, 0x100fe400078e7815ULL, 0x0000000705067812ULL, 0x100fe400078e7815ULL,
0x00000007080a7812ULL, 0x060fe200078e7815ULL, 0x0000000815097824ULL, 0x040fe200078e0202ULL,
0x0000000708087812ULL, 0x100fe200078e781bULL, 0x00000008150b7824ULL, 0x000fe200078e0206ULL,
0x0000000704047812ULL, 0x100fe200078e781bULL, 0x000010000c027824ULL, 0x000fe200078e00ffULL,
0x0000000705057812ULL, 0x000fe200078e781bULL, 0x000000081b197824ULL, 0x002fe200078e0208ULL,
0x0000000713147812ULL, 0x000fe200078e7815ULL, 0x0000000803087824ULL, 0x000fe200078e00ffULL,
0x0000000713067812ULL, 0x000fe200078e781bULL, 0x000000081b137824ULL, 0x000fc400078e0204ULL,
0x00000008150f7824ULL, 0x000fe200078e020aULL, 0x0000000808087812ULL, 0x000fe200078ec0ffULL,
0x000000081b177824ULL, 0x000fe200078e0205ULL, 0x000000545505723eULL, 0x000fe200000010ffULL,
0x000008000d047824ULL, 0x000fe400078e0202ULL, 0x0000000815157824ULL, 0x000fe400078e0214ULL,
0x000000081b1b7824ULL, 0x000fe200078e0206ULL, 0x000000505106723eULL, 0x000fe200000010ffULL,
0x0000001009097824ULL, 0x000fc400078e0204ULL, 0x000000100b0b7824ULL, 0x000fe200078e0204ULL,
0x00005410051c7816ULL, 0x000fe20000000006ULL, 0x000000100f0f7824ULL, 0x000fe200078e0204ULL,
0x00007632051d7816ULL, 0x000fe20000000006ULL, 0x0000001013137824ULL, 0x100fe200078e0204ULL,
0x000000444505723eULL, 0x000fe200000010ffULL, 0x0000001017177824ULL, 0x100fe200078e0204ULL,
0x000000404106723eULL, 0x000fe200000010ffULL, 0x0000001015157824ULL, 0x100fe400078e0204ULL,
0x0000001019197824ULL, 0x000fc400078e0204ULL, 0x000000101b1b7824ULL, 0x000fe400078e0204ULL,
0x00000001090a7824ULL, 0x000fe200078e0208ULL, 0x000000484909723eULL, 0x000fe200000010ffULL,
0x00000001080b7824ULL, 0x040fe400078e020bULL, 0x00000001080f7824ULL, 0x040fe200078e020fULL,
0x0000001c0a007388ULL, 0x0003e20000000a00ULL, 0x0000000108137824ULL, 0x040fe400078e0213ULL,
0x0000000108177824ULL, 0x000fc400078e0217ULL, 0x0000000108157824ULL, 0x040fe400078e0215ULL,
0x0000000108197824ULL, 0x040fe400078e0219ULL, 0x00000001081b7824ULL, 0x000fe200078e021bULL,
0x0000004c4d08723eULL, 0x000fe400000010ffULL, 0x00005410050a7816ULL, 0x002fe40000000006ULL,
0x00005410081c7816ULL, 0x140fe40000000009ULL, 0x00007632081d7816ULL, 0x000fc40000000009ULL,
0x0000003c3d08723eULL, 0x000fe400000010ffULL, 0x000000383909723eULL, 0x000fe200000010ffULL,
0x0000001c0b007388ULL, 0x0003e40000000a00ULL, 0x00007632050b7816ULL, 0x002fe40000000006ULL,
0x000000565705723eULL, 0x000fe400000010ffULL, 0x000000525306723eULL, 0x000fe200000010ffULL,
0x0000000a0f007388ULL, 0x0003e40000000a00ULL, 0x00005410080a7816ULL, 0x002fe20000000009ULL,
0x000000010e0f7824ULL, 0x000fe200078e0203ULL, 0x00007632080b7816ULL, 0x000fc40000000009ULL,
0x0000004e4f08723eULL, 0x000fe400000010ffULL, 0x0000004a4b09723eULL, 0x000fe200000010ffULL,
0x0000000a15007388ULL, 0x0003e40000000a00ULL, 0x00005410050a7816ULL, 0x142fe40000000006ULL,
0x00007632050b7816ULL, 0x000fe40000000006ULL, 0x000000464705723eULL, 0x000fe400000010ffULL,
0x000000424306723eULL, 0x000fe200000010ffULL, 0x0000000a13007388ULL, 0x0003e40000000a00ULL,
0x00005410080a7816ULL, 0x142fe20000000009ULL, 0x000000100f137824ULL, 0x000fe200078e0202ULL,
0x00007632080b7816ULL, 0x000fc40000000009ULL, 0x0000003e3f08723eULL, 0x000fe400000010ffULL,
0x0000003a3b09723eULL, 0x000fe200000010ffULL, 0x0000000a17007388ULL, 0x0003e40000000a00ULL,
0x00005410050a7816ULL, 0x142fe40000000006ULL, 0x00007632050b7816ULL, 0x000fe40000000006ULL,
0x000000ff00067306ULL, 0x000fe60000205400ULL, 0x0000000a19007388ULL, 0x0003ea0000000a00ULL,
0x000000ff00057306ULL, 0x000fe2000020d400ULL, 0x00005410080a7816ULL, 0x002fc40000000009ULL,
0x00007632080b7816ULL, 0x000fca0000000009ULL, 0x000000ff00097306ULL, 0x000e620000209400ULL,
0x0000000a1b007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000060900720bULL, 0x002fda0003f1d000ULL, 0x0000000105050812ULL, 0x000fe200078efcffULL,
0x0004000013207984ULL, 0x000e660000000c00ULL, 0x000000050506723eULL, 0x000fe200000010ffULL,
0x000c000013247984ULL, 0x000ea80000000c00ULL, 0x0000000013147984ULL, 0x000ee80000000c00ULL,
0x00080000131c7984ULL, 0x000f220000000c00ULL, 0x3f803f8006207831ULL, 0x002fc40000200020ULL,
0x3f803f8006237831ULL, 0x000fe40000200023ULL, 0x3f803f8020207831ULL, 0x004fe20000200024ULL,
0x00000300ff247624ULL, 0x000fe200078e00ffULL, 0x3f803f8006227831ULL, 0x040fe40000200022ULL,
0x3f803f8006177831ULL, 0x048fe40000200017ULL, 0x000000012400780cULL, 0x000fe20003f05270ULL,
0x3f803f8006167831ULL, 0x040fe40000200016ULL, 0x3f803f8006157831ULL, 0x000fc40000200015ULL,
0x3f803f8006147831ULL, 0x040fe40000200014ULL, 0x3f803f8006217831ULL, 0x000fe40000200021ULL,
0x3f803f8017177831ULL, 0x010fe4000020001fULL, 0x3f803f8016167831ULL, 0x000fe4000020001eULL,
0x3f803f8015157831ULL, 0x000fe4000020001dULL, 0x3f803f8014147831ULL, 0x000fc4000020001cULL,
0x3f803f8023237831ULL, 0x000fe40000200027ULL, 0x3f803f8022227831ULL, 0x000fe20000200026ULL,
0x0000001413007388ULL, 0x0003e20000000c00ULL, 0x3f803f8021217831ULL, 0x000fca0000200025ULL,
0x0004002013007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f4000008947ULL, 0x000fea0003800000ULL, 0x00000000001a7919ULL, 0x000ea20000002700ULL,
0x0000580024067a24ULL, 0x000fe200078e02ffULL, 0x000000010dff7812ULL, 0x000fe2000780f800ULL,
0x00000800ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000000097919ULL, 0x000ea20000002600ULL,
0x0000660006147a24ULL, 0x002fe200078e02ffULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000000ff0300720cULL, 0x000fe20000725670ULL, 0x00000000131c7984ULL, 0x0002e40000000c00ULL,
0x000007ff14087811ULL, 0x000fe200078e40ffULL, 0x000058001a1a7a24ULL, 0x004fc400078e0209ULL,
0x000004000c097824ULL, 0x000fe400078e00ffULL, 0x000003001a067a24ULL, 0x000fca00078e02ffULL,
0x0000000406157c10ULL, 0x000fc8000fffe0ffULL, 0x00000015080a7211ULL, 0x000fca00078fa8ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000bULL, 0x000000090a187210ULL, 0x000fe40007f5e0ffULL,
0x01ffffff140a7812ULL, 0x000fc600078ec0ffULL, 0x000000ffff197224ULL, 0x000fc800010e060bULL,
0x000000100f187825ULL, 0x000fe200078e0018ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010030b7824ULL, 0x00afe200078e00ffULL, 0x00000001ff0f7819ULL, 0x000fe20000011603ULL,
0x00000080ff177424ULL, 0x000fe400078e00ffULL, 0x0000000115167824ULL, 0x000fe200078e020aULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x00006c0015147625ULL, 0x000fe200078e0017ULL,
0x0000000c0f0f7812ULL, 0x000fc600078ec0ffULL, 0x00006c0016167625ULL, 0x000fe200078e0017ULL,
0x000000140f147210ULL, 0x000fc80007a1e00bULL, 0x000000160f167210ULL, 0x000fe40007c7e00bULL,
0x00000015ff157210ULL, 0x000fe400007e44ffULL, 0x00000017ff177210ULL, 0x000fc60001fe84ffULL,
0x0000001114007986ULL, 0x0003e8000c101906ULL, 0x0000001216007986ULL, 0x0003e4000c101906ULL,
0x0000000000007941ULL, 0x00afea0003800000ULL, 0x0000001c18007986ULL, 0x0003e2000c101d06ULL,
0x0000011000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff137424ULL, 0x000fe200078e00ffULL,
0xffffffff240b7810ULL, 0x000fc60007ffe0ffULL, 0x00006a001a127625ULL, 0x000fe200078e0013ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b121279a8ULL, 0x000ea400099ee1c6ULL, 0x0000000b1200720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0f7807ULL, 0x000fca0000000000ULL,
0x0000000fff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff0b7984ULL, 0x000ee40000000000ULL,
0x000000ff0b00720cULL, 0x008fda0003f05270ULL, 0x00002b9000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0000000106147810ULL, 0x000fe20007ffe0ffULL, 0x0000001003007824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011603ULL, 0x00000080ff1b7424ULL, 0x000fc600078e00ffULL,
0x00000070001d7812ULL, 0x002fe200078ec0ffULL, 0x00006c0006127625ULL, 0x000fe200078e001bULL,
0x0000000c0b167812ULL, 0x000fc600078ec0ffULL, 0x00006c0014147625ULL, 0x000fe200078e001bULL,
0x0000001216127210ULL, 0x000fc8000791e01dULL, 0x0000001416147210ULL, 0x000fe40007b5e01dULL,
0x00000013ff137210ULL, 0x000fe400007e24ffULL, 0x00000015ff157210ULL, 0x000fc600017e64ffULL,
0x0000000612007981ULL, 0x000368000c1e1900ULL, 0x00000006140b7981ULL, 0x000362000c1e1900ULL,
0x000000022400780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000206127810ULL, 0x002fca0007ffe0ffULL, 0x00006c0012127625ULL, 0x000fca00078e001bULL,
0x0000001216127210ULL, 0x000fc8000791e01dULL, 0x00000013ff137210ULL, 0x000fca00007e24ffULL,
0x00000006120f7981ULL, 0x004362000c1e1900ULL, 0x000000042400780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000306127810ULL, 0x002fca0007ffe0ffULL,
0x00006c0012127625ULL, 0x000fca00078e001bULL, 0x0000001216127210ULL, 0x000fc8000791e01dULL,
0x00000013ff137210ULL, 0x000fca00007e24ffULL, 0x0000000612117981ULL, 0x000362000c1e1900ULL,
0x000000042400780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000406127810ULL, 0x002fca0007ffe0ffULL, 0x00006c0012127625ULL, 0x000fca00078e001bULL,
0x0000001216127210ULL, 0x000fc8000791e01dULL, 0x00000013ff137210ULL, 0x000fca00007e24ffULL,
0x0000000612177981ULL, 0x000362000c1e1900ULL, 0x000000062400780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000506127810ULL, 0x002fca0007ffe0ffULL,
0x00006c0012127625ULL, 0x000fca00078e001bULL, 0x0000001216127210ULL, 0x000fc8000791e01dULL,
0x00000013ff137210ULL, 0x000fca00007e24ffULL, 0x0000000612197981ULL, 0x000362000c1e1900ULL,
0x000000062400780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000082400780cULL, 0x002fe40003f06070ULL, 0x0000000606127810ULL, 0x000fca0007ffe0ffULL,
0x00006c0012127625ULL, 0x000fca00078e001bULL, 0x0000001216127210ULL, 0x000fe40007a3e01dULL,
0x0000000706140810ULL, 0x000fe40007ffe0ffULL, 0x00000013ff137210ULL, 0x000fc60000fe44ffULL,
0x00006c0014140625ULL, 0x000fe400078e001bULL, 0x00000006121b7981ULL, 0x000366000c1e1900ULL,
0x0000001416140210ULL, 0x000fc80007c7e01dULL, 0x00000015ff150210ULL, 0x000fca0001fe84ffULL,
0x00000006141d0981ULL, 0x000368000c1e1900ULL, 0x0000000724127810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff147819ULL, 0x000fc80000011612ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff157224ULL, 0x000fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x020fe400078e0000ULL, 0x0000000815167824ULL, 0x040fe200078e00ffULL,
0x0000000115157810ULL, 0x000fc80007ffe0ffULL, 0x0000030016007a0cULL, 0x000fe40003f26070ULL,
0x000000141500720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x0000000816137810ULL, 0x040fe40007ffe0ffULL, 0x0000000116127810ULL, 0x000fe40007ffe0ffULL,
0x0000030013007a0cULL, 0x000fe40003f26070ULL, 0x0000030012007a0cULL, 0x000fe40003f46070ULL,
0x0000001f00007209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000106127824ULL, 0x000fe200078e0213ULL, 0x00000001ff1a7819ULL, 0x000fe20000011603ULL,
0x00000080ff137424ULL, 0x000fe400078e00ffULL, 0x0000001003187824ULL, 0x000fe200078e00ffULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x00006c0012127625ULL, 0x000fc600078e0013ULL,
0x00000070181f7812ULL, 0x000fc800078ec0ffULL, 0x000000121a127210ULL, 0x000fc80007b3e01fULL,
0x00000013ff137210ULL, 0x000fca0000fe64ffULL, 0x00000006121f7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x0000000916137810ULL, 0x042fe40007ffe0ffULL,
0x0000000216127810ULL, 0x000fe40007ffe0ffULL, 0x0000030013007a0cULL, 0x000fe40003f26070ULL,
0x0000030012007a0cULL, 0x000fe40003f46070ULL, 0x0000000b00007209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000106127824ULL, 0x000fe200078e0213ULL,
0x00000001ff187819ULL, 0x000fe20000011603ULL, 0x00000080ff137424ULL, 0x000fe400078e00ffULL,
0x00000010030b7824ULL, 0x000fe200078e00ffULL, 0x0000000c18187812ULL, 0x000fe200078ec0ffULL,
0x00006c0012127625ULL, 0x000fc600078e0013ULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x0000001218127210ULL, 0x000fc80007b3e00bULL, 0x00000013ff137210ULL, 0x000fca0000fe64ffULL,
0x00000006120b7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a16137810ULL, 0x042fe40007ffe0ffULL, 0x0000000316127810ULL, 0x000fe40007ffe0ffULL,
0x0000030013007a0cULL, 0x000fe40003f26070ULL, 0x0000030012007a0cULL, 0x000fe40003f46070ULL,
0x0000000f00007209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000106127824ULL, 0x000fe200078e0213ULL, 0x00000001ff187819ULL, 0x000fe20000011603ULL,
0x00000080ff137424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x004fe200078e00ffULL,
0x0000000c18187812ULL, 0x000fe200078ec0ffULL, 0x00006c0012127625ULL, 0x000fc600078e0013ULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000001218127210ULL, 0x000fc80007b3e00fULL,
0x00000013ff137210ULL, 0x000fca0000fe64ffULL, 0x00000006120f7981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b16137810ULL, 0x042fe40007ffe0ffULL,
0x0000000416127810ULL, 0x000fe40007ffe0ffULL, 0x0000030013007a0cULL, 0x000fe40003f26070ULL,
0x0000030012007a0cULL, 0x000fe40003f46070ULL, 0x0000001100007209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000106127824ULL, 0x000fe200078e0213ULL,
0x00000001ff187819ULL, 0x000fe20000011603ULL, 0x00000080ff137424ULL, 0x000fe400078e00ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c18187812ULL, 0x000fe200078ec0ffULL,
0x00006c0012127625ULL, 0x000fc600078e0013ULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000001218127210ULL, 0x000fc80007b3e011ULL, 0x00000013ff137210ULL, 0x000fca0000fe64ffULL,
0x0000000612117981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c16137810ULL, 0x042fe40007ffe0ffULL, 0x0000000516127810ULL, 0x000fe40007ffe0ffULL,
0x0000030013007a0cULL, 0x000fe40003f26070ULL, 0x0000030012007a0cULL, 0x000fe40003f46070ULL,
0x0000001700007209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000106127824ULL, 0x000fe200078e0213ULL, 0x00000001ff187819ULL, 0x000fe20000011603ULL,
0x00000080ff137424ULL, 0x000fe400078e00ffULL, 0x0000001003177824ULL, 0x000fe200078e00ffULL,
0x0000000c18187812ULL, 0x000fe200078ec0ffULL, 0x00006c0012127625ULL, 0x000fc600078e0013ULL,
0x0000007017177812ULL, 0x000fc800078ec0ffULL, 0x0000001218127210ULL, 0x000fc80007b3e017ULL,
0x00000013ff137210ULL, 0x000fca0000fe64ffULL, 0x0000000612177981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d16137810ULL, 0x042fe40007ffe0ffULL,
0x0000000616127810ULL, 0x000fe40007ffe0ffULL, 0x0000030013007a0cULL, 0x000fe40003f26070ULL,
0x0000030012007a0cULL, 0x000fe40003f46070ULL, 0x0000001900007209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000106127824ULL, 0x000fe200078e0213ULL,
0x00000001ff1a7819ULL, 0x000fe20000011603ULL, 0x00000080ff137424ULL, 0x000fe400078e00ffULL,
0x0000001003187824ULL, 0x000fe200078e00ffULL, 0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL,
0x00006c0012127625ULL, 0x000fc600078e0013ULL, 0x0000007018197812ULL, 0x000fc800078ec0ffULL,
0x000000121a127210ULL, 0x000fc80007b3e019ULL, 0x00000013ff137210ULL, 0x000fca0000fe64ffULL,
0x0000000612197981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e16137810ULL, 0x042fe40007ffe0ffULL, 0x0000000716127810ULL, 0x000fe40007ffe0ffULL,
0x0000030013007a0cULL, 0x000fe40003f26070ULL, 0x0000030012007a0cULL, 0x000fe40003f46070ULL,
0x0000001b00007209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000106127824ULL, 0x000fe200078e0213ULL, 0x00000001ff1a7819ULL, 0x000fe20000011603ULL,
0x00000080ff137424ULL, 0x000fe400078e00ffULL, 0x0000001003187824ULL, 0x000fe200078e00ffULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x00006c0012127625ULL, 0x000fc600078e0013ULL,
0x00000070181b7812ULL, 0x000fc800078ec0ffULL, 0x000000121a127210ULL, 0x000fc80007b3e01bULL,
0x00000013ff137210ULL, 0x000fca0000fe64ffULL, 0x00000006121b7981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f16137810ULL, 0x002fe40007ffe0ffULL,
0x0000001d00007209ULL, 0x000fe40007810000ULL, 0x0000030013007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000106127824ULL, 0x000fe200078e0213ULL,
0x00000001ff187819ULL, 0x000fe20000011603ULL, 0x00000080ff137424ULL, 0x000fe400078e00ffULL,
0x0000001003167824ULL, 0x000fe200078e00ffULL, 0x0000000c18187812ULL, 0x000fe200078ec0ffULL,
0x00006c0012127625ULL, 0x000fc600078e0013ULL, 0x00000070161d7812ULL, 0x000fc800078ec0ffULL,
0x0000001218127210ULL, 0x000fc80007a3e01dULL, 0x00000013ff137210ULL, 0x000fca0000fe44ffULL,
0x00000006121d7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ee40000000000ULL, 0x00000010030b7824ULL, 0x028fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x004fc80000011603ULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0f127812ULL, 0x002fca00078ec0ffULL, 0x00000001120b7824ULL, 0x000fca00078e020bULL,
0x000000000b007388ULL, 0x0003e40000000800ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000001003007824ULL, 0x002fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x000000010d177824ULL, 0x000fe200078e0206ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000800ff137424ULL, 0x000fe200078e00ffULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x0000000110357824ULL, 0x000fe200078e0202ULL, 0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000001708127211ULL, 0x000fe200078fa8ffULL,
0x000010e000007945ULL, 0x000fe20003800000ULL, 0x0000002003117810ULL, 0x000fe20007ffe0ffULL,
0x000000010b347824ULL, 0x000fe200078e0200ULL, 0x0000000107007812ULL, 0x000fe200078ec0ffULL,
0x00006c0012127625ULL, 0x000fe200078e0013ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000020d0b8824ULL, 0x140fe200078e020cULL, 0x0000000912127210ULL, 0x000fe20007f3e0ffULL,
0x000000020d0f8824ULL, 0x004fe200078e020cULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000080007077824ULL, 0x000fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000000020b188824ULL, 0x100fe200078e0200ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000020f1a8824ULL, 0x000fe200078e0200ULL, 0x0000080007007812ULL, 0x000fe200078ec0ffULL,
0x000000010a148824ULL, 0x000fe200078e0217ULL, 0x0000000034347984ULL, 0x000e620000000800ULL,
0x00000080ff158424ULL, 0x000fc400078e00ffULL, 0x00000080ff168424ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fe200008e0613ULL, 0x000003000d007a0cULL, 0x000fe20003f26070ULL,
0x0000000135007824ULL, 0x000fe400078e0200ULL, 0x00006c0014148625ULL, 0x000fc800078e0015ULL,
0x00006c0017168625ULL, 0x000fc800078e0016ULL, 0x0000000818188824ULL, 0x100fe400078e0203ULL,
0x000000081a1a8824ULL, 0x000fe400078e0203ULL, 0x0000001011107825ULL, 0x000fe200078e0012ULL,
0x00004580181b8811ULL, 0x000fe400078e20ffULL, 0x000041801a218811ULL, 0x000fe200078e20ffULL,
0x0000001003197824ULL, 0x040fe400078e0200ULL, 0x0000001003127825ULL, 0x000fc800078e0012ULL,
0x0000001003148825ULL, 0x040fe200078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000012197faeULL, 0x0005e6000b901c46ULL, 0x0000001003168825ULL, 0x000fe200078e0016ULL,
0x0038000010197faeULL, 0x0007e6000b901c46ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x00000000141b8faeULL, 0x0009e2000b901c46ULL, 0x000000ffff077224ULL, 0x000fc400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x0000000016218faeULL, 0x000be2000b901c46ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x004fe2000001ff00ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000107805ULL, 0x008fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x010fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x020fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000d5000001947ULL, 0x000fea0003800000ULL, 0x000000ffff007224ULL, 0x002fe400078e00ffULL,
0x000000ffff377224ULL, 0x000fca00078e000dULL, 0x0000000237397810ULL, 0x000fe20007ffe0ffULL,
0x0000029000017945ULL, 0x000fe60003800000ULL, 0x0000030039007a0cULL, 0x000fda0003f06070ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x000000070300780cULL, 0x040fe20003f24070ULL,
0x0000000106337824ULL, 0x100fe200078e0239ULL, 0x00000001ff2c7819ULL, 0x000fe20000011639ULL,
0x00000800ff327424ULL, 0x000fe200078e00ffULL, 0x00000020033d7810ULL, 0x000fe20007ffe0ffULL,
0x00000400392e7824ULL, 0x000fe200078e00ffULL, 0x00000033082d7211ULL, 0x000fe400078fa8ffULL,
0x000000012c307812ULL, 0x000fc600078ec0ffULL, 0x00006c002d2c7625ULL, 0x000fc800078e0032ULL,
0x000000020d319824ULL, 0x140fe200078e020cULL, 0x000000092c2c7210ULL, 0x000fe20007f1e0ffULL,
0x000000020d3b9824ULL, 0x000fe400078e020cULL, 0x0000000231389824ULL, 0x100fe400078e0230ULL,
0x000000023b3c9824ULL, 0x000fe200078e0230ULL, 0x000008002e307812ULL, 0x000fe200078ec0ffULL,
0x000000010a2f9824ULL, 0x000fe400078e0233ULL, 0x00000080ff329424ULL, 0x000fc400078e00ffULL,
0x00000080ff3a9424ULL, 0x000fe400078e00ffULL, 0x00006c002f2e9625ULL, 0x000fc800078e0032ULL,
0x0000000135307824ULL, 0x000fe400078e0230ULL, 0x000000ffff2d7224ULL, 0x000fe400000e062dULL,
0x00006c0033329625ULL, 0x000fc800078e003aULL, 0x00000010033b7824ULL, 0x040fe400078e0230ULL,
0x0000000838389824ULL, 0x000fe400078e0203ULL, 0x0000001003309825ULL, 0x000fc800078e002eULL,
0x000000083c3c9824ULL, 0x000fe400078e0203ULL, 0x000000103d2e7825ULL, 0x100fe200078e002cULL,
0x00004580383d9811ULL, 0x000fe400078e20ffULL, 0x000041803c3f9811ULL, 0x000fe200078e20ffULL,
0x00000010032c7825ULL, 0x000fc800078e002cULL, 0x0000001003329825ULL, 0x000fe200078e0032ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800002c3b7faeULL, 0x0003e8000b901c46ULL,
0x003800002e3b7faeULL, 0x0003e8000b901c46ULL, 0x00000000303d9faeULL, 0x0003e8000b901c46ULL,
0x00000000323f9faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000040372c7824ULL, 0x002fe200078e00ffULL,
0x00000001ff2e7819ULL, 0x100fe20000011603ULL, 0x000000020d2f7824ULL, 0x000fe200078e020cULL,
0x00000002ff527819ULL, 0x000fe20000011603ULL, 0x00000010032d7824ULL, 0x000fe200078e00ffULL,
0x000000802c2c7812ULL, 0x000fc400078ec0ffULL, 0x0000000c2e2e7812ULL, 0x000fe200078ec0ffULL,
0x0000000852317824ULL, 0x040fe200078e00ffULL, 0x000000702d2d7812ULL, 0x000fe200078ec0ffULL,
0x000001002f2c7824ULL, 0x000fe200078e002cULL, 0x00000007523e7812ULL, 0x040fe200078ec0ffULL,
0x0000000852337824ULL, 0x000fe200078e00ffULL, 0x00000052ff407212ULL, 0x000fe400078e33ffULL,
0x0000002c2e2e7210ULL, 0x000fe20007ffe02dULL, 0x00000008522d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8312c7812ULL, 0x000fc400078ee23eULL, 0x0000000852547810ULL, 0x000fe40007ffe0ffULL,
0x000000012d307812ULL, 0x000fe200078ef63eULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180002e2f7984ULL, 0x000e620000000800ULL, 0x000000022d327812ULL, 0x140fe200078ef63eULL,
0x0000000854317824ULL, 0x040fe200078e00ffULL, 0x000000032d387812ULL, 0x140fe200078ef63eULL,
0x004580002e507984ULL, 0x0004e20000000800ULL, 0x000000042d3a7812ULL, 0x140fe200078ef63eULL,
0x0000000854447824ULL, 0x040fe200078e00ffULL, 0x000000052d3c7812ULL, 0x140fe200078ef63eULL,
0x0000000854427824ULL, 0x000fe200078e00ffULL, 0x000000062d3e7812ULL, 0x000fe200078ef63eULL,
0x00000400372d7824ULL, 0x000fe200078e00ffULL, 0xfffffff833407812ULL, 0x000fc400078ee240ULL,
0x00000054ff4e7212ULL, 0x000fe400078e33ffULL, 0x000008002d2e7812ULL, 0x004fe400078ec0ffULL,
0xfffffff8314e7812ULL, 0x000fe400078ee24eULL, 0x00000180352d7810ULL, 0x000fe40007ffe02eULL,
0x0000000754317812ULL, 0x000fc600078ec0ffULL, 0x000000102c2c7824ULL, 0x000fe200078e022dULL,
0xfffffff8442e7812ULL, 0x000fe200078ee231ULL, 0x0000001040407824ULL, 0x000fe200078e022dULL,
0x0000000142447812ULL, 0x000fe200078ef631ULL, 0x0000001030307824ULL, 0x000fe200078e022dULL,
0x0000000242467812ULL, 0x000fe200078ef631ULL, 0x0000001032327824ULL, 0x000fe200078e022dULL,
0x0000000342487812ULL, 0x000fe200078ef631ULL, 0x0000001038387824ULL, 0x000fe200078e022dULL,
0x00000004424a7812ULL, 0x000fe200078ef631ULL, 0x000000103a3a7824ULL, 0x000fe200078e022dULL,
0x00000005424c7812ULL, 0x000fe200078ef631ULL, 0x000000103c3c7824ULL, 0x000fe200078e022dULL,
0x0000000642427812ULL, 0x000fe200078ef631ULL, 0x000000103e3e7824ULL, 0x000fc400078e022dULL,
0x0000002f342f7221ULL, 0x002fe40000010100ULL, 0x000000102e2e7824ULL, 0x100fe400078e022dULL,
0x3fb8aa3b2f337820ULL, 0x000fe40000410000ULL, 0x00000004032f7824ULL, 0x000fe400078e00ffULL,
0x0000001044447824ULL, 0x100fe400078e022dULL, 0x0000003300337308ULL, 0x000ee20000000800ULL,
0x0000000c2f2f7812ULL, 0x000fe200078ec0ffULL, 0x0000001046467824ULL, 0x000fc400078e022dULL,
0x0000001048487824ULL, 0x000fe400078e022dULL, 0x000000012c2c7824ULL, 0x000fe400078e022fULL,
0x000000012f407824ULL, 0x040fe400078e0240ULL, 0x000000012f307824ULL, 0x040fe200078e0230ULL,
0x000000002c317984ULL, 0x000e620000000800ULL, 0x000000012f327824ULL, 0x040fe400078e0232ULL,
0x000000012f387824ULL, 0x000fe200078e0238ULL, 0x0000000040407984ULL, 0x000fe20000000800ULL,
0x0000005033377220ULL, 0x008fc40000410000ULL, 0x000000104a4a7824ULL, 0x100fe200078e022dULL,
0x0000000030337984ULL, 0x000fe20000000800ULL, 0x000000104c4c7824ULL, 0x100fe400078e022dULL,
0x0000001042427824ULL, 0x100fe200078e022dULL, 0x00001f52372c7589ULL, 0x000ea200000e0000ULL,
0x000000104e4e7824ULL, 0x000fe400078e022dULL, 0x000000012f3a7824ULL, 0x040fe200078e023aULL,
0x0000000032327984ULL, 0x000ee20000000800ULL, 0x000000012f3c7824ULL, 0x000fc400078e023cULL,
0x000000012f3e7824ULL, 0x040fe200078e023eULL, 0x0000000038387984ULL, 0x000f220000000800ULL,
0x000000012f2e7824ULL, 0x040fe400078e022eULL, 0x000000012f447824ULL, 0x040fe200078e0244ULL,
0x000000003a3a7984ULL, 0x000f620000000800ULL, 0x000000012f467824ULL, 0x040fe400078e0246ULL,
0x000000012f487824ULL, 0x040fe200078e0248ULL, 0x000000003c3c7984ULL, 0x000f220000000800ULL,
0x000000012f4a7824ULL, 0x000fc400078e024aULL, 0x000000012f4c7824ULL, 0x040fe200078e024cULL,
0x000000003e3e7984ULL, 0x000f220000000800ULL, 0x000000012f427824ULL, 0x040fe400078e0242ULL,
0x000000012f4e7824ULL, 0x000fe200078e024eULL, 0x000000002e2e7984ULL, 0x000f220000000800ULL,
0x0000003637367221ULL, 0x000fe20000010000ULL, 0x00005410ff2d7816ULL, 0x102fe40000000031ULL,
0x0000000044447984ULL, 0x000fe20000000800ULL, 0x00007610ff317816ULL, 0x000fc40000000031ULL,
0x0000002c2d2b7223ULL, 0x084fe2000001002bULL, 0x00005410ff2d7816ULL, 0x000fe20000000040ULL,
0x0000000046467984ULL, 0x000fe20000000800ULL, 0x0000002c312a7223ULL, 0x000fc6000001002aULL,
0x0000002c2d1d7223ULL, 0x080fe2000001001dULL, 0x00007610ff2d7816ULL, 0x000fe20000000040ULL,
0x0000000048487984ULL, 0x000fe80000000800ULL, 0x0000002c2d1c7223ULL, 0x000fe2000001001cULL,
0x00005410ff2d7816ULL, 0x100fe20000000033ULL, 0x00001f5437307589ULL, 0x0002a200000e0000ULL,
0x00007610ff337816ULL, 0x000fc60000000033ULL, 0x0000002c2d297223ULL, 0x080fe20000010029ULL,
0x00005410ff2d7816ULL, 0x008fe20000000032ULL, 0x000000004a4a7984ULL, 0x000ee20000000800ULL,
0x0000002c33287223ULL, 0x000fc60000010028ULL, 0x0000002c2d277223ULL, 0x000fe20000010027ULL,
0x00007610ff2d7816ULL, 0x000fe20000000032ULL, 0x000000004c4c7984ULL, 0x000ea20000000800ULL,
0x000000ffff377224ULL, 0x002fc600078e0039ULL, 0x0000002c2d267223ULL, 0x000fe20000010026ULL,
0x00005410ff2d7816ULL, 0x010fe20000000038ULL, 0x0000000042427984ULL, 0x000e620000000800ULL,
0x0000030037007a0cULL, 0x000fc60003f06070ULL, 0x0000002c2d257223ULL, 0x080fe20000010025ULL,
0x00007610ff2d7816ULL, 0x000fe20000000038ULL, 0x000000004e4e7984ULL, 0x000f280000000800ULL,
0x0000002c2d247223ULL, 0x000fe20000010024ULL, 0x00005410ff2d7816ULL, 0x020fca000000003aULL,
0x0000002c2d237223ULL, 0x000fe20000010023ULL, 0x00007610ff2d7816ULL, 0x000fca000000003aULL,
0x0000002c2d227223ULL, 0x000fe20000010022ULL, 0x00005410ff2d7816ULL, 0x000fca000000003cULL,
0x0000002c2d217223ULL, 0x000fe20000010021ULL, 0x00007610ff2d7816ULL, 0x000fca000000003cULL,
0x0000002c2d207223ULL, 0x000fe20000010020ULL, 0x00005410ff2d7816ULL, 0x000fca000000003eULL,
0x0000002c2d1f7223ULL, 0x000fe2000001001fULL, 0x00007610ff2d7816ULL, 0x000fca000000003eULL,
0x0000002c2d1e7223ULL, 0x000fe2000001001eULL, 0x00005410ff2c7816ULL, 0x100fe4000000002eULL,
0x00007610ff2d7816ULL, 0x000fc6000000002eULL, 0x000000302c1b7223ULL, 0x084fe2000001001bULL,
0x00005410ff2c7816ULL, 0x000fe20000000044ULL, 0x000000302d1a7223ULL, 0x000fe2000001001aULL,
0x00007610ff2d7816ULL, 0x000fc60000000044ULL, 0x000000302c197223ULL, 0x080fe20000010019ULL,
0x00005410ff2c7816ULL, 0x000fe20000000046ULL, 0x000000302d187223ULL, 0x000fe20000010018ULL,
0x00007610ff2d7816ULL, 0x000fc60000000046ULL, 0x000000302c177223ULL, 0x080fe20000010017ULL,
0x00005410ff2c7816ULL, 0x000fe20000000048ULL, 0x000000302d167223ULL, 0x000fe20000010016ULL,
0x00007610ff2d7816ULL, 0x000fc60000000048ULL, 0x000000302c157223ULL, 0x080fe20000010015ULL,
0x00005410ff2c7816ULL, 0x008fe2000000004aULL, 0x000000302d147223ULL, 0x000fe20000010014ULL,
0x00007610ff2d7816ULL, 0x000fc6000000004aULL, 0x000000302c137223ULL, 0x080fe20000010013ULL,
0x00005410ff2c7816ULL, 0x000fe2000000004cULL, 0x000000302d127223ULL, 0x000fe20000010012ULL,
0x00007610ff2d7816ULL, 0x000fc6000000004cULL, 0x000000302c117223ULL, 0x080fe20000010011ULL,
0x00005410ff2c7816ULL, 0x002fe20000000042ULL, 0x000000302d107223ULL, 0x080fe20000010010ULL,
0x00007610ff427816ULL, 0x000fe40000000042ULL, 0x00007610ff2d7816ULL, 0x110fe2000000004eULL,
0x000000302c0f7223ULL, 0x080fe2000001000fULL, 0x00005410ff2c7816ULL, 0x000fe2000000004eULL,
0x00000030420b7223ULL, 0x080fe4000001000bULL, 0x000000302d007223ULL, 0x000fc40000010000ULL,
0x000000302c077223ULL, 0x000fe20000010007ULL, 0xfffff2d000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x002fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x000000ff0c00720cULL, 0x000fe20003f05270ULL, 0x0000001003067824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fca00078ec0ffULL, 0x0000000103097824ULL, 0x000fe200078e0206ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000001003067824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c03087812ULL, 0x000fc600078ec0ffULL,
0x000000800d037824ULL, 0x000fc800078e0206ULL, 0x0000000108037824ULL, 0x000fca00078e0203ULL,
0x0049803603007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800009037984ULL, 0x002e680000000800ULL,
0x004a000009067984ULL, 0x000ea20000000800ULL, 0x00000003ff037221ULL, 0x002fc80000010000ULL,
0x0000000603037221ULL, 0x004fca0000010000ULL, 0x0180000003067810ULL, 0x000fc80007ffe0ffULL,
0x7f80000006067812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0600780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e0003ULL, 0x0000fa9000087802ULL, 0x000fe40000000f00ULL,
0x000078a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff067224ULL, 0x00efe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000300067308ULL, 0x000e640000001000ULL,
0xbf80000003087423ULL, 0x002fc80000000006ULL, 0x800000ff08097221ULL, 0x000fc80000010100ULL,
0x0000000906067223ULL, 0x000fe40000000006ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000000050505723eULL, 0x000fc600000010ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff2f7819ULL, 0x002fe40000011603ULL,
0x00000008032c7811ULL, 0x000fe400078ff0ffULL, 0x0000002fff097212ULL, 0x000fe200078e33ffULL,
0x00001f2f06087589ULL, 0x000e6200000e0000ULL, 0x0000002cff2d7212ULL, 0x000fe200078e33ffULL,
0x000000082c2e7824ULL, 0x000fe400078e00ffULL, 0x00001f2c060a7589ULL, 0x000ea600000e0000ULL,
0xfffffff82e2d7812ULL, 0x000fca00078ee22dULL, 0x000000102d2d7824ULL, 0x000fe400078e0204ULL,
0x0000002b082b7220ULL, 0x042fe40000410000ULL, 0x0000002a082a7220ULL, 0x040fe40000410000ULL,
0x0000002908297220ULL, 0x040fe40000410000ULL, 0x0000002808287220ULL, 0x000fe20000410000ULL,
0x0000002b2a2a723eULL, 0x000fe200000010ffULL, 0x0000002708277220ULL, 0x000fc40000410000ULL,
0x0000002608267220ULL, 0x000fe20000410000ULL, 0x000000292828723eULL, 0x000fe200000010ffULL,
0x0000002508257220ULL, 0x040fe40000410000ULL, 0x0000002408247220ULL, 0x000fe20000410000ULL,
0x000000272626723eULL, 0x000fe200000010ffULL, 0x0000002308237220ULL, 0x040fe40000410000ULL,
0x0000002208227220ULL, 0x000fe20000410000ULL, 0x000000252424723eULL, 0x000fe200000010ffULL,
0x0000002108217220ULL, 0x000fe20000410000ULL, 0x000000072c257812ULL, 0x000fe200078ec0ffULL,
0x0000002008207220ULL, 0x000fe20000410000ULL, 0x000000232222723eULL, 0x000fe200000010ffULL,
0x0000001f081f7220ULL, 0x040fe20000410000ULL, 0x0000000525237812ULL, 0x040fe200078e3cffULL,
0x0000001e081e7220ULL, 0x000fe20000410000ULL, 0x000000212020723eULL, 0x000fe200000010ffULL,
0x0000001d081d7220ULL, 0x040fe20000410000ULL, 0x0000000425217812ULL, 0x000fe200078e3cffULL,
0x0000001c08087220ULL, 0x000fe20000410000ULL, 0x0000001f1e1e723eULL, 0x000fe200000010ffULL,
0x000000082f1c7824ULL, 0x000fc400078e00ffULL, 0x0000001b0a1b7220ULL, 0x004fe20000410000ULL,
0x0000001d0808723eULL, 0x000fe200000010ffULL, 0x0000001a0a1a7220ULL, 0x000fe20000410000ULL,
0xfffffff81c317812ULL, 0x000fe200078ee209ULL, 0x000000190a197220ULL, 0x040fe20000410000ULL,
0x000000072f097812ULL, 0x000fe200078ec0ffULL, 0x000000180a187220ULL, 0x000fe20000410000ULL,
0x0000001b1a1a723eULL, 0x000fe200000010ffULL, 0x000000170a177220ULL, 0x040fe20000410000ULL,
0x00000002091c7812ULL, 0x040fe200078e3cffULL, 0x000000160a167220ULL, 0x040fe20000410000ULL,
0x00000003092e7812ULL, 0x040fe200078e3cffULL, 0x000000150a157220ULL, 0x040fe20000410000ULL,
0x0000000409307812ULL, 0x040fe200078e3cffULL, 0x000000140a147220ULL, 0x040fe20000410000ULL,
0x0000000509327812ULL, 0x040fe200078e3cffULL, 0x000000130a137220ULL, 0x040fe20000410000ULL,
0x0000000609347812ULL, 0x000fe200078e3cffULL, 0x000000120a127220ULL, 0x000fe20000410000ULL,
0x000000171616723eULL, 0x000fe200000010ffULL, 0x000000110a117220ULL, 0x000fe20000410000ULL,
0x000000191818723eULL, 0x000fe200000010ffULL, 0x000000100a107220ULL, 0x000fe20000410000ULL,
0x000000131212723eULL, 0x000fe200000010ffULL, 0x0000000f0a0f7220ULL, 0x000fe20000410000ULL,
0x000000151414723eULL, 0x000fe200000010ffULL, 0x0000000b0a067220ULL, 0x000fe20000410000ULL,
0x000000111010723eULL, 0x000fe200000010ffULL, 0x000000070a077220ULL, 0x040fe20000410000ULL,
0x0000000225197812ULL, 0x000fe200078e3cffULL, 0x000000000a007220ULL, 0x000fe20000410000ULL,
0x0000000f0606723eULL, 0x000fe200000010ffULL, 0x000000082f0a7824ULL, 0x000fc400078e00ffULL,
0x000000082f0b7824ULL, 0x000fe200078e021cULL, 0x000000070000723eULL, 0x000fe200000010ffULL,
0x0000000403277824ULL, 0x000fe200078e00ffULL, 0xfffffff80a077812ULL, 0x000fe200078ee22fULL,
0x000000082c177824ULL, 0x040fe200078e00ffULL, 0x00000001090a7812ULL, 0x000fe200078e3cffULL,
0x000000082f0f7824ULL, 0x000fe200078e022eULL, 0x00000003251c7812ULL, 0x000fe200078e3cffULL,
0x000000082f117824ULL, 0x000fe200078e0230ULL, 0xfffffff817177812ULL, 0x000fe200078ee22cULL,
0x000000082f097824ULL, 0x000fe200078e020aULL, 0x00000001250a7812ULL, 0x000fe200078e3cffULL,
0x000000082c1f7824ULL, 0x000fe200078e021cULL, 0x0000000c271c7812ULL, 0x000fe200078ec0ffULL,
0x0000001007077824ULL, 0x000fe200078e0204ULL, 0x0000000625257812ULL, 0x000fe200078e3cffULL,
0x000000082f137824ULL, 0x000fc400078e0232ULL, 0x0000001009097824ULL, 0x000fe400078e0204ULL,
0x000000082f157824ULL, 0x000fe400078e0234ULL, 0x000000100b0b7824ULL, 0x100fe400078e0204ULL,
0x000000100f0f7824ULL, 0x100fe400078e0204ULL, 0x000000011c077824ULL, 0x000fe400078e0207ULL,
0x0000001011117824ULL, 0x000fc400078e0204ULL, 0x000000082c1b7824ULL, 0x000fe200078e020aULL,
0x0000002a07007388ULL, 0x0003e20000000800ULL, 0x0000001013137824ULL, 0x100fe400078e0204ULL,
0x000000011c097824ULL, 0x000fe400078e0209ULL, 0x000000082c1d7824ULL, 0x000fe400078e0219ULL,
0x0000001015157824ULL, 0x000fe200078e0204ULL, 0x0000002809007388ULL, 0x000fe20000000800ULL,
0x000000011c0b7824ULL, 0x000fc400078e020bULL, 0x00000010310a7824ULL, 0x100fe400078e0204ULL,
0x000000011c0f7824ULL, 0x000fe200078e020fULL, 0x000000260b007388ULL, 0x000fe20000000800ULL,
0x000000082c217824ULL, 0x000fe400078e0221ULL, 0x0000001017197824ULL, 0x000fe200078e0204ULL,
0x000000240f007388ULL, 0x000fe20000000800ULL, 0x000000011c117824ULL, 0x000fe400078e0211ULL,
0x000000082c237824ULL, 0x000fc400078e0223ULL, 0x000000101b1b7824ULL, 0x100fe200078e0204ULL,
0x0000002211007388ULL, 0x000fe20000000800ULL, 0x000000011c137824ULL, 0x000fe400078e0213ULL,
0x000000082c257824ULL, 0x000fe400078e0225ULL, 0x000000101d1d7824ULL, 0x100fe200078e0204ULL,
0x0000002013007388ULL, 0x000fe20000000800ULL, 0x000000011c157824ULL, 0x000fe400078e0215ULL,
0x000000101f1f7824ULL, 0x000fc400078e0204ULL, 0x000000011c177824ULL, 0x040fe200078e020aULL,
0x0000001e15007388ULL, 0x000fe20000000800ULL, 0x0000001021217824ULL, 0x100fe400078e0204ULL,
0x000000011c197824ULL, 0x040fe200078e0219ULL, 0x0000000817007388ULL, 0x000fe20000000800ULL,
0x0000001023237824ULL, 0x100fe400078e0204ULL, 0x000000011c1b7824ULL, 0x000fe200078e021bULL,
0x0000001a19007388ULL, 0x000fe20000000800ULL, 0x0000001025257824ULL, 0x000fc400078e0204ULL,
0x000000011c1d7824ULL, 0x040fe200078e021dULL, 0x000000181b007388ULL, 0x000fe20000000800ULL,
0x000000011c1f7824ULL, 0x040fe400078e021fULL, 0x000000011c217824ULL, 0x040fe200078e0221ULL,
0x000000161d007388ULL, 0x000fe20000000800ULL, 0x000000011c237824ULL, 0x040fe400078e0223ULL,
0x000000011c257824ULL, 0x040fe200078e0225ULL, 0x000000141f007388ULL, 0x000fe20000000800ULL,
0x000000011c2d7824ULL, 0x000fc400078e022dULL, 0x000000010e077824ULL, 0x002fe200078e0203ULL,
0x0000001221007388ULL, 0x000fe60000000800ULL, 0x0000001007077824ULL, 0x000fe200078e0202ULL,
0x0000001023007388ULL, 0x000fe80000000800ULL, 0x0000000625007388ULL, 0x000fe80000000800ULL,
0x000000002d007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000007087984ULL, 0x000e680000000c00ULL, 0x0004000007287984ULL, 0x000ea80000000c00ULL,
0x0008000007187984ULL, 0x000ee80000000c00ULL, 0x000c000007307984ULL, 0x000f220000000c00ULL,
0x3f803f80050b7831ULL, 0x002fc4000020000bULL, 0x3f803f80050a7831ULL, 0x040fe4000020000aULL,
0x3f803f8005097831ULL, 0x040fe40000200009ULL, 0x3f803f8005087831ULL, 0x040fe40000200008ULL,
0x3f803f80052b7831ULL, 0x044fe4000020002bULL, 0x3f803f80052a7831ULL, 0x040fe4000020002aULL,
0x3f803f8005297831ULL, 0x000fc40000200029ULL, 0x3f803f8005287831ULL, 0x000fe40000200028ULL,
0x3f803f800b0b7831ULL, 0x008fe4000020001bULL, 0x3f803f800a0a7831ULL, 0x000fe4000020001aULL,
0x3f803f8009097831ULL, 0x000fe40000200019ULL, 0x3f803f8008087831ULL, 0x000fe40000200018ULL,
0x3f803f802b2b7831ULL, 0x010fc40000200033ULL, 0x3f803f802a2a7831ULL, 0x000fe20000200032ULL,
0x0000000807007388ULL, 0x0003e20000000c00ULL, 0x3f803f8029297831ULL, 0x000fe40000200031ULL,
0x3f803f8028287831ULL, 0x000fca0000200030ULL, 0x0004002807007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000020030f7810ULL, 0x004fe20007ffe0ffULL,
0x00000000000d7919ULL, 0x000ea20000002600ULL, 0x00000003ff0e7819ULL, 0x000fe20000011603ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x00000003ff047819ULL, 0x000fe2000001160fULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x000000070e007812ULL, 0x000fe200078e4803ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000704067812ULL, 0x000fe400078e480fULL,
0x0ffffff800057812ULL, 0x000fc400078ef803ULL, 0x0ffffff806077812ULL, 0x002fc600078ef80fULL,
0x0000001005057824ULL, 0x100fe400078e0202ULL, 0x0000001007077824ULL, 0x000fc600078e0202ULL,
0x0000000005087984ULL, 0x0003280000000c00ULL, 0x0000000007107984ULL, 0x000b220000000c00ULL,
0x000000080d157824ULL, 0x044fe400078e00ffULL, 0x000000080d0d7824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x008fe4000f8e023fULL, 0xfffffff815007812ULL, 0x000fe200078ee20eULL,
0x000000080c0e7824ULL, 0x040fe200078e00ffULL, 0xfffffff80d047812ULL, 0x000fe200078ee204ULL,
0x000000080c0c7824ULL, 0x000fe200078e00ffULL, 0x0000000400027c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000404007c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff80e037812ULL, 0x000fe200078ee203ULL,
0x000000ffff057224ULL, 0x002fe200000e06ffULL, 0x00005a0002047a11ULL, 0x000fe200078040ffULL,
0x000000ffff077224ULL, 0x020fe200008e06ffULL, 0x00005a0000067a11ULL, 0x000fe400078240ffULL,
0x00005b0002057a11ULL, 0x000fe400000f4405ULL, 0x00005b0000077a11ULL, 0x000fc400008f4407ULL,
0xfffffff80c0d7812ULL, 0x000fe200078ee20fULL, 0x0000001003027825ULL, 0x000fc800078e0004ULL,
0x000000100d047825ULL, 0x000fe200078e0006ULL, 0x0000000802007986ULL, 0x010fe8000c101d06ULL,
0x0000001004007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000405077824ULL, 0x000fe400078e0200ULL, 0xffffffffff387424ULL, 0x000fc600078e00ffULL,
0x000000040700720cULL, 0x000fda0003f06070ULL, 0x00000002130a8824ULL, 0x000fc800078e00ffULL,
0x000064000a0a8a24ULL, 0x000fc800078e0207ULL, 0x000060000a0a8625ULL, 0x000fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff0c7624ULL, 0x000fe200078e00ffULL,
0x000000060a388981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff0d7624ULL, 0x000fc600078e00ffULL,
0x00f60000ff087f8cULL, 0x000e68000c80043fULL, 0x000000060c3c7981ULL, 0x000762000c1e9900ULL,
0x00000001050f7810ULL, 0x000fe20007ffe0ffULL, 0x0000004039397824ULL, 0x000fe400078e00ffULL,
0x00000040003a7824ULL, 0x000fe200078e00ffULL, 0x000000060f00720cULL, 0x000fe20003f06070ULL,
0x00000040143b7824ULL, 0x000fc400078e00ffULL, 0x00000039381f7224ULL, 0x004fd400078e02ffULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x00000100050a7824ULL, 0x00afe200078e023aULL,
0x00000002ff237819ULL, 0x100fe40000011602ULL, 0x00000003ff157819ULL, 0x100fe40000011602ULL,
0x0000000a030b7217ULL, 0x000fe20007800000ULL, 0x00000040140c7824ULL, 0x000fe200078e0223ULL,
0x0000000315157812ULL, 0x000fe400078e4802ULL, 0x0000003011257812ULL, 0x000fe200078ec0ffULL,
0x000000010b127824ULL, 0x000fe200078e0a0aULL, 0x000000100c0b7810ULL, 0x000fc40007ffe0ffULL,
0x000000080c0a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000b1f0b7210ULL, 0x040fe40007f5e0ffULL,
0x0000000a1f1d7210ULL, 0x040fe40007f3e0ffULL, 0x0000000c1f167210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x00005e000b147a11ULL, 0x000fe200078438ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078238ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x00005f000b1b7a11ULL, 0x000fc400010f3c0aULL,
0x00005e0016107a11ULL, 0x000fe400078038ffULL, 0x000000180c0a7810ULL, 0x000fe40007ffe0ffULL,
0x000000122300720cULL, 0x000fe40003f66070ULL, 0x00005f001d1d7a11ULL, 0x000fe400008f3c0eULL,
0x00005f0016167a11ULL, 0x000fe400000f3c0dULL, 0x0000000a1f0f7210ULL, 0x000fc40007f3e0ffULL,
0x0000100000177811ULL, 0x000fe400078e68ffULL, 0x0ffffffc15027812ULL, 0x000fe400078ef802ULL,
0x000000200c0b7810ULL, 0x000fe40007ffe0ffULL, 0x00000010250a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001002197824ULL, 0x000fe200078e0217ULL, 0x0000000b1f1e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x000000280c0d7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0616ULL, 0x000000300c0e7810ULL, 0x000fc40007ffe0ffULL,
0x000000380c0c7810ULL, 0x000fe40007ffe0ffULL, 0x00005e000f107a11ULL, 0x000fe200078838ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e2000d901c46ULL,
0x0000000d1f1a7210ULL, 0x040fe40007fde0ffULL, 0x0000000e1f187210ULL, 0x040fe40007f1e0ffULL,
0x0000000c1f167210ULL, 0x000fe40007f3e0ffULL, 0x0000000823117810ULL, 0x000fc40007ffe0ffULL,
0x00005f000f027a11ULL, 0x000fe400020f3c02ULL, 0x000000251c0c7210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff197224ULL, 0x002fe200010e06ffULL, 0x00000010231f7810ULL, 0x000fe40007ffe0ffULL,
0x00000025140e7210ULL, 0x080fe20007f9e0ffULL, 0x0000000411147824ULL, 0x000fe200078e00ffULL,
0x0000002510107210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200018e061dULL,
0x0000001823217810ULL, 0x000fe20007ffe0ffULL, 0x000000041f0a7824ULL, 0x000fe200078e00ffULL,
0x000000121100720cULL, 0x080fe20003f66070ULL, 0x000000ffff0f7224ULL, 0x000fe200020e061bULL,
0x000000121f00720cULL, 0x000fe20003f86070ULL, 0x000000ffff117224ULL, 0x000fe200028e0602ULL,
0xfffffffc14027812ULL, 0x000fe200078ee215ULL, 0x0000000421207824ULL, 0x000fe200078e00ffULL,
0x00005e001e1c7a11ULL, 0x000fc400078438ffULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee215ULL,
0x00000010020b7824ULL, 0x000fe200078e0217ULL, 0x00000020231d7810ULL, 0x000fe40007ffe0ffULL,
0x000000122100720cULL, 0x000fe40003fa6070ULL, 0x00005f001e1e7a11ULL, 0x000fe200010f3c19ULL,
0x000000100a197824ULL, 0x000fe200078e0217ULL, 0x00000028231f7810ULL, 0x000fe20007ffe0ffULL,
0x000000041d027824ULL, 0x000fe200078e00ffULL, 0x0000003023217810ULL, 0x000fe20007ffe0ffULL,
0x000000000c0b7faeULL, 0x0003e2000d901c46ULL, 0xfffffffc20147812ULL, 0x100fe200078ee215ULL,
0x000000041f0a7824ULL, 0x000fe200078e00ffULL, 0x0000003823237810ULL, 0x000fe20007ffe0ffULL,
0x000000000e197faeULL, 0x0005e2000e101c46ULL, 0xfffffffc02027812ULL, 0x000fe200078ee215ULL,
0x00000010141b7824ULL, 0x000fe200078e0217ULL, 0xfffffffc0a0a7812ULL, 0x000fc400078ee215ULL,
0x000000121d00720cULL, 0x080fe40003f46070ULL, 0x00000000101b7faeULL, 0x0007e2000e901c46ULL,
0x00000004210c7824ULL, 0x002fe200078e00ffULL, 0x000000121f00720cULL, 0x080fe20003f66070ULL,
0x000000ffff0d7224ULL, 0x000fe200008e06ffULL, 0x000000122100720cULL, 0x080fe20003f86070ULL,
0x00000004230e7824ULL, 0x044fe200078e00ffULL, 0xfffffffc0c0c7812ULL, 0x000fe200078ee215ULL,
0x000000100a197824ULL, 0x000fe200078e0217ULL, 0x000000122300720cULL, 0x000fe20003fa6070ULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0xfffffffc0e0e7812ULL, 0x000fe200078ee215ULL,
0x0000001002157824ULL, 0x000fc400078e0217ULL, 0x000000ffff117224ULL, 0x008fe200030e06ffULL,
0x00005e001a027a11ULL, 0x000fe200078c38ffULL, 0x000000100c1b7824ULL, 0x100fe400078e0217ULL,
0x000000100e177824ULL, 0x000fe200078e0217ULL, 0x00005f001a117a11ULL, 0x000fe400030f3c11ULL,
0x000000251c0a7210ULL, 0x080fe40007fde0ffULL, 0x00005e00180e7a11ULL, 0x000fe400078038ffULL,
0x00000025020c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e061eULL,
0x00005e0016107a11ULL, 0x000fc400078c38ffULL, 0x00005f00180f7a11ULL, 0x000fe400000f3c0fULL,
0x00005f0016027a11ULL, 0x000fe200030f3c0dULL, 0x000000ffff0d7224ULL, 0x000fe200008e0611ULL,
0x000000250e0e7210ULL, 0x080fe20007f1e0ffULL, 0x000000000a157faeULL, 0x0003e2000d101c46ULL,
0x0000002510107210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e060fULL,
0x000000000c197faeULL, 0x0003e2000d901c46ULL, 0x000000ffff117224ULL, 0x000fc600008e0602ULL,
0x000000000e1b7faeULL, 0x0003e8000e101c46ULL, 0x0000000010177faeULL, 0x0003e2000e901c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000003b020a7211ULL, 0x04afe400078ff0ffULL,
0x00000008021a7811ULL, 0x040fe400078ff0ffULL, 0x0000000a1f0a7210ULL, 0x000fe40007f1e0ffULL,
0x0000002002107811ULL, 0x000fc400078ff0ffULL, 0x00000010020c7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x00005e000a227a11ULL, 0x000fe200078038ffULL,
0x000000013b0f7824ULL, 0x040fe200078e0210ULL, 0x00000018020e7811ULL, 0x000fe400078ff0ffULL,
0x00005f000a247a11ULL, 0x000fe200000f3c0bULL, 0x000000013b0a7824ULL, 0x040fe200078e021aULL,
0x0000003002167811ULL, 0x040fe200078ff0ffULL, 0x000000013b0b7824ULL, 0x040fe200078e020cULL,
0x00000003ff1d7819ULL, 0x000fe20000011602ULL, 0x000000013b0d7824ULL, 0x040fe200078e020eULL,
0x0000002802127811ULL, 0x040fe200078ff0ffULL, 0x000000013b157824ULL, 0x000fe200078e0216ULL,
0x0000003802187811ULL, 0x000fe200078ff0ffULL, 0x000000040e0e7824ULL, 0x000fe200078e00ffULL,
0x0000000a1f207210ULL, 0x040fe20007fde0ffULL, 0x000000040c0a7824ULL, 0x000fe200078e00ffULL,
0x0000000f1f1b7210ULL, 0x000fe20007f3e0ffULL, 0x0000000416167824ULL, 0x000fe200078e00ffULL,
0x000000031d0f7812ULL, 0x000fe200078e4802ULL, 0x000000013b147824ULL, 0x000fe200078e0212ULL,
0x0000000b1f197210ULL, 0x000fe20007fbe0ffULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0x0000100000297811ULL, 0x000fe200078e68ffULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee20fULL, 0x000000013b177824ULL, 0x000fe200078e0218ULL,
0xfffffffc0e0b7812ULL, 0x100fe200078ee20fULL, 0x00000004100c7824ULL, 0x000fe200078e00ffULL,
0x0000000d1f1c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000418187824ULL, 0x000fe200078e00ffULL,
0x0ffffffc0f107812ULL, 0x000fe200078ef802ULL, 0x000000ffff1d7224ULL, 0x000fe200030e06ffULL,
0xfffffffc160e7812ULL, 0x000fe200078ee20fULL, 0x000000100b217824ULL, 0x000fe200078e0229ULL,
0xfffffffc1a027812ULL, 0x000fe200078ee20fULL, 0x00000010102b7824ULL, 0x100fe200078e0229ULL,
0x00005e00201e7a11ULL, 0x000fe200078c38ffULL, 0x000000100e277824ULL, 0x000fe200078e0229ULL,
0xfffffffc120d7812ULL, 0x000fe200078ee20fULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x000000141f147210ULL, 0x000fc40007f5e0ffULL, 0x000000151f157210ULL, 0x000fe20007f7e0ffULL,
0x000000100d257824ULL, 0x100fe200078e0229ULL, 0x000000171f177210ULL, 0x000fe20007f9e0ffULL,
0x000000100a1f7824ULL, 0x000fe200078e0229ULL, 0xfffffffc0c0c7812ULL, 0x100fe200078ee20fULL,
0x000000ffff0a7224ULL, 0x000fe200028e06ffULL, 0xfffffffc180f7812ULL, 0x000fe200078ee20fULL,
0x000000ffff127224ULL, 0x000fe200018e06ffULL, 0x00005f0020207a11ULL, 0x000fe200030f3c1dULL,
0x00000010021d7824ULL, 0x100fe200078e0229ULL, 0x00005e00190e7a11ULL, 0x000fe200078a38ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x00005e001c107a11ULL, 0x000fe200078038ffULL,
0x000000100c237824ULL, 0x100fe200078e0229ULL, 0x0000003011117812ULL, 0x000fe200078ec0ffULL,
0x000000100f297824ULL, 0x000fe200078e0229ULL, 0x00005e001b0d7a11ULL, 0x000fc400078238ffULL,
0x00005f00190f7a11ULL, 0x000fe200028f3c0aULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x00005f001c1c7a11ULL, 0x000fe400000f3c0bULL, 0x00000022110a7210ULL, 0x000fe40007f1e0ffULL,
0x00005f001b1b7a11ULL, 0x000fe200008f3c02ULL, 0x000000ffff027224ULL, 0x000fe200020e06ffULL,
0x00005e0014167a11ULL, 0x000fe200078238ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0624ULL,
0x00005e0015187a11ULL, 0x000fc400078438ffULL, 0x00005e00171a7a11ULL, 0x000fe400078638ffULL,
0x00005f0014197a11ULL, 0x000fe200008f3c19ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a2b7faeULL, 0x0003e2000b901c46ULL, 0x0000001e110c7210ULL, 0x000fe40007f1e0ffULL,
0x00005f0015127a11ULL, 0x000fe400010f3c12ULL, 0x0000000e110e7210ULL, 0x000fe40007f3e0ffULL,
0x00005f0017027a11ULL, 0x000fc400018f3c02ULL, 0x0000001011107210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x0000000d11147210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e0620ULL, 0x0000001611167210ULL, 0x040fe40007f9e0ffULL,
0x0000001811187210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff157224ULL, 0x000fe200018e061bULL,
0x0000001a111a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200010e061cULL,
0x000000000c1d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff177224ULL, 0x000fc400020e0619ULL,
0x000000ffff197224ULL, 0x000fe200028e0612ULL, 0x000000000e1f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1b7224ULL, 0x000fc600000e0602ULL, 0x0000000010217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e8000b901c46ULL, 0x0000000016257faeULL, 0x0003e8000b901c46ULL,
0x0000000018277faeULL, 0x0003e8000b901c46ULL, 0x000000001a297faeULL, 0x0003e4000b901c46ULL,
0x00f60400ff0b7984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x800000000bff7812ULL, 0x002fc60007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff027424ULL, 0x000fc800078e00ffULL, 0x00000002000a7305ULL, 0x0002a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x0000000a0000735dULL, 0x004fe20003800000ULL,
0x00f60400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000097919ULL, 0x000e640000000000ULL,
0x0000002000027824ULL, 0x002fc800078e0209ULL, 0x00000010020a7824ULL, 0x000fe200078e00ffULL,
0x00000003ff087819ULL, 0x000fc80000011602ULL, 0x1ffffffe08097812ULL, 0x000fe400078ec0ffULL,
0x000000f00a0a7812ULL, 0x000fe400078ec0ffULL, 0x00000001090b7812ULL, 0x040fe400078efcffULL,
0x0000000709097812ULL, 0x100fe400078e7802ULL, 0x000000070b0b7812ULL, 0x000fc600078e7802ULL,
0x0000000109097824ULL, 0x000fe400078e020aULL, 0x000000010a0b7824ULL, 0x000fc600078e020bULL,
0x0000000009147984ULL, 0x000e68000000cc00ULL, 0x000000000b0c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff147224ULL, 0x000fe400078e0015ULL,
0x000000ffff197224ULL, 0x000fe400078e0016ULL, 0x000000ffff157224ULL, 0x000fc400078e0017ULL,
0x000000ffff1a7224ULL, 0x004fe400078e000cULL, 0x000000ffff1b7224ULL, 0x000fe400078e000eULL,
0x000000ffff167224ULL, 0x000fe400078e000dULL, 0x000000ffff177224ULL, 0x000fe200078e000fULL,
0x0000001809007388ULL, 0x0003e8000000cc00ULL, 0x000000140b007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff087f8cULL, 0x002fe8000c80043fULL,
0x00f60400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x00000002000a7305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x0000000a0000735dULL, 0x004fe20003800000ULL, 0x00f60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000060500720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x3db504f33c3c7820ULL, 0x020fe20000410000ULL,
0x0000f688003d7811ULL, 0x000fe200078e18ffULL, 0x00006400133e7a24ULL, 0x000fe200078e02ffULL,
0xffffffff06407810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x0000f608003f7811ULL, 0x000fe400078e28ffULL, 0x0000010005427824ULL, 0x000fe200078e023aULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000420300720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x03cfea0003800000ULL, 0x000000ffff437224ULL, 0x000fe200078e0041ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fc4000001ff00ULL, 0x0000000144287810ULL, 0x000fe20007ffe0ffULL,
0x00000d7000007945ULL, 0x000fe20003800000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e0044ULL,
0x0000000143417812ULL, 0x000fe200078e0cffULL, 0x0000003938377224ULL, 0x020fe200078e02ffULL,
0x00000001ff2a7819ULL, 0x100fe20000011628ULL, 0x000000ffff447224ULL, 0x000fe200078e0028ULL,
0x000000022800780cULL, 0x000fc40003f06070ULL, 0x0000000128577812ULL, 0x000fe200078ec0ffULL,
0x000003002a2b7a24ULL, 0x000fca00078e0205ULL, 0x000000012b297810ULL, 0x000fc80007ffe0ffULL,
0x000000062900720cULL, 0x000fda0003f26070ULL, 0x000006c000009947ULL, 0x000fea0003800000ULL,
0x00000002ff367819ULL, 0x002fe20000011602ULL, 0x000001002b2e7824ULL, 0x000fe400078e023aULL,
0x0000000457477824ULL, 0x000fe200078e00ffULL, 0x0000000836487810ULL, 0x040fe20007ffe0ffULL,
0x000000013b287824ULL, 0x000fe200078e0236ULL, 0x0000001036507810ULL, 0x000fe20007ffe0ffULL,
0x0000000200467824ULL, 0x000fe200078e0241ULL, 0x0000002e03297217ULL, 0x000fe20007800000ULL,
0x000000013b2a7824ULL, 0x000fe200078e0248ULL, 0x0000002837317210ULL, 0x000fe20007f3e0ffULL,
0x000000013b2b7824ULL, 0x000fe200078e0250ULL, 0x0000001836527810ULL, 0x040fe20007ffe0ffULL,
0x0000000129457824ULL, 0x000fe200078e0a2eULL, 0x0000002a372f7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff347224ULL, 0x000fe200008e06ffULL, 0x0000002036547810ULL, 0x000fe20007ffe0ffULL,
0x000000013b2e7824ULL, 0x000fe200078e0252ULL, 0x00005e0031287a11ULL, 0x000fe200078238ffULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x00005e002f2a7a11ULL, 0x000fc400078438ffULL,
0x0000002b372d7210ULL, 0x000fe40007f7e0ffULL, 0x0000003036587810ULL, 0x040fe40007ffe0ffULL,
0x00005f002f2b7a11ULL, 0x000fe200010f3c32ULL, 0x000000013b2f7824ULL, 0x000fe200078e0254ULL,
0x00005f0031297a11ULL, 0x000fe200008f3c34ULL, 0x000000013b317824ULL, 0x000fe200078e0258ULL,
0x0000002836567810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff307224ULL, 0x000fe200018e06ffULL,
0x000000453600720cULL, 0x000fc40003f46070ULL, 0x00000038365a7810ULL, 0x000fe40007ffe0ffULL,
0x0000002e37367210ULL, 0x040fe40007f3e0ffULL, 0x0000002f37347210ULL, 0x000fe20007fbe0ffULL,
0x000000013b327824ULL, 0x000fe200078e025aULL, 0x00005e002d2c7a11ULL, 0x000fe200078638ffULL,
0x000000ffff2f7224ULL, 0x000fe200008e06ffULL, 0x00005e00362e7a11ULL, 0x000fe400078238ffULL,
0x0000003137357210ULL, 0x000fc40007f9e0ffULL, 0x00000003ff317819ULL, 0x000fe40000011602ULL,
0x00005f002d2d7a11ULL, 0x000fe200018f3c30ULL, 0x000000013b307824ULL, 0x000fe200078e0256ULL,
0x00005f00362f7a11ULL, 0x000fe200008f3c2fULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x000000454800720cULL, 0x040fe20003f26070ULL, 0x0000000448487824ULL, 0x000fe200078e00ffULL,
0x00000003314d7812ULL, 0x000fe200078e4802ULL, 0x000000ffff317224ULL, 0x000fe200028e06ffULL,
0x0000003037337210ULL, 0x000fc40007fde0ffULL, 0x0000100046467811ULL, 0x000fe400078e60ffULL,
0x0ffffffc4d497812ULL, 0x100fe200078ef802ULL, 0x000000ffff4c7224ULL, 0x000fe200030e06ffULL,
0xfffffffc47477812ULL, 0x000fe400078ee202ULL, 0x00005e0034307a11ULL, 0x000fe200078a38ffULL,
0x0000001049497824ULL, 0x000fe200078e0246ULL, 0xfffffffc484b7812ULL, 0x000fe200078ee24dULL,
0x0000001047287825ULL, 0x000fe200078e0028ULL, 0x0000003237377210ULL, 0x000fc40007f7e0ffULL,
0x00005f0034317a11ULL, 0x000fe200028f3c31ULL, 0x000000104b4b7824ULL, 0x000fe200078e0246ULL,
0x00005e0035347a11ULL, 0x000fe200078838ffULL, 0x00000010472a7825ULL, 0x000fe200078e002aULL,
0x00005e0033327a11ULL, 0x000fe200078a38ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028497faeULL, 0x0003e2000d101c46ULL, 0x00005f0035357a11ULL, 0x000fe200020f3c4aULL,
0x000000ffff487224ULL, 0x000fe200018e06ffULL, 0x00005e0037367a11ULL, 0x040fe200078638ffULL,
0x000000002a4b7faeULL, 0x0005e2000c901c46ULL, 0x000000455600720cULL, 0x0c0fe20003f86070ULL,
0x0000000456567824ULL, 0x000fe200078e00ffULL, 0x000000455000720cULL, 0x040fe20003f26070ULL,
0x0000000450507824ULL, 0x000fe200078e00ffULL, 0x00005f0037377a11ULL, 0x000fc400018f3c48ULL,
0x000000455200720cULL, 0x0c0fe20003f46070ULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x00005f0033337a11ULL, 0x000fe400028f3c4cULL, 0x000000455400720cULL, 0x0c0fe20003f66070ULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0x000000455800720cULL, 0x0c0fe20003fa6070ULL,
0x0000000458587824ULL, 0x000fe200078e00ffULL, 0x000000455a00720cULL, 0x040fe20003fc6070ULL,
0x000000045a5a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc56297812ULL, 0x002fe200078ee24dULL,
0x00000010472a7825ULL, 0x004fe200078e002eULL, 0xfffffffc50457812ULL, 0x000fc400078ee24dULL,
0xfffffffc52497812ULL, 0x000fe200078ee24dULL, 0x00000010472e7825ULL, 0x000fe200078e0032ULL,
0xfffffffc544b7812ULL, 0x100fe400078ee24dULL, 0xfffffffc584f7812ULL, 0x100fe200078ee24dULL,
0x0000001045457824ULL, 0x100fe200078e0246ULL, 0xfffffffc5a517812ULL, 0x000fe200078ee24dULL,
0x00000010294d7824ULL, 0x000fe400078e0246ULL, 0x0000001047287825ULL, 0x000fc800078e002cULL,
0x0000001049497824ULL, 0x100fe200078e0246ULL, 0x0000000028457faeULL, 0x0003e2000c901c46ULL,
0x000000104b4b7824ULL, 0x000fe400078e0246ULL, 0x00000010472c7825ULL, 0x000fe200078e0030ULL,
0x000000002a497faeULL, 0x0003e6000d101c46ULL, 0x000000104f4f7824ULL, 0x000fe200078e0246ULL,
0x000000002c4b7faeULL, 0x0003e2000d901c46ULL, 0x0000001047307825ULL, 0x000fc600078e0034ULL,
0x000000002e4d7faeULL, 0x0003e2000e101c46ULL, 0x0000001051517824ULL, 0x000fe400078e0246ULL,
0x0000001047327825ULL, 0x000fe200078e0036ULL, 0x00000000304f7faeULL, 0x0003e8000e901c46ULL,
0x0000000032517faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x0000003b02287211ULL, 0x042fe200078ff0ffULL, 0x0000000457537824ULL, 0x000fe200078e00ffULL,
0x0000000802307811ULL, 0x000fc400078ff0ffULL, 0x0000003728297210ULL, 0x080fe40007f3e0ffULL,
0x0000002002467811ULL, 0x040fe200078ff0ffULL, 0x000000013b2a7824ULL, 0x000fe200078e0230ULL,
0x0000001802347811ULL, 0x000fe200078ff0ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078238ffULL, 0x000000013b487824ULL, 0x040fe200078e0246ULL,
0x000000372a2b7210ULL, 0x000fe20007f5e0ffULL, 0x000000013b367824ULL, 0x000fe200078e0234ULL,
0x00005f0029297a11ULL, 0x000fe200008f3c2eULL, 0x0000000446467824ULL, 0x000fe200078e00ffULL,
0x00000010022e7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x00000028024a7811ULL, 0x000fc400078ff0ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078438ffULL,
0x000000013b327824ULL, 0x040fe200078e022eULL, 0x00000003ff457819ULL, 0x000fe20000011602ULL,
0x000000013b4c7824ULL, 0x000fe200078e024aULL, 0x00005f002b2b7a11ULL, 0x000fe200010f3c2cULL,
0x00000002002c7824ULL, 0x000fe200078e0241ULL, 0x0000003002507811ULL, 0x000fe200078ff0ffULL,
0x000000042e2e7824ULL, 0x000fe200078e00ffULL, 0x0000003802547811ULL, 0x000fe400078ff0ffULL,
0x00000037322d7210ULL, 0x080fe20007fde0ffULL, 0x0000000430327824ULL, 0x000fe200078e00ffULL,
0x0000000345457812ULL, 0x000fe200078e4802ULL, 0x000000013b527824ULL, 0x000fe200078e0250ULL,
0x0000003748317210ULL, 0x080fe20007f9e0ffULL, 0x000000044a487824ULL, 0x000fe200078e00ffULL,
0x00000037362f7210ULL, 0x080fe20007fbe0ffULL, 0x0000000434367824ULL, 0x000fe200078e00ffULL,
0x000000374c337210ULL, 0x000fe20007f3e0ffULL, 0x00000004504a7824ULL, 0x000fe200078e00ffULL,
0x000010002c517811ULL, 0x000fe200078e60ffULL, 0x00000004544c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc2e347812ULL, 0x000fe200078ee245ULL, 0x000000ffff2e7224ULL, 0x000fe200030e06ffULL,
0x0ffffffc45307812ULL, 0x000fe200078ef802ULL, 0x000000013b567824ULL, 0x000fe200078e0254ULL,
0x00005e002d2c7a11ULL, 0x000fe200078c38ffULL, 0x0000001034477824ULL, 0x000fe200078e0251ULL,
0xfffffffc32327812ULL, 0x000fe200078ee245ULL, 0x0000001030557824ULL, 0x000fe200078e0251ULL,
0xfffffffc36367812ULL, 0x100fe200078ee245ULL, 0x000000ffff307224ULL, 0x000fe200028e06ffULL,
0xfffffffc46467812ULL, 0x000fc400078ee245ULL, 0xfffffffc48487812ULL, 0x000fe200078ee245ULL,
0x0000001036497824ULL, 0x000fe200078e0251ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee245ULL,
0x00000010464b7824ULL, 0x000fe200078e0251ULL, 0xfffffffc4c4c7812ULL, 0x000fe200078ee245ULL,
0x0000001032457824ULL, 0x100fe200078e0251ULL, 0x00005f002d2d7a11ULL, 0x000fe200030f3c2eULL,
0x00000010484d7824ULL, 0x100fe200078e0251ULL, 0x00005e002f2e7a11ULL, 0x040fe200078a38ffULL,
0x000000104a4f7824ULL, 0x100fe200078e0251ULL, 0x0000003752357210ULL, 0x080fe20007f5e0ffULL,
0x000000104c517824ULL, 0x000fe200078e0251ULL, 0x0000003756377210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x00005f002f2f7a11ULL, 0x000fe200028f3c30ULL,
0x000000ffff4a7224ULL, 0x000fe200008e06ffULL, 0xfffffffc53537812ULL, 0x000fe200078ee202ULL,
0x000000ffff487224ULL, 0x000fe200010e06ffULL, 0x00005e0031307a11ULL, 0x000fe200078838ffULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x00005e0033327a11ULL, 0x000fe200078238ffULL,
0x0000001053287825ULL, 0x000fe200078e0028ULL, 0x00005e0035347a11ULL, 0x000fc400078438ffULL,
0x00005e0037367a11ULL, 0x000fe200078638ffULL, 0x00000010532a7825ULL, 0x000fe200078e002aULL,
0x00005f0031317a11ULL, 0x000fe200020f3c4cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028557faeULL, 0x0003e2000b901c46ULL, 0x00005f0033337a11ULL, 0x000fe200008f3c4aULL,
0x00000010532c7825ULL, 0x000fe200078e002cULL, 0x00005f0035357a11ULL, 0x000fe200010f3c48ULL,
0x000000002a457faeULL, 0x0003e2000b901c46ULL, 0x00005f0037377a11ULL, 0x000fe200018f3c46ULL,
0x00000010532e7825ULL, 0x040fe400078e002eULL, 0x000000002c477faeULL, 0x0003e4000b901c46ULL,
0x0000001053307825ULL, 0x000fc400078e0030ULL, 0x000000002e497faeULL, 0x0003e4000b901c46ULL,
0x0000001053327825ULL, 0x040fe400078e0032ULL, 0x00000000304b7faeULL, 0x0003e4000b901c46ULL,
0x0000001053347825ULL, 0x040fe400078e0034ULL, 0x00000000324d7faeULL, 0x0003e4000b901c46ULL,
0x0000001053367825ULL, 0x000fc400078e0036ULL, 0x00000000344f7faeULL, 0x0003e8000b901c46ULL,
0x0000000036517faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff5700720cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000009947ULL, 0x000fea0003800000ULL, 0x00000004ff297424ULL, 0x002fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x0000030029077a24ULL, 0x000fca00078e0207ULL,
0x000000040700720cULL, 0x000fda0003f26070ULL, 0x0000003000001947ULL, 0x000fea0003800000ULL,
0x000000023e287824ULL, 0x000fc800078e0207ULL, 0x0000600028287625ULL, 0x000fca00078e0029ULL,
0x0000000628387981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000084e4d7824ULL, 0x002fe400078e00ffULL,
0x000000ffff4b7224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff802297812ULL, 0x000fe200078ec0ffULL, 0x00000002002d7824ULL, 0x000fe200078e0243ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000014b2f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000729297812ULL, 0x000fe400078ef802ULL, 0x000010002d2d7811ULL, 0x000fc400078e60ffULL,
0x00000001ff287819ULL, 0x000fc80000011629ULL, 0x0000000328287812ULL, 0x000fc800078ec0ffULL,
0x0000004b282a7212ULL, 0x040fe400078e3cffULL, 0x0000002f28287212ULL, 0x000fc600078e3cffULL,
0x00000004292a7824ULL, 0x040fe400078e022aULL, 0x0000000429287824ULL, 0x000fe200078e0228ULL,
0x0000002002297810ULL, 0x000fe20007ffe0ffULL, 0x000000102a2a7824ULL, 0x100fe400078e022dULL,
0x0000001028287824ULL, 0x000fe200078e022dULL, 0xfffffff829297812ULL, 0x000fe400078ec0ffULL,
0x000000002a34783bULL, 0x000e640000000200ULL, 0x00000007292c7812ULL, 0x000fc400078ef802ULL,
0x000000002830783bULL, 0x0002a40000000200ULL, 0x00000018ff287819ULL, 0x002fe20000011434ULL,
0x0001000034587824ULL, 0x000fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe20000011435ULL,
0x0000003400a07306ULL, 0x000fe20000009400ULL, 0x00000018ff2b7819ULL, 0x000fe20000011436ULL,
0x0001000035597824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000018ff467819ULL, 0x004fc40000011430ULL, 0x00000018ff457819ULL, 0x000fe20000011437ULL,
0x0000002800a27306ULL, 0x000fe20000209400ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff497819ULL, 0x000fe40000011432ULL, 0x00000018ff4a7819ULL, 0x000fe40000011433ULL,
0x00000018ff487819ULL, 0x000fe20000011431ULL, 0x0000002800a77306ULL, 0x000e700000205400ULL,
0x0000002800877306ULL, 0x0004f0000020d400ULL, 0x0000002a00a87306ULL, 0x000fe20000209400ULL,
0x00000001ff287819ULL, 0x004fc4000001162cULL, 0x000000a7a200720bULL, 0x002fe40003fdd000ULL,
0x0000000328287812ULL, 0x000fc600078ec0ffULL, 0x0000002a00ab7306ULL, 0x000fe20000205400ULL,
0x0000004b28297212ULL, 0x040fe400078e3cffULL, 0x0000002f282f7212ULL, 0x000fe400078e3cffULL,
0x000000024b4b7810ULL, 0x000fc60007ffe0ffULL, 0x0000002a00857306ULL, 0x0003e2000020d400ULL,
0x0000000187876812ULL, 0x008fce00078efcffULL, 0x0000002b00aa7306ULL, 0x000fe20000209400ULL,
0x000000042c2a7824ULL, 0x042fe400078e0229ULL, 0x000000042c2c7824ULL, 0x000fe400078e022fULL,
0x000000102a2a7824ULL, 0x100fe400078e022dULL, 0x000000102c2c7824ULL, 0x000fe200078e022dULL,
0x0000002b00a97306ULL, 0x000fea0000205400ULL, 0x000000002c2c783bULL, 0x000e660000000200ULL,
0x0000002b00837306ULL, 0x0005f0000020d400ULL, 0x0000005800707306ULL, 0x000fe20000209400ULL,
0x000000002a28783bULL, 0x004eae0000000200ULL, 0x0000005800bb7306ULL, 0x000ef00000205400ULL,
0x0000003400a17306ULL, 0x000f300000005400ULL, 0x0000003400887306ULL, 0x0008a2000000d400ULL,
0x000000bb7000720bULL, 0x008fc40003f9d000ULL, 0x00000018ff737819ULL, 0x002fe4000001142dULL,
0x00000018ff797819ULL, 0x000fc6000001142eULL, 0x0000003500a37306ULL, 0x000fe20000009400ULL,
0x0000010034347824ULL, 0x010fe200078e00ffULL, 0x000000a1a000720bULL, 0x000fe40003f5d000ULL,
0x00000018ff5f7819ULL, 0x000fe4000001142cULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500a67306ULL, 0x000e620000005400ULL, 0x0001000028717824ULL, 0x004fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fc8000001142fULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000003500867306ULL, 0x0004e2000000d400ULL, 0x0000000188882812ULL, 0x000fce00078efcffULL,
0x0000003400bd7306ULL, 0x000fe20000209400ULL, 0x0000010035357824ULL, 0x004fe200078e00ffULL,
0x000000a6a300720bULL, 0x002fc80003fbd000ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400ba7306ULL, 0x000e6e0000205400ULL, 0x0000000186865812ULL, 0x008fe200078efcffULL,
0x00000034009c7306ULL, 0x0005e2000020d400ULL, 0x000000a9aa00720bULL, 0x000fce0003fbd000ULL,
0x0000005800997306ULL, 0x000722000020d400ULL, 0x0001000037347824ULL, 0x004fe200078e00ffULL,
0x000000babd00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500c67306ULL, 0x000fe20000209400ULL, 0x0001000036587824ULL, 0x008fe200078e00ffULL,
0x0000000183835812ULL, 0x000fc800078efcffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x0000003500c97306ULL, 0x000e620000205400ULL, 0x0000000199994812ULL, 0x010fe400078efcffULL,
0x000000019c9c3812ULL, 0x000fe400078efcffULL, 0x000000aba800720bULL, 0x000fc60003f7d000ULL,
0x00000035009a7306ULL, 0x0004f0000020d400ULL, 0x0000003600a57306ULL, 0x000fe20000009400ULL,
0x00000018ff357819ULL, 0x004fe40000011428ULL, 0x000000c9c600720bULL, 0x002fc40003f9d000ULL,
0x0000000185853812ULL, 0x000fc600078efcffULL, 0x0000003600a47306ULL, 0x000e700000005400ULL,
0x0000003600847306ULL, 0x000522000000d400ULL, 0x000000019a9a4812ULL, 0x008fce00078efcffULL,
0x0000003500d07306ULL, 0x000fe20000209400ULL, 0x0000010036367824ULL, 0x004fe200078e00ffULL,
0x000000a4a500720bULL, 0x002fc80003f5d000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003500d37306ULL, 0x000fee0000205400ULL, 0x0000000184842812ULL, 0x010fe200078efcffULL,
0x0000003500747306ULL, 0x0003f0000020d400ULL, 0x0000003000917306ULL, 0x000fe20000009400ULL,
0x0001000030357824ULL, 0x002fce00078e00ffULL, 0x0000003000927306ULL, 0x000ff00000005400ULL,
0x0000003000547306ULL, 0x0003f0000000d400ULL, 0x0000003400ce7306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x002fce00078e00ffULL, 0x0000003400d17306ULL, 0x000e700000205400ULL,
0x00000034009b7306ULL, 0x0004f0000020d400ULL, 0x00000037009d7306ULL, 0x000fe20000009400ULL,
0x00000018ff347819ULL, 0x004fc4000001142aULL, 0x000000d1ce00720bULL, 0x002fca0003f9d000ULL,
0x00000037009e7306ULL, 0x000e700000005400ULL, 0x0000003700807306ULL, 0x000522000000d400ULL,
0x000000019b9b4812ULL, 0x008fce00078efcffULL, 0x0000003400c77306ULL, 0x000fe20000209400ULL,
0x0000010037377824ULL, 0x004fe200078e00ffULL, 0x0000009e9d00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000003400c47306ULL, 0x000fee0000205400ULL,
0x0000000180803812ULL, 0x010fe200078efcffULL, 0x00000034006a7306ULL, 0x0003f0000020d400ULL,
0x0000003600ca7306ULL, 0x000fe20000209400ULL, 0x00000018ff347819ULL, 0x002fe20000011430ULL,
0x0001000031307824ULL, 0x000fcc00078e00ffULL, 0x0000003600cd7306ULL, 0x000ff00000205400ULL,
0x0000003600967306ULL, 0x0003f0000020d400ULL, 0x0000005800c87306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x002fce0000011429ULL, 0x0000005800cb7306ULL, 0x000e700000205400ULL,
0x00000058009f7306ULL, 0x0004f0000020d400ULL, 0x0000003600cc7306ULL, 0x000fe20000209400ULL,
0x00000018ff587819ULL, 0x004fc40000011435ULL, 0x000000cbc800720bULL, 0x002fca0003fdd000ULL,
0x0000003600cf7306ULL, 0x000ff00000205400ULL, 0x00000036006f7306ULL, 0x0003e2000020d400ULL,
0x000000019f9f6812ULL, 0x008fce00078efcffULL, 0x0000003700d27306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x002fe20000011430ULL, 0x0000010031307824ULL, 0x000fcc00078e00ffULL,
0x0000003700d57306ULL, 0x000e700000205400ULL, 0x00000037007d7306ULL, 0x0004f0000020d400ULL,
0x0000005900c57306ULL, 0x000fe20000209400ULL, 0x00000018ff377819ULL, 0x004fc4000001142bULL,
0x000000d5d200720bULL, 0x002fca0003fdd000ULL, 0x0000005900c27306ULL, 0x000e700000205400ULL,
0x0000005900977306ULL, 0x000522000020d400ULL, 0x000000017d7d6812ULL, 0x008fce00078efcffULL,
0x0000005800be7306ULL, 0x000fe20000209400ULL, 0x0001000033597824ULL, 0x004fe200078e00ffULL,
0x000000c2c500720bULL, 0x002fc80003f3d000ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000005800c17306ULL, 0x000fee0000205400ULL, 0x0000000197971812ULL, 0x010fe200078efcffULL,
0x0000005800617306ULL, 0x0003e2000020d400ULL, 0x000000cdca00720bULL, 0x000fce0003f3d000ULL,
0x0000003700c07306ULL, 0x000fe20000209400ULL, 0x0001000032587824ULL, 0x002fca00078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000003700c37306ULL, 0x000fe20000205400ULL,
0x0000000196961812ULL, 0x000fce00078efcffULL, 0x0000003700657306ULL, 0x0003f0000020d400ULL,
0x0000007100d67306ULL, 0x000fe20000209400ULL, 0x00000018ff377819ULL, 0x002fce0000011430ULL,
0x0000007100d97306ULL, 0x000e700000205400ULL, 0x0000003400bc7306ULL, 0x000ff00000209400ULL,
0x0000003400bf7306ULL, 0x000fe20000205400ULL, 0x000000d9d600720bULL, 0x002fce0003f9d000ULL,
0x0000003400357306ULL, 0x0003f0000020d400ULL, 0x0000003700b37306ULL, 0x000fe20000209400ULL,
0x0000010032347824ULL, 0x002fce00078e00ffULL, 0x0000003700b47306ULL, 0x000ff00000205400ULL,
0x0000003700307306ULL, 0x0003f0000020d400ULL, 0x0000003200907306ULL, 0x000fe20000009400ULL,
0x0000010033377824ULL, 0x002fca00078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011437ULL,
0x00000032008d7306ULL, 0x000ff00000005400ULL, 0x0000003200517306ULL, 0x000ff0000000d400ULL,
0x00000033008b7306ULL, 0x000ff00000009400ULL, 0x00000033008e7306ULL, 0x000ff00000005400ULL,
0x0000003300507306ULL, 0x000ff0000000d400ULL, 0x0000005800ac7306ULL, 0x000ff00000209400ULL,
0x0000005800ad7306ULL, 0x000ff00000205400ULL, 0x0000005800327306ULL, 0x000ff0000020d400ULL,
0x0000005900757306ULL, 0x000ff00000209400ULL, 0x0000005900727306ULL, 0x000ff00000205400ULL,
0x0000005900337306ULL, 0x000ff0000020d400ULL, 0x0000002800b77306ULL, 0x000ff00000009400ULL,
0x0000002800b27306ULL, 0x000e700000005400ULL, 0x00000028006c7306ULL, 0x0004f0000000d400ULL,
0x0000007300587306ULL, 0x000fe20000209400ULL, 0x0000010028287824ULL, 0x004fe200078e00ffULL,
0x000000b2b700720bULL, 0x002fc80003f3d000ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000007300597306ULL, 0x000fee0000205400ULL, 0x000000016c6c1812ULL, 0x008fe200078efcffULL,
0x00000073005a7306ULL, 0x0003e2000020d400ULL, 0x000000cfcc00720bULL, 0x000fce0003f3d000ULL,
0x00000071007b7306ULL, 0x0004e2000020d400ULL, 0x0001000029737824ULL, 0x002fca00078e00ffULL,
0x00000018ffd47819ULL, 0x000fe40000011473ULL, 0x0000002900b57306ULL, 0x000fe20000009400ULL,
0x000100002a717824ULL, 0x004fe200078e00ffULL, 0x000000016f6f1812ULL, 0x000fcc00078efcffULL,
0x0000002900b67306ULL, 0x000e620000005400ULL, 0x000000017b7b4812ULL, 0x008fce00078efcffULL,
0x0000002800d87306ULL, 0x000ff00000209400ULL, 0x0000002800db7306ULL, 0x000ea20000205400ULL,
0x000000b6b500720bULL, 0x002fce0003fbd000ULL, 0x000000d400da7306ULL, 0x000ff00000209400ULL,
0x000000d400dd7306ULL, 0x000e620000205400ULL, 0x000000dbd800720bULL, 0x004fce0003fdd000ULL,
0x0000002900697306ULL, 0x0004f0000000d400ULL, 0x0000002a00b17306ULL, 0x000fe20000009400ULL,
0x0000010029297824ULL, 0x004fe200078e00ffULL, 0x000000ddda00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002a00b07306ULL, 0x000e620000005400ULL,
0x0000000169695812ULL, 0x008fe400078efcffULL, 0x000000c4c700720bULL, 0x000fca0003fbd000ULL,
0x0000002a00647306ULL, 0x0004f0000000d400ULL, 0x0000004500ae7306ULL, 0x000fe20000209400ULL,
0x000001002a2a7824ULL, 0x004fe200078e00ffULL, 0x000000b0b100720bULL, 0x002fc40003f7d000ULL,
0x000000016a6a5812ULL, 0x000fe400078efcffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000004500af7306ULL, 0x000e620000205400ULL, 0x000000c1be00720bULL, 0x000fcc0003fbd000ULL,
0x0000000164643812ULL, 0x008fe200078efcffULL, 0x0000005c006d7306ULL, 0x000fe20000209400ULL,
0x000000929100720bULL, 0x000fca0003f7d000ULL, 0x0000000161615812ULL, 0x000fe400078efcffULL,
0x0000005c006e7306ULL, 0x000fe20000205400ULL, 0x000000afae00720bULL, 0x002fe40003f5d000ULL,
0x000000bfbc00720bULL, 0x000fc60003fbd000ULL, 0x0000000154543812ULL, 0x000fe400078efcffULL,
0x0000005c00377306ULL, 0x000fe4000020d400ULL, 0x000000546154723eULL, 0x000fcc00000010ffULL,
0x00000079005b7306ULL, 0x000fe20000209400ULL, 0x0000000135355812ULL, 0x000fce00078efcffULL,
0x00000079005c7306ULL, 0x000ff00000205400ULL, 0x00000079005d7306ULL, 0x000ff0000020d400ULL,
0x00000031008f7306ULL, 0x000ff00000009400ULL, 0x00000031008a7306ULL, 0x000ff00000005400ULL,
0x0000003100527306ULL, 0x000ff0000000d400ULL, 0x0000002800797306ULL, 0x0002b0000020d400ULL,
0x000000d4007c7306ULL, 0x000722000020d400ULL, 0x00000018ff287819ULL, 0x002fce0000011471ULL,
0x0000003600b97306ULL, 0x000fe20000209400ULL, 0x000100002bd47824ULL, 0x008fe200078e00ffULL,
0x0000000179796812ULL, 0x004fcc00078efcffULL, 0x0000003600b87306ULL, 0x000e620000205400ULL,
0x000000017c7c4812ULL, 0x010fc800078efcffULL, 0x000000697c7c723eULL, 0x000fc600000010ffULL,
0x0000003600317306ULL, 0x0004f0000020d400ULL, 0x0000002900dc7306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x004fe40000011434ULL, 0x000000b8b900720bULL, 0x002fca0003f7d000ULL,
0x0000002900df7306ULL, 0x000e700000205400ULL, 0x0000002a00e07306ULL, 0x000fe20000209400ULL,
0x0000000131313812ULL, 0x008fce00078efcffULL, 0x0000002a00e37306ULL, 0x000ea20000205400ULL,
0x000000dfdc00720bULL, 0x002fce0003fdd000ULL, 0x0000002b00957306ULL, 0x000ff00000009400ULL,
0x0000002b00987306ULL, 0x000e620000005400ULL, 0x000000e3e000720bULL, 0x004fce0003f9d000ULL,
0x0000002b00577306ULL, 0x0004f0000000d400ULL, 0x0000003600817306ULL, 0x000fe20000209400ULL,
0x000001002b2b7824ULL, 0x004fe200078e00ffULL, 0x000000989500720bULL, 0x002fc80003f3d000ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000003600827306ULL, 0x000fee0000205400ULL,
0x0000000157571812ULL, 0x008fe200078efcffULL, 0x0000003600347306ULL, 0x000fe2000020d400ULL,
0x0000008d9000720bULL, 0x000fe20003f3d000ULL, 0x000001002e8d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001148dULL, 0x0000004500787306ULL, 0x000e6c000020d400ULL,
0x0000000151511812ULL, 0x000fe400078efcffULL, 0x0000005f00667306ULL, 0x000fe20000209400ULL,
0x000000727500720bULL, 0x000fce0003f3d000ULL, 0x0000005f00677306ULL, 0x000fe20000205400ULL,
0x0000000178782812ULL, 0x002fe400078efcffULL, 0x000000d3d000720bULL, 0x000fc60003f5d000ULL,
0x0000000133331812ULL, 0x000fe400078efcffULL, 0x0000005f00367306ULL, 0x000ff0000020d400ULL,
0x0000007a005e7306ULL, 0x000fe20000209400ULL, 0x0000000174742812ULL, 0x000fc800078efcffULL,
0x000000797479723eULL, 0x000fc600000010ffULL, 0x0000007a005f7306ULL, 0x000ff00000205400ULL,
0x0000007a00607306ULL, 0x000ff0000020d400ULL, 0x00000029007a7306ULL, 0x0002b0000020d400ULL,
0x0000002800de7306ULL, 0x000fe20000209400ULL, 0x00000018ff297819ULL, 0x002fce00000114d4ULL,
0x0000002800e17306ULL, 0x000e620000205400ULL, 0x000000017a7a6812ULL, 0x004fce00078efcffULL,
0x0000002800737306ULL, 0x0005f0000020d400ULL, 0x0000002a00717306ULL, 0x000722000020d400ULL,
0x000100002c287824ULL, 0x004fe200078e00ffULL, 0x000000e1de00720bULL, 0x002fcc0003f5d000ULL,
0x0000002900d47306ULL, 0x000fe20000209400ULL, 0x000100002d2a7824ULL, 0x008fca00078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe4000001142aULL, 0x0000002900d77306ULL, 0x000e620000205400ULL,
0x0000000171714812ULL, 0x010fe400078efcffULL, 0x000000c3c000720bULL, 0x000fe40003f9d000ULL,
0x0000000173732812ULL, 0x000fc600078efcffULL, 0x0000002b00a77306ULL, 0x000ff00000209400ULL,
0x0000002b00a67306ULL, 0x000ea20000205400ULL, 0x000000d7d400720bULL, 0x002fe40003fdd000ULL,
0x0000000165654812ULL, 0x000fca00078efcffULL, 0x0000002b00a07306ULL, 0x0003f0000020d400ULL,
0x0000002900707306ULL, 0x000722000020d400ULL, 0x00000007022b7812ULL, 0x002fe400078ec0ffULL,
0x000000a6a700720bULL, 0x004fc40003f5d000ULL, 0x000000082bab7812ULL, 0x000fc600078ef802ULL,
0x0000004600937306ULL, 0x000fe20000209400ULL, 0x00000018ff297819ULL, 0x008fe40000011428ULL,
0x0000004d02287211ULL, 0x000fe400078fe0ffULL, 0x000000044d4d7810ULL, 0x000fc60007ffe0ffULL,
0x0000002900a17306ULL, 0x000fe20000209400ULL, 0x0000000170706812ULL, 0x010fe400078efcffULL,
0x0000008a8f00720bULL, 0x000fe20003fdd000ULL, 0x000001002f8f7824ULL, 0x000fe200078e00ffULL,
0x00000001a0a02812ULL, 0x000fe400078efcffULL, 0x0000008e8b00720bULL, 0x000fe20003f5d000ULL,
0x0000002900a27306ULL, 0x000e620000205400ULL, 0x000100002f8e7824ULL, 0x000fe200078e00ffULL,
0x000000a06565723eULL, 0x000fc400000010ffULL, 0x00000018ff8f7819ULL, 0x000fe4000001148fULL,
0x00000018ff8e7819ULL, 0x000fe4000001148eULL, 0x00000029009e7306ULL, 0x0005e2000020d400ULL,
0x0000000152526812ULL, 0x000fe400078efcffULL, 0x000000adac00720bULL, 0x000fe40003fdd000ULL,
0x0000000150502812ULL, 0x000fe400078efcffULL, 0x000000523152723eULL, 0x000fe200000010ffULL,
0x0000004600947306ULL, 0x000ee20000205400ULL, 0x0000000728297812ULL, 0x004fc400078e78abULL,
0x0000000228287810ULL, 0x000fe40007ffe0ffULL, 0x000000a2a100720bULL, 0x002fe20003f5d000ULL,
0x00000010ab297824ULL, 0x000fe200078e0229ULL, 0x000000503350723eULL, 0x000fe200000010ffULL,
0x0000002c00687306ULL, 0x000fe20000009400ULL, 0x0000000132326812ULL, 0x000fe200078efcffULL,
0x0000001029297824ULL, 0x000fcc00078e00ffULL, 0x0000002c006b7306ULL, 0x000e620000005400ULL,
0x000000949300720bULL, 0x008fe40003f9d000ULL, 0x000000019e9e2812ULL, 0x000fca00078efcffULL,
0x0000002c004f7306ULL, 0x0005f0000000d400ULL, 0x00000046004c7306ULL, 0x000ee2000020d400ULL,
0x000001002c2c7824ULL, 0x004fe200078e00ffULL, 0x0000006b6800720bULL, 0x002fc80003fdd000ULL,
0x00000018ffa97819ULL, 0x000fe4000001142cULL, 0x00000007282c7812ULL, 0x000fe200078e78abULL,
0x00000048008c7306ULL, 0x000fe20000209400ULL, 0x000000002928783bULL, 0x000e660000000200ULL,
0x00000010aba87824ULL, 0x000fe200078e022cULL, 0x00000088992c723eULL, 0x000fe400000010ffULL,
0x000000014c4c4812ULL, 0x008fe200078efcffULL, 0x0000004800897306ULL, 0x000ea20000205400ULL,
0x000000b4b300720bULL, 0x000fc40003f9d000ULL, 0x000000014f4f6812ULL, 0x000fca00078efcffULL,
0x00000049007f7306ULL, 0x000fec0000209400ULL, 0x0000000130304812ULL, 0x000fe400078efcffULL,
0x00000049007e7306ULL, 0x000ee20000205400ULL, 0x000000898c00720bULL, 0x004fce0003fbd000ULL,
0x0000004800477306ULL, 0x000eb0000020d400ULL, 0x0000004900457306ULL, 0x000f22000020d400ULL,
0x0000007e7f00720bULL, 0x008fce0003f7d000ULL, 0x0000004a00777306ULL, 0x000fe20000209400ULL,
0x0000000147475812ULL, 0x004fe400078efcffULL, 0x000000828100720bULL, 0x000fca0003fbd000ULL,
0x0000004a00767306ULL, 0x000ea20000205400ULL, 0x0000000145453812ULL, 0x010fe400078efcffULL,
0x0000006e6d00720bULL, 0x000fca0003f7d000ULL, 0x0000002d00637306ULL, 0x000fe20000009400ULL,
0x0000000134345812ULL, 0x000fce00078efcffULL, 0x0000002d00627306ULL, 0x000ee20000005400ULL,
0x000000767700720bULL, 0x004fe40003f9d000ULL, 0x0000000137373812ULL, 0x000fe400078efcffULL,
0x000000676600720bULL, 0x000fc60003f7d000ULL, 0x0000002d004e7306ULL, 0x0005f0000000d400ULL,
0x0000004a00467306ULL, 0x000f22000020d400ULL, 0x000001002d2d7824ULL, 0x004fe200078e00ffULL,
0x000000626300720bULL, 0x008fc40003fbd000ULL, 0x000000647362723eULL, 0x000fe400000010ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001142dULL, 0x000000a900a37306ULL, 0x000fe20000209400ULL,
0x0000009c872d723eULL, 0x000fe200000010ffULL, 0x000100002e877824ULL, 0x000fe200078e00ffULL,
0x000000716a63723eULL, 0x000fe400000010ffULL, 0x000000577064723eULL, 0x000fe400000010ffULL,
0x00000018ff877819ULL, 0x000fe20000011487ULL, 0x000000a900a47306ULL, 0x000ea20000205400ULL,
0x0000002c280c723cULL, 0x002fe2000004180cULL, 0x0000000146464812ULL, 0x010fc400078efcffULL,
0x0000000136363812ULL, 0x000fe400078efcffULL, 0x000000595800720bULL, 0x000fe40003f7d000ULL,
0x000000aa00a57306ULL, 0x000fe20000209400ULL, 0x00000086972c723eULL, 0x000fe200000010ffULL,
0x000000622814723cULL, 0x040fe20000041814ULL, 0x0000009a852d723eULL, 0x000fe400000010ffULL,
0x000000014e4e5812ULL, 0x000fe400078efcffULL, 0x0000005c5b00720bULL, 0x000fe20003fbd000ULL,
0x000000aa00987306ULL, 0x000e620000205400ULL, 0x000000a4a300720bULL, 0x004fe20003f9d000ULL,
0x0000002c2808723cULL, 0x000fe20000041808ULL, 0x000000015a5a3812ULL, 0x000fc400078efcffULL,
0x0000004f9e9c723eULL, 0x000fc600000010ffULL, 0x0000002f004a7306ULL, 0x000fe20000009400ULL,
0x0000007d782d723eULL, 0x000fe200000010ffULL, 0x000000642810723cULL, 0x040fe20000041810ULL,
0x000000809b2c723eULL, 0x000fe400000010ffULL, 0x0000006c7b78723eULL, 0x000fe400000010ffULL,
0x0000007a6f7d723eULL, 0x000fe200000010ffULL, 0x0000002f00537306ULL, 0x000ea20000005400ULL,
0x00000098a500720bULL, 0x002fe20003fdd000ULL, 0x0000002c2820723cULL, 0x000fe20000041820ULL,
0x000000015d5d5812ULL, 0x000fca00078efcffULL, 0x0000002e00567306ULL, 0x000fe40000009400ULL,
0x00000078281c723cULL, 0x040fec000004181cULL, 0x0000002e00557306ULL, 0x000e620000005400ULL,
0x000000534a00720bULL, 0x004fe20003f5d000ULL, 0x0000007c2818723cULL, 0x000fe20000041818ULL,
0x000000304753723eULL, 0x000fca00000010ffULL, 0x0000002f00497306ULL, 0x0004f0000000d400ULL,
0x0000002e00487306ULL, 0x0008e2000000d400ULL, 0x00000096832f723eULL, 0x004fe400000010ffULL,
0x000000555600720bULL, 0x002fc40003f3d000ULL, 0x000000354c55723eULL, 0x000fc600000010ffULL,
0x000000a9009d7306ULL, 0x000e62000020d400ULL, 0x000000849f2e723eULL, 0x010fe400000010ffULL,
0x0000000149492812ULL, 0x008fca00078efcffULL, 0x000000aa00917306ULL, 0x000ea2000020d400ULL,
0x0000002e2824723cULL, 0x000fe20000041824ULL, 0x0000000148481812ULL, 0x000fcc00078efcffULL,
0x0000008a008b7306ULL, 0x000fe20000209400ULL, 0x00000010a82e7824ULL, 0x000fe200078e00ffULL,
0x000000019d9d4812ULL, 0x002fe400078efcffULL, 0x000000513228723eULL, 0x000fe400000010ffULL,
0x000000344529723eULL, 0x000fe200000010ffULL, 0x000000002e2c783bULL, 0x000e620000000200ULL,
0x0000008a00887306ULL, 0x000ee20000205400ULL, 0x0000000191916812ULL, 0x004fe400078efcffULL,
0x000000374651723eULL, 0x000fc400000010ffULL, 0x0000009d369d723eULL, 0x000fe400000010ffULL,
0x0000004e914e723eULL, 0x000fe200000010ffULL, 0x0000008700837306ULL, 0x000ff00000209400ULL,
0x00000087007e7306ULL, 0x000ea20000205400ULL, 0x000000888b00720bULL, 0x008fce0003f9d000ULL,
0x0000008f002b7306ULL, 0x000ff00000209400ULL, 0x0000008f00307306ULL, 0x000ee20000205400ULL,
0x0000007e8300720bULL, 0x004fe20003fdd000ULL, 0x000000542c0c723cULL, 0x042fec000004180cULL,
0x0000008a00857306ULL, 0x000e64000020d400ULL, 0x000000522c08723cULL, 0x040fec0000041808ULL,
0x0000008700777306ULL, 0x000ea2000020d400ULL, 0x000000302b00720bULL, 0x008fe20003f3d000ULL,
0x000000282c24723cULL, 0x000fec0000041824ULL, 0x0000008d00687306ULL, 0x000fe20000209400ULL,
0x0000000185854812ULL, 0x002fc400078efcffULL, 0x0000005f5e00720bULL, 0x000fe40003f9d000ULL,
0x000000855a4f723eULL, 0x000fe200000010ffULL, 0x000000502c20723cULL, 0x000fe40000041820ULL,
0x0000008d00697306ULL, 0x000e620000205400ULL, 0x0000000177776812ULL, 0x004fc800078efcffULL,
0x00000048775c723eULL, 0x000fe200000010ffULL, 0x0000009c2c1c723cULL, 0x000fe4000004181cULL,
0x0000008e00577306ULL, 0x000fe20000209400ULL, 0x0000000160604812ULL, 0x000fca00078efcffULL,
0x0000004e2c18723cULL, 0x000fe40000041818ULL, 0x0000008e002a7306ULL, 0x000ea20000205400ULL,
0x000000696800720bULL, 0x002fce0003f7d000ULL, 0x0000008f008f7306ULL, 0x000e70000020d400ULL,
0x0000008d00567306ULL, 0x000ee2000020d400ULL, 0x0000002a5700720bULL, 0x004fce0003fdd000ULL,
0x0000008e008e7306ULL, 0x000ea2000020d400ULL, 0x000000018f8f1812ULL, 0x002fe400078efcffULL,
0x000000044b00780cULL, 0x000fe40003f25270ULL, 0x0000008f608f723eULL, 0x000fe400000010ffULL,
0x0000000156563812ULL, 0x008fc800078efcffULL, 0x000000565d5d723eULL, 0x000fe400000010ffULL,
0x000000018e8e6812ULL, 0x004fca00078efcffULL, 0x0000005c2c14723cULL, 0x000fe20000041814ULL,
0x000000498e8e723eULL, 0x000fce00000010ffULL, 0x0000008e2c10723cULL, 0x000fe20000041810ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe12000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff437224ULL, 0x000fe200078e0041ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd25000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003d287f8cULL, 0x000fe2000c80043fULL, 0x000000243c247220ULL, 0x040fe40000410000ULL,
0x000000253c257220ULL, 0x040fe20000410000ULL, 0x000004003d2b7984ULL, 0x000e620000000800ULL,
0x000000203c207220ULL, 0x040fe40000410000ULL, 0x0000000e3c2a7220ULL, 0x040fe40000410000ULL,
0x000000263c267220ULL, 0x000fc40000410000ULL, 0x000000273c277220ULL, 0x040fe40000410000ULL,
0x000000213c217220ULL, 0x040fe40000410000ULL, 0x0000000f3c2c7220ULL, 0x040fe40000410000ULL,
0x000000223c2d7220ULL, 0x040fe40000410000ULL, 0x000000233c2e7220ULL, 0x040fe40000410000ULL,
0x0000001e3c2f7220ULL, 0x000fc40000410000ULL, 0x0000001a3c317220ULL, 0x040fe40000410000ULL,
0x0000000c3c0c7220ULL, 0x040fe40000410000ULL, 0x0000000d3c0d7220ULL, 0x040fe40000410000ULL,
0x000000083c087220ULL, 0x040fe40000410000ULL, 0x000000093c097220ULL, 0x040fe40000410000ULL,
0x0000000a3c0a7220ULL, 0x000fc40000410000ULL, 0x0000000b3c0b7220ULL, 0x040fe40000410000ULL,
0x0000001c3c1c7220ULL, 0x040fe40000410000ULL, 0x0000001d3c1d7220ULL, 0x040fe40000410000ULL,
0x0000001f3c307220ULL, 0x040fe40000410000ULL, 0x0000001b3c327220ULL, 0x040fe20000410000ULL,
0x800000002bff7812ULL, 0x002fe20007804829ULL, 0x000000143c1a7220ULL, 0x000fc40000410000ULL,
0x000000163c337220ULL, 0x040fe40000410000ULL, 0x000000173c347220ULL, 0x040fe40000410000ULL,
0x000000123c357220ULL, 0x040fe40000410000ULL, 0x000000133c367220ULL, 0x040fe40000410000ULL,
0x000000153c1b7220ULL, 0x000fe40000410000ULL, 0x000000ffff127224ULL, 0x000fc400078e0024ULL,
0x000000ffff137224ULL, 0x000fe400078e0025ULL, 0x000000ffff147224ULL, 0x000fe400078e0020ULL,
0x000000ffff157224ULL, 0x000fe400078e0021ULL, 0x000000ffff207224ULL, 0x000fe400078e002aULL,
0x000000ffff247224ULL, 0x000fe400078e0026ULL, 0x000000ffff257224ULL, 0x000fc400078e0027ULL,
0x000000103c1e7220ULL, 0x040fe40000410000ULL, 0x000000113c1f7220ULL, 0x000fe40000410000ULL,
0x000000ffff217224ULL, 0x000fe400078e002cULL, 0x000000ffff267224ULL, 0x000fe400078e002dULL,
0x000000ffff277224ULL, 0x000fe400078e002eULL, 0x000000ffff2a7224ULL, 0x000fc400078e002fULL,
0x000000183c187220ULL, 0x040fe40000410000ULL, 0x000000193c197220ULL, 0x000fe40000410000ULL,
0x000000ffff0f7224ULL, 0x000fe400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff107224ULL, 0x000fe400078e0008ULL, 0x000000ffff117224ULL, 0x000fc400078e0009ULL,
0x000000ffff167224ULL, 0x000fe400078e001cULL, 0x000000ffff177224ULL, 0x000fe400078e001dULL,
0x000000ffff227224ULL, 0x000fe400078e000aULL, 0x000000ffff237224ULL, 0x000fe400078e000bULL,
0x000000ffff2b7224ULL, 0x000fe400078e0030ULL, 0x000000ffff2c7224ULL, 0x000fc400078e0031ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0032ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0033ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0034ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff307224ULL, 0x000fe400078e0035ULL,
0x000000ffff317224ULL, 0x000fe200078e0036ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x0000000800097305ULL, 0x0002a4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x000000090000735dULL, 0x004fe40003800000ULL,
0x000004003d097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004021d7824ULL, 0x000fe200078e00ffULL,
0x000000400500720cULL, 0x000fc80003f05270ULL, 0xfffffff01d097812ULL, 0x000fca00078ec0ffULL,
0x00000080001c7824ULL, 0x000fca00078e0209ULL, 0x00f400001c087984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002020c7824ULL, 0x000fe400078e00ffULL,
0x0000000103427824ULL, 0x000fc600078e0a42ULL, 0x000000060c0d7812ULL, 0x000fc800078ec0ffULL,
0x000000010d297812ULL, 0x040fe400078efcffULL, 0x000000080d337812ULL, 0x000fe400078efcffULL,
0x000000422900720cULL, 0x080fe40003f26070ULL, 0x000000100d297812ULL, 0x000fe400078efcffULL,
0x000000423300720cULL, 0x080fe40003f06070ULL, 0x000000422900720cULL, 0x000fc40003fc6070ULL,
0x000000110d337812ULL, 0x040fe400078efcffULL, 0x000000180d297812ULL, 0x040fe400078efcffULL,
0x000000420d00720cULL, 0x080fe40003f46070ULL, 0x000000423300720cULL, 0x080fe40003fa6070ULL,
0x000000422900720cULL, 0x000fe40003f66070ULL, 0x000000090d357812ULL, 0x000fc400078efcffULL,
0x000000190d337812ULL, 0x040fe400078efcffULL, 0x000000200d297812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40005000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40004800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40004800000ULL,
0x000000423500720cULL, 0x080fe40003f86070ULL, 0x000000423300720cULL, 0x080fe40003f46070ULL,
0x000000422900720cULL, 0x000fe40003f26070ULL, 0x000000210d337812ULL, 0x040fe400078efcffULL,
0x000000280d297812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fc40004000000ULL,
0xff7fffff10107808ULL, 0x000fe40004000000ULL, 0xff7fffff23237808ULL, 0x000fe40006000000ULL,
0xff7fffff11117808ULL, 0x000fe40006000000ULL, 0x000000423300720cULL, 0x080fe40003f06070ULL,
0x000000422900720cULL, 0x000fe40003f86070ULL, 0x000000290d337812ULL, 0x000fc400078efcffULL,
0x000000300d297812ULL, 0x000fe400078efcffULL, 0xff7fffff24247808ULL, 0x000fe40007000000ULL,
0xff7fffff12127808ULL, 0x000fe40007000000ULL, 0xff7fffff25257808ULL, 0x000fe40006800000ULL,
0xff7fffff13137808ULL, 0x000fe40006800000ULL, 0x000000423300720cULL, 0x000fc40003fc6070ULL,
0x000000422900720cULL, 0x000fe40003fa6070ULL, 0x000000310d337812ULL, 0x040fe400078efcffULL,
0x000000380d297812ULL, 0x040fe400078efcffULL, 0x000000390d0d7812ULL, 0x000fe400078efcffULL,
0xff7fffff26267808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005800000ULL,
0xff7fffff27277808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff16167808ULL, 0x000fe40004800000ULL,
0x000000423300720cULL, 0x080fe40003f66070ULL, 0x000000422900720cULL, 0x000fc40003f46070ULL,
0x000000420d00720cULL, 0x000fe40003f26070ULL, 0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL,
0xff7fffff17177808ULL, 0x000fe40004000000ULL, 0xff7fffff2c2c7808ULL, 0x000fe40006000000ULL,
0xff7fffff18187808ULL, 0x000fe40006000000ULL, 0xff7fffff2d2d7808ULL, 0x000fc40007000000ULL,
0xff7fffff19197808ULL, 0x000fe40007000000ULL, 0xff7fffff2e2e7808ULL, 0x000fe40006800000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40005800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL, 0xff7fffff30307808ULL, 0x000fc40005000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL, 0xff7fffff31317808ULL, 0x000fe40004800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL, 0x0000000f080d7209ULL, 0x004fe40007810000ULL,
0x0000002009087209ULL, 0x000fe40007810000ULL, 0x0000000e0d0d7209ULL, 0x000fe40007810000ULL,
0x0000002108097209ULL, 0x000fc40007810000ULL, 0x000000100d087209ULL, 0x000fe40007810000ULL,
0x00000022090c7209ULL, 0x000fe40007810000ULL, 0x0000001108097209ULL, 0x000fe40007810000ULL,
0x000000230c0d7209ULL, 0x000fe40007810000ULL, 0x0000001209087209ULL, 0x000fe40007810000ULL,
0x000000240d0c7209ULL, 0x000fc40007810000ULL, 0x0000001308097209ULL, 0x000fe40007810000ULL,
0x000000250c0d7209ULL, 0x000fe40007810000ULL, 0x0000001409087209ULL, 0x000fe40007810000ULL,
0x000000260d0c7209ULL, 0x000fe40007810000ULL, 0x0000001508097209ULL, 0x000fe40007810000ULL,
0x000000270c0d7209ULL, 0x000fc40007810000ULL, 0x0000001609087209ULL, 0x000fe40007810000ULL,
0x0000002a0d0c7209ULL, 0x000fe40007810000ULL, 0x0000001708097209ULL, 0x000fe40007810000ULL,
0x0000002b0c0d7209ULL, 0x000fe40007810000ULL, 0x0000001809087209ULL, 0x000fe40007810000ULL,
0x0000002c0d0c7209ULL, 0x000fc40007810000ULL, 0x0000001908097209ULL, 0x000fe40007810000ULL,
0x0000002d0c0d7209ULL, 0x000fe40007810000ULL, 0x0000001a09087209ULL, 0x000fe40007810000ULL,
0x0000002e0d0c7209ULL, 0x000fe40007810000ULL, 0x0000001b08097209ULL, 0x000fe40007810000ULL,
0x0000002f0c0d7209ULL, 0x000fc40007810000ULL, 0x0000001e09087209ULL, 0x000fe40007810000ULL,
0x000000300d0c7209ULL, 0x000fe40007810000ULL, 0x0000001f08097209ULL, 0x000fe40007810000ULL,
0x000000310c337209ULL, 0x000fe20007810000ULL, 0x000018627f007947ULL, 0x000fea000b800000ULL,
0x0c401f0009087f89ULL, 0x0004e400000e0000ULL, 0x0000000809347209ULL, 0x008fe20007810000ULL,
0x000018b27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0033087f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a097f89ULL, 0x004ea800000e0000ULL, 0x0c401f000b287f89ULL, 0x000f2200000e0000ULL,
0x00000008330c7209ULL, 0x008fc60007810000ULL, 0x0c201f0034087f89ULL, 0x000ee200000e0000ULL,
0x000000090a0d7209ULL, 0x004fc60007810000ULL, 0x0c201f000c097f89ULL, 0x000ea200000e0000ULL,
0x000000280b287209ULL, 0x010fc60007810000ULL, 0x0c201f000d327f89ULL, 0x002e6800000e0000ULL,
0x0c201f0028297f89ULL, 0x00092200000e0000ULL, 0x0000000834087209ULL, 0x008fe40007810000ULL,
0x000000090c097209ULL, 0x004fe40007810000ULL, 0x000000320d0a7209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b080b7820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fc40000000000ULL,
0x00000004ff337e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe2000001080bULL, 0x0000000000057886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL,
0x0000000f000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b11117823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b12127823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b13137823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001080bULL, 0x0000000e000d7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b15157823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b16167823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b17177823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001080bULL,
0x0000001000107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b19197823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080bULL, 0x0000001100117308ULL, 0x000e620000000800ULL,
0x3fb8aa3b1f0b7823ULL, 0x000fe2000001080bULL, 0x0000000c0d0c723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b091f7820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001081fULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b22227823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b23237823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001081fULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x00000010110e723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b25257823ULL, 0x000fc4000001081fULL,
0x3fb8aa3b26267823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b27277823ULL, 0x100fe4000001081fULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081fULL, 0x00000022000f7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b2e2e7823ULL, 0x000fc4000001081fULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b30307823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b311f7823ULL, 0x000fe2000001081fULL,
0x0000002300327308ULL, 0x0008a20000000800ULL, 0x3f8000003322783eULL, 0x008fe400000010ffULL,
0x00000020210d723eULL, 0x002fca00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x000000ffff237224ULL, 0x010fe200078e0022ULL, 0x0000000f320f723eULL, 0x004fcc00000010ffULL,
0x0000001400147308ULL, 0x000fe20000000800ULL, 0x000000220c34723cULL, 0x000fe200000418ffULL,
0x000000121310723eULL, 0x002fcc00000010ffULL, 0x0000001500157308ULL, 0x000e700000000800ULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x000000141512723eULL, 0x002fce00000010ffULL, 0x0000002600267308ULL, 0x000ff00000000800ULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x000000242511723eULL, 0x004fce00000010ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000262713723eULL, 0x002fce00000010ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000221034723cULL, 0x000fee0000041834ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000001900197308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000010ffULL, 0x0000002a002a7308ULL, 0x000ff00000000800ULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x000000181916723eULL, 0x004fe200000010ffULL,
0x0000000fff197424ULL, 0x000fe200078e00ffULL, 0xfffffffc02187812ULL, 0x000fc800078ec0ffULL,
0x0000001819247219ULL, 0x000fe200000006ffULL, 0x0000002c002c7308ULL, 0x000fe60000000800ULL,
0x00000000242173a1ULL, 0x000ea200000e8000ULL, 0x00000000240473c4ULL, 0x000ee80000004000ULL,
0x0000002d002d7308ULL, 0x000f220000000800ULL, 0x0000002a2b15723eULL, 0x002fce00000010ffULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x0000002c2d17723eULL, 0x010fce00000010ffULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000000524ff7c12ULL, 0x004fe2000f804021ULL,
0x000000221434723cULL, 0x000fec0000041834ULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x0000000b000b7308ULL, 0x000ea20000000800ULL, 0x0000001a1b18723eULL, 0x002fce00000010ffULL,
0x0000002e002e7308ULL, 0x000ff00000000800ULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x0000001e0b1a723eULL, 0x004fe400000010ffULL, 0x00000028290b7209ULL, 0x000fca0007810000ULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000001f001f7308ULL, 0x000ea20000000800ULL,
0x0000002e2f19723eULL, 0x002fe400000010ffULL, 0x000000301f1b723eULL, 0x004fce00000010ffULL,
0x00000022182c723cULL, 0x000fe20000041834ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x000014a204008947ULL, 0x008fde000b800000ULL, 0x001c1fff2c207589ULL, 0x0002a400000e0000ULL,
0x00000000241f73a1ULL, 0x000ee200000e8000ULL, 0x00000000240473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x0000000524ff7c12ULL, 0x008fda000f80401fULL,
0x000014c204008947ULL, 0x010fea000b800000ULL, 0x001c1fff2e217589ULL, 0x00072800000e0000ULL,
0x001c1fff01227589ULL, 0x00066800000e0000ULL, 0x001c1fff23237589ULL, 0x0006a400000e0000ULL,
0x00000002ff1e7819ULL, 0x000fe40000011602ULL, 0x0000000c1d437812ULL, 0x000fc400078ec0ffULL,
0x000000071e1f7812ULL, 0x040fe200078ec0ffULL, 0x000000081e287824ULL, 0x040fe200078e00ffULL,
0x0000001eff267212ULL, 0x000fe200078e33ffULL, 0x000000081e247824ULL, 0x00afe200078e00ffULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x000000081e337824ULL, 0x040fe200078e00ffULL,
0x000000081e1e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff828257812ULL, 0x100fe400078ee21fULL,
0x0000000124277812ULL, 0x100fe200078ef61fULL, 0x000000081e4f7824ULL, 0x000fe200078e00ffULL,
0x0000000224297812ULL, 0x100fe200078ef61fULL, 0x000000081e287824ULL, 0x000fe200078e00ffULL,
0x00000003242b7812ULL, 0x000fc400078ef61fULL, 0x00000004242d7812ULL, 0x140fe400078ef61fULL,
0x00000005242f7812ULL, 0x140fe400078ef61fULL, 0x0000000624317812ULL, 0x000fe200078ef61fULL,
0x000000081e247824ULL, 0x040fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe400078ee226ULL,
0x0000001eff267212ULL, 0x000fe400078e33ffULL, 0x000000071e1f7812ULL, 0x000fc400078ec0ffULL,
0x00009000001e7811ULL, 0x000fe400078e58ffULL, 0xfffffff828357812ULL, 0x100fe400078ee21fULL,
0x0000000124377812ULL, 0x140fe200078ef61fULL, 0x00000010251d7824ULL, 0x100fe200078e021eULL,
0x0000000224457812ULL, 0x140fe200078ef61fULL, 0x000000102d287824ULL, 0x100fe200078e021eULL,
0x0000000324477812ULL, 0x040fe200078ef61fULL, 0x00000001431d7824ULL, 0x000fe200078e021dULL,
0x0000000424497812ULL, 0x140fe200078ef61fULL, 0x000000102f2a7824ULL, 0x100fe200078e021eULL,
0x00000005244b7812ULL, 0x140fe200078ef61fULL, 0x00000010312c7824ULL, 0x100fe200078e021eULL,
0x00000006244d7812ULL, 0x000fe200078ef61fULL, 0x00000010271f7824ULL, 0x000fe200078e021eULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee226ULL, 0x0000001029247824ULL, 0x100fe200078e021eULL,
0x0000000c1d007388ULL, 0x0003e20000000800ULL, 0x000000102b267824ULL, 0x000fc400078e021eULL,
0x00000001431f7824ULL, 0x040fe400078e021fULL, 0x0000000143257824ULL, 0x000fe400078e0224ULL,
0x00000010332e7824ULL, 0x000fe200078e021eULL, 0x0000000e1f007388ULL, 0x0007e20000000800ULL,
0x0000000143277824ULL, 0x000fe400078e0226ULL, 0x0000001035307824ULL, 0x000fe200078e021eULL,
0x0000001025007388ULL, 0x0007e20000000800ULL, 0x0000000143297824ULL, 0x000fc400078e0228ULL,
0x0000001037317824ULL, 0x000fe200078e021eULL, 0x0000001227007388ULL, 0x0007e20000000800ULL,
0x00000001432b7824ULL, 0x000fe400078e022aULL, 0x0000001045327824ULL, 0x000fe200078e021eULL,
0x0000001429007388ULL, 0x0007e20000000800ULL, 0x00000001432d7824ULL, 0x000fe400078e022cULL,
0x0000001047337824ULL, 0x000fe200078e021eULL, 0x000000162b007388ULL, 0x0007e20000000800ULL,
0x00000001432f7824ULL, 0x000fc400078e022eULL, 0x0000001049347824ULL, 0x100fe200078e021eULL,
0x000000182d007388ULL, 0x0007e20000000800ULL, 0x000000104b357824ULL, 0x100fe400078e021eULL,
0x000000104d367824ULL, 0x100fe200078e021eULL, 0x0000001a2f007388ULL, 0x0007e20000000800ULL,
0x000000104f377824ULL, 0x000fe400078e021eULL, 0x0000000143307824ULL, 0x040fe400078e0230ULL,
0x00000001431e7824ULL, 0x000fc400078e0231ULL, 0x0000000143327824ULL, 0x040fe200078e0232ULL,
0x0000000d30007388ULL, 0x0007e20000000800ULL, 0x00000001430c7824ULL, 0x042fe400078e0233ULL,
0x0000000143347824ULL, 0x040fe200078e0234ULL, 0x0000000f1e007388ULL, 0x0007e20000000800ULL,
0x0000000143247824ULL, 0x040fe400078e0235ULL, 0x0000000143367824ULL, 0x040fe200078e0236ULL,
0x0000001132007388ULL, 0x0007e20000000800ULL, 0x0000000143267824ULL, 0x000fc600078e0237ULL,
0x000000130c007388ULL, 0x0007e80000000800ULL, 0x0000001534007388ULL, 0x0007e80000000800ULL,
0x0000001724007388ULL, 0x0007e80000000800ULL, 0x0000001936007388ULL, 0x0007e80000000800ULL,
0x0000001b26007388ULL, 0x0007e80000000800ULL, 0x00f000081c008388ULL, 0x0007e80000000c00ULL,
0x00f200201c008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003fff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008003fff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010003fff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030005057a10ULL, 0x000fe20007ffe0ffULL, 0x000018003fff7f8cULL, 0x0003e6000c80043fULL,
0x000000060500720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffb6c000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff307807ULL, 0x010fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x0001648000337802ULL, 0x000fe40000000f00ULL, 0x000010a000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff137224ULL, 0x000fe200078e0032ULL, 0xfffeb62000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x000fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x000164e000337802ULL, 0x000fe40000000f00ULL, 0x0000104000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff137224ULL, 0x000fe200078e0032ULL, 0xfffeb64000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0013ULL, 0x0001655000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000f9000007944ULL, 0x03efea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0032ULL,
0xfffeb69000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x002fe200078e0013ULL,
0x000165c000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x00000f2000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0032ULL, 0xfffeb65000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0014ULL, 0x0001663000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x00000eb000007944ULL, 0x020fea0003c00000ULL, 0x000000ffffbf7224ULL, 0x004fe200078e0032ULL,
0xfffeb9b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x002fe200078e002cULL,
0x000166a000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000e4000007944ULL, 0x024fea0003c00000ULL,
0x000000ffffbc7224ULL, 0x004fe200078e0032ULL, 0xfffeb97000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x010fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x0001670000337802ULL, 0x000fc40000000f00ULL, 0x00000e2000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff137224ULL, 0x000fe200078e0032ULL, 0xfffee3e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x000fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x0001676000337802ULL, 0x000fc40000000f00ULL, 0x00000dc000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff137224ULL, 0x000fe200078e0032ULL, 0xfffee41000007947ULL, 0x000fea000383ffffULL,
0x0000001fff357424ULL, 0x008fe200078e00ffULL, 0x000167c000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000d2000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0032ULL, 0xfffee48000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x00afe200078e002cULL, 0x0001683000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x00000cb000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0032ULL,
0xfffee53000007947ULL, 0x000fea000383ffffULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x0001689000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x00000c5000007944ULL, 0x024fea0003c00000ULL, 0x000000ffffc97224ULL, 0x004fe200078e0032ULL,
0xfffee7f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x002fe200078e002cULL,
0x0001690000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x00000be000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff927224ULL, 0x004fe200078e0032ULL, 0xfffee7a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x002fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x0001696000337802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0032ULL, 0xffff0f2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x000fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x000169c000337802ULL, 0x000fc40000000f00ULL, 0x00000b6000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0032ULL, 0xffff0f5000007947ULL, 0x000fea000383ffffULL,
0x0000001fff357424ULL, 0x002fe200078e00ffULL, 0x00016a2000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000ac000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0032ULL, 0xffff0fc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x002fe200078e002cULL, 0x00016a9000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x00000a5000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0032ULL,
0xffff107000007947ULL, 0x000fea000383ffffULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x00016af000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x000009f000007944ULL, 0x030fea0003c00000ULL, 0x000000ffffb37224ULL, 0x004fe200078e0032ULL,
0xffff132000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x002fe200078e002cULL,
0x00016b6000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000098000007944ULL, 0x034fea0003c00000ULL,
0x000000ffffb27224ULL, 0x004fe200078e0032ULL, 0xffff12d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x010fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x00016bc000337802ULL, 0x000fc40000000f00ULL, 0x0000096000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0032ULL, 0xffff3a4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x000fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x00016c2000337802ULL, 0x000fc40000000f00ULL, 0x0000090000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0032ULL, 0xffff3a7000007947ULL, 0x000fea000383ffffULL,
0x0000001fff357424ULL, 0x008fe200078e00ffULL, 0x00016c8000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000086000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0032ULL, 0xffff3ae000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x00afe200078e002cULL, 0x00016cf000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x000007f000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0032ULL,
0xffff3b9000007947ULL, 0x000fea000383ffffULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x00016d5000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000079000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff937224ULL, 0x004fe200078e0032ULL,
0xffff3e5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x002fe200078e002cULL,
0x00016dc000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000072000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff947224ULL, 0x004fe200078e0032ULL, 0xffff3e0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff297224ULL, 0x000fe200078e0009ULL, 0x00016e40000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x000fc400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000066000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0029ULL, 0xffffe73000007947ULL, 0x000fea000383ffffULL,
0x000000ffff297224ULL, 0x000fe200078e0033ULL, 0x00016ec0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x000005e000007944ULL, 0x024fea0003c00000ULL,
0x0000002933367209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e000aULL,
0x00016f30000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0000057000007944ULL, 0x000fea0003c00000ULL, 0x000000290a0a7209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e000bULL, 0x00016fa0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000050000007944ULL, 0x000fea0003c00000ULL,
0x000000290b287209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e0034ULL,
0x00017010000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x0000002934087209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e0036ULL, 0x00017080000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x0000002936097209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e000aULL,
0x000170f0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x000003b000007944ULL, 0x000fea0003c00000ULL, 0x000000290a0a7209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e0028ULL, 0x00017160000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0xffffe51000007947ULL, 0x000fea000383ffffULL, 0x000000ffff337224ULL, 0x000fe200078e002cULL,
0x000171d000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fc400078e00ffULL,
0x00001c1fff357424ULL, 0x000fe400078e00ffULL, 0x000000ffff367224ULL, 0x000fe400078e0024ULL,
0x0000031000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e0032ULL,
0xffffeaf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff337224ULL, 0x002fe200078e002eULL,
0x0001725000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fe400078e00ffULL,
0x00001c1fff357424ULL, 0x000fe400078e00ffULL, 0x000000ffff367224ULL, 0x000fe400078e0024ULL,
0x0000029000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff347224ULL, 0x002fe200078e00ffULL,
0x000172b000307802ULL, 0x000fe20000000f00ULL, 0x00001c1fff357424ULL, 0x000fc400078e00ffULL,
0x000000ffff367224ULL, 0x000fe400078e0024ULL, 0x000000ffff217224ULL, 0x004fe400078e0032ULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff367224ULL, 0x002fe200078e0024ULL,
0x0001731000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fe400078e00ffULL,
0x00001c1fff357424ULL, 0x000fe400078e00ffULL, 0x000000ffff227224ULL, 0x004fe400078e0032ULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff237224ULL, 0x004fe200078e0032ULL,
0xffffea3000007947ULL, 0x000fea000383ffffULL, 0x0180000006037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003097812ULL, 0x000fc800078ec0ffULL,
0x018000000900780cULL, 0x000fda0003f05070ULL, 0x0000000600038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0900720cULL, 0x040fe40003f25070ULL,
0x008000000900780cULL, 0x000fe40003f02070ULL, 0x00000001ff0a7807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x000000030aff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000006067812ULL, 0x002fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x000000030aff7212ULL, 0x000fda000780c0ffULL, 0x0080000006030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0006ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000600037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffe8b6008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000004200007348ULL, 0x000fe80003800000ULL,
0x0c00003229297389ULL, 0x0002a200000e0035ULL, 0xfffe8b200c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff317424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0000003433327389ULL, 0x0002a200000e0035ULL, 0xfffe8ae030007950ULL, 0x000fea0003c3ffffULL,
0x000000013000780cULL, 0x000fe20003f05070ULL, 0x0000003100007348ULL, 0x000fd80003800000ULL,
0x0000000000307806ULL, 0x000fc800040e0100ULL, 0x0000003130327212ULL, 0x000fe200078ec0ffULL,
0x000000ffff307224ULL, 0x000fe400078e0033ULL, 0x00000000ff317424ULL, 0x000fc800078e00ffULL,
0xfffe8a7030007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000538ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000b18ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ba8ULL, 0x0000000000000884ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000142cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001450ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001460ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001480ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001510ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001518ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001528ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001700ULL, 0x0000000000017680ULL, 0xff00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018d80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000018d90ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018d90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000019210ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001510ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000017870ULL, 0x0000000000017870ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000018d80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000019210ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin_len = 103152;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
