/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000012578ULL, 0x00000000000120f8ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000011080ULL, 0x0000000000000200ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000011280ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001108000000000ULL, 0x0000480400000000ULL, 0x0400288080810c00ULL, 0x00000000000043ccULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080860828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808692ULL, 0x0000001cffffffffULL, 0x0000006800000000ULL, 0x0001108000000000ULL,
0x0000020000000000ULL, 0x0000000000000000ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x0001030000103104ULL, 0x0001032000010310ULL, 0x00bc290400010330ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001e0500001fULL,
0x0500001f0500001eULL, 0x0500001f0500001fULL, 0x0500003c0500003cULL, 0x0500003c0500003cULL,
0x0500003c0500003cULL, 0x0500003c0500003cULL, 0x0500003c0500003cULL, 0x00bc28040500003cULL,
0x000000f0000000b0ULL, 0x00002130000020a0ULL, 0x000021c0000021a0ULL, 0x000026d000002580ULL,
0x00004cc000004c40ULL, 0x00004d7000004d30ULL, 0x000051c0000051a0ULL, 0x000070e0000070c0ULL,
0x0000746000007450ULL, 0x00009a30000099f0ULL, 0x0000a0d00000a0a0ULL, 0x0000fc200000fc10ULL,
0x0000fc400000fc30ULL, 0x0000fc900000fc70ULL, 0x0000fcc00000fcb0ULL, 0x00010310000102f0ULL,
0x0001036000010320ULL, 0x0001038000010370ULL, 0x00010c2000010b90ULL, 0x00010ce000010c80ULL,
0x00010db000010d50ULL, 0x00010e7000010e10ULL, 0x00010fa000010f00ULL, 0x0270390400011040ULL,
0x000000ff00000170ULL, 0x000401000001b600ULL, 0x0000000300000250ULL, 0x003f01000001b608ULL,
0x00000003000002c0ULL, 0x003f01000001b610ULL, 0x00000003000004a0ULL, 0x003f01000001b648ULL,
0x00000002000005b0ULL, 0x003f01000001b668ULL, 0x000000ff000008a0ULL, 0x000401070001b600ULL,
0x0000000300000a60ULL, 0x003f01010001b610ULL, 0x000000ff00001370ULL, 0x0009010700000000ULL,
0x00000009000013a0ULL, 0x003f010100000020ULL, 0x0000000900001760ULL, 0x003f010600000020ULL,
0x0000000900001a10ULL, 0x003f010a00000020ULL, 0x0000003100001e70ULL, 0x0009010700000000ULL,
0x0000002d00001f30ULL, 0x0009010600000000ULL, 0x0000002900001f80ULL, 0x003f010a0001b608ULL,
0x0000002d00002450ULL, 0x0009010a00000000ULL, 0x0000000900004400ULL, 0x003f010100000020ULL,
0x0000005500004420ULL, 0x003f01010001b610ULL, 0x0000000900004510ULL, 0x003f010600000020ULL,
0x0000000900004900ULL, 0x003f010a00000020ULL, 0x000000ff00004b00ULL, 0x000c010700000000ULL,
0x0000003100004b60ULL, 0x0009010600000000ULL, 0x000000ff00004bb0ULL, 0x0009010affffffe0ULL,
0x0000003100004fe0ULL, 0x0009010a00000000ULL, 0x00000009000069a0ULL, 0x003f010100000020ULL,
0x00000055000069e0ULL, 0x003f01010001b630ULL, 0x000000080000c610ULL, 0x003f010a0001b600ULL,
0x000000080000c7f0ULL, 0x003f01010001b600ULL, 0x000000080000c810ULL, 0x003f010a0001b600ULL,
0x000000090000f3c0ULL, 0x003f010a0001b610ULL, 0x0000000900010680ULL, 0x003f01010001b608ULL,
0x00000009000106d0ULL, 0x003f010a00000020ULL, 0x0000002900010750ULL, 0x003f010a0001b608ULL,
0x00000029000107e0ULL, 0x003f010a00000000ULL, 0x0000000900010850ULL, 0x003f010a00000020ULL,
0x00000027000108e0ULL, 0x003f010affffffe0ULL, 0x0000002700010970ULL, 0x003f010a00000000ULL,
0x00000008000109d0ULL, 0x003f010a0001b600ULL, 0x0000000800010a50ULL, 0x003f010a0001b600ULL,
0x0000000900010ad0ULL, 0x003f010a0001b610ULL, 0x00141c0400053803ULL, 0x0000ab500000a6f0ULL,
0x0000c8d00000c830ULL, 0x000c0504000106b0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0058190300000000ULL, 0x0000000f00080a04ULL, 0x0004360400580210ULL, 0x0000000000000008ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x0000000000000000ULL, 0x00000000000000c4ULL, 0x0000000e00000002ULL,
0x0000000000011080ULL, 0x0000000000000044ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL,
0x00000000000000a0ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL, 0x0000004043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000097919ULL, 0x000eae0000002300ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x0000000000027919ULL, 0x000ea20000002200ULL, 0x0000000000037919ULL, 0x000f2a0000002100ULL,
0x00000300ff007b82ULL, 0x000f620000000800ULL, 0x00000000000b7919ULL, 0x000f6e0000002700ULL,
0x00000000000779c3ULL, 0x000f620000002600ULL, 0x00000004ff517e24ULL, 0x008fc4000f8e00ffULL,
0x0000000109027824ULL, 0x004fe400078e0202ULL, 0x00001fff09097589ULL, 0x000ea400000e0000ULL,
0x0000008002027824ULL, 0x110fe200078e0203ULL, 0x00000005ff537819ULL, 0x000fc80000011603ULL,
0x000000ff0200720cULL, 0x040fe40003f05270ULL, 0x00001fff53537589ULL, 0x000ee200000e0000ULL,
0x000000030200780cULL, 0x000fd40003f44070ULL, 0x0000000000240947ULL, 0x022fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01b60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001a000007945ULL, 0x000fe80003800000ULL, 0x0000000000602947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7fff000000057882ULL, 0x000fc60000000000ULL, 0x0000000402037c11ULL, 0x000fe2000f8e20ffULL,
0x001fffc000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000030612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f640000000000ULL,
0x01b60804063f75b2ULL, 0x0103700008000100ULL, 0xfffffffd00e81947ULL, 0x020fea000393ffffULL,
0x0000000000007918ULL, 0x010fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x001fff8000047882ULL, 0x002fe20000000000ULL, 0x7ffe000000057882ULL, 0x000fd60000000000ULL,
0x00000000030612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f640000000000ULL,
0x01b61004063f75b2ULL, 0x0103700008000100ULL, 0xfffffffd00e81947ULL, 0x020fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000007f0200780cULL, 0x040fe20003f04070ULL,
0x00008e00ff067b82ULL, 0x000f620000000a00ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x000000010200780cULL, 0x000fe40003f84070ULL, 0x000000ff0900720cULL, 0x004fd00003f65270ULL,
0x0000000000048919ULL, 0x000ea20000008800ULL, 0x0000040000038802ULL, 0x000fc80000000f00ULL,
0x0000065404038816ULL, 0x004fe20000000003ULL, 0xff317217ff048424ULL, 0x000fc800078e00ffULL,
0x0000000402038824ULL, 0x000fca00078e0203ULL, 0x01b4000403008388ULL, 0x0005e20000000800ULL,
0x0000000000382947ULL, 0x022fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402037c11ULL, 0x004fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x010fca0000000000ULL, 0x00000000030612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000f240000000000ULL, 0x01b64804063f75b2ULL, 0x0043300008000100ULL,
0xfffffffd00e81947ULL, 0x010fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000402027c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x014fca0000000000ULL,
0x00000000020612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f240000000000ULL,
0x01b66804063f75b2ULL, 0x0043300008000100ULL, 0xfffffffd00e81947ULL, 0x010fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00008400ff087b82ULL, 0x000e620000000800ULL,
0x00008200000e7ab9ULL, 0x000fe20000000a00ULL, 0x000000040b067825ULL, 0x000fcc00078e0006ULL,
0x0000000000007b1dULL, 0x014fec0000010000ULL, 0x0000000000983947ULL, 0x000fea0003800000ULL,
0x0000000000137919ULL, 0x000ea20000000000ULL, 0x00008800ff047b82ULL, 0x000f220000000a00ULL,
0x0000000453037824ULL, 0x008fe200078e00ffULL, 0x0000000407047899ULL, 0x002fe2000800063fULL,
0x0000001008027824ULL, 0x000fca00078e00ffULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000000402027e24ULL, 0x000fe2000f8e020bULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x00000003130d7211ULL, 0x044fe200078fe0ffULL, 0x00000010130a7824ULL, 0x000fe200078e00ffULL,
0x0000065405047896ULL, 0x002fe40008000004ULL, 0x000000070d0c7812ULL, 0x040fe200078ec0ffULL,
0x000000020d0f7836ULL, 0x000fe40000000000ULL, 0x0000000102037824ULL, 0x040fe200078e020dULL,
0x0000000f0c0c7812ULL, 0x000fe200078e7813ULL, 0x0000000102117824ULL, 0x000fe200078e020fULL,
0x000000070f0e7812ULL, 0x000fe200078ec0ffULL, 0x0000010003027825ULL, 0x010fc600078e0004ULL,
0x0000000f0e0e7812ULL, 0x000fe200078e7813ULL, 0x0000010011047825ULL, 0x000fe200078e0004ULL,
0x000000f00a117812ULL, 0x000fc600078ec0ffULL, 0x000000100d0c7824ULL, 0x000fe200078e020cULL,
0x0000001102027210ULL, 0x000fe20007f1e0ffULL, 0x000000100f0e7824ULL, 0x000fe200078e020eULL,
0x0000001104047210ULL, 0x000fe40007f3e0ffULL, 0x000000040c0d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x000000040e0f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff057224ULL, 0x000fc600008e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020d7faeULL, 0x0003e8000b901c4eULL, 0x00000000040f7faeULL, 0x0003e2000b901c4eULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0001b60004047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x0000000e06067981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fe40003f05270ULL,
0x00000000061072caULL, 0x004fda00000e0000ULL, 0x0000003f10047890ULL, 0x002fe4000fffe03fULL,
0x000000ff10067890ULL, 0x000fe4000fffe03fULL, 0x000000063f057899ULL, 0x000fe40008011604ULL,
0x000000083f067899ULL, 0x000fe20008011606ULL, 0x000000a000808947ULL, 0x000ff60003800000ULL,
0x00000001ff6d7819ULL, 0x008fe20000011653ULL, 0x0000000000097919ULL, 0x000e620000008800ULL,
0x0000040000047802ULL, 0x000fe40000000f00ULL, 0x03ffffff6d027812ULL, 0x000fca00078ec0ffULL,
0x0000000451057824ULL, 0x000fca00078e0202ULL, 0x0000000505007c0cULL, 0x000fda000bf06070ULL,
0x00009000ff038b82ULL, 0x000ea20000000800ULL, 0x000000020b028824ULL, 0x000fce00078e00ffULL,
0x00008c00ff068b82ULL, 0x000ee20000000a00ULL, 0x0000000302028224ULL, 0x004fc800078e0203ULL,
0x0000000105038824ULL, 0x000fe200078e0202ULL, 0x0000065409027816ULL, 0x002fe20000000004ULL,
0xffffffffff097424ULL, 0x000fe400078e00ffULL, 0x0000000403068825ULL, 0x008fc800078e0006ULL,
0x00000002ff047424ULL, 0x000fe400078e00ffULL, 0x0000001053037824ULL, 0x000fc800078e0202ULL,
0x01b6100403ff79a7ULL, 0x0003e2000850003fULL, 0x0000000e06098981ULL, 0x0004e2000c1e1900ULL,
0x0000000305037812ULL, 0x002fca00078ec0ffULL, 0x0000000203047836ULL, 0x000fe20000000000ULL,
0xfffffffe00037811ULL, 0x000fc800078e10ffULL, 0x000000030400780cULL, 0x000fc80003f04070ULL,
0x0000000203047807ULL, 0x000fca0000000000ULL, 0x0000000105047824ULL, 0x000fca00078e0204ULL,
0x0000000504007c0cULL, 0x000fe2000bf06070ULL, 0x0000000000067919ULL, 0x004e580000000000ULL,
0x00009000ff0a8b82ULL, 0x000ea20000000800ULL, 0x000000020b058824ULL, 0x000fce00078e00ffULL,
0x00008c00ff0c8b82ULL, 0x000f220000000a00ULL, 0x00000001530f7812ULL, 0x000fe200078ec0ffULL,
0x0000000a05058224ULL, 0x004fc800078e020aULL, 0x0000000105078824ULL, 0x000fe400078e0204ULL,
0xffffffffff057424ULL, 0x000fe400078e00ffULL, 0x00000004070c8825ULL, 0x010fe200078e000cULL,
0x00000003ff0e7819ULL, 0x002fc60000011606ULL, 0x0000000151077836ULL, 0x040fe20000000000ULL,
0x0000000e0c058981ULL, 0x000362000c1e1900ULL, 0x00000004510a7824ULL, 0x000fe200078e026dULL,
0x0000000607077899ULL, 0x000fe2000800063fULL, 0x000000200f117824ULL, 0x000fe200078e00ffULL,
0x0000000607007c0cULL, 0x000fe2000bf06070ULL, 0x000000400a077824ULL, 0x000fe200078e00ffULL,
0x000000006d0972caULL, 0x000fe200000e0000ULL, 0x0000000111107824ULL, 0x000fe400078e020eULL,
0x000040006d147824ULL, 0x000fe200078e0202ULL, 0x00000010070a7c48ULL, 0x000fe2000ffe0000ULL,
0x000000040e127836ULL, 0x000fe20000000000ULL, 0x00000006100c7212ULL, 0x042fe200078e3cffULL,
0x0000000810157824ULL, 0x000fe200078e00ffULL, 0x00000000140872caULL, 0x000fe200000e0000ULL,
0x0000000111137824ULL, 0x000fc400078e0212ULL, 0x000000080e147836ULL, 0x040fe40000000000ULL,
0x0000000c0e207836ULL, 0x000fe20000000000ULL, 0x00000006130d7212ULL, 0x0c0fe200078e3cffULL,
0x000000010a0a7824ULL, 0x000fe200078e0a07ULL, 0xfffffff815077812ULL, 0x000fe200078ee20cULL,
0x00000008131e7824ULL, 0x000fe400078e00ffULL, 0x0000000111157824ULL, 0x040fe200078e0214ULL,
0x000000400a0a7807ULL, 0x000fe20000000000ULL, 0x0000000111167824ULL, 0x000fe200078e0220ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20dULL, 0x00000008151f7824ULL, 0x040fe200078e00ffULL,
0x00000006150c7212ULL, 0x080fe200078e3cffULL, 0x00000008161c7824ULL, 0x040fe200078e00ffULL,
0x00000006160d7212ULL, 0x000fe200078e3cffULL, 0x0000004008087824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee20cULL, 0x000000100e227836ULL, 0x040fe20000000000ULL,
0xfffffff81c217812ULL, 0x000fe200078ee20dULL, 0x000000140e247836ULL, 0x000fe20000000000ULL,
0x00008a00ff0c7b82ULL, 0x000e620000000a00ULL, 0x000000110a0a7248ULL, 0x000fe20007fe0000ULL,
0x000000180e277836ULL, 0x040fe20000000000ULL, 0x00013000080a7890ULL, 0x000fe2000fffe03fULL,
0x0000001c0e2a7836ULL, 0x000fc40000000000ULL, 0x0000000111187824ULL, 0x040fe400078e0222ULL,
0x00000001111a7824ULL, 0x000fe200078e0224ULL, 0x0000000a07077c11ULL, 0x000fe2000f8e20ffULL,
0x00000001111b7824ULL, 0x040fe200078e0227ULL, 0x0000000618177212ULL, 0x080fe200078e3cffULL,
0x00000001111d7824ULL, 0x000fe200078e022aULL, 0x000000061a197212ULL, 0x000fe200078e3cffULL,
0x000000010a0a7824ULL, 0x000fe200078e0a11ULL, 0x0000000a1f1f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000010062d7824ULL, 0x000fe200078e00ffULL, 0x0000000a21217c11ULL, 0x000fe2000f8e20ffULL,
0x0000000818267824ULL, 0x000fe200078e00ffULL, 0x0000000a1200720cULL, 0x000fe20003f86070ULL,
0x000000081a287824ULL, 0x000fe200078e00ffULL, 0x000000702d2d7812ULL, 0x000fe200078ec0ffULL,
0x000000081d1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff826237812ULL, 0x000fc400078ee217ULL,
0xfffffff828267812ULL, 0x000fe200078ee219ULL, 0x000000081b287824ULL, 0x000fe200078e00ffULL,
0x000000061d197212ULL, 0x080fe400078e3cffULL, 0x000000061b177212ULL, 0x000fe400078e3cffULL,
0xfffffff81c2b7812ULL, 0x000fe400078ee219ULL, 0xfffffff828287812ULL, 0x000fe400078ee217ULL,
0x0000000a1400720cULL, 0x000fc40003f66070ULL, 0x0000000a0e00720cULL, 0x000fe20003fa6070ULL,
0x0001b648020e7836ULL, 0x000fe20000000000ULL, 0x0000000a23237c11ULL, 0x000fe4000f8e20ffULL,
0x0000000a2b2b7c11ULL, 0x000fe4000f8e20ffULL, 0x000000000e0472caULL, 0x000fda00000e0000ULL,
0x0000000409097291ULL, 0x000fe2000f8e203fULL, 0x0000000708097e24ULL, 0x008fca000f8e0209ULL,
0x0000003f09117812ULL, 0x000fe400078ef810ULL, 0x0000003f09137812ULL, 0x000fe400078ef813ULL,
0x0000003f09257812ULL, 0x000fe200078ef81aULL, 0x0000008011107825ULL, 0x102fe200078e000cULL,
0x0000003f09157812ULL, 0x000fe400078ef815ULL, 0x0000003f09297812ULL, 0x000fe200078ef81bULL,
0x0000008013127825ULL, 0x000fe200078e000cULL, 0x0000002d101a7210ULL, 0x000fc40007f1e0ffULL,
0x0000003f09177812ULL, 0x000fe400078ef816ULL, 0x0000002d121c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200000e0611ULL, 0x0000003f09197812ULL, 0x000fe200078ef818ULL,
0x0000008015107825ULL, 0x000fe200078e000cULL, 0x0000003f09097812ULL, 0x000fe400078ef81dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a077faeULL, 0x0003e2000e901c4eULL,
0x000000ffff1d7224ULL, 0x000fe200008e0613ULL, 0x0000002d10107210ULL, 0x000fe20007f1e0ffULL,
0x0000008017127825ULL, 0x000fe200078e000cULL, 0x0000000a2700720cULL, 0x000fc60003fa6070ULL,
0x0000008025167825ULL, 0x100fe200078e000cULL, 0x0000002d12127210ULL, 0x000fe40007f3e0ffULL,
0x0000000a28257c11ULL, 0x000fe2000f8e20ffULL, 0x0000008019147825ULL, 0x000fe200078e000cULL,
0x0000000a261b7c11ULL, 0x002fc6000f8e20ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000002d16167210ULL, 0x000fe20007f1e0ffULL, 0x0000008029187825ULL, 0x000fe200078e000cULL,
0x0000002d14147210ULL, 0x000fc60007f5e0ffULL, 0x00000080090c7825ULL, 0x000fe200078e000cULL,
0x0000000a1e097c11ULL, 0x000fc6000f8e20ffULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0x0000002d18187210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x0000002d0c0c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200010e0615ULL,
0x0000000a2000720cULL, 0x080fe20003f46070ULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x0000000a2200720cULL, 0x080fe20003f26070ULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000000a2400720cULL, 0x080fe20003f06070ULL, 0x000000001c097faeULL, 0x0003e2000e101c4eULL,
0x0000000a2a00720cULL, 0x000fe20003f86070ULL, 0x00000001ff0a7424ULL, 0x000fc400078e00ffULL,
0x00000000101f7faeULL, 0x0005e2000d901c4eULL, 0xff317217ff077424ULL, 0x000fc600078e00ffULL,
0x0000000012217faeULL, 0x0007e8000d101c4eULL, 0x0000000014237faeULL, 0x0007e2000c901c4eULL,
0x000000086d097824ULL, 0x002fc600078e020eULL, 0x00000000161b7faeULL, 0x0007e2000c101c4eULL,
0x0000000651007c0cULL, 0x000fc6000bf06070ULL, 0x0000000018257faeULL, 0x0007e8000e901c4eULL,
0x000000000c2b7faeULL, 0x0007e2000e101c4eULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a49ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x0000200a09ff79a7ULL, 0x0003e2000850003fULL, 0x0000000000227805ULL, 0x008fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fc4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0a7224ULL, 0x002fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fc4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000005800740947ULL, 0x000fec0003800000ULL, 0x00009000ff0c7b82ULL, 0x000e620000000800ULL,
0x000000020b0d7824ULL, 0x000fe200078e00ffULL, 0x00007610ff697816ULL, 0x000fe20000000069ULL,
0xff317217ff077424ULL, 0x000fe200078e00ffULL, 0x00007610ff687816ULL, 0x000fe20000000068ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0xfffe49b809117890ULL, 0x000fe2000fffe03fULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x0000000c0d0d7224ULL, 0x102fe200078e020cULL,
0x00007610ff0c7816ULL, 0x000fd2000000000cULL, 0x0000002053667824ULL, 0x000fca00078e00ffULL,
0xffffffc0660e7812ULL, 0x000fca00078ec0ffULL, 0x00000100510e7824ULL, 0x000fca00078e020eULL,
0x000000100e007c0cULL, 0x000fda000bf06070ULL, 0x0000005800240947ULL, 0x000fea0003800000ULL,
0x000000800e3c7836ULL, 0x000fe20000000000ULL, 0x00000003040e7812ULL, 0x000fe200078ec0ffULL,
0x00008a00ff707b82ULL, 0x000e620000000a00ULL, 0x0000002066667812ULL, 0x000fe200078ec0ffULL,
0x0000000151247836ULL, 0x000fe20000000000ULL, 0x00000003ff3d7819ULL, 0x000fe20000011606ULL,
0x000000020e0e7836ULL, 0x000fe20000000000ULL, 0x000000103c257c48ULL, 0x000fe2000ffe0000ULL,
0x00000010063b7824ULL, 0x000fe200078e00ffULL, 0x0000000624007c0cULL, 0x000fe2000bf26070ULL,
0x000000013d677824ULL, 0x040fe200078e0266ULL, 0x000000030e00780cULL, 0x000fe20003f04070ULL,
0x000000043d3a7836ULL, 0x000fe20000000000ULL, 0x0000ffff690e7812ULL, 0x000fe200078ec0ffULL,
0x00000001253c7824ULL, 0x000fe200078e0a3cULL, 0x0000000667647212ULL, 0x0c0fe200078e3cffULL,
0x0000000867257824ULL, 0x000fe200078e00ffULL, 0x000088800e2a7816ULL, 0x000fe200000000ffULL,
0x000000013a657824ULL, 0x100fe200078e0266ULL, 0x00000002033f7807ULL, 0x000fe20000000000ULL,
0x0000000c3d367836ULL, 0x000fe20000000000ULL, 0xfffffff825647812ULL, 0x000fe200078ee264ULL,
0x800000002a2a7824ULL, 0x000fe200078e00ffULL, 0x0000000665627212ULL, 0x040fe200078e3cffULL,
0x0000000865257824ULL, 0x000fe200078e00ffULL, 0x000000703b3b7812ULL, 0x000fe200078ec0ffULL,
0x0000202a090075a7ULL, 0x000ea2000804007fULL, 0x0000000136617824ULL, 0x000fc400078e0266ULL,
0x000000083d377836ULL, 0x040fe20000000000ULL, 0xfffffff825627812ULL, 0x000fe200078ee262ULL,
0x000000103d357836ULL, 0x000fe20000000000ULL, 0x00000006615e7212ULL, 0x0c0fe200078e3cffULL,
0x0000000861257824ULL, 0x000fe400078e00ffULL, 0x0000000137637824ULL, 0x100fe400078e0266ULL,
0x00000001355f7824ULL, 0x000fe200078e0266ULL, 0xfffffff8255e7812ULL, 0x000fe200078ee25eULL,
0x000000143d347836ULL, 0x000fe20000000000ULL, 0x0000000663607212ULL, 0x080fe200078e3cffULL,
0x000000183d337836ULL, 0x000fe20000000000ULL, 0x000000065f5c7212ULL, 0x000fe200078e3cffULL,
0x0000000863277824ULL, 0x000fc400078e00ffULL, 0x000000085f257824ULL, 0x000fe400078e00ffULL,
0x00000001345d7824ULL, 0x100fe200078e0266ULL, 0xfffffff827607812ULL, 0x000fe200078ee260ULL,
0x00000001335b7824ULL, 0x000fe200078e0266ULL, 0xfffffff8255c7812ULL, 0x000fe200078ee25cULL,
0x0000001c3d327836ULL, 0x000fe20000000000ULL, 0x000000065d5a7212ULL, 0x0c0fe200078e3cffULL,
0x000000085d277824ULL, 0x000fe200078e00ffULL, 0x000000065b587212ULL, 0x040fe200078e3cffULL,
0x000000085b257824ULL, 0x000fc400078e00ffULL, 0x0000000132597824ULL, 0x000fe200078e0266ULL,
0xfffffff8275a7812ULL, 0x000fe200078ee25aULL, 0x00000007050e7e24ULL, 0x020fe2000f8e0208ULL,
0xfffffff825587812ULL, 0x000fe200078ee258ULL, 0x0000000859247824ULL, 0x040fe200078e00ffULL,
0x0000000659577212ULL, 0x000fe200078e3cffULL, 0x0000000104267824ULL, 0x000fe200078e023fULL,
0x0000003f0e2d7812ULL, 0x000fe400078ef867ULL, 0x0000003f0e297812ULL, 0x000fe400078ef865ULL,
0x0000003f0e277812ULL, 0x000fe200078ef863ULL, 0x000000802d2c7825ULL, 0x002fe200078e0070ULL,
0x0000003f0e257812ULL, 0x000fc400078ef861ULL, 0xfffffff824577812ULL, 0x000fe200078ee257ULL,
0x0000008029287825ULL, 0x000fe200078e0070ULL, 0x0000000526007c0cULL, 0x000fc6000bf06070ULL,
0x0000008027267825ULL, 0x000fc800078e0070ULL, 0x0000008025247825ULL, 0x000fe200078e0070ULL,
0x0000000000082947ULL, 0x004fec0003800000ULL, 0x0000202a090075a7ULL, 0x000e64000804017fULL,
0x000000ec0024a947ULL, 0x002fea0003800000ULL, 0x0000003b28387210ULL, 0x000fe20007f7e0ffULL,
0x0000000d040a7899ULL, 0x000fe2000800063fULL, 0x0000003b242e7210ULL, 0x000fe20007fbe0ffULL,
0x00000003040c7899ULL, 0x000fe2000800063fULL, 0x000000403c057807ULL, 0x000fe20000800000ULL,
0x000000ffff397224ULL, 0x000fe200018e0629ULL, 0x0000003f0e297812ULL, 0x000fe200078ef85fULL,
0x000000ffff2f7224ULL, 0x000fe200028e0625ULL, 0x0000006605057248ULL, 0x000fe20007fe0000ULL,
0x000020000a0a7892ULL, 0x000fe2000f8e0c3fULL, 0x0000003f0e257812ULL, 0x000fe200078ef85bULL,
0x0000008029287825ULL, 0x000fe200078e0070ULL, 0x0000003b26307210ULL, 0x000fe20007f9e0ffULL,
0x00013000080a7890ULL, 0x000fe2000fffe00aULL, 0x0000003b2c447210ULL, 0x000fe20007f5e0ffULL,
0x0000000105057824ULL, 0x000fe200078e0a66ULL, 0x0000003b282c7210ULL, 0x000fe20007f7e0ffULL,
0x0000008025247825ULL, 0x000fe200078e0070ULL, 0x000000080c0b7892ULL, 0x000fe2000f8e0c3fULL,
0x0000000a64477c11ULL, 0x000fc4000f8e20ffULL, 0x000000ffff317224ULL, 0x000fe200020e0627ULL,
0x0000003f0e277812ULL, 0x000fe200078ef85dULL, 0x000000ffff457224ULL, 0x000fe200010e062dULL,
0x000000053d00720cULL, 0x080fe20003f26070ULL, 0x000000ffff2d7224ULL, 0x000fe200018e0629ULL,
0x0000003b24287210ULL, 0x000fe20007fbe0ffULL, 0x0000008027267825ULL, 0x000fe200078e0070ULL,
0x000000053a00720cULL, 0x080fe20003f46070ULL, 0x0000000b090d7290ULL, 0x000fe2000fffe03fULL,
0x000000053700720cULL, 0x000fe20003f66070ULL, 0x000000ffff297224ULL, 0x000fe200028e0625ULL,
0x0000003b262a7210ULL, 0x000fe20007f9e0ffULL, 0x00008c00ff248b82ULL, 0x000e620000000a00ULL,
0x0000000a62557c11ULL, 0x000fc4000f8e20ffULL, 0x0000000a606b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2b7224ULL, 0x000fe200020e0627ULL, 0x0000003f0e277812ULL, 0x000fe200078ef859ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000044477faeULL, 0x000fe2000c901c4eULL,
0x000000053600720cULL, 0x080fe40003f26070ULL, 0x000000053300720cULL, 0x080fe20003f86070ULL,
0x0000000038557faeULL, 0x0005e2000d101c4eULL, 0x000000053500720cULL, 0x080fe20003f46070ULL,
0x0000008027267825ULL, 0x000fe200078e0070ULL, 0x000000053200720cULL, 0x080fe20003fa6070ULL,
0x00000000306b7faeULL, 0x0007e2000d901c4eULL, 0x000000053400720cULL, 0x000fc40003f66070ULL,
0x0000000a5e6f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000003b26267210ULL, 0x000fe40007fde0ffULL,
0x0000000a5c057c11ULL, 0x000fe2000f8e20ffULL, 0x000000002e6f7faeULL, 0x000fe2000c901c4eULL,
0x0000003f0d558210ULL, 0x004fe20007ffe004ULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x0000000a5a397c11ULL, 0x000fe2000f8e20ffULL, 0x000000002c057faeULL, 0x0005e2000d101c4eULL,
0x0000000a58457c11ULL, 0x000fe2000f8e20ffULL, 0x0000000bff317e24ULL, 0x008fe2000f8e00ffULL,
0x0000000a57477c11ULL, 0x000fe2000f8e20ffULL, 0x0000000455248825ULL, 0x002fe200078e0024ULL,
0x000000002a397faeULL, 0x0003e2000d901c4eULL, 0x0000ffff680e7812ULL, 0x000fc600078ec0ffULL,
0x0000000028457faeULL, 0x0007e2000e101c4eULL, 0x000088800e0e7816ULL, 0x000fe200000000ffULL,
0xffffffffff057424ULL, 0x004fe400078e00ffULL, 0x0000000026477faeULL, 0x0005e2000e901c4eULL,
0x0000ffff0c2c7812ULL, 0x000fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000008532a7824ULL, 0x002fe400078e00ffULL, 0x000088802c3e7816ULL, 0x000fe200000000ffULL,
0x0000000e24058981ULL, 0x000362000c1e1900ULL, 0x0000000cff2d7e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff02a297812ULL, 0x008fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000eULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4dULL, 0x800000003e267824ULL, 0x004fc400078e00ffULL,
0x0000000102297824ULL, 0x000fe400078e0229ULL, 0x800000002a2a7824ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x002fcc0000000000ULL, 0x0000002a2d0075a7ULL, 0x0002620008000049ULL,
0x00000001ff567819ULL, 0x000fe20000011606ULL, 0x000000806d0e7824ULL, 0x000fc600078e0202ULL,
0x0000000c56567812ULL, 0x000fc800078ec0ffULL, 0x0000000e560e7210ULL, 0x000fe20007ffe03bULL,
0x01b60826290075a7ULL, 0x000ea4000802017fULL, 0x000000e400e49947ULL, 0x006fea0003800000ULL,
0x01b000000e247984ULL, 0x000e620000000800ULL, 0x0000000453257824ULL, 0x000fe200078e00ffULL,
0x0000000806397812ULL, 0x040fe200078ec0ffULL, 0x0000000804087291ULL, 0x000fe2000f8e683fULL,
0x01b200000e527984ULL, 0x0004a20000000800ULL, 0x0000000c090c7290ULL, 0x000fe2000fffe03fULL,
0x0000000425257812ULL, 0x000fe200078ec0ffULL, 0x0001300008087890ULL, 0x000fe2000fffe03fULL,
0x00000007393c7812ULL, 0x000fe200078ec806ULL, 0x00000001ff507424ULL, 0x000fe200078e00ffULL,
0x0000002506277211ULL, 0x000fc400078fe0ffULL, 0x0000000739397812ULL, 0x000fe400078ef806ULL,
0x000000273c387212ULL, 0x000fca00078e3cffULL, 0x0000000839477824ULL, 0x000fca00078e0238ULL,
0x0000000847287c11ULL, 0x000fe4000f8e20ffULL, 0x000000072400720bULL, 0x002fda0003f3d000ULL,
0x0000000000257806ULL, 0x000fc800008e0100ULL, 0x0000ffff25297812ULL, 0x000fda000782c0ffULL,
0x0000000000dc9947ULL, 0x004fea0003800000ULL, 0x000000072400720bULL, 0x000fe40003f34000ULL,
0x00000024072e7209ULL, 0x000fe40007810000ULL, 0x00000002ff257819ULL, 0x000fc60000011606ULL,
0x8000002e070e7221ULL, 0x000fe40000010000ULL, 0x0000000825267836ULL, 0x000fe40000000000ULL,
0x3fb8aa3b0e0e7820ULL, 0x000fe40000410000ULL, 0x0000000000077806ULL, 0x000fe400008e0100ULL,
0x0000000e002b7308ULL, 0x000e620000000800ULL, 0x000000536d00720cULL, 0x000fe40003f25270ULL,
0x0000ffff072c7812ULL, 0x000fc800078e3cffULL, 0x0000002c29ff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff507807ULL, 0x000fc60001000000ULL, 0x0000008053079824ULL, 0x000fe200078e0202ULL,
0x00001f262b267589ULL, 0x002e6200000e0000ULL, 0x0000002b0a0a7220ULL, 0x000fc60000410000ULL,
0x00001f252b257589ULL, 0x000ea200000e0000ULL, 0x8000002e24242221ULL, 0x000fe20000010000ULL,
0x0000000756079210ULL, 0x000fc60007ffe03bULL, 0x3fb8aa3b24242820ULL, 0x000fe40000410000ULL,
0x01b4002e07009388ULL, 0x0007e40000000800ULL, 0x00000024000b2308ULL, 0x000f220000000800ULL,
0x000000ffff077224ULL, 0x008fe400078e002eULL, 0x0000002623237220ULL, 0x082fe20000410000ULL,
0x0000002622227220ULL, 0x080fe20000410000ULL, 0x000000261f1f7220ULL, 0x080fe20000410000ULL,
0x000000261e1e7220ULL, 0x080fe20000410000ULL, 0x000000261b1b7220ULL, 0x080fe20000410000ULL,
0x000000261a1a7220ULL, 0x080fe20000410000ULL, 0x0000002617177220ULL, 0x080fe20000410000ULL,
0x0000002616167220ULL, 0x080fe20000410000ULL, 0x0000002613137220ULL, 0x080fe20000410000ULL,
0x0000002612127220ULL, 0x080fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x000000264e4e7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x000fe20000410000ULL, 0x0000002521217220ULL, 0x084fe20000410000ULL,
0x0000002520207220ULL, 0x080fe20000410000ULL, 0x000000251d1d7220ULL, 0x080fe20000410000ULL,
0x000000251c1c7220ULL, 0x080fe20000410000ULL, 0x0000002519197220ULL, 0x080fe20000410000ULL,
0x0000002518187220ULL, 0x080fe20000410000ULL, 0x0000002515157220ULL, 0x080fe20000410000ULL,
0x0000002514147220ULL, 0x080fe20000410000ULL, 0x0000002511117220ULL, 0x080fe20000410000ULL,
0x0000002510107220ULL, 0x080fe20000410000ULL, 0x000000254d4d7220ULL, 0x080fe20000410000ULL,
0x000000254c4c7220ULL, 0x080fe20000410000ULL, 0x0000002549497220ULL, 0x080fe20000410000ULL,
0x0000002548487220ULL, 0x080fe20000410000ULL, 0x0000002541417220ULL, 0x080fe20000410000ULL,
0x0000002540407220ULL, 0x000fe20000410000ULL, 0x0000000b52522220ULL, 0x010fce0000410000ULL,
0x0000000000080947ULL, 0x000fea0003800000ULL, 0x0000002a2d0075a7ULL, 0x000e640008000149ULL,
0x000000e000d08947ULL, 0x002fea0003800000ULL, 0x000000002828783bULL, 0x000e620000004200ULL,
0x0000000227277836ULL, 0x000fe20000000000ULL, 0x00000004ff257819ULL, 0x000fe20000011606ULL,
0x000008006d6d7824ULL, 0x000fe200078e0202ULL, 0x00000002ff457819ULL, 0x000fe20000011606ULL,
0x000000010400788cULL, 0x000fe2000bf05270ULL, 0x000000273c3c7212ULL, 0x000fe200078e3cffULL,
0x00000004000a7c82ULL, 0x000fe20008000000ULL, 0x0000000706277812ULL, 0x000fe200078ec0ffULL,
0x0000000104047892ULL, 0x000fe2000f8e0c3fULL, 0x0000000bff6a723eULL, 0x000fe200000010ffULL,
0x0000000839307824ULL, 0x000fe200078e023cULL, 0x00000008276c7812ULL, 0x000fe200078ef806ULL,
0x0000000a520a7221ULL, 0x000fe20000010000ULL, 0x000054106a727816ULL, 0x000fc4000000006aULL,
0x0000000725257812ULL, 0x000fe400078e786cULL, 0x0000991050747816ULL, 0x000fe200000000ffULL,
0x00001f45726b7589ULL, 0x000fe200000e0000ULL, 0x00000008302c7c11ULL, 0x000fe2000f8e20ffULL,
0x000000086c467824ULL, 0x000fe200078e0225ULL, 0x00000006067d7811ULL, 0x000fe400078fe0ffULL,
0x000000000000781cULL, 0x000fe20003f6f008ULL, 0x0000001046247824ULL, 0x000fe200078e026dULL,
0x000000002c2c783bULL, 0x000ea20000004200ULL, 0x000000077d7d7812ULL, 0x000fc400078e786cULL,
0x000000ff69ff7812ULL, 0x040fe4000784c0ffULL, 0x011000002424783bULL, 0x000ee20000000200ULL,
0x0000761069527816ULL, 0x000fe20000000052ULL, 0x0000010028447824ULL, 0x042fe200078e00ffULL,
0x00008880286e7816ULL, 0x000fe200000000ffULL, 0x0000010029507824ULL, 0x040fe200078e00ffULL,
0x0000888029737816ULL, 0x000fe400000000ffULL, 0x00000018ff757819ULL, 0x000fe20000011444ULL,
0x0000000845447836ULL, 0x000fe20000000000ULL, 0x00000018ff767819ULL, 0x000fe20000011450ULL,
0x000000ffff507224ULL, 0x000fe200078e0074ULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x00000018ff0e7819ULL, 0x000fe20000011429ULL, 0x00001f44726a7589ULL, 0x00032200000e0000ULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x000000ff5000720cULL, 0x000fe20003f05270ULL,
0x0001000028747824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fc40000011428ULL,
0x0000007500757306ULL, 0x000ee20000202400ULL, 0x00000018ff547819ULL, 0x000fe4000001142aULL,
0x00000018ff557819ULL, 0x000fe4000001142bULL, 0x00000018ff727819ULL, 0x002fe40000011474ULL,
0x000088802a747816ULL, 0x000fe200000000ffULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x00000018ff507819ULL, 0x004fe2000001142cULL, 0x0000006b24248232ULL, 0x008fe20000200000ULL,
0x000054106e287816ULL, 0x000fca0000000075ULL, 0x0000007600767306ULL, 0x000e620000202400ULL,
0x00000018ff757819ULL, 0x000fe20000011429ULL, 0x0000006b26268232ULL, 0x000fe20000200000ULL,
0x000088802b6e7816ULL, 0x000fe200000000ffULL, 0x0000006a25258232ULL, 0x090fe40000200000ULL,
0x0000006a27278232ULL, 0x000fe40000200000ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x0000541073297816ULL, 0x002fce0000000076ULL, 0x0000000e000e7306ULL, 0x000fe20000202400ULL,
0x000000282440723cULL, 0x000fee0000041840ULL, 0x0000007200727306ULL, 0x000e620000202400ULL,
0x000001002a287824ULL, 0x000fe400078e00ffULL, 0x000001002b297824ULL, 0x000fca00078e00ffULL,
0x0000007500757306ULL, 0x000ea20000202400ULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000007400747306ULL, 0x000ff00000202400ULL, 0x0000002800777306ULL, 0x0002f00000202400ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x0000541072287816ULL, 0x002fc4000000006fULL,
0x00000080396f7811ULL, 0x000fe400078e18ffULL, 0x00000018ff727819ULL, 0x000fc6000001142dULL,
0x0000002900797306ULL, 0x0004700000202400ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x0000541075297816ULL, 0x004fe2000000000eULL, 0x00000001380e7824ULL, 0x000fc400078e026fULL,
0x000000013c6f7824ULL, 0x000fc800078e026fULL, 0x000000282448723cULL, 0x000fe20000041848ULL,
0x0000005500557306ULL, 0x000fec0000202400ULL, 0x0000541074287816ULL, 0x008fe40000000077ULL,
0x00000018ff747819ULL, 0x000fe2000001142bULL, 0x0000002a00737306ULL, 0x0004e20000202400ULL,
0x000054106e297816ULL, 0x002fce0000000079ULL, 0x00000074006e7306ULL, 0x0003220000202400ULL,
0x000000080e2a7c11ULL, 0x004fe2000f8e20ffULL, 0x00000028244c723cULL, 0x000fe2000004184cULL,
0x000088802c0e7816ULL, 0x040fe400000000ffULL, 0x0000541073547816ULL, 0x008fe20000000054ULL,
0x000001002c737824ULL, 0x000fc600078e00ffULL, 0x0000000e000e7306ULL, 0x000fe20000202400ULL,
0x000100002c2c7824ULL, 0x000fe200078e00ffULL, 0x000000002a28783bULL, 0x000ea20000004200ULL,
0x00000018ff747819ULL, 0x002fe4000001142eULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x000054106e557816ULL, 0x010fe20000000055ULL, 0x0000005000507306ULL, 0x000fe20000202400ULL,
0x000088802d6e7816ULL, 0x000fe400000000ffULL, 0x00000018ff2c7819ULL, 0x000fc6000001142cULL,
0x000000542410723cULL, 0x000fe40000041810ULL, 0x0000007300737306ULL, 0x000e6a0000202400ULL,
0x000001002d557824ULL, 0x000fe400078e00ffULL, 0x000000ffff547224ULL, 0x000fe200078e006eULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x00000018ff6e7819ULL, 0x000fc4000001142fULL,
0x00000018ff557819ULL, 0x000fca0000011455ULL, 0x0000005400757306ULL, 0x0003f00000202400ULL,
0x0000005500767306ULL, 0x000ee20000202400ULL, 0x000054100e547816ULL, 0x002fe20000000073ULL,
0x000100002d737824ULL, 0x000fe200078e00ffULL, 0x00000018ff0e7819ULL, 0x004fca0000011428ULL,
0x0000002c002d7306ULL, 0x0002a20000202400ULL, 0x0000541075557816ULL, 0x008fce0000000076ULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x00000018ff757819ULL, 0x000fe20000011473ULL,
0x000001002f2c7824ULL, 0x002fe200078e00ffULL, 0x000088802e737816ULL, 0x040fe200000000ffULL,
0x000000542414723cULL, 0x000fe60000041814ULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0000007500757306ULL, 0x000e660000202400ULL, 0x000001002e547824ULL, 0x000fc400078e00ffULL,
0x000100002e2e7824ULL, 0x000fc600078e00ffULL, 0x0000002c00777306ULL, 0x0005e20000202400ULL,
0x00000018ff767819ULL, 0x000fe40000011454ULL, 0x000088802f547816ULL, 0x040fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fc6000001142eULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x000054102d2c7816ULL, 0x004fe40000000050ULL,
0x00005410752d7816ULL, 0x002fe40000000072ULL, 0x00000018ff757819ULL, 0x000fe4000001142fULL,
0x000000086f727c11ULL, 0x000fe2000f8e20ffULL, 0x0000005400547306ULL, 0x000e620000202400ULL,
0x00000018ff6f7819ULL, 0x000fe2000001142aULL, 0x0000002c2418723cULL, 0x000fec0000041818ULL,
0x0000002e00557306ULL, 0x000ea20000202400ULL, 0x00000002062d7811ULL, 0x000fc800078fe0ffULL,
0x000000072d2f7812ULL, 0x000fe400078e786cULL, 0x00005410542d7816ULL, 0x002fe20000000077ULL,
0x0000007300737306ULL, 0x000fe40000202400ULL, 0x000000086c507824ULL, 0x000fc800078e022fULL,
0x0000001050507824ULL, 0x000fe200078e026dULL, 0x0000541055547816ULL, 0x004fe20000000074ULL,
0x0000007600767306ULL, 0x000e620000202400ULL, 0x00000018ff747819ULL, 0x000fce000001142bULL,
0x0000007500757306ULL, 0x000ea20000202400ULL, 0x00005410732c7816ULL, 0x002fce0000000076ULL,
0x0000000e000e7306ULL, 0x000fe20000202400ULL, 0x00000018ff737819ULL, 0x000fe20000011429ULL,
0x0000002c242c723cULL, 0x000fe2000004181cULL, 0x0000541075557816ULL, 0x004fe2000000006eULL,
0x00000100296e7824ULL, 0x040fe200078e00ffULL, 0x00000000721c783bULL, 0x0002a60000004200ULL,
0x0000007300737306ULL, 0x000fe20000202400ULL, 0x00000018ff757819ULL, 0x000fe2000001146eULL,
0x000000542420723cULL, 0x000fe20000041820ULL, 0x011000005024783bULL, 0x000ee20000000200ULL,
0x0000888029727816ULL, 0x042fe200000000ffULL, 0x0001000029297824ULL, 0x000fc600078e00ffULL,
0x0000007500757306ULL, 0x000fe20000202400ULL, 0x0000010028557824ULL, 0x040fe200078e00ffULL,
0x0000888028547816ULL, 0x040fe200000000ffULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x00000018ff287819ULL, 0x000fce0000011428ULL,
0x0000005400547306ULL, 0x000ff00000202400ULL, 0x0000005500557306ULL, 0x000e620000202400ULL,
0x00000018ff6e7819ULL, 0x004fce000001141cULL, 0x0000002900767306ULL, 0x000ea20000202400ULL,
0x0000006b24248232ULL, 0x088fe40000200000ULL, 0x0000006b26268232ULL, 0x000fe20000200000ULL,
0x0000541054547816ULL, 0x002fe20000000055ULL, 0x0000006a25258232ULL, 0x080fe20000200000ULL,
0x0000541072557816ULL, 0x000fe20000000075ULL, 0x0000006a27278232ULL, 0x000fe20000200000ULL,
0x0000002800757306ULL, 0x000e620000202400ULL, 0x00000018ff727819ULL, 0x000fe4000001141dULL,
0x0000541076297816ULL, 0x004fc60000000073ULL, 0x000000542440723cULL, 0x000fe20000041840ULL,
0x000088802b737816ULL, 0x000fe200000000ffULL, 0x0000006f006f7306ULL, 0x000fea0000202400ULL,
0x000001002a557824ULL, 0x040fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe4000001141eULL,
0x0000541075287816ULL, 0x002fe2000000000eULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x000088802a0e7816ULL, 0x040fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fc800078e00ffULL,
0x000000282448723cULL, 0x000fe20000041848ULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000000e000e7306ULL, 0x000fea0000202400ULL, 0x00000018ff287819ULL, 0x000fe20000011455ULL,
0x000001002b557824ULL, 0x040fe400078e00ffULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x0000002800297306ULL, 0x000e640000202400ULL, 0x00000018ff757819ULL, 0x000fc40000011455ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x00000018ff557819ULL, 0x000fe4000001141fULL,
0x0000007500767306ULL, 0x000ea20000202400ULL, 0x000054100e287816ULL, 0x002fce0000000029ULL,
0x0000002a002a7306ULL, 0x000e620000202400ULL, 0x000088801c0e7816ULL, 0x000fe400000000ffULL,
0x0000541073297816ULL, 0x004fca0000000076ULL, 0x0000007400747306ULL, 0x000fe20000202400ULL,
0x000100001c737824ULL, 0x040fe200078e00ffULL, 0x00000028244c723cULL, 0x000fe8000004184cULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000002b002b7306ULL, 0x000ea20000202400ULL,
0x000001001c287824ULL, 0x000fe200078e00ffULL, 0x000054102a1c7816ULL, 0x002fe2000000006fULL,
0x000001001d297824ULL, 0x000fca00078e00ffULL, 0x0000000e000e7306ULL, 0x000fe20000202400ULL,
0x000100001d2a7824ULL, 0x040fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe40000011428ULL,
0x000088801d287816ULL, 0x000fe400000000ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000007700777306ULL, 0x000e620000202400ULL, 0x000054102b1d7816ULL, 0x004fe40000000074ULL,
0x00000100396f7811ULL, 0x000fc400078e18ffULL, 0x00000018ff757819ULL, 0x000fe4000001142aULL,
0x000088801f747816ULL, 0x000fe200000000ffULL, 0x0000002800287306ULL, 0x000fe20000202400ULL,
0x0000001c2410723cULL, 0x000fe20000041810ULL, 0x00000001382a7824ULL, 0x000fca00078e026fULL,
0x000000082a2b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000002900297306ULL, 0x000ea20000202400ULL,
0x000088801e1d7816ULL, 0x040fe200000000ffULL, 0x000001001e2a7824ULL, 0x000fe200078e00ffULL,
0x000054100e1c7816ULL, 0x002fc80000000077ULL, 0x00000018ff777819ULL, 0x000fe2000001142aULL,
0x0000006e006e7306ULL, 0x000ff00000202400ULL, 0x0000007300737306ULL, 0x000e700000202400ULL,
0x0000001d000e7306ULL, 0x0005f00000202400ULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x00005410281d7816ULL, 0x004fc40000000029ULL, 0x000000002b28783bULL, 0x000eaa0000004200ULL,
0x0000007500757306ULL, 0x000ee20000202400ULL, 0x0000001c2414723cULL, 0x000fee0000041814ULL,
0x000001001f1d7824ULL, 0x000fe200078e00ffULL, 0x00005410731c7816ULL, 0x002fe2000000006eULL,
0x000100001e6e7824ULL, 0x000fe200078e00ffULL, 0x0000007700777306ULL, 0x000e640000202400ULL,
0x00000018ff1d7819ULL, 0x000fcc000001141dULL, 0x0000007400737306ULL, 0x000ff00000202400ULL,
0x0000001d001e7306ULL, 0x0007300000202400ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x00005410751d7816ULL, 0x008fc40000000072ULL, 0x00000018ff727819ULL, 0x000fe2000001146eULL,
0x000100001f6e7824ULL, 0x000fe200078e00ffULL, 0x0000000406757811ULL, 0x000fc600078fe0ffULL,
0x00000072001f7306ULL, 0x0006e20000202400ULL, 0x0000000775757812ULL, 0x000fe200078e786cULL,
0x0000001c2418723cULL, 0x000fe20000041818ULL, 0x00000018ff6e7819ULL, 0x000fc6000001146eULL,
0x000000086c747824ULL, 0x000fe200078e0275ULL, 0x0000888028757816ULL, 0x004fe200000000ffULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x000054100e1c7816ULL, 0x002fe20000000077ULL,
0x00000010740e7824ULL, 0x000fe200078e026dULL, 0x00005410731d7816ULL, 0x010fe2000000001eULL,
0x000000013c727824ULL, 0x008fe400078e026fULL, 0x0000010028747824ULL, 0x000fe200078e00ffULL,
0x000054101f547816ULL, 0x000fe20000000054ULL, 0x0000006e006e7306ULL, 0x000e620000202400ULL,
0x000000ffff737224ULL, 0x000fe200078e0075ULL, 0x0000001c242c723cULL, 0x000fe2000004182cULL,
0x011000000e1c783bULL, 0x000ea20000000200ULL, 0x00000018ff757819ULL, 0x000fe20000011474ULL,
0x000000086c6c7824ULL, 0x000fe200078e027dULL, 0x00000018ff747819ULL, 0x000fe20000011428ULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000073006f7306ULL, 0x0007e20000202400ULL,
0x000000106c6c7824ULL, 0x000fc600078e026dULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x000054106e557816ULL, 0x002fe40000000055ULL, 0x0000007400747306ULL, 0x000fe20000202400ULL,
0x00000008726e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000010029727824ULL, 0x040fe200078e00ffULL,
0x00000018ff737819ULL, 0x008fe4000001142aULL, 0x000000542420723cULL, 0x000fe40000041820ULL,
0x00000018ff767819ULL, 0x000fe20000011472ULL, 0x0000007500547306ULL, 0x000e620000202400ULL,
0x00000018ff727819ULL, 0x000fe20000011429ULL, 0x000000006e24783bULL, 0x000ee40000004200ULL,
0x0000888029557816ULL, 0x000fc800000000ffULL, 0x0000007600767306ULL, 0x000fe20000202400ULL,
0x000054106f547816ULL, 0x002fce0000000054ULL, 0x0000005500557306ULL, 0x000e620000202400ULL,
0x00000018ff6f7819ULL, 0x000fe2000001142bULL, 0x0000006b1c1c8232ULL, 0x084fe40000200000ULL,
0x0000006b1e1e8232ULL, 0x000fe40000200000ULL, 0x0000006a1d1d8232ULL, 0x080fe40000200000ULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x0000006a1f1f8232ULL, 0x000fe20000200000ULL,
0x0000541055557816ULL, 0x002fcc0000000076ULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x000000541c40723cULL, 0x000fee0000041840ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x00000018ff6e7819ULL, 0x008fe40000011424ULL, 0x0000888026797816ULL, 0x000fe200000000ffULL,
0x0001000029547824ULL, 0x000fe200078e00ffULL, 0x000088802a557816ULL, 0x000fc600000000ffULL,
0x0000002800297306ULL, 0x000e620000202400ULL, 0x00000018ff547819ULL, 0x000fce0000011454ULL,
0x0000005400757306ULL, 0x0004e20000202400ULL, 0x0000541029287816ULL, 0x002fe20000000074ULL,
0x000001002a297824ULL, 0x000fcc00078e00ffULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x004fe40000011426ULL,
0x00000018ff747819ULL, 0x000fe40000011429ULL, 0x0000541075297816ULL, 0x008fe40000000072ULL,
0x000088802b727816ULL, 0x000fe200000000ffULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x00000018ff2a7819ULL, 0x000fc6000001142aULL, 0x000000281c48723cULL, 0x000fe80000041848ULL,
0x0000007400747306ULL, 0x000e660000202400ULL, 0x000001002b297824ULL, 0x040fe400078e00ffULL,
0x000000ffff287224ULL, 0x000fe200078e0072ULL, 0x00000018ff727819ULL, 0x000fe20000011425ULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000002800757306ULL, 0x0003e60000202400ULL, 0x00000018ff2b7819ULL, 0x000fca000001142bULL,
0x0000002900767306ULL, 0x000ea20000202400ULL, 0x0000541055287816ULL, 0x002fe40000000074ULL,
0x00000018ff557819ULL, 0x000fca0000011427ULL, 0x0000002a002a7306ULL, 0x000e620000202400ULL,
0x0000541075297816ULL, 0x004fe20000000076ULL, 0x0000010025757824ULL, 0x000fcc00078e00ffULL,
0x0000002b00767306ULL, 0x000ea20000202400ULL, 0x00000018ff777819ULL, 0x000fe20000011475ULL,
0x000000281c4c723cULL, 0x000fe2000004184cULL, 0x0001000024757824ULL, 0x000fca00078e00ffULL,
0x00000077002b7306ULL, 0x000fe20000202400ULL, 0x00000018ff757819ULL, 0x000fe20000011475ULL,
0x0000010024287824ULL, 0x040fe200078e00ffULL, 0x0000888024297816ULL, 0x000fe400000000ffULL,
0x000054102a247816ULL, 0x002fe20000000073ULL, 0x00010000252a7824ULL, 0x040fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011428ULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x0000888025287816ULL, 0x000fe400000000ffULL, 0x0000018039737811ULL, 0x000fc400078e18ffULL,
0x0000541076257816ULL, 0x004fe4000000006fULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000002800287306ULL, 0x000e620000202400ULL, 0x00000001386f7824ULL, 0x000fc600078e0273ULL,
0x000000241c10723cULL, 0x000fe80000041810ULL, 0x0000002900297306ULL, 0x000fe60000202400ULL,
0x0000541028257816ULL, 0x002fca000000002bULL, 0x0000007400747306ULL, 0x000e620000202400ULL,
0x000000086f287c11ULL, 0x000fce000f8e20ffULL, 0x0000002a007b7306ULL, 0x0004e20000202400ULL,
0x0000541029247816ULL, 0x002fce0000000074ULL, 0x0000007500757306ULL, 0x000fe20000202400ULL,
0x000000002828783bULL, 0x004e620000004200ULL, 0x0000888027747816ULL, 0x000fe200000000ffULL,
0x000000241c14723cULL, 0x000fea0000041814ULL, 0x0000005400547306ULL, 0x000fe40000202400ULL,
0x0000010026247824ULL, 0x000fc400078e00ffULL, 0x0000010027257824ULL, 0x000fc800078e00ffULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000018ff777819ULL, 0x000fe40000011425ULL,
0x00000018ff257819ULL, 0x000fe20000011426ULL, 0x0001000027267824ULL, 0x000fe200078e00ffULL,
0x0000007900797306ULL, 0x000fe80000202400ULL, 0x00000018ff267819ULL, 0x000fc80000011426ULL,
0x0000002500277306ULL, 0x0006b00000202400ULL, 0x0000002600267306ULL, 0x000f220000202400ULL,
0x000054107b257816ULL, 0x008fe40000000072ULL, 0x00000018ff6d7819ULL, 0x002fc40000011428ULL,
0x00000018ff727819ULL, 0x000fe4000001142aULL, 0x0000541027547816ULL, 0x004fe20000000054ULL,
0x0000002400767306ULL, 0x0002a20000202400ULL, 0x0000541026557816ULL, 0x010fce0000000055ULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x0000541075247816ULL, 0x002fe2000000006eULL,
0x000000013c6e7824ULL, 0x000fe200078e0273ULL, 0x000000541c20723cULL, 0x000fea0000041820ULL,
0x0000007700777306ULL, 0x000e620000202400ULL, 0x000000241c18723cULL, 0x000fe20000041818ULL,
0x0000010028557824ULL, 0x040fe200078e00ffULL, 0x0000888028547816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fc800078e00ffULL, 0x0000006d006d7306ULL, 0x000fe20000202400ULL,
0x00000018ff757819ULL, 0x000fe40000011455ULL, 0x0000541079247816ULL, 0x004fe20000000076ULL,
0x000100002b767824ULL, 0x000fe200078e00ffULL, 0x0000888029557816ULL, 0x000fe400000000ffULL,
0x0000541074257816ULL, 0x002fe20000000077ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x00000018ff747819ULL, 0x000fe40000011429ULL, 0x00000018ff287819ULL, 0x000fc40000011428ULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x000000241c2c723cULL, 0x000fe2000004182cULL,
0x011000006c24783bULL, 0x000e620000000200ULL, 0x0000007400737306ULL, 0x0005ea0000202400ULL,
0x000000086e1c7c11ULL, 0x000fc6000f8e20ffULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x0000010029747824ULL, 0x044fe400078e00ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x000000001c1c783bULL, 0x000ea40000004200ULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0000002800287306ULL, 0x000ef00000202400ULL,
0x0000007400747306ULL, 0x000f220000202400ULL, 0x0000541028287816ULL, 0x008fce000000006dULL,
0x0000007500757306ULL, 0x000ee20000202400ULL, 0x000088802a6d7816ULL, 0x000fe200000000ffULL,
0x0000006b24248232ULL, 0x082fe20000200000ULL, 0x0000541055557816ULL, 0x010fe20000000074ULL,
0x0000006b26268232ULL, 0x000fc80000200000ULL, 0x0000002900747306ULL, 0x000e620000202400ULL,
0x0000006a25258232ULL, 0x080fe20000200000ULL, 0x00000018ff6b7819ULL, 0x000fe2000001142bULL,
0x0000006a27278232ULL, 0x000fe20000200000ULL, 0x000000ff68ff7812ULL, 0x000fe4000780c0ffULL,
0x0000541054547816ULL, 0x008fe40000000075ULL, 0x0000006d006d7306ULL, 0x000fe20000202400ULL,
0x00000018ff6a7819ULL, 0x004fe4000001141cULL, 0x000088801c787816ULL, 0x000fc400000000ffULL,
0x000000542440723cULL, 0x000fe20000041840ULL, 0x0000541074297816ULL, 0x002fe20000000073ULL,
0x000001002a737824ULL, 0x000fe200078e00ffULL, 0x000088802b747816ULL, 0x040fe200000000ffULL,
0x0000007200727306ULL, 0x000fe60000202400ULL, 0x00000018ff557819ULL, 0x000fe2000001141dULL,
0x000000282448723cULL, 0x000fe20000041848ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000018ff547819ULL, 0x000fe2000001141eULL, 0x0000007400747306ULL, 0x000fe60000202400ULL,
0x000001002b297824ULL, 0x000fca00078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011429ULL,
0x0000007300287306ULL, 0x000e620000202400ULL, 0x000100002a297824ULL, 0x000fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fc8000001141fULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000007500757306ULL, 0x000ea20000202400ULL, 0x000054106d287816ULL, 0x002fce0000000028ULL,
0x00000029002b7306ULL, 0x0004700000202400ULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x0000541074297816ULL, 0x004fe40000000075ULL, 0x000088801d757816ULL, 0x000fca00000000ffULL,
0x0000007600747306ULL, 0x000ea20000202400ULL, 0x00000028244c723cULL, 0x000fee000004184cULL,
0x000001001c287824ULL, 0x040fe200078e00ffULL, 0x0000007800787306ULL, 0x000fe20000202400ULL,
0x000100001c1c7824ULL, 0x000fc400078e00ffULL, 0x000001001d297824ULL, 0x040fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000002800777306ULL, 0x0007f00000202400ULL, 0x0000001c006d7306ULL, 0x0003e20000202400ULL,
0x000088801f287816ULL, 0x008fce00000000ffULL, 0x0000007500757306ULL, 0x000fe20000202400ULL,
0x000054102b1c7816ULL, 0x002fe40000000072ULL, 0x00000018ff727819ULL, 0x000fe4000001141dULL,
0x00005410741d7816ULL, 0x004fe4000000006bULL, 0x000088801e747816ULL, 0x040fe200000000ffULL,
0x0000002900767306ULL, 0x0002a80000202400ULL, 0x0000001c2410723cULL, 0x000fe80000041810ULL,
0x0000006a006a7306ULL, 0x000ee60000202400ULL, 0x000001001e1d7824ULL, 0x000fc400078e00ffULL,
0x000001001f1c7824ULL, 0x040fe400078e00ffULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff297819ULL, 0x002fe4000001141fULL, 0x0000007200727306ULL, 0x000e620000202400ULL,
0x00000018ff1e7819ULL, 0x000fce000001141eULL, 0x0000001d006b7306ULL, 0x0005f00000202400ULL,
0x0000001c00737306ULL, 0x0009e20000202400ULL, 0x00005410751d7816ULL, 0x004fce0000000076ULL,
0x0000002800287306ULL, 0x000ea20000202400ULL, 0x00005410781c7816ULL, 0x010fce0000000077ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x0000001c2414723cULL, 0x000fee0000041814ULL,
0x0000002a002a7306ULL, 0x000fe20000202400ULL, 0x000054106d1c7816ULL, 0x008fe4000000006aULL,
0x00005410721d7816ULL, 0x002fc40000000055ULL, 0x00000001ff6d7819ULL, 0x000fe40000011653ULL,
0x00007610686a7816ULL, 0x000fe2000000006aULL, 0x0000007400747306ULL, 0x000e620000202400ULL,
0x00000001ff68b807ULL, 0x000fe20000000000ULL, 0x0000001c2418723cULL, 0x000fe20000041818ULL,
0x000000106d557824ULL, 0x000fca00078e0202ULL, 0x0000001e002b7306ULL, 0x0007220000202400ULL,
0x00005410281d7816ULL, 0x004fe40000000073ULL, 0x00005410741c7816ULL, 0x002fca000000006bULL,
0x0000002900297306ULL, 0x000e640000202400ULL, 0x0000001c241c723cULL, 0x008fe2000004182cULL,
0x000054102b287816ULL, 0x010fe20000000054ULL, 0x00000001ff547424ULL, 0x000fc800078e00ffULL,
0x0000205409ff79a7ULL, 0x0005e2000850003fULL, 0x0000541029297816ULL, 0x002fe2000000002aULL,
0x01b6105455ff79a7ULL, 0x0005ec000850003fULL, 0x000000282420723cULL, 0x000fee0000041820ULL,
0x0000000451247824ULL, 0x000fc400078e026dULL, 0x000040006d257824ULL, 0x000fc600078e0202ULL,
0x0000008024247811ULL, 0x000fe400078e30ffULL, 0x00000000250872caULL, 0x000fe400000e0000ULL,
0x0000001024007c0cULL, 0x000fe2000bf26070ULL, 0x000000ffff247224ULL, 0x000fe200078e0004ULL,
0x00000001ff257807ULL, 0x000fe20001000000ULL, 0x0000000104047824ULL, 0x000fc600078e023fULL,
0x0000761025697816ULL, 0x000fce0000000069ULL, 0x00000028005c1947ULL, 0x004fea0003800000ULL,
0x8000000025267824ULL, 0x000fe200078e00ffULL, 0x0000000d0a047899ULL, 0x000fe2000800063fULL,
0x0000000705287e24ULL, 0x020fe4000f8e0208ULL, 0x00002026090075a7ULL, 0x0002a200080a007fULL,
0x0000000100047824ULL, 0x000fe200078e0251ULL, 0x00002000040b7892ULL, 0x000fe2000f8ec03fULL,
0x0000003f28737812ULL, 0x000fe200078ef867ULL, 0x00000001243f7824ULL, 0x000fe200078e023fULL,
0x0000003f282f7812ULL, 0x000fe200078ef865ULL, 0x0000000404247824ULL, 0x000fe200078e026dULL,
0x0000003f28277812ULL, 0x000fe200078ef85dULL, 0x0000008073727825ULL, 0x100fe200078e0070ULL,
0x0000003f282d7812ULL, 0x000fe200078ef863ULL, 0x00013000080b7890ULL, 0x000fe2000fffe00bULL,
0x0000003f285d7812ULL, 0x000fe200078ef859ULL, 0x0000004024597824ULL, 0x000fe200078e00ffULL,
0x0000003f282b7812ULL, 0x000fe200078ef861ULL, 0x0000000104047836ULL, 0x000fe20000000000ULL,
0x000000033f057812ULL, 0x000fe200078ec0ffULL, 0x000000802f2e7825ULL, 0x000fe200078e0070ULL,
0x0000003f28297812ULL, 0x000fc400078ef85fULL, 0x0000003f28257812ULL, 0x000fe200078ef85bULL,
0x000000802d2c7825ULL, 0x100fe200078e0070ULL, 0x0000003b72727210ULL, 0x000fe40007f5e0ffULL,
0x0000001059747c48ULL, 0x000fe2000ffe0000ULL, 0x000000802b2a7825ULL, 0x000fe200078e0070ULL,
0x0000000604007c0cULL, 0x000fc6000bf06070ULL, 0x00000002055b7836ULL, 0x000fe40000000000ULL,
0x0000008029287825ULL, 0x000fc600078e0070ULL, 0x000000035b00780cULL, 0x000fe20003f24070ULL,
0x0000008027267825ULL, 0x002fc800078e0070ULL, 0x0000008025247825ULL, 0x000fc800078e0070ULL,
0x000000805d047825ULL, 0x000fe200078e0070ULL, 0x0000003b2e707210ULL, 0x000fe40007f7e0ffULL,
0x0000003b2c2e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff737224ULL, 0x000fe200010e0673ULL,
0x0000003b2a2c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000174747824ULL, 0x000fe400078e0a59ULL,
0x000000ffff717224ULL, 0x000fe200018e062fULL, 0x0000003b282a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200020e062dULL, 0x0000004074597807ULL, 0x000fe20000000000ULL,
0x000000ffff2d7224ULL, 0x000fe200010e062bULL, 0x0000003b26287210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200018e0629ULL, 0x0000005966597248ULL, 0x000fc40007fe0000ULL,
0x0000003b24267210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff297224ULL, 0x000fe200010e0627ULL,
0x0000003b04247210ULL, 0x000fe20007f5e0ffULL, 0x0000000159597824ULL, 0x000fe200078e0a66ULL,
0x0000000203047807ULL, 0x000fe20000800000ULL, 0x000000ffff277224ULL, 0x000fe400000e0625ULL,
0x000000ffff257224ULL, 0x000fe200010e0605ULL, 0x000000593500720cULL, 0x000fe20003f66070ULL,
0x000000013f047824ULL, 0x000fe200078e0204ULL, 0x0000000b64057c11ULL, 0x000fc4000f8e20ffULL,
0x0000000b62357c11ULL, 0x000fe4000f8e20ffULL, 0x000000593d00720cULL, 0x080fe40003fc6070ULL,
0x000000593a00720cULL, 0x080fe40003f86070ULL, 0x000000593700720cULL, 0x080fe40003f46070ULL,
0x000000593600720cULL, 0x000fe40003f26070ULL, 0x0000000504007c0cULL, 0x000fe2000bf06070ULL,
0x0000000000145947ULL, 0x004fd80003800000ULL, 0x000000ff52ff7812ULL, 0x000fc800078ac0ffULL,
0x00000001ff367807ULL, 0x000fca0002800000ULL, 0x8000000036367824ULL, 0x000fc800078e00ffULL,
0x00002036090075a7ULL, 0x000e6400080a017fULL, 0x000000bc00c8d947ULL, 0x002fea0003800000ULL,
0x00008c00ff368b82ULL, 0x000e620000000a00ULL, 0x0000000b603d7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000072057faeULL, 0x0005e2000f101c4eULL,
0x000000030a0c7899ULL, 0x000fe2000800063fULL, 0x000000593400720cULL, 0x080fe40003fa6070ULL,
0x0000000070357faeULL, 0x000fe2000e101c4eULL, 0x000000593300720cULL, 0x080fe20003f86070ULL,
0x000000080c0c7892ULL, 0x000fe2000f8ec03fULL, 0x0000000b5e337c11ULL, 0x000fe2000f8e20ffULL,
0x000000002e3d7faeULL, 0x0009e2000d101c4eULL, 0x000000593200720cULL, 0x000fe20003f46070ULL,
0x0001b648110c7890ULL, 0x000fe2000fffe00cULL, 0x0000000b5c3f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000010d058824ULL, 0x004fe200078e0204ULL, 0x0000000b5a597c11ULL, 0x000fe2000f8e20ffULL,
0x000000002c337faeULL, 0x000fe2000c901c4eULL, 0x0000000b57577c11ULL, 0x000fc4000f8e20ffULL,
0x0000ffff68687812ULL, 0x000fe200078ec0ffULL, 0x000000002a3f7faeULL, 0x0005e2000d901c4eULL,
0x0000000b582f7c11ULL, 0x010fe2000f8e20ffULL, 0x0000000405368825ULL, 0x002fe400078e0036ULL,
0x0000000028597faeULL, 0x0003e2000e901c4eULL, 0x0000888068687816ULL, 0x000fe200000000ffULL,
0xffffffffff057424ULL, 0x000fe400078e00ffULL, 0x00000000262f7faeULL, 0x0007e4000e101c4eULL,
0x000000ffff2a7224ULL, 0x004fc400078e0068ULL, 0x0000000024577faeULL, 0x0007e2000d101c4eULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000e36058981ULL, 0x000762000c1e1900ULL,
0x800000003e3e7824ULL, 0x000fe400078e00ffULL, 0x800000002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4cULL, 0x0000000000007918ULL, 0x002fca0000000000ULL,
0x0000002a310075a7ULL, 0x0002620008000049ULL, 0x0000004053247824ULL, 0x008fca00078e00ffULL,
0xffffff8024257812ULL, 0x000fc800078ec0ffULL, 0x0000010002257810ULL, 0x000fc80007ffe025ULL,
0x0000002556267210ULL, 0x000fe20007ffe03bULL, 0xffffe03eff0075a7ULL, 0x000ea40008020149ULL,
0x000000bc00389947ULL, 0x006fea0003800000ULL, 0x01b0000026247984ULL, 0x000e620000000800ULL,
0x0000200004047892ULL, 0x000fe2000f8e0c3fULL, 0x00000001ff5f7424ULL, 0x000fe400078e00ffULL,
0x01b2000026577984ULL, 0x0004a20000000800ULL, 0x0001300008047890ULL, 0x000fcc000fffe004ULL,
0x0000000447287c11ULL, 0x000fe4000f8e20ffULL, 0x000000072400720bULL, 0x002fda0003f3d000ULL,
0x0000000000257806ULL, 0x000fc800008e0100ULL, 0x0000ffff25277812ULL, 0x000fda000782c0ffULL,
0x0000000000d89947ULL, 0x004fea0003800000ULL, 0x000000072400720bULL, 0x000fe40003f34000ULL,
0x0000002407297209ULL, 0x000fe40007810000ULL, 0x0000000253267811ULL, 0x000fc600078ff8ffULL,
0x8000002907257221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b25257820ULL, 0x000fe40000410000ULL,
0x0000000000077806ULL, 0x000fe400008e0100ULL, 0x000000532600720cULL, 0x000fe40003f25270ULL,
0x0000ffff072c7812ULL, 0x000fe200078e3cffULL, 0x0000002500257308ULL, 0x000e660000000800ULL,
0x0000002c27ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff5f7807ULL, 0x000fc60001000000ULL,
0x0000008053279824ULL, 0x000fe200078e0202ULL, 0x00001f4525077589ULL, 0x002e6a00000e0000ULL,
0x8000002924262221ULL, 0x000fe20000010000ULL, 0x0000002756569210ULL, 0x000fe20007ffe03bULL,
0x000000250a0a7220ULL, 0x000fe20000410000ULL, 0x00001f4425247589ULL, 0x000ea200000e0000ULL,
0x3fb8aa3b26262820ULL, 0x000fc60000410000ULL, 0x01b4002956009388ULL, 0x0007e20000000800ULL,
0x00000026000b2308ULL, 0x000f220000000800ULL, 0x0000000740407220ULL, 0x082fe20000410000ULL,
0x0000000741417220ULL, 0x080fe20000410000ULL, 0x0000000748487220ULL, 0x080fe20000410000ULL,
0x0000000749497220ULL, 0x080fe20000410000ULL, 0x000000074c4c7220ULL, 0x080fe20000410000ULL,
0x000000074d4d7220ULL, 0x080fe20000410000ULL, 0x0000000710107220ULL, 0x080fe20000410000ULL,
0x0000000711117220ULL, 0x080fe20000410000ULL, 0x0000000714147220ULL, 0x080fe20000410000ULL,
0x0000000715157220ULL, 0x080fe20000410000ULL, 0x0000000718187220ULL, 0x080fe20000410000ULL,
0x0000000719197220ULL, 0x080fe20000410000ULL, 0x000000071c1c7220ULL, 0x080fe20000410000ULL,
0x000000071d1d7220ULL, 0x080fe20000410000ULL, 0x0000000720207220ULL, 0x080fe20000410000ULL,
0x0000000721217220ULL, 0x000fe20000410000ULL, 0x0000002442427220ULL, 0x084fe20000410000ULL,
0x0000002443437220ULL, 0x080fe20000410000ULL, 0x000000244a4a7220ULL, 0x080fe20000410000ULL,
0x000000244b4b7220ULL, 0x080fe20000410000ULL, 0x000000244e4e7220ULL, 0x080fe20000410000ULL,
0x000000244f4f7220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x0000002422227220ULL, 0x080fe20000410000ULL,
0x0000002423237220ULL, 0x000fe20000410000ULL, 0x000000ffff077224ULL, 0x000fc400078e0029ULL,
0x000000570b572220ULL, 0x018fce0000410000ULL, 0x0000000000080947ULL, 0x000fea0003800000ULL,
0x0000002a310075a7ULL, 0x000e640008000149ULL, 0x000000b800508947ULL, 0x002fea0003800000ULL,
0x0000008039257811ULL, 0x040fe200078e18ffULL, 0x000000002828783bULL, 0x000e620000004200ULL,
0x00000004302c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000010a00788cULL, 0x000fe2000bf05270ULL,
0x0000010039277811ULL, 0x000fe200078e18ffULL, 0x0000000138247824ULL, 0x100fe200078e0225ULL,
0x0000000bff56723eULL, 0x000fe200000010ffULL, 0x000000013c257824ULL, 0x000fe200078e0225ULL,
0x000099105f5f7816ULL, 0x000fe200000000ffULL, 0x0000000138387824ULL, 0x100fe200078e0227ULL,
0x0000000424247c11ULL, 0x000fe2000f8e20ffULL, 0x000000013c277824ULL, 0x000fe200078e0227ULL,
0x0000000425257c11ULL, 0x000fe2000f8e20ffULL, 0x000000002c2c783bULL, 0x000ea20000004200ULL,
0x0000541056657816ULL, 0x000fe20000000056ULL, 0x0000000a570a7221ULL, 0x000fe20000010000ULL,
0x0000000427277c11ULL, 0x000fe2000f8e20ffULL, 0x000000002430783bULL, 0x0007220000004200ULL,
0x000000ff5f00720cULL, 0x000fc40003f05270ULL, 0x000000046e6e7c11ULL, 0x000fe2000f8e20ffULL,
0x000000002534783bULL, 0x0006a20000004200ULL, 0x0000000438387c11ULL, 0x000fe4000f8e20ffULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x0000040053247824ULL, 0x008fe200078e00ffULL,
0x00000000273c783bULL, 0x000fe80000004200ULL, 0xfffff80024257812ULL, 0x000fe200078ec0ffULL,
0x00001f4565597589ULL, 0x000fe800000e0000ULL, 0x0000000102257824ULL, 0x000fe200078e0225ULL,
0x00001f4465567589ULL, 0x0007e600000e0000ULL, 0x0000001046257824ULL, 0x000fe200078e0225ULL,
0x000000003838783bULL, 0x000fe20000004200ULL, 0x0000010028477824ULL, 0x042fe200078e00ffULL,
0x0000888028467816ULL, 0x040fe200000000ffULL, 0x0000010029607824ULL, 0x040fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011428ULL, 0x012000002524783bULL, 0x000e620000000200ULL,
0x00000018ff777819ULL, 0x000fe20000011447ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x0000888029477816ULL, 0x040fe200000000ffULL, 0x0000004600467306ULL, 0x000fe20000202400ULL,
0x00000018ff607819ULL, 0x000fe20000011460ULL, 0x000001002a447824ULL, 0x008fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011429ULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fc40000011428ULL, 0x000088802a5f7816ULL, 0x040fe200000000ffULL,
0x0000007700777306ULL, 0x000ee20000202400ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000018ff787819ULL, 0x000fe40000011444ULL, 0x00000018ff647819ULL, 0x000fe2000001142aULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001142bULL,
0x0000004700477306ULL, 0x000fe20000202400ULL, 0x00000018ff637819ULL, 0x004fc4000001142cULL,
0x00000018ff627819ULL, 0x000fe4000001142dULL, 0x00000018ff617819ULL, 0x000fe4000001142eULL,
0x00000018ff767819ULL, 0x000fe2000001142fULL, 0x0000006000607306ULL, 0x000ea20000202400ULL,
0x000000046f457c11ULL, 0x000fe2000f8e20ffULL, 0x000000010a047892ULL, 0x000fe2000f80c03fULL,
0x00000018ff757819ULL, 0x010fe40000011430ULL, 0x00000018ff747819ULL, 0x000fc40000011431ULL,
0x00000018ff727819ULL, 0x000fe20000011433ULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x00000018ff737819ULL, 0x000fe40000011432ULL, 0x00000018ff707819ULL, 0x000fe20000011435ULL,
0x0000005924248232ULL, 0x082fe20000200000ULL, 0x00000018ff697819ULL, 0x000fe20000011437ULL,
0x0000005926268232ULL, 0x000fe20000200000ULL, 0x00000018ff717819ULL, 0x000fe20000011434ULL,
0x0000002800657306ULL, 0x0006620000202400ULL, 0x0000005625258232ULL, 0x080fe20000200000ULL,
0x00000018ff6b7819ULL, 0x000fe20000011436ULL, 0x0000005627278232ULL, 0x000fe20000200000ULL,
0x00000018ff5e7819ULL, 0x000fc4000001143aULL, 0x00000018ff5d7819ULL, 0x000fe4000001143bULL,
0x0000005800587306ULL, 0x000fe20000202400ULL, 0x0000541046287816ULL, 0x008fe40000000077ULL,
0x00000018ff687819ULL, 0x000fe40000011438ULL, 0x00000018ff5b7819ULL, 0x000fe4000001143cULL,
0x00000018ff667819ULL, 0x000fe2000001143dULL, 0x0000002900777306ULL, 0x0004e20000202400ULL,
0x00000018ff677819ULL, 0x000fc40000011439ULL, 0x000000000000781cULL, 0x000fca0003f4f008ULL,
0x0000005f005f7306ULL, 0x000fe20000202400ULL, 0x0000541047297816ULL, 0x004fe20000000060ULL,
0x000001002b607824ULL, 0x000fe200078e00ffULL, 0x000000004544783bULL, 0x000eaa0000004200ULL,
0x000000282440723cULL, 0x000fe20000041840ULL, 0x0000007800787306ULL, 0x000f2c0000202400ULL,
0x0000541065287816ULL, 0x002fc4000000005cULL, 0x00000018ff657819ULL, 0x000fe20000011460ULL,
0x0000006400647306ULL, 0x000fe20000202400ULL, 0x000088802b297816ULL, 0x040fe200000000ffULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fca000001143eULL,
0x00000029005c7306ULL, 0x0007f00000202400ULL, 0x0000006500657306ULL, 0x000e620000202400ULL,
0x0000541077297816ULL, 0x008fce0000000058ULL, 0x000000282448723cULL, 0x000fe20000041848ULL,
0x0000005a005a7306ULL, 0x000fe20000202400ULL, 0x00000018ff587819ULL, 0x004fca0000011444ULL,
0x000054105f287816ULL, 0x010fe40000000078ULL, 0x000054105c297816ULL, 0x002fe20000000065ULL,
0x0000006300637306ULL, 0x000fe20000202400ULL, 0x00000018ff657819ULL, 0x000fe4000001142bULL,
0x0000888039787816ULL, 0x000fe400000000ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001143fULL,
0x00000028244c723cULL, 0x000fe2000004184cULL, 0x00000018ff5c7819ULL, 0x000fe20000011445ULL,
0x0000006500657306ULL, 0x000fea0000202400ULL, 0x00000018ff287819ULL, 0x000fc4000001142aULL,
0x000088802c2a7816ULL, 0x040fe200000000ffULL, 0x0000006200627306ULL, 0x000ff00000202400ULL,
0x0000002800297306ULL, 0x000e700000202400ULL, 0x0000002a002a7306ULL, 0x000fe20000202400ULL,
0x0000541029287816ULL, 0x002fe20000000064ULL, 0x000001002c297824ULL, 0x000fcc00078e00ffULL,
0x0000006100617306ULL, 0x000fe20000202400ULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe40000011429ULL, 0x0000541065297816ULL, 0x000fe4000000005aULL,
0x000088802d5a7816ULL, 0x040fe400000000ffULL, 0x0000007600767306ULL, 0x000fe20000202400ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x00000018ff657819ULL, 0x000fe20000011447ULL,
0x000000282410723cULL, 0x000fe80000041810ULL, 0x0000002c002c7306ULL, 0x000e660000202400ULL,
0x000001002d297824ULL, 0x000fc400078e00ffULL, 0x000100002d2d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff287224ULL, 0x000fe200078e005aULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000002b002b7306ULL, 0x000fe20000202400ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000018ff5a7819ULL, 0x000fe40000011446ULL, 0x000054102c2c7816ULL, 0x002fc60000000063ULL,
0x0000002d002d7306ULL, 0x000e620000202400ULL, 0x000088802e637816ULL, 0x000fce00000000ffULL,
0x0000002800647306ULL, 0x0005e20000202400ULL, 0x000054102d2d7816ULL, 0x002fce0000000062ULL,
0x0000002900297306ULL, 0x000e620000202400ULL, 0x000054102a287816ULL, 0x004fe2000000002bULL,
0x0000002c2418723cULL, 0x000fec0000041818ULL, 0x0000006300627306ULL, 0x000fe20000202400ULL,
0x000001002f2c7824ULL, 0x040fe200078e00ffULL, 0x000088802f2d7816ULL, 0x040fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x0000541064297816ULL, 0x002fe20000000029ULL,
0x000001002e647824ULL, 0x040fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x0000002d002d7306ULL, 0x000fe20000202400ULL,
0x00000018ff2f7819ULL, 0x000fc4000001142fULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x000000282428723cULL, 0x000fe20000041814ULL, 0x000000006e14783bULL, 0x0002a20000004200ULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x00000064006f7306ULL, 0x000ef00000202400ULL,
0x0000002c006e7306ULL, 0x0026700000202400ULL, 0x0000002e002e7306ULL, 0x000f220000202400ULL,
0x00005410622c7816ULL, 0x008fc4000000006fULL, 0x00008880356f7816ULL, 0x000fe400000000ffULL,
0x000054102d2d7816ULL, 0x002fc6000000006eULL, 0x0000002f002f7306ULL, 0x000e620000202400ULL,
0x00000100316e7824ULL, 0x000fc600078e00ffULL, 0x0000002c241c723cULL, 0x000fe4000004181cULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x0000007500757306ULL, 0x000fe60000202400ULL,
0x000054102e2c7816ULL, 0x010fe40000000061ULL, 0x000054102f2d7816ULL, 0x002fc60000000076ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x00008880302e7816ULL, 0x000fe400000000ffULL,
0x00000018ff637819ULL, 0x004fe40000011414ULL, 0x00000018ff647819ULL, 0x000fe20000011415ULL,
0x0000002c2420723cULL, 0x000fe20000041820ULL, 0x012000005024783bULL, 0x0002a20000000200ULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x00000018ff617819ULL, 0x000fe40000011417ULL,
0x00000018ff627819ULL, 0x000fc40000011416ULL, 0x00000100302d7824ULL, 0x040fe400078e00ffULL,
0x000000ffff2c7224ULL, 0x000fe200078e002eULL, 0x0000888033507816ULL, 0x002fe200000000ffULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142dULL,
0x0000007300737306ULL, 0x000fe20000202400ULL, 0x00008880312d7816ULL, 0x040fe200000000ffULL,
0x0001000031317824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fc80000011430ULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x0000002c002c7306ULL, 0x000ff00000202400ULL,
0x0000002e002f7306ULL, 0x0002f00000202400ULL, 0x0000002d002d7306ULL, 0x000f220000202400ULL,
0x00008880322e7816ULL, 0x002fe200000000ffULL, 0x0000005924248232ULL, 0x004fc40000200000ULL,
0x0000005926268232ULL, 0x000fe20000200000ULL, 0x000054102c2c7816ULL, 0x008fe2000000002fULL,
0x0000005625258232ULL, 0x080fe40000200000ULL, 0x0000003000307306ULL, 0x000fe20000202400ULL,
0x0000005627278232ULL, 0x000fe40000200000ULL, 0x000000ffff2f7224ULL, 0x000fe400078e002eULL,
0x00000100322e7824ULL, 0x040fe200078e00ffULL, 0x000054102d2d7816ULL, 0x010fe2000000006eULL,
0x0001000032327824ULL, 0x000fe200078e00ffULL, 0x0000003100317306ULL, 0x000e640000202400ULL,
0x00000018ff2e7819ULL, 0x000fc4000001142eULL, 0x00000018ff767819ULL, 0x000fe20000011432ULL,
0x0000002c2440723cULL, 0x000fe20000041840ULL, 0x0000888034327816ULL, 0x000fe400000000ffULL,
0x0000002f002f7306ULL, 0x000fe80000202400ULL, 0x00000100332c7824ULL, 0x040fe400078e00ffULL,
0x0001000033337824ULL, 0x000fc400078e00ffULL, 0x00000100342d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000002e002e7306ULL, 0x000ea20000202400ULL,
0x00000018ff777819ULL, 0x000fe20000011433ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff337819ULL, 0x000fe4000001142dULL, 0x00005410312d7816ULL, 0x002fe40000000074ULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000002c00797306ULL, 0x0003f00000202400ULL,
0x0000005000507306ULL, 0x000ee20000202400ULL, 0x00005410302c7816ULL, 0x002fc40000000075ULL,
0x0000888036307816ULL, 0x000fca00000000ffULL, 0x0000002c2448723cULL, 0x000fe20000041848ULL,
0x0000007200727306ULL, 0x000fec0000202400ULL, 0x00000100352c7824ULL, 0x040fe400078e00ffULL,
0x00000100362d7824ULL, 0x040fe200078e00ffULL, 0x0000007600767306ULL, 0x000fe20000202400ULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0001000036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011435ULL,
0x0000002c00747306ULL, 0x0005e20000202400ULL, 0x0000888037357816ULL, 0x000fce00000000ffULL,
0x0000007700777306ULL, 0x000e620000202400ULL, 0x000054102f2c7816ULL, 0x004fe4000000002eULL,
0x00000018ff2f7819ULL, 0x000fe4000001142dULL, 0x00005410502d7816ULL, 0x008fc60000000079ULL,
0x0000003200327306ULL, 0x000fe80000202400ULL, 0x0000002c244c723cULL, 0x000fe8000004184cULL,
0x0000003300337306ULL, 0x000ea60000202400ULL, 0x00000100372c7824ULL, 0x000fc400078e00ffULL,
0x0001000037377824ULL, 0x000fe400078e00ffULL, 0x00000100382d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000006f006f7306ULL, 0x000ee20000202400ULL,
0x00000018ff2e7819ULL, 0x000fe40000011437ULL, 0x00000018ff377819ULL, 0x000fe4000001142dULL,
0x00005410772d7816ULL, 0x002fc60000000072ULL, 0x0000002c00507306ULL, 0x0003f00000202400ULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x00005410762c7816ULL, 0x002fce0000000073ULL,
0x0000002c2410723cULL, 0x000fe20000041810ULL, 0x0000007000707306ULL, 0x000fec0000202400ULL,
0x00000100392c7824ULL, 0x040fe200078e00ffULL, 0x000088803a2d7816ULL, 0x000fe200000000ffULL,
0x00000034006e7306ULL, 0x0003e20000202400ULL, 0x0001000039397824ULL, 0x000fc400078e00ffULL,
0x00000018ff2c7819ULL, 0x000fc6000001142cULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000002c007a7306ULL, 0x0005e20000202400ULL, 0x00000018ff347819ULL, 0x002fe40000011436ULL,
0x0000888038367816ULL, 0x040fe200000000ffULL, 0x0001000038387824ULL, 0x000fc800078e00ffULL,
0x0000003100317306ULL, 0x000e620000202400ULL, 0x00005410322c7816ULL, 0x004fe20000000033ULL,
0x000001003a327824ULL, 0x040fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x000100003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000002d00337306ULL, 0x0007e20000202400ULL, 0x00000018ff777819ULL, 0x000fe4000001143aULL,
0x000088803c3a7816ULL, 0x000fca00000000ffULL, 0x0000003000307306ULL, 0x000fe20000202400ULL,
0x000054106f2d7816ULL, 0x008fe40000000074ULL, 0x000088803b747816ULL, 0x000fca00000000ffULL,
0x0000002c2428723cULL, 0x000fe20000041828ULL, 0x0000002f002f7306ULL, 0x000eac0000202400ULL,
0x000001003b2c7824ULL, 0x040fe400078e00ffULL, 0x000001003c2d7824ULL, 0x040fe200078e00ffULL,
0x0000003500357306ULL, 0x000ee20000202400ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fc4000001142dULL, 0x00005410312d7816ULL, 0x002fe40000000070ULL,
0x0000002c007b7306ULL, 0x0003e20000202400ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000088803d707816ULL, 0x000fe400000000ffULL,
0x000088803e317816ULL, 0x000fe200000000ffULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x000054106e2c7816ULL, 0x002fce0000000071ULL, 0x0000002c2418723cULL, 0x000fe20000041818ULL,
0x0000006900697306ULL, 0x000fec0000202400ULL, 0x000001003d2c7824ULL, 0x040fe400078e00ffULL,
0x000001003e2d7824ULL, 0x040fe200078e00ffULL, 0x0000003400347306ULL, 0x000fe20000202400ULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000002c00797306ULL, 0x0005e20000202400ULL, 0x00000018ff3e7819ULL, 0x000fce000001143eULL,
0x0000002e002e7306ULL, 0x000e620000202400ULL, 0x00005410302c7816ULL, 0x004fe4000000002fULL,
0x00000018ff307819ULL, 0x000fe4000001142dULL, 0x00005410352d7816ULL, 0x008fe40000000050ULL,
0x000088803f507816ULL, 0x040fe200000000ffULL, 0x0000003600367306ULL, 0x000fe80000202400ULL,
0x0000002c241c723cULL, 0x000fe8000004181cULL, 0x0000003700377306ULL, 0x000fe60000202400ULL,
0x000001003f2c7824ULL, 0x000fc400078e00ffULL, 0x00000100442d7824ULL, 0x000fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0000007800787306ULL, 0x000fe20000202400ULL, 0x00000018ff357819ULL, 0x000fe4000001142dULL,
0x000054102e2d7816ULL, 0x002fca0000000069ULL, 0x0000002c00737306ULL, 0x0003f00000202400ULL,
0x0000003200327306ULL, 0x000ea20000202400ULL, 0x00005410342c7816ULL, 0x002fe4000000006bULL,
0x00008880456b7816ULL, 0x000fca00000000ffULL, 0x0000002c242c723cULL, 0x000fe20000041820ULL,
0x012000000e24783bULL, 0x0002e20000000200ULL, 0x0000007400747306ULL, 0x000f2a0000202400ULL,
0x0000010045207824ULL, 0x000fe200078e00ffULL, 0x0000541033327816ULL, 0x004fe20000000032ULL,
0x00000100470e7824ULL, 0x002fe200078e00ffULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x0000010046227824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011420ULL,
0x0001000044207824ULL, 0x000fe200078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x0001000045457824ULL, 0x000fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fc40000011422ULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000541074337816ULL, 0x010fe4000000007bULL, 0x00000018ff457819ULL, 0x000fc60000011445ULL,
0x0000007700777306ULL, 0x000e700000202400ULL, 0x0000003b00727306ULL, 0x000ea20000202400ULL,
0x0000005924248232ULL, 0x008fce0000200000ULL, 0x00000038007d7306ULL, 0x0007e20000202400ULL,
0x0000005926268232ULL, 0x000fe40000200000ULL, 0x0000005625258232ULL, 0x080fe40000200000ULL,
0x0000005627278232ULL, 0x000fc60000200000ULL, 0x0000003c006e7306ULL, 0x0009e20000202400ULL,
0x0000888044387816ULL, 0x008fc600000000ffULL, 0x00000032244c723cULL, 0x000fe8000004184cULL,
0x0000002100447306ULL, 0x0007e20000202400ULL, 0x00000018ff3c7819ULL, 0x010fe4000001143fULL,
0x0000541077327816ULL, 0x002fe4000000005eULL, 0x0000541072337816ULL, 0x004fc6000000005dULL,
0x00000020003f7306ULL, 0x0003e20000202400ULL, 0x0000541078217816ULL, 0x008fc6000000007aULL,
0x000000322410723cULL, 0x000fe80000041810ULL, 0x0000003a003a7306ULL, 0x000fe20000202400ULL,
0x0000541036207816ULL, 0x002fe40000000037ULL, 0x0000888047367816ULL, 0x040fe200000000ffULL,
0x0001000047477824ULL, 0x000fe400078e00ffULL, 0x0001000015337824ULL, 0x000fc400078e00ffULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x000000202440723cULL, 0x000fe40000041840ULL,
0x00000018ff337819ULL, 0x000fca0000011433ULL, 0x0000007000707306ULL, 0x000fe20000202400ULL,
0x0000010014207824ULL, 0x000fca00078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe40000011420ULL,
0x0000003d00717306ULL, 0x000ff00000202400ULL, 0x0000000e003d7306ULL, 0x0003f00000202400ULL,
0x0000003900767306ULL, 0x0005e20000202400ULL, 0x00008880140e7816ULL, 0x042fe200000000ffULL,
0x0001000014147824ULL, 0x000fca00078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000005b005b7306ULL, 0x000fe20000202400ULL, 0x0000888046397816ULL, 0x044fe200000000ffULL,
0x0001000046467824ULL, 0x000fca00078e00ffULL, 0x00000018ff377819ULL, 0x000fe20000011446ULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x0000888015467816ULL, 0x000fce00000000ffULL,
0x0000003100317306ULL, 0x000ff00000202400ULL, 0x0000003000307306ULL, 0x000e700000202400ULL,
0x0000006800687306ULL, 0x000ea20000202400ULL, 0x0000541031307816ULL, 0x002fce0000000030ULL,
0x0000006700677306ULL, 0x000e620000202400ULL, 0x000054107d687816ULL, 0x004fce0000000068ULL,
0x0000006000607306ULL, 0x000fe20000202400ULL, 0x0000541076697816ULL, 0x002fce0000000067ULL,
0x0000005f005f7306ULL, 0x000fe20000202400ULL, 0x000000682448723cULL, 0x000fee0000041848ULL,
0x0000005000507306ULL, 0x000e700000202400ULL, 0x0000003e00757306ULL, 0x0004e20000202400ULL,
0x0000541050317816ULL, 0x002fce0000000073ULL, 0x0000003c003c7306ULL, 0x000e620000202400ULL,
0x00000018ff3e7819ULL, 0x004fe20000011447ULL, 0x0000010015477824ULL, 0x000fe200078e00ffULL,
0x0000541070157816ULL, 0x000fe20000000079ULL, 0x00000030241c723cULL, 0x000fe2000004181cULL,
0x00005410755e7816ULL, 0x008fc60000000060ULL, 0x0000001400327306ULL, 0x0005e20000202400ULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x000054103c5f7816ULL, 0x002fca000000005fULL,
0x0000003800347306ULL, 0x000fe20000202400ULL, 0x000054103a147816ULL, 0x004fe4000000006fULL,
0x00008880163a7816ULL, 0x000fe200000000ffULL, 0x0000005e242c723cULL, 0x000fe8000004182cULL,
0x0000002200387306ULL, 0x0003e40000202400ULL, 0x000000142428723cULL, 0x000fec0000041828ULL,
0x0000003500357306ULL, 0x000ea20000202400ULL, 0x012000006c20783bULL, 0x002e620000000200ULL,
0x0000205409ff79a7ULL, 0x0007e2000850003fULL, 0x000054106e147816ULL, 0x000fc4000000005bULL,
0x0000541071157816ULL, 0x000fc60000000066ULL, 0x0000006b006b7306ULL, 0x000f220000202400ULL,
0x01b6305455ff79a7ULL, 0x0007e6000850003fULL, 0x000000142418723cULL, 0x000fe20000041818ULL,
0x0000541034347816ULL, 0x004fc60000000035ULL, 0x0000003900397306ULL, 0x000ea60000202400ULL,
0x0000010016147824ULL, 0x040fe200078e00ffULL, 0x0000888017157816ULL, 0x040fe200000000ffULL,
0x0000010017257824ULL, 0x040fe400078e00ffULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x0000000e000e7306ULL, 0x000fe20000202400ULL, 0x000054106b357816ULL, 0x010fc40000000044ULL,
0x00000018ff267819ULL, 0x000fe40000011417ULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000541039387816ULL, 0x004fe20000000038ULL, 0x0000001400317306ULL, 0x0005e20000202400ULL,
0x0000005920208232ULL, 0x002fce0000200000ULL, 0x0000003b003b7306ULL, 0x000fe20000202400ULL,
0x00000018ff147819ULL, 0x004fe20000011425ULL, 0x0000005922228232ULL, 0x000fe40000200000ULL,
0x0000005621218232ULL, 0x080fe40000200000ULL, 0x0000005623238232ULL, 0x000fe20000200000ULL,
0x000000ff6aff7812ULL, 0x000fe2000780c0ffULL, 0x0000005800587306ULL, 0x000e660000202400ULL,
0x00000001ff6a9807ULL, 0x000fc40000000000ULL, 0x000000342040723cULL, 0x000fe20000041840ULL,
0x000000ff52ff7812ULL, 0x000fe4000782c0ffULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x000000ff6aff7812ULL, 0x000fe4000780c0ffULL, 0x00000001ff697807ULL, 0x000fe40004800000ULL,
0x00000001ff6aa807ULL, 0x000fe40000000000ULL, 0x000054103f447816ULL, 0x002fe20000000058ULL,
0x0000005a005a7306ULL, 0x000fe20000202400ULL, 0x000076106a687816ULL, 0x000fce0000000068ULL,
0x0000006500657306ULL, 0x000ff00000202400ULL, 0x0000006300637306ULL, 0x000e700000202400ULL,
0x0000006400647306ULL, 0x000fe20000202400ULL, 0x0000541032327816ULL, 0x002fce0000000063ULL,
0x0000004500457306ULL, 0x000e700000202400ULL, 0x0000003600367306ULL, 0x000ea20000202400ULL,
0x0000541045457816ULL, 0x002fce000000005cULL, 0x0000003700377306ULL, 0x000e620000202400ULL,
0x000000442048723cULL, 0x000fe20000041848ULL, 0x0000541036397816ULL, 0x004fcc000000003dULL,
0x0000003e003e7306ULL, 0x000ea20000202400ULL, 0x00000038204c723cULL, 0x000fe2000004184cULL,
0x00005410375a7816ULL, 0x002fcc000000005aULL, 0x0000004600467306ULL, 0x000fe20000202400ULL,
0x000054103e5b7816ULL, 0x004fce0000000065ULL, 0x0000004700477306ULL, 0x000fe20000202400ULL,
0x0000005a2010723cULL, 0x000fee0000041810ULL, 0x0000003300337306ULL, 0x000e700000202400ULL,
0x0000003a003a7306ULL, 0x000ea20000202400ULL, 0x0000541033337816ULL, 0x002fce0000000064ULL,
0x0000001500247306ULL, 0x0003e20000202400ULL, 0x000000322018723cULL, 0x000fe20000041818ULL,
0x000054103a3a7816ULL, 0x004fcc0000000031ULL, 0x0000001400277306ULL, 0x0005220000202400ULL,
0x0000541046157816ULL, 0x002fce0000000047ULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x000054100e147816ULL, 0x004fe4000000003bULL, 0x00005410243b7816ULL, 0x010fca0000000027ULL,
0x0000006100617306ULL, 0x000fe40000202400ULL, 0x0000003a201c723cULL, 0x000fec000004181cULL,
0x0000001600257306ULL, 0x0002b00000202400ULL, 0x0000002600267306ULL, 0x000f220000202400ULL,
0x000000142014723cULL, 0x002fe20000041828ULL, 0x0000541025607816ULL, 0x004fc40000000062ULL,
0x0000541026617816ULL, 0x010fce0000000061ULL, 0x000000602020723cULL, 0x008fde000004182cULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000100517824ULL, 0x000fe200078e0251ULL,
0x000000ff0cff7812ULL, 0x000fc8000780c0ffULL, 0x0000000651007c0cULL, 0x000fe4000bf26070ULL,
0x00000001ff0c7807ULL, 0x000fd60000000000ULL, 0xffffffa400b49947ULL, 0x020fea000383ffffULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x000000026d037824ULL, 0x000fe400078e00ffULL,
0x0001b00002067836ULL, 0x000fe20000000000ULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000000203087812ULL, 0x000fe200078e0cffULL, 0x0000008053037824ULL, 0x000fc600078e0206ULL,
0x0000000108097812ULL, 0x000fca00078ef853ULL, 0x0000008009097824ULL, 0x000fe400078e0206ULL,
0x0000001004057824ULL, 0x022fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x100fe40000011604ULL,
0x00000002ff287819ULL, 0x000fe40000011604ULL, 0x00000070050e7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b247812ULL, 0x000fe400078ec0ffULL, 0x000002000e057810ULL, 0x000fc40007ffe003ULL,
0x0000000324067210ULL, 0x140fe40007ffe00eULL, 0x0000000924037210ULL, 0x040fe20007ffe00eULL,
0x0000000124057824ULL, 0x000fe200078e0205ULL, 0x000002000e097810ULL, 0x000fe20007ffe009ULL,
0x0000000706007388ULL, 0x000fe80000000800ULL, 0x0000000a05007388ULL, 0x000fe20000000800ULL,
0x0000000124097824ULL, 0x000fe200078e0209ULL, 0x0000000804247811ULL, 0x000fe200078ff0ffULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000003037984ULL, 0x000e680000000800ULL,
0x0000000009097984ULL, 0x000ea20000000800ULL, 0x0000000703087209ULL, 0x002fca0007810000ULL,
0x8000000803037221ULL, 0x000fe20000010000ULL, 0x00000007080b7221ULL, 0x000fc60000010100ULL,
0x3fb8aa3b03057820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fe20000410000ULL,
0x0000000000037919ULL, 0x000e640000002500ULL, 0x0000000500067308ULL, 0x000eb00000000800ULL,
0x0000000b000b7308ULL, 0x000ee20000000800ULL, 0x0000000609067220ULL, 0x004fe20000410000ULL,
0x00001f280b0c7589ULL, 0x008ea600000e0000ULL, 0x0000000a0b0a7223ULL, 0x000fe20000010006ULL,
0x00001f240b077589ULL, 0x000ee200000e0000ULL, 0x0000000603007c0cULL, 0x002fe2000bf06070ULL,
0x000000400c407220ULL, 0x044fe20000410000ULL, 0x000000410c417220ULL, 0x040fe20000410000ULL,
0x000000480c487220ULL, 0x040fe20000410000ULL, 0x000000490c497220ULL, 0x040fe20000410000ULL,
0x0000004c0c4c7220ULL, 0x040fe20000410000ULL, 0x0000004d0c4d7220ULL, 0x040fe20000410000ULL,
0x000000100c107220ULL, 0x040fe20000410000ULL, 0x000000110c117220ULL, 0x040fe20000410000ULL,
0x000000140c147220ULL, 0x040fe20000410000ULL, 0x000000150c157220ULL, 0x040fe20000410000ULL,
0x000000180c187220ULL, 0x040fe20000410000ULL, 0x000000190c197220ULL, 0x040fe20000410000ULL,
0x0000001c0c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d0c1d7220ULL, 0x040fe20000410000ULL,
0x000000200c207220ULL, 0x040fe20000410000ULL, 0x000000210c217220ULL, 0x000fe20000410000ULL,
0x0000004207427220ULL, 0x048fe20000410000ULL, 0x0000004307437220ULL, 0x040fe20000410000ULL,
0x0000004a074a7220ULL, 0x040fe20000410000ULL, 0x0000004b074b7220ULL, 0x040fe20000410000ULL,
0x0000004e074e7220ULL, 0x040fe20000410000ULL, 0x0000004f074f7220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001607167220ULL, 0x040fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x000fe20000410000ULL,
0x0000000000d80947ULL, 0x000fec0003800000ULL, 0x018000000a047836ULL, 0x000fe20000000000ULL,
0x000000c000007945ULL, 0x000fe80003800000ULL, 0x7f80000004047812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000738000067802ULL, 0x000fce0000000f00ULL, 0x0000009c00407944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x00cfe200078e0004ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000a00057308ULL, 0x000e640000001000ULL, 0xbf8000000a047423ULL, 0x002fc80000000005ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000405057223ULL, 0x000fce0000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009400ff067b82ULL, 0x000ea40000000a00ULL,
0x0000000e06067981ULL, 0x004ea2000c1e9900ULL, 0x0000000000047919ULL, 0x000ee40000000000ULL,
0x00000002ff287819ULL, 0x008fe40000011604ULL, 0x0000000804247811ULL, 0x000fe200078ff0ffULL,
0x0000000506057220ULL, 0x004fca0000410000ULL, 0x00001f2805097589ULL, 0x000ea800000e0000ULL,
0x00001f24050b7589ULL, 0x000ee200000e0000ULL, 0x0000000940407220ULL, 0x084fe20000410000ULL,
0x0000000941417220ULL, 0x080fe20000410000ULL, 0x0000000948487220ULL, 0x080fe20000410000ULL,
0x0000000949497220ULL, 0x080fe20000410000ULL, 0x000000094c4c7220ULL, 0x080fe20000410000ULL,
0x000000094d4d7220ULL, 0x080fe20000410000ULL, 0x0000000910107220ULL, 0x080fe20000410000ULL,
0x0000000911117220ULL, 0x080fe20000410000ULL, 0x0000000914147220ULL, 0x080fe20000410000ULL,
0x0000000915157220ULL, 0x080fe20000410000ULL, 0x0000000918187220ULL, 0x080fe20000410000ULL,
0x0000000919197220ULL, 0x080fe20000410000ULL, 0x000000091c1c7220ULL, 0x080fe20000410000ULL,
0x000000091d1d7220ULL, 0x080fe20000410000ULL, 0x0000000920207220ULL, 0x080fe20000410000ULL,
0x0000000921217220ULL, 0x000fe20000410000ULL, 0x0000000b42427220ULL, 0x088fe20000410000ULL,
0x0000000b43437220ULL, 0x080fe20000410000ULL, 0x0000000b4a4a7220ULL, 0x080fe20000410000ULL,
0x0000000b4b4b7220ULL, 0x080fe20000410000ULL, 0x0000000b4e4e7220ULL, 0x080fe20000410000ULL,
0x0000000b4f4f7220ULL, 0x080fe20000410000ULL, 0x0000000b12127220ULL, 0x080fe20000410000ULL,
0x0000000b13137220ULL, 0x080fe20000410000ULL, 0x0000000b16167220ULL, 0x080fe20000410000ULL,
0x0000000b17177220ULL, 0x080fe20000410000ULL, 0x0000000b1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000b1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000b1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000b1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000b22227220ULL, 0x080fe20000410000ULL,
0x0000000b23237220ULL, 0x000fce0000410000ULL, 0x0000000204057812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000404140723eULL, 0x000fe400000010ffULL,
0x00000004050d7811ULL, 0x040fe400078ff8ffULL, 0x00000001ff077819ULL, 0x000fe40000011605ULL,
0x000000070d0e7812ULL, 0x000fe400078e7828ULL, 0x0000000205097811ULL, 0x000fc400078ff8ffULL,
0x0000000605257811ULL, 0x000fe200078ff8ffULL, 0x0000000828267824ULL, 0x000fe200078e020eULL,
0x0000000707057812ULL, 0x000fe200078e7828ULL, 0x000010000f0e7824ULL, 0x000fe200078e0202ULL,
0x0000000707077812ULL, 0x000fe200078e7824ULL, 0x0000000804027824ULL, 0x000fe200078e00ffULL,
0x00000007090b7812ULL, 0x000fe200078e7828ULL, 0x0000000828067824ULL, 0x000fe200078e0205ULL,
0x0000000725277812ULL, 0x000fe200078e7828ULL, 0x000008006d057824ULL, 0x000fe200078e020eULL,
0x0000000709097812ULL, 0x000fe200078e7824ULL, 0x00000008242a7824ULL, 0x000fe200078e0207ULL,
0x000000070d0d7812ULL, 0x000fe200078e7824ULL, 0x0000001026267824ULL, 0x000fe200078e0205ULL,
0x0000000725257812ULL, 0x000fe200078e7824ULL, 0x00000008280c7824ULL, 0x000fe200078e020bULL,
0x0000000802077812ULL, 0x000fe200078ec0ffULL, 0x00000008242c7824ULL, 0x040fe200078e0209ULL,
0x000000484948723eULL, 0x000fe200000010ffULL, 0x00000008242e7824ULL, 0x000fe200078e020dULL,
0x0000004c4d4c723eULL, 0x000fe200000010ffULL, 0x0000001006067824ULL, 0x000fe200078e0205ULL,
0x000000141514723eULL, 0x000fe200000010ffULL, 0x0000000828287824ULL, 0x000fe200078e0227ULL,
0x000000181918723eULL, 0x000fe200000010ffULL, 0x0000000824247824ULL, 0x000fe200078e0225ULL,
0x0000001c1d1c723eULL, 0x000fe200000010ffULL, 0x0000000107027824ULL, 0x000fe200078e0226ULL,
0x000000101126723eULL, 0x000fe200000010ffULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x0000541040107816ULL, 0x100fe20000000048ULL, 0x000000100c0c7824ULL, 0x100fe200078e0205ULL,
0x0000763240117816ULL, 0x000fe20000000048ULL, 0x000000102a2a7824ULL, 0x100fe200078e0205ULL,
0x000000202120723eULL, 0x000fe200000010ffULL, 0x0000001028287824ULL, 0x100fe200078e0205ULL,
0x000000424342723eULL, 0x000fe200000010ffULL, 0x000000102c2c7824ULL, 0x100fe200078e0205ULL,
0x0000001006007388ULL, 0x0005e20000000a00ULL, 0x000000102e2e7824ULL, 0x100fe200078e0205ULL,
0x0000004a4b21723eULL, 0x000fe200000010ffULL, 0x0000001024247824ULL, 0x000fe200078e0205ULL,
0x0000004e4f4e723eULL, 0x000fe200000010ffULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000121327723eULL, 0x000fe200000010ffULL, 0x00000001072a7824ULL, 0x000fe200078e022aULL,
0x000000161716723eULL, 0x000fe200000010ffULL, 0x0000000107287824ULL, 0x000fe200078e0228ULL,
0x0000001a1b0b723eULL, 0x000fe200000010ffULL, 0x00000001072c7824ULL, 0x040fe200078e022cULL,
0x000054104c067816ULL, 0x044fe20000000026ULL, 0x00000001072e7824ULL, 0x000fe200078e022eULL,
0x0000001e1f1e723eULL, 0x000fe200000010ffULL, 0x0000000107247824ULL, 0x000fe200078e0224ULL,
0x000076324c077816ULL, 0x000fe20000000026ULL, 0x000000206d197824ULL, 0x000fe200078e0204ULL,
0x000054104e267816ULL, 0x000fc40000000027ULL, 0x000076324e277816ULL, 0x000fe20000000027ULL,
0x000000060c007388ULL, 0x0005e20000000a00ULL, 0x000000222322723eULL, 0x000fe200000010ffULL,
0x0000001019097824ULL, 0x000fe200078e020eULL, 0x000000010000780cULL, 0x000fe40003f05270ULL,
0x0000541014067816ULL, 0x144fe40000000018ULL, 0x0000763214077816ULL, 0x000fca0000000018ULL,
0x0000000602007388ULL, 0x0005e40000000a00ULL, 0x000054101c067816ULL, 0x144fe20000000020ULL,
0x000000ff00027306ULL, 0x000ea20000202400ULL, 0x000076321c077816ULL, 0x000fe40000000020ULL,
0x0000541042207816ULL, 0x140fe40000000021ULL, 0x0000763242217816ULL, 0x000fe20000000021ULL,
0x0000000628007388ULL, 0x0007e80000000a00ULL, 0x000000202a007388ULL, 0x000fe80000000a00ULL,
0x000000262c007388ULL, 0x000fe20000000a00ULL, 0x0000541016067816ULL, 0x008fc4000000000bULL,
0x0000763216077816ULL, 0x000fca000000000bULL, 0x000000062e007388ULL, 0x0007e40000000a00ULL,
0x000054101e067816ULL, 0x148fe40000000022ULL, 0x000076321e077816ULL, 0x000fca0000000022ULL,
0x0000000624007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000009107984ULL, 0x000ea80000000c00ULL, 0x00040000091c7984ULL, 0x000ee80000000c00ULL,
0x0008000009147984ULL, 0x000f280000000c00ULL, 0x000c000009207984ULL, 0x000f620000000c00ULL,
0x0000001302137230ULL, 0x004fc40000200800ULL, 0x0000001202127230ULL, 0x040fe40000200800ULL,
0x0000001102117230ULL, 0x040fe40000200800ULL, 0x0000001002107230ULL, 0x040fe40000200800ULL,
0x0000001f021f7230ULL, 0x048fe40000200800ULL, 0x0000001e021e7230ULL, 0x040fe40000200800ULL,
0x0000001d021d7230ULL, 0x000fc40000200800ULL, 0x0000001c02027230ULL, 0x000fe40000200800ULL,
0x0000001713137230ULL, 0x010fe40000200000ULL, 0x0000001612127230ULL, 0x000fe40000200000ULL,
0x0000001511117230ULL, 0x000fe40000200000ULL, 0x0000001410107230ULL, 0x000fe40000200000ULL,
0x000000231f1f7230ULL, 0x020fc40000200000ULL, 0x000000221e1e7230ULL, 0x000fe20000200000ULL,
0x0000001009007388ULL, 0x0005e20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000200000ULL,
0x00000020021c7230ULL, 0x000fca0000200000ULL, 0x0004001c09007388ULL, 0x0005e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000002800608947ULL, 0x000fea0003800000ULL,
0x00000000000b7919ULL, 0x000ee20000002700ULL, 0x00008400ff0d7b82ULL, 0x000ee20000000800ULL,
0x00000800531e7824ULL, 0x004fe200078e00ffULL, 0x000000016dff7812ULL, 0x000fe2000780f853ULL,
0x0000000000027919ULL, 0x000ee20000002600ULL, 0x0000040000207802ULL, 0x000fe20000000f00ULL,
0x00000040191b7836ULL, 0x000fe20000000000ULL, 0x000008001e1e7812ULL, 0x000fe200078ee2ffULL,
0x0000000009107984ULL, 0x0004a20000000c00ULL, 0x00009200ff1f7b82ULL, 0x000f260000000800ULL,
0x0004000009147984ULL, 0x0004a20000000c00ULL, 0x0000000000217919ULL, 0x000f680000008800ULL,
0x00009800ff067b82ULL, 0x000ea20000000a00ULL, 0x0000000d0b0b7224ULL, 0x008fc400078e0202ULL,
0x0000000d00027224ULL, 0x000fe400078e02ffULL, 0x000000000b1c7224ULL, 0x000fe400078e02ffULL,
0x0000001f021f7224ULL, 0x010fe400078e02ffULL, 0x000000011c227824ULL, 0x000fc600078e0203ULL,
0x00000fff1f1d7811ULL, 0x000fe400078e40ffULL, 0x0000065421207816ULL, 0x020fe40000000020ULL,
0x000000221d037211ULL, 0x000fe400078fa0ffULL, 0x01ffffff1f1f7812ULL, 0x000fc600078ec0ffULL,
0x0000100003027825ULL, 0x006fc600078e0006ULL, 0x0000001e02027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fe200008e0603ULL, 0x000000ff0400720cULL, 0x000fe20000725670ULL,
0x0000001019187825ULL, 0x000fc800078e0002ULL, 0x000000101b1a7825ULL, 0x000fe200078e0002ULL,
0x0000000000380947ULL, 0x000fee0003800000ULL, 0x00009800ff0c7b82ULL, 0x000e620000000a00ULL,
0x0000001004217824ULL, 0x000fe200078e00ffULL, 0x00000001ff237819ULL, 0x000fe20000011604ULL,
0x0000000122097824ULL, 0x000fc600078e021fULL, 0x0000007021217812ULL, 0x000fe400078ec0ffULL,
0x0000000c23237812ULL, 0x000fe200078ec0ffULL, 0x0000008022027825ULL, 0x002fc800078e000cULL,
0x00000080090c7825ULL, 0x000fe200078e000cULL, 0x0000000223027210ULL, 0x140fe40007a1e021ULL,
0x0000000c230c7210ULL, 0x000fe40007c7e021ULL, 0x00000003ff037210ULL, 0x000fe400007e44ffULL,
0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL, 0x0000000802007986ULL, 0x0003e8000c10190eULL,
0x0000000a0c007986ULL, 0x0003e4000c10190eULL, 0x0000001018007986ULL, 0x0005e8000c101d0eULL,
0x000000141a007986ULL, 0x0005e2000c101d0eULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000004c1947ULL, 0x000fea0003800000ULL, 0x00009600ff027b82ULL, 0x002e620000000a00ULL,
0xffffffff00097836ULL, 0x000fe40000000000ULL, 0x000000040b027825ULL, 0x002fe200078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x0003ec0000008000ULL, 0x0000000000007992ULL, 0x002fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000009020279a8ULL, 0x000ee800099ee1ceULL, 0x00000000ff00798fULL, 0x008fe20002000000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fc40000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x000000090200720cULL, 0x000fc80003f05270ULL,
0x00000001ff087807ULL, 0x000fca0000000000ULL, 0x00000008ff007988ULL, 0x0003e80008000004ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000020027984ULL, 0x002e640000000000ULL, 0x000000ff0200720cULL, 0x002fda0003f05270ULL,
0x0000002400448947ULL, 0x000fea0003800000ULL, 0x000000ff5300720cULL, 0x000fda0003f05270ULL,
0x0000000c00300947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x0000000000d88947ULL, 0x000fea0003800000ULL, 0x0000001004087824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011604ULL, 0x000000011c097836ULL, 0x040fe40000000000ULL,
0x000000801c027825ULL, 0x100fe200078e0006ULL, 0x0000007008177812ULL, 0x004fe400078ec0ffULL,
0x0000000c0a0c7812ULL, 0x000fe200078ec0ffULL, 0x0000008009087825ULL, 0x000fc600078e0006ULL,
0x000000020c0a7210ULL, 0x140fe4000791e017ULL, 0x000000080c087210ULL, 0x000fe40007b5e017ULL,
0x00000003ff0b7210ULL, 0x000fe400007e24ffULL, 0x00000009ff097210ULL, 0x000fc600017e64ffULL,
0x0000000e0a027981ULL, 0x000368000c1e1900ULL, 0x0000000e08037981ULL, 0x000362000c1e1900ULL,
0x000000020000780cULL, 0x000fda0003f05270ULL, 0x00000000009c8947ULL, 0x002fea0003800000ULL,
0x000000021c097836ULL, 0x000fc80000000000ULL, 0x0000008009087825ULL, 0x000fc600078e0006ULL,
0x000000080c087210ULL, 0x000fc8000791e017ULL, 0x00000009ff097210ULL, 0x000fcc00007e24ffULL,
0x0000000e08097981ULL, 0x000362000c1e1900ULL, 0x000000040000780cULL, 0x000fda0003f06070ULL,
0x0000000000808947ULL, 0x002fea0003800000ULL, 0x000000031c0b7836ULL, 0x000fc80000000000ULL,
0x000000800b0a7825ULL, 0x000fc600078e0006ULL, 0x0000000a0c0a7210ULL, 0x000fc8000791e017ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x0000000e0a0d7981ULL, 0x000362000c1e1900ULL,
0x000000040000780cULL, 0x000fda0003f05270ULL, 0x0000000000648947ULL, 0x002fea0003800000ULL,
0x000000041c0b7836ULL, 0x000fc80000000000ULL, 0x000000800b0a7825ULL, 0x000fc600078e0006ULL,
0x0000000a0c0a7210ULL, 0x000fc8000791e017ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x0000000e0a117981ULL, 0x000362000c1e1900ULL, 0x000000060000780cULL, 0x000fda0003f06070ULL,
0x0000000000488947ULL, 0x002fea0003800000ULL, 0x000000051c0b7836ULL, 0x000fc80000000000ULL,
0x000000800b0a7825ULL, 0x000fc600078e0006ULL, 0x0000000a0c0a7210ULL, 0x000fc8000791e017ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x0000000e0a137981ULL, 0x000362000c1e1900ULL,
0x000000060000780cULL, 0x000fda0003f05270ULL, 0x00000000002c8947ULL, 0x002fea0003800000ULL,
0x000000080000780cULL, 0x000fe20003f06070ULL, 0x000000061c0b7836ULL, 0x000fc80000000000ULL,
0x000000800b0a7825ULL, 0x000fc600078e0006ULL, 0x0000000a0c0a7210ULL, 0x000fca0007a3e017ULL,
0x000000071c150836ULL, 0x000fe20000000000ULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x0000008015060825ULL, 0x000fe400078e0006ULL, 0x0000000e0a157981ULL, 0x000362000c1e1900ULL,
0x000000060c060210ULL, 0x000fc80007c7e017ULL, 0x00000007ff070210ULL, 0x000fca0001fe84ffULL,
0x0000000e06170981ULL, 0x000368000c1e1900ULL, 0x0000000700067836ULL, 0x002fca0000000000ULL,
0x00000003ff0c7819ULL, 0x000fc80000011606ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000000800248947ULL, 0x000fea0003800000ULL, 0x00009800ff067b82ULL, 0x000e620000000a00ULL,
0x000000ffff107224ULL, 0x004fe200078e001cULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff197224ULL, 0x020fe200078e0002ULL, 0x0000003f00057c82ULL, 0x000fcc0008000000ULL,
0x0000000400007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x000000050c007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400f41947ULL, 0x022fee0003800000ULL,
0x0000000804067890ULL, 0x000fe2000fffe03fULL, 0x0000001902027209ULL, 0x000fe20007810000ULL,
0x0000000104077890ULL, 0x000fc8000fffe03fULL, 0x0000000600007c0cULL, 0x040fe4000bf23070ULL,
0x0000000700007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001004087824ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011604ULL,
0x00000008100b7836ULL, 0x000fc60000000000ULL, 0x0000007008197812ULL, 0x000fe200078ec0ffULL,
0x000000800b0a7825ULL, 0x002fe200078e0006ULL, 0x0000000c12127812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e019ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x0000000e0a197981ULL, 0x000368000c1e1900ULL, 0x0000000400b42947ULL, 0x000fea0003800000ULL,
0x0000000904067890ULL, 0x000fe2000fffe03fULL, 0x0000000302027209ULL, 0x000fe20007810000ULL,
0x0000000204077890ULL, 0x000fc8000fffe03fULL, 0x0000000600007c0cULL, 0x040fe4000bf23070ULL,
0x0000000700007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001004037824ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fe20000011604ULL,
0x00000009100b7836ULL, 0x002fc60000000000ULL, 0x0000007003037812ULL, 0x000fe200078ec0ffULL,
0x000000800b0a7825ULL, 0x000fe200078e0006ULL, 0x0000000c08087812ULL, 0x000fc800078ec0ffULL,
0x0000000a080a7210ULL, 0x000fc80007b3e003ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x0000000e0a037981ULL, 0x000368000c1e1900ULL, 0x0000000400742947ULL, 0x000fea0003800000ULL,
0x0000000a04067890ULL, 0x000fe2000fffe03fULL, 0x0000000902027209ULL, 0x000fe20007810000ULL,
0x0000000304077890ULL, 0x000fc8000fffe03fULL, 0x0000000600007c0cULL, 0x040fe4000bf23070ULL,
0x0000000700007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001004087824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x002fe20000011604ULL,
0x0000000a10097836ULL, 0x000fc60000000000ULL, 0x00000070080b7812ULL, 0x000fe200078ec0ffULL,
0x0000008009087825ULL, 0x000fe200078e0006ULL, 0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL,
0x000000080a087210ULL, 0x000fc80007b3e00bULL, 0x00000009ff097210ULL, 0x000fcc0000fe64ffULL,
0x0000000e08097981ULL, 0x000366000c1e1900ULL, 0x0000000400342947ULL, 0x000fea0003800000ULL,
0x0000000b04067890ULL, 0x000fe2000fffe03fULL, 0x0000000d02027209ULL, 0x000fe20007810000ULL,
0x0000000404077890ULL, 0x000fc8000fffe03fULL, 0x0000000600007c0cULL, 0x040fe4000bf23070ULL,
0x0000000700007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001004087824ULL, 0x002fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011604ULL,
0x0000000b100b7836ULL, 0x000fc60000000000ULL, 0x00000070080d7812ULL, 0x000fe200078ec0ffULL,
0x000000800b0a7825ULL, 0x000fe200078e0006ULL, 0x0000000c12127812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e00dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x0000000e0a0d7981ULL, 0x000368000c1e1900ULL, 0x0000000000f42947ULL, 0x000fea0003800000ULL,
0x0000000c04067890ULL, 0x000fe2000fffe03fULL, 0x0000001102027209ULL, 0x000fe20007810000ULL,
0x0000000504077890ULL, 0x000fc8000fffe03fULL, 0x0000000600007c0cULL, 0x040fe4000bf23070ULL,
0x0000000700007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001004087824ULL, 0x002fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011604ULL,
0x0000000c100b7836ULL, 0x000fc60000000000ULL, 0x0000007008117812ULL, 0x000fe200078ec0ffULL,
0x000000800b0a7825ULL, 0x000fe200078e0006ULL, 0x0000000c12127812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x0000000e0a117981ULL, 0x000368000c1e1900ULL, 0x0000000000b42947ULL, 0x000fea0003800000ULL,
0x0000000d04067890ULL, 0x000fe2000fffe03fULL, 0x0000001302027209ULL, 0x000fe20007810000ULL,
0x0000000604077890ULL, 0x000fc8000fffe03fULL, 0x0000000600007c0cULL, 0x040fe4000bf23070ULL,
0x0000000700007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001004087824ULL, 0x002fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011604ULL,
0x0000000d100b7836ULL, 0x000fc60000000000ULL, 0x0000007008137812ULL, 0x000fe200078ec0ffULL,
0x000000800b0a7825ULL, 0x000fe200078e0006ULL, 0x0000000c12127812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e013ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x0000000e0a137981ULL, 0x000368000c1e1900ULL, 0x0000000000742947ULL, 0x000fea0003800000ULL,
0x0000000e04067890ULL, 0x000fe2000fffe03fULL, 0x0000001502027209ULL, 0x000fe20007810000ULL,
0x0000000704077890ULL, 0x000fc8000fffe03fULL, 0x0000000600007c0cULL, 0x040fe4000bf23070ULL,
0x0000000700007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001004087824ULL, 0x002fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011604ULL,
0x0000000e100b7836ULL, 0x000fc60000000000ULL, 0x0000007008157812ULL, 0x000fe200078ec0ffULL,
0x000000800b0a7825ULL, 0x000fe200078e0006ULL, 0x0000000c12127812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e015ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x0000000e0a157981ULL, 0x000368000c1e1900ULL, 0x0000000000342947ULL, 0x000fea0003800000ULL,
0x0000000f04067890ULL, 0x000fe2000fffe03fULL, 0x0000001702027209ULL, 0x000fca0007810000ULL,
0x0000000600007c0cULL, 0x000fda000bf23070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001004087824ULL, 0x002fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011604ULL,
0x0000000f100b7836ULL, 0x000fc60000000000ULL, 0x0000007008177812ULL, 0x000fe200078ec0ffULL,
0x000000800b0a7825ULL, 0x000fe200078e0006ULL, 0x0000000c12127812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007a3e017ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x0000000e0a177981ULL, 0x000368000c1e1900ULL, 0x0000000804047890ULL, 0x000fe2000fffe03fULL,
0x0000000810107836ULL, 0x000fe20000000000ULL, 0xfffffff400f08947ULL, 0x000ff4000383ffffULL,
0x0000000000047919ULL, 0x000ee40000000000ULL, 0x0000001004037824ULL, 0x028fe200078e00ffULL,
0x00000001ff067819ULL, 0x002fc80000011604ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ec0ffULL, 0x0000002006037210ULL, 0x000fca0007ffe003ULL,
0x0000000203007388ULL, 0x0003e40000000800ULL, 0x00009800ff0c7b82ULL, 0x000ee20000000a00ULL,
0x000000070400780cULL, 0x040fe20003f04070ULL, 0x000000016d107824ULL, 0x004fe200078e021cULL,
0x00000002ff027819ULL, 0x002fe20000011653ULL, 0x0000020053537824ULL, 0x000fe200078e00ffULL,
0x00000001ff227819ULL, 0x000fe20000011604ULL, 0x0000001004237824ULL, 0x040fe200078e00ffULL,
0x000000101d037211ULL, 0x000fe200078fa0ffULL, 0x0000006004157836ULL, 0x000fe20000000000ULL,
0x0000000102067812ULL, 0x000fe400078ec0ffULL, 0x0000000000447805ULL, 0x000fc4000001ff00ULL,
0x0000007023237812ULL, 0x000fe400078ec0ffULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000c22227812ULL, 0x000fe200078ec0ffULL, 0x000002006d088824ULL, 0x140fe200078e0220ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x000002006d0a8824ULL, 0x000fe200078e0220ULL,
0x0000002022247210ULL, 0x000fe20007ffe023ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000001000f098824ULL, 0x000fe200078e0208ULL, 0x0000080053087812ULL, 0x000fe200078ec0ffULL,
0x000001000f0b8824ULL, 0x000fe200078e020aULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000008006178824ULL, 0x000fe200078e0209ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000100003027825ULL, 0x008fe200078e000cULL, 0x0000000000347805ULL, 0x000fc4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000008006198824ULL, 0x000fe200078e020bULL, 0x0000001e02027210ULL, 0x000fe20007f3e0ffULL,
0x000020006d067824ULL, 0x000fe200078e0220ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000011f078824ULL, 0x000fe200078e0210ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x000010000f217824ULL, 0x000fe200078e0206ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000008010108825ULL, 0x000fe200078e000cULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x00000080070c8825ULL, 0x000fe200078e000cULL, 0x0000000024247984ULL, 0x000e620000000800ULL,
0x00000000003c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000121077824ULL, 0x000fe400078e0208ULL, 0x000000ffff037224ULL, 0x000fe200008e0603ULL,
0x000000006d00720cULL, 0x000fe20003f26070ULL, 0x0000002004097836ULL, 0x000fc40000000000ULL,
0x00000040040b7836ULL, 0x040fe40000000000ULL, 0x0000001004137824ULL, 0x040fe400078e0207ULL,
0x0000001004067825ULL, 0x000fc800078e0002ULL, 0x0000001009087825ULL, 0x100fe200078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000006137faeULL, 0x0005e6000b901c4eULL,
0x000000100b0a7825ULL, 0x100fe200078e0002ULL, 0x0038000008137faeULL, 0x0005e6000b901c4eULL,
0x0000001015027825ULL, 0x000fe200078e0002ULL, 0x005800000a137faeULL, 0x0005e6000b901c4eULL,
0x00000010040c8825ULL, 0x040fe200078e000cULL, 0x0078000002137faeULL, 0x0005e6000b901c4eULL,
0x0000001004178824ULL, 0x000fc400078e0217ULL, 0x0000001004108825ULL, 0x000fc600078e0010ULL,
0x045800000c178faeULL, 0x0005e2000b901c4eULL, 0x0000001004198824ULL, 0x000fe400078e0219ULL,
0x000000ffff257224ULL, 0x000fc600078e00ffULL, 0x0418000010198faeULL, 0x0005e8000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000800bc1947ULL, 0x002fea0003800000ULL,
0x00009800ff027b82ULL, 0x004e620000000a00ULL, 0x00000003ff067819ULL, 0x000fe20000011604ULL,
0x000002006d4e7824ULL, 0x000fe200078e0220ULL, 0xfffffff8ff077812ULL, 0x000fe200078ee204ULL,
0x000000ffff457224ULL, 0x000fe200078e00ffULL, 0x0000000306067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff157224ULL, 0x000fe200078e006dULL, 0x00000002ff4c7819ULL, 0x000fe20000011604ULL,
0x0000000807097836ULL, 0x040fe20000000000ULL, 0x0000000406087812ULL, 0x000fe200078efcffULL,
0x0000000807477824ULL, 0x000fe200078e00ffULL, 0x0000000706467812ULL, 0x000fe200078e7807ULL,
0x00000008094a7824ULL, 0x000fe200078e00ffULL, 0x00000007060b7812ULL, 0x000fe200078e7809ULL,
0x000001000f4e7824ULL, 0x000fe200078e024eULL, 0x0000000708067812ULL, 0x000fe200078e7807ULL,
0x000000084c497836ULL, 0x000fe20000000000ULL, 0x0000000708097812ULL, 0x000fc400078e7809ULL,
0x0000004746467212ULL, 0x080fe400078efcffULL, 0x0000004a0b487212ULL, 0x080fe400078efcffULL,
0x0000004706477212ULL, 0x000fe400078efcffULL, 0x0000004a094a7212ULL, 0x002fce00078efcffULL,
0x00000002154b7836ULL, 0x000fca0000000000ULL, 0x000000004b00720cULL, 0x000fda0003f06070ULL,
0x0000000000a40947ULL, 0x000fea0003800000ULL, 0x000000011c107824ULL, 0x100fe200078e024bULL,
0x000000070400780cULL, 0x040fe20003f24070ULL, 0x0000002004097836ULL, 0x040fe20000000000ULL,
0x00000001ff087819ULL, 0x000fe2000001164bULL, 0x00000040044d7836ULL, 0x040fe20000000000ULL,
0x000000101d077211ULL, 0x000fe200078fa0ffULL, 0x00000060044f7836ULL, 0x000fe20000000000ULL,
0x00000001081b7812ULL, 0x000fc600078ec0ffULL, 0x0000100007067825ULL, 0x000fc800078e0002ULL,
0x000002006d0a9824ULL, 0x000fe200078e0220ULL, 0x0000001e060c7210ULL, 0x000fe20007f1e0ffULL,
0x000004004b067824ULL, 0x000fe400078e00ffULL, 0x000001000f4e9824ULL, 0x000fe400078e020aULL,
0x000002006d089824ULL, 0x000fe200078e0220ULL, 0x0000080006067812ULL, 0x000fe200078ec0ffULL,
0x000000011f0b9824ULL, 0x000fe400078e0210ULL, 0x000000ffff0d7224ULL, 0x000fc400000e0607ULL,
0x000000801b199824ULL, 0x000fe400078e024eULL, 0x0000000121077824ULL, 0x000fe400078e0206ULL,
0x000001000f4e9824ULL, 0x000fe400078e0208ULL, 0x000000800b0a9825ULL, 0x000fc800078e0002ULL,
0x0000008010109825ULL, 0x000fc800078e0002ULL, 0x0000001004177824ULL, 0x040fe400078e0207ULL,
0x0000001004127825ULL, 0x000fc800078e000cULL, 0x0000001009067825ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000012177faeULL, 0x0003e6000b901c4eULL,
0x000000801b1b9824ULL, 0x000fe200078e024eULL, 0x0038000006177faeULL, 0x0003e2000b901c4eULL,
0x000000104d087825ULL, 0x000fc800078e000cULL, 0x000000104f0c7825ULL, 0x000fe200078e000cULL,
0x0058000008177faeULL, 0x0003e6000b901c4eULL, 0x00000010040a9825ULL, 0x040fe200078e000aULL,
0x007800000c177faeULL, 0x0003e6000b901c4eULL, 0x0000001004199824ULL, 0x040fe400078e0219ULL,
0x0000001004109825ULL, 0x000fc600078e0010ULL, 0x045800000a199faeULL, 0x0003e2000b901c4eULL,
0x00000010041b9824ULL, 0x000fca00078e021bULL, 0x04180000101b9faeULL, 0x0003e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000004015067824ULL, 0x002fca00078e00ffULL,
0x0000008006067812ULL, 0x000fc800078ec0ffULL, 0x0000004e23077210ULL, 0x000fe20007ffe006ULL,
0x0000040015067824ULL, 0x000fc800078e00ffULL, 0x00000001220c7824ULL, 0x000fe200078e0207ULL,
0x0000080006067812ULL, 0x000fc800078ec0ffULL, 0x0000018021077810ULL, 0x000fe20007ffe006ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180000c0d7984ULL, 0x000e620000000800ULL,
0x0000001048147824ULL, 0x100fe400078e0207ULL, 0x0000001046087824ULL, 0x100fe200078e0207ULL,
0x004580000c067984ULL, 0x000fe20000000800ULL, 0x0000001047107824ULL, 0x100fe400078e0207ULL,
0x000000104a187824ULL, 0x000fe200078e0207ULL, 0x000000001414783bULL, 0x000ea80000000200ULL,
0x000000000808783bULL, 0x000ee80000000200ULL, 0x000000001010783bULL, 0x000f280000000200ULL,
0x000000001818783bULL, 0x000f620000000200ULL, 0x0000000d240d7221ULL, 0x002fc80000010100ULL,
0x3fb8aa3b0d077820ULL, 0x000fe20000410000ULL, 0x0000763215557816ULL, 0x044fe20000000055ULL,
0x0001000015567824ULL, 0x000fc800078e00ffULL, 0x0000000700077308ULL, 0x000e620000000800ULL,
0x0000763216157816ULL, 0x040fe20000000015ULL, 0x0001000016577824ULL, 0x000fe200078e00ffULL,
0x000076320a0d7816ULL, 0x008fe2000000000dULL, 0x000100000b507824ULL, 0x040fe200078e00ffULL,
0x000076320b4d7816ULL, 0x000fe2000000004dULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x0000763213537816ULL, 0x050fe20000000053ULL, 0x0001000010517824ULL, 0x040fe200078e00ffULL,
0x00007632104f7816ULL, 0x000fe2000000004fULL, 0x0001000013547824ULL, 0x000fe200078e00ffULL,
0x0000763211107816ULL, 0x000fe20000000010ULL, 0x000100000a0a7824ULL, 0x000fe200078e00ffULL,
0x00007632090c7816ULL, 0x040fe2000000000cULL, 0x0001000009097824ULL, 0x000fc400078e00ffULL,
0x00000006075d7220ULL, 0x002fe20000410000ULL, 0x0000763208067816ULL, 0x040fe20000000006ULL,
0x0001000008087824ULL, 0x000fe200078e00ffULL, 0x0000763212527816ULL, 0x000fe20000000052ULL,
0x000000445d447221ULL, 0x000fe20000010000ULL, 0x00001f4c5d5c7589ULL, 0x000e6200000e0000ULL,
0x0001000006077824ULL, 0x000fe200078e00ffULL, 0x0000763214137816ULL, 0x000fe20000000013ULL,
0x000100000d067824ULL, 0x000fe200078e00ffULL, 0x00001f495d5d7589ULL, 0x000ea200000e0000ULL,
0x0000763217167816ULL, 0x000fe20000000016ULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x0000763218587816ULL, 0x020fe20000000058ULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x0000763219597816ULL, 0x000fe20000000059ULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x000076321a5a7816ULL, 0x000fe2000000005aULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x000076321b5b7816ULL, 0x000fe2000000005bULL, 0x0001000018187824ULL, 0x000fc400078e00ffULL,
0x0001000019197824ULL, 0x000fe400078e00ffULL, 0x000100001a1a7824ULL, 0x000fe400078e00ffULL,
0x000100001b1b7824ULL, 0x000fe400078e00ffULL, 0x000100000c0b7824ULL, 0x000fe400078e00ffULL,
0x0000005c06317223ULL, 0x082fe20000010031ULL, 0x0001000053067824ULL, 0x000fe400078e00ffULL,
0x0000005c08397223ULL, 0x080fe20000010039ULL, 0x0000005c07367223ULL, 0x000fe20000010036ULL,
0x0000005d153a7223ULL, 0x004fe2000001003aULL, 0x000000ffff157224ULL, 0x000fc400078e004bULL,
0x0000005c06257223ULL, 0x080fe20000010025ULL, 0x000100004d087824ULL, 0x000fe400078e00ffULL,
0x0000005c09407223ULL, 0x000fe20000010040ULL, 0x0001000010077824ULL, 0x000fe200078e00ffULL,
0x000000001500720cULL, 0x000fe20003f06070ULL, 0x0001000055067824ULL, 0x000fe400078e00ffULL,
0x0000005c082f7223ULL, 0x080fe2000001002fULL, 0x0000005c072a7223ULL, 0x000fe2000001002aULL,
0x000100004f4f7824ULL, 0x000fc400078e00ffULL, 0x0000005d063d7223ULL, 0x000fe2000001003dULL,
0x0001000052097824ULL, 0x000fe400078e00ffULL, 0x0000005c0b327223ULL, 0x080fe20000010032ULL,
0x0001000013137824ULL, 0x000fe400078e00ffULL, 0x0000005c0a3b7223ULL, 0x080fe2000001003bULL,
0x0001000016077824ULL, 0x000fe400078e00ffULL, 0x0000005c50377223ULL, 0x000fe20000010037ULL,
0x0001000058587824ULL, 0x000fc400078e00ffULL, 0x0000005c51427223ULL, 0x080fe20000010042ULL,
0x0001000059067824ULL, 0x000fe400078e00ffULL, 0x0000005c4f2c7223ULL, 0x080fe2000001002cULL,
0x000100005a5a7824ULL, 0x000fe400078e00ffULL, 0x0000005c113e7223ULL, 0x080fe2000001003eULL,
0x000100005b087824ULL, 0x000fe400078e00ffULL, 0x0000005c12437223ULL, 0x080fe20000010043ULL,
0x0000005c09287223ULL, 0x080fe20000010028ULL, 0x0000005c54417223ULL, 0x000fe20000010041ULL,
0x0000005d143f7223ULL, 0x080fe2000001003fULL, 0x0000005d13347223ULL, 0x080fe20000010034ULL,
0x0000005d56337223ULL, 0x080fe20000010033ULL, 0x0000005d573c7223ULL, 0x080fe2000001003cULL,
0x0000005d17307223ULL, 0x080fe20000010030ULL, 0x0000005d072e7223ULL, 0x080fe2000001002eULL,
0x0000005d182d7223ULL, 0x080fe2000001002dULL, 0x0000005d582b7223ULL, 0x080fe2000001002bULL,
0x0000005d19387223ULL, 0x080fe20000010038ULL, 0x0000005d06357223ULL, 0x080fe20000010035ULL,
0x0000005d1a297223ULL, 0x080fe20000010029ULL, 0x0000005d5a277223ULL, 0x080fe20000010027ULL,
0x0000005d1b267223ULL, 0x080fe20000010026ULL, 0x0000005d08457223ULL, 0x000fe20000010045ULL,
0xfffffff4009c8947ULL, 0x000fec000383ffffULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x0000001000027824ULL, 0x006fe200078e00ffULL,
0x00000001ff047819ULL, 0x000fe20000011600ULL, 0x0000498020007836ULL, 0x000fc60000000000ULL,
0x0000007002037812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ec0ffULL,
0x0000000004007210ULL, 0x000fe20007ffe003ULL, 0x0000000000200947ULL, 0x000fec0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x000000806d207824ULL, 0x000fe400078e0220ULL,
0x0000001002037824ULL, 0x002fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ec0ffULL,
0x0000002002037210ULL, 0x000fca0007ffe003ULL, 0x0049804403007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000000027984ULL, 0x000ea80000000800ULL,
0x0000800000037984ULL, 0x002e620000000800ULL, 0x00000002ff027221ULL, 0x004fc80000010000ULL,
0x0000000302027221ULL, 0x002fc80000010000ULL, 0x0180000002037836ULL, 0x000fca0000000000ULL,
0x7f80000003037812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0002ULL, 0x00009ff000067802ULL, 0x000fce0000000f00ULL,
0x0000007000247944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0004ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000200037308ULL, 0x000e640000001000ULL,
0xbf80000002007423ULL, 0x002fc80000000003ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000047919ULL, 0x000ea40000000000ULL,
0x00000002ff077819ULL, 0x104fe40000011604ULL, 0x00000008040d7811ULL, 0x000fe400078ff0ffULL,
0x00000003ff147819ULL, 0x000fe20000011604ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0700027589ULL, 0x000ea200000e0000ULL, 0xfffffff8ff197812ULL, 0x000fc400078ee204ULL,
0x0000000314187812ULL, 0x000fe200078ec0ffULL, 0x00001f0d000c7589ULL, 0x000ee400000e0000ULL,
0x00000008191d7836ULL, 0x000fe20000000000ULL, 0x00000004181a7812ULL, 0x000fe200078efcffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000007181b7812ULL, 0x000fe200078e7819ULL,
0x000000081d1e7824ULL, 0x000fe200078e00ffULL, 0x00000007181f7812ULL, 0x000fe400078e781dULL,
0x000000071a1d7812ULL, 0x000fe200078e781dULL, 0x0000003902087220ULL, 0x044fe20000410000ULL,
0x0000003602037220ULL, 0x040fe20000410000ULL, 0x0000004002097220ULL, 0x040fe20000410000ULL,
0x0000003202327220ULL, 0x000fe20000410000ULL, 0x0000003f0c3f7220ULL, 0x048fe20000410000ULL,
0x000000340c347220ULL, 0x040fe20000410000ULL, 0x000000330c337220ULL, 0x040fe20000410000ULL,
0x0000003d0c007220ULL, 0x040fe20000410000ULL, 0x0000003c0c3c7220ULL, 0x040fe20000410000ULL,
0x0000003a0c157220ULL, 0x040fe20000410000ULL, 0x000000300c307220ULL, 0x040fe20000410000ULL,
0x0000002e0c177220ULL, 0x040fe20000410000ULL, 0x0000002d0c2d7220ULL, 0x040fe20000410000ULL,
0x0000002b0c147220ULL, 0x040fe20000410000ULL, 0x000000380c387220ULL, 0x040fe20000410000ULL,
0x000000350c357220ULL, 0x040fe20000410000ULL, 0x000000290c297220ULL, 0x040fe20000410000ULL,
0x000000270c167220ULL, 0x040fe20000410000ULL, 0x000000260c267220ULL, 0x040fe20000410000ULL,
0x000000450c457220ULL, 0x000fe20000410000ULL, 0x00000008190c7824ULL, 0x000fe200078e00ffULL,
0x000000071a197812ULL, 0x000fe200078e7819ULL, 0x0000003b020a7220ULL, 0x042fe20000410000ULL,
0x0000003102317220ULL, 0x040fe20000410000ULL, 0x00000037020b7220ULL, 0x040fe20000410000ULL,
0x0000002f02067220ULL, 0x040fe20000410000ULL, 0x0000004202107220ULL, 0x040fe20000410000ULL,
0x0000002c02077220ULL, 0x040fe20000410000ULL, 0x0000003e02117220ULL, 0x040fe20000410000ULL,
0x0000002a022a7220ULL, 0x040fe20000410000ULL, 0x0000004302127220ULL, 0x040fe20000410000ULL,
0x00000028020d7220ULL, 0x040fe20000410000ULL, 0x0000004102137220ULL, 0x040fe20000410000ULL,
0x0000000c1b187212ULL, 0x000fe200078efcffULL, 0x0000002502027220ULL, 0x000fe20000410000ULL,
0x0000001e1f1a7212ULL, 0x000fc400078efcffULL, 0x0000000c191c7212ULL, 0x000fe200078efcffULL,
0x00000010180c7824ULL, 0x100fe200078e0205ULL, 0x0000001e1d1e7212ULL, 0x000fe200078efcffULL,
0x000000101a1d7824ULL, 0x100fe200078e0205ULL, 0x000000080308723eULL, 0x000fe200000010ffULL,
0x000000101c1c7824ULL, 0x100fe200078e0205ULL, 0x000000093209723eULL, 0x000fe200000010ffULL,
0x000000101e057824ULL, 0x000fe200078e0205ULL, 0x0000000a310a723eULL, 0x000fe200000010ffULL,
0x000000206d037824ULL, 0x000fe200078e0204ULL, 0x0000000b060b723eULL, 0x000fc400000010ffULL,
0x000000100710723eULL, 0x000fe200000010ffULL, 0x0000001003037824ULL, 0x000fe200078e020eULL,
0x000000112a11723eULL, 0x000fe200000010ffULL, 0x000000080c007844ULL, 0x000fe20000000200ULL,
0x000000120d12723eULL, 0x000fe400000010ffULL, 0x000000130213723eULL, 0x000fe400000010ffULL,
0x0000003f3418723eULL, 0x000fe400000010ffULL, 0x000000330019723eULL, 0x000fe200000010ffULL,
0x000000101c007844ULL, 0x000fe20000000200ULL, 0x0000003c151a723eULL, 0x000fe200000010ffULL,
0x000000ff00007306ULL, 0x000e620000202400ULL, 0x00000030171b723eULL, 0x000fc400000010ffULL,
0x0000002d1414723eULL, 0x000fe400000010ffULL, 0x000000383515723eULL, 0x000fe200000010ffULL,
0x000000181d007844ULL, 0x000fe20000000200ULL, 0x000000291616723eULL, 0x000fe400000010ffULL,
0x000000264517723eULL, 0x000fca00000010ffULL, 0x0000001405007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000003207984ULL, 0x000e680000000c00ULL,
0x0004000003287984ULL, 0x000ea80000000c00ULL, 0x0008000003247984ULL, 0x000ee80000000c00ULL,
0x000c0000032c7984ULL, 0x000f220000000c00ULL, 0x0000002300237230ULL, 0x002fc40000200800ULL,
0x0000002200227230ULL, 0x040fe40000200800ULL, 0x0000002100217230ULL, 0x040fe40000200800ULL,
0x0000002000207230ULL, 0x040fe40000200800ULL, 0x0000002b002b7230ULL, 0x044fe40000200800ULL,
0x0000002a002a7230ULL, 0x040fe40000200800ULL, 0x0000002900297230ULL, 0x000fc40000200800ULL,
0x0000002800287230ULL, 0x000fe40000200800ULL, 0x0000002723237230ULL, 0x008fe40000200000ULL,
0x0000002622227230ULL, 0x000fe40000200000ULL, 0x0000002521217230ULL, 0x000fe40000200000ULL,
0x0000002420207230ULL, 0x000fe40000200000ULL, 0x0000002f2b2b7230ULL, 0x010fc40000200000ULL,
0x0000002e2a2a7230ULL, 0x000fe20000200000ULL, 0x0000002003007388ULL, 0x0003e20000000c00ULL,
0x0000002d29297230ULL, 0x000fe40000200000ULL, 0x0000002c28287230ULL, 0x000fca0000200000ULL,
0x0004002803007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff6d00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000197919ULL, 0x004ea20000002600ULL, 0x00000020041d7836ULL, 0x040fe20000000000ULL,
0x00000003ff057819ULL, 0x000fe20000011604ULL, 0x00000040041f7836ULL, 0x040fe20000000000ULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0x0000006004217836ULL, 0x002fe20000000000ULL,
0x0000000705037812ULL, 0x000fe200078e4804ULL, 0x000000080f1b7824ULL, 0x040fe200078e00ffULL,
0x00000003ff0c7819ULL, 0x000fe2000001161dULL, 0x0000840000057ab9ULL, 0x000fe20000000800ULL,
0x00000003ff0d7819ULL, 0x000fe2000001161fULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x00000003ff187819ULL, 0x000fe20000011621ULL, 0x0000860000067ab9ULL, 0x000fe20000000a00ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee204ULL, 0x000000080f1e7824ULL, 0x000fe200078e00ffULL,
0x0ffffff803037812ULL, 0x000fc400078ef804ULL, 0x000000070c027812ULL, 0x000fe400078e481dULL,
0x000000070d047812ULL, 0x000fe200078e481fULL, 0x0000001003037824ULL, 0x100fe200078e020eULL,
0x0000000718067812ULL, 0x000fe400078e4821ULL, 0x0ffffff804077812ULL, 0x000fe400078ef81fULL,
0x0ffffff806097812ULL, 0x000fe200078ef821ULL, 0x00000004050472a4ULL, 0x008fe4000f8e023fULL,
0x0000001007107824ULL, 0x100fe200078e020eULL, 0xfffffff81e217812ULL, 0x000fe200078ee221ULL,
0x0000001009147824ULL, 0x000fc400078e020eULL, 0x0000001019007824ULL, 0x044fe400078e00ffULL,
0x0000000010107984ULL, 0x000fe20000000c00ULL, 0x0000001019237824ULL, 0x000fe400078e00ffULL,
0xfffffff000007812ULL, 0x000fe200078ee205ULL, 0x0000000014147984ULL, 0x000fe20000000c00ULL,
0x0ffffff802057812ULL, 0x000fe200078ef81dULL, 0x000000080f027824ULL, 0x000fe200078e00ffULL,
0x0000000400007c10ULL, 0x000fe4000ff1e0ffULL, 0xfffffff0230c7812ULL, 0x000fe200078ee20cULL,
0x0000001005087824ULL, 0x000fe200078e020eULL, 0xfffffff8021d7812ULL, 0x000fe200078ee21dULL,
0x0000000003047984ULL, 0x0002a20000000c00ULL, 0x000000080f0e7824ULL, 0x000fc600078e00ffULL,
0x0000000008087984ULL, 0x000ee40000000c00ULL, 0xfffffff80e1f7812ULL, 0x000fe200078ee21fULL,
0x00000010190e7824ULL, 0x040fe400078e00ffULL, 0x0000001019197824ULL, 0x000fe400078e00ffULL,
0x000000ffff037224ULL, 0x002fe200000e06ffULL, 0x0000000600027c11ULL, 0x000fe4000f8040ffULL,
0xfffffff00e0d7812ULL, 0x000fc400078ee20dULL, 0xfffffff019187812ULL, 0x000fe400078ee218ULL,
0x0000000700037c11ULL, 0x000fe400080f4403ULL, 0x000000040c1c7c10ULL, 0x000fe4000ff1e0ffULL,
0x000000040d0f7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000101b027825ULL, 0x000fe200078e0002ULL,
0x0000000418007c10ULL, 0x000fc6000ff5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x000000061c0c7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x000000060f0e7c11ULL, 0x040fe2000f8240ffULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x0000000600187c11ULL, 0x000fe4000f8440ffULL, 0x000000071c0d7c11ULL, 0x000fe400080f440dULL,
0x000000070f0f7c11ULL, 0x000fe400088f441aULL, 0x0000000700197c11ULL, 0x000fe200090f4419ULL,
0x000000101d0c7825ULL, 0x000fe200078e000cULL, 0x0000000402007986ULL, 0x004fe6000c101d0eULL,
0x000000101f0e7825ULL, 0x000fe200078e000eULL, 0x000000080c007986ULL, 0x008fe6000c101d0eULL,
0x0000001021187825ULL, 0x000fe200078e0018ULL, 0x000000100e007986ULL, 0x000fe8000c101d0eULL,
0x0000001418007986ULL, 0x000fe2000c101d0eULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00009400ff067b82ULL, 0x000e620000000a00ULL, 0x03ffffff53027812ULL, 0x008fe200078ec0ffULL,
0xffffffffff097424ULL, 0x000fc800078e00ffULL, 0x0000000451037824ULL, 0x000fca00078e0202ULL,
0x0000000503007c0cULL, 0x000fe2000bf06070ULL, 0x0000000e06077981ULL, 0x002358000c1e9900ULL,
0x00009000ff058b82ULL, 0x000ea20000000800ULL, 0x000000020b028824ULL, 0x000fce00078e00ffULL,
0x00008c00ff0c8b82ULL, 0x000ee20000000a00ULL, 0x0000000502058224ULL, 0x004fe400078e0203ULL,
0x0000000151027836ULL, 0x000fe40000000000ULL, 0x00000004050c8825ULL, 0x008fca00078e000cULL,
0x0000000e0c098981ULL, 0x000362000c1e1900ULL, 0x0000000602007c0cULL, 0x000fe2000bf06070ULL,
0x0000000607077899ULL, 0x000fe2000800063fULL, 0x0000004008027824ULL, 0x000fe400078e00ffULL,
0x0000004053047824ULL, 0x000fd200078e00ffULL, 0x0000000c00448947ULL, 0x002fea0003800000ULL,
0x0000000000067919ULL, 0x000e620000000000ULL, 0x0000010051127824ULL, 0x000fe200078e0204ULL,
0x0000040000087802ULL, 0x000fe20000000f00ULL, 0x0000000702097e24ULL, 0x020fe2000f8e0209ULL,
0x00000000000f7919ULL, 0x000ea40000008800ULL, 0x0000001012057c48ULL, 0x000fca000ffe0000ULL,
0x0000000105127824ULL, 0x000fe200078e0a12ULL, 0x00000003ff137819ULL, 0x002fe40000011606ULL,
0x0ffffff8060d7812ULL, 0x040fe400078ec0ffULL, 0x00000006130a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000413117836ULL, 0x000fe20000000000ULL, 0x000006540f087816ULL, 0x004fe20000000008ULL,
0x0000000c13177836ULL, 0x000fe20000000000ULL, 0x000000070d257812ULL, 0x000fe200078ef80aULL,
0x00000008110c7824ULL, 0x040fe200078e00ffULL, 0x0000000611057212ULL, 0x000fe200078e3cffULL,
0x0000000813157836ULL, 0x000fe20000000000ULL, 0x000000121100720cULL, 0x000fe20003f86070ULL,
0x00000008170e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c237812ULL, 0x000fe200078ee205ULL,
0x0000000815297824ULL, 0x000fe200078e00ffULL, 0x00008a00ff0c7b82ULL, 0x000e620000000a00ULL,
0x0000000617057212ULL, 0x080fe200078e3cffULL, 0x0000001013197836ULL, 0x000fe20000000000ULL,
0x00000006150a7212ULL, 0x080fe200078e3cffULL, 0x0000001413217836ULL, 0x000fe20000000000ULL,
0xfffffff80e2b7812ULL, 0x000fe200078ee205ULL, 0x0000000819107824ULL, 0x040fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20aULL, 0x00000010060f7824ULL, 0x000fe200078e00ffULL,
0x0000000619057212ULL, 0x080fe200078e3cffULL, 0x00000008212f7824ULL, 0x000fe200078e00ffULL,
0x0000003f130a7812ULL, 0x040fe200078ec0ffULL, 0x0000001813317836ULL, 0x000fe20000000000ULL,
0x00000006210e7212ULL, 0x000fe200078e3cffULL, 0x0000001c13377836ULL, 0x040fe20000000000ULL,
0xfffffff8102d7812ULL, 0x000fe200078ee205ULL, 0x0000002013337836ULL, 0x000fe20000000000ULL,
0x000000700f057812ULL, 0x000fe200078ec0ffULL, 0x00000001090f7824ULL, 0x000fe200078e020aULL,
0x0000003f110a7812ULL, 0x000fe200078ec0ffULL, 0x0000002413357836ULL, 0x000fe20000000000ULL,
0xfffffff82f2f7812ULL, 0x000fc400078ee20eULL, 0x0000003f150e7812ULL, 0x000fe200078ec0ffULL,
0x0000000109117824ULL, 0x000fe200078e020aULL, 0x000000121500720cULL, 0x080fe40003fa6070ULL,
0x0000003f190a7812ULL, 0x000fe200078ec0ffULL, 0x0000000109157824ULL, 0x000fe200078e020eULL,
0x0000003f17167812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x102fe200078e000cULL,
0x000000121900720cULL, 0x080fe40003f46070ULL, 0x000000121700720cULL, 0x000fe20003f06070ULL,
0x000000800f0e7825ULL, 0x000fe200078e000cULL, 0x00000005101c7210ULL, 0x000fc40007f7e0ffULL,
0x0000003f37187812ULL, 0x000fe200078ec0ffULL, 0x0000008015147825ULL, 0x000fe200078e000cULL,
0x000000050e1a7210ULL, 0x000fe40007f3e0ffULL, 0x0000003f33227812ULL, 0x000fe200078ec0ffULL,
0x0000000109197824ULL, 0x040fe200078e020aULL, 0x00000005141e7210ULL, 0x000fe20007fde0ffULL,
0x0000000109177824ULL, 0x000fe200078e0216ULL, 0x0000003f210a7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1d7224ULL, 0x000fe200018e0611ULL, 0x0000003f31147812ULL, 0x000fe200078ec0ffULL,
0x0000008019107825ULL, 0x000fe200078e000cULL, 0x0000000631247212ULL, 0x000fc600078e3cffULL,
0x000000ffff1b7224ULL, 0x000fe200008e060fULL, 0x000000122100720cULL, 0x000fe20003f26070ULL,
0x000000ffff1f7224ULL, 0x000fe200030e0615ULL, 0x0000000510107210ULL, 0x000fe20007fde0ffULL,
0x00000080170e7825ULL, 0x000fc800078e000cULL, 0x0000000109157824ULL, 0x040fe200078e020aULL,
0x000000050e0e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000109177824ULL, 0x000fe400078e0214ULL,
0x0000008015147825ULL, 0x000fc800078e000cULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0000000514147210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e060fULL,
0x000000121300720cULL, 0x000fe20003f66070ULL, 0x0000008017167825ULL, 0x000fc800078e000cULL,
0x00004000530a7824ULL, 0x000fe400078e0208ULL, 0x0000000109197824ULL, 0x000fe400078e0218ULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x0000000516207210ULL, 0x000fe20007fde0ffULL,
0x000010000a0a7836ULL, 0x000fe40000000000ULL, 0x0000008019187825ULL, 0x000fc800078e000cULL,
0x0000000109277824ULL, 0x000fe400078e0222ULL, 0x0000001025257824ULL, 0x000fe400078e020aULL,
0x000000ffff217224ULL, 0x000fe200030e0617ULL, 0x0000000518187210ULL, 0x000fe20007fde0ffULL,
0x0000008027167825ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a257faeULL, 0x0003e2000d901c4eULL, 0x000000123100720cULL, 0x000fe40003f66070ULL,
0x0000001023277824ULL, 0x000fc400078e020aULL, 0x0000000831317824ULL, 0x000fe400078e00ffULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x0000000516227210ULL, 0x000fe20007fde0ffULL,
0x000000001c277faeULL, 0x0005e2000e101c4eULL, 0x0000003f35167812ULL, 0x000fe200078ec0ffULL,
0x0000001029297824ULL, 0x000fe200078e020aULL, 0x00000006371a7212ULL, 0x042fe200078e3cffULL,
0x00000008371b7824ULL, 0x040fe200078e00ffULL, 0x000000123700720cULL, 0x080fe20003f86070ULL,
0x000000ffff237224ULL, 0x000fe200030e0617ULL, 0xfffffff831317812ULL, 0x000fe200078ee224ULL,
0x0000000109177824ULL, 0x000fe200078e0216ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee21aULL,
0x000000102b2b7824ULL, 0x100fe200078e020aULL, 0x000000001e297faeULL, 0x0003e2000e901c4eULL,
0x000000102d2d7824ULL, 0x100fe200078e020aULL, 0x000000123300720cULL, 0x000fe20003fa6070ULL,
0x000000102f2f7824ULL, 0x100fe200078e020aULL, 0x0000000633247212ULL, 0x040fe200078e3cffULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x000000000e2b7faeULL, 0x0007e2000c101c4eULL,
0x0000001031317824ULL, 0x000fc400078e020aULL, 0x0000008017167825ULL, 0x000fe200078e000cULL,
0x00000000102d7faeULL, 0x0009e2000d101c4eULL, 0xfffffff8331d7812ULL, 0x004fe400078ee224ULL,
0x000000101b1b7824ULL, 0x100fe200078e020aULL, 0x00000000142f7faeULL, 0x000fe2000c901c4eULL,
0x00000028131f7836ULL, 0x042fe20000000000ULL, 0x0000000516167210ULL, 0x000fe20007fde0ffULL,
0x0000002c13257836ULL, 0x000fe20000000000ULL, 0x0000000020317faeULL, 0x000fe2000d901c4eULL,
0x00000008350f7824ULL, 0x048fe200078e00ffULL, 0x00000006350e7212ULL, 0x080fe200078e3cffULL,
0x000000101d1d7824ULL, 0x100fe200078e020aULL, 0x00000000181b7faeULL, 0x0003e2000e101c4eULL,
0x000000061f107212ULL, 0x010fe200078e3cffULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee20eULL, 0x0000003013277836ULL, 0x000fe20000000000ULL,
0x000000123500720cULL, 0x080fe20003fc6070ULL, 0x0000003413297836ULL, 0x000fe20000000000ULL,
0x0000003f1f0e7812ULL, 0x000fe200078ec0ffULL, 0x00000038132b7836ULL, 0x040fe20000000000ULL,
0x00000000221d7faeULL, 0x000fe2000e901c4eULL, 0x0000003c132d7836ULL, 0x000fe20000000000ULL,
0x000000121f00720cULL, 0x0c0fe20003fa6070ULL, 0x000000081f197824ULL, 0x002fe200078e00ffULL,
0x000000122500720cULL, 0x0c0fe20003f86070ULL, 0x00000008251b7824ULL, 0x000fe200078e00ffULL,
0x000000122700720cULL, 0x000fe20003f66070ULL, 0x000000100f157824ULL, 0x000fe200078e020aULL,
0xfffffff819197812ULL, 0x000fe200078ee210ULL, 0x00000001090f7824ULL, 0x000fe200078e020eULL,
0x0000000625107212ULL, 0x000fe200078e3cffULL, 0x0000000829187824ULL, 0x040fe200078e00ffULL,
0x000000122900720cULL, 0x080fe20003f46070ULL, 0x000000800f0e7825ULL, 0x000fe200078e000cULL,
0x000000122b00720cULL, 0x080fe20003f26070ULL, 0x0000000016157faeULL, 0x0003e2000f101c4eULL,
0x000000122d00720cULL, 0x000fe20003f06070ULL, 0x0000000827127824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee210ULL, 0x000000082b1a7824ULL, 0x000fe200078e00ffULL,
0x0000000627117212ULL, 0x000fe200078e3cffULL, 0x0000001019197824ULL, 0x100fe200078e020aULL,
0x0000003f25107812ULL, 0x000fe200078ec0ffULL, 0x000000101b1b7824ULL, 0x000fe200078e020aULL,
0xfffffff8121f7812ULL, 0x000fc400078ee211ULL, 0x0000003f27147812ULL, 0x000fe200078ec0ffULL,
0x0000000109117824ULL, 0x000fe200078e0210ULL, 0x0000000629137212ULL, 0x000fe200078e3cffULL,
0x000000101f1f7824ULL, 0x000fe200078e020aULL, 0x000000050e127210ULL, 0x000fe20007fde0ffULL,
0x0000008011107825ULL, 0x000fe200078e000cULL, 0xfffffff818217812ULL, 0x000fe400078ee213ULL,
0x0000003f29167812ULL, 0x002fe200078ec0ffULL, 0x00000001091d7824ULL, 0x000fe200078e0214ULL,
0x0000003f2d187812ULL, 0x000fe200078ec0ffULL, 0x000000ffff137224ULL, 0x000fe200030e060fULL,
0x0000000510147210ULL, 0x000fe20007fde0ffULL, 0x000000801d0e7825ULL, 0x000fe200078e000cULL,
0x0000003f2b107812ULL, 0x000fc400078ec0ffULL, 0x0000000012197faeULL, 0x0003e2000e901c4eULL,
0x0000000109177824ULL, 0x040fe400078e0216ULL, 0x000000ffff157224ULL, 0x000fe200030e0611ULL,
0x000000050e167210ULL, 0x000fe20007fde0ffULL, 0x00000001091d7824ULL, 0x000fe400078e0210ULL,
0x0000008017107825ULL, 0x000fe200078e000cULL, 0x00000000141b7faeULL, 0x0003e6000e101c4eULL,
0x000000ffff177224ULL, 0x000fe200030e060fULL, 0x0000000510107210ULL, 0x000fe20007fde0ffULL,
0x000000801d0e7825ULL, 0x000fc600078e000cULL, 0x00000000161f7faeULL, 0x0003e2000d901c4eULL,
0x0000000109237824ULL, 0x000fe200078e0218ULL, 0x000000062b097212ULL, 0x080fe200078e3cffULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x000000050e0e7210ULL, 0x000fe20007fde0ffULL,
0x000000082d1d7824ULL, 0x040fe200078e00ffULL, 0x000000062d187212ULL, 0x000fe200078e3cffULL,
0x00000080230c7825ULL, 0x000fe200078e000cULL, 0xfffffff81a097812ULL, 0x000fe400078ee209ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee218ULL, 0x000000ffff0f7224ULL, 0x000fe200030e060fULL,
0x000000050c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001021217824ULL, 0x000fc400078e020aULL,
0x0000001009097824ULL, 0x100fe400078e020aULL, 0x000000101d1d7824ULL, 0x000fe200078e020aULL,
0x0000000010217faeULL, 0x0003e2000d101c4eULL, 0x000000ffff0d7224ULL, 0x000fc600030e060dULL,
0x000000000e097faeULL, 0x0003e8000c901c4eULL, 0x000000000c1d7faeULL, 0x0003e2000c101c4eULL,
0x0000000800f47947ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e620000000000ULL,
0x0000040000087802ULL, 0x000fe20000000f00ULL, 0x0000000702097e24ULL, 0x020fe2000f8e0209ULL,
0x00000000000f7919ULL, 0x000ea20000008800ULL, 0x00000003ff057819ULL, 0x002fe40000011606ULL,
0x0ffffff8060d7812ULL, 0x000fe400078ec0ffULL, 0x00000006050a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000405137836ULL, 0x000fe20000000000ULL, 0x000006540f087816ULL, 0x004fe20000000008ULL,
0x0000000805157836ULL, 0x000fe20000000000ULL, 0x000000070d0e7812ULL, 0x000fe200078ef80aULL,
0x0000000813177824ULL, 0x040fe200078e00ffULL, 0x00000006130c7212ULL, 0x080fe200078e3cffULL,
0x0000001005197836ULL, 0x000fe20000000000ULL, 0x0000000615117212ULL, 0x080fe200078e3cffULL,
0x00000014051b7836ULL, 0x000fe20000000000ULL, 0xfffffff817107812ULL, 0x000fe200078ee20cULL,
0x0000000815147824ULL, 0x000fe200078e00ffULL, 0x00000006190c7212ULL, 0x0c0fe200078e3cffULL,
0x00000008191f7824ULL, 0x000fe200078e00ffULL, 0x000000061b0d7212ULL, 0x0c0fe200078e3cffULL,
0x000000081b207824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee211ULL,
0x0000000c05177836ULL, 0x040fe20000000000ULL, 0xfffffff81f1c7812ULL, 0x000fe200078ee20cULL,
0x0000002005217836ULL, 0x040fe20000000000ULL, 0xfffffff820207812ULL, 0x000fe200078ee20dULL,
0x0000002405237836ULL, 0x000fe20000000000ULL, 0x00000006170a7212ULL, 0x080fe200078e3cffULL,
0x00000018051d7836ULL, 0x000fe20000000000ULL, 0x00000006210c7212ULL, 0x080fe200078e3cffULL,
0x0000000817117824ULL, 0x000fe200078e00ffULL, 0x00000006230d7212ULL, 0x080fe200078e3cffULL,
0x0000000821277824ULL, 0x000fe200078e00ffULL, 0x000000061d0f7212ULL, 0x080fe200078e3cffULL,
0x0000000823307824ULL, 0x000fe200078e00ffULL, 0xfffffff811187812ULL, 0x000fe200078ee20aULL,
0x0000003005297836ULL, 0x040fe20000000000ULL, 0xfffffff8272c7812ULL, 0x000fe200078ee20cULL,
0x00000034052b7836ULL, 0x000fe20000000000ULL, 0xfffffff830307812ULL, 0x000fe200078ee20dULL,
0x000000081d247824ULL, 0x000fe200078e00ffULL, 0x00000006290c7212ULL, 0x080fe200078e3cffULL,
0x0000001c051f7836ULL, 0x000fe20000000000ULL, 0x000000062b0d7212ULL, 0x080fe200078e3cffULL,
0x0000002805257836ULL, 0x000fe20000000000ULL, 0xfffffff824247812ULL, 0x000fe200078ee20fULL,
0x000000081f117824ULL, 0x040fe200078e00ffULL, 0x000000061f0a7212ULL, 0x080fe200078e3cffULL,
0x00000008292f7824ULL, 0x000fe200078e00ffULL, 0x00000006250f7212ULL, 0x080fe200078e3cffULL,
0x000000082b407824ULL, 0x000fe200078e00ffULL, 0xfffffff811287812ULL, 0x000fe200078ee20aULL,
0x0000000825347824ULL, 0x000fe200078e00ffULL, 0xfffffff82f3c7812ULL, 0x000fe200078ee20cULL,
0x0000002c05277836ULL, 0x040fe20000000000ULL, 0xfffffff840407812ULL, 0x000fe200078ee20dULL,
0x00000038052d7836ULL, 0x000fe20000000000ULL, 0xfffffff834347812ULL, 0x000fe200078ee20fULL,
0x0000000827117824ULL, 0x000fe200078e00ffULL, 0x00008a00ff0c7b82ULL, 0x000e620000000a00ULL,
0x000000082d447824ULL, 0x000fe200078e00ffULL, 0x00000006270a7212ULL, 0x000fc400078e3cffULL,
0x000000062d0f7212ULL, 0x080fe400078e3cffULL, 0xfffffff811387812ULL, 0x000fe400078ee20aULL,
0xfffffff844447812ULL, 0x000fe200078ee20fULL, 0x00004000530f7824ULL, 0x000fe200078e0208ULL,
0x0000003f050a7812ULL, 0x040fe200078ec0ffULL, 0x0000003c05057836ULL, 0x000fe20000000000ULL,
0x0000003f15127812ULL, 0x000fe200078ec0ffULL, 0x000010000f117836ULL, 0x000fe20000000000ULL,
0x0000003f17167812ULL, 0x000fe200078ec0ffULL, 0x00000001090f7824ULL, 0x000fe200078e020aULL,
0x0000003f130a7812ULL, 0x000fe200078ec0ffULL, 0x0000000805487824ULL, 0x040fe200078e00ffULL,
0x00000006052f7212ULL, 0x000fe200078e3cffULL, 0x0000000109157824ULL, 0x000fe200078e0212ULL,
0x0000003f191a7812ULL, 0x000fe200078ec0ffULL, 0x0000000109137824ULL, 0x040fe200078e020aULL,
0xfffffff8480a7812ULL, 0x000fe200078ee22fULL, 0x0000000109177824ULL, 0x000fe200078e0216ULL,
0x0000003f1b1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000109197824ULL, 0x000fe200078e021aULL,
0x0000003f1d227812ULL, 0x000fe200078ec0ffULL, 0x00000010102f7824ULL, 0x100fe200078e0211ULL,
0x0000003f1f267812ULL, 0x000fe200078ec0ffULL, 0x0000001014317824ULL, 0x100fe200078e0211ULL,
0x0000003f212a7812ULL, 0x000fe200078ec0ffULL, 0x0000001018337824ULL, 0x100fe200078e0211ULL,
0x0000003f05467812ULL, 0x000fe200078ec0ffULL, 0x000000100e057824ULL, 0x100fe200078e0211ULL,
0x0000003f232e7812ULL, 0x000fe200078ec0ffULL, 0x000000101c357824ULL, 0x100fe200078e0211ULL,
0x0000003f25327812ULL, 0x000fe200078ec0ffULL, 0x0000001020377824ULL, 0x100fe200078e0211ULL,
0x0000003f27367812ULL, 0x000fe200078ec0ffULL, 0x0000001024397824ULL, 0x100fe200078e0211ULL,
0x0000003f293a7812ULL, 0x000fe200078ec0ffULL, 0x00000010283b7824ULL, 0x100fe200078e0211ULL,
0x0000003f2b3e7812ULL, 0x000fe200078ec0ffULL, 0x000000102c3d7824ULL, 0x100fe200078e0211ULL,
0x0000003f2d427812ULL, 0x000fe200078ec0ffULL, 0x00000010303f7824ULL, 0x000fc400078e0211ULL,
0x0000001034417824ULL, 0x100fe400078e0211ULL, 0x0000001038437824ULL, 0x100fe400078e0211ULL,
0x000000103c457824ULL, 0x100fe400078e0211ULL, 0x0000001040477824ULL, 0x100fe400078e0211ULL,
0x0000001044497824ULL, 0x100fe400078e0211ULL, 0x000000100a4d7824ULL, 0x000fc400078e0211ULL,
0x00000001091b7824ULL, 0x000fe400078e021eULL, 0x0000008013107825ULL, 0x002fc800078e000cULL,
0x00000001091d7824ULL, 0x000fe400078e0222ULL, 0x0000008015127825ULL, 0x000fc800078e000cULL,
0x00000001091f7824ULL, 0x000fe400078e0226ULL, 0x0000008017147825ULL, 0x000fc800078e000cULL,
0x0000000109217824ULL, 0x000fe400078e022aULL, 0x0000008019167825ULL, 0x000fc800078e000cULL,
0x0000000109237824ULL, 0x000fe400078e022eULL, 0x000000801b187825ULL, 0x000fc800078e000cULL,
0x0000000109257824ULL, 0x040fe400078e0232ULL, 0x0000000109277824ULL, 0x040fe400078e0236ULL,
0x0000000109297824ULL, 0x040fe400078e023aULL, 0x00000001092b7824ULL, 0x040fe400078e023eULL,
0x00000001092d7824ULL, 0x040fe400078e0242ULL, 0x00000001094b7824ULL, 0x000fc400078e0246ULL,
0x000000801d1a7825ULL, 0x000fc800078e000cULL, 0x0000001006097824ULL, 0x000fe400078e00ffULL,
0x000000801f1c7825ULL, 0x000fc600078e000cULL, 0x0000007009097812ULL, 0x000fe200078ec0ffULL,
0x00000080211e7825ULL, 0x000fc800078e000cULL, 0x0000008023207825ULL, 0x000fc800078e000cULL,
0x0000008025227825ULL, 0x000fc800078e000cULL, 0x000000800f0e7825ULL, 0x000fc800078e000cULL,
0x0000008027247825ULL, 0x000fc800078e000cULL, 0x0000008029267825ULL, 0x000fc800078e000cULL,
0x000000802b287825ULL, 0x000fc800078e000cULL, 0x000000802d2a7825ULL, 0x000fc800078e000cULL,
0x000000804b2c7825ULL, 0x000fe200078e000cULL, 0x000000090e0c7210ULL, 0x000fe40007f1e0ffULL,
0x00000009100e7210ULL, 0x000fe40007f3e0ffULL, 0x0000000912107210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060fULL, 0x0000000914127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e0611ULL, 0x0000000916147210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0613ULL, 0x0000000918167210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200018e0615ULL, 0x000000091a187210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff157224ULL, 0x000fe200000e0617ULL, 0x000000091c1a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e0619ULL, 0x000000091e1c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e061bULL, 0x00000009201e7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e061dULL, 0x0000000922207210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c057faeULL, 0x0003e2000b901c4eULL,
0x0000000924227210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e061fULL,
0x0000000926247210ULL, 0x000fe20007f1e0ffULL, 0x000000000e2f7faeULL, 0x0003e2000b901c4eULL,
0x000000ffff1f7224ULL, 0x000fe200008e0621ULL, 0x0000000928267210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff217224ULL, 0x000fe200010e0623ULL, 0x0000000010317faeULL, 0x0003e2000b901c4eULL,
0x000000ffff237224ULL, 0x000fe200018e0625ULL, 0x000000092a287210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff257224ULL, 0x000fe200000e0627ULL, 0x0000000012337faeULL, 0x0003e2000b901c4eULL,
0x000000092c2a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff277224ULL, 0x000fc400008e0629ULL,
0x0000000014357faeULL, 0x0003e2000b901c4eULL, 0x000000ffff297224ULL, 0x000fe400010e062bULL,
0x000000ffff2b7224ULL, 0x000fe200018e062dULL, 0x0000000016377faeULL, 0x0003e8000b901c4eULL,
0x0000000018397faeULL, 0x0003e8000b901c4eULL, 0x000000001a3b7faeULL, 0x0003e8000b901c4eULL,
0x000000001c3d7faeULL, 0x0003e8000b901c4eULL, 0x000000001e3f7faeULL, 0x0003e8000b901c4eULL,
0x0000000020417faeULL, 0x0003e8000b901c4eULL, 0x0000000022437faeULL, 0x0003e8000b901c4eULL,
0x0000000024457faeULL, 0x0003e8000b901c4eULL, 0x0000000026477faeULL, 0x0003e8000b901c4eULL,
0x0000000028497faeULL, 0x0003e8000b901c4eULL, 0x000000002a4d7faeULL, 0x0003e4000b901c4eULL,
0x0000000400037824ULL, 0x000fe400078e0203ULL, 0xffffffffff057424ULL, 0x002fc600078e00ffULL,
0x0000000503007c0cULL, 0x000fda000bf06070ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00009000ff057b82ULL, 0x000e620000000800ULL, 0x000000020b0a7824ULL, 0x000fce00078e00ffULL,
0x00008c00ff0c7b82ULL, 0x000ea20000000a00ULL, 0x000000050a057224ULL, 0x002fc800078e0203ULL,
0x00000004050c7825ULL, 0x004fca00078e000cULL, 0x0000000e0c057981ULL, 0x000364000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01b600ff080075a7ULL, 0x000ea2000800017fULL,
0x000000035300780cULL, 0x000fe20003f24070ULL, 0x00000001ff197424ULL, 0x000fe400078e00ffULL,
0x80000000ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000004000dc8947ULL, 0x004ff20003800000ULL,
0x0000000000601947ULL, 0x000fea0003800000ULL, 0x0000002053097824ULL, 0x000fc800078e0206ULL,
0x00000010090c7824ULL, 0x002fe200078e00ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011609ULL,
0x1ffffffe0a0a7812ULL, 0x000fe400078ec0ffULL, 0x000000f00c0d7812ULL, 0x000fe400078ec0ffULL,
0x000000010a0c7812ULL, 0x000fe400078efcffULL, 0x000000070a0a7812ULL, 0x000fe400078e7809ULL,
0x000000070c0c7812ULL, 0x000fc600078e7809ULL, 0x000000010a097824ULL, 0x000fe400078e020dULL,
0x000000010d0d7824ULL, 0x000fe400078e020cULL, 0x0000001009097824ULL, 0x100fe400078e0208ULL,
0x000000100d0d7824ULL, 0x000fc600078e0208ULL, 0x0000000009147984ULL, 0x000e680000000c00ULL,
0x000000000d107984ULL, 0x000ea20000000c00ULL, 0x000000ffff1c7224ULL, 0x002fe400078e0014ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0016ULL,
0x000000ffff157224ULL, 0x000fc400078e0017ULL, 0x000000ffff1e7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0012ULL, 0x000000ffff167224ULL, 0x000fe400078e0011ULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x0000001c09007388ULL, 0x0003e80000000c00ULL,
0x000000140d007388ULL, 0x0003e40000000c00ULL, 0x01b6001908ff79a7ULL, 0x0005e2000850003fULL,
0x0000000651007c0cULL, 0x000fe2000bf26070ULL, 0x01b6000f080075a7ULL, 0x000ee4000800017fULL,
0x0000004000808947ULL, 0x00cff40003800000ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x00009000ff0a7b82ULL, 0x000ea20000000800ULL, 0x3db504f307077820ULL, 0x000fe20000410000ULL,
0x0000001053097824ULL, 0x002fe200078e0208ULL, 0xffffffff06047890ULL, 0x000fe2000fffe03fULL,
0x000000ffff107224ULL, 0x000fe400078e00ffULL, 0x0000000a0b0a7224ULL, 0x004fe200078e02ffULL,
0x00007610ff0b7816ULL, 0x000fd0000000000bULL, 0x0000010051387824ULL, 0x000fca00078e0204ULL,
0x0000001038007c0cULL, 0x000fda000bf01070ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000100397824ULL, 0x000fe200078e0251ULL, 0x00000001103a7812ULL, 0x000fc600078e0cffULL,
0x00000001390c7836ULL, 0x000fca0000000000ULL, 0x000000060c007c0cULL, 0x000fda000bf06070ULL,
0x0000000c00388947ULL, 0x000fea0003800000ULL, 0x00000003ff3b7819ULL, 0x000fe20000011606ULL,
0x00008a00ff0e7b82ULL, 0x000e620000000a00ULL, 0x0000010039167824ULL, 0x000fc600078e0204ULL,
0x000000043b117836ULL, 0x040fe40000000000ULL, 0x000000083b177836ULL, 0x000fe20000000000ULL,
0x00000010160d7c48ULL, 0x000fe2000ffe0000ULL, 0x0000000811137824ULL, 0x040fe200078e00ffULL,
0x00000006110c7212ULL, 0x080fe200078e3cffULL, 0x0000000817157824ULL, 0x040fe200078e00ffULL,
0x0000000617127212ULL, 0x080fe200078e3cffULL, 0x0000000c3b197836ULL, 0x040fe20000000000ULL,
0xfffffff813287812ULL, 0x000fe200078ee20cULL, 0x00000007020c7e24ULL, 0x020fe2000f8e0205ULL,
0x0000003f3b137812ULL, 0x040fe200078ec0ffULL, 0x000000103b1b7836ULL, 0x000fe20000000000ULL,
0xfffffff8152a7812ULL, 0x000fe200078ee212ULL, 0x000000010d167824ULL, 0x000fe200078e0a16ULL,
0x00000006190d7212ULL, 0x0c0fe200078e3cffULL, 0x00000008192c7824ULL, 0x000fe200078e00ffULL,
0x000000061b1e7212ULL, 0x000fe200078e3cffULL, 0x0000001006057824ULL, 0x000fe200078e00ffULL,
0x000000161700720cULL, 0x000fe20003fa6070ULL, 0x0000000113137824ULL, 0x000fe200078e020cULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee20dULL, 0x000000081b157824ULL, 0x000fe200078e00ffULL,
0x0000007005057812ULL, 0x000fe200078ec0ffULL, 0x000000183b217836ULL, 0x000fe20000000000ULL,
0x0000003f110d7812ULL, 0x000fe200078ec0ffULL, 0x0000008013127825ULL, 0x002fe200078e000eULL,
0xfffffff8151e7812ULL, 0x000fc400078ee21eULL, 0x0000000621227212ULL, 0x040fe200078e3cffULL,
0x0000000821157824ULL, 0x000fe200078e00ffULL, 0x0000000512147210ULL, 0x000fe20007f1e0ffULL,
0x000000010d0d7824ULL, 0x000fe200078e020cULL, 0x0000003f17177812ULL, 0x000fe200078ec0ffULL,
0x0000001c3b277836ULL, 0x000fe20000000000ULL, 0xfffffff815227812ULL, 0x000fe200078ee222ULL,
0x000000ffff157224ULL, 0x000fe200000e0613ULL, 0x000000161900720cULL, 0x080fe20003f26070ULL,
0x000000800d127825ULL, 0x000fe200078e000eULL, 0x000000161b00720cULL, 0x000fc40003f06070ULL,
0x0000003f19197812ULL, 0x000fe200078ec0ffULL, 0x00000001170d7824ULL, 0x000fe200078e020cULL,
0x00000005121c7210ULL, 0x000fe20007f5e0ffULL, 0x000000143b1f7836ULL, 0x000fe20000000000ULL,
0x0000003f1b1b7812ULL, 0x000fe200078ec0ffULL, 0x00000008272e7824ULL, 0x000fe200078e00ffULL,
0x000000161100720cULL, 0x000fe20003f86070ULL, 0x000000ffff1d7224ULL, 0x000fe200010e0613ULL,
0x000000061f207212ULL, 0x080fe200078e3cffULL, 0x000000800d127825ULL, 0x000fe200078e000eULL,
0x00000006270d7212ULL, 0x000fc400078e3cffULL, 0x000000063b177212ULL, 0x000fe200078e3cffULL,
0x0000000119197824ULL, 0x100fe200078e020cULL, 0x0000000512247210ULL, 0x000fe20007f5e0ffULL,
0x000000011b1b7824ULL, 0x000fe200078e020cULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee20dULL,
0x000000081f117824ULL, 0x000fe200078e00ffULL, 0x0000000717177812ULL, 0x000fe200078ec0ffULL,
0x0000008019187825ULL, 0x000fc600078e000eULL, 0xfffffff811207812ULL, 0x000fe200078ee220ULL,
0x000000801b1a7825ULL, 0x000fe200078e000eULL, 0x0000000518187210ULL, 0x000fe40007f7e0ffULL,
0x0ffffff817267812ULL, 0x000fe200078ef806ULL, 0x00004000530d7824ULL, 0x000fe200078e0208ULL,
0x000000051a127210ULL, 0x000fe20007fde0ffULL, 0x000000ffff257224ULL, 0x000fe200010e0613ULL,
0x000000163b00720cULL, 0x040fe20003f46070ULL, 0x000020003a117824ULL, 0x000fe400078e020dULL,
0x000000203b297836ULL, 0x000fc40000000000ULL, 0x000000243b2b7836ULL, 0x000fe40000000000ULL,
0x0000100011117836ULL, 0x000fe40000000000ULL, 0x000000ffff197224ULL, 0x000fe200018e0619ULL,
0x000000161f00720cULL, 0x040fe20003f66070ULL, 0x000000ffff137224ULL, 0x000fe200030e061bULL,
0x0000003f1f1b7812ULL, 0x000fe200078ec0ffULL, 0x0000000829307824ULL, 0x040fe200078e00ffULL,
0x00000006291f7212ULL, 0x080fe200078e3cffULL, 0x000000082b327824ULL, 0x040fe200078e00ffULL,
0x000000062b237212ULL, 0x000fe200078e3cffULL, 0x0000001026177824ULL, 0x100fe200078e0211ULL,
0xfffffff830267812ULL, 0x000fe200078ee21fULL, 0x000000283b2d7836ULL, 0x000fe20000000000ULL,
0xfffffff832307812ULL, 0x000fe200078ee223ULL, 0x00000010281f7824ULL, 0x100fe200078e0211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000d101c4eULL,
0x000000162100720cULL, 0x080fe20003f46070ULL, 0x000000011b1b7824ULL, 0x000fe200078e020cULL,
0x0000003f21237812ULL, 0x000fe200078ec0ffULL, 0x000000102a217824ULL, 0x000fe200078e0211ULL,
0x000000001c1f7faeULL, 0x0005e2000e101c4eULL, 0x000000082d287824ULL, 0x000fe200078e00ffULL,
0x000000162900720cULL, 0x080fe20003f86070ULL, 0x000000801b1a7825ULL, 0x000fe200078e000eULL,
0x0000000024217faeULL, 0x000fe2000e901c4eULL, 0x000000162700720cULL, 0x000fc40003fa6070ULL,
0x000000062d177212ULL, 0x002fe200078e3cffULL, 0x0000000123237824ULL, 0x000fe200078e020cULL,
0x0000003f27277812ULL, 0x000fe200078ec0ffULL, 0x000000343b317836ULL, 0x000fe20000000000ULL,
0xfffffff828287812ULL, 0x000fe200078ee217ULL, 0x000000102c177824ULL, 0x000fe200078e0211ULL,
0x000000051a1a7210ULL, 0x000fe20007fde0ffULL, 0x0000008023147825ULL, 0x000fe200078e000eULL,
0x0000003f2b1f7812ULL, 0x004fe400078ec0ffULL, 0x0000000018177faeULL, 0x0003e2000c901c4eULL,
0x00000001271d7824ULL, 0x000fe200078e020cULL, 0x000000162b00720cULL, 0x000fe20003f26070ULL,
0x000000303b2b7836ULL, 0x000fe20000000000ULL, 0x0000003f29297812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1b7224ULL, 0x000fe200030e061bULL, 0x0000000514147210ULL, 0x000fe20007fde0ffULL,
0x000000801d1c7825ULL, 0x000fc800078e000eULL, 0x000000082b2c7824ULL, 0x040fe200078e00ffULL,
0x000000062b177212ULL, 0x002fe200078e3cffULL, 0x0000000129257824ULL, 0x100fe400078e020cULL,
0x000000011f1f7824ULL, 0x000fe200078e020cULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee217ULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x000000051c1c7210ULL, 0x000fe20007fde0ffULL,
0x0000002c3b2f7836ULL, 0x000fe40000000000ULL, 0x0000008025247825ULL, 0x000fc600078e000eULL,
0x000000062f217212ULL, 0x080fe200078e3cffULL, 0x000000801f187825ULL, 0x000fe200078e000eULL,
0x00000006311f7212ULL, 0x000fc600078e3cffULL, 0x0000000831327824ULL, 0x000fe400078e00ffULL,
0x000000101e177824ULL, 0x000fe400078e0211ULL, 0x000000082f2a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8321e7812ULL, 0x000fe200078ee21fULL, 0x000000ffff1d7224ULL, 0x000fe200030e061dULL,
0x0000000524247210ULL, 0x000fe20007fde0ffULL, 0x0000000012177faeULL, 0x0003e2000c101c4eULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee221ULL, 0x00000010201f7824ULL, 0x100fe200078e0211ULL,
0x000000162d00720cULL, 0x0c0fe20003f06070ULL, 0x0000001022217824ULL, 0x000fe200078e0211ULL,
0x0000003f2d2d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0x0000000518187210ULL, 0x000fe20007fde0ffULL, 0x000000001a1f7faeULL, 0x0005e2000d901c4eULL,
0x000000102e237824ULL, 0x100fe200078e0211ULL, 0x000000163100720cULL, 0x080fe20003f66070ULL,
0x0000001026277824ULL, 0x000fe200078e0211ULL, 0x0000000014217faeULL, 0x0007e2000d101c4eULL,
0x000000012d137824ULL, 0x002fe200078e020cULL, 0x0000003f2b177812ULL, 0x000fe200078ec0ffULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x000000001c237faeULL, 0x0003e2000e901c4eULL,
0x0000001030297824ULL, 0x000fe200078e0211ULL, 0x000000162f00720cULL, 0x000fe20003fa6070ULL,
0x0000008013127825ULL, 0x000fe200078e000eULL, 0x0000000024277faeULL, 0x000fe2000e101c4eULL,
0x0000003f311b7812ULL, 0x004fc400078ec0ffULL, 0x000000383b337836ULL, 0x000fe20000000000ULL,
0x0000003f2f157812ULL, 0x008fe200078ec0ffULL, 0x0000000018297faeULL, 0x0005e2000c901c4eULL,
0x0000003c3b217836ULL, 0x000fe20000000000ULL, 0x000000162b00720cULL, 0x080fe20003f86070ULL,
0x0000000117177824ULL, 0x100fe200078e020cULL, 0x000000163300720cULL, 0x080fe20003f46070ULL,
0x0000000115157824ULL, 0x100fe200078e020cULL, 0x000000162100720cULL, 0x000fe20003f26070ULL,
0x000000011b1b7824ULL, 0x000fe200078e020cULL, 0x0000003f331d7812ULL, 0x002fe200078ec0ffULL,
0x0000008015147825ULL, 0x000fe200078e000eULL, 0x0000003f211f7812ULL, 0x000fc400078ec0ffULL,
0x0000000512187210ULL, 0x004fe20007fde0ffULL, 0x000000011d1d7824ULL, 0x100fe200078e020cULL,
0x00000006211c7212ULL, 0x080fe200078e3cffULL, 0x000000011f1f7824ULL, 0x000fe200078e020cULL,
0x00000006330c7212ULL, 0x000fe200078e3cffULL, 0x000000ffff197224ULL, 0x000fe200030e0613ULL,
0x0000000514167210ULL, 0x000fe20007fde0ffULL, 0x0000008017127825ULL, 0x000fc800078e000eULL,
0x000000ffff177224ULL, 0x000fe200030e0615ULL, 0x00000005121a7210ULL, 0x000fe20007fde0ffULL,
0x000000801b147825ULL, 0x000fc800078e000eULL, 0x000000ffff1b7224ULL, 0x000fe200030e0613ULL,
0x0000000514147210ULL, 0x000fe20007fde0ffULL, 0x000000801d127825ULL, 0x000fc800078e000eULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x0000000512127210ULL, 0x000fe20007fde0ffULL,
0x0000000833337824ULL, 0x000fe400078e00ffULL, 0x0000000821217824ULL, 0x000fe400078e00ffULL,
0x000000801f0e7825ULL, 0x000fe200078e000eULL, 0xfffffff8330c7812ULL, 0x000fe400078ee20cULL,
0xfffffff8211c7812ULL, 0x000fe200078ee21cULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x000000050e0e7210ULL, 0x000fe20007fde0ffULL, 0x00000010281d7824ULL, 0x000fc400078e0211ULL,
0x000000102a1f7824ULL, 0x100fe400078e0211ULL, 0x000000102c217824ULL, 0x100fe200078e0211ULL,
0x00000000181d7faeULL, 0x0009e2000c101c4eULL, 0x000000101e057824ULL, 0x100fe400078e0211ULL,
0x000000100c237824ULL, 0x100fe200078e0211ULL, 0x00000000161f7faeULL, 0x0009e2000e901c4eULL,
0x000000101c117824ULL, 0x000fe400078e0211ULL, 0x000000ffff0f7224ULL, 0x000fe200030e060fULL,
0x000000001a217faeULL, 0x0009e8000e101c4eULL, 0x0000000014057faeULL, 0x0009e8000d901c4eULL,
0x0000000012237faeULL, 0x0009e8000d101c4eULL, 0x000000000e117faeULL, 0x0009e2000c901c4eULL,
0x0000000800e87947ULL, 0x000fea0003800000ULL, 0x00000003ff3b7819ULL, 0x000fe20000011606ULL,
0x0000000702057e24ULL, 0x020fc6000f8e0205ULL, 0x000000063b117212ULL, 0x0c0fe200078e3cffULL,
0x000000083b177836ULL, 0x040fe40000000000ULL, 0x000000183b277836ULL, 0x000fe20000000000ULL,
0x0000000711117812ULL, 0x000fe200078ec0ffULL, 0x00000008170e7824ULL, 0x040fe200078e00ffULL,
0x00000006170d7212ULL, 0x080fe200078e3cffULL, 0x000000143b237836ULL, 0x000fe20000000000ULL,
0x00000006270f7212ULL, 0x0c0fe200078e3cffULL, 0x0000000827147824ULL, 0x000fe200078e00ffULL,
0xfffffff80e1b7812ULL, 0x000fe200078ee20dULL, 0x000000103b217836ULL, 0x000fe20000000000ULL,
0x00000006230e7212ULL, 0x0c0fe200078e3cffULL, 0x0000000823257824ULL, 0x000fe200078e00ffULL,
0xfffffff814337812ULL, 0x000fe200078ee20fULL, 0x000000243b2f7836ULL, 0x000fe20000000000ULL,
0x00000006210d7212ULL, 0x080fe200078e3cffULL, 0x000000283b3d7836ULL, 0x040fe20000000000ULL,
0xfffffff825257812ULL, 0x000fe200078ee20eULL, 0x000000043b137836ULL, 0x000fe20000000000ULL,
0x000000062f0e7212ULL, 0x080fe200078e3cffULL, 0x0000000821127824ULL, 0x000fe200078e00ffULL,
0x000000063d0f7212ULL, 0x080fe200078e3cffULL, 0x000000082f377824ULL, 0x000fe200078e00ffULL,
0x00000006130c7212ULL, 0x080fe200078e3cffULL, 0x000000083d147824ULL, 0x000fe200078e00ffULL,
0xfffffff812317812ULL, 0x000fe200078ee20dULL, 0x0000000813197824ULL, 0x000fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fe200078ee20eULL, 0x000000203b2d7836ULL, 0x040fe20000000000ULL,
0xfffffff814417812ULL, 0x000fe200078ee20fULL, 0x000000343b477836ULL, 0x040fe20000000000ULL,
0xfffffff819197812ULL, 0x000fe200078ee20cULL, 0x000000383b4b7836ULL, 0x000fe20000000000ULL,
0x000000062d0d7212ULL, 0x080fe200078e3cffULL, 0x0000000c3b1d7836ULL, 0x000fe20000000000ULL,
0x00000006470e7212ULL, 0x080fe200078e3cffULL, 0x000000082d127824ULL, 0x000fe200078e00ffULL,
0x000000064b0f7212ULL, 0x080fe200078e3cffULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0x000000061d0c7212ULL, 0x080fe200078e3cffULL, 0x00000008474d7824ULL, 0x000fe200078e00ffULL,
0xfffffff812357812ULL, 0x000fe200078ee20dULL, 0x000000084b147824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee20cULL, 0x0000001c3b297836ULL, 0x040fe20000000000ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee20eULL, 0x000000303b437836ULL, 0x000fe20000000000ULL,
0xfffffff814557812ULL, 0x000fe200078ee20fULL, 0x00000008292b7824ULL, 0x040fe200078e00ffULL,
0x00000006290c7212ULL, 0x080fe200078e3cffULL, 0x0000000843127824ULL, 0x040fe200078e00ffULL,
0x00000006430d7212ULL, 0x080fe200078e3cffULL, 0x0000002c3b3f7836ULL, 0x040fe20000000000ULL,
0x00008a00ff0e7b82ULL, 0x000e620000000a00ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee20cULL,
0x0000003c3b4f7836ULL, 0x000fe20000000000ULL, 0xfffffff812497812ULL, 0x000fe200078ee20dULL,
0x000000083f457824ULL, 0x040fe200078e00ffULL, 0x000000063f0c7212ULL, 0x080fe200078e3cffULL,
0x00004000530d7824ULL, 0x000fe200078e0208ULL, 0x000000064f307212ULL, 0x040fe200078e3cffULL,
0x000000084f597824ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee20cULL,
0x000020003a127824ULL, 0x000fe200078e020dULL, 0x0000003f3b0c7812ULL, 0x000fc400078ec0ffULL,
0x0000003f1d167812ULL, 0x000fe200078ec0ffULL, 0x0000100012147836ULL, 0x000fe20000000000ULL,
0x0000003f17127812ULL, 0x000fe200078ec0ffULL, 0x000000010c157824ULL, 0x100fe200078e0205ULL,
0x0000003f130c7812ULL, 0x000fe200078ec0ffULL, 0x00000001161d7824ULL, 0x100fe200078e0205ULL,
0x0000003f21187812ULL, 0x000fe200078ec0ffULL, 0x0000000112137824ULL, 0x100fe200078e0205ULL,
0x0000003f231a7812ULL, 0x000fe200078ec0ffULL, 0x0000001006127824ULL, 0x000fe200078e00ffULL,
0x0000003f271c7812ULL, 0x000fe200078ec0ffULL, 0x000000010c177824ULL, 0x100fe200078e0205ULL,
0x0000003f291e7812ULL, 0x000fe200078ec0ffULL, 0x0000000118217824ULL, 0x100fe200078e0205ULL,
0x0000003f2d207812ULL, 0x000fe200078ec0ffULL, 0x000000011a237824ULL, 0x100fe200078e0205ULL,
0x0000003f2f227812ULL, 0x000fe200078ec0ffULL, 0x000000011c277824ULL, 0x100fe200078e0205ULL,
0x0000003f3d247812ULL, 0x000fe200078ec0ffULL, 0x000000011e297824ULL, 0x100fe200078e0205ULL,
0x0000003f3f267812ULL, 0x000fe200078ec0ffULL, 0x00000001202d7824ULL, 0x100fe200078e0205ULL,
0x0000003f43287812ULL, 0x000fe200078ec0ffULL, 0x00000001222f7824ULL, 0x100fe200078e0205ULL,
0x0000003f472a7812ULL, 0x000fe200078ec0ffULL, 0x00000001243f7824ULL, 0x100fe200078e0205ULL,
0x0000003f4b2c7812ULL, 0x000fe200078ec0ffULL, 0x0000000126437824ULL, 0x100fe200078e0205ULL,
0x0000003f4f2e7812ULL, 0x000fe200078ec0ffULL, 0x0000000128477824ULL, 0x100fe200078e0205ULL,
0x0ffffff811117812ULL, 0x000fe200078ef806ULL, 0x000000012a4b7824ULL, 0x100fe200078e0205ULL,
0xfffffff859597812ULL, 0x000fe200078ee230ULL, 0x000000012c4f7824ULL, 0x000fc400078e0205ULL,
0x000000012e577824ULL, 0x000fe400078e0205ULL, 0x0000001011057824ULL, 0x100fe400078e0214ULL,
0x00000010190c7824ULL, 0x100fe400078e0214ULL, 0x000000101b117824ULL, 0x100fe400078e0214ULL,
0x000000101f307824ULL, 0x100fe400078e0214ULL, 0x0000001031317824ULL, 0x000fc400078e0214ULL,
0x0000001025327824ULL, 0x100fe400078e0214ULL, 0x0000001033337824ULL, 0x100fe400078e0214ULL,
0x000000102b347824ULL, 0x100fe400078e0214ULL, 0x0000001035357824ULL, 0x100fe400078e0214ULL,
0x00000010373d7824ULL, 0x100fe200078e0214ULL, 0x0000007012377812ULL, 0x000fe200078ec0ffULL,
0x0000001041417824ULL, 0x000fc400078e0214ULL, 0x0000001045457824ULL, 0x100fe400078e0214ULL,
0x0000001049497824ULL, 0x100fe400078e0214ULL, 0x000000104d4d7824ULL, 0x100fe400078e0214ULL,
0x0000001055557824ULL, 0x100fe400078e0214ULL, 0x0000001059597824ULL, 0x000fe400078e0214ULL,
0x0000008015147825ULL, 0x002fc800078e000eULL, 0x0000008017167825ULL, 0x000fe200078e000eULL,
0x0000003714147210ULL, 0x000fc60007f1e0ffULL, 0x0000008013187825ULL, 0x000fe200078e000eULL,
0x0000003716167210ULL, 0x000fc60007f3e0ffULL, 0x000000801d1a7825ULL, 0x000fe200078e000eULL,
0x0000003718187210ULL, 0x000fc60007f5e0ffULL, 0x00000080211c7825ULL, 0x000fe200078e000eULL,
0x000000371a1a7210ULL, 0x000fc60007f7e0ffULL, 0x00000080231e7825ULL, 0x000fc800078e000eULL,
0x0000008027207825ULL, 0x000fc800078e000eULL, 0x0000008029227825ULL, 0x000fc800078e000eULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x000000371c1c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e0617ULL, 0x000000371e1e7210ULL, 0x000fe20007f3e0ffULL,
0x000000802d247825ULL, 0x000fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014057faeULL, 0x0003e6000b901c4eULL, 0x000000ffff197224ULL, 0x000fe200010e0619ULL,
0x0000003720207210ULL, 0x000fe20007f5e0ffULL, 0x000000802f267825ULL, 0x000fe200078e000eULL,
0x00000000160c7faeULL, 0x0003e6000b901c4eULL, 0x000000ffff1b7224ULL, 0x000fe200018e061bULL,
0x0000003722227210ULL, 0x000fe20007f7e0ffULL, 0x000000803f287825ULL, 0x100fe200078e000eULL,
0x0000000018117faeULL, 0x0003e6000b901c4eULL, 0x00000080432a7825ULL, 0x000fe200078e000eULL,
0x000000001a307faeULL, 0x0003e6000b901c4eULL, 0x000000ffff1d7224ULL, 0x000fe200000e061dULL,
0x0000003724247210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e061fULL,
0x0000003726267210ULL, 0x000fe20007f3e0ffULL, 0x00000080472c7825ULL, 0x000fe200078e000eULL,
0x000000001c317faeULL, 0x0003e6000b901c4eULL, 0x000000ffff217224ULL, 0x000fe200010e0621ULL,
0x0000003728287210ULL, 0x000fe20007f5e0ffULL, 0x000000804b2e7825ULL, 0x000fe200078e000eULL,
0x000000001e327faeULL, 0x0003e6000b901c4eULL, 0x000000ffff237224ULL, 0x000fe200018e0623ULL,
0x000000372a2a7210ULL, 0x000fe20007f7e0ffULL, 0x000000804f127825ULL, 0x100fe200078e000eULL,
0x0000000020337faeULL, 0x0003e6000b901c4eULL, 0x00000080570e7825ULL, 0x000fe200078e000eULL,
0x0000000022347faeULL, 0x0003e6000b901c4eULL, 0x000000ffff257224ULL, 0x000fe200000e0625ULL,
0x000000372c2c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff277224ULL, 0x000fe200008e0627ULL,
0x000000372e2e7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff297224ULL, 0x000fe200010e0629ULL,
0x0000003712127210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200018e062bULL,
0x000000370e0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2d7224ULL, 0x000fe200000e062dULL,
0x0000000024357faeULL, 0x0003e2000b901c4eULL, 0x000000ffff2f7224ULL, 0x000fc400008e062fULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x00000000263d7faeULL, 0x0003e2000b901c4eULL,
0x000000ffff0f7224ULL, 0x000fc600018e060fULL, 0x0000000028417faeULL, 0x0003e8000b901c4eULL,
0x000000002a457faeULL, 0x0003e8000b901c4eULL, 0x000000002c497faeULL, 0x0003e8000b901c4eULL,
0x000000002e4d7faeULL, 0x0003e8000b901c4eULL, 0x0000000012557faeULL, 0x0003e8000b901c4eULL,
0x000000000e597faeULL, 0x0003e4000b901c4eULL, 0x0000000400037824ULL, 0x000fe200078e0203ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff057424ULL, 0x012fc600078e00ffULL,
0x0000000503007c0cULL, 0x000fda000bf06070ULL, 0x00008c00ff0e8b82ULL, 0x000e620000000a00ULL,
0x000000020a118824ULL, 0x000fe400078e0203ULL, 0x0000200010427824ULL, 0x000fe200078e020dULL,
0xfffffff806417812ULL, 0x040fe400078ec0ffULL, 0x00000007063f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x00000004ff3d7819ULL, 0x000fe40000011606ULL,
0x0000000000347805ULL, 0x000fc4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fc4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fc4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000004110e8825ULL, 0x002fe200078e000eULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000e0e058981ULL, 0x000362000c1e1900ULL,
0x00000020060d7836ULL, 0x000fe20000000000ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000100042427836ULL, 0x000fe20000000000ULL, 0x0000000741417812ULL, 0x000fe400078ef806ULL,
0xfffffff80d0d7812ULL, 0x000fe400078ec0ffULL, 0x000000083f407812ULL, 0x000fe400078ef806ULL,
0x000000070d3c7812ULL, 0x002fce00078ef806ULL, 0x000000073e0c7812ULL, 0x000fe200078e7841ULL,
0x000000023e7b7824ULL, 0x000fc800078e023dULL, 0x00000008410d7824ULL, 0x000fc800078e020cULL,
0x000000100d147824ULL, 0x000fe200078e0242ULL, 0x000000073e0d7812ULL, 0x000fca00078e783cULL,
0x000000001414783bULL, 0x000e620000000200ULL, 0x000000083c0d7824ULL, 0x000fc800078e020dULL,
0x000000100d0d7824ULL, 0x000fcc00078e0242ULL, 0x000000000d0c783bULL, 0x000ea20000000200ULL,
0x00000018ff5a7819ULL, 0x002fe20000011414ULL, 0x0001000014187824ULL, 0x040fe200078e00ffULL,
0x0000888014617816ULL, 0x040fe200000000ffULL, 0x0000010014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011415ULL, 0x0001000015197824ULL, 0x040fe200078e00ffULL,
0x0000888015627816ULL, 0x040fe200000000ffULL, 0x0000010015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000005a005a7306ULL, 0x000fe20000202400ULL,
0x00000018ff597819ULL, 0x000fc40000011416ULL, 0x0000888016587816ULL, 0x000fe400000000ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000018ff657819ULL, 0x000fe20000011417ULL,
0x00000014005d7306ULL, 0x0002e20000202400ULL, 0x0000888017707816ULL, 0x000fe400000000ffULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x00000018ff197819ULL, 0x000fc40000011419ULL,
0x00000018ff647819ULL, 0x004fe2000001140dULL, 0x0000001500777306ULL, 0x0005e20000202400ULL,
0x0001000016147824ULL, 0x042fe200078e00ffULL, 0x000088800d687816ULL, 0x000fe200000000ffULL,
0x0000010016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001140cULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0001000017157824ULL, 0x044fe200078e00ffULL, 0x0000001800747306ULL, 0x000fe20000202400ULL,
0x0000010017177824ULL, 0x000fe200078e00ffULL, 0x000088800c6c7816ULL, 0x000fc400000000ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x0000001600727306ULL, 0x0003e20000202400ULL, 0x00000018ff567819ULL, 0x000fe4000001140eULL,
0x00000018ff437819ULL, 0x000fe4000001140fULL, 0x000088800e667816ULL, 0x000fe400000000ffULL,
0x000088800f607816ULL, 0x000fe200000000ffULL, 0x00000017006e7306ULL, 0x0005e20000202400ULL,
0x000000013e167836ULL, 0x002fc40000000000ULL, 0x000000023e3e7836ULL, 0x000fc60000000000ULL,
0x0000000716187812ULL, 0x000fe400078e7841ULL, 0x0000001900797306ULL, 0x0003e20000202400ULL,
0x0000000716457812ULL, 0x000fe400078e783cULL, 0x0000000841177824ULL, 0x004fe200078e0218ULL,
0x000000083e00780cULL, 0x000fe40003f05270ULL, 0x000000083c457824ULL, 0x000fe400078e0245ULL,
0x0000001017177824ULL, 0x000fe200078e0242ULL, 0x0000001500737306ULL, 0x0005e80000202400ULL,
0x000000001718783bULL, 0x002e680000000200ULL, 0x0000001400757306ULL, 0x0009e20000202400ULL,
0x000100000d157824ULL, 0x004fc400078e00ffULL, 0x000001000d0d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x000100000c147824ULL, 0x050fe200078e00ffULL, 0x00000015006d7306ULL, 0x000fe20000202400ULL,
0x000001000c0c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff0c7819ULL, 0x000fe4000001140cULL, 0x0000000d006b7306ULL, 0x0005f00000202400ULL,
0x0000000c006f7306ULL, 0x0009e20000202400ULL, 0x000100000f0d7824ULL, 0x004fc400078e00ffULL,
0x000001000f0f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff0d7819ULL, 0x000fe4000001140dULL,
0x0000001400717306ULL, 0x0005e20000202400ULL, 0x000100000e0c7824ULL, 0x050fe200078e00ffULL,
0x00000018ff0f7819ULL, 0x000fe2000001140fULL, 0x000001000e0e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff447819ULL, 0x002fe40000011418ULL, 0x00000018ff0c7819ULL, 0x000fe4000001140cULL,
0x0000000d00637306ULL, 0x0003e20000202400ULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x0000001045147824ULL, 0x004fe200078e0242ULL, 0x0000888018467816ULL, 0x000fc400000000ffULL,
0x00000018ff4c7819ULL, 0x000fe40000011419ULL, 0x00008880194d7816ULL, 0x040fe200000000ffULL,
0x0000000c00697306ULL, 0x0005e20000202400ULL, 0x00010000190d7824ULL, 0x042fe200078e00ffULL,
0x000000001414783bULL, 0x000e620000000200ULL, 0x0000010019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001141aULL, 0x00000018ff507819ULL, 0x000fe4000001140dULL,
0x000000077b0d7812ULL, 0x000fe200078e7840ULL, 0x00010000180c7824ULL, 0x044fe200078e00ffULL,
0x0000000e00677306ULL, 0x000fe20000202400ULL, 0x0000010018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x00000010400d7824ULL, 0x000fe200078e020dULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x000000027b7b7836ULL, 0x000fe20000000000ULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x000000100d0d7824ULL, 0x000fe200078e0208ULL,
0x0000000c004f7306ULL, 0x0005e20000202400ULL, 0x00000018ff4a7819ULL, 0x000fc4000001141bULL,
0x000000077b7b7812ULL, 0x000fe400078e7840ULL, 0x000088801a4e7816ULL, 0x040fe400000000ffULL,
0x000088801b527816ULL, 0x000fe200000000ffULL, 0x0000000f005e7306ULL, 0x0009e20000202400ULL,
0x000100001a0c7824ULL, 0x044fe400078e00ffULL, 0x000001001a1a7824ULL, 0x000fe400078e00ffULL,
0x00000010407b7824ULL, 0x000fe200078e027bULL, 0x00000018ff5b7819ULL, 0x000fc4000001140cULL,
0x0000006100617306ULL, 0x000ea20000202400ULL, 0x000000000d0c783bULL, 0x010f220000000200ULL,
0x00000018ff1a7819ULL, 0x000fcc000001141aULL, 0x0000001800557306ULL, 0x0005e20000202400ULL,
0x00000018ff497819ULL, 0x002fe40000011414ULL, 0x00000018ff487819ULL, 0x000fe40000011415ULL,
0x00000018ff477819ULL, 0x000fe40000011416ULL, 0x00000018ff457819ULL, 0x000fe20000011417ULL,
0x0000001900577306ULL, 0x0007e20000202400ULL, 0x000100001b187824ULL, 0x044fe400078e00ffULL,
0x000001001b1b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000005c005c7306ULL, 0x000fe20000202400ULL, 0x000054105d197816ULL, 0x008fe4000000005aULL,
0x00008880145a7816ULL, 0x000fe400000000ffULL, 0x00000018ff1b7819ULL, 0x000fc6000001141bULL,
0x00000018005f7306ULL, 0x0003f00000202400ULL, 0x0000005900597306ULL, 0x000ea20000202400ULL,
0x0000541061187816ULL, 0x002fce0000000074ULL, 0x0000006200627306ULL, 0x000e620000202400ULL,
0x000000180c34723cULL, 0x010fe20000041834ULL, 0x0000541072597816ULL, 0x004fcc0000000059ULL,
0x0000005800587306ULL, 0x000ea20000202400ULL, 0x0001000014197824ULL, 0x040fe400078e00ffULL,
0x0000010014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000006500657306ULL, 0x000ee20000202400ULL, 0x0000541062187816ULL, 0x002fe40000000079ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000888015627816ULL, 0x040fe400000000ffULL,
0x0000541058587816ULL, 0x004fe20000000075ULL, 0x0000007000707306ULL, 0x000e6c0000202400ULL,
0x000000580c2c723cULL, 0x000fe4000004182cULL, 0x0000001900617306ULL, 0x0005ea0000202400ULL,
0x0000010015587824ULL, 0x000fc600078e00ffULL, 0x0000006a006a7306ULL, 0x000fe20000202400ULL,
0x0000541077197816ULL, 0x004fce000000005cULL, 0x0000006c006c7306ULL, 0x000ea20000202400ULL,
0x000000180c30723cULL, 0x000fee0000041830ULL, 0x00000014005c7306ULL, 0x0003e20000202400ULL,
0x0001000015197824ULL, 0x000fe200078e00ffULL, 0x000054106e157816ULL, 0x008fe20000000065ULL,
0x000000107b187824ULL, 0x000fe200078e0208ULL, 0x00000018ff657819ULL, 0x000fc40000011458ULL,
0x00000018ff727819ULL, 0x000fe40000011419ULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x0000541070147816ULL, 0x002fe40000000073ULL, 0x0000888016587816ULL, 0x000fca00000000ffULL,
0x0000006800687306ULL, 0x000e620000202400ULL, 0x000000140c28723cULL, 0x000fee0000041828ULL,
0x000054106c147816ULL, 0x004fe20000000071ULL, 0x0000005600567306ULL, 0x000fe20000202400ULL,
0x000054106f157816ULL, 0x000fe2000000006aULL, 0x00010000166a7824ULL, 0x000fc400078e00ffULL,
0x0000010016167824ULL, 0x000fc600078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x0000006600667306ULL, 0x000ea20000202400ULL, 0x000000140c24723cULL, 0x000fe20000041824ULL,
0x00000018ff167819ULL, 0x000fcc0000011416ULL, 0x0000001a00547306ULL, 0x000fe20000202400ULL,
0x0000541068147816ULL, 0x002fe4000000006dULL, 0x000054106b157816ULL, 0x000fca0000000064ULL,
0x0000001b005d7306ULL, 0x0003e40000202400ULL, 0x000000140c20723cULL, 0x000fec0000041820ULL,
0x0000004300437306ULL, 0x000ee20000202400ULL, 0x000000001818783bULL, 0x002e620000000200ULL,
0x0000541066147816ULL, 0x004fc40000000069ULL, 0x0000541067157816ULL, 0x000fe40000000056ULL,
0x0000888017567816ULL, 0x000fe400000000ffULL, 0x0000006000607306ULL, 0x000ea60000202400ULL,
0x000000140c1c723cULL, 0x000fea000004181cULL, 0x0000004400447306ULL, 0x000fe40000202400ULL,
0x000054105e157816ULL, 0x008fe20000000043ULL, 0x000000ffff437224ULL, 0x000fe200078e0056ULL,
0x0000541060147816ULL, 0x004fc80000000063ULL, 0x0000004600467306ULL, 0x000ea60000202400ULL,
0x000000140c10723cULL, 0x000fea0000041810ULL, 0x0000004e004e7306ULL, 0x000fe40000202400ULL,
0x00010000170d7824ULL, 0x000fc400078e00ffULL, 0x0000010017177824ULL, 0x000fe200078e00ffULL,
0x00005410460c7816ULL, 0x004fc6000000004fULL, 0x0000005b005b7306ULL, 0x000ea20000202400ULL,
0x00000018ff0f7819ULL, 0x000fe4000001140dULL, 0x00005410550d7816ULL, 0x000fe40000000044ULL,
0x00000018ff177819ULL, 0x000fc60000011417ULL, 0x0000004c004c7306ULL, 0x000ee40000202400ULL,
0x0000000c1834723cULL, 0x002fe20000041834ULL, 0x000054104e4e7816ULL, 0x004fca000000005bULL,
0x0000004b004b7306ULL, 0x000e620000202400ULL, 0x0000541057577816ULL, 0x008fce000000004cULL,
0x0000004a004a7306ULL, 0x000ea20000202400ULL, 0x00005410544f7816ULL, 0x002fce000000004bULL,
0x0000004900497306ULL, 0x000e620000202400ULL, 0x0000004e182c723cULL, 0x000fe2000004182cULL,
0x000054105d157816ULL, 0x004fcc000000004aULL, 0x0000004800487306ULL, 0x000fe20000202400ULL,
0x000054105c5b7816ULL, 0x002fce0000000049ULL, 0x0000004700477306ULL, 0x000ff00000202400ULL,
0x0000004500457306ULL, 0x000ff00000202400ULL, 0x0000004d004d7306ULL, 0x000ff00000202400ULL,
0x0000005000507306ULL, 0x000e700000202400ULL, 0x0000005200527306ULL, 0x000ea20000202400ULL,
0x000054104d567816ULL, 0x002fce0000000050ULL, 0x0000005a005a7306ULL, 0x000e620000202400ULL,
0x000000561830723cULL, 0x000fe20000041830ULL, 0x0000541052147816ULL, 0x004fcc000000005fULL,
0x0000006200627306ULL, 0x000fe20000202400ULL, 0x000000141828723cULL, 0x000fe20000041828ULL,
0x000054105a5a7816ULL, 0x002fcc0000000061ULL, 0x0000007200597306ULL, 0x000e620000202400ULL,
0x0000005a1824723cULL, 0x000fee0000041824ULL, 0x0000006500657306ULL, 0x000ea20000202400ULL,
0x0000541062627816ULL, 0x002fce0000000059ULL, 0x0000005800587306ULL, 0x000fe20000202400ULL,
0x0000541065637816ULL, 0x004fce0000000048ULL, 0x0000006a006b7306ULL, 0x000e620000202400ULL,
0x000000621820723cULL, 0x000fee0000041820ULL, 0x0000001600167306ULL, 0x000ea20000202400ULL,
0x0000541058467816ULL, 0x002fce000000006bULL, 0x00000043000e7306ULL, 0x000fe20000202400ULL,
0x0000541016477816ULL, 0x004fce0000000047ULL, 0x0000000f000d7306ULL, 0x000e620000202400ULL,
0x00000046181c723cULL, 0x000fee000004181cULL, 0x00000017000c7306ULL, 0x000ea20000202400ULL,
0x000054100e0e7816ULL, 0x002fe4000000000dULL, 0x000054100c0f7816ULL, 0x004fce0000000045ULL,
0x0000000e1810723cULL, 0x000fe20000041810ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xfffffff000400947ULL, 0x000fde000383ffffULL, 0x0000ffff0b0c7812ULL, 0x000fe200078ec0ffULL,
0x00000080530d7824ULL, 0x000fe400078e0208ULL, 0x0000000720147220ULL, 0x080fe20000410000ULL,
0x000000071c167220ULL, 0x080fe20000410000ULL, 0x000088800c0e7816ULL, 0x000fe200000000ffULL,
0x00000004060c7824ULL, 0x000fe400078e00ffULL, 0x000000071d177220ULL, 0x080fe20000410000ULL,
0x0000000734157220ULL, 0x080fe20000410000ULL, 0x0000000735357220ULL, 0x080fe20000410000ULL,
0x800000000e0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff00c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000736367220ULL, 0x080fe20000410000ULL, 0x0000000737377220ULL, 0x080fe20000410000ULL,
0x01b6100e090075a7ULL, 0x000e62000800017fULL, 0x0000000730307220ULL, 0x080fe20000410000ULL,
0x0000000731317220ULL, 0x080fe20000410000ULL, 0x0000000732327220ULL, 0x080fe20000410000ULL,
0x0000000733337220ULL, 0x080fe20000410000ULL, 0x000000072c2c7220ULL, 0x080fe20000410000ULL,
0x000000072d2d7220ULL, 0x080fe20000410000ULL, 0x000000072e2e7220ULL, 0x080fe20000410000ULL,
0x000000072f2f7220ULL, 0x080fe20000410000ULL, 0x0000000728287220ULL, 0x080fe20000410000ULL,
0x0000000729297220ULL, 0x080fe20000410000ULL, 0x000000072a2a7220ULL, 0x080fe20000410000ULL,
0x000000072b2b7220ULL, 0x080fe20000410000ULL, 0x0000000724247220ULL, 0x080fe20000410000ULL,
0x0000000725257220ULL, 0x080fe20000410000ULL, 0x0000000726267220ULL, 0x080fe20000410000ULL,
0x0000000727277220ULL, 0x080fe20000410000ULL, 0x0000000721217220ULL, 0x080fe20000410000ULL,
0x0000000722227220ULL, 0x080fe20000410000ULL, 0x0000000723237220ULL, 0x080fe20000410000ULL,
0x000000071e1e7220ULL, 0x080fe20000410000ULL, 0x000000071f1f7220ULL, 0x000fe20000410000ULL,
0x000000010d1c7824ULL, 0x000fc400078e020cULL, 0x0000000710107220ULL, 0x080fe20000410000ULL,
0x0000000711117220ULL, 0x080fe20000410000ULL, 0x0000000712207220ULL, 0x080fe20000410000ULL,
0x00000007131d7220ULL, 0x000fe20000410000ULL, 0x00000014004c8947ULL, 0x002fec0003800000ULL,
0x01b400001c0c7984ULL, 0x0002a20000000c00ULL, 0x0000000451007c0cULL, 0x000fda000bf05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x0000000206127824ULL, 0x000fe200078e00ffULL,
0x0000001038387c10ULL, 0x000fc8000fffe1ffULL, 0x0000000612137812ULL, 0x000fc800078ec0ffULL,
0x0000000113197812ULL, 0x040fe400078efcffULL, 0x00000008131b7812ULL, 0x000fe400078efcffULL,
0x000000381900720cULL, 0x080fe40003f26070ULL, 0x0000001013197812ULL, 0x000fe400078efcffULL,
0x000000381b00720cULL, 0x080fe40003f06070ULL, 0x000000381900720cULL, 0x000fc40003fc6070ULL,
0x00000011131b7812ULL, 0x040fe400078efcffULL, 0x0000001813197812ULL, 0x040fe400078efcffULL,
0x000000381300720cULL, 0x080fe40003f46070ULL, 0x000000381b00720cULL, 0x080fe40003fa6070ULL,
0x000000381900720cULL, 0x000fe40003f66070ULL, 0x00000009133d7812ULL, 0x000fc400078efcffULL,
0x00000019131b7812ULL, 0x040fe400078efcffULL, 0x0000002013197812ULL, 0x000fe400078efcffULL,
0xff7fffff36367808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff37377808ULL, 0x000fe40004800000ULL, 0xff7fffff35357808ULL, 0x000fc40004800000ULL,
0x000000383d00720cULL, 0x080fe40003f86070ULL, 0x000000381b00720cULL, 0x080fe40003f46070ULL,
0x000000381900720cULL, 0x000fe40003f26070ULL, 0x00000021131b7812ULL, 0x040fe400078efcffULL,
0x0000002813197812ULL, 0x000fe400078efcffULL, 0xff7fffff32327808ULL, 0x000fc40004000000ULL,
0xff7fffff30307808ULL, 0x000fe40004000000ULL, 0xff7fffff33337808ULL, 0x000fe40006000000ULL,
0xff7fffff31317808ULL, 0x000fe40006000000ULL, 0x000000381b00720cULL, 0x080fe40003f06070ULL,
0x000000381900720cULL, 0x000fe40003f86070ULL, 0x00000029131b7812ULL, 0x000fc400078efcffULL,
0x0000003013197812ULL, 0x000fe400078efcffULL, 0xff7fffff2e2e7808ULL, 0x000fe40007000000ULL,
0xff7fffff2c2c7808ULL, 0x000fe40007000000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40006800000ULL,
0xff7fffff2d2d7808ULL, 0x000fe40006800000ULL, 0x000000381b00720cULL, 0x000fc40003fc6070ULL,
0x000000381900720cULL, 0x000fe40003fa6070ULL, 0x00000031131b7812ULL, 0x040fe400078efcffULL,
0x0000003813197812ULL, 0x040fe400078efcffULL, 0x0000003913137812ULL, 0x000fe400078efcffULL,
0xff7fffff2a2a7808ULL, 0x000fe40005800000ULL, 0xff7fffff28287808ULL, 0x000fc40005800000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40005000000ULL, 0xff7fffff29297808ULL, 0x000fe40005000000ULL,
0xff7fffff26267808ULL, 0x000fe40004800000ULL, 0xff7fffff24247808ULL, 0x000fe40004800000ULL,
0x000000381b00720cULL, 0x080fe40003f66070ULL, 0x000000381900720cULL, 0x000fc40003f46070ULL,
0x000000381300720cULL, 0x000fe40003f26070ULL, 0xff7fffff27277808ULL, 0x000fe40004000000ULL,
0xff7fffff25257808ULL, 0x000fe40004000000ULL, 0xff7fffff22227808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff23237808ULL, 0x000fc40007000000ULL,
0xff7fffff21217808ULL, 0x000fe40007000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff20207808ULL, 0x000fc40005000000ULL,
0xff7fffff10107808ULL, 0x000fe40005000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL,
0xff7fffff11117808ULL, 0x000fce0004800000ULL, 0x000000150c0c7209ULL, 0x004fe20007810000ULL,
0xffffffff00087882ULL, 0x000fe20000000000ULL, 0x000000360d127209ULL, 0x000fe40007810000ULL,
0x000000350c0d7209ULL, 0x000fe40007810000ULL, 0x0000003712137209ULL, 0x000fe40007810000ULL,
0x000000300d0c7209ULL, 0x000fe40007810000ULL, 0x0000003213127209ULL, 0x000fc40007810000ULL,
0x000000310c0d7209ULL, 0x000fe40007810000ULL, 0x0000003312137209ULL, 0x000fe40007810000ULL,
0x0000002c0d0c7209ULL, 0x000fe40007810000ULL, 0x0000002e13127209ULL, 0x000fe40007810000ULL,
0x0000002d0c0d7209ULL, 0x000fe40007810000ULL, 0x0000002f12137209ULL, 0x000fc40007810000ULL,
0x000000280d0c7209ULL, 0x000fe40007810000ULL, 0x0000002a13127209ULL, 0x000fe40007810000ULL,
0x000000290c0d7209ULL, 0x000fe40007810000ULL, 0x0000002b12137209ULL, 0x000fe40007810000ULL,
0x000000240d0c7209ULL, 0x000fe40007810000ULL, 0x0000002613127209ULL, 0x000fc40007810000ULL,
0x000000250c0d7209ULL, 0x000fe40007810000ULL, 0x0000002712137209ULL, 0x000fe40007810000ULL,
0x000000140d0c7209ULL, 0x000fe40007810000ULL, 0x0000002213127209ULL, 0x000fe40007810000ULL,
0x000000210c0d7209ULL, 0x000fe40007810000ULL, 0x0000002312137209ULL, 0x000fc40007810000ULL,
0x000000160d0c7209ULL, 0x000fe40007810000ULL, 0x0000001e13127209ULL, 0x000fe40007810000ULL,
0x000000170c0d7209ULL, 0x000fe40007810000ULL, 0x0000001f12137209ULL, 0x000fe40007810000ULL,
0x000000ff0bff7812ULL, 0x000fe4000780c0ffULL, 0x000000100d0c7209ULL, 0x000fc40007810000ULL,
0x0000002013127209ULL, 0x000fe40007810000ULL, 0x00000001ff0b7807ULL, 0x000fe40000000000ULL,
0x000000110c0c7209ULL, 0x000fe40007810000ULL, 0x0000001d12127209ULL, 0x000fe20007810000ULL,
0x0000000e08c87947ULL, 0x000fec000b800000ULL, 0x0c401f000c0d7f89ULL, 0x000e6800000e0000ULL,
0x0c401f0012197f89ULL, 0x000ea800000e0000ULL, 0x0c401f000e1b7f89ULL, 0x000ee800000e0000ULL,
0x0c401f000f347f89ULL, 0x000f2200000e0000ULL, 0x0000000d0c137209ULL, 0x002fc40007810000ULL,
0x0000001912197209ULL, 0x004fc60007810000ULL, 0x0c201f0013187f89ULL, 0x000e6200000e0000ULL,
0x0000001b0e1b7209ULL, 0x008fc60007810000ULL, 0x0c201f00191a7f89ULL, 0x000ea200000e0000ULL,
0x000000340f347209ULL, 0x010fc60007810000ULL, 0x0c201f001b387f89ULL, 0x000ee800000e0000ULL,
0x0c201f00343d7f89ULL, 0x00092200000e0000ULL, 0x00000018130c7209ULL, 0x002fe40007810000ULL,
0x0000001a190d7209ULL, 0x004fe40007810000ULL, 0x000000381b0e7209ULL, 0x008fce0007810000ULL,
0x3fb8aa3b0c127820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b0d427820ULL, 0x000fe20000410000ULL,
0x3f80000000087882ULL, 0x000fe40000000000ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b14147823ULL, 0x000fe20000010812ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010842ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010842ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010842ULL, 0x3fb8aa3b33337823ULL, 0x000fe20000010842ULL,
0x0000003500187308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010812ULL,
0x0000001400357308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b17177823ULL, 0x000fe20000010812ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010842ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010842ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010842ULL,
0x0000001500157308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010842ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010842ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010842ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010842ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010842ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010842ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010842ULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1d1d7823ULL, 0x000fce0000010842ULL,
0x0000003100317308ULL, 0x000e700000000800ULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x000000303112723eULL, 0x002fce00000010ffULL, 0x0000003700377308ULL, 0x000ff00000000800ULL,
0x0000003200137308ULL, 0x000ff00000000800ULL, 0x0000003300147308ULL, 0x000e700000000800ULL,
0x00000028000f7308ULL, 0x0005e20000000800ULL, 0x000000131413723eULL, 0x002fce00000010ffULL,
0x0000002900387308ULL, 0x0003e20000000800ULL, 0x00000008ff287e24ULL, 0x004fca000f8e00ffULL,
0x3f8000002828783eULL, 0x000fe400000010ffULL, 0x0000001000407308ULL, 0x0005e60000000800ULL,
0x000000ffff297224ULL, 0x002fca00078e0028ULL, 0x0000001100437308ULL, 0x0003e20000000800ULL,
0x000000151810723eULL, 0x004fce00000010ffULL, 0x0000001700417308ULL, 0x000fe20000000800ULL,
0x000000363711723eULL, 0x002fe200000010ffULL, 0x0000000000007948ULL, 0x000fec0003800000ULL,
0x000000281018723cULL, 0x000fe200000418ffULL, 0x0000002c002c7308ULL, 0x000ff00000000800ULL,
0x0000002d002d7308ULL, 0x000e700000000800ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x0000002c2d14723eULL, 0x002fce00000010ffULL, 0x0000002f002f7308ULL, 0x000e700000000800ULL,
0x0000002a00177308ULL, 0x000fe20000000800ULL, 0x0000002e2f15723eULL, 0x002fce00000010ffULL,
0x0000002b00307308ULL, 0x000e700000000800ULL, 0x00000016003e7308ULL, 0x0004e20000000800ULL,
0x000000173017723eULL, 0x002fce00000010ffULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x0000000f3816723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b200f7823ULL, 0x000fe20000010842ULL,
0x0000003e4120723eULL, 0x008fca00000010ffULL, 0x000000281418723cULL, 0x000fe20000041818ULL,
0x0000002500257308ULL, 0x000e700000000800ULL, 0x00000021003c7308ULL, 0x000ea20000000800ULL,
0x000000242524723eULL, 0x002fce00000010ffULL, 0x0000002600217308ULL, 0x0005f00000000800ULL,
0x0000002700327308ULL, 0x000e620000000800ULL, 0x000000353c26723eULL, 0x004fce00000010ffULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x000000213225723eULL, 0x002fce00000010ffULL,
0x0000002300237308ULL, 0x000e700000000800ULL, 0x0000001e001e7308ULL, 0x000fe20000000800ULL,
0x000000222327723eULL, 0x002fce00000010ffULL, 0x0000001f001f7308ULL, 0x000e620000000800ULL,
0x000000404322723eULL, 0x000fe200000010ffULL, 0x000000282418723cULL, 0x000fec0000041818ULL,
0x0000000f000f7308ULL, 0x000fe20000000800ULL, 0x0000001e1f21723eULL, 0x002fce00000010ffULL,
0x0000001d002a7308ULL, 0x000e640000000800ULL, 0x0000000f2a23723eULL, 0x002fe400000010ffULL,
0xfffffffc060f7812ULL, 0x000fcc00078ec0ffULL, 0x000000282028723cULL, 0x000fee0000041818ULL,
0x0000000fff187424ULL, 0x000fca00078e00ffULL, 0x0000000f181f7219ULL, 0x000fe400000006ffULL,
0x0000003d340f7209ULL, 0x010fd20007810000ULL, 0x001c1fff28187589ULL, 0x00026200000e0000ULL,
0x00000000001e7806ULL, 0x000fe200038e0100ULL, 0x000000001f1a73a1ULL, 0x000eb000000e8000ULL,
0x000000001f0873c4ULL, 0x000ee20000004000ULL, 0x0000000000097886ULL, 0x000fc400038e0100ULL,
0x000000091fff7c12ULL, 0x004fda000f80401aULL, 0x0000000a08d48947ULL, 0x00afea000b800000ULL,
0x001c1fff2a197589ULL, 0x0002a800000e0000ULL, 0x001c1fff1a1a7589ULL, 0x000ee800000e0000ULL,
0x001c1fff001b7589ULL, 0x00032400000e0000ULL, 0xfffffff8ff3f7812ULL, 0x000fe200078ee23fULL,
0x00000800531f7824ULL, 0x002fe200078e0208ULL, 0x000000033b2a7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff307224ULL, 0x000fe200078e0010ULL, 0x0000000306ff7812ULL, 0x000fe2000780c0ffULL,
0x000000083f297836ULL, 0x040fe20000000000ULL, 0x000000042a2c7812ULL, 0x000fe200078efcffULL,
0x000000083f1d7824ULL, 0x000fe200078e00ffULL, 0x000000072a1e7812ULL, 0x000fe200078e783fULL,
0x000110001f1f7836ULL, 0x000fe20000000000ULL, 0x000000072c287812ULL, 0x000fe200078e783fULL,
0x000000ffff317224ULL, 0x000fe200078e0012ULL, 0x000000072a2a7812ULL, 0x000fe200078e7829ULL,
0x000000ffff327224ULL, 0x000fe200078e0014ULL, 0x000000072c2c7812ULL, 0x000fe200078e7829ULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x0000001d1e1e7212ULL, 0x080fe200078efcffULL,
0x000000ffff337224ULL, 0x000fe200078e0016ULL, 0x0000001d28287212ULL, 0x000fe200078efcffULL,
0x000000ffff347224ULL, 0x000fe200078e0024ULL, 0x000000292a2a7212ULL, 0x080fe200078efcffULL,
0x000000101e1e7824ULL, 0x100fe200078e021fULL, 0x000000292c2c7212ULL, 0x000fe200078efcffULL,
0x0000001028287824ULL, 0x000fc400078e021fULL, 0x000000ffff357224ULL, 0x000fe200078e0026ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x000000301e007844ULL, 0x0003e20000000200ULL,
0x000000ffff367224ULL, 0x000fe400078e0020ULL, 0x000000ffff377224ULL, 0x000fe400078e0022ULL,
0x000000102a2a7824ULL, 0x000fc400078e021fULL, 0x000000ffff3c7224ULL, 0x000fe200078e0011ULL,
0x0000003428007844ULL, 0x0003e20000000200ULL, 0x000000ffff3d7224ULL, 0x000fe400078e0013ULL,
0x000000ffff3e7224ULL, 0x000fe400078e0015ULL, 0x000000ffff3f7224ULL, 0x000fe400078e0017ULL,
0x000000102c2c7824ULL, 0x000fe400078e021fULL, 0x000000ffff147224ULL, 0x000fe200078e0025ULL,
0x0000003c2a007844ULL, 0x0003e20000000200ULL, 0x000000ffff157224ULL, 0x000fc400078e0027ULL,
0x000000ffff167224ULL, 0x000fe400078e0021ULL, 0x000000ffff177224ULL, 0x000fe400078e0023ULL,
0x00000001ff107424ULL, 0x000fe400078e00ffULL, 0x000000ffff517224ULL, 0x000fe200078e0039ULL,
0x000000142c007844ULL, 0x0003e80000000200ULL, 0x01b0000c1c008388ULL, 0x0003e80000000c00ULL,
0x01b200181c008388ULL, 0x01c3e20000000c00ULL, 0x0000000639007c0cULL, 0x000fe2000bf06070ULL,
0x01b6081009ff79a7ULL, 0x0005e4000850003fULL, 0x000000ffff107224ULL, 0x004fd400078e003aULL,
0xffffffc000808947ULL, 0x022fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff2b7224ULL, 0x000fce00078e002aULL, 0x0000202b090075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x0000202b0900a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xffffff1000c07947ULL, 0x000fea000383ffffULL, 0x000000ffff247224ULL, 0x100fe400078e0026ULL,
0x000000ffff257224ULL, 0x000fce00078e0026ULL, 0x01b60825290075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x01b60825290095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff1400fc7947ULL, 0x020fea000383ffffULL, 0x000000ffff247224ULL, 0x100fe400078e002aULL,
0x000000ffff257224ULL, 0x000fce00078e002aULL, 0x0000000cff297e24ULL, 0x000fc8000f8e00ffULL,
0x00000025290075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00000025290085a7ULL, 0x000e64000800007fULL,
0xfffffffc00e88947ULL, 0x002fea000383ffffULL, 0xffffff1c000c7947ULL, 0x020fea000383ffffULL,
0x000000ffff377224ULL, 0x000fce00078e0036ULL, 0x00002037090075a7ULL, 0x00026200080a017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000d95dULL, 0x000fea0003900000ULL,
0x000020370900d5a7ULL, 0x000e6400080a007fULL, 0xfffffffc00ecd947ULL, 0x002fea000383ffffULL,
0xffffff40001c7947ULL, 0x000fea000383ffffULL, 0x000000ffff247224ULL, 0x100fe400078e003eULL,
0x000000ffff257224ULL, 0x000fce00078e003eULL, 0x00000009ff277e24ULL, 0x000fc8000f8e00ffULL,
0xffffe025270075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0xffffe025270095a7ULL, 0x000e64000802007fULL,
0xfffffffc00e89947ULL, 0x002fea000383ffffULL, 0xffffff4000a47947ULL, 0x020fea000383ffffULL,
0x000000ffff247224ULL, 0x100fe400078e002aULL, 0x000000ffff257224ULL, 0x000fce00078e002aULL,
0x0000000dff277e24ULL, 0x000fc8000f8e00ffULL, 0x00000025270075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00000025270085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffff44008c7947ULL, 0x020fea000383ffffULL, 0x01b600ff080075a7ULL, 0x0004a2000800017fULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01b600ff080085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffbc000c7947ULL, 0x022fea000383ffffULL, 0x80000000ff0c7424ULL, 0x002fe400078e00ffULL,
0x80000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x01b6000d080075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01b6000d080085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e48947ULL, 0x002fea000383ffffULL,
0xffffffbc00607947ULL, 0x020fea000383ffffULL, 0x000000ffff0c7224ULL, 0x100fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fce00078e000eULL, 0x01b6100d090075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01b6100d090085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffe800947947ULL, 0x020fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff417224ULL, 0x000fe400078e000cULL, 0x00000002ff3e7424ULL, 0x000fe400078e00ffULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fce00078e00ffULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0c00003e413d7389ULL, 0x0006e40000000043ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff417224ULL, 0x002fe400078e0012ULL, 0x00000002ff3e7424ULL, 0x000fe400078e00ffULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x004fce00078e003dULL, 0x000000003c087348ULL, 0x000fea0003c00000ULL,
0x0c00003e413d7389ULL, 0x0002640000000043ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000000d0c137209ULL, 0x000fe20007810000ULL, 0x000000ffff417224ULL, 0x000fe400078e000eULL,
0x000000ffff197224ULL, 0x000fce00078e003dULL, 0x000000003c087348ULL, 0x000fea0003c00000ULL,
0x0c00003e413d7389ULL, 0x0002640000000043ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001912197209ULL, 0x000fe20007810000ULL, 0x000000ffff417224ULL, 0x000fe400078e000fULL,
0x000000ffff1b7224ULL, 0x000fce00078e003dULL, 0x000000003c087348ULL, 0x000fea0003c00000ULL,
0x0c00003e413d7389ULL, 0x0002640000000043ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001b0e1b7209ULL, 0x000fe20007810000ULL, 0x000000ffff417224ULL, 0x000fe400078e0013ULL,
0x00000001ff3e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fce00078e003dULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0c00003e413d7389ULL, 0x0002640000000043ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000340f347209ULL, 0x000fe20007810000ULL,
0x000000ffff417224ULL, 0x000fe400078e0019ULL, 0x000000ffff187224ULL, 0x000fce00078e003dULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0c00003e413d7389ULL, 0x0002640000000043ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x00000018130c7209ULL, 0x000fe20007810000ULL,
0x000000ffff417224ULL, 0x000fe400078e001bULL, 0x000000ffff1a7224ULL, 0x000fce00078e003dULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0c00003e413d7389ULL, 0x0002640000000043ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001a190d7209ULL, 0x000fe20007810000ULL,
0x000000ffff417224ULL, 0x000fe400078e0034ULL, 0x000000ffff387224ULL, 0x000fce00078e003dULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0c00003e413d7389ULL, 0x0002640000000043ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000381b0e7209ULL, 0x000fe20007810000ULL,
0xffffffec00947947ULL, 0x020fec000383ffffULL, 0x0000007000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff1d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fce00078e001fULL, 0x000000003c087348ULL, 0x000fea0003c00000ULL,
0x0000001b2a1b7389ULL, 0x0006e4000000001dULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff197224ULL, 0x004fe400078e001bULL, 0x000000ffff2a7224ULL, 0x002fe400078e001aULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff1d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fce00078e001fULL, 0x000000003c087348ULL, 0x000fea0003c00000ULL,
0x0000001b2a1b7389ULL, 0x0006e4000000001dULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1a7224ULL, 0x004fe400078e001bULL, 0x000000ffff2a7224ULL, 0x002fe400078e0000ULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff1d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fce00078e001fULL, 0x000000003c087348ULL, 0x000fea0003c00000ULL,
0x0000001b2a1b7389ULL, 0x0006e4000000001dULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff000c47947ULL, 0x026fea000383ffffULL,
0x018000000a047836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000004077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000000a00048308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff077807ULL, 0x000fe40000800000ULL, 0x00000001ff047807ULL, 0x004fc80004000000ULL,
0x0000000407ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff0aff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff047807ULL, 0x000fc80000000000ULL,
0x0000000407ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000a077812ULL, 0x000fd600078ec0ffULL,
0x0080000007040812ULL, 0x000fe200078efcffULL, 0x000000ffff048224ULL, 0x000fe200078e0007ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000a00047308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffffeec06847950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001b680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000d8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000610ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000658ULL, 0x00000000000004e4ULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b3cULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000b60ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000b60ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000b90ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000bd8ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000be0ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000c00ULL, 0x0000000000011280ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000011e80ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000011e90ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000011e90ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000011e90ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000012578ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000012578ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000bd8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000011280ULL, 0x0000000000011280ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000011e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000011e90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_90_cubin_len = 75464;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
