/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000017910ULL, 0x0000000000017490ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000016020ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x0000000000016190ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x00000000000161d0ULL, 0x0000000000000130ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000016300ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001602000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x0057600400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001602000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080a90828808081ULL, 0x8808288080aa0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808088920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL,
0x0001619000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0xaa08288080a90828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080aa920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000016000000000ULL,
0x000161d000000000ULL, 0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x00081204000000f2ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000007c00043704ULL, 0x0000000d00080a04ULL,
0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0018310400ff1b03ULL, 0x00015310000150d0ULL, 0x0001549000015320ULL,
0x000154b0000154a0ULL, 0xffffffff00e82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500001dffffffffULL, 0x0500001d0500001dULL, 0xffffffff0500001dULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00e82804ffffffffULL, 0x00000240000000b0ULL,
0x00001a1000001970ULL, 0x00001ac000001a90ULL, 0x0000309000003060ULL, 0x0000481000004770ULL,
0x000048c000004890ULL, 0x00005d2000005d10ULL, 0x00007370000072d0ULL, 0x00007420000073f0ULL,
0x000089e000008770ULL, 0x00009ec000009e20ULL, 0x00009f7000009f40ULL, 0x0000b1700000b130ULL,
0x0000c4500000c440ULL, 0x0000ef300000ef10ULL, 0x0000f4400000f410ULL, 0x00014d6000014d30ULL,
0x00014d8000014d70ULL, 0x00014dc000014da0ULL, 0x00014df000014de0ULL, 0x000154e000015480ULL,
0x00015500000154f0ULL, 0x00015ba000015b30ULL, 0x00015c6000015c00ULL, 0x00015d0000015cb0ULL,
0x00015da000015d50ULL, 0x00015e4000015df0ULL, 0x00015f3000015eb0ULL, 0x00015ff000015f90ULL,
0x0000014003e03904ULL, 0x0000f600000000ffULL, 0x00000180003f0100ULL, 0x0000f6080000000fULL,
0x000001b0003f0130ULL, 0x0000f6100000000fULL, 0x000001f0003f0130ULL, 0x0000f6480000000fULL,
0x00000230003f0120ULL, 0x0000f6680000000fULL, 0x00000460003f0120ULL, 0x0000f600000000ffULL,
0x00000660003f0107ULL, 0x0000f61400000036ULL, 0x00000790003f0102ULL, 0x0000f61000000036ULL,
0x00000d50003f0101ULL, 0x00000000000000ffULL, 0x00000e0000040107ULL, 0x0000002000000043ULL,
0x00000f80003f0101ULL, 0x0000002400000043ULL, 0x00001030003f0106ULL, 0x0000002400000043ULL,
0x000010c0003f0106ULL, 0x0000002400000043ULL, 0x00001700003f0106ULL, 0x0000000000000057ULL,
0x0000177000040107ULL, 0x000000040000002dULL, 0x0000179000040106ULL, 0x0000f60c00000048ULL,
0x000018a0003f0106ULL, 0x0000000400000024ULL, 0x00001d30003f0106ULL, 0x000000040000002dULL,
0x00001dd000040106ULL, 0x000000040000002dULL, 0x00003e3000040106ULL, 0x0000002000000043ULL,
0x00003eb0003f0101ULL, 0x0000000000000000ULL, 0x00003f60003f0101ULL, 0x0000002400000043ULL,
0x00003fb0003f0106ULL, 0x0000002400000043ULL, 0x00004040003f0106ULL, 0x0000002400000043ULL,
0x00004530003f0106ULL, 0x00000000000000ffULL, 0x000045a000060107ULL, 0x0000000400000067ULL,
0x000045c0003f0106ULL, 0x0000f61c00000048ULL, 0x000046b0003f0106ULL, 0x0000f61c00000048ULL,
0x00004b70003f0106ULL, 0x0000f64c00000025ULL, 0x00004c00003f0106ULL, 0x0000f64c00000025ULL,
0x00006ac0003f0106ULL, 0x0000002000000043ULL, 0x00006b40003f0101ULL, 0x0000000000000000ULL,
0x00006be0003f0101ULL, 0x0000002400000043ULL, 0x00006c40003f0106ULL, 0x0000002400000043ULL,
0x00006cd0003f0106ULL, 0x0000002400000043ULL, 0x00007090003f0106ULL, 0x0000000000000057ULL,
0x0000710000040107ULL, 0x00000004000000ffULL, 0x0000712000060106ULL, 0x0000f62c00000048ULL,
0x00007210003f0106ULL, 0x0000f62c00000048ULL, 0x000076b0003f0106ULL, 0x0000f64c00000000ULL,
0x00007740003f0106ULL, 0x00000004000000ffULL, 0x000095f000060106ULL, 0x0000002000000043ULL,
0x00009670003f0101ULL, 0x0000000000000000ULL, 0x00009700003f0101ULL, 0x0000002400000043ULL,
0x00009750003f0106ULL, 0x0000002400000043ULL, 0x000097e0003f0106ULL, 0x0000002400000043ULL,
0x00009bf0003f0106ULL, 0x00000000000000ffULL, 0x00009c6000060107ULL, 0x0000000400000067ULL,
0x00009c80003f0106ULL, 0x0000f63c00000048ULL, 0x00009d60003f0106ULL, 0x0000f63c00000048ULL,
0x0000a220003f0106ULL, 0x0000f64c00000061ULL, 0x0000a2b0003f0106ULL, 0x0000f64c00000061ULL,
0x0000c090003f0106ULL, 0x0000002000000043ULL, 0x0000c0f0003f0101ULL, 0x0000f64000000048ULL,
0x00010fb0003f0101ULL, 0x0000f604000000ffULL, 0x00011040003f0106ULL, 0x0000f604000000ffULL,
0x00011260003f0106ULL, 0x0000f600000000ffULL, 0x00011270003f0101ULL, 0x0000f604000000ffULL,
0x000112f0003f0106ULL, 0x0000f604000000ffULL, 0x00014140003f0106ULL, 0x0000f61400000040ULL,
0x00014610003f0106ULL, 0x0000f61400000040ULL, 0x00015a80003f0106ULL, 0x0000f60800000040ULL,
0x00053803003f0101ULL, 0x0000fe4000141c04ULL, 0x0001134000010290ULL, 0x00015ae000011410ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001ccULL, 0x0000001100000002ULL,
0x000000000000014cULL, 0x0000001100000002ULL, 0x00000000000000ccULL, 0x0000001100000002ULL,
0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001a2ULL, 0x0000001100000002ULL,
0x0000000000000122ULL, 0x0000001100000002ULL, 0x00000000000000a8ULL, 0x0000001100000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000087919ULL, 0x000e620000002300ULL,
0x00000004ff117424ULL, 0x000fe200078e00ffULL, 0x0000460000087ab9ULL, 0x000fe20000000a00ULL,
0x00005800ff417624ULL, 0x000fe200078e00ffULL, 0x0000000000037919ULL, 0x000e680000002200ULL,
0x0000000000097919ULL, 0x000ea80000002100ULL, 0x0000000000247919ULL, 0x000ee80000002700ULL,
0x00000000003f7919ULL, 0x000f220000002600ULL, 0x0000000108007824ULL, 0x002fc800078e0203ULL,
0x00000080000f7824ULL, 0x004fe400078e0209ULL, 0x00001fff08007589ULL, 0x000e6600000e0000ULL,
0x000000ff0f00720cULL, 0x040fe40003f05270ULL, 0x000000030f00780cULL, 0x040fe40003f44070ULL,
0x0000007f0f00780cULL, 0x040fe40003f24070ULL, 0x000000010f00780cULL, 0x000fce0003f64070ULL,
0x3fffff80ff028424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff038424ULL, 0x000fe400078e00ffULL,
0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL, 0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL,
0x00f60002ff008388ULL, 0x0005e20000000a00ULL, 0x000000ff0000720cULL, 0x002fe20003f05270ULL,
0x3fffff80ff0aa424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff0ba424ULL, 0x000fe200078e00ffULL,
0x00f608040f00a388ULL, 0x0003e2000000ca00ULL, 0x3fffffc0ff06a424ULL, 0x000fc400078e00ffULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x00f6100a0f00a388ULL, 0x0003e2000000ca00ULL,
0xff317217ff0e9424ULL, 0x000fe200078e00ffULL, 0x00000005ff027819ULL, 0x004fe20000011609ULL,
0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL, 0x00f648060f00a388ULL, 0x0003e20000008a00ULL,
0x7fffffc0ff0db424ULL, 0x000fe400078e00ffULL, 0x0000620024087625ULL, 0x008fe200078e0011ULL,
0x00f4000e0f009388ULL, 0x0003e80000004800ULL, 0x00f6680c0f00b388ULL, 0x0003e80000008a00ULL,
0x00001fff02027589ULL, 0x000ea800000e0000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x012e620000000000ULL,
0x0000000402057824ULL, 0x004fc400078e00ffULL, 0x0000001041037824ULL, 0x000fe400078e00ffULL,
0x000000103f047824ULL, 0x000fe400078e00ffULL, 0x00000100ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000002403037224ULL, 0x000fe200078e0204ULL, 0x000000050e0a7211ULL, 0x042fe200078fe0ffULL,
0x000000100e057824ULL, 0x000fc600078e00ffULL, 0x000000020a0c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000103047824ULL, 0x040fe200078e020aULL, 0x000000070a067812ULL, 0x000fe400078ec0ffULL,
0x000000070c0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000103077824ULL, 0x000fe200078e020cULL,
0x000000f0050d7812ULL, 0x000fe200078ec0ffULL, 0x00005c0004047625ULL, 0x080fe200078e000fULL,
0x0000000f06037812ULL, 0x100fe400078e780eULL, 0x0000000f0b0b7812ULL, 0x000fe200078e780eULL,
0x00005c0007067625ULL, 0x000fe200078e000fULL, 0x0000000d04047210ULL, 0x000fc60007f1e0ffULL,
0x000000100a037824ULL, 0x000fe200078e0203ULL, 0x0000000d06067210ULL, 0x000fe20007f3e0ffULL,
0x000000100c0b7824ULL, 0x000fe400078e020bULL, 0x000000ffff057224ULL, 0x000fe400000e0605ULL,
0x0000001003037824ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400008e0607ULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e8000b901c48ULL, 0x00000000060b7faeULL, 0x0003e8000b901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000808037981ULL, 0x012ee2000c1e1900ULL,
0x00000000000479c3ULL, 0x000e620000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000004ff347e24ULL, 0x002fe2000f8e00ffULL, 0x0000003f03357810ULL, 0x008fc40007ffe0ffULL,
0x000000ff03377810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff357819ULL, 0x000fe40000011635ULL,
0x00000008ff377819ULL, 0x000fca0000011637ULL, 0x0000fd4000008947ULL, 0x000fea0003800000ULL,
0x00000002ff397819ULL, 0x004fe20000011602ULL, 0x0000001002367824ULL, 0x000fe400078e00ffULL,
0x00000003ff077424ULL, 0x000fe200078e00ffULL, 0x03ffffff39057812ULL, 0x000fca00078ec0ffULL,
0x0000000434097824ULL, 0x000fca00078e0205ULL, 0x000000350900720cULL, 0x000fda0003f06070ULL,
0x0000000224008824ULL, 0x000fe400078e00ffULL, 0x00006400ff058624ULL, 0x000fc800078e00ffULL,
0x0000640000048624ULL, 0x000fe400078e0205ULL, 0xffffffffff007424ULL, 0x000fe400078e00ffULL,
0x0000000109048824ULL, 0x000fe200078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6140736ff738cULL, 0x0003e20000000000ULL, 0x0000600004048625ULL, 0x000fe200078e0011ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000804008981ULL, 0x0004e2000c1e1900ULL,
0x00000300ff387624ULL, 0x000fe200078e00ffULL, 0x0000000309067812ULL, 0x000fe200078ec0ffULL,
0xffffffffff3a7424ULL, 0x000fe200078e00ffULL, 0x00000000003b7919ULL, 0x000f220000000000ULL,
0xfffffffd11387424ULL, 0x000fe200078e0238ULL, 0x000000030600780cULL, 0x000fc40003f05270ULL,
0x00000001023c7812ULL, 0x000fe400078ec0ffULL, 0x00000001ff497819ULL, 0x000fe20000011602ULL,
0x000000403f3f7824ULL, 0x000fe200078e00ffULL, 0x00000001384a7807ULL, 0x000fe20004000000ULL,
0x0000004041417824ULL, 0x000fe200078e00ffULL, 0x00f6100036ff7f8cULL, 0x0003e6000c80043fULL,
0x00000001094a7824ULL, 0x000fca00078e024aULL, 0x000000354a00720cULL, 0x000fda0003f06070ULL,
0x0000000224068824ULL, 0x000fe400078e00ffULL, 0x00006400ff078624ULL, 0x002fc800078e00ffULL,
0x0000640006078624ULL, 0x000fc800078e0207ULL, 0x0000000107048824ULL, 0x004fe200078e024aULL,
0x00000003ff077819ULL, 0x010fe2000001163bULL, 0x000000103c087824ULL, 0x000fe400078e00ffULL,
0x0000600004048625ULL, 0x000fc800078e0011ULL, 0x00000020493d7824ULL, 0x000fe200078e00ffULL,
0x00000008043a8981ULL, 0x000362000c1e1900ULL, 0x00000001080a7824ULL, 0x000fe200078e0207ULL,
0x00000004070b7810ULL, 0x000fe20007ffe0ffULL, 0x00002000493e7824ULL, 0x000fe200078e00ffULL,
0x0000000134067810ULL, 0x000fe20007ffe0ffULL, 0x000000080a0e7824ULL, 0x040fe200078e00ffULL,
0x0000003b0a097212ULL, 0x000fe200078e3cffULL, 0x00000001080c7824ULL, 0x000fe200078e020bULL,
0x0000000c07127810ULL, 0x040fe20007ffe0ffULL, 0x00000000490473c2ULL, 0x000ea200000e0000ULL,
0x0000010034047824ULL, 0x002fe200078e023dULL, 0xfffffff80e097812ULL, 0x000fe200078ee209ULL,
0x000000080c0d7824ULL, 0x000fe200078e00ffULL, 0x00000008070e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108147824ULL, 0x000fe200078e0212ULL, 0x0000000403057217ULL, 0x000fe20007800000ULL,
0xff317217ff407424ULL, 0x000fe200078e00ffULL, 0x000000370600720cULL, 0x000fe20003f06070ULL,
0x0000000108107824ULL, 0x000fe200078e020eULL, 0x0000003b0c067212ULL, 0x080fe200078e3cffULL,
0x0000000105057824ULL, 0x000fe200078e0a04ULL, 0x0000003b140f7212ULL, 0x080fe200078e3cffULL,
0x0000000810117824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee206ULL,
0x0000000814167824ULL, 0x000fe200078e00ffULL, 0x0000002005057807ULL, 0x000fe20000000000ULL,
0x000000ffff427224ULL, 0x000fe200078e00ffULL, 0x0000003b10067212ULL, 0x000fc400078e3cffULL,
0x0000000805057217ULL, 0x000fe40007800000ULL, 0x000000203f047812ULL, 0x000fe400078ef804ULL,
0xfffffff811117812ULL, 0x000fe200078ee206ULL, 0x0000f64804047891ULL, 0x004fe2000f8e203fULL,
0xfffffff816197812ULL, 0x000fe200078ee20fULL, 0x00000001050f7824ULL, 0x000fe200078e0a08ULL,
0x0000b0003e067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff167424ULL, 0x000fe200078e00ffULL,
0x0000003f0a057812ULL, 0x000fc400078ec0ffULL, 0x0000000f0700720cULL, 0x080fe20003f46070ULL,
0x0000001011177824ULL, 0x100fe200078e0206ULL, 0x0000003f0c077812ULL, 0x000fe200078ec0ffULL,
0x000000103b117824ULL, 0x000fe200078e00ffULL, 0x0000000f0b00720cULL, 0x000fe20003f26070ULL,
0x0000001009137824ULL, 0x100fe200078e0206ULL, 0x0000003f10097812ULL, 0x000fe200078ec0ffULL,
0x000000100d157824ULL, 0x100fe200078e0206ULL, 0x0000003f140d7812ULL, 0x000fe200078ec0ffULL,
0x0000001019197824ULL, 0x000fe200078e0206ULL, 0x0000007011117812ULL, 0x000fc400078ec0ffULL,
0x0000000f0e00720cULL, 0x000fe40003f06070ULL, 0x0000f64849437811ULL, 0x000fe200078e18ffULL,
0x0000000041007224ULL, 0x008fc800078e0204ULL, 0x0000000100057824ULL, 0x040fe400078e0205ULL,
0x0000000100077824ULL, 0x000fe400078e0207ULL, 0x00005e0005047625ULL, 0x000fc800078e0016ULL,
0x0000000100097824ULL, 0x000fe200078e0209ULL, 0x00000011040c7210ULL, 0x000fe20007f7e0ffULL,
0x00000001000a7824ULL, 0x000fe400078e020dULL, 0x00005e0007067625ULL, 0x000fc800078e0016ULL,
0x00005e0009087625ULL, 0x000fe200078e0016ULL, 0x00000011060e7210ULL, 0x000fc60007f9e0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0016ULL, 0x0000001108087210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e0605ULL, 0x0000000f1200720cULL, 0x000fe20003f66070ULL,
0x000000ffff0f7224ULL, 0x000fe200020e0607ULL, 0x000000110a107210ULL, 0x000fe20007fde0ffULL,
0x000000ffff097224ULL, 0x000fe200028e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c137faeULL, 0x0003e2000d101c48ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x000000ffff117224ULL, 0x000fe200030e060bULL,
0x000000000e157faeULL, 0x0005e2000c901c48ULL, 0x00000000000a7805ULL, 0x000fc6000001ff00ULL,
0x0000000008177faeULL, 0x0007e2000c101c48ULL, 0x000000373400720cULL, 0x000fc60003f06070ULL,
0x0000000010197faeULL, 0x0009e2000d901c48ULL, 0x00000000000c7805ULL, 0x002fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000e7805ULL, 0x004fc6000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000087805ULL, 0x008fe2000001ff00ULL, 0x000000ffff117224ULL, 0x010fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200043ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000b31000000947ULL, 0x000fea0003800000ULL, 0x0000000224447824ULL, 0x002fe200078e00ffULL,
0x00007610ff707816ULL, 0x000fe20000000070ULL, 0x00006400ff077624ULL, 0x000fe200078e00ffULL,
0x00007610ff717816ULL, 0x000fe20000000071ULL, 0xff317217ff407424ULL, 0x000fe200078e00ffULL,
0x00007610ff457816ULL, 0x000fe20000000045ULL, 0x0000640044447624ULL, 0x000fc400078e0207ULL,
0x000000ffff6f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0xffffffc036257812ULL, 0x000fca00078ec0ffULL, 0x0000010034007824ULL, 0x000fca00078e0225ULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x0000b1e000000947ULL, 0x002fea0003800000ULL,
0x0000240043257984ULL, 0x000e620000000800ULL, 0x0000ffff70007812ULL, 0x000fe200078ec0ffULL,
0x000000ffff6d7224ULL, 0x000fe400078e004aULL, 0x000000ffff467224ULL, 0x000fe200078e006fULL,
0x0000888000247816ULL, 0x000fca00000000ffULL, 0x8000000024007824ULL, 0x000fca00078e00ffULL,
0x8000000025ff7812ULL, 0x002fe20007804800ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x00007610716e7816ULL, 0x000fe4000000006eULL, 0x0000761070777816ULL, 0x000fe20000000077ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000240043257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000024257824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x004fe40003800000ULL,
0x0000240043247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000034a007812ULL, 0x000fe200078ec0ffULL, 0x0000010034587824ULL, 0x000fe200078e00ffULL,
0x00000001ff497819ULL, 0x000fe40000011602ULL, 0x000000030000780cULL, 0x000fc60003f05270ULL,
0x0000002049007824ULL, 0x000fe200078e0258ULL, 0x0000000138257807ULL, 0x000fc80004000000ULL,
0x0000004000007810ULL, 0x000fe20007ffe0ffULL, 0x000000014a4a7824ULL, 0x000fc600078e0225ULL,
0x000000203f247812ULL, 0x000fe400078ef800ULL, 0x000000354a00720cULL, 0x000fe40003f06070ULL,
0x00000003ff2e7819ULL, 0x000fe2000001163bULL, 0x000000413a287224ULL, 0x020fe200078e0224ULL,
0x0000001036277812ULL, 0x000fe200078ec0ffULL, 0xffffffffff3a7424ULL, 0x000fd000078e00ffULL,
0x0000000144258824ULL, 0x000fe400078e024aULL, 0x00000004ff268424ULL, 0x000fc800078e00ffULL,
0x0000600025248625ULL, 0x000fc800078e0026ULL, 0x000000012e2a7824ULL, 0x100fe200078e0227ULL,
0x00000008243a8981ULL, 0x000362000c1e1900ULL, 0x0000000134267810ULL, 0x000fe20007ffe0ffULL,
0x0000000802297824ULL, 0x000fe200078e00ffULL, 0x000000042e307810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000003b2a4b7212ULL, 0x040fe200078e3cffULL,
0x000000103b557824ULL, 0x000fe200078e00ffULL, 0x0000003f2a4d7812ULL, 0x000fe200078ec0ffULL,
0x0000000130507824ULL, 0x000fe200078e0227ULL, 0x000000372600720cULL, 0x000fe20003f06070ULL,
0x000000082a247824ULL, 0x002fe200078e00ffULL, 0x0000000003257217ULL, 0x000fe20007800000ULL,
0x000000086f2d7824ULL, 0x000fe200078e00ffULL, 0x0000000c2e337810ULL, 0x000fe20007ffe0ffULL,
0x00000008502b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8244b7812ULL, 0x000fe200078ee24bULL,
0x0000000125257824ULL, 0x000fe200078e0a00ULL, 0xfffffff029297812ULL, 0x000fe200078ec0ffULL,
0x0000000128247824ULL, 0x000fe200078e024dULL, 0x0000007055317812ULL, 0x000fe200078ec0ffULL,
0x0000000133527824ULL, 0x100fe200078e0227ULL, 0x0000002025007807ULL, 0x000fe20000000000ULL,
0x00005e0024247625ULL, 0x000fe200078e002fULL, 0x0000003b504c7212ULL, 0x000fe200078e3cffULL,
0x00000000290473c2ULL, 0x0002a200000e0000ULL, 0x000000082e327810ULL, 0x000fe20007ffe0ffULL,
0x0000000852267824ULL, 0x000fe200078e00ffULL, 0x00000031242a7210ULL, 0x000fe20007f1e0ffULL,
0x000010006f247824ULL, 0x000fe200078e00ffULL, 0x000000082d577812ULL, 0x000fe200078e0cffULL,
0x00000001322c7824ULL, 0x000fe200078e0227ULL, 0x0000003f50507812ULL, 0x000fe200078ec0ffULL,
0x0000000402487824ULL, 0x000fe200078e00ffULL, 0xfffffff82b4c7812ULL, 0x000fe200078ee24cULL,
0x00000000570573c2ULL, 0x000ee200000e0000ULL, 0x0000003b524f7212ULL, 0x000fe200078e3cffULL,
0x000000ffff2b7224ULL, 0x000fe200000e0625ULL, 0x0000002700007217ULL, 0x000fe20007800000ULL,
0x0000000128257824ULL, 0x000fe200078e0250ULL, 0xfffffff8264f7812ULL, 0x000fe200078ee24fULL,
0x000000082c297824ULL, 0x002fe200078e00ffULL, 0x0000100024267812ULL, 0x000fe200078e0cffULL,
0x00005e0025247625ULL, 0x000fe200078e002fULL, 0x0000003f2c517812ULL, 0x000fc400078ec0ffULL,
0x0000003f52527812ULL, 0x000fe200078ec0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a27ULL,
0x0000003b2c4e7212ULL, 0x000fe200078e3cffULL, 0x0000000128277824ULL, 0x000fe200078e0251ULL,
0x0000003124247210ULL, 0x000fe20007f5e0ffULL, 0x0000000128287824ULL, 0x000fe200078e0252ULL,
0xfffffff8294e7812ULL, 0x000fe200078ee24eULL, 0x00002000492c7824ULL, 0x000fe200078e0226ULL,
0x000000002e00720cULL, 0x080fe20003f06070ULL, 0x00005e0027267625ULL, 0x080fe200078e002fULL,
0x000000003000720cULL, 0x080fe20003f26070ULL, 0x0000f64804047890ULL, 0x004fe2000fffe03fULL,
0x0000b0002c2c7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0028287625ULL, 0x000fe200078e002fULL,
0x000000003300720cULL, 0x080fe20003f66070ULL, 0x0000000504057290ULL, 0x008fe2000fffe03fULL,
0x0000003126267210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff257224ULL, 0x000fe200010e0625ULL,
0x000000003200720cULL, 0x000fe20003f46070ULL, 0x000000104b597824ULL, 0x100fe200078e022cULL,
0x0000003128287210ULL, 0x000fe20007fbe0ffULL, 0x000000104c5a7824ULL, 0x100fe200078e022cULL,
0xfffffff048487812ULL, 0x000fe200078ec0ffULL, 0x000000ffff277224ULL, 0x000fe200020e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a597faeULL, 0x0003e2000c101c48ULL,
0x000000104e5b7824ULL, 0x000fc400078e022cULL, 0x000000ffff297224ULL, 0x000fe200028e0629ULL,
0x00000000245a7faeULL, 0x0003e2000c901c48ULL, 0x000000104f5c7824ULL, 0x000fc600078e022cULL,
0x00000000265b7faeULL, 0x0003e8000d101c48ULL, 0x00000000285c7faeULL, 0x0003e8000d901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000004042d257984ULL, 0x0022a20008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f60c0048277984ULL, 0x000ee20000000800ULL,
0x0000ffff71007812ULL, 0x000fc400078ec0ffULL, 0x0000ffff45247812ULL, 0x000fe400078ec0ffULL,
0x00008880002a7816ULL, 0x000fe400000000ffULL, 0x0000888024537816ULL, 0x000fc600000000ffULL,
0x800000002a007824ULL, 0x000fe400078e00ffULL, 0x8000000053247824ULL, 0x000fc600078e00ffULL,
0x8000000025ff7812ULL, 0x004fe40007804800ULL, 0x8000000027ff7812ULL, 0x008fe20007824824ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000f60839247811ULL, 0x000fe200078e20ffULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x8000000053267824ULL, 0x000fe400078e00ffULL, 0x0000000000257305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000250000735dULL, 0x008fe40003800000ULL,
0x0000040024257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x004fc40007824826ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000001ff547819ULL, 0x000fe2000001163bULL, 0x00000001ff727424ULL, 0x000fe200078e00ffULL,
0x0000007055557812ULL, 0x000fe400078ec0ffULL, 0x0000000c54547812ULL, 0x000fc600078ec0ffULL,
0x0000008039257824ULL, 0x000fc800078e0255ULL, 0x0000000125257824ULL, 0x000fca00078e0254ULL,
0x00f0000025277984ULL, 0x000ea80000000800ULL, 0x00f2000025007984ULL, 0x0007220000000800ULL,
0x000000402700720bULL, 0x004fda0003f3d000ULL, 0x0000000000247806ULL, 0x000fc800008e0100ULL,
0x0000ffff242b7812ULL, 0x000fda000782c0ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000402700720bULL, 0x018fe40003f34000ULL, 0x00000027402c7209ULL, 0x000fe40007810000ULL,
0x00000002ff287819ULL, 0x000fc6000001163bULL, 0x8000002c40247221ULL, 0x100fe20000010000ULL,
0x0000000828297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff407224ULL, 0x000fe400078e002cULL,
0x3fb8aa3b24267820ULL, 0x000fe40000410000ULL, 0x0000000000247806ULL, 0x000fe400008e0100ULL,
0x000000023900720cULL, 0x000fe20003f25270ULL, 0x00000026002f7308ULL, 0x000ea20000000800ULL,
0x0000ffff24247812ULL, 0x000fc800078e3cffULL, 0x000000242bff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff727807ULL, 0x000fc60001000000ULL, 0x0000008002259824ULL, 0x000fc800078e0255ULL,
0x0000000154259824ULL, 0x000fe200078e0225ULL, 0x00001f292f297589ULL, 0x004ea200000e0000ULL,
0x8000002c27272221ULL, 0x000fe20000010000ULL, 0x0000002f42427220ULL, 0x000fe40000410000ULL,
0x00001f282f287589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b27272820ULL, 0x000fc60000410000ULL,
0x00f4002c25009388ULL, 0x0009e20000000800ULL, 0x0000002700472308ULL, 0x000e620000000800ULL,
0x0000002907077220ULL, 0x084fe20000410000ULL, 0x0000002906067220ULL, 0x080fe20000410000ULL,
0x000000290b0b7220ULL, 0x080fe20000410000ULL, 0x000000290a0a7220ULL, 0x080fe20000410000ULL,
0x000000290f0f7220ULL, 0x080fe20000410000ULL, 0x000000290e0e7220ULL, 0x080fe20000410000ULL,
0x0000002913137220ULL, 0x080fe20000410000ULL, 0x0000002912127220ULL, 0x080fe20000410000ULL,
0x0000002917177220ULL, 0x080fe20000410000ULL, 0x0000002916167220ULL, 0x080fe20000410000ULL,
0x000000291b1b7220ULL, 0x080fe20000410000ULL, 0x000000291a1a7220ULL, 0x080fe20000410000ULL,
0x000000291f1f7220ULL, 0x080fe20000410000ULL, 0x000000291e1e7220ULL, 0x080fe20000410000ULL,
0x0000002923237220ULL, 0x080fe20000410000ULL, 0x0000002922227220ULL, 0x000fe20000410000ULL,
0x0000002805057220ULL, 0x088fe20000410000ULL, 0x0000002804047220ULL, 0x080fe20000410000ULL,
0x0000002809097220ULL, 0x080fe20000410000ULL, 0x0000002808087220ULL, 0x080fe20000410000ULL,
0x000000280d0d7220ULL, 0x080fe20000410000ULL, 0x000000280c0c7220ULL, 0x080fe20000410000ULL,
0x0000002811117220ULL, 0x080fe20000410000ULL, 0x0000002810107220ULL, 0x080fe20000410000ULL,
0x0000002815157220ULL, 0x080fe20000410000ULL, 0x0000002814147220ULL, 0x080fe20000410000ULL,
0x0000002819197220ULL, 0x080fe20000410000ULL, 0x0000002818187220ULL, 0x080fe20000410000ULL,
0x000000281d1d7220ULL, 0x080fe20000410000ULL, 0x000000281c1c7220ULL, 0x080fe20000410000ULL,
0x0000002821217220ULL, 0x080fe20000410000ULL, 0x0000002820207220ULL, 0x000fe20000410000ULL,
0x0000004700002220ULL, 0x002fc80000410000ULL, 0x0000004200427221ULL, 0x018fe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x000004042d007984ULL, 0x000ea20008000800ULL,
0x800000002a257824ULL, 0x000fca00078e00ffULL, 0x8000000000ff7812ULL, 0x004fe20007804825ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000002a257824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000004042d247984ULL, 0x000ea40008000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000402247824ULL, 0x040fe200078e00ffULL,
0x000000083b007812ULL, 0x000fe200078ec0ffULL, 0x0000100002257824ULL, 0x000fe400078e00ffULL,
0x000010006f287824ULL, 0x000fe200078e023eULL, 0x0000000424247812ULL, 0x000fe400078ec0ffULL,
0xffffe00025267812ULL, 0x000fe400078ec0ffULL, 0x00000007002d7812ULL, 0x142fe400078ec83bULL,
0x000000243b2c7211ULL, 0x000fe200078fe0ffULL, 0x000010006f267824ULL, 0x000fe200078e0226ULL,
0x0000000700007812ULL, 0x000fc400078ef83bULL, 0x0000002c2d297212ULL, 0x040fe400078e3cffULL,
0x0000b000262e7810ULL, 0x000fe40007ffe0ffULL, 0x000000022c2c7810ULL, 0x000fe20007ffe0ffULL,
0x00000008005d7824ULL, 0x040fe200078e0229ULL, 0x0000008000607811ULL, 0x000fe400078e18ffULL,
0x0000002c2d2d7212ULL, 0x000fe200078e3cffULL, 0x000000105d247824ULL, 0x000fe200078e022eULL,
0x0000b000282f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001295e7824ULL, 0x000fc400078e0260ULL,
0x00000008005f7824ULL, 0x000fe400078e022dULL, 0x000000002424783bULL, 0x000e620000004200ULL,
0x000000105e287824ULL, 0x100fe400078e022fULL, 0x000000105f307824ULL, 0x000fe400078e022eULL,
0x000000012d607824ULL, 0x000fe400078e0260ULL, 0x000000002828783bULL, 0x000ea40000004200ULL,
0x00000010602f7824ULL, 0x000fc400078e022fULL, 0x000000003030783bULL, 0x000ee80000004200ULL,
0x000000002f2c783bULL, 0x000f220000004200ULL, 0x0000010024e17824ULL, 0x002fe200078e00ffULL,
0x0000002400e37306ULL, 0x000fe20000009400ULL, 0x00000018ffb87819ULL, 0x000fe20000011424ULL,
0x0000010025d77824ULL, 0x000fe200078e00ffULL, 0x00000018ffc27819ULL, 0x000fe20000011425ULL,
0x0000010026c47824ULL, 0x000fe200078e00ffULL, 0x00000018ffe17819ULL, 0x000fe200000114e1ULL,
0x0001000024db7824ULL, 0x000fe200078e00ffULL, 0x00000018ffd77819ULL, 0x000fe200000114d7ULL,
0x0000002400e47306ULL, 0x000e620000005400ULL, 0x00000018ffc47819ULL, 0x000fe200000114c4ULL,
0x0000010027cb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffdb7819ULL, 0x000fe200000114dbULL,
0x0001000026cc7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc07819ULL, 0x000fe20000011426ULL,
0x0001000025d47824ULL, 0x000fe200078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x000000b800df7306ULL, 0x000fe20000209400ULL, 0x00000018ffcc7819ULL, 0x000fe200000114ccULL,
0x0001000027c97824ULL, 0x000fe200078e00ffULL, 0x00000018ffd47819ULL, 0x000fe200000114d4ULL,
0x00000100289d7824ULL, 0x044fe200078e00ffULL, 0x00000018ffba7819ULL, 0x000fe20000011427ULL,
0x0001000028a27824ULL, 0x000fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe20000011428ULL,
0x000000b800e27306ULL, 0x000ea20000205400ULL, 0x000000e4e300720bULL, 0x002fe20003fbd000ULL,
0x000001002a8c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff797819ULL, 0x000fe2000001142aULL,
0x000100002a837824ULL, 0x000fe200078e00ffULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x0000010029a07824ULL, 0x040fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe20000011429ULL,
0x000000e100e97306ULL, 0x000fe20000209400ULL, 0x0001000029a37824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe2000001142bULL, 0x000001002b867824ULL, 0x040fe200078e00ffULL,
0x00000018ffae7819ULL, 0x008fe20000011432ULL, 0x000100002b7d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe20000011433ULL, 0x0000010031e37824ULL, 0x000fe200078e00ffULL,
0x000000e100ea7306ULL, 0x000e620000205400ULL, 0x000000e2df00720bULL, 0x004fc40003f1d000ULL,
0x00000018ff9d7819ULL, 0x000fe4000001149dULL, 0x00000018ffe37819ULL, 0x000fe400000114e3ULL,
0x00000018ff8c7819ULL, 0x000fe2000001148cULL, 0x0000002400947306ULL, 0x0004e2000000d400ULL,
0x00000018ffa07819ULL, 0x000fe400000114a0ULL, 0x00000018ff6b7819ULL, 0x010fe4000001142cULL,
0x00000018ff697819ULL, 0x000fc4000001142dULL, 0x00000018ffa27819ULL, 0x000fe200000114a2ULL,
0x0000002500ab7306ULL, 0x000fe20000009400ULL, 0x000000eae900720bULL, 0x002fe40003f3d000ULL,
0x00000018ff247819ULL, 0x004fe40000011431ULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x00000018ffa37819ULL, 0x000fe200000114a3ULL, 0x0000002500e07306ULL, 0x000e620000005400ULL,
0x0000000194945812ULL, 0x008fc400078efcffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x00000018ff867819ULL, 0x000fc60000011486ULL, 0x000000c200d87306ULL, 0x000ff00000209400ULL,
0x000000c200b17306ULL, 0x0004e20000205400ULL, 0x000000e0ab00720bULL, 0x002fe40003fdd000ULL,
0x000000e100ab7245ULL, 0x000fc8000020d400ULL, 0x00000001abab1812ULL, 0x000fe200078efcffULL,
0x000000d700e57306ULL, 0x000fe20000209400ULL, 0x000000c200c27245ULL, 0x004fce000020d400ULL,
0x000000d700e87306ULL, 0x000e620000205400ULL, 0x000000b1d800720bULL, 0x008fe40003fbd000ULL,
0x000000b800b17245ULL, 0x000fe4000020d400ULL, 0x000000d700b87245ULL, 0x000fe4000020d400ULL,
0x00000001b1b10812ULL, 0x000fe200078efcffULL, 0x000000c400d67306ULL, 0x000fec0000209400ULL,
0x00000001c2c25812ULL, 0x000fc400078efcffULL, 0x000000c400d37306ULL, 0x0004e20000205400ULL,
0x000000e8e500720bULL, 0x002fce0003f3d000ULL, 0x0000002500937306ULL, 0x000e62000000d400ULL,
0x000000c400c47245ULL, 0x004fca000020d400ULL, 0x00000001b8b81812ULL, 0x000fe400078efcffULL,
0x000000db00e77306ULL, 0x000fe20000209400ULL, 0x000000d3d600720bULL, 0x008fce0003f1d000ULL,
0x000000db00e67306ULL, 0x000ea20000205400ULL, 0x0000000193936812ULL, 0x002fca00078efcffULL,
0x00000001c4c40812ULL, 0x000fe400078efcffULL, 0x0000002600de7306ULL, 0x000ff00000009400ULL,
0x0000002600dd7306ULL, 0x000e620000005400ULL, 0x000000e6e700720bULL, 0x004fce0003f9d000ULL,
0x000000cb00d57306ULL, 0x000ff00000209400ULL, 0x000000cb00da7306ULL, 0x000ea20000205400ULL,
0x000000ddde00720bULL, 0x002fce0003f7d000ULL, 0x0000002700d17306ULL, 0x000ff00000009400ULL,
0x0000002700ce7306ULL, 0x000e620000005400ULL, 0x000000dad500720bULL, 0x004fce0003fdd000ULL,
0x000000cc00cf7306ULL, 0x000ff00000209400ULL, 0x000000cc00d27306ULL, 0x000ea20000205400ULL,
0x000000ced100720bULL, 0x002fce0003f3d000ULL, 0x000000c000c87306ULL, 0x000ff00000209400ULL,
0x000000c000c57306ULL, 0x0002e20000205400ULL, 0x000000d2cf00720bULL, 0x004fce0003f1d000ULL,
0x0000002800c77306ULL, 0x000fe20000009400ULL, 0x000000c000c07245ULL, 0x002fce000020d400ULL,
0x0000002800ca7306ULL, 0x000fe20000005400ULL, 0x000000c5c800720bULL, 0x008fe20003fbd000ULL,
0x0000010032c57824ULL, 0x000fe200078e00ffULL, 0x000000cb00c87245ULL, 0x000fc8000020d400ULL,
0x00000001c8c86812ULL, 0x000fe200078efcffULL, 0x0000002800677306ULL, 0x0003e2000000d400ULL,
0x00000018ffc57819ULL, 0x000fca00000114c5ULL, 0x00000001c0c05812ULL, 0x000fe400078efcffULL,
0x0000002a00b57306ULL, 0x000fe20000009400ULL, 0x0000010030287824ULL, 0x002fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002a00b27306ULL, 0x000ff00000005400ULL,
0x0000002a00627306ULL, 0x0003f0000000d400ULL, 0x00000026008b7306ULL, 0x000ea2000000d400ULL,
0x00000002022a7824ULL, 0x002fca00078e00ffULL, 0x000000042aec7812ULL, 0x000fe400078ec0ffULL,
0x00000029008a7306ULL, 0x000fe20000009400ULL, 0x000000073b2a7812ULL, 0x000fc800078ec0ffULL,
0x000000082a2a7812ULL, 0x000fc600078ef83bULL, 0x0000002900bb7306ULL, 0x000fe20000005400ULL,
0x000000018b8b3812ULL, 0x004fce00078efcffULL, 0x0000002900007306ULL, 0x0003f0000000d400ULL,
0x000000d400dc7306ULL, 0x000fe20000209400ULL, 0x0000991072297816ULL, 0x002fc800000000ffULL,
0x000000ff2900720cULL, 0x000fc60003f45270ULL, 0x000000d400d97306ULL, 0x000ff00000205400ULL,
0x000000ba00c67306ULL, 0x000ff00000209400ULL, 0x000000ba00c37306ULL, 0x000e700000205400ULL,
0x000000c900d07306ULL, 0x000ff00000209400ULL, 0x000000c900cd7306ULL, 0x0004e20000205400ULL,
0x000000c3c600720bULL, 0x002fc40003f7d000ULL, 0x000000cc00c37245ULL, 0x000fe2000020d400ULL,
0x000100002ccc7824ULL, 0x000fc600078e00ffULL, 0x00000001c3c30812ULL, 0x000fe200078efcffULL,
0x0000002700897306ULL, 0x000322000000d400ULL, 0x000000c900c97245ULL, 0x004fce000020d400ULL,
0x0000003000be7306ULL, 0x000fe20000009400ULL, 0x00000018ff277819ULL, 0x002fe40000011430ULL,
0x000000cdd000720bULL, 0x008fe20003fdd000ULL, 0x000100002dcd7824ULL, 0x000fc800078e00ffULL,
0x0000003000c17306ULL, 0x000e620000005400ULL, 0x0000000189891812ULL, 0x010fe400078efcffULL,
0x00000018ffcd7819ULL, 0x000fca00000114cdULL, 0x00000030007c7306ULL, 0x0004e2000000d400ULL,
0x00000001c9c96812ULL, 0x000fce00078efcffULL, 0x0000002b00ad7306ULL, 0x000fe20000009400ULL,
0x0001000030307824ULL, 0x004fe200078e00ffULL, 0x000000c1be00720bULL, 0x002fe20003f3d000ULL,
0x0000010033c17824ULL, 0x000fe200078e00ffULL, 0x000000ba00be7245ULL, 0x000fe4000020d400ULL,
0x00000018ffdd7819ULL, 0x000fe40000011430ULL, 0x0000002b00567306ULL, 0x000fe20000005400ULL,
0x000000db00307245ULL, 0x000fe4000020d400ULL, 0x00000001bebe3812ULL, 0x000fc400078efcffULL,
0x0000000130304812ULL, 0x000fe400078efcffULL, 0x000000d9dc00720bULL, 0x000fe20003f9d000ULL,
0x0000002b00617306ULL, 0x0003e2000000d400ULL, 0x000000017c7c1812ULL, 0x008fe400078efcffULL,
0x000000bb8a00720bULL, 0x000fe40003f7d000ULL, 0x000000e300bb7245ULL, 0x000fe4000020d400ULL,
0x000000dd00ba7245ULL, 0x000fe2000020d400ULL, 0x0000002800297306ULL, 0x000fe20000209400ULL,
0x000000ec3b2b7211ULL, 0x002fc800078fe0ffULL, 0x000000022be97810ULL, 0x040fe40007ffe0ffULL,
0x000000072b2b7812ULL, 0x100fe200078e782aULL, 0x0000002800e47306ULL, 0x000e620000205400ULL,
0x00000007e9eb7812ULL, 0x000fe400078e782aULL, 0x0000000100003812ULL, 0x000fe200078efcffULL,
0x000000082a2b7824ULL, 0x040fe400078e022bULL, 0x000000082a2a7824ULL, 0x000fe400078e02ebULL,
0x0000003100bd7306ULL, 0x000fe40000009400ULL, 0x000000102a8a7824ULL, 0x000fcc00078e00ffULL,
0x0000003100b67306ULL, 0x000ea20000005400ULL, 0x000000e42900720bULL, 0x002fce0003f1d000ULL,
0x000000e300e97306ULL, 0x000ff00000209400ULL, 0x000000e300e07306ULL, 0x000e620000205400ULL,
0x000000b6bd00720bULL, 0x004fe40003fdd000ULL, 0x0000002800bd7245ULL, 0x000fc8000020d400ULL,
0x00000001bdbd0812ULL, 0x000fe200078efcffULL, 0x00000031007a7306ULL, 0x0004f0000000d400ULL,
0x0000002700bf7306ULL, 0x000fe20000209400ULL, 0x0001000031317824ULL, 0x004fe200078e00ffULL,
0x000000e0e900720bULL, 0x002fc80003fbd000ULL, 0x00000018ffce7819ULL, 0x000fe40000011431ULL,
0x0000002700bc7306ULL, 0x000e620000205400ULL, 0x000000d400317245ULL, 0x000fe4000020d400ULL,
0x000000017a7a6812ULL, 0x008fe400078efcffULL, 0x0000000131314812ULL, 0x000fe400078efcffULL,
0x000000cac700720bULL, 0x000fe20003f9d000ULL, 0x000000dd00d87306ULL, 0x000fe20000209400ULL,
0x00000018ffc77819ULL, 0x000fc400000114c1ULL, 0x00000001bbbb5812ULL, 0x000fe400078efcffULL,
0x0000002700c17245ULL, 0x000fe4000020d400ULL, 0x000000ce00b67245ULL, 0x000fe2000020d400ULL,
0x000000dd00d37306ULL, 0x000ea20000205400ULL, 0x000000bcbf00720bULL, 0x002fe40003f3d000ULL,
0x0000002400bf7245ULL, 0x000fe4000020d400ULL, 0x0000000167674812ULL, 0x000fc600078efcffULL,
0x000000ce00d17306ULL, 0x000fec0000209400ULL, 0x00000001c1c11812ULL, 0x000fe400078efcffULL,
0x000000ce00ca7306ULL, 0x0002e20000205400ULL, 0x000000d3d800720bULL, 0x004fce0003f1d000ULL,
0x0000002400267306ULL, 0x000fe20000209400ULL, 0x000001002ece7824ULL, 0x002fca00078e00ffULL,
0x00000001baba0812ULL, 0x000fe400078efcffULL, 0x0000002400257306ULL, 0x0002a20000205400ULL,
0x000000cad100720bULL, 0x008fe40003fbd000ULL, 0x000000bac1ba723eULL, 0x000fe400000010ffULL,
0x00000018ffce7819ULL, 0x000fc600000114ceULL, 0x000000c500c67306ULL, 0x000fe20000209400ULL,
0x0000080039247824ULL, 0x002fca00078e028aULL, 0x00000001b6b65812ULL, 0x000fe400078efcffULL,
0x000000c500297306ULL, 0x000e620000205400ULL, 0x000000252600720bULL, 0x004fce0003f1d000ULL,
0x0000003200b97306ULL, 0x000fec0000009400ULL, 0x00000001bfbf0812ULL, 0x000fe400078efcffULL,
0x00000032006a7306ULL, 0x000ea20000005400ULL, 0x00000029c600720bULL, 0x002fe40003f3d000ULL,
0x000000b2b500720bULL, 0x000fc40003f1d000ULL, 0x000000c700b57245ULL, 0x000fc6000020d400ULL,
0x0000003200747306ULL, 0x0002f0000000d400ULL, 0x000000c700287306ULL, 0x000fe20000209400ULL,
0x0001000032327824ULL, 0x002fe200078e00ffULL, 0x0000006ab900720bULL, 0x004fe20003fdd000ULL,
0x000000102b6a7824ULL, 0x000fe200078e00ffULL, 0x000000c500b97245ULL, 0x000fc4000020d400ULL,
0x00000018ffbc7819ULL, 0x000fe40000011432ULL, 0x000000c700cb7306ULL, 0x0002a20000205400ULL,
0x00000001b9b91812ULL, 0x000fe400078efcffULL, 0x000000bc00b27245ULL, 0x000fe4000020d400ULL,
0x0000000162620812ULL, 0x000fe400078efcffULL, 0x0000000174746812ULL, 0x008fe200078efcffULL,
0x0000003300b47306ULL, 0x000fe20000009400ULL, 0x00000002ffc77819ULL, 0x002fce000001163bULL,
0x0000003300b77306ULL, 0x000e620000005400ULL, 0x000000cb2800720bULL, 0x004fe20003fbd000ULL,
0x0000080039287824ULL, 0x000fe400078e026aULL, 0x000001002ccb7824ULL, 0x000fc800078e00ffULL,
0x000000bc00327306ULL, 0x000fe20000209400ULL, 0x009000002828783bULL, 0x000fea0000000200ULL,
0x00000001b5b55812ULL, 0x000fe400078efcffULL, 0x000000bc00257306ULL, 0x0004e20000205400ULL,
0x000000b7b400720bULL, 0x002fe40003f3d000ULL, 0x000000ae00b77245ULL, 0x000fca000020d400ULL,
0x000000ae00b37306ULL, 0x000fe20000209400ULL, 0x000001002fbc7824ULL, 0x004fca00078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe400000114bcULL, 0x000000ae00b07306ULL, 0x000e620000205400ULL,
0x000000253200720bULL, 0x008fe40003fdd000ULL, 0x009000002424783bULL, 0x000fe20000000200ULL,
0x00000018ff327819ULL, 0x000fe4000001142eULL, 0x000000bc00cf7245ULL, 0x000fe4000020d400ULL,
0x0000003300687306ULL, 0x0004ec000000d400ULL, 0x00000001b2b26812ULL, 0x000fc400078efcffULL,
0x000000b0b300720bULL, 0x002fe20003fbd000ULL, 0x0001000033337824ULL, 0x004fe200078e00ffULL,
0x00000047ffb0723eULL, 0x000fe200000010ffULL, 0x0000008f00977306ULL, 0x000fe20000209400ULL,
0x000100002eb37824ULL, 0x000fe400078e00ffULL, 0x00005410b0b07816ULL, 0x000fe400000000b0ULL,
0x0000000168681812ULL, 0x008fe400078efcffULL, 0x00000056ad00720bULL, 0x000fe20003f3d000ULL,
0x0000008f00987306ULL, 0x000fe20000205400ULL, 0x00000008c7567810ULL, 0x000fc40007ffe0ffULL,
0x00001fc7b0c77589ULL, 0x000e6200000e0000ULL, 0x00000018ffca7819ULL, 0x000fe40000011433ULL,
0x00000001b7b75812ULL, 0x000fe200078efcffULL, 0x00001f56b0c67589ULL, 0x000ea200000e0000ULL,
0x000000ca00c57306ULL, 0x000fe20000209400ULL, 0x00000018ffb37819ULL, 0x000fc600000114b3ULL,
0x0000000161611812ULL, 0x000fc800078efcffULL, 0x000000ca00b47306ULL, 0x000ef00000205400ULL,
0x0000009c00ac7306ULL, 0x000fe20000209400ULL, 0x000000c72828a231ULL, 0x082fe400003400ffULL,
0x000000c72a2aa231ULL, 0x000fc400003400ffULL, 0x000000c72424a231ULL, 0x000fc600003400ffULL,
0x0000009c00af7306ULL, 0x0003220000205400ULL, 0x000000c72626a231ULL, 0x000fe200003400ffULL,
0x000000b4c500720bULL, 0x008fe20003fbd000ULL, 0x000000c62929a231ULL, 0x084fe200003400ffULL,
0x000000ca00b47245ULL, 0x000fe2000020d400ULL, 0x000000c62b2ba231ULL, 0x080fe200003400ffULL,
0x0000009c00c57245ULL, 0x000fe2000020d400ULL, 0x000000c62525a231ULL, 0x080fe200003400ffULL,
0x0000009d009e7306ULL, 0x000fe20000209400ULL, 0x000000c62727a231ULL, 0x000fe200003400ffULL,
0x000000989700720bULL, 0x000fc40003f5d000ULL, 0x00000018ff9c7819ULL, 0x002fc600000114cbULL,
0x00000001b4b45812ULL, 0x000fe200078efcffULL, 0x0000009d009f7306ULL, 0x000e620000205400ULL,
0x000000afac00720bULL, 0x010fe20003fdd000ULL, 0x000100002faf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffac7819ULL, 0x000fc8000001142fULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0000008c00a47306ULL, 0x000fec0000209400ULL, 0x00000001c5c56812ULL, 0x000fe400078efcffULL,
0x0000008c00a57306ULL, 0x000fe20000205400ULL, 0x0000009f9e00720bULL, 0x002fc40003fbd000ULL,
0x0000009d009e7245ULL, 0x000fe4000020d400ULL, 0x000000a0009d7245ULL, 0x000fe4000020d400ULL,
0x000000b4c5c5723eULL, 0x000fe200000010ffULL, 0x000000a000a17306ULL, 0x000fec0000209400ULL,
0x000000019e9e5812ULL, 0x000fc400078efcffULL, 0x000000a000a67306ULL, 0x000e700000205400ULL,
0x0000002c00877306ULL, 0x000ff00000009400ULL, 0x0000002c00847306ULL, 0x000fe20000005400ULL,
0x000000a6a100720bULL, 0x002fce0003fdd000ULL, 0x0000002c00637306ULL, 0x0003ec000000d400ULL,
0x000000019d9d6812ULL, 0x000fe400078efcffULL, 0x0000002d007e7306ULL, 0x000fe20000009400ULL,
0x000001002d2c7824ULL, 0x002fe200078e00ffULL, 0x000000009d9d723eULL, 0x000fc400000010ffULL,
0x0000006b00007245ULL, 0x000fe4000020d400ULL, 0x00000018ff977819ULL, 0x000fe4000001142cULL,
0x0000002d007f7306ULL, 0x000e620000005400ULL, 0x00000094ab2c723eULL, 0x000fce00000010ffULL,
0x0000002d00647306ULL, 0x0005f0000000d400ULL, 0x0000008800997306ULL, 0x000fe20000209400ULL,
0x00000093b82d723eULL, 0x004fe400000010ffULL, 0x0000008f00937245ULL, 0x000fc4000020d400ULL,
0x00000018ff8f7819ULL, 0x000fe400000114ccULL, 0x0000000193932812ULL, 0x000fe200078efcffULL,
0x0000008800967306ULL, 0x0004e20000205400ULL, 0x000000a5a400720bULL, 0x000fe20003f5d000ULL,
0x0000002c2820723cULL, 0x000fe20000041820ULL, 0x0000007f7e00720bULL, 0x002fca0003f1d000ULL,
0x000000a200a77306ULL, 0x000fe20000209400ULL, 0x0000008bc42c723eULL, 0x000fe400000010ffULL,
0x00000089c82d723eULL, 0x000fe400000010ffULL, 0x0000008800887245ULL, 0x004fe4000020d400ULL,
0x000000b2b7c4723eULL, 0x000fe200000010ffULL, 0x000000a200a87306ULL, 0x0002a20000205400ULL,
0x000000969900720bULL, 0x008fe20003f9d000ULL, 0x0000002c2818723cULL, 0x000fe20000041818ULL,
0x0000000164640812ULL, 0x000fca00078efcffULL, 0x00000083008d7306ULL, 0x000fe20000209400ULL,
0x000000a200a27245ULL, 0x002fe2000020d400ULL, 0x000000c42804723cULL, 0x040fe20000041804ULL,
0x0000007cbd2c723eULL, 0x000fe400000010ffULL, 0x0000007abb2d723eULL, 0x000fe400000010ffULL,
0x0000000188884812ULL, 0x000fe200078efcffULL, 0x00000083008e7306ULL, 0x0003e20000205400ULL,
0x000000a8a700720bULL, 0x004fe40003fbd000ULL, 0x000000848700720bULL, 0x000fe20003f9d000ULL,
0x0000002c2810723cULL, 0x000fe20000041810ULL, 0x000000b6bfbb723eULL, 0x000fc600000010ffULL,
0x000000a300a97306ULL, 0x000fe20000209400ULL, 0x0000008300837245ULL, 0x002fe4000020d400ULL,
0x00000074b92c723eULL, 0x000fe200000010ffULL, 0x000000ba280c723cULL, 0x040fe2000004180cULL,
0x00000068b52d723eULL, 0x000fe400000010ffULL, 0x00000001a2a25812ULL, 0x000fe200078efcffULL,
0x000000a300aa7306ULL, 0x0002a20000205400ULL, 0x0000000163634812ULL, 0x000fe400078efcffULL,
0x000000a293a2723eULL, 0x000fe200000010ffULL, 0x0000002c2808723cULL, 0x000fe80000041808ULL,
0x00000079009b7306ULL, 0x000fe20000209400ULL, 0x000000a300a37245ULL, 0x002fc4000020d400ULL,
0x0000009c002c7245ULL, 0x000fe4000020d400ULL, 0x00000097002d7245ULL, 0x000fc6000020d400ULL,
0x00000079009a7306ULL, 0x000e620000205400ULL, 0x000000aaa900720bULL, 0x004fce0003f7d000ULL,
0x0000002f00767306ULL, 0x000fec0000009400ULL, 0x00000001a3a33812ULL, 0x000fe400078efcffULL,
0x0000002f007b7306ULL, 0x000ea20000005400ULL, 0x0000009a9b00720bULL, 0x002fe40003fdd000ULL,
0x000000a388a3723eULL, 0x000fca00000010ffULL, 0x0000002f00667306ULL, 0x0002f0000000d400ULL,
0x0000002e00817306ULL, 0x000fe20000009400ULL, 0x00000031c22f723eULL, 0x002fe400000010ffULL,
0x0000008c00317245ULL, 0x000fc4000020d400ULL, 0x0000007b7600720bULL, 0x004fe40003f3d000ULL,
0x0000000131312812ULL, 0x000fe200078efcffULL, 0x0000002e00807306ULL, 0x000fe20000005400ULL,
0x0000008e8d00720bULL, 0x000fce0003f5d000ULL, 0x0000002e00657306ULL, 0x0003e4000000d400ULL,
0x0000000166661812ULL, 0x008fc800078efcffULL, 0x0000000183832812ULL, 0x000fe400078efcffULL,
0x0000006c00907306ULL, 0x000fe20000209400ULL, 0x00000030b12e723eULL, 0x002fce00000010ffULL,
0x0000006c00917306ULL, 0x0002a20000205400ULL, 0x0000002e281c723cULL, 0x000fee000004181cULL,
0x0000007d00857306ULL, 0x000fe20000209400ULL, 0x000000c3c02e723eULL, 0x000fe400000010ffULL,
0x000000c9be2f723eULL, 0x000fc400000010ffULL, 0x0000006c006c7245ULL, 0x002fc6000020d400ULL,
0x0000007d00827306ULL, 0x000e620000205400ULL, 0x000000919000720bULL, 0x004fe20003fbd000ULL,
0x0000002e2814723cULL, 0x000fec0000041814ULL, 0x0000008600927306ULL, 0x000fe20000209400ULL,
0x00000079002e7245ULL, 0x000fe2000020d400ULL, 0x000000a2241c723cULL, 0x000fe2000004181cULL,
0x0000007d002f7245ULL, 0x000fc4000020d400ULL, 0x000000012e2e6812ULL, 0x000fe400078efcffULL,
0x000000623128723eULL, 0x000fe200000010ffULL, 0x0000008600957306ULL, 0x0004e20000205400ULL,
0x000000828500720bULL, 0x002fe40003f5d000ULL, 0x000000016c6c5812ULL, 0x000fe400078efcffULL,
0x00000069002a7245ULL, 0x000fe4000020d400ULL, 0x000000832e2e723eULL, 0x000fe200000010ffULL,
0x0000009c009f7306ULL, 0x000fe20000209400ULL, 0x0000008600867245ULL, 0x004fca000020d400ULL,
0x000000012f2f2812ULL, 0x000fe400078efcffULL, 0x0000009c00a67306ULL, 0x0002a20000205400ULL,
0x000000959200720bULL, 0x008fe40003f7d000ULL, 0x0000002f6c2f723eULL, 0x000fca00000010ffULL,
0x0000006b00757306ULL, 0x000fe20000209400ULL, 0x000000679e9c723eULL, 0x002fe200000010ffULL,
0x0000002e2414723cULL, 0x040fe80000041814ULL, 0x0000000186863812ULL, 0x000fe400078efcffULL,
0x0000006b00787306ULL, 0x000e620000205400ULL, 0x000000a69f00720bULL, 0x004fe20003fdd000ULL,
0x0000009c2420723cULL, 0x000fe20000041820ULL, 0x000000808100720bULL, 0x000fc40003f7d000ULL,
0x000000618629723eULL, 0x000fc600000010ffULL, 0x000000cd00307306ULL, 0x000fe80000209400ULL,
0x000000282418723cULL, 0x000fe40000041818ULL, 0x000000012c2c6812ULL, 0x000fe400078efcffULL,
0x000000cd00877306ULL, 0x000ea20000205400ULL, 0x000000787500720bULL, 0x002fe40003f5d000ULL,
0x000000cd00297245ULL, 0x000fc4000020d400ULL, 0x0000000165653812ULL, 0x000fe400078efcffULL,
0x000000632c2c723eULL, 0x000fe200000010ffULL, 0x0000006900737306ULL, 0x000fec0000209400ULL,
0x0000000100002812ULL, 0x000fe400078efcffULL, 0x0000006900727306ULL, 0x000e620000205400ULL,
0x000000873000720bULL, 0x004fce0003f1d000ULL, 0x0000009700987306ULL, 0x000fec0000209400ULL,
0x0000000129290812ULL, 0x000fe400078efcffULL, 0x0000009700997306ULL, 0x000ea20000205400ULL,
0x000000727300720bULL, 0x002fce0003fbd000ULL, 0x0000008f00907306ULL, 0x000fec0000209400ULL,
0x000000012a2a5812ULL, 0x000fe400078efcffULL, 0x0000008f008b7306ULL, 0x0002e20000205400ULL,
0x000000999800720bULL, 0x004fe40003fdd000ULL, 0x000000292a29723eULL, 0x000fca00000010ffULL,
0x0000003200337306ULL, 0x000fe20000209400ULL, 0x0000008f008f7245ULL, 0x002fca000020d400ULL,
0x000000012d2d6812ULL, 0x000fe400078efcffULL, 0x0000003200ae7306ULL, 0x0002a20000205400ULL,
0x0000008b9000720bULL, 0x008fe40003f9d000ULL, 0x000000642d2d723eULL, 0x000fca00000010ffULL,
0x000000ac00ad7306ULL, 0x000fe20000209400ULL, 0x0000003200327245ULL, 0x002fe2000020d400ULL,
0x0000002c2410723cULL, 0x000fe80000041810ULL, 0x000000018f8f4812ULL, 0x000fe400078efcffULL,
0x000000ac00b07306ULL, 0x0002e20000205400ULL, 0x000000ae3300720bULL, 0x004fe40003fdd000ULL,
0x000000af00337245ULL, 0x000fc4000020d400ULL, 0x0000008f0028723eULL, 0x000fe400000010ffULL,
0x0000f61039007811ULL, 0x000fe200078e20ffULL, 0x000000ce007c7306ULL, 0x000fe20000209400ULL,
0x000000ac00ac7245ULL, 0x002fc6000020d400ULL, 0x00000028240c723cULL, 0x000fe4000004180cULL,
0x0000000132326812ULL, 0x000fe400078efcffULL, 0x000000ce00797306ULL, 0x0002a20000205400ULL,
0x000000b0ad00720bULL, 0x008fce0003f9d000ULL, 0x000000bc00747306ULL, 0x000fe20000209400ULL,
0x000000ce00ce7245ULL, 0x002fca000020d400ULL, 0x00000001acac4812ULL, 0x000fe400078efcffULL,
0x000000bc00757306ULL, 0x000e620000205400ULL, 0x000000797c00720bULL, 0x004fce0003f5d000ULL,
0x000000b300687306ULL, 0x000fec0000209400ULL, 0x00000001cece2812ULL, 0x000fe400078efcffULL,
0x000000b3002b7306ULL, 0x0004e20000205400ULL, 0x000000757400720bULL, 0x002fe40003f1d000ULL,
0x00000065cece723eULL, 0x000fca00000010ffULL, 0x000000af00307306ULL, 0x000fe20000209400ULL,
0x000000b300b37245ULL, 0x004fca000020d400ULL, 0x00000001cfcf0812ULL, 0x000fe400078efcffULL,
0x000000af00317306ULL, 0x000e620000205400ULL, 0x0000002b6800720bULL, 0x008fe40003fbd000ULL,
0x00000066cfcf723eULL, 0x000fe200000010ffULL, 0x0000010034667824ULL, 0x000fcc00078e00ffULL,
0x000000ce2408723cULL, 0x000fe80000041808ULL, 0x00000001b3b35812ULL, 0x000fe400078efcffULL,
0x000000313000720bULL, 0x002fe40003f7d000ULL, 0x000000b33232723eULL, 0x000fd600000010ffULL,
0x0000000133333812ULL, 0x000fc800078efcffULL, 0x00000033ac33723eULL, 0x000fce00000010ffULL,
0x000000322404723cULL, 0x000fe20000041804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200043ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004039247824ULL, 0x000fe200078e0266ULL,
0x000000ff71ff7812ULL, 0x000fe2000782c0ffULL, 0x0000000000ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ff70ff7812ULL, 0x000fe4000784c0ffULL, 0x0000004024247810ULL, 0x000fe40007ffe0ffULL,
0x00000001ff2e7807ULL, 0x000fe40000800000ULL, 0x000000032400720cULL, 0x000fc40003f26070ULL,
0x000000016f00780cULL, 0x040fe40003f05270ULL, 0x00000001ff657807ULL, 0x000fe40001000000ULL,
0x000000016f6f7812ULL, 0x000fe400078e0cffULL, 0x000000712e717207ULL, 0x000fe40004000000ULL,
0x0000761065707816ULL, 0x000fc60000000070ULL, 0x0000820000001947ULL, 0x000fea0003800000ULL,
0x0000240043257984ULL, 0x004ea20000000800ULL, 0x8000000065007824ULL, 0x000fca00078e00ffULL,
0x8000000025ff7812ULL, 0x004fe20007824800ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x0000240043257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x004fe40007824800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x8000000065257824ULL, 0x000fe400078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x0000240043247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000036d007812ULL, 0x000fe400078ec0ffULL, 0x00000001ff497819ULL, 0x000fe40000011602ULL,
0x000000030000780cULL, 0x000fc80003f25270ULL, 0x0000000138007807ULL, 0x000fca0004800000ULL,
0x000000016d6d7824ULL, 0x000fca00078e0200ULL, 0x000000036d007812ULL, 0x000fc800078ec0ffULL,
0x000000030000780cULL, 0x000fe20003f25270ULL, 0x0000002049007824ULL, 0x000fc600078e0258ULL,
0x00000001386c7807ULL, 0x000fe40004800000ULL, 0x0000008000007810ULL, 0x000fc60007ffe0ffULL,
0x000000016d4a7824ULL, 0x000fe200078e026cULL, 0x000000203f247812ULL, 0x000fc800078ef800ULL,
0x000000354a00720cULL, 0x000fe20003f26070ULL, 0x000000413a267224ULL, 0x020fe200078e0224ULL,
0x0000000003277217ULL, 0x000fe20007800000ULL, 0xffffffffff3a7424ULL, 0x000fd400078e00ffULL,
0x0000006c44259210ULL, 0x000fe20007ffe06dULL, 0x00000004ff289424ULL, 0x000fc800078e00ffULL,
0x0000600025249625ULL, 0x000fe200078e0028ULL, 0x0000000134287810ULL, 0x000fc60007ffe0ffULL,
0x0000000127277824ULL, 0x000fe200078e0a00ULL, 0x00000008243a9981ULL, 0x000562000c1e1900ULL,
0x000000372800720cULL, 0x000fe20003f26070ULL, 0x0000000802627824ULL, 0x000fe200078e00ffULL,
0x0000001036007812ULL, 0x000fe200078ec0ffULL, 0x00000080ff307424ULL, 0x000fe200078e00ffULL,
0x0000002027277807ULL, 0x000fe20000800000ULL, 0x00000001522c7824ULL, 0x100fe200078e0226ULL,
0x0000000146617812ULL, 0x000fe400078ec0ffULL, 0xfffffff062627812ULL, 0x000fe200078ec0ffULL,
0x000000014d247824ULL, 0x004fe200078e0226ULL, 0x0000002700277217ULL, 0x000fe20007800000ULL,
0x00000008612a7824ULL, 0x000fe200078e00ffULL, 0x0000f64862327810ULL, 0x000fe20007ffe0ffULL,
0x00005e0024247625ULL, 0x000fe200078e0030ULL, 0x00000003ff2f7819ULL, 0x000fe2000001163bULL,
0x000000002a0773c2ULL, 0x0004e200000e0000ULL, 0x000000082a677812ULL, 0x000fe200078e3cffULL,
0x0000000127007824ULL, 0x000fe200078e0a00ULL, 0x0000005524287210ULL, 0x000fe20007f3e0ffULL,
0x0000000150277824ULL, 0x000fe200078e0226ULL, 0x000000042f2b7810ULL, 0x000fe20007ffe0ffULL,
0x00000002492d7824ULL, 0x000fe200078e0261ULL, 0x000000082f317810ULL, 0x040fe20007ffe0ffULL,
0x00000000320673c2ULL, 0x000ee200000e0000ULL, 0x000000ffff297224ULL, 0x000fe200008e0625ULL,
0x000000002f00720cULL, 0x000fe20003f46070ULL, 0x00005e0027247625ULL, 0x000fe200078e0030ULL,
0x000000002b00720cULL, 0x000fc40003f26070ULL, 0x0000000c2f2f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000151277824ULL, 0x000fe200078e0226ULL, 0x00000055242a7210ULL, 0x004fe20007f7e0ffULL,
0x0000000132677824ULL, 0x000fe400078e0267ULL, 0x00005e0027267625ULL, 0x000fc800078e0030ULL,
0x000000ffff2b7224ULL, 0x000fe200018e0625ULL, 0x0000005526267210ULL, 0x080fe20007f9e0ffULL,
0x00005e002c247625ULL, 0x000fe200078e0030ULL, 0x000000003100720cULL, 0x080fe40003f66070ULL,
0x0000b0002d2c7811ULL, 0x000fe200078e60ffULL, 0x000000ffff277224ULL, 0x000fe200020e0627ULL,
0x000000002f00720cULL, 0x000fe40003f86070ULL, 0x0000005524247210ULL, 0x000fe20007fbe0ffULL,
0x000000104b2d7824ULL, 0x100fe200078e022cULL, 0x0000000706067290ULL, 0x008fe2000fffe03fULL,
0x000000104c2f7824ULL, 0x000fc400078e022cULL, 0x000000104e317824ULL, 0x100fe200078e022cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282d7faeULL, 0x0005e2000d101c48ULL,
0x000000ffff257224ULL, 0x000fe400028e0625ULL, 0x000000104f337824ULL, 0x000fe200078e022cULL,
0x000000002a2f7faeULL, 0x0005e8000c901c48ULL, 0x0000000026317faeULL, 0x0005e8000d901c48ULL,
0x0000000024337faeULL, 0x0005e8000e101c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000040067257984ULL, 0x0044e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f61c0048247984ULL, 0x000f220000000800ULL, 0x0000006e2e6e7207ULL, 0x000fe20004000000ULL,
0x8000000053277824ULL, 0x000fc600078e00ffULL, 0x0000ffff6e007812ULL, 0x000fc800078ec0ffULL,
0x0000888000287816ULL, 0x000fca00000000ffULL, 0x8000000028007824ULL, 0x000fca00078e00ffULL,
0x8000000025ff7812ULL, 0x008fe40007804800ULL, 0x8000000024ff7812ULL, 0x010fe20007824827ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x8000000053257824ULL, 0x000fe400078e00ffULL,
0x0000000000247305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000240000735dULL, 0x010fe40003800000ULL, 0x00f61c0048247984ULL, 0x000ee40000000800ULL,
0x8000000024ff7812ULL, 0x008fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000002002007824ULL, 0x000fe400078e00ffULL,
0x00000001ff6b7424ULL, 0x000fc600078e00ffULL, 0xffffff8000007812ULL, 0x000fc800078ec0ffULL,
0x0000008055257810ULL, 0x000fca0007ffe000ULL, 0x0000000154257824ULL, 0x000fca00078e0225ULL,
0x00f0000025277984ULL, 0x000ee80000000800ULL, 0x00f2000025007984ULL, 0x0008620000000800ULL,
0x000000402700720bULL, 0x008fda0003f3d000ULL, 0x0000000000247806ULL, 0x000fc800008e0100ULL,
0x0000ffff24297812ULL, 0x000fda000782c0ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000402700720bULL, 0x012fe40003f34000ULL, 0x00000027402b7209ULL, 0x040fe40007810000ULL,
0x0000000139257810ULL, 0x000fe40007ffe0ffULL, 0x00000002ff2c7819ULL, 0x000fe2000001163bULL,
0x8000002b40247221ULL, 0x100fe20000010000ULL, 0x000000ffff407224ULL, 0x000fc600078e002bULL,
0x3fb8aa3b24267820ULL, 0x000fe40000410000ULL, 0x0000000000247806ULL, 0x000fe400008e0100ULL,
0x000000022500720cULL, 0x000fe20003f25270ULL, 0x00000026002d7308ULL, 0x000e620000000800ULL,
0x0000ffff242a7812ULL, 0x000fc800078e3cffULL, 0x0000002a29ff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff6b7807ULL, 0x000fc60001000000ULL, 0x0000008002259824ULL, 0x000fc800078e0255ULL,
0x00000001542a9824ULL, 0x000fe200078e0225ULL, 0x00001f2c2d247589ULL, 0x002e6200000e0000ULL,
0x8000002b27272221ULL, 0x000fe20000010000ULL, 0x0000002d42427220ULL, 0x000fe40000410000ULL,
0x00001f562d257589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b27272820ULL, 0x000fc60000410000ULL,
0x00f4002b2a009388ULL, 0x0009e20000000800ULL, 0x0000002700472308ULL, 0x000ea20000000800ULL,
0x0000002420207220ULL, 0x082fe20000410000ULL, 0x0000002421217220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x000000240c0c7220ULL, 0x080fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x0000002404047220ULL, 0x080fe20000410000ULL, 0x0000002405057220ULL, 0x000fe20000410000ULL,
0x0000002522227220ULL, 0x088fe20000410000ULL, 0x0000002523237220ULL, 0x080fe20000410000ULL,
0x000000251e1e7220ULL, 0x080fe20000410000ULL, 0x000000251f1f7220ULL, 0x080fe20000410000ULL,
0x000000251a1a7220ULL, 0x080fe20000410000ULL, 0x000000251b1b7220ULL, 0x080fe20000410000ULL,
0x0000002516167220ULL, 0x080fe20000410000ULL, 0x0000002517177220ULL, 0x080fe20000410000ULL,
0x0000002512127220ULL, 0x080fe20000410000ULL, 0x0000002513137220ULL, 0x080fe20000410000ULL,
0x000000250e0e7220ULL, 0x080fe20000410000ULL, 0x000000250f0f7220ULL, 0x080fe20000410000ULL,
0x000000250a0a7220ULL, 0x080fe20000410000ULL, 0x000000250b0b7220ULL, 0x080fe20000410000ULL,
0x0000002506067220ULL, 0x080fe20000410000ULL, 0x0000002507077220ULL, 0x000fe20000410000ULL,
0x0000000047002220ULL, 0x004fc80000410000ULL, 0x0000004200427221ULL, 0x012fe20000010000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x0000000861007824ULL, 0x000fe400078e00ffULL,
0x8000000028277824ULL, 0x000fc600078e00ffULL, 0x0000000800257812ULL, 0x000fca00078e3cffULL,
0x0000000162257824ULL, 0x000fca00078e0225ULL, 0x00f64c0025007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000028277824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x00f64c0025247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000100046007824ULL, 0x000fe200078e00ffULL, 0x000099106b6b7816ULL, 0x000fe200000000ffULL,
0x0000100002247824ULL, 0x000fc600078e00ffULL, 0x00001000002d7812ULL, 0x000fe400078e0cffULL,
0xffffe00024007812ULL, 0x000fe400078ec0ffULL, 0x0000b0003e317810ULL, 0x100fe40007ffe02dULL,
0x0000b00000007810ULL, 0x000fc60007ffe02dULL, 0x000000105e637824ULL, 0x100fe400078e0231ULL,
0x000000105d687824ULL, 0x100fe400078e0200ULL, 0x000000105f697824ULL, 0x000fe200078e0200ULL,
0x00000000632c783bULL, 0x000e620000004200ULL, 0x0000001060647824ULL, 0x000fc600078e0231ULL,
0x000000006824783bULL, 0x000ee80000004200ULL, 0x000000006928783bULL, 0x000f280000004200ULL,
0x000000006430783bULL, 0x000ea20000004200ULL, 0x0000002c00ba7306ULL, 0x002fe20000009400ULL,
0x00000018ff987819ULL, 0x000fc4000001142cULL, 0x00000018ff927819ULL, 0x000fe2000001142dULL,
0x0000010024bc7824ULL, 0x048fe200078e00ffULL, 0x00000018ffc87819ULL, 0x000fe20000011424ULL,
0x0001000024af7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe20000011425ULL,
0x0000002400d57306ULL, 0x000fe20000009400ULL, 0x00000018ffbc7819ULL, 0x000fe200000114bcULL,
0x0000010025cd7824ULL, 0x040fe200078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0001000025d67824ULL, 0x000fe200078e00ffULL, 0x00000018ffa27819ULL, 0x010fe20000011429ULL,
0x0001000029d77824ULL, 0x000fe200078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe200000114cdULL,
0x000000bc00b07306ULL, 0x000fe20000209400ULL, 0x00000018ffa67819ULL, 0x000fe2000001142bULL,
0x0000010026cc7824ULL, 0x040fe200078e00ffULL, 0x00000018ffd67819ULL, 0x000fe200000114d6ULL,
0x0000010027e57824ULL, 0x040fe200078e00ffULL, 0x00000018ffca7819ULL, 0x000fe20000011426ULL,
0x0001000026e17824ULL, 0x000fe200078e00ffULL, 0x00000018ffcc7819ULL, 0x000fe200000114ccULL,
0x000000bc00b17306ULL, 0x0002e20000205400ULL, 0x00000018ffe57819ULL, 0x000fe200000114e5ULL,
0x0001000027de7824ULL, 0x000fe200078e00ffULL, 0x00000018ffe17819ULL, 0x000fc400000114e1ULL,
0x00000018ffc77819ULL, 0x000fe40000011427ULL, 0x00000018ffde7819ULL, 0x000fe200000114deULL,
0x0000002400dc7306ULL, 0x000f220000005400ULL, 0x000000bc00bc7245ULL, 0x002fe4000020d400ULL,
0x00000018ffbf7819ULL, 0x000fe40000011428ULL, 0x00000018ffd77819ULL, 0x000fe400000114d7ULL,
0x00000018ffa37819ULL, 0x000fe2000001142aULL, 0x000000af00b67306ULL, 0x000fe20000209400ULL,
0x000000b1b000720bULL, 0x008fc40003f9d000ULL, 0x00000018ff887819ULL, 0x000fe4000001142eULL,
0x00000018ff837819ULL, 0x000fe4000001142fULL, 0x00000018ff717819ULL, 0x004fe20000011432ULL,
0x000000af00eb7306ULL, 0x0002a20000205400ULL, 0x000000dcd500720bULL, 0x010fe40003f3d000ULL,
0x00000018ff7a7819ULL, 0x000fe40000011430ULL, 0x00000018ff797819ULL, 0x000fc40000011431ULL,
0x00000001bcbc4812ULL, 0x000fe200078efcffULL, 0x000000c800b87306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fe4000020d400ULL, 0x00000018ff707819ULL, 0x000fca0000011433ULL,
0x000000c800b37306ULL, 0x000e620000205400ULL, 0x000000ebb600720bULL, 0x004fce0003f9d000ULL,
0x0000002400997306ULL, 0x0004ec000000d400ULL, 0x00000001afaf4812ULL, 0x000fe400078efcffULL,
0x0000002500d87306ULL, 0x000fe20000009400ULL, 0x0000010029247824ULL, 0x004fe200078e00ffULL,
0x000000b3b800720bULL, 0x002fc80003f7d000ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000002500ad7306ULL, 0x000e620000005400ULL, 0x0000000199991812ULL, 0x008fe400078efcffULL,
0x000000ff6b00720cULL, 0x000fca0003f25270ULL, 0x0000002900c67306ULL, 0x000ff00000009400ULL,
0x0000002900c97306ULL, 0x000fe20000005400ULL, 0x000000add800720bULL, 0x002fe20003fbd000ULL,
0x000001002aad7824ULL, 0x000fca00078e00ffULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x0000002900897306ULL, 0x0003f0000000d400ULL, 0x0000002b00c27306ULL, 0x000fe20000009400ULL,
0x000001002b297824ULL, 0x002fce00078e00ffULL, 0x0000002b00bb7306ULL, 0x000ff00000005400ULL,
0x0000002b00827306ULL, 0x0003f0000000d400ULL, 0x000000cd00cb7306ULL, 0x000fe20000209400ULL,
0x000100002b2b7824ULL, 0x002fca00078e00ffULL, 0x00000018ffb87819ULL, 0x000fe2000001142bULL,
0x00000200022b7824ULL, 0x000fe200078e00ffULL, 0x000000cd00ea7306ULL, 0x000e680000205400ULL,
0xfffff8002b2b7812ULL, 0x000fc800078ec0ffULL, 0x000000d600e87306ULL, 0x000fe20000209400ULL,
0x000000018a6b7824ULL, 0x100fe200078e022bULL, 0x000000c8008a7245ULL, 0x000fe2000020d400ULL,
0x000000016a6a7824ULL, 0x000fe400078e022bULL, 0x000001002f2b7824ULL, 0x000fe200078e00ffULL,
0x000000018a8a3812ULL, 0x000fe400078efcffULL, 0x000000d600e97306ULL, 0x000ea20000205400ULL,
0x000000eacb00720bULL, 0x002fe20003f9d000ULL, 0x000001002dcb7824ULL, 0x000fc400078e00ffULL,
0x000100002dea7824ULL, 0x000fc600078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x000000c300b27306ULL, 0x000ff00000209400ULL, 0x000000c300bd7306ULL, 0x000e620000205400ULL,
0x000000e9e800720bULL, 0x004fe20003f7d000ULL, 0x000100002ce97824ULL, 0x000fc400078e00ffULL,
0x000001002ee87824ULL, 0x000fc800078e00ffULL, 0x0000002500977306ULL, 0x0004e2000000d400ULL,
0x00000018ffe87819ULL, 0x000fce00000114e8ULL, 0x000000cc00da7306ULL, 0x000fe20000209400ULL,
0x000000bdb200720bULL, 0x002fe20003f5d000ULL, 0x000001002cb27824ULL, 0x000fe400078e00ffULL,
0x0000010028257824ULL, 0x004fc600078e00ffULL, 0x00000018ffb27819ULL, 0x000fe200000114b2ULL,
0x000000cc00db7306ULL, 0x0002a20000205400ULL, 0x0000000197975812ULL, 0x008fe400078efcffULL,
0x00000018ff257819ULL, 0x000fca0000011425ULL, 0x0000002800ce7306ULL, 0x000fe20000009400ULL,
0x000000cc00cc7245ULL, 0x002fce000020d400ULL, 0x0000002800d37306ULL, 0x000e620000005400ULL,
0x000000dbda00720bULL, 0x004fe20003fbd000ULL, 0x0000010031da7824ULL, 0x000fe200078e00ffULL,
0x00000018ffdb7819ULL, 0x000fc800000114eaULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x000000e500d17306ULL, 0x000fec0000209400ULL, 0x00000001cccc5812ULL, 0x000fe400078efcffULL,
0x000000e500d27306ULL, 0x000eb00000205400ULL, 0x0000002c00b77306ULL, 0x000ff00000005400ULL,
0x0000002c007e7306ULL, 0x0007f0000000d400ULL, 0x0000002600b47306ULL, 0x000fe20000009400ULL,
0x000000cd002c7245ULL, 0x008fc8000020d400ULL, 0x000000012c2c4812ULL, 0x000fe400078efcffULL,
0x000000d3ce00720bULL, 0x002fe20003f9d000ULL, 0x0000002600ef7306ULL, 0x000e620000005400ULL,
0x000000d600ce7245ULL, 0x000fe4000020d400ULL, 0x00000018ffd37819ULL, 0x000fe400000114e9ULL,
0x00000001cece3812ULL, 0x000fe400078efcffULL, 0x000000d2d100720bULL, 0x004fe20003f7d000ULL,
0x000000ca00e07306ULL, 0x000fe20000209400ULL, 0x0000010030d17824ULL, 0x000fc400078e00ffULL,
0x0001000030d27824ULL, 0x000fc600078e00ffULL, 0x00000018ffd17819ULL, 0x000fe400000114d1ULL,
0x000000ca00c57306ULL, 0x0004e20000205400ULL, 0x000000efb400720bULL, 0x002fe20003fdd000ULL,
0x000100002ab47824ULL, 0x000fe200078e00ffULL, 0x00000018ffd27819ULL, 0x000fc800000114d2ULL,
0x00000018ffb07819ULL, 0x000fe200000114b4ULL, 0x0000002700ae7306ULL, 0x000fe20000009400ULL,
0x000000ca00ca7245ULL, 0x004fce000020d400ULL, 0x0000002700ed7306ULL, 0x000e620000005400ULL,
0x000000c5e000720bULL, 0x008fe40003fbd000ULL, 0x000000e500c57245ULL, 0x000fc8000020d400ULL,
0x00000001c5c53812ULL, 0x000fe200078efcffULL, 0x000000e100d47306ULL, 0x000fec0000209400ULL,
0x00000001caca5812ULL, 0x000fe400078efcffULL, 0x000000e100dd7306ULL, 0x000fe20000205400ULL,
0x000000edae00720bULL, 0x002fc40003f1d000ULL, 0x00000018ffae7819ULL, 0x000fca0000011429ULL,
0x000000de00e67306ULL, 0x000ff00000209400ULL, 0x000000de00e77306ULL, 0x0002b00000205400ULL,
0x0000002600917306ULL, 0x000722000000d400ULL, 0x000000de00de7245ULL, 0x002fce000020d400ULL,
0x000000c700cf7306ULL, 0x000fe20000209400ULL, 0x0001000028267824ULL, 0x008fe200078e00ffULL,
0x000000e7e600720bULL, 0x004fc80003f7d000ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x000000c700d07306ULL, 0x0002a20000205400ULL, 0x0000000191916812ULL, 0x010fcc00078efcffULL,
0x00000001dede3812ULL, 0x000fe200078efcffULL, 0x0000002400df7306ULL, 0x000fe20000209400ULL,
0x000000c700c77245ULL, 0x002fce000020d400ULL, 0x0000002400e27306ULL, 0x000e620000205400ULL,
0x000000d0cf00720bULL, 0x004fe40003fdd000ULL, 0x000000e100cf7245ULL, 0x000fca000020d400ULL,
0x00000027008e7306ULL, 0x000eac000000d400ULL, 0x00000001c7c76812ULL, 0x000fe400078efcffULL,
0x0000002d009e7306ULL, 0x000fe20000009400ULL, 0x000000e2df00720bULL, 0x002fce0003fbd000ULL,
0x0000002d00a17306ULL, 0x000fe20000005400ULL, 0x000000018e8e0812ULL, 0x004fce00078efcffULL,
0x0000002d00007306ULL, 0x0003f0000000d400ULL, 0x0000002500e37306ULL, 0x000fe20000209400ULL,
0x000000c3002d7245ULL, 0x002fe2000020d400ULL, 0x0001000031c37824ULL, 0x000fc600078e00ffULL,
0x000000012d2d2812ULL, 0x000fe400078efcffULL, 0x000000ddd400720bULL, 0x000fe20003f5d000ULL,
0x0000002500e47306ULL, 0x000e620000205400ULL, 0x00000018ffc37819ULL, 0x000fe400000114c3ULL,
0x000000ce2d2d723eULL, 0x000fca00000010ffULL, 0x0000002a00b57306ULL, 0x000fe80000009400ULL,
0x00000001cfcf2812ULL, 0x000fe400078efcffULL, 0x000000c9c600720bULL, 0x000fe40003f5d000ULL,
0x0000002a00be7306ULL, 0x000ea20000005400ULL, 0x000000e4e300720bULL, 0x002fe40003f1d000ULL,
0x0000002500c67245ULL, 0x000fc4000020d400ULL, 0x000000cfcaca723eULL, 0x000fc600000010ffULL,
0x00000028008b7306ULL, 0x000e66000000d400ULL, 0x0000000189892812ULL, 0x000fe400078efcffULL,
0x000000b7ba00720bULL, 0x000fe40003f5d000ULL, 0x00000001c6c60812ULL, 0x000fe200078efcffULL,
0x000000bf00c17306ULL, 0x000fe20000209400ULL, 0x000000beb500720bULL, 0x004fe40003f7d000ULL,
0x0000002400be7245ULL, 0x000fc4000020d400ULL, 0x000000bf00ba7245ULL, 0x000fe4000020d400ULL,
0x00000001bebe5812ULL, 0x000fe200078efcffULL, 0x000000bf00c47306ULL, 0x000ea20000205400ULL,
0x000000018b8b4812ULL, 0x002fe400078efcffULL, 0x000000bbc200720bULL, 0x000fe40003fbd000ULL,
0x0000002600b57245ULL, 0x000fe4000020d400ULL, 0x000000017e7e2812ULL, 0x000fe200078efcffULL,
0x000000d700d97306ULL, 0x000fe20000209400ULL, 0x0000008bc6c6723eULL, 0x000fce00000010ffULL,
0x000000d700d87306ULL, 0x0002e20000205400ULL, 0x000000c4c100720bULL, 0x004fe40003fdd000ULL,
0x0000000182825812ULL, 0x000fe400078efcffULL, 0x00000018ffc17819ULL, 0x000fe4000001142bULL,
0x000000a19e00720bULL, 0x000fe20003fbd000ULL, 0x0000002600277306ULL, 0x000fe20000209400ULL,
0x000000d700d77245ULL, 0x002fe4000020d400ULL, 0x000000c100e97245ULL, 0x000fc6000020d400ULL,
0x00000001baba6812ULL, 0x000fe400078efcffULL, 0x0000002600dc7306ULL, 0x000e620000205400ULL,
0x000000d8d900720bULL, 0x008fc60003f9d000ULL, 0x0000000100005812ULL, 0x000fc800078efcffULL,
0x0000002a00857306ULL, 0x000eac000000d400ULL, 0x00000001d7d74812ULL, 0x000fe400078efcffULL,
0x000000ad00d57306ULL, 0x000fe20000209400ULL, 0x000000dc2700720bULL, 0x002fe40003f1d000ULL,
0x009800006b24783bULL, 0x000fea0000000200ULL, 0x000000ad00287306ULL, 0x000e620000205400ULL,
0x0000000185853812ULL, 0x004fca00078efcffULL, 0x00000001b5b50812ULL, 0x000fe400078efcffULL,
0x000000ae00297306ULL, 0x000fe40000209400ULL, 0x000000b5baba723eULL, 0x000fcc00000010ffULL,
0x000000ae002a7306ULL, 0x000ea20000205400ULL, 0x00000028d500720bULL, 0x002fce0003fdd000ULL,
0x000000a200c07306ULL, 0x000ff00000209400ULL, 0x000000a200b97306ULL, 0x0002e20000205400ULL,
0x0000002a2900720bULL, 0x004fe40003f9d000ULL, 0x009800006a28783bULL, 0x000fea0000000200ULL,
0x0000009200ab7306ULL, 0x000fe20000209400ULL, 0x000000a200a27245ULL, 0x002fce000020d400ULL,
0x0000009200ac7306ULL, 0x0002a20000205400ULL, 0x000000b9c000720bULL, 0x008fe40003f1d000ULL,
0x000000ad00c07245ULL, 0x000fe4000020d400ULL, 0x00000002ffb97819ULL, 0x000fe4000001163bULL,
0x00000001c0c06812ULL, 0x000fe200078efcffULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x0000009200927245ULL, 0x002fe4000020d400ULL, 0x00000085c0c0723eULL, 0x000fc600000010ffULL,
0x00000001a2a20812ULL, 0x000fe400078efcffULL, 0x000000b000b47306ULL, 0x0002e20000205400ULL,
0x000000acab00720bULL, 0x004fce0003fbd000ULL, 0x0000002e00a07306ULL, 0x000fe20000009400ULL,
0x000000b000b07245ULL, 0x002fca000020d400ULL, 0x0000000192925812ULL, 0x000fe400078efcffULL,
0x0000002e009b7306ULL, 0x000e620000005400ULL, 0x000000b4b100720bULL, 0x008fce0003fdd000ULL,
0x0000002e007d7306ULL, 0x0004ec000000d400ULL, 0x00000001b0b06812ULL, 0x000fe400078efcffULL,
0x000000a300a47306ULL, 0x000fe20000209400ULL, 0x000100002e2e7824ULL, 0x004fe200078e00ffULL,
0x0000009ba000720bULL, 0x002fc40003fdd000ULL, 0x000000a6009b7245ULL, 0x000fe4000020d400ULL,
0x00000018ffb77819ULL, 0x000fe4000001142eULL, 0x000000a300a57306ULL, 0x0002a20000205400ULL,
0x00000047ff2e723eULL, 0x000fc800000010ffULL, 0x000054102ebf7816ULL, 0x000fe4000000002eULL,
0x000000017d7d6812ULL, 0x008fe200078efcffULL, 0x000000b800b37306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fe2000020d400ULL, 0x00001fb9bfb17589ULL, 0x000e6800000e0000ULL,
0x00001f56bf2e7589ULL, 0x000ee400000e0000ULL, 0x000000b800b67306ULL, 0x0008620000205400ULL,
0x000000a5a400720bULL, 0x004fc40003f1d000ULL, 0x000000ae00a57245ULL, 0x000fc8000020d400ULL,
0x00000001a5a54812ULL, 0x000fe200078efcffULL, 0x000000c100bb7306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x010fca000020d400ULL, 0x00000001a3a30812ULL, 0x000fe400078efcffULL,
0x000000c100c27306ULL, 0x0005220000205400ULL, 0x000000b6b300720bULL, 0x002fe20003f9d000ULL,
0x000000b128289231ULL, 0x080fe200003400ffULL, 0x000000b0a3b0723eULL, 0x000fe200000010ffULL,
0x000000b12a2a9231ULL, 0x080fe400003400ffULL, 0x000000b124249231ULL, 0x080fe400003400ffULL,
0x0000002f009f7306ULL, 0x000fe20000009400ULL, 0x000000b126269231ULL, 0x000fe200003400ffULL,
0x00000082a5c1723eULL, 0x004fe200000010ffULL, 0x0000002e29299231ULL, 0x008fc400003400ffULL,
0x0000002e2b2b9231ULL, 0x080fe200003400ffULL, 0x00000001b8b84812ULL, 0x000fe200078efcffULL,
0x0000002e25259231ULL, 0x080fe200003400ffULL, 0x0000002f009c7306ULL, 0x000e620000005400ULL,
0x000000c2bb00720bULL, 0x010fe20003fbd000ULL, 0x0000002e27279231ULL, 0x000fe200003400ffULL,
0x00000099bc2e723eULL, 0x000fe200000010ffULL, 0x000000c02808723cULL, 0x000fe20000041808ULL,
0x000000d7a2bb723eULL, 0x000fc600000010ffULL, 0x000000b200bd7306ULL, 0x000fe80000209400ULL,
0x000000ba280c723cULL, 0x000fe4000004180cULL, 0x00000001e9e95812ULL, 0x000fe400078efcffULL,
0x000000b200c87306ULL, 0x000ea20000205400ULL, 0x0000009c9f00720bULL, 0x002fe40003f1d000ULL,
0x000000b2009f7245ULL, 0x000fca000020d400ULL, 0x00000088008d7306ULL, 0x000ff00000209400ULL,
0x00000088008c7306ULL, 0x0002e20000205400ULL, 0x000000c8bd00720bULL, 0x004fce0003f9d000ULL,
0x000000d300d47306ULL, 0x000fe20000209400ULL, 0x0000008800887245ULL, 0x002fca000020d400ULL,
0x000000019f9f4812ULL, 0x000fe400078efcffULL, 0x000000d300dd7306ULL, 0x0002a20000205400ULL,
0x0000008c8d00720bULL, 0x008fe40003fbd000ULL, 0x0000007e9f7e723eULL, 0x000fca00000010ffULL,
0x000000a600a77306ULL, 0x000fe20000209400ULL, 0x000000d300d37245ULL, 0x002fca000020d400ULL,
0x0000000188885812ULL, 0x000fe400078efcffULL, 0x000000a600a87306ULL, 0x000e620000205400ULL,
0x000000ddd400720bULL, 0x004fce0003f3d000ULL, 0x00000030009a7306ULL, 0x000fec0000009400ULL,
0x00000001d3d31812ULL, 0x000fe400078efcffULL, 0x00000030009d7306ULL, 0x000ea20000005400ULL,
0x000000a8a700720bULL, 0x002fce0003f7d000ULL, 0x0000009800a97306ULL, 0x000fec0000209400ULL,
0x000000019b9b3812ULL, 0x000fe400078efcffULL, 0x0000009800aa7306ULL, 0x0002e20000205400ULL,
0x0000009d9a00720bULL, 0x004fe40003f9d000ULL, 0x000000cb009d7245ULL, 0x000fc4000020d400ULL,
0x000000b89bb1723eULL, 0x000fc600000010ffULL, 0x000000e800c97306ULL, 0x000fe20000209400ULL,
0x0000009800987245ULL, 0x002fc6000020d400ULL, 0x000000b02804723cULL, 0x000fe80000041804ULL,
0x000000e800c47306ULL, 0x0002a20000205400ULL, 0x000000aaa900720bULL, 0x008fce0003f5d000ULL,
0x000000d1009c7306ULL, 0x000fe20000209400ULL, 0x000000e800e87245ULL, 0x002fca000020d400ULL,
0x0000000198982812ULL, 0x000fe400078efcffULL, 0x000000d100a17306ULL, 0x000e620000205400ULL,
0x000000c4c900720bULL, 0x004fe40003f3d000ULL, 0x000000d39898723eULL, 0x000fe400000010ffULL,
0x000000c300d37245ULL, 0x000fc6000020d400ULL, 0x0000002f00767306ULL, 0x0004ec000000d400ULL,
0x00000001e8e81812ULL, 0x000fe400078efcffULL, 0x000000cb00cd7306ULL, 0x000fe20000209400ULL,
0x000100002f2f7824ULL, 0x004fe200078e00ffULL, 0x000000a19c00720bULL, 0x002fc40003fbd000ULL,
0x0000007de8e8723eULL, 0x000fe400000010ffULL, 0x00000018ffa47819ULL, 0x000fe4000001142fULL,
0x000000cb00d67306ULL, 0x0002a20000205400ULL, 0x000000972c2f723eULL, 0x000fe400000010ffULL,
0x000000af8a2c723eULL, 0x000fe400000010ffULL, 0x0000000176760812ULL, 0x008fc600078efcffULL,
0x000000b700ad7306ULL, 0x000fe20000209400ULL, 0x0000002e2820723cULL, 0x040fe20000041820ULL,
0x000000dec7cb723eULL, 0x002fe400000010ffULL, 0x00000089bec7723eULL, 0x000fe400000010ffULL,
0x000000a400897245ULL, 0x000fe4000020d400ULL, 0x000000b700b47306ULL, 0x0002e20000205400ULL,
0x00000091cc2e723eULL, 0x000fe200000010ffULL, 0x0000002c281c723cULL, 0x000fe2000004181cULL,
0x0000008ec52f723eULL, 0x000fc400000010ffULL, 0x000000d6cd00720bULL, 0x004fe40003f7d000ULL,
0x00000076e9e9723eULL, 0x000fe200000010ffULL, 0x0000003300907306ULL, 0x000fe20000009400ULL,
0x000000b700b77245ULL, 0x002fe2000020d400ULL, 0x0000002e2818723cULL, 0x000fe20000041818ULL,
0x00000083002c7245ULL, 0x000fca000020d400ULL, 0x00000033008f7306ULL, 0x000e620000005400ULL,
0x000000b4ad00720bULL, 0x008fe20003fdd000ULL, 0x000000ca2814723cULL, 0x040fe20000041814ULL,
0x000000d1002e7245ULL, 0x000fe4000020d400ULL, 0x000000019d9d3812ULL, 0x000fe400078efcffULL,
0x000000012e2e5812ULL, 0x000fe200078efcffULL, 0x000000da009a7306ULL, 0x000fe20000209400ULL,
0x000000da002f7245ULL, 0x000fe2000020d400ULL, 0x000000c62810723cULL, 0x000fe80000041810ULL,
0x00000001b7b76812ULL, 0x000fc400078efcffULL, 0x000000da00a97306ULL, 0x000ea20000205400ULL,
0x0000008f9000720bULL, 0x002fe20003f3d000ULL, 0x000000e82418723cULL, 0x000fe20000041818ULL,
0x0000007a00297245ULL, 0x000fe4000020d400ULL, 0x000000b78888723eULL, 0x000fc600000010ffULL,
0x0000003100947306ULL, 0x000ff00000009400ULL, 0x0000003100937306ULL, 0x000e620000005400ULL,
0x000000a99a00720bULL, 0x004fce0003fbd000ULL, 0x0000008300877306ULL, 0x000fec0000209400ULL,
0x000000012f2f5812ULL, 0x000fe400078efcffULL, 0x0000008300867306ULL, 0x000ea20000205400ULL,
0x000000939400720bULL, 0x002fce0003f5d000ULL, 0x000000db00e07306ULL, 0x000ff00000209400ULL,
0x000000db00e17306ULL, 0x0002e20000205400ULL, 0x000000868700720bULL, 0x004fce0003f1d000ULL,
0x000000a400a77306ULL, 0x000fe20000209400ULL, 0x000000db00db7245ULL, 0x002fca000020d400ULL,
0x000000012c2c0812ULL, 0x000fe400078efcffULL, 0x000000a4009e7306ULL, 0x000e620000205400ULL,
0x000000e1e000720bULL, 0x008fce0003f7d000ULL, 0x0000007100787306ULL, 0x000fec0000209400ULL,
0x00000001dbdb3812ULL, 0x000fe400078efcffULL, 0x00000071006f7306ULL, 0x0004e20000205400ULL,
0x0000009ea700720bULL, 0x002fe40003fdd000ULL, 0x000000db9299723eULL, 0x000fca00000010ffULL,
0x00000030007b7306ULL, 0x000322000000d400ULL, 0x0000007100717245ULL, 0x004fe2000020d400ULL,
0x00000098241c723cULL, 0x000fe8000004181cULL, 0x0000000189896812ULL, 0x000fe400078efcffULL,
0x0000003100747306ULL, 0x000522000000d400ULL, 0x0000010033307824ULL, 0x002fe200078e00ffULL,
0x0000006f7800720bULL, 0x008fc40003fbd000ULL, 0x000000892c89723eULL, 0x000fe400000010ffULL,
0x00000018ff877819ULL, 0x000fe40000011430ULL, 0x0000003200957306ULL, 0x000fe20000009400ULL,
0x0000010032317824ULL, 0x004fe200078e00ffULL, 0x000000017b7b4812ULL, 0x010fe200078efcffULL,
0x000000882414723cULL, 0x000fe60000041814ULL, 0x00000018ff317819ULL, 0x000fc40000011431ULL,
0x0000003200967306ULL, 0x000e620000005400ULL, 0x0000000174742812ULL, 0x000fe400078efcffULL,
0x0000000171715812ULL, 0x000fe400078efcffULL, 0x0000007b2e2e723eULL, 0x000fe400000010ffULL,
0x000000742f2f723eULL, 0x000fe200000010ffULL, 0x0000007a00817306ULL, 0x000fec0000209400ULL,
0x0000002e2410723cULL, 0x000fe40000041810ULL, 0x0000007a00847306ULL, 0x000ea20000205400ULL,
0x000000969500720bULL, 0x002fce0003f7d000ULL, 0x0000007900807306ULL, 0x000ff00000209400ULL,
0x00000079007f7306ULL, 0x000e620000205400ULL, 0x000000848100720bULL, 0x004fce0003fdd000ULL,
0x000000d200977306ULL, 0x000fec0000209400ULL, 0x0000000129296812ULL, 0x000fe400078efcffULL,
0x000000d2008a7306ULL, 0x0004e20000205400ULL, 0x0000007f8000720bULL, 0x002fe40003f1d000ULL,
0x000000009d7f723eULL, 0x000fc400000010ffULL, 0x0000007900007245ULL, 0x000fc6000020d400ULL,
0x000000c3008f7306ULL, 0x000fe20000209400ULL, 0x000000d200d27245ULL, 0x004fe2000020d400ULL,
0x0000007e2420723cULL, 0x000fe80000041820ULL, 0x0000000100000812ULL, 0x000fe400078efcffULL,
0x000000c3008e7306ULL, 0x000e620000205400ULL, 0x0000008a9700720bULL, 0x008fce0003f9d000ULL,
0x0000003200737306ULL, 0x0004ec000000d400ULL, 0x00000001d2d24812ULL, 0x000fe400078efcffULL,
0x0000003300727306ULL, 0x0008e2000000d400ULL, 0x0001000032327824ULL, 0x004fe200078e00ffULL,
0x0000008e8f00720bULL, 0x002fc40003f5d000ULL, 0x000000d229d2723eULL, 0x000fe400000010ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000007000757306ULL, 0x000fe20000209400ULL,
0x0001000033337824ULL, 0x010fe200078e00ffULL, 0x0000000173733812ULL, 0x008fe400078efcffULL,
0x0000008700297245ULL, 0x000fe4000020d400ULL, 0x00000018ff337819ULL, 0x000fc40000011433ULL,
0x00000070007c7306ULL, 0x0002a20000205400ULL, 0x00000001d3d32812ULL, 0x000fe400078efcffULL,
0x0000000172721812ULL, 0x000fe400078efcffULL, 0x000000d300d3723eULL, 0x000fe400000010ffULL,
0x0000003100007245ULL, 0x000fe2000020d400ULL, 0x00000031002d7306ULL, 0x000fe20000209400ULL,
0x0000007000707245ULL, 0x002fc6000020d400ULL, 0x000000d2240c723cULL, 0x000fe8000004180cULL,
0x0000003100867306ULL, 0x000e620000205400ULL, 0x0000007c7500720bULL, 0x004fce0003f9d000ULL,
0x0000008700857306ULL, 0x000fec0000209400ULL, 0x0000000170704812ULL, 0x000fe400078efcffULL,
0x0000008700827306ULL, 0x000ea20000205400ULL, 0x000000862d00720bULL, 0x002fce0003fdd000ULL,
0x0000003200307306ULL, 0x000fec0000209400ULL, 0x0000000100006812ULL, 0x000fe400078efcffULL,
0x00000032002b7306ULL, 0x0002e20000205400ULL, 0x000000828500720bULL, 0x004fce0003f5d000ULL,
0x0000003300287306ULL, 0x000fe20000209400ULL, 0x0000003200327245ULL, 0x002fca000020d400ULL,
0x0000000129292812ULL, 0x000fe400078efcffULL, 0x00000033006f7306ULL, 0x0002a20000205400ULL,
0x0000002b3000720bULL, 0x008fe40003f1d000ULL, 0x000000722929723eULL, 0x000fe400000010ffULL,
0x0000003300337245ULL, 0x002fd2000020d400ULL, 0x0000000132320812ULL, 0x000fe400078efcffULL,
0x0000006f2800720bULL, 0x004fe40003f7d000ULL, 0x000000730028723eULL, 0x000fe400000010ffULL,
0x000000327132723eULL, 0x000fe400000010ffULL, 0x0000f62039007811ULL, 0x000fc600078e20ffULL,
0x000000282408723cULL, 0x000fe80000041808ULL, 0x0000000133333812ULL, 0x000fc800078efcffULL,
0x000000337033723eULL, 0x000fce00000010ffULL, 0x000000322404723cULL, 0x000fe20000041804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200043ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000434247824ULL, 0x000fe200078e0239ULL, 0x000000ff6eff7812ULL, 0x000fe2000784c0ffULL,
0x0000000000ff7f8cULL, 0x0005e2000c80043fULL, 0x0000000146ff7812ULL, 0x000fe4000780c0ffULL,
0x0000008024247811ULL, 0x000fe400078e30ffULL, 0x00000001ff737807ULL, 0x000fe40001000000ULL,
0x000000032400720cULL, 0x000fc40003f46070ULL, 0x000000ff77ff7812ULL, 0x000fe4000782c0ffULL,
0x0000006e73717207ULL, 0x000fe40004000000ULL, 0x00000001ff707807ULL, 0x000fe40004800000ULL,
0x00000001466f7812ULL, 0x000fca00078ec0ffULL, 0x0000558000002947ULL, 0x000fea0003800000ULL,
0x0000240043257984ULL, 0x004ea20000000800ULL, 0x00000001ff247807ULL, 0x000fca0004800000ULL,
0x8000000024007824ULL, 0x000fca00078e00ffULL, 0x8000000025ff7812ULL, 0x004fe20007844800ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000002947ULL, 0x000fea0003800000ULL,
0x0000240043257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x004fe40007844800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000024257824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x0000240043247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007844825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000016d6c7824ULL, 0x000fe200078e026cULL,
0x00000001ff497819ULL, 0x000fc80000011602ULL, 0x000000036c007812ULL, 0x000fc800078ec0ffULL,
0x000000030000780cULL, 0x000fe20003f45270ULL, 0x0000002049007824ULL, 0x000fc600078e0258ULL,
0x00000001386d7807ULL, 0x000fe40005000000ULL, 0x000000c000007810ULL, 0x000fc60007ffe0ffULL,
0x000000016c4a7824ULL, 0x000fe200078e026dULL, 0x000000203f247812ULL, 0x000fc800078ef800ULL,
0x000000354a00720cULL, 0x000fe20003f46070ULL, 0x000000413a287224ULL, 0x020fe200078e0224ULL,
0x0000000003277217ULL, 0x000fe20007800000ULL, 0xffffffffff3a7424ULL, 0x000fd400078e00ffULL,
0x000000014425a824ULL, 0x000fe400078e024aULL, 0x00000004ff26a424ULL, 0x000fc800078e00ffULL,
0x000060002524a625ULL, 0x000fe200078e0026ULL, 0x0000000134267810ULL, 0x000fc60007ffe0ffULL,
0x0000000127277824ULL, 0x000fe200078e0a00ULL, 0x00000008243aa981ULL, 0x000562000c1e1900ULL,
0x000000372600720cULL, 0x000fe20003f46070ULL, 0x00000080ff2f7424ULL, 0x000fe200078e00ffULL,
0x00000010362a7812ULL, 0x000fe200078ec0ffULL, 0x000000014d007824ULL, 0x100fe200078e0228ULL,
0x0000002027277807ULL, 0x000fe20001000000ULL, 0x0000000150267824ULL, 0x000fe200078e0228ULL,
0x00000003ff2d7819ULL, 0x000fe4000001163bULL, 0x000000272a277217ULL, 0x000fe20007800000ULL,
0x00005e0000247625ULL, 0x004fe200078e002fULL, 0x000000042d297810ULL, 0x000fc60007ffe0ffULL,
0x0000000127007824ULL, 0x000fe200078e0a2aULL, 0x00000055242a7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0026267625ULL, 0x000fc800078e002fULL, 0x0000000151247824ULL, 0x100fe200078e0228ULL,
0x0000005526267210ULL, 0x000fe20007f7e0ffULL, 0x0000000152287824ULL, 0x000fe400078e0228ULL,
0x000000ffff2b7224ULL, 0x000fe200010e0625ULL, 0x000000002900720cULL, 0x000fe20003f46070ULL,
0x00005e0024247625ULL, 0x000fc800078e002fULL, 0x00005e0028287625ULL, 0x000fe200078e002fULL,
0x0000005524247210ULL, 0x080fe40007f9e0ffULL, 0x000000082d2f7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff277224ULL, 0x000fe200018e0627ULL, 0x0000005528287210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff257224ULL, 0x000fe200020e0625ULL, 0x000000002d00720cULL, 0x0c0fe40003f66070ULL,
0x0000000c2d2d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff297224ULL, 0x000fe200028e0629ULL,
0x000000002f00720cULL, 0x000fc40003f86070ULL, 0x000000002d00720cULL, 0x000fce0003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a597faeULL, 0x0005e8000d901c48ULL,
0x00000000265a7faeULL, 0x0005e8000d101c48ULL, 0x00000000245b7faeULL, 0x0005e8000e101c48ULL,
0x00000000285c7faeULL, 0x0005e8000e901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000406ff257984ULL, 0x004ea20008000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f62c0048247984ULL, 0x000ee20000000800ULL, 0x0000006e736e7207ULL, 0x000fe20004000000ULL,
0x8000000053277824ULL, 0x000fc600078e00ffULL, 0x0000ffff6e007812ULL, 0x000fc800078ec0ffULL,
0x0000888000287816ULL, 0x000fca00000000ffULL, 0x8000000028007824ULL, 0x000fca00078e00ffULL,
0x8000000025ff7812ULL, 0x004fe40007844800ULL, 0x8000000024ff7812ULL, 0x008fe20007864827ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000003947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x8000000053257824ULL, 0x000fe400078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x00f62c0048247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007864825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000b947ULL, 0x000fea000383ffffULL, 0x0000002002007824ULL, 0x000fe400078e00ffULL,
0x00000001ffc07424ULL, 0x000fc600078e00ffULL, 0xffffff8000007812ULL, 0x000fc800078ec0ffULL,
0x0000010055257810ULL, 0x000fca0007ffe000ULL, 0x0000000154257824ULL, 0x000fca00078e0225ULL,
0x00f0000025277984ULL, 0x000ea80000000800ULL, 0x00f2000025007984ULL, 0x0007220000000800ULL,
0x000000402700720bULL, 0x004fda0003f7d000ULL, 0x0000000000247806ULL, 0x000fc800018e0100ULL,
0x0000ffff24297812ULL, 0x000fda000786c0ffULL, 0x000003700000b947ULL, 0x000fea0003800000ULL,
0x000000402700720bULL, 0x018fe40003f74000ULL, 0x00000027402b7209ULL, 0x040fe40007810000ULL,
0x0000000239257810ULL, 0x000fe40007ffe0ffULL, 0x00000002ff2c7819ULL, 0x000fe2000001163bULL,
0x8000002b40247221ULL, 0x100fe20000010000ULL, 0x000000ffff407224ULL, 0x000fc600078e002bULL,
0x3fb8aa3b24267820ULL, 0x000fe40000410000ULL, 0x0000000000247806ULL, 0x000fe400018e0100ULL,
0x000000022500720cULL, 0x000fe20003f65270ULL, 0x00000026002d7308ULL, 0x000ea20000000800ULL,
0x0000ffff242a7812ULL, 0x000fc800078e3cffULL, 0x0000002a29ff7212ULL, 0x000fc8000788c0ffULL,
0x00000001ffc07807ULL, 0x000fc60002000000ULL, 0x000000800225b824ULL, 0x000fc800078e0255ULL,
0x00000001542ab824ULL, 0x000fe200078e0225ULL, 0x00001f2c2d247589ULL, 0x004ea200000e0000ULL,
0x8000002b27274221ULL, 0x000fe20000010000ULL, 0x0000002d42427220ULL, 0x000fe40000410000ULL,
0x00001f562d257589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b27274820ULL, 0x000fc60000410000ULL,
0x00f4002b2a00b388ULL, 0x0009e20000000800ULL, 0x0000002700474308ULL, 0x000e620000000800ULL,
0x0000002420207220ULL, 0x084fe20000410000ULL, 0x0000002421217220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x000000240c0c7220ULL, 0x080fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x0000002404047220ULL, 0x080fe20000410000ULL, 0x0000002405057220ULL, 0x000fe20000410000ULL,
0x0000002522227220ULL, 0x088fe20000410000ULL, 0x0000002523237220ULL, 0x080fe20000410000ULL,
0x000000251e1e7220ULL, 0x080fe20000410000ULL, 0x000000251f1f7220ULL, 0x080fe20000410000ULL,
0x000000251a1a7220ULL, 0x080fe20000410000ULL, 0x000000251b1b7220ULL, 0x080fe20000410000ULL,
0x0000002516167220ULL, 0x080fe20000410000ULL, 0x0000002517177220ULL, 0x080fe20000410000ULL,
0x0000002512127220ULL, 0x080fe20000410000ULL, 0x0000002513137220ULL, 0x080fe20000410000ULL,
0x000000250e0e7220ULL, 0x080fe20000410000ULL, 0x000000250f0f7220ULL, 0x080fe20000410000ULL,
0x000000250a0a7220ULL, 0x080fe20000410000ULL, 0x000000250b0b7220ULL, 0x080fe20000410000ULL,
0x0000002506067220ULL, 0x080fe20000410000ULL, 0x0000002507077220ULL, 0x000fe20000410000ULL,
0x0000000047004220ULL, 0x002fc80000410000ULL, 0x0000004200427221ULL, 0x018fe20000010000ULL,
0x000000f000002947ULL, 0x000fea0003800000ULL, 0x0000000861007824ULL, 0x000fe400078e0262ULL,
0x8000000028257824ULL, 0x000fc800078e00ffULL, 0x00f64c0000007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007844825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x8000000028257824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x00000406ff247984ULL, 0x000ea40008000800ULL, 0x8000000024ff7812ULL, 0x004fc40007844825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000100002007824ULL, 0x000fe200078e00ffULL, 0x00009910c0c07816ULL, 0x000fe200000000ffULL,
0x0000100046257824ULL, 0x000fc600078e00ffULL, 0xffffe00000007812ULL, 0x000fe400078ec0ffULL,
0x0000100025257812ULL, 0x000fc600078ec0ffULL, 0x0000100061007824ULL, 0x000fe200078e0200ULL,
0x0000b0003e297810ULL, 0x000fc80007ffe025ULL, 0x0000b00000007810ULL, 0x000fe20007ffe0ffULL,
0x000000105e247824ULL, 0x100fe400078e0229ULL, 0x0000001060297824ULL, 0x000fe400078e0229ULL,
0x000000105d2c7824ULL, 0x100fe400078e0200ULL, 0x000000002424783bULL, 0x000ea20000004200ULL,
0x000000105f307824ULL, 0x000fc600078e0200ULL, 0x000000002c2c783bULL, 0x000ee80000004200ULL,
0x000000003030783bULL, 0x000f280000004200ULL, 0x000000002928783bULL, 0x000e620000004200ULL,
0x00000024008e7306ULL, 0x004fe20000009400ULL, 0x00000018ffa17819ULL, 0x000fe20000011424ULL,
0x0000010024a77824ULL, 0x040fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe20000011425ULL,
0x0001000024ae7824ULL, 0x000fe200078e00ffULL, 0x00000018ffd47819ULL, 0x008fe2000001142cULL,
0x000100002ce07824ULL, 0x000fe200078e00ffULL, 0x00000018ffc17819ULL, 0x000fe2000001142dULL,
0x0000002400937306ULL, 0x000fe20000005400ULL, 0x000001002ddc7824ULL, 0x040fe200078e00ffULL,
0x00000018ffcb7819ULL, 0x000fe2000001142eULL, 0x000100002dda7824ULL, 0x000fe200078e00ffULL,
0x00000018ffe07819ULL, 0x000fe200000114e0ULL, 0x000001002ed77824ULL, 0x040fe200078e00ffULL,
0x00000018ffdc7819ULL, 0x000fe200000114dcULL, 0x000001002fd07824ULL, 0x000fe200078e00ffULL,
0x0000002400787306ULL, 0x0005e2000000d400ULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x000100002ed27824ULL, 0x000fe200078e00ffULL, 0x00000018ffd77819ULL, 0x000fe200000114d7ULL,
0x0000010025967824ULL, 0x040fe200078e00ffULL, 0x00000018ffd07819ULL, 0x000fe200000114d0ULL,
0x0001000025b07824ULL, 0x000fe200078e00ffULL, 0x00000018ffc57819ULL, 0x000fe2000001142fULL,
0x0000002c00e37306ULL, 0x000fe20000009400ULL, 0x000001002c247824ULL, 0x004fe200078e00ffULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x0000010026927824ULL, 0x000fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x010fe20000011430ULL, 0x0000010027887824ULL, 0x000fe200078e00ffULL,
0x00000018ffe77819ULL, 0x000fc40000011424ULL, 0x0000002c00e47306ULL, 0x000ea20000005400ULL,
0x00000018ffa97819ULL, 0x000fe40000011433ULL, 0x00000018ffb77819ULL, 0x000fe40000011431ULL,
0x00000018ff9a7819ULL, 0x000fe40000011432ULL, 0x00000018ff967819ULL, 0x000fe20000011496ULL,
0x000000e700247306ULL, 0x000fe20000209400ULL, 0x00000018ff5c7819ULL, 0x002fe40000011428ULL,
0x00000018ff5f7819ULL, 0x000fc40000011429ULL, 0x00000018ff707819ULL, 0x000fe4000001142aULL,
0x00000018ff747819ULL, 0x000fe2000001142bULL, 0x000000e700e97306ULL, 0x000e620000205400ULL,
0x000000e4e300720bULL, 0x004fe40003f9d000ULL, 0x00000018ff837819ULL, 0x000fe40000011426ULL,
0x00000018ff807819ULL, 0x000fe40000011427ULL, 0x00000018ffa77819ULL, 0x000fe200000114a7ULL,
0x000000d400d97306ULL, 0x000fe20000209400ULL, 0x00000018ffb07819ULL, 0x000fc400000114b0ULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x00000018ffae7819ULL, 0x000fe400000114aeULL,
0x00000018ff927819ULL, 0x000fe20000011492ULL, 0x000000d400d87306ULL, 0x000ea20000205400ULL,
0x000000e92400720bULL, 0x002fe20003f5d000ULL, 0x0000010031247824ULL, 0x000fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x000000e000eb7306ULL, 0x000ff00000209400ULL,
0x000000e000ec7306ULL, 0x000e620000205400ULL, 0x000000d8d900720bULL, 0x004fe20003fdd000ULL,
0x0001000030d87824ULL, 0x000fc400078e00ffULL, 0x0001000033d97824ULL, 0x000fc600078e00ffULL,
0x00000018ffd87819ULL, 0x000fe200000114d8ULL, 0x0000002c00947306ULL, 0x0004e2000000d400ULL,
0x00000018ffd97819ULL, 0x000fce00000114d9ULL, 0x000000c100c27306ULL, 0x000fe20000209400ULL,
0x000000eceb00720bULL, 0x002fe20003f7d000ULL, 0x00000100302c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x000000c100d57306ULL, 0x0002a20000205400ULL,
0x0000000194944812ULL, 0x008fce00078efcffULL, 0x0000002d00de7306ULL, 0x000fe20000009400ULL,
0x000000c100c17245ULL, 0x002fce000020d400ULL, 0x0000002d00dd7306ULL, 0x000e620000005400ULL,
0x000000d5c200720bULL, 0x004fe20003f9d000ULL, 0x0000010033d57824ULL, 0x000fe200078e00ffULL,
0x000000dc00c27245ULL, 0x000fc8000020d400ULL, 0x00000018ffd57819ULL, 0x000fe200000114d5ULL,
0x000000dc00ed7306ULL, 0x000fec0000209400ULL, 0x00000001c1c14812ULL, 0x000fe400078efcffULL,
0x000000dc00ee7306ULL, 0x0004e20000205400ULL, 0x000000ddde00720bULL, 0x002fce0003fbd000ULL,
0x000000da00e17306ULL, 0x000fe20000209400ULL, 0x0000010028dc7824ULL, 0x004fce00078e00ffULL,
0x000000da00e27306ULL, 0x000ff00000205400ULL, 0x000000d700e87306ULL, 0x000ff00000209400ULL,
0x000000d700e57306ULL, 0x000ff00000205400ULL, 0x0000002d00917306ULL, 0x0002b0000000d400ULL,
0x000000d000d67306ULL, 0x000fe20000209400ULL, 0x000000e7002d7245ULL, 0x002fc8000020d400ULL,
0x000000012d2d2812ULL, 0x000fe400078efcffULL, 0x000000eeed00720bULL, 0x008fe20003f5d000ULL,
0x000000d000db7306ULL, 0x000e620000205400ULL, 0x0000000191915812ULL, 0x004fce00078efcffULL,
0x0000002e00ce7306ULL, 0x000fe80000009400ULL, 0x00000001c2c22812ULL, 0x000fe400078efcffULL,
0x000000ffc000720cULL, 0x000fe40003f45270ULL, 0x0000002e00d17306ULL, 0x000ea20000005400ULL,
0x000000dbd600720bULL, 0x002fe20003f9d000ULL, 0x0001000026db7824ULL, 0x000fe200078e00ffULL,
0x000000d700c07245ULL, 0x000fca000020d400ULL, 0x0000002500aa7306ULL, 0x000ff00000009400ULL,
0x00000025009d7306ULL, 0x000fe20000005400ULL, 0x000000d1ce00720bULL, 0x004fce0003fbd000ULL,
0x0000002500797306ULL, 0x0003f0000000d400ULL, 0x0000002e008b7306ULL, 0x0004e2000000d400ULL,
0x000100002f257824ULL, 0x002fca00078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000002f00c87306ULL, 0x000fe20000009400ULL, 0x000000e0002e7245ULL, 0x004fc8000020d400ULL,
0x000000012e2e3812ULL, 0x000fe400078efcffULL, 0x000000e2e100720bULL, 0x000fe20003f7d000ULL,
0x0000002f00cf7306ULL, 0x000fe20000005400ULL, 0x000000018b8b5812ULL, 0x008fce00078efcffULL,
0x0000002f00897306ULL, 0x0003f0000000d400ULL, 0x000000d200df7306ULL, 0x000fe20000209400ULL,
0x000000d4002f7245ULL, 0x002fc8000020d400ULL, 0x000000012f2f6812ULL, 0x000fe400078efcffULL,
0x000000e5e800720bULL, 0x000fe20003fdd000ULL, 0x000000d200e67306ULL, 0x000e620000205400ULL,
0x0000002e2f2e723eULL, 0x000fce00000010ffULL, 0x0000003000c67306ULL, 0x000fe80000009400ULL,
0x00000001c0c06812ULL, 0x000fc800078efcffULL, 0x0000003000c77306ULL, 0x000fe20000005400ULL,
0x000000e6df00720bULL, 0x002fce0003fdd000ULL, 0x0000003000857306ULL, 0x0003f0000000d400ULL,
0x000000c500c97306ULL, 0x000fe20000209400ULL, 0x0001000031307824ULL, 0x002fca00078e00ffULL,
0x00000018ffce7819ULL, 0x000fe40000011430ULL, 0x000000c500ca7306ULL, 0x000e620000205400ULL,
0x000000da00307245ULL, 0x000fc8000020d400ULL, 0x0000000130303812ULL, 0x000fe400078efcffULL,
0x000000cfc800720bULL, 0x000fe20003f7d000ULL, 0x000000cb00cc7306ULL, 0x000fe20000209400ULL,
0x000000d000c87245ULL, 0x000fe2000020d400ULL, 0x0000010032cf7824ULL, 0x000fe200078e00ffULL,
0x00000030c12f723eULL, 0x000fe400000010ffULL, 0x00000001c8c84812ULL, 0x000fe400078efcffULL,
0x00000018ffcf7819ULL, 0x000fe200000114cfULL, 0x000000cb00cd7306ULL, 0x0004e20000205400ULL,
0x000000cac900720bULL, 0x002fe20003f9d000ULL, 0x0001000029c97824ULL, 0x000fe200078e00ffULL,
0x000000cb00ca7245ULL, 0x000fc4000020d400ULL, 0x0000000189893812ULL, 0x000fe400078efcffULL,
0x0000008300307245ULL, 0x000fe2000020d400ULL, 0x0000002c00e37306ULL, 0x000fe20000209400ULL,
0x0001000028cb7824ULL, 0x004fe200078e00ffULL, 0x00000018ffc97819ULL, 0x000fc800000114c9ULL,
0x00000018ffcb7819ULL, 0x000fe400000114cbULL, 0x0000002c00ea7306ULL, 0x0003e20000205400ULL,
0x000000cdcc00720bULL, 0x008fe20003fbd000ULL, 0x0001000027cd7824ULL, 0x000fe200078e00ffULL,
0x000000c500cc7245ULL, 0x000fe4000020d400ULL, 0x0000002400c57245ULL, 0x000fe4000020d400ULL,
0x00000001cccc4812ULL, 0x000fe200078efcffULL, 0x0000002400dd7306ULL, 0x000fec0000209400ULL,
0x00000001caca5812ULL, 0x000fc400078efcffULL, 0x0000002400de7306ULL, 0x000ea20000205400ULL,
0x000000c7c600720bULL, 0x000fe40003fbd000ULL, 0x0000002c00c67245ULL, 0x000fe2000020d400ULL,
0x00000100292c7824ULL, 0x002fe200078e00ffULL, 0x0000002500c77245ULL, 0x000fc6000020d400ULL,
0x0000002500d37306ULL, 0x000fec0000209400ULL, 0x0000000185855812ULL, 0x000fe400078efcffULL,
0x0000002500e47306ULL, 0x000e620000205400ULL, 0x000000dedd00720bULL, 0x004fce0003f9d000ULL,
0x0000003300b87306ULL, 0x000fec0000009400ULL, 0x00000001c5c54812ULL, 0x000fe400078efcffULL,
0x0000003300b57306ULL, 0x000fe20000005400ULL, 0x000000e4d300720bULL, 0x002fce0003f7d000ULL,
0x00000033007d7306ULL, 0x0003ec000000d400ULL, 0x00000001c7c73812ULL, 0x000fe400078efcffULL,
0x0000003100c47306ULL, 0x000fe20000009400ULL, 0x000000d200337245ULL, 0x002fc8000020d400ULL,
0x0000000133336812ULL, 0x000fe400078efcffULL, 0x000000eae300720bULL, 0x000fe20003fdd000ULL,
0x0000003100c37306ULL, 0x000e700000005400ULL, 0x0000003100847306ULL, 0x000ea8000000d400ULL,
0x00000001c6c66812ULL, 0x000fc800078efcffULL, 0x000000d800d47306ULL, 0x000fe20000209400ULL,
0x000000c3c400720bULL, 0x002fe20003f7d000ULL, 0x000001002ac47824ULL, 0x000fe400078e00ffULL,
0x000001002bc37824ULL, 0x000fc600078e00ffULL, 0x00000018ffc47819ULL, 0x000fe200000114c4ULL,
0x000000d800317306ULL, 0x000e620000205400ULL, 0x00000018ffc37819ULL, 0x000fca00000114c3ULL,
0x0000000184843812ULL, 0x004fe400078efcffULL, 0x000000ce00d17306ULL, 0x000ff00000209400ULL,
0x000000ce00d67306ULL, 0x000ea20000205400ULL, 0x00000031d400720bULL, 0x002fe20003fdd000ULL,
0x000100002b317824ULL, 0x000fcc00078e00ffULL, 0x000000bd00bf7306ULL, 0x000ff00000209400ULL,
0x000000bd00be7306ULL, 0x0002e20000205400ULL, 0x000000d6d100720bULL, 0x004fce0003f9d000ULL,
0x0000003200ba7306ULL, 0x000fe20000009400ULL, 0x000000bd00bd7245ULL, 0x002fce000020d400ULL,
0x0000003200b97306ULL, 0x000e620000005400ULL, 0x000000bebf00720bULL, 0x008fe40003fbd000ULL,
0x000000d800be7245ULL, 0x000fc8000020d400ULL, 0x00000001bebe6812ULL, 0x000fe200078efcffULL,
0x000000b700bc7306ULL, 0x000fec0000209400ULL, 0x00000001bdbd5812ULL, 0x000fe400078efcffULL,
0x000000b700bb7306ULL, 0x0004e20000205400ULL, 0x000000b9ba00720bULL, 0x002fc40003fdd000ULL,
0x000000ce00b97245ULL, 0x000fe4000020d400ULL, 0x000000b700ba7245ULL, 0x000fe4000020d400ULL,
0x00000001b9b94812ULL, 0x000fe200078efcffULL, 0x000000cf00d07306ULL, 0x000fe20000209400ULL,
0x000000b5b800720bULL, 0x000fe40003f9d000ULL, 0x000000cf00b57245ULL, 0x000fe4000020d400ULL,
0x00000047ffb8723eULL, 0x000fc400000010ffULL, 0x00000018ffb77819ULL, 0x004fe200000114dbULL,
0x000000cf00d37306ULL, 0x0002a20000205400ULL, 0x000000bbbc00720bULL, 0x008fca0003f7d000ULL,
0x000000017d7d4812ULL, 0x000fe400078efcffULL, 0x00000032007e7306ULL, 0x000722000000d400ULL,
0x00000002ffcf7819ULL, 0x002fca000001163bULL, 0x00000001baba3812ULL, 0x000fe400078efcffULL,
0x000000a9009b7306ULL, 0x000fe20000209400ULL, 0x0001000032327824ULL, 0x008fe200078e00ffULL,
0x000000d3d000720bULL, 0x004fe40003fbd000ULL, 0x00005410b8d07816ULL, 0x000fe400000000b8ULL,
0x00000018ffd27819ULL, 0x000fe20000011432ULL, 0x000100002a327824ULL, 0x000fe200078e00ffULL,
0x000000a9009e7306ULL, 0x0002a20000205400ULL, 0x000000017e7e6812ULL, 0x010fc400078efcffULL,
0x000000d500b87245ULL, 0x000fe4000020d400ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x00000001b5b55812ULL, 0x000fe200078efcffULL, 0x000000d500d77306ULL, 0x000fe20000209400ULL,
0x000000a900a97245ULL, 0x002fce000020d400ULL, 0x000000d500da7306ULL, 0x000e620000205400ULL,
0x0000009e9b00720bULL, 0x004fce0003f9d000ULL, 0x000000d200d47306ULL, 0x000fec0000209400ULL,
0x00000001a9a94812ULL, 0x000fe400078efcffULL, 0x000000d200bf7306ULL, 0x000ea20000205400ULL,
0x000000dad700720bULL, 0x002fce0003f7d000ULL, 0x0000009a00ab7306ULL, 0x000fec0000209400ULL,
0x00000001b8b83812ULL, 0x000fe400078efcffULL, 0x0000009a00ac7306ULL, 0x0002e20000205400ULL,
0x000000bfd400720bULL, 0x004fe40003fbd000ULL, 0x00001fcfd0bf7589ULL, 0x000fe200000e0000ULL,
0x0000007db87d723eULL, 0x000fc800000010ffULL, 0x0000009600a87306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x002fce000020d400ULL, 0x0000009600ad7306ULL, 0x0002a20000205400ULL,
0x000000acab00720bULL, 0x008fe40003fdd000ULL, 0x000000d200ab7245ULL, 0x000fe4000020d400ULL,
0x00000018ffac7819ULL, 0x000fe400000114cdULL, 0x00000001abab5812ULL, 0x000fe200078efcffULL,
0x00000028008f7306ULL, 0x000fe20000009400ULL, 0x000000938e00720bULL, 0x000fe40003fbd000ULL,
0x0000009600967245ULL, 0x002fc4000020d400ULL, 0x000000d9008e7245ULL, 0x000fe4000020d400ULL,
0x000000019a9a6812ULL, 0x000fe200078efcffULL, 0x00000028008c7306ULL, 0x000fe20000005400ULL,
0x000000ada800720bULL, 0x004fe40003f9d000ULL, 0x0000009daa00720bULL, 0x000fe40003fdd000ULL,
0x00000018ff937819ULL, 0x000fe400000114dcULL, 0x0000000178785812ULL, 0x000fe200078efcffULL,
0x0000002800577306ULL, 0x000fe2000000d400ULL, 0x000000ab9a9a723eULL, 0x000fca00000010ffULL,
0x0000000196964812ULL, 0x000fe400078efcffULL, 0x00000029008d7306ULL, 0x000fe20000009400ULL,
0x0000000179796812ULL, 0x000fc800078efcffULL, 0x000000799679723eULL, 0x000fc600000010ffULL,
0x00000029008a7306ULL, 0x000ff00000005400ULL, 0x00000029005b7306ULL, 0x000ff0000000d400ULL,
0x0000002a007f7306ULL, 0x000ff00000009400ULL, 0x0000002a007c7306ULL, 0x000ff00000005400ULL,
0x0000002a00007306ULL, 0x000ff0000000d400ULL, 0x0000002b007a7306ULL, 0x000ff00000009400ULL,
0x0000002b007b7306ULL, 0x000ff00000005400ULL, 0x0000002b005a7306ULL, 0x0003f0000000d400ULL,
0x000000d900bc7306ULL, 0x000fe20000209400ULL, 0x00a000006a28783bULL, 0x002e6e0000000200ULL,
0x000000d900d17306ULL, 0x000eb00000205400ULL, 0x0000002600a47306ULL, 0x000ff00000009400ULL,
0x0000002600997306ULL, 0x000ee20000005400ULL, 0x000000d1bc00720bULL, 0x004fc40003f7d000ULL,
0x00001f56d0bc7589ULL, 0x000eaa00000e0000ULL, 0x0000002600597306ULL, 0x000f2c000000d400ULL,
0x000000018e8e3812ULL, 0x000fc400078efcffULL, 0x0000002700a27306ULL, 0x000fe20000009400ULL,
0x00000099a400720bULL, 0x008fe20003fbd000ULL, 0x000000bf2828a231ULL, 0x082fe400003400ffULL,
0x000000bf2a2aa231ULL, 0x000fc800003400ffULL, 0x0000002700977306ULL, 0x000fe20000005400ULL,
0x000000bc2929a231ULL, 0x084fe400003400ffULL, 0x000000bc2b2ba231ULL, 0x000fc600003400ffULL,
0x0000000159595812ULL, 0x010fe400078efcffULL, 0x0000002700587306ULL, 0x0003e4000000d400ULL,
0x0000002e281c723cULL, 0x000fec000004181cULL, 0x0000009000a37306ULL, 0x000fe20000209400ULL,
0x00a000006b24783bULL, 0x002e620000000200ULL, 0x00000033ca2e723eULL, 0x000fc400000010ffULL,
0x000000c7cc2f723eULL, 0x000fc800000010ffULL, 0x0000009000987306ULL, 0x000ea60000205400ULL,
0x0000002e2814723cULL, 0x000fea0000041814ULL, 0x000000a7009c7306ULL, 0x000fe40000209400ULL,
0x000000bebd2e723eULL, 0x000fc400000010ffULL, 0x000000b9ba2f723eULL, 0x000fc800000010ffULL,
0x000000a700957306ULL, 0x0007220000205400ULL, 0x00000098a300720bULL, 0x004fe40003f9d000ULL,
0x0000002e280c723cULL, 0x000fea000004180cULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x000000a700a77245ULL, 0x008fce000020d400ULL, 0x000000b000b47306ULL, 0x0004e20000205400ULL,
0x000000959c00720bULL, 0x010fe20003f7d000ULL, 0x000000bf2424a231ULL, 0x082fe200003400ffULL,
0x00000018ff957819ULL, 0x000fe2000001142cULL, 0x000000bf2626a231ULL, 0x000fe200003400ffULL,
0x000000942d2c723eULL, 0x000fe200000010ffULL, 0x000000bc2525a231ULL, 0x080fe200003400ffULL,
0x00000091c22d723eULL, 0x000fe200000010ffULL, 0x00000088009f7306ULL, 0x000fe20000209400ULL,
0x0000009000917245ULL, 0x000fe2000020d400ULL, 0x000000bc2727a231ULL, 0x000fe200003400ffULL,
0x000000b000b07245ULL, 0x004fc4000020d400ULL, 0x0000000191914812ULL, 0x000fe200078efcffULL,
0x0000002c2820723cULL, 0x000fe20000041820ULL, 0x00000001a7a73812ULL, 0x000fe200078efcffULL,
0x0000008800a07306ULL, 0x000e620000205400ULL, 0x000000b4b100720bULL, 0x008fe40003fdd000ULL,
0x00000095002e7245ULL, 0x000fe4000020d400ULL, 0x00000089c82d723eULL, 0x000fe400000010ffULL,
0x0000008800897245ULL, 0x000fe2000020d400ULL, 0x0000008300867306ULL, 0x000fe20000209400ULL,
0x0000008bc02c723eULL, 0x000fc400000010ffULL, 0x00000078a778723eULL, 0x000fc600000010ffULL,
0x00000001b0b06812ULL, 0x000fe400078efcffULL, 0x0000008300877306ULL, 0x000ea20000205400ULL,
0x000000a09f00720bULL, 0x002fe20003f9d000ULL, 0x0000002c2818723cULL, 0x000fe20000041818ULL,
0x0000008c8f00720bULL, 0x000fe40003fdd000ULL, 0x000000b09191723eULL, 0x000fc600000010ffULL,
0x000000ae00af7306ULL, 0x000fe20000209400ULL, 0x00000085c62c723eULL, 0x000fe200000010ffULL,
0x000000782420723cULL, 0x000fe20000041820ULL, 0x00000084c52d723eULL, 0x000fc600000010ffULL,
0x0000000189894812ULL, 0x000fe400078efcffULL, 0x000000ae00b27306ULL, 0x0002e20000205400ULL,
0x000000878600720bULL, 0x004fe20003fbd000ULL, 0x0000002c2810723cULL, 0x000fe20000041810ULL,
0x0000000157576812ULL, 0x000fca00078efcffULL, 0x000000a100a57306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x002fe4000020d400ULL, 0x00000093002c7245ULL, 0x000fe4000020d400ULL,
0x00000080002d7245ULL, 0x000fe4000020d400ULL, 0x0000000130305812ULL, 0x000fe200078efcffULL,
0x000000a100a67306ULL, 0x0002a20000205400ULL, 0x000000b2af00720bULL, 0x008fce0003f5d000ULL,
0x000000b700bb7306ULL, 0x000fe20000209400ULL, 0x000000a100a17245ULL, 0x002fca000020d400ULL,
0x00000001aeae2812ULL, 0x000fe400078efcffULL, 0x000000b700ce7306ULL, 0x0002e20000205400ULL,
0x000000a6a500720bULL, 0x004fe40003f7d000ULL, 0x00000097a200720bULL, 0x000fca0003f5d000ULL,
0x00000093009c7306ULL, 0x000fe20000209400ULL, 0x000000b700b77245ULL, 0x002fca000020d400ULL,
0x00000001a1a13812ULL, 0x000fe400078efcffULL, 0x00000093009d7306ULL, 0x0002a20000205400ULL,
0x000000cebb00720bULL, 0x008fe40003f9d000ULL, 0x0000000158582812ULL, 0x000fca00078efcffULL,
0x0000009200b37306ULL, 0x000fe20000209400ULL, 0x000000588993723eULL, 0x002fca00000010ffULL,
0x00000001b7b74812ULL, 0x000fe400078efcffULL, 0x0000009200b67306ULL, 0x0002e20000205400ULL,
0x0000009d9c00720bULL, 0x004fe40003fbd000ULL, 0x000000b73030723eULL, 0x000fca00000010ffULL,
0x0000008000817306ULL, 0x000fe20000209400ULL, 0x0000009200927245ULL, 0x002fca000020d400ULL,
0x000000012c2c5812ULL, 0x000fe400078efcffULL, 0x0000008000827306ULL, 0x000e620000205400ULL,
0x000000b6b300720bULL, 0x008fe40003f7d000ULL, 0x000000572c2c723eULL, 0x000fca00000010ffULL,
0x000000ac009b7306ULL, 0x000fec0000209400ULL, 0x0000000192923812ULL, 0x000fe400078efcffULL,
0x000000ac009e7306ULL, 0x0004e20000205400ULL, 0x000000828100720bULL, 0x002fe40003f9d000ULL,
0x0000008a8d00720bULL, 0x000fc40003f7d000ULL, 0x000000599292723eULL, 0x000fc600000010ffULL,
0x0000009500997306ULL, 0x000fe20000209400ULL, 0x000000ac00ac7245ULL, 0x004fc6000020d400ULL,
0x000000922418723cULL, 0x000fe40000041818ULL, 0x000000012d2d4812ULL, 0x000fe400078efcffULL,
0x0000009500987306ULL, 0x000e620000205400ULL, 0x0000009e9b00720bULL, 0x008fe40003f5d000ULL,
0x0000007b7a00720bULL, 0x000fe40003f9d000ULL, 0x0000008ea99b723eULL, 0x000fe400000010ffULL,
0x000000015b5b3812ULL, 0x000fe200078efcffULL, 0x000000cb00907306ULL, 0x000fe80000209400ULL,
0x0000009a2804723cULL, 0x000fe40000041804ULL, 0x00000001acac2812ULL, 0x000fc400078efcffULL,
0x000000cb008f7306ULL, 0x0004e20000205400ULL, 0x000000989900720bULL, 0x002fe40003fbd000ULL,
0x0000007c7f00720bULL, 0x000fe40003f5d000ULL, 0x0000007eb57c723eULL, 0x000fe400000010ffULL,
0x000000015a5a4812ULL, 0x000fe200078efcffULL, 0x0000005c005d7306ULL, 0x000fe20000209400ULL,
0x000000cb00cb7245ULL, 0x004fc6000020d400ULL, 0x0000007c2808723cULL, 0x000fe40000041808ULL,
0x000000012e2e5812ULL, 0x000fe400078efcffULL, 0x0000005c005e7306ULL, 0x0002a20000205400ULL,
0x0000008f9000720bULL, 0x008fe40003fdd000ULL, 0x0000005f00287245ULL, 0x000fe4000020d400ULL,
0x000000c400297245ULL, 0x000fe4000020d400ULL, 0x0000000100002812ULL, 0x000fe200078efcffULL,
0x0000005f00607306ULL, 0x000fe20000209400ULL, 0x0000005c005c7245ULL, 0x002fc4000020d400ULL,
0x000000aea190723eULL, 0x000fc600000010ffULL, 0x00000001cbcb6812ULL, 0x000fe400078efcffULL,
0x0000005f006f7306ULL, 0x000e620000205400ULL, 0x0000005e5d00720bULL, 0x004fe20003fbd000ULL,
0x00000090241c723cULL, 0x000fe2000004181cULL, 0x000000c9005d7245ULL, 0x000fca000020d400ULL,
0x000000c900887306ULL, 0x000fec0000209400ULL, 0x000000015c5c5812ULL, 0x000fe400078efcffULL,
0x000000c900337306ULL, 0x000ea20000205400ULL, 0x0000006f6000720bULL, 0x002fe40003fdd000ULL,
0x000000cb5c5c723eULL, 0x000fca00000010ffULL, 0x000000c400837306ULL, 0x000fec0000209400ULL,
0x0000000128286812ULL, 0x000fe400078efcffULL, 0x000000c400827306ULL, 0x000e620000205400ULL,
0x000000338800720bULL, 0x004fe40003f7d000ULL, 0x00000018ff337819ULL, 0x000fc40000011431ULL,
0x000000ac2d31723eULL, 0x000fe400000010ffULL, 0x0000005b2e2d723eULL, 0x000fe200000010ffULL,
0x000000c3002f7306ULL, 0x000fe80000209400ULL, 0x000000302414723cULL, 0x000fe40000041814ULL,
0x000000015d5d3812ULL, 0x000fe400078efcffULL, 0x000000c3007a7306ULL, 0x0004e20000205400ULL,
0x000000828300720bULL, 0x002fc40003fbd000ULL, 0x0000005d285d723eULL, 0x000fe200000010ffULL,
0x0000002c2410723cULL, 0x000fe80000041810ULL, 0x0000007000717306ULL, 0x000fe20000209400ULL,
0x000000c300c37245ULL, 0x004fc6000020d400ULL, 0x0000005c240c723cULL, 0x000fe4000004180cULL,
0x0000000129295812ULL, 0x000fe400078efcffULL, 0x0000007000727306ULL, 0x000e620000205400ULL,
0x0000007a2f00720bULL, 0x008fe40003fdd000ULL, 0x000000002928723eULL, 0x000fe400000010ffULL,
0x0000f63039007811ULL, 0x000fc600078e20ffULL, 0x0000007400757306ULL, 0x000fec0000209400ULL,
0x00000001c3c36812ULL, 0x000fe400078efcffULL, 0x0000007400767306ULL, 0x0004e20000205400ULL,
0x000000727100720bULL, 0x002fe40003f7d000ULL, 0x0000005ac329723eULL, 0x000fca00000010ffULL,
0x00000032002a7306ULL, 0x000fe20000209400ULL, 0x0000007400747245ULL, 0x004fe2000020d400ULL,
0x000000282408723cULL, 0x000fec0000041808ULL, 0x00000032002b7306ULL, 0x0002a20000205400ULL,
0x000000767500720bULL, 0x008fce0003fbd000ULL, 0x0000003300587306ULL, 0x000fe20000209400ULL,
0x0000003200327245ULL, 0x002fca000020d400ULL, 0x0000000174745812ULL, 0x000fe400078efcffULL,
0x0000003300597306ULL, 0x0002e20000205400ULL, 0x0000002b2a00720bULL, 0x004fe40003f5d000ULL,
0x00000070002b7245ULL, 0x000fc8000020d400ULL, 0x000000012b2b3812ULL, 0x000fe400078efcffULL,
0x0000003300337245ULL, 0x002fca000020d400ULL, 0x0000000132322812ULL, 0x000fe400078efcffULL,
0x000000595800720bULL, 0x008fe40003fdd000ULL, 0x000000322b32723eULL, 0x000fd600000010ffULL,
0x0000000133336812ULL, 0x000fc800078efcffULL, 0x000000337433723eULL, 0x000fce00000010ffULL,
0x000000322404723cULL, 0x000fe20000041804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200043ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004039247824ULL, 0x000fe200078e0266ULL,
0x000000ff6eff7812ULL, 0x000fe2000784c0ffULL, 0x0000000000ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ff77ff7812ULL, 0x000fe4000786c0ffULL, 0x000000c024247810ULL, 0x000fe40007ffe0ffULL,
0x00000001ff2c7807ULL, 0x000fe40001000000ULL, 0x000000032400720cULL, 0x000fc40003f46070ULL,
0x00000001ff707807ULL, 0x000fe40001800000ULL, 0x0000002c73717207ULL, 0x000fe40004000000ULL,
0x00000001466f7812ULL, 0x000fce00078e0cffULL, 0x00002a6000002947ULL, 0x000fea0003800000ULL,
0x0000240043007984ULL, 0x004ea20000000800ULL, 0x8000000065257824ULL, 0x000fca00078e00ffULL,
0x8000000000ff7812ULL, 0x004fe20007844825ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000002947ULL, 0x000fea0003800000ULL, 0x0000240043007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007844825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x8000000065657824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x0000240043247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007844865ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000016c6d7824ULL, 0x000fca00078e026dULL, 0x000000036d007812ULL, 0x000fc800078ec0ffULL,
0x000000030000780cULL, 0x000fe40003f45270ULL, 0x0000030034007a10ULL, 0x000fe40007ffe0ffULL,
0x00000001384a7807ULL, 0x000fc60005000000ULL, 0x0000010000267824ULL, 0x000fe400078e023dULL,
0x000000016d4a7824ULL, 0x000fc600078e024aULL, 0x000000203f247812ULL, 0x000fe400078ef826ULL,
0x000000354a00720cULL, 0x000fc60003f46070ULL, 0x000000413a287224ULL, 0x020fe200078e0224ULL,
0x0000002603277217ULL, 0x000fe20007800000ULL, 0xffffffffff3a7424ULL, 0x000fe200078e00ffULL,
0x0000000100007810ULL, 0x000fce0007ffe0ffULL, 0x000000014425a824ULL, 0x000fe400078e024aULL,
0x00000004ff2aa424ULL, 0x000fc800078e00ffULL, 0x000060002524a625ULL, 0x000fc800078e002aULL,
0x0000000127277824ULL, 0x000fe200078e0a26ULL, 0x00000008243aa981ULL, 0x000562000c1e1900ULL,
0x000000370000720cULL, 0x000fe20003f46070ULL, 0x00000080ff2e7424ULL, 0x000fe200078e00ffULL,
0x00000010362b7812ULL, 0x000fe200078ec0ffULL, 0x000000014d4d7824ULL, 0x100fe200078e0228ULL,
0x0000002027277807ULL, 0x000fe20001000000ULL, 0x0000000150267824ULL, 0x100fe200078e0228ULL,
0x00000003ff2f7819ULL, 0x000fe2000001163bULL, 0x0000000151297824ULL, 0x000fe200078e0228ULL,
0x000000272b007217ULL, 0x000fe20007800000ULL, 0x00005e004d247625ULL, 0x004fe200078e002eULL,
0x000000042f2d7810ULL, 0x000fc40007ffe0ffULL, 0x000000082f317810ULL, 0x000fe20007ffe0ffULL,
0x00005e0026267625ULL, 0x000fe200078e002eULL, 0x00000055242a7210ULL, 0x000fc60007f5e0ffULL,
0x0000000152527824ULL, 0x000fe200078e0228ULL, 0x0000005526267210ULL, 0x000fe20007f7e0ffULL,
0x0000000100007824ULL, 0x000fe400078e0a2bULL, 0x00005e0029287625ULL, 0x000fc800078e002eULL,
0x000000ffff2b7224ULL, 0x000fe200010e0625ULL, 0x0000005528287210ULL, 0x000fe20007f9e0ffULL,
0x00005e0052247625ULL, 0x000fe200078e002eULL, 0x000000002d00720cULL, 0x000fc60003f46070ULL,
0x000000ffff277224ULL, 0x000fe200018e0627ULL, 0x0000005524247210ULL, 0x000fe20007fbe0ffULL,
0x00001000612d7824ULL, 0x000fe200078e023eULL, 0x000000002f00720cULL, 0x0c0fe20003f66070ULL,
0x000000ffff297224ULL, 0x000fe200020e0629ULL, 0x0000000c2f2f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff257224ULL, 0x000fe200028e0625ULL, 0x000000003100720cULL, 0x080fe40003f86070ULL,
0x0000b0002d2d7810ULL, 0x000fe40007ffe0ffULL, 0x000000002f00720cULL, 0x000fc60003fa6070ULL,
0x000000104b4b7824ULL, 0x100fe400078e022dULL, 0x000000104c2f7824ULL, 0x100fe400078e022dULL,
0x000000104e317824ULL, 0x100fe200078e022dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a4b7faeULL, 0x0005e2000d901c48ULL, 0x000000104f2d7824ULL, 0x000fc600078e022dULL,
0x00000000262f7faeULL, 0x0005e8000d101c48ULL, 0x0000000028317faeULL, 0x0005e8000e101c48ULL,
0x00000000242d7faeULL, 0x0005e8000e901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000040067677984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f63c0048247984ULL, 0x004ea20000000800ULL, 0x0000002c73737207ULL, 0x000fe20004000000ULL,
0x8000000053257824ULL, 0x000fc600078e00ffULL, 0x0000ffff73287812ULL, 0x000fca00078ec0ffULL,
0x8000000028007824ULL, 0x000fca00078e00ffULL, 0x8000000067ff7812ULL, 0x008fe40007844800ULL,
0x8000000024ff7812ULL, 0x004fe20007864825ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000003947ULL, 0x000fea0003800000ULL, 0x8000000053537824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x00f63c0048247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007864853ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000b947ULL, 0x000fea000383ffffULL,
0x0000002002007824ULL, 0x000fe400078e00ffULL, 0x00000001ff6e7424ULL, 0x000fc600078e00ffULL,
0xffffff8000007812ULL, 0x000fc800078ec0ffULL, 0x0000018055257810ULL, 0x000fca0007ffe000ULL,
0x0000000154257824ULL, 0x000fca00078e0225ULL, 0x00f0000025277984ULL, 0x000ea80000000800ULL,
0x00f2000025007984ULL, 0x0007220000000800ULL, 0x000000402700720bULL, 0x004fda0003f7d000ULL,
0x0000000000247806ULL, 0x000fc800018e0100ULL, 0x0000ffff24297812ULL, 0x000fda000786c0ffULL,
0x000003700000b947ULL, 0x000fea0003800000ULL, 0x000000402700720bULL, 0x018fe40003f74000ULL,
0x00000027402b7209ULL, 0x040fe40007810000ULL, 0x0000000339257810ULL, 0x000fe40007ffe0ffULL,
0x00000002ff2e7819ULL, 0x000fe2000001163bULL, 0x8000002b40247221ULL, 0x100fe20000010000ULL,
0x000000ffff407224ULL, 0x000fc600078e002bULL, 0x3fb8aa3b24267820ULL, 0x000fe40000410000ULL,
0x0000000000247806ULL, 0x000fe400018e0100ULL, 0x000000022500720cULL, 0x000fe20003f65270ULL,
0x00000026002d7308ULL, 0x000ea20000000800ULL, 0x0000ffff242a7812ULL, 0x000fc800078e3cffULL,
0x0000002a29ff7212ULL, 0x000fc8000788c0ffULL, 0x00000001ff6e7807ULL, 0x000fc60002000000ULL,
0x000000800255b824ULL, 0x000fc800078e0255ULL, 0x000000015454b824ULL, 0x000fe200078e0255ULL,
0x00001f2e2d247589ULL, 0x004ea200000e0000ULL, 0x8000002b27274221ULL, 0x000fe20000010000ULL,
0x0000002d42427220ULL, 0x000fe40000410000ULL, 0x00001f562d257589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b27274820ULL, 0x000fc60000410000ULL, 0x00f4002b5400b388ULL, 0x0009e20000000800ULL,
0x0000002700474308ULL, 0x000e620000000800ULL, 0x0000002420207220ULL, 0x084fe20000410000ULL,
0x0000002421217220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002408087220ULL, 0x080fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x0000002404047220ULL, 0x080fe20000410000ULL,
0x0000002405057220ULL, 0x000fe20000410000ULL, 0x0000002522227220ULL, 0x088fe20000410000ULL,
0x0000002523237220ULL, 0x080fe20000410000ULL, 0x000000251e1e7220ULL, 0x080fe20000410000ULL,
0x000000251f1f7220ULL, 0x080fe20000410000ULL, 0x000000251a1a7220ULL, 0x080fe20000410000ULL,
0x000000251b1b7220ULL, 0x080fe20000410000ULL, 0x0000002516167220ULL, 0x080fe20000410000ULL,
0x0000002517177220ULL, 0x080fe20000410000ULL, 0x0000002512127220ULL, 0x080fe20000410000ULL,
0x0000002513137220ULL, 0x080fe20000410000ULL, 0x000000250e0e7220ULL, 0x080fe20000410000ULL,
0x000000250f0f7220ULL, 0x080fe20000410000ULL, 0x000000250a0a7220ULL, 0x080fe20000410000ULL,
0x000000250b0b7220ULL, 0x080fe20000410000ULL, 0x0000002506067220ULL, 0x080fe20000410000ULL,
0x0000002507077220ULL, 0x000fe20000410000ULL, 0x0000000047004220ULL, 0x002fc80000410000ULL,
0x0000004200427221ULL, 0x018fe20000010000ULL, 0x0000011000002947ULL, 0x000fea0003800000ULL,
0x0000000861617824ULL, 0x000fe400078e00ffULL, 0x8000000028257824ULL, 0x000fc600078e00ffULL,
0x0000000861617812ULL, 0x000fca00078e3cffULL, 0x0000000162617824ULL, 0x000fca00078e0261ULL,
0x00f64c0061007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007844825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000028257824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x00f64c0061247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007844825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000006824783bULL, 0x000ea20000004200ULL,
0x000099106e6e7816ULL, 0x000fc600000000ffULL, 0x000000006928783bULL, 0x000ee80000004200ULL,
0x000000006360783bULL, 0x000f280000004200ULL, 0x000000006464783bULL, 0x000e620000004200ULL,
0x0001000024d37824ULL, 0x044fe200078e00ffULL, 0x00000024009a7306ULL, 0x000fe20000009400ULL,
0x0000010024d17824ULL, 0x000fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe20000011424ULL,
0x0001000025c97824ULL, 0x040fe200078e00ffULL, 0x00000018ffd37819ULL, 0x000fe200000114d3ULL,
0x0000010026c07824ULL, 0x040fe200078e00ffULL, 0x00000018ffd17819ULL, 0x000fe200000114d1ULL,
0x0000010025d07824ULL, 0x000fe200078e00ffULL, 0x0000002400a37306ULL, 0x000ea20000005400ULL,
0x00000018ffb67819ULL, 0x000fe20000011425ULL, 0x0000010027b97824ULL, 0x040fe200078e00ffULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x0001000026bb7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc07819ULL, 0x000fe200000114c0ULL, 0x0001000027bc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd07819ULL, 0x000fe200000114d0ULL, 0x000000d300d87306ULL, 0x000fe20000209400ULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x0000010028b07824ULL, 0x008fe200078e00ffULL,
0x00000018ffa97819ULL, 0x000fe20000011426ULL, 0x0000010029ac7824ULL, 0x000fe200078e00ffULL,
0x00000018ffbb7819ULL, 0x000fe200000114bbULL, 0x000001002a907824ULL, 0x000fe200078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe200000114bcULL, 0x000000d300dd7306ULL, 0x0006620000205400ULL,
0x000000a39a00720bULL, 0x004fe20003fdd000ULL, 0x000001002b8f7824ULL, 0x040fe200078e00ffULL,
0x00000018ffa67819ULL, 0x000fe20000011427ULL, 0x000100002a927824ULL, 0x000fe200078e00ffULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x000100002b957824ULL, 0x000fe200078e00ffULL,
0x00000018ff997819ULL, 0x000fe20000011428ULL, 0x000000bd00cd7306ULL, 0x000fe20000209400ULL,
0x000000d300d37245ULL, 0x008fe2000020d400ULL, 0x0000010061de7824ULL, 0x050fe200078e00ffULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x0001000060dc7824ULL, 0x040fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe20000011490ULL, 0x0000010060da7824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011429ULL, 0x000000bd00ce7306ULL, 0x000ea20000205400ULL,
0x000000ddd800720bULL, 0x002fe20003fbd000ULL, 0x00010000629b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x0001000061df7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001142bULL, 0x00010000639d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe20000011492ULL, 0x000000d1009e7306ULL, 0x000fe20000209400ULL,
0x00000018ff877819ULL, 0x000fc4000001142aULL, 0x00000018ff787819ULL, 0x000fe40000011461ULL,
0x00000018ff957819ULL, 0x000fe40000011495ULL, 0x00000001d3d35812ULL, 0x000fe200078efcffULL,
0x000000d100db7306ULL, 0x0002e20000205400ULL, 0x000000cecd00720bULL, 0x004fe40003f5d000ULL,
0x00000018ffcd7819ULL, 0x000fe400000114deULL, 0x00000018ff697819ULL, 0x000fc40000011462ULL,
0x00000018ff5e7819ULL, 0x000fe20000011463ULL, 0x0000002500ca7306ULL, 0x000fe20000009400ULL,
0x000000d100d17245ULL, 0x002fe4000020d400ULL, 0x00000018ff887819ULL, 0x000fe40000011460ULL,
0x00000018ff9b7819ULL, 0x000fe4000001149bULL, 0x00000018ff007819ULL, 0x000fe20000011464ULL,
0x0000002500c77306ULL, 0x000e620000005400ULL, 0x000000db9e00720bULL, 0x008fe20003f7d000ULL,
0x00000100659e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9d7819ULL, 0x000fc4000001149dULL,
0x00000018ff557819ULL, 0x000fe40000011465ULL, 0x00000018ff9e7819ULL, 0x000fe2000001149eULL,
0x00000024007a7306ULL, 0x000ea2000000d400ULL, 0x00000018ff2f7819ULL, 0x000fe40000011466ULL,
0x00000018ff2e7819ULL, 0x000fc60000011467ULL, 0x00000001d1d13812ULL, 0x000fe400078efcffULL,
0x000000b600bf7306ULL, 0x000fe20000209400ULL, 0x000000c7ca00720bULL, 0x002fce0003f9d000ULL,
0x000000b600be7306ULL, 0x0002e20000205400ULL, 0x000000017a7a6812ULL, 0x004fc800078efcffULL,
0x0000007ad17a723eULL, 0x000fc600000010ffULL, 0x000000c900d77306ULL, 0x000fe20000209400ULL,
0x000000b600b67245ULL, 0x002fce000020d400ULL, 0x000000c900d47306ULL, 0x0002a20000205400ULL,
0x000000bebf00720bULL, 0x008fe40003fdd000ULL, 0x000000bd00be7245ULL, 0x000fe4000020d400ULL,
0x00000018ffbd7819ULL, 0x000fe400000114dcULL, 0x00000001bebe2812ULL, 0x000fe200078efcffULL,
0x000000c000d27306ULL, 0x000fe20000209400ULL, 0x000000c900c97245ULL, 0x002fe4000020d400ULL,
0x000000d3bebe723eULL, 0x000fc600000010ffULL, 0x00000001b6b66812ULL, 0x000fe400078efcffULL,
0x000000c000d57306ULL, 0x000e620000205400ULL, 0x000000d4d700720bULL, 0x004fce0003fbd000ULL,
0x000000d000d67306ULL, 0x000fec0000209400ULL, 0x00000001c9c95812ULL, 0x000fe400078efcffULL,
0x000000d000d97306ULL, 0x0004e20000205400ULL, 0x000000d5d200720bULL, 0x002fe40003f5d000ULL,
0x000000c9b6bf723eULL, 0x000fca00000010ffULL, 0x0000002500797306ULL, 0x000e62000000d400ULL,
0x000000d000d07245ULL, 0x004fce000020d400ULL, 0x000000b900c87306ULL, 0x000fe20000209400ULL,
0x000000d9d600720bULL, 0x008fce0003f7d000ULL, 0x000000b900cf7306ULL, 0x000ea20000205400ULL,
0x0000000179794812ULL, 0x002fca00078efcffULL, 0x00000001d0d03812ULL, 0x000fe400078efcffULL,
0x0000002700b57306ULL, 0x000ff00000009400ULL, 0x0000002700b47306ULL, 0x000e620000005400ULL,
0x000000cfc800720bULL, 0x004fce0003f9d000ULL, 0x000000a900af7306ULL, 0x000ff00000209400ULL,
0x000000a900ae7306ULL, 0x000ea20000205400ULL, 0x000000b4b500720bULL, 0x002fe40003fbd000ULL,
0x000000c000b57245ULL, 0x000fc8000020d400ULL, 0x00000001b5b52812ULL, 0x000fe200078efcffULL,
0x000000bb00cb7306ULL, 0x000ff00000209400ULL, 0x000000bb00cc7306ULL, 0x0002e20000205400ULL,
0x000000aeaf00720bULL, 0x004fc40003f5d000ULL, 0x000000b900ae7245ULL, 0x000fe4000020d400ULL,
0x00000018ffaf7819ULL, 0x000fe400000114dfULL, 0x00000001aeae4812ULL, 0x000fe200078efcffULL,
0x0000002600b87306ULL, 0x000fe20000009400ULL, 0x000000bb00bb7245ULL, 0x002fce000020d400ULL,
0x0000002600b77306ULL, 0x000e620000005400ULL, 0x000000cccb00720bULL, 0x008fce0003fdd000ULL,
0x000000bc00c47306ULL, 0x000fec0000209400ULL, 0x00000001bbbb6812ULL, 0x000fe400078efcffULL,
0x000000bc00c57306ULL, 0x0004e20000205400ULL, 0x000000b7b800720bULL, 0x002fce0003f7d000ULL,
0x0000002700757306ULL, 0x000322000000d400ULL, 0x000000bc00bc7245ULL, 0x004fce000020d400ULL,
0x000000a600ab7306ULL, 0x000fe20000209400ULL, 0x0001000029277824ULL, 0x002fe200078e00ffULL,
0x000000c5c400720bULL, 0x008fc80003f9d000ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x000000a600a87306ULL, 0x000e620000205400ULL, 0x0000000175755812ULL, 0x010fc800078efcffULL,
0x00000075ae75723eULL, 0x000fe400000010ffULL, 0x00000001bcbc4812ULL, 0x000fe200078efcffULL,
0x000000b000c17306ULL, 0x000ff00000209400ULL, 0x000000b000c27306ULL, 0x0004e20000205400ULL,
0x000000a8ab00720bULL, 0x002fc40003fbd000ULL, 0x000000a900a87245ULL, 0x000fe4000020d400ULL,
0x000000a600a97245ULL, 0x000fe4000020d400ULL, 0x00000001a8a82812ULL, 0x000fe200078efcffULL,
0x0000002600727306ULL, 0x000e62000000d400ULL, 0x000000b000b07245ULL, 0x004fe4000020d400ULL,
0x000000bba8a8723eULL, 0x000fc600000010ffULL, 0x00000001a9a95812ULL, 0x000fe400078efcffULL,
0x0000002800ad7306ULL, 0x000fe20000009400ULL, 0x000000c2c100720bULL, 0x008fe40003fdd000ULL,
0x000000bca9a9723eULL, 0x000fca00000010ffULL, 0x0000002800aa7306ULL, 0x000ea20000005400ULL,
0x0000000172723812ULL, 0x002fca00078efcffULL, 0x00000001b0b06812ULL, 0x000fe400078efcffULL,
0x00000028006d7306ULL, 0x0002f0000000d400ULL, 0x0000002900a47306ULL, 0x000fe20000009400ULL,
0x0001000028287824ULL, 0x002fe200078e00ffULL, 0x000000aaad00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002900a77306ULL, 0x000e6e0000005400ULL,
0x000000016d6d3812ULL, 0x008fe200078efcffULL, 0x000000ac00ba7306ULL, 0x000ff00000209400ULL,
0x000000ac00c37306ULL, 0x000ea20000205400ULL, 0x000000a7a400720bULL, 0x002fce0003f9d000ULL,
0x0000009900a27306ULL, 0x000ff00000209400ULL, 0x0000009900a57306ULL, 0x000e620000205400ULL,
0x000000c3ba00720bULL, 0x004fce0003f5d000ULL, 0x0000002800b17306ULL, 0x000ff00000209400ULL,
0x0000002800c67306ULL, 0x000ea20000205400ULL, 0x000000a5a200720bULL, 0x002fe40003fbd000ULL,
0x000000ac00a57245ULL, 0x000fc8000020d400ULL, 0x00000001a5a52812ULL, 0x000fe200078efcffULL,
0x0000002700b27306ULL, 0x000ff00000209400ULL, 0x0000002700b37306ULL, 0x000e620000205400ULL,
0x000000c6b100720bULL, 0x004fce0003fdd000ULL, 0x00000029006c7306ULL, 0x000eb0000000d400ULL,
0x0000002b009f7306ULL, 0x000fe20000009400ULL, 0x000000b3b200720bULL, 0x002fce0003f7d000ULL,
0x0000002b00a07306ULL, 0x000e620000005400ULL, 0x000000016c6c4812ULL, 0x004fc800078efcffULL,
0x0000006ca5a5723eULL, 0x000fc600000010ffULL, 0x0000002a00a17306ULL, 0x000ff00000009400ULL,
0x0000002a009c7306ULL, 0x000ea20000005400ULL, 0x000000a09f00720bULL, 0x002fe40003f9d000ULL,
0x00000099009f7245ULL, 0x000fc4000020d400ULL, 0x0000002700997245ULL, 0x000fe4000020d400ULL,
0x000000019f9f5812ULL, 0x000fe200078efcffULL, 0x0000009000247306ULL, 0x000fe20000209400ULL,
0x0000000199993812ULL, 0x000fce00078efcffULL, 0x0000009000257306ULL, 0x000e620000205400ULL,
0x0000009ca100720bULL, 0x004fe40003f5d000ULL, 0x00000028009c7245ULL, 0x000fc8000020d400ULL,
0x000000019c9c6812ULL, 0x000fe200078efcffULL, 0x0000008300967306ULL, 0x000ff00000209400ULL,
0x0000008300977306ULL, 0x000ea20000205400ULL, 0x000000252400720bULL, 0x002fce0003fbd000ULL,
0x0000008f00267306ULL, 0x000ff00000209400ULL, 0x0000008f00297306ULL, 0x000e620000205400ULL,
0x000000979600720bULL, 0x004fe40003fdd000ULL, 0x00000047ff96723eULL, 0x000fc400000010ffULL,
0x00000002ff977819ULL, 0x000fc6000001163bULL, 0x0000002a005c7306ULL, 0x0004f0000000d400ULL,
0x0000008e00847306ULL, 0x000fe20000209400ULL, 0x00000100632a7824ULL, 0x004fe200078e00ffULL,
0x000000292600720bULL, 0x002fc40003f7d000ULL, 0x00a800006a24783bULL, 0x0003e40000000200ULL,
0x00000018ffa17819ULL, 0x000fe4000001142aULL, 0x0000008e00857306ULL, 0x0005220000205400ULL,
0x000000015c5c2812ULL, 0x008fe400078efcffULL, 0x0000008f006a7245ULL, 0x002fca000020d400ULL,
0x0000002b005b7306ULL, 0x0002e2000000d400ULL, 0x0000008e008e7245ULL, 0x004fe4000020d400ULL,
0x000000016a6a3812ULL, 0x000fca00078efcffULL, 0x0000009200917306ULL, 0x000fe20000209400ULL,
0x00000100622b7824ULL, 0x002fe200078e00ffULL, 0x000000858400720bULL, 0x010fc80003f5d000ULL,
0x00000018ffa67819ULL, 0x000fe4000001142bULL, 0x0000009200947306ULL, 0x0002a20000205400ULL,
0x00a800006b28783bULL, 0x0009e20000000200ULL, 0x000000015b5b4812ULL, 0x008fc800078efcffULL,
0x0000005b6a5b723eULL, 0x000fe400000010ffULL, 0x00000087007f7306ULL, 0x000fe20000209400ULL,
0x00005410966b7816ULL, 0x010fe40000000096ULL, 0x0000008300967245ULL, 0x000fe4000020d400ULL,
0x0000009000837245ULL, 0x000fe2000020d400ULL, 0x00001f976b977589ULL, 0x000ee200000e0000ULL,
0x0000009200927245ULL, 0x002fe2000020d400ULL, 0x00000087007c7306ULL, 0x0003220000205400ULL,
0x0000000183835812ULL, 0x000fe200078efcffULL, 0x00001f566b567589ULL, 0x0002e200000e0000ULL,
0x000000949100720bULL, 0x004fc40003fbd000ULL, 0x0000000196966812ULL, 0x000fe400078efcffULL,
0x000000018e8e2812ULL, 0x000fe200078efcffULL, 0x000000cd00c77306ULL, 0x000fe20000209400ULL,
0x0000008700877245ULL, 0x002fe4000020d400ULL, 0x000000999699723eULL, 0x000fe200000010ffULL,
0x000000ffff6b7224ULL, 0x000fc800078e006eULL, 0x000000cd00ca7306ULL, 0x000e620000205400ULL,
0x0000007c7f00720bULL, 0x010fe40003fdd000ULL, 0x0000000192925812ULL, 0x000fe400078efcffULL,
0x000000ff6b00720cULL, 0x000fe40003f85270ULL, 0x000000a6006b7245ULL, 0x000fe2000020d400ULL,
0x00000060007d7306ULL, 0x000fec0000009400ULL, 0x0000000187876812ULL, 0x000fc400078efcffULL,
0x0000006000807306ULL, 0x000ea20000005400ULL, 0x000000cac700720bULL, 0x002fe20003f5d000ULL,
0x000000972424c231ULL, 0x088fe200003400ffULL, 0x000000928792723eULL, 0x000fe200000010ffULL,
0x000000972626c231ULL, 0x080fe400003400ffULL, 0x000000972828c231ULL, 0x080fe400003400ffULL,
0x0000006100867306ULL, 0x000fe20000009400ULL, 0x000000972a2ac231ULL, 0x000fe400003400ffULL,
0x000000562525c231ULL, 0x000fc400003400ffULL, 0x000000562727c231ULL, 0x080fe400003400ffULL,
0x000000562929c231ULL, 0x080fe200003400ffULL, 0x00000061007b7306ULL, 0x000e620000005400ULL,
0x000000807d00720bULL, 0x004fe20003fbd000ULL, 0x000000562b2bc231ULL, 0x000fe200003400ffULL,
0x0000006900567245ULL, 0x000fe2000020d400ULL, 0x000000be241c723cULL, 0x040fe8000004181cULL,
0x00000078008a7306ULL, 0x000fe80000209400ULL, 0x000000a82414723cULL, 0x000fe80000041814ULL,
0x0000007800817306ULL, 0x0005e20000205400ULL, 0x0000007b8600720bULL, 0x002fc40003fdd000ULL,
0x00000079d07b723eULL, 0x000fca00000010ffULL, 0x0000009500937306ULL, 0x000fe20000209400ULL,
0x0000007800787245ULL, 0x004fe2000020d400ULL, 0x0000007a2420723cULL, 0x000fec0000041820ULL,
0x0000009500987306ULL, 0x000e700000205400ULL, 0x00000060002d7306ULL, 0x0004f0000000d400ULL,
0x00000062008b7306ULL, 0x000fe20000009400ULL, 0x000000989300720bULL, 0x002fe20003f7d000ULL,
0x0000010067607824ULL, 0x004fe200078e00ffULL, 0x0000009500937245ULL, 0x000fc4000020d400ULL,
0x0000009c9f98723eULL, 0x000fe400000010ffULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000006200827306ULL, 0x000e620000005400ULL, 0x000000012d2d5812ULL, 0x008fc600078efcffULL,
0x00000098240c723cULL, 0x000fe4000004180cULL, 0x0000000193933812ULL, 0x000fe400078efcffULL,
0x0000006200507306ULL, 0x0004e4000000d400ULL, 0x000000938e93723eULL, 0x000fcc00000010ffULL,
0x0000006300897306ULL, 0x000fe20000009400ULL, 0x0000010064627824ULL, 0x004fe200078e00ffULL,
0x000000828b00720bULL, 0x002fe20003fbd000ULL, 0x000000922404723cULL, 0x000fe60000041804ULL,
0x00000018ff7c7819ULL, 0x000fe40000011462ULL, 0x00000063007e7306ULL, 0x000fee0000005400ULL,
0x0000000150505812ULL, 0x008fe200078efcffULL, 0x00000063004f7306ULL, 0x0003f0000000d400ULL,
0x000000bd00b77306ULL, 0x000fe20000209400ULL, 0x00000018ff637819ULL, 0x002fc800000114daULL,
0x0000006300627245ULL, 0x000fc6000020d400ULL, 0x000000bd00b47306ULL, 0x0002b00000205400ULL,
0x00000063009a7306ULL, 0x000fe20000209400ULL, 0x000000bd00bd7245ULL, 0x002fce000020d400ULL,
0x0000006300a37306ULL, 0x0002e20000205400ULL, 0x000000b4b700720bULL, 0x004fce0003f9d000ULL,
0x0000006100527306ULL, 0x000522000000d400ULL, 0x000000cd00637245ULL, 0x002fc8000020d400ULL,
0x0000000163632812ULL, 0x000fe400078efcffULL, 0x000000818a00720bULL, 0x000fe20003f5d000ULL,
0x000000af00aa7306ULL, 0x000fe20000209400ULL, 0x000000a39a00720bULL, 0x008fe20003f7d000ULL,
0x0000010066617824ULL, 0x004fe200078e00ffULL, 0x00000001bdbd4812ULL, 0x000fe400078efcffULL,
0x0000007e8900720bULL, 0x000fe40003f9d000ULL, 0x000000af00897245ULL, 0x000fe2000020d400ULL,
0x000000af00ab7306ULL, 0x000e620000205400ULL, 0x0000000152526812ULL, 0x010fc400078efcffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000000178782812ULL, 0x000fe400078efcffULL,
0x0000000162623812ULL, 0x000fe200078efcffULL, 0x000000a100a27306ULL, 0x000fe20000209400ULL,
0x000000526363723eULL, 0x000fe400000010ffULL, 0x000000014f4f4812ULL, 0x000fe400078efcffULL,
0x0000002d6262723eULL, 0x000fc600000010ffULL, 0x000000a100ad7306ULL, 0x000ea20000205400ULL,
0x000000abaa00720bULL, 0x002fc60003fdd000ULL, 0x000000622820723cULL, 0x000fe80000041820ULL,
0x0000006900707306ULL, 0x000fec0000209400ULL, 0x0000000189896812ULL, 0x000fc400078efcffULL,
0x00000069006f7306ULL, 0x000e620000205400ULL, 0x000000ada200720bULL, 0x004fe40003f5d000ULL,
0x000000897889723eULL, 0x000fca00000010ffULL, 0x0000006400777306ULL, 0x000ff00000009400ULL,
0x0000006400767306ULL, 0x000ea20000005400ULL, 0x0000006f7000720bULL, 0x002fce0003fbd000ULL,
0x00000088008c7306ULL, 0x000fec0000209400ULL, 0x0000000156565812ULL, 0x000fe400078efcffULL,
0x00000088008d7306ULL, 0x0002e20000205400ULL, 0x000000767700720bULL, 0x004fce0003fdd000ULL,
0x0000009b00a07306ULL, 0x000fe20000209400ULL, 0x0000008800887245ULL, 0x002fce000020d400ULL,
0x0000009b007f7306ULL, 0x0003e20000205400ULL, 0x0000008d8c00720bULL, 0x008fce0003f7d000ULL,
0x0000007c00807306ULL, 0x000fe20000209400ULL, 0x0000009b009b7245ULL, 0x002fca000020d400ULL,
0x0000000188883812ULL, 0x000fe400078efcffULL, 0x0000007c00857306ULL, 0x0002a40000205400ULL,
0x000000bd8888723eULL, 0x000fcc00000010ffULL, 0x00000064004b7306ULL, 0x000722000000d400ULL,
0x0000007c007c7245ULL, 0x002fe2000020d400ULL, 0x00000088281c723cULL, 0x000fec000004181cULL,
0x0000009d006e7306ULL, 0x000fe20000209400ULL, 0x0001000064647824ULL, 0x008fe200078e00ffULL,
0x000000858000720bULL, 0x004fc80003fbd000ULL, 0x00000018ff7e7819ULL, 0x000fe40000011464ULL,
0x000000a100647245ULL, 0x000fe2000020d400ULL, 0x0000009d007d7306ULL, 0x0002a20000205400ULL,
0x000000014b4b6812ULL, 0x010fe400078efcffULL, 0x0000000164642812ULL, 0x000fe400078efcffULL,
0x0000007fa000720bULL, 0x000fe40003f5d000ULL, 0x000000017c7c5812ULL, 0x000fe200078efcffULL,
0x0000005e005f7306ULL, 0x000fe20000209400ULL, 0x0000009d009d7245ULL, 0x002fce000020d400ULL,
0x0000005e00687306ULL, 0x0002e20000205400ULL, 0x0000007d6e00720bULL, 0x004fe40003f9d000ULL,
0x000000019b9b2812ULL, 0x000fca00078efcffULL, 0x000000a600a47306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x002fca000020d400ULL, 0x000000019d9d4812ULL, 0x000fe400078efcffULL,
0x000000a600a77306ULL, 0x000e620000205400ULL, 0x000000685f00720bULL, 0x008fce0003f5d000ULL,
0x0000009e00827306ULL, 0x000fec0000209400ULL, 0x000000015e5e2812ULL, 0x000fe400078efcffULL,
0x0000009e00817306ULL, 0x0004e20000205400ULL, 0x000000a7a400720bULL, 0x002fe40003f7d000ULL,
0x0000006db0a4723eULL, 0x000fca00000010ffULL, 0x0000007e00797306ULL, 0x000fe20000209400ULL,
0x0000009e009e7245ULL, 0x004fe2000020d400ULL, 0x000000a42410723cULL, 0x000fe80000041810ULL,
0x000000016b6b3812ULL, 0x000fe400078efcffULL, 0x0000007e00767306ULL, 0x0002a20000205400ULL,
0x000000818200720bULL, 0x008fe40003fbd000ULL, 0x000000506b50723eULL, 0x000fca00000010ffULL,
0x00000066005d7306ULL, 0x000fe20000009400ULL, 0x0000007e007e7245ULL, 0x002fca000020d400ULL,
0x000000019e9e5812ULL, 0x000fe400078efcffULL, 0x00000066005a7306ULL, 0x000e620000005400ULL,
0x000000767900720bULL, 0x004fce0003fdd000ULL, 0x0000006500747306ULL, 0x000fec0000009400ULL,
0x000000017e7e6812ULL, 0x000fe400078efcffULL, 0x0000006500717306ULL, 0x000ea20000005400ULL,
0x0000005a5d00720bULL, 0x002fe40003f9d000ULL, 0x0000005c835a723eULL, 0x000fca00000010ffULL,
0x0000006700587306ULL, 0x000fe40000009400ULL, 0x0000005a2408723cULL, 0x000fec0000041808ULL,
0x0000006700597306ULL, 0x000e620000005400ULL, 0x000000717400720bULL, 0x004fe40003f7d000ULL,
0x00000072b574723eULL, 0x000fca00000010ffULL, 0x0000000000547306ULL, 0x000fe40000209400ULL,
0x000000742418723cULL, 0x000fec0000041818ULL, 0x0000000000317306ULL, 0x0004e20000205400ULL,
0x000000595800720bULL, 0x002fe40003f5d000ULL, 0x0000000000277245ULL, 0x000fc4000020d400ULL,
0x0000009b5624723eULL, 0x000fe400000010ffULL, 0x0000009d5e25723eULL, 0x000fe200000010ffULL,
0x0000005500517306ULL, 0x000fe20000209400ULL, 0x0000005500007245ULL, 0x004fe4000020d400ULL,
0x0000004b7c56723eULL, 0x000fc600000010ffULL, 0x000000242814723cULL, 0x000fe40000041814ULL,
0x0000005500327306ULL, 0x000e620000205400ULL, 0x000000315400720bULL, 0x008fce0003fbd000ULL,
0x0000006500577306ULL, 0x0004ec000000d400ULL, 0x0000000127275812ULL, 0x000fe400078efcffULL,
0x0000006100697306ULL, 0x000fe20000209400ULL, 0x0001000065657824ULL, 0x004fe200078e00ffULL,
0x000000325100720bULL, 0x002fc40003fdd000ULL, 0x0000004f6451723eULL, 0x000fe400000010ffULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x0000006100687306ULL, 0x0002a20000205400ULL,
0x0000000157573812ULL, 0x008fe400078efcffULL, 0x00000065007f7245ULL, 0x000fe2000020d400ULL,
0x000000502818723cULL, 0x000fe20000041818ULL, 0x000000579e57723eULL, 0x000fe400000010ffULL,
0x0000000100006812ULL, 0x000fe200078efcffULL, 0x0000006500717306ULL, 0x000fe20000209400ULL,
0x0000006100617245ULL, 0x002fc4000020d400ULL, 0x0000007e277e723eULL, 0x000fe200000010ffULL,
0x000000562810723cULL, 0x000fe80000041810ULL, 0x0000006500707306ULL, 0x000e620000205400ULL,
0x000000686900720bULL, 0x004fce0003fbd000ULL, 0x00000060005c7306ULL, 0x000fec0000209400ULL,
0x0000000161615812ULL, 0x000fe400078efcffULL, 0x0000006000597306ULL, 0x0004e20000205400ULL,
0x000000707100720bULL, 0x002fce0003f7d000ULL, 0x0000006600307306ULL, 0x000322000000d400ULL,
0x0000006000607245ULL, 0x004fca000020d400ULL, 0x000000017f7f3812ULL, 0x000fe400078efcffULL,
0x0000006700537306ULL, 0x000522000000d400ULL, 0x0001000066667824ULL, 0x002fe200078e00ffULL,
0x000000595c00720bULL, 0x008fe40003fdd000ULL, 0x0000007f007f723eULL, 0x000fe400000010ffULL,
0x00000018ff667819ULL, 0x000fe40000011466ULL, 0x0000002f004d7306ULL, 0x000fe20000209400ULL,
0x0001000067677824ULL, 0x004fe200078e00ffULL, 0x0000000130304812ULL, 0x010fe200078efcffULL,
0x0000007e280c723cULL, 0x000fe6000004180cULL, 0x00000018ff677819ULL, 0x000fc40000011467ULL,
0x0000002f004e7306ULL, 0x0002a20000205400ULL, 0x0000000160606812ULL, 0x000fe400078efcffULL,
0x0000000153532812ULL, 0x000fe400078efcffULL, 0x000000306130723eULL, 0x000fc600000010ffULL,
0x0000002e00337306ULL, 0x000fe20000209400ULL, 0x0000002f002f7245ULL, 0x002fce000020d400ULL,
0x0000002e004c7306ULL, 0x0002e20000205400ULL, 0x0000004e4d00720bULL, 0x004fce0003f7d000ULL,
0x0000006600267306ULL, 0x000fe20000209400ULL, 0x0000002e002e7245ULL, 0x002fca000020d400ULL,
0x000000012f2f3812ULL, 0x000fe400078efcffULL, 0x00000066002d7306ULL, 0x0002a20000205400ULL,
0x0000004c3300720bULL, 0x008fce0003fbd000ULL, 0x0000006700317306ULL, 0x000fe20000209400ULL,
0x0000006600667245ULL, 0x002fca000020d400ULL, 0x000000012e2e5812ULL, 0x000fe400078efcffULL,
0x0000006700327306ULL, 0x0002e20000205400ULL, 0x0000002d2600720bULL, 0x004fe40003f9d000ULL,
0x0000006700677245ULL, 0x002fd6000020d400ULL, 0x0000000166664812ULL, 0x000fe400078efcffULL,
0x000000323100720bULL, 0x008fe40003fdd000ULL, 0x000000536031723eULL, 0x000fe400000010ffULL,
0x000000662f66723eULL, 0x000fca00000010ffULL, 0x000000302808723cULL, 0x000fe80000041808ULL,
0x0000000167676812ULL, 0x000fc800078efcffULL, 0x000000672e67723eULL, 0x000fce00000010ffULL,
0x000000662804723cULL, 0x000fe20000041804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200043ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6400048ff7f8cULL, 0x0005e2000c80043fULL,
0x0000991073007816ULL, 0x000fe400000000ffULL, 0x00000001ff707807ULL, 0x000fe40004800000ULL,
0x000000ff0000720cULL, 0x000fe40003f45270ULL, 0x00000001466f7812ULL, 0x000fe400078ec0ffULL,
0x00000001ff2c8807ULL, 0x000fc80001000000ULL, 0x000076102c717816ULL, 0x000fe40000000071ULL,
0x0000030034347a10ULL, 0x004fe40007ffe0ffULL, 0x000000ff45ff7812ULL, 0x000fe4000780c0ffULL,
0x000000373400720cULL, 0x000fe40003f26070ULL, 0x00000001ff457807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff4d8000007947ULL, 0x000fea000383ffffULL,
0x00000000000479c3ULL, 0x002e620000002500ULL, 0x000000ffff287224ULL, 0x000fe400078e000eULL,
0x000000ffff317224ULL, 0x000fe400078e0007ULL, 0x000000ffff327224ULL, 0x000fe400078e0006ULL,
0x000000ffff307224ULL, 0x000fe400078e0005ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0004ULL,
0x000000ffff2d7224ULL, 0x000fc400078e000bULL, 0x000000ffff2e7224ULL, 0x000fe400078e000aULL,
0x000000ffff2c7224ULL, 0x000fe400078e0009ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0008ULL,
0x000000ffff2a7224ULL, 0x000fe400078e000fULL, 0x000000ffff267224ULL, 0x000fe400078e000dULL,
0x000000ffff297224ULL, 0x000fe200078e000cULL, 0x0000000437007c0cULL, 0x002fe2000bf03070ULL,
0x000000ffff247224ULL, 0x000fc400078e0013ULL, 0x000000ffff277224ULL, 0x000fe400078e0011ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0017ULL, 0x000000ffff257224ULL, 0x000fcc00078e0015ULL,
0x0000037000000947ULL, 0x000fea0003800000ULL, 0x0180000042007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000c36000067802ULL, 0x000fe40000000f00ULL, 0x00009cc000007944ULL, 0x020fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000004200037308ULL, 0x000e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000042ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff057624ULL, 0x000fe400078e00ffULL, 0x00006800ff047624ULL, 0x000fca00078e00ffULL,
0x0000000804057981ULL, 0x000f28000c1e9900ULL, 0x0000000000037919ULL, 0x000e680000000000ULL,
0x0000000000087919ULL, 0x000ee20000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011603ULL,
0x0000000808037811ULL, 0x008fe200078ff0ffULL, 0x0000000005067220ULL, 0x014fca0000410000ULL,
0x00001f0706007589ULL, 0x000e6800000e0000ULL, 0x00001f0306037589ULL, 0x000ea200000e0000ULL,
0x0000002000207220ULL, 0x042fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001900197220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000001000107220ULL, 0x040fe20000410000ULL, 0x0000002700277220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002600267220ULL, 0x040fe20000410000ULL,
0x0000002b002b7220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002f002f7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x000fe20000410000ULL,
0x0000002203227220ULL, 0x044fe20000410000ULL, 0x0000002303237220ULL, 0x040fe20000410000ULL,
0x0000001e031e7220ULL, 0x040fe20000410000ULL, 0x0000001f031f7220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000001b031b7220ULL, 0x040fe20000410000ULL,
0x0000001603167220ULL, 0x040fe20000410000ULL, 0x0000000e030e7220ULL, 0x040fe20000410000ULL,
0x0000001203127220ULL, 0x040fe20000410000ULL, 0x0000002403247220ULL, 0x040fe20000410000ULL,
0x0000002803287220ULL, 0x040fe20000410000ULL, 0x0000002a032a7220ULL, 0x040fe20000410000ULL,
0x0000002e032e7220ULL, 0x040fe20000410000ULL, 0x0000002d032d7220ULL, 0x040fe20000410000ULL,
0x0000003203327220ULL, 0x040fe20000410000ULL, 0x0000003103317220ULL, 0x000fe20000410000ULL,
0x0000000000007919ULL, 0x000e680000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000200037812ULL, 0x002fc400078ec0ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011600ULL,
0x00000001ff047819ULL, 0x000fe40000011603ULL, 0x0000000403087811ULL, 0x040fe400078ff8ffULL,
0x0000000800177811ULL, 0x000fe400078ff0ffULL, 0x0000000203057811ULL, 0x040fe400078ff8ffULL,
0x00000006030b7811ULL, 0x000fc400078ff8ffULL, 0x0000000704037812ULL, 0x100fe400078e780fULL,
0x00000007080a7812ULL, 0x040fe400078e780fULL, 0x0000000708087812ULL, 0x000fe200078e7817ULL,
0x000000080f077824ULL, 0x000fe200078e0203ULL, 0x0000000704047812ULL, 0x000fe200078e7817ULL,
0x000010003c037824ULL, 0x000fe200078e00ffULL, 0x0000000705067812ULL, 0x100fe200078e780fULL,
0x0000000817157824ULL, 0x000fe200078e0208ULL, 0x000000070b0c7812ULL, 0x000fe200078e780fULL,
0x0000000800087824ULL, 0x000fe200078e00ffULL, 0x0000000705057812ULL, 0x100fe200078e7817ULL,
0x0000000817117824ULL, 0x000fe200078e0204ULL, 0x000000070b0b7812ULL, 0x000fe200078e7817ULL,
0x0000080049047824ULL, 0x000fe200078e0203ULL, 0x0000000808087812ULL, 0x000fe200078ec0ffULL,
0x000000080f097824ULL, 0x000fe200078e0206ULL, 0x0000001c1d06723eULL, 0x000fe200000010ffULL,
0x000000080f0d7824ULL, 0x000fc400078e020aULL, 0x0000000817137824ULL, 0x000fe200078e0205ULL,
0x000000202105723eULL, 0x000fe200000010ffULL, 0x000000080f0f7824ULL, 0x000fe400078e020cULL,
0x0000000817177824ULL, 0x000fe400078e020bULL, 0x0000001007077824ULL, 0x100fe400078e0204ULL,
0x00000010090b7824ULL, 0x100fe400078e0204ULL, 0x000000100d0d7824ULL, 0x000fc400078e0204ULL,
0x0000001011117824ULL, 0x100fe400078e0204ULL, 0x0000001013137824ULL, 0x100fe400078e0204ULL,
0x000000100f0f7824ULL, 0x100fe400078e0204ULL, 0x0000001015157824ULL, 0x100fe400078e0204ULL,
0x0000001017177824ULL, 0x000fe400078e0204ULL, 0x0000000107097824ULL, 0x000fe200078e0208ULL,
0x000000181907723eULL, 0x000fe200000010ffULL, 0x00000001080b7824ULL, 0x040fe200078e020bULL,
0x0000541005187816ULL, 0x140fe20000000006ULL, 0x00000001080d7824ULL, 0x040fe200078e020dULL,
0x0000763205197816ULL, 0x000fe20000000006ULL, 0x0000000108117824ULL, 0x040fe200078e0211ULL,
0x000000102705723eULL, 0x000fe200000010ffULL, 0x0000000108137824ULL, 0x000fe200078e0213ULL,
0x000000292606723eULL, 0x000fe200000010ffULL, 0x00000001080f7824ULL, 0x040fe200078e020fULL,
0x0000001809007388ULL, 0x0003e20000000a00ULL, 0x0000000108157824ULL, 0x040fe200078e0215ULL,
0x00005410050a7816ULL, 0x000fe20000000006ULL, 0x0000000108177824ULL, 0x000fe200078e0217ULL,
0x000000142508723eULL, 0x000fc800000010ffULL, 0x0000541007187816ULL, 0x142fe40000000008ULL,
0x0000763207197816ULL, 0x000fe40000000008ULL, 0x0000002b2c07723eULL, 0x000fe400000010ffULL,
0x0000002f3008723eULL, 0x000fe200000010ffULL, 0x000000180b007388ULL, 0x0003e40000000a00ULL,
0x00007632050b7816ULL, 0x002fe40000000006ULL, 0x000000222305723eULL, 0x000fc400000010ffULL,
0x0000001e1f06723eULL, 0x000fe200000010ffULL, 0x0000000a0d007388ULL, 0x0003e40000000a00ULL,
0x00005410070a7816ULL, 0x142fe40000000008ULL, 0x00007632070b7816ULL, 0x000fe40000000008ULL,
0x0000001a1b07723eULL, 0x000fe400000010ffULL, 0x000000160e08723eULL, 0x000fe200000010ffULL,
0x0000000a0f007388ULL, 0x0003e20000000a00ULL, 0x000000013d0e7824ULL, 0x000fc400078e0200ULL,
0x00000300ff167624ULL, 0x000fe400078e00ffULL, 0x000000100e097824ULL, 0x000fe200078e0203ULL,
0x00005410050a7816ULL, 0x142fe40000000006ULL, 0x00007632050b7816ULL, 0x000fe40000000006ULL,
0x000000122405723eULL, 0x000fe400000010ffULL, 0x000000282a06723eULL, 0x000fe200000010ffULL,
0x0000000a11007388ULL, 0x0003e40000000a00ULL, 0x00005410070a7816ULL, 0x002fc40000000008ULL,
0x00007632070b7816ULL, 0x000fe40000000008ULL, 0x0000002e2d07723eULL, 0x000fe400000010ffULL,
0x000000323108723eULL, 0x000fe200000010ffULL, 0x0000000a13007388ULL, 0x0003e40000000a00ULL,
0x00005410050a7816ULL, 0x142fe40000000006ULL, 0x00007632050b7816ULL, 0x000fe40000000006ULL,
0x000000ff00057306ULL, 0x000fe60000205400ULL, 0x0000000a15007388ULL, 0x0003ea0000000a00ULL,
0x000000ff00067306ULL, 0x000ea20000209400ULL, 0x00005410070a7816ULL, 0x002fc40000000008ULL,
0x00007632070b7816ULL, 0x000fca0000000008ULL, 0x0000000a17007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000050600720bULL, 0x004fe40003f1d000ULL,
0x000000ff00057245ULL, 0x000fd6000020d400ULL, 0x0000000105050812ULL, 0x000fe400078efcffULL,
0x000000011600780cULL, 0x000fe40003f05270ULL, 0x000000050508723eULL, 0x000fe200000010ffULL,
0x0000000009107984ULL, 0x000e680000000c00ULL, 0x00040000091c7984ULL, 0x000ea80000000c00ULL,
0x0008000009187984ULL, 0x000ee80000000c00ULL, 0x000c000009207984ULL, 0x000f220000000c00ULL,
0x3f803f8008137831ULL, 0x002fc40000200013ULL, 0x3f803f8008127831ULL, 0x040fe40000200012ULL,
0x3f803f8008117831ULL, 0x040fe40000200011ULL, 0x3f803f8008107831ULL, 0x040fe40000200010ULL,
0x3f803f80081f7831ULL, 0x044fe4000020001fULL, 0x3f803f80081e7831ULL, 0x040fe4000020001eULL,
0x3f803f80081d7831ULL, 0x000fc4000020001dULL, 0x3f803f80081c7831ULL, 0x000fe4000020001cULL,
0x3f803f8013137831ULL, 0x008fe4000020001bULL, 0x3f803f8012127831ULL, 0x000fe4000020001aULL,
0x3f803f8011117831ULL, 0x000fe40000200019ULL, 0x3f803f8010107831ULL, 0x000fe40000200018ULL,
0x3f803f801f1f7831ULL, 0x010fc40000200023ULL, 0x3f803f801e1e7831ULL, 0x000fe20000200022ULL,
0x0000001009007388ULL, 0x0003e20000000c00ULL, 0x3f803f801d1d7831ULL, 0x000fe40000200021ULL,
0x3f803f801c1c7831ULL, 0x000fca0000200020ULL, 0x0004001c09007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000305000008947ULL, 0x000fea0003800000ULL,
0x0000000000127919ULL, 0x002e620000002700ULL, 0x0000580016067a24ULL, 0x000fe200078e02ffULL,
0x0000000149ff7812ULL, 0x000fe2000780f802ULL, 0x00001000ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000000077919ULL, 0x000e620000002600ULL, 0x00006600060c7a24ULL, 0x000fe200078e02ffULL,
0x000000400e117810ULL, 0x000fe20007ffe0ffULL, 0x000008003c087824ULL, 0x000fe200078e00ffULL,
0x0000000009187984ULL, 0x000ea80000000c00ULL, 0x00040000091c7984ULL, 0x0007240000000c00ULL,
0x01ffffff0c097812ULL, 0x008fe200078ec0ffULL, 0x0000580012127a24ULL, 0x002fe200078e0207ULL,
0x00000fff0c077811ULL, 0x000fc600078e40ffULL, 0x0000030012067a24ULL, 0x000fca00078e02ffULL,
0x0000000406147c10ULL, 0x000fc8000fffe0ffULL, 0x00000014070a7211ULL, 0x000fca00078fa0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000bULL, 0x000000080a0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x000000ff0000720cULL, 0x000fc60000725670ULL,
0x000000100e0e7825ULL, 0x000fc800078e000aULL, 0x0000001011107825ULL, 0x000fe200078e000aULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000010000a7824ULL, 0x014fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x00000001140c7824ULL, 0x000fe200078e0209ULL, 0x000000700a137812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b157812ULL, 0x000fe200078ec0ffULL, 0x00006c00140a7625ULL, 0x000fc800078e000dULL,
0x00006c000c0c7625ULL, 0x000fe200078e000dULL, 0x0000000a150a7210ULL, 0x000fc80007a1e013ULL,
0x0000000c150c7210ULL, 0x000fe40007c7e013ULL, 0x0000000bff0b7210ULL, 0x000fe400007e44ffULL,
0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL, 0x000000400a007986ULL, 0x0003e8000c101908ULL,
0x000000420c007986ULL, 0x0003e4000c101908ULL, 0x000000180e007986ULL, 0x0145e2000c101d08ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x0000001c10007986ULL, 0x0005e8000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff0b7424ULL, 0x002fe200078e00ffULL, 0xffffffff160d7810ULL, 0x000fc60007ffe0ffULL,
0x00006a00120a7625ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000d0a0a79a8ULL, 0x000ee400099ee1c8ULL,
0x0000000d0a00720cULL, 0x008fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0c7807ULL, 0x000fca0000000000ULL, 0x0000000cff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff0a7984ULL, 0x002e640000000000ULL, 0x000000ff0a00720cULL, 0x002fda0003f05270ULL,
0x00002c8000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff0a7819ULL, 0x000fe20000011600ULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001060c7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff197424ULL, 0x004fe200078e00ffULL, 0x0000000c0a0e7812ULL, 0x000fe400078ec0ffULL,
0x00000070021b7812ULL, 0x000fe200078ec0ffULL, 0x00006c00060a7625ULL, 0x000fc800078e0019ULL,
0x00006c000c0c7625ULL, 0x000fe200078e0019ULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL,
0x0000000c0e0c7210ULL, 0x000fe40007b5e01bULL, 0x0000000bff0b7210ULL, 0x000fe400007e24ffULL,
0x0000000dff0d7210ULL, 0x000fc600017e64ffULL, 0x000000080a027981ULL, 0x000368000c1e1900ULL,
0x000000080c0f7981ULL, 0x000362000c1e1900ULL, 0x000000021600780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002060a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000080a117981ULL, 0x000362000c1e1900ULL,
0x000000041600780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003060a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000080a137981ULL, 0x000362000c1e1900ULL, 0x000000041600780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004060a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000080a157981ULL, 0x000362000c1e1900ULL,
0x000000061600780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005060a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000080a177981ULL, 0x000362000c1e1900ULL, 0x000000061600780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081600780cULL, 0x002fe40003f06070ULL,
0x00000006060a7810ULL, 0x000fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a0e0a7210ULL, 0x000fe40007a3e01bULL, 0x00000007060c0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006c000c0c0625ULL, 0x000fe400078e0019ULL,
0x000000080a197981ULL, 0x000366000c1e1900ULL, 0x0000000c0e0c0210ULL, 0x000fc80007c7e01bULL,
0x0000000dff0d0210ULL, 0x000fcc0001fe84ffULL, 0x000000080c0d0981ULL, 0x000366000c1e1900ULL,
0x00000007160a7810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0c7819ULL, 0x000fc8000001160aULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff1b7224ULL, 0x004fe400078e00ffULL, 0x000000ffff1d7224ULL, 0x020fe400078e0002ULL,
0x000000081b0e7824ULL, 0x040fe200078e00ffULL, 0x000000011b1b7810ULL, 0x000fc80007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x0000000c1b00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080e0b7810ULL, 0x040fe40007ffe0ffULL,
0x000000010e0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001d02027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x00000070101d7812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e01dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000080a1d7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090e0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000020e0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000000f02027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff107819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010000f7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000080a0f7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0e0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000030e0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001102027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007010117812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000080a117981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0e0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000040e0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001302027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007010137812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e013ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000080a137981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0e0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000050e0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001502027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007010157812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e015ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000080a157981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0e0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000060e0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001702027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007010177812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e017ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000080a177981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0e0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000070e0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001902027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007010197812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e019ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000080a197981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0e0b7810ULL, 0x002fe40007ffe0ffULL, 0x0000000d02027209ULL, 0x000fe40007810000ULL,
0x000003000b007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff0e7819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010000d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007a3e00dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000080a0d7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ee40000000000ULL,
0x00000010000a7824ULL, 0x00afe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fc80000011600ULL,
0x000000700a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL,
0x000000010b0b7824ULL, 0x000fca00078e020aULL, 0x000000020b007388ULL, 0x0203e40000000800ULL,
0x0000000149147824ULL, 0x000fe200078e0206ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011600ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000014070a7211ULL, 0x000fe200078fa0ffULL,
0x00001000ff117424ULL, 0x004fe200078e00ffULL, 0x00000070020c7812ULL, 0x000fe200078ec0ffULL,
0x000000013e3e7824ULL, 0x000fe200078e0203ULL, 0x0000000c0b0f7812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e0011ULL, 0x0000000139027812ULL, 0x040fe200078ec0ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000006000117810ULL, 0x000fe20007ffe0ffULL,
0x0000080039397824ULL, 0x000fe200078e00ffULL, 0x000000080a0a7210ULL, 0x000fe20007f3e0ffULL,
0x000000010f297824ULL, 0x000fe200078e020cULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000002490d8824ULL, 0x100fe200078e023cULL, 0x0000080039397812ULL, 0x000fe200078ec0ffULL,
0x00000002490f8824ULL, 0x000fe200078e023cULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000020d178824ULL, 0x100fe200078e0202ULL, 0x00000020000d7810ULL, 0x040fe20007ffe0ffULL,
0x000000020f198824ULL, 0x000fe200078e0202ULL, 0x00000040000f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109128824ULL, 0x000fe200078e0214ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000080ff138424ULL, 0x000fe200078e00ffULL, 0x0000000029297984ULL, 0x000e620000000800ULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000030049007a0cULL, 0x000fe20003f26070ULL,
0x00000080ff158424ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000013e397824ULL, 0x000fe200078e0239ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00006c0012128625ULL, 0x000fc800078e0013ULL, 0x000000100d0c7825ULL, 0x000fc800078e000aULL,
0x000000100f0e7825ULL, 0x000fc800078e000aULL, 0x0000001011107825ULL, 0x000fc800078e000aULL,
0x00006c0014148625ULL, 0x000fc800078e0015ULL, 0x0000000817178824ULL, 0x000fe400078e0200ULL,
0x0000001000397824ULL, 0x040fe400078e0239ULL, 0x00000010000a7825ULL, 0x000fe200078e000aULL,
0x0000458017178811ULL, 0x000fc600078e20ffULL, 0x0000000819198824ULL, 0x000fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a397faeULL, 0x0005e2000b901c48ULL,
0x0000001000128825ULL, 0x000fc600078e0012ULL, 0x00004180191f8811ULL, 0x000fe200078e20ffULL,
0x0000001000148825ULL, 0x000fe200078e0014ULL, 0x003800000c397faeULL, 0x0007e2000b901c48ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x005800000e397faeULL, 0x0009e2000b901c48ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x00000000000a7805ULL, 0x004fe2000001ff00ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x0078000010397faeULL, 0x0005e8000b901c48ULL, 0x0000000012178faeULL, 0x0003e2000b901c48ULL,
0x00000000000c7805ULL, 0x008fc6000001ff00ULL, 0x00000000141f8faeULL, 0x0007e2000b901c48ULL,
0x00000000000e7805ULL, 0x010fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000107805ULL, 0x004fe2000001ff00ULL, 0x0000000000127805ULL, 0x002fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x008fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000e0000001947ULL, 0x000fea0003800000ULL,
0x00000df000007945ULL, 0x000fe20003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e00ffULL,
0x000000ffff2c7224ULL, 0x000fca00078e0049ULL, 0x000000022c377810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff437224ULL, 0x000fe200078e002cULL, 0x00000002ff5a7819ULL, 0x002fe20000011600ULL,
0x00000002492c7824ULL, 0x000fe200078e023cULL, 0x0000030037007a0cULL, 0x000fe20003f06070ULL,
0x00000040432b7824ULL, 0x000fe200078e00ffULL, 0x000000075a2d7812ULL, 0x040fe200078ec0ffULL,
0x000000085a387824ULL, 0x040fe200078e00ffULL, 0x0000005aff4a7212ULL, 0x000fe200078e33ffULL,
0x000000085a2a7824ULL, 0x040fe200078e00ffULL, 0x000000802b2b7812ULL, 0x000fe200078ec0ffULL,
0x000000085a2f7824ULL, 0x008fe200078e00ffULL, 0x0000039000017945ULL, 0x000fe20003800000ULL,
0xfffffff838387812ULL, 0x100fe200078ee22dULL, 0x0000001000477824ULL, 0x000fe200078e00ffULL,
0x000000012a3a7812ULL, 0x020fe200078ef62dULL, 0x000001002c417824ULL, 0x000fe200078e002bULL,
0x000000022a407812ULL, 0x000fc400078ef62dULL, 0x000000032a427812ULL, 0x140fe400078ef62dULL,
0x000000042a447812ULL, 0x140fe400078ef62dULL, 0x000000052a467812ULL, 0x140fe400078ef62dULL,
0x000000062a487812ULL, 0x000fe400078ef62dULL, 0xfffffff82f4a7812ULL, 0x000fe400078ee24aULL,
0x000000085a5c7810ULL, 0x000fe20007ffe0ffULL, 0x000002c000000947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x000fe20003f24070ULL, 0x0000000106347824ULL, 0x100fe200078e0237ULL,
0x00000001ff2c7819ULL, 0x000fe20000011637ULL, 0x00001000ff2b7424ULL, 0x000fe200078e00ffULL,
0x00000020002f7810ULL, 0x000fc40007ffe0ffULL, 0x00000034072a7211ULL, 0x000fe400078fa0ffULL,
0x000000012c2d7812ULL, 0x000fe200078ec0ffULL, 0x00000400372c7824ULL, 0x000fe200078e00ffULL,
0x0000004000317810ULL, 0x000fe20007ffe0ffULL, 0x00006c002a2a7625ULL, 0x000fe200078e002bULL,
0x00000060003f7810ULL, 0x000fc60007ffe0ffULL, 0x00000002492e9824ULL, 0x140fe200078e023cULL,
0x000000082a2a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000249309824ULL, 0x000fe400078e023cULL,
0x000000022e3b9824ULL, 0x100fe400078e022dULL, 0x0000000230459824ULL, 0x000fe200078e022dULL,
0x000008002c2d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2b7224ULL, 0x000fe400000e062bULL,
0x0000000109329824ULL, 0x000fc400078e0234ULL, 0x000000013e2d7824ULL, 0x000fe400078e022dULL,
0x00000080ff339424ULL, 0x000fe400078e00ffULL, 0x00000080ff359424ULL, 0x000fe400078e00ffULL,
0x0000001000397824ULL, 0x000fe400078e022dULL, 0x00006c0032329625ULL, 0x000fc800078e0033ULL,
0x00000010002c7825ULL, 0x000fc800078e002aULL, 0x000000102f2e7825ULL, 0x100fe200078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800002c397faeULL, 0x0003e6000b901c48ULL,
0x0000001031307825ULL, 0x100fe200078e002aULL, 0x003800002e397faeULL, 0x0003e6000b901c48ULL,
0x00006c0034349625ULL, 0x000fe200078e0035ULL, 0x0058000030397faeULL, 0x0003e6000b901c48ULL,
0x000000103f2a7825ULL, 0x000fc800078e002aULL, 0x000000083b3b9824ULL, 0x100fe200078e0200ULL,
0x007800002a397faeULL, 0x0003e2000b901c48ULL, 0x00000008453f9824ULL, 0x000fe400078e0200ULL,
0x0000001000329825ULL, 0x040fe200078e0032ULL, 0x000045803b3b9811ULL, 0x000fe400078e20ffULL,
0x000041803f3f9811ULL, 0x000fe200078e20ffULL, 0x0000001000349825ULL, 0x000fe400078e0034ULL,
0x00000000323b9faeULL, 0x0003e8000b901c48ULL, 0x00000000343f9faeULL, 0x0003e4000b901c48ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000001ff2c7819ULL, 0x002fe20000011600ULL, 0x000000085c307824ULL, 0x040fe200078e00ffULL,
0x0000007047507812ULL, 0x000fe200078ec0ffULL, 0x000000085c2e7824ULL, 0x000fe200078e00ffULL,
0x0000000c2c2d7812ULL, 0x000fe200078ec0ffULL, 0x00000400432a7824ULL, 0x000fe200078e00ffULL,
0x000000075c2b7812ULL, 0x000fc400078ec0ffULL, 0x000000412d417210ULL, 0x000fe20007ffe050ULL,
0x000000085c2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8302c7812ULL, 0x100fe400078ee22bULL,
0x000000012e307812ULL, 0x140fe400078ef62bULL, 0x000000022e327812ULL, 0x140fe400078ef62bULL,
0x000000032e347812ULL, 0x140fe400078ef62bULL, 0x000000042e4c7812ULL, 0x000fc400078ef62bULL,
0x000000052e4e7812ULL, 0x140fe400078ef62bULL, 0x000000062e2e7812ULL, 0x000fe200078ef62bULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800041527984ULL, 0x000e620000000800ULL,
0x000008002a2b7812ULL, 0x000fe200078ec0ffULL, 0x00000004002a7824ULL, 0x000fe200078e00ffULL,
0x0000005cff507212ULL, 0x000fe200078e33ffULL, 0x0045800041417984ULL, 0x000ea20000000800ULL,
0x000001803e2b7810ULL, 0x000fe40007ffe02bULL, 0xfffffff82d507812ULL, 0x000fe400078ee250ULL,
0x0000000c2a2d7812ULL, 0x000fe200078ec0ffULL, 0x0000001038387824ULL, 0x000fc400078e022bULL,
0x000000103a3a7824ULL, 0x100fe400078e022bULL, 0x0000001040407824ULL, 0x100fe400078e022bULL,
0x0000001042427824ULL, 0x100fe400078e022bULL, 0x0000001044447824ULL, 0x100fe400078e022bULL,
0x0000001046467824ULL, 0x100fe400078e022bULL, 0x0000001048487824ULL, 0x000fc400078e022bULL,
0x0000001034347824ULL, 0x100fe400078e022bULL, 0x000000104c4c7824ULL, 0x100fe400078e022bULL,
0x000000104e4e7824ULL, 0x100fe400078e022bULL, 0x000000104a4a7824ULL, 0x100fe400078e022bULL,
0x0000001030307824ULL, 0x100fe400078e022bULL, 0x0000001032327824ULL, 0x000fc400078e022bULL,
0x000000102e2e7824ULL, 0x100fe400078e022bULL, 0x0000001050507824ULL, 0x100fe400078e022bULL,
0x000000102c2c7824ULL, 0x000fe200078e022bULL, 0x0000005229527221ULL, 0x002fe20000010100ULL,
0x0000000138387824ULL, 0x000fe400078e022dULL, 0x000000012d3a7824ULL, 0x040fe200078e023aULL,
0x3fb8aa3b52527820ULL, 0x000fe20000410000ULL, 0x000000012d407824ULL, 0x000fc400078e0240ULL,
0x000000012d427824ULL, 0x040fe200078e0242ULL, 0x0000000038387984ULL, 0x000e620000000800ULL,
0x000000012d447824ULL, 0x040fe200078e0244ULL, 0x0000005200527308ULL, 0x000ea20000000800ULL,
0x000000012d467824ULL, 0x040fe200078e0246ULL, 0x000000003a3a7984ULL, 0x000ee20000000800ULL,
0x000000012d487824ULL, 0x040fe400078e0248ULL, 0x000000012d4a7824ULL, 0x040fe200078e024aULL,
0x0000000040407984ULL, 0x000f220000000800ULL, 0x000000012d347824ULL, 0x000fc400078e0234ULL,
0x000000012d4c7824ULL, 0x040fe200078e024cULL, 0x0000000042427984ULL, 0x000f620000000800ULL,
0x000000012d4e7824ULL, 0x040fe400078e024eULL, 0x000000012d307824ULL, 0x040fe200078e0230ULL,
0x0000000044447984ULL, 0x000f620000000800ULL, 0x000000012d327824ULL, 0x040fe200078e0232ULL,
0x00000041522f7220ULL, 0x004fe20000410000ULL, 0x000000012d2e7824ULL, 0x040fe200078e022eULL,
0x0000000046467984ULL, 0x000ea20000000800ULL, 0x000000012d507824ULL, 0x000fe200078e0250ULL,
0x000000362f367221ULL, 0x000fe20000010000ULL, 0x000000012d2c7824ULL, 0x000fe200078e022cULL,
0x0000000048487984ULL, 0x000ea80000000800ULL, 0x000000004a4a7984ULL, 0x000ea80000000800ULL,
0x0000000034347984ULL, 0x000ea80000000800ULL, 0x000000004c4c7984ULL, 0x000ea80000000800ULL,
0x000000004e4e7984ULL, 0x000ea20000000800ULL, 0x00005410ff337816ULL, 0x002fc40000000038ULL,
0x00007610ff387816ULL, 0x000fe20000000038ULL, 0x000000002c2a7984ULL, 0x0002a20000000800ULL,
0x00005410ff357816ULL, 0x108fe4000000003aULL, 0x00007610ff3a7816ULL, 0x000fe2000000003aULL,
0x0000000030307984ULL, 0x000ee80000000800ULL, 0x0000000032327984ULL, 0x000ee20000000800ULL,
0x000000ffff2c7224ULL, 0x002fe200078e0037ULL, 0x00005410ff377816ULL, 0x010fc40000000040ULL,
0x000000002e2e7984ULL, 0x000e620000000800ULL, 0x00005410ff397816ULL, 0x020fe40000000042ULL,
0x00005410ff3b7816ULL, 0x000fe20000000044ULL, 0x0000000050507984ULL, 0x000f220000000800ULL,
0x00005410ff3f7816ULL, 0x004fe40000000046ULL, 0x000003002c007a0cULL, 0x000fe40003f06070ULL,
0x00005410ff417816ULL, 0x000fe40000000048ULL, 0x00007610ff407816ULL, 0x000fc40000000040ULL,
0x00005410ff437816ULL, 0x000fe4000000004aULL, 0x00007610ff427816ULL, 0x000fe40000000042ULL,
0x00005410ff4d7816ULL, 0x000fe40000000034ULL, 0x00007610ff447816ULL, 0x000fe40000000044ULL,
0x00005410ff4f7816ULL, 0x000fe4000000004cULL, 0x00007610ff467816ULL, 0x000fc40000000046ULL,
0x00005410ff517816ULL, 0x000fe4000000004eULL, 0x00007610ff487816ULL, 0x000fe40000000048ULL,
0x00007610ff4a7816ULL, 0x000fe4000000004aULL, 0x00005410ff457816ULL, 0x100fe4000000002aULL,
0x00007610ff527816ULL, 0x000fe4000000002aULL, 0x00005410ff477816ULL, 0x008fc40000000030ULL,
0x00007610ff547816ULL, 0x000fe40000000030ULL, 0x00005410ff4b7816ULL, 0x100fe40000000032ULL,
0x00007610ff567816ULL, 0x000fe40000000032ULL, 0x00007610ff347816ULL, 0x000fe40000000034ULL,
0x00007610ff4c7816ULL, 0x000fe4000000004cULL, 0x00007610ff4e7816ULL, 0x000fc4000000004eULL,
0x00005410ff537816ULL, 0x102fe4000000002eULL, 0x00007610ff587816ULL, 0x000fe4000000002eULL,
0x00005410ff557816ULL, 0x110fe40000000050ULL, 0x00007610ff577816ULL, 0x000fe20000000050ULL,
0x00006be27f007947ULL, 0x000fea000b800000ULL, 0x00001f5a2f2d7589ULL, 0x0002a400000e0000ULL,
0x00006c327f007947ULL, 0x000fea000b800000ULL, 0x00001f5c2f2b7589ULL, 0x00072400000e0000ULL,
0x0000002d33287223ULL, 0x084fe20000010028ULL, 0x0000002d38277223ULL, 0x080fe20000010027ULL,
0x0000002d35267223ULL, 0x080fe20000010026ULL, 0x0000002d3a257223ULL, 0x080fe20000010025ULL,
0x0000002d37247223ULL, 0x080fe20000010024ULL, 0x0000002d40237223ULL, 0x080fe20000010023ULL,
0x0000002d39227223ULL, 0x080fe20000010022ULL, 0x0000002d42217223ULL, 0x080fe20000010021ULL,
0x0000002d3b207223ULL, 0x080fe20000010020ULL, 0x0000002d441f7223ULL, 0x080fe2000001001fULL,
0x0000002d3f1e7223ULL, 0x080fe2000001001eULL, 0x0000002d461d7223ULL, 0x080fe2000001001dULL,
0x0000002d411c7223ULL, 0x080fe2000001001cULL, 0x0000002d481b7223ULL, 0x080fe2000001001bULL,
0x0000002d431a7223ULL, 0x080fe2000001001aULL, 0x0000002d4a197223ULL, 0x000fe20000010019ULL,
0x0000002b45187223ULL, 0x090fe20000010018ULL, 0x0000002b52177223ULL, 0x080fe20000010017ULL,
0x0000002b47167223ULL, 0x080fe20000010016ULL, 0x0000002b54157223ULL, 0x080fe20000010015ULL,
0x0000002b4b147223ULL, 0x080fe20000010014ULL, 0x0000002b56137223ULL, 0x080fe20000010013ULL,
0x0000002b4d127223ULL, 0x080fe20000010012ULL, 0x0000002b34117223ULL, 0x080fe20000010011ULL,
0x0000002b4f107223ULL, 0x080fe20000010010ULL, 0x0000002b4c0f7223ULL, 0x080fe2000001000fULL,
0x0000002b510e7223ULL, 0x080fe2000001000eULL, 0x0000002b4e0d7223ULL, 0x080fe2000001000dULL,
0x0000002b530c7223ULL, 0x080fe2000001000cULL, 0x0000002b580b7223ULL, 0x080fe2000001000bULL,
0x0000002b550a7223ULL, 0x080fe2000001000aULL, 0x0000002b57027223ULL, 0x000fe20000010002ULL,
0xfffff24000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x000000ff3c00720cULL, 0x000fe20003f05270ULL,
0x0000001000067824ULL, 0x004fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fc80000011600ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c00077812ULL, 0x000fca00078ec0ffULL,
0x0000000107087824ULL, 0x000fe200078e0206ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000067824ULL, 0x004fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011600ULL, 0x0000007006007812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fc600078ec0ffULL, 0x0000008049007824ULL, 0x000fc800078e0200ULL,
0x0000000107077824ULL, 0x000fca00078e0200ULL, 0x0049803607007388ULL, 0x0005e40000000800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800008007984ULL, 0x000f280000000800ULL,
0x004a000008077984ULL, 0x004ea20000000800ULL, 0x00000000ff007221ULL, 0x010fc80000010000ULL,
0x0000000700007221ULL, 0x004fca0000010000ULL, 0x0180000000067810ULL, 0x000fc80007ffe0ffULL,
0x7f80000006067812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0600780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff427224ULL, 0x000fe200078e0000ULL, 0x0000f35000067802ULL, 0x000fe40000000f00ULL,
0x00006cd000007944ULL, 0x02afea0003c00000ULL, 0x000000ffff067224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000077308ULL, 0x000ea40000001000ULL,
0xbf80000000067423ULL, 0x004fc80000000007ULL, 0x800000ff06067221ULL, 0x000fc80000010100ULL,
0x0000000607067223ULL, 0x000fe40000000007ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000800437811ULL, 0x004fe400078ff0ffULL, 0x00000002ff337819ULL, 0x000fe40000011600ULL,
0x00000043ff457212ULL, 0x000fe200078e33ffULL, 0x00001f4306097589ULL, 0x000ea200000e0000ULL,
0x0000000843087824ULL, 0x000fc400078e00ffULL, 0x0000000833477824ULL, 0x000fe200078e00ffULL,
0x00001f3306077589ULL, 0x00086400000e0000ULL, 0xfffffff808457812ULL, 0x000fca00078ee245ULL,
0x0000001045457824ULL, 0x000fe200078e0204ULL, 0x00000033ff067212ULL, 0x010fc800078e33ffULL,
0xfffffff847477812ULL, 0x000fe200078ee206ULL, 0x0000000833067824ULL, 0x000fe200078e00ffULL,
0x0000001809187220ULL, 0x044fe20000410000ULL, 0x0000001709177220ULL, 0x040fe20000410000ULL,
0x0000001609167220ULL, 0x040fe20000410000ULL, 0x0000001509157220ULL, 0x040fe20000410000ULL,
0x0000001409147220ULL, 0x040fe20000410000ULL, 0x0000001309137220ULL, 0x040fe20000410000ULL,
0x0000001209127220ULL, 0x040fe20000410000ULL, 0x0000001109117220ULL, 0x040fe20000410000ULL,
0x0000001009107220ULL, 0x040fe20000410000ULL, 0x0000000f090f7220ULL, 0x040fe20000410000ULL,
0x0000000e090e7220ULL, 0x040fe20000410000ULL, 0x0000000d090d7220ULL, 0x040fe20000410000ULL,
0x0000000c090c7220ULL, 0x040fe20000410000ULL, 0x0000000b090b7220ULL, 0x040fe20000410000ULL,
0x0000000a090a7220ULL, 0x040fe20000410000ULL, 0x0000000209097220ULL, 0x000fe20000410000ULL,
0x0000000733027812ULL, 0x000fe200078ec0ffULL, 0x0000002807287220ULL, 0x042fe20000410000ULL,
0x0000002707277220ULL, 0x040fe20000410000ULL, 0x0000002607267220ULL, 0x040fe20000410000ULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000002207227220ULL, 0x040fe20000410000ULL,
0x0000002107217220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000001f071f7220ULL, 0x040fe20000410000ULL, 0x0000001e071e7220ULL, 0x040fe20000410000ULL,
0x0000001d071d7220ULL, 0x040fe20000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000001b071b7220ULL, 0x040fe20000410000ULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x0000001907077220ULL, 0x000fe20000410000ULL, 0x0000000e0d0d723eULL, 0x000fc400000010ffULL,
0x0000000c0b0b723eULL, 0x000fe400000010ffULL, 0x0000000a0909723eULL, 0x000fe400000010ffULL,
0xfffffff806197812ULL, 0x000fe400078ee233ULL, 0x0000000102067812ULL, 0x040fe400078e3cffULL,
0x0000000202087812ULL, 0x040fe200078e3cffULL, 0x0000001019197824ULL, 0x000fe200078e0204ULL,
0x00000003020a7812ULL, 0x040fe200078e3cffULL, 0x0000000833297824ULL, 0x040fe200078e0206ULL,
0x00000004020c7812ULL, 0x040fe200078e3cffULL, 0x00000008332b7824ULL, 0x040fe200078e0208ULL,
0x00000005020e7812ULL, 0x040fe200078e3cffULL, 0x00000008332d7824ULL, 0x040fe200078e020aULL,
0x0000000602027812ULL, 0x000fe200078e3cffULL, 0x00000008332f7824ULL, 0x008fe200078e020cULL,
0x000000121111723eULL, 0x000fe200000010ffULL, 0x0000000833317824ULL, 0x000fe200078e020eULL,
0x0000000743127812ULL, 0x000fe200078ec0ffULL, 0x0000000833337824ULL, 0x000fe200078e0202ULL,
0x000000141313723eULL, 0x000fe200000010ffULL, 0x0000000843147824ULL, 0x000fe200078e00ffULL,
0x000000100f0f723eULL, 0x000fe200000010ffULL, 0x0000000400107824ULL, 0x000fe200078e00ffULL,
0x0000000112027812ULL, 0x040fe200078e3cffULL, 0x0000001029297824ULL, 0x100fe200078e0204ULL,
0x0000000212067812ULL, 0x040fe200078e3cffULL, 0x000000102b2b7824ULL, 0x000fe200078e0204ULL,
0x0000000312087812ULL, 0x040fe200078e3cffULL, 0x0000000843377824ULL, 0x040fe200078e0202ULL,
0x00000004120a7812ULL, 0x040fe200078e3cffULL, 0x0000000843397824ULL, 0x040fe200078e0206ULL,
0x00000005120c7812ULL, 0x040fe200078e3cffULL, 0x00000008433b7824ULL, 0x040fe200078e0208ULL,
0x00000006120e7812ULL, 0x000fe200078e3cffULL, 0x00000008433f7824ULL, 0x000fe200078e020aULL,
0x0000001c1b1b723eULL, 0x000fe200000010ffULL, 0x0000000843417824ULL, 0x040fe200078e020cULL,
0xfffffff814357812ULL, 0x000fe200078ee243ULL, 0x0000000843437824ULL, 0x000fe200078e020eULL,
0x0000000c101c7812ULL, 0x000fe200078ec0ffULL, 0x0000001047067824ULL, 0x100fe200078e0204ULL,
0x000000282727723eULL, 0x000fe200000010ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0204ULL,
0x000000262525723eULL, 0x000fe200000010ffULL, 0x0000001035357824ULL, 0x100fe200078e0204ULL,
0x000000242323723eULL, 0x000fe200000010ffULL, 0x000000011c027824ULL, 0x000fe200078e0219ULL,
0x000000222121723eULL, 0x000fe200000010ffULL, 0x000000102f2f7824ULL, 0x100fe200078e0204ULL,
0x000000201f1f723eULL, 0x000fe200000010ffULL, 0x0000001031317824ULL, 0x100fe200078e0204ULL,
0x0000001e1d1d723eULL, 0x000fe200000010ffULL, 0x0000001033337824ULL, 0x100fe200078e0204ULL,
0x0000002702007388ULL, 0x0003e20000000800ULL, 0x0000001037377824ULL, 0x100fe200078e0204ULL,
0x0000001a0707723eULL, 0x000fe200000010ffULL, 0x0000001039397824ULL, 0x100fe200078e0204ULL,
0x000000181717723eULL, 0x000fe200000010ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0204ULL,
0x000000161515723eULL, 0x000fe200000010ffULL, 0x000000103f3f7824ULL, 0x000fc400078e0204ULL,
0x0000001041417824ULL, 0x100fe400078e0204ULL, 0x0000001043437824ULL, 0x000fe400078e0204ULL,
0x000000011c107824ULL, 0x040fe400078e0206ULL, 0x000000011c047824ULL, 0x040fe400078e0229ULL,
0x000000011c067824ULL, 0x040fe400078e022bULL, 0x000000011c087824ULL, 0x040fe200078e022dULL,
0x0000002504007388ULL, 0x0005e20000000800ULL, 0x000000011c0a7824ULL, 0x000fc400078e022fULL,
0x000000011c0c7824ULL, 0x040fe200078e0231ULL, 0x0000002306007388ULL, 0x000fe20000000800ULL,
0x000000011c0e7824ULL, 0x040fe400078e0233ULL, 0x000000011c127824ULL, 0x040fe200078e0235ULL,
0x0000002108007388ULL, 0x000fe20000000800ULL, 0x000000011c147824ULL, 0x040fe400078e0237ULL,
0x000000011c027824ULL, 0x042fe200078e0239ULL, 0x0000001f0a007388ULL, 0x000fe20000000800ULL,
0x000000011c167824ULL, 0x000fc400078e023bULL, 0x000000011c187824ULL, 0x040fe200078e023fULL,
0x0000001d0c007388ULL, 0x000fe20000000800ULL, 0x000000011c1e7824ULL, 0x040fe400078e0245ULL,
0x000000011c1a7824ULL, 0x040fe200078e0241ULL, 0x0000001b0e007388ULL, 0x000fe20000000800ULL,
0x000000011c1c7824ULL, 0x000fe400078e0243ULL, 0x000000013d207824ULL, 0x000fe200078e0200ULL,
0x0000000710007388ULL, 0x0003e60000000800ULL, 0x0000001020047824ULL, 0x004fe200078e0203ULL,
0x0000001712007388ULL, 0x000fe80000000800ULL, 0x0000001514007388ULL, 0x000fe20000000800ULL,
0x000000050510723eULL, 0x002fc600000010ffULL, 0x0000001302007388ULL, 0x000fe80000000800ULL,
0x0000001116007388ULL, 0x000fe80000000800ULL, 0x0000000f18007388ULL, 0x000fe80000000800ULL,
0x0000000d1a007388ULL, 0x000fe80000000800ULL, 0x0000000b1c007388ULL, 0x000fe80000000800ULL,
0x000000091e007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000004207984ULL, 0x000e680000000c00ULL, 0x0004000004287984ULL, 0x000ea80000000c00ULL,
0x0008000004247984ULL, 0x000ee80000000c00ULL, 0x000c0000042c7984ULL, 0x000f220000000c00ULL,
0x3f803f8010237831ULL, 0x002fc40000200023ULL, 0x3f803f8010227831ULL, 0x040fe40000200022ULL,
0x3f803f8010217831ULL, 0x040fe40000200021ULL, 0x3f803f8010207831ULL, 0x040fe40000200020ULL,
0x3f803f80102b7831ULL, 0x044fe4000020002bULL, 0x3f803f80102a7831ULL, 0x040fe4000020002aULL,
0x3f803f8010297831ULL, 0x000fc40000200029ULL, 0x3f803f8010287831ULL, 0x000fe40000200028ULL,
0x3f803f8023237831ULL, 0x008fe40000200027ULL, 0x3f803f8022227831ULL, 0x000fe40000200026ULL,
0x3f803f8021217831ULL, 0x000fe40000200025ULL, 0x3f803f8020207831ULL, 0x000fe40000200024ULL,
0x3f803f802b2b7831ULL, 0x010fc4000020002fULL, 0x3f803f802a2a7831ULL, 0x000fe2000020002eULL,
0x0000002004007388ULL, 0x0003e20000000c00ULL, 0x3f803f8029297831ULL, 0x000fe4000020002dULL,
0x3f803f8028287831ULL, 0x000fca000020002cULL, 0x0004002804007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff4900720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000167919ULL, 0x000ee20000002600ULL,
0x0000002000157810ULL, 0x040fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000f220000002700ULL,
0x0000004000177810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x00000003ff057819ULL, 0x000fe20000011600ULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x0000006000217810ULL, 0x002fe20007ffe0ffULL, 0x000000083c207824ULL, 0x040fe200078e00ffULL,
0x00000003ff067819ULL, 0x000fe20000011615ULL, 0x000000083c227824ULL, 0x000fe200078e00ffULL,
0x00000003ff097819ULL, 0x000fc40000011617ULL, 0x00000003ff147819ULL, 0x000fe40000011621ULL,
0x0000000706077812ULL, 0x000fe400078e4815ULL, 0x00000007090a7812ULL, 0x000fe400078e4817ULL,
0x00000007140b7812ULL, 0x000fe400078e4821ULL, 0x0ffffff807087812ULL, 0x000fe400078ef815ULL,
0x0ffffff80a0a7812ULL, 0x000fe200078ef817ULL, 0x0000001016047824ULL, 0x008fe200078e00ffULL,
0x0ffffff80b0c7812ULL, 0x000fe200078ef821ULL, 0x0000001008087824ULL, 0x100fe200078e0203ULL,
0x00000004050472a4ULL, 0x010fe2000f8e023fULL, 0x000000100a0a7824ULL, 0x000fe200078e0203ULL,
0xfffffff004047812ULL, 0x000fe200078ee205ULL, 0x000000083c0b7824ULL, 0x000fe200078e00ffULL,
0x0000000705057812ULL, 0x100fe200078e4800ULL, 0x0000000008107984ULL, 0x004fe20000000c00ULL,
0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001016077824ULL, 0x000fe200078e00ffULL,
0x0ffffff805027812ULL, 0x100fe200078ef800ULL, 0x000000100c057824ULL, 0x100fe200078e0203ULL,
0x000000000a187984ULL, 0x000fe20000000c00ULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee200ULL,
0x0000001016007824ULL, 0x000fe200078e00ffULL, 0xfffffff007067812ULL, 0x000fe200078ee206ULL,
0x0000001002027824ULL, 0x000fe200078e0203ULL, 0x00000000051c7984ULL, 0x000fe20000000c00ULL,
0x0000001016237824ULL, 0x000fe200078e00ffULL, 0xfffffff000097812ULL, 0x000fe200078ee209ULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00000000020c7984ULL, 0x0002a20000000c00ULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff023147812ULL, 0x000fc400078ee214ULL,
0x0000000409007c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000414147c10ULL, 0x000fe4000ff5e0ffULL,
0x00005a0004027a11ULL, 0x002fe200078040ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0xfffffff820157812ULL, 0x000fe200078ee215ULL, 0x000000ffff097224ULL, 0x000fe200010e06ffULL,
0x00005b0004037a11ULL, 0x000fe400000f4403ULL, 0x0000000406057c10ULL, 0x000fc4000ff1e0ffULL,
0x00005a0000067a11ULL, 0x000fe200078240ffULL, 0x000000100b027825ULL, 0x000fe200078e0002ULL,
0x00005a0014087a11ULL, 0x000fe400078440ffULL, 0xfffffff822177812ULL, 0x000fe200078ee217ULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x00005a0005047a11ULL, 0x040fe400078040ffULL,
0x00005b0000077a11ULL, 0x000fe400008f4407ULL, 0x00005b0005057a11ULL, 0x000fc400000f440aULL,
0xfffffff83c217812ULL, 0x000fe200078ee221ULL, 0x0000001017067825ULL, 0x000fe200078e0006ULL,
0x00005b0014097a11ULL, 0x000fc600010f4409ULL, 0x0000001015047825ULL, 0x000fc800078e0004ULL,
0x0000001021087825ULL, 0x000fe200078e0008ULL, 0x0000000c02007986ULL, 0x004fe8000c101d08ULL,
0x0000001004007986ULL, 0x000fe8000c101d08ULL, 0x0000001806007986ULL, 0x000fe8000c101d08ULL,
0x0000001c08007986ULL, 0x000fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006800ff067624ULL, 0x000fe200078e00ffULL, 0x03ffffff02057812ULL, 0x004fe200078ec0ffULL,
0x00006900ff077624ULL, 0x000fc400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000000434367824ULL, 0x000fe200078e0205ULL, 0x00000008063a7981ULL, 0x000368000c1e9900ULL,
0x000000353600720cULL, 0x000fe40003f06070ULL, 0x0000000134007810ULL, 0x000fd60007ffe0ffULL,
0x0000000224058824ULL, 0x000fc800078e00ffULL, 0x0000640005048a24ULL, 0x000fc800078e0236ULL,
0x0000600004048625ULL, 0x000fca00078e0011ULL, 0x0000000804388981ULL, 0x000362000c1e1900ULL,
0x000000370000720cULL, 0x000fe20003f06070ULL, 0x000000403f397824ULL, 0x000fe400078e00ffULL,
0x0000004041127824ULL, 0x000fe400078e00ffULL, 0x00000040023b7824ULL, 0x000fd000078e00ffULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x002e620000000000ULL,
0x0000003812127224ULL, 0x020fe200078e0239ULL, 0x0000100002157811ULL, 0x000fe200078e68ffULL,
0x00000080ff1a7424ULL, 0x000fe400078e00ffULL, 0x0000010034007824ULL, 0x000fca00078e023bULL,
0x0000000003097217ULL, 0x000fca0007800000ULL, 0x0000000109007824ULL, 0x000fe200078e0a00ULL,
0x00000002ff1f7819ULL, 0x102fe20000011610ULL, 0x0000001010217824ULL, 0x000fe200078e00ffULL,
0x00000003ff137819ULL, 0x000fe40000011610ULL, 0x0000003f1f057812ULL, 0x040fe400078ec0ffULL,
0x000000081f0f7810ULL, 0x040fe40007ffe0ffULL, 0x000000101f237810ULL, 0x000fe20007ffe0ffULL,
0x0000000112057824ULL, 0x000fe200078e0205ULL, 0x0000003021217812ULL, 0x000fe200078ec0ffULL,
0x000000040f147824ULL, 0x040fe200078e00ffULL, 0x0000003f0f077812ULL, 0x000fe200078ec0ffULL,
0x00005e0005047625ULL, 0x000fe200078e001aULL, 0x0000003f230b7812ULL, 0x000fc400078ec0ffULL,
0x000000181f257810ULL, 0x040fe20007ffe0ffULL, 0x0000000112077824ULL, 0x000fe200078e0207ULL,
0x00000021040a7210ULL, 0x080fe20007f1e0ffULL, 0x0000000112087824ULL, 0x000fe200078e020bULL,
0x000000201f197810ULL, 0x000fe20007ffe0ffULL, 0x00005e0007067625ULL, 0x080fe200078e001aULL,
0x0000000313137812ULL, 0x000fe400078e4810ULL, 0x000000281f1b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0605ULL, 0x0000003f25057812ULL, 0x000fe200078ec0ffULL,
0x00005e0008087625ULL, 0x000fe200078e001aULL, 0x00000021060c7210ULL, 0x000fc40007f1e0ffULL,
0x000000301f1d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000112057824ULL, 0x000fe200078e0205ULL,
0x0000002108087210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0607ULL,
0x0000003f19077812ULL, 0x000fe200078ec0ffULL, 0x00005e0005047625ULL, 0x000fe200078e001aULL,
0x000000001f00720cULL, 0x0c0fe40003f06070ULL, 0x000000381f1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000112077824ULL, 0x000fe200078e0207ULL, 0x00000021040e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000000f00720cULL, 0x000fe20003f26070ULL,
0x00005e0007067625ULL, 0x000fe200078e001aULL, 0x0ffffffc13047812ULL, 0x000fc400078ef810ULL,
0x000000002300720cULL, 0x080fe20003fa6070ULL, 0x000000ffff0f7224ULL, 0x000fe200010e0605ULL,
0x0000003f1b057812ULL, 0x000fe200078ec0ffULL, 0x0000001004177824ULL, 0x000fe200078e0215ULL,
0x0000002106107210ULL, 0x000fe20007f7e0ffULL, 0x000000041d167824ULL, 0x000fe200078e00ffULL,
0xfffffffc14067812ULL, 0x000fe200078ee213ULL, 0x0000000112057824ULL, 0x000fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a177faeULL, 0x0003e2000c101c48ULL,
0x000000ffff117224ULL, 0x000fe200018e0607ULL, 0x000000002500720cULL, 0x000fe20003f86070ULL,
0x00005e0005047625ULL, 0x000fe200078e001aULL, 0x000000001900720cULL, 0x000fc40003f66070ULL,
0x000000001b00720cULL, 0x080fe20003f46070ULL, 0x0000001006077824ULL, 0x000fe200078e0215ULL,
0x000000001f00720cULL, 0x080fe20003f06070ULL, 0x000000041b147824ULL, 0x000fe200078e00ffULL,
0xfffffffc16167812ULL, 0x000fe200078ee213ULL, 0x000000041f187824ULL, 0x000fe200078e00ffULL,
0x0000003f1d0b7812ULL, 0x042fe200078ec0ffULL, 0x000000000c077faeULL, 0x0003e2000c901c48ULL,
0x00000021040a7210ULL, 0x000fe20007fde0ffULL, 0x00000010161b7824ULL, 0x000fe200078e0215ULL,
0x000000001d00720cULL, 0x000fe20003f26070ULL, 0x0000000112047824ULL, 0x000fe200078e020bULL,
0xfffffffc14147812ULL, 0x000fe200078ee213ULL, 0x000000ffff0b7224ULL, 0x000fe200030e0605ULL,
0xfffffffc18187812ULL, 0x000fe200078ee213ULL, 0x00005e0004047625ULL, 0x000fe200078e001aULL,
0x0000003f1f077812ULL, 0x002fc600078ec0ffULL, 0x0000000423007824ULL, 0x000fe200078e00ffULL,
0x0000002104047210ULL, 0x000fe20007fde0ffULL, 0x00000004250c7824ULL, 0x000fe400078e00ffULL,
0x0000000112077824ULL, 0x000fe200078e0207ULL, 0xfffffffc00007812ULL, 0x100fe200078ee213ULL,
0x0000000419127824ULL, 0x000fe200078e00ffULL, 0xfffffffc0c0c7812ULL, 0x000fe200078ee213ULL,
0x00005e0007067625ULL, 0x000fc600078e001aULL, 0xfffffffc12127812ULL, 0x000fe200078ee213ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x0000002106067210ULL, 0x000fe20007fde0ffULL,
0x00000010000d7824ULL, 0x100fe400078e0215ULL, 0x000000100c137824ULL, 0x100fe400078e0215ULL,
0x0000001012177824ULL, 0x100fe200078e0215ULL, 0x00000000080d7faeULL, 0x0003e2000e901c48ULL,
0x0000001014197824ULL, 0x100fe400078e0215ULL, 0x0000001018157824ULL, 0x000fe200078e0215ULL,
0x000000000e137faeULL, 0x0003e2000e101c48ULL, 0x000000ffff077224ULL, 0x000fc600030e0607ULL,
0x0000000010177faeULL, 0x0003e8000d901c48ULL, 0x000000000a197faeULL, 0x0003e8000d101c48ULL,
0x00000000041b7faeULL, 0x0003e8000c901c48ULL, 0x0000000006157faeULL, 0x0003e2000c101c48ULL,
0x000005a000007947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x002e620000000000ULL,
0x0000003812127224ULL, 0x020fe200078e0239ULL, 0x00000002ff047819ULL, 0x002fc40000011600ULL,
0x00000003ff057819ULL, 0x000fe40000011600ULL, 0x0000003f04077812ULL, 0x040fe400078ec0ffULL,
0x0000000804067810ULL, 0x040fe40007ffe0ffULL, 0x0000001004097810ULL, 0x040fe40007ffe0ffULL,
0x00000018040c7810ULL, 0x040fe40007ffe0ffULL, 0x00000020040f7810ULL, 0x000fc40007ffe0ffULL,
0x0000002804107810ULL, 0x000fe20007ffe0ffULL, 0x000000040c1c7824ULL, 0x000fe200078e00ffULL,
0x0000003004157810ULL, 0x040fe20007ffe0ffULL, 0x000000040f207824ULL, 0x000fe200078e00ffULL,
0x0000003804187810ULL, 0x000fe20007ffe0ffULL, 0x0000000112047824ULL, 0x000fe200078e0207ULL,
0x0000003f06077812ULL, 0x040fe200078ec0ffULL, 0x0000000406067824ULL, 0x000fe200078e00ffULL,
0x0000003f090b7812ULL, 0x000fe200078ec0ffULL, 0x0000000410227824ULL, 0x000fe200078e00ffULL,
0x0000003f0c0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000112087824ULL, 0x040fe200078e0207ULL,
0x0000003f0f117812ULL, 0x000fe200078ec0ffULL, 0x00000001120a7824ULL, 0x000fe200078e020bULL,
0x0000003f10137812ULL, 0x000fe200078ec0ffULL, 0x00000001120e7824ULL, 0x040fe200078e020dULL,
0x0000003f15177812ULL, 0x000fe200078ec0ffULL, 0x0000000112147824ULL, 0x000fe200078e0211ULL,
0x0000003f18197812ULL, 0x000fe200078ec0ffULL, 0x0000000112167824ULL, 0x040fe200078e0213ULL,
0x0000000305077812ULL, 0x100fe200078e4800ULL, 0x00000001121a7824ULL, 0x000fe200078e0217ULL,
0x00001000020b7811ULL, 0x000fe200078e68ffULL, 0x00000001121e7824ULL, 0x000fe200078e0219ULL,
0xfffffffc06067812ULL, 0x100fe200078ee207ULL, 0x0000000409127824ULL, 0x000fe200078e00ffULL,
0xfffffffc1c107812ULL, 0x100fe200078ee207ULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x0ffffffc07007812ULL, 0x000fe200078ef800ULL, 0x0000000415267824ULL, 0x000fe200078e00ffULL,
0xfffffffc120c7812ULL, 0x100fe200078ee207ULL, 0x0000000418287824ULL, 0x000fe200078e00ffULL,
0xfffffffc20127812ULL, 0x000fe200078ee207ULL, 0x00000080ff137424ULL, 0x000fe200078e00ffULL,
0x0000003005157812ULL, 0x000fe200078ec0ffULL, 0x0000001006197824ULL, 0x000fe200078e020bULL,
0xfffffffc22187812ULL, 0x100fe200078ee207ULL, 0x00005e0004047625ULL, 0x000fe200078e0013ULL,
0xfffffffc261c7812ULL, 0x000fc400078ee207ULL, 0xfffffffc28207812ULL, 0x000fe200078ee207ULL,
0x00005e0008067625ULL, 0x000fe200078e0013ULL, 0x0000001504047210ULL, 0x000fc60007f1e0ffULL,
0x0000001000177824ULL, 0x100fe200078e020bULL, 0x0000001506067210ULL, 0x000fe20007f3e0ffULL,
0x000000100c1b7824ULL, 0x100fe400078e020bULL, 0x00000010101d7824ULL, 0x100fe400078e020bULL,
0x00000010121f7824ULL, 0x100fe400078e020bULL, 0x0000001018217824ULL, 0x000fe400078e020bULL,
0x00005e000a087625ULL, 0x000fc800078e0013ULL, 0x000000101c237824ULL, 0x100fe200078e020bULL,
0x0000001508087210ULL, 0x000fe20007f5e0ffULL, 0x0000001020257824ULL, 0x000fe400078e020bULL,
0x00005e000e0a7625ULL, 0x000fc800078e0013ULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x000000150a0a7210ULL, 0x000fe20007f1e0ffULL, 0x00005e00140c7625ULL, 0x000fc600078e0013ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004177faeULL, 0x0003e2000b901c48ULL,
0x00005e00160e7625ULL, 0x000fc800078e0013ULL, 0x00005e001a107625ULL, 0x000fc800078e0013ULL,
0x00005e001e127625ULL, 0x000fc800078e0013ULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x000000150c0c7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x000000150e0e7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000001510107210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000001512127210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x0000000006197faeULL, 0x0003e2000b901c48ULL, 0x000000ffff117224ULL, 0x000fc400010e0611ULL,
0x000000ffff137224ULL, 0x000fe200018e0613ULL, 0x00000000081b7faeULL, 0x0003e8000b901c48ULL,
0x000000000a1d7faeULL, 0x0003e8000b901c48ULL, 0x000000000c1f7faeULL, 0x0003e8000b901c48ULL,
0x000000000e217faeULL, 0x0003e8000b901c48ULL, 0x0000000010237faeULL, 0x0003e8000b901c48ULL,
0x0000000012257faeULL, 0x0003e4000b901c48ULL, 0x00f60400ff007984ULL, 0x000ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000000ff7812ULL, 0x004fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x00f60400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000030200780cULL, 0x000fda0003f04070ULL, 0x0000017000000947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x002e640000000000ULL, 0x0000002002007824ULL, 0x002fc800078e0205ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7800ULL,
0x0000000707077812ULL, 0x000fc600078e7800ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001005007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ffff7f8cULL, 0x000fe8000c80043fULL, 0x00f60400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x00f60400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000373400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000003c7919ULL, 0x000ea20000000000ULL,
0x3db504f33a3a7820ULL, 0x000fe20000410000ULL, 0x0000640024437a24ULL, 0x000fe200078e02ffULL,
0xffffffff37417810ULL, 0x000fe20007ffe0ffULL, 0x0000001002407824ULL, 0x000fe200078e00ffULL,
0x00007610ff3d7816ULL, 0x000fe2000000003dULL, 0x000000ffff3f7224ULL, 0x000fe200078e00ffULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x0000000604047899ULL, 0x000fe4000800063fULL,
0x00000100343e7824ULL, 0x000fe200078e023bULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000003e0300720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x028fea0003800000ULL,
0x000000ffff457224ULL, 0x000fe200078e003fULL, 0x0000000000207805ULL, 0x002fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fc4000001ff00ULL,
0x0000000100247810ULL, 0x000fe20007ffe0ffULL, 0x00000bb000007945ULL, 0x000fe20003800000ULL,
0x000000ffff427224ULL, 0x000fe200078e0000ULL, 0x00000001453f7812ULL, 0x000fc400078e0cffULL,
0x00000001ff257819ULL, 0x100fe20000011624ULL, 0x000000ffff007224ULL, 0x000fe200078e0024ULL,
0x000000022400780cULL, 0x040fe40003f06070ULL, 0x0000000124547812ULL, 0x000fe200078ec0ffULL,
0x0000030025287a24ULL, 0x000fca00078e0234ULL, 0x0000000128267810ULL, 0x000fc80007ffe0ffULL,
0x000000372600720cULL, 0x000fda0003f26070ULL, 0x000005e000009947ULL, 0x020fea0003800000ULL,
0x0000010028247824ULL, 0x000fe200078e023bULL, 0x00000002ff2f7819ULL, 0x004fe2000001163cULL,
0x00000004382a7c24ULL, 0x000fe4000f8e0239ULL, 0x0000000454317824ULL, 0x000fe200078e00ffULL,
0x0000002403257217ULL, 0x000fe20007800000ULL, 0x0000000202297824ULL, 0x000fe200078e023fULL,
0x000000082f2b7810ULL, 0x040fe20007ffe0ffULL, 0x00000080ff517424ULL, 0x000fe200078e00ffULL,
0x0000003f2f277812ULL, 0x000fe200078ec0ffULL, 0x0000000125287824ULL, 0x000fe200078e0a24ULL,
0x00000003ff257819ULL, 0x100fe2000001163cULL, 0x000000042b2e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc31317812ULL, 0x100fe200078ee23cULL, 0x000000012a247824ULL, 0x000fe200078e0227ULL,
0x0000000325337812ULL, 0x000fc400078e483cULL, 0x0000003f2b257812ULL, 0x000fe400078ec0ffULL,
0x000000282f00720cULL, 0x080fe40003f26070ULL, 0x000000282b00720cULL, 0x000fe20003f46070ULL,
0x000000012a267824ULL, 0x000fe200078e0225ULL, 0x0000100029297811ULL, 0x000fe200078e60ffULL,
0x00005e0024247625ULL, 0x080fe200078e0051ULL, 0x0ffffffc332c7812ULL, 0x000fe400078ef83cULL,
0xfffffffc2e2e7812ULL, 0x000fe200078ee233ULL, 0x00005e0026267625ULL, 0x000fe200078e0051ULL,
0x000000102f477810ULL, 0x000fc40007ffe0ffULL, 0x000000182f497810ULL, 0x040fe20007ffe0ffULL,
0x000000102c2b7824ULL, 0x000fe200078e0229ULL, 0x000000202f4b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001031247825ULL, 0x000fe200078e0024ULL, 0x000000282f4d7810ULL, 0x040fe40007ffe0ffULL,
0x000000302f4f7810ULL, 0x040fe20007ffe0ffULL, 0x000000102e2d7824ULL, 0x000fe200078e0229ULL,
0x000000382f537810ULL, 0x000fe20007ffe0ffULL, 0x0000001031267825ULL, 0x000fe200078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242b7faeULL, 0x0003e2000c901c48ULL,
0x0000003f4f2f7812ULL, 0x000fc400078ec0ffULL, 0x0000003f53557812ULL, 0x000fe200078ec0ffULL,
0x00000000262d7faeULL, 0x0005e2000d101c48ULL, 0x000000284700720cULL, 0x080fe20003f26070ULL,
0x000000012a447824ULL, 0x040fe200078e022fULL, 0x000000284900720cULL, 0x080fe20003f46070ULL,
0x000000012a487824ULL, 0x040fe200078e0255ULL, 0x000000284b00720cULL, 0x0c0fe20003f66070ULL,
0x000000044b2e7824ULL, 0x000fe200078e00ffULL, 0x000000284d00720cULL, 0x0c0fe20003f86070ULL,
0x000000044d327824ULL, 0x000fe200078e00ffULL, 0x0000003f47257812ULL, 0x002fe200078ec0ffULL,
0x000000044f467824ULL, 0x000fe200078e00ffULL, 0x0000003f4b2b7812ULL, 0x000fe200078ec0ffULL,
0x0000000447267824ULL, 0x004fe200078e00ffULL, 0x0000003f49277812ULL, 0x000fe200078ec0ffULL,
0x000000012a247824ULL, 0x040fe200078e0225ULL, 0x0000003f4d2d7812ULL, 0x000fe200078ec0ffULL,
0x000000012a2c7824ULL, 0x040fe200078e022bULL, 0x000000284f00720cULL, 0x080fe20003fa6070ULL,
0x00000004534a7824ULL, 0x040fe200078e00ffULL, 0x000000285300720cULL, 0x000fe20003fc6070ULL,
0x000000012a287824ULL, 0x000fe200078e0227ULL, 0xfffffffc26267812ULL, 0x000fe200078ee233ULL,
0x000000012a307824ULL, 0x000fe200078e022dULL, 0xfffffffc2e2e7812ULL, 0x100fe200078ee233ULL,
0x00000004492a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc32327812ULL, 0x100fe200078ee233ULL,
0x00005e0024247625ULL, 0x000fe200078e0051ULL, 0xfffffffc46467812ULL, 0x000fc400078ee233ULL,
0xfffffffc2a2a7812ULL, 0x000fe200078ee233ULL, 0x000000102e497824ULL, 0x000fe200078e0229ULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee233ULL, 0x0000001026337824ULL, 0x100fe400078e0229ULL,
0x000000102a477824ULL, 0x100fe400078e0229ULL, 0x00000010324b7824ULL, 0x100fe400078e0229ULL,
0x00000010464d7824ULL, 0x100fe400078e0229ULL, 0x000000104a4f7824ULL, 0x000fc400078e0229ULL,
0x00005e0028267625ULL, 0x000fc800078e0051ULL, 0x00005e002c287625ULL, 0x000fc800078e0051ULL,
0x00005e00302a7625ULL, 0x000fc800078e0051ULL, 0x00005e00442c7625ULL, 0x000fc800078e0051ULL,
0x00005e00482e7625ULL, 0x000fc800078e0051ULL, 0x0000001031247825ULL, 0x000fc800078e0024ULL,
0x0000001031267825ULL, 0x040fe200078e0026ULL, 0x0000000024337faeULL, 0x0003e6000c901c48ULL,
0x0000001031287825ULL, 0x040fe200078e0028ULL, 0x0000000026477faeULL, 0x0003e6000d101c48ULL,
0x00000010312a7825ULL, 0x040fe200078e002aULL, 0x0000000028497faeULL, 0x0003e6000d901c48ULL,
0x00000010312c7825ULL, 0x040fe200078e002cULL, 0x000000002a4b7faeULL, 0x0003e6000e101c48ULL,
0x00000010312e7825ULL, 0x000fe200078e002eULL, 0x000000002c4d7faeULL, 0x0003e8000e901c48ULL,
0x000000002e4f7faeULL, 0x0003e2000f101c48ULL, 0x0000052000007947ULL, 0x000fea0003800000ULL,
0x00000002ff247819ULL, 0x004fe2000001163cULL, 0x0000000438257c24ULL, 0x000fc4000f8e0239ULL,
0x0000000454477824ULL, 0x000fe200078e00ffULL, 0x0000003f24267812ULL, 0x040fe200078ec0ffULL,
0x00000080ff337424ULL, 0x000fe200078e00ffULL, 0x0000000824287810ULL, 0x040fe40007ffe0ffULL,
0x00000010242b7810ULL, 0x040fe40007ffe0ffULL, 0x00000018242d7810ULL, 0x040fe40007ffe0ffULL,
0x00000020242f7810ULL, 0x040fe40007ffe0ffULL, 0x0000002824317810ULL, 0x000fc40007ffe0ffULL,
0x0000003024497810ULL, 0x040fe40007ffe0ffULL, 0x00000038244b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000125247824ULL, 0x000fe200078e0226ULL, 0x0000003f28267812ULL, 0x040fe200078ec0ffULL,
0x0000000428287824ULL, 0x000fe200078e00ffULL, 0x0000003f2b2c7812ULL, 0x000fe200078ec0ffULL,
0x000000044b527824ULL, 0x000fe200078e00ffULL, 0x0000003f2d2e7812ULL, 0x000fe200078ec0ffULL,
0x00000001252a7824ULL, 0x000fe200078e0226ULL, 0x0000003f2f327812ULL, 0x000fe200078ec0ffULL,
0x00000001252c7824ULL, 0x000fe200078e022cULL, 0x0000003f31467812ULL, 0x000fe200078ec0ffULL,
0x0000000125307824ULL, 0x000fe200078e022eULL, 0x0000003f494a7812ULL, 0x000fe200078ec0ffULL,
0x0000000125447824ULL, 0x000fe200078e0232ULL, 0x0000003f4b4e7812ULL, 0x000fe200078ec0ffULL,
0x0000000125487824ULL, 0x000fe200078e0246ULL, 0xfffffffc47477812ULL, 0x000fe200078ee23cULL,
0x00000001254c7824ULL, 0x000fc400078e024aULL, 0x0000000125507824ULL, 0x000fe200078e024eULL,
0x00000003ff257819ULL, 0x100fe2000001163cULL, 0x0000000202267824ULL, 0x000fe400078e023fULL,
0x000000042b2e7824ULL, 0x000fe200078e00ffULL, 0x0000000325277812ULL, 0x100fe200078e483cULL,
0x000000042d327824ULL, 0x000fe200078e00ffULL, 0x0000100026297811ULL, 0x000fe200078e60ffULL,
0x000000042f467824ULL, 0x000fe200078e00ffULL, 0x0ffffffc27267812ULL, 0x000fe200078ef83cULL,
0x00000004314a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc28287812ULL, 0x100fe200078ee227ULL,
0x00000004494e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc2e2e7812ULL, 0x100fe200078ee227ULL,
0x00005e0024247625ULL, 0x000fe200078e0033ULL, 0xfffffffc32327812ULL, 0x000fc400078ee227ULL,
0xfffffffc46467812ULL, 0x000fe200078ee227ULL, 0x0000001026497824ULL, 0x000fe200078e0229ULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee227ULL, 0x00000010284b7824ULL, 0x000fe200078e0229ULL,
0xfffffffc4e4e7812ULL, 0x000fe200078ee227ULL, 0x000000102e4d7824ULL, 0x000fe200078e0229ULL,
0xfffffffc52527812ULL, 0x000fe200078ee227ULL, 0x00000010324f7824ULL, 0x100fe400078e0229ULL,
0x0000001046517824ULL, 0x100fe400078e0229ULL, 0x000000104a537824ULL, 0x000fc400078e0229ULL,
0x000000104e557824ULL, 0x100fe400078e0229ULL, 0x0000001052577824ULL, 0x000fe400078e0229ULL,
0x00005e002a267625ULL, 0x000fc800078e0033ULL, 0x00005e002c287625ULL, 0x000fc800078e0033ULL,
0x00005e00302a7625ULL, 0x000fc800078e0033ULL, 0x00005e00442c7625ULL, 0x000fc800078e0033ULL,
0x00005e00482e7625ULL, 0x000fc800078e0033ULL, 0x0000001047247825ULL, 0x000fc800078e0024ULL,
0x00005e004c307625ULL, 0x080fe200078e0033ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024497faeULL, 0x0003e6000b901c48ULL, 0x00005e0050327625ULL, 0x000fc800078e0033ULL,
0x0000001047267825ULL, 0x000fc800078e0026ULL, 0x0000001047287825ULL, 0x040fe200078e0028ULL,
0x00000000264b7faeULL, 0x0003e6000b901c48ULL, 0x00000010472a7825ULL, 0x040fe200078e002aULL,
0x00000000284d7faeULL, 0x0003e6000b901c48ULL, 0x00000010472c7825ULL, 0x040fe200078e002cULL,
0x000000002a4f7faeULL, 0x0003e6000b901c48ULL, 0x00000010472e7825ULL, 0x040fe200078e002eULL,
0x000000002c517faeULL, 0x0003e6000b901c48ULL, 0x0000001047307825ULL, 0x040fe200078e0030ULL,
0x000000002e537faeULL, 0x0003e6000b901c48ULL, 0x0000001047327825ULL, 0x000fe200078e0032ULL,
0x0000000030557faeULL, 0x0003e8000b901c48ULL, 0x0000000032577faeULL, 0x0003e4000b901c48ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5400720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x00000004ff257424ULL, 0x002fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000030025367a24ULL, 0x000fca00078e0236ULL, 0x000000353600720cULL, 0x000fda0003f26070ULL,
0x0000003000001947ULL, 0x000fea0003800000ULL, 0x0000000243247824ULL, 0x000fc800078e0236ULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x0000000824387981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000842497824ULL, 0x002fe400078e00ffULL, 0x000000ffff477224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff83c257812ULL, 0x000fe200078ec0ffULL,
0x0000000202297824ULL, 0x000fe200078e0245ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000001472b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000725257812ULL, 0x000fe400078ef83cULL,
0x0000100029297811ULL, 0x000fc400078e60ffULL, 0x00000001ff247819ULL, 0x000fe40000011625ULL,
0x000000073ccf7812ULL, 0x000fe400078ec0ffULL, 0x0000000324247812ULL, 0x000fe400078ec0ffULL,
0x00000008cfcf7812ULL, 0x000fe400078ef83cULL, 0x0000004724267212ULL, 0x040fe400078e3cffULL,
0x0000002b24247212ULL, 0x000fc600078e3cffULL, 0x0000000425267824ULL, 0x040fe400078e0226ULL,
0x0000000425247824ULL, 0x000fe200078e0224ULL, 0x000000203c257810ULL, 0x000fe20007ffe0ffULL,
0x0000001026267824ULL, 0x100fe400078e0229ULL, 0x0000001024247824ULL, 0x000fe200078e0229ULL,
0xfffffff825257812ULL, 0x000fe400078ec0ffULL, 0x000000002630783bULL, 0x000e640000000200ULL,
0x0000000725287812ULL, 0x000fc400078ef83cULL, 0x00000000242c783bULL, 0x0004e40000000200ULL,
0x00000001ff247819ULL, 0x004fc80000011628ULL, 0x00000003242a7812ULL, 0x000fc800078ec0ffULL,
0x000000472a257212ULL, 0x040fe400078e3cffULL, 0x0000002b2a2b7212ULL, 0x000fe400078e3cffULL,
0x0000000247477810ULL, 0x000fe20007ffe0ffULL, 0x0000000428247824ULL, 0x040fe400078e0225ULL,
0x0000000428287824ULL, 0x000fe400078e022bULL, 0x0000001024247824ULL, 0x100fe400078e0229ULL,
0x0000001028287824ULL, 0x000fc800078e0229ULL, 0x000000002424783bULL, 0x000ea80000000200ULL,
0x000000002828783bULL, 0x000f220000000200ULL, 0x0000003000747306ULL, 0x002fe20000009400ULL,
0x00000018ffab7819ULL, 0x000fe20000011430ULL, 0x0001000030607824ULL, 0x000fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe20000011431ULL, 0x0000010032af7824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011432ULL, 0x0001000033ae7824ULL, 0x040fe200078e00ffULL,
0x00000018ffb27819ULL, 0x000fe20000011460ULL, 0x0000003000b37306ULL, 0x000e620000005400ULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x0000010033aa7824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe20000011433ULL, 0x000100002c7b7824ULL, 0x048fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x000100002d7e7824ULL, 0x040fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x00000030005f7306ULL, 0x0006a2000000d400ULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x000001002c807824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x000001002d817824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe2000001142cULL, 0x000100002e757824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x000000b200b47306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x008fe200078e00ffULL, 0x000000b37400720bULL, 0x002fe20003f9d000ULL,
0x000001002e6d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fc4000001142eULL,
0x00000018ffb67819ULL, 0x000fe20000011430ULL, 0x0001000031307824ULL, 0x000fe200078e00ffULL,
0x000000b200b57306ULL, 0x000e620000205400ULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x00000018ff9c7819ULL, 0x004fe20000011424ULL, 0x0001000024c87824ULL, 0x000fe200078e00ffULL,
0x00000018ffbb7819ULL, 0x000fe20000011430ULL, 0x0001000032307824ULL, 0x000fe200078e00ffULL,
0x000000015f5f4812ULL, 0x000fe200078efcffULL, 0x000000b600b77306ULL, 0x000fe20000209400ULL,
0x00000018ffc87819ULL, 0x000fc400000114c8ULL, 0x00000018ffc17819ULL, 0x000fe40000011430ULL,
0x00000018ff997819ULL, 0x000fe40000011425ULL, 0x00000018ff967819ULL, 0x000fe20000011426ULL,
0x000000b600b87306ULL, 0x000ea20000205400ULL, 0x000000b5b400720bULL, 0x002fe20003f5d000ULL,
0x0000010027b57824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe40000011427ULL,
0x00000018ff647819ULL, 0x000fc4000001142dULL, 0x00000018ffb57819ULL, 0x000fe200000114b5ULL,
0x0000003100a77306ULL, 0x000fe20000009400ULL, 0x00000018ff507819ULL, 0x000fe4000001142fULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff6d7819ULL, 0x000fc6000001146dULL,
0x0000003100a47306ULL, 0x000e620000005400ULL, 0x000000b8b700720bULL, 0x004fce0003f7d000ULL,
0x00000031005e7306ULL, 0x0004f0000000d400ULL, 0x000000ab00b97306ULL, 0x000fe20000209400ULL,
0x0000010031317824ULL, 0x004fe200078e00ffULL, 0x000000a4a700720bULL, 0x002fc40003f3d000ULL,
0x000000b600a77245ULL, 0x000fe4000020d400ULL, 0x00000018ffbe7819ULL, 0x000fe40000011431ULL,
0x000000ab00ba7306ULL, 0x000e620000205400ULL, 0x000000b200a47245ULL, 0x000fe4000020d400ULL,
0x00000001a7a73812ULL, 0x000fe400078efcffULL, 0x00000001a4a42812ULL, 0x000fe400078efcffULL,
0x000000015e5e1812ULL, 0x008fe200078efcffULL, 0x000000bb00bc7306ULL, 0x000ff00000209400ULL,
0x000000bb00bd7306ULL, 0x000ea20000205400ULL, 0x000000bab900720bULL, 0x002fce0003fdd000ULL,
0x000000be00bf7306ULL, 0x000ff00000209400ULL, 0x000000be00c07306ULL, 0x000e620000205400ULL,
0x000000bdbc00720bULL, 0x004fce0003fbd000ULL, 0x0000003200a57306ULL, 0x000ff00000009400ULL,
0x0000003200a67306ULL, 0x000ea20000005400ULL, 0x000000c0bf00720bULL, 0x002fce0003f7d000ULL,
0x000000a300ad7306ULL, 0x000ff00000209400ULL, 0x000000a300ac7306ULL, 0x000e620000205400ULL,
0x000000a6a500720bULL, 0x004fe40003f5d000ULL, 0x000000ab00a67245ULL, 0x000fc4000020d400ULL,
0x000000bb00a57245ULL, 0x000fe4000020d400ULL, 0x00000001a6a66812ULL, 0x000fe200078efcffULL,
0x0000003300a17306ULL, 0x000fe20000009400ULL, 0x00000001a5a55812ULL, 0x000fc800078efcffULL,
0x0000005ea55e723eULL, 0x000fc600000010ffULL, 0x0000003300a27306ULL, 0x000ea20000005400ULL,
0x000000acad00720bULL, 0x002fe20003f9d000ULL, 0x0001000026ac7824ULL, 0x000fca00078e00ffULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x0000002c009d7306ULL, 0x000ff00000009400ULL,
0x0000002c00a07306ULL, 0x000e620000005400ULL, 0x000000a2a100720bULL, 0x004fc40003fdd000ULL,
0x000000be00a17245ULL, 0x000fe4000020d400ULL, 0x0000009300a27245ULL, 0x000fe4000020d400ULL,
0x00000001a1a13812ULL, 0x000fe200078efcffULL, 0x000000c100c27306ULL, 0x000ff00000209400ULL,
0x000000c100c37306ULL, 0x000ea20000205400ULL, 0x000000a09d00720bULL, 0x002fe20003f3d000ULL,
0x00000100269d7824ULL, 0x000fe200078e00ffULL, 0x000000a300a07245ULL, 0x000fe2000020d400ULL,
0x0001000027a37824ULL, 0x000fc600078e00ffULL, 0x00000001a0a04812ULL, 0x000fe200078efcffULL,
0x000000af00c47306ULL, 0x000fe20000209400ULL, 0x00000018ffa37819ULL, 0x000fce00000114a3ULL,
0x000000af00c57306ULL, 0x000e620000205400ULL, 0x000000c3c200720bULL, 0x004fce0003fbd000ULL,
0x00000093009f7306ULL, 0x000ff00000209400ULL, 0x00000093009e7306ULL, 0x000ea20000205400ULL,
0x000000c5c400720bULL, 0x002fce0003f7d000ULL, 0x00000024008d7306ULL, 0x000ff00000009400ULL,
0x0000002400947306ULL, 0x000fe20000005400ULL, 0x0000009e9f00720bULL, 0x004fe40003f9d000ULL,
0x000000c1009e7245ULL, 0x000fc4000020d400ULL, 0x00000018ff9f7819ULL, 0x000fe4000001149dULL,
0x000000af009d7245ULL, 0x000fe2000020d400ULL, 0x0000002400567306ULL, 0x0003e2000000d400ULL,
0x000000019e9e5812ULL, 0x000fe400078efcffULL, 0x000000019d9d3812ULL, 0x000fe400078efcffULL,
0x0000008800af7245ULL, 0x000fe4000020d400ULL, 0x00000001a2a24812ULL, 0x000fe200078efcffULL,
0x00000032005b7306ULL, 0x0004e2000000d400ULL, 0x0000010024247824ULL, 0x002fca00078e00ffULL,
0x00000018ffcb7819ULL, 0x000fe20000011424ULL, 0x0001000025247824ULL, 0x000fe200078e00ffULL,
0x0000008800957306ULL, 0x000fe20000209400ULL, 0x000001002f327824ULL, 0x004fc600078e00ffULL,
0x00000018ffce7819ULL, 0x000fe40000011424ULL, 0x000000493c247211ULL, 0x000fe400078fe0ffULL,
0x0000008800927306ULL, 0x000e620000205400ULL, 0x000000015b5b2812ULL, 0x008fe400078efcffULL,
0x0000000224747810ULL, 0x040fe40007ffe0ffULL, 0x0000000724247812ULL, 0x100fe400078e78cfULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x000000ae00c67306ULL, 0x000fe20000209400ULL,
0x0000000774747812ULL, 0x000fe200078e78cfULL, 0x00000010cf247824ULL, 0x000fe200078e0224ULL,
0x0000000449497810ULL, 0x000fc60007ffe0ffULL, 0x0000001024247824ULL, 0x000fe400078e00ffULL,
0x000000ae00c77306ULL, 0x0004e20000205400ULL, 0x000000929500720bULL, 0x002fe20003f5d000ULL,
0x00000010cf747824ULL, 0x000fcc00078e0274ULL, 0x000000aa00b17306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x004fca000020d400ULL, 0x00000001afaf2812ULL, 0x000fe400078efcffULL,
0x000000aa00b07306ULL, 0x0002a20000205400ULL, 0x000000c7c600720bULL, 0x008fce0003fbd000ULL,
0x000000c800c97306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x002fca000020d400ULL,
0x00000001aeae5812ULL, 0x000fe400078efcffULL, 0x000000c800ca7306ULL, 0x000e620000205400ULL,
0x000000b0b100720bULL, 0x004fe40003f7d000ULL, 0x000000948d00720bULL, 0x000fe40003fbd000ULL,
0x000000c8008d7245ULL, 0x000fc6000020d400ULL, 0x0000003300577306ULL, 0x0004ec000000d400ULL,
0x00000001aaaa3812ULL, 0x000fe400078efcffULL, 0x0000009c00a97306ULL, 0x000fe20000209400ULL,
0x000000cac900720bULL, 0x002fe20003f9d000ULL, 0x000100002f337824ULL, 0x004fe200078e00ffULL,
0x0000000156565812ULL, 0x000fc400078efcffULL, 0x000000aaafaf723eULL, 0x000fe400000010ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0000009c00a87306ULL, 0x0002a20000205400ULL,
0x0000000157576812ULL, 0x008fc800078efcffULL, 0x00000057aeae723eULL, 0x000fe400000010ffULL,
0x000000018d8d4812ULL, 0x000fe200078efcffULL, 0x000000ce00b37306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fe4000020d400ULL, 0x000000568d56723eULL, 0x000fca00000010ffULL,
0x000000ce00b47306ULL, 0x000e620000205400ULL, 0x000000a8a900720bULL, 0x004fce0003fdd000ULL,
0x000000cb00cc7306ULL, 0x000fec0000209400ULL, 0x000000019c9c6812ULL, 0x000fe400078efcffULL,
0x000000cb00cd7306ULL, 0x0004e20000205400ULL, 0x000000b4b300720bULL, 0x002fce0003f5d000ULL,
0x00000025008e7306ULL, 0x000fe20000009400ULL, 0x000000cb00cb7245ULL, 0x004fce000020d400ULL,
0x0000002500897306ULL, 0x000e620000005400ULL, 0x000000cdcc00720bULL, 0x008fce0003f7d000ULL,
0x00000099009a7306ULL, 0x000fec0000209400ULL, 0x00000001cbcb3812ULL, 0x000fe400078efcffULL,
0x00000099009b7306ULL, 0x0004e20000205400ULL, 0x000000898e00720bULL, 0x002fe40003f9d000ULL,
0x000000ce008e7245ULL, 0x000fc4000020d400ULL, 0x000000cb9c57723eULL, 0x000fe400000010ffULL,
0x000000018e8e2812ULL, 0x000fe200078efcffULL, 0x0000002600857306ULL, 0x000fe20000009400ULL,
0x0000009900997245ULL, 0x004fce000020d400ULL, 0x0000002600867306ULL, 0x000e620000005400ULL,
0x0000009b9a00720bULL, 0x008fce0003fdd000ULL, 0x00000026004f7306ULL, 0x000eac000000d400ULL,
0x0000000199996812ULL, 0x000fe400078efcffULL, 0x000000ac00ad7306ULL, 0x000fe20000209400ULL,
0x000000868500720bULL, 0x002fe40003f7d000ULL, 0x00000018ff857819ULL, 0x010fca000001142aULL,
0x000000ac00267306ULL, 0x000e6c0000205400ULL, 0x000000014f4f3812ULL, 0x004fe400078efcffULL,
0x0000002500557306ULL, 0x0004f0000000d400ULL, 0x0000002700797306ULL, 0x000fe20000009400ULL,
0x0000010025257824ULL, 0x004fe200078e00ffULL, 0x00000026ad00720bULL, 0x002fc80003f5d000ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000027007a7306ULL, 0x000fe20000005400ULL,
0x0000000155554812ULL, 0x008fe400078efcffULL, 0x0000002500887245ULL, 0x000fe4000020d400ULL,
0x000000558e8e723eULL, 0x000fc600000010ffULL, 0x00000027004e7306ULL, 0x000ff0000000d400ULL,
0x0000009f00277306ULL, 0x000ff00000209400ULL, 0x0000009f00927306ULL, 0x000e700000205400ULL,
0x000000a300937306ULL, 0x000ff00000209400ULL, 0x000000a300947306ULL, 0x0004e20000205400ULL,
0x000000922700720bULL, 0x002fc40003f9d000ULL, 0x000000ac00927245ULL, 0x000fc8000020d400ULL,
0x0000000192922812ULL, 0x000fe200078efcffULL, 0x0000002500b27306ULL, 0x000fe20000209400ULL,
0x0000007a7900720bULL, 0x000fe40003f5d000ULL, 0x000000a300a37245ULL, 0x004fe4000020d400ULL,
0x0000009f007a7245ULL, 0x000fe4000020d400ULL, 0x0000004f9292723eULL, 0x000fe200000010ffULL,
0x0000002500ab7306ULL, 0x000e620000205400ULL, 0x000000949300720bULL, 0x008fc40003fdd000ULL,
0x000000017a7a4812ULL, 0x000fe400078efcffULL, 0x0000009600937245ULL, 0x000fe4000020d400ULL,
0x000000014e4e2812ULL, 0x000fe200078efcffULL, 0x000000b500897306ULL, 0x000fec0000209400ULL,
0x00000001a3a36812ULL, 0x000fc400078efcffULL, 0x000000b500267306ULL, 0x0004e20000205400ULL,
0x000000abb200720bULL, 0x002fe40003fbd000ULL, 0x0000004ea34e723eULL, 0x000fca00000010ffULL,
0x0000008700907306ULL, 0x000fe20000209400ULL, 0x000000b500b57245ULL, 0x004fca000020d400ULL,
0x0000000188885812ULL, 0x000fe400078efcffULL, 0x0000008700917306ULL, 0x000e620000205400ULL,
0x000000268900720bULL, 0x008fe20003f7d000ULL, 0x0001000028897824ULL, 0x000fe200078e00ffULL,
0x000000002424783bULL, 0x000ea80000000200ULL, 0x00000018ff897819ULL, 0x000fe20000011489ULL,
0x0000007b008c7306ULL, 0x000fec0000209400ULL, 0x00000001b5b53812ULL, 0x000fc400078efcffULL,
0x0000007b008f7306ULL, 0x000ee20000205400ULL, 0x000000919000720bULL, 0x002fce0003fdd000ULL,
0x0000002c004d7306ULL, 0x000330000000d400ULL, 0x0000009600987306ULL, 0x000fe20000209400ULL,
0x0000008f8c00720bULL, 0x008fe40003f5d000ULL, 0x00000018ff2c7819ULL, 0x002fc40000011428ULL,
0x00000088998f723eULL, 0x000fc600000010ffULL, 0x0000009600977306ULL, 0x000e620000205400ULL,
0x000000014d4d1812ULL, 0x010fe200078efcffULL, 0x000000ae2414723cULL, 0x044fec0000041814ULL,
0x0000007e007f7306ULL, 0x000fe40000209400ULL, 0x000000562410723cULL, 0x040fec0000041810ULL,
0x0000007e00827306ULL, 0x000ea20000205400ULL, 0x000000979800720bULL, 0x002fe20003fbd000ULL,
0x0000008e240c723cULL, 0x000fec000004180cULL, 0x0000002d00737306ULL, 0x000fec0000009400ULL,
0x0000000193935812ULL, 0x000fc400078efcffULL, 0x0000002d00767306ULL, 0x000e620000005400ULL,
0x000000827f00720bULL, 0x004fe20003f3d000ULL, 0x00000100297f7824ULL, 0x000fe200078e00ffULL,
0x0000007a9393723eULL, 0x000fe200000010ffULL, 0x000001002a827824ULL, 0x000fc600078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x00000080008b7306ULL, 0x000fe20000209400ULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x000000922408723cULL, 0x000fec0000041808ULL,
0x00000080008a7306ULL, 0x000ea20000205400ULL, 0x000000767300720bULL, 0x002fc40003f9d000ULL,
0x0000008700767245ULL, 0x000fe4000020d400ULL, 0x00000018ff737819ULL, 0x000fe4000001142bULL,
0x0000000176766812ULL, 0x000fe200078efcffULL, 0x0000002f00627306ULL, 0x000fe60000009400ULL,
0x000000b5764f723eULL, 0x000fca00000010ffULL, 0x0000002f00637306ULL, 0x000e620000005400ULL,
0x0000008a8b00720bULL, 0x004fe20003f7d000ULL, 0x0000004e2404723cULL, 0x000fe20000041804ULL,
0x0000007b008a7245ULL, 0x000fe4000020d400ULL, 0x00000080008b7245ULL, 0x000fe2000020d400ULL,
0x000100002a807824ULL, 0x000fe200078e00ffULL, 0x000000018a8a2812ULL, 0x000fe200078efcffULL,
0x0000006600677306ULL, 0x000fe60000209400ULL, 0x00000018ff807819ULL, 0x000fc40000011480ULL,
0x0000004d8a8a723eULL, 0x000fe400000010ffULL, 0x000000018b8b3812ULL, 0x000fe200078efcffULL,
0x00000066006a7306ULL, 0x0004e20000205400ULL, 0x000000636200720bULL, 0x002fe20003fdd000ULL,
0x0001000029627824ULL, 0x000fe200078e00ffULL, 0x0000007e00637245ULL, 0x000fc8000020d400ULL,
0x0000000163631812ULL, 0x000fe200078efcffULL, 0x0000002e00727306ULL, 0x000fe20000009400ULL,
0x0000006600667245ULL, 0x004fce000020d400ULL, 0x0000002e00717306ULL, 0x000e620000005400ULL,
0x0000006a6700720bULL, 0x008fce0003f5d000ULL, 0x0000005a006c7306ULL, 0x000fec0000209400ULL,
0x0000000166662812ULL, 0x000fe400078efcffULL, 0x0000005a00697306ULL, 0x0004e20000205400ULL,
0x000000717200720bULL, 0x002fe40003fbd000ULL, 0x0000008b668b723eULL, 0x000fca00000010ffULL,
0x0000008100837306ULL, 0x000fe20000209400ULL, 0x0000005a005a7245ULL, 0x004fce000020d400ULL,
0x0000008100847306ULL, 0x0002a20000205400ULL, 0x000000696c00720bULL, 0x008fce0003f3d000ULL,
0x0000006400687306ULL, 0x000fe20000209400ULL, 0x0000008100817245ULL, 0x002fca000020d400ULL,
0x000000015a5a1812ULL, 0x000fe400078efcffULL, 0x0000006400657306ULL, 0x0002e20000205400ULL,
0x000000848300720bULL, 0x004fe20003f7d000ULL, 0x000100002b837824ULL, 0x040fe400078e00ffULL,
0x000001002b847824ULL, 0x000fc600078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011483ULL,
0x0000002e004b7306ULL, 0x000ea2000000d400ULL, 0x0000006400647245ULL, 0x002fe4000020d400ULL,
0x00000018ff847819ULL, 0x000fc60000011484ULL, 0x0000000181813812ULL, 0x000fe400078efcffULL,
0x00000033006f7306ULL, 0x000fe20000209400ULL, 0x000000656800720bULL, 0x008fe40003f5d000ULL,
0x00000018ff687819ULL, 0x000fe40000011462ULL, 0x0000007500627245ULL, 0x000fc6000020d400ULL,
0x0000003300707306ULL, 0x0002e20000205400ULL, 0x000000014b4b5812ULL, 0x004fca00078efcffULL,
0x0000000164642812ULL, 0x000fe400078efcffULL, 0x0000003200607306ULL, 0x000fe20000209400ULL,
0x0000003300337245ULL, 0x002fe4000020d400ULL, 0x00000081644d723eULL, 0x000fca00000010ffULL,
0x0000003200617306ULL, 0x0002a20000205400ULL, 0x000000706f00720bULL, 0x008fce0003fbd000ULL,
0x00000028005d7306ULL, 0x000fe20000009400ULL, 0x0000003200327245ULL, 0x002fca000020d400ULL,
0x0000000133335812ULL, 0x000fe400078efcffULL, 0x00000028005c7306ULL, 0x000fe20000005400ULL,
0x000000616000720bULL, 0x004fce0003f3d000ULL, 0x00000028004a7306ULL, 0x0003ec000000d400ULL,
0x0000000132321812ULL, 0x000fe400078efcffULL, 0x0000002d004c7306ULL, 0x0004e2000000d400ULL,
0x0000010028287824ULL, 0x002fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011428ULL,
0x00000050006b7306ULL, 0x000fe20000209400ULL, 0x00000018ff2d7819ULL, 0x004fe40000011429ULL,
0x0000005fa428723eULL, 0x000fe400000010ffULL, 0x000000a1a05f723eULL, 0x000fc600000010ffULL,
0x00000050006e7306ULL, 0x000e620000205400ULL, 0x000000014c4c4812ULL, 0x008fc600078efcffULL,
0x0000005e241c723cULL, 0x000fe2000004181cULL, 0x0000004c634c723eULL, 0x000fc600000010ffULL,
0x00000075007c7306ULL, 0x000ff00000209400ULL, 0x00000075007d7306ULL, 0x000ea20000205400ULL,
0x0000006e6b00720bULL, 0x002fce0003f9d000ULL, 0x0000002900597306ULL, 0x000ff00000009400ULL,
0x0000002900587306ULL, 0x000fe20000005400ULL, 0x0000007d7c00720bULL, 0x004fce0003f7d000ULL,
0x0000002900487306ULL, 0x0003ec000000d400ULL, 0x0000000162623812ULL, 0x000fe400078efcffULL,
0x0000006d00777306ULL, 0x000fe20000209400ULL, 0x000000a7a629723eULL, 0x002fe400000010ffULL,
0x0000005c5d00720bULL, 0x000fc40003f7d000ULL, 0x0000004b6262723eULL, 0x000fc600000010ffULL,
0x0000006d00787306ULL, 0x0002a20000205400ULL, 0x000000282420723cULL, 0x000fee0000041820ULL,
0x0000002a00527306ULL, 0x000fe20000009400ULL, 0x0000005b9e28723eULL, 0x000fe400000010ffULL,
0x0000009da229723eULL, 0x000fc400000010ffULL, 0x0000006d006d7245ULL, 0x002fe4000020d400ULL,
0x000000014a4a3812ULL, 0x000fe200078efcffULL, 0x0000002a00517306ULL, 0x000e620000005400ULL,
0x000000787700720bULL, 0x004fe20003f5d000ULL, 0x000000282418723cULL, 0x000fec0000041818ULL,
0x00000089007b7306ULL, 0x000fe20000209400ULL, 0x0000001074287824ULL, 0x000fe200078e00ffULL,
0x0000006800277245ULL, 0x000fc4000020d400ULL, 0x0000002d00267245ULL, 0x000fe4000020d400ULL,
0x000000016d6d2812ULL, 0x000fe400078efcffULL, 0x00000089006a7306ULL, 0x0004e20000205400ULL,
0x000000515200720bULL, 0x002fe40003fbd000ULL, 0x0000005000517245ULL, 0x000fe4000020d400ULL,
0x000000585900720bULL, 0x000fe40003f5d000ULL, 0x0000000151514812ULL, 0x000fe200078efcffULL,
0x00000067007e7306ULL, 0x000fe20000209400ULL, 0x0000008900897245ULL, 0x004fc4000020d400ULL,
0x000000325125723eULL, 0x000fe400000010ffULL, 0x0000006d5a63723eULL, 0x000fc600000010ffULL,
0x0000006700657306ULL, 0x0002a20000205400ULL, 0x0000006a7b00720bULL, 0x008fe40003f3d000ULL,
0x0000000148482812ULL, 0x000fca00078efcffULL, 0x0000002c00307306ULL, 0x000fe20000209400ULL,
0x0000006700677245ULL, 0x002fca000020d400ULL, 0x0000000189891812ULL, 0x000fe400078efcffULL,
0x0000002c00317306ULL, 0x0002e20000205400ULL, 0x000000657e00720bULL, 0x004fe40003f9d000ULL,
0x0000004a894a723eULL, 0x000fca00000010ffULL, 0x0000002f00427306ULL, 0x000ea2000000d400ULL,
0x0000002c002c7245ULL, 0x002fca000020d400ULL, 0x0000000167674812ULL, 0x000fe400078efcffULL,
0x0000002a00447306ULL, 0x000e62000000d400ULL, 0x000000313000720bULL, 0x008fce0003f3d000ULL,
0x0000002b00547306ULL, 0x000fe20000009400ULL, 0x0000000142426812ULL, 0x004fc800078efcffULL,
0x000000423324723eULL, 0x000fe400000010ffULL, 0x000000012c2c1812ULL, 0x000fe200078efcffULL,
0x0000002b00537306ULL, 0x000ea20000005400ULL, 0x0000000144445812ULL, 0x002fe400078efcffULL,
0x000000672c4b723eULL, 0x000fe400000010ffULL, 0x00000085002c7245ULL, 0x000fc6000020d400ULL,
0x0000002b00467306ULL, 0x0002f0000000d400ULL, 0x0000002d002e7306ULL, 0x000fe20000209400ULL,
0x000000002828783bULL, 0x002e620000000200ULL, 0x000000535400720bULL, 0x004fcc0003fdd000ULL,
0x0000002d002f7306ULL, 0x00052e0000205400ULL, 0x0000000146466812ULL, 0x008fe200078efcffULL,
0x0000006800697306ULL, 0x000fe20000209400ULL, 0x00000080002d7245ULL, 0x004fce000020d400ULL,
0x00000068006c7306ULL, 0x000ea20000205400ULL, 0x0000002f2e00720bULL, 0x010fce0003f9d000ULL,
0x0000007f005b7306ULL, 0x000fec0000209400ULL, 0x0000000126264812ULL, 0x000fe400078efcffULL,
0x0000007f00587306ULL, 0x0007220000205400ULL, 0x0000006c6900720bULL, 0x004fe20003f7d000ULL,
0x000000242814723cULL, 0x042fec0000041814ULL, 0x0000008000597306ULL, 0x000fe20000209400ULL,
0x0000007f007f7245ULL, 0x008fe2000020d400ULL, 0x0000008a2820723cULL, 0x000fe80000041820ULL,
0x0000000127273812ULL, 0x000fc400078efcffULL, 0x0000008000527306ULL, 0x000e620000205400ULL,
0x000000585b00720bULL, 0x010fe20003f3d000ULL, 0x0000004c281c723cULL, 0x000fe2000004181cULL,
0x000000482724723eULL, 0x000fe400000010ffULL, 0x0000008200277245ULL, 0x000fc6000020d400ULL,
0x0000008500867306ULL, 0x000fe40000209400ULL, 0x000000622818723cULL, 0x040fe80000041818ULL,
0x000000017f7f1812ULL, 0x000fe400078efcffULL, 0x0000008500797306ULL, 0x000ea20000205400ULL,
0x000000525900720bULL, 0x002fe20003f5d000ULL, 0x0000004a2810723cULL, 0x000fe20000041810ULL,
0x0000007f2625723eULL, 0x000fca00000010ffULL, 0x0000008200507306ULL, 0x000fe40000209400ULL,
0x00000024280c723cULL, 0x000fe8000004180cULL, 0x000000012d2d2812ULL, 0x000fe400078efcffULL,
0x0000008200537306ULL, 0x000e620000205400ULL, 0x000000798600720bULL, 0x004fe40003f7d000ULL,
0x0000008400257245ULL, 0x000fc4000020d400ULL, 0x000000442d26723eULL, 0x000fc600000010ffULL,
0x0000007300717306ULL, 0x000fec0000209400ULL, 0x000000012c2c3812ULL, 0x000fe400078efcffULL,
0x0000007300727306ULL, 0x000ea20000205400ULL, 0x000000535000720bULL, 0x002fce0003f9d000ULL,
0x0000008300307306ULL, 0x000fec0000209400ULL, 0x0000000127274812ULL, 0x000fe400078efcffULL,
0x00000083002f7306ULL, 0x0002e20000205400ULL, 0x000000727100720bULL, 0x004fe40003f3d000ULL,
0x000000272c27723eULL, 0x000fc400000010ffULL, 0x00000073002c7245ULL, 0x000fc6000020d400ULL,
0x00000084002e7306ULL, 0x000fe20000209400ULL, 0x0000008300837245ULL, 0x002fe2000020d400ULL,
0x000000262808723cULL, 0x000fe80000041808ULL, 0x000000012c2c1812ULL, 0x000fe400078efcffULL,
0x0000008400317306ULL, 0x000e620000205400ULL, 0x0000002f3000720bULL, 0x008fe40003f5d000ULL,
0x000000044700780cULL, 0x000fd60003f25270ULL, 0x0000000183832812ULL, 0x000fe400078efcffULL,
0x000000312e00720bULL, 0x002fe40003fbd000ULL, 0x000000468324723eULL, 0x000fd600000010ffULL,
0x0000000125255812ULL, 0x000fc800078efcffULL, 0x000000252c25723eULL, 0x000fce00000010ffULL,
0x000000242804723cULL, 0x000fe20000041804ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe12000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff457224ULL, 0x000fe200078e003fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd41000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00f6140040257984ULL, 0x000e620000000800ULL, 0x0000ffff3d007812ULL, 0x000fe200078ec0ffULL,
0x0000001d3a1d7220ULL, 0x040fe20000410000ULL, 0x0000001a3a247220ULL, 0x040fe20000410000ULL,
0x000000143a147220ULL, 0x000fe20000410000ULL, 0x00008880002f7816ULL, 0x000fe200000000ffULL,
0x0000001e3a1e7220ULL, 0x040fe20000410000ULL, 0x0000001b3a267220ULL, 0x040fe20000410000ULL,
0x000000153a157220ULL, 0x040fe20000410000ULL, 0x0000000c3a1a7220ULL, 0x040fe20000410000ULL,
0x000000203a207220ULL, 0x040fe20000410000ULL, 0x000000213a217220ULL, 0x040fe20000410000ULL,
0x000000223a227220ULL, 0x040fe20000410000ULL, 0x0000001f3a1f7220ULL, 0x040fe20000410000ULL,
0x000000163a277220ULL, 0x040fe20000410000ULL, 0x000000173a287220ULL, 0x040fe20000410000ULL,
0x0000000d3a1b7220ULL, 0x040fe20000410000ULL, 0x800000002f007824ULL, 0x000fe200078e00ffULL,
0x000000233a237220ULL, 0x040fe20000410000ULL, 0x000000183a187220ULL, 0x040fe20000410000ULL,
0x000000193a197220ULL, 0x040fe20000410000ULL, 0x000000103a167220ULL, 0x040fe20000410000ULL,
0x000000113a177220ULL, 0x040fe20000410000ULL, 0x0000001c3a1c7220ULL, 0x040fe20000410000ULL,
0x000000123a297220ULL, 0x040fe20000410000ULL, 0x000000133a2a7220ULL, 0x040fe20000410000ULL,
0x0000000e3a2b7220ULL, 0x040fe20000410000ULL, 0x0000000f3a2c7220ULL, 0x040fe20000410000ULL,
0x000000083a087220ULL, 0x040fe20000410000ULL, 0x000000093a097220ULL, 0x040fe20000410000ULL,
0x0000000a3a2d7220ULL, 0x040fe20000410000ULL, 0x0000000b3a2e7220ULL, 0x040fe20000410000ULL,
0x000000043a047220ULL, 0x040fe20000410000ULL, 0x000000053a057220ULL, 0x040fe20000410000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e001dULL, 0x000000063a067220ULL, 0x040fe20000410000ULL,
0x000000ffff107224ULL, 0x000fe200078e0014ULL, 0x000000073a077220ULL, 0x000fe20000410000ULL,
0x000000ffff117224ULL, 0x000fc400078e0015ULL, 0x000000ffff147224ULL, 0x000fe200078e001aULL,
0x8000000025ff7812ULL, 0x002fe20007804800ULL, 0x000000ffff1d7224ULL, 0x000fe400078e001eULL,
0x000000ffff0b7224ULL, 0x000fe400078e0020ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0021ULL,
0x000000ffff157224ULL, 0x000fe400078e001bULL, 0x000000ffff1a7224ULL, 0x000fc400078e0022ULL,
0x000000ffff1e7224ULL, 0x000fe400078e001fULL, 0x000000ffff0e7224ULL, 0x000fe400078e0018ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0019ULL, 0x000000ffff127224ULL, 0x000fe400078e0016ULL,
0x000000ffff137224ULL, 0x000fe400078e0017ULL, 0x000000ffff1b7224ULL, 0x000fc400078e0023ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0024ULL, 0x000000ffff207224ULL, 0x000fe400078e0026ULL,
0x000000ffff217224ULL, 0x000fe400078e0027ULL, 0x000000ffff227224ULL, 0x000fe400078e0028ULL,
0x000000ffff0c7224ULL, 0x000fe400078e001cULL, 0x000000ffff167224ULL, 0x000fc400078e0008ULL,
0x000000ffff177224ULL, 0x000fe400078e0009ULL, 0x000000ffff187224ULL, 0x000fe400078e0004ULL,
0x000000ffff197224ULL, 0x000fe400078e0005ULL, 0x000000ffff237224ULL, 0x000fe400078e0029ULL,
0x000000ffff247224ULL, 0x000fe400078e002aULL, 0x000000ffff257224ULL, 0x000fc400078e002bULL,
0x000000ffff267224ULL, 0x000fe400078e002cULL, 0x000000ffff277224ULL, 0x000fe400078e002dULL,
0x000000ffff287224ULL, 0x000fe200078e002eULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000ffff297224ULL, 0x000fe400078e0006ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0007ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000002f2f7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x00f6140040047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fc4000780482fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000043c1c7824ULL, 0x000fe200078e00ffULL, 0x000000413400720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff01c057812ULL, 0x000fca00078ec0ffULL,
0x0000008002007824ULL, 0x000fca00078e0205ULL, 0x00f4000000047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x000000023c087824ULL, 0x000fe400078e00ffULL,
0x00000001033e7824ULL, 0x000fc600078e0a3eULL, 0x0000000608097812ULL, 0x000fc800078ec0ffULL,
0x00000001092b7812ULL, 0x040fe400078efcffULL, 0x00000008092d7812ULL, 0x000fe400078efcffULL,
0x0000003e2b00720cULL, 0x080fe40003f26070ULL, 0x00000010092b7812ULL, 0x000fe400078efcffULL,
0x0000003e2d00720cULL, 0x080fe40003f06070ULL, 0x0000003e2b00720cULL, 0x000fc40003fc6070ULL,
0x00000011092d7812ULL, 0x040fe400078efcffULL, 0x00000018092b7812ULL, 0x040fe400078efcffULL,
0x0000003e0900720cULL, 0x080fe40003f46070ULL, 0x0000003e2d00720cULL, 0x080fe40003fa6070ULL,
0x0000003e2b00720cULL, 0x000fe40003f66070ULL, 0x00000009092f7812ULL, 0x000fc400078efcffULL,
0x00000019092d7812ULL, 0x040fe400078efcffULL, 0x00000020092b7812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL,
0x0000003e2f00720cULL, 0x080fe40003f86070ULL, 0x0000003e2d00720cULL, 0x080fe40003f46070ULL,
0x0000003e2b00720cULL, 0x000fe40003f26070ULL, 0x00000021092d7812ULL, 0x040fe400078efcffULL,
0x00000028092b7812ULL, 0x000fe400078efcffULL, 0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL, 0x0000003e2d00720cULL, 0x080fe40003f06070ULL,
0x0000003e2b00720cULL, 0x000fe40003f86070ULL, 0x00000029092d7812ULL, 0x000fc400078efcffULL,
0x00000030092b7812ULL, 0x000fe400078efcffULL, 0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL, 0xff7fffff20207808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL, 0x0000003e2d00720cULL, 0x000fc40003fc6070ULL,
0x0000003e2b00720cULL, 0x000fe40003fa6070ULL, 0x00000031092d7812ULL, 0x040fe400078efcffULL,
0x00000038092b7812ULL, 0x040fe400078efcffULL, 0x0000003909097812ULL, 0x000fe400078efcffULL,
0xff7fffff21217808ULL, 0x000fe40005800000ULL, 0xff7fffff10107808ULL, 0x000fc40005800000ULL,
0xff7fffff22227808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40005000000ULL,
0xff7fffff23237808ULL, 0x000fe40004800000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0x0000003e2d00720cULL, 0x080fe40003f66070ULL, 0x0000003e2b00720cULL, 0x000fc40003f46070ULL,
0x0000003e0900720cULL, 0x000fe40003f26070ULL, 0xff7fffff24247808ULL, 0x000fe40004000000ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff25257808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff26267808ULL, 0x000fc40007000000ULL,
0xff7fffff15157808ULL, 0x000fe40007000000ULL, 0xff7fffff27277808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff28287808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff29297808ULL, 0x000fc40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40005000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000b04097209ULL, 0x004fe20007810000ULL, 0x0000001fff317424ULL, 0x000fe200078e00ffULL,
0x0000001a05047209ULL, 0x000fe20007810000ULL, 0xffffffffff327424ULL, 0x000fe200078e00ffULL,
0x0000000a09097209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fc40007810000ULL,
0x0000000c09087209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000000d08097209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000000e09087209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fc40007810000ULL,
0x0000000f08097209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000001009087209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fc40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x0000002304057209ULL, 0x000fe40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x0000002405047209ULL, 0x000fe40007810000ULL,
0x0000001409087209ULL, 0x000fe40007810000ULL, 0x0000002504057209ULL, 0x000fc40007810000ULL,
0x0000001508097209ULL, 0x000fe40007810000ULL, 0x0000002605047209ULL, 0x000fe40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x0000002704057209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x0000002805047209ULL, 0x000fc40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x0000002904057209ULL, 0x000fe40007810000ULL,
0x00000019082d7209ULL, 0x000fe40007810000ULL, 0x0000002a052f7209ULL, 0x000fe20007810000ULL,
0x00000ea27f007947ULL, 0x000fea000b800000ULL, 0x0c401f002d047f89ULL, 0x0004e400000e0000ULL,
0x000000042d2d7209ULL, 0x00cfe20007810000ULL, 0x00000ed27f007947ULL, 0x000fea000b800000ULL,
0x0c401f002f047f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006057f89ULL, 0x000ee800000e0000ULL,
0x0c401f00072c7f89ULL, 0x000f2200000e0000ULL, 0x000000042f087209ULL, 0x004fc60007810000ULL,
0x0c201f002d047f89ULL, 0x000ea200000e0000ULL, 0x0000000506097209ULL, 0x008fc60007810000ULL,
0x0c201f0008057f89ULL, 0x000ee200000e0000ULL, 0x0000002c072c7209ULL, 0x010fc60007810000ULL,
0x0c201f00092e7f89ULL, 0x002e6800000e0000ULL, 0x0c201f002c2b7f89ULL, 0x00092200000e0000ULL,
0x000000042d047209ULL, 0x004fe40007810000ULL, 0x0000000508057209ULL, 0x008fe40007810000ULL,
0x0000002e09067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3f80000000057882ULL, 0x000fc40000000000ULL, 0x00000005ff2e7e24ULL, 0x002fe2000f8e00ffULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x3f8000002e2e783eULL, 0x000fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL,
0x000000ffff2f7224ULL, 0x000fe200078e002eULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010819ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b2a197823ULL, 0x000fe20000010819ULL, 0x0000000000067886ULL, 0x000fc400038e0100ULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x000000080908723eULL, 0x002fce00000010ffULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x008fce00000010ffULL, 0x0000001d000b7308ULL, 0x0007f00000000800ULL,
0x0000001e001e7308ULL, 0x000f220000000800ULL, 0x0000001a1b09723eULL, 0x002fe200000010ffULL,
0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000b1e0b723eULL, 0x010fce00000010ffULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000002e0830723cULL, 0x000fee00000418ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ee20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000010ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x008fce00000010ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x0000001f200d723eULL, 0x002fce00000010ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x00000021220f723eULL, 0x008fce00000010ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x0000002e0c30723cULL, 0x000fee0000041830ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ee20000000800ULL,
0x000000121310723eULL, 0x002fce00000010ffULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002400247308ULL, 0x000e620000000800ULL, 0x000000141512723eULL, 0x008fe400000010ffULL,
0xfffffffc3c147812ULL, 0x000fc800078ec0ffULL, 0x000000141d1d7219ULL, 0x000fe200000006ffULL,
0x0000002500257308ULL, 0x000fe60000000800ULL, 0x000000001d1e73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0573c4ULL, 0x000f280000004000ULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x000000232411723eULL, 0x002fce00000010ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000252613723eULL, 0x004fce00000010ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000061dff7c12ULL, 0x008fe2000f80401eULL, 0x0000002e1030723cULL, 0x000fec0000041830ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000010ffULL, 0x0000002700277308ULL, 0x000ff00000000800ULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x000000180716723eULL, 0x004fe400000010ffULL,
0x0000002c2b077209ULL, 0x000fca0007810000ULL, 0x0000002900297308ULL, 0x000ff00000000800ULL,
0x00000019001a7308ULL, 0x000ea20000000800ULL, 0x000000272815723eULL, 0x002fe400000010ffULL,
0x000000291a17723eULL, 0x004fce00000010ffULL, 0x0000002e1420723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x000009e205008947ULL, 0x010fde000b800000ULL,
0x001c1fff20187589ULL, 0x0002a400000e0000ULL, 0x000000001d1a73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0573c4ULL, 0x000f220000004000ULL, 0x0000000000067886ULL, 0x000fe400038e0100ULL,
0x000000061dff7c12ULL, 0x008fda000f80401aULL, 0x00000a0205008947ULL, 0x010fea000b800000ULL,
0x001c1fff22197589ULL, 0x00072800000e0000ULL, 0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL,
0x001c1fff001b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1d7819ULL, 0x00afe4000001163cULL,
0x0000000c1c337812ULL, 0x000fc400078ec0ffULL, 0x000000071d1e7812ULL, 0x040fe200078ec0ffULL,
0x000000081d237824ULL, 0x040fe200078e00ffULL, 0x0000001dff217212ULL, 0x000fe200078e33ffULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0x000000033cff7812ULL, 0x000fe2000780c0ffULL,
0x000000081d2e7824ULL, 0x040fe200078e00ffULL, 0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823207812ULL, 0x100fe400078ee21eULL, 0x000000011f227812ULL, 0x100fe200078ef61eULL,
0x000000081d4a7824ULL, 0x000fe200078e00ffULL, 0x000000021f247812ULL, 0x100fe200078ef61eULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0x000000031f267812ULL, 0x000fc400078ef61eULL,
0x000000041f287812ULL, 0x140fe400078ef61eULL, 0x000000051f2a7812ULL, 0x140fe400078ef61eULL,
0x000000061f2c7812ULL, 0x000fe200078ef61eULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee221ULL, 0x0000001dff217212ULL, 0x000fe400078e33ffULL,
0x000000071d1e7812ULL, 0x000fc400078ec0ffULL, 0x00009000021d7811ULL, 0x000fe400078e58ffULL,
0xfffffff823307812ULL, 0x100fe400078ee21eULL, 0x000000011f327812ULL, 0x140fe200078ef61eULL,
0x00000010201c7824ULL, 0x000fe200078e021dULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee221ULL,
0x0000001024207824ULL, 0x100fe200078e021dULL, 0x000000021f3e7812ULL, 0x140fe200078ef61eULL,
0x0000001028247824ULL, 0x100fe200078e021dULL, 0x000000031f427812ULL, 0x140fe200078ef61eULL,
0x000000102c287824ULL, 0x100fe200078e021dULL, 0x000000041f447812ULL, 0x140fe200078ef61eULL,
0x00000010322c7824ULL, 0x100fe200078e021dULL, 0x000000051f467812ULL, 0x140fe200078ef61eULL,
0x000000103e2d7824ULL, 0x100fe200078e021dULL, 0x000000061f487812ULL, 0x000fe200078ef61eULL,
0x00000010221e7824ULL, 0x000fc400078e021dULL, 0x0000001026227824ULL, 0x100fe400078e021dULL,
0x000000102a267824ULL, 0x100fe400078e021dULL, 0x00000001331f7824ULL, 0x000fe400078e021cULL,
0x000000102e2a7824ULL, 0x100fe400078e021dULL, 0x00000010301c7824ULL, 0x100fe200078e021dULL,
0x000000081f007388ULL, 0x0003e20000000800ULL, 0x00000010422e7824ULL, 0x000fc400078e021dULL,
0x00000010442f7824ULL, 0x100fe400078e021dULL, 0x0000001046307824ULL, 0x100fe400078e021dULL,
0x0000001048317824ULL, 0x100fe400078e021dULL, 0x000000104a327824ULL, 0x000fe400078e021dULL,
0x00000001331d7824ULL, 0x040fe400078e021eULL, 0x0000000133217824ULL, 0x000fc400078e0220ULL,
0x0000000133237824ULL, 0x040fe200078e0222ULL, 0x0000000a1d007388ULL, 0x0007e20000000800ULL,
0x0000000133257824ULL, 0x040fe400078e0224ULL, 0x0000000133277824ULL, 0x040fe200078e0226ULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x0000000133297824ULL, 0x040fe400078e0228ULL,
0x00000001332b7824ULL, 0x040fe200078e022aULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x00000001331c7824ULL, 0x000fc400078e021cULL, 0x00000001332c7824ULL, 0x040fe200078e022cULL,
0x0000001025007388ULL, 0x0007e20000000800ULL, 0x00000001331e7824ULL, 0x040fe400078e022dULL,
0x00000001332e7824ULL, 0x040fe200078e022eULL, 0x0000001227007388ULL, 0x0007e20000000800ULL,
0x0000000133087824ULL, 0x042fe400078e022fULL, 0x0000000133307824ULL, 0x040fe200078e0230ULL,
0x0000001429007388ULL, 0x0007e20000000800ULL, 0x0000000133207824ULL, 0x000fc400078e0231ULL,
0x0000000133327824ULL, 0x000fe200078e0232ULL, 0x000000162b007388ULL, 0x0007e80000000800ULL,
0x000000091c007388ULL, 0x0007e80000000800ULL, 0x0000000b2c007388ULL, 0x0007e80000000800ULL,
0x0000000d1e007388ULL, 0x0007e80000000800ULL, 0x0000000f2e007388ULL, 0x0007e80000000800ULL,
0x0000001108007388ULL, 0x0007e80000000800ULL, 0x0000001330007388ULL, 0x0007e80000000800ULL,
0x0000001520007388ULL, 0x0007e80000000800ULL, 0x0000001732007388ULL, 0x0007e80000000800ULL,
0x00f0000400008388ULL, 0x0007e80000000c00ULL, 0x00f2001800008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030034347a10ULL, 0x000fe20007ffe0ffULL,
0x00f6080040ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff3dff7812ULL, 0x000fc4000780c0ffULL,
0x000000373400720cULL, 0x000fe40003f26070ULL, 0x00000001ff3d7807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffb90000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff307224ULL, 0x000fe200078e005aULL,
0x00015b40002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x0000069000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2d7224ULL, 0x004fe200078e002eULL, 0xffff93c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x002fe200078e005cULL, 0x00015bb0002a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x0000062000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2b7224ULL, 0x004fe200078e002eULL,
0xffff937000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x000fe200078e002dULL,
0x00015c1000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x000fc400078e00ffULL,
0x0000058000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002bULL,
0xfffff11000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x000fe200078e002fULL,
0x00015c7000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000052000007944ULL, 0x020fea0003c00000ULL, 0x0000002b2f307209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0006ULL, 0x00015cc000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x002fc400078e00ffULL, 0x000004d000007944ULL, 0x000fea0003c00000ULL,
0x0000002b06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0007ULL,
0x00015d1000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x0000002b072c7209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e002dULL, 0x00015d6000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x0000002b2d047209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0030ULL,
0x00015db000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x002fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x0000002b30057209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0006ULL, 0x00015e0000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000002b06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e002cULL,
0x00015e5000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0xffffefd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2f7224ULL, 0x000fe200078e0020ULL, 0x00015ec0002a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff307224ULL, 0x000fc400078e00ffULL, 0x00001c1fff317424ULL, 0x000fe400078e00ffULL,
0x000000ffff327224ULL, 0x000fe400078e001dULL, 0x0000031000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e002eULL, 0xfffff5b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2f7224ULL, 0x002fe200078e0022ULL, 0x00015f40002a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff307224ULL, 0x000fe400078e00ffULL, 0x00001c1fff317424ULL, 0x000fe400078e00ffULL,
0x000000ffff327224ULL, 0x000fe400078e001dULL, 0x0000029000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff307224ULL, 0x002fe200078e00ffULL, 0x00015fa0002a7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff317424ULL, 0x000fc400078e00ffULL, 0x000000ffff327224ULL, 0x000fe400078e001dULL,
0x000000ffff197224ULL, 0x004fe400078e002eULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff327224ULL, 0x002fe200078e001dULL, 0x00016000002a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff307224ULL, 0x000fe400078e00ffULL, 0x00001c1fff317424ULL, 0x000fe400078e00ffULL,
0x000000ffff1a7224ULL, 0x004fe400078e002eULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e002eULL, 0xfffff4f000007947ULL, 0x000fea000383ffffULL,
0x0180000042007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000004200008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff077807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000007ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff42ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000007ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000042077812ULL, 0x000fd600078ec0ffULL,
0x0080000007000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0007ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000004200007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffe9e7006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003200007348ULL, 0x000fe80003800000ULL, 0x0c00002e2b2b7389ULL, 0x0002a200000e0031ULL,
0xfffe9e3008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2b7424ULL, 0x000fe200078e00ffULL,
0x0000003200007348ULL, 0x000fe80003800000ULL, 0x000000302f2e7389ULL, 0x0002a200000e0031ULL,
0xfffe9df02a007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000778ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007f0ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e9cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ec0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ed0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ef0ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f60ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f68ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000f78ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000016300ULL, 0xf200001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017480ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000017490ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017490ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000017910ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f60ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000016520ULL, 0x0000000000016520ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017480ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000017910ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_89_cubin_len = 96752;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
