/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000206c0ULL, 0x0000000000020340ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL,
0x326d735f61647563ULL, 0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL,
0x746e695f5f240068ULL, 0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL,
0x66625f636e79736cULL, 0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL,
0x5f30376d735f6164ULL, 0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL,
0x5f5f245f335f6c61ULL, 0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL,
0x2e616c65722e0074ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL,
0x766e2e0066754265ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL,
0x65642e006d617261ULL, 0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL,
0x616c65722e00656dULL, 0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL,
0x00000000006e6f69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000037fULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000003cdULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b002200000413ULL,
0x000000000001e750ULL, 0x0000000000000180ULL, 0x000b002200000446ULL, 0x000000000001e8d0ULL,
0x0000000000000040ULL, 0x000b002200000471ULL, 0x000000000001e910ULL, 0x0000000000000050ULL,
0x000b00220000049bULL, 0x000000000001e960ULL, 0x0000000000000120ULL, 0x000a000300000509ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000529ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000559ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001ea80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001e75000000000ULL, 0x0000040400000000ULL, 0x810c000001880400ULL, 0x0078400400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001e75000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8084288080860900ULL,
0x0000000000002880ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080870828808081ULL, 0x8f082880808b0828ULL,
0x2880809208288080ULL, 0x8094082880809308ULL, 0x0828808095082880ULL, 0x8080970828808096ULL,
0xa5082880809a0828ULL, 0x288080a708288080ULL, 0x80ec08288080a908ULL, 0x08288080f2082880ULL,
0x8080f808288080f3ULL, 0x8016288080980828ULL, 0x0000000310288082ULL, 0x8098920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000000f000000000ULL, 0x0001e8d000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080870828808081ULL,
0x8f082880808b0828ULL, 0x2880809208288080ULL, 0x8094082880809308ULL, 0x0828808095082880ULL,
0x80809a0828808096ULL, 0xa808288080a50828ULL, 0x288080a908288080ULL, 0x80f208288080ec08ULL,
0x08288080f3082880ULL, 0x8080a708288080f8ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x002200288080a792ULL, 0x0000002cffffffffULL, 0x000001b800000000ULL, 0x0001e91000000000ULL,
0x0000005000000000ULL, 0x0000100400000000ULL, 0x80ec288080a70900ULL, 0x0000000000002880ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080870828808081ULL, 0x8f082880808b0828ULL, 0x2880809208288080ULL,
0x8094082880809308ULL, 0x0828808095082880ULL, 0x80809a0828808096ULL, 0xa708288080a50828ULL,
0x288080a908288080ULL, 0x80f208288080ec08ULL, 0x08288080f3082880ULL, 0x8080a808288080f8ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080a892ULL, 0x0000001cffffffffULL,
0x0000028800000000ULL, 0x0001e96000000000ULL, 0x0000012000000000ULL, 0x0000000000000000ULL,
0x0000001900082f04ULL, 0x00082304000000f9ULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL,
0x0000000000000019ULL, 0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0068016000000016ULL, 0x000c170400681903ULL,
0x0060000a00000000ULL, 0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL,
0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000eb000043104ULL, 0xffffffff019c2904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00000320019c2804ULL,
0x000005f000000490ULL, 0x00002da000002d10ULL, 0x0000302000002eb0ULL, 0x000032f000003190ULL,
0x0000378000003740ULL, 0x000037c000003790ULL, 0x00006980000068f0ULL, 0x00006c1000006aa0ULL,
0x00006ee000006d80ULL, 0x000073a000007360ULL, 0x000073e0000073b0ULL, 0x0000a3800000a2e0ULL,
0x0000a6000000a490ULL, 0x0000a8d00000a770ULL, 0x0000ad800000ad40ULL, 0x0000adc00000ad90ULL,
0x0000de200000dd90ULL, 0x0000e0a00000df30ULL, 0x0000e3700000e210ULL, 0x0000e8200000e7e0ULL,
0x0000e8600000e830ULL, 0x00010bc000010bb0ULL, 0x00010be000010bd0ULL, 0x0001be400001be00ULL,
0x0001be600001be50ULL, 0x0001bed00001beb0ULL, 0x0001bf000001bef0ULL, 0x0001d3c00001d360ULL,
0x0001d4900001d430ULL, 0x0001d5500001d4f0ULL, 0x0001d6300001d5c0ULL, 0x0001d7100001d6a0ULL,
0x0001d7d00001d770ULL, 0x0001d8a00001d840ULL, 0x0001d9600001d900ULL, 0x0001da400001d9d0ULL,
0x0001db200001dab0ULL, 0x0001dbe00001db80ULL, 0x0001dcb00001dc50ULL, 0x0001dd700001dd10ULL,
0x0001de500001dde0ULL, 0x0001df300001dec0ULL, 0x0001dff00001df90ULL, 0x0001e0c00001e060ULL,
0x0001e1800001e120ULL, 0x0001e2600001e1f0ULL, 0x0001e3400001e2d0ULL, 0x0001e4300001e3b0ULL,
0x0001e5300001e4b0ULL, 0x0001e6300001e5b0ULL, 0x0001e7300001e6b0ULL, 0x0000042004403904ULL,
0x0001a600000000ffULL, 0x00000460003f0100ULL, 0x0001a60800000013ULL, 0x00000580003f0120ULL,
0x0001a68800000013ULL, 0x000005b0003f0120ULL, 0x0001a6a800000013ULL, 0x000005e0003f0120ULL,
0x0001a6c800000013ULL, 0x00000f10003f0120ULL, 0x0001a600000000ffULL, 0x000010c0003f0107ULL,
0x000000040000000aULL, 0x00001170003f0102ULL, 0x000000000000000aULL, 0x00001b80003f0101ULL,
0x00000000000000ffULL, 0x00001c0000040107ULL, 0x00000000000000ffULL, 0x00001c6000040101ULL,
0x0001a6c80000000cULL, 0x00001df0003f0101ULL, 0x0001a6cc0000000fULL, 0x00001fd0003f0105ULL,
0x0001a6cc0000000fULL, 0x00002910003f0105ULL, 0x0001a6b000000010ULL, 0x000029c0003f0107ULL,
0x0001a6b000000010ULL, 0x00002a20003f0101ULL, 0x0001a60800000023ULL, 0x00002a40003f0101ULL,
0x0001a60c00000023ULL, 0x00002c10003f0105ULL, 0x0001a60c00000023ULL, 0x000034a0003f0105ULL,
0x0001a6ac00000010ULL, 0x00003670003f0105ULL, 0x0001a6ac00000010ULL, 0x00005a60003f0105ULL,
0x000000000000002aULL, 0x00005ac0003f0101ULL, 0x0001a68800000025ULL, 0x00005af0003f0101ULL,
0x0000000400000019ULL, 0x00005cb0003f0105ULL, 0x0000000400000019ULL, 0x00006500003f0105ULL,
0x0001a6a800000025ULL, 0x000065d0003f0107ULL, 0x0001a6a800000025ULL, 0x00006630003f0101ULL,
0x0001a62800000023ULL, 0x00006650003f0101ULL, 0x0001a62c00000023ULL, 0x00006820003f0105ULL,
0x0001a62c00000023ULL, 0x000070d0003f0105ULL, 0x0001a6b40000006dULL, 0x000072a0003f0105ULL,
0x0001a6b40000006dULL, 0x00009450003f0105ULL, 0x000000000000006eULL, 0x000094b0003f0101ULL,
0x0001a69000000028ULL, 0x000094e0003f0101ULL, 0x0000000400000019ULL, 0x000096a0003f0105ULL,
0x0000000400000019ULL, 0x00009ef0003f0105ULL, 0x0001a6b000000027ULL, 0x00009fc0003f0107ULL,
0x0001a6b000000027ULL, 0x0000a020003f0101ULL, 0x0001a64800000023ULL, 0x0000a040003f0101ULL,
0x0001a64c00000023ULL, 0x0000a210003f0105ULL, 0x0001a64c00000023ULL, 0x0000aab0003f0105ULL,
0x0001a6ac00000070ULL, 0x0000ac80003f0105ULL, 0x0001a6ac00000070ULL, 0x0000ce30003f0105ULL,
0x000000000000000fULL, 0x0000ce90003f0101ULL, 0x0001a69800000007ULL, 0x0000cec0003f0101ULL,
0x000000040000000fULL, 0x0000d0a0003f0105ULL, 0x000000040000000fULL, 0x0000d9f0003f0105ULL,
0x0001a6a800000028ULL, 0x0000da80003f0107ULL, 0x0001a6a800000028ULL, 0x0000dae0003f0101ULL,
0x0001a66800000007ULL, 0x0000db10003f0101ULL, 0x0001a66c00000007ULL, 0x0000dce0003f0105ULL,
0x0001a66c00000007ULL, 0x0000e540003f0105ULL, 0x0001a6b400000018ULL, 0x0000e710003f0105ULL,
0x0001a6b400000018ULL, 0x00010960003f0105ULL, 0x0000000000000019ULL, 0x000109e0003f0101ULL,
0x000000000000000cULL, 0x00012c50003f0101ULL, 0x0001a600000000ffULL, 0x00014570003f0101ULL,
0x0001a604000000ffULL, 0x00014780003f0105ULL, 0x0001a604000000ffULL, 0x00014b00003f0105ULL,
0x0001a600000000ffULL, 0x00014b30003f0101ULL, 0x0001a604000000ffULL, 0x00014cf0003f0105ULL,
0x0001a604000000ffULL, 0x000190e0003f0105ULL, 0x00000000000000bbULL, 0x00019180003f0101ULL,
0x00000004000000bbULL, 0x00019350003f0105ULL, 0x00000004000000bbULL, 0x0001d1a0003f0105ULL,
0x00000000000000beULL, 0x0001d200003f0101ULL, 0x00000008000000beULL, 0x0001d260003f0101ULL,
0x00000010000000beULL, 0x0001d2d0003f0101ULL, 0x00000018000000beULL, 0x00053803003f0101ULL,
0x00011b4000301c04ULL, 0x00011e1000011b70ULL, 0x000121f000012000ULL, 0x000125d0000123e0ULL,
0x000129c0000127c0ULL, 0x00014d5000012b70ULL, 0x000004010001d320ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000334ULL, 0x0000001900000002ULL, 0x0000000000000264ULL, 0x0000001900000002ULL,
0x00000000000001a4ULL, 0x0000001900000002ULL, 0x00000000000000ccULL, 0x0000001900000002ULL,
0x0000000000000044ULL, 0x0000001900000002ULL, 0x0000000000000310ULL, 0x0000001900000002ULL,
0x0000000000000240ULL, 0x0000001900000002ULL, 0x000000000000017dULL, 0x0000001900000002ULL,
0x00000000000000a8ULL, 0x0000001900000002ULL, 0x000000000001a700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000c27919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff0b0424ULL, 0x000fe200078e00ffULL,
0x00000001c2020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e000bULL,
0x00005c00c20a0625ULL, 0x000fe200078e000bULL, 0x0000000602070981ULL, 0x0002aa000c1e1900ULL,
0x000000060a0a0981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff177624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000087919ULL, 0x000e620000002600ULL, 0x00005a00ff157624ULL, 0x000fc600078e00ffULL,
0x0000000000117919ULL, 0x000e620000002300ULL, 0x0000590015157a24ULL, 0x000fc600078e02ffULL,
0x00000000000b7919ULL, 0x008ee20000002100ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00047810ULL, 0x010fcc0007ffe0ffULL, 0x0000000400057305ULL, 0x000864000021f000ULL,
0x000000ffff047224ULL, 0x010fe400078e00ffULL, 0x000000ffff097224ULL, 0x002fc800078e0a05ULL,
0x0000590009097a24ULL, 0x000fc800078e02ffULL, 0x0000000905057227ULL, 0x000fcc00078e0004ULL,
0x00000400050d7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff027224ULL, 0x000fc800078e0a0dULL,
0x0000040002007624ULL, 0x000fca00078e0217ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d1810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x000000010d0d2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0dba12ULL, 0x000fc800078e33ffULL, 0x0000000d00007306ULL, 0x000e620000209000ULL,
0x000000ff0d00720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000030d047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000e640000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000000803097227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a09ULL, 0x000000000d007224ULL, 0x000fca00078e0208ULL,
0x0000000d0000720cULL, 0x000fe20003fa6070ULL, 0x0000010011027a24ULL, 0x002fe400078e0204ULL,
0x00001fff11117589ULL, 0x000fe400000e0000ULL, 0x0000000002137a24ULL, 0x108fe200078e020bULL,
0x00000005ff0b7819ULL, 0x000fc8000001160bULL, 0x000000ff1300720cULL, 0x000fc60003f65270ULL,
0x0000000100005824ULL, 0x000fe200078e0a0dULL, 0x0000000f1300780cULL, 0x000fe40003f24070ULL,
0x0000000109095810ULL, 0x000fe40007ffe0ffULL, 0x0000000d0000720cULL, 0x000fe40003fc6070ULL,
0x000000031300780cULL, 0x040fe40003fa4070ULL, 0x0000007f1300780cULL, 0x000fe20003f44070ULL,
0x3fffff80ff02b424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff049424ULL, 0x000fc800078e00ffULL, 0x0000000109096810ULL, 0x000fe20007ffe0ffULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x0000000dff09c212ULL, 0x000fe200078e33ffULL,
0x01a60002ff00b388ULL, 0x0003e20000000a00ULL, 0x000000011300780cULL, 0x000fe20003f64070ULL,
0x3fffff80ff0cd424ULL, 0x000fe400078e00ffULL, 0x000000ffff067224ULL, 0x000fe200078e0a09ULL,
0x01a6080413009388ULL, 0x0007e20000008a00ULL, 0xff317217ff10a424ULL, 0x000fe400078e00ffULL,
0x000000060d087224ULL, 0x000fe200078e0208ULL, 0x00001fff0b027589ULL, 0x000f2200000e0000ULL,
0x3fffff60ff06d424ULL, 0x000fc400078e00ffULL, 0x0000002008037824ULL, 0x002fe200078e00ffULL,
0x01a400101300a388ULL, 0x000fe20000004800ULL, 0x7fffff80ff0dd424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0eb424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff0fb424ULL, 0x000fe400078e00ffULL,
0x0000000107000824ULL, 0x004fe400078e0a0aULL, 0x00005800ff008624ULL, 0x000fc400078e00ffULL,
0x00005800c20a8a24ULL, 0x000fe400078e02ffULL, 0x00005a0000047a24ULL, 0x008fe400078e02ffULL,
0x7fffff60ff07d424ULL, 0x000fe400078e00ffULL, 0x0000000104057824ULL, 0x040fe200078e0a03ULL,
0x000000030400720cULL, 0x000fe20003f26070ULL, 0x0000000411047824ULL, 0x010fe200078e0202ULL,
0x01a688061300d388ULL, 0x000fe20000008a00ULL, 0x000000150a777224ULL, 0x000fe200078e02ffULL,
0x0000002005057817ULL, 0x000fc40003800000ULL, 0x01a6a80c1300d388ULL, 0x000fe20000008a00ULL,
0x00005a0009167a24ULL, 0x000fe200078e0277ULL, 0x000000ff05767207ULL, 0x000fe40000800000ULL,
0x01a6c80e1300b388ULL, 0x000fe80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000207600780cULL, 0x000fe20003f05270ULL, 0x0000000404077824ULL, 0x000fd800078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a00000b7b06ULL, 0x000e620000209000ULL,
0x0000000000087919ULL, 0x000eae0000000000ULL, 0x0000000b000b7308ULL, 0x002e620000001000ULL,
0x00000004ff067819ULL, 0x004fc80000011608ULL, 0x00000002060f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001070c7824ULL, 0x000fe200078e0206ULL, 0x0ffffffe0b047810ULL, 0x002fc60007ffe0ffULL,
0x0000000107107824ULL, 0x000fe200078e020fULL, 0x0000000400057305ULL, 0x0002a6000021f000ULL,
0x0000000103137824ULL, 0x000fe400078e0210ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x004fc800078e0a05ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d050e7227ULL, 0x000fc800078e0004ULL, 0x0000000103057824ULL, 0x000fc800078e020cULL,
0x000000050e047227ULL, 0x000fc800078e00ffULL, 0x000000130e0e7227ULL, 0x000fc800078e00ffULL,
0x000000ffff127224ULL, 0x000fe400078e0a04ULL, 0x000000ffff147224ULL, 0x000fe400078e0a0eULL,
0x00005a00120b7a24ULL, 0x000fe400078e0205ULL, 0x00005a00140d7a24ULL, 0x000fc600078e0213ULL,
0x00005a000b007a0cULL, 0x000fe40003f06070ULL, 0x00005a000d007a0cULL, 0x000fd60003f46070ULL,
0x80005a000b0b0a10ULL, 0x000fe40007ffe0ffULL, 0x80005a000d0d2a10ULL, 0x000fe40007ffe0ffULL,
0x00005a000b007a0cULL, 0x000fe40003f26070ULL, 0x00005a000d007a0cULL, 0x000fe40003f66070ULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x000000010e0e2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff0b7a12ULL, 0x000fc600078e33ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x000000010e0e3810ULL, 0x000fe40007ffe0ffULL,
0x000000040b0d7207ULL, 0x040fe40004000000ULL, 0x0000000e0b127207ULL, 0x000fe20004000000ULL,
0x00000010080b7824ULL, 0x000fe200078e00ffULL, 0x0000000776047217ULL, 0x000fe20007800000ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0a0dULL, 0x000000ffff147224ULL, 0x000fc400078e0a12ULL,
0x00005a000e057a24ULL, 0x000fe400078e0205ULL, 0x00005a0014137a24ULL, 0x000fe400078e0213ULL,
0x0000000104047824ULL, 0x000fe400078e0a07ULL, 0x00000001160e7824ULL, 0x040fe400078e0205ULL,
0x0000000116137824ULL, 0x000fe200078e0213ULL, 0x000000040600720cULL, 0x080fe20003f06070ULL,
0x000000150d057224ULL, 0x080fe200078e020eULL, 0x000000040f00720cULL, 0x000fe20003f26070ULL,
0x0000001512067224ULL, 0x000fe200078e0213ULL, 0x000000f00b0d7812ULL, 0x000fe200078ec0ffULL,
0x0000010005047825ULL, 0x000fc800078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000d04047212ULL, 0x000fc600078efcffULL, 0x000000010c0e7824ULL, 0x100fe200078e0208ULL,
0x0000000d06067212ULL, 0x000fe200078efcffULL, 0x000000100c0f7824ULL, 0x000fe200078e00ffULL,
0x0000600004047a10ULL, 0x000fe20007f5e0ffULL, 0x00000001100c7824ULL, 0x000fe200078e0208ULL,
0x0000600006067a10ULL, 0x000fe20007f7e0ffULL, 0x00000010100d7824ULL, 0x000fe200078e00ffULL,
0xfffffff00f0e7812ULL, 0x000fe400078ee20eULL, 0x0000610005057a10ULL, 0x000fe400017fe4ffULL,
0xfffffff00d0c7812ULL, 0x000fe200078ee20cULL, 0x000000100e0d7824ULL, 0x000fe200078e00ffULL,
0x0000610007077a10ULL, 0x000fc60001ffe4ffULL, 0x000000100c0f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000c101c46ULL,
0x00000000060f7faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a0000067b06ULL, 0x000e620000209000ULL, 0x0000000000087919ULL, 0x000eae0000000000ULL,
0x0000000600067308ULL, 0x002e620000001000ULL, 0x00000007080c7211ULL, 0x004fc800078fe0ffULL,
0x000000020c0e7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe060b7810ULL, 0x002fc80007ffe0ffULL,
0x0000000b00057305ULL, 0x000e64000021f000ULL, 0x000000ffff047224ULL, 0x002fc800078e0a05ULL,
0x00005a0004077a24ULL, 0x000fe400078e02ffULL, 0x000000ffff047224ULL, 0x000fc800078e00ffULL,
0x00000007050d7227ULL, 0x000fc800078e0004ULL, 0x0000000103047824ULL, 0x040fe400078e020cULL,
0x0000000103077824ULL, 0x000fe400078e020eULL, 0x000000040d057227ULL, 0x000fc800078e00ffULL,
0x000000070d0b7227ULL, 0x000fc800078e00ffULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a05ULL,
0x000000ffff107224ULL, 0x000fe400078e0a0bULL, 0x00005a000d067a24ULL, 0x000fe400078e0204ULL,
0x00005a00100d7a24ULL, 0x000fc600078e0207ULL, 0x00005a0006007a0cULL, 0x000fe40003f06070ULL,
0x00005a000d007a0cULL, 0x000fd60003f46070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x80005a000d0d2a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00005a000d007a0cULL, 0x000fe20003f66070ULL, 0x000000010c0d7824ULL, 0x000fe200078e0208ULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x000000010b0b2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff067a12ULL, 0x000fc600078e33ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x000000010b0b3810ULL, 0x000fe40007ffe0ffULL,
0x0000000506057207ULL, 0x040fe40004000000ULL, 0x0000000b06067207ULL, 0x000fc60004000000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a05ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x00005a000b047a24ULL, 0x000fe400078e0204ULL, 0x00005a0010077a24ULL, 0x000fe400078e0207ULL,
0x0000000116047824ULL, 0x040fe400078e0204ULL, 0x0000000116077824ULL, 0x000fc400078e0207ULL,
0x00000010080b7824ULL, 0x000fe400078e00ffULL, 0x0000001505047224ULL, 0x080fe400078e0204ULL,
0x0000001506077224ULL, 0x000fe200078e0207ULL, 0x000000f00b0f7812ULL, 0x000fe200078ec0ffULL,
0x0000010004047825ULL, 0x000fc800078e00ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x0000000f04047212ULL, 0x000fc600078efcffULL, 0x000000100c107824ULL, 0x000fe200078e00ffULL,
0x0000000f06067212ULL, 0x000fe200078efcffULL, 0x000000010e0c7824ULL, 0x000fe200078e0208ULL,
0x0000600004047a10ULL, 0x000fe20007f1e0ffULL, 0x000000100e0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff0100d7812ULL, 0x000fe400078ee20dULL, 0x0000600006067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00f0c7812ULL, 0x000fe200078ee20cULL, 0x000000100d0d7824ULL, 0x000fe200078e00ffULL,
0x0000610005057a10ULL, 0x000fc400007fe4ffULL, 0x0000610007077a10ULL, 0x000fe20000ffe4ffULL,
0x000000100c0f7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e8000b901c46ULL, 0x00000000060f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x0000000000047806ULL, 0x000fe200038e0000ULL,
0x00000004ff837424ULL, 0x000fc600078e00ffULL, 0x0000000400057300ULL, 0x000e6200000e0000ULL,
0x00006800c20c7625ULL, 0x000fce00078e0083ULL, 0x0000000400077309ULL, 0x000ea20000000000ULL,
0x000000060500720cULL, 0x002fe40003f02070ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff057224ULL, 0x004fd400078e0a07ULL, 0x01a60405ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01a60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000060c047981ULL, 0x000ea2000c1e1900ULL, 0x000000ff1100720cULL, 0x000fe40003f05270ULL,
0x0000003f04057810ULL, 0x046fe40007ffe0ffULL, 0x000000ff04077810ULL, 0x000fc40007ffe0ffULL,
0x00000006ff057819ULL, 0x000fe40000011605ULL, 0x00000008ff067819ULL, 0x000fca0000011607ULL,
0x00011b7000008947ULL, 0x000fea0003800000ULL, 0x00000002ff207819ULL, 0x000fe20000011602ULL,
0x00000003ff0f7424ULL, 0x000fe200078e00ffULL, 0x0001a688020a7811ULL, 0x000fe400078e18ffULL,
0x03ffffff20147812ULL, 0x000fc800078ec0ffULL, 0x000000051400720cULL, 0x000fda0003f06070ULL,
0x00000002c2008824ULL, 0x000fe400078e00ffULL, 0x00006a00ff0d8624ULL, 0x000fc800078e00ffULL,
0x00006a00000d8624ULL, 0x000fe400078e020dULL, 0xffffffffff007424ULL, 0x000fe400078e00ffULL,
0x00000001140c8824ULL, 0x000fe200078e020dULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040f0aff738cULL, 0x0003e20000000000ULL, 0x000066000c0c8625ULL, 0x000fe200078e0083ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060c008981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0700780cULL, 0x000fe20003f04070ULL, 0x00000040091e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff1f7819ULL, 0x000fe20000011602ULL, 0x000000000aff7f8cULL, 0x0007e8000c80043fULL,
0x000000201f807824ULL, 0x000fca00078e00ffULL, 0x000000201e077812ULL, 0x000fe200078ef880ULL,
0x00005900000e7a24ULL, 0x004fe200078e02ffULL, 0x0000000102007812ULL, 0x000fc600078ec0ffULL,
0x000000400e1d7824ULL, 0x000fe200078e00ffULL, 0x0000040000000947ULL, 0x000fea0003800000ULL,
0x00000080040d7217ULL, 0x008fe20007800000ULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x00000003ff0a7819ULL, 0x002fe40000011608ULL, 0x000064001d1b7a11ULL, 0x000fe200078838ffULL,
0x000000010d0d7824ULL, 0x000fe200078e0a80ULL, 0x000000040a0f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001000c7824ULL, 0x000fe200078e020aULL, 0x0000000c0a107810ULL, 0x000fe40007ffe0ffULL,
0x000000000d0d7217ULL, 0x000fe20007800000ULL, 0x000000010c0e7824ULL, 0x040fe200078e0208ULL,
0x000065001d1d7a11ULL, 0x000fe200020f3cffULL, 0x000000080c157824ULL, 0x000fc400078e00ffULL,
0x000000010d0d7824ULL, 0x000fe400078e0a00ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0xfffffff815157812ULL, 0x000fe200078ee20eULL, 0x0000000100117824ULL, 0x000fe200078e0210ULL,
0x000000080a0e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000d0f00720cULL, 0x080fe20003f46070ULL,
0x00000001000f7824ULL, 0x000fe200078e020fULL, 0x0000000d0e00720cULL, 0x080fe20003f26070ULL,
0x00000001000e7824ULL, 0x000fe200078e020eULL, 0x0000000d0a00720cULL, 0x080fe20003f66070ULL,
0x000000010f007824ULL, 0x040fe200078e0208ULL, 0x0000000d1000720cULL, 0x000fe20003f06070ULL,
0x000000080f177824ULL, 0x000fc400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee200ULL, 0x00000001070f7824ULL, 0x040fe200078e020fULL,
0x000000700c0c7812ULL, 0x000fe200078ef80bULL, 0x0000000107107824ULL, 0x040fe400078e020eULL,
0x0000000107127824ULL, 0x000fe200078e0211ULL, 0x0000000c1b0c7210ULL, 0x000fe20007f9e0ffULL,
0x000000010e0a7824ULL, 0x140fe400078e0208ULL, 0x000000080e197824ULL, 0x000fe400078e00ffULL,
0x0000000111007824ULL, 0x000fc400078e0208ULL, 0x0000000811077824ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe200078ee20aULL, 0x000000800f0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff807077812ULL, 0x000fe200078ee200ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700e0a7812ULL, 0x100fe400078ef80bULL, 0x000160001f007811ULL, 0x000fe200078e68ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000070100e7812ULL, 0x000fc600078ef80bULL,
0x000000010d0d7824ULL, 0x000fe200020e061dULL, 0x00000070120b7812ULL, 0x000fe200078ef80bULL,
0x0000001015157824ULL, 0x100fe200078e0200ULL, 0x0000001b0a0a7210ULL, 0x080fe20007f9e0ffULL,
0x0000001017177824ULL, 0x100fe200078e0200ULL, 0x0000001b0e0e7210ULL, 0x080fe20007fbe0ffULL,
0x0000001019197824ULL, 0x000fe200078e0200ULL, 0x0000001b0b107210ULL, 0x000fe20007fde0ffULL,
0x000000010f0b7824ULL, 0x100fe200020e061dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c157faeULL, 0x0003e2000d901c46ULL, 0x00000001110f7824ULL, 0x000fc400028e061dULL,
0x0000001007077824ULL, 0x000fe200078e0200ULL, 0x000000000a177faeULL, 0x0003e2000d101c46ULL,
0x0000000113117824ULL, 0x000fc600030e061dULL, 0x000000000e197faeULL, 0x0003e8000c901c46ULL,
0x0000000010077faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010000d7824ULL, 0x008fe200078e00ffULL, 0x000064001d197a11ULL, 0x000fc800078038ffULL,
0x0000000d08007211ULL, 0x000fe400078fe8ffULL, 0x000065001d1d7a11ULL, 0x000fe400000f3cffULL,
0x00000008000f7810ULL, 0x042fe20007ffe0ffULL, 0x00000001000a7824ULL, 0x140fe200078e0208ULL,
0x00000004000e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000800157824ULL, 0x040fe400078e00ffULL,
0x000000010f0d7824ULL, 0x040fe400078e0208ULL, 0x000000080f107824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee20aULL, 0x00000001070c7824ULL, 0x000fe200078e0200ULL,
0x0000000c00007810ULL, 0x000fe20007ffe0ffULL, 0x000000010e0a7824ULL, 0x000fe200078e0208ULL,
0xfffffff810177812ULL, 0x000fe200078ee20dULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000080e117824ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fe200078ef80bULL,
0x00000001070e7824ULL, 0x040fe400078e020eULL, 0x0000000107107824ULL, 0x000fe200078e020fULL,
0xfffffff811167812ULL, 0x000fe200078ee20aULL, 0x0000000107127824ULL, 0x000fe200078e0200ULL,
0x0000000c190c7210ULL, 0x000fe20007f1e0ffULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000700e0a7812ULL, 0x000fc600078ef80bULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000070100e7812ULL, 0x000fc600078ef80bULL,
0x0000000100077824ULL, 0x000fe200078e0208ULL, 0x00000070120b7812ULL, 0x000fe200078ef80bULL,
0x0000000800007824ULL, 0x000fe200078e00ffULL, 0x000160001f127811ULL, 0x000fe200078e68ffULL,
0x000000010d0d7824ULL, 0x000fe200000e061dULL, 0x0000000a190a7210ULL, 0x040fe40007f1e0ffULL,
0x0000000e190e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001015157824ULL, 0x100fe200078e0212ULL,
0xfffffff800007812ULL, 0x000fe200078ee207ULL, 0x0000001016077824ULL, 0x100fe200078e0212ULL,
0x0000000b19107210ULL, 0x000fe20007f5e0ffULL, 0x000000010f0b7824ULL, 0x000fe200000e061dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c157faeULL, 0x0003e2000b901c46ULL,
0x0000001017177824ULL, 0x000fc400078e0212ULL, 0x00000001110f7824ULL, 0x100fe200008e061dULL,
0x000000000a077faeULL, 0x0003e2000b901c46ULL, 0x0000001000197824ULL, 0x000fe400078e0212ULL,
0x0000000113117824ULL, 0x000fe200010e061dULL, 0x000000000e177faeULL, 0x0003e8000b901c46ULL,
0x0000000010197faeULL, 0x0003e4000b901c46ULL, 0x00000001141d7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff247424ULL, 0x000fc600078e00ffULL, 0x000000051d00720cULL, 0x000fda0003f06070ULL,
0x0000006000000947ULL, 0x000fea0003800000ULL, 0x00000002c2007824ULL, 0x000fe400078e00ffULL,
0x00006a00ff077624ULL, 0x002fc800078e00ffULL, 0x00006a0000007624ULL, 0x000fc800078e0207ULL,
0x0000000100247824ULL, 0x000fc800078e021dULL, 0x0000660024247625ULL, 0x000fcc00078e0083ULL,
0x0000000624247981ULL, 0x000324000c1e1900ULL, 0x000000001f0473c2ULL, 0x000ea200000e0000ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x000000081f0c7824ULL, 0x002fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0001a6a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff597224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff0a7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6c8000c0c7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff587224ULL, 0x000fe200078e00ffULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000687805ULL, 0x000fe2000001ff00ULL,
0x0000ed1000008947ULL, 0x000fea0003800000ULL, 0x00000002c21c7824ULL, 0x000fe200078e00ffULL,
0x000000011f757812ULL, 0x000fe200078ec0ffULL, 0x00006a00ff077624ULL, 0x000fc400078e00ffULL,
0x000000ffff007224ULL, 0x002fe400078e000bULL, 0x00006a001c1c7624ULL, 0x000fe400078e0207ULL,
0x000000ffff0e7224ULL, 0x004fe400078e000dULL, 0xff317217ff077424ULL, 0x000fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fc400078e00ffULL,
0x000000ffff1a7224ULL, 0x00afca00078e001dULL, 0x00000000000a7805ULL, 0x000fc40000015200ULL,
0x00000004020c7824ULL, 0x000fca00078e00ffULL, 0xfffffff80c0f7812ULL, 0x000fc800078ec0ffULL,
0x0001a6c80f197810ULL, 0x000fe20007ffe0ffULL, 0x01a6cc000f0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a117210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc8000001140dULL,
0x000000110c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060dULL,
0x000000020c0c7819ULL, 0x000fc8000000120dULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6cc000f0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010020a7824ULL, 0x000fe200078e00ffULL,
0x000000011b0b7810ULL, 0x000fe20007ffe0ffULL, 0x0000590024247a24ULL, 0x010fc600078e02ffULL,
0xffffffe00a0c7812ULL, 0x000fe200078ec0ffULL, 0x0000004024297824ULL, 0x000fe200078e00ffULL,
0x000000060b00720cULL, 0x000fc60003f26070ULL, 0x000001001b0c7824ULL, 0x000fca00078e020cULL,
0x000000400c0d7810ULL, 0x000fc80007ffe0ffULL, 0x000000200d0b7812ULL, 0x000fca00078ec0ffULL,
0x000000011e107824ULL, 0x000fe200078e020bULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x000000100a0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000d040a7217ULL, 0x000fe40007800000ULL,
0x00000003ff0e7819ULL, 0x000fe40000011608ULL, 0x0000640029257a11ULL, 0x040fe200078a38ffULL,
0x000000010a0a7824ULL, 0x000fe200078e0a0dULL, 0x000000040e0f7810ULL, 0x040fe20007ffe0ffULL,
0x000000010e0d7824ULL, 0x000fe200078e020bULL, 0x0000650029297a11ULL, 0x000fc400028f3cffULL,
0x0000000b0a0a7217ULL, 0x000fe20007800000ULL, 0x000000010d0c7824ULL, 0x040fe400078e0208ULL,
0x000000080d117824ULL, 0x000fe400078e00ffULL, 0x000000010a0a7824ULL, 0x000fc600078e0a0bULL,
0xfffffff811127812ULL, 0x000fe400078ee20cULL, 0x000000080e117810ULL, 0x040fe40007ffe0ffULL,
0x0000000a0e00720cULL, 0x0c0fe40003f86070ULL, 0x0000000c0e0e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000a0f00720cULL, 0x0c0fe20003f66070ULL, 0x000000010f0f7824ULL, 0x100fe200078e020bULL,
0x0000000a1100720cULL, 0x0c0fe20003f46070ULL, 0x0000000111117824ULL, 0x100fe200078e020bULL,
0x0000000a0e00720cULL, 0x040fe20003f06070ULL, 0x000000010e217824ULL, 0x000fc400078e020bULL,
0x000000010f0b7824ULL, 0x140fe400078e0208ULL, 0x000000080f187824ULL, 0x000fe400078e00ffULL,
0x00000001110c7824ULL, 0x040fe400078e0208ULL, 0x0000000811237824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee20bULL, 0x00000010080e7824ULL, 0x000fe400078e00ffULL,
0x00000001100a7824ULL, 0x040fe200078e020dULL, 0xfffffff823247812ULL, 0x000fe200078ee20cULL,
0x00000001100c7824ULL, 0x000fe200078e020fULL, 0x000000700e277812ULL, 0x000fe200078ec0ffULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000270a0a7212ULL, 0x000fc600078efcffULL, 0x00000001100e7824ULL, 0x040fe200078e0211ULL,
0x0000000a250a7210ULL, 0x000fe20007fbe0ffULL, 0x0000000110107824ULL, 0x000fe200078e0221ULL,
0x000000270c0c7212ULL, 0x000fe200078efcffULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000270e0e7212ULL, 0x000fc600078efcffULL,
0x000000010b0b7824ULL, 0x100fe200028e0629ULL, 0x000000250c0c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000121237824ULL, 0x040fe200078e0208ULL, 0x0000002710107212ULL, 0x000fe200078efcffULL,
0x0000000821267824ULL, 0x000fe200078e00ffULL, 0x000170001f217811ULL, 0x000fe200078e68ffULL,
0x000000010d0d7824ULL, 0x000fe200028e0629ULL, 0x000000250e0e7210ULL, 0x080fe40007fbe0ffULL,
0xfffffff826267812ULL, 0x000fe200078ee223ULL, 0x0000001012237824ULL, 0x100fe200078e0221ULL,
0x0000002510107210ULL, 0x000fe20007fde0ffULL, 0x0000001018257824ULL, 0x000fc400078e0221ULL,
0x0000001024277824ULL, 0x000fe200078e0221ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a237faeULL, 0x0003e2000e101c46ULL, 0x000000010f0f7824ULL, 0x000fe400028e0629ULL,
0x0000001026217824ULL, 0x000fe200078e0221ULL, 0x000000000c257faeULL, 0x0003e2000d901c46ULL,
0x0000000111117824ULL, 0x000fc600030e0629ULL, 0x000000000e277faeULL, 0x0003e8000d101c46ULL,
0x0000000010217faeULL, 0x0003e2000c101c46ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x000000100a0b7812ULL, 0x000fe400078ec0ffULL, 0x0000640029257a11ULL, 0x040fe400078038ffULL,
0x0000000b080b7211ULL, 0x000fe400078fe8ffULL, 0x0000650029297a11ULL, 0x000fc400000f3cffULL,
0x000000040b0d7810ULL, 0x040fe20007ffe0ffULL, 0x000000010b0a7824ULL, 0x140fe200078e0208ULL,
0x000000080b0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000080b117824ULL, 0x000fe200078e00ffULL,
0x000170001f277811ULL, 0x000fe200078e68ffULL, 0x000000010d0c7824ULL, 0x040fe400078e0208ULL,
0x000000080d217824ULL, 0x000fe200078e00ffULL, 0xfffffff811127812ULL, 0x000fe200078ee20aULL,
0x000000010f0e7824ULL, 0x040fe400078e0208ULL, 0x000000080f117824ULL, 0x000fe200078e00ffULL,
0xfffffff821187812ULL, 0x000fe200078ee20cULL, 0x00000010080c7824ULL, 0x000fc400078e00ffULL,
0x00000001100a7824ULL, 0x040fe200078e020bULL, 0xfffffff811247812ULL, 0x000fe200078ee20eULL,
0x00000001100d7824ULL, 0x000fe200078e020dULL, 0x0000000c0b117810ULL, 0x000fe20007ffe0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000700c237812ULL, 0x000fc600078ec0ffULL,
0x00000001100f7824ULL, 0x000fe200078e020fULL, 0x000000230a0a7212ULL, 0x000fe200078efcffULL,
0x0000000110107824ULL, 0x000fe400078e0211ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x0000000a250a7210ULL, 0x000fc60007f1e0ffULL, 0x0000000111217824ULL, 0x040fe200078e0208ULL,
0x000000230c0c7212ULL, 0x000fe200078efcffULL, 0x0000000811267824ULL, 0x000fe400078e00ffULL,
0x000000800f0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee221ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000230e0e7212ULL, 0x000fc600078efcffULL,
0x000000010b0b7824ULL, 0x000fe200000e0629ULL, 0x0000002310107212ULL, 0x000fe200078efcffULL,
0x0000001012217824ULL, 0x100fe200078e0227ULL, 0x0000000c250c7210ULL, 0x040fe20007f1e0ffULL,
0x0000001018237824ULL, 0x000fe200078e0227ULL, 0x0000000e250e7210ULL, 0x040fe40007f5e0ffULL,
0x0000001025107210ULL, 0x000fe20007f7e0ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a217faeULL, 0x0003e2000b901c46ULL,
0x0000001024257824ULL, 0x000fc400078e0227ULL, 0x000000010f0f7824ULL, 0x000fe200010e0629ULL,
0x000000000c237faeULL, 0x0003e2000b901c46ULL, 0x0000001026277824ULL, 0x000fe400078e0227ULL,
0x0000000111117824ULL, 0x000fe200018e0629ULL, 0x000000000e257faeULL, 0x0003e8000b901c46ULL,
0x0000000010277faeULL, 0x0003e4000b901c46ULL, 0x00000008020c7824ULL, 0x002fe200078e00ffULL,
0x000000011d0a7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff00c107812ULL, 0x000fe400078ec0ffULL, 0x000000050a00720cULL, 0x000fe40003f06070ULL,
0x00000000100473c2ULL, 0x000e6200000e0000ULL, 0xffffffe00c237812ULL, 0x040fe400078ec0ffULL,
0x000000100c0e7812ULL, 0x040fe400078ec0ffULL, 0x000000080c0c7812ULL, 0x000fcc00078ec0ffULL,
0x000000011c0a8824ULL, 0x000fe400078e020aULL, 0x00000004ff0b8424ULL, 0x000fe200078e00ffULL,
0x000000230c237210ULL, 0x000fe40007ffe00eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000066000a0a8625ULL, 0x000fca00078e000bULL, 0x000000060a248981ULL, 0x000522000c1e1900ULL,
0x0001a6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x01a6b000106e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a60800230e7f8cULL, 0x000664000c80043fULL, 0x00000000000a7805ULL, 0x000fc40000015200ULL,
0x01a60c00230d7984ULL, 0x000ee40000000800ULL, 0x800000000dff7812ULL, 0x00afe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a117210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc8000001140dULL,
0x000000110c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060dULL,
0x000000020c0c7819ULL, 0x000fc8000000120dULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60c00230d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001008187824ULL, 0x000fe200078e00ffULL, 0x00000001ff747819ULL, 0x000fe20000011608ULL,
0x00000020020a7824ULL, 0x000fc600078e00ffULL, 0x0000007018187812ULL, 0x000fe400078ec0ffULL,
0xffffff800a0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c74747812ULL, 0x000fc800078ec0ffULL,
0x0000000b740b7210ULL, 0x000fca0007ffe018ULL, 0x01a000000b0a7984ULL, 0x000e680000000800ULL,
0x01a200000b0c7984ULL, 0x0006a20000000800ULL, 0x000000070a00720bULL, 0x002fe20003f1d000ULL,
0x0001a6227f007947ULL, 0x000fd8000b800000ULL, 0x00000000000b7806ULL, 0x008fc800000e0100ULL,
0x000000ff0b00720cULL, 0x000fe20003f05270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff217224ULL, 0x000fd200078e0007ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x000000022000720cULL, 0x000fe40003f05270ULL,
0x000000070a00720bULL, 0x000fe20003f54000ULL, 0x0001a5f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000127806ULL, 0x000fc400010e0100ULL, 0x00000080020d8824ULL, 0x000fe200078e0218ULL,
0x000000070a217209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000174268824ULL, 0x000fca00078e020dULL, 0x01a4002126008388ULL, 0x0003e20000000800ULL,
0x000000ff1200720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000000721077221ULL, 0x002fe20000010100ULL, 0x000000ff12ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b07077820ULL, 0x000fc80000410000ULL,
0x0000000700267308ULL, 0x000e640000000800ULL, 0x0000002622227220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe20000011608ULL,
0x0001a5427f007947ULL, 0x000fea000b800000ULL, 0x00001f2926287589ULL, 0x0002e400000e0000ULL,
0x0000002868687220ULL, 0x08cfe40000410000ULL, 0x0000002869697220ULL, 0x080fe40000410000ULL,
0x0000002864647220ULL, 0x080fe40000410000ULL, 0x0000002865657220ULL, 0x080fe40000410000ULL,
0x0000002860607220ULL, 0x080fe40000410000ULL, 0x0000002861617220ULL, 0x000fc40000410000ULL,
0x000000285c5c7220ULL, 0x080fe40000410000ULL, 0x000000285d5d7220ULL, 0x080fe40000410000ULL,
0x0000002858587220ULL, 0x080fe40000410000ULL, 0x0000002859597220ULL, 0x080fe40000410000ULL,
0x0000002854547220ULL, 0x080fe40000410000ULL, 0x0000002855557220ULL, 0x000fc40000410000ULL,
0x0000002850507220ULL, 0x080fe40000410000ULL, 0x0000002851517220ULL, 0x080fe40000410000ULL,
0x000000284c4c7220ULL, 0x080fe40000410000ULL, 0x000000284d4d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0012ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000808297811ULL, 0x002fe200078ff0ffULL, 0x0001a4327f007947ULL, 0x000fea000b800000ULL,
0x00001f2926287589ULL, 0x0002e400000e0000ULL, 0x000000286a6a7220ULL, 0x08cfe40000410000ULL,
0x000000286b6b7220ULL, 0x080fe40000410000ULL, 0x0000002866667220ULL, 0x080fe40000410000ULL,
0x0000002867677220ULL, 0x080fe40000410000ULL, 0x0000002862627220ULL, 0x080fe40000410000ULL,
0x0000002863637220ULL, 0x000fc40000410000ULL, 0x000000285e5e7220ULL, 0x080fe40000410000ULL,
0x000000285f5f7220ULL, 0x080fe40000410000ULL, 0x000000285a5a7220ULL, 0x080fe40000410000ULL,
0x000000285b5b7220ULL, 0x080fe40000410000ULL, 0x0000002856567220ULL, 0x080fe40000410000ULL,
0x0000002857577220ULL, 0x000fc40000410000ULL, 0x0000002852527220ULL, 0x080fe40000410000ULL,
0x0000002853537220ULL, 0x080fe40000410000ULL, 0x000000284e4e7220ULL, 0x080fe40000410000ULL,
0x000000284f4f7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000012ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001008297811ULL, 0x002fe200078ff0ffULL,
0x0001a3227f007947ULL, 0x000fea000b800000ULL, 0x00001f2926287589ULL, 0x0002e400000e0000ULL,
0x0000002848487220ULL, 0x08cfe40000410000ULL, 0x0000002849497220ULL, 0x080fe40000410000ULL,
0x0000002844447220ULL, 0x080fe40000410000ULL, 0x0000002845457220ULL, 0x080fe40000410000ULL,
0x0000002840407220ULL, 0x080fe40000410000ULL, 0x0000002841417220ULL, 0x000fc40000410000ULL,
0x000000283c3c7220ULL, 0x080fe40000410000ULL, 0x000000283d3d7220ULL, 0x080fe40000410000ULL,
0x0000002838387220ULL, 0x080fe40000410000ULL, 0x0000002839397220ULL, 0x080fe40000410000ULL,
0x0000002834347220ULL, 0x080fe40000410000ULL, 0x0000002835357220ULL, 0x000fc40000410000ULL,
0x0000002830307220ULL, 0x080fe40000410000ULL, 0x0000002831317220ULL, 0x080fe40000410000ULL,
0x000000282c2c7220ULL, 0x080fe40000410000ULL, 0x000000282d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000012ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001808297811ULL, 0x002fe200078ff0ffULL,
0x0001a2227f007947ULL, 0x000fea000b800000ULL, 0x00001f2926287589ULL, 0x0002e400000e0000ULL,
0x000000284a4a7220ULL, 0x08cfe40000410000ULL, 0x000000284b4b7220ULL, 0x080fe40000410000ULL,
0x0000002846467220ULL, 0x080fe40000410000ULL, 0x0000002847477220ULL, 0x080fe40000410000ULL,
0x0000002842427220ULL, 0x080fe40000410000ULL, 0x0000002843437220ULL, 0x000fc40000410000ULL,
0x000000283e3e7220ULL, 0x080fe40000410000ULL, 0x000000283f3f7220ULL, 0x080fe40000410000ULL,
0x000000283a3a7220ULL, 0x080fe40000410000ULL, 0x000000283b3b7220ULL, 0x080fe40000410000ULL,
0x0000002836367220ULL, 0x080fe40000410000ULL, 0x0000002837377220ULL, 0x000fc40000410000ULL,
0x0000002832327220ULL, 0x080fe40000410000ULL, 0x0000002833337220ULL, 0x080fe40000410000ULL,
0x000000282e2e7220ULL, 0x080fe40000410000ULL, 0x000000282f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x000000120bff7212ULL, 0x000fda00078030ffULL,
0x800000210a0a0221ULL, 0x000fe20000010000ULL, 0x00007610ff0e0816ULL, 0x000fc6000000000eULL,
0x3fb8aa3b0a0a0820ULL, 0x000fc80000410000ULL, 0x0000000a00170308ULL, 0x000e640000000800ULL,
0x000000170c0c0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000220c227221ULL, 0x004fc40000010000ULL, 0x00000000000a7805ULL, 0x000fca0000015200ULL,
0x01a6ac0010077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804800ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc8000001140dULL,
0x0000000c07077211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x0000000207077819ULL, 0x000fc8000000120cULL, 0x000000070000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6ac0010077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100e007816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000017ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff077819ULL, 0x000fe40000011608ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x00019e327f007947ULL, 0x000fea000b800000ULL,
0x00001f0700167589ULL, 0x0002a400000e0000ULL, 0x0000000807297810ULL, 0x000fe20007ffe0ffULL,
0x00019e827f007947ULL, 0x000fea000b800000ULL, 0x00000010070b7810ULL, 0x000fe20007ffe0ffULL,
0x00001f2900157589ULL, 0x00066800000e0000ULL, 0x00001f0b00147589ULL, 0x0006a400000e0000ULL,
0x0000001807297810ULL, 0x008fe20007ffe0ffULL, 0x00019f127f007947ULL, 0x000fea000b800000ULL,
0x00001f2900137589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000202257824ULL, 0x000fe200078e00ffULL, 0x00000008080b7812ULL, 0x000fe200078ec0ffULL,
0x00001000020c7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000026000007945ULL, 0x000fe20003800000ULL, 0x0000000425077812ULL, 0x002fc400078ec0ffULL,
0x000000070b127812ULL, 0x000fe200078ef808ULL, 0x00000004020b7824ULL, 0x000fe200078e00ffULL,
0x0000000708007211ULL, 0x008fe400078fe0ffULL, 0x0000001012117812ULL, 0x040fe200078efcffULL,
0x00000008120d7824ULL, 0x040fe200078e00ffULL, 0x000000040b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000112107824ULL, 0x000fe200078e0200ULL, 0xffffe0000c0c7812ULL, 0x000fe200078ec0ffULL,
0x00000001000f7824ULL, 0x000fe400078e0211ULL, 0x0000040002007824ULL, 0x000fe200078e00ffULL,
0xfffffff80d107812ULL, 0x000fe200078ee210ULL, 0x00000008110a7824ULL, 0x000fe200078e00ffULL,
0x000160000c0c7810ULL, 0x000fe20007ffe0ffULL, 0x00000008120e7824ULL, 0x000fe200078e00ffULL,
0xfffff00000007812ULL, 0x000fe200078ec0ffULL, 0x0000000812267824ULL, 0x000fe200078e00ffULL,
0xfffffff80a0f7812ULL, 0x000fc400078ee20fULL, 0x0000000b080a7211ULL, 0x000fe400078fe0ffULL,
0x0001200000007810ULL, 0x000fc60007ffe0ffULL, 0x00000001120b7824ULL, 0x000fe400078e020aULL,
0x0000001010707824ULL, 0x100fe400078e0200ULL, 0x000000100f287824ULL, 0x000fe200078e0200ULL,
0xfffffff80e0e7812ULL, 0x000fe400078ee20bULL, 0x000000020b0d7810ULL, 0x000fe20007ffe0ffULL,
0x000000007070783bULL, 0x000e640000000200ULL, 0x000000100e787824ULL, 0x000fc400078e020cULL,
0x000000002828783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000001670707231ULL, 0x086fe400003400ffULL, 0x0000001672727231ULL, 0x000fe400003400ffULL,
0x0000001571717231ULL, 0x080fe400003400ffULL, 0x0000001573737231ULL, 0x000fe400003400ffULL,
0x0000001428287231ULL, 0x088fe400003400ffULL, 0x000000142a2a7231ULL, 0x000fc400003400ffULL,
0x0000001329297231ULL, 0x080fe400003400ffULL, 0x000000132b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff8260d7812ULL, 0x000fe200078ee20dULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x0000000207077812ULL, 0x000fe200078efcffULL,
0x0000106000007945ULL, 0x000fe40003800000ULL, 0x000000100d7c7824ULL, 0x000fe200078e020cULL,
0x0000000708077211ULL, 0x000fca00078fe0ffULL, 0x000000007c7c783bULL, 0x000ea20000004200ULL,
0x0000007800267306ULL, 0x008fe20000009400ULL, 0x00000018ff0c7819ULL, 0x000fe20000011478ULL,
0x0000010078957824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011479ULL,
0x0000010079987824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe2000001147bULL,
0x000001007aa97824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe2000001147aULL,
0x0000007800937306ULL, 0x000ee20000005400ULL, 0x00000018ff9e7819ULL, 0x000fe20000011498ULL,
0x000001007bac7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x004fe2000001147eULL,
0x000001007cbb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe2000001147fULL,
0x000001007dbe7824ULL, 0x000fe200078e00ffULL, 0x00000018ff967819ULL, 0x000fe2000001147dULL,
0x0000007800947306ULL, 0x000462000000d400ULL, 0x00000018ff957819ULL, 0x000fc40000011495ULL,
0x00000018ffa97819ULL, 0x000fe400000114a9ULL, 0x00000018ffb27819ULL, 0x000fe400000114acULL,
0x00000018ffbb7819ULL, 0x000fe200000114bbULL, 0x0000000c009a7306ULL, 0x000fe20000209400ULL,
0x0001000078787824ULL, 0x004fe200078e00ffULL, 0x000000932600720bULL, 0x008fe20003f7d000ULL,
0x000001007e267824ULL, 0x000fe200078e00ffULL, 0x00000018ffc47819ULL, 0x000fe400000114beULL,
0x00000018ff787819ULL, 0x000fc40000011478ULL, 0x0000000c009d7306ULL, 0x000fe20000205400ULL,
0x00000018ff267819ULL, 0x000fcc0000011426ULL, 0x0000000194943812ULL, 0x002fe200078efcffULL,
0x0000000c006c7306ULL, 0x0003f0000020d400ULL, 0x0000008200a57306ULL, 0x000fe20000209400ULL,
0x00000018ff0c7819ULL, 0x002fce000001147cULL, 0x0000008200a87306ULL, 0x000ff00000205400ULL,
0x00000082006d7306ULL, 0x000ff0000020d400ULL, 0x0000009b00897306ULL, 0x000ff00000209400ULL,
0x0000009b008c7306ULL, 0x000ff00000205400ULL, 0x0000009b00827306ULL, 0x000ff0000020d400ULL,
0x0000008a00b77306ULL, 0x000ff00000209400ULL, 0x0000008a00ba7306ULL, 0x000ff00000205400ULL,
0x0000008a00877306ULL, 0x000ff0000020d400ULL, 0x0000000c00c07306ULL, 0x000ff00000209400ULL,
0x0000000c00c17306ULL, 0x000ff00000205400ULL, 0x0000000c00857306ULL, 0x000ff0000020d400ULL,
0x0000007800987306ULL, 0x000ff00000209400ULL, 0x00000078009b7306ULL, 0x000e700000205400ULL,
0x000000a3008d7306ULL, 0x000ff00000209400ULL, 0x000000a3008a7306ULL, 0x000fe20000205400ULL,
0x0000009b9800720bULL, 0x002fce0003fdd000ULL, 0x000000a3000c7306ULL, 0x0003f0000020d400ULL,
0x0000008300ae7306ULL, 0x000fe20000209400ULL, 0x0001000079a37824ULL, 0x002fca00078e00ffULL,
0x00000018ffa37819ULL, 0x000fe400000114a3ULL, 0x0000008300af7306ULL, 0x000ff00000205400ULL,
0x00000083008f7306ULL, 0x000ff0000020d400ULL, 0x0000009600917306ULL, 0x000ff00000209400ULL,
0x0000009600927306ULL, 0x000ff00000205400ULL, 0x0000009600837306ULL, 0x000ff0000020d400ULL,
0x0000009500967306ULL, 0x000ff00000209400ULL, 0x0000009500977306ULL, 0x000e700000205400ULL,
0x0000009500997306ULL, 0x000eb0000020d400ULL, 0x0000009e00a07306ULL, 0x000fe20000209400ULL,
0x000000979600720bULL, 0x002fce0003f5d000ULL, 0x0000009e00a17306ULL, 0x000e6c0000205400ULL,
0x0000000199992812ULL, 0x004fe400078efcffULL, 0x000000a300957306ULL, 0x000fe20000209400ULL,
0x0000009d9a00720bULL, 0x000fce0003f5d000ULL, 0x000000a300a47306ULL, 0x000ea20000205400ULL,
0x000000a1a000720bULL, 0x002fca0003fbd000ULL, 0x000000016c6c2812ULL, 0x000fe400078efcffULL,
0x00000079009c7306ULL, 0x000ff00000009400ULL, 0x00000079009f7306ULL, 0x000e620000005400ULL,
0x000000a49500720bULL, 0x004fce0003f7d000ULL, 0x0000007900277306ULL, 0x000eb0000000d400ULL,
0x0000009e00a27306ULL, 0x000ee2000020d400ULL, 0x0000009f9c00720bULL, 0x002fce0003f9d000ULL,
0x0000007800797306ULL, 0x000e6c000020d400ULL, 0x0000000127274812ULL, 0x004fe400078efcffULL,
0x000000a9009e7306ULL, 0x000fe20000209400ULL, 0x00000001a2a25812ULL, 0x008fe400078efcffULL,
0x000000a8a500720bULL, 0x000fc40003f9d000ULL, 0x00000027a227723eULL, 0x000fc600000010ffULL,
0x000000a900ab7306ULL, 0x000ea20000205400ULL, 0x0000000179796812ULL, 0x002fc800078efcffULL,
0x000000796c6c723eULL, 0x000fc600000010ffULL, 0x000000a300a67306ULL, 0x000e62000020d400ULL,
0x000000016d6d4812ULL, 0x000fce00078efcffULL, 0x0000007a00a77306ULL, 0x000fe20000009400ULL,
0x000000ab9e00720bULL, 0x004fce0003fdd000ULL, 0x0000007a00aa7306ULL, 0x000ea20000005400ULL,
0x00000001a6a63812ULL, 0x002fc800078efcffULL, 0x000000a66d6d723eULL, 0x000fc600000010ffULL,
0x0000007b00b07306ULL, 0x000fe80000009400ULL, 0x0000006c7064723cULL, 0x000f680000041864ULL,
0x0000007b00b17306ULL, 0x000e620000005400ULL, 0x000000aaa700720bULL, 0x004fc60003fbd000ULL,
0x0000006c2844723cULL, 0x000b680000041844ULL, 0x000000a900ad7306ULL, 0x000ea6000020d400ULL,
0x00000008116c7824ULL, 0x020fca00078e00ffULL, 0x0000007b008e7306ULL, 0x0006a2000000d400ULL,
0x000000b1b000720bULL, 0x002fce0003f7d000ULL, 0x0000007a00907306ULL, 0x000262000000d400ULL,
0x000100007b7b7824ULL, 0x008fe200078e00ffULL, 0x00000001adad6812ULL, 0x004fe400078efcffULL,
0x000000afae00720bULL, 0x000fe40003fdd000ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x000000b200b37306ULL, 0x000fe20000209400ULL, 0x000100007a7a7824ULL, 0x002fe200078e00ffULL,
0x000000018e8e3812ULL, 0x000fc800078efcffULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x000000b200b47306ULL, 0x000e620000205400ULL, 0x0000000190905812ULL, 0x000fe400078efcffULL,
0x000000018f8f6812ULL, 0x000fca00078efcffULL, 0x000000b200b57306ULL, 0x000eb0000020d400ULL,
0x0000007b00a97306ULL, 0x000fe20000209400ULL, 0x000000b4b300720bULL, 0x002fce0003f5d000ULL,
0x0000007b00b67306ULL, 0x000e6c0000205400ULL, 0x00000001b5b52812ULL, 0x004fe400078efcffULL,
0x000000bb00b27306ULL, 0x000fe20000209400ULL, 0x000000bab700720bULL, 0x000fe40003f5d000ULL,
0x0000008eb579723eULL, 0x000fca00000010ffULL, 0x000000bb00bd7306ULL, 0x000ea20000205400ULL,
0x000000b6a900720bULL, 0x002fca0003fbd000ULL, 0x0000000187872812ULL, 0x000fe400078efcffULL,
0x000000c400c57306ULL, 0x000ff00000209400ULL, 0x000000c400c67306ULL, 0x000e620000205400ULL,
0x000000bdb200720bULL, 0x004fce0003f7d000ULL, 0x0000007c00b97306ULL, 0x000ff00000009400ULL,
0x0000007c00bc7306ULL, 0x000fe20000005400ULL, 0x000000c6c500720bULL, 0x002fce0003fdd000ULL,
0x0000007c00867306ULL, 0x0003f0000000d400ULL, 0x0000007a00787306ULL, 0x000fe20000209400ULL,
0x000100007c7c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007a00a37306ULL, 0x000e700000205400ULL, 0x0000007d00c27306ULL, 0x000ff00000009400ULL,
0x0000007d00c37306ULL, 0x000fe20000005400ULL, 0x000000a37800720bULL, 0x002fc40003f9d000ULL,
0x00000090ad78723eULL, 0x000fca00000010ffULL, 0x0000007d00847306ULL, 0x0003e4000000d400ULL,
0x000000787060723cULL, 0x080f6c0000041860ULL, 0x0000007a00ac7306ULL, 0x000ea2000020d400ULL,
0x000100007d7d7824ULL, 0x002fe200078e00ffULL, 0x000000782840723cULL, 0x000f680000041840ULL,
0x00000018ff7d7819ULL, 0x000fc4000001147dULL, 0x0000007b00b87306ULL, 0x000e70000020d400ULL,
0x000000bb00bf7306ULL, 0x000ee2000020d400ULL, 0x00000001acac4812ULL, 0x004fe400078efcffULL,
0x000000bcb900720bULL, 0x000fca0003f9d000ULL, 0x0000007c007a7306ULL, 0x000fe20000209400ULL,
0x00000001b8b85812ULL, 0x002fe400078efcffULL, 0x000000c3c200720bULL, 0x000fca0003fbd000ULL,
0x0000007c007b7306ULL, 0x000e620000205400ULL, 0x00000001bfbf3812ULL, 0x008fe400078efcffULL,
0x0000000186864812ULL, 0x000fe400078efcffULL, 0x000000c1c000720bULL, 0x000fe40003f9d000ULL,
0x00000086bf86723eULL, 0x000fe200000010ffULL, 0x000000c400c77306ULL, 0x000ea2000020d400ULL,
0x0000000184845812ULL, 0x000fe400078efcffULL, 0x000000929100720bULL, 0x000fca0003fbd000ULL,
0x0000007d00bb7306ULL, 0x000fe20000209400ULL, 0x0000007b7a00720bULL, 0x002fe40003f7d000ULL,
0x0000000185854812ULL, 0x000fe400078efcffULL, 0x000000b8877b723eULL, 0x000fe400000010ffULL,
0x000000ac8f7a723eULL, 0x000fe200000010ffULL, 0x0000007d00c87306ULL, 0x000e620000205400ULL,
0x00000001c7c76812ULL, 0x004fe400078efcffULL, 0x0000000183835812ULL, 0x000fc400078efcffULL,
0x0000008c8900720bULL, 0x000fe20003fbd000ULL, 0x0000007a705c723cULL, 0x040f62000004185cULL,
0x00000084c787723eULL, 0x000fe200000010ffULL, 0x0000007d00967306ULL, 0x0004ec000020d400ULL,
0x000000867058723cULL, 0x000f640000041858ULL, 0x0000007c00be7306ULL, 0x000ee2000020d400ULL,
0x000001007f7d7824ULL, 0x004fe200078e00ffULL, 0x000000c8bb00720bULL, 0x002fc40003fdd000ULL,
0x0000000182825812ULL, 0x000fe400078efcffULL, 0x00000018ff957819ULL, 0x000fe2000001147dULL,
0x0000007a283c723cULL, 0x040f62000004183cULL, 0x00000026007c7306ULL, 0x000fee0000209400ULL,
0x0000000196966812ULL, 0x008fe200078efcffULL, 0x0000002600937306ULL, 0x000e620000205400ULL,
0x00000001bebe3812ULL, 0x000fe200078efcffULL, 0x000000862838723cULL, 0x000f620000041838ULL,
0x0000009683bf723eULL, 0x000fc400000010ffULL, 0x000000be85be723eULL, 0x000fc600000010ffULL,
0x0000009500977306ULL, 0x000fe80000209400ULL, 0x000000be7054723cULL, 0x000f680000041854ULL,
0x00000095009a7306ULL, 0x000ea20000205400ULL, 0x000000937c00720bULL, 0x002fc60003f7d000ULL,
0x000000be2834723cULL, 0x000f680000041834ULL, 0x0000007e00c97306ULL, 0x000ff00000009400ULL,
0x0000007e00ca7306ULL, 0x000e620000005400ULL, 0x0000009a9700720bULL, 0x004fce0003fdd000ULL,
0x0000007f00887306ULL, 0x000ff00000009400ULL, 0x0000007f008b7306ULL, 0x000ea20000005400ULL,
0x000000cac900720bULL, 0x002fce0003f5d000ULL, 0x0000007f000b7306ULL, 0x0003f0000000d400ULL,
0x0000007e00817306ULL, 0x0006e2000000d400ULL, 0x000100007f7f7824ULL, 0x002fe200078e00ffULL,
0x0000008b8800720bULL, 0x004fcc0003f9d000ULL, 0x00000095009c7306ULL, 0x0002a2000020d400ULL,
0x000100007e7e7824ULL, 0x008fca00078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000002600987306ULL, 0x0006a2000020d400ULL, 0x00000018ff957819ULL, 0x002fe4000001147fULL,
0x0000000181812812ULL, 0x000fe400078efcffULL, 0x000000010b0b4812ULL, 0x000fc600078efcffULL,
0x0000009500917306ULL, 0x000fe20000209400ULL, 0x000000949926723eULL, 0x008fe400000010ffULL,
0x000000019c9c6812ULL, 0x004fc800078efcffULL, 0x0000000b9c99723eULL, 0x000fe200000010ffULL,
0x00000095007c7306ULL, 0x000e620000205400ULL, 0x0000000198983812ULL, 0x000fe200078efcffULL,
0x000000267068723cULL, 0x000f620000041868ULL, 0x0000008a8d00720bULL, 0x000fe20003f7d000ULL,
0x00000001110b7824ULL, 0x000fe200078e0207ULL, 0x000000819898723eULL, 0x000fc600000010ffULL,
0x0000007e007d7306ULL, 0x000fe20000209400ULL, 0xfffffff86c0b7812ULL, 0x000fe200078ee20bULL,
0x000000262848723cULL, 0x000b6c0000041848ULL, 0x0000007e00947306ULL, 0x000ea20000205400ULL,
0x0000007c9100720bULL, 0x002fe20003fdd000ULL, 0x0000000812277824ULL, 0x020fe200078e00ffULL,
0x000000010c0c3812ULL, 0x000fe200078efcffULL, 0x000000987050723cULL, 0x000f620000041850ULL,
0x0000000111267824ULL, 0x000fe200078e020aULL, 0x000160001f0a7811ULL, 0x000fc400078e68ffULL,
0x0000009500957306ULL, 0x000e68000020d400ULL, 0x000000982830723cULL, 0x000f680000041830ULL,
0x0000007e007f7306ULL, 0x000ee2000020d400ULL, 0x000000947d00720bULL, 0x004fe40003f5d000ULL,
0x0000000195956812ULL, 0x002fc800078efcffULL, 0x000000950c83723eULL, 0x000fe200000010ffULL,
0x00000001120c7824ULL, 0x000fe400078e0207ULL, 0x0000000811077824ULL, 0x000fc800078e00ffULL,
0x000000017f7f2812ULL, 0x008fe400078efcffULL, 0xfffffff8270c7812ULL, 0x000fe200078ee20cULL,
0x0000000811277824ULL, 0x000fe200078e00ffULL, 0x0000007f8282723eULL, 0x000fe400000010ffULL,
0xfffffff807077812ULL, 0x000fe400078ee226ULL, 0x0000000226267810ULL, 0x000fc60007ffe0ffULL,
0x00000082704c723cULL, 0x000b62000004184cULL, 0x0000001007787824ULL, 0x000fcc00078e020aULL,
0x000000100c707824ULL, 0x120fe200078e0200ULL, 0x00000082282c723cULL, 0x000b62000004182cULL,
0x000000100b007824ULL, 0x000fc800078e0200ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000000028783bULL, 0x0204e20000000200ULL, 0x0000008000000947ULL, 0x000fd20003800000ULL,
0x0000001670707231ULL, 0x082fe400003400ffULL, 0x0000001672727231ULL, 0x000fe400003400ffULL,
0x0000001571717231ULL, 0x080fe400003400ffULL, 0x0000001573737231ULL, 0x000fc400003400ffULL,
0x0000001428287231ULL, 0x088fe400003400ffULL, 0x000000142a2a7231ULL, 0x000fe400003400ffULL,
0x0000001329297231ULL, 0x080fe400003400ffULL, 0x000000132b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff827007812ULL, 0x004fe200078ee226ULL,
0x000000007878783bULL, 0x000ea20000004200ULL, 0xfffffff825257812ULL, 0x000fc600078ec0ffULL,
0x00000010007c7824ULL, 0x000fcc00078e020aULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x0000007800967306ULL, 0x004fe20000009400ULL, 0x00000018ff827819ULL, 0x000fe20000011478ULL,
0x0000010078987824ULL, 0x000fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe20000011479ULL,
0x00000100799d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe2000001147aULL,
0x000001007aae7824ULL, 0x000fe200078e00ffULL, 0x00000018ff987819ULL, 0x000fe20000011498ULL,
0x0000007800997306ULL, 0x000ea20000005400ULL, 0x00000018ff8a7819ULL, 0x000fe2000001147bULL,
0x000001007bb27824ULL, 0x000fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x008fe2000001147dULL,
0x000001007cc07824ULL, 0x000fe200078e00ffULL, 0x00000018ff9e7819ULL, 0x000fe2000001147eULL,
0x000001007dc47824ULL, 0x000fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe2000001149dULL,
0x0000007800937306ULL, 0x000662000000d400ULL, 0x00000018ffa77819ULL, 0x000fe2000001147fULL,
0x000001007ece7824ULL, 0x000fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fc400000114aeULL,
0x00000018ffb57819ULL, 0x000fe400000114b2ULL, 0x00000018ffc07819ULL, 0x000fe200000114c0ULL,
0x00000082009f7306ULL, 0x000fe20000209400ULL, 0x0001000078787824ULL, 0x008fe200078e00ffULL,
0x000000999600720bULL, 0x004fe40003fdd000ULL, 0x00000018ffc77819ULL, 0x000fe400000114c4ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000008200a07306ULL, 0x000fe20000205400ULL,
0x00000018ffce7819ULL, 0x000fcc00000114ceULL, 0x0000000193936812ULL, 0x002fe200078efcffULL,
0x00000082006c7306ULL, 0x0003f0000020d400ULL, 0x0000008400aa7306ULL, 0x000fe20000209400ULL,
0x00000018ff827819ULL, 0x002fce000001147cULL, 0x0000008400ab7306ULL, 0x000ff00000205400ULL,
0x00000084006d7306ULL, 0x000ff0000020d400ULL, 0x0000008500b17306ULL, 0x000ff00000209400ULL,
0x0000008500b47306ULL, 0x000ff00000205400ULL, 0x00000085008d7306ULL, 0x000ff0000020d400ULL,
0x0000009a00917306ULL, 0x000ff00000209400ULL, 0x0000009a00927306ULL, 0x000ff00000205400ULL,
0x0000009a00857306ULL, 0x000ff0000020d400ULL, 0x0000009e008e7306ULL, 0x000ff00000209400ULL,
0x0000009e008f7306ULL, 0x000ff00000205400ULL, 0x0000009e00847306ULL, 0x000ff0000020d400ULL,
0x0000007900a17306ULL, 0x000ff00000009400ULL, 0x0000007900a27306ULL, 0x000e700000005400ULL,
0x00000098009a7306ULL, 0x000ff00000209400ULL, 0x00000098009b7306ULL, 0x000ea20000205400ULL,
0x000000a2a100720bULL, 0x002fce0003f5d000ULL, 0x00000078009d7306ULL, 0x000ff00000209400ULL,
0x00000078009e7306ULL, 0x000e620000205400ULL, 0x0000009b9a00720bULL, 0x004fce0003fbd000ULL,
0x0000008a00bc7306ULL, 0x000ff00000209400ULL, 0x0000008a00bd7306ULL, 0x000fe20000205400ULL,
0x0000009e9d00720bULL, 0x002fce0003f9d000ULL, 0x0000008a00897306ULL, 0x000ff0000020d400ULL,
0x0000008200c37306ULL, 0x000ff00000209400ULL, 0x0000008200c87306ULL, 0x000ff00000205400ULL,
0x0000008200877306ULL, 0x000ff0000020d400ULL, 0x000000a7008a7306ULL, 0x000ff00000209400ULL,
0x000000a7008b7306ULL, 0x000ff00000205400ULL, 0x000000a700827306ULL, 0x0003f0000020d400ULL,
0x000000a300a47306ULL, 0x000fe20000209400ULL, 0x0001000079a77824ULL, 0x002fca00078e00ffULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x000000a300a57306ULL, 0x000e700000205400ULL,
0x0000007900277306ULL, 0x000eb0000000d400ULL, 0x00000098009c7306ULL, 0x000ee2000020d400ULL,
0x000000a5a400720bULL, 0x002fce0003f1d000ULL, 0x000000a300a67306ULL, 0x000e62000020d400ULL,
0x0000000127272812ULL, 0x004fce00078efcffULL, 0x0000007800797306ULL, 0x000ea2000020d400ULL,
0x000000019c9c5812ULL, 0x008fe400078efcffULL, 0x000000a09f00720bULL, 0x000fca0003fbd000ULL,
0x000000a700987306ULL, 0x000fe20000209400ULL, 0x00000001a6a60812ULL, 0x002fe400078efcffULL,
0x000000abaa00720bULL, 0x000fe40003f1d000ULL, 0x00000027a627723eULL, 0x000fc600000010ffULL,
0x000000a700a97306ULL, 0x000e620000205400ULL, 0x0000000179794812ULL, 0x004fe400078efcffULL,
0x000000016c6c5812ULL, 0x000fc800078efcffULL, 0x000000796c6c723eULL, 0x000fe200000010ffULL,
0x000000ae00a37306ULL, 0x000fe20000209400ULL, 0x000000016d6d0812ULL, 0x000fe400078efcffULL,
0x000000b4b100720bULL, 0x000fca0003f1d000ULL, 0x000000ae00b07306ULL, 0x000ea20000205400ULL,
0x000000a99800720bULL, 0x002fce0003fdd000ULL, 0x000000b500b77306ULL, 0x000fe20000209400ULL,
0x000000018d8d0812ULL, 0x000fce00078efcffULL, 0x000000b500b87306ULL, 0x000e620000205400ULL,
0x000000b0a300720bULL, 0x004fce0003f5d000ULL, 0x0000007a00ac7306ULL, 0x000ff00000009400ULL,
0x0000007a00ad7306ULL, 0x000ea20000005400ULL, 0x000000b8b700720bULL, 0x002fce0003f9d000ULL,
0x0000007a00907306ULL, 0x0002f0000000d400ULL, 0x0000007b00b37306ULL, 0x000fe20000009400ULL,
0x000100007a7a7824ULL, 0x002fe200078e00ffULL, 0x000000adac00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000007b00b67306ULL, 0x000e6e0000005400ULL,
0x0000000190903812ULL, 0x008fe200078efcffULL, 0x0000007b008c7306ULL, 0x0004e2000000d400ULL,
0x000000bdbc00720bULL, 0x000fce0003f7d000ULL, 0x000000a700a87306ULL, 0x000ee2000020d400ULL,
0x000100007b7b7824ULL, 0x004fe200078e00ffULL, 0x000000b6b300720bULL, 0x002fc80003fbd000ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x000000ae00af7306ULL, 0x000e62000020d400ULL,
0x0000000189893812ULL, 0x000fcc00078efcffULL, 0x000000018c8c5812ULL, 0x008fe200078efcffULL,
0x000000b500b97306ULL, 0x000ea2000020d400ULL, 0x00000001a8a86812ULL, 0x000fc800078efcffULL,
0x000000a86d6d723eULL, 0x000fc600000010ffULL, 0x0000007c00be7306ULL, 0x000fe20000009400ULL,
0x00000001afaf2812ULL, 0x002fc600078efcffULL, 0x0000006c7064723cULL, 0x000f680000041864ULL,
0x0000007c00bf7306ULL, 0x000e620000005400ULL, 0x00000001b9b94812ULL, 0x004fc600078efcffULL,
0x0000006c2844723cULL, 0x000f620000041844ULL, 0x0000008cb979723eULL, 0x000fc600000010ffULL,
0x0000007a00787306ULL, 0x000ff00000209400ULL, 0x0000007a00a77306ULL, 0x000ea20000205400ULL,
0x000000bfbe00720bULL, 0x002fce0003f9d000ULL, 0x0000007b00ae7306ULL, 0x000ff00000209400ULL,
0x0000007b00bb7306ULL, 0x000e620000205400ULL, 0x000000a77800720bULL, 0x004fe40003fdd000ULL,
0x00000090af78723eULL, 0x000fca00000010ffULL, 0x0000007c00887306ULL, 0x0004e4000000d400ULL,
0x000000787060723cULL, 0x080f6c0000041860ULL, 0x0000007a00b27306ULL, 0x0006e2000020d400ULL,
0x000100007c7c7824ULL, 0x004fe200078e00ffULL, 0x000000bbae00720bULL, 0x002fe20003f5d000ULL,
0x000000782840723cULL, 0x000f6a0000041840ULL, 0x0000007b00ba7306ULL, 0x000e62000020d400ULL,
0x00000018ff7a7819ULL, 0x008fc4000001147cULL, 0x0000000188884812ULL, 0x000fca00078efcffULL,
0x0000007d00c57306ULL, 0x000fe20000009400ULL, 0x00000001b2b26812ULL, 0x000fce00078efcffULL,
0x0000007d00ca7306ULL, 0x000ea20000005400ULL, 0x00000001baba2812ULL, 0x002fce00078efcffULL,
0x000000c000b57306ULL, 0x000ff00000209400ULL, 0x000000c000c27306ULL, 0x000e620000205400ULL,
0x000000cac500720bULL, 0x004fce0003fdd000ULL, 0x000000c700c97306ULL, 0x000ff00000209400ULL,
0x000000c700cc7306ULL, 0x000ea20000205400ULL, 0x000000c2b500720bULL, 0x002fce0003fbd000ULL,
0x0000007a007b7306ULL, 0x000ff00000209400ULL, 0x0000007a00c47306ULL, 0x000e620000205400ULL,
0x000000ccc900720bULL, 0x004fce0003f5d000ULL, 0x0000007d00867306ULL, 0x0004f0000000d400ULL,
0x0000007f00957306ULL, 0x000fe20000009400ULL, 0x000100007d7d7824ULL, 0x004fe200078e00ffULL,
0x000000c47b00720bULL, 0x002fc40003f9d000ULL, 0x000000ba897b723eULL, 0x000fe400000010ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x0000007f00267306ULL, 0x000e620000005400ULL,
0x0000000186866812ULL, 0x008fe400078efcffULL, 0x000000929100720bULL, 0x000fca0003fdd000ULL,
0x0000007e00977306ULL, 0x000ff00000009400ULL, 0x0000007e00947306ULL, 0x000ea20000005400ULL,
0x000000269500720bULL, 0x002fe40003f7d000ULL, 0x000000939c26723eULL, 0x000fc400000010ffULL,
0x0000000185856812ULL, 0x000fc600078efcffULL, 0x000000c000c17306ULL, 0x000e64000020d400ULL,
0x000000267068723cULL, 0x080f6c0000041868ULL, 0x000000c700cb7306ULL, 0x000ee2000020d400ULL,
0x000000949700720bULL, 0x004fe20003f1d000ULL, 0x000000262848723cULL, 0x000f6c0000041848ULL,
0x0000007a00c67306ULL, 0x0004e2000020d400ULL, 0x00000001c1c15812ULL, 0x002fc400078efcffULL,
0x000000c8c300720bULL, 0x000fe40003fbd000ULL, 0x00000088c188723eULL, 0x000fc600000010ffULL,
0x0000007d00c07306ULL, 0x000fe20000209400ULL, 0x000001007f7a7824ULL, 0x004fe200078e00ffULL,
0x00000001cbcb2812ULL, 0x008fc800078efcffULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x0000007d00cd7306ULL, 0x000e620000205400ULL, 0x00000001c6c64812ULL, 0x000fe400078efcffULL,
0x0000000187875812ULL, 0x000fe400078efcffULL, 0x0000008f8e00720bULL, 0x000fe40003fbd000ULL,
0x00000086cb89723eULL, 0x000fe200000010ffULL, 0x000000ce00967306ULL, 0x000fe20000209400ULL,
0x000000c687c6723eULL, 0x000fca00000010ffULL, 0x000000887058723cULL, 0x000f640000041858ULL,
0x000000ce00997306ULL, 0x000ea20000205400ULL, 0x000000cdc000720bULL, 0x002fe40003f5d000ULL,
0x0000000184845812ULL, 0x000fc600078efcffULL, 0x000000882838723cULL, 0x000f640000041838ULL,
0x0000007e00837306ULL, 0x0002f0000000d400ULL, 0x0000007f00817306ULL, 0x0006e2000000d400ULL,
0x000100007e7e7824ULL, 0x002fe200078e00ffULL, 0x000000999600720bULL, 0x004fc80003f9d000ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000007d007c7306ULL, 0x000e62000020d400ULL,
0x000100007f7f7824ULL, 0x008fe200078e00ffULL, 0x0000000183830812ULL, 0x000fc800078efcffULL,
0x00000018ff937819ULL, 0x000fe4000001147fULL, 0x000000ce00987306ULL, 0x000ea2000020d400ULL,
0x0000000181813812ULL, 0x000fce00078efcffULL, 0x0000007a009a7306ULL, 0x000fe20000209400ULL,
0x000000017c7c2812ULL, 0x002fe400078efcffULL, 0x0000008b8a00720bULL, 0x000fe40003f5d000ULL,
0x0000007c85c7723eULL, 0x000fc600000010ffULL, 0x0000007a009b7306ULL, 0x000e620000205400ULL,
0x0000000198984812ULL, 0x004fc600078efcffULL, 0x000000c67054723cULL, 0x000f620000041854ULL,
0x000000839898723eULL, 0x000fc600000010ffULL, 0x0000007e007d7306ULL, 0x000fe20000209400ULL,
0x0000000182822812ULL, 0x000fc600078efcffULL, 0x000000c62834723cULL, 0x000f680000041834ULL,
0x0000007e00947306ULL, 0x000ea20000205400ULL, 0x0000009b9a00720bULL, 0x002fce0003fdd000ULL,
0x0000009300957306ULL, 0x000ff00000209400ULL, 0x00000093008c7306ULL, 0x000e620000205400ULL,
0x000000947d00720bULL, 0x004fce0003f9d000ULL, 0x0000007a009e7306ULL, 0x0004f0000020d400ULL,
0x0000007e007f7306ULL, 0x000ee2000020d400ULL, 0x0000008c9500720bULL, 0x002fe40003f1d000ULL,
0x000000b28d7a723eULL, 0x004fca00000010ffULL, 0x0000009300937306ULL, 0x000e62000020d400ULL,
0x000000019e9e6812ULL, 0x008fe200078efcffULL, 0x0000007a705c723cULL, 0x000f66000004185cULL,
0x000000819e99723eULL, 0x000fe400000010ffULL, 0x000000017f7f4812ULL, 0x000fc600078efcffULL,
0x0000007a283c723cULL, 0x000f62000004183cULL, 0x0000007f8484723eULL, 0x000fe400000010ffULL,
0x0000000193930812ULL, 0x002fca00078efcffULL, 0x000000987050723cULL, 0x000f620000041850ULL,
0x000000938285723eULL, 0x000fce00000010ffULL, 0x000000982830723cULL, 0x000f700000041830ULL,
0x00000084704c723cULL, 0x080f70000004184cULL, 0x00000084282c723cULL, 0x000b6e000004182cULL,
0x0001a6c81f2a7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000002a2a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6880025ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff6c7224ULL, 0x000fc600078e00ffULL,
0x0000000000267805ULL, 0x000fc80000015200ULL, 0x0000040019257984ULL, 0x004ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fc4000780482bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011429ULL,
0x0000002825257211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x0000000225257819ULL, 0x000fc80000001228ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016c6c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040019257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001002267824ULL, 0x000fe400078e00ffULL, 0x0000590024247a24ULL, 0x010fc600078e02ffULL,
0xffffffe026287812ULL, 0x000fe200078ec0ffULL, 0x0000004024717824ULL, 0x000fc800078e00ffULL,
0x000001001b277824ULL, 0x000fca00078e0228ULL, 0x0000008027277810ULL, 0x000fc80007ffe0ffULL,
0x0000002027257812ULL, 0x000fca00078ec0ffULL, 0x000000011e2a7824ULL, 0x000fe200078e0225ULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x0000002704247217ULL, 0x000fe40007800000ULL,
0x0000001026297812ULL, 0x000fe400078ec0ffULL, 0x00000003ff257819ULL, 0x000fe20000011608ULL,
0x0000000124247824ULL, 0x000fe200078e0a27ULL, 0x00006400716d7a11ULL, 0x000fe400078a38ffULL,
0x0000000425287810ULL, 0x040fe20007ffe0ffULL, 0x0000000125277824ULL, 0x000fe200078e0229ULL,
0x0000002429247217ULL, 0x000fc40007800000ULL, 0x0000000c256c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127267824ULL, 0x000fe200078e0208ULL, 0x0000650071717a11ULL, 0x000fe200028f3cffULL,
0x0000000827737824ULL, 0x000fe400078e00ffULL, 0x0000000124247824ULL, 0x100fe400078e0a29ULL,
0x000000016c7d7824ULL, 0x000fe200078e0229ULL, 0xfffffff873737812ULL, 0x000fe400078ee226ULL,
0x0000000825267810ULL, 0x000fc40007ffe0ffULL, 0x000000242500720cULL, 0x080fe20003f86070ULL,
0x0000000127257824ULL, 0x000fe200078e022aULL, 0x000000242600720cULL, 0x080fe20003f46070ULL,
0x0000000128277824ULL, 0x140fe200078e0229ULL, 0x000000242800720cULL, 0x080fe20003f66070ULL,
0x00000001262b7824ULL, 0x000fe200078e0229ULL, 0x000000246c00720cULL, 0x000fe20003f06070ULL,
0x0000000127267824ULL, 0x040fe400078e0208ULL, 0x0000000827797824ULL, 0x000fe400078e00ffULL,
0x0000008025247825ULL, 0x000fc600078e00ffULL, 0xfffffff879797812ULL, 0x000fe200078ee226ULL,
0x000000012b287824ULL, 0x040fe200078e0208ULL, 0x0000001824247212ULL, 0x000fe200078efcffULL,
0x000000082b7b7824ULL, 0x000fe400078e00ffULL, 0x0000000127267824ULL, 0x000fe200078e022aULL,
0x000000246d247210ULL, 0x000fe20007fbe0ffULL, 0x000000017d6c7824ULL, 0x000fe200078e0208ULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee228ULL, 0x0000008026267825ULL, 0x000fc800078e00ffULL,
0x000000012b287824ULL, 0x100fe200078e022aULL, 0x0000001826267212ULL, 0x000fe200078efcffULL,
0x000000017d2a7824ULL, 0x000fe400078e022aULL, 0x0000008028287825ULL, 0x000fc800078e00ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001828287212ULL, 0x000fc600078efcffULL,
0x0000000125257824ULL, 0x000fe200028e0671ULL, 0x0000006d26267210ULL, 0x000fe20007fbe0ffULL,
0x000000087d7d7824ULL, 0x000fe200078e00ffULL, 0x000000182a2a7212ULL, 0x000fc600078efcffULL,
0x0000000127277824ULL, 0x100fe200028e0671ULL, 0x0000006d28287210ULL, 0x080fe40007fbe0ffULL,
0x0000006d2a2a7210ULL, 0x000fe20007fde0ffULL, 0x00000010736d7824ULL, 0x000fe200078e020aULL,
0xfffffff87d7d7812ULL, 0x000fe200078ee26cULL, 0x0000000129297824ULL, 0x100fe400028e0671ULL,
0x000000012b2b7824ULL, 0x000fe200030e0671ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000246d7faeULL, 0x0003e2000e101c46ULL, 0x0000001079717824ULL, 0x000fc400078e020aULL,
0x000000107b737824ULL, 0x100fe400078e020aULL, 0x000000107d797824ULL, 0x000fe200078e020aULL,
0x0000000026717faeULL, 0x0003e8000d901c46ULL, 0x0000000028737faeULL, 0x0003e8000d101c46ULL,
0x000000002a797faeULL, 0x0003e2000c101c46ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001026257812ULL, 0x000fe400078ec0ffULL, 0x0000640071737a11ULL, 0x000fc400078038ffULL,
0x0000002508257211ULL, 0x000fe400078fe8ffULL, 0x0000650071717a11ULL, 0x000fe400000f3cffULL,
0x0000000425277810ULL, 0x040fe20007ffe0ffULL, 0x0000000125267824ULL, 0x040fe200078e0208ULL,
0x0000000825297810ULL, 0x040fe20007ffe0ffULL, 0x00000008256d7824ULL, 0x040fe200078e00ffULL,
0x0000000c252b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000125247824ULL, 0x000fe400078e022aULL,
0x0000000127257824ULL, 0x000fe200078e0208ULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee226ULL,
0x00000008276c7824ULL, 0x000fc400078e00ffULL, 0x0000000127267824ULL, 0x100fe400078e022aULL,
0x0000000129287824ULL, 0x040fe200078e022aULL, 0xfffffff86c797812ULL, 0x000fe200078ee225ULL,
0x0000000129277824ULL, 0x140fe400078e0208ULL, 0x0000000829707824ULL, 0x000fe400078e00ffULL,
0x000000012b297824ULL, 0x040fe400078e0208ULL, 0x000000082b727824ULL, 0x000fe200078e00ffULL,
0xfffffff8707b7812ULL, 0x000fe200078ee227ULL, 0x0000008024247825ULL, 0x000fc600078e00ffULL,
0xfffffff8727d7812ULL, 0x000fe200078ee229ULL, 0x000000012b2a7824ULL, 0x000fe200078e022aULL,
0x0000001824247212ULL, 0x000fe200078efcffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0x0000002473247210ULL, 0x000fe20007f1e0ffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000001826267212ULL, 0x000fc600078efcffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000001828287212ULL, 0x000fe400078efcffULL, 0x0000002673267210ULL, 0x000fe20007f5e0ffULL,
0x0000000125257824ULL, 0x100fe200000e0671ULL, 0x000000182a2a7212ULL, 0x000fe200078efcffULL,
0x000000106d6d7824ULL, 0x100fe200078e020aULL, 0x0000002873287210ULL, 0x000fe20007f1e0ffULL,
0x0000000127277824ULL, 0x100fe200010e0671ULL, 0x0000002a732a7210ULL, 0x000fe20007f7e0ffULL,
0x000000107b737824ULL, 0x000fe200078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000246d7faeULL, 0x0003e2000b901c46ULL, 0x0000000129297824ULL, 0x000fc400000e0671ULL,
0x000000012b2b7824ULL, 0x000fe400018e0671ULL, 0x0000001079717824ULL, 0x100fe400078e020aULL,
0x000000107d797824ULL, 0x000fc600078e020aULL, 0x0000000026717faeULL, 0x0003e8000b901c46ULL,
0x0000000028737faeULL, 0x0003e8000b901c46ULL, 0x000000002a797faeULL, 0x0003e4000b901c46ULL,
0x0000000802257824ULL, 0x002fe200078e00ffULL, 0x000000021d267810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff247424ULL, 0x000fc600078e00ffULL, 0xfffffff025257812ULL, 0x000fe400078ec0ffULL,
0x000000052600720cULL, 0x000fe40003f06070ULL, 0x00000000250473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000011c268824ULL, 0x000fc400078e0226ULL,
0x00000004ff278424ULL, 0x000fc800078e00ffULL, 0x0000660026268625ULL, 0x000fca00078e0027ULL,
0x0000000626248981ULL, 0x000522000c1e1900ULL, 0x0001a6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x01a6a800252a7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a62800236c7f8cULL, 0x000664000c80043fULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0x01a62c0023257984ULL, 0x002e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002826287210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011429ULL, 0x0000002825257211ULL, 0x000fca00078110ffULL,
0x000000ffff287224ULL, 0x000fca00000e0629ULL, 0x0000000225257819ULL, 0x000fc80000001228ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a62c0023257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002002257824ULL, 0x000fca00078e00ffULL,
0xffffff8025257812ULL, 0x000fc800078ec0ffULL, 0x0000008018257810ULL, 0x000fca0007ffe025ULL,
0x0000000174257824ULL, 0x000fca00078e0225ULL, 0x01a0000025267984ULL, 0x000e680000000800ULL,
0x01a2000025707984ULL, 0x0006a20000000800ULL, 0x000000212600720bULL, 0x002fe20003f1d000ULL,
0x00016e527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x008fc800000e0100ULL,
0x000000ff2500720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6c7424ULL, 0x000fd600078e00ffULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000000120277810ULL, 0x000fe40007ffe0ffULL, 0x000000212600720bULL, 0x000fe40003f54000ULL,
0x000000022700720cULL, 0x000fe20003f05270ULL, 0x00016e227f007947ULL, 0x000fd4000b800000ULL,
0x0000000000727806ULL, 0x000fc400010e0100ULL, 0x0000008002298824ULL, 0x000fe200078e0218ULL,
0x0000002126278209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000174288824ULL, 0x000fca00078e0229ULL, 0x01a4002728008388ULL, 0x0003e20000000800ULL,
0x000000ff7200720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002126287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff72ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002128277221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b27277820ULL, 0x000fc80000410000ULL, 0x0000002700737308ULL, 0x000e640000000800ULL,
0x0000007322227220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe20000011608ULL, 0x00016d627f007947ULL, 0x000fea000b800000ULL,
0x00001f2973287589ULL, 0x0002e400000e0000ULL, 0x0000002868687220ULL, 0x08cfe40000410000ULL,
0x0000002869697220ULL, 0x080fe40000410000ULL, 0x0000002864647220ULL, 0x080fe40000410000ULL,
0x0000002865657220ULL, 0x000fc40000410000ULL, 0x0000002860607220ULL, 0x080fe40000410000ULL,
0x0000002861617220ULL, 0x080fe40000410000ULL, 0x000000285c5c7220ULL, 0x080fe40000410000ULL,
0x000000285d5d7220ULL, 0x080fe40000410000ULL, 0x0000002858587220ULL, 0x080fe40000410000ULL,
0x0000002859597220ULL, 0x000fc40000410000ULL, 0x0000002854547220ULL, 0x080fe40000410000ULL,
0x0000002855557220ULL, 0x080fe40000410000ULL, 0x0000002850507220ULL, 0x080fe40000410000ULL,
0x0000002851517220ULL, 0x080fe40000410000ULL, 0x000000284c4c7220ULL, 0x080fe40000410000ULL,
0x000000284d4d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0072ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000808297811ULL, 0x002fe200078ff0ffULL,
0x00016c527f007947ULL, 0x000fea000b800000ULL, 0x00001f2973287589ULL, 0x0002e400000e0000ULL,
0x000000286a6a7220ULL, 0x08cfe40000410000ULL, 0x000000286b6b7220ULL, 0x080fe40000410000ULL,
0x0000002866667220ULL, 0x080fe40000410000ULL, 0x0000002867677220ULL, 0x080fe40000410000ULL,
0x0000002862627220ULL, 0x080fe40000410000ULL, 0x0000002863637220ULL, 0x000fc40000410000ULL,
0x000000285e5e7220ULL, 0x080fe40000410000ULL, 0x000000285f5f7220ULL, 0x080fe40000410000ULL,
0x000000285a5a7220ULL, 0x080fe40000410000ULL, 0x000000285b5b7220ULL, 0x080fe40000410000ULL,
0x0000002856567220ULL, 0x080fe40000410000ULL, 0x0000002857577220ULL, 0x000fc40000410000ULL,
0x0000002852527220ULL, 0x080fe40000410000ULL, 0x0000002853537220ULL, 0x080fe40000410000ULL,
0x000000284e4e7220ULL, 0x080fe40000410000ULL, 0x000000284f4f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000072ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001008297811ULL, 0x002fe200078ff0ffULL, 0x00016b427f007947ULL, 0x000fea000b800000ULL,
0x00001f2973287589ULL, 0x0002e400000e0000ULL, 0x0000002848487220ULL, 0x08cfe40000410000ULL,
0x0000002849497220ULL, 0x080fe40000410000ULL, 0x0000002844447220ULL, 0x080fe40000410000ULL,
0x0000002845457220ULL, 0x080fe40000410000ULL, 0x0000002840407220ULL, 0x080fe40000410000ULL,
0x0000002841417220ULL, 0x000fc40000410000ULL, 0x000000283c3c7220ULL, 0x080fe40000410000ULL,
0x000000283d3d7220ULL, 0x080fe40000410000ULL, 0x0000002838387220ULL, 0x080fe40000410000ULL,
0x0000002839397220ULL, 0x080fe40000410000ULL, 0x0000002834347220ULL, 0x080fe40000410000ULL,
0x0000002835357220ULL, 0x000fc40000410000ULL, 0x0000002830307220ULL, 0x080fe40000410000ULL,
0x0000002831317220ULL, 0x080fe40000410000ULL, 0x000000282c2c7220ULL, 0x080fe40000410000ULL,
0x000000282d2d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000072ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001808297811ULL, 0x002fe200078ff0ffULL, 0x00016a427f007947ULL, 0x000fea000b800000ULL,
0x00001f2973287589ULL, 0x0002e400000e0000ULL, 0x000000284a4a7220ULL, 0x08cfe40000410000ULL,
0x000000284b4b7220ULL, 0x080fe40000410000ULL, 0x0000002846467220ULL, 0x080fe40000410000ULL,
0x0000002847477220ULL, 0x080fe40000410000ULL, 0x0000002842427220ULL, 0x080fe40000410000ULL,
0x0000002843437220ULL, 0x000fc40000410000ULL, 0x000000283e3e7220ULL, 0x080fe40000410000ULL,
0x000000283f3f7220ULL, 0x080fe40000410000ULL, 0x000000283a3a7220ULL, 0x080fe40000410000ULL,
0x000000283b3b7220ULL, 0x080fe40000410000ULL, 0x0000002836367220ULL, 0x080fe40000410000ULL,
0x0000002837377220ULL, 0x000fc40000410000ULL, 0x0000002832327220ULL, 0x080fe40000410000ULL,
0x0000002833337220ULL, 0x080fe40000410000ULL, 0x000000282e2e7220ULL, 0x080fe40000410000ULL,
0x000000282f2f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007225ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff6c7424ULL, 0x000fe200078e00ffULL,
0x0000002126217209ULL, 0x000fd60007810000ULL, 0x8000002126260221ULL, 0x000fe20000010000ULL,
0x00007610ff6c0816ULL, 0x000fc6000000006cULL, 0x3fb8aa3b26260820ULL, 0x000fc80000410000ULL,
0x0000002600170308ULL, 0x000e640000000800ULL, 0x0000001770700220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002270227221ULL, 0x004fc40000010000ULL,
0x0000000000267805ULL, 0x000fca0000015200ULL, 0x0000000802257824ULL, 0x000fca00078e00ffULL,
0xfffffff0256d7812ULL, 0x000fca00078ec0ffULL, 0x01a6b4006d257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002826287210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011429ULL, 0x0000002825257211ULL, 0x000fca00078110ffULL,
0x000000ffff287224ULL, 0x000fca00000e0629ULL, 0x0000000225257819ULL, 0x000fc80000001228ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6b4006d257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099106c257816ULL, 0x000fc800000000ffULL,
0x000000ff2500720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000017ff13723eULL, 0x000fe400000010ffULL, 0x00000002ff267819ULL, 0x000fe40000011608ULL,
0x0000541013137816ULL, 0x000fe20000000013ULL, 0x000166227f007947ULL, 0x000fea000b800000ULL,
0x00001f2613167589ULL, 0x0002a400000e0000ULL, 0x0000000826297810ULL, 0x000fe20007ffe0ffULL,
0x000166727f007947ULL, 0x000fea000b800000ULL, 0x0000001026147810ULL, 0x000fe20007ffe0ffULL,
0x00001f2913157589ULL, 0x00066a00000e0000ULL, 0x00001f1413147589ULL, 0x0006a400000e0000ULL,
0x0000001826297810ULL, 0x008fe20007ffe0ffULL, 0x000167027f007947ULL, 0x000fea000b800000ULL,
0x00001f2913137589ULL, 0x0022e400000e0000ULL, 0x0000040002257824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100002267824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00025257812ULL, 0x000fc400078ec0ffULL,
0xffffe00026277812ULL, 0x000fe400078ec0ffULL, 0x0001300025267810ULL, 0x000fe40007ffe0ffULL,
0x0001700027257810ULL, 0x000fc60007ffe0ffULL, 0x0000001010707824ULL, 0x100fe400078e0226ULL,
0x000000100f6c7824ULL, 0x000fe400078e0226ULL, 0x000000100e787824ULL, 0x000fe400078e0225ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000006c6c783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001670707231ULL, 0x086fe400003400ffULL,
0x0000001672727231ULL, 0x000fc400003400ffULL, 0x0000001571717231ULL, 0x080fe400003400ffULL,
0x0000001573737231ULL, 0x000fe400003400ffULL, 0x000000146c6c7231ULL, 0x088fe400003400ffULL,
0x000000146e6e7231ULL, 0x000fe400003400ffULL, 0x000000136d6d7231ULL, 0x080fe400003400ffULL,
0x000000136f6f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100d7c7824ULL, 0x000fe200078e0225ULL, 0x000000007878783bULL, 0x000ee20000004200ULL,
0x00000f9000007945ULL, 0x000fe80003800000ULL, 0x000000007c7c783bULL, 0x000ea20000004200ULL,
0x0000007800987306ULL, 0x008fe20000009400ULL, 0x00000018ff257819ULL, 0x000fe20000011478ULL,
0x00000100789a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011479ULL,
0x00000100799f7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa07819ULL, 0x004fe2000001147eULL,
0x000001007ab07824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe2000001147bULL,
0x00000078009b7306ULL, 0x000ea20000005400ULL, 0x00000018ffa57819ULL, 0x000fe2000001149fULL,
0x000001007bb47824ULL, 0x000fe200078e00ffULL, 0x00000018ffa97819ULL, 0x000fe2000001147fULL,
0x000001007cc27824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe2000001147aULL,
0x000001007dc67824ULL, 0x000fe200078e00ffULL, 0x00000018ff9c7819ULL, 0x000fe2000001147dULL,
0x0000007800957306ULL, 0x000662000000d400ULL, 0x00000018ff9a7819ULL, 0x000fc4000001149aULL,
0x00000018ffb07819ULL, 0x000fe400000114b0ULL, 0x00000018ffb77819ULL, 0x000fe400000114b4ULL,
0x00000018ffc27819ULL, 0x000fe200000114c2ULL, 0x0000007900a37306ULL, 0x000fe20000009400ULL,
0x0001000078787824ULL, 0x008fe200078e00ffULL, 0x0000009b9800720bULL, 0x004fe20003f7d000ULL,
0x000001007e9b7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc77819ULL, 0x000fe400000114c6ULL,
0x00000018ff787819ULL, 0x000fc40000011478ULL, 0x0000007900a47306ULL, 0x000ea20000005400ULL,
0x00000018ff9b7819ULL, 0x000fcc000001149bULL, 0x0000000195953812ULL, 0x002fe200078efcffULL,
0x0000002500a17306ULL, 0x000ff00000209400ULL, 0x0000002500a27306ULL, 0x000fe20000205400ULL,
0x000000a4a300720bULL, 0x004fce0003f9d000ULL, 0x0000002500947306ULL, 0x0003f0000020d400ULL,
0x0000008200ac7306ULL, 0x000fe20000209400ULL, 0x00000018ff257819ULL, 0x002fce000001147cULL,
0x0000008200ad7306ULL, 0x000ff00000205400ULL, 0x0000008200917306ULL, 0x000ff0000020d400ULL,
0x000000a000897306ULL, 0x000ff00000209400ULL, 0x000000a0008c7306ULL, 0x000ff00000205400ULL,
0x000000a000827306ULL, 0x000ff0000020d400ULL, 0x00000078009f7306ULL, 0x000ff00000209400ULL,
0x0000007800a07306ULL, 0x000e700000205400ULL, 0x0000008a00be7306ULL, 0x000ff00000209400ULL,
0x0000008a00bf7306ULL, 0x000fe20000205400ULL, 0x000000a09f00720bULL, 0x002fe20003fdd000ULL,
0x000100007f9f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe2000001149fULL,
0x0000008a00877306ULL, 0x000ff0000020d400ULL, 0x0000002500c57306ULL, 0x000ff00000209400ULL,
0x0000002500c87306ULL, 0x000ff00000205400ULL, 0x0000002500857306ULL, 0x000ff0000020d400ULL,
0x000000a9008d7306ULL, 0x000ff00000209400ULL, 0x000000a9008a7306ULL, 0x000ff00000205400ULL,
0x000000a900257306ULL, 0x0003f0000020d400ULL, 0x0000007900297306ULL, 0x000ea2000000d400ULL,
0x0001000079a97824ULL, 0x002fca00078e00ffULL, 0x00000018ffa97819ULL, 0x000fe400000114a9ULL,
0x000000a500a67306ULL, 0x000ff00000209400ULL, 0x000000a500a77306ULL, 0x000e620000205400ULL,
0x0000000129294812ULL, 0x004fc400078efcffULL, 0x000000adac00720bULL, 0x000fca0003f9d000ULL,
0x0000008300b37306ULL, 0x000ff00000209400ULL, 0x0000008300b67306ULL, 0x000fe20000205400ULL,
0x000000a7a600720bULL, 0x002fe40003fbd000ULL, 0x0000000191914812ULL, 0x000fca00078efcffULL,
0x00000083008f7306ULL, 0x000ff0000020d400ULL, 0x0000009c00927306ULL, 0x000ff00000209400ULL,
0x0000009c00937306ULL, 0x000ff00000205400ULL, 0x0000009c00837306ULL, 0x000ff0000020d400ULL,
0x0000009a009c7306ULL, 0x000ff00000209400ULL, 0x0000009a009d7306ULL, 0x000e700000205400ULL,
0x0000009a009e7306ULL, 0x000eb0000020d400ULL, 0x000000a500a87306ULL, 0x000ee2000020d400ULL,
0x0000009d9c00720bULL, 0x002fce0003f5d000ULL, 0x0000007800797306ULL, 0x000e6c000020d400ULL,
0x000000019e9e2812ULL, 0x004fe400078efcffULL, 0x000000a9009a7306ULL, 0x000fe20000209400ULL,
0x00000001a8a85812ULL, 0x008fe400078efcffULL, 0x000000a2a100720bULL, 0x000fc40003f5d000ULL,
0x00000029a829723eULL, 0x000fc600000010ffULL, 0x000000a900ab7306ULL, 0x000ea20000205400ULL,
0x0000000179796812ULL, 0x002fce00078efcffULL, 0x000000b000a57306ULL, 0x000fe20000209400ULL,
0x0000000194942812ULL, 0x000fce00078efcffULL, 0x000000b000b27306ULL, 0x000e620000205400ULL,
0x000000ab9a00720bULL, 0x004fce0003f7d000ULL, 0x0000007a00ae7306ULL, 0x000ff00000009400ULL,
0x0000007a00af7306ULL, 0x000ea20000005400ULL, 0x000000b2a500720bULL, 0x002fce0003fdd000ULL,
0x0000007a00907306ULL, 0x0002f0000000d400ULL, 0x000000a900aa7306ULL, 0x000ee2000020d400ULL,
0x000100007a7a7824ULL, 0x002fe200078e00ffULL, 0x000000afae00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x000000b000b17306ULL, 0x000e6e000020d400ULL,
0x0000000190905812ULL, 0x008fe200078efcffULL, 0x0000007a00787306ULL, 0x000fe20000209400ULL,
0x00000001aaaa3812ULL, 0x000fce00078efcffULL, 0x0000007a00a97306ULL, 0x000ea20000205400ULL,
0x00000001b1b16812ULL, 0x002fe400078efcffULL, 0x000000b6b300720bULL, 0x000fca0003fdd000ULL,
0x0000007b00b57306ULL, 0x000ff00000009400ULL, 0x0000007b00b87306ULL, 0x000e620000005400ULL,
0x000000a97800720bULL, 0x004fe40003f9d000ULL, 0x000000018f8f6812ULL, 0x000fc400078efcffULL,
0x000000799478723eULL, 0x000fe400000010ffULL, 0x000000aa9179723eULL, 0x000fe200000010ffULL,
0x0000007b008e7306ULL, 0x0004ec000000d400ULL, 0x000000787064723cULL, 0x000f640000041864ULL,
0x0000007a00b47306ULL, 0x000ee2000020d400ULL, 0x000100007b7b7824ULL, 0x004fe200078e00ffULL,
0x000000b8b500720bULL, 0x002fc80003f7d000ULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x000000786c44723cULL, 0x000f620000041844ULL, 0x0000007c00c07306ULL, 0x000fee0000009400ULL,
0x000000018e8e3812ULL, 0x008fe200078efcffULL, 0x0000007b00b07306ULL, 0x000fe20000209400ULL,
0x00000001b4b44812ULL, 0x000fce00078efcffULL, 0x0000007b00bd7306ULL, 0x000e700000205400ULL,
0x0000007c00c17306ULL, 0x000eb00000005400ULL, 0x000000b700b97306ULL, 0x000fe20000209400ULL,
0x000000bdb000720bULL, 0x002fce0003fbd000ULL, 0x000000b700ba7306ULL, 0x000e620000205400ULL,
0x000000c1c000720bULL, 0x004fce0003f9d000ULL, 0x000000b700bb7306ULL, 0x000eb0000020d400ULL,
0x000000c200b77306ULL, 0x000fe20000209400ULL, 0x000000bab900720bULL, 0x002fce0003f5d000ULL,
0x000000c200c47306ULL, 0x000e6c0000205400ULL, 0x00000001bbbb2812ULL, 0x004fe400078efcffULL,
0x000000c700c97306ULL, 0x000fe20000209400ULL, 0x000000bfbe00720bULL, 0x000fce0003f5d000ULL,
0x000000c700ca7306ULL, 0x000ea20000205400ULL, 0x000000c4b700720bULL, 0x002fca0003f7d000ULL,
0x0000000187872812ULL, 0x000fe400078efcffULL, 0x0000007c00867306ULL, 0x0002f0000000d400ULL,
0x0000007d00967306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x002fe200078e00ffULL,
0x000000cac900720bULL, 0x004fc80003fdd000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007d00997306ULL, 0x000fe20000005400ULL, 0x0000000186864812ULL, 0x008fe400078efcffULL,
0x000000c8c500720bULL, 0x000fca0003f9d000ULL, 0x0000007d00847306ULL, 0x0003f0000000d400ULL,
0x0000007b00bc7306ULL, 0x000ea2000020d400ULL, 0x000100007d7d7824ULL, 0x002fe200078e00ffULL,
0x0000000185854812ULL, 0x000fc800078efcffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x000000c200c37306ULL, 0x000e70000020d400ULL, 0x000000c700cb7306ULL, 0x000ee2000020d400ULL,
0x00000001bcbc5812ULL, 0x004fc400078efcffULL, 0x000000999600720bULL, 0x000fca0003fbd000ULL,
0x0000007c007a7306ULL, 0x000fe20000209400ULL, 0x00000001c3c33812ULL, 0x002fc800078efcffULL,
0x00000086c386723eULL, 0x000fc600000010ffULL, 0x0000007c007b7306ULL, 0x000e620000205400ULL,
0x00000001cbcb6812ULL, 0x008fe400078efcffULL, 0x0000000184845812ULL, 0x000fe400078efcffULL,
0x000000939200720bULL, 0x000fc60003fbd000ULL, 0x0000007d00c27306ULL, 0x000ff00000209400ULL,
0x0000007d00cd7306ULL, 0x000ea20000205400ULL, 0x0000007b7a00720bULL, 0x002fe40003f7d000ULL,
0x0000000183835812ULL, 0x000fc400078efcffULL, 0x0000008c8900720bULL, 0x000fe40003fbd000ULL,
0x00000090b17a723eULL, 0x000fe200000010ffULL, 0x0000007d00987306ULL, 0x0002e2000020d400ULL,
0x0000008ebb7b723eULL, 0x000fce00000010ffULL, 0x0000007f00887306ULL, 0x000fe20000009400ULL,
0x000001007f7d7824ULL, 0x002fe200078e00ffULL, 0x000000cdc200720bULL, 0x004fe20003fdd000ULL,
0x0000007a7060723cULL, 0x080f620000041860ULL, 0x0000000182825812ULL, 0x000fe400078efcffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x0000007f008b7306ULL, 0x000e660000005400ULL,
0x0000007a6c40723cULL, 0x000f680000041840ULL, 0x0000000198986812ULL, 0x008fe200078efcffULL,
0x0000007c00c67306ULL, 0x000ea6000020d400ULL, 0x0000009883c7723eULL, 0x000fca00000010ffULL,
0x0000009b007c7306ULL, 0x000fe20000209400ULL, 0x0000008b8800720bULL, 0x002fce0003f9d000ULL,
0x0000009b009d7306ULL, 0x000e620000205400ULL, 0x00000001c6c63812ULL, 0x004fc800078efcffULL,
0x000000c685c6723eULL, 0x000fc600000010ffULL, 0x0000009b009a7306ULL, 0x000ea8000020d400ULL,
0x000000c67054723cULL, 0x080f680000041854ULL, 0x0000007e00977306ULL, 0x000fe20000009400ULL,
0x0000009d7c00720bULL, 0x002fe40003f7d000ULL, 0x000000b48f7c723eULL, 0x000fe200000010ffULL,
0x000000c66c34723cULL, 0x000f680000041834ULL, 0x0000007e00287306ULL, 0x000e6c0000005400ULL,
0x000000019a9a3812ULL, 0x004fc400078efcffULL, 0x0000007d009c7306ULL, 0x000fe20000209400ULL,
0x0000008a8d00720bULL, 0x000fce0003f7d000ULL, 0x0000007d009b7306ULL, 0x000ea20000205400ULL,
0x000000289700720bULL, 0x002fe40003f5d000ULL, 0x000000959e28723eULL, 0x000fc600000010ffULL,
0x0000000125253812ULL, 0x000fe400078efcffULL, 0x0000007e00817306ULL, 0x0002e4000000d400ULL,
0x000000287068723cULL, 0x080f6c0000041868ULL, 0x0000007f00277306ULL, 0x000ee2000000d400ULL,
0x000100007e7e7824ULL, 0x002fe200078e00ffULL, 0x0000009b9c00720bULL, 0x004fe20003fdd000ULL,
0x000000286c48723cULL, 0x000f660000041848ULL, 0x00000018ff7e7819ULL, 0x000fc4000001147eULL,
0x0000007d00a07306ULL, 0x0002a2000020d400ULL, 0x0000000181812812ULL, 0x008fc800078efcffULL,
0x000000819a9a723eULL, 0x000fc600000010ffULL, 0x0000007e007f7306ULL, 0x000fe20000209400ULL,
0x000000bc877d723eULL, 0x002fe400000010ffULL, 0x00000084cb87723eULL, 0x000fe400000010ffULL,
0x0000000127274812ULL, 0x000fc600078efcffULL, 0x0000007e00967306ULL, 0x000e620000205400ULL,
0x00000001a0a06812ULL, 0x004fe200078efcffULL, 0x0000007c705c723cULL, 0x040f66000004185cULL,
0x00000027a09b723eULL, 0x000fe200000010ffULL, 0x000000100b277824ULL, 0x000fe400078e0226ULL,
0x0000009f00917306ULL, 0x000fe40000209400ULL, 0x000000867058723cULL, 0x040f6c0000041858ULL,
0x0000009f00887306ULL, 0x000ea20000205400ULL, 0x000000967f00720bULL, 0x002fe20003f5d000ULL,
0x0000009a7050723cULL, 0x000f6c0000041850ULL, 0x0000007e00897306ULL, 0x000e64000020d400ULL,
0x0000007c6c3c723cULL, 0x040f6c000004183cULL, 0x0000009f00847306ULL, 0x000ee2000020d400ULL,
0x000000889100720bULL, 0x004fe20003fdd000ULL, 0x000000866c38723cULL, 0x000f620000041838ULL,
0x0000000189892812ULL, 0x002fce00078efcffULL, 0x0000009a6c30723cULL, 0x000f620000041830ULL,
0x000000898282723eULL, 0x000fc600000010ffULL, 0x0000000184846812ULL, 0x008fc800078efcffULL,
0x000000842583723eULL, 0x000fe400000010ffULL, 0x000010000a257810ULL, 0x000fca0007ffe0ffULL,
0x00000082704c723cULL, 0x080b6e000004184cULL, 0x000000100c707824ULL, 0x020fe200078e0226ULL,
0x000000826c2c723cULL, 0x000b62000004182cULL, 0x0000001007267824ULL, 0x000fe200078e0225ULL,
0x00000000276c783bULL, 0x0202a80000000200ULL, 0x000000007070783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fd80003800000ULL, 0x0000001670707231ULL, 0x088fe400003400ffULL,
0x0000001672727231ULL, 0x000fc400003400ffULL, 0x0000001571717231ULL, 0x080fe400003400ffULL,
0x0000001573737231ULL, 0x000fe400003400ffULL, 0x000000146c6c7231ULL, 0x084fe400003400ffULL,
0x000000146e6e7231ULL, 0x000fe400003400ffULL, 0x000000136d6d7231ULL, 0x080fe400003400ffULL,
0x000000136f6f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010007c7824ULL, 0x000fe200078e0225ULL, 0x000000002678783bULL, 0x000e6a0000004200ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000078009c7306ULL, 0x002fe20000009400ULL,
0x00000018ff817819ULL, 0x000fe20000011478ULL, 0x00000100789e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011479ULL, 0x0000010079a27824ULL, 0x000fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe2000001147aULL, 0x000001007ab27824ULL, 0x000fe200078e00ffULL,
0x00000018ff9f7819ULL, 0x008fe2000001147dULL, 0x00000078009d7306ULL, 0x000e620000005400ULL,
0x00000018ffa37819ULL, 0x000fe2000001147eULL, 0x000001007bb57824ULL, 0x000fe200078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe2000001149eULL, 0x000001007dc77824ULL, 0x000fe200078e00ffULL,
0x00000018ffa97819ULL, 0x000fe200000114a2ULL, 0x000001007cc47824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe2000001147bULL, 0x0000007800947306ULL, 0x0006a2000000d400ULL,
0x00000018ffb27819ULL, 0x000fe200000114b2ULL, 0x000001007ecf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa47819ULL, 0x000fc4000001147fULL, 0x00000018ffbb7819ULL, 0x000fe400000114b5ULL,
0x00000018ffc97819ULL, 0x000fe200000114c7ULL, 0x0000007900a77306ULL, 0x000fe20000009400ULL,
0x0001000078787824ULL, 0x008fe200078e00ffULL, 0x0000009d9c00720bULL, 0x002fe40003fdd000ULL,
0x00000018ffc47819ULL, 0x000fe400000114c4ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007900a87306ULL, 0x000e620000005400ULL, 0x00000018ffcf7819ULL, 0x000fcc00000114cfULL,
0x0000000194946812ULL, 0x004fe200078efcffULL, 0x0000008200ae7306ULL, 0x000ff00000209400ULL,
0x0000008200b17306ULL, 0x000fe20000205400ULL, 0x000000a8a700720bULL, 0x002fce0003f5d000ULL,
0x0000008200907306ULL, 0x000ff0000020d400ULL, 0x0000008400b77306ULL, 0x000ff00000209400ULL,
0x0000008400b87306ULL, 0x000ff00000205400ULL, 0x00000084008c7306ULL, 0x000ff0000020d400ULL,
0x0000009f00917306ULL, 0x000ff00000209400ULL, 0x0000009f00927306ULL, 0x000ff00000205400ULL,
0x0000009f00847306ULL, 0x000ff0000020d400ULL, 0x000000a3008e7306ULL, 0x000ff00000209400ULL,
0x000000a3008f7306ULL, 0x000ff00000205400ULL, 0x000000a300827306ULL, 0x000ff0000020d400ULL,
0x0000009e009f7306ULL, 0x000ff00000209400ULL, 0x0000009e00a07306ULL, 0x000e700000205400ULL,
0x0000007800a27306ULL, 0x000ff00000209400ULL, 0x0000007800a37306ULL, 0x000ea20000205400ULL,
0x000000a09f00720bULL, 0x002fce0003fbd000ULL, 0x0000007900297306ULL, 0x0002f0000000d400ULL,
0x0000008100a57306ULL, 0x000fe20000209400ULL, 0x0001000079797824ULL, 0x002fe200078e00ffULL,
0x000000a3a200720bULL, 0x004fc80003f9d000ULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000008100a67306ULL, 0x000fe20000205400ULL, 0x0000000129292812ULL, 0x008fce00078efcffULL,
0x0000008100937306ULL, 0x0003f0000020d400ULL, 0x000000a900aa7306ULL, 0x000fe20000209400ULL,
0x00000018ff817819ULL, 0x002fce000001147cULL, 0x000000a900ab7306ULL, 0x000e700000205400ULL,
0x000000a900ac7306ULL, 0x000eb0000020d400ULL, 0x000000b200a97306ULL, 0x000fe20000209400ULL,
0x000000abaa00720bULL, 0x002fce0003f1d000ULL, 0x000000b200b47306ULL, 0x000e6c0000205400ULL,
0x00000001acac0812ULL, 0x004fe400078efcffULL, 0x0000008900c07306ULL, 0x000fe20000209400ULL,
0x000000b1ae00720bULL, 0x000fe40003f1d000ULL, 0x00000029ac29723eULL, 0x000fca00000010ffULL,
0x0000008900c37306ULL, 0x000fe20000205400ULL, 0x000000b4a900720bULL, 0x002fca0003f5d000ULL,
0x0000000190900812ULL, 0x000fe400078efcffULL, 0x0000008900887306ULL, 0x000fe2000020d400ULL,
0x000000b8b700720bULL, 0x000fce0003f1d000ULL, 0x00000081009b7306ULL, 0x000fec0000209400ULL,
0x000000018c8c0812ULL, 0x000fe400078efcffULL, 0x00000081009a7306ULL, 0x000ff00000205400ULL,
0x0000008100867306ULL, 0x000ff0000020d400ULL, 0x000000a400897306ULL, 0x000ff00000209400ULL,
0x000000a4008a7306ULL, 0x000ff00000205400ULL, 0x000000a400817306ULL, 0x000ff0000020d400ULL,
0x0000009e00a17306ULL, 0x000e70000020d400ULL, 0x0000007800a47306ULL, 0x000eb0000020d400ULL,
0x0000007b00b97306ULL, 0x000fe20000009400ULL, 0x00000001a1a15812ULL, 0x002fc400078efcffULL,
0x000000a6a500720bULL, 0x000fe20003fbd000ULL, 0x000100007fa57824ULL, 0x000fc800078e00ffULL,
0x0000007b00ba7306ULL, 0x000e620000005400ULL, 0x00000001a4a44812ULL, 0x004fe400078efcffULL,
0x00000018ffa57819ULL, 0x000fca00000114a5ULL, 0x0000007b008b7306ULL, 0x0004e2000000d400ULL,
0x0000000193935812ULL, 0x000fce00078efcffULL, 0x00000079009e7306ULL, 0x000fe20000209400ULL,
0x000100007b7b7824ULL, 0x004fe200078e00ffULL, 0x000000bab900720bULL, 0x002fc80003fbd000ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x0000007900ad7306ULL, 0x000e6e0000205400ULL,
0x000000018b8b5812ULL, 0x008fe200078efcffULL, 0x000000bb00bc7306ULL, 0x000ff00000209400ULL,
0x000000bb00bd7306ULL, 0x000ea20000205400ULL, 0x000000ad9e00720bULL, 0x002fce0003fdd000ULL,
0x0000007a00b07306ULL, 0x000ff00000009400ULL, 0x0000007a00b37306ULL, 0x000e620000005400ULL,
0x000000bdbc00720bULL, 0x004fce0003f9d000ULL, 0x0000007a008d7306ULL, 0x0004f0000000d400ULL,
0x000000b200b67306ULL, 0x000ee2000020d400ULL, 0x000100007a7a7824ULL, 0x004fe200078e00ffULL,
0x000000b3b000720bULL, 0x002fc80003f7d000ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x0000007b00b27306ULL, 0x000fee0000209400ULL, 0x000000018d8d3812ULL, 0x008fe200078efcffULL,
0x0000007b00bf7306ULL, 0x000e620000205400ULL, 0x00000001b6b62812ULL, 0x000fc400078efcffULL,
0x000000c3c000720bULL, 0x000fca0003f7d000ULL, 0x0000007900af7306ULL, 0x000eb0000020d400ULL,
0x000000bb00be7306ULL, 0x000ee2000020d400ULL, 0x000000bfb200720bULL, 0x002fe40003f5d000ULL,
0x0000000188883812ULL, 0x000fca00078efcffULL, 0x0000007c00c27306ULL, 0x000fe20000009400ULL,
0x00000001afaf6812ULL, 0x004fce00078efcffULL, 0x0000007c00c57306ULL, 0x000e620000005400ULL,
0x00000001bebe4812ULL, 0x008fce00078efcffULL, 0x0000007a00787306ULL, 0x000ff00000209400ULL,
0x0000007a00797306ULL, 0x000ea20000205400ULL, 0x000000c5c200720bULL, 0x002fce0003f9d000ULL,
0x0000007c00877306ULL, 0x0002f0000000d400ULL, 0x0000007b00c17306ULL, 0x000ee2000020d400ULL,
0x000100007c7c7824ULL, 0x002fe200078e00ffULL, 0x000000797800720bULL, 0x004fc40003fdd000ULL,
0x000000af9079723eULL, 0x000fe400000010ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x000000c900ca7306ULL, 0x000fe20000209400ULL, 0x0000000187874812ULL, 0x008fe400078efcffULL,
0x000000a49378723eULL, 0x000fca00000010ffULL, 0x000000c900cb7306ULL, 0x000e620000205400ULL,
0x00000001c1c12812ULL, 0x000fe200078efcffULL, 0x000000787064723cULL, 0x080f6c0000041864ULL,
0x0000007a00b57306ULL, 0x000ea4000020d400ULL, 0x000000786c44723cULL, 0x000f6c0000041844ULL,
0x0000007d00987306ULL, 0x000fe20000009400ULL, 0x000000cbca00720bULL, 0x002fce0003f5d000ULL,
0x0000007d00997306ULL, 0x000e620000005400ULL, 0x00000001b5b56812ULL, 0x004fc800078efcffULL,
0x000000b58c8c723eULL, 0x000fc600000010ffULL, 0x0000007d00857306ULL, 0x0004f0000000d400ULL,
0x000000c400bb7306ULL, 0x000fe20000209400ULL, 0x000100007d7d7824ULL, 0x004fe200078e00ffULL,
0x000000999800720bULL, 0x002fcc0003fdd000ULL, 0x000000c400c67306ULL, 0x000e6e0000205400ULL,
0x0000000185856812ULL, 0x008fe200078efcffULL, 0x0000007c007a7306ULL, 0x000fe20000209400ULL,
0x000000929100720bULL, 0x000fce0003fdd000ULL, 0x0000007c007b7306ULL, 0x000ea20000205400ULL,
0x000000c6bb00720bULL, 0x002fca0003fbd000ULL, 0x0000000184846812ULL, 0x000fe400078efcffULL,
0x000000c400c87306ULL, 0x0002f0000020d400ULL, 0x000000c900cc7306ULL, 0x000ee2000020d400ULL,
0x00000018ffc47819ULL, 0x002fc4000001147dULL, 0x0000007b7a00720bULL, 0x004fe40003f9d000ULL,
0x0000008bbe7b723eULL, 0x000fe400000010ffULL, 0x0000008db67a723eULL, 0x000fe200000010ffULL,
0x000000c400cd7306ULL, 0x000fe20000209400ULL, 0x00000001c8c85812ULL, 0x008fe400078efcffULL,
0x0000009a9b00720bULL, 0x000fe40003fbd000ULL, 0x000000c1888d723eULL, 0x000fe200000010ffULL,
0x0000007a7060723cULL, 0x000f620000041860ULL, 0x00000087c8c8723eULL, 0x000fe200000010ffULL,
0x000000c400ce7306ULL, 0x000e620000205400ULL, 0x00000001cccc2812ULL, 0x000fc800078efcffULL,
0x00000085ccc9723eULL, 0x000fe200000010ffULL, 0x0000008c705c723cULL, 0x000f64000004185cULL,
0x0000007c00c77306ULL, 0x0004e2000020d400ULL, 0x0000000186865812ULL, 0x000fe400078efcffULL,
0x0000008f8e00720bULL, 0x000fc60003fbd000ULL, 0x000000c87058723cULL, 0x000f640000041858ULL,
0x0000007e00977306ULL, 0x000fe20000009400ULL, 0x000001007f7c7824ULL, 0x004fe200078e00ffULL,
0x000000cecd00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff9f7819ULL, 0x000fe2000001147cULL,
0x0000007a6c40723cULL, 0x000f620000041840ULL, 0x0000007e00967306ULL, 0x000e620000005400ULL,
0x00000001c7c74812ULL, 0x008fe400078efcffULL, 0x0000000182825812ULL, 0x000fc800078efcffULL,
0x0000008c6c3c723cULL, 0x040f62000004183cULL, 0x000000cf009c7306ULL, 0x000fee0000209400ULL,
0x000000c86c38723cULL, 0x000f620000041838ULL, 0x000000cf009d7306ULL, 0x000ea20000205400ULL,
0x000000969700720bULL, 0x002fce0003f1d000ULL, 0x0000007e00837306ULL, 0x0002f0000000d400ULL,
0x000000c4007d7306ULL, 0x000ee2000020d400ULL, 0x000100007e7e7824ULL, 0x002fe200078e00ffULL,
0x0000009d9c00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007f00957306ULL, 0x000fe20000009400ULL, 0x0000000183830812ULL, 0x008fce00078efcffULL,
0x0000007f00287306ULL, 0x000e620000005400ULL, 0x000000017d7d2812ULL, 0x000fe400078efcffULL,
0x0000008a8900720bULL, 0x000fe40003f5d000ULL, 0x0000007d847d723eULL, 0x000fc600000010ffULL,
0x0000007f00277306ULL, 0x000eb0000000d400ULL, 0x000000cf009e7306ULL, 0x000ee2000020d400ULL,
0x000000289500720bULL, 0x002fe40003f7d000ULL, 0x0000000181812812ULL, 0x000fc400078efcffULL,
0x00000094a128723eULL, 0x000fc600000010ffULL, 0x0000009f00a07306ULL, 0x000fe80000209400ULL,
0x000000287068723cULL, 0x000f640000041868ULL, 0x0000000127273812ULL, 0x004fe400078efcffULL,
0x0000009f00a37306ULL, 0x000e620000205400ULL, 0x000000019e9e4812ULL, 0x008fc600078efcffULL,
0x000000286c48723cULL, 0x000b620000041848ULL, 0x000000839e9e723eULL, 0x000fc600000010ffULL,
0x0000007e007c7306ULL, 0x000ff00000209400ULL, 0x0000007e007f7306ULL, 0x000ea20000205400ULL,
0x000000a3a000720bULL, 0x002fce0003fdd000ULL, 0x000000a500907306ULL, 0x000ff00000209400ULL,
0x000000a5008b7306ULL, 0x000e620000205400ULL, 0x0000007f7c00720bULL, 0x004fe40003f9d000ULL,
0x000000c7867c723eULL, 0x000fca00000010ffULL, 0x0000009f00a27306ULL, 0x000ea4000020d400ULL,
0x0000007c7054723cULL, 0x080f6c0000041854ULL, 0x0000007e00897306ULL, 0x000ee2000020d400ULL,
0x0000008b9000720bULL, 0x002fe20003f1d000ULL, 0x0000007c6c34723cULL, 0x000f6c0000041834ULL,
0x000000a500887306ULL, 0x000e62000020d400ULL, 0x00000001a2a26812ULL, 0x004fc800078efcffULL,
0x00000027a29f723eULL, 0x000fe200000010ffULL, 0x0000000202277824ULL, 0x000fe200078e00ffULL,
0x0000000189894812ULL, 0x008fc800078efcffULL, 0xfffffff827287812ULL, 0x020fe200078ec0ffULL,
0x0000009e7050723cULL, 0x000f620000041850ULL, 0x000000898282723eULL, 0x000fe400000010ffULL,
0x0000000188880812ULL, 0x002fc800078efcffULL, 0x000000888183723eULL, 0x000fe200000010ffULL,
0x0000009e6c30723cULL, 0x000f700000041830ULL, 0x00000082704c723cULL, 0x080f70000004184cULL,
0x000000826c2c723cULL, 0x000b6e000004182cULL, 0x0001a6c81f6e7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006e6e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6900028ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff277224ULL, 0x000fc600078e00ffULL, 0x0000000000287805ULL, 0x004fc80000015200ULL,
0x00000400196d7984ULL, 0x000ea40000000800ULL, 0x800000006dff7812ULL, 0x006fc4000780486fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c28717210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6d7824ULL, 0x000fe200000e0e29ULL,
0x003d09007100780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c407100780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff6c7819ULL, 0x000fc8000001146dULL, 0x000000716c6c7211ULL, 0x000fca00078110ffULL,
0x000000ffff6d7224ULL, 0x000fca00000e066dULL, 0x000000026c6c7819ULL, 0x000fc8000000126dULL,
0x0000006c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000127277810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400196d7984ULL, 0x000e640000000800ULL, 0x800000006dff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001002287824ULL, 0x000fe400078e00ffULL,
0x0000590024247a24ULL, 0x010fc600078e02ffULL, 0xffffffe0286c7812ULL, 0x000fe200078ec0ffULL,
0x0000004024737824ULL, 0x000fc800078e00ffULL, 0x000001001b297824ULL, 0x000fca00078e026cULL,
0x000000c029297810ULL, 0x000fc80007ffe0ffULL, 0x0000002029277812ULL, 0x000fca00078ec0ffULL,
0x000000011e707824ULL, 0x000fe200078e0227ULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x0000002904247217ULL, 0x000fe40007800000ULL, 0x0000001028277812ULL, 0x000fe400078ec0ffULL,
0x00000003ff287819ULL, 0x000fe20000011608ULL, 0x0000000124247824ULL, 0x000fc600078e0a29ULL,
0x00000004286d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000128297824ULL, 0x140fe200078e0227ULL,
0x0000002427247217ULL, 0x000fe40007800000ULL, 0x0000000c286e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001296c7824ULL, 0x040fe400078e0208ULL, 0x00000008296f7824ULL, 0x000fe400078e00ffULL,
0x0000000124247824ULL, 0x100fe400078e0a27ULL, 0x000000016e797824ULL, 0x000fe200078e0227ULL,
0xfffffff86f727812ULL, 0x000fc400078ee26cULL, 0x00000008286c7810ULL, 0x040fe20007ffe0ffULL,
0x00000001797a7824ULL, 0x000fe200078e0208ULL, 0x000000246d00720cULL, 0x0c0fe20003f66070ULL,
0x000000016d6d7824ULL, 0x100fe200078e0227ULL, 0x000000242800720cULL, 0x080fe20003f86070ULL,
0x000000016c6f7824ULL, 0x040fe200078e0227ULL, 0x000000246c00720cULL, 0x080fe20003f46070ULL,
0x0000000129287824ULL, 0x000fe200078e0270ULL, 0x000000246e00720cULL, 0x000fe20003f06070ULL,
0x000000016d277824ULL, 0x040fe400078e0208ULL, 0x000000086d6c7824ULL, 0x000fc400078e00ffULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff86c247812ULL, 0x000fe200078ee227ULL,
0x000000016f6e7824ULL, 0x000fe200078e0208ULL, 0x0000640073277a11ULL, 0x000fe200078a38ffULL,
0x000000086f717824ULL, 0x000fe200078e00ffULL, 0x0000001828287212ULL, 0x000fe200078efcffULL,
0x000000016d6c7824ULL, 0x000fe200078e0270ULL, 0x0000650073737a11ULL, 0x000fe400028f3cffULL,
0xfffffff871787812ULL, 0x000fe200078ee26eULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000002827287210ULL, 0x000fc60007fbe0ffULL, 0x000000016f6e7824ULL, 0x100fe200078e0270ULL,
0x000000186c6c7212ULL, 0x000fe200078efcffULL, 0x0000000179707824ULL, 0x000fe400078e0270ULL,
0x000000806e6e7825ULL, 0x000fc800078e00ffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000186e6e7212ULL, 0x000fc600078efcffULL, 0x0000000129297824ULL, 0x000fe200028e0673ULL,
0x000000276c6c7210ULL, 0x000fe20007fbe0ffULL, 0x0000000879797824ULL, 0x000fe200078e00ffULL,
0x0000001870707212ULL, 0x000fc600078efcffULL, 0x000000016d6d7824ULL, 0x000fe200028e0673ULL,
0x000000276e6e7210ULL, 0x080fe40007fbe0ffULL, 0x0000002770707210ULL, 0x000fe20007fde0ffULL,
0x0000001072277824ULL, 0x000fe200078e0225ULL, 0xfffffff8797a7812ULL, 0x000fe200078ee27aULL,
0x000000016f6f7824ULL, 0x100fe400028e0673ULL, 0x0000000171717824ULL, 0x000fe200030e0673ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028277faeULL, 0x0003e2000e101c46ULL,
0x0000001024737824ULL, 0x000fc400078e0225ULL, 0x0000001078797824ULL, 0x100fe400078e0225ULL,
0x000000107a7b7824ULL, 0x000fe200078e0225ULL, 0x000000006c737faeULL, 0x0003e8000d901c46ULL,
0x000000006e797faeULL, 0x0003e8000d101c46ULL, 0x00000000707b7faeULL, 0x0003e2000c101c46ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001028277812ULL, 0x000fc800078ec0ffULL,
0x0000002708277211ULL, 0x000fc800078fe8ffULL, 0x0000000427297810ULL, 0x040fe20007ffe0ffULL,
0x0000000127247824ULL, 0x040fe200078e0208ULL, 0x0000000c27717810ULL, 0x040fe20007ffe0ffULL,
0x00000008276d7824ULL, 0x040fe400078e00ffULL, 0x0000000127287824ULL, 0x000fe400078e0270ULL,
0x0000000829727824ULL, 0x000fe200078e00ffULL, 0xfffffff86d247812ULL, 0x000fe200078ee224ULL,
0x00000001296c7824ULL, 0x000fe200078e0270ULL, 0x00000008276d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000129277824ULL, 0x000fc400078e0208ULL, 0x00000008717a7824ULL, 0x000fe400078e00ffULL,
0x000000016d6e7824ULL, 0x040fe200078e0270ULL, 0xfffffff872727812ULL, 0x000fe200078ee227ULL,
0x000000016d6f7824ULL, 0x100fe200078e0208ULL, 0x0000640073277a11ULL, 0x000fe200078038ffULL,
0x000000086d787824ULL, 0x000fe400078e00ffULL, 0x00000001716d7824ULL, 0x000fe200078e0208ULL,
0x0000650073737a11ULL, 0x000fe200000f3cffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0xfffffff878787812ULL, 0x000fc400078ee26fULL, 0xfffffff87a7a7812ULL, 0x000fe200078ee26dULL,
0x0000000171707824ULL, 0x000fe200078e0270ULL, 0x0000001828287212ULL, 0x000fe200078efcffULL,
0x000000806c6c7825ULL, 0x000fc600078e00ffULL, 0x0000002827287210ULL, 0x000fe20007f1e0ffULL,
0x000000806e6e7825ULL, 0x000fe200078e00ffULL, 0x000000186c6c7212ULL, 0x000fc600078efcffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000186e6e7212ULL, 0x000fe400078efcffULL,
0x0000006c276c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000129297824ULL, 0x000fe200000e0673ULL,
0x0000001870707212ULL, 0x000fe200078efcffULL, 0x0000001078797824ULL, 0x000fe200078e0225ULL,
0x0000006e276e7210ULL, 0x000fe20007f1e0ffULL, 0x000000016d6d7824ULL, 0x000fe200010e0673ULL,
0x0000007027707210ULL, 0x000fe20007f7e0ffULL, 0x0000001024277824ULL, 0x000fc400078e0225ULL,
0x000000016f6f7824ULL, 0x100fe400000e0673ULL, 0x0000000171717824ULL, 0x000fe200018e0673ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028277faeULL, 0x0003e2000b901c46ULL,
0x0000001072737824ULL, 0x100fe400078e0225ULL, 0x000000107a7b7824ULL, 0x000fc600078e0225ULL,
0x000000006c737faeULL, 0x0003e8000b901c46ULL, 0x000000006e797faeULL, 0x0003e8000b901c46ULL,
0x00000000707b7faeULL, 0x0003e4000b901c46ULL, 0x0000000802277824ULL, 0x002fe200078e00ffULL,
0x000000031d287810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff027277812ULL, 0x000fe400078ec0ffULL, 0x000000052800720cULL, 0x000fe40003f06070ULL,
0x00000000270473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000011c288824ULL, 0x000fc400078e0228ULL, 0x00000004ff298424ULL, 0x000fc800078e00ffULL,
0x0000660028288625ULL, 0x000fca00078e0029ULL, 0x0000000628248981ULL, 0x000522000c1e1900ULL,
0x0001a6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x01a6b000276e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6480023707f8cULL, 0x000664000c80043fULL, 0x0000000000287805ULL, 0x000fc40000015200ULL,
0x01a64c0023277984ULL, 0x002e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006c7805ULL, 0x000fcc0000015200ULL, 0x0000006c286c7210ULL, 0x000fca0007f1e1ffULL,
0x000000016d6d7824ULL, 0x000fe200000e0e29ULL, 0x003d09006c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff277819ULL, 0x000fc8000001146dULL,
0x0000006c27277211ULL, 0x000fca00078110ffULL, 0x000000ffff6c7224ULL, 0x000fca00000e066dULL,
0x0000000227277819ULL, 0x000fc8000000126cULL, 0x000000270000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a64c0023277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002002237824ULL, 0x008fca00078e00ffULL, 0xffffff8023237812ULL, 0x000fc800078ec0ffULL,
0x0000010018237810ULL, 0x000fca0007ffe023ULL, 0x0000000174237824ULL, 0x000fca00078e0223ULL,
0x01a0000023707984ULL, 0x000e680000000800ULL, 0x01a2000023727984ULL, 0x0006a20000000800ULL,
0x000000217000720bULL, 0x002fe20003f1d000ULL, 0x000138727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000737806ULL, 0x008fc800000e0100ULL, 0x000000ff7300720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff277424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fd200078e0021ULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x0000000220237810ULL, 0x000fe40007ffe0ffULL, 0x000000217000720bULL, 0x000fe40003f54000ULL,
0x000000022300720cULL, 0x000fe20003f05270ULL, 0x000138327f007947ULL, 0x000fd4000b800000ULL,
0x0000000000787806ULL, 0x000fc400010e0100ULL, 0x0000008002278824ULL, 0x000fe200078e0218ULL,
0x0000002170237209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000174288824ULL, 0x000fca00078e0227ULL, 0x01a4002328008388ULL, 0x0003e20000000800ULL,
0x000000ff7800720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000002123217221ULL, 0x002fe20000010100ULL, 0x000000ff78ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b21217820ULL, 0x000fcc0000410000ULL,
0x0000002100217308ULL, 0x000e640000000800ULL, 0x0000002122227220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe20000011608ULL,
0x000137827f007947ULL, 0x000fea000b800000ULL, 0x00001f2921287589ULL, 0x0002e400000e0000ULL,
0x0000002868687220ULL, 0x08cfe40000410000ULL, 0x0000002869697220ULL, 0x080fe40000410000ULL,
0x0000002864647220ULL, 0x080fe40000410000ULL, 0x0000002865657220ULL, 0x000fc40000410000ULL,
0x0000002860607220ULL, 0x080fe40000410000ULL, 0x0000002861617220ULL, 0x080fe40000410000ULL,
0x000000285c5c7220ULL, 0x080fe40000410000ULL, 0x000000285d5d7220ULL, 0x080fe40000410000ULL,
0x0000002858587220ULL, 0x080fe40000410000ULL, 0x0000002859597220ULL, 0x000fc40000410000ULL,
0x0000002854547220ULL, 0x080fe40000410000ULL, 0x0000002855557220ULL, 0x080fe40000410000ULL,
0x0000002850507220ULL, 0x080fe40000410000ULL, 0x0000002851517220ULL, 0x080fe40000410000ULL,
0x000000284c4c7220ULL, 0x080fe40000410000ULL, 0x000000284d4d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0078ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000808297811ULL, 0x002fe200078ff0ffULL, 0x000136727f007947ULL, 0x000fea000b800000ULL,
0x00001f2921287589ULL, 0x0002e400000e0000ULL, 0x000000286a6a7220ULL, 0x08cfe40000410000ULL,
0x000000286b6b7220ULL, 0x080fe40000410000ULL, 0x0000002866667220ULL, 0x080fe40000410000ULL,
0x0000002867677220ULL, 0x080fe40000410000ULL, 0x0000002862627220ULL, 0x080fe40000410000ULL,
0x0000002863637220ULL, 0x000fc40000410000ULL, 0x000000285e5e7220ULL, 0x080fe40000410000ULL,
0x000000285f5f7220ULL, 0x080fe40000410000ULL, 0x000000285a5a7220ULL, 0x080fe40000410000ULL,
0x000000285b5b7220ULL, 0x080fe40000410000ULL, 0x0000002856567220ULL, 0x080fe40000410000ULL,
0x0000002857577220ULL, 0x000fc40000410000ULL, 0x0000002852527220ULL, 0x080fe40000410000ULL,
0x0000002853537220ULL, 0x080fe40000410000ULL, 0x000000284e4e7220ULL, 0x080fe40000410000ULL,
0x000000284f4f7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000078ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001008297811ULL, 0x002fe200078ff0ffULL,
0x000135627f007947ULL, 0x000fea000b800000ULL, 0x00001f2921287589ULL, 0x0002e400000e0000ULL,
0x0000002848487220ULL, 0x08cfe40000410000ULL, 0x0000002849497220ULL, 0x080fe40000410000ULL,
0x0000002844447220ULL, 0x080fe40000410000ULL, 0x0000002845457220ULL, 0x080fe40000410000ULL,
0x0000002840407220ULL, 0x080fe40000410000ULL, 0x0000002841417220ULL, 0x000fc40000410000ULL,
0x000000283c3c7220ULL, 0x080fe40000410000ULL, 0x000000283d3d7220ULL, 0x080fe40000410000ULL,
0x0000002838387220ULL, 0x080fe40000410000ULL, 0x0000002839397220ULL, 0x080fe40000410000ULL,
0x0000002834347220ULL, 0x080fe40000410000ULL, 0x0000002835357220ULL, 0x000fc40000410000ULL,
0x0000002830307220ULL, 0x080fe40000410000ULL, 0x0000002831317220ULL, 0x080fe40000410000ULL,
0x000000282c2c7220ULL, 0x080fe40000410000ULL, 0x000000282d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000078ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001808297811ULL, 0x002fe200078ff0ffULL,
0x000134627f007947ULL, 0x000fea000b800000ULL, 0x00001f2921287589ULL, 0x0002e400000e0000ULL,
0x000000284a4a7220ULL, 0x08cfe40000410000ULL, 0x000000284b4b7220ULL, 0x080fe40000410000ULL,
0x0000002846467220ULL, 0x080fe40000410000ULL, 0x0000002847477220ULL, 0x080fe40000410000ULL,
0x0000002842427220ULL, 0x080fe40000410000ULL, 0x0000002843437220ULL, 0x000fc40000410000ULL,
0x000000283e3e7220ULL, 0x080fe40000410000ULL, 0x000000283f3f7220ULL, 0x080fe40000410000ULL,
0x000000283a3a7220ULL, 0x080fe40000410000ULL, 0x000000283b3b7220ULL, 0x080fe40000410000ULL,
0x0000002836367220ULL, 0x080fe40000410000ULL, 0x0000002837377220ULL, 0x000fc40000410000ULL,
0x0000002832327220ULL, 0x080fe40000410000ULL, 0x0000002833337220ULL, 0x080fe40000410000ULL,
0x000000282e2e7220ULL, 0x080fe40000410000ULL, 0x000000282f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000007873ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff277424ULL, 0x000fd800078e00ffULL, 0x8000002370700221ULL, 0x000fe20000010000ULL,
0x00007610ff270816ULL, 0x000fc60000000027ULL, 0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL,
0x0000007000170308ULL, 0x000e640000000800ULL, 0x0000001772720220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002272227221ULL, 0x004fc40000010000ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x0000000802217824ULL, 0x000fca00078e00ffULL,
0xfffffff021707812ULL, 0x000fca00078ec0ffULL, 0x01a6ac0070217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c286c7210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6d7824ULL, 0x000fe200000e0e29ULL,
0x003d09006c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff217819ULL, 0x000fc8000001146dULL, 0x0000006c21217211ULL, 0x000fca00078110ffULL,
0x000000ffff6c7224ULL, 0x000fca00000e066dULL, 0x0000000221217819ULL, 0x000fc8000000126cULL,
0x000000210000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000171717810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6ac0070217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991027217816ULL, 0x000fc800000000ffULL,
0x000000ff2100720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000017ff13723eULL, 0x000fe400000010ffULL, 0x00000002ff2a7819ULL, 0x000fe40000011608ULL,
0x0000541013137816ULL, 0x000fe20000000013ULL, 0x000130527f007947ULL, 0x000fea000b800000ULL,
0x00001f2a13167589ULL, 0x0002a400000e0000ULL, 0x000000082a297810ULL, 0x000fe20007ffe0ffULL,
0x000130a27f007947ULL, 0x000fea000b800000ULL, 0x000000102a147810ULL, 0x000fe20007ffe0ffULL,
0x00001f2913157589ULL, 0x00066a00000e0000ULL, 0x00001f1413147589ULL, 0x0006a400000e0000ULL,
0x000000182a297810ULL, 0x008fe20007ffe0ffULL, 0x000131327f007947ULL, 0x000fea000b800000ULL,
0x00001f2913137589ULL, 0x0022e400000e0000ULL, 0x0000040002217824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100002277824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00021217812ULL, 0x000fc400078ec0ffULL,
0xffffe00027277812ULL, 0x000fe400078ec0ffULL, 0x0001400021217810ULL, 0x000fe40007ffe0ffULL,
0x0001600027277810ULL, 0x000fc60007ffe0ffULL, 0x0000001010107824ULL, 0x100fe400078e0221ULL,
0x000000100f0f7824ULL, 0x000fe400078e0221ULL, 0x000000100e787824ULL, 0x000fe200078e0227ULL,
0x000000001070783bULL, 0x0002e80000000200ULL, 0x000000000f28783bULL, 0x0022a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001670707231ULL, 0x08cfe400003400ffULL,
0x0000001672727231ULL, 0x000fc400003400ffULL, 0x0000001571717231ULL, 0x080fe400003400ffULL,
0x0000001573737231ULL, 0x000fe400003400ffULL, 0x0000001428287231ULL, 0x080fe400003400ffULL,
0x000000142a2a7231ULL, 0x000fe400003400ffULL, 0x0000001329297231ULL, 0x080fe400003400ffULL,
0x000000132b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100d7c7824ULL, 0x000fe200078e0227ULL, 0x000000007878783bULL, 0x000e620000004200ULL,
0x00000f8000007945ULL, 0x000fe80003800000ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000078006c7306ULL, 0x002fe20000009400ULL, 0x00000018ff0f7819ULL, 0x000fe20000011478ULL,
0x0000010078957824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011479ULL,
0x0000010079987824ULL, 0x000fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x008fe2000001147eULL,
0x000001007aa97824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe2000001147bULL,
0x0000007800937306ULL, 0x000e620000005400ULL, 0x00000018ff9e7819ULL, 0x000fe20000011498ULL,
0x000001007bac7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe2000001147fULL,
0x000001007cbb7824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe2000001147aULL,
0x000001007dbe7824ULL, 0x000fe200078e00ffULL, 0x00000018ff967819ULL, 0x000fe2000001147dULL,
0x0000007800947306ULL, 0x0006a2000000d400ULL, 0x00000018ff957819ULL, 0x000fc40000011495ULL,
0x00000018ffa97819ULL, 0x000fe400000114a9ULL, 0x00000018ffb27819ULL, 0x000fe400000114acULL,
0x00000018ffbb7819ULL, 0x000fe200000114bbULL, 0x0000000f009a7306ULL, 0x000fe20000209400ULL,
0x0001000078787824ULL, 0x008fe200078e00ffULL, 0x000000936c00720bULL, 0x002fe20003f7d000ULL,
0x000001007e6c7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc47819ULL, 0x000fe400000114beULL,
0x00000018ff787819ULL, 0x000fc40000011478ULL, 0x0000000f009d7306ULL, 0x000fe20000205400ULL,
0x00000018ff6c7819ULL, 0x000fcc000001146cULL, 0x0000000194943812ULL, 0x004fe200078efcffULL,
0x0000000f00927306ULL, 0x0003f0000020d400ULL, 0x0000002700a57306ULL, 0x000fe20000209400ULL,
0x00000018ff0f7819ULL, 0x002fce000001147cULL, 0x0000002700a87306ULL, 0x000ff00000205400ULL,
0x00000027008f7306ULL, 0x000ff0000020d400ULL, 0x0000009b00877306ULL, 0x000ff00000209400ULL,
0x0000009b008a7306ULL, 0x000ff00000205400ULL, 0x0000009b00277306ULL, 0x000ff0000020d400ULL,
0x0000007800987306ULL, 0x000ff00000209400ULL, 0x00000078009b7306ULL, 0x000e700000205400ULL,
0x0000008800b77306ULL, 0x000ff00000209400ULL, 0x0000008800ba7306ULL, 0x000fe20000205400ULL,
0x0000009b9800720bULL, 0x002fe20003fdd000ULL, 0x000100007f9b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe2000001149bULL, 0x0000008800857306ULL, 0x000ff0000020d400ULL,
0x0000000f00c07306ULL, 0x000ff00000209400ULL, 0x0000000f00c17306ULL, 0x000ff00000205400ULL,
0x0000000f00837306ULL, 0x000ff0000020d400ULL, 0x000000a3008b7306ULL, 0x000ff00000209400ULL,
0x000000a300887306ULL, 0x000ff00000205400ULL, 0x000000a3000f7306ULL, 0x0003f0000020d400ULL,
0x00000079009c7306ULL, 0x000fe20000009400ULL, 0x0001000079a37824ULL, 0x002fca00078e00ffULL,
0x00000018ffa37819ULL, 0x000fe400000114a3ULL, 0x00000079009f7306ULL, 0x000e700000005400ULL,
0x0000008100ae7306ULL, 0x000ff00000209400ULL, 0x0000008100af7306ULL, 0x000fe20000205400ULL,
0x0000009f9c00720bULL, 0x002fce0003f9d000ULL, 0x00000081008d7306ULL, 0x000ff0000020d400ULL,
0x00000079006d7306ULL, 0x000e70000000d400ULL, 0x0000009600907306ULL, 0x000ff00000209400ULL,
0x0000009600917306ULL, 0x000fe20000205400ULL, 0x000000016d6d4812ULL, 0x002fc400078efcffULL,
0x000000a8a500720bULL, 0x000fca0003f9d000ULL, 0x0000009600817306ULL, 0x000ff0000020d400ULL,
0x0000009500967306ULL, 0x000fe20000209400ULL, 0x000000018f8f4812ULL, 0x000fce00078efcffULL,
0x0000009500977306ULL, 0x000e700000205400ULL, 0x0000009500997306ULL, 0x000eb0000020d400ULL,
0x0000009e00a07306ULL, 0x000fe20000209400ULL, 0x000000979600720bULL, 0x002fce0003f5d000ULL,
0x0000009e00a17306ULL, 0x000e6c0000205400ULL, 0x0000000199992812ULL, 0x004fe400078efcffULL,
0x0000009e00a27306ULL, 0x000ea2000020d400ULL, 0x0000009d9a00720bULL, 0x000fce0003f5d000ULL,
0x0000007800797306ULL, 0x000ee2000020d400ULL, 0x000000a1a000720bULL, 0x002fca0003fbd000ULL,
0x0000000192922812ULL, 0x000fe400078efcffULL, 0x000000a300957306ULL, 0x000fec0000209400ULL,
0x00000001a2a25812ULL, 0x004fe400078efcffULL, 0x000000a300a47306ULL, 0x000e620000205400ULL,
0x0000000179796812ULL, 0x008fc400078efcffULL, 0x0000006da26d723eULL, 0x000fca00000010ffULL,
0x000000a9009e7306ULL, 0x000ff00000209400ULL, 0x000000a900ab7306ULL, 0x000ea20000205400ULL,
0x000000a49500720bULL, 0x002fce0003f7d000ULL, 0x000000a300a67306ULL, 0x000e70000020d400ULL,
0x000000a900ad7306ULL, 0x000ee2000020d400ULL, 0x000000ab9e00720bULL, 0x004fce0003fdd000ULL,
0x0000007a00a77306ULL, 0x000fe20000009400ULL, 0x00000001a6a63812ULL, 0x002fce00078efcffULL,
0x0000007a00aa7306ULL, 0x000e620000005400ULL, 0x00000001adad6812ULL, 0x008fe400078efcffULL,
0x000000afae00720bULL, 0x000fca0003fdd000ULL, 0x0000007a008e7306ULL, 0x0004f0000000d400ULL,
0x0000007b00b07306ULL, 0x000fe20000009400ULL, 0x000100007a7a7824ULL, 0x004fe200078e00ffULL,
0x000000aaa700720bULL, 0x002fc40003fbd000ULL, 0x000000018d8d6812ULL, 0x000fe400078efcffULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000007b00b17306ULL, 0x000e6e0000005400ULL,
0x000000018e8e5812ULL, 0x008fe200078efcffULL, 0x0000007b008c7306ULL, 0x0004f0000000d400ULL,
0x0000007a00787306ULL, 0x000fe20000209400ULL, 0x000100007b7b7824ULL, 0x004fe200078e00ffULL,
0x000000b1b000720bULL, 0x002fc80003f7d000ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x0000007a00a37306ULL, 0x000e6e0000205400ULL, 0x000000018c8c3812ULL, 0x008fe200078efcffULL,
0x000000b200b37306ULL, 0x000ff00000209400ULL, 0x000000b200b47306ULL, 0x000ea20000205400ULL,
0x000000a37800720bULL, 0x002fc40003f9d000ULL, 0x000000799278723eULL, 0x000fe400000010ffULL,
0x000000a68f79723eULL, 0x000fc600000010ffULL, 0x000000b200b57306ULL, 0x000e68000020d400ULL,
0x000000787064723cULL, 0x000f680000041864ULL, 0x0000007b00a97306ULL, 0x000fe20000209400ULL,
0x000000b4b300720bULL, 0x004fc60003f5d000ULL, 0x000000782844723cULL, 0x000b680000041844ULL,
0x0000007b00b67306ULL, 0x000ea60000205400ULL, 0x0000001007787824ULL, 0x020fc600078e020aULL,
0x00000001b5b52812ULL, 0x002fe400078efcffULL, 0x000000bb00b27306ULL, 0x000fe20000209400ULL,
0x000000bab700720bULL, 0x000fce0003f5d000ULL, 0x000000bb00bd7306ULL, 0x000e620000205400ULL,
0x000000b6a900720bULL, 0x004fca0003fbd000ULL, 0x0000000185852812ULL, 0x000fe400078efcffULL,
0x000000c400c57306ULL, 0x000ff00000209400ULL, 0x000000c400c67306ULL, 0x000ea20000205400ULL,
0x000000bdb200720bULL, 0x002fce0003f7d000ULL, 0x0000007c00b97306ULL, 0x000ff00000009400ULL,
0x0000007c00bc7306ULL, 0x000fe20000005400ULL, 0x000000c6c500720bULL, 0x004fce0003fdd000ULL,
0x0000007c00847306ULL, 0x0003f0000000d400ULL, 0x0000007d00c27306ULL, 0x000fe20000009400ULL,
0x000100007c7c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007d00c37306ULL, 0x000ff00000005400ULL, 0x0000007d00827306ULL, 0x0003f0000000d400ULL,
0x0000007a00ac7306ULL, 0x000ea2000020d400ULL, 0x000100007d7d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x0000007b00b87306ULL, 0x000e70000020d400ULL,
0x000000bb00bf7306ULL, 0x000ee2000020d400ULL, 0x00000001acac4812ULL, 0x004fc400078efcffULL,
0x000000bcb900720bULL, 0x000fca0003f9d000ULL, 0x000000c400c77306ULL, 0x000ea2000020d400ULL,
0x00000001b8b85812ULL, 0x002fe400078efcffULL, 0x000000c3c200720bULL, 0x000fca0003fbd000ULL,
0x0000007c007a7306ULL, 0x000fe20000209400ULL, 0x00000001bfbf3812ULL, 0x008fe400078efcffULL,
0x0000000184844812ULL, 0x000fe400078efcffULL, 0x000000c1c000720bULL, 0x000fe40003f9d000ULL,
0x00000084bf84723eULL, 0x000fe200000010ffULL, 0x0000007c007b7306ULL, 0x000e620000205400ULL,
0x00000001c7c76812ULL, 0x004fe400078efcffULL, 0x0000000182825812ULL, 0x000fc400078efcffULL,
0x000000919000720bULL, 0x000fc60003fbd000ULL, 0x0000007d00bb7306ULL, 0x000fe40000209400ULL,
0x0000000183834812ULL, 0x000fcc00078efcffULL, 0x0000007d00c87306ULL, 0x000ea20000205400ULL,
0x0000007b7a00720bULL, 0x002fe40003f7d000ULL, 0x0000008cb57b723eULL, 0x000fe400000010ffULL,
0x0000000181815812ULL, 0x000fe400078efcffULL, 0x0000008a8700720bULL, 0x000fe20003fbd000ULL,
0x0000007d00967306ULL, 0x0002e2000020d400ULL, 0x0000008ead7a723eULL, 0x000fce00000010ffULL,
0x0000007c00be7306ULL, 0x000ee2000020d400ULL, 0x000001007f7d7824ULL, 0x002fe200078e00ffULL,
0x000000c8bb00720bULL, 0x004fe20003fdd000ULL, 0x0000007a7060723cULL, 0x080f620000041860ULL,
0x0000000127275812ULL, 0x000fe400078efcffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000007e00c97306ULL, 0x000fe60000009400ULL, 0x0000007a2840723cULL, 0x000f680000041840ULL,
0x0000000196966812ULL, 0x008fe200078efcffULL, 0x0000007e00ca7306ULL, 0x000e620000005400ULL,
0x00000001bebe3812ULL, 0x000fc400078efcffULL, 0x0000009681bf723eULL, 0x000fe400000010ffULL,
0x000000be83be723eULL, 0x000fc600000010ffULL, 0x0000006c007c7306ULL, 0x000fe80000209400ULL,
0x000000be7054723cULL, 0x000f680000041854ULL, 0x0000006c00937306ULL, 0x000ea20000205400ULL,
0x000000cac900720bULL, 0x002fc60003f5d000ULL, 0x000000be2834723cULL, 0x000f680000041834ULL,
0x0000007d00977306ULL, 0x000ff00000209400ULL, 0x0000007d00987306ULL, 0x000e620000205400ULL,
0x000000937c00720bULL, 0x004fc40003f7d000ULL, 0x000000ac8d7c723eULL, 0x000fca00000010ffULL,
0x0000007e00107306ULL, 0x0004f0000000d400ULL, 0x0000007f00867306ULL, 0x000fe20000009400ULL,
0x000100007e7e7824ULL, 0x004fe200078e00ffULL, 0x000000989700720bULL, 0x002fc80003fdd000ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000007f00897306ULL, 0x000e620000005400ULL,
0x0000000110102812ULL, 0x008fce00078efcffULL, 0x0000006c00957306ULL, 0x0004f0000020d400ULL,
0x0000007f000d7306ULL, 0x000ee2000000d400ULL, 0x00000094996c723eULL, 0x004fe400000010ffULL,
0x000000898600720bULL, 0x002fca0003f9d000ULL, 0x0000007d009a7306ULL, 0x0002a2000020d400ULL,
0x0000000195953812ULL, 0x008fe200078efcffULL, 0x0000006c7068723cULL, 0x000f620000041868ULL,
0x000000888b00720bULL, 0x000fca0003f7d000ULL, 0x0000007e007f7306ULL, 0x000fe20000209400ULL,
0x000000b8857d723eULL, 0x002fe200000010ffULL, 0x0000006c2848723cULL, 0x000f620000041848ULL,
0x00000082c785723eULL, 0x000fe400000010ffULL, 0x000000010d0d4812ULL, 0x000fc600078efcffULL,
0x0000007e00947306ULL, 0x000e620000205400ULL, 0x000000019a9a6812ULL, 0x004fe200078efcffULL,
0x0000007c705c723cULL, 0x000f62000004185cULL, 0x000000010f0f3812ULL, 0x000fca00078efcffULL,
0x0000009b008f7306ULL, 0x000fe40000209400ULL, 0x000000847058723cULL, 0x000f6c0000041858ULL,
0x0000009b008c7306ULL, 0x000ea20000205400ULL, 0x000000947f00720bULL, 0x002fe20003f5d000ULL,
0x0000007c283c723cULL, 0x000f62000004183cULL, 0x0000000d9a7f723eULL, 0x000fca00000010ffULL,
0x0000007e00867306ULL, 0x0002e4000020d400ULL, 0x000000842838723cULL, 0x000f6c0000041838ULL,
0x0000009b00827306ULL, 0x000ee2000020d400ULL, 0x0000008c8f00720bULL, 0x004fe40003fdd000ULL,
0x00000010957e723eULL, 0x002fc400000010ffULL, 0x0000000186862812ULL, 0x008fca00078efcffULL,
0x0000007e7050723cULL, 0x000f620000041850ULL, 0x000000862786723eULL, 0x000fc600000010ffULL,
0x0000000182826812ULL, 0x000fc800078efcffULL, 0x0000007e2830723cULL, 0x000f620000041830ULL,
0x000000820f87723eULL, 0x000fce00000010ffULL, 0x00000086704c723cULL, 0x080b6e000004184cULL,
0x000000100c707824ULL, 0x120fe200078e0221ULL, 0x000000862828723cULL, 0x000b62000004182cULL,
0x000000100b217824ULL, 0x000fc800078e0221ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x00000000212c783bULL, 0x0204e20000000200ULL, 0x0000008000000947ULL, 0x000fd20003800000ULL,
0x0000001670707231ULL, 0x082fe400003400ffULL, 0x0000001672727231ULL, 0x000fe400003400ffULL,
0x0000001571717231ULL, 0x080fe400003400ffULL, 0x0000001573737231ULL, 0x000fc400003400ffULL,
0x000000142c2c7231ULL, 0x088fe400003400ffULL, 0x000000142e2e7231ULL, 0x000fe400003400ffULL,
0x000000132d2d7231ULL, 0x080fe400003400ffULL, 0x000000132f2f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010007c7824ULL, 0x000fe200078e020aULL,
0x000000007878783bULL, 0x000eaa0000004200ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000078006c7306ULL, 0x004fe20000009400ULL, 0x00000018ff077819ULL, 0x000fe20000011478ULL,
0x00000100788e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x000fe20000011479ULL,
0x0000010079917824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe2000001147aULL,
0x000001007aa47824ULL, 0x000fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x008fe2000001147dULL,
0x00000078006d7306ULL, 0x000ea20000005400ULL, 0x00000018ff947819ULL, 0x000fe2000001147eULL,
0x000001007ba77824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe2000001148eULL,
0x000001007cb67824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe2000001147bULL,
0x000001007dbc7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe2000001147fULL,
0x00000078008d7306ULL, 0x000662000000d400ULL, 0x00000018ff997819ULL, 0x000fe20000011491ULL,
0x000001007ec77824ULL, 0x000fe200078e00ffULL, 0x00000018ffa47819ULL, 0x000fc400000114a4ULL,
0x00000018ffad7819ULL, 0x000fe400000114a7ULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x0000000700937306ULL, 0x000fe20000209400ULL, 0x0001000078787824ULL, 0x008fe200078e00ffULL,
0x0000006d6c00720bULL, 0x004fe20003fdd000ULL, 0x000001007f6c7824ULL, 0x000fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe400000114bcULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000000700967306ULL, 0x000fe20000205400ULL, 0x00000018ffc77819ULL, 0x000fc400000114c7ULL,
0x00000018ff6c7819ULL, 0x000fc8000001146cULL, 0x000000018d8d6812ULL, 0x002fe200078efcffULL,
0x0000000700987306ULL, 0x0003f0000020d400ULL, 0x0000000f00a07306ULL, 0x000fe20000209400ULL,
0x00000018ff077819ULL, 0x002fce000001147cULL, 0x0000000f00a37306ULL, 0x000ff00000205400ULL,
0x0000000f008a7306ULL, 0x000ff0000020d400ULL, 0x0000001000a97306ULL, 0x000ff00000209400ULL,
0x0000001000aa7306ULL, 0x000ff00000205400ULL, 0x0000001000867306ULL, 0x000ff0000020d400ULL,
0x0000008f008b7306ULL, 0x000ff00000209400ULL, 0x0000008f008c7306ULL, 0x000ff00000205400ULL,
0x0000008f00107306ULL, 0x000ff0000020d400ULL, 0x0000009400887306ULL, 0x000ff00000209400ULL,
0x0000009400897306ULL, 0x000ff00000205400ULL, 0x00000094000f7306ULL, 0x000ff0000020d400ULL,
0x0000007900957306ULL, 0x000ff00000009400ULL, 0x00000079009a7306ULL, 0x000e700000005400ULL,
0x0000008e008f7306ULL, 0x000ff00000209400ULL, 0x0000008e00907306ULL, 0x000ea20000205400ULL,
0x0000009a9500720bULL, 0x002fce0003f5d000ULL, 0x0000007800917306ULL, 0x000ff00000209400ULL,
0x0000007800947306ULL, 0x000e620000205400ULL, 0x000000908f00720bULL, 0x004fce0003fbd000ULL,
0x0000008300b27306ULL, 0x000ff00000209400ULL, 0x0000008300b57306ULL, 0x000fe20000205400ULL,
0x000000949100720bULL, 0x002fce0003f9d000ULL, 0x0000008300827306ULL, 0x000ff0000020d400ULL,
0x0000000700b97306ULL, 0x000ff00000209400ULL, 0x0000000700be7306ULL, 0x000ff00000205400ULL,
0x0000000700277306ULL, 0x000ff0000020d400ULL, 0x0000009d00837306ULL, 0x000ff00000209400ULL,
0x0000009d00847306ULL, 0x000ff00000205400ULL, 0x0000009d00077306ULL, 0x0003f0000020d400ULL,
0x0000007900977306ULL, 0x000ea2000000d400ULL, 0x00010000799d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe4000001149dULL, 0x0000008e00927306ULL, 0x000e70000020d400ULL,
0x00000099009b7306ULL, 0x000fe20000209400ULL, 0x0000000197972812ULL, 0x004fce00078efcffULL,
0x00000099009c7306ULL, 0x000ea20000205400ULL, 0x0000000192925812ULL, 0x002fe400078efcffULL,
0x000000969300720bULL, 0x000fe20003fbd000ULL, 0x000100007f937824ULL, 0x000fc800078e00ffULL,
0x00000099009e7306ULL, 0x000e62000020d400ULL, 0x00000018ff937819ULL, 0x000fce0000011493ULL,
0x0000007800797306ULL, 0x000ee2000020d400ULL, 0x0000009c9b00720bULL, 0x004fe40003f1d000ULL,
0x0000000198985812ULL, 0x000fca00078efcffULL, 0x0000009d008e7306ULL, 0x000fec0000209400ULL,
0x000000019e9e0812ULL, 0x002fe400078efcffULL, 0x0000009d009f7306ULL, 0x000e620000205400ULL,
0x0000000179794812ULL, 0x008fe400078efcffULL, 0x000000a3a000720bULL, 0x000fc40003f1d000ULL,
0x000000979e6d723eULL, 0x000fc600000010ffULL, 0x000000a400997306ULL, 0x000ff00000209400ULL,
0x000000a400a67306ULL, 0x000ea20000205400ULL, 0x0000009f8e00720bULL, 0x002fe40003fdd000ULL,
0x000000018a8a0812ULL, 0x000fc400078efcffULL, 0x000000aaa900720bULL, 0x000fc60003f1d000ULL,
0x000000ad00ae7306ULL, 0x000ff00000209400ULL, 0x000000ad00af7306ULL, 0x000e620000205400ULL,
0x000000a69900720bULL, 0x004fe40003f5d000ULL, 0x0000000186860812ULL, 0x000fca00078efcffULL,
0x0000007a00a27306ULL, 0x000ff00000009400ULL, 0x0000007a00a57306ULL, 0x000ea20000005400ULL,
0x000000afae00720bULL, 0x002fce0003f9d000ULL, 0x0000007a00877306ULL, 0x0002f0000000d400ULL,
0x0000007b00ab7306ULL, 0x000fe20000009400ULL, 0x000100007a7a7824ULL, 0x002fe200078e00ffULL,
0x000000a5a200720bULL, 0x004fc80003f7d000ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x0000007b00ac7306ULL, 0x000e6e0000005400ULL, 0x0000000187873812ULL, 0x008fe200078efcffULL,
0x0000007b00857306ULL, 0x0004e2000000d400ULL, 0x000000b5b200720bULL, 0x000fce0003f7d000ULL,
0x0000009d00a17306ULL, 0x000ee2000020d400ULL, 0x000100007b7b7824ULL, 0x004fe200078e00ffULL,
0x000000acab00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x000000a400a87306ULL, 0x000e62000020d400ULL, 0x0000000182823812ULL, 0x000fcc00078efcffULL,
0x0000000185855812ULL, 0x008fe200078efcffULL, 0x000000ad00b07306ULL, 0x000ea2000020d400ULL,
0x00000001a1a16812ULL, 0x000fce00078efcffULL, 0x0000007a00787306ULL, 0x000fe20000209400ULL,
0x00000001a8a82812ULL, 0x002fce00078efcffULL, 0x0000007a009d7306ULL, 0x000e620000205400ULL,
0x00000001b0b04812ULL, 0x004fce00078efcffULL, 0x0000007c00b47306ULL, 0x000ff00000009400ULL,
0x0000007c00b77306ULL, 0x000ea20000005400ULL, 0x0000009d7800720bULL, 0x002fe40003fdd000ULL,
0x000000799878723eULL, 0x000fc400000010ffULL, 0x000000a18a79723eULL, 0x000fc600000010ffULL,
0x0000007b00a47306ULL, 0x000fe80000209400ULL, 0x000000782c44723cULL, 0x000b680000041844ULL,
0x0000007b00b17306ULL, 0x000e620000205400ULL, 0x000000b7b400720bULL, 0x004fc60003f9d000ULL,
0x000000787064723cULL, 0x000b680000041864ULL, 0x0000007c00817306ULL, 0x0004f0000000d400ULL,
0x0000007a00a77306ULL, 0x000ee2000020d400ULL, 0x000100007c7c7824ULL, 0x004fe200078e00ffULL,
0x000000b1a400720bULL, 0x002fc80003f5d000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007d00bb7306ULL, 0x000fe20000009400ULL, 0x0000000181814812ULL, 0x008fce00078efcffULL,
0x0000007d00c07306ULL, 0x000e620000005400ULL, 0x00000001a7a76812ULL, 0x000fc800078efcffULL,
0x000000a78686723eULL, 0x000fc600000010ffULL, 0x0000007b00b37306ULL, 0x000eb0000020d400ULL,
0x000000b600ad7306ULL, 0x000fe20000209400ULL, 0x000000c0bb00720bULL, 0x002fce0003fdd000ULL,
0x000000b600b87306ULL, 0x000e620000205400ULL, 0x00000001b3b32812ULL, 0x004fce00078efcffULL,
0x000000bd00bf7306ULL, 0x000ff00000209400ULL, 0x000000bd00c27306ULL, 0x000ea20000205400ULL,
0x000000b8ad00720bULL, 0x002fce0003fbd000ULL, 0x0000007c007a7306ULL, 0x000ff00000209400ULL,
0x0000007c007b7306ULL, 0x000e620000205400ULL, 0x000000c2bf00720bULL, 0x004fce0003f5d000ULL,
0x0000007d00217306ULL, 0x0004f0000000d400ULL, 0x000000b600ba7306ULL, 0x000ee2000020d400ULL,
0x000100007d7d7824ULL, 0x004fe200078e00ffULL, 0x0000007b7a00720bULL, 0x002fc40003f9d000ULL,
0x00000085b07b723eULL, 0x000fe400000010ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x000000bd00c47306ULL, 0x000e62000020d400ULL, 0x0000000121216812ULL, 0x008fe400078efcffULL,
0x0000008c8b00720bULL, 0x000fe40003fdd000ULL, 0x00000087a87a723eULL, 0x000fe400000010ffULL,
0x000000b38287723eULL, 0x000fe200000010ffULL, 0x0000007c00bc7306ULL, 0x000ea2000020d400ULL,
0x00000001baba5812ULL, 0x000fc400078efcffULL, 0x000000beb900720bULL, 0x000fe20003fbd000ULL,
0x0000007a2c40723cULL, 0x000b620000041840ULL, 0x00000081baba723eULL, 0x000fc600000010ffULL,
0x0000007e00c57306ULL, 0x000fe20000009400ULL, 0x00000001c4c42812ULL, 0x002fe400078efcffULL,
0x0000000110106812ULL, 0x000fe200078efcffULL, 0x000000862c3c723cULL, 0x000b62000004183cULL,
0x00000021c4bb723eULL, 0x000fc600000010ffULL, 0x0000007e00c67306ULL, 0x000e620000005400ULL,
0x00000001bcbc4812ULL, 0x004fe400078efcffULL, 0x0000000127275812ULL, 0x000fe200078efcffULL,
0x000000ba2c38723cULL, 0x000b620000041838ULL, 0x000000898800720bULL, 0x000fe40003fbd000ULL,
0x000000bc27bc723eULL, 0x000fe200000010ffULL, 0x0000007d00b67306ULL, 0x000fe80000209400ULL,
0x0000007a7060723cULL, 0x000b680000041860ULL, 0x0000007d00c17306ULL, 0x000ea20000205400ULL,
0x000000c6c500720bULL, 0x002fc40003f1d000ULL, 0x000000010f0f5812ULL, 0x000fe200078efcffULL,
0x00000086705c723cULL, 0x040b68000004185cULL, 0x000000c7008f7306ULL, 0x000fe80000209400ULL,
0x000000ba7058723cULL, 0x000b680000041858ULL, 0x000000c7007c7306ULL, 0x000e620000205400ULL,
0x000000c1b600720bULL, 0x004fce0003f5d000ULL, 0x0000007e000d7306ULL, 0x0004f0000000d400ULL,
0x0000007f00c87306ULL, 0x000fe20000009400ULL, 0x000100007e7e7824ULL, 0x004fe200078e00ffULL,
0x0000007c8f00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007f00c97306ULL, 0x000e620000005400ULL, 0x000000010d0d0812ULL, 0x008fce00078efcffULL,
0x0000007d00c37306ULL, 0x000eb0000020d400ULL, 0x000000c7008e7306ULL, 0x000ee2000020d400ULL,
0x000000c9c800720bULL, 0x002fce0003f7d000ULL, 0x0000006c00917306ULL, 0x000fe20000209400ULL,
0x00000001c3c32812ULL, 0x004fe400078efcffULL, 0x000000848300720bULL, 0x000fe40003f5d000ULL,
0x000000c310bd723eULL, 0x000fc600000010ffULL, 0x0000006c00947306ULL, 0x000e620000205400ULL,
0x000000018e8e4812ULL, 0x008fc600078efcffULL, 0x000000bc2c34723cULL, 0x000b620000041834ULL,
0x0000000d8e8e723eULL, 0x000fc600000010ffULL, 0x0000007e007d7306ULL, 0x000fe20000209400ULL,
0x0000000107072812ULL, 0x000fc600078efcffULL, 0x000000bc7054723cULL, 0x000b680000041854ULL,
0x0000007e00907306ULL, 0x000ea20000205400ULL, 0x000000949100720bULL, 0x002fce0003fdd000ULL,
0x00000093008a7306ULL, 0x000ff00000209400ULL, 0x0000009300857306ULL, 0x000e620000205400ULL,
0x000000907d00720bULL, 0x004fce0003f9d000ULL, 0x0000007f00007306ULL, 0x000eb0000000d400ULL,
0x0000006c007f7306ULL, 0x0006e2000020d400ULL, 0x000000858a00720bULL, 0x002fce0003f1d000ULL,
0x0000007e007e7306ULL, 0x000e62000020d400ULL, 0x0000000100003812ULL, 0x004fe400078efcffULL,
0x0000008d926c723eULL, 0x008fca00000010ffULL, 0x00000093007c7306ULL, 0x000ea2000020d400ULL,
0x000000017f7f6812ULL, 0x000fe200078efcffULL, 0x0000006c2c48723cULL, 0x000b660000041848ULL,
0x000000007f8f723eULL, 0x000fe200000010ffULL, 0x0000000202007824ULL, 0x000fe200078e00ffULL,
0x000000017e7e4812ULL, 0x002fc600078efcffULL, 0x0000006c7068723cULL, 0x000b620000041868ULL,
0x0000007e0f7e723eULL, 0x000fe400000010ffULL, 0x0001a6c81f0f7811ULL, 0x000fe400078e18ffULL,
0x000000017c7c0812ULL, 0x004fc600078efcffULL, 0x0000008e2c30723cULL, 0x000b620000041830ULL,
0x0000007c077f723eULL, 0x000fe400000010ffULL, 0xfffffff800077812ULL, 0x000fca00078ec0ffULL,
0x0000008e7050723cULL, 0x040b700000041850ULL, 0x0000007e704c723cULL, 0x080b70000004184cULL,
0x0000007e2c2c723cULL, 0x000b620000041828ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000000f6c7f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6980007ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff007224ULL, 0x000fc600078e00ffULL, 0x0000000000287805ULL, 0x000fc80000015200ULL,
0x000004000f077984ULL, 0x008ee20000000800ULL, 0x00000003200d7810ULL, 0x000fc40007ffe0ffULL,
0x8000000007ff7812ULL, 0x00cfe2000780486dULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a28107210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2a7824ULL, 0x000fe200000e0e29ULL,
0x003d09001000780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401000780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc8000001142aULL, 0x0000001007077211ULL, 0x000fca00078110ffULL,
0x000000ffff107224ULL, 0x000fca00000e062aULL, 0x0000000207077819ULL, 0x000fc80000001210ULL,
0x000000070000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000100007810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000004000f077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x004fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000011b0f7810ULL, 0x002fe40007ffe0ffULL, 0x000000031d1d7810ULL, 0x000fe40007ffe0ffULL,
0x000000060f00720cULL, 0x000fda0003f06070ULL, 0x0000085000000947ULL, 0x000fea0003800000ULL,
0x000000021b077810ULL, 0x000fe20007ffe0ffULL, 0x000001000f0f7824ULL, 0x000fe400078e0280ULL,
0x0000590024247a24ULL, 0x010fe200078e02ffULL, 0x000000060700720cULL, 0x000fe40003f06070ULL,
0x000000200f077812ULL, 0x000fe200078ec0ffULL, 0x0000004024247824ULL, 0x000fc800078e00ffULL,
0x000000011e077824ULL, 0x000fcc00078e0207ULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x0000000f04007217ULL, 0x000fe20007800000ULL, 0x0000001002107824ULL, 0x000fc800078e00ffULL,
0x0000000100007824ULL, 0x000fe200078e0a0fULL, 0x00000010100f7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff107819ULL, 0x000fe40000011608ULL, 0x000000000f007217ULL, 0x000fe40007800000ULL,
0x00000004101d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000810217810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x100fe200078e0a0fULL, 0x0000000c10287810ULL, 0x000fe20007ffe0ffULL,
0x000000011d2a7824ULL, 0x000fc400078e020fULL, 0x0000000121277824ULL, 0x100fe200078e020fULL,
0x000000001000720cULL, 0x0c0fe20003f86070ULL, 0x0000000110107824ULL, 0x000fe200078e020fULL,
0x000000001d00720cULL, 0x080fe20003f66070ULL, 0x000000082a707824ULL, 0x000fe200078e00ffULL,
0x000000002100720cULL, 0x080fe20003f46070ULL, 0x00000001101d7824ULL, 0x100fe200078e0208ULL,
0x000000002800720cULL, 0x000fe20003f06070ULL, 0x00000008106c7824ULL, 0x000fe400078e00ffULL,
0x000000012a217824ULL, 0x000fc400078e0208ULL, 0x00000001280f7824ULL, 0x000fe200078e020fULL,
0xfffffff86c1d7812ULL, 0x000fe200078ee21dULL, 0x0000000110287824ULL, 0x000fe200078e0207ULL,
0xfffffff870217812ULL, 0x000fe200078ee221ULL, 0x000000012a2a7824ULL, 0x100fe400078e0207ULL,
0x00000001276c7824ULL, 0x100fe400078e0207ULL, 0x000000010f707824ULL, 0x040fe400078e0207ULL,
0x000000010f077824ULL, 0x000fc400078e0208ULL, 0x000000080f107824ULL, 0x000fe400078e00ffULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff810737812ULL, 0x000fe200078ee207ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000640024077a11ULL, 0x000fe400078a38ffULL,
0x0000001828287212ULL, 0x080fe200078efcffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x000000182a2a7212ULL, 0x000fe400078efcffULL, 0x00006500240f7a11ULL, 0x000fe200028f3cffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x0000002807287210ULL, 0x000fc40007fbe0ffULL,
0x000000072a2a7210ULL, 0x080fe20007fde0ffULL, 0x0000000127007824ULL, 0x040fe200078e0208ULL,
0x000000186c6c7212ULL, 0x080fe200078efcffULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x0000001870707212ULL, 0x000fe200078efcffULL, 0x0000000129297824ULL, 0x100fe200028e060fULL,
0x000000076c6c7210ULL, 0x080fe20007fbe0ffULL, 0x000000012b2b7824ULL, 0x000fe200030e060fULL,
0xfffffff827277812ULL, 0x000fe200078ee200ULL, 0x000000101d1d7824ULL, 0x100fe200078e020aULL,
0x0000000770707210ULL, 0x000fe20007fde0ffULL, 0x0000001021217824ULL, 0x000fc400078e020aULL,
0x0000001027277824ULL, 0x100fe200078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000281d7faeULL, 0x0003e2000e101c46ULL, 0x000000016d6d7824ULL, 0x100fe400028e060fULL,
0x0000001073737824ULL, 0x000fe200078e020aULL, 0x000000002a217faeULL, 0x0003e2000d901c46ULL,
0x0000000171717824ULL, 0x000fc600030e060fULL, 0x000000006c277faeULL, 0x0003e8000d101c46ULL,
0x0000000070737faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001002007824ULL, 0x000fca00078e00ffULL, 0x00000010000f7812ULL, 0x000fc800078ec0ffULL,
0x0000000f080f7211ULL, 0x000fc800078fe8ffULL, 0x000000040f107810ULL, 0x040fe20007ffe0ffULL,
0x000000010f007824ULL, 0x040fe200078e0208ULL, 0x000000080f217810ULL, 0x040fe20007ffe0ffULL,
0x000000080f1d7824ULL, 0x040fe400078e00ffULL, 0x000000010f287824ULL, 0x140fe200078e0207ULL,
0x0000000c0f0f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001102a7824ULL, 0x040fe200078e0207ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee200ULL, 0x0000000110007824ULL, 0x040fe400078e0208ULL,
0x0000000810277824ULL, 0x000fc400078e00ffULL, 0x00000001216c7824ULL, 0x100fe400078e0207ULL,
0x000000010f707824ULL, 0x000fe400078e0207ULL, 0x0000000121077824ULL, 0x040fe400078e0208ULL,
0x0000000821727824ULL, 0x000fe200078e00ffULL, 0xfffffff827217812ULL, 0x000fe200078ee200ULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff872277812ULL, 0x000fe200078ee207ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000640024077a11ULL, 0x000fe400078038ffULL,
0x0000001828287212ULL, 0x080fe200078efcffULL, 0x000000010f107824ULL, 0x040fe200078e0208ULL,
0x000000182a2a7212ULL, 0x000fe200078efcffULL, 0x000000080f737824ULL, 0x000fe200078e00ffULL,
0x00006500240f7a11ULL, 0x000fe200000f3cffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000002807287210ULL, 0x000fc40007f1e0ffULL, 0xfffffff873737812ULL, 0x000fe200078ee210ULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000186c6c7212ULL, 0x000fc600078efcffULL,
0x0000000129297824ULL, 0x100fe200000e060fULL, 0x0000001870707212ULL, 0x000fe200078efcffULL,
0x000000101d1d7824ULL, 0x100fe200078e020aULL, 0x0000002a072a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001021217824ULL, 0x100fe200078e020aULL, 0x0000006c076c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001027277824ULL, 0x000fe200078e020aULL, 0x0000007007707210ULL, 0x000fe20007f7e0ffULL,
0x000000012b2b7824ULL, 0x100fe200000e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000281d7faeULL, 0x0003e2000b901c46ULL, 0x000000016d6d7824ULL, 0x000fc400010e060fULL,
0x0000001073737824ULL, 0x000fe200078e020aULL, 0x000000002a217faeULL, 0x0003e2000b901c46ULL,
0x0000000171717824ULL, 0x000fc600018e060fULL, 0x000000006c277faeULL, 0x0003e8000b901c46ULL,
0x0000000070737faeULL, 0x0003e4000b901c46ULL, 0x000000041a1d7810ULL, 0x002fe20007ffe0ffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0xffffffffff247424ULL, 0x000fe400078e00ffULL,
0x000000051d00720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000011c287824ULL, 0x000fe400078e021dULL, 0x00000004ff297424ULL, 0x000fc800078e00ffULL,
0x0000660028287625ULL, 0x000fca00078e0029ULL, 0x0000000628247981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000802007824ULL, 0x000fe400078e00ffULL,
0x0000000220077824ULL, 0x000fc600078e0275ULL, 0xfffffff000287812ULL, 0x042fe400078ec0ffULL,
0x0000000800007812ULL, 0x000fe400078ec0ffULL, 0x00000000280473c2ULL, 0x000e6600000e0000ULL,
0x0000001007077824ULL, 0x000fe400078e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0001a6a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6a80028287f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a66800076c7f8cULL, 0x0004e2000c80043fULL, 0x000000ffff007224ULL, 0x002fc600078e0029ULL,
0x0000000000287805ULL, 0x000fc80000015200ULL, 0x01a66c00070f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x00afe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a280f7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2a7824ULL, 0x000fe200000e0e29ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001142aULL, 0x0000000f0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e062aULL, 0x000000020a0a7819ULL, 0x000fc8000000120fULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000110107810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a66c00070f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000800d077824ULL, 0x004fc800078e0218ULL,
0x0000000174077824ULL, 0x000fca00078e0207ULL, 0x01a00000072a7984ULL, 0x000e680000000800ULL,
0x01a20000070a7984ULL, 0x0004e20000000800ULL, 0x000000232a00720bULL, 0x002fe20003f1d000ULL,
0x000101d27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000f7806ULL, 0x004fc800000e0100ULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x00000001ff107424ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fd200078e0023ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x000000020d00720cULL, 0x000fe40003f05270ULL,
0x000000232a00720bULL, 0x000fe20003f54000ULL, 0x000101a27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001a7806ULL, 0x000fc400010e0100ULL, 0x0000008002218824ULL, 0x000fe200078e0218ULL,
0x000000232a077209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000174748824ULL, 0x000fca00078e0221ULL, 0x01a4000774008388ULL, 0x0003e20000000800ULL,
0x000000ff1a00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000002307187221ULL, 0x002fe20000010100ULL, 0x000000ff1aff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b18187820ULL, 0x000fc80000410000ULL,
0x0000001800217308ULL, 0x000e640000000800ULL, 0x0000002122227220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe20000011608ULL,
0x000100f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2921287589ULL, 0x0002a400000e0000ULL,
0x0000002868687220ULL, 0x084fe40000410000ULL, 0x0000002869697220ULL, 0x080fe40000410000ULL,
0x0000002864647220ULL, 0x080fe40000410000ULL, 0x0000002865657220ULL, 0x080fe40000410000ULL,
0x0000002860607220ULL, 0x080fe40000410000ULL, 0x0000002861617220ULL, 0x000fc40000410000ULL,
0x000000285c5c7220ULL, 0x080fe40000410000ULL, 0x000000285d5d7220ULL, 0x080fe40000410000ULL,
0x0000002858587220ULL, 0x080fe40000410000ULL, 0x0000002859597220ULL, 0x080fe40000410000ULL,
0x0000002854547220ULL, 0x080fe40000410000ULL, 0x0000002855557220ULL, 0x000fc40000410000ULL,
0x0000002850507220ULL, 0x080fe40000410000ULL, 0x0000002851517220ULL, 0x080fe40000410000ULL,
0x000000284c4c7220ULL, 0x080fe40000410000ULL, 0x000000284d4d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001aff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000808297811ULL, 0x002fe200078ff0ffULL, 0x0000ffe27f007947ULL, 0x000fea000b800000ULL,
0x00001f2921287589ULL, 0x0002a400000e0000ULL, 0x000000286a6a7220ULL, 0x084fe40000410000ULL,
0x000000286b6b7220ULL, 0x080fe40000410000ULL, 0x0000002866667220ULL, 0x080fe40000410000ULL,
0x0000002867677220ULL, 0x080fe40000410000ULL, 0x0000002862627220ULL, 0x080fe40000410000ULL,
0x0000002863637220ULL, 0x000fc40000410000ULL, 0x000000285e5e7220ULL, 0x080fe40000410000ULL,
0x000000285f5f7220ULL, 0x080fe40000410000ULL, 0x000000285a5a7220ULL, 0x080fe40000410000ULL,
0x000000285b5b7220ULL, 0x080fe40000410000ULL, 0x0000002856567220ULL, 0x080fe40000410000ULL,
0x0000002857577220ULL, 0x000fc40000410000ULL, 0x0000002852527220ULL, 0x080fe40000410000ULL,
0x0000002853537220ULL, 0x080fe40000410000ULL, 0x000000284e4e7220ULL, 0x080fe40000410000ULL,
0x000000284f4f7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00001aff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001008297811ULL, 0x002fe200078ff0ffULL,
0x0000fed27f007947ULL, 0x000fea000b800000ULL, 0x00001f2921287589ULL, 0x0002a400000e0000ULL,
0x0000002848487220ULL, 0x084fe40000410000ULL, 0x0000002849497220ULL, 0x080fe40000410000ULL,
0x0000002844447220ULL, 0x080fe40000410000ULL, 0x0000002845457220ULL, 0x080fe40000410000ULL,
0x0000002840407220ULL, 0x080fe40000410000ULL, 0x0000002841417220ULL, 0x000fc40000410000ULL,
0x000000283c3c7220ULL, 0x080fe40000410000ULL, 0x000000283d3d7220ULL, 0x080fe40000410000ULL,
0x0000002838387220ULL, 0x080fe40000410000ULL, 0x0000002839397220ULL, 0x080fe40000410000ULL,
0x0000002834347220ULL, 0x080fe40000410000ULL, 0x0000002835357220ULL, 0x000fc40000410000ULL,
0x0000002830307220ULL, 0x080fe40000410000ULL, 0x0000002831317220ULL, 0x080fe40000410000ULL,
0x000000282c2c7220ULL, 0x080fe40000410000ULL, 0x000000282d2d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000001aff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001808297811ULL, 0x002fe200078ff0ffULL,
0x0000fdd27f007947ULL, 0x000fea000b800000ULL, 0x00001f2921287589ULL, 0x0002a400000e0000ULL,
0x000000284a4a7220ULL, 0x084fe40000410000ULL, 0x000000284b4b7220ULL, 0x080fe40000410000ULL,
0x0000002846467220ULL, 0x080fe40000410000ULL, 0x0000002847477220ULL, 0x080fe40000410000ULL,
0x0000002842427220ULL, 0x080fe40000410000ULL, 0x0000002843437220ULL, 0x000fc40000410000ULL,
0x000000283e3e7220ULL, 0x080fe40000410000ULL, 0x000000283f3f7220ULL, 0x080fe40000410000ULL,
0x000000283a3a7220ULL, 0x080fe40000410000ULL, 0x000000283b3b7220ULL, 0x080fe40000410000ULL,
0x0000002836367220ULL, 0x080fe40000410000ULL, 0x0000002837377220ULL, 0x000fc40000410000ULL,
0x0000002832327220ULL, 0x080fe40000410000ULL, 0x0000002833337220ULL, 0x080fe40000410000ULL,
0x000000282e2e7220ULL, 0x080fe40000410000ULL, 0x000000282f2f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000001a0fff7212ULL, 0x000fda00078030ffULL,
0x0000002a070f0221ULL, 0x000fe20000010100ULL, 0x00007610ff100816ULL, 0x000fc60000000010ULL,
0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL, 0x0000000f00170308ULL, 0x000e640000000800ULL,
0x000000170a0a0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000220a227221ULL, 0x008fc40000010000ULL, 0x0000000000287805ULL, 0x000fca0000015200ULL,
0x00000008020a7824ULL, 0x000fca00078e00ffULL, 0xfffffff00a187812ULL, 0x000fca00078ec0ffULL,
0x01a6b400180f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a280f7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2a7824ULL, 0x000fe200000e0e29ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001142aULL,
0x0000000f0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e062aULL,
0x000000020a0a7819ULL, 0x000fc8000000120fULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6b400180f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910100a7816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000017ff0a723eULL, 0x000fe400000010ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011608ULL,
0x000054100a0a7816ULL, 0x000fe2000000000aULL, 0x0000f9c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0a167589ULL, 0x0002a400000e0000ULL, 0x000000080f297810ULL, 0x000fe20007ffe0ffULL,
0x0000fa127f007947ULL, 0x000fea000b800000ULL, 0x000000100f137810ULL, 0x000fe20007ffe0ffULL,
0x00001f290a157589ULL, 0x00066800000e0000ULL, 0x00001f130a147589ULL, 0x0006a400000e0000ULL,
0x000000180f297810ULL, 0x008fe20007ffe0ffULL, 0x0000faa27f007947ULL, 0x000fea000b800000ULL,
0x00001f290a137589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff0a7819ULL, 0x00afe20000011608ULL, 0x0000000402107824ULL, 0x000fe200078e00ffULL,
0x000120000d0d7811ULL, 0x000fe200078e60ffULL, 0x00000008121a7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004750a7824ULL, 0x000fe200078e020aULL,
0x0000000410187812ULL, 0x000fe200078ec0ffULL, 0x0000000811217824ULL, 0x000fe200078e00ffULL,
0x0000017000007945ULL, 0x000fe20003800000ULL, 0x00000001120f7824ULL, 0x000fc400078e020aULL,
0x00000001110a7824ULL, 0x000fe400078e020aULL, 0x000000100e707824ULL, 0x000fe200078e0225ULL,
0xfffffff81a107812ULL, 0x000fe400078ee20fULL, 0x00000002180f7812ULL, 0x000fe400078efcffULL,
0xfffffff821187812ULL, 0x000fe200078ee20aULL, 0x0000001010107824ULL, 0x000fe200078e020dULL,
0x0000000f080a7211ULL, 0x000fe200078fe0ffULL, 0x00000008120f7824ULL, 0x000fc400078e00ffULL,
0x0000001018187824ULL, 0x000fe200078e020dULL, 0x00000000106c783bULL, 0x0002e20000000200ULL,
0x0000000112127824ULL, 0x000fc600078e020aULL, 0x000000001828783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x000000166c6c7231ULL, 0x08cfe400003400ffULL,
0x000000166e6e7231ULL, 0x000fe400003400ffULL, 0x000000156d6d7231ULL, 0x080fe400003400ffULL,
0x000000156f6f7231ULL, 0x000fe400003400ffULL, 0x0000001428287231ULL, 0x080fe400003400ffULL,
0x000000142a2a7231ULL, 0x000fc400003400ffULL, 0x0000001329297231ULL, 0x080fe400003400ffULL,
0x000000132b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff80f127812ULL, 0x000fe200078ee212ULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0x00000fa000007945ULL, 0x000fe20003800000ULL, 0x00000001110a7824ULL, 0x040fe400078e020aULL,
0x0000001012127824ULL, 0x000fe400078e0225ULL, 0x0000000811117824ULL, 0x000fc600078e00ffULL,
0x000000001278783bULL, 0x0006a20000004200ULL, 0x00000018ff0f7819ULL, 0x002fe20000011470ULL,
0x0000007000857306ULL, 0x000fe20000009400ULL, 0x0000010070887824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe20000011473ULL, 0x00000100718b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff127819ULL, 0x008fe20000011471ULL, 0x0000010072a07824ULL, 0x000fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe20000011472ULL, 0x0000010073a47824ULL, 0x000fe200078e00ffULL,
0x0000007000867306ULL, 0x000e620000005400ULL, 0x00000018ff8e7819ULL, 0x004fe2000001147bULL,
0x0000010078b27824ULL, 0x000fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe2000001148bULL,
0x0000010079b77824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fc40000011479ULL,
0x00000018ff8d7819ULL, 0x000fe2000001147aULL, 0x0000007000877306ULL, 0x0004e2000000d400ULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x00000018ffa07819ULL, 0x000fe400000114a0ULL,
0x00000018ffa77819ULL, 0x000fe400000114a4ULL, 0x00000018ffb27819ULL, 0x000fe200000114b2ULL,
0x0000000f008f7306ULL, 0x000fe20000209400ULL, 0x0001000070707824ULL, 0x004fe200078e00ffULL,
0x000000868500720bULL, 0x002fe20003f7d000ULL, 0x000001007a867824ULL, 0x000fe200078e00ffULL,
0x00000018ffb77819ULL, 0x000fc400000114b7ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000000f00907306ULL, 0x000fe20000205400ULL, 0x00000018ff867819ULL, 0x000fcc0000011486ULL,
0x0000000187873812ULL, 0x008fe200078efcffULL, 0x0000000f00927306ULL, 0x0003f0000020d400ULL,
0x0000007100917306ULL, 0x000fe20000009400ULL, 0x00000018ff0f7819ULL, 0x002fce0000011478ULL,
0x0000007100947306ULL, 0x000e700000005400ULL, 0x0000007d00ae7306ULL, 0x000ff00000209400ULL,
0x0000007d00af7306ULL, 0x000fe20000205400ULL, 0x000000949100720bULL, 0x002fce0003f9d000ULL,
0x0000007d00277306ULL, 0x000ff0000020d400ULL, 0x0000000f00b37306ULL, 0x000ff00000209400ULL,
0x0000000f00ba7306ULL, 0x000ff00000205400ULL, 0x0000000f00217306ULL, 0x000ff0000020d400ULL,
0x0000008e007e7306ULL, 0x000ff00000209400ULL, 0x0000008e007d7306ULL, 0x000ff00000205400ULL,
0x0000008e000f7306ULL, 0x000ff0000020d400ULL, 0x00000070008b7306ULL, 0x000ff00000209400ULL,
0x00000070008e7306ULL, 0x000e700000205400ULL, 0x0000007100937306ULL, 0x0004f0000000d400ULL,
0x00000012009b7306ULL, 0x000fe20000209400ULL, 0x0001000071717824ULL, 0x004fe200078e00ffULL,
0x0000008e8b00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x00000012009c7306ULL, 0x000e620000205400ULL, 0x0000000193934812ULL, 0x008fce00078efcffULL,
0x00000012009d7306ULL, 0x000eb0000020d400ULL, 0x0000001a00a37306ULL, 0x000fe20000209400ULL,
0x0000009c9b00720bULL, 0x002fce0003f9d000ULL, 0x0000001a00a67306ULL, 0x000fec0000205400ULL,
0x000000019d9d4812ULL, 0x004fe400078efcffULL, 0x0000001a00837306ULL, 0x000ff0000020d400ULL,
0x0000008900bf7306ULL, 0x000ff00000209400ULL, 0x0000008900c07306ULL, 0x000ff00000205400ULL,
0x00000089001a7306ULL, 0x000ff0000020d400ULL, 0x0000008d007c7306ULL, 0x000ff00000209400ULL,
0x0000008d007f7306ULL, 0x000ff00000205400ULL, 0x0000008d00127306ULL, 0x000ff0000020d400ULL,
0x0000008800897306ULL, 0x000ff00000209400ULL, 0x00000088008a7306ULL, 0x000e700000205400ULL,
0x00000088008c7306ULL, 0x000eb0000020d400ULL, 0x0000009500967306ULL, 0x000fe20000209400ULL,
0x0000008a8900720bULL, 0x002fe20003f5d000ULL, 0x000100007b8a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x0000009500977306ULL, 0x000e6c0000205400ULL,
0x000000018c8c2812ULL, 0x004fe400078efcffULL, 0x0000009500987306ULL, 0x000ea2000020d400ULL,
0x000000908f00720bULL, 0x000fce0003f5d000ULL, 0x00000070008d7306ULL, 0x000ee2000020d400ULL,
0x000000979600720bULL, 0x002fca0003fbd000ULL, 0x0000000192922812ULL, 0x000fe400078efcffULL,
0x0000007100887306ULL, 0x000fec0000209400ULL, 0x0000000198985812ULL, 0x004fe400078efcffULL,
0x0000007100997306ULL, 0x000e620000205400ULL, 0x000000018d8d6812ULL, 0x008fce00078efcffULL,
0x000000a000957306ULL, 0x000ff00000209400ULL, 0x000000a000a27306ULL, 0x000ea20000205400ULL,
0x000000998800720bULL, 0x002fce0003f7d000ULL, 0x00000072009e7306ULL, 0x000ff00000009400ULL,
0x00000072009f7306ULL, 0x000e620000005400ULL, 0x000000a29500720bULL, 0x004fce0003fdd000ULL,
0x0000007200847306ULL, 0x0004f0000000d400ULL, 0x00000071009a7306ULL, 0x000ee2000020d400ULL,
0x0001000072727824ULL, 0x004fe200078e00ffULL, 0x0000009f9e00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x000000a000a17306ULL, 0x000e6e000020d400ULL,
0x0000000184845812ULL, 0x008fe200078efcffULL, 0x0000007200707306ULL, 0x000fe20000209400ULL,
0x000000019a9a3812ULL, 0x000fce00078efcffULL, 0x0000007200717306ULL, 0x000ea20000205400ULL,
0x00000001a1a16812ULL, 0x002fe400078efcffULL, 0x000000a6a300720bULL, 0x000fca0003fdd000ULL,
0x0000007300a57306ULL, 0x000ff00000009400ULL, 0x0000007300a87306ULL, 0x000e620000005400ULL,
0x000000717000720bULL, 0x004fe40003f9d000ULL, 0x0000000183836812ULL, 0x000fc400078efcffULL,
0x000000878c70723eULL, 0x000fe400000010ffULL, 0x000000939871723eULL, 0x000fe200000010ffULL,
0x0000007300827306ULL, 0x0004ec000000d400ULL, 0x000000702848723cULL, 0x000f640000041848ULL,
0x0000007200a47306ULL, 0x000ee2000020d400ULL, 0x0001000073737824ULL, 0x004fe200078e00ffULL,
0x000000a8a500720bULL, 0x002fc80003f7d000ULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x000000706c68723cULL, 0x000f620000041868ULL, 0x0000007800b07306ULL, 0x000fee0000009400ULL,
0x0000000182823812ULL, 0x008fe200078efcffULL, 0x0000007800b17306ULL, 0x000e620000005400ULL,
0x00000001a4a44812ULL, 0x000fc800078efcffULL, 0x000000a483a4723eULL, 0x000fc600000010ffULL,
0x000000a700a97306ULL, 0x000ff00000209400ULL, 0x000000a700aa7306ULL, 0x000ea20000205400ULL,
0x000000b1b000720bULL, 0x002fce0003f9d000ULL, 0x000000a700ab7306ULL, 0x000e70000020d400ULL,
0x0000007300a07306ULL, 0x000fe20000209400ULL, 0x000000aaa900720bULL, 0x004fce0003f5d000ULL,
0x0000007300ad7306ULL, 0x000eac0000205400ULL, 0x00000001abab2812ULL, 0x002fe400078efcffULL,
0x000000b200a77306ULL, 0x000fe20000209400ULL, 0x000000afae00720bULL, 0x000fce0003f5d000ULL,
0x000000b200b47306ULL, 0x000e620000205400ULL, 0x000000ada000720bULL, 0x004fca0003fbd000ULL,
0x0000000127272812ULL, 0x000fe400078efcffULL, 0x000000b700b97306ULL, 0x000ff00000209400ULL,
0x000000b700be7306ULL, 0x000ea20000205400ULL, 0x000000b4a700720bULL, 0x002fce0003f7d000ULL,
0x0000007800237306ULL, 0x0002f0000000d400ULL, 0x0000007900b57306ULL, 0x000fe20000009400ULL,
0x0001000078787824ULL, 0x002fe200078e00ffULL, 0x000000beb900720bULL, 0x004fc80003fdd000ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000007900bc7306ULL, 0x000fe20000005400ULL,
0x0000000123234812ULL, 0x008fe400078efcffULL, 0x000000bab300720bULL, 0x000fca0003f9d000ULL,
0x0000007900187306ULL, 0x0003f0000000d400ULL, 0x0000007300ac7306ULL, 0x000ea2000020d400ULL,
0x0001000079797824ULL, 0x002fe200078e00ffULL, 0x0000000121214812ULL, 0x000fc800078efcffULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x000000b200b67306ULL, 0x000e70000020d400ULL,
0x000000b700bb7306ULL, 0x000ee2000020d400ULL, 0x00000001acac5812ULL, 0x004fc400078efcffULL,
0x000000bcb500720bULL, 0x000fe40003fbd000ULL, 0x000000ac27a5723eULL, 0x000fc600000010ffULL,
0x0000007800727306ULL, 0x000fe20000209400ULL, 0x00000001b6b63812ULL, 0x002fc600078efcffULL,
0x000000a4283c723cULL, 0x000f62000004183cULL, 0x00000023b6b6723eULL, 0x000fc600000010ffULL,
0x0000007800737306ULL, 0x000e620000205400ULL, 0x00000001bbbb6812ULL, 0x008fe400078efcffULL,
0x0000000118185812ULL, 0x000fe200078efcffULL, 0x000000a46c5c723cULL, 0x000f62000004185cULL,
0x000000c0bf00720bULL, 0x000fe40003fbd000ULL, 0x00000018bbb7723eULL, 0x000fe200000010ffULL,
0x0000007900b27306ULL, 0x000fec0000209400ULL, 0x000000b62838723cULL, 0x000f640000041838ULL,
0x0000007900bd7306ULL, 0x000ea20000205400ULL, 0x000000737200720bULL, 0x002fc40003f7d000ULL,
0x000000011a1a5812ULL, 0x000fe400078efcffULL, 0x0000007f7c00720bULL, 0x000fe20003fbd000ULL,
0x000000b66c58723cULL, 0x000f620000041858ULL, 0x0000008d9272723eULL, 0x000fe200000010ffULL,
0x0000007900857306ULL, 0x0002e2000020d400ULL, 0x0000009a9d73723eULL, 0x000fce00000010ffULL,
0x0000007b00747306ULL, 0x000fe20000009400ULL, 0x000001007b797824ULL, 0x002fe200078e00ffULL,
0x000000bdb200720bULL, 0x004fe20003fdd000ULL, 0x000000722844723cULL, 0x080f620000041844ULL,
0x0000000112125812ULL, 0x000fe400078efcffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000007b00817306ULL, 0x000e660000005400ULL, 0x000000726c64723cULL, 0x000f680000041864ULL,
0x0000000185856812ULL, 0x008fe200078efcffULL, 0x0000007800b87306ULL, 0x000ea6000020d400ULL,
0x000000851ab9723eULL, 0x000fca00000010ffULL, 0x0000007a00c17306ULL, 0x000fe20000009400ULL,
0x000000817400720bULL, 0x002fce0003f9d000ULL, 0x0000007a00c27306ULL, 0x000e620000005400ULL,
0x00000001b8b83812ULL, 0x004fc800078efcffULL, 0x000000b821b8723eULL, 0x000fc600000010ffULL,
0x0000008600787306ULL, 0x000fe80000209400ULL, 0x000000b82834723cULL, 0x000f680000041834ULL,
0x0000008600897306ULL, 0x000ea20000205400ULL, 0x000000c2c100720bULL, 0x002fc60003f5d000ULL,
0x000000b86c54723cULL, 0x000f680000041854ULL, 0x0000007900887306ULL, 0x000ff00000209400ULL,
0x00000079008f7306ULL, 0x000e620000205400ULL, 0x000000897800720bULL, 0x004fc40003f7d000ULL,
0x00000084a178723eULL, 0x000fca00000010ffULL, 0x0000007a00107306ULL, 0x0004f0000000d400ULL,
0x0000007b000e7306ULL, 0x000ee2000000d400ULL, 0x000100007a7a7824ULL, 0x004fe200078e00ffULL,
0x0000008f8800720bULL, 0x002fc80003fdd000ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x00000086008b7306ULL, 0x000e62000020d400ULL, 0x0000000110102812ULL, 0x008fce00078efcffULL,
0x0000007900917306ULL, 0x0004e2000020d400ULL, 0x000000010e0e4812ULL, 0x000fce00078efcffULL,
0x0000007a007b7306ULL, 0x000fe20000209400ULL, 0x000000018b8b3812ULL, 0x002fe400078efcffULL,
0x0000007d7e00720bULL, 0x000fe40003f7d000ULL, 0x00000082ab79723eULL, 0x004fc600000010ffULL,
0x0000007a00867306ULL, 0x000e620000205400ULL, 0x0000000191916812ULL, 0x008fc600078efcffULL,
0x000000782840723cULL, 0x000f680000041840ULL, 0x0000008a00877306ULL, 0x000fe20000209400ULL,
0x000000010f0f3812ULL, 0x000fc600078efcffULL, 0x000000786c60723cULL, 0x000f680000041860ULL,
0x0000008a00747306ULL, 0x000ea20000205400ULL, 0x000000867b00720bULL, 0x002fe40003f5d000ULL,
0x0000000e917b723eULL, 0x000fca00000010ffULL, 0x0000007a00277306ULL, 0x0002f0000020d400ULL,
0x0000008a008a7306ULL, 0x000ee2000020d400ULL, 0x000000748700720bULL, 0x004fe40003fdd000ULL,
0x000000108b7a723eULL, 0x002fe200000010ffULL, 0x000000100c107824ULL, 0x000fc400078e020dULL,
0x000000100b0d7824ULL, 0x000fe200078e020dULL, 0x0000000127272812ULL, 0x008fc600078efcffULL,
0x0000007a2830723cULL, 0x000f620000041830ULL, 0x00000027120e723eULL, 0x000fc600000010ffULL,
0x000000018a8a6812ULL, 0x000fc800078efcffULL, 0x0000007a6c50723cULL, 0x000f620000041850ULL,
0x0000008a0f0f723eULL, 0x000fce00000010ffULL, 0x0000000e6c4c723cULL, 0x080f70000004184cULL,
0x0000000e282c723cULL, 0x000b64000004182cULL, 0x000000001028783bULL, 0x0202a80000000200ULL,
0x000000000d0c783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fd80003800000ULL,
0x0000001628287231ULL, 0x084fe400003400ffULL, 0x000000162a2a7231ULL, 0x000fc400003400ffULL,
0x0000001529297231ULL, 0x080fe400003400ffULL, 0x000000152b2b7231ULL, 0x000fe400003400ffULL,
0x000000140c0c7231ULL, 0x088fe400003400ffULL, 0x000000140e0e7231ULL, 0x000fe400003400ffULL,
0x000000130d0d7231ULL, 0x080fe400003400ffULL, 0x000000130f0f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff8110a7812ULL, 0x000fe200078ee20aULL,
0x00000000266c783bULL, 0x000e680000004200ULL, 0x000000100a0a7824ULL, 0x000fca00078e0225ULL,
0x000000000a70783bULL, 0x000ee20000004200ULL, 0x0000006c00277306ULL, 0x002fe20000009400ULL,
0x00000018ff0b7819ULL, 0x000fe2000001146cULL, 0x000001006c267824ULL, 0x000fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fe2000001146dULL, 0x000001006d7d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fe2000001146eULL, 0x000001006e947824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000006c007a7306ULL, 0x000e620000005400ULL,
0x00000018ff7b7819ULL, 0x008fe20000011471ULL, 0x000001006f997824ULL, 0x040fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011472ULL, 0x000100006f9f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe2000001146fULL, 0x0000010070a77824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011473ULL, 0x0000006c00797306ULL, 0x0006a2000000d400ULL,
0x00000018ff857819ULL, 0x000fe2000001147dULL, 0x0000010071ad7824ULL, 0x040fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011494ULL, 0x0001000071b27824ULL, 0x000fe200078e00ffULL,
0x00000018ff997819ULL, 0x000fe20000011499ULL, 0x0000010072b97824ULL, 0x000fe200078e00ffULL,
0x00000018ff9f7819ULL, 0x000fe2000001149fULL, 0x0000000b007f7306ULL, 0x000fe20000209400ULL,
0x000100006c6c7824ULL, 0x008fe200078e00ffULL, 0x0000007a2700720bULL, 0x002fc40003fdd000ULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000000b00847306ULL, 0x000fe20000205400ULL, 0x00000018ffad7819ULL, 0x000fe400000114adULL,
0x00000018ffb27819ULL, 0x000fe400000114b2ULL, 0x00000018ffb97819ULL, 0x000fe400000114b9ULL,
0x0000000179796812ULL, 0x004fe200078efcffULL, 0x0000000b00867306ULL, 0x0003f0000020d400ULL,
0x00000011008e7306ULL, 0x000fe20000209400ULL, 0x00000018ff0b7819ULL, 0x002fce0000011470ULL,
0x00000011008f7306ULL, 0x000ff00000205400ULL, 0x0000001100907306ULL, 0x000ff0000020d400ULL,
0x0000001200957306ULL, 0x000ff00000209400ULL, 0x00000012009a7306ULL, 0x000ff00000205400ULL,
0x00000012009c7306ULL, 0x000ff0000020d400ULL, 0x0000007b00b57306ULL, 0x000ff00000209400ULL,
0x0000007b00b67306ULL, 0x000ff00000205400ULL, 0x0000007b00127306ULL, 0x000ff0000020d400ULL,
0x0000008200ba7306ULL, 0x000ff00000209400ULL, 0x0000008200bb7306ULL, 0x000ff00000205400ULL,
0x0000008200117306ULL, 0x000ff0000020d400ULL, 0x0000006d00817306ULL, 0x000ff00000009400ULL,
0x0000006d00887306ULL, 0x000e700000005400ULL, 0x00000026007b7306ULL, 0x000ff00000209400ULL,
0x00000026007c7306ULL, 0x000ea20000205400ULL, 0x000000888100720bULL, 0x002fce0003f5d000ULL,
0x0000006c007d7306ULL, 0x000ff00000209400ULL, 0x0000006c00827306ULL, 0x000e620000205400ULL,
0x0000007c7b00720bULL, 0x004fce0003fbd000ULL, 0x0000002500a37306ULL, 0x000ff00000209400ULL,
0x0000002500a47306ULL, 0x000fe20000205400ULL, 0x000000827d00720bULL, 0x002fe20003f9d000ULL,
0x0001000073827824ULL, 0x000fca00078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011482ULL,
0x0000002500237306ULL, 0x000ff0000020d400ULL, 0x0000000b00a97306ULL, 0x000ff00000209400ULL,
0x0000000b00ac7306ULL, 0x000ff00000205400ULL, 0x0000000b001a7306ULL, 0x000ff0000020d400ULL,
0x0000008900257306ULL, 0x000ff00000209400ULL, 0x0000008900747306ULL, 0x000ff00000205400ULL,
0x00000089000b7306ULL, 0x0003f0000020d400ULL, 0x0000006d00837306ULL, 0x000ea2000000d400ULL,
0x000100006d897824ULL, 0x002fca00078e00ffULL, 0x00000018ff897819ULL, 0x000fe40000011489ULL,
0x00000026007e7306ULL, 0x000e70000020d400ULL, 0x0000008500877306ULL, 0x000fe20000209400ULL,
0x0000000183832812ULL, 0x004fce00078efcffULL, 0x00000085008a7306ULL, 0x000ea20000205400ULL,
0x000000017e7e5812ULL, 0x002fe400078efcffULL, 0x000000847f00720bULL, 0x000fca0003fbd000ULL,
0x00000085008c7306ULL, 0x000e70000020d400ULL, 0x0000006c006d7306ULL, 0x000ee2000020d400ULL,
0x0000008a8700720bULL, 0x004fe40003f1d000ULL, 0x0000000186865812ULL, 0x000fca00078efcffULL,
0x0000008900267306ULL, 0x000fec0000209400ULL, 0x000000018c8c0812ULL, 0x002fe400078efcffULL,
0x00000089008b7306ULL, 0x000e620000205400ULL, 0x000000016d6d4812ULL, 0x008fe400078efcffULL,
0x0000008f8e00720bULL, 0x000fc40003f1d000ULL, 0x000000838c27723eULL, 0x000fc600000010ffULL,
0x0000009400857306ULL, 0x000ff00000209400ULL, 0x0000009400967306ULL, 0x000ea20000205400ULL,
0x0000008b2600720bULL, 0x002fe20003fdd000ULL, 0x0000010073267824ULL, 0x000fe200078e00ffULL,
0x0000000190900812ULL, 0x000fc400078efcffULL, 0x0000009a9500720bULL, 0x000fe40003f1d000ULL,
0x00000018ff7f7819ULL, 0x000fe20000011426ULL, 0x00000099009b7306ULL, 0x000fe20000209400ULL,
0x000000797e26723eULL, 0x000fce00000010ffULL, 0x0000009900a07306ULL, 0x000e620000205400ULL,
0x000000968500720bULL, 0x004fe20003f5d000ULL, 0x000000262868723cULL, 0x000b620000041868ULL,
0x000000019c9c0812ULL, 0x000fca00078efcffULL, 0x0000006e00917306ULL, 0x000fe40000009400ULL,
0x000000260c48723cULL, 0x000b6c0000041848ULL, 0x0000006e00927306ULL, 0x000ea20000005400ULL,
0x000000a09b00720bULL, 0x002fce0003f9d000ULL, 0x0000006e00937306ULL, 0x0002f0000000d400ULL,
0x00000089008d7306ULL, 0x000ee2000020d400ULL, 0x000100006e6e7824ULL, 0x002fe200078e00ffULL,
0x000000929100720bULL, 0x004fc80003f7d000ULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x0000009400987306ULL, 0x000e6e000020d400ULL, 0x0000000193933812ULL, 0x008fe200078efcffULL,
0x00000099009d7306ULL, 0x000ea2000020d400ULL, 0x000000018d8d6812ULL, 0x000fc400078efcffULL,
0x000000a4a300720bULL, 0x000fca0003f7d000ULL, 0x0000006e006c7306ULL, 0x000fe20000209400ULL,
0x0000000198982812ULL, 0x002fc800078efcffULL, 0x000000939898723eULL, 0x000fc600000010ffULL,
0x0000006e00897306ULL, 0x000e620000205400ULL, 0x000000019d9d4812ULL, 0x004fe400078efcffULL,
0x0000000123233812ULL, 0x000fca00078efcffULL, 0x0000006f00977306ULL, 0x000ff00000009400ULL,
0x0000006f009e7306ULL, 0x000ea20000005400ULL, 0x000000896c00720bULL, 0x002fe40003fdd000ULL,
0x0000006d866c723eULL, 0x000fc400000010ffULL, 0x0000008d906d723eULL, 0x000fc600000010ffULL,
0x0000007000a57306ULL, 0x000fe80000009400ULL, 0x0000006c2864723cULL, 0x000b680000041864ULL,
0x0000007000a67306ULL, 0x000e620000005400ULL, 0x0000009e9700720bULL, 0x004fc60003fbd000ULL,
0x0000006c0c44723cULL, 0x000b680000041844ULL, 0x0000009f00947306ULL, 0x000ff00000209400ULL,
0x0000009f00a17306ULL, 0x000ea20000205400ULL, 0x000000a6a500720bULL, 0x002fce0003f9d000ULL,
0x0000007000217306ULL, 0x0002f0000000d400ULL, 0x0000006f00787306ULL, 0x000ee2000000d400ULL,
0x0001000070707824ULL, 0x002fe200078e00ffULL, 0x000000a19400720bULL, 0x004fc80003f5d000ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000006e006f7306ULL, 0x000e62000020d400ULL,
0x0000000121214812ULL, 0x008fce00078efcffULL, 0x0000007100ab7306ULL, 0x000fe20000009400ULL,
0x0000000178785812ULL, 0x000fce00078efcffULL, 0x0000007100ae7306ULL, 0x000ea20000005400ULL,
0x000000016f6f6812ULL, 0x002fc800078efcffULL, 0x0000006f9c9c723eULL, 0x000fc600000010ffULL,
0x0000009f00a27306ULL, 0x000e70000020d400ULL, 0x000000a700997306ULL, 0x000fe20000209400ULL,
0x000000aeab00720bULL, 0x004fce0003fdd000ULL, 0x000000a700a87306ULL, 0x000ea20000205400ULL,
0x00000001a2a22812ULL, 0x002fce00078efcffULL, 0x000000ad00af7306ULL, 0x000ff00000209400ULL,
0x000000ad00b07306ULL, 0x000e620000205400ULL, 0x000000a89900720bULL, 0x004fe40003fbd000ULL,
0x000000789d99723eULL, 0x000fc400000010ffULL, 0x000000a2239d723eULL, 0x000fc600000010ffULL,
0x00000070006e7306ULL, 0x000fe40000209400ULL, 0x000000982860723cULL, 0x040b6c0000041860ULL,
0x00000070009f7306ULL, 0x000ea20000205400ULL, 0x000000b0af00720bULL, 0x002fe20003f5d000ULL,
0x0000009c285c723cULL, 0x000b6c000004185cULL, 0x0000007100187306ULL, 0x000e64000000d400ULL,
0x000000980c40723cULL, 0x040b6c0000041840ULL, 0x000000a700aa7306ULL, 0x000ee2000020d400ULL,
0x0000009f6e00720bULL, 0x004fe20003f9d000ULL, 0x0000009c0c3c723cULL, 0x000b6c000004183cULL,
0x000000ad00b17306ULL, 0x000ea2000020d400ULL, 0x0000000118186812ULL, 0x002fc400078efcffULL,
0x000000b6b500720bULL, 0x000fca0003fdd000ULL, 0x0000007000717306ULL, 0x000e62000020d400ULL,
0x00000001aaaa5812ULL, 0x008fe400078efcffULL, 0x000000aca900720bULL, 0x000fe40003fbd000ULL,
0x00000021aaaa723eULL, 0x000fc600000010ffULL, 0x0000007200b77306ULL, 0x000fe20000009400ULL,
0x00000001b1b12812ULL, 0x004fe400078efcffULL, 0x0000000112126812ULL, 0x000fe400078efcffULL,
0x00000018b1ab723eULL, 0x000fc600000010ffULL, 0x0000007200b87306ULL, 0x000ea20000005400ULL,
0x0000000171714812ULL, 0x002fe400078efcffULL, 0x000000011a1a5812ULL, 0x000fe200078efcffULL,
0x000000aa2858723cULL, 0x000b620000041858ULL, 0x000000bbba00720bULL, 0x000fc60003fbd000ULL,
0x000000b200a77306ULL, 0x000fe80000209400ULL, 0x000000aa0c38723cULL, 0x000b680000041838ULL,
0x000000b200b47306ULL, 0x000e620000205400ULL, 0x000000b8b700720bULL, 0x004fe40003f1d000ULL,
0x0000000111115812ULL, 0x000fca00078efcffULL, 0x000000b9007a7306ULL, 0x000ff00000209400ULL,
0x000000b9007b7306ULL, 0x000ea20000205400ULL, 0x000000b4a700720bULL, 0x002fce0003f5d000ULL,
0x0000007200107306ULL, 0x0002f0000000d400ULL, 0x0000007300bc7306ULL, 0x000fe20000009400ULL,
0x0001000072727824ULL, 0x002fe200078e00ffULL, 0x0000007b7a00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000007300bd7306ULL, 0x000e620000005400ULL,
0x0000000110100812ULL, 0x008fce00078efcffULL, 0x00000073000a7306ULL, 0x000eb0000000d400ULL,
0x0000007200707306ULL, 0x000fe20000209400ULL, 0x000000bdbc00720bULL, 0x002fce0003f7d000ULL,
0x0000007200737306ULL, 0x000fec0000205400ULL, 0x000000010a0a3812ULL, 0x004fe400078efcffULL,
0x00000072007c7306ULL, 0x000ff0000020d400ULL, 0x000000b200b37306ULL, 0x000e70000020d400ULL,
0x000000b9007d7306ULL, 0x000eb0000020d400ULL, 0x0000007f00817306ULL, 0x000fe20000209400ULL,
0x00000001b3b32812ULL, 0x002fc400078efcffULL, 0x000000742500720bULL, 0x000fe40003f5d000ULL,
0x000000b3126f723eULL, 0x000fc600000010ffULL, 0x0000007f00727306ULL, 0x000e620000205400ULL,
0x000000017d7d4812ULL, 0x004fe400078efcffULL, 0x000000737000720bULL, 0x000fe40003f9d000ULL,
0x000000107d70723eULL, 0x000fc600000010ffULL, 0x00000082006e7306ULL, 0x000fe20000209400ULL,
0x000000010b0b2812ULL, 0x000fce00078efcffULL, 0x0000008200797306ULL, 0x000ea20000205400ULL,
0x000000728100720bULL, 0x002fe40003fdd000ULL, 0x000000017c7c4812ULL, 0x000fca00078efcffULL,
0x0000007f007f7306ULL, 0x000e70000020d400ULL, 0x0000008200827306ULL, 0x000ee2000020d400ULL,
0x000000796e00720bULL, 0x004fe40003f1d000ULL, 0x000000711a6e723eULL, 0x000fc400000010ffULL,
0x000000017f7f6812ULL, 0x002fca00078efcffULL, 0x0000006e2854723cULL, 0x000b620000041854ULL,
0x0000000a7f71723eULL, 0x000fe400000010ffULL, 0x0000007c110a723eULL, 0x000fe400000010ffULL,
0x0000000182820812ULL, 0x008fc600078efcffULL, 0x0000006e0c34723cULL, 0x000b620000041834ULL,
0x000000820b0b723eULL, 0x000fce00000010ffULL, 0x000000702850723cULL, 0x040b700000041850ULL,
0x0000000a284c723cULL, 0x000b70000004184cULL, 0x000000700c30723cULL, 0x040b700000041830ULL,
0x0000000a0c2c723cULL, 0x000b62000004182cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x00000000190a7f8cULL, 0x0202a2000c80043fULL, 0x000000011b1b7810ULL, 0x000fc40007ffe0ffULL,
0x0001a6a0200c7811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000cff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff0e7224ULL, 0x004fe200078e000bULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff138000007947ULL, 0x000fea000383ffffULL,
0x000000ff0600720cULL, 0x000fda0003f05270ULL, 0x000005b000008947ULL, 0x000fea0003800000ULL,
0x0180000022007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x00010ab000067802ULL, 0x000fc40000000f00ULL,
0x0000dca000007944ULL, 0x01efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002200057308ULL, 0x000ee40000001000ULL, 0xbf80000005007423ULL, 0x008fc80000000022ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000005007223ULL, 0x000fc40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff057624ULL, 0x000fe400078e00ffULL,
0x00006e00ff047624ULL, 0x000fca00078e00ffULL, 0x0000000604057981ULL, 0x008ee8000c1e9900ULL,
0x00000000000a7919ULL, 0x002e680000000000ULL, 0x0000000000067919ULL, 0x000ea20000000000ULL,
0x000000180a077811ULL, 0x042fe400078ff0ffULL, 0x000000080a0d7811ULL, 0x004fc400078ff0ffULL,
0x00000002ff0b7819ULL, 0x000fe40000011606ULL, 0x000000100a0f7811ULL, 0x000fe200078ff0ffULL,
0x0000000005087220ULL, 0x008fca0000410000ULL, 0x00001f0b08007589ULL, 0x000e6800000e0000ULL,
0x00001f0708077589ULL, 0x000ea800000e0000ULL, 0x00001f0d08067589ULL, 0x000ee800000e0000ULL,
0x00001f0f08047589ULL, 0x000ea200000e0000ULL, 0x0000006800687220ULL, 0x002fc40000410000ULL,
0x0000006900697220ULL, 0x040fe40000410000ULL, 0x0000006400647220ULL, 0x040fe40000410000ULL,
0x0000006500657220ULL, 0x040fe40000410000ULL, 0x0000006000607220ULL, 0x040fe40000410000ULL,
0x0000006100617220ULL, 0x040fe40000410000ULL, 0x0000005c005c7220ULL, 0x000fc40000410000ULL,
0x0000005d005d7220ULL, 0x040fe40000410000ULL, 0x0000005800587220ULL, 0x040fe40000410000ULL,
0x0000005900597220ULL, 0x040fe40000410000ULL, 0x0000005400547220ULL, 0x040fe40000410000ULL,
0x0000005500557220ULL, 0x040fe40000410000ULL, 0x0000005000507220ULL, 0x000fc40000410000ULL,
0x0000005100517220ULL, 0x040fe40000410000ULL, 0x0000004c004c7220ULL, 0x040fe40000410000ULL,
0x0000004d004d7220ULL, 0x000fe40000410000ULL, 0x0000004a074a7220ULL, 0x044fe40000410000ULL,
0x0000004b074b7220ULL, 0x040fe40000410000ULL, 0x0000004607467220ULL, 0x000fc40000410000ULL,
0x0000004707477220ULL, 0x040fe40000410000ULL, 0x0000004207427220ULL, 0x040fe40000410000ULL,
0x0000004307437220ULL, 0x040fe40000410000ULL, 0x0000003e073e7220ULL, 0x040fe40000410000ULL,
0x0000003f073f7220ULL, 0x040fe40000410000ULL, 0x0000003a073a7220ULL, 0x000fc40000410000ULL,
0x0000003b073b7220ULL, 0x040fe40000410000ULL, 0x0000003607367220ULL, 0x040fe40000410000ULL,
0x0000003707377220ULL, 0x040fe40000410000ULL, 0x0000003207327220ULL, 0x040fe40000410000ULL,
0x0000003307337220ULL, 0x040fe40000410000ULL, 0x0000002e072e7220ULL, 0x000fc40000410000ULL,
0x0000002f072f7220ULL, 0x000fe40000410000ULL, 0x000000066a6a7220ULL, 0x088fe40000410000ULL,
0x000000066b6b7220ULL, 0x080fe40000410000ULL, 0x0000000666667220ULL, 0x080fe40000410000ULL,
0x0000000667677220ULL, 0x080fe40000410000ULL, 0x0000000662627220ULL, 0x000fc40000410000ULL,
0x0000000663637220ULL, 0x080fe40000410000ULL, 0x000000065e5e7220ULL, 0x080fe40000410000ULL,
0x000000065f5f7220ULL, 0x080fe40000410000ULL, 0x000000065a5a7220ULL, 0x080fe40000410000ULL,
0x000000065b5b7220ULL, 0x080fe40000410000ULL, 0x0000000656567220ULL, 0x000fc40000410000ULL,
0x0000000657577220ULL, 0x080fe40000410000ULL, 0x0000000652527220ULL, 0x080fe40000410000ULL,
0x0000000653537220ULL, 0x080fe40000410000ULL, 0x000000064e4e7220ULL, 0x080fe40000410000ULL,
0x000000064f4f7220ULL, 0x000fe40000410000ULL, 0x0000000448487220ULL, 0x000fc40000410000ULL,
0x0000000449497220ULL, 0x080fe40000410000ULL, 0x0000000444447220ULL, 0x080fe40000410000ULL,
0x0000000445457220ULL, 0x080fe40000410000ULL, 0x0000000440407220ULL, 0x080fe40000410000ULL,
0x0000000441417220ULL, 0x080fe40000410000ULL, 0x000000043c3c7220ULL, 0x000fc40000410000ULL,
0x000000043d3d7220ULL, 0x080fe40000410000ULL, 0x0000000438387220ULL, 0x080fe40000410000ULL,
0x0000000439397220ULL, 0x080fe40000410000ULL, 0x0000000434347220ULL, 0x080fe40000410000ULL,
0x0000000435357220ULL, 0x080fe40000410000ULL, 0x0000000430307220ULL, 0x000fc40000410000ULL,
0x0000000431317220ULL, 0x080fe40000410000ULL, 0x000000042c2c7220ULL, 0x080fe40000410000ULL,
0x000000042d2d7220ULL, 0x000fc40000410000ULL, 0x0000000000057919ULL, 0x000ee20000000000ULL,
0x0000006a6b6a723eULL, 0x000fe400000010ffULL, 0x000000666766723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000626362723eULL, 0x000fc400000010ffULL,
0x0000005e5f5e723eULL, 0x000fe400000010ffULL, 0x0000005a5b5a723eULL, 0x000fe400000010ffULL,
0x000000565756723eULL, 0x000fe400000010ffULL, 0x000000525352723eULL, 0x000fe400000010ffULL,
0x0000004e4f29723eULL, 0x000fe400000010ffULL, 0x000000484948723eULL, 0x000fc400000010ffULL,
0x0000000805077811ULL, 0x048fe400078ff0ffULL, 0x0000000205007812ULL, 0x040fe400078ec0ffULL,
0x00000018050d7811ULL, 0x004fe200078ff0ffULL, 0x00000008070b7824ULL, 0x002fe200078e00ffULL,
0x0000000700047211ULL, 0x000fe400078ff8ffULL, 0x0000001005077811ULL, 0x000fe200078ff0ffULL,
0x000000080d167824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0c7812ULL, 0x000fc400078ee204ULL,
0x00000002ff0b7819ULL, 0x000fe20000011605ULL, 0x00000008070f7824ULL, 0x000fe200078e00ffULL,
0x0000000700067211ULL, 0x040fe400078ff8ffULL, 0x0000000b00047211ULL, 0x040fe200078ff8ffULL,
0x000000080b107824ULL, 0x040fe200078e00ffULL, 0x0000000d00077211ULL, 0x000fe200078ff8ffULL,
0x000000080b0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f147812ULL, 0x000fe200078ee206ULL,
0x0000200002067824ULL, 0x000fe200078e00ffULL, 0x0000000204007810ULL, 0x000fc40007ffe0ffULL,
0xfffffff816167812ULL, 0x000fe200078ee207ULL, 0x000000080b077824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0a7812ULL, 0x000fe400078ee200ULL, 0x0000200006007812ULL, 0x000fe400078ee2ffULL,
0xfffffff807067812ULL, 0x000fe400078ee204ULL, 0x0000000404087810ULL, 0x040fe20007ffe0ffULL,
0x000010001f077824ULL, 0x000fe200078e0200ULL, 0x00000006040b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000805047824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0e7812ULL, 0x000fe200078ee208ULL,
0x0000001006087824ULL, 0x000fe200078e0207ULL, 0xfffffff810107812ULL, 0x000fe200078ee20bULL,
0x000000100c127824ULL, 0x100fe200078e0207ULL, 0x00000008040b7812ULL, 0x000fe200078ec0ffULL,
0x000000100a0c7824ULL, 0x100fe200078e0207ULL, 0x000000686904723eULL, 0x000fe200000010ffULL,
0x0000001014147824ULL, 0x000fe200078e0207ULL, 0x000000646506723eULL, 0x000fe200000010ffULL,
0x00000001080a7824ULL, 0x000fe200078e020bULL, 0x000000545508723eULL, 0x000fe200000010ffULL,
0x0000001016167824ULL, 0x100fe200078e0207ULL, 0x00005410041a7816ULL, 0x100fe20000000006ULL,
0x000000100e0e7824ULL, 0x100fe200078e0207ULL, 0x00007632041b7816ULL, 0x000fe20000000006ULL,
0x0000001010107824ULL, 0x000fe200078e0207ULL, 0x000000606104723eULL, 0x000fe200000010ffULL,
0x000000010b0c7824ULL, 0x000fe200078e020cULL, 0x0000005c5d06723eULL, 0x000fe200000010ffULL,
0x0000001a0a007388ULL, 0x0003e20000000a00ULL, 0x000000585907723eULL, 0x000fe200000010ffULL,
0x000000010b0e7824ULL, 0x000fe200078e020eULL, 0x000000444524723eULL, 0x010fe200000010ffULL,
0x000000010b127824ULL, 0x040fe200078e0212ULL, 0x0000541052287816ULL, 0x140fe20000000029ULL,
0x000000010b147824ULL, 0x040fe200078e0214ULL, 0x0000763252297816ULL, 0x000fe20000000029ULL,
0x000000010b167824ULL, 0x000fe200078e0216ULL, 0x000000404140723eULL, 0x000fe200000010ffULL,
0x000000010b107824ULL, 0x000fe200078e0210ULL, 0x0000004c4d0b723eULL, 0x000fc400000010ffULL,
0x00005410041a7816ULL, 0x142fe40000000006ULL, 0x00007632041b7816ULL, 0x000fe40000000006ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x0000001a0c007388ULL, 0x000fe20000000a00ULL, 0x00000050510a723eULL, 0x000fe400000010ffULL,
0x0000003c3d20723eULL, 0x000fe200000010ffULL, 0x000000060e007388ULL, 0x0003e20000000a00ULL,
0x000000383938723eULL, 0x000fc400000010ffULL, 0x00000034351c723eULL, 0x000fe400000010ffULL,
0x000000303130723eULL, 0x000fe400000010ffULL, 0x0000002c2d18723eULL, 0x000fe400000010ffULL,
0x0000004a4b04723eULL, 0x000fe400000010ffULL, 0x0000003e3f08723eULL, 0x000fe400000010ffULL,
0x000054100a067816ULL, 0x002fc4000000000bULL, 0x000076320a077816ULL, 0x000fe4000000000bULL,
0x00005410480a7816ULL, 0x140fe40000000024ULL, 0x00007632480b7816ULL, 0x000fe20000000024ULL,
0x0000000610007388ULL, 0x0003e40000000a00ULL, 0x000054106a067816ULL, 0x142fe40000000066ULL,
0x000076326a077816ULL, 0x000fca0000000066ULL, 0x0000000612007388ULL, 0x0003e40000000a00ULL,
0x0000541062067816ULL, 0x142fe4000000005eULL, 0x0000763262077816ULL, 0x000fca000000005eULL,
0x000400060c007388ULL, 0x0003e40000000a00ULL, 0x000054105a067816ULL, 0x142fe40000000056ULL,
0x000076325a077816ULL, 0x000fca0000000056ULL, 0x000400060e007388ULL, 0x0003e80000000a00ULL,
0x0004002810007388ULL, 0x000fe80000000a00ULL, 0x0000000a14007388ULL, 0x0005e20000000a00ULL,
0x000000464706723eULL, 0x002fe400000010ffULL, 0x000000424307723eULL, 0x000fc800000010ffULL,
0x0000541007127816ULL, 0x040fe40000000008ULL, 0x00005410400a7816ULL, 0x144fe40000000020ULL,
0x00007632400b7816ULL, 0x000fe40000000020ULL, 0x0000763207137816ULL, 0x000fe40000000008ULL,
0x000000323307723eULL, 0x000fe200000010ffULL, 0x0008000a0c007388ULL, 0x0003e20000000a00ULL,
0x0000002e2f08723eULL, 0x000fc400000010ffULL, 0x00005410380a7816ULL, 0x142fe4000000001cULL,
0x00007632380b7816ULL, 0x000fca000000001cULL, 0x0008000a0e007388ULL, 0x0003e40000000a00ULL,
0x00005410300a7816ULL, 0x142fe40000000018ULL, 0x00007632300b7816ULL, 0x000fca0000000018ULL,
0x0008000a10007388ULL, 0x0003e40000000a00ULL, 0x00005410040a7816ULL, 0x142fe40000000006ULL,
0x00007632040b7816ULL, 0x000fe40000000006ULL, 0x0000003a3b04723eULL, 0x000fe400000010ffULL,
0x000000363706723eULL, 0x000fe200000010ffULL, 0x0000000a16007388ULL, 0x0003e60000000a00ULL,
0x00007632040d7816ULL, 0x100fe20000000006ULL, 0x000c00120c007388ULL, 0x0005e20000000a00ULL,
0x00000001800b7824ULL, 0x002fe200078e0205ULL, 0x00005410040c7816ULL, 0x004fc60000000006ULL,
0x000000100b0b7824ULL, 0x000fe200078e0200ULL, 0x0000541007127816ULL, 0x140fe20000000008ULL,
0x000000ff00047306ULL, 0x000fe20000205400ULL, 0x0000763207137816ULL, 0x000fe20000000008ULL,
0x000c000c0e007388ULL, 0x000fe80000000a00ULL, 0x000c001210007388ULL, 0x000fe40000000a00ULL,
0x000000ff00077306ULL, 0x000e640000209400ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000b147984ULL, 0x000ea20000000c00ULL, 0x000000ff00067306ULL, 0x000ee6000020d400ULL,
0x000400000b0c7984ULL, 0x000ea80000000c00ULL, 0x000800000b247984ULL, 0x000ea20000000c00ULL,
0x000000040700720bULL, 0x002fc60003f1d000ULL, 0x000c00000b107984ULL, 0x000e680000000c00ULL,
0x001000000b187984ULL, 0x000e680000000c00ULL, 0x001400000b207984ULL, 0x000e640000000c00ULL,
0x0000000106060812ULL, 0x008fc400078efcffULL, 0x001800000b287984ULL, 0x000ee20000000c00ULL,
0x000000ff1f00720cULL, 0x000fe40003f05270ULL, 0x000000060606723eULL, 0x000fe200000010ffULL,
0x001c00000b2c7984ULL, 0x000ee80000000c00ULL, 0x3f803f8006177831ULL, 0x044fe40000200017ULL,
0x3f803f8006167831ULL, 0x000fc40000200016ULL, 0x3f803f8006157831ULL, 0x040fe40000200015ULL,
0x3f803f8006147831ULL, 0x040fe40000200014ULL, 0x3f803f80060f7831ULL, 0x040fe4000020000fULL,
0x3f803f80060e7831ULL, 0x040fe4000020000eULL, 0x3f803f80060d7831ULL, 0x040fe4000020000dULL,
0x3f803f80060c7831ULL, 0x000fc4000020000cULL, 0x3f803f8006277831ULL, 0x040fe40000200027ULL,
0x3f803f8006267831ULL, 0x040fe40000200026ULL, 0x3f803f8006257831ULL, 0x040fe40000200025ULL,
0x3f803f8006247831ULL, 0x040fe40000200024ULL, 0x3f803f8006137831ULL, 0x042fe40000200013ULL,
0x3f803f8006127831ULL, 0x000fc40000200012ULL, 0x3f803f8006117831ULL, 0x040fe40000200011ULL,
0x3f803f8006107831ULL, 0x000fe40000200010ULL, 0x3f803f8017177831ULL, 0x000fe4000020001bULL,
0x3f803f8016167831ULL, 0x000fe4000020001aULL, 0x3f803f8015157831ULL, 0x000fe40000200019ULL,
0x3f803f8014147831ULL, 0x000fc40000200018ULL, 0x3f803f800f0f7831ULL, 0x000fe40000200023ULL,
0x3f803f800e0e7831ULL, 0x000fe20000200022ULL, 0x000000140b007388ULL, 0x000fe20000000c00ULL,
0x3f803f800d0d7831ULL, 0x000fe40000200021ULL, 0x3f803f800c0c7831ULL, 0x000fe40000200020ULL,
0x3f803f8027277831ULL, 0x008fe4000020002bULL, 0x3f803f8026267831ULL, 0x000fe2000020002aULL,
0x0004000c0b007388ULL, 0x000fe20000000c00ULL, 0x3f803f8025257831ULL, 0x000fc40000200029ULL,
0x3f803f8024247831ULL, 0x000fe40000200028ULL, 0x3f803f8013137831ULL, 0x000fe4000020002fULL,
0x3f803f8012127831ULL, 0x000fe2000020002eULL, 0x000800240b007388ULL, 0x000fe20000000c00ULL,
0x3f803f8011117831ULL, 0x000fe4000020002dULL, 0x3f803f8010107831ULL, 0x000fca000020002cULL,
0x000c00100b007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff087819ULL, 0x000fc80000011605ULL,
0x000000760800720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a00000b7b06ULL, 0x000e620000209000ULL, 0x0000000103047824ULL, 0x000fe200078e0208ULL,
0x00005a00ff197a12ULL, 0x000fe400078e33ffULL, 0x0000000102157812ULL, 0x000fe400078ec0ffULL,
0x0000002005027810ULL, 0x000fc80007ffe0ffULL, 0x00000003ff117819ULL, 0x000fe20000011602ULL,
0x0000000b000b7308ULL, 0x002e640000001000ULL, 0x0ffffffe0b067810ULL, 0x002fcc0007ffe0ffULL,
0x0000000600077305ULL, 0x0002a4000021f000ULL, 0x000000ffff067224ULL, 0x002fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x004fc800078e0a07ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d07177227ULL, 0x000fc800078e0006ULL, 0x0000000108067824ULL, 0x000fe400078e0205ULL,
0x00000004170a7227ULL, 0x000fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a0aULL, 0x00005a0007077a24ULL, 0x000fca00078e0204ULL,
0x00005a0007007a0cULL, 0x000fda0003f06070ULL, 0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL,
0x000000010a0a0810ULL, 0x000fe40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fe40003f26070ULL,
0x0ffffff806077812ULL, 0x000fe400078ef805ULL, 0x00005a00ff007a0cULL, 0x000fc60003f05070ULL,
0x0000001007087824ULL, 0x000fca00078e0200ULL, 0x00000000080c7984ULL, 0x0002a20000000c00ULL,
0x000000010a0a1810ULL, 0x000fc80007ffe0ffULL, 0x0000000a190a7207ULL, 0x000fe40004000000ULL,
0x0000000705087812ULL, 0x002fc600078ec0ffULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a0aULL,
0x000059000a077a24ULL, 0x000fe400078e0209ULL, 0x00005a000b047a24ULL, 0x000fe400078e0204ULL,
0x00000008150b7824ULL, 0x000fe400078e0208ULL, 0x00005a0007047a24ULL, 0x000fca00078e0204ULL,
0x0000000477047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0004067a11ULL, 0x000fc800078240ffULL, 0x00005f0004077a11ULL, 0x000fe400008f4407ULL,
0x000000761100720cULL, 0x000fc60003f26070ULL, 0x000000100b067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000103047824ULL, 0x100fe400078e0211ULL, 0x0000000102117824ULL, 0x000fe400078e0211ULL,
0x0000000417067227ULL, 0x002fc600078e00ffULL, 0x0000000711117812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a06ULL, 0x0ffffff811117812ULL, 0x000fe200078ef802ULL,
0x00005a0007077a24ULL, 0x000fe200078e0204ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001011117824ULL, 0x000fe200078e0200ULL, 0x00005a0007007a0cULL, 0x000fca0003f26070ULL,
0x0000000011107984ULL, 0x000e700000000c00ULL, 0x80005a0007071a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fc40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fda0003f46070ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000619067207ULL, 0x000fca0004000000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a06ULL, 0x0000590006077a24ULL, 0x000fe400078e0209ULL,
0x00005a000b047a24ULL, 0x000fe400078e0204ULL, 0x00000008150b7824ULL, 0x000fe400078e0202ULL,
0x00005a0007047a24ULL, 0x000fca00078e0204ULL, 0x0000000477077210ULL, 0x000fe40007f3e0ffULL,
0x0000004005047810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0d7819ULL, 0x000fe40000011604ULL,
0x00005f0007077a11ULL, 0x000fe400008f4408ULL, 0x000000760d00720cULL, 0x000fc60003f26070ULL,
0x000000100b067825ULL, 0x000fca00078e0006ULL, 0x0000001006007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000103027824ULL, 0x100fe400078e020dULL,
0x00000001040d7824ULL, 0x000fe400078e020dULL, 0x0000000217067227ULL, 0x002fc600078e00ffULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc600078e0a06ULL,
0x0ffffff80d0d7812ULL, 0x000fe200078ef804ULL, 0x00005a0007077a24ULL, 0x000fe200078e0202ULL,
0x0000000704047812ULL, 0x000fc600078ec0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0200ULL,
0x00005a0007007a0cULL, 0x000fca0003f26070ULL, 0x000000000d0c7984ULL, 0x000e700000000c00ULL,
0x80005a0007071a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fc40007ffe0ffULL,
0x00005a0007007a0cULL, 0x000fda0003f46070ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000619067207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a06ULL,
0x0000590006077a24ULL, 0x000fe400078e0209ULL, 0x00005a000b027a24ULL, 0x000fe400078e0202ULL,
0x00000008150b7824ULL, 0x000fe400078e0204ULL, 0x00005a0007027a24ULL, 0x000fca00078e0202ULL,
0x0000000277077210ULL, 0x000fe40007f3e0ffULL, 0x0000006005027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff117819ULL, 0x000fe40000011602ULL, 0x00005f0007077a11ULL, 0x000fe400008f4408ULL,
0x000000761100720cULL, 0x000fc60003f26070ULL, 0x000000100b067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000103047824ULL, 0x100fe400078e0211ULL, 0x0000000102117824ULL, 0x000fe400078e0211ULL,
0x0000000417067227ULL, 0x002fc600078e00ffULL, 0x0000000711117812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a06ULL, 0x0ffffff811117812ULL, 0x000fe200078ef802ULL,
0x00005a0007077a24ULL, 0x000fe200078e0204ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001011117824ULL, 0x000fe200078e0200ULL, 0x00005a0007007a0cULL, 0x000fca0003f26070ULL,
0x0000000011107984ULL, 0x000e700000000c00ULL, 0x80005a0007071a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fc40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fda0003f46070ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000619067207ULL, 0x000fca0004000000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a06ULL, 0x0000590006077a24ULL, 0x000fe400078e0209ULL,
0x00005a000b047a24ULL, 0x000fe400078e0204ULL, 0x00000008150b7824ULL, 0x000fe400078e0202ULL,
0x00005a0007047a24ULL, 0x000fca00078e0204ULL, 0x0000000477077210ULL, 0x000fe40007f3e0ffULL,
0x0000008005047810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0d7819ULL, 0x000fe40000011604ULL,
0x00005f0007077a11ULL, 0x000fe400008f4408ULL, 0x000000760d00720cULL, 0x000fc60003f26070ULL,
0x000000100b067825ULL, 0x000fca00078e0006ULL, 0x0000001006007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000103027824ULL, 0x100fe400078e020dULL,
0x00000001040d7824ULL, 0x000fe400078e020dULL, 0x0000000217067227ULL, 0x002fc600078e00ffULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc600078e0a06ULL,
0x0ffffff80d0d7812ULL, 0x000fe200078ef804ULL, 0x00005a0007077a24ULL, 0x000fe200078e0202ULL,
0x0000000704047812ULL, 0x000fc600078ec0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0200ULL,
0x00005a0007007a0cULL, 0x000fca0003f26070ULL, 0x000000000d0c7984ULL, 0x000e700000000c00ULL,
0x80005a0007071a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fc40007ffe0ffULL,
0x00005a0007007a0cULL, 0x000fda0003f46070ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000619067207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a06ULL,
0x0000590006077a24ULL, 0x000fe400078e0209ULL, 0x00005a000b027a24ULL, 0x000fe400078e0202ULL,
0x00000008150b7824ULL, 0x000fe400078e0204ULL, 0x00005a0007027a24ULL, 0x000fca00078e0202ULL,
0x0000000277077210ULL, 0x000fe40007f3e0ffULL, 0x000000a005027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff117819ULL, 0x000fe40000011602ULL, 0x00005f0007077a11ULL, 0x000fe400008f4408ULL,
0x000000761100720cULL, 0x000fc60003f26070ULL, 0x000000100b067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000103047824ULL, 0x100fe200078e0211ULL, 0x000000c005087810ULL, 0x000fe20007ffe0ffULL,
0x0000000102117824ULL, 0x000fe400078e0211ULL, 0x0000000417067227ULL, 0x002fe200078e00ffULL,
0x00000003ff0d7819ULL, 0x000fc40000011608ULL, 0x0000000711117812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a06ULL, 0x0ffffff811117812ULL, 0x000fe200078ef802ULL,
0x00005a0007077a24ULL, 0x000fe200078e0204ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001011117824ULL, 0x000fe200078e0200ULL, 0x00005a0007007a0cULL, 0x000fca0003f26070ULL,
0x0000000011107984ULL, 0x000e700000000c00ULL, 0x80005a0007071a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fc40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fda0003f46070ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000619067207ULL, 0x000fca0004000000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a06ULL, 0x0000590006077a24ULL, 0x000fe400078e0209ULL,
0x00005a000b047a24ULL, 0x000fe400078e0204ULL, 0x00000008150b7824ULL, 0x000fe400078e0202ULL,
0x00005a0007047a24ULL, 0x000fca00078e0204ULL, 0x0000000477047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0004067a11ULL, 0x000fc800078240ffULL,
0x00005f0004077a11ULL, 0x000fe400008f4407ULL, 0x000000760d00720cULL, 0x000fc60003f26070ULL,
0x000000100b067825ULL, 0x000fca00078e0006ULL, 0x0000001006007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000103027824ULL, 0x100fe400078e020dULL,
0x00000001080d7824ULL, 0x000fe400078e020dULL, 0x0000000217047227ULL, 0x000fc600078e00ffULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x002fc600078e0a04ULL,
0x0ffffff80d0d7812ULL, 0x000fe200078ef808ULL, 0x00005a0007067a24ULL, 0x000fe200078e0202ULL,
0x0000000708087812ULL, 0x000fc600078ec0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0200ULL,
0x00005a0006007a0cULL, 0x000fca0003f26070ULL, 0x000000000d0c7984ULL, 0x000e700000000c00ULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fc40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f46070ULL, 0x000000e005067810ULL, 0x000fd60007ffe0ffULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x0000000419047207ULL, 0x000fca0004000000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a04ULL, 0x0000590004077a24ULL, 0x000fe400078e0209ULL,
0x00005a000b027a24ULL, 0x000fe200078e0202ULL, 0x00000003ff0b7819ULL, 0x000fc60000011606ULL,
0x00005a0007027a24ULL, 0x000fe400078e0202ULL, 0x0000000103037824ULL, 0x000fc600078e020bULL,
0x0000000277027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0002047a11ULL, 0x000fc800078240ffULL, 0x00005f0002057a11ULL, 0x000fe200008f4407ULL,
0x0000000815077824ULL, 0x000fe200078e0208ULL, 0x000000760b00720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000317027227ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x002fe400078e0a02ULL, 0x00000001060b7824ULL, 0x000fe400078e020bULL,
0x00005a0004047a24ULL, 0x000fc600078e0203ULL, 0x000000070b0b7812ULL, 0x000fe400078ec0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f26070ULL, 0xfffffff80b0b7812ULL, 0x000fe400078ef806ULL,
0x0000000706067812ULL, 0x000fc600078ec0ffULL, 0x000000100b0b7824ULL, 0x000fe400078e0200ULL,
0x0000000815057824ULL, 0x000fc600078e0206ULL, 0x000000000b0c7984ULL, 0x000e620000000c00ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000102021810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fda0003f46070ULL, 0x0000000102022810ULL, 0x000fc80007ffe0ffULL,
0x0000000219027207ULL, 0x000fca0004000000ULL, 0x000000ffff047224ULL, 0x000fe400078e0a02ULL,
0x0000590002007a24ULL, 0x000fe400078e0209ULL, 0x00005a0004037a24ULL, 0x000fc800078e0203ULL,
0x00005a0000007a24ULL, 0x000fca00078e0203ULL, 0x0000000077007210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005e0000027a11ULL, 0x000fc800078040ffULL,
0x00005f0000037a11ULL, 0x000fca00000f4403ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000c02007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000050200720cULL, 0x000fe20003f06070ULL, 0xffffffffff137424ULL, 0x000fd800078e00ffULL,
0x00000002c20d8824ULL, 0x000fc800078e00ffULL, 0x00006a000d108a24ULL, 0x000fc800078e0202ULL,
0x0000660010108625ULL, 0x000fe200078e0083ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006e00ff0e7624ULL, 0x000fe200078e00ffULL, 0x0000000610138981ULL, 0x000ea2000c1e1900ULL,
0x00006f00ff0f7624ULL, 0x000fc600078e00ffULL, 0x01a60000ff0c7f8cULL, 0x000e68000c80043fULL,
0x000000060e0e7981ULL, 0x000722000c1e9900ULL, 0x000001ff0700780cULL, 0x000fe20003f04070ULL,
0x0000004017c07824ULL, 0x000fe400078e00ffULL, 0x0000004002bc7824ULL, 0x000fe400078e00ffULL,
0x0000004009077824ULL, 0x000fc400078e00ffULL, 0x00000013c0287224ULL, 0x004fcc00078e02ffULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x000000bc040f7217ULL, 0x00afe40007800000ULL,
0x00000003ff2c7819ULL, 0x000fe40000011608ULL, 0x0000640028317a11ULL, 0x000fe200078438ffULL,
0x000000010f0f7824ULL, 0x000fe200078e0abcULL, 0x000000042c117810ULL, 0x040fe20007ffe0ffULL,
0x0000004009097824ULL, 0x000fe200078e022cULL, 0x000000082c127810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1100720cULL, 0x0c0fe20003f86070ULL, 0x0000000111107824ULL, 0x140fe200078e0208ULL,
0x0000650028337a11ULL, 0x000fe200010f3cffULL, 0x0000000811277824ULL, 0x000fe200078e00ffULL,
0x0000000f1200720cULL, 0x040fe20003f06070ULL, 0x0000000112117824ULL, 0x040fe200078e0208ULL,
0x0000001809187810ULL, 0x000fe20007ffe0ffULL, 0x0000000812147824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fc400078ee210ULL, 0x0000000409127810ULL, 0x040fe20007ffe0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0xfffffff814297812ULL, 0x000fe400078ee211ULL,
0x0000000c2c147810ULL, 0x000fe20007ffe0ffULL, 0x0000008009107825ULL, 0x040fe200078e00ffULL,
0x0000007018187812ULL, 0x100fe400078ef80bULL, 0x0000000f1400720cULL, 0x040fe20003f26070ULL,
0x0000000114157824ULL, 0x000fe200078e0208ULL, 0x00000070101a7812ULL, 0x000fe200078ef80bULL,
0x0000000814167824ULL, 0x000fe200078e00ffULL, 0x0000000809147810ULL, 0x000fe20007ffe0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000001a311a7210ULL, 0x000fc40007f5e0ffULL,
0xfffffff8162b7812ULL, 0x000fe200078ee215ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000c09107810ULL, 0x000fe40007ffe0ffULL, 0x00000070121c7812ULL, 0x000fe200078ef80bULL,
0x00000001111b7824ULL, 0x000fe200010e0633ULL, 0x0000007014147812ULL, 0x000fe200078ef80bULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000311c1c7210ULL, 0x080fe40007f7e0ffULL,
0x0000003114147210ULL, 0x000fc40007f5e0ffULL, 0x00000070101e7812ULL, 0x000fe200078ef80bULL,
0x00000001131d7824ULL, 0x100fe200018e0633ULL, 0x0000001009127810ULL, 0x000fe20007ffe0ffULL,
0x0000000115157824ULL, 0x100fe200010e0633ULL, 0x000000311e1e7210ULL, 0x080fe40007f5e0ffULL,
0x0000001409167810ULL, 0x040fe20007ffe0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000001c09107810ULL, 0x000fe40007ffe0ffULL, 0x000000142c227810ULL, 0x000fe20007ffe0ffULL,
0x00000001111f7824ULL, 0x000fe200010e0633ULL, 0x0000007012207812ULL, 0x000fe200078ef80bULL,
0x000000012c117824ULL, 0x000fe200078e0208ULL, 0x0000003118187210ULL, 0x080fe20007fde0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000003120207210ULL, 0x000fc40007f7e0ffULL,
0x0000000711257812ULL, 0x000fe200078ec0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000007016167812ULL, 0x100fe400078ef80bULL, 0x000000102c127810ULL, 0x000fe20007ffe0ffULL,
0x00000008222f7824ULL, 0x000fe200078e00ffULL, 0x0000007010237812ULL, 0x000fe200078ef80bULL,
0x0000000122107824ULL, 0x000fe200078e0208ULL, 0x0000003116167210ULL, 0x000fe20007fbe0ffULL,
0x0000000113217824ULL, 0x100fe200018e0633ULL, 0x0000000f2200720cULL, 0x000fe20003f66070ULL,
0x0000000119197824ULL, 0x100fe200030e0633ULL, 0x0000003123227210ULL, 0x000fe20007fde0ffULL,
0x0000000117177824ULL, 0x100fe200028e0633ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee210ULL,
0x0000000112137824ULL, 0x000fe200078e0208ULL, 0x0000002009107810ULL, 0x000fe20007ffe0ffULL,
0x0000000111237824ULL, 0x000fe200030e0633ULL, 0x0000000f2c00720cULL, 0x000fc40003fa6070ULL,
0x0000200002247811ULL, 0x000fe200078e70ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0ffffff825257812ULL, 0x000fe400078ef808ULL, 0x000000182c267810ULL, 0x000fe20007ffe0ffULL,
0x0000001027277824ULL, 0x100fe200078e0224ULL, 0x0000000f1200720cULL, 0x0c0fe20003f46070ULL,
0x0000000812127824ULL, 0x000fe200078e00ffULL, 0x00000070102a7812ULL, 0x000fe200078ef80bULL,
0x0000001025257824ULL, 0x000fe200078e0224ULL, 0x0000001c2c287810ULL, 0x000fe20007ffe0ffULL,
0x0000000126107824ULL, 0x000fe200078e0208ULL, 0xfffffff8122d7812ULL, 0x000fe200078ee213ULL,
0x0000000826357824ULL, 0x040fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a257faeULL, 0x0003e2000e901c46ULL, 0x0000002409127810ULL, 0x000fe20007ffe0ffULL,
0x0000001029297824ULL, 0x100fe200078e0224ULL, 0x0000000f2600720cULL, 0x080fe20003fa6070ULL,
0x000000001c277faeULL, 0x0005e2000e101c46ULL, 0x000000102b2b7824ULL, 0x100fe200078e0224ULL,
0x0000000f2800720cULL, 0x000fe20003f86070ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000014297faeULL, 0x0007e6000c101c46ULL, 0x000000102d2d7824ULL, 0x000fe200078e0224ULL,
0x000000312a1a7210ULL, 0x002fe20007fde0ffULL, 0x000000001e2b7faeULL, 0x0003e2000c901c46ULL,
0x0000007012127812ULL, 0x000fe200078ef80bULL, 0x0000000128257824ULL, 0x040fe200078e0208ULL,
0xfffffff8351d7812ULL, 0x004fe200078ee210ULL, 0x00000001111b7824ULL, 0x000fe200030e0633ULL,
0x0000002809107810ULL, 0x000fe20007ffe0ffULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x000000202c1c7810ULL, 0x040fe20007ffe0ffULL, 0x000000102f2f7824ULL, 0x000fe200078e0224ULL,
0x000000242c277810ULL, 0x000fe20007ffe0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000f1c00720cULL, 0x000fe20003f06070ULL, 0x00000000202d7faeULL, 0x0005e2000d101c46ULL,
0x0000003112127210ULL, 0x000fe20007fde0ffULL, 0x000000011c267824ULL, 0x140fe200078e0208ULL,
0x0000000f2700720cULL, 0x040fe20003f26070ULL, 0x000000081c357824ULL, 0x000fe200078e00ffULL,
0x00000070101c7812ULL, 0x000fe200078ef80bULL, 0x0000000127107824ULL, 0x040fe200078e0208ULL,
0xfffffff828257812ULL, 0x000fe200078ee225ULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0xfffffff8351f7812ULL, 0x002fe200078ee226ULL, 0x0000000113137824ULL, 0x100fe200030e0633ULL,
0x000000311c147210ULL, 0x008fe20007fde0ffULL, 0x00000000162f7faeULL, 0x0003e2000d901c46ULL,
0xfffffff827277812ULL, 0x000fe200078ee210ULL, 0x000000101d1d7824ULL, 0x100fe200078e0224ULL,
0x0000002c09107810ULL, 0x000fe20007ffe0ffULL, 0x0000000111157824ULL, 0x000fe200030e0633ULL,
0x000000302c207810ULL, 0x004fe20007ffe0ffULL, 0x0000001025257824ULL, 0x000fe200078e0224ULL,
0x00000000181d7faeULL, 0x0005e2000e901c46ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000002c2c1e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000022257faeULL, 0x0007e2000e101c46ULL,
0x000000101f1f7824ULL, 0x100fe200078e0224ULL, 0x0000007010167812ULL, 0x002fe200078ef80bULL,
0x0000001027277824ULL, 0x000fe200078e0224ULL, 0x0000003009107810ULL, 0x000fe40007ffe0ffULL,
0x0000003116167210ULL, 0x000fe20007fde0ffULL, 0x000000001a1f7faeULL, 0x0003e2000c101c46ULL,
0x000000282c1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000011e197824ULL, 0x004fe200078e0208ULL,
0x000000342c217810ULL, 0x000fe20007ffe0ffULL, 0x0000000111177824ULL, 0x000fe200030e0633ULL,
0x0000000012277faeULL, 0x0005e2000c901c46ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000382c267810ULL, 0x000fc40007ffe0ffULL, 0x0000003c2c227810ULL, 0x008fe40007ffe0ffULL,
0x0000007010187812ULL, 0x000fe200078ef80bULL, 0x0000000120107824ULL, 0x000fe200078e0208ULL,
0x0000000f1e00720cULL, 0x080fe20003f86070ULL, 0x00000008201f7824ULL, 0x002fe200078e00ffULL,
0x0000000f1c00720cULL, 0x080fe20003fa6070ULL, 0x000000081e1e7824ULL, 0x000fe200078e00ffULL,
0x0000003409127810ULL, 0x004fe20007ffe0ffULL, 0x0000000822237824ULL, 0x000fe200078e00ffULL,
0x0000000f2000720cULL, 0x000fc40003f66070ULL, 0x0000000f2100720cULL, 0x080fe20003f46070ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000f2600720cULL, 0x080fe40003f26070ULL,
0x0000000f2200720cULL, 0x000fe20003f06070ULL, 0x000000011c0f7824ULL, 0x000fe200078e0208ULL,
0x0000003118187210ULL, 0x080fe20007fde0ffULL, 0x000000081c1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe400078ee210ULL, 0x00000070121a7812ULL, 0x000fe200078ef80bULL,
0x0000000121127824ULL, 0x000fe200078e0208ULL, 0x0000003809107810ULL, 0x000fe20007ffe0ffULL,
0x0000000821217824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1d7812ULL, 0x000fe200078ee219ULL,
0x0000000111197824ULL, 0x000fe200030e0633ULL, 0xfffffff81c0f7812ULL, 0x000fe200078ee20fULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000311a1a7210ULL, 0x000fc40007fde0ffULL,
0x0000003c091c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000126097824ULL, 0x000fe200078e0208ULL,
0xfffffff821217812ULL, 0x000fe200078ee212ULL, 0x00000001131b7824ULL, 0x000fe400030e0633ULL,
0x000000801c127825ULL, 0x000fe200078e00ffULL, 0x00000070101c7812ULL, 0x000fc600078ef80bULL,
0x0000000826267824ULL, 0x000fe200078e00ffULL, 0x0000007012127812ULL, 0x000fe200078ef80bULL,
0x0000000122107824ULL, 0x000fe200078e0208ULL, 0x000000311c087210ULL, 0x080fe20007fde0ffULL,
0x000000100f0f7824ULL, 0x100fe200078e0224ULL, 0xfffffff8260b7812ULL, 0x000fe200078ee209ULL,
0x000000101d1d7824ULL, 0x000fe200078e0224ULL, 0xfffffff823237812ULL, 0x000fe200078ee210ULL,
0x0000000111097824ULL, 0x000fe200030e0633ULL, 0x0000003112107210ULL, 0x000fe20007fde0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0224ULL, 0x00000000140f7faeULL, 0x0003e2000e901c46ULL,
0x0000001021217824ULL, 0x000fc400078e0224ULL, 0x000000100b0b7824ULL, 0x100fe200078e0224ULL,
0x00000000161d7faeULL, 0x0003e2000e101c46ULL, 0x0000001023237824ULL, 0x000fe400078e0224ULL,
0x0000000113117824ULL, 0x000fe200030e0633ULL, 0x00000000181f7faeULL, 0x0003e8000d901c46ULL,
0x000000001a217faeULL, 0x0003e8000d101c46ULL, 0x00000000080b7faeULL, 0x0003e8000c901c46ULL,
0x0000000010237faeULL, 0x0003e2000c101c46ULL, 0x00000b5000007947ULL, 0x000fea0003800000ULL,
0x0000000408107811ULL, 0x04afe400078fe8ffULL, 0x0000000808127811ULL, 0x000fc400078fe8ffULL,
0x0000000c08147811ULL, 0x000fe200078fe8ffULL, 0x0000000110097824ULL, 0x100fe200078e0208ULL,
0x0000001c08247811ULL, 0x000fe200078fe8ffULL, 0x0000000810167824ULL, 0x000fe200078e00ffULL,
0x0000002008257811ULL, 0x000fe200078fe8ffULL, 0x0000000812187824ULL, 0x000fe200078e00ffULL,
0x00000024082e7811ULL, 0x000fe200078fe8ffULL, 0x00000001140f7824ULL, 0x100fe200078e0208ULL,
0xfffffff816117812ULL, 0x000fe200078ee209ULL, 0x0000000112097824ULL, 0x100fe200078e0208ULL,
0x0000001008167811ULL, 0x000fe200078fe8ffULL, 0x00000008141a7824ULL, 0x000fe200078e00ffULL,
0x0000002c08327811ULL, 0x000fe200078fe8ffULL, 0x00000008241d7824ULL, 0x000fe200078e00ffULL,
0xfffffff818137812ULL, 0x000fe200078ee209ULL, 0x0000000116177824ULL, 0x000fe200078e0208ULL,
0xfffffff81a157812ULL, 0x000fe200078ee20fULL, 0x00000008161c7824ULL, 0x000fe200078e00ffULL,
0x0000001408187811ULL, 0x040fe200078fe8ffULL, 0x0000000107107824ULL, 0x040fe200078e0210ULL,
0x00000018081a7811ULL, 0x000fe200078fe8ffULL, 0x0000000107127824ULL, 0x000fe200078e0212ULL,
0xfffffff81c177812ULL, 0x000fe200078ee217ULL, 0x0000000118097824ULL, 0x100fe200078e0208ULL,
0x0000002808307811ULL, 0x000fe200078fe8ffULL, 0x00000008181e7824ULL, 0x000fe200078e00ffULL,
0x0000003008347811ULL, 0x000fe200078fe8ffULL, 0x000000011a0f7824ULL, 0x100fe200078e0208ULL,
0x0000003408367811ULL, 0x000fe200078fe8ffULL, 0x000000081a207824ULL, 0x000fe200078e00ffULL,
0xfffffff81e197812ULL, 0x000fe200078ee209ULL, 0x00000001241c7824ULL, 0x100fe200078e0208ULL,
0x0000003808387811ULL, 0x000fe200078fe8ffULL, 0x0000000125097824ULL, 0x040fe200078e0208ULL,
0xfffffff8201b7812ULL, 0x000fe200078ee20fULL, 0x00000008251e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1c7812ULL, 0x000fe200078ee21cULL, 0x000000012e0f7824ULL, 0x100fe200078e0208ULL,
0x0000003c083a7811ULL, 0x000fe200078fe8ffULL, 0x000000082e207824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1d7812ULL, 0x000fe200078ee209ULL, 0x0000000132097824ULL, 0x100fe200078e0208ULL,
0x00002000022a7811ULL, 0x000fe200078e70ffULL, 0x00000001301f7824ULL, 0x000fe200078e0208ULL,
0xfffffff8201e7812ULL, 0x000fe200078ee20fULL, 0x0000000832207824ULL, 0x000fe200078e00ffULL,
0x00006400284d7a11ULL, 0x000fe200078038ffULL, 0x0000000830227824ULL, 0x000fc400078e00ffULL,
0x00000001340f7824ULL, 0x100fe200078e0208ULL, 0xfffffff820207812ULL, 0x000fe200078ee209ULL,
0x0000000834267824ULL, 0x000fe200078e00ffULL, 0x0000000808097211ULL, 0x000fe200078fe8ffULL,
0x0000000836237824ULL, 0x000fe200078e00ffULL, 0xfffffff8221f7812ULL, 0x000fe200078ee21fULL,
0x0000000136227824ULL, 0x100fe200078e0208ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x00000008382c7824ULL, 0x000fe200078e00ffULL, 0xfffffff826217812ULL, 0x000fe200078ee20fULL,
0x00000001380f7824ULL, 0x100fe200078e0208ULL, 0x0ffffff809097812ULL, 0x100fe200078ef808ULL,
0x000000013a267824ULL, 0x000fe200078e0208ULL, 0x0000000708087211ULL, 0x000fe200078fe8ffULL,
0x000000101c3b7824ULL, 0x000fe200078e022aULL, 0xfffffff823227812ULL, 0x000fe200078ee222ULL,
0x0000000107147824ULL, 0x000fe200078e0214ULL, 0xfffffff82c237812ULL, 0x000fe200078ee20fULL,
0x00000010090f7824ULL, 0x000fe200078e022aULL, 0x00006500284f7a11ULL, 0x000fe200000f3cffULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x00000010112f7824ULL, 0x100fe200078e022aULL,
0x00000070081c7812ULL, 0x000fe200078ef80bULL, 0x0000001013317824ULL, 0x000fe400078e022aULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000001c4d1c7210ULL, 0x000fc60007f1e0ffULL,
0x0000001015337824ULL, 0x000fe400078e022aULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x000000101e3f7824ULL, 0x100fe200078e022aULL,
0x00000070101e7812ULL, 0x100fe200078ef80bULL, 0x0000001020437824ULL, 0x000fe200078e022aULL,
0x0000007012207812ULL, 0x100fe200078ef80bULL, 0x0000000107087824ULL, 0x000fe200078e0216ULL,
0x0000001e4d1e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001022477824ULL, 0x100fe200078e022aULL,
0x0000007014227812ULL, 0x000fe200078ef80bULL, 0x000000101d3d7824ULL, 0x000fe400078e022aULL,
0x00000001091d7824ULL, 0x000fe200000e064fULL, 0x000000204d207210ULL, 0x040fe20007f1e0ffULL,
0x000000083a277824ULL, 0x000fe200078e00ffULL, 0x000000224d227210ULL, 0x000fe20007f5e0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c0f7faeULL, 0x0003e4000b901c46ULL, 0xfffffff827267812ULL, 0x000fe200078ee226ULL,
0x0000000107107824ULL, 0x040fe200078e0218ULL, 0x0000007008087812ULL, 0x000fe200078ef80bULL,
0x0000000107127824ULL, 0x000fc400078e021aULL, 0x000000101f417824ULL, 0x000fe400078e022aULL,
0x0000000107147824ULL, 0x000fe400078e0224ULL, 0x0000001021457824ULL, 0x100fe400078e022aULL,
0x00000001111f7824ULL, 0x000fe400008e064fULL, 0x0000000107167824ULL, 0x000fe400078e0225ULL,
0x0000001023497824ULL, 0x000fe200078e022aULL, 0x000000001e2f7faeULL, 0x0003e2000b901c46ULL,
0x0000000113217824ULL, 0x000fe200000e064fULL, 0x000000084d247210ULL, 0x000fe20007f1e0ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x0000000020317faeULL, 0x0003e2000b901c46ULL,
0x0000000115237824ULL, 0x000fe400010e064fULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x0000000022337faeULL, 0x0003e2000b901c46ULL, 0x0000001017357824ULL, 0x000fe200078e022aULL,
0x0000007012287812ULL, 0x000fe200078ef80bULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x000000284d287210ULL, 0x000fe20007f3e0ffULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x00000010264b7824ULL, 0x100fe200078e022aULL, 0x0000007010267812ULL, 0x100fe200078ef80bULL,
0x0000001019377824ULL, 0x100fe200078e022aULL, 0x00000070162c7812ULL, 0x100fe200078ef80bULL,
0x000000101b397824ULL, 0x000fe200078e022aULL, 0x00000070142a7812ULL, 0x000fe200078ef80bULL,
0x0000000109257824ULL, 0x000fe200000e064fULL, 0x000000264d267210ULL, 0x000fe20007f1e0ffULL,
0x0000000107087824ULL, 0x000fe200078e022eULL, 0x0000002a4d2a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000107107824ULL, 0x000fe200078e0230ULL, 0x0000002c4d2c7210ULL, 0x000fe20007f7e0ffULL,
0x0000000107127824ULL, 0x040fe200078e0232ULL, 0x0000000024357faeULL, 0x0003e2000b901c46ULL,
0x0000000107147824ULL, 0x000fc400078e0234ULL, 0x0000000111277824ULL, 0x100fe400000e064fULL,
0x0000000107167824ULL, 0x000fe400078e0236ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000000026377faeULL, 0x0003e6000b901c46ULL, 0x0000000113297824ULL, 0x000fe200008e064fULL,
0x0000007008087812ULL, 0x000fe200078ef80bULL, 0x0000000107187824ULL, 0x000fc400078e0238ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000084d087210ULL, 0x000fe20007f1e0ffULL,
0x0000000028397faeULL, 0x0003e4000b901c46ULL, 0x00000001152b7824ULL, 0x000fe200010e064fULL,
0x0000007010107812ULL, 0x000fe200078ef80bULL, 0x00000001071a7824ULL, 0x000fe400078e023aULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000104d107210ULL, 0x000fe20007f3e0ffULL,
0x000000002a3b7faeULL, 0x0003e4000b901c46ULL, 0x00000001172d7824ULL, 0x000fe200018e064fULL,
0x0000007012127812ULL, 0x000fe200078ef80bULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x000000124d127210ULL, 0x040fe20007f5e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000007014147812ULL, 0x100fe200078ef80bULL, 0x000000002c3d7faeULL, 0x0003e4000b901c46ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000007016167812ULL, 0x100fe400078ef80bULL,
0x000000144d147210ULL, 0x000fe20007f7e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000007018187812ULL, 0x000fc400078ef80bULL, 0x000000164d167210ULL, 0x000fe20007f9e0ffULL,
0x0000000109097824ULL, 0x000fe200000e064fULL, 0x000000701a0b7812ULL, 0x000fe200078ef80bULL,
0x0000000111117824ULL, 0x100fe200008e064fULL, 0x000000184d187210ULL, 0x000fe20007fbe0ffULL,
0x0000000113137824ULL, 0x100fe200010e064fULL, 0x0000000b4d1a7210ULL, 0x000fe20007fde0ffULL,
0x0000000115157824ULL, 0x100fe200018e064fULL, 0x00000000083f7faeULL, 0x0003e2000b901c46ULL,
0x0000000117177824ULL, 0x100fe400020e064fULL, 0x0000000119197824ULL, 0x100fe200028e064fULL,
0x0000000010417faeULL, 0x0003e2000b901c46ULL, 0x000000011b1b7824ULL, 0x000fc600030e064fULL,
0x0000000012437faeULL, 0x0003e8000b901c46ULL, 0x0000000014457faeULL, 0x0003e8000b901c46ULL,
0x0000000016477faeULL, 0x0003e8000b901c46ULL, 0x0000000018497faeULL, 0x0003e8000b901c46ULL,
0x000000001a4b7faeULL, 0x0003e4000b901c46ULL, 0x0000000402087810ULL, 0x002fe20007ffe0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000050800720cULL, 0x000fda0003f06070ULL,
0x00000002c2098824ULL, 0x000fc800078e00ffULL, 0x00006a0009108a24ULL, 0x000fe400078e0208ULL,
0xffffffffff097424ULL, 0x000fe400078e00ffULL, 0x0000660010108625ULL, 0x000fca00078e0083ULL,
0x0000000610098981ULL, 0x000322000c1e1900ULL, 0x00005800ff0b7624ULL, 0x000fca00078e00ffULL,
0x0000001f0b0b7810ULL, 0x000fc80007ffe0ffULL, 0x00000005ff1d7819ULL, 0x000fc4000001160bULL,
0x0000000000107805ULL, 0x002fca0000015200ULL, 0x01a60400ff0b7984ULL, 0x000e620000000800ULL,
0x0000001d0a827224ULL, 0x000fe400078e02ffULL, 0x00000001040a7824ULL, 0x000fe400078e0a00ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x800000000bff7812ULL, 0x002fe2000780480dULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620082827625ULL, 0x000fe200078e0083ULL, 0x00000008ff0a7819ULL, 0x000fe2000001160aULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc80000011413ULL, 0x000000120b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x000000020b0b7819ULL, 0x000fc80000001212ULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a60400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000b7919ULL, 0x000e640000000000ULL,
0x00000020020b7824ULL, 0x002fca00078e020bULL, 0x00000004ff0c7819ULL, 0x000fe4000001160bULL,
0x000000010b0d7810ULL, 0x040fe40007ffe0ffULL, 0x0ffffffe0c107812ULL, 0x000fe400078ec0ffULL,
0x0000001f0b0c7812ULL, 0x000fc600078ec0ffULL, 0x0000000110117824ULL, 0x040fe400078e020dULL,
0x000000010b0f7824ULL, 0x000fe200078e0210ULL, 0x0000000810107810ULL, 0x000fe20007ffe0ffULL,
0x000000100c147824ULL, 0x040fe200078e00ffULL, 0x0000000f11117812ULL, 0x000fe200078ec0ffULL,
0x000000100c127824ULL, 0x000fe200078e00ffULL, 0x0000000f0f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000010d0d7824ULL, 0x100fe200078e0210ULL, 0x000001f014117812ULL, 0x000fe200078ee211ULL,
0x000000010b0b7824ULL, 0x000fe200078e0210ULL, 0x000001f0120f7812ULL, 0x000fe200078ee20fULL,
0x000000100c107824ULL, 0x040fe200078e00ffULL, 0x0000000f0d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000011147984ULL, 0x000e62000000cc00ULL, 0x000000100c0c7824ULL, 0x000fe200078e00ffULL,
0x0000000f0b0b7812ULL, 0x000fc400078ec0ffULL, 0x000000000f187984ULL, 0x000ea4000000cc00ULL,
0x000001f00c0d7812ULL, 0x000fe400078ee20dULL, 0x000001f0100b7812ULL, 0x000fe200078ee20bULL,
0x000000ffff227224ULL, 0x002fe400078e0014ULL, 0x000000ffff237224ULL, 0x000fe400078e0016ULL,
0x000000ffff207224ULL, 0x004fe400078e0018ULL, 0x000000ffff217224ULL, 0x000fc400078e001aULL,
0x000000ffff267224ULL, 0x000fe400078e0015ULL, 0x000000ffff277224ULL, 0x000fe200078e0017ULL,
0x000000200f007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff247224ULL, 0x000fe400078e0019ULL,
0x000000ffff257224ULL, 0x000fca00078e001bULL, 0x0000002411007388ULL, 0x000fe8000000cc00ULL,
0x000000000d147984ULL, 0x000e68000000cc00ULL, 0x000000000b187984ULL, 0x000ea2000000cc00ULL,
0x000000ffff2b7224ULL, 0x002fe400078e0016ULL, 0x000000ffff2a7224ULL, 0x000fc400078e0014ULL,
0x000000ffff167224ULL, 0x000fe400078e0015ULL, 0x000000ffff287224ULL, 0x004fe400078e0018ULL,
0x000000ffff297224ULL, 0x000fe400078e001aULL, 0x000000ffff147224ULL, 0x000fe400078e0019ULL,
0x000000ffff157224ULL, 0x000fe200078e001bULL, 0x000000280b007388ULL, 0x0003e8000000cc00ULL,
0x000000140d007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a60000ff127f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0f7224ULL, 0x000fc600078e00ffULL,
0x00000000000c7805ULL, 0x002fc80000015200ULL, 0x01a60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x006fc40007804813ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100c107210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0dULL, 0x003d09001000780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401000780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011411ULL,
0x000000100b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff107224ULL, 0x000fca00000e0611ULL,
0x000000020b0b7819ULL, 0x000fc80000001210ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0600720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00000000000b7919ULL, 0x000e620000000000ULL, 0x3db504f30e0d7820ULL, 0x010fe20000410000ULL,
0x00000100bcbf7810ULL, 0x000fe20007ffe0ffULL, 0x00006a00c2c27a24ULL, 0x000fe200078e02ffULL,
0x0001a68802bb7811ULL, 0x000fe200078e18ffULL, 0x000000021d0c7824ULL, 0x000fe200078e00ffULL,
0xffffffff000e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000009000f7810ULL, 0x000fe40007ffe0ffULL, 0x0001a60802be7811ULL, 0x000fc600078e28ffULL,
0x0000000210137810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000009c02b7224ULL, 0x010fe200078e02ffULL, 0x0000000111127812ULL, 0x000fc400078e0cffULL,
0x000000061300720cULL, 0x000fda0003f06070ULL, 0x00000cd000008947ULL, 0x00cfea0003800000ULL,
0x00000003ff247819ULL, 0x002fe2000001160bULL, 0x0000010010097824ULL, 0x000fe200078e02bfULL,
0x000064002b297a11ULL, 0x040fe400078438ffULL, 0x0000000424167810ULL, 0x040fe40007ffe0ffULL,
0x0000000824187810ULL, 0x000fe40007ffe0ffULL, 0x0000000904147217ULL, 0x000fe20007800000ULL,
0x0000000116137824ULL, 0x100fe200078e020bULL, 0x0000000c24207810ULL, 0x000fe20007ffe0ffULL,
0x0000000816267824ULL, 0x000fe200078e00ffULL, 0x0000001024227810ULL, 0x000fe20007ffe0ffULL,
0x0000000118157824ULL, 0x000fe200078e020bULL, 0x00000014242e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000818287824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee213ULL,
0x0000000114097824ULL, 0x000fe200078e0a09ULL, 0x0000001824327810ULL, 0x000fe20007ffe0ffULL,
0x0000000120137824ULL, 0x000fe200078e020bULL, 0xfffffff828287812ULL, 0x000fe200078ee215ULL,
0x00000008202a7824ULL, 0x000fe200078e00ffULL, 0x000000091600720cULL, 0x080fe20003f26070ULL,
0x0000000122147824ULL, 0x000fe200078e020bULL, 0x000000091800720cULL, 0x080fe20003f06070ULL,
0x0000000822197824ULL, 0x000fe200078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee213ULL,
0x000000012e157824ULL, 0x040fe200078e020bULL, 0x000065002b2b7a11ULL, 0x000fe200010f3cffULL,
0x000000082e307824ULL, 0x000fe200078e00ffULL, 0xfffffff8192c7812ULL, 0x000fe200078ee214ULL,
0x000000100b137824ULL, 0x000fe200078e00ffULL, 0x0000001c24367810ULL, 0x000fe20007ffe0ffULL,
0x0000000107147824ULL, 0x000fe200078e0224ULL, 0xfffffff830307812ULL, 0x000fe200078ee215ULL,
0x0000000132177824ULL, 0x040fe200078e020bULL, 0x00000070132d7812ULL, 0x000fe200078ec0ffULL,
0x0000000832347824ULL, 0x000fe200078e00ffULL, 0x00000020243a7810ULL, 0x000fe20007ffe0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000092200720cULL, 0x000fc40003fa6070ULL,
0xfffffff834347812ULL, 0x000fe200078ee217ULL, 0x0000000107167824ULL, 0x040fe200078e0216ULL,
0x0000002d141a7212ULL, 0x000fe200078efcffULL, 0x0000000107187824ULL, 0x000fe400078e0218ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000001a291a7210ULL, 0x000fc60007f5e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000002d161c7212ULL, 0x000fc600078efcffULL,
0x0000000107147824ULL, 0x000fe200078e0220ULL, 0x0000002d181e7212ULL, 0x000fe200078efcffULL,
0x00000001151b7824ULL, 0x000fe200010e062bULL, 0x000000291c1c7210ULL, 0x080fe20007f7e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000291e1e7210ULL, 0x000fe40007f9e0ffULL,
0x000000092000720cULL, 0x000fe20003f46070ULL, 0x0000000136137824ULL, 0x000fe200078e020bULL,
0x0000002d14207212ULL, 0x000fe200078efcffULL, 0x0000000836387824ULL, 0x000fc400078e00ffULL,
0x0000000107167824ULL, 0x000fe400078e0222ULL, 0x0000000124187824ULL, 0x000fe200078e020bULL,
0xfffffff838387812ULL, 0x000fe200078ee213ULL, 0x00000001171d7824ULL, 0x000fe200018e062bULL,
0x000000092400720cULL, 0x000fe20003f66070ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000718187812ULL, 0x000fc600078ec0ffULL, 0x00000001191f7824ULL, 0x000fe200020e062bULL,
0x0000002920207210ULL, 0x000fe20007f9e0ffULL, 0x0000000202137824ULL, 0x000fe200078e0212ULL,
0x0000002d16227212ULL, 0x000fe200078efcffULL, 0x0000000107147824ULL, 0x000fe200078e022eULL,
0x0ffffff818187812ULL, 0x100fe200078ef80bULL, 0x000000013a197824ULL, 0x040fe200078e020bULL,
0x0000200013137811ULL, 0x000fe200078e68ffULL, 0x000000083a3c7824ULL, 0x000fe200078e00ffULL,
0x0000002922227210ULL, 0x000fe20007fde0ffULL, 0x0000000115217824ULL, 0x000fe200020e062bULL,
0x000000092e00720cULL, 0x000fe20003f86070ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fc400078ee219ULL, 0x0000002c242e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107167824ULL, 0x000fe200078e0232ULL, 0x0000002d14147212ULL, 0x000fe200078efcffULL,
0x0000001018197824ULL, 0x000fe400078e0213ULL, 0x0000000117237824ULL, 0x000fe400030e062bULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a197faeULL, 0x0003e2000d901c46ULL, 0x000000093200720cULL, 0x000fe40003f66070ULL,
0x0000001026257824ULL, 0x000fe200078e0213ULL, 0x0000002424267810ULL, 0x000fe20007ffe0ffULL,
0x0000000107187824ULL, 0x000fc600078e0236ULL, 0x000000001c257faeULL, 0x0005e2000c901c46ULL,
0x0000000126277824ULL, 0x000fe200078e020bULL, 0x000000093600720cULL, 0x000fe40003f26070ULL,
0x00000029141a7210ULL, 0x002fe20007fde0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000002d16147212ULL, 0x000fc600078efcffULL, 0x00000001151b7824ULL, 0x000fe200030e062bULL,
0x0000002d18187212ULL, 0x000fe200078efcffULL, 0x0000000826167824ULL, 0x000fe200078e00ffULL,
0x00000029141c7210ULL, 0x084fe20007fde0ffULL, 0x0000000107147824ULL, 0x000fe400078e023aULL,
0x0000001028257824ULL, 0x000fe200078e0213ULL, 0xfffffff816287812ULL, 0x000fe200078ee227ULL,
0x00000001171d7824ULL, 0x000fe200030e062bULL, 0x0000002918187210ULL, 0x000fe20007fde0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000001e257faeULL, 0x0003e2000c101c46ULL,
0x000000093a00720cULL, 0x000fc40003f06070ULL, 0x000000102a177824ULL, 0x000fe200078e0213ULL,
0x00000028242a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107167824ULL, 0x000fe400078e0226ULL,
0x0000000119197824ULL, 0x000fe200030e062bULL, 0x0000000020177faeULL, 0x0005e2000d101c46ULL,
0x000000092600720cULL, 0x000fe20003f46070ULL, 0x000000082a267824ULL, 0x000fe200078e00ffULL,
0x0000002d141e7212ULL, 0x002fe200078efcffULL, 0x000000012a1f7824ULL, 0x100fe400078e020bULL,
0x000000012e147824ULL, 0x000fe200078e020bULL, 0x000000291e1e7210ULL, 0x000fe20007fde0ffULL,
0x000000082e277824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee21fULL,
0x000000102c257824ULL, 0x000fc400078e0213ULL, 0x00000001151f7824ULL, 0x000fe200030e062bULL,
0xfffffff8272c7812ULL, 0x000fe200078ee214ULL, 0x0000008016147825ULL, 0x000fe200078e00ffULL,
0x0000000022257faeULL, 0x0003e2000e901c46ULL, 0x000000092a00720cULL, 0x000fe40003fa6070ULL,
0x0000000107167824ULL, 0x040fe200078e022aULL, 0x0000002d14207212ULL, 0x004fe200078efcffULL,
0x0000000107147824ULL, 0x000fe200078e022eULL, 0x00000030242a7810ULL, 0x000fe20007ffe0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000002920207210ULL, 0x000fc60007fde0ffULL,
0x0000001030277824ULL, 0x000fe200078e0213ULL, 0x0000002d16167212ULL, 0x000fe200078efcffULL,
0x0000000115217824ULL, 0x000fe200030e062bULL, 0x0000003824307810ULL, 0x000fe20007ffe0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000001a277faeULL, 0x0005e2000e101c46ULL,
0x000000092e00720cULL, 0x000fe40003f86070ULL, 0x0000001034257824ULL, 0x002fe200078e0213ULL,
0x0000002d14227212ULL, 0x000fe200078efcffULL, 0x000000012a237824ULL, 0x000fe200078e020bULL,
0x0000003424147810ULL, 0x000fe20007ffe0ffULL, 0x000000082a2e7824ULL, 0x040fe200078e00ffULL,
0x000000001c257faeULL, 0x0003e2000d901c46ULL, 0x000000092a00720cULL, 0x000fc40003f66070ULL,
0x0000003c24247810ULL, 0x000fe20007ffe0ffULL, 0x0000001038277824ULL, 0x004fe200078e0213ULL,
0x00000029161a7210ULL, 0x080fe20007fde0ffULL, 0x0000000107167824ULL, 0x000fe200078e022aULL,
0xfffffff82e2a7812ULL, 0x000fe200078ee223ULL, 0x00000008142e7824ULL, 0x000fe200078e00ffULL,
0x0000000018277faeULL, 0x0005e2000c901c46ULL, 0x00000001171b7824ULL, 0x000fe200030e062bULL,
0x0000002922227210ULL, 0x000fe20007fde0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000091400720cULL, 0x000fc60003f26070ULL, 0x0000000115237824ULL, 0x000fe200030e062bULL,
0x0000002d161c7212ULL, 0x002fe200078efcffULL, 0x0000000114157824ULL, 0x000fe400078e020bULL,
0x0000000107147824ULL, 0x040fe200078e0214ULL, 0x000000291c1c7210ULL, 0x000fe20007fde0ffULL,
0x0000000107167824ULL, 0x000fe200078e0230ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee215ULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x00000001171d7824ULL, 0x000fe200030e062bULL,
0x0000002d14187212ULL, 0x004fe200078efcffULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0x0000002918187210ULL, 0x000fe20007fde0ffULL, 0x000000103c257824ULL, 0x100fe200078e0213ULL,
0x0000002d16167212ULL, 0x000fe200078efcffULL, 0x0000001028277824ULL, 0x000fe400078e0213ULL,
0x0000000107147824ULL, 0x000fe200078e0224ULL, 0x000000001e257faeULL, 0x0003e2000c101c46ULL,
0x0000000115197824ULL, 0x000fe200030e062bULL, 0x000000092400720cULL, 0x080fe20003f06070ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000020277faeULL, 0x0005e2000d101c46ULL,
0x000000093000720cULL, 0x000fc40003f46070ULL, 0x0000000130097824ULL, 0x100fe200078e020bULL,
0x0000002916167210ULL, 0x000fe40007fde0ffULL, 0x0000002d14147212ULL, 0x000fe200078efcffULL,
0x00000008301e7824ULL, 0x002fe400078e00ffULL, 0x00000001241f7824ULL, 0x040fe400078e020bULL,
0x0000000824207824ULL, 0x004fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL,
0x0000000117177824ULL, 0x000fe200030e062bULL, 0x0000002914147210ULL, 0x000fe20007fde0ffULL,
0x0000001026097824ULL, 0x000fe200078e0213ULL, 0xfffffff820207812ULL, 0x000fe200078ee21fULL,
0x000000102c1f7824ULL, 0x000fc400078e0213ULL, 0x000000102a217824ULL, 0x100fe200078e0213ULL,
0x000000001a097faeULL, 0x0003e2000e901c46ULL, 0x000000102e257824ULL, 0x100fe400078e0213ULL,
0x000000101e277824ULL, 0x100fe200078e0213ULL, 0x00000000221f7faeULL, 0x0003e2000e101c46ULL,
0x0000001020137824ULL, 0x000fe400078e0213ULL, 0x0000000115157824ULL, 0x000fe200030e062bULL,
0x000000001c217faeULL, 0x0003e8000d901c46ULL, 0x0000000018257faeULL, 0x0003e8000c901c46ULL,
0x0000000016277faeULL, 0x0003e8000d101c46ULL, 0x0000000014137faeULL, 0x0003e2000c101c46ULL,
0x00000b8000007947ULL, 0x000fea0003800000ULL, 0x000000140b207811ULL, 0x042fe400078fe8ffULL,
0x000000040b187811ULL, 0x000fc400078fe8ffULL, 0x0000000c0b1c7811ULL, 0x040fe200078fe8ffULL,
0x0000000120157824ULL, 0x140fe200078e020bULL, 0x000000080b1a7811ULL, 0x040fe200078fe8ffULL,
0x0000000820247824ULL, 0x000fe200078e00ffULL, 0x000000240b287811ULL, 0x040fe200078fe8ffULL,
0x0000000118097824ULL, 0x040fe200078e020bULL, 0x000000100b1e7811ULL, 0x040fe200078fe8ffULL,
0x0000000818147824ULL, 0x000fe200078e00ffULL, 0xfffffff8243b7812ULL, 0x000fe200078ee215ULL,
0x000000011c137824ULL, 0x040fe200078e020bULL, 0x0000001c0b247811ULL, 0x040fe200078fe8ffULL,
0x000000081c227824ULL, 0x000fe200078e00ffULL, 0xfffffff814177812ULL, 0x000fe200078ee209ULL,
0x000000011a097824ULL, 0x040fe200078e020bULL, 0x000000200b267811ULL, 0x040fe200078fe8ffULL,
0x000000081a167824ULL, 0x000fe200078e00ffULL, 0xfffffff822377812ULL, 0x000fe200078ee213ULL,
0x0000000128157824ULL, 0x040fe200078e020bULL, 0x000000180b227811ULL, 0x040fe200078fe8ffULL,
0x00000008282c7824ULL, 0x000fe200078e00ffULL, 0xfffffff816357812ULL, 0x000fe200078ee209ULL,
0x0000000124137824ULL, 0x040fe200078e020bULL, 0x000000340b307811ULL, 0x040fe200078fe8ffULL,
0x00000008242a7824ULL, 0x000fe200078e00ffULL, 0xfffffff82c437812ULL, 0x000fe200078ee215ULL,
0x000000011e147824ULL, 0x040fe200078e020bULL, 0x0000002c0b2c7811ULL, 0x040fe200078fe8ffULL,
0x000000081e397824ULL, 0x000fe200078e00ffULL, 0xfffffff82a3f7812ULL, 0x000fe200078ee213ULL,
0x0000000122097824ULL, 0x140fe200078e020bULL, 0x000000280b2a7811ULL, 0x000fe200078fe8ffULL,
0x0000000822167824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee214ULL,
0x0000000126147824ULL, 0x040fe200078e020bULL, 0x000000300b2e7811ULL, 0x000fe200078fe8ffULL,
0x0000000826417824ULL, 0x000fe200078e00ffULL, 0xfffffff8163d7812ULL, 0x000fe200078ee209ULL,
0x000000012c137824ULL, 0x140fe200078e020bULL, 0x000064002b537a11ULL, 0x000fe200078038ffULL,
0x000000082c327824ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee214ULL,
0x000000012a097824ULL, 0x040fe200078e020bULL, 0x000065002b557a11ULL, 0x000fe200000f3cffULL,
0x000000082a167824ULL, 0x000fe200078e00ffULL, 0xfffffff832477812ULL, 0x000fe200078ee213ULL,
0x0000000130157824ULL, 0x040fe200078e020bULL, 0x000000380b327811ULL, 0x040fe200078fe8ffULL,
0x0000000830347824ULL, 0x000fe200078e00ffULL, 0xfffffff816457812ULL, 0x000fe200078ee209ULL,
0x000000012e147824ULL, 0x040fe200078e020bULL, 0x0000000b0b097211ULL, 0x040fe200078fe8ffULL,
0x000000082e497824ULL, 0x000fe200078e00ffULL, 0xfffffff8344b7812ULL, 0x000fe200078ee215ULL,
0x0000000132157824ULL, 0x140fe200078e020bULL, 0x0000003c0b347811ULL, 0x000fe200078fe8ffULL,
0x0000000832167824ULL, 0x000fe200078e00ffULL, 0xfffffff849497812ULL, 0x000fe200078ee214ULL,
0x0000000202137824ULL, 0x000fe200078e0212ULL, 0x0000000709147812ULL, 0x000fe200078ec0ffULL,
0x0000000134197824ULL, 0x000fe200078e020bULL, 0xfffffff8164d7812ULL, 0x000fe200078ee215ULL,
0x0000000834367824ULL, 0x000fe200078e00ffULL, 0x0ffffff814097812ULL, 0x000fe200078ef80bULL,
0x000000100b147824ULL, 0x000fe200078e00ffULL, 0x0000200013167811ULL, 0x000fc400078e68ffULL,
0xfffffff836197812ULL, 0x000fe400078ee219ULL, 0x000000070b157211ULL, 0x000fe200078fe8ffULL,
0x0000001009097824ULL, 0x100fe200078e0216ULL, 0x0000007014517812ULL, 0x000fe200078ec0ffULL,
0x0000001017137824ULL, 0x100fe400078e0216ULL, 0x0000001035357824ULL, 0x100fe400078e0216ULL,
0x0000001037377824ULL, 0x100fe400078e0216ULL, 0x0000001039397824ULL, 0x000fc400078e0216ULL,
0x000000103b3b7824ULL, 0x100fe400078e0216ULL, 0x000000103d3d7824ULL, 0x100fe400078e0216ULL,
0x000000103f3f7824ULL, 0x100fe400078e0216ULL, 0x0000001041417824ULL, 0x100fe400078e0216ULL,
0x0000001043437824ULL, 0x100fe400078e0216ULL, 0x0000001045457824ULL, 0x000fc400078e0216ULL,
0x0000001047477824ULL, 0x100fe400078e0216ULL, 0x0000001049497824ULL, 0x100fe400078e0216ULL,
0x000000104b4b7824ULL, 0x100fe400078e0216ULL, 0x000000104d4d7824ULL, 0x100fe400078e0216ULL,
0x00000010194f7824ULL, 0x000fe400078e0216ULL, 0x0000008015147825ULL, 0x000fc800078e00ffULL,
0x0000000107167824ULL, 0x040fe200078e0218ULL, 0x0000005114147212ULL, 0x000fe200078efcffULL,
0x0000000107187824ULL, 0x040fe400078e021aULL, 0x00000001071a7824ULL, 0x000fe200078e021cULL,
0x0000001453147210ULL, 0x000fe20007f1e0ffULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x00000001071c7824ULL, 0x000fe200078e021eULL, 0x0000005118187212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000005116167212ULL, 0x000fc600078efcffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x000000511c1c7212ULL, 0x080fe400078efcffULL, 0x0000001653167210ULL, 0x000fe20007f3e0ffULL,
0x0000000115157824ULL, 0x000fe200000e0655ULL, 0x0000001853187210ULL, 0x000fe20007f1e0ffULL,
0x00000001071e7824ULL, 0x040fe200078e0220ULL, 0x000000511a1a7212ULL, 0x000fe200078efcffULL,
0x0000000107207824ULL, 0x040fe200078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014097faeULL, 0x0003e2000b901c46ULL, 0x0000000107227824ULL, 0x000fe200078e0224ULL,
0x0000001a531a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000107247824ULL, 0x000fc400078e0226ULL,
0x000000801e1e7825ULL, 0x000fc800078e00ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x000000511e1e7212ULL, 0x000fc600078efcffULL, 0x0000000119197824ULL, 0x000fe200000e0655ULL,
0x0000001c531c7210ULL, 0x000fe20007f1e0ffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000005120207212ULL, 0x000fc600078efcffULL, 0x0000000107267824ULL, 0x000fe200078e0228ULL,
0x0000005122227212ULL, 0x000fe200078efcffULL, 0x0000008024247825ULL, 0x000fc800078e00ffULL,
0x0000000107287824ULL, 0x040fe200078e022aULL, 0x0000005124247212ULL, 0x000fe200078efcffULL,
0x00000001072a7824ULL, 0x040fe400078e022cULL, 0x00000001072c7824ULL, 0x000fe200078e022eULL,
0x0000002453247210ULL, 0x000fe20007f7e0ffULL, 0x00000001072e7824ULL, 0x000fe400078e0230ULL,
0x0000008026267825ULL, 0x000fc800078e00ffULL, 0x0000000107307824ULL, 0x000fe200078e0232ULL,
0x0000005126267212ULL, 0x000fe200078efcffULL, 0x0000008028287825ULL, 0x000fc800078e00ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0655ULL, 0x0000001e531e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000107327824ULL, 0x000fe200078e0234ULL, 0x0000005128287212ULL, 0x000fe200078efcffULL,
0x000000802a2a7825ULL, 0x000fc800078e00ffULL, 0x0000000117177824ULL, 0x100fe200008e0655ULL,
0x0000002053207210ULL, 0x000fe20007f3e0ffULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x000000512a2a7212ULL, 0x080fe400078efcffULL, 0x0000000016137faeULL, 0x0003e2000b901c46ULL,
0x000000011b1b7824ULL, 0x100fe200010e0655ULL, 0x0000002253227210ULL, 0x040fe20007f5e0ffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x000000512c2c7212ULL, 0x080fe200078efcffULL,
0x0000000018357faeULL, 0x0003e4000b901c46ULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x000000512e2e7212ULL, 0x080fe200078efcffULL, 0x000000001a377faeULL, 0x0003e4000b901c46ULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x0000005130307212ULL, 0x080fe200078efcffULL,
0x000000001c397faeULL, 0x0003e2000b901c46ULL, 0x0000002e532e7210ULL, 0x000fe20007f9e0ffULL,
0x000000011f1f7824ULL, 0x100fe200000e0655ULL, 0x0000002653267210ULL, 0x000fe20007f1e0ffULL,
0x0000000121217824ULL, 0x100fe200008e0655ULL, 0x0000002853287210ULL, 0x000fe20007f3e0ffULL,
0x0000000123237824ULL, 0x100fe200010e0655ULL, 0x0000005132327212ULL, 0x000fe200078efcffULL,
0x0000000125257824ULL, 0x100fe200018e0655ULL, 0x0000002a532a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000127277824ULL, 0x100fe200000e0655ULL, 0x0000002c532c7210ULL, 0x000fe20007f7e0ffULL,
0x0000000129297824ULL, 0x100fe200008e0655ULL, 0x0000003053307210ULL, 0x040fe20007fbe0ffULL,
0x000000001e3b7faeULL, 0x0003e2000b901c46ULL, 0x0000003253327210ULL, 0x000fe20007fde0ffULL,
0x000000012b2b7824ULL, 0x000fc400010e0655ULL, 0x00000000203d7faeULL, 0x0003e2000b901c46ULL,
0x000000012d2d7824ULL, 0x100fe400018e0655ULL, 0x000000012f2f7824ULL, 0x100fe200020e0655ULL,
0x00000000223f7faeULL, 0x0003e2000b901c46ULL, 0x0000000131317824ULL, 0x100fe400028e0655ULL,
0x0000000133337824ULL, 0x000fe200030e0655ULL, 0x0000000024417faeULL, 0x0003e8000b901c46ULL,
0x0000000026437faeULL, 0x0003e8000b901c46ULL, 0x0000000028457faeULL, 0x0003e8000b901c46ULL,
0x000000002a477faeULL, 0x0003e8000b901c46ULL, 0x000000002c497faeULL, 0x0003e8000b901c46ULL,
0x000000002e4b7faeULL, 0x0003e8000b901c46ULL, 0x00000000304d7faeULL, 0x0003e8000b901c46ULL,
0x00000000324f7faeULL, 0x0003e4000b901c46ULL, 0x0000000408087810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff097424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000050800720cULL, 0x000fda0003f06070ULL, 0x00000002c2168824ULL, 0x000fe400078e0208ULL,
0x00000004ff178424ULL, 0x000fc800078e00ffULL, 0x0000660016168625ULL, 0x000fe200078e0017ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x0000000616098981ULL, 0x000322000c1e1900ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000006e7805ULL, 0x000fe2000001ff00ULL, 0x00000000006c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x002fc80000000000ULL, 0xfffffff80b147812ULL, 0x000fe200078ec0ffULL,
0x0000000202717824ULL, 0x020fe200078e0211ULL, 0x0000000115727810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000714147812ULL, 0x000fc400078ef80bULL,
0x0000200071717811ULL, 0x000fc600078e68ffULL, 0x0000000114137824ULL, 0x040fe400078e0215ULL,
0x0000000814167824ULL, 0x000fca00078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee213ULL,
0x0000000814137824ULL, 0x040fe400078e00ffULL, 0x0000000114147824ULL, 0x000fe400078e0272ULL,
0x0000001016167824ULL, 0x000fc600078e0271ULL, 0xfffffff813147812ULL, 0x000fe400078ee214ULL,
0x000000001628783bULL, 0x000e660000000200ULL, 0x0000001014147824ULL, 0x000fca00078e0271ULL,
0x00000000142c783bULL, 0x0004e40000000200ULL, 0x000000200b147810ULL, 0x004fc80007ffe0ffULL,
0xfffffff814147812ULL, 0x000fc800078ec0ffULL, 0x0000000714737812ULL, 0x000fca00078ef80bULL,
0x0000000173137824ULL, 0x040fe400078e0215ULL, 0x0000000873147824ULL, 0x040fe400078e00ffULL,
0x0000000173727824ULL, 0x040fe400078e0272ULL, 0x0000000873737824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe400078ee213ULL, 0x00000018ff187819ULL, 0x002fc6000001142aULL,
0x0000001014147824ULL, 0x000fe200078e0271ULL, 0x0000002800f67306ULL, 0x000fe20000009400ULL,
0x00000018ff167819ULL, 0x000fe40000011428ULL, 0x00000018ff177819ULL, 0x000fe20000011429ULL,
0x000000001468783bULL, 0x000e620000000200ULL, 0x00000018ff137819ULL, 0x000fe2000001142bULL,
0x000100002f767824ULL, 0x008fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001142dULL,
0x0000001800c37306ULL, 0x000fe20000209400ULL, 0x00000018ff707819ULL, 0x000fc4000001142eULL,
0x00000018ff747819ULL, 0x000fe4000001142fULL, 0xfffffff873727812ULL, 0x000fc600078ee272ULL,
0x0000001800c47306ULL, 0x000ff00000205400ULL, 0x0000001800b17306ULL, 0x000ff0000020d400ULL,
0x0000001f008b7306ULL, 0x000ff00000209400ULL, 0x0000001f008c7306ULL, 0x000ff00000205400ULL,
0x0000001f00187306ULL, 0x0005f0000020d400ULL, 0x0000002800c57306ULL, 0x000ee20000005400ULL,
0x00010000281f7824ULL, 0x004fca00078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000002800a37306ULL, 0x000470000000d400ULL, 0x0000001f00e67306ULL, 0x000fe20000209400ULL,
0x0000010028287824ULL, 0x004fe200078e00ffULL, 0x000000c5f600720bULL, 0x008fc80003f7d000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000001f00f57306ULL, 0x000eae0000205400ULL,
0x00000001a3a33812ULL, 0x002fe200078efcffULL, 0x0000002800d47306ULL, 0x000ff00000209400ULL,
0x0000002800d57306ULL, 0x000fe20000205400ULL, 0x000000f5e600720bULL, 0x004fce0003fbd000ULL,
0x0000002800c87306ULL, 0x0003f0000020d400ULL, 0x0000001f00d67306ULL, 0x0004e2000020d400ULL,
0x000100002b287824ULL, 0x002fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000070001d7306ULL, 0x000fe20000209400ULL, 0x000100002a1f7824ULL, 0x004fca00078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000007000197306ULL, 0x000fe20000205400ULL,
0x00000001d6d65812ULL, 0x008fe400078efcffULL, 0x000000d5d400720bULL, 0x000fca0003fbd000ULL,
0x00000070001a7306ULL, 0x0003f0000020d400ULL, 0x0000002800d77306ULL, 0x000fe20000209400ULL,
0x0001000029707824ULL, 0x002fe200078e00ffULL, 0x00000001c8c85812ULL, 0x000fc400078efcffULL,
0x000000c4c300720bULL, 0x000fe40003fbd000ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000002800ee7306ULL, 0x000fe20000205400ULL, 0x000000080bc47812ULL, 0x000fc800078ec0ffULL,
0x00000007c4c37812ULL, 0x000fc600078ef80bULL, 0x0000002800d87306ULL, 0x0003e2000020d400ULL,
0x00000010c3c47812ULL, 0x000fe400078efcffULL, 0x00000001b1b15812ULL, 0x000fca00078efcffULL,
0x0000002900f37306ULL, 0x000fe20000009400ULL, 0x00000018ff287819ULL, 0x002fce000001146aULL,
0x00000029008e7306ULL, 0x000e700000005400ULL, 0x0000002900a67306ULL, 0x0004f0000000d400ULL,
0x0000002a00937306ULL, 0x000fe20000009400ULL, 0x0000010029297824ULL, 0x004fe200078e00ffULL,
0x0000008ef300720bULL, 0x002fc80003f3d000ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002a00f47306ULL, 0x000e6e0000005400ULL, 0x00000001a6a61812ULL, 0x008fe200078efcffULL,
0x0000002a00df7306ULL, 0x0004f0000000d400ULL, 0x0000002b00947306ULL, 0x000fe20000009400ULL,
0x000001002a2a7824ULL, 0x004fe200078e00ffULL, 0x000000f49300720bULL, 0x002fc80003f1d000ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000002b00f17306ULL, 0x000e6e0000005400ULL,
0x00000001dfdf0812ULL, 0x008fe200078efcffULL, 0x0000002b00d37306ULL, 0x0004f0000000d400ULL,
0x0000001f00977306ULL, 0x000fe20000209400ULL, 0x000001002b2b7824ULL, 0x004fe200078e00ffULL,
0x000000f19400720bULL, 0x002fc80003f5d000ULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x0000001f00987306ULL, 0x000fee0000205400ULL, 0x00000001d3d32812ULL, 0x008fe200078efcffULL,
0x0000001f00e47306ULL, 0x0003f0000020d400ULL, 0x0000001700927306ULL, 0x000fe20000209400ULL,
0x00000018ff1f7819ULL, 0x002fce0000011468ULL, 0x0000001700997306ULL, 0x000e700000205400ULL,
0x0000001700a27306ULL, 0x0004f0000020d400ULL, 0x0000002800bd7306ULL, 0x000fe20000209400ULL,
0x00000018ff177819ULL, 0x004fc4000001142cULL, 0x000000999200720bULL, 0x002fca0003fdd000ULL,
0x0000002800ce7306ULL, 0x000ff00000205400ULL, 0x00000028009c7306ULL, 0x0003e2000020d400ULL,
0x00000001a2a26812ULL, 0x008fe400078efcffULL, 0x000000989700720bULL, 0x000fca0003fdd000ULL,
0x0000001f00e57306ULL, 0x000fe20000209400ULL, 0x000100002d287824ULL, 0x002fce00078e00ffULL,
0x0000001f00e87306ULL, 0x000e620000205400ULL, 0x00000001e4e46812ULL, 0x000fce00078efcffULL,
0x0000001f00a17306ULL, 0x0004f0000020d400ULL, 0x0000001600917306ULL, 0x000fe20000209400ULL,
0x000100002c1f7824ULL, 0x004fe200078e00ffULL, 0x000000e8e500720bULL, 0x002fcc0003f5d000ULL,
0x0000001600f27306ULL, 0x000e6e0000205400ULL, 0x00000001a1a12812ULL, 0x008fe200078efcffULL,
0x00000016009f7306ULL, 0x000eb0000020d400ULL, 0x00000013009e7306ULL, 0x000fe20000209400ULL,
0x000000f29100720bULL, 0x002fce0003f9d000ULL, 0x0000001300d17306ULL, 0x000fec0000205400ULL,
0x000000019f9f4812ULL, 0x004fe400078efcffULL, 0x0000001300b47306ULL, 0x000ff0000020d400ULL,
0x0000001700af7306ULL, 0x000ff00000209400ULL, 0x0000001700b07306ULL, 0x000ff00000205400ULL,
0x0000001700167306ULL, 0x000ff0000020d400ULL, 0x0000007400147306ULL, 0x000ff00000209400ULL,
0x0000007400137306ULL, 0x000ff00000205400ULL, 0x0000007400177306ULL, 0x0003f0000020d400ULL,
0x0000002900c97306ULL, 0x000fe20000209400ULL, 0x00000018ff747819ULL, 0x002fe20000011428ULL,
0x0000001072287824ULL, 0x000fcc00078e0271ULL, 0x0000002900d27306ULL, 0x000e700000205400ULL,
0x0000002900e77306ULL, 0x0004f0000020d400ULL, 0x0000002a00957306ULL, 0x000fe20000209400ULL,
0x00000018ff297819ULL, 0x004fc40000011469ULL, 0x000000d2c900720bULL, 0x002fca0003f9d000ULL,
0x0000002a00967306ULL, 0x000e700000205400ULL, 0x0000002a00e07306ULL, 0x000462000020d400ULL,
0x00000001e7e74812ULL, 0x008fce00078efcffULL, 0x0000002b00ef7306ULL, 0x000fe20000209400ULL,
0x00000018ff2a7819ULL, 0x004fe4000001146bULL, 0x000000969500720bULL, 0x002fca0003fdd000ULL,
0x0000002b00f07306ULL, 0x000e700000205400ULL, 0x0000002b00d97306ULL, 0x0004e2000020d400ULL,
0x00000001e0e06812ULL, 0x000fe400078efcffULL, 0x000000eed700720bULL, 0x000fca0003fdd000ULL,
0x0000002900da7306ULL, 0x000fe20000209400ULL, 0x00000018ff2b7819ULL, 0x004fe4000001141fULL,
0x000000f0ef00720bULL, 0x002fca0003fbd000ULL, 0x0000002900b77306ULL, 0x000fe20000205400ULL,
0x00000001d8d86812ULL, 0x000fce00078efcffULL, 0x00000029009b7306ULL, 0x000fe2000020d400ULL,
0x00000001d9d95812ULL, 0x008fce00078efcffULL, 0x0000002a00cf7306ULL, 0x000ff00000209400ULL,
0x0000002a00d07306ULL, 0x000ff00000205400ULL, 0x0000002a009d7306ULL, 0x000ff0000020d400ULL,
0x0000002b00b97306ULL, 0x000ff00000209400ULL, 0x0000002b00ba7306ULL, 0x000ff00000205400ULL,
0x0000002b008d7306ULL, 0x0003f0000020d400ULL, 0x0000002c00b67306ULL, 0x000fe20000009400ULL,
0x000000002828783bULL, 0x002e6e0000000200ULL, 0x0000002c00b57306ULL, 0x000ff00000005400ULL,
0x0000002c008a7306ULL, 0x0005f0000000d400ULL, 0x0000002d00ab7306ULL, 0x000fe20000009400ULL,
0x000001002c2c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000002d00a97306ULL, 0x000ff00000005400ULL, 0x0000002d001e7306ULL, 0x0005f0000000d400ULL,
0x0000002c00b37306ULL, 0x000fe20000209400ULL, 0x000001002d2d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000002c00b27306ULL, 0x000ff00000205400ULL,
0x0000002c001f7306ULL, 0x0005f0000020d400ULL, 0x0000002e00ad7306ULL, 0x000fe20000009400ULL,
0x000100002e2c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000002e00ac7306ULL, 0x000ff00000005400ULL, 0x0000002e001c7306ULL, 0x0005f0000000d400ULL,
0x0000002d00a77306ULL, 0x000fe20000209400ULL, 0x000001002e2e7824ULL, 0x004fca00078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000002d00a87306ULL, 0x000ff00000205400ULL,
0x0000002d00717306ULL, 0x0005f0000020d400ULL, 0x0000007000c67306ULL, 0x000fe20000209400ULL,
0x00000018ff2d7819ULL, 0x004fce0000011476ULL, 0x0000007000c77306ULL, 0x000eb00000205400ULL,
0x0000007000eb7306ULL, 0x000ef0000020d400ULL, 0x0000002c00907306ULL, 0x000fe20000209400ULL,
0x000000c7c600720bULL, 0x004fce0003f7d000ULL, 0x0000002c008f7306ULL, 0x000fec0000205400ULL,
0x00000001ebeb3812ULL, 0x008fe400078efcffULL, 0x0000002c00727306ULL, 0x0003e2000020d400ULL,
0x000000d19e00720bULL, 0x000fce0003f7d000ULL, 0x0000007400a47306ULL, 0x000fe20000209400ULL,
0x00000018ff2c7819ULL, 0x002fca0000011428ULL, 0x00000001b4b43812ULL, 0x000fe400078efcffULL,
0x0000007400a57306ULL, 0x000ff00000205400ULL, 0x0000007400707306ULL, 0x000ff0000020d400ULL,
0x0000002e00737306ULL, 0x000ff00000209400ULL, 0x0000002e00747306ULL, 0x000ff00000205400ULL,
0x0000002e00757306ULL, 0x0003f0000020d400ULL, 0x0000002d00767306ULL, 0x000fe20000209400ULL,
0x00000018ff2e7819ULL, 0x002fce0000011429ULL, 0x0000002d00777306ULL, 0x000ff00000205400ULL,
0x0000002d00787306ULL, 0x0003f0000020d400ULL, 0x0000002c007c7306ULL, 0x000fe20000209400ULL,
0x00000018ff2d7819ULL, 0x002fce000001142aULL, 0x0000002c007d7306ULL, 0x000ff00000205400ULL,
0x0000002c007e7306ULL, 0x0003f0000020d400ULL, 0x0000002e007f7306ULL, 0x000fe20000209400ULL,
0x00010000682c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000002e00807306ULL, 0x000ff00000205400ULL, 0x0000002e00817306ULL, 0x0003f0000020d400ULL,
0x0000002d00847306ULL, 0x000fe20000209400ULL, 0x000100006a2e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000002d00857306ULL, 0x000ff00000205400ULL,
0x0000002d00867306ULL, 0x0003f0000020d400ULL, 0x0000006900307306ULL, 0x000fe20000009400ULL,
0x00010000692d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000006900317306ULL, 0x000e700000005400ULL, 0x00000069009a7306ULL, 0x0004f0000000d400ULL,
0x0000002c00ec7306ULL, 0x000fe20000209400ULL, 0x0000010069697824ULL, 0x004fe200078e00ffULL,
0x000000313000720bULL, 0x002fcc0003f9d000ULL, 0x0000002c00ed7306ULL, 0x000e6e0000205400ULL,
0x000000019a9a4812ULL, 0x008fe200078efcffULL, 0x0000002c00c17306ULL, 0x0004e2000020d400ULL,
0x000000d0cf00720bULL, 0x000fce0003f9d000ULL, 0x0000002e00dd7306ULL, 0x000fe20000209400ULL,
0x00000018ff2c7819ULL, 0x004fe40000011469ULL, 0x000000edec00720bULL, 0x002fc60003fdd000ULL,
0x000000019d9d4812ULL, 0x000fe400078efcffULL, 0x0000002e00de7306ULL, 0x000e620000205400ULL,
0x000000acad00720bULL, 0x000fce0003f9d000ULL, 0x0000002e00b87306ULL, 0x000462000020d400ULL,
0x00000001c1c16812ULL, 0x008fca00078efcffULL, 0x000000011c1c4812ULL, 0x000fe400078efcffULL,
0x0000002c00db7306ULL, 0x000fe20000209400ULL, 0x00000004ff2e7819ULL, 0x004fe4000001160bULL,
0x000000dedd00720bULL, 0x002fc60003f5d000ULL, 0x0000000215c97824ULL, 0x040fe200078e022eULL,
0x0000000215157810ULL, 0x000fe20007ffe0ffULL, 0x0000002c00dc7306ULL, 0x000fe20000205400ULL,
0x00000010c42e7824ULL, 0x000fce00078e00ffULL, 0x0000002c00ca7306ULL, 0x0003e2000020d400ULL,
0x00000001b8b82812ULL, 0x000fce00078efcffULL, 0x0000002d00e17306ULL, 0x000fe20000209400ULL,
0x000100006b2c7824ULL, 0x002fca00078e00ffULL, 0x00000018fff17819ULL, 0x000fe2000001142cULL,
0x00000001c32c7824ULL, 0x040fe200078e02c9ULL, 0x0000002d00e27306ULL, 0x000e700000205400ULL,
0x0000002d00cd7306ULL, 0x0004f0000020d400ULL, 0x0000002f00aa7306ULL, 0x000fe20000009400ULL,
0x00000010c32d7824ULL, 0x004fe200078e00ffULL, 0x000000e2e100720bULL, 0x002fc80003fdd000ULL,
0xfffffff02d2c7812ULL, 0x000fe200078ee22cULL, 0x00000001c42d7824ULL, 0x000fe200078e02c9ULL,
0x0000002f00ae7306ULL, 0x000fe20000005400ULL, 0x00000002c9c97810ULL, 0x000fe40007ffe0ffULL,
0x000000102c307824ULL, 0x000fe200078e00ffULL, 0xfffffff02e2d7812ULL, 0x000fc600078ee22dULL,
0x00000001cdcd6812ULL, 0x008fe200078efcffULL, 0x0000002f001b7306ULL, 0x0003e2000000d400ULL,
0x000000102d2d7824ULL, 0x000fe200078e00ffULL, 0x000000cebd00720bULL, 0x000fe40003fdd000ULL,
0x0000009acd9a723eULL, 0x000fc800000010ffULL, 0x0000006800327306ULL, 0x000fe20000009400ULL,
0x000001002f2f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x0000006800337306ULL, 0x000e620000005400ULL, 0x000000019c9c6812ULL, 0x000fe400078efcffULL,
0x000000b0af00720bULL, 0x000fca0003fdd000ULL, 0x0000006800a07306ULL, 0x0004f0000000d400ULL,
0x0000002f00797306ULL, 0x000fe20000209400ULL, 0x0000010068687824ULL, 0x004fe200078e00ffULL,
0x000000333200720bULL, 0x002fc40003f3d000ULL, 0x000000003030783bULL, 0x000e620000000200ULL,
0x0000000116166812ULL, 0x000fe400078efcffULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x0000002f007a7306ULL, 0x000fe20000205400ULL, 0x0000008f9000720bULL, 0x000fcc0003fdd000ULL,
0x00000001a0a01812ULL, 0x008fe200078efcffULL, 0x0000002f007b7306ULL, 0x0005e2000020d400ULL,
0x000000b7da00720bULL, 0x000fe40003f3d000ULL, 0x000000a0c1a0723eULL, 0x000fc600000010ffULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x0000006800e97306ULL, 0x000fe20000209400ULL,
0x00000018ff2f7819ULL, 0x004fe4000001142bULL, 0x000000777600720bULL, 0x000fe40003fdd000ULL,
0x0000001c721c723eULL, 0x000fe400000010ffULL, 0x000000019b9b1812ULL, 0x000fe200078efcffULL,
0x0000006800ea7306ULL, 0x000eb00000205400ULL, 0x0000006800cc7306ULL, 0x000ee2000020d400ULL,
0x0000000178786812ULL, 0x000fce00078efcffULL, 0x0000006a00687306ULL, 0x000fe20000009400ULL,
0x000000eae900720bULL, 0x004fce0003fbd000ULL, 0x0000006a00697306ULL, 0x000eac0000005400ULL,
0x00000001cccc5812ULL, 0x008fe400078efcffULL, 0x0000002f00877306ULL, 0x000fe20000209400ULL,
0x000000dcdb00720bULL, 0x000fe40003fbd000ULL, 0x000000cca1a1723eULL, 0x000fca00000010ffULL,
0x0000002f00887306ULL, 0x000fe20000205400ULL, 0x000000696800720bULL, 0x004fe20003f1d000ULL,
0x000000a03044723cULL, 0x042fe20000041844ULL, 0x000000a3d668723eULL, 0x000fe400000010ffULL,
0x000000c89f69723eULL, 0x000fe400000010ffULL, 0x00000001caca5812ULL, 0x000fe200078efcffULL,
0x0000002f00897306ULL, 0x0003e6000020d400ULL, 0x000000ca9b9b723eULL, 0x000fe200000010ffULL,
0x000000683064723cULL, 0x040fe80000041864ULL, 0x0000006b00e37306ULL, 0x000fe20000009400ULL,
0x000000002d2c783bULL, 0x002e660000000200ULL, 0x0000009a3040723cULL, 0x000fe80000041840ULL,
0x0000006b00e67306ULL, 0x000eb00000005400ULL, 0x0000006b00c57306ULL, 0x000670000000d400ULL,
0x000000f100d17306ULL, 0x000fe20000209400ULL, 0x000001006b6b7824ULL, 0x008fe200078e00ffULL,
0x000000e6e300720bULL, 0x004fcc0003f7d000ULL, 0x000000f100d27306ULL, 0x000eae0000205400ULL,
0x00000001c5c53812ULL, 0x002fe200078efcffULL, 0x000000f100c67306ULL, 0x0003e2000020d400ULL,
0x000000a9ab00720bULL, 0x000fe20003f7d000ULL, 0x000000682c60723cULL, 0x040b6c0000041860ULL,
0x0000006a00cb7306ULL, 0x0006e2000000d400ULL, 0x00000018fff17819ULL, 0x002fe2000001146bULL,
0x000000a02c38723cULL, 0x000fe20000041838ULL, 0x000000d2d100720bULL, 0x004fc40003f3d000ULL,
0x000000dfe468723eULL, 0x020fe400000010ffULL, 0x000000e0b169723eULL, 0x000fe200000010ffULL,
0x000000f100d67306ULL, 0x000fe20000209400ULL, 0x000001006a6a7824ULL, 0x008fe200078e00ffULL,
0x000000e7a26b723eULL, 0x000fe200000010ffULL, 0x0000009a2c34723cULL, 0x000be20000041834ULL,
0x000000011e1e3812ULL, 0x000fe400078efcffULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x000000f100d77306ULL, 0x000e620000205400ULL, 0x00000001cbcb0812ULL, 0x000fe200078efcffULL,
0x000100002b9a7824ULL, 0x020fe200078e00ffULL, 0x000000bab900720bULL, 0x000fe20003f1d000ULL,
0x000000683054723cULL, 0x000fe20000041854ULL, 0x00000001c6c61812ULL, 0x000fc400078efcffULL,
0x000000b5b600720bULL, 0x000fe20003f3d000ULL, 0x0000006a00d47306ULL, 0x000fe20000209400ULL,
0x000000747300720bULL, 0x000fe40003f7d000ULL, 0x00000018ff9a7819ULL, 0x000fe2000001149aULL,
0x000000682c50723cULL, 0x000be80000041850ULL, 0x0000006a00d57306ULL, 0x000ea20000205400ULL,
0x000000d7d600720bULL, 0x002fc40003f5d000ULL, 0x0001000029687824ULL, 0x020fe200078e00ffULL,
0x000000018d8d0812ULL, 0x000fe400078efcffULL, 0x000000a5a400720bULL, 0x000fe40003f1d000ULL,
0x000000f100c87306ULL, 0x000e62000020d400ULL, 0x00000018ff697819ULL, 0x000fe20000011468ULL,
0x0000010029687824ULL, 0x000fe200078e00ffULL, 0x000000018a8a1812ULL, 0x000fe400078efcffULL,
0x0000000175753812ULL, 0x000fc400078efcffULL, 0x000000a8a700720bULL, 0x000fe20003f3d000ULL,
0x0000006a00c77306ULL, 0x000662000020d400ULL, 0x000000d5d400720bULL, 0x004fe40003fbd000ULL,
0x0000007a7900720bULL, 0x000fe40003f7d000ULL, 0x0000000170700812ULL, 0x000fe400078efcffULL,
0x000000191d00720bULL, 0x000fe20003f1d000ULL, 0x00000028008e7306ULL, 0x000fe20000009400ULL,
0x00010000286a7824ULL, 0x008fe200078e00ffULL, 0x00000001c8c82812ULL, 0x002fc400078efcffULL,
0x000000b2b300720bULL, 0x000fe40003f5d000ULL, 0x00000018ffee7819ULL, 0x000fe4000001146aULL,
0x0000002800937306ULL, 0x000e620000005400ULL, 0x000000a6eb6a723eULL, 0x000fe400000010ffULL,
0x00000001c7c75812ULL, 0x000fe400078efcffULL, 0x000000c89d9d723eULL, 0x000fe400000010ffULL,
0x000000aeaa00720bULL, 0x000fe20003fbd000ULL, 0x0000002800947306ULL, 0x0004e2000000d400ULL,
0x0000006a305c723cULL, 0x000fe2000004185cULL, 0x000000011f1f2812ULL, 0x000fc400078efcffULL,
0x0000008c8b00720bULL, 0x000fe40003f5d000ULL, 0x0000000171711812ULL, 0x000fe400078efcffULL,
0x0000002900917306ULL, 0x000fe20000009400ULL, 0x0000010028287824ULL, 0x004fe200078e00ffULL,
0x0000006a2c58723cULL, 0x000b620000041858ULL, 0x000000017b7b3812ULL, 0x000fe400078efcffULL,
0x000000011b1b5812ULL, 0x000fe400078efcffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000002900927306ULL, 0x000fe20000005400ULL, 0x000000d9b46b723eULL, 0x020fc400000010ffULL,
0x000000d3d86a723eULL, 0x000fe400000010ffULL, 0x0000000118182812ULL, 0x000fe400078efcffULL,
0x000000938e00720bULL, 0x002fe20003f5d000ULL, 0x0000002900997306ULL, 0x0003e2000000d400ULL,
0x000000131400720bULL, 0x000fe20003f3d000ULL, 0x0000006a304c723cULL, 0x000fe2000004184cULL,
0x0000007d7c00720bULL, 0x000fe40003fbd000ULL, 0x000000011a1a0812ULL, 0x000fc400078efcffULL,
0x0000001f168b723eULL, 0x000fe200000010ffULL, 0x0000002800b17306ULL, 0x000fe20000209400ULL,
0x000000c79c29723eULL, 0x002fe200000010ffULL, 0x0000006a2c48723cULL, 0x000b620000041848ULL,
0x000000c5c69c723eULL, 0x000fe400000010ffULL, 0x00000018ffc77819ULL, 0x000fe20000011468ULL,
0x00000001c3687824ULL, 0x140fe200078e02c9ULL, 0x0000000194942812ULL, 0x008fe200078efcffULL,
0x0000002800b77306ULL, 0x000e620000205400ULL, 0x00000010c36b7824ULL, 0x020fe200078e00ffULL,
0x0000009c306c723cULL, 0x000fe2000004186cULL, 0x00000001c4c97824ULL, 0x000fe200078e02c9ULL,
0x000000711871723eULL, 0x000fe200000010ffULL, 0x00000010c4c47824ULL, 0x000fe200078e00ffULL,
0xfffffff06b687812ULL, 0x000fc400078ee268ULL, 0x0000002800b47306ULL, 0x0004e2000020d400ULL,
0x000000751a1d723eULL, 0x000fe200000010ffULL, 0x0000009c2c24723cULL, 0x000fe20000041824ULL,
0xfffffff0c4c97812ULL, 0x000fe200078ee2c9ULL, 0x0000001068687824ULL, 0x000fe200078e00ffULL,
0x0000000117171812ULL, 0x000fe400078efcffULL, 0x000000017e7e5812ULL, 0x000fe200078efcffULL,
0x000000c700c37306ULL, 0x000fe20000209400ULL, 0x000000cbb828723eULL, 0x004fe400000010ffULL,
0x000000b7b100720bULL, 0x002fc40003f7d000ULL, 0x000000929100720bULL, 0x000fe40003f9d000ULL,
0x0000008a8d8a723eULL, 0x000fe200000010ffULL, 0x00000028303c723cULL, 0x080b62000004183cULL,
0x000000c700c67306ULL, 0x000e620000205400ULL, 0x0000001e7070723eULL, 0x000fe400000010ffULL,
0x0000001b7816723eULL, 0x000fe400000010ffULL, 0x0000007b1717723eULL, 0x000fe200000010ffULL,
0x000100002a317824ULL, 0x020fe200078e00ffULL, 0x000000282c20723cULL, 0x000b620000041820ULL,
0x0000002a00977306ULL, 0x000fe20000009400ULL, 0x00000010c9307824ULL, 0x000fe200078e00ffULL,
0x00000001b4b43812ULL, 0x008fc400078efcffULL, 0x00000018ffb57819ULL, 0x000fe40000011431ULL,
0x000000807f00720bULL, 0x000fe20003f7d000ULL, 0x000000003030783bULL, 0x000ea20000000200ULL,
0x0000002a00987306ULL, 0x000ee20000005400ULL, 0x000000c6c300720bULL, 0x002fe40003f5d000ULL,
0x0000000199994812ULL, 0x000fe400078efcffULL, 0x000000888700720bULL, 0x000fe40003f9d000ULL,
0x000000b47ea7723eULL, 0x000fe200000010ffULL, 0x0000002a00957306ULL, 0x0002e6000000d400ULL,
0x0000000181813812ULL, 0x000fca00078efcffULL, 0x000000ee00a37306ULL, 0x000fe20000209400ULL,
0x000001002a2a7824ULL, 0x002fe200078e00ffULL, 0x000000989700720bULL, 0x008fe40003f1d000ULL,
0x0000000189894812ULL, 0x000fe400078efcffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x000000ee00a27306ULL, 0x000e6e0000205400ULL, 0x0000000195950812ULL, 0x000fe200078efcffULL,
0x0000006900bd7306ULL, 0x000fe20000209400ULL, 0x000000081500780cULL, 0x000fe20003f05270ULL,
0x0000008a3060723cULL, 0x044b6c0000041860ULL, 0x0000006900c17306ULL, 0x000ea20000205400ULL,
0x000000a2a300720bULL, 0x002fe20003fdd000ULL, 0x000000703058723cULL, 0x040b6c0000041858ULL,
0x000000b500a07306ULL, 0x000fe40000209400ULL, 0x0000001c3050723cULL, 0x040b6c0000041850ULL,
0x000000b5009b7306ULL, 0x000e620000205400ULL, 0x000000c1bd00720bULL, 0x004fe20003f3d000ULL,
0x000000163048723cULL, 0x000b6c0000041848ULL, 0x0000002b00967306ULL, 0x000ff00000009400ULL,
0x0000002b009e7306ULL, 0x000fe20000005400ULL, 0x0000009ba000720bULL, 0x002fce0003fbd000ULL,
0x0000002b009f7306ULL, 0x0003f0000000d400ULL, 0x000000c700c47306ULL, 0x000ea2000020d400ULL,
0x000001002b2b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x0000002a001f7306ULL, 0x000ff00000209400ULL, 0x0000002a00147306ULL, 0x000e620000205400ULL,
0x00000001c4c42812ULL, 0x004fc800078efcffULL, 0x000000c48181723eULL, 0x000fc600000010ffULL,
0x000000ee00a67306ULL, 0x000eb0000020d400ULL, 0x0000006900b87306ULL, 0x0006a2000020d400ULL,
0x000000141f00720bULL, 0x002fce0003f5d000ULL, 0x000000b500287306ULL, 0x020e62000020d400ULL,
0x000000006868783bULL, 0x008ee20000000200ULL, 0x00000001a6a66812ULL, 0x004fe400078efcffULL,
0x0000009e9600720bULL, 0x000fe40003fdd000ULL, 0x00000094a6a6723eULL, 0x000fe400000010ffULL,
0x0000009a00137306ULL, 0x000fe20000209400ULL, 0x00000001b8b81812ULL, 0x000fe400078efcffULL,
0x000000858400720bULL, 0x000fc40003f3d000ULL, 0x00000099b880723eULL, 0x000fe200000010ffULL,
0x000000a63038723cULL, 0x040b640000041838ULL, 0x0000009a00187306ULL, 0x000ea20000205400ULL,
0x0000000128285812ULL, 0x002fe400078efcffULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x000000952828723eULL, 0x000fe200000010ffULL, 0x000000803034723cULL, 0x000b640000041834ULL,
0x0000002b00197306ULL, 0x000fe20000209400ULL, 0x0000000186861812ULL, 0x000fce00078efcffULL,
0x0000002b001a7306ULL, 0x000e620000205400ULL, 0x000000181300720bULL, 0x004fce0003f7d000ULL,
0x0000002a00297306ULL, 0x000ea2000020d400ULL, 0x0000008a6864723cULL, 0x048b6e0000041864ULL,
0x0000009a009a7306ULL, 0x000ee2000020d400ULL, 0x0000001a1900720bULL, 0x002fe20003fbd000ULL,
0x00000070685c723cULL, 0x040b6c000004185cULL, 0x0000002b00147306ULL, 0x000e62000020d400ULL,
0x0000000129292812ULL, 0x004fe200078efcffULL, 0x0000001c6854723cULL, 0x000b660000041854ULL,
0x000000298629723eULL, 0x000fc400000010ffULL, 0x000000019a9a3812ULL, 0x008fc600078efcffULL,
0x00000016684c723cULL, 0x000b62000004184cULL, 0x0000009f9a88723eULL, 0x000fe400000010ffULL,
0x0000000114145812ULL, 0x002fca00078efcffULL, 0x000000a66844723cULL, 0x000b620000041844ULL,
0x000000148989723eULL, 0x000fce00000010ffULL, 0x000000806840723cULL, 0x040b700000041840ULL,
0x00000028683c723cULL, 0x040b70000004183cULL, 0x00000088686c723cULL, 0x000b70000004186cULL,
0x000000283020723cULL, 0x040b700000041820ULL, 0x000000883024723cULL, 0x000b620000041824ULL,
0x0000001000008944ULL, 0x000fe20003c00000ULL, 0xffffdf5000007947ULL, 0x000fcc000383ffffULL,
0x0000000d4c4c7220ULL, 0x0a0fe40000410000ULL, 0x0000000d4d4d7220ULL, 0x000fc40000410000ULL,
0x0000000d4f4f7220ULL, 0x080fe40000410000ULL, 0x0000000d46467220ULL, 0x080fe40000410000ULL,
0x0000000d54547220ULL, 0x080fe40000410000ULL, 0x0000000d4e4e7220ULL, 0x080fe40000410000ULL,
0x0000000d44447220ULL, 0x080fe40000410000ULL, 0x0000000d45457220ULL, 0x000fc40000410000ULL,
0x0000000d40407220ULL, 0x080fe40000410000ULL, 0x0000000d41417220ULL, 0x080fe40000410000ULL,
0x0000000d43437220ULL, 0x080fe40000410000ULL, 0x0000000d3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000d3f3f7220ULL, 0x080fe40000410000ULL, 0x0000000d64647220ULL, 0x000fc40000410000ULL,
0x0000000d65657220ULL, 0x080fe40000410000ULL, 0x0000000d66667220ULL, 0x080fe40000410000ULL,
0x0000000d67677220ULL, 0x080fe40000410000ULL, 0x0000000d5c117220ULL, 0x080fe40000410000ULL,
0x0000000d5d137220ULL, 0x080fe40000410000ULL, 0x0000000d5e147220ULL, 0x000fc40000410000ULL,
0x0000000d5f157220ULL, 0x080fe40000410000ULL, 0x0000000d56167220ULL, 0x080fe40000410000ULL,
0x0000000d57177220ULL, 0x080fe40000410000ULL, 0x0000000d47187220ULL, 0x080fe40000410000ULL,
0x0000000d42427220ULL, 0x080fe40000410000ULL, 0x0000000d6d6d7220ULL, 0x000fc40000410000ULL,
0x0000000d6e6e7220ULL, 0x080fe40000410000ULL, 0x0000000d6f6f7220ULL, 0x080fe40000410000ULL,
0x0000000d60197220ULL, 0x080fe40000410000ULL, 0x0000000d611a7220ULL, 0x080fe40000410000ULL,
0x0000000d62327220ULL, 0x080fe40000410000ULL, 0x0000000d581b7220ULL, 0x000fc40000410000ULL,
0x0000000d591c7220ULL, 0x080fe40000410000ULL, 0x0000000d501d7220ULL, 0x080fe40000410000ULL,
0x0000000d511e7220ULL, 0x080fe40000410000ULL, 0x0000000d481f7220ULL, 0x080fe40000410000ULL,
0x0000000d49287220ULL, 0x080fe40000410000ULL, 0x0000000d34297220ULL, 0x000fc40000410000ULL,
0x0000000d352a7220ULL, 0x080fe40000410000ULL, 0x0000000d20207220ULL, 0x080fe40000410000ULL,
0x0000000d21217220ULL, 0x080fe40000410000ULL, 0x0000000d24247220ULL, 0x000fe40000410000ULL,
0x000000ffff627224ULL, 0x000fe400078e004cULL, 0x000000ffff607224ULL, 0x000fc400078e004dULL,
0x0000000d555f7220ULL, 0x080fe40000410000ULL, 0x0000000d3c577220ULL, 0x080fe40000410000ULL,
0x0000000d3d567220ULL, 0x080fe40000410000ULL, 0x0000000d63307220ULL, 0x080fe40000410000ULL,
0x0000000d5a317220ULL, 0x080fe40000410000ULL, 0x0000000d4b2b7220ULL, 0x000fc40000410000ULL,
0x000000ffff4d7224ULL, 0x000fe400078e004fULL, 0x000000ffff4c7224ULL, 0x000fe400078e0046ULL,
0x0000000d6c557220ULL, 0x080fe40000410000ULL, 0x0000000d5b337220ULL, 0x080fe40000410000ULL,
0x0000000d522f7220ULL, 0x080fe40000410000ULL, 0x0000000d532e7220ULL, 0x000fc40000410000ULL,
0x0000000d4a2d7220ULL, 0x080fe40000410000ULL, 0x0000000d383c7220ULL, 0x080fe40000410000ULL,
0x0000000d393d7220ULL, 0x080fe40000410000ULL, 0x0000000d3a2c7220ULL, 0x080fe40000410000ULL,
0x0000000d3b687220ULL, 0x080fe40000410000ULL, 0x0000000d36697220ULL, 0x000fc40000410000ULL,
0x0000000d376a7220ULL, 0x000fe40000410000ULL, 0x000000ffff637224ULL, 0x000fe400078e0054ULL,
0x000000ffff617224ULL, 0x000fe400078e0044ULL, 0x000000ffff5a7224ULL, 0x000fe400078e0045ULL,
0x000000ffff597224ULL, 0x000fe400078e0040ULL, 0x000000ffff587224ULL, 0x000fc400078e0041ULL,
0x000000ffff4b7224ULL, 0x000fe400078e004eULL, 0x000000ffff507224ULL, 0x000fe400078e0043ULL,
0x000000ffff4f7224ULL, 0x000fe400078e003eULL, 0x000000ffff467224ULL, 0x000fe400078e003fULL,
0x0000000d22227220ULL, 0x080fe40000410000ULL, 0x0000000d23237220ULL, 0x000fc40000410000ULL,
0x0000000d25257220ULL, 0x080fe40000410000ULL, 0x0000000d266b7220ULL, 0x080fe40000410000ULL,
0x0000000d276c7220ULL, 0x000fe40000410000ULL, 0x000000ffff5d7224ULL, 0x000fe400078e0064ULL,
0x000000ffff5c7224ULL, 0x000fe400078e0065ULL, 0x000000ffff5e7224ULL, 0x000fc400078e0011ULL,
0x000000ffff5b7224ULL, 0x000fe400078e0013ULL, 0x000000ffff547224ULL, 0x000fe400078e006dULL,
0x000000ffff487224ULL, 0x000fe400078e0066ULL, 0x000000ffff537224ULL, 0x000fe400078e0067ULL,
0x000000ffff477224ULL, 0x000fe400078e0014ULL, 0x000000ffff4a7224ULL, 0x000fc400078e0015ULL,
0x000000ffff497224ULL, 0x000fe400078e0016ULL, 0x000000ffff517224ULL, 0x000fe400078e0017ULL,
0x000000ffff527224ULL, 0x000fe400078e0018ULL, 0x000000ffff4e7224ULL, 0x000fe400078e0042ULL,
0x000000ffff457224ULL, 0x000fe400078e006eULL, 0x000000ffff447224ULL, 0x000fc400078e006fULL,
0x000000ffff357224ULL, 0x000fe400078e0019ULL, 0x000000ffff347224ULL, 0x000fe400078e001aULL,
0x000000ffff367224ULL, 0x000fe400078e001bULL, 0x000000ffff377224ULL, 0x000fe400078e001cULL,
0x000000ffff387224ULL, 0x000fe400078e001dULL, 0x000000ffff397224ULL, 0x000fc400078e001eULL,
0x000000ffff3a7224ULL, 0x000fe400078e001fULL, 0x000000ffff3b7224ULL, 0x000fe400078e0028ULL,
0x000000ffff3e7224ULL, 0x000fe400078e0029ULL, 0x000000ffff3f7224ULL, 0x000fe400078e002aULL,
0x000000ffff437224ULL, 0x000fe400078e0020ULL, 0x000000ffff407224ULL, 0x000fc400078e0021ULL,
0x000000ffff417224ULL, 0x000fe200078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000bb187f8cULL, 0x0002a2000c80043fULL, 0x000000ffff427224ULL, 0x000fe400078e0025ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0068ULL, 0x000000ffff247224ULL, 0x000fe400078e0069ULL,
0x000000ffff257224ULL, 0x000fe400078e006aULL, 0x000000ffff267224ULL, 0x000fc400078e0022ULL,
0x000000ffff277224ULL, 0x000fe400078e0023ULL, 0x000000ffff287224ULL, 0x000fe400078e006bULL,
0x000000ffff297224ULL, 0x000fc400078e006cULL, 0x0000000000147805ULL, 0x002fca0000015200ULL,
0x00000400bb117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x006fe40007804819ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614167210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff117819ULL, 0x000fc80000011417ULL,
0x0000001611117211ULL, 0x000fca00078110ffULL, 0x000000ffff167224ULL, 0x000fca00000e0617ULL,
0x0000000211117819ULL, 0x000fc80000001216ULL, 0x000000110000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000113137810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400bb117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000040b137824ULL, 0x000fe200078e00ffULL, 0x0000000a1000720cULL, 0x000fc80003f06070ULL,
0xfffffff013117812ULL, 0x000fca00078ec0ffULL, 0x0000008002117824ULL, 0x000fca00078e0211ULL,
0x01a4000011147984ULL, 0x0002a20000000c00ULL, 0x000021f000008947ULL, 0x000fea0003800000ULL,
0x00005a00001b7b06ULL, 0x000ee20000209000ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x000000030b1a7211ULL, 0x040fe200078ff0ffULL, 0x000000020b657824ULL, 0x000fc600078e00ffULL,
0x000000101a1e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000665657812ULL, 0x000fca00078ec0ffULL,
0x0000000165677824ULL, 0x000fe200078e0200ULL, 0x0000001b001b7308ULL, 0x008ee40000001000ULL,
0x0ffffffe1b1d7810ULL, 0x008fcc0007ffe0ffULL, 0x0000001d00197305ULL, 0x000ee4000021f000ULL,
0x000000ffff1f7224ULL, 0x008fc800078e0a19ULL, 0x00005a001f1f7a24ULL, 0x000fc800078e02ffULL,
0x0000001f19217227ULL, 0x000fe200078e0018ULL, 0x000000081a197810ULL, 0x000fca0007ffe0ffULL,
0x0000001a21187227ULL, 0x000fc800078e00ffULL, 0x00000019211c7227ULL, 0x000fc800078e00ffULL,
0x000000ffff1b7224ULL, 0x000fe400078e0a18ULL, 0x000000ffff207224ULL, 0x000fe400078e0a1cULL,
0x00005a001b1b7a24ULL, 0x000fe200078e021aULL, 0x000000181a1a7810ULL, 0x000fe20007ffe0ffULL,
0x00005a00201d7a24ULL, 0x000fe400078e0219ULL, 0x0000001e211f7227ULL, 0x000fe200078e00ffULL,
0x00005a001b007a0cULL, 0x000fe40003f06070ULL, 0x00005a001d007a0cULL, 0x000fe20003fa6070ULL,
0x000000ffff197224ULL, 0x000fc400078e0a1fULL, 0x0000001a21207227ULL, 0x000fc800078e00ffULL,
0x00005a00191e7a24ULL, 0x000fe400078e021eULL, 0x000000ffff217224ULL, 0x000fe400078e0a20ULL,
0x80005a001b1b0a10ULL, 0x000fe20007ffe0ffULL, 0x0000010010197824ULL, 0x000fe200078e02bcULL,
0x00005a001e007a0cULL, 0x000fe20003f26070ULL, 0x00005a00211a7a24ULL, 0x000fe200078e021aULL,
0x80005a001d1d5a10ULL, 0x000fe40007ffe0ffULL, 0x00005a001b007a0cULL, 0x000fe20003f46070ULL,
0x000000010f1b7824ULL, 0x000fe200078e0265ULL, 0x00005a001a007a0cULL, 0x000fc40003f66070ULL,
0x0000001904647217ULL, 0x000fe40007800000ULL, 0x00005a001d007a0cULL, 0x000fe40003fc6070ULL,
0x0000000118180810ULL, 0x000fe20007ffe0ffULL, 0x0000000164647824ULL, 0x000fe200078e0a19ULL,
0x80005a001e1e1a10ULL, 0x000fe40007ffe0ffULL, 0x000000011c1c5810ULL, 0x000fe20007ffe0ffULL,
0x0000000167197824ULL, 0x000fe200078e0a64ULL, 0x00005a001e007a0cULL, 0x000fc40003f86070ULL,
0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL, 0x00005a00ff217a12ULL, 0x000fe400078e33ffULL,
0x000000641b00720cULL, 0x040fe20003f06070ULL, 0x000000011b1b7824ULL, 0x000fe200078e0a64ULL,
0x80005a001a1a3a10ULL, 0x000fe40007ffe0ffULL, 0x0000000118182810ULL, 0x000fe40007ffe0ffULL,
0x000000011c1c6810ULL, 0x000fc40007ffe0ffULL, 0x000000190e747217ULL, 0x000fe40003800000ULL,
0x00005a001a007a0cULL, 0x000fe40003f46070ULL, 0x0000001821197207ULL, 0x040fe40006800000ULL,
0x0000001b0e1b7217ULL, 0x040fe40003800000ULL, 0x0000001c211d7207ULL, 0x000fe40006800000ULL,
0x000000190e197217ULL, 0x000fc40003800000ULL, 0x000000011f1f1810ULL, 0x000fe40007ffe0ffULL,
0x000000646700720cULL, 0x000fe20003fc6070ULL, 0x000000190c8d7224ULL, 0x000fe200078e02ffULL,
0x00000004ff1b7819ULL, 0x000fe4000001161bULL, 0x0000001d0e1d7217ULL, 0x000fe40003800000ULL,
0x0000000120203810ULL, 0x000fe40007ffe0ffULL, 0x000000011f1f4810ULL, 0x000fe20007ffe0ffULL,
0x0000001d0c917224ULL, 0x000fe200078e02ffULL, 0x000000ff74747207ULL, 0x000fc40003000000ULL,
0x000000ff1b1c7207ULL, 0x000fe40000000000ULL, 0x0000000120202810ULL, 0x000fe40007ffe0ffULL,
0x0000001f211d7207ULL, 0x000fe20006800000ULL, 0x000000018d1b7824ULL, 0x000fe200078e021cULL,
0x0000008d74197211ULL, 0x000fe200078fe0ffULL, 0x000000011c1f7824ULL, 0x000fe200078e0291ULL,
0x0000002021217207ULL, 0x000fe20006800000ULL, 0x000000021b1a7825ULL, 0x000fe200078e0082ULL,
0x0000001d0e1d7217ULL, 0x000fc40003800000ULL, 0x000000210e217217ULL, 0x000fe20003800000ULL,
0x0000000219187825ULL, 0x100fe200078e0082ULL, 0x0000001065717812ULL, 0x000fe200078efcffULL,
0x000000061a667981ULL, 0x0046a4000c1e9500ULL, 0x0000001d0c937224ULL, 0x000fe400078e02ffULL,
0x0000000618697981ULL, 0x0002a2000c1e9500ULL, 0x000000021f1e7825ULL, 0x000fe200078e0082ULL,
0x00000091741d7211ULL, 0x040fe400078fe0ffULL, 0x0000009374237211ULL, 0x000fe200078fe0ffULL,
0x000000210c957224ULL, 0x000fe200078e02ffULL, 0x000000061e687981ULL, 0x0002a2000c1e9500ULL,
0x000000011c217824ULL, 0x000fc400078e0293ULL, 0x000000010f757824ULL, 0x000fe200078e0271ULL,
0x00000095746b7211ULL, 0x000fe200078fe0ffULL, 0x000000011c6d7824ULL, 0x000fe400078e0295ULL,
0x000000021d1c7825ULL, 0x000fc800078e0082ULL, 0x0000000221207825ULL, 0x000fc800078e0082ULL,
0x00000002231a7825ULL, 0x008fe200078e0082ULL, 0x00000006206a7981ULL, 0x0006a6000c1e9500ULL,
0x00000001751f7824ULL, 0x002fe400078e0a64ULL, 0x00000001716f7824ULL, 0x000fe400078e0200ULL,
0x000000026d227825ULL, 0x100fe200078e0082ULL, 0x0000001f0e1e7217ULL, 0x000fe20003800000ULL,
0x000000061a6d7981ULL, 0x0002a4000c1e9500ULL, 0x000000026b187825ULL, 0x000fc400078e0082ULL,
0x000000061c6b7981ULL, 0x0002a4000c1e9500ULL, 0x000000016f1f7824ULL, 0x000fe200078e0a64ULL,
0x000000647500720cULL, 0x080fe20003f26070ULL, 0x00000006226c7981ULL, 0x0006a2000c1e9500ULL,
0x00000004ff1e7819ULL, 0x000fe4000001161eULL, 0x000000646f00720cULL, 0x000fe20003f06070ULL,
0x0000000618737981ULL, 0x0006a2000c1e9500ULL, 0x0000001f0e1f7217ULL, 0x000fe40003800000ULL,
0x000000ff1e1c7207ULL, 0x002fc40000800000ULL, 0x000000ff1f7c7207ULL, 0x000fe40000000000ULL,
0x00000020657b7812ULL, 0x000fe200078efcffULL, 0x000000011c1f7824ULL, 0x000fe200078e0291ULL,
0x0000008d7c197211ULL, 0x048fe200078fe0ffULL, 0x000000018d1b7824ULL, 0x000fe200078e021cULL,
0x000000917c1d7211ULL, 0x040fe200078fe0ffULL, 0x000000021f1e7825ULL, 0x000fe200078e0082ULL,
0x000000957c777211ULL, 0x000fc600078fe0ffULL, 0x0000000219187825ULL, 0x000fe200078e0082ULL,
0x000000061e707981ULL, 0x0002e6000c1e9500ULL, 0x000000010f817824ULL, 0x000fe200078e027bULL,
0x0000000618757981ULL, 0x0002e2000c1e9500ULL, 0x000000011c237824ULL, 0x040fe400078e0293ULL,
0x000000011c797824ULL, 0x000fe400078e0295ULL, 0x000000021b1a7825ULL, 0x000fc800078e0082ULL,
0x000000021d1c7825ULL, 0x000fe200078e0082ULL, 0x000000061a6e7981ULL, 0x0002e6000c1e9500ULL,
0x00000001811f7824ULL, 0x002fe400078e0a64ULL, 0x0000000277187825ULL, 0x000fe400078e0082ULL,
0x000000061c777981ULL, 0x0002e4000c1e9500ULL, 0x000000017b7d7824ULL, 0x000fe200078e0200ULL,
0x0000001f0e1e7217ULL, 0x000fc40003800000ULL, 0x000000937c217211ULL, 0x000fe200078fe0ffULL,
0x000000017d1f7824ULL, 0x000fe200078e0a64ULL, 0x000000648100720cULL, 0x080fe20003f26070ULL,
0x0000000223227825ULL, 0x000fe200078e0082ULL, 0x00000004ff1e7819ULL, 0x000fe2000001161eULL,
0x00000006187f7981ULL, 0x0002e2000c1e9500ULL, 0x000000647d00720cULL, 0x000fe20003f06070ULL,
0x0000000221207825ULL, 0x100fe200078e0082ULL, 0x0000001f0e1f7217ULL, 0x000fe20003800000ULL,
0x0000000622727981ULL, 0x0002e4000c1e9500ULL, 0x00000002791a7825ULL, 0x000fe200078e0082ULL,
0x000000ff1e1e7207ULL, 0x000fe20000800000ULL, 0x0000000620797981ULL, 0x0002e2000c1e9500ULL,
0x000000ff1f847207ULL, 0x000fc60000000000ULL, 0x000000061a767981ULL, 0x0002e4000c1e9500ULL,
0x000000011e237824ULL, 0x002fe200078e0291ULL, 0x0000009184217211ULL, 0x040fe200078fe0ffULL,
0x000000018d1b7824ULL, 0x000fe200078e021eULL, 0x0000009584857211ULL, 0x000fe200078fe0ffULL,
0x0000000223227825ULL, 0x000fc800078e0082ULL, 0x000000021b1a7825ULL, 0x100fe200078e0082ULL,
0x00000006227a7981ULL, 0x0002e6000c1e9500ULL, 0x0000000221207825ULL, 0x000fe200078e0082ULL,
0x000000061a787981ULL, 0x0002e2000c1e9500ULL, 0x0000008d84817211ULL, 0x000fe400078fe0ffULL,
0x0000003065877812ULL, 0x000fe200078efcffULL, 0x000000011e1f7824ULL, 0x000fe200078e0293ULL,
0x0000009384197211ULL, 0x000fe200078fe0ffULL, 0x00000002851a7825ULL, 0x002fc400078e0082ULL,
0x0000000620857981ULL, 0x0002e4000c1e9500ULL, 0x000000011e1d7824ULL, 0x000fe400078e0295ULL,
0x0000000281807825ULL, 0x000fe200078e0082ULL, 0x000000061adb7981ULL, 0x0002e6000c1e9500ULL,
0x000000010f8f7824ULL, 0x000fe400078e0287ULL, 0x000000021f1e7825ULL, 0x100fe200078e0082ULL,
0x0000000680817981ULL, 0x0002e6000c1e9500ULL, 0x0000000219187825ULL, 0x100fe200078e0082ULL,
0x000000061e7e7981ULL, 0x0002e6000c1e9500ULL, 0x000000021d1c7825ULL, 0x000fe200078e0082ULL,
0x00000006188b7981ULL, 0x0002e6000c1e9500ULL, 0x000000018f237824ULL, 0x000fe200078e0a64ULL,
0x000000061c807981ULL, 0x0022e2000c1e9500ULL, 0x0000000187897824ULL, 0x000fc600078e0200ULL,
0x000000230e227217ULL, 0x040fe20003800000ULL, 0x0000000189237824ULL, 0x000fe200078e0a64ULL,
0x000000648f00720cULL, 0x080fe40003f26070ULL, 0x000000648900720cULL, 0x000fe40003f06070ULL,
0x00000004ff227819ULL, 0x000fe40000011622ULL, 0x000000230e237217ULL, 0x000fe40003800000ULL,
0x000000ff22887207ULL, 0x000fc40000800000ULL, 0x000000ff23867207ULL, 0x000fc60000000000ULL,
0x000000018d217824ULL, 0x000fe200078e0288ULL, 0x0000008d86237211ULL, 0x000fe200078fe0ffULL,
0x00000001881d7824ULL, 0x002fe200078e0293ULL, 0x00000093861f7211ULL, 0x000fe200078fe0ffULL,
0x0000000221207825ULL, 0x000fc800078e0082ULL, 0x0000000223227825ULL, 0x100fe200078e0082ULL,
0x00000006208a7981ULL, 0x0002e6000c1e9500ULL, 0x000000021d1c7825ULL, 0x100fe200078e0082ULL,
0x0000000622c17981ULL, 0x0002e6000c1e9500ULL, 0x000000021f1e7825ULL, 0x000fe200078e0082ULL,
0x000000061c907981ULL, 0x0002e2000c1e9500ULL, 0x00000091861b7211ULL, 0x000fc600078fe0ffULL,
0x000000061ed97981ULL, 0x0002e2000c1e9500ULL, 0x0000000188197824ULL, 0x000fe400078e0291ULL,
0x000000021b1a7825ULL, 0x000fc800078e0082ULL, 0x0000000219187825ULL, 0x000fe200078e0082ULL,
0x000000061ad77981ULL, 0x0002e4000c1e9500ULL, 0x0000009586217211ULL, 0x002fe400078fe0ffULL,
0x00000006188e7981ULL, 0x0002e2000c1e9500ULL, 0x0000000188237824ULL, 0x000fe400078e0295ULL,
0x0000000221207825ULL, 0x000fc800078e0082ULL, 0x0000000223227825ULL, 0x000fe200078e0082ULL,
0x0000000620dd7981ULL, 0x0002e8000c1e9500ULL, 0x0000000622927981ULL, 0x0002e4000c1e9500ULL,
0xfffffff074197812ULL, 0x002fe200078ec0ffULL, 0x00000001ffd57424ULL, 0x000fc800078e00ffULL,
0x0000000164187824ULL, 0x000fc800078e0219ULL, 0x0000000167197824ULL, 0x000fe200078e0a18ULL,
0x00000001658d7812ULL, 0x000fc800078efcffULL, 0x00000019d5197219ULL, 0x000fe200000006ffULL,
0x000000018d1b7824ULL, 0x000fe200078e0200ULL, 0xfffffff07c1d7812ULL, 0x000fc600078ec0ffULL,
0x000000011b1a7824ULL, 0x000fe200078e0a18ULL, 0x00000008658f7812ULL, 0x040fe200078efcffULL,
0x00000001641e7824ULL, 0x000fe200078e021dULL, 0x0000000965917812ULL, 0x000fe400078efcffULL,
0x0000001ad51d7219ULL, 0x000fe200000006ffULL, 0x000000018f1f7824ULL, 0x100fe400078e0200ULL,
0x0000000191237824ULL, 0x000fe200078e0200ULL, 0xfffffff084217812ULL, 0x000fe200078ec0ffULL,
0x000000011f1c7824ULL, 0x100fe200078e0a18ULL, 0xfffffff086937812ULL, 0x000fe200078ec0ffULL,
0x0000000123187824ULL, 0x000fe200078e0a18ULL, 0x0000001165977812ULL, 0x000fe200078efcffULL,
0x0000000164207824ULL, 0x040fe200078e0221ULL, 0x0000001cd5217219ULL, 0x040fe200000006ffULL,
0x0000000164847824ULL, 0x000fe200078e0293ULL, 0x00000018d5937219ULL, 0x000fe200000006ffULL,
0x0000000197997824ULL, 0x000fc400078e0200ULL, 0x000000016f187824ULL, 0x100fe400078e0a1eULL,
0x00000001991a7824ULL, 0x000fe200078e0a1eULL, 0x0000541069667816ULL, 0x004fc80000000066ULL,
0x0000006619ff7212ULL, 0x000fc800078ac0ffULL, 0x000000646700720cULL, 0x000fc80002fa1470ULL,
0x000000646500720cULL, 0x000fe40002fa1070ULL, 0x000000661dff7212ULL, 0x000fe4000782c0ffULL,
0xff8000005d5d7808ULL, 0x000fe40002800000ULL, 0x000000641b00720cULL, 0x000fe40000f21470ULL,
0x000054106d6a7816ULL, 0x000fe4000000006aULL, 0x000054106b687816ULL, 0x000fc40000000068ULL,
0x0000006a19ff7212ULL, 0x040fe4000788c0ffULL, 0x0000006819ff7212ULL, 0x080fe4000784c0ffULL,
0x000000681dff7212ULL, 0x000fe400078ac0ffULL, 0x000000646700720cULL, 0x0c0fe40001741470ULL,
0x000000646700720cULL, 0x080fe40002781470ULL, 0x000000641b00720cULL, 0x000fc40002fa1470ULL,
0x000000646500720cULL, 0x0c0fe40001741070ULL, 0x000000646500720cULL, 0x080fe40002781070ULL,
0x000000648d00720cULL, 0x0c0fe40000f21070ULL, 0x000000648d00720cULL, 0x000fe40002fa1070ULL,
0x00005410736c7816ULL, 0x000fe4000000006cULL, 0xff80000048487808ULL, 0x000fc40001000000ULL,
0xff80000035357808ULL, 0x000fe40002000000ULL, 0xff8000005c5c7808ULL, 0x000fe40000800000ULL,
0xff80000053537808ULL, 0x000fe40002800000ULL, 0x0000006621ff7212ULL, 0x000fe4000786c0ffULL,
0x0000006c19ff7212ULL, 0x000fe4000780c0ffULL, 0x0000006a1dff7212ULL, 0x000fc4000784c0ffULL,
0x0000006c1dff7212ULL, 0x000fe4000788c0ffULL, 0x0000006893ff7212ULL, 0x000fe4000782c0ffULL,
0x0000006a21ff7212ULL, 0x000fe400078ac0ffULL, 0x000000646700720cULL, 0x080fe40000701470ULL,
0x000000641b00720cULL, 0x0c0fe40001741470ULL, 0x000000641b00720cULL, 0x000fc40002781470ULL,
0x000000641f00720cULL, 0x0c0fe40001f61470ULL, 0x000000641f00720cULL, 0x080fe40002fa1470ULL,
0x000000642300720cULL, 0x080fe40000f21470ULL, 0x00000018659d7812ULL, 0x040fe400078efcffULL,
0x0000001965a37812ULL, 0x040fe400078efcffULL, 0x000000646500720cULL, 0x000fc40000701070ULL,
0x000000648d00720cULL, 0x0c0fe40001741070ULL, 0x000000648d00720cULL, 0x080fe40002781070ULL,
0x000000648f00720cULL, 0x0c0fe40001f61070ULL, 0x000000648f00720cULL, 0x080fe40002fa1070ULL,
0x000000649100720cULL, 0x000fe40000f21070ULL, 0x00000018d5957219ULL, 0x000fc400000006ffULL,
0x0000001ad59b7219ULL, 0x000fe400000006ffULL, 0x00005410756e7816ULL, 0x008fe4000000006eULL,
0x0000541077707816ULL, 0x000fe20000000070ULL, 0x000000019d9f7824ULL, 0x100fe200078e0200ULL,
0xff80000032327808ULL, 0x000fe20000000000ULL, 0x00000001a3a57824ULL, 0x000fe200078e0200ULL,
0xff80000034347808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fc40002000000ULL,
0xff8000005e5e7808ULL, 0x000fe40001800000ULL, 0xff80000036367808ULL, 0x000fe40002800000ULL,
0xff8000004a4a7808ULL, 0x000fe40000800000ULL, 0x0000006821ff7212ULL, 0x000fe4000780c0ffULL,
0x0000006a93ff7212ULL, 0x000fe4000784c0ffULL, 0x0000006c21ff7212ULL, 0x000fc4000788c0ffULL,
0x0000006c93ff7212ULL, 0x000fe4000786c0ffULL, 0x0000006e9bff7212ULL, 0x000fe400078ac0ffULL,
0x0000007095ff7212ULL, 0x000fe2000782c0ffULL, 0x000000019f1c7824ULL, 0x100fe200078e0a1eULL,
0x000000641f00720cULL, 0x080fe20000701470ULL, 0x00000001a51e7824ULL, 0x000fe200078e0a1eULL,
0x000000641f00720cULL, 0x080fe40002781470ULL, 0x000000642300720cULL, 0x000fc40001741470ULL,
0x000000642300720cULL, 0x080fe40001f61470ULL, 0x000000646f00720cULL, 0x080fe40000f21470ULL,
0x000000649900720cULL, 0x080fe40002fa1470ULL, 0x000000648f00720cULL, 0x0c0fe40000701070ULL,
0x000000648f00720cULL, 0x080fe40002781070ULL, 0x000000649100720cULL, 0x000fc40001741070ULL,
0x000000649100720cULL, 0x080fe40001f61070ULL, 0x000000647100720cULL, 0x080fe40000f21070ULL,
0x000000649700720cULL, 0x000fe40002fa1070ULL, 0x0000001cd5a17219ULL, 0x040fe400000006ffULL,
0x0000001ed5a77219ULL, 0x000fe400000006ffULL, 0x0000541079727816ULL, 0x000fc40000000072ULL,
0x000054107f767816ULL, 0x000fe40000000076ULL, 0xff80000047477808ULL, 0x000fe40000000000ULL,
0xff80000031317808ULL, 0x000fe40002000000ULL, 0xff80000037377808ULL, 0x000fe40001000000ULL,
0xff80000033337808ULL, 0x000fe40001800000ULL, 0xff80000049497808ULL, 0x000fc40000800000ULL,
0xff8000005f5f7808ULL, 0x000fe40002800000ULL, 0x0000006e95ff7212ULL, 0x080fe4000780c0ffULL,
0x0000006ea1ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007295ff7212ULL, 0x040fe4000784c0ffULL,
0x0000007695ff7212ULL, 0x000fe4000786c0ffULL, 0x000000729bff7212ULL, 0x000fc4000782c0ffULL,
0x00000070a7ff7212ULL, 0x000fe200078ac0ffULL, 0x000000017d227824ULL, 0x000fe200078e0a20ULL,
0x000000646f00720cULL, 0x0c0fe40000701470ULL, 0x000000646f00720cULL, 0x0c0fe40001741470ULL,
0x000000646f00720cULL, 0x080fe40001f61470ULL, 0x000000649900720cULL, 0x080fe40000f21470ULL,
0x000000649f00720cULL, 0x000fc40002781470ULL, 0x00000064a500720cULL, 0x080fe40002fa1470ULL,
0x0000002165ab7812ULL, 0x000fe400078efcffULL, 0x000000647100720cULL, 0x0c0fe40000701070ULL,
0x000000647100720cULL, 0x0c0fe40001741070ULL, 0x000000647100720cULL, 0x080fe40001f61070ULL,
0x000000649700720cULL, 0x000fc40000f21070ULL, 0x000000649d00720cULL, 0x080fe40002781070ULL,
0x00000064a300720cULL, 0x000fe40002fa1070ULL, 0x00000022d5a97219ULL, 0x000fe400000006ffULL,
0x00005410857a7816ULL, 0x000fe2000000007aULL, 0x00000001abad7824ULL, 0x000fe200078e0200ULL,
0xff80000063637808ULL, 0x000fe40000000000ULL, 0xff80000038387808ULL, 0x000fc40001000000ULL,
0xff8000002f2f7808ULL, 0x000fe40001800000ULL, 0xff80000039397808ULL, 0x000fe40000800000ULL,
0xff80000062627808ULL, 0x000fe40002000000ULL, 0xff8000004d4d7808ULL, 0x000fe40002800000ULL,
0x000000709bff7212ULL, 0x040fe4000780c0ffULL, 0x000000769bff7212ULL, 0x000fc4000784c0ffULL,
0x00000070a1ff7212ULL, 0x000fe4000786c0ffULL, 0x00000072a7ff7212ULL, 0x040fe4000782c0ffULL,
0x00000076a7ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007aa9ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001ad747824ULL, 0x000fe200078e0a20ULL, 0x000000649900720cULL, 0x0c0fe40000701470ULL,
0x000000649900720cULL, 0x000fc40001741470ULL, 0x000000649f00720cULL, 0x080fe40001f61470ULL,
0x00000064a500720cULL, 0x0c0fe40000f21470ULL, 0x00000064a500720cULL, 0x080fe40002781470ULL,
0x000000647d00720cULL, 0x000fe40002fa1470ULL, 0x0000002865b17812ULL, 0x040fe400078efcffULL,
0x0000002965b77812ULL, 0x000fc400078efcffULL, 0x000000649700720cULL, 0x0c0fe40000701070ULL,
0x000000649700720cULL, 0x080fe40001741070ULL, 0x000000649d00720cULL, 0x080fe40001f61070ULL,
0x00000064a300720cULL, 0x0c0fe40000f21070ULL, 0x00000064a300720cULL, 0x080fe40002781070ULL,
0x000000647b00720cULL, 0x000fc40002fa1070ULL, 0x00000074d5af7219ULL, 0x000fe400000006ffULL,
0x0000541081787816ULL, 0x000fe40000000078ULL, 0x000054108b7e7816ULL, 0x000fe4000000007eULL,
0x00005410db807816ULL, 0x000fe20000000080ULL, 0x00000001b1b37824ULL, 0x100fe200078e0200ULL,
0xff80000051517808ULL, 0x000fe20000000000ULL, 0x00000001b7b97824ULL, 0x000fe200078e0200ULL,
0xff8000002e2e7808ULL, 0x000fc40001000000ULL, 0xff8000004b4b7808ULL, 0x000fe40001800000ULL,
0xff8000003b3b7808ULL, 0x000fe40000800000ULL, 0xff8000002b2b7808ULL, 0x000fe40002000000ULL,
0xff8000004c4c7808ULL, 0x000fe40002800000ULL, 0x0000006693ff7212ULL, 0x000fe400078cc0ffULL,
0x00000072a1ff7212ULL, 0x000fc4000780c0ffULL, 0x00000076a1ff7212ULL, 0x000fe4000784c0ffULL,
0x00000078a9ff7212ULL, 0x040fe4000786c0ffULL, 0x0000007ea9ff7212ULL, 0x040fe4000782c0ffULL,
0x00000080a9ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007eafff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b37c7824ULL, 0x100fe200078e0a20ULL, 0x000000642300720cULL, 0x080fe200037c1470ULL,
0x00000001b9207824ULL, 0x000fe200078e0a20ULL, 0x000000649f00720cULL, 0x000fc40000701470ULL,
0x000000649f00720cULL, 0x080fe40001741470ULL, 0x000000647d00720cULL, 0x0c0fe40001f61470ULL,
0x000000647d00720cULL, 0x0c0fe40000f21470ULL, 0x000000647d00720cULL, 0x080fe40002781470ULL,
0x00000064ad00720cULL, 0x080fe40002fa1470ULL, 0x000000649100720cULL, 0x000fc400037c1070ULL,
0x000000649d00720cULL, 0x0c0fe40000701070ULL, 0x000000649d00720cULL, 0x080fe40001741070ULL,
0x000000647b00720cULL, 0x0c0fe40001f61070ULL, 0x000000647b00720cULL, 0x0c0fe40000f21070ULL,
0x000000647b00720cULL, 0x080fe40002781070ULL, 0x00000064ab00720cULL, 0x000fc40002fa1070ULL,
0x0000007cd5b57219ULL, 0x040fe400000006ffULL, 0x00000020d5bd7219ULL, 0x000fe400000006ffULL,
0xff8000005b5b7808ULL, 0x000fe40003000000ULL, 0xff8000003a3a7808ULL, 0x000fe40000000000ULL,
0xff8000002d2d7808ULL, 0x000fe40001000000ULL, 0xff80000061617808ULL, 0x000fc40001800000ULL,
0xff8000003c3c7808ULL, 0x000fe40000800000ULL, 0xff8000002c2c7808ULL, 0x000fe40002000000ULL,
0xff8000003d3d7808ULL, 0x000fe40002800000ULL, 0x0000006ea7ff7212ULL, 0x000fe400078cc0ffULL,
0x00000078afff7212ULL, 0x080fe4000780c0ffULL, 0x00000078b5ff7212ULL, 0x000fc4000784c0ffULL,
0x0000007aafff7212ULL, 0x040fe4000786c0ffULL, 0x00000080afff7212ULL, 0x000fe4000782c0ffULL,
0x0000007ab5ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007ebdff7212ULL, 0x000fe200078ac0ffULL,
0x0000000189867824ULL, 0x000fe200078e0a84ULL, 0x00000064a500720cULL, 0x080fe400037c1470ULL,
0x00000064ad00720cULL, 0x000fc40000701470ULL, 0x00000064ad00720cULL, 0x0c0fe40001f61470ULL,
0x00000064ad00720cULL, 0x080fe40000f21470ULL, 0x00000064b300720cULL, 0x0c0fe40001741470ULL,
0x00000064b300720cULL, 0x080fe40002781470ULL, 0x00000064b900720cULL, 0x000fe40002fa1470ULL,
0x0000003165c57812ULL, 0x000fc400078efcffULL, 0x0000003865cb7812ULL, 0x040fe400078efcffULL,
0x0000003965d17812ULL, 0x000fe400078efcffULL, 0x00000064a300720cULL, 0x080fe400037c1070ULL,
0x00000064ab00720cULL, 0x0c0fe40000701070ULL, 0x00000064ab00720cULL, 0x0c0fe40001f61070ULL,
0x00000064ab00720cULL, 0x000fc40000f21070ULL, 0x00000064b100720cULL, 0x0c0fe40001741070ULL,
0x00000064b100720cULL, 0x080fe40002781070ULL, 0x00000064b700720cULL, 0x000fe40002fa1070ULL,
0x00000086d5c37219ULL, 0x000fe400000006ffULL, 0x00005410c18a7816ULL, 0x000fe4000000008aULL,
0x00005410d9907816ULL, 0x000fe20000000090ULL, 0x00000001c5c77824ULL, 0x100fe200078e0200ULL,
0xff80000060607808ULL, 0x000fe20003000000ULL, 0x00000001cbcd7824ULL, 0x100fe200078e0200ULL,
0xff8000005a5a7808ULL, 0x000fe20000000000ULL, 0x00000001d1d37824ULL, 0x000fe200078e0200ULL,
0xff80000052527808ULL, 0x000fc40001800000ULL, 0xff8000002a2a7808ULL, 0x000fe40000800000ULL,
0xff80000059597808ULL, 0x000fe40001000000ULL, 0xff8000004e4e7808ULL, 0x000fe40002000000ULL,
0xff8000003f3f7808ULL, 0x000fe40002800000ULL, 0x00000078bdff7212ULL, 0x040fe400078cc0ffULL,
0x0000007abdff7212ULL, 0x000fc4000780c0ffULL, 0x0000007eb5ff7212ULL, 0x040fe4000786c0ffULL,
0x00000080b5ff7212ULL, 0x080fe4000782c0ffULL, 0x00000080bdff7212ULL, 0x000fe4000784c0ffULL,
0x0000008ac3ff7212ULL, 0x040fe4000788c0ffULL, 0x00000090c3ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c7887824ULL, 0x100fe200078e0a84ULL, 0x00000064b300720cULL, 0x080fe20001f61470ULL,
0x00000001cd8c7824ULL, 0x100fe200078e0a84ULL, 0x00000064b300720cULL, 0x080fe20000f21470ULL,
0x00000001d3847824ULL, 0x000fe200078e0a84ULL, 0x00000064b900720cULL, 0x000fc400037c1470ULL,
0x00000064b900720cULL, 0x0c0fe40000701470ULL, 0x00000064b900720cULL, 0x080fe40001741470ULL,
0x000000648900720cULL, 0x0c0fe40002781470ULL, 0x000000648900720cULL, 0x000fe40002fa1470ULL,
0x00000088d5c97219ULL, 0x040fe400000006ffULL, 0x0000008cd5cf7219ULL, 0x000fc400000006ffULL,
0x00000064b100720cULL, 0x0c0fe40001f61070ULL, 0x00000064b100720cULL, 0x080fe40000f21070ULL,
0x00000064b700720cULL, 0x0c0fe400037c1070ULL, 0x00000064b700720cULL, 0x0c0fe40000701070ULL,
0x00000064b700720cULL, 0x080fe40001741070ULL, 0x000000648700720cULL, 0x000fc40002781070ULL,
0x000000648700720cULL, 0x000fe40002fa1070ULL, 0x00000084d5d57219ULL, 0x000fe400000006ffULL,
0x00005410d78e7816ULL, 0x000fe4000000008eULL, 0xff8000003e3e7808ULL, 0x000fe40001800000ULL,
0xff80000024247808ULL, 0x000fe40000800000ULL, 0xff80000058587808ULL, 0x000fc40003000000ULL,
0xff80000050507808ULL, 0x000fe40000000000ULL, 0xff80000025257808ULL, 0x000fe40001000000ULL,
0xff80000057577808ULL, 0x000fe40002000000ULL, 0xff80000043437808ULL, 0x000fe40002800000ULL,
0x0000008ac9ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008acfff7212ULL, 0x000fc4000782c0ffULL,
0x0000008ad5ff7212ULL, 0x000fe400078cc0ffULL, 0x0000008ec3ff7212ULL, 0x080fe4000780c0ffULL,
0x0000008ec9ff7212ULL, 0x080fe4000784c0ffULL, 0x0000008ecfff7212ULL, 0x000fe4000788c0ffULL,
0x00000090c9ff7212ULL, 0x000fe400078ac0ffULL, 0x000000648900720cULL, 0x000fc40000701470ULL,
0x00000064c700720cULL, 0x0c0fe40001f61470ULL, 0x00000064c700720cULL, 0x0c0fe40001741470ULL,
0x00000064c700720cULL, 0x080fe40002fa1470ULL, 0x00000064cd00720cULL, 0x080fe40000f21470ULL,
0x00000064d300720cULL, 0x080fe400037c1470ULL, 0x00000064cd00720cULL, 0x000fc40002781470ULL,
0x000000648700720cULL, 0x080fe40000701070ULL, 0x00000064c500720cULL, 0x0c0fe40001f61070ULL,
0x00000064c500720cULL, 0x0c0fe40001741070ULL, 0x00000064c500720cULL, 0x080fe40002fa1070ULL,
0x00000064cb00720cULL, 0x080fe40000f21070ULL, 0x00000064d100720cULL, 0x000fc400037c1070ULL,
0x00000064cb00720cULL, 0x000fe40002781070ULL, 0x00005410dd927816ULL, 0x000fe40000000092ULL,
0xff8000004f4f7808ULL, 0x000fe40000000000ULL, 0xff80000056567808ULL, 0x000fe40001800000ULL,
0xff80000046467808ULL, 0x000fe40001000000ULL, 0xff80000040407808ULL, 0x000fc40002800000ULL,
0xff80000055557808ULL, 0x000fe40000800000ULL, 0xff80000054547808ULL, 0x000fe40003000000ULL,
0xff80000045457808ULL, 0x000fe40002000000ULL, 0x0000008ed5ff7212ULL, 0x000fe4000780c0ffULL,
0x00000090cfff7212ULL, 0x080fe4000786c0ffULL, 0x00000090d5ff7212ULL, 0x000fc4000784c0ffULL,
0x00000092c3ff7212ULL, 0x080fe400078ac0ffULL, 0x00000092c9ff7212ULL, 0x080fe4000782c0ffULL,
0x00000092cfff7212ULL, 0x080fe400078cc0ffULL, 0x00000092d5ff7212ULL, 0x000fe4000788c0ffULL,
0x000000648900720cULL, 0x080fe40002fa1470ULL, 0x00000064c700720cULL, 0x000fc40000f21470ULL,
0x00000064cd00720cULL, 0x0c0fe40001f61470ULL, 0x00000064cd00720cULL, 0x080fe400037c1470ULL,
0x00000064d300720cULL, 0x0c0fe40000701470ULL, 0x00000064d300720cULL, 0x0c0fe40001741470ULL,
0x00000064d300720cULL, 0x080fe40002781470ULL, 0x000000648700720cULL, 0x000fc40002fa1070ULL,
0x00000064c500720cULL, 0x080fe40000f21070ULL, 0x00000064d100720cULL, 0x080fe40000701070ULL,
0x00000064cb00720cULL, 0x0c0fe40001f61070ULL, 0x00000064cb00720cULL, 0x080fe400037c1070ULL,
0x00000064d100720cULL, 0x0c0fe40001741070ULL, 0x00000064d100720cULL, 0x000fc40002781070ULL,
0xff80000044447808ULL, 0x000fe40000000000ULL, 0xff80000041417808ULL, 0x000fe40001800000ULL,
0xff80000042427808ULL, 0x000fe40001000000ULL, 0xff80000026267808ULL, 0x000fe40002800000ULL,
0xff80000027277808ULL, 0x000fe40000800000ULL, 0xff80000028287808ULL, 0x000fc40003000000ULL,
0xff80000029297808ULL, 0x000fc40002000000ULL, 0x0000005d1400720bULL, 0x004fe40003f1e000ULL,
0x000000481500720bULL, 0x000fe40003f3e000ULL, 0x000000351600720bULL, 0x000fe40003f5e000ULL,
0x000000321700720bULL, 0x000fe40003f7e000ULL, 0x000000145d197208ULL, 0x000fe40004000000ULL,
0x0000001548147208ULL, 0x000fc40004800000ULL, 0x0000001635157208ULL, 0x000fe40005000000ULL,
0x0000001732177208ULL, 0x000fe40005800000ULL, 0x0000005c1900720bULL, 0x000fe40003f1e000ULL,
0x000000531400720bULL, 0x000fe40003f3e000ULL, 0x000000341500720bULL, 0x000fe40003f5e000ULL,
0x000000301700720bULL, 0x000fc40003f7e000ULL, 0x000000195c197208ULL, 0x000fe40004000000ULL,
0x0000001453147208ULL, 0x000fe40004800000ULL, 0x0000001534157208ULL, 0x000fe40005000000ULL,
0x0000001730167208ULL, 0x000fe40005800000ULL, 0x0000005e1900720bULL, 0x000fe40003f1e000ULL,
0x000000471400720bULL, 0x000fc40003f3e000ULL, 0x000000361500720bULL, 0x000fe40003f5e000ULL,
0x000000311600720bULL, 0x000fe40003f7e000ULL, 0x000000195e187208ULL, 0x000fe40004000000ULL,
0x0000001447177208ULL, 0x000fe40004800000ULL, 0x0000001536147208ULL, 0x000fe40005000000ULL,
0x0000001631167208ULL, 0x000fc40005800000ULL, 0x0000005b1800720bULL, 0x000fe40003f1e000ULL,
0x0000004a1700720bULL, 0x000fe40003f3e000ULL, 0x000000371400720bULL, 0x000fe40003f5e000ULL,
0x000000331600720bULL, 0x000fe40003f7e000ULL, 0x000000185b187208ULL, 0x000fe40004000000ULL,
0x000000174a1a7208ULL, 0x000fc40004800000ULL, 0x0000001437157208ULL, 0x000fe40005000000ULL,
0x0000001633167208ULL, 0x000fe40005800000ULL, 0x000000631800720bULL, 0x000fe40003f1e000ULL,
0x000000491a00720bULL, 0x000fe40003f3e000ULL, 0x000000381500720bULL, 0x000fe40003f5e000ULL,
0x0000002f1600720bULL, 0x000fc40003f7e000ULL, 0x0000001863187208ULL, 0x000fe40004000000ULL,
0x0000001a491a7208ULL, 0x000fe40004800000ULL, 0x0000001538147208ULL, 0x000fe40005000000ULL,
0x000000162f157208ULL, 0x000fe40005800000ULL, 0x0000005f1800720bULL, 0x000fe40003f1e000ULL,
0x000000511a00720bULL, 0x000fc40003f3e000ULL, 0x000000391400720bULL, 0x000fe40003f5e000ULL,
0x0000002e1500720bULL, 0x000fe40003f7e000ULL, 0x000000185f177208ULL, 0x000fe40004000000ULL,
0x0000001a511a7208ULL, 0x000fe40004800000ULL, 0x0000001439197208ULL, 0x000fe40005000000ULL,
0x000000152e147208ULL, 0x000fc40005800000ULL, 0x000000621700720bULL, 0x000fe40003f1e000ULL,
0x0000004b1a00720bULL, 0x000fe40003f3e000ULL, 0x0000003a1900720bULL, 0x000fe40003f5e000ULL,
0x0000002d1400720bULL, 0x000fe40003f7e000ULL, 0x0000001762177208ULL, 0x000fe40004000000ULL,
0x0000001a4b1a7208ULL, 0x000fc40004800000ULL, 0x000000193a167208ULL, 0x000fe40005000000ULL,
0x000000142d147208ULL, 0x000fe40005800000ULL, 0x000000601700720bULL, 0x000fe40003f1e000ULL,
0x0000004d1a00720bULL, 0x000fe40003f3e000ULL, 0x0000003b1600720bULL, 0x000fe40003f5e000ULL,
0x0000002b1400720bULL, 0x000fc40003f7e000ULL, 0x0000001760187208ULL, 0x000fe40004000000ULL,
0x0000001a4d157208ULL, 0x000fe40004800000ULL, 0x000000163b177208ULL, 0x000fe40005000000ULL,
0x000000142b197208ULL, 0x000fe40005800000ULL, 0x000000611800720bULL, 0x000fe40003f1e000ULL,
0x0000004c1500720bULL, 0x000fc40003f3e000ULL, 0x0000003c1700720bULL, 0x000fe40003f5e000ULL,
0x0000002c1900720bULL, 0x000fe40003f7e000ULL, 0x00000018611b7208ULL, 0x000fe40004000000ULL,
0x000000154c157208ULL, 0x000fe40004800000ULL, 0x000000173c147208ULL, 0x000fe40005000000ULL,
0x000000192c197208ULL, 0x000fc40005800000ULL, 0x0000005a1b00720bULL, 0x000fe40003f1e000ULL,
0x000000521500720bULL, 0x000fe40003f3e000ULL, 0x0000003d1400720bULL, 0x000fe40003f5e000ULL,
0x0000002a1900720bULL, 0x000fe40003f7e000ULL, 0x0000001b5a167208ULL, 0x000fe40004000000ULL,
0x0000001552157208ULL, 0x000fc40004800000ULL, 0x000000143d177208ULL, 0x000fe40005000000ULL,
0x000000192a197208ULL, 0x000fe40005800000ULL, 0x000000591600720bULL, 0x000fe40003f1e000ULL,
0x0000004e1500720bULL, 0x000fe40003f3e000ULL, 0x0000003e1700720bULL, 0x000fe40003f5e000ULL,
0x000000241900720bULL, 0x000fc40003f7e000ULL, 0x00000016591b7208ULL, 0x000fe40004000000ULL,
0x000000154e157208ULL, 0x000fe40004800000ULL, 0x000000173e147208ULL, 0x000fe40005000000ULL,
0x0000001924167208ULL, 0x000fe40005800000ULL, 0x000000501500720bULL, 0x000fe40003f3e000ULL,
0x0000003f1400720bULL, 0x000fc40003f5e000ULL, 0x000000581b00720bULL, 0x000fe40003f1e000ULL,
0x000000251600720bULL, 0x000fe40003f7e000ULL, 0x00000015501a7208ULL, 0x000fe40004800000ULL,
0x000000143f147208ULL, 0x000fe40005000000ULL, 0x0000001b58187208ULL, 0x000fe40004000000ULL,
0x0000001625157208ULL, 0x000fc40005800000ULL, 0x000000431400720bULL, 0x000fe40003f5e000ULL,
0x000000571800720bULL, 0x000fe40003f1e000ULL, 0x0000004f1a00720bULL, 0x000fe40003f3e000ULL,
0x000000261500720bULL, 0x000fe40003f7e000ULL, 0x00000014431b7208ULL, 0x000fe40005000000ULL,
0x0000001857177208ULL, 0x000fc40004000000ULL, 0x0000001a4f197208ULL, 0x000fe40004800000ULL,
0x0000001526147208ULL, 0x000fe40005800000ULL, 0x000000561700720bULL, 0x000fe40003f1e000ULL,
0x000000461900720bULL, 0x000fe40003f3e000ULL, 0x000000401b00720bULL, 0x000fe40003f5e000ULL,
0x000000271400720bULL, 0x000fc40003f7e000ULL, 0x0000001756167208ULL, 0x000fe40004000000ULL,
0x0000001946187208ULL, 0x000fe40004800000ULL, 0x0000001b401a7208ULL, 0x000fe40005000000ULL,
0x0000001427157208ULL, 0x000fe40005800000ULL, 0x000000551600720bULL, 0x000fe40003f1e000ULL,
0x000000451800720bULL, 0x000fc40003f3e000ULL, 0x000000411a00720bULL, 0x000fe40003f5e000ULL,
0x000000281500720bULL, 0x000fe40003f7e000ULL, 0x0000001655177208ULL, 0x000fe40004000000ULL,
0x0000001845197208ULL, 0x000fe40004800000ULL, 0x0000001a411b7208ULL, 0x000fe40005000000ULL,
0x0000001528147208ULL, 0x000fc40005800000ULL, 0x000000541700720bULL, 0x000fe40003f1e000ULL,
0x000000441900720bULL, 0x000fe40003f3e000ULL, 0x000000421b00720bULL, 0x000fe40003f5e000ULL,
0x000000291400720bULL, 0x000fe40003f7e000ULL, 0x0000001754177208ULL, 0x000fe40004000000ULL,
0x00000019441a7208ULL, 0x000fc40004800000ULL, 0x0000001b421e7208ULL, 0x000fe40005000000ULL,
0x00000014291d7208ULL, 0x000fe20005800000ULL, 0x000025727f007947ULL, 0x000fea000b800000ULL,
0x0c401f0017147f89ULL, 0x0004e400000e0000ULL, 0x000000141700720bULL, 0x008fc80003f1e000ULL,
0x00000017141f7208ULL, 0x000fe20004000000ULL, 0x000025a27f007947ULL, 0x000fea000b800000ULL,
0x0c401f001a147f89ULL, 0x000ee800000e0000ULL, 0x0c401f001e157f89ULL, 0x000e6800000e0000ULL,
0x0c401f001d167f89ULL, 0x000ea200000e0000ULL, 0x000000141a00720bULL, 0x008fc40003f1e000ULL,
0x000000151e00720bULL, 0x002fe40003f3e000ULL, 0x0000001a14177208ULL, 0x004fe40004000000ULL,
0x0000001e15187208ULL, 0x000fe20004800000ULL, 0x0c201f001f147f89ULL, 0x000e6200000e0000ULL,
0x000000161d00720bULL, 0x000fc60003f1e000ULL, 0x0c201f00171c7f89ULL, 0x000ea200000e0000ULL,
0x0000001d161a7208ULL, 0x000fc60004000000ULL, 0x0c201f0018197f89ULL, 0x000ee800000e0000ULL,
0x0c201f001a1b7f89ULL, 0x0002e400000e0000ULL, 0x000000141f00720bULL, 0x002fe40003f1e000ULL,
0x0000001c1700720bULL, 0x004fe40003f3e000ULL, 0x0000001f14147208ULL, 0x000fc40004000000ULL,
0x000000191800720bULL, 0x008fe40003f5e000ULL, 0x000000171c157208ULL, 0x000fe40004800000ULL,
0x0000001819167208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b14177820ULL, 0x002fe20000410000ULL,
0x0000001b1a00720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe40000000000ULL,
0x3fb8aa3b5b1c7823ULL, 0x100fe40000010817ULL, 0x3fb8aa3b5d5d7823ULL, 0x000fc40000010817ULL,
0x3fb8aa3b5c5c7823ULL, 0x100fe20000010817ULL, 0x0000001c001d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b5e5e7823ULL, 0x100fe40000010817ULL, 0x3fb8aa3b63637823ULL, 0x100fe40000010817ULL,
0x3fb8aa3b5f5f7823ULL, 0x100fe40000010817ULL, 0x3fb8aa3b62627823ULL, 0x100fe20000010817ULL,
0x0000005d00187308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b60607823ULL, 0x000fc40000010817ULL,
0x3fb8aa3b615b7823ULL, 0x100fe40000010817ULL, 0x3fb8aa3b5a5a7823ULL, 0x100fe40000010817ULL,
0x3fb8aa3b59597823ULL, 0x100fe20000010817ULL, 0x00000060001f7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b58587823ULL, 0x100fe40000010817ULL, 0x3fb8aa3b57577823ULL, 0x100fe40000010817ULL,
0x3fb8aa3b56567823ULL, 0x000fc40000010817ULL, 0x3fb8aa3b55557823ULL, 0x100fe20000010817ULL,
0x0000005c00197308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b54547823ULL, 0x000fe20000010817ULL,
0x00000002ff607819ULL, 0x002fe2000001160bULL, 0x3fb8aa3b15177820ULL, 0x000fc60000410000ULL,
0x00000004601c7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010817ULL,
0x0000005e005e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010817ULL,
0x00000010606d7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b53537823ULL, 0x100fe40000010817ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe40000010817ULL, 0x3fb8aa3b49497823ULL, 0x100fe20000010817ULL,
0x0000004700207308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b51517823ULL, 0x100fe20000010817ULL,
0x000000181918723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b4b4b7823ULL, 0x000fc40000010817ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe40000010817ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010817ULL,
0x0000004a00217308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b52527823ULL, 0x100fe40000010817ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe40000010817ULL, 0x3fb8aa3b50507823ULL, 0x100fe40000010817ULL,
0x3fb8aa3b4f477823ULL, 0x102fe20000010817ULL, 0x0000004800487308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b46467823ULL, 0x000fc40000010817ULL, 0x3fb8aa3b45457823ULL, 0x100fe40000010817ULL,
0x3fb8aa3b44447823ULL, 0x000fe40000010817ULL, 0x3fb8aa3b16177820ULL, 0x000fe20000410000ULL,
0x0000005300537308ULL, 0x000e620000000800ULL, 0x0000000860617824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b35357823ULL, 0x100fe40000010817ULL, 0x3fb8aa3b34347823ULL, 0x000fc40000010817ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010817ULL, 0x0000005100227308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b37377823ULL, 0x100fe40000010817ULL, 0x3fb8aa3b38387823ULL, 0x100fe40000010817ULL,
0x3fb8aa3b39397823ULL, 0x100fe40000010817ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010817ULL,
0x00000038004a7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010817ULL,
0x000000485319723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b3c3c7823ULL, 0x000fc40000010817ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe40000010817ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010817ULL,
0x0000005f001e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe40000010817ULL,
0x3fb8aa3b43437823ULL, 0x100fe40000010817ULL, 0x3fb8aa3b40407823ULL, 0x100fe40000010817ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010817ULL, 0x0000004900497308ULL, 0x000e620000000800ULL,
0x3fb8aa3b42427823ULL, 0x000fe20000010817ULL, 0x0000001a1b177208ULL, 0x000fe20004000000ULL,
0x0000000860387824ULL, 0x044fe200078e00ffULL, 0x00000003601b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000860657824ULL, 0x040fe200078e00ffULL, 0x00000001601a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b174f7820ULL, 0x000fe20000410000ULL, 0xfffffff838677812ULL, 0x000fe200078ee21bULL,
0x00000004ff387e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff861617812ULL, 0x000fe200078ee21aULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001084fULL, 0x0000005000517308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001084fULL, 0x00000002601a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001084fULL, 0x3f8000003838783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001084fULL, 0xfffffff865657812ULL, 0x000fe200078ee21aULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x0000005e1d1a723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001084fULL,
0x00000020211b723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001084fULL,
0x00000049221d723eULL, 0x002fe200000010ffULL, 0x0000000860697824ULL, 0x000fe200078e00ffULL,
0x000000030bff7812ULL, 0x000fe2000780c0ffULL, 0x0000003000237308ULL, 0x000e620000000800ULL,
0x3fb8aa3b2d2d7823ULL, 0x000fc4000001084fULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001084fULL,
0xfffffff869697812ULL, 0x000fe200078ee21cULL, 0x000000ffff6a7224ULL, 0x100fe400078e0038ULL,
0x000000ffff6b7224ULL, 0x000fe200078e0038ULL, 0x0000003500357308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2c497823ULL, 0x100fe4000001084fULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe4000001084fULL,
0x3fb8aa3b24247823ULL, 0x000fc6000001084fULL, 0x0000003400347308ULL, 0x000ea20000000800ULL,
0x000000322321723eULL, 0x002fce00000010ffULL, 0x0000003600367308ULL, 0x000ff00000000800ULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x000000353420723eULL, 0x004fe200000010ffULL,
0x000000ffff347224ULL, 0x000fc400078e0038ULL, 0x000000ffff357224ULL, 0x000fc800078e0038ULL,
0x0000003100507308ULL, 0x000ff00000000800ULL, 0x00000033005f7308ULL, 0x000ea20000000800ULL,
0x000000363722723eULL, 0x002fce00000010ffULL, 0x0000004d005c7308ULL, 0x000ff00000000800ULL,
0x00000039004d7308ULL, 0x0002e20000000800ULL, 0x000000505f23723eULL, 0x004fe200000010ffULL,
0x00000008605f7824ULL, 0x000fcc00078e00ffULL, 0x0000006300637308ULL, 0x000ea20000000800ULL,
0x000000ffff397224ULL, 0x002fe200078e0038ULL, 0x000000342034723cULL, 0x000fec00000418ffULL,
0x0000006200627308ULL, 0x000e620000000800ULL, 0x0000004a4d2c723eULL, 0x008fe200000010ffULL,
0x000000381830723cULL, 0x000f6200000418ffULL, 0x3fb8aa3b274a7823ULL, 0x000fc4000001084fULL,
0x000000ffff277224ULL, 0x000fe400078e0038ULL, 0x00000008604d7824ULL, 0x000fe200078e00ffULL,
0x0000004b004b7308ULL, 0x000ee20000000800ULL, 0x000000631e1c723eULL, 0x004fe200000010ffULL,
0x0000000860637824ULL, 0x000fe400078e00ffULL, 0xfffffff84d4d7812ULL, 0x000fc800078ee260ULL,
0x0000003a003a7308ULL, 0x000fe20000000800ULL, 0x000000621f1e723eULL, 0x002fce00000010ffULL,
0x0000003b003b7308ULL, 0x000e620000000800ULL, 0x0000004b5c1f723eULL, 0x008fe200000010ffULL,
0x00000008605c7824ULL, 0x040fe200078e00ffULL, 0x00000005604b7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff85c537812ULL, 0x000fe200078ee24bULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x0000006a1c30723cULL, 0x020b620000041830ULL, 0x3fb8aa3b284b7823ULL, 0x000fcc000001084fULL,
0x0000002e00487308ULL, 0x0004e20000000800ULL, 0x00000008606b7810ULL, 0x020fce0007ffe0ffULL,
0x0000002d00397308ULL, 0x0007e20000000800ULL, 0xffffffff602e7810ULL, 0x004fc80007ffe0ffULL,
0xfffffff863637812ULL, 0x000fe400078ee22eULL, 0x0000003a3b2e723eULL, 0x002fe200000010ffULL,
0x0000002b00507308ULL, 0x000e620000000800ULL, 0x0000002f482d723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b263b7823ULL, 0x000fe4000001084fULL, 0x000000ffff267224ULL, 0x000fe400078e0038ULL,
0x000000086b487824ULL, 0x000fe400078e00ffULL, 0x0000004e004e7308ULL, 0x000ea60000000800ULL,
0xfffffff8486b7812ULL, 0x000fc400078ee26bULL, 0x00000039502f723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b25397823ULL, 0x100fe4000001084fULL, 0x0000005b005b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b294f7823ULL, 0x000fe4000001084fULL, 0x000000086d507824ULL, 0x000fe200078e00ffULL,
0x000000262c34723cULL, 0x000b680000041834ULL, 0x0000005a005a7308ULL, 0x000fe20000000800ULL,
0xfffffff8506d7812ULL, 0x000fe200078ee26dULL, 0x000000ffff507224ULL, 0x100fe200078e0038ULL,
0x0000004e5127723eULL, 0x024fe200000010ffULL, 0x000000ffff517224ULL, 0x000fc800078e0038ULL,
0x0000005900597308ULL, 0x000ff00000000800ULL, 0x0000005800587308ULL, 0x000e700000000800ULL,
0x0000004c004c7308ULL, 0x000ff00000000800ULL, 0x00000052005d7308ULL, 0x0004e20000000800ULL,
0x000000595826723eULL, 0x002fce00000010ffULL, 0x0000004900497308ULL, 0x000fe20000000800ULL,
0x0000000660527810ULL, 0x044fe40007ffe0ffULL, 0x0000001860607810ULL, 0x000fe40007ffe0ffULL,
0xfffffff85f5f7812ULL, 0x000fc600078ee252ULL, 0x0000002a003a7308ULL, 0x000e620000000800ULL,
0x0000000860297824ULL, 0x000fe200078e00ffULL, 0x0000004c5d25723eULL, 0x008fcc00000010ffULL,
0x00000024002b7308ULL, 0x0005f00000000800ULL, 0x0000003900487308ULL, 0x0006620000000800ULL,
0x0000005b5a24723eULL, 0x004fce00000010ffULL, 0x0000003c003c7308ULL, 0x000fe20000000800ULL,
0xfffffff829397812ULL, 0x008fe200078ee260ULL, 0x000000502430723cULL, 0x000f620000041830ULL,
0x000000493a29723eULL, 0x002fe200000010ffULL, 0x000000ffff497224ULL, 0x000fc800078e0038ULL,
0x0000003d003d7308ULL, 0x000e620000000800ULL, 0x0000002b482b723eULL, 0x000fe200000010ffULL,
0x000000ffff487224ULL, 0x000fcc00078e0038ULL, 0x0000003e003e7308ULL, 0x000ff00000000800ULL,
0x0000003f003f7308ULL, 0x000ea20000000800ULL, 0x0000003c3d28723eULL, 0x002fce00000010ffULL,
0x0000004700477308ULL, 0x000ff00000000800ULL, 0x0000004600467308ULL, 0x000e620000000800ULL,
0x0000003e3f2a723eULL, 0x004fce00000010ffULL, 0x0000004500457308ULL, 0x000fe20000000800ULL,
0x000000482834723cULL, 0x000fee0000041834ULL, 0x0000004400447308ULL, 0x000ea20000000800ULL,
0x00000047463d723eULL, 0x002fe400000010ffULL, 0x0001200002467811ULL, 0x000fca00078e60ffULL,
0x0000004300437308ULL, 0x000fe20000000800ULL, 0x000000104d4d7824ULL, 0x100fe400078e0246ULL,
0x0000001061617824ULL, 0x100fe400078e0246ULL, 0x0000001065657824ULL, 0x100fe400078e0246ULL,
0x0000001067677824ULL, 0x100fe200078e0246ULL, 0x0000004000407308ULL, 0x000e620000000800ULL,
0x00000045443f723eULL, 0x004fe200000010ffULL, 0x0000001069697824ULL, 0x100fe200078e0246ULL,
0x0000000c13447812ULL, 0x000fe200078ec0ffULL, 0x0000001053537824ULL, 0x000fc400078e0246ULL,
0x000000105f5f7824ULL, 0x000fe400078e0246ULL, 0x0000004100417308ULL, 0x000fe20000000800ULL,
0x000000014d4d7824ULL, 0x000fe400078e0244ULL, 0x0000000144617824ULL, 0x040fe400078e0261ULL,
0x0000000144657824ULL, 0x000fe200078e0265ULL, 0x000000184d007388ULL, 0x0005e20000000800ULL,
0x0000001063637824ULL, 0x100fe200078e0246ULL, 0x0000004200427308ULL, 0x000ee20000000800ULL,
0x000000434040723eULL, 0x002fe200000010ffULL, 0x0000000144677824ULL, 0x000fe200078e0267ULL,
0x0000001a61007388ULL, 0x0003e20000000800ULL, 0x000000106b6b7824ULL, 0x000fc400078e0246ULL,
0x0000000144697824ULL, 0x040fe200078e0269ULL, 0x0000001c65007388ULL, 0x0003e20000000800ULL,
0x0000005700577308ULL, 0x000fe20000000800ULL, 0x0000000144537824ULL, 0x040fe400078e0253ULL,
0x00000001445f7824ULL, 0x040fe200078e025fULL, 0x0000001e67007388ULL, 0x0003e20000000800ULL,
0x0000000144637824ULL, 0x040fe400078e0263ULL, 0x0000000144187824ULL, 0x004fe200078e026bULL,
0x0000005600567308ULL, 0x000ea20000000800ULL, 0x000000414242723eULL, 0x008fe200000010ffULL,
0x0000002469007388ULL, 0x0003e20000000800ULL, 0x000000106d6d7824ULL, 0x000fc400078e0246ULL,
0x0000001039397824ULL, 0x000fe200078e0246ULL, 0x0000002653007388ULL, 0x0003e20000000800ULL,
0x00000001446d7824ULL, 0x040fe200078e026dULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x0000000144447824ULL, 0x000fce00078e0239ULL, 0x0000005400547308ULL, 0x000ee20000000800ULL,
0x00000057563c723eULL, 0x004fca00000010ffULL, 0x0000003c5f007388ULL, 0x0003e40000000800ULL,
0x0000003b003b7308ULL, 0x000ff00000000800ULL, 0x0000004a004a7308ULL, 0x000ea20000000800ULL,
0x00000055543e723eULL, 0x008fca00000010ffULL, 0x0000003e63007388ULL, 0x0003e40000000800ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x000000483c30723cULL, 0x020f620000041830ULL,
0x0000001918007388ULL, 0x0003e80000000800ULL, 0x0004001b61007388ULL, 0x0003e40000000800ULL,
0x0000004f003a7308ULL, 0x000ee20000000800ULL, 0x0000003b4a41723eULL, 0x004fe200000010ffULL,
0x000000ffff3b7224ULL, 0x100fe200078e0038ULL, 0x0004001d65007388ULL, 0x0003e80000000800ULL,
0x0004001f67007388ULL, 0x0003e80000000800ULL, 0x0004002569007388ULL, 0x0003e80000000800ULL,
0x0004002753007388ULL, 0x0003e20000000800ULL, 0x0000004b3a43723eULL, 0x008fe200000010ffULL,
0x000000ffff3a7224ULL, 0x000fc400078e0038ULL, 0x0004003d5f007388ULL, 0x0003e20000000800ULL,
0x000000ffff317224ULL, 0x020fc600078e0032ULL, 0x0004003f63007388ULL, 0x0003e20000000800ULL,
0x0000003a4034723cULL, 0x000f660000041834ULL, 0x000000206d007388ULL, 0x0003e80000000800ULL,
0x0008002261007388ULL, 0x0003e80000000800ULL, 0x0008002c65007388ULL, 0x0003e80000000800ULL,
0x0008002e67007388ULL, 0x0003e80000000800ULL, 0x0008002869007388ULL, 0x0003e80000000800ULL,
0x0008002a53007388ULL, 0x0003e20000000800ULL, 0x000000ffff327224ULL, 0x020fc400078e0034ULL,
0x000000ffff337224ULL, 0x000fe200078e0036ULL, 0x000800405f007388ULL, 0x0003e80000000800ULL,
0x0008004263007388ULL, 0x0003e80000000800ULL, 0x0000002144007388ULL, 0x0003e80000000800ULL,
0x000c002361007388ULL, 0x0003e80000000800ULL, 0x000c002d65007388ULL, 0x0003e80000000800ULL,
0x000c002f67007388ULL, 0x0003e80000000800ULL, 0x000c002969007388ULL, 0x0003e80000000800ULL,
0x000c002b53007388ULL, 0x0003e80000000800ULL, 0x000c00415f007388ULL, 0x0003e80000000800ULL,
0x000c004363007388ULL, 0x0003e80000000800ULL, 0x01a0001411008388ULL, 0x0003e80000000c00ULL,
0x01a2003011008388ULL, 0x0003e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000beff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000800beff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00001000beff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000110107810ULL, 0x000fe20007ffe0ffULL, 0x00001800beff7f8cULL, 0x0003e4000c80043fULL,
0x000000ffff117224ULL, 0x002fe200078e0012ULL, 0x000000061000720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff7ae000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff277807ULL, 0x008fe20004000000ULL,
0xffffffffff297424ULL, 0x000fe200078e00ffULL, 0x0001d37000287802ULL, 0x000fc40000000f00ULL,
0x000015f000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0027ULL,
0xfffe599000007947ULL, 0x000fea000383ffffULL, 0x00000001ff277807ULL, 0x000fe20005000000ULL,
0xffffffffff297424ULL, 0x000fe200078e00ffULL, 0x0001d3d000287802ULL, 0x000fc40000000f00ULL,
0x0000159000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff127224ULL, 0x000fe200078e0027ULL,
0xfffe59c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0026ULL,
0x0001d44000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000014d000007944ULL, 0x014fea0003c00000ULL,
0xfffe5a7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0026ULL,
0x0001d4a000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000147000007944ULL, 0x014fea0003c00000ULL,
0xfffe5b8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0026ULL,
0x0001d50000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000141000007944ULL, 0x014fea0003c00000ULL,
0xfffe5c9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0026ULL,
0x0001d56000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000013b000007944ULL, 0x014fea0003c00000ULL,
0xfffe5d9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0000ULL,
0x0001d5d000277802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0007ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000134000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0028ULL,
0xfffe616000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0000ULL,
0x0001d64000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000012d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0028ULL, 0x0000001007297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff287224ULL, 0x000fe200078e0000ULL, 0x0001d6b000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000126000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0028ULL,
0xfffe60d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0000ULL,
0x0001d72000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000011f000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0028ULL, 0xfffe609000007947ULL, 0x000fea000383ffffULL,
0x00000001ff277807ULL, 0x008fe20004000000ULL, 0xffffffffff297424ULL, 0x000fe200078e00ffULL,
0x0001d78000287802ULL, 0x000fc40000000f00ULL, 0x000011e000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff257224ULL, 0x000fe200078e0027ULL, 0xfffe916000007947ULL, 0x000fea000383ffffULL,
0x00000001ff277807ULL, 0x000fe20005000000ULL, 0xffffffffff297424ULL, 0x000fe200078e00ffULL,
0x0001d7e000287802ULL, 0x000fc40000000f00ULL, 0x0000118000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff727224ULL, 0x000fe200078e0027ULL, 0xfffe919000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0073ULL, 0x0001d85000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000010c000007944ULL, 0x014fea0003c00000ULL, 0xfffe925000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0073ULL, 0x0001d8b000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000106000007944ULL, 0x014fea0003c00000ULL, 0xfffe936000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0073ULL, 0x0001d91000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000100000007944ULL, 0x014fea0003c00000ULL, 0xfffe947000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0073ULL, 0x0001d97000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000fa000007944ULL, 0x014fea0003c00000ULL, 0xfffe957000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0013ULL, 0x0001d9e000277802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe400078e0026ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000f3000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0028ULL, 0xfffe997000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0013ULL, 0x0001da5000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000ec000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0028ULL,
0x0000001026297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff287224ULL, 0x000fe200078e0013ULL,
0x0001dac000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000e5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0028ULL, 0xfffe98e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0013ULL, 0x0001db3000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000de000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0028ULL,
0xfffe98a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff277807ULL, 0x008fe20004000000ULL,
0xffffffffff297424ULL, 0x000fe200078e00ffULL, 0x0001db9000287802ULL, 0x000fc40000000f00ULL,
0x00000dd000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff737224ULL, 0x000fe200078e0027ULL,
0xfffec74000007947ULL, 0x000fea000383ffffULL, 0x00000001ff277807ULL, 0x000fe20005000000ULL,
0xffffffffff297424ULL, 0x000fe200078e00ffULL, 0x0001dbf000287802ULL, 0x000fc40000000f00ULL,
0x00000d7000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff787224ULL, 0x000fe200078e0027ULL,
0xfffec78000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0021ULL,
0x0001dc6000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000cb000007944ULL, 0x014fea0003c00000ULL,
0xfffec83000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0021ULL,
0x0001dcc000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000c5000007944ULL, 0x014fea0003c00000ULL,
0xfffec94000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0021ULL,
0x0001dd2000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000bf000007944ULL, 0x014fea0003c00000ULL,
0xfffeca5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0021ULL,
0x0001dd8000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000b9000007944ULL, 0x014fea0003c00000ULL,
0xfffecb5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0013ULL,
0x0001ddf000277802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe400078e002aULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000b2000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0028ULL,
0xfffecf4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0013ULL,
0x0001de6000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000ab000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0028ULL, 0x000000102a297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff287224ULL, 0x000fe200078e0013ULL, 0x0001ded000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000a4000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0028ULL,
0xfffeceb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0013ULL,
0x0001df4000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000009d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0028ULL, 0xfffece7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff277807ULL, 0x004fe20004000000ULL, 0xffffffffff297424ULL, 0x000fe200078e00ffULL,
0x0001dfa000287802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0027ULL, 0xfffefde000007947ULL, 0x000fea000383ffffULL,
0x00000001ff277807ULL, 0x000fe20005000000ULL, 0xffffffffff297424ULL, 0x000fe200078e00ffULL,
0x0001e00000287802ULL, 0x000fc40000000f00ULL, 0x0000096000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x000fe200078e0027ULL, 0xfffefe1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0021ULL, 0x0001e07000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000008a000007944ULL, 0x018fea0003c00000ULL, 0xfffefec000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0021ULL, 0x0001e0d000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000084000007944ULL, 0x018fea0003c00000ULL, 0xfffeffd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0021ULL, 0x0001e13000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000007e000007944ULL, 0x018fea0003c00000ULL, 0xffff00e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e0021ULL, 0x0001e19000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000078000007944ULL, 0x018fea0003c00000ULL, 0xffff01e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e000aULL, 0x0001e20000277802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe400078e000fULL, 0x0000001fff717424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000071000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0028ULL, 0xffff05d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e000aULL, 0x0001e27000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0028ULL,
0x000000100f297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff287224ULL, 0x000fe200078e000aULL,
0x0001e2e000277802ULL, 0x000fe20000000f00ULL, 0x0000001fff717424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0028ULL, 0xffff054000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x000fe200078e000aULL, 0x0001e35000277802ULL, 0x000fe20000000f00ULL,
0x0000001fff717424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0028ULL,
0xffff050000007947ULL, 0x000fea000383ffffULL, 0x00000002ff1c7424ULL, 0x000fe200078e00ffULL,
0x0001e3c000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff1b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff207424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e001bULL, 0xffffda3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x006fe200078e001aULL, 0x0001e44000187802ULL, 0x000fe20000000f00ULL,
0x00000002ff1c7424ULL, 0x000fc400078e00ffULL, 0x0000001fff1b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff207424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x010fea0003c00000ULL,
0x0000001b1a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff177224ULL, 0x002fe200078e001eULL,
0x0001e4c000187802ULL, 0x000fe20000000f00ULL, 0x00000002ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000001a1b167208ULL, 0x000fe20004000000ULL, 0x0000001fff1b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff207424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x0000001b1e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff177224ULL, 0x002fe200078e001dULL,
0x0001e54000187802ULL, 0x000fe20000000f00ULL, 0x00000002ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000001e1b1e7208ULL, 0x000fe20004000000ULL, 0x0000001fff1b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff207424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000001b1d00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff177224ULL, 0x002fe200078e001fULL,
0x0001e5c000187802ULL, 0x000fe20000000f00ULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000001d1b1a7208ULL, 0x000fe20004000000ULL, 0x0000001fff1b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff207424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000001b1f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff177224ULL, 0x002fe200078e0016ULL,
0x0001e64000187802ULL, 0x000fe20000000f00ULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000001f1b147208ULL, 0x000fe20004000000ULL, 0x0000001fff1b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff207424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x0000001b1600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff177224ULL, 0x002fe200078e001eULL,
0x0001e6c000187802ULL, 0x000fe20000000f00ULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x000000161b157208ULL, 0x000fe20004000000ULL, 0x0000001fff1b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff207424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x0000001b1e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff177224ULL, 0x002fe200078e001aULL,
0x0001e74000187802ULL, 0x000fe20000000f00ULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000001e1b167208ULL, 0x000fe20004000000ULL, 0x0000001fff1b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff207424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffd82000007947ULL, 0x000fea000383ffffULL, 0x0180000022007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000047812ULL, 0x000fc800078ec0ffULL,
0x018000000400780cULL, 0x000fda0003f05070ULL, 0x0000002200008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0400720cULL, 0x040fe40003f25070ULL,
0x008000000400780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000005ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff22ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000022047812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fda000780c0ffULL, 0x0080000004000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0004ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe400078e0006ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffe173004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff197424ULL, 0x000fe200078e00ffULL,
0x0000002000007348ULL, 0x000fe80003800000ULL, 0x0c00001c171b7389ULL, 0x0002a200000e001bULL,
0xfffe16f018007950ULL, 0x000fea0003c3ffffULL, 0x0000006c00007348ULL, 0x000fe80003800000ULL,
0x0000002928287389ULL, 0x0002a200000e0071ULL, 0x00000000ff6d7424ULL, 0x000fc400078e00ffULL,
0x000000ffff6c7224ULL, 0x002fc800078e0027ULL, 0xfffe16a06c007950ULL, 0x000fea0003c3ffffULL,
0x000000012700780cULL, 0x000fe20003f45070ULL, 0x0000002900007348ULL, 0x000fd80003800000ULL,
0x0000000000277806ULL, 0x000fc800050e0100ULL, 0x0000002927277212ULL, 0x000fe200078ec0ffULL,
0x00000000ff297424ULL, 0x000fc800078e00ffULL, 0xfffe164028007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000568ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000348ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c80ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d40ULL,
0x00000000000008b0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001600ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001690ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001694ULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x000000000001ea80ULL, 0xf900001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000020300ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000020340ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x00000000000206c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001690ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001ec70ULL,
0x000000000001ec70ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000020300ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000206c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_80_cubin_len = 133024;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
