/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000019cd0ULL, 0x0000000000019950ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x0000000000017da0ULL, 0x0000000000000190ULL, 0x000b0022000004daULL, 0x0000000000017f30ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x0000000000017f70ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x0000000000017fc0ULL, 0x0000000000000140ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000018100ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00017da000000000ULL, 0x0000040400000000ULL, 0x810c000001880400ULL, 0x005dd40400288080ULL,
0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9008288080870828ULL,
0x2880809208288080ULL, 0x8095082880809308ULL, 0x08288080ac082880ULL, 0x80808508288080b1ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808592ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x00017da000000000ULL, 0x0000019000000000ULL, 0x0000580400000000ULL,
0x8084288080820900ULL, 0x0900000004042880ULL, 0x2880808228808085ULL, 0x00000064ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x9208288080870828ULL, 0x2880809308288080ULL, 0x80ac082880809508ULL,
0x08288080b1082880ULL, 0x8082801628808090ULL, 0x0000000000031028ULL, 0x2880809092000000ULL,
0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000012000000000ULL, 0x00017f3000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x9008288080870828ULL, 0x2880809208288080ULL, 0x80ac082880809508ULL, 0x08288080b1082880ULL,
0x8082801628808093ULL, 0x0000000000031028ULL, 0x2880809392000000ULL, 0x0000000000002200ULL,
0x0000002cffffffffULL, 0x000001b800000000ULL, 0x00017f7000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x8092288080930900ULL, 0x0000000000002880ULL, 0x00000064ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x9008288080870828ULL, 0x2880809308288080ULL, 0x80ac082880809508ULL,
0x08288080b1082880ULL, 0x8082801628808092ULL, 0x0000000000031028ULL, 0x2880809292000000ULL,
0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000026000000000ULL, 0x00017fc000000000ULL,
0x0000014000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x000823040000007fULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL,
0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL,
0x0008110400000000ULL, 0x000000000000001bULL, 0x0000007b00043704ULL, 0x0000001800080a04ULL,
0x0068190300680160ULL, 0x00000000000c1704ULL, 0x0021f0000060000aULL, 0x00000000000c1704ULL,
0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0011f00000500008ULL, 0x00000000000c1704ULL,
0x0081f00000300007ULL, 0x00000000000c1704ULL, 0x0021f00000280006ULL, 0x00000000000c1704ULL,
0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL,
0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL,
0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400801b03ULL,
0x0134290400000b70ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL,
0x000003c000000390ULL, 0x00002900000005f0ULL, 0x00002ad0000029b0ULL, 0x000030b000002c30ULL,
0x00003130000030e0ULL, 0x0000603000003180ULL, 0x000061f0000060c0ULL, 0x000067e000006350ULL,
0x0000686000006810ULL, 0x00009520000068b0ULL, 0x000096f0000095c0ULL, 0x00009ce000009850ULL,
0x00009d6000009d10ULL, 0x0000ca8000009db0ULL, 0x0000cc400000cb20ULL, 0x0000d2200000cda0ULL,
0x0000d2a00000d250ULL, 0x0000f4000000d2f0ULL, 0x000166600000f410ULL, 0x000166b0000166a0ULL,
0x00016710000166c0ULL, 0x0001675000016730ULL, 0x000173e000016760ULL, 0x0001747000017420ULL,
0x00017500000174b0ULL, 0x000175a000017550ULL, 0x00017630000175e0ULL, 0x000176c000017670ULL,
0x0001776000017710ULL, 0x000177f0000177a0ULL, 0x0001788000017830ULL, 0x00017920000178d0ULL,
0x000179b000017960ULL, 0x00017a40000179f0ULL, 0x00017ae000017a90ULL, 0x00017ba000017b40ULL,
0x00017c6000017c00ULL, 0x00017d2000017cc0ULL, 0x0440390400017d80ULL, 0x000000ff00000430ULL,
0x003f01000000f600ULL, 0x0000000f00000470ULL, 0x003f01200000f608ULL, 0x0000000f00000500ULL,
0x003f01200000f688ULL, 0x0000000f00000510ULL, 0x003f01200000f6a8ULL, 0x0000000f000005b0ULL,
0x003f01200000f6c8ULL, 0x000000ff00000b90ULL, 0x003f01070000f600ULL, 0x0000000500000d80ULL,
0x003f010200000004ULL, 0x0000000500000e30ULL, 0x003f010100000000ULL, 0x0000000500001660ULL,
0x003f01070000f6a8ULL, 0x00000005000017c0ULL, 0x003f01010000f6a8ULL, 0x0000000a00001820ULL,
0x003f01010000f6c8ULL, 0x00000011000019d0ULL, 0x003f01050000f6ccULL, 0x0000001100001bb0ULL,
0x003f01050000f6ccULL, 0x0000000d000024f0ULL, 0x003f01070000f6b0ULL, 0x0000000d000025a0ULL,
0x003f01010000f6b0ULL, 0x0000000a00002600ULL, 0x003f01010000f608ULL, 0x0000000a00002620ULL,
0x003f01050000f60cULL, 0x0000000a000027f0ULL, 0x003f01050000f60cULL, 0x0000002a00002e10ULL,
0x003f01050000f6acULL, 0x0000002a00002fe0ULL, 0x003f01050000f6acULL, 0x0000000e000051a0ULL,
0x003f010100000000ULL, 0x0000005b00005200ULL, 0x003f01010000f688ULL, 0x0000000700005230ULL,
0x003f010500000004ULL, 0x00000007000053f0ULL, 0x003f010500000004ULL, 0x0000000d00005c40ULL,
0x003f01070000f6a8ULL, 0x0000000d00005d10ULL, 0x003f01010000f6a8ULL, 0x0000000a00005d70ULL,
0x003f01010000f628ULL, 0x0000000a00005d90ULL, 0x003f01050000f62cULL, 0x0000000a00005f60ULL,
0x003f01050000f62cULL, 0x0000003600006540ULL, 0x003f01050000f6b4ULL, 0x0000003600006710ULL,
0x003f01050000f6b4ULL, 0x0000001000008690ULL, 0x003f010100000000ULL, 0x00000012000086f0ULL,
0x003f01010000f690ULL, 0x0000000700008720ULL, 0x003f010500000004ULL, 0x00000007000088e0ULL,
0x003f010500000004ULL, 0x0000000d00009130ULL, 0x003f01070000f6b0ULL, 0x0000000d00009200ULL,
0x003f01010000f6b0ULL, 0x0000000a00009260ULL, 0x003f01010000f648ULL, 0x0000000a00009280ULL,
0x003f01050000f64cULL, 0x0000000a00009450ULL, 0x003f01050000f64cULL, 0x0000001100009a40ULL,
0x003f01050000f6acULL, 0x0000001100009c10ULL, 0x003f01050000f6acULL, 0x0000000e0000bb80ULL,
0x003f010100000000ULL, 0x0000000d0000bbe0ULL, 0x003f01010000f698ULL, 0x000000070000bc10ULL,
0x003f010500000004ULL, 0x000000070000bdd0ULL, 0x003f010500000004ULL, 0x0000000b0000c6e0ULL,
0x003f01070000f6a8ULL, 0x0000000b0000c770ULL, 0x003f01010000f6a8ULL, 0x000000080000c7d0ULL,
0x003f01010000f668ULL, 0x000000080000c800ULL, 0x003f01050000f66cULL, 0x000000080000c9d0ULL,
0x003f01050000f66cULL, 0x0000002a0000cf80ULL, 0x003f01050000f6b4ULL, 0x0000002a0000d150ULL,
0x003f01050000f6b4ULL, 0x000000070000f1d0ULL, 0x003f010100000000ULL, 0x000000110000f250ULL,
0x003f010100000000ULL, 0x000000ff00010630ULL, 0x003f01010000f600ULL, 0x000000ff00011280ULL,
0x003f01050000f604ULL, 0x000000ff00011490ULL, 0x003f01050000f604ULL, 0x000000ff000116c0ULL,
0x003f01010000f600ULL, 0x000000ff000116f0ULL, 0x003f01050000f604ULL, 0x000000ff000118b0ULL,
0x003f01050000f604ULL, 0x0000007900014a20ULL, 0x003f010100000000ULL, 0x0000007900014ac0ULL,
0x003f010500000004ULL, 0x0000007900014c90ULL, 0x003f010500000004ULL, 0x0000007c00017240ULL,
0x003f010100000000ULL, 0x0000007c000172a0ULL, 0x003f010100000008ULL, 0x0000007c00017300ULL,
0x003f010100000010ULL, 0x0000007c00017370ULL, 0x003f010100000018ULL, 0x00201c0400053803ULL,
0x0000fd100000fce0ULL, 0x000101a00000ffb0ULL, 0x00010550000103a0ULL, 0x000173b000011910ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000002e4ULL, 0x0000001b00000002ULL,
0x000000000000023cULL, 0x0000001b00000002ULL, 0x00000000000001a4ULL, 0x0000001b00000002ULL,
0x00000000000000f4ULL, 0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL,
0x00000000000002bbULL, 0x0000001b00000002ULL, 0x0000000000000213ULL, 0x0000001b00000002ULL,
0x000000000000017bULL, 0x0000001b00000002ULL, 0x00000000000000d0ULL, 0x0000001b00000002ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000077919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff040424ULL, 0x000fe200078e00ffULL,
0x0000000107020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e0004ULL,
0x00005c0007040625ULL, 0x000fe200078e0004ULL, 0x00000006020b0981ULL, 0x0002a8000c1e1900ULL,
0x0000000604060981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff767624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x00000000000c7919ULL, 0x000e620000002300ULL, 0x00005a00ff117624ULL, 0x000fc800078e00ffULL,
0x0000590011117a24ULL, 0x000fe200078e02ffULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00087810ULL, 0x010fcc0007ffe0ffULL, 0x0000000800097305ULL, 0x000864000021f000ULL,
0x000000ffff087224ULL, 0x010fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x002fc800078e0a09ULL,
0x000059000d0d7a24ULL, 0x000fc800078e02ffULL, 0x0000000d09097227ULL, 0x000fe400078e0008ULL,
0x0000000000087919ULL, 0x000e680000002600ULL, 0x0000040009097a27ULL, 0x000fe200078e00ffULL,
0x00000000000d7919ULL, 0x000f260000002100ULL, 0x000000ffff037224ULL, 0x000fc800078e0a09ULL,
0x0000040003007624ULL, 0x000fca00078e0276ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x0000000109091810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x0000000109092810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff09ba12ULL, 0x000fc800078e33ffULL, 0x0000000900007306ULL, 0x000e620000209000ULL,
0x000000ff0900720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002e4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000309047224ULL, 0x008fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000503037227ULL, 0x000fe400078e0002ULL,
0x0000000000057919ULL, 0x000e680000002200ULL, 0x0000000803787227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a78ULL, 0x0000000009007224ULL, 0x000fca00078e0208ULL,
0x000000090000720cULL, 0x000fe20003fa6070ULL, 0x000001000c027a24ULL, 0x002fc800078e0205ULL,
0x00000000020f7a24ULL, 0x010fd000078e020dULL, 0x0000000100005824ULL, 0x000fe200078e0a09ULL,
0x0000000178785810ULL, 0x000fe40007ffe0ffULL, 0x000000ff0f00720cULL, 0x040fe40003f65270ULL,
0x000000090000720cULL, 0x000fe40003fc6070ULL, 0x0000000f0f00780cULL, 0x040fe40003f24070ULL,
0x00000005ff007819ULL, 0x000fe4000001160dULL, 0x00001fff0c0d7589ULL, 0x000fe200000e0000ULL,
0x000000030f00780cULL, 0x000fc40003fa4070ULL, 0x0000007f0f00780cULL, 0x040fe20003f44070ULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x0000000178786810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL,
0x00000009ff78c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff049424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00f60002ff00b388ULL, 0x0007e20000000a00ULL,
0x000000ffff7b7224ULL, 0x000fe200078e0a78ULL, 0x000000010f00780cULL, 0x000fe20003f64070ULL,
0xff317217ff0ea424ULL, 0x000fe200078e00ffULL, 0x00f608040f009388ULL, 0x000fe20000008a00ULL,
0x0000007b097b7224ULL, 0x000fc400078e0208ULL, 0x3fffff80ff08d424ULL, 0x000fe200078e00ffULL,
0x00f4000e0f00a388ULL, 0x000fe20000004800ULL, 0x000000107b7b7824ULL, 0x000fe400078e00ffULL,
0x3fffff60ff02d424ULL, 0x008fe400078e00ffULL, 0x7fffff60ff03d424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff09d424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff0ab424ULL, 0x000fe200078e00ffULL,
0x00f688020f00d388ULL, 0x0003e80000008a00ULL, 0x00f6a8080f00d388ULL, 0x000fe20000008a00ULL,
0x000000040d027824ULL, 0x002fc400078e0200ULL, 0x000000010b720824ULL, 0x004fe400078e0a06ULL,
0x00005800ff728624ULL, 0x000fe400078e00ffULL, 0x0000580007068a24ULL, 0x000fe400078e02ffULL,
0x00005a0072047a24ULL, 0x000fe400078e02ffULL, 0x7fffffc0ff0bb424ULL, 0x000fe400078e00ffULL,
0x0000000104057824ULL, 0x040fe200078e0a7bULL, 0x0000007b0400720cULL, 0x000fe20003f26070ULL,
0x00000011067a7224ULL, 0x000fe200078e02ffULL, 0x00f6c80a0f00b388ULL, 0x000fe20000008a00ULL,
0x0000000202047824ULL, 0x000fe200078e00ffULL, 0x0000001005057817ULL, 0x000fc80003800000ULL,
0x000000ff05797207ULL, 0x000fe20000800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000107900780cULL, 0x000fe20003f05270ULL, 0x00005a00780f7a24ULL, 0x000fd800078e027aULL,
0x000002c000008947ULL, 0x000fea0003800000ULL, 0x00005a0000087b06ULL, 0x000e620000209000ULL,
0x0000000000497919ULL, 0x000ea20000000000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000800087308ULL, 0x002e620000001000ULL,
0x00000004ff057819ULL, 0x004fca0000011649ULL, 0x00000001040a7824ULL, 0x000fe200078e0205ULL,
0x0ffffffe08037810ULL, 0x002fe20007ffe0ffULL, 0x0000001049087824ULL, 0x000fca00078e00ffULL,
0x0000000300037305ULL, 0x000e64000021f000ULL, 0x000000ffff097224ULL, 0x002fc800078e0a03ULL,
0x00005a0009097a24ULL, 0x000fc800078e02ffULL, 0x0000000903097227ULL, 0x000fc800078e0002ULL,
0x000000017b027824ULL, 0x000fc800078e020aULL, 0x0000000209097227ULL, 0x000fc800078e00ffULL,
0x000000ffff0b7224ULL, 0x000fc800078e0a09ULL, 0x00005a000b037a24ULL, 0x000fca00078e0202ULL,
0x00005a0003007a0cULL, 0x000fda0003f06070ULL, 0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL,
0x0000000109090810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fda0003f26070ULL,
0x0000000109091810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff09aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a09ULL, 0x00005a0003027a24ULL, 0x000fe200078e0202ULL,
0x0000000479037217ULL, 0x000fc60007800000ULL, 0x000000010f027824ULL, 0x000fe400078e0202ULL,
0x0000000103047824ULL, 0x000fe400078e0a04ULL, 0x0000001109027224ULL, 0x000fe200078e0202ULL,
0x000000f008097812ULL, 0x000fe400078ec0ffULL, 0x000000040500720cULL, 0x000fe20003f06070ULL,
0x0000010002027825ULL, 0x000fc800078e00ffULL, 0x000000010a047824ULL, 0x000fe200078e0249ULL,
0x0000000902097212ULL, 0x000fe200078efcffULL, 0x000000100a057824ULL, 0x000fc600078e00ffULL,
0x0000600009027a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff005047812ULL, 0x000fe400078ee204ULL,
0x0000610003037a10ULL, 0x000fc60000ffe4ffULL, 0x0000001004057824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e2000c101c46ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00005a0000057b06ULL, 0x000e620000209000ULL,
0x0000000000497919ULL, 0x000ea20000000000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000500057308ULL, 0x002e620000001000ULL,
0x0000000449047211ULL, 0x004fe400078fe0ffULL, 0x0ffffffe05087810ULL, 0x002fca0007ffe0ffULL,
0x0000000800037305ULL, 0x0002a4000021f000ULL, 0x0000001049087824ULL, 0x002fe400078e00ffULL,
0x000000ffff097224ULL, 0x004fc800078e0a03ULL, 0x00005a0009097a24ULL, 0x000fc800078e02ffULL,
0x0000000903037227ULL, 0x000fe200078e0002ULL, 0x000000f008097812ULL, 0x000fc600078ec0ffULL,
0x000000017b027824ULL, 0x000fc800078e0204ULL, 0x0000000203037227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a03ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103030810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff03aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a03ULL, 0x00005a0005027a24ULL, 0x000fe400078e0202ULL,
0x0000000104057824ULL, 0x040fe400078e0249ULL, 0x000000010f027824ULL, 0x000fe400078e0202ULL,
0x0000001004047824ULL, 0x000fe400078e00ffULL, 0x0000001103027224ULL, 0x000fc600078e0202ULL,
0xfffffff004057812ULL, 0x000fe200078ee205ULL, 0x0000010002027825ULL, 0x000fc800078e00ffULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x0000000902027212ULL, 0x000fc800078efcffULL,
0x0000600002027a10ULL, 0x000fc80007f1e0ffULL, 0x0000610003037a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e8000b901c46ULL,
0x0000000000047919ULL, 0x000ea20000000000ULL, 0x0000000000027806ULL, 0x002fe200038e0000ULL,
0x00000004ff427424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000200037300ULL, 0x000eb000000e0000ULL, 0x0000000200057309ULL, 0x000e620000000000ULL,
0x000000040300720cULL, 0x004fe20003f02070ULL, 0x000000ffff037224ULL, 0x002fc400078e0a05ULL,
0x0000680007047625ULL, 0x000fd400078e0042ULL, 0x00f60403ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604027981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0d00720cULL, 0x000fe40003f05270ULL,
0x0000003f02037810ULL, 0x046fe40007ffe0ffULL, 0x000000ff02107810ULL, 0x000fc40007ffe0ffULL,
0x00000006ff037819ULL, 0x000fe40000011603ULL, 0x00000008ff717819ULL, 0x000fca0000011610ULL,
0x0000f89000008947ULL, 0x000fea0003800000ULL, 0x00000002ff777819ULL, 0x000fe20000011600ULL,
0x00000003ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000f68800057811ULL, 0x000fe400078e18ffULL,
0x03ffffff77067812ULL, 0x000fc800078ec0ffULL, 0x000000030600720cULL, 0x000fda0003f06070ULL,
0x0000000207048824ULL, 0x000fe400078e00ffULL, 0x00006a00ff098624ULL, 0x000fc800078e00ffULL,
0x00006a0004098624ULL, 0x000fe400078e0209ULL, 0xffffffffff047424ULL, 0x000fe400078e00ffULL,
0x0000000106098824ULL, 0x000fe200078e0209ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040c05ff738cULL, 0x0003e20000000000ULL, 0x00006600090a8625ULL, 0x000fe200078e0042ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060a048981ULL, 0x000ea2000c1e1900ULL,
0x000001ff1000780cULL, 0x000fe20003f04070ULL, 0x0000004078747824ULL, 0x000fe200078e00ffULL,
0x00000001ff737819ULL, 0x000fe20000011600ULL, 0x0000000005ff7f8cULL, 0x0007e8000c80043fULL,
0x00000020737c7824ULL, 0x000fca00078e00ffULL, 0x0000002074097812ULL, 0x000fe200078ef87cULL,
0x00005900040c7a24ULL, 0x006fe200078e02ffULL, 0x0000000100047812ULL, 0x000fc600078ec0ffULL,
0x000000400c197824ULL, 0x000fe200078e00ffULL, 0x0000040000000947ULL, 0x000fea0003800000ULL,
0x0000007c02057217ULL, 0x008fe20007800000ULL, 0x00000010040a7824ULL, 0x000fe200078e00ffULL,
0x00000003ff0b7819ULL, 0x000fe40000011649ULL, 0x0000640019137a11ULL, 0x000fe200078838ffULL,
0x0000000105057824ULL, 0x000fe200078e0a7cULL, 0x000000040b0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000010a0c7824ULL, 0x000fe200078e020bULL, 0x0000000c0b0f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000a05057217ULL, 0x000fe20007800000ULL, 0x000000010c0d7824ULL, 0x040fe200078e0249ULL,
0x0000650019197a11ULL, 0x000fe200020f3cffULL, 0x000000080c127824ULL, 0x000fc400078e00ffULL,
0x0000000105057824ULL, 0x000fe400078e0a0aULL, 0x000000010a187824ULL, 0x000fe200078e020fULL,
0xfffffff812127812ULL, 0x000fe400078ee20dULL, 0x000000080b0d7810ULL, 0x000fe40007ffe0ffULL,
0x000000050e00720cULL, 0x080fe20003f46070ULL, 0x000000010a0e7824ULL, 0x040fe200078e020eULL,
0x000000050d00720cULL, 0x080fe20003f26070ULL, 0x000000010a107824ULL, 0x000fe200078e020dULL,
0x000000050b00720cULL, 0x080fe20003f66070ULL, 0x000000010e0a7824ULL, 0x040fe200078e0249ULL,
0x000000050f00720cULL, 0x000fe20003f06070ULL, 0x000000080e0d7824ULL, 0x000fc400078e00ffULL,
0x00000001090b7824ULL, 0x000fe400078e020cULL, 0x00000001100c7824ULL, 0x040fe200078e0249ULL,
0xfffffff80d147812ULL, 0x000fe200078ee20aULL, 0x0000000810117824ULL, 0x000fe400078e00ffULL,
0x000000800b0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff811167812ULL, 0x000fe200078ee20cULL,
0x00000001090c7824ULL, 0x040fe200078e020eULL, 0x000000700a0a7812ULL, 0x000fe200078ef808ULL,
0x00000001090e7824ULL, 0x040fe400078e0210ULL, 0x0000000109107824ULL, 0x000fe200078e0218ULL,
0x0000000a130a7210ULL, 0x000fe20007f9e0ffULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x0000000118057824ULL, 0x000fe200078e0249ULL, 0x000000700c097812ULL, 0x000fe200078ef808ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000000818187824ULL, 0x000fe200078e00ffULL,
0x000000700e0c7812ULL, 0x000fe200078ef808ULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee205ULL, 0x000000010b0b7824ULL, 0x000fe200020e0619ULL,
0x00000070100e7812ULL, 0x000fe400078ef808ULL, 0x0000b00073057811ULL, 0x000fe400078e68ffULL,
0x0000001309087210ULL, 0x080fe40007f9e0ffULL, 0x000000130c0c7210ULL, 0x080fe20007fbe0ffULL,
0x0000001014157824ULL, 0x100fe200078e0205ULL, 0x000000130e0e7210ULL, 0x000fe20007fde0ffULL,
0x0000001012137824ULL, 0x000fc400078e0205ULL, 0x000000010d097824ULL, 0x000fe400020e0619ULL,
0x0000001016177824ULL, 0x000fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a137faeULL, 0x0003e2000d901c46ULL, 0x000000010f0d7824ULL, 0x000fe400028e0619ULL,
0x0000001018057824ULL, 0x000fe200078e0205ULL, 0x0000000008157faeULL, 0x0003e2000d101c46ULL,
0x00000001110f7824ULL, 0x000fc600030e0619ULL, 0x000000000c177faeULL, 0x0003e8000c901c46ULL,
0x000000000e057faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010040a7824ULL, 0x008fe200078e00ffULL, 0x0000640019157a11ULL, 0x000fe400078038ffULL,
0x0000b00073177811ULL, 0x000fe400078e68ffULL, 0x0000000a490a7211ULL, 0x000fc400078fe8ffULL,
0x0000650019197a11ULL, 0x000fe400000f3cffULL, 0x000000040a0c7810ULL, 0x040fe20007ffe0ffULL,
0x000000010a057824ULL, 0x140fe200078e0249ULL, 0x000000080a0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000080a107824ULL, 0x000fe400078e00ffULL, 0x00000001090b7824ULL, 0x000fe400078e020aULL,
0x000000010c0d7824ULL, 0x000fe200078e0249ULL, 0xfffffff810057812ULL, 0x000fe200078ee205ULL,
0x000000080c127824ULL, 0x000fe200078e00ffULL, 0x0000000c0a107810ULL, 0x000fe20007ffe0ffULL,
0x000000800b0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee20dULL,
0x000000010e0f7824ULL, 0x000fe200078e0249ULL, 0x000000700a0a7812ULL, 0x000fe200078ef808ULL,
0x000000080e147824ULL, 0x000fe400078e00ffULL, 0x00000001090c7824ULL, 0x000fe200078e020cULL,
0x0000000a150a7210ULL, 0x000fe20007f1e0ffULL, 0x00000001090e7824ULL, 0x040fe200078e020eULL,
0xfffffff814147812ULL, 0x000fe200078ee20fULL, 0x0000000109117824ULL, 0x000fe400078e0210ULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x0000000110097824ULL, 0x000fe200078e0249ULL,
0x000000700c137812ULL, 0x000fe200078ef808ULL, 0x0000000810167824ULL, 0x000fe400078e00ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff816097812ULL, 0x000fe200078ee209ULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0x000000700e0c7812ULL, 0x000fc600078ef808ULL,
0x000000010b0b7824ULL, 0x000fe200000e0619ULL, 0x00000070100e7812ULL, 0x000fe200078ef808ULL,
0x0000001005057824ULL, 0x100fe200078e0217ULL, 0x0000001315087210ULL, 0x040fe20007f1e0ffULL,
0x0000001012137824ULL, 0x100fe200078e0217ULL, 0x0000000c150c7210ULL, 0x040fe40007f3e0ffULL,
0x0000000e150e7210ULL, 0x000fe20007f5e0ffULL, 0x0000001014157824ULL, 0x100fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a057faeULL, 0x0003e2000b901c46ULL,
0x0000001009177824ULL, 0x000fc400078e0217ULL, 0x000000010d097824ULL, 0x100fe400000e0619ULL,
0x000000010f0d7824ULL, 0x100fe400008e0619ULL, 0x00000001110f7824ULL, 0x000fe200010e0619ULL,
0x0000000008137faeULL, 0x0003e8000b901c46ULL, 0x000000000c157faeULL, 0x0003e8000b901c46ULL,
0x000000000e177faeULL, 0x0003e4000b901c46ULL, 0x0000000106097810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff107424ULL, 0x000fc600078e00ffULL, 0x000000030900720cULL, 0x000fda0003f06070ULL,
0x0000000207058824ULL, 0x000fe400078e00ffULL, 0x00006a00ff068624ULL, 0x000fc800078e00ffULL,
0x00006a0005068624ULL, 0x000fe400078e0206ULL, 0x0000001073057824ULL, 0x000fe400078e00ffULL,
0x0000000106438824ULL, 0x000fe400078e0209ULL, 0x00000000050473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000660043428625ULL, 0x000fca00078e0042ULL,
0x0000000642108981ULL, 0x000522000c1e1900ULL, 0x000000ff7100720cULL, 0x000fe20003f05270ULL,
0x00000008730a7824ULL, 0x000fe200078e00ffULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0x0000f6a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6a800050e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6c8000a0a7f8cULL, 0x000ee2000c80043fULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000d9c000008947ULL, 0x000fea0003800000ULL, 0x0000001005067812ULL, 0x000fe200078ec0ffULL,
0x0000000207757824ULL, 0x000fc400078e00ffULL, 0x00006a00ff087624ULL, 0x000fe400078e00ffULL,
0x0000002077057824ULL, 0x002fe400078e0206ULL, 0x000000ffff0e7224ULL, 0x004fe400078e000fULL,
0x00006a0075757624ULL, 0x000fe400078e0208ULL, 0x000000ffff0d7224ULL, 0x008fe400078e000bULL,
0x0000000804087824ULL, 0x000fc400078e0205ULL, 0xff317217ff0f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff487224ULL, 0x000fe400078e00ffULL, 0x000000ffff377224ULL, 0x000fc400078e00ffULL,
0x000000ffff637224ULL, 0x00afca00078e0009ULL, 0x00000000000a7805ULL, 0x000fc40000015200ULL,
0x0000000400077824ULL, 0x000fca00078e00ffULL, 0xfffffff807117812ULL, 0x000fc800078ec0ffULL,
0x0000f6c811077810ULL, 0x000fe20007ffe0ffULL, 0x00f6cc0011127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120a297210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0bULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000002912127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc0011127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010000a7824ULL, 0x000fe200078e00ffULL,
0x0000000148127810ULL, 0x000fe20007ffe0ffULL, 0x0000590010107a24ULL, 0x010fc600078e02ffULL,
0xffffffe00a0b7812ULL, 0x000fe200078ec0ffULL, 0x00000040103f7824ULL, 0x000fe200078e00ffULL,
0x000000711200720cULL, 0x000fc60003f26070ULL, 0x00000100480b7824ULL, 0x000fca00078e020bULL,
0x000000400b0d7810ULL, 0x000fc80007ffe0ffULL, 0x000000200d0b7812ULL, 0x000fca00078ec0ffULL,
0x0000000174297824ULL, 0x000fe200078e020bULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x000000100a0b7812ULL, 0x000fe200078ec0ffULL, 0x0000001049137824ULL, 0x000fe200078e00ffULL,
0x0000000d020a7217ULL, 0x000fe40007800000ULL, 0x00000003ff117819ULL, 0x000fe40000011649ULL,
0x0000007013417812ULL, 0x000fe200078ec0ffULL, 0x000000010a0a7824ULL, 0x000fe200078e0a0dULL,
0x0000000411127810ULL, 0x040fe20007ffe0ffULL, 0x0000000111107824ULL, 0x040fe200078e020bULL,
0x00000008112a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000b0a0a7217ULL, 0x000fe20007800000ULL,
0x00000001100d7824ULL, 0x040fe200078e0249ULL, 0x000064003f3d7a11ULL, 0x040fe200078a38ffULL,
0x0000000810287824ULL, 0x000fe400078e00ffULL, 0x000000010a0a7824ULL, 0x000fe200078e0a0bULL,
0x000065003f3f7a11ULL, 0x000fe400028f3cffULL, 0xfffffff8280d7812ULL, 0x000fe400078ee20dULL,
0x0000000a1100720cULL, 0x000fc40003f86070ULL, 0x0000000c11117810ULL, 0x000fe40007ffe0ffULL,
0x0000000a1200720cULL, 0x0c0fe20003f66070ULL, 0x0000000112127824ULL, 0x100fe200078e020bULL,
0x0000000a2a00720cULL, 0x0c0fe20003f46070ULL, 0x000000012a2a7824ULL, 0x100fe200078e020bULL,
0x0000000a1100720cULL, 0x040fe20003f06070ULL, 0x00000001112c7824ULL, 0x000fe400078e020bULL,
0x00000001120b7824ULL, 0x040fe400078e0249ULL, 0x0000000812287824ULL, 0x000fc400078e00ffULL,
0x00000001290a7824ULL, 0x040fe400078e0210ULL, 0x0000000129107824ULL, 0x000fe200078e022aULL,
0xfffffff8282b7812ULL, 0x000fe200078ee20bULL, 0x000000800a0a7825ULL, 0x000fc800078e00ffULL,
0x0000000129287824ULL, 0x040fe200078e0212ULL, 0x000000410a0a7212ULL, 0x000fe200078efcffULL,
0x0000000129127824ULL, 0x000fe400078e022cULL, 0x000000012a117824ULL, 0x040fe200078e0249ULL,
0x0000000a3d0a7210ULL, 0x000fe20007fbe0ffULL, 0x000000082a2e7824ULL, 0x000fe400078e00ffULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff82e2d7812ULL, 0x000fe200078ee211ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000004128287212ULL, 0x000fc600078efcffULL,
0x000000012c2a7824ULL, 0x000fe200078e0249ULL, 0x0000004110107212ULL, 0x000fe200078efcffULL,
0x000000082c2f7824ULL, 0x000fe400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee22aULL, 0x000000010b0b7824ULL, 0x100fe200028e063fULL,
0x0000003d28287210ULL, 0x000fe40007fbe0ffULL, 0x0000004112127212ULL, 0x000fe400078efcffULL,
0x0000c000732a7811ULL, 0x000fe200078e68ffULL, 0x0000000129297824ULL, 0x000fe200028e063fULL,
0x0000003d10107210ULL, 0x080fe40007fbe0ffULL, 0x0000003d12127210ULL, 0x000fe20007fde0ffULL,
0x000000100d0d7824ULL, 0x000fc400078e022aULL, 0x000000102b2b7824ULL, 0x100fe400078e022aULL,
0x000000102d2d7824ULL, 0x100fe200078e022aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000e101c46ULL, 0x0000000111117824ULL, 0x100fe400028e063fULL,
0x000000102f2f7824ULL, 0x000fe200078e022aULL, 0x00000000282b7faeULL, 0x0003e2000d901c46ULL,
0x0000000113137824ULL, 0x000fc600030e063fULL, 0x00000000102d7faeULL, 0x0003e8000d101c46ULL,
0x00000000122f7faeULL, 0x0003e2000c101c46ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x000000100a0a7812ULL, 0x000fe400078ec0ffULL, 0x000064003f2f7a11ULL, 0x000fe400078038ffULL,
0x0000000a490a7211ULL, 0x000fe400078fe8ffULL, 0x000065003f3f7a11ULL, 0x000fc400000f3cffULL,
0x000000040a107810ULL, 0x040fe20007ffe0ffULL, 0x000000010a0b7824ULL, 0x140fe200078e0249ULL,
0x000000080a127810ULL, 0x040fe20007ffe0ffULL, 0x000000080a287824ULL, 0x000fe200078e00ffULL,
0x0000c000733d7811ULL, 0x000fe200078e68ffULL, 0x0000000110117824ULL, 0x040fe400078e0249ULL,
0x00000008102a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8280d7812ULL, 0x000fe200078ee20bULL,
0x00000001290b7824ULL, 0x000fe200078e020aULL, 0x0000000c0a287810ULL, 0x000fe20007ffe0ffULL,
0x0000000112137824ULL, 0x000fe200078e0249ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee211ULL,
0x0000001049117824ULL, 0x000fc400078e00ffULL, 0x000000800b0a7825ULL, 0x000fc600078e00ffULL,
0x00000070112d7812ULL, 0x000fe200078ec0ffULL, 0x00000008122c7824ULL, 0x000fe400078e00ffULL,
0x0000000129107824ULL, 0x040fe200078e0210ULL, 0x0000002d0a0a7212ULL, 0x000fe200078efcffULL,
0x0000000129127824ULL, 0x040fe200078e0212ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee213ULL,
0x0000000129297824ULL, 0x000fe200078e0228ULL, 0x0000000a2f0a7210ULL, 0x000fe20007f1e0ffULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x00000001282b7824ULL, 0x000fe200078e0249ULL,
0x0000002d10107212ULL, 0x000fe200078efcffULL, 0x00000008282e7824ULL, 0x000fe400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee22bULL,
0x0000008029287825ULL, 0x000fe200078e00ffULL, 0x0000002d12127212ULL, 0x000fc600078efcffULL,
0x000000010b0b7824ULL, 0x000fe200000e063fULL, 0x0000002d28287212ULL, 0x000fe200078efcffULL,
0x000000100d0d7824ULL, 0x100fe200078e023dULL, 0x000000102f107210ULL, 0x040fe20007f1e0ffULL,
0x000000102a2b7824ULL, 0x100fe200078e023dULL, 0x000000122f127210ULL, 0x040fe20007f5e0ffULL,
0x000000102c2d7824ULL, 0x000fe200078e023dULL, 0x000000282f287210ULL, 0x000fe20007f7e0ffULL,
0x0000000111117824ULL, 0x100fe200000e063fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000b901c46ULL, 0x0000000113137824ULL, 0x000fc400010e063fULL,
0x000000102e2f7824ULL, 0x000fe200078e023dULL, 0x00000000102b7faeULL, 0x0003e2000b901c46ULL,
0x0000000129297824ULL, 0x000fc600018e063fULL, 0x00000000122d7faeULL, 0x0003e8000b901c46ULL,
0x00000000282f7faeULL, 0x0003e4000b901c46ULL, 0x00000008000a7824ULL, 0x002fe200078e00ffULL,
0x0000000109107810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff447424ULL, 0x000fc600078e00ffULL,
0xfffffff00a0d7812ULL, 0x000fe400078ec0ffULL, 0x000000031000720cULL, 0x000fe40003f06070ULL,
0x000000000d0473c2ULL, 0x000e6200000e0000ULL, 0xffffffe00a0b7812ULL, 0x040fe400078ec0ffULL,
0x000000100a127812ULL, 0x040fe400078ec0ffULL, 0x000000080a0a7812ULL, 0x000fcc00078ec0ffULL,
0x0000000175108824ULL, 0x000fe400078e0210ULL, 0x00000004ff118424ULL, 0x000fe200078e00ffULL,
0x0000000b0a0a7210ULL, 0x000fe40007ffe012ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000660010108625ULL, 0x000fca00078e0011ULL, 0x0000000610448981ULL, 0x000522000c1e1900ULL,
0x0000f6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6b0000d107f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f608000a2a7f8cULL, 0x000664000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x00f60c000a0b7984ULL, 0x000ee40000000800ULL, 0x800000000bff7812ULL, 0x00afe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002812287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e13ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011429ULL,
0x000000280b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x000000020b0b7819ULL, 0x000fc80000001228ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60c000a0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010494f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff647819ULL, 0x000fe20000011649ULL,
0x00000020000b7824ULL, 0x000fe400078e00ffULL, 0xffffffffff6e7424ULL, 0x000fe200078e00ffULL,
0x000000704f4f7812ULL, 0x000fc400078ec0ffULL, 0xffffff800b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c64647812ULL, 0x000fc800078ec0ffULL, 0x0000000b640b7210ULL, 0x000fca0007ffe04fULL,
0x00f000000b287984ULL, 0x000e680000000800ULL, 0x00f200000b297984ULL, 0x0006a20000000800ULL,
0x0000000f2800720bULL, 0x002fe20003f1d000ULL, 0x00014ac27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0d2b7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fc400078e000fULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff6f7424ULL, 0x000fca00078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000007700720cULL, 0x000fe40003f05270ULL, 0x0000000f2800720bULL, 0x000fe20003f54000ULL,
0x00014a527f007947ULL, 0x000fd8000b800000ULL, 0x00000000002a7806ULL, 0x000fc400010e0100ULL,
0x00000080000d8824ULL, 0x000fe200078e024fULL, 0x0000000f280b7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x0000000164128824ULL, 0x000fe200078e020dULL,
0x000099102a0d7816ULL, 0x000fc800000000ffULL, 0x00f4000b12008388ULL, 0x0003e20000000800ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000f0b0d7221ULL, 0x002fe20000010100ULL, 0x000000ff2aff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d002c7308ULL, 0x000e640000000800ULL, 0x0000002c0c0c7220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011649ULL,
0x000149827f007947ULL, 0x000fea000b800000ULL, 0x00001f0d2c0d7589ULL, 0x0002e400000e0000ULL,
0x0000000d24247220ULL, 0x08cfe20000410000ULL, 0x0000000d25257220ULL, 0x080fe20000410000ULL,
0x0000000d38387220ULL, 0x080fe20000410000ULL, 0x0000000d39397220ULL, 0x080fe20000410000ULL,
0x0000000d14147220ULL, 0x080fe20000410000ULL, 0x0000000d15157220ULL, 0x080fe20000410000ULL,
0x0000000d20207220ULL, 0x080fe20000410000ULL, 0x0000000d21217220ULL, 0x080fe20000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000d1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000d18187220ULL, 0x080fe20000410000ULL, 0x0000000d19197220ULL, 0x080fe20000410000ULL,
0x0000000d30307220ULL, 0x080fe20000410000ULL, 0x0000000d31317220ULL, 0x080fe20000410000ULL,
0x0000000d34347220ULL, 0x080fe20000410000ULL, 0x0000000d35357220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff002aff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008490d7811ULL, 0x000fe200078ff0ffULL,
0x000148627f007947ULL, 0x000fea000b800000ULL, 0x00001f0d2c0d7589ULL, 0x00066400000e0000ULL,
0x0000000d26267220ULL, 0x086fe20000410000ULL, 0x0000000d27277220ULL, 0x080fe20000410000ULL,
0x0000000d3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000d3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000d16167220ULL, 0x080fe20000410000ULL, 0x0000000d17177220ULL, 0x080fe20000410000ULL,
0x0000000d22227220ULL, 0x080fe20000410000ULL, 0x0000000d23237220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000d1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000d32327220ULL, 0x080fe20000410000ULL, 0x0000000d33337220ULL, 0x080fe20000410000ULL,
0x0000000d36367220ULL, 0x080fe20000410000ULL, 0x0000000d37377220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff2bff7812ULL, 0x000fe2000780602aULL,
0x00000001ff0d7424ULL, 0x000fd800078e00ffULL, 0x8000000b28280221ULL, 0x000fe20000010000ULL,
0x00007610ff0d0816ULL, 0x000fc6000000000dULL, 0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL,
0x0000002800060308ULL, 0x000e640000000800ULL, 0x0000000629290220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000c290c7221ULL, 0x004fc20000010000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x00000008000f7824ULL, 0x000fca00078e00ffULL,
0xfffffff00f2a7812ULL, 0x000fca00078ec0ffULL, 0x00f6ac002a0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780480eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002812287210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e13ULL,
0x003d09002800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011429ULL, 0x000000280f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff287224ULL, 0x000fca00000e0629ULL, 0x000000020f0f7819ULL, 0x000fc80000001228ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012b2b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac002a0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780480eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100d0d7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000006ff04723eULL, 0x000fe400000010ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011649ULL, 0x00005410040e7816ULL, 0x000fe20000000004ULL,
0x000144227f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0e057589ULL, 0x0002a400000e0000ULL,
0x000000080f0d7810ULL, 0x000fe20007ffe0ffULL, 0x000144527f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0e047589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100f0d7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e000eULL,
0x0000314000137802ULL, 0x000fc40000000f00ULL, 0x00014e3000007944ULL, 0x01cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180f0d7810ULL, 0x006fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e000eULL, 0x0000319000137802ULL, 0x000fc40000000f00ULL,
0x00014de000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002005b7824ULL, 0x040fe200078e00ffULL, 0x00000007490d7812ULL, 0x046fe200078ec0ffULL,
0x00000200004d7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000008494a7812ULL, 0x000fc400078ec0ffULL, 0x000000045b0e7812ULL, 0x000fe400078ec0ffULL,
0x000000080d537812ULL, 0x000fe400078ef849ULL, 0x0000000e490e7211ULL, 0x000fe400078fe0ffULL,
0xfffff8004d4d7812ULL, 0x000fe200078ec0ffULL, 0x00000008530f7824ULL, 0x040fe400078e00ffULL,
0x0000000153767824ULL, 0x000fca00078e020eULL, 0xfffffff80f627812ULL, 0x000fca00078ee276ULL,
0x0000001062627824ULL, 0x000fc800078e00ffULL, 0x00000001624e7824ULL, 0x000fc400078e024dULL,
0x00000004000e7824ULL, 0x000fe200078e00ffULL, 0x00000004ff5f7819ULL, 0x000fe40000011649ULL,
0x0000000d4a3d7212ULL, 0x000fe400078efcffULL, 0x000000040e0e7812ULL, 0x000fe400078ec0ffULL,
0x0000b000735d7811ULL, 0x000fe200078e68ffULL, 0x000000083d457824ULL, 0x000fe200078e00ffULL,
0x000000104a4a7812ULL, 0x000fe200078efe0dULL, 0x000000015f0e7824ULL, 0x000fe200078e020eULL,
0xfffffff85b5b7812ULL, 0x000fc600078ec0ffULL, 0x000000013d3e7824ULL, 0x000fe400078e020eULL,
0x000000084a0d7824ULL, 0x000fe400078e00ffULL, 0x000000010e567824ULL, 0x000fe200078e024aULL,
0xfffffff845457812ULL, 0x000fc800078ee23eULL, 0xfffffff80d4c7812ULL, 0x000fe200078ee256ULL,
0x0000001045407824ULL, 0x000fc800078e025dULL, 0x000000104c2c7824ULL, 0x008fe400078e025dULL,
0x000000004040783bULL, 0x000e680000004200ULL, 0x000000002c2c783bULL, 0x000fe20000004200ULL,
0x00000100403c7824ULL, 0x002fe200078e00ffULL, 0x0000004000287306ULL, 0x000fe20000009400ULL,
0x0000010041697824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011440ULL,
0x00000100436d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x0000004000297306ULL, 0x000e620000005400ULL,
0x0000003c006b7245ULL, 0x000fe4000020d400ULL, 0x00000018ff557819ULL, 0x000fe40000011441ULL,
0x00000018ff6d7819ULL, 0x000fc6000001146dULL, 0x0000003c002a7306ULL, 0x000ff00000209400ULL,
0x0000003c002b7306ULL, 0x000ea20000205400ULL, 0x000000292800720bULL, 0x002fce0003f5d000ULL,
0x0000006900547306ULL, 0x000ff00000209400ULL, 0x00000069003f7306ULL, 0x000e620000205400ULL,
0x0000002b2a00720bULL, 0x004fe40003f7d000ULL, 0x009000004e28783bULL, 0x000eaa0000000200ULL,
0x00000041004b7306ULL, 0x000fec0000009400ULL, 0x000000016b6b3812ULL, 0x000fc400078efcffULL,
0x00000041005c7306ULL, 0x000ee20000005400ULL, 0x0000003f5400720bULL, 0x002fe20003fbd000ULL,
0x0001000040547824ULL, 0x000fca00078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x00000040006a7306ULL, 0x000e70000000d400ULL, 0x0000004100127306ULL, 0x000ea2000000d400ULL,
0x0000005c4b00720bULL, 0x008fe20003f9d000ULL, 0x000000083d5c7824ULL, 0x000fe200078e00ffULL,
0x000000023e4b7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff85c4b7812ULL, 0x000fe200078ee24bULL,
0x0000005500687306ULL, 0x000fe20000205400ULL, 0x000000016a6a2812ULL, 0x002fe200078efcffULL,
0x0000000528288231ULL, 0x084fe400003400ffULL, 0x000000104b3d7824ULL, 0x000fe200078e025dULL,
0x0000006a6b40723eULL, 0x000fe200000010ffULL, 0x000000052a2a8231ULL, 0x000fe200003400ffULL,
0x00000069006b7245ULL, 0x000fe2000020d400ULL, 0x0001000041697824ULL, 0x000fe200078e00ffULL,
0x0000000112124812ULL, 0x000fe200078efcffULL, 0x00000055005c7306ULL, 0x0002a20000209400ULL,
0x000000016b6b5812ULL, 0x000fe200078efcffULL, 0x000000003d3c783bULL, 0x000ee20000004200ULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0000000429298231ULL, 0x080fe200003400ffULL,
0x000000126b41723eULL, 0x000fe200000010ffULL, 0x000000042b2b8231ULL, 0x000fc400003400ffULL,
0x00000069006b7306ULL, 0x000fe20000209400ULL, 0x0000005500557245ULL, 0x002fc8000020d400ULL,
0x000000402824723cULL, 0x000f660000041824ULL, 0x00000069006c7306ULL, 0x000e620000205400ULL,
0x000000685c00720bULL, 0x004fce0003fbd000ULL, 0x00000060005a7306ULL, 0x000fec0000209400ULL,
0x0000000155555812ULL, 0x000fe400078efcffULL, 0x0000006000577306ULL, 0x0004e20000205400ULL,
0x0000006c6b00720bULL, 0x002fe20003f9d000ULL, 0x00000100426c7824ULL, 0x000fe200078e00ffULL,
0x00000054006b7245ULL, 0x000fc8000020d400ULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x0000005400677306ULL, 0x000fe20000209400ULL, 0x0000006000607245ULL, 0x004fce000020d400ULL,
0x00000054006a7306ULL, 0x000e620000205400ULL, 0x000000575a00720bULL, 0x008fce0003f7d000ULL,
0x0000004300657306ULL, 0x000fec0000009400ULL, 0x0000000160603812ULL, 0x000fe400078efcffULL,
0x0000006a6700720bULL, 0x002fe20003f5d000ULL, 0x0000004300667306ULL, 0x000e620000005400ULL,
0x00000069006a7245ULL, 0x000fc8000020d400ULL, 0x000000016a6a4812ULL, 0x000fc600078efcffULL,
0x0000006c00677306ULL, 0x000fe20000209400ULL, 0x0000006a5555723eULL, 0x000fc600000010ffULL,
0x000000016b6b2812ULL, 0x000fc800078efcffULL, 0x0000006c00687306ULL, 0x000ea20000205400ULL,
0x0000006b6054723eULL, 0x000fe400000010ffULL, 0x000000666500720bULL, 0x002fe20003f9d000ULL,
0x0001000042657824ULL, 0x000fc800078e00ffULL, 0x0000006d00697306ULL, 0x000fe20000209400ULL,
0x000000542838723cULL, 0x000be20000041838ULL, 0x00000018ff657819ULL, 0x000fcc0000011465ULL,
0x0000006d006a7306ULL, 0x000e620000205400ULL, 0x00000018ff557819ULL, 0x020fe40000011442ULL,
0x000000686700720bULL, 0x004fe40003f7d000ULL, 0x00000018ff547819ULL, 0x000fc60000011443ULL,
0x00000042005e7306ULL, 0x000ff00000009400ULL, 0x0000004200617306ULL, 0x000ea20000005400ULL,
0x0000006a6900720bULL, 0x002fe20003fbd000ULL, 0x00010000436a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000005500667306ULL, 0x000ff00000209400ULL,
0x0000005500677306ULL, 0x0002e20000205400ULL, 0x000000615e00720bULL, 0x004fce0003f5d000ULL,
0x0000004200597306ULL, 0x0004e2000000d400ULL, 0x0000005500557245ULL, 0x002fce000020d400ULL,
0x0000004300587306ULL, 0x000262000000d400ULL, 0x0000006c00427245ULL, 0x004fe4000020d400ULL,
0x000000676600720bULL, 0x008fe20003fdd000ULL, 0x000001003c667824ULL, 0x000fe200078e00ffULL,
0x0000000142423812ULL, 0x000fe200078efcffULL, 0x000001003d677824ULL, 0x000fe400078e00ffULL,
0x0000006500697306ULL, 0x000fe20000209400ULL, 0x0000006d00437245ULL, 0x002fe4000020d400ULL,
0x00000018ff667819ULL, 0x000fc40000011466ULL, 0x0000000159592812ULL, 0x000fe400078efcffULL,
0x0000000143435812ULL, 0x000fe200078efcffULL, 0x00000065006b7306ULL, 0x000e620000205400ULL,
0x0000000158584812ULL, 0x000fe400078efcffULL, 0x000000594242723eULL, 0x000fe400000010ffULL,
0x000000584343723eULL, 0x000fe400000010ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000006a006c7306ULL, 0x000fe20000209400ULL, 0x0000000155556812ULL, 0x000fc600078efcffULL,
0x000000422814723cULL, 0x000b680000041814ULL, 0x0000006a006d7306ULL, 0x0004e20000205400ULL,
0x0000006b6900720bULL, 0x002fe40003f9d000ULL, 0x0000006500427245ULL, 0x020fe4000020d400ULL,
0x0000006a00437245ULL, 0x000fe4000020d400ULL, 0x00000018ff657819ULL, 0x000fe2000001143cULL,
0x0000005400617306ULL, 0x000fe20000209400ULL, 0x000100003d6a7824ULL, 0x004fca00078e00ffULL,
0x0000000142424812ULL, 0x000fe400078efcffULL, 0x0000005400687306ULL, 0x0002a20000205400ULL,
0x0000006d6c00720bULL, 0x008fe40003fbd000ULL, 0x000000425542723eULL, 0x000fe400000010ffULL,
0x00000018ff6a7819ULL, 0x000fc6000001146aULL, 0x0000003c005c7306ULL, 0x000fe20000009400ULL,
0x0000005400547245ULL, 0x002fca000020d400ULL, 0x0000000143435812ULL, 0x000fe400078efcffULL,
0x0000003c005a7306ULL, 0x000e620000005400ULL, 0x000000686100720bULL, 0x004fce0003f7d000ULL,
0x00000066006c7306ULL, 0x000fec0000209400ULL, 0x0000000154543812ULL, 0x000fe400078efcffULL,
0x0000006600697306ULL, 0x000ea20000205400ULL, 0x0000005a5c00720bULL, 0x002fe40003f5d000ULL,
0x000000435443723eULL, 0x000fc400000010ffULL, 0x00000018ff547819ULL, 0x000fc6000001142cULL,
0x0000003d00607306ULL, 0x000fe40000009400ULL, 0x000000422820723cULL, 0x000b6c0000041820ULL,
0x0000003d005e7306ULL, 0x000e620000005400ULL, 0x000000696c00720bULL, 0x004fe40003f7d000ULL,
0x0000006600427245ULL, 0x020fc4000020d400ULL, 0x0000006700437245ULL, 0x000fc6000020d400ULL,
0x0000006700687306ULL, 0x000fec0000209400ULL, 0x0000000142423812ULL, 0x000fe400078efcffULL,
0x00000067006b7306ULL, 0x000ea20000205400ULL, 0x0000005e6000720bULL, 0x002fce0003fdd000ULL,
0x0000003c00577306ULL, 0x000e70000000d400ULL, 0x0000003d00587306ULL, 0x000ee2000000d400ULL,
0x0000006b6800720bULL, 0x004fe40003f9d000ULL, 0x0000000157572812ULL, 0x002fca00078efcffULL,
0x0000003e00597306ULL, 0x000fe20000009400ULL, 0x000000574242723eULL, 0x000fe200000010ffULL,
0x000100003c577824ULL, 0x000fc800078e00ffULL, 0x0000000143434812ULL, 0x000fe400078efcffULL,
0x0000000158586812ULL, 0x008fe200078efcffULL, 0x0000003e005c7306ULL, 0x000e620000005400ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x000000584343723eULL, 0x000fe400000010ffULL,
0x00000018ff3c7819ULL, 0x000fc6000001143dULL, 0x0000005700687306ULL, 0x000fe40000209400ULL,
0x00000042281c723cULL, 0x000b6c000004181cULL, 0x0000005700697306ULL, 0x000ea20000205400ULL,
0x0000005c5900720bULL, 0x002fe40003f9d000ULL, 0x00000018ff427819ULL, 0x020fca000001143eULL,
0x0000003f00617306ULL, 0x000ff00000009400ULL, 0x0000003f00607306ULL, 0x000e620000005400ULL,
0x000000696800720bULL, 0x004fce0003fdd000ULL, 0x0000003c00587306ULL, 0x000ff00000209400ULL,
0x0000003c00437306ULL, 0x000ea20000205400ULL, 0x000000606100720bULL, 0x002fce0003f7d000ULL,
0x0000006500667306ULL, 0x000ff00000209400ULL, 0x0000006500677306ULL, 0x0002e20000205400ULL,
0x000000435800720bULL, 0x004fe40003f5d000ULL, 0x00000018ff437819ULL, 0x000fc4000001143fULL,
0x0000005700587245ULL, 0x000fe2000020d400ULL, 0x000001003e577824ULL, 0x000fe400078e00ffULL,
0x0000006a006b7306ULL, 0x000fe20000209400ULL, 0x0000000158586812ULL, 0x000fe400078efcffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000006500657245ULL, 0x002fc6000020d400ULL,
0x0000006a005c7306ULL, 0x0002a20000205400ULL, 0x000000676600720bULL, 0x008fe40003fbd000ULL,
0x0000005700677245ULL, 0x000fca000020d400ULL, 0x00000042003d7306ULL, 0x000fe20000209400ULL,
0x0000006a006a7245ULL, 0x002fca000020d400ULL, 0x0000000165655812ULL, 0x000fe400078efcffULL,
0x0000004200607306ULL, 0x000e620000205400ULL, 0x0000005c6b00720bULL, 0x004fce0003fdd000ULL,
0x0000004300597306ULL, 0x000fec0000209400ULL, 0x000000016a6a6812ULL, 0x000fe400078efcffULL,
0x0000004300667306ULL, 0x000ea20000205400ULL, 0x000000603d00720bULL, 0x002fe20003fbd000ULL,
0x000001003f3d7824ULL, 0x000fc400078e00ffULL, 0x000100003e607824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x00000057005c7306ULL, 0x000fe20000209400ULL,
0x00000018ff607819ULL, 0x000fce0000011460ULL, 0x0000005700617306ULL, 0x000e620000205400ULL,
0x000000665900720bULL, 0x004fe40003fdd000ULL, 0x0000003c00597245ULL, 0x000fc8000020d400ULL,
0x0000000159592812ULL, 0x000fe200078efcffULL, 0x0000003d00667306ULL, 0x000ff00000209400ULL,
0x0000003d00697306ULL, 0x0004e20000205400ULL, 0x000000615c00720bULL, 0x002fe20003f5d000ULL,
0x000100003f617824ULL, 0x000fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000003e005a7306ULL, 0x000262000000d400ULL, 0x0000003d003d7245ULL, 0x004fca000020d400ULL,
0x0000000167672812ULL, 0x000fe400078efcffULL, 0x0000003f005e7306ULL, 0x000ea2000000d400ULL,
0x000000696600720bULL, 0x008fe40003f5d000ULL, 0x00000058653e723eULL, 0x002fe200000010ffULL,
0x000000084a657824ULL, 0x000fe200078e00ffULL, 0x00000002564a7810ULL, 0x000fe40007ffe0ffULL,
0x00000018ff587819ULL, 0x000fe2000001142dULL, 0x00000060003c7306ULL, 0x000fe20000209400ULL,
0x000000015a5a4812ULL, 0x000fc400078efcffULL, 0xfffffff8654a7812ULL, 0x000fc600078ee24aULL,
0x000000013d3d2812ULL, 0x000fe400078efcffULL, 0x00000060003f7306ULL, 0x000e620000205400ULL,
0x000000015e5e3812ULL, 0x004fc800078efcffULL, 0x0000005e3d3d723eULL, 0x000fc600000010ffULL,
0x00000061005c7306ULL, 0x000ff00000209400ULL, 0x0000006100697306ULL, 0x000ea20000205400ULL,
0x0000003f3c00720bULL, 0x002fe40003f9d000ULL, 0x0000006a593f723eULL, 0x000fc400000010ffULL,
0x0000005a673c723eULL, 0x000fe200000010ffULL, 0x000001002d677824ULL, 0x000fe400078e00ffULL,
0x0000002c00507306ULL, 0x000fe40000009400ULL, 0x0000003e2818723cULL, 0x000b620000041818ULL,
0x00000018ff677819ULL, 0x000fe40000011467ULL, 0x000000695c00720bULL, 0x004fc60003f5d000ULL,
0x0000002c00527306ULL, 0x000e620000005400ULL, 0x00000042003f7245ULL, 0x020fe2000020d400ULL,
0x0000003c2830723cULL, 0x000b620000041830ULL, 0x00000043003e7245ULL, 0x000fe4000020d400ULL,
0x0000006000427245ULL, 0x000fe4000020d400ULL, 0x0000006100437245ULL, 0x000fe2000020d400ULL,
0x0000006700687306ULL, 0x000fe20000205400ULL, 0x000000013f3f5812ULL, 0x000fe400078efcffULL,
0x0000000142424812ULL, 0x000fc400078efcffULL, 0x000000013e3e6812ULL, 0x000fe400078efcffULL,
0x0000000143432812ULL, 0x000fe200078efcffULL, 0x0000002d00517306ULL, 0x000fe20000009400ULL,
0x000000423f42723eULL, 0x000fe200000010ffULL, 0x000000104a3f7824ULL, 0x000fe200078e025dULL,
0x000000433e43723eULL, 0x000fe400000010ffULL, 0x000000525000720bULL, 0x002fe40003f5d000ULL,
0x00000018ff5c7819ULL, 0x000fe2000001142eULL, 0x0000002d00477306ULL, 0x000e620000005400ULL,
0x000000003f3c783bULL, 0x020fe20000004200ULL, 0x000000422834723cULL, 0x000b620000041834ULL,
0x00000018ff617819ULL, 0x000fca000001142fULL, 0x0000002c00467306ULL, 0x0004e2000000d400ULL,
0x0000000473287824ULL, 0x020fe400078e025fULL, 0x000001002c427824ULL, 0x000fc600078e00ffULL,
0x0000000228287810ULL, 0x000fe20007ffe053ULL, 0x0000000853537824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x00000067005f7306ULL, 0x000ee20000209400ULL,
0x000100002c2c7824ULL, 0x004fe200078e00ffULL, 0x000000475100720bULL, 0x002fe40003f9d000ULL,
0xfffffff853287812ULL, 0x000fe400078ee228ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000004200437306ULL, 0x000fe20000209400ULL, 0x00000010284d7824ULL, 0x000fe200078e024dULL,
0x0000000146462812ULL, 0x008fc400078efcffULL, 0x0000004200477245ULL, 0x000fe4000020d400ULL,
0x009000004d28783bULL, 0x000e640000000200ULL, 0x0000004200667306ULL, 0x000ea20000205400ULL,
0x000000685f00720bULL, 0x000fe40003fbd000ULL, 0x0000006700687245ULL, 0x000fca000020d400ULL,
0x0000002f00127306ULL, 0x000fec0000009400ULL, 0x0000000168685812ULL, 0x000fe400078efcffULL,
0x0000002f00417306ULL, 0x000ee20000005400ULL, 0x000000664300720bULL, 0x004fce0003f7d000ULL,
0x0000005400557306ULL, 0x000fec0000209400ULL, 0x0000000147473812ULL, 0x000fe400078efcffULL,
0x0000005400577306ULL, 0x0004a20000205400ULL, 0x000000411200720bULL, 0x008fe40003f5d000ULL,
0x000000464746723eULL, 0x000fe200000010ffULL, 0x0000000528288231ULL, 0x002fc800003400ffULL,
0x0000002d00137306ULL, 0x0002e2000000d400ULL, 0x000000052a2a8231ULL, 0x000fe200003400ffULL,
0x0000005400547245ULL, 0x004fe2000020d400ULL, 0x0000000429298231ULL, 0x080fe400003400ffULL,
0x000000042b2b8231ULL, 0x000fc600003400ffULL, 0x0000002c00697306ULL, 0x000fe20000209400ULL,
0x000100002d2d7824ULL, 0x002fe200078e00ffULL, 0x000000575500720bULL, 0x000fe20003f1d000ULL,
0x000001002f577824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002c00127306ULL, 0x0002a20000205400ULL, 0x0000000113134812ULL, 0x008fe400078efcffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x000000136847723eULL, 0x000fe400000010ffULL,
0x0000000154540812ULL, 0x000fe200078efcffULL, 0x0000002e000d7306ULL, 0x000fe20000009400ULL,
0x0000002c002c7245ULL, 0x002fc6000020d400ULL, 0x000000462824723cULL, 0x000b680000041824ULL,
0x0000002e000e7306ULL, 0x000e620000005400ULL, 0x000000126900720bULL, 0x004fe20003f7d000ULL,
0x000100002f697824ULL, 0x000fca00078e00ffULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x0000005800597306ULL, 0x000fec0000209400ULL, 0x000000012c2c3812ULL, 0x000fe400078efcffULL,
0x00000058005a7306ULL, 0x000ea20000205400ULL, 0x0000000e0d00720bULL, 0x002fe20003f9d000ULL,
0x000001002e0e7824ULL, 0x000fe200078e00ffULL, 0x0000002c542c723eULL, 0x000fc800000010ffULL,
0x00000018ff0e7819ULL, 0x000fe2000001140eULL, 0x0000005c00567306ULL, 0x000ff00000209400ULL,
0x0000005c005e7306ULL, 0x000e620000205400ULL, 0x0000005a5900720bULL, 0x004fce0003fdd000ULL,
0x0000002d00417306ULL, 0x000ff00000209400ULL, 0x0000002d00687306ULL, 0x0004e20000205400ULL,
0x0000005e5600720bULL, 0x002fe20003fbd000ULL, 0x000100002e5e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000005700127306ULL, 0x000fe20000209400ULL,
0x0000002d002d7245ULL, 0x004fce000020d400ULL, 0x00000057006d7306ULL, 0x0002a20000205400ULL,
0x000000684100720bULL, 0x008fce0003f7d000ULL, 0x0000002f00407306ULL, 0x0006a2000000d400ULL,
0x0000005700577245ULL, 0x002fca000020d400ULL, 0x000000012d2d3812ULL, 0x000fe400078efcffULL,
0x0000006100607306ULL, 0x000fe20000209400ULL, 0x00000058002f7245ULL, 0x008fe2000020d400ULL,
0x000001003c587824ULL, 0x000fc600078e00ffULL, 0x000000012f2f6812ULL, 0x000fe400078efcffULL,
0x0000006d1200720bULL, 0x004fe20003fdd000ULL, 0x0000006100657306ULL, 0x0002a20000205400ULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000000140402812ULL, 0x000fe400078efcffULL,
0x00000018ff127819ULL, 0x000fe4000001143eULL, 0x0000002d2f2d723eULL, 0x000fe200000010ffULL,
0x0000000e00467306ULL, 0x020fe20000209400ULL, 0x0000006100617245ULL, 0x002fc6000020d400ULL,
0x0000000157576812ULL, 0x000fc800078efcffULL, 0x0000000e00557306ULL, 0x0002e20000205400ULL,
0x000000656000720bULL, 0x004fce0003f1d000ULL, 0x0000005e00567306ULL, 0x000fe20000209400ULL,
0x0000000e000e7245ULL, 0x002fca000020d400ULL, 0x0000000161610812ULL, 0x000fe400078efcffULL,
0x0000005e006b7306ULL, 0x0002a20000205400ULL, 0x000000554600720bULL, 0x008fe40003f7d000ULL,
0x00000018ff467819ULL, 0x000fca000001143dULL, 0x0000002e000f7306ULL, 0x0006e2000000d400ULL,
0x0000005e005e7245ULL, 0x002fca000020d400ULL, 0x000000010e0e3812ULL, 0x000fe400078efcffULL,
0x0000003d00507306ULL, 0x000fe20000009400ULL, 0x0000006b5600720bULL, 0x004fe40003fdd000ULL,
0x00000018ff2e7819ULL, 0x008fca000001143cULL, 0x0000003d00667306ULL, 0x000e620000005400ULL,
0x000000010f0f4812ULL, 0x000fc800078efcffULL, 0x0000000f0e0e723eULL, 0x000fe400000010ffULL,
0x000000015e5e6812ULL, 0x000fe200078efcffULL, 0x0000003c00527306ULL, 0x000fe20000009400ULL,
0x00000040570f723eULL, 0x000fe400000010ffULL, 0x0000002e00577245ULL, 0x000fca000020d400ULL,
0x0000003c00537306ULL, 0x000ea20000005400ULL, 0x000000665000720bULL, 0x002fe20003f9d000ULL,
0x000001003d507824ULL, 0x000fe200078e00ffULL, 0x0000000e2814723cULL, 0x000f680000041814ULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000006900417306ULL, 0x000ff00000209400ULL,
0x0000006900607306ULL, 0x000e620000205400ULL, 0x000000535200720bULL, 0x004fc40003f7d000ULL,
0x0000006900527245ULL, 0x000fca000020d400ULL, 0x0000003e005f7306ULL, 0x000ff00000009400ULL,
0x0000003e00517306ULL, 0x000ea20000005400ULL, 0x000000604100720bULL, 0x002fe40003fdd000ULL,
0x00000018ff417819ULL, 0x000fca000001143fULL, 0x0000003f00677306ULL, 0x000fec0000009400ULL,
0x0000000152526812ULL, 0x000fe400078efcffULL, 0x0000003f00477306ULL, 0x000e620000005400ULL,
0x000000515f00720bULL, 0x004fe40003f5d000ULL, 0x0000005c005f7245ULL, 0x000fc8000020d400ULL,
0x000000015f5f5812ULL, 0x000fe200078efcffULL, 0x0000005800537306ULL, 0x000ff00000209400ULL,
0x0000005800667306ULL, 0x0004e20000205400ULL, 0x000000476700720bULL, 0x002fe20003fbd000ULL,
0x000100003c677824ULL, 0x000fc400078e00ffULL, 0x000001003f477824ULL, 0x000fc600078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000005000607306ULL, 0x000fe20000209400ULL,
0x0000005800587245ULL, 0x004fe4000020d400ULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000006700407245ULL, 0x000fc6000020d400ULL, 0x00000050006b7306ULL, 0x0002a20000205400ULL,
0x000000665300720bULL, 0x008fce0003fdd000ULL, 0x0000002e00597306ULL, 0x000fe20000209400ULL,
0x0000005000507245ULL, 0x002fca000020d400ULL, 0x0000000158586812ULL, 0x000fe400078efcffULL,
0x0000002e005a7306ULL, 0x0002e20000205400ULL, 0x0000006b6000720bULL, 0x004fe20003f1d000ULL,
0x000100003d607824ULL, 0x000fca00078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000003c00437306ULL, 0x000ea2000000d400ULL, 0x0000002c282c723cULL, 0x002b6a0000041838ULL,
0x0000000150500812ULL, 0x000fe400078efcffULL, 0x0000004600657306ULL, 0x000fe20000209400ULL,
0x0000005a5900720bULL, 0x008fe20003fdd000ULL, 0x000001003e597824ULL, 0x000fe200078e00ffULL,
0x00000046003b7245ULL, 0x020fc4000020d400ULL, 0x0000005e5f38723eULL, 0x000fe400000010ffULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0000004600687306ULL, 0x000e620000205400ULL,
0x0000000143433812ULL, 0x004fe400078efcffULL, 0x000000526139723eULL, 0x000fe400000010ffULL,
0x00000059003a7245ULL, 0x000fe4000020d400ULL, 0x0000000157576812ULL, 0x000fe200078efcffULL,
0x0000003d00427306ULL, 0x000ea2000000d400ULL, 0x00000043580e723eULL, 0x000fe200000010ffULL,
0x000000382820723cULL, 0x000b6c0000041820ULL, 0x00000067003c7306ULL, 0x000fe20000209400ULL,
0x000000686500720bULL, 0x002fce0003f7d000ULL, 0x00000067003d7306ULL, 0x000e620000205400ULL,
0x0000000142424812ULL, 0x004fc800078efcffULL, 0x00000042500f723eULL, 0x000fe400000010ffULL,
0x000000013b3b3812ULL, 0x000fe200078efcffULL, 0x00000060005c7306ULL, 0x000fe80000209400ULL,
0x0000000e281c723cULL, 0x000f68000004181cULL, 0x0000006000697306ULL, 0x0004e20000205400ULL,
0x0000003d3c00720bULL, 0x002fe20003f1d000ULL, 0x000100003e3c7824ULL, 0x000fc400078e00ffULL,
0x000100003f3d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000001200557306ULL, 0x000fe20000209400ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006000607245ULL, 0x004fc6000020d400ULL, 0x0000000140400812ULL, 0x000fe400078efcffULL,
0x0000001200567306ULL, 0x000e620000205400ULL, 0x000000695c00720bULL, 0x008fe40003f9d000ULL,
0x000000405738723eULL, 0x020fca00000010ffULL, 0x0000005900657306ULL, 0x000fec0000209400ULL,
0x0000000160604812ULL, 0x000fe400078efcffULL, 0x0000005900667306ULL, 0x000ea20000205400ULL,
0x000000565500720bULL, 0x002fe40003f1d000ULL, 0x000000603b39723eULL, 0x000fca00000010ffULL,
0x00000047005a7306ULL, 0x000fe40000209400ULL, 0x000000382818723cULL, 0x000b6c0000041818ULL,
0x00000047005c7306ULL, 0x000e620000205400ULL, 0x000000666500720bULL, 0x004fe40003fdd000ULL,
0x0000004100387245ULL, 0x020fca000020d400ULL, 0x0000003e00137306ULL, 0x000eac000000d400ULL,
0x000000013a3a6812ULL, 0x000fe400078efcffULL, 0x0000003f000d7306ULL, 0x000ee2000000d400ULL,
0x0000005c5a00720bULL, 0x002fce0003f7d000ULL, 0x0000003c003e7306ULL, 0x000fe20000209400ULL,
0x0000000113132812ULL, 0x004fc800078efcffULL, 0x000000133a0e723eULL, 0x000fe400000010ffULL,
0x0000003d00137245ULL, 0x000fe2000020d400ULL, 0x0000003c003f7306ULL, 0x000e620000205400ULL,
0x000000010d0d5812ULL, 0x008fce00078efcffULL, 0x0000004100517306ULL, 0x000ff00000209400ULL,
0x0000004100537306ULL, 0x000ea20000205400ULL, 0x0000003f3e00720bULL, 0x002fe40003fdd000ULL,
0x00000047003e7245ULL, 0x000fc8000020d400ULL, 0x000000013e3e3812ULL, 0x000fe200078efcffULL,
0x0000003d00547306ULL, 0x000fe60000209400ULL, 0x0000000d3e0f723eULL, 0x000fe400000010ffULL,
0x00000012000d7245ULL, 0x000fe4000020d400ULL, 0x0000003c00127245ULL, 0x000fe2000020d400ULL,
0x0000003d00557306ULL, 0x000e620000205400ULL, 0x000000535100720bULL, 0x004fe20003f9d000ULL,
0x0000000e2830723cULL, 0x000b620000041830ULL, 0x000000010d0d0812ULL, 0x000fc400078efcffULL,
0x0000000112126812ULL, 0x000fc800078efcffULL, 0x000000120d12723eULL, 0x000fe400000010ffULL,
0x0000f6c8730e7811ULL, 0x020fc600078e18ffULL, 0x0000000138384812ULL, 0x000fe400078efcffULL,
0x000000555400720bULL, 0x002fda0003f5d000ULL, 0x0000000113132812ULL, 0x000fc800078efcffULL,
0x000000133813723eULL, 0x000fce00000010ffULL, 0x000000122828723cULL, 0x000b620000041834ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000000e0e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f688005bff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff0d7224ULL, 0x000fc600078e00ffULL,
0x0000000000127805ULL, 0x020fc80000015200ULL, 0x0000040007357984ULL, 0x000ee40000000800ULL,
0x8000000035ff7812ULL, 0x00afe4000780480fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003412377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e13ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040007357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010000e7824ULL, 0x000fca00078e00ffULL, 0xffffffe00e0d7812ULL, 0x000fca00078ec0ffULL,
0x00000100480d7824ULL, 0x000fca00078e020dULL, 0x000000800d137810ULL, 0x000fe20007ffe0ffULL,
0x00005900440d7a24ULL, 0x010fc600078e02ffULL, 0x00000020130f7812ULL, 0x000fe200078ec0ffULL,
0x000000400d0d7824ULL, 0x000fc800078e00ffULL, 0x00000001740f7824ULL, 0x000fe200078e020fULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x000000100e357812ULL, 0x000fe400078ec0ffULL,
0x00000013020e7217ULL, 0x000fe40007800000ULL, 0x00000003ff127819ULL, 0x000fe40000011649ULL,
0x000064000d397a11ULL, 0x000fe200078a38ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0a13ULL,
0x0000000412367810ULL, 0x040fe20007ffe0ffULL, 0x0000000112347824ULL, 0x040fe200078e0235ULL,
0x0000000c12377810ULL, 0x000fc40007ffe0ffULL, 0x0000000e350e7217ULL, 0x000fe20007800000ULL,
0x0000000134137824ULL, 0x040fe200078e0249ULL, 0x000065000d3b7a11ULL, 0x000fe200028f3cffULL,
0x0000000834387824ULL, 0x000fe400078e00ffULL, 0x000000010e0e7824ULL, 0x100fe400078e0a35ULL,
0x00000001373e7824ULL, 0x000fe200078e0235ULL, 0xfffffff838387812ULL, 0x000fe400078ee213ULL,
0x0000000812137810ULL, 0x000fe20007ffe0ffULL, 0x000000013e0d7824ULL, 0x000fe200078e0249ULL,
0x0000000e1200720cULL, 0x080fe20003f86070ULL, 0x0000000134127824ULL, 0x000fe200078e020fULL,
0x0000000e3600720cULL, 0x0c0fe20003f66070ULL, 0x0000000136347824ULL, 0x100fe200078e0235ULL,
0x0000000e1300720cULL, 0x0c0fe20003f46070ULL, 0x0000000113367824ULL, 0x000fe200078e0235ULL,
0x0000000e3700720cULL, 0x000fe20003f06070ULL, 0x0000000134137824ULL, 0x000fc400078e0249ULL,
0x00000008343a7824ULL, 0x000fe400078e00ffULL, 0x00000001360e7824ULL, 0x040fe400078e0249ULL,
0x0000000836357824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff8353c7812ULL, 0x000fe200078ee20eULL,
0x0000000134347824ULL, 0x100fe200078e020fULL, 0x0000004f12127212ULL, 0x000fe200078efcffULL,
0x0000000136367824ULL, 0x000fe400078e020fULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000001239127210ULL, 0x000fc60007fbe0ffULL, 0x000000013e0e7824ULL, 0x000fe200078e020fULL,
0x0000004f34347212ULL, 0x000fe200078efcffULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000004f36367212ULL, 0x000fc600078efcffULL,
0x0000000113137824ULL, 0x000fe200028e063bULL, 0x0000003934347210ULL, 0x000fe20007fbe0ffULL,
0x000000083e3e7824ULL, 0x000fe200078e00ffULL, 0x0000004f0e0e7212ULL, 0x000fc600078efcffULL,
0x0000000135357824ULL, 0x000fe200028e063bULL, 0x0000003936367210ULL, 0x080fe40007fbe0ffULL,
0x000000390e0e7210ULL, 0x000fe20007fde0ffULL, 0x000000103a397824ULL, 0x000fe200078e025dULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL, 0x00000010380d7824ULL, 0x000fe400078e025dULL,
0x0000000137377824ULL, 0x100fe400028e063bULL, 0x000000010f0f7824ULL, 0x000fe200030e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000120d7faeULL, 0x0003e2000e101c46ULL,
0x000000103c3b7824ULL, 0x000fc400078e025dULL, 0x000000103e3d7824ULL, 0x000fe200078e025dULL,
0x0000000034397faeULL, 0x0003e8000d901c46ULL, 0x00000000363b7faeULL, 0x0003e8000d101c46ULL,
0x000000000e3d7faeULL, 0x0003e2000c101c46ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x000000100e0e7812ULL, 0x000fe400078ec0ffULL, 0x000064000d397a11ULL, 0x000fc400078038ffULL,
0x0000000e490e7211ULL, 0x000fe400078fe8ffULL, 0x000065000d3b7a11ULL, 0x000fe400000f3cffULL,
0x000000040e347810ULL, 0x040fe20007ffe0ffULL, 0x000000010e137824ULL, 0x040fe200078e0249ULL,
0x000000080e3a7810ULL, 0x040fe20007ffe0ffULL, 0x000000080e387824ULL, 0x040fe200078e00ffULL,
0x0000000c0e3c7810ULL, 0x000fe20007ffe0ffULL, 0x00000008343e7824ULL, 0x000fe400078e00ffULL,
0x000000010e127824ULL, 0x000fe200078e020fULL, 0xfffffff838387812ULL, 0x000fe200078ee213ULL,
0x0000000134137824ULL, 0x000fc400078e0249ULL, 0x0000000134367824ULL, 0x100fe400078e020fULL,
0x000000013a347824ULL, 0x100fe400078e020fULL, 0x000000013c0e7824ULL, 0x000fe400078e020fULL,
0x000000013a0f7824ULL, 0x040fe400078e0249ULL, 0x000000083a407824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3a7812ULL, 0x000fe200078ee213ULL, 0x000000013c357824ULL, 0x000fc400078e0249ULL,
0x000000083c427824ULL, 0x000fe200078e00ffULL, 0xfffffff8403c7812ULL, 0x000fe200078ee20fULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff8423e7812ULL, 0x000fe200078ee235ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004f12127212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000001239127210ULL, 0x040fe40007f1e0ffULL,
0x0000004f36367212ULL, 0x080fe200078efcffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000004f34347212ULL, 0x080fe400078efcffULL, 0x0000003639367210ULL, 0x000fe20007f5e0ffULL,
0x0000000113137824ULL, 0x000fe200000e063bULL, 0x0000004f0e0e7212ULL, 0x000fe200078efcffULL,
0x00000010380d7824ULL, 0x000fe200078e025dULL, 0x0000003439347210ULL, 0x000fe20007f1e0ffULL,
0x0000000137377824ULL, 0x000fe200010e063bULL, 0x0000000e390e7210ULL, 0x000fe20007f7e0ffULL,
0x000000103a397824ULL, 0x000fe200078e025dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120d7faeULL, 0x0003e2000b901c46ULL, 0x0000000135357824ULL, 0x000fc400000e063bULL,
0x000000010f0f7824ULL, 0x000fe200018e063bULL, 0x0000000036397faeULL, 0x0003e2000b901c46ULL,
0x000000103c3b7824ULL, 0x100fe400078e025dULL, 0x000000103e3d7824ULL, 0x000fc600078e025dULL,
0x00000000343b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e3d7faeULL, 0x0003e4000b901c46ULL,
0x00000008000d7824ULL, 0x002fe200078e00ffULL, 0x00000002090e7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff407424ULL, 0x000fc600078e00ffULL, 0xfffffff00d0d7812ULL, 0x000fe400078ec0ffULL,
0x000000030e00720cULL, 0x000fe40003f06070ULL, 0x000000000d0473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x00000001750e8824ULL, 0x000fc400078e020eULL,
0x00000004ff0f8424ULL, 0x000fc800078e00ffULL, 0x000066000e0e8625ULL, 0x000fca00078e000fULL,
0x000000060e408981ULL, 0x000722000c1e1900ULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x008fec0000008000ULL, 0x00f6a8000d0e7f8cULL, 0x0002e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f628000a127f8cULL, 0x0002a4000c80043fULL,
0x0000000000347805ULL, 0x000fc40000015200ULL, 0x00f62c000a0d7984ULL, 0x002e640000000800ULL,
0x800000000dff7812ULL, 0x006fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634367210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011437ULL, 0x000000360d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff367224ULL, 0x000fca00000e0637ULL, 0x000000020d0d7819ULL, 0x000fc80000001236ULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c000a0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020000d7824ULL, 0x000fca00078e00ffULL,
0xffffff800d127812ULL, 0x000fc800078ec0ffULL, 0x000000804f0d7810ULL, 0x000fca0007ffe012ULL,
0x00000001640d7824ULL, 0x000fca00078e020dULL, 0x00f000000d347984ULL, 0x000e680000000800ULL,
0x00f200000d357984ULL, 0x0004e20000000800ULL, 0x0000000b3400720bULL, 0x002fe20003f1d000ULL,
0x000115527f007947ULL, 0x000fd8000b800000ULL, 0x00000000000d7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0d377812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0d7424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000001770d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000b3400720bULL, 0x000fe40003f54000ULL,
0x000000000d00720cULL, 0x000fe20003f05270ULL, 0x000115027f007947ULL, 0x000fd4000b800000ULL,
0x0000000000367806ULL, 0x000fc400010e0100ULL, 0x0000008000138824ULL, 0x000fe200078e024fULL,
0x0000000b340d8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991036127816ULL, 0x000fe200000000ffULL, 0x0000000164388824ULL, 0x000fca00078e0213ULL,
0x00f4000d38008388ULL, 0x0003e20000000800ULL, 0x000000ff1200720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000b34127209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff36ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000b120d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d00397308ULL, 0x000e640000000800ULL, 0x000000390c0c7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011649ULL,
0x000114227f007947ULL, 0x000fea000b800000ULL, 0x00001f0d390d7589ULL, 0x0002a400000e0000ULL,
0x0000000d24247220ULL, 0x084fe20000410000ULL, 0x0000000d25257220ULL, 0x080fe20000410000ULL,
0x0000000d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000d14147220ULL, 0x080fe20000410000ULL, 0x0000000d15157220ULL, 0x080fe20000410000ULL,
0x0000000d20207220ULL, 0x080fe20000410000ULL, 0x0000000d21217220ULL, 0x080fe20000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000d1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000d18187220ULL, 0x080fe20000410000ULL, 0x0000000d19197220ULL, 0x080fe20000410000ULL,
0x0000000d30307220ULL, 0x080fe20000410000ULL, 0x0000000d31317220ULL, 0x080fe20000410000ULL,
0x0000000d28287220ULL, 0x080fe20000410000ULL, 0x0000000d29297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0036ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008490d7811ULL, 0x000fe200078ff0ffULL,
0x000113027f007947ULL, 0x000fea000b800000ULL, 0x00001f0d390d7589ULL, 0x00046400000e0000ULL,
0x0000000d26267220ULL, 0x086fe20000410000ULL, 0x0000000d27277220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d16167220ULL, 0x080fe20000410000ULL, 0x0000000d17177220ULL, 0x080fe20000410000ULL,
0x0000000d22227220ULL, 0x080fe20000410000ULL, 0x0000000d23237220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000d1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000d32327220ULL, 0x080fe20000410000ULL, 0x0000000d33337220ULL, 0x080fe20000410000ULL,
0x0000000d2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000d2b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff37ff7812ULL, 0x000fe20007806036ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000b340b7209ULL, 0x000fd60007810000ULL,
0x8000000b34340221ULL, 0x000fe20000010000ULL, 0x00007610ff0d0816ULL, 0x000fc6000000000dULL,
0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL, 0x0000003400060308ULL, 0x000e640000000800ULL,
0x0000000635350220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000c350c7221ULL, 0x008fc20000010000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000000800347824ULL, 0x000fca00078e00ffULL, 0xfffffff034367812ULL, 0x000fca00078ec0ffULL,
0x00f6b40036357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003412377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e13ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b40036357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100d0d7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000006ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff117819ULL, 0x000fe40000011649ULL,
0x0000541004107816ULL, 0x000fe20000000004ULL, 0x00010eb27f007947ULL, 0x000fea000b800000ULL,
0x00001f1110057589ULL, 0x0002a400000e0000ULL, 0x00000008110d7810ULL, 0x000fe20007ffe0ffULL,
0x00010ee27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d10047589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010110d7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e0010ULL, 0x0000687000137802ULL, 0x000fc40000000f00ULL,
0x0001170000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018110d7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e0010ULL,
0x000068c000137802ULL, 0x000fc40000000f00ULL, 0x000116b000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000010005d507810ULL, 0x000fe20007ffe0ffULL, 0x009800004e38783bULL, 0x000ee80000000200ULL,
0x0000001045527824ULL, 0x000fc400078e0250ULL, 0x000000104b347824ULL, 0x100fe400078e0250ULL,
0x000000104c517824ULL, 0x000fe200078e0250ULL, 0x00000000523c783bULL, 0x000ea80000004200ULL,
0x000000003434783bULL, 0x000e620000004200ULL, 0x0000000538388231ULL, 0x08cfe400003400ffULL,
0x000000053a3a8231ULL, 0x000fc400003400ffULL, 0x0000000439398231ULL, 0x082fe400003400ffULL,
0x000000043b3b8231ULL, 0x000fe200003400ffULL, 0x000001003c107824ULL, 0x000fe200078e00ffULL,
0x0000003d00667306ULL, 0x000fe20000009400ULL, 0x000001003f6c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011410ULL, 0x000001003d107824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000003d00677306ULL, 0x000e640000005400ULL,
0x00000018ff687819ULL, 0x000fe40000011410ULL, 0x000000005110783bULL, 0x000ea80000004200ULL,
0x0000006800697306ULL, 0x000ff00000209400ULL, 0x00000068006a7306ULL, 0x0006e20000205400ULL,
0x000000676600720bULL, 0x002fc40003f9d000ULL, 0x00000018ff667819ULL, 0x000fca000001143dULL,
0x0000003c00417306ULL, 0x000fe20000009400ULL, 0x0000006800687245ULL, 0x008fce000020d400ULL,
0x0000003c00447306ULL, 0x000e620000005400ULL, 0x0000006a6900720bULL, 0x000fce0003fbd000ULL,
0x0000005300557306ULL, 0x000fec0000209400ULL, 0x0000000168685812ULL, 0x000fe400078efcffULL,
0x0000005300567306ULL, 0x000ee20000205400ULL, 0x000000444100720bULL, 0x002fe40003f5d000ULL,
0x00000018ff447819ULL, 0x000fc4000001143cULL, 0x0000005300417245ULL, 0x000fc6000020d400ULL,
0x0000003d00437306ULL, 0x0002b0000000d400ULL, 0x0000003c00427306ULL, 0x0004a2000000d400ULL,
0x000000565500720bULL, 0x008fe20003f7d000ULL, 0x000100003d3d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000003e00467306ULL, 0x000fe20000009400ULL,
0x000100003c3c7824ULL, 0x004fe200078e00ffULL, 0x0000000143434812ULL, 0x000fc800078efcffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003e00477306ULL, 0x000e620000005400ULL,
0x0000000142422812ULL, 0x000fe400078efcffULL, 0x0000000141413812ULL, 0x000fe400078efcffULL,
0x000000436843723eULL, 0x000fe400000010ffULL, 0x000000424142723eULL, 0x000fe200000010ffULL,
0x0000003f005a7306ULL, 0x000fec0000009400ULL, 0x000000423824723cULL, 0x000b620000041824ULL,
0x000000474600720bULL, 0x002fe20003f9d000ULL, 0x0000003f00657306ULL, 0x000e700000005400ULL,
0x0000003c00687306ULL, 0x000ff00000209400ULL, 0x0000003c00477306ULL, 0x0004e20000205400ULL,
0x000000655a00720bULL, 0x002fe20003f7d000ULL, 0x000001003e5a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000004400677306ULL, 0x000fe20000209400ULL,
0x0000003c003c7245ULL, 0x004fce000020d400ULL, 0x0000004400427306ULL, 0x020e620000205400ULL,
0x000000476800720bULL, 0x008fce0003fbd000ULL, 0x0000006600437306ULL, 0x000fec0000209400ULL,
0x000000013c3c5812ULL, 0x000fe400078efcffULL, 0x00000066006a7306ULL, 0x000ea20000205400ULL,
0x000000426700720bULL, 0x002fce0003fdd000ULL, 0x0000003d00657306ULL, 0x000ff00000209400ULL,
0x0000003d00687306ULL, 0x0002e20000205400ULL, 0x0000006a4300720bULL, 0x004fce0003f5d000ULL,
0x0000005a00477306ULL, 0x000fe20000209400ULL, 0x0000003d003d7245ULL, 0x002fce000020d400ULL,
0x0000005a006a7306ULL, 0x000e620000205400ULL, 0x000000686500720bULL, 0x008fe40003fbd000ULL,
0x0000004400657245ULL, 0x000fe4000020d400ULL, 0x00000018ff447819ULL, 0x000fe4000001143eULL,
0x0000000165656812ULL, 0x000fe200078efcffULL, 0x0000006c00437306ULL, 0x000fe60000209400ULL,
0x0000003c653c723eULL, 0x000fc400000010ffULL, 0x00000018ff657819ULL, 0x000fe4000001143fULL,
0x000000013d3d5812ULL, 0x000fe200078efcffULL, 0x0000006c00687306ULL, 0x0004e20000205400ULL,
0x0000006a4700720bULL, 0x002fe40003fdd000ULL, 0x00000066006a7245ULL, 0x000fc8000020d400ULL,
0x000000016a6a2812ULL, 0x000fe200078efcffULL, 0x0000003e00597306ULL, 0x0002e2000000d400ULL,
0x0000006c006c7245ULL, 0x004fe4000020d400ULL, 0x0000003d6a3d723eULL, 0x000fca00000010ffULL,
0x0000003f000d7306ULL, 0x0004a2000000d400ULL, 0x000100003e3e7824ULL, 0x002fe200078e00ffULL,
0x000000684300720bULL, 0x008fe20003fbd000ULL, 0x0000003c382c723cULL, 0x000b66000004182cULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x0000004400677306ULL, 0x000fe20000209400ULL,
0x000100003f3f7824ULL, 0x004fe200078e00ffULL, 0x0000005a003c7245ULL, 0x020fc4000020d400ULL,
0x0000000159594812ULL, 0x000fe400078efcffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000004400687306ULL, 0x000e620000205400ULL, 0x000000010d0d3812ULL, 0x000fe400078efcffULL,
0x000000013c3c6812ULL, 0x000fe400078efcffULL, 0x000000016c6c5812ULL, 0x000fe400078efcffULL,
0x000000593c3c723eULL, 0x000fe200000010ffULL, 0x0000003e00697306ULL, 0x000fe20000209400ULL,
0x0000000d6c3d723eULL, 0x000fce00000010ffULL, 0x0000003e006b7306ULL, 0x0004e20000205400ULL,
0x000000686700720bULL, 0x002fe20003f7d000ULL, 0x0000003c3814723cULL, 0x000b620000041814ULL,
0x0001000034677824ULL, 0x000fca00078e00ffULL, 0x0000006500437306ULL, 0x000fe20000209400ULL,
0x00000044003d7245ULL, 0x020fe4000020d400ULL, 0x0000003e003c7245ULL, 0x000fe4000020d400ULL,
0x0000003f003e7245ULL, 0x004fe4000020d400ULL, 0x000000013d3d3812ULL, 0x000fe200078efcffULL,
0x0000006500667306ULL, 0x0002a20000205400ULL, 0x0000006b6900720bULL, 0x008fe20003f5d000ULL,
0x0000010035697824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fc80000011467ULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0000003f006a7306ULL, 0x000fe20000209400ULL,
0x0000006500657245ULL, 0x002fca000020d400ULL, 0x000000013c3c2812ULL, 0x000fe400078efcffULL,
0x0000003f006d7306ULL, 0x000e620000205400ULL, 0x000000664300720bULL, 0x004fe40003fbd000ULL,
0x0000003c3d3c723eULL, 0x000fe400000010ffULL, 0x00000018ff667819ULL, 0x000fc60000011434ULL,
0x00000034005e7306ULL, 0x000fec0000009400ULL, 0x0000000165655812ULL, 0x000fe400078efcffULL,
0x0000006d6a00720bULL, 0x002fe20003f9d000ULL, 0x00000100346a7824ULL, 0x000fe200078e00ffULL,
0x00000034005f7306ULL, 0x000e680000005400ULL, 0x00000018ff6a7819ULL, 0x000fc8000001146aULL,
0x0000003500607306ULL, 0x000fe60000009400ULL, 0x000000013e3e4812ULL, 0x000fc800078efcffULL,
0x0000003e653d723eULL, 0x000fe200000010ffULL, 0x0000003500617306ULL, 0x000ea20000005400ULL,
0x0000005f5e00720bULL, 0x002fe40003f5d000ULL, 0x00000069005e7245ULL, 0x000fc6000020d400ULL,
0x0000003c3820723cULL, 0x000be40000041820ULL, 0x0000006a003f7306ULL, 0x000fea0000209400ULL,
0x000000104a3c7824ULL, 0x020fc600078e0250ULL, 0x0000006a00687306ULL, 0x000e620000205400ULL,
0x000000616000720bULL, 0x004fe40003f9d000ULL, 0x00000018ff617819ULL, 0x000fc80000011435ULL,
0x0000006100727245ULL, 0x000fe2000020d400ULL, 0x00000069003e7306ULL, 0x000ff00000209400ULL,
0x00000069003d7306ULL, 0x000ea20000205400ULL, 0x000000683f00720bULL, 0x002fe20003f7d000ULL,
0x0001000035687824ULL, 0x000fca00078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x00000034005c7306ULL, 0x000e70000000d400ULL, 0x00000035005b7306ULL, 0x000662000000d400ULL,
0x0000003d3e00720bULL, 0x004fc40003fbd000ULL, 0x000000003c3c783bULL, 0x000fea0000004200ULL,
0x0000006600657306ULL, 0x000fe20000209400ULL, 0x0000006a00357245ULL, 0x008fe4000020d400ULL,
0x000000015c5c2812ULL, 0x002fe400078efcffULL, 0x0000000135353812ULL, 0x000fc400078efcffULL,
0x000000015e5e5812ULL, 0x000fe200078efcffULL, 0x00000066005f7306ULL, 0x000e620000205400ULL,
0x000000015b5b4812ULL, 0x000fe400078efcffULL, 0x0000005c3534723eULL, 0x000fe400000010ffULL,
0x0000005b5e35723eULL, 0x000fc600000010ffULL, 0x0000006700607306ULL, 0x000fe80000209400ULL,
0x00000034381c723cULL, 0x000b68000004181cULL, 0x00000067006d7306ULL, 0x0004e20000205400ULL,
0x0000005f6500720bULL, 0x002fe40003f7d000ULL, 0x0000006600357245ULL, 0x020fe2000020d400ULL,
0x0000010036667824ULL, 0x000fe200078e00ffULL, 0x0000006700347245ULL, 0x000fc4000020d400ULL,
0x00000018ff657819ULL, 0x000fe20000011436ULL, 0x00000061006b7306ULL, 0x000fe20000209400ULL,
0x0000010037677824ULL, 0x004fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fc80000011466ULL,
0x0000000135353812ULL, 0x000fe400078efcffULL, 0x00000061006c7306ULL, 0x000e620000205400ULL,
0x0000006d6000720bULL, 0x008fe40003f5d000ULL, 0x00000018ff677819ULL, 0x000fca0000011467ULL,
0x0000006800697306ULL, 0x000fec0000209400ULL, 0x0000000134342812ULL, 0x000fe400078efcffULL,
0x00000068006a7306ULL, 0x000ea20000205400ULL, 0x0000006c6b00720bULL, 0x002fe40003fbd000ULL,
0x000000343534723eULL, 0x000fc400000010ffULL, 0x0000006800357245ULL, 0x000fc6000020d400ULL,
0x0000003600547306ULL, 0x000fec0000009400ULL, 0x0000000172725812ULL, 0x000fe400078efcffULL,
0x0000006a6900720bULL, 0x004fe20003f9d000ULL, 0x0000003600587306ULL, 0x000e700000005400ULL,
0x0000006500697306ULL, 0x000fe80000209400ULL, 0x0000000135354812ULL, 0x000fc800078efcffULL,
0x00000065006a7306ULL, 0x0004e20000205400ULL, 0x000000357235723eULL, 0x000fe400000010ffULL,
0x000000585400720bULL, 0x002fe40003fdd000ULL, 0x00000018ff587819ULL, 0x000fc60000011437ULL,
0x0000006700687306ULL, 0x000fe20000209400ULL, 0x000000343818723cULL, 0x000b620000041818ULL,
0x0000006500657245ULL, 0x004fcc000020d400ULL, 0x00000067006d7306ULL, 0x000e620000205400ULL,
0x0000006a6900720bULL, 0x008fe20003f7d000ULL, 0x0001000037697824ULL, 0x000fca00078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0000003700567306ULL, 0x000fec0000009400ULL,
0x0000000165653812ULL, 0x000fe400078efcffULL, 0x0000003700557306ULL, 0x000ea20000005400ULL,
0x0000006d6800720bULL, 0x002fe20003fbd000ULL, 0x0001000036687824ULL, 0x000fca00078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x00000066006b7306ULL, 0x000ff00000209400ULL,
0x00000066006c7306ULL, 0x000e620000205400ULL, 0x000000555600720bULL, 0x004fce0003f5d000ULL,
0x0000003600577306ULL, 0x000eb0000000d400ULL, 0x0000005800347306ULL, 0x020fe20000209400ULL,
0x0000006c6b00720bULL, 0x002fce0003f9d000ULL, 0x0000005800357306ULL, 0x0002e20000205400ULL,
0x0000000157576812ULL, 0x004fce00078efcffULL, 0x0000003700537306ULL, 0x000ea2000000d400ULL,
0x0000005800587245ULL, 0x002fce000020d400ULL, 0x0000006800567306ULL, 0x000fe20000209400ULL,
0x000000353400720bULL, 0x008fe40003fdd000ULL, 0x0000006600347245ULL, 0x000fe4000020d400ULL,
0x0000006700667245ULL, 0x000fe4000020d400ULL, 0x0000000134344812ULL, 0x000fe200078efcffULL,
0x0000006800377306ULL, 0x000e620000205400ULL, 0x0000000153532812ULL, 0x004fe400078efcffULL,
0x0000000166665812ULL, 0x000fc400078efcffULL, 0x000000573434723eULL, 0x000fe400000010ffULL,
0x000000536635723eULL, 0x000fe200000010ffULL, 0x00000069006a7306ULL, 0x000fe20000209400ULL,
0x0000000158586812ULL, 0x000fe200078efcffULL, 0x0000010010667824ULL, 0x000fc800078e00ffULL,
0x000000343830723cULL, 0x000b620000041830ULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x00000069006b7306ULL, 0x000ea20000205400ULL, 0x000000375600720bULL, 0x002fc80003f5d000ULL,
0x0000006800347245ULL, 0x020fe4000020d400ULL, 0x0000006900357245ULL, 0x000fe2000020d400ULL,
0x0000001000417306ULL, 0x000fec0000009400ULL, 0x0000000134342812ULL, 0x000fe400078efcffULL,
0x0000006b6a00720bULL, 0x004fe20003f9d000ULL, 0x0000001000467306ULL, 0x000e620000005400ULL,
0x000000346534723eULL, 0x000fc400000010ffULL, 0x00000018ff657819ULL, 0x000fca0000011410ULL,
0x0000001100477306ULL, 0x000fe80000009400ULL, 0x0000000135354812ULL, 0x000fc800078efcffULL,
0x000000355835723eULL, 0x000fe200000010ffULL, 0x00000011005a7306ULL, 0x000ea20000005400ULL,
0x000000464100720bULL, 0x002fe20003fdd000ULL, 0x0000010011467824ULL, 0x000fc800078e00ffULL,
0x000000343838723cULL, 0x000b620000041828ULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000006600287306ULL, 0x020fea0000209400ULL, 0x00000018ff357819ULL, 0x000fc60000011411ULL,
0x0000006600297306ULL, 0x000e620000205400ULL, 0x0000005a4700720bULL, 0x004fce0003f5d000ULL,
0x0000004600697306ULL, 0x000fe20000209400ULL, 0x000000292800720bULL, 0x002fce0003f7d000ULL,
0x00000046006a7306ULL, 0x000e620000205400ULL, 0x009800004d28783bULL, 0x000eae0000000200ULL,
0x0000006500587306ULL, 0x000ff00000209400ULL, 0x0000006500677306ULL, 0x000ee20000205400ULL,
0x0000006a6900720bULL, 0x002fe20003fbd000ULL, 0x00000100126a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000001100597306ULL, 0x0003f0000000d400ULL,
0x0000001000427306ULL, 0x0004a2000000d400ULL, 0x0001000011117824ULL, 0x002fe200078e00ffULL,
0x000000675800720bULL, 0x008fc40003f9d000ULL, 0x0000006600677245ULL, 0x000fe4000020d400ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000004600667245ULL, 0x000fe2000020d400ULL,
0x0001000010107824ULL, 0x004fe200078e00ffULL, 0x00000011005a7306ULL, 0x000fe20000209400ULL,
0x0000000167673812ULL, 0x000fe200078efcffULL, 0x0000000528288231ULL, 0x080fe200003400ffULL,
0x0000000166665812ULL, 0x000fe200078efcffULL, 0x000000052a2a8231ULL, 0x000fe200003400ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000000429298231ULL, 0x080fe200003400ffULL,
0x0000000142426812ULL, 0x000fe200078efcffULL, 0x0000001100697306ULL, 0x0002a20000205400ULL,
0x0000000159592812ULL, 0x000fe200078efcffULL, 0x000000042b2b8231ULL, 0x000fe200003400ffULL,
0x000000426758723eULL, 0x000fc400000010ffULL, 0x000000596659723eULL, 0x000fe400000010ffULL,
0x00000018ff427819ULL, 0x000fe20000011413ULL, 0x0000001000687306ULL, 0x000fe20000209400ULL,
0x0000001100117245ULL, 0x002fc6000020d400ULL, 0x000000582824723cULL, 0x000b680000041824ULL,
0x0000001000477306ULL, 0x0002e20000205400ULL, 0x000000695a00720bULL, 0x004fe40003fbd000ULL,
0x0000003500587245ULL, 0x020fe4000020d400ULL, 0x0000006500697245ULL, 0x000fe4000020d400ULL,
0x00000018ff597819ULL, 0x000fe2000001143cULL, 0x00000013005b7306ULL, 0x000fe20000009400ULL,
0x0000001000107245ULL, 0x002fc4000020d400ULL, 0x0000000169694812ULL, 0x000fc600078efcffULL,
0x0000000111115812ULL, 0x000fe400078efcffULL, 0x00000013005c7306ULL, 0x000e620000005400ULL,
0x000000476800720bULL, 0x008fe40003fdd000ULL, 0x00000018ff477819ULL, 0x000fca0000011412ULL,
0x0000003500347306ULL, 0x000fec0000209400ULL, 0x0000000110106812ULL, 0x000fe400078efcffULL,
0x0000003500417306ULL, 0x000ea20000205400ULL, 0x0000005c5b00720bULL, 0x002fe20003fbd000ULL,
0x00000100135b7824ULL, 0x000fe200078e00ffULL, 0x000000106910723eULL, 0x000fc800000010ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x00000012000d7306ULL, 0x000ff00000009400ULL,
0x0000001200437306ULL, 0x000e620000005400ULL, 0x000000413400720bULL, 0x004fce0003f7d000ULL,
0x0000006a00357306ULL, 0x000fec0000209400ULL, 0x0000000158583812ULL, 0x000fe400078efcffULL,
0x0000006a006c7306ULL, 0x000ea20000205400ULL, 0x000000430d00720bULL, 0x002fe40003fdd000ULL,
0x000000115811723eULL, 0x000fc400000010ffULL, 0x00000018ff587819ULL, 0x000fe4000001143dULL,
0x00000018ff0d7819ULL, 0x000fe2000001143eULL, 0x0000003e00537306ULL, 0x000fe40000009400ULL,
0x00000010282c723cULL, 0x000f6c000004182cULL, 0x0000003e00567306ULL, 0x000e620000005400ULL,
0x0000006c3500720bULL, 0x004fc40003f1d000ULL, 0x00000018ff357819ULL, 0x000fca000001143fULL,
0x0000003c005f7306ULL, 0x000ff00000009400ULL, 0x0000003c00607306ULL, 0x000ea20000005400ULL,
0x000000565300720bULL, 0x002fe40003f7d000ULL, 0x0000006a00537245ULL, 0x000fc8000020d400ULL,
0x0000000153530812ULL, 0x000fe200078efcffULL, 0x0000003d00547306ULL, 0x000ff00000009400ULL,
0x0000003d00557306ULL, 0x000e620000005400ULL, 0x000000605f00720bULL, 0x004fe20003f5d000ULL,
0x00010000135f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000005b00437306ULL, 0x000ff00000209400ULL, 0x0000005b006c7306ULL, 0x000ea20000205400ULL,
0x000000555400720bULL, 0x002fce0003f9d000ULL, 0x0000001200447306ULL, 0x0002f0000000d400ULL,
0x0000003f00577306ULL, 0x000fe20000009400ULL, 0x0001000012127824ULL, 0x002fe200078e00ffULL,
0x0000006c4300720bULL, 0x004fc80003f1d000ULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x0000003f00417306ULL, 0x000fe20000005400ULL, 0x0000000144446812ULL, 0x008fce00078efcffULL,
0x0000001200607306ULL, 0x000ff00000209400ULL, 0x0000001200557306ULL, 0x000e700000205400ULL,
0x00000013005e7306ULL, 0x0004f0000000d400ULL, 0x0000004700467306ULL, 0x000fe20000209400ULL,
0x0000005b00137245ULL, 0x004fc4000020d400ULL, 0x000000556000720bULL, 0x002fe20003fdd000ULL,
0x000100003c607824ULL, 0x040fe200078e00ffULL, 0x0000000113130812ULL, 0x000fe400078efcffULL,
0x000000415700720bULL, 0x000fe20003f1d000ULL, 0x00000047005a7306ULL, 0x000e620000205400ULL,
0x000001003c417824ULL, 0x000fe200078e00ffULL, 0x0000001200557245ULL, 0x000fe2000020d400ULL,
0x000001003d127824ULL, 0x000fe200078e00ffULL, 0x000000015e5e5812ULL, 0x008fe400078efcffULL,
0x00000018ff417819ULL, 0x000fc40000011441ULL, 0x0000005f00567306ULL, 0x000fe20000209400ULL,
0x0000000155556812ULL, 0x000fe400078efcffULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x00000018ff607819ULL, 0x000fe40000011460ULL, 0x0000005e1313723eULL, 0x000fe200000010ffULL,
0x0000005f005b7306ULL, 0x000ea20000205400ULL, 0x0000005a4600720bULL, 0x002fe40003fbd000ULL,
0x0000005f00467245ULL, 0x000fca000020d400ULL, 0x0000004200667306ULL, 0x000ff00000209400ULL,
0x0000004200657306ULL, 0x000e620000205400ULL, 0x0000005b5600720bULL, 0x004fe20003fdd000ULL,
0x000100003d5b7824ULL, 0x000fe200078e00ffULL, 0x0000004700567245ULL, 0x000fc8000020d400ULL,
0x0000000156565812ULL, 0x000fe200078efcffULL, 0x0000004100577306ULL, 0x000fe20000209400ULL,
0x00000018ff5b7819ULL, 0x000fca000001145bULL, 0x0000000146466812ULL, 0x000fe400078efcffULL,
0x00000041005a7306ULL, 0x000ea20000205400ULL, 0x000000656600720bULL, 0x002fce0003fbd000ULL,
0x0000001200477306ULL, 0x000ff00000209400ULL, 0x0000001200667306ULL, 0x000e620000205400ULL,
0x0000005a5700720bULL, 0x004fe20003fdd000ULL, 0x000001003e5a7824ULL, 0x000fe200078e00ffULL,
0x0000004200577245ULL, 0x000fc4000020d400ULL, 0x0000004100427245ULL, 0x000fe2000020d400ULL,
0x000001003f417824ULL, 0x000fe200078e00ffULL, 0x0000000157575812ULL, 0x000fe200078efcffULL,
0x0000005900677306ULL, 0x000fe20000209400ULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x00000018ff417819ULL, 0x000fc60000011441ULL, 0x0000000142426812ULL, 0x000fe400078efcffULL,
0x0000005900687306ULL, 0x0004e20000205400ULL, 0x000000664700720bULL, 0x002fe40003fdd000ULL,
0x0000001200477245ULL, 0x000fe4000020d400ULL, 0x000000445312723eULL, 0x000fe400000010ffULL,
0x0000006000447245ULL, 0x000fe2000020d400ULL, 0x0000003c00617306ULL, 0x000e62000000d400ULL,
0x0000005900597245ULL, 0x004fc6000020d400ULL, 0x000000122814723cULL, 0x000b640000041814ULL,
0x0000000147476812ULL, 0x000fe400078efcffULL, 0x00000060003c7306ULL, 0x000fe20000209400ULL,
0x000000686700720bULL, 0x008fce0003fbd000ULL, 0x00000060005f7306ULL, 0x000ea20000205400ULL,
0x0000000161612812ULL, 0x002fc800078efcffULL, 0x000000614212723eULL, 0x020fe400000010ffULL,
0x0000000159595812ULL, 0x000fe200078efcffULL, 0x0000003d00367306ULL, 0x000e70000000d400ULL,
0x0000005800697306ULL, 0x000fe20000209400ULL, 0x0000005f3c00720bULL, 0x004fe20003fdd000ULL,
0x000100003e3c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x00000058005c7306ULL, 0x0004e20000205400ULL, 0x0000000136364812ULL, 0x002fc800078efcffULL,
0x000000364713723eULL, 0x000fe400000010ffULL, 0x0000000144446812ULL, 0x000fe200078efcffULL,
0x0000005b003d7306ULL, 0x000fe20000209400ULL, 0x0000005800587245ULL, 0x004fc6000020d400ULL,
0x00000012281c723cULL, 0x000f68000004181cULL, 0x0000005b00687306ULL, 0x0002a20000205400ULL,
0x0000005c6900720bULL, 0x008fce0003f5d000ULL, 0x0000000d00107306ULL, 0x000fe20000209400ULL,
0x0000005b005b7245ULL, 0x002fca000020d400ULL, 0x0000000158582812ULL, 0x000fe400078efcffULL,
0x0000000d00117306ULL, 0x0002e20000205400ULL, 0x000000683d00720bULL, 0x004fe20003f9d000ULL,
0x000100003f3d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000005a00657306ULL, 0x000fe20000209400ULL, 0x0000000d000d7245ULL, 0x002fca000020d400ULL,
0x000000015b5b4812ULL, 0x000fe400078efcffULL, 0x0000005a00667306ULL, 0x0002a20000205400ULL,
0x000000111000720bULL, 0x008fe40003fdd000ULL, 0x000000555610723eULL, 0x000fe400000010ffULL,
0x000000465711723eULL, 0x000fc600000010ffULL, 0x00000041005c7306ULL, 0x000fe20000209400ULL,
0x0000005a005a7245ULL, 0x002fc6000020d400ULL, 0x000000102820723cULL, 0x000b640000041820ULL,
0x000000010d0d6812ULL, 0x000fe400078efcffULL, 0x00000041005f7306ULL, 0x0002e20000205400ULL,
0x000000666500720bULL, 0x004fe40003fbd000ULL, 0x000000445910723eULL, 0x020fe400000010ffULL,
0x0000005b5811723eULL, 0x000fc600000010ffULL, 0x0000003e00377306ULL, 0x000ea2000000d400ULL,
0x0000004100417245ULL, 0x002fc6000020d400ULL, 0x000000102818723cULL, 0x000b640000041818ULL,
0x000000015a5a5812ULL, 0x000fe400078efcffULL, 0x0000003f00347306ULL, 0x000e62000000d400ULL,
0x0000005f5c00720bULL, 0x008fe40003f5d000ULL, 0x0000003c00107245ULL, 0x020fe4000020d400ULL,
0x0000003d00117245ULL, 0x000fc6000020d400ULL, 0x0000003500437306ULL, 0x000fe20000209400ULL,
0x0000000137373812ULL, 0x004fc800078efcffULL, 0x000000375a12723eULL, 0x000fe400000010ffULL,
0x0000000141412812ULL, 0x000fe200078efcffULL, 0x0000003500547306ULL, 0x000ea20000205400ULL,
0x0000000134340812ULL, 0x002fc800078efcffULL, 0x000000344113723eULL, 0x000fe400000010ffULL,
0x0000003500347245ULL, 0x000fe2000020d400ULL, 0x0000003c003e7306ULL, 0x000fe80000209400ULL,
0x000000122830723cULL, 0x000b680000041830ULL, 0x0000003c003f7306ULL, 0x000e620000205400ULL,
0x000000544300720bULL, 0x004fce0003f9d000ULL, 0x0000003d00537306ULL, 0x000fec0000209400ULL,
0x0000000134344812ULL, 0x000fe400078efcffULL, 0x0000003d00567306ULL, 0x000ea20000205400ULL,
0x0000003f3e00720bULL, 0x002fda0003fbd000ULL, 0x0000000110105812ULL, 0x000fe400078efcffULL,
0x000000565300720bULL, 0x004fe40003f7d000ULL, 0x000000100d10723eULL, 0x000fe200000010ffULL,
0x00000002000d7824ULL, 0x000fca00078e00ffULL, 0xfffffff80d127812ULL, 0x020fca00078ec0ffULL,
0x0000000111113812ULL, 0x000fc800078efcffULL, 0x000000113411723eULL, 0x000fce00000010ffULL,
0x000000102838723cULL, 0x000b6e0000041838ULL, 0x0000f6c873107811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000010107f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6900012ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0d7224ULL, 0x000fc600078e00ffULL, 0x0000000000127805ULL, 0x004fc80000015200ULL,
0x0000040007297984ULL, 0x000ea40000000800ULL, 0x8000000029ff7812ULL, 0x006fc40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028122b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e13ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc80000011429ULL, 0x0000002b28287211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000228287819ULL, 0x000fc80000001229ULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040007297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000107824ULL, 0x000fca00078e00ffULL,
0xffffffe0100d7812ULL, 0x000fca00078ec0ffULL, 0x00000100480d7824ULL, 0x000fca00078e020dULL,
0x000000c00d137810ULL, 0x000fe20007ffe0ffULL, 0x00005900400d7a24ULL, 0x010fc600078e02ffULL,
0x0000002013117812ULL, 0x000fe200078ec0ffULL, 0x000000400d0d7824ULL, 0x000fc800078e00ffULL,
0x00000001742a7824ULL, 0x000fe200078e0211ULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x0000001010297812ULL, 0x000fe400078ec0ffULL, 0x0000001302107217ULL, 0x000fe40007800000ULL,
0x00000003ff117819ULL, 0x000fe40000011649ULL, 0x000064000d357a11ULL, 0x000fe200078a38ffULL,
0x0000000110107824ULL, 0x000fe200078e0a13ULL, 0x0000000411287810ULL, 0x040fe20007ffe0ffULL,
0x0000000111127824ULL, 0x040fe200078e0229ULL, 0x0000000c112b7810ULL, 0x000fc40007ffe0ffULL,
0x0000001029107217ULL, 0x000fe20007800000ULL, 0x0000000112137824ULL, 0x040fe200078e0249ULL,
0x000065000d377a11ULL, 0x000fe200028f3cffULL, 0x0000000812347824ULL, 0x000fe400078e00ffULL,
0x0000000110107824ULL, 0x000fc600078e0a29ULL, 0xfffffff8343d7812ULL, 0x000fe200078ee213ULL,
0x000000012b347824ULL, 0x100fe200078e0229ULL, 0x0000000811137810ULL, 0x040fe40007ffe0ffULL,
0x000000101100720cULL, 0x080fe20003f86070ULL, 0x0000000112117824ULL, 0x000fe200078e022aULL,
0x000000102800720cULL, 0x0c0fe20003f66070ULL, 0x0000000128127824ULL, 0x100fe200078e0229ULL,
0x000000101300720cULL, 0x0c0fe20003f46070ULL, 0x0000000113287824ULL, 0x000fe200078e0229ULL,
0x000000102b00720cULL, 0x000fe20003f06070ULL, 0x0000000112137824ULL, 0x000fc400078e0249ULL,
0x0000000812367824ULL, 0x000fe400078e00ffULL, 0x0000008011107825ULL, 0x000fc600078e00ffULL,
0xfffffff8363f7812ULL, 0x000fe200078ee213ULL, 0x0000000112127824ULL, 0x000fe200078e022aULL,
0x0000004f10107212ULL, 0x000fe200078efcffULL, 0x0000000128297824ULL, 0x040fe400078e0249ULL,
0x00000008283c7824ULL, 0x000fe200078e00ffULL, 0x0000001035107210ULL, 0x000fe20007fbe0ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff83c417812ULL, 0x000fe200078ee229ULL,
0x0000000128287824ULL, 0x100fe200078e022aULL, 0x0000004f12127212ULL, 0x000fe200078efcffULL,
0x00000001342a7824ULL, 0x000fe400078e022aULL, 0x0000008028287825ULL, 0x000fc800078e00ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000004f28287212ULL, 0x000fc600078efcffULL,
0x0000000111117824ULL, 0x000fe200028e0637ULL, 0x0000003512127210ULL, 0x000fe20007fbe0ffULL,
0x00000001340d7824ULL, 0x000fe200078e0249ULL, 0x0000004f2a2a7212ULL, 0x000fe200078efcffULL,
0x0000000834347824ULL, 0x000fe400078e00ffULL, 0x0000000113137824ULL, 0x000fe200028e0637ULL,
0x0000003528287210ULL, 0x080fe40007fbe0ffULL, 0x000000352a2a7210ULL, 0x000fe20007fde0ffULL,
0x000000103f357824ULL, 0x100fe200078e0250ULL, 0xfffffff834437812ULL, 0x000fe200078ee20dULL,
0x000000103d0d7824ULL, 0x000fc400078e0250ULL, 0x0000000129297824ULL, 0x100fe400028e0637ULL,
0x000000012b2b7824ULL, 0x000fe200030e0637ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100d7faeULL, 0x0003e2000e101c46ULL, 0x0000001041377824ULL, 0x100fe400078e0250ULL,
0x00000010433d7824ULL, 0x000fe200078e0250ULL, 0x0000000012357faeULL, 0x0003e8000d901c46ULL,
0x0000000028377faeULL, 0x0003e8000d101c46ULL, 0x000000002a3d7faeULL, 0x0003e2000c101c46ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001010107812ULL, 0x000fe400078ec0ffULL,
0x000064000d377a11ULL, 0x000fc400078038ffULL, 0x0000001049117211ULL, 0x000fe400078fe8ffULL,
0x000065000d3d7a11ULL, 0x000fe400000f3cffULL, 0x0000000411137810ULL, 0x040fe20007ffe0ffULL,
0x0000000111127824ULL, 0x140fe200078e0249ULL, 0x0000000811297810ULL, 0x040fe20007ffe0ffULL,
0x0000000811357824ULL, 0x040fe200078e00ffULL, 0x0000000c112b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000111107824ULL, 0x000fe400078e022aULL, 0x0000000113117824ULL, 0x000fe200078e0249ULL,
0xfffffff835357812ULL, 0x000fe200078ee212ULL, 0x0000000813347824ULL, 0x000fc400078e00ffULL,
0x0000000113127824ULL, 0x100fe400078e022aULL, 0x0000000129287824ULL, 0x040fe200078e022aULL,
0xfffffff8343f7812ULL, 0x000fe200078ee211ULL, 0x0000000129137824ULL, 0x140fe400078e0249ULL,
0x0000000829367824ULL, 0x000fe400078e00ffULL, 0x000000012b297824ULL, 0x040fe400078e0249ULL,
0x000000082b3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff836417812ULL, 0x000fe200078ee213ULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff83c437812ULL, 0x000fe200078ee229ULL,
0x000000012b2a7824ULL, 0x000fe200078e022aULL, 0x0000004f10107212ULL, 0x000fe200078efcffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0x0000001037107210ULL, 0x000fe20007f1e0ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000004f12127212ULL, 0x000fc600078efcffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000004f28287212ULL, 0x080fe400078efcffULL,
0x0000001237127210ULL, 0x000fe20007f5e0ffULL, 0x0000000111117824ULL, 0x100fe200000e063dULL,
0x0000004f2a2a7212ULL, 0x000fe200078efcffULL, 0x00000010350d7824ULL, 0x100fe200078e0250ULL,
0x0000002837287210ULL, 0x000fe20007f1e0ffULL, 0x0000000113137824ULL, 0x100fe200010e063dULL,
0x0000002a372a7210ULL, 0x000fe20007f7e0ffULL, 0x000000103f357824ULL, 0x000fe200078e0250ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100d7faeULL, 0x0003e2000b901c46ULL,
0x0000000129297824ULL, 0x000fc400000e063dULL, 0x000000012b2b7824ULL, 0x000fe200018e063dULL,
0x0000000012357faeULL, 0x0003e2000b901c46ULL, 0x0000001041377824ULL, 0x100fe400078e0250ULL,
0x00000010433d7824ULL, 0x000fc600078e0250ULL, 0x0000000028377faeULL, 0x0003e8000b901c46ULL,
0x000000002a3d7faeULL, 0x0003e4000b901c46ULL, 0x00000008000d7824ULL, 0x002fe200078e00ffULL,
0x0000000309127810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff107424ULL, 0x000fc600078e00ffULL,
0xfffffff00d0d7812ULL, 0x000fe400078ec0ffULL, 0x000000031200720cULL, 0x000fe40003f06070ULL,
0x000000000d0473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000000175128824ULL, 0x000fc400078e0212ULL, 0x00000004ff138424ULL, 0x000fc800078e00ffULL,
0x0000660012128625ULL, 0x000fca00078e0013ULL, 0x0000000612108981ULL, 0x000522000c1e1900ULL,
0x0000f6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6b0000d287f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f648000a127f8cULL, 0x000664000c80043fULL, 0x00000000002a7805ULL, 0x000fc40000015200ULL,
0x00f64c000a0d7984ULL, 0x002e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x000000342a347210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e2bULL, 0x003d09003400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011435ULL,
0x000000340d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff347224ULL, 0x000fca00000e0635ULL,
0x000000020d0d7819ULL, 0x000fc80000001234ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000111117810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c000a0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020000a7824ULL, 0x008fca00078e00ffULL, 0xffffff800a0a7812ULL, 0x000fc800078ec0ffULL,
0x000001004f0d7810ULL, 0x000fca0007ffe00aULL, 0x00000001640d7824ULL, 0x000fca00078e020dULL,
0x00f000000d2a7984ULL, 0x000e680000000800ULL, 0x00f200000d117984ULL, 0x0006a20000000800ULL,
0x0000000b2a00720bULL, 0x002fe20003f1d000ULL, 0x0000e2227f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0d2b7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x000fd200078e000bULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000002770d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000b2a00720bULL, 0x000fe40003f54000ULL,
0x000000000d00720cULL, 0x000fe20003f05270ULL, 0x0000e1c27f007947ULL, 0x000fd4000b800000ULL,
0x00000000000a7806ULL, 0x000fc400010e0100ULL, 0x0000008000138824ULL, 0x000fe200078e024fULL,
0x0000000b2a0d8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100a127816ULL, 0x000fe200000000ffULL, 0x0000000164348824ULL, 0x000fca00078e0213ULL,
0x00f4000d34008388ULL, 0x0003e20000000800ULL, 0x000000ff1200720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000b2a127209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0aff7812ULL, 0x000fc6000780c0ffULL,
0x0000000b120d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d00357308ULL, 0x000e640000000800ULL, 0x000000350c0c7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011649ULL,
0x0000e0e27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d350d7589ULL, 0x0002e400000e0000ULL,
0x0000000d24247220ULL, 0x08cfe20000410000ULL, 0x0000000d25257220ULL, 0x080fe20000410000ULL,
0x0000000d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000d14147220ULL, 0x080fe20000410000ULL, 0x0000000d15157220ULL, 0x080fe20000410000ULL,
0x0000000d20207220ULL, 0x080fe20000410000ULL, 0x0000000d21217220ULL, 0x080fe20000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000d1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000d18187220ULL, 0x080fe20000410000ULL, 0x0000000d19197220ULL, 0x080fe20000410000ULL,
0x0000000d30307220ULL, 0x080fe20000410000ULL, 0x0000000d31317220ULL, 0x080fe20000410000ULL,
0x0000000d38387220ULL, 0x080fe20000410000ULL, 0x0000000d39397220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000aff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008490d7811ULL, 0x000fe200078ff0ffULL,
0x0000dfc27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d350d7589ULL, 0x00066400000e0000ULL,
0x0000000d26267220ULL, 0x086fe20000410000ULL, 0x0000000d27277220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d16167220ULL, 0x080fe20000410000ULL, 0x0000000d17177220ULL, 0x080fe20000410000ULL,
0x0000000d22227220ULL, 0x080fe20000410000ULL, 0x0000000d23237220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000d1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000d32327220ULL, 0x080fe20000410000ULL, 0x0000000d33337220ULL, 0x080fe20000410000ULL,
0x0000000d3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000d3b3b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff2bff7812ULL, 0x000fe2000780600aULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000b2a0a7209ULL, 0x000fd60007810000ULL,
0x8000000a2a2a0221ULL, 0x000fe20000010000ULL, 0x00007610ff0d0816ULL, 0x000fc6000000000dULL,
0x3fb8aa3b2a2a0820ULL, 0x000fc80000410000ULL, 0x0000002a00060308ULL, 0x000e640000000800ULL,
0x0000000611110220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000c110c7221ULL, 0x004fc20000010000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x00000008000b7824ULL, 0x000fca00078e00ffULL, 0xfffffff00b117812ULL, 0x000fca00078ec0ffULL,
0x00f6ac00110b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a122a7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e13ULL, 0x003d09002a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc8000001142bULL,
0x0000002a0b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff2a7224ULL, 0x000fca00000e062bULL,
0x000000020b0b7819ULL, 0x000fc8000000122aULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac00110b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100d0b7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0b00720cULL, 0x000fda0003f65270ULL, 0x0000012000003947ULL, 0x000fea0003800000ULL,
0x00000006ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011649ULL,
0x00005410040b7816ULL, 0x000fe20000000004ULL, 0x0000db727f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0b057589ULL, 0x0002a400000e0000ULL, 0x000000080e0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000dba27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0b047589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100e0d7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e000bULL, 0x00009d7000137802ULL, 0x000fc40000000f00ULL,
0x0000e20000007944ULL, 0x01cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180e0d7810ULL, 0x006fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e000bULL,
0x00009dc000137802ULL, 0x000fc40000000f00ULL, 0x0000e1b000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001045457824ULL, 0x100fe200078e025dULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000104c3e7824ULL, 0x000fc400078e025dULL,
0x000000104b347824ULL, 0x000fe400078e025dULL, 0x000000004544783bULL, 0x000e680000004200ULL,
0x000000003434783bULL, 0x008fe20000004200ULL, 0x0000010044117824ULL, 0x002fe200078e00ffULL,
0x0000004500427306ULL, 0x000fe20000009400ULL, 0x00000100454c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0d7819ULL, 0x004fc40000011444ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000004500437306ULL, 0x000e620000005400ULL,
0x00000018ff127819ULL, 0x000fce0000011445ULL, 0x0000001100407306ULL, 0x000ff00000209400ULL,
0x0000001100417306ULL, 0x000ea20000205400ULL, 0x000000434200720bULL, 0x002fce0003f1d000ULL,
0x0000000d000b7306ULL, 0x000ff00000209400ULL, 0x0000000d000e7306ULL, 0x0002e20000205400ULL,
0x000000414000720bULL, 0x004fe40003f5d000ULL, 0x00a000004e40783bULL, 0x000eaa0000000200ULL,
0x00000044003c7306ULL, 0x000fe20000009400ULL, 0x0000000d000d7245ULL, 0x002fce000020d400ULL,
0x00000044003d7306ULL, 0x000e620000005400ULL, 0x0000000e0b00720bULL, 0x008fce0003f9d000ULL,
0x0000004c00697306ULL, 0x000fec0000209400ULL, 0x000000010d0d4812ULL, 0x000fe400078efcffULL,
0x0000004c00727306ULL, 0x0006a20000205400ULL, 0x0000003d3c00720bULL, 0x002fe40003fdd000ULL,
0x000000003e3c783bULL, 0x000e6a0000004200ULL, 0x0000004400587306ULL, 0x0004a2000000d400ULL,
0x0000004c004c7245ULL, 0x008fe2000020d400ULL, 0x000000054040b231ULL, 0x004fc400003400ffULL,
0x000000054242b231ULL, 0x000fe400003400ffULL, 0x000000044141b231ULL, 0x080fe400003400ffULL,
0x0000004500597306ULL, 0x0004e2000000d400ULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x000000726900720bULL, 0x000fe20003fbd000ULL, 0x000000044343b231ULL, 0x000fe200003400ffULL,
0x0000001100697245ULL, 0x000fe4000020d400ULL, 0x00000018ff447819ULL, 0x000fc40000011444ULL,
0x00000012000f7306ULL, 0x000fe20000209400ULL, 0x0001000045457824ULL, 0x004fe200078e00ffULL,
0x0000000169692812ULL, 0x000fe400078efcffULL, 0x0000000158586812ULL, 0x000fe400078efcffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000001200687306ULL, 0x000ea20000205400ULL,
0x000000014c4c5812ULL, 0x000fe400078efcffULL, 0x0000000159590812ULL, 0x008fc400078efcffULL,
0x000000586958723eULL, 0x000fe400000010ffULL, 0x000000594c59723eULL, 0x000fe200000010ffULL,
0x00000044005f7306ULL, 0x000fe20000209400ULL, 0x00000012004c7245ULL, 0x000fca000020d400ULL,
0x000000584024723cULL, 0x000f640000041824ULL, 0x00000044006c7306ULL, 0x0006620000205400ULL,
0x000000680f00720bULL, 0x004fe20003f5d000ULL, 0x0001000047687824ULL, 0x000fca00078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x00000045006a7306ULL, 0x000fe20000209400ULL,
0x0000004400447245ULL, 0x008fca000020d400ULL, 0x000000014c4c2812ULL, 0x000fe400078efcffULL,
0x00000045000b7306ULL, 0x0004e20000205400ULL, 0x0000006c5f00720bULL, 0x002fe40003fdd000ULL,
0x00000018ff5f7819ULL, 0x000fca0000011446ULL, 0x0000004600607306ULL, 0x000fe20000009400ULL,
0x0000004500457245ULL, 0x004fca000020d400ULL, 0x0000000144446812ULL, 0x000fe400078efcffULL,
0x0000000b6a00720bULL, 0x008fe20003fbd000ULL, 0x0000004600617306ULL, 0x000e620000005400ULL,
0x000000440d44723eULL, 0x000fce00000010ffULL, 0x0000004600657306ULL, 0x000ea8000000d400ULL,
0x0000000145455812ULL, 0x000fc800078efcffULL, 0x000000454c45723eULL, 0x000fe200000010ffULL,
0x00000100464c7824ULL, 0x000fe200078e00ffULL, 0x0000004700667306ULL, 0x000fe20000009400ULL,
0x000000616000720bULL, 0x002fc80003f1d000ULL, 0x00000044402c723cULL, 0x000be6000004182cULL,
0x0000004700677306ULL, 0x000e680000005400ULL, 0x00000018ff447819ULL, 0x020fe2000001144cULL,
0x00000100474c7824ULL, 0x000fe200078e00ffULL, 0x0000000165650812ULL, 0x004fe400078efcffULL,
0x0000004400457306ULL, 0x000fe40000209400ULL, 0x00000018ff4c7819ULL, 0x000fc8000001144cULL,
0x0000004c006c7245ULL, 0x000fe4000020d400ULL, 0x0000004400587306ULL, 0x000ea20000205400ULL,
0x000000676600720bULL, 0x002fe20003f9d000ULL, 0x0001000046677824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fc80000011447ULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000004c00597306ULL, 0x000fe20000209400ULL, 0x000000584500720bULL, 0x004fce0003f5d000ULL,
0x0000004c00607306ULL, 0x000e620000205400ULL, 0x0000004400587245ULL, 0x000fe2000020d400ULL,
0x000000104a447824ULL, 0x000fcc00078e025dULL, 0x0000004700137306ULL, 0x0004e2000000d400ULL,
0x0000000158582812ULL, 0x000fce00078efcffULL, 0x0000006600617306ULL, 0x000fe20000209400ULL,
0x000000655858723eULL, 0x000fe200000010ffULL, 0x000000004444783bULL, 0x004ea20000004200ULL,
0x000000605900720bULL, 0x002fca0003fbd000ULL, 0x0000006600697306ULL, 0x0002620000205400ULL,
0x0000000113134812ULL, 0x008fce00078efcffULL, 0x00000068004a7306ULL, 0x000fe20000209400ULL,
0x000000016c6c5812ULL, 0x000fe400078efcffULL, 0x0000006600667245ULL, 0x002fe4000020d400ULL,
0x000000136c59723eULL, 0x000fc600000010ffULL, 0x0000006800657306ULL, 0x0002e20000205400ULL,
0x000000696100720bULL, 0x000fe20003fbd000ULL, 0x0000010034697824ULL, 0x000fe400078e00ffULL,
0x000000584014723cULL, 0x000b660000041814ULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x0000005f004e7306ULL, 0x000fe60000209400ULL, 0x0000006800597245ULL, 0x020fe2000020d400ULL,
0x0000010035687824ULL, 0x002fe200078e00ffULL, 0x0000006700587245ULL, 0x000fc4000020d400ULL,
0x0000000166665812ULL, 0x000fe200078efcffULL, 0x0000005f006a7306ULL, 0x0002a20000205400ULL,
0x000000654a00720bULL, 0x008fe40003f9d000ULL, 0x00000018ff687819ULL, 0x000fca0000011468ULL,
0x0000006700607306ULL, 0x000fe20000209400ULL, 0x0000005f005f7245ULL, 0x002fca000020d400ULL,
0x0000000159594812ULL, 0x000fe400078efcffULL, 0x00000067006b7306ULL, 0x000e620000205400ULL,
0x0000006a4e00720bULL, 0x004fe40003f5d000ULL, 0x000000596659723eULL, 0x000fca00000010ffULL,
0x0000006900657306ULL, 0x000fec0000209400ULL, 0x000000015f5f2812ULL, 0x000fe400078efcffULL,
0x0000006900667306ULL, 0x000ea20000205400ULL, 0x0000006b6000720bULL, 0x002fce0003f1d000ULL,
0x00000034005c7306ULL, 0x000fec0000009400ULL, 0x0000000158580812ULL, 0x000fe400078efcffULL,
0x00000034005b7306ULL, 0x000e620000005400ULL, 0x000000666500720bULL, 0x004fe20003f5d000ULL,
0x0001000034657824ULL, 0x000fe200078e00ffULL, 0x000000585f58723eULL, 0x000fe200000010ffULL,
0x0001000035667824ULL, 0x000fc600078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x00000035005a7306ULL, 0x000fe20000009400ULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x000000584020723cULL, 0x000bec0000041820ULL, 0x00000035005e7306ULL, 0x000ea20000005400ULL,
0x0000005b5c00720bULL, 0x002fc40003f1d000ULL, 0x00000018ff5c7819ULL, 0x000fca0000011434ULL,
0x0000006800677306ULL, 0x000ff00000209400ULL, 0x00000068006a7306ULL, 0x000e620000205400ULL,
0x0000005e5a00720bULL, 0x004fe40003f9d000ULL, 0x00000018ff5e7819ULL, 0x000fca0000011435ULL,
0x0000003400577306ULL, 0x0004f0000000d400ULL, 0x0000003500567306ULL, 0x0006e2000000d400ULL,
0x0000006a6700720bULL, 0x002fe40003fbd000ULL, 0x0000006900347245ULL, 0x004fc8000020d400ULL,
0x0000000134342812ULL, 0x000fe200078efcffULL, 0x0000005c00597306ULL, 0x020fe20000209400ULL,
0x0000006800357245ULL, 0x008fe4000020d400ULL, 0x0000000157570812ULL, 0x000fc600078efcffULL,
0x0000000135355812ULL, 0x000fe400078efcffULL, 0x0000005c005a7306ULL, 0x000e620000205400ULL,
0x0000000156564812ULL, 0x000fe400078efcffULL, 0x000000573434723eULL, 0x000fe400000010ffULL,
0x000000563535723eULL, 0x000fc600000010ffULL, 0x00000065006a7306ULL, 0x000fe80000209400ULL,
0x00000034401c723cULL, 0x000b68000004181cULL, 0x00000065006b7306ULL, 0x0004e20000205400ULL,
0x0000005a5900720bULL, 0x002fe40003f5d000ULL, 0x0000005c00357245ULL, 0x020fc4000020d400ULL,
0x0000006500347245ULL, 0x000fc6000020d400ULL, 0x0000005e005b7306ULL, 0x000fe20000209400ULL,
0x00000018ff657819ULL, 0x004fca0000011436ULL, 0x0000000135352812ULL, 0x000fe400078efcffULL,
0x0000005e00677306ULL, 0x000e620000205400ULL, 0x0000006b6a00720bULL, 0x008fce0003f1d000ULL,
0x0000006600697306ULL, 0x000fec0000209400ULL, 0x0000000134340812ULL, 0x000fe400078efcffULL,
0x0000006600687306ULL, 0x000ea20000205400ULL, 0x000000675b00720bULL, 0x002fe40003fbd000ULL,
0x000000343534723eULL, 0x000fc400000010ffULL, 0x0000006600357245ULL, 0x000fc6000020d400ULL,
0x0000006500677306ULL, 0x000fe20000209400ULL, 0x000000686900720bULL, 0x004fe20003f9d000ULL,
0x0000010037697824ULL, 0x000fe200078e00ffULL, 0x0000005e00687245ULL, 0x000fe2000020d400ULL,
0x00000100365e7824ULL, 0x000fc800078e00ffULL, 0x00000065006b7306ULL, 0x0002a20000205400ULL,
0x0000000168685812ULL, 0x000fe400078efcffULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x00000018ff697819ULL, 0x000fc60000011469ULL, 0x0000005e00667306ULL, 0x000fe20000209400ULL,
0x0000000135354812ULL, 0x000fe400078efcffULL, 0x0000006500657245ULL, 0x002fe4000020d400ULL,
0x000000356835723eULL, 0x000fc600000010ffULL, 0x0000005e00687306ULL, 0x000e620000205400ULL,
0x0000006b6700720bULL, 0x004fc60003f1d000ULL, 0x000000344018723cULL, 0x000b680000041818ULL,
0x00000069006a7306ULL, 0x000fe60000209400ULL, 0x00000018ff347819ULL, 0x020fc60000011437ULL,
0x0000000165650812ULL, 0x000fe400078efcffULL, 0x0000006900357306ULL, 0x000ea20000205400ULL,
0x000000686600720bULL, 0x002fe20003f5d000ULL, 0x0001000037667824ULL, 0x000fca00078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x00000036002a7306ULL, 0x000ff00000009400ULL,
0x00000036002b7306ULL, 0x000e620000005400ULL, 0x000000356a00720bULL, 0x004fe20003f9d000ULL,
0x0001000036357824ULL, 0x000fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000003700537306ULL, 0x000ff00000009400ULL, 0x0000003700547306ULL, 0x000ea20000005400ULL,
0x0000002b2a00720bULL, 0x002fce0003fdd000ULL, 0x0000003400677306ULL, 0x000ff00000209400ULL,
0x0000003400687306ULL, 0x000e620000205400ULL, 0x000000545300720bULL, 0x004fe40003fbd000ULL,
0x0000005e00547245ULL, 0x000fc8000020d400ULL, 0x0000000154542812ULL, 0x000fe200078efcffULL,
0x00000036004b7306ULL, 0x000eb0000000d400ULL, 0x00000035002b7306ULL, 0x000fe20000209400ULL,
0x000000686700720bULL, 0x002fce0003f5d000ULL, 0x0000003500367306ULL, 0x000e620000205400ULL,
0x000000014b4b6812ULL, 0x004fc800078efcffULL, 0x0000004b5454723eULL, 0x000fe400000010ffULL,
0x00000018ff4b7819ULL, 0x000fe2000001143cULL, 0x0000003700557306ULL, 0x000eb0000000d400ULL,
0x0000006600377306ULL, 0x000fe20000209400ULL, 0x000000362b00720bULL, 0x002fc40003fdd000ULL,
0x0000006900367245ULL, 0x000fc8000020d400ULL, 0x0000000136364812ULL, 0x000fe200078efcffULL,
0x0000006600687306ULL, 0x000e620000205400ULL, 0x0000000155555812ULL, 0x004fc800078efcffULL,
0x000000553655723eULL, 0x000fc600000010ffULL, 0x0000003c000e7306ULL, 0x000fe80000009400ULL,
0x000000544030723cULL, 0x000b620000041830ULL, 0x000000683700720bULL, 0x002fc60003f9d000ULL,
0x0000003c00117306ULL, 0x000e620000005400ULL, 0x0000003400687245ULL, 0x000fe4000020d400ULL,
0x0000003500347245ULL, 0x000fe4000020d400ULL, 0x0000006600357245ULL, 0x000fe4000020d400ULL,
0x0000000168682812ULL, 0x000fe200078efcffULL, 0x0000003c000b7306ULL, 0x000ea2000000d400ULL,
0x0000000134346812ULL, 0x000fe400078efcffULL, 0x00000018ff547819ULL, 0x020fc4000001143dULL,
0x0000000135354812ULL, 0x000fe400078efcffULL, 0x000000346534723eULL, 0x000fe200000010ffULL,
0x0000004b00367306ULL, 0x000fe20000209400ULL, 0x000000356835723eULL, 0x000fe400000010ffULL,
0x000000110e00720bULL, 0x002fe20003f9d000ULL, 0x000001003d0e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe4000001143fULL, 0x00000018ff117819ULL, 0x000fe20000011444ULL,
0x000000344038723cULL, 0x000b620000041838ULL, 0x0000004b00377306ULL, 0x000e620000205400ULL,
0x00000018ff0e7819ULL, 0x000fca000001140eULL, 0x000001003c347824ULL, 0x060fe200078e00ffULL,
0x000000010b0b4812ULL, 0x004fe200078efcffULL, 0x000100003c427824ULL, 0x000fe200078e00ffULL,
0x0000003d000f7306ULL, 0x000fe20000009400ULL, 0x00000018ff407819ULL, 0x000fe4000001143eULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x000000373600720bULL, 0x002fe20003f9d000ULL, 0x0000003400357306ULL, 0x000ff00000209400ULL,
0x00000034003c7306ULL, 0x000e700000205400ULL, 0x0000004200437306ULL, 0x000ff00000209400ULL,
0x00000042006c7306ULL, 0x000ea20000205400ULL, 0x0000003c3500720bULL, 0x002fc40003fbd000ULL,
0x00000034003c7245ULL, 0x000fe4000020d400ULL, 0x00a000004d34783bULL, 0x000e660000000200ULL,
0x0000003d00127306ULL, 0x000eec0000005400ULL, 0x000000013c3c5812ULL, 0x000fc400078efcffULL,
0x0000003f00607306ULL, 0x000fe20000009400ULL, 0x0000006c4300720bULL, 0x004fe40003f5d000ULL,
0x0000000b3c3c723eULL, 0x000fca00000010ffULL, 0x0000003f00617306ULL, 0x000ea20000005400ULL,
0x000000120f00720bULL, 0x008fe40003fdd000ULL, 0x00000018ff0f7819ULL, 0x000fca0000011445ULL,
0x00000044005f7306ULL, 0x000ff00000009400ULL, 0x0000004400587306ULL, 0x000ee20000005400ULL,
0x000000616000720bULL, 0x004fe20003fbd000ULL, 0x0001000045617824ULL, 0x000fe200078e00ffULL,
0x0000004200607245ULL, 0x000fe2000020d400ULL, 0x000100003d427824ULL, 0x000fe200078e00ffULL,
0x000000053434b231ULL, 0x002fc400003400ffULL, 0x0000000160602812ULL, 0x000fe200078efcffULL,
0x0000003e004c7306ULL, 0x000fe20000009400ULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x000000053636b231ULL, 0x000fe200003400ffULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x000000043535b231ULL, 0x080fe400003400ffULL, 0x000000043737b231ULL, 0x000fe400003400ffULL,
0x0000003e004e7306ULL, 0x000e620000005400ULL, 0x000000585f00720bULL, 0x008fe20003f5d000ULL,
0x000100003e587824ULL, 0x000fe200078e00ffULL, 0x0000004b005f7245ULL, 0x000fc8000020d400ULL,
0x000000015f5f4812ULL, 0x000fe200078efcffULL, 0x0000000e00127306ULL, 0x000fe20000209400ULL,
0x00000018ff587819ULL, 0x000fce0000011458ULL, 0x0000000e00437306ULL, 0x000ea20000205400ULL,
0x0000004e4c00720bULL, 0x002fce0003f1d000ULL, 0x0000003d000d7306ULL, 0x0002f0000000d400ULL,
0x00000042004b7306ULL, 0x000fe20000209400ULL, 0x000000431200720bULL, 0x004fe20003f9d000ULL,
0x000001003e127824ULL, 0x000fe200078e00ffULL, 0x0000000e003d7245ULL, 0x002fe2000020d400ULL,
0x000001003f437824ULL, 0x000fc600078e00ffULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x00000042004c7306ULL, 0x000e620000205400ULL, 0x000000010d0d6812ULL, 0x008fe400078efcffULL,
0x00000018ff437819ULL, 0x000fc60000011443ULL, 0x000000013d3d4812ULL, 0x000fe400078efcffULL,
0x0000005400557306ULL, 0x000fe40000209400ULL, 0x0000000d3d3d723eULL, 0x000fcc00000010ffULL,
0x0000005400657306ULL, 0x000ea20000205400ULL, 0x0000004c4b00720bULL, 0x002fe20003fdd000ULL,
0x0000003c3424723cULL, 0x000b6c0000041824ULL, 0x00000012004d7306ULL, 0x000ff00000209400ULL,
0x00000012000e7306ULL, 0x000e620000205400ULL, 0x000000655500720bULL, 0x004fc40003f7d000ULL,
0x0000004200557245ULL, 0x000fc8000020d400ULL, 0x0000000155556812ULL, 0x000fe200078efcffULL,
0x0000004500597306ULL, 0x000ff00000009400ULL, 0x00000045005a7306ULL, 0x000ea20000005400ULL,
0x0000000e4d00720bULL, 0x002fc40003fdd000ULL, 0x00000018ff0e7819ULL, 0x000fca0000011446ULL,
0x00000046005b7306ULL, 0x000ff00000009400ULL, 0x00000046005c7306ULL, 0x000e620000005400ULL,
0x0000005a5900720bULL, 0x004fe40003f9d000ULL, 0x0000005400597245ULL, 0x000fc8000020d400ULL,
0x0000000159593812ULL, 0x000fe200078efcffULL, 0x00000043004b7306ULL, 0x000ff00000209400ULL,
0x00000043004c7306ULL, 0x000ea20000205400ULL, 0x0000005c5b00720bULL, 0x002fc40003f7d000ULL,
0x00000012005b7245ULL, 0x000fe4000020d400ULL, 0x00000018ff127819ULL, 0x000fe40000011447ULL,
0x000000015b5b6812ULL, 0x000fe200078efcffULL, 0x0000003e00137306ULL, 0x000e70000000d400ULL,
0x0000004700537306ULL, 0x000fe20000009400ULL, 0x0000004c4b00720bULL, 0x004fe20003fdd000ULL,
0x000100003f4c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x00000047005e7306ULL, 0x000ea20000005400ULL, 0x0000000113130812ULL, 0x002fc800078efcffULL,
0x000000135b3c723eULL, 0x020fc600000010ffULL, 0x0000003f004a7306ULL, 0x000e70000000d400ULL,
0x00000058003e7306ULL, 0x000fe20000209400ULL, 0x0000005e5300720bULL, 0x004fe40003f1d000ULL,
0x00000043005e7245ULL, 0x000fc8000020d400ULL, 0x000000015e5e6812ULL, 0x000fe200078efcffULL,
0x00000058003f7306ULL, 0x0004e20000205400ULL, 0x000000014a4a5812ULL, 0x002fc800078efcffULL,
0x0000004a5e3d723eULL, 0x000fc600000010ffULL, 0x0000004000417306ULL, 0x000fe20000209400ULL,
0x0000005800587245ULL, 0x004fc6000020d400ULL, 0x0000003c3414723cULL, 0x000b680000041814ULL,
0x00000040006a7306ULL, 0x000e620000205400ULL, 0x0000003f3e00720bULL, 0x008fe20003fdd000ULL,
0x00000100443e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000004c004d7306ULL, 0x000fec0000209400ULL, 0x0000000158586812ULL, 0x000fe400078efcffULL,
0x0000004c005a7306ULL, 0x0004e20000205400ULL, 0x0000006a4100720bULL, 0x002fe20003fbd000ULL,
0x0000010045417824ULL, 0x000fca00078e00ffULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0000006600687306ULL, 0x000fe20000209400ULL, 0x0000004c004c7245ULL, 0x004fce000020d400ULL,
0x0000006600697306ULL, 0x000e620000205400ULL, 0x0000005a4d00720bULL, 0x008fe40003fdd000ULL,
0x00000040005a7245ULL, 0x000fe4000020d400ULL, 0x00000066004d7245ULL, 0x000fe4000020d400ULL,
0x000000015a5a5812ULL, 0x000fe200078efcffULL, 0x0000003e00537306ULL, 0x000fec0000209400ULL,
0x000000014c4c6812ULL, 0x000fc400078efcffULL, 0x0000003e005c7306ULL, 0x000ea20000205400ULL,
0x000000696800720bULL, 0x002fe20003fbd000ULL, 0x0001000044687824ULL, 0x000fca00078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x0000001100677306ULL, 0x000fec0000209400ULL,
0x000000014d4d5812ULL, 0x000fe400078efcffULL, 0x00000011004e7306ULL, 0x0002e20000205400ULL,
0x0000005c5300720bULL, 0x004fce0003fdd000ULL, 0x00000041003f7306ULL, 0x000fe20000209400ULL,
0x0000001100117245ULL, 0x002fce000020d400ULL, 0x0000004100407306ULL, 0x0002a20000205400ULL,
0x0000004e6700720bULL, 0x008fe20003fbd000ULL, 0x00000100464e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000004500567306ULL, 0x0006a2000000d400ULL,
0x0000004100417245ULL, 0x002fca000020d400ULL, 0x0000000111115812ULL, 0x000fe400078efcffULL,
0x0000004400577306ULL, 0x000e62000000d400ULL, 0x0000003e00457245ULL, 0x008fc8000020d400ULL,
0x0000000145456812ULL, 0x000fe400078efcffULL, 0x000000403f00720bULL, 0x004fe20003fdd000ULL,
0x0000006800447306ULL, 0x000fe20000209400ULL, 0x0000010047407824ULL, 0x000fe200078e00ffULL,
0x0000000156564812ULL, 0x000fc800078efcffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000006800537306ULL, 0x0004e20000205400ULL, 0x0000000157572812ULL, 0x002fc600078efcffULL,
0x0000000141416812ULL, 0x000fe400078efcffULL, 0x00000057453c723eULL, 0x020fe400000010ffULL,
0x00000046002a7306ULL, 0x0002e2000000d400ULL, 0x0000006800687245ULL, 0x004fe4000020d400ULL,
0x00000056413d723eULL, 0x000fca00000010ffULL, 0x0000000f006b7306ULL, 0x000fe20000209400ULL,
0x0001000046467824ULL, 0x002fe200078e00ffULL, 0x000000534400720bULL, 0x008fe20003fdd000ULL,
0x0000003c341c723cULL, 0x000f66000004181cULL, 0x00000018ff0b7819ULL, 0x000fe20000011446ULL,
0x0001000047467824ULL, 0x000fe200078e00ffULL, 0x0000000f006c7306ULL, 0x000e620000205400ULL,
0x000000012a2a3812ULL, 0x000fc600078efcffULL, 0x00000018ff467819ULL, 0x000fc60000011446ULL,
0x0000000168686812ULL, 0x000fe200078efcffULL, 0x00000061003e7306ULL, 0x000ff00000209400ULL,
0x00000061003f7306ULL, 0x0004e20000205400ULL, 0x0000006c6b00720bULL, 0x002fce0003f5d000ULL,
0x0000004e00657306ULL, 0x000fe20000209400ULL, 0x0000006100617245ULL, 0x004fce000020d400ULL,
0x0000004e00667306ULL, 0x000e620000205400ULL, 0x0000003f3e00720bULL, 0x008fe40003f9d000ULL,
0x000000605f3e723eULL, 0x000fe400000010ffULL, 0x00000055593f723eULL, 0x000fc600000010ffULL,
0x0000000e00427306ULL, 0x000fe80000209400ULL, 0x0000003e342c723cULL, 0x000b64000004182cULL,
0x0000000161614812ULL, 0x000fe400078efcffULL, 0x0000000e00547306ULL, 0x0004e20000205400ULL,
0x000000666500720bULL, 0x002fe40003fbd000ULL, 0x000000585a3e723eULL, 0x020fc400000010ffULL,
0x0000004c4d3f723eULL, 0x000fc600000010ffULL, 0x0000004000537306ULL, 0x000fe20000209400ULL,
0x0000000e000e7245ULL, 0x004fc6000020d400ULL, 0x0000003e3420723cULL, 0x000b680000041820ULL,
0x00000040005c7306ULL, 0x0002a20000205400ULL, 0x000000544200720bULL, 0x008fe40003fdd000ULL,
0x0000000f00427245ULL, 0x000fe4000020d400ULL, 0x0000004e000f7245ULL, 0x000fe4000020d400ULL,
0x0000000142422812ULL, 0x000fe200078efcffULL, 0x0000001200437306ULL, 0x000fe20000209400ULL,
0x000000010f0f5812ULL, 0x000fc400078efcffULL, 0x0000004000407245ULL, 0x002fe4000020d400ULL,
0x0000002a0f2a723eULL, 0x000fe400000010ffULL, 0x00000046000f7245ULL, 0x000fe2000020d400ULL,
0x00000012004b7306ULL, 0x0002e20000205400ULL, 0x0000005c5300720bULL, 0x004fe40003f5d000ULL,
0x000000010e0e6812ULL, 0x000fe400078efcffULL, 0x00000068113e723eULL, 0x020fc400000010ffULL,
0x00000061423f723eULL, 0x000fe200000010ffULL, 0x0000000b000d7306ULL, 0x000fe20000209400ULL,
0x0000001200127245ULL, 0x002fca000020d400ULL, 0x0000000140402812ULL, 0x000fe200078efcffULL,
0x0000003e3418723cULL, 0x000f620000041818ULL, 0x0000000b00447306ULL, 0x0002a20000205400ULL,
0x0000004b4300720bULL, 0x008fce0003f9d000ULL, 0x0000004600137306ULL, 0x000fe20000209400ULL,
0x0000000b000b7245ULL, 0x002fca000020d400ULL, 0x0000000112124812ULL, 0x000fe400078efcffULL,
0x00000046004a7306ULL, 0x000e620000205400ULL, 0x000000440d00720bULL, 0x004fce0003fbd000ULL,
0x00000047002b7306ULL, 0x000eac000000d400ULL, 0x000000010b0b5812ULL, 0x000fe400078efcffULL,
0x0000004a1300720bULL, 0x002fe40003f7d000ULL, 0x0000000b0e0e723eULL, 0x000fe200000010ffULL,
0x00000002000b7824ULL, 0x000fe200078e00ffULL, 0x000000012b2b0812ULL, 0x004fc800078efcffULL,
0xfffffff80b0d7812ULL, 0x000fe400078ec0ffULL, 0x0000002b402b723eULL, 0x000fc600000010ffULL,
0x000000010f0f3812ULL, 0x000fc800078efcffULL, 0x0000000f120f723eULL, 0x000fe200000010ffULL,
0x0000002a3430723cULL, 0x040f700000041830ULL, 0x0000000e3434723cULL, 0x000b6e0000041838ULL,
0x0000f6c8730e7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000000e0e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f698000dff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff0b7224ULL, 0x000fc600078e00ffULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x00000400070d7984ULL, 0x004ea40000000800ULL,
0x800000000dff7812ULL, 0x006fc4000780480fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a122a7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e13ULL, 0x003d09002a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc8000001142bULL,
0x0000002a0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff2a7224ULL, 0x000fca00000e062bULL,
0x000000020d0d7819ULL, 0x000fc8000000122aULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400070d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001480d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000309097810ULL, 0x000fe40007ffe0ffULL,
0x000000710d00720cULL, 0x000fda0003f06070ULL, 0x0000085000000947ULL, 0x000fea0003800000ULL,
0x00000002480e7810ULL, 0x000fe20007ffe0ffULL, 0x000001000d0d7824ULL, 0x000fe400078e027cULL,
0x0000590010097a24ULL, 0x010fe200078e02ffULL, 0x000000710e00720cULL, 0x000fe40003f06070ULL,
0x000000200d0b7812ULL, 0x000fe200078ec0ffULL, 0x0000004009097824ULL, 0x000fc800078e00ffULL,
0x00000001742a7824ULL, 0x000fcc00078e020bULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x0000000d020b7217ULL, 0x000fe20007800000ULL, 0x00000010000e7824ULL, 0x000fc800078e00ffULL,
0x000000010b0b7824ULL, 0x000fe200078e0a0dULL, 0x000000100e0e7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011649ULL, 0x0000000b0e0b7217ULL, 0x000fe40007800000ULL,
0x000000040d0f7810ULL, 0x040fe40007ffe0ffULL, 0x000000080d107810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0b7824ULL, 0x100fe200078e0a0eULL, 0x0000000c0d127810ULL, 0x000fe20007ffe0ffULL,
0x000000010f117824ULL, 0x000fc400078e020eULL, 0x0000000110137824ULL, 0x140fe200078e020eULL,
0x0000000b1000720cULL, 0x080fe20003f46070ULL, 0x0000000111107824ULL, 0x100fe200078e0249ULL,
0x0000000b0d00720cULL, 0x080fe20003f86070ULL, 0x0000000811397824ULL, 0x000fe200078e00ffULL,
0x0000000b0f00720cULL, 0x080fe20003f66070ULL, 0x000000010d0d7824ULL, 0x100fe200078e020eULL,
0x0000000b1200720cULL, 0x040fe20003f06070ULL, 0x00000001122b7824ULL, 0x000fe200078e020eULL,
0xfffffff8393a7812ULL, 0x000fe200078ee210ULL, 0x000000010d0f7824ULL, 0x000fc400078e0249ULL,
0x000000080d387824ULL, 0x040fe400078e00ffULL, 0x000000010d107824ULL, 0x100fe400078e022aULL,
0x00000001110e7824ULL, 0x000fe200078e022aULL, 0xfffffff838387812ULL, 0x000fe200078ee20fULL,
0x00000001130b7824ULL, 0x040fe400078e0249ULL, 0x00000008133c7824ULL, 0x000fe400078e00ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee20bULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00006400090b7a11ULL, 0x000fe400078a38ffULL,
0x0000004f10107212ULL, 0x080fe200078efcffULL, 0x0000000113127824ULL, 0x100fe200078e022aULL,
0x0000004f0e0e7212ULL, 0x000fe200078efcffULL, 0x000000012b2a7824ULL, 0x000fe200078e022aULL,
0x0000650009097a11ULL, 0x000fe200028f3cffULL, 0x000000012b0d7824ULL, 0x000fe200078e0249ULL,
0x000000100b107210ULL, 0x000fe20007fbe0ffULL, 0x000000082b3e7824ULL, 0x000fe200078e00ffULL,
0x0000000b0e0e7210ULL, 0x000fe20007fde0ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000004f12127212ULL, 0x000fc600078efcffULL, 0x0000000111117824ULL, 0x100fe200028e0609ULL,
0x0000004f2a2a7212ULL, 0x000fe200078efcffULL, 0x000000010f0f7824ULL, 0x000fe200030e0609ULL,
0x0000000b12127210ULL, 0x080fe20007fbe0ffULL, 0x000000103a0d7824ULL, 0x100fe200078e025dULL,
0x0000000b2a2a7210ULL, 0x000fe20007fde0ffULL, 0x00000010380b7824ULL, 0x100fe400078e025dULL,
0x000000103c397824ULL, 0x000fe400078e025dULL, 0x0000000113137824ULL, 0x000fe200028e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100b7faeULL, 0x0003e2000e101c46ULL,
0x000000103e5d7824ULL, 0x000fc400078e025dULL, 0x000000012b2b7824ULL, 0x000fe200030e0609ULL,
0x000000000e0d7faeULL, 0x0003e8000d901c46ULL, 0x0000000012397faeULL, 0x0003e8000d101c46ULL,
0x000000002a5d7faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010000b7824ULL, 0x000fca00078e00ffULL, 0x000000100b0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000e490b7211ULL, 0x000fc800078fe8ffULL, 0x000000040b0f7810ULL, 0x040fe20007ffe0ffULL,
0x000000010b0d7824ULL, 0x040fe200078e0249ULL, 0x0000000c0b137810ULL, 0x040fe20007ffe0ffULL,
0x000000080b387824ULL, 0x040fe400078e00ffULL, 0x000000010b0e7824ULL, 0x100fe400078e022aULL,
0x000000080f3a7824ULL, 0x040fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe200078ee20dULL,
0x000000010f107824ULL, 0x000fe200078e022aULL, 0x000000080b0d7810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0b7824ULL, 0x000fc400078e0249ULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee20bULL, 0x000000010d117824ULL, 0x000fe200078e0249ULL,
0x00006400090b7a11ULL, 0x000fe200078038ffULL, 0x000000080d3c7824ULL, 0x040fe200078e00ffULL,
0x0000004f0e0e7212ULL, 0x000fe200078efcffULL, 0x000000010d127824ULL, 0x100fe200078e022aULL,
0x0000650009097a11ULL, 0x000fe200000f3cffULL, 0x00000001132a7824ULL, 0x040fe200078e022aULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee211ULL, 0x00000001130d7824ULL, 0x000fe200078e0249ULL,
0x0000000e0b0e7210ULL, 0x000fe20007f1e0ffULL, 0x00000008133e7824ULL, 0x000fc400078e00ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000004f10107212ULL, 0x000fc600078efcffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000004f12127212ULL, 0x000fc600078efcffULL,
0x000000010f0f7824ULL, 0x000fe200000e0609ULL, 0x0000004f2a2a7212ULL, 0x000fe200078efcffULL,
0x000000103a0d7824ULL, 0x100fe200078e025dULL, 0x000000100b107210ULL, 0x040fe20007f1e0ffULL,
0x000000103c397824ULL, 0x100fe200078e025dULL, 0x000000120b127210ULL, 0x040fe40007f5e0ffULL,
0x0000002a0b2a7210ULL, 0x000fe20007f7e0ffULL, 0x00000010380b7824ULL, 0x000fe400078e025dULL,
0x0000000111117824ULL, 0x000fc400000e0609ULL, 0x0000000113137824ULL, 0x000fe200010e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0b7faeULL, 0x0003e2000b901c46ULL,
0x000000103e5d7824ULL, 0x000fe400078e025dULL, 0x000000012b2b7824ULL, 0x000fe200018e0609ULL,
0x00000000100d7faeULL, 0x0003e8000b901c46ULL, 0x0000000012397faeULL, 0x0003e8000b901c46ULL,
0x000000002a5d7faeULL, 0x0003e4000b901c46ULL, 0x0000000463097810ULL, 0x000fe20007ffe0ffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0xffffffffff107424ULL, 0x002fc400078e00ffULL,
0x000000030900720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000175107824ULL, 0x000fe400078e0209ULL, 0x00000004ff117424ULL, 0x000fc800078e00ffULL,
0x0000660010107625ULL, 0x000fcc00078e0011ULL, 0x0000000610107981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008000b7824ULL, 0x000fca00078e00ffULL,
0xfffffff00b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000000b0473c2ULL, 0x000ea200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000f6a804047890ULL, 0x004fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8000b0e7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6680008127f8cULL, 0x0002a2000c80043fULL,
0x000000ffff0e7224ULL, 0x008fc600078e000fULL, 0x00000000002a7805ULL, 0x000fc80000015200ULL,
0x00f66c00080b7984ULL, 0x004ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x000000382a387210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e2bULL, 0x003d09003800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011439ULL,
0x000000380b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff387224ULL, 0x000fca00000e0639ULL,
0x000000020b0b7819ULL, 0x000fc80000001238ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c00080b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000180770b7811ULL, 0x000fc800078e38ffULL, 0x0000000b640b7210ULL, 0x000fca0007ffe04fULL,
0x00f000000b117984ULL, 0x002e680000000800ULL, 0x00f200000b2b7984ULL, 0x0004e20000000800ULL,
0x0000000a1100720bULL, 0x002fe20003f1d000ULL, 0x0000ae827f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0d2a7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x000fd200078e000aULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x00000003770b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000a1100720bULL, 0x000fe40003f54000ULL,
0x000000000b00720cULL, 0x000fe20003f05270ULL, 0x0000ae227f007947ULL, 0x000fd4000b800000ULL,
0x00000000000b7806ULL, 0x000fc400010e0100ULL, 0x00000080004f8824ULL, 0x000fe200078e024fULL,
0x0000000a110f7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x000099100b0d7816ULL, 0x000fe200000000ffULL, 0x0000000164648824ULL, 0x000fca00078e024fULL,
0x00f4000f64008388ULL, 0x0003e20000000800ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000a0f0a7221ULL, 0x002fe20000010100ULL,
0x000000ff0bff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL, 0x0000000a00397308ULL, 0x000e640000000800ULL,
0x000000390c0c7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011649ULL, 0x0000ad527f007947ULL, 0x000fea000b800000ULL,
0x00001f0d390d7589ULL, 0x0002a400000e0000ULL, 0x0000000d24247220ULL, 0x084fe20000410000ULL,
0x0000000d25257220ULL, 0x080fe20000410000ULL, 0x0000000d2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000d2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000d14147220ULL, 0x080fe20000410000ULL,
0x0000000d15157220ULL, 0x080fe20000410000ULL, 0x0000000d20207220ULL, 0x080fe20000410000ULL,
0x0000000d21217220ULL, 0x080fe20000410000ULL, 0x0000000d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000d1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000d18187220ULL, 0x080fe20000410000ULL,
0x0000000d19197220ULL, 0x080fe20000410000ULL, 0x0000000d30307220ULL, 0x080fe20000410000ULL,
0x0000000d31317220ULL, 0x080fe20000410000ULL, 0x0000000d34347220ULL, 0x080fe20000410000ULL,
0x0000000d35357220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000bff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008490d7811ULL, 0x000fe200078ff0ffULL, 0x0000ac327f007947ULL, 0x000fea000b800000ULL,
0x00001f0d390d7589ULL, 0x00046400000e0000ULL, 0x0000000d26267220ULL, 0x086fe20000410000ULL,
0x0000000d27277220ULL, 0x080fe20000410000ULL, 0x0000000d2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000d16167220ULL, 0x080fe20000410000ULL,
0x0000000d17177220ULL, 0x080fe20000410000ULL, 0x0000000d22227220ULL, 0x080fe20000410000ULL,
0x0000000d23237220ULL, 0x080fe20000410000ULL, 0x0000000d1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000d1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000d1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000d32327220ULL, 0x080fe20000410000ULL,
0x0000000d33337220ULL, 0x080fe20000410000ULL, 0x0000000d36367220ULL, 0x080fe20000410000ULL,
0x0000000d37377220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff2aff7812ULL, 0x000fe2000780600bULL, 0x00000001ff0d7424ULL, 0x000fd800078e00ffULL,
0x000000110f110221ULL, 0x000fe20000010100ULL, 0x00007610ff0d0816ULL, 0x000fc6000000000dULL,
0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL, 0x0000001100060308ULL, 0x000e640000000800ULL,
0x000000062b2b0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000c2b0c7221ULL, 0x008fc20000010000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000800117824ULL, 0x000fca00078e00ffULL, 0xfffffff0112a7812ULL, 0x000fca00078ec0ffULL,
0x00f6b4002a117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804829ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120a127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e0bULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff117819ULL, 0x000fc80000011413ULL,
0x0000001211117211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x0000000211117819ULL, 0x000fc80000001212ULL, 0x000000110000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012b2b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b4002a117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100d0a7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000006ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff0b7819ULL, 0x000fe40000011649ULL,
0x00005410040a7816ULL, 0x000fe20000000004ULL, 0x0000a7f27f007947ULL, 0x000fea000b800000ULL,
0x00001f0b0a057589ULL, 0x0002a400000e0000ULL, 0x000000080b0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000a8227f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0a047589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100b0d7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e000aULL, 0x0000d2b000137802ULL, 0x000fc40000000f00ULL,
0x0000acc000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180b0d7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e000aULL,
0x0000d30000137802ULL, 0x000fc40000000f00ULL, 0x0000ac7000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000800776a7824ULL, 0x040fe200078e0262ULL, 0x0000000377607810ULL, 0x000fc40007ffe0ffULL,
0x000000005228783bULL, 0x000ee20000004200ULL, 0x0000000276767810ULL, 0x000fc60007ffe0ffULL,
0x000000005140783bULL, 0x000ea20000004200ULL, 0x0000010028697824ULL, 0x048fe200078e00ffULL,
0x00000028000b7306ULL, 0x002fe20000009400ULL, 0x00000018ff397819ULL, 0x000fe20000011428ULL,
0x00010000285e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe40000011429ULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000002800447306ULL, 0x000e620000005400ULL, 0x00000018ff5f7819ULL, 0x000fc4000001142bULL,
0x00000018ff3e7819ULL, 0x000fe4000001142aULL, 0x00000018ff4c7819ULL, 0x004fe40000011441ULL,
0x00000018ff457819ULL, 0x000fe20000011440ULL, 0x00000028003a7306ULL, 0x000ea2000000d400ULL,
0x00000018ff0a7819ULL, 0x000fce0000011442ULL, 0x00000029005c7306ULL, 0x000fe20000009400ULL,
0x000000440b00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff0b7819ULL, 0x000fca0000011443ULL,
0x0000002900617306ULL, 0x000e6c0000005400ULL, 0x000000013a3a6812ULL, 0x004fe400078efcffULL,
0x0000006900137306ULL, 0x000ff00000209400ULL, 0x0000006900287306ULL, 0x0004e20000205400ULL,
0x000000615c00720bULL, 0x002fe20003f5d000ULL, 0x00000100295c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000002a00687306ULL, 0x000fe20000009400ULL,
0x0000006900697245ULL, 0x004fce000020d400ULL, 0x0000002a006d7306ULL, 0x000e620000005400ULL,
0x000000281300720bULL, 0x008fe20003f7d000ULL, 0x0001000029287824ULL, 0x000fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000005e00647306ULL, 0x000fec0000209400ULL,
0x0000000169693812ULL, 0x000fe400078efcffULL, 0x0000005e00657306ULL, 0x000ea20000205400ULL,
0x0000006d6800720bULL, 0x002fc40003f9d000ULL, 0x0000003a693a723eULL, 0x000fe200000010ffULL,
0x0001000042697824ULL, 0x000fc800078e00ffULL, 0x0000002b00587306ULL, 0x000fe20000009400ULL,
0x00000018ff697819ULL, 0x000fce0000011469ULL, 0x0000002b003f7306ULL, 0x000e620000005400ULL,
0x000000656400720bULL, 0x004fce0003fbd000ULL, 0x0000003900577306ULL, 0x000ff00000209400ULL,
0x0000003900387306ULL, 0x0004e20000205400ULL, 0x0000003f5800720bULL, 0x002fce0003f7d000ULL,
0x0000005c00617306ULL, 0x000fe20000209400ULL, 0x0000003900397245ULL, 0x004fce000020d400ULL,
0x0000005c00687306ULL, 0x0002a20000205400ULL, 0x000000385700720bULL, 0x008fe40003fdd000ULL,
0x0000005e00387245ULL, 0x000fc8000020d400ULL, 0x0000000138385812ULL, 0x000fe200078efcffULL,
0x0000002800647306ULL, 0x000fe20000209400ULL, 0x0000005c005c7245ULL, 0x002fca000020d400ULL,
0x0000000139396812ULL, 0x000fe400078efcffULL, 0x00000028003f7306ULL, 0x000e620000205400ULL,
0x000000686100720bULL, 0x004fe20003fbd000ULL, 0x000001002b687824ULL, 0x000fe200078e00ffULL,
0x000000383938723eULL, 0x000fe200000010ffULL, 0x000100002a617824ULL, 0x000fc600078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x00000029003b7306ULL, 0x0004e2000000d400ULL,
0x00000018ff617819ULL, 0x000fca0000011461ULL, 0x000000015c5c5812ULL, 0x000fe400078efcffULL,
0x0000005d006b7306ULL, 0x000fe20000209400ULL, 0x000001002a297824ULL, 0x004fe200078e00ffULL,
0x0000003f6400720bULL, 0x002fc80003fdd000ULL, 0x00000018ff577819ULL, 0x000fe40000011429ULL,
0x0000005d00547306ULL, 0x0002a20000205400ULL, 0x000000013b3b2812ULL, 0x008fc800078efcffULL,
0x0000003b5c3b723eULL, 0x000fc600000010ffULL, 0x0000004000627306ULL, 0x000fe20000009400ULL,
0x0000005d005d7245ULL, 0x002fce000020d400ULL, 0x0000004000637306ULL, 0x000e620000005400ULL,
0x000000546b00720bULL, 0x004fe20003fbd000ULL, 0x00010000406b7824ULL, 0x000fe200078e00ffULL,
0x0000002800547245ULL, 0x000fc8000020d400ULL, 0x0000000154546812ULL, 0x000fe200078efcffULL,
0x0000005700297306ULL, 0x000fe20000209400ULL, 0x00000018ff6b7819ULL, 0x000fca000001146bULL,
0x000000015d5d5812ULL, 0x000fe400078efcffULL, 0x00000057006c7306ULL, 0x000ea20000205400ULL,
0x000000636200720bULL, 0x002fe40003f5d000ULL, 0x000000545d39723eULL, 0x000fe200000010ffULL,
0x00000100435d7824ULL, 0x000fe200078e00ffULL, 0x0000000849547812ULL, 0x000fc600078ec0ffULL,
0x0000002b003d7306ULL, 0x0002e2000000d400ULL, 0x00000018ff5d7819ULL, 0x000fce000001145dULL,
0x0000002a003c7306ULL, 0x0006e2000000d400ULL, 0x000100002b2b7824ULL, 0x002fe200078e00ffULL,
0x0000006c2900720bULL, 0x004fc80003fdd000ULL, 0x00000018ff637819ULL, 0x000fe4000001142bULL,
0x0000004100557306ULL, 0x000fe20000009400ULL, 0x00a800006a28783bULL, 0x0082a20000000200ULL,
0x000000013d3d3812ULL, 0x000fcc00078efcffULL, 0x0000004100567306ULL, 0x000ee20000005400ULL,
0x000000013c3c4812ULL, 0x000fe200078efcffULL, 0x00010000416a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000006800587306ULL, 0x000ff00000209400ULL,
0x0000006800657306ULL, 0x000e620000205400ULL, 0x000000565500720bULL, 0x008fe20003fbd000ULL,
0x0000010040567824ULL, 0x000fe200078e00ffULL, 0x0000005700557245ULL, 0x000fc8000020d400ULL,
0x0000000155556812ULL, 0x000fe200078efcffULL, 0x0000003e00667306ULL, 0x000fe20000209400ULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x0000003c553c723eULL, 0x000fe200000010ffULL,
0x0000010042557824ULL, 0x000fc800078e00ffULL, 0x0000003e00597306ULL, 0x000ee20000205400ULL,
0x000000655800720bULL, 0x002fe20003fdd000ULL, 0x0000000528288231ULL, 0x084fe200003400ffULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x000000052a2a8231ULL, 0x000fe400003400ffULL,
0x0000000429298231ULL, 0x080fe400003400ffULL, 0x000000042b2b8231ULL, 0x000fe200003400ffULL,
0x00000041004d7306ULL, 0x0003ec000000d400ULL, 0x0000003a2824723cULL, 0x000b620000041824ULL,
0x000000596600720bULL, 0x008fe20003f9d000ULL, 0x0000010041597824ULL, 0x000fe200078e00ffULL,
0x00000040004e7306ULL, 0x0004e2000000d400ULL, 0x0000000400417824ULL, 0x002fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000004413a7812ULL, 0x020fe400078ec0ffULL,
0x0000005f005b7306ULL, 0x000fe20000209400ULL, 0x0000006800407245ULL, 0x004fe2000020d400ULL,
0x0001000043687824ULL, 0x000fe200078e00ffULL, 0x000000023a3a7812ULL, 0x000fe400078efcffULL,
0x0000000140406812ULL, 0x000fe400078efcffULL, 0x0000000754417812ULL, 0x000fe200078ef849ULL,
0x0000005f005a7306ULL, 0x000e620000205400ULL, 0x0000003d403d723eULL, 0x000fc400000010ffULL,
0x0000003a49407211ULL, 0x000fe400078fe0ffULL, 0x000000382838723cULL, 0x040b62000004182cULL,
0x000000014e4e2812ULL, 0x008fe400078efcffULL, 0x0000006300627306ULL, 0x000fe20000209400ULL,
0x000000014d4d5812ULL, 0x000fe400078efcffULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x00000008412d7824ULL, 0x060fe200078e00ffULL, 0x0000003c2814723cULL, 0x000b620000041814ULL,
0x00000001412c7824ULL, 0x040fe200078e0240ULL, 0x0000001041417812ULL, 0x000fe200078efcffULL,
0x0000006300647306ULL, 0x000ea20000205400ULL, 0x0000005a5b00720bULL, 0x002fc40003fdd000ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee22cULL, 0x00000001412f7824ULL, 0x040fe200078e0240ULL,
0x0000003e002c7245ULL, 0x000fe2000020d400ULL, 0x00000008412e7824ULL, 0x000fe400078e00ffULL,
0x00000061003f7306ULL, 0x000fe20000209400ULL, 0x000000012c2c4812ULL, 0x000fe200078efcffULL,
0x000000102d2d7824ULL, 0x000fe200078e0250ULL, 0xfffffff82e2f7812ULL, 0x000fe400078ee22fULL,
0x0000005f002e7245ULL, 0x000fc6000020d400ULL, 0x00000061005e7306ULL, 0x0002e20000205400ULL,
0x000000646200720bULL, 0x004fe20003f9d000ULL, 0x000000102f407824ULL, 0x000fe200078e0250ULL,
0x000000012e2e6812ULL, 0x000fca00078efcffULL, 0x0000005600577306ULL, 0x000fe20000209400ULL,
0x0000006100617245ULL, 0x002fe4000020d400ULL, 0x0000005e3f00720bULL, 0x008fca0003f7d000ULL,
0x0000005600587306ULL, 0x000e620000205400ULL, 0x000000002d3c783bULL, 0x0204ee0000004200ULL,
0x00000059005a7306ULL, 0x000fe20000209400ULL, 0x00000063002d7245ULL, 0x004fe4000020d400ULL,
0x0000000161613812ULL, 0x000fc400078efcffULL, 0x000000012d2d4812ULL, 0x000fe400078efcffULL,
0x000000612c2c723eULL, 0x000fe200000010ffULL, 0x00000059005b7306ULL, 0x000ea20000205400ULL,
0x0000002d2e2d723eULL, 0x000fe400000010ffULL, 0x00000007492e7812ULL, 0x000fe400078ec0ffULL,
0x000000585700720bULL, 0x002fe40003fdd000ULL, 0x000000082e2e7812ULL, 0x000fe200078ef849ULL,
0x0000002c2820723cULL, 0x000b620000041820ULL, 0x0000004c004f7306ULL, 0x000fe60000209400ULL,
0x000000082e417824ULL, 0x000fe200078e00ffULL, 0x0000005b5a00720bULL, 0x004fc80003f5d000ULL,
0x0000004c00537306ULL, 0x000e620000205400ULL, 0xfffffff841417812ULL, 0x000fca00078ee276ULL,
0x00000080602c7824ULL, 0x020fe400078e0241ULL, 0x0000004500517306ULL, 0x000fe60000209400ULL,
0x000090002c2c7811ULL, 0x000fca00078e20ffULL, 0x0000004500527306ULL, 0x000ea20000205400ULL,
0x000000002c2c783bULL, 0x000ee20000000200ULL, 0x000000534f00720bULL, 0x002fe40003f9d000ULL,
0x00000056004f7245ULL, 0x000fe4000020d400ULL, 0x0000005900567245ULL, 0x000fe4000020d400ULL,
0x0000006b006d7306ULL, 0x000fe20000209400ULL, 0x000000014f4f6812ULL, 0x000fe400078efcffULL,
0x0000000156562812ULL, 0x000fc400078efcffULL, 0x0000004e4f4e723eULL, 0x000fe400000010ffULL,
0x0000004d564f723eULL, 0x000fe200000010ffULL, 0x0000006b00657306ULL, 0x000e620000205400ULL,
0x000000525100720bULL, 0x004fe40003f7d000ULL, 0x0000004500457245ULL, 0x000fe4000020d400ULL,
0x0000006a004d7245ULL, 0x000fc6000020d400ULL, 0x0000006a00727306ULL, 0x000fec0000209400ULL,
0x0000000145453812ULL, 0x000fe400078efcffULL, 0x0000006a00667306ULL, 0x000ea20000205400ULL,
0x000000656d00720bULL, 0x002fe20003fdd000ULL, 0x000001003c6d7824ULL, 0x008fca00078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x0000004200477306ULL, 0x000fe20000009400ULL,
0x000000052c2c8231ULL, 0x080fe400003400ffULL, 0x000000052e2e8231ULL, 0x000fe400003400ffULL,
0x000000042d2d8231ULL, 0x080fe400003400ffULL, 0x000000042f2f8231ULL, 0x000fe200003400ffULL,
0x0000004200467306ULL, 0x000e620000005400ULL, 0x000000667200720bULL, 0x004fc40003f1d000ULL,
0x0000004c00727245ULL, 0x000fe4000020d400ULL, 0x0000006b004c7245ULL, 0x000fe2000020d400ULL,
0x0000004e2c24723cULL, 0x000fe20000041824ULL, 0x0000000172724812ULL, 0x000fe200078efcffULL,
0x00000043004a7306ULL, 0x000fe20000009400ULL, 0x000000014c4c6812ULL, 0x000fc800078efcffULL,
0x0000004c454c723eULL, 0x000fe400000010ffULL, 0x000000014d4d0812ULL, 0x000fe200078efcffULL,
0x00000043004b7306ULL, 0x000ea20000005400ULL, 0x000000464700720bULL, 0x002fe40003fdd000ULL,
0x0000004d724d723eULL, 0x000fca00000010ffULL, 0x0000005500547306ULL, 0x000fe40000209400ULL,
0x0000004c2c38723cULL, 0x000fec0000041838ULL, 0x00000055005c7306ULL, 0x000e620000205400ULL,
0x0000004b4a00720bULL, 0x004fe40003f1d000ULL, 0x00000018ff4b7819ULL, 0x000fca000001143cULL,
0x0000005d005e7306ULL, 0x000ff00000209400ULL, 0x0000005d00627306ULL, 0x000ea20000205400ULL,
0x0000005c5400720bULL, 0x002fe40003f7d000ULL, 0x00000018ff547819ULL, 0x000fca000001143dULL,
0x0000000a00677306ULL, 0x000ff00000209400ULL, 0x0000000a00127306ULL, 0x000e620000205400ULL,
0x000000625e00720bULL, 0x004fe40003fbd000ULL, 0x0000005d00627245ULL, 0x000fc4000020d400ULL,
0x00000018ff5e7819ULL, 0x000fe4000001143eULL, 0x00000018ff5d7819ULL, 0x000fe2000001143fULL,
0x00000042000d7306ULL, 0x000eac000000d400ULL, 0x0000000162625812ULL, 0x000fe400078efcffULL,
0x0000004300117306ULL, 0x0006a2000000d400ULL, 0x000000126700720bULL, 0x002fc40003f5d000ULL,
0x0000005500127245ULL, 0x000fe4000020d400ULL, 0x0000000a00677245ULL, 0x000fe4000020d400ULL,
0x0000000112123812ULL, 0x000fe200078efcffULL, 0x0000000b00447306ULL, 0x000fe20000209400ULL,
0x000000004040783bULL, 0x008e620000004200ULL, 0x000000010d0d6812ULL, 0x004fe400078efcffULL,
0x00000069000a7245ULL, 0x000fe4000020d400ULL, 0x0000000d1212723eULL, 0x000fc400000010ffULL,
0x0000000b00137306ULL, 0x000ea20000205400ULL, 0x0000000111110812ULL, 0x000fe400078efcffULL,
0x0000000167672812ULL, 0x000fca00078efcffULL, 0x00000069006e7306ULL, 0x000ff00000209400ULL,
0x00000069006c7306ULL, 0x000ee20000205400ULL, 0x000000134400720bULL, 0x004fe40003f9d000ULL,
0x000000116213723eULL, 0x000fca00000010ffULL, 0x0000006800707306ULL, 0x000fe40000209400ULL,
0x000000122c14723cULL, 0x000bec0000041814ULL, 0x00000068006f7306ULL, 0x000ea20000205400ULL,
0x0000006c6e00720bULL, 0x008fe40003fdd000ULL, 0x0000000b00127245ULL, 0x020fc4000020d400ULL,
0x00000068000b7245ULL, 0x000fe4000020d400ULL, 0x0000000112124812ULL, 0x000fe200078efcffULL,
0x0000003c005f7306ULL, 0x000fe20000009400ULL, 0x00000018ff137819ULL, 0x002fca0000011440ULL,
0x000000010a0a6812ULL, 0x000fe400078efcffULL, 0x0000006f7000720bULL, 0x004fe20003f1d000ULL,
0x0000003c00507306ULL, 0x000e620000005400ULL, 0x0000000a670a723eULL, 0x000fce00000010ffULL,
0x0000003d00607306ULL, 0x000fe80000009400ULL, 0x000000010b0b0812ULL, 0x000fc800078efcffULL,
0x0000003d00617306ULL, 0x000ea20000005400ULL, 0x0000000b120b723eULL, 0x000fe400000010ffULL,
0x000000505f00720bULL, 0x002fe40003fdd000ULL, 0x00000018ff127819ULL, 0x000fc60000011441ULL,
0x0000003f00647306ULL, 0x000fe20000009400ULL, 0x0000000a2c20723cULL, 0x000bee0000041820ULL,
0x0000003f00537306ULL, 0x000e620000005400ULL, 0x000000616000720bULL, 0x004fe20003f5d000ULL,
0x000001003d607824ULL, 0x000fe200078e00ffULL, 0x00000018ff0a7819ULL, 0x020fc80000011442ULL,
0x00000018ff607819ULL, 0x000fe20000011460ULL, 0x0000006d000b7306ULL, 0x000ff00000209400ULL,
0x0000006d00507306ULL, 0x000ea20000205400ULL, 0x000000536400720bULL, 0x002fc40003fbd000ULL,
0x0000006000537245ULL, 0x000fca000020d400ULL, 0x0000003e00527306ULL, 0x000ff00000009400ULL,
0x0000003e00587306ULL, 0x000e620000005400ULL, 0x000000500b00720bULL, 0x004fe40003f9d000ULL,
0x00000018ff0b7819ULL, 0x000fca0000011443ULL, 0x00000040005b7306ULL, 0x000ff00000009400ULL,
0x0000004000597306ULL, 0x000ea20000005400ULL, 0x000000585200720bULL, 0x002fe20003f1d000ULL,
0x000100003c587824ULL, 0x000fe200078e00ffULL, 0x0000006d00527245ULL, 0x000fc8000020d400ULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000006000617306ULL, 0x000fe20000209400ULL,
0x0000000152524812ULL, 0x000fce00078efcffULL, 0x0000006000647306ULL, 0x0002e20000205400ULL,
0x000000595b00720bULL, 0x004fe20003f7d000ULL, 0x000001003e5b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x0000003c00637306ULL, 0x000ea2000000d400ULL,
0x000001003f607824ULL, 0x002fca00078e00ffULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x0000003d00517306ULL, 0x000e62000000d400ULL, 0x000000646100720bULL, 0x008fe20003f9d000ULL,
0x000100003d647824ULL, 0x000fca00078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x0000004b004c7306ULL, 0x000fe20000209400ULL, 0x0000000163636812ULL, 0x004fc800078efcffULL,
0x000000635252723eULL, 0x000fe400000010ffULL, 0x0000000153534812ULL, 0x000fe200078efcffULL,
0x0000004b004d7306ULL, 0x000ea20000205400ULL, 0x0000000151512812ULL, 0x002fc800078efcffULL,
0x000000515353723eULL, 0x000fc600000010ffULL, 0x00000054005c7306ULL, 0x000fe80000209400ULL,
0x00000052281c723cULL, 0x000b68000004181cULL, 0x0000005400447306ULL, 0x0002e20000205400ULL,
0x0000004d4c00720bULL, 0x004fce0003fdd000ULL, 0x0000005800597306ULL, 0x000fe20000209400ULL,
0x0000005400547245ULL, 0x002fce000020d400ULL, 0x00000058006e7306ULL, 0x0002a20000205400ULL,
0x000000445c00720bULL, 0x008fce0003f5d000ULL, 0x0000005b004d7306ULL, 0x000fe20000209400ULL,
0x0000005800587245ULL, 0x002fca000020d400ULL, 0x0000000154542812ULL, 0x000fe400078efcffULL,
0x0000005b00447306ULL, 0x000fe20000205400ULL, 0x0000006e5900720bULL, 0x004fe20003f9d000ULL,
0x000100003e597824ULL, 0x000fca00078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x00000042004f7306ULL, 0x000fec0000009400ULL, 0x0000000158584812ULL, 0x000fe400078efcffULL,
0x00000042006a7306ULL, 0x000e700000005400ULL, 0x0000003e00577306ULL, 0x0004f0000000d400ULL,
0x00000064003d7306ULL, 0x000fe20000209400ULL, 0x0000004b003e7245ULL, 0x004fe2000020d400ULL,
0x000100003f4b7824ULL, 0x000fe200078e00ffULL, 0x0000006a4f00720bULL, 0x002fc40003f5d000ULL,
0x000000013e3e6812ULL, 0x000fe400078efcffULL, 0x000000444d00720bULL, 0x000fe20003fdd000ULL,
0x00000064004c7306ULL, 0x000e620000205400ULL, 0x0000005b004f7245ULL, 0x000fe2000020d400ULL,
0x00000100404d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x00010000405b7824ULL, 0x000fe200078e00ffULL, 0x0000000157570812ULL, 0x008fe400078efcffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000006000617306ULL, 0x000fe20000209400ULL,
0x00000018ff5b7819ULL, 0x000fc4000001145bULL, 0x000000583e3e723eULL, 0x000fe400000010ffULL,
0x000000014f4f6812ULL, 0x000fc600078efcffULL, 0x00000060006e7306ULL, 0x0004e20000205400ULL,
0x0000004c3d00720bULL, 0x002fce0003f9d000ULL, 0x00000059003d7306ULL, 0x000fe20000209400ULL,
0x0000006000607245ULL, 0x004fce000020d400ULL, 0x00000059004c7306ULL, 0x0002a20000205400ULL,
0x0000006e6100720bULL, 0x008fe20003fdd000ULL, 0x0000010041617824ULL, 0x000fca00078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000005e00557306ULL, 0x000fe20000209400ULL,
0x0000005900597245ULL, 0x002fca000020d400ULL, 0x0000000160606812ULL, 0x000fe400078efcffULL,
0x0000005e000d7306ULL, 0x0002e20000205400ULL, 0x0000004c3d00720bULL, 0x004fe20003fdd000ULL,
0x00010000414c7824ULL, 0x000fe400078e00ffULL, 0x00000100423d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000004100657306ULL, 0x000fe20000009400ULL,
0x0000005e005e7245ULL, 0x002fe4000020d400ULL, 0x00000018ff3d7819ULL, 0x000fc6000001143dULL,
0x0000000159596812ULL, 0x000fe400078efcffULL, 0x0000004100667306ULL, 0x000fe20000005400ULL,
0x0000000d5500720bULL, 0x008fce0003f1d000ULL, 0x0000004b00447306ULL, 0x000fec0000209400ULL,
0x000000015e5e0812ULL, 0x000fe400078efcffULL, 0x0000004b006d7306ULL, 0x0002b00000205400ULL,
0x0000003f005a7306ULL, 0x0006a2000000d400ULL, 0x0000004b004b7245ULL, 0x002fce000020d400ULL,
0x0000004d005c7306ULL, 0x000fe20000209400ULL, 0x00000064003f7245ULL, 0x008fe4000020d400ULL,
0x0000006d4400720bULL, 0x004fe40003fdd000ULL, 0x000000013f3f4812ULL, 0x000fe400078efcffULL,
0x000000666500720bULL, 0x000fe20003f9d000ULL, 0x0000004d006f7306ULL, 0x000e620000205400ULL,
0x000000015a5a5812ULL, 0x000fe400078efcffULL, 0x0000003f543f723eULL, 0x000fc400000010ffULL,
0x0000001300547245ULL, 0x000fc6000020d400ULL, 0x0000005d00117306ULL, 0x000fe20000209400ULL,
0x000000014b4b6812ULL, 0x000fe200078efcffULL, 0x0000003e2818723cULL, 0x000f6c0000041818ULL,
0x0000005d00627306ULL, 0x0004e20000205400ULL, 0x0000006f5c00720bULL, 0x002fce0003f1d000ULL,
0x0000006100667306ULL, 0x000fe20000209400ULL, 0x0000005d005d7245ULL, 0x004fce000020d400ULL,
0x00000061000d7306ULL, 0x000e620000205400ULL, 0x000000621100720bULL, 0x008fe20003fbd000ULL,
0x0000010043117824ULL, 0x000fca00078e00ffULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000001300697306ULL, 0x000fec0000209400ULL, 0x000000015d5d5812ULL, 0x000fe400078efcffULL,
0x0000001300687306ULL, 0x000fe20000205400ULL, 0x0000000d6600720bULL, 0x002fe20003fdd000ULL,
0x00010000420d7824ULL, 0x000fe200078e00ffULL, 0x0000004b5d4b723eULL, 0x000fc800000010ffULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x0000004300477306ULL, 0x000ff00000009400ULL,
0x00000043004a7306ULL, 0x000e700000005400ULL, 0x00000041004e7306ULL, 0x000eb0000000d400ULL,
0x0000004c00647306ULL, 0x000fe20000209400ULL, 0x0000004a4700720bULL, 0x002fe20003fbd000ULL,
0x00010000434a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff527819ULL, 0x020fe2000001144aULL,
0x0000004c00657306ULL, 0x000e620000205400ULL, 0x000000014e4e4812ULL, 0x004fe400078efcffULL,
0x000000595e4a723eULL, 0x000fca00000010ffULL, 0x0000004000567306ULL, 0x000ea4000000d400ULL,
0x0000004a2834723cULL, 0x000fec0000041834ULL, 0x0000004200457306ULL, 0x0006a2000000d400ULL,
0x000000656400720bULL, 0x002fce0003f9d000ULL, 0x0000005b00407306ULL, 0x000fe20000209400ULL,
0x0000004d00427245ULL, 0x008fe4000020d400ULL, 0x0000000156563812ULL, 0x004fe400078efcffULL,
0x0000000142420812ULL, 0x000fe400078efcffULL, 0x000000686900720bULL, 0x000fe20003f1d000ULL,
0x0000005b00417306ULL, 0x0003e20000205400ULL, 0x0000000145452812ULL, 0x000fe400078efcffULL,
0x000000564242723eULL, 0x000fca00000010ffULL, 0x00000012006b7306ULL, 0x000fe20000209400ULL,
0x0000005b005b7245ULL, 0x002fc6000020d400ULL, 0x0000000154540812ULL, 0x000fc800078efcffULL,
0x00000012006c7306ULL, 0x0002b00000205400ULL, 0x0000003d00557306ULL, 0x000fe20000209400ULL,
0x0000001200127245ULL, 0x002fce000020d400ULL, 0x0000003d005c7306ULL, 0x000e620000205400ULL,
0x0000006c6b00720bULL, 0x004fce0003f7d000ULL, 0x0000004300467306ULL, 0x0004ec000000d400ULL,
0x0000000112123812ULL, 0x000fe400078efcffULL, 0x0000000b00507306ULL, 0x000fe20000209400ULL,
0x0000006100437245ULL, 0x004fe4000020d400ULL, 0x0000005c5500720bULL, 0x002fc40003f1d000ULL,
0x0000000143436812ULL, 0x000fe400078efcffULL, 0x000000414000720bULL, 0x000fe20003fdd000ULL,
0x0000000b003c7306ULL, 0x000e620000205400ULL, 0x000000574f40723eULL, 0x000fe400000010ffULL,
0x0000004c00557245ULL, 0x000fe4000020d400ULL, 0x0000005a6041723eULL, 0x000fe400000010ffULL,
0x0000000155554812ULL, 0x000fe200078efcffULL, 0x0000000a00677306ULL, 0x000fe20000209400ULL,
0x0000000146465812ULL, 0x008fc400078efcffULL, 0x000000551255723eULL, 0x000fe200000010ffULL,
0x000000402830723cULL, 0x000f620000041830ULL, 0x000000015b5b6812ULL, 0x000fe400078efcffULL,
0x0000000b00127245ULL, 0x000fe2000020d400ULL, 0x0000000a005f7306ULL, 0x0004e20000205400ULL,
0x0000003c5000720bULL, 0x002fe40003f9d000ULL, 0x0000003d003c7245ULL, 0x000fe4000020d400ULL,
0x00000011003d7245ULL, 0x000fc4000020d400ULL, 0x000000013c3c0812ULL, 0x000fe200078efcffULL,
0x0000001100447306ULL, 0x000fe20000209400ULL, 0x0000000a000a7245ULL, 0x004fe4000020d400ULL,
0x00000052000b7245ULL, 0x000fe4000020d400ULL, 0x0000004e4343723eULL, 0x000fe400000010ffULL,
0x0000000112124812ULL, 0x000fe200078efcffULL, 0x00000011004d7306ULL, 0x000e620000205400ULL,
0x0000005f6700720bULL, 0x008fc40003fdd000ULL, 0x0000005b5454723eULL, 0x000fe200000010ffULL,
0x000000422c1c723cULL, 0x000b62000004181cULL, 0x000000453c3c723eULL, 0x000fc600000010ffULL,
0x0000000d00477306ULL, 0x000fe80000209400ULL, 0x000000542c18723cULL, 0x000b640000041818ULL,
0x000000010a0a6812ULL, 0x000fe400078efcffULL, 0x0000000d00517306ULL, 0x0004e20000205400ULL,
0x0000004d4400720bULL, 0x002fce0003f7d000ULL, 0x00000052004f7306ULL, 0x000fe20000209400ULL,
0x0000000d000d7245ULL, 0x004fca000020d400ULL, 0x000000013d3d3812ULL, 0x000fe400078efcffULL,
0x00000052003e7306ULL, 0x000e620000205400ULL, 0x000000514700720bULL, 0x008fe40003f1d000ULL,
0x000000463d3d723eULL, 0x000fce00000010ffULL, 0x0000003c2c30723cULL, 0x020b680000041830ULL,
0x000000010d0d0812ULL, 0x000fe400078efcffULL, 0x0000003e4f00720bULL, 0x002fe40003f5d000ULL,
0x0000000d0a0a723eULL, 0x000fd600000010ffULL, 0x000000010b0b2812ULL, 0x000fc800078efcffULL,
0x0000000b120b723eULL, 0x000fce00000010ffULL, 0x0000000a2c34723cULL, 0x000b620000041834ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x00000000070a7f8cULL, 0x0202a2000c80043fULL,
0x0000000148487810ULL, 0x000fe40007ffe0ffULL, 0x0000f6a077117811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000011ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff0d7224ULL, 0x004fe200078e000bULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff26f000007947ULL, 0x000fea000383ffffULL, 0x000000ff7100720cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x018000000c027810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000f32000057802ULL, 0x002fc40000000f00ULL, 0x00008a8000007944ULL, 0x01cfea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000c00037308ULL, 0x000e640000001000ULL,
0xbf80000003027423ULL, 0x002fc8000000000cULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000203047223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006f00ff037624ULL, 0x000fe400078e00ffULL, 0x00006e00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000057919ULL, 0x000e680000000000ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011605ULL,
0x0000000808057811ULL, 0x004fe200078ff0ffULL, 0x0000000403067220ULL, 0x008fca0000410000ULL,
0x00001f0706047589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea200000e0000ULL,
0x0000002404247220ULL, 0x042fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000003804387220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000001404147220ULL, 0x040fe20000410000ULL, 0x0000001504157220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x000fe20000410000ULL,
0x0000002605267220ULL, 0x044fe20000410000ULL, 0x0000002705277220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000001605167220ULL, 0x040fe20000410000ULL, 0x0000001705177220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x000fc20000410000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x0000100000067824ULL, 0x000fe200078e00ffULL,
0x000000181918723eULL, 0x000fc400000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000303130723eULL, 0x000fe400000010ffULL, 0x000000343534723eULL, 0x000fe400000010ffULL,
0x000000161716723eULL, 0x000fc400000010ffULL, 0x0000001e1f1e723eULL, 0x000fe400000010ffULL,
0x000000323332723eULL, 0x000fe400000010ffULL, 0x000000363719723eULL, 0x000fe400000010ffULL,
0x00000002ff077819ULL, 0x002fe40000011603ULL, 0x0000000203027812ULL, 0x040fe400078ec0ffULL,
0x0000000803097811ULL, 0x000fe200078ff0ffULL, 0x00000008070a7824ULL, 0x048fe200078e00ffULL,
0x0000000702047211ULL, 0x040fe200078ff8ffULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0x0000000902057211ULL, 0x000fe200078ff8ffULL, 0x0000000809087824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x000fe20007ffe0ffULL, 0x0000000807097824ULL, 0x000fc600078e00ffULL,
0xfffffff8080f7812ULL, 0x004fe200078ee205ULL, 0x0000000807057824ULL, 0x000fe200078e00ffULL,
0xfffffff809097812ULL, 0x000fe400078ee202ULL, 0x0000100006027812ULL, 0x000fe200078ee2ffULL,
0x0000000803067824ULL, 0x000fe200078e00ffULL, 0x0000000404077810ULL, 0x040fe40007ffe0ffULL,
0x0000000604087810ULL, 0x000fe40007ffe0ffULL, 0xfffffff805057812ULL, 0x000fe200078ee204ULL,
0x0000080073047824ULL, 0x000fe200078e0202ULL, 0xfffffff80a0b7812ULL, 0x000fc400078ee207ULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee208ULL, 0x000000100f107824ULL, 0x110fe200078e0204ULL,
0x0000000806077812ULL, 0x000fe200078ec0ffULL, 0x0000001005067824ULL, 0x100fe200078e0204ULL,
0x000000383905723eULL, 0x000fe200000010ffULL, 0x00000010090a7824ULL, 0x100fe200078e0204ULL,
0x0000001a1b0f723eULL, 0x000fe200000010ffULL, 0x000000100b0c7824ULL, 0x100fe200078e0204ULL,
0x00000022230b723eULL, 0x000fe200000010ffULL, 0x000000100d0e7824ULL, 0x000fe200078e0204ULL,
0x000000242504723eULL, 0x000fe200000010ffULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x0000001c1d06723eULL, 0x000fe200000010ffULL, 0x00000001070a7824ULL, 0x040fe200078e020aULL,
0x0000541004127816ULL, 0x140fe20000000005ULL, 0x0000000107107824ULL, 0x040fe200078e0210ULL,
0x0000763204137816ULL, 0x000fe20000000005ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000141504723eULL, 0x000fe200000010ffULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x000000202105723eULL, 0x000fe200000010ffULL, 0x0000001208007388ULL, 0x0003e20000000a00ULL,
0x0000763230077816ULL, 0x000fc40000000034ULL, 0x0000763204097816ULL, 0x000fe40000000005ULL,
0x000054101e147816ULL, 0x140fe4000000000fULL, 0x000076321e157816ULL, 0x000fe4000000000fULL,
0x00007632320d7816ULL, 0x000fe40000000019ULL, 0x0000541004087816ULL, 0x002fe40000000005ULL,
0x000000262704723eULL, 0x000fc400000010ffULL, 0x0000003a3b05723eULL, 0x000fe200000010ffULL,
0x000000080a007388ULL, 0x0003e40000000a00ULL, 0x0000541006087816ULL, 0x142fe40000000018ULL,
0x0000763206097816ULL, 0x000fe40000000018ULL, 0x0000541030067816ULL, 0x000fc60000000034ULL,
0x000000080c007388ULL, 0x0003e80000000a00ULL, 0x000000060e007388ULL, 0x0005e20000000a00ULL,
0x0000541016087816ULL, 0x142fe4000000000bULL, 0x0000763216097816ULL, 0x000fe4000000000bULL,
0x0000541004067816ULL, 0x144fe40000000005ULL, 0x0000763204077816ULL, 0x000fe20000000005ULL,
0x000000017c057824ULL, 0x000fe200078e0203ULL, 0x000000ff00047306ULL, 0x000fe60000205400ULL,
0x0000000610007388ULL, 0x0003e80000000a00ULL, 0x000400080a007388ULL, 0x000fe80000000a00ULL,
0x000400140c007388ULL, 0x0005e20000000a00ULL, 0x0000001005067824ULL, 0x002fc400078e0202ULL,
0x000000ff00057306ULL, 0x000e620000209400ULL, 0x00005410320c7816ULL, 0x004fca0000000019ULL,
0x0004000c0e007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000006087984ULL, 0x000ea20000000c00ULL, 0x000000040500720bULL, 0x002fc40003f1d000ULL,
0x000000ff00047245ULL, 0x000fe2000020d400ULL, 0x0004000006147984ULL, 0x000e680000000c00ULL,
0x0008000006107984ULL, 0x000ee80000000c00ULL, 0x000c000006187984ULL, 0x000ee40000000c00ULL,
0x0000000104040812ULL, 0x000fc400078efcffULL, 0x000000ff7300720cULL, 0x000fe40003f05270ULL,
0x000000040404723eULL, 0x000fca00000010ffULL, 0x3f803f80040b7831ULL, 0x044fe4000020000bULL,
0x3f803f80040a7831ULL, 0x040fe4000020000aULL, 0x3f803f8004097831ULL, 0x040fe40000200009ULL,
0x3f803f8004087831ULL, 0x040fe40000200008ULL, 0x3f803f8004177831ULL, 0x042fe40000200017ULL,
0x3f803f8004167831ULL, 0x000fc40000200016ULL, 0x3f803f8004157831ULL, 0x040fe40000200015ULL,
0x3f803f8004147831ULL, 0x000fe40000200014ULL, 0x3f803f800b0b7831ULL, 0x008fe40000200013ULL,
0x3f803f800a0a7831ULL, 0x000fe40000200012ULL, 0x3f803f8009097831ULL, 0x000fe40000200011ULL,
0x3f803f8008087831ULL, 0x000fc40000200010ULL, 0x3f803f8017177831ULL, 0x000fe4000020001bULL,
0x3f803f8016167831ULL, 0x000fe2000020001aULL, 0x0000000806007388ULL, 0x000fe20000000c00ULL,
0x3f803f8015157831ULL, 0x000fe40000200019ULL, 0x3f803f8014147831ULL, 0x000fca0000200018ULL,
0x0004001406007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff087819ULL, 0x000fc80000011603ULL,
0x000000790800720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000067b06ULL, 0x000e620000209000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00005a00ff107a12ULL, 0x000fe400078e33ffULL, 0x00000001000f7812ULL, 0x000fe400078ec0ffULL,
0x0000002003007810ULL, 0x040fe40007ffe0ffULL, 0x00000007030e7812ULL, 0x000fe200078ec0ffULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe06097810ULL, 0x002fcc0007ffe0ffULL,
0x0000000900057305ULL, 0x000e64000021f000ULL, 0x000000ffff077224ULL, 0x002fc800078e0a05ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x0000000705117227ULL, 0x000fc800078e0004ULL,
0x000000017b047824ULL, 0x000fc800078e0208ULL, 0x0000000411077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x00005a0005067a24ULL, 0x000fe400078e0204ULL,
0x0000000108057824ULL, 0x000fc600078e0203ULL, 0x00005a0006007a0cULL, 0x000fda0003f06070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x0000000705067812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef803ULL,
0x0000001005067824ULL, 0x000fe400078e0202ULL, 0x0000000107071810ULL, 0x000fc60007ffe0ffULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000710077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007057a24ULL, 0x000fe200078e0278ULL,
0x00000003ff067819ULL, 0x002fe20000011600ULL, 0x00005a000d047a24ULL, 0x000fe400078e0204ULL,
0x000000080f077824ULL, 0x000fe400078e020eULL, 0x00005a0005057a24ULL, 0x000fca00078e0204ULL,
0x000000057a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x000000790600720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000017b047824ULL, 0x102fe200078e0206ULL, 0x00000040030c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100067824ULL, 0x000fe400078e0206ULL, 0x0000000411077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x00005a0005057a24ULL, 0x000fca00078e0204ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0000000706057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001005067824ULL, 0x000fe400078e0202ULL,
0x0000000107072810ULL, 0x000fc60007ffe0ffULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000710077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007057a24ULL, 0x000fe200078e0278ULL, 0x00000003ff067819ULL, 0x002fe2000001160cULL,
0x00005a000d047a24ULL, 0x000fe400078e0204ULL, 0x000000080f077824ULL, 0x000fe400078e0200ULL,
0x00005a0005057a24ULL, 0x000fca00078e0204ULL, 0x000000057a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440eULL, 0x000000790600720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000017b007824ULL, 0x100fe400078e0206ULL,
0x000000010c067824ULL, 0x000fe400078e0206ULL, 0x0000000011047227ULL, 0x002fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x00005a0005057a24ULL, 0x000fca00078e0200ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0000000706057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001005067824ULL, 0x000fe400078e0202ULL,
0x0000000104042810ULL, 0x000fc60007ffe0ffULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000410057207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x0000590005057a24ULL, 0x000fe400078e0278ULL, 0x00005a0007007a24ULL, 0x000fc800078e0200ULL,
0x00005a0005057a24ULL, 0x000fe200078e0200ULL, 0x0000006003007810ULL, 0x000fe20007ffe0ffULL,
0x000000080f037824ULL, 0x000fc600078e020cULL, 0x000000057a057210ULL, 0x000fe40007f3e0ffULL,
0x00000003ff067819ULL, 0x002fc60000011600ULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fe200078240ffULL, 0x000000017b7b7824ULL, 0x000fc600078e0206ULL,
0x00005f0005057a11ULL, 0x000fe400008f440eULL, 0x000000790600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000007b11057227ULL, 0x002fc800078e00ffULL,
0x000000ffff047224ULL, 0x000fe400078e0a05ULL, 0x0000000100067824ULL, 0x000fe400078e0206ULL,
0x00005a0004037a24ULL, 0x000fca00078e027bULL, 0x00005a0003007a0cULL, 0x000fda0003f26070ULL,
0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f46070ULL, 0x0000000706037812ULL, 0x000fc800078ec0ffULL,
0xfffffff803037812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001003047824ULL, 0x000fe400078e0202ULL, 0x0000000105052810ULL, 0x000fc60007ffe0ffULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000510057207ULL, 0x000fca0004000000ULL,
0x000000ffff027224ULL, 0x000fe400078e0a05ULL, 0x0000590005787a24ULL, 0x000fe400078e0278ULL,
0x00005a00027b7a24ULL, 0x000fe400078e027bULL, 0x000000080f057824ULL, 0x000fe400078e0200ULL,
0x00005a00787b7a24ULL, 0x000fca00078e027bULL, 0x0000007b7a7b7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005e007b027a11ULL, 0x000fc800078040ffULL,
0x00005f007b037a11ULL, 0x000fca00000f4406ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000030000720cULL, 0x000fe20003f06070ULL, 0xffffffffff047424ULL, 0x000fd800078e00ffULL,
0x00000002070d8824ULL, 0x000fc800078e00ffULL, 0x00006a000d0d8a24ULL, 0x000fc800078e0200ULL,
0x000066000d0c8625ULL, 0x000fe200078e0042ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006e00ff0e7624ULL, 0x000fe200078e00ffULL, 0x000000060c048981ULL, 0x000ea2000c1e1900ULL,
0x00006f00ff0f7624ULL, 0x000fc600078e00ffULL, 0x00f60000ff0a7f8cULL, 0x000e68000c80043fULL,
0x000000060e097981ULL, 0x000722000c1e9900ULL, 0x000001ff1000780cULL, 0x000fe20003f04070ULL,
0x00005800ff757624ULL, 0x000fe400078e00ffULL, 0x0000004076767824ULL, 0x000fe400078e00ffULL,
0x00000040007a7824ULL, 0x000fe200078e00ffULL, 0x0000001f75757810ULL, 0x000fe20007ffe0ffULL,
0x0000004078057824ULL, 0x000fc600078e00ffULL, 0x00000005ff757819ULL, 0x000fe20000011675ULL,
0x0000007604277224ULL, 0x004fe400078e02ffULL, 0x0000062000000947ULL, 0x000fea0003800000ULL,
0x00000002ff217819ULL, 0x00afe40000011649ULL, 0x0000640027257a11ULL, 0x000fe400078038ffULL,
0x0000000821137810ULL, 0x000fe20007ffe0ffULL, 0x0000004078787824ULL, 0x000fe200078e0221ULL,
0x0000650027277a11ULL, 0x000fe400000f3cffULL, 0x0000004949127211ULL, 0x000fe200078fe8ffULL,
0x00000080780c7825ULL, 0x040fe200078e00ffULL, 0x00000008780e7810ULL, 0x000fc40007ffe0ffULL,
0x0000001078107810ULL, 0x000fe40007ffe0ffULL, 0x000000300c147812ULL, 0x100fe200078ef808ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00000003121a7812ULL, 0x000fe400078ec0ffULL,
0x0000001425147210ULL, 0x000fe20007f1e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000300e167812ULL, 0x000fe400078ef808ULL, 0x00001000001c7811ULL, 0x000fe200078e68ffULL,
0x000000010d157824ULL, 0x000fe200000e0627ULL, 0x0000002516167210ULL, 0x000fc40007f3e0ffULL,
0x0000002878127810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffc1a497812ULL, 0x000fe200078ef849ULL,
0x000000010f177824ULL, 0x000fe200008e0627ULL, 0x0000007a020f7217ULL, 0x000fe40007800000ULL,
0x00000030100c7812ULL, 0x000fe200078ef808ULL, 0x0000001049497824ULL, 0x000fe200078e021cULL,
0x0000002078107810ULL, 0x000fe20007ffe0ffULL, 0x000000010f187824ULL, 0x000fe200078e0a7aULL,
0x000000250c0c7210ULL, 0x000fc40007f5e0ffULL, 0x00000018780e7810ULL, 0x000fe40007ffe0ffULL,
0x000000181300720cULL, 0x0c0fe20003f26070ULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0x000000182100720cULL, 0x000fe20003f06070ULL, 0x00000001110d7824ULL, 0x000fe200010e0627ULL,
0x0000001021237810ULL, 0x000fe20007ffe0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffffc13137812ULL, 0x000fe400078ee21aULL, 0x0000001821297810ULL, 0x000fe20007ffe0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000003010107812ULL, 0x000fc400078ef808ULL,
0x00000020211b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001013197824ULL, 0x000fe200078e021cULL,
0x000000300e0e7812ULL, 0x100fe200078ef808ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014497faeULL, 0x0003e2000c101c46ULL,
0x0000002510107210ULL, 0x080fe40007f7e0ffULL, 0x00000028211d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000016197faeULL, 0x0005e2000c901c46ULL, 0x0000003012127812ULL, 0x000fe200078ef808ULL,
0x0000000111117824ULL, 0x000fe200018e0627ULL, 0x000000250e0e7210ULL, 0x000fe20007f5e0ffULL,
0x000000041d2b7824ULL, 0x000fe200078e00ffULL, 0x00000030211f7810ULL, 0x000fc40007ffe0ffULL,
0x0000003821217810ULL, 0x000fe20007ffe0ffULL, 0x000000010f0f7824ULL, 0x000fe200010e0627ULL,
0x0000003878147810ULL, 0x002fe20007ffe0ffULL, 0x000000041f2d7824ULL, 0x000fe200078e00ffULL,
0x000000182900720cULL, 0x080fe20003f86070ULL, 0x0000000423197824ULL, 0x004fe200078e00ffULL,
0x0000002512167210ULL, 0x000fe20007fde0ffULL, 0x0000000429297824ULL, 0x000fe200078e00ffULL,
0x0000003078127810ULL, 0x000fe20007ffe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000182300720cULL, 0x000fc40003fa6070ULL, 0x000000181b00720cULL, 0x080fe20003f66070ULL,
0x0000000113177824ULL, 0x000fe200030e0627ULL, 0x000000181d00720cULL, 0x080fe20003f46070ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffffc19197812ULL, 0x000fe400078ee21aULL,
0x000000181f00720cULL, 0x000fe20003f26070ULL, 0x000000041b237824ULL, 0x000fe200078e00ffULL,
0x0000003012127812ULL, 0x000fe200078ef808ULL, 0x00000004212f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc291b7812ULL, 0x000fe200078ee21aULL, 0x0000001019197824ULL, 0x000fe200078e021cULL,
0x0000002512127210ULL, 0x000fc40007fde0ffULL, 0x0000003014087812ULL, 0x000fe200078ef808ULL,
0x000000101b1b7824ULL, 0x000fe200078e021cULL, 0x000000182100720cULL, 0x000fe20003f06070ULL,
0x0000000113137824ULL, 0x000fe200030e0627ULL, 0xfffffffc231d7812ULL, 0x100fe200078ee21aULL,
0x000000000c197faeULL, 0x0003e2000e901c46ULL, 0xfffffffc2b1f7812ULL, 0x100fe400078ee21aULL,
0xfffffffc2d217812ULL, 0x000fe200078ee21aULL, 0x000000101d1d7824ULL, 0x000fe200078e021cULL,
0xfffffffc2f237812ULL, 0x000fe200078ee21aULL, 0x000000101f1f7824ULL, 0x100fe200078e021cULL,
0x0000002508147210ULL, 0x000fe20007fde0ffULL, 0x0000001021217824ULL, 0x100fe200078e021cULL,
0x000000000e1b7faeULL, 0x0003e2000e101c46ULL, 0x0000001023237824ULL, 0x000fc400078e021cULL,
0x0000000115157824ULL, 0x000fe200030e0627ULL, 0x00000000101d7faeULL, 0x0003e8000d901c46ULL,
0x00000000161f7faeULL, 0x0003e8000d101c46ULL, 0x0000000012217faeULL, 0x0003e8000c901c46ULL,
0x0000000014237faeULL, 0x0003e2000c101c46ULL, 0x0000056000007947ULL, 0x000fea0003800000ULL,
0x0000000849207811ULL, 0x04afe400078ff0ffULL, 0x00000049490d7211ULL, 0x000fc400078fe8ffULL,
0x0000001049107811ULL, 0x040fe200078ff0ffULL, 0x00000004200f7824ULL, 0x000fe200078e00ffULL,
0x0000001849127811ULL, 0x040fe400078ff0ffULL, 0x0000002049147811ULL, 0x000fe200078ff0ffULL,
0x0000000410117824ULL, 0x000fe200078e00ffULL, 0x000000030d1c7812ULL, 0x000fe200078ec0ffULL,
0x0000000412137824ULL, 0x000fe200078e00ffULL, 0x0000002849167811ULL, 0x040fe200078ff0ffULL,
0x0000000414157824ULL, 0x000fe200078e00ffULL, 0x0000003049187811ULL, 0x000fe200078ff0ffULL,
0x0000000105107824ULL, 0x000fe200078e0210ULL, 0x00000005490c7211ULL, 0x040fe200078ff0ffULL,
0x0000000416177824ULL, 0x000fe200078e00ffULL, 0x00000038491a7811ULL, 0x000fe200078ff0ffULL,
0x0000000418197824ULL, 0x000fe200078e00ffULL, 0x00001000001e7811ULL, 0x000fe200078e68ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffffc0f0e7812ULL, 0x000fc400078ee21cULL,
0xfffffffc110f7812ULL, 0x100fe200078ee21cULL, 0x000000041a1b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc13117812ULL, 0x000fe200078ee21cULL, 0x000000100e1d7824ULL, 0x000fe200078e021eULL,
0xfffffffc15137812ULL, 0x000fe200078ee21cULL, 0x00000001050e7824ULL, 0x000fe200078e0220ULL,
0xfffffffc17157812ULL, 0x000fe200078ee21cULL, 0x0000000105127824ULL, 0x000fe200078e0212ULL,
0x00006400272b7a11ULL, 0x000fe200078038ffULL, 0x000000100f1f7824ULL, 0x000fe200078e021eULL,
0xfffffffc19177812ULL, 0x000fe200078ee21cULL, 0x0000000105147824ULL, 0x000fe200078e0214ULL,
0x000000300c0c7812ULL, 0x000fe200078ef808ULL, 0x0000001011217824ULL, 0x000fe200078e021eULL,
0xfffffffc1b197812ULL, 0x000fe200078ee21cULL, 0x0000000105167824ULL, 0x000fe200078e0216ULL,
0x00006500272d7a11ULL, 0x000fe200000f3cffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000c2b0c7210ULL, 0x000fc40007f1e0ffULL, 0x0ffffffc1c497812ULL, 0x000fe200078ef849ULL,
0x0000001013237824ULL, 0x000fe200078e021eULL, 0x000000300e0e7812ULL, 0x000fe200078ef808ULL,
0x0000000105187824ULL, 0x000fe400078e0218ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000001015257824ULL, 0x000fe200078e021eULL, 0x0000003010107812ULL, 0x000fe200078ef808ULL,
0x00000001051a7824ULL, 0x000fe400078e021aULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000102b107210ULL, 0x000fc60007f3e0ffULL, 0x0000001017277824ULL, 0x000fe200078e021eULL,
0x0000003012127812ULL, 0x000fe200078ef808ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x000000122b127210ULL, 0x000fe20007f5e0ffULL, 0x0000001019297824ULL, 0x000fe200078e021eULL,
0x0000003014147812ULL, 0x000fe200078ef808ULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0x000000142b147210ULL, 0x000fe20007f7e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000003016167812ULL, 0x000fc600078ef808ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000003018187812ULL, 0x000fe400078ef808ULL, 0x000000162b167210ULL, 0x000fe20007f9e0ffULL,
0x000000010d0d7824ULL, 0x100fe200000e062dULL, 0x0000000e2b0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000001049497824ULL, 0x000fe200078e021eULL, 0x000000301a087812ULL, 0x000fe200078ef808ULL,
0x0000000111117824ULL, 0x100fe200008e062dULL, 0x000000182b187210ULL, 0x000fe20007fbe0ffULL,
0x000000010f0f7824ULL, 0x100fe200000e062dULL, 0x000000082b1a7210ULL, 0x000fe20007fde0ffULL,
0x0000000113137824ULL, 0x100fe200010e062dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c497faeULL, 0x0003e2000b901c46ULL, 0x0000000115157824ULL, 0x000fc400018e062dULL,
0x0000000117177824ULL, 0x100fe200020e062dULL, 0x000000000e1d7faeULL, 0x0003e2000b901c46ULL,
0x0000000119197824ULL, 0x100fe400028e062dULL, 0x000000011b1b7824ULL, 0x000fe200030e062dULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e8000b901c46ULL, 0x0000000016257faeULL, 0x0003e8000b901c46ULL,
0x0000000018277faeULL, 0x0003e8000b901c46ULL, 0x000000001a297faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000c7805ULL, 0x002fc40000015200ULL,
0x00f60400ff0f7984ULL, 0x000e620000000800ULL, 0x0000007506437224ULL, 0x000fc400078e02ffULL,
0x0000000102787824ULL, 0x000fe400078e0a72ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x800000000fff7812ULL, 0x002fe2000780480bULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000620043427625ULL, 0x000fe200078e0042ULL,
0x00000008ff787819ULL, 0x000fe20000011678ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c117210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc8000001140fULL,
0x0000001106067211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x0000000206067819ULL, 0x000fc8000000120fULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000b7919ULL, 0x000e640000000000ULL, 0x0000002000067824ULL, 0x002fca00078e020bULL,
0x00000003ff087819ULL, 0x000fc80000011606ULL, 0x1ffffffe080b7812ULL, 0x000fe400078ec0ffULL,
0x0000000f06087812ULL, 0x000fc600078ec0ffULL, 0x00000001060b7824ULL, 0x000fe400078e020bULL,
0x00000010080d7824ULL, 0x040fe400078e00ffULL, 0x0000001008087824ULL, 0x000fe200078e00ffULL,
0x0000000f0b067812ULL, 0x040fe400078ec0ffULL, 0x000000010b0b7810ULL, 0x000fe40007ffe0ffULL,
0x000000f00d067812ULL, 0x000fe400078ee206ULL, 0x0000000f0b0b7812ULL, 0x000fc600078ec0ffULL,
0x0000000006107984ULL, 0x000e62000000cc00ULL, 0x000000f0080b7812ULL, 0x000fca00078ee20bULL,
0x000000000b0c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fe400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fc400078e000eULL, 0x000000ffff127224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe200078e000fULL, 0x0000001406007388ULL, 0x0003e8000000cc00ULL,
0x000000100b007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff0e7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff087224ULL, 0x000fc600078e00ffULL,
0x00000000000a7805ULL, 0x002fc80000015200ULL, 0x00f60400ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x006fc4000780480fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a117210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc8000001140dULL,
0x0000001106067211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060dULL,
0x0000000206067819ULL, 0x000fc8000000120dULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff7100720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000e620000000000ULL, 0x00006a0007777a24ULL, 0x000fe200078e02ffULL,
0x3db504f309077820ULL, 0x010fe20000410000ULL, 0x0000000275757824ULL, 0x000fe200078e00ffULL,
0x0000f68800797811ULL, 0x000fe200078e18ffULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0xffffffff72737810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200078e0000ULL,
0x0000000972747810ULL, 0x000fe40007ffe0ffULL, 0x0000f608007c7811ULL, 0x000fc400078e28ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e0009ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x018fc4000001ff00ULL, 0x000000010c00780cULL, 0x000fe20003f25270ULL,
0x00000c0000007945ULL, 0x000fe20003800000ULL, 0x00000001080f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200078e000cULL, 0x000000010c0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000007604357224ULL, 0x030fe200078e02ffULL, 0x000000010b097812ULL, 0x000fc400078e0cffULL,
0x000000020e00780cULL, 0x040fe20003f06070ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000eULL,
0x000000ff0e347207ULL, 0x000fc60000800000ULL, 0x000000ffff0f1224ULL, 0x000fca00078e0208ULL,
0x000000010f1c7810ULL, 0x000fc80007ffe0ffULL, 0x000000711c00720cULL, 0x000fda0003f46070ULL,
0x000006000000a947ULL, 0x000fea0003800000ULL, 0x00000010060e7824ULL, 0x002fe200078e00ffULL,
0x00000002ff407819ULL, 0x000fe20000011606ULL, 0x000001000f1f7824ULL, 0x000fe200078e027aULL,
0x00006400353d7a11ULL, 0x040fe200078238ffULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x000000300e1d7812ULL, 0x000fe200078ec0ffULL, 0x00000002003c7824ULL, 0x000fe200078e0209ULL,
0x0000001f023a7217ULL, 0x000fe40007800000ULL, 0x0000650035357a11ULL, 0x000fe200008f3cffULL,
0x00000040340e7824ULL, 0x000fe200078e021dULL, 0x0000001840467810ULL, 0x040fe20007ffe0ffULL,
0x00000001051d7824ULL, 0x000fe200078e0240ULL, 0x0000001040447810ULL, 0x000fe20007ffe0ffULL,
0x000000013a3e7824ULL, 0x000fe200078e0a1fULL, 0x00000008403f7810ULL, 0x040fe20007ffe0ffULL,
0x000000801d1c7825ULL, 0x000fe200078e000eULL, 0x0000002040487810ULL, 0x000fc40007ffe0ffULL,
0x000010003c3c7811ULL, 0x000fe200078e60ffULL, 0x00000001053b7824ULL, 0x040fe200078e0244ULL,
0x0000003d1c1e7210ULL, 0x080fe20007f3e0ffULL, 0x0000000105377824ULL, 0x000fe200078e023fULL,
0x00000006061c7211ULL, 0x000fe200078fe8ffULL, 0x000000803b3a7825ULL, 0x000fe200078e000eULL,
0x0000003e4600720cULL, 0x000fe40003fa6070ULL, 0x000000031c4d7812ULL, 0x000fe200078ec0ffULL,
0x000000011d1f7824ULL, 0x000fe200008e0635ULL, 0x0000003d3a3a7210ULL, 0x000fe20007f3e0ffULL,
0x00000001051d7824ULL, 0x000fc400078e0246ULL, 0x0000008037367825ULL, 0x000fc800078e000eULL,
0x000000801d1c7825ULL, 0x000fe200078e000eULL, 0x0000003d36387210ULL, 0x000fc60007f5e0ffULL,
0x000000013b3b7824ULL, 0x100fe200008e0635ULL, 0x0000003d1c1c7210ULL, 0x000fe20007f7e0ffULL,
0x0000000137397824ULL, 0x100fe200010e0635ULL, 0x0000003e4000720cULL, 0x080fe20003f26070ULL,
0x000000043f4a7824ULL, 0x040fe200078e00ffULL, 0x0000003e3f00720cULL, 0x080fe20003f46070ULL,
0x000000011d1d7824ULL, 0x000fe200018e0635ULL, 0x0000003e4400720cULL, 0x040fe20003f66070ULL,
0x0000000444447824ULL, 0x000fe200078e00ffULL, 0x0ffffffc4d3f7812ULL, 0x000fe200078ef806ULL,
0x0000000105377824ULL, 0x000fe200078e0248ULL, 0xfffffffc4a417812ULL, 0x100fe200078ee24dULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0xfffffffc44457812ULL, 0x000fe200078ee24dULL,
0x000000103f3f7824ULL, 0x000fe200078e023cULL, 0x0000002840447810ULL, 0x040fe20007ffe0ffULL,
0x0000008037367825ULL, 0x000fe200078e000eULL, 0x00000030404a7810ULL, 0x000fc40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e3f7faeULL, 0x0003e2000c901c46ULL,
0x0000000105477824ULL, 0x000fe200078e0244ULL, 0x0000003d36367210ULL, 0x000fe20007f9e0ffULL,
0x0000001041417824ULL, 0x000fe200078e023cULL, 0x0000003840407810ULL, 0x000fe20007ffe0ffULL,
0x0000000105497824ULL, 0x000fe400078e024aULL, 0x0000001045457824ULL, 0x000fe200078e023cULL,
0x0000000038417faeULL, 0x0005e2000d101c46ULL, 0x0000000137377824ULL, 0x000fe200020e0635ULL,
0x0000003e4800720cULL, 0x080fe20003f86070ULL, 0x00000001054b7824ULL, 0x000fe200078e0240ULL,
0x000000003a457faeULL, 0x0007e2000d901c46ULL, 0x00000080471e7825ULL, 0x002fe200078e000eULL,
0x0000003e4400720cULL, 0x000fc40003f66070ULL, 0x0000003e4a00720cULL, 0x080fe20003f46070ULL,
0x0000000448487824ULL, 0x000fe200078e00ffULL, 0x0000003d1e1e7210ULL, 0x080fe20007fde0ffULL,
0x0000000444447824ULL, 0x000fe200078e00ffULL, 0x0000003e4000720cULL, 0x000fe20003f26070ULL,
0x0000008049387825ULL, 0x004fe200078e000eULL, 0xfffffffc483f7812ULL, 0x100fe400078ee24dULL,
0xfffffffc463b7812ULL, 0x008fe200078ee24dULL, 0x000000011f1f7824ULL, 0x000fe200030e0635ULL,
0x0000003d38387210ULL, 0x000fe20007fde0ffULL, 0x000000044a4a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc44417812ULL, 0x000fe200078ee24dULL, 0x000000804b0e7825ULL, 0x000fc600078e000eULL,
0xfffffffc4a457812ULL, 0x000fe200078ee24dULL, 0x0000000440407824ULL, 0x000fe400078e00ffULL,
0x0000000139397824ULL, 0x000fe200030e0635ULL, 0x0000003d0e0e7210ULL, 0x000fe20007fde0ffULL,
0x000000103b3b7824ULL, 0x100fe200078e023cULL, 0xfffffffc404d7812ULL, 0x000fe200078ee24dULL,
0x000000103f3f7824ULL, 0x100fe400078e023cULL, 0x00000010413d7824ULL, 0x100fe200078e023cULL,
0x000000001c3b7faeULL, 0x0003e2000e901c46ULL, 0x0000001045417824ULL, 0x000fc400078e023cULL,
0x000000104d457824ULL, 0x000fe200078e023cULL, 0x00000000363f7faeULL, 0x0003e2000e101c46ULL,
0x000000010f0f7824ULL, 0x000fc600030e0635ULL, 0x000000001e3d7faeULL, 0x0003e8000d901c46ULL,
0x0000000038417faeULL, 0x0003e8000d101c46ULL, 0x000000000e457faeULL, 0x0003e2000c901c46ULL,
0x0000053000007947ULL, 0x000fea0003800000ULL, 0x00000006060e7211ULL, 0x002fe200078fe8ffULL,
0x00000002001c7824ULL, 0x000fe200078e0209ULL, 0x00000008061e7811ULL, 0x000fc400078ff0ffULL,
0x000000030e0f7812ULL, 0x000fe400078ec0ffULL, 0x0000001006367811ULL, 0x000fe200078ff0ffULL,
0x000000041e0e7824ULL, 0x000fe200078e00ffULL, 0x0000001806387811ULL, 0x040fe200078ff0ffULL,
0x00000001053b7824ULL, 0x040fe200078e021eULL, 0x00000020063a7811ULL, 0x000fe200078ff0ffULL,
0x0000000436447824ULL, 0x000fe200078e00ffULL, 0xfffffffc0e457812ULL, 0x100fe200078ee20fULL,
0x00000010060e7824ULL, 0x040fe200078e00ffULL, 0x00000028063c7811ULL, 0x000fe200078ff0ffULL,
0x0000000438467824ULL, 0x000fe200078e00ffULL, 0x00000030063e7811ULL, 0x000fe200078ff0ffULL,
0x000000043a487824ULL, 0x000fe200078e00ffULL, 0x0000003806407811ULL, 0x000fe200078ff0ffULL,
0x000000043c4a7824ULL, 0x000fe200078e00ffULL, 0x000000300e1f7812ULL, 0x000fe200078ec0ffULL,
0x000000043e4c7824ULL, 0x000fe200078e00ffULL, 0x0000000506377211ULL, 0x000fe200078ff0ffULL,
0x00000004404e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc44477812ULL, 0x000fe200078ee20fULL,
0x00000040341e7824ULL, 0x000fe200078e021fULL, 0xfffffffc46497812ULL, 0x100fe200078ee20fULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0xfffffffc484b7812ULL, 0x100fe200078ee20fULL,
0x00000001053f7824ULL, 0x040fe200078e0236ULL, 0xfffffffc4a4d7812ULL, 0x100fe200078ee20fULL,
0x00000001053d7824ULL, 0x000fe200078e0238ULL, 0x0ffffffc0f417812ULL, 0x000fe200078ef806ULL,
0x0000000105397824ULL, 0x000fe200078e023aULL, 0xfffffffc4c4f7812ULL, 0x000fe200078ee20fULL,
0x0000008037367825ULL, 0x000fe200078e001eULL, 0xfffffffc4e517812ULL, 0x000fc400078ee20fULL,
0x0000640035537a11ULL, 0x000fe200078238ffULL, 0x00000001050f7824ULL, 0x000fe200078e023eULL,
0x000010001c1c7811ULL, 0x000fe200078e60ffULL, 0x000000803b3a7825ULL, 0x000fe200078e001eULL,
0x0000650035357a11ULL, 0x000fe400008f3cffULL, 0x0000005336367210ULL, 0x080fe20007f3e0ffULL,
0x00000001051d7824ULL, 0x000fe200078e023cULL, 0x000000533a3a7210ULL, 0x000fe20007f5e0ffULL,
0x000000803f3e7825ULL, 0x000fc800078e001eULL, 0x000000803d3c7825ULL, 0x000fe200078e001eULL,
0x000000533e3e7210ULL, 0x000fc60007f7e0ffULL, 0x0000000105557824ULL, 0x000fe200078e0240ULL,
0x000000533c3c7210ULL, 0x000fe20007f9e0ffULL, 0x0000001041417824ULL, 0x100fe400078e021cULL,
0x0000001045457824ULL, 0x100fe400078e021cULL, 0x0000001047477824ULL, 0x100fe400078e021cULL,
0x0000001049497824ULL, 0x100fe400078e021cULL, 0x000000104b4b7824ULL, 0x000fc400078e021cULL,
0x000000104d4d7824ULL, 0x100fe400078e021cULL, 0x000000104f4f7824ULL, 0x100fe400078e021cULL,
0x0000001051517824ULL, 0x000fe400078e021cULL, 0x0000008039387825ULL, 0x000fc800078e001eULL,
0x000000801d1c7825ULL, 0x000fc800078e001eULL, 0x000000800f0e7825ULL, 0x000fc800078e001eULL,
0x00000080551e7825ULL, 0x000fc800078e001eULL, 0x0000000137377824ULL, 0x100fe200008e0635ULL,
0x0000005338387210ULL, 0x080fe20007f3e0ffULL, 0x000000013b3b7824ULL, 0x100fe200010e0635ULL,
0x000000531c1c7210ULL, 0x080fe20007f5e0ffULL, 0x000000013f3f7824ULL, 0x100fe200018e0635ULL,
0x000000530e0e7210ULL, 0x080fe20007f7e0ffULL, 0x000000013d3d7824ULL, 0x100fe200020e0635ULL,
0x000000531e1e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000139397824ULL, 0x100fe200008e0635ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036417faeULL, 0x0003e2000b901c46ULL,
0x000000011d1d7824ULL, 0x000fc400010e0635ULL, 0x000000010f0f7824ULL, 0x100fe200018e0635ULL,
0x000000003a457faeULL, 0x0003e2000b901c46ULL, 0x000000011f1f7824ULL, 0x000fc600020e0635ULL,
0x000000003e477faeULL, 0x0003e8000b901c46ULL, 0x000000003c497faeULL, 0x0003e8000b901c46ULL,
0x00000000384b7faeULL, 0x0003e8000b901c46ULL, 0x000000001c4d7faeULL, 0x0003e8000b901c46ULL,
0x000000000e4f7faeULL, 0x0003e8000b901c46ULL, 0x000000001e517faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000013400780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x000000040a0a7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff047424ULL, 0x000fc600078e00ffULL,
0x000000030a00720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x00000002770e7824ULL, 0x002fe400078e020aULL, 0x00000004ff0f7424ULL, 0x000fc800078e00ffULL,
0x000066000e0e7625ULL, 0x000fca00078e000fULL, 0x000000060e047981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff0e7224ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff8060f7812ULL, 0x000fe200078ec0ffULL, 0x0000000200597824ULL, 0x000fe200078e020bULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000002006637810ULL, 0x000fe40007ffe0ffULL,
0x000000070f0f7812ULL, 0x000fe400078ef806ULL, 0x0000100059597811ULL, 0x000fe400078e60ffULL,
0x00000001ff1d7819ULL, 0x020fe2000001160fULL, 0x000000040f1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff863637812ULL, 0x000fe200078ec0ffULL, 0x000000040f1e7824ULL, 0x000fe200078e00ffULL,
0x000000010e5a7810ULL, 0x000fe20007ffe0ffULL, 0x000000011d1c7824ULL, 0x000fe200078e020eULL,
0x0000000763637812ULL, 0x000fc600078ef806ULL, 0x000000011d1d7824ULL, 0x000fe200078e025aULL,
0xfffffffc1f1c7812ULL, 0x000fe400078ee21cULL, 0x00000001ff647819ULL, 0x000fe40000011663ULL,
0xfffffffc1e1e7812ULL, 0x000fe200078ee21dULL, 0x000000101c1c7824ULL, 0x100fe400078e0259ULL,
0x00000001640f7824ULL, 0x000fe400078e020eULL, 0x000000101e347824ULL, 0x000fe200078e0259ULL,
0x000000001c3c783bULL, 0x0002a20000000200ULL, 0x0000000164647824ULL, 0x000fc800078e025aULL,
0x000000003434783bULL, 0x000fe20000000200ULL, 0x00000004631c7824ULL, 0x042fe400078e00ffULL,
0x0000000463637824ULL, 0x000fc600078e00ffULL, 0xfffffffc1c1c7812ULL, 0x000fca00078ee20fULL,
0x000000101c1c7824ULL, 0x000fca00078e0259ULL, 0x000000001c38783bULL, 0x0002e20000000200ULL,
0x0000003d005d7306ULL, 0x004fe20000009400ULL, 0x00000018ff577819ULL, 0x000fe2000001143dULL,
0x000100003c1c7824ULL, 0x002fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe2000001143cULL,
0x000100003d697824ULL, 0x040fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe2000001143eULL,
0x000001003d6a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000003d005e7306ULL, 0x000e620000005400ULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x000100003e617824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x000001003f6d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fc4000001143fULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000003e001e7306ULL, 0x000fe20000009400ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x0001000039707824ULL, 0x008fcc00078e00ffULL,
0x0000003e001f7306ULL, 0x000ea20000005400ULL, 0x0000005e5d00720bULL, 0x002fe40003f5d000ULL,
0x0000001c005d7245ULL, 0x000fe4000020d400ULL, 0x00000018ff707819ULL, 0x000fc60000011470ULL,
0x0000005700487306ULL, 0x000ff00000209400ULL, 0x0000005700477306ULL, 0x000e620000205400ULL,
0x0000001f1e00720bULL, 0x004fe20003f3d000ULL, 0x000000040d1f7824ULL, 0x000fe200078e020eULL,
0x000000020e0e7810ULL, 0x000fca0007ffe0ffULL, 0x0000005600537306ULL, 0x000ff00000209400ULL,
0x0000005600627306ULL, 0x000ea20000205400ULL, 0x000000474800720bULL, 0x002fe20003f9d000ULL,
0x000000021f487824ULL, 0x000fe200078e00ffULL, 0x0000000706477812ULL, 0x000fc800078ec0ffULL,
0x0000000847477812ULL, 0x000fe200078ef806ULL, 0x0000003c001d7306ULL, 0x000fe80000009400ULL,
0x00000010471f7824ULL, 0x000fc800078e00ffULL, 0x0000003c00507306ULL, 0x000e620000005400ULL,
0x000000625300720bULL, 0x004fe40003fbd000ULL, 0x0000004806627211ULL, 0x000fca00078fe0ffULL,
0x0000001c00557306ULL, 0x000fe20000209400ULL, 0x0000000147627824ULL, 0x000fca00078e0262ULL,
0xfffffff01f627812ULL, 0x000fe400078ee262ULL, 0x0000001c005e7306ULL, 0x0004e20000205400ULL,
0x000000501d00720bULL, 0x002fce0003f7d000ULL, 0x0000003c00547306ULL, 0x000262000000d400ULL,
0x00000010621c7824ULL, 0x004fe200078e00ffULL, 0x0000005e5500720bULL, 0x008fe20003fdd000ULL,
0x000001003c3c7824ULL, 0x002fca00078e00ffULL, 0x0000006900537306ULL, 0x000fe20000209400ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000000154543812ULL, 0x000fca00078efcffULL,
0x0000003c001d7306ULL, 0x000fe20000209400ULL, 0x000000015d5d6812ULL, 0x000fce00078efcffULL,
0x0000003c001e7306ULL, 0x000e700000205400ULL, 0x00000069005e7306ULL, 0x0004e20000205400ULL,
0x0000001e1d00720bULL, 0x002fce0003fdd000ULL, 0x0000003d005c7306ULL, 0x000e62000000d400ULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0x0000006900697245ULL, 0x004fe4000020d400ULL,
0x0000005e5300720bULL, 0x008fc80003f7d000ULL, 0x0000006a003d7306ULL, 0x000fe20000209400ULL,
0x0000003c005e7245ULL, 0x000fe4000020d400ULL, 0x000000545d3c723eULL, 0x000fe400000010ffULL,
0x000000015e5e6812ULL, 0x000fc600078efcffULL, 0x0000006a00627306ULL, 0x000ea20000205400ULL,
0x000000015c5c2812ULL, 0x002fe400078efcffULL, 0x0000000169693812ULL, 0x000fca00078efcffULL,
0x00000049006b7306ULL, 0x000ff00000209400ULL, 0x00000049006c7306ULL, 0x000e620000205400ULL,
0x000000623d00720bULL, 0x004fe40003fdd000ULL, 0x00000056003d7245ULL, 0x000fc8000020d400ULL,
0x000000013d3d5812ULL, 0x000fe200078efcffULL, 0x0000003e005b7306ULL, 0x0004e6000000d400ULL,
0x0000005e3d3d723eULL, 0x000fe400000010ffULL, 0x0000006c6b00720bULL, 0x002fe20003fbd000ULL,
0x000001003e3e7824ULL, 0x004fe400078e00ffULL, 0x00000061005d7306ULL, 0x000fe40000209400ULL,
0x0000003c1c30723cULL, 0x000be20000041830ULL, 0x00000057006c7245ULL, 0x000fc4000020d400ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x000000016c6c4812ULL, 0x000fe200078efcffULL,
0x0000006100627306ULL, 0x000e620000205400ULL, 0x0000006a003d7245ULL, 0x020fe4000020d400ULL,
0x0000005c693c723eULL, 0x000fe400000010ffULL, 0x000000013d3d6812ULL, 0x000fe400078efcffULL,
0x00000049006a7245ULL, 0x000fe2000020d400ULL, 0x0000003e005e7306ULL, 0x000fe20000209400ULL,
0x0000003d6c3d723eULL, 0x000fe200000010ffULL, 0x000100003f6c7824ULL, 0x000fe200078e00ffULL,
0x000000015b5b1812ULL, 0x008fc400078efcffULL, 0x000000016a6a5812ULL, 0x000fe400078efcffULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x0000003e006b7306ULL, 0x000ea20000205400ULL,
0x000000625d00720bULL, 0x002fe20003f5d000ULL, 0x0000003c1c2c723cULL, 0x000b62000004182cULL,
0x00000018ff5c7819ULL, 0x000fca0000011434ULL, 0x0000003f005f7306ULL, 0x000fe20000009400ULL,
0x00000061003c7245ULL, 0x020fe4000020d400ULL, 0x0000003e003d7245ULL, 0x000fc6000020d400ULL,
0x000000013c3c2812ULL, 0x000fe400078efcffULL, 0x0000006b5e00720bULL, 0x004fe20003f7d000ULL,
0x0000003f00607306ULL, 0x000e620000005400ULL, 0x0000005b3c3c723eULL, 0x000fe400000010ffULL,
0x00000018ff5b7819ULL, 0x000fca0000011435ULL, 0x0000004600657306ULL, 0x000fe80000209400ULL,
0x000000013d3d3812ULL, 0x000fc800078efcffULL, 0x0000004600667306ULL, 0x0004e20000205400ULL,
0x0000003d6a3d723eULL, 0x000fe400000010ffULL, 0x000000605f00720bULL, 0x002fe20003fdd000ULL,
0x0001000038607824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fc60000011438ULL,
0x0000003c1c28723cULL, 0x000be20000041828ULL, 0x0000006c00697306ULL, 0x000fe20000209400ULL,
0x00000018ff607819ULL, 0x000fe40000011460ULL, 0x0000004600467245ULL, 0x004fc6000020d400ULL,
0xfffffffc633c7812ULL, 0x020fe400078ee264ULL, 0x0000006c006e7306ULL, 0x000e620000205400ULL,
0x000000666500720bULL, 0x008fe40003f3d000ULL, 0x000000103c3c7824ULL, 0x000fca00078e0259ULL,
0x0000005f00637306ULL, 0x000fec0000209400ULL, 0x0000000146461812ULL, 0x000fe400078efcffULL,
0x0000005f00647306ULL, 0x000ea20000205400ULL, 0x0000006e6900720bULL, 0x002fe40003f7d000ULL,
0x00000018ff6e7819ULL, 0x000fca000001143aULL, 0x0000006d005a7306ULL, 0x000ff00000209400ULL,
0x0000006d006b7306ULL, 0x0002e20000205400ULL, 0x000000646300720bULL, 0x004fce0003fbd000ULL,
0x0000003f00587306ULL, 0x0004a2000000d400ULL, 0x0000006d006d7245ULL, 0x002fce000020d400ULL,
0x0000003800677306ULL, 0x000fe20000009400ULL, 0x0000006b5a00720bULL, 0x008fe20003f9d000ULL,
0x000000003c3c783bULL, 0x004e620000000200ULL, 0x00000018ff5a7819ULL, 0x000fca0000011436ULL,
0x0000003800687306ULL, 0x000ea20000005400ULL, 0x0000000158586812ULL, 0x000fca00078efcffULL,
0x000000016d6d4812ULL, 0x000fe400078efcffULL, 0x0000003800457306ULL, 0x000670000000d400ULL,
0x0000006000597306ULL, 0x000fe20000209400ULL, 0x0000010038387824ULL, 0x008fe200078e00ffULL,
0x000000686700720bULL, 0x004fc80003f5d000ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000006000667306ULL, 0x000eae0000205400ULL, 0x0000000145452812ULL, 0x002fe200078efcffULL,
0x0000003800647306ULL, 0x000ff00000209400ULL, 0x0000003800657306ULL, 0x000e620000205400ULL,
0x000000665900720bULL, 0x004fc40003fdd000ULL, 0x0000006c00597245ULL, 0x000fe4000020d400ULL,
0x0000005f006c7245ULL, 0x000fe4000020d400ULL, 0x0000000159593812ULL, 0x000fe200078efcffULL,
0x00000034004f7306ULL, 0x000fe20000009400ULL, 0x000000016c6c5812ULL, 0x000fe400078efcffULL,
0x000000585958723eULL, 0x000fe400000010ffULL, 0x0000006d4659723eULL, 0x000fe200000010ffULL,
0x000001003a6d7824ULL, 0x000fe200078e00ffULL, 0x000000656400720bULL, 0x002fe20003f3d000ULL,
0x0000003400517306ULL, 0x000e660000005400ULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x000000581c24723cULL, 0x000b680000041824ULL, 0x0000003500527306ULL, 0x000fe60000009400ULL,
0x0000006000587245ULL, 0x020fe2000020d400ULL, 0x0001000034607824ULL, 0x000fe200078e00ffULL,
0x0000003800597245ULL, 0x000fc4000020d400ULL, 0x0000000158586812ULL, 0x000fe400078efcffULL,
0x0000000159591812ULL, 0x000fe200078efcffULL, 0x00000035004d7306ULL, 0x000ea20000005400ULL,
0x000000455858723eULL, 0x000fe400000010ffULL, 0x000000596c59723eULL, 0x000fe200000010ffULL,
0x000100003a6c7824ULL, 0x000fe200078e00ffULL, 0x000000514f00720bULL, 0x002fe20003f7d000ULL,
0x00000100394f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000003900507306ULL, 0x000fe20000009400ULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x000000581c20723cULL, 0x000b620000041820ULL, 0x00000018ff4f7819ULL, 0x000fca000001144fULL,
0x0000003900557306ULL, 0x000e620000005400ULL, 0x0000004d5200720bULL, 0x004fe40003fdd000ULL,
0x00000018ff4d7819ULL, 0x000fe40000011439ULL, 0x00000018ff597819ULL, 0x020fc6000001143cULL,
0x0000007000587306ULL, 0x000ff00000209400ULL, 0x0000007000517306ULL, 0x0004e20000205400ULL,
0x000000555000720bULL, 0x002fce0003f5d000ULL, 0x0000004d00527306ULL, 0x000fe20000209400ULL,
0x0000007000707245ULL, 0x004fce000020d400ULL, 0x0000004d00557306ULL, 0x000e620000205400ULL,
0x000000515800720bULL, 0x008fe40003f3d000ULL, 0x0000005c00587245ULL, 0x000fca000020d400ULL,
0x0000004f00507306ULL, 0x000fec0000209400ULL, 0x0000000170701812ULL, 0x000fe400078efcffULL,
0x0000004f00517306ULL, 0x0004e20000205400ULL, 0x000000555200720bULL, 0x002fce0003f9d000ULL,
0x0000003900537306ULL, 0x000e62000000d400ULL, 0x0000004f004f7245ULL, 0x004fce000020d400ULL,
0x0000006c00397306ULL, 0x000fe20000209400ULL, 0x000000515000720bULL, 0x008fce0003f3d000ULL,
0x0000006c00527306ULL, 0x0004e20000205400ULL, 0x0000000153532812ULL, 0x002fca00078efcffULL,
0x000000014f4f1812ULL, 0x000fe400078efcffULL, 0x00000036004e7306ULL, 0x000fe20000009400ULL,
0x0000006c006c7245ULL, 0x004fce000020d400ULL, 0x00000036004c7306ULL, 0x000e620000005400ULL,
0x000000523900720bULL, 0x008fce0003f5d000ULL, 0x0000003a00547306ULL, 0x000fec0000009400ULL,
0x000000016c6c2812ULL, 0x000fe400078efcffULL, 0x0000003a00567306ULL, 0x000ea20000005400ULL,
0x0000004c4e00720bULL, 0x002fe20003f3d000ULL, 0x000100003b4c7824ULL, 0x000fe200078e00ffULL,
0x0000004d004e7245ULL, 0x000fc8000020d400ULL, 0x000000014e4e4812ULL, 0x000fe200078efcffULL,
0x0000003b005d7306ULL, 0x000ff00000009400ULL, 0x0000003b005e7306ULL, 0x000e620000005400ULL,
0x000000565400720bULL, 0x004fe20003fbd000ULL, 0x0000010034567824ULL, 0x000fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x0000006d00507306ULL, 0x000ff00000209400ULL,
0x0000006d00397306ULL, 0x0004e20000205400ULL, 0x0000005e5d00720bULL, 0x002fe20003f9d000ULL,
0x000001003b5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fc8000001144cULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000003a00577306ULL, 0x000e62000000d400ULL,
0x0000006d006d7245ULL, 0x004fce000020d400ULL, 0x0000006e003a7306ULL, 0x000fe20000209400ULL,
0x000000395000720bULL, 0x008fce0003f5d000ULL, 0x0000006e004d7306ULL, 0x0004e20000205400ULL,
0x0000000157575812ULL, 0x002fca00078efcffULL, 0x000000016d6d2812ULL, 0x000fe400078efcffULL,
0x0000005d004c7306ULL, 0x000fe20000209400ULL, 0x0000006e006e7245ULL, 0x004fce000020d400ULL,
0x0000005d00517306ULL, 0x0002a20000205400ULL, 0x0000004d3a00720bULL, 0x008fce0003fbd000ULL,
0x0000005e00507306ULL, 0x000fe20000209400ULL, 0x0000005d005d7245ULL, 0x002fca000020d400ULL,
0x000000016e6e5812ULL, 0x000fe400078efcffULL, 0x0000005e004d7306ULL, 0x0002e20000205400ULL,
0x000000514c00720bULL, 0x004fe20003f5d000ULL, 0x0000010035517824ULL, 0x000fca00078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0000003b00497306ULL, 0x0004e2000000d400ULL,
0x0000005e005e7245ULL, 0x002fca000020d400ULL, 0x000000015d5d2812ULL, 0x000fe400078efcffULL,
0x00000037004b7306ULL, 0x000fe20000009400ULL, 0x00000018ff3b7819ULL, 0x004fe4000001143bULL,
0x0000004d5000720bULL, 0x008fe40003fbd000ULL, 0x0000003b005f7245ULL, 0x000fc6000020d400ULL,
0x00000037004a7306ULL, 0x000e620000005400ULL, 0x0000000149494812ULL, 0x000fce00078efcffULL,
0x0000003b00397306ULL, 0x000fe20000209400ULL, 0x000000015e5e5812ULL, 0x000fce00078efcffULL,
0x0000003b004c7306ULL, 0x000ea20000205400ULL, 0x0000004a4b00720bULL, 0x002fce0003f5d000ULL,
0x00000060004d7306ULL, 0x000ff00000209400ULL, 0x0000006000507306ULL, 0x0002e20000205400ULL,
0x0000004c3900720bULL, 0x004fe20003f9d000ULL, 0x00010000364c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x00000056003a7306ULL, 0x000fe20000209400ULL,
0x0000006000607245ULL, 0x002fca000020d400ULL, 0x000000015f5f4812ULL, 0x000fe400078efcffULL,
0x00000056004b7306ULL, 0x0002a20000205400ULL, 0x000000504d00720bULL, 0x008fe20003fbd000ULL,
0x0001000035507824ULL, 0x000fe400078e00ffULL, 0x00000100364d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000005c00627306ULL, 0x000fe20000209400ULL,
0x0000005600567245ULL, 0x002fe4000020d400ULL, 0x00000018ff4d7819ULL, 0x000fc6000001144dULL,
0x0000000160605812ULL, 0x000fe400078efcffULL, 0x0000005c00617306ULL, 0x000e620000205400ULL,
0x0000004b3a00720bULL, 0x004fce0003f9d000ULL, 0x00000050004a7306ULL, 0x000fec0000209400ULL,
0x0000000156564812ULL, 0x000fe400078efcffULL, 0x00000050004b7306ULL, 0x0004e20000205400ULL,
0x000000616200720bULL, 0x002fe40003fbd000ULL, 0x00000018ff617819ULL, 0x000fca0000011437ULL,
0x00000051003b7306ULL, 0x000fe20000209400ULL, 0x0000005000507245ULL, 0x004fca000020d400ULL,
0x0000000158585812ULL, 0x000fe400078efcffULL, 0x0000005100527306ULL, 0x0002a20000205400ULL,
0x0000004b4a00720bULL, 0x008fe40003f9d000ULL, 0x00000018ff4b7819ULL, 0x000fca000001143dULL,
0x0000005a00697306ULL, 0x000fe20000209400ULL, 0x0000005100517245ULL, 0x002fca000020d400ULL,
0x0000000150504812ULL, 0x000fe400078efcffULL, 0x0000005a00687306ULL, 0x0002e20000205400ULL,
0x000000523b00720bULL, 0x004fe40003fbd000ULL, 0x0000005b00527245ULL, 0x000fca000020d400ULL,
0x0000003400447306ULL, 0x000ea2000000d400ULL, 0x0000005a005a7245ULL, 0x002fca000020d400ULL,
0x0000000151515812ULL, 0x000fe400078efcffULL, 0x0000005b006a7306ULL, 0x000fe20000209400ULL,
0x000000686900720bULL, 0x008fe20003f9d000ULL, 0x0000010037687824ULL, 0x000fca00078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x0000005b006b7306ULL, 0x000e620000205400ULL,
0x0000000144443812ULL, 0x004fca00078efcffULL, 0x000000015a5a4812ULL, 0x000fe400078efcffULL,
0x0000004c004a7306ULL, 0x000ff00000209400ULL, 0x0000004c003b7306ULL, 0x0004e20000205400ULL,
0x0000006b6a00720bULL, 0x002fce0003f7d000ULL, 0x00000036000f7306ULL, 0x000e62000000d400ULL,
0x0000004c004c7245ULL, 0x004fca000020d400ULL, 0x0000000152523812ULL, 0x000fe400078efcffULL,
0x0000004d00367306ULL, 0x000fe20000209400ULL, 0x0000003b4a00720bULL, 0x008fe40003fbd000ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143eULL, 0x000000515251723eULL, 0x000fc600000010ffULL,
0x0000004d00697306ULL, 0x0004e20000205400ULL, 0x000000010f0f1812ULL, 0x002fca00078efcffULL,
0x000000014c4c5812ULL, 0x000fe400078efcffULL, 0x0000003d00657306ULL, 0x000fe20000009400ULL,
0x0000004d004d7245ULL, 0x004fe4000020d400ULL, 0x0000000f4c4c723eULL, 0x000fca00000010ffULL,
0x0000003d00667306ULL, 0x000e620000005400ULL, 0x000000693600720bULL, 0x008fe20003f7d000ULL,
0x000100003c367824ULL, 0x000fe400078e00ffULL, 0x0001000037697824ULL, 0x000fc600078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000003500407306ULL, 0x000ea2000000d400ULL,
0x00000018ff697819ULL, 0x000fca0000011469ULL, 0x000000014d4d3812ULL, 0x000fe400078efcffULL,
0x0000003c00637306ULL, 0x000fe20000009400ULL, 0x000000666500720bULL, 0x002fe40003fbd000ULL,
0x0000004d5a4d723eULL, 0x000fca00000010ffULL, 0x0000003c00647306ULL, 0x000e620000005400ULL,
0x0000000140406812ULL, 0x004fc800078efcffULL, 0x000000405050723eULL, 0x000fc600000010ffULL,
0x0000003e00677306ULL, 0x000ff00000009400ULL, 0x0000003e006f7306ULL, 0x000ea20000005400ULL,
0x000000646300720bULL, 0x002fe20003fdd000ULL, 0x000001003c647824ULL, 0x000fca00078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0000003f00557306ULL, 0x000ff00000009400ULL,
0x0000003f00347306ULL, 0x000e620000005400ULL, 0x0000006f6700720bULL, 0x004fce0003f3d000ULL,
0x00000036004a7306ULL, 0x000ff00000209400ULL, 0x0000003600657306ULL, 0x000ea20000205400ULL,
0x000000345500720bULL, 0x002fce0003f7d000ULL, 0x0000003c00467306ULL, 0x0002f0000000d400ULL,
0x0000006100357306ULL, 0x000fe20000209400ULL, 0x000000654a00720bULL, 0x004fe40003f9d000ULL,
0x00000036003c7245ULL, 0x002fca000020d400ULL, 0x00000061003a7306ULL, 0x0002a20000205400ULL,
0x0000000146466812ULL, 0x008fca00078efcffULL, 0x000000013c3c4812ULL, 0x000fe400078efcffULL,
0x0000006400347306ULL, 0x000fe20000209400ULL, 0x0000006100617245ULL, 0x002fe4000020d400ULL,
0x000000463c3c723eULL, 0x000fca00000010ffULL, 0x0000006400677306ULL, 0x000e620000205400ULL,
0x0000003a3500720bULL, 0x004fe40003f9d000ULL, 0x0000004f4e35723eULL, 0x000fe400000010ffULL,
0x00000064004f7245ULL, 0x000fe4000020d400ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143fULL,
0x0000006900657306ULL, 0x000fec0000209400ULL, 0x0000000161614812ULL, 0x000fc400078efcffULL,
0x000000673400720bULL, 0x002fe20003fdd000ULL, 0x0000006900667306ULL, 0x0002a20000205400ULL,
0x000000537034723eULL, 0x000fe200000010ffULL, 0x000100003d537824ULL, 0x000fca00078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x000000341c14723cULL, 0x000b620000041814ULL,
0x0000003700417306ULL, 0x000ee2000000d400ULL, 0x0000006900697245ULL, 0x002fe4000020d400ULL,
0x000000014f4f6812ULL, 0x000fc600078efcffULL, 0x0000000248357810ULL, 0x020fe40007ffe0ffULL,
0x0000006800367306ULL, 0x000fe20000209400ULL, 0x000000666500720bULL, 0x004fe40003fdd000ULL,
0x0000003506347211ULL, 0x000fe400078fe0ffULL, 0x0000006d6e35723eULL, 0x000fc600000010ffULL,
0x0000006800377306ULL, 0x0002a20000205400ULL, 0x0000000147347824ULL, 0x000fe200078e0234ULL,
0x0000000141412812ULL, 0x008fe200078efcffULL, 0x0000001047477824ULL, 0x000fc600078e00ffULL,
0x0000000169696812ULL, 0x000fe400078efcffULL, 0xfffffff047647812ULL, 0x000fe200078ee234ULL,
0x0000005300487306ULL, 0x000fe20000209400ULL, 0x000000576c34723eULL, 0x000fe200000010ffULL,
0x000001003e577824ULL, 0x000fe200078e00ffULL, 0x0000006800687245ULL, 0x002fe2000020d400ULL,
0x00000010646a7824ULL, 0x000fe400078e00ffULL, 0x000100003e647824ULL, 0x000fe200078e00ffULL,
0x000000373600720bULL, 0x004fe20003fdd000ULL, 0x000000341c18723cULL, 0x000b620000041818ULL,
0x0000005300477306ULL, 0x0002a20000205400ULL, 0x000000006a34783bULL, 0x020ee20000000200ULL,
0x00000018ff647819ULL, 0x000fc40000011464ULL, 0x00000018ff577819ULL, 0x000fc80000011457ULL,
0x0000005900627306ULL, 0x000fe20000209400ULL, 0x0000005300537245ULL, 0x002fe4000020d400ULL,
0x0000000168686812ULL, 0x000fca00078efcffULL, 0x0000005900637306ULL, 0x000e620000205400ULL,
0x000000474800720bULL, 0x004fe20003fdd000ULL, 0x000100003f477824ULL, 0x000fe200078e00ffULL,
0x000000495d48723eULL, 0x000fe400000010ffULL, 0x0000005e5f49723eULL, 0x000fe200000010ffULL,
0x000001003f5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000003d00387306ULL, 0x0004e8000000d400ULL, 0x000000481c10723cULL, 0x000b640000041810ULL,
0x0000000153536812ULL, 0x000fc400078efcffULL, 0x0000004b005b7306ULL, 0x000fe20000209400ULL,
0x000001003d3d7824ULL, 0x004fe200078e00ffULL, 0x000000636200720bULL, 0x002fe40003f5d000ULL,
0x00000041691c723eULL, 0x020fe400000010ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000004b005c7306ULL, 0x000e620000205400ULL, 0x00000068611d723eULL, 0x000fe200000010ffULL,
0x00000050342c723cULL, 0x008f62000004182cULL, 0x0000005900487245ULL, 0x000fc4000020d400ULL,
0x00000018ff1e7819ULL, 0x000fe4000001145eULL, 0x0000000148482812ULL, 0x000fe200078efcffULL,
0x0000003d00657306ULL, 0x000fe20000209400ULL, 0x0000000138385812ULL, 0x000fe200078efcffULL,
0x0000001c3424723cULL, 0x040b6c0000041824ULL, 0x0000003d00667306ULL, 0x0004e20000205400ULL,
0x0000005c5b00720bULL, 0x002fe20003f9d000ULL, 0x0000004c3428723cULL, 0x000f640000041828ULL,
0x0000003d001d7245ULL, 0x020fc8000020d400ULL, 0x0000006400677306ULL, 0x000fe20000209400ULL,
0x0000004f483d723eULL, 0x004fce00000010ffULL, 0x0000006400637306ULL, 0x0002a20000205400ULL,
0x000000666500720bULL, 0x008fe20003f5d000ULL, 0x0000003c3420723cULL, 0x000f620000041820ULL,
0x0000005700657245ULL, 0x000fca000020d400ULL, 0x0000003e00457306ULL, 0x0006a2000000d400ULL,
0x0000006400647245ULL, 0x002fca000020d400ULL, 0x000000011d1d2812ULL, 0x000fe400078efcffULL,
0x0000003f00397306ULL, 0x000262000000d400ULL, 0x00000044603e723eULL, 0x008fe400000010ffULL,
0x000000636700720bULL, 0x004fca0003fbd000ULL, 0x0000001e001c7306ULL, 0x000fe20000205400ULL,
0x00000056583f723eULL, 0x002fe400000010ffULL, 0x0000000145451812ULL, 0x000fca00078efcffULL,
0x0000003e3430723cULL, 0x000b620000041830ULL, 0x0000003b00547306ULL, 0x000fe20000209400ULL,
0x0000000164645812ULL, 0x000fe400078efcffULL, 0x0000000139393812ULL, 0x000fe400078efcffULL,
0x000000456464723eULL, 0x000fe400000010ffULL, 0x0000004b003e7245ULL, 0x020fe2000020d400ULL,
0x0000001e003f7306ULL, 0x000e660000209400ULL, 0x000000013e3e4812ULL, 0x000fc800078efcffULL,
0x0000001d3e1d723eULL, 0x000fe200000010ffULL, 0x0000003b00557306ULL, 0x000eb00000205400ULL,
0x0000003a004a7306ULL, 0x000fe20000209400ULL, 0x0000001c3f00720bULL, 0x002fc40003f3d000ULL,
0x00000038531c723eULL, 0x000fe400000010ffULL, 0x0000003b00387245ULL, 0x000fc6000020d400ULL,
0x0000003a004e7306ULL, 0x0002e20000205400ULL, 0x000000555400720bULL, 0x004fe20003fdd000ULL,
0x0000001c3414723cULL, 0x000b6c0000041814ULL, 0x0000005700627306ULL, 0x000fe20000209400ULL,
0x0000001e001d7245ULL, 0x020fe4000020d400ULL, 0x00000047001c7245ULL, 0x000fc4000020d400ULL,
0x0000003a003a7245ULL, 0x002fe4000020d400ULL, 0x000000011d1d1812ULL, 0x000fe200078efcffULL,
0x00000057005d7306ULL, 0x000e620000205400ULL, 0x0000004e4a00720bULL, 0x008fe40003f5d000ULL,
0x000000040e00780cULL, 0x000fe40003f25270ULL, 0x0000000138386812ULL, 0x000fc600078efcffULL,
0x0000004700447306ULL, 0x000fec0000209400ULL, 0x000000013a3a2812ULL, 0x000fe400078efcffULL,
0x00000047001f7306ULL, 0x000ea20000205400ULL, 0x0000005d6200720bULL, 0x002fe40003f9d000ULL,
0x0000001d3a1d723eULL, 0x000fd600000010ffULL, 0x0000000165654812ULL, 0x000fe400078efcffULL,
0x0000001f4400720bULL, 0x004fe40003fbd000ULL, 0x000000653865723eULL, 0x000fce00000010ffULL,
0x000000643418723cULL, 0x000b680000041818ULL, 0x000000011c1c5812ULL, 0x000fc800078efcffULL,
0x000000391c1c723eULL, 0x000fce00000010ffULL, 0x0000001c3410723cULL, 0x000b620000041810ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe0c000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0009ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd37000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000000731317220ULL, 0x080fe20000410000ULL,
0x000000072c0b7220ULL, 0x080fe20000410000ULL, 0x000000072d0c7220ULL, 0x080fe20000410000ULL,
0x0000000714147220ULL, 0x080fe20000410000ULL, 0x00000007301f7220ULL, 0x080fe20000410000ULL,
0x00000007320e7220ULL, 0x080fe20000410000ULL, 0x00000007331e7220ULL, 0x080fe20000410000ULL,
0x0000000728337220ULL, 0x080fe20000410000ULL, 0x0000000721307220ULL, 0x080fe20000410000ULL,
0x0000000718347220ULL, 0x0a0fe20000410000ULL, 0x0000000719327220ULL, 0x080fe20000410000ULL,
0x000000072e0f7220ULL, 0x080fe20000410000ULL, 0x000000072f1c7220ULL, 0x080fe20000410000ULL,
0x000000072a287220ULL, 0x080fe20000410000ULL, 0x000000072b1d7220ULL, 0x080fe20000410000ULL,
0x0000000720367220ULL, 0x080fe20000410000ULL, 0x0000000723217220ULL, 0x080fe20000410000ULL,
0x000000071a187220ULL, 0x080fe20000410000ULL, 0x000000071b197220ULL, 0x080fe20000410000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0031ULL, 0x00000007292e7220ULL, 0x080fe20000410000ULL,
0x00000007242f7220ULL, 0x080fe20000410000ULL, 0x0000000725387220ULL, 0x080fe20000410000ULL,
0x00000007262a7220ULL, 0x080fe20000410000ULL, 0x0000000727377220ULL, 0x080fe20000410000ULL,
0x0000000722227220ULL, 0x080fe20000410000ULL, 0x0000000715357220ULL, 0x080fe20000410000ULL,
0x0000000716167220ULL, 0x080fe20000410000ULL, 0x0000000717177220ULL, 0x080fe20000410000ULL,
0x00000007102b7220ULL, 0x080fe20000410000ULL, 0x0000000711207220ULL, 0x080fe20000410000ULL,
0x00000007121a7220ULL, 0x080fe20000410000ULL, 0x00000007131b7220ULL, 0x000fe20000410000ULL,
0x000000ffff2d7224ULL, 0x000fc400078e000bULL, 0x000000ffff237224ULL, 0x000fe400078e000cULL,
0x000000ffff317224ULL, 0x000fe200078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000790c7f8cULL, 0x0002a2000c80043fULL, 0x000000ffff297224ULL, 0x000fe400078e001cULL,
0x000000ffff277224ULL, 0x000fe400078e001dULL, 0x000000ffff1d7224ULL, 0x000fe400078e0022ULL,
0x000000ffff1c7224ULL, 0x000fc400078e0021ULL, 0x000000ffff267224ULL, 0x000fe400078e000eULL,
0x000000ffff257224ULL, 0x000fe400078e000fULL, 0x000000ffff217224ULL, 0x000fe400078e0016ULL,
0x000000ffff227224ULL, 0x000fc400078e0017ULL, 0x00000000000e7805ULL, 0x002fca0000015200ULL,
0x00000400790b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x006fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100e107210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0fULL, 0x003d09001000780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401000780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011411ULL,
0x000000100b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff107224ULL, 0x000fca00000e0611ULL,
0x000000020b0b7819ULL, 0x000fc80000001210ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400790b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000406247824ULL, 0x000fe200078e00ffULL, 0x000000780800720cULL, 0x000fc80003f06070ULL,
0xfffffff0240b7812ULL, 0x000fca00078ec0ffULL, 0x00000080000b7824ULL, 0x000fca00078e020bULL,
0x00f400000b0c7984ULL, 0x0002a20000000c00ULL, 0x000014f000008947ULL, 0x000fea0003800000ULL,
0x00005a0000127b06ULL, 0x000ee20000209000ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fe20003f85070ULL, 0x0000010008397824ULL, 0x000fe200078e027aULL,
0x00005a00ff167a12ULL, 0x000fe200078e33ffULL, 0x00000002063a7824ULL, 0x000fca00078e00ffULL,
0x000000063a3a7812ULL, 0x000fca00078ec0ffULL, 0x000000013a3c7824ULL, 0x000fe200078e0272ULL,
0x0000001200127308ULL, 0x008ee40000001000ULL, 0x0ffffffe12147810ULL, 0x008fcc0007ffe0ffULL,
0x0000001400117305ULL, 0x000ee4000021f000ULL, 0x000000ffff137224ULL, 0x008fc800078e0a11ULL,
0x00005a0013137a24ULL, 0x000fc800078e02ffULL, 0x0000001311157227ULL, 0x000fe200078e0010ULL,
0x0000007b06107211ULL, 0x000fca00078ff0ffULL, 0x0000001015117227ULL, 0x000fc800078e00ffULL,
0x000000ffff137224ULL, 0x000fc800078e0a11ULL, 0x00005a0013127a24ULL, 0x000fe200078e0210ULL,
0x0000000810107810ULL, 0x000fc80007ffe0ffULL, 0x00005a0012007a0cULL, 0x000fe20003f06070ULL,
0x0000001015147227ULL, 0x000fc800078e00ffULL, 0x000000ffff137224ULL, 0x000fc800078e0a14ULL,
0x00005a0013137a24ULL, 0x000fe200078e0210ULL, 0x0000003902107217ULL, 0x000fc60007800000ULL,
0x80005a0012120a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0013007a0cULL, 0x000fe20003f46070ULL,
0x0000000110397824ULL, 0x000fe200078e0a39ULL, 0x00005a0012007a0cULL, 0x000fe20003f26070ULL,
0x0000000174107824ULL, 0x000fe200078e023aULL, 0x0000000111110810ULL, 0x000fc60007ffe0ffULL,
0x0000000110127824ULL, 0x040fe200078e0a39ULL, 0x000000391000720cULL, 0x000fca0003f66070ULL,
0x80005a0013132a10ULL, 0x000fe40007ffe0ffULL, 0x0000000111111810ULL, 0x000fe40007ffe0ffULL,
0x00005a0013007a0cULL, 0x000fe40003f06070ULL, 0x0000001116107207ULL, 0x000fe40006000000ULL,
0x0000001273117217ULL, 0x040fe20003800000ULL, 0x000000013c127824ULL, 0x000fe200078e0a39ULL,
0x0000001073107217ULL, 0x000fc40003800000ULL, 0x00000004ff117819ULL, 0x000fe40000011611ULL,
0x000000393c00720cULL, 0x000fe20003f26070ULL, 0x0000001075527224ULL, 0x000fe200078e02ffULL,
0x0000001273127217ULL, 0x000fe40003800000ULL, 0x000000ff11157207ULL, 0x000fe40001800000ULL,
0x0000000114142810ULL, 0x000fe40007ffe0ffULL, 0x000000ff124f7207ULL, 0x000fe20000800000ULL,
0x0000000152117824ULL, 0x000fe200078e0215ULL, 0x0000000114140810ULL, 0x000fc40007ffe0ffULL,
0x000000524f137211ULL, 0x000fe200078fe0ffULL, 0x0000000211107825ULL, 0x100fe200078e0042ULL,
0x0000001416147207ULL, 0x000fe40006000000ULL, 0x000000103a3b7812ULL, 0x000fe200078efcffULL,
0x0000000213127825ULL, 0x000fe200078e0042ULL, 0x0000001473147217ULL, 0x000fe20003800000ULL,
0x0000000610507981ULL, 0x0046a8000c1e9500ULL, 0x0000000612537981ULL, 0x0002a2000c1e9500ULL,
0x0000001475547224ULL, 0x000fc800078e02ffULL, 0x0000000115157824ULL, 0x000fe200078e0254ULL,
0x000000203a3d7812ULL, 0x000fe200078efcffULL, 0x0000000174107824ULL, 0x008fe200078e023bULL,
0x000000544f177211ULL, 0x000fe200078fe0ffULL, 0x0000000215147825ULL, 0x000fc800078e0042ULL,
0x0000000110127824ULL, 0x042fe200078e0a39ULL, 0x000000391000720cULL, 0x000fe20003f26070ULL,
0x000000013b3e7824ULL, 0x000fe200078e0272ULL, 0x00000006144d7981ULL, 0x0002e2000c1e9500ULL,
0x0000000174467824ULL, 0x000fe200078e023dULL, 0x0000001273127217ULL, 0x000fe20003800000ULL,
0x000000013e107824ULL, 0x000fe400078e0a39ULL, 0x0000000217167825ULL, 0x000fe200078e0042ULL,
0x00000004ff127819ULL, 0x000fc80000011612ULL, 0x000000ff12157207ULL, 0x002fe20000800000ULL,
0x0000000146487824ULL, 0x000fe200078e0a39ULL, 0x000000393e00720cULL, 0x080fe20003f06070ULL,
0x000000013d447824ULL, 0x000fe200078e0272ULL, 0x0000001073107217ULL, 0x040fe20003800000ULL,
0x0000000152117824ULL, 0x000fe200078e0215ULL, 0x0000004873477217ULL, 0x000fe20003800000ULL,
0x0000000616587981ULL, 0x0002e2000c1e9500ULL, 0x000000ff103f7207ULL, 0x000fe20000000000ULL,
0x0000000211107825ULL, 0x000fe200078e0042ULL, 0x000000394600720cULL, 0x000fc40003f26070ULL,
0x00000004ff477819ULL, 0x000fe40000011647ULL, 0x0000000610407981ULL, 0x0002e2000c1e9500ULL,
0x000000303a467812ULL, 0x000fe400078efcffULL, 0x000000ff47497207ULL, 0x000fe20000800000ULL,
0x0000000115157824ULL, 0x000fe200078e0254ULL, 0x000000523f137211ULL, 0x040fe200078fe0ffULL,
0x0000000144107824ULL, 0x002fe200078e0a39ULL, 0x000000543f177211ULL, 0x000fe200078fe0ffULL,
0x0000000152117824ULL, 0x000fe200078e0249ULL, 0x000000394400720cULL, 0x000fc40003f06070ULL,
0x0000001073107217ULL, 0x000fe20003800000ULL, 0x0000000174567824ULL, 0x000fe400078e0246ULL,
0x0000000213127825ULL, 0x000fe200078e0042ULL, 0x000000ff104b7207ULL, 0x000fc60000000000ULL,
0x0000000215147825ULL, 0x100fe200078e0042ULL, 0x0000000612417981ULL, 0x0002e6000c1e9500ULL,
0x0000000217167825ULL, 0x100fe200078e0042ULL, 0x0000000614457981ULL, 0x0002e6000c1e9500ULL,
0x0000000211107825ULL, 0x000fe200078e0042ULL, 0x0000000616487981ULL, 0x0002e6000c1e9500ULL,
0x00000001564e7824ULL, 0x000fe200078e0a39ULL, 0x0000000610477981ULL, 0x0002e2000c1e9500ULL,
0x00000001464c7824ULL, 0x000fe200078e0272ULL, 0x000000524b137211ULL, 0x002fc400078fe0ffULL,
0x0000004e73517217ULL, 0x000fe20003800000ULL, 0x0000000149157824ULL, 0x000fe200078e0254ULL,
0x000000544b177211ULL, 0x000fe200078fe0ffULL, 0x000000014c107824ULL, 0x000fe200078e0a39ULL,
0x000000395600720cULL, 0x080fe40003f26070ULL, 0x00000004ff517819ULL, 0x000fe20000011651ULL,
0x0000000213127825ULL, 0x100fe200078e0042ULL, 0x000000394c00720cULL, 0x000fe40003f06070ULL,
0x0000001073107217ULL, 0x000fe20003800000ULL, 0x0000000215147825ULL, 0x100fe200078e0042ULL,
0x000000ff51557207ULL, 0x000fe20000800000ULL, 0x00000006124a7981ULL, 0x0002e4000c1e9500ULL,
0x0000000217167825ULL, 0x000fe200078e0042ULL, 0x000000ff10517207ULL, 0x000fe20000000000ULL,
0x0000000614497981ULL, 0x0002e8000c1e9500ULL, 0x00000006164e7981ULL, 0x0002e2000c1e9500ULL,
0x0000000152117824ULL, 0x000fe200078e0255ULL, 0x0000005251137211ULL, 0x002fc600078fe0ffULL,
0x0000000211107825ULL, 0x000fc800078e0042ULL, 0x0000000213127825ULL, 0x000fe400078e0042ULL,
0x0000000610107981ULL, 0x0002e2000c1e9500ULL, 0x0000005451157211ULL, 0x000fc600078fe0ffULL,
0x0000000612137981ULL, 0x0002e2000c1e9500ULL, 0x0000000155177824ULL, 0x000fe400078e0254ULL,
0x0000000215147825ULL, 0x000fc800078e0042ULL, 0x0000000217167825ULL, 0x000fe400078e0042ULL,
0x0000000614147981ULL, 0x0002e8000c1e9500ULL, 0x0000000616177981ULL, 0x0002e2000c1e9500ULL,
0xfffffff04f547812ULL, 0x000fe200078ec0ffULL, 0x00000001ff4f7424ULL, 0x000fc800078e00ffULL,
0x0000000139117824ULL, 0x002fc800078e0254ULL, 0x000000013c5a7824ULL, 0x000fe200078e0a11ULL,
0x000000093a127812ULL, 0x000fc800078efcffULL, 0x0000005a4f5a7219ULL, 0x000fe200000006ffULL,
0x0000000112167824ULL, 0x000fe200078e0272ULL, 0xfffffff03f3f7812ULL, 0x000fc600078ec0ffULL,
0x0000000116607824ULL, 0x000fe200078e0a11ULL, 0x000000113a6a7812ULL, 0x040fe400078efcffULL,
0x000000013a527812ULL, 0x040fe400078efcffULL, 0x000000183a687812ULL, 0x040fe400078efcffULL,
0x000000604f607219ULL, 0x000fe200000006ffULL, 0x00000001393f7824ULL, 0x000fe200078e023fULL,
0x000000193a667812ULL, 0x000fe400078efcffULL, 0xfffffff04b4b7812ULL, 0x000fe200078ec0ffULL,
0x000000016a707824ULL, 0x000fc400078e0272ULL, 0x0000000152567824ULL, 0x100fe400078e0272ULL,
0x00000001686e7824ULL, 0x100fe400078e0272ULL, 0x00000001666c7824ULL, 0x000fe400078e0272ULL,
0x0000000139657824ULL, 0x000fe400078e024bULL, 0x000000013e157824ULL, 0x100fe400078e0a3fULL,
0x00000001704b7824ULL, 0x000fc400078e0a3fULL, 0x00000001565c7824ULL, 0x000fe400078e0a11ULL,
0x000000016e597824ULL, 0x100fe400078e0a3fULL, 0x000000016c697824ULL, 0x000fe200078e0a3fULL,
0x000000154f3f7219ULL, 0x040fe400000006ffULL, 0x0000004b4f157219ULL, 0x040fe400000006ffULL,
0x0000005c4f5c7219ULL, 0x040fe400000006ffULL, 0x000000594f4b7219ULL, 0x000fe200000006ffULL,
0x00000001445d7824ULL, 0x000fe200078e0a65ULL, 0x000000213a627812ULL, 0x000fc400078efcffULL,
0xfffffff051517812ULL, 0x000fe400078ec0ffULL, 0x000000694f597219ULL, 0x040fe400000006ffULL,
0x0000005d4f5d7219ULL, 0x000fe200000006ffULL, 0x0000000162647824ULL, 0x000fc800078e0272ULL,
0x00000001645f7824ULL, 0x000fca00078e0a65ULL, 0x0000005f4f5f7219ULL, 0x000fe400000006ffULL,
0x0000541053537816ULL, 0x004fe40000000050ULL, 0x000000083a507812ULL, 0x000fe400078efcffULL,
0x000000535aff7212ULL, 0x000fc6000780c0ffULL, 0x0000000150547824ULL, 0x000fe200078e0272ULL,
0x000000393c00720cULL, 0x000fc60000701470ULL, 0x00000001545e7824ULL, 0x000fe200078e0a11ULL,
0x000000393a00720cULL, 0x000fc800007a1070ULL, 0x0000005e4f5e7219ULL, 0x000fe400000006ffULL,
0xff8000001f1f7808ULL, 0x000fe40002800000ULL, 0x00005410584d7816ULL, 0x008fc8000000004dULL,
0x0000004d5aff7212ULL, 0x080fe4000784c0ffULL, 0x0000004d5eff7212ULL, 0x080fe400078cc0ffULL,
0x0000004d60ff7212ULL, 0x000fe400078ac0ffULL, 0x000000393c00720cULL, 0x080fe40001741470ULL,
0x000000395400720cULL, 0x080fe400037c1470ULL, 0x000000391600720cULL, 0x000fc40002fa1470ULL,
0x000000393a00720cULL, 0x080fe40001741070ULL, 0x000000395000720cULL, 0x080fe400037c1070ULL,
0x000000391200720cULL, 0x000fe40002fa1070ULL, 0xff80000026267808ULL, 0x000fe40001000000ULL,
0xff80000025257808ULL, 0x000fe40003000000ULL, 0xff80000029297808ULL, 0x000fc40002800000ULL,
0x0000541041407816ULL, 0x000fe40000000040ULL, 0x000000535cff7212ULL, 0x080fe4000782c0ffULL,
0x000000535eff7212ULL, 0x080fe4000786c0ffULL, 0x0000541048487816ULL, 0x000fe40000000045ULL,
0x0000005360ff7212ULL, 0x000fe4000788c0ffULL, 0x0000004d5cff7212ULL, 0x000fc4000780c0ffULL,
0x000000403fff7212ULL, 0x040fe4000784c0ffULL, 0x000000483fff7212ULL, 0x080fe400078cc0ffULL,
0x000000484bff7212ULL, 0x000fe400078ac0ffULL, 0x000000395600720cULL, 0x0c0fe40000f21470ULL,
0x000000395600720cULL, 0x080fe40000701470ULL, 0x000000395400720cULL, 0x000fc40001f61470ULL,
0x000000391600720cULL, 0x080fe40002781470ULL, 0x000000393e00720cULL, 0x0c0fe40001741470ULL,
0x000000393e00720cULL, 0x080fe400037c1470ULL, 0x000000396e00720cULL, 0x000fe40002fa1470ULL,
0x000000283a607812ULL, 0x040fe400078efcffULL, 0x000000293a5e7812ULL, 0x000fc400078efcffULL,
0x000000395200720cULL, 0x0c0fe40000f21070ULL, 0x000000395200720cULL, 0x080fe40000701070ULL,
0x000000395000720cULL, 0x080fe40001f61070ULL, 0x000000391200720cULL, 0x080fe40002781070ULL,
0x000000393b00720cULL, 0x0c0fe40001741070ULL, 0x000000393b00720cULL, 0x000fc400037c1070ULL,
0x000000396800720cULL, 0x000fe40002fa1070ULL, 0x000054104a4a7816ULL, 0x000fe40000000047ULL,
0x000054104e4e7816ULL, 0x000fe20000000049ULL, 0x0000000160117824ULL, 0x100fe200078e0272ULL,
0xff8000002c2c7808ULL, 0x000fe20000800000ULL, 0x000000015e577824ULL, 0x000fe200078e0272ULL,
0xff8000001e1e7808ULL, 0x000fe20000000000ULL, 0x00000001394d7824ULL, 0x000fe200078e0251ULL,
0xff8000002d2d7808ULL, 0x000fc40001800000ULL, 0xff80000023237808ULL, 0x000fe40002000000ULL,
0xff80000033337808ULL, 0x000fe40001000000ULL, 0xff80000028287808ULL, 0x000fe40003000000ULL,
0xff8000002a2a7808ULL, 0x000fe40002800000ULL, 0x0000004015ff7212ULL, 0x080fe4000782c0ffULL,
0x000000404bff7212ULL, 0x000fc4000780c0ffULL, 0x0000004059ff7212ULL, 0x000fe4000786c0ffULL,
0x0000004815ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004859ff7212ULL, 0x000fe4000784c0ffULL,
0x0000004a5dff7212ULL, 0x040fe400078cc0ffULL, 0x0000004e5dff7212ULL, 0x000fe200078ac0ffULL,
0x0000000111677824ULL, 0x100fe200078e0a65ULL, 0x000000397000720cULL, 0x0c0fe20000f21470ULL,
0x0000000157657824ULL, 0x000fe200078e0a65ULL, 0x000000397000720cULL, 0x080fe20002781470ULL,
0x000000014c637824ULL, 0x000fe200078e0a4dULL, 0x000000396e00720cULL, 0x000fc40000701470ULL,
0x000000396c00720cULL, 0x0c0fe40001f61470ULL, 0x000000396c00720cULL, 0x080fe40001741470ULL,
0x000000394400720cULL, 0x0c0fe400037c1470ULL, 0x000000394400720cULL, 0x000fe40002fa1470ULL,
0x000000313a5c7812ULL, 0x040fe400078efcffULL, 0x000000383a5a7812ULL, 0x000fc400078efcffULL,
0x000000393a587812ULL, 0x000fe400078efcffULL, 0x000000396a00720cULL, 0x0c0fe40000f21070ULL,
0x000000396a00720cULL, 0x080fe40002781070ULL, 0x000000396800720cULL, 0x080fe40000701070ULL,
0x000000396600720cULL, 0x0c0fe40001f61070ULL, 0x000000396600720cULL, 0x000fc40001741070ULL,
0x000000393d00720cULL, 0x0c0fe400037c1070ULL, 0x000000393d00720cULL, 0x000fe40002fa1070ULL,
0x000000674f677219ULL, 0x040fe400000006ffULL, 0x000000654f657219ULL, 0x040fe400000006ffULL,
0x000000634f637219ULL, 0x000fe400000006ffULL, 0x0000541013107816ULL, 0x000fe20000000010ULL,
0x000000015c557824ULL, 0x100fe200078e0272ULL, 0xff8000002e2e7808ULL, 0x000fe20000800000ULL,
0x000000015a537824ULL, 0x100fe200078e0272ULL, 0xff80000027277808ULL, 0x000fe20002000000ULL,
0x0000000158517824ULL, 0x000fe200078e0272ULL, 0xff8000002f2f7808ULL, 0x000fc40000000000ULL,
0xff80000038387808ULL, 0x000fe40001800000ULL, 0xff80000037377808ULL, 0x000fe40001000000ULL,
0xff80000036367808ULL, 0x000fe40003000000ULL, 0xff8000001d1d7808ULL, 0x000fe40002800000ULL,
0x0000004a5fff7212ULL, 0x080fe4000782c0ffULL, 0x0000004a67ff7212ULL, 0x000fc4000788c0ffULL,
0x0000004a65ff7212ULL, 0x000fe4000780c0ffULL, 0x0000004e5fff7212ULL, 0x080fe4000786c0ffULL,
0x0000004e67ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004e65ff7212ULL, 0x000fe400078cc0ffULL,
0x0000001063ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000155617824ULL, 0x100fe200078e0a4dULL,
0x000000396400720cULL, 0x0c0fe20000f21470ULL, 0x00000001535b7824ULL, 0x100fe200078e0a4dULL,
0x000000396400720cULL, 0x080fe20001f61470ULL, 0x00000001514d7824ULL, 0x000fe200078e0a4dULL,
0x000000391100720cULL, 0x000fc40002781470ULL, 0x000000391100720cULL, 0x080fe40001741470ULL,
0x000000395700720cULL, 0x0c0fe40000701470ULL, 0x000000395700720cULL, 0x080fe400037c1470ULL,
0x000000394c00720cULL, 0x080fe40002fa1470ULL, 0x000000396200720cULL, 0x0c0fe40000f21070ULL,
0x000000396200720cULL, 0x000fc40001f61070ULL, 0x000000396000720cULL, 0x0c0fe40002781070ULL,
0x000000396000720cULL, 0x080fe40001741070ULL, 0x000000395e00720cULL, 0x0c0fe40000701070ULL,
0x000000395e00720cULL, 0x080fe400037c1070ULL, 0x000000394600720cULL, 0x000fe40002fa1070ULL,
0x000000614f617219ULL, 0x000fc400000006ffULL, 0x0000005b4f5b7219ULL, 0x040fe400000006ffULL,
0x0000004d4f4d7219ULL, 0x000fe400000006ffULL, 0x0000541014147816ULL, 0x000fe40000000017ULL,
0xff80000030307808ULL, 0x000fe40000800000ULL, 0xff8000001c1c7808ULL, 0x000fe40001800000ULL,
0xff80000031317808ULL, 0x000fc40002000000ULL, 0xff80000021217808ULL, 0x000fe40001000000ULL,
0xff80000035357808ULL, 0x000fe40000000000ULL, 0xff80000022227808ULL, 0x000fe40003000000ULL,
0xff80000034347808ULL, 0x000fe40002800000ULL, 0x0000001061ff7212ULL, 0x080fe4000782c0ffULL,
0x000000105bff7212ULL, 0x000fc4000786c0ffULL, 0x000000104dff7212ULL, 0x000fe4000788c0ffULL,
0x0000001463ff7212ULL, 0x080fe4000784c0ffULL, 0x0000001461ff7212ULL, 0x080fe4000780c0ffULL,
0x000000145bff7212ULL, 0x080fe400078cc0ffULL, 0x000000144dff7212ULL, 0x000fe400078ac0ffULL,
0x000000394c00720cULL, 0x000fc40001741470ULL, 0x000000395500720cULL, 0x0c0fe40000f21470ULL,
0x000000395500720cULL, 0x080fe40000701470ULL, 0x000000395300720cULL, 0x0c0fe40001f61470ULL,
0x000000395300720cULL, 0x080fe400037c1470ULL, 0x000000395100720cULL, 0x0c0fe40002781470ULL,
0x000000395100720cULL, 0x000fc40002fa1470ULL, 0x000000394600720cULL, 0x080fe40001741070ULL,
0x000000395c00720cULL, 0x0c0fe40000f21070ULL, 0x000000395c00720cULL, 0x080fe40000701070ULL,
0x000000395a00720cULL, 0x0c0fe40001f61070ULL, 0x000000395a00720cULL, 0x080fe400037c1070ULL,
0x000000395800720cULL, 0x000fc40002781070ULL, 0x000000395800720cULL, 0x000fe40002fa1070ULL,
0xff80000032327808ULL, 0x000fe40000800000ULL, 0xff8000002b2b7808ULL, 0x000fe40001800000ULL,
0xff80000020207808ULL, 0x000fe40002000000ULL, 0xff80000018187808ULL, 0x000fe40001000000ULL,
0xff80000019197808ULL, 0x000fc40000000000ULL, 0xff8000001a1a7808ULL, 0x000fe40003000000ULL,
0xff8000001b1b7808ULL, 0x000fc40002800000ULL, 0x0000001f0c00720bULL, 0x004fe20003f1e000ULL,
0x0000001fff147424ULL, 0x000fe200078e00ffULL, 0x000000260d00720bULL, 0x000fe20003f3e000ULL,
0xffffffffff3b7424ULL, 0x000fe200078e00ffULL, 0x0000000c1f117208ULL, 0x000fe40004000000ULL,
0x0000000d260d7208ULL, 0x000fe40004800000ULL, 0x0000002c1100720bULL, 0x000fc40003f1e000ULL,
0x0000001e0d00720bULL, 0x000fe40003f3e000ULL, 0x000000112c0c7208ULL, 0x000fe40004000000ULL,
0x0000000d1e107208ULL, 0x000fe40004800000ULL, 0x0000002d0c00720bULL, 0x000fe40003f1e000ULL,
0x000000251000720bULL, 0x000fe40003f3e000ULL, 0x0000000c2d0c7208ULL, 0x000fc40004000000ULL,
0x0000001025107208ULL, 0x000fe40004800000ULL, 0x000000230c00720bULL, 0x000fe40003f1e000ULL,
0x000000291000720bULL, 0x000fe40003f3e000ULL, 0x0000000c230c7208ULL, 0x000fe40004000000ULL,
0x00000010290d7208ULL, 0x000fe40004800000ULL, 0x000000330c00720bULL, 0x000fc40003f1e000ULL,
0x000000280d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c33117208ULL, 0x000fe40004000000ULL,
0x0000000d280c7208ULL, 0x000fe40004800000ULL, 0x0000002e1100720bULL, 0x000fe40003f1e000ULL,
0x000000270c00720bULL, 0x000fe40003f3e000ULL, 0x000000112e107208ULL, 0x000fc40004000000ULL,
0x0000000c270d7208ULL, 0x000fe40004800000ULL, 0x0000002f1000720bULL, 0x000fe40003f1e000ULL,
0x0000002a0d00720bULL, 0x000fe40003f3e000ULL, 0x000000102f117208ULL, 0x000fe40004000000ULL,
0x0000000d2a0c7208ULL, 0x000fe40004800000ULL, 0x000000381100720bULL, 0x000fc40003f1e000ULL,
0x000000370c00720bULL, 0x000fe40003f3e000ULL, 0x0000001138117208ULL, 0x000fe40004000000ULL,
0x0000000c370c7208ULL, 0x000fe40004800000ULL, 0x000000361100720bULL, 0x000fe40003f1e000ULL,
0x0000001d0c00720bULL, 0x000fe40003f3e000ULL, 0x0000001136117208ULL, 0x000fc40004000000ULL,
0x0000000c1d0d7208ULL, 0x000fe40004800000ULL, 0x000000301100720bULL, 0x000fe40003f1e000ULL,
0x0000001c0d00720bULL, 0x000fe40003f3e000ULL, 0x00000011300c7208ULL, 0x000fe40004000000ULL,
0x0000000d1c107208ULL, 0x000fe40004800000ULL, 0x000000310c00720bULL, 0x000fc40003f1e000ULL,
0x000000211000720bULL, 0x000fe40003f3e000ULL, 0x0000000c310c7208ULL, 0x000fe40004000000ULL,
0x00000010210d7208ULL, 0x000fe40004800000ULL, 0x000000350c00720bULL, 0x000fe40003f1e000ULL,
0x000000220d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c35117208ULL, 0x000fc40004000000ULL,
0x0000000d220d7208ULL, 0x000fe40004800000ULL, 0x000000341100720bULL, 0x000fe40003f1e000ULL,
0x000000180d00720bULL, 0x000fe40003f3e000ULL, 0x0000001134117208ULL, 0x000fe40004000000ULL,
0x0000000d180c7208ULL, 0x000fe40004800000ULL, 0x000000321100720bULL, 0x000fc40003f1e000ULL,
0x000000190c00720bULL, 0x000fe40003f3e000ULL, 0x0000001132107208ULL, 0x000fe40004000000ULL,
0x0000000c190d7208ULL, 0x000fe40004800000ULL, 0x0000002b1000720bULL, 0x000fe40003f1e000ULL,
0x0000001a0d00720bULL, 0x000fe40003f3e000ULL, 0x000000102b117208ULL, 0x000fc40004000000ULL,
0x0000000d1a0c7208ULL, 0x000fe40004800000ULL, 0x000000201100720bULL, 0x000fe40003f1e000ULL,
0x0000001b0c00720bULL, 0x000fe40003f3e000ULL, 0x0000001120127208ULL, 0x000fe40004000000ULL,
0x0000000c1b157208ULL, 0x000fe20004800000ULL, 0x000014627f007947ULL, 0x000fec000b800000ULL,
0x0c401f00120c7f89ULL, 0x0004e400000e0000ULL, 0x0000000c1200720bULL, 0x008fc80003f1e000ULL,
0x000000120c177208ULL, 0x000fe20004000000ULL, 0x000014727f007947ULL, 0x000fea000b800000ULL,
0x0c401f00150c7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0d7f89ULL, 0x000e6800000e0000ULL,
0x0c401f000f127f89ULL, 0x006e6200000e0000ULL, 0x0000000c1500720bULL, 0x008fc40003f1e000ULL,
0x0000000d0e00720bULL, 0x000fe40003f3e000ULL, 0x000000150c107208ULL, 0x000fe40004000000ULL,
0x0000000e0d117208ULL, 0x000fe20004800000ULL, 0x0c201f00170c7f89ULL, 0x000ea200000e0000ULL,
0x000000120f00720bULL, 0x002fc60003f1e000ULL, 0x0c201f00100d7f89ULL, 0x000e6200000e0000ULL,
0x0000000f12397208ULL, 0x000fc60004000000ULL, 0x0c201f0011147f89ULL, 0x000ee800000e0000ULL,
0x0c201f00393a7f89ULL, 0x0002e200000e0000ULL, 0x0000000c1700720bULL, 0x004fe40003f1e000ULL,
0x0000000d1000720bULL, 0x002fe40003f3e000ULL, 0x000000170c0c7208ULL, 0x000fe40004000000ULL,
0x000000141100720bULL, 0x008fc40003f5e000ULL, 0x000000100d0d7208ULL, 0x000fe40004800000ULL,
0x00000011140e7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b0c0f7820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000c24247812ULL, 0x000fe400078ec0ffULL,
0x3fb8aa3b2f167823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b312f7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b0d317820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b2d2d7823ULL, 0x000fe2000001080fULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b25257823ULL, 0x000fe20000010831ULL,
0x3fb8aa3b23237823ULL, 0x000fe2000001080fULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b29297823ULL, 0x000fe20000010831ULL, 0x0000002c00117308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b33337823ULL, 0x000fe2000001080fULL, 0x3fb8aa3b27277823ULL, 0x000fe20000010831ULL,
0x3fb8aa3b2e157823ULL, 0x000fe2000001080fULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b37377823ULL, 0x000fe20000010831ULL,
0x3fb8aa3b38387823ULL, 0x100fe2000001080fULL, 0x0000001f00107308ULL, 0x000e620000000800ULL,
0x3fb8aa3b322c7823ULL, 0x108fe2000001080fULL, 0x3fb8aa3b302e7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b35307823ULL, 0x000fe2000001080fULL, 0x3fb8aa3b21217823ULL, 0x000fe20000010831ULL,
0x3fb8aa3b2b2b7823ULL, 0x000fe2000001080fULL, 0x0000000306ff7812ULL, 0x000fc4000780c0ffULL,
0x0000002d00127308ULL, 0x0023e20000000800ULL, 0x0000003a3900720bULL, 0x004fce0003f3e000ULL,
0x0000002300137308ULL, 0x0004e20000000800ULL, 0x000000101110723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b362d7823ULL, 0x002fcc000001080fULL, 0x00000026001f7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b34237823ULL, 0x104fe2000001080fULL, 0x00000002ff347819ULL, 0x000fe20000011606ULL,
0x3fb8aa3b200f7823ULL, 0x000fe2000001080fULL, 0x3fb8aa3b18207823ULL, 0x000fe40000010831ULL,
0x0000000134187810ULL, 0x040fe40007ffe0ffULL, 0x0000001e001e7308ULL, 0x000ea20000000800ULL,
0x00000004ff267e24ULL, 0x002fe2000f8e00ffULL, 0x000000121312723eULL, 0x008fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008343b7810ULL, 0x000fc40007ffe0ffULL,
0x3f8000002626783eULL, 0x000fe400000010ffULL, 0x0000002500257308ULL, 0x000fe60000000800ULL,
0x000000ffff367224ULL, 0x000fca00078e0026ULL, 0x0000002900327308ULL, 0x0002e20000000800ULL,
0x0000001f1e11723eULL, 0x004fce00000010ffULL, 0x0000003300147308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c297823ULL, 0x002fce0000010831ULL, 0x0000002700337308ULL, 0x0003e20000000800ULL,
0x000000253213723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b1d257823ULL, 0x000fcc0000010831ULL,
0x0000001500157308ULL, 0x000ea20000000800ULL, 0x000000ffff277224ULL, 0x002fce00078e0026ULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x00000026101c723cULL, 0x000b6e00000418ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b22277823ULL, 0x020fe20000010831ULL,
0x000000141514723eULL, 0x004fcc00000010ffULL, 0x0000003800177308ULL, 0x000ea20000000800ULL,
0x000000283315723eULL, 0x002fe200000010ffULL, 0x0000000834337824ULL, 0x000fca00078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee218ULL, 0x0000002a002a7308ULL, 0x000ff00000000800ULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x000000161716723eULL, 0x004fce00000010ffULL,
0x0000002700287308ULL, 0x0005e20000000800ULL, 0x0000002a3717723eULL, 0x002fe200000010ffULL,
0x000000ffff277224ULL, 0x004fcc00078e0026ULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1a2a7823ULL, 0x000fe20000010831ULL, 0x000000ffff377224ULL, 0x000fe200078e0026ULL,
0x00000026141c723cULL, 0x000f6a000004181cULL, 0x0000002e002e7308ULL, 0x000e700000000800ULL,
0x0000002f002f7308ULL, 0x000ff00000000800ULL, 0x0000003000307308ULL, 0x000ea20000000800ULL,
0x0000002d2e18723eULL, 0x002fe200000010ffULL, 0x00000008342e7824ULL, 0x000fcc00078e00ffULL,
0x0000002500257308ULL, 0x000ff00000000800ULL, 0x0000002900327308ULL, 0x0002e20000000800ULL,
0x0000002f301a723eULL, 0x004fe200000010ffULL, 0x0000000834307824ULL, 0x000fc400078e00ffULL,
0x00000008342f7824ULL, 0x000fc800078e00ffULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b19297823ULL, 0x102fe20000010831ULL, 0x3fb8aa3b1b317823ULL, 0x000fe20000010831ULL,
0x000000253219723eULL, 0x008fca00000010ffULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x000000083b327824ULL, 0x000fca00078e00ffULL, 0xfffffff8323b7812ULL, 0x000fe400078ee23bULL,
0x00000021281b723eULL, 0x004fe200000010ffULL, 0x0000002c002c7308ULL, 0x000e620000000800ULL,
0x0000000334217810ULL, 0x000fc80007ffe0ffULL, 0xfffffff8302d7812ULL, 0x000fe200078ee221ULL,
0x00000036181c723cULL, 0x020b62000004181cULL, 0x0000000634217810ULL, 0x000fe20007ffe0ffULL,
0x0000002000277308ULL, 0x0005e60000000800ULL, 0xfffffff830357812ULL, 0x000fe400078ee221ULL,
0x0000000834377824ULL, 0x020fc600078e00ffULL, 0x0000002900287308ULL, 0x0006620000000800ULL,
0x0000000434207810ULL, 0x004fce0007ffe0ffULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0xfffffff82f297812ULL, 0x008fe400078ee220ULL, 0x0000000534207810ULL, 0x000fc80007ffe0ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee220ULL, 0x0000000f00227308ULL, 0x0004e20000000800ULL,
0x000000232c20723eULL, 0x002fe400000010ffULL, 0x000000272821723eULL, 0x000fe200000010ffULL,
0x000000ffff277224ULL, 0x000fe200078e0026ULL, 0x00009000002c7811ULL, 0x000fc600078e58ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x00000002340f7810ULL, 0x004fe20007ffe0ffULL,
0x0000001033337824ULL, 0x100fe400078e022cULL, 0x000000102d2d7824ULL, 0x100fe200078e022cULL,
0xfffffff82e257812ULL, 0x000fe200078ee20fULL, 0x00000008340f7824ULL, 0x040fe200078e00ffULL,
0xffffffff342e7810ULL, 0x000fe20007ffe0ffULL, 0x0000003100317308ULL, 0x000e620000000800ULL,
0x0000002b2222723eULL, 0x008fe200000010ffULL, 0x0000001025257824ULL, 0x000fe200078e022cULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee234ULL, 0x0000001029297824ULL, 0x000fe200078e022cULL,
0xfffffff837377812ULL, 0x000fe200078ee22eULL, 0x000000102f2f7824ULL, 0x000fc400078e022cULL,
0x000000100f0f7824ULL, 0x000fe400078e022cULL, 0x0000000124337824ULL, 0x040fe400078e0233ULL,
0x000000010f0f7824ULL, 0x000fe400078e0224ULL, 0x0000001035357824ULL, 0x100fe200078e022cULL,
0x0000002a3123723eULL, 0x002fe200000010ffULL, 0x0000000124257824ULL, 0x000fe200078e0225ULL,
0x000000100f007388ULL, 0x0003e20000000800ULL, 0x0000001037377824ULL, 0x000fc400078e022cULL,
0x00000001242d7824ULL, 0x040fe200078e022dULL, 0x0000001233007388ULL, 0x0005e20000000800ULL,
0x00000026201c723cULL, 0x000f62000004181cULL, 0x000000103b3b7824ULL, 0x000fe400078e022cULL,
0x0000000124297824ULL, 0x040fe200078e0229ULL, 0x0000001425007388ULL, 0x0005e20000000800ULL,
0x00000001242f7824ULL, 0x000fe200078e022fULL, 0x000000393a0f7208ULL, 0x002fe20004800000ULL,
0x0000000124357824ULL, 0x040fe200078e0235ULL, 0x000000162d007388ULL, 0x0005e20000000800ULL,
0x0000000124377824ULL, 0x000fc400078e0237ULL, 0x0000000124247824ULL, 0x000fe200078e023bULL,
0x0000001829007388ULL, 0x0005e80000000800ULL, 0x0000001a2f007388ULL, 0x0005e80000000800ULL,
0x0000002035007388ULL, 0x0005e80000000800ULL, 0x0000002237007388ULL, 0x0005e20000000800ULL,
0x000000ffff1d7224ULL, 0x020fc600078e001eULL, 0x0000001124007388ULL, 0x0005e80000000800ULL,
0x0004001333007388ULL, 0x0005e80000000800ULL, 0x0004001525007388ULL, 0x0005e80000000800ULL,
0x000400172d007388ULL, 0x0005e80000000800ULL, 0x0004001929007388ULL, 0x0005e80000000800ULL,
0x0004001b2f007388ULL, 0x0005e80000000800ULL, 0x0004002135007388ULL, 0x0005e80000000800ULL,
0x0004002337007388ULL, 0x0005e80000000800ULL, 0x00f0000c0b008388ULL, 0x0005e80000000c00ULL,
0x00f2001c0b008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000007cff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008007cff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010007cff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000108087810ULL, 0x000fe20007ffe0ffULL, 0x000018007cff7f8cULL, 0x0003e6000c80043fULL,
0x000000710800720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffa61000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0d7807ULL, 0x008fe40004000000ULL, 0x000173f000127802ULL, 0x000fc40000000f00ULL,
0x00000bd000007944ULL, 0x014fea0003c00000ULL, 0xfffeb51000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40005000000ULL, 0x0001743000127802ULL, 0x000fc40000000f00ULL,
0x00000b9000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e000dULL,
0xfffeb57000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e002cULL,
0x0001748000137802ULL, 0x000fc40000000f00ULL, 0x00000af000007944ULL, 0x014fea0003c00000ULL,
0xfffeb65000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e002cULL,
0x000174c000137802ULL, 0x000fc40000000f00ULL, 0x00000ab000007944ULL, 0x016fea0003c00000ULL,
0xfffeb77000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000eULL,
0x0001751000137802ULL, 0x000fe20000000f00ULL, 0x000000ffff0d7224ULL, 0x000fc400078e000fULL,
0x00000a6000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e000dULL,
0xfffebb9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000eULL,
0x0001756000137802ULL, 0x000fc40000000f00ULL, 0x00000a1000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e000dULL, 0xfffebb7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x004fe40004000000ULL, 0x000175b000127802ULL, 0x000fc40000000f00ULL,
0x00000a1000007944ULL, 0x018fea0003c00000ULL, 0xfffeea8000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40005000000ULL, 0x000175f000127802ULL, 0x000fc40000000f00ULL,
0x000009d000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff367224ULL, 0x000fe200078e000dULL,
0xfffeeac000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0039ULL,
0x0001764000137802ULL, 0x000fc40000000f00ULL, 0x0000093000007944ULL, 0x018fea0003c00000ULL,
0xfffeebb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0039ULL,
0x0001768000137802ULL, 0x000fc40000000f00ULL, 0x000008f000007944ULL, 0x01afea0003c00000ULL,
0xfffeecd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0010ULL,
0x000176d000137802ULL, 0x000fe20000000f00ULL, 0x000000ffff0d7224ULL, 0x000fc400078e0011ULL,
0x000008a000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e000dULL,
0xfffef10000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0010ULL,
0x0001772000137802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e000dULL, 0xfffef0e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x008fe40004000000ULL, 0x0001777000127802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x014fea0003c00000ULL, 0xffff1db000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40005000000ULL, 0x000177b000127802ULL, 0x000fc40000000f00ULL,
0x0000081000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e000dULL,
0xffff1e0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0035ULL,
0x0001780000137802ULL, 0x000fc40000000f00ULL, 0x0000077000007944ULL, 0x014fea0003c00000ULL,
0xffff1ef000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0035ULL,
0x0001784000137802ULL, 0x000fc40000000f00ULL, 0x0000073000007944ULL, 0x016fea0003c00000ULL,
0xffff201000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000bULL,
0x0001789000137802ULL, 0x000fe20000000f00ULL, 0x000000ffff0d7224ULL, 0x000fc400078e000eULL,
0x000006e000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e000dULL,
0xffff244000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000bULL,
0x000178e000137802ULL, 0x000fc40000000f00ULL, 0x0000069000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e000dULL, 0xffff242000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x004fe40004000000ULL, 0x0001793000127802ULL, 0x000fc40000000f00ULL,
0x0000069000007944ULL, 0x018fea0003c00000ULL, 0xffff515000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40005000000ULL, 0x0001797000127802ULL, 0x000fc40000000f00ULL,
0x0000065000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e000dULL,
0xffff51a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0039ULL,
0x000179c000137802ULL, 0x000fc40000000f00ULL, 0x000005b000007944ULL, 0x018fea0003c00000ULL,
0xffff528000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0039ULL,
0x00017a0000137802ULL, 0x000fc40000000f00ULL, 0x0000057000007944ULL, 0x01afea0003c00000ULL,
0xffff53a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000aULL,
0x00017a5000137802ULL, 0x000fe20000000f00ULL, 0x000000ffff0d7224ULL, 0x000fc400078e000bULL,
0x0000052000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e000dULL,
0xffff57c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000aULL,
0x00017aa000137802ULL, 0x000fc40000000f00ULL, 0x000004d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e000dULL, 0xffff57a000007947ULL, 0x000fea000383ffffULL,
0x00000002ff137424ULL, 0x000fe200078e00ffULL, 0x00017af000107802ULL, 0x000fc40000000f00ULL,
0x0000044000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e003aULL,
0xffffeb6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x006fe200078e0015ULL,
0x00017b5000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff137424ULL, 0x000fc400078e00ffULL,
0x000003e000007944ULL, 0x010fea0003c00000ULL, 0x0000003a1500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e000eULL, 0x00017bb000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff137424ULL, 0x000fe200078e00ffULL, 0x000000153a0d7208ULL, 0x000fc80004000000ULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x0000003a0e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e000fULL, 0x00017c1000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff137424ULL, 0x000fe200078e00ffULL, 0x0000000e3a157208ULL, 0x000fc80004000000ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x0000003a0f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e0017ULL, 0x00017c7000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x0000000f3a397208ULL, 0x000fc80004000000ULL,
0x000002c000007944ULL, 0x000fea0003c00000ULL, 0x0000003a1700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e000dULL, 0x00017cd000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x000000173a0c7208ULL, 0x000fc80004000000ULL,
0x0000026000007944ULL, 0x000fea0003c00000ULL, 0x0000003a0d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e0015ULL, 0x00017d3000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x0000000d3a0d7208ULL, 0x000fc80004000000ULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x0000003a1500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e0039ULL, 0x00017d9000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x000000153a0e7208ULL, 0x000fc80004000000ULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0xffffea3000007947ULL, 0x000fea000383ffffULL,
0x018000000c027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000c00028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0cff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000c037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000c00027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0005ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe80d002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff117424ULL, 0x000fe200078e00ffULL,
0x0000003b00007348ULL, 0x000fe80003800000ULL, 0x0c000013123a7389ULL, 0x0002a200000e0014ULL,
0xfffe809010007950ULL, 0x000fea0003c3ffffULL, 0x0000006f00007348ULL, 0x000fe80003800000ULL,
0x0000000d120d7389ULL, 0x0002a400000e0070ULL, 0x000000ffff127224ULL, 0x002fc400078e0013ULL,
0x00000000ff137424ULL, 0x000fc800078e00ffULL, 0xfffe804012007950ULL, 0x000fea0003c3ffffULL,
0x000000010d00780cULL, 0x000fe20003f45070ULL, 0x00000000ff137424ULL, 0x000fe200078e00ffULL,
0x0000006e00007348ULL, 0x000ff60003800000ULL, 0x00000000000d7806ULL, 0x000fc800050e0100ULL,
0x0000006e0d0d7212ULL, 0x000fe200078ec0ffULL, 0xfffe7fe012007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x00000000000002f8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000cf0ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000db0ULL, 0x00000000000007ccULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001580ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001590ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001620ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001624ULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000018100ULL, 0x7f00001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019900ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019950ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000019cd0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001620ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000182e0ULL, 0x00000000000182e0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000019900ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000019cd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_89_cubin_len = 105904;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
