/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001bad0ULL, 0x000000000001b750ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x0000000000019b20ULL, 0x0000000000000190ULL, 0x000b0022000004daULL, 0x0000000000019cb0ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x0000000000019cf0ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x0000000000019d40ULL, 0x0000000000000140ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000019e80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00019b2000000000ULL, 0x0000040400000000ULL, 0x810c000000100400ULL, 0x0066ac0408288080ULL,
0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8e082880808c0828ULL,
0x2880809408288080ULL, 0x8097082880809508ULL, 0x08288080a9082880ULL, 0x8080ad08288080acULL,
0xbd08288080b00828ULL, 0x2880808508288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808085ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x00019b2000000000ULL,
0x0000019000000000ULL, 0x00005c0400000000ULL, 0x8082288080850900ULL, 0x0000000000002880ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080870828808081ULL, 0x8e082880808c0828ULL, 0x2880809408288080ULL,
0x8097082880809508ULL, 0x08288080a9082880ULL, 0x8080ad08288080acULL, 0xbd08288080b00828ULL,
0x2880808808288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808088ULL,
0x0000001cffffffffULL, 0x0000012800000000ULL, 0x00019cb000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080870828808081ULL, 0x8c08288080880828ULL,
0x2880808e08288080ULL, 0x8095082880809408ULL, 0x0828808097082880ULL, 0x8080ac08288080a9ULL,
0xb008288080ad0828ULL, 0x288080bd08288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x00002200288080bdULL, 0x0000002cffffffffULL, 0x000001d000000000ULL, 0x00019cf000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8094288080bd0900ULL, 0x0000000000002880ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080870828808081ULL, 0x8c08288080880828ULL, 0x2880808e08288080ULL,
0x8097082880809408ULL, 0x08288080a9082880ULL, 0x8080ad08288080acULL, 0xbd08288080b00828ULL,
0x2880809508288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808095ULL,
0x0000002cffffffffULL, 0x0000028800000000ULL, 0x00019d4000000000ULL, 0x0000014000000000ULL,
0x0000080400000000ULL, 0x8094288080950900ULL, 0x0000000000002880ULL, 0x0000001b00082f04ULL,
0x0008230400000080ULL, 0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL,
0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL,
0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL,
0x0000001b00081204ULL, 0x0008110400000008ULL, 0x000000080000001bULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0068016000000018ULL, 0x000c170400681903ULL, 0x0060000a00000000ULL,
0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL,
0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00801b030011f000ULL, 0x00000b9000043104ULL, 0xffffffff01342904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000003a001342804ULL, 0x000005b0000003d0ULL, 0x000029b000002920ULL,
0x00002c3000002ad0ULL, 0x000030e0000030b0ULL, 0x000031c000003150ULL, 0x000060f000006060ULL,
0x0000638000006220ULL, 0x0000684000006810ULL, 0x00006920000068b0ULL, 0x0000963000009590ULL,
0x000098c000009760ULL, 0x00009d8000009d50ULL, 0x00009e6000009df0ULL, 0x0000cbf00000cb50ULL,
0x0000ce700000cd10ULL, 0x0000d3200000d2f0ULL, 0x0000d4000000d390ULL, 0x0000f5200000f510ULL,
0x0001807000018030ULL, 0x0001809000018080ULL, 0x00018100000180a0ULL, 0x0001814000018120ULL,
0x00018e4000018df0ULL, 0x00018f1000018eb0ULL, 0x00018ff000018f80ULL, 0x000190a000019050ULL,
0x0001917000019110ULL, 0x00019250000191e0ULL, 0x00019300000192b0ULL, 0x000193d000019370ULL,
0x000194b000019440ULL, 0x0001956000019510ULL, 0x00019630000195d0ULL, 0x00019710000196a0ULL,
0x0001980000019780ULL, 0x0001990000019880ULL, 0x00019a0000019980ULL, 0x00019b0000019a80ULL,
0x0000044004403904ULL, 0x00017600000000ffULL, 0x00000480003f0100ULL, 0x0001760800000011ULL,
0x00000510003f0120ULL, 0x0001768800000011ULL, 0x00000530003f0120ULL, 0x000176a800000011ULL,
0x00000540003f0120ULL, 0x000176c800000011ULL, 0x00000bf0003f0120ULL, 0x00017600000000ffULL,
0x00000da0003f0107ULL, 0x0000000400000002ULL, 0x00000e50003f0102ULL, 0x0000000000000002ULL,
0x00001690003f0101ULL, 0x000176a800000005ULL, 0x000017e0003f0107ULL, 0x000176a800000005ULL,
0x00001840003f0101ULL, 0x000176c800000007ULL, 0x000019e0003f0101ULL, 0x000176cc00000012ULL,
0x00001bd0003f0105ULL, 0x000176cc00000012ULL, 0x00002520003f0105ULL, 0x000176b000000012ULL,
0x000025d0003f0107ULL, 0x000176b000000012ULL, 0x00002630003f0101ULL, 0x0001760800000007ULL,
0x00002650003f0101ULL, 0x0001760c00000007ULL, 0x00002820003f0105ULL, 0x0001760c00000007ULL,
0x00002e10003f0105ULL, 0x000176ac00000034ULL, 0x00002fe0003f0105ULL, 0x000176ac00000034ULL,
0x000051d0003f0105ULL, 0x0000000000000014ULL, 0x00005230003f0101ULL, 0x000176880000006eULL,
0x00005260003f0101ULL, 0x0000000400000006ULL, 0x00005420003f0105ULL, 0x0000000400000006ULL,
0x00005c70003f0105ULL, 0x000176a800000016ULL, 0x00005d40003f0107ULL, 0x000176a800000016ULL,
0x00005da0003f0101ULL, 0x0001762800000007ULL, 0x00005dc0003f0101ULL, 0x0001762c00000007ULL,
0x00005f90003f0105ULL, 0x0001762c00000007ULL, 0x00006570003f0105ULL, 0x000176b40000003cULL,
0x00006740003f0105ULL, 0x000176b40000003cULL, 0x00008700003f0105ULL, 0x0000000000000012ULL,
0x00008760003f0101ULL, 0x0001769000000014ULL, 0x00008790003f0101ULL, 0x0000000400000006ULL,
0x00008950003f0105ULL, 0x0000000400000006ULL, 0x000091a0003f0105ULL, 0x000176b000000014ULL,
0x00009270003f0107ULL, 0x000176b000000014ULL, 0x000092d0003f0101ULL, 0x0001764800000007ULL,
0x000092f0003f0101ULL, 0x0001764c00000007ULL, 0x000094c0003f0105ULL, 0x0001764c00000007ULL,
0x00009ab0003f0105ULL, 0x000176ac0000003cULL, 0x00009c80003f0105ULL, 0x000176ac0000003cULL,
0x0000bc40003f0105ULL, 0x0000000000000010ULL, 0x0000bca0003f0101ULL, 0x000176980000000cULL,
0x0000bcd0003f0101ULL, 0x0000000400000006ULL, 0x0000be90003f0105ULL, 0x0000000400000006ULL,
0x0000c7b0003f0105ULL, 0x000176a80000000bULL, 0x0000c840003f0107ULL, 0x000176a80000000bULL,
0x0000c8a0003f0101ULL, 0x0001766800000004ULL, 0x0000c8d0003f0101ULL, 0x0001766c00000004ULL,
0x0000caa0003f0105ULL, 0x0001766c00000004ULL, 0x0000d050003f0105ULL, 0x000176b400000017ULL,
0x0000d220003f0105ULL, 0x000176b400000017ULL, 0x0000f2e0003f0105ULL, 0x0000000000000006ULL,
0x0000f360003f0101ULL, 0x0000000000000010ULL, 0x00010750003f0101ULL, 0x00017600000000ffULL,
0x00012070003f0101ULL, 0x00017604000000ffULL, 0x00012280003f0105ULL, 0x00017604000000ffULL,
0x000124b0003f0105ULL, 0x00017600000000ffULL, 0x000124e0003f0101ULL, 0x00017604000000ffULL,
0x000126a0003f0105ULL, 0x00017604000000ffULL, 0x00016400003f0105ULL, 0x0000000000000077ULL,
0x000164b0003f0101ULL, 0x0000000400000077ULL, 0x00016680003f0105ULL, 0x0000000400000077ULL,
0x00018c30003f0105ULL, 0x000000000000007bULL, 0x00018c90003f0101ULL, 0x000000080000007bULL,
0x00018cf0003f0101ULL, 0x000000100000007bULL, 0x00018d60003f0101ULL, 0x000000180000007bULL,
0x00053803003f0101ULL, 0x0000fdf000201c04ULL, 0x000100d00000fe20ULL, 0x000104c0000102c0ULL,
0x0001270000010670ULL, 0x0000040100018db0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000031cULL,
0x0000001b00000002ULL, 0x0000000000000264ULL, 0x0000001b00000002ULL, 0x00000000000001bcULL,
0x0000001b00000002ULL, 0x0000000000000104ULL, 0x0000001b00000002ULL, 0x0000000000000044ULL,
0x0000001b00000002ULL, 0x00000000000002f7ULL, 0x0000001b00000002ULL, 0x000000000000023fULL,
0x0000001b00000002ULL, 0x0000000000000197ULL, 0x0000001b00000002ULL, 0x00000000000000dfULL,
0x0000001b00000002ULL, 0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fe20000000a00ULL,
0xfffffff801017810ULL, 0x000fe40007ffe0ffULL, 0x00005d00ff007a0cULL, 0x000fda0003f05300ULL,
0x00000004ff090424ULL, 0x000fe200078e00ffULL, 0x0000000104020810ULL, 0x002fca0007ffe0ffULL,
0x00005c0002020625ULL, 0x000fc800078e0009ULL, 0x00005c0004080625ULL, 0x000fe400078e0009ULL,
0x0000000602030981ULL, 0x0002a8000c1e1900ULL, 0x0000000608080981ULL, 0x0006a2000c1e1900ULL,
0x0000590000007b06ULL, 0x000f220000209000ULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x00005a00ff137624ULL, 0x000fe200078e00ffULL, 0x00000000007a7919ULL, 0x000ee20000002600ULL,
0x00005900ff027624ULL, 0x002fc600078e00ffULL, 0x0000000000107919ULL, 0x000e620000002300ULL,
0x0000590013137a24ULL, 0x000fc600078e02ffULL, 0x00000000000b7919ULL, 0x000e620000002200ULL,
0x0000000000007308ULL, 0x010f240000001000ULL, 0x0ffffffe00067810ULL, 0x010fcc0007ffe0ffULL,
0x0000000600077305ULL, 0x000864000021f000ULL, 0x000000ffff067224ULL, 0x010fe400078e00ffULL,
0x000000ffff057224ULL, 0x002fc800078e0a07ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000507077227ULL, 0x000fcc00078e0006ULL, 0x0000040007057a27ULL, 0x000fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a05ULL, 0x0000040007007624ULL, 0x000fca00078e0202ULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x8000590000001a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f46070ULL,
0x0000000105052810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff05ba12ULL, 0x000fc800078e33ffULL,
0x0000000500007306ULL, 0x000e620000209000ULL, 0x000000ff0500720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00067810ULL, 0x002fcc0007ffe0ffULL,
0x0000000600077305ULL, 0x0002e4000021f000ULL, 0x000000ffff067224ULL, 0x002fe400078e00ffULL,
0x0000000705097224ULL, 0x008fc800078e02ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a09ULL,
0x0000000907077227ULL, 0x000fe400078e0006ULL, 0x0000000000097919ULL, 0x000e640000002100ULL,
0x0000010010067a24ULL, 0x000fe400078e020bULL, 0x0000007a077c7227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a7cULL, 0x0000000005007224ULL, 0x000fca00078e027aULL,
0x000000050000720cULL, 0x000fe20003fa6070ULL, 0x0000000006117a24ULL, 0x002fca00078e0209ULL,
0x000000ff1100720cULL, 0x000fce0003f65270ULL, 0x0000000100005824ULL, 0x000fe200078e0a05ULL,
0x000000017c7c5810ULL, 0x000fe40007ffe0ffULL, 0x0000000f1100780cULL, 0x040fe40003f24070ULL,
0x000000050000720cULL, 0x000fe40003fc6070ULL, 0x00000005ff007819ULL, 0x000fe40000011609ULL,
0x00001fff10097589ULL, 0x000fe200000e0000ULL, 0x000000031100780cULL, 0x000fe20003fa4070ULL,
0x3fffff80ff06b424ULL, 0x000fc400078e00ffULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0x7fffff80ff07b424ULL, 0x000fe200078e00ffULL, 0x0000007f1100780cULL, 0x040fe20003f44070ULL,
0x3fffffc0ff0a9424ULL, 0x000fe400078e00ffULL, 0x000000017c7c6810ULL, 0x000fe20007ffe0ffULL,
0x7fffffc0ff0b9424ULL, 0x000fe200078e00ffULL, 0x00000005ff7cc212ULL, 0x000fe200078e33ffULL,
0x01760006ff00b388ULL, 0x0007e20000000a00ULL, 0x000000011100780cULL, 0x000fe20003f64070ULL,
0x7fffff80ff0dd424ULL, 0x000fc400078e00ffULL, 0x000000ffff0c7224ULL, 0x000fe200078e0a7cULL,
0x0176080a11009388ULL, 0x000fe40000008a00ULL, 0xff317217ff12a424ULL, 0x000fe400078e00ffULL,
0x0000000c057a7224ULL, 0x000fe400078e027aULL, 0x3fffff60ff06d424ULL, 0x008fe200078e00ffULL,
0x017400121100a388ULL, 0x000fe20000004800ULL, 0x000000107a7a7824ULL, 0x000fe400078e00ffULL,
0x7fffff60ff07d424ULL, 0x000fc400078e00ffULL, 0x3fffff80ff0cd424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0eb424ULL, 0x000fe200078e00ffULL, 0x017688061100d388ULL, 0x000fe20000008a00ULL,
0x7fffffc0ff0fb424ULL, 0x000fc600078e00ffULL, 0x0176a80c1100d388ULL, 0x000fe80000008a00ULL,
0x0176c80e1100b388ULL, 0x000fe20000008a00ULL, 0x0000000103670824ULL, 0x004fe400078e0a08ULL,
0x00005800ff678624ULL, 0x000fe400078e00ffULL, 0x0000580004088a24ULL, 0x000fe400078e02ffULL,
0x00005a0067037a24ULL, 0x000fc400078e02ffULL, 0x0000001308147224ULL, 0x000fe400078e02ffULL,
0x0000000103057824ULL, 0x040fe200078e0a7aULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000007a0300720cULL, 0x000fe20003f26070ULL, 0x0000001401007387ULL, 0x0005e20000100800ULL,
0x0000001005057817ULL, 0x000fe20003800000ULL, 0x0000000409037824ULL, 0x002fc400078e0200ULL,
0x00005a007c127a24ULL, 0x000fe200078e0214ULL, 0x000000ff057d7207ULL, 0x000fe20000800000ULL,
0x00000002030a7824ULL, 0x000fc600078e00ffULL, 0x000000107d00780cULL, 0x000fda0003f05270ULL,
0x000002c000008947ULL, 0x000fea0003800000ULL, 0x00005a0000057b06ULL, 0x004e620000209000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x00005a00ff007a0cULL, 0x000fcc0003f45070ULL,
0x0000000500057308ULL, 0x002e620000001000ULL, 0x00000004ff0b7819ULL, 0x004fca0000011603ULL,
0x000000010a0c7824ULL, 0x000fe200078e020bULL, 0x0ffffffe05067810ULL, 0x002fc60007ffe0ffULL,
0x000000017a057824ULL, 0x000fe200078e020cULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x004fc800078e0a07ULL,
0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL, 0x0000000d070e7227ULL, 0x000fe200078e0006ULL,
0x0000000a7d077217ULL, 0x000fca0007800000ULL, 0x000000050e0e7227ULL, 0x000fc800078e00ffULL,
0x000000ffff107224ULL, 0x000fe400078e0a0eULL, 0x00000001070a7824ULL, 0x000fe400078e0a0aULL,
0x00005a0010067a24ULL, 0x000fca00078e0205ULL, 0x00005a0006007a0cULL, 0x000fda0003f06070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x000000010e0e0810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x0000000a0b00720cULL, 0x000fe20003f06070ULL,
0x000000010c0a7824ULL, 0x040fe400078e0203ULL, 0x000000100c0b7824ULL, 0x000fca00078e00ffULL,
0xfffffff00b0a7812ULL, 0x000fc600078ee20aULL, 0x000000010e0e1810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff0eaa12ULL, 0x000fe200078e33ffULL, 0x000000100a0b7824ULL, 0x000fc800078e00ffULL,
0x000000ffff067224ULL, 0x000fc800078e0a0eULL, 0x00005a0006057a24ULL, 0x000fc800078e0205ULL,
0x0000000112057824ULL, 0x000fc800078e0205ULL, 0x000000130e067224ULL, 0x000fe400078e0205ULL,
0x0000001003057824ULL, 0x000fe400078e00ffULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0x000000f0050d7812ULL, 0x000fc800078ec0ffULL, 0x0000000d060d7212ULL, 0x000fc800078efcffULL,
0x000060000d067a10ULL, 0x000fc80007f3e0ffULL, 0x0000610007077a10ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e2000c101c46ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00005a00000b7b06ULL, 0x004e620000209000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000b000b7308ULL, 0x002e620000001000ULL,
0x0000000a030a7211ULL, 0x004fe400078fe0ffULL, 0x0ffffffe0b077810ULL, 0x002fc60007ffe0ffULL,
0x000000010a0b7824ULL, 0x000fc600078e0203ULL, 0x0000000700077305ULL, 0x000e64000021f000ULL,
0x000000ffff057224ULL, 0x002fc800078e0a07ULL, 0x00005a0005057a24ULL, 0x000fc800078e02ffULL,
0x0000000507067227ULL, 0x000fc800078e0006ULL, 0x000000017a057824ULL, 0x000fe400078e020aULL,
0x000000100a0a7824ULL, 0x000fe400078e00ffULL, 0x0000000506067227ULL, 0x000fc600078e00ffULL,
0xfffffff00a0b7812ULL, 0x000fe200078ee20bULL, 0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL,
0x00005a000c077a24ULL, 0x000fe400078e0205ULL, 0x000000100b0b7824ULL, 0x000fc600078e00ffULL,
0x00005a0007007a0cULL, 0x000fda0003f06070ULL, 0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106060810ULL, 0x000fe40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fda0003f26070ULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff06aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x00005a000c057a24ULL, 0x000fc800078e0205ULL,
0x0000000112057824ULL, 0x000fc800078e0205ULL, 0x0000001306067224ULL, 0x000fe400078e0205ULL,
0x0000001003057824ULL, 0x000fe400078e00ffULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0x000000f0050d7812ULL, 0x000fc800078ec0ffULL, 0x0000000d06067212ULL, 0x000fc800078efcffULL,
0x0000600006067a10ULL, 0x000fc80007f1e0ffULL, 0x0000610007077a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e8000b901c46ULL,
0x00000000000a7919ULL, 0x000ea20000000000ULL, 0x0000000000067806ULL, 0x002fe200038e0000ULL,
0x00000004ff477424ULL, 0x000fc600078e00ffULL, 0x0000000600077300ULL, 0x000ea200000e0000ULL,
0x0000680004707625ULL, 0x000fce00078e0047ULL, 0x00000006000b7309ULL, 0x000e620000000000ULL,
0x0000000a0700720cULL, 0x004fe40003f02070ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff077224ULL, 0x002fd400078e0a0bULL, 0x01760407ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01760000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000670707981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fe40003f05270ULL,
0x0000003f70767810ULL, 0x044fe40007ffe0ffULL, 0x000000ff700e7810ULL, 0x000fc40007ffe0ffULL,
0x00000006ff767819ULL, 0x000fe40000011676ULL, 0x00000008ff787819ULL, 0x000fca000001160eULL,
0x0000f99000008947ULL, 0x000fea0003800000ULL, 0x00000002ff7b7819ULL, 0x000fe20000011600ULL,
0x00000003ff0b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff067424ULL, 0x000fe200078e00ffULL,
0x03ffffff7b077812ULL, 0x002fc800078ec0ffULL, 0x000000760700720cULL, 0x000fda0003f06070ULL,
0x0000000204028824ULL, 0x000fe400078e00ffULL, 0x00006a00ff098624ULL, 0x000fc800078e00ffULL,
0x00006a0002088624ULL, 0x000fe200078e0209ULL, 0x0001768800027811ULL, 0x000fc600078e18ffULL,
0x0000000107088824ULL, 0x000fe200078e0208ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040b02ff738cULL, 0x0003e20000000000ULL, 0x0000660008088625ULL, 0x000fe200078e0047ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000608068981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0e00780cULL, 0x000fe20003f04070ULL, 0x000000407c777824ULL, 0x000fe200078e00ffULL,
0x00000001ff737819ULL, 0x000fe20000011600ULL, 0x0000000002ff7f8cULL, 0x0007e8000c80043fULL,
0x00000020730c7824ULL, 0x000fca00078e00ffULL, 0x00000020770a7812ULL, 0x000fe200078ef80cULL,
0x00005900060b7a24ULL, 0x006fe200078e02ffULL, 0x0000000100067812ULL, 0x000fc600078ec0ffULL,
0x000000400b177824ULL, 0x000fe200078e00ffULL, 0x0000040000000947ULL, 0x000fea0003800000ULL,
0x0000000c70027217ULL, 0x008fe20007800000ULL, 0x0000001006097824ULL, 0x000fe200078e00ffULL,
0x00000003ff087819ULL, 0x100fe40000011603ULL, 0x0000640017137a11ULL, 0x000fe200078838ffULL,
0x0000000102027824ULL, 0x000fe200078e0a0cULL, 0x00000004080d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001090b7824ULL, 0x000fe200078e0208ULL, 0x0000000c080e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000902027217ULL, 0x000fe20007800000ULL, 0x000000010b0c7824ULL, 0x000fe200078e0203ULL,
0x0000650017177a11ULL, 0x000fe200020f3cffULL, 0x000000080b0f7824ULL, 0x000fc400078e00ffULL,
0x0000000102027824ULL, 0x000fc600078e0a09ULL, 0xfffffff80f107812ULL, 0x000fe200078ee20cULL,
0x00000001090f7824ULL, 0x000fe200078e020eULL, 0x00000008080c7810ULL, 0x000fe40007ffe0ffULL,
0x000000020d00720cULL, 0x080fe20003f46070ULL, 0x00000001090d7824ULL, 0x040fe200078e020dULL,
0x000000020c00720cULL, 0x080fe20003f26070ULL, 0x00000001090c7824ULL, 0x000fe200078e020cULL,
0x000000020800720cULL, 0x080fe20003f66070ULL, 0x000000010d097824ULL, 0x040fe200078e0203ULL,
0x000000020e00720cULL, 0x000fe20003f06070ULL, 0x000000080d127824ULL, 0x000fc400078e00ffULL,
0x000000010a087824ULL, 0x000fe400078e020bULL, 0x000000010c0b7824ULL, 0x000fe200078e0203ULL,
0xfffffff812027812ULL, 0x000fe200078ee209ULL, 0x000000080c147824ULL, 0x000fe400078e00ffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff814127812ULL, 0x000fe200078ee20bULL,
0x000000010a0b7824ULL, 0x000fe200078e020dULL, 0x0000007008087812ULL, 0x000fe200078ef805ULL,
0x000000010a0c7824ULL, 0x040fe400078e020cULL, 0x000000010a0e7824ULL, 0x000fe200078e020fULL,
0x0000000813087210ULL, 0x000fe20007f9e0ffULL, 0x000000800b0a7825ULL, 0x000fc800078e00ffULL,
0x000000010f117824ULL, 0x040fe200078e0203ULL, 0x000000700a0a7812ULL, 0x000fe200078ef805ULL,
0x000000080f147824ULL, 0x000fe400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee211ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fc600078ef805ULL, 0x0000000109097824ULL, 0x000fe200020e0617ULL,
0x000000700e0e7812ULL, 0x000fe400078ef805ULL, 0x0001300073057811ULL, 0x000fe400078e68ffULL,
0x000000130a0a7210ULL, 0x080fe40007f9e0ffULL, 0x000000130c0c7210ULL, 0x080fe20007fbe0ffULL,
0x0000001010117824ULL, 0x100fe200078e0205ULL, 0x000000130e0e7210ULL, 0x000fe20007fde0ffULL,
0x0000001002137824ULL, 0x000fc400078e0205ULL, 0x000000010b0b7824ULL, 0x000fe200020e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e2000d901c46ULL,
0x0000001012157824ULL, 0x000fe400078e0205ULL, 0x000000010d0d7824ULL, 0x000fe200028e0617ULL,
0x000000000a137faeULL, 0x0003e2000d101c46ULL, 0x0000001014057824ULL, 0x000fe400078e0205ULL,
0x000000010f0f7824ULL, 0x000fe200030e0617ULL, 0x000000000c157faeULL, 0x0003e8000c901c46ULL,
0x000000000e057faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001006027824ULL, 0x008fe200078e00ffULL, 0x0000640017157a11ULL, 0x000fc400078038ffULL,
0x0001300073197811ULL, 0x000fe400078e68ffULL, 0x0000000203027211ULL, 0x000fe400078fe8ffULL,
0x0000650017177a11ULL, 0x000fe400000f3cffULL, 0x00000004020b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000102087824ULL, 0x040fe200078e0203ULL, 0x00000008020c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000802097824ULL, 0x000fe400078e00ffULL, 0x000000080b0e7824ULL, 0x000fc400078e00ffULL,
0x000000010c0d7824ULL, 0x100fe200078e0203ULL, 0xfffffff809107812ULL, 0x000fe200078ee208ULL,
0x000000010b097824ULL, 0x000fe400078e0203ULL, 0x000000010a087824ULL, 0x000fe200078e0202ULL,
0x0000000c02027810ULL, 0x000fe20007ffe0ffULL, 0x000000080c127824ULL, 0x000fe200078e00ffULL,
0xfffffff80e117812ULL, 0x000fe200078ee209ULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee20dULL, 0x000000010a0b7824ULL, 0x000fe200078e020bULL,
0x0000007008087812ULL, 0x000fe200078ef805ULL, 0x000000010a0c7824ULL, 0x040fe400078e020cULL,
0x000000010a0e7824ULL, 0x000fe200078e0202ULL, 0x0000000815087210ULL, 0x000fe20007f1e0ffULL,
0x000000800b0a7825ULL, 0x000fc800078e00ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a0a7812ULL, 0x000fc600078ef805ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fc600078ef805ULL, 0x0000000102137824ULL, 0x000fe200078e0203ULL,
0x000000700e057812ULL, 0x000fe200078ef805ULL, 0x0000000802027824ULL, 0x000fe200078e00ffULL,
0x0000000c150c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000109097824ULL, 0x000fe200000e0617ULL,
0x0000000a150a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001011117824ULL, 0x000fe200078e0219ULL,
0xfffffff802027812ULL, 0x000fe200078ee213ULL, 0x0000001012137824ULL, 0x100fe200078e0219ULL,
0x00000005150e7210ULL, 0x000fe20007f5e0ffULL, 0x0000001010057824ULL, 0x000fc400078e0219ULL,
0x000000010b0b7824ULL, 0x100fe400000e0617ULL, 0x000000010d0d7824ULL, 0x000fe200008e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e2000b901c46ULL,
0x0000001002157824ULL, 0x000fe400078e0219ULL, 0x000000010f0f7824ULL, 0x000fe200010e0617ULL,
0x000000000a117faeULL, 0x0003e8000b901c46ULL, 0x000000000c137faeULL, 0x0003e8000b901c46ULL,
0x000000000e157faeULL, 0x0003e4000b901c46ULL, 0x0000000107027810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0f7424ULL, 0x002fc600078e00ffULL, 0x000000760200720cULL, 0x000fda0003f06070ULL,
0x0000000204058824ULL, 0x000fe400078e00ffULL, 0x00006a00ff088624ULL, 0x000fc800078e00ffULL,
0x00006a0005058624ULL, 0x000fc800078e0208ULL, 0x0000000105088824ULL, 0x000fe400078e0202ULL,
0x0000001073057824ULL, 0x040fe400078e00ffULL, 0x0000660008088625ULL, 0x000fe400078e0047ULL,
0x00000000050473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000006080f8981ULL, 0x000522000c1e1900ULL, 0x000000ff7800720cULL, 0x000fe20003f05270ULL,
0x0000000873077824ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x000176a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0176a800050a7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176c80007087f8cULL, 0x000662000c80043fULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000dab000008947ULL, 0x000fea0003800000ULL, 0x0000001005087812ULL, 0x00afe200078ec0ffULL,
0x0000000204797824ULL, 0x000fc400078e00ffULL, 0x00006a00ff047624ULL, 0x000fe400078e00ffULL,
0x000000207b057824ULL, 0x000fe400078e0208ULL, 0x00006a0079797624ULL, 0x000fe400078e0204ULL,
0x0000000806047824ULL, 0x000fe400078e0205ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0xff317217ff0c7424ULL, 0x000fc400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x000fc400078e00ffULL, 0x000000ffff727224ULL, 0x004fca00078e0002ULL,
0x0000000000107805ULL, 0x000fc40000015200ULL, 0x0000000400067824ULL, 0x000fca00078e00ffULL,
0xfffffff806127812ULL, 0x000fc800078ec0ffULL, 0x000176c812137810ULL, 0x000fe20007ffe0ffULL,
0x0176cc0012077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe4000780480eULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x0000022000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe400078e00ffULL, 0x000000ffff067224ULL, 0x000fe200078e0013ULL,
0x000001e000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000610157210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000001506067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0176cc0012077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780480eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x000fc400078e0013ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000077824ULL, 0x000fe200078e00ffULL, 0x0000000105117810ULL, 0x000fe20007ffe0ffULL,
0x000059000f0f7a24ULL, 0x010fc600078e02ffULL, 0xffffffe0070e7812ULL, 0x000fe200078ec0ffULL,
0x000000400f3d7824ULL, 0x000fe200078e00ffULL, 0x000000781100720cULL, 0x000fc60003f26070ULL,
0x00000100050e7824ULL, 0x000fca00078e020eULL, 0x000000400e107810ULL, 0x000fc80007ffe0ffULL,
0x00000020100e7812ULL, 0x000fca00078ec0ffULL, 0x0000000177157824ULL, 0x000fe200078e020eULL,
0x0000042000009947ULL, 0x000fea0003800000ULL, 0x00000010070e7812ULL, 0x000fe400078ec0ffULL,
0x0000001070077217ULL, 0x000fe40007800000ULL, 0x00000003ff117819ULL, 0x000fe40000011603ULL,
0x000064003d177a11ULL, 0x000fe200078a38ffULL, 0x0000000107077824ULL, 0x000fe200078e0a10ULL,
0x0000000811367810ULL, 0x040fe20007ffe0ffULL, 0x0000000111107824ULL, 0x040fe200078e020eULL,
0x0000000411127810ULL, 0x000fc40007ffe0ffULL, 0x0000000e07077217ULL, 0x000fe20007800000ULL,
0x00000001100f7824ULL, 0x040fe200078e0203ULL, 0x000065003d3d7a11ULL, 0x000fe200028f3cffULL,
0x0000000810167824ULL, 0x000fe400078e00ffULL, 0x0000000107077824ULL, 0x000fc600078e0a0eULL,
0xfffffff816167812ULL, 0x000fe400078ee20fULL, 0x000000071100720cULL, 0x0c0fe40003f86070ULL,
0x000000073600720cULL, 0x0c0fe20003f46070ULL, 0x0000000136367824ULL, 0x000fe200078e020eULL,
0x0000000c11117810ULL, 0x000fe40007ffe0ffULL, 0x000000071200720cULL, 0x080fe20003f66070ULL,
0x00000001360f7824ULL, 0x040fe200078e0203ULL, 0x000000071100720cULL, 0x000fe20003f06070ULL,
0x00000008363c7824ULL, 0x000fc400078e00ffULL, 0x0000000112127824ULL, 0x100fe400078e020eULL,
0x00000001113e7824ULL, 0x000fe200078e020eULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee20fULL,
0x0000001003117824ULL, 0x000fe400078e00ffULL, 0x00000001150e7824ULL, 0x040fe400078e0210ULL,
0x0000000115147824ULL, 0x000fe200078e0212ULL, 0x0000007011357812ULL, 0x000fe200078ec0ffULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000000112077824ULL, 0x000fe200078e0203ULL,
0x000000350e0e7212ULL, 0x000fe200078efcffULL, 0x0000000812347824ULL, 0x000fe400078e00ffULL,
0x0000000115107824ULL, 0x000fe200078e0236ULL, 0x0000000e170e7210ULL, 0x000fe20007fbe0ffULL,
0x0000000115127824ULL, 0x000fe200078e023eULL, 0xfffffff834347812ULL, 0x000fe200078ee207ULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000003514147212ULL, 0x000fc600078efcffULL, 0x000000013e077824ULL, 0x000fe200078e0203ULL,
0x0000003510107212ULL, 0x000fe200078efcffULL, 0x000000083e367824ULL, 0x000fe400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee207ULL,
0x000000010f0f7824ULL, 0x100fe200028e063dULL, 0x0000001714147210ULL, 0x000fe40007fbe0ffULL,
0x0000003512127212ULL, 0x000fe400078efcffULL, 0x0001400073077811ULL, 0x000fe200078e68ffULL,
0x0000000115157824ULL, 0x000fe200028e063dULL, 0x0000001710107210ULL, 0x080fe40007fbe0ffULL,
0x0000001712127210ULL, 0x000fe20007fde0ffULL, 0x0000001016177824ULL, 0x000fc400078e0207ULL,
0x0000001034357824ULL, 0x100fe400078e0207ULL, 0x000000103c377824ULL, 0x000fe200078e0207ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e177faeULL, 0x0003e2000e101c46ULL,
0x0000000111117824ULL, 0x000fe400028e063dULL, 0x0000001036077824ULL, 0x000fe200078e0207ULL,
0x0000000014357faeULL, 0x0003e2000d901c46ULL, 0x0000000113137824ULL, 0x000fc600030e063dULL,
0x0000000010377faeULL, 0x0003e8000d101c46ULL, 0x0000000012077faeULL, 0x0003e2000c101c46ULL,
0x0000035000007947ULL, 0x000fea0003800000ULL, 0x00000010070e7812ULL, 0x000fe200078ec0ffULL,
0x0000001003137824ULL, 0x000fe200078e00ffULL, 0x000064003d377a11ULL, 0x000fe400078038ffULL,
0x0000000e030e7211ULL, 0x000fe400078fe8ffULL, 0x0000007013357812ULL, 0x000fc400078ec0ffULL,
0x000000040e107810ULL, 0x040fe20007ffe0ffULL, 0x000000010e077824ULL, 0x140fe200078e0203ULL,
0x000000080e127810ULL, 0x040fe20007ffe0ffULL, 0x000000080e147824ULL, 0x000fe200078e00ffULL,
0x000065003d3d7a11ULL, 0x000fe200000f3cffULL, 0x00000001100f7824ULL, 0x040fe200078e0203ULL,
0x00014000733f7811ULL, 0x000fe200078e68ffULL, 0x0000000810167824ULL, 0x000fe200078e00ffULL,
0xfffffff814077812ULL, 0x000fe200078ee207ULL, 0x0000000112117824ULL, 0x000fe200078e0203ULL,
0x0000000c0e147810ULL, 0x000fe20007ffe0ffULL, 0x0000000812347824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee20fULL, 0x00000001150f7824ULL, 0x000fc400078e020eULL,
0x0000000115107824ULL, 0x000fe200078e0210ULL, 0xfffffff834347812ULL, 0x000fe200078ee211ULL,
0x000000800f0e7825ULL, 0x000fc800078e00ffULL, 0x0000000115127824ULL, 0x040fe200078e0212ULL,
0x000000350e0e7212ULL, 0x000fe200078efcffULL, 0x0000000115157824ULL, 0x000fe400078e0214ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000e370e7210ULL, 0x000fc60007f1e0ffULL,
0x0000000114177824ULL, 0x000fe200078e0203ULL, 0x0000003510107212ULL, 0x000fe200078efcffULL,
0x0000000814367824ULL, 0x000fe400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee217ULL, 0x0000008015147825ULL, 0x000fe200078e00ffULL,
0x0000003512127212ULL, 0x000fc600078efcffULL, 0x000000010f0f7824ULL, 0x000fe200000e063dULL,
0x0000003514147212ULL, 0x000fe200078efcffULL, 0x0000001007077824ULL, 0x100fe200078e023fULL,
0x0000001037107210ULL, 0x040fe20007f1e0ffULL, 0x0000001016177824ULL, 0x100fe200078e023fULL,
0x0000001237127210ULL, 0x040fe20007f5e0ffULL, 0x0000001034357824ULL, 0x000fe200078e023fULL,
0x0000001437147210ULL, 0x000fe20007f7e0ffULL, 0x0000000111117824ULL, 0x100fe200000e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e077faeULL, 0x0003e2000b901c46ULL,
0x0000000113137824ULL, 0x000fc400010e063dULL, 0x0000001036377824ULL, 0x000fe200078e023fULL,
0x0000000010177faeULL, 0x0003e2000b901c46ULL, 0x0000000115157824ULL, 0x000fc600018e063dULL,
0x0000000012357faeULL, 0x0003e8000b901c46ULL, 0x0000000014377faeULL, 0x0003e4000b901c46ULL,
0x0000000800077824ULL, 0x002fe200078e00ffULL, 0x0000000102107810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0f7424ULL, 0x000fc600078e00ffULL, 0xfffffff007127812ULL, 0x040fe400078ec0ffULL,
0x000000761000720cULL, 0x000fe40003f06070ULL, 0x00000000120473c2ULL, 0x000e6200000e0000ULL,
0xffffffe0070e7812ULL, 0x040fe400078ec0ffULL, 0x0000001007137812ULL, 0x040fe400078ec0ffULL,
0x0000000807077812ULL, 0x000fcc00078ec0ffULL, 0x0000000179108824ULL, 0x000fe400078e0210ULL,
0x00000004ff118424ULL, 0x000fe200078e00ffULL, 0x0000000e07077210ULL, 0x000fe40007ffe013ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000660010108625ULL, 0x000fca00078e0011ULL,
0x00000006100f8981ULL, 0x000722000c1e1900ULL, 0x000176b004047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x008fec0000008000ULL, 0x0176b00012127f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176080007167f8cULL, 0x0006a4000c80043fULL,
0x0000000000107805ULL, 0x000fc40000015200ULL, 0x01760c0007157984ULL, 0x000ee40000000800ULL,
0x8000000015ff7812ULL, 0x00cfe40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410357210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc80000011415ULL, 0x000000350e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x000000020e0e7819ULL, 0x000fc80000001215ULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760c0007157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001003637824ULL, 0x000fe200078e00ffULL,
0x00000001ff747819ULL, 0x000fe20000011603ULL, 0x00000020000e7824ULL, 0x000fc600078e00ffULL,
0x0000007063637812ULL, 0x000fe400078ec0ffULL, 0xffffff800e0e7812ULL, 0x000fe400078ec0ffULL,
0x0000000c74747812ULL, 0x000fc800078ec0ffULL, 0x0000000e740e7210ULL, 0x000fca0007ffe063ULL,
0x017000000e117984ULL, 0x000ea80000000800ULL, 0x017200000e107984ULL, 0x0006620000000800ULL,
0x0000000c1100720bULL, 0x004fe20003f1d000ULL, 0x000164a27f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff3c177812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000ffff0e7224ULL, 0x000fd200078e000cULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000007b00720cULL, 0x000fe40003f05270ULL, 0x0000000c1100720bULL, 0x000fe20003f54000ULL,
0x000164627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000167806ULL, 0x000fc400010e0100ULL,
0x0000008000158824ULL, 0x000fe200078e0263ULL, 0x0000000c110e7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991016147816ULL, 0x000fe200000000ffULL,
0x0000000174158824ULL, 0x000fca00078e0215ULL, 0x0174000e15008388ULL, 0x0005e20000000800ULL,
0x000000ff1400720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000c0e0c7221ULL, 0x004fe20000010100ULL, 0x000000ff16ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00357308ULL, 0x000ea40000000800ULL, 0x000000350d0d7220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x000fe20000011603ULL,
0x000163a27f007947ULL, 0x000fea000b800000ULL, 0x00001f14353c7589ULL, 0x0004e400000e0000ULL,
0x0000003c38387220ULL, 0x08cfe40000410000ULL, 0x0000003c39397220ULL, 0x080fe40000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe40000410000ULL, 0x0000003c1d1d7220ULL, 0x080fe40000410000ULL,
0x0000003c20207220ULL, 0x080fe40000410000ULL, 0x0000003c21217220ULL, 0x000fc40000410000ULL,
0x0000003c24247220ULL, 0x080fe40000410000ULL, 0x0000003c25257220ULL, 0x080fe40000410000ULL,
0x0000003c28287220ULL, 0x080fe40000410000ULL, 0x0000003c29297220ULL, 0x080fe40000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000003c2d2d7220ULL, 0x000fc40000410000ULL,
0x0000003c30307220ULL, 0x080fe40000410000ULL, 0x0000003c31317220ULL, 0x080fe40000410000ULL,
0x0000003c18187220ULL, 0x080fe40000410000ULL, 0x0000003c19197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803147811ULL, 0x000fe200078ff0ffULL,
0x000162a27f007947ULL, 0x000fea000b800000ULL, 0x00001f14353c7589ULL, 0x0004e400000e0000ULL,
0x0000003c3a3a7220ULL, 0x08cfe40000410000ULL, 0x0000003c3b3b7220ULL, 0x080fe40000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe40000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe40000410000ULL,
0x0000003c22227220ULL, 0x080fe40000410000ULL, 0x0000003c23237220ULL, 0x000fc40000410000ULL,
0x0000003c26267220ULL, 0x080fe40000410000ULL, 0x0000003c27277220ULL, 0x080fe40000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe40000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe40000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe40000410000ULL, 0x0000003c2f2f7220ULL, 0x000fc40000410000ULL,
0x0000003c32327220ULL, 0x080fe40000410000ULL, 0x0000003c33337220ULL, 0x080fe40000410000ULL,
0x0000003c1a1a7220ULL, 0x080fe40000410000ULL, 0x0000003c1b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff17ff7812ULL, 0x000fe20007806016ULL,
0x00000001ff167424ULL, 0x000fd800078e00ffULL, 0x8000000e11110221ULL, 0x000fe20000010000ULL,
0x00007610ff160816ULL, 0x000fc60000000016ULL, 0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL,
0x0000001100080308ULL, 0x000ea40000000800ULL, 0x0000000810100220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000d100d7221ULL, 0x002fc40000010000ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0x00000008000c7824ULL, 0x000fca00078e00ffULL,
0xfffffff00c347812ULL, 0x000fca00078ec0ffULL, 0x0176ac00340c7984ULL, 0x000e640000000800ULL,
0x800000000cff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc80000011415ULL, 0x000000170c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x000000020c0c7819ULL, 0x000fc80000001215ULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000135357810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac00340c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910160b7816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0b00720cULL, 0x000fda0003fc5270ULL,
0x0000016000006947ULL, 0x000fea0003800000ULL, 0x00000008ff09723eULL, 0x000fe400000010ffULL,
0x00000002ff0c7819ULL, 0x000fe40000011603ULL, 0x00005410090b7816ULL, 0x000fe20000000009ULL,
0x00015e827f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0b097589ULL, 0x0002a400000e0000ULL,
0x000000080c147810ULL, 0x000fe20007ffe0ffULL, 0x00015ed27f007947ULL, 0x000fea000b800000ULL,
0x00001f140b0a7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100c147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e000bULL,
0x00003160003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00016b9000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180c147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e000bULL, 0x000031d0003d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x004fc400078e00ffULL,
0x00016b2000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002006e7824ULL, 0x040fe200078e00ffULL, 0x00000007030b7812ULL, 0x04afe200078ec0ffULL,
0x00000200004e7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000803107812ULL, 0x000fe400078ec0ffULL, 0x000000046e0c7812ULL, 0x000fe400078ec0ffULL,
0x000000080b507812ULL, 0x000fe400078ef803ULL, 0x0000000c03117211ULL, 0x000fc400078fe0ffULL,
0xfffff8004e4e7812ULL, 0x000fe200078ec0ffULL, 0x00000008506d7824ULL, 0x040fe400078e00ffULL,
0x00000001506a7824ULL, 0x000fca00078e0211ULL, 0xfffffff86d6d7812ULL, 0x000fca00078ee26aULL,
0x000000106d6d7824ULL, 0x000fc800078e00ffULL, 0x000000016d497824ULL, 0x000fc400078e024eULL,
0x0000000400117824ULL, 0x000fe200078e00ffULL, 0x00000004ff6c7819ULL, 0x000fe40000011603ULL,
0x0000000b103c7212ULL, 0x044fe400078efcffULL, 0x0000000411117812ULL, 0x000fe400078ec0ffULL,
0x0001300073657811ULL, 0x000fe400078e68ffULL, 0x0000001010107812ULL, 0x000fe200078efe0bULL,
0x000000016c517824ULL, 0x000fe200078e0211ULL, 0xfffffff86e6e7812ULL, 0x000fe200078ec0ffULL,
0x000000083c117824ULL, 0x000fc400078e00ffULL, 0x000000013c0c7824ULL, 0x000fe400078e0251ULL,
0x0000000810147824ULL, 0x000fe400078e00ffULL, 0x0000000151517824ULL, 0x000fe200078e0210ULL,
0xfffffff811117812ULL, 0x000fe400078ee20cULL, 0x000000020c0c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8140b7812ULL, 0x000fe200078ee251ULL, 0x0000001011407824ULL, 0x000fc800078e0265ULL,
0x000000100b347824ULL, 0x000fe400078e0265ULL, 0x000000004040783bULL, 0x000e680000004200ULL,
0x000000003434783bULL, 0x000ea20000004200ULL, 0x00000018ff157819ULL, 0x002fe20000011440ULL,
0x00000040005b7306ULL, 0x000fe20000009400ULL, 0x00000018ff3f7819ULL, 0x000fe40000011443ULL,
0x00000018ff3d7819ULL, 0x000fc40000011441ULL, 0x00000018ff3e7819ULL, 0x000fe40000011442ULL,
0x00000018ff567819ULL, 0x004fe20000011434ULL, 0x00000015004c7306ULL, 0x000fe20000209400ULL,
0x00000018ff5a7819ULL, 0x000fce0000011435ULL, 0x0000001500557306ULL, 0x000e700000205400ULL,
0x0000001500577306ULL, 0x000eb0000020d400ULL, 0x0000003f00167306ULL, 0x000fe20000209400ULL,
0x000000554c00720bULL, 0x002fce0003fbd000ULL, 0x0000003f00157306ULL, 0x000fec0000205400ULL,
0x0000000157575812ULL, 0x004fe400078efcffULL, 0x0000003f00627306ULL, 0x0003f0000020d400ULL,
0x0000003d004b7306ULL, 0x000fe20000209400ULL, 0x000000083c3f7824ULL, 0x002fca00078e00ffULL,
0xfffffff83f0c7812ULL, 0x000fe400078ee20cULL, 0x0000003d004a7306ULL, 0x000fe60000205400ULL,
0x000000100c3c7824ULL, 0x000fca00078e0265ULL, 0x0000003d00597306ULL, 0x0003f0000020d400ULL,
0x0000003e00177306ULL, 0x000fe20000209400ULL, 0x00000100403d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003e00147306ULL, 0x000ff00000205400ULL,
0x0000003e00667306ULL, 0x0003f0000020d400ULL, 0x0000003d004d7306ULL, 0x000fe20000209400ULL,
0x00000100413e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff607819ULL, 0x000fe4000001143eULL,
0x0000003d005c7306ULL, 0x000e700000205400ULL, 0x0000003d00677306ULL, 0x0004f0000020d400ULL,
0x0000004000547306ULL, 0x000ee20000005400ULL, 0x000000003c3c783bULL, 0x004ea20000004200ULL,
0x0000005c4d00720bULL, 0x002fcc0003f7d000ULL, 0x0000004000527306ULL, 0x00026e000000d400ULL,
0x0000000167673812ULL, 0x008fe200078efcffULL, 0x0000004100587306ULL, 0x000fe20000009400ULL,
0x0001000040407824ULL, 0x002fe200078e00ffULL, 0x000000545b00720bULL, 0x000fc80003f1d000ULL,
0x00000018ff5e7819ULL, 0x000fe40000011440ULL, 0x00000041006b7306ULL, 0x000e6e0000005400ULL,
0x0000000152520812ULL, 0x000fe200078efcffULL, 0x0000004100537306ULL, 0x0006a6000000d400ULL,
0x000000526752723eULL, 0x000fca00000010ffULL, 0x0000005e00407306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x008fe200078e00ffULL, 0x0000006b5800720bULL, 0x002fe20003f5d000ULL,
0x000001003c4d7824ULL, 0x004fca00078e00ffULL, 0x0000005e00697306ULL, 0x000e620000205400ULL,
0x00000018ff717819ULL, 0x000fcc000001144dULL, 0x0000000153532812ULL, 0x000fe200078efcffULL,
0x0000005e00687306ULL, 0x0004e2000020d400ULL, 0x000000141700720bULL, 0x000fce0003f5d000ULL,
0x00000056004f7306ULL, 0x000fe20000209400ULL, 0x00000018ff5e7819ULL, 0x004fe20000011441ULL,
0x0000010042417824ULL, 0x000fe200078e00ffULL, 0x000000694000720bULL, 0x002fe20003f9d000ULL,
0x000001003d407824ULL, 0x000fe400078e00ffULL, 0x0000000166662812ULL, 0x000fe400078efcffULL,
0x0000005e005f7306ULL, 0x000fe20000209400ULL, 0x00000018ff6f7819ULL, 0x000fe20000011441ULL,
0x0000010043417824ULL, 0x000fca00078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe20000011441ULL,
0x0000005e00617306ULL, 0x000e620000205400ULL, 0x0000000168684812ULL, 0x008fe400078efcffULL,
0x0000004a4b00720bULL, 0x000fca0003f9d000ULL, 0x0000005600487306ULL, 0x000ff00000205400ULL,
0x0000005600447306ULL, 0x000fe2000020d400ULL, 0x000000615f00720bULL, 0x002fe40003f1d000ULL,
0x0000000159594812ULL, 0x000fca00078efcffULL, 0x0000006000567306ULL, 0x000ff00000209400ULL,
0x00000060005d7306ULL, 0x000e700000205400ULL, 0x0000006f00547306ULL, 0x000ff00000209400ULL,
0x0000006f005b7306ULL, 0x000ea20000205400ULL, 0x0000005d5600720bULL, 0x002fce0003f7d000ULL,
0x0000005a00467306ULL, 0x000ff00000209400ULL, 0x0000005a00477306ULL, 0x000fe20000205400ULL,
0x0000005b5400720bULL, 0x004fce0003fbd000ULL, 0x0000005a00457306ULL, 0x000ff0000020d400ULL,
0x00000060005a7306ULL, 0x000e70000020d400ULL, 0x0000004200697306ULL, 0x000ff00000009400ULL,
0x00000042005f7306ULL, 0x000ea20000005400ULL, 0x000000015a5a3812ULL, 0x002fc800078efcffULL,
0x000000535a53723eULL, 0x000fc600000010ffULL, 0x0000006f00587306ULL, 0x0002f0000020d400ULL,
0x00000043004a7306ULL, 0x000fe20000009400ULL, 0x0000005f6900720bULL, 0x004fe40003f7d000ULL,
0x00000018ff6f7819ULL, 0x002fc40000011440ULL, 0x00000018ff697819ULL, 0x000fc60000011436ULL,
0x00000043004b7306ULL, 0x000e620000005400ULL, 0x0000000158585812ULL, 0x008fce00078efcffULL,
0x0000004200567306ULL, 0x0004f0000000d400ULL, 0x00000071004d7306ULL, 0x000fe20000209400ULL,
0x0000004b4a00720bULL, 0x002fe20003fbd000ULL, 0x0001000042427824ULL, 0x004fca00078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011442ULL, 0x00000071005c7306ULL, 0x000e620000205400ULL,
0x0000000156563812ULL, 0x008fe200078efcffULL, 0x000100003d427824ULL, 0x000fca00078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x0000005e00647306ULL, 0x000eb0000020d400ULL,
0x0000006b00417306ULL, 0x000fe20000209400ULL, 0x0000005c4d00720bULL, 0x002fc40003f7d000ULL,
0x00000018ff5c7819ULL, 0x000fca000001143cULL, 0x0000006b004c7306ULL, 0x000e620000205400ULL,
0x0000000164640812ULL, 0x004fe400078efcffULL, 0x000000151600720bULL, 0x000fca0003f1d000ULL,
0x0000004300547306ULL, 0x0004f0000000d400ULL, 0x0000003c005b7306ULL, 0x000fe20000009400ULL,
0x0000004c4100720bULL, 0x002fe20003f9d000ULL, 0x0001000043437824ULL, 0x004fe200078e00ffULL,
0x0000000162620812ULL, 0x000fca00078efcffULL, 0x0000003c00147306ULL, 0x000e620000005400ULL,
0x0000000154545812ULL, 0x008fce00078efcffULL, 0x0000007100607306ULL, 0x000eb0000020d400ULL,
0x0000003c00617306ULL, 0x000ee2000000d400ULL, 0x000000145b00720bULL, 0x002fe40003fbd000ULL,
0x00000018ff5b7819ULL, 0x000fca000001143dULL, 0x0000003d00177306ULL, 0x000fe20000009400ULL,
0x0000000160603812ULL, 0x004fce00078efcffULL, 0x0000003d004c7306ULL, 0x000e620000005400ULL,
0x0000000161615812ULL, 0x008fce00078efcffULL, 0x0000005c00157306ULL, 0x000ff00000209400ULL,
0x0000005c00167306ULL, 0x000ea20000205400ULL, 0x0000004c1700720bULL, 0x002fce0003f7d000ULL,
0x0000006b00557306ULL, 0x0002f0000020d400ULL, 0x0000006f00407306ULL, 0x000fe20000209400ULL,
0x000000161500720bULL, 0x004fe40003fbd000ULL, 0x011000004914783bULL, 0x000ea20000000200ULL,
0x00000018ff6b7819ULL, 0x002fc80000011437ULL, 0x0000006f005d7306ULL, 0x000e620000205400ULL,
0x0000000155554812ULL, 0x008fce00078efcffULL, 0x0000003d005f7306ULL, 0x000ee2000000d400ULL,
0x0000005d4000720bULL, 0x002fe20003f9d000ULL, 0x000100003c5d7824ULL, 0x000fcc00078e00ffULL,
0x0000006f005e7306ULL, 0x0002a2000020d400ULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x000000015f5f3812ULL, 0x008fca00078efcffULL, 0x0000005d003c7306ULL, 0x000fe20000209400ULL,
0x00000018ff6f7819ULL, 0x002fce000001143fULL, 0x0000005d004b7306ULL, 0x000e620000205400ULL,
0x000000091414e231ULL, 0x084fe200003400ffULL, 0x000000015e5e4812ULL, 0x000fe200078efcffULL,
0x000000091616e231ULL, 0x000fe400003400ffULL, 0x0000000a1515e231ULL, 0x080fe400003400ffULL,
0x0000000a1717e231ULL, 0x000fe200003400ffULL, 0x0000005b00407306ULL, 0x000fec0000209400ULL,
0x000000521438723cULL, 0x000be40000041838ULL, 0x0000005b00417306ULL, 0x000ea20000205400ULL,
0x0000004b3c00720bULL, 0x002fce0003f7d000ULL, 0x0000005d005d7306ULL, 0x000e70000020d400ULL,
0x00000067005a7306ULL, 0x000fe20000209400ULL, 0x000000414000720bULL, 0x004fce0003f9d000ULL,
0x00000067003d7306ULL, 0x000ea20000205400ULL, 0x000000015d5d3812ULL, 0x002fce00078efcffULL,
0x0000005c005c7306ULL, 0x000e70000020d400ULL, 0x00000042003c7306ULL, 0x000fe20000209400ULL,
0x0000003d5a00720bULL, 0x004fe40003f7d000ULL, 0x00000064593d723eULL, 0x000fca00000010ffULL,
0x0000004200537306ULL, 0x020ea20000205400ULL, 0x000000015c5c5812ULL, 0x002fce00078efcffULL,
0x0000006b004d7306ULL, 0x000ff00000209400ULL, 0x0000006b004b7306ULL, 0x000fe20000205400ULL,
0x000000533c00720bULL, 0x004fe40003fbd000ULL, 0x00000068573c723eULL, 0x000fca00000010ffULL,
0x0000006b00407306ULL, 0x0003e4000020d400ULL, 0x0000003c141c723cULL, 0x000b6c000004181cULL,
0x0000004200647306ULL, 0x0004e2000020d400ULL, 0x00000018ff6b7819ULL, 0x002fe4000001143eULL,
0x00000056583c723eULL, 0x020fc400000010ffULL, 0x00000054553d723eULL, 0x000fc600000010ffULL,
0x00000069004a7306ULL, 0x000fe20000209400ULL, 0x00000018ff427819ULL, 0x004fc60000011443ULL,
0x0000003c1420723cULL, 0x000be80000041820ULL, 0x00000069004c7306ULL, 0x000fe20000205400ULL,
0x0000000164645812ULL, 0x008fe400078efcffULL, 0x00000100343c7824ULL, 0x020fca00078e00ffULL,
0x0000006900417306ULL, 0x000fe2000020d400ULL, 0x00000018ff717819ULL, 0x000fce000001143cULL,
0x0000006b00527306ULL, 0x000ff00000209400ULL, 0x0000006b00697306ULL, 0x000e700000205400ULL,
0x0000006b005a7306ULL, 0x000eb0000020d400ULL, 0x0000004200597306ULL, 0x000fe20000209400ULL,
0x000000695200720bULL, 0x002fce0003fbd000ULL, 0x00000042006b7306ULL, 0x000e6c0000205400ULL,
0x000000015a5a5812ULL, 0x004fe400078efcffULL, 0x0000006700677306ULL, 0x000ea2000020d400ULL,
0x000000484f00720bULL, 0x000fe40003fbd000ULL, 0x0000006b5900720bULL, 0x002fe20003f5d000ULL,
0x000001003f6b7824ULL, 0x000fc800078e00ffULL, 0x00000042003d7306ULL, 0x000e62000020d400ULL,
0x00000018ff6b7819ULL, 0x000fe4000001146bULL, 0x0000000167673812ULL, 0x004fca00078efcffULL,
0x0000006f00537306ULL, 0x000fe20000209400ULL, 0x0000000144445812ULL, 0x000fe400078efcffULL,
0x000000474600720bULL, 0x000fca0003fbd000ULL, 0x0000006f00687306ULL, 0x000ea20000205400ULL,
0x000000013d3d2812ULL, 0x002fc800078efcffULL, 0x0000003d623d723eULL, 0x000fc600000010ffULL,
0x0000006f00577306ULL, 0x0002e2000020d400ULL, 0x0000000145455812ULL, 0x000fce00078efcffULL,
0x0000006b00597306ULL, 0x000fe20000209400ULL, 0x000001003e6f7824ULL, 0x002fe200078e00ffULL,
0x000000685300720bULL, 0x004fc80003f7d000ULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000006b003c7306ULL, 0x000e6e0000205400ULL, 0x0000000157573812ULL, 0x008fe200078efcffULL,
0x0000006f00547306ULL, 0x000ff00000209400ULL, 0x0000006f00697306ULL, 0x000ea20000205400ULL,
0x0000003c5900720bULL, 0x002fc40003f1d000ULL, 0x00000067663c723eULL, 0x000fca00000010ffULL,
0x0000003400527306ULL, 0x000fe40000009400ULL, 0x0000003c1424723cULL, 0x000b6c0000041824ULL,
0x0000003400537306ULL, 0x000e620000005400ULL, 0x000000695400720bULL, 0x004fe20003f5d000ULL,
0x000100003e3d7824ULL, 0x020fcc00078e00ffULL, 0x0000003400437306ULL, 0x0004f0000000d400ULL,
0x0000003f00697306ULL, 0x000fe20000009400ULL, 0x0001000034347824ULL, 0x004fe200078e00ffULL,
0x000000535200720bULL, 0x002fc80003f7d000ULL, 0x00000018ff757819ULL, 0x000fe40000011434ULL,
0x0000006f00347306ULL, 0x0002ae000020d400ULL, 0x0000000143433812ULL, 0x008fe200078efcffULL,
0x0000003f003c7306ULL, 0x000ee20000005400ULL, 0x00000018ff6f7819ULL, 0x002fc4000001143dULL,
0x0000005f5e3d723eULL, 0x000fca00000010ffULL, 0x0000005b005b7306ULL, 0x000e62000020d400ULL,
0x0000000134342812ULL, 0x004fce00078efcffULL, 0x0000003e00687306ULL, 0x000fe20000009400ULL,
0x0000003c6900720bULL, 0x008fe20003f5d000ULL, 0x000100003f3c7824ULL, 0x000fcc00078e00ffULL,
0x0000003e00667306ULL, 0x000ea20000005400ULL, 0x000000015b5b4812ULL, 0x002fce00078efcffULL,
0x0000006b00627306ULL, 0x000e62000020d400ULL, 0x000000666800720bULL, 0x004fce0003f9d000ULL,
0x0000003e00677306ULL, 0x000ea2000000d400ULL, 0x0000000162620812ULL, 0x002fce00078efcffULL,
0x0000003f00667306ULL, 0x0002f0000000d400ULL, 0x0000006f00687306ULL, 0x000fe20000209400ULL,
0x00000018ff3f7819ULL, 0x002fe4000001143cULL, 0x00000061603c723eULL, 0x000fc400000010ffULL,
0x0000000167674812ULL, 0x004fc600078efcffULL, 0x0000006f00697306ULL, 0x000e620000205400ULL,
0x0000000166662812ULL, 0x008fe200078efcffULL, 0x0000003c1428723cULL, 0x000b620000041828ULL,
0x000000673434723eULL, 0x000fca00000010ffULL, 0x0000003f006b7306ULL, 0x000fe20000209400ULL,
0x0000005d5c3c723eULL, 0x020fe400000010ffULL, 0x000000645b3d723eULL, 0x000fca00000010ffULL,
0x0000003f005e7306ULL, 0x000ea20000205400ULL, 0x000000696800720bULL, 0x002fe20003f9d000ULL,
0x0000003c142c723cULL, 0x000b6c000004182cULL, 0x0000006f003e7306ULL, 0x000e62000020d400ULL,
0x00000100353c7824ULL, 0x060fe400078e00ffULL, 0x00010000353d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003f003f7306ULL, 0x000ee2000020d400ULL,
0x0000005e6b00720bULL, 0x004fe40003f1d000ULL, 0x00000018ff3d7819ULL, 0x000fca000001143dULL,
0x00000035005c7306ULL, 0x000fe20000009400ULL, 0x000000013e3e4812ULL, 0x002fce00078efcffULL,
0x00000035005b7306ULL, 0x000e620000005400ULL, 0x000000013f3f0812ULL, 0x008fce00078efcffULL,
0x00000035005d7306ULL, 0x0004f0000000d400ULL, 0x0000003c005f7306ULL, 0x000fe20000209400ULL,
0x000000666235723eULL, 0x004fe400000010ffULL, 0x0000005b5c00720bULL, 0x002fca0003f9d000ULL,
0x000000341430723cULL, 0x000b620000041830ULL, 0x0000003c00647306ULL, 0x000e6c0000205400ULL,
0x0000003e5a34723eULL, 0x020fe400000010ffULL, 0x0000003f5735723eULL, 0x000fe200000010ffULL,
0x0000003c005e7306ULL, 0x0004a2000020d400ULL, 0x000000015d5d4812ULL, 0x008fca00078efcffULL,
0x000000341414723cULL, 0x000b620000041818ULL, 0x000000645f00720bULL, 0x002fe20003f7d000ULL,
0x0000003600667306ULL, 0x000fe20000009400ULL, 0x00000100363c7824ULL, 0x004fc800078e00ffULL,
0x0000010037197824ULL, 0x020fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe2000001143cULL,
0x00000008101b7824ULL, 0x000fe200078e00ffULL, 0x0000000251107810ULL, 0x000fe20007ffe0ffULL,
0x0000003600677306ULL, 0x000e620000005400ULL, 0x00000018ff357819ULL, 0x000fe40000011419ULL,
0xfffffff81b107812ULL, 0x000fe200078ee210ULL, 0x00010000361b7824ULL, 0x000fe200078e00ffULL,
0x000000015e5e3812ULL, 0x000fe400078efcffULL, 0x0000004c4a00720bULL, 0x000fe20003f7d000ULL,
0x0000003500197306ULL, 0x000fe20000209400ULL, 0x00000018ff347819ULL, 0x000fe2000001141bULL,
0x00000010103c7824ULL, 0x000fcc00078e0265ULL, 0x00000035001a7306ULL, 0x000ea20000205400ULL,
0x000000676600720bULL, 0x002fc60003f5d000ULL, 0x0000000141413812ULL, 0x000fc800078efcffULL,
0x0000003500517306ULL, 0x0003f0000020d400ULL, 0x0000003600537306ULL, 0x0006e2000000d400ULL,
0x0001000037357824ULL, 0x002fe200078e00ffULL, 0x0000001a1900720bULL, 0x004fcc0003fbd000ULL,
0x0000007100557306ULL, 0x000fe20000209400ULL, 0x00000018ff367819ULL, 0x008fe20000011435ULL,
0x0000000473357824ULL, 0x000fca00078e026cULL, 0x0000000235357810ULL, 0x000fe20007ffe050ULL,
0x0000007100567306ULL, 0x000e620000205400ULL, 0x0000000850507824ULL, 0x000fe200078e00ffULL,
0x0000000153532812ULL, 0x000fe400078efcffULL, 0x0000000151515812ULL, 0x000fe400078efcffULL,
0xfffffff850357812ULL, 0x000fe400078ee235ULL, 0x0000006800577306ULL, 0x000fe60000209400ULL,
0x0000001035487824ULL, 0x000fca00078e024eULL, 0x0000006800187306ULL, 0x000fe20000205400ULL,
0x000000565500720bULL, 0x002fce0003f1d000ULL, 0x00000068005a7306ULL, 0x000ff0000020d400ULL,
0x00000037005c7306ULL, 0x000ff00000009400ULL, 0x00000037006f7306ULL, 0x000ff00000005400ULL,
0x0000003700527306ULL, 0x000ff0000000d400ULL, 0x00000034001b7306ULL, 0x000ff00000209400ULL,
0x0000003400697306ULL, 0x000ff00000205400ULL, 0x0000003400557306ULL, 0x000ff0000020d400ULL,
0x0000003600677306ULL, 0x000ff00000209400ULL, 0x0000003600687306ULL, 0x000ff00000205400ULL,
0x0000003600567306ULL, 0x0003f0000020d400ULL, 0x0000003d00617306ULL, 0x000fe20000209400ULL,
0x011000004834783bULL, 0x002e6e0000000200ULL, 0x0000003d00607306ULL, 0x000eb00000205400ULL,
0x0000003d00627306ULL, 0x000670000020d400ULL, 0x0000007100547306ULL, 0x000e62000020d400ULL,
0x000000003c3c783bULL, 0x008ee20000004200ULL, 0x000000606100720bULL, 0x004fcc0003f9d000ULL,
0x0000007500587306ULL, 0x000fee0000209400ULL, 0x0000000162624812ULL, 0x002fe200078efcffULL,
0x0000007500597306ULL, 0x000e620000205400ULL, 0x0000000154540812ULL, 0x000fe200078efcffULL,
0x000000093434e231ULL, 0x080fe200003400ffULL, 0x0000004b4d00720bULL, 0x000fe20003f9d000ULL,
0x000000093636e231ULL, 0x000fe200003400ffULL, 0x000000624545723eULL, 0x000fe200000010ffULL,
0x0000000a3535e231ULL, 0x000fc400003400ffULL, 0x0000007500427306ULL, 0x000ea2000020d400ULL,
0x0000000a3737e231ULL, 0x000fe200003400ffULL, 0x000000185700720bULL, 0x000fe40003fdd000ULL,
0x000000595800720bULL, 0x002fc80003f1d000ULL, 0x0000000140404812ULL, 0x000fce00078efcffULL,
0x000000015a5a6812ULL, 0x000fe400078efcffULL, 0x00000018ff647819ULL, 0x008fe2000001143eULL,
0x0000003c004b7306ULL, 0x000fe20000009400ULL, 0x000000691b00720bULL, 0x000fe20003fdd000ULL,
0x000001003c4a7824ULL, 0x000fe200078e00ffULL, 0x0000000142420812ULL, 0x004fe200078efcffULL,
0x000001003d187824ULL, 0x000fe200078e00ffULL, 0x0000006f5c00720bULL, 0x000fe20003f1d000ULL,
0x000100003c197824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001144aULL,
0x0000006400597306ULL, 0x000fe20000209400ULL, 0x00000018ff587819ULL, 0x000fc4000001143cULL,
0x00000018ff507819ULL, 0x000fe4000001143dULL, 0x00000018ff717819ULL, 0x000fe4000001143fULL,
0x00000018ff577819ULL, 0x000fe20000011418ULL, 0x00000064005c7306ULL, 0x000fe20000205400ULL,
0x000000424444723eULL, 0x000fe200000010ffULL, 0x000100003f427824ULL, 0x000fe200078e00ffULL,
0x0000000152520812ULL, 0x000fe400078efcffULL, 0x000000686700720bULL, 0x000fc40003f1d000ULL,
0x0000000155556812ULL, 0x000fe200078efcffULL, 0x0000006400477306ULL, 0x000fe2000020d400ULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x00000044341c723cULL, 0x000f62000004181cULL,
0x000000535a5a723eULL, 0x000fca00000010ffULL, 0x0000003c00647306ULL, 0x000e640000005400ULL,
0x0000000156560812ULL, 0x000fcc00078efcffULL, 0x0000003d001a7306ULL, 0x000ff00000009400ULL,
0x0000003d001b7306ULL, 0x000ea20000005400ULL, 0x000000644b00720bULL, 0x002fe40003f5d000ULL,
0x00000018ff4b7819ULL, 0x000fca0000011419ULL, 0x0000005f006f7306ULL, 0x000ff00000209400ULL,
0x0000005f00607306ULL, 0x000e620000205400ULL, 0x0000001b1a00720bULL, 0x004fe20003fbd000ULL,
0x000100003d1a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe2000001141aULL,
0x00000058006b7306ULL, 0x000ff00000209400ULL, 0x00000058006c7306ULL, 0x000ea20000205400ULL,
0x000000606f00720bULL, 0x002fce0003f7d000ULL, 0x00000058004f7306ULL, 0x000e70000020d400ULL,
0x00000050005b7306ULL, 0x000fe20000209400ULL, 0x0000006c6b00720bULL, 0x004fce0003fdd000ULL,
0x0000005000667306ULL, 0x000fec0000205400ULL, 0x000000014f4f6812ULL, 0x002fe400078efcffULL,
0x00000050004e7306ULL, 0x000fe2000020d400ULL, 0x0000005c5900720bULL, 0x000fce0003fdd000ULL,
0x0000007100507306ULL, 0x000fec0000209400ULL, 0x0000000147476812ULL, 0x000fe400078efcffULL,
0x0000007100587306ULL, 0x000ff00000205400ULL, 0x0000007100467306ULL, 0x000ff0000020d400ULL,
0x0000005700187306ULL, 0x000ff00000209400ULL, 0x0000005700717306ULL, 0x000e700000205400ULL,
0x0000004b00197306ULL, 0x000ff00000209400ULL, 0x0000004b00697306ULL, 0x000ea20000205400ULL,
0x000000711800720bULL, 0x002fc40003f1d000ULL, 0x000000435418723eULL, 0x000fe200000010ffULL,
0x000100003e547824ULL, 0x000fc800078e00ffULL, 0x0000005f004c7306ULL, 0x000e62000020d400ULL,
0x00000018ff547819ULL, 0x000fce0000011454ULL, 0x00000061001a7306ULL, 0x000fe20000209400ULL,
0x000000691900720bULL, 0x004fe40003f9d000ULL, 0x0000005d5e19723eULL, 0x000fca00000010ffULL,
0x00000061001b7306ULL, 0x000ea20000205400ULL, 0x000000014c4c3812ULL, 0x002fce00078efcffULL,
0x0000003c005f7306ULL, 0x0002e2000000d400ULL, 0x0000001b1a00720bULL, 0x004fe20003f7d000ULL,
0x000001003e3c7824ULL, 0x002fcc00078e00ffULL, 0x00000057004a7306ULL, 0x000e62000020d400ULL,
0x000000183418723cULL, 0x000b620000041838ULL, 0x00000018ff757819ULL, 0x000fe2000001143cULL,
0x000001003f3c7824ULL, 0x000fe200078e00ffULL, 0x000000015f5f2812ULL, 0x008fc800078efcffULL,
0x0000003f00437306ULL, 0x000fe20000009400ULL, 0x000000564039723eULL, 0x020fe400000010ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001143cULL, 0x0000005f4c4c723eULL, 0x000fc600000010ffULL,
0x0000003f00387306ULL, 0x000ea20000005400ULL, 0x000000014a4a0812ULL, 0x002fce00078efcffULL,
0x0000003d004d7306ULL, 0x000e70000000d400ULL, 0x0000004b00577306ULL, 0x000ee2000020d400ULL,
0x000000384300720bULL, 0x004fe40003f1d000ULL, 0x000000554138723eULL, 0x000fca00000010ffULL,
0x0000007500647306ULL, 0x000fe20000209400ULL, 0x000000014d4d5812ULL, 0x002fe200078efcffULL,
0x000000383424723cULL, 0x000b620000041824ULL, 0x000000665b00720bULL, 0x000fe40003fbd000ULL,
0x00000052515b723eULL, 0x000fe400000010ffULL, 0x0000004d4a4d723eULL, 0x000fe200000010ffULL,
0x0000007500677306ULL, 0x000e620000205400ULL, 0x0000000157574812ULL, 0x008fc600078efcffULL,
0x0000005a3420723cULL, 0x000f640000041820ULL, 0x000000574f38723eULL, 0x020fe400000010ffULL,
0x0000003e00687306ULL, 0x000fe20000009400ULL, 0x000000014e4e5812ULL, 0x000fc600078efcffULL,
0x0000004c3428723cULL, 0x000f680000041828ULL, 0x0000003e005d7306ULL, 0x000ea20000005400ULL,
0x000000676400720bULL, 0x002fce0003f9d000ULL, 0x00000061003d7306ULL, 0x000e70000020d400ULL,
0x00000075004b7306ULL, 0x000ee2000020d400ULL, 0x0000005d6800720bULL, 0x004fce0003f5d000ULL,
0x0000006b00607306ULL, 0x000fe20000209400ULL, 0x000000013d3d3812ULL, 0x002fe400078efcffULL,
0x000000585000720bULL, 0x000fe40003f7d000ULL, 0x0000003d4e39723eULL, 0x000fc600000010ffULL,
0x0000006b00617306ULL, 0x000e620000205400ULL, 0x000000014b4b4812ULL, 0x008fc600078efcffULL,
0x00000038342c723cULL, 0x000b68000004182cULL, 0x0000003e003b7306ULL, 0x000ea2000000d400ULL,
0x0000000146463812ULL, 0x000fce00078efcffULL, 0x0000003f003a7306ULL, 0x000ee2000000d400ULL,
0x000000616000720bULL, 0x002fce0003fbd000ULL, 0x00000054003e7306ULL, 0x000fe20000209400ULL,
0x000000013b3b2812ULL, 0x004fce00078efcffULL, 0x00000054003f7306ULL, 0x000e620000205400ULL,
0x000000013a3a0812ULL, 0x008fce00078efcffULL, 0x0000004200437306ULL, 0x000ff00000209400ULL,
0x0000004200447306ULL, 0x000ea20000205400ULL, 0x0000003f3e00720bULL, 0x002fe40003f9d000ULL,
0x0000003b4b3e723eULL, 0x000fca00000010ffULL, 0x0000006b003c7306ULL, 0x000e70000020d400ULL,
0x0000005400547306ULL, 0x000ee2000020d400ULL, 0x000000444300720bULL, 0x004fce0003f5d000ULL,
0x0000004200417306ULL, 0x000ea2000020d400ULL, 0x000000013c3c5812ULL, 0x002fc800078efcffULL,
0x0000003a3c3f723eULL, 0x000fe400000010ffULL, 0x0000000154544812ULL, 0x008fc800078efcffULL,
0x000000544738723eULL, 0x020fe200000010ffULL, 0x0000003e3430723cULL, 0x000f620000041830ULL,
0x0000000141412812ULL, 0x004fc800078efcffULL, 0x000000414639723eULL, 0x000fce00000010ffULL,
0x000000383434723cULL, 0x000b6e0000041814ULL, 0x000176c873147811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000014147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x017688006eff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff3a7224ULL, 0x000fc600078e00ffULL, 0x0000000000167805ULL, 0x000fc80000015200ULL,
0x0000040006397984ULL, 0x000ee40000000800ULL, 0x8000000039ff7812ULL, 0x00afc40007804815ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x00000038163b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e17ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff387819ULL, 0x000fc80000011439ULL, 0x0000003b38387211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x0000000238387819ULL, 0x000fc80000001239ULL,
0x000000380000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040006397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000167824ULL, 0x000fe400078e00ffULL,
0x000059000f0f7a24ULL, 0x010fc600078e02ffULL, 0xffffffe016147812ULL, 0x000fe200078ec0ffULL,
0x000000400f0f7824ULL, 0x000fc800078e00ffULL, 0x0000010005147824ULL, 0x000fca00078e0214ULL,
0x0000008014157810ULL, 0x000fc80007ffe0ffULL, 0x0000002015147812ULL, 0x000fca00078ec0ffULL,
0x00000001773a7824ULL, 0x000fe200078e0214ULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x0000001570147217ULL, 0x000fe40007800000ULL, 0x0000001016177812ULL, 0x000fe400078ec0ffULL,
0x00000003ff167819ULL, 0x000fe20000011603ULL, 0x0000000114147824ULL, 0x000fe200078e0a15ULL,
0x000064000f3d7a11ULL, 0x000fe400078a38ffULL, 0x0000000416397810ULL, 0x040fe20007ffe0ffULL,
0x0000000116157824ULL, 0x000fe200078e0217ULL, 0x0000001417147217ULL, 0x000fc40007800000ULL,
0x000065000f3f7a11ULL, 0x000fe200028f3cffULL, 0x0000000115387824ULL, 0x040fe400078e0203ULL,
0x00000008153b7824ULL, 0x040fe400078e00ffULL, 0x0000000114147824ULL, 0x000fe400078e0a17ULL,
0x0000000115157824ULL, 0x000fe200078e023aULL, 0xfffffff83b3c7812ULL, 0x000fe400078ee238ULL,
0x0000000816387810ULL, 0x000fc40007ffe0ffULL, 0x0000000c163b7810ULL, 0x040fe40007ffe0ffULL,
0x000000141600720cULL, 0x080fe20003f86070ULL, 0x0000000139167824ULL, 0x140fe200078e0217ULL,
0x000000143800720cULL, 0x0c0fe20003f46070ULL, 0x0000000138387824ULL, 0x100fe200078e0217ULL,
0x000000143900720cULL, 0x080fe20003f66070ULL, 0x000000013b417824ULL, 0x040fe200078e0217ULL,
0x000000143b00720cULL, 0x000fe20003f06070ULL, 0x0000000116177824ULL, 0x040fe400078e0203ULL,
0x00000008163e7824ULL, 0x000fc400078e00ffULL, 0x0000008015147825ULL, 0x000fc600078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee217ULL, 0x0000000116167824ULL, 0x000fe200078e023aULL,
0x0000006314147212ULL, 0x000fe200078efcffULL, 0x0000000138397824ULL, 0x040fe400078e0203ULL,
0x0000000838407824ULL, 0x000fe200078e00ffULL, 0x000000143d147210ULL, 0x000fe20007fbe0ffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee239ULL,
0x0000000138387824ULL, 0x100fe200078e023aULL, 0x0000006316167212ULL, 0x000fe200078efcffULL,
0x00000001413a7824ULL, 0x000fe400078e023aULL, 0x0000008038387825ULL, 0x000fc800078e00ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000006338387212ULL, 0x000fc600078efcffULL,
0x0000000115157824ULL, 0x000fe200028e063fULL, 0x0000003d16167210ULL, 0x000fe20007fbe0ffULL,
0x00000001410f7824ULL, 0x040fe200078e0203ULL, 0x000000633a3a7212ULL, 0x000fe200078efcffULL,
0x0000000841427824ULL, 0x000fe400078e00ffULL, 0x0000000117177824ULL, 0x000fe200028e063fULL,
0x0000003d38387210ULL, 0x080fe40007fbe0ffULL, 0x0000003d3a3a7210ULL, 0x000fe20007fde0ffULL,
0x000000103e3d7824ULL, 0x000fe200078e0265ULL, 0xfffffff842427812ULL, 0x000fe200078ee20fULL,
0x000000103c0f7824ULL, 0x000fc400078e0265ULL, 0x0000000139397824ULL, 0x100fe400028e063fULL,
0x000000013b3b7824ULL, 0x000fe200030e063fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140f7faeULL, 0x0003e2000e101c46ULL, 0x00000010403f7824ULL, 0x100fe400078e0265ULL,
0x0000001042417824ULL, 0x000fe200078e0265ULL, 0x00000000163d7faeULL, 0x0003e8000d901c46ULL,
0x00000000383f7faeULL, 0x0003e8000d101c46ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001016167812ULL, 0x000fe400078ec0ffULL,
0x000064000f3f7a11ULL, 0x000fc400078038ffULL, 0x0000001603167211ULL, 0x000fe400078fe8ffULL,
0x000065000f417a11ULL, 0x000fe400000f3cffULL, 0x0000000416177810ULL, 0x040fe20007ffe0ffULL,
0x0000000116157824ULL, 0x040fe200078e0203ULL, 0x0000000816397810ULL, 0x040fe20007ffe0ffULL,
0x00000008163e7824ULL, 0x040fe200078e00ffULL, 0x0000000c163b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000817407824ULL, 0x040fe400078e00ffULL, 0x0000000116147824ULL, 0x000fe200078e023aULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee215ULL, 0x0000000117157824ULL, 0x000fc400078e0203ULL,
0x0000000139387824ULL, 0x140fe400078e023aULL, 0x0000000139167824ULL, 0x040fe200078e0203ULL,
0xfffffff840407812ULL, 0x000fe200078ee215ULL, 0x0000000839397824ULL, 0x000fe400078e00ffULL,
0x00000001173c7824ULL, 0x000fe400078e023aULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff839427812ULL, 0x000fc600078ee216ULL, 0x000000013b3a7824ULL, 0x000fe200078e023aULL,
0x0000006314167212ULL, 0x000fe200078efcffULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0x000000163f167210ULL, 0x000fe20007f1e0ffULL, 0x000000013b177824ULL, 0x040fe200078e0203ULL,
0x000000633c147212ULL, 0x080fe200078efcffULL, 0x000000083b447824ULL, 0x000fe400078e00ffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x000000143f147210ULL, 0x000fe40007f5e0ffULL,
0xfffffff844447812ULL, 0x000fe200078ee217ULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000006338387212ULL, 0x000fc600078efcffULL, 0x0000000115177824ULL, 0x100fe200000e0641ULL,
0x000000633a3a7212ULL, 0x000fe200078efcffULL, 0x000000013d157824ULL, 0x000fe200010e0641ULL,
0x000000383f387210ULL, 0x040fe20007f1e0ffULL, 0x000000103e0f7824ULL, 0x100fe200078e0265ULL,
0x0000003a3f3a7210ULL, 0x000fe20007f7e0ffULL, 0x00000010403d7824ULL, 0x000fe400078e0265ULL,
0x0000000139397824ULL, 0x100fe200000e0641ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000160f7faeULL, 0x0003e2000b901c46ULL, 0x000000013b3b7824ULL, 0x000fc400018e0641ULL,
0x00000010423f7824ULL, 0x100fe200078e0265ULL, 0x00000000143d7faeULL, 0x0003e2000b901c46ULL,
0x0000001044417824ULL, 0x000fc600078e0265ULL, 0x00000000383f7faeULL, 0x0003e8000b901c46ULL,
0x000000003a417faeULL, 0x0003e4000b901c46ULL, 0x0000000800167824ULL, 0x002fe200078e00ffULL,
0x0000000202147810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff0f7424ULL, 0x000fc600078e00ffULL,
0xfffffff016167812ULL, 0x000fe400078ec0ffULL, 0x000000761400720cULL, 0x000fe40003f06070ULL,
0x00000000160473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000000179148824ULL, 0x000fc400078e0214ULL, 0x00000004ff158424ULL, 0x000fc800078e00ffULL,
0x0000660014148625ULL, 0x000fca00078e0015ULL, 0x00000006140f8981ULL, 0x000722000c1e1900ULL,
0x000176a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x008fec0000008000ULL,
0x0176a80016167f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176280007147f8cULL, 0x0006a4000c80043fULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01762c00073b7984ULL, 0x000ee40000000800ULL, 0x800000003bff7812ULL, 0x00cfe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01762c00073b7984ULL, 0x000ea40000000800ULL,
0x800000003bff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000147824ULL, 0x000fca00078e00ffULL, 0xffffff8014147812ULL, 0x000fc800078ec0ffULL,
0x0000008063157810ULL, 0x000fca0007ffe014ULL, 0x0000000174157824ULL, 0x000fca00078e0215ULL,
0x0170000015397984ULL, 0x000ea80000000800ULL, 0x0172000015387984ULL, 0x0006620000000800ULL,
0x0000000e3900720bULL, 0x004fe20003f1d000ULL, 0x00012fc27f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff3c3b7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff3a7424ULL, 0x000fd600078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x000000017b157810ULL, 0x000fe40007ffe0ffULL,
0x0000000e3900720bULL, 0x000fe40003f54000ULL, 0x000000001500720cULL, 0x000fe20003f05270ULL,
0x00012f827f007947ULL, 0x000fd4000b800000ULL, 0x00000000003a7806ULL, 0x000fc400010e0100ULL,
0x0000008000158824ULL, 0x000fe200078e0263ULL, 0x0000000e39148209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x00000001743d8824ULL, 0x000fe200078e0215ULL,
0x000099103a157816ULL, 0x000fc800000000ffULL, 0x017400143d008388ULL, 0x0005e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000e39157209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff3aff7812ULL, 0x000fc6000780c0ffULL, 0x0000000e15147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400407308ULL, 0x000ea40000000800ULL,
0x000000400d0d7220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x000fe20000011603ULL, 0x00012eb27f007947ULL, 0x000fea000b800000ULL,
0x00001f14403c7589ULL, 0x0004e400000e0000ULL, 0x0000003c18187220ULL, 0x08cfe40000410000ULL,
0x0000003c19197220ULL, 0x080fe40000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe40000410000ULL,
0x0000003c1d1d7220ULL, 0x000fc40000410000ULL, 0x0000003c20207220ULL, 0x080fe40000410000ULL,
0x0000003c21217220ULL, 0x080fe40000410000ULL, 0x0000003c24247220ULL, 0x080fe40000410000ULL,
0x0000003c25257220ULL, 0x080fe40000410000ULL, 0x0000003c28287220ULL, 0x080fe40000410000ULL,
0x0000003c29297220ULL, 0x000fc40000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe40000410000ULL,
0x0000003c2d2d7220ULL, 0x080fe40000410000ULL, 0x0000003c30307220ULL, 0x080fe40000410000ULL,
0x0000003c31317220ULL, 0x080fe40000410000ULL, 0x0000003c34347220ULL, 0x080fe40000410000ULL,
0x0000003c35357220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff003aff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803147811ULL, 0x000fe200078ff0ffULL, 0x00012db27f007947ULL, 0x000fea000b800000ULL,
0x00001f14403c7589ULL, 0x0004e400000e0000ULL, 0x0000003c1a1a7220ULL, 0x08cfe40000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe40000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe40000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe40000410000ULL, 0x0000003c22227220ULL, 0x080fe40000410000ULL,
0x0000003c23237220ULL, 0x000fc40000410000ULL, 0x0000003c26267220ULL, 0x080fe40000410000ULL,
0x0000003c27277220ULL, 0x080fe40000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe40000410000ULL,
0x0000003c2b2b7220ULL, 0x080fe40000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe40000410000ULL,
0x0000003c2f2f7220ULL, 0x000fc40000410000ULL, 0x0000003c32327220ULL, 0x080fe40000410000ULL,
0x0000003c33337220ULL, 0x080fe40000410000ULL, 0x0000003c36367220ULL, 0x080fe40000410000ULL,
0x0000003c37377220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff3bff7812ULL, 0x000fe2000780603aULL, 0x00000001ff3a7424ULL, 0x000fe200078e00ffULL,
0x0000000e390e7209ULL, 0x000fd60007810000ULL, 0x8000000e39390221ULL, 0x000fe20000010000ULL,
0x00007610ff3a0816ULL, 0x000fc6000000003aULL, 0x3fb8aa3b39390820ULL, 0x000fc80000410000ULL,
0x0000003900080308ULL, 0x000ea40000000800ULL, 0x0000000838380220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000d380d7221ULL, 0x002fc40000010000ULL,
0x0000000000147805ULL, 0x000fca0000015200ULL, 0x0000000800387824ULL, 0x000fca00078e00ffULL,
0xfffffff0383c7812ULL, 0x000fca00078ec0ffULL, 0x0176b4003c397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x00000038143b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e15ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff387819ULL, 0x000fc80000011439ULL, 0x0000003b38387211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x0000000238387819ULL, 0x000fc80000001239ULL,
0x000000380000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176b4003c397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099103a127816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1200720cULL, 0x000fda0003f85270ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x00000008ff09723eULL, 0x000fe400000010ffULL,
0x00000002ff137819ULL, 0x000fe40000011603ULL, 0x0000541009127816ULL, 0x000fe20000000009ULL,
0x000129827f007947ULL, 0x000fea000b800000ULL, 0x00001f1312097589ULL, 0x0002a400000e0000ULL,
0x0000000813147810ULL, 0x000fe20007ffe0ffULL, 0x000129d27f007947ULL, 0x000fea000b800000ULL,
0x00001f14120a7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001013147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e0012ULL,
0x000068c0003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0001343000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001813147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e0012ULL, 0x00006930003d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x004fc400078e00ffULL,
0x000133c000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x0000100065697810ULL, 0x000fca0007ffe0ffULL,
0x0000001011647824ULL, 0x100fe400078e0269ULL, 0x000000100c387824ULL, 0x100fe400078e0269ULL,
0x000000100b687824ULL, 0x000fe200078e0269ULL, 0x000000006440783bULL, 0x000ee80000004200ULL,
0x000000003838783bULL, 0x000ea80000004200ULL, 0x00000000683c783bULL, 0x004ea20000004200ULL,
0x00000018ff127819ULL, 0x00afe20000011440ULL, 0x00000040006c7306ULL, 0x000fe20000005400ULL,
0x00000018ff157819ULL, 0x000fe20000011441ULL, 0x0001000040667824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fc40000011439ULL, 0x00000018ff467819ULL, 0x000fe4000001143bULL,
0x00000018ff447819ULL, 0x000fe20000011442ULL, 0x0000001200627306ULL, 0x000fe20000209400ULL,
0x00000018ff6b7819ULL, 0x004fe4000001143cULL, 0x00000018ff6e7819ULL, 0x000fca0000011466ULL,
0x0000001200137306ULL, 0x000e700000205400ULL, 0x0000001500617306ULL, 0x000ff00000209400ULL,
0x0000001500147306ULL, 0x000fe20000205400ULL, 0x000000136200720bULL, 0x002fe20003fbd000ULL,
0x0000010041627824ULL, 0x000fcc00078e00ffULL, 0x0000001500577306ULL, 0x0003f0000020d400ULL,
0x0000004500517306ULL, 0x000fe20000209400ULL, 0x00000018ff157819ULL, 0x002fce0000011438ULL,
0x0000004500547306ULL, 0x000ff00000205400ULL, 0x00000045005d7306ULL, 0x000ff0000020d400ULL,
0x00000015004d7306ULL, 0x000ff00000209400ULL, 0x0000001500527306ULL, 0x000ff00000205400ULL,
0x00000015005e7306ULL, 0x0003f0000020d400ULL, 0x0000004000457306ULL, 0x000ea20000009400ULL,
0x0000010040157824ULL, 0x002fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011415ULL,
0x00000046005c7306ULL, 0x000ff00000209400ULL, 0x00000046005b7306ULL, 0x000fe20000205400ULL,
0x0000006c4500720bULL, 0x004fc40003fdd000ULL, 0x00000018ff6c7819ULL, 0x000fe20000011462ULL,
0x0001000041627824ULL, 0x000fc800078e00ffULL, 0x00000046004e7306ULL, 0x000fe2000020d400ULL,
0x00000018ff717819ULL, 0x000fce0000011462ULL, 0x0000006700507306ULL, 0x000ff00000209400ULL,
0x0000006700557306ULL, 0x000e700000205400ULL, 0x0000004100467306ULL, 0x000ff00000009400ULL,
0x00000041006f7306ULL, 0x000ea20000005400ULL, 0x000000555000720bULL, 0x002fce0003f7d000ULL,
0x0000004400537306ULL, 0x000ff00000209400ULL, 0x00000044005a7306ULL, 0x000fe20000205400ULL,
0x0000006f4600720bULL, 0x004fce0003f5d000ULL, 0x0000004400607306ULL, 0x0003f0000020d400ULL,
0x0000001200567306ULL, 0x0004e2000020d400ULL, 0x00000018ff447819ULL, 0x002fce000001143aULL,
0x0000004400477306ULL, 0x000fe20000209400ULL, 0x00000018ff127819ULL, 0x004fce0000011443ULL,
0x00000044004a7306ULL, 0x000fe20000205400ULL, 0x0000000156565812ULL, 0x008fe400078efcffULL,
0x0000005a5300720bULL, 0x000fca0003fbd000ULL, 0x00000044004f7306ULL, 0x000ff0000020d400ULL,
0x0000006700447306ULL, 0x000e62000020d400ULL, 0x0000000160605812ULL, 0x000fce00078efcffULL,
0x0000004000157306ULL, 0x000eb0000000d400ULL, 0x0000001200597306ULL, 0x000fe20000209400ULL,
0x0000000144443812ULL, 0x002fce00078efcffULL, 0x0000001200587306ULL, 0x000fe20000205400ULL,
0x0000000115156812ULL, 0x004fc800078efcffULL, 0x000000154444723eULL, 0x000fc600000010ffULL,
0x00000012005f7306ULL, 0x000ff0000020d400ULL, 0x0000006c00677306ULL, 0x000ff00000209400ULL,
0x0000006c00407306ULL, 0x000e700000205400ULL, 0x0000006b004c7306ULL, 0x000ff00000209400ULL,
0x0000006b004b7306ULL, 0x000fe20000205400ULL, 0x000000406700720bULL, 0x002fce0003f7d000ULL,
0x0000006b00127306ULL, 0x000ff0000020d400ULL, 0x0000006e00667306ULL, 0x000ff00000209400ULL,
0x0000006e006b7306ULL, 0x000e700000205400ULL, 0x0000007100627306ULL, 0x000ff00000209400ULL,
0x00000071006f7306ULL, 0x000ea20000205400ULL, 0x0000006b6600720bULL, 0x002fce0003f1d000ULL,
0x0000006e00137306ULL, 0x0002f0000020d400ULL, 0x0000004100457306ULL, 0x0006e2000000d400ULL,
0x0000006f6200720bULL, 0x004fe20003fdd000ULL, 0x0000010043627824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001143fULL, 0x00010000386e7824ULL, 0x002fc800078e00ffULL,
0x0000007100507306ULL, 0x000e62000020d400ULL, 0x0000010042417824ULL, 0x008fe200078e00ffULL,
0x0000000113130812ULL, 0x000fe400078efcffULL, 0x000000146100720bULL, 0x000fe40003f1d000ULL,
0x00000018ff6b7819ULL, 0x000fe40000011441ULL, 0x0000004200407306ULL, 0x000fe20000009400ULL,
0x0000000145452812ULL, 0x000fe400078efcffULL, 0x000000135656723eULL, 0x000fc400000010ffULL,
0x00000018ff6e7819ULL, 0x000fc6000001146eULL, 0x0000004200677306ULL, 0x000ea20000005400ULL,
0x0000000150506812ULL, 0x002fe400078efcffULL, 0x0000000157570812ULL, 0x000fc800078efcffULL,
0x000000505757723eULL, 0x000fe200000010ffULL, 0x0000006c00467306ULL, 0x0002f0000020d400ULL,
0x0000006b00667306ULL, 0x000fe20000209400ULL, 0x00000018ff6c7819ULL, 0x002fc40000011462ULL,
0x000000674000720bULL, 0x004fe20003fdd000ULL, 0x0001000042407824ULL, 0x000fe400078e00ffULL,
0x0000010038677824ULL, 0x000fe400078e00ffULL, 0x0000006b00417306ULL, 0x000e620000205400ULL,
0x00000018ff537819ULL, 0x000fe40000011440ULL, 0x0000000146463812ULL, 0x008fe400078efcffULL,
0x000000585900720bULL, 0x000fc40003f7d000ULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000006c00627306ULL, 0x000fe20000209400ULL, 0x000000454645723eULL, 0x000fce00000010ffULL,
0x0000006c00617306ULL, 0x000ea20000205400ULL, 0x000000416600720bULL, 0x002fe40003f5d000ULL,
0x000000015f5f3812ULL, 0x000fca00078efcffULL, 0x0000006b00557306ULL, 0x0002f0000020d400ULL,
0x0000004200587306ULL, 0x0006e2000000d400ULL, 0x000000616200720bULL, 0x004fe40003f1d000ULL,
0x00000018ff6b7819ULL, 0x002fca000001143eULL, 0x0000004300597306ULL, 0x000fe20000009400ULL,
0x0001000043427824ULL, 0x008fe200078e00ffULL, 0x0000000155552812ULL, 0x000fcc00078efcffULL,
0x00000043005a7306ULL, 0x000e620000005400ULL, 0x0000000158586812ULL, 0x000fce00078efcffULL,
0x0000005300407306ULL, 0x000ff00000209400ULL, 0x0000005300417306ULL, 0x000ea20000205400ULL,
0x0000005a5900720bULL, 0x002fe40003f5d000ULL, 0x00000018ff5a7819ULL, 0x000fca0000011442ULL,
0x0000006c00147306ULL, 0x000e70000020d400ULL, 0x0000004300597306ULL, 0x0006e2000000d400ULL,
0x000000414000720bULL, 0x004fe40003fdd000ULL, 0x0000000114140812ULL, 0x002fe200078efcffULL,
0x011800004940783bULL, 0x008e620000000200ULL, 0x000000524d00720bULL, 0x000fc60003f1d000ULL,
0x0000005a00627306ULL, 0x000fe20000209400ULL, 0x0000000159592812ULL, 0x000fe400078efcffULL,
0x000000545100720bULL, 0x000fca0003f5d000ULL, 0x0000005a004d7306ULL, 0x000ea20000205400ULL,
0x00000018ff517819ULL, 0x000fe4000001143dULL, 0x000000015e5e0812ULL, 0x000fca00078efcffULL,
0x0000005300667306ULL, 0x000ee2000020d400ULL, 0x000000015d5d2812ULL, 0x000fe400078efcffULL,
0x0000004d6200720bULL, 0x004fe20003fbd000ULL, 0x0000010039627824ULL, 0x000fc800078e00ffULL,
0x0000005a00617306ULL, 0x000ea2000020d400ULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x0000000166666812ULL, 0x008fca00078efcffULL, 0x0000005100537306ULL, 0x000fe20000209400ULL,
0x0000004a4700720bULL, 0x000fe20003fdd000ULL, 0x000000094040c231ULL, 0x082fe400003400ffULL,
0x000000094242c231ULL, 0x000fc800003400ffULL, 0x00000051004d7306ULL, 0x000fe20000205400ULL,
0x0000000a4141c231ULL, 0x080fe200003400ffULL, 0x0000000161615812ULL, 0x004fe200078efcffULL,
0x0000000a4343c231ULL, 0x000fc600003400ffULL, 0x000000014f4f6812ULL, 0x000fe400078efcffULL,
0x0000005100157306ULL, 0x000fe4000020d400ULL, 0x00000056401c723cULL, 0x040bec000004181cULL,
0x0000006200517306ULL, 0x000fe20000209400ULL, 0x000000585556723eULL, 0x020fe200000010ffULL,
0x000000444018723cULL, 0x000b620000041818ULL, 0x000000591457723eULL, 0x000fca00000010ffULL,
0x00000062005a7306ULL, 0x000e620000205400ULL, 0x0000001010447824ULL, 0x020fe200078e0269ULL,
0x000000564020723cULL, 0x000bec0000041820ULL, 0x0000006700477306ULL, 0x000fe20000209400ULL,
0x000000666056723eULL, 0x020fe200000010ffULL, 0x0001000039607824ULL, 0x000fcc00078e00ffULL,
0x00000067004a7306ULL, 0x000ea20000205400ULL, 0x0000005a5100720bULL, 0x002fce0003f7d000ULL,
0x0000006700677306ULL, 0x000e70000020d400ULL, 0x00000038005a7306ULL, 0x000fe20000009400ULL,
0x0000004a4700720bULL, 0x004fe40003fbd000ULL, 0x000000004444783bULL, 0x000eaa0000004200ULL,
0x00000038006c7306ULL, 0x000eec0000005400ULL, 0x0000000167675812ULL, 0x002fc400078efcffULL,
0x0000006200627306ULL, 0x000e70000020d400ULL, 0x0000006e00147306ULL, 0x000fe20000209400ULL,
0x0000006c5a00720bULL, 0x008fce0003fbd000ULL, 0x0000006e00577306ULL, 0x000ee20000205400ULL,
0x0000000162623812ULL, 0x002fce00078efcffULL, 0x0000006b00527306ULL, 0x000ff00000209400ULL,
0x0000006b00547306ULL, 0x000fe20000205400ULL, 0x000000571400720bULL, 0x008fe40003f7d000ULL,
0x000000615f57723eULL, 0x000fc400000010ffULL, 0x00000018ff5f7819ULL, 0x000fc60000011460ULL,
0x0000006b004a7306ULL, 0x000fe4000020d400ULL, 0x000000564024723cULL, 0x000b6c0000041824ULL,
0x00000038006b7306ULL, 0x000470000000d400ULL, 0x00000039005a7306ULL, 0x000fe20000009400ULL,
0x00000018ff387819ULL, 0x004fce0000011444ULL, 0x0000003900597306ULL, 0x000ea20000005400ULL,
0x000000016b6b5812ULL, 0x002fc800078efcffULL, 0x0000006b6756723eULL, 0x020fe200000010ffULL,
0x000001003a677824ULL, 0x000fe400078e00ffULL, 0x00000039006c7306ULL, 0x000e66000000d400ULL,
0x00000018ff677819ULL, 0x000fca0000011467ULL, 0x0000005f00607306ULL, 0x000fe20000209400ULL,
0x000000595a00720bULL, 0x004fce0003fbd000ULL, 0x0000005f00617306ULL, 0x000eac0000205400ULL,
0x000000016c6c5812ULL, 0x002fe400078efcffULL, 0x0000006e00397306ULL, 0x000e64000020d400ULL,
0x0000006c6257723eULL, 0x000fe200000010ffULL, 0x000100003a627824ULL, 0x000fe200078e00ffULL,
0x000000616000720bULL, 0x004fc80003fbd000ULL, 0x00000067006b7306ULL, 0x000fe20000209400ULL,
0x000000564028723cULL, 0x000b620000041828ULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x0000000139393812ULL, 0x002fc800078efcffULL, 0x0000006700607306ULL, 0x000e620000205400ULL,
0x000001003b577824ULL, 0x020fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011457ULL,
0x0000003b00567306ULL, 0x000fe20000009400ULL, 0x000000606b00720bULL, 0x002fce0003f7d000ULL,
0x0000006f00517306ULL, 0x000ff00000209400ULL, 0x0000003b006b7306ULL, 0x000e700000005400ULL,
0x0000006f00507306ULL, 0x000ff00000205400ULL, 0x0000006f00137306ULL, 0x0005e2000020d400ULL,
0x0000006b5600720bULL, 0x002fe20003f5d000ULL, 0x000100003b6b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001146bULL, 0x0000005f005f7306ULL, 0x000e62000020d400ULL,
0x00000018ff6f7819ULL, 0x004fce0000011445ULL, 0x0000006f00597306ULL, 0x000ff00000209400ULL,
0x0000006f005a7306ULL, 0x000fe20000205400ULL, 0x000000015f5f5812ULL, 0x002fce00078efcffULL,
0x0000006f00147306ULL, 0x000ff0000020d400ULL, 0x0000006c00577306ULL, 0x000ff00000209400ULL,
0x0000006c00607306ULL, 0x000e700000205400ULL, 0x0000003a00667306ULL, 0x000ff00000009400ULL,
0x0000003a006f7306ULL, 0x000ea20000005400ULL, 0x000000605700720bULL, 0x002fce0003f1d000ULL,
0x0000003a00567306ULL, 0x0002f0000000d400ULL, 0x0000006700617306ULL, 0x000ee2000020d400ULL,
0x0000006f6600720bULL, 0x004fe40003fbd000ULL, 0x000000395e3a723eULL, 0x002fca00000010ffULL,
0x0000006c00577306ULL, 0x000e6c000020d400ULL, 0x0000000156565812ULL, 0x008fe400078efcffULL,
0x0000006200667306ULL, 0x000fe20000209400ULL, 0x0000000161613812ULL, 0x000fe400078efcffULL,
0x0000005b5c00720bULL, 0x000fc40003f7d000ULL, 0x000000566156723eULL, 0x000fc600000010ffULL,
0x0000006200677306ULL, 0x000ea20000205400ULL, 0x0000000157570812ULL, 0x002fce00078efcffULL,
0x0000006b006c7306ULL, 0x000fe20000209400ULL, 0x000000014e4e3812ULL, 0x000fce00078efcffULL,
0x0000006b005e7306ULL, 0x000e620000205400ULL, 0x000000676600720bULL, 0x004fce0003fbd000ULL,
0x0000003b00607306ULL, 0x0004f0000000d400ULL, 0x0000006200627306ULL, 0x000ee2000020d400ULL,
0x0000005e6c00720bULL, 0x002fe40003f1d000ULL, 0x0000005f5d3b723eULL, 0x004fc400000010ffULL,
0x00000018ff5f7819ULL, 0x000fc60000011446ULL, 0x0000006b006b7306ULL, 0x000e62000020d400ULL,
0x0000000160602812ULL, 0x008fe200078efcffULL, 0x0000003a402c723cULL, 0x040fe6000004182cULL,
0x000000605757723eULL, 0x000fe400000010ffULL, 0x00000018ff607819ULL, 0x000fe20000011447ULL,
0x0000005f005d7306ULL, 0x000fe20000209400ULL, 0x0000000162625812ULL, 0x000fe400078efcffULL,
0x0000004b4c00720bULL, 0x000fe20003fbd000ULL, 0x000000564030723cULL, 0x000b620000041830ULL,
0x000000016b6b0812ULL, 0x002fc600078efcffULL, 0x0000005f005b7306ULL, 0x000fe60000205400ULL,
0x000000624f56723eULL, 0x020fe400000010ffULL, 0x0000006b4e57723eULL, 0x000fe200000010ffULL,
0x000001003c4e7824ULL, 0x000fe400078e00ffULL, 0x0000000112125812ULL, 0x000fe200078efcffULL,
0x0000005f00397306ULL, 0x000fe4000020d400ULL, 0x00000018ff627819ULL, 0x000fe2000001144eULL,
0x000000564040723cULL, 0x000b6a0000041834ULL, 0x00000060003b7306ULL, 0x000fe40000209400ULL,
0x000100003c347824ULL, 0x020fc400078e00ffULL, 0x000001003d357824ULL, 0x000fc600078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011434ULL, 0x00000060005c7306ULL, 0x000fe20000205400ULL,
0x00000018ff6b7819ULL, 0x000fce0000011435ULL, 0x00000060003a7306ULL, 0x000ff0000020d400ULL,
0x0000003c005e7306ULL, 0x000ff00000009400ULL, 0x0000003c005f7306ULL, 0x000e700000005400ULL,
0x00000062004e7306ULL, 0x000ff00000209400ULL, 0x0000006200607306ULL, 0x000ea20000205400ULL,
0x0000005f5e00720bULL, 0x002fe20003f5d000ULL, 0x000001003e5f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001145fULL, 0x0000006700347306ULL, 0x000ff00000209400ULL,
0x0000006700617306ULL, 0x000e620000205400ULL, 0x000000604e00720bULL, 0x004fce0003f7d000ULL,
0x0000003c004f7306ULL, 0x000eb0000000d400ULL, 0x00000062003c7306ULL, 0x0006a2000020d400ULL,
0x000000613400720bULL, 0x002fe20003f1d000ULL, 0x000001003f347824ULL, 0x000fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000006700577306ULL, 0x000e62000020d400ULL,
0x000100003d627824ULL, 0x008fe200078e00ffULL, 0x000000014f4f2812ULL, 0x004fe400078efcffULL,
0x000000545200720bULL, 0x000fe40003f5d000ULL, 0x00000018ff6c7819ULL, 0x000fe40000011462ULL,
0x0000003d00377306ULL, 0x000fe20000009400ULL, 0x000000013c3c3812ULL, 0x000fc400078efcffULL,
0x0000004d5300720bULL, 0x000fe20003f7d000ULL, 0x000100003e4d7824ULL, 0x000fe200078e00ffULL,
0x0000004f3c3c723eULL, 0x000fc600000010ffULL, 0x0000003d00567306ULL, 0x000ea20000005400ULL,
0x0000000157570812ULL, 0x002fe400078efcffULL, 0x000000014a4a2812ULL, 0x000fe400078efcffULL,
0x0000005a5900720bULL, 0x000fe20003f5d000ULL, 0x00010000465a7824ULL, 0x000fe400078e00ffULL,
0x0000006b00357306ULL, 0x000fe20000209400ULL, 0x0000000115153812ULL, 0x000fe400078efcffULL,
0x00000018ff5a7819ULL, 0x000fca000001145aULL, 0x0000006b00367306ULL, 0x000e620000205400ULL,
0x000000563700720bULL, 0x004fe40003fdd000ULL, 0x0000000114142812ULL, 0x000fca00078efcffULL,
0x0000003d00667306ULL, 0x000eb0000000d400ULL, 0x0000006b003d7306ULL, 0x000ee2000020d400ULL,
0x000000363500720bULL, 0x002fce0003f1d000ULL, 0x0000003f00527306ULL, 0x000fe20000009400ULL,
0x0000000166666812ULL, 0x004fce00078efcffULL, 0x0000003f00537306ULL, 0x000e620000005400ULL,
0x000000013d3d0812ULL, 0x008fc800078efcffULL, 0x000000663d3d723eULL, 0x000fc600000010ffULL,
0x00000034004c7306ULL, 0x000ff00000209400ULL, 0x00000034004e7306ULL, 0x000ea20000205400ULL,
0x000000535200720bULL, 0x002fce0003f1d000ULL, 0x0000003400567306ULL, 0x0002f0000020d400ULL,
0x0000003e00607306ULL, 0x000fe20000009400ULL, 0x011800004834783bULL, 0x002e620000000200ULL,
0x0000004e4c00720bULL, 0x004fcc0003f7d000ULL, 0x0000003e006b7306ULL, 0x000eae0000005400ULL,
0x0000000156563812ULL, 0x008fe200078efcffULL, 0x0000006c00677306ULL, 0x000ff00000209400ULL,
0x0000006c006e7306ULL, 0x000ee20000205400ULL, 0x0000006b6000720bULL, 0x004fce0003fbd000ULL,
0x0000006f00627306ULL, 0x000ff00000209400ULL, 0x0000006f004b7306ULL, 0x000fe20000205400ULL,
0x0000006e6700720bULL, 0x008fe20003fdd000ULL, 0x000000093434c231ULL, 0x002fc400003400ffULL,
0x000000093636c231ULL, 0x000fe400003400ffULL, 0x0000000a3535c231ULL, 0x080fe400003400ffULL,
0x0000006f005f7306ULL, 0x0003e2000020d400ULL, 0x0000000a3737c231ULL, 0x000fe200003400ffULL,
0x000000505100720bULL, 0x000fcc0003f9d000ULL, 0x0000003e00617306ULL, 0x0004e2000000d400ULL,
0x00000018ff6f7819ULL, 0x002fe2000001144dULL, 0x0000003c3418723cULL, 0x000b6a0000041818ULL,
0x0000000113134812ULL, 0x000fe200078efcffULL, 0x0000006f004d7306ULL, 0x000fe20000209400ULL,
0x000100003f3e7824ULL, 0x004fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000006f00537306ULL, 0x000e620000205400ULL, 0x0000000161615812ULL, 0x008fce00078efcffULL,
0x0000006c005e7306ULL, 0x000eb0000020d400ULL, 0x0000006f00607306ULL, 0x000ee2000020d400ULL,
0x000000534d00720bULL, 0x002fce0003fbd000ULL, 0x0000003e006b7306ULL, 0x000fe20000209400ULL,
0x000000015e5e6812ULL, 0x004fe400078efcffULL, 0x0000004b6200720bULL, 0x000fca0003fdd000ULL,
0x0000003e006c7306ULL, 0x000e620000205400ULL, 0x0000000160605812ULL, 0x008fce00078efcffULL,
0x0000003e00527306ULL, 0x0004e2000020d400ULL, 0x000000015f5f6812ULL, 0x000fce00078efcffULL,
0x00000044004e7306ULL, 0x000fe20000009400ULL, 0x00000100453e7824ULL, 0x004fe200078e00ffULL,
0x0000006c6b00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff627819ULL, 0x000fe4000001143eULL,
0x00000044006f7306ULL, 0x000e6e0000005400ULL, 0x0000000152525812ULL, 0x008fe200078efcffULL,
0x0000003f00547306ULL, 0x0004e6000000d400ULL, 0x000000521313723eULL, 0x000fca00000010ffULL,
0x0000003800557306ULL, 0x000fe20000209400ULL, 0x00000100443f7824ULL, 0x004fe200078e00ffULL,
0x0000006f4e00720bULL, 0x002fe20003f7d000ULL, 0x00010000444e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001143fULL, 0x0000003800587306ULL, 0x000e620000205400ULL,
0x0000000154540812ULL, 0x008fc800078efcffULL, 0x00000054563d723eULL, 0x020fc600000010ffULL,
0x00000045004c7306ULL, 0x000ff00000009400ULL, 0x0000004500757306ULL, 0x000ea20000005400ULL,
0x000000585500720bULL, 0x002fe40003fdd000ULL, 0x00000018ff557819ULL, 0x000fca000001144eULL,
0x00000062003e7306ULL, 0x000ff00000209400ULL, 0x00000062003f7306ULL, 0x000e620000205400ULL,
0x000000754c00720bULL, 0x004fe20003f1d000ULL, 0x00010000454c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff587819ULL, 0x000fe2000001144cULL, 0x0000006e00677306ULL, 0x000ff00000209400ULL,
0x0000006e00517306ULL, 0x000ea20000205400ULL, 0x0000003f3e00720bULL, 0x002fce0003f9d000ULL,
0x0000006e00507306ULL, 0x000e70000020d400ULL, 0x00000062004b7306ULL, 0x000ee2000020d400ULL,
0x000000516700720bULL, 0x004fce0003fbd000ULL, 0x0000005500717306ULL, 0x000fec0000209400ULL,
0x0000000150505812ULL, 0x002fe400078efcffULL, 0x0000005500757306ULL, 0x000e620000205400ULL,
0x000000014b4b4812ULL, 0x008fce00078efcffULL, 0x00000046003e7306ULL, 0x000ff00000009400ULL,
0x00000046004f7306ULL, 0x000ea20000005400ULL, 0x000000757100720bULL, 0x002fce0003fbd000ULL,
0x00000045004d7306ULL, 0x000e70000000d400ULL, 0x00000047003f7306ULL, 0x000fe20000009400ULL,
0x0000004f3e00720bULL, 0x004fe40003f9d000ULL, 0x00000057123e723eULL, 0x000fe200000010ffULL,
0x0001000047127824ULL, 0x000fc800078e00ffULL, 0x00000047003c7306ULL, 0x000ea20000005400ULL,
0x000000014d4d0812ULL, 0x002fc800078efcffULL, 0x0000004d4b4b723eULL, 0x000fc600000010ffULL,
0x0000004400537306ULL, 0x0002f0000000d400ULL, 0x00000055004e7306ULL, 0x000ee2000020d400ULL,
0x0000010046447824ULL, 0x002fe200078e00ffULL, 0x0000003c3f00720bULL, 0x004fc40003f1d000ULL,
0x0000005e153f723eULL, 0x000fe400000010ffULL, 0x00000018ff6b7819ULL, 0x000fe20000011444ULL,
0x0000010047447824ULL, 0x000fe200078e00ffULL, 0x00000058006e7306ULL, 0x000fe20000209400ULL,
0x00000018ff157819ULL, 0x000fe40000011412ULL, 0x0000003e341c723cULL, 0x000b62000004181cULL,
0x00000018ff517819ULL, 0x000fe40000011444ULL, 0x0000000153533812ULL, 0x008fc400078efcffULL,
0x00000058006f7306ULL, 0x000e620000205400ULL, 0x000000014e4e5812ULL, 0x000fe400078efcffULL,
0x000000604a12723eULL, 0x000fe400000010ffULL, 0x000000615f3c723eULL, 0x000fe400000010ffULL,
0x00000053504a723eULL, 0x000fe200000010ffULL, 0x0000006b00627306ULL, 0x000fe40000209400ULL,
0x000000123424723cULL, 0x040b6c0000041824ULL, 0x0000006b00597306ULL, 0x000ea20000205400ULL,
0x0000006f6e00720bULL, 0x002fe20003f7d000ULL, 0x0000003c3420723cULL, 0x040f6c0000041820ULL,
0x0000005800457306ULL, 0x000e64000020d400ULL, 0x0000004a3428723cULL, 0x000f6c0000041828ULL,
0x0000005100587306ULL, 0x000fe20000209400ULL, 0x000000596200720bULL, 0x004fce0003fbd000ULL,
0x0000005100557306ULL, 0x000ea20000205400ULL, 0x0000000145453812ULL, 0x002fe400078efcffULL,
0x0000005c3b00720bULL, 0x000fca0003f7d000ULL, 0x0000005100447306ULL, 0x000e70000020d400ULL,
0x0000004600517306ULL, 0x000ee2000000d400ULL, 0x000000555800720bULL, 0x004fe40003f5d000ULL,
0x000000013a3a3812ULL, 0x000fca00078efcffULL, 0x0000003800387306ULL, 0x000eac000020d400ULL,
0x0000000144442812ULL, 0x002fe400078efcffULL, 0x0000006b004c7306ULL, 0x000e62000020d400ULL,
0x0000000151514812ULL, 0x008fce00078efcffULL, 0x0000004700467306ULL, 0x000ee2000000d400ULL,
0x0000000138386812ULL, 0x004fe400078efcffULL, 0x0000005b5d00720bULL, 0x000fe40003fdd000ULL,
0x0000004e384e723eULL, 0x000fc600000010ffULL, 0x0000005a004f7306ULL, 0x000fe20000209400ULL,
0x000000014c4c5812ULL, 0x002fc800078efcffULL, 0x000000514c4c723eULL, 0x000fc600000010ffULL,
0x0000005a00477306ULL, 0x000e620000205400ULL, 0x0000000146460812ULL, 0x008fe400078efcffULL,
0x0000000139396812ULL, 0x000fe400078efcffULL, 0x00000046444d723eULL, 0x000fc600000010ffULL,
0x0000001500577306ULL, 0x000fe80000209400ULL, 0x0000004c3430723cULL, 0x000f680000041830ULL,
0x00000015003e7306ULL, 0x020ea20000205400ULL, 0x000000474f00720bULL, 0x002fe40003fbd000ULL,
0x00000045144f723eULL, 0x000fe200000010ffULL, 0x0000000200147824ULL, 0x000fc800078e00ffULL,
0x0000005a005a7306ULL, 0x000e62000020d400ULL, 0xfffffff814147812ULL, 0x000fe200078ec0ffULL,
0x0000004e342c723cULL, 0x000f6c000004182cULL, 0x0000001500137306ULL, 0x000ee2000020d400ULL,
0x0000003e5700720bULL, 0x004fe40003f9d000ULL, 0x000000015a5a5812ULL, 0x002fc800078efcffULL,
0x0000005a3912723eULL, 0x000fce00000010ffULL, 0x0000000113134812ULL, 0x008fc800078efcffULL,
0x000000133a13723eULL, 0x000fce00000010ffULL, 0x000000123434723cULL, 0x000b6e0000041840ULL,
0x000176c873127811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000012127f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176900014ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff3a7224ULL, 0x000fc600078e00ffULL,
0x0000000000147805ULL, 0x004fc80000015200ULL, 0x0000040006397984ULL, 0x000ea40000000800ULL,
0x8000000039ff7812ULL, 0x006fc40007804813ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038143b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e15ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff387819ULL, 0x000fc80000011439ULL,
0x0000003b38387211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000238387819ULL, 0x000fc80000001239ULL, 0x000000380000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040006397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000147824ULL, 0x000fe400078e00ffULL, 0x000059000f0f7a24ULL, 0x010fc600078e02ffULL,
0xffffffe014127812ULL, 0x000fe200078ec0ffULL, 0x000000400f0f7824ULL, 0x000fc800078e00ffULL,
0x0000010005127824ULL, 0x000fca00078e0212ULL, 0x000000c012137810ULL, 0x000fc80007ffe0ffULL,
0x0000002013127812ULL, 0x000fca00078ec0ffULL, 0x00000001773b7824ULL, 0x000fe200078e0212ULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x0000001014157812ULL, 0x000fe400078ec0ffULL,
0x0000001370127217ULL, 0x000fe40007800000ULL, 0x00000003ff147819ULL, 0x000fc60000011603ULL,
0x0000000112127824ULL, 0x000fe200078e0a13ULL, 0x0000000414397810ULL, 0x040fe20007ffe0ffULL,
0x0000000114387824ULL, 0x040fe200078e0215ULL, 0x0000000c143d7810ULL, 0x000fe40007ffe0ffULL,
0x0000001215127217ULL, 0x000fe20007800000ULL, 0x0000000138137824ULL, 0x040fe400078e0203ULL,
0x00000008383c7824ULL, 0x000fe400078e00ffULL, 0x0000000112127824ULL, 0x000fc400078e0a15ULL,
0x000000013d427824ULL, 0x000fe200078e0215ULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee213ULL,
0x0000000814137810ULL, 0x040fe40007ffe0ffULL, 0x000000121400720cULL, 0x080fe20003f86070ULL,
0x0000000138147824ULL, 0x000fe200078e023bULL, 0x000000123900720cULL, 0x080fe20003f66070ULL,
0x00000001133a7824ULL, 0x140fe200078e0215ULL, 0x000000121300720cULL, 0x080fe20003f46070ULL,
0x0000000139387824ULL, 0x000fe200078e0215ULL, 0x000000123d00720cULL, 0x000fe20003f06070ULL,
0x000000013a127824ULL, 0x040fe200078e0203ULL, 0x000064000f3d7a11ULL, 0x000fe200078a38ffULL,
0x000000083a397824ULL, 0x000fc400078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000065000f3f7a11ULL, 0x000fe400028f3cffULL, 0xfffffff839407812ULL, 0x000fe200078ee212ULL,
0x0000000138137824ULL, 0x000fe200078e0203ULL, 0x0000006314147212ULL, 0x000fe200078efcffULL,
0x00000008383e7824ULL, 0x040fe400078e00ffULL, 0x0000000138387824ULL, 0x100fe200078e023bULL,
0x000000143d147210ULL, 0x000fe20007fbe0ffULL, 0x000000013a3a7824ULL, 0x000fe200078e023bULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL, 0x0000008038387825ULL, 0x000fc800078e00ffULL,
0x0000000142127824ULL, 0x000fe200078e023bULL, 0x0000006338387212ULL, 0x000fe200078efcffULL,
0x000000803a3a7825ULL, 0x000fc800078e00ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000633a3a7212ULL, 0x000fc600078efcffULL, 0x0000000115157824ULL, 0x000fe200028e063fULL,
0x0000003d38387210ULL, 0x000fe20007fbe0ffULL, 0x00000001420f7824ULL, 0x000fe200078e0203ULL,
0x0000006312127212ULL, 0x000fe200078efcffULL, 0x0000000842427824ULL, 0x000fe400078e00ffULL,
0x0000000139397824ULL, 0x000fe200028e063fULL, 0x0000003d3a3a7210ULL, 0x080fe40007fbe0ffULL,
0x0000003d12127210ULL, 0x000fe20007fde0ffULL, 0x000000103e3d7824ULL, 0x000fe200078e0269ULL,
0xfffffff842427812ULL, 0x000fe200078ee20fULL, 0x000000103c0f7824ULL, 0x000fc400078e0269ULL,
0x000000013b3b7824ULL, 0x100fe400028e063fULL, 0x0000000113137824ULL, 0x000fe200030e063fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140f7faeULL, 0x0003e2000e101c46ULL,
0x00000010403f7824ULL, 0x100fe400078e0269ULL, 0x0000001042417824ULL, 0x000fe200078e0269ULL,
0x00000000383d7faeULL, 0x0003e8000d901c46ULL, 0x000000003a3f7faeULL, 0x0003e8000d101c46ULL,
0x0000000012417faeULL, 0x0003e2000c101c46ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001014147812ULL, 0x000fe400078ec0ffULL, 0x000064000f3d7a11ULL, 0x000fc400078038ffULL,
0x0000001403127211ULL, 0x000fe400078fe8ffULL, 0x000065000f3f7a11ULL, 0x000fe400000f3cffULL,
0x0000000412387810ULL, 0x040fe20007ffe0ffULL, 0x0000000112137824ULL, 0x040fe200078e0203ULL,
0x00000008123e7810ULL, 0x040fe20007ffe0ffULL, 0x00000008123c7824ULL, 0x040fe200078e00ffULL,
0x0000000c12407810ULL, 0x040fe20007ffe0ffULL, 0x0000000112147824ULL, 0x100fe400078e023bULL,
0x00000001383a7824ULL, 0x000fe200078e023bULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL,
0x0000000138137824ULL, 0x000fc400078e0203ULL, 0x0000000838427824ULL, 0x000fe400078e00ffULL,
0x000000013e387824ULL, 0x100fe400078e023bULL, 0x0000000140127824ULL, 0x000fe400078e023bULL,
0x000000013e397824ULL, 0x040fe400078e0203ULL, 0x000000083e447824ULL, 0x000fe200078e00ffULL,
0xfffffff8423e7812ULL, 0x000fe200078ee213ULL, 0x00000001403b7824ULL, 0x000fc400078e0203ULL,
0x0000000840467824ULL, 0x000fe200078e00ffULL, 0xfffffff844407812ULL, 0x000fe200078ee239ULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff846427812ULL, 0x000fe200078ee23bULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000006314147212ULL, 0x000fc600078efcffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x000000143d147210ULL, 0x040fe40007f1e0ffULL,
0x000000633a3a7212ULL, 0x080fe200078efcffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000006338387212ULL, 0x080fe400078efcffULL, 0x0000003a3d3a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000115157824ULL, 0x000fe200000e063fULL, 0x0000006312127212ULL, 0x000fe200078efcffULL,
0x000000103c0f7824ULL, 0x000fe200078e0269ULL, 0x000000383d387210ULL, 0x000fe20007f1e0ffULL,
0x000000013b3b7824ULL, 0x000fe200010e063fULL, 0x000000123d127210ULL, 0x000fe20007f7e0ffULL,
0x000000103e3d7824ULL, 0x000fe200078e0269ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140f7faeULL, 0x0003e2000b901c46ULL, 0x0000000139397824ULL, 0x000fc400000e063fULL,
0x0000000113137824ULL, 0x000fe200018e063fULL, 0x000000003a3d7faeULL, 0x0003e2000b901c46ULL,
0x00000010403f7824ULL, 0x100fe400078e0269ULL, 0x0000001042417824ULL, 0x000fc600078e0269ULL,
0x00000000383f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012417faeULL, 0x0003e4000b901c46ULL,
0x0000000800147824ULL, 0x002fe200078e00ffULL, 0x0000000302127810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0f7424ULL, 0x000fc600078e00ffULL, 0xfffffff014147812ULL, 0x000fe400078ec0ffULL,
0x000000761200720cULL, 0x000fe40003f06070ULL, 0x00000000140473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000000179128824ULL, 0x000fc400078e0212ULL,
0x00000004ff138424ULL, 0x000fc800078e00ffULL, 0x0000660012128625ULL, 0x000fca00078e0013ULL,
0x00000006120f8981ULL, 0x000522000c1e1900ULL, 0x000176b004047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x0176b00014127f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176480007147f8cULL, 0x0022e4000c80043fULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x01764c00073b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x00afe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01764c00073b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000077824ULL, 0x000fca00078e00ffULL,
0xffffff8007147812ULL, 0x000fc800078ec0ffULL, 0x0000010063077810ULL, 0x000fca0007ffe014ULL,
0x0000000174077824ULL, 0x000fca00078e0207ULL, 0x0170000007397984ULL, 0x000e680000000800ULL,
0x0172000007387984ULL, 0x0006a20000000800ULL, 0x0000000e3900720bULL, 0x002fe20003f1d000ULL,
0x0000fcf27f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff3c407812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff3a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fd200078e000eULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x000000027b077810ULL, 0x000fe40007ffe0ffULL,
0x0000000e3900720bULL, 0x000fe40003f54000ULL, 0x000000000700720cULL, 0x000fe20003f05270ULL,
0x0000fca27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000077806ULL, 0x000fc400010e0100ULL,
0x0000008000158824ULL, 0x000fe200078e0263ULL, 0x0000000e39148209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x00000001743b8824ULL, 0x000fe200078e0215ULL,
0x0000991007157816ULL, 0x000fc800000000ffULL, 0x017400143b008388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000e39157209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff07ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000e15147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x00000014003a7308ULL, 0x000e640000000800ULL,
0x0000003a0d0d7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x000fe20000011603ULL, 0x0000fbd27f007947ULL, 0x000fea000b800000ULL,
0x00001f143a3c7589ULL, 0x0002e400000e0000ULL, 0x0000003c18187220ULL, 0x08cfe40000410000ULL,
0x0000003c19197220ULL, 0x080fe40000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe40000410000ULL,
0x0000003c1d1d7220ULL, 0x000fc40000410000ULL, 0x0000003c20207220ULL, 0x080fe40000410000ULL,
0x0000003c21217220ULL, 0x080fe40000410000ULL, 0x0000003c24247220ULL, 0x080fe40000410000ULL,
0x0000003c25257220ULL, 0x080fe40000410000ULL, 0x0000003c28287220ULL, 0x080fe40000410000ULL,
0x0000003c29297220ULL, 0x000fc40000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe40000410000ULL,
0x0000003c2d2d7220ULL, 0x080fe40000410000ULL, 0x0000003c30307220ULL, 0x080fe40000410000ULL,
0x0000003c31317220ULL, 0x080fe40000410000ULL, 0x0000003c34347220ULL, 0x080fe40000410000ULL,
0x0000003c35357220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0007ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803147811ULL, 0x002fe200078ff0ffULL, 0x0000fad27f007947ULL, 0x000fea000b800000ULL,
0x00001f143a3c7589ULL, 0x0002e400000e0000ULL, 0x0000003c1a1a7220ULL, 0x08cfe40000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe40000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe40000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe40000410000ULL, 0x0000003c22227220ULL, 0x080fe40000410000ULL,
0x0000003c23237220ULL, 0x000fc40000410000ULL, 0x0000003c26267220ULL, 0x080fe40000410000ULL,
0x0000003c27277220ULL, 0x080fe40000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe40000410000ULL,
0x0000003c2b2b7220ULL, 0x080fe40000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe40000410000ULL,
0x0000003c2f2f7220ULL, 0x000fc40000410000ULL, 0x0000003c32327220ULL, 0x080fe40000410000ULL,
0x0000003c33337220ULL, 0x080fe40000410000ULL, 0x0000003c36367220ULL, 0x080fe40000410000ULL,
0x0000003c37377220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff40ff7812ULL, 0x000fe20007806007ULL, 0x00000001ff3a7424ULL, 0x000fe200078e00ffULL,
0x0000000e39077209ULL, 0x000fd60007810000ULL, 0x8000000739390221ULL, 0x000fe20000010000ULL,
0x00007610ff3a0816ULL, 0x000fc6000000003aULL, 0x3fb8aa3b39390820ULL, 0x000fc80000410000ULL,
0x0000003900080308ULL, 0x000e640000000800ULL, 0x0000000838380220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000d380d7221ULL, 0x004fc40000010000ULL,
0x0000000000147805ULL, 0x000fca0000015200ULL, 0x00000008000e7824ULL, 0x000fca00078e00ffULL,
0xfffffff00e3c7812ULL, 0x000fca00078ec0ffULL, 0x0176ac003c397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x00000038143b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e15ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc80000011439ULL, 0x0000003b0e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x000000020e0e7819ULL, 0x000fc80000001239ULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac003c397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099103a0e7816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0e00720cULL, 0x000fda0003fc5270ULL,
0x0000016000006947ULL, 0x000fea0003800000ULL, 0x00000008ff09723eULL, 0x000fe400000010ffULL,
0x00000002ff177819ULL, 0x000fe40000011603ULL, 0x00005410090e7816ULL, 0x000fe20000000009ULL,
0x0000f6a27f007947ULL, 0x000fea000b800000ULL, 0x00001f170e097589ULL, 0x0002a400000e0000ULL,
0x0000000817147810ULL, 0x000fe20007ffe0ffULL, 0x0000f6f27f007947ULL, 0x000fea000b800000ULL,
0x00001f140e0a7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001017147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e000eULL,
0x00009e00003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000fef000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001817147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e000eULL, 0x00009e70003d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x004fc400078e00ffULL,
0x0000fe8000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100c147824ULL, 0x108fe200078e0265ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001011407824ULL, 0x100fe400078e0265ULL, 0x000000100b387824ULL, 0x000fe400078e0265ULL,
0x000000001414783bULL, 0x002e680000004200ULL, 0x000000004040783bULL, 0x000ee80000004200ULL,
0x000000003838783bULL, 0x000ea20000004200ULL, 0x00000018ff477819ULL, 0x002fc40000011417ULL,
0x00000018ff467819ULL, 0x000fe40000011415ULL, 0x00000018ff0c7819ULL, 0x008fe20000011440ULL,
0x00000047005b7306ULL, 0x000fe20000209400ULL, 0x00000018ff447819ULL, 0x000fe40000011442ULL,
0x00000018ff5a7819ULL, 0x004fe40000011438ULL, 0x00000018ff117819ULL, 0x000fe40000011441ULL,
0x00000018ff6b7819ULL, 0x000fe20000011439ULL, 0x00000047005c7306ULL, 0x000ff00000205400ULL,
0x0000004700577306ULL, 0x000ff0000020d400ULL, 0x0000004000477306ULL, 0x000ff00000009400ULL,
0x0000004000667306ULL, 0x000e700000005400ULL, 0x0000000c00607306ULL, 0x000ff00000209400ULL,
0x0000000c00457306ULL, 0x000ea20000205400ULL, 0x000000664700720bULL, 0x002fce0003f7d000ULL,
0x0000000c00597306ULL, 0x0002f0000020d400ULL, 0x0000004400517306ULL, 0x000fe20000209400ULL,
0x00000018ff0c7819ULL, 0x002fe40000011443ULL, 0x000000456000720bULL, 0x004fe20003f9d000ULL,
0x0000010041607824ULL, 0x000fc800078e00ffULL, 0x0000004400527306ULL, 0x000e620000205400ULL,
0x00000018ff717819ULL, 0x000fce0000011460ULL, 0x0000004400507306ULL, 0x000462000020d400ULL,
0x0000000159594812ULL, 0x008fce00078efcffULL, 0x00000041005f7306ULL, 0x000fe20000009400ULL,
0x00000018ff447819ULL, 0x004fe40000011416ULL, 0x000000525100720bULL, 0x002fca0003f9d000ULL,
0x00000041006c7306ULL, 0x000e700000005400ULL, 0x0000004600547306ULL, 0x000fe20000209400ULL,
0x0000000150504812ULL, 0x000fce00078efcffULL, 0x0000004600557306ULL, 0x000fe20000205400ULL,
0x0000006c5f00720bULL, 0x002fe20003f5d000ULL, 0x00010000415f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe2000001145fULL, 0x0000004600617306ULL, 0x0003f0000020d400ULL,
0x0000000c00567306ULL, 0x000fe20000209400ULL, 0x0001000040467824ULL, 0x002fca00078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe40000011446ULL, 0x0000000c00537306ULL, 0x000ff00000205400ULL,
0x0000000c004c7306ULL, 0x000ff0000020d400ULL, 0x00000044000b7306ULL, 0x000ff00000209400ULL,
0x00000044000c7306ULL, 0x000ff00000205400ULL, 0x0000004400587306ULL, 0x0003f0000020d400ULL,
0x0000006e00467306ULL, 0x000fe20000209400ULL, 0x0000010040447824ULL, 0x002fca00078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011444ULL, 0x0000006e00477306ULL, 0x000e700000205400ULL,
0x00000067005d7306ULL, 0x000ff00000209400ULL, 0x00000067005e7306ULL, 0x000ea20000205400ULL,
0x000000474600720bULL, 0x002fce0003fbd000ULL, 0x0000006e00667306ULL, 0x000e70000020d400ULL,
0x0000005a004a7306ULL, 0x000fe20000209400ULL, 0x0000005e5d00720bULL, 0x004fce0003f1d000ULL,
0x0000005a004b7306ULL, 0x000fe20000205400ULL, 0x0000000166665812ULL, 0x002fce00078efcffULL,
0x0000005a004d7306ULL, 0x000ff0000020d400ULL, 0x0000006c005f7306ULL, 0x000ff00000209400ULL,
0x0000006c00607306ULL, 0x000e700000205400ULL, 0x0000006700447306ULL, 0x000eb0000020d400ULL,
0x00000040005a7306ULL, 0x000ee2000000d400ULL, 0x000000605f00720bULL, 0x002fce0003fbd000ULL,
0x0000007100407306ULL, 0x000fe20000209400ULL, 0x0000000144440812ULL, 0x004fce00078efcffULL,
0x00000071006f7306ULL, 0x000e620000205400ULL, 0x000000015a5a3812ULL, 0x008fc800078efcffULL,
0x0000005a4444723eULL, 0x000fc600000010ffULL, 0x0000004100457306ULL, 0x0004f0000000d400ULL,
0x00000011003c7306ULL, 0x000fe20000209400ULL, 0x0000010042417824ULL, 0x004fe200078e00ffULL,
0x0000006f4000720bULL, 0x002fe20003f1d000ULL, 0x0000010043407824ULL, 0x000fc600078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe40000011441ULL, 0x00000011003d7306ULL, 0x000e620000205400ULL,
0x00000018ff6f7819ULL, 0x000fe40000011440ULL, 0x0000000145452812ULL, 0x008fca00078efcffULL,
0x0000006c00677306ULL, 0x000eb0000020d400ULL, 0x0000006e00417306ULL, 0x000fe20000209400ULL,
0x0000003d3c00720bULL, 0x002fce0003f7d000ULL, 0x0000006e005e7306ULL, 0x000e620000205400ULL,
0x0000000167675812ULL, 0x004fce00078efcffULL, 0x00000011000e7306ULL, 0x0004f0000020d400ULL,
0x00000042003c7306ULL, 0x000fe20000009400ULL, 0x00000018ff117819ULL, 0x004fe40000011414ULL,
0x0000005e4100720bULL, 0x002fe20003fbd000ULL, 0x00010000435e7824ULL, 0x000fc800078e00ffULL,
0x00000011003f7306ULL, 0x000fe20000209400ULL, 0x000000010e0e3812ULL, 0x008fe400078efcffULL,
0x00000018ff5e7819ULL, 0x000fca000001145eULL, 0x00000011003e7306ULL, 0x000e700000205400ULL,
0x00000042003d7306ULL, 0x000eb00000005400ULL, 0x0000006e00477306ULL, 0x0006e2000020d400ULL,
0x0000003e3f00720bULL, 0x002fce0003f5d000ULL, 0x0000006f00407306ULL, 0x000fe20000209400ULL,
0x0000003d3c00720bULL, 0x004fe20003f7d000ULL, 0x00000010103c7824ULL, 0x000fe200078e0265ULL,
0x00000018ff6e7819ULL, 0x008fca000001143bULL, 0x0000006f005d7306ULL, 0x000e620000205400ULL,
0x0000000147475812ULL, 0x000fce00078efcffULL, 0x00000042005f7306ULL, 0x0004f0000000d400ULL,
0x0000006f00467306ULL, 0x0006e2000020d400ULL, 0x0001000042427824ULL, 0x004fe200078e00ffULL,
0x0000005d4000720bULL, 0x002fcc0003fbd000ULL, 0x00000043003e7306ULL, 0x000fe20000009400ULL,
0x00000018ff6f7819ULL, 0x008fe40000011442ULL, 0x000000015f5f3812ULL, 0x000fca00078efcffULL,
0x00000043003f7306ULL, 0x000e620000005400ULL, 0x0000000146465812ULL, 0x000fce00078efcffULL,
0x0000006f00417306ULL, 0x000ff00000209400ULL, 0x0000006f00407306ULL, 0x000ea20000205400ULL,
0x0000003f3e00720bULL, 0x002fe40003f7d000ULL, 0x000000003c3c783bULL, 0x000e6a0000004200ULL,
0x0000004300607306ULL, 0x0006e2000000d400ULL, 0x000000404100720bULL, 0x004fce0003fbd000ULL,
0x0000005e006c7306ULL, 0x000fe20000209400ULL, 0x012000004940783bULL, 0x008ea20000000200ULL,
0x0000000160603812ULL, 0x000fcc00078efcffULL, 0x0000001100627306ULL, 0x000ee2000020d400ULL,
0x000000555400720bULL, 0x000fce0003f7d000ULL, 0x0000005e00557306ULL, 0x000e6c0000205400ULL,
0x0000000161613812ULL, 0x000fe400078efcffULL, 0x0000006b004f7306ULL, 0x000fe20000209400ULL,
0x0000000162622812ULL, 0x008fe400078efcffULL, 0x00000018ff757819ULL, 0x002fca000001143fULL,
0x0000006b004e7306ULL, 0x000fe20000205400ULL, 0x000000556c00720bULL, 0x000fe20003f9d000ULL,
0x00000100146c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x0000006b00117306ULL, 0x000fe2000020d400ULL, 0x000000094040e231ULL, 0x084fe400003400ffULL,
0x000000094242e231ULL, 0x000fe400003400ffULL, 0x0000000a4141e231ULL, 0x080fe400003400ffULL,
0x0000000a4343e231ULL, 0x000fe200003400ffULL, 0x00000071006b7306ULL, 0x0002b0000020d400ULL,
0x0000005e005e7306ULL, 0x000ee2000020d400ULL, 0x00000018ff717819ULL, 0x002fc4000001143dULL,
0x000000016b6b0812ULL, 0x004fca00078efcffULL, 0x0000006c005a7306ULL, 0x000fe20000209400ULL,
0x000000535600720bULL, 0x000fe40003f1d000ULL, 0x000000456b45723eULL, 0x000fe400000010ffULL,
0x00000018ff567819ULL, 0x000fe4000001143aULL, 0x000000015e5e4812ULL, 0x008fe200078efcffULL,
0x0000006c006b7306ULL, 0x000e640000205400ULL, 0x000000444018723cULL, 0x000be80000041818ULL,
0x000000014c4c0812ULL, 0x000fc400078efcffULL, 0x0000006c00497306ULL, 0x0004e2000020d400ULL,
0x000000665944723eULL, 0x020fe400000010ffULL, 0x000000670e45723eULL, 0x000fca00000010ffULL,
0x0000006f005d7306ULL, 0x0006e2000020d400ULL, 0x00000100156c7824ULL, 0x004fe200078e00ffULL,
0x0000006b5a00720bULL, 0x002fe20003f9d000ULL, 0x00000044401c723cULL, 0x000b66000004181cULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x00000014005a7306ULL, 0x000fe20000009400ULL,
0x00000018ff6f7819ULL, 0x008fcc000001143cULL, 0x0000000149494812ULL, 0x000fe200078efcffULL,
0x00000014006b7306ULL, 0x000e620000005400ULL, 0x000000015d5d5812ULL, 0x000fe400078efcffULL,
0x0000000c0b00720bULL, 0x000fca0003fbd000ULL, 0x0000006c000e7306ULL, 0x000ff00000209400ULL,
0x0000006c00457306ULL, 0x020ea20000205400ULL, 0x0000006b5a00720bULL, 0x002fe40003f1d000ULL,
0x0000000158585812ULL, 0x000fca00078efcffULL, 0x0000001400667306ULL, 0x0002f0000000d400ULL,
0x0000006f00547306ULL, 0x000fe20000209400ULL, 0x0001000014147824ULL, 0x002fe200078e00ffULL,
0x000000450e00720bULL, 0x004fc40003f9d000ULL, 0x000000604645723eULL, 0x000fc800000010ffULL,
0x0000006f00557306ULL, 0x000fe20000205400ULL, 0x0000000166660812ULL, 0x008fce00078efcffULL,
0x0000006f000b7306ULL, 0x0003f0000020d400ULL, 0x0000005600517306ULL, 0x000fe20000209400ULL,
0x00000018ff6f7819ULL, 0x002fce0000011414ULL, 0x0000005600527306ULL, 0x000ff00000205400ULL,
0x0000005600107306ULL, 0x000ff0000020d400ULL, 0x0000006e00537306ULL, 0x000ff00000209400ULL,
0x0000006e00567306ULL, 0x000ff00000205400ULL, 0x0000006e000c7306ULL, 0x000ff0000020d400ULL,
0x0000001500677306ULL, 0x000ff00000009400ULL, 0x0000001500447306ULL, 0x000e700000005400ULL,
0x0000006c006b7306ULL, 0x000eb0000020d400ULL, 0x0000006f00147306ULL, 0x000fe20000209400ULL,
0x000000446700720bULL, 0x002fc40003f1d000ULL, 0x0000005f4744723eULL, 0x000fe200000010ffULL,
0x0001000015477824ULL, 0x000fc800078e00ffULL, 0x0000006f006e7306ULL, 0x000e620000205400ULL,
0x000000016b6b4812ULL, 0x004fce00078efcffULL, 0x00000015006c7306ULL, 0x0004e2000000d400ULL,
0x0000006e1400720bULL, 0x002fe20003f9d000ULL, 0x0000010016147824ULL, 0x000fcc00078e00ffULL,
0x0000006f00677306ULL, 0x000262000020d400ULL, 0x00000018ff157819ULL, 0x004fe40000011447ULL,
0x000000444044723cULL, 0x000be20000041820ULL, 0x000000016c6c0812ULL, 0x008fc800078efcffULL,
0x0000001600237306ULL, 0x020fe20000009400ULL, 0x00000018ff6f7819ULL, 0x002fe40000011414ULL,
0x0000005d5014723eULL, 0x000fca00000010ffULL, 0x0000001600507306ULL, 0x000e620000005400ULL,
0x0000000167674812ULL, 0x000fce00078efcffULL, 0x0000001500607306ULL, 0x000ff00000209400ULL,
0x00000015005f7306ULL, 0x000ea20000205400ULL, 0x000000502300720bULL, 0x002fe20003f5d000ULL,
0x0000010017237824ULL, 0x000fca00078e00ffULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x0000006f00217306ULL, 0x000ff00000209400ULL, 0x0000006f006e7306ULL, 0x000e620000205400ULL,
0x0000005f6000720bULL, 0x004fce0003f1d000ULL, 0x0000001500227306ULL, 0x0004f0000020d400ULL,
0x0000006f00207306ULL, 0x0006e2000020d400ULL, 0x0000005e4c15723eULL, 0x004fe400000010ffULL,
0x0000006e2100720bULL, 0x002fc40003f9d000ULL, 0x00000018ff6e7819ULL, 0x000fc6000001143eULL,
0x000000144024723cULL, 0x000b620000041824ULL, 0x00010000166f7824ULL, 0x008fe200078e00ffULL,
0x0000001700147306ULL, 0x020fe20000009400ULL, 0x0000000122220812ULL, 0x000fc600078efcffULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000000120204812ULL, 0x000fe400078efcffULL,
0x00000017005d7306ULL, 0x000e700000005400ULL, 0x0000002300157306ULL, 0x000ff00000209400ULL,
0x00000023004c7306ULL, 0x000ea20000205400ULL, 0x0000005d1400720bULL, 0x002fc40003f1d000ULL,
0x000000664914723eULL, 0x000fca00000010ffULL, 0x0000007100597306ULL, 0x000ff00000209400ULL,
0x00000071005a7306ULL, 0x000fe20000205400ULL, 0x0000004c1500720bULL, 0x004fe40003f7d000ULL,
0x0000006c6b15723eULL, 0x000fca00000010ffULL, 0x00000071000e7306ULL, 0x000ff0000020d400ULL,
0x0000001600217306ULL, 0x000e70000000d400ULL, 0x0000006f00167306ULL, 0x000ff00000209400ULL,
0x0000006f00717306ULL, 0x000ea20000205400ULL, 0x0000000121212812ULL, 0x002fc400078efcffULL,
0x0000005c5b00720bULL, 0x000fca0003f5d000ULL, 0x0000006e005f7306ULL, 0x000ff00000209400ULL,
0x0000006e00607306ULL, 0x000fe20000205400ULL, 0x000000711600720bULL, 0x004fe40003f9d000ULL,
0x0000000157572812ULL, 0x000fca00078efcffULL, 0x0000006e00507306ULL, 0x0003f0000020d400ULL,
0x0000002300237306ULL, 0x000ea2000020d400ULL, 0x00010000176e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x0000001700667306ULL, 0x0002f0000000d400ULL,
0x0000006e006b7306ULL, 0x000fe20000209400ULL, 0x000000144014723cULL, 0x002be20000041828ULL,
0x0000000123233812ULL, 0x004fcc00078efcffULL, 0x0000006e006c7306ULL, 0x000e620000205400ULL,
0x000000676228723eULL, 0x020fe400000010ffULL, 0x000000226129723eULL, 0x000fe200000010ffULL,
0x0000010038227824ULL, 0x000fe200078e00ffULL, 0x0000000166660812ULL, 0x008fc600078efcffULL,
0x0000006f00497306ULL, 0x000ea2000020d400ULL, 0x00000018ff717819ULL, 0x000fe20000011422ULL,
0x000000284028723cULL, 0x000b6c000004182cULL, 0x0000006e00627306ULL, 0x000ee2000020d400ULL,
0x00000021202c723eULL, 0x020fe400000010ffULL, 0x0000006c6b00720bULL, 0x002fc40003f1d000ULL,
0x00000066232d723eULL, 0x000fc600000010ffULL, 0x0000003800207306ULL, 0x000fe20000009400ULL,
0x0000000149494812ULL, 0x004fc600078efcffULL, 0x0000002c402c723cULL, 0x000b680000041830ULL,
0x00000038005c7306ULL, 0x000e620000005400ULL, 0x0000000162620812ULL, 0x008fe400078efcffULL,
0x000000495830723eULL, 0x020fe200000010ffULL, 0x0001000038327824ULL, 0x000fe200078e00ffULL,
0x000000625731723eULL, 0x000fc600000010ffULL, 0x0000003800217306ULL, 0x000ea2000000d400ULL,
0x00000018ff577819ULL, 0x000fc60000011432ULL, 0x000000304030723cULL, 0x000b680000041834ULL,
0x00000039006b7306ULL, 0x000fe20000009400ULL, 0x0000005c2000720bULL, 0x002fe40003f1d000ULL,
0x0000010039347824ULL, 0x060fe400078e00ffULL, 0x0001000039357824ULL, 0x000fc600078e00ffULL,
0x0000003900497306ULL, 0x000e620000005400ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff357819ULL, 0x000fc60000011435ULL, 0x0000000121210812ULL, 0x004fe400078efcffULL,
0x0000004b4a00720bULL, 0x000fe20003f1d000ULL, 0x0000003900237306ULL, 0x0004e2000000d400ULL,
0x000000496b00720bULL, 0x002fce0003f5d000ULL, 0x0000005700387306ULL, 0x000fe20000209400ULL,
0x012000004848783bULL, 0x000e620000000200ULL, 0x000001003a397824ULL, 0x004fe400078e00ffULL,
0x000000014d4d0812ULL, 0x000fe400078efcffULL, 0x0000004e4f00720bULL, 0x000fe40003f1d000ULL,
0x0000005700437306ULL, 0x000ea20000205400ULL, 0x00000018ff427819ULL, 0x000fe40000011439ULL,
0x0000000123232812ULL, 0x008fca00078efcffULL, 0x0000003a00397306ULL, 0x000fe60000009400ULL,
0x0000000111110812ULL, 0x000fe400078efcffULL, 0x000000565300720bULL, 0x000fc60003f1d000ULL,
0x0000003a00207306ULL, 0x000ee20000005400ULL, 0x000000433800720bULL, 0x004fce0003f7d000ULL,
0x0000007100227306ULL, 0x000fe40000209400ULL, 0x000000010c0c0812ULL, 0x000fcc00078efcffULL,
0x0000007100677306ULL, 0x000ea20000205400ULL, 0x000000203900720bULL, 0x008fe20003fbd000ULL,
0x000100003a207824ULL, 0x000fe200078e00ffULL, 0x000000094848e231ULL, 0x082fe400003400ffULL,
0x000000094a4ae231ULL, 0x000fe400003400ffULL, 0x00000018ff397819ULL, 0x000fe20000011420ULL,
0x0000005700367306ULL, 0x000e62000020d400ULL, 0x000100003b207824ULL, 0x000fe200078e00ffULL,
0x0000000a4949e231ULL, 0x000fc400003400ffULL, 0x0000000a4b4be231ULL, 0x000fe400003400ffULL,
0x00000018ff6b7819ULL, 0x000fe40000011420ULL, 0x0000003400407306ULL, 0x000fe20000209400ULL,
0x000000672200720bULL, 0x004fce0003f9d000ULL, 0x00000034006f7306ULL, 0x000ea20000205400ULL,
0x0000000136363812ULL, 0x002fc800078efcffULL, 0x000000364d36723eULL, 0x000fc600000010ffULL,
0x0000004200627306ULL, 0x000ff00000209400ULL, 0x0000004200667306ULL, 0x000e620000205400ULL,
0x0000006f4000720bULL, 0x004fce0003f7d000ULL, 0x00000035006c7306ULL, 0x000ff00000209400ULL,
0x00000035006e7306ULL, 0x000ea20000205400ULL, 0x000000666200720bULL, 0x002fce0003fdd000ULL,
0x00000034005b7306ULL, 0x0002f0000020d400ULL, 0x0000004200577306ULL, 0x000ee2000020d400ULL,
0x000001003b347824ULL, 0x002fe200078e00ffULL, 0x0000006e6c00720bULL, 0x004fc80003f5d000ULL,
0x00000018ff5c7819ULL, 0x000fe40000011434ULL, 0x0000003b00227306ULL, 0x000fe20000009400ULL,
0x000000015b5b3812ULL, 0x008fe400078efcffULL, 0x000000525100720bULL, 0x000fe20003f7d000ULL,
0x000100003d527824ULL, 0x000fe200078e00ffULL, 0x000000235b23723eULL, 0x000fc600000010ffULL,
0x0000003b00437306ULL, 0x000fe20000005400ULL, 0x0000000157576812ULL, 0x000fe400078efcffULL,
0x00000018ff527819ULL, 0x000fca0000011452ULL, 0x0000003b00427306ULL, 0x0003e2000000d400ULL,
0x0000000110103812ULL, 0x000fe400078efcffULL, 0x000000555400720bULL, 0x000fca0003f7d000ULL,
0x0000007100617306ULL, 0x000ea2000020d400ULL, 0x000001003c3b7824ULL, 0x002fce00078e00ffULL,
0x00000075005d7306ULL, 0x000fe20000209400ULL, 0x000000010b0b3812ULL, 0x000fe400078efcffULL,
0x000000605f00720bULL, 0x000fca0003f7d000ULL, 0x00000075005e7306ULL, 0x000fe20000205400ULL,
0x0000000161614812ULL, 0x004fe400078efcffULL, 0x000000432200720bULL, 0x000fca0003f9d000ULL,
0x00000075004c7306ULL, 0x0003e2000020d400ULL, 0x0000000150503812ULL, 0x000fce00078efcffULL,
0x0000005c00417306ULL, 0x000fe20000209400ULL, 0x00000018ff757819ULL, 0x002fe4000001143bULL,
0x0000000142424812ULL, 0x000fca00078efcffULL, 0x0000005c00347306ULL, 0x000e700000205400ULL,
0x0000003500377306ULL, 0x000eb0000020d400ULL, 0x0000003c003b7306ULL, 0x000fe20000009400ULL,
0x000000344100720bULL, 0x002fe20003fdd000ULL, 0x000001003e347824ULL, 0x000fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000003c004e7306ULL, 0x000e620000005400ULL,
0x0000000137372812ULL, 0x004fc800078efcffULL, 0x000000371137723eULL, 0x000fc600000010ffULL,
0x0000005c00357306ULL, 0x000ea8000020d400ULL, 0x00000036481c723cULL, 0x000f68000004181cULL,
0x0000003a00587306ULL, 0x000ee2000000d400ULL, 0x0000004e3b00720bULL, 0x002fe20003f5d000ULL,
0x000100003c3b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x00000039003a7306ULL, 0x000fe20000209400ULL, 0x0000000135356812ULL, 0x004fce00078efcffULL,
0x00000039005c7306ULL, 0x000e620000205400ULL, 0x0000000158585812ULL, 0x008fce00078efcffULL,
0x0000006b00207306ULL, 0x000ff00000209400ULL, 0x0000006b00227306ULL, 0x000ea20000205400ULL,
0x0000005c3a00720bULL, 0x002fce0003fbd000ULL, 0x0000003900437306ULL, 0x0002f0000020d400ULL,
0x0000007500677306ULL, 0x000fe20000209400ULL, 0x000001003d397824ULL, 0x002fe200078e00ffULL,
0x000000222000720bULL, 0x004fe20003fdd000ULL, 0x000001003f227824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000075006f7306ULL, 0x000e620000205400ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x0000000143435812ULL, 0x008fc800078efcffULL,
0x000000431010723eULL, 0x000fe200000010ffULL, 0x0000003d00517306ULL, 0x000ff00000009400ULL,
0x0000003d006e7306ULL, 0x000ea20000005400ULL, 0x0000006f6700720bULL, 0x002fce0003f9d000ULL,
0x0000006b00387306ULL, 0x000e70000020d400ULL, 0x00000039006b7306ULL, 0x000fe20000209400ULL,
0x0000006e5100720bULL, 0x004fce0003fbd000ULL, 0x0000003900717306ULL, 0x000ea20000205400ULL,
0x0000000138386812ULL, 0x002fc800078efcffULL, 0x000000380c11723eULL, 0x000fc600000010ffULL,
0x0000003b006c7306ULL, 0x000fe80000209400ULL, 0x000000104824723cULL, 0x000b680000041824ULL,
0x0000003b00537306ULL, 0x000e620000205400ULL, 0x000000716b00720bULL, 0x004fe40003fdd000ULL,
0x000176c873107811ULL, 0x020fca00078e18ffULL, 0x0000003c004f7306ULL, 0x000eb0000000d400ULL,
0x0000003f00547306ULL, 0x000fe20000009400ULL, 0x000000536c00720bULL, 0x002fe20003f1d000ULL,
0x000100003e537824ULL, 0x000fca00078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000003f00557306ULL, 0x000e620000005400ULL, 0x000000014f4f2812ULL, 0x004fce00078efcffULL,
0x0000007500407306ULL, 0x000eb0000020d400ULL, 0x0000003d003c7306ULL, 0x000ee2000000d400ULL,
0x000000555400720bULL, 0x002fe20003f5d000ULL, 0x000100003f547824ULL, 0x000fcc00078e00ffULL,
0x0000003e00207306ULL, 0x000fe20000009400ULL, 0x0000000140404812ULL, 0x004fce00078efcffULL,
0x0000003e003d7306ULL, 0x000e620000005400ULL, 0x000000013c3c5812ULL, 0x008fe400078efcffULL,
0x0000005a5900720bULL, 0x000fca0003fbd000ULL, 0x0000003900397306ULL, 0x000eb0000020d400ULL,
0x0000003b004e7306ULL, 0x000ee2000020d400ULL, 0x0000003d2000720bULL, 0x002fe40003f9d000ULL,
0x000000010e0e5812ULL, 0x000fca00078efcffULL, 0x0000005200627306ULL, 0x000fe20000209400ULL,
0x0000000139396812ULL, 0x004fce00078efcffULL, 0x0000005200667306ULL, 0x000e620000205400ULL,
0x000000014e4e0812ULL, 0x008fc800078efcffULL, 0x0000004e0b4e723eULL, 0x000fe200000010ffULL,
0x00000002000b7824ULL, 0x000fe400078e00ffULL, 0x00000052003a7306ULL, 0x000ea6000020d400ULL,
0xfffffff80b0c7812ULL, 0x000fca00078ec0ffULL, 0x0000003400567306ULL, 0x000fe20000209400ULL,
0x000000666200720bULL, 0x002fce0003fdd000ULL, 0x00000034005c7306ULL, 0x000e6c0000205400ULL,
0x000000013a3a6812ULL, 0x004fe400078efcffULL, 0x00000034003b7306ULL, 0x000ea2000020d400ULL,
0x0000005e5d00720bULL, 0x000fce0003fdd000ULL, 0x0000002200527306ULL, 0x000fe20000209400ULL,
0x0000005c5600720bULL, 0x002fca0003f1d000ULL, 0x000000014c4c6812ULL, 0x000fe400078efcffULL,
0x0000002200517306ULL, 0x000e6c0000205400ULL, 0x000000013b3b0812ULL, 0x004fe400078efcffULL,
0x0000002200347306ULL, 0x0005f0000020d400ULL, 0x0000003e00417306ULL, 0x000ee2000000d400ULL,
0x000000216122723eULL, 0x004fc400000010ffULL, 0x000000515200720bULL, 0x002fca0003fbd000ULL,
0x000000224820723cULL, 0x000b620000041818ULL, 0x0000003f003d7306ULL, 0x000e6c000000d400ULL,
0x00000018ff1a7819ULL, 0x020fe40000011454ULL, 0x00000053003e7306ULL, 0x000fe20000209400ULL,
0x0000000141414812ULL, 0x008fc400078efcffULL, 0x000000585718723eULL, 0x000fe400000010ffULL,
0x000000423519723eULL, 0x000fe400000010ffULL, 0x0000000134345812ULL, 0x000fe200078efcffULL,
0x00000053003f7306ULL, 0x000ea20000205400ULL, 0x000000013d3d2812ULL, 0x002fc600078efcffULL,
0x000000184844723cULL, 0x000b620000041844ULL, 0x0000003d343d723eULL, 0x000fc600000010ffULL,
0x0000001a001b7306ULL, 0x000fe60000209400ULL, 0x0000004f4018723eULL, 0x020fe400000010ffULL,
0x0000003c3919723eULL, 0x000fe400000010ffULL, 0x0000003a0e4f723eULL, 0x000fe200000010ffULL,
0x0000001a00367306ULL, 0x000e620000205400ULL, 0x0000003f3e00720bULL, 0x004fe40003f1d000ULL,
0x000000413b3c723eULL, 0x000fc600000010ffULL, 0x0000004e4828723cULL, 0x040b640000041828ULL,
0x0000005300537306ULL, 0x000eac000020d400ULL, 0x0000003c482c723cULL, 0x000b64000004182cULL,
0x0000001a00517306ULL, 0x0006e2000020d400ULL, 0x000000361b00720bULL, 0x002fc40003f9d000ULL,
0x0000000153530812ULL, 0x004fc600078efcffULL, 0x000000184818723cULL, 0x008b620000041814ULL,
0x000000535050723eULL, 0x000fce00000010ffULL, 0x0000000151514812ULL, 0x000fc800078efcffULL,
0x000000514c51723eULL, 0x000fce00000010ffULL, 0x000000504830723cULL, 0x000b620000041830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000010107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x017698000cff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff0b7224ULL, 0x000fc600078e00ffULL,
0x0000000000147805ULL, 0x020fc80000015200ULL, 0x0000040006177984ULL, 0x000ee40000000800ULL,
0x8000000017ff7812ULL, 0x00afe40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x004fc80000011417ULL,
0x000000350c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x000000020c0c7819ULL, 0x000fc80000001217ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040006177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000105117810ULL, 0x000fe40007ffe0ffULL, 0x0000000302027810ULL, 0x000fe40007ffe0ffULL,
0x000000781100720cULL, 0x000fda0003f06070ULL, 0x0000086000000947ULL, 0x000fea0003800000ULL,
0x00000002050b7810ULL, 0x000fe20007ffe0ffULL, 0x00000020730c7824ULL, 0x004fe400078e00ffULL,
0x000059000f027a24ULL, 0x010fe200078e02ffULL, 0x000000780b00720cULL, 0x000fe20003f06070ULL,
0x00000100110e7824ULL, 0x000fe400078e020cULL, 0x0000004002027824ULL, 0x000fc600078e00ffULL,
0x000000200e0c7812ULL, 0x000fca00078ec0ffULL, 0x00000001770c7824ULL, 0x000fe400078e020cULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x0000000e700b7217ULL, 0x000fe20007800000ULL,
0x00000010000f7824ULL, 0x000fc800078e00ffULL, 0x000000010b0b7824ULL, 0x000fe200078e0a0eULL,
0x000000100f0e7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011603ULL,
0x0000000b0e0b7217ULL, 0x000fe40007800000ULL, 0x000000040f107810ULL, 0x040fe40007ffe0ffULL,
0x000000080f147810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x100fe200078e0a0eULL,
0x0000000c0f167810ULL, 0x000fe20007ffe0ffULL, 0x0000000110117824ULL, 0x000fc400078e020eULL,
0x0000000114157824ULL, 0x100fe200078e020eULL, 0x0000000b0f00720cULL, 0x0c0fe20003f86070ULL,
0x000000010f0f7824ULL, 0x000fe200078e020eULL, 0x0000000b1000720cULL, 0x080fe20003f66070ULL,
0x0000000811377824ULL, 0x000fe200078e00ffULL, 0x0000000b1400720cULL, 0x080fe20003f46070ULL,
0x000000010f107824ULL, 0x140fe200078e0203ULL, 0x0000000b1600720cULL, 0x000fe20003f06070ULL,
0x000000080f357824ULL, 0x000fe400078e00ffULL, 0x0000000111147824ULL, 0x000fc400078e0203ULL,
0x0000000116177824ULL, 0x000fe200078e020eULL, 0xfffffff835347812ULL, 0x000fe200078ee210ULL,
0x000000010f0e7824ULL, 0x000fe200078e020cULL, 0xfffffff837367812ULL, 0x000fe200078ee214ULL,
0x0000000111107824ULL, 0x100fe400078e020cULL, 0x00000001150b7824ULL, 0x040fe400078e0203ULL,
0x0000000815387824ULL, 0x040fe400078e00ffULL, 0x0000000115147824ULL, 0x000fc400078e020cULL,
0x0000000117157824ULL, 0x040fe400078e0203ULL, 0x00000008173a7824ULL, 0x000fe400078e00ffULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000630e0e7212ULL, 0x000fc600078efcffULL, 0x0000000117167824ULL, 0x000fe200078e020cULL,
0xfffffff8380c7812ULL, 0x000fe200078ee20bULL, 0x0000001036377824ULL, 0x000fe200078e0265ULL,
0x00006400020b7a11ULL, 0x000fe200078a38ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0xfffffff83a387812ULL, 0x000fe400078ee215ULL, 0x0000006310107212ULL, 0x000fe200078efcffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000650002357a11ULL, 0x000fe400028f3cffULL,
0x0000000e0b0e7210ULL, 0x000fe20007fbe0ffULL, 0x000000100c397824ULL, 0x000fe200078e0265ULL,
0x0000000b10107210ULL, 0x000fc40007fde0ffULL, 0x0000006314147212ULL, 0x080fe200078efcffULL,
0x000000010f0f7824ULL, 0x100fe200028e0635ULL, 0x0000006316167212ULL, 0x000fe200078efcffULL,
0x0000000111117824ULL, 0x000fe200030e0635ULL, 0x0000000b14147210ULL, 0x080fe40007fbe0ffULL,
0x0000000b16167210ULL, 0x000fe20007fde0ffULL, 0x00000010340b7824ULL, 0x000fe400078e0265ULL,
0x0000000115157824ULL, 0x000fe400028e0635ULL, 0x0000001038657824ULL, 0x000fe200078e0265ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0b7faeULL, 0x0003e2000e101c46ULL,
0x0000000117177824ULL, 0x000fc600030e0635ULL, 0x0000000010377faeULL, 0x0003e8000d901c46ULL,
0x0000000014397faeULL, 0x0003e8000d101c46ULL, 0x0000000016657faeULL, 0x0003e2000c101c46ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x00000010000b7824ULL, 0x000fca00078e00ffULL,
0x000000100b0e7812ULL, 0x000fc800078ec0ffULL, 0x0000000e030e7211ULL, 0x000fc800078fe8ffULL,
0x000000040e0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000010e0b7824ULL, 0x040fe200078e0203ULL,
0x000000080e117810ULL, 0x040fe20007ffe0ffULL, 0x000000080e347824ULL, 0x040fe200078e00ffULL,
0x0000000c0e157810ULL, 0x040fe20007ffe0ffULL, 0x000000010e107824ULL, 0x100fe400078e020cULL,
0x000000010f0e7824ULL, 0x040fe200078e020cULL, 0xfffffff834347812ULL, 0x000fe200078ee20bULL,
0x000000010f0b7824ULL, 0x040fe400078e0203ULL, 0x000000080f367824ULL, 0x000fc400078e00ffULL,
0x0000000111167824ULL, 0x040fe400078e020cULL, 0x00000001110f7824ULL, 0x040fe400078e0203ULL,
0x0000000811387824ULL, 0x000fe400078e00ffULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000115177824ULL, 0x040fe200078e0203ULL, 0x0000006310107212ULL, 0x000fe200078efcffULL,
0x00000008153a7824ULL, 0x040fe400078e00ffULL, 0x0000000115147824ULL, 0x000fe200078e020cULL,
0xfffffff8360c7812ULL, 0x000fe400078ee20bULL, 0x00006400020b7a11ULL, 0x000fe200078038ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffff838367812ULL, 0x000fe400078ee20fULL,
0xfffffff83a387812ULL, 0x000fe200078ee217ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000650002357a11ULL, 0x000fc400000f3cffULL, 0x000000100b107210ULL, 0x000fe20007f1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x000000630e0e7212ULL, 0x080fe400078efcffULL,
0x0000006314147212ULL, 0x080fe200078efcffULL, 0x0000000111117824ULL, 0x000fe200000e0635ULL,
0x0000006316167212ULL, 0x000fe200078efcffULL, 0x000000100c377824ULL, 0x100fe200078e0265ULL,
0x0000000e0b0e7210ULL, 0x040fe20007f1e0ffULL, 0x0000001036397824ULL, 0x000fe200078e0265ULL,
0x000000160b167210ULL, 0x000fc40007f5e0ffULL, 0x000000140b147210ULL, 0x000fe20007f7e0ffULL,
0x00000010340b7824ULL, 0x000fe400078e0265ULL, 0x000000010f0f7824ULL, 0x100fe400000e0635ULL,
0x0000000117177824ULL, 0x000fe200010e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100b7faeULL, 0x0003e2000b901c46ULL, 0x0000001038657824ULL, 0x000fe400078e0265ULL,
0x0000000115157824ULL, 0x000fe200018e0635ULL, 0x000000000e377faeULL, 0x0003e8000b901c46ULL,
0x0000000016397faeULL, 0x0003e8000b901c46ULL, 0x0000000014657faeULL, 0x0003e4000b901c46ULL,
0x0000000472027810ULL, 0x000fe20007ffe0ffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0xffffffffff0f7424ULL, 0x002fc400078e00ffULL, 0x000000760200720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00000001790e7824ULL, 0x000fe400078e0202ULL,
0x00000004ff0f7424ULL, 0x000fc800078e00ffULL, 0x000066000e0e7625ULL, 0x000fcc00078e000fULL,
0x000000060e0f7981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008000b7824ULL, 0x000fca00078e00ffULL, 0xfffffff00b0b7812ULL, 0x000fc800078ec0ffULL,
0x000000000b0473c2ULL, 0x000ee200000e0000ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000176a804047890ULL, 0x008fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a8000b107f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176680004167f8cULL, 0x0002a4000c80043fULL, 0x000000ffff0b7224ULL, 0x00cfc400078e0011ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0x01766c0004157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x004fe40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410357210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc80000011415ULL, 0x000000350c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x000000020c0c7819ULL, 0x000fc80000001215ULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01766c0004157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001807b0c7811ULL, 0x000fc800078e38ffULL,
0x0000000c740c7210ULL, 0x000fca0007ffe063ULL, 0x017000000c0e7984ULL, 0x000e680000000800ULL,
0x017200000c107984ULL, 0x0004e20000000800ULL, 0x000000070e00720bULL, 0x002fe20003f1d000ULL,
0x0000c9927f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x004fc800000e0100ULL,
0x0000ffff3c347812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff167424ULL, 0x000fe400078e00ffULL, 0x000000ffff0c7224ULL, 0x000fd200078e0007ULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x000000037b117810ULL, 0x000fe40007ffe0ffULL,
0x000000070e00720bULL, 0x000fe40003f54000ULL, 0x000000001100720cULL, 0x000fe20003f05270ULL,
0x0000c9427f007947ULL, 0x000fd4000b800000ULL, 0x0000000000117806ULL, 0x000fc400010e0100ULL,
0x0000008000638824ULL, 0x000fe200078e0263ULL, 0x000000070e0c7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991011147816ULL, 0x000fe200000000ffULL,
0x0000000174638824ULL, 0x000fca00078e0263ULL, 0x0174000c63008388ULL, 0x0003e20000000800ULL,
0x000000ff1400720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x000000070c077221ULL, 0x002fe20000010100ULL, 0x000000ff11ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b07077820ULL, 0x000fc80000410000ULL,
0x0000000700167308ULL, 0x000e640000000800ULL, 0x000000160d0d7220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x000fe20000011603ULL,
0x0000c8827f007947ULL, 0x000fea000b800000ULL, 0x00001f14163c7589ULL, 0x0002a400000e0000ULL,
0x0000003c20207220ULL, 0x084fe40000410000ULL, 0x0000003c21217220ULL, 0x080fe40000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe40000410000ULL, 0x0000003c1d1d7220ULL, 0x080fe40000410000ULL,
0x0000003c44447220ULL, 0x080fe40000410000ULL, 0x0000003c45457220ULL, 0x000fc40000410000ULL,
0x0000003c24247220ULL, 0x080fe40000410000ULL, 0x0000003c25257220ULL, 0x080fe40000410000ULL,
0x0000003c18187220ULL, 0x080fe40000410000ULL, 0x0000003c19197220ULL, 0x080fe40000410000ULL,
0x0000003c28287220ULL, 0x080fe40000410000ULL, 0x0000003c29297220ULL, 0x000fc40000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000003c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000003c30307220ULL, 0x080fe40000410000ULL, 0x0000003c31317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0011ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803147811ULL, 0x002fe200078ff0ffULL,
0x0000c7827f007947ULL, 0x000fea000b800000ULL, 0x00001f14163c7589ULL, 0x0002a400000e0000ULL,
0x0000003c22227220ULL, 0x084fe40000410000ULL, 0x0000003c23237220ULL, 0x080fe40000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe40000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe40000410000ULL,
0x0000003c46467220ULL, 0x080fe40000410000ULL, 0x0000003c47477220ULL, 0x000fc40000410000ULL,
0x0000003c26267220ULL, 0x080fe40000410000ULL, 0x0000003c27277220ULL, 0x080fe40000410000ULL,
0x0000003c1a1a7220ULL, 0x080fe40000410000ULL, 0x0000003c1b1b7220ULL, 0x080fe40000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe40000410000ULL, 0x0000003c2b2b7220ULL, 0x000fc40000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe40000410000ULL, 0x0000003c2f2f7220ULL, 0x080fe40000410000ULL,
0x0000003c32327220ULL, 0x080fe40000410000ULL, 0x0000003c33337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff34ff7812ULL, 0x000fe20007806011ULL,
0x00000001ff167424ULL, 0x000fd800078e00ffULL, 0x0000000e0c0e0221ULL, 0x000fe20000010100ULL,
0x00007610ff160816ULL, 0x000fc60000000016ULL, 0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL,
0x0000000e00080308ULL, 0x000e640000000800ULL, 0x0000000810100220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000d100d7221ULL, 0x008fc40000010000ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0x0000000800077824ULL, 0x000fca00078e00ffULL,
0xfffffff007177812ULL, 0x000fca00078ec0ffULL, 0x0176b40017077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x00000014100e7210ULL, 0x000fca0007f1e1ffULL, 0x0000000115147824ULL, 0x000fe200000e0e11ULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff077819ULL, 0x000fc80000011414ULL, 0x0000000e07077211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e0614ULL, 0x0000000207077819ULL, 0x000fc8000000120eULL,
0x000000070000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176b40017077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991016077816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0700720cULL, 0x000fda0003f65270ULL,
0x0000016000003947ULL, 0x000fea0003800000ULL, 0x00000008ff07723eULL, 0x000fe400000010ffULL,
0x00000002ff0e7819ULL, 0x000fe40000011603ULL, 0x0000541007077816ULL, 0x000fe20000000007ULL,
0x0000c3627f007947ULL, 0x000fea000b800000ULL, 0x00001f0e07097589ULL, 0x0002a400000e0000ULL,
0x000000080e147810ULL, 0x000fe20007ffe0ffULL, 0x0000c3b27f007947ULL, 0x000fea000b800000ULL,
0x00001f14070a7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100e147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e0007ULL,
0x0000d3a0003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000c95000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180e147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e0007ULL, 0x0000d410003d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x004fc400078e00ffULL,
0x0000c8e000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000008007b147824ULL, 0x048fe200078e026dULL,
0x000000037b137810ULL, 0x000fc40007ffe0ffULL, 0x000000006464783bULL, 0x000ee20000004200ULL,
0x000000026a6a7810ULL, 0x000fc60007ffe0ffULL, 0x000000006834783bULL, 0x000ea20000004200ULL,
0x00000018ff077819ULL, 0x00afe20000011464ULL, 0x0000006400167306ULL, 0x000fe20000009400ULL,
0x00000018ff157819ULL, 0x000fe20000011466ULL, 0x00010000665f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff177819ULL, 0x000fe20000011467ULL, 0x0000010067527824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x004fe40000011436ULL, 0x00000018ff0e7819ULL, 0x000fe20000011465ULL,
0x0000006400417306ULL, 0x000e620000005400ULL, 0x00000018ff3b7819ULL, 0x000fc40000011435ULL,
0x00000018ff627819ULL, 0x000fe40000011452ULL, 0x00000018ff4f7819ULL, 0x000fc60000011437ULL,
0x0000000700107306ULL, 0x000ff00000209400ULL, 0x00000007006c7306ULL, 0x000ea20000205400ULL,
0x000000411600720bULL, 0x002fce0003fdd000ULL, 0x0000000700427306ULL, 0x0002f0000020d400ULL,
0x0000001500127306ULL, 0x000fe20000209400ULL, 0x00000018ff077819ULL, 0x002fe40000011434ULL,
0x0000006c1000720bULL, 0x004fca0003fbd000ULL, 0x00000007003e7306ULL, 0x000ff00000209400ULL,
0x00000007003f7306ULL, 0x000fe20000205400ULL, 0x0000000142425812ULL, 0x008fce00078efcffULL,
0x00000007005e7306ULL, 0x0003f0000020d400ULL, 0x0000001500117306ULL, 0x000fe20000205400ULL,
0x0000010064077824ULL, 0x002fce00078e00ffULL, 0x0000001500567306ULL, 0x0003f0000020d400ULL,
0x0000001700517306ULL, 0x000fe20000209400ULL, 0x00000018ff157819ULL, 0x002fce0000011407ULL,
0x0000001700557306ULL, 0x000ff00000205400ULL, 0x0000001700577306ULL, 0x0003f0000020d400ULL,
0x0000006400387306ULL, 0x0004e2000000d400ULL, 0x0000010065177824ULL, 0x002fca00078e00ffULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x00000066006e7306ULL, 0x000fe20000009400ULL,
0x0001000064647824ULL, 0x004fca00078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x00000066006f7306ULL, 0x000e620000005400ULL, 0x0000000138386812ULL, 0x008fce00078efcffULL,
0x0000001500407306ULL, 0x000ff00000209400ULL, 0x0000001500597306ULL, 0x000ea20000205400ULL,
0x0000006f6e00720bULL, 0x002fce0003fdd000ULL, 0x0000001500077306ULL, 0x0002f0000020d400ULL,
0x0000001700717306ULL, 0x000fe20000209400ULL, 0x0000010066157824ULL, 0x002fe200078e00ffULL,
0x000000594000720bULL, 0x004fc80003f9d000ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000001700727306ULL, 0x000e6e0000205400ULL, 0x0000000107074812ULL, 0x008fe200078efcffULL,
0x0000006400587306ULL, 0x000fe60000209400ULL, 0x000000380738723eULL, 0x000fca00000010ffULL,
0x0000006400757306ULL, 0x000ea20000205400ULL, 0x000000727100720bULL, 0x002fce0003f5d000ULL,
0x0000006400507306ULL, 0x0002f0000020d400ULL, 0x0000006500617306ULL, 0x000fe20000009400ULL,
0x00000018ff647819ULL, 0x002fe2000001145fULL, 0x00010000675f7824ULL, 0x000fe200078e00ffULL,
0x000000755800720bULL, 0x004fe20003f1d000ULL, 0x0000010034587824ULL, 0x000fc800078e00ffULL,
0x0000006500637306ULL, 0x000e620000005400ULL, 0x00000018ff747819ULL, 0x000fce0000011458ULL,
0x0000006500397306ULL, 0x000462000000d400ULL, 0x0000000150500812ULL, 0x008fce00078efcffULL,
0x0000004900437306ULL, 0x000fe20000209400ULL, 0x0001000065657824ULL, 0x004fe200078e00ffULL,
0x000000636100720bULL, 0x002fc80003f9d000ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000049004c7306ULL, 0x000fee0000205400ULL, 0x0000000139394812ULL, 0x000fe200078efcffULL,
0x00000049004b7306ULL, 0x000ff0000020d400ULL, 0x00000015005c7306ULL, 0x000ff00000209400ULL,
0x00000015005b7306ULL, 0x000ff00000205400ULL, 0x0000001500497306ULL, 0x000ff0000020d400ULL,
0x00000066006d7306ULL, 0x0002b0000000d400ULL, 0x0000006400157306ULL, 0x000fe20000209400ULL,
0x00000018ff667819ULL, 0x002fce000001145fULL, 0x0000006400167306ULL, 0x000e620000205400ULL,
0x000000016d6d6812ULL, 0x004fce00078efcffULL, 0x0000000e004e7306ULL, 0x000ff00000209400ULL,
0x0000000e004d7306ULL, 0x000ea20000205400ULL, 0x000000161500720bULL, 0x002fce0003fdd000ULL,
0x0000003b003d7306ULL, 0x000ff00000209400ULL, 0x0000003b003c7306ULL, 0x000fe20000205400ULL,
0x0000004d4e00720bULL, 0x004fce0003fbd000ULL, 0x0000003b005d7306ULL, 0x000ff0000020d400ULL,
0x00000017003b7306ULL, 0x000e70000020d400ULL, 0x0000006500607306ULL, 0x000ff00000209400ULL,
0x00000065005a7306ULL, 0x000ea20000205400ULL, 0x000000013b3b2812ULL, 0x002fc800078efcffULL,
0x000000393b39723eULL, 0x000fc600000010ffULL, 0x0000006200177306ULL, 0x000ff00000209400ULL,
0x0000006200547306ULL, 0x000fe20000205400ULL, 0x0000005a6000720bULL, 0x004fe20003f5d000ULL,
0x00010000345a7824ULL, 0x000fcc00078e00ffULL, 0x0000006200527306ULL, 0x000ff0000020d400ULL,
0x0000006400417306ULL, 0x000e70000020d400ULL, 0x00000066005f7306ULL, 0x000ff00000209400ULL,
0x0000006600627306ULL, 0x000ea20000205400ULL, 0x0000000141416812ULL, 0x002fce00078efcffULL,
0x0000000e00487306ULL, 0x000e70000020d400ULL, 0x0000004f000e7306ULL, 0x000fe20000209400ULL,
0x000000625f00720bULL, 0x004fce0003fdd000ULL, 0x0000004f003a7306ULL, 0x000fe20000205400ULL,
0x0000000148485812ULL, 0x002fe400078efcffULL, 0x000000541700720bULL, 0x000fe20003fbd000ULL,
0x0000010035177824ULL, 0x000fe200078e00ffULL, 0x0000000703547812ULL, 0x000fc600078ec0ffULL,
0x0000004f004a7306ULL, 0x000fe2000020d400ULL, 0x0000000854547812ULL, 0x000fce00078ef803ULL,
0x00000065004f7306ULL, 0x000e62000020d400ULL, 0x0000000152525812ULL, 0x000fe400078efcffULL,
0x000000111200720bULL, 0x000fca0003fbd000ULL, 0x0000006700687306ULL, 0x000ff00000009400ULL,
0x00000067006b7306ULL, 0x000ea20000005400ULL, 0x000000014f4f2812ULL, 0x002fe400078efcffULL,
0x0000005b5c00720bULL, 0x000fc40003f5d000ULL, 0x0000000156565812ULL, 0x000fe400078efcffULL,
0x0000003f3e00720bULL, 0x000fe20003fbd000ULL, 0x0000006600407306ULL, 0x000e62000020d400ULL,
0x000000415656723eULL, 0x000fce00000010ffULL, 0x0000006700537306ULL, 0x000ee2000000d400ULL,
0x0000006b6800720bULL, 0x004fe40003f1d000ULL, 0x00000018ff687819ULL, 0x000fe20000011417ULL,
0x0000000854177824ULL, 0x000fe200078e00ffULL, 0x0000000149492812ULL, 0x000fe400078efcffULL,
0x000000015e5e5812ULL, 0x000fe200078efcffULL, 0x0000003400677306ULL, 0x000fe20000009400ULL,
0x0000000140406812ULL, 0x002fe400078efcffULL, 0x0000003c3d00720bULL, 0x000fe20003fdd000ULL,
0x00000004003c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8176a7812ULL, 0x000fc400078ee26aULL,
0x012800001414783bULL, 0x000e620000000200ULL, 0x00000034006c7306ULL, 0x000ea20000005400ULL,
0x000000043c3c7812ULL, 0x000fe400078ec0ffULL, 0x0000000153530812ULL, 0x008fe400078efcffULL,
0x000000023c3c7812ULL, 0x000fe400078efcffULL, 0x000000555100720bULL, 0x000fe20003f1d000ULL,
0x0000003500107306ULL, 0x000fe20000009400ULL, 0x0000010036517824ULL, 0x000fe200078e00ffULL,
0x0000003a0e00720bULL, 0x000fc40003fbd000ULL, 0x000000015d5d6812ULL, 0x000fe400078efcffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000003500667306ULL, 0x000ee20000005400ULL,
0x0000006c6700720bULL, 0x004fe40003f9d000ULL, 0x00000018ff677819ULL, 0x000fe4000001145aULL,
0x0000000157570812ULL, 0x000fe400078efcffULL, 0x000000014a4a5812ULL, 0x000fe200078efcffULL,
0x0000003500637306ULL, 0x000462000000d400ULL, 0x000000405757723eULL, 0x000fc400000010ffULL,
0x000000661000720bULL, 0x008fe20003f5d000ULL, 0x0001000035357824ULL, 0x004fc800078e00ffULL,
0x0000007400587306ULL, 0x000fe20000209400ULL, 0x0000008013107824ULL, 0x000fe200078e026aULL,
0x00000008036a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x000000091414b231ULL, 0x082fe200003400ffULL, 0x000000076a6a7812ULL, 0x000fe200078ef803ULL,
0x000000091616b231ULL, 0x000fe200003400ffULL, 0x0000003500547306ULL, 0x000fe20000209400ULL,
0x0001100010107811ULL, 0x000fe200078e20ffULL, 0x0000000a1515b231ULL, 0x080fe200003400ffULL,
0x000000086a3d7824ULL, 0x000fe200078e00ffULL, 0x0000000163632812ULL, 0x000fe200078efcffULL,
0x0000000a1717b231ULL, 0x000fc400003400ffULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x00000035006c7306ULL, 0x000fe80000205400ULL, 0x000000381438723cULL, 0x040b680000041820ULL,
0x0000003500627306ULL, 0x0005e6000020d400ULL, 0x000000504220723eULL, 0x020fe200000010ffULL,
0x000000561424723cULL, 0x000fe20000041824ULL, 0x0000004f4821723eULL, 0x000fc600000010ffULL,
0x0000007400597306ULL, 0x000ee20000205400ULL, 0x0000010037357824ULL, 0x004fc600078e00ffULL,
0x00000020141c723cULL, 0x000b64000004181cULL, 0x00000018ff6b7819ULL, 0x000fe40000011435ULL,
0x0000003c03357211ULL, 0x000fe200078fe0ffULL, 0x00000067005a7306ULL, 0x000fe40000209400ULL,
0x0000006d4920723eULL, 0x020fe400000010ffULL, 0x000000016a3c7824ULL, 0x040fe200078e0235ULL,
0x000000106a6a7812ULL, 0x000fc400078efcffULL, 0x000000595800720bULL, 0x008fe20003f1d000ULL,
0x0000006700607306ULL, 0x000ea20000205400ULL, 0xfffffff83d3c7812ULL, 0x000fe200078ee23cULL,
0x000000016a357824ULL, 0x000fe200078e0235ULL, 0x000000535221723eULL, 0x000fc600000010ffULL,
0x000000103c3c7824ULL, 0x000fe200078e0269ULL, 0x000000091010b231ULL, 0x082fe200003400ffULL,
0x0000006700617306ULL, 0x000e62000020d400ULL, 0x000000091212b231ULL, 0x000fe400003400ffULL,
0x0000000a1111b231ULL, 0x080fe200003400ffULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x0000000a1313b231ULL, 0x000fc600003400ffULL, 0x00000068005b7306ULL, 0x000fe20000209400ULL,
0x000000605a00720bULL, 0x004fce0003f7d000ULL, 0x00000068005c7306ULL, 0x000eac0000205400ULL,
0x0000000161613812ULL, 0x002fe400078efcffULL, 0x0000006800667306ULL, 0x000e62000020d400ULL,
0x0000004c4300720bULL, 0x000fce0003f7d000ULL, 0x0000007400647306ULL, 0x000e62000020d400ULL,
0x0000005c5b00720bULL, 0x004fca0003f5d000ULL, 0x000000014b4b3812ULL, 0x000fe400078efcffULL,
0x0000003400657306ULL, 0x000ea2000000d400ULL, 0x000001003c567824ULL, 0x008fe200078e00ffULL,
0x00000018ff227819ULL, 0x000fc8000001143eULL, 0x0000000166662812ULL, 0x002fe400078efcffULL,
0x0000005100677306ULL, 0x000fe20000209400ULL, 0x0000000164640812ULL, 0x000fe400078efcffULL,
0x0000006c5400720bULL, 0x000fe40003f5d000ULL, 0x00000018ff6c7819ULL, 0x000fe40000011456ULL,
0x000000636657723eULL, 0x000fe200000010ffULL, 0x0000005100687306ULL, 0x000e620000205400ULL,
0x0000000165654812ULL, 0x004fe200078efcffULL, 0x000001003d667824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fc4000001143dULL, 0x000000656456723eULL, 0x000fe400000010ffULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x0000005100597306ULL, 0x000ea2000020d400ULL,
0x0000000162622812ULL, 0x000fe400078efcffULL, 0x00000018ff487819ULL, 0x000fe2000001143fULL,
0x000000561038723cULL, 0x000be80000041838ULL, 0x0000003700347306ULL, 0x000fe20000009400ULL,
0x000000686700720bULL, 0x002fc40003f5d000ULL, 0x000000615e56723eULL, 0x020fe400000010ffULL,
0x000000625d57723eULL, 0x000fc600000010ffULL, 0x0000003700517306ULL, 0x000e680000005400ULL,
0x00000056101c723cULL, 0x000fe4000004181cULL, 0x0000000159592812ULL, 0x004fe400078efcffULL,
0x00000036004e7306ULL, 0x000ff00000009400ULL, 0x00000036004d7306ULL, 0x000ea20000005400ULL,
0x000000513400720bULL, 0x002fe20003f1d000ULL, 0x0001000037347824ULL, 0x000fca00078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011434ULL, 0x000000086a347824ULL, 0x000fe200078e00ffULL,
0x0000006b005f7306ULL, 0x000fe80000209400ULL, 0xfffffff834347812ULL, 0x000fe400078ee235ULL,
0x0000004d4e00720bULL, 0x004fe40003f9d000ULL, 0x0000006b00607306ULL, 0x000e620000205400ULL,
0x00010000364d7824ULL, 0x000fc400078e00ffULL, 0x0000001034347824ULL, 0x000fc600078e0269ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144dULL, 0x0000003600587306ULL, 0x000eb0000000d400ULL,
0x00000037005a7306ULL, 0x0006a2000000d400ULL, 0x000000605f00720bULL, 0x002fe20003fdd000ULL,
0x000100003c607824ULL, 0x000fcc00078e00ffULL, 0x0000005100727306ULL, 0x000fe20000209400ULL,
0x000000003434783bULL, 0x008e620000004200ULL, 0x0000000158584812ULL, 0x004fc800078efcffULL,
0x000000585958723eULL, 0x000fe400000010ffULL, 0x0000005100717306ULL, 0x000ea20000205400ULL,
0x000000015a5a0812ULL, 0x000fce00078efcffULL, 0x0000006b00557306ULL, 0x000ef0000020d400ULL,
0x0000004e006f7306ULL, 0x000fe20000209400ULL, 0x000000717200720bULL, 0x004fce0003f1d000ULL,
0x0000004e006e7306ULL, 0x000ea20000205400ULL, 0x0000000155556812ULL, 0x008fc800078efcffULL,
0x0000005a5559723eULL, 0x000fc600000010ffULL, 0x0000006c00677306ULL, 0x000fe20000209400ULL,
0x00000018ff6d7819ULL, 0x002fe40000011435ULL, 0x00000018ff747819ULL, 0x000fe40000011434ULL,
0x00000018ff757819ULL, 0x000fe40000011436ULL, 0x00000018ff407819ULL, 0x000fe20000011437ULL,
0x0000006c00687306ULL, 0x000e620000205400ULL, 0x0000006e6f00720bULL, 0x004fe40003f9d000ULL,
0x00000018ff6e7819ULL, 0x000fca0000011460ULL, 0x0000004e004d7306ULL, 0x0004f0000020d400ULL,
0x00000051004c7306ULL, 0x000ee2000020d400ULL, 0x00000018ff4e7819ULL, 0x004fe4000001143cULL,
0x000000686700720bULL, 0x002fca0003fdd000ULL, 0x0000004e006b7306ULL, 0x000fe20000209400ULL,
0x000000014d4d4812ULL, 0x008fce00078efcffULL, 0x0000004e006a7306ULL, 0x000e620000205400ULL,
0x000000014c4c0812ULL, 0x000fce00078efcffULL, 0x0000004e00077306ULL, 0x000eb0000020d400ULL,
0x0000002200517306ULL, 0x000fe20000209400ULL, 0x0000006a6b00720bULL, 0x002fce0003f9d000ULL,
0x00000022004e7306ULL, 0x000fec0000205400ULL, 0x0000000107074812ULL, 0x004fe400078efcffULL,
0x0000002200427306ULL, 0x0003f0000020d400ULL, 0x0000006c00637306ULL, 0x000ea2000020d400ULL,
0x000000201420723cULL, 0x002f6e0000041844ULL, 0x0000003c005e7306ULL, 0x000ff00000009400ULL,
0x0000003c00617306ULL, 0x000e620000005400ULL, 0x0000000163636812ULL, 0x004fce00078efcffULL,
0x0000003d005f7306ULL, 0x000fe20000009400ULL, 0x000000581020723cULL, 0x020bee0000041820ULL,
0x0000003d00567306ULL, 0x000ea20000005400ULL, 0x000000615e00720bULL, 0x002fe20003f1d000ULL,
0x000100003f617824ULL, 0x000fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000006600647306ULL, 0x000ff00000209400ULL, 0x0000006600657306ULL, 0x000e620000205400ULL,
0x000000565f00720bULL, 0x004fe20003f5d000ULL, 0x000100003e567824ULL, 0x000fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x0000003c005d7306ULL, 0x0004f0000000d400ULL,
0x0000004300697306ULL, 0x000fe20000209400ULL, 0x000100003d3c7824ULL, 0x004fe200078e00ffULL,
0x000000656400720bULL, 0x002fc80003fdd000ULL, 0x00000018ff6f7819ULL, 0x000fe2000001143cULL,
0x000001003e3c7824ULL, 0x000fe200078e00ffULL, 0x00000043000e7306ULL, 0x000e620000205400ULL,
0x000000015d5d0812ULL, 0x008fc600078efcffULL, 0x00000018ff727819ULL, 0x000fe4000001143cULL,
0x0000004d4b3c723eULL, 0x000fe400000010ffULL, 0x0000006600667306ULL, 0x000eb0000020d400ULL,
0x0000006f00557306ULL, 0x000fe20000209400ULL, 0x0000000e6900720bULL, 0x002fe20003f9d000ULL,
0x00000100360e7824ULL, 0x000fcc00078e00ffULL, 0x0000006f005a7306ULL, 0x000e620000205400ULL,
0x0000000166666812ULL, 0x004fce00078efcffULL, 0x0000006e00607306ULL, 0x000ff00000209400ULL,
0x0000006e00627306ULL, 0x000ea20000205400ULL, 0x0000005a5500720bULL, 0x002fce0003fdd000ULL,
0x0000006e006c7306ULL, 0x000e70000020d400ULL, 0x0000003d00577306ULL, 0x000662000000d400ULL,
0x000000626000720bULL, 0x004fe20003f1d000ULL, 0x0001000034627824ULL, 0x000fca00078e00ffULL,
0x00000018ff627819ULL, 0x000fe20000011462ULL, 0x0000003e006e7306ULL, 0x000fe20000009400ULL,
0x0000004c4a3d723eULL, 0x008fe200000010ffULL, 0x000001003f4a7824ULL, 0x000fc800078e00ffULL,
0x000000016c6c0812ULL, 0x002fe400078efcffULL, 0x0000003e00717306ULL, 0x000e620000005400ULL,
0x0000003c1024723cULL, 0x000be20000041824ULL, 0x0000000157572812ULL, 0x000fcc00078efcffULL,
0x0000003f005e7306ULL, 0x000ff00000009400ULL, 0x0000003f005f7306ULL, 0x000ea20000005400ULL,
0x000000716e00720bULL, 0x002fce0003f7d000ULL, 0x0000006f00587306ULL, 0x0202f0000020d400ULL,
0x0000004300437306ULL, 0x000ee2000020d400ULL, 0x00000018ff6f7819ULL, 0x002fe4000001144aULL,
0x0000005f5e00720bULL, 0x004fe20003fbd000ULL, 0x00000100345f7824ULL, 0x000fc800078e00ffULL,
0x0000006d00527306ULL, 0x000fe20000209400ULL, 0x0000000158586812ULL, 0x008fe400078efcffULL,
0x00000018ff687819ULL, 0x000fca000001145fULL, 0x0000006d00537306ULL, 0x000fe20000205400ULL,
0x0000000143434812ULL, 0x000fce00078efcffULL, 0x0000006d00447306ULL, 0x000ff0000020d400ULL,
0x0000006f004c7306ULL, 0x000ff00000209400ULL, 0x0000006f004d7306ULL, 0x000e700000205400ULL,
0x00000072006d7306ULL, 0x000ff00000209400ULL, 0x0000007200597306ULL, 0x000ea20000205400ULL,
0x0000004d4c00720bULL, 0x002fce0003f9d000ULL, 0x0000003f003d7306ULL, 0x000e70000000d400ULL,
0x00000061003f7306ULL, 0x000fe20000209400ULL, 0x000000596d00720bULL, 0x004fce0003fdd000ULL,
0x00000061006e7306ULL, 0x000fe20000205400ULL, 0x000000013d3d5812ULL, 0x002fce00078efcffULL,
0x00000061005e7306ULL, 0x000ff0000020d400ULL, 0x0000003500617306ULL, 0x000ff00000009400ULL,
0x00000035005a7306ULL, 0x000e700000005400ULL, 0x0000006f004a7306ULL, 0x000eb0000020d400ULL,
0x0000003400647306ULL, 0x000fe20000009400ULL, 0x0000005a6100720bULL, 0x002fe20003f1d000ULL,
0x0001000035617824ULL, 0x000fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000003400657306ULL, 0x000e620000005400ULL, 0x000000014a4a4812ULL, 0x004fe400078efcffULL,
0x0000006e3f00720bULL, 0x000fe40003f9d000ULL, 0x0000003d4a3d723eULL, 0x000fc600000010ffULL,
0x00000072004b7306ULL, 0x000eb0000020d400ULL, 0x0000003e003c7306ULL, 0x000ee2000000d400ULL,
0x000000656400720bULL, 0x002fe40003f5d000ULL, 0x000000015e5e4812ULL, 0x000fca00078efcffULL,
0x00000056006f7306ULL, 0x000fe20000209400ULL, 0x000000014b4b6812ULL, 0x004fce00078efcffULL,
0x0000005600717306ULL, 0x000e620000205400ULL, 0x000000013c3c3812ULL, 0x008fe400078efcffULL,
0x0000004e5100720bULL, 0x000fe40003f7d000ULL, 0x0000003c4b3c723eULL, 0x000fc600000010ffULL,
0x0000004800507306ULL, 0x000ff00000209400ULL, 0x00000048004f7306ULL, 0x000ea20000205400ULL,
0x000000716f00720bULL, 0x002fe40003fdd000ULL, 0x0000000142423812ULL, 0x000fca00078efcffULL,
0x00000056003e7306ULL, 0x0002f0000020d400ULL, 0x00000074005c7306ULL, 0x000fe20000209400ULL,
0x0000010035567824ULL, 0x002fe200078e00ffULL, 0x0000004f5000720bULL, 0x004fe20003fbd000ULL,
0x0001000036507824ULL, 0x000fca00078e00ffULL, 0x00000074005b7306ULL, 0x000fe20000205400ULL,
0x000000013e3e6812ULL, 0x008fe400078efcffULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000003e4242723eULL, 0x000fc600000010ffULL, 0x0000007400497306ULL, 0x0003f0000020d400ULL,
0x0000003500557306ULL, 0x0004e2000000d400ULL, 0x00000018ff747819ULL, 0x002fce0000011456ULL,
0x0000007500477306ULL, 0x000fe20000209400ULL, 0x00000018ff357819ULL, 0x004fe2000001140eULL,
0x00000100370e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001140eULL,
0x0000007500547306ULL, 0x000fe20000205400ULL, 0x0000000155550812ULL, 0x008fe400078efcffULL,
0x000000535200720bULL, 0x000fca0003f1d000ULL, 0x0000007500417306ULL, 0x000ff0000020d400ULL,
0x00000074006a7306ULL, 0x000fe20000209400ULL, 0x0000000144440812ULL, 0x000fce00078efcffULL,
0x00000074006b7306ULL, 0x000e700000205400ULL, 0x0000007400567306ULL, 0x000eb0000020d400ULL,
0x0000003400607306ULL, 0x000ee2000000d400ULL, 0x0000006b6a00720bULL, 0x002fce0003f7d000ULL,
0x0000006800727306ULL, 0x000fec0000209400ULL, 0x0000000156563812ULL, 0x004fe400078efcffULL,
0x0000006800677306ULL, 0x000e620000205400ULL, 0x0000000160602812ULL, 0x008fce00078efcffULL,
0x0000006200747306ULL, 0x000ff00000209400ULL, 0x0000006200757306ULL, 0x000ea20000205400ULL,
0x000000677200720bULL, 0x002fce0003fdd000ULL, 0x0000004800487306ULL, 0x000e70000020d400ULL,
0x0000003500647306ULL, 0x000fe20000209400ULL, 0x000000757400720bULL, 0x004fce0003f5d000ULL,
0x0000003500657306ULL, 0x000fe20000205400ULL, 0x0000000148485812ULL, 0x002fce00078efcffULL,
0x00000035004c7306ULL, 0x000ff0000020d400ULL, 0x0000003600347306ULL, 0x000ff00000009400ULL,
0x0000003600357306ULL, 0x000e700000005400ULL, 0x00000037003f7306ULL, 0x000ff00000009400ULL,
0x00000037006e7306ULL, 0x000ea20000005400ULL, 0x000000353400720bULL, 0x002fc40003f9d000ULL,
0x0000005d6334723eULL, 0x000fe400000010ffULL, 0x000000576635723eULL, 0x000fc600000010ffULL,
0x00000068005f7306ULL, 0x000e68000020d400ULL, 0x000000341418723cULL, 0x000fe80000041818ULL,
0x00000062005a7306ULL, 0x000ee2000020d400ULL, 0x0000006e3f00720bULL, 0x004fe20003fbd000ULL,
0x00010000373f7824ULL, 0x000fcc00078e00ffULL, 0x0000006100687306ULL, 0x000fe20000209400ULL,
0x000000015f5f6812ULL, 0x002fe400078efcffULL, 0x0000005b5c00720bULL, 0x000fca0003fdd000ULL,
0x0000006100697306ULL, 0x000e620000205400ULL, 0x000000015a5a2812ULL, 0x008fe400078efcffULL,
0x000000656400720bULL, 0x000fca0003f5d000ULL, 0x0000006100597306ULL, 0x000ea2000020d400ULL,
0x0000000149496812ULL, 0x000fe400078efcffULL, 0x000000544700720bULL, 0x000fca0003fdd000ULL,
0x0000004d00617306ULL, 0x000fe20000209400ULL, 0x000000696800720bULL, 0x002fe40003f7d000ULL,
0x000000014c4c2812ULL, 0x000fca00078efcffULL, 0x0000004d00627306ULL, 0x000e620000205400ULL,
0x0000000141416812ULL, 0x000fca00078efcffULL, 0x0000000159593812ULL, 0x004fe400078efcffULL,
0x0000004d000e7306ULL, 0x000eb0000020d400ULL, 0x00000036004e7306ULL, 0x0006a2000000d400ULL,
0x000000626100720bULL, 0x002fce0003f1d000ULL, 0x00000037004d7306ULL, 0x000262000000d400ULL,
0x0000006c0736723eULL, 0x008fe400000010ffULL, 0x00000018ff077819ULL, 0x000fe4000001143fULL,
0x0000003c143c723cULL, 0x000b62000004182cULL, 0x000000010e0e0812ULL, 0x004fe400078efcffULL,
0x0000004000457306ULL, 0x000fe20000209400ULL, 0x000000584337723eULL, 0x002fe400000010ffULL,
0x0000005e4843723eULL, 0x000fc400000010ffULL, 0x000000014e4e4812ULL, 0x000fe400078efcffULL,
0x0000005a492c723eULL, 0x020fe200000010ffULL, 0x000000361434723cULL, 0x040b620000041828ULL,
0x0000004000467306ULL, 0x000e620000205400ULL, 0x000000014d4d5812ULL, 0x000fe400078efcffULL,
0x00000059442d723eULL, 0x000fe400000010ffULL, 0x0000004e4c4c723eULL, 0x000fe400000010ffULL,
0x000000421414723cULL, 0x000f620000041830ULL, 0x00000050004f7306ULL, 0x000fe20000209400ULL,
0x000000605f28723eULL, 0x020fc400000010ffULL, 0x000000555629723eULL, 0x000fe400000010ffULL,
0x0000004d0e4d723eULL, 0x000fc600000010ffULL, 0x0000005000517306ULL, 0x000ea20000205400ULL,
0x000000464500720bULL, 0x002fc60003f7d000ULL, 0x0000004c1030723cULL, 0x040f68000004183cULL,
0x0000000700577306ULL, 0x000fe80000209400ULL, 0x0000002c102c723cULL, 0x000f680000041834ULL,
0x00000007002a7306ULL, 0x000e620000205400ULL, 0x000000514f00720bULL, 0x004fce0003f5d000ULL,
0x0000004000407306ULL, 0x000eb0000020d400ULL, 0x0000005000507306ULL, 0x000ee2000020d400ULL,
0x0000002a5700720bULL, 0x002fe40003f9d000ULL, 0x000000281028723cULL, 0x000b6a0000041818ULL,
0x0000000700077306ULL, 0x000e62000020d400ULL, 0x0000000140403812ULL, 0x004fc400078efcffULL,
0x0000000150502812ULL, 0x008fc800078efcffULL, 0x000000504118723eULL, 0x020fe400000010ffULL,
0x0000000107074812ULL, 0x002fc800078efcffULL, 0x000000074019723eULL, 0x000fce00000010ffULL,
0x000000181018723cULL, 0x000b620000041814ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000006067f8cULL, 0x000e62000c80043fULL, 0x0000000105057810ULL, 0x000fe40007ffe0ffULL,
0x000176a07b107811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000010ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff0e7224ULL, 0x002fe200078e0007ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff25f000007947ULL, 0x000fea000383ffffULL,
0x000000ff7800720cULL, 0x008fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x018000000d027810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000f43000057802ULL, 0x002fc40000000f00ULL,
0x0000a6f000007944ULL, 0x014fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000d00047308ULL, 0x000ee40000001000ULL, 0xbf80000004027423ULL, 0x008fc8000000000dULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000304047223ULL, 0x000fc40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ee8000c1e9900ULL,
0x0000000000057919ULL, 0x002e680000000000ULL, 0x0000000000087919ULL, 0x000ea20000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011605ULL, 0x0000000808057811ULL, 0x004fe200078ff0ffULL,
0x0000000403067220ULL, 0x008fca0000410000ULL, 0x00001f0706047589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea200000e0000ULL, 0x0000003804387220ULL, 0x042fe40000410000ULL,
0x0000003904397220ULL, 0x040fe40000410000ULL, 0x0000001c041c7220ULL, 0x040fe40000410000ULL,
0x0000001d041d7220ULL, 0x000fc40000410000ULL, 0x0000002004207220ULL, 0x040fe40000410000ULL,
0x0000002104217220ULL, 0x040fe40000410000ULL, 0x0000002404247220ULL, 0x040fe40000410000ULL,
0x0000002504257220ULL, 0x040fe40000410000ULL, 0x0000002804287220ULL, 0x040fe40000410000ULL,
0x0000002904297220ULL, 0x000fc40000410000ULL, 0x0000002c042c7220ULL, 0x040fe40000410000ULL,
0x0000002d042d7220ULL, 0x040fe40000410000ULL, 0x0000003004307220ULL, 0x040fe40000410000ULL,
0x0000003104317220ULL, 0x040fe40000410000ULL, 0x0000001804187220ULL, 0x040fe40000410000ULL,
0x0000001904197220ULL, 0x000fc40000410000ULL, 0x0000003a053a7220ULL, 0x044fe40000410000ULL,
0x0000003b053b7220ULL, 0x040fe40000410000ULL, 0x0000001e051e7220ULL, 0x040fe40000410000ULL,
0x0000001f051f7220ULL, 0x040fe40000410000ULL, 0x0000002205227220ULL, 0x040fe40000410000ULL,
0x0000002305237220ULL, 0x000fc40000410000ULL, 0x0000002605267220ULL, 0x040fe40000410000ULL,
0x0000002705277220ULL, 0x040fe40000410000ULL, 0x0000002a052a7220ULL, 0x040fe40000410000ULL,
0x0000002b052b7220ULL, 0x040fe40000410000ULL, 0x0000002e052e7220ULL, 0x040fe40000410000ULL,
0x0000002f052f7220ULL, 0x000fc40000410000ULL, 0x0000003205327220ULL, 0x040fe40000410000ULL,
0x0000003305337220ULL, 0x040fe40000410000ULL, 0x0000001a051a7220ULL, 0x040fe40000410000ULL,
0x0000001b051b7220ULL, 0x000fc40000410000ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x0000100000077824ULL, 0x000fe200078e00ffULL, 0x0000002c2d2c723eULL, 0x000fe200000010ffULL,
0x00000020730c7824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000303130723eULL, 0x000fc400000010ffULL, 0x000000181918723eULL, 0x000fe400000010ffULL,
0x000000222322723eULL, 0x000fe400000010ffULL, 0x0000002a2b2a723eULL, 0x000fe400000010ffULL,
0x0000002e2f15723eULL, 0x000fe400000010ffULL, 0x000000323332723eULL, 0x000fe400000010ffULL,
0x0000001a1b19723eULL, 0x000fc400000010ffULL, 0x00000002ff067819ULL, 0x008fe40000011602ULL,
0x0000000202037812ULL, 0x040fe400078ec0ffULL, 0x0000000802087811ULL, 0x002fe200078ff0ffULL,
0x00000008060a7824ULL, 0x044fe200078e00ffULL, 0x0000000603057211ULL, 0x040fe200078ff8ffULL,
0x00000008060d7824ULL, 0x000fe200078e00ffULL, 0x0000000803047211ULL, 0x000fe200078ff8ffULL,
0x00000008080f7824ULL, 0x010fe200078e00ffULL, 0x0000000205037810ULL, 0x000fe20007ffe0ffULL,
0x0000000806087824ULL, 0x000fe200078e00ffULL, 0x00005410320e7816ULL, 0x000fc40000000019ULL,
0xfffffff80f0f7812ULL, 0x000fe400078ee204ULL, 0x0000100007047812ULL, 0x000fe400078ee2ffULL,
0xfffffff808097812ULL, 0x040fe400078ee203ULL, 0xfffffff808037812ULL, 0x000fe200078ee205ULL,
0x0000080073067824ULL, 0x000fe200078e0204ULL, 0x0000000405077810ULL, 0x040fe40007ffe0ffULL,
0x0000000605087810ULL, 0x000fe20007ffe0ffULL, 0x0000000802057824ULL, 0x000fe200078e00ffULL,
0xfffffff80a0b7812ULL, 0x000fe200078ee207ULL, 0x0000001003077824ULL, 0x000fe200078e0206ULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee208ULL, 0x0000001009097824ULL, 0x100fe200078e0206ULL,
0x0000000805087812ULL, 0x000fe200078ec0ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0206ULL,
0x000000383903723eULL, 0x000fe200000010ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0206ULL,
0x0000001c1d05723eULL, 0x000fe200000010ffULL, 0x0000000107077824ULL, 0x000fc400078e0208ULL,
0x000000100d0d7824ULL, 0x000fe200078e0206ULL, 0x0000541003107816ULL, 0x040fe20000000005ULL,
0x0000000108097824ULL, 0x040fe200078e0209ULL, 0x0000763203117816ULL, 0x000fe20000000005ULL,
0x00000001080b7824ULL, 0x040fe200078e020bULL, 0x000000202103723eULL, 0x000fe200000010ffULL,
0x00000001080d7824ULL, 0x040fe200078e020dULL, 0x000000242505723eULL, 0x000fe200000010ffULL,
0x0000001007007388ULL, 0x0003e20000000a00ULL, 0x000000282906723eULL, 0x000fe200000010ffULL,
0x00000001080f7824ULL, 0x000fe200078e020fULL, 0x000054102a087816ULL, 0x000fc40000000015ULL,
0x0000541006127816ULL, 0x140fe4000000002cULL, 0x0000763206137816ULL, 0x000fe4000000002cULL,
0x0000541030067816ULL, 0x140fe40000000018ULL, 0x0000541003107816ULL, 0x142fe40000000005ULL,
0x0000763203117816ULL, 0x000fe40000000005ULL, 0x0000763230077816ULL, 0x000fc40000000018ULL,
0x0000003a3b03723eULL, 0x000fe200000010ffULL, 0x0000001009007388ULL, 0x0003e20000000a00ULL,
0x0000001e1f05723eULL, 0x000fc600000010ffULL, 0x000000120b007388ULL, 0x000fe80000000a00ULL,
0x000000060d007388ULL, 0x0005e20000000a00ULL, 0x000000262711723eULL, 0x002fc800000010ffULL,
0x0000541022107816ULL, 0x140fe40000000011ULL, 0x0000763222117816ULL, 0x000fe40000000011ULL,
0x0000541003067816ULL, 0x144fe40000000005ULL, 0x0000763203077816ULL, 0x000fe20000000005ULL,
0x000000010c037824ULL, 0x000fe200078e0202ULL, 0x000000ff00057306ULL, 0x000fe60000205400ULL,
0x000000060f007388ULL, 0x0003e80000000a00ULL, 0x0004001009007388ULL, 0x0005e20000000a00ULL,
0x00007632320f7816ULL, 0x002fe20000000019ULL, 0x0000001003077824ULL, 0x000fe200078e0204ULL,
0x000000ff00067306ULL, 0x000e620000209400ULL, 0x000076322a097816ULL, 0x004fca0000000015ULL,
0x000400080b007388ULL, 0x000fe40000000a00ULL, 0x000000ff00037306ULL, 0x000ea4000020d400ULL,
0x0004000e0d007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000007107984ULL, 0x000ee20000000c00ULL, 0x000000050600720bULL, 0x002fc60003f1d000ULL,
0x0004000007087984ULL, 0x000e680000000c00ULL, 0x0008000007147984ULL, 0x000e680000000c00ULL,
0x000c000007187984ULL, 0x000e640000000c00ULL, 0x0000000103030812ULL, 0x004fc400078efcffULL,
0x000000ff7300720cULL, 0x000fe40003f05270ULL, 0x000000030305723eULL, 0x000fca00000010ffULL,
0x3f803f8005137831ULL, 0x048fe40000200013ULL, 0x3f803f8005127831ULL, 0x040fe40000200012ULL,
0x3f803f8005117831ULL, 0x040fe40000200011ULL, 0x3f803f8005107831ULL, 0x040fe40000200010ULL,
0x3f803f80050b7831ULL, 0x042fe4000020000bULL, 0x3f803f80050a7831ULL, 0x000fc4000020000aULL,
0x3f803f8005097831ULL, 0x040fe40000200009ULL, 0x3f803f8005087831ULL, 0x000fe40000200008ULL,
0x3f803f8013137831ULL, 0x000fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fc40000200014ULL,
0x3f803f800b0b7831ULL, 0x000fe4000020001bULL, 0x3f803f800a0a7831ULL, 0x000fe2000020001aULL,
0x0000001007007388ULL, 0x000fe20000000c00ULL, 0x3f803f8009097831ULL, 0x000fe40000200019ULL,
0x3f803f8008087831ULL, 0x000fca0000200018ULL, 0x0004000807007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff057819ULL, 0x000fc80000011602ULL, 0x0000007d0500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000011c7983ULL, 0x000ea20000100800ULL,
0x00005a0000097b06ULL, 0x000e620000209000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00005a00ff117a12ULL, 0x000fe400078e33ffULL, 0x00000001000d7812ULL, 0x000fe400078ec0ffULL,
0x0000002002007810ULL, 0x040fe40007ffe0ffULL, 0x00000007020e7812ULL, 0x000fe200078ec0ffULL,
0x0000000900097308ULL, 0x002e640000001000ULL, 0x0ffffffe090a7810ULL, 0x002fcc0007ffe0ffULL,
0x0000000a00077305ULL, 0x000e64000021f000ULL, 0x000000ffff037224ULL, 0x002fc800078e0a07ULL,
0x00005a0003037a24ULL, 0x000fc800078e02ffULL, 0x00000003070f7227ULL, 0x000fc800078e0006ULL,
0x000000017a037824ULL, 0x000fe400078e0205ULL, 0x0000000105057824ULL, 0x000fe400078e0202ULL,
0x000000030f067227ULL, 0x000fc600078e00ffULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc600078e0a06ULL, 0x0ffffff805057812ULL, 0x000fe200078ef802ULL,
0x00005a0008077a24ULL, 0x000fc800078e0203ULL, 0x0000001005057824ULL, 0x000fe200078e0204ULL,
0x00005a0007007a0cULL, 0x000fc80003f06070ULL, 0x0000000005087984ULL, 0x0002e40000000c00ULL,
0x00000003ff057819ULL, 0x002fce0000011600ULL, 0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106060810ULL, 0x000fe40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fe40003f26070ULL,
0x00005a00ff007a0cULL, 0x000fd60003f05070ULL, 0x0000000106061810ULL, 0x000fc80007ffe0ffULL,
0x0000000611077207ULL, 0x000fca0004000000ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a07ULL,
0x0000590007067a24ULL, 0x000fe400078e027cULL, 0x00005a000c037a24ULL, 0x000fc800078e0203ULL,
0x00005a0006037a24ULL, 0x000fca00078e0203ULL, 0x000000031c037210ULL, 0x004fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0003067a11ULL, 0x000fc800078240ffULL,
0x00005f0003077a11ULL, 0x000fe200008f440cULL, 0x000000080d037824ULL, 0x000fe200078e020eULL,
0x0000007d0500720cULL, 0x000fc60003f26070ULL, 0x0000001003067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0083ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000017a037824ULL, 0x100fe400078e0205ULL, 0x0000000100057824ULL, 0x000fe400078e0205ULL,
0x000000030f067227ULL, 0x002fc600078e00ffULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc600078e0a06ULL, 0x0ffffff805057812ULL, 0x000fe200078ef800ULL,
0x00005a0008077a24ULL, 0x000fe200078e0203ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001005057824ULL, 0x000fe200078e0204ULL, 0x00005a0007007a0cULL, 0x000fc80003f26070ULL,
0x0000000005087984ULL, 0x0002b20000000c00ULL, 0x80005a0007071a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fc40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fda0003f46070ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000611077207ULL, 0x000fca0004000000ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a07ULL, 0x0000590007067a24ULL, 0x000fe400078e027cULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x00000040020c7810ULL, 0x000fc60007ffe0ffULL,
0x00005a0006037a24ULL, 0x000fe200078e0203ULL, 0x00000003ff057819ULL, 0x002fc8000001160cULL,
0x000000031c037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003067a11ULL, 0x000fc800078240ffULL, 0x00005f0003077a11ULL, 0x000fe200008f440eULL,
0x000000080d037824ULL, 0x000fe200078e0200ULL, 0x0000007d0500720cULL, 0x000fc60003f26070ULL,
0x0000001003067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000017a007824ULL, 0x100fe400078e0205ULL,
0x000000010c057824ULL, 0x000fe400078e0205ULL, 0x000000000f037227ULL, 0x000fc600078e00ffULL,
0x0000000705057812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x002fc600078e0a03ULL,
0x0ffffff805057812ULL, 0x000fe200078ef80cULL, 0x00005a0007067a24ULL, 0x000fe200078e0200ULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001005057824ULL, 0x000fe200078e0204ULL,
0x00005a0006007a0cULL, 0x000fc80003f26070ULL, 0x0000000005087984ULL, 0x0002b20000000c00ULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103031810ULL, 0x000fc40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fda0003f46070ULL, 0x0000000103032810ULL, 0x000fc80007ffe0ffULL,
0x0000000311037207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e027cULL, 0x00005a0007007a24ULL, 0x000fc800078e0200ULL,
0x00005a0003007a24ULL, 0x000fca00078e0200ULL, 0x000000001c037210ULL, 0x000fe40007f3e0ffULL,
0x0000006002007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003067a11ULL, 0x040fe400078240ffULL, 0x00000003ff057819ULL, 0x002fe40000011600ULL,
0x00005f0003077a11ULL, 0x000fe200008f440eULL, 0x000000080d037824ULL, 0x000fe200078e020cULL,
0x0000007d0500720cULL, 0x000fe20003f26070ULL, 0x000000017a7a7824ULL, 0x000fe400078e0205ULL,
0x0000001003027825ULL, 0x000fca00078e0006ULL, 0x0000000802007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000007a0f027227ULL, 0x002fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a02ULL, 0x0000000100057824ULL, 0x000fe400078e0205ULL,
0x00005a0003037a24ULL, 0x000fc600078e027aULL, 0x0000000705057812ULL, 0x000fe400078ec0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f26070ULL, 0xfffffff805057812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001005057824ULL, 0x000fca00078e0204ULL,
0x0000000005087984ULL, 0x0002a20000000c00ULL, 0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL,
0x0000000102021810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fe20003f46070ULL,
0x000000080d057824ULL, 0x002fd800078e0200ULL, 0x0000000102022810ULL, 0x000fc80007ffe0ffULL,
0x0000000211037207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e027cULL, 0x00005a00077a7a24ULL, 0x000fc800078e027aULL,
0x00005a00037a7a24ULL, 0x000fca00078e027aULL, 0x0000007a1c7a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005e007a027a11ULL, 0x000fc800078040ffULL,
0x00005f007a037a11ULL, 0x000fca00000f4403ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x004fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000760000720cULL, 0x000fe20003f06070ULL, 0xffffffffff147424ULL, 0x000fd800078e00ffULL,
0x0000000204078824ULL, 0x002fc800078e00ffULL, 0x00006a00070a8a24ULL, 0x000fc800078e0200ULL,
0x000066000a0a8625ULL, 0x000fe200078e0047ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006e00ff0c7624ULL, 0x000fe200078e00ffULL, 0x000000060a148981ULL, 0x000ea2000c1e1900ULL,
0x00006f00ff0d7624ULL, 0x000fc600078e00ffULL, 0x01760000ff067f8cULL, 0x000e68000c80043fULL,
0x000000060c097981ULL, 0x000722000c1e9900ULL, 0x000001ff0e00780cULL, 0x000fe20003f04070ULL,
0x00000040027d7824ULL, 0x000fe400078e00ffULL, 0x0000004000797824ULL, 0x000fe400078e00ffULL,
0x000000407c027824ULL, 0x000fc400078e00ffULL, 0x000000147d147224ULL, 0x004fcc00078e02ffULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x00000079700a7217ULL, 0x00afe40007800000ULL,
0x00000003ff1a7819ULL, 0x000fe40000011603ULL, 0x0000640014157a11ULL, 0x000fe200078438ffULL,
0x000000010a177824ULL, 0x000fe200078e0a79ULL, 0x000000041a0c7810ULL, 0x000fe20007ffe0ffULL,
0x000000407c7c7824ULL, 0x000fe200078e021aULL, 0x000000081a0e7810ULL, 0x000fe40007ffe0ffULL,
0x000000170c00720cULL, 0x0c0fe20003f86070ULL, 0x000000010c0a7824ULL, 0x100fe200078e0203ULL,
0x000000170e00720cULL, 0x000fe20003f06070ULL, 0x000000080c237824ULL, 0x000fe200078e00ffULL,
0x000000047c0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000010e0b7824ULL, 0x000fe200078e0203ULL,
0x000000147c127810ULL, 0x000fe20007ffe0ffULL, 0x000000080e107824ULL, 0x000fe200078e00ffULL,
0x0000000c1a0e7810ULL, 0x000fe20007ffe0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fc400078ee20aULL, 0xfffffff810277812ULL, 0x000fe200078ee20bULL,
0x000000807c0a7825ULL, 0x000fe200078e00ffULL, 0x000000170e00720cULL, 0x000fe40003f26070ULL,
0x000000700c1c7812ULL, 0x000fe200078ef805ULL, 0x000000010e0f7824ULL, 0x000fe200078e0203ULL,
0x000000700a1e7812ULL, 0x000fe200078ef805ULL, 0x000000080e107824ULL, 0x000fe200078e00ffULL,
0x000000087c0e7810ULL, 0x000fe20007ffe0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000650014147a11ULL, 0x000fc400010f3cffULL, 0xfffffff810297812ULL, 0x000fe200078ee20fULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000151c1c7210ULL, 0x000fe40007f7e0ffULL,
0x0000000c7c0c7810ULL, 0x000fe40007ffe0ffULL, 0x0000001e151e7210ULL, 0x000fe20007f5e0ffULL,
0x000000010d1d7824ULL, 0x000fe200018e0614ULL, 0x000000700e0a7812ULL, 0x000fe200078ef805ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000187c207810ULL, 0x000fc40007ffe0ffULL,
0x00000070120e7812ULL, 0x100fe200078ef805ULL, 0x000000010b1f7824ULL, 0x100fe200010e0614ULL,
0x000000150a0a7210ULL, 0x080fe20007f5e0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x000000700c187812ULL, 0x100fe400078ef805ULL, 0x000000107c107810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0b7824ULL, 0x000fe200010e0614ULL, 0x000000150e0e7210ULL, 0x080fe40007fbe0ffULL,
0x00000070200c7812ULL, 0x000fe200078ef805ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001518187210ULL, 0x000fc40007f5e0ffULL, 0x000000101a207810ULL, 0x040fe20007ffe0ffULL,
0x00000001130f7824ULL, 0x100fe200028e0614ULL, 0x000000141a227810ULL, 0x040fe20007ffe0ffULL,
0x000000011a137824ULL, 0x100fe200078e0203ULL, 0x000000150c0c7210ULL, 0x000fe20007fde0ffULL,
0x000000010d197824ULL, 0x100fe200010e0614ULL, 0x000000172000720cULL, 0x040fe20003f46070ULL,
0x00000001201b7824ULL, 0x000fe200078e0203ULL, 0x0000007010107812ULL, 0x000fe200078ef805ULL,
0x0000000820267824ULL, 0x000fe200078e00ffULL, 0x0000001c7c127810ULL, 0x000fe20007ffe0ffULL,
0x0000000122207824ULL, 0x140fe200078e0203ULL, 0x0000000713247812ULL, 0x000fe200078ec0ffULL,
0x00000008222d7824ULL, 0x000fe200078e00ffULL, 0x0000001510107210ULL, 0x000fe20007f7e0ffULL,
0x00000001210d7824ULL, 0x000fe200030e0614ULL, 0x0000100000167811ULL, 0x000fe200078e70ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0ffffff824217812ULL, 0x000fc400078ef803ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee220ULL, 0x0000000111117824ULL, 0x000fe200018e0614ULL,
0x000000171a00720cULL, 0x080fe20003fa6070ULL, 0x0000001023257824ULL, 0x100fe200078e0216ULL,
0x000000207c207810ULL, 0x000fe20007ffe0ffULL, 0x0000001027277824ULL, 0x100fe200078e0216ULL,
0xfffffff8262b7812ULL, 0x000fe200078ee21bULL, 0x00000010211b7824ULL, 0x000fe200078e0216ULL,
0x000000172200720cULL, 0x000fe20003f66070ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x000fc400078ef805ULL, 0x000000247c227810ULL, 0x000fe20007ffe0ffULL,
0x0000001029297824ULL, 0x000fe200078e0216ULL, 0x0000001512127210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e1b7faeULL, 0x0003e2000e901c46ULL,
0x0000007020207812ULL, 0x000fe200078ef805ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000001c1a287810ULL, 0x040fe20007ffe0ffULL, 0x000000001c257faeULL, 0x0005e2000e101c46ULL,
0x000000181a247810ULL, 0x000fe20007ffe0ffULL, 0x0000000113137824ULL, 0x100fe200030e0614ULL,
0x000000172800720cULL, 0x080fe20003f86070ULL, 0x000000000a277faeULL, 0x0007e2000c101c46ULL,
0x000000172400720cULL, 0x040fe20003fa6070ULL, 0x0000000124267824ULL, 0x000fe200078e0203ULL,
0x00000015201e7210ULL, 0x082fe20007fde0ffULL, 0x00000008241b7824ULL, 0x000fe200078e00ffULL,
0x0000007022207812ULL, 0x000fe200078ef805ULL, 0x0000000128227824ULL, 0x100fe200078e0203ULL,
0x000000287c1c7810ULL, 0x004fe20007ffe0ffULL, 0x0000000828257824ULL, 0x000fe200078e00ffULL,
0x000000241a247810ULL, 0x000fe20007ffe0ffULL, 0x00000001211f7824ULL, 0x000fe200030e0614ULL,
0x0000001520207210ULL, 0x000fe20007fde0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee222ULL, 0x0000000018297faeULL, 0x0003e2000c901c46ULL,
0x000000201a227810ULL, 0x000fe20007ffe0ffULL, 0x0000000123217824ULL, 0x000fe200030e0614ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee226ULL, 0x00000008240b7824ULL, 0x008fe200078e00ffULL,
0x000000172200720cULL, 0x0c0fe20003f06070ULL, 0x0000000122237824ULL, 0x000fe200078e0203ULL,
0x000000172400720cULL, 0x000fe20003f26070ULL, 0x0000000822267824ULL, 0x000fe200078e00ffULL,
0x000000701c227812ULL, 0x000fe200078ef805ULL, 0x00000001241c7824ULL, 0x000fe200078e0203ULL,
0x000000381a247810ULL, 0x000fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x100fe200078e0216ULL,
0x00000015220a7210ULL, 0x000fe20007fde0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0216ULL,
0xfffffff80b197812ULL, 0x002fe200078ee21cULL, 0x000000101b1b7824ULL, 0x000fe200078e0216ULL,
0x0000002c7c1c7810ULL, 0x000fe20007ffe0ffULL, 0x00000000102b7faeULL, 0x0003e2000d101c46ULL,
0x000000011d0b7824ULL, 0x000fe200030e0614ULL, 0xfffffff826237812ULL, 0x000fe200078ee223ULL,
0x0000001025257824ULL, 0x100fe200078e0216ULL, 0x000000000e2d7faeULL, 0x0005e2000d901c46ULL,
0x0000001019197824ULL, 0x100fe200078e0216ULL, 0x0000002c1a187810ULL, 0x040fe20007ffe0ffULL,
0x0000001023237824ULL, 0x000fe200078e0216ULL, 0x000000000c1b7faeULL, 0x0007e2000e901c46ULL,
0x000000301a227810ULL, 0x000fc40007ffe0ffULL, 0x0000003c1a267810ULL, 0x040fe20007ffe0ffULL,
0x0000000012257faeULL, 0x0007e2000e101c46ULL, 0x000000281a107810ULL, 0x002fe20007ffe0ffULL,
0x00000008221d7824ULL, 0x000fe200078e00ffULL, 0x000000171800720cULL, 0x080fe20003f86070ULL,
0x000000801c0e7825ULL, 0x004fe200078e00ffULL, 0x000000341a1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000001e237faeULL, 0x0003e2000c101c46ULL, 0x000000171000720cULL, 0x040fe20003fa6070ULL,
0x00000008101a7824ULL, 0x000fe200078e00ffULL, 0x000000700e0c7812ULL, 0x008fe200078ef805ULL,
0x0000000020197faeULL, 0x0005e2000c901c46ULL, 0x000000307c0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000110137824ULL, 0x000fe200078e0203ULL, 0x000000150c0c7210ULL, 0x000fc40007fde0ffULL,
0x000000347c107810ULL, 0x000fe40007ffe0ffULL, 0x000000172200720cULL, 0x080fe20003f66070ULL,
0x000000010f0d7824ULL, 0x000fe200030e0614ULL, 0x000000171c00720cULL, 0x080fe20003f46070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000172400720cULL, 0x080fe40003f26070ULL,
0x000000172600720cULL, 0x000fe20003f06070ULL, 0x0000000118197824ULL, 0x004fe200078e0203ULL,
0x000000700e127812ULL, 0x000fe200078ef805ULL, 0x00000001220e7824ULL, 0x000fe200078e0203ULL,
0xfffffff81a177812ULL, 0x000fe200078ee213ULL, 0x0000000818187824ULL, 0x000fe200078e00ffULL,
0x0000001512127210ULL, 0x000fe20007fde0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fc400078ee20eULL, 0xfffffff8181b7812ULL, 0x000fe200078ee219ULL,
0x000000010f137824ULL, 0x000fe200030e0614ULL, 0x000000387c0e7810ULL, 0x000fe20007ffe0ffULL,
0x000000081c1f7824ULL, 0x002fe200078e00ffULL, 0x0000007010187812ULL, 0x000fe200078ef805ULL,
0x000000011c107824ULL, 0x100fe200078e0203ULL, 0x0000003c7c7c7810ULL, 0x000fe20007ffe0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000001518187210ULL, 0x000fe40007fde0ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee210ULL, 0x00000001241a7824ULL, 0x000fe200078e0203ULL,
0x000000700e0e7812ULL, 0x000fe200078ef805ULL, 0x0000000111197824ULL, 0x000fc400030e0614ULL,
0x000000807c107825ULL, 0x000fe200078e00ffULL, 0x000000150e0e7210ULL, 0x000fc60007fde0ffULL,
0x0000000824217824ULL, 0x000fe200078e00ffULL, 0x0000007010107812ULL, 0x000fe200078ef805ULL,
0x00000001261c7824ULL, 0x040fe400078e0203ULL, 0x0000000826237824ULL, 0x000fe200078e00ffULL,
0xfffffff821037812ULL, 0x000fe200078ee21aULL, 0x000000010f0f7824ULL, 0x000fe200030e0614ULL,
0x0000001510107210ULL, 0x000fe20007fde0ffULL, 0x0000001017177824ULL, 0x000fe200078e0216ULL,
0xfffffff823057812ULL, 0x000fe200078ee21cULL, 0x000000101b1b7824ULL, 0x000fc400078e0216ULL,
0x000000101d1d7824ULL, 0x100fe200078e0216ULL, 0x000000000a177faeULL, 0x0003e2000e901c46ULL,
0x000000101f1f7824ULL, 0x100fe400078e0216ULL, 0x0000001003037824ULL, 0x100fe200078e0216ULL,
0x000000000c1b7faeULL, 0x0003e2000e101c46ULL, 0x0000001005057824ULL, 0x000fe400078e0216ULL,
0x0000000111117824ULL, 0x000fe200030e0614ULL, 0x00000000121d7faeULL, 0x0003e8000d901c46ULL,
0x00000000181f7faeULL, 0x0003e8000d101c46ULL, 0x000000000e037faeULL, 0x0003e8000c901c46ULL,
0x0000000010057faeULL, 0x0003e2000c101c46ULL, 0x00000b5000007947ULL, 0x000fea0003800000ULL,
0x00000004030c7811ULL, 0x04afe400078fe8ffULL, 0x00000008030d7811ULL, 0x000fc400078fe8ffULL,
0x0000001403157811ULL, 0x040fe200078fe8ffULL, 0x000000010c0a7824ULL, 0x140fe200078e0203ULL,
0x0000000c030f7811ULL, 0x040fe200078fe8ffULL, 0x000000080c1d7824ULL, 0x000fe200078e00ffULL,
0x0000001003127811ULL, 0x000fe200078fe8ffULL, 0x000000080d1f7824ULL, 0x000fe200078e00ffULL,
0x0000002003197811ULL, 0x000fe200078fe8ffULL, 0x0000000815257824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee20aULL, 0x000000010d0a7824ULL, 0x100fe200078e0203ULL,
0x0000001803167811ULL, 0x000fe200078fe8ffULL, 0x000000010f0b7824ULL, 0x100fe200078e0203ULL,
0x0000001c03177811ULL, 0x000fe200078fe8ffULL, 0x000000080f107824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee20aULL, 0x00000001150a7824ULL, 0x100fe200078e0203ULL,
0x0000002c032d7811ULL, 0x000fe200078fe8ffULL, 0x00000001120e7824ULL, 0x000fe200078e0203ULL,
0xfffffff810217812ULL, 0x000fe200078ee20bULL, 0x0000000812117824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x00000001190a7824ULL, 0x100fe200078e0203ULL,
0x0000002403337811ULL, 0x000fe200078fe8ffULL, 0x00000008192b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8110e7812ULL, 0x000fe200078ee20eULL, 0x00000001160b7824ULL, 0x140fe200078e0203ULL,
0x00000028032f7811ULL, 0x000fe200078fe8ffULL, 0x0000000816187824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee20aULL, 0x0000000117107824ULL, 0x000fe200078e0203ULL,
0x0000003003317811ULL, 0x000fe200078fe8ffULL, 0x0000000817117824ULL, 0x000fe200078e00ffULL,
0xfffffff818277812ULL, 0x000fe200078ee20bULL, 0x000000012d0a7824ULL, 0x100fe200078e0203ULL,
0x00000034032e7811ULL, 0x000fe200078fe8ffULL, 0x000000082d137824ULL, 0x000fe200078e00ffULL,
0xfffffff811107812ULL, 0x000fe200078ee210ULL, 0x00000001330b7824ULL, 0x100fe200078e0203ULL,
0x0000003803327811ULL, 0x000fe200078fe8ffULL, 0x00000008331c7824ULL, 0x000fe200078e00ffULL,
0xfffffff813267812ULL, 0x000fe200078ee20aULL, 0x000000012f117824ULL, 0x000fe200078e0203ULL,
0x00000003030a7211ULL, 0x000fe200078fe8ffULL, 0x000000082f187824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL, 0x00000001310b7824ULL, 0x040fe200078e0203ULL,
0x000000070a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000831247824ULL, 0x000fe200078e00ffULL,
0xfffffff818117812ULL, 0x000fe200078ee211ULL, 0x000000012e137824ULL, 0x040fe200078e0203ULL,
0x0000003c03307811ULL, 0x040fe200078fe8ffULL, 0x000000082e187824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20bULL, 0x00000008321b7824ULL, 0x000fe200078e00ffULL,
0x00001000001e7811ULL, 0x000fe200078e70ffULL, 0x00000001301a7824ULL, 0x100fe200078e0203ULL,
0x0ffffff80a0b7812ULL, 0x000fe200078ef803ULL, 0x0000000830237824ULL, 0x000fe200078e00ffULL,
0x00000002030a7211ULL, 0x000fe200078fe8ffULL, 0x0000001010297824ULL, 0x000fe200078e021eULL,
0xfffffff818137812ULL, 0x000fe200078ee213ULL, 0x0000000132187824ULL, 0x000fe200078e0203ULL,
0xfffffff8231a7812ULL, 0x000fe200078ee21aULL, 0x000000100b037824ULL, 0x000fe200078e021eULL,
0x00006400142a7a11ULL, 0x000fe200078038ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff81b187812ULL, 0x000fc400078ee218ULL, 0x00006500142c7a11ULL, 0x000fe200000f3cffULL,
0x0000000102107824ULL, 0x000fe400078e020fULL, 0x000000100e237824ULL, 0x100fe400078e021eULL,
0x0000001011287824ULL, 0x100fe400078e021eULL, 0x0000001013227824ULL, 0x000fe200078e021eULL,
0x000000700a137812ULL, 0x000fe200078ef805ULL, 0x00000001020e7824ULL, 0x000fe400078e020dULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000132a0a7210ULL, 0x000fc60007f1e0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000007010137812ULL, 0x000fc600078ef805ULL,
0x0000000102127824ULL, 0x000fe200078e0212ULL, 0x000000700e1b7812ULL, 0x000fe200078ef805ULL,
0x00000001020c7824ULL, 0x000fe200078e020cULL, 0x000000132a107210ULL, 0x000fe20007f5e0ffULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x000000010b0b7824ULL, 0x000fe200000e062cULL,
0x0000001b2a0e7210ULL, 0x000fe20007f1e0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e021eULL,
0x00000070121b7812ULL, 0x000fe200078ef805ULL, 0x000000101f1f7824ULL, 0x100fe200078e021eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a037faeULL, 0x0003e2000b901c46ULL,
0x0000001021217824ULL, 0x100fe400078e021eULL, 0x0000001025257824ULL, 0x100fe400078e021eULL,
0x0000001027277824ULL, 0x000fc400078e021eULL, 0x000000102b2b7824ULL, 0x100fe400078e021eULL,
0x000000101c1c7824ULL, 0x100fe400078e021eULL, 0x0000001026267824ULL, 0x100fe400078e021eULL,
0x0000001024247824ULL, 0x100fe400078e021eULL, 0x0000001018207824ULL, 0x100fe400078e021eULL,
0x000000101a1e7824ULL, 0x000fc400078e021eULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x00000001021a7824ULL, 0x000fe200078e0219ULL, 0x000000700c357812ULL, 0x000fe200078ef805ULL,
0x000000010f0f7824ULL, 0x000fe200000e062cULL, 0x0000001b2a127210ULL, 0x000fe20007f1e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x000000352a0c7210ULL, 0x000fc60007f3e0ffULL,
0x0000000102157824ULL, 0x000fe200078e0215ULL, 0x000000701a357812ULL, 0x000fe200078ef805ULL,
0x0000000102187824ULL, 0x040fe400078e0217ULL, 0x0000000102167824ULL, 0x000fe200078e0216ULL,
0x000000352a1a7210ULL, 0x000fe20007f7e0ffULL, 0x0000008015147825ULL, 0x000fc800078e00ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000070143b7812ULL, 0x000fc600078ef805ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000007018377812ULL, 0x000fc600078ef805ULL,
0x0000000102337824ULL, 0x000fe200078e0233ULL, 0x0000007016397812ULL, 0x000fe200078ef805ULL,
0x0000000102347824ULL, 0x040fe400078e022fULL, 0x00000001022d7824ULL, 0x040fe400078e022dULL,
0x0000000102357824ULL, 0x040fe400078e0231ULL, 0x0000000102367824ULL, 0x040fe400078e022eULL,
0x00000001023a7824ULL, 0x000fc400078e0230ULL, 0x00000080332e7825ULL, 0x000fc800078e00ffULL,
0x0000000102387824ULL, 0x000fe200078e0232ULL, 0x000000702e457812ULL, 0x000fe200078ef805ULL,
0x0000008034307825ULL, 0x000fc800078e00ffULL, 0x0000000111117824ULL, 0x100fe200010e062cULL,
0x000000372a187210ULL, 0x040fe20007f5e0ffULL, 0x0000000113137824ULL, 0x000fe200000e062cULL,
0x0000003b2a147210ULL, 0x000fe20007f1e0ffULL, 0x000000802d327825ULL, 0x000fe200078e00ffULL,
0x0000007030437812ULL, 0x000fc600078ef805ULL, 0x000000010d0d7824ULL, 0x000fe200008e062cULL,
0x000000392a167210ULL, 0x000fe20007f3e0ffULL, 0x0000008035347825ULL, 0x000fe200078e00ffULL,
0x0000007032417812ULL, 0x100fe400078ef805ULL, 0x000000000c1d7faeULL, 0x0003e2000b901c46ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x00000070343f7812ULL, 0x100fe400078ef805ULL,
0x000000000e1f7faeULL, 0x0003e2000b901c46ULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x00000070363d7812ULL, 0x000fc400078ef805ULL, 0x0000000010217faeULL, 0x0003e2000b901c46ULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x00000070382d7812ULL, 0x100fe400078ef805ULL,
0x0000003d2a367210ULL, 0x040fe20007f9e0ffULL, 0x0000000115157824ULL, 0x100fe200000e062cULL,
0x000000452a2e7210ULL, 0x040fe20007f1e0ffULL, 0x0000000117177824ULL, 0x100fe200008e062cULL,
0x000000432a307210ULL, 0x000fe20007f3e0ffULL, 0x0000000119197824ULL, 0x100fe200010e062cULL,
0x000000703a057812ULL, 0x000fe200078ef805ULL, 0x000000011b1b7824ULL, 0x100fe200018e062cULL,
0x000000412a327210ULL, 0x040fe20007f5e0ffULL, 0x000000012f2f7824ULL, 0x100fe200000e062cULL,
0x0000003f2a347210ULL, 0x040fe20007f7e0ffULL, 0x0000000012237faeULL, 0x0003e2000b901c46ULL,
0x0000002d2a387210ULL, 0x040fe20007fbe0ffULL, 0x0000000131317824ULL, 0x100fe200008e062cULL,
0x000000052a3a7210ULL, 0x000fe20007fde0ffULL, 0x0000000014257faeULL, 0x0003e2000b901c46ULL,
0x0000000133337824ULL, 0x000fc400010e062cULL, 0x0000000135357824ULL, 0x100fe200018e062cULL,
0x0000000016277faeULL, 0x0003e2000b901c46ULL, 0x0000000137377824ULL, 0x100fe400020e062cULL,
0x0000000139397824ULL, 0x100fe200028e062cULL, 0x0000000018297faeULL, 0x0003e2000b901c46ULL,
0x000000013b3b7824ULL, 0x000fc600030e062cULL, 0x000000001a2b7faeULL, 0x0003e8000b901c46ULL,
0x000000002e1c7faeULL, 0x0003e8000b901c46ULL, 0x0000000030287faeULL, 0x0003e8000b901c46ULL,
0x0000000032267faeULL, 0x0003e8000b901c46ULL, 0x0000000034247faeULL, 0x0003e8000b901c46ULL,
0x0000000036227faeULL, 0x0003e8000b901c46ULL, 0x0000000038207faeULL, 0x0003e8000b901c46ULL,
0x000000003a1e7faeULL, 0x0003e4000b901c46ULL, 0x00000004006c7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff6e7424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000766c00720cULL, 0x000fda0003f06070ULL, 0x0000000204038824ULL, 0x002fc800078e00ffULL,
0x00006a00030a8a24ULL, 0x000fc800078e026cULL, 0x000066000a0a8625ULL, 0x000fca00078e0047ULL,
0x000000060a6e8981ULL, 0x000322000c1e1900ULL, 0x00005800ff037624ULL, 0x000fca00078e00ffULL,
0x0000001f03037810ULL, 0x000fc80007ffe0ffULL, 0x00000005ff6f7819ULL, 0x000fc40000011603ULL,
0x00000000000a7805ULL, 0x002fca0000015200ULL, 0x01760400ff037984ULL, 0x000e620000000800ULL,
0x0000006f08467224ULL, 0x000fe400078e02ffULL, 0x0000000170757824ULL, 0x000fe400078e0a67ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x8000000003ff7812ULL, 0x002fe20007804807ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620046467625ULL, 0x000fe200078e0047ULL, 0x00000008ff757819ULL, 0x000fe20000011675ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a087210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0c7824ULL, 0x000fe200000e0e0bULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140cULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e060cULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002000037824ULL, 0x002fca00078e0203ULL, 0x00000003ff057819ULL, 0x000fc80000011603ULL,
0x1ffffffe05067812ULL, 0x000fe400078ec0ffULL, 0x0000000f03057812ULL, 0x000fc600078ec0ffULL,
0x0000000103067824ULL, 0x000fe400078e0206ULL, 0x0000001005087824ULL, 0x040fe400078e00ffULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x0000000f06037812ULL, 0x040fe400078ec0ffULL,
0x0000000106067810ULL, 0x000fe40007ffe0ffULL, 0x000000f008037812ULL, 0x000fe400078ee203ULL,
0x0000000f06067812ULL, 0x000fc600078ec0ffULL, 0x0000000003107984ULL, 0x000e62000000cc00ULL,
0x000000f005067812ULL, 0x000fca00078ee206ULL, 0x00000000060c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fc400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000001403007388ULL, 0x0003e8000000cc00ULL, 0x0000001006007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01760000ff0c7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff057224ULL, 0x000fc600078e00ffULL, 0x0000000000067805ULL, 0x002fc80000015200ULL,
0x01760400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x006fc4000780480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a06087210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0a7824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140aULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e060aULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff7800720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x000000026f6f7824ULL, 0x000fe200078e00ffULL, 0x00000100797c7810ULL, 0x000fe20007ffe0ffULL,
0x3db504f309047820ULL, 0x010fe20000410000ULL, 0x0001768800777811ULL, 0x040fe200078e18ffULL,
0x000000ffff697224ULL, 0x000fe200078e00ffULL, 0xffffffff67687810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff667224ULL, 0x000fe200078e00ffULL, 0x00000009676a7810ULL, 0x000fe40007ffe0ffULL,
0x00017608007b7811ULL, 0x000fc400078e28ffULL, 0x0000000269057810ULL, 0x004fe20007ffe0ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000006e7d6e7224ULL, 0x010fe200078e02ffULL,
0x00000001666d7812ULL, 0x000fc400078e0cffULL, 0x000000780500720cULL, 0x000fda0003f06070ULL,
0x00000cd000008947ULL, 0x008fea0003800000ULL, 0x00000003ff107819ULL, 0x002fe20000011603ULL,
0x00000100690b7824ULL, 0x000fc600078e027cULL, 0x00000004100c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000b70067217ULL, 0x000fe40007800000ULL, 0x0000000c10167810ULL, 0x000fe20007ffe0ffULL,
0x000000010c057824ULL, 0x000fe200078e0203ULL, 0x0000001010187810ULL, 0x000fe20007ffe0ffULL,
0x000000080c087824ULL, 0x000fe200078e00ffULL, 0x0000000810127810ULL, 0x000fe20007ffe0ffULL,
0x00000001060b7824ULL, 0x000fe200078e0a0bULL, 0x0000001810207810ULL, 0x000fe20007ffe0ffULL,
0x0000000816067824ULL, 0x000fe200078e00ffULL, 0xfffffff808257812ULL, 0x000fe200078ee205ULL,
0x0000000116057824ULL, 0x100fe200078e0203ULL, 0x0000000b0c00720cULL, 0x080fe20003f26070ULL,
0x00000001181f7824ULL, 0x000fe200078e0203ULL, 0x0000001c10227810ULL, 0x000fe20007ffe0ffULL,
0x0000000818087824ULL, 0x000fe200078e00ffULL, 0xfffffff806297812ULL, 0x000fe200078ee205ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x0000000b1200720cULL, 0x0c0fe20003f06070ULL,
0x0000000112077824ULL, 0x000fe200078e0203ULL, 0xfffffff8081f7812ULL, 0x000fe200078ee21fULL,
0x0000000102087824ULL, 0x000fe200078e0210ULL, 0x0000007006067812ULL, 0x000fe200078ec0ffULL,
0x00000008120a7824ULL, 0x000fe200078e00ffULL, 0x00000014101a7810ULL, 0x000fe20007ffe0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000000b1800720cULL, 0x000fc40003fa6070ULL,
0xfffffff80a277812ULL, 0x000fe200078ee207ULL, 0x00000001020c7824ULL, 0x000fe200078e020cULL,
0x000064006e077a11ULL, 0x000fe200078438ffULL, 0x0000000120117824ULL, 0x000fe200078e0203ULL,
0x0000000608147212ULL, 0x000fe200078efcffULL, 0x00000008200e7824ULL, 0x000fe200078e00ffULL,
0x000065006e057a11ULL, 0x000fe200010f3cffULL, 0x0000000102127824ULL, 0x000fe200078e0212ULL,
0x0000001407147210ULL, 0x000fe20007f5e0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff80e117812ULL, 0x000fc400078ee211ULL, 0x00000020101c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000122177824ULL, 0x000fe200078e0203ULL, 0x000000060c0e7212ULL, 0x080fe200078efcffULL,
0x0000000822087824ULL, 0x000fe200078e00ffULL, 0x00000028101e7810ULL, 0x000fe20007ffe0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000070e0e7210ULL, 0x000fe40007f7e0ffULL,
0xfffffff808177812ULL, 0x000fe200078ee217ULL, 0x000000011a1b7824ULL, 0x000fe200078e0203ULL,
0x00000006120c7212ULL, 0x000fe200078efcffULL, 0x000000081a0a7824ULL, 0x000fc400078e00ffULL,
0x0000000102087824ULL, 0x000fe200078e0216ULL, 0x000000070c0c7210ULL, 0x000fe20007f9e0ffULL,
0x0000000102187824ULL, 0x000fe200078e0218ULL, 0xfffffff80a1b7812ULL, 0x000fe200078ee21bULL,
0x0000000110127824ULL, 0x000fe400078e0203ULL, 0x0000000109157824ULL, 0x000fe200010e0605ULL,
0x0000000b1600720cULL, 0x000fe20003f46070ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000000712167812ULL, 0x000fc600078ec0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000000608127212ULL, 0x080fe400078efcffULL, 0x0ffffff816237812ULL, 0x000fe200078ef803ULL,
0x00000002000a7824ULL, 0x000fe200078e026dULL, 0x0000000618087212ULL, 0x000fe200078efcffULL,
0x000000010d0f7824ULL, 0x000fe200018e0605ULL, 0x0000000b1000720cULL, 0x000fe20003f66070ULL,
0x000000011c1d7824ULL, 0x000fe200078e0203ULL, 0x000010000a0a7811ULL, 0x000fe200078e68ffULL,
0x000000081c187824ULL, 0x000fe200078e00ffULL, 0x0000000708087210ULL, 0x080fe20007fde0ffULL,
0x00000001130d7824ULL, 0x000fe200020e0605ULL, 0x0000000712127210ULL, 0x000fe20007f9e0ffULL,
0x0000001023237824ULL, 0x000fe200078e020aULL, 0xfffffff8181d7812ULL, 0x000fe200078ee21dULL,
0x0000000102187824ULL, 0x000fe200078e021aULL, 0x0000002410167810ULL, 0x000fe20007ffe0ffULL,
0x0000000109137824ULL, 0x100fe200020e0605ULL, 0x0000000b1a00720cULL, 0x080fe20003f86070ULL,
0x0000000119097824ULL, 0x000fe200030e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014237faeULL, 0x0003e2000d901c46ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000000b2000720cULL, 0x000fc60003f66070ULL, 0x0000001025257824ULL, 0x000fe200078e020aULL,
0x0000000618187212ULL, 0x080fe200078efcffULL, 0x0000000102207824ULL, 0x000fe400078e0220ULL,
0x00000008161a7824ULL, 0x000fe200078e00ffULL, 0x000000000e257faeULL, 0x0005e2000c901c46ULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000000b2200720cULL, 0x000fe40003f26070ULL,
0x0000000718187210ULL, 0x000fe20007fde0ffULL, 0x0000000102227824ULL, 0x000fe200078e0222ULL,
0x0000000620147212ULL, 0x002fe200078efcffULL, 0x0000000116157824ULL, 0x000fc400078e0203ULL,
0x0000008022227825ULL, 0x000fc600078e00ffULL, 0xfffffff81a2b7812ULL, 0x000fe200078ee215ULL,
0x0000000119197824ULL, 0x100fe200030e0605ULL, 0x0000000714147210ULL, 0x080fe20007fde0ffULL,
0x0000000102207824ULL, 0x000fe200078e021cULL, 0x00000006220e7212ULL, 0x004fe200078efcffULL,
0x0000001027257824ULL, 0x000fe400078e020aULL, 0x0000000121157824ULL, 0x000fe200030e0605ULL,
0x000000070e0e7210ULL, 0x000fe20007fde0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x000000000c257faeULL, 0x0003e2000c101c46ULL, 0x0000000b1c00720cULL, 0x000fc40003f06070ULL,
0x0000001029277824ULL, 0x100fe200078e020aULL, 0x0000002c101c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001230f7824ULL, 0x000fe400030e0605ULL, 0x000000101f237824ULL, 0x000fe200078e020aULL,
0x0000000012277faeULL, 0x0005e2000d101c46ULL, 0x0000000b1600720cULL, 0x000fe20003f46070ULL,
0x0000000102167824ULL, 0x000fe200078e0216ULL, 0x00000006200c7212ULL, 0x002fe200078efcffULL,
0x000000011e0d7824ULL, 0x140fe200078e0203ULL, 0x0000000008237faeULL, 0x0003e2000e901c46ULL,
0x000000081e207824ULL, 0x000fe200078e00ffULL, 0x000000070c0c7210ULL, 0x000fe20007fde0ffULL,
0x000000011c1a7824ULL, 0x000fe200078e0203ULL, 0x0000000b1e00720cULL, 0x000fe20003fa6070ULL,
0x000000081c297824ULL, 0x000fe200078e00ffULL, 0xfffffff820257812ULL, 0x000fe200078ee20dULL,
0x0000008016127825ULL, 0x004fe200078e00ffULL, 0x0000003010167810ULL, 0x000fc40007ffe0ffULL,
0xfffffff829277812ULL, 0x000fe200078ee21aULL, 0x00000001210d7824ULL, 0x000fe200030e0605ULL,
0x00000006121a7212ULL, 0x000fe200078efcffULL, 0x00000001021e7824ULL, 0x000fe400078e021eULL,
0x000000101b217824ULL, 0x100fe200078e020aULL, 0x000000071a1a7210ULL, 0x000fe20007fde0ffULL,
0x0000001011117824ULL, 0x000fe400078e020aULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000000018217faeULL, 0x0005e2000e101c46ULL, 0x0000000b1c00720cULL, 0x000fc40003f86070ULL,
0x0000000102127824ULL, 0x000fe200078e021cULL, 0x0000000014117faeULL, 0x0007e2000d901c46ULL,
0x0000000b1600720cULL, 0x000fe20003f66070ULL, 0x00000001131b7824ULL, 0x000fe200030e0605ULL,
0x000000061e087212ULL, 0x082fe200078efcffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000003c101c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000708087210ULL, 0x000fe20007fde0ffULL,
0x0000000116187824ULL, 0x004fe200078e0203ULL, 0x0000000612127212ULL, 0x000fe200078efcffULL,
0x0000000816197824ULL, 0x000fc400078e00ffULL, 0x0000000102167824ULL, 0x000fe400078e0216ULL,
0x000000011f097824ULL, 0x000fe200030e0605ULL, 0xfffffff819197812ULL, 0x000fe200078ee218ULL,
0x0000008016147825ULL, 0x008fe200078e00ffULL, 0x0000003410167810ULL, 0x000fe40007ffe0ffULL,
0x0000000712127210ULL, 0x000fe20007fde0ffULL, 0x0000001017177824ULL, 0x000fe200078e020aULL,
0x0000000614147212ULL, 0x000fe200078efcffULL, 0x0000000116187824ULL, 0x000fc400078e0203ULL,
0x00000008161f7824ULL, 0x000fe200078e00ffULL, 0x000000000e177faeULL, 0x0003e2000c901c46ULL,
0x0000000102117824ULL, 0x000fe200078e0216ULL, 0x0000000b1600720cULL, 0x000fe20003f26070ULL,
0x0000000113137824ULL, 0x000fe200030e0605ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee218ULL,
0x000000101d1d7824ULL, 0x000fe200078e020aULL, 0x0000003810187810ULL, 0x000fe20007ffe0ffULL,
0x0000000102167824ULL, 0x000fe200078e021cULL, 0x0000000714147210ULL, 0x000fe20007fde0ffULL,
0x000000081c217824ULL, 0x000fe200078e00ffULL, 0x000000000c1d7faeULL, 0x0005e2000c101c46ULL,
0x0000000102107824ULL, 0x000fe200078e0218ULL, 0x0000000b1c00720cULL, 0x000fe20003f06070ULL,
0x00000080110e7825ULL, 0x002fc800078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000060e0e7212ULL, 0x000fc600078efcffULL, 0x000000102b177824ULL, 0x000fe200078e020aULL,
0x0000000610107212ULL, 0x080fe200078efcffULL, 0x0000000115157824ULL, 0x100fe200030e0605ULL,
0x000000070e0e7210ULL, 0x000fe20007fde0ffULL, 0x00000080160c7825ULL, 0x004fe200078e00ffULL,
0x000000001a177faeULL, 0x0003e2000d101c46ULL, 0x0000000b1800720cULL, 0x000fe40003f46070ULL,
0x000000010f0f7824ULL, 0x000fe200030e0605ULL, 0x0000000710107210ULL, 0x000fe20007fde0ffULL,
0x00000001180b7824ULL, 0x000fe200078e0203ULL, 0x000000060c067212ULL, 0x000fe200078efcffULL,
0x0000000818187824ULL, 0x000fc400078e00ffULL, 0x000000011c167824ULL, 0x000fe400078e0203ULL,
0x0000000111117824ULL, 0x000fe200030e0605ULL, 0xfffffff8181d7812ULL, 0x000fe200078ee20bULL,
0x00000010250b7824ULL, 0x000fe200078e020aULL, 0xfffffff821217812ULL, 0x000fe200078ee216ULL,
0x0000001027177824ULL, 0x102fe200078e020aULL, 0x0000000706067210ULL, 0x000fe20007fde0ffULL,
0x0000001019197824ULL, 0x100fe200078e020aULL, 0x00000000080b7faeULL, 0x0003e2000e901c46ULL,
0x000000101f1b7824ULL, 0x000fc400078e020aULL, 0x000000101d1d7824ULL, 0x100fe200078e020aULL,
0x0000000012177faeULL, 0x0003e2000e101c46ULL, 0x00000010211f7824ULL, 0x000fe400078e020aULL,
0x000000010d077824ULL, 0x000fe200030e0605ULL, 0x0000000014197faeULL, 0x0003e8000d901c46ULL,
0x000000000e1b7faeULL, 0x0003e8000c901c46ULL, 0x00000000101d7faeULL, 0x0003e8000d101c46ULL,
0x00000000061f7faeULL, 0x0003e2000c101c46ULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x0000000403087811ULL, 0x042fe200078fe8ffULL, 0x0000001003217824ULL, 0x040fe200078e00ffULL,
0x00000010030e7811ULL, 0x000fc400078fe8ffULL, 0x0000000803097811ULL, 0x040fe200078fe8ffULL,
0x0000000108057824ULL, 0x140fe200078e0203ULL, 0x0000001403107811ULL, 0x040fe200078fe8ffULL,
0x0000000808067824ULL, 0x000fe200078e00ffULL, 0x0000000c030b7811ULL, 0x040fe200078fe8ffULL,
0x000000010e077824ULL, 0x040fe200078e0203ULL, 0x0000001803137811ULL, 0x000fe200078fe8ffULL,
0x000000080e127824ULL, 0x000fe200078e00ffULL, 0xfffffff806377812ULL, 0x000fe200078ee205ULL,
0x0000000109057824ULL, 0x000fe200078e0203ULL, 0x0000002003117811ULL, 0x000fe200078fe8ffULL,
0x00000008090c7824ULL, 0x000fe200078e00ffULL, 0xfffffff812317812ULL, 0x000fe200078ee207ULL,
0x00000001100a7824ULL, 0x040fe200078e0203ULL, 0x0000002403187811ULL, 0x000fe200078fe8ffULL,
0x00000008102f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c357812ULL, 0x000fe200078ee205ULL,
0x000000010b067824ULL, 0x100fe200078e0203ULL, 0x0000001c03127811ULL, 0x000fe200078fe8ffULL,
0x000000080b337824ULL, 0x000fe200078e00ffULL, 0x00000028031e7811ULL, 0x000fe200078fe8ffULL,
0x0000000113057824ULL, 0x100fe200078e0203ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee20aULL,
0x00000008130c7824ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe200078ee206ULL,
0x0000000111077824ULL, 0x100fe200078e0203ULL, 0x00000030031b7811ULL, 0x000fe200078fe8ffULL,
0x0000000811147824ULL, 0x000fe200078e00ffULL, 0x00000034031c7811ULL, 0x040fe200078fe8ffULL,
0x00000001180a7824ULL, 0x000fe200078e0203ULL, 0xfffffff80c2d7812ULL, 0x000fe200078ee205ULL,
0x0000000818277824ULL, 0x000fe200078e00ffULL, 0x0000002c03197811ULL, 0x000fe200078fe8ffULL,
0x0000000112067824ULL, 0x000fe200078e0203ULL, 0xfffffff814297812ULL, 0x000fe200078ee207ULL,
0x00000008122b7824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee20aULL,
0x000000011e057824ULL, 0x140fe200078e0203ULL, 0x00000038031d7811ULL, 0x000fe200078fe8ffULL,
0x000000081e0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee206ULL,
0x000000011b077824ULL, 0x000fe200078e0203ULL, 0x0000003c031a7811ULL, 0x000fe200078fe8ffULL,
0x000000081b147824ULL, 0x000fe200078e00ffULL, 0xfffffff80c257812ULL, 0x000fe200078ee205ULL,
0x000000011c0a7824ULL, 0x040fe200078e0203ULL, 0x0000000303057211ULL, 0x000fe200078fe8ffULL,
0x000000081c0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff814237812ULL, 0x000fe200078ee207ULL,
0x0000000119067824ULL, 0x000fe200078e0203ULL, 0x0000007021217812ULL, 0x000fe200078ec0ffULL,
0x00000008190d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20aULL,
0x0000000200077824ULL, 0x000fe200078e026dULL, 0x000064006e1f7a11ULL, 0x000fe200078038ffULL,
0x000000011d0a7824ULL, 0x100fe200078e0203ULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee206ULL,
0x000000081d157824ULL, 0x000fe200078e00ffULL, 0x0000000705067812ULL, 0x000fe200078ec0ffULL,
0x000000011a0c7824ULL, 0x040fe200078e0203ULL, 0x0000100007267811ULL, 0x000fe200078e68ffULL,
0x000000081a177824ULL, 0x000fe200078e00ffULL, 0xfffffff815057812ULL, 0x000fe200078ee20aULL,
0x00000001020a7824ULL, 0x000fe200078e0209ULL, 0x0ffffff806397812ULL, 0x000fe200078ef803ULL,
0x0000001037377824ULL, 0x000fe200078e0226ULL, 0xfffffff817077812ULL, 0x000fe200078ee20cULL,
0x0000001035357824ULL, 0x100fe200078e0226ULL, 0x0000000203067211ULL, 0x000fe200078fe8ffULL,
0x0000001039397824ULL, 0x100fe200078e0226ULL, 0x000065006e3b7a11ULL, 0x000fe200000f3cffULL,
0x0000001033337824ULL, 0x000fc400078e0226ULL, 0x0000001031317824ULL, 0x100fe400078e0226ULL,
0x000000102f2f7824ULL, 0x100fe400078e0226ULL, 0x000000102d2d7824ULL, 0x100fe400078e0226ULL,
0x000000102b2b7824ULL, 0x100fe400078e0226ULL, 0x0000001029297824ULL, 0x100fe400078e0226ULL,
0x0000001027277824ULL, 0x000fc400078e0226ULL, 0x0000001025257824ULL, 0x100fe400078e0226ULL,
0x000000100d247824ULL, 0x100fe400078e0226ULL, 0x0000001023237824ULL, 0x100fe400078e0226ULL,
0x000000100f227824ULL, 0x100fe400078e0226ULL, 0x0000001005057824ULL, 0x100fe400078e0226ULL,
0x0000001007267824ULL, 0x000fc400078e0226ULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x00000001020c7824ULL, 0x000fe200078e020bULL, 0x0000002106067212ULL, 0x000fe200078efcffULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0x000000061f067210ULL, 0x000fe20007f1e0ffULL,
0x00000001020e7824ULL, 0x000fe200078e020eULL, 0x000000210a0a7212ULL, 0x000fe200078efcffULL,
0x0000000102087824ULL, 0x000fe400078e0208ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000000210e0e7212ULL, 0x000fc600078efcffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000002108087212ULL, 0x000fc600078efcffULL,
0x0000000107077824ULL, 0x000fe200000e063bULL, 0x0000000a1f0a7210ULL, 0x040fe20007f1e0ffULL,
0x0000000102107824ULL, 0x000fe200078e0210ULL, 0x000000210c0c7212ULL, 0x000fe200078efcffULL,
0x0000000102137824ULL, 0x040fe200078e0213ULL, 0x000000081f087210ULL, 0x040fe20007f3e0ffULL,
0x0000000102147824ULL, 0x040fe200078e0212ULL, 0x0000000c1f0c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000102167824ULL, 0x000fe200078e0211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006397faeULL, 0x0003e2000b901c46ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000008013127825ULL, 0x000fe200078e00ffULL, 0x0000002110107212ULL, 0x000fc600078efcffULL,
0x000000010b0b7824ULL, 0x000fe200000e063bULL, 0x0000000e1f0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000002112127212ULL, 0x000fc600078efcffULL,
0x0000000102407824ULL, 0x000fe200078e0218ULL, 0x0000002114147212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x0000000102427824ULL, 0x000fe200078e021eULL,
0x0000002116167212ULL, 0x000fe200078efcffULL, 0x00000001023e7824ULL, 0x040fe400078e0219ULL,
0x00000001023c7824ULL, 0x040fe200078e021bULL, 0x000000161f167210ULL, 0x000fe20007f7e0ffULL,
0x00000001021c7824ULL, 0x040fe400078e021cULL, 0x00000001021b7824ULL, 0x040fe400078e021dULL,
0x0000000102187824ULL, 0x000fc400078e021aULL, 0x0000008040407825ULL, 0x000fc800078e00ffULL,
0x0000008042427825ULL, 0x000fe200078e00ffULL, 0x00000021401e7212ULL, 0x000fc600078efcffULL,
0x000000010f0f7824ULL, 0x000fe200000e063bULL, 0x000000101f107210ULL, 0x000fe20007f1e0ffULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x0000002142207212ULL, 0x000fc600078efcffULL,
0x0000000109097824ULL, 0x100fe200008e063bULL, 0x000000121f127210ULL, 0x000fe20007f3e0ffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x000000213e3e7212ULL, 0x080fe400078efcffULL,
0x0000000008377faeULL, 0x0003e2000b901c46ULL, 0x000000010d0d7824ULL, 0x100fe200010e063bULL,
0x000000141f147210ULL, 0x000fe20007f5e0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000213c3c7212ULL, 0x080fe200078efcffULL, 0x000000000a357faeULL, 0x0003e4000b901c46ULL,
0x000000801b1a7825ULL, 0x000fe200078e00ffULL, 0x000000211c1c7212ULL, 0x080fe200078efcffULL,
0x000000000c337faeULL, 0x0003e4000b901c46ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x000000211a1a7212ULL, 0x080fe200078efcffULL, 0x000000000e317faeULL, 0x0003e2000b901c46ULL,
0x0000001c1f1c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000111117824ULL, 0x100fe200000e063bULL,
0x0000002118187212ULL, 0x000fe200078efcffULL, 0x0000000113137824ULL, 0x100fe200008e063bULL,
0x0000001e1f1e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000115157824ULL, 0x100fe200010e063bULL,
0x000000201f207210ULL, 0x000fe20007f3e0ffULL, 0x0000000117177824ULL, 0x100fe200018e063bULL,
0x0000003e1f3e7210ULL, 0x040fe20007f5e0ffULL, 0x00000000102f7faeULL, 0x0003e2000b901c46ULL,
0x0000003c1f3c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000143217824ULL, 0x100fe200008e063bULL,
0x0000001a1f1a7210ULL, 0x000fe20007fbe0ffULL, 0x000000013f3f7824ULL, 0x100fe200010e063bULL,
0x000000181f187210ULL, 0x000fe20007fde0ffULL, 0x00000001411f7824ULL, 0x100fe200000e063bULL,
0x00000000122d7faeULL, 0x0003e2000b901c46ULL, 0x000000013d3d7824ULL, 0x000fc400018e063bULL,
0x000000011d1d7824ULL, 0x100fe200020e063bULL, 0x00000000142b7faeULL, 0x0003e2000b901c46ULL,
0x000000011b1b7824ULL, 0x100fe400028e063bULL, 0x0000000119197824ULL, 0x000fe200030e063bULL,
0x0000000016297faeULL, 0x0003e8000b901c46ULL, 0x000000001e277faeULL, 0x0003e8000b901c46ULL,
0x0000000020257faeULL, 0x0003e8000b901c46ULL, 0x000000003e247faeULL, 0x0003e8000b901c46ULL,
0x000000003c237faeULL, 0x0003e8000b901c46ULL, 0x000000001c227faeULL, 0x0003e8000b901c46ULL,
0x000000001a057faeULL, 0x0003e8000b901c46ULL, 0x0000000018267faeULL, 0x0003e4000b901c46ULL,
0x0000000000057919ULL, 0x002e620000002700ULL, 0x000000046c6c7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff6e7424ULL, 0x000fc400078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000766c00720cULL, 0x000fda0003f06070ULL, 0x00000004ff078424ULL, 0x000fe400078e00ffULL,
0x00006a0005057a24ULL, 0x002fc800078e02ffULL, 0x0000000205068824ULL, 0x000fe200078e026cULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000660006068625ULL, 0x000fe200078e0007ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000006066e8981ULL, 0x000322000c1e1900ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x002fc80000000000ULL,
0xfffffff803067812ULL, 0x000fe200078ec0ffULL, 0x0000000200417824ULL, 0x000fe200078e0266ULL,
0x0000000105407810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000706067812ULL, 0x000fc400078ef803ULL, 0x0000100041417811ULL, 0x000fc600078e68ffULL,
0x0000000106077824ULL, 0x040fe400078e0205ULL, 0x0000000806087824ULL, 0x000fca00078e00ffULL,
0xfffffff808087812ULL, 0x000fe200078ee207ULL, 0x0000000806077824ULL, 0x040fe400078e00ffULL,
0x0000000106067824ULL, 0x000fe400078e0240ULL, 0x0000001008087824ULL, 0x000fc600078e0241ULL,
0xfffffff807067812ULL, 0x000fe400078ee206ULL, 0x000000000820783bULL, 0x000e660000000200ULL,
0x0000001006107824ULL, 0x000fcc00078e0241ULL, 0x000000001010783bULL, 0x000ea20000000200ULL,
0x0000002000597306ULL, 0x002fe20000009400ULL, 0x00000018ff077819ULL, 0x000fe20000011421ULL,
0x0001000020447824ULL, 0x000fe200078e00ffULL, 0x00000018ff067819ULL, 0x000fe40000011420ULL,
0x00000018ff097819ULL, 0x000fe40000011423ULL, 0x00000018ff087819ULL, 0x000fe20000011422ULL,
0x00000020005c7306ULL, 0x000e620000005400ULL, 0x00000018ff457819ULL, 0x004fc40000011411ULL,
0x00000018ff0a7819ULL, 0x020fe40000011410ULL, 0x00000018ff527819ULL, 0x000fe40000011413ULL,
0x00000018ff4a7819ULL, 0x000fe20000011412ULL, 0x0000002000427306ULL, 0x0004e2000000d400ULL,
0x00000018ff447819ULL, 0x000fce0000011444ULL, 0x0000000700547306ULL, 0x000fe20000209400ULL,
0x0000010020207824ULL, 0x004fe200078e00ffULL, 0x0000005c5900720bULL, 0x002fe20003f1d000ULL,
0x0000010022597824ULL, 0x000fe200078e00ffULL, 0x00000020035c7810ULL, 0x000fc80007ffe0ffULL,
0x0000000700577306ULL, 0x000fe20000205400ULL, 0xfffffff85c5c7812ULL, 0x000fcc00078ec0ffULL,
0x0000000142420812ULL, 0x008fe200078efcffULL, 0x00000007004d7306ULL, 0x000ff0000020d400ULL,
0x00000045000d7306ULL, 0x000ff00000209400ULL, 0x00000045000c7306ULL, 0x000ff00000205400ULL,
0x0000004500077306ULL, 0x0003f0000020d400ULL, 0x0000002100487306ULL, 0x000fe20000009400ULL,
0x00000018ff457819ULL, 0x002fe20000011420ULL, 0x0001000021207824ULL, 0x000fca00078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe20000011420ULL, 0x0000002100497306ULL, 0x000e700000005400ULL,
0x00000021004f7306ULL, 0x0004f0000000d400ULL, 0x0000000600157306ULL, 0x000fe20000209400ULL,
0x0000010021217824ULL, 0x004fe200078e00ffULL, 0x000000494800720bULL, 0x002fc80003fbd000ULL,
0x00000018ff5e7819ULL, 0x000fe20000011421ULL, 0x0001000022217824ULL, 0x000fe200078e00ffULL,
0x0000000600147306ULL, 0x000e680000205400ULL, 0x00000018ff607819ULL, 0x000fc60000011421ULL,
0x000000014f4f5812ULL, 0x008fe200078efcffULL, 0x0000000600437306ULL, 0x000eb0000020d400ULL,
0x0000000900537306ULL, 0x000fe20000209400ULL, 0x000000141500720bULL, 0x002fce0003f5d000ULL,
0x00000009004c7306ULL, 0x000e6c0000205400ULL, 0x0000000143432812ULL, 0x004fe400078efcffULL,
0x00000009005a7306ULL, 0x000eb0000020d400ULL, 0x0000000a000e7306ULL, 0x000fe20000209400ULL,
0x0000004c5300720bULL, 0x002fce0003f5d000ULL, 0x0000000a000f7306ULL, 0x000fec0000205400ULL,
0x000000015a5a2812ULL, 0x004fe400078efcffULL, 0x0000000a00067306ULL, 0x000ff0000020d400ULL,
0x0000005200097306ULL, 0x000ff00000209400ULL, 0x00000052000a7306ULL, 0x000ff00000205400ULL,
0x00000052000b7306ULL, 0x000ff0000020d400ULL, 0x0000002200167306ULL, 0x000ff00000009400ULL,
0x0000002200177306ULL, 0x000e700000005400ULL, 0x0000005e00527306ULL, 0x000ff00000209400ULL,
0x0000005e00637306ULL, 0x000fe20000205400ULL, 0x000000171600720bULL, 0x002fce0003f3d000ULL,
0x0000005e00717306ULL, 0x0003f0000020d400ULL, 0x0000002200587306ULL, 0x0004e2000000d400ULL,
0x00000018ff5e7819ULL, 0x002fe40000011459ULL, 0x000000075c597812ULL, 0x000fca00078ef803ULL,
0x0000000159497824ULL, 0x040fe200078e0205ULL, 0x0000004500507306ULL, 0x000fe20000209400ULL,
0x0000000859227824ULL, 0x044fe400078e00ffULL, 0x0000000159407824ULL, 0x040fe400078e0240ULL,
0x0000000859597824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe400078ee249ULL,
0x0000004500557306ULL, 0x000e620000205400ULL, 0x0000000158581812ULL, 0x008fc400078efcffULL,
0x0000001022167824ULL, 0x000fe200078e0241ULL, 0xfffffff859407812ULL, 0x000fc800078ee240ULL,
0x00000008003e7306ULL, 0x000fe20000209400ULL, 0x000000001614783bULL, 0x000ea20000000200ULL,
0x0000001040407824ULL, 0x000fcc00078e0241ULL, 0x00000008003f7306ULL, 0x000ee20000205400ULL,
0x000000555000720bULL, 0x002fce0003fdd000ULL, 0x0000002300217306ULL, 0x000ff00000009400ULL,
0x0000002300227306ULL, 0x000e620000005400ULL, 0x0000003f3e00720bULL, 0x008fe40003f1d000ULL,
0x00000007033e7812ULL, 0x000fc800078ec0ffULL, 0x000000083e3e7812ULL, 0x100fe200078ef803ULL,
0x0000000800517306ULL, 0x000ef0000020d400ULL, 0x0000004a003c7306ULL, 0x000fe20000209400ULL,
0x000000222100720bULL, 0x002fe20003f7d000ULL, 0x0000010023217824ULL, 0x000fe200078e00ffULL,
0x00000004ff227819ULL, 0x000fe20000011603ULL, 0x0001000017597824ULL, 0x004fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fc40000011415ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000004a003d7306ULL, 0x000fe20000205400ULL, 0x00000002053f7824ULL, 0x000fe200078e0222ULL,
0x0000000151510812ULL, 0x008fe400078efcffULL, 0x00000018ff4c7819ULL, 0x000fe40000011416ULL,
0x00000018ff747819ULL, 0x000fe40000011417ULL, 0x0000004a00087306ULL, 0x000fe2000020d400ULL,
0x00000018ff597819ULL, 0x000fc40000011459ULL, 0x0000000205057810ULL, 0x000fca0007ffe0ffULL,
0x00000044004e7306ULL, 0x000ff00000209400ULL, 0x00000044005f7306ULL, 0x000e700000205400ULL,
0x00000045004a7306ULL, 0x000eb0000020d400ULL, 0x0000005b00207306ULL, 0x000fe20000209400ULL,
0x0000005f4e00720bULL, 0x002fe20003f9d000ULL, 0x00010000234e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001144eULL, 0x0000005b005d7306ULL, 0x000e620000205400ULL,
0x000000014a4a6812ULL, 0x004fc800078efcffULL, 0x0000004a4343723eULL, 0x000fc600000010ffULL,
0x00000044004b7306ULL, 0x000eb0000020d400ULL, 0x0000002300617306ULL, 0x0006e2000000d400ULL,
0x0000005d2000720bULL, 0x002fe20003fdd000ULL, 0x000000013e207824ULL, 0x140fe200078e023fULL,
0x000000023e3f7810ULL, 0x000fc40007ffe03fULL, 0x000000014b4b4812ULL, 0x004fe200078efcffULL,
0x000000103e237824ULL, 0x008fe200078e00ffULL, 0x000000575400720bULL, 0x000fe20003f9d000ULL,
0x0000002100557306ULL, 0x000fe20000209400ULL, 0x000000424b42723eULL, 0x000fe200000010ffULL,
0x000000103e3e7824ULL, 0x000fe200078e00ffULL, 0xfffffff023207812ULL, 0x000fe400078ee220ULL,
0x0000000161613812ULL, 0x000fe400078efcffULL, 0x00000018ff547819ULL, 0x000fe20000011414ULL,
0x0000001020207824ULL, 0x000fe200078e00ffULL, 0x0000002100577306ULL, 0x000e620000205400ULL,
0xfffffff03e3f7812ULL, 0x000fc400078ee23fULL, 0x000000014d4d4812ULL, 0x000fca00078efcffULL,
0x0000002100657306ULL, 0x0004f0000020d400ULL, 0x0000005b00727306ULL, 0x000ee2000020d400ULL,
0x000000002020783bULL, 0x004ea20000000200ULL, 0x000000575500720bULL, 0x002fcc0003f3d000ULL,
0x0000006000447306ULL, 0x000fee0000209400ULL, 0x0000000165651812ULL, 0x008fe200078efcffULL,
0x0000006000457306ULL, 0x000e620000205400ULL, 0x0000000172726812ULL, 0x000fe400078efcffULL,
0x000000635200720bULL, 0x000fca0003fdd000ULL, 0x0000005e00487306ULL, 0x000ff00000209400ULL,
0x0000005e00497306ULL, 0x000ee20000205400ULL, 0x0000000171716812ULL, 0x000fe400078efcffULL,
0x000000454400720bULL, 0x002fca0003fbd000ULL, 0x0000006000567306ULL, 0x000e62000020d400ULL,
0x000000422038723cULL, 0x004bee0000041838ULL, 0x0001000010427824ULL, 0x020fe200078e00ffULL,
0x0000005c004e7306ULL, 0x000fe20000209400ULL, 0x000000494800720bULL, 0x008fc40003fdd000ULL,
0x000000714d43723eULL, 0x000fe400000010ffULL, 0x0000000156565812ULL, 0x002fc600078efcffULL,
0x0000005c00507306ULL, 0x000e700000205400ULL, 0x00000073005f7306ULL, 0x000ff00000209400ULL,
0x0000007300607306ULL, 0x000ea20000205400ULL, 0x000000504e00720bULL, 0x002fce0003f9d000ULL,
0x00000073005d7306ULL, 0x0003f0000020d400ULL, 0x0000005e005b7306ULL, 0x000ee2000020d400ULL,
0x00000018ff737819ULL, 0x002fe20000011442ULL, 0x0000010010427824ULL, 0x000fe200078e00ffULL,
0x000000605f00720bULL, 0x004fca0003f5d000ULL, 0x0000001000447306ULL, 0x000ff00000009400ULL,
0x0000001000497306ULL, 0x000fe20000005400ULL, 0x000000015b5b6812ULL, 0x008fe400078efcffULL,
0x000000015d5d2812ULL, 0x000fca00078efcffULL, 0x0000001000457306ULL, 0x0003f0000000d400ULL,
0x0000005c006b7306ULL, 0x000ea2000020d400ULL, 0x00000018ff107819ULL, 0x002fe40000011442ULL,
0x0000004f7242723eULL, 0x000fe200000010ffULL, 0x0001000015727824ULL, 0x000fc800078e00ffULL,
0x00000011004e7306ULL, 0x000fe20000009400ULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x000000422034723cULL, 0x000b620000041834ULL, 0x000000016b6b4812ULL, 0x004fcc00078efcffULL,
0x0001000011427824ULL, 0x020fe200078e00ffULL, 0x0000005b5143723eULL, 0x000fe200000010ffULL,
0x0000001100577306ULL, 0x000fe20000005400ULL, 0x0000010011517824ULL, 0x000fe400078e00ffULL,
0x00000018ff717819ULL, 0x000fe40000011442ULL, 0x000000585642723eULL, 0x000fe400000010ffULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0000001100507306ULL, 0x000fe8000000d400ULL,
0x000000422030723cULL, 0x000b680000041830ULL, 0x00000054005c7306ULL, 0x000fe60000209400ULL,
0x000000655a43723eULL, 0x020fe200000010ffULL, 0x0001000014657824ULL, 0x040fe200078e00ffULL,
0x000000616b42723eULL, 0x000fe200000010ffULL, 0x00000100146b7824ULL, 0x000fc400078e00ffULL,
0x00000054005e7306ULL, 0x000e620000205400ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff6b7819ULL, 0x000fe2000001146bULL, 0x00000042202c723cULL, 0x000b68000004182cULL,
0x0000007100557306ULL, 0x000ff00000209400ULL, 0x0000007100567306ULL, 0x000fe20000205400ULL,
0x0000005e5c00720bULL, 0x002fe20003fbd000ULL, 0x00010000125e7824ULL, 0x000fcc00078e00ffULL,
0x0000007100117306ULL, 0x000ff0000020d400ULL, 0x00000014005a7306ULL, 0x000ff00000009400ULL,
0x0000001400617306ULL, 0x000e700000005400ULL, 0x0000001500427306ULL, 0x020ff00000009400ULL,
0x0000001500437306ULL, 0x000ea20000005400ULL, 0x000000615a00720bULL, 0x002fce0003f9d000ULL,
0x0000006500607306ULL, 0x000ff00000209400ULL, 0x0000006500717306ULL, 0x000e620000205400ULL,
0x000000434200720bULL, 0x004fce0003f7d000ULL, 0x00000014005c7306ULL, 0x000ea2000000d400ULL,
0x000000716000720bULL, 0x002fce0003f1d000ULL, 0x0000006b00147306ULL, 0x000fe20000209400ULL,
0x0000010015717824ULL, 0x000fca00078e00ffULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000006b00617306ULL, 0x000e620000205400ULL, 0x000000015c5c4812ULL, 0x004fce00078efcffULL,
0x0000007200437306ULL, 0x000ff00000209400ULL, 0x0000007200607306ULL, 0x000ea20000205400ULL,
0x000000611400720bULL, 0x002fce0003fdd000ULL, 0x0000005400647306ULL, 0x000e70000020d400ULL,
0x0000004c00627306ULL, 0x000fe20000209400ULL, 0x000000604300720bULL, 0x004fce0003f3d000ULL,
0x0000004c00637306ULL, 0x000ea20000205400ULL, 0x0000000164645812ULL, 0x002fce00078efcffULL,
0x0000004c00547306ULL, 0x000e70000020d400ULL, 0x00000073004c7306ULL, 0x000fe20000209400ULL,
0x000000636200720bULL, 0x004fe20003f9d000ULL, 0x0001000016637824ULL, 0x000fca00078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x00000073004a7306ULL, 0x000fec0000205400ULL,
0x0000000154544812ULL, 0x002fe400078efcffULL, 0x0000007300487306ULL, 0x0003f0000020d400ULL,
0x0000007400527306ULL, 0x000fe20000209400ULL, 0x00000018ff737819ULL, 0x002fce000001145eULL,
0x00000073005e7306ULL, 0x000ff00000209400ULL, 0x00000073005f7306ULL, 0x000ff00000205400ULL,
0x00000073005a7306ULL, 0x000ff0000020d400ULL, 0x0000006500737306ULL, 0x0002b0000020d400ULL,
0x0000007400537306ULL, 0x000fe20000205400ULL, 0x0000010012657824ULL, 0x002fce00078e00ffULL,
0x00000074004b7306ULL, 0x000fe2000020d400ULL, 0x0000000173730812ULL, 0x004fce00078efcffULL,
0x0000007100147306ULL, 0x000ff00000209400ULL, 0x0000007100607306ULL, 0x000e700000205400ULL,
0x0000006b00747306ULL, 0x000eb0000020d400ULL, 0x0000007200437306ULL, 0x0006e2000020d400ULL,
0x000000601400720bULL, 0x002fc40003f1d000ULL, 0x0000005c7314723eULL, 0x000fca00000010ffULL,
0x0000001500427306ULL, 0x000262000000d400ULL, 0x0000000174746812ULL, 0x004fe400078efcffULL,
0x00000018ff727819ULL, 0x008fca0000011465ULL, 0x00000071006b7306ULL, 0x000ea2000020d400ULL,
0x000000746415723eULL, 0x002fe400000010ffULL, 0x0000000143431812ULL, 0x000fe400078efcffULL,
0x0000000142423812ULL, 0x000fc600078efcffULL, 0x000000142028723cULL, 0x000b620000041828ULL,
0x0000001600627306ULL, 0x000fe20000009400ULL, 0x000000016b6b0812ULL, 0x004fca00078efcffULL,
0x000000424314723eULL, 0x020fe400000010ffULL, 0x0000001200617306ULL, 0x000fe20000009400ULL,
0x0000006b5d15723eULL, 0x000fce00000010ffULL, 0x0000001600437306ULL, 0x000e620000005400ULL,
0x000000142024723cULL, 0x000b6e0000041824ULL, 0x0000010016157824ULL, 0x020fe200078e00ffULL,
0x0000001200607306ULL, 0x000ea80000005400ULL, 0x00000018ff157819ULL, 0x000fc40000011415ULL,
0x000000436200720bULL, 0x002fe40003f5d000ULL, 0x00000012005c7306ULL, 0x000e70000000d400ULL,
0x0000007200647306ULL, 0x000fe20000209400ULL, 0x000000606100720bULL, 0x004fce0003fdd000ULL,
0x0000007200657306ULL, 0x000fec0000205400ULL, 0x000000015c5c6812ULL, 0x002fe400078efcffULL,
0x0000007200127306ULL, 0x000ff0000020d400ULL, 0x0000006300427306ULL, 0x000ff00000209400ULL,
0x0000006300717306ULL, 0x000e700000205400ULL, 0x0000001700437306ULL, 0x000ff00000009400ULL,
0x0000001700727306ULL, 0x000ea20000005400ULL, 0x000000714200720bULL, 0x002fce0003f7d000ULL,
0x00000016005d7306ULL, 0x000e70000000d400ULL, 0x00000015006b7306ULL, 0x000fe20000209400ULL,
0x000000724300720bULL, 0x004fe40003f1d000ULL, 0x000000004040783bULL, 0x000eaa0000000200ULL,
0x0000001500167306ULL, 0x000ee20000205400ULL, 0x000000015d5d2812ULL, 0x002fce00078efcffULL,
0x0000005900627306ULL, 0x000ff00000209400ULL, 0x0000005900737306ULL, 0x000e620000205400ULL,
0x000000166b00720bULL, 0x008fe20003fbd000ULL, 0x00000100176b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001146bULL, 0x0000006300147306ULL, 0x000ee2000020d400ULL,
0x000000736200720bULL, 0x002fce0003f3d000ULL, 0x0000006b00717306ULL, 0x000fe20000209400ULL,
0x0001000040607824ULL, 0x004fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011443ULL,
0x0000000114143812ULL, 0x008fc800078efcffULL, 0x0000006b00627306ULL, 0x000e620000205400ULL,
0x000000535200720bULL, 0x000fe40003f7d000ULL, 0x0000005d1414723eULL, 0x000fe400000010ffULL,
0x00000018ff5d7819ULL, 0x000fc60000011440ULL, 0x0000001500637306ULL, 0x000eac000020d400ULL,
0x000000014b4b3812ULL, 0x000fe400078efcffULL, 0x00000010004f7306ULL, 0x000fe20000209400ULL,
0x000000627100720bULL, 0x002fe40003f5d000ULL, 0x00000018ff627819ULL, 0x000fca0000011441ULL,
0x00000010004d7306ULL, 0x000e620000205400ULL, 0x0000000163635812ULL, 0x004fe400078efcffULL,
0x0000004a4c00720bULL, 0x000fe20003fbd000ULL, 0x00000100404c7824ULL, 0x000fe200078e00ffULL,
0x000000635415723eULL, 0x000fe400000010ffULL, 0x00000018ff637819ULL, 0x000fe20000011442ULL,
0x0000001700167306ULL, 0x000ea8000000d400ULL, 0x00000014201c723cULL, 0x000b68000004181cULL,
0x0000005900177306ULL, 0x000ee2000020d400ULL, 0x0000004d4f00720bULL, 0x002fe20003f7d000ULL,
0x00010000414d7824ULL, 0x040fe200078e00ffULL, 0x0000000148485812ULL, 0x000fe200078efcffULL,
0x00000100414f7824ULL, 0x000fe200078e00ffULL, 0x000000565500720bULL, 0x000fc40003fbd000ULL,
0x00000018ff557819ULL, 0x000fe2000001144dULL, 0x0000006b00527306ULL, 0x000e62000020d400ULL,
0x0000000116160812ULL, 0x004fe400078efcffULL, 0x000000494400720bULL, 0x000fe20003f1d000ULL,
0x0000010013497824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fc6000001144fULL,
0x0000001000107306ULL, 0x000ea2000020d400ULL, 0x0000000117171812ULL, 0x008fe400078efcffULL,
0x0000000f0e00720bULL, 0x000fe40003f3d000ULL, 0x000000161714723eULL, 0x020fe400000010ffULL,
0x00000018ff747819ULL, 0x000fe20000011449ULL, 0x00000013006b7306ULL, 0x000fe20000009400ULL,
0x0000000152522812ULL, 0x002fe400078efcffULL, 0x000000574e00720bULL, 0x000fc40003f5d000ULL,
0x000000524b15723eULL, 0x000fe400000010ffULL, 0x0000000145450812ULL, 0x000fe200078efcffULL,
0x0000001300717306ULL, 0x000e620000005400ULL, 0x0000000110103812ULL, 0x004fe400078efcffULL,
0x0000000c0d00720bULL, 0x000fe20003f7d000ULL, 0x000000142018723cULL, 0x000b620000041818ULL,
0x0000000106061812ULL, 0x000fe400078efcffULL, 0x0000003d3c00720bULL, 0x000fe20003f3d000ULL,
0x0000005100587306ULL, 0x000fe20000209400ULL, 0x0000000111115812ULL, 0x000fc400078efcffULL,
0x0000000150502812ULL, 0x000fc800078efcffULL, 0x000000501150723eULL, 0x000fe200000010ffULL,
0x00000051005b7306ULL, 0x000ea20000205400ULL, 0x000000716b00720bULL, 0x002fe40003f9d000ULL,
0x0000000107073812ULL, 0x000fe400078efcffULL, 0x000000656400720bULL, 0x000fe40003f7d000ULL,
0x0000000108081812ULL, 0x000fe200078efcffULL, 0x0000005d00547306ULL, 0x000ff00000209400ULL,
0x0000005d00537306ULL, 0x000e620000205400ULL, 0x0000005b5800720bULL, 0x004fc40003f1d000ULL,
0x0000000112123812ULL, 0x000fca00078efcffULL, 0x0000005d00167306ULL, 0x0004f0000020d400ULL,
0x0000006300237306ULL, 0x020fe20000209400ULL, 0x00010000135d7824ULL, 0x004fe200078e00ffULL,
0x000000535400720bULL, 0x002fe20003f7d000ULL, 0x0001000043547824ULL, 0x000fc600078e00ffULL,
0x00000018ff727819ULL, 0x000fe4000001145dULL, 0x0000006300597306ULL, 0x000fe20000205400ULL,
0x00000018ff547819ULL, 0x000fcc0000011454ULL, 0x0000000116163812ULL, 0x008fe200078efcffULL,
0x0000006300157306ULL, 0x000fe2000020d400ULL, 0x0000000a0900720bULL, 0x000fce0003f7d000ULL,
0x00000072005d7306ULL, 0x000fec0000209400ULL, 0x000000010b0b3812ULL, 0x000fe400078efcffULL,
0x0000007200637306ULL, 0x000ff00000205400ULL, 0x0000007200447306ULL, 0x0003f0000020d400ULL,
0x0000005100517306ULL, 0x000ea2000020d400ULL, 0x00000018ff727819ULL, 0x002fce0000011460ULL,
0x0000007300207306ULL, 0x000ff00000209400ULL, 0x0000007300217306ULL, 0x000fe20000205400ULL,
0x0000000151510812ULL, 0x004fe400078efcffULL, 0x0000005f5e00720bULL, 0x000fc40003f1d000ULL,
0x000000510751723eULL, 0x000fc600000010ffULL, 0x0000007300147306ULL, 0x000ff0000020d400ULL,
0x00000040004e7306ULL, 0x000fe20000009400ULL, 0x000000015a5a0812ULL, 0x000fc800078efcffULL,
0x0000005c5a5a723eULL, 0x000fc600000010ffULL, 0x0000004000737306ULL, 0x000e700000005400ULL,
0x00000072006b7306ULL, 0x000ff00000209400ULL, 0x0000007200717306ULL, 0x000ea20000205400ULL,
0x000000734e00720bULL, 0x002fce0003fbd000ULL, 0x00000062004b7306ULL, 0x000ff00000209400ULL,
0x0000006200527306ULL, 0x000fe20000205400ULL, 0x000000716b00720bULL, 0x004fce0003fdd000ULL,
0x0000006200177306ULL, 0x000ff0000020d400ULL, 0x0000001300227306ULL, 0x000e70000000d400ULL,
0x0000007400627306ULL, 0x000ff00000209400ULL, 0x0000007400577306ULL, 0x000fe20000205400ULL,
0x0000000122224812ULL, 0x002fce00078efcffULL, 0x0000007400137306ULL, 0x0003f0000020d400ULL,
0x00000041000e7306ULL, 0x000fe20000009400ULL, 0x00000018ff747819ULL, 0x002fce000001144cULL,
0x00000041000f7306ULL, 0x000e700000005400ULL, 0x0000007400607306ULL, 0x000ff00000209400ULL,
0x0000007400617306ULL, 0x000ea20000205400ULL, 0x0000000f0e00720bULL, 0x002fe20003f5d000ULL,
0x00010000420e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x0000004000497306ULL, 0x000e70000000d400ULL, 0x00000072004a7306ULL, 0x000ee2000020d400ULL,
0x000000616000720bULL, 0x004fce0003f3d000ULL, 0x0000007400407306ULL, 0x000ea2000020d400ULL,
0x0000000149495812ULL, 0x002fe400078efcffULL, 0x000000635d00720bULL, 0x000fe20003fbd000ULL,
0x00000100435d7824ULL, 0x000fc800078e00ffULL, 0x00000042000c7306ULL, 0x000fe20000009400ULL,
0x000000014a4a6812ULL, 0x008fe400078efcffULL, 0x00000018ff097819ULL, 0x000fe4000001145dULL,
0x000000494a4a723eULL, 0x000fc600000010ffULL, 0x00000042000d7306ULL, 0x000e620000005400ULL,
0x0000000140401812ULL, 0x004fe400078efcffULL, 0x0000000144445812ULL, 0x000fe400078efcffULL,
0x000000524b00720bULL, 0x000fe40003fbd000ULL, 0x00000040164b723eULL, 0x000fe200000010ffULL,
0x0000005500727306ULL, 0x000fe20000209400ULL, 0x00000022440a723eULL, 0x000fce00000010ffULL,
0x0000005500747306ULL, 0x000ea20000205400ULL, 0x0000000d0c00720bULL, 0x002fe20003f1d000ULL,
0x00000100420c7824ULL, 0x000fe200078e00ffULL, 0x0000000117175812ULL, 0x000fc800078efcffULL,
0x00000018ff3c7819ULL, 0x000fe2000001140cULL, 0x00000056004f7306ULL, 0x000fe20000209400ULL,
0x000000103f0c7824ULL, 0x000fce00078e00ffULL, 0x00000056005b7306ULL, 0x000e620000205400ULL,
0x000000747200720bULL, 0x004fce0003fdd000ULL, 0x00000043003d7306ULL, 0x000ff00000009400ULL,
0x0000004300607306ULL, 0x000ea20000005400ULL, 0x0000005b4f00720bULL, 0x002fe40003f9d000ULL,
0x00000012085b723eULL, 0x000fca00000010ffULL, 0x00000055004d7306ULL, 0x000e70000020d400ULL,
0x0000000e00557306ULL, 0x000fe20000209400ULL, 0x000000603d00720bULL, 0x004fe40003f3d000ULL,
0x00000010063d723eULL, 0x000fca00000010ffULL, 0x0000000e005e7306ULL, 0x000ea20000205400ULL,
0x000000014d4d6812ULL, 0x002fe400078efcffULL, 0x000000576200720bULL, 0x000fca0003fdd000ULL,
0x00000041004c7306ULL, 0x000e70000000d400ULL, 0x00000042004e7306ULL, 0x000ee2000000d400ULL,
0x0000005e5500720bULL, 0x004fe40003f7d000ULL, 0x0000000113136812ULL, 0x000fc400078efcffULL,
0x000000592300720bULL, 0x000fe40003fdd000ULL, 0x000000130b0b723eULL, 0x000fe200000010ffULL,
0x0000005600417306ULL, 0x000ea2000020d400ULL, 0x000000014c4c2812ULL, 0x002fe400078efcffULL,
0x000000212000720bULL, 0x000fe40003f5d000ULL, 0x0000004c4d16723eULL, 0x000fc600000010ffULL,
0x0000000e00427306ULL, 0x0002a2000020d400ULL, 0x000000014e4e0812ULL, 0x008fe400078efcffULL,
0x000000080500780cULL, 0x000fe40003f05270ULL, 0x0000000115156812ULL, 0x000fc600078efcffULL,
0x0000003c00567306ULL, 0x000fe20000209400ULL, 0x000000000c0c783bULL, 0x002e620000000200ULL,
0x0000000141414812ULL, 0x004fe400078efcffULL, 0x0000000114142812ULL, 0x000fe400078efcffULL,
0x000000411717723eULL, 0x000fe400000010ffULL, 0x0000003c00587306ULL, 0x000ea20000205400ULL,
0x0000000142423812ULL, 0x000fc800078efcffULL, 0x0000004e4242723eULL, 0x000fc600000010ffULL,
0x0000005400537306ULL, 0x000ff00000209400ULL, 0x0000005400067306ULL, 0x000ee20000205400ULL,
0x000000585600720bULL, 0x004fce0003f9d000ULL, 0x0000000900077306ULL, 0x000ff00000209400ULL,
0x0000000900087306ULL, 0x000ea20000205400ULL, 0x000000065300720bULL, 0x008fe20003fbd000ULL,
0x000000500c34723cULL, 0x042b6c0000041834ULL, 0x0000003c003e7306ULL, 0x0002e4000020d400ULL,
0x0000005a0c30723cULL, 0x040b6c0000041830ULL, 0x00000043003f7306ULL, 0x0006e2000000d400ULL,
0x000000080700720bULL, 0x004fe20003f7d000ULL, 0x0000000a0c2c723cULL, 0x000b62000004182cULL,
0x00000045483c723eULL, 0x002fca00000010ffULL, 0x0000005400547306ULL, 0x000e62000020d400ULL,
0x000000013e3e4812ULL, 0x008fe200078efcffULL, 0x0000003c0c38723cULL, 0x000b660000041838ULL,
0x0000003e1543723eULL, 0x000fc600000010ffULL, 0x0000000900557306ULL, 0x000ea2000020d400ULL,
0x000000013f3f1812ULL, 0x000fe200078efcffULL, 0x0000004a0c28723cULL, 0x000b620000041828ULL,
0x0000000154545812ULL, 0x002fce00078efcffULL, 0x000000160c24723cULL, 0x000b620000041824ULL,
0x0000003f5454723eULL, 0x000fe400000010ffULL, 0x0000000155553812ULL, 0x004fca00078efcffULL,
0x000000420c1c723cULL, 0x000b62000004181cULL, 0x000000551455723eULL, 0x000fce00000010ffULL,
0x000000540c18723cULL, 0x000b620000041818ULL, 0x0000001000008944ULL, 0x000fe20003c00000ULL,
0xffffe11000007947ULL, 0x000fcc000383ffffULL, 0x0000000430307220ULL, 0x0a0fe40000410000ULL,
0x000000042c2c7220ULL, 0x080fe40000410000ULL, 0x0000000438387220ULL, 0x080fe40000410000ULL,
0x0000000439397220ULL, 0x080fe40000410000ULL, 0x0000000434347220ULL, 0x080fe40000410000ULL,
0x0000000435357220ULL, 0x000fc40000410000ULL, 0x0000000431317220ULL, 0x080fe40000410000ULL,
0x0000000428057220ULL, 0x080fe40000410000ULL, 0x0000000429067220ULL, 0x080fe40000410000ULL,
0x000000041d077220ULL, 0x080fe40000410000ULL, 0x0000000432227220ULL, 0x080fe40000410000ULL,
0x000000042d327220ULL, 0x000fc40000410000ULL, 0x000000042f0b7220ULL, 0x080fe40000410000ULL,
0x000000042e0a7220ULL, 0x080fe40000410000ULL, 0x000000042a0c7220ULL, 0x080fe40000410000ULL,
0x000000042b0d7220ULL, 0x080fe40000410000ULL, 0x00000004252f7220ULL, 0x080fe40000410000ULL,
0x00000004260e7220ULL, 0x000fc40000410000ULL, 0x00000004270f7220ULL, 0x080fe40000410000ULL,
0x000000041f147220ULL, 0x080fe40000410000ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0030ULL,
0x000000ffff297224ULL, 0x000fe400078e002cULL, 0x000000043a3a7220ULL, 0x080fe40000410000ULL,
0x000000043b3b7220ULL, 0x000fc40000410000ULL, 0x0000000436207220ULL, 0x080fe40000410000ULL,
0x0000000437237220ULL, 0x080fe40000410000ULL, 0x0000000433217220ULL, 0x080fe40000410000ULL,
0x00000004242b7220ULL, 0x080fe40000410000ULL, 0x000000041c2e7220ULL, 0x080fe40000410000ULL,
0x000000041e107220ULL, 0x000fc40000410000ULL, 0x0000000418257220ULL, 0x080fe40000410000ULL,
0x0000000419177220ULL, 0x080fe40000410000ULL, 0x000000041a157220ULL, 0x080fe40000410000ULL,
0x000000041b167220ULL, 0x000fe40000410000ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0038ULL,
0x000000ffff267224ULL, 0x000fc400078e0039ULL, 0x000000ffff277224ULL, 0x000fe400078e0034ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0035ULL, 0x000000ffff287224ULL, 0x000fe400078e0031ULL,
0x000000ffff307224ULL, 0x000fe400078e0005ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0006ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000077087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff1e7224ULL, 0x000fc400078e003aULL,
0x000000ffff1c7224ULL, 0x000fe400078e003bULL, 0x000000ffff247224ULL, 0x000fe400078e000aULL,
0x000000ffff317224ULL, 0x000fe400078e000bULL, 0x000000ffff1b7224ULL, 0x000fe400078e000cULL,
0x000000ffff1a7224ULL, 0x000fe400078e000dULL, 0x000000ffff187224ULL, 0x000fc400078e000eULL,
0x000000ffff197224ULL, 0x000fe400078e000fULL, 0x000000ffff077224ULL, 0x000fc400078e0010ULL,
0x00000000000a7805ULL, 0x002fca0000015200ULL, 0x0000040077057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x006fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a067210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0c7824ULL, 0x000fe200000e0e0bULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140cULL, 0x0000000605057211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e060cULL, 0x0000000205057819ULL, 0x000fc80000001206ULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040077057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000403067824ULL, 0x000fe200078e00ffULL,
0x000000756900720cULL, 0x000fc80003f06070ULL, 0xfffffff006057812ULL, 0x000fca00078ec0ffULL,
0x0000008000057824ULL, 0x000fca00078e0205ULL, 0x0174000005087984ULL, 0x0002a20000000c00ULL,
0x000014f000008947ULL, 0x000fea0003800000ULL, 0x00005a00000e7b06ULL, 0x000ee20000209000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fe20003f85070ULL,
0x0000010069337824ULL, 0x000fe200078e0279ULL, 0x00005a00ff137a12ULL, 0x000fe200078e33ffULL,
0x0000000203367824ULL, 0x000fca00078e00ffULL, 0x0000000636367812ULL, 0x000fca00078ec0ffULL,
0x0000000136347824ULL, 0x000fe200078e0267ULL, 0x0000000e000e7308ULL, 0x008ee40000001000ULL,
0x0ffffffe0e107810ULL, 0x008fcc0007ffe0ffULL, 0x00000010000d7305ULL, 0x000ee4000021f000ULL,
0x000000ffff0f7224ULL, 0x008fc800078e0a0dULL, 0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL,
0x0000000f0d117227ULL, 0x000fe200078e000cULL, 0x0000007a030c7211ULL, 0x000fca00078ff0ffULL,
0x0000000c110d7227ULL, 0x000fc800078e00ffULL, 0x000000ffff0f7224ULL, 0x000fc800078e0a0dULL,
0x00005a000f0e7a24ULL, 0x000fe200078e020cULL, 0x000000080c0c7810ULL, 0x000fc80007ffe0ffULL,
0x00005a000e007a0cULL, 0x000fe20003f06070ULL, 0x0000000c11107227ULL, 0x000fc800078e00ffULL,
0x000000ffff117224ULL, 0x000fc800078e0a10ULL, 0x00005a0011117a24ULL, 0x000fe200078e020cULL,
0x00000033700c7217ULL, 0x000fc60007800000ULL, 0x80005a000e0e0a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0011007a0cULL, 0x000fe20003f46070ULL, 0x000000010c337824ULL, 0x000fe200078e0a33ULL,
0x00005a000e007a0cULL, 0x000fe20003f26070ULL, 0x000000016a0c7824ULL, 0x000fe200078e0236ULL,
0x000000010d0d0810ULL, 0x000fc60007ffe0ffULL, 0x000000010c0f7824ULL, 0x040fe200078e0a33ULL,
0x000000330c00720cULL, 0x000fc80003f66070ULL, 0x0000000f680c7217ULL, 0x000fe20003800000ULL,
0x00000001340f7824ULL, 0x000fe200078e0a33ULL, 0x80005a0011112a10ULL, 0x000fe40007ffe0ffULL,
0x000000010d0d1810ULL, 0x000fe40007ffe0ffULL, 0x00005a0011007a0cULL, 0x000fe40003f06070ULL,
0x0000000d130d7207ULL, 0x000fe40006000000ULL, 0x00000004ff0c7819ULL, 0x000fc4000001160cULL,
0x0000000d68507217ULL, 0x000fe40003800000ULL, 0x000000ff0c117207ULL, 0x000fe40001800000ULL,
0x0000000110102810ULL, 0x000fe20007ffe0ffULL, 0x000000506f507224ULL, 0x000fe200078e02ffULL,
0x000000333400720cULL, 0x000fe40003f26070ULL, 0x0000000f680f7217ULL, 0x000fe20003800000ULL,
0x00000001500d7824ULL, 0x000fe200078e0211ULL, 0x0000000110100810ULL, 0x000fc40007ffe0ffULL,
0x000000ff0f417207ULL, 0x000fe20000800000ULL, 0x000000020d0c7825ULL, 0x000fe200078e0046ULL,
0x0000001013137207ULL, 0x000fe40006000000ULL, 0x00000010363a7812ULL, 0x000fe400078efcffULL,
0x00000050410f7211ULL, 0x000fe200078fe0ffULL, 0x000000060c457981ULL, 0x0046a2000c1e9500ULL,
0x0000001368527217ULL, 0x000fc60003800000ULL, 0x000000020f0e7825ULL, 0x000fc800078e0046ULL,
0x000000016a0c7824ULL, 0x008fe200078e023aULL, 0x000000060e4e7981ULL, 0x0006a2000c1e9500ULL,
0x000000526f527224ULL, 0x000fe400078e02ffULL, 0x000000010c0d7824ULL, 0x000fe400078e0a33ULL,
0x0000000111117824ULL, 0x000fe400078e0252ULL, 0x000000013a387824ULL, 0x000fe200078e0267ULL,
0x0000000d680e7217ULL, 0x008fe20003800000ULL, 0x0000000211107825ULL, 0x000fe200078e0046ULL,
0x000000330c00720cULL, 0x000fc40003f26070ULL, 0x00000004ff0e7819ULL, 0x000fe2000001160eULL,
0x00000001380d7824ULL, 0x000fe200078e0a33ULL, 0x00000020363c7812ULL, 0x000fe200078efcffULL,
0x0000000610437981ULL, 0x0006a2000c1e9500ULL, 0x000000333800720cULL, 0x000fe40003f06070ULL,
0x0000000d680d7217ULL, 0x000fe20003800000ULL, 0x000000016a447824ULL, 0x000fe200078e023cULL,
0x0000005241137211ULL, 0x000fe400078fe0ffULL, 0x000000ff0e117207ULL, 0x008fc40000800000ULL,
0x000000ff0d357207ULL, 0x000fe20000000000ULL, 0x00000001443b7824ULL, 0x000fe400078e0a33ULL,
0x00000001500d7824ULL, 0x000fe400078e0211ULL, 0x0000000213127825ULL, 0x000fe200078e0046ULL,
0x0000003b683b7217ULL, 0x000fc60003800000ULL, 0x000000020d0c7825ULL, 0x000fe200078e0046ULL,
0x0000000612567981ULL, 0x0006a6000c1e9500ULL, 0x000000013c407824ULL, 0x000fe200078e0267ULL,
0x000000060c377981ULL, 0x0002a2000c1e9500ULL, 0x000000334400720cULL, 0x080fe40003f26070ULL,
0x00000004ff3b7819ULL, 0x000fe4000001163bULL, 0x000000334000720cULL, 0x040fe20003f06070ULL,
0x00000001400d7824ULL, 0x002fe200078e0a33ULL, 0x000000ff3b3d7207ULL, 0x000fc40000800000ULL,
0x0000003036447812ULL, 0x000fe400078efcffULL, 0x0000000d680d7217ULL, 0x000fe20003800000ULL,
0x0000000111117824ULL, 0x000fe200078e0252ULL, 0x00000050350f7211ULL, 0x040fe400078fe0ffULL,
0x0000005235137211ULL, 0x008fe400078fe0ffULL, 0x000000ff0d3f7207ULL, 0x000fe20000000000ULL,
0x00000001500d7824ULL, 0x000fe400078e023dULL, 0x000000016a547824ULL, 0x000fc400078e0244ULL,
0x000000020f0e7825ULL, 0x000fc800078e0046ULL, 0x0000000211107825ULL, 0x100fe200078e0046ULL,
0x000000060e3e7981ULL, 0x0002e6000c1e9500ULL, 0x0000000213127825ULL, 0x100fe200078e0046ULL,
0x0000000610397981ULL, 0x0002e6000c1e9500ULL, 0x000000020d0c7825ULL, 0x000fe200078e0046ULL,
0x0000000612427981ULL, 0x0002e6000c1e9500ULL, 0x0000000154497824ULL, 0x000fe200078e0a33ULL,
0x000000060c3b7981ULL, 0x0002e2000c1e9500ULL, 0x00000001444a7824ULL, 0x000fe200078e0267ULL,
0x000000503f0f7211ULL, 0x002fc400078fe0ffULL, 0x0000004968497217ULL, 0x000fe20003800000ULL,
0x000000013d117824ULL, 0x000fe200078e0252ULL, 0x000000523f137211ULL, 0x000fe200078fe0ffULL,
0x000000014a0d7824ULL, 0x000fe200078e0a33ULL, 0x000000335400720cULL, 0x080fe40003f26070ULL,
0x00000004ff497819ULL, 0x000fe20000011649ULL, 0x000000020f0e7825ULL, 0x100fe200078e0046ULL,
0x000000334a00720cULL, 0x000fe40003f06070ULL, 0x0000000d680d7217ULL, 0x000fe20003800000ULL,
0x0000000211107825ULL, 0x100fe200078e0046ULL, 0x000000ff494b7207ULL, 0x000fe20000800000ULL,
0x000000060e487981ULL, 0x0002e4000c1e9500ULL, 0x0000000213127825ULL, 0x000fe200078e0046ULL,
0x000000ff0d497207ULL, 0x000fe20000000000ULL, 0x00000006103d7981ULL, 0x0002e8000c1e9500ULL,
0x00000006124c7981ULL, 0x0002e2000c1e9500ULL, 0x00000001500d7824ULL, 0x000fe200078e024bULL,
0x00000050490f7211ULL, 0x002fc600078fe0ffULL, 0x000000020d0c7825ULL, 0x000fc800078e0046ULL,
0x000000020f0e7825ULL, 0x000fe400078e0046ULL, 0x000000060c0c7981ULL, 0x0002e2000c1e9500ULL,
0x0000005249117211ULL, 0x000fc600078fe0ffULL, 0x000000060e0f7981ULL, 0x0002e2000c1e9500ULL,
0x000000014b137824ULL, 0x000fe400078e0252ULL, 0x0000000211107825ULL, 0x000fc800078e0046ULL,
0x0000000213127825ULL, 0x000fe400078e0046ULL, 0x0000000610107981ULL, 0x0002e8000c1e9500ULL,
0x0000000612137981ULL, 0x0002e2000c1e9500ULL, 0xfffffff041507812ULL, 0x000fe200078ec0ffULL,
0x00000001ff417424ULL, 0x000fc800078e00ffULL, 0x00000001330d7824ULL, 0x002fc800078e0250ULL,
0x0000000134587824ULL, 0x000fe200078e0a0dULL, 0x0000000836507812ULL, 0x040fe400078efcffULL,
0x00000009360e7812ULL, 0x000fe400078efcffULL, 0x0000005841587219ULL, 0x000fe200000006ffULL,
0x0000000150547824ULL, 0x100fe400078e0267ULL, 0x000000010e127824ULL, 0x000fe400078e0267ULL,
0x00000001545c7824ULL, 0x000fc400078e0a0dULL, 0x00000001125e7824ULL, 0x000fc600078e0a0dULL,
0x0000005c415c7219ULL, 0x040fe400000006ffULL, 0x0000005e415e7219ULL, 0x000fe400000006ffULL,
0x0000001836667812ULL, 0x040fe400078efcffULL, 0x0000001136727812ULL, 0x040fe400078efcffULL,
0x0000001936647812ULL, 0x000fc600078efcffULL, 0x0000000172117824ULL, 0x100fe400078e0267ULL,
0x0000000164747824ULL, 0x000fe200078e0267ULL, 0x0000002136607812ULL, 0x000fe400078efcffULL,
0xfffffff049497812ULL, 0x000fc600078ec0ffULL, 0x0000000160627824ULL, 0x000fe400078e0267ULL,
0x00000001334f7824ULL, 0x000fc800078e0249ULL, 0x000000014a5b7824ULL, 0x000fca00078e0a4fULL,
0x0000005b415b7219ULL, 0x000fe400000006ffULL, 0x000054104e457816ULL, 0x004fe40000000045ULL,
0x00000001364e7812ULL, 0x000fe400078efcffULL, 0x0000004558ff7212ULL, 0x000fc6000780c0ffULL,
0x000000014e527824ULL, 0x000fe200078e0267ULL, 0x000000333400720cULL, 0x000fc60000701470ULL,
0x00000001525a7824ULL, 0x000fe200078e0a0dULL, 0x000000333600720cULL, 0x000fc800007a1070ULL,
0x0000005a415a7219ULL, 0x000fe400000006ffULL, 0xff8000001d1d7808ULL, 0x000fe20002800000ULL,
0x00000001660d7824ULL, 0x000fe200078e0267ULL, 0x000000455aff7212ULL, 0x080fe4000782c0ffULL,
0x000000455cff7212ULL, 0x000fe4000786c0ffULL, 0x0000541056437816ULL, 0x000fc80000000043ULL,
0x0000004358ff7212ULL, 0x080fe4000784c0ffULL, 0x000000435aff7212ULL, 0x080fe4000780c0ffULL,
0x000000435cff7212ULL, 0x080fe400078cc0ffULL, 0x000000435eff7212ULL, 0x000fe400078ac0ffULL,
0xfffffff035437812ULL, 0x000fca00078ec0ffULL, 0x0000000133437824ULL, 0x000fe200078e0243ULL,
0x000000333400720cULL, 0x080fe40001741470ULL, 0x000000335400720cULL, 0x080fe200037c1470ULL,
0x0000000138517824ULL, 0x100fe200078e0a43ULL, 0x000000331200720cULL, 0x000fe20002fa1470ULL,
0x000000010d557824ULL, 0x000fe200078e0a43ULL, 0x000000455eff7212ULL, 0x000fe4000788c0ffULL,
0xfffffff03f457812ULL, 0x000fe400078ec0ffULL, 0x000000333600720cULL, 0x000fc40001741070ULL,
0x000000335000720cULL, 0x080fe400037c1070ULL, 0x000000330e00720cULL, 0x000fe40002fa1070ULL,
0x0000005141517219ULL, 0x040fe400000006ffULL, 0x0000005541557219ULL, 0x000fe400000006ffULL,
0x000054103e3e7816ULL, 0x008fe20000000037ULL, 0x0000000133457824ULL, 0x000fe200078e0245ULL,
0xff8000001e1e7808ULL, 0x000fc40001000000ULL, 0x0000541042427816ULL, 0x000fe40000000039ULL,
0xff80000020207808ULL, 0x000fe40003000000ULL, 0xff80000023237808ULL, 0x000fe40002800000ULL,
0x0000003e51ff7212ULL, 0x040fe4000784c0ffULL, 0x0000004251ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004255ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000111537824ULL, 0x100fe200078e0a43ULL,
0x000000335200720cULL, 0x080fe20000f21470ULL, 0x0000000174577824ULL, 0x000fe200078e0a43ULL,
0x000000335200720cULL, 0x080fe20000701470ULL, 0x0000000140597824ULL, 0x000fe200078e0a45ULL,
0x000000335400720cULL, 0x000fc40001f61470ULL, 0x000000331200720cULL, 0x080fe40002781470ULL,
0x000000333800720cULL, 0x0c0fe40001741470ULL, 0x000000333800720cULL, 0x080fe400037c1470ULL,
0x000000330d00720cULL, 0x000fe40002fa1470ULL, 0x00000028365e7812ULL, 0x040fe400078efcffULL,
0x00000029365c7812ULL, 0x000fc400078efcffULL, 0x000000334e00720cULL, 0x0c0fe40000f21070ULL,
0x000000334e00720cULL, 0x080fe40000701070ULL, 0x000000335000720cULL, 0x080fe40001f61070ULL,
0x000000330e00720cULL, 0x080fe40002781070ULL, 0x000000333a00720cULL, 0x0c0fe40001741070ULL,
0x000000333a00720cULL, 0x000fc400037c1070ULL, 0x000000336600720cULL, 0x000fe40002fa1070ULL,
0x0000005341537219ULL, 0x040fe400000006ffULL, 0x0000005741577219ULL, 0x040fe400000006ffULL,
0x0000005941597219ULL, 0x000fe400000006ffULL, 0x0000541048487816ULL, 0x000fe4000000003bULL,
0x000054104c4c7816ULL, 0x000fe2000000003dULL, 0x000000015e357824ULL, 0x100fe200078e0267ULL,
0xff80000026267808ULL, 0x000fe20000800000ULL, 0x000000015c3f7824ULL, 0x000fe200078e0267ULL,
0xff8000001c1c7808ULL, 0x000fc40000000000ULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff8000001f1f7808ULL, 0x000fe40002000000ULL, 0xff8000002d2d7808ULL, 0x000fe40001000000ULL,
0xff80000022227808ULL, 0x000fe40003000000ULL, 0xff80000024247808ULL, 0x000fe40002800000ULL,
0x0000003e53ff7212ULL, 0x000fc4000782c0ffULL, 0x0000003e55ff7212ULL, 0x080fe4000780c0ffULL,
0x0000003e57ff7212ULL, 0x000fe4000786c0ffULL, 0x0000004253ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004257ff7212ULL, 0x000fe4000784c0ffULL, 0x0000004859ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004c59ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001625f7824ULL, 0x100fe200078e0a45ULL,
0x000000331100720cULL, 0x080fe20000f21470ULL, 0x0000000135617824ULL, 0x100fe200078e0a45ULL,
0x000000331100720cULL, 0x080fe20002781470ULL, 0x000000013f5d7824ULL, 0x000fe200078e0a45ULL,
0x000000330d00720cULL, 0x000fc40000701470ULL, 0x000000337400720cULL, 0x0c0fe40001f61470ULL,
0x000000337400720cULL, 0x080fe40001741470ULL, 0x000000334000720cULL, 0x0c0fe400037c1470ULL,
0x000000334000720cULL, 0x000fe40002fa1470ULL, 0x00000031365a7812ULL, 0x040fe400078efcffULL,
0x0000003836587812ULL, 0x000fc400078efcffULL, 0x0000003936567812ULL, 0x000fe400078efcffULL,
0x000000337200720cULL, 0x0c0fe40000f21070ULL, 0x000000337200720cULL, 0x080fe40002781070ULL,
0x000000336600720cULL, 0x080fe40000701070ULL, 0x000000336400720cULL, 0x0c0fe40001f61070ULL,
0x000000336400720cULL, 0x000fc40001741070ULL, 0x000000333c00720cULL, 0x0c0fe400037c1070ULL,
0x000000333c00720cULL, 0x000fe40002fa1070ULL, 0x0000005f415f7219ULL, 0x040fe400000006ffULL,
0x0000006141617219ULL, 0x040fe400000006ffULL, 0x0000005d415d7219ULL, 0x000fe400000006ffULL,
0x000054100f0c7816ULL, 0x000fe2000000000cULL, 0x000000015a437824ULL, 0x100fe200078e0267ULL,
0xff80000028287808ULL, 0x000fe20000800000ULL, 0x0000000158457824ULL, 0x100fe200078e0267ULL,
0xff80000021217808ULL, 0x000fe20002000000ULL, 0x0000000156497824ULL, 0x000fe200078e0267ULL,
0xff80000029297808ULL, 0x000fc40000000000ULL, 0xff80000032327808ULL, 0x000fe40001800000ULL,
0xff80000031317808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fe40003000000ULL,
0xff8000001b1b7808ULL, 0x000fe40002800000ULL, 0x000000485fff7212ULL, 0x080fe4000782c0ffULL,
0x0000004861ff7212ULL, 0x000fc4000788c0ffULL, 0x000000485dff7212ULL, 0x000fe4000780c0ffULL,
0x0000004c5fff7212ULL, 0x080fe4000786c0ffULL, 0x0000004c61ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004c5dff7212ULL, 0x000fe400078cc0ffULL, 0x0000000c5bff7212ULL, 0x000fe200078ac0ffULL,
0x00000001434b7824ULL, 0x100fe200078e0a4fULL, 0x000000336200720cULL, 0x0c0fe20000f21470ULL,
0x00000001454d7824ULL, 0x100fe200078e0a4fULL, 0x000000336200720cULL, 0x080fe20001f61470ULL,
0x00000001494f7824ULL, 0x000fe200078e0a4fULL, 0x000000333500720cULL, 0x000fc40002781470ULL,
0x000000333500720cULL, 0x080fe40001741470ULL, 0x000000333f00720cULL, 0x0c0fe40000701470ULL,
0x000000333f00720cULL, 0x080fe400037c1470ULL, 0x000000334a00720cULL, 0x080fe40002fa1470ULL,
0x000000336000720cULL, 0x0c0fe40000f21070ULL, 0x000000336000720cULL, 0x000fc40001f61070ULL,
0x000000335e00720cULL, 0x0c0fe40002781070ULL, 0x000000335e00720cULL, 0x080fe40001741070ULL,
0x000000335c00720cULL, 0x0c0fe40000701070ULL, 0x000000335c00720cULL, 0x080fe400037c1070ULL,
0x000000334400720cULL, 0x000fe40002fa1070ULL, 0x0000004b414b7219ULL, 0x000fc400000006ffULL,
0x0000004d414d7219ULL, 0x040fe400000006ffULL, 0x0000004f414f7219ULL, 0x000fe400000006ffULL,
0x0000541010107816ULL, 0x000fe40000000013ULL, 0xff8000002a2a7808ULL, 0x000fe40000800000ULL,
0xff8000001a1a7808ULL, 0x000fe40001800000ULL, 0xff8000002b2b7808ULL, 0x000fc40002000000ULL,
0xff80000018187808ULL, 0x000fe40001000000ULL, 0xff8000002f2f7808ULL, 0x000fe40000000000ULL,
0xff80000019197808ULL, 0x000fe40003000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0x0000000c4bff7212ULL, 0x080fe4000782c0ffULL, 0x0000000c4dff7212ULL, 0x000fc4000786c0ffULL,
0x0000000c4fff7212ULL, 0x000fe4000788c0ffULL, 0x000000105bff7212ULL, 0x080fe4000784c0ffULL,
0x000000104bff7212ULL, 0x080fe4000780c0ffULL, 0x000000104dff7212ULL, 0x080fe400078cc0ffULL,
0x000000104fff7212ULL, 0x000fe400078ac0ffULL, 0x000000334a00720cULL, 0x000fc40001741470ULL,
0x000000334300720cULL, 0x0c0fe40000f21470ULL, 0x000000334300720cULL, 0x080fe40000701470ULL,
0x000000334500720cULL, 0x0c0fe40001f61470ULL, 0x000000334500720cULL, 0x080fe400037c1470ULL,
0x000000334900720cULL, 0x0c0fe40002781470ULL, 0x000000334900720cULL, 0x000fc40002fa1470ULL,
0x000000334400720cULL, 0x080fe40001741070ULL, 0x000000335a00720cULL, 0x0c0fe40000f21070ULL,
0x000000335a00720cULL, 0x080fe40000701070ULL, 0x000000335800720cULL, 0x0c0fe40001f61070ULL,
0x000000335800720cULL, 0x080fe400037c1070ULL, 0x000000335600720cULL, 0x000fc40002781070ULL,
0x000000335600720cULL, 0x000fe40002fa1070ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff80000025257808ULL, 0x000fe40001800000ULL, 0xff80000017177808ULL, 0x000fe40002000000ULL,
0xff80000007077808ULL, 0x000fe40001000000ULL, 0xff80000014147808ULL, 0x000fc40000000000ULL,
0xff80000015157808ULL, 0x000fe40003000000ULL, 0xff80000016167808ULL, 0x000fc40002800000ULL,
0x0000001d0800720bULL, 0x004fe40003f1e000ULL, 0x0000001e0900720bULL, 0x000fe40003f3e000ULL,
0x000000081d0d7208ULL, 0x000fe40004000000ULL, 0x000000091e097208ULL, 0x000fe40004800000ULL,
0x000000260d00720bULL, 0x000fc40003f1e000ULL, 0x0000001c0900720bULL, 0x000fe40003f3e000ULL,
0x0000000d26087208ULL, 0x000fe40004000000ULL, 0x000000091c097208ULL, 0x000fe40004800000ULL,
0x000000270800720bULL, 0x000fe40003f1e000ULL, 0x000000200900720bULL, 0x000fe40003f3e000ULL,
0x0000000827087208ULL, 0x000fc40004000000ULL, 0x00000009200c7208ULL, 0x000fe40004800000ULL,
0x0000001f0800720bULL, 0x000fe40003f1e000ULL, 0x000000230c00720bULL, 0x000fe40003f3e000ULL,
0x000000081f087208ULL, 0x000fe40004000000ULL, 0x0000000c23097208ULL, 0x000fe40004800000ULL,
0x0000002d0800720bULL, 0x000fc40003f1e000ULL, 0x000000220900720bULL, 0x000fe40003f3e000ULL,
0x000000082d0d7208ULL, 0x000fe40004000000ULL, 0x0000000922087208ULL, 0x000fe40004800000ULL,
0x000000280d00720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fe40003f3e000ULL,
0x0000000d280c7208ULL, 0x000fc40004000000ULL, 0x0000000821097208ULL, 0x000fe40004800000ULL,
0x000000290c00720bULL, 0x000fe40003f1e000ULL, 0x000000240900720bULL, 0x000fe40003f3e000ULL,
0x0000000c290d7208ULL, 0x000fe40004000000ULL, 0x0000000924087208ULL, 0x000fe40004800000ULL,
0x000000320d00720bULL, 0x000fc40003f1e000ULL, 0x000000310800720bULL, 0x000fe40003f3e000ULL,
0x0000000d320d7208ULL, 0x000fe40004000000ULL, 0x0000000831087208ULL, 0x000fe40004800000ULL,
0x000000300d00720bULL, 0x000fe40003f1e000ULL, 0x0000001b0800720bULL, 0x000fe40003f3e000ULL,
0x0000000d300d7208ULL, 0x000fc40004000000ULL, 0x000000081b097208ULL, 0x000fe40004800000ULL,
0x0000002a0d00720bULL, 0x000fe40003f1e000ULL, 0x0000001a0900720bULL, 0x000fe40003f3e000ULL,
0x0000000d2a087208ULL, 0x000fe40004000000ULL, 0x000000091a097208ULL, 0x000fe40004800000ULL,
0x0000002b0800720bULL, 0x000fc40003f1e000ULL, 0x000000180900720bULL, 0x000fe40003f3e000ULL,
0x000000082b087208ULL, 0x000fe40004000000ULL, 0x00000009180c7208ULL, 0x000fe40004800000ULL,
0x0000002f0800720bULL, 0x000fe40003f1e000ULL, 0x000000190c00720bULL, 0x000fe40003f3e000ULL,
0x000000082f097208ULL, 0x000fc40004000000ULL, 0x0000000c190c7208ULL, 0x000fe40004800000ULL,
0x0000002e0900720bULL, 0x000fe40003f1e000ULL, 0x000000070c00720bULL, 0x000fe40003f3e000ULL,
0x000000092e097208ULL, 0x000fe40004000000ULL, 0x0000000c070d7208ULL, 0x000fe40004800000ULL,
0x0000002c0900720bULL, 0x000fc40003f1e000ULL, 0x000000140d00720bULL, 0x000fe40003f3e000ULL,
0x000000092c087208ULL, 0x000fe40004000000ULL, 0x0000000d140c7208ULL, 0x000fe40004800000ULL,
0x000000250800720bULL, 0x000fe40003f1e000ULL, 0x000000150c00720bULL, 0x000fe40003f3e000ULL,
0x0000000825087208ULL, 0x000fc40004000000ULL, 0x0000000c15097208ULL, 0x000fe40004800000ULL,
0x000000170800720bULL, 0x000fe40003f1e000ULL, 0x000000160900720bULL, 0x000fe40003f3e000ULL,
0x0000000817107208ULL, 0x000fe40004000000ULL, 0x00000009160f7208ULL, 0x000fe20004800000ULL,
0x000017127f007947ULL, 0x000fec000b800000ULL, 0x0c401f0010087f89ULL, 0x0004e400000e0000ULL,
0x000000081000720bULL, 0x008fc80003f1e000ULL, 0x0000001008127208ULL, 0x000fe20004000000ULL,
0x000017427f007947ULL, 0x000fea000b800000ULL, 0x0c401f000f087f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a097f89ULL, 0x000e6800000e0000ULL, 0x0c401f000b0c7f89ULL, 0x000ea800000e0000ULL,
0x0c201f00120d7f89ULL, 0x000ea200000e0000ULL, 0x000000080f00720bULL, 0x008fc40003f1e000ULL,
0x000000090a00720bULL, 0x002fe40003f3e000ULL, 0x0000000f08087208ULL, 0x000fe40004000000ULL,
0x0000000a09097208ULL, 0x000fe40004800000ULL, 0x0000000c0b00720bULL, 0x004fe20003f1e000ULL,
0x0c201f0008117f89ULL, 0x000e6600000e0000ULL, 0x0000000b0c0f7208ULL, 0x000fe20004000000ULL,
0x0c201f00090e7f89ULL, 0x000ea200000e0000ULL, 0x0000000d1200720bULL, 0x000fc60003f1e000ULL,
0x0c201f000f347f89ULL, 0x0006e200000e0000ULL, 0x000000120d0c7208ULL, 0x000fe40004000000ULL,
0x000000110800720bULL, 0x002fe40003f3e000ULL, 0x0000000e0900720bULL, 0x004fe40003f5e000ULL,
0x00000008110d7208ULL, 0x000fe40004800000ULL, 0x000000090e0e7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b0c107820ULL, 0x00afe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000c06067812ULL, 0x000fc400078ec0ffULL, 0x3fb8aa3b25137823ULL, 0x100fe20000010810ULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b0d257820ULL, 0x000fe20000410000ULL,
0x000000340f00720bULL, 0x004fe20003f3e000ULL, 0x3fb8aa3b280b7823ULL, 0x100fe40000010810ULL,
0x3fb8aa3b1e1e7823ULL, 0x000fe20000010825ULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010810ULL, 0x0000000f340f7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b26267823ULL, 0x000fc40000010810ULL, 0x3fb8aa3b27277823ULL, 0x100fe40000010810ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010810ULL, 0x0000001d00087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe40000010825ULL, 0x3fb8aa3b20207823ULL, 0x100fe40000010825ULL,
0x3fb8aa3b23237823ULL, 0x100fe40000010825ULL, 0x3fb8aa3b21217823ULL, 0x000fe20000010825ULL,
0x0000002600097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b2b287823ULL, 0x000fc40000010810ULL,
0x3fb8aa3b24247823ULL, 0x100fe40000010825ULL, 0x3fb8aa3b31317823ULL, 0x100fe40000010825ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010810ULL, 0x00000027000a7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b32327823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b22227823ULL, 0x000fe40000010825ULL,
0x3fb8aa3b29117823ULL, 0x000fc40000010810ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010825ULL,
0x0000000b00367308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a277823ULL, 0x104fe20000010810ULL,
0x000000080908723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b2c267823ULL, 0x100fe40000010810ULL,
0x3fb8aa3b30127823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b192c7823ULL, 0x000fe20000010825ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2f297823ULL, 0x000fc40000010810ULL,
0x3fb8aa3b07077823ULL, 0x000fca0000010825ULL, 0x0000001c000b7308ULL, 0x000e700000000800ULL,
0x0000001f001f7308ULL, 0x000eb00000000800ULL, 0x00000020001d7308ULL, 0x0007e20000000800ULL,
0x0000001e0b09723eULL, 0x002fce00000010ffULL, 0x00000023002a7308ULL, 0x000e620000000800ULL,
0x00000004ff207e24ULL, 0x008fe2000f8e00ffULL, 0x0000000a1f0a723eULL, 0x004fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x3f8000002020783eULL, 0x000fe400000010ffULL,
0x00000021002b7308ULL, 0x0005e60000000800ULL, 0x000000ffff307224ULL, 0x100fe200078e0020ULL,
0x0000001d2a0b723eULL, 0x002fe200000010ffULL, 0x000000ffff217224ULL, 0x004fc600078e0020ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1a2a7823ULL, 0x000fc60000010825ULL,
0x00000020081c723cULL, 0x000b6800000418ffULL, 0x0000003100317308ULL, 0x000fe60000000800ULL,
0x3fb8aa3b18217823ULL, 0x020fca0000010825ULL, 0x0000002d002d7308ULL, 0x000e700000000800ULL,
0x0000001100337308ULL, 0x0005f00000000800ULL, 0x0000003200327308ULL, 0x000ee20000000800ULL,
0x0000002d3618723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b2e117823ULL, 0x104fe20000010810ULL,
0x00000002ff2e7819ULL, 0x000fe20000011603ULL, 0x3fb8aa3b17107823ULL, 0x000fc80000010810ULL,
0x0000002200227308ULL, 0x000e620000000800ULL, 0x000000082e2d7824ULL, 0x040fe400078e00ffULL,
0x000000082e2f7824ULL, 0x000fca00078e00ffULL, 0x0000001b00237308ULL, 0x0005e20000000800ULL,
0x00000033321a723eULL, 0x008fe200000010ffULL, 0x000000082e337824ULL, 0x000fe200078e00ffULL,
0x000000222b19723eULL, 0x002fca00000010ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000024311b723eULL, 0x004fe200000010ffULL, 0x000000ffff317224ULL, 0x000fe400078e0020ULL,
0x3fb8aa3b14247823ULL, 0x100fe20000010825ULL, 0x000000012e147810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b152b7823ULL, 0x100fe40000010825ULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x00000030181c723cULL, 0x000f62000004181cULL, 0x3fb8aa3b16257823ULL, 0x000fe20000010825ULL,
0xfffffff82d2d7812ULL, 0x000fca00078ee214ULL, 0x0000002800287308ULL, 0x000ff00000000800ULL,
0x0000002900297308ULL, 0x000ea20000000800ULL, 0x000000122714723eULL, 0x002fe200000010ffULL,
0x000000082e277824ULL, 0x040fe200078e00ffULL, 0x000000032e127810ULL, 0x000fc80007ffe0ffULL,
0xfffffff827277812ULL, 0x000fe200078ee212ULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x000000062e127810ULL, 0x000fce0007ffe0ffULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x000000282916723eULL, 0x004fe200000010ffULL, 0x000000082e287824ULL, 0x000fcc00078e00ffULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x000000232a15723eULL, 0x002fe200000010ffULL,
0x000000082e237824ULL, 0x040fe200078e00ffULL, 0xffffffff2e2a7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff833337812ULL, 0x000fe200078ee22aULL, 0x0000001000227308ULL, 0x0002e20000000800ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0020ULL, 0x000000212c17723eULL, 0x004fcc00000010ffULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x000000042e217810ULL, 0x040fe40007ffe0ffULL,
0x000000022e107810ULL, 0x002fe40007ffe0ffULL, 0xfffffff828297812ULL, 0x000fe200078ee221ULL,
0x00000030141c723cULL, 0x020b62000004181cULL, 0xfffffff823237812ULL, 0x000fe200078ee210ULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x000000052e107810ULL, 0x040fe20007ffe0ffULL,
0x000000082e217824ULL, 0x040fe200078e00ffULL, 0x000000082e2c7810ULL, 0x000fc40007ffe0ffULL,
0x000000082e317824ULL, 0x020fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe400078ee210ULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0xfffffff821217812ULL, 0x000fe200078ee22eULL,
0x000000082c357824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe400078ee212ULL,
0x000000132212723eULL, 0x008fe400000010ffULL, 0x0001100000227811ULL, 0x000fe200078e58ffULL,
0x0000002500287308ULL, 0x0004e20000000800ULL, 0x000000112610723eULL, 0x002fc600000010ffULL,
0x0000001021217824ULL, 0x100fe400078e0222ULL, 0x000000102d2d7824ULL, 0x100fe400078e0222ULL,
0x0000000700077308ULL, 0x000fe20000000800ULL, 0x0000001023237824ULL, 0x000fe200078e0222ULL,
0xfffffff835257812ULL, 0x004fe200078ee22cULL, 0x0000001027277824ULL, 0x100fe400078e0222ULL,
0x0000001029297824ULL, 0x000fe400078e0222ULL, 0x0000000121217824ULL, 0x000fe200078e0206ULL,
0x0000002400247308ULL, 0x000e620000000800ULL, 0x0000002b2813723eULL, 0x008fe200000010ffULL,
0x000000ffff2b7224ULL, 0x000fc400078e0020ULL, 0x000000102f2f7824ULL, 0x100fe200078e0222ULL,
0x0000000821007388ULL, 0x0005e20000000800ULL, 0x00000001062d7824ULL, 0x040fe400078e022dULL,
0x0000001031317824ULL, 0x100fe400078e0222ULL, 0x0000000106237824ULL, 0x040fe200078e0223ULL,
0x0000000a2d007388ULL, 0x0005e20000000800ULL, 0x0000001033337824ULL, 0x100fe400078e0222ULL,
0x0000000106277824ULL, 0x000fe200078e0227ULL, 0x0000001823007388ULL, 0x0005e20000000800ULL,
0x000000072411723eULL, 0x002fe200000010ffULL, 0x0000001025257824ULL, 0x000fc400078e0222ULL,
0x0000000106297824ULL, 0x040fe200078e0229ULL, 0x0000001a27007388ULL, 0x0005e20000000800ULL,
0x00000001062f7824ULL, 0x040fe400078e022fULL, 0x0000002a101c723cULL, 0x000f62000004181cULL,
0x0000000106317824ULL, 0x040fe200078e0231ULL, 0x0000001429007388ULL, 0x0005e20000000800ULL,
0x0000000106337824ULL, 0x040fe400078e0233ULL, 0x0000000106067824ULL, 0x000fe200078e0225ULL,
0x000000162f007388ULL, 0x0005e80000000800ULL, 0x0000001031007388ULL, 0x0005e80000000800ULL,
0x0000001233007388ULL, 0x0005e80000000800ULL, 0x0000000906007388ULL, 0x0005e80000000800ULL,
0x0004000b2d007388ULL, 0x0005e40000000800ULL, 0x000000ffff1d7224ULL, 0x020fc400078e001eULL,
0x0004001923007388ULL, 0x0005e80000000800ULL, 0x0004001b27007388ULL, 0x0005e80000000800ULL,
0x0004001529007388ULL, 0x0005e80000000800ULL, 0x000400172f007388ULL, 0x0005e80000000800ULL,
0x0004001131007388ULL, 0x0005e80000000800ULL, 0x0004001333007388ULL, 0x0005e80000000800ULL,
0x0170000c05008388ULL, 0x0005e80000000c00ULL, 0x0172001c05008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000007bff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008007bff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010007bff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000169697810ULL, 0x000fe20007ffe0ffULL,
0x000018007bff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff667224ULL, 0x000fc400078e006dULL,
0x000000786900720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff9a0000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff147807ULL, 0x008fe20004000000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x00018e0000157802ULL, 0x000fc40000000f00ULL, 0x00000f4000007944ULL, 0x012fea0003c00000ULL,
0xfffe9b2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20005000000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x00018e5000157802ULL, 0x000fc40000000f00ULL,
0x00000ef000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff167224ULL, 0x000fe200078e003cULL,
0xfffe9b5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0035ULL,
0x00018ec0003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000e3000007944ULL, 0x012fea0003c00000ULL,
0xfffe9c1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0035ULL,
0x00018f20003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000dd000007944ULL, 0x012fea0003c00000ULL,
0xfffe9d1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e000bULL,
0x00018f90003d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e000cULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x00000d6000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xfffea11000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e000bULL,
0x00019000003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000cf000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e003cULL, 0xfffea0d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x008fe20004000000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x0001906000157802ULL, 0x000fc40000000f00ULL, 0x00000ce000007944ULL, 0x012fea0003c00000ULL,
0xfffed00000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20005000000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x000190b000157802ULL, 0x000fc40000000f00ULL,
0x00000c9000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e003cULL,
0xfffed03000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0040ULL,
0x00019120003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000bd000007944ULL, 0x012fea0003c00000ULL,
0xfffed10000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0040ULL,
0x00019180003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000b7000007944ULL, 0x012fea0003c00000ULL,
0xfffed20000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0012ULL,
0x000191f0003d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e0013ULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x00000b0000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xfffed61000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0012ULL,
0x00019260003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000a9000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e003cULL, 0xfffed5d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x008fe20004000000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x000192c000157802ULL, 0x000fc40000000f00ULL, 0x00000a8000007944ULL, 0x014fea0003c00000ULL,
0xffff02d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20005000000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x0001931000157802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff077224ULL, 0x000fe200078e003cULL,
0xffff031000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e003aULL,
0x00019380003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000097000007944ULL, 0x014fea0003c00000ULL,
0xffff03e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e003aULL,
0x000193e0003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000091000007944ULL, 0x014fea0003c00000ULL,
0xffff04e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e000eULL,
0x00019450003d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e0017ULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x000008a000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xffff08f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e000eULL,
0x000194c0003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000083000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e003cULL, 0xffff08b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x004fe20004000000ULL, 0xffffffffff3d7424ULL, 0x000fe200078e00ffULL,
0x0001952000157802ULL, 0x000fc40000000f00ULL, 0x0000082000007944ULL, 0x018fea0003c00000ULL,
0xffff363000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20005000000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x0001957000157802ULL, 0x000fc40000000f00ULL,
0x000007d000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff117224ULL, 0x000fe200078e003cULL,
0xffff367000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0x000195e0003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000071000007944ULL, 0x018fea0003c00000ULL,
0xffff373000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0x00019640003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x000006b000007944ULL, 0x018fea0003c00000ULL,
0xffff383000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0007ULL,
0x000196b0003d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e000eULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000064000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xffff3c3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff157224ULL, 0x000fe200078e0007ULL,
0x00019720003d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3e7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x000005d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e003cULL, 0xffff3bf000007947ULL, 0x000fea000383ffffULL,
0x00000002ff117424ULL, 0x000fe200078e00ffULL, 0x0001979000087802ULL, 0x000fe20000000f00ULL,
0x0000001fff347424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000052000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0034ULL,
0xffffe89000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x006fe200078e000fULL,
0x0001981000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff117424ULL, 0x000fe400078e00ffULL,
0x0000001fff347424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x000004a000007944ULL, 0x010fea0003c00000ULL, 0x000000340f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e000aULL, 0x0001989000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff117424ULL, 0x000fe200078e00ffULL, 0x0000000f340d7208ULL, 0x000fe20004000000ULL,
0x0000001fff347424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000042000007944ULL, 0x000fea0003c00000ULL, 0x000000340a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e000bULL, 0x0001991000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff117424ULL, 0x000fe200078e00ffULL, 0x0000000a34137208ULL, 0x000fe20004000000ULL,
0x0000001fff347424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x000003a000007944ULL, 0x000fea0003c00000ULL, 0x000000340b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e0012ULL, 0x0001999000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x0000000b340f7208ULL, 0x000fe20004000000ULL,
0x0000001fff347424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000341200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e000dULL, 0x00019a1000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x00000012340c7208ULL, 0x000fe20004000000ULL,
0x0000001fff347424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x000002a000007944ULL, 0x000fea0003c00000ULL, 0x000000340d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e0013ULL, 0x00019a9000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x0000000d340d7208ULL, 0x000fe20004000000ULL,
0x0000001fff347424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000022000007944ULL, 0x000fea0003c00000ULL, 0x000000341300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e000fULL, 0x00019b1000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x00000013340e7208ULL, 0x000fe20004000000ULL,
0x0000001fff347424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0xffffe68000007947ULL, 0x000fea000383ffffULL,
0x018000000d027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000d00028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0dff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000d037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000d00027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0005ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe635002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003300007348ULL, 0x000fe80003800000ULL, 0x0c00001110347389ULL, 0x0002a200000e0034ULL,
0xfffe631008007950ULL, 0x000fea0003c3ffffULL, 0x0000003c00007348ULL, 0x000fe80003800000ULL,
0x00000014153c7389ULL, 0x0002a400000e003eULL, 0x000000ffff147224ULL, 0x002fc400078e003dULL,
0x00000000ff157424ULL, 0x000fc800078e00ffULL, 0xfffe62c014007950ULL, 0x000fea0003c3ffffULL,
0x000000011400780cULL, 0x000fe20003f45070ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0x0000003d00007348ULL, 0x000fe80003800000ULL, 0x00000000ff157424ULL, 0x000fce00078e00ffULL,
0x00000000003c7806ULL, 0x000fc800050e0100ULL, 0x0000003d3c3c7212ULL, 0x000fe200078ec0ffULL,
0xfffe625014007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x0000000000000340ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d38ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000df8ULL, 0x00000000000007d0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015c8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015d8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001668ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000000166cULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000019e80ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001b700ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001b750ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001bad0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001668ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001a098ULL, 0x000000000001a098ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001bad0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_80_cubin_len = 113584;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
