/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000018f90ULL, 0x0000000000018b10ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000017240ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x00000000000173b0ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x00000000000173f0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000017430ULL,
0x0000000000000150ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000017580ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001724000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x005b4c0400288080ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080990828808081ULL,
0x9e082880809b0828ULL, 0x288080a208288080ULL, 0x80a508288080a408ULL, 0x08288080a9082880ULL,
0x8080ab08288080aaULL, 0xb108288080b00828ULL, 0x288080b208288080ULL, 0x80c608288080bd08ULL,
0x08288080e9082880ULL, 0x8082801628808086ULL, 0x0000000000031028ULL, 0x2880808692000000ULL,
0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001724000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x92082880808f0828ULL, 0x2880809b08288080ULL, 0x80a208288080a108ULL, 0x08288080a3082880ULL,
0x8080a508288080a4ULL, 0xab08288080aa0828ULL, 0x288080b108288080ULL, 0x80bd08288080b208ULL,
0x08288080c6082880ULL, 0x80808808288080e9ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808892ULL, 0x0000001cffffffffULL, 0x0000013000000000ULL, 0x000173b000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x8f08288080880828ULL, 0x2880809208288080ULL, 0x80a1082880809b08ULL, 0x08288080a2082880ULL,
0x8080a508288080a3ULL, 0xab08288080aa0828ULL, 0x288080b108288080ULL, 0x80bd08288080b208ULL,
0x08288080c6082880ULL, 0x8080a408288080e9ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x002200288080a492ULL, 0x0000001cffffffffULL, 0x000001f000000000ULL, 0x000173f000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x8f08288080880828ULL, 0x2880809208288080ULL, 0x80a1082880809b08ULL, 0x08288080a2082880ULL,
0x8080a508288080a3ULL, 0xab08288080aa0828ULL, 0x288080b108288080ULL, 0x80bd08288080b208ULL,
0x08288080c6082880ULL, 0x8080a408288080e9ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x002200288080a492ULL, 0x0000001cffffffffULL, 0x000002b000000000ULL, 0x0001743000000000ULL,
0x0000015000000000ULL, 0x0000000000000000ULL, 0x0000001200082f04ULL, 0x00081204000000f2ULL,
0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000007c00043704ULL, 0x0000000e00080a04ULL, 0x0058190300580160ULL, 0x00000000000c1704ULL,
0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x001c310400ff1b03ULL,
0x0001599000000020ULL, 0x00015be000015bd0ULL, 0x00015d6000015d50ULL, 0x0160290400015d70ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0500001d0500001dULL, 0x0500001d0500001dULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000f001602804ULL, 0x00001a1000000110ULL, 0x00001b6000001aa0ULL, 0x00001f6000001b90ULL,
0x00001ff000001f90ULL, 0x0000495000002050ULL, 0x00004ab0000049e0ULL, 0x00004ef000004bd0ULL,
0x00004f7000004f10ULL, 0x0000770000004fd0ULL, 0x0000786000007790ULL, 0x00007c9000007980ULL,
0x00007d1000007cb0ULL, 0x0000a3e000007d70ULL, 0x0000a5400000a470ULL, 0x0000a9800000a660ULL,
0x0000aa000000a9a0ULL, 0x0000cc300000aa60ULL, 0x0000f2300000cc40ULL, 0x0000faf00000f310ULL,
0x000155f00000fb20ULL, 0x0001563000015620ULL, 0x0001566000015640ULL, 0x000156a000015680ULL,
0x00015d40000156b0ULL, 0x00015db000015da0ULL, 0x000164d000015dc0ULL, 0x0001659000016520ULL,
0x0001667000016600ULL, 0x00016730000166e0ULL, 0x000167f000016780ULL, 0x000168c000016860ULL,
0x0001698000016930ULL, 0x00016a40000169d0ULL, 0x00016b1000016ab0ULL, 0x00016bd000016b80ULL,
0x00016c8000016c20ULL, 0x00016d5000016cf0ULL, 0x00016e2000016dc0ULL, 0x00016ed000016e80ULL,
0x00016f7000016f20ULL, 0x0001701000016fc0ULL, 0x000170d000017060ULL, 0x000171b000017150ULL,
0x04c0390400017210ULL, 0x000000ff00000220ULL, 0x003f01000000f600ULL, 0x00000003000002c0ULL,
0x003f01200000f608ULL, 0x0000000300000300ULL, 0x003f01200000f688ULL, 0x0000000300000380ULL,
0x003f01200000f6a8ULL, 0x00000003000003b0ULL, 0x003f01200000f6c8ULL, 0x000000ff00000460ULL,
0x003f01070000f600ULL, 0x0000003800000630ULL, 0x003f01020000f68cULL, 0x00000038000006e0ULL,
0x003f01010000f688ULL, 0x000000ff00000ca0ULL, 0x0004010700000000ULL, 0x000000ff00000d40ULL,
0x0004010100000000ULL, 0x0000003f00000da0ULL, 0x003f010100000020ULL, 0x0000008600000ef0ULL,
0x003f010500000004ULL, 0x0000003f00000f60ULL, 0x003f010500000024ULL, 0x0000003f00000fe0ULL,
0x003f010500000024ULL, 0x0000002d000016e0ULL, 0x003f010700000000ULL, 0x0000002d000017d0ULL,
0x003f010100000000ULL, 0x0000002f000017e0ULL, 0x003f010500000004ULL, 0x0000005000001850ULL,
0x003f01010000f608ULL, 0x0000005000001870ULL, 0x003f01050000f60cULL, 0x0000002700001910ULL,
0x003f01050000f60cULL, 0x0000002f00001e50ULL, 0x003f010500000004ULL, 0x0000002f00001ed0ULL,
0x003f010500000004ULL, 0x0000003f00004020ULL, 0x003f010100000020ULL, 0x0000005c000040a0ULL,
0x003f01010000f688ULL, 0x00000086000040f0ULL, 0x003f010500000004ULL, 0x0000003f00004140ULL,
0x003f010500000024ULL, 0x0000003f000041c0ULL, 0x003f010500000024ULL, 0x0000005f000046f0ULL,
0x003f010700000000ULL, 0x0000005f00004770ULL, 0x003f010100000000ULL, 0x0000006000004780ULL,
0x003f010500000004ULL, 0x0000005d000047f0ULL, 0x003f01010000f628ULL, 0x0000005d00004810ULL,
0x003f01050000f62cULL, 0x00000050000048a0ULL, 0x003f01050000f62cULL, 0x0000002400004dc0ULL,
0x003f01050000f6acULL, 0x0000002400004e40ULL, 0x003f01050000f6acULL, 0x0000003f00006df0ULL,
0x003f010100000020ULL, 0x0000005c00006e60ULL, 0x003f01010000f690ULL, 0x0000008600006ea0ULL,
0x003f010500000004ULL, 0x0000003f00006ef0ULL, 0x003f010500000024ULL, 0x0000003f00006f70ULL,
0x003f010500000024ULL, 0x00000000000074a0ULL, 0x0005010700000000ULL, 0x0000000000007520ULL,
0x0005010100000000ULL, 0x0000003100007530ULL, 0x0005010500000004ULL, 0x00000050000075a0ULL,
0x003f01010000f648ULL, 0x00000050000075c0ULL, 0x003f01050000f64cULL, 0x0000005000007650ULL,
0x003f01050000f64cULL, 0x0000002500007b60ULL, 0x003f01050000f6acULL, 0x0000002500007be0ULL,
0x003f01050000f6acULL, 0x0000003f00009b90ULL, 0x003f010100000020ULL, 0x0000005c00009c00ULL,
0x003f01010000f698ULL, 0x0000008600009c60ULL, 0x003f010500000004ULL, 0x0000003f00009cb0ULL,
0x003f010500000024ULL, 0x0000003f00009d30ULL, 0x003f010500000024ULL, 0x0000005f0000a170ULL,
0x003f010700000000ULL, 0x0000002c0000a1f0ULL, 0x003f010100000000ULL, 0x000000600000a200ULL,
0x003f010500000004ULL, 0x0000005d0000a270ULL, 0x003f01010000f668ULL, 0x0000005d0000a290ULL,
0x003f01050000f66cULL, 0x0000005d0000a330ULL, 0x003f01050000f66cULL, 0x000000240000a850ULL,
0x003f01050000f6acULL, 0x000000240000a8d0ULL, 0x003f01050000f6acULL, 0x0000003f0000c7e0ULL,
0x003f010100000020ULL, 0x0000005c0000c840ULL, 0x003f01010000f6a0ULL, 0x000000ff00010870ULL,
0x003f01010000f600ULL, 0x000000ff00011680ULL, 0x003f01050000f604ULL, 0x000000ff00011720ULL,
0x003f01050000f604ULL, 0x000000ff00011930ULL, 0x003f01010000f600ULL, 0x000000ff00011940ULL,
0x003f01050000f604ULL, 0x000000ff000119d0ULL, 0x003f01050000f604ULL, 0x0000003e00014a50ULL,
0x003f010100000000ULL, 0x0000003e00014a90ULL, 0x003f010500000004ULL, 0x0000003e00014ef0ULL,
0x003f010500000004ULL, 0x0000004000016330ULL, 0x003f010100000000ULL, 0x0000004000016390ULL,
0x003f010100000008ULL, 0x00000040000163f0ULL, 0x003f010100000010ULL, 0x0000004000016460ULL,
0x003f010100000018ULL, 0x00141c0400053803ULL, 0x0001077000010520ULL, 0x00011ae000011a30ULL,
0x00000401000164a0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x000000000000035cULL, 0x0000001200000002ULL,
0x000000000000029cULL, 0x0000001200000002ULL, 0x00000000000001dcULL, 0x0000001200000002ULL,
0x000000000000011cULL, 0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL,
0x0000000000000338ULL, 0x0000001200000002ULL, 0x0000000000000278ULL, 0x0000001200000002ULL,
0x00000000000001b8ULL, 0x0000001200000002ULL, 0x00000000000000f3ULL, 0x0000001200000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x0000000000147806ULL, 0x000fe200038e0000ULL, 0x00005800ff3c7624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000f7919ULL, 0x000ea20000002300ULL,
0x0000001400067300ULL, 0x000ee200000e0000ULL, 0x00000100ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000000000007919ULL, 0x000ea80000002200ULL, 0x0000000000367919ULL, 0x000f220000000000ULL,
0x0000001400147309ULL, 0x000f660000000000ULL, 0x0000000000127919ULL, 0x000ee80000002600ULL,
0x0000000000247919ULL, 0x000f620000002700ULL, 0x00000005ff027819ULL, 0x002fc60000011603ULL,
0x0000000000077919ULL, 0x000e680000000000ULL, 0x00001fff02027589ULL, 0x000fe200000e0000ULL,
0x000000010f007824ULL, 0x004fc600078e0200ULL, 0x00001fff0f0f7589ULL, 0x000ea200000e0000ULL,
0x0000008000037824ULL, 0x000fe200078e0203ULL, 0x00000004ff117819ULL, 0x010fe20000011636ULL,
0x000000083c007824ULL, 0x000fe400078e00ffULL, 0x0000000812097824ULL, 0x008fe200078e00ffULL,
0x000000ff0300720cULL, 0x040fe20003f45270ULL, 0x00000010360e7824ULL, 0x000fe200078e00ffULL,
0x0000007f0300780cULL, 0x040fe20003f84070ULL, 0x0000002400007224ULL, 0x020fe200078e0209ULL,
0x0000000f0300780cULL, 0x000fc40003f64070ULL, 0x000000030300780cULL, 0x000fe40003f24070ULL,
0x000000070600720cULL, 0x002fe40003f02070ULL, 0x000000f00e157812ULL, 0x000fc600078ec0ffULL,
0x3fffff80ff04a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff05a424ULL, 0x000fe400078e00ffULL,
0x000000040f087824ULL, 0x004fe400078e0202ULL, 0xff317217ff0cc424ULL, 0x000fe200078e00ffULL,
0x00f60004ff00a388ULL, 0x0003e20000000a00ULL, 0x00000002080a7824ULL, 0x000fe200078e00ffULL,
0x000000010300780cULL, 0x000fe20003f44070ULL, 0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL,
0x00f4000c0300c388ULL, 0x000fe20000004800ULL, 0x000000010a137824ULL, 0x040fe200078e0211ULL,
0x000000080a0b7817ULL, 0x000fe20007800000ULL, 0x7fffffc0ff07b424ULL, 0x000fc400078e00ffULL,
0x3fffff60ff089424ULL, 0x000fe400078e00ffULL, 0x0000000100047824ULL, 0x002fe200078e0213ULL,
0x00f608060300b388ULL, 0x0003e20000008a00ULL, 0x7fffff60ff099424ULL, 0x000fe400078e00ffULL,
0x000000010b007824ULL, 0x000fe400078e0a0aULL, 0x00005c0004047625ULL, 0x000fe200078e000dULL,
0x00f6880803009388ULL, 0x0005e40000008a00ULL, 0x000000001100720cULL, 0x000fe20003f66070ULL,
0x3fffff80ff0a9424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL,
0x0000000713077812ULL, 0x002fe200078ec0ffULL, 0x3fffffc0ff0ca424ULL, 0x000fe200078e00ffULL,
0x0000001504067210ULL, 0x000fe20007f9e0ffULL, 0x7fffffc0ff0da424ULL, 0x000fe200078e00ffULL,
0x00f6a80a03009388ULL, 0x0003e20000008a00ULL, 0x0000000f07107812ULL, 0x000fe200078e7836ULL,
0x000000ffff007224ULL, 0x000fe400078e0a14ULL, 0x00f6c80c0300a388ULL, 0x0003e20000008a00ULL,
0x000000ffff077224ULL, 0x000fc400020e0605ULL, 0x0000001013107824ULL, 0x000fe400078e0210ULL,
0x00000004ff117424ULL, 0x000fe400078e00ffULL, 0x0000001010097824ULL, 0x004fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000620024047625ULL, 0x000fca00078e0011ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604037981ULL, 0x002ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x00000004ff347e24ULL, 0x002fe2000f8e00ffULL,
0x0000007f03357810ULL, 0x004fc40007ffe0ffULL, 0x000000ff03377810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff357819ULL, 0x000fe40000011635ULL, 0x00000008ff377819ULL, 0x000fca0000011637ULL,
0x0001021000008947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe20000011602ULL,
0x0000000802387824ULL, 0x000fe400078e00ffULL, 0x00000003ff077424ULL, 0x000fe200078e00ffULL,
0x01ffffff00057812ULL, 0x000fe200078ec0ffULL, 0xffffffffff397424ULL, 0x000fc800078e00ffULL,
0x0000000234527824ULL, 0x000fca00078e0205ULL, 0x000000355200720cULL, 0x000fda0003f06070ULL,
0x0000000224008824ULL, 0x000fe400078e00ffULL, 0x00006400ff058624ULL, 0x000fc800078e00ffULL,
0x0000640000058624ULL, 0x000fc800078e0205ULL, 0x0000000152058824ULL, 0x000fe200078e0205ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c0738ff738cULL, 0x0003e20000000000ULL,
0x0000600005048625ULL, 0x000fe200078e0011ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000604398981ULL, 0x0004e2000c1e1900ULL, 0x00000001ff437819ULL, 0x000fe20000011602ULL,
0x00000080123b7824ULL, 0x000fe200078e00ffULL, 0x00000001023a7812ULL, 0x000fe200078ec0ffULL,
0x00f6880038ff7f8cULL, 0x0009e2000c80043fULL, 0x0000000134007810ULL, 0x000fe20007ffe0ffULL,
0x00002000433c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff077819ULL, 0x002fe20000011636ULL,
0x000000103a067824ULL, 0x000fe200078e00ffULL, 0x000000370000720cULL, 0x000fe20003f06070ULL,
0x0000000834057824ULL, 0x004fe200078e0243ULL, 0x00000004070a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000106097824ULL, 0x040fe200078e0207ULL, 0x00000008070c7810ULL, 0x000fe20007ffe0ffULL,
0x0000002005007824ULL, 0x000fe200078e00ffULL, 0x0000000c07127810ULL, 0x000fe20007ffe0ffULL,
0x00000001060b7824ULL, 0x040fe200078e020aULL, 0x0000003609087212ULL, 0x040fe200078e3cffULL,
0x00000008090d7824ULL, 0x000fe200078e00ffULL, 0x0000000003057217ULL, 0x000fe20007800000ULL,
0x000000080b0f7824ULL, 0x040fe200078e00ffULL, 0x000000360b047212ULL, 0x080fe200078e3cffULL,
0x0000000106117824ULL, 0x040fe200078e0212ULL, 0xfffffff80d087812ULL, 0x000fe200078ee208ULL,
0x0000000105057824ULL, 0x100fe200078e0a00ULL, 0x000000603b007812ULL, 0x000fe200078ef800ULL,
0x00000001060d7824ULL, 0x000fe200078e020cULL, 0xfffffff80f047812ULL, 0x000fe200078ee204ULL,
0x00000000430473c2ULL, 0x000e6200000e0000ULL, 0x0000002005057807ULL, 0x000fe20000000000ULL,
0x0000000100097824ULL, 0x040fe200078e0209ULL, 0x000000360d107212ULL, 0x000fe200078e3cffULL,
0x00000001000f7824ULL, 0x040fe200078e020bULL, 0x0000000605057217ULL, 0x000fe20007800000ULL,
0x0000000100137824ULL, 0x040fe200078e020dULL, 0x0000003611147212ULL, 0x000fe200078e3cffULL,
0x0000000100177824ULL, 0x000fe200078e0211ULL, 0x0000b0003c0b7810ULL, 0x000fe20007ffe0ffULL,
0x000000080d157824ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000811117824ULL, 0x000fe200078e00ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000105057824ULL, 0x000fe200078e0a06ULL, 0xfffffff815107812ULL, 0x000fe200078ee210ULL,
0x00000010080d7824ULL, 0x100fe200078e020bULL, 0xfffffff811147812ULL, 0x000fe200078ee214ULL,
0x0000001004117824ULL, 0x100fe200078e020bULL, 0x000000050c00720cULL, 0x080fe20003f26070ULL,
0x0000001010157824ULL, 0x100fe200078e020bULL, 0x000000050700720cULL, 0x080fe20003f66070ULL,
0x0000001014197824ULL, 0x000fe200078e020bULL, 0x000000050a00720cULL, 0x080fe20003f46070ULL,
0x0000f6a804047891ULL, 0x002fe2000f8e203fULL, 0x000000051200720cULL, 0x000fe20003f06070ULL,
0xff317217ff3d7424ULL, 0x000fe200078e00ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000f6a8433f7811ULL, 0x000fe200078e18ffULL,
0x0000580039007a24ULL, 0x008fc800078e02ffULL, 0x0000008000007824ULL, 0x000fca00078e00ffULL,
0x0000000900097210ULL, 0x040fe40007f9e0ffULL, 0x0000000f000f7210ULL, 0x040fe40007fde0ffULL,
0x00005e00090c7a11ULL, 0x000fe200078a38ffULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x00005e000f077a11ULL, 0x000fe200078838ffULL, 0x000000ffff047224ULL, 0x000fe200030e06ffULL,
0x0000001300137210ULL, 0x000fe40007fde0ffULL, 0x00005f0009107a11ULL, 0x000fc400028f3c10ULL,
0x0000001700007210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff067224ULL, 0x000fe200030e06ffULL,
0x00005f000f0b7a11ULL, 0x000fe200020f3c04ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000700e0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fe200028e06ffULL,
0x00005e0013087a11ULL, 0x000fe400078838ffULL, 0x00005e00000a7a11ULL, 0x000fe400078c38ffULL,
0x0000000c0f047210ULL, 0x000fc40007fbe0ffULL, 0x00005f0013097a11ULL, 0x000fe400020f3c06ULL,
0x0000000f07067210ULL, 0x080fe40007f9e0ffULL, 0x00005f0000007a11ULL, 0x000fe200030f3c05ULL,
0x000000ffff057224ULL, 0x000fe200028e0610ULL, 0x0000000f08087210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff077224ULL, 0x000fe200020e060bULL, 0x0000000f0a0a7210ULL, 0x000fe40007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0009e2000d901c46ULL,
0x000000ffff097224ULL, 0x000fc400028e0609ULL, 0x000000ffff0b7224ULL, 0x000fe200020e0600ULL,
0x0000000006117faeULL, 0x0009e8000d101c46ULL, 0x0000000008157faeULL, 0x0003e2000c901c46ULL,
0x000000373400720cULL, 0x000fc60003f26070ULL, 0x000000000a197faeULL, 0x0005e8000c101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000147805ULL, 0x002fe2000001ff00ULL, 0x0000000000187805ULL, 0x004fc4000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x010fec0000008000ULL,
0x00000000ff687f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000020003f267f8cULL, 0x0004e2000c80043fULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x000000203f867810ULL, 0x000fe20007ffe0ffULL,
0x0000ba6000001947ULL, 0x000fea0003800000ULL, 0x0000000224407824ULL, 0x004fe400078e00ffULL,
0x00006400ff237624ULL, 0x000fc400078e00ffULL, 0x000000ffff257224ULL, 0x008fe400078e0027ULL,
0x0000640040407624ULL, 0x000fe400078e0223ULL, 0xff317217ff3d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff6b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fe400078e00ffULL,
0x0000010034007824ULL, 0x000fca00078e00ffULL, 0x000000030000720cULL, 0x000fda0003f06070ULL,
0x0000b98000000947ULL, 0x026fea0003800000ULL, 0x0000040086007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000fee0000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x000000ffff517224ULL, 0x000fe400078e0052ULL,
0x000000ffff417224ULL, 0x000fe200078e006bULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x000024003f007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x000024003f247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000300ff537624ULL, 0x000fe200078e00ffULL,
0x0000000152007812ULL, 0x000fe200078ec0ffULL, 0x0000580039277a24ULL, 0x000fe200078e02ffULL,
0x00000003ff317819ULL, 0x000fe20000011636ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x000000010000780cULL, 0x000fc40003f05070ULL, 0xffffffff53537811ULL, 0x000fc800078e08ffULL,
0x0000000153537807ULL, 0x000fca0004000000ULL, 0x0000000152527824ULL, 0x000fca00078e0253ULL,
0x000000355200720cULL, 0x000fe20003f06070ULL, 0x0000001002007824ULL, 0x000fe200078e00ffULL,
0x0000000431337810ULL, 0x000fe20007ffe0ffULL, 0x00000100344e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff437819ULL, 0x000fe40000011602ULL, 0x0000001000267812ULL, 0x000fce00078ec0ffULL,
0x0000005340248210ULL, 0x000fe20007ffe051ULL, 0x00000004ff258424ULL, 0x000fe200078e00ffULL,
0x0000000134007810ULL, 0x000fc60007ffe0ffULL, 0x0000600024248625ULL, 0x000fc800078e0025ULL,
0x0000000133477824ULL, 0x000fe200078e0226ULL, 0x0000000624398981ULL, 0x000562000c1e1900ULL,
0x000000370000720cULL, 0x000fe20003f06070ULL, 0x0000002043007824ULL, 0x000fe200078e024eULL,
0x00000008314f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000131457824ULL, 0x100fe200078e0226ULL,
0x0000003647627212ULL, 0x080fe200078e3cffULL, 0x00000080272b7824ULL, 0x000fe200078e00ffULL,
0x0000004000007810ULL, 0x000fe20007ffe0ffULL, 0x000000014f497824ULL, 0x000fe200078e0226ULL,
0x0000000c31597810ULL, 0x000fe20007ffe0ffULL, 0x0000000847257824ULL, 0x004fe200078e00ffULL,
0x0000003645617212ULL, 0x080fe200078e3cffULL, 0x0000000849247824ULL, 0x040fe200078e00ffULL,
0x0000003649637212ULL, 0x000fe200078e3cffULL, 0x0000000845287824ULL, 0x000fe200078e00ffULL,
0xfffffff825627812ULL, 0x000fe200078ee262ULL, 0x00000001594b7824ULL, 0x000fe200078e0226ULL,
0x0000000003257217ULL, 0x000fe20007800000ULL, 0x00000010364d7824ULL, 0x000fe200078e00ffULL,
0xfffffff824637812ULL, 0x000fe200078ee263ULL, 0x000000084b297824ULL, 0x000fe200078e00ffULL,
0xfffffff828617812ULL, 0x000fe200078ee261ULL, 0x0000000125257824ULL, 0x100fe200078e0a00ULL,
0x000000603b007812ULL, 0x000fe200078ef800ULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x000000364b647212ULL, 0x000fc400078e3cffULL, 0x0000002025257807ULL, 0x000fe20000000000ULL,
0x0000000100247824ULL, 0x040fe200078e0245ULL, 0xfffffff829647812ULL, 0x000fe200078ee264ULL,
0x0000000100277824ULL, 0x040fe200078e0247ULL, 0x0000002625257217ULL, 0x000fe20007800000ULL,
0x0000000100287824ULL, 0x040fe200078e0249ULL, 0x000000242b247210ULL, 0x040fe20007f5e0ffULL,
0x0000000100007824ULL, 0x000fe200078e024bULL, 0x000000272b2d7210ULL, 0x040fe40007f7e0ffULL,
0x000000282b297210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200010e06ffULL,
0x00005e00242e7a11ULL, 0x040fe200078438ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x000000002b2b7210ULL, 0x000fe20007f1e0ffULL, 0x0000000125007824ULL, 0x000fe200078e0a26ULL,
0x00005f00242f7a11ULL, 0x000fe200010f3c2fULL, 0x000010006b247824ULL, 0x000fe200078e00ffULL,
0x00005e002d277a11ULL, 0x000fe200078438ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x0000000838507812ULL, 0x000fe200078ec0ffULL, 0x000000ffff267224ULL, 0x000fe200000e06ffULL,
0x0000100024247812ULL, 0x000fc400078e0cffULL, 0x00005f002d2d7a11ULL, 0x000fe400010f3c28ULL,
0x000000003100720cULL, 0x000fe20003f46070ULL, 0x0000200043257824ULL, 0x000fe200078e0224ULL,
0x00005e0029287a11ULL, 0x000fe400078638ffULL, 0x000000704d317812ULL, 0x000fe400078ec0ffULL,
0x00005f0029297a11ULL, 0x000fe400018f3c2cULL, 0x00005e002b2a7a11ULL, 0x000fc400078038ffULL,
0x000000312e247210ULL, 0x080fe40007f7e0ffULL, 0x0000b00025577810ULL, 0x000fe40007ffe0ffULL,
0x00005f002b2b7a11ULL, 0x000fe200000f3c26ULL, 0x000000ffff257224ULL, 0x000fe200018e062fULL,
0x0000003127267210ULL, 0x080fe20007fbe0ffULL, 0x0000001061547824ULL, 0x000fe200078e0257ULL,
0x000000003300720cULL, 0x080fe20003f06070ULL, 0x000000086b2f7824ULL, 0x000fe200078e00ffULL,
0x0000003128287210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff277224ULL, 0x000fe200028e062dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024547faeULL, 0x0005e2000d101c46ULL,
0x000000004f00720cULL, 0x080fe20003f46070ULL, 0x0000001062557824ULL, 0x000fe200078e0257ULL,
0x000000005900720cULL, 0x000fe20003fa6070ULL, 0x000000ffff297224ULL, 0x000fe200018e0629ULL,
0xfffffff038007812ULL, 0x000fe200078ec0ffULL, 0x0000001063567824ULL, 0x100fe200078e0257ULL,
0x000000312a2a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001064577824ULL, 0x000fe200078e0257ULL,
0x0000f6a8002c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000026557faeULL, 0x0007e2000c101c46ULL,
0x000000082f2d7812ULL, 0x000fe200078e0cffULL, 0x000000ffff2b7224ULL, 0x000fe200020e062bULL,
0xffffffe038007812ULL, 0x040fe200078ec0ffULL, 0x0000000028567faeULL, 0x0009e2000d101c46ULL,
0x0000001038257812ULL, 0x004fe200078ec0ffULL, 0x000000012c2d7824ULL, 0x000fe200078e022dULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x000000002a577faeULL, 0x0009e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000100277824ULL, 0x008fc800078e0225ULL,
0x0000000127507824ULL, 0x000fc600078e0250ULL, 0x000000002d0403c2ULL, 0x000ea40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000012c2f7824ULL, 0x000fe200078e022fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002d667f8cULL, 0x0004e8000c80043fULL,
0x000004002f007984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6080050247f8cULL, 0x000fe2000c80043fULL,
0x8000000000ff7812ULL, 0x012fc60007844869ULL, 0x00f60c0050297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x000000083a277824ULL, 0x000fe400078e0227ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000267305ULL, 0x000324000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000260000735dULL, 0x010fe20003800000ULL, 0x00f60c0027297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002002447824ULL, 0x000fe200078e00ffULL, 0x00000001ff467819ULL, 0x000fe20000011636ULL,
0xffffffffff487424ULL, 0x000fe200078e00ffULL, 0x000000704d4d7812ULL, 0x000fe400078ec0ffULL,
0xffffff8044447812ULL, 0x000fe400078ec0ffULL, 0x0000000c46467812ULL, 0x000fc800078ec0ffULL,
0x0000004446007210ULL, 0x000fca0007ffe04dULL, 0x00f0000000267984ULL, 0x000e680000000800ULL,
0x00f2000000277984ULL, 0x0008a20000000800ULL, 0x0000003d2600720bULL, 0x002fe20003f1d000ULL,
0x00014aa27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x010fc800000e0100ULL,
0x0000ffff00297812ULL, 0x000fe2000780c0ffULL, 0x000003e000007945ULL, 0x000fe20003800000ULL,
0x00000001ff4f7424ULL, 0x000fd600078e00ffULL, 0x000003b000008947ULL, 0x000fea0003800000ULL,
0x00000002ff257819ULL, 0x000fe40000011602ULL, 0x0000003d2600720bULL, 0x000fe40003f14000ULL,
0x000000022500720cULL, 0x000fe20003f65270ULL, 0x00014a627f007947ULL, 0x000ff4000b800000ULL,
0x0000000000007806ULL, 0x000fe400000e0100ULL, 0x000000800225b824ULL, 0x000fe200078e024dULL,
0x000000263d2e7209ULL, 0x040fe40007810000ULL, 0x0000ffff00007812ULL, 0x000fe200078e3cffULL,
0x000000014625b824ULL, 0x000fe400078e0225ULL, 0x8000002e3d247221ULL, 0x000fe20000010000ULL,
0x0000000029ff7212ULL, 0x000fc4000780c0ffULL, 0x00f4002e2500b388ULL, 0x0003e20000000800ULL,
0x3fb8aa3b24247820ULL, 0x000fe20000410000ULL, 0x00000002ff007819ULL, 0x000fc60000011636ULL,
0x00000024002a7308ULL, 0x0003220000000800ULL, 0x000149f27f007947ULL, 0x000fea000b800000ULL,
0x00001f002a287589ULL, 0x01086400000e0000ULL, 0x0000000800007810ULL, 0x010fe20007ffe0ffULL,
0x00014a327f007947ULL, 0x000fea000b800000ULL, 0x00001f002a007589ULL, 0x0008e400000e0000ULL,
0x8000002e26260221ULL, 0x100fe20000010000ULL, 0x0000002a3e3e7220ULL, 0x000fe20000410000ULL,
0x0000000023237220ULL, 0x088fe20000410000ULL, 0x0000000022227220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b26260820ULL, 0x000fe20000410000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x0000002600420308ULL, 0x000ee20000000800ULL, 0x000000001a1a7220ULL, 0x080fe20000410000ULL,
0x0000000017177220ULL, 0x080fe20000410000ULL, 0x0000000016167220ULL, 0x080fe20000410000ULL,
0x0000000013137220ULL, 0x080fe20000410000ULL, 0x0000000012127220ULL, 0x080fe20000410000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x000000000b0b7220ULL, 0x080fe20000410000ULL, 0x000000000a0a7220ULL, 0x080fe20000410000ULL,
0x0000000007077220ULL, 0x080fe20000410000ULL, 0x0000000006067220ULL, 0x000fe20000410000ULL,
0x00000001ff4f7807ULL, 0x000fe20000000000ULL, 0x0000002821217220ULL, 0x082fe20000410000ULL,
0x0000002820207220ULL, 0x080fe20000410000ULL, 0x000000281d1d7220ULL, 0x080fe20000410000ULL,
0x000000281c1c7220ULL, 0x080fe20000410000ULL, 0x0000002819197220ULL, 0x080fe20000410000ULL,
0x0000002818187220ULL, 0x080fe20000410000ULL, 0x0000002815157220ULL, 0x080fe20000410000ULL,
0x0000002814147220ULL, 0x080fe20000410000ULL, 0x0000002811117220ULL, 0x080fe20000410000ULL,
0x0000002810107220ULL, 0x080fe20000410000ULL, 0x000000280d0d7220ULL, 0x080fe20000410000ULL,
0x000000280c0c7220ULL, 0x080fe20000410000ULL, 0x0000002809097220ULL, 0x080fe20000410000ULL,
0x0000002808087220ULL, 0x080fe20000410000ULL, 0x0000002805057220ULL, 0x080fe20000410000ULL,
0x0000002804047220ULL, 0x000fe20000410000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e002eULL,
0x0000004227270220ULL, 0x00cfc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000003e273e7221ULL, 0x004fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x000004002f007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x004fe40003800000ULL, 0x000004002f247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000042ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff277819ULL, 0x000fc40000011636ULL,
0x00005410002a7816ULL, 0x010fe20000000000ULL, 0x000146d27f007947ULL, 0x000fea000b800000ULL,
0x00001f272a957589ULL, 0x0002a400000e0000ULL, 0x00000008274a7810ULL, 0x000fe20007ffe0ffULL,
0x000147127f007947ULL, 0x000fea000b800000ULL, 0x00001f4a2a8e7589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x00000010272b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff2c7424ULL, 0x000fe200078e00ffULL, 0x0000200000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x000153f000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x00000018272b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff2c7424ULL, 0x000fe200078e00ffULL, 0x0000206000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0001539000007944ULL, 0x03cfea0003c00000ULL,
0x0000000202657824ULL, 0x000fe200078e00ffULL, 0x0000000736257812ULL, 0x000fe200078ec0ffULL,
0x0000020002c67824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000000465e17812ULL, 0x000fc400078ec0ffULL, 0x0000000825e07812ULL, 0x000fe400078ef836ULL,
0x000000e136e17211ULL, 0x000fe400078fe0ffULL, 0xfffff800c6c67812ULL, 0x000fe400078ec0ffULL,
0x00000007e1257812ULL, 0x000fca00078e78e0ULL, 0x00000008e0277824ULL, 0x002fe200078e0225ULL,
0x0000000836257812ULL, 0x000fc600078ec0ffULL, 0x00000010274c7824ULL, 0x000fe400078e02c6ULL,
0x0000000402007824ULL, 0x040fe200078e00ffULL, 0x00000002e1e17810ULL, 0x000fe20007ffe0ffULL,
0x0000100002247824ULL, 0x000fe200078e00ffULL, 0x000099104f4f7816ULL, 0x000fe400000000ffULL,
0x0000000400277812ULL, 0x000fe400078ec0ffULL, 0xffffe00024247812ULL, 0x000fe400078ec0ffULL,
0x0000000725007812ULL, 0x000fe400078ec836ULL, 0x0000002736277211ULL, 0x000fe200078fe0ffULL,
0x000010006b267824ULL, 0x000fe200078e0224ULL, 0x0000000725257812ULL, 0x000fc400078ef836ULL,
0x0000002700247212ULL, 0x000fe400078e3cffULL, 0x0000b000262d7810ULL, 0x000fe20007ffe0ffULL,
0x000010006b267824ULL, 0x000fe200078e023cULL, 0x0000000227277810ULL, 0x000fe20007ffe0ffULL,
0x0000000825587824ULL, 0x040fe200078e0224ULL, 0x00000080255b7811ULL, 0x000fe400078e18ffULL,
0x00000027002c7212ULL, 0x000fe200078e3cffULL, 0x0000001058307824ULL, 0x000fe200078e022dULL,
0x0000b000262e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000124597824ULL, 0x000fe200078e025bULL,
0x000000ff4f00720cULL, 0x000fe20003f45270ULL, 0x00000008255a7824ULL, 0x000fc400078e022cULL,
0x000000003030783bULL, 0x000e620000004200ULL, 0x0000001059287824ULL, 0x100fe400078e022eULL,
0x000000105a247824ULL, 0x000fe400078e022dULL, 0x000000012c5b7824ULL, 0x000fe400078e025bULL,
0x000000002828783bULL, 0x014ea40000004200ULL, 0x000000105b2e7824ULL, 0x000fe400078e022eULL,
0x000000002424783bULL, 0x000f280000004200ULL, 0x000000002e2c783bULL, 0x000ee20000004200ULL,
0x0001000030e67824ULL, 0x042fe200078e00ffULL, 0x00000018ffd77819ULL, 0x000fe20000011430ULL,
0x0000010030e77824ULL, 0x000fe200078e00ffULL, 0x0000003000e57306ULL, 0x000fe20000009400ULL,
0x0001000031da7824ULL, 0x040fe200078e00ffULL, 0x00000018ffe67819ULL, 0x000fe200000114e6ULL,
0x0000010032cd7824ULL, 0x040fe200078e00ffULL, 0x00000018ffe77819ULL, 0x000fe200000114e7ULL,
0x0000010031d87824ULL, 0x000fe200078e00ffULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x0000010033c97824ULL, 0x040fe200078e00ffULL, 0x000000e600eb7306ULL, 0x000fe20000209400ULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x0001000033c57824ULL, 0x000fe200078e00ffULL,
0x00000018ffd87819ULL, 0x000fe200000114d8ULL, 0x0000010029a17824ULL, 0x044fe200078e00ffULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x0001000029a37824ULL, 0x000fe200078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe20000011432ULL, 0x000000e600ea7306ULL, 0x000e620000205400ULL,
0x00000018ffc77819ULL, 0x000fe20000011431ULL, 0x0001000032c87824ULL, 0x000fe200078e00ffULL,
0x00000018ffb97819ULL, 0x000fe20000011433ULL, 0x00000100289e7824ULL, 0x040fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe20000011429ULL, 0x0001000028a87824ULL, 0x000fe200078e00ffULL,
0x00000018ffc57819ULL, 0x000fe200000114c5ULL, 0x0000003000e47306ULL, 0x000ea20000005400ULL,
0x00000018ff8b7819ULL, 0x000fe20000011428ULL, 0x000001002a837824ULL, 0x040fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x000001002b807824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x010fe20000011424ULL, 0x000100002a787824ULL, 0x000fe200078e00ffULL,
0x00000018ffb27819ULL, 0x000fe20000011425ULL, 0x0000003100d27306ULL, 0x000fe20000009400ULL,
0x000000eaeb00720bULL, 0x002fe20003f1d000ULL, 0x000100002b7b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fc4000001142aULL, 0x00000018ff6e7819ULL, 0x000fe4000001142bULL,
0x00000018ff9c7819ULL, 0x000fe20000011427ULL, 0x0000003100db7306ULL, 0x000e620000005400ULL,
0x000000e4e500720bULL, 0x004fe40003fdd000ULL, 0x00000007e1e57812ULL, 0x000fe400078e78e0ULL,
0x00000018ffab7819ULL, 0x000fe40000011426ULL, 0x00000018ff9e7819ULL, 0x000fe2000001149eULL,
0x000000d700e27306ULL, 0x000fe20000209400ULL, 0x00000008e0e57824ULL, 0x000fe200078e02e5ULL,
0x00000018ffa17819ULL, 0x000fc400000114a1ULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x00000010e54f7824ULL, 0x000fe200078e02c6ULL, 0x000000e700c67245ULL, 0x000fe2000020d400ULL,
0x0001000025e57824ULL, 0x000fe200078e00ffULL, 0x000000d700e37306ULL, 0x0005220000205400ULL,
0x000000dbd200720bULL, 0x002fe40003f9d000ULL, 0x000000e600d27245ULL, 0x000fe4000020d400ULL,
0x00000018ffdb7819ULL, 0x000fe400000114e5ULL, 0x00000001d2d20812ULL, 0x000fe200078efcffULL,
0x000000e700ec7306ULL, 0x000fe20000209400ULL, 0x000000d700d77245ULL, 0x004fc4000020d400ULL,
0x00000018ffa37819ULL, 0x000fe400000114a3ULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x000000e700ed7306ULL, 0x000e620000205400ULL,
0x000000e3e200720bULL, 0x010fe40003f7d000ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x00000018ff787819ULL, 0x000fc60000011478ULL, 0x000000da00de7306ULL, 0x000fec0000209400ULL,
0x00000001d7d73812ULL, 0x000fe400078efcffULL, 0x000000da00df7306ULL, 0x000ea20000205400ULL,
0x000000edec00720bULL, 0x002fce0003fbd000ULL, 0x0000003100897306ULL, 0x00066c000000d400ULL,
0x00000001c6c65812ULL, 0x000fe400078efcffULL, 0x000000cd00d67306ULL, 0x000fe20000209400ULL,
0x000000dfde00720bULL, 0x004fe40003f1d000ULL, 0x00000018ff317819ULL, 0x008fca000001142dULL,
0x000000cd00d37306ULL, 0x0004e20000205400ULL, 0x0000000189894812ULL, 0x002fce00078efcffULL,
0x0000003300cb7306ULL, 0x000fe20000009400ULL, 0x000000cd00cd7245ULL, 0x004fce000020d400ULL,
0x0000003300ca7306ULL, 0x000e620000005400ULL, 0x000000d3d600720bULL, 0x008fe20003f9d000ULL,
0x0001000027d37824ULL, 0x000fca00078e00ffULL, 0x00000018ffd37819ULL, 0x000fe200000114d3ULL,
0x000000d800e87306ULL, 0x000fec0000209400ULL, 0x00000001cdcd4812ULL, 0x000fe400078efcffULL,
0x000000d800e97306ULL, 0x0004e20000205400ULL, 0x000000cacb00720bULL, 0x002fc40003f7d000ULL,
0x000000da00ca7245ULL, 0x000fc8000020d400ULL, 0x00000001caca0812ULL, 0x000fe200078efcffULL,
0x0000003000917306ULL, 0x000322000000d400ULL, 0x000000d800d87245ULL, 0x004fce000020d400ULL,
0x0000003200dc7306ULL, 0x000fe20000009400ULL, 0x000000e9e800720bULL, 0x008fe40003fbd000ULL,
0x00000018ff307819ULL, 0x002fca000001142cULL, 0x0000003200dd7306ULL, 0x000e620000005400ULL,
0x0000000191916812ULL, 0x010fca00078efcffULL, 0x00000001d8d85812ULL, 0x000fe400078efcffULL,
0x000000c900d47306ULL, 0x000ff00000209400ULL, 0x000000c900d97306ULL, 0x000ea20000205400ULL,
0x000000dddc00720bULL, 0x002fe20003fdd000ULL, 0x0000010026dc7824ULL, 0x000fca00078e00ffULL,
0x00000018ffcb7819ULL, 0x000fe200000114dcULL, 0x000000bc00c47306ULL, 0x000ff00000209400ULL,
0x000000bc00c37306ULL, 0x000e620000205400ULL, 0x000000d9d400720bULL, 0x004fce0003f1d000ULL,
0x000000c700d07306ULL, 0x000ff00000209400ULL, 0x000000c700d17306ULL, 0x0004e20000205400ULL,
0x000000c3c400720bULL, 0x002fe40003f9d000ULL, 0x000000c900c47245ULL, 0x000fc8000020d400ULL,
0x00000001c4c40812ULL, 0x000fe200078efcffULL, 0x0000002900987306ULL, 0x000fe20000009400ULL,
0x000000c700c77245ULL, 0x004fce000020d400ULL, 0x00000029009b7306ULL, 0x000fe20000005400ULL,
0x000000d1d000720bULL, 0x008fe20003fbd000ULL, 0x0000010027d17824ULL, 0x000fca00078e00ffULL,
0x00000018ffd17819ULL, 0x000fe200000114d1ULL, 0x0000002900007306ULL, 0x0003ec000000d400ULL,
0x00000001c7c75812ULL, 0x000fe400078efcffULL, 0x0000003200827306ULL, 0x000ea2000000d400ULL,
0x0000010025297824ULL, 0x002fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x000000b900c17306ULL, 0x000ff00000209400ULL, 0x000000b900c27306ULL, 0x000e620000205400ULL,
0x0000000182826812ULL, 0x004fc800078efcffULL, 0x00000082cd82723eULL, 0x000fc600000010ffULL,
0x000000c500ce7306ULL, 0x000ff00000209400ULL, 0x000000c500cf7306ULL, 0x0004e20000205400ULL,
0x000000c2c100720bULL, 0x002fe40003fdd000ULL, 0x000000bc00c17245ULL, 0x000fc4000020d400ULL,
0x000000b900bc7245ULL, 0x000fe4000020d400ULL, 0x00000001c1c14812ULL, 0x000fe200078efcffULL,
0x00000028009a7306ULL, 0x000fe20000009400ULL, 0x000000c500c57245ULL, 0x004fca000020d400ULL,
0x00000001bcbc6812ULL, 0x000fe400078efcffULL, 0x00000028009d7306ULL, 0x000fe20000005400ULL,
0x000000cfce00720bULL, 0x008fce0003f1d000ULL, 0x0000002800697306ULL, 0x0003ec000000d400ULL,
0x00000001c5c50812ULL, 0x000fe400078efcffULL, 0x0000002400bb7306ULL, 0x000fe20000009400ULL,
0x0000010024287824ULL, 0x002fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000002400ba7306ULL, 0x000ff00000005400ULL, 0x0000002400717306ULL, 0x0003f0000000d400ULL,
0x0000002900e17306ULL, 0x000fe20000209400ULL, 0x0001000024247824ULL, 0x002fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000002900e47306ULL, 0x000e700000205400ULL,
0x000000c800cc7306ULL, 0x000ff00000209400ULL, 0x000000c800d57306ULL, 0x0004e20000205400ULL,
0x000000e4e100720bULL, 0x002fce0003f9d000ULL, 0x0000002500b67306ULL, 0x000fe20000009400ULL,
0x000000c800c87245ULL, 0x004fce000020d400ULL, 0x0000002500b57306ULL, 0x000e620000005400ULL,
0x000000d5cc00720bULL, 0x008fce0003fbd000ULL, 0x0000002500707306ULL, 0x000eac000000d400ULL,
0x00000001c8c85812ULL, 0x000fe400078efcffULL, 0x0000002400e07306ULL, 0x000fe20000209400ULL,
0x000000b5b600720bULL, 0x002fe40003f1d000ULL, 0x0000002900b57245ULL, 0x000fc4000020d400ULL,
0x000000babb00720bULL, 0x000fe40003fbd000ULL, 0x00000001b5b54812ULL, 0x000fe200078efcffULL,
0x0000002400257306ULL, 0x000e620000205400ULL, 0x0000002400b67245ULL, 0x000fe4000020d400ULL,
0x0000002800ba7245ULL, 0x000fc6000020d400ULL, 0x0000000170700812ULL, 0x004fe400078efcffULL,
0x0000003300817306ULL, 0x000ea4000000d400ULL, 0x0000000171715812ULL, 0x000fcc00078efcffULL,
0x0000002a00997306ULL, 0x000fe20000009400ULL, 0x00000025e000720bULL, 0x002fce0003fdd000ULL,
0x0000002a008c7306ULL, 0x000fe20000005400ULL, 0x0000000181813812ULL, 0x004fca00078efcffULL,
0x00000001b6b66812ULL, 0x000fe400078efcffULL, 0x0000002a00607306ULL, 0x000ff0000000d400ULL,
0x0000002b00977306ULL, 0x000ff00000009400ULL, 0x0000002b00907306ULL, 0x000ff00000005400ULL,
0x0000002b005f7306ULL, 0x000ff0000000d400ULL, 0x000000db00e27306ULL, 0x000ff00000209400ULL,
0x000000db00dd7306ULL, 0x0002b00000205400ULL, 0x00000028002a7306ULL, 0x000fe20000209400ULL,
0x000000db00db7245ULL, 0x002fce000020d400ULL, 0x00000028002b7306ULL, 0x000e620000205400ULL,
0x000000dde200720bULL, 0x004fce0003f9d000ULL, 0x0000002700a67306ULL, 0x000fec0000009400ULL,
0x00000001dbdb4812ULL, 0x000fe400078efcffULL, 0x0000002700a77306ULL, 0x000ea20000005400ULL,
0x0000002b2a00720bULL, 0x002fe40003f7d000ULL, 0x009000004c28783bULL, 0x000e6a0000000200ULL,
0x00000027006a7306ULL, 0x000eec000000d400ULL, 0x00000001baba3812ULL, 0x000fc400078efcffULL,
0x000000cb00d07306ULL, 0x000fe20000209400ULL, 0x000000a7a600720bULL, 0x004fe40003f9d000ULL,
0x00000018ffa67819ULL, 0x000fe4000001142eULL, 0x00000071baba723eULL, 0x000fc600000010ffULL,
0x000000cb00277306ULL, 0x000eac0000205400ULL, 0x000000016a6a4812ULL, 0x008fe400078efcffULL,
0x0000002600b77306ULL, 0x000ff00000009400ULL, 0x0000002600b87306ULL, 0x000ee20000005400ULL,
0x00000027d000720bULL, 0x004fe20003fdd000ULL, 0x000000952828a231ULL, 0x002fc400003400ffULL,
0x000000952a2aa231ULL, 0x000fe400003400ffULL, 0x0000008e2929a231ULL, 0x080fe400003400ffULL,
0x000000b400bd7306ULL, 0x000fe20000209400ULL, 0x0000008e2b2ba231ULL, 0x000fce00003400ffULL,
0x000000b400be7306ULL, 0x0002a20000205400ULL, 0x000000b8b700720bULL, 0x008fe40003f7d000ULL,
0x000000b400b77245ULL, 0x000fca000020d400ULL, 0x00000026006f7306ULL, 0x000722000000d400ULL,
0x000000cb00b47245ULL, 0x002fc8000020d400ULL, 0x00000001b4b46812ULL, 0x000fc600078efcffULL,
0x000000ab00b07306ULL, 0x000fe20000209400ULL, 0x0001000026267824ULL, 0x008fe200078e00ffULL,
0x000000bebd00720bULL, 0x004fc80003fbd000ULL, 0x00000018ffbb7819ULL, 0x000fe40000011426ULL,
0x000000ab00b37306ULL, 0x000e620000205400ULL, 0x009000004f24783bULL, 0x000ea20000000200ULL,
0x000000016f6f3812ULL, 0x010fe400078efcffULL, 0x0000009d9a00720bULL, 0x000fe40003f7d000ULL,
0x000000bb009d7245ULL, 0x000fe4000020d400ULL, 0x000000b200bf7306ULL, 0x000fe20000209400ULL,
0x00000001b7b75812ULL, 0x000fc800078efcffULL, 0x000000b6b7b6723eULL, 0x000fc600000010ffULL,
0x000000b200c07306ULL, 0x0007220000205400ULL, 0x000000b3b000720bULL, 0x002fe40003fdd000ULL,
0x000000d100b37245ULL, 0x000fe4000020d400ULL, 0x0000000169693812ULL, 0x000fc600078efcffULL,
0x0000009c00ac7306ULL, 0x000fe20000209400ULL, 0x000000b200b27245ULL, 0x008fce000020d400ULL,
0x0000009c00ad7306ULL, 0x000e620000205400ULL, 0x000000c0bf00720bULL, 0x010fce0003f1d000ULL,
0x000000d100c37306ULL, 0x000fe20000209400ULL, 0x000000952424a231ULL, 0x084fe400003400ffULL,
0x000000952626a231ULL, 0x000fe400003400ffULL, 0x0000008e2525a231ULL, 0x080fe200003400ffULL,
0x00000001b2b20812ULL, 0x000fe200078efcffULL, 0x0000008e2727a231ULL, 0x000fe200003400ffULL,
0x000000d100c27306ULL, 0x000ea20000205400ULL, 0x000000adac00720bULL, 0x002fe20003f9d000ULL,
0x000001002fad7824ULL, 0x040fe200078e00ffULL, 0x000000ab00ac7245ULL, 0x000fe2000020d400ULL,
0x000001002eab7824ULL, 0x000fe200078e00ffULL, 0x000000dbb2b7723eULL, 0x000fe200000010ffULL,
0x000100002f8e7824ULL, 0x000fe200078e00ffULL, 0x00000001acac6812ULL, 0x000fe200078efcffULL,
0x000000bb00b97306ULL, 0x000fe20000209400ULL, 0x0000008c9900720bULL, 0x000fc40003fdd000ULL,
0x0000009c00997245ULL, 0x000fe2000020d400ULL, 0x000100002e9c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001142fULL, 0x000000b62818723cULL, 0x000fe20000041818ULL,
0x0000000199994812ULL, 0x000fe200078efcffULL, 0x000000bb00b87306ULL, 0x0002e20000205400ULL,
0x000000c2c300720bULL, 0x004fe40003fbd000ULL, 0x00000018ffab7819ULL, 0x000fe400000114abULL,
0x0000006fb4b2723eULL, 0x000fc400000010ffULL, 0x0000000160606812ULL, 0x000fe200078efcffULL,
0x0000009e009f7306ULL, 0x000fe20000209400ULL, 0x00000070b5bb723eULL, 0x002fe400000010ffULL,
0x00000018ff707819ULL, 0x000fe400000114adULL, 0x00000018ff9c7819ULL, 0x000fe4000001149cULL,
0x00000001b3b35812ULL, 0x000fe200078efcffULL, 0x0000009e00a07306ULL, 0x0002a20000205400ULL,
0x000000b8b900720bULL, 0x008fe20003f1d000ULL, 0x000000ba2814723cULL, 0x000fe20000041814ULL,
0x0000006ab3b3723eULL, 0x000fc400000010ffULL, 0x00000018ff8e7819ULL, 0x000fc6000001148eULL,
0x000000d300bd7306ULL, 0x000fe20000209400ULL, 0x0000009e009e7245ULL, 0x002fe2000020d400ULL,
0x000000b2281c723cULL, 0x000fe8000004181cULL, 0x000000019d9d0812ULL, 0x000fe400078efcffULL,
0x000000d300be7306ULL, 0x000e620000205400ULL, 0x000000a09f00720bULL, 0x004fe20003f9d000ULL,
0x000001002d9f7824ULL, 0x000fe200078e00ffULL, 0x0000009b9800720bULL, 0x000fc40003f1d000ULL,
0x000000d300987245ULL, 0x000fe4000020d400ULL, 0x00000018ff9f7819ULL, 0x000fe2000001149fULL,
0x000000a100a27306ULL, 0x000fe20000209400ULL, 0x0000009dacac723eULL, 0x000fe400000010ffULL,
0x0000008e009d7245ULL, 0x000fc6000020d400ULL, 0x000000019e9e4812ULL, 0x000fe400078efcffULL,
0x000000a100a97306ULL, 0x0004e20000205400ULL, 0x000000bebd00720bULL, 0x002fe40003fbd000ULL,
0x0000000100000812ULL, 0x000fe400078efcffULL, 0x000000699e9e723eULL, 0x000fc600000010ffULL,
0x000000a800aa7306ULL, 0x000fe20000209400ULL, 0x000000a100a17245ULL, 0x004fca000020d400ULL,
0x0000000198985812ULL, 0x000fe400078efcffULL, 0x000000a800af7306ULL, 0x0002a20000205400ULL,
0x000000a9a200720bULL, 0x008fe20003f5d000ULL, 0x000100002ca27824ULL, 0x040fe200078e00ffULL,
0x000000909700720bULL, 0x000fe20003fbd000ULL, 0x000001002c977824ULL, 0x000fe200078e00ffULL,
0x0000009899ad723eULL, 0x000fc600000010ffULL, 0x00000084008d7306ULL, 0x000fe20000209400ULL,
0x00000018ff977819ULL, 0x000fe40000011497ULL, 0x000000a800a87245ULL, 0x002fe2000020d400ULL,
0x000000ac2820723cULL, 0x000fe40000041820ULL, 0x00000001a1a12812ULL, 0x000fe400078efcffULL,
0x0000008400947306ULL, 0x0002e20000205400ULL, 0x000000afaa00720bULL, 0x004fe20003f9d000ULL,
0x000100002daa7824ULL, 0x000fe200078e00ffULL, 0x000000015f5f5812ULL, 0x000fc800078efcffULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x000000a300ae7306ULL, 0x000fe20000209400ULL,
0x0000008400847245ULL, 0x002fca000020d400ULL, 0x00000001a8a84812ULL, 0x000fe400078efcffULL,
0x000000a300b17306ULL, 0x0002a20000205400ULL, 0x000000948d00720bULL, 0x008fce0003f1d000ULL,
0x0000008b00927306ULL, 0x000fe20000209400ULL, 0x000000a300a37245ULL, 0x002fca000020d400ULL,
0x0000000184840812ULL, 0x000fe400078efcffULL, 0x0000008b008f7306ULL, 0x0002e20000205400ULL,
0x000000b1ae00720bULL, 0x004fce0003f5d000ULL, 0x0000007300937306ULL, 0x000fe20000209400ULL,
0x0000008b008b7245ULL, 0x002fca000020d400ULL, 0x00000001a3a32812ULL, 0x000fe400078efcffULL,
0x0000007300967306ULL, 0x0002a20000205400ULL, 0x0000008f9200720bULL, 0x008fe40003f7d000ULL,
0x000000a384a3723eULL, 0x000fca00000010ffULL, 0x0000008300a47306ULL, 0x000fe20000209400ULL,
0x0000007300737245ULL, 0x002fca000020d400ULL, 0x000000018b8b3812ULL, 0x000fe400078efcffULL,
0x0000008300a57306ULL, 0x000e620000205400ULL, 0x000000969300720bULL, 0x004fce0003f9d000ULL,
0x0000008000877306ULL, 0x000fec0000209400ULL, 0x0000000173734812ULL, 0x000fe400078efcffULL,
0x00000080008a7306ULL, 0x0004e20000205400ULL, 0x000000a5a400720bULL, 0x002fce0003f5d000ULL,
0x0000006e00887306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x004fce000020d400ULL,
0x0000006e00857306ULL, 0x0002a20000205400ULL, 0x0000008a8700720bULL, 0x008fce0003f1d000ULL,
0x0000009700a07306ULL, 0x000fe20000209400ULL, 0x0000006e006e7245ULL, 0x002fca000020d400ULL,
0x0000000180800812ULL, 0x000fe400078efcffULL, 0x0000009700a97306ULL, 0x0002e20000205400ULL,
0x000000858800720bULL, 0x004fe40003f7d000ULL, 0x0000008300857245ULL, 0x000fe4000020d400ULL,
0x00000081c483723eULL, 0x000fe400000010ffULL, 0x0000000185852812ULL, 0x000fe200078efcffULL,
0x0000002c00797306ULL, 0x000fe20000009400ULL, 0x0000009700977245ULL, 0x002fc6000020d400ULL,
0x00000082280c723cULL, 0x000fe4000004180cULL, 0x000000016e6e3812ULL, 0x000fe400078efcffULL,
0x0000002c007a7306ULL, 0x000e620000005400ULL, 0x000000a9a000720bULL, 0x008fce0003f9d000ULL,
0x0000002c00687306ULL, 0x0004ec000000d400ULL, 0x0000000197974812ULL, 0x000fe400078efcffULL,
0x0000002d00767306ULL, 0x000fe20000009400ULL, 0x00000091c62c723eULL, 0x004fe400000010ffULL,
0x0000007a7900720bULL, 0x002fc40003f5d000ULL, 0x0000007b00797245ULL, 0x000fc6000020d400ULL,
0x0000002d00777306ULL, 0x000e700000005400ULL, 0x0000002d005e7306ULL, 0x000522000000d400ULL,
0x0000000168682812ULL, 0x008fc800078efcffULL, 0x000000689768723eULL, 0x000fc600000010ffULL,
0x0000007b007e7306ULL, 0x000fe20000209400ULL, 0x00000089d82d723eULL, 0x004fe400000010ffULL,
0x00000018ff897819ULL, 0x000fe400000114a2ULL, 0x000000777600720bULL, 0x002fe40003f1d000ULL,
0x000000a88ba2723eULL, 0x000fe200000010ffULL, 0x0000007b007d7306ULL, 0x000e620000205400ULL,
0x0000002c2804723cULL, 0x000fee0000041804ULL, 0x00000078007c7306ULL, 0x000fe20000209400ULL,
0x000000c8c12c723eULL, 0x000fc400000010ffULL, 0x000000c5bc2d723eULL, 0x000fe400000010ffULL,
0x000000015e5e0812ULL, 0x010fc600078efcffULL, 0x00000078007f7306ULL, 0x0004e20000205400ULL,
0x0000007d7e00720bULL, 0x002fe20003fbd000ULL, 0x0000002c2810723cULL, 0x000fec0000041810ULL,
0x0000003000337306ULL, 0x000fe20000209400ULL, 0x0000007800787245ULL, 0x004fe4000020d400ULL,
0x0000009f002d7245ULL, 0x000fc6000020d400ULL, 0x0000000179795812ULL, 0x000fe400078efcffULL,
0x0000003000747306ULL, 0x0002a20000205400ULL, 0x0000007f7c00720bULL, 0x008fe40003fdd000ULL,
0x000000796e79723eULL, 0x000fca00000010ffULL, 0x0000009f008f7306ULL, 0x000fe20000209400ULL,
0x0000003000307245ULL, 0x002fca000020d400ULL, 0x0000000178786812ULL, 0x000fe400078efcffULL,
0x0000009f00927306ULL, 0x0002e20000205400ULL, 0x000000743300720bULL, 0x004fe40003f7d000ULL,
0x000000787378723eULL, 0x000fca00000010ffULL, 0x0000002e00727306ULL, 0x000fe20000009400ULL,
0x00000000a19f723eULL, 0x002fe200000010ffULL, 0x000000782410723cULL, 0x000fe20000041810ULL,
0x000000ab00007245ULL, 0x000fc6000020d400ULL, 0x0000000130303812ULL, 0x000fe400078efcffULL,
0x0000002e00757306ULL, 0x000e620000005400ULL, 0x000000928f00720bULL, 0x008fe20003f9d000ULL,
0x0000009e2404723cULL, 0x000fec0000041804ULL, 0x0000002e005d7306ULL, 0x0004ec000000d400ULL,
0x000000012d2d4812ULL, 0x000fc400078efcffULL, 0x0000002f006d7306ULL, 0x000fe20000009400ULL,
0x000000d2d72e723eULL, 0x004fe400000010ffULL, 0x000000757200720bULL, 0x002fe40003fdd000ULL,
0x0000005e2d69723eULL, 0x000fc600000010ffULL, 0x0000002f006c7306ULL, 0x000e680000005400ULL,
0x000000682414723cULL, 0x000fe80000041814ULL, 0x0000002f005c7306ULL, 0x000522000000d400ULL,
0x000000015d5d6812ULL, 0x008fce00078efcffULL, 0x0000003100327306ULL, 0x000fe20000209400ULL,
0x000000cac72f723eULL, 0x004fe400000010ffULL, 0x0000006c6d00720bULL, 0x002fca0003fbd000ULL,
0x0000002e2808723cULL, 0x000fe20000041808ULL, 0x0000003100a77306ULL, 0x0002ac0000205400ULL,
0x000000608528723eULL, 0x000fe400000010ffULL, 0x000000aa002e7306ULL, 0x000fe20000209400ULL,
0x0000003100317245ULL, 0x002fc4000020d400ULL, 0x0000005f8029723eULL, 0x000fe400000010ffULL,
0x000000015c5c5812ULL, 0x010fc600078efcffULL, 0x000000aa002f7306ULL, 0x0002e20000205400ULL,
0x000000a73200720bULL, 0x004fe20003f5d000ULL, 0x00000028240c723cULL, 0x040fec000004180cULL,
0x0000008900887306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x002fe2000020d400ULL,
0x000000a22408723cULL, 0x000fe20000041808ULL, 0x0000007000297245ULL, 0x000fc6000020d400ULL,
0x0000000131312812ULL, 0x000fe400078efcffULL, 0x0000008900877306ULL, 0x0002a20000205400ULL,
0x0000002f2e00720bULL, 0x008fce0003f1d000ULL, 0x000000ab002c7306ULL, 0x000fe20000209400ULL,
0x0000008900897245ULL, 0x002fca000020d400ULL, 0x00000001aaaa0812ULL, 0x000fe400078efcffULL,
0x000000ab00717306ULL, 0x000e620000205400ULL, 0x000000878800720bULL, 0x004fe40003f9d000ULL,
0x000000aa3131723eULL, 0x000fca00000010ffULL, 0x000000a6009a7306ULL, 0x000fec0000209400ULL,
0x0000000189894812ULL, 0x000fe400078efcffULL, 0x000000a6009b7306ULL, 0x000ea20000205400ULL,
0x000000712c00720bULL, 0x002fe40003f7d000ULL, 0x000000893030723eULL, 0x000fca00000010ffULL,
0x0000008c00907306ULL, 0x000fe40000209400ULL, 0x000000302418723cULL, 0x000fe80000041818ULL,
0x0000000100003812ULL, 0x000fe400078efcffULL, 0x0000008c00957306ULL, 0x0002e20000205400ULL,
0x0000009b9a00720bULL, 0x004fe40003f9d000ULL, 0x0000005d0028723eULL, 0x000fca00000010ffULL,
0x00000070006c7306ULL, 0x000fe20000209400ULL, 0x0000008c008c7245ULL, 0x002fce000020d400ULL,
0x0000007000337306ULL, 0x000e620000205400ULL, 0x000000959000720bULL, 0x008fce0003f1d000ULL,
0x0000009c00327306ULL, 0x000fec0000209400ULL, 0x000000018c8c0812ULL, 0x000fe400078efcffULL,
0x0000009c002b7306ULL, 0x0004e20000205400ULL, 0x000000336c00720bULL, 0x002fce0003f5d000ULL,
0x0000008e002a7306ULL, 0x000fe20000209400ULL, 0x0000009c009c7245ULL, 0x004fca000020d400ULL,
0x0000000129292812ULL, 0x000fe400078efcffULL, 0x0000008e002f7306ULL, 0x000e620000205400ULL,
0x0000002b3200720bULL, 0x008fe40003f7d000ULL, 0x000000a6002b7245ULL, 0x000fe4000020d400ULL,
0x0000005c2929723eULL, 0x000fe400000010ffULL, 0x000000012b2b4812ULL, 0x000fca00078efcffULL,
0x00000028241c723cULL, 0x000fe4000004181cULL, 0x000000019c9c3812ULL, 0x000fe400078efcffULL,
0x0000002f2a00720bULL, 0x002fe40003fdd000ULL, 0x0000009c2b9c723eULL, 0x000fd600000010ffULL,
0x000000019d9d6812ULL, 0x000fc800078efcffULL, 0x0000009d8c9d723eULL, 0x000fce00000010ffULL,
0x0000009c2420723cULL, 0x000fe20000041820ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020003f247f8cULL, 0x0002a2000c80043fULL, 0xfffffff8655c7812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000404e007810ULL, 0x000fe20007ffe0ffULL,
0x00f688005cff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff697224ULL, 0x000fe200078e0067ULL,
0x000000016b6b7812ULL, 0x000fe400078e0cffULL, 0x000000030000720cULL, 0x000fda0003f06070ULL,
0x0000878000000947ULL, 0x000fea0003800000ULL, 0x0000040086007984ULL, 0x008ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x000024003f007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x000024003f247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff437819ULL, 0x000fe20000011602ULL,
0x00000008415e7824ULL, 0x000fe200078e00ffULL, 0x0000000134267810ULL, 0x000fe20007ffe0ffULL,
0x0000580039287a24ULL, 0x020fe200078e02ffULL, 0x0000000838247812ULL, 0x000fe200078ec0ffULL,
0x0000001043007824ULL, 0x040fe200078e00ffULL, 0x000000372600720cULL, 0x000fe20003f06070ULL,
0x0000002043267824ULL, 0x000fe200078e024eULL, 0xffffffe038257812ULL, 0x000fe200078ec0ffULL,
0x0000008028297824ULL, 0x000fe200078e00ffULL, 0x00000010005d7812ULL, 0x040fe200078ec0ffULL,
0x00001000416a7824ULL, 0x000fe200078e00ffULL, 0x0000f6a800607810ULL, 0x000fc40007ffe0ffULL,
0x0000008026007810ULL, 0x000fe20007ffe0ffULL, 0x0000001002267824ULL, 0x000fe200078e00ffULL,
0x000000085e5f7812ULL, 0x000fe400078ec0ffULL, 0x00000025245d7210ULL, 0x000fe40007ffe05dULL,
0x0000000003257217ULL, 0x000fe40007800000ULL, 0x000000603b247812ULL, 0x100fe400078ef800ULL,
0x000000085f277812ULL, 0x000fe200078e3cffULL, 0x0000000125257824ULL, 0x000fe200078e0a00ULL,
0x0000001026307812ULL, 0x000fe200078ec0ffULL, 0x00000001605f7824ULL, 0x000fc400078e025fULL,
0x0000000145007824ULL, 0x100fe200078e0224ULL, 0x0000002025257807ULL, 0x000fe20000000000ULL,
0x0000000160607824ULL, 0x000fe200078e0227ULL, 0x000000005f0473c2ULL, 0x000ea200000e0000ULL,
0x0000000147267824ULL, 0x100fe200078e0224ULL, 0x0000000029007210ULL, 0x000fe20007f5e0ffULL,
0x0000000149277824ULL, 0x100fe200078e0224ULL, 0x0000002530257217ULL, 0x000fe20007800000ULL,
0x000000014b247824ULL, 0x000fe200078e0224ULL, 0x00000026292d7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200010e06ffULL, 0x0000002729277210ULL, 0x000fc40007f9e0ffULL,
0x00000024292c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x00005e00002e7a11ULL, 0x040fe200078438ffULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x00005e002d267a11ULL, 0x000fe400078638ffULL, 0x00005e0027287a11ULL, 0x000fe400078838ffULL,
0x00005f00002f7a11ULL, 0x000fe200010f3c2fULL, 0x0000000125007824ULL, 0x000fe200078e0a30ULL,
0x00005f002d2d7a11ULL, 0x000fe200018f3c2aULL, 0x000000ffff257224ULL, 0x000fe200000e06ffULL,
0x00005f0027297a11ULL, 0x000fc400020f3c24ULL, 0x00005e002c2a7a11ULL, 0x000fe400078038ffULL,
0x000010006a247812ULL, 0x000fe400078ec0ffULL, 0x00000003ff277819ULL, 0x000fe40000011636ULL,
0x00005f002c2c7a11ULL, 0x000fe200000f3c25ULL, 0x0000200043257824ULL, 0x000fe200078e0224ULL,
0x00000008272b7810ULL, 0x000fe40007ffe0ffULL, 0x0000004d2e247210ULL, 0x000fc40007f9e0ffULL,
0x0000000427317810ULL, 0x040fe40007ffe0ffULL, 0x000000002700720cULL, 0x0c0fe40003f66070ULL,
0x0000000c27277810ULL, 0x000fe40007ffe0ffULL, 0x0000004d26267210ULL, 0x080fe40007fbe0ffULL,
0x000000002b00720cULL, 0x080fe40003f06070ULL, 0x0000b000252b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff257224ULL, 0x000fe200020e062fULL, 0x000000002700720cULL, 0x080fe20003f86070ULL,
0x000000ffff277224ULL, 0x000fe200028e062dULL, 0x0000004d28287210ULL, 0x000fe20007fbe0ffULL,
0x0000001061617824ULL, 0x100fe200078e022bULL, 0x000000003100720cULL, 0x000fe20003f46070ULL,
0x0000001062627824ULL, 0x000fc400078e022bULL, 0x000000ffff297224ULL, 0x000fe200028e0629ULL,
0x0000004d2a2a7210ULL, 0x000fe20007fbe0ffULL, 0x0000001063637824ULL, 0x100fe200078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024617faeULL, 0x0007e2000d901c46ULL,
0x0000001064647824ULL, 0x000fe400078e022bULL, 0x000000ffff2b7224ULL, 0x000fc800028e062cULL,
0x0000000026627faeULL, 0x0007e8000d101c46ULL, 0x0000000028637faeULL, 0x0007e8000c101c46ULL,
0x000000002a647faeULL, 0x0007e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x004fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000005f687f8cULL, 0x000528000c80043fULL,
0x0000040060277984ULL, 0x0084e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f628005d247f8cULL, 0x000fe2000c80043fULL,
0x8000000027ff7812ULL, 0x008fc60007844867ULL, 0x00f62c005d297984ULL, 0x000ee40000000800ULL,
0x8000000029ff7812ULL, 0x008fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x000764000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000260000735dULL, 0x020fe20003800000ULL,
0x00f62c0050277984ULL, 0x000ee40000000800ULL, 0x8000000027ff7812ULL, 0x008fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000804d257810ULL, 0x000fca0007ffe044ULL,
0x0000000146257824ULL, 0x000fca00078e0225ULL, 0x00f0000025007984ULL, 0x000ee80000000800ULL,
0x00f2000025277984ULL, 0x0002a20000000800ULL, 0x0000003d0000720bULL, 0x008fe20003f1d000ULL,
0x00011dc27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x002fc800000e0100ULL,
0x0000ffff24267812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ffad7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000102257811ULL, 0x000fe400078ff0ffULL, 0x0000003d0000720bULL, 0x000fe40003f14000ULL,
0x000000022500720cULL, 0x000fe20003f65270ULL, 0x00011d827f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x000000003d287209ULL, 0x000fe20007810000ULL,
0x000000800229b824ULL, 0x000fc800078e024dULL, 0x00000001462bb824ULL, 0x000fe200078e0229ULL,
0x800000283d257221ULL, 0x000fe20000010000ULL, 0x0000ffff24297812ULL, 0x000fc600078e3cffULL,
0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL, 0x00f400282b00b388ULL, 0x0003e20000000800ULL,
0x0000002926ff7212ULL, 0x000fe4000780c0ffULL, 0x00000025002a7308ULL, 0x000ee20000000800ULL,
0x00000002ff297819ULL, 0x000fe20000011636ULL, 0x0000002a3e3e7220ULL, 0x008fe20000410000ULL,
0x00011d027f007947ULL, 0x000fec000b800000ULL, 0x00001f292a247589ULL, 0x0022e400000e0000ULL,
0x0000002404047220ULL, 0x088fe20000410000ULL, 0x0000002405057220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x000000240c0c7220ULL, 0x080fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002420207220ULL, 0x080fe20000410000ULL, 0x0000002421217220ULL, 0x000fe20000410000ULL,
0x00011c527f007947ULL, 0x000fea000b800000ULL, 0x00001f4a2a247589ULL, 0x00066400000e0000ULL,
0x8000002800000221ULL, 0x100fe20000010000ULL, 0x00000001ffad7807ULL, 0x000fe20000000000ULL,
0x0000002406067220ULL, 0x082fe20000410000ULL, 0x0000002407077220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL, 0x000000240a0a7220ULL, 0x080fe20000410000ULL,
0x000000240b0b7220ULL, 0x080fe20000410000ULL, 0x000000240e0e7220ULL, 0x080fe20000410000ULL,
0x0000000000420308ULL, 0x000e620000000800ULL, 0x000000240f0f7220ULL, 0x080fe20000410000ULL,
0x0000002412127220ULL, 0x080fe20000410000ULL, 0x0000002413137220ULL, 0x080fe20000410000ULL,
0x0000002416167220ULL, 0x080fe20000410000ULL, 0x0000002417177220ULL, 0x080fe20000410000ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x000000241e1e7220ULL, 0x080fe20000410000ULL, 0x000000241f1f7220ULL, 0x080fe20000410000ULL,
0x0000002422227220ULL, 0x080fe20000410000ULL, 0x0000002423237220ULL, 0x000fe20000410000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e0028ULL, 0x0000002742270220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000003e273e7221ULL, 0x004fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x0000000841007824ULL, 0x000fe200078e00ffULL, 0xfffffff038257812ULL, 0x000fc800078ec0ffULL,
0x0000000800007812ULL, 0x000fca00078e0cffULL, 0x0000000125247824ULL, 0x000fca00078e0200ULL,
0x00f6ac0024257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000257305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x004fe40003800000ULL,
0x00f6ac0024257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff2b7819ULL, 0x000fe40000011636ULL,
0x00000042ff24723eULL, 0x000fe400000010ffULL, 0x000000182b007810ULL, 0x040fe40007ffe0ffULL,
0x000000102b267810ULL, 0x000fe40007ffe0ffULL, 0x00005410242a7816ULL, 0x008fe20000000024ULL,
0x000119a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2b2a9b7589ULL, 0x0002a400000e0000ULL,
0x000119e27f007947ULL, 0x000fea000b800000ULL, 0x00001f4a2a927589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x002fe200078e0026ULL,
0x00004f8000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0001247000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x002fe200078e0000ULL,
0x00004fe000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0001241000007944ULL, 0x01cfea0003c00000ULL,
0x00001000412d7824ULL, 0x002fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100002007824ULL, 0x000fc600078e00ffULL, 0x000010002d2d7812ULL, 0x000fe400078e0cffULL,
0xffffe00000007812ULL, 0x000fc800078ec0ffULL, 0x0000b00000677810ULL, 0x100fe40007ffe02dULL,
0x0000b0003c007810ULL, 0x000fc60007ffe02dULL, 0x0000001058667824ULL, 0x100fe400078e0267ULL,
0x000000105a677824ULL, 0x000fe400078e0267ULL, 0x0000001059687824ULL, 0x110fe200078e0200ULL,
0x000000006624783bULL, 0x000e620000004200ULL, 0x000000105b657824ULL, 0x000fc600078e0200ULL,
0x000000006728783bULL, 0x00cea80000004200ULL, 0x000000006830783bULL, 0x000ee80000004200ULL,
0x00000000652c783bULL, 0x000f220000004200ULL, 0x00000018ffae7819ULL, 0x002fe20000011424ULL,
0x0000010024b77824ULL, 0x040fe200078e00ffULL, 0x0000002400af7306ULL, 0x000fe20000009400ULL,
0x0001000024c47824ULL, 0x000fe200078e00ffULL, 0x00000018ffe57819ULL, 0x000fe20000011425ULL,
0x0001000025e97824ULL, 0x040fe200078e00ffULL, 0x00000018ffb77819ULL, 0x000fe200000114b7ULL,
0x0000010025bc7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc47819ULL, 0x000fe200000114c4ULL,
0x0000010027e17824ULL, 0x040fe200078e00ffULL, 0x000000ae00b97306ULL, 0x000fe20000209400ULL,
0x00000018ffe97819ULL, 0x000fe200000114e9ULL, 0x0000010026e67824ULL, 0x000fe200078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe200000114bcULL, 0x0001000027d97824ULL, 0x000fe200078e00ffULL,
0x00000018ffe17819ULL, 0x000fe200000114e1ULL, 0x0000010028d07824ULL, 0x004fe200078e00ffULL,
0x00000018ffe67819ULL, 0x000fe200000114e6ULL, 0x000000ae00b47306ULL, 0x0002a20000205400ULL,
0x00000018ffce7819ULL, 0x000fe20000011426ULL, 0x0001000026dc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa17819ULL, 0x000fc4000001142bULL, 0x00000018ffcb7819ULL, 0x000fe40000011427ULL,
0x00000018ffa77819ULL, 0x008fe20000011430ULL, 0x0000002400b87306ULL, 0x000ee20000005400ULL,
0x000000ae00ae7245ULL, 0x002fe4000020d400ULL, 0x00000018ffd97819ULL, 0x000fe400000114d9ULL,
0x00000018ffd07819ULL, 0x000fe400000114d0ULL, 0x00000018ffa47819ULL, 0x000fe2000001142aULL,
0x000000b700b17306ULL, 0x000fe20000209400ULL, 0x000000b4b900720bULL, 0x004fe20003f1d000ULL,
0x0000010030b47824ULL, 0x000fe200078e00ffULL, 0x00000018ffdc7819ULL, 0x000fc400000114dcULL,
0x00000018ff907819ULL, 0x000fe40000011431ULL, 0x00000018ffbd7819ULL, 0x000fe20000011428ULL,
0x000000b700b27306ULL, 0x0002a20000205400ULL, 0x000000b8af00720bULL, 0x008fe20003f9d000ULL,
0x000001002aaf7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe40000011429ULL,
0x00000018ff887819ULL, 0x000fe40000011432ULL, 0x00000001aeae0812ULL, 0x000fe200078efcffULL,
0x000000c400ec7306ULL, 0x000fe20000209400ULL, 0x000000b700b77245ULL, 0x002fc4000020d400ULL,
0x00000018ff817819ULL, 0x000fe40000011433ULL, 0x00000018ffaf7819ULL, 0x000fe400000114afULL,
0x00000018ffb47819ULL, 0x000fe200000114b4ULL, 0x000000c400ef7306ULL, 0x000e620000205400ULL,
0x000000b2b100720bULL, 0x004fe40003fbd000ULL, 0x00000018ff717819ULL, 0x010fe4000001142cULL,
0x00000018ff727819ULL, 0x000fc4000001142dULL, 0x00000018ff737819ULL, 0x000fe2000001142eULL,
0x0000002500ac7306ULL, 0x000fe20000009400ULL, 0x00000018ff767819ULL, 0x000fca000001142fULL,
0x00000001b7b75812ULL, 0x000fe400078efcffULL, 0x0000002500b57306ULL, 0x000ea20000005400ULL,
0x000000efec00720bULL, 0x002fe20003f7d000ULL, 0x0000010032ec7824ULL, 0x000fcc00078e00ffULL,
0x000000e900ba7306ULL, 0x000ff00000209400ULL, 0x000000e900bb7306ULL, 0x000e620000205400ULL,
0x000000b5ac00720bULL, 0x004fe20003f5d000ULL, 0x000001002bac7824ULL, 0x000fc400078e00ffULL,
0x000100002bb57824ULL, 0x000fc600078e00ffULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x0000002400a67306ULL, 0x000ea2000000d400ULL, 0x00000018ffb57819ULL, 0x000fce00000114b5ULL,
0x000000bc00c57306ULL, 0x000fe20000209400ULL, 0x000000bbba00720bULL, 0x002fce0003f1d000ULL,
0x000000bc00ea7306ULL, 0x0002e20000205400ULL, 0x00000001a6a64812ULL, 0x004fce00078efcffULL,
0x000000e500b37306ULL, 0x000fe20000209400ULL, 0x000000bc00bc7245ULL, 0x002fce000020d400ULL,
0x000000e500b67306ULL, 0x000e620000205400ULL, 0x000000eac500720bULL, 0x008fe20003f9d000ULL,
0x0001000031ea7824ULL, 0x000fe400078e00ffULL, 0x0001000033c57824ULL, 0x000fc800078e00ffULL,
0x0000002600cf7306ULL, 0x000fe20000009400ULL, 0x00000018ffc57819ULL, 0x000fca00000114c5ULL,
0x00000001bcbc4812ULL, 0x000fe400078efcffULL, 0x0000002600b07306ULL, 0x000ea20000005400ULL,
0x000000b6b300720bULL, 0x002fce0003fbd000ULL, 0x00000025008f7306ULL, 0x000e70000000d400ULL,
0x0000002700df7306ULL, 0x000fe20000009400ULL, 0x000000b0cf00720bULL, 0x004fe20003fdd000ULL,
0x000100002ab07824ULL, 0x000fca00078e00ffULL, 0x00000018ffb07819ULL, 0x000fe200000114b0ULL,
0x0000002700e07306ULL, 0x000fe20000005400ULL, 0x000000018f8f2812ULL, 0x002fce00078efcffULL,
0x000000e100e87306ULL, 0x000ff00000209400ULL, 0x000000e100eb7306ULL, 0x000e700000205400ULL,
0x0000002b00c17306ULL, 0x000ff00000009400ULL, 0x0000002b00be7306ULL, 0x000fe20000005400ULL,
0x000000ebe800720bULL, 0x002fce0003f5d000ULL, 0x0000002b007c7306ULL, 0x0003f0000000d400ULL,
0x000000e600c67306ULL, 0x000fe20000209400ULL, 0x00009910ad2b7816ULL, 0x002fe400000000ffULL,
0x000000c400ad7245ULL, 0x000fe2000020d400ULL, 0x0001000032c47824ULL, 0x000fc600078e00ffULL,
0x00000001adad3812ULL, 0x000fe200078efcffULL, 0x000000e600ed7306ULL, 0x000e620000205400ULL,
0x000000ff2b00720cULL, 0x000fe20003f65270ULL, 0x00010000302b7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc47819ULL, 0x000fca00000114c4ULL, 0x000000ce00d77306ULL, 0x000ff00000209400ULL,
0x000000ce00da7306ULL, 0x000fe20000205400ULL, 0x000000edc600720bULL, 0x002fce0003f9d000ULL,
0x0000002700897306ULL, 0x0003f0000000d400ULL, 0x0000003000957306ULL, 0x000fe20000009400ULL,
0x0000010029277824ULL, 0x002fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000003000a27306ULL, 0x000ff00000005400ULL, 0x0000003000797306ULL, 0x0003f0000000d400ULL,
0x00000026008a7306ULL, 0x000ea2000000d400ULL, 0x000000e900307245ULL, 0x002fc8000020d400ULL,
0x0000000130300812ULL, 0x000fe400078efcffULL, 0x000000e0df00720bULL, 0x000fe20003f1d000ULL,
0x000000cb00d57306ULL, 0x000ff00000209400ULL, 0x000000cb00d47306ULL, 0x000e620000205400ULL,
0x000000018a8a6812ULL, 0x004fc600078efcffULL, 0x0000000189890812ULL, 0x000fc800078efcffULL,
0x000000d900e27306ULL, 0x000ff00000209400ULL, 0x000000d900e37306ULL, 0x0005e20000205400ULL,
0x000000d4d500720bULL, 0x002fe40003fdd000ULL, 0x000000ce00d57245ULL, 0x000fca000020d400ULL,
0x000000d000dd7306ULL, 0x000fe20000209400ULL, 0x000000d900d97245ULL, 0x004fce000020d400ULL,
0x000000d000de7306ULL, 0x0002b00000205400ULL, 0x0000002a00c27306ULL, 0x000fe20000009400ULL,
0x000000d000d07245ULL, 0x002fce000020d400ULL, 0x0000002a00c37306ULL, 0x000fe20000005400ULL,
0x000000dedd00720bULL, 0x004fce0003f1d000ULL, 0x0000002a00827306ULL, 0x0003ec000000d400ULL,
0x00000001d0d00812ULL, 0x000fe400078efcffULL, 0x0000003100967306ULL, 0x000fe20000009400ULL,
0x00000100312a7824ULL, 0x002fca00078e00ffULL, 0x00000018ffba7819ULL, 0x000fe2000001142aULL,
0x00000100332a7824ULL, 0x000fe200078e00ffULL, 0x0000003100937306ULL, 0x000ff00000005400ULL,
0x0000003100007306ULL, 0x0003f0000000d400ULL, 0x000000dc00e47306ULL, 0x000fe20000209400ULL,
0x000000e500317245ULL, 0x002fc4000020d400ULL, 0x00000018ffe57819ULL, 0x000fe4000001142bULL,
0x0000000131315812ULL, 0x000fe400078efcffULL, 0x000000dad700720bULL, 0x000fe20003fbd000ULL,
0x000000dc00e77306ULL, 0x0003e20000205400ULL, 0x00000018ffd77819ULL, 0x000fce00000114eaULL,
0x0000002700d67306ULL, 0x000fe20000209400ULL, 0x000000dc00dc7245ULL, 0x002fc6000020d400ULL,
0x00000001d5d55812ULL, 0x000fc800078efcffULL, 0x0000002700db7306ULL, 0x000e700000205400ULL,
0x0000002900ca7306ULL, 0x000ff00000009400ULL, 0x0000002900c97306ULL, 0x000ea20000005400ULL,
0x000000dbd600720bULL, 0x002fe20003fbd000ULL, 0x000001002cd67824ULL, 0x000fcc00078e00ffULL,
0x0000002900857306ULL, 0x0003f0000000d400ULL, 0x0000003200a07306ULL, 0x000fe20000009400ULL,
0x0001000029297824ULL, 0x002fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000003200917306ULL, 0x000ff00000005400ULL, 0x00000032006b7306ULL, 0x0003f0000000d400ULL,
0x000000bd00c87306ULL, 0x000fe20000209400ULL, 0x000000e100327245ULL, 0x002fc8000020d400ULL,
0x0000000132322812ULL, 0x000fe400078efcffULL, 0x000000e3e200720bULL, 0x000fe20003f5d000ULL,
0x000000bd00c77306ULL, 0x000e700000205400ULL, 0x0000003300aa7306ULL, 0x000fe80000009400ULL,
0x00000001d9d92812ULL, 0x000fc400078efcffULL, 0x000000c9ca00720bULL, 0x004fe40003f5d000ULL,
0x0000003300977306ULL, 0x000fe20000005400ULL, 0x000000c7c800720bULL, 0x002fe40003f1d000ULL,
0x0000002700c87245ULL, 0x000fe4000020d400ULL, 0x00000018ffc77819ULL, 0x000fe4000001142aULL,
0x00000001c8c85812ULL, 0x000fe200078efcffULL, 0x00000033006c7306ULL, 0x0003e2000000d400ULL,
0x00000018ffc97819ULL, 0x000fc400000114ecULL, 0x0000000185852812ULL, 0x000fe400078efcffULL,
0x000000bec100720bULL, 0x000fe40003f5d000ULL, 0x000000bd00c17245ULL, 0x000fe2000020d400ULL,
0x0000002800cc7306ULL, 0x000fe20000009400ULL, 0x000000e600337245ULL, 0x002fe2000020d400ULL,
0x000100002ebd7824ULL, 0x000fe200078e00ffULL, 0x0000002900be7245ULL, 0x000fe4000020d400ULL,
0x0000000133334812ULL, 0x000fc400078efcffULL, 0x000000e7e400720bULL, 0x000fe20003f9d000ULL,
0x0000002800cd7306ULL, 0x000e620000005400ULL, 0x00000001c1c10812ULL, 0x000fe400078efcffULL,
0x000000017c7c2812ULL, 0x000fe400078efcffULL, 0x000000a29500720bULL, 0x000fe40003f5d000ULL,
0x000000a400957245ULL, 0x000fe2000020d400ULL, 0x0000002900d27306ULL, 0x000fe20000209400ULL,
0x0000008a338a723eULL, 0x000fc400000010ffULL, 0x00000018ffbd7819ULL, 0x000fe400000114bdULL,
0x00000001dcdc4812ULL, 0x000fc600078efcffULL, 0x0000002900d37306ULL, 0x000ea20000205400ULL,
0x000000cdcc00720bULL, 0x002fe40003f9d000ULL, 0x000000cb00cc7245ULL, 0x000fe4000020d400ULL,
0x0000000179792812ULL, 0x000fe400078efcffULL, 0x00000001cccc6812ULL, 0x000fe200078efcffULL,
0x0000002800877306ULL, 0x0002e2000000d400ULL, 0x00000097aa00720bULL, 0x000fe40003f5d000ULL,
0x000000d9ccd9723eULL, 0x000fca00000010ffULL, 0x000000af00247306ULL, 0x000fe20000209400ULL,
0x0001000028287824ULL, 0x002fe200078e00ffULL, 0x000000d3d200720bULL, 0x004fc80003fbd000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x000000af00257306ULL, 0x0002a20000205400ULL,
0x0000000187874812ULL, 0x008fe400078efcffULL, 0x000000c3c200720bULL, 0x000fe40003f9d000ULL,
0x0000002800c27245ULL, 0x000fe4000020d400ULL, 0x00000001bebe5812ULL, 0x000fe200078efcffULL,
0x000000ac00267306ULL, 0x000fe20000209400ULL, 0x000000a300c37245ULL, 0x000fc4000020d400ULL,
0x000000af00af7245ULL, 0x002fe4000020d400ULL, 0x000000016c6c2812ULL, 0x000fe400078efcffULL,
0x00000087d0d0723eULL, 0x000fe200000010ffULL, 0x000000ac00cf7306ULL, 0x000e620000205400ULL,
0x000000252400720bULL, 0x004fe40003f1d000ULL, 0x0000000182824812ULL, 0x000fca00078efcffULL,
0x0000002800d17306ULL, 0x000fec0000209400ULL, 0x00000001afaf0812ULL, 0x000fe400078efcffULL,
0x0000002800d87306ULL, 0x0004e20000205400ULL, 0x000000cf2600720bULL, 0x002fe20003fbd000ULL,
0x000100002dcf7824ULL, 0x000fe200078e00ffULL, 0x009800004f24783bULL, 0x000e620000000200ULL,
0x00000082af82723eULL, 0x000fc600000010ffULL, 0x00000018ffcf7819ULL, 0x000fe200000114cfULL,
0x000000a300c07306ULL, 0x000fe20000209400ULL, 0x009800004c28783bULL, 0x004eae0000000200ULL,
0x000000a300bf7306ULL, 0x0009620000205400ULL, 0x000000d8d100720bULL, 0x008fe20003fdd000ULL,
0x000001002dd87824ULL, 0x000fcc00078e00ffULL, 0x000000a400987306ULL, 0x000fe20000209400ULL,
0x000100002fa37824ULL, 0x010fca00078e00ffULL, 0x00000001c2c26812ULL, 0x000fe400078efcffULL,
0x000000a4009f7306ULL, 0x000ee20000205400ULL, 0x000000bfc000720bULL, 0x020fe20003fdd000ULL,
0x000001002ec07824ULL, 0x000fe200078e00ffULL, 0x000000c2c1c2723eULL, 0x000fe200000010ffULL,
0x000001002fbf7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe400000114a3ULL,
0x00000018ffc07819ULL, 0x000fe200000114c0ULL, 0x000000b500b27306ULL, 0x000fe20000209400ULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x0000009b2424b231ULL, 0x002fc400003400ffULL,
0x0000009b2626b231ULL, 0x080fe400003400ffULL, 0x00000001c3c36812ULL, 0x000fe200078efcffULL,
0x000000922525b231ULL, 0x080fe200003400ffULL, 0x000000b500b97306ULL, 0x0003220000205400ULL,
0x0000009f9800720bULL, 0x008fe20003fdd000ULL, 0x0000009b2828b231ULL, 0x084fe200003400ffULL,
0x000000ac009f7245ULL, 0x000fe2000020d400ULL, 0x0000009b2a2ab231ULL, 0x000fe200003400ffULL,
0x000000a700987245ULL, 0x000fe2000020d400ULL, 0x000000922929b231ULL, 0x080fe200003400ffULL,
0x000000019f9f5812ULL, 0x000fe200078efcffULL, 0x000000e500df7306ULL, 0x000fe20000209400ULL,
0x000000922b2bb231ULL, 0x080fe200003400ffULL, 0x000000b500b57245ULL, 0x002fe2000020d400ULL,
0x000000922727b231ULL, 0x000fe200003400ffULL, 0x00000018ff927819ULL, 0x000fc400000114d8ULL,
0x0000000195956812ULL, 0x000fe400078efcffULL, 0x000000e500d47306ULL, 0x0002a20000205400ULL,
0x000000b9b200720bULL, 0x010fe40003fbd000ULL, 0x00000091a000720bULL, 0x000fe40003fdd000ULL,
0x000000ba00917245ULL, 0x000fe4000020d400ULL, 0x000000dcd5d8723eULL, 0x000fe200000010ffULL,
0x000000b400b37306ULL, 0x000fe20000209400ULL, 0x000000e500e57245ULL, 0x002fc4000020d400ULL,
0x000000bec3c3723eULL, 0x000fe400000010ffULL, 0x000000bf00c17245ULL, 0x000fe2000020d400ULL,
0x000000d82810723cULL, 0x000fe20000041810ULL, 0x00000001b5b55812ULL, 0x000fe200078efcffULL,
0x000000b400b67306ULL, 0x0002e20000205400ULL, 0x000000d4df00720bULL, 0x004fe40003f7d000ULL,
0x000000016b6b6812ULL, 0x000fc600078efcffULL, 0x000000c22818723cULL, 0x000fe40000041818ULL,
0x000000c900ca7306ULL, 0x000fe20000209400ULL, 0x000000b400b47245ULL, 0x002fca000020d400ULL,
0x00000001e5e53812ULL, 0x000fe400078efcffULL, 0x000000c900d17306ULL, 0x000e620000205400ULL,
0x000000b6b300720bULL, 0x008fce0003fbd000ULL, 0x000000a1009a7306ULL, 0x000fec0000209400ULL,
0x00000001b4b45812ULL, 0x000fe400078efcffULL, 0x000000a100a57306ULL, 0x000ea20000205400ULL,
0x000000d1ca00720bULL, 0x002fe40003f7d000ULL, 0x00000085c8d1723eULL, 0x000fc400000010ffULL,
0x00000079b4b4723eULL, 0x000fc600000010ffULL, 0x000000b000b17306ULL, 0x000fe40000209400ULL,
0x000000d02814723cULL, 0x000fec0000041814ULL, 0x000000b000b87306ULL, 0x0002e20000205400ULL,
0x000000a59a00720bULL, 0x004fe40003f9d000ULL, 0x00000090009a7245ULL, 0x000fca000020d400ULL,
0x000000a700ab7306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x002fce000020d400ULL,
0x000000a7009c7306ULL, 0x000e620000205400ULL, 0x000000b8b100720bULL, 0x008fce0003f1d000ULL,
0x000000c700d27306ULL, 0x000fec0000209400ULL, 0x00000001b0b00812ULL, 0x000fe400078efcffULL,
0x000000c700d37306ULL, 0x0004e20000205400ULL, 0x0000009cab00720bULL, 0x002fe40003fbd000ULL,
0x000000939600720bULL, 0x000fc40003f1d000ULL, 0x00000018ff937819ULL, 0x000fe400000114d6ULL,
0x000000a100967245ULL, 0x000fe2000020d400ULL, 0x0000009000a97306ULL, 0x000fe20000209400ULL,
0x000000c700c77245ULL, 0x004fe4000020d400ULL, 0x0000000196964812ULL, 0x000fe400078efcffULL,
0x000000b095b0723eULL, 0x000fe400000010ffULL, 0x0000000198985812ULL, 0x000fe200078efcffULL,
0x00000090009e7306ULL, 0x0002a20000205400ULL, 0x0000000100000812ULL, 0x000fc400078efcffULL,
0x000000b596b1723eULL, 0x000fe400000010ffULL, 0x000000cf00957245ULL, 0x000fe4000020d400ULL,
0x000000e59898723eULL, 0x000fe200000010ffULL, 0x0000002c00947306ULL, 0x000fe20000009400ULL,
0x000000c900907245ULL, 0x002fe2000020d400ULL, 0x000000b02820723cULL, 0x000fe60000041820ULL,
0x0000000190903812ULL, 0x000fc400078efcffULL, 0x000000d3d200720bULL, 0x008fe20003f7d000ULL,
0x0000002c00997306ULL, 0x000e620000005400ULL, 0x0000009ea900720bULL, 0x004fe40003f1d000ULL,
0x0000006b9090723eULL, 0x000fca00000010ffULL, 0x00000088008c7306ULL, 0x000fe80000209400ULL,
0x00000001c7c73812ULL, 0x000fe400078efcffULL, 0x000000019a9a0812ULL, 0x000fe400078efcffULL,
0x00000088008b7306ULL, 0x000ea20000205400ULL, 0x000000999400720bULL, 0x002fce0003fbd000ULL,
0x000000ba00bb7306ULL, 0x000ff00000209400ULL, 0x000000ba00c67306ULL, 0x000e620000205400ULL,
0x0000008b8c00720bULL, 0x004fe40003fdd000ULL, 0x00000089328b723eULL, 0x000fca00000010ffULL,
0x000000c400cd7306ULL, 0x000fe40000209400ULL, 0x0000008a280c723cULL, 0x000fec000004180cULL,
0x000000c400ac7306ULL, 0x0004e20000205400ULL, 0x000000c6bb00720bULL, 0x002fce0003f9d000ULL,
0x0000002c006d7306ULL, 0x000322000000d400ULL, 0x000000c400c47245ULL, 0x004fca000020d400ULL,
0x0000000191914812ULL, 0x000fe400078efcffULL, 0x0000008100847306ULL, 0x000fe20000209400ULL,
0x000100002c2c7824ULL, 0x002fe200078e00ffULL, 0x000000accd00720bULL, 0x008fe40003f7d000ULL,
0x0000000091b5723eULL, 0x000fe400000010ffULL, 0x00000018ff947819ULL, 0x000fe4000001142cULL,
0x0000008100837306ULL, 0x000e620000205400ULL, 0x000000a6b72c723eULL, 0x000fc400000010ffULL,
0x000000016d6d5812ULL, 0x010fe400078efcffULL, 0x0000006cc791723eULL, 0x000fe400000010ffULL,
0x00000001c4c43812ULL, 0x000fe200078efcffULL, 0x000000d700ce7306ULL, 0x000fe80000209400ULL,
0x00000090240c723cULL, 0x000fe8000004180cULL, 0x000000d700cb7306ULL, 0x0004e20000205400ULL,
0x000000838400720bULL, 0x002fc40003f7d000ULL, 0x0000007c9f83723eULL, 0x000fca00000010ffULL,
0x0000009300a07306ULL, 0x000fe20000209400ULL, 0x000000d700d77245ULL, 0x004fe2000020d400ULL,
0x00000082281c723cULL, 0x000fec000004181cULL, 0x00000093009b7306ULL, 0x000fe20000205400ULL,
0x000000cbce00720bULL, 0x008fce0003f9d000ULL, 0x0000002d00a87306ULL, 0x000fec0000009400ULL,
0x00000001d7d74812ULL, 0x000fe400078efcffULL, 0x0000002d009d7306ULL, 0x000e700000005400ULL,
0x0000002d006e7306ULL, 0x0005f0000000d400ULL, 0x0000002e008e7306ULL, 0x000fe20000009400ULL,
0x0000008fbc2d723eULL, 0x004fc400000010ffULL, 0x0000009da800720bULL, 0x002fca0003f9d000ULL,
0x0000002c2804723cULL, 0x000fe20000041804ULL, 0x0000002e008d7306ULL, 0x000e6c0000005400ULL,
0x00000088002d7245ULL, 0x000fe4000020d400ULL, 0x000000c500a27306ULL, 0x000fe20000209400ULL,
0x00000081002c7245ULL, 0x000fc4000020d400ULL, 0x000000012d2d6812ULL, 0x000fe400078efcffULL,
0x0000009ba000720bULL, 0x000fe40003fdd000ULL, 0x000000012c2c3812ULL, 0x000fe200078efcffULL,
0x000000c500a17306ULL, 0x0004e20000205400ULL, 0x0000008d8e00720bULL, 0x002fe40003f1d000ULL,
0x000000016e6e4812ULL, 0x000fe400078efcffULL, 0x000000c42dc4723eULL, 0x000fc400000010ffULL,
0x000000b42404723cULL, 0x000fe20000041804ULL, 0x00000071007d7306ULL, 0x000fe20000209400ULL,
0x000000c500c57245ULL, 0x004fce000020d400ULL, 0x00000071007e7306ULL, 0x0002a20000205400ULL,
0x000000a1a200720bULL, 0x008fce0003f5d000ULL, 0x0000009200977306ULL, 0x000fe20000209400ULL,
0x0000007100717245ULL, 0x002fca000020d400ULL, 0x00000001c5c52812ULL, 0x000fe400078efcffULL,
0x00000092009c7306ULL, 0x000fe20000205400ULL, 0x0000007e7d00720bULL, 0x004fe40003f7d000ULL,
0x000000c52cc5723eULL, 0x000fca00000010ffULL, 0x0000002e006f7306ULL, 0x0002a4000000d400ULL,
0x000000c42410723cULL, 0x000fe80000041810ULL, 0x0000000171713812ULL, 0x000fe400078efcffULL,
0x0000002f00807306ULL, 0x000fe20000009400ULL, 0x000000adae2e723eULL, 0x002fce00000010ffULL,
0x0000002f007f7306ULL, 0x000e620000005400ULL, 0x000000016f6f0812ULL, 0x004fce00078efcffULL,
0x0000002f00707306ULL, 0x0005f0000000d400ULL, 0x00000072007a7306ULL, 0x000fe20000209400ULL,
0x00000030312f723eULL, 0x004fe400000010ffULL, 0x0000007f8000720bULL, 0x002fca0003f5d000ULL,
0x0000002e2808723cULL, 0x000fe20000041808ULL, 0x00000072007b7306ULL, 0x0002ac0000205400ULL,
0x00000093002e7245ULL, 0x000fe4000020d400ULL, 0x0000009400997306ULL, 0x000fe20000209400ULL,
0x00000092002f7245ULL, 0x000fc4000020d400ULL, 0x000000012e2e6812ULL, 0x000fe400078efcffULL,
0x0000009c9700720bULL, 0x000fe40003fdd000ULL, 0x0000007200727245ULL, 0x002fe2000020d400ULL,
0x00000094008e7306ULL, 0x0002e20000205400ULL, 0x0000007b7a00720bULL, 0x004fe40003fbd000ULL,
0x0000000170702812ULL, 0x000fe400078efcffULL, 0x0000006d2e2e723eULL, 0x000fc600000010ffULL,
0x000000cf00307306ULL, 0x000fe20000209400ULL, 0x0000009400947245ULL, 0x002fe4000020d400ULL,
0x000000012f2f6812ULL, 0x000fc600078efcffULL, 0x0000000172725812ULL, 0x000fe400078efcffULL,
0x000000cf00317306ULL, 0x000e620000205400ULL, 0x0000008e9900720bULL, 0x008fe40003fdd000ULL,
0x000000d79a99723eULL, 0x000fe400000010ffULL, 0x0000006e2f2f723eULL, 0x000fc600000010ffULL,
0x000000c000327306ULL, 0x000fe40000209400ULL, 0x000000982408723cULL, 0x040fe80000041808ULL,
0x0000000194946812ULL, 0x000fe400078efcffULL, 0x000000c000337306ULL, 0x0004e20000205400ULL,
0x000000313000720bULL, 0x002fe20003f9d000ULL, 0x0000002e2414723cULL, 0x000fe20000041814ULL,
0x000000947194723eULL, 0x000fca00000010ffULL, 0x0000007300747306ULL, 0x000fe20000209400ULL,
0x000000c000c07245ULL, 0x004fca000020d400ULL, 0x0000000195954812ULL, 0x000fe400078efcffULL,
0x0000007300757306ULL, 0x000e620000205400ULL, 0x000000333200720bULL, 0x008fe40003f7d000ULL,
0x000000957295723eULL, 0x000fca00000010ffULL, 0x0000007600777306ULL, 0x000fe40000209400ULL,
0x000000942418723cULL, 0x000fe80000041818ULL, 0x00000001c0c03812ULL, 0x000fe400078efcffULL,
0x0000007600787306ULL, 0x0004e20000205400ULL, 0x000000757400720bULL, 0x002fe40003fdd000ULL,
0x0000006fc0c0723eULL, 0x000fca00000010ffULL, 0x000000bf007f7306ULL, 0x000fe20000209400ULL,
0x0000007600767245ULL, 0x004fce000020d400ULL, 0x000000bf007c7306ULL, 0x000e620000205400ULL,
0x000000787700720bULL, 0x008fce0003f9d000ULL, 0x000000bd007a7306ULL, 0x000fec0000209400ULL,
0x0000000176764812ULL, 0x000fe400078efcffULL, 0x000000bd00297306ULL, 0x0004e20000205400ULL,
0x0000007c7f00720bULL, 0x002fce0003fbd000ULL, 0x000000a300007306ULL, 0x000fe20000209400ULL,
0x000000bd00bd7245ULL, 0x004fca000020d400ULL, 0x00000001c1c15812ULL, 0x000fe400078efcffULL,
0x000000a3002b7306ULL, 0x000e620000205400ULL, 0x000000297a00720bULL, 0x008fe40003f7d000ULL,
0x000000a300297245ULL, 0x000fe4000020d400ULL, 0x00000070c1c1723eULL, 0x000fce00000010ffULL,
0x000000c0241c723cULL, 0x000fe4000004181cULL, 0x00000001bdbd3812ULL, 0x000fe400078efcffULL,
0x0000002b0000720bULL, 0x002fe40003f1d000ULL, 0x0000007300007245ULL, 0x000fc8000020d400ULL,
0x0000000100006812ULL, 0x000fc800078efcffULL, 0x000000bd0028723eULL, 0x000fc600000010ffULL,
0x0000000129290812ULL, 0x000fc800078efcffULL, 0x000000297629723eULL, 0x000fce00000010ffULL,
0x000000282420723cULL, 0x000fe20000041820ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003f247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000804e007810ULL, 0x000fe20007ffe0ffULL,
0x00f690005cff7f8cULL, 0x0007e2000c80043fULL, 0x00000001416b7812ULL, 0x000fe400078ec0ffULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x000059d000000947ULL, 0x000fea0003800000ULL,
0x0000040086007984ULL, 0x008ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003f007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000024003f247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000151517824ULL, 0x000fe400078e0253ULL, 0x00000300ff007624ULL, 0x000fe400078e00ffULL,
0x0000580039267a24ULL, 0x000fe200078e02ffULL, 0x0000000151247812ULL, 0x000fe200078ec0ffULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0xffffffff00007811ULL, 0x000fe400078e08ffULL,
0x000000012400780cULL, 0x000fc80003f05070ULL, 0x00000001006c7807ULL, 0x000fca0004000000ULL,
0x0000000151007824ULL, 0x000fe200078e026cULL, 0x00000001ff437819ULL, 0x000fc80000011602ULL,
0x000000350000720cULL, 0x000fe20003f06070ULL, 0x0000002043007824ULL, 0x000fca00078e024eULL,
0x000000c000007810ULL, 0x000fc80007ffe0ffULL, 0x0000000003277217ULL, 0x000fc60007800000ULL,
0x0000006c40248210ULL, 0x000fe20007ffe051ULL, 0x00000004ff258424ULL, 0x000fe400078e00ffULL,
0x0000000127277824ULL, 0x100fe200078e0a00ULL, 0x000000603b007812ULL, 0x000fe200078ef800ULL,
0x0000600024248625ULL, 0x000fe200078e0025ULL, 0x0000000134287810ULL, 0x000fc60007ffe0ffULL,
0x00000080262b7824ULL, 0x000fe200078e00ffULL, 0x0000000624398981ULL, 0x000562000c1e1900ULL,
0x000000372800720cULL, 0x000fe20003f46070ULL, 0x0000001002287824ULL, 0x000fe200078e00ffULL,
0xfffffff038297812ULL, 0x000fe200078ec0ffULL, 0x0000000149267824ULL, 0x100fe200078e0200ULL,
0x000000085e317812ULL, 0x000fe400078ec0ffULL, 0x0000001028287812ULL, 0x000fe200078ec0ffULL,
0x00000000290573c2ULL, 0x00072200000e0000ULL, 0x0000002027277807ULL, 0x000fe20001000000ULL,
0x0000000145247824ULL, 0x104fe200078e0200ULL, 0x000000262b267210ULL, 0x000fe20007f7e0ffULL,
0x0000000147257824ULL, 0x100fe200078e0200ULL, 0x0000002728277217ULL, 0x000fe20007800000ULL,
0x000000014b007824ULL, 0x000fe200078e0200ULL, 0x000000242b247210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff297224ULL, 0x008fe200018e06ffULL, 0x000000252b257210ULL, 0x000fe20007f5e0ffULL,
0x0000000127277824ULL, 0x000fe200078e0a28ULL, 0x000000002b2b7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200000e06ffULL, 0x00005e0024307a11ULL, 0x000fe200078038ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x0000000831007812ULL, 0x000fc400078e3cffULL,
0x00005f00242f7a11ULL, 0x000fe200000f3c2fULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x00000000000473c2ULL, 0x000ea200000e0000ULL, 0x00005e00252c7a11ULL, 0x000fe400078038ffULL,
0x00000003ff327819ULL, 0x000fe40000011636ULL, 0x00005e0026287a11ULL, 0x000fe200078438ffULL,
0x0000f6a805057890ULL, 0x010fe2000fffe03fULL, 0x00005e002b2a7a11ULL, 0x000fe400078638ffULL,
0x00005f00252d7a11ULL, 0x000fc400000f3c2eULL, 0x000000273200720cULL, 0x000fe40003f06070ULL,
0x00005f0026297a11ULL, 0x000fe400010f3c29ULL, 0x00005f002b2b7a11ULL, 0x000fe400018f3c24ULL,
0x0000004d30247210ULL, 0x000fe40007f5e0ffULL, 0x0000000832267810ULL, 0x040fe40007ffe0ffULL,
0x00000004322e7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff257224ULL, 0x000fe200010e062fULL,
0x0000000c32327810ULL, 0x000fe20007ffe0ffULL, 0x0000000405047290ULL, 0x004fe2000fffe03fULL,
0x000000272600720cULL, 0x000fc40003f66070ULL, 0x0000004d2c267210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024547faeULL, 0x0005e2000c101c46ULL,
0x000000272e00720cULL, 0x080fe40003f86070ULL, 0x000000273200720cULL, 0x000fe20003f46070ULL,
0x000000ffff277224ULL, 0x000fe200028e062dULL, 0x0000004d28287210ULL, 0x080fe40007f1e0ffULL,
0x0000004d2a2a7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff297224ULL, 0x000fe400000e0629ULL,
0x000000ffff2b7224ULL, 0x000fe400028e062bULL, 0x0000000026557faeULL, 0x0007e8000e101c46ULL,
0x0000000028567faeULL, 0x0007e8000d901c46ULL, 0x000000002a577faeULL, 0x0007e8000d101c46ULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000547f8cULL, 0x0084e8000c800405ULL, 0x0000040531267984ULL, 0x0005220008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6480050247f8cULL, 0x000fe2000c80043fULL, 0x8000000026ff7812ULL, 0x010fc60007844869ULL,
0x00f64c0050277984ULL, 0x000f240000000800ULL, 0x8000000027ff7812ULL, 0x010fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x004fc800078e00ffULL,
0x0000000000267305ULL, 0x000524000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000260000735dULL, 0x010fe20003800000ULL, 0x00f64c0050277984ULL, 0x000ea40000000800ULL,
0x8000000027ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001004d257810ULL, 0x000fca0007ffe044ULL, 0x0000000146257824ULL, 0x000fca00078e0225ULL,
0x00f0000025007984ULL, 0x004ea80000000800ULL, 0x00f2000025277984ULL, 0x0008620000000800ULL,
0x0000003d0000720bULL, 0x004fe20003f1d000ULL, 0x0000f2627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x010fc800000e0100ULL, 0x0000ffff24267812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ffc67424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000202257811ULL, 0x000fe400078ff0ffULL,
0x0000003d0000720bULL, 0x000fe40003f14000ULL, 0x000000022500720cULL, 0x000fe20003f65270ULL,
0x0000f2227f007947ULL, 0x000ff4000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x000000003d287209ULL, 0x000fe20007810000ULL, 0x000000800229b824ULL, 0x000fc800078e024dULL,
0x00000001462bb824ULL, 0x000fe200078e0229ULL, 0x800000283d257221ULL, 0x000fe20000010000ULL,
0x0000ffff24297812ULL, 0x000fc600078e3cffULL, 0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL,
0x00f400282b00b388ULL, 0x0005e20000000800ULL, 0x0000002926ff7212ULL, 0x000fe4000780c0ffULL,
0x00000025002a7308ULL, 0x000f220000000800ULL, 0x00000002ff297819ULL, 0x000fe20000011636ULL,
0x0000002a3e3e7220ULL, 0x010fe20000410000ULL, 0x0000f1a27f007947ULL, 0x000fec000b800000ULL,
0x00001f292a247589ULL, 0x00452400000e0000ULL, 0x0000002404047220ULL, 0x090fe20000410000ULL,
0x0000002405057220ULL, 0x080fe20000410000ULL, 0x0000002408087220ULL, 0x080fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002420207220ULL, 0x080fe20000410000ULL,
0x0000002421217220ULL, 0x000fe20000410000ULL, 0x0000f0f27f007947ULL, 0x000fea000b800000ULL,
0x00001f4a2a247589ULL, 0x0008a400000e0000ULL, 0x8000002800000221ULL, 0x100fe20000010000ULL,
0x00000001ffc67807ULL, 0x000fe20000000000ULL, 0x0000002406067220ULL, 0x084fe20000410000ULL,
0x0000002407077220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x0000000000420308ULL, 0x000ea20000000800ULL,
0x000000240f0f7220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x0000002422227220ULL, 0x080fe20000410000ULL,
0x0000002423237220ULL, 0x000fe20000410000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e0028ULL,
0x0000002742270220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0x0000003e273e7221ULL, 0x002fe20000010000ULL,
0x000000f000002947ULL, 0x000fea0003800000ULL, 0x000000085e257812ULL, 0x000fe400078ec0ffULL,
0xfffffff038007812ULL, 0x000fca00078ec0ffULL, 0x0000000100257824ULL, 0x000fca00078e0225ULL,
0x00f6ac0025007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x004fe40003800000ULL,
0x00f6ac0025247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff2b7819ULL, 0x000fe40000011636ULL,
0x00000042ff24723eULL, 0x000fe400000010ffULL, 0x000000182b007810ULL, 0x040fe40007ffe0ffULL,
0x000000102b267810ULL, 0x000fe40007ffe0ffULL, 0x00005410242a7816ULL, 0x010fe20000000024ULL,
0x0000ee527f007947ULL, 0x000fea000b800000ULL, 0x00001f2b2a837589ULL, 0x0002a400000e0000ULL,
0x0000ee927f007947ULL, 0x000fea000b800000ULL, 0x00001f4a2a827589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x002fe200078e0026ULL,
0x00007d2000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0000f6d000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2b7224ULL, 0x002fe200078e0000ULL,
0x00007d8000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0000f67000007944ULL, 0x03cfea0003c00000ULL,
0x0000100002287824ULL, 0x000fe200078e00ffULL, 0x000010006a317812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00009910c6c67816ULL, 0x000fe400000000ffULL,
0xffffe00028287812ULL, 0x000fe400078ec0ffULL, 0x0000b0003c007810ULL, 0x000fc40007ffe031ULL,
0x0000b00028317810ULL, 0x000fc60007ffe031ULL, 0x0000001059247824ULL, 0x100fe400078e0200ULL,
0x0000001058287824ULL, 0x100fe400078e0231ULL, 0x000000105a317824ULL, 0x000fe400078e0231ULL,
0x000000002424783bULL, 0x000f220000004200ULL, 0x000000105b2c7824ULL, 0x002fc600078e0200ULL,
0x000000002828783bULL, 0x014e680000004200ULL, 0x000000003130783bULL, 0x000ea80000004200ULL,
0x000000002c2c783bULL, 0x000f220000004200ULL, 0x0000002400857306ULL, 0x000fe20000009400ULL,
0x00000018ffa37819ULL, 0x000fe20000011424ULL, 0x0000010024957824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe20000011425ULL, 0x0000010028df7824ULL, 0x042fe200078e00ffULL,
0x00000018ffd57819ULL, 0x000fe20000011428ULL, 0x0001000029de7824ULL, 0x040fe200078e00ffULL,
0x00000018ffc97819ULL, 0x000fe20000011429ULL, 0x0000002800d47306ULL, 0x000fe20000009400ULL,
0x00000018ffdf7819ULL, 0x000fe200000114dfULL, 0x0000010029dc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffde7819ULL, 0x000fe200000114deULL, 0x0001000028dd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb67819ULL, 0x004fe20000011430ULL, 0x0001000024aa7824ULL, 0x000fe200078e00ffULL,
0x00000018ffdc7819ULL, 0x000fe200000114dcULL, 0x0000002800d37306ULL, 0x000e620000005400ULL,
0x00000018ffdd7819ULL, 0x000fe200000114ddULL, 0x000001002bca7824ULL, 0x000fe200078e00ffULL,
0x00000018ffac7819ULL, 0x000fe20000011431ULL, 0x000001002ad67824ULL, 0x000fe200078e00ffULL,
0x00000018ffc17819ULL, 0x000fe2000001142aULL, 0x0000010025a47824ULL, 0x040fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x000000df00e67306ULL, 0x000fe20000209400ULL,
0x0001000025af7824ULL, 0x000fe200078e00ffULL, 0x00000018ffd67819ULL, 0x000fe200000114d6ULL,
0x0000010033ed7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe20000011433ULL,
0x0000010032ec7824ULL, 0x000fe200078e00ffULL, 0x00000018ffbf7819ULL, 0x000fe2000001142bULL,
0x0000010026a97824ULL, 0x000fe200078e00ffULL, 0x000000df00e97306ULL, 0x000ea20000205400ULL,
0x000000d3d400720bULL, 0x002fe20003f5d000ULL, 0x0001000030d37824ULL, 0x000fe200078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe20000011432ULL, 0x0000010027847824ULL, 0x000fe200078e00ffULL,
0x00000018ffed7819ULL, 0x000fc400000114edULL, 0x00000018ffd37819ULL, 0x000fe200000114d3ULL,
0x000000d500db7306ULL, 0x000fe20000209400ULL, 0x00000018ff7b7819ULL, 0x000fe40000011426ULL,
0x00000018ff787819ULL, 0x000fe40000011427ULL, 0x00000018ff957819ULL, 0x000fe40000011495ULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x000000d500da7306ULL, 0x000e620000205400ULL,
0x000000e9e600720bULL, 0x004fe20003fdd000ULL, 0x0001000033e97824ULL, 0x000fe200078e00ffULL,
0x00000018ffa97819ULL, 0x000fc400000114a9ULL, 0x00000018ff847819ULL, 0x000fe40000011484ULL,
0x00000018ffe97819ULL, 0x000fe200000114e9ULL, 0x00000028008c7306ULL, 0x0004e2000000d400ULL,
0x00000018ffa47819ULL, 0x000fe400000114a4ULL, 0x00000018ff6b7819ULL, 0x010fe4000001142cULL,
0x00000018ffaf7819ULL, 0x000fe400000114afULL, 0x00000018ff5a7819ULL, 0x000fe2000001142dULL,
0x0000002900d97306ULL, 0x000fe20000009400ULL, 0x000000dadb00720bULL, 0x002fe20003fbd000ULL,
0x000100002b287824ULL, 0x004fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fc4000001142eULL,
0x00000018ff527819ULL, 0x000fe4000001142fULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000002900d87306ULL, 0x000fe20000005400ULL, 0x000000018c8c2812ULL, 0x008fce00078efcffULL,
0x000000de00e77306ULL, 0x000ff00000209400ULL, 0x000000de00e87306ULL, 0x000e700000205400ULL,
0x00000024008a7306ULL, 0x000ff00000005400ULL, 0x00000024006f7306ULL, 0x0005e2000000d400ULL,
0x000000e8e700720bULL, 0x002fce0003f5d000ULL, 0x0000003000c57306ULL, 0x000fe20000009400ULL,
0x0000010030247824ULL, 0x004fca00078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000003000c27306ULL, 0x000ff00000005400ULL, 0x00000030007d7306ULL, 0x0003f0000000d400ULL,
0x000000dc00e47306ULL, 0x000fe20000209400ULL, 0x000000ffff307224ULL, 0x002fe200078e00c6ULL,
0x000000de00c67245ULL, 0x000fc8000020d400ULL, 0x000000ff3000720cULL, 0x000fe20003f65270ULL,
0x0001000031307824ULL, 0x000fe200078e00ffULL, 0x000000dc00e57306ULL, 0x000e620000205400ULL,
0x00000001c6c62812ULL, 0x000fce00078efcffULL, 0x000000c900cd7306ULL, 0x000ff00000209400ULL,
0x000000c900ce7306ULL, 0x0005e20000205400ULL, 0x000000e5e400720bULL, 0x002fce0003f9d000ULL,
0x000000dd00ea7306ULL, 0x000fe20000209400ULL, 0x000000c900c97245ULL, 0x004fce000020d400ULL,
0x000000dd00eb7306ULL, 0x000e700000205400ULL, 0x0000002500917306ULL, 0x000ff00000009400ULL,
0x00000025008e7306ULL, 0x000fe20000005400ULL, 0x000000ebea00720bULL, 0x002fe20003f1d000ULL,
0x0001000032eb7824ULL, 0x000fca00078e00ffULL, 0x00000018ffeb7819ULL, 0x000fe200000114ebULL,
0x0000002500507306ULL, 0x0003f0000000d400ULL, 0x0000003100bd7306ULL, 0x000fe20000009400ULL,
0x0000010031257824ULL, 0x002fca00078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000003100be7306ULL, 0x000ff00000005400ULL, 0x00000031007c7306ULL, 0x0003f0000000d400ULL,
0x0000002900897306ULL, 0x000ea2000000d400ULL, 0x000000df00317245ULL, 0x002fc8000020d400ULL,
0x0000000131316812ULL, 0x000fe400078efcffULL, 0x000000d8d900720bULL, 0x000fe20003fdd000ULL,
0x0000002b00c87306ULL, 0x000fe20000009400ULL, 0x00000018ffd87819ULL, 0x000fe40000011430ULL,
0x000000dd00307245ULL, 0x000fe4000020d400ULL, 0x0000008c318c723eULL, 0x000fe400000010ffULL,
0x0000000130300812ULL, 0x000fe200078efcffULL, 0x0000002b00cb7306ULL, 0x000e680000005400ULL,
0x0000000189896812ULL, 0x004fc800078efcffULL, 0x000000ca00e07306ULL, 0x000ff00000209400ULL,
0x000000ca00e37306ULL, 0x000ea20000205400ULL, 0x000000cbc800720bULL, 0x002fe40003fdd000ULL,
0x000000d600c87245ULL, 0x000fc4000020d400ULL, 0x00000018ffcb7819ULL, 0x000fc600000114ecULL,
0x0000003300b87306ULL, 0x000ff00000009400ULL, 0x0000003300b57306ULL, 0x000fe20000005400ULL,
0x000000e3e000720bULL, 0x004fce0003f5d000ULL, 0x0000003300727306ULL, 0x0003f0000000d400ULL,
0x000000d600e17306ULL, 0x000fe20000209400ULL, 0x000000d500337245ULL, 0x002fc8000020d400ULL,
0x0000000133335812ULL, 0x000fe400078efcffULL, 0x000000cecd00720bULL, 0x000fe20003fbd000ULL,
0x000000d600e27306ULL, 0x000fe20000205400ULL, 0x0001000026cd7824ULL, 0x000fe200078e00ffULL,
0x000000303330723eULL, 0x000fc800000010ffULL, 0x00000018ffcd7819ULL, 0x000fe400000114cdULL,
0x0000002a00cc7306ULL, 0x000fe80000009400ULL, 0x00000001c9c95812ULL, 0x000fc800078efcffULL,
0x0000002a00cf7306ULL, 0x000e620000005400ULL, 0x000000c6c931723eULL, 0x000fce00000010ffULL,
0x000000c100c47306ULL, 0x000ff00000209400ULL, 0x000000c100c77306ULL, 0x0004e20000205400ULL,
0x000000cfcc00720bULL, 0x002fe20003f1d000ULL, 0x0001000027cc7824ULL, 0x000fca00078e00ffULL,
0x00000018ffcc7819ULL, 0x000fe200000114ccULL, 0x0000002a007f7306ULL, 0x000322000000d400ULL,
0x000000c100c17245ULL, 0x004fce000020d400ULL, 0x0000002b007e7306ULL, 0x000ea2000000d400ULL,
0x000100002a2a7824ULL, 0x002fe200078e00ffULL, 0x000000c7c400720bULL, 0x008fe20003fbd000ULL,
0x000100002cc47824ULL, 0x000fe200078e00ffULL, 0x000000ca00c77245ULL, 0x000fe2000020d400ULL,
0x000100002dca7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000003200bb7306ULL, 0x000fe20000009400ULL, 0x00000001c7c72812ULL, 0x000fe400078efcffULL,
0x000000017f7f0812ULL, 0x010fc400078efcffULL, 0x000000c2c500720bULL, 0x000fe20003f1d000ULL,
0x000001002dc57824ULL, 0x000fe200078e00ffULL, 0x00000001c1c15812ULL, 0x000fe200078efcffULL,
0x0000003200bc7306ULL, 0x000fe20000005400ULL, 0x000000017e7e6812ULL, 0x004fe400078efcffULL,
0x0000002a00c27245ULL, 0x000fe4000020d400ULL, 0x00000018ffca7819ULL, 0x000fe400000114caULL,
0x0000007ec7c7723eULL, 0x000fe200000010ffULL, 0x0000003200777306ULL, 0x0003e4000000d400ULL,
0x000000017d7d0812ULL, 0x000fcc00078efcffULL, 0x000000bf00c37306ULL, 0x000fe20000209400ULL,
0x000000dc00327245ULL, 0x002fc8000020d400ULL, 0x0000000132324812ULL, 0x000fe400078efcffULL,
0x000000e2e100720bULL, 0x000fe20003f9d000ULL, 0x000000bf00c07306ULL, 0x000e700000205400ULL,
0x0000002800d17306ULL, 0x000fe80000209400ULL, 0x00000001c8c84812ULL, 0x000fc800078efcffULL,
0x0000002800d27306ULL, 0x000ea20000205400ULL, 0x000000c0c300720bULL, 0x002fe40003fdd000ULL,
0x0000002800c07245ULL, 0x000fe4000020d400ULL, 0x000000bf00c37245ULL, 0x000fe4000020d400ULL,
0x0000007fc8c6723eULL, 0x000fe200000010ffULL, 0x0000002a00d07306ULL, 0x000fec0000209400ULL,
0x00000001c3c36812ULL, 0x000fc400078efcffULL, 0x0000002a00d77306ULL, 0x000e620000205400ULL,
0x000000d2d100720bULL, 0x004fce0003f5d000ULL, 0x00000025002b7306ULL, 0x000fec0000209400ULL,
0x00000001c0c02812ULL, 0x000fe400078efcffULL, 0x0000002500e67306ULL, 0x000ea20000205400ULL,
0x000000d7d000720bULL, 0x002fe40003f9d000ULL, 0x000000bebd00720bULL, 0x000fc40003f5d000ULL,
0x0000002500bd7245ULL, 0x000fe4000020d400ULL, 0x0000002400be7245ULL, 0x000fe2000020d400ULL,
0x000000d300ea7306ULL, 0x000fe20000209400ULL, 0x000000c0c3c3723eULL, 0x000fca00000010ffULL,
0x00000001c2c24812ULL, 0x000fe400078efcffULL, 0x000000d300db7306ULL, 0x0002e20000205400ULL,
0x000000e62b00720bULL, 0x004fe40003fbd000ULL, 0x000000017c7c2812ULL, 0x000fe400078efcffULL,
0x000000b5b800720bULL, 0x000fe20003f5d000ULL, 0x000001002fb57824ULL, 0x000fe200078e00ffULL,
0x000000c2c1c2723eULL, 0x000fe200000010ffULL, 0x0000002400297306ULL, 0x000fe20000209400ULL,
0x000000d300d37245ULL, 0x002fc4000020d400ULL, 0x00000018ffb57819ULL, 0x000fc600000114b5ULL,
0x00000001bdbd5812ULL, 0x000fe400078efcffULL, 0x0000002400d47306ULL, 0x000e620000205400ULL,
0x000000dbea00720bULL, 0x008fe40003fdd000ULL, 0x0000000172722812ULL, 0x000fe400078efcffULL,
0x0000008a8500720bULL, 0x000fe40003f5d000ULL, 0x000000e900857245ULL, 0x000fe2000020d400ULL,
0x000000b600b97306ULL, 0x000fe20000209400ULL, 0x0000009d008a7245ULL, 0x000fca000020d400ULL,
0x00000001d3d36812ULL, 0x000fe400078efcffULL, 0x000000b600ba7306ULL, 0x0004e20000205400ULL,
0x000000d42900720bULL, 0x002fe40003f9d000ULL, 0x000000016f6f2812ULL, 0x000fca00078efcffULL,
0x000000d800d57306ULL, 0x000fe20000209400ULL, 0x000000b600b67245ULL, 0x004fca000020d400ULL,
0x00000001bebe4812ULL, 0x000fe400078efcffULL, 0x000000d800ce7306ULL, 0x000e620000205400ULL,
0x000000bab900720bULL, 0x008fe40003f1d000ULL, 0x000000bcbb00720bULL, 0x000fe20003f9d000ULL,
0x000001002cbc7824ULL, 0x000fc800078e00ffULL, 0x000000ac00b77306ULL, 0x000fec0000209400ULL,
0x00000001b6b60812ULL, 0x000fe400078efcffULL, 0x000000ac00b47306ULL, 0x000ea20000205400ULL,
0x000000ced500720bULL, 0x002fe40003fbd000ULL, 0x0000000177774812ULL, 0x000fc400078efcffULL,
0x000000d3b6b6723eULL, 0x000fc600000010ffULL, 0x00000026009c7306ULL, 0x000ff00000009400ULL,
0x00000026008d7306ULL, 0x000fe20000005400ULL, 0x000000b4b700720bULL, 0x004fe40003fdd000ULL,
0x000000d800b47245ULL, 0x000fc4000020d400ULL, 0x000000ac00b77245ULL, 0x000fe4000020d400ULL,
0x00000001b4b45812ULL, 0x000fe200078efcffULL, 0x0000002600697306ULL, 0x000fe2000000d400ULL,
0x000000cb00ac7245ULL, 0x000fca000020d400ULL, 0x00000001b7b76812ULL, 0x000fe400078efcffULL,
0x0000002700a77306ULL, 0x000fe40000009400ULL, 0x000000b4b7b7723eULL, 0x000fcc00000010ffULL,
0x0000002700907306ULL, 0x000e700000005400ULL, 0x0000002700007306ULL, 0x000eb0000000d400ULL,
0x000000cb00267306ULL, 0x000fe20000209400ULL, 0x00000090a700720bULL, 0x002fc40003f5d000ULL,
0x0000008b00907245ULL, 0x000fca000020d400ULL, 0x000000cb00277306ULL, 0x000e6c0000205400ULL,
0x0000000100002812ULL, 0x004fe400078efcffULL, 0x000000ed002a7306ULL, 0x000ff00000209400ULL,
0x000000ed00297306ULL, 0x000ea20000205400ULL, 0x000000272600720bULL, 0x002fc40003f1d000ULL,
0x00a000004f24783bULL, 0x000e6a0000000200ULL, 0x0000009e00967306ULL, 0x000fec0000209400ULL,
0x00000001acac0812ULL, 0x000fc400078efcffULL, 0x0000009e009b7306ULL, 0x000ee20000205400ULL,
0x000000292a00720bULL, 0x004fe40003fbd000ULL, 0x00a000004c28783bULL, 0x000eaa0000000200ULL,
0x000000e900b87306ULL, 0x000ff00000209400ULL, 0x000000e900b97306ULL, 0x000f220000205400ULL,
0x0000009b9600720bULL, 0x008fc40003fdd000ULL, 0x000000ed009b7245ULL, 0x000fc8000020d400ULL,
0x000000019b9b5812ULL, 0x000fe200078efcffULL, 0x000000eb00bf7306ULL, 0x000fe20000209400ULL,
0x000000832424b231ULL, 0x082fe400003400ffULL, 0x000000729b9b723eULL, 0x000fe200000010ffULL,
0x000000832626b231ULL, 0x000fe400003400ffULL, 0x000000822525b231ULL, 0x080fe400003400ffULL,
0x000000eb00ba7306ULL, 0x000e620000205400ULL, 0x000000b9b800720bULL, 0x010fe20003fbd000ULL,
0x000000822727b231ULL, 0x000fcc00003400ffULL, 0x0000009500937306ULL, 0x000fe20000209400ULL,
0x000000832828b231ULL, 0x084fe400003400ffULL, 0x000000832a2ab231ULL, 0x000fc600003400ffULL,
0x0000000185855812ULL, 0x000fe200078efcffULL, 0x000000822929b231ULL, 0x080fe200003400ffULL,
0x0000009500987306ULL, 0x000ea20000205400ULL, 0x000000babf00720bULL, 0x002fe20003f1d000ULL,
0x000000822b2bb231ULL, 0x000fe200003400ffULL, 0x000000a400837245ULL, 0x000fe4000020d400ULL,
0x00000018ff827819ULL, 0x000fc600000114c5ULL, 0x0000009d00947306ULL, 0x000fe20000209400ULL,
0x000000302808723cULL, 0x040fee0000041808ULL, 0x0000009d009f7306ULL, 0x000e620000205400ULL,
0x000000989300720bULL, 0x004fe20003fbd000ULL, 0x000000c6280c723cULL, 0x000fe2000004180cULL,
0x0000008400937245ULL, 0x000fc4000020d400ULL, 0x0000007b00307245ULL, 0x000fe4000020d400ULL,
0x000000cc00317245ULL, 0x000fe2000020d400ULL, 0x000000aa00ad7306ULL, 0x000fe40000209400ULL,
0x000000c22810723cULL, 0x040fec0000041810ULL, 0x000000aa00b27306ULL, 0x0004e20000205400ULL,
0x0000009f9400720bULL, 0x002fe20003f9d000ULL, 0x000000b62818723cULL, 0x000fe20000041818ULL,
0x000000eb00947245ULL, 0x000fc4000020d400ULL, 0x0000009e009f7245ULL, 0x000fe4000020d400ULL,
0x0000000194940812ULL, 0x000fe200078efcffULL, 0x000000a300a67306ULL, 0x000fe20000209400ULL,
0x0000008e9100720bULL, 0x000fe40003f1d000ULL, 0x00000095008e7245ULL, 0x000fe4000020d400ULL,
0x000000aa00aa7245ULL, 0x004fe4000020d400ULL, 0x000000018e8e5812ULL, 0x000fe200078efcffULL,
0x000000a300977306ULL, 0x0002a20000205400ULL, 0x000000b2ad00720bULL, 0x008fc40003f7d000ULL,
0x000000019f9f6812ULL, 0x000fe400078efcffULL, 0x0000008d9c00720bULL, 0x000fe40003fdd000ULL,
0x00000018ff917819ULL, 0x000fe200000114bcULL, 0x000000a900b17306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fe4000020d400ULL, 0x000000018a8a4812ULL, 0x000fe400078efcffULL,
0x00000089328d723eULL, 0x000fc400000010ffULL, 0x00000001aaaa3812ULL, 0x000fe200078efcffULL,
0x000000a900ae7306ULL, 0x000e620000205400ULL, 0x00000097a600720bULL, 0x004fe40003fbd000ULL,
0x0000000169696812ULL, 0x000fe200078efcffULL, 0x0000008c2804723cULL, 0x000fe20000041804ULL,
0x0000000150500812ULL, 0x000fe400078efcffULL, 0x000000858a85723eULL, 0x000fe200000010ffULL,
0x0000002c008f7306ULL, 0x000fec0000009400ULL, 0x00000001a3a35812ULL, 0x000fc400078efcffULL,
0x0000002c00927306ULL, 0x000ea20000005400ULL, 0x000000aeb100720bULL, 0x002fe40003f7d000ULL,
0x000000aaa3aa723eULL, 0x000fca00000010ffULL, 0x0000008400a07306ULL, 0x000ff00000209400ULL,
0x0000008400a17306ULL, 0x0002e20000205400ULL, 0x000000928f00720bULL, 0x004fe40003fbd000ULL,
0x000000a900927245ULL, 0x000fc4000020d400ULL, 0x00000018ff8f7819ULL, 0x000fe400000114c4ULL,
0x0000000192923812ULL, 0x000fe200078efcffULL, 0x000000a400a87306ULL, 0x000fe20000209400ULL,
0x000000949f84723eULL, 0x002fe400000010ffULL, 0x000000699292723eULL, 0x000fca00000010ffULL,
0x000000a400ab7306ULL, 0x000e620000205400ULL, 0x000000a1a000720bULL, 0x008fe20003f7d000ULL,
0x000000842820723cULL, 0x000fec0000041820ULL, 0x0000002c006d7306ULL, 0x000eac000000d400ULL,
0x0000000193933812ULL, 0x000fc400078efcffULL, 0x0000007b00807306ULL, 0x000fe20000209400ULL,
0x000000aba800720bULL, 0x002fe40003f9d000ULL, 0x000000009393723eULL, 0x000fe400000010ffULL,
0x0000006b00007245ULL, 0x000fc6000020d400ULL, 0x0000007b00817306ULL, 0x000e620000205400ULL,
0x000000016d6d5812ULL, 0x004fe200078efcffULL, 0x00000092240c723cULL, 0x000fe8000004180cULL,
0x0000000183834812ULL, 0x000fe400078efcffULL, 0x000000cd002c7306ULL, 0x000fe40000209400ULL,
0x000000508383723eULL, 0x000fcc00000010ffULL, 0x000000cd00bb7306ULL, 0x0004e20000205400ULL,
0x000000818000720bULL, 0x002fce0003fdd000ULL, 0x000000af00b07306ULL, 0x000fe20000209400ULL,
0x000000cd00cd7245ULL, 0x004fca000020d400ULL, 0x0000000130306812ULL, 0x000fe400078efcffULL,
0x000000af00b37306ULL, 0x0002a20000205400ULL, 0x000000bb2c00720bULL, 0x008fe40003f7d000ULL,
0x0000007dbe2c723eULL, 0x000fca00000010ffULL, 0x0000007800797306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x002fca000020d400ULL, 0x00000001cdcd3812ULL, 0x000fe400078efcffULL,
0x00000078007a7306ULL, 0x0002e20000205400ULL, 0x000000b3b000720bULL, 0x004fe40003f9d000ULL,
0x000000cd3030723eULL, 0x000fca00000010ffULL, 0x0000009100987306ULL, 0x000fe20000209400ULL,
0x0000007800787245ULL, 0x002fca000020d400ULL, 0x00000001afaf4812ULL, 0x000fe400078efcffULL,
0x0000009100957306ULL, 0x000e620000205400ULL, 0x0000007a7900720bULL, 0x008fce0003f7d000ULL,
0x0000002d00a27306ULL, 0x000fec0000009400ULL, 0x0000000178783812ULL, 0x000fe400078efcffULL,
0x0000002d00997306ULL, 0x000ea20000005400ULL, 0x000000959800720bULL, 0x002fce0003fdd000ULL,
0x0000002d00587306ULL, 0x0002f0000000d400ULL, 0x000000cc00967306ULL, 0x000fe20000209400ULL,
0x000001002e2d7824ULL, 0x002fe200078e00ffULL, 0x00000099a200720bULL, 0x004fc80003f9d000ULL,
0x00000018ff7d7819ULL, 0x000fe4000001142dULL, 0x000000cc009d7306ULL, 0x000e620000205400ULL,
0x0000007cbd2d723eULL, 0x000fcc00000010ffULL, 0x0000000158584812ULL, 0x008fe200078efcffULL,
0x0000008b00a57306ULL, 0x000fe20000209400ULL, 0x0000002c2814723cULL, 0x000fee0000041814ULL,
0x0000008b009a7306ULL, 0x000ea20000205400ULL, 0x00000091002c7245ULL, 0x000fc4000020d400ULL,
0x0000009d9600720bULL, 0x002fe40003f5d000ULL, 0x000000012c2c6812ULL, 0x000fe400078efcffULL,
0x00000082002d7245ULL, 0x000fe2000020d400ULL, 0x0000006b00737306ULL, 0x000fe20000209400ULL,
0x0000006d2c2c723eULL, 0x000fce00000010ffULL, 0x0000006b00747306ULL, 0x000e620000205400ULL,
0x0000009aa500720bULL, 0x004fe40003f1d000ULL, 0x00000077ac9a723eULL, 0x000fe400000010ffULL,
0x0000000131312812ULL, 0x000fc600078efcffULL, 0x0000008200977306ULL, 0x000fe20000209400ULL,
0x000000317831723eULL, 0x000fe200000010ffULL, 0x0000009a281c723cULL, 0x000fe8000004181cULL,
0x0000000190900812ULL, 0x000fe400078efcffULL, 0x00000082009c7306ULL, 0x0004e20000205400ULL,
0x000000747300720bULL, 0x002fe20003f7d000ULL, 0x000000302410723cULL, 0x000fe20000041810ULL,
0x000000ca00297245ULL, 0x000fc4000020d400ULL, 0x0000007d002a7245ULL, 0x000fe4000020d400ULL,
0x000000af90ab723eULL, 0x000fe200000010ffULL, 0x0000002f00757306ULL, 0x000fe20000009400ULL,
0x0000006f8e82723eULL, 0x004fca00000010ffULL, 0x0000000100003812ULL, 0x000fe200078efcffULL,
0x000000aa2408723cULL, 0x000fe20000041808ULL, 0x0000002f00767306ULL, 0x000e620000005400ULL,
0x0000009c9700720bULL, 0x008fcc0003fdd000ULL, 0x000000822404723cULL, 0x000fe20000041804ULL,
0x0000005a00717306ULL, 0x000fec0000209400ULL, 0x000000012d2d6812ULL, 0x000fe400078efcffULL,
0x0000005a00707306ULL, 0x0004e20000205400ULL, 0x000000767500720bULL, 0x002fc40003f5d000ULL,
0x000000582d2d723eULL, 0x000fca00000010ffULL, 0x000000ca00337306ULL, 0x000fe20000209400ULL,
0x0000005a005a7245ULL, 0x004fe2000020d400ULL, 0x0000002c2414723cULL, 0x000fec0000041814ULL,
0x000000ca007e7306ULL, 0x000e620000205400ULL, 0x000000707100720bULL, 0x008fce0003fbd000ULL,
0x0000002e00887306ULL, 0x000fec0000009400ULL, 0x000000015a5a5812ULL, 0x000fe400078efcffULL,
0x0000002e00877306ULL, 0x000ea20000005400ULL, 0x0000007e3300720bULL, 0x002fce0003f9d000ULL,
0x0000008f008b7306ULL, 0x000fec0000209400ULL, 0x0000000129294812ULL, 0x000fe400078efcffULL,
0x0000008f00327306ULL, 0x0002e20000205400ULL, 0x000000878800720bULL, 0x004fe40003f1d000ULL,
0x000000295a29723eULL, 0x000fca00000010ffULL, 0x0000007d007b7306ULL, 0x000fe20000209400ULL,
0x0000008f008f7245ULL, 0x002fce000020d400ULL, 0x0000007d007a7306ULL, 0x000e620000205400ULL,
0x000000328b00720bULL, 0x008fce0003fdd000ULL, 0x0000002e00577306ULL, 0x0004ec000000d400ULL,
0x000000018f8f6812ULL, 0x000fe400078efcffULL, 0x0000002f00567306ULL, 0x0008e2000000d400ULL,
0x000100002e2e7824ULL, 0x004fe200078e00ffULL, 0x0000007a7b00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x00000053005b7306ULL, 0x000fe20000209400ULL,
0x000100002f2f7824ULL, 0x010fe200078e00ffULL, 0x0000000157570812ULL, 0x008fc800078efcffULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x00000053006a7306ULL, 0x0002a20000205400ULL,
0x000000012a2a3812ULL, 0x000fe400078efcffULL, 0x0000000156562812ULL, 0x000fe400078efcffULL,
0x000000572a2a723eULL, 0x000fc600000010ffULL, 0x0000005200597306ULL, 0x000fe20000209400ULL,
0x0000005300537245ULL, 0x002fce000020d400ULL, 0x00000052006e7306ULL, 0x0002e20000205400ULL,
0x0000006a5b00720bULL, 0x004fce0003fdd000ULL, 0x000000b500757306ULL, 0x000fe20000209400ULL,
0x0000005200527245ULL, 0x002fca000020d400ULL, 0x0000000153536812ULL, 0x000fe400078efcffULL,
0x000000b500727306ULL, 0x000e620000205400ULL, 0x0000006e5900720bULL, 0x008fce0003f9d000ULL,
0x0000002e00707306ULL, 0x000fec0000209400ULL, 0x0000000152524812ULL, 0x000fe400078efcffULL,
0x0000002e002b7306ULL, 0x0004e20000205400ULL, 0x000000727500720bULL, 0x002fce0003fbd000ULL,
0x0000002f00287306ULL, 0x000fe20000209400ULL, 0x0000002e002e7245ULL, 0x004fce000020d400ULL,
0x0000002f00337306ULL, 0x0002a20000205400ULL, 0x0000002b7000720bULL, 0x008fe40003f7d000ULL,
0x000000b5002b7245ULL, 0x000fc8000020d400ULL, 0x000000012b2b5812ULL, 0x000fe400078efcffULL,
0x0000002f002f7245ULL, 0x002fe4000020d400ULL, 0x000000562b2b723eULL, 0x000fc600000010ffULL,
0x000000012e2e3812ULL, 0x000fe400078efcffULL, 0x000000332800720bULL, 0x004fe40003f1d000ULL,
0x0000008f0028723eULL, 0x000fe200000010ffULL, 0x0000002a241c723cULL, 0x000fe2000004181cULL,
0x0000002e532e723eULL, 0x000fce00000010ffULL, 0x000000282418723cULL, 0x000fe40000041818ULL,
0x000000012f2f0812ULL, 0x000fc800078efcffULL, 0x0000002f522f723eULL, 0x000fce00000010ffULL,
0x0000002e2420723cULL, 0x000fe20000041820ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003f247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c04e4e7810ULL, 0x000fe20007ffe0ffULL,
0x00f698005cff7f8cULL, 0x0007e2000c80043fULL, 0x0000000151527824ULL, 0x000fe200078e026cULL,
0x00000001416b7812ULL, 0x000fe200078e0cffULL, 0x000000ffff697224ULL, 0x000fe200078e0055ULL,
0x000000034e00720cULL, 0x000fda0003f06070ULL, 0x00002c1000000947ULL, 0x000fea0003800000ULL,
0x0000040086007984ULL, 0x008ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003f007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000024003f247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000f6a8432f7811ULL, 0x000fe200078e20ffULL, 0x0000580039267a24ULL, 0x020fe200078e02ffULL,
0x0000030034007a10ULL, 0x000fe20007ffe0ffULL, 0x000000005f0473c2ULL, 0x0004e200000e0000ULL,
0x00000001ff437819ULL, 0x000fe20000011602ULL, 0x0000008026287824ULL, 0x000fe200078e00ffULL,
0x000000085e5e7812ULL, 0x000fc600078ec0ffULL, 0x0000000800247824ULL, 0x040fe200078e0243ULL,
0x0000000100007810ULL, 0x000fc60007ffe0ffULL, 0x0000002024247824ULL, 0x000fe200078e00ffULL,
0x000000370000720cULL, 0x000fc80003f06070ULL, 0x0000002403257217ULL, 0x000fe40007800000ULL,
0x000000603b007812ULL, 0x000fc600078ef824ULL, 0x0000000125257824ULL, 0x000fe400078e0a24ULL,
0x0000001002247824ULL, 0x000fe400078e00ffULL, 0x0000000145457824ULL, 0x100fe200078e0200ULL,
0x0000002025257807ULL, 0x000fe20000000000ULL, 0x0000000147477824ULL, 0x100fe200078e0200ULL,
0x0000001024267812ULL, 0x000fe200078ec0ffULL, 0x0000000149497824ULL, 0x100fe200078e0200ULL,
0x0000004528457210ULL, 0x000fe20007f5e0ffULL, 0x000000014b007824ULL, 0x000fe200078e0200ULL,
0x0000002526257217ULL, 0x000fc40007800000ULL, 0x0000004728477210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x00005e00452c7a11ULL, 0x000fe400078038ffULL,
0x0000004928497210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x0000000028297210ULL, 0x000fe20007f9e0ffULL, 0x0000000125007824ULL, 0x000fe200078e0a26ULL,
0x00000003ff257819ULL, 0x000fe40000011636ULL, 0x00005f00452d7a11ULL, 0x000fe200000f3c24ULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x00005e0047267a11ULL, 0x000fc400078038ffULL,
0x00005e0049287a11ULL, 0x000fe400078438ffULL, 0x0000000825317810ULL, 0x040fe40007ffe0ffULL,
0x0000000425337810ULL, 0x000fe40007ffe0ffULL, 0x00005f0047277a11ULL, 0x000fe400000f3c2aULL,
0x0000004d26267210ULL, 0x000fe40007fbe0ffULL, 0x00005f00492b7a11ULL, 0x000fc400010f3c24ULL,
0x000000003100720cULL, 0x080fe20003f06070ULL, 0x000000ffff277224ULL, 0x000fe200028e0627ULL,
0x0000004d2c247210ULL, 0x000fe20007fde0ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x0000000c25317810ULL, 0x040fe40007ffe0ffULL, 0x000000002500720cULL, 0x080fe20003f66070ULL,
0x000000ffff257224ULL, 0x000fe200030e062dULL, 0x000000003300720cULL, 0x000fe40003f46070ULL,
0x00005e00292a7a11ULL, 0x000fc400078838ffULL, 0x000000003100720cULL, 0x000fe40003fa6070ULL,
0x0000004d28287210ULL, 0x080fe40007fde0ffULL, 0x00005f0029007a11ULL, 0x000fe200020f3c2cULL,
0x000000012f2c7824ULL, 0x000fe200078e025eULL, 0x0000004d2a2a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff297224ULL, 0x000fe200030e062bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024617faeULL, 0x0009e6000d901c46ULL, 0x000000ffff2b7224ULL, 0x000fe200020e0600ULL,
0x0000000026627faeULL, 0x0009e8000d101c46ULL, 0x0000000028637faeULL, 0x0009e8000c101c46ULL,
0x000000002a647faeULL, 0x0009e8000e901c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002c247f8cULL, 0x0104e8000c80043fULL,
0x0000040060297984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f668005d267f8cULL, 0x000fe2000c80043fULL,
0x8000000029ff7812ULL, 0x010fc60007844855ULL, 0x00f66c005d2b7984ULL, 0x000f240000000800ULL,
0x800000002bff7812ULL, 0x010fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x000000ffff697224ULL, 0x008fe200078e0025ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000240000735dULL, 0x010fe20003800000ULL, 0x00f66c005d257984ULL, 0x000ee40000000800ULL,
0x8000000025ff7812ULL, 0x008fc40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001804d257810ULL, 0x000fca0007ffe044ULL, 0x0000000146257824ULL, 0x000fca00078e0225ULL,
0x00f0000025007984ULL, 0x000ee80000000800ULL, 0x00f2000025277984ULL, 0x0008620000000800ULL,
0x0000003d0000720bULL, 0x008fe20003f1d000ULL, 0x0000c7d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x010fc800000e0100ULL, 0x0000ffff24267812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ffa57424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000302257811ULL, 0x000fe400078ff0ffULL,
0x0000003d0000720bULL, 0x000fe40003f14000ULL, 0x000000022500720cULL, 0x000fe20003f65270ULL,
0x0000c7927f007947ULL, 0x000ff4000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x000000003d287209ULL, 0x040fe20007810000ULL, 0x00000080024db824ULL, 0x000fe200078e024dULL,
0x0000ffff24297812ULL, 0x000fe400078e3cffULL, 0x00000002ff2b7819ULL, 0x000fe20000011636ULL,
0x00000001464db824ULL, 0x000fe200078e024dULL, 0x800000283d257221ULL, 0x000fe20000010000ULL,
0x0000002926ff7212ULL, 0x000fc6000780c0ffULL, 0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL,
0x00f400284d00b388ULL, 0x0007e60000000800ULL, 0x00000025002a7308ULL, 0x000f240000000800ULL,
0x0000002a3e3e7220ULL, 0x010fe20000410000ULL, 0x0000c7127f007947ULL, 0x000fea000b800000ULL,
0x00001f2b2a247589ULL, 0x00872400000e0000ULL, 0x0000002404047220ULL, 0x090fe20000410000ULL,
0x0000002405057220ULL, 0x080fe20000410000ULL, 0x0000002408087220ULL, 0x080fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002420207220ULL, 0x080fe20000410000ULL,
0x0000002421217220ULL, 0x000fe20000410000ULL, 0x0000c6527f007947ULL, 0x000fea000b800000ULL,
0x00001f4a2a247589ULL, 0x0008a400000e0000ULL, 0x8000002800000221ULL, 0x100fe20000010000ULL,
0x00000001ffa57807ULL, 0x000fe20000000000ULL, 0x0000002406067220ULL, 0x084fe20000410000ULL,
0x0000002407077220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x0000000000420308ULL, 0x000ea20000000800ULL,
0x000000240f0f7220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x0000002422227220ULL, 0x080fe20000410000ULL,
0x0000002423237220ULL, 0x000fe20000410000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e0028ULL,
0x0000002742270220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000003e273e7221ULL, 0x002fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x0000000841007824ULL, 0x000fe200078e00ffULL,
0xfffffff038257812ULL, 0x000fc800078ec0ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000125247824ULL, 0x000fca00078e0200ULL, 0x00f6ac0024257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804855ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000257305ULL, 0x000364000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000250000735dULL, 0x020fe40003800000ULL, 0x00f6ac0024257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc40007804855ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff2b7819ULL, 0x008fe40000011636ULL, 0x00000042ff24723eULL, 0x000fe400000010ffULL,
0x000000182b007810ULL, 0x040fe40007ffe0ffULL, 0x000000102b267810ULL, 0x000fe40007ffe0ffULL,
0x00005410242a7816ULL, 0x010fe20000000024ULL, 0x0000c3a27f007947ULL, 0x000fea000b800000ULL,
0x00001f2b2a6b7589ULL, 0x0002e400000e0000ULL, 0x0000c3e27f007947ULL, 0x000fea000b800000ULL,
0x00001f4a2a6a7589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0026ULL, 0x0000aa1000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x004fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000c9e000007944ULL, 0x018fea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0000ULL, 0x0000aa7000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x004fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000c98000007944ULL, 0x018fea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006624783bULL, 0x000f680000004200ULL, 0x000000006830783bULL, 0x000f280000004200ULL,
0x000000006728783bULL, 0x016e680000004200ULL, 0x00000000652c783bULL, 0x000ea20000004200ULL,
0x0000010024977824ULL, 0x020fe200078e00ffULL, 0x0000002400ac7306ULL, 0x000fe20000009400ULL,
0x00000018ffc07819ULL, 0x000fe20000011424ULL, 0x0000010027bd7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa77819ULL, 0x000fe20000011425ULL, 0x0000010032d77824ULL, 0x040fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe20000011497ULL, 0x0001000032b67824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011432ULL, 0x0000002400ad7306ULL, 0x000f220000005400ULL,
0x00000018ff5d7819ULL, 0x000fe20000011433ULL, 0x0000010033d87824ULL, 0x000fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe200000114bdULL, 0x0001000026b97824ULL, 0x000fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe20000011426ULL, 0x0001000027b37824ULL, 0x000fe200078e00ffULL,
0x00000018ff967819ULL, 0x000fe20000011427ULL, 0x0000002400707306ULL, 0x000ae2000000d400ULL,
0x00000018ffb97819ULL, 0x000fe200000114b9ULL, 0x000001002a9c7824ULL, 0x042fe200078e00ffULL,
0x00000018ffb37819ULL, 0x000fe200000114b3ULL, 0x000001002b977824ULL, 0x040fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe20000011428ULL, 0x000100002a9e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe20000011429ULL, 0x000000ae00b07306ULL, 0x000fe20000209400ULL,
0x0001000024247824ULL, 0x020fe200078e00ffULL, 0x000000adac00720bULL, 0x010fe20003f1d000ULL,
0x000100002b9a7824ULL, 0x000fe200078e00ffULL, 0x000000c000ad7245ULL, 0x000fe2000020d400ULL,
0x0001000030d67824ULL, 0x000fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe20000011424ULL,
0x0000010025247824ULL, 0x000fe200078e00ffULL, 0x000000ae00b77306ULL, 0x000e620000205400ULL,
0x00000018ff9c7819ULL, 0x000fc4000001149cULL, 0x000000b800ac7245ULL, 0x000fe4000020d400ULL,
0x00000018ffc57819ULL, 0x000fe20000011424ULL, 0x0000010026247824ULL, 0x000fe200078e00ffULL,
0x0000000170700812ULL, 0x008fe200078efcffULL, 0x000000c000c17306ULL, 0x000fe20000209400ULL,
0x00000018ff977819ULL, 0x000fe40000011497ULL, 0x00000018ffcb7819ULL, 0x000fe20000011424ULL,
0x0000010029247824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fc4000001142aULL,
0x00000018ff7e7819ULL, 0x000fe2000001142bULL, 0x000000c000c27306ULL, 0x000ee20000205400ULL,
0x000000b7b000720bULL, 0x002fe20003f5d000ULL, 0x0000010031b77824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000018ff837819ULL, 0x000fe40000011430ULL,
0x00000018ffd77819ULL, 0x000fe200000114d7ULL, 0x0000002500c37306ULL, 0x000fe20000009400ULL,
0x00000018ff9e7819ULL, 0x000fc4000001149eULL, 0x00000018ff9a7819ULL, 0x000fe4000001149aULL,
0x00000018ff527819ULL, 0x004fe4000001142cULL, 0x00000018ffd87819ULL, 0x000fe200000114d8ULL,
0x0000002500c47306ULL, 0x000fe20000005400ULL, 0x000000c2c100720bULL, 0x008fe40003fbd000ULL,
0x00000018ff717819ULL, 0x000fe40000011431ULL, 0x00000018ffb77819ULL, 0x000fc400000114b7ULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x00000025006f7306ULL, 0x0003e2000000d400ULL,
0x00000018ff4a7819ULL, 0x000fe4000001142dULL, 0x00000018ff457819ULL, 0x000fe4000001142eULL,
0x00000018ff447819ULL, 0x000fe4000001142fULL, 0x00000001adad5812ULL, 0x000fe200078efcffULL,
0x000000b800be7306ULL, 0x000fe20000209400ULL, 0x0001000025257824ULL, 0x002fca00078e00ffULL,
0x00000018ffc87819ULL, 0x000fe20000011425ULL, 0x0000010028257824ULL, 0x000fe200078e00ffULL,
0x000000b800bf7306ULL, 0x000e680000205400ULL, 0x00000018ff257819ULL, 0x000fc80000011425ULL,
0x000000c500c67306ULL, 0x000ff00000209400ULL, 0x000000c500c77306ULL, 0x000ea20000205400ULL,
0x000000bfbe00720bULL, 0x002fce0003fdd000ULL, 0x000000c800c97306ULL, 0x000fec0000209400ULL,
0x00000001acac6812ULL, 0x000fe400078efcffULL, 0x000000c800ca7306ULL, 0x000e620000205400ULL,
0x000000c7c600720bULL, 0x004fe40003f9d000ULL, 0x000000acadac723eULL, 0x000fca00000010ffULL,
0x000000a700b47306ULL, 0x000ff00000209400ULL, 0x000000a700b57306ULL, 0x000ea20000205400ULL,
0x000000cac900720bULL, 0x002fce0003f1d000ULL, 0x00000032007d7306ULL, 0x000ff00000009400ULL,
0x0000003200727306ULL, 0x000fe20000005400ULL, 0x000000b5b400720bULL, 0x004fce0003fbd000ULL,
0x0000003200507306ULL, 0x0003f0000000d400ULL, 0x0000003300847306ULL, 0x000fe20000009400ULL,
0x0001000033327824ULL, 0x002fce00078e00ffULL, 0x0000003300777306ULL, 0x000ff00000005400ULL,
0x00000033004d7306ULL, 0x0003f0000000d400ULL, 0x0000002600af7306ULL, 0x000fe20000009400ULL,
0x000000ae00337245ULL, 0x002fc4000020d400ULL, 0x000000c500ae7245ULL, 0x000fe4000020d400ULL,
0x0000000133332812ULL, 0x000fe400078efcffULL, 0x000000c4c300720bULL, 0x000fe20003f5d000ULL,
0x0000002600b27306ULL, 0x000e620000005400ULL, 0x00000001aeae4812ULL, 0x000fe400078efcffULL,
0x000000703370723eULL, 0x000fca00000010ffULL, 0x000000cb00cc7306ULL, 0x000fe80000209400ULL,
0x000000016f6f2812ULL, 0x000fc800078efcffULL, 0x000000cb00cd7306ULL, 0x000ea20000205400ULL,
0x000000b2af00720bULL, 0x002fe40003fdd000ULL, 0x000000c800af7245ULL, 0x000fe4000020d400ULL,
0x000000a700b27245ULL, 0x000fe4000020d400ULL, 0x00000001afaf0812ULL, 0x000fe200078efcffULL,
0x000000bd00d07306ULL, 0x000fe20000209400ULL, 0x00000001b2b25812ULL, 0x000fe400078efcffULL,
0x00000018ffa77819ULL, 0x000fc400000114d6ULL, 0x000000afb2ad723eULL, 0x000fc600000010ffULL,
0x000000bd00d17306ULL, 0x000e620000205400ULL, 0x000000cdcc00720bULL, 0x004fce0003f9d000ULL,
0x0000002700a67306ULL, 0x000ff00000009400ULL, 0x0000002700a37306ULL, 0x000ea20000005400ULL,
0x000000d1d000720bULL, 0x002fce0003f5d000ULL, 0x0000009b009f7306ULL, 0x000ff00000209400ULL,
0x0000009b00a27306ULL, 0x000e620000205400ULL, 0x000000a3a600720bULL, 0x004fe40003f1d000ULL,
0x000000cb00a67245ULL, 0x000fc8000020d400ULL, 0x00000001a6a64812ULL, 0x000fe200078efcffULL,
0x000000b900ce7306ULL, 0x000ff00000209400ULL, 0x000000b900cf7306ULL, 0x000ea20000205400ULL,
0x000000a29f00720bULL, 0x002fc40003fbd000ULL, 0x000000bd009f7245ULL, 0x000fc8000020d400ULL,
0x000000019f9f2812ULL, 0x000fe200078efcffULL, 0x000000b300d27306ULL, 0x000ff00000209400ULL,
0x000000b300d37306ULL, 0x0002e20000205400ULL, 0x000000cfce00720bULL, 0x004fce0003f9d000ULL,
0x0000002600677306ULL, 0x000ea2000000d400ULL, 0x000000b300b37245ULL, 0x002fce000020d400ULL,
0x0000002700667306ULL, 0x000322000000d400ULL, 0x000000d3d200720bULL, 0x008fce0003f5d000ULL,
0x0000009600a07306ULL, 0x000fe20000209400ULL, 0x0001000029277824ULL, 0x002fe200078e00ffULL,
0x0000000167676812ULL, 0x004fc800078efcffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000096009d7306ULL, 0x0002a20000205400ULL, 0x0000000166660812ULL, 0x010fe400078efcffULL,
0x00000001b3b32812ULL, 0x000fe400078efcffULL, 0x000000669f9f723eULL, 0x000fc600000010ffULL,
0x0000002500d47306ULL, 0x000fe20000209400ULL, 0x0000009600967245ULL, 0x002fce000020d400ULL,
0x0000002500d57306ULL, 0x000e620000205400ULL, 0x0000009da000720bULL, 0x004fe40003fdd000ULL,
0x0000009b00a07245ULL, 0x000fe4000020d400ULL, 0x000000b9009d7245ULL, 0x000fe4000020d400ULL,
0x00000001a0a05812ULL, 0x000fe200078efcffULL, 0x0000002800987306ULL, 0x000fe20000009400ULL,
0x000000019d9d4812ULL, 0x000fc800078efcffULL, 0x0000009da0a0723eULL, 0x000fe400000010ffULL,
0x0000000196966812ULL, 0x000fe200078efcffULL, 0x0000002800997306ULL, 0x000ea20000005400ULL,
0x000000d5d400720bULL, 0x002fce0003f1d000ULL, 0x0000002800637306ULL, 0x0002f0000000d400ULL,
0x0000002400bb7306ULL, 0x000fe20000209400ULL, 0x0001000028287824ULL, 0x002fe200078e00ffULL,
0x000000999800720bULL, 0x004fe20003f9d000ULL, 0x000001002d997824ULL, 0x000fc600078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002400bc7306ULL, 0x000e620000205400ULL,
0x00000018ff997819ULL, 0x000fcc0000011499ULL, 0x0000000163634812ULL, 0x008fe200078efcffULL,
0x0000002900957306ULL, 0x000ff00000009400ULL, 0x0000002900947306ULL, 0x000ea20000005400ULL,
0x000000bcbb00720bULL, 0x002fce0003fbd000ULL, 0x0000008d00937306ULL, 0x000ff00000209400ULL,
0x0000008d00927306ULL, 0x0002e20000205400ULL, 0x000000949500720bULL, 0x004fe20003f5d000ULL,
0x000100002c957824ULL, 0x000fe200078e00ffULL, 0x0000002500947245ULL, 0x000fc8000020d400ULL,
0x0000000194940812ULL, 0x000fe200078efcffULL, 0x0000002800b17306ULL, 0x000fe20000209400ULL,
0x0000008d008d7245ULL, 0x002fe4000020d400ULL, 0x00000018ff957819ULL, 0x000fca0000011495ULL,
0x0000002800ba7306ULL, 0x000e620000205400ULL, 0x000000929300720bULL, 0x008fe40003f1d000ULL,
0x0000002400937245ULL, 0x000fc8000020d400ULL, 0x0000000193935812ULL, 0x000fe200078efcffULL,
0x0000002700aa7306ULL, 0x000fec0000209400ULL, 0x000000018d8d0812ULL, 0x000fe400078efcffULL,
0x0000002700ab7306ULL, 0x000ea20000205400ULL, 0x000000bab100720bULL, 0x002fce0003fdd000ULL,
0x0000002a00907306ULL, 0x000ff00000009400ULL, 0x0000002a00917306ULL, 0x000e620000005400ULL,
0x000000abaa00720bULL, 0x004fe20003fbd000ULL, 0x000001002eaa7824ULL, 0x000fc400078e00ffULL,
0x000001002fab7824ULL, 0x000fc600078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x0000008a008c7306ULL, 0x000fe20000209400ULL, 0x00000018ffab7819ULL, 0x000fce00000114abULL,
0x0000008a008b7306ULL, 0x000ea20000205400ULL, 0x000000919000720bULL, 0x002fe40003f9d000ULL,
0x0000002800907245ULL, 0x000fc8000020d400ULL, 0x0000000190906812ULL, 0x000fe200078efcffULL,
0x0000002900627306ULL, 0x000e70000000d400ULL, 0x0000002a005f7306ULL, 0x000ee2000000d400ULL,
0x0000008b8c00720bULL, 0x004fc40003fdd000ULL, 0x00000027008b7245ULL, 0x000fc8000020d400ULL,
0x000000018b8b5812ULL, 0x000fe200078efcffULL, 0x0000002b008f7306ULL, 0x000fe20000009400ULL,
0x0000000162622812ULL, 0x002fc800078efcffULL, 0x000000629393723eULL, 0x000fc600000010ffULL,
0x0000002b008e7306ULL, 0x000e620000005400ULL, 0x000000015f5f4812ULL, 0x008fce00078efcffULL,
0x0000002b00587306ULL, 0x0004f0000000d400ULL, 0x0000009c00297306ULL, 0x000fe20000209400ULL,
0x00009910a52b7816ULL, 0x004fe400000000ffULL, 0x0000008e8f00720bULL, 0x002fe20003f5d000ULL,
0x000001002c8e7824ULL, 0x000fe200078e00ffULL, 0x000000ff2b00720cULL, 0x000fe20003f65270ULL,
0x00000100302b7824ULL, 0x000fc400078e00ffULL, 0x0000009c00267306ULL, 0x0002a20000205400ULL,
0x00000018ff8e7819ULL, 0x000fce000001148eULL, 0x0000009700a97306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fe4000020d400ULL, 0x0000000158582812ULL, 0x008fca00078efcffULL,
0x00000097002a7306ULL, 0x0002e20000205400ULL, 0x000000262900720bULL, 0x004fe40003f1d000ULL,
0x00a800004c24783bULL, 0x00052a0000000200ULL, 0x0000003000757306ULL, 0x000fe20000009400ULL,
0x0000009700977245ULL, 0x002fe4000020d400ULL, 0x00000083004c7245ULL, 0x004fc6000020d400ULL,
0x000000019c9c0812ULL, 0x000fe400078efcffULL, 0x0000003000807306ULL, 0x000e620000005400ULL,
0x0000002aa900720bULL, 0x008fe20003fbd000ULL, 0x000100002da97824ULL, 0x000fca00078e00ffULL,
0x00000018ffa97819ULL, 0x000fe200000114a9ULL, 0x0000003000577306ULL, 0x0004ec000000d400ULL,
0x0000000197975812ULL, 0x000fe400078efcffULL, 0x000000a700a37306ULL, 0x000fe20000209400ULL,
0x00000018ff307819ULL, 0x004fe2000001142bULL, 0x00010000312b7824ULL, 0x000fe200078e00ffULL,
0x000000807500720bULL, 0x002fc40003f5d000ULL, 0x000000589797723eULL, 0x000fe400000010ffULL,
0x00000018ffb47819ULL, 0x000fe2000001142bULL, 0x000000a700a27306ULL, 0x0002a20000205400ULL,
0x00a800004f28783bULL, 0x000aa20000000200ULL, 0x0000006b2424b231ULL, 0x090fe400003400ffULL,
0x0000006b2626b231ULL, 0x000fe400003400ffULL, 0x0000006a2525b231ULL, 0x080fe400003400ffULL,
0x0000008100887306ULL, 0x000fe20000209400ULL, 0x0000006a2727b231ULL, 0x000fe200003400ffULL,
0x000000a700a77245ULL, 0x002fc4000020d400ULL, 0x0000007e004f7245ULL, 0x020fe4000020d400ULL,
0x0000000157572812ULL, 0x008fe400078efcffULL, 0x0000008100897306ULL, 0x000fe20000205400ULL,
0x000000778400720bULL, 0x000fe20003f5d000ULL, 0x000000ac2408723cULL, 0x000fec0000041808ULL,
0x000000d700927306ULL, 0x000fec0000209400ULL, 0x000000014d4d2812ULL, 0x000fc400078efcffULL,
0x000000d7008f7306ULL, 0x0002f00000205400ULL, 0x0000007e00787306ULL, 0x000fe20000209400ULL,
0x0000006b2828b231ULL, 0x084fe200003400ffULL, 0x000000d700d77245ULL, 0x002fe2000020d400ULL,
0x0000006b2a2ab231ULL, 0x000fe200003400ffULL, 0x00000071006b7245ULL, 0x000fe2000020d400ULL,
0x0000006a2929b231ULL, 0x000fc400003400ffULL, 0x0000006a2b2bb231ULL, 0x000fe200003400ffULL,
0x000000a2a300720bULL, 0x000fe20003f7d000ULL, 0x0000007e007f7306ULL, 0x000e700000205400ULL,
0x0000002c00747306ULL, 0x000fe80000009400ULL, 0x00000001a7a73812ULL, 0x000fc400078efcffULL,
0x0000008f9200720bULL, 0x008fe40003f7d000ULL, 0x0000002c00797306ULL, 0x000fe20000005400ULL,
0x0000007f7800720bULL, 0x002fe40003f9d000ULL, 0x00000018ff787819ULL, 0x000fe40000011432ULL,
0x0000008100327245ULL, 0x000fe4000020d400ULL, 0x000000639492723eULL, 0x000fe200000010ffULL,
0x0000002c00537306ULL, 0x0003e2000000d400ULL, 0x0000006400637245ULL, 0x000fc4000020d400ULL,
0x00000001d7d73812ULL, 0x000fe400078efcffULL, 0x00000099008f7245ULL, 0x000fe2000020d400ULL,
0x000000922414723cULL, 0x000fe20000041814ULL, 0x000000014f4f4812ULL, 0x000fe200078efcffULL,
0x0000009e00a17306ULL, 0x000fe20000209400ULL, 0x0000008a002c7245ULL, 0x002fc8000020d400ULL,
0x000000012c2c6812ULL, 0x000fe400078efcffULL, 0x000000898800720bULL, 0x000fe20003fdd000ULL,
0x0000009e00a47306ULL, 0x000e620000205400ULL, 0x0000008b2c8b723eULL, 0x000fe400000010ffULL,
0x0000005d002c7245ULL, 0x000fca000020d400ULL, 0x0000009a00a57306ULL, 0x000fe80000209400ULL,
0x0000000132326812ULL, 0x000fe400078efcffULL, 0x000000727d00720bULL, 0x000fe40003fdd000ULL,
0x0000009a00a87306ULL, 0x0004e20000205400ULL, 0x000000a4a100720bULL, 0x002fe40003f1d000ULL,
0x000000b396a1723eULL, 0x000fc400000010ffULL, 0x0000005f9c96723eULL, 0x000fc600000010ffULL,
0x000000d8008c7306ULL, 0x000fe20000209400ULL, 0x0000009a009a7245ULL, 0x004fe2000020d400ULL,
0x000000a02410723cULL, 0x000fe20000041810ULL, 0x0000000150506812ULL, 0x000fca00078efcffULL,
0x000000d800917306ULL, 0x0002a20000205400ULL, 0x000000a8a500720bULL, 0x008fe20003fbd000ULL,
0x00000096241c723cULL, 0x000fec000004181cULL, 0x0000003100767306ULL, 0x000fe20000009400ULL,
0x000000d800d87245ULL, 0x002fca000020d400ULL, 0x000000019a9a5812ULL, 0x000fe400078efcffULL,
0x0000003100737306ULL, 0x000fe20000005400ULL, 0x000000918c00720bULL, 0x004fe40003f7d000ULL,
0x0000009a4f33723eULL, 0x000fca00000010ffULL, 0x0000003100007306ULL, 0x000fec000000d400ULL,
0x00000001d8d83812ULL, 0x000fe400078efcffULL, 0x0000003000317306ULL, 0x000fe40000209400ULL,
0x0000004dd84d723eULL, 0x000fcc00000010ffULL, 0x0000003000b07306ULL, 0x0002b00000205400ULL,
0x0000006400687306ULL, 0x000fe20000209400ULL, 0x0000003000307245ULL, 0x002fce000020d400ULL,
0x0000006400657306ULL, 0x000e620000205400ULL, 0x000000b03100720bULL, 0x004fe40003fbd000ULL,
0x000000b700317245ULL, 0x000fca000020d400ULL, 0x000000b700b87306ULL, 0x000fec0000209400ULL,
0x0000000130305812ULL, 0x000fe400078efcffULL, 0x000000b700b57306ULL, 0x0004e20000205400ULL,
0x000000656800720bULL, 0x002fe40003fdd000ULL, 0x000000573030723eULL, 0x000fca00000010ffULL,
0x000000b6008a7306ULL, 0x000fe20000209400ULL, 0x0000007800b77245ULL, 0x004fca000020d400ULL,
0x0000000163636812ULL, 0x000fe400078efcffULL, 0x000000b600897306ULL, 0x0002a20000205400ULL,
0x000000b5b800720bULL, 0x008fce0003f9d000ULL, 0x0000002d00827306ULL, 0x000fe20000009400ULL,
0x000000b600b67245ULL, 0x002fca000020d400ULL, 0x0000000131314812ULL, 0x000fe400078efcffULL,
0x0000002d007b7306ULL, 0x000fe20000005400ULL, 0x000000898a00720bULL, 0x004fe40003f7d000ULL,
0x000000908d8a723eULL, 0x000fca00000010ffULL, 0x0000002d00487306ULL, 0x0003e4000000d400ULL,
0x0000008a2418723cULL, 0x000fe80000041818ULL, 0x00000001b6b63812ULL, 0x000fe400078efcffULL,
0x0000008300877306ULL, 0x000fe20000209400ULL, 0x0000009e002d7245ULL, 0x002fe4000020d400ULL,
0x00000067a69e723eULL, 0x000fc400000010ffULL, 0x000000012d2d0812ULL, 0x000fe400078efcffULL,
0x000000737600720bULL, 0x000fe20003f1d000ULL, 0x00000083007a7306ULL, 0x000e620000205400ULL,
0x0000002d3232723eULL, 0x000fe200000010ffULL, 0x0000009e240c723cULL, 0x000fe2000004180cULL,
0x000000b663b6723eULL, 0x000fca00000010ffULL, 0x0000007100857306ULL, 0x000fe40000209400ULL,
0x000000322420723cULL, 0x000fe40000041820ULL, 0x0000000100000812ULL, 0x000fc800078efcffULL,
0x00000071007c7306ULL, 0x0004e20000205400ULL, 0x0000007a8700720bULL, 0x002fe40003fbd000ULL,
0x000000003131723eULL, 0x000fca00000010ffULL, 0x0000005d00617306ULL, 0x000fe20000209400ULL,
0x0000006fae71723eULL, 0x004fca00000010ffULL, 0x000000014c4c5812ULL, 0x000fe400078efcffULL,
0x0000005d00607306ULL, 0x000e620000205400ULL, 0x0000007c8500720bULL, 0x008fe20003f1d000ULL,
0x000000702404723cULL, 0x000fe20000041804ULL, 0x000000797400720bULL, 0x000fca0003fbd000ULL,
0x000000b4009b7306ULL, 0x000fe20000209400ULL, 0x000000a74c24723eULL, 0x000fe400000010ffULL,
0x00000050d74c723eULL, 0x000fc600000010ffULL, 0x000000016b6b0812ULL, 0x000fe400078efcffULL,
0x000000b400987306ULL, 0x0004e20000205400ULL, 0x000000606100720bULL, 0x002fe20003f7d000ULL,
0x0000004c280c723cULL, 0x000fe2000004180cULL, 0x0000000153535812ULL, 0x000fca00078efcffULL,
0x0000008e00737306ULL, 0x000fe20000209400ULL, 0x000000b400b47245ULL, 0x004fe2000020d400ULL,
0x000000302804723cULL, 0x000fe80000041804ULL, 0x000000012c2c3812ULL, 0x000fe400078efcffULL,
0x0000008e006a7306ULL, 0x0002a20000205400ULL, 0x000000989b00720bULL, 0x008fce0003f9d000ULL,
0x0000002e006e7306ULL, 0x000fe20000009400ULL, 0x0000008e008e7245ULL, 0x002fca000020d400ULL,
0x00000001b4b44812ULL, 0x000fe400078efcffULL, 0x0000002e006d7306ULL, 0x000e620000005400ULL,
0x0000006a7300720bULL, 0x004fe40003fdd000ULL, 0x0000007b8200720bULL, 0x000fe40003f9d000ULL,
0x000000b46b25723eULL, 0x000fc600000010ffULL, 0x0000007800757306ULL, 0x000fe80000209400ULL,
0x000000242808723cULL, 0x000fe40000041808ULL, 0x000000018e8e6812ULL, 0x000fe400078efcffULL,
0x0000007800727306ULL, 0x000ea20000205400ULL, 0x0000006d6e00720bULL, 0x002fe40003f1d000ULL,
0x0000000148484812ULL, 0x000fc400078efcffULL, 0x000000538e8e723eULL, 0x000fc600000010ffULL,
0x0000005200597306ULL, 0x000ff00000209400ULL, 0x00000052005a7306ULL, 0x0002e20000205400ULL,
0x000000727500720bULL, 0x004fce0003f5d000ULL, 0x0000009900767306ULL, 0x000fe20000209400ULL,
0x0000005200527245ULL, 0x002fca000020d400ULL, 0x00000001b7b72812ULL, 0x000fe400078efcffULL,
0x0000009900777306ULL, 0x000e620000205400ULL, 0x0000005a5900720bULL, 0x008fe40003f7d000ULL,
0x000000b72cb7723eULL, 0x000fca00000010ffULL, 0x0000002f005e7306ULL, 0x000fe40000009400ULL,
0x000000b62810723cULL, 0x000fe80000041810ULL, 0x0000000152523812ULL, 0x000fe400078efcffULL,
0x0000002f005b7306ULL, 0x000ea20000005400ULL, 0x000000777600720bULL, 0x002fce0003fdd000ULL,
0x0000004a00567306ULL, 0x000fec0000209400ULL, 0x000000018f8f6812ULL, 0x000fe400078efcffULL,
0x0000004a00557306ULL, 0x0002e20000205400ULL, 0x0000005b5e00720bULL, 0x004fe40003f5d000ULL,
0x000000488f8f723eULL, 0x000fca00000010ffULL, 0x0000009500747306ULL, 0x000fe20000209400ULL,
0x0000004a004a7245ULL, 0x002fe2000020d400ULL, 0x0000008e2814723cULL, 0x000fec0000041814ULL,
0x00000095006d7306ULL, 0x0002a20000205400ULL, 0x000000555600720bULL, 0x008fce0003fbd000ULL,
0x000000a900657306ULL, 0x000fe20000209400ULL, 0x0000009500957245ULL, 0x002fca000020d400ULL,
0x000000014a4a5812ULL, 0x000fe400078efcffULL, 0x000000a900667306ULL, 0x0002e20000205400ULL,
0x0000006d7400720bULL, 0x004fce0003fdd000ULL, 0x000000aa00627306ULL, 0x000fe20000209400ULL,
0x000000a900a97245ULL, 0x002fca000020d400ULL, 0x0000000195956812ULL, 0x000fe400078efcffULL,
0x000000aa00617306ULL, 0x0002a20000205400ULL, 0x000000666500720bULL, 0x008fe40003f9d000ULL,
0x000000955252723eULL, 0x000fca00000010ffULL, 0x0000002e00477306ULL, 0x000722000000d400ULL,
0x000000aa00aa7245ULL, 0x002fca000020d400ULL, 0x00000001a9a94812ULL, 0x000fe400078efcffULL,
0x0000002f00467306ULL, 0x000362000000d400ULL, 0x000100002e2e7824ULL, 0x008fe200078e00ffULL,
0x000000616200720bULL, 0x004fe40003f7d000ULL, 0x000000a94a53723eULL, 0x000fe400000010ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x00000045004b7306ULL, 0x000fe20000209400ULL,
0x000100002f2f7824ULL, 0x002fe200078e00ffULL, 0x0000000147470812ULL, 0x010fe200078efcffULL,
0x000000522818723cULL, 0x000fe60000041818ULL, 0x00000018ff2f7819ULL, 0x000fc4000001142fULL,
0x00000045004e7306ULL, 0x0002a20000205400ULL, 0x00000001aaaa3812ULL, 0x000fe400078efcffULL,
0x0000000146462812ULL, 0x020fe400078efcffULL, 0x00000047aaaa723eULL, 0x000fc600000010ffULL,
0x0000004400497306ULL, 0x000fe20000209400ULL, 0x0000004500457245ULL, 0x002fce000020d400ULL,
0x0000004400547306ULL, 0x0002e20000205400ULL, 0x0000004e4b00720bULL, 0x004fce0003fdd000ULL,
0x000000ab005b7306ULL, 0x000fe20000209400ULL, 0x0000004400447245ULL, 0x002fca000020d400ULL,
0x0000000145456812ULL, 0x000fe400078efcffULL, 0x000000ab00587306ULL, 0x0002a20000205400ULL,
0x000000544900720bULL, 0x008fce0003f9d000ULL, 0x0000002e002d7306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x002fca000020d400ULL, 0x0000000144444812ULL, 0x000fe400078efcffULL,
0x0000002e00007306ULL, 0x0002e20000205400ULL, 0x000000585b00720bULL, 0x004fce0003fbd000ULL,
0x0000002f00267306ULL, 0x000fe20000209400ULL, 0x0000002e002e7245ULL, 0x002fca000020d400ULL,
0x00000001abab5812ULL, 0x000fe400078efcffULL, 0x0000002f00257306ULL, 0x0002a20000205400ULL,
0x000000002d00720bULL, 0x008fe40003f7d000ULL, 0x00000046abab723eULL, 0x000fe400000010ffULL,
0x0000002f002f7245ULL, 0x002fca000020d400ULL, 0x000000aa281c723cULL, 0x000fe8000004181cULL,
0x000000012e2e3812ULL, 0x000fe400078efcffULL, 0x000000252600720bULL, 0x004fe40003f1d000ULL,
0x0000002e452e723eULL, 0x000fd600000010ffULL, 0x000000012f2f0812ULL, 0x000fc800078efcffULL,
0x0000002f442f723eULL, 0x000fce00000010ffULL, 0x0000002e2820723cULL, 0x000fe20000041820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020003f247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a0005cff7f8cULL, 0x0007e2000c80043fULL, 0x0000000151527824ULL, 0x000fe200078e026cULL,
0x00000001416b7812ULL, 0x000fe400078ec0ffULL, 0x0000030034347a10ULL, 0x008fc80007ffe0ffULL,
0x000000373400720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff461000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x004ea20000002500ULL,
0x000000ffff317224ULL, 0x000fe400078e0023ULL, 0x000000ffff327224ULL, 0x000fe400078e0022ULL,
0x000000ffff2d7224ULL, 0x000fe400078e001fULL, 0x000000ffff2b7224ULL, 0x000fe400078e001cULL,
0x000000ffff307224ULL, 0x000fe400078e0021ULL, 0x000000ffff2f7224ULL, 0x000fc400078e0020ULL,
0x000000ffff2e7224ULL, 0x000fe400078e001eULL, 0x000000ffff2c7224ULL, 0x000fe400078e001dULL,
0x000000ffff297224ULL, 0x000fe400078e001bULL, 0x000000ffff2a7224ULL, 0x000fe400078e001aULL,
0x000000ffff287224ULL, 0x000fe400078e0019ULL, 0x000000ffff277224ULL, 0x008fe200078e0018ULL,
0x0000000437007c0cULL, 0x004fe2000bf03070ULL, 0x000000ffff267224ULL, 0x000fc400078e0016ULL,
0x000000ffff237224ULL, 0x000fe400078e0014ULL, 0x000000ffff227224ULL, 0x000fe400078e0012ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0010ULL, 0x000000ffff1c7224ULL, 0x000fe400078e000eULL,
0x000000ffff257224ULL, 0x000fe400078e0017ULL, 0x000000ffff247224ULL, 0x000fc400078e0015ULL,
0x000000ffff217224ULL, 0x000fe400078e0013ULL, 0x000000ffff207224ULL, 0x000fe400078e0011ULL,
0x000000ffff1e7224ULL, 0x000fe400078e000fULL, 0x000000ffff187224ULL, 0x000fe400078e000dULL,
0x000000ffff1d7224ULL, 0x000fe400078e000cULL, 0x000000ffff1a7224ULL, 0x000fc400078e000bULL,
0x000000ffff167224ULL, 0x000fe400078e000aULL, 0x000000ffff147224ULL, 0x000fe400078e0009ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0008ULL, 0x000000ffff127224ULL, 0x000fe400078e0007ULL,
0x000000ffff107224ULL, 0x000fe400078e0006ULL, 0x000000ffff0e7224ULL, 0x000fc400078e0005ULL,
0x000000ffff197224ULL, 0x000fe200078e0004ULL, 0x0000037000000947ULL, 0x000fea0003800000ULL,
0x018000003e007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000cb5000067802ULL, 0x000fe40000000f00ULL,
0x0000a6f000007944ULL, 0x022fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003e00037308ULL, 0x000ea40000001000ULL, 0xbf80000003007423ULL, 0x004fc8000000003eULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff057624ULL, 0x000fe400078e00ffULL,
0x00006800ff047624ULL, 0x000fca00078e00ffULL, 0x0000000604057981ULL, 0x000f28000c1e9900ULL,
0x0000000000037919ULL, 0x000ee80000000000ULL, 0x0000000000087919ULL, 0x000ea20000000000ULL,
0x00000002ff077819ULL, 0x008fe40000011603ULL, 0x0000000808037811ULL, 0x004fe200078ff0ffULL,
0x0000000005067220ULL, 0x010fca0000410000ULL, 0x00001f0706007589ULL, 0x000ea800000e0000ULL,
0x00001f0306037589ULL, 0x000ee200000e0000ULL, 0x0000001900197220ULL, 0x044fe20000410000ULL,
0x0000000e000e7220ULL, 0x040fe20000410000ULL, 0x0000001b001b7220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001f001f7220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002300237220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002700277220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002b002b7220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002f002f7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x000fe20000410000ULL, 0x0000001003107220ULL, 0x048fe20000410000ULL,
0x0000001203127220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000001c031c7220ULL, 0x040fe20000410000ULL,
0x0000001e031e7220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002103217220ULL, 0x040fe20000410000ULL, 0x0000002603267220ULL, 0x040fe20000410000ULL,
0x0000002503257220ULL, 0x040fe20000410000ULL, 0x0000002a032a7220ULL, 0x040fe20000410000ULL,
0x0000002903297220ULL, 0x040fe20000410000ULL, 0x0000002e032e7220ULL, 0x040fe20000410000ULL,
0x0000002d032d7220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000003103317220ULL, 0x000fe20000410000ULL, 0x0000000000007919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000200037812ULL, 0x004fc400078ec0ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011600ULL, 0x00000001ff047819ULL, 0x000fe40000011603ULL,
0x0000000403087811ULL, 0x040fe400078ff8ffULL, 0x0000000800177811ULL, 0x000fe400078ff0ffULL,
0x0000000203057811ULL, 0x040fe400078ff8ffULL, 0x00000006030b7811ULL, 0x000fc400078ff8ffULL,
0x0000000704037812ULL, 0x100fe400078e780fULL, 0x00000007080a7812ULL, 0x040fe400078e780fULL,
0x0000000708087812ULL, 0x000fe200078e7817ULL, 0x000000080f077824ULL, 0x000fe200078e0203ULL,
0x0000000704047812ULL, 0x000fe200078e7817ULL, 0x000010003a037824ULL, 0x000fe200078e00ffULL,
0x0000000705067812ULL, 0x100fe200078e780fULL, 0x0000000817157824ULL, 0x000fe200078e0208ULL,
0x000000070b0c7812ULL, 0x000fe200078e780fULL, 0x0000000800087824ULL, 0x000fe200078e00ffULL,
0x0000000705057812ULL, 0x100fe200078e7817ULL, 0x0000000817117824ULL, 0x000fe200078e0204ULL,
0x000000070b0b7812ULL, 0x000fe200078e7817ULL, 0x0000080043047824ULL, 0x000fe200078e0203ULL,
0x0000000808087812ULL, 0x000fe200078ec0ffULL, 0x000000080f097824ULL, 0x040fe200078e0206ULL,
0x0000001b1406723eULL, 0x000fe200000010ffULL, 0x000000080f0d7824ULL, 0x000fc400078e020aULL,
0x0000000817137824ULL, 0x000fe200078e0205ULL, 0x000000190e05723eULL, 0x000fe200000010ffULL,
0x000000080f0f7824ULL, 0x000fe400078e020cULL, 0x0000000817177824ULL, 0x000fe200078e020bULL,
0x0000763205197816ULL, 0x000fe20000000006ULL, 0x0000001007077824ULL, 0x100fe400078e0204ULL,
0x00000010090b7824ULL, 0x100fe400078e0204ULL, 0x000000100d0d7824ULL, 0x000fc400078e0204ULL,
0x0000001011117824ULL, 0x100fe400078e0204ULL, 0x0000001013137824ULL, 0x100fe400078e0204ULL,
0x000000100f0f7824ULL, 0x100fe400078e0204ULL, 0x0000001015157824ULL, 0x100fe400078e0204ULL,
0x0000001017177824ULL, 0x000fe400078e0204ULL, 0x0000000107097824ULL, 0x000fe200078e0208ULL,
0x0000001d1807723eULL, 0x000fe200000010ffULL, 0x00000001080b7824ULL, 0x040fe200078e020bULL,
0x0000541005187816ULL, 0x000fe20000000006ULL, 0x00000001080d7824ULL, 0x000fe200078e020dULL,
0x000000232405723eULL, 0x000fe200000010ffULL, 0x0000000108117824ULL, 0x000fe200078e0211ULL,
0x000000272806723eULL, 0x000fe200000010ffULL, 0x0000000108137824ULL, 0x040fe200078e0213ULL,
0x0000001809007388ULL, 0x0005e20000000a00ULL, 0x00000001080f7824ULL, 0x040fe200078e020fULL,
0x00005410050a7816ULL, 0x000fe20000000006ULL, 0x0000000108157824ULL, 0x000fc400078e0215ULL,
0x0000000108177824ULL, 0x000fe200078e0217ULL, 0x0000001f2008723eULL, 0x000fc800000010ffULL,
0x0000541007187816ULL, 0x004fe20000000008ULL, 0x0000002043097824ULL, 0x000fe200078e0200ULL,
0x0000763207197816ULL, 0x000fe40000000008ULL, 0x0000002b2c07723eULL, 0x000fe200000010ffULL,
0x00000010090c7824ULL, 0x000fe200078e0203ULL, 0x0000002f3008723eULL, 0x000fe200000010ffULL,
0x000000180b007388ULL, 0x0005e40000000a00ULL, 0x00007632050b7816ULL, 0x004fe40000000006ULL,
0x000000101205723eULL, 0x000fc400000010ffULL, 0x000000161a06723eULL, 0x000fe200000010ffULL,
0x0000000a0d007388ULL, 0x0005e40000000a00ULL, 0x00005410070a7816ULL, 0x144fe40000000008ULL,
0x00007632070b7816ULL, 0x000fe40000000008ULL, 0x0000001c1e07723eULL, 0x000fe400000010ffULL,
0x000000222108723eULL, 0x000fe200000010ffULL, 0x0000000a0f007388ULL, 0x0005e40000000a00ULL,
0x00005410050a7816ULL, 0x004fc40000000006ULL, 0x00007632050b7816ULL, 0x000fe40000000006ULL,
0x000000262505723eULL, 0x000fe400000010ffULL, 0x0000002a2906723eULL, 0x000fe200000010ffULL,
0x0000000a11007388ULL, 0x0005e40000000a00ULL, 0x00005410070a7816ULL, 0x144fe40000000008ULL,
0x00007632070b7816ULL, 0x000fe40000000008ULL, 0x0000002e2d07723eULL, 0x000fc400000010ffULL,
0x000000323108723eULL, 0x000fe200000010ffULL, 0x0000000a13007388ULL, 0x0005e40000000a00ULL,
0x00005410050a7816ULL, 0x144fe40000000006ULL, 0x00007632050b7816ULL, 0x000fe40000000006ULL,
0x000000ff00057306ULL, 0x000fe60000205400ULL, 0x0000000a15007388ULL, 0x0005ea0000000a00ULL,
0x000000ff00067306ULL, 0x000ee20000209400ULL, 0x00005410070a7816ULL, 0x004fc40000000008ULL,
0x00007632070b7816ULL, 0x000fca0000000008ULL, 0x0000000a17007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000050600720bULL, 0x008fe40003f1d000ULL,
0x000000ff00057245ULL, 0x000fd6000020d400ULL, 0x0000000105050812ULL, 0x000fc800078efcffULL,
0x000000050508723eULL, 0x000fe200000010ffULL, 0x000000000c107984ULL, 0x000ea80000000c00ULL,
0x000800000c187984ULL, 0x000ee80000000c00ULL, 0x000400000c1c7984ULL, 0x000f280000000c00ULL,
0x000c00000c207984ULL, 0x000e620000000c00ULL, 0x3f803f8008107831ULL, 0x004fc40000200010ULL,
0x3f803f8008137831ULL, 0x000fe40000200013ULL, 0x3f803f8010107831ULL, 0x008fe20000200018ULL,
0x00000300ff187624ULL, 0x000fe200078e00ffULL, 0x3f803f8008127831ULL, 0x040fe40000200012ULL,
0x3f803f8008117831ULL, 0x040fe40000200011ULL, 0x000000011800780cULL, 0x000fe20003f05270ULL,
0x3f803f80081f7831ULL, 0x050fe4000020001fULL, 0x3f803f80081e7831ULL, 0x000fc4000020001eULL,
0x3f803f80081d7831ULL, 0x040fe4000020001dULL, 0x3f803f80081c7831ULL, 0x000fe4000020001cULL,
0x3f803f8013137831ULL, 0x000fe4000020001bULL, 0x3f803f8012127831ULL, 0x000fe4000020001aULL,
0x3f803f8011117831ULL, 0x000fe40000200019ULL, 0x3f803f801f1f7831ULL, 0x002fc40000200023ULL,
0x3f803f801e1e7831ULL, 0x000fe20000200022ULL, 0x000000100c007388ULL, 0x0003e20000000c00ULL,
0x3f803f801d1d7831ULL, 0x000fe40000200021ULL, 0x3f803f801c1c7831ULL, 0x000fca0000200020ULL,
0x0004001c0c007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f4000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x002e620000002700ULL,
0x0000580018067a24ULL, 0x000fe200078e02ffULL, 0x0000000143ff7812ULL, 0x000fe2000780f802ULL,
0x00000800ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000000077919ULL, 0x000e620000002600ULL,
0x00006600060d7a24ULL, 0x000fe200078e02ffULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000004003a087824ULL, 0x000fe200078e00ffULL, 0x000000000c147984ULL, 0x0004e20000000c00ULL,
0x000000ff0000720cULL, 0x000fe20000725670ULL, 0x0000580010107a24ULL, 0x002fe200078e0207ULL,
0x000007ff0d077811ULL, 0x000fc600078e40ffULL, 0x0000030010067a24ULL, 0x000fca00078e02ffULL,
0x0000000406127c10ULL, 0x000fc8000fffe0ffULL, 0x00000012070a7211ULL, 0x000fca00078fa8ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000bULL, 0x000000080a0e7210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fc800010e060bULL, 0x00000010090e7825ULL, 0x000fe200078e000eULL,
0x01ffffff0d097812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010000a7824ULL, 0x00cfe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x00000001120c7824ULL, 0x000fe200078e0209ULL,
0x000000700a117812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b137812ULL, 0x000fe200078ec0ffULL,
0x00006c00120a7625ULL, 0x000fc800078e000dULL, 0x00006c000c0c7625ULL, 0x000fe200078e000dULL,
0x0000000a130a7210ULL, 0x000fc80007a1e011ULL, 0x0000000c130c7210ULL, 0x000fe40007c7e011ULL,
0x0000000bff0b7210ULL, 0x000fe400007e44ffULL, 0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL,
0x0000003d0a007986ULL, 0x0003e8000c101906ULL, 0x0000003e0c007986ULL, 0x0003e4000c101906ULL,
0x0000000000007941ULL, 0x00cfea0003800000ULL, 0x000000140e007986ULL, 0x0005e2000c101d06ULL,
0x0000011000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0b7424ULL, 0x002fe200078e00ffULL,
0xffffffff180d7810ULL, 0x000fc60007ffe0ffULL, 0x00006a00100a7625ULL, 0x000fe200078e000bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000d0a0a79a8ULL, 0x000ee400099ee1c6ULL, 0x0000000d0a00720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0c7807ULL, 0x000fca0000000000ULL,
0x0000000cff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff0a7984ULL, 0x002e640000000000ULL,
0x000000ff0a00720cULL, 0x002fda0003f05270ULL, 0x00002b9000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000010000a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011600ULL,
0x00000080ff197424ULL, 0x000fe200078e00ffULL, 0x00000001060c7810ULL, 0x000fe40007ffe0ffULL,
0x000000700a1b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b107812ULL, 0x000fe200078ec0ffULL,
0x00006c00060a7625ULL, 0x000fc800078e0019ULL, 0x00006c000c0c7625ULL, 0x000fe200078e0019ULL,
0x0000000a100a7210ULL, 0x000fc8000791e01bULL, 0x0000000c100c7210ULL, 0x000fe40007b5e01bULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x000000060a0e7981ULL, 0x004368000c1e1900ULL, 0x000000060c0f7981ULL, 0x000362000c1e1900ULL,
0x000000021800780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002060a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a100a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a117981ULL, 0x000362000c1e1900ULL, 0x000000041800780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003060a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a100a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a137981ULL, 0x000362000c1e1900ULL,
0x000000041800780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004060a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a100a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a157981ULL, 0x000362000c1e1900ULL, 0x000000061800780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005060a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a100a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a177981ULL, 0x000362000c1e1900ULL,
0x000000061800780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081800780cULL, 0x002fe40003f06070ULL, 0x00000006060a7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a100a7210ULL, 0x000fe40007a3e01bULL,
0x00000007060c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006c000c0c0625ULL, 0x000fe400078e0019ULL, 0x000000060a197981ULL, 0x000366000c1e1900ULL,
0x0000000c100c0210ULL, 0x000fc80007c7e01bULL, 0x0000000dff0d0210ULL, 0x000fcc0001fe84ffULL,
0x000000060c0d0981ULL, 0x000366000c1e1900ULL, 0x00000007180a7810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0c7819ULL, 0x000fc8000001160aULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x020fe400078e000eULL, 0x000000081b107824ULL, 0x040fe200078e00ffULL,
0x000000011b1b7810ULL, 0x000fc80007ffe0ffULL, 0x0000030010007a0cULL, 0x000fe40003f26070ULL,
0x0000000c1b00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x00000008100b7810ULL, 0x040fe40007ffe0ffULL, 0x00000001100a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001d0e0e7209ULL, 0x004fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff147819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x00000070121d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a140a7210ULL, 0x000fc80007b3e01dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a1d7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x00000009100b7810ULL, 0x042fe40007ffe0ffULL,
0x00000002100a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000000f0e0e7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010000f7824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a0f7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a100b7810ULL, 0x042fe40007ffe0ffULL, 0x00000003100a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x000000110e0e7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a117981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b100b7810ULL, 0x042fe40007ffe0ffULL,
0x00000004100a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x000000130e0e7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff147819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007012137812ULL, 0x000fc800078ec0ffULL,
0x0000000a140a7210ULL, 0x000fc80007b3e013ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a137981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c100b7810ULL, 0x042fe40007ffe0ffULL, 0x00000005100a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x000000150e0e7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff147819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007012157812ULL, 0x000fc800078ec0ffULL, 0x0000000a140a7210ULL, 0x000fc80007b3e015ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a157981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d100b7810ULL, 0x042fe40007ffe0ffULL,
0x00000006100a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x000000170e0e7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff147819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007012177812ULL, 0x000fc800078ec0ffULL,
0x0000000a140a7210ULL, 0x000fc80007b3e017ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a177981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e100b7810ULL, 0x042fe40007ffe0ffULL, 0x00000007100a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x000000190e0e7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff147819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007012197812ULL, 0x000fc800078ec0ffULL, 0x0000000a140a7210ULL, 0x000fc80007b3e019ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a197981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f100b7810ULL, 0x002fe40007ffe0ffULL,
0x0000000d0e0e7209ULL, 0x000fe40007810000ULL, 0x000003000b007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010000d7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007a3e00dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000060a0d7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ee40000000000ULL, 0x00000010000a7824ULL, 0x00afe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011600ULL, 0x000000700a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL, 0x000000010b0b7824ULL, 0x000fca00078e020aULL,
0x0000000e0b007388ULL, 0x0203e40000000800ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x00000010000b7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011600ULL,
0x0000000143127824ULL, 0x000fe200078e0206ULL, 0x00000002ff0e7819ULL, 0x004fe20000011602ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000700b0c7812ULL, 0x000fe200078ec0ffULL,
0x00000800ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000c0d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000020002027824ULL, 0x000fe200078e00ffULL, 0x00000012070a7211ULL, 0x000fe200078fa8ffULL,
0x000000013c3c7824ULL, 0x000fe200078e0203ULL, 0x000010d000007945ULL, 0x000fe20003800000ULL,
0x000000010d297824ULL, 0x000fe200078e020cULL, 0x000000010e0c7812ULL, 0x000fe200078ec0ffULL,
0x00000002430d8824ULL, 0x000fe200078e023aULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00006c000a0a7625ULL, 0x000fe200078e000fULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000020d178824ULL, 0x000fe200078e020cULL, 0x00000800020d7812ULL, 0x000fe200078ec0ffULL,
0x00000002430f8824ULL, 0x000fe200078e023aULL, 0x000000080a0a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000109108824ULL, 0x000fe200078e0212ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000080ff118424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000080ff138424ULL, 0x000fe200078e00ffULL, 0x0000000029297984ULL, 0x000e620000000800ULL,
0x000000020f198824ULL, 0x000fe200078e020cULL, 0x00000020000f7810ULL, 0x000fe20007ffe0ffULL,
0x000000013c0d7824ULL, 0x000fc400078e020dULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000030043007a0cULL, 0x000fe20003f26070ULL, 0x00006c0010108625ULL, 0x000fc800078e0011ULL,
0x00006c0012128625ULL, 0x000fc800078e0013ULL, 0x0000000817178824ULL, 0x100fe400078e0200ULL,
0x0000000819198824ULL, 0x000fe400078e0200ULL, 0x0000001000157824ULL, 0x040fe200078e020dULL,
0x0000458017178811ULL, 0x000fe200078e20ffULL, 0x00000010000c7825ULL, 0x100fe200078e000aULL,
0x00004180191f8811ULL, 0x000fe400078e20ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000100f0e7825ULL, 0x000fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000c157faeULL, 0x0005e2000b901c46ULL, 0x00000000000a7805ULL, 0x000fc4000001ff00ULL,
0x0000001000108825ULL, 0x040fe200078e0010ULL, 0x003800000e157faeULL, 0x0007e6000b901c46ULL,
0x0000001000128825ULL, 0x000fe200078e0012ULL, 0x0000000010178faeULL, 0x0009e6000b901c46ULL,
0x000000ffff027224ULL, 0x000fe200078e00ffULL, 0x00000000121f8faeULL, 0x0003e2000b901c46ULL,
0x00000000000c7805ULL, 0x004fe2000001ff00ULL, 0x000000ffff287224ULL, 0x000fc400078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000e7805ULL, 0x008fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x000000ffff327224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x010fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x002fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000d5000001947ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e00ffULL,
0x000000ffff337224ULL, 0x000fca00078e0043ULL, 0x0000000233357810ULL, 0x000fe20007ffe0ffULL,
0x0000029000017945ULL, 0x000fe60003800000ULL, 0x0000030035007a0cULL, 0x000fda0003f06070ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x000000070000780cULL, 0x000fe20003f24070ULL,
0x0000000106307824ULL, 0x100fe200078e0235ULL, 0x00000001ff2a7819ULL, 0x000fe20000011635ULL,
0x00000800ff347424ULL, 0x000fe200078e00ffULL, 0x00000020003b7810ULL, 0x000fe20007ffe0ffULL,
0x00000400352c7824ULL, 0x000fe200078e00ffULL, 0x00000030072b7211ULL, 0x000fe400078fa8ffULL,
0x000000012a2e7812ULL, 0x000fc600078ec0ffULL, 0x00006c002b2a7625ULL, 0x000fc800078e0034ULL,
0x00000002432f9824ULL, 0x000fe200078e023aULL, 0x000000082a2a7210ULL, 0x000fe20007f1e0ffULL,
0x00000001092d9824ULL, 0x000fe400078e0230ULL, 0x000000022f3d9824ULL, 0x000fe200078e022eULL,
0x000008002c2f7812ULL, 0x000fe200078ec0ffULL, 0x00000080ff349424ULL, 0x000fe400078e00ffULL,
0x0000000243399824ULL, 0x020fe400078e023aULL, 0x00006c002d2c9625ULL, 0x000fc800078e0034ULL,
0x0000000239399824ULL, 0x000fe400078e022eULL, 0x00000080ff319424ULL, 0x000fe400078e00ffULL,
0x000000013c2f7824ULL, 0x000fe400078e022fULL, 0x000000ffff2b7224ULL, 0x000fe400000e062bULL,
0x00006c0030309625ULL, 0x000fc800078e0031ULL, 0x0000001000377824ULL, 0x040fe400078e022fULL,
0x0000000839399824ULL, 0x000fe400078e0200ULL, 0x00000010002e9825ULL, 0x000fc600078e002cULL,
0x0000458039399811ULL, 0x000fe200078e20ffULL, 0x000000083d3d9824ULL, 0x000fe400078e0200ULL,
0x000000103b2c7825ULL, 0x000fc600078e002aULL, 0x000041803d3b9811ULL, 0x000fe200078e20ffULL,
0x00000010002a7825ULL, 0x000fc800078e002aULL, 0x0000001000309825ULL, 0x000fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800002a377faeULL, 0x0003e8000b901c46ULL,
0x003800002c377faeULL, 0x0003e8000b901c46ULL, 0x000000002e399faeULL, 0x0003e8000b901c46ULL,
0x00000000303b9faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000040332a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff2c7819ULL, 0x000fe20000011600ULL, 0x00000002432d7824ULL, 0x000fe200078e023aULL,
0x00000002ff527819ULL, 0x000fe20000011600ULL, 0x00000010002b7824ULL, 0x000fe200078e00ffULL,
0x000000802a2a7812ULL, 0x000fc400078ec0ffULL, 0x0000000c2c2c7812ULL, 0x000fe200078ec0ffULL,
0x00000008522f7824ULL, 0x040fe200078e00ffULL, 0x000000702b2b7812ULL, 0x000fe200078ec0ffULL,
0x000001002d2a7824ULL, 0x000fe200078e002aULL, 0x0000000752427812ULL, 0x040fe200078ec0ffULL,
0x00000008522d7824ULL, 0x040fe200078e00ffULL, 0x0000000852547810ULL, 0x000fe40007ffe0ffULL,
0x0000002a2c2c7210ULL, 0x000fe20007ffe02bULL, 0x00000008522b7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2a7812ULL, 0x100fe200078ee242ULL, 0x00000008542d7824ULL, 0x040fe200078e00ffULL,
0x00000054ff4e7212ULL, 0x000fe200078e33ffULL, 0x0000000854447824ULL, 0x000fe200078e00ffULL,
0x000000012b2e7812ULL, 0x000fe200078ef642ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180002c3e7984ULL, 0x000e620000000800ULL, 0x000000022b307812ULL, 0x140fe400078ef642ULL,
0x000000032b347812ULL, 0x140fe200078ef642ULL, 0x004580002c507984ULL, 0x0002a20000000800ULL,
0x000000042b367812ULL, 0x140fe400078ef642ULL, 0x000000052b387812ULL, 0x000fe400078ef642ULL,
0x00000052ff407212ULL, 0x000fe400078e33ffULL, 0xfffffff82d4e7812ULL, 0x000fc400078ee24eULL,
0xfffffff82f407812ULL, 0x000fe400078ee240ULL, 0x00000007542f7812ULL, 0x000fe200078ec0ffULL,
0x0000003e292c7221ULL, 0x002fe20000010100ULL, 0x000000062b3e7812ULL, 0x000fe200078ef642ULL,
0x00000400332b7824ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b2c317820ULL, 0x000fe20000410000ULL,
0x00000004002c7824ULL, 0x000fe400078e00ffULL, 0x000008002b2b7812ULL, 0x000fe200078ec0ffULL,
0x0000000854427824ULL, 0x000fc400078e00ffULL, 0x0000000c2c2d7812ULL, 0x000fe200078ec0ffULL,
0x0000003100317308ULL, 0x000ea20000000800ULL, 0x000001803c2b7810ULL, 0x000fe20007ffe02bULL,
0x000000ffff337224ULL, 0x000fe200078e0035ULL, 0xfffffff8442c7812ULL, 0x100fe400078ee22fULL,
0x0000000142447812ULL, 0x000fe200078ef62fULL, 0x000000102a2a7824ULL, 0x000fe200078e022bULL,
0x0000000242467812ULL, 0x000fe200078ef62fULL, 0x0000001040407824ULL, 0x000fe200078e022bULL,
0x0000000342487812ULL, 0x000fe200078ef62fULL, 0x000000012a2a7824ULL, 0x000fe200078e022dULL,
0x00000004424a7812ULL, 0x140fe200078ef62fULL, 0x000000012d407824ULL, 0x040fe200078e0240ULL,
0x00000005424c7812ULL, 0x000fe200078ef62fULL, 0x000000102e2e7824ULL, 0x000fe200078e022bULL,
0x0000000642427812ULL, 0x000fe200078ef62fULL, 0x0000001030307824ULL, 0x100fe200078e022bULL,
0x000000002a2f7984ULL, 0x000e620000000800ULL, 0x000000012d2e7824ULL, 0x000fe200078e022eULL,
0x0000005031317220ULL, 0x004fe20000410000ULL, 0x000000012d307824ULL, 0x000fe200078e0230ULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x0000001034347824ULL, 0x100fe200078e022bULL,
0x0000030033007a0cULL, 0x000fe20003f06070ULL, 0x0000001036367824ULL, 0x100fe200078e022bULL,
0x000000002e2e7984ULL, 0x000fe20000000800ULL, 0x000000012d347824ULL, 0x000fe200078e0234ULL,
0x0000003231327221ULL, 0x000fe20000010000ULL, 0x000000012d367824ULL, 0x000fe200078e0236ULL,
0x0000000030307984ULL, 0x000fe20000000800ULL, 0x0000001038387824ULL, 0x000fc400078e022bULL,
0x000000103e3e7824ULL, 0x100fe200078e022bULL, 0x00001f52312a7589ULL, 0x000ea200000e0000ULL,
0x000000012d387824ULL, 0x000fe400078e0238ULL, 0x000000102c2c7824ULL, 0x100fe200078e022bULL,
0x0000000034347984ULL, 0x000ee20000000800ULL, 0x0000001044447824ULL, 0x100fe400078e022bULL,
0x0000001046467824ULL, 0x100fe200078e022bULL, 0x0000000036367984ULL, 0x000f220000000800ULL,
0x0000001048487824ULL, 0x000fc400078e022bULL, 0x000000104a4a7824ULL, 0x100fe200078e022bULL,
0x0000000038387984ULL, 0x000ee20000000800ULL, 0x000000104c4c7824ULL, 0x100fe400078e022bULL,
0x0000001042427824ULL, 0x100fe400078e022bULL, 0x000000104e4e7824ULL, 0x000fe400078e022bULL,
0x000000012d3e7824ULL, 0x040fe200078e023eULL, 0x00001f54312b7589ULL, 0x000fe200000e0000ULL,
0x000000012d2c7824ULL, 0x000fc400078e022cULL, 0x000000012d447824ULL, 0x040fe200078e0244ULL,
0x00007610ff507816ULL, 0x002fe2000000002fULL, 0x000000012d467824ULL, 0x040fe200078e0246ULL,
0x000000003e3e7984ULL, 0x000e620000000800ULL, 0x000000012d487824ULL, 0x040fe400078e0248ULL,
0x000000012d4a7824ULL, 0x040fe200078e024aULL, 0x000000002c2c7984ULL, 0x000e620000000800ULL,
0x000000012d4c7824ULL, 0x040fe200078e024cULL, 0x0000002a50277223ULL, 0x004fe20000010027ULL,
0x000000012d427824ULL, 0x040fe200078e0242ULL, 0x0000000044447984ULL, 0x000ea20000000800ULL,
0x000000012d4e7824ULL, 0x000fe200078e024eULL, 0x00005410ff2d7816ULL, 0x000fc4000000002fULL,
0x0000000046467984ULL, 0x000e660000000800ULL, 0x0000002a2d287223ULL, 0x000fe20000010028ULL,
0x00005410ff2d7816ULL, 0x100fe20000000040ULL, 0x0000000048487984ULL, 0x000ea20000000800ULL,
0x00007610ff407816ULL, 0x000fc60000000040ULL, 0x0000002a2d1a7223ULL, 0x080fe2000001001aULL,
0x00005410ff2d7816ULL, 0x100fe2000000002eULL, 0x000000004a4a7984ULL, 0x000ea20000000800ULL,
0x00007610ff2e7816ULL, 0x000fe2000000002eULL, 0x0000002a40197223ULL, 0x080fe40000010019ULL,
0x0000002a2d267223ULL, 0x080fe20000010026ULL, 0x00005410ff2d7816ULL, 0x100fe20000000030ULL,
0x000000004c4c7984ULL, 0x000ea20000000800ULL, 0x00007610ff307816ULL, 0x000fe20000000030ULL,
0x0000002a2e257223ULL, 0x000fc40000010025ULL, 0x0000002a2d247223ULL, 0x080fe20000010024ULL,
0x00005410ff2d7816ULL, 0x108fe20000000034ULL, 0x0000000042427984ULL, 0x000ee20000000800ULL,
0x00007610ff347816ULL, 0x000fe20000000034ULL, 0x0000002a30237223ULL, 0x080fe40000010023ULL,
0x0000002a2d227223ULL, 0x080fe20000010022ULL, 0x00005410ff2d7816ULL, 0x110fe20000000036ULL,
0x000000004e4e7984ULL, 0x000f220000000800ULL, 0x00007610ff367816ULL, 0x000fe20000000036ULL,
0x0000002a34217223ULL, 0x000fc40000010021ULL, 0x0000002a2d207223ULL, 0x080fe20000010020ULL,
0x00005410ff2d7816ULL, 0x100fe20000000038ULL, 0x0000002a361f7223ULL, 0x000fe2000001001fULL,
0x00007610ff387816ULL, 0x000fc60000000038ULL, 0x0000002a2d1e7223ULL, 0x080fe2000001001eULL,
0x00005410ff2d7816ULL, 0x102fe2000000003eULL, 0x0000002a381d7223ULL, 0x000fe2000001001dULL,
0x00007610ff3e7816ULL, 0x000fc6000000003eULL, 0x0000002a2d1c7223ULL, 0x080fe2000001001cULL,
0x00005410ff2d7816ULL, 0x100fe2000000002cULL, 0x0000002a3e1b7223ULL, 0x000fe2000001001bULL,
0x00007610ff2c7816ULL, 0x000fc6000000002cULL, 0x0000002b2d187223ULL, 0x080fe20000010018ULL,
0x00005410ff2d7816ULL, 0x104fe20000000044ULL, 0x0000002b2c177223ULL, 0x000fe20000010017ULL,
0x00007610ff447816ULL, 0x000fc60000000044ULL, 0x0000002b2d167223ULL, 0x080fe20000010016ULL,
0x00005410ff2d7816ULL, 0x100fe20000000046ULL, 0x0000002b44157223ULL, 0x000fe20000010015ULL,
0x00007610ff467816ULL, 0x000fc60000000046ULL, 0x0000002b2d147223ULL, 0x080fe20000010014ULL,
0x00005410ff2d7816ULL, 0x100fe20000000048ULL, 0x0000002b46137223ULL, 0x000fe20000010013ULL,
0x00007610ff487816ULL, 0x000fc60000000048ULL, 0x0000002b2d127223ULL, 0x080fe20000010012ULL,
0x00005410ff2d7816ULL, 0x100fe2000000004aULL, 0x0000002b48117223ULL, 0x000fe20000010011ULL,
0x00007610ff4a7816ULL, 0x000fc6000000004aULL, 0x0000002b2d107223ULL, 0x080fe20000010010ULL,
0x00005410ff2d7816ULL, 0x100fe2000000004cULL, 0x0000002b4a0f7223ULL, 0x000fe2000001000fULL,
0x00007610ff4c7816ULL, 0x000fc6000000004cULL, 0x0000002b2d0e7223ULL, 0x080fe2000001000eULL,
0x00005410ff2d7816ULL, 0x108fe20000000042ULL, 0x0000002b4c0d7223ULL, 0x000fe2000001000dULL,
0x00007610ff427816ULL, 0x000fc60000000042ULL, 0x0000002b2d0c7223ULL, 0x080fe2000001000cULL,
0x00005410ff2d7816ULL, 0x010fe2000000004eULL, 0x0000002b420b7223ULL, 0x000fc8000001000bULL,
0x0000002b2d0a7223ULL, 0x000fe2000001000aULL, 0x00007610ff2d7816ULL, 0x000fca000000004eULL,
0x0000002b2d027223ULL, 0x000fe20000010002ULL, 0xfffff2d000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000ff3a00720cULL, 0x000fe20003f05270ULL, 0x0000001000067824ULL, 0x002fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fc80000011600ULL, 0x0000007006067812ULL, 0x000fe400078ec0ffULL,
0x0000000c00077812ULL, 0x000fca00078ec0ffULL, 0x0000000107087824ULL, 0x000fe200078e0206ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x0000001000067824ULL, 0x002fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011600ULL,
0x0000007006007812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fc600078ec0ffULL,
0x0000008043007824ULL, 0x000fc800078e0200ULL, 0x0000000107077824ULL, 0x000fca00078e0200ULL,
0x0049803207007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800008007984ULL, 0x000ea80000000800ULL,
0x004a000008077984ULL, 0x002e620000000800ULL, 0x00000000ff007221ULL, 0x004fc80000010000ULL,
0x0000000700007221ULL, 0x002fca0000010000ULL, 0x0180000000067810ULL, 0x000fc80007ffe0ffULL,
0x7f80000006067812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0600780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fe200078e0000ULL, 0x0000fa3000067802ULL, 0x000fe40000000f00ULL,
0x0000781000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff067224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000077308ULL, 0x000e640000001000ULL,
0xbf80000000067423ULL, 0x002fc80000000007ULL, 0x800000ff06067221ULL, 0x000fc80000010100ULL,
0x0000000607067223ULL, 0x000fe40000000007ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000800417811ULL, 0x004fe400078ff0ffULL, 0x00000002ff337819ULL, 0x000fe40000011600ULL,
0x00000041ff457212ULL, 0x000fe200078e33ffULL, 0x00001f4106097589ULL, 0x000ea200000e0000ULL,
0x0000000841087824ULL, 0x000fc400078e00ffULL, 0x0000000833477824ULL, 0x000fe200078e00ffULL,
0x00001f3306077589ULL, 0x00072400000e0000ULL, 0xfffffff808457812ULL, 0x000fca00078ee245ULL,
0x0000001045457824ULL, 0x000fe200078e0204ULL, 0x00000033ff067212ULL, 0x008fc800078e33ffULL,
0xfffffff847477812ULL, 0x000fe200078ee206ULL, 0x0000000833067824ULL, 0x000fe200078e00ffULL,
0x0000001809187220ULL, 0x044fe20000410000ULL, 0x0000001709177220ULL, 0x040fe20000410000ULL,
0x0000001609167220ULL, 0x040fe20000410000ULL, 0x0000001509157220ULL, 0x040fe20000410000ULL,
0x0000001409147220ULL, 0x040fe20000410000ULL, 0x0000001309137220ULL, 0x040fe20000410000ULL,
0x0000001209127220ULL, 0x040fe20000410000ULL, 0x0000001109117220ULL, 0x040fe20000410000ULL,
0x0000001009107220ULL, 0x040fe20000410000ULL, 0x0000000f090f7220ULL, 0x040fe20000410000ULL,
0x0000000e090e7220ULL, 0x040fe20000410000ULL, 0x0000000d090d7220ULL, 0x040fe20000410000ULL,
0x0000000c090c7220ULL, 0x040fe20000410000ULL, 0x0000000b090b7220ULL, 0x040fe20000410000ULL,
0x0000000a090a7220ULL, 0x040fe20000410000ULL, 0x0000000209097220ULL, 0x000fe20000410000ULL,
0x0000000733027812ULL, 0x000fe200078ec0ffULL, 0x0000002807287220ULL, 0x050fe20000410000ULL,
0x0000002707277220ULL, 0x040fe20000410000ULL, 0x0000002607267220ULL, 0x040fe20000410000ULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000002207227220ULL, 0x040fe20000410000ULL,
0x0000002107217220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000001f071f7220ULL, 0x040fe20000410000ULL, 0x0000001e071e7220ULL, 0x040fe20000410000ULL,
0x0000001d071d7220ULL, 0x040fe20000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000001b071b7220ULL, 0x040fe20000410000ULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x0000001907077220ULL, 0x000fe20000410000ULL, 0x0000000e0d0d723eULL, 0x000fc400000010ffULL,
0x0000000c0b0b723eULL, 0x000fe400000010ffULL, 0x0000000a0909723eULL, 0x000fe400000010ffULL,
0xfffffff806197812ULL, 0x000fe400078ee233ULL, 0x0000000102067812ULL, 0x040fe400078e3cffULL,
0x0000000202087812ULL, 0x040fe200078e3cffULL, 0x0000001019197824ULL, 0x000fe200078e0204ULL,
0x00000003020a7812ULL, 0x040fe200078e3cffULL, 0x0000000833297824ULL, 0x040fe200078e0206ULL,
0x00000004020c7812ULL, 0x040fe200078e3cffULL, 0x00000008332b7824ULL, 0x040fe200078e0208ULL,
0x00000005020e7812ULL, 0x040fe200078e3cffULL, 0x00000008332d7824ULL, 0x040fe200078e020aULL,
0x0000000602027812ULL, 0x000fe200078e3cffULL, 0x00000008332f7824ULL, 0x000fe200078e020cULL,
0x000000121111723eULL, 0x000fe200000010ffULL, 0x0000000833317824ULL, 0x000fe200078e020eULL,
0x0000000741127812ULL, 0x000fe200078ec0ffULL, 0x0000000833337824ULL, 0x000fe200078e0202ULL,
0x000000141313723eULL, 0x000fe200000010ffULL, 0x0000000841147824ULL, 0x000fe200078e00ffULL,
0x000000100f0f723eULL, 0x000fe200000010ffULL, 0x0000000400107824ULL, 0x000fe200078e00ffULL,
0x0000000112027812ULL, 0x040fe200078e3cffULL, 0x0000001029297824ULL, 0x100fe200078e0204ULL,
0x0000000212067812ULL, 0x040fe200078e3cffULL, 0x000000102b2b7824ULL, 0x000fe200078e0204ULL,
0x0000000312087812ULL, 0x040fe200078e3cffULL, 0x0000000841377824ULL, 0x040fe200078e0202ULL,
0x00000004120a7812ULL, 0x040fe200078e3cffULL, 0x0000000841397824ULL, 0x060fe200078e0206ULL,
0x00000005120c7812ULL, 0x040fe200078e3cffULL, 0x00000008413b7824ULL, 0x040fe200078e0208ULL,
0x00000006120e7812ULL, 0x000fe200078e3cffULL, 0x00000008413d7824ULL, 0x000fe200078e020aULL,
0x0000001c1b1b723eULL, 0x000fe200000010ffULL, 0x00000008413f7824ULL, 0x040fe200078e020cULL,
0xfffffff814357812ULL, 0x000fe200078ee241ULL, 0x0000000841417824ULL, 0x000fe200078e020eULL,
0x0000000c101c7812ULL, 0x000fe200078ec0ffULL, 0x0000001047067824ULL, 0x100fe200078e0204ULL,
0x000000282727723eULL, 0x000fe200000010ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0204ULL,
0x000000262525723eULL, 0x000fe200000010ffULL, 0x0000001035357824ULL, 0x100fe200078e0204ULL,
0x000000242323723eULL, 0x000fe200000010ffULL, 0x000000011c027824ULL, 0x000fe200078e0219ULL,
0x000000222121723eULL, 0x000fe200000010ffULL, 0x000000102f2f7824ULL, 0x100fe200078e0204ULL,
0x000000201f1f723eULL, 0x000fe200000010ffULL, 0x0000001031317824ULL, 0x100fe200078e0204ULL,
0x0000001e1d1d723eULL, 0x000fe200000010ffULL, 0x0000001033337824ULL, 0x100fe200078e0204ULL,
0x0000002702007388ULL, 0x0005e20000000800ULL, 0x0000001037377824ULL, 0x100fe200078e0204ULL,
0x0000001a0707723eULL, 0x000fe200000010ffULL, 0x0000001039397824ULL, 0x100fe200078e0204ULL,
0x000000181717723eULL, 0x000fe200000010ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0204ULL,
0x000000161515723eULL, 0x000fe200000010ffULL, 0x000000103d3d7824ULL, 0x000fc400078e0204ULL,
0x000000103f3f7824ULL, 0x100fe400078e0204ULL, 0x0000001041417824ULL, 0x000fe400078e0204ULL,
0x000000011c107824ULL, 0x040fe400078e0206ULL, 0x000000011c047824ULL, 0x040fe400078e0229ULL,
0x000000011c067824ULL, 0x040fe400078e022bULL, 0x000000011c087824ULL, 0x040fe200078e022dULL,
0x0000002504007388ULL, 0x0007e20000000800ULL, 0x000000011c0a7824ULL, 0x000fc400078e022fULL,
0x000000011c0c7824ULL, 0x040fe200078e0231ULL, 0x0000002306007388ULL, 0x000fe20000000800ULL,
0x000000011c0e7824ULL, 0x040fe400078e0233ULL, 0x000000011c127824ULL, 0x040fe200078e0235ULL,
0x0000002108007388ULL, 0x000fe20000000800ULL, 0x000000011c147824ULL, 0x040fe400078e0237ULL,
0x000000011c027824ULL, 0x044fe200078e0239ULL, 0x0000001f0a007388ULL, 0x000fe20000000800ULL,
0x000000011c167824ULL, 0x000fc400078e023bULL, 0x000000011c187824ULL, 0x040fe200078e023dULL,
0x0000001d0c007388ULL, 0x000fe20000000800ULL, 0x000000011c1e7824ULL, 0x040fe400078e0245ULL,
0x000000011c1a7824ULL, 0x040fe200078e023fULL, 0x0000001b0e007388ULL, 0x000fe20000000800ULL,
0x000000011c1c7824ULL, 0x000fe400078e0241ULL, 0x0000002043207824ULL, 0x000fe200078e0200ULL,
0x0000000710007388ULL, 0x0005e60000000800ULL, 0x0000001020047824ULL, 0x008fe200078e0203ULL,
0x0000001712007388ULL, 0x000fe80000000800ULL, 0x0000001514007388ULL, 0x000fe20000000800ULL,
0x000000050510723eULL, 0x004fc600000010ffULL, 0x0000001302007388ULL, 0x000fe80000000800ULL,
0x0000001116007388ULL, 0x000fe80000000800ULL, 0x0000000f18007388ULL, 0x000fe80000000800ULL,
0x0000000d1a007388ULL, 0x000fe80000000800ULL, 0x0000000b1c007388ULL, 0x000fe80000000800ULL,
0x000000091e007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000004207984ULL, 0x000ea80000000c00ULL, 0x0004000004287984ULL, 0x000ee80000000c00ULL,
0x0008000004247984ULL, 0x000f280000000c00ULL, 0x000c0000042c7984ULL, 0x000e620000000c00ULL,
0x3f803f8010237831ULL, 0x004fc40000200023ULL, 0x3f803f8010227831ULL, 0x040fe40000200022ULL,
0x3f803f8010217831ULL, 0x040fe40000200021ULL, 0x3f803f8010207831ULL, 0x040fe40000200020ULL,
0x3f803f80102b7831ULL, 0x048fe4000020002bULL, 0x3f803f80102a7831ULL, 0x040fe4000020002aULL,
0x3f803f8010297831ULL, 0x000fc40000200029ULL, 0x3f803f8010287831ULL, 0x000fe40000200028ULL,
0x3f803f8023237831ULL, 0x010fe40000200027ULL, 0x3f803f8022227831ULL, 0x000fe40000200026ULL,
0x3f803f8021217831ULL, 0x000fe40000200025ULL, 0x3f803f8020207831ULL, 0x000fe40000200024ULL,
0x3f803f802b2b7831ULL, 0x002fc4000020002fULL, 0x3f803f802a2a7831ULL, 0x000fe2000020002eULL,
0x0000002004007388ULL, 0x0003e20000000c00ULL, 0x3f803f8029297831ULL, 0x000fe4000020002dULL,
0x3f803f8028287831ULL, 0x000fca000020002cULL, 0x0004002804007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff4300720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002000137810ULL, 0x002fe20007ffe0ffULL,
0x0000000000077919ULL, 0x000e620000002600ULL, 0x00000003ff117819ULL, 0x100fe20000011600ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x00000003ff047819ULL, 0x100fe20000011613ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000711057812ULL, 0x100fe200078e4800ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000704067812ULL, 0x000fe400078e4813ULL,
0x0ffffff805027812ULL, 0x000fc400078ef800ULL, 0x0ffffff806067812ULL, 0x000fc600078ef813ULL,
0x0000001002027824ULL, 0x100fe400078e0203ULL, 0x0000001006067824ULL, 0x000fc600078e0203ULL,
0x0000000002087984ULL, 0x0008a80000000c00ULL, 0x00000000060c7984ULL, 0x0044a20000000c00ULL,
0x0000000807107824ULL, 0x042fe400078e00ffULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x008fe4000f8e023fULL, 0xfffffff810037812ULL, 0x000fc400078ee211ULL,
0xfffffff807047812ULL, 0x000fe200078ee204ULL, 0x000000083a077824ULL, 0x040fe200078e00ffULL,
0x0000000403037c10ULL, 0x000fe2000ff1e0ffULL, 0x000000083a3a7824ULL, 0x000fe200078e00ffULL,
0x0000000404057c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff807077812ULL, 0x000fe200078ee200ULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00005a0003027a11ULL, 0x010fe200078040ffULL,
0x000000ffff067224ULL, 0x004fe200008e06ffULL, 0x00005a0005047a11ULL, 0x000fc400078240ffULL,
0x00005b0003037a11ULL, 0x000fe400000f4410ULL, 0x00005b0005057a11ULL, 0x000fe400008f4406ULL,
0xfffffff83a117812ULL, 0x000fe200078ee213ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001011047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x000fe8000c101d06ULL,
0x0000000c04007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff057819ULL, 0x000fe20000011602ULL, 0xffffffffff397424ULL, 0x000fc800078e00ffULL,
0x0000000234387824ULL, 0x000fca00078e0205ULL, 0x000000353800720cULL, 0x000fda0003f06070ULL,
0x0000000224058824ULL, 0x000fc800078e00ffULL, 0x0000640005068a24ULL, 0x000fc800078e0238ULL,
0x0000600006068625ULL, 0x000fe200078e0011ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff087624ULL, 0x000fe200078e00ffULL, 0x0000000606398981ULL, 0x000ea2000c1e1900ULL,
0x00006900ff097624ULL, 0x000fc600078e00ffULL, 0x00f60000ff047f8cULL, 0x000e68000c80043fULL,
0x00000006083d7981ULL, 0x000762000c1e9900ULL, 0x0000000134007810ULL, 0x000fe20007ffe0ffULL,
0x00000040023b7824ULL, 0x000fe400078e00ffULL, 0x00000080123a7824ULL, 0x000fe200078e00ffULL,
0x000000370000720cULL, 0x000fe20003f06070ULL, 0x00000100340b7824ULL, 0x000fc400078e023bULL,
0x000000803c3c7824ULL, 0x000fc600078e00ffULL, 0x000000403a167812ULL, 0x000fe200078ef80bULL,
0x0000003c39217224ULL, 0x004fcc00078e02ffULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1d7819ULL, 0x00afe40000011636ULL, 0x0000000b03007217ULL, 0x000fe40007800000ULL,
0x000000081d117810ULL, 0x040fe20007ffe0ffULL, 0x000000011d067824ULL, 0x140fe200078e0216ULL,
0x000000181d237810ULL, 0x040fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a0bULL,
0x000000101d177810ULL, 0x000fe40007ffe0ffULL, 0x0000000621137210ULL, 0x000fe20007f1e0ffULL,
0x0000000111067824ULL, 0x100fe200078e0216ULL, 0x000000300e1f7812ULL, 0x000fe200078ec0ffULL,
0x0000000117077824ULL, 0x000fe200078e0216ULL, 0x00000003ff0d7819ULL, 0x000fe20000011636ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005e00130a7a11ULL, 0x000fe200078038ffULL,
0x00000004170e7824ULL, 0x000fe200078e00ffULL, 0x0000000721127210ULL, 0x000fc40007f3e0ffULL,
0x00005f0013137a11ULL, 0x000fe200000f3c08ULL, 0x0000000123087824ULL, 0x000fe200078e0216ULL,
0x0000000621067210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x000000030d0d7812ULL, 0x000fe400078e4836ULL, 0x0000000821087210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e00060c7a11ULL, 0x000fe400078038ffULL,
0x00005e00120b7a11ULL, 0x000fe200078238ffULL, 0x000000ffff077224ULL, 0x000fe200010e06ffULL,
0x00005e0008107a11ULL, 0x000fc400078438ffULL, 0x00005f0006157a11ULL, 0x000fe400000f3c15ULL,
0x00005f0008147a11ULL, 0x000fe200010f3c07ULL, 0x0000000411087824ULL, 0x000fe200078e00ffULL,
0x0000000a1f067210ULL, 0x000fe40007f7e0ffULL, 0x000000001d00720cULL, 0x000fe40003f06070ULL,
0xfffffffc080a7812ULL, 0x000fe200078ee20dULL, 0x000000ffff077224ULL, 0x000fe200018e0613ULL,
0x00001000020f7811ULL, 0x000fc400078e68ffULL, 0x0000001f0c087210ULL, 0x080fe40007f7e0ffULL,
0x0ffffffc0d367812ULL, 0x000fe200078ef836ULL, 0x000000100a137824ULL, 0x000fe200078e020fULL,
0x000000001700720cULL, 0x080fe40003f46070ULL, 0xfffffffc0e0c7812ULL, 0x000fe200078ee20dULL,
0x00000004230e7824ULL, 0x000fe200078e00ffULL, 0x000000201d177810ULL, 0x000fe40007ffe0ffULL,
0x00005f0012127a11ULL, 0x000fe200008f3c09ULL, 0x000000ffff097224ULL, 0x000fe200018e0615ULL,
0x000000001100720cULL, 0x080fe20003f26070ULL, 0x0000001036117824ULL, 0x100fe200078e020fULL,
0x0000001f0b0a7210ULL, 0x000fe20007f9e0ffULL, 0x000000100c157824ULL, 0x000fe200078e020fULL,
0x000000281d197810ULL, 0x000fe20007ffe0ffULL, 0x00000001160c7824ULL, 0x000fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006117faeULL, 0x0003e2000c101c46ULL,
0x000000ffff0b7224ULL, 0x000fe200020e0612ULL, 0x000000002300720cULL, 0x000fc40003f86070ULL,
0x0000000c21127210ULL, 0x000fe40007f1e0ffULL, 0x000000301d1b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000008137faeULL, 0x0005e2000c901c46ULL, 0x00005e00120c7a11ULL, 0x000fe400078c38ffULL,
0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL, 0x000000000a157faeULL, 0x0007e2000d101c46ULL,
0x000000ffff077224ULL, 0x002fe200000e06ffULL, 0x0000001f10067210ULL, 0x000fe40007fbe0ffULL,
0x000000001700720cULL, 0x000fc40003f66070ULL, 0x00005f0012127a11ULL, 0x000fe200030f3c07ULL,
0x000000ffff077224ULL, 0x000fe200028e0614ULL, 0xfffffffc0e087812ULL, 0x004fe200078ee20dULL,
0x000000041d147824ULL, 0x000fe200078e00ffULL, 0x000000001900720cULL, 0x080fe40003f46070ULL,
0x000000001b00720cULL, 0x080fe20003f26070ULL, 0x0000001008097824ULL, 0x000fe200078e020fULL,
0x000000001d00720cULL, 0x000fe20003f06070ULL, 0x0000000116007824ULL, 0x040fe400078e0219ULL,
0x0000000116087824ULL, 0x040fe200078e021bULL, 0x0000000006097faeULL, 0x0003e2000e101c46ULL,
0x00000001160a7824ULL, 0x008fe200078e021dULL, 0x0000000021107210ULL, 0x000fe20007fbe0ffULL,
0x0000000417007824ULL, 0x000fe200078e00ffULL, 0x00000008210e7210ULL, 0x000fe20007f9e0ffULL,
0x0000000419087824ULL, 0x000fe200078e00ffULL, 0x0000000a210b7210ULL, 0x000fe20007fde0ffULL,
0x000000041b0a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc00007812ULL, 0x000fc400078ee20dULL,
0xfffffffc08087812ULL, 0x100fe400078ee20dULL, 0xfffffffc0a0a7812ULL, 0x100fe200078ee20dULL,
0x000000ffff077224ULL, 0x002fe200028e06ffULL, 0xfffffffc14067812ULL, 0x000fe200078ee20dULL,
0x0000001000117824ULL, 0x100fe200078e020fULL, 0x00005e0010097a11ULL, 0x000fe200078a38ffULL,
0x0000001008137824ULL, 0x100fe400078e020fULL, 0x000000100a157824ULL, 0x000fe200078e020fULL,
0x00005f0010107a11ULL, 0x000fe200028f3c07ULL, 0x00000010060f7824ULL, 0x000fe200078e020fULL,
0x0000001f0c067210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e06ffULL,
0x00005e000e0a7a11ULL, 0x000fe200078838ffULL, 0x000000ffff007224ULL, 0x000fe200030e06ffULL,
0x00005e000b0c7a11ULL, 0x000fe200078c38ffULL, 0x000000ffff077224ULL, 0x000fe200028e0612ULL,
0x0000001f09087210ULL, 0x000fc40007fbe0ffULL, 0x00005f000e0d7a11ULL, 0x000fe400020f3c0dULL,
0x0000001f0a0a7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff097224ULL, 0x000fe200028e0610ULL,
0x00005f000b007a11ULL, 0x000fe200030f3c00ULL, 0x0000000006117faeULL, 0x0003e2000d901c46ULL,
0x0000001f0c0c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0b7224ULL, 0x000fe400020e060dULL,
0x0000000008137faeULL, 0x0003e4000d101c46ULL, 0x000000ffff0d7224ULL, 0x000fc400028e0600ULL,
0x000000000a157faeULL, 0x0003e8000c901c46ULL, 0x000000000c0f7faeULL, 0x0003e2000c101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000001636007211ULL, 0x04afe400078ff0ffULL,
0x0000000836177811ULL, 0x040fe400078ff0ffULL, 0x0000000021007210ULL, 0x000fe40007f1e0ffULL,
0x0000001036067811ULL, 0x000fc400078ff0ffULL, 0x0000001836087811ULL, 0x000fe200078ff0ffULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x00005e0000207a11ULL, 0x000fe400078038ffULL,
0x00000028360c7811ULL, 0x000fe200078ff0ffULL, 0x0000000116097824ULL, 0x000fe200078e0208ULL,
0x00005f0000227a11ULL, 0x000fe200000f3c07ULL, 0x0000000117007824ULL, 0x000fe200078e0216ULL,
0x00000020360a7811ULL, 0x000fe200078ff0ffULL, 0x0000000116077824ULL, 0x040fe200078e0206ULL,
0x00000003ff157819ULL, 0x000fe20000011636ULL, 0x00000001160d7824ULL, 0x000fe200078e020cULL,
0x00000030360f7811ULL, 0x000fe200078ff0ffULL, 0x0000000408087824ULL, 0x000fe200078e00ffULL,
0x00000000211e7210ULL, 0x000fe20007fde0ffULL, 0x00000001160b7824ULL, 0x000fe200078e020aULL,
0x0000000315157812ULL, 0x000fe200078e4836ULL, 0x000000040c0c7824ULL, 0x000fe200078e00ffULL,
0x0000003836117811ULL, 0x000fe200078ff0ffULL, 0x0000000417007824ULL, 0x000fe200078e00ffULL,
0x0000000721137210ULL, 0x040fe20007fbe0ffULL, 0x000000040a0a7824ULL, 0x000fe200078e00ffULL,
0x00000009211a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000116107824ULL, 0x000fe200078e020fULL,
0x0000100002237811ULL, 0x000fe200078e68ffULL, 0x000000040f147824ULL, 0x000fe200078e00ffULL,
0xfffffffc08077812ULL, 0x000fe200078ee215ULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x0000000b21187210ULL, 0x000fe20007f3e0ffULL, 0x0000000116127824ULL, 0x000fe200078e0211ULL,
0xfffffffc0c097812ULL, 0x100fe200078ee215ULL, 0x0000000406067824ULL, 0x000fe200078e00ffULL,
0x00005e001e1c7a11ULL, 0x000fe200078c38ffULL, 0x0000000411167824ULL, 0x000fe200078e00ffULL,
0xfffffffc00007812ULL, 0x000fe200078ee215ULL, 0x00000010071b7824ULL, 0x000fe200078e0223ULL,
0xfffffffc0a087812ULL, 0x000fe200078ee215ULL, 0x00000010091f7824ULL, 0x000fe200078e0223ULL,
0xfffffffc140a7812ULL, 0x000fe200078ee215ULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005f001e1e7a11ULL, 0x000fe200030f3c0fULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x0000001021107210ULL, 0x040fe20007f7e0ffULL, 0x0000001000177824ULL, 0x000fe200078e0223ULL,
0x0000001221127210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff007224ULL, 0x000fe200028e06ffULL,
0xfffffffc06067812ULL, 0x000fe200078ee215ULL, 0x00000010081d7824ULL, 0x000fe200078e0223ULL,
0x00005e00180f7a11ULL, 0x000fc400078238ffULL, 0x0ffffffc15367812ULL, 0x000fe200078ef836ULL,
0x0000001006197824ULL, 0x100fe200078e0223ULL, 0x00005e001a0c7a11ULL, 0x000fe400078038ffULL,
0x0000000d210d7210ULL, 0x000fe20007f5e0ffULL, 0x000000100a217824ULL, 0x000fe200078e0223ULL,
0xfffffffc160b7812ULL, 0x000fe200078ee215ULL, 0x000000ffff157224ULL, 0x000fe200018e06ffULL,
0x000000300e257812ULL, 0x000fe200078ec0ffULL, 0x0000001036277824ULL, 0x100fe200078e0223ULL,
0x00005e00130a7a11ULL, 0x000fe200078a38ffULL, 0x000000100b237824ULL, 0x000fe200078e0223ULL,
0x00005f0018187a11ULL, 0x000fe200008f3c07ULL, 0x000000ffff077224ULL, 0x000fe200020e06ffULL,
0x00005f001a1a7a11ULL, 0x000fe200000f3c09ULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x00005e0012147a11ULL, 0x000fc400078638ffULL, 0x0000002025067210ULL, 0x000fe40007f1e0ffULL,
0x00005f00130b7a11ULL, 0x000fe400028f3c00ULL, 0x00005e000d117a11ULL, 0x040fe400078238ffULL,
0x00005e0010137a11ULL, 0x000fe400078438ffULL, 0x00005f0012007a11ULL, 0x000fe200018f3c07ULL,
0x000000ffff077224ULL, 0x000fe200000e0622ULL, 0x00005f000d167a11ULL, 0x000fc400008f3c16ULL,
0x0000001c25087210ULL, 0x040fe40007f1e0ffULL, 0x00005f0010157a11ULL, 0x000fe200010f3c15ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006277faeULL, 0x0003e2000b901c46ULL,
0x0000000a250a7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e061eULL,
0x0000000c250c7210ULL, 0x040fe40007f5e0ffULL, 0x0000000f250e7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000001125107210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e061aULL, 0x0000001325127210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e0618ULL, 0x0000001425147210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200020e0616ULL, 0x0000000008177faeULL, 0x0003e2000b901c46ULL,
0x000000ffff137224ULL, 0x000fc400028e0615ULL, 0x000000ffff157224ULL, 0x000fe200000e0600ULL,
0x000000000a197faeULL, 0x0003e8000b901c46ULL, 0x000000000c1b7faeULL, 0x0003e8000b901c46ULL,
0x000000000e1d7faeULL, 0x0003e8000b901c46ULL, 0x00000000101f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012217faeULL, 0x0003e8000b901c46ULL, 0x0000000014237faeULL, 0x0003e4000b901c46ULL,
0x00f60400ff077984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000007ff7812ULL, 0x002fc60007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002002007824ULL, 0x002fc800078e0205ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x000000f006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105077812ULL, 0x040fe400078efcffULL,
0x0000000705057812ULL, 0x100fe400078e7800ULL, 0x0000000707077812ULL, 0x000fc600078e7800ULL,
0x0000000105057824ULL, 0x000fe400078e0206ULL, 0x0000000106077824ULL, 0x000fc600078e0207ULL,
0x00000000050c7984ULL, 0x000e68000000cc00ULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fc400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001005007388ULL, 0x0003e8000000cc00ULL, 0x0000000c07007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff047f8cULL, 0x002fe8000c80043fULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe20003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000373400720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000367919ULL, 0x000e620000000000ULL, 0x3db504f33d3d7820ULL, 0x020fe20000410000ULL,
0x00006400243f7a24ULL, 0x000fe200078e02ffULL, 0x0000f688023e7811ULL, 0x040fe200078e18ffULL,
0x000000ffff437224ULL, 0x000fe200078e00ffULL, 0xffffffff37417810ULL, 0x000fe40007ffe0ffULL,
0x0000f60802407811ULL, 0x000fe400078e28ffULL, 0x0000010034427824ULL, 0x000fe200078e023bULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000420300720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x03cfea0003800000ULL, 0x000000ffff457224ULL, 0x000fe200078e0043ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fc4000001ff00ULL, 0x0000000146247810ULL, 0x000fe20007ffe0ffULL,
0x00000d9000007945ULL, 0x000fe20003800000ULL, 0x000000ffff007224ULL, 0x000fe200078e0046ULL,
0x0000000145437812ULL, 0x000fe200078e0cffULL, 0x0000003c39337224ULL, 0x020fe200078e02ffULL,
0x00000001ff257819ULL, 0x100fe20000011624ULL, 0x000000ffff467224ULL, 0x000fe200078e0024ULL,
0x000000022400780cULL, 0x000fc40003f06070ULL, 0x0000000124567812ULL, 0x000fe200078ec0ffULL,
0x0000030025267a24ULL, 0x000fc800078e0234ULL, 0x0000010026447824ULL, 0x040fe200078e023bULL,
0x0000000126287810ULL, 0x000fc80007ffe0ffULL, 0x000000372800720cULL, 0x000fe40003f26070ULL,
0x0000004044257812ULL, 0x000fca00078ec0ffULL, 0x000000013a2f7824ULL, 0x000fcc00078e0225ULL,
0x000006b000009947ULL, 0x000fea0003800000ULL, 0x00000002ff307819ULL, 0x002fe20000011636ULL,
0x0000000456557824ULL, 0x000fe200078e00ffULL, 0x0000004403257217ULL, 0x000fe20007800000ULL,
0x0000000202487824ULL, 0x000fe200078e0243ULL, 0x00000010304f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000130247824ULL, 0x140fe200078e022fULL, 0x0000000830477810ULL, 0x040fe20007ffe0ffULL,
0x0000000125447824ULL, 0x000fe200078e0a44ULL, 0x0000001830507810ULL, 0x040fe20007ffe0ffULL,
0x000000014f277824ULL, 0x100fe200078e022fULL, 0x00000024332d7210ULL, 0x000fe20007f3e0ffULL,
0x0000000147267824ULL, 0x000fe200078e022fULL, 0x0000002030517810ULL, 0x000fc40007ffe0ffULL,
0x0000002733297210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00000026332b7210ULL, 0x000fe40007f5e0ffULL, 0x00005e002d247a11ULL, 0x000fe200078238ffULL,
0x000000ffff2a7224ULL, 0x000fe200018e06ffULL, 0x00005e0029287a11ULL, 0x000fe200078638ffULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x00005e002b267a11ULL, 0x000fe400078438ffULL,
0x00005f0029297a11ULL, 0x000fe200018f3c2aULL, 0x00000001502a7824ULL, 0x000fe200078e022fULL,
0x0000003030537810ULL, 0x000fc40007ffe0ffULL, 0x0000002830527810ULL, 0x040fe40007ffe0ffULL,
0x00005f002d257a11ULL, 0x000fe200008f3c2eULL, 0x00000001532d7824ULL, 0x100fe200078e022fULL,
0x00005f002b277a11ULL, 0x000fe200010f3c2cULL, 0x00000001512b7824ULL, 0x100fe200078e022fULL,
0x0000003830547810ULL, 0x000fe20007ffe0ffULL, 0x00000001522c7824ULL, 0x100fe200078e022fULL,
0x0000002a33327210ULL, 0x040fe40007f3e0ffULL, 0x000000443000720cULL, 0x000fe20003f46070ULL,
0x00000001542e7824ULL, 0x000fe200078e022fULL, 0x0000002b33307210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff2b7224ULL, 0x000fe200008e06ffULL, 0x0000002d33317210ULL, 0x000fc40007f9e0ffULL,
0x00000003ff2d7819ULL, 0x100fe40000011636ULL, 0x00005e00322a7a11ULL, 0x040fe200078238ffULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x0000002c332f7210ULL, 0x040fe40007fde0ffULL,
0x0000002e33337210ULL, 0x000fe20007f7e0ffULL, 0x00000004472e7824ULL, 0x000fe200078e00ffULL,
0x000000032d4d7812ULL, 0x000fe200078e4836ULL, 0x000000ffff2d7224ULL, 0x000fe200028e06ffULL,
0x00005f00322b7a11ULL, 0x000fe200008f3c2bULL, 0x000000ffff4e7224ULL, 0x000fe200030e06ffULL,
0x000000444700720cULL, 0x000fe20003f26070ULL, 0x000000ffff4a7224ULL, 0x000fe200018e06ffULL,
0x0000100048487811ULL, 0x000fc400078e60ffULL, 0x0ffffffc4d497812ULL, 0x100fe400078ef836ULL,
0xfffffffc55477812ULL, 0x000fe400078ee236ULL, 0xfffffffc2e4b7812ULL, 0x000fe200078ee24dULL,
0x0000001049497824ULL, 0x000fe200078e0248ULL, 0x00005e00302c7a11ULL, 0x040fe200078a38ffULL,
0x0000001047247825ULL, 0x000fe200078e0024ULL, 0x00005e0033327a11ULL, 0x000fe400078838ffULL,
0x00005f00302d7a11ULL, 0x000fe200028f3c2dULL, 0x000000104b4b7824ULL, 0x000fe200078e0248ULL,
0x00005e002f2e7a11ULL, 0x000fe200078a38ffULL, 0x0000001047267825ULL, 0x000fe200078e0026ULL,
0x00005e0031307a11ULL, 0x000fe200078638ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024497faeULL, 0x0003e2000d101c46ULL, 0x00005f002f2f7a11ULL, 0x000fc400028f3c4eULL,
0x00005f0031317a11ULL, 0x000fe200018f3c4cULL, 0x00000000264b7faeULL, 0x0005e2000c901c46ULL,
0x00005f0033337a11ULL, 0x000fe200020f3c4aULL, 0x00000004514a7824ULL, 0x000fe200078e00ffULL,
0x000000444f00720cULL, 0x080fe40003f26070ULL, 0x000000445000720cULL, 0x0c0fe20003f46070ULL,
0x0000000450507824ULL, 0x000fe200078e00ffULL, 0x000000445100720cULL, 0x080fe20003f66070ULL,
0x0000000453247824ULL, 0x042fe200078e00ffULL, 0x000000445200720cULL, 0x0c0fe20003f86070ULL,
0x0000000452527824ULL, 0x000fe200078e00ffULL, 0x000000445300720cULL, 0x080fe20003fa6070ULL,
0x0000001047267825ULL, 0x004fe200078e002aULL, 0x000000445400720cULL, 0x000fc40003fc6070ULL,
0xfffffffc4a257812ULL, 0x100fe200078ee24dULL, 0x000000044f447824ULL, 0x000fe200078e00ffULL,
0xfffffffc504b7812ULL, 0x100fe200078ee24dULL, 0x0000000454547824ULL, 0x000fe200078e00ffULL,
0xfffffffc524f7812ULL, 0x000fe200078ee24dULL, 0x00000010472a7825ULL, 0x000fe200078e002eULL,
0xfffffffc44497812ULL, 0x100fe400078ee24dULL, 0xfffffffc24517812ULL, 0x100fe200078ee24dULL,
0x000000104b4b7824ULL, 0x100fe200078e0248ULL, 0xfffffffc54537812ULL, 0x000fe200078ee24dULL,
0x00000010254d7824ULL, 0x000fc400078e0248ULL, 0x0000001049497824ULL, 0x000fe400078e0248ULL,
0x0000001047247825ULL, 0x000fc800078e0028ULL, 0x0000001047287825ULL, 0x000fe200078e002cULL,
0x0000000024497faeULL, 0x0003e6000c901c46ULL, 0x000000104f4f7824ULL, 0x100fe200078e0248ULL,
0x00000000264b7faeULL, 0x0003e2000d101c46ULL, 0x0000001051517824ULL, 0x000fe400078e0248ULL,
0x00000010472c7825ULL, 0x000fe200078e0030ULL, 0x00000000284d7faeULL, 0x0003e6000d901c46ULL,
0x0000001053537824ULL, 0x000fe200078e0248ULL, 0x000000002a4f7faeULL, 0x0003e2000e101c46ULL,
0x00000010472e7825ULL, 0x000fc600078e0032ULL, 0x000000002c517faeULL, 0x0003e8000e901c46ULL,
0x000000002e537faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x00000008362c7811ULL, 0x002fe200078ff0ffULL, 0x0000000456557824ULL, 0x000fe200078e00ffULL,
0x0000002f36247211ULL, 0x040fe400078ff0ffULL, 0x00000018362e7811ULL, 0x000fe200078ff0ffULL,
0x000000012c257824ULL, 0x040fe200078e022fULL, 0x0000002433297210ULL, 0x000fe20007f3e0ffULL,
0x000000042c4a7824ULL, 0x000fe200078e00ffULL, 0x0000002036307811ULL, 0x000fc400078ff0ffULL,
0x0000002533277210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x00005e0029247a11ULL, 0x000fe200078238ffULL, 0x00000004304e7824ULL, 0x000fe200078e00ffULL,
0x0000003036447811ULL, 0x000fe200078ff0ffULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x00005e0027267a11ULL, 0x000fe400078438ffULL, 0x00005f0029257a11ULL, 0x000fe200008f3c2aULL,
0x00000001442c7824ULL, 0x000fe200078e022fULL, 0x00005f0027277a11ULL, 0x000fe200010f3c28ULL,
0x0000000202287824ULL, 0x000fe200078e0243ULL, 0x00000003ff297819ULL, 0x000fe20000011636ULL,
0x0000000444527824ULL, 0x000fe200078e00ffULL, 0x00000010362a7811ULL, 0x000fc400078ff0ffULL,
0x0000000329317812ULL, 0x100fe200078e4836ULL, 0x000000012e297824ULL, 0x100fe200078e022fULL,
0x0000100028537811ULL, 0x000fe200078e60ffULL, 0x000000012a287824ULL, 0x000fe200078e022fULL,
0x0000002836327811ULL, 0x000fe200078ff0ffULL, 0x000000042e2e7824ULL, 0x000fe200078e00ffULL,
0x0000003836487811ULL, 0x000fe200078ff0ffULL, 0x000000042a4c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc4a447812ULL, 0x000fe200078ee231ULL, 0x00000001302a7824ULL, 0x100fe200078e022fULL,
0x0000002833307210ULL, 0x040fe20007f7e0ffULL, 0x00000001322b7824ULL, 0x000fe200078e022fULL,
0xfffffffc2e4a7812ULL, 0x100fe200078ee231ULL, 0x0000000432507824ULL, 0x000fe200078e00ffULL,
0x00000029332e7210ULL, 0x040fe20007f5e0ffULL, 0x0000000448547824ULL, 0x000fe200078e00ffULL,
0xfffffffc4e4e7812ULL, 0x000fe200078ee231ULL, 0x00000001482d7824ULL, 0x000fe200078e022fULL,
0xfffffffc4c487812ULL, 0x000fe200078ee231ULL, 0x000000ffff297224ULL, 0x000fe200018e06ffULL,
0x0000002a334c7210ULL, 0x040fe20007f3e0ffULL, 0x000000104a4b7824ULL, 0x000fe200078e0253ULL,
0x0000002b332f7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200010e06ffULL,
0xfffffffc50507812ULL, 0x000fe200078ee231ULL, 0x0000001048497824ULL, 0x000fe200078e0253ULL,
0xfffffffc52527812ULL, 0x100fe200078ee231ULL, 0x000000ffff4a7224ULL, 0x000fe200018e06ffULL,
0xfffffffc54547812ULL, 0x000fe200078ee231ULL, 0x0000001044477824ULL, 0x100fe200078e0253ULL,
0x0ffffffc31327812ULL, 0x100fe200078ef836ULL, 0x000000104e4d7824ULL, 0x100fe200078e0253ULL,
0x0000002c33317210ULL, 0x040fe20007f9e0ffULL, 0x00000010504f7824ULL, 0x100fe200078e0253ULL,
0x00005e002e2a7a11ULL, 0x000fe200078438ffULL, 0x0000001032577824ULL, 0x000fe200078e0253ULL,
0x00005e0030287a11ULL, 0x000fe200078c38ffULL, 0x000000ffff487224ULL, 0x000fe200020e06ffULL,
0x0000002d33337210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff2d7224ULL, 0x000fe200008e06ffULL,
0x00005f002e2b7a11ULL, 0x000fe200010f3c2bULL, 0x0000001052517824ULL, 0x100fe200078e0253ULL,
0xfffffffc55557812ULL, 0x000fe200078ee236ULL, 0x000000ffff447224ULL, 0x000fe200028e06ffULL,
0x00005e004c2c7a11ULL, 0x000fe200078238ffULL, 0x0000001054537824ULL, 0x000fe200078e0253ULL,
0x00005f0030297a11ULL, 0x000fe200030f3c29ULL, 0x0000001055247825ULL, 0x000fe200078e0024ULL,
0x00005e002f2e7a11ULL, 0x000fc400078438ffULL, 0x00005e0031307a11ULL, 0x000fe200078638ffULL,
0x0000001055267825ULL, 0x000fe200078e0026ULL, 0x00005e0033327a11ULL, 0x000fe200078838ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024577faeULL, 0x0003e2000b901c46ULL,
0x00005f004c2d7a11ULL, 0x000fe200008f3c2dULL, 0x0000001055287825ULL, 0x000fe200078e0028ULL,
0x00005f002f2f7a11ULL, 0x000fe200010f3c4aULL, 0x0000000026477faeULL, 0x0003e2000b901c46ULL,
0x00005f0031317a11ULL, 0x000fe200018f3c48ULL, 0x00000010552a7825ULL, 0x000fe200078e002aULL,
0x00005f0033337a11ULL, 0x000fe200020f3c44ULL, 0x0000000028497faeULL, 0x0003e4000b901c46ULL,
0x00000010552c7825ULL, 0x000fc400078e002cULL, 0x000000002a4b7faeULL, 0x0003e4000b901c46ULL,
0x00000010552e7825ULL, 0x040fe400078e002eULL, 0x000000002c4d7faeULL, 0x0003e4000b901c46ULL,
0x0000001055307825ULL, 0x040fe400078e0030ULL, 0x000000002e4f7faeULL, 0x0003e4000b901c46ULL,
0x0000001055327825ULL, 0x000fc400078e0032ULL, 0x0000000030517faeULL, 0x0003e8000b901c46ULL,
0x0000000032537faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff5600720cULL, 0x000fe20003f25270ULL, 0x000000b000007945ULL, 0x000fd80003800000ULL,
0x0000009000009947ULL, 0x000fea0003800000ULL, 0x00000300ff257624ULL, 0x002fe400078e00ffULL,
0xffffffffff397424ULL, 0x000fe400078e00ffULL, 0x0000000225387824ULL, 0x000fca00078e0238ULL,
0x000000353800720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x000000023f247824ULL, 0x000fe400078e0238ULL, 0x00000004ff257424ULL, 0x000fc800078e00ffULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x0000000624397981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008004b7824ULL, 0x002fe400078e00ffULL, 0x000000ffff4a7224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff836257812ULL, 0x000fe200078ec0ffULL,
0x0000000202297824ULL, 0x000fe200078e0245ULL, 0x000000014a2a7810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000725257812ULL, 0x000fe400078ef836ULL,
0x0000100029297811ULL, 0x000fc400078e60ffULL, 0x00000001ff007819ULL, 0x000fe40000011625ULL,
0x0000000736d17812ULL, 0x000fe400078ec0ffULL, 0x0000000300277812ULL, 0x000fe400078ec0ffULL,
0x00000008d1d17812ULL, 0x000fe400078ef836ULL, 0x0000004a27007212ULL, 0x040fe400078e3cffULL,
0x0000002a27247212ULL, 0x000fc600078e3cffULL, 0x0000000425007824ULL, 0x040fe400078e0200ULL,
0x0000000425247824ULL, 0x000fe200078e0224ULL, 0x0000002036257810ULL, 0x000fe20007ffe0ffULL,
0x0000001000007824ULL, 0x100fe400078e0229ULL, 0x0000001024247824ULL, 0x000fe200078e0229ULL,
0xfffffff825257812ULL, 0x000fe400078ec0ffULL, 0x000000000030783bULL, 0x0002a40000000200ULL,
0x0000000725287812ULL, 0x000fc400078ef836ULL, 0x00000000242c783bULL, 0x0007240000000200ULL,
0x00000001ff007819ULL, 0x002fc80000011628ULL, 0x00000003002b7812ULL, 0x000fc800078ec0ffULL,
0x0000004a2b257212ULL, 0x040fe400078e3cffULL, 0x0000002a2b2b7212ULL, 0x000fe400078e3cffULL,
0x000000024a4a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000428007824ULL, 0x040fe400078e0225ULL,
0x0000000428287824ULL, 0x000fe400078e022bULL, 0x0000001000247824ULL, 0x108fe400078e0229ULL,
0x0000001028287824ULL, 0x000fc800078e0229ULL, 0x000000002424783bULL, 0x000e680000000200ULL,
0x000000002828783bULL, 0x000ee20000000200ULL, 0x0000003000757306ULL, 0x004fe20000009400ULL,
0x00000018ffac7819ULL, 0x000fe20000011430ULL, 0x0001000030617824ULL, 0x000fe200078e00ffULL,
0x00000018ffa47819ULL, 0x000fe20000011431ULL, 0x0000010032b07824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011433ULL, 0x0000010033ab7824ULL, 0x040fe200078e00ffULL,
0x00000018ffb57819ULL, 0x000fe20000011461ULL, 0x0000003000b47306ULL, 0x000ea20000005400ULL,
0x00000018ffb07819ULL, 0x000fe200000114b0ULL, 0x0001000033af7824ULL, 0x000fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011432ULL, 0x000100002c7c7824ULL, 0x050fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x000001002c817824ULL, 0x000fe200078e00ffULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x0000003000607306ULL, 0x000862000000d400ULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x000100002d7f7824ULL, 0x040fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x000001002e6e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe2000001142cULL, 0x000001002d827824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x000000b500b67306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x010fe200078e00ffULL, 0x000000b47500720bULL, 0x004fe20003f9d000ULL,
0x000100002e767824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fc4000001142dULL,
0x00000018ffb87819ULL, 0x000fe20000011430ULL, 0x0001000031307824ULL, 0x000fe200078e00ffULL,
0x000000b500b77306ULL, 0x000ea20000205400ULL, 0x00000018ff9d7819ULL, 0x002fe20000011424ULL,
0x0001000024c97824ULL, 0x000fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe40000011425ULL,
0x00000018ffbd7819ULL, 0x000fe20000011430ULL, 0x0001000032307824ULL, 0x000fe200078e00ffULL,
0x0000000160604812ULL, 0x000fe200078efcffULL, 0x000000b800b97306ULL, 0x000fe20000209400ULL,
0x00000018ffc97819ULL, 0x000fc400000114c9ULL, 0x00000018ffc37819ULL, 0x000fe40000011430ULL,
0x00000018ff977819ULL, 0x000fe40000011426ULL, 0x00000018ff887819ULL, 0x000fe20000011427ULL,
0x000000b800ba7306ULL, 0x000e620000205400ULL, 0x000000b7b600720bULL, 0x004fe20003f5d000ULL,
0x0000010025b67824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001142eULL,
0x00000018ff6e7819ULL, 0x000fc4000001146eULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x0000003100a87306ULL, 0x000fe20000009400ULL, 0x00000018ff827819ULL, 0x000fe40000011482ULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x00000018ff517819ULL, 0x000fc6000001142fULL,
0x0000003100a57306ULL, 0x000ea20000005400ULL, 0x000000bab900720bULL, 0x002fce0003f7d000ULL,
0x00000031005f7306ULL, 0x000330000000d400ULL, 0x000000ac00bb7306ULL, 0x000fe20000209400ULL,
0x0000010031317824ULL, 0x002fe200078e00ffULL, 0x000000a5a800720bULL, 0x004fc40003f3d000ULL,
0x000000b800a87245ULL, 0x000fe2000020d400ULL, 0x0000010027b87824ULL, 0x000fe200078e00ffULL,
0x00000018ffc07819ULL, 0x000fe40000011431ULL, 0x000000ac00bc7306ULL, 0x000e620000205400ULL,
0x000000b500a57245ULL, 0x000fe4000020d400ULL, 0x00000001a8a83812ULL, 0x000fe400078efcffULL,
0x00000001a5a52812ULL, 0x000fe400078efcffULL, 0x000000015f5f1812ULL, 0x010fe200078efcffULL,
0x000000c000c17306ULL, 0x000fe20000209400ULL, 0x00000018ffb87819ULL, 0x000fce00000114b8ULL,
0x000000c000c27306ULL, 0x000ea20000205400ULL, 0x000000bcbb00720bULL, 0x002fce0003fdd000ULL,
0x0000003200a67306ULL, 0x000ff00000009400ULL, 0x0000003200a77306ULL, 0x000e620000005400ULL,
0x000000c2c100720bULL, 0x004fce0003f7d000ULL, 0x000000bd00be7306ULL, 0x000ff00000209400ULL,
0x000000bd00bf7306ULL, 0x000ea20000205400ULL, 0x000000a7a600720bULL, 0x002fe40003f5d000ULL,
0x000000ac00a77245ULL, 0x000fc4000020d400ULL, 0x000000bd00a67245ULL, 0x000fe4000020d400ULL,
0x00000001a7a76812ULL, 0x000fe200078efcffULL, 0x0000003300a27306ULL, 0x000ff00000009400ULL,
0x0000003300a37306ULL, 0x000e620000005400ULL, 0x000000bfbe00720bULL, 0x004fce0003fbd000ULL,
0x000000a400ae7306ULL, 0x000fec0000209400ULL, 0x00000001a6a65812ULL, 0x000fe400078efcffULL,
0x000000a400ad7306ULL, 0x000ea20000205400ULL, 0x000000a3a200720bULL, 0x002fe40003fdd000ULL,
0x000000c000a27245ULL, 0x000fc4000020d400ULL, 0x0000009400a37245ULL, 0x000fe4000020d400ULL,
0x00000001a2a23812ULL, 0x000fe200078efcffULL, 0x000000b000c67306ULL, 0x000ff00000209400ULL,
0x000000b000c77306ULL, 0x0003220000205400ULL, 0x000000adae00720bULL, 0x004fe20003f9d000ULL,
0x0001000026ad7824ULL, 0x000fca00078e00ffULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x00000024008e7306ULL, 0x000fe20000009400ULL, 0x000000b000b07245ULL, 0x002fce000020d400ULL,
0x0000002400957306ULL, 0x000fe20000005400ULL, 0x000000c7c600720bULL, 0x010fce0003f7d000ULL,
0x0000002400577306ULL, 0x0003ec000000d400ULL, 0x00000001b0b03812ULL, 0x000fe400078efcffULL,
0x00000032005c7306ULL, 0x000522000000d400ULL, 0x0000010024247824ULL, 0x002fca00078e00ffULL,
0x00000018ffcc7819ULL, 0x000fe20000011424ULL, 0x0001000025247824ULL, 0x000fe200078e00ffULL,
0x0000008900967306ULL, 0x000fe20000209400ULL, 0x000001002f327824ULL, 0x004fc600078e00ffULL,
0x00000018ffcf7819ULL, 0x000fe40000011424ULL, 0x0000004b36247211ULL, 0x000fe400078fe0ffULL,
0x0000008900937306ULL, 0x000e620000205400ULL, 0x000000015c5c2812ULL, 0x010fe400078efcffULL,
0x0000000224757810ULL, 0x040fe40007ffe0ffULL, 0x0000000724247812ULL, 0x100fe400078e78d1ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000002c009e7306ULL, 0x000fe20000009400ULL,
0x0000000775757812ULL, 0x000fe200078e78d1ULL, 0x00000010d1247824ULL, 0x000fe200078e0224ULL,
0x000000044b4b7810ULL, 0x000fc60007ffe0ffULL, 0x0000001024247824ULL, 0x000fe400078e00ffULL,
0x0000002c009f7306ULL, 0x000ea20000005400ULL, 0x000000939600720bULL, 0x002fe20003f5d000ULL,
0x00000010d1757824ULL, 0x000fe200078e0275ULL, 0x0000009d00967245ULL, 0x000fe4000020d400ULL,
0x000000cc00937245ULL, 0x000fc6000020d400ULL, 0x000000c300c47306ULL, 0x000ff00000209400ULL,
0x000000c300c57306ULL, 0x000e620000205400ULL, 0x0000009f9e00720bULL, 0x004fe40003f3d000ULL,
0x000000a4009f7245ULL, 0x000fc8000020d400ULL, 0x000000019f9f4812ULL, 0x000fe200078efcffULL,
0x0000009400a07306ULL, 0x000fe60000209400ULL, 0x000000a29f9f723eULL, 0x000fca00000010ffULL,
0x0000009400a17306ULL, 0x0005220000205400ULL, 0x000000c5c400720bULL, 0x002fce0003fbd000ULL,
0x000000ab00b27306ULL, 0x000fe20000209400ULL, 0x0000008900947245ULL, 0x004fe4000020d400ULL,
0x000000cf00897245ULL, 0x000fe4000020d400ULL, 0x0000000194942812ULL, 0x000fc600078efcffULL,
0x000000ab00b17306ULL, 0x0002a20000205400ULL, 0x000000a1a000720bULL, 0x010fe20003f9d000ULL,
0x0001000027a07824ULL, 0x000fe200078e00ffULL, 0x000000c300a17245ULL, 0x000fc8000020d400ULL,
0x00000001a1a15812ULL, 0x000fe200078efcffULL, 0x00000025008f7306ULL, 0x000fe20000009400ULL,
0x000000ab00ab7245ULL, 0x002fe4000020d400ULL, 0x00000018ffa07819ULL, 0x000fc600000114a0ULL,
0x00000001a3a34812ULL, 0x000fe400078efcffULL, 0x00000025008a7306ULL, 0x000fe20000005400ULL,
0x000000b1b200720bULL, 0x004fce0003f7d000ULL, 0x0000002500567306ULL, 0x000fec000000d400ULL,
0x00000001abab3812ULL, 0x000fe400078efcffULL, 0x000000cf00b47306ULL, 0x000fe40000209400ULL,
0x000000ab94ab723eULL, 0x000fcc00000010ffULL, 0x000000cf00257306ULL, 0x000e700000205400ULL,
0x000000af00b37306ULL, 0x000ff00000209400ULL, 0x000000af00c87306ULL, 0x0005220000205400ULL,
0x00000025b400720bULL, 0x002fce0003f5d000ULL, 0x0000003300587306ULL, 0x0002e2000000d400ULL,
0x000000af00af7245ULL, 0x004fca000020d400ULL, 0x0000000189892812ULL, 0x000fe400078efcffULL,
0x0000009d00aa7306ULL, 0x000fe20000209400ULL, 0x000000c8b300720bULL, 0x010fe20003fbd000ULL,
0x000100002f337824ULL, 0x002fca00078e00ffULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0000009d00a97306ULL, 0x000e620000205400ULL, 0x0000000158586812ULL, 0x008fca00078efcffULL,
0x00000001afaf5812ULL, 0x000fe400078efcffULL, 0x000000c900ca7306ULL, 0x000fe20000209400ULL,
0x000000958e00720bULL, 0x000fe40003fbd000ULL, 0x000000c9008e7245ULL, 0x000fe4000020d400ULL,
0x0000009a00957245ULL, 0x000fc6000020d400ULL, 0x000000c900cb7306ULL, 0x000ea20000205400ULL,
0x000000a9aa00720bULL, 0x002fe40003fdd000ULL, 0x00000058afaa723eULL, 0x000fe400000010ffULL,
0x0000003300587245ULL, 0x000fe4000020d400ULL, 0x0000000157575812ULL, 0x000fe200078efcffULL,
0x000000cc00cd7306ULL, 0x000fec0000209400ULL, 0x0000000196966812ULL, 0x000fc400078efcffULL,
0x000000cc00ce7306ULL, 0x000e620000205400ULL, 0x000000cbca00720bULL, 0x004fce0003f9d000ULL,
0x000000ad00ae7306ULL, 0x000fec0000209400ULL, 0x000000018e8e4812ULL, 0x000fe400078efcffULL,
0x000000ad00b77306ULL, 0x000ea20000205400ULL, 0x000000cecd00720bULL, 0x002fe40003f7d000ULL,
0x0000008a8f00720bULL, 0x000fc40003f9d000ULL, 0x000000ad008f7245ULL, 0x000fe4000020d400ULL,
0x000000b6008a7245ULL, 0x000fe2000020d400ULL, 0x0000009a009b7306ULL, 0x000fec0000209400ULL,
0x0000000193933812ULL, 0x000fe400078efcffULL, 0x0000009a009c7306ULL, 0x000e620000205400ULL,
0x000000b7ae00720bULL, 0x004fc40003f5d000ULL, 0x0000000156564812ULL, 0x000fe400078efcffULL,
0x000000939693723eULL, 0x000fe400000010ffULL, 0x000000568956723eULL, 0x000fe200000010ffULL,
0x0000002600867306ULL, 0x000fec0000009400ULL, 0x000000018f8f2812ULL, 0x000fc400078efcffULL,
0x0000002600877306ULL, 0x000ea20000005400ULL, 0x0000009c9b00720bULL, 0x002fce0003fdd000ULL,
0x0000002600507306ULL, 0x0002ec000000d400ULL, 0x0000000195956812ULL, 0x000fe400078efcffULL,
0x00000027007a7306ULL, 0x000fe20000009400ULL, 0x0000010026267824ULL, 0x002fe200078e00ffULL,
0x000000878600720bULL, 0x004fc40003f7d000ULL, 0x00000018ff867819ULL, 0x000fe4000001142aULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000027007b7306ULL, 0x000e6e0000005400ULL,
0x0000000150503812ULL, 0x008fe200078efcffULL, 0x00000027004f7306ULL, 0x000ea6000000d400ULL,
0x000000508f50723eULL, 0x000fca00000010ffULL, 0x0000002600277306ULL, 0x000fe20000209400ULL,
0x0000007b7a00720bULL, 0x002fe40003f5d000ULL, 0x00000026007b7245ULL, 0x000fca000020d400ULL,
0x00000026009e7306ULL, 0x000e6c0000205400ULL, 0x000000014f4f2812ULL, 0x004fe400078efcffULL,
0x000000a000a47306ULL, 0x000ff00000209400ULL, 0x000000a000257306ULL, 0x0004e20000205400ULL,
0x0000009e2700720bULL, 0x002fc40003f9d000ULL, 0x0000005fa69e723eULL, 0x000fe400000010ffULL,
0x00000076005f7245ULL, 0x000fc6000020d400ULL, 0x000000b8009d7306ULL, 0x000fe20000209400ULL,
0x000000a000a07245ULL, 0x004fca000020d400ULL, 0x000000017b7b4812ULL, 0x000fe400078efcffULL,
0x000000b8009c7306ULL, 0x0002a20000205400ULL, 0x00000025a400720bULL, 0x008fe40003fdd000ULL,
0x000000002424783bULL, 0x000eea0000000200ULL, 0x0000007c008d7306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x002fca000020d400ULL, 0x00000001a0a06812ULL, 0x000fe400078efcffULL,
0x0000007c00907306ULL, 0x000e620000205400ULL, 0x0000009c9d00720bULL, 0x004fe40003f7d000ULL,
0x0000004fa0a0723eULL, 0x000fca00000010ffULL, 0x0000008800917306ULL, 0x000fec0000209400ULL,
0x00000001b8b83812ULL, 0x000fe400078efcffULL, 0x0000008800927306ULL, 0x000ea20000205400ULL,
0x000000908d00720bULL, 0x002fce0003f5d000ULL, 0x00000081008c7306ULL, 0x000fe20000209400ULL,
0x0000009e241c723cULL, 0x048fee000004181cULL, 0x00000081008b7306ULL, 0x0002e20000205400ULL,
0x000000929100720bULL, 0x004fe40003fdd000ULL, 0x000000578e92723eULL, 0x000fe200000010ffULL,
0x000000aa2414723cULL, 0x000fe80000041814ULL, 0x0000006700687306ULL, 0x000fe20000209400ULL,
0x0000008100817245ULL, 0x002fc6000020d400ULL, 0x000000922410723cULL, 0x000fe80000041810ULL,
0x00000067006b7306ULL, 0x000e620000205400ULL, 0x0000008b8c00720bULL, 0x008fe20003f7d000ULL,
0x00010000288c7824ULL, 0x000fe200078e00ffULL, 0x0000007c008b7245ULL, 0x000fe2000020d400ULL,
0x00010000297c7824ULL, 0x000fc600078e00ffULL, 0x000000018b8b2812ULL, 0x000fe200078efcffULL,
0x0000002d00747306ULL, 0x000fe20000009400ULL, 0x00000018ff8c7819ULL, 0x000fe4000001148cULL,
0x00000018ff7c7819ULL, 0x000fc6000001147cULL, 0x0000000181813812ULL, 0x000fe400078efcffULL,
0x0000002d00777306ULL, 0x000ea20000005400ULL, 0x0000006b6800720bULL, 0x002fce0003f5d000ULL,
0x0000002c004e7306ULL, 0x0002f0000000d400ULL, 0x000000b600b57306ULL, 0x000fe20000209400ULL,
0x000000777400720bULL, 0x004fe40003f9d000ULL, 0x0000008800777245ULL, 0x000fe2000020d400ULL,
0x000001002b887824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x002fc40000011428ULL,
0x0000000177776812ULL, 0x000fe200078efcffULL, 0x000000b600ac7306ULL, 0x000e620000205400ULL,
0x000000014e4e1812ULL, 0x008fe400078efcffULL, 0x00000018ff747819ULL, 0x000fe4000001142bULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x0000004e8b4e723eULL, 0x000fe200000010ffULL,
0x0000007f00807306ULL, 0x000ff00000209400ULL, 0x0000007f00837306ULL, 0x0004e20000205400ULL,
0x000000acb500720bULL, 0x002fce0003fbd000ULL, 0x0000002f00637306ULL, 0x000fe20000009400ULL,
0x0000007f007f7245ULL, 0x004fca000020d400ULL, 0x000000018a8a5812ULL, 0x000fe400078efcffULL,
0x0000002f00647306ULL, 0x000e620000005400ULL, 0x000000838000720bULL, 0x008fe20003f3d000ULL,
0x0000010029807824ULL, 0x000fe200078e00ffULL, 0x0000008a9557723eULL, 0x000fe200000010ffULL,
0x000100002a837824ULL, 0x000fc600078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x0000006500697306ULL, 0x000fe20000209400ULL, 0x00000018ff837819ULL, 0x000fe20000011483ULL,
0x00000056240c723cULL, 0x000fe8000004180cULL, 0x000000017f7f1812ULL, 0x000fe400078efcffULL,
0x0000006500667306ULL, 0x0004e20000205400ULL, 0x000000646300720bULL, 0x002fc40003fdd000ULL,
0x0000006700647245ULL, 0x000fc8000020d400ULL, 0x0000000164642812ULL, 0x000fe200078efcffULL,
0x0000009700997306ULL, 0x000fe20000209400ULL, 0x0000006500657245ULL, 0x004fe4000020d400ULL,
0x00000081644f723eULL, 0x000fca00000010ffULL, 0x0000009700987306ULL, 0x000e620000205400ULL,
0x000000666900720bULL, 0x008fce0003f5d000ULL, 0x0000005b006d7306ULL, 0x000fec0000209400ULL,
0x0000000165652812ULL, 0x000fe400078efcffULL, 0x0000005b006a7306ULL, 0x0004e20000205400ULL,
0x000000989900720bULL, 0x002fe40003fbd000ULL, 0x0000009700987245ULL, 0x000fca000020d400ULL,
0x00000028005e7306ULL, 0x000fe20000009400ULL, 0x0000005b005b7245ULL, 0x004fca000020d400ULL,
0x0000000198985812ULL, 0x000fe400078efcffULL, 0x00000028005d7306ULL, 0x000fe20000005400ULL,
0x0000006a6d00720bULL, 0x008fce0003f3d000ULL, 0x00000028004d7306ULL, 0x0003ec000000d400ULL,
0x000000015b5b1812ULL, 0x000fe400078efcffULL, 0x0000002d00447306ULL, 0x0004e2000000d400ULL,
0x0000010028287824ULL, 0x002fca00078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011428ULL,
0x00000029005a7306ULL, 0x000fe20000009400ULL, 0x00000018ff2d7819ULL, 0x004fe40000011429ULL,
0x00000060a528723eULL, 0x000fe400000010ffULL, 0x0000006b008d7245ULL, 0x000fc6000020d400ULL,
0x0000002900597306ULL, 0x000fe20000005400ULL, 0x0000000144444812ULL, 0x008fce00078efcffULL,
0x00000029004c7306ULL, 0x0003f0000000d400ULL, 0x0000006e00787306ULL, 0x000fe20000209400ULL,
0x000000a8a729723eULL, 0x002fce00000010ffULL, 0x0000006e00797306ULL, 0x0002a20000205400ULL,
0x000000282420723cULL, 0x000fee0000041820ULL, 0x0000008200847306ULL, 0x000fe20000209400ULL,
0x0000005ca128723eULL, 0x000fe400000010ffULL, 0x000000b0a329723eULL, 0x000fc400000010ffULL,
0x0000006e006e7245ULL, 0x002fe4000020d400ULL, 0x000000b877a1723eULL, 0x000fe200000010ffULL,
0x0000008200857306ULL, 0x0002e20000205400ULL, 0x000000797800720bULL, 0x004fe20003f5d000ULL,
0x000000282418723cULL, 0x040fec0000041818ULL, 0x0000002e00737306ULL, 0x000fe20000009400ULL,
0x0000001075287824ULL, 0x000fe200078e00ffULL, 0x0000008200827245ULL, 0x002fe2000020d400ULL,
0x000000a02404723cULL, 0x000fe60000041804ULL, 0x000000016e6e2812ULL, 0x000fc400078efcffULL,
0x0000002e00727306ULL, 0x000e620000005400ULL, 0x000000858400720bULL, 0x008fe20003f7d000ULL,
0x000001002a847824ULL, 0x000fe200078e00ffULL, 0x000000595a00720bULL, 0x000fe20003f5d000ULL,
0x000100002b857824ULL, 0x000fe200078e00ffULL, 0x0000003200597245ULL, 0x000fe4000020d400ULL,
0x00000018ff847819ULL, 0x000fe20000011484ULL, 0x0000003200617306ULL, 0x000fe20000209400ULL,
0x00000018ff857819ULL, 0x000fca0000011485ULL, 0x0000000182823812ULL, 0x000fe400078efcffULL,
0x0000003200627306ULL, 0x0004e20000205400ULL, 0x000000727300720bULL, 0x002fe40003fbd000ULL,
0x000000014c4c2812ULL, 0x000fca00078efcffULL, 0x00000076007d7306ULL, 0x000fe20000209400ULL,
0x0000005100327245ULL, 0x004fce000020d400ULL, 0x00000076007e7306ULL, 0x000e620000205400ULL,
0x000000626100720bULL, 0x008fce0003f3d000ULL, 0x0000002e00007306ULL, 0x000eac000000d400ULL,
0x0000000159591812ULL, 0x000fe400078efcffULL, 0x00000051006c7306ULL, 0x000fe20000209400ULL,
0x0000007e7d00720bULL, 0x002fce0003f7d000ULL, 0x00000051006f7306ULL, 0x0002e20000205400ULL,
0x0000000100005812ULL, 0x004fca00078efcffULL, 0x000000015f5f3812ULL, 0x000fe400078efcffULL,
0x0000003300707306ULL, 0x000fe20000209400ULL, 0x0000005d5e00720bULL, 0x000fe40003f7d000ULL,
0x0000007b9851723eULL, 0x002fca00000010ffULL, 0x0000003300717306ULL, 0x000e620000205400ULL,
0x0000006f6c00720bULL, 0x008fe20003f9d000ULL, 0x000000502408723cULL, 0x000fe80000041808ULL,
0x000000014d4d3812ULL, 0x000fe400078efcffULL, 0x0000008c00637306ULL, 0x000fe20000209400ULL,
0x000000447f24723eULL, 0x000fe400000010ffULL, 0x000000826525723eULL, 0x000fc400000010ffULL,
0x000000005f26723eULL, 0x000fe400000010ffULL, 0x0000000132324812ULL, 0x000fe200078efcffULL,
0x0000008c00687306ULL, 0x0004e20000205400ULL, 0x000000717000720bULL, 0x002fe40003fbd000ULL,
0x0000006e5b27723eULL, 0x000fe400000010ffULL, 0x0000008500007245ULL, 0x000fe4000020d400ULL,
0x000000593259723eULL, 0x000fe200000010ffULL, 0x0000002a00537306ULL, 0x000fe20000009400ULL,
0x0000008c008c7245ULL, 0x004fca000020d400ULL, 0x0000000158585812ULL, 0x000fe400078efcffULL,
0x0000002a00527306ULL, 0x000e620000005400ULL, 0x000000686300720bULL, 0x008fce0003f3d000ULL,
0x0000002a00487306ULL, 0x000eac000000d400ULL, 0x000000018c8c1812ULL, 0x000fe400078efcffULL,
0x0000002b00557306ULL, 0x000fe20000009400ULL, 0x000000525300720bULL, 0x002fe40003fbd000ULL,
0x0000004d8c8c723eULL, 0x000fca00000010ffULL, 0x0000002b00547306ULL, 0x000fec0000005400ULL,
0x0000000148485812ULL, 0x004fe400078efcffULL, 0x0000002b00497306ULL, 0x0003f0000000d400ULL,
0x0000006b00677306ULL, 0x000fe20000209400ULL, 0x000000002828783bULL, 0x002e6e0000000200ULL,
0x0000006b00667306ULL, 0x000eb00000205400ULL, 0x0000002c00307306ULL, 0x000ff00000209400ULL,
0x0000002c00317306ULL, 0x0007220000205400ULL, 0x000000666700720bULL, 0x004fce0003f9d000ULL,
0x0000002f00477306ULL, 0x000ea2000000d400ULL, 0x0000002c002c7245ULL, 0x008fca000020d400ULL,
0x000000018d8d4812ULL, 0x000fe400078efcffULL, 0x0000002d002e7306ULL, 0x000fe20000209400ULL,
0x000000313000720bULL, 0x010fe20003f3d000ULL, 0x00000024281c723cULL, 0x042fec000004181cULL,
0x0000002d002f7306ULL, 0x0002e20000205400ULL, 0x0000000147476812ULL, 0x004fe200078efcffULL,
0x000000262818723cULL, 0x000fe20000041818ULL, 0x000000545500720bULL, 0x000fc40003fdd000ULL,
0x000000475858723eULL, 0x000fe400000010ffULL, 0x000000012c2c1812ULL, 0x000fe200078efcffULL,
0x00000080005c7306ULL, 0x000fe20000209400ULL, 0x0000002d002d7245ULL, 0x002fe2000020d400ULL,
0x0000004e2820723cULL, 0x000fe20000041820ULL, 0x0000008800277245ULL, 0x000fe4000020d400ULL,
0x0000008d2c8d723eULL, 0x000fc600000010ffULL, 0x00000080005d7306ULL, 0x0002a20000205400ULL,
0x0000002f2e00720bULL, 0x008fe20003f9d000ULL, 0x000000582814723cULL, 0x000fe20000041814ULL,
0x0000007c002f7245ULL, 0x000fe4000020d400ULL, 0x0000000149496812ULL, 0x000fc600078efcffULL,
0x0000007c00607306ULL, 0x000fe20000209400ULL, 0x0000008000807245ULL, 0x002fe2000020d400ULL,
0x0000008c2810723cULL, 0x000fe80000041810ULL, 0x000000012d2d4812ULL, 0x000fe400078efcffULL,
0x0000007c00697306ULL, 0x000e620000205400ULL, 0x0000005d5c00720bULL, 0x004fce0003f3d000ULL,
0x0000008300337306ULL, 0x000fec0000209400ULL, 0x0000000180801812ULL, 0x000fe400078efcffULL,
0x0000008300527306ULL, 0x0004e20000205400ULL, 0x000000696000720bULL, 0x002fe40003f7d000ULL,
0x000000802d4d723eULL, 0x000fca00000010ffULL, 0x0000007400727306ULL, 0x000fe20000209400ULL,
0x0000008300837245ULL, 0x004fca000020d400ULL, 0x000000012f2f3812ULL, 0x000fe400078efcffULL,
0x0000007400737306ULL, 0x0002a20000205400ULL, 0x000000523300720bULL, 0x008fe40003f5d000ULL,
0x0000004c2f4c723eULL, 0x000fca00000010ffULL, 0x0000008600877306ULL, 0x000fe20000209400ULL,
0x0000007400747245ULL, 0x002fe2000020d400ULL, 0x0000004c280c723cULL, 0x000fe8000004180cULL,
0x0000000183832812ULL, 0x000fe400078efcffULL, 0x00000086007a7306ULL, 0x0002e20000205400ULL,
0x000000737200720bULL, 0x004fe40003f3d000ULL, 0x000000488324723eULL, 0x000fca00000010ffULL,
0x0000008400537306ULL, 0x000fe20000209400ULL, 0x0000008600867245ULL, 0x002fca000020d400ULL,
0x0000000174741812ULL, 0x000fe400078efcffULL, 0x0000008400547306ULL, 0x000e620000205400ULL,
0x0000007a8700720bULL, 0x008fe40003f7d000ULL, 0x000000044a00780cULL, 0x000fca0003f25270ULL,
0x0000008500307306ULL, 0x000fec0000209400ULL, 0x0000000186863812ULL, 0x000fe400078efcffULL,
0x0000008500317306ULL, 0x000ea20000205400ULL, 0x000000545300720bULL, 0x002fce0003f9d000ULL,
0x00000088002e7306ULL, 0x000ff00000209400ULL, 0x0000008800257306ULL, 0x000e620000205400ULL,
0x000000313000720bULL, 0x004fda0003f5d000ULL, 0x0000000100002812ULL, 0x000fe400078efcffULL,
0x000000252e00720bULL, 0x002fe40003fbd000ULL, 0x0000008400257245ULL, 0x000fe4000020d400ULL,
0x000000490026723eULL, 0x000fe400000010ffULL, 0x0000000125254812ULL, 0x000fc800078efcffULL,
0x000000258625723eULL, 0x000fc600000010ffULL, 0x0000000127275812ULL, 0x000fc800078efcffULL,
0x000000277427723eULL, 0x000fe200000010ffULL, 0x000000242808723cULL, 0x040ff00000041808ULL,
0x000000262804723cULL, 0x000fe20000041804ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe12000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff457224ULL, 0x000fe200078e0043ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd22000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000003e247f8cULL, 0x000fe2000c80043fULL,
0x0000001d3d1d7220ULL, 0x040fe20000410000ULL, 0x0000001a3d267220ULL, 0x040fe20000410000ULL,
0x000000153d157220ULL, 0x040fe20000410000ULL, 0x000004003e277984ULL, 0x000e620000000800ULL,
0x0000001e3d1e7220ULL, 0x040fe20000410000ULL, 0x0000000d3d1a7220ULL, 0x040fe20000410000ULL,
0x000000203d207220ULL, 0x040fe20000410000ULL, 0x000000213d217220ULL, 0x040fe20000410000ULL,
0x000000223d227220ULL, 0x040fe20000410000ULL, 0x0000001f3d1f7220ULL, 0x040fe20000410000ULL,
0x000000143d147220ULL, 0x040fe20000410000ULL, 0x000000163d297220ULL, 0x040fe20000410000ULL,
0x000000173d2a7220ULL, 0x040fe20000410000ULL, 0x000000233d237220ULL, 0x040fe20000410000ULL,
0x000000183d187220ULL, 0x040fe20000410000ULL, 0x000000193d197220ULL, 0x040fe20000410000ULL,
0x0000001b3d287220ULL, 0x040fe20000410000ULL, 0x000000113d167220ULL, 0x040fe20000410000ULL,
0x0000000c3d177220ULL, 0x040fe20000410000ULL, 0x0000001c3d1c7220ULL, 0x040fe20000410000ULL,
0x000000103d007220ULL, 0x040fe20000410000ULL, 0x000000123d2b7220ULL, 0x040fe20000410000ULL,
0x000000133d2c7220ULL, 0x040fe20000410000ULL, 0x0000000e3d2d7220ULL, 0x040fe20000410000ULL,
0x0000000f3d2e7220ULL, 0x040fe20000410000ULL, 0x000000083d087220ULL, 0x040fe20000410000ULL,
0x000000093d097220ULL, 0x040fe20000410000ULL, 0x0000000a3d2f7220ULL, 0x040fe20000410000ULL,
0x0000000b3d307220ULL, 0x040fe20000410000ULL, 0x000000043d047220ULL, 0x040fe20000410000ULL,
0x000000053d057220ULL, 0x040fe20000410000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e001dULL,
0x000000063d067220ULL, 0x040fe20000410000ULL, 0x000000ffff117224ULL, 0x000fe200078e0015ULL,
0x000000073d077220ULL, 0x000fe20000410000ULL, 0x000000ffff157224ULL, 0x000fc400078e001aULL,
0x000000ffff1d7224ULL, 0x000fe400078e001eULL, 0x000000ffff0b7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0021ULL, 0x000000ffff107224ULL, 0x000fe200078e0014ULL,
0x8000000027ff7812ULL, 0x002fe20007804825ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0022ULL,
0x000000ffff1e7224ULL, 0x000fc400078e001fULL, 0x000000ffff0e7224ULL, 0x000fe400078e0018ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0019ULL, 0x000000ffff137224ULL, 0x000fe400078e0016ULL,
0x000000ffff147224ULL, 0x000fe400078e0017ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0023ULL,
0x000000ffff1f7224ULL, 0x000fc400078e0026ULL, 0x000000ffff207224ULL, 0x000fe400078e0028ULL,
0x000000ffff217224ULL, 0x000fe400078e0029ULL, 0x000000ffff227224ULL, 0x000fe400078e002aULL,
0x000000ffff0c7224ULL, 0x000fe400078e001cULL, 0x000000ffff127224ULL, 0x000fe400078e0000ULL,
0x000000ffff167224ULL, 0x000fc400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e0009ULL,
0x000000ffff187224ULL, 0x000fe400078e0004ULL, 0x000000ffff197224ULL, 0x000fe400078e0005ULL,
0x000000ffff237224ULL, 0x000fe400078e002bULL, 0x000000ffff267224ULL, 0x000fe400078e002cULL,
0x000000ffff277224ULL, 0x000fc400078e002dULL, 0x000000ffff287224ULL, 0x000fe400078e002eULL,
0x000000ffff297224ULL, 0x000fe400078e002fULL, 0x000000ffff2a7224ULL, 0x000fe200078e0030ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0006ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0007ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x000004003e057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004361c7824ULL, 0x000fe200078e00ffULL, 0x000000413400720cULL, 0x000fc80003f05270ULL,
0xfffffff01c057812ULL, 0x000fca00078ec0ffULL, 0x0000008002007824ULL, 0x000fca00078e0205ULL,
0x00f4000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000236087824ULL, 0x000fe400078e00ffULL, 0x0000000103427824ULL, 0x000fc600078e0a42ULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x0000000109257812ULL, 0x040fe400078efcffULL,
0x00000008092d7812ULL, 0x000fe400078efcffULL, 0x000000422500720cULL, 0x080fe40003f26070ULL,
0x0000001009257812ULL, 0x000fe400078efcffULL, 0x000000422d00720cULL, 0x080fe40003f06070ULL,
0x000000422500720cULL, 0x000fc40003fc6070ULL, 0x00000011092d7812ULL, 0x040fe400078efcffULL,
0x0000001809257812ULL, 0x040fe400078efcffULL, 0x000000420900720cULL, 0x080fe40003f46070ULL,
0x000000422d00720cULL, 0x080fe40003fa6070ULL, 0x000000422500720cULL, 0x000fe40003f66070ULL,
0x00000009092f7812ULL, 0x000fc400078efcffULL, 0x00000019092d7812ULL, 0x040fe400078efcffULL,
0x0000002009257812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x000000422f00720cULL, 0x080fe40003f86070ULL,
0x000000422d00720cULL, 0x080fe40003f46070ULL, 0x000000422500720cULL, 0x000fe40003f26070ULL,
0x00000021092d7812ULL, 0x040fe400078efcffULL, 0x0000002809257812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x000000422d00720cULL, 0x080fe40003f06070ULL, 0x000000422500720cULL, 0x000fe40003f86070ULL,
0x00000029092d7812ULL, 0x000fc400078efcffULL, 0x0000003009257812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x000000422d00720cULL, 0x000fc40003fc6070ULL, 0x000000422500720cULL, 0x000fe40003fa6070ULL,
0x00000031092d7812ULL, 0x040fe400078efcffULL, 0x0000003809257812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x000000422d00720cULL, 0x080fe40003f66070ULL,
0x000000422500720cULL, 0x000fc40003f46070ULL, 0x000000420900720cULL, 0x000fe40003f26070ULL,
0xff7fffff26267808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff27277808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff28287808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff29297808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff2b2b7808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff2c2c7808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0x0000000b04097209ULL, 0x004fe20007810000ULL, 0x0000001fff317424ULL, 0x000fe200078e00ffULL,
0x0000001a05047209ULL, 0x000fe20007810000ULL, 0xffffffffff327424ULL, 0x000fe200078e00ffULL,
0x0000000a09097209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fc40007810000ULL,
0x0000000c09087209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000000d08097209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000000e09087209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fc40007810000ULL,
0x0000000f08097209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000001009087209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fc40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x0000002304057209ULL, 0x000fe40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x0000002605047209ULL, 0x000fe40007810000ULL,
0x0000001409087209ULL, 0x000fe40007810000ULL, 0x0000002704057209ULL, 0x000fc40007810000ULL,
0x0000001508097209ULL, 0x000fe40007810000ULL, 0x0000002805047209ULL, 0x000fe40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x0000002904057209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x0000002a05047209ULL, 0x000fc40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x0000002b04057209ULL, 0x000fe40007810000ULL,
0x00000019082d7209ULL, 0x000fe40007810000ULL, 0x0000002c052f7209ULL, 0x000fe20007810000ULL,
0x000018027f007947ULL, 0x000fea000b800000ULL, 0x0c401f002d047f89ULL, 0x0004e400000e0000ULL,
0x000000042d2d7209ULL, 0x00cfe20007810000ULL, 0x000018327f007947ULL, 0x000fea000b800000ULL,
0x0c401f002f047f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006057f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007247f89ULL, 0x000f2200000e0000ULL, 0x000000042f087209ULL, 0x004fc60007810000ULL,
0x0c201f002d047f89ULL, 0x000ea200000e0000ULL, 0x0000000506097209ULL, 0x008fc60007810000ULL,
0x0c201f0008057f89ULL, 0x000ee200000e0000ULL, 0x0000002407247209ULL, 0x010fc60007810000ULL,
0x0c201f00092e7f89ULL, 0x002e6800000e0000ULL, 0x0c201f0024257f89ULL, 0x00092200000e0000ULL,
0x000000042d047209ULL, 0x004fe40007810000ULL, 0x0000000508057209ULL, 0x008fe40007810000ULL,
0x0000002e09067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fc40000000000ULL, 0x00000004ff2e7e24ULL, 0x002fe2000f8e00ffULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x3f8000002e2e783eULL, 0x000fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL,
0x000000ffff2f7224ULL, 0x000fe200078e002eULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010819ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b2c197823ULL, 0x000fe20000010819ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x000000080908723eULL, 0x002fce00000010ffULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x008fce00000010ffULL, 0x0000001d000b7308ULL, 0x0007f00000000800ULL,
0x0000001e001e7308ULL, 0x000f220000000800ULL, 0x0000001a1b09723eULL, 0x002fe200000010ffULL,
0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000b1e0b723eULL, 0x010fce00000010ffULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000002e0830723cULL, 0x000fee00000418ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ee20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000010ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x008fce00000010ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x0000001f200d723eULL, 0x002fce00000010ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x00000021220f723eULL, 0x008fce00000010ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x0000002e0c30723cULL, 0x000fee0000041830ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ee20000000800ULL,
0x000000121310723eULL, 0x002fce00000010ffULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x000000141512723eULL, 0x008fe400000010ffULL,
0xfffffffc36147812ULL, 0x000fc800078ec0ffULL, 0x000000141d1d7219ULL, 0x000fe200000006ffULL,
0x0000002700277308ULL, 0x000fe60000000800ULL, 0x000000001d1e73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f280000004000ULL, 0x0000002800287308ULL, 0x000ea20000000800ULL,
0x000000232611723eULL, 0x002fce00000010ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000272813723eULL, 0x004fce00000010ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000051dff7c12ULL, 0x008fe2000f80401eULL, 0x0000002e1030723cULL, 0x000fec0000041830ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000010ffULL, 0x0000002900297308ULL, 0x000ff00000000800ULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x000000180716723eULL, 0x004fe400000010ffULL,
0x0000002425077209ULL, 0x000fca0007810000ULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x00000019001a7308ULL, 0x000ea20000000800ULL, 0x000000292a15723eULL, 0x002fe400000010ffULL,
0x0000002b1a17723eULL, 0x004fce00000010ffULL, 0x0000002e1430723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000134204008947ULL, 0x010fde000b800000ULL,
0x001c1fff30187589ULL, 0x0002a400000e0000ULL, 0x000000001d1a73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000051dff7c12ULL, 0x008fda000f80401aULL, 0x0000136204008947ULL, 0x010fea000b800000ULL,
0x001c1fff32197589ULL, 0x00072800000e0000ULL, 0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL,
0x001c1fff001b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011636ULL,
0x0000000c1c337812ULL, 0x000fc400078ec0ffULL, 0x000000071d1e7812ULL, 0x040fe200078ec0ffULL,
0x000000081d237824ULL, 0x040fe200078e00ffULL, 0x0000001dff217212ULL, 0x000fe200078e33ffULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0x0000000336ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081d2e7824ULL, 0x040fe200078e00ffULL, 0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823207812ULL, 0x100fe400078ee21eULL, 0x000000011f227812ULL, 0x100fe200078ef61eULL,
0x000000081d4c7824ULL, 0x000fe200078e00ffULL, 0x000000021f247812ULL, 0x100fe200078ef61eULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0x000000031f267812ULL, 0x000fc400078ef61eULL,
0x000000041f287812ULL, 0x140fe400078ef61eULL, 0x000000051f2a7812ULL, 0x140fe400078ef61eULL,
0x000000061f2c7812ULL, 0x000fe200078ef61eULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee221ULL, 0x0000001dff217212ULL, 0x000fe400078e33ffULL,
0x000000071d1e7812ULL, 0x000fc400078ec0ffULL, 0x00009000021d7811ULL, 0x000fe400078e58ffULL,
0xfffffff823307812ULL, 0x100fe400078ee21eULL, 0x000000011f327812ULL, 0x140fe200078ef61eULL,
0x00000010201c7824ULL, 0x000fe200078e021dULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee221ULL,
0x0000001024207824ULL, 0x100fe200078e021dULL, 0x000000021f427812ULL, 0x140fe200078ef61eULL,
0x0000001028247824ULL, 0x100fe200078e021dULL, 0x000000031f447812ULL, 0x140fe200078ef61eULL,
0x000000102c287824ULL, 0x100fe200078e021dULL, 0x000000041f467812ULL, 0x140fe200078ef61eULL,
0x00000010322c7824ULL, 0x100fe200078e021dULL, 0x000000051f487812ULL, 0x140fe200078ef61eULL,
0x00000010422d7824ULL, 0x100fe200078e021dULL, 0x000000061f4a7812ULL, 0x000fe200078ef61eULL,
0x00000010221e7824ULL, 0x000fc400078e021dULL, 0x0000001026227824ULL, 0x100fe400078e021dULL,
0x000000102a267824ULL, 0x100fe400078e021dULL, 0x00000001331f7824ULL, 0x000fe400078e021cULL,
0x000000102e2a7824ULL, 0x100fe400078e021dULL, 0x00000010301c7824ULL, 0x100fe200078e021dULL,
0x000000081f007388ULL, 0x0003e20000000800ULL, 0x00000010442e7824ULL, 0x000fc400078e021dULL,
0x00000010462f7824ULL, 0x100fe400078e021dULL, 0x0000001048307824ULL, 0x100fe400078e021dULL,
0x000000104a317824ULL, 0x100fe400078e021dULL, 0x000000104c327824ULL, 0x000fe400078e021dULL,
0x00000001331d7824ULL, 0x040fe400078e021eULL, 0x0000000133217824ULL, 0x000fc400078e0220ULL,
0x0000000133237824ULL, 0x040fe200078e0222ULL, 0x0000000a1d007388ULL, 0x0007e20000000800ULL,
0x0000000133257824ULL, 0x040fe400078e0224ULL, 0x0000000133277824ULL, 0x040fe200078e0226ULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x0000000133297824ULL, 0x040fe400078e0228ULL,
0x00000001332b7824ULL, 0x040fe200078e022aULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x00000001331c7824ULL, 0x000fc400078e021cULL, 0x00000001332c7824ULL, 0x040fe200078e022cULL,
0x0000001025007388ULL, 0x0007e20000000800ULL, 0x00000001331e7824ULL, 0x040fe400078e022dULL,
0x00000001332e7824ULL, 0x040fe200078e022eULL, 0x0000001227007388ULL, 0x0007e20000000800ULL,
0x0000000133087824ULL, 0x042fe400078e022fULL, 0x0000000133307824ULL, 0x040fe200078e0230ULL,
0x0000001429007388ULL, 0x0007e20000000800ULL, 0x0000000133207824ULL, 0x000fc400078e0231ULL,
0x0000000133327824ULL, 0x000fe200078e0232ULL, 0x000000162b007388ULL, 0x0007e80000000800ULL,
0x000000091c007388ULL, 0x0007e80000000800ULL, 0x0000000b2c007388ULL, 0x0007e80000000800ULL,
0x0000000d1e007388ULL, 0x0007e80000000800ULL, 0x0000000f2e007388ULL, 0x0007e80000000800ULL,
0x0000001108007388ULL, 0x0007e80000000800ULL, 0x0000001330007388ULL, 0x0007e80000000800ULL,
0x0000001520007388ULL, 0x0007e80000000800ULL, 0x0000001732007388ULL, 0x0007e80000000800ULL,
0x00f0000400008388ULL, 0x0007e80000000c00ULL, 0x00f2001800008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000040ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080040ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100040ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030034347a10ULL, 0x000fe20007ffe0ffULL,
0x0000180040ff7f8cULL, 0x0003e6000c80043fULL, 0x000000373400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb61000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff257807ULL, 0x010fe40004000000ULL,
0x000164e000247802ULL, 0x000fe40000000f00ULL, 0x00000f5000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0028ULL, 0xfffeb52000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40004000000ULL, 0x0001653000247802ULL, 0x000fe40000000f00ULL,
0x00000f0000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0028ULL,
0xfffeb56000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x000fe200078e0000ULL,
0x000165a000247802ULL, 0x002fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x004fc400078e00ffULL, 0x00000e5000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e0029ULL, 0xfffeb5b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e0000ULL, 0x0001661000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x004fe400078e00ffULL,
0x00000de000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0029ULL,
0xfffeb57000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x000fe200078e0027ULL,
0x0001668000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000d7000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff957224ULL, 0x004fe200078e0029ULL, 0xfffeb8d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e004aULL, 0x000166f000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x00000d0000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff8e7224ULL, 0x004fe200078e0029ULL,
0xfffeb89000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x002fe40004000000ULL,
0x0001674000247802ULL, 0x000fc40000000f00ULL, 0x00000cf000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xfffee20000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40004000000ULL, 0x0001679000247802ULL, 0x000fc40000000f00ULL,
0x00000ca000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xfffee24000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e0029ULL,
0x0001680000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000bf000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0029ULL, 0xfffee2a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e004aULL, 0x0001687000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x00000b8000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e0029ULL,
0xfffee35000007947ULL, 0x000fea000383ffffULL, 0x0000001fff2c7424ULL, 0x000fe200078e00ffULL,
0x000168d000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x00000b2000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff9b7224ULL, 0x004fe200078e0029ULL,
0xfffee61000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e004aULL,
0x0001694000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000ab000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff927224ULL, 0x004fe200078e0029ULL, 0xfffee5c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x010fe40004000000ULL, 0x0001699000247802ULL, 0x000fe40000000f00ULL,
0x00000aa000007944ULL, 0x02afea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xffff0d6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40004000000ULL,
0x000169e000247802ULL, 0x000fe40000000f00ULL, 0x00000a5000007944ULL, 0x02afea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff0da000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x004fe200078e0029ULL, 0x00016a5000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x000009a000007944ULL, 0x02afea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e0029ULL,
0xffff0e0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e004aULL,
0x00016ac000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0000093000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0029ULL, 0xffff0eb000007947ULL, 0x000fea000383ffffULL,
0x0000001fff2c7424ULL, 0x000fe200078e00ffULL, 0x00016b2000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x000008d000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff837224ULL, 0x004fe200078e0029ULL, 0xffff116000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e004aULL, 0x00016b9000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000086000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff827224ULL, 0x004fe200078e0029ULL,
0xffff111000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x010fe40004000000ULL,
0x00016be000247802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff37f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40004000000ULL, 0x00016c3000247802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xffff383000007947ULL, 0x000fea000383ffffULL, 0x0000001fff2c7424ULL, 0x00cfe200078e00ffULL,
0x00016c9000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x0000076000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e0029ULL,
0xffff38a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x00afe200078e004aULL,
0x00016d0000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x004fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x000006f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0029ULL, 0xffff395000007947ULL, 0x000fea000383ffffULL,
0x0000001fff2c7424ULL, 0x004fe200078e00ffULL, 0x00016d6000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0000069000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6b7224ULL, 0x004fe200078e0029ULL, 0xffff3c1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e004aULL, 0x00016dd000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x004fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000062000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff6a7224ULL, 0x004fe200078e0029ULL,
0xffff3bc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff257224ULL, 0x000fe200078e002dULL,
0x00016e3000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x000fc400078e00ffULL,
0x0000058000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0025ULL,
0xffffe7b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff257224ULL, 0x000fe200078e002fULL,
0x00016e9000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000052000007944ULL, 0x020fea0003c00000ULL, 0x000000252f307209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0006ULL, 0x00016ee000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x002fc400078e00ffULL, 0x000004d000007944ULL, 0x000fea0003c00000ULL,
0x0000002506067209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0007ULL,
0x00016f3000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x0000002507247209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e002dULL, 0x00016f8000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x000000252d047209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0030ULL,
0x00016fd000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x002fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x0000002530057209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0006ULL, 0x0001702000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000002506067209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0024ULL,
0x0001707000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0xffffe67000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0030ULL, 0x000170e000247802ULL, 0x000fe20000000f00ULL,
0x000000ffff2b7224ULL, 0x000fc400078e00ffULL, 0x00001c1fff2c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fe400078e001dULL, 0x0000031000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e0029ULL, 0xffffec5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x002fe200078e0032ULL, 0x0001716000247802ULL, 0x000fe20000000f00ULL,
0x000000ffff2b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff2c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fe400078e001dULL, 0x0000029000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e00ffULL, 0x000171c000247802ULL, 0x000fe20000000f00ULL,
0x00001c1fff2c7424ULL, 0x000fc400078e00ffULL, 0x000000ffff2d7224ULL, 0x000fe400078e001dULL,
0x000000ffff197224ULL, 0x004fe400078e0029ULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2d7224ULL, 0x002fe200078e001dULL, 0x0001722000247802ULL, 0x000fe20000000f00ULL,
0x000000ffff2b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff2c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1a7224ULL, 0x004fe400078e0029ULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0029ULL, 0xffffeb9000007947ULL, 0x000fea000383ffffULL,
0x018000003e007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000003e00008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff077807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000007ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff3eff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000007ff7212ULL, 0x000fe4000780c0ffULL, 0x800000003e077812ULL, 0x000fd600078ec0ffULL,
0x0080000007000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0007ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003e00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffe8c5006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003200007348ULL, 0x000fe80003800000ULL, 0x0c00002e25257389ULL, 0x0002a200000e0031ULL,
0xfffe8c1008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff257424ULL, 0x000fe200078e00ffULL,
0x0000002d00007348ULL, 0x000fe80003800000ULL, 0x0000002b2a297389ULL, 0x0002a200000e002cULL,
0xfffe8bd024007950ULL, 0x000fea0003c3ffffULL, 0x000000012500780cULL, 0x000fe20003f05070ULL,
0x0000004800007348ULL, 0x000fd80003800000ULL, 0x0000000000257806ULL, 0x000fc800040e0100ULL,
0x0000004825287212ULL, 0x000fe200078ec0ffULL, 0x00000000ff257424ULL, 0x000fc800078e00ffULL,
0xfffe8b7024007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000370ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000950ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000009e0ULL, 0x0000000000000880ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001260ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001280ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001290ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000012b0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001340ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001348ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001358ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001580ULL, 0x0000000000017580ULL, 0xf200001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018b00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000018b10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018b10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000018f90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001340ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000177c0ULL, 0x00000000000177c0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000018b00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000018f90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_89_cubin_len = 102512;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
