/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000019010ULL, 0x0000000000018b90ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000017190ULL, 0x0000000000000180ULL,
0x000e002200000106ULL, 0x0000000000017310ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000017350ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000017390ULL,
0x0000000000000170ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000017500ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001719000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x005b200400288080ULL, 0x0000000000000000ULL, 0x000000dcffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x8c08288080860828ULL, 0x2880808e08288080ULL, 0x8092082880809008ULL, 0x0828808093082880ULL,
0x8080950828808094ULL, 0x9908288080980828ULL, 0x2880809a08288080ULL, 0x80a0082880809b08ULL,
0x08288080a1082880ULL, 0x8080a308288080a2ULL, 0xa708288080a50828ULL, 0x288080a808288080ULL,
0x80aa08288080a908ULL, 0x08288080ab082880ULL, 0x8080ae08288080acULL, 0xb008288080af0828ULL,
0x288080b108288080ULL, 0x80b408288080b308ULL, 0x08288080b6082880ULL, 0x80808808288080c4ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808892ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x0001719000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8082288080860900ULL, 0x0900000010042880ULL, 0x2880808628808088ULL, 0x000000dcffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x8808288080860828ULL, 0x2880808e08288080ULL, 0x8092082880809008ULL,
0x0828808093082880ULL, 0x8080950828808094ULL, 0x9908288080980828ULL, 0x2880809a08288080ULL,
0x80a0082880809b08ULL, 0x08288080a1082880ULL, 0x8080a308288080a2ULL, 0xa708288080a50828ULL,
0x288080a808288080ULL, 0x80aa08288080a908ULL, 0x08288080ab082880ULL, 0x8080ae08288080acULL,
0xb008288080af0828ULL, 0x288080b108288080ULL, 0x80b408288080b308ULL, 0x08288080b6082880ULL,
0x80808c08288080c4ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808c92ULL,
0x0000001cffffffffULL, 0x0000019800000000ULL, 0x0001731000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x000000dcffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8808288080860828ULL,
0x2880808c08288080ULL, 0x8090082880808e08ULL, 0x0828808092082880ULL, 0x8080940828808093ULL,
0x9808288080950828ULL, 0x2880809908288080ULL, 0x809b082880809a08ULL, 0x08288080a0082880ULL,
0x8080a208288080a1ULL, 0xa508288080a30828ULL, 0x288080a708288080ULL, 0x80a908288080a808ULL,
0x08288080aa082880ULL, 0x8080ac08288080abULL, 0xaf08288080ae0828ULL, 0x288080b108288080ULL,
0x80b408288080b308ULL, 0x08288080b6082880ULL, 0x8080b008288080c4ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080b092ULL, 0x0000001cffffffffULL, 0x000002a800000000ULL,
0x0001735000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000dcffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x8808288080860828ULL, 0x2880808c08288080ULL, 0x8090082880808e08ULL,
0x0828808092082880ULL, 0x8080940828808093ULL, 0x9808288080950828ULL, 0x2880809908288080ULL,
0x809b082880809a08ULL, 0x08288080a0082880ULL, 0x8080a208288080a1ULL, 0xa508288080a30828ULL,
0x288080a708288080ULL, 0x80a908288080a808ULL, 0x08288080aa082880ULL, 0x8080ac08288080abULL,
0xaf08288080ae0828ULL, 0x288080b008288080ULL, 0x80b408288080b108ULL, 0x08288080b6082880ULL,
0x8080b308288080c4ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080b392ULL,
0x0000002cffffffffULL, 0x000003b800000000ULL, 0x0001739000000000ULL, 0x0000017000000000ULL,
0x0000140400000000ULL, 0x80b0288080b30900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL,
0x00081204000000ffULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000eULL,
0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x000159c000015530ULL, 0x00015b40000159d0ULL,
0x00015b6000015b50ULL, 0xffffffff01602904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x05000024ffffffffULL, 0x0500002405000024ULL, 0xffffffff05000024ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01602804ffffffffULL, 0x00000110000000f0ULL, 0x00001aa000001a10ULL,
0x00001b9000001b60ULL, 0x00001f9000001f60ULL, 0x0000205000001ff0ULL, 0x00004a0000004970ULL,
0x00004bf000004ad0ULL, 0x00004f3000004f10ULL, 0x00004ff000004f90ULL, 0x000077c000007730ULL,
0x000079b000007890ULL, 0x00007ce000007cc0ULL, 0x00007da000007d40ULL, 0x0000a4a00000a410ULL,
0x0000a6900000a570ULL, 0x0000a9d00000a9b0ULL, 0x0000aa900000aa30ULL, 0x0000caa00000ca90ULL,
0x0000f1500000f060ULL, 0x0000f9800000f950ULL, 0x00015410000153e0ULL, 0x0001543000015420ULL,
0x0001547000015450ULL, 0x000154a000015490ULL, 0x00015b9000015b30ULL, 0x00015bb000015ba0ULL,
0x00016330000162d0ULL, 0x00016410000163a0ULL, 0x000164f000016480ULL, 0x000165b000016550ULL,
0x0001668000016610ULL, 0x00016750000166e0ULL, 0x00016810000167b0ULL, 0x000168e000016870ULL,
0x000169b000016940ULL, 0x00016a7000016a10ULL, 0x00016b4000016ad0ULL, 0x00016c1000016ba0ULL,
0x00016d1000016c90ULL, 0x00016df000016d80ULL, 0x00016ed000016e60ULL, 0x00016fb000016f40ULL,
0x000170a000017020ULL, 0x0001716000017100ULL, 0x000001f004c03904ULL, 0x0000f600000000ffULL,
0x00000270003f0100ULL, 0x0000f60800000003ULL, 0x000002c0003f0120ULL, 0x0000f68800000003ULL,
0x00000360003f0120ULL, 0x0000f6a800000003ULL, 0x00000390003f0120ULL, 0x0000f6c800000003ULL,
0x00000460003f0120ULL, 0x0000f600000000ffULL, 0x00000630003f0107ULL, 0x0000f68c00000008ULL,
0x000006e0003f0102ULL, 0x0000f68800000008ULL, 0x00000cb0003f0101ULL, 0x00000000000000ffULL,
0x00000d4000040107ULL, 0x00000000000000ffULL, 0x00000da000040101ULL, 0x0000002000000015ULL,
0x00000f00003f0101ULL, 0x0000000400000016ULL, 0x00000f70003f0105ULL, 0x0000002400000015ULL,
0x00000ff0003f0105ULL, 0x0000002400000015ULL, 0x00001700003f0105ULL, 0x0000000000000072ULL,
0x000017e0003f0107ULL, 0x0000000000000072ULL, 0x000017f0003f0101ULL, 0x000000040000002dULL,
0x00001860003f0105ULL, 0x0000f60800000025ULL, 0x00001880003f0101ULL, 0x0000f60c00000025ULL,
0x00001920003f0105ULL, 0x0000f60c00000013ULL, 0x00001e50003f0105ULL, 0x000000040000002dULL,
0x00001ed0003f0105ULL, 0x000000040000002dULL, 0x00004020003f0105ULL, 0x0000002000000015ULL,
0x000040a0003f0101ULL, 0x0000f68800000059ULL, 0x00004100003f0101ULL, 0x0000000400000016ULL,
0x00004150003f0105ULL, 0x0000002400000015ULL, 0x000041d0003f0105ULL, 0x0000002400000015ULL,
0x00004700003f0105ULL, 0x0000000000000064ULL, 0x00004780003f0107ULL, 0x0000000000000064ULL,
0x00004790003f0101ULL, 0x0000000400000065ULL, 0x00004800003f0105ULL, 0x0000f6280000005bULL,
0x00004820003f0101ULL, 0x0000f62c0000005bULL, 0x000048c0003f0105ULL, 0x0000f62c00000025ULL,
0x00004de0003f0105ULL, 0x0000f6ac00000012ULL, 0x00004e60003f0105ULL, 0x0000f6ac00000012ULL,
0x00006e20003f0105ULL, 0x0000002000000015ULL, 0x00006e90003f0101ULL, 0x0000f69000000059ULL,
0x00006ed0003f0101ULL, 0x0000000400000016ULL, 0x00006f20003f0105ULL, 0x0000002400000015ULL,
0x00006fa0003f0105ULL, 0x0000002400000015ULL, 0x000074d0003f0105ULL, 0x0000000000000060ULL,
0x0000755000050107ULL, 0x0000000000000060ULL, 0x0000756000050101ULL, 0x000000040000005dULL,
0x000075d000050105ULL, 0x0000f64800000025ULL, 0x000075f0003f0101ULL, 0x0000f64c00000025ULL,
0x00007680003f0105ULL, 0x0000f64c00000025ULL, 0x00007b90003f0105ULL, 0x0000f6ac0000001bULL,
0x00007c10003f0105ULL, 0x0000f6ac0000001bULL, 0x00009bb0003f0105ULL, 0x0000002000000015ULL,
0x00009c20003f0101ULL, 0x0000f69800000059ULL, 0x00009c90003f0101ULL, 0x0000000400000016ULL,
0x00009ce0003f0105ULL, 0x0000002400000015ULL, 0x00009d60003f0105ULL, 0x0000002400000015ULL,
0x0000a1a0003f0105ULL, 0x0000000000000064ULL, 0x0000a220003f0107ULL, 0x0000000000000014ULL,
0x0000a230003f0101ULL, 0x0000000400000065ULL, 0x0000a2a0003f0105ULL, 0x0000f6680000005bULL,
0x0000a2c0003f0101ULL, 0x0000f66c0000005bULL, 0x0000a360003f0105ULL, 0x0000f66c0000005bULL,
0x0000a880003f0105ULL, 0x0000f6ac00000014ULL, 0x0000a900003f0105ULL, 0x0000f6ac00000014ULL,
0x0000c810003f0105ULL, 0x0000002000000015ULL, 0x0000c870003f0101ULL, 0x0000f6a000000059ULL,
0x000106e0003f0101ULL, 0x0000f600000000ffULL, 0x000114f0003f0101ULL, 0x0000f604000000ffULL,
0x00011590003f0105ULL, 0x0000f604000000ffULL, 0x000117a0003f0105ULL, 0x0000f600000000ffULL,
0x000117b0003f0101ULL, 0x0000f604000000ffULL, 0x00011840003f0105ULL, 0x0000f604000000ffULL,
0x000148c0003f0105ULL, 0x000000000000003eULL, 0x000148f0003f0101ULL, 0x000000040000003eULL,
0x00014d00003f0105ULL, 0x000000040000003eULL, 0x00016120003f0105ULL, 0x0000000000000040ULL,
0x00016180003f0101ULL, 0x0000000800000040ULL, 0x000161e0003f0101ULL, 0x0000001000000040ULL,
0x00016250003f0101ULL, 0x0000001800000040ULL, 0x00053803003f0101ULL, 0x0001039000141c04ULL,
0x000118a0000105e0ULL, 0x0001629000011950ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000004b4ULL, 0x0000001200000002ULL, 0x00000000000003a4ULL, 0x0000001200000002ULL,
0x0000000000000294ULL, 0x0000001200000002ULL, 0x000000000000016cULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x0000000000000490ULL, 0x0000001200000002ULL,
0x0000000000000380ULL, 0x0000001200000002ULL, 0x0000000000000270ULL, 0x0000001200000002ULL,
0x0000000000000148ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x0000000000147806ULL, 0x000fe200038e0000ULL, 0x00005800ff3b7624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000001400067300ULL, 0x000ee200000e0000ULL, 0x000000083b087824ULL, 0x000fe400078e00ffULL,
0x0000000000027919ULL, 0x000ea20000002200ULL, 0x00000100ff177424ULL, 0x000fc600078e00ffULL,
0x00000000003a7919ULL, 0x000f220000002600ULL, 0x0000001400147309ULL, 0x000f660000000000ULL,
0x0000000000107919ULL, 0x000ee80000002700ULL, 0x0000000000077919ULL, 0x000ee20000000000ULL,
0x00000005ff007819ULL, 0x002fcc0000011603ULL, 0x00001fff00007589ULL, 0x000fe200000e0000ULL,
0x000000010d027824ULL, 0x004fc600078e0202ULL, 0x00001fff0d0d7589ULL, 0x000e6200000e0000ULL,
0x0000008002037824ULL, 0x000fc600078e0203ULL, 0x0000000000027919ULL, 0x000ea20000000000ULL,
0x000000083a097824ULL, 0x010fe200078e00ffULL, 0x000000ff0300720cULL, 0x040fe40003f45270ULL,
0x0000000f0300780cULL, 0x040fe20003f64070ULL, 0x00000010080a7224ULL, 0x008fe200078e0209ULL,
0x000000030300780cULL, 0x040fe40003f24070ULL, 0x0000007f0300780cULL, 0x000fe40003f84070ULL,
0x000000070600720cULL, 0x000fca0003f02070ULL, 0x3fffff80ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff05a424ULL, 0x000fe400078e00ffULL, 0x000000040d087824ULL, 0x002fe400078e0200ULL,
0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL, 0x00f60004ff00a388ULL, 0x0003e20000000a00ULL,
0x000000010300780cULL, 0x000fe20003f44070ULL, 0x00000002080b7824ULL, 0x000fe200078e00ffULL,
0x00000004ff0e7819ULL, 0x004fe20000011602ULL, 0x7fffffc0ff07b424ULL, 0x000fc400078e00ffULL,
0x3fffff60ff089424ULL, 0x000fe200078e00ffULL, 0x000000080b0c7817ULL, 0x040fe20007800000ULL,
0x000000010b0f7824ULL, 0x000fe200078e020eULL, 0x00f608060300b388ULL, 0x0005e20000008a00ULL,
0x7fffff60ff099424ULL, 0x000fe400078e00ffULL, 0x000000010a047824ULL, 0x002fe200078e020fULL,
0x000000070f137812ULL, 0x000fe200078ec0ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a0bULL,
0x00f6880803009388ULL, 0x000fe20000008a00ULL, 0xff317217ff12c424ULL, 0x000fc400078e00ffULL,
0x3fffffc0ff0aa424ULL, 0x000fe200078e00ffULL, 0x0000000c0e00720cULL, 0x000fe20003f66070ULL,
0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL, 0x00f400120300c388ULL, 0x0003e20000004800ULL,
0x3fffff80ff069424ULL, 0x004fe400078e00ffULL, 0x7fffff80ff079424ULL, 0x000fe400078e00ffULL,
0x0000001002117824ULL, 0x000fe400078e00ffULL, 0x00005c0004047625ULL, 0x000fe200078e0017ULL,
0x00f6a80603009388ULL, 0x0005e40000008a00ULL, 0x000000f011157812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x020fe200078e0a14ULL, 0x00f6c80a0300a388ULL, 0x0005e20000008a00ULL,
0x0000000f13127812ULL, 0x002fe200078e7802ULL, 0x00000004ff137424ULL, 0x000fc400078e00ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001504047210ULL, 0x000fe20007f9e0ffULL,
0x000000100f127824ULL, 0x000fe400078e0212ULL, 0x0000620010087625ULL, 0x000fc800078e0013ULL,
0x000000ffff057224ULL, 0x000fe400020e0605ULL, 0x00000010120f7824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0005e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f6040cffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000608037981ULL, 0x004ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000004ff047e24ULL, 0x002fe2000f8e00ffULL,
0x0000007f03057810ULL, 0x004fc40007ffe0ffULL, 0x000000ff03077810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff057819ULL, 0x000fe40000011605ULL, 0x00000008ff077819ULL, 0x000fca0000011607ULL,
0x0001008000008947ULL, 0x000fea0003800000ULL, 0x00000003ff067819ULL, 0x000fe20000011600ULL,
0x00000003ff0f7424ULL, 0x000fc600078e00ffULL, 0x01ffffff06097812ULL, 0x000fca00078ec0ffULL,
0x0000000204067824ULL, 0x000fe400078e0209ULL, 0xffffffffff097424ULL, 0x000fc600078e00ffULL,
0x000000050600720cULL, 0x000fda0003f06070ULL, 0x0000000210088824ULL, 0x000fe400078e00ffULL,
0x00006400ff0b8624ULL, 0x000fc800078e00ffULL, 0x00006400080b8624ULL, 0x000fe400078e020bULL,
0x0000000800087824ULL, 0x000fe400078e00ffULL, 0x00000001060b8824ULL, 0x000fe200078e020bULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c0f08ff738cULL, 0x0003e20000000000ULL,
0x000060000b0c8625ULL, 0x000fe200078e0013ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000060c098981ULL, 0x0004e2000c1e1900ULL, 0x00000001000a7812ULL, 0x000fe200078ec0ffULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000003ff137819ULL, 0x000fe20000011602ULL,
0x00f6880008ff7f8cULL, 0x0009e2000c80043fULL, 0x00000001ff0b7819ULL, 0x000fe20000011600ULL,
0x000000100a127824ULL, 0x000fe200078e00ffULL, 0x0000000413167810ULL, 0x040fe20007ffe0ffULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000001040e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000112157824ULL, 0x000fe200078e0213ULL, 0x00000008131a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008040d7824ULL, 0x004fe200078e020bULL, 0x000000070e00720cULL, 0x000fe20003f06070ULL,
0x0000000815147824ULL, 0x040fe200078e00ffULL, 0x00000002150f7212ULL, 0x082fe200078e3cffULL,
0x0000000112177824ULL, 0x000fe200078e0216ULL, 0x0000000c131e7810ULL, 0x000fe20007ffe0ffULL,
0x000000200d0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee20fULL,
0x0000000817197824ULL, 0x040fe200078e00ffULL, 0x00000002170c7212ULL, 0x000fe200078e3cffULL,
0x00000001121b7824ULL, 0x040fe200078e021aULL, 0x0000000e030f7217ULL, 0x000fe20007800000ULL,
0x00000001121d7824ULL, 0x000fe200078e021eULL, 0xfffffff819187812ULL, 0x000fe200078ee20cULL,
0x000000803a0c7824ULL, 0x000fe200078e00ffULL, 0x000000021b1c7212ULL, 0x080fe200078e3cffULL,
0x000000010f0f7824ULL, 0x100fe200078e0a0eULL, 0x000000021d207212ULL, 0x000fe200078e3cffULL,
0x000020000b0d7824ULL, 0x000fe200078e00ffULL, 0x000000600c0e7812ULL, 0x000fe200078ef80eULL,
0x000000081b217824ULL, 0x000fe200078e00ffULL, 0x000000200f0f7807ULL, 0x000fe20000000000ULL,
0x000000000b0473c2ULL, 0x000e6200000e0000ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x000000010e157824ULL, 0x040fe200078e0215ULL, 0x000000120f0f7217ULL, 0x000fe20007800000ULL,
0x000000010e197824ULL, 0x040fe200078e0217ULL, 0x0000b0000d177810ULL, 0x000fe20007ffe0ffULL,
0x000000010e1f7824ULL, 0x040fe200078e021bULL, 0xfffffff8211c7812ULL, 0x000fe200078ee21cULL,
0x000000010e237824ULL, 0x000fe200078e021dULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x000000010f0f7824ULL, 0x000fe200078e0a12ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x000000081d1d7824ULL, 0x000fe200078e00ffULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000010141b7824ULL, 0x100fe200078e0217ULL, 0x0000000f1300720cULL, 0x080fe20003f66070ULL,
0x000000101c217824ULL, 0x100fe200078e0217ULL, 0x0000000f1a00720cULL, 0x080fe20003f26070ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0xfffffff81d207812ULL, 0x000fe200078ee220ULL,
0x00000010181d7824ULL, 0x100fe200078e0217ULL, 0x0000000f1600720cULL, 0x080fe20003f46070ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000000f1e00720cULL, 0x000fe20003f06070ULL,
0x0000001020257824ULL, 0x000fe200078e0217ULL, 0x0000f6a804047891ULL, 0x002fe2000f8e203fULL,
0x00005800090e7a24ULL, 0x008fc800078e02ffULL, 0x000000800e0e7824ULL, 0x000fca00078e00ffULL,
0x000000150e137210ULL, 0x040fe40007f9e0ffULL, 0x000000190e197210ULL, 0x040fe40007fde0ffULL,
0x00005e00131a7a11ULL, 0x000fe200078a38ffULL, 0x000000ffff147224ULL, 0x000fe200020e06ffULL,
0x00005e0019157a11ULL, 0x000fe200078838ffULL, 0x000000ffff127224ULL, 0x000fe200030e06ffULL,
0x0000001f0e1f7210ULL, 0x000fe40007fde0ffULL, 0x00005f0013137a11ULL, 0x000fc400028f3c14ULL,
0x000000230e0e7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff147224ULL, 0x000fe200030e06ffULL,
0x00005f0019177a11ULL, 0x000fe400020f3c12ULL, 0x0000007011197812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0f7224ULL, 0x000fe200028e06ffULL, 0x00005e001f167a11ULL, 0x000fe400078838ffULL,
0x0000001a19127210ULL, 0x000fe40007fbe0ffULL, 0x00005f001f117a11ULL, 0x000fc400020f3c14ULL,
0x0000001915147210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff137224ULL, 0x000fe200028e0613ULL,
0x00005e000e187a11ULL, 0x000fe400078c38ffULL, 0x0000001916167210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff157224ULL, 0x000fe200020e0617ULL, 0x00005f000e0e7a11ULL, 0x000fe200030f3c0fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000121b7faeULL, 0x0009e2000d901c46ULL,
0x0000001918187210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff177224ULL, 0x000fe400028e0611ULL,
0x00000000141d7faeULL, 0x0003e2000d101c46ULL, 0x000000ffff0f7224ULL, 0x000fc400078e00ffULL,
0x000000ffff197224ULL, 0x000fe200020e060eULL, 0x0000000016217faeULL, 0x0009e2000c901c46ULL,
0x000000070400720cULL, 0x000fe20003f26070ULL, 0xff317217ff0e7424ULL, 0x000fe400078e00ffULL,
0x0000000018257faeULL, 0x0009e8000c101c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000f6a80b157811ULL, 0x002fc600078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff127f8cULL, 0x010e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200015187f8cULL, 0x0004e2000c80043fULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000002015167810ULL, 0x000fe20007ffe0ffULL,
0x0000baa000001947ULL, 0x000fea0003800000ULL, 0x0000000210187824ULL, 0x00cfe400078e00ffULL,
0x00006400ff117624ULL, 0x000fc400078e00ffULL, 0x000000ffff177224ULL, 0x002fe400078e0013ULL,
0x000000ffff317224ULL, 0x000fe400078e0019ULL, 0x0000640018187624ULL, 0x000fe400078e0211ULL,
0xff317217ff0e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff147224ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc400078e00ffULL, 0x0000010004107824ULL, 0x000fca00078e00ffULL,
0x000000031000720cULL, 0x000fda0003f06070ULL, 0x0000b9b000000947ULL, 0x022fea0003800000ULL,
0x0000040016107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x000000ffff197224ULL, 0x000fe400078e0006ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0014ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000240015107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL,
0x0000000b00107305ULL, 0x0002a4000021f000ULL, 0x3fa000000b0b7823ULL, 0x002fe200000100ffULL,
0x000000100000735dULL, 0x004fe40003800000ULL, 0x0000240015107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300ff1b7624ULL, 0x000fe200078e00ffULL, 0x00000001060b7812ULL, 0x000fe200078ec0ffULL,
0x0000580009137a24ULL, 0x000fe200078e02ffULL, 0x00000003ff277819ULL, 0x000fe20000011602ULL,
0xffffffffff097424ULL, 0x000fe200078e00ffULL, 0x000000010b00780cULL, 0x000fc40003f05070ULL,
0xffffffff1b1b7811ULL, 0x000fc800078e08ffULL, 0x000000011b1b7807ULL, 0x000fca0004000000ULL,
0x0000000106067824ULL, 0x000fca00078e021bULL, 0x000000050600720cULL, 0x000fe20003f06070ULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x00000004272f7810ULL, 0x000fe20007ffe0ffULL,
0x00000100041c7824ULL, 0x000fc600078e00ffULL, 0x000000100b1e7812ULL, 0x000fce00078ec0ffULL,
0x0000001b18108210ULL, 0x000fe20007ffe019ULL, 0x00000004ff118424ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc60000011600ULL, 0x0000600010108625ULL, 0x000fc800078e0011ULL,
0x000000012f1f7824ULL, 0x100fe200078e021eULL, 0x0000000610098981ULL, 0x000362000c1e1900ULL,
0x0000000827317810ULL, 0x040fe20007ffe0ffULL, 0x00000001271d7824ULL, 0x100fe200078e021eULL,
0x0000000104127810ULL, 0x000fe20007ffe0ffULL, 0x00000080132b7824ULL, 0x000fe200078e00ffULL,
0x000000021f687212ULL, 0x080fe200078e3cffULL, 0x0000000131217824ULL, 0x000fe200078e021eULL,
0x000000071200720cULL, 0x000fe20003f06070ULL, 0x000000081d207824ULL, 0x000fe200078e00ffULL,
0x0000000c27337810ULL, 0x000fe20007ffe0ffULL, 0x000000200b107824ULL, 0x002fe200078e021cULL,
0x0000000221697212ULL, 0x080fe200078e3cffULL, 0x000000081f117824ULL, 0x000fe200078e00ffULL,
0x000000021d677212ULL, 0x000fe200078e3cffULL, 0x0000000821127824ULL, 0x000fe200078e00ffULL,
0x0000004010107810ULL, 0x000fe20007ffe0ffULL, 0x0000000133237824ULL, 0x000fe200078e021eULL,
0xfffffff811687812ULL, 0x000fe200078ee268ULL, 0x00000010022c7824ULL, 0x000fe200078e00ffULL,
0x0000001003117217ULL, 0x000fe20007800000ULL, 0x0000000823257824ULL, 0x040fe200078e00ffULL,
0xfffffff812697812ULL, 0x000fe200078ee269ULL, 0x000004d000007945ULL, 0x000fe20003800000ULL,
0x00000002236a7212ULL, 0x000fe200078e3cffULL, 0x0000000111117824ULL, 0x100fe200078e0a10ULL,
0x000000600c107812ULL, 0x000fc400078ef810ULL, 0xfffffff820677812ULL, 0x000fe400078ee267ULL,
0xfffffff8256a7812ULL, 0x000fe200078ee26aULL, 0x0000000110127824ULL, 0x040fe200078e021dULL,
0x0000002011117807ULL, 0x000fe20000000000ULL, 0x0000000110137824ULL, 0x000fe200078e021fULL,
0x000000702c2d7812ULL, 0x000fe200078ec0ffULL, 0x0000000110207824ULL, 0x040fe200078e0221ULL,
0x000000122b127210ULL, 0x040fe20007f5e0ffULL, 0x0000000110107824ULL, 0x000fe200078e0223ULL,
0x000000132b257210ULL, 0x000fc40007f7e0ffULL, 0x0000001e11117217ULL, 0x000fe20007800000ULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x00005e0012247a11ULL, 0x000fe400078438ffULL,
0x000000202b207210ULL, 0x000fe20007f9e0ffULL, 0x0000000111227824ULL, 0x000fe200078e0a1eULL,
0x000000102b2b7210ULL, 0x000fe20007f1e0ffULL, 0x0000100014107824ULL, 0x000fe200078e00ffULL,
0x00005f0012287a11ULL, 0x000fe200010f3c13ULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x00005e0025137a11ULL, 0x000fc400078438ffULL, 0x0000100010107812ULL, 0x000fe400078e0cffULL,
0x00005f0025257a11ULL, 0x000fe200010f3c12ULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x000000222700720cULL, 0x000fe20003f46070ULL, 0x000000ffff277224ULL, 0x000fe200020e06ffULL,
0x00005e0020267a11ULL, 0x040fe200078638ffULL, 0x000020000b117824ULL, 0x000fe200078e0210ULL,
0x00005e002b2a7a11ULL, 0x000fe400078038ffULL, 0x00005f0020277a11ULL, 0x000fc400018f3c27ULL,
0x0000002d24107210ULL, 0x080fe40007f7e0ffULL, 0x0000b00011247810ULL, 0x000fe40007ffe0ffULL,
0x00005f002b2b7a11ULL, 0x000fe200000f3c12ULL, 0x000000ffff117224ULL, 0x000fe200018e0628ULL,
0x0000002d13127210ULL, 0x080fe20007fbe0ffULL, 0x00000010671e7824ULL, 0x100fe200078e0224ULL,
0x000000222f00720cULL, 0x080fe20003f06070ULL, 0x0000001068207824ULL, 0x100fe200078e0224ULL,
0x0000002d26267210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff137224ULL, 0x000fe200028e0625ULL,
0x0000002d2a2a7210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101e7faeULL, 0x0003e2000d101c46ULL, 0x000000223100720cULL, 0x080fe20003f46070ULL,
0x00000008142d7824ULL, 0x000fe200078e00ffULL, 0x000000223300720cULL, 0x000fe20003fa6070ULL,
0x000000ffff277224ULL, 0x000fe200018e0627ULL, 0xfffffff008227812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2b7224ULL, 0x000fe200020e062bULL, 0x000000082d257812ULL, 0x000fe200078e0cffULL,
0x0000000012207faeULL, 0x0005e2000c101c46ULL, 0x0000f6a822287810ULL, 0x000fe20007ffe0ffULL,
0x0000001069227824ULL, 0x100fe200078e0224ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x000000106a247824ULL, 0x000fe200078e0224ULL, 0xffffffe008107812ULL, 0x002fe200078ec0ffULL,
0x0000000128727824ULL, 0x000fe200078e0225ULL, 0x0000000026227faeULL, 0x0003e2000d101c46ULL,
0x0000001008117812ULL, 0x000fc600078ec0ffULL, 0x000000002a247faeULL, 0x0003e4000e901c46ULL,
0x0000000110137824ULL, 0x004fe200078e0211ULL, 0x0000000808107812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000113257824ULL, 0x000fe400078e0210ULL,
0x00000000720403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001282d7824ULL, 0x000fe200078e022dULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000072727f8cULL, 0x000ea8000c80043fULL, 0x000004002d127984ULL, 0x0007220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080025107f8cULL, 0x000fe2000c80043fULL, 0x8000000012ff7812ULL, 0x010fc60007844817ULL,
0x00f60c0025277984ULL, 0x002e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x000000080a137824ULL, 0x000fe400078e0213ULL,
0x3e000000ff127424ULL, 0x000fc800078e00ffULL, 0x0000001200267305ULL, 0x000324000021f000ULL,
0x3fa0000012127823ULL, 0x002fe200000100ffULL, 0x000000260000735dULL, 0x010fe20003800000ULL,
0x00f60c0013277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fc40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000267824ULL, 0x000fe200078e00ffULL,
0x00000001ff287819ULL, 0x000fe40000011602ULL, 0x000000702c277812ULL, 0x000fe400078ec0ffULL,
0xffffff8026267812ULL, 0x000fe400078ec0ffULL, 0x0000000c28287812ULL, 0x000fc800078ec0ffULL,
0x0000002628107210ULL, 0x000fca0007ffe027ULL, 0x00f0000010117984ULL, 0x000e680000000800ULL,
0x00f2000010127984ULL, 0x0008e20000000800ULL, 0x0000000e1100720bULL, 0x002fe20003f1d000ULL,
0x000148927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x010fc800000e0100ULL,
0x0000ffff102a7812ULL, 0x000fe2000780c0ffULL, 0x000003e000007945ULL, 0x000fe20003800000ULL,
0x00000001ff927424ULL, 0x000fd600078e00ffULL, 0x000003b000008947ULL, 0x000fea0003800000ULL,
0x00000002ff137819ULL, 0x000fe40000011600ULL, 0x0000000e1100720bULL, 0x000fe40003f14000ULL,
0x000000001300720cULL, 0x000fe20003f65270ULL, 0x000148627f007947ULL, 0x000ff4000b800000ULL,
0x0000000000107806ULL, 0x000fe400000e0100ULL, 0x000000800013b824ULL, 0x000fe200078e0227ULL,
0x000000110e2c7209ULL, 0x000fe40007810000ULL, 0x0000ffff102b7812ULL, 0x000fe200078e3cffULL,
0x000000012813b824ULL, 0x000fe200078e0213ULL, 0x00000002ff107819ULL, 0x000fe20000011602ULL,
0x8000002c0e0e7221ULL, 0x000fe20000010000ULL, 0x0000002b2aff7212ULL, 0x000fc4000780c0ffULL,
0x00f4002c1300b388ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0e0e7820ULL, 0x000fc80000410000ULL,
0x0000000e00337308ULL, 0x0003220000000800ULL, 0x000148027f007947ULL, 0x000fea000b800000ULL,
0x00001f10330e7589ULL, 0x01232400000e0000ULL, 0x0000000810107810ULL, 0x002fe20007ffe0ffULL,
0x000148427f007947ULL, 0x000fea000b800000ULL, 0x00001f1033107589ULL, 0x00032400000e0000ULL,
0x8000002c11110221ULL, 0x000fe20000010000ULL, 0x00000001ff927807ULL, 0x000fe20000000000ULL,
0x0000000e39397220ULL, 0x090fe40000410000ULL, 0x3fb8aa3b11110820ULL, 0x000fe40000410000ULL,
0x0000000e38387220ULL, 0x080fe40000410000ULL, 0x0000001100290308ULL, 0x000f220000000800ULL,
0x0000000e3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000e3c3c7220ULL, 0x080fe40000410000ULL,
0x0000000e41417220ULL, 0x080fe40000410000ULL, 0x0000000e40407220ULL, 0x080fe40000410000ULL,
0x0000000e45457220ULL, 0x080fe40000410000ULL, 0x0000000e44447220ULL, 0x080fe40000410000ULL,
0x0000000e49497220ULL, 0x000fc40000410000ULL, 0x0000000e48487220ULL, 0x080fe40000410000ULL,
0x0000000e4d4d7220ULL, 0x080fe40000410000ULL, 0x0000000e4c4c7220ULL, 0x080fe40000410000ULL,
0x0000000e51517220ULL, 0x080fe40000410000ULL, 0x0000000e50507220ULL, 0x080fe40000410000ULL,
0x0000000e55557220ULL, 0x000fc40000410000ULL, 0x0000000e54547220ULL, 0x000fe40000410000ULL,
0x000000330f0f7220ULL, 0x000fe40000410000ULL, 0x000000103b3b7220ULL, 0x080fe40000410000ULL,
0x000000103a3a7220ULL, 0x080fe40000410000ULL, 0x000000103f3f7220ULL, 0x080fe40000410000ULL,
0x000000103e3e7220ULL, 0x000fc40000410000ULL, 0x0000001043437220ULL, 0x080fe40000410000ULL,
0x0000001042427220ULL, 0x080fe40000410000ULL, 0x0000001047477220ULL, 0x080fe40000410000ULL,
0x0000001046467220ULL, 0x080fe40000410000ULL, 0x000000104b4b7220ULL, 0x080fe40000410000ULL,
0x000000104a4a7220ULL, 0x000fc40000410000ULL, 0x000000104f4f7220ULL, 0x080fe40000410000ULL,
0x000000104e4e7220ULL, 0x080fe40000410000ULL, 0x0000001053537220ULL, 0x080fe40000410000ULL,
0x0000001052527220ULL, 0x080fe40000410000ULL, 0x0000001057577220ULL, 0x080fe40000410000ULL,
0x0000001056567220ULL, 0x000fc40000410000ULL, 0x000000ffff0e7224ULL, 0x000fe400078e002cULL,
0x0000002912120220ULL, 0x018fe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000000f120f7221ULL, 0x008fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x000004002d107984ULL, 0x000ee40000000800ULL,
0x8000000010ff7812ULL, 0x008fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x000724000021f000ULL, 0x3fa0000010107823ULL, 0x008fe200000100ffULL,
0x000000110000735dULL, 0x010fe20003800000ULL, 0x000004002d127984ULL, 0x000ee40000000800ULL,
0x8000000012ff7812ULL, 0x008fc40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000029ff10723eULL, 0x000fe400000010ffULL, 0x00000002ff127819ULL, 0x000fe40000011602ULL,
0x0000541010337816ULL, 0x002fe20000000010ULL, 0x000144e27f007947ULL, 0x000fea000b800000ULL,
0x00001f1233c17589ULL, 0x0002e400000e0000ULL, 0x00000008122a7810ULL, 0x000fe20007ffe0ffULL,
0x000145227f007947ULL, 0x000fea000b800000ULL, 0x00001f2a33be7589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001012347810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x0000200000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0001535000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001812347810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x0000206000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x000152f000007944ULL, 0x03cfea0003c00000ULL,
0x0000000200597824ULL, 0x000fe200078e00ffULL, 0x0000000702df7812ULL, 0x000fe200078ec0ffULL,
0x0000020000587824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000000459117812ULL, 0x000fc400078ec0ffULL, 0x00000008dfdf7812ULL, 0x000fe400078ef802ULL,
0x0000001102807211ULL, 0x000fe400078fe0ffULL, 0xfffff80058587812ULL, 0x000fe400078ec0ffULL,
0x0000000780107812ULL, 0x000fe400078e78dfULL, 0x0000000802117812ULL, 0x000fc600078ec0ffULL,
0x00000008df2b7824ULL, 0x000fc800078e0210ULL, 0x000000102b2b7824ULL, 0x000fe400078e0258ULL,
0x0000000400107824ULL, 0x000fe200078e00ffULL, 0x0000000280807810ULL, 0x000fe20007ffe0ffULL,
0x0000100000127824ULL, 0x002fe200078e00ffULL, 0x0000991092927816ULL, 0x000fe400000000ffULL,
0x0000000410137812ULL, 0x000fe400078ec0ffULL, 0xffffe00012177812ULL, 0x000fe400078ec0ffULL,
0x0000000711107812ULL, 0x140fe400078ec802ULL, 0x0000001302137211ULL, 0x000fe200078fe0ffULL,
0x0000100014177824ULL, 0x000fe200078e0217ULL, 0x0000000711117812ULL, 0x000fc400078ef802ULL,
0x0000001310127212ULL, 0x000fe400078e3cffULL, 0x0000b000172f7810ULL, 0x000fe20007ffe0ffULL,
0x0000100014177824ULL, 0x000fe200078e020dULL, 0x0000000213137810ULL, 0x000fe20007ffe0ffULL,
0x00000008112c7824ULL, 0x040fe200078e0212ULL, 0x0000008011637811ULL, 0x000fe400078e18ffULL,
0x0000001310647212ULL, 0x000fe200078e3cffULL, 0x000000102c347824ULL, 0x000fe200078e022fULL,
0x0000b00017667810ULL, 0x000fe20007ffe0ffULL, 0x00000001122d7824ULL, 0x000fc400078e0263ULL,
0x00000008112e7824ULL, 0x000fe400078e0264ULL, 0x000000003434783bULL, 0x000e620000004200ULL,
0x000000102d307824ULL, 0x000fe400078e0266ULL, 0x000000102e107824ULL, 0x000fc800078e022fULL,
0x000000003030783bULL, 0x014ea20000004200ULL, 0x00000018ff127819ULL, 0x002fe20000011434ULL,
0x0000003400f87306ULL, 0x000fe20000009400ULL, 0x00000018ff2f7819ULL, 0x000fe40000011437ULL,
0x00000018ff5d7819ULL, 0x000fe40000011436ULL, 0x00000018ff5c7819ULL, 0x000fe40000011435ULL,
0x00000018ff617819ULL, 0x004fe20000011431ULL, 0x0000001200f47306ULL, 0x000fe20000209400ULL,
0x00000018ff5f7819ULL, 0x000fc40000011430ULL, 0x00000018ff657819ULL, 0x000fe40000011433ULL,
0x00000018ff627819ULL, 0x000fc60000011432ULL, 0x00000012009b7306ULL, 0x000e700000205400ULL,
0x0000001200b27306ULL, 0x000530000020d400ULL, 0x0000002f008e7306ULL, 0x000fe20000209400ULL,
0x000000001010783bULL, 0x004ea20000004200ULL, 0x0000009bf400720bULL, 0x002fcc0003f9d000ULL,
0x0000002f00d77306ULL, 0x000fee0000205400ULL, 0x00000001b2b24812ULL, 0x010fe200078efcffULL,
0x0000002f00a37306ULL, 0x0003f0000020d400ULL, 0x0000003400a77306ULL, 0x000f220000005400ULL,
0x00000100342f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x0000003400b97306ULL, 0x0002f0000000d400ULL, 0x0000002f00f77306ULL, 0x000fe20000209400ULL,
0x0001000034347824ULL, 0x002fe200078e00ffULL, 0x000000a7f800720bULL, 0x010fe20003f1d000ULL,
0x0000010013987824ULL, 0x004fc600078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000002f008a7306ULL, 0x000e620000205400ULL, 0x00000018ffdd7819ULL, 0x000fcc0000011498ULL,
0x00000001b9b90812ULL, 0x008fe200078efcffULL, 0x0000002f00c87306ULL, 0x0004f0000020d400ULL,
0x0000003400f57306ULL, 0x000fe20000209400ULL, 0x00000100362f7824ULL, 0x004fe200078e00ffULL,
0x0000008af700720bULL, 0x002fc80003f5d000ULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x0000003400a87306ULL, 0x000e6e0000205400ULL, 0x00000001c8c82812ULL, 0x008fe200078efcffULL,
0x0000003400b77306ULL, 0x0004f0000020d400ULL, 0x0000002f00817306ULL, 0x000fe20000209400ULL,
0x0000010037347824ULL, 0x004fe200078e00ffULL, 0x000000a8f500720bULL, 0x002fc80003fbd000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000002f00ec7306ULL, 0x000fee0000205400ULL,
0x00000001b7b75812ULL, 0x008fe200078efcffULL, 0x0000002f00af7306ULL, 0x0003f0000020d400ULL,
0x0000005d008d7306ULL, 0x000fe20000209400ULL, 0x00000018ff2f7819ULL, 0x002fce0000011410ULL,
0x0000005d00e07306ULL, 0x000ff00000205400ULL, 0x0000005d00a47306ULL, 0x000ff0000020d400ULL,
0x0000006100b37306ULL, 0x000ff00000209400ULL, 0x0000006100b47306ULL, 0x000ff00000205400ULL,
0x00000061005d7306ULL, 0x0003f0000020d400ULL, 0x0000003500f67306ULL, 0x000fe20000009400ULL,
0x0000010035617824ULL, 0x002fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x00000035007d7306ULL, 0x000e700000005400ULL, 0x0000003500937306ULL, 0x0004f0000000d400ULL,
0x0000002f00e37306ULL, 0x000fe20000209400ULL, 0x0001000035357824ULL, 0x004fe200078e00ffULL,
0x0000007df600720bULL, 0x002fc80003f7d000ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000002f00e47306ULL, 0x000fee0000205400ULL, 0x0000000193933812ULL, 0x008fe200078efcffULL,
0x0000002f00907306ULL, 0x0003f0000020d400ULL, 0x0000003400e57306ULL, 0x000fe20000209400ULL,
0x00000100302f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x0000003400e67306ULL, 0x000e700000205400ULL, 0x0000003400b07306ULL, 0x0004f0000020d400ULL,
0x00000036007e7306ULL, 0x000fe20000009400ULL, 0x00000018ff347819ULL, 0x004fc40000011411ULL,
0x000000e6e500720bULL, 0x002fca0003f7d000ULL, 0x0000003600ef7306ULL, 0x000e700000005400ULL,
0x0000003600ac7306ULL, 0x000522000000d400ULL, 0x00000001b0b03812ULL, 0x008fce00078efcffULL,
0x0000005c007f7306ULL, 0x000fe20000209400ULL, 0x0001000036367824ULL, 0x004fe200078e00ffULL,
0x000000ef7e00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000005c00847306ULL, 0x000e6e0000205400ULL, 0x00000001acac2812ULL, 0x010fe200078efcffULL,
0x0000005c00b17306ULL, 0x000ea2000020d400ULL, 0x000000d78e00720bULL, 0x000fce0003f5d000ULL,
0x0000005f00bb7306ULL, 0x000fe20000209400ULL, 0x000000847f00720bULL, 0x002fca0003f9d000ULL,
0x00000001a3a32812ULL, 0x000fe400078efcffULL, 0x0000005f00ba7306ULL, 0x000fec0000205400ULL,
0x00000001b1b14812ULL, 0x004fe400078efcffULL, 0x0000005f005c7306ULL, 0x000fe2000020d400ULL,
0x000000e08d00720bULL, 0x000fce0003f9d000ULL, 0x0000003500f17306ULL, 0x000fec0000209400ULL,
0x00000001a4a44812ULL, 0x000fe400078efcffULL, 0x0000003500f27306ULL, 0x000e700000205400ULL,
0x0000003500b87306ULL, 0x0004f0000020d400ULL, 0x0000003400e17306ULL, 0x000fe20000209400ULL,
0x00000018ff357819ULL, 0x004fc40000011412ULL, 0x000000f2f100720bULL, 0x002fca0003fbd000ULL,
0x0000003400e27306ULL, 0x000ff00000205400ULL, 0x00000034008f7306ULL, 0x0003e2000020d400ULL,
0x00000001b8b85812ULL, 0x008fce00078efcffULL, 0x00000037008c7306ULL, 0x000fe20000009400ULL,
0x0000010031347824ULL, 0x002fce00078e00ffULL, 0x00000037008b7306ULL, 0x000e700000005400ULL,
0x0000003700ab7306ULL, 0x0004f0000000d400ULL, 0x0000006500967306ULL, 0x000fe20000209400ULL,
0x0001000037377824ULL, 0x004fe200078e00ffULL, 0x0000008b8c00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000006500957306ULL, 0x000fee0000205400ULL,
0x00000001abab0812ULL, 0x008fe200078efcffULL, 0x00000065005f7306ULL, 0x000ff0000020d400ULL,
0x0000002f00cd7306ULL, 0x000ff00000209400ULL, 0x0000002f00d07306ULL, 0x000ff00000205400ULL,
0x0000002f00657306ULL, 0x0003f0000020d400ULL, 0x0000003500c97306ULL, 0x000fe20000209400ULL,
0x00000001642f7824ULL, 0x002fc400078e0263ULL, 0x0000010032637824ULL, 0x000fca00078e00ffULL,
0x0000003500cc7306ULL, 0x000fe20000205400ULL, 0x00000018ff6c7819ULL, 0x000fce0000011463ULL,
0x00000035007c7306ULL, 0x0003f0000020d400ULL, 0x0000003600e77306ULL, 0x000fe20000209400ULL,
0x00000018ff357819ULL, 0x002fe20000011434ULL, 0x000000102f347824ULL, 0x000fcc00078e0266ULL,
0x0000003600e87306ULL, 0x000e700000205400ULL, 0x0000003600a97306ULL, 0x0004f0000020d400ULL,
0x0000006200947306ULL, 0x000fe20000209400ULL, 0x00000018ff367819ULL, 0x004fc40000011413ULL,
0x000000e8e700720bULL, 0x002fca0003fbd000ULL, 0x0000006200917306ULL, 0x000ff00000205400ULL,
0x00000062005e7306ULL, 0x000fe2000020d400ULL, 0x00000001a9a95812ULL, 0x008fce00078efcffULL,
0x0000003700e97306ULL, 0x000ff00000209400ULL, 0x0000003700ea7306ULL, 0x000ff00000205400ULL,
0x0000003700aa7306ULL, 0x000ff0000020d400ULL, 0x0000003600cb7306ULL, 0x000ff00000209400ULL,
0x0000003600ce7306ULL, 0x000ff00000205400ULL, 0x00000036007b7306ULL, 0x000ff0000020d400ULL,
0x0000003500cf7306ULL, 0x000ff00000209400ULL, 0x0000003500d27306ULL, 0x000ff00000205400ULL,
0x0000003500627306ULL, 0x0003f0000020d400ULL, 0x0000003000c37306ULL, 0x000fe20000009400ULL,
0x000000003434783bULL, 0x002e6e0000004200ULL, 0x0000003000c07306ULL, 0x000ff00000005400ULL,
0x0000003000607306ULL, 0x0005f0000000d400ULL, 0x00000061009c7306ULL, 0x000fe20000209400ULL,
0x0001000030307824ULL, 0x004fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000006100f37306ULL, 0x000eb00000205400ULL, 0x0000006100c67306ULL, 0x000ee2000020d400ULL,
0x00000018ff977819ULL, 0x002fce0000011435ULL, 0x0000003000c77306ULL, 0x000fe20000209400ULL,
0x000000f39c00720bULL, 0x004fce0003fdd000ULL, 0x0000003000ca7306ULL, 0x000fec0000205400ULL,
0x00000001c6c66812ULL, 0x008fe400078efcffULL, 0x0000003000617306ULL, 0x0003e2000020d400ULL,
0x000000ec8100720bULL, 0x000fe40003fdd000ULL, 0x00000093c693723eULL, 0x000fca00000010ffULL,
0x0000003100c57306ULL, 0x000fe20000009400ULL, 0x0000010033307824ULL, 0x002fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003100c27306ULL, 0x000fe20000005400ULL,
0x00000001afaf6812ULL, 0x000fe400078efcffULL, 0x000000eae900720bULL, 0x000fca0003fdd000ULL,
0x0000003100177306ULL, 0x0003f0000000d400ULL, 0x0000003000a57306ULL, 0x000fe20000209400ULL,
0x0001000031317824ULL, 0x002fe200078e00ffULL, 0x00000001aaaa6812ULL, 0x000fc400078efcffULL,
0x000000e4e300720bULL, 0x000fe40003fdd000ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003000a67306ULL, 0x000ff00000205400ULL, 0x0000003000667306ULL, 0x0003e2000020d400ULL,
0x0000000190906812ULL, 0x000fc400078efcffULL, 0x000000ccc900720bULL, 0x000fca0003fdd000ULL,
0x0000003100b57306ULL, 0x000fe20000209400ULL, 0x0000010010307824ULL, 0x002fca00078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011430ULL, 0x0000010011307824ULL, 0x000fe200078e00ffULL,
0x0000003100b67306ULL, 0x000fe20000205400ULL, 0x000000017c7c6812ULL, 0x000fce00078efcffULL,
0x0000003100647306ULL, 0x0003f0000020d400ULL, 0x0000009700707306ULL, 0x000fe20000209400ULL,
0x00000018ff317819ULL, 0x002fce0000011434ULL, 0x0000009700717306ULL, 0x000ff00000205400ULL,
0x0000009700747306ULL, 0x0003f0000020d400ULL, 0x0000003200bc7306ULL, 0x000fe20000009400ULL,
0x00000018ff977819ULL, 0x002fce0000011430ULL, 0x0000003200bf7306ULL, 0x000e700000005400ULL,
0x00000032005a7306ULL, 0x0004f0000000d400ULL, 0x0000003300bd7306ULL, 0x000fe20000009400ULL,
0x0001000032327824ULL, 0x004fe200078e00ffULL, 0x000000bfbc00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003300c47306ULL, 0x000fee0000005400ULL,
0x000000015a5a6812ULL, 0x008fe200078efcffULL, 0x00000033005b7306ULL, 0x0003f0000000d400ULL,
0x00000031006d7306ULL, 0x000fe20000209400ULL, 0x0001000033337824ULL, 0x002fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x00000031006e7306ULL, 0x000ff00000205400ULL,
0x00000031006f7306ULL, 0x000ff0000020d400ULL, 0x0000009700307306ULL, 0x000ff00000209400ULL,
0x0000009700317306ULL, 0x000e700000205400ULL, 0x0000001000d97306ULL, 0x000ff00000009400ULL,
0x0000001000da7306ULL, 0x000ea20000005400ULL, 0x000000313000720bULL, 0x002fce0003f9d000ULL,
0x0000001000867306ULL, 0x0002f0000000d400ULL, 0x0000001100827306ULL, 0x000fe20000009400ULL,
0x0001000010107824ULL, 0x002fe200078e00ffULL, 0x000000dad900720bULL, 0x004fc80003f1d000ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000001100837306ULL, 0x000e6e0000005400ULL,
0x0000000186860812ULL, 0x008fe200078efcffULL, 0x0000001100857306ULL, 0x0004f0000000d400ULL,
0x0000006c00ad7306ULL, 0x000fe20000209400ULL, 0x0001000011117824ULL, 0x004fe200078e00ffULL,
0x000000838200720bULL, 0x002fc80003fbd000ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000006c00ae7306ULL, 0x000fee0000205400ULL, 0x0000000185855812ULL, 0x008fe200078efcffULL,
0x0000006c00637306ULL, 0x000ff0000020d400ULL, 0x00000032009d7306ULL, 0x000ff00000209400ULL,
0x00000032009e7306ULL, 0x000e700000205400ULL, 0x00000032006b7306ULL, 0x0004f0000020d400ULL,
0x0000003300877306ULL, 0x000fe20000209400ULL, 0x00000018ff327819ULL, 0x004fc40000011436ULL,
0x0000009e9d00720bULL, 0x002fca0003fdd000ULL, 0x0000003300887306ULL, 0x000ff00000205400ULL,
0x00000033006c7306ULL, 0x0003e2000020d400ULL, 0x000000016b6b6812ULL, 0x008fce00078efcffULL,
0x0000003200757306ULL, 0x000fe20000209400ULL, 0x00000018ff337819ULL, 0x002fce0000011437ULL,
0x0000003200767306ULL, 0x000ff00000205400ULL, 0x0000003200777306ULL, 0x000ff0000020d400ULL,
0x0000003300787306ULL, 0x000ff00000209400ULL, 0x0000003300797306ULL, 0x000ff00000205400ULL,
0x00000033007a7306ULL, 0x000ff0000020d400ULL, 0x0000009700a27306ULL, 0x000e70000020d400ULL,
0x0000001000327306ULL, 0x000ff00000209400ULL, 0x0000001000337306ULL, 0x000ea20000205400ULL,
0x00000001a2a24812ULL, 0x002fce00078efcffULL, 0x00000010009f7306ULL, 0x000e70000020d400ULL,
0x0000001100ed7306ULL, 0x000fe20000209400ULL, 0x000000333200720bULL, 0x004fe40003f5d000ULL,
0x009000002b30783bULL, 0x000eaa0000000200ULL, 0x0000001100f07306ULL, 0x000eec0000205400ULL,
0x000000019f9f2812ULL, 0x002fc400078efcffULL, 0x0000001100a07306ULL, 0x000e64000020d400ULL,
0x0000009f9090723eULL, 0x000fcc00000010ffULL, 0x0000008900eb7306ULL, 0x000fe20000209400ULL,
0x000000f0ed00720bULL, 0x008fce0003f1d000ULL, 0x0000008900ee7306ULL, 0x000eec0000205400ULL,
0x00000001a0a00812ULL, 0x002fe400078efcffULL, 0x0000001200107306ULL, 0x000ff00000009400ULL,
0x0000001200117306ULL, 0x000e620000005400ULL, 0x000000eeeb00720bULL, 0x008fce0003f7d000ULL,
0x0000008900a17306ULL, 0x000730000020d400ULL, 0x00000012009a7306ULL, 0x000ea2000000d400ULL,
0x0000010012897824ULL, 0x008fe200078e00ffULL, 0x000000111000720bULL, 0x002fc80003f9d000ULL,
0x00000018ff897819ULL, 0x000fe40000011489ULL, 0x000000dd00d37306ULL, 0x000fe20000209400ULL,
0x00000001a1a13812ULL, 0x010fe400078efcffULL, 0x000000e2e100720bULL, 0x000fca0003f7d000ULL,
0x0000008900d17306ULL, 0x000fe20000209400ULL, 0x000000019a9a4812ULL, 0x004fe400078efcffULL,
0x000000cecb00720bULL, 0x000fca0003f9d000ULL, 0x0000008900d47306ULL, 0x000e620000205400ULL,
0x000000018f8f3812ULL, 0x000fce00078efcffULL, 0x0000008900977306ULL, 0x0004e2000020d400ULL,
0x000000017b7b4812ULL, 0x000fe400078efcffULL, 0x000000d2cf00720bULL, 0x000fca0003f9d000ULL,
0x000000dd00d67306ULL, 0x000f220000205400ULL, 0x0001000012897824ULL, 0x004fe200078e00ffULL,
0x0000000780127812ULL, 0x000fe400078e78dfULL, 0x000000d4d100720bULL, 0x002fe40003fbd000ULL,
0x00000018fff97819ULL, 0x000fe20000011489ULL, 0x00000008dfdf7824ULL, 0x000fe200078e0212ULL,
0x000000dd00987306ULL, 0x0002a2000020d400ULL, 0x0000010035127824ULL, 0x000fe200078e00ffULL,
0x0000000162624812ULL, 0x000fe200078efcffULL, 0x00000010df587824ULL, 0x000fe200078e0258ULL,
0x000000cac700720bULL, 0x000fc40003f9d000ULL, 0x00000018ffd77819ULL, 0x000fe40000011412ULL,
0x0000001300d57306ULL, 0x000fe20000009400ULL, 0x0001000013dd7824ULL, 0x002fe200078e00ffULL,
0x0000000197975812ULL, 0x008fe400078efcffULL, 0x000000d6d300720bULL, 0x010fe40003f1d000ULL,
0x00000018fffa7819ULL, 0x000fe400000114ddULL, 0x0000001300d87306ULL, 0x000e620000005400ULL,
0x0000000161614812ULL, 0x000fc400078efcffULL, 0x000000aead00720bULL, 0x000fe40003f9d000ULL,
0x0000009a979a723eULL, 0x000fc600000010ffULL, 0x0000001300997306ULL, 0x000722000000d400ULL,
0x0000000198980812ULL, 0x004fe400078efcffULL, 0x000000ff9200720cULL, 0x000fe40003f05270ULL,
0x000000b9c892723eULL, 0x000fc600000010ffULL, 0x000000f900db7306ULL, 0x000fe20000209400ULL,
0x0000010034137824ULL, 0x008fe200078e00ffULL, 0x000000d8d500720bULL, 0x002fe40003f5d000ULL,
0x0000000163634812ULL, 0x000fe400078efcffULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x000000f900dc7306ULL, 0x000e620000205400ULL, 0x000000c130308231ULL, 0x080fe200003400ffULL,
0x0000005a635a723eULL, 0x000fe200000010ffULL, 0x000000c132328231ULL, 0x000fc400003400ffULL,
0x000000be31318231ULL, 0x080fe400003400ffULL, 0x0000000199992812ULL, 0x010fe200078efcffULL,
0x000000fa00dd7306ULL, 0x000fe20000209400ULL, 0x000000c0c300720bULL, 0x000fe20003f5d000ULL,
0x000000be33338231ULL, 0x000fcc00003400ffULL, 0x000000fa00de7306ULL, 0x000ea20000205400ULL,
0x000000dcdb00720bULL, 0x002fe20003f7d000ULL, 0x000000923054723cULL, 0x000fe80000041854ULL,
0x0000000160602812ULL, 0x000fe400078efcffULL, 0x00000013008d7306ULL, 0x000fe20000209400ULL,
0x000000b4b300720bULL, 0x000fe20003f5d000ULL, 0x0000010036937824ULL, 0x000fe200078e00ffULL,
0x000000acaf92723eULL, 0x000fe200000010ffULL, 0x0000010037af7824ULL, 0x000fc600078e00ffULL,
0x00000018ffac7819ULL, 0x000fe20000011493ULL, 0x00000013008e7306ULL, 0x000fe20000205400ULL,
0x000000dedd00720bULL, 0x004fe40003fbd000ULL, 0x000000abb093723eULL, 0x000fe200000010ffULL,
0x0001000037b07824ULL, 0x000fe200078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe400000114afULL,
0x000000015d5d2812ULL, 0x000fe200078efcffULL, 0x0000001300827306ULL, 0x0003e2000020d400ULL,
0x000000a6a500720bULL, 0x000fe20003f5d000ULL, 0x00000092304c723cULL, 0x000fec000004184cULL,
0x000000f900897306ULL, 0x000ea2000020d400ULL, 0x009000005810783bULL, 0x002e6a0000000200ULL,
0x0000000166662812ULL, 0x000fc400078efcffULL, 0x000000fa008a7306ULL, 0x000ee2000020d400ULL,
0x0000000189893812ULL, 0x004fce00078efcffULL, 0x0000003400a77306ULL, 0x000fe20000009400ULL,
0x000000c2c500720bULL, 0x000fe40003f7d000ULL, 0x000000018a8a5812ULL, 0x008fca00078efcffULL,
0x0000003400a87306ULL, 0x000ea20000005400ULL, 0x000000d0cd00720bULL, 0x000fca0003fbd000ULL,
0x0000000117173812ULL, 0x000fe400078efcffULL, 0x00000034007d7306ULL, 0x000722000000d400ULL,
0x000000b6b500720bULL, 0x000fca0003f7d000ULL, 0x0000000165655812ULL, 0x000fe400078efcffULL,
0x00000035009b7306ULL, 0x000fe20000009400ULL, 0x0001000034347824ULL, 0x008fe200078e00ffULL,
0x000000babb00720bULL, 0x000fe20003fbd000ULL, 0x000000c110108231ULL, 0x082fe200003400ffULL,
0x000000a8a700720bULL, 0x004fe20003f9d000ULL, 0x000000c112128231ULL, 0x000fe200003400ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x000000be11118231ULL, 0x080fe200003400ffULL,
0x00000035009c7306ULL, 0x000e620000005400ULL, 0x0000000164643812ULL, 0x000fe200078efcffULL,
0x000000be13138231ULL, 0x000fe200003400ffULL, 0x000000959600720bULL, 0x000fc40003f7d000ULL,
0x000000c4bd00720bULL, 0x000fe40003f1d000ULL, 0x000000015c5c5812ULL, 0x000fe200078efcffULL,
0x00000035007e7306ULL, 0x0004e2000000d400ULL, 0x000000919400720bULL, 0x000fe40003fbd000ULL,
0x000000017d7d4812ULL, 0x010fe400078efcffULL, 0x000000a08f91723eULL, 0x000fe400000010ffULL,
0x000000615c5c723eULL, 0x000fe200000010ffULL, 0x0000003400cb7306ULL, 0x000fe20000209400ULL,
0x0001000035357824ULL, 0x004fe200078e00ffULL, 0x0000009c9b00720bULL, 0x002fc40003f5d000ULL,
0x000000015f5f3812ULL, 0x000fe200078efcffULL, 0x000000903040723cULL, 0x000fe20000041840ULL,
0x00000018ffc17819ULL, 0x000fe40000011435ULL, 0x0000003400c07306ULL, 0x000e620000205400ULL,
0x000000b8b135723eULL, 0x000fe400000010ffULL, 0x000000015e5e5812ULL, 0x000fe400078efcffULL,
0x00000099989b723eULL, 0x000fe400000010ffULL, 0x0000008e8d00720bULL, 0x000fe20003fbd000ULL,
0x0000003400bc7306ULL, 0x000522000020d400ULL, 0x000000015b5b0812ULL, 0x000fc400078efcffULL,
0x000000017e7e2812ULL, 0x008fe200078efcffULL, 0x0000009a303c723cULL, 0x000fe2000004183cULL,
0x000000888700720bULL, 0x000fe40003f1d000ULL, 0x000000717000720bULL, 0x000fe20003f5d000ULL,
0x000000d700837306ULL, 0x000fe20000209400ULL, 0x000000b7b234723eULL, 0x004fe400000010ffULL,
0x000000c0cb00720bULL, 0x002fe40003f9d000ULL, 0x0000000182825812ULL, 0x000fc400078efcffULL,
0x0000006e6d00720bULL, 0x000fe20003fbd000ULL, 0x000000343050723cULL, 0x000fe20000041850ULL,
0x000000d700d47306ULL, 0x000e620000205400ULL, 0x000000016c6c0812ULL, 0x000fe400078efcffULL,
0x0000000174742812ULL, 0x000fe400078efcffULL, 0x000000645d5d723eULL, 0x000fe400000010ffULL,
0x000000a9a434723eULL, 0x000fe200000010ffULL, 0x000000d700c97306ULL, 0x000ea2000020d400ULL,
0x000000aaa335723eULL, 0x000fc400000010ffULL, 0x00000001bcbc4812ULL, 0x010fe400078efcffULL,
0x000000016f6f5812ULL, 0x000fe400078efcffULL, 0x000000767500720bULL, 0x000fe20003fbd000ULL,
0x000000343048723cULL, 0x000fe20000041848ULL, 0x00000036008b7306ULL, 0x000fe20000009400ULL,
0x000000d48300720bULL, 0x002fe40003f7d000ULL, 0x0000005b665b723eULL, 0x000fe400000010ffULL,
0x0000006b5e5e723eULL, 0x000fc400000010ffULL, 0x00000086a134723eULL, 0x000fe200000010ffULL,
0x00000036008c7306ULL, 0x000e620000005400ULL, 0x00000085a235723eULL, 0x000fe200000010ffULL,
0x0000005c1050723cULL, 0x000fe20000041850ULL, 0x0000000177775812ULL, 0x000fe400078efcffULL,
0x0000006c5f5f723eULL, 0x000fe400000010ffULL, 0x00000001c9c93812ULL, 0x004fe200078efcffULL,
0x000000c100bf7306ULL, 0x000fe20000209400ULL, 0x0000007d8282723eULL, 0x000fe200000010ffULL,
0x000000343044723cULL, 0x000fe20000041844ULL, 0x0000007ec983723eULL, 0x000fca00000010ffULL,
0x000000c100ba7306ULL, 0x000ea20000205400ULL, 0x000000897c34723eULL, 0x000fe200000010ffULL,
0x0000005a104c723cULL, 0x000fe2000004184cULL, 0x0000008a7b35723eULL, 0x000fe400000010ffULL,
0x0000008c8b00720bULL, 0x002fc60003fdd000ULL, 0x000000ac00ab7306ULL, 0x000fe40000209400ULL,
0x000000343038723cULL, 0x000fec0000041838ULL, 0x000000ac00927306ULL, 0x000e620000205400ULL,
0x00000018ff317819ULL, 0x000fe200000114b0ULL, 0x0000005e1048723cULL, 0x000fe20000041848ULL,
0x000000babf00720bULL, 0x004fc40003f7d000ULL, 0x000000bc6fb0723eULL, 0x000fc600000010ffULL,
0x00000036007f7306ULL, 0x0004e4000000d400ULL, 0x000000821044723cULL, 0x000fec0000041844ULL,
0x0000003700817306ULL, 0x000fe20000009400ULL, 0x0001000036367824ULL, 0x004fe200078e00ffULL,
0x00000092ab00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff7b7819ULL, 0x000fe40000011436ULL,
0x0000003700847306ULL, 0x000e620000005400ULL, 0x000000017f7f6812ULL, 0x008fe400078efcffULL,
0x000000606536723eULL, 0x000fca00000010ffULL, 0x0000003700807306ULL, 0x0005f0000000d400ULL,
0x000000c100b17306ULL, 0x000ee2000020d400ULL, 0x000000176237723eULL, 0x004fe400000010ffULL,
0x000000848100720bULL, 0x002fca0003f1d000ULL, 0x000000ac00947306ULL, 0x000e62000020d400ULL,
0x000000361054723cULL, 0x000fee0000041854ULL, 0x000000af00857306ULL, 0x000fe20000209400ULL,
0x00000001b1b13812ULL, 0x008fe400078efcffULL, 0x000000797800720bULL, 0x000fc40003f7d000ULL,
0x0000000180800812ULL, 0x000fe400078efcffULL, 0x000000b174b1723eULL, 0x000fe200000010ffULL,
0x000000af00867306ULL, 0x000ea20000205400ULL, 0x0000000194944812ULL, 0x002fc800078efcffULL,
0x0000007f9494723eULL, 0x000fe200000010ffULL, 0x000000b01040723cULL, 0x000fe40000041840ULL,
0x0000007b007c7306ULL, 0x000fe20000209400ULL, 0x000000017a7a3812ULL, 0x000fce00078efcffULL,
0x0000007b00177306ULL, 0x000e620000205400ULL, 0x000000868500720bULL, 0x004fce0003f5d000ULL,
0x0000003100327306ULL, 0x000ff00000209400ULL, 0x0000003100337306ULL, 0x000ea20000205400ULL,
0x000000177c00720bULL, 0x002fce0003f9d000ULL, 0x000000af00957306ULL, 0x000e70000020d400ULL,
0x0000007b00307306ULL, 0x000ee2000020d400ULL, 0x000000333200720bULL, 0x004fce0003fdd000ULL,
0x0000003100317306ULL, 0x000ea2000020d400ULL, 0x0000000195952812ULL, 0x002fc800078efcffULL,
0x000000809595723eULL, 0x000fe400000010ffULL, 0x0000000130304812ULL, 0x008fc800078efcffULL,
0x000000307730723eULL, 0x000fe200000010ffULL, 0x00000094103c723cULL, 0x000fe2000004183cULL,
0x0000000131316812ULL, 0x004fc800078efcffULL, 0x000000317a31723eULL, 0x000fce00000010ffULL,
0x000000301038723cULL, 0x000fe20000041838ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200015107f8cULL, 0x0002a2000c80043fULL, 0xfffffff859597812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000401c107810ULL, 0x004fe20007ffe0ffULL,
0x00f6880059ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff317224ULL, 0x000fe200078e0011ULL,
0x0000000114147812ULL, 0x000fe200078e0cffULL, 0x000000ffff177224ULL, 0x000fe200078e0073ULL,
0x000000031000720cULL, 0x000fda0003f06070ULL, 0x000087b000000947ULL, 0x000fea0003800000ULL,
0x0000040016107984ULL, 0x004ea40000000800ULL, 0x8000000010ff7812ULL, 0x004fe40007804831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000240015107984ULL, 0x000ea40000000800ULL,
0x8000000010ff7812ULL, 0x004fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL,
0x0000000b00107305ULL, 0x0004e4000021f000ULL, 0x3fa000000b0b7823ULL, 0x004fe200000100ffULL,
0x000000100000735dULL, 0x008fe40003800000ULL, 0x0000240015107984ULL, 0x000ea40000000800ULL,
0x8000000010ff7812ULL, 0x004fc40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff0b7819ULL, 0x000fe20000011600ULL, 0x000000081a5a7824ULL, 0x000fe200078e00ffULL,
0x0000000808127812ULL, 0x000fe200078ec0ffULL, 0x000010001a667824ULL, 0x000fe200078e00ffULL,
0xffffffe008117812ULL, 0x000fe200078ec0ffULL, 0x000000100b107824ULL, 0x040fe200078e00ffULL,
0x000000085a647812ULL, 0x000fe200078ec0ffULL, 0x000000200b137824ULL, 0x000fe200078e021cULL,
0x0000000104147810ULL, 0x000fe40007ffe0ffULL, 0x00000010105b7812ULL, 0x000fc400078ec0ffULL,
0x0000f6a810657810ULL, 0x000fe40007ffe0ffULL, 0x00000011125b7210ULL, 0x000fe40007ffe05bULL,
0x0000000864127812ULL, 0x000fe200078e3cffULL, 0x0000000165647824ULL, 0x000fe200078e0264ULL,
0x0000008013107810ULL, 0x000fe20007ffe0ffULL, 0x0000001000137824ULL, 0x000fe200078e00ffULL,
0x000000071400720cULL, 0x000fe20003f06070ULL, 0x0000000165657824ULL, 0x000fe200078e0212ULL,
0x000000600c127812ULL, 0x000fe200078ef810ULL, 0x0000580009147a24ULL, 0x020fe200078e02ffULL,
0x0000001003117217ULL, 0x000fe20007800000ULL, 0x00000000640473c2ULL, 0x000ea200000e0000ULL,
0x00000010135c7812ULL, 0x000fe200078ec0ffULL, 0x0000008014177824ULL, 0x000fc400078e00ffULL,
0x000000011f137824ULL, 0x000fe400078e0212ULL, 0x0000000111117824ULL, 0x000fe400078e0a10ULL,
0x000000011d107824ULL, 0x100fe200078e0212ULL, 0x0000001317337210ULL, 0x000fe20007f7e0ffULL,
0x0000000121147824ULL, 0x100fe200078e0212ULL, 0x0000002011117807ULL, 0x000fe20000000000ULL,
0x0000000123127824ULL, 0x000fe200078e0212ULL, 0x0000001017357210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x0000001417147210ULL, 0x000fc40007f9e0ffULL,
0x00005e0033347a11ULL, 0x000fe200078638ffULL, 0x000000ffff327224ULL, 0x000fe200010e06ffULL,
0x0000001217127210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff317224ULL, 0x000fe200020e06ffULL,
0x00005e0035367a11ULL, 0x000fe400078438ffULL, 0x000000115c117217ULL, 0x000fe20007800000ULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x00005e0014307a11ULL, 0x000fe400078838ffULL,
0x00005f0033337a11ULL, 0x000fe200018f3c10ULL, 0x0000000111137824ULL, 0x000fe200078e0a5cULL,
0x0000100066107812ULL, 0x000fc400078ec0ffULL, 0x00005f0035357a11ULL, 0x000fe400010f3c32ULL,
0x00005f0014317a11ULL, 0x000fe200020f3c31ULL, 0x000020000b117824ULL, 0x000fe200078e0210ULL,
0x00005e0012327a11ULL, 0x000fe400078038ffULL, 0x00000003ff147819ULL, 0x000fe40000011602ULL,
0x0000002736107210ULL, 0x000fe40007f9e0ffULL, 0x00005f0012177a11ULL, 0x000fc400000f3c17ULL,
0x00000004145e7810ULL, 0x040fe40007ffe0ffULL, 0x00000008145c7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c14367810ULL, 0x000fe40007ffe0ffULL, 0x0000002734127210ULL, 0x000fe40007fbe0ffULL,
0x000000131400720cULL, 0x080fe40003f66070ULL, 0x0000b00011147810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200020e0635ULL, 0x000000135e00720cULL, 0x000fc40003f46070ULL,
0x000000135c00720cULL, 0x080fe20003f06070ULL, 0x0000001067677824ULL, 0x100fe200078e0214ULL,
0x000000133600720cULL, 0x000fe20003f86070ULL, 0x000000ffff137224ULL, 0x000fe200028e0633ULL,
0x0000002730307210ULL, 0x080fe20007fbe0ffULL, 0x0000001068687824ULL, 0x100fe400078e0214ULL,
0x0000001069697824ULL, 0x100fe200078e0214ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010677faeULL, 0x0007e2000d901c46ULL, 0x000000ffff317224ULL, 0x000fe200028e0631ULL,
0x0000002732327210ULL, 0x000fe20007fbe0ffULL, 0x000000106a6a7824ULL, 0x000fe200078e0214ULL,
0x0000000012687faeULL, 0x0007e6000d101c46ULL, 0x000000ffff337224ULL, 0x000fe200028e0617ULL,
0x0000000030697faeULL, 0x0007e8000c101c46ULL, 0x00000000326a7faeULL, 0x0007e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x004fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000064107f8cULL, 0x0084e8000c80043fULL, 0x0000040065177984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f628005b127f8cULL, 0x000fe2000c80043fULL, 0x8000000017ff7812ULL, 0x010fc60007844873ULL,
0x00f62c005b317984ULL, 0x000f240000000800ULL, 0x8000000031ff7812ULL, 0x010fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x000000ffff177224ULL, 0x008fe200078e0011ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x000724000021f000ULL,
0x3fa0000010107823ULL, 0x008fe200000100ffULL, 0x000000110000735dULL, 0x010fe40003800000ULL,
0x00f62c0025117984ULL, 0x000ee40000000800ULL, 0x8000000011ff7812ULL, 0x008fc40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008027117810ULL, 0x000fca0007ffe026ULL,
0x0000000128117824ULL, 0x000fca00078e0211ULL, 0x00f0000011137984ULL, 0x000ee80000000800ULL,
0x00f2000011107984ULL, 0x0008620000000800ULL, 0x0000000e1300720bULL, 0x008fe20003f1d000ULL,
0x00011bb27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000117806ULL, 0x010fc800000e0100ULL,
0x0000ffff11127812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ffe07424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000100117811ULL, 0x000fe400078ff0ffULL, 0x0000000e1300720bULL, 0x000fe40003f14000ULL,
0x000000001100720cULL, 0x000fe20003f65270ULL, 0x00011b827f007947ULL, 0x000ff4000b800000ULL,
0x0000000000117806ULL, 0x000fe400000e0100ULL, 0x000000130e147209ULL, 0x000fe20007810000ULL,
0x000000800031b824ULL, 0x000fe200078e0227ULL, 0x0000ffff11117812ULL, 0x000fe400078e3cffULL,
0x00000002ff347819ULL, 0x000fe20000011602ULL, 0x000000012831b824ULL, 0x000fe200078e0231ULL,
0x0000001112ff7212ULL, 0x000fe2000780c0ffULL, 0x800000140e0e7221ULL, 0x000fc60000010000ULL,
0x00f400143100b388ULL, 0x0007e20000000800ULL, 0x3fb8aa3b0e0e7820ULL, 0x000fc80000410000ULL,
0x0000000e00337308ULL, 0x000f240000000800ULL, 0x000000330f0f7220ULL, 0x010fe20000410000ULL,
0x00011b127f007947ULL, 0x000fea000b800000ULL, 0x00001f34330e7589ULL, 0x00872400000e0000ULL,
0x0000000e54547220ULL, 0x090fe40000410000ULL, 0x0000000e55557220ULL, 0x080fe40000410000ULL,
0x0000000e50507220ULL, 0x080fe40000410000ULL, 0x0000000e51517220ULL, 0x080fe40000410000ULL,
0x0000000e4c4c7220ULL, 0x000fc40000410000ULL, 0x0000000e4d4d7220ULL, 0x080fe40000410000ULL,
0x0000000e48487220ULL, 0x080fe40000410000ULL, 0x0000000e49497220ULL, 0x080fe40000410000ULL,
0x0000000e44447220ULL, 0x080fe40000410000ULL, 0x0000000e45457220ULL, 0x080fe40000410000ULL,
0x0000000e40407220ULL, 0x000fc40000410000ULL, 0x0000000e41417220ULL, 0x080fe40000410000ULL,
0x0000000e3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000e3d3d7220ULL, 0x080fe40000410000ULL,
0x0000000e38387220ULL, 0x080fe40000410000ULL, 0x0000000e39397220ULL, 0x000fe20000410000ULL,
0x00011a527f007947ULL, 0x000fea000b800000ULL, 0x00001f2a330e7589ULL, 0x0008a400000e0000ULL,
0x8000001413130221ULL, 0x000fe20000010000ULL, 0x00000001ffe07807ULL, 0x000fe20000000000ULL,
0x0000000e56567220ULL, 0x004fc40000410000ULL, 0x3fb8aa3b13130820ULL, 0x000fe40000410000ULL,
0x0000000e57577220ULL, 0x080fe40000410000ULL, 0x0000001300290308ULL, 0x000ea20000000800ULL,
0x0000000e52527220ULL, 0x080fe40000410000ULL, 0x0000000e53537220ULL, 0x080fe40000410000ULL,
0x0000000e4e4e7220ULL, 0x080fe40000410000ULL, 0x0000000e4f4f7220ULL, 0x000fc40000410000ULL,
0x0000000e4a4a7220ULL, 0x080fe40000410000ULL, 0x0000000e4b4b7220ULL, 0x080fe40000410000ULL,
0x0000000e46467220ULL, 0x080fe40000410000ULL, 0x0000000e47477220ULL, 0x080fe40000410000ULL,
0x0000000e42427220ULL, 0x080fe40000410000ULL, 0x0000000e43437220ULL, 0x000fc40000410000ULL,
0x0000000e3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000e3f3f7220ULL, 0x080fe40000410000ULL,
0x0000000e3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000e3b3b7220ULL, 0x000fe40000410000ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0014ULL, 0x0000001029100220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000000f100f7221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x000000081a107824ULL, 0x000fe200078e00ffULL, 0xfffffff008117812ULL, 0x000fc800078ec0ffULL,
0x0000000810107812ULL, 0x000fca00078e0cffULL, 0x0000000111127824ULL, 0x000fca00078e0210ULL,
0x00f6ac0012117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804873ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x000364000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x020fe40003800000ULL,
0x00f6ac0012117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007804873ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff347819ULL, 0x008fe40000011602ULL,
0x00000029ff12723eULL, 0x000fe400000010ffULL, 0x0000001834107810ULL, 0x040fe40007ffe0ffULL,
0x0000001034117810ULL, 0x000fe40007ffe0ffULL, 0x0000541012337816ULL, 0x010fe20000000012ULL,
0x000117a27f007947ULL, 0x000fea000b800000ULL, 0x00001f3433c77589ULL, 0x0002e400000e0000ULL,
0x000117e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2a33c47589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff347224ULL, 0x002fe200078e0011ULL,
0x00004fa000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x000123b000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff347224ULL, 0x002fe200078e0010ULL,
0x0000500000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0001235000007944ULL, 0x01cfea0003c00000ULL,
0x000010001a127824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100000107824ULL, 0x000fe200078e00ffULL, 0x00009910e0e07816ULL, 0x000fe400000000ffULL,
0x0000100012127812ULL, 0x000fe400078e0cffULL, 0xffffe00010117812ULL, 0x000fc400078ec0ffULL,
0x0000b0000d6e7810ULL, 0x100fe40007ffe012ULL, 0x0000b00011117810ULL, 0x000fc60007ffe012ULL,
0x000000102d127824ULL, 0x000fe400078e026eULL, 0x000000102c107824ULL, 0x100fe400078e0211ULL,
0x000000102e117824ULL, 0x000fe200078e0211ULL, 0x000000001260783bULL, 0x000f680000004200ULL,
0x000000001030783bULL, 0x016e680000004200ULL, 0x000000001134783bULL, 0x000ea20000004200ULL,
0x00000018ff737819ULL, 0x020fe20000011462ULL, 0x0000006000cb7306ULL, 0x000fe20000009400ULL,
0x00000018ff6f7819ULL, 0x000fc40000011460ULL, 0x00000018ff137819ULL, 0x002fe20000011430ULL,
0x00000100307f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011431ULL,
0x00000018ff5d7819ULL, 0x000fe20000011432ULL, 0x0000001300f87306ULL, 0x000fe20000209400ULL,
0x00000018ff5e7819ULL, 0x000fe40000011433ULL, 0x00000018ff6d7819ULL, 0x004fe40000011436ULL,
0x00000018ff7f7819ULL, 0x000fc4000001147fULL, 0x00000018ff6b7819ULL, 0x000fe20000011434ULL,
0x0000001300f57306ULL, 0x000e620000205400ULL, 0x00000018ff6c7819ULL, 0x000fe40000011435ULL,
0x00000018ff707819ULL, 0x000fe40000011461ULL, 0x00000018ff767819ULL, 0x000fc60000011463ULL,
0x0000001300c07306ULL, 0x000530000020d400ULL, 0x0000005c009b7306ULL, 0x000fe20000209400ULL,
0x000000102f137824ULL, 0x004fe200078e026eULL, 0x00000018ff6e7819ULL, 0x000fc40000011437ULL,
0x000000f5f800720bULL, 0x002fc80003f7d000ULL, 0x0000005c00f27306ULL, 0x000ff00000205400ULL,
0x0000005c00ba7306ULL, 0x000fe2000020d400ULL, 0x00000001c0c03812ULL, 0x010fce00078efcffULL,
0x0000005d00917306ULL, 0x000ff00000209400ULL, 0x0000005d00947306ULL, 0x000ff00000205400ULL,
0x0000005d00ae7306ULL, 0x000ff0000020d400ULL, 0x0000005e00897306ULL, 0x000ff00000209400ULL,
0x0000005e00a27306ULL, 0x000ff00000205400ULL, 0x0000005e00aa7306ULL, 0x0003f0000020d400ULL,
0x0000003000fc7306ULL, 0x000fe20000009400ULL, 0x00000000135c783bULL, 0x002e6e0000004200ULL,
0x0000003000837306ULL, 0x000eb00000005400ULL, 0x0000003000927306ULL, 0x000970000000d400ULL,
0x0000006d00d17306ULL, 0x000fe20000209400ULL, 0x0001000030307824ULL, 0x010fe200078e00ffULL,
0x00000083fc00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000006d00cc7306ULL, 0x000fee0000205400ULL, 0x0000000192924812ULL, 0x020fe200078efcffULL,
0x0000003000f77306ULL, 0x000fe20000209400ULL, 0x00000018ff807819ULL, 0x002fc4000001145dULL,
0x00000018ff797819ULL, 0x000fe4000001145cULL, 0x00000018ff827819ULL, 0x000fe4000001145fULL,
0x00000018ff817819ULL, 0x000fe2000001145eULL, 0x0000003000be7306ULL, 0x000e700000205400ULL,
0x0000006d007d7306ULL, 0x000ff0000020d400ULL, 0x00000073009f7306ULL, 0x000fe20000209400ULL,
0x000000bef700720bULL, 0x002fce0003fbd000ULL, 0x0000007300a07306ULL, 0x000ff00000205400ULL,
0x00000073006d7306ULL, 0x000ff0000020d400ULL, 0x0000008000727306ULL, 0x000ff00000209400ULL,
0x0000008000737306ULL, 0x000ff00000205400ULL, 0x0000008000747306ULL, 0x0003f0000020d400ULL,
0x0000003100fa7306ULL, 0x000fe20000009400ULL, 0x0000010031807824ULL, 0x002fca00078e00ffULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x0000003100c17306ULL, 0x000e700000005400ULL,
0x0000003100937306ULL, 0x0005f0000000d400ULL, 0x0000003000c57306ULL, 0x000962000020d400ULL,
0x0001000031317824ULL, 0x004fe200078e00ffULL, 0x000000c1fa00720bULL, 0x002fc80003f5d000ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000007f00dd7306ULL, 0x000fe20000209400ULL,
0x0000010033307824ULL, 0x010fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003100f37306ULL, 0x000fe20000209400ULL, 0x00000001c5c55812ULL, 0x020fe400078efcffULL,
0x000000f29b00720bULL, 0x000fe40003fbd000ULL, 0x0000000193932812ULL, 0x000fe400078efcffULL,
0x000000949100720bULL, 0x000fe20003f5d000ULL, 0x0000003100f67306ULL, 0x000e700000205400ULL,
0x0000007f00da7306ULL, 0x000ea20000205400ULL, 0x00000001baba5812ULL, 0x000fc600078efcffULL,
0x00000001aeae2812ULL, 0x000fc800078efcffULL, 0x0000007f00c97306ULL, 0x000962000020d400ULL,
0x000000f6f300720bULL, 0x002fce0003f9d000ULL, 0x0000003100bd7306ULL, 0x0002e2000020d400ULL,
0x00000100327f7824ULL, 0x010fe200078e00ffULL, 0x000000dadd00720bULL, 0x004fc80003f1d000ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000003000a87306ULL, 0x000fe20000209400ULL,
0x0000010034317824ULL, 0x002fcc00078e00ffULL, 0x00000001c9c90812ULL, 0x020fe200078efcffULL,
0x0000007f00ef7306ULL, 0x000fe20000209400ULL, 0x00000001bdbd4812ULL, 0x008fe400078efcffULL,
0x00000092c992723eULL, 0x000fca00000010ffULL, 0x0000007f00f07306ULL, 0x000e700000205400ULL,
0x0000003000a97306ULL, 0x000eb00000205400ULL, 0x0000003200857306ULL, 0x000fe20000009400ULL,
0x000000f0ef00720bULL, 0x002fce0003f9d000ULL, 0x0000003200f47306ULL, 0x000e620000005400ULL,
0x000000a9a800720bULL, 0x004fce0003fbd000ULL, 0x0000003200b67306ULL, 0x0004f0000000d400ULL,
0x00000033009c7306ULL, 0x000fe20000009400ULL, 0x0001000032327824ULL, 0x004fe200078e00ffULL,
0x000000f48500720bULL, 0x002fc80003f1d000ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000003300f17306ULL, 0x000e6e0000005400ULL, 0x00000001b6b60812ULL, 0x008fe200078efcffULL,
0x0000003300b07306ULL, 0x0004f0000000d400ULL, 0x0000007f00bb7306ULL, 0x000962000020d400ULL,
0x0001000033337824ULL, 0x004fe200078e00ffULL, 0x000000f19c00720bULL, 0x002fcc0003f7d000ULL,
0x0000003000b17306ULL, 0x000e62000020d400ULL, 0x00000018ff7f7819ULL, 0x010fe20000011433ULL,
0x0000010035337824ULL, 0x000fca00078e00ffULL, 0x00000001b0b03812ULL, 0x008fe200078efcffULL,
0x0000003500957306ULL, 0x000fe20000009400ULL, 0x00000001bbbb4812ULL, 0x020fce00078efcffULL,
0x0000003500e67306ULL, 0x000ea20000005400ULL, 0x00000001b1b15812ULL, 0x002fe400078efcffULL,
0x000000a28900720bULL, 0x000fca0003fbd000ULL, 0x0000003200877306ULL, 0x000ff00000209400ULL,
0x0000003200ec7306ULL, 0x000e620000205400ULL, 0x000000e69500720bULL, 0x004fe40003f5d000ULL,
0x00000001aaaa5812ULL, 0x000fca00078efcffULL, 0x0000006b00967306ULL, 0x000ff00000209400ULL,
0x0000006b00e37306ULL, 0x000fe20000205400ULL, 0x000000ec8700720bULL, 0x002fce0003f9d000ULL,
0x0000006b009e7306ULL, 0x000ff0000020d400ULL, 0x0000006c00e27306ULL, 0x000ff00000209400ULL,
0x0000006c00e57306ULL, 0x000ff00000205400ULL, 0x0000006c008e7306ULL, 0x000ff0000020d400ULL,
0x0000006f00c27306ULL, 0x000ff00000209400ULL, 0x0000006f00c37306ULL, 0x000ff00000205400ULL,
0x0000006f006b7306ULL, 0x000ff0000020d400ULL, 0x0000007000b87306ULL, 0x000ff00000209400ULL,
0x0000007000b97306ULL, 0x000ff00000205400ULL, 0x00000070006c7306ULL, 0x000ff0000020d400ULL,
0x00000079006f7306ULL, 0x000ff00000209400ULL, 0x0000007900707306ULL, 0x000ff00000205400ULL,
0x0000007900717306ULL, 0x000ff0000020d400ULL, 0x0000003400ed7306ULL, 0x000ff00000009400ULL,
0x0000003400867306ULL, 0x000ff00000005400ULL, 0x0000003400a67306ULL, 0x0003f0000000d400ULL,
0x0000008200787306ULL, 0x000fe20000209400ULL, 0x0001000034347824ULL, 0x002fce00078e00ffULL,
0x0000008200797306ULL, 0x000ff00000205400ULL, 0x00000082007a7306ULL, 0x0003f0000020d400ULL,
0x0000006e00997306ULL, 0x000fe20000209400ULL, 0x0000010036827824ULL, 0x002fca00078e00ffULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x0000006e00907306ULL, 0x000ff00000205400ULL,
0x0000006e007c7306ULL, 0x000ff0000020d400ULL, 0x00000076008c7306ULL, 0x000ff00000209400ULL,
0x00000076008d7306ULL, 0x000ff00000205400ULL, 0x00000076006e7306ULL, 0x000ff0000020d400ULL,
0x0000008100757306ULL, 0x000ff00000209400ULL, 0x0000008100767306ULL, 0x000ff00000205400ULL,
0x0000008100777306ULL, 0x0003f0000020d400ULL, 0x0000007f00a17306ULL, 0x000fe20000209400ULL,
0x00000018ff817819ULL, 0x002fce0000011433ULL, 0x0000007f00ee7306ULL, 0x000e700000205400ULL,
0x0000007f00ad7306ULL, 0x0005f0000020d400ULL, 0x0000003500a47306ULL, 0x000722000000d400ULL,
0x00000018ff7f7819ULL, 0x004fc40000011434ULL, 0x000000eea100720bULL, 0x002fca0003f1d000ULL,
0x0000003200b37306ULL, 0x000e62000020d400ULL, 0x0001000035357824ULL, 0x008fce00078e00ffULL,
0x0000008000b77306ULL, 0x000fe20000209400ULL, 0x00000001a4a42812ULL, 0x010fe400078efcffULL,
0x00000001adad0812ULL, 0x000fca00078efcffULL, 0x0000008000b47306ULL, 0x000ea20000205400ULL,
0x00000001b3b34812ULL, 0x002fce00078efcffULL, 0x0000008100327306ULL, 0x000ff00000209400ULL,
0x0000008100337306ULL, 0x000e620000205400ULL, 0x000000b4b700720bULL, 0x004fce0003fdd000ULL,
0x0000007f00347306ULL, 0x000ff00000209400ULL, 0x0000007f00e97306ULL, 0x000ea20000205400ULL,
0x000000333200720bULL, 0x002fce0003f9d000ULL, 0x0000008200ea7306ULL, 0x000ff00000209400ULL,
0x0000008200eb7306ULL, 0x000e620000205400ULL, 0x000000e93400720bULL, 0x004fce0003fbd000ULL,
0x0000003600e77306ULL, 0x000ff00000009400ULL, 0x0000003600e47306ULL, 0x000ea20000005400ULL,
0x000000ebea00720bULL, 0x002fce0003f5d000ULL, 0x00000036008a7306ULL, 0x0002f0000000d400ULL,
0x0000008000c67306ULL, 0x000962000020d400ULL, 0x0001000036367824ULL, 0x002fe200078e00ffULL,
0x000000e4e700720bULL, 0x004fc80003f1d000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000008100a77306ULL, 0x0002a2000020d400ULL, 0x00000018ff807819ULL, 0x010fcc0000011431ULL,
0x000000018a8a0812ULL, 0x008fe200078efcffULL, 0x0000007f00a57306ULL, 0x000722000020d400ULL,
0x0000010037817824ULL, 0x002fe200078e00ffULL, 0x00000001c6c66812ULL, 0x020fe400078efcffULL,
0x00000086ed00720bULL, 0x000fe40003fdd000ULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x00000060009a7306ULL, 0x000fe20000005400ULL, 0x00000100607f7824ULL, 0x008fe200078e00ffULL,
0x00000001a7a74812ULL, 0x004fc400078efcffULL, 0x000000909900720bULL, 0x000fe20003f1d000ULL,
0x000100005e997824ULL, 0x000fe200078e00ffULL, 0x00000093c693723eULL, 0x000fe400000010ffULL,
0x00000060007b7306ULL, 0x0003e2000000d400ULL, 0x00000001a5a55812ULL, 0x010fe400078efcffULL,
0x00000001a6a66812ULL, 0x000fe400078efcffULL, 0x000000e5e200720bULL, 0x000fe40003fdd000ULL,
0x00000018ff997819ULL, 0x000fe20000011499ULL, 0x0000008000307306ULL, 0x000fe20000209400ULL,
0x0001000060607824ULL, 0x002fe200078e00ffULL, 0x000000017c7c0812ULL, 0x000fcc00078efcffULL,
0x0000008000317306ULL, 0x000e640000205400ULL, 0x000000018e8e6812ULL, 0x000fe400078efcffULL,
0x000000ccd100720bULL, 0x000fe20003fdd000ULL, 0x000100005dcc7824ULL, 0x000fe400078e00ffULL,
0x000001005fd17824ULL, 0x000fe200078e00ffULL, 0x0000008000ab7306ULL, 0x0004e4000020d400ULL,
0x00000018ffcc7819ULL, 0x000fc400000114ccULL, 0x00000018ffd17819ULL, 0x000fc800000114d1ULL,
0x0000003600d87306ULL, 0x000fe20000209400ULL, 0x00000018ff807819ULL, 0x004fe40000011435ULL,
0x000000313000720bULL, 0x002fe20003f7d000ULL, 0x000001005d307824ULL, 0x000fe200078e00ffULL,
0x000000017d7d6812ULL, 0x000fc600078efcffULL, 0x0000003600db7306ULL, 0x000fe20000205400ULL,
0x00000018ffe67819ULL, 0x000fe40000011430ULL, 0x009800005830783bULL, 0x000e6a0000000200ULL,
0x0000003600987306ULL, 0x0005e2000020d400ULL, 0x00000001abab3812ULL, 0x008fe400078efcffULL,
0x000000e39600720bULL, 0x000fca0003f7d000ULL, 0x00000082009d7306ULL, 0x000ee2000020d400ULL,
0x00000018ff367819ULL, 0x004fce0000011460ULL, 0x0000008000357306ULL, 0x000fe20000209400ULL,
0x000000019e9e3812ULL, 0x000fce00078efcffULL, 0x0000008000e87306ULL, 0x000ea20000205400ULL,
0x000000019d9d2812ULL, 0x008fe400078efcffULL, 0x000000dbd800720bULL, 0x000fca0003f5d000ULL,
0x0000008100dc7306ULL, 0x000ff00000209400ULL, 0x0000008100df7306ULL, 0x000ee20000205400ULL,
0x000000e83500720bULL, 0x004fe40003f9d000ULL, 0x0000000198982812ULL, 0x000fca00078efcffULL,
0x0000008000a37306ULL, 0x000530000020d400ULL, 0x0000003600d07306ULL, 0x000fe20000209400ULL,
0x00000018ff807819ULL, 0x004fe2000001147fULL, 0x00000100617f7824ULL, 0x000fe200078e00ffULL,
0x000000dfdc00720bULL, 0x008fe20003fbd000ULL, 0x000000ffffdf7224ULL, 0x000fc400078e00e0ULL,
0x000100005cdc7824ULL, 0x000fe400078e00ffULL, 0x0000003600d37306ULL, 0x000fe20000205400ULL,
0x00000001a3a34812ULL, 0x010fe400078efcffULL, 0x000000ffdf00720cULL, 0x000fe40003f65270ULL,
0x00000018ffdc7819ULL, 0x000fc600000114dcULL, 0x0000003600607306ULL, 0x0005f0000020d400ULL,
0x00000037008f7306ULL, 0x000fe20000009400ULL, 0x0000010063367824ULL, 0x004fe200078e00ffULL,
0x000000c73030b231ULL, 0x002fc400003400ffULL, 0x000000c73232b231ULL, 0x000fe400003400ffULL,
0x00000018fff97819ULL, 0x000fe20000011436ULL, 0x0001000062367824ULL, 0x000fe200078e00ffULL,
0x0000003700ce7306ULL, 0x000e620000005400ULL, 0x000000c43131b231ULL, 0x080fe400003400ffULL,
0x000000c43333b231ULL, 0x000fe200003400ffULL, 0x00000018ff367819ULL, 0x000fc80000011436ULL,
0x00000037007e7306ULL, 0x0004f0000000d400ULL, 0x0000008000d27306ULL, 0x000fe20000209400ULL,
0x0001000037377824ULL, 0x004fe200078e00ffULL, 0x000000ce8f00720bULL, 0x002fe20003f9d000ULL,
0x000001005ece7824ULL, 0x000fc600078e00ffULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000008000d57306ULL, 0x000fe20000205400ULL, 0x00000018ffce7819ULL, 0x000fcc00000114ceULL,
0x000000017e7e4812ULL, 0x008fe200078efcffULL, 0x0000008000887306ULL, 0x0003e2000020d400ULL,
0x0000009acb00720bULL, 0x000fce0003f9d000ULL, 0x0000006100c87306ULL, 0x000fe20000009400ULL,
0x0000010062807824ULL, 0x002fca00078e00ffULL, 0x00000018ff847819ULL, 0x000fe40000011480ULL,
0x0000006100cd7306ULL, 0x000e620000005400ULL, 0x000000017b7b4812ULL, 0x000fe400078efcffULL,
0x000000d3d000720bULL, 0x000fca0003f9d000ULL, 0x0000006100147306ULL, 0x0004f0000000d400ULL,
0x0000008100977306ULL, 0x000962000020d400ULL, 0x0001000061617824ULL, 0x004fe200078e00ffULL,
0x000000cdc800720bULL, 0x002fc40003f5d000ULL, 0x0000000160604812ULL, 0x000fc800078efcffULL,
0x0000003700de7306ULL, 0x000fe20000209400ULL, 0x00000018ff817819ULL, 0x010fcc000001147fULL,
0x0000000114142812ULL, 0x008fe200078efcffULL, 0x0000003700e17306ULL, 0x000e620000205400ULL,
0x0000000197975812ULL, 0x020fe400078efcffULL, 0x000000b9b800720bULL, 0x000fca0003f5d000ULL,
0x00000037008b7306ULL, 0x0004f0000020d400ULL, 0x0000008400bc7306ULL, 0x000fe20000209400ULL,
0x00000018ff377819ULL, 0x004fe40000011461ULL, 0x000000e1de00720bULL, 0x002fc40003fbd000ULL,
0x000000016c6c2812ULL, 0x000fc600078efcffULL, 0x0000008400bf7306ULL, 0x000e700000205400ULL,
0x0000008400807306ULL, 0x000ea2000020d400ULL, 0x000000018b8b5812ULL, 0x008fe400078efcffULL,
0x000000d5d200720bULL, 0x000fc40003fbd000ULL, 0x0000008b7c8b723eULL, 0x000fc600000010ffULL,
0x0000003700ca7306ULL, 0x000ff00000209400ULL, 0x0000003700cf7306ULL, 0x000fe20000205400ULL,
0x0000000188885812ULL, 0x000fe400078efcffULL, 0x000000c3c200720bULL, 0x000fca0003fbd000ULL,
0x0000003700617306ULL, 0x0007f0000020d400ULL, 0x0000003600ac7306ULL, 0x000fe20000209400ULL,
0x000001005c377824ULL, 0x008fe200078e00ffULL, 0x000000016b6b5812ULL, 0x000fc400078efcffULL,
0x000000bfbc00720bULL, 0x002fe40003fbd000ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000003600af7306ULL, 0x000e620000205400ULL, 0x000000606b60723eULL, 0x000fce00000010ffULL,
0x0000003600847306ULL, 0x000722000020d400ULL, 0x0000000180805812ULL, 0x004fce00078efcffULL,
0x0000003700a17306ULL, 0x000fe20000209400ULL, 0x0001000063367824ULL, 0x008fe200078e00ffULL,
0x000000afac00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003700a27306ULL, 0x000fee0000205400ULL, 0x0000000184845812ULL, 0x010fe200078efcffULL,
0x0000003600a87306ULL, 0x000ff00000209400ULL, 0x0000003600a97306ULL, 0x000ff00000205400ULL,
0x0000003600877306ULL, 0x000ff0000020d400ULL, 0x0000003700897306ULL, 0x0003f0000020d400ULL,
0x0000008100d47306ULL, 0x000fe20000209400ULL, 0x009800002b34783bULL, 0x002e6e0000000200ULL,
0x0000008100d77306ULL, 0x000eb00000205400ULL, 0x0000006200d67306ULL, 0x000ff00000009400ULL,
0x0000006200d97306ULL, 0x000ee20000005400ULL, 0x000000d7d400720bULL, 0x004fce0003f1d000ULL,
0x000000f900b27306ULL, 0x000ff00000209400ULL, 0x000000f900b57306ULL, 0x000ea20000205400ULL,
0x000000d9d600720bULL, 0x008fe20003fdd000ULL, 0x000000c73434b231ULL, 0x002fc400003400ffULL,
0x000000c73636b231ULL, 0x000fe400003400ffULL, 0x000000c43535b231ULL, 0x080fe400003400ffULL,
0x00000081007f7306ULL, 0x000e62000020d400ULL, 0x000000c43737b231ULL, 0x000fce00003400ffULL,
0x0000006200817306ULL, 0x000ee2000000d400ULL, 0x000000b5b200720bULL, 0x004fe20003f5d000ULL,
0x000000923454723cULL, 0x000fec0000041854ULL, 0x000000f900827306ULL, 0x000ea2000020d400ULL,
0x000000017f7f0812ULL, 0x002fe400078efcffULL, 0x000000cfca00720bULL, 0x000fc40003f1d000ULL,
0x000000b6bb92723eULL, 0x000fe400000010ffULL, 0x000000b0b193723eULL, 0x000fe200000010ffULL,
0x0000006300da7306ULL, 0x000fe20000009400ULL, 0x0000000181816812ULL, 0x008fe400078efcffULL,
0x000000a09f00720bULL, 0x000fe40003fdd000ULL, 0x000000147f7f723eULL, 0x000fe200000010ffULL,
0x00000092344c723cULL, 0x000fe2000004184cULL, 0x000000818080723eULL, 0x000fe200000010ffULL,
0x0000006300dd7306ULL, 0x000e620000005400ULL, 0x0000000182822812ULL, 0x004fc400078efcffULL,
0x0000008d8c00720bULL, 0x000fe40003f5d000ULL, 0x0000000161610812ULL, 0x000fe400078efcffULL,
0x0000008a9d8c723eULL, 0x000fe200000010ffULL, 0x0000005c00be7306ULL, 0x000fe20000009400ULL,
0x000000016d6d6812ULL, 0x000fe400078efcffULL, 0x000000a2a100720bULL, 0x000fe40003fdd000ULL,
0x000000a6ab92723eULL, 0x000fc400000010ffULL, 0x000000a4a793723eULL, 0x000fe200000010ffULL,
0x0000005c00c17306ULL, 0x000ea20000005400ULL, 0x000000ddda00720bULL, 0x002fe40003f7d000ULL,
0x000000016e6e2812ULL, 0x000fe400078efcffULL, 0x0000007e978d723eULL, 0x000fe200000010ffULL,
0x000000923444723cULL, 0x000fe20000041844ULL, 0x000000987d8a723eULL, 0x000fe200000010ffULL,
0x0000006300837306ULL, 0x000e62000000d400ULL, 0x0000000189896812ULL, 0x000fc400078efcffULL,
0x000000706f00720bULL, 0x000fe40003fdd000ULL, 0x0000007b887e723eULL, 0x000fe200000010ffULL,
0x0000008c343c723cULL, 0x000fe2000004183cULL, 0x000000616c61723eULL, 0x000fe200000010ffULL,
0x0000005c00627306ULL, 0x000ee2000000d400ULL, 0x000000c1be00720bULL, 0x004fca0003f9d000ULL,
0x0000008a3438723cULL, 0x000fe40000041838ULL, 0x0000005d00b47306ULL, 0x000fe20000009400ULL,
0x0000000183833812ULL, 0x002fe400078efcffULL, 0x000000a9a800720bULL, 0x000fe40003f7d000ULL,
0x0000000171716812ULL, 0x000fe200078efcffULL, 0x0000007e3054723cULL, 0x000fe20000041854ULL,
0x000000767500720bULL, 0x000fe20003fdd000ULL, 0x0000005d00b77306ULL, 0x000e620000005400ULL,
0x0000000162624812ULL, 0x008fc400078efcffULL, 0x000000838281723eULL, 0x000fca00000010ffULL,
0x0000005d00857306ULL, 0x0004e2000000d400ULL, 0x0000000187873812ULL, 0x000fe200078efcffULL,
0x00000080304c723cULL, 0x000fe4000004184cULL, 0x0000000177776812ULL, 0x000fc800078efcffULL,
0x0000005e009b7306ULL, 0x000fe20000009400ULL, 0x000100005f5d7824ULL, 0x004fe200078e00ffULL,
0x000000b7b400720bULL, 0x002fc80003f1d000ULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x0000005e009c7306ULL, 0x000e6e0000005400ULL, 0x0000000185850812ULL, 0x008fe200078efcffULL,
0x0000005e00867306ULL, 0x0004e2000000d400ULL, 0x000000737200720bULL, 0x000fce0003f1d000ULL,
0x0000005f00917306ULL, 0x000fe20000009400ULL, 0x000000c5c05e723eULL, 0x004fe400000010ffULL,
0x0000009c9b00720bULL, 0x002fc60003fbd000ULL, 0x0000000174740812ULL, 0x000fe400078efcffULL,
0x0000005f00947306ULL, 0x000e700000005400ULL, 0x0000005f00637306ULL, 0x000522000000d400ULL,
0x0000000186865812ULL, 0x008fce00078efcffULL, 0x000000e600957306ULL, 0x000fe20000209400ULL,
0x000000bdba5f723eULL, 0x004fe400000010ffULL, 0x000000949100720bULL, 0x002fca0003f7d000ULL,
0x000000e600967306ULL, 0x000e620000205400ULL, 0x0000005e3450723cULL, 0x000fee0000041850ULL,
0x000000dc008f7306ULL, 0x000fe20000209400ULL, 0x000000b3ae5e723eULL, 0x000fe400000010ffULL,
0x000000adaa5f723eULL, 0x000fc400000010ffULL, 0x0000000163633812ULL, 0x010fc600078efcffULL,
0x000000dc00907306ULL, 0x000ea20000205400ULL, 0x000000969500720bULL, 0x002fe20003f5d000ULL,
0x0000005e3448723cULL, 0x000fec0000041848ULL, 0x000000e6005c7306ULL, 0x000e62000020d400ULL,
0x000000a59e5e723eULL, 0x000fe200000010ffULL, 0x000000603050723cULL, 0x000fe20000041850ULL,
0x000000a38e5f723eULL, 0x000fca00000010ffULL, 0x000000dc009a7306ULL, 0x000ee2000020d400ULL,
0x000000908f00720bULL, 0x004fe20003f9d000ULL, 0x0000005e3440723cULL, 0x000fec0000041840ULL,
0x000000cc00c87306ULL, 0x000fe20000209400ULL, 0x000000015c5c2812ULL, 0x002fe400078efcffULL,
0x000000846d34723eULL, 0x000fc400000010ffULL, 0x000000876e35723eULL, 0x000fe400000010ffULL,
0x000000628984723eULL, 0x000fe200000010ffULL, 0x000000cc00c77306ULL, 0x000e620000205400ULL,
0x000000019a9a4812ULL, 0x008fe400078efcffULL, 0x000000855c85723eULL, 0x000fe200000010ffULL,
0x000000343048723cULL, 0x000fe20000041848ULL, 0x0000009a719a723eULL, 0x000fc600000010ffULL,
0x000000ce00ba7306ULL, 0x000fe80000209400ULL, 0x000000843044723cULL, 0x000fe80000041844ULL,
0x000000ce00b17306ULL, 0x000ea20000205400ULL, 0x000000c7c800720bULL, 0x002fce0003f5d000ULL,
0x000000cc00c37306ULL, 0x000e70000020d400ULL, 0x000000ce00ad7306ULL, 0x000ee2000020d400ULL,
0x000000b1ba00720bULL, 0x004fce0003f9d000ULL, 0x000000d100a47306ULL, 0x000fe20000209400ULL,
0x00000001c3c32812ULL, 0x002fe400078efcffULL, 0x000000797800720bULL, 0x000fe40003f5d000ULL,
0x000000c3749b723eULL, 0x000fc600000010ffULL, 0x000000d100937306ULL, 0x000e620000205400ULL,
0x00000001adad4812ULL, 0x008fc600078efcffULL, 0x0000009a3040723cULL, 0x000fe20000041840ULL,
0x00000086ad62723eULL, 0x000fc600000010ffULL, 0x00000099005e7306ULL, 0x000fe20000209400ULL,
0x000000017a7a2812ULL, 0x000fce00078efcffULL, 0x0000009900377306ULL, 0x000ea20000205400ULL,
0x00000093a400720bULL, 0x002fce0003f1d000ULL, 0x0000005d00367306ULL, 0x000ff00000209400ULL,
0x0000005d005f7306ULL, 0x000e620000205400ULL, 0x000000375e00720bULL, 0x004fce0003f9d000ULL,
0x000000d1008e7306ULL, 0x000eb0000020d400ULL, 0x0000009900147306ULL, 0x000ee2000020d400ULL,
0x0000005f3600720bULL, 0x002fce0003fbd000ULL, 0x0000005d00357306ULL, 0x000e62000020d400ULL,
0x000000018e8e0812ULL, 0x004fc800078efcffULL, 0x000000638e63723eULL, 0x000fe400000010ffULL,
0x0000000114144812ULL, 0x008fc800078efcffULL, 0x000000147734723eULL, 0x000fe200000010ffULL,
0x00000062303c723cULL, 0x000fe2000004183cULL, 0x0000000135355812ULL, 0x002fc800078efcffULL,
0x000000357a35723eULL, 0x000fce00000010ffULL, 0x000000343038723cULL, 0x000fe20000041838ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200015307f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000801c147810ULL, 0x000fe20007ffe0ffULL, 0x00f6900059ff7f8cULL, 0x0007e6000c80043fULL,
0x000000031400720cULL, 0x000fe40003f06070ULL, 0x000000011a147812ULL, 0x000fd600078ec0ffULL,
0x000059e000000947ULL, 0x000fea0003800000ULL, 0x0000040016067984ULL, 0x008ee40000000800ULL,
0x8000000006ff7812ULL, 0x00cfe40007804831ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240015067984ULL, 0x000ea40000000800ULL, 0x8000000006ff7812ULL, 0x004fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff067424ULL, 0x000fc800078e00ffULL, 0x00000006000b7305ULL, 0x0004e4000021f000ULL,
0x3fa0000006067823ULL, 0x004fe200000100ffULL, 0x0000000b0000735dULL, 0x008fe20003800000ULL,
0x0000240015147984ULL, 0x000ea40000000800ULL, 0x8000000014ff7812ULL, 0x004fc40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000119197824ULL, 0x000fe400078e021bULL,
0x00000300ff067624ULL, 0x000fe400078e00ffULL, 0x0000580009147a24ULL, 0x000fe200078e02ffULL,
0x00000001190b7812ULL, 0x000fe200078ec0ffULL, 0xffffffffff097424ULL, 0x000fe200078e00ffULL,
0xffffffff06067811ULL, 0x000fe400078e08ffULL, 0x000000010b00780cULL, 0x000fc80003f05070ULL,
0x0000000106627807ULL, 0x000fe40004000000ULL, 0x00000001ff0b7819ULL, 0x000fc60000011600ULL,
0x0000000119067824ULL, 0x000fca00078e0262ULL, 0x000000050600720cULL, 0x000fe20003f06070ULL,
0x000000200b067824ULL, 0x000fca00078e021cULL, 0x000000c006067810ULL, 0x000fc80007ffe0ffULL,
0x00000006031b7217ULL, 0x000fc60007800000ULL, 0x0000006218308210ULL, 0x000fe20007ffe019ULL,
0x00000004ff318424ULL, 0x000fe400078e00ffULL, 0x000000011b1b7824ULL, 0x100fe200078e0a06ULL,
0x000000600c067812ULL, 0x000fe200078ef806ULL, 0x0000600030308625ULL, 0x000fe200078e0031ULL,
0x0000000104327810ULL, 0x000fc60007ffe0ffULL, 0x0000008014337824ULL, 0x000fe200078e00ffULL,
0x000000073200720cULL, 0x000fe20003f46070ULL, 0x000000011d147824ULL, 0x100fe200078e0206ULL,
0x0000000630098981ULL, 0x000562000c1e1900ULL, 0x0000001000327824ULL, 0x000fe200078e00ffULL,
0xfffffff008357812ULL, 0x000fe400078ec0ffULL, 0x0000001433377210ULL, 0x000fe40007f1e0ffULL,
0x000000085a5d7812ULL, 0x000fe200078ec0ffULL, 0x00000000350573c2ULL, 0x00072200000e0000ULL,
0x0000001032347812ULL, 0x000fe200078ec0ffULL, 0x000000ffff327224ULL, 0x000fe200000e06ffULL,
0x000000201b1b7807ULL, 0x000fe20001000000ULL, 0x000000011f307824ULL, 0x104fe200078e0206ULL,
0x00005e00375c7a11ULL, 0x000fe200078038ffULL, 0x0000000121317824ULL, 0x100fe200078e0206ULL,
0x0000001b341b7217ULL, 0x000fe20007800000ULL, 0x0000000123067824ULL, 0x000fe200078e0206ULL,
0x0000003033307210ULL, 0x000fc40007f5e0ffULL, 0x000000085d607812ULL, 0x000fe200078e3cffULL,
0x000000011b1b7824ULL, 0x000fe200078e0a34ULL, 0x0000003133147210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff357224ULL, 0x008fe200010e06ffULL, 0x00005f0037377a11ULL, 0x000fe200000f3c32ULL,
0x00000000600473c2ULL, 0x000ea200000e0000ULL, 0x00005e0030327a11ULL, 0x000fe400078038ffULL,
0x0000000633067210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff337224ULL, 0x000fe200018e06ffULL,
0x00000003ff5e7819ULL, 0x000fc40000011602ULL, 0x00005e0014347a11ULL, 0x000fe200078438ffULL,
0x000000ffff317224ULL, 0x000fe200020e06ffULL, 0x00005f0030357a11ULL, 0x000fe200000f3c35ULL,
0x0000f6a805057890ULL, 0x010fe2000fffe03fULL, 0x0000001b5e00720cULL, 0x000fe40003f06070ULL,
0x00005f0014147a11ULL, 0x000fe400010f3c33ULL, 0x00005e0006367a11ULL, 0x000fe400078638ffULL,
0x000000275c307210ULL, 0x000fc40007f5e0ffULL, 0x000000045e6c7810ULL, 0x000fe40007ffe0ffULL,
0x00005f0006067a11ULL, 0x000fe200018f3c31ULL, 0x000000ffff317224ULL, 0x000fe200010e0637ULL,
0x000000085e5c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000405047290ULL, 0x004fe2000fffe03fULL,
0x0000000c5e5e7810ULL, 0x000fe40007ffe0ffULL, 0x0000002732327210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000301e7faeULL, 0x0005e2000c101c46ULL,
0x0000001b6c00720cULL, 0x000fc40003f86070ULL, 0x0000001b5c00720cULL, 0x080fe20003f66070ULL,
0x000000ffff337224ULL, 0x000fe200028e0635ULL, 0x0000001b5e00720cULL, 0x000fe40003f46070ULL,
0x0000002734347210ULL, 0x080fe40007f1e0ffULL, 0x0000002736367210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff357224ULL, 0x000fe400000e0614ULL, 0x000000ffff377224ULL, 0x000fe200028e0606ULL,
0x0000000032207faeULL, 0x0005e8000e101c46ULL, 0x0000000034227faeULL, 0x0005e8000d901c46ULL,
0x0000000036247faeULL, 0x0005e8000d101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000060607f8cULL, 0x000ee8000c800405ULL,
0x000004055d067984ULL, 0x0008620008000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480025307f8cULL, 0x004fe2000c80043fULL,
0x8000000006ff7812ULL, 0x002fc60007844817ULL, 0x00f64c00251b7984ULL, 0x000e640000000800ULL,
0x800000001bff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff067424ULL, 0x000fc800078e00ffULL, 0x0000000600147305ULL, 0x0002a4000021f000ULL,
0x3fa0000006067823ULL, 0x002fe200000100ffULL, 0x000000140000735dULL, 0x004fe20003800000ULL,
0x00f64c00251b7984ULL, 0x000e640000000800ULL, 0x800000001bff7812ULL, 0x002fc40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000100271b7810ULL, 0x000fca0007ffe026ULL,
0x00000001281b7824ULL, 0x000fca00078e021bULL, 0x00f000001b257984ULL, 0x000e680000000800ULL,
0x00f200001b067984ULL, 0x0005220000000800ULL, 0x0000000e2500720bULL, 0x002fe20003f1d000ULL,
0x0000f0527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x004fc800000e0100ULL,
0x0000ffff141e7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ffcc7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x00000002001b7811ULL, 0x000fe400078ff0ffULL, 0x0000000e2500720bULL, 0x000fe40003f14000ULL,
0x000000001b00720cULL, 0x000fe20003f65270ULL, 0x0000f0227f007947ULL, 0x000ff4000b800000ULL,
0x0000000000147806ULL, 0x000fe400000e0100ULL, 0x000000250e207209ULL, 0x000fe20007810000ULL,
0x00000080001bb824ULL, 0x000fe200078e0227ULL, 0x00000002ff347819ULL, 0x000fc60000011602ULL,
0x000000012831b824ULL, 0x000fe200078e021bULL, 0x0000ffff141b7812ULL, 0x000fe200078e3cffULL,
0x800000200e0e7221ULL, 0x000fc60000010000ULL, 0x00f400203100b388ULL, 0x0003e20000000800ULL,
0x3fb8aa3b0e0e7820ULL, 0x000fe20000410000ULL, 0x0000001b1eff7212ULL, 0x000fc6000780c0ffULL,
0x0000000e00337308ULL, 0x000ea40000000800ULL, 0x000000330f0f7220ULL, 0x004fe20000410000ULL,
0x0000efb27f007947ULL, 0x000fea000b800000ULL, 0x00001f34330e7589ULL, 0x0022a400000e0000ULL,
0x0000000e54547220ULL, 0x084fe40000410000ULL, 0x0000000e55557220ULL, 0x080fe40000410000ULL,
0x0000000e50507220ULL, 0x080fe40000410000ULL, 0x0000000e51517220ULL, 0x080fe40000410000ULL,
0x0000000e4c4c7220ULL, 0x000fc40000410000ULL, 0x0000000e4d4d7220ULL, 0x080fe40000410000ULL,
0x0000000e48487220ULL, 0x080fe40000410000ULL, 0x0000000e49497220ULL, 0x080fe40000410000ULL,
0x0000000e44447220ULL, 0x080fe40000410000ULL, 0x0000000e45457220ULL, 0x080fe40000410000ULL,
0x0000000e40407220ULL, 0x000fc40000410000ULL, 0x0000000e41417220ULL, 0x080fe40000410000ULL,
0x0000000e3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000e3d3d7220ULL, 0x080fe40000410000ULL,
0x0000000e38387220ULL, 0x080fe40000410000ULL, 0x0000000e39397220ULL, 0x000fe20000410000ULL,
0x0000eef27f007947ULL, 0x000fea000b800000ULL, 0x00001f2a330e7589ULL, 0x00046400000e0000ULL,
0x8000002025250221ULL, 0x000fe20000010000ULL, 0x00000001ffcc7807ULL, 0x000fe20000000000ULL,
0x0000000e56567220ULL, 0x002fc40000410000ULL, 0x3fb8aa3b25250820ULL, 0x000fe40000410000ULL,
0x0000000e57577220ULL, 0x080fe40000410000ULL, 0x0000002500290308ULL, 0x000e620000000800ULL,
0x0000000e52527220ULL, 0x080fe40000410000ULL, 0x0000000e53537220ULL, 0x080fe40000410000ULL,
0x0000000e4e4e7220ULL, 0x080fe40000410000ULL, 0x0000000e4f4f7220ULL, 0x000fc40000410000ULL,
0x0000000e4a4a7220ULL, 0x080fe40000410000ULL, 0x0000000e4b4b7220ULL, 0x080fe40000410000ULL,
0x0000000e46467220ULL, 0x080fe40000410000ULL, 0x0000000e47477220ULL, 0x080fe40000410000ULL,
0x0000000e42427220ULL, 0x080fe40000410000ULL, 0x0000000e43437220ULL, 0x000fc40000410000ULL,
0x0000000e3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000e3f3f7220ULL, 0x080fe40000410000ULL,
0x0000000e3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000e3b3b7220ULL, 0x000fe40000410000ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0020ULL, 0x0000000629060220ULL, 0x012fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000000f060f7221ULL, 0x010fe20000010000ULL, 0x000000f000002947ULL, 0x000fea0003800000ULL,
0x000000085a1b7812ULL, 0x000fe400078ec0ffULL, 0xfffffff008067812ULL, 0x000fca00078ec0ffULL,
0x00000001061b7824ULL, 0x000fca00078e021bULL, 0x00f6ac001b067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x0000000600147305ULL, 0x000324000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x000000140000735dULL, 0x010fe40003800000ULL, 0x00f6ac001b147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fc40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff347819ULL, 0x000fe40000011602ULL, 0x00000029ff17723eULL, 0x000fe400000010ffULL,
0x0000001834067810ULL, 0x040fe40007ffe0ffULL, 0x0000001034147810ULL, 0x000fe40007ffe0ffULL,
0x0000541017337816ULL, 0x004fe20000000017ULL, 0x0000ec527f007947ULL, 0x000fea000b800000ULL,
0x00001f3433b17589ULL, 0x0002a400000e0000ULL, 0x0000ec927f007947ULL, 0x000fea000b800000ULL,
0x00001f2a33247589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff347224ULL, 0x002fe200078e0014ULL, 0x00007d5000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000f60000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff347224ULL, 0x002fe200078e0006ULL, 0x00007db000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000f5a000007944ULL, 0x03cfea0003c00000ULL, 0x00001000665c7812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100000257824ULL, 0x000fe400078e00ffULL,
0x0000b0000d067810ULL, 0x000fc60007ffe05cULL, 0xffffe00025257812ULL, 0x000fe400078ec0ffULL,
0x000000102d307824ULL, 0x100fe400078e0206ULL, 0x000000102f347824ULL, 0x002fe200078e0206ULL,
0x0000b00025257810ULL, 0x000fc60007ffe05cULL, 0x000000003030783bULL, 0x014e640000004200ULL,
0x000000102c5c7824ULL, 0x100fe400078e0225ULL, 0x000000003434783bULL, 0x000ea20000004200ULL,
0x000000102e2e7824ULL, 0x000fc600078e0225ULL, 0x000000005c5c783bULL, 0x000f220000004200ULL,
0x00000018ff2d7819ULL, 0x002fe20000011431ULL, 0x0000003000b87306ULL, 0x000fe20000009400ULL,
0x00000018ff2f7819ULL, 0x000fe40000011432ULL, 0x00000018ff667819ULL, 0x000fe40000011433ULL,
0x00000018ff767819ULL, 0x004fe40000011436ULL, 0x00000018ff227819ULL, 0x000fe20000011430ULL,
0x0000002d00a97306ULL, 0x000fe20000209400ULL, 0x00000018ff6b7819ULL, 0x000fc40000011434ULL,
0x00000018ff777819ULL, 0x000fe40000011437ULL, 0x00000018ff257819ULL, 0x000fe40000011435ULL,
0x00000018ff797819ULL, 0x010fe2000001145fULL, 0x0000002d00a87306ULL, 0x000fe20000205400ULL,
0x00000018ff787819ULL, 0x000fce000001145eULL, 0x0000002d00147306ULL, 0x000ff0000020d400ULL,
0x0000002f008a7306ULL, 0x000ff00000209400ULL, 0x0000002f008b7306ULL, 0x000ff00000205400ULL,
0x0000002f001b7306ULL, 0x0003f0000020d400ULL, 0x0000006600847306ULL, 0x000fe20000209400ULL,
0x000000002e2c783bULL, 0x002e6e0000004200ULL, 0x0000006600857306ULL, 0x000ff00000205400ULL,
0x0000006600637306ULL, 0x000ff0000020d400ULL, 0x00000076006f7306ULL, 0x000ff00000209400ULL,
0x0000007600667306ULL, 0x000ff00000205400ULL, 0x0000007600707306ULL, 0x0005e2000020d400ULL,
0x00000018ff7a7819ULL, 0x002fce000001142eULL, 0x0000002200b37306ULL, 0x000fe20000209400ULL,
0x00000018ff767819ULL, 0x004fce000001145cULL, 0x0000007600997306ULL, 0x000ff00000209400ULL,
0x0000007600947306ULL, 0x000e700000205400ULL, 0x0000007600b67306ULL, 0x000530000020d400ULL,
0x0000002200b27306ULL, 0x000fe20000205400ULL, 0x00000018ff767819ULL, 0x004fc4000001142cULL,
0x000000949900720bULL, 0x002fca0003f7d000ULL, 0x0000007600d27306ULL, 0x000ff00000209400ULL,
0x0000007600cf7306ULL, 0x000fe20000205400ULL, 0x00000001b6b63812ULL, 0x010fce00078efcffULL,
0x00000076008e7306ULL, 0x0003f0000020d400ULL, 0x0000002200207306ULL, 0x000fe2000020d400ULL,
0x0000010030767824ULL, 0x002fca00078e00ffULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x0000006b00227306ULL, 0x000ff00000209400ULL, 0x0000006b00757306ULL, 0x000ff00000205400ULL,
0x0000006b00717306ULL, 0x000ff0000020d400ULL, 0x00000077006d7306ULL, 0x000ff00000209400ULL,
0x0000007700727306ULL, 0x000ff00000205400ULL, 0x00000077006b7306ULL, 0x0003f0000020d400ULL,
0x0000007600c87306ULL, 0x000fe20000209400ULL, 0x00000018ff777819ULL, 0x002fce000001145dULL,
0x0000007600c97306ULL, 0x000ff00000205400ULL, 0x00000076007f7306ULL, 0x0003f0000020d400ULL,
0x0000003000b77306ULL, 0x000fe20000005400ULL, 0x0000010032767824ULL, 0x002fca00078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe20000011476ULL, 0x0000010033767824ULL, 0x000fe200078e00ffULL,
0x0000003000747306ULL, 0x0003f0000000d400ULL, 0x00000025006e7306ULL, 0x000fe20000209400ULL,
0x0001000030307824ULL, 0x002fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000002500737306ULL, 0x000ff00000205400ULL, 0x00000025006c7306ULL, 0x000ff0000020d400ULL,
0x0000007700db7306ULL, 0x000ff00000209400ULL, 0x0000007700867306ULL, 0x000e700000205400ULL,
0x0000007700257306ULL, 0x000530000020d400ULL, 0x0000007900d17306ULL, 0x000fe20000209400ULL,
0x00000018ff777819ULL, 0x004fc4000001142dULL, 0x00000086db00720bULL, 0x002fe20003f1d000ULL,
0x000001002e867824ULL, 0x000fc800078e00ffULL, 0x0000007900d87306ULL, 0x000ff00000205400ULL,
0x00000079009a7306ULL, 0x0003e2000020d400ULL, 0x0000000125250812ULL, 0x010fce00078efcffULL,
0x0000007800d77306ULL, 0x000fe20000209400ULL, 0x00000018ff797819ULL, 0x002fce000001142fULL,
0x0000007800dc7306ULL, 0x000e700000205400ULL, 0x0000007800a07306ULL, 0x000eb0000020d400ULL,
0x0000007700d97306ULL, 0x000fe20000209400ULL, 0x000000dcd700720bULL, 0x002fce0003f1d000ULL,
0x0000007700d67306ULL, 0x000fec0000205400ULL, 0x00000001a0a00812ULL, 0x004fe400078efcffULL,
0x0000007700877306ULL, 0x0003f0000020d400ULL, 0x0000007900c67306ULL, 0x000fe20000209400ULL,
0x0000010031777824ULL, 0x002fce00078e00ffULL, 0x0000007900c77306ULL, 0x000ff00000205400ULL,
0x0000007900787306ULL, 0x000ff0000020d400ULL, 0x0000003200be7306ULL, 0x000ff00000009400ULL,
0x0000003200b97306ULL, 0x000ff00000005400ULL, 0x00000032001e7306ULL, 0x0003f0000000d400ULL,
0x0000003000c27306ULL, 0x000fe20000209400ULL, 0x0001000032327824ULL, 0x002fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003000c17306ULL, 0x000ff00000205400ULL,
0x0000003000797306ULL, 0x0003f0000020d400ULL, 0x0000007a00c47306ULL, 0x000fe20000209400ULL,
0x00000018ff307819ULL, 0x002fce0000011476ULL, 0x0000007a00c57306ULL, 0x000ff00000205400ULL,
0x0000007a00817306ULL, 0x0003f0000020d400ULL, 0x00000030009b7306ULL, 0x000fe20000209400ULL,
0x00000018ff7a7819ULL, 0x002fce0000011477ULL, 0x00000030009c7306ULL, 0x000ff00000205400ULL,
0x0000003000767306ULL, 0x0003f0000020d400ULL, 0x0000007a00ca7306ULL, 0x000fe20000209400ULL,
0x0000010035307824ULL, 0x002fce00078e00ffULL, 0x0000007a00cb7306ULL, 0x000ff00000205400ULL,
0x0000007a00777306ULL, 0x000ff0000020d400ULL, 0x0000003200957306ULL, 0x000ff00000209400ULL,
0x0000003200967306ULL, 0x000ff00000205400ULL, 0x00000032007a7306ULL, 0x0003f0000020d400ULL,
0x0000003100bd7306ULL, 0x000fe20000009400ULL, 0x00000018ff327819ULL, 0x002fe20000011430ULL,
0x000001005c307824ULL, 0x000fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000003100ba7306ULL, 0x000ff00000005400ULL, 0x0000003100067306ULL, 0x0003f0000000d400ULL,
0x00000030008d7306ULL, 0x000fe20000209400ULL, 0x0001000031317824ULL, 0x002fca00078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000030008c7306ULL, 0x000e700000205400ULL,
0x0000005c00e77306ULL, 0x000ff00000009400ULL, 0x0000005c00e87306ULL, 0x000ea20000005400ULL,
0x0000008c8d00720bULL, 0x002fce0003f5d000ULL, 0x0000005c00c37306ULL, 0x000330000000d400ULL,
0x0000003100ad7306ULL, 0x000fe20000209400ULL, 0x000100005c5c7824ULL, 0x002fe200078e00ffULL,
0x000000e8e700720bULL, 0x004fc80003f9d000ULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000003100b07306ULL, 0x000fee0000205400ULL, 0x00000001c3c34812ULL, 0x010fe200078efcffULL,
0x00000031007b7306ULL, 0x0003f0000020d400ULL, 0x0000003000ce7306ULL, 0x000522000020d400ULL,
0x0000010034317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000005c00e97306ULL, 0x000fe20000209400ULL, 0x000001005e307824ULL, 0x004fce00078e00ffULL,
0x0000005c00ea7306ULL, 0x000e620000205400ULL, 0x00000001cece2812ULL, 0x010fce00078efcffULL,
0x0000003100887306ULL, 0x000ff00000209400ULL, 0x0000003100897306ULL, 0x000fe20000205400ULL,
0x000000eae900720bULL, 0x002fe40003f5d000ULL, 0x00000018ffe97819ULL, 0x000fca0000011486ULL,
0x00000031007e7306ULL, 0x0003f0000020d400ULL, 0x0000005d00e07306ULL, 0x000fe20000009400ULL,
0x000001005d317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000005d00df7306ULL, 0x000e700000005400ULL, 0x0000005d00bf7306ULL, 0x0005f0000000d400ULL,
0x0000005c00cd7306ULL, 0x0008e2000020d400ULL, 0x000100005d5d7824ULL, 0x004fe200078e00ffULL,
0x000000dfe000720bULL, 0x002fc80003fdd000ULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x0000005e00a27306ULL, 0x000fe20000009400ULL, 0x00000018ff5c7819ULL, 0x010fe20000011430ULL,
0x000001005f307824ULL, 0x000fca00078e00ffULL, 0x00000018ff927819ULL, 0x000fe20000011430ULL,
0x0000005d00ed7306ULL, 0x000fe20000209400ULL, 0x00000001cdcd2812ULL, 0x008fe400078efcffULL,
0x00000001bfbf6812ULL, 0x000fca00078efcffULL, 0x0000005d00ee7306ULL, 0x000e700000205400ULL,
0x0000005e00dd7306ULL, 0x000eb00000005400ULL, 0x0000005e00ac7306ULL, 0x000722000000d400ULL,
0x000000eeed00720bULL, 0x002fce0003f5d000ULL, 0x0000003200837306ULL, 0x000fe20000209400ULL,
0x000100005e5e7824ULL, 0x008fe200078e00ffULL, 0x000000dda200720bULL, 0x004fe20003fbd000ULL,
0x000001002fdd7824ULL, 0x000fc600078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x0000003200827306ULL, 0x000fee0000205400ULL, 0x00000001acac5812ULL, 0x010fe200078efcffULL,
0x0000003200807306ULL, 0x000fe2000020d400ULL, 0x000000d8d100720bULL, 0x000fce0003fbd000ULL,
0x0000003100eb7306ULL, 0x000fec0000209400ULL, 0x000000019a9a5812ULL, 0x000fe400078efcffULL,
0x0000003100ec7306ULL, 0x000e700000205400ULL, 0x0000003100d07306ULL, 0x000ff0000020d400ULL,
0x0000005d00c07306ULL, 0x0004e2000020d400ULL, 0x000000eceb00720bULL, 0x002fc40003f9d000ULL,
0x00000018ffeb7819ULL, 0x000fca00000114ddULL, 0x0000005e00327306ULL, 0x000fe20000209400ULL,
0x000001002d5d7824ULL, 0x004fca00078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x0000005e00317306ULL, 0x000e620000205400ULL, 0x00000001c0c02812ULL, 0x008fe400078efcffULL,
0x00000001d0d04812ULL, 0x000fe400078efcffULL, 0x000000c02525723eULL, 0x000fc600000010ffULL,
0x0000005c00ef7306ULL, 0x000ff00000209400ULL, 0x0000005c00f07306ULL, 0x000ea20000205400ULL,
0x000000313200720bULL, 0x002fce0003f5d000ULL, 0x0000005f00de7306ULL, 0x000ff00000009400ULL,
0x0000005f00a37306ULL, 0x000e620000005400ULL, 0x000000f0ef00720bULL, 0x004fce0003f7d000ULL,
0x0000005f00a17306ULL, 0x0004f0000000d400ULL, 0x0000005e00af7306ULL, 0x000f22000020d400ULL,
0x000100005f5f7824ULL, 0x004fe200078e00ffULL, 0x000000a3de00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000005d00e57306ULL, 0x000fee0000209400ULL,
0x00000001a1a14812ULL, 0x008fe200078efcffULL, 0x0000005d00e67306ULL, 0x000e620000205400ULL,
0x00000001afaf2812ULL, 0x010fce00078efcffULL, 0x0000003300bb7306ULL, 0x000ff00000009400ULL,
0x0000003300bc7306ULL, 0x000fe20000005400ULL, 0x000000e6e500720bULL, 0x002fce0003f5d000ULL,
0x0000003300177306ULL, 0x0003f0000000d400ULL, 0x0000005c00b57306ULL, 0x0004e2000020d400ULL,
0x0001000033337824ULL, 0x002fca00078e00ffULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000002c00d47306ULL, 0x000fe20000009400ULL, 0x000001002c5c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000002c00d57306ULL, 0x000e620000005400ULL,
0x00000001b5b53812ULL, 0x008fce00078efcffULL, 0x0000002c00977306ULL, 0x0004f0000000d400ULL,
0x0000005f00e17306ULL, 0x000fe20000209400ULL, 0x000100002c2c7824ULL, 0x004fe200078e00ffULL,
0x000000d5d400720bULL, 0x002fc80003f9d000ULL, 0x00000018ff5e7819ULL, 0x000fe4000001142cULL,
0x0000005f00e27306ULL, 0x000e6e0000205400ULL, 0x0000000197974812ULL, 0x008fe200078efcffULL,
0x0000007c00a47306ULL, 0x000ff00000209400ULL, 0x0000007c00a57306ULL, 0x000fe20000205400ULL,
0x000000e2e100720bULL, 0x002fce0003f7d000ULL, 0x0000007c007d7306ULL, 0x000ff0000020d400ULL,
0x00000033008f7306ULL, 0x000ff00000209400ULL, 0x0000003300907306ULL, 0x000ff00000205400ULL,
0x00000033007c7306ULL, 0x000ff0000020d400ULL, 0x0000005d009e7306ULL, 0x000e70000020d400ULL,
0x0000009200307306ULL, 0x000ff00000209400ULL, 0x0000009200337306ULL, 0x000ea20000205400ULL,
0x000000019e9e2812ULL, 0x002fce00078efcffULL, 0x0000005e002c7306ULL, 0x000ff00000209400ULL,
0x0000005e00f17306ULL, 0x000e620000205400ULL, 0x000000333000720bULL, 0x004fe40003fdd000ULL,
0x00a000002b30783bULL, 0x000eaa0000000200ULL, 0x000000e900e77306ULL, 0x000ff00000209400ULL,
0x000000e900ea7306ULL, 0x000ee20000205400ULL, 0x000000f12c00720bULL, 0x002fce0003fbd000ULL,
0x0000002d00da7306ULL, 0x000ff00000009400ULL, 0x0000002d00d37306ULL, 0x000e620000005400ULL,
0x000000eae700720bULL, 0x008fce0003f5d000ULL, 0x0000002d00917306ULL, 0x000730000000d400ULL,
0x0000002e00df7306ULL, 0x000fe20000009400ULL, 0x000100002d2d7824ULL, 0x008fe200078e00ffULL,
0x000000d3da00720bULL, 0x002fc80003f1d000ULL, 0x00000018fff37819ULL, 0x000fe4000001142dULL,
0x0000002e00e07306ULL, 0x000e6e0000005400ULL, 0x0000000191910812ULL, 0x010fe200078efcffULL,
0x0000002e00997306ULL, 0x000730000000d400ULL, 0x0000005f00a77306ULL, 0x000ea2000020d400ULL,
0x000100002e2e7824ULL, 0x008fe200078e00ffULL, 0x000000e0df00720bULL, 0x002fc80003f1d000ULL,
0x00000018ffd77819ULL, 0x000fe4000001142eULL, 0x0000009200ae7306ULL, 0x000e6e000020d400ULL,
0x0000000199990812ULL, 0x010fe200078efcffULL, 0x0000005e009f7306ULL, 0x000ee2000020d400ULL,
0x00000001a7a73812ULL, 0x004fc400078efcffULL, 0x000000cfd200720bULL, 0x000fe40003f7d000ULL,
0x00009910cccf7816ULL, 0x000fe400000000ffULL, 0x000000c7c600720bULL, 0x000fe20003f1d000ULL,
0x000000e900a27306ULL, 0x000ea2000020d400ULL, 0x00000001aeae6812ULL, 0x002fe200078efcffULL,
0x0000010036c67824ULL, 0x000fe400078e00ffULL, 0x0000010037c77824ULL, 0x000fc600078e00ffULL,
0x00000018ffc67819ULL, 0x000fe200000114c6ULL, 0x0000005c00e37306ULL, 0x000fe20000209400ULL,
0x000000019f9f5812ULL, 0x008fe400078efcffULL, 0x000000018e8e3812ULL, 0x000fe400078efcffULL,
0x000000ffcf00720cULL, 0x000fe40003f65270ULL, 0x0000000178780812ULL, 0x000fe200078efcffULL,
0x0000005c00e47306ULL, 0x000e620000205400ULL, 0x00000001a2a22812ULL, 0x004fc400078efcffULL,
0x000000cbca00720bULL, 0x000fe40003f1d000ULL, 0x00000099a2a2723eULL, 0x000fe400000010ffULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x000000f3002d7306ULL, 0x000fe40000209400ULL,
0x000000243131b231ULL, 0x080fe400003400ffULL, 0x000000243333b231ULL, 0x000fe400003400ffULL,
0x000000b13030b231ULL, 0x000fc400003400ffULL, 0x000000f300f27306ULL, 0x000ea20000205400ULL,
0x000000e4e300720bULL, 0x002fe20003fdd000ULL, 0x000000b13232b231ULL, 0x000fe200003400ffULL,
0x0000000177770812ULL, 0x000fe400078efcffULL, 0x000000b0ad00720bULL, 0x000fc60003f1d000ULL,
0x000000eb00dd7306ULL, 0x000ff00000209400ULL, 0x000000eb00de7306ULL, 0x000e620000205400ULL,
0x000000f22d00720bULL, 0x004fe40003f9d000ULL, 0x000000017b7b0812ULL, 0x000fca00078efcffULL,
0x000000d700dc7306ULL, 0x000ff00000209400ULL, 0x000000d700d17306ULL, 0x000ea20000205400ULL,
0x000000dedd00720bULL, 0x002fce0003fbd000ULL, 0x0000002f00db7306ULL, 0x000ff00000009400ULL,
0x0000002f00e87306ULL, 0x000fe20000005400ULL, 0x000000d1dc00720bULL, 0x004fce0003f5d000ULL,
0x0000002f00947306ULL, 0x0003f0000000d400ULL, 0x0000005c00a67306ULL, 0x000ea2000020d400ULL,
0x000100002f2f7824ULL, 0x002fca00078e00ffULL, 0x00000018ffd37819ULL, 0x000fe4000001142fULL,
0x000000f300987306ULL, 0x000e62000020d400ULL, 0x00a00000582c783bULL, 0x000eee0000000200ULL,
0x000000eb00a37306ULL, 0x000f22000020d400ULL, 0x00000001a6a66812ULL, 0x004fc400078efcffULL,
0x000000d6d900720bULL, 0x000fca0003fdd000ULL, 0x000000d700cc7306ULL, 0x000ea2000020d400ULL,
0x0000000198984812ULL, 0x002fe400078efcffULL, 0x000000e8db00720bULL, 0x000fca0003f9d000ULL,
0x000000d300d27306ULL, 0x000fe20000209400ULL, 0x00000001a3a35812ULL, 0x010fe400078efcffULL,
0x0000000187876812ULL, 0x000fe400078efcffULL, 0x000000c5c400720bULL, 0x000fe20003fdd000ULL,
0x0001000036c47824ULL, 0x000fe400078e00ffULL, 0x000000d300d57306ULL, 0x000e620000205400ULL,
0x00000001cccc2812ULL, 0x004fe400078efcffULL, 0x000000babd00720bULL, 0x000fc40003f5d000ULL,
0x0000000194944812ULL, 0x000fe400078efcffULL, 0x000000b7b800720bULL, 0x000fe20003f9d000ULL,
0x000000d300cf7306ULL, 0x000ea2000020d400ULL, 0x000000242d2db231ULL, 0x088fe200003400ffULL,
0x0000000181816812ULL, 0x000fe200078efcffULL, 0x000000242f2fb231ULL, 0x000fe200003400ffULL,
0x000000b9be00720bULL, 0x000fe20003fdd000ULL, 0x000000b12c2cb231ULL, 0x080fe200003400ffULL,
0x000000cdb624723eULL, 0x000fe200000010ffULL, 0x000000b12e2eb231ULL, 0x000fe200003400ffULL,
0x000000d5d200720bULL, 0x002fe20003fbd000ULL, 0x00000034009d7306ULL, 0x000fe20000009400ULL,
0x0000000106062812ULL, 0x000fc400078efcffULL, 0x000000a8a900720bULL, 0x000fe20003f5d000ULL,
0x000000243050723cULL, 0x000fe20000041850ULL, 0x0000000174744812ULL, 0x000fe400078efcffULL,
0x000000c1c200720bULL, 0x000fe20003f9d000ULL, 0x0000003400b47306ULL, 0x000e620000005400ULL,
0x000000011e1e6812ULL, 0x000fe400078efcffULL, 0x0000008b8a00720bULL, 0x000fe40003fdd000ULL,
0x00000001cfcf5812ULL, 0x004fc400078efcffULL, 0x000000c9c800720bULL, 0x000fe20003fbd000ULL,
0x00000034005d7306ULL, 0x0004e2000000d400ULL, 0x0000000114142812ULL, 0x000fe400078efcffULL,
0x0000009c9b00720bULL, 0x000fe40003f5d000ULL, 0x0000000179794812ULL, 0x000fe400078efcffULL,
0x000000afa024723eULL, 0x000fe200000010ffULL, 0x0000003500aa7306ULL, 0x000fe20000009400ULL,
0x0001000034347824ULL, 0x004fe200078e00ffULL, 0x000000b49d00720bULL, 0x002fc40003f9d000ULL,
0x000000017f7f5812ULL, 0x000fe400078efcffULL, 0x000000b2b300720bULL, 0x000fe40003fbd000ULL,
0x0000003500ab7306ULL, 0x000e620000005400ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000000176762812ULL, 0x000fe400078efcffULL, 0x000000858400720bULL, 0x000fe40003f5d000ULL,
0x000000a79a25723eULL, 0x000fe200000010ffULL, 0x00000035005f7306ULL, 0x000522000000d400ULL,
0x00000094a3a3723eULL, 0x000fc400000010ffULL, 0x0000000120205812ULL, 0x000fe400078efcffULL,
0x000000a5a400720bULL, 0x000fe20003fbd000ULL, 0x000000243048723cULL, 0x040fe20000041848ULL,
0x000000cc81cc723eULL, 0x000fe200000010ffULL, 0x0000003600927306ULL, 0x000fe20000009400ULL,
0x0001000035357824ULL, 0x004fe200078e00ffULL, 0x000000cf78cd723eULL, 0x000fe400000010ffULL,
0x000000011b1b6812ULL, 0x000fe400078efcffULL, 0x00000018ffb97819ULL, 0x000fe20000011435ULL,
0x000000a2303c723cULL, 0x000fe2000004183cULL, 0x0000003600937306ULL, 0x000ea20000005400ULL,
0x000000bfd035723eULL, 0x000fc400000010ffULL, 0x0000009f8e24723eULL, 0x000fe400000010ffULL,
0x000000988725723eULL, 0x000fe400000010ffULL, 0x000000017d7d5812ULL, 0x000fe200078efcffULL,
0x00000036005c7306ULL, 0x000fe2000000d400ULL, 0x0000000163632812ULL, 0x000fe200078efcffULL,
0x000000cc3038723cULL, 0x000fe20000041838ULL, 0x000000015d5d4812ULL, 0x008fe400078efcffULL,
0x000000bcbb00720bULL, 0x000fc40003f7d000ULL, 0x000000abaa00720bULL, 0x002fe20003f1d000ULL,
0x0000003400867306ULL, 0x000fe20000209400ULL, 0x000000969500720bULL, 0x000fe20003fbd000ULL,
0x000000243040723cULL, 0x000fe20000041840ULL, 0x000000898800720bULL, 0x000fe40003fdd000ULL,
0x000000828300720bULL, 0x000fe40003f5d000ULL, 0x00000018ffc47819ULL, 0x000fe200000114c4ULL,
0x0000003400c57306ULL, 0x000e620000205400ULL, 0x000000067725723eULL, 0x000fc400000010ffULL,
0x0000000117173812ULL, 0x000fe400078efcffULL, 0x000000015f5f0812ULL, 0x010fe400078efcffULL,
0x000000017a7a5812ULL, 0x000fe200078efcffULL, 0x0000003400367306ULL, 0x000722000020d400ULL,
0x000000017e7e6812ULL, 0x000fe400078efcffULL, 0x0000000180802812ULL, 0x000fe400078efcffULL,
0x000000908f00720bULL, 0x000fc40003f7d000ULL, 0x000000939200720bULL, 0x004fe20003fbd000ULL,
0x000000b900b77306ULL, 0x000fe20000209400ULL, 0x000000c3ce34723eULL, 0x008fe400000010ffULL,
0x000000c58600720bULL, 0x002fe40003f9d000ULL, 0x000000752200720bULL, 0x000fe40003fdd000ULL,
0x000000736e00720bULL, 0x000fe20003f1d000ULL, 0x000000343054723cULL, 0x000fe20000041854ULL,
0x000000b900b87306ULL, 0x000e620000205400ULL, 0x000000747f24723eULL, 0x000fc400000010ffULL,
0x000000017c7c3812ULL, 0x000fe400078efcffULL, 0x000000015c5c5812ULL, 0x000fe400078efcffULL,
0x000000acb534723eULL, 0x000fe200000010ffULL, 0x000000c600ad7306ULL, 0x000fe20000209400ULL,
0x000000a1ae35723eULL, 0x000fe400000010ffULL, 0x0000000136364812ULL, 0x010fe400078efcffULL,
0x0000000171716812ULL, 0x000fc400078efcffULL, 0x000000016c6c0812ULL, 0x000fe200078efcffULL,
0x00000034304c723cULL, 0x000fe2000004184cULL, 0x000000c600a87306ULL, 0x000ea20000205400ULL,
0x000000b8b700720bULL, 0x002fe40003f5d000ULL, 0x000000666f00720bULL, 0x000fe40003fdd000ULL,
0x0000005d7e7e723eULL, 0x000fe400000010ffULL, 0x00000097a634723eULL, 0x000fe200000010ffULL,
0x00000037008c7306ULL, 0x000fe20000009400ULL, 0x000000919e35723eULL, 0x000fe200000010ffULL,
0x000000242c54723cULL, 0x000fe20000041854ULL, 0x000000367136723eULL, 0x000fc400000010ffULL,
0x0000007a1b7a723eULL, 0x000fe400000010ffULL, 0x0000005f807f723eULL, 0x000fe200000010ffULL,
0x00000037008d7306ULL, 0x000e620000005400ULL, 0x000000a8ad00720bULL, 0x004fe20003f9d000ULL,
0x000000343044723cULL, 0x000fe20000041844ULL, 0x000000177625723eULL, 0x000fe400000010ffULL,
0x0000000170706812ULL, 0x000fe400078efcffULL, 0x0000001e7d24723eULL, 0x000fe200000010ffULL,
0x00000037005e7306ULL, 0x0004e2000000d400ULL, 0x000000792030723eULL, 0x000fc400000010ffULL,
0x0000007b1431723eULL, 0x000fe400000010ffULL, 0x0000007c637b723eULL, 0x000fe200000010ffULL,
0x000000242c4c723cULL, 0x000fe4000004184cULL, 0x000000b900b17306ULL, 0x000f22000020d400ULL,
0x0001000037377824ULL, 0x004fe200078e00ffULL, 0x0000008d8c00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff067819ULL, 0x000fe20000011437ULL, 0x000000302c50723cULL, 0x040fe20000041850ULL,
0x000000c6009d7306ULL, 0x000e6e000020d400ULL, 0x000000015e5e3812ULL, 0x008fe200078efcffULL,
0x000000c700917306ULL, 0x000fe20000209400ULL, 0x00000001b1b12812ULL, 0x010fe200078efcffULL,
0x0000007a2c48723cULL, 0x000fe20000041848ULL, 0x000000726d00720bULL, 0x000fc40003f5d000ULL,
0x000000b16c37723eULL, 0x000fc600000010ffULL, 0x000000c700847306ULL, 0x000ea20000205400ULL,
0x000000019d9d4812ULL, 0x002fe200078efcffULL, 0x0000007e2c44723cULL, 0x000fe60000041844ULL,
0x0000005c9d5c723eULL, 0x000fc600000010ffULL, 0x000000c400347306ULL, 0x000fe20000209400ULL,
0x000000016b6b2812ULL, 0x000fe200078efcffULL, 0x000000362c40723cULL, 0x000fec0000041840ULL,
0x000000c400337306ULL, 0x000e620000205400ULL, 0x000000849100720bULL, 0x004fce0003f1d000ULL,
0x0000000600147306ULL, 0x000ff00000209400ULL, 0x0000000600317306ULL, 0x000ea20000205400ULL,
0x000000333400720bULL, 0x002fce0003f9d000ULL, 0x000000c700357306ULL, 0x000e70000020d400ULL,
0x000000c400177306ULL, 0x000ee2000020d400ULL, 0x000000311400720bULL, 0x004fce0003fbd000ULL,
0x0000000600067306ULL, 0x000ea2000020d400ULL, 0x0000000135350812ULL, 0x002fc800078efcffULL,
0x0000005e355d723eULL, 0x000fe400000010ffULL, 0x0000000117174812ULL, 0x008fc800078efcffULL,
0x000000177070723eULL, 0x000fe200000010ffULL, 0x0000005c2c3c723cULL, 0x000fe2000004183cULL,
0x0000000106065812ULL, 0x004fc800078efcffULL, 0x000000066b71723eULL, 0x000fce00000010ffULL,
0x000000702c38723cULL, 0x000fe20000041838ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200015247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c01c1c7810ULL, 0x000fe20007ffe0ffULL,
0x00f6980059ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff317224ULL, 0x004fe200078e0025ULL,
0x000000011a147812ULL, 0x000fe200078e0cffULL, 0x0000000119067824ULL, 0x000fe200078e0262ULL,
0x000000031c00720cULL, 0x000fe20003f06070ULL, 0x000000ffff177224ULL, 0x000fd800078e0061ULL,
0x00002c2000000947ULL, 0x000fea0003800000ULL, 0x0000040016067984ULL, 0x008ea40000000800ULL,
0x8000000006ff7812ULL, 0x004fe40007804831ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240015067984ULL, 0x000ea40000000800ULL, 0x8000000006ff7812ULL, 0x004fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff067424ULL, 0x000fc800078e00ffULL, 0x0000000600147305ULL, 0x0004e4000021f000ULL,
0x3fa0000006067823ULL, 0x004fe200000100ffULL, 0x000000140000735dULL, 0x008fe40003800000ULL,
0x0000240015147984ULL, 0x000ea40000000800ULL, 0x8000000014ff7812ULL, 0x004fc40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000f6a80b257811ULL, 0x000fe200078e20ffULL,
0x00005800091b7a24ULL, 0x020fe200078e02ffULL, 0x0000030004067a10ULL, 0x000fe20007ffe0ffULL,
0x00000000640473c2ULL, 0x0004e200000e0000ULL, 0x00000001ff0b7819ULL, 0x000fe20000011600ULL,
0x000000801b1e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff247819ULL, 0x000fe40000011602ULL,
0x000000085a5a7812ULL, 0x000fe200078ec0ffULL, 0x0000000806147824ULL, 0x040fe200078e020bULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x00000004242e7810ULL, 0x000fe20007ffe0ffULL,
0x0000002014147824ULL, 0x000fe200078e00ffULL, 0x000000070600720cULL, 0x000fe40003f06070ULL,
0x00000008242c7810ULL, 0x000fe40007ffe0ffULL, 0x0000001403177217ULL, 0x000fe40007800000ULL,
0x000000600c067812ULL, 0x000fc600078ef814ULL, 0x0000000117177824ULL, 0x000fe400078e0a14ULL,
0x0000001000147824ULL, 0x000fe400078e00ffULL, 0x000000011d1d7824ULL, 0x100fe200078e0206ULL,
0x0000002017177807ULL, 0x000fe20000000000ULL, 0x000000011f1f7824ULL, 0x100fe200078e0206ULL,
0x00000010141c7812ULL, 0x000fe200078ec0ffULL, 0x0000000121217824ULL, 0x100fe200078e0206ULL,
0x0000001d1e1d7210ULL, 0x000fe20007f5e0ffULL, 0x0000000123067824ULL, 0x000fe200078e0206ULL,
0x000000171c177217ULL, 0x000fc40007800000ULL, 0x0000001f1e1f7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x00005e001d227a11ULL, 0x000fe200078038ffULL,
0x0000000117177824ULL, 0x000fe200078e0a1cULL, 0x000000211e217210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x000000061e067210ULL, 0x000fe40007f9e0ffULL,
0x00005f001d1d7a11ULL, 0x000fe200000f3c14ULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x00005e001f1e7a11ULL, 0x000fe200078038ffULL, 0x000000ffff1b7224ULL, 0x000fe200020e06ffULL,
0x00005e0021207a11ULL, 0x000fc400078438ffULL, 0x00005f001f1f7a11ULL, 0x000fe400000f3c1cULL,
0x000000271e1e7210ULL, 0x000fe40007fbe0ffULL, 0x000000172400720cULL, 0x000fe40003f66070ULL,
0x00000027221c7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff1f7224ULL, 0x000fe200028e061fULL,
0x0000000c24247810ULL, 0x000fe40007ffe0ffULL, 0x00005f0021147a11ULL, 0x000fe200010f3c14ULL,
0x000000ffff1d7224ULL, 0x000fe200030e061dULL, 0x000000172e00720cULL, 0x000fc40003f46070ULL,
0x00005e0006227a11ULL, 0x000fe400078838ffULL, 0x000000172c00720cULL, 0x080fe20003f06070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c677faeULL, 0x0009e2000d901c46ULL,
0x000000172400720cULL, 0x000fe40003fa6070ULL, 0x0000002720207210ULL, 0x080fe40007fde0ffULL,
0x00005f0006067a11ULL, 0x000fe400020f3c1bULL, 0x0000002722227210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff217224ULL, 0x000fe200030e0614ULL, 0x000000001e687faeULL, 0x0009e2000d101c46ULL,
0x0000000125147824ULL, 0x000fc400078e025aULL, 0x000000ffff237224ULL, 0x000fe200020e0606ULL,
0x0000000020697faeULL, 0x0009e8000c101c46ULL, 0x00000000226a7faeULL, 0x0009e8000e901c46ULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x008fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000141c7f8cULL, 0x0104e8000c80043fULL, 0x0000040065657984ULL, 0x000f220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f668005b1e7f8cULL, 0x000fe2000c80043fULL, 0x8000000065ff7812ULL, 0x010fc60007844861ULL,
0x00f66c005b177984ULL, 0x000f240000000800ULL, 0x8000000017ff7812ULL, 0x010fe4000780481fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x000000ffff177224ULL, 0x008fe200078e001dULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff067424ULL, 0x000fc800078e00ffULL, 0x0000000600147305ULL, 0x0044e4000021f000ULL,
0x3fa0000006067823ULL, 0x004fe200000100ffULL, 0x000000140000735dULL, 0x008fe20003800000ULL,
0x00f66c005b1b7984ULL, 0x000ea40000000800ULL, 0x800000001bff7812ULL, 0x004fc4000780481fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000180271b7810ULL, 0x000fca0007ffe026ULL,
0x00000001281b7824ULL, 0x000fca00078e021bULL, 0x00f000001b1d7984ULL, 0x000ee80000000800ULL,
0x00f200001b067984ULL, 0x0008620000000800ULL, 0x0000000e1d00720bULL, 0x008fe20003f1d000ULL,
0x0000c5d27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x014fc800000e0100ULL,
0x0000ffff141c7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff977424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x00000003001b7811ULL, 0x000fe400078ff0ffULL, 0x0000000e1d00720bULL, 0x000fe40003f14000ULL,
0x000000001b00720cULL, 0x000fe20003f65270ULL, 0x0000c5a27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000147806ULL, 0x000fe400000e0100ULL, 0x0000001d0e1e7209ULL, 0x000fe20007810000ULL,
0x000000800027b824ULL, 0x000fe200078e0227ULL, 0x0000ffff141b7812ULL, 0x000fe400078e3cffULL,
0x00000002ff347819ULL, 0x000fe20000011602ULL, 0x000000012827b824ULL, 0x000fe200078e0227ULL,
0x0000001b1cff7212ULL, 0x000fe2000780c0ffULL, 0x8000001e0e0e7221ULL, 0x000fc60000010000ULL,
0x00f4001e2700b388ULL, 0x0005e20000000800ULL, 0x3fb8aa3b0e0e7820ULL, 0x000fc80000410000ULL,
0x0000000e00337308ULL, 0x000ee40000000800ULL, 0x000000330f0f7220ULL, 0x008fe20000410000ULL,
0x0000c5327f007947ULL, 0x000fea000b800000ULL, 0x00001f34330e7589ULL, 0x0044e400000e0000ULL,
0x0000000e54547220ULL, 0x088fe40000410000ULL, 0x0000000e55557220ULL, 0x080fe40000410000ULL,
0x0000000e50507220ULL, 0x080fe40000410000ULL, 0x0000000e51517220ULL, 0x080fe40000410000ULL,
0x0000000e4c4c7220ULL, 0x000fc40000410000ULL, 0x0000000e4d4d7220ULL, 0x080fe40000410000ULL,
0x0000000e48487220ULL, 0x080fe40000410000ULL, 0x0000000e49497220ULL, 0x080fe40000410000ULL,
0x0000000e44447220ULL, 0x080fe40000410000ULL, 0x0000000e45457220ULL, 0x080fe40000410000ULL,
0x0000000e40407220ULL, 0x000fc40000410000ULL, 0x0000000e41417220ULL, 0x080fe40000410000ULL,
0x0000000e3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000e3d3d7220ULL, 0x080fe40000410000ULL,
0x0000000e38387220ULL, 0x080fe40000410000ULL, 0x0000000e39397220ULL, 0x000fe20000410000ULL,
0x0000c4727f007947ULL, 0x000fea000b800000ULL, 0x00001f2a330e7589ULL, 0x00072400000e0000ULL,
0x8000001e1d1d0221ULL, 0x000fe20000010000ULL, 0x00000001ff977807ULL, 0x000fe20000000000ULL,
0x0000000e56567220ULL, 0x010fc40000410000ULL, 0x3fb8aa3b1d1d0820ULL, 0x000fe40000410000ULL,
0x0000000e57577220ULL, 0x080fe40000410000ULL, 0x0000001d00290308ULL, 0x000f220000000800ULL,
0x0000000e52527220ULL, 0x080fe40000410000ULL, 0x0000000e53537220ULL, 0x080fe40000410000ULL,
0x0000000e4e4e7220ULL, 0x080fe40000410000ULL, 0x0000000e4f4f7220ULL, 0x000fc40000410000ULL,
0x0000000e4a4a7220ULL, 0x080fe40000410000ULL, 0x0000000e4b4b7220ULL, 0x080fe40000410000ULL,
0x0000000e46467220ULL, 0x080fe40000410000ULL, 0x0000000e47477220ULL, 0x080fe40000410000ULL,
0x0000000e42427220ULL, 0x080fe40000410000ULL, 0x0000000e43437220ULL, 0x000fc40000410000ULL,
0x0000000e3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000e3f3f7220ULL, 0x080fe40000410000ULL,
0x0000000e3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000e3b3b7220ULL, 0x000fe40000410000ULL,
0x000000ffff0e7224ULL, 0x000fe400078e001eULL, 0x0000000629060220ULL, 0x012fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000000f060f7221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x000000081a067824ULL, 0x000fe200078e00ffULL, 0xfffffff0081b7812ULL, 0x000fc800078ec0ffULL,
0x0000000806067812ULL, 0x000fca00078e0cffULL, 0x000000011b147824ULL, 0x000fca00078e0206ULL,
0x00f6ac00141b7984ULL, 0x000e640000000800ULL, 0x800000001bff7812ULL, 0x002fe40007804861ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff067424ULL, 0x000fc800078e00ffULL, 0x00000006001b7305ULL, 0x000324000021f000ULL,
0x3fa0000006067823ULL, 0x002fe200000100ffULL, 0x0000001b0000735dULL, 0x010fe40003800000ULL,
0x00f6ac00141b7984ULL, 0x000e640000000800ULL, 0x800000001bff7812ULL, 0x002fc40007804861ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff347819ULL, 0x004fe40000011602ULL,
0x00000029ff1b723eULL, 0x000fe400000010ffULL, 0x0000001834067810ULL, 0x040fe40007ffe0ffULL,
0x0000001034147810ULL, 0x000fe40007ffe0ffULL, 0x000054101b337816ULL, 0x008fe2000000001bULL,
0x0000c1c27f007947ULL, 0x000fea000b800000ULL, 0x00001f3433917589ULL, 0x0002a400000e0000ULL,
0x0000c2027f007947ULL, 0x000fea000b800000ULL, 0x00001f2a33907589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff347224ULL, 0x002fe200078e0014ULL,
0x0000aa4000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000c91000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff347224ULL, 0x002fe200078e0006ULL,
0x0000aaa000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000c8b000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000101c783bULL, 0x000f680000004200ULL,
0x000000001124783bULL, 0x000a680000004200ULL, 0x00000000122c783bULL, 0x000ee80000004200ULL,
0x000000001320783bULL, 0x0008a20000004200ULL, 0x00000018ff117819ULL, 0x020fe2000001141cULL,
0x0000001c00c37306ULL, 0x000fe20000009400ULL, 0x00000018ff337819ULL, 0x00afe2000001141fULL,
0x000001001c717824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fc40000011424ULL,
0x00000018ff137819ULL, 0x010fe4000001141dULL, 0x00000018ff5b7819ULL, 0x000fe2000001142dULL,
0x0000001c00c07306ULL, 0x000e620000005400ULL, 0x00000018ff5c7819ULL, 0x000fe4000001142eULL,
0x00000018ff727819ULL, 0x004fe40000011421ULL, 0x00000018ff327819ULL, 0x000fe4000001141eULL,
0x00000018ff357819ULL, 0x000fe20000011425ULL, 0x0000001c009c7306ULL, 0x0005e2000000d400ULL,
0x00000018ff717819ULL, 0x000fc40000011471ULL, 0x00000018ff367819ULL, 0x000fe40000011426ULL,
0x00000018ff377819ULL, 0x000fe40000011427ULL, 0x00000018ff5a7819ULL, 0x000fe2000001142cULL,
0x0000001100c47306ULL, 0x000fe20000209400ULL, 0x000100001c1c7824ULL, 0x004fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001142fULL, 0x00000018ff637819ULL, 0x000fe40000011420ULL,
0x00000018ff737819ULL, 0x000fc40000011422ULL, 0x0000001100c77306ULL, 0x000ea20000205400ULL,
0x00000018ff787819ULL, 0x000fe40000011423ULL, 0x000000c0c300720bULL, 0x002fca0003f1d000ULL,
0x0000001100987306ULL, 0x000e70000020d400ULL, 0x0000003300bf7306ULL, 0x000fe20000209400ULL,
0x000000c7c400720bULL, 0x004fe40003fbd000ULL, 0x000000019c9c0812ULL, 0x000fca00078efcffULL,
0x0000003300bc7306ULL, 0x000fec0000205400ULL, 0x0000000198985812ULL, 0x002fe400078efcffULL,
0x00000033007b7306ULL, 0x000ff0000020d400ULL, 0x0000003400b47306ULL, 0x000ff00000209400ULL,
0x0000003400117306ULL, 0x000ff00000205400ULL, 0x0000003400767306ULL, 0x000ff0000020d400ULL,
0x0000005b008c7306ULL, 0x000ff00000209400ULL, 0x0000005b008b7306ULL, 0x000ff00000205400ULL,
0x0000005b00337306ULL, 0x000ff0000020d400ULL, 0x0000005c00747306ULL, 0x000ff00000209400ULL,
0x0000005c00777306ULL, 0x000ff00000205400ULL, 0x0000005c00347306ULL, 0x000ff0000020d400ULL,
0x00000072005b7306ULL, 0x000ff00000209400ULL, 0x00000072005c7306ULL, 0x000ff00000205400ULL,
0x00000072005d7306ULL, 0x0003f0000020d400ULL, 0x0000001300c57306ULL, 0x000fe20000209400ULL,
0x00000018ff727819ULL, 0x002fce000001141cULL, 0x0000007200cb7306ULL, 0x000ff00000209400ULL,
0x00000072001c7306ULL, 0x000e700000205400ULL, 0x00000072009d7306ULL, 0x0004f0000020d400ULL,
0x0000001300be7306ULL, 0x000f220000205400ULL, 0x0000001ccb00720bULL, 0x002fe20003f5d000ULL,
0x000001001f727824ULL, 0x004fca00078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x00000013008f7306ULL, 0x000e6c000020d400ULL, 0x000000019d9d2812ULL, 0x008fe400078efcffULL,
0x0000007100c67306ULL, 0x000fe20000209400ULL, 0x000000bec500720bULL, 0x010fce0003f5d000ULL,
0x0000007100c97306ULL, 0x000eac0000205400ULL, 0x000000018f8f2812ULL, 0x002fe400078efcffULL,
0x0000003200ba7306ULL, 0x000ff00000209400ULL, 0x0000003200bd7306ULL, 0x000e620000205400ULL,
0x000000c9c600720bULL, 0x004fce0003f9d000ULL, 0x0000003200837306ULL, 0x000eb0000020d400ULL,
0x0000003500137306ULL, 0x000fe20000209400ULL, 0x000000bdba00720bULL, 0x002fce0003f5d000ULL,
0x0000003500b67306ULL, 0x000fec0000205400ULL, 0x0000000183832812ULL, 0x004fe400078efcffULL,
0x00000035006d7306ULL, 0x000ff0000020d400ULL, 0x0000003600a47306ULL, 0x000ff00000209400ULL,
0x0000003600a37306ULL, 0x000ff00000205400ULL, 0x00000036006b7306ULL, 0x000ff0000020d400ULL,
0x0000003700aa7306ULL, 0x000ff00000209400ULL, 0x0000003700ab7306ULL, 0x000ff00000205400ULL,
0x0000003700667306ULL, 0x000ff0000020d400ULL, 0x0000005a009a7306ULL, 0x000ff00000209400ULL,
0x0000005a00997306ULL, 0x000ff00000205400ULL, 0x0000005a00327306ULL, 0x000ff0000020d400ULL,
0x0000005f006e7306ULL, 0x000ff00000209400ULL, 0x0000005f006f7306ULL, 0x000ff00000205400ULL,
0x0000005f00357306ULL, 0x000ff0000020d400ULL, 0x0000006300367306ULL, 0x000ff00000209400ULL,
0x0000006300377306ULL, 0x000ff00000205400ULL, 0x00000063005a7306ULL, 0x000ff0000020d400ULL,
0x00000073005e7306ULL, 0x000ff00000209400ULL, 0x00000073005f7306ULL, 0x000ff00000205400ULL,
0x0000007300607306ULL, 0x0003f0000020d400ULL, 0x0000001d00ad7306ULL, 0x000fe20000009400ULL,
0x000001001d737824ULL, 0x002fca00078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x0000001d00c27306ULL, 0x000e700000005400ULL, 0x0000001d009b7306ULL, 0x0004f0000000d400ULL,
0x0000007800617306ULL, 0x000fe20000209400ULL, 0x000100001d1d7824ULL, 0x004fe200078e00ffULL,
0x000000c2ad00720bULL, 0x002fcc0003f7d000ULL, 0x0000007800647306ULL, 0x000fee0000205400ULL,
0x000000019b9b3812ULL, 0x008fe200078efcffULL, 0x0000007800637306ULL, 0x0003f0000020d400ULL,
0x0000007100af7306ULL, 0x0004e2000020d400ULL, 0x000001001e787824ULL, 0x002fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000001e00c17306ULL, 0x000fe20000009400ULL,
0x00000018ff717819ULL, 0x004fce000001141dULL, 0x00000071001d7306ULL, 0x000fe20000209400ULL,
0x00000001afaf4812ULL, 0x008fce00078efcffULL, 0x0000007100ca7306ULL, 0x000e700000205400ULL,
0x0000007800cc7306ULL, 0x000ff00000209400ULL, 0x0000007800cf7306ULL, 0x000ea20000205400ULL,
0x000000ca1d00720bULL, 0x002fe20003f9d000ULL, 0x00000100201d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x0000001e00927306ULL, 0x000e700000005400ULL,
0x0000001e008a7306ULL, 0x000722000000d400ULL, 0x000000cfcc00720bULL, 0x004fce0003fbd000ULL,
0x0000007100947306ULL, 0x000562000020d400ULL, 0x000100001e1e7824ULL, 0x008fe200078e00ffULL,
0x00000092c100720bULL, 0x002fcc0003f1d000ULL, 0x0000007800937306ULL, 0x0002e2000020d400ULL,
0x00000018ff717819ULL, 0x004fcc000001141eULL, 0x000000018a8a0812ULL, 0x010fe200078efcffULL,
0x0000002500b57306ULL, 0x000fe20000009400ULL, 0x0000010024787824ULL, 0x002fe200078e00ffULL,
0x0000000194944812ULL, 0x020fc800078efcffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000002500127306ULL, 0x000e620000005400ULL, 0x0000000193935812ULL, 0x008fe400078efcffULL,
0x000000bcbf00720bULL, 0x000fe40003fbd000ULL, 0x0000008a938a723eULL, 0x000fc600000010ffULL,
0x0000007300cd7306ULL, 0x000ff00000209400ULL, 0x0000007300c87306ULL, 0x000ea20000205400ULL,
0x00000012b500720bULL, 0x002fe40003f5d000ULL, 0x000000017b7b5812ULL, 0x000fca00078efcffULL,
0x00000071001e7306ULL, 0x000ff00000209400ULL, 0x0000007100d37306ULL, 0x000e620000205400ULL,
0x000000c8cd00720bULL, 0x004fce0003fdd000ULL, 0x0000002400b97306ULL, 0x000ff00000009400ULL,
0x0000002400b87306ULL, 0x000fe20000005400ULL, 0x000000d31e00720bULL, 0x002fce0003f9d000ULL,
0x00000024007e7306ULL, 0x0003f0000000d400ULL, 0x0000007200d17306ULL, 0x000fe20000209400ULL,
0x0001000024247824ULL, 0x002fca00078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000007200ce7306ULL, 0x000ff00000205400ULL, 0x0000007200897306ULL, 0x0003f0000020d400ULL,
0x0000007100887306ULL, 0x0004e2000020d400ULL, 0x0000010025727824ULL, 0x002fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000002500757306ULL, 0x000322000000d400ULL,
0x0000010026717824ULL, 0x004fca00078e00ffULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000007300ac7306ULL, 0x000ea2000020d400ULL, 0x0001000025257824ULL, 0x002fe200078e00ffULL,
0x0000000188884812ULL, 0x008fc800078efcffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000007200d87306ULL, 0x000fe20000209400ULL, 0x0000000175752812ULL, 0x010fe400078efcffULL,
0x000000888388723eULL, 0x000fca00000010ffULL, 0x0000007200db7306ULL, 0x000e620000205400ULL,
0x00000001acac6812ULL, 0x004fe400078efcffULL, 0x000000ced100720bULL, 0x000fca0003fdd000ULL,
0x0000002400da7306ULL, 0x000ff00000209400ULL, 0x0000002400dd7306ULL, 0x000ea20000205400ULL,
0x000000dbd800720bULL, 0x002fe40003f9d000ULL, 0x0000000189896812ULL, 0x000fc400078efcffULL,
0x000000b8b900720bULL, 0x000fc60003fdd000ULL, 0x0000007100e47306ULL, 0x000ff00000209400ULL,
0x0000007100e77306ULL, 0x000e620000205400ULL, 0x000000ddda00720bULL, 0x004fe40003fbd000ULL,
0x000000017e7e6812ULL, 0x000fc400078efcffULL, 0x000000b61300720bULL, 0x000fe40003fdd000ULL,
0x0000991097b67816ULL, 0x000fe200000000ffULL, 0x0000001f00bb7306ULL, 0x000ff00000009400ULL,
0x0000001f00b07306ULL, 0x000ea20000005400ULL, 0x000000e7e400720bULL, 0x002fc40003f5d000ULL,
0x000000016d6d6812ULL, 0x000fe400078efcffULL, 0x000000a3a400720bULL, 0x000fe20003fdd000ULL,
0x0001000022a37824ULL, 0x000fe400078e00ffULL, 0x0000001f00867306ULL, 0x0002e2000000d400ULL,
0x0000010023a47824ULL, 0x000fe400078e00ffULL, 0x00000018ffa37819ULL, 0x000fc600000114a3ULL,
0x00000018ffa47819ULL, 0x000fe400000114a4ULL, 0x0000002600b77306ULL, 0x000fe20000009400ULL,
0x000100001f1f7824ULL, 0x002fe200078e00ffULL, 0x000000b0bb00720bULL, 0x004fe40003f7d000ULL,
0x000000016b6b6812ULL, 0x000fe400078efcffULL, 0x00000018ff737819ULL, 0x000fe4000001141fULL,
0x0000002600107306ULL, 0x000fee0000005400ULL, 0x0000000186863812ULL, 0x008fe200078efcffULL,
0x0000002600707306ULL, 0x0003f0000000d400ULL, 0x0000007200807306ULL, 0x0004e2000020d400ULL,
0x0001000026267824ULL, 0x002fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000024007f7306ULL, 0x000322000020d400ULL, 0x0000010027727824ULL, 0x004fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000007100797306ULL, 0x000ea2000020d400ULL,
0x0000000180804812ULL, 0x008fe200078efcffULL, 0x000001002c247824ULL, 0x002fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x00000073001f7306ULL, 0x000fe20000209400ULL,
0x000000017f7f5812ULL, 0x010fce00078efcffULL, 0x0000007300d07306ULL, 0x000e620000205400ULL,
0x0000000179792812ULL, 0x004fce00078efcffULL, 0x0000002500de7306ULL, 0x000ff00000209400ULL,
0x0000002500e17306ULL, 0x000ea20000205400ULL, 0x000000d01f00720bULL, 0x002fce0003f1d000ULL,
0x0000007200d57306ULL, 0x000ff00000209400ULL, 0x0000007200d27306ULL, 0x000e620000205400ULL,
0x000000e1de00720bULL, 0x004fce0003f9d000ULL, 0x0000002600d67306ULL, 0x000ff00000209400ULL,
0x0000002600d97306ULL, 0x000ea20000205400ULL, 0x000000d2d500720bULL, 0x002fce0003fbd000ULL,
0x00000025007a7306ULL, 0x0002f0000020d400ULL, 0x0000002d00a87306ULL, 0x000fe20000009400ULL,
0x000001002d257824ULL, 0x002fe200078e00ffULL, 0x000000d9d600720bULL, 0x004fcc0003f5d000ULL,
0x0000002d00a17306ULL, 0x000fe20000005400ULL, 0x000000017a7a4812ULL, 0x008fce00078efcffULL,
0x0000002d00067306ULL, 0x0003f0000000d400ULL, 0x0000002700a27306ULL, 0x000fe20000009400ULL,
0x000100002d2d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff877819ULL, 0x000fe2000001142dULL,
0x000001002e2d7824ULL, 0x000fe200078e00ffULL, 0x0000002700a97306ULL, 0x000e680000005400ULL,
0x00000018ffe67819ULL, 0x000fe2000001142dULL, 0x000001002f2d7824ULL, 0x000fc600078e00ffULL,
0x00000027006a7306ULL, 0x0004e4000000d400ULL, 0x00000018ffe97819ULL, 0x000fcc000001142dULL,
0x0000002e00a77306ULL, 0x000fe20000009400ULL, 0x0001000027277824ULL, 0x004fe200078e00ffULL,
0x000000a9a200720bULL, 0x002fe20003f9d000ULL, 0x0000010022a27824ULL, 0x000fe400078e00ffULL,
0x0001000023a97824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000002e00a07306ULL, 0x000e620000005400ULL, 0x00000018ffa27819ULL, 0x000fe400000114a2ULL,
0x00000018ffa97819ULL, 0x000fc800000114a9ULL, 0x000000016a6a4812ULL, 0x008fe200078efcffULL,
0x0000002e00317306ULL, 0x0004f0000000d400ULL, 0x0000007300827306ULL, 0x000f22000020d400ULL,
0x000100002e2e7824ULL, 0x004fe200078e00ffULL, 0x000000a0a700720bULL, 0x002fc80003fdd000ULL,
0x00000018ffe87819ULL, 0x000fe2000001142eULL, 0x000100002f2e7824ULL, 0x000fe200078e00ffULL,
0x0000007800d47306ULL, 0x000fe80000209400ULL, 0x00000018ff1c7819ULL, 0x000fc6000001142eULL,
0x0000000131316812ULL, 0x008fe200078efcffULL, 0x0000007800d77306ULL, 0x000e620000205400ULL,
0x0000000182820812ULL, 0x010fe400078efcffULL, 0x00000010b700720bULL, 0x000fe40003f1d000ULL,
0x000000777400720bULL, 0x000fe40003fdd000ULL, 0x0000007a6d77723eULL, 0x000fe200000010ffULL,
0x0000007800857306ULL, 0x000eb0000020d400ULL, 0x0000007200737306ULL, 0x000ee2000020d400ULL,
0x000000d7d400720bULL, 0x002fc40003f7d000ULL, 0x0000000170700812ULL, 0x000fe400078efcffULL,
0x000000abaa00720bULL, 0x000fe40003f1d000ULL, 0x0000000134346812ULL, 0x000fe200078efcffULL,
0x0000002600787306ULL, 0x00032c000020d400ULL, 0x0000000185853812ULL, 0x004fc400078efcffULL,
0x0000002700dc7306ULL, 0x000fe20000209400ULL, 0x0000000173735812ULL, 0x008fe400078efcffULL,
0x00000018ff267819ULL, 0x002fe40000011425ULL, 0x00000011b400720bULL, 0x000fe40003f7d000ULL,
0x00a800005810783bULL, 0x000e620000000200ULL, 0x0000002700df7306ULL, 0x000ea20000205400ULL,
0x0000000178782812ULL, 0x010fe400078efcffULL, 0x000000a1a800720bULL, 0x000fc40003f5d000ULL,
0x0000000166660812ULL, 0x000fc600078efcffULL, 0x0000001c002e7306ULL, 0x000fe40000209400ULL,
0x0000000176763812ULL, 0x000fe400078efcffULL, 0x000000ffb600720cULL, 0x000fe40003f65270ULL,
0x0000007f7676723eULL, 0x000fe400000010ffULL, 0x0000001c00ad7306ULL, 0x000fe20000205400ULL,
0x000000dfdc00720bULL, 0x004fe40003fbd000ULL, 0x0000000106062812ULL, 0x000fc400078efcffULL,
0x0000008b8c00720bULL, 0x000fe40003f5d000ULL, 0x00000086898b723eULL, 0x000fe200000010ffULL,
0x0000001c00927306ULL, 0x0005e2000020d400ULL, 0x000000827b89723eULL, 0x000fce00000010ffULL,
0x0000002700717306ULL, 0x000ee2000020d400ULL, 0x00000100211c7824ULL, 0x004fe200078e00ffULL,
0x0000000133332812ULL, 0x000fc800078efcffULL, 0x00000018ffb87819ULL, 0x000fe2000001141cULL,
0x000000911010b231ULL, 0x082fe200003400ffULL, 0x0000002c009f7306ULL, 0x000fe20000009400ULL,
0x000000911212b231ULL, 0x000fe400003400ffULL, 0x000000901111b231ULL, 0x080fe400003400ffULL,
0x000000901313b231ULL, 0x000fc600003400ffULL, 0x0000002c009e7306ULL, 0x000e620000005400ULL,
0x0000000171715812ULL, 0x008fc800078efcffULL, 0x000000716671723eULL, 0x000fc600000010ffULL,
0x0000002400e07306ULL, 0x000ff00000209400ULL, 0x0000002400e37306ULL, 0x000ea20000205400ULL,
0x0000009e9f00720bULL, 0x002fce0003f9d000ULL, 0x0000002c00677306ULL, 0x0002f0000000d400ULL,
0x0000001d00b07306ULL, 0x000fe20000209400ULL, 0x000100002c2c7824ULL, 0x002fe200078e00ffULL,
0x000000e3e000720bULL, 0x004fc80003fbd000ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000001d00bb7306ULL, 0x000e620000205400ULL, 0x0000000167674812ULL, 0x008fce00078efcffULL,
0x0000001d00b97306ULL, 0x0004f0000020d400ULL, 0x0000002400727306ULL, 0x000f22000020d400ULL,
0x00a800002b1c783bULL, 0x004ea20000000200ULL, 0x000000bbb000720bULL, 0x002fcc0003fdd000ULL,
0x0000002600e27306ULL, 0x000fee0000209400ULL, 0x00000001b9b96812ULL, 0x008fe200078efcffULL,
0x0000002600e57306ULL, 0x000e620000205400ULL, 0x0000000172725812ULL, 0x010fe400078efcffULL,
0x000000999a00720bULL, 0x000fc40003fbd000ULL, 0x000000373600720bULL, 0x000fe40003fdd000ULL,
0x000000677272723eULL, 0x000fe200000010ffULL, 0x0000002c00b37306ULL, 0x000ff00000209400ULL,
0x0000002c00b27306ULL, 0x000ee20000205400ULL, 0x000000e5e200720bULL, 0x002fc40003f1d000ULL,
0x0000000132325812ULL, 0x000fe400078efcffULL, 0x000000015a5a6812ULL, 0x000fe400078efcffULL,
0x0000005f5e00720bULL, 0x000fe20003fdd000ULL, 0x000000e9008d7306ULL, 0x000fe20000209400ULL,
0x000000911c1cb231ULL, 0x084fe400003400ffULL, 0x000000911e1eb231ULL, 0x000fe400003400ffULL,
0x000000901d1db231ULL, 0x000fc400003400ffULL, 0x000000901f1fb231ULL, 0x000fe200003400ffULL,
0x000000e9008e7306ULL, 0x000e620000205400ULL, 0x000000b2b300720bULL, 0x008fc60003f9d000ULL,
0x0000000160606812ULL, 0x000fe400078efcffULL, 0x0000008a1c4c723cULL, 0x040fe4000004184cULL,
0x0000002600257306ULL, 0x000eac000020d400ULL, 0x000000881c48723cULL, 0x000fe40000041848ULL,
0x0000002c00277306ULL, 0x000ee2000020d400ULL, 0x0000008e8d00720bULL, 0x002fca0003f5d000ULL,
0x000000761c40723cULL, 0x000fe40000041840ULL, 0x000000e9002d7306ULL, 0x000e62000020d400ULL,
0x0000000125250812ULL, 0x004fce00078efcffULL, 0x0000002000817306ULL, 0x000fe20000009400ULL,
0x0000000127274812ULL, 0x008fc800078efcffULL, 0x000000273232723eULL, 0x000fc600000010ffULL,
0x0000002000847306ULL, 0x000ea20000005400ULL, 0x000000012d2d2812ULL, 0x002fe400078efcffULL,
0x0000006f6e00720bULL, 0x000fca0003f5d000ULL, 0x0000008700ae7306ULL, 0x000ff00000209400ULL,
0x0000008700b17306ULL, 0x000e620000205400ULL, 0x000000848100720bULL, 0x004fe40003f9d000ULL,
0x0000000135352812ULL, 0x000fca00078efcffULL, 0x000000e600957306ULL, 0x000ff00000209400ULL,
0x000000e600967306ULL, 0x000ea20000205400ULL, 0x000000b1ae00720bULL, 0x002fce0003f1d000ULL,
0x0000002000307306ULL, 0x0002f0000000d400ULL, 0x00000021007c7306ULL, 0x000fe20000009400ULL,
0x0001000020207824ULL, 0x002fe200078e00ffULL, 0x000000969500720bULL, 0x004fc80003fbd000ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000021007d7306ULL, 0x000fe20000005400ULL,
0x0000000130304812ULL, 0x008fc800078efcffULL, 0x00000030b930723eULL, 0x000fc600000010ffULL,
0x0000002100287306ULL, 0x0003f0000000d400ULL, 0x0000008700247306ULL, 0x000ea2000020d400ULL,
0x0001000021217824ULL, 0x002fca00078e00ffULL, 0x00000018ff9e7819ULL, 0x000fe40000011421ULL,
0x000000e600267306ULL, 0x000e62000020d400ULL, 0x000000948f21723eULL, 0x000fce00000010ffULL,
0x0000002f00a57306ULL, 0x000fe20000009400ULL, 0x0000000124240812ULL, 0x004fe400078efcffULL,
0x0000007d7c00720bULL, 0x000fe40003f1d000ULL, 0x000000243333723eULL, 0x000fc600000010ffULL,
0x0000002f00a67306ULL, 0x000ea20000005400ULL, 0x0000000126265812ULL, 0x002fc800078efcffULL,
0x000000312626723eULL, 0x000fc600000010ffULL, 0x000000e8002c7306ULL, 0x000fe20000209400ULL,
0x0000000128280812ULL, 0x000fe400078efcffULL, 0x0000005c5b00720bULL, 0x000fca0003f1d000ULL,
0x000000e800877306ULL, 0x000e620000205400ULL, 0x000000a6a500720bULL, 0x004fce0003f7d000ULL,
0x000000b800b57306ULL, 0x000fe20000209400ULL, 0x000000015d5d0812ULL, 0x000fce00078efcffULL,
0x000000b800b47306ULL, 0x000ea20000205400ULL, 0x000000872c00720bULL, 0x002fce0003fbd000ULL,
0x00000020002b7306ULL, 0x000ff00000209400ULL, 0x0000002000587306ULL, 0x000e620000205400ULL,
0x000000b4b500720bULL, 0x004fce0003f5d000ULL, 0x00000020009f7306ULL, 0x0004f0000020d400ULL,
0x0000002200697306ULL, 0x000fe20000009400ULL, 0x0000009d9820723eULL, 0x004fe400000010ffULL,
0x000000582b00720bULL, 0x002fca0003f9d000ULL, 0x00000022006c7306ULL, 0x000fe20000005400ULL,
0x000000201c50723cULL, 0x000fee0000041850ULL, 0x00000022001b7306ULL, 0x0003e2000000d400ULL,
0x0000007e8520723eULL, 0x000fe400000010ffULL, 0x000000758021723eULL, 0x000fc400000010ffULL,
0x000000019f9f4812ULL, 0x008fc600078efcffULL, 0x0000002300657306ULL, 0x000fe20000009400ULL,
0x0000009caf22723eULL, 0x002fe200000010ffULL, 0x000000201c44723cULL, 0x000fe20000041844ULL,
0x0000009f5a5a723eULL, 0x000fca00000010ffULL, 0x0000002300687306ULL, 0x000fe20000005400ULL,
0x000000707920723eULL, 0x000fe200000010ffULL, 0x000000321050723cULL, 0x000fe20000041850ULL,
0x0000006a7321723eULL, 0x000fe400000010ffULL, 0x000000786b70723eULL, 0x000fe400000010ffULL,
0x000000062573723eULL, 0x000fe200000010ffULL, 0x0000002300147306ULL, 0x0003e4000000d400ULL,
0x000000201c3c723cULL, 0x040fec000004183cULL, 0x0000002f002a7306ULL, 0x000ea2000000d400ULL,
0x0000009bac23723eULL, 0x002fe200000010ffULL, 0x000000701c38723cULL, 0x040fec0000041838ULL,
0x000000e8002f7306ULL, 0x000e64000020d400ULL, 0x000000221c54723cULL, 0x000fec0000041854ULL,
0x000000b800977306ULL, 0x000ee2000020d400ULL, 0x000000012a2a3812ULL, 0x004fc400078efcffULL,
0x000000ad2e00720bULL, 0x000fe40003f7d000ULL, 0x0000002a2d27723eULL, 0x000fc600000010ffULL,
0x0000009e00a07306ULL, 0x000fe20000209400ULL, 0x000000012f2f5812ULL, 0x002fe400078efcffULL,
0x0000006c6900720bULL, 0x000fe20003fbd000ULL, 0x00000026104c723cULL, 0x000fe2000004184cULL,
0x0000002f3434723eULL, 0x000fc600000010ffULL, 0x0000009e00917306ULL, 0x000e620000205400ULL,
0x0000000197972812ULL, 0x008fe400078efcffULL, 0x0000000192923812ULL, 0x000fe200078efcffULL,
0x000000721054723cULL, 0x000fe20000041854ULL, 0x000000686500720bULL, 0x000fe40003f7d000ULL,
0x000000923535723eULL, 0x000fe200000010ffULL, 0x000000a200227306ULL, 0x000fe20000209400ULL,
0x000000011b1b5812ULL, 0x000fe400078efcffULL, 0x000000289731723eULL, 0x000fc600000010ffULL,
0x000000341048723cULL, 0x000fe40000041848ULL, 0x000000a200237306ULL, 0x000ea20000205400ULL,
0x00000091a000720bULL, 0x002fe40003f5d000ULL, 0x0000000114143812ULL, 0x000fc600078efcffULL,
0x000000301044723cULL, 0x000fe40000041844ULL, 0x0000009e00907306ULL, 0x000e70000020d400ULL,
0x000000a2007c7306ULL, 0x000ee2000020d400ULL, 0x000000232200720bULL, 0x004fce0003f9d000ULL,
0x000000a4002c7306ULL, 0x000fe20000209400ULL, 0x0000000190902812ULL, 0x002fe400078efcffULL,
0x000000646100720bULL, 0x000fe40003f5d000ULL, 0x000000905d5b723eULL, 0x000fc600000010ffULL,
0x000000a4006d7306ULL, 0x000e620000205400ULL, 0x000000017c7c4812ULL, 0x008fc600078efcffULL,
0x0000005a1040723cULL, 0x000fe20000041840ULL, 0x0000001b7c7c723eULL, 0x000fc600000010ffULL,
0x000000a300207306ULL, 0x000fe20000209400ULL, 0x0000000163632812ULL, 0x000fce00078efcffULL,
0x000000a3001d7306ULL, 0x000ea20000205400ULL, 0x0000006d2c00720bULL, 0x002fce0003f1d000ULL,
0x000000a900067306ULL, 0x000ff00000209400ULL, 0x000000a9001f7306ULL, 0x000e620000205400ULL,
0x0000001d2000720bULL, 0x004fce0003f9d000ULL, 0x000000a4007d7306ULL, 0x000eb0000020d400ULL,
0x000000a300a37306ULL, 0x000ee2000020d400ULL, 0x0000001f0600720bULL, 0x002fce0003fbd000ULL,
0x000000a9001c7306ULL, 0x000e62000020d400ULL, 0x000000017d7d0812ULL, 0x004fc800078efcffULL,
0x000000147d7d723eULL, 0x000fe400000010ffULL, 0x00000001a3a34812ULL, 0x008fc800078efcffULL,
0x000000a36060723eULL, 0x000fe200000010ffULL, 0x0000007c103c723cULL, 0x000fe2000004183cULL,
0x000000011c1c5812ULL, 0x002fc800078efcffULL, 0x0000001c6361723eULL, 0x000fce00000010ffULL,
0x000000601038723cULL, 0x000fe20000041838ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200015107f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a00059ff7f8cULL, 0x0007e2000c80043fULL,
0x0000000119067824ULL, 0x000fe200078e0262ULL, 0x000000011a147812ULL, 0x000fe200078ec0ffULL,
0x000000ffff317224ULL, 0x004fe400078e0011ULL, 0x0000030004047a10ULL, 0x00cfc80007ffe0ffULL,
0x000000070400720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff45e000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x004ea40000002500ULL,
0x0000000407007c0cULL, 0x004fda000bf03070ULL, 0x0000039000000947ULL, 0x000fea0003800000ULL,
0x018000000f027810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e000fULL,
0x0000c9a000087802ULL, 0x000fe40000000f00ULL, 0x0000a7f000007944ULL, 0x02afea0003c00000ULL,
0x000000ffff047224ULL, 0x008fe200078e0002ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000f00047308ULL, 0x000ea40000001000ULL, 0xbf80000004027423ULL, 0x004fc8000000000fULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000304047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000057919ULL, 0x000f280000000000ULL, 0x0000000000087919ULL, 0x000ee20000000000ULL,
0x00000002ff077819ULL, 0x010fe40000011605ULL, 0x0000000808057811ULL, 0x008fe200078ff0ffULL,
0x0000000403067220ULL, 0x004fca0000410000ULL, 0x00001f0706047589ULL, 0x000ea800000e0000ULL,
0x00001f0506057589ULL, 0x000ee200000e0000ULL, 0x0000005404547220ULL, 0x044fe40000410000ULL,
0x0000005504557220ULL, 0x040fe40000410000ULL, 0x0000005004507220ULL, 0x040fe40000410000ULL,
0x0000005104517220ULL, 0x000fc40000410000ULL, 0x0000004c044c7220ULL, 0x040fe40000410000ULL,
0x0000004d044d7220ULL, 0x040fe40000410000ULL, 0x0000004804487220ULL, 0x040fe40000410000ULL,
0x0000004904497220ULL, 0x040fe40000410000ULL, 0x0000004404447220ULL, 0x040fe40000410000ULL,
0x0000004504457220ULL, 0x000fc40000410000ULL, 0x0000004004407220ULL, 0x040fe40000410000ULL,
0x0000004104417220ULL, 0x040fe40000410000ULL, 0x0000003c043c7220ULL, 0x040fe40000410000ULL,
0x0000003d043d7220ULL, 0x040fe40000410000ULL, 0x0000003804387220ULL, 0x040fe40000410000ULL,
0x0000003904397220ULL, 0x000fc40000410000ULL, 0x0000005605567220ULL, 0x048fe40000410000ULL,
0x0000005705577220ULL, 0x040fe40000410000ULL, 0x0000005205527220ULL, 0x040fe40000410000ULL,
0x0000005305537220ULL, 0x040fe40000410000ULL, 0x0000004e054e7220ULL, 0x040fe40000410000ULL,
0x0000004f054f7220ULL, 0x000fc40000410000ULL, 0x0000004a054a7220ULL, 0x040fe40000410000ULL,
0x0000004b054b7220ULL, 0x040fe40000410000ULL, 0x0000004605467220ULL, 0x040fe40000410000ULL,
0x0000004705477220ULL, 0x040fe40000410000ULL, 0x0000004205427220ULL, 0x040fe40000410000ULL,
0x0000004305437220ULL, 0x000fc40000410000ULL, 0x0000003e053e7220ULL, 0x040fe40000410000ULL,
0x0000003f053f7220ULL, 0x040fe40000410000ULL, 0x0000003a053a7220ULL, 0x040fe40000410000ULL,
0x0000003b053b7220ULL, 0x000fe40000410000ULL, 0x0000000000027919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000202037812ULL, 0x004fc400078ec0ffULL,
0x00000002ff147819ULL, 0x000fe40000011602ULL, 0x0000000203067811ULL, 0x040fe400078ff8ffULL,
0x0000000403077811ULL, 0x040fe400078ff8ffULL, 0x00000008021a7811ULL, 0x000fe400078ff0ffULL,
0x00000001ff057819ULL, 0x000fe40000011603ULL, 0x0000000603117811ULL, 0x000fc400078ff8ffULL,
0x0000000706047812ULL, 0x100fe400078e7814ULL, 0x0000000707097812ULL, 0x060fe400078e7814ULL,
0x0000000707077812ULL, 0x000fe200078e781aULL, 0x00000008140c7824ULL, 0x000fe200078e0204ULL,
0x0000000705037812ULL, 0x100fe200078e7814ULL, 0x000010000a047824ULL, 0x000fe200078e00ffULL,
0x0000000711127812ULL, 0x002fe200078e7814ULL, 0x000000081a187824ULL, 0x008fe200078e0207ULL,
0x0000000705057812ULL, 0x100fe200078e781aULL, 0x0000000802077824ULL, 0x000fe200078e00ffULL,
0x0000000706067812ULL, 0x100fe200078e781aULL, 0x0000000814087824ULL, 0x040fe200078e0203ULL,
0x0000000711117812ULL, 0x000fe200078e781aULL, 0x0000000814107824ULL, 0x040fe200078e0209ULL,
0x0000000807077812ULL, 0x000fe200078ec0ffULL, 0x0000000814127824ULL, 0x000fc400078e0212ULL,
0x000000081a147824ULL, 0x040fe200078e0205ULL, 0x000000545505723eULL, 0x000fe200000010ffULL,
0x000000081a167824ULL, 0x040fe200078e0206ULL, 0x000000505106723eULL, 0x000fe200000010ffULL,
0x000008000b037824ULL, 0x000fe400078e0204ULL, 0x000000081a1a7824ULL, 0x000fe200078e0211ULL,
0x00005410051c7816ULL, 0x140fe20000000006ULL, 0x0000001008087824ULL, 0x100fe200078e0203ULL,
0x00007632051d7816ULL, 0x000fe20000000006ULL, 0x000000100c0c7824ULL, 0x100fe200078e0203ULL,
0x000000444505723eULL, 0x000fe200000010ffULL, 0x0000001010107824ULL, 0x100fe200078e0203ULL,
0x000000404106723eULL, 0x000fe200000010ffULL, 0x0000001014147824ULL, 0x000fc400078e0203ULL,
0x0000001016167824ULL, 0x100fe400078e0203ULL, 0x0000001012127824ULL, 0x100fe400078e0203ULL,
0x0000001018187824ULL, 0x100fe400078e0203ULL, 0x000000101a1a7824ULL, 0x000fe400078e0203ULL,
0x0000000108097824ULL, 0x000fe200078e0207ULL, 0x000000484908723eULL, 0x000fe200000010ffULL,
0x00000001070c7824ULL, 0x000fc400078e020cULL, 0x0000000107107824ULL, 0x040fe200078e0210ULL,
0x0000001c09007388ULL, 0x0003e20000000a00ULL, 0x0000000107147824ULL, 0x040fe400078e0214ULL,
0x0000000107167824ULL, 0x040fe400078e0216ULL, 0x0000000107127824ULL, 0x040fe400078e0212ULL,
0x0000000107187824ULL, 0x040fe400078e0218ULL, 0x00000001071a7824ULL, 0x000fe200078e021aULL,
0x0000004c4d07723eULL, 0x000fe200000010ffULL, 0x000000200b097824ULL, 0x002fc600078e0202ULL,
0x00005410071c7816ULL, 0x140fe40000000008ULL, 0x00007632071d7816ULL, 0x000fe40000000008ULL,
0x0000003c3d07723eULL, 0x000fe400000010ffULL, 0x000000383908723eULL, 0x000fe200000010ffULL,
0x0000001c0c007388ULL, 0x0003e60000000a00ULL, 0x0000763207117816ULL, 0x000fc40000000008ULL,
0x00005410051c7816ULL, 0x002fe20000000006ULL, 0x00000010090c7824ULL, 0x000fe200078e0204ULL,
0x00007632051d7816ULL, 0x000fe40000000006ULL, 0x000000565705723eULL, 0x000fe400000010ffULL,
0x000000525306723eULL, 0x000fe200000010ffULL, 0x0000001c10007388ULL, 0x0003e40000000a00ULL,
0x0000541007107816ULL, 0x002fe40000000008ULL, 0x0000004e4f07723eULL, 0x000fc400000010ffULL,
0x0000004a4b08723eULL, 0x000fe200000010ffULL, 0x0000001012007388ULL, 0x0003e40000000a00ULL,
0x0000541005107816ULL, 0x142fe40000000006ULL, 0x0000763205117816ULL, 0x000fe40000000006ULL,
0x000000464705723eULL, 0x000fe400000010ffULL, 0x000000424306723eULL, 0x000fe200000010ffULL,
0x0000001014007388ULL, 0x0003e60000000a00ULL, 0x0000541005207816ULL, 0x000fc40000000006ULL,
0x0000763205217816ULL, 0x000fe40000000006ULL, 0x000000ff00067306ULL, 0x000fe20000205400ULL,
0x0000541007107816ULL, 0x142fe40000000008ULL, 0x0000763207117816ULL, 0x000fca0000000008ULL,
0x000000ff00057306ULL, 0x000fe2000020d400ULL, 0x0000003e3f07723eULL, 0x000fe400000010ffULL,
0x0000003a3b08723eULL, 0x000fe200000010ffULL, 0x0000001016007388ULL, 0x000fe60000000a00ULL,
0x0000763207197816ULL, 0x140fe20000000008ULL, 0x0000002018007388ULL, 0x0003e40000000a00ULL,
0x0000541007187816ULL, 0x002fc40000000008ULL, 0x000000ff00077306ULL, 0x000e660000209400ULL,
0x000000181a007388ULL, 0x0005e80000000a00ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000300ff1a7624ULL, 0x004fe200078e00ffULL, 0x000000060700720bULL, 0x002fda0003f1d000ULL,
0x0000000105050812ULL, 0x000fe200078efcffULL, 0x000000000c107984ULL, 0x000e620000000c00ULL,
0x000000011a00780cULL, 0x000fe40003f05270ULL, 0x000000050508723eULL, 0x000fe200000010ffULL,
0x000400000c1c7984ULL, 0x000ea80000000c00ULL, 0x000800000c147984ULL, 0x000ee80000000c00ULL,
0x000c00000c207984ULL, 0x000f220000000c00ULL, 0x3f803f8008137831ULL, 0x002fc40000200013ULL,
0x3f803f8008127831ULL, 0x040fe40000200012ULL, 0x3f803f8008117831ULL, 0x040fe40000200011ULL,
0x3f803f8008107831ULL, 0x040fe40000200010ULL, 0x3f803f80081f7831ULL, 0x044fe4000020001fULL,
0x3f803f80081e7831ULL, 0x040fe4000020001eULL, 0x3f803f80081d7831ULL, 0x000fc4000020001dULL,
0x3f803f80081c7831ULL, 0x000fe4000020001cULL, 0x3f803f8013137831ULL, 0x008fe40000200017ULL,
0x3f803f8012127831ULL, 0x000fe40000200016ULL, 0x3f803f8011117831ULL, 0x000fe40000200015ULL,
0x3f803f8010107831ULL, 0x000fe40000200014ULL, 0x3f803f801f1f7831ULL, 0x010fc40000200023ULL,
0x3f803f801e1e7831ULL, 0x000fe20000200022ULL, 0x000000100c007388ULL, 0x0003e20000000c00ULL,
0x3f803f801d1d7831ULL, 0x000fe40000200021ULL, 0x3f803f801c1c7831ULL, 0x000fca0000200020ULL,
0x0004001c0c007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f5000008947ULL, 0x000fea0003800000ULL, 0x0000000000167919ULL, 0x000ea20000002700ULL,
0x000058001a067a24ULL, 0x000fe200078e02ffULL, 0x000000010bff7812ULL, 0x000fe2000780f800ULL,
0x00000800ff117424ULL, 0x002fe200078e00ffULL, 0x0000000000077919ULL, 0x000ea20000002600ULL,
0x0000660006127a24ULL, 0x000fe200078e02ffULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000004000a087824ULL, 0x000fe200078e00ffULL, 0x000000000c1c7984ULL, 0x0002e20000000c00ULL,
0x000000ff0200720cULL, 0x000fe20000725670ULL, 0x0000580016167a24ULL, 0x004fe200078e0207ULL,
0x000007ff12077811ULL, 0x000fc600078e40ffULL, 0x0000030016067a24ULL, 0x000fca00078e02ffULL,
0x0000000406187c10ULL, 0x000fc8000fffe0ffULL, 0x0000001807107211ULL, 0x000fca00078fa8ffULL,
0x00006c0010107625ULL, 0x000fca00078e0011ULL, 0x0000000810147210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff157224ULL, 0x000fc800010e0611ULL, 0x0000001009147825ULL, 0x000fe200078e0014ULL,
0x01ffffff12097812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010020c7824ULL, 0x00afe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011602ULL,
0x00000080ff137424ULL, 0x000fe400078e00ffULL, 0x0000000118127824ULL, 0x000fe200078e0209ULL,
0x000000700c177812ULL, 0x000fe400078ec0ffULL, 0x0000000c100c7812ULL, 0x000fe200078ec0ffULL,
0x00006c0018107625ULL, 0x000fc800078e0013ULL, 0x00006c0012127625ULL, 0x000fe200078e0013ULL,
0x000000100c107210ULL, 0x000fc80007a1e017ULL, 0x000000120c127210ULL, 0x000fe40007c7e017ULL,
0x00000011ff117210ULL, 0x000fe400007e44ffULL, 0x00000013ff137210ULL, 0x000fc60001fe84ffULL,
0x0000000e10007986ULL, 0x0003e8000c101906ULL, 0x0000000f12007986ULL, 0x0003e4000c101906ULL,
0x0000000000007941ULL, 0x00afea0003800000ULL, 0x0000001c14007986ULL, 0x0003e2000c101d06ULL,
0x0000011000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0f7424ULL, 0x000fe200078e00ffULL,
0xffffffff1a117810ULL, 0x000fc60007ffe0ffULL, 0x00006a00160e7625ULL, 0x000fe200078e000fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x000000110e0e79a8ULL, 0x000ea400099ee1c6ULL, 0x000000110e00720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0c7807ULL, 0x000fca0000000000ULL,
0x0000000cff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff0c7984ULL, 0x004ea40000000000ULL,
0x000000ff0c00720cULL, 0x004fda0003f05270ULL, 0x00002ba000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff0e7819ULL, 0x000fe20000011602ULL, 0x00000010020c7824ULL, 0x000fe200078e00ffULL,
0x0000000106107810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff1d7424ULL, 0x002fe200078e00ffULL,
0x0000000c0e127812ULL, 0x000fe400078ec0ffULL, 0x000000700c1f7812ULL, 0x000fe200078ec0ffULL,
0x00006c00060e7625ULL, 0x000fc800078e001dULL, 0x00006c0010107625ULL, 0x000fe200078e001dULL,
0x0000000e120e7210ULL, 0x000fc8000791e01fULL, 0x0000001012107210ULL, 0x000fe40007b5e01fULL,
0x0000000fff0f7210ULL, 0x000fe400007e24ffULL, 0x00000011ff117210ULL, 0x000fc600017e64ffULL,
0x000000060e0c7981ULL, 0x000368000c1e1900ULL, 0x0000000610137981ULL, 0x000362000c1e1900ULL,
0x000000021a00780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002060e7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000e0e7625ULL, 0x000fca00078e001dULL,
0x0000000e120e7210ULL, 0x000fc8000791e01fULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000060e157981ULL, 0x000362000c1e1900ULL, 0x000000041a00780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003060e7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000e0e7625ULL, 0x000fca00078e001dULL, 0x0000000e120e7210ULL, 0x000fc8000791e01fULL,
0x0000000fff0f7210ULL, 0x000fca00007e24ffULL, 0x000000060e177981ULL, 0x000362000c1e1900ULL,
0x000000041a00780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004060e7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000e0e7625ULL, 0x000fca00078e001dULL,
0x0000000e120e7210ULL, 0x000fc8000791e01fULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000060e197981ULL, 0x000362000c1e1900ULL, 0x000000061a00780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005060e7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000e0e7625ULL, 0x000fca00078e001dULL, 0x0000000e120e7210ULL, 0x000fc8000791e01fULL,
0x0000000fff0f7210ULL, 0x000fca00007e24ffULL, 0x000000060e1b7981ULL, 0x000362000c1e1900ULL,
0x000000061a00780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081a00780cULL, 0x002fe40003f06070ULL, 0x00000006060e7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000e0e7625ULL, 0x000fca00078e001dULL, 0x0000000e120e7210ULL, 0x000fe40007a3e01fULL,
0x0000000706100810ULL, 0x000fe40007ffe0ffULL, 0x0000000fff0f7210ULL, 0x000fc60000fe44ffULL,
0x00006c0010100625ULL, 0x000fe400078e001dULL, 0x000000060e1d7981ULL, 0x000366000c1e1900ULL,
0x0000001012100210ULL, 0x000fc80007c7e01fULL, 0x00000011ff110210ULL, 0x000fca0001fe84ffULL,
0x00000006101f0981ULL, 0x000368000c1e1900ULL, 0x000000071a0e7810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff107819ULL, 0x000fc8000001160eULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff117224ULL, 0x000fe400078e00ffULL,
0x000000ffff217224ULL, 0x020fe400078e000cULL, 0x0000000811127824ULL, 0x040fe200078e00ffULL,
0x0000000111117810ULL, 0x000fc80007ffe0ffULL, 0x0000030012007a0cULL, 0x000fe40003f26070ULL,
0x000000101100720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x00000008120f7810ULL, 0x040fe40007ffe0ffULL, 0x00000001120e7810ULL, 0x000fe40007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x000000210c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060e7824ULL, 0x000fe200078e020fULL, 0x00000001ff167819ULL, 0x000fe20000011602ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001002147824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006c000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007014217812ULL, 0x000fc800078ec0ffULL, 0x0000000e160e7210ULL, 0x000fc80007b3e021ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e217981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x00000009120f7810ULL, 0x042fe40007ffe0ffULL,
0x00000002120e7810ULL, 0x000fe40007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x000003000e007a0cULL, 0x000fe40003f46070ULL, 0x000000130c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060e7824ULL, 0x000fe200078e020fULL,
0x00000001ff147819ULL, 0x000fe20000011602ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001002137824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007013137812ULL, 0x000fc800078ec0ffULL,
0x0000000e140e7210ULL, 0x000fc80007b3e013ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000060e137981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a120f7810ULL, 0x042fe40007ffe0ffULL, 0x00000003120e7810ULL, 0x000fe40007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x000000150c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060e7824ULL, 0x000fe200078e020fULL, 0x00000001ff167819ULL, 0x000fe20000011602ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001002147824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006c000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007014157812ULL, 0x000fc800078ec0ffULL, 0x0000000e160e7210ULL, 0x000fc80007b3e015ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e157981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b120f7810ULL, 0x042fe40007ffe0ffULL,
0x00000004120e7810ULL, 0x000fe40007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x000003000e007a0cULL, 0x000fe40003f46070ULL, 0x000000170c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060e7824ULL, 0x000fe200078e020fULL,
0x00000001ff167819ULL, 0x000fe20000011602ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001002147824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007014177812ULL, 0x000fc800078ec0ffULL,
0x0000000e160e7210ULL, 0x000fc80007b3e017ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000060e177981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c120f7810ULL, 0x042fe40007ffe0ffULL, 0x00000005120e7810ULL, 0x000fe40007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x000000190c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060e7824ULL, 0x000fe200078e020fULL, 0x00000001ff167819ULL, 0x000fe20000011602ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001002147824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006c000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007014197812ULL, 0x000fc800078ec0ffULL, 0x0000000e160e7210ULL, 0x000fc80007b3e019ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e197981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d120f7810ULL, 0x042fe40007ffe0ffULL,
0x00000006120e7810ULL, 0x000fe40007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x000003000e007a0cULL, 0x000fe40003f46070ULL, 0x0000001b0c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060e7824ULL, 0x000fe200078e020fULL,
0x00000001ff167819ULL, 0x000fe20000011602ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001002147824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fc600078e000fULL, 0x00000070141b7812ULL, 0x000fc800078ec0ffULL,
0x0000000e160e7210ULL, 0x000fc80007b3e01bULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000060e1b7981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e120f7810ULL, 0x042fe40007ffe0ffULL, 0x00000007120e7810ULL, 0x000fe40007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x000003000e007a0cULL, 0x000fe40003f46070ULL,
0x0000001d0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060e7824ULL, 0x000fe200078e020fULL, 0x00000001ff167819ULL, 0x000fe20000011602ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001002147824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006c000e0e7625ULL, 0x000fc600078e000fULL,
0x00000070141d7812ULL, 0x000fc800078ec0ffULL, 0x0000000e160e7210ULL, 0x000fc80007b3e01dULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e1d7981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f120f7810ULL, 0x002fe40007ffe0ffULL,
0x0000001f0c0c7209ULL, 0x000fe40007810000ULL, 0x000003000f007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060e7824ULL, 0x000fe200078e020fULL,
0x00000001ff147819ULL, 0x000fe20000011602ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001002127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fc600078e000fULL, 0x00000070121f7812ULL, 0x000fc800078ec0ffULL,
0x0000000e140e7210ULL, 0x000fc80007a3e01fULL, 0x0000000fff0f7210ULL, 0x000fca0000fe44ffULL,
0x000000060e1f7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000027919ULL, 0x000ea40000000000ULL, 0x00000010020e7824ULL, 0x006fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011602ULL, 0x000000700e0e7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0f0f7812ULL, 0x000fca00078ec0ffULL, 0x000000010f0f7824ULL, 0x000fca00078e020eULL,
0x0000000c0f007388ULL, 0x0203e40000000800ULL, 0x000000070200780cULL, 0x040fe20003f04070ULL,
0x000000010b147824ULL, 0x002fe200078e0206ULL, 0x00000001ff0f7819ULL, 0x000fe20000011602ULL,
0x00000010020c7824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000800ff137424ULL, 0x000fe200078e00ffULL, 0x00000014070e7211ULL, 0x000fe200078fa8ffULL,
0x000000010d347824ULL, 0x000fe200078e0204ULL, 0x000000700c0c7812ULL, 0x000fe200078ec0ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000c0f117812ULL, 0x000fe200078ec0ffULL,
0x00006c000e0e7625ULL, 0x000fe200078e0013ULL, 0x00000002ff107819ULL, 0x000fe20000011600ULL,
0x000010d000007945ULL, 0x000fe20003800000ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000020000007824ULL, 0x000fe200078e00ffULL, 0x000000080e0e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001112b7824ULL, 0x000fe200078e020cULL, 0x00000001100c7812ULL, 0x000fe200078ec0ffULL,
0x000000020b118824ULL, 0x140fe200078e020aULL, 0x00000800000d7812ULL, 0x000fe200078ec0ffULL,
0x000000020b138824ULL, 0x000fe200078e020aULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000211198824ULL, 0x100fe200078e020cULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000002131b8824ULL, 0x000fe200078e020cULL, 0x0000002002137810ULL, 0x000fe20007ffe0ffULL,
0x00000001090c8824ULL, 0x000fe200078e0214ULL, 0x000000002b2b7984ULL, 0x000e620000000800ULL,
0x00000080ff158424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000080ff178424ULL, 0x000fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000134117824ULL, 0x000fc400078e020dULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x000003000b007a0cULL, 0x000fe20003f26070ULL, 0x00006c000c0c8625ULL, 0x000fc800078e0015ULL,
0x00006c0014148625ULL, 0x000fc800078e0017ULL, 0x0000000819198824ULL, 0x100fe400078e0202ULL,
0x0000001002177824ULL, 0x000fe400078e0211ULL, 0x000000081b1b8824ULL, 0x000fe200078e0202ULL,
0x0000458019198811ULL, 0x000fe200078e20ffULL, 0x0000001013107825ULL, 0x000fc600078e000eULL,
0x000041801b218811ULL, 0x000fe200078e20ffULL, 0x00000010020e7825ULL, 0x000fe200078e000eULL,
0x00000000001a7805ULL, 0x000fc6000001ff00ULL, 0x0000001002128825ULL, 0x040fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000e177faeULL, 0x0005e2000b901c46ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x0000001002148825ULL, 0x000fe200078e0014ULL,
0x0038000010177faeULL, 0x0007e6000b901c46ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x0000000012198faeULL, 0x0009e2000b901c46ULL, 0x000000ffff2a7224ULL, 0x000fc400078e00ffULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x0000000014218faeULL, 0x000be2000b901c46ULL,
0x00000000000e7805ULL, 0x004fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000107805ULL, 0x008fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x010fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x020fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000d6000001947ULL, 0x000fea0003800000ULL, 0x000000ffff007224ULL, 0x002fe400078e00ffULL,
0x000000ffff367224ULL, 0x000fca00078e000bULL, 0x0000000236377810ULL, 0x000fe20007ffe0ffULL,
0x0000029000017945ULL, 0x000fe60003800000ULL, 0x0000030037007a0cULL, 0x000fda0003f06070ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x000000070200780cULL, 0x000fe20003f24070ULL,
0x0000000106327824ULL, 0x100fe200078e0237ULL, 0x00000001ff2c7819ULL, 0x000fe20000011637ULL,
0x00000800ff387424ULL, 0x000fe200078e00ffULL, 0x00000020023d7810ULL, 0x000fe20007ffe0ffULL,
0x00000400372e7824ULL, 0x000fe200078e00ffULL, 0x00000032072d7211ULL, 0x000fe400078fa8ffULL,
0x000000012c307812ULL, 0x000fc600078ec0ffULL, 0x00006c002d2c7625ULL, 0x000fc800078e0038ULL,
0x000000020b319824ULL, 0x000fe200078e020aULL, 0x000000082c2c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001092f9824ULL, 0x000fe400078e0232ULL, 0x00000002313f9824ULL, 0x000fe200078e0230ULL,
0x000008002e317812ULL, 0x000fe200078ec0ffULL, 0x00000080ff389424ULL, 0x000fe400078e00ffULL,
0x000000020b3b9824ULL, 0x000fe400078e020aULL, 0x00006c002f2e9625ULL, 0x000fc800078e0038ULL,
0x000000023b3b9824ULL, 0x000fe400078e0230ULL, 0x00000080ff339424ULL, 0x000fe400078e00ffULL,
0x0000000134317824ULL, 0x000fe400078e0231ULL, 0x000000ffff2d7224ULL, 0x000fe400000e062dULL,
0x00006c0032329625ULL, 0x000fc800078e0033ULL, 0x0000001002397824ULL, 0x040fe400078e0231ULL,
0x000000083b3b9824ULL, 0x000fe400078e0202ULL, 0x0000001002309825ULL, 0x000fc600078e002eULL,
0x000045803b3b9811ULL, 0x000fe200078e20ffULL, 0x000000083f3f9824ULL, 0x000fe400078e0202ULL,
0x000000103d2e7825ULL, 0x000fc600078e002cULL, 0x000041803f3d9811ULL, 0x000fe200078e20ffULL,
0x00000010022c7825ULL, 0x000fc800078e002cULL, 0x0000001002329825ULL, 0x000fe200078e0032ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800002c397faeULL, 0x0003e8000b901c46ULL,
0x003800002e397faeULL, 0x0003e8000b901c46ULL, 0x00000000303b9faeULL, 0x0003e8000b901c46ULL,
0x00000000323d9faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff2f7224ULL, 0x002fe200078e0036ULL,
0x00000001ff2e7819ULL, 0x000fe20000011602ULL, 0x000000020b317824ULL, 0x000fe200078e020aULL,
0x00000002ff397819ULL, 0x000fe20000011602ULL, 0x000000402f2c7824ULL, 0x000fe200078e00ffULL,
0x0000000c2e2e7812ULL, 0x000fe200078ec0ffULL, 0x00000010022d7824ULL, 0x000fe200078e00ffULL,
0x0000000739407812ULL, 0x040fe200078ec0ffULL, 0x0000000839337824ULL, 0x000fe200078e00ffULL,
0x000000802c2c7812ULL, 0x000fc400078ec0ffULL, 0x000000702d2d7812ULL, 0x000fe400078ec0ffULL,
0x00000039ff3e7212ULL, 0x000fe200078e33ffULL, 0x00000100312c7824ULL, 0x000fe200078e002cULL,
0x00000008393b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000839317824ULL, 0x000fe200078e00ffULL,
0xfffffff8333e7812ULL, 0x000fe400078ee23eULL, 0x0000002c2e2e7210ULL, 0x000fe20007ffe02dULL,
0x00000008392d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8312c7812ULL, 0x000fe200078ee240ULL,
0x000000083b317824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180002e3c7984ULL, 0x000e620000000800ULL, 0x000000012d307812ULL, 0x100fe200078ef640ULL,
0x000000083b427824ULL, 0x000fe200078e00ffULL, 0x000000022d327812ULL, 0x140fe200078ef640ULL,
0x004580002e4e7984ULL, 0x0002a20000000800ULL, 0x000000032d367812ULL, 0x140fe400078ef640ULL,
0x000000042d387812ULL, 0x140fe400078ef640ULL, 0x000000052d3a7812ULL, 0x000fe400078ef640ULL,
0x0000003bff4c7212ULL, 0x000fc800078e33ffULL, 0xfffffff8314c7812ULL, 0x000fe400078ee24cULL,
0x000000073b317812ULL, 0x000fe200078ec0ffULL, 0x0000003c2b2e7221ULL, 0x002fe20000010100ULL,
0x000000062d3c7812ULL, 0x000fe200078ef640ULL, 0x000004002f2d7824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b2e337820ULL, 0x000fe40000410000ULL, 0x00000004022e7824ULL, 0x000fe200078e00ffULL,
0x000008002d2d7812ULL, 0x000fe200078ec0ffULL, 0x000000083b407824ULL, 0x000fc400078e00ffULL,
0x0000003300337308ULL, 0x000ea20000000800ULL, 0x00000180342d7810ULL, 0x000fe40007ffe02dULL,
0x0000000c2e2f7812ULL, 0x000fe400078ec0ffULL, 0xfffffff8422e7812ULL, 0x000fe200078ee231ULL,
0x000000102c2c7824ULL, 0x000fe200078e022dULL, 0x0000000140427812ULL, 0x000fe200078ef631ULL,
0x000000103e3e7824ULL, 0x000fe200078e022dULL, 0x0000000240447812ULL, 0x000fe200078ef631ULL,
0x000000012c2c7824ULL, 0x000fe200078e022fULL, 0x0000000340467812ULL, 0x140fe200078ef631ULL,
0x000000012f3e7824ULL, 0x040fe200078e023eULL, 0x0000000440487812ULL, 0x000fe200078ef631ULL,
0x0000001030307824ULL, 0x000fe200078e022dULL, 0x00000005404a7812ULL, 0x000fe200078ef631ULL,
0x0000001032327824ULL, 0x000fe200078e022dULL, 0x0000000640407812ULL, 0x000fe200078ef631ULL,
0x000000003e3e7984ULL, 0x000fe20000000800ULL, 0x000000012f307824ULL, 0x000fc400078e0230ULL,
0x000000012f327824ULL, 0x000fe200078e0232ULL, 0x000000002c317984ULL, 0x000e620000000800ULL,
0x0000001036367824ULL, 0x100fe400078e022dULL, 0x0000004e334e7220ULL, 0x004fe20000410000ULL,
0x0000000030307984ULL, 0x000fe20000000800ULL, 0x000000012f367824ULL, 0x000fe400078e0236ULL,
0x0000001038387824ULL, 0x100fe200078e022dULL, 0x0000000032327984ULL, 0x000fe20000000800ULL,
0x000000103a3a7824ULL, 0x000fc400078e022dULL, 0x000000012f387824ULL, 0x040fe200078e0238ULL,
0x00001f394e2c7589ULL, 0x000ea200000e0000ULL, 0x000000012f3a7824ULL, 0x000fe400078e023aULL,
0x000000103c3c7824ULL, 0x100fe200078e022dULL, 0x0000000036367984ULL, 0x000ee20000000800ULL,
0x000000102e2e7824ULL, 0x100fe400078e022dULL, 0x0000001042427824ULL, 0x100fe200078e022dULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x0000001044447824ULL, 0x000fc400078e022dULL,
0x0000001046467824ULL, 0x100fe200078e022dULL, 0x000000003a3a7984ULL, 0x000f620000000800ULL,
0x0000001048487824ULL, 0x100fe400078e022dULL, 0x000000104a4a7824ULL, 0x100fe400078e022dULL,
0x0000001040407824ULL, 0x100fe400078e022dULL, 0x000000104c4c7824ULL, 0x000fe400078e022dULL,
0x000000012f3c7824ULL, 0x040fe200078e023cULL, 0x00001f3b4e2d7589ULL, 0x000fe200000e0000ULL,
0x000000012f2e7824ULL, 0x000fc400078e022eULL, 0x000000012f427824ULL, 0x040fe400078e0242ULL,
0x000000012f447824ULL, 0x040fe200078e0244ULL, 0x000000003c3c7984ULL, 0x000f220000000800ULL,
0x000000012f467824ULL, 0x040fe400078e0246ULL, 0x000000012f487824ULL, 0x040fe200078e0248ULL,
0x000000002e2e7984ULL, 0x000f620000000800ULL, 0x000000012f4a7824ULL, 0x040fe400078e024aULL,
0x000000012f407824ULL, 0x040fe200078e0240ULL, 0x0000000042427984ULL, 0x000f620000000800ULL,
0x000000012f4c7824ULL, 0x000fe200078e024cULL, 0x00005410ff2f7816ULL, 0x002fe20000000031ULL,
0x000000354e357221ULL, 0x000fe20000010000ULL, 0x0000000044447984ULL, 0x000e620000000800ULL,
0x00007610ff317816ULL, 0x000fc40000000031ULL, 0x0000002c2f2a7223ULL, 0x084fe2000001002aULL,
0x00005410ff2f7816ULL, 0x100fe2000000003eULL, 0x0000000046467984ULL, 0x000ea20000000800ULL,
0x00007610ff3e7816ULL, 0x000fe2000000003eULL, 0x0000002c31297223ULL, 0x080fe40000010029ULL,
0x0000002c2f1c7223ULL, 0x080fe2000001001cULL, 0x00005410ff2f7816ULL, 0x100fe20000000030ULL,
0x0000000048487984ULL, 0x000e620000000800ULL, 0x00007610ff307816ULL, 0x000fe20000000030ULL,
0x0000002c3e1b7223ULL, 0x000fc4000001001bULL, 0x0000002c2f287223ULL, 0x080fe20000010028ULL,
0x00005410ff2f7816ULL, 0x100fe20000000032ULL, 0x000000004a4a7984ULL, 0x000e620000000800ULL,
0x00007610ff327816ULL, 0x000fe20000000032ULL, 0x0000002c30277223ULL, 0x080fe40000010027ULL,
0x0000002c2f267223ULL, 0x080fe20000010026ULL, 0x00005410ff2f7816ULL, 0x108fe20000000036ULL,
0x0000000040407984ULL, 0x000ee20000000800ULL, 0x00007610ff367816ULL, 0x000fe20000000036ULL,
0x0000002c32257223ULL, 0x000fc40000010025ULL, 0x0000002c2f247223ULL, 0x080fe20000010024ULL,
0x00005410ff2f7816ULL, 0x110fe20000000038ULL, 0x0000002c36237223ULL, 0x080fe20000010023ULL,
0x00007610ff387816ULL, 0x000fe20000000038ULL, 0x000000004c4c7984ULL, 0x000f220000000800ULL,
0x000000ffff367224ULL, 0x000fe400078e0037ULL, 0x0000002c2f227223ULL, 0x080fe20000010022ULL,
0x00005410ff2f7816ULL, 0x120fe2000000003aULL, 0x0000002c38217223ULL, 0x000fe20000010021ULL,
0x00007610ff3a7816ULL, 0x000fc4000000003aULL, 0x0000030036007a0cULL, 0x000fe20003f06070ULL,
0x0000002c2f207223ULL, 0x080fe20000010020ULL, 0x00005410ff2f7816ULL, 0x100fe2000000003cULL,
0x0000002c3a1f7223ULL, 0x000fe2000001001fULL, 0x00007610ff3c7816ULL, 0x000fc6000000003cULL,
0x0000002c2f1e7223ULL, 0x080fe4000001001eULL, 0x0000002c3c1d7223ULL, 0x000fe2000001001dULL,
0x00005410ff2c7816ULL, 0x100fe4000000002eULL, 0x00007610ff2e7816ULL, 0x000fc6000000002eULL,
0x0000002d2c1a7223ULL, 0x080fe2000001001aULL, 0x00005410ff2c7816ULL, 0x100fe20000000042ULL,
0x0000002d2e197223ULL, 0x000fe20000010019ULL, 0x00007610ff427816ULL, 0x000fc60000000042ULL,
0x0000002d2c187223ULL, 0x080fe20000010018ULL, 0x00005410ff2c7816ULL, 0x102fe20000000044ULL,
0x0000002d42177223ULL, 0x000fe20000010017ULL, 0x00007610ff447816ULL, 0x000fc60000000044ULL,
0x0000002d2c167223ULL, 0x080fe20000010016ULL, 0x00005410ff2c7816ULL, 0x104fe20000000046ULL,
0x0000002d44157223ULL, 0x000fe20000010015ULL, 0x00007610ff467816ULL, 0x000fc60000000046ULL,
0x0000002d2c147223ULL, 0x080fe20000010014ULL, 0x00005410ff2c7816ULL, 0x100fe20000000048ULL,
0x0000002d46137223ULL, 0x000fe20000010013ULL, 0x00007610ff487816ULL, 0x000fc60000000048ULL,
0x0000002d2c127223ULL, 0x080fe20000010012ULL, 0x00005410ff2c7816ULL, 0x100fe2000000004aULL,
0x0000002d48117223ULL, 0x000fe20000010011ULL, 0x00007610ff4a7816ULL, 0x000fc6000000004aULL,
0x0000002d2c107223ULL, 0x080fe20000010010ULL, 0x00005410ff2c7816ULL, 0x108fe20000000040ULL,
0x0000002d4a0f7223ULL, 0x000fe2000001000fULL, 0x00007610ff407816ULL, 0x000fc60000000040ULL,
0x0000002d2c0e7223ULL, 0x080fe2000001000eULL, 0x00005410ff2c7816ULL, 0x110fe2000000004cULL,
0x0000002d400d7223ULL, 0x000fe2000001000dULL, 0x00007610ff4c7816ULL, 0x000fc6000000004cULL,
0x0000002d2c0c7223ULL, 0x080fe4000001000cULL, 0x0000002d4c007223ULL, 0x000fe20000010000ULL,
0xfffff2c000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x000000ff0a00720cULL, 0x000fe20003f05270ULL,
0x0000001002067824ULL, 0x002fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c02077812ULL, 0x000fca00078ec0ffULL,
0x0000000107087824ULL, 0x000fe200078e0206ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e640000000000ULL, 0x0000001002067824ULL, 0x002fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011602ULL, 0x0000007006027812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fc600078ec0ffULL, 0x000000800b027824ULL, 0x000fc800078e0202ULL,
0x0000000107027824ULL, 0x000fca00078e0202ULL, 0x0049803502007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800008027984ULL, 0x002e680000000800ULL, 0x004a000008077984ULL, 0x000ea20000000800ULL,
0x00000002ff027221ULL, 0x002fc80000010000ULL, 0x0000000702027221ULL, 0x004fca0000010000ULL,
0x0180000002067810ULL, 0x000fc80007ffe0ffULL, 0x7f80000006067812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0600780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e0002ULL,
0x0000f8a000087802ULL, 0x000fe40000000f00ULL, 0x000078f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x008fe200078e0002ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000200077308ULL, 0x000e640000001000ULL, 0xbf80000002067423ULL, 0x002fc80000000007ULL,
0x800000ff06067221ULL, 0x000fc80000010100ULL, 0x0000000607067223ULL, 0x000fe40000000007ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e680000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff2b7819ULL, 0x002fe40000011602ULL,
0x00000008022d7811ULL, 0x000fc600078ff0ffULL, 0x00001f2b06077589ULL, 0x000e6200000e0000ULL,
0x0000002dff2c7212ULL, 0x000fe200078e33ffULL, 0x000000082d2f7824ULL, 0x000fe400078e00ffULL,
0x00001f2d06097589ULL, 0x0004e600000e0000ULL, 0xfffffff82f2c7812ULL, 0x000fca00078ee22cULL,
0x000000102c2c7824ULL, 0x000fe200078e0203ULL, 0x0000002bff067212ULL, 0x004fe200078e33ffULL,
0x0000002a072a7220ULL, 0x042fe40000410000ULL, 0x0000002907297220ULL, 0x040fe40000410000ULL,
0x0000002807287220ULL, 0x040fe40000410000ULL, 0x0000002707277220ULL, 0x000fe20000410000ULL,
0x0000002a2929723eULL, 0x000fe200000010ffULL, 0x0000002607267220ULL, 0x000fc40000410000ULL,
0x0000002507257220ULL, 0x000fe20000410000ULL, 0x000000282727723eULL, 0x000fe200000010ffULL,
0x0000002407247220ULL, 0x040fe40000410000ULL, 0x0000002307237220ULL, 0x000fe20000410000ULL,
0x000000262525723eULL, 0x000fe200000010ffULL, 0x0000002207227220ULL, 0x040fe40000410000ULL,
0x0000002107217220ULL, 0x000fe20000410000ULL, 0x000000242323723eULL, 0x000fe200000010ffULL,
0x0000002007207220ULL, 0x000fc40000410000ULL, 0x0000001f071f7220ULL, 0x000fe20000410000ULL,
0x000000222121723eULL, 0x000fe200000010ffULL, 0x0000001e071e7220ULL, 0x000fe20000410000ULL,
0x000000072d227812ULL, 0x000fe200078ec0ffULL, 0x0000001d071d7220ULL, 0x000fe20000410000ULL,
0x000000201f1f723eULL, 0x000fe200000010ffULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000000522207812ULL, 0x040fe200078e3cffULL, 0x0000001b07077220ULL, 0x000fe20000410000ULL,
0x0000001e1d1d723eULL, 0x000fe200000010ffULL, 0x000000082b1b7824ULL, 0x000fe200078e00ffULL,
0x00000004221e7812ULL, 0x040fe200078e3cffULL, 0x0000001a091a7220ULL, 0x008fe20000410000ULL,
0x0000001c0707723eULL, 0x000fe200000010ffULL, 0x0000001909197220ULL, 0x000fe20000410000ULL,
0xfffffff81b2e7812ULL, 0x000fe200078ee206ULL, 0x0000001809187220ULL, 0x000fe20000410000ULL,
0x000000072b067812ULL, 0x000fe200078ec0ffULL, 0x0000001709177220ULL, 0x040fe20000410000ULL,
0x00000003221b7812ULL, 0x000fe200078e3cffULL, 0x0000001609167220ULL, 0x040fe20000410000ULL,
0x0000000106087812ULL, 0x000fe200078e3cffULL, 0x0000001509157220ULL, 0x000fe20000410000ULL,
0x0000001a1919723eULL, 0x000fe200000010ffULL, 0x0000001409147220ULL, 0x040fe20000410000ULL,
0x00000002221a7812ULL, 0x000fe200078e3cffULL, 0x0000001309137220ULL, 0x000fe20000410000ULL,
0x000000161515723eULL, 0x000fe200000010ffULL, 0x0000001209127220ULL, 0x000fe20000410000ULL,
0x000000181717723eULL, 0x000fe200000010ffULL, 0x0000001109117220ULL, 0x000fe20000410000ULL,
0x000000141313723eULL, 0x000fe200000010ffULL, 0x0000001009107220ULL, 0x040fe20000410000ULL,
0x0000000606147812ULL, 0x040fe200078e3cffULL, 0x0000000f090f7220ULL, 0x000fe20000410000ULL,
0x000000121111723eULL, 0x000fe200000010ffULL, 0x0000000e090e7220ULL, 0x040fe20000410000ULL,
0x0000000506127812ULL, 0x040fe200078e3cffULL, 0x0000000d090d7220ULL, 0x000fe20000410000ULL,
0x000000100f0f723eULL, 0x000fe200000010ffULL, 0x0000000c090c7220ULL, 0x040fe20000410000ULL,
0x0000000406107812ULL, 0x040fe200078e3cffULL, 0x0000000009097220ULL, 0x000fe20000410000ULL,
0x0000000e0d0d723eULL, 0x000fe200000010ffULL, 0x000000082b007824ULL, 0x000fe200078e00ffULL,
0x00000003060e7812ULL, 0x000fe200078e3cffULL, 0x0000000402247824ULL, 0x000fe200078e00ffULL,
0x0000000c0909723eULL, 0x000fe200000010ffULL, 0x000000082d167824ULL, 0x000fe200078e00ffULL,
0x00000002060c7812ULL, 0x000fe200078e3cffULL, 0x000000082b067824ULL, 0x000fe200078e0208ULL,
0xfffffff800007812ULL, 0x000fe200078ee22bULL, 0x000000082d1c7824ULL, 0x000fe200078e021bULL,
0x0000000c241b7812ULL, 0x000fe200078ec0ffULL, 0x000000082b087824ULL, 0x040fe200078e020cULL,
0xfffffff816167812ULL, 0x000fe200078ee22dULL, 0x000000082b0c7824ULL, 0x000fc400078e020eULL,
0x000000082b0e7824ULL, 0x040fe400078e0210ULL, 0x000000082b107824ULL, 0x040fe400078e0212ULL,
0x000000082b127824ULL, 0x000fe200078e0214ULL, 0x0000000122147812ULL, 0x000fe200078e3cffULL,
0x0000001000007824ULL, 0x100fe200078e0203ULL, 0x0000000622227812ULL, 0x000fe200078e3cffULL,
0x0000001006067824ULL, 0x100fe400078e0203ULL, 0x0000001008087824ULL, 0x000fc400078e0203ULL,
0x000000100c0c7824ULL, 0x100fe400078e0203ULL, 0x000000011b007824ULL, 0x000fe400078e0200ULL,
0x000000100e0e7824ULL, 0x100fe400078e0203ULL, 0x000000082d187824ULL, 0x000fe200078e0214ULL,
0x0000002900007388ULL, 0x000fe20000000800ULL, 0x0000001010107824ULL, 0x000fe400078e0203ULL,
0x000000011b067824ULL, 0x000fc400078e0206ULL, 0x000000082d1a7824ULL, 0x000fe400078e021aULL,
0x0000001012127824ULL, 0x100fe200078e0203ULL, 0x0000002706007388ULL, 0x000fe20000000800ULL,
0x000000011b087824ULL, 0x040fe400078e0208ULL, 0x000000102e147824ULL, 0x000fe400078e0203ULL,
0x000000011b0c7824ULL, 0x000fe200078e020cULL, 0x0000002508007388ULL, 0x000fe20000000800ULL,
0x000000082d1e7824ULL, 0x000fc400078e021eULL, 0x0000001016167824ULL, 0x100fe200078e0203ULL,
0x000000230c007388ULL, 0x000fe20000000800ULL, 0x000000011b0e7824ULL, 0x000fe400078e020eULL,
0x000000082d207824ULL, 0x000fe400078e0220ULL, 0x0000001018187824ULL, 0x000fe200078e0203ULL,
0x000000210e007388ULL, 0x000fe20000000800ULL, 0x000000011b107824ULL, 0x000fe400078e0210ULL,
0x000000082d227824ULL, 0x000fc400078e0222ULL, 0x000000101a1a7824ULL, 0x100fe200078e0203ULL,
0x0000001f10007388ULL, 0x000fe20000000800ULL, 0x000000011b127824ULL, 0x040fe400078e0212ULL,
0x000000101c1c7824ULL, 0x100fe400078e0203ULL, 0x000000011b147824ULL, 0x040fe200078e0214ULL,
0x0000001d12007388ULL, 0x0003e20000000800ULL, 0x000000101e1e7824ULL, 0x100fe400078e0203ULL,
0x000000011b167824ULL, 0x000fe200078e0216ULL, 0x0000000714007388ULL, 0x000fe20000000800ULL,
0x0000001020207824ULL, 0x000fc400078e0203ULL, 0x000000011b187824ULL, 0x000fe200078e0218ULL,
0x0000001916007388ULL, 0x000fe20000000800ULL, 0x0000001022227824ULL, 0x000fe200078e0203ULL,
0x000000050512723eULL, 0x002fe200000010ffULL, 0x000000011b1a7824ULL, 0x040fe200078e021aULL,
0x0000001718007388ULL, 0x000fe20000000800ULL, 0x000000011b1c7824ULL, 0x040fe400078e021cULL,
0x000000011b1e7824ULL, 0x040fe200078e021eULL, 0x000000151a007388ULL, 0x000fe20000000800ULL,
0x000000011b207824ULL, 0x000fc400078e0220ULL, 0x000000011b227824ULL, 0x040fe200078e0222ULL,
0x000000131c007388ULL, 0x000fe20000000800ULL, 0x000000011b2c7824ULL, 0x000fe400078e022cULL,
0x000000200b037824ULL, 0x000fe200078e0202ULL, 0x000000111e007388ULL, 0x000fe60000000800ULL,
0x0000001003037824ULL, 0x000fe200078e0204ULL, 0x0000000f20007388ULL, 0x000fe80000000800ULL,
0x0000000d22007388ULL, 0x000fe80000000800ULL, 0x000000092c007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000003247984ULL, 0x000e680000000c00ULL,
0x0004000003307984ULL, 0x000ea80000000c00ULL, 0x0008000003287984ULL, 0x000ee80000000c00ULL,
0x000c000003147984ULL, 0x000f220000000c00ULL, 0x3f803f8012277831ULL, 0x002fc40000200027ULL,
0x3f803f8012267831ULL, 0x040fe40000200026ULL, 0x3f803f8012257831ULL, 0x040fe40000200025ULL,
0x3f803f8012247831ULL, 0x040fe40000200024ULL, 0x3f803f8012337831ULL, 0x044fe40000200033ULL,
0x3f803f8012327831ULL, 0x040fe40000200032ULL, 0x3f803f8012317831ULL, 0x000fc40000200031ULL,
0x3f803f8012307831ULL, 0x000fe40000200030ULL, 0x3f803f8027277831ULL, 0x008fe4000020002bULL,
0x3f803f8026267831ULL, 0x000fe4000020002aULL, 0x3f803f8025257831ULL, 0x000fe40000200029ULL,
0x3f803f8024247831ULL, 0x000fe40000200028ULL, 0x3f803f8033337831ULL, 0x010fc40000200017ULL,
0x3f803f8032327831ULL, 0x000fe20000200016ULL, 0x0000002403007388ULL, 0x0003e20000000c00ULL,
0x3f803f8031317831ULL, 0x000fe40000200015ULL, 0x3f803f8030307831ULL, 0x000fca0000200014ULL,
0x0004003003007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000020020b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000067919ULL, 0x000ea20000002600ULL,
0x00000003ff097819ULL, 0x100fe20000011602ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x00000003ff057819ULL, 0x100fe2000001160bULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000709037812ULL, 0x102fe200078e4802ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000705007812ULL, 0x000fe400078e480bULL, 0x0ffffff803037812ULL, 0x000fc400078ef802ULL,
0x0ffffff800077812ULL, 0x000fc600078ef80bULL, 0x0000001003037824ULL, 0x100fe400078e0204ULL,
0x0000001007077824ULL, 0x000fc600078e0204ULL, 0x00000000030c7984ULL, 0x0003280000000c00ULL,
0x0000000007107984ULL, 0x000b220000000c00ULL, 0x0000000806007824ULL, 0x044fe400078e00ffULL,
0x0000000806067824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x008fe4000f8e023fULL,
0xfffffff800007812ULL, 0x000fe200078ee209ULL, 0x000000080a097824ULL, 0x000fe200078e00ffULL,
0xfffffff806057812ULL, 0x000fe200078ee205ULL, 0x000000080a0a7824ULL, 0x000fe200078e00ffULL,
0x0000000400087c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000405007c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff037224ULL, 0x002fe200000e06ffULL, 0x00005a0008047a11ULL, 0x000fe200078040ffULL,
0x000000ffff077224ULL, 0x020fe200008e06ffULL, 0x00005a0000067a11ULL, 0x000fe400078240ffULL,
0x00005b0008057a11ULL, 0x000fe400000f4403ULL, 0xfffffff809037812ULL, 0x000fe400078ee202ULL,
0x00005b0000077a11ULL, 0x000fe400008f4407ULL, 0xfffffff80a097812ULL, 0x000fe200078ee20bULL,
0x0000001003027825ULL, 0x000fc800078e0004ULL, 0x0000001009047825ULL, 0x000fe200078e0006ULL,
0x0000000c02007986ULL, 0x010fe8000c101d06ULL, 0x0000001004007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff097819ULL, 0x000fe20000011600ULL,
0xffffffffff387424ULL, 0x000fc800078e00ffULL, 0x0000000204067824ULL, 0x000fca00078e0209ULL,
0x000000050600720cULL, 0x000fda0003f06070ULL, 0x0000000210098824ULL, 0x000fc800078e00ffULL,
0x00006400090a8a24ULL, 0x000fc800078e0206ULL, 0x000060000a0a8625ULL, 0x000fe200078e0013ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff0c7624ULL, 0x000fe200078e00ffULL,
0x000000060a388981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff0d7624ULL, 0x000fc600078e00ffULL,
0x00f60000ff087f8cULL, 0x000e68000c80043fULL, 0x000000060c3c7981ULL, 0x000762000c1e9900ULL,
0x00000001040e7810ULL, 0x000fe20007ffe0ffULL, 0x0000004000397824ULL, 0x000fe400078e00ffULL,
0x000000803a3a7824ULL, 0x000fe200078e00ffULL, 0x000000070e00720cULL, 0x000fe20003f06070ULL,
0x00000100040f7824ULL, 0x000fc400078e0239ULL, 0x000000803b3b7824ULL, 0x000fc600078e00ffULL,
0x000000403a1c7812ULL, 0x000fe200078ef80fULL, 0x0000003b38257224ULL, 0x004fcc00078e02ffULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000002ff217819ULL, 0x00afe40000011602ULL,
0x0000000f030a7217ULL, 0x000fe40007800000ULL, 0x0000000821197810ULL, 0x040fe20007ffe0ffULL,
0x00000001210b7824ULL, 0x140fe200078e021cULL, 0x0000001821277810ULL, 0x040fe20007ffe0ffULL,
0x000000010a127824ULL, 0x000fe200078e0a0fULL, 0x00000010211b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001190a7824ULL, 0x000fe200078e021cULL, 0x0000000b250b7210ULL, 0x000fc40007f1e0ffULL,
0x00000003ff157819ULL, 0x000fe40000011602ULL, 0x0000003011237812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005e000b147a11ULL, 0x040fe400078038ffULL,
0x0000100000117811ULL, 0x000fe400078e68ffULL, 0x00005f000b177a11ULL, 0x000fe200000f3c0cULL,
0x00000001270c7824ULL, 0x100fe200078e021cULL, 0x0000000a25187210ULL, 0x000fe20007f1e0ffULL,
0x000000011b0b7824ULL, 0x000fe200078e021cULL, 0x00000028211d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000c250c7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x00005e00180d7a11ULL, 0x040fe400078038ffULL, 0x0000000b250f7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e06ffULL, 0x00005f0018187a11ULL, 0x000fe400000f3c13ULL,
0x00005e000c167a11ULL, 0x000fe200078438ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000000315137812ULL, 0x000fc400078e4802ULL, 0x00005e000f0e7a11ULL, 0x000fe400078238ffULL,
0x00005f000c1a7a11ULL, 0x000fe200010f3c0bULL, 0x00000004190c7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc13027812ULL, 0x000fe400078ef802ULL, 0x000000122100720cULL, 0x000fe40003f06070ULL,
0x00005f000f0f7a11ULL, 0x000fe200008f3c0aULL, 0x0000001002157824ULL, 0x000fe200078e0211ULL,
0x00000014230a7210ULL, 0x000fe20007f7e0ffULL, 0x000000041b147824ULL, 0x040fe200078e00ffULL,
0x000000121b00720cULL, 0x000fc40003f46070ULL, 0xfffffffc0c027812ULL, 0x000fe200078ee213ULL,
0x000000ffff0b7224ULL, 0x000fe200018e0617ULL, 0x00000020211b7810ULL, 0x000fe40007ffe0ffULL,
0x000000121900720cULL, 0x080fe20003f26070ULL, 0x0000001002177824ULL, 0x000fe200078e0211ULL,
0x000000230d0c7210ULL, 0x080fe20007f7e0ffULL, 0x000000011c027824ULL, 0x000fe200078e021bULL,
0xfffffffc14147812ULL, 0x000fe200078ee213ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a157faeULL, 0x0003e2000c101c46ULL, 0x000000230e0e7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e0618ULL, 0x00000030211f7810ULL, 0x040fe20007ffe0ffULL,
0x0000001014197824ULL, 0x000fe200078e0211ULL, 0x0000003821217810ULL, 0x000fe20007ffe0ffULL,
0x0000000427147824ULL, 0x000fe200078e00ffULL, 0x000000121b00720cULL, 0x080fe20003f66070ULL,
0x000000ffff0f7224ULL, 0x000fe200020e060fULL, 0x000000122700720cULL, 0x080fe20003f86070ULL,
0x000000000c177faeULL, 0x0005e2000c901c46ULL, 0x000000121f00720cULL, 0x000fc40003f26070ULL,
0x00000002250b7210ULL, 0x002fe20007f1e0ffULL, 0x000000000e197faeULL, 0x0003e2000d101c46ULL,
0x00000023160a7210ULL, 0x000fe40007fbe0ffULL, 0x00005e000b187a11ULL, 0x000fe400078c38ffULL,
0xfffffffc14027812ULL, 0x000fe400078ee213ULL, 0x000000121d00720cULL, 0x080fe20003f46070ULL,
0x000000ffff0c7224ULL, 0x004fe200000e06ffULL, 0x000000122100720cULL, 0x000fe20003f06070ULL,
0x00000010020d7824ULL, 0x000fc400078e0211ULL, 0x000000011c027824ULL, 0x040fe200078e021dULL,
0x00005f000b127a11ULL, 0x000fe200030f3c0cULL, 0x000000ffff0b7224ULL, 0x000fe400028e061aULL,
0x000000011c0c7824ULL, 0x040fe200078e021fULL, 0x0000000225167210ULL, 0x000fe20007fbe0ffULL,
0x000000011c0e7824ULL, 0x002fe200078e0221ULL, 0x000000000a0d7faeULL, 0x0003e2000e101c46ULL,
0x000000041b027824ULL, 0x000fe200078e00ffULL, 0x0000000c25147210ULL, 0x000fe20007f9e0ffULL,
0x000000041d0c7824ULL, 0x000fe200078e00ffULL, 0x0000000e250f7210ULL, 0x000fe20007fde0ffULL,
0x000000041f0e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc02027812ULL, 0x100fe200078ee213ULL,
0x00000004211a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0c0c7812ULL, 0x000fc400078ee213ULL,
0xfffffffc0e0e7812ULL, 0x000fe200078ee213ULL, 0x0000001002157824ULL, 0x000fe200078e0211ULL,
0xfffffffc1a0a7812ULL, 0x002fe200078ee213ULL, 0x000000ffff0b7224ULL, 0x000fe200028e06ffULL,
0x00005e00160d7a11ULL, 0x000fe200078a38ffULL, 0x000000100c177824ULL, 0x100fe400078e0211ULL,
0x000000100e197824ULL, 0x000fe200078e0211ULL, 0x00005f0016167a11ULL, 0x000fe200028f3c0bULL,
0x000000100a117824ULL, 0x000fe200078e0211ULL, 0x00000023180a7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff137224ULL, 0x000fe200020e06ffULL, 0x00005e00140e7a11ULL, 0x000fe200078838ffULL,
0x000000ffff027224ULL, 0x000fc400030e06ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e0612ULL,
0x000000230d0c7210ULL, 0x080fe40007fbe0ffULL, 0x00005e000f127a11ULL, 0x040fe400078c38ffULL,
0x00005f0014137a11ULL, 0x000fe200020f3c13ULL, 0x000000ffff0d7224ULL, 0x000fe200028e0616ULL,
0x000000230e0e7210ULL, 0x080fe20007f9e0ffULL, 0x000000000a157faeULL, 0x0003e2000d901c46ULL,
0x00005f000f027a11ULL, 0x000fe400030f3c02ULL, 0x0000002312127210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200020e0613ULL, 0x000000000c177faeULL, 0x0003e6000d101c46ULL,
0x000000ffff137224ULL, 0x000fe200028e0602ULL, 0x000000000e197faeULL, 0x0003e8000c901c46ULL,
0x0000000012117faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000001c020a7211ULL, 0x04afe400078ff0ffULL, 0x00000018020d7811ULL, 0x000fc400078ff0ffULL,
0x0000000a250a7210ULL, 0x000fe40007f1e0ffULL, 0x00000008021d7811ULL, 0x000fe200078ff0ffULL,
0x000000011c0e7824ULL, 0x000fe200078e020dULL, 0x00000020020f7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x00005e000a247a11ULL, 0x000fe400078038ffULL,
0x0000002802137811ULL, 0x000fe200078ff0ffULL, 0x000000011c127824ULL, 0x000fe200078e020fULL,
0x00005f000a267a11ULL, 0x000fe200000f3c0bULL, 0x000000011d0a7824ULL, 0x000fe200078e021cULL,
0x00000010020b7811ULL, 0x000fe200078ff0ffULL, 0x000000011c147824ULL, 0x000fe200078e0213ULL,
0x0000003002157811ULL, 0x040fe200078ff0ffULL, 0x000000040f1a7824ULL, 0x000fe200078e00ffULL,
0x0000003802177811ULL, 0x000fe200078ff0ffULL, 0x000000011c0c7824ULL, 0x040fe200078e020bULL,
0x00000003ff1b7819ULL, 0x100fe20000011602ULL, 0x000000011c167824ULL, 0x040fe200078e0215ULL,
0x0000000e251e7210ULL, 0x000fe20007f1e0ffULL, 0x000000011c187824ULL, 0x000fe200078e0217ULL,
0x000000031b1b7812ULL, 0x100fe200078e4802ULL, 0x000000040d0e7824ULL, 0x000fe200078e00ffULL,
0x0000000a25227210ULL, 0x000fe20007fde0ffULL, 0x00000004131c7824ULL, 0x000fe200078e00ffULL,
0x0000000c25197210ULL, 0x000fe20007fbe0ffULL, 0x000000041d0a7824ULL, 0x000fe200078e00ffULL,
0x0000100000297811ULL, 0x000fe200078e68ffULL, 0x000000040b0c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0e0b7812ULL, 0x100fe200078ee21bULL, 0x0000000415287824ULL, 0x000fe200078e00ffULL,
0x0000001225127210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200030e06ffULL,
0x0ffffffc1b157812ULL, 0x000fe200078ef802ULL, 0x00000004172a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1c0d7812ULL, 0x000fe200078ee21bULL, 0x000000100b217824ULL, 0x100fe200078e0229ULL,
0x00005e0022207a11ULL, 0x000fe200078c38ffULL, 0x00000010152b7824ULL, 0x000fe200078e0229ULL,
0xfffffffc0a027812ULL, 0x000fe200078ee21bULL, 0x000000ffff0b7224ULL, 0x000fe200008e06ffULL,
0x0000001425147210ULL, 0x000fc40007f5e0ffULL, 0x0000001625167210ULL, 0x040fe20007f7e0ffULL,
0x00000010021d7824ULL, 0x100fe200078e0229ULL, 0x0000001825187210ULL, 0x000fe20007f9e0ffULL,
0x000000100d257824ULL, 0x000fe200078e0229ULL, 0xfffffffc280e7812ULL, 0x100fe200078ee21bULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0xfffffffc0c0a7812ULL, 0x000fe200078ee21bULL,
0x000000ffff027224ULL, 0x000fe200028e06ffULL, 0x00005f0022227a11ULL, 0x000fe200030f3c13ULL,
0x000000100e277824ULL, 0x100fe200078e0229ULL, 0x00005e0012157a11ULL, 0x000fe200078238ffULL,
0x000000100a1f7824ULL, 0x000fe200078e0229ULL, 0xfffffffc1a0c7812ULL, 0x000fc400078ee21bULL,
0x00005e001e137a11ULL, 0x000fe400078038ffULL, 0xfffffffc2a0f7812ULL, 0x000fe200078ee21bULL,
0x000000100c237824ULL, 0x100fe200078e0229ULL, 0x0000003011287812ULL, 0x000fe200078ec0ffULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x00005e00190e7a11ULL, 0x000fe200078a38ffULL,
0x000000100f297824ULL, 0x000fe200078e0229ULL, 0x00005f00121c7a11ULL, 0x000fe200008f3c0bULL,
0x000000ffff0b7224ULL, 0x000fe200020e06ffULL, 0x00005f001e1e7a11ULL, 0x000fe200000f3c0dULL,
0x000000ffff1b7224ULL, 0x000fe200010e06ffULL, 0x00005e00181a7a11ULL, 0x000fc400078638ffULL,
0x00000024280a7210ULL, 0x000fe40007f1e0ffULL, 0x00005f00190f7a11ULL, 0x000fe400028f3c02ULL,
0x00005e0014177a11ULL, 0x000fe400078238ffULL, 0x00005e0016197a11ULL, 0x000fe400078438ffULL,
0x00005f0018027a11ULL, 0x000fe200018f3c0bULL, 0x000000ffff0b7224ULL, 0x000fe200000e0626ULL,
0x00005f00141b7a11ULL, 0x000fc400008f3c1bULL, 0x00000020280c7210ULL, 0x000fe40007f1e0ffULL,
0x00005f0016117a11ULL, 0x000fe200010f3c11ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a2b7faeULL, 0x0003e2000b901c46ULL, 0x0000000e280e7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e0622ULL, 0x0000001328127210ULL, 0x040fe40007f5e0ffULL,
0x0000001528147210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x0000001728167210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff137224ULL, 0x000fe200010e061eULL,
0x0000001928187210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff157224ULL, 0x000fe200018e061cULL,
0x0000001a281a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff177224ULL, 0x000fe200020e061bULL,
0x000000000c1d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff197224ULL, 0x000fc400028e0611ULL,
0x000000ffff1b7224ULL, 0x000fe200000e0602ULL, 0x000000000e1f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012217faeULL, 0x0003e8000b901c46ULL, 0x0000000014237faeULL, 0x0003e8000b901c46ULL,
0x0000000016257faeULL, 0x0003e8000b901c46ULL, 0x0000000018277faeULL, 0x0003e8000b901c46ULL,
0x000000001a297faeULL, 0x0003e4000b901c46ULL, 0x00f60400ff0b7984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x800000000bff7812ULL, 0x002fc60007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x00000002000a7305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x0000000a0000735dULL, 0x004fe20003800000ULL, 0x00f60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000097919ULL, 0x000e640000000000ULL, 0x0000002000027824ULL, 0x002fc800078e0209ULL,
0x00000010020a7824ULL, 0x000fe200078e00ffULL, 0x00000003ff087819ULL, 0x000fc80000011602ULL,
0x1ffffffe08097812ULL, 0x000fe400078ec0ffULL, 0x000000f00a0a7812ULL, 0x000fe400078ec0ffULL,
0x00000001090b7812ULL, 0x040fe400078efcffULL, 0x0000000709097812ULL, 0x100fe400078e7802ULL,
0x000000070b0b7812ULL, 0x000fc600078e7802ULL, 0x0000000109097824ULL, 0x000fe400078e020aULL,
0x000000010a0b7824ULL, 0x000fc600078e020bULL, 0x0000000009147984ULL, 0x000e68000000cc00ULL,
0x000000000b0c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff187224ULL, 0x002fe400078e0014ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff157224ULL, 0x000fc400078e0017ULL, 0x000000ffff1a7224ULL, 0x004fe400078e000cULL,
0x000000ffff1b7224ULL, 0x000fe400078e000eULL, 0x000000ffff167224ULL, 0x000fe400078e000dULL,
0x000000ffff177224ULL, 0x000fe200078e000fULL, 0x0000001809007388ULL, 0x0003e8000000cc00ULL,
0x000000140b007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff087f8cULL, 0x002fe8000c80043fULL, 0x00f60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff027424ULL, 0x000fc800078e00ffULL, 0x00000002000a7305ULL, 0x0002a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x0000000a0000735dULL, 0x004fe20003800000ULL,
0x00f60400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000070400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x3db504f33c3c7820ULL, 0x020fe20000410000ULL, 0x0000f688003e7811ULL, 0x000fe200078e18ffULL,
0x00006400103d7a24ULL, 0x000fe200078e02ffULL, 0xffffffff073f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff417224ULL, 0x000fe200078e00ffULL, 0x0000f60800407811ULL, 0x000fe400078e28ffULL,
0x0000010004427824ULL, 0x000fe200078e0239ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000420300720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x03cfea0003800000ULL,
0x000000ffff437224ULL, 0x000fe200078e0041ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fc4000001ff00ULL,
0x0000000144297810ULL, 0x000fe20007ffe0ffULL, 0x00000d9000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e0044ULL, 0x0000000143417812ULL, 0x000fe200078e0cffULL,
0x0000003b38477224ULL, 0x020fe200078e02ffULL, 0x00000001ff2b7819ULL, 0x100fe20000011629ULL,
0x000000ffff447224ULL, 0x000fe200078e0029ULL, 0x000000022900780cULL, 0x000fc40003f06070ULL,
0x00000001295b7812ULL, 0x000fe200078ec0ffULL, 0x000003002b2a7a24ULL, 0x000fc800078e0204ULL,
0x000001002a367824ULL, 0x040fe200078e0239ULL, 0x000000012a2c7810ULL, 0x000fc80007ffe0ffULL,
0x000000072c00720cULL, 0x000fe40003f26070ULL, 0x00000040362b7812ULL, 0x000fca00078ec0ffULL,
0x000000013a357824ULL, 0x000fcc00078e022bULL, 0x000006b000009947ULL, 0x000fea0003800000ULL,
0x00000002ff467819ULL, 0x002fe20000011602ULL, 0x0000000200487824ULL, 0x000fc600078e0241ULL,
0x0000001046507810ULL, 0x040fe20007ffe0ffULL, 0x0000000146297824ULL, 0x140fe200078e0235ULL,
0x00000008464a7810ULL, 0x040fe40007ffe0ffULL, 0x0000001846527810ULL, 0x000fe20007ffe0ffULL,
0x00000001502b7824ULL, 0x100fe200078e0235ULL, 0x0000002947317210ULL, 0x040fe20007f3e0ffULL,
0x000000014a2a7824ULL, 0x000fe200078e0235ULL, 0x0000002846567810ULL, 0x000fe40007ffe0ffULL,
0x0000002b472f7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff347224ULL, 0x000fe200008e06ffULL,
0x0000002a472d7210ULL, 0x000fc40007f5e0ffULL, 0x00005e00312a7a11ULL, 0x000fe200078238ffULL,
0x000000ffff307224ULL, 0x000fe200018e06ffULL, 0x00005e002f2e7a11ULL, 0x000fe200078638ffULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x00005e002d2c7a11ULL, 0x000fe400078438ffULL,
0x00005f002f2f7a11ULL, 0x000fe200018f3c30ULL, 0x0000000152307824ULL, 0x100fe200078e0235ULL,
0x0000003046587810ULL, 0x000fe40007ffe0ffULL, 0x00005f002d2d7a11ULL, 0x000fe200010f3c32ULL,
0x0000000156327824ULL, 0x100fe200078e0235ULL, 0x0000002046547810ULL, 0x000fe20007ffe0ffULL,
0x0000000158337824ULL, 0x000fe200078e0235ULL, 0x00000038465a7810ULL, 0x000fc40007ffe0ffULL,
0x00005f00312b7a11ULL, 0x000fe200008f3c34ULL, 0x0000000154317824ULL, 0x100fe200078e0235ULL,
0x0000003047457210ULL, 0x000fe20007f3e0ffULL, 0x000000015a347824ULL, 0x000fe200078e0235ULL,
0x0000003603297217ULL, 0x000fe40007800000ULL, 0x0000003247357210ULL, 0x000fe20007fde0ffULL,
0x000000ffff327224ULL, 0x000fe200008e06ffULL, 0x00005e0045307a11ULL, 0x000fe200078238ffULL,
0x0000000129297824ULL, 0x000fe200078e0a36ULL, 0x0000003347377210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff4e7224ULL, 0x000fe200030e06ffULL, 0x00000003ff337819ULL, 0x000fc40000011602ULL,
0x0000003147367210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200020e06ffULL,
0x00005f0045317a11ULL, 0x000fe200008f3c32ULL, 0x000000045b457824ULL, 0x000fe200078e00ffULL,
0x000000294a00720cULL, 0x0c0fe20003f26070ULL, 0x000000044a4a7824ULL, 0x000fe200078e00ffULL,
0x00000003334d7812ULL, 0x000fe200078e4802ULL, 0x000000ffff337224ULL, 0x000fe200028e06ffULL,
0x000000294600720cULL, 0x000fe40003f46070ULL, 0x0000003447477210ULL, 0x000fc40007f7e0ffULL,
0x0000100048487811ULL, 0x000fe400078e60ffULL, 0x0ffffffc4d497812ULL, 0x100fe400078ef802ULL,
0xfffffffc45457812ULL, 0x000fe400078ee202ULL, 0xfffffffc4a4b7812ULL, 0x000fe200078ee24dULL,
0x0000001049497824ULL, 0x000fe200078e0248ULL, 0x00005e0036327a11ULL, 0x040fe200078a38ffULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0x00005e0047467a11ULL, 0x000fe200078838ffULL,
0x00000010452a7825ULL, 0x000fe200078e002aULL, 0x00005f0036337a11ULL, 0x000fc400028f3c33ULL,
0x00005e0037367a11ULL, 0x000fe200078638ffULL, 0x000000104b4b7824ULL, 0x000fe200078e0248ULL,
0x00005e0035347a11ULL, 0x000fe200078a38ffULL, 0x00000010452c7825ULL, 0x000fe200078e002cULL,
0x00005f0047477a11ULL, 0x000fe200020f3c4aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a497faeULL, 0x0003e2000d101c46ULL, 0x000000295600720cULL, 0x0c0fe20003f86070ULL,
0x0000000456567824ULL, 0x000fe200078e00ffULL, 0x00005f0037377a11ULL, 0x000fe200018f3c4cULL,
0x000000002c4b7faeULL, 0x0005e2000c901c46ULL, 0x000000295000720cULL, 0x0c0fe20003f26070ULL,
0x0000000450507824ULL, 0x000fe200078e00ffULL, 0x000000295200720cULL, 0x040fe20003f46070ULL,
0x0000000452527824ULL, 0x000fe200078e00ffULL, 0x00005f0035357a11ULL, 0x000fc400028f3c4eULL,
0x000000295400720cULL, 0x0c0fe20003f66070ULL, 0x0000000454547824ULL, 0x000fe200078e00ffULL,
0x000000295800720cULL, 0x0c0fe20003fa6070ULL, 0x0000000458587824ULL, 0x000fe200078e00ffULL,
0x000000295a00720cULL, 0x040fe20003fc6070ULL, 0x000000045a5a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc562b7812ULL, 0x002fe200078ee24dULL, 0x00000010452c7825ULL, 0x044fe200078e0030ULL,
0xfffffffc50297812ULL, 0x100fe400078ee24dULL, 0xfffffffc52497812ULL, 0x000fe200078ee24dULL,
0x0000001045307825ULL, 0x000fe200078e0034ULL, 0xfffffffc544b7812ULL, 0x000fc400078ee24dULL,
0xfffffffc584f7812ULL, 0x100fe200078ee24dULL, 0x0000001029297824ULL, 0x100fe200078e0248ULL,
0xfffffffc5a517812ULL, 0x000fe200078ee24dULL, 0x000000102b4d7824ULL, 0x000fe400078e0248ULL,
0x00000010452a7825ULL, 0x000fc800078e002eULL, 0x0000001049497824ULL, 0x100fe200078e0248ULL,
0x000000002a297faeULL, 0x0003e2000c901c46ULL, 0x000000104b4b7824ULL, 0x000fe400078e0248ULL,
0x00000010452e7825ULL, 0x000fe200078e0032ULL, 0x000000002c497faeULL, 0x0003e6000d101c46ULL,
0x000000104f4f7824ULL, 0x000fe200078e0248ULL, 0x000000002e4b7faeULL, 0x0003e2000d901c46ULL,
0x0000001045327825ULL, 0x000fc600078e0036ULL, 0x00000000304d7faeULL, 0x0003e2000e101c46ULL,
0x0000001051517824ULL, 0x000fe400078e0248ULL, 0x0000001045347825ULL, 0x000fe200078e0046ULL,
0x00000000324f7faeULL, 0x0003e8000e901c46ULL, 0x0000000034517faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x0000000802327811ULL, 0x042fe200078ff0ffULL,
0x000000045b597824ULL, 0x000fe200078e00ffULL, 0x0000003502297211ULL, 0x000fc400078ff0ffULL,
0x00000003ff2f7819ULL, 0x000fe20000011602ULL, 0x00000001322a7824ULL, 0x040fe200078e0235ULL,
0x00000029472b7210ULL, 0x040fe20007f3e0ffULL, 0x00000004324c7824ULL, 0x000fe200078e00ffULL,
0x0000002002347811ULL, 0x040fe400078ff0ffULL, 0x0000002a47297210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff307224ULL, 0x000fe200008e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe400078238ffULL,
0x0000002802367811ULL, 0x000fe200078ff0ffULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0x00005e00292c7a11ULL, 0x000fc400078438ffULL, 0x00005f002b2b7a11ULL, 0x000fe400008f3c30ULL,
0x00005f00292d7a11ULL, 0x000fe200010f3c2eULL, 0x0000000200297824ULL, 0x000fe200078e0241ULL,
0x00000010022e7811ULL, 0x040fe400078ff0ffULL, 0x0000001802307811ULL, 0x040fe400078ff0ffULL,
0x0000003002487811ULL, 0x000fe200078ff0ffULL, 0x000000042e4e7824ULL, 0x000fe200078e00ffULL,
0x00000038024a7811ULL, 0x000fe200078ff0ffULL, 0x0000000430507824ULL, 0x000fe200078e00ffULL,
0x000000032f337812ULL, 0x100fe200078e4802ULL, 0x00000001342f7824ULL, 0x100fe200078e0235ULL,
0x0000100029467811ULL, 0x000fe200078e60ffULL, 0x000000012e297824ULL, 0x000fe200078e0235ULL,
0x0ffffffc33457812ULL, 0x000fe200078ef802ULL, 0x0000000434347824ULL, 0x000fe200078e00ffULL,
0xfffffffc4e4b7812ULL, 0x000fe200078ee233ULL, 0x00000001302e7824ULL, 0x100fe200078e0235ULL,
0x0000002947297210ULL, 0x040fe20007f7e0ffULL, 0x0000000136307824ULL, 0x000fe200078e0235ULL,
0xfffffffc344f7812ULL, 0x000fe200078ee233ULL, 0x0000000436367824ULL, 0x000fe200078e00ffULL,
0x0000002e47347210ULL, 0x000fe20007f5e0ffULL, 0x0000000148317824ULL, 0x000fe200078e0235ULL,
0xfffffffc4c497812ULL, 0x000fe200078ee233ULL, 0x000000014a327824ULL, 0x000fe200078e0235ULL,
0xfffffffc36517812ULL, 0x100fe200078ee233ULL, 0x0000000448487824ULL, 0x000fe200078e00ffULL,
0xfffffffc504d7812ULL, 0x100fe200078ee233ULL, 0x000000044a4a7824ULL, 0x000fe200078e00ffULL,
0x00005e00292e7a11ULL, 0x000fe200078c38ffULL, 0x000000ffff367224ULL, 0x000fe200018e06ffULL,
0xfffffffc48537812ULL, 0x100fe200078ee233ULL, 0x0000001045557824ULL, 0x100fe200078e0246ULL,
0xfffffffc4a577812ULL, 0x000fe200078ee233ULL, 0x000000104b457824ULL, 0x100fe200078e0246ULL,
0x0000002f47337210ULL, 0x000fe20007f3e0ffULL, 0x000000104f4b7824ULL, 0x100fe200078e0246ULL,
0x0000003147377210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff317224ULL, 0x000fe200010e06ffULL,
0x0000003047357210ULL, 0x000fe20007f7e0ffULL, 0x00000010534f7824ULL, 0x000fe200078e0246ULL,
0x00005e0034307a11ULL, 0x040fe200078438ffULL, 0x000000ffff4e7224ULL, 0x000fe200008e06ffULL,
0x0000003247477210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff4c7224ULL, 0x000fe200018e06ffULL,
0x00005f00292f7a11ULL, 0x000fe200030f3c36ULL, 0x0000001049297824ULL, 0x100fe200078e0246ULL,
0x00005f0034317a11ULL, 0x000fe200010f3c31ULL, 0x000000104d497824ULL, 0x000fe200078e0246ULL,
0xfffffffc59537812ULL, 0x000fe200078ee202ULL, 0x00000010514d7824ULL, 0x100fe200078e0246ULL,
0x00005e0033327a11ULL, 0x000fe200078238ffULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x00005e0035347a11ULL, 0x000fe200078438ffULL, 0x0000001057517824ULL, 0x000fe200078e0246ULL,
0x00005e0037367a11ULL, 0x000fe200078638ffULL, 0x000000ffff487224ULL, 0x000fe200028e06ffULL,
0x00005e0047467a11ULL, 0x000fe200078838ffULL, 0x00000010532a7825ULL, 0x000fe200078e002aULL,
0x00005f0033337a11ULL, 0x000fc400008f3c4eULL, 0x00005f0035357a11ULL, 0x000fe200010f3c4cULL,
0x00000010532c7825ULL, 0x000fe200078e002cULL, 0x00005f0037377a11ULL, 0x000fe200018f3c4aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a557faeULL, 0x0003e2000b901c46ULL,
0x00005f0047477a11ULL, 0x000fe200020f3c48ULL, 0x00000010532e7825ULL, 0x040fe400078e002eULL,
0x000000002c297faeULL, 0x0003e4000b901c46ULL, 0x0000001053307825ULL, 0x040fe400078e0030ULL,
0x000000002e457faeULL, 0x0003e4000b901c46ULL, 0x0000001053327825ULL, 0x000fc400078e0032ULL,
0x0000000030497faeULL, 0x0003e4000b901c46ULL, 0x0000001053347825ULL, 0x040fe400078e0034ULL,
0x00000000324b7faeULL, 0x0003e4000b901c46ULL, 0x0000001053367825ULL, 0x040fe400078e0036ULL,
0x00000000344d7faeULL, 0x0003e4000b901c46ULL, 0x0000001053467825ULL, 0x000fc400078e0046ULL,
0x00000000364f7faeULL, 0x0003e8000b901c46ULL, 0x0000000046517faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5b00720cULL, 0x000fe20003f25270ULL,
0x000000b000007945ULL, 0x000fd80003800000ULL, 0x0000009000009947ULL, 0x000fea0003800000ULL,
0x00000300ff297624ULL, 0x002fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000000229067824ULL, 0x000fca00078e0206ULL, 0x000000050600720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x000000023d2a7824ULL, 0x000fe400078e0206ULL,
0x00000004ff2b7424ULL, 0x000fc800078e00ffULL, 0x000060002a2a7625ULL, 0x000fca00078e002bULL,
0x000000062a387981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000008284d7824ULL, 0x002fe400078e00ffULL,
0x000000ffff4b7224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff802297812ULL, 0x000fe200078ec0ffULL, 0x00000002002d7824ULL, 0x000fe200078e0243ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000014b2f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000729297812ULL, 0x000fe400078ef802ULL, 0x000010002d2d7811ULL, 0x000fc400078e60ffULL,
0x00000001ff287819ULL, 0x000fc80000011629ULL, 0x0000000328287812ULL, 0x000fc800078ec0ffULL,
0x0000004b282a7212ULL, 0x040fe400078e3cffULL, 0x0000002f28287212ULL, 0x000fc600078e3cffULL,
0x00000004292a7824ULL, 0x040fe400078e022aULL, 0x0000000429287824ULL, 0x000fe200078e0228ULL,
0x0000002002297810ULL, 0x000fe20007ffe0ffULL, 0x000000102a2a7824ULL, 0x100fe400078e022dULL,
0x0000001028287824ULL, 0x000fe200078e022dULL, 0xfffffff829297812ULL, 0x000fe400078ec0ffULL,
0x000000002a34783bULL, 0x000e640000000200ULL, 0x00000007292c7812ULL, 0x000fc400078ef802ULL,
0x000000002830783bULL, 0x0002a40000000200ULL, 0x00000018ff287819ULL, 0x002fe20000011434ULL,
0x0001000034587824ULL, 0x000fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe20000011435ULL,
0x0000003400a07306ULL, 0x000fe20000009400ULL, 0x00000018ff2b7819ULL, 0x000fe20000011436ULL,
0x0001000035597824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000018ff467819ULL, 0x004fc40000011430ULL, 0x00000018ff457819ULL, 0x000fe20000011437ULL,
0x0000002800a27306ULL, 0x000fe20000209400ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff497819ULL, 0x000fe40000011432ULL, 0x00000018ff4a7819ULL, 0x000fe40000011433ULL,
0x00000018ff487819ULL, 0x000fe20000011431ULL, 0x0000002800a77306ULL, 0x000e700000205400ULL,
0x0000002800877306ULL, 0x0004f0000020d400ULL, 0x0000002a00a87306ULL, 0x000fe20000209400ULL,
0x00000001ff287819ULL, 0x004fc4000001162cULL, 0x000000a7a200720bULL, 0x002fe40003fdd000ULL,
0x0000000328287812ULL, 0x000fc600078ec0ffULL, 0x0000002a00ab7306ULL, 0x000fe20000205400ULL,
0x0000004b28297212ULL, 0x040fe400078e3cffULL, 0x0000002f282f7212ULL, 0x000fe400078e3cffULL,
0x000000024b4b7810ULL, 0x000fc60007ffe0ffULL, 0x0000002a00857306ULL, 0x0003e2000020d400ULL,
0x0000000187876812ULL, 0x008fce00078efcffULL, 0x0000002b00aa7306ULL, 0x000fe20000209400ULL,
0x000000042c2a7824ULL, 0x042fe400078e0229ULL, 0x000000042c2c7824ULL, 0x000fe400078e022fULL,
0x000000102a2a7824ULL, 0x100fe400078e022dULL, 0x000000102c2c7824ULL, 0x000fe200078e022dULL,
0x0000002b00a97306ULL, 0x000fea0000205400ULL, 0x000000002c2c783bULL, 0x000e660000000200ULL,
0x0000002b00837306ULL, 0x0005f0000020d400ULL, 0x0000005800707306ULL, 0x000fe20000209400ULL,
0x000000002a28783bULL, 0x004eae0000000200ULL, 0x0000005800bb7306ULL, 0x000ef00000205400ULL,
0x0000003400a17306ULL, 0x000f300000005400ULL, 0x0000003400887306ULL, 0x0008a2000000d400ULL,
0x000000bb7000720bULL, 0x008fc40003f9d000ULL, 0x00000018ff737819ULL, 0x002fe4000001142dULL,
0x00000018ff797819ULL, 0x000fc6000001142eULL, 0x0000003500a37306ULL, 0x000fe20000009400ULL,
0x0000010034347824ULL, 0x010fe200078e00ffULL, 0x000000a1a000720bULL, 0x000fe40003f5d000ULL,
0x00000018ff5f7819ULL, 0x000fe4000001142cULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500a67306ULL, 0x000e620000005400ULL, 0x0001000028717824ULL, 0x004fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fc8000001142fULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000003500867306ULL, 0x0004e2000000d400ULL, 0x0000000188882812ULL, 0x000fce00078efcffULL,
0x0000003400bd7306ULL, 0x000fe20000209400ULL, 0x0000010035357824ULL, 0x004fe200078e00ffULL,
0x000000a6a300720bULL, 0x002fc80003fbd000ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400ba7306ULL, 0x000e6e0000205400ULL, 0x0000000186865812ULL, 0x008fe200078efcffULL,
0x00000034009c7306ULL, 0x0005e2000020d400ULL, 0x000000a9aa00720bULL, 0x000fce0003fbd000ULL,
0x0000005800997306ULL, 0x000722000020d400ULL, 0x0001000037347824ULL, 0x004fe200078e00ffULL,
0x000000babd00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500c67306ULL, 0x000fe20000209400ULL, 0x0001000036587824ULL, 0x008fe200078e00ffULL,
0x0000000183835812ULL, 0x000fc800078efcffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x0000003500c97306ULL, 0x000e620000205400ULL, 0x0000000199994812ULL, 0x010fe400078efcffULL,
0x000000019c9c3812ULL, 0x000fe400078efcffULL, 0x000000aba800720bULL, 0x000fc60003f7d000ULL,
0x00000035009a7306ULL, 0x0004f0000020d400ULL, 0x0000003600a57306ULL, 0x000fe20000009400ULL,
0x00000018ff357819ULL, 0x004fe40000011428ULL, 0x000000c9c600720bULL, 0x002fc40003f9d000ULL,
0x0000000185853812ULL, 0x000fc600078efcffULL, 0x0000003600a47306ULL, 0x000e700000005400ULL,
0x0000003600847306ULL, 0x000522000000d400ULL, 0x000000019a9a4812ULL, 0x008fce00078efcffULL,
0x0000003500d07306ULL, 0x000fe20000209400ULL, 0x0000010036367824ULL, 0x004fe200078e00ffULL,
0x000000a4a500720bULL, 0x002fc80003f5d000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003500d37306ULL, 0x000fee0000205400ULL, 0x0000000184842812ULL, 0x010fe200078efcffULL,
0x0000003500747306ULL, 0x0003f0000020d400ULL, 0x0000003000917306ULL, 0x000fe20000009400ULL,
0x0001000030357824ULL, 0x002fce00078e00ffULL, 0x0000003000927306ULL, 0x000ff00000005400ULL,
0x0000003000547306ULL, 0x0003f0000000d400ULL, 0x0000003400ce7306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x002fce00078e00ffULL, 0x0000003400d17306ULL, 0x000e700000205400ULL,
0x00000034009b7306ULL, 0x0004f0000020d400ULL, 0x00000037009d7306ULL, 0x000fe20000009400ULL,
0x00000018ff347819ULL, 0x004fc4000001142aULL, 0x000000d1ce00720bULL, 0x002fca0003f9d000ULL,
0x00000037009e7306ULL, 0x000e700000005400ULL, 0x0000003700807306ULL, 0x000522000000d400ULL,
0x000000019b9b4812ULL, 0x008fce00078efcffULL, 0x0000003400c77306ULL, 0x000fe20000209400ULL,
0x0000010037377824ULL, 0x004fe200078e00ffULL, 0x0000009e9d00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000003400c47306ULL, 0x000fee0000205400ULL,
0x0000000180803812ULL, 0x010fe200078efcffULL, 0x00000034006a7306ULL, 0x0003f0000020d400ULL,
0x0000003600ca7306ULL, 0x000fe20000209400ULL, 0x00000018ff347819ULL, 0x002fe20000011430ULL,
0x0001000031307824ULL, 0x000fcc00078e00ffULL, 0x0000003600cd7306ULL, 0x000ff00000205400ULL,
0x0000003600967306ULL, 0x0003f0000020d400ULL, 0x0000005800c87306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x002fce0000011429ULL, 0x0000005800cb7306ULL, 0x000e700000205400ULL,
0x00000058009f7306ULL, 0x0004f0000020d400ULL, 0x0000003600cc7306ULL, 0x000fe20000209400ULL,
0x00000018ff587819ULL, 0x004fc40000011435ULL, 0x000000cbc800720bULL, 0x002fca0003fdd000ULL,
0x0000003600cf7306ULL, 0x000ff00000205400ULL, 0x00000036006f7306ULL, 0x0003e2000020d400ULL,
0x000000019f9f6812ULL, 0x008fce00078efcffULL, 0x0000003700d27306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x002fe20000011430ULL, 0x0000010031307824ULL, 0x000fcc00078e00ffULL,
0x0000003700d57306ULL, 0x000e700000205400ULL, 0x00000037007d7306ULL, 0x0004f0000020d400ULL,
0x0000005900c57306ULL, 0x000fe20000209400ULL, 0x00000018ff377819ULL, 0x004fc4000001142bULL,
0x000000d5d200720bULL, 0x002fca0003fdd000ULL, 0x0000005900c27306ULL, 0x000e700000205400ULL,
0x0000005900977306ULL, 0x000522000020d400ULL, 0x000000017d7d6812ULL, 0x008fce00078efcffULL,
0x0000005800be7306ULL, 0x000fe20000209400ULL, 0x0001000033597824ULL, 0x004fe200078e00ffULL,
0x000000c2c500720bULL, 0x002fc80003f3d000ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000005800c17306ULL, 0x000fee0000205400ULL, 0x0000000197971812ULL, 0x010fe200078efcffULL,
0x0000005800617306ULL, 0x0003e2000020d400ULL, 0x000000cdca00720bULL, 0x000fce0003f3d000ULL,
0x0000003700c07306ULL, 0x000fe20000209400ULL, 0x0001000032587824ULL, 0x002fca00078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000003700c37306ULL, 0x000fe20000205400ULL,
0x0000000196961812ULL, 0x000fce00078efcffULL, 0x0000003700657306ULL, 0x0003f0000020d400ULL,
0x0000007100d67306ULL, 0x000fe20000209400ULL, 0x00000018ff377819ULL, 0x002fce0000011430ULL,
0x0000007100d97306ULL, 0x000e700000205400ULL, 0x0000003400bc7306ULL, 0x000ff00000209400ULL,
0x0000003400bf7306ULL, 0x000fe20000205400ULL, 0x000000d9d600720bULL, 0x002fce0003f9d000ULL,
0x0000003400357306ULL, 0x0003f0000020d400ULL, 0x0000003700b37306ULL, 0x000fe20000209400ULL,
0x0000010032347824ULL, 0x002fce00078e00ffULL, 0x0000003700b47306ULL, 0x000ff00000205400ULL,
0x0000003700307306ULL, 0x0003f0000020d400ULL, 0x0000003200907306ULL, 0x000fe20000009400ULL,
0x0000010033377824ULL, 0x002fca00078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011437ULL,
0x00000032008d7306ULL, 0x000ff00000005400ULL, 0x0000003200517306ULL, 0x000ff0000000d400ULL,
0x00000033008b7306ULL, 0x000ff00000009400ULL, 0x00000033008e7306ULL, 0x000ff00000005400ULL,
0x0000003300507306ULL, 0x000ff0000000d400ULL, 0x0000005800ac7306ULL, 0x000ff00000209400ULL,
0x0000005800ad7306ULL, 0x000ff00000205400ULL, 0x0000005800327306ULL, 0x000ff0000020d400ULL,
0x0000005900757306ULL, 0x000ff00000209400ULL, 0x0000005900727306ULL, 0x000ff00000205400ULL,
0x0000005900337306ULL, 0x000ff0000020d400ULL, 0x0000002800b77306ULL, 0x000ff00000009400ULL,
0x0000002800b27306ULL, 0x000e700000005400ULL, 0x00000028006c7306ULL, 0x0004f0000000d400ULL,
0x0000007300587306ULL, 0x000fe20000209400ULL, 0x0000010028287824ULL, 0x004fe200078e00ffULL,
0x000000b2b700720bULL, 0x002fc80003f3d000ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000007300597306ULL, 0x000fee0000205400ULL, 0x000000016c6c1812ULL, 0x008fe200078efcffULL,
0x00000073005a7306ULL, 0x0003e2000020d400ULL, 0x000000cfcc00720bULL, 0x000fce0003f3d000ULL,
0x00000071007b7306ULL, 0x0004e2000020d400ULL, 0x0001000029737824ULL, 0x002fca00078e00ffULL,
0x00000018ffd47819ULL, 0x000fe40000011473ULL, 0x0000002900b57306ULL, 0x000fe20000009400ULL,
0x000100002a717824ULL, 0x004fe200078e00ffULL, 0x000000016f6f1812ULL, 0x000fcc00078efcffULL,
0x0000002900b67306ULL, 0x000e620000005400ULL, 0x000000017b7b4812ULL, 0x008fce00078efcffULL,
0x0000002800d87306ULL, 0x000ff00000209400ULL, 0x0000002800db7306ULL, 0x000ea20000205400ULL,
0x000000b6b500720bULL, 0x002fce0003fbd000ULL, 0x000000d400da7306ULL, 0x000ff00000209400ULL,
0x000000d400dd7306ULL, 0x000e620000205400ULL, 0x000000dbd800720bULL, 0x004fce0003fdd000ULL,
0x0000002900697306ULL, 0x0004f0000000d400ULL, 0x0000002a00b17306ULL, 0x000fe20000009400ULL,
0x0000010029297824ULL, 0x004fe200078e00ffULL, 0x000000ddda00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002a00b07306ULL, 0x000e620000005400ULL,
0x0000000169695812ULL, 0x008fe400078efcffULL, 0x000000c4c700720bULL, 0x000fca0003fbd000ULL,
0x0000002a00647306ULL, 0x0004f0000000d400ULL, 0x0000004500ae7306ULL, 0x000fe20000209400ULL,
0x000001002a2a7824ULL, 0x004fe200078e00ffULL, 0x000000b0b100720bULL, 0x002fc40003f7d000ULL,
0x000000016a6a5812ULL, 0x000fe400078efcffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000004500af7306ULL, 0x000e620000205400ULL, 0x000000c1be00720bULL, 0x000fcc0003fbd000ULL,
0x0000000164643812ULL, 0x008fe200078efcffULL, 0x0000005c006d7306ULL, 0x000fe20000209400ULL,
0x000000929100720bULL, 0x000fca0003f7d000ULL, 0x0000000161615812ULL, 0x000fe400078efcffULL,
0x0000005c006e7306ULL, 0x000fe20000205400ULL, 0x000000afae00720bULL, 0x002fe40003f5d000ULL,
0x000000bfbc00720bULL, 0x000fc60003fbd000ULL, 0x0000000154543812ULL, 0x000fe400078efcffULL,
0x0000005c00377306ULL, 0x000fe4000020d400ULL, 0x000000546154723eULL, 0x000fcc00000010ffULL,
0x00000079005b7306ULL, 0x000fe20000209400ULL, 0x0000000135355812ULL, 0x000fce00078efcffULL,
0x00000079005c7306ULL, 0x000ff00000205400ULL, 0x00000079005d7306ULL, 0x000ff0000020d400ULL,
0x00000031008f7306ULL, 0x000ff00000009400ULL, 0x00000031008a7306ULL, 0x000ff00000005400ULL,
0x0000003100527306ULL, 0x000ff0000000d400ULL, 0x0000002800797306ULL, 0x0002b0000020d400ULL,
0x000000d4007c7306ULL, 0x000722000020d400ULL, 0x00000018ff287819ULL, 0x002fce0000011471ULL,
0x0000003600b97306ULL, 0x000fe20000209400ULL, 0x000100002bd47824ULL, 0x008fe200078e00ffULL,
0x0000000179796812ULL, 0x004fcc00078efcffULL, 0x0000003600b87306ULL, 0x000e620000205400ULL,
0x000000017c7c4812ULL, 0x010fc800078efcffULL, 0x000000697c7c723eULL, 0x000fc600000010ffULL,
0x0000003600317306ULL, 0x0004f0000020d400ULL, 0x0000002900dc7306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x004fe40000011434ULL, 0x000000b8b900720bULL, 0x002fca0003f7d000ULL,
0x0000002900df7306ULL, 0x000e700000205400ULL, 0x0000002a00e07306ULL, 0x000fe20000209400ULL,
0x0000000131313812ULL, 0x008fce00078efcffULL, 0x0000002a00e37306ULL, 0x000ea20000205400ULL,
0x000000dfdc00720bULL, 0x002fce0003fdd000ULL, 0x0000002b00957306ULL, 0x000ff00000009400ULL,
0x0000002b00987306ULL, 0x000e620000005400ULL, 0x000000e3e000720bULL, 0x004fce0003f9d000ULL,
0x0000002b00577306ULL, 0x0004f0000000d400ULL, 0x0000003600817306ULL, 0x000fe20000209400ULL,
0x000001002b2b7824ULL, 0x004fe200078e00ffULL, 0x000000989500720bULL, 0x002fc80003f3d000ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000003600827306ULL, 0x000fee0000205400ULL,
0x0000000157571812ULL, 0x008fe200078efcffULL, 0x0000003600347306ULL, 0x000fe2000020d400ULL,
0x0000008d9000720bULL, 0x000fe20003f3d000ULL, 0x000001002e8d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001148dULL, 0x0000004500787306ULL, 0x000e6c000020d400ULL,
0x0000000151511812ULL, 0x000fe400078efcffULL, 0x0000005f00667306ULL, 0x000fe20000209400ULL,
0x000000727500720bULL, 0x000fce0003f3d000ULL, 0x0000005f00677306ULL, 0x000fe20000205400ULL,
0x0000000178782812ULL, 0x002fe400078efcffULL, 0x000000d3d000720bULL, 0x000fc60003f5d000ULL,
0x0000000133331812ULL, 0x000fe400078efcffULL, 0x0000005f00367306ULL, 0x000ff0000020d400ULL,
0x0000007a005e7306ULL, 0x000fe20000209400ULL, 0x0000000174742812ULL, 0x000fc800078efcffULL,
0x000000797479723eULL, 0x000fc600000010ffULL, 0x0000007a005f7306ULL, 0x000ff00000205400ULL,
0x0000007a00607306ULL, 0x000ff0000020d400ULL, 0x00000029007a7306ULL, 0x0002b0000020d400ULL,
0x0000002800de7306ULL, 0x000fe20000209400ULL, 0x00000018ff297819ULL, 0x002fce00000114d4ULL,
0x0000002800e17306ULL, 0x000e620000205400ULL, 0x000000017a7a6812ULL, 0x004fce00078efcffULL,
0x0000002800737306ULL, 0x0005f0000020d400ULL, 0x0000002a00717306ULL, 0x000722000020d400ULL,
0x000100002c287824ULL, 0x004fe200078e00ffULL, 0x000000e1de00720bULL, 0x002fcc0003f5d000ULL,
0x0000002900d47306ULL, 0x000fe20000209400ULL, 0x000100002d2a7824ULL, 0x008fca00078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe4000001142aULL, 0x0000002900d77306ULL, 0x000e620000205400ULL,
0x0000000171714812ULL, 0x010fe400078efcffULL, 0x000000c3c000720bULL, 0x000fe40003f9d000ULL,
0x0000000173732812ULL, 0x000fc600078efcffULL, 0x0000002b00a77306ULL, 0x000ff00000209400ULL,
0x0000002b00a67306ULL, 0x000ea20000205400ULL, 0x000000d7d400720bULL, 0x002fe40003fdd000ULL,
0x0000000165654812ULL, 0x000fca00078efcffULL, 0x0000002b00a07306ULL, 0x0003f0000020d400ULL,
0x0000002900707306ULL, 0x000722000020d400ULL, 0x00000007022b7812ULL, 0x002fe400078ec0ffULL,
0x000000a6a700720bULL, 0x004fc40003f5d000ULL, 0x000000082bab7812ULL, 0x000fc600078ef802ULL,
0x0000004600937306ULL, 0x000fe20000209400ULL, 0x00000018ff297819ULL, 0x008fe40000011428ULL,
0x0000004d02287211ULL, 0x000fe400078fe0ffULL, 0x000000044d4d7810ULL, 0x000fc60007ffe0ffULL,
0x0000002900a17306ULL, 0x000fe20000209400ULL, 0x0000000170706812ULL, 0x010fe400078efcffULL,
0x0000008a8f00720bULL, 0x000fe20003fdd000ULL, 0x000001002f8f7824ULL, 0x000fe200078e00ffULL,
0x00000001a0a02812ULL, 0x000fe400078efcffULL, 0x0000008e8b00720bULL, 0x000fe20003f5d000ULL,
0x0000002900a27306ULL, 0x000e620000205400ULL, 0x000100002f8e7824ULL, 0x000fe200078e00ffULL,
0x000000a06565723eULL, 0x000fc400000010ffULL, 0x00000018ff8f7819ULL, 0x000fe4000001148fULL,
0x00000018ff8e7819ULL, 0x000fe4000001148eULL, 0x00000029009e7306ULL, 0x0005e2000020d400ULL,
0x0000000152526812ULL, 0x000fe400078efcffULL, 0x000000adac00720bULL, 0x000fe40003fdd000ULL,
0x0000000150502812ULL, 0x000fe400078efcffULL, 0x000000523152723eULL, 0x000fe200000010ffULL,
0x0000004600947306ULL, 0x000ee20000205400ULL, 0x0000000728297812ULL, 0x004fc400078e78abULL,
0x0000000228287810ULL, 0x000fe40007ffe0ffULL, 0x000000a2a100720bULL, 0x002fe20003f5d000ULL,
0x00000010ab297824ULL, 0x000fe200078e0229ULL, 0x000000503350723eULL, 0x000fe200000010ffULL,
0x0000002c00687306ULL, 0x000fe20000009400ULL, 0x0000000132326812ULL, 0x000fe200078efcffULL,
0x0000001029297824ULL, 0x000fcc00078e00ffULL, 0x0000002c006b7306ULL, 0x000e620000005400ULL,
0x000000949300720bULL, 0x008fe40003f9d000ULL, 0x000000019e9e2812ULL, 0x000fca00078efcffULL,
0x0000002c004f7306ULL, 0x0005f0000000d400ULL, 0x00000046004c7306ULL, 0x000ee2000020d400ULL,
0x000001002c2c7824ULL, 0x004fe200078e00ffULL, 0x0000006b6800720bULL, 0x002fc80003fdd000ULL,
0x00000018ffa97819ULL, 0x000fe4000001142cULL, 0x00000007282c7812ULL, 0x000fe200078e78abULL,
0x00000048008c7306ULL, 0x000fe20000209400ULL, 0x000000002928783bULL, 0x000e660000000200ULL,
0x00000010aba87824ULL, 0x000fe200078e022cULL, 0x00000088992c723eULL, 0x000fe400000010ffULL,
0x000000014c4c4812ULL, 0x008fe200078efcffULL, 0x0000004800897306ULL, 0x000ea20000205400ULL,
0x000000b4b300720bULL, 0x000fc40003f9d000ULL, 0x000000014f4f6812ULL, 0x000fca00078efcffULL,
0x00000049007f7306ULL, 0x000fec0000209400ULL, 0x0000000130304812ULL, 0x000fe400078efcffULL,
0x00000049007e7306ULL, 0x000ee20000205400ULL, 0x000000898c00720bULL, 0x004fce0003fbd000ULL,
0x0000004800477306ULL, 0x000eb0000020d400ULL, 0x0000004900457306ULL, 0x000f22000020d400ULL,
0x0000007e7f00720bULL, 0x008fce0003f7d000ULL, 0x0000004a00777306ULL, 0x000fe20000209400ULL,
0x0000000147475812ULL, 0x004fe400078efcffULL, 0x000000828100720bULL, 0x000fca0003fbd000ULL,
0x0000004a00767306ULL, 0x000ea20000205400ULL, 0x0000000145453812ULL, 0x010fe400078efcffULL,
0x0000006e6d00720bULL, 0x000fca0003f7d000ULL, 0x0000002d00637306ULL, 0x000fe20000009400ULL,
0x0000000134345812ULL, 0x000fce00078efcffULL, 0x0000002d00627306ULL, 0x000ee20000005400ULL,
0x000000767700720bULL, 0x004fe40003f9d000ULL, 0x0000000137373812ULL, 0x000fe400078efcffULL,
0x000000676600720bULL, 0x000fc60003f7d000ULL, 0x0000002d004e7306ULL, 0x0005f0000000d400ULL,
0x0000004a00467306ULL, 0x000f22000020d400ULL, 0x000001002d2d7824ULL, 0x004fe200078e00ffULL,
0x000000626300720bULL, 0x008fc40003fbd000ULL, 0x000000647362723eULL, 0x000fe400000010ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001142dULL, 0x000000a900a37306ULL, 0x000fe20000209400ULL,
0x0000009c872d723eULL, 0x000fe200000010ffULL, 0x000100002e877824ULL, 0x000fe200078e00ffULL,
0x000000716a63723eULL, 0x000fe400000010ffULL, 0x000000577064723eULL, 0x000fe400000010ffULL,
0x00000018ff877819ULL, 0x000fe20000011487ULL, 0x000000a900a47306ULL, 0x000ea20000205400ULL,
0x0000002c280c723cULL, 0x002fe2000004180cULL, 0x0000000146464812ULL, 0x010fc400078efcffULL,
0x0000000136363812ULL, 0x000fe400078efcffULL, 0x000000595800720bULL, 0x000fe40003f7d000ULL,
0x000000aa00a57306ULL, 0x000fe20000209400ULL, 0x00000086972c723eULL, 0x000fe200000010ffULL,
0x000000622814723cULL, 0x040fe20000041814ULL, 0x0000009a852d723eULL, 0x000fe400000010ffULL,
0x000000014e4e5812ULL, 0x000fe400078efcffULL, 0x0000005c5b00720bULL, 0x000fe20003fbd000ULL,
0x000000aa00987306ULL, 0x000e620000205400ULL, 0x000000a4a300720bULL, 0x004fe20003f9d000ULL,
0x0000002c2808723cULL, 0x000fe20000041808ULL, 0x000000015a5a3812ULL, 0x000fc400078efcffULL,
0x0000004f9e9c723eULL, 0x000fc600000010ffULL, 0x0000002f004a7306ULL, 0x000fe20000009400ULL,
0x0000007d782d723eULL, 0x000fe200000010ffULL, 0x000000642810723cULL, 0x040fe20000041810ULL,
0x000000809b2c723eULL, 0x000fe400000010ffULL, 0x0000006c7b78723eULL, 0x000fe400000010ffULL,
0x0000007a6f7d723eULL, 0x000fe200000010ffULL, 0x0000002f00537306ULL, 0x000ea20000005400ULL,
0x00000098a500720bULL, 0x002fe20003fdd000ULL, 0x0000002c2820723cULL, 0x000fe20000041820ULL,
0x000000015d5d5812ULL, 0x000fca00078efcffULL, 0x0000002e00567306ULL, 0x000fe40000009400ULL,
0x00000078281c723cULL, 0x040fec000004181cULL, 0x0000002e00557306ULL, 0x000e620000005400ULL,
0x000000534a00720bULL, 0x004fe20003f5d000ULL, 0x0000007c2818723cULL, 0x000fe20000041818ULL,
0x000000304753723eULL, 0x000fca00000010ffULL, 0x0000002f00497306ULL, 0x0004f0000000d400ULL,
0x0000002e00487306ULL, 0x0008e2000000d400ULL, 0x00000096832f723eULL, 0x004fe400000010ffULL,
0x000000555600720bULL, 0x002fc40003f3d000ULL, 0x000000354c55723eULL, 0x000fc600000010ffULL,
0x000000a9009d7306ULL, 0x000e62000020d400ULL, 0x000000849f2e723eULL, 0x010fe400000010ffULL,
0x0000000149492812ULL, 0x008fca00078efcffULL, 0x000000aa00917306ULL, 0x000ea2000020d400ULL,
0x0000002e2824723cULL, 0x000fe20000041824ULL, 0x0000000148481812ULL, 0x000fcc00078efcffULL,
0x0000008a008b7306ULL, 0x000fe20000209400ULL, 0x00000010a82e7824ULL, 0x000fe200078e00ffULL,
0x000000019d9d4812ULL, 0x002fe400078efcffULL, 0x000000513228723eULL, 0x000fe400000010ffULL,
0x000000344529723eULL, 0x000fe200000010ffULL, 0x000000002e2c783bULL, 0x000e620000000200ULL,
0x0000008a00887306ULL, 0x000ee20000205400ULL, 0x0000000191916812ULL, 0x004fe400078efcffULL,
0x000000374651723eULL, 0x000fc400000010ffULL, 0x0000009d369d723eULL, 0x000fe400000010ffULL,
0x0000004e914e723eULL, 0x000fe200000010ffULL, 0x0000008700837306ULL, 0x000ff00000209400ULL,
0x00000087007e7306ULL, 0x000ea20000205400ULL, 0x000000888b00720bULL, 0x008fce0003f9d000ULL,
0x0000008f002b7306ULL, 0x000ff00000209400ULL, 0x0000008f00307306ULL, 0x000ee20000205400ULL,
0x0000007e8300720bULL, 0x004fe20003fdd000ULL, 0x000000542c0c723cULL, 0x042fec000004180cULL,
0x0000008a00857306ULL, 0x000e64000020d400ULL, 0x000000522c08723cULL, 0x040fec0000041808ULL,
0x0000008700777306ULL, 0x000ea2000020d400ULL, 0x000000302b00720bULL, 0x008fe20003f3d000ULL,
0x000000282c24723cULL, 0x000fec0000041824ULL, 0x0000008d00687306ULL, 0x000fe20000209400ULL,
0x0000000185854812ULL, 0x002fc400078efcffULL, 0x0000005f5e00720bULL, 0x000fe40003f9d000ULL,
0x000000855a4f723eULL, 0x000fe200000010ffULL, 0x000000502c20723cULL, 0x000fe40000041820ULL,
0x0000008d00697306ULL, 0x000e620000205400ULL, 0x0000000177776812ULL, 0x004fc800078efcffULL,
0x00000048775c723eULL, 0x000fe200000010ffULL, 0x0000009c2c1c723cULL, 0x000fe4000004181cULL,
0x0000008e00577306ULL, 0x000fe20000209400ULL, 0x0000000160604812ULL, 0x000fca00078efcffULL,
0x0000004e2c18723cULL, 0x000fe40000041818ULL, 0x0000008e002a7306ULL, 0x000ea20000205400ULL,
0x000000696800720bULL, 0x002fce0003f7d000ULL, 0x0000008f008f7306ULL, 0x000e70000020d400ULL,
0x0000008d00567306ULL, 0x000ee2000020d400ULL, 0x0000002a5700720bULL, 0x004fce0003fdd000ULL,
0x0000008e008e7306ULL, 0x000ea2000020d400ULL, 0x000000018f8f1812ULL, 0x002fe400078efcffULL,
0x000000044b00780cULL, 0x000fe40003f25270ULL, 0x0000008f608f723eULL, 0x000fe400000010ffULL,
0x0000000156563812ULL, 0x008fc800078efcffULL, 0x000000565d5d723eULL, 0x000fe400000010ffULL,
0x000000018e8e6812ULL, 0x004fca00078efcffULL, 0x0000005c2c14723cULL, 0x000fe20000041814ULL,
0x000000498e8e723eULL, 0x000fce00000010ffULL, 0x0000008e2c10723cULL, 0x000fe20000041810ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe12000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff437224ULL, 0x000fe200078e0041ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd22000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003e287f8cULL, 0x000fe2000c80043fULL, 0x000000243c247220ULL, 0x040fe40000410000ULL,
0x000000253c257220ULL, 0x040fe20000410000ULL, 0x000004003e2b7984ULL, 0x000e620000000800ULL,
0x000000203c207220ULL, 0x040fe40000410000ULL, 0x0000000e3c2a7220ULL, 0x040fe40000410000ULL,
0x000000263c267220ULL, 0x000fc40000410000ULL, 0x000000273c277220ULL, 0x040fe40000410000ULL,
0x000000213c217220ULL, 0x040fe40000410000ULL, 0x0000000f3c2c7220ULL, 0x040fe40000410000ULL,
0x000000223c2d7220ULL, 0x040fe40000410000ULL, 0x000000233c2e7220ULL, 0x040fe40000410000ULL,
0x0000001e3c2f7220ULL, 0x000fc40000410000ULL, 0x0000001a3c317220ULL, 0x040fe40000410000ULL,
0x0000000c3c0c7220ULL, 0x040fe40000410000ULL, 0x0000000d3c0d7220ULL, 0x040fe40000410000ULL,
0x000000083c087220ULL, 0x040fe40000410000ULL, 0x000000093c097220ULL, 0x040fe40000410000ULL,
0x0000000a3c0a7220ULL, 0x000fc40000410000ULL, 0x0000000b3c0b7220ULL, 0x040fe40000410000ULL,
0x0000001c3c1c7220ULL, 0x040fe40000410000ULL, 0x0000001d3c1d7220ULL, 0x040fe40000410000ULL,
0x0000001f3c307220ULL, 0x040fe40000410000ULL, 0x0000001b3c327220ULL, 0x040fe20000410000ULL,
0x800000002bff7812ULL, 0x002fe20007804829ULL, 0x000000143c1a7220ULL, 0x000fc40000410000ULL,
0x000000163c337220ULL, 0x040fe40000410000ULL, 0x000000173c347220ULL, 0x040fe40000410000ULL,
0x000000123c357220ULL, 0x040fe40000410000ULL, 0x000000133c367220ULL, 0x040fe40000410000ULL,
0x000000153c1b7220ULL, 0x000fe40000410000ULL, 0x000000ffff127224ULL, 0x000fc400078e0024ULL,
0x000000ffff137224ULL, 0x000fe400078e0025ULL, 0x000000ffff147224ULL, 0x000fe400078e0020ULL,
0x000000ffff157224ULL, 0x000fe400078e0021ULL, 0x000000ffff207224ULL, 0x000fe400078e002aULL,
0x000000ffff247224ULL, 0x000fe400078e0026ULL, 0x000000ffff257224ULL, 0x000fc400078e0027ULL,
0x000000103c1e7220ULL, 0x040fe40000410000ULL, 0x000000113c1f7220ULL, 0x000fe40000410000ULL,
0x000000ffff217224ULL, 0x000fe400078e002cULL, 0x000000ffff267224ULL, 0x000fe400078e002dULL,
0x000000ffff277224ULL, 0x000fe400078e002eULL, 0x000000ffff2a7224ULL, 0x000fc400078e002fULL,
0x000000183c187220ULL, 0x040fe40000410000ULL, 0x000000193c197220ULL, 0x000fe40000410000ULL,
0x000000ffff0f7224ULL, 0x000fe400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff107224ULL, 0x000fe400078e0008ULL, 0x000000ffff117224ULL, 0x000fc400078e0009ULL,
0x000000ffff167224ULL, 0x000fe400078e001cULL, 0x000000ffff177224ULL, 0x000fe400078e001dULL,
0x000000ffff227224ULL, 0x000fe400078e000aULL, 0x000000ffff237224ULL, 0x000fe400078e000bULL,
0x000000ffff2b7224ULL, 0x000fe400078e0030ULL, 0x000000ffff2c7224ULL, 0x000fc400078e0031ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0032ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0033ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0034ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff307224ULL, 0x000fe400078e0035ULL,
0x000000ffff317224ULL, 0x000fe200078e0036ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x0000000800097305ULL, 0x0002a4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x000000090000735dULL, 0x004fe40003800000ULL,
0x000004003e097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004021d7824ULL, 0x000fe200078e00ffULL,
0x0000003f0400720cULL, 0x000fc80003f05270ULL, 0xfffffff01d097812ULL, 0x000fca00078ec0ffULL,
0x00000080001c7824ULL, 0x000fca00078e0209ULL, 0x00f400001c087984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002020c7824ULL, 0x000fe400078e00ffULL,
0x0000000103427824ULL, 0x000fc600078e0a42ULL, 0x000000060c0d7812ULL, 0x000fc800078ec0ffULL,
0x000000010d297812ULL, 0x040fe400078efcffULL, 0x000000080d337812ULL, 0x000fe400078efcffULL,
0x000000422900720cULL, 0x080fe40003f26070ULL, 0x000000100d297812ULL, 0x000fe400078efcffULL,
0x000000423300720cULL, 0x080fe40003f06070ULL, 0x000000422900720cULL, 0x000fc40003fc6070ULL,
0x000000110d337812ULL, 0x040fe400078efcffULL, 0x000000180d297812ULL, 0x040fe400078efcffULL,
0x000000420d00720cULL, 0x080fe40003f46070ULL, 0x000000423300720cULL, 0x080fe40003fa6070ULL,
0x000000422900720cULL, 0x000fe40003f66070ULL, 0x000000090d357812ULL, 0x000fc400078efcffULL,
0x000000190d337812ULL, 0x040fe400078efcffULL, 0x000000200d297812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40005000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40004800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40004800000ULL,
0x000000423500720cULL, 0x080fe40003f86070ULL, 0x000000423300720cULL, 0x080fe40003f46070ULL,
0x000000422900720cULL, 0x000fe40003f26070ULL, 0x000000210d337812ULL, 0x040fe400078efcffULL,
0x000000280d297812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fc40004000000ULL,
0xff7fffff10107808ULL, 0x000fe40004000000ULL, 0xff7fffff23237808ULL, 0x000fe40006000000ULL,
0xff7fffff11117808ULL, 0x000fe40006000000ULL, 0x000000423300720cULL, 0x080fe40003f06070ULL,
0x000000422900720cULL, 0x000fe40003f86070ULL, 0x000000290d337812ULL, 0x000fc400078efcffULL,
0x000000300d297812ULL, 0x000fe400078efcffULL, 0xff7fffff24247808ULL, 0x000fe40007000000ULL,
0xff7fffff12127808ULL, 0x000fe40007000000ULL, 0xff7fffff25257808ULL, 0x000fe40006800000ULL,
0xff7fffff13137808ULL, 0x000fe40006800000ULL, 0x000000423300720cULL, 0x000fc40003fc6070ULL,
0x000000422900720cULL, 0x000fe40003fa6070ULL, 0x000000310d337812ULL, 0x040fe400078efcffULL,
0x000000380d297812ULL, 0x040fe400078efcffULL, 0x000000390d0d7812ULL, 0x000fe400078efcffULL,
0xff7fffff26267808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005800000ULL,
0xff7fffff27277808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff16167808ULL, 0x000fe40004800000ULL,
0x000000423300720cULL, 0x080fe40003f66070ULL, 0x000000422900720cULL, 0x000fc40003f46070ULL,
0x000000420d00720cULL, 0x000fe40003f26070ULL, 0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL,
0xff7fffff17177808ULL, 0x000fe40004000000ULL, 0xff7fffff2c2c7808ULL, 0x000fe40006000000ULL,
0xff7fffff18187808ULL, 0x000fe40006000000ULL, 0xff7fffff2d2d7808ULL, 0x000fc40007000000ULL,
0xff7fffff19197808ULL, 0x000fe40007000000ULL, 0xff7fffff2e2e7808ULL, 0x000fe40006800000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40005800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL, 0xff7fffff30307808ULL, 0x000fc40005000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL, 0xff7fffff31317808ULL, 0x000fe40004800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL, 0x0000000f080d7209ULL, 0x004fe40007810000ULL,
0x0000002009087209ULL, 0x000fe40007810000ULL, 0x0000000e0d0d7209ULL, 0x000fe40007810000ULL,
0x0000002108097209ULL, 0x000fc40007810000ULL, 0x000000100d087209ULL, 0x000fe40007810000ULL,
0x00000022090c7209ULL, 0x000fe40007810000ULL, 0x0000001108097209ULL, 0x000fe40007810000ULL,
0x000000230c0d7209ULL, 0x000fe40007810000ULL, 0x0000001209087209ULL, 0x000fe40007810000ULL,
0x000000240d0c7209ULL, 0x000fc40007810000ULL, 0x0000001308097209ULL, 0x000fe40007810000ULL,
0x000000250c0d7209ULL, 0x000fe40007810000ULL, 0x0000001409087209ULL, 0x000fe40007810000ULL,
0x000000260d0c7209ULL, 0x000fe40007810000ULL, 0x0000001508097209ULL, 0x000fe40007810000ULL,
0x000000270c0d7209ULL, 0x000fc40007810000ULL, 0x0000001609087209ULL, 0x000fe40007810000ULL,
0x0000002a0d0c7209ULL, 0x000fe40007810000ULL, 0x0000001708097209ULL, 0x000fe40007810000ULL,
0x0000002b0c0d7209ULL, 0x000fe40007810000ULL, 0x0000001809087209ULL, 0x000fe40007810000ULL,
0x0000002c0d0c7209ULL, 0x000fc40007810000ULL, 0x0000001908097209ULL, 0x000fe40007810000ULL,
0x0000002d0c0d7209ULL, 0x000fe40007810000ULL, 0x0000001a09087209ULL, 0x000fe40007810000ULL,
0x0000002e0d0c7209ULL, 0x000fe40007810000ULL, 0x0000001b08097209ULL, 0x000fe40007810000ULL,
0x0000002f0c0d7209ULL, 0x000fc40007810000ULL, 0x0000001e09087209ULL, 0x000fe40007810000ULL,
0x000000300d0c7209ULL, 0x000fe40007810000ULL, 0x0000001f08097209ULL, 0x000fe40007810000ULL,
0x000000310c337209ULL, 0x000fe20007810000ULL, 0x000018627f007947ULL, 0x000fea000b800000ULL,
0x0c401f0009087f89ULL, 0x0004e400000e0000ULL, 0x0000000809347209ULL, 0x008fe20007810000ULL,
0x000018b27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0033087f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a097f89ULL, 0x004ea800000e0000ULL, 0x0c401f000b287f89ULL, 0x000f2200000e0000ULL,
0x00000008330c7209ULL, 0x008fc60007810000ULL, 0x0c201f0034087f89ULL, 0x000ee200000e0000ULL,
0x000000090a0d7209ULL, 0x004fc60007810000ULL, 0x0c201f000c097f89ULL, 0x000ea200000e0000ULL,
0x000000280b287209ULL, 0x010fc60007810000ULL, 0x0c201f000d327f89ULL, 0x002e6800000e0000ULL,
0x0c201f0028297f89ULL, 0x00092200000e0000ULL, 0x0000000834087209ULL, 0x008fe40007810000ULL,
0x000000090c097209ULL, 0x004fe40007810000ULL, 0x000000320d0a7209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b080b7820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fc40000000000ULL,
0x00000004ff337e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe2000001080bULL, 0x0000000000057886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL,
0x0000000f000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b11117823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b12127823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b13137823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001080bULL, 0x0000000e000d7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b15157823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b16167823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b17177823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001080bULL,
0x0000001000107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b19197823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080bULL, 0x0000001100117308ULL, 0x000e620000000800ULL,
0x3fb8aa3b1f0b7823ULL, 0x000fe2000001080bULL, 0x0000000c0d0c723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b091f7820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001081fULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b22227823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b23237823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001081fULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x00000010110e723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b25257823ULL, 0x000fc4000001081fULL,
0x3fb8aa3b26267823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b27277823ULL, 0x100fe4000001081fULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081fULL, 0x00000022000f7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b2e2e7823ULL, 0x000fc4000001081fULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b30307823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b311f7823ULL, 0x000fe2000001081fULL,
0x0000002300327308ULL, 0x0008a20000000800ULL, 0x3f8000003322783eULL, 0x008fe400000010ffULL,
0x00000020210d723eULL, 0x002fca00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x000000ffff237224ULL, 0x010fe200078e0022ULL, 0x0000000f320f723eULL, 0x004fcc00000010ffULL,
0x0000001400147308ULL, 0x000fe20000000800ULL, 0x000000220c34723cULL, 0x000fe200000418ffULL,
0x000000121310723eULL, 0x002fcc00000010ffULL, 0x0000001500157308ULL, 0x000e700000000800ULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x000000141512723eULL, 0x002fce00000010ffULL, 0x0000002600267308ULL, 0x000ff00000000800ULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x000000242511723eULL, 0x004fce00000010ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000262713723eULL, 0x002fce00000010ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000221034723cULL, 0x000fee0000041834ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000001900197308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000010ffULL, 0x0000002a002a7308ULL, 0x000ff00000000800ULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x000000181916723eULL, 0x004fe200000010ffULL,
0x0000000fff197424ULL, 0x000fe200078e00ffULL, 0xfffffffc02187812ULL, 0x000fc800078ec0ffULL,
0x0000001819247219ULL, 0x000fe200000006ffULL, 0x0000002c002c7308ULL, 0x000fe60000000800ULL,
0x00000000242173a1ULL, 0x000ea200000e8000ULL, 0x00000000240473c4ULL, 0x000ee80000004000ULL,
0x0000002d002d7308ULL, 0x000f220000000800ULL, 0x0000002a2b15723eULL, 0x002fce00000010ffULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x0000002c2d17723eULL, 0x010fce00000010ffULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000000524ff7c12ULL, 0x004fe2000f804021ULL,
0x000000221434723cULL, 0x000fec0000041834ULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x0000000b000b7308ULL, 0x000ea20000000800ULL, 0x0000001a1b18723eULL, 0x002fce00000010ffULL,
0x0000002e002e7308ULL, 0x000ff00000000800ULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x0000001e0b1a723eULL, 0x004fe400000010ffULL, 0x00000028290b7209ULL, 0x000fca0007810000ULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000001f001f7308ULL, 0x000ea20000000800ULL,
0x0000002e2f19723eULL, 0x002fe400000010ffULL, 0x000000301f1b723eULL, 0x004fce00000010ffULL,
0x00000022182c723cULL, 0x000fe20000041834ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x000014a204008947ULL, 0x008fde000b800000ULL, 0x001c1fff2c207589ULL, 0x0002a400000e0000ULL,
0x00000000241f73a1ULL, 0x000ee200000e8000ULL, 0x00000000240473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x0000000524ff7c12ULL, 0x008fda000f80401fULL,
0x000014c204008947ULL, 0x010fea000b800000ULL, 0x001c1fff2e217589ULL, 0x00072800000e0000ULL,
0x001c1fff01227589ULL, 0x00066800000e0000ULL, 0x001c1fff23237589ULL, 0x0006a400000e0000ULL,
0x00000002ff1e7819ULL, 0x000fe40000011602ULL, 0x0000000c1d437812ULL, 0x000fc400078ec0ffULL,
0x000000071e1f7812ULL, 0x040fe200078ec0ffULL, 0x000000081e287824ULL, 0x040fe200078e00ffULL,
0x0000001eff267212ULL, 0x000fe200078e33ffULL, 0x000000081e247824ULL, 0x00afe200078e00ffULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x000000081e337824ULL, 0x040fe200078e00ffULL,
0x000000081e1e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff828257812ULL, 0x100fe400078ee21fULL,
0x0000000124277812ULL, 0x100fe200078ef61fULL, 0x000000081e4f7824ULL, 0x000fe200078e00ffULL,
0x0000000224297812ULL, 0x100fe200078ef61fULL, 0x000000081e287824ULL, 0x000fe200078e00ffULL,
0x00000003242b7812ULL, 0x000fc400078ef61fULL, 0x00000004242d7812ULL, 0x140fe400078ef61fULL,
0x00000005242f7812ULL, 0x140fe400078ef61fULL, 0x0000000624317812ULL, 0x000fe200078ef61fULL,
0x000000081e247824ULL, 0x040fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe400078ee226ULL,
0x0000001eff267212ULL, 0x000fe400078e33ffULL, 0x000000071e1f7812ULL, 0x000fc400078ec0ffULL,
0x00009000001e7811ULL, 0x000fe400078e58ffULL, 0xfffffff828357812ULL, 0x100fe400078ee21fULL,
0x0000000124377812ULL, 0x140fe200078ef61fULL, 0x00000010251d7824ULL, 0x100fe200078e021eULL,
0x0000000224457812ULL, 0x140fe200078ef61fULL, 0x000000102d287824ULL, 0x100fe200078e021eULL,
0x0000000324477812ULL, 0x040fe200078ef61fULL, 0x00000001431d7824ULL, 0x000fe200078e021dULL,
0x0000000424497812ULL, 0x140fe200078ef61fULL, 0x000000102f2a7824ULL, 0x100fe200078e021eULL,
0x00000005244b7812ULL, 0x140fe200078ef61fULL, 0x00000010312c7824ULL, 0x100fe200078e021eULL,
0x00000006244d7812ULL, 0x000fe200078ef61fULL, 0x00000010271f7824ULL, 0x000fe200078e021eULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee226ULL, 0x0000001029247824ULL, 0x100fe200078e021eULL,
0x0000000c1d007388ULL, 0x0003e20000000800ULL, 0x000000102b267824ULL, 0x000fc400078e021eULL,
0x00000001431f7824ULL, 0x040fe400078e021fULL, 0x0000000143257824ULL, 0x000fe400078e0224ULL,
0x00000010332e7824ULL, 0x000fe200078e021eULL, 0x0000000e1f007388ULL, 0x0007e20000000800ULL,
0x0000000143277824ULL, 0x000fe400078e0226ULL, 0x0000001035307824ULL, 0x000fe200078e021eULL,
0x0000001025007388ULL, 0x0007e20000000800ULL, 0x0000000143297824ULL, 0x000fc400078e0228ULL,
0x0000001037317824ULL, 0x000fe200078e021eULL, 0x0000001227007388ULL, 0x0007e20000000800ULL,
0x00000001432b7824ULL, 0x000fe400078e022aULL, 0x0000001045327824ULL, 0x000fe200078e021eULL,
0x0000001429007388ULL, 0x0007e20000000800ULL, 0x00000001432d7824ULL, 0x000fe400078e022cULL,
0x0000001047337824ULL, 0x000fe200078e021eULL, 0x000000162b007388ULL, 0x0007e20000000800ULL,
0x00000001432f7824ULL, 0x000fc400078e022eULL, 0x0000001049347824ULL, 0x100fe200078e021eULL,
0x000000182d007388ULL, 0x0007e20000000800ULL, 0x000000104b357824ULL, 0x100fe400078e021eULL,
0x000000104d367824ULL, 0x100fe200078e021eULL, 0x0000001a2f007388ULL, 0x0007e20000000800ULL,
0x000000104f377824ULL, 0x000fe400078e021eULL, 0x0000000143307824ULL, 0x040fe400078e0230ULL,
0x00000001431e7824ULL, 0x000fc400078e0231ULL, 0x0000000143327824ULL, 0x040fe200078e0232ULL,
0x0000000d30007388ULL, 0x0007e20000000800ULL, 0x00000001430c7824ULL, 0x042fe400078e0233ULL,
0x0000000143347824ULL, 0x040fe200078e0234ULL, 0x0000000f1e007388ULL, 0x0007e20000000800ULL,
0x0000000143247824ULL, 0x040fe400078e0235ULL, 0x0000000143367824ULL, 0x040fe200078e0236ULL,
0x0000001132007388ULL, 0x0007e20000000800ULL, 0x0000000143267824ULL, 0x000fc600078e0237ULL,
0x000000130c007388ULL, 0x0007e80000000800ULL, 0x0000001534007388ULL, 0x0007e80000000800ULL,
0x0000001724007388ULL, 0x0007e80000000800ULL, 0x0000001936007388ULL, 0x0007e80000000800ULL,
0x0000001b26007388ULL, 0x0007e80000000800ULL, 0x00f000081c008388ULL, 0x0007e80000000c00ULL,
0x00f200201c008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000040ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080040ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100040ff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030004047a10ULL, 0x000fe20007ffe0ffULL, 0x0000180040ff7f8cULL, 0x0003e6000c80043fULL,
0x000000070400720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffb69000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff307807ULL, 0x010fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x000162e000337802ULL, 0x000fe40000000f00ULL, 0x000010b000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0032ULL, 0xfffeb72000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x000fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x0001634000337802ULL, 0x000fe40000000f00ULL, 0x0000105000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0032ULL, 0xfffeb75000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0010ULL, 0x000163b000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000fa000007944ULL, 0x03efea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0032ULL,
0xfffeb7a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e0010ULL,
0x0001642000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x00000f3000007944ULL, 0x03cfea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0032ULL, 0xfffeb76000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0012ULL, 0x0001649000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x00000ec000007944ULL, 0x024fea0003c00000ULL, 0x000000ffffc17224ULL, 0x004fe200078e0032ULL,
0xfffebac000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x002fe200078e002aULL,
0x0001650000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000e5000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffffbe7224ULL, 0x004fe200078e0032ULL, 0xfffeba8000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x010fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x0001656000337802ULL, 0x000fc40000000f00ULL, 0x00000e3000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff117224ULL, 0x000fe200078e0032ULL, 0xfffee40000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x000fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x000165c000337802ULL, 0x000fc40000000f00ULL, 0x00000dd000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff117224ULL, 0x000fe200078e0032ULL, 0xfffee43000007947ULL, 0x000fea000383ffffULL,
0x0000001fff357424ULL, 0x008fe200078e00ffULL, 0x0001662000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000d3000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0032ULL, 0xfffee4a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x00afe200078e002aULL, 0x0001669000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x00000cc000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0032ULL,
0xfffee55000007947ULL, 0x000fea000383ffffULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x000166f000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x00000c6000007944ULL, 0x004fea0003c00000ULL, 0x000000ffffc77224ULL, 0x004fe200078e0032ULL,
0xfffee81000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x002fe200078e002aULL,
0x0001676000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x00000bf000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffffc47224ULL, 0x004fe200078e0032ULL, 0xfffee7c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x004fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x000167c000337802ULL, 0x000fc40000000f00ULL, 0x00000bd000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0032ULL, 0xffff0f6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x000fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x0001682000337802ULL, 0x000fc40000000f00ULL, 0x00000b7000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0032ULL, 0xffff0f9000007947ULL, 0x000fea000383ffffULL,
0x0000001fff357424ULL, 0x002fe200078e00ffULL, 0x0001688000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000ad000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0032ULL, 0xffff100000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x002fe200078e002aULL, 0x000168f000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x00000a6000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0032ULL,
0xffff10b000007947ULL, 0x000fea000383ffffULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x0001695000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x00000a0000007944ULL, 0x028fea0003c00000ULL, 0x000000ffffb17224ULL, 0x004fe200078e0032ULL,
0xffff136000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x002fe200078e002aULL,
0x000169c000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000099000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0032ULL, 0xffff131000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x010fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x00016a2000337802ULL, 0x000fc40000000f00ULL, 0x0000097000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0032ULL, 0xffff39e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff307807ULL, 0x000fe20004000000ULL, 0xffffffffff317424ULL, 0x000fe200078e00ffULL,
0x00016a8000337802ULL, 0x000fc40000000f00ULL, 0x0000091000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0032ULL, 0xffff3a1000007947ULL, 0x000fea000383ffffULL,
0x0000001fff357424ULL, 0x004fe200078e00ffULL, 0x00016ae000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000087000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0032ULL, 0xffff3a8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x006fe200078e002aULL, 0x00016b5000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000080000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0032ULL,
0xffff3b3000007947ULL, 0x000fea000383ffffULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x00016bb000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x000007a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff917224ULL, 0x004fe200078e0032ULL,
0xffff3df000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x002fe200078e002aULL,
0x00016c2000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000073000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff907224ULL, 0x004fe200078e0032ULL, 0xffff3da000007947ULL, 0x000fea000383ffffULL,
0x000000ffff297224ULL, 0x000fe200078e0009ULL, 0x00016ca0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x000fc400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000067000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0029ULL, 0xffffe73000007947ULL, 0x000fea000383ffffULL,
0x000000ffff297224ULL, 0x000fe200078e0033ULL, 0x00016d20000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x000005f000007944ULL, 0x024fea0003c00000ULL,
0x0000002933367209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e000aULL,
0x00016d90000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0000058000007944ULL, 0x000fea0003c00000ULL, 0x000000290a0a7209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e000bULL, 0x00016e00000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x000000290b287209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e0034ULL,
0x00016e70000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x000004a000007944ULL, 0x000fea0003c00000ULL, 0x0000002934087209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e0036ULL, 0x00016ee0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x0000002936097209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e000aULL,
0x00016f50000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x000003c000007944ULL, 0x000fea0003c00000ULL, 0x000000290a0a7209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e0028ULL, 0x00016fc0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fe400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000035000007944ULL, 0x000fea0003c00000ULL,
0xffffe51000007947ULL, 0x000fea000383ffffULL, 0x000000ffff337224ULL, 0x000fe200078e002cULL,
0x0001703000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fc400078e00ffULL,
0x00001c1fff357424ULL, 0x000fe400078e00ffULL, 0x000000ffff367224ULL, 0x000fe400078e0024ULL,
0x0000032000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e0032ULL,
0xffffeaf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff337224ULL, 0x002fe200078e002eULL,
0x000170b000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fe400078e00ffULL,
0x00001c1fff357424ULL, 0x000fe400078e00ffULL, 0x000000ffff367224ULL, 0x000fe400078e0024ULL,
0x000002a000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff347224ULL, 0x002fe200078e00ffULL,
0x0001711000307802ULL, 0x000fe20000000f00ULL, 0x00001c1fff357424ULL, 0x000fc400078e00ffULL,
0x000000ffff367224ULL, 0x000fe400078e0024ULL, 0x000000ffff217224ULL, 0x004fe400078e0032ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff367224ULL, 0x002fe200078e0024ULL,
0x0001717000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fe400078e00ffULL,
0x00001c1fff357424ULL, 0x000fe400078e00ffULL, 0x000000ffff227224ULL, 0x004fe400078e0032ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff237224ULL, 0x004fe200078e0032ULL,
0xffffea3000007947ULL, 0x000fea000383ffffULL, 0x0180000006027810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000002077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000000600028308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff077807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000207ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000006067812ULL, 0x002fe400078ec0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000207ff7212ULL, 0x000fda000780c0ffULL, 0x0080000006020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0006ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000600027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x006fe400078e0008ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffe8cf006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000004200007348ULL, 0x000fe80003800000ULL, 0x0c00003229297389ULL, 0x0002a200000e0035ULL,
0xfffe8cb00c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff317424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0000003433327389ULL, 0x0002a200000e0035ULL,
0xfffe8c7030007950ULL, 0x000fea0003c3ffffULL, 0x000000013000780cULL, 0x000fe20003f05070ULL,
0x0000003100007348ULL, 0x000fd80003800000ULL, 0x0000000000307806ULL, 0x000fc800040e0100ULL,
0x0000003130327212ULL, 0x000fe200078ec0ffULL, 0x000000ffff307224ULL, 0x000fe400078e0033ULL,
0x00000000ff317424ULL, 0x000fc800078e00ffULL, 0xfffe8c0030007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000004d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ab8ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000b48ULL, 0x0000000000000884ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000013ccULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000013f0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001400ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001420ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000014b0ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000014b8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000014c8ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001680ULL, 0x0000000000017500ULL, 0xff00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018b80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000018b90ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018b90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000019010ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000014b0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000176d0ULL, 0x00000000000176d0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000018b80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000019010ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin_len = 102640;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
