/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x00000000000128f8ULL, 0x0000000000012478ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x00000000000112f0ULL, 0x0000000000000290ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000011580ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000112f000000000ULL, 0x00004c0400000000ULL, 0x0400288080810c00ULL, 0x0000000000004464ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808a0828808081ULL, 0x8508288080990828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x0028808085920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL,
0x0000006800000000ULL, 0x000112f000000000ULL, 0x0000029000000000ULL, 0x00005c0400000000ULL,
0x8082288080850900ULL, 0x0000000000002880ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x000090a000183104ULL, 0x0001051000009670ULL, 0x0001053000010520ULL,
0x00c4290400010540ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002205000023ULL, 0x0500002305000022ULL, 0x0500002305000023ULL,
0x0500001f0500001fULL, 0x0500001f0500001fULL, 0x0500001f0500001fULL, 0x0500001f0500001fULL,
0x0500001f0500001fULL, 0x00c428040500001fULL, 0x000000d0000000b0ULL, 0x0000225000002190ULL,
0x000022f0000022c0ULL, 0x000027b0000026a0ULL, 0x00004d9000004cf0ULL, 0x00004e4000004e20ULL,
0x00005350000051c0ULL, 0x000071b000007190ULL, 0x0000753000007520ULL, 0x00009670000090a0ULL,
0x00009b6000009b20ULL, 0x0000a2600000a230ULL, 0x0000fe300000fe20ULL, 0x0000fe500000fe40ULL,
0x0000fea00000fe80ULL, 0x0000fed00000fec0ULL, 0x0001052000010500ULL, 0x0001057000010530ULL,
0x0001059000010580ULL, 0x00010e8000010df0ULL, 0x00010f4000010ee0ULL, 0x0001101000010fb0ULL,
0x000110d000011070ULL, 0x0001121000011170ULL, 0x02703904000112b0ULL, 0x000000ff00000180ULL,
0x000401000001b600ULL, 0x0000000300000260ULL, 0x003f01000001b608ULL, 0x00000003000002d0ULL,
0x003f01000001b610ULL, 0x00000003000004b0ULL, 0x003f01000001b648ULL, 0x00000002000005c0ULL,
0x003f01000001b668ULL, 0x000000ff000008b0ULL, 0x000401070001b600ULL, 0x000000ff00000a60ULL,
0x000401010001b610ULL, 0x000000ff000013d0ULL, 0x000a010700000000ULL, 0x000000ff00001400ULL,
0x0009010100000020ULL, 0x000000ff00001840ULL, 0x0009010600000020ULL, 0x000000ff00001ab0ULL,
0x0009010a00000020ULL, 0x0000003600001f90ULL, 0x0014010700000000ULL, 0x0000003200002010ULL,
0x0014010600000000ULL, 0x0000003500002070ULL, 0x0005010a0001b608ULL, 0x0000003200002550ULL,
0x0014010a00000000ULL, 0x000000ff00004490ULL, 0x0009010100000020ULL, 0x000000ff000044d0ULL,
0x001301010001b610ULL, 0x000000ff000045f0ULL, 0x0009010600000020ULL, 0x000000ff00004960ULL,
0x0009010a00000020ULL, 0x000000ff00004bb0ULL, 0x000d010700000000ULL, 0x0000003600004c10ULL,
0x0014010600000000ULL, 0x0000003500004c60ULL, 0x0005010a0001b628ULL, 0x00000036000050a0ULL,
0x0014010a00000000ULL, 0x000000ff00006a60ULL, 0x0009010100000020ULL, 0x000000ff00006a90ULL,
0x001301010001b630ULL, 0x000000ff0000c7c0ULL, 0x0005010a0001b600ULL, 0x000000ff0000c9c0ULL,
0x000501010001b600ULL, 0x000000ff0000c9e0ULL, 0x0005010a0001b600ULL, 0x000000ff0000f5e0ULL,
0x0008010a0001b610ULL, 0x000000ff000108a0ULL, 0x000801010001b608ULL, 0x0000002b00010900ULL,
0x003f010a00000020ULL, 0x0000002300010980ULL, 0x003f010a0001b608ULL, 0x0000002300010a10ULL,
0x003f010a00000000ULL, 0x0000003f00010a90ULL, 0x003f010a00000020ULL, 0x0000002300010b20ULL,
0x003f010a0001b628ULL, 0x0000002300010bb0ULL, 0x003f010a00000000ULL, 0x0000000900010c20ULL,
0x003f010a0001b600ULL, 0x0000000900010cb0ULL, 0x003f010a0001b600ULL, 0x0000001300010d30ULL,
0x003f010a0001b610ULL, 0x00141c0400053803ULL, 0x0000ace00000a870ULL, 0x0000caa00000ca00ULL,
0x000c0504000108d0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0058190300000000ULL,
0x0000000f00080a04ULL, 0x0004360400580210ULL, 0x0000000000000008ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x0000000000000000ULL, 0x00000000000000d4ULL, 0x0000000e00000002ULL, 0x00000000000112f0ULL,
0x0000000000000044ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000aaULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000077919ULL, 0x000eae0000002100ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x0000000000087919ULL, 0x000f220000002300ULL, 0x0000000000057919ULL, 0x000f2a0000002200ULL,
0x00000300ff007b82ULL, 0x000f620000000800ULL, 0x00000000000b7919ULL, 0x000f620000002700ULL,
0x0000000000097919ULL, 0x000f620000002600ULL, 0x00000004ff0f7e24ULL, 0x008fe2000f8e00ffULL,
0x00000005ff037819ULL, 0x004fcc0000011607ULL, 0x00001fff03037589ULL, 0x000ea200000e0000ULL,
0x0000000108027824ULL, 0x010fc600078e0205ULL, 0x00001fff08087589ULL, 0x000ee200000e0000ULL,
0x0000008002027824ULL, 0x000fca00078e0207ULL, 0x000000ff0200720cULL, 0x040fe40003f05270ULL,
0x000000030200780cULL, 0x000fe40003f44070ULL, 0x00000000031072caULL, 0x004fd200000e0000ULL,
0x0000000000240947ULL, 0x022fec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01b60006043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001a000007945ULL, 0x000fe80003800000ULL,
0x0000000000602947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7fff000000057882ULL, 0x000fc60000000000ULL,
0x0000000402037c11ULL, 0x000fe2000f8e20ffULL, 0x001fffc000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000030612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000f240000000000ULL, 0x01b60804063f75b2ULL, 0x0043300008000100ULL,
0xfffffffd00e81947ULL, 0x010fea000393ffffULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x001fff8000047882ULL, 0x002fe20000000000ULL,
0x7ffe000000057882ULL, 0x000fd60000000000ULL, 0x00000000030612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000f240000000000ULL, 0x01b61004063f75b2ULL, 0x0043300008000100ULL,
0xfffffffd00e81947ULL, 0x010fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000007f0200780cULL, 0x040fe20003f04070ULL, 0x00008e00ff067b82ULL, 0x000f220000000a00ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x000000010200780cULL, 0x000fe40003f84070ULL,
0x000000ff0800720cULL, 0x008fd00003f65270ULL, 0x0000000000048919ULL, 0x000ee20000008800ULL,
0x0000040000038802ULL, 0x000fc80000000f00ULL, 0x0000065404038816ULL, 0x008fe20000000003ULL,
0xff317217ff048424ULL, 0x000fc800078e00ffULL, 0x0000000402038824ULL, 0x000fca00078e0203ULL,
0x01b4000403008388ULL, 0x0007e20000000800ULL, 0x0000000000382947ULL, 0x010fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000402037c11ULL, 0x008fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fca0000000000ULL,
0x00000000030612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x01b64804063f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x002e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x00cfca0000000000ULL, 0x00000000020612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x01b66804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00008200000e7ab9ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x004fe20000010000ULL,
0x000000040b067825ULL, 0x000fca00078e0006ULL, 0x0000840000077ab9ULL, 0x000fe20000000800ULL,
0x0000000000983947ULL, 0x000fea0003800000ULL, 0x0000000000157919ULL, 0x000ea20000000000ULL,
0x00008800ff047b82ULL, 0x008ee20000000a00ULL, 0x0000000210067899ULL, 0x002fe2000800063fULL,
0x0000001009027824ULL, 0x000fe200078e00ffULL, 0x0000000407047899ULL, 0x000fca000800063fULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x000000040b027c24ULL, 0x000fe2000f8e0202ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x00000006150d7c11ULL, 0x044fe2000f8fe0ffULL,
0x00000010150a7824ULL, 0x000fe200078e00ffULL, 0x0000065405047896ULL, 0x002fe40008000004ULL,
0x000000070d0c7812ULL, 0x040fe200078ec0ffULL, 0x000000020d117836ULL, 0x000fe40000000000ULL,
0x0000000102037824ULL, 0x040fe200078e020dULL, 0x0000000f0c0c7812ULL, 0x000fe200078e7815ULL,
0x0000000102137824ULL, 0x000fe200078e0211ULL, 0x00000007110e7812ULL, 0x000fe200078ec0ffULL,
0x0000010003027825ULL, 0x008fc600078e0004ULL, 0x0000000f0e0e7812ULL, 0x000fe200078e7815ULL,
0x0000010013047825ULL, 0x000fe200078e0004ULL, 0x000000f00a137812ULL, 0x000fc600078ec0ffULL,
0x000000100d0c7824ULL, 0x000fe200078e020cULL, 0x0000001302027210ULL, 0x000fe20007f1e0ffULL,
0x00000010110e7824ULL, 0x000fe200078e020eULL, 0x0000001304047210ULL, 0x000fe40007f3e0ffULL,
0x000000040c0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x000000040e117c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff057224ULL, 0x000fc600008e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e8000b901c4eULL,
0x0000000004117faeULL, 0x0003e2000b901c4eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0001b60004047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x0000000e060d7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x0000007f0d027836ULL, 0x044fe40000000000ULL,
0x000000ff0d037836ULL, 0x008fc60000000000ULL, 0x00000007ff027819ULL, 0x000fe40000011602ULL,
0x00000008ff037819ULL, 0x000fca0000011603ULL, 0x000000a000e48947ULL, 0x000fea0003800000ULL,
0x000000023f047899ULL, 0x002fe20008011610ULL, 0xffffffffff0a7424ULL, 0x000fe200078e00ffULL,
0x0000040000057882ULL, 0x000fe40000000000ULL, 0x01ffffff04047892ULL, 0x000fcc000f8ec03fULL,
0x000000040f117c11ULL, 0x000fc8000f8e08ffULL, 0x000000021100720cULL, 0x000fe20003f06070ULL,
0x00000000000479c3ULL, 0x000e580000008800ULL, 0x00009000ff058b82ULL, 0x000ea20000000800ULL,
0x000000020b048824ULL, 0x000fce00078e00ffULL, 0x00008c00ff068b82ULL, 0x000ee20000000a00ULL,
0x0000065404057896ULL, 0x002fc80008000005ULL, 0x0000000510047291ULL, 0x000fe2000f8e203fULL,
0x0000000504048224ULL, 0x004fc800078e0205ULL, 0x0000000111058824ULL, 0x000fe400078e0204ULL,
0x00000002ff047424ULL, 0x000fe400078e00ffULL, 0x0000000405068825ULL, 0x008fe400078e0006ULL,
0x01b61004ffff79a7ULL, 0x0003e60008500004ULL, 0x0000000e060a8981ULL, 0x0004e2000c1e1900ULL,
0x0000000111057812ULL, 0x000fc400078ec0ffULL, 0xffffffff00047811ULL, 0x002fe400078e08ffULL,
0x000000010500780cULL, 0x000fe20003f05070ULL, 0x0000000110117892ULL, 0x000fe2000f8ec03fULL,
0xffffffffff067424ULL, 0x004fe400078e00ffULL, 0x0000000104057807ULL, 0x000fca0004000000ULL,
0x0000000111057824ULL, 0x000fca00078e0205ULL, 0x000000020500720cULL, 0x000fda0003f06070ULL,
0x00009000ff138b82ULL, 0x000e620000000800ULL, 0x000000020b088824ULL, 0x000fce00078e00ffULL,
0x00008c00ff108b82ULL, 0x000ea20000000a00ULL, 0x0000001308088224ULL, 0x002fc800078e0213ULL,
0x0000000108078824ULL, 0x000fc800078e0205ULL, 0x0000000407108825ULL, 0x004fe400078e0010ULL,
0x0000000000077919ULL, 0x000e620000000000ULL, 0x0000000511047899ULL, 0x000fe2000800063fULL,
0x000000010f087836ULL, 0x000fe20000000000ULL, 0x000000013f067899ULL, 0x000fe20008011610ULL,
0x0000000e10068981ULL, 0x000562000c1e1900ULL, 0x0000000707077899ULL, 0x000fe4000800063fULL,
0x000000030800720cULL, 0x000fe20003f06070ULL, 0x0000000506087291ULL, 0x000fc4000f8e703fULL,
0x000000060f0e7c11ULL, 0x000fe4000f8e10ffULL, 0x0001300008097890ULL, 0x000fe2000fffe03fULL,
0x00000003ff137819ULL, 0x002fe20000011607ULL, 0x00000010072d7824ULL, 0x000fc800078e00ffULL,
0x0000000413157836ULL, 0x000fe20000000000ULL, 0x000000702d2d7812ULL, 0x000fe200078ec0ffULL,
0x0000000c13237836ULL, 0x000fe40000000000ULL, 0x0000000415147c36ULL, 0x000fe40008000000ULL,
0x0000000413127c36ULL, 0x000fe40008000000ULL, 0x0000000814217824ULL, 0x040fe200078e00ffULL,
0x00000007140c7212ULL, 0x080fe200078e3cffULL, 0x0000000423187c36ULL, 0x000fe20008000000ULL,
0x0000000712087212ULL, 0x0c0fe200078e3cffULL, 0x0000000813177836ULL, 0x000fe20000000000ULL,
0xfffffff821217812ULL, 0x000fe200078ee20cULL, 0x0000000812117824ULL, 0x004fe200078e00ffULL,
0x00000007180c7212ULL, 0x0c0fe200078e3cffULL, 0x0000000818197824ULL, 0x000fe200078e00ffULL,
0x0000007f12127812ULL, 0x000fe200078ec0ffULL, 0x0000000417167c36ULL, 0x000fe20008000000ULL,
0xfffffff811207812ULL, 0x000fe200078ee208ULL, 0x0000001813297836ULL, 0x040fe20000000000ULL,
0xfffffff819247812ULL, 0x000fe200078ee20cULL, 0x0000000816117824ULL, 0x040fe200078e00ffULL,
0x0000000716087212ULL, 0x080fe200078e3cffULL, 0x000000400e0c7824ULL, 0x000fe200078e00ffULL,
0x0000007f14147812ULL, 0x000fe200078ec0ffULL, 0x0000001013257836ULL, 0x000fe20000000000ULL,
0xfffffff811227812ULL, 0x000fe200078ee208ULL, 0x00000004291e7c36ULL, 0x000fe20008000000ULL,
0x0000000c0d117248ULL, 0x000fe20007fe0000ULL, 0x00000004251a7c36ULL, 0x000fe20008000000ULL,
0x0000007f16167812ULL, 0x000fe200078ec0ffULL, 0x0000001413277836ULL, 0x000fe20000000000ULL,
0x000000071e0e7212ULL, 0x080fe200078e3cffULL, 0x0000000111117824ULL, 0x000fe200078e0a0cULL,
0x000000071a087212ULL, 0x000fe200078e3cffULL, 0x000000081e1b7824ULL, 0x000fe200078e00ffULL,
0x0000007f18187812ULL, 0x000fe200078ec0ffULL, 0x000000081a197824ULL, 0x000fe200078e00ffULL,
0x0000004011117807ULL, 0x000fe20000000000ULL, 0x00000004271c7c36ULL, 0x000fe20008000000ULL,
0xfffffff81b2a7812ULL, 0x000fe200078ee20eULL, 0x0000001c132b7836ULL, 0x000fe20000000000ULL,
0x0000000411117c48ULL, 0x000fc4000ffe0000ULL, 0xfffffff819267812ULL, 0x000fe200078ee208ULL,
0x000000081c197824ULL, 0x040fe200078e00ffULL, 0x000000071c087212ULL, 0x0c0fe200078e3cffULL,
0x80000004110e7c36ULL, 0x000fe20008000000ULL, 0x0000007f1c1c7812ULL, 0x000fe200078ec0ffULL,
0x00008a00ff107b82ULL, 0x000e620000000a00ULL, 0xfffffff819287812ULL, 0x000fe200078ee208ULL,
0x0000008009087824ULL, 0x000fe200078e00ffULL, 0x0000000e1300720cULL, 0x080fe20003fa6070ULL,
0x000000042b2c7c36ULL, 0x000fe20008000000ULL, 0x0000000e1500720cULL, 0x080fe20003f86070ULL,
0x0001b64805047890ULL, 0x000fe2000fffe03fULL, 0x0000004008097812ULL, 0x000fe200078ef80cULL,
0x000000082c2e7824ULL, 0x040fe200078e00ffULL, 0x0000000e1700720cULL, 0x000fe20003f66070ULL,
0x00000004060a7291ULL, 0x000fe2000f8e203fULL, 0x000000072c197212ULL, 0x000fc400078e3cffULL,
0x0000007f1a1a7812ULL, 0x000fe400078ec0ffULL, 0xfffffff82e0c7812ULL, 0x000fe400078ee219ULL,
0x0000007f1e1e7812ULL, 0x000fe400078ec0ffULL, 0x0000007f2c2c7812ULL, 0x000fe400078ec0ffULL,
0x0000000921217c11ULL, 0x000fe2000f8e20ffULL, 0x000000070a097c24ULL, 0x008fe4000f8e0209ULL,
0x00000001ff0a7424ULL, 0x000fc400078e00ffULL, 0x0000000109137824ULL, 0x040fe400078e0212ULL,
0x0000000109157824ULL, 0x000fe400078e0214ULL, 0x0000008013127825ULL, 0x002fc800078e0010ULL,
0x0000000109177824ULL, 0x000fe200078e0216ULL, 0x0000002d12127210ULL, 0x000fe20007f1e0ffULL,
0x0000008015147825ULL, 0x000fc800078e0010ULL, 0x0000008017167825ULL, 0x000fe200078e0010ULL,
0x0000002d14147210ULL, 0x000fc60007f3e0ffULL, 0x0000000109197824ULL, 0x040fe400078e0218ULL,
0x00000001091d7824ULL, 0x000fe400078e021cULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x0000002d16167210ULL, 0x000fe20007f1e0ffULL, 0x0000008019187825ULL, 0x000fc800078e0010ULL,
0x00000001091b7824ULL, 0x000fe400078e021aULL, 0x000000801d1c7825ULL, 0x000fc800078e0010ULL,
0x00000001091f7824ULL, 0x040fe400078e021eULL, 0x0000000109097824ULL, 0x000fe400078e022cULL,
0x000000ffff157224ULL, 0x000fe200008e0615ULL, 0x0000002d18187210ULL, 0x000fe20007f3e0ffULL,
0x000000801b1a7825ULL, 0x000fc800078e0010ULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x0000002d1c1c7210ULL, 0x000fe20007f1e0ffULL, 0x000000801f1e7825ULL, 0x000fe200078e0010ULL,
0x0000002d1a1a7210ULL, 0x000fc60007f5e0ffULL, 0x0000008009107825ULL, 0x000fe200078e0010ULL,
0x0000000920097c11ULL, 0x000fc6000f8e20ffULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x0000002d1e1e7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e061dULL,
0x0000002d10107210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200010e061bULL,
0x0000000e2300720cULL, 0x080fe20003f46070ULL, 0x000000ffff1f7224ULL, 0x000fe200008e061fULL,
0x0000000e2500720cULL, 0x080fe20003f26070ULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000000e2700720cULL, 0x080fe20003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012097faeULL, 0x0003e2000e901c4eULL, 0x0000000e2900720cULL, 0x000fc40003fa6070ULL,
0x0000000922237c11ULL, 0x000fe2000f8e20ffULL, 0x0000000014217faeULL, 0x0005e2000e101c4eULL,
0x0000000e2b00720cULL, 0x000fe40003f86070ULL, 0x0000000924257c11ULL, 0x000fe2000f8e20ffULL,
0x0000000016237faeULL, 0x0007e2000d901c4eULL, 0x0000000926277c11ULL, 0x000fe4000f8e20ffULL,
0x000000092a297c11ULL, 0x000fe2000f8e20ffULL, 0x0000000018257faeULL, 0x0007e2000d101c4eULL,
0x0000000928137c11ULL, 0x002fe2000f8e20ffULL, 0xff317217ff097424ULL, 0x000fe200078e00ffULL,
0x000000090c157c11ULL, 0x004fe2000f8e20ffULL, 0x000000001a277faeULL, 0x0007e2000c901c4eULL,
0x0000000406097291ULL, 0x000fc6000f8e183fULL, 0x000000001c137faeULL, 0x0007e2000c101c4eULL,
0x000000030f00720cULL, 0x000fc60003f06070ULL, 0x000000001e297faeULL, 0x0007e8000e901c4eULL,
0x0000000010157faeULL, 0x0007e2000e101c4eULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4aULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000200affff79a7ULL, 0x0003e20008500009ULL, 0x00000000001a7805ULL, 0x008fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fc4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0a7224ULL, 0x002fe200078e00ffULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fc4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000005800880947ULL, 0x000fec0003800000ULL, 0x00009000ff1b7b82ULL, 0x000e620000000800ULL,
0x000000020b0e7824ULL, 0x000fe200078e00ffULL, 0x00007610ff6a7816ULL, 0x000fe2000000006aULL,
0xff317217ff097424ULL, 0x000fe200078e00ffULL, 0x00007610ff697816ULL, 0x000fe20000000069ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x00007610ff0c7816ULL, 0x000fe2000000000cULL,
0x0000001b0e0e7224ULL, 0x002fe400078e021bULL, 0x000000ffff1b7224ULL, 0x000fce00078e00ffULL,
0x00000005100a7899ULL, 0x000fc8000800063fULL, 0xffffffc00a0b7892ULL, 0x000fcc000f8ec03fULL,
0x0000000b0f207c11ULL, 0x000fc8000f8e40ffULL, 0x0000000d2000720cULL, 0x000fda0003f06070ULL,
0x00000058003c0947ULL, 0x000fea0003800000ULL, 0x0000008020207836ULL, 0x000fe20000000000ULL,
0x0000000105217812ULL, 0x000fe200078ec0ffULL, 0x000000200a0b7892ULL, 0x000fe2000f8ec03fULL,
0x00000003ff4f7819ULL, 0x000fe20000011607ULL, 0x00008a00ff707b82ULL, 0x000e620000000a00ULL,
0x0000004008337812ULL, 0x000fe200078ef820ULL, 0x000000010f227836ULL, 0x000fe20000000000ULL,
0x000000012100780cULL, 0x000fe20003f05070ULL, 0x0000000b4f687c36ULL, 0x000fe20008000000ULL,
0x000000200d217248ULL, 0x000fe20007fe0000ULL, 0x0000000706337c24ULL, 0x020fe2000f8e0233ULL,
0x0000000104567807ULL, 0x000fe20004000000ULL, 0x000000084f4c7836ULL, 0x000fe20000000000ULL,
0x0000000768677212ULL, 0x000fe200078e3cffULL, 0x0000000121067824ULL, 0x000fe200078e0a20ULL,
0x000000032200720cULL, 0x000fe20003f26070ULL, 0x0000000868207824ULL, 0x040fe200078e00ffULL,
0x0000007f68687812ULL, 0x000fe200078ec0ffULL, 0x0000000b4c647c36ULL, 0x000fc40008000000ULL,
0x000000044f4d7836ULL, 0x040fe20000000000ULL, 0xfffffff820677812ULL, 0x000fe200078ee267ULL,
0x0000000c4f3f7836ULL, 0x040fe20000000000ULL, 0x0000ffff6a207812ULL, 0x000fe200078ec0ffULL,
0x000000144f3d7836ULL, 0x000fe20000000000ULL, 0x0000000764637212ULL, 0x0c0fe200078e3cffULL,
0x0000000864247824ULL, 0x000fe200078e00ffULL, 0x0000888020287816ULL, 0x000fe200000000ffULL,
0x0000000b4d667c36ULL, 0x000fe20008000000ULL, 0x0000007f64647812ULL, 0x000fe200078ec0ffULL,
0x0000000b3f627c36ULL, 0x000fe20008000000ULL, 0xfffffff824637812ULL, 0x000fe200078ee263ULL,
0x8000000028287824ULL, 0x000fe200078e00ffULL, 0x0000000766657212ULL, 0x080fe200078e3cffULL,
0x0000000b3d5e7c36ULL, 0x000fe20008000000ULL, 0x0000000762617212ULL, 0x000fe200078e3cffULL,
0x00002028ff0075a7ULL, 0x000ea20008060049ULL, 0x000000104f3e7836ULL, 0x000fc40000000000ULL,
0x000000184f3c7836ULL, 0x040fe20000000000ULL, 0x000000075e5d7212ULL, 0x080fe200078e3cffULL,
0x0000001c4f377836ULL, 0x000fe40000000000ULL, 0x0000000866227824ULL, 0x040fe200078e00ffULL,
0x0000007f66667812ULL, 0x000fe200078ec0ffULL, 0x0000000862207824ULL, 0x040fe200078e00ffULL,
0x0000007f62627812ULL, 0x000fe200078ec0ffULL, 0x000000085e247824ULL, 0x000fe200078e00ffULL,
0xfffffff822657812ULL, 0x000fe200078ee265ULL, 0x0000000b3e607c36ULL, 0x000fe20008000000ULL,
0xfffffff820617812ULL, 0x000fe200078ee261ULL, 0x0000000105217824ULL, 0x000fe200078e0256ULL,
0xfffffff8245d7812ULL, 0x000fe200078ee25dULL, 0x0000000b3c5c7c36ULL, 0x000fe20008000000ULL,
0x00000007605f7212ULL, 0x080fe200078e3cffULL, 0x00000010074e7824ULL, 0x000fe200078e00ffULL,
0x000000022100720cULL, 0x000fe20003f06070ULL, 0x0000000b375a7c36ULL, 0x000fe20008000000ULL,
0x000000075c5b7212ULL, 0x080fe200078e3cffULL, 0x0000000133257824ULL, 0x000fe200078e0268ULL,
0x000000704e4e7812ULL, 0x000fe200078ec0ffULL, 0x0000000860227824ULL, 0x000fe200078e00ffULL,
0x000000075a587212ULL, 0x000fe200078e3cffULL, 0x000000085c207824ULL, 0x000fc400078e00ffULL,
0x0000008025247825ULL, 0x002fe200078e0070ULL, 0xfffffff8225f7812ULL, 0x000fe400078ee25fULL,
0xfffffff8205b7812ULL, 0x000fe200078ee25bULL, 0x000000085a297824ULL, 0x000fe200078e00ffULL,
0x0000004e24307210ULL, 0x000fe20007f5e0ffULL, 0x0000000133277824ULL, 0x040fe400078e0266ULL,
0x0000000133237824ULL, 0x040fe200078e0264ULL, 0xfffffff829587812ULL, 0x000fe200078ee258ULL,
0x0000000133217824ULL, 0x000fc400078e0262ULL, 0x0000008027267825ULL, 0x000fc800078e0070ULL,
0x0000008023227825ULL, 0x000fc800078e0070ULL, 0x0000008021207825ULL, 0x000fe200078e0070ULL,
0x0000000000083947ULL, 0x004fec0003800000ULL, 0x00002028ff0075a7ULL, 0x000e640008060149ULL,
0x000000ec0084b947ULL, 0x002fea0003800000ULL, 0x0000004e262a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fe200010e0625ULL, 0x0000004e20267210ULL, 0x000fe20007f5e0ffULL,
0x0000000d040a7899ULL, 0x000fe2000800063fULL, 0x0000007f60607812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2b7224ULL, 0x000fe200018e0627ULL, 0x0000004e22287210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff277224ULL, 0x000fe200010e0621ULL, 0x0000007f5e5e7812ULL, 0x000fe200078ec0ffULL,
0x0000000133217824ULL, 0x040fe200078e0260ULL, 0x0000004006067807ULL, 0x000fe20000800000ULL,
0x000000ffff297224ULL, 0x000fe200020e0623ULL, 0x000020000a0a7892ULL, 0x000fe2000f8e0c3fULL,
0x0000000133237824ULL, 0x000fe200078e025eULL, 0x0000000b06067c48ULL, 0x000fe2000ffe0000ULL,
0x0000008021207825ULL, 0x100fe200078e0070ULL, 0x0000007f5c5c7812ULL, 0x000fe200078ec0ffULL,
0x00013000080a7890ULL, 0x000fe2000fffe00aULL, 0x00008c00ff348b82ULL, 0x000e620000000a00ULL,
0x0000008023227825ULL, 0x000fe200078e0070ULL, 0x0000004e20207210ULL, 0x000fe20007f5e0ffULL,
0x0000000506137291ULL, 0x000fe2000f8e203fULL, 0x0000007f5a5a7812ULL, 0x000fe200078ec0ffULL,
0x8000000b06067c36ULL, 0x000fe20008000000ULL, 0x0000004e22227210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff217224ULL, 0x000fe200010e0621ULL, 0x0000000a67397c11ULL, 0x000fe2000f8e20ffULL,
0x0000000133257824ULL, 0x000fe200078e025cULL, 0x000000064f00720cULL, 0x080fe20003f26070ULL,
0x000000ffff237224ULL, 0x000fe200018e0623ULL, 0x000000064d00720cULL, 0x080fe20003f46070ULL,
0x0000008025247825ULL, 0x000fe200078e0070ULL, 0x000000064c00720cULL, 0x080fe20003f66070ULL,
0x00000003040d7899ULL, 0x000fe2000800063fULL, 0x0000000a653b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000133337824ULL, 0x000fe200078e025aULL, 0x0000000a63517c11ULL, 0x000fe2000f8e20ffULL,
0x0001b64813147890ULL, 0x000fe2000fffe03fULL, 0x0000004e24247210ULL, 0x000fe20007f9e0ffULL,
0x0000008033327825ULL, 0x000fe200078e0070ULL, 0x000000063700720cULL, 0x080fe20003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030397faeULL, 0x0005e2000c901c4eULL,
0x000000063f00720cULL, 0x080fe20003f26070ULL, 0x000000ffff257224ULL, 0x000fe200020e0625ULL,
0x000000063c00720cULL, 0x080fe20003f86070ULL, 0x000000002a3b7faeULL, 0x0007e2000d101c4eULL,
0x000000063e00720cULL, 0x080fe20003f46070ULL, 0x00000003100c7899ULL, 0x000fe2000800063fULL,
0x0000000a61537c11ULL, 0x000fe2000f8e20ffULL, 0x0000000028517faeULL, 0x0009e2000d901c4eULL,
0x000000063d00720cULL, 0x000fe20003f66070ULL, 0xffffffffff067424ULL, 0x000fe200078e00ffULL,
0x0000004e32327210ULL, 0x000fe20007fde0ffULL, 0xfffffff00c0c7892ULL, 0x000fe2000f8ec03fULL,
0x0000000a5b317c11ULL, 0x004fe2000f8e20ffULL, 0x0000000026537faeULL, 0x0003e2000c901c4eULL,
0x0000000a58397c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff337224ULL, 0x000fe200030e0633ULL,
0x0000000a5f2b7c11ULL, 0x008fc4000f8e20ffULL, 0x000000560e3b8210ULL, 0x000fe40007ffe005ULL,
0x0000000a5d297c11ULL, 0x010fe2000f8e20ffULL, 0x000000080d0a7892ULL, 0x000fe2000f8e0c3fULL,
0x00000000202b7faeULL, 0x0005e6000d101c4eULL, 0x0000000a14127290ULL, 0x000fe2000fffe03fULL,
0x000000043b268825ULL, 0x002fe200078e0034ULL, 0x0000000022297faeULL, 0x000fe6000d901c4eULL,
0x0000000aff367e24ULL, 0x000fe2000f8e00ffULL, 0x0000000024317faeULL, 0x0003e2000e101c4eULL,
0x0000ffff0c217812ULL, 0x004fc600078ec0ffULL, 0x0000000032397faeULL, 0x0005e2000e901c4eULL,
0x0000ffff69207812ULL, 0x000fe400078ec0ffULL, 0x0000888021547816ULL, 0x000fe200000000ffULL,
0x0000000e26068981ULL, 0x000762000c1e1900ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000888020257816ULL, 0x002fe400000000ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a52ULL,
0x0000000dff327e24ULL, 0x004fe4000f8e00ffULL, 0x0000000cff357e24ULL, 0x000fc4000f8e00ffULL,
0x8000000025257824ULL, 0x000fe400078e00ffULL, 0x8000000054207824ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x008fcc0000000000ULL, 0x00000025320075a7ULL, 0x0002620008000054ULL,
0x00000001ff597819ULL, 0x000fe20000011607ULL, 0x00000005060a7291ULL, 0x000fe4000f8e383fULL,
0x0000000c050c7290ULL, 0x000fe2000fffe03fULL, 0x0000000c59597812ULL, 0x000fc800078ec0ffULL,
0x0000000a59577c10ULL, 0x000fe2000fffe04eULL, 0x01b60820350075a7ULL, 0x000ea40008020145ULL,
0x000000e800349947ULL, 0x006fea0003800000ULL, 0x01b0000057207984ULL, 0x000e620000000800ULL,
0x00000002100a7899ULL, 0x000fe2000800063fULL, 0x0000000807227812ULL, 0x040fe200078ec0ffULL,
0x0000000804087291ULL, 0x000fe2000f8e683fULL, 0x01b2000057577984ULL, 0x000ea20000000800ULL,
0x000000040a0a7892ULL, 0x000fe2000f8ec03fULL, 0x0000000722397812ULL, 0x000fe200078ec807ULL,
0x0001300008087890ULL, 0x000fe2000fffe03fULL, 0x00000007223b7812ULL, 0x000fe200078ef807ULL,
0x0000000d140d7290ULL, 0x000fe2000fffe03fULL, 0x00000001ff287424ULL, 0x000fe200078e00ffULL,
0x0000000a07247c11ULL, 0x000fc8000f8fe0ffULL, 0x00000024393a7212ULL, 0x000fca00078e3cffULL,
0x000000083b557824ULL, 0x000fca00078e023aULL, 0x0000000855307c11ULL, 0x000fe4000f8e20ffULL,
0x000000092000720bULL, 0x002fda0003f3d000ULL, 0x0000000000217806ULL, 0x000fc800008e0100ULL,
0x0000ffff21267812ULL, 0x000fda000782c0ffULL, 0x0000000000e09947ULL, 0x004fea0003800000ULL,
0x000000092000720bULL, 0x000fe20003f34000ULL, 0x000000100600728cULL, 0x000fe2000bf05270ULL,
0x00000020092a7209ULL, 0x000fe40007810000ULL, 0x00000002ff227819ULL, 0x000fc60000011607ULL,
0x8000002a09217221ULL, 0x000fe20000010000ULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x0000000822237836ULL, 0x000fe40000000000ULL, 0x3fb8aa3b21217820ULL, 0x000fe20000410000ULL,
0x00000005100a8291ULL, 0x000fe2000f8e383fULL, 0x0000000000097806ULL, 0x000fc800008e0100ULL,
0x0000ffff09097812ULL, 0x000fe200078e3cffULL, 0x0000002100217308ULL, 0x000e660000000800ULL,
0x0000000926ff7212ULL, 0x000fe4000782c0ffULL, 0x0000000a5909ac10ULL, 0x000fe4000fffe04eULL,
0x00000001ff287807ULL, 0x000fc60000800000ULL, 0x01b4002a0900a388ULL, 0x0005e80000000800ULL,
0x00001f2321237589ULL, 0x002e6400000e0000ULL, 0x8000002a20201221ULL, 0x100fe20000010000ULL,
0x000000210a0a7220ULL, 0x000fe20000410000ULL, 0x00001f2221227589ULL, 0x000ee400000e0000ULL,
0x3fb8aa3b20201820ULL, 0x000fe20000410000ULL, 0x000000ffff097224ULL, 0x004fc600078e002aULL,
0x00000020000b1308ULL, 0x000ea20000000800ULL, 0x000000231b1b7220ULL, 0x082fe20000410000ULL,
0x000000231a1a7220ULL, 0x080fe20000410000ULL, 0x0000002313137220ULL, 0x080fe20000410000ULL,
0x0000002312127220ULL, 0x080fe20000410000ULL, 0x0000002317177220ULL, 0x080fe20000410000ULL,
0x0000002316167220ULL, 0x080fe20000410000ULL, 0x000000232f2f7220ULL, 0x080fe20000410000ULL,
0x000000232e2e7220ULL, 0x080fe20000410000ULL, 0x0000002343437220ULL, 0x080fe20000410000ULL,
0x0000002342427220ULL, 0x080fe20000410000ULL, 0x000000234b4b7220ULL, 0x080fe20000410000ULL,
0x000000234a4a7220ULL, 0x080fe20000410000ULL, 0x0000002347477220ULL, 0x080fe20000410000ULL,
0x0000002346467220ULL, 0x080fe20000410000ULL, 0x000000231f1f7220ULL, 0x080fe20000410000ULL,
0x000000231e1e7220ULL, 0x000fe20000410000ULL, 0x0000002219197220ULL, 0x088fe20000410000ULL,
0x0000002218187220ULL, 0x080fe20000410000ULL, 0x0000002211117220ULL, 0x080fe20000410000ULL,
0x0000002210107220ULL, 0x080fe20000410000ULL, 0x0000002215157220ULL, 0x080fe20000410000ULL,
0x0000002214147220ULL, 0x080fe20000410000ULL, 0x000000222d2d7220ULL, 0x080fe20000410000ULL,
0x000000222c2c7220ULL, 0x080fe20000410000ULL, 0x0000002241417220ULL, 0x080fe20000410000ULL,
0x0000002240407220ULL, 0x080fe20000410000ULL, 0x0000002249497220ULL, 0x080fe20000410000ULL,
0x0000002248487220ULL, 0x080fe20000410000ULL, 0x0000002245457220ULL, 0x080fe20000410000ULL,
0x0000002244447220ULL, 0x080fe20000410000ULL, 0x000000221d1d7220ULL, 0x080fe20000410000ULL,
0x000000221c1c7220ULL, 0x000fe20000410000ULL, 0x0000000b57571220ULL, 0x004fce0000410000ULL,
0x0000000000080947ULL, 0x000fea0003800000ULL, 0x00000025320075a7ULL, 0x000e640008000154ULL,
0x000000e4001c8947ULL, 0x002fea0003800000ULL, 0x000000003030783bULL, 0x000e620000004200ULL,
0x0000000224247836ULL, 0x000fe20000000000ULL, 0x0000000707267812ULL, 0x000fe200078ec0ffULL,
0x0000000506067291ULL, 0x000fe2000f8e583fULL, 0x00000002ff537819ULL, 0x100fe20000011607ULL,
0x000000010400788cULL, 0x000fe2000bf05270ULL, 0x0000002439397212ULL, 0x000fe200078e3cffULL,
0x00000004000a7c82ULL, 0x000fe20008000000ULL, 0x00000004ff247819ULL, 0x000fe20000011607ULL,
0x0000000104047892ULL, 0x000fe2000f8e0c3fULL, 0x00000008266d7812ULL, 0x000fe200078ef807ULL,
0x000000083b347824ULL, 0x000fe200078e0239ULL, 0x0000000bff6b723eULL, 0x000fe200000010ffULL,
0x0000000a570a7221ULL, 0x000fe20000010000ULL, 0x0000000724247812ULL, 0x000fc400078e786dULL,
0x000054106b737816ULL, 0x000fe4000000006bULL, 0x0000991028757816ULL, 0x000fe200000000ffULL,
0x000000086d387824ULL, 0x000fe200078e0224ULL, 0x0000000834207c11ULL, 0x000fe2000f8e20ffULL,
0x00001f53736b7589ULL, 0x000fe200000e0000ULL, 0x000000000000781cULL, 0x000fe40003f6f008ULL,
0x0000000638247c11ULL, 0x000fe4000f8e20ffULL, 0x000000002020783bULL, 0x000ea20000004200ULL,
0x000000ff6aff7812ULL, 0x000fc4000784c0ffULL, 0x000076106a577816ULL, 0x000fe20000000057ULL,
0x011000002424783bULL, 0x000ee20000000200ULL, 0x0000010030527824ULL, 0x042fe200078e00ffULL,
0x0000888030297816ULL, 0x040fe200000000ffULL, 0x0000010031747824ULL, 0x040fe200078e00ffULL,
0x00008880316f7816ULL, 0x000fe400000000ffULL, 0x00000018ff727819ULL, 0x000fe20000011452ULL,
0x0000000853527836ULL, 0x000fe20000000000ULL, 0x00000018ff287819ULL, 0x000fe20000011474ULL,
0x000000ffff747224ULL, 0x000fe200078e0075ULL, 0x0000002900297306ULL, 0x000fe20000202400ULL,
0x00000018ff2b7819ULL, 0x000fe20000011430ULL, 0x00001f52736c7589ULL, 0x00032200000e0000ULL,
0x00000018ff2a7819ULL, 0x000fe20000011431ULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x000000ff7400720cULL, 0x000fe20003f05270ULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011432ULL, 0x0000007200727306ULL, 0x000f220000202400ULL,
0x00000018ff307819ULL, 0x000fc40000011430ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000888032737816ULL, 0x002fe400000000ffULL, 0x00000018ff6e7819ULL, 0x000fe20000011433ULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x00000018ff507819ULL, 0x004fe20000011420ULL,
0x0000006b24248232ULL, 0x088fe40000200000ULL, 0x0000006b26268232ULL, 0x000fc80000200000ULL,
0x0000002800767306ULL, 0x0002a20000202400ULL, 0x0000006c25258232ULL, 0x090fe40000200000ULL,
0x0000006c27278232ULL, 0x000fca0000200000ULL, 0x0000002b002b7306ULL, 0x000fe20000202400ULL,
0x0000541029287816ULL, 0x002fe40000000072ULL, 0x000000803b727811ULL, 0x000fe400078e18ffULL,
0x000054106f297816ULL, 0x004fc60000000076ULL, 0x0000003000747306ULL, 0x000e620000202400ULL,
0x00000100326f7824ULL, 0x040fe400078e00ffULL, 0x0001000032327824ULL, 0x000fe200078e00ffULL,
0x00000028241c723cULL, 0x000fe4000004181cULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000002a002a7306ULL, 0x000fe20000202400ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x000000013a297824ULL, 0x000fe200078e0272ULL, 0x0000541074287816ULL, 0x002fc8000000002bULL,
0x0000003100317306ULL, 0x000e620000202400ULL, 0x0000888033747816ULL, 0x000fe200000000ffULL,
0x0000000139727824ULL, 0x000fe200078e0272ULL, 0x00000008292b7c11ULL, 0x000fca000f8e20ffULL,
0x0000007300307306ULL, 0x0005e20000202400ULL, 0x0000541031297816ULL, 0x002fe2000000002aULL,
0x0000010033317824ULL, 0x000fcc00078e00ffULL, 0x0000006f00757306ULL, 0x0002e20000202400ULL,
0x0001000033337824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x004fe40000011421ULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x000000282444723cULL, 0x000fe20000041844ULL,
0x000000002b28783bULL, 0x000ea20000004200ULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x00000018ff6f7819ULL, 0x002fe40000011422ULL,
0x0000541030307816ULL, 0x008fca0000000075ULL, 0x0000003100317306ULL, 0x000e620000202400ULL,
0x00000018ff757819ULL, 0x000fce0000011423ULL, 0x0000005100517306ULL, 0x000fe20000202400ULL,
0x0000541074317816ULL, 0x002fce0000000031ULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x0000888021747816ULL, 0x000fe200000000ffULL, 0x000000302448723cULL, 0x000fec0000041848ULL,
0x0000003200327306ULL, 0x000e620000202400ULL, 0x00000018ff767819ULL, 0x004fce0000011428ULL,
0x0000003300317306ULL, 0x000ea20000202400ULL, 0x0000541032307816ULL, 0x002fce0000000051ULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x0000888020327816ULL, 0x040fe400000000ffULL,
0x0000541031317816ULL, 0x004fe2000000006eULL, 0x00000100206e7824ULL, 0x000fc800078e00ffULL,
0x0000007600517306ULL, 0x0003e20000202400ULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x000000302440723cULL, 0x000fe80000041840ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000003200327306ULL, 0x000fe20000202400ULL, 0x0000010021317824ULL, 0x040fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe2000001146eULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fc80000011429ULL, 0x0000005000507306ULL, 0x000fe20000202400ULL,
0x00000018ff767819ULL, 0x002fce0000011431ULL, 0x0000003000337306ULL, 0x0003f00000202400ULL,
0x0000007600777306ULL, 0x0004e20000202400ULL, 0x00000018ff307819ULL, 0x002fce0000011421ULL,
0x0000002000317306ULL, 0x0003220000202400ULL, 0x00000018ff767819ULL, 0x004fe4000001142aULL,
0x0000541074217816ULL, 0x008fca0000000077ULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x0000541032207816ULL, 0x002fe40000000033ULL, 0x0000888022747816ULL, 0x000fca00000000ffULL,
0x0000003000307306ULL, 0x000e620000202400ULL, 0x00000020242c723cULL, 0x000fee000004182cULL,
0x0000010022217824ULL, 0x040fe200078e00ffULL, 0x0000541031207816ULL, 0x010fe20000000050ULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x0000888023507816ULL, 0x000fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fc40000011421ULL,
0x0000000872317c11ULL, 0x000fe4000f8e20ffULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000002100777306ULL, 0x0002b00000202400ULL, 0x0000005000507306ULL, 0x000fe20000202400ULL,
0x0000541030217816ULL, 0x002fc40000000073ULL, 0x000000003130783bULL, 0x000e6a0000004200ULL,
0x000000202414723cULL, 0x000fe20000041814ULL, 0x0000006f006f7306ULL, 0x000fec0000202400ULL,
0x0000010023207824ULL, 0x000fc400078e00ffULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x0000007500757306ULL, 0x000fe40000202400ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff237819ULL, 0x000fc80000011423ULL, 0x0000002000737306ULL, 0x0004f00000202400ULL,
0x0000002200227306ULL, 0x000f220000202400ULL, 0x0000541074207816ULL, 0x004fe40000000077ULL,
0x0000000207747811ULL, 0x000fc400078fe0ffULL, 0x0000541050217816ULL, 0x008fc60000000073ULL,
0x0000002300727306ULL, 0x000ea20000202400ULL, 0x0000000774507812ULL, 0x000fe400078e786dULL,
0x00000018ff737819ULL, 0x000fc6000001142bULL, 0x000000086d507824ULL, 0x000fe200078e0250ULL,
0x000000202410723cULL, 0x000fe20000041810ULL, 0x0000006e006e7306ULL, 0x000fe60000202400ULL,
0x0000000650507c11ULL, 0x000fc6000f8e20ffULL, 0x0000541022207816ULL, 0x010fe4000000006fULL,
0x0000541072217816ULL, 0x004fe20000000075ULL, 0x0000007600747306ULL, 0x000fe20000202400ULL,
0x000088802a757816ULL, 0x000fe400000000ffULL, 0x00000018ff727819ULL, 0x002fe40000011430ULL,
0x00000018ff6f7819ULL, 0x000fe20000011431ULL, 0x000000202418723cULL, 0x000fe20000041818ULL,
0x011000005020783bULL, 0x000e620000000200ULL, 0x0000007300737306ULL, 0x000fea0000202400ULL,
0x0000010028257824ULL, 0x040fe200078e00ffULL, 0x0000888028247816ULL, 0x040fe200000000ffULL,
0x0000010029277824ULL, 0x040fe200078e00ffULL, 0x0000888029267816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000002400247306ULL, 0x000fe20000202400ULL, 0x00000018ff297819ULL, 0x000fc40000011429ULL,
0x00000018ff287819ULL, 0x000fca0000011428ULL, 0x0000002500257306ULL, 0x000eb00000202400ULL,
0x0000002600267306ULL, 0x000fe20000202400ULL, 0x0000541024247816ULL, 0x004fce0000000025ULL,
0x0000002700277306ULL, 0x000ea20000202400ULL, 0x0000006b20208232ULL, 0x082fe40000200000ULL,
0x0000006b22228232ULL, 0x000fe40000200000ULL, 0x0000006c21218232ULL, 0x080fe40000200000ULL,
0x0000006c23238232ULL, 0x000fe20000200000ULL, 0x0000002800287306ULL, 0x000fe20000202400ULL,
0x0000541026257816ULL, 0x004fce0000000027ULL, 0x0000002900277306ULL, 0x0002a20000202400ULL,
0x000088802b267816ULL, 0x040fe200000000ffULL, 0x00000024201c723cULL, 0x000fec000004181cULL,
0x0000007500757306ULL, 0x000fe20000202400ULL, 0x000001002b257824ULL, 0x000fe400078e00ffULL,
0x000001002a247824ULL, 0x000fc400078e00ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000002600267306ULL, 0x000fe20000202400ULL,
0x00000018ff297819ULL, 0x002fe4000001142aULL, 0x000001003b2a7811ULL, 0x000fca00078e18ffULL,
0x0000002500777306ULL, 0x0005f00000202400ULL, 0x0000002900297306ULL, 0x000e620000202400ULL,
0x0000541027257816ULL, 0x004fe2000000006eULL, 0x000000013a277824ULL, 0x100fe200078e022aULL,
0x00000018ff6e7819ULL, 0x000fe2000001142bULL, 0x00000001392a7824ULL, 0x000fe200078e022aULL,
0x00008880302b7816ULL, 0x000fc400000000ffULL, 0x0000000827277c11ULL, 0x000fe2000f8e20ffULL,
0x0000002400767306ULL, 0x0005f00000202400ULL, 0x0000006e006e7306ULL, 0x000ee20000202400ULL,
0x0000541028247816ULL, 0x004fc40000000051ULL, 0x0000541029287816ULL, 0x002fe40000000074ULL,
0x00000018ff517819ULL, 0x000fc60000011432ULL, 0x000000242044723cULL, 0x000fe20000041844ULL,
0x0000002b002b7306ULL, 0x000fe20000202400ULL, 0x000054106e297816ULL, 0x008fe20000000073ULL,
0x0000010030737824ULL, 0x000fc800078e00ffULL, 0x0000541075247816ULL, 0x000fe20000000076ULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011433ULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x0000888031757816ULL, 0x000fe200000000ffULL,
0x000000282040723cULL, 0x000fe20000041840ULL, 0x0000541026257816ULL, 0x000fe40000000077ULL,
0x00000018ff737819ULL, 0x000fc60000011473ULL, 0x0000007600747306ULL, 0x000fe20000202400ULL,
0x0000010031297824ULL, 0x040fe200078e00ffULL, 0x000000242048723cULL, 0x000fe20000041848ULL,
0x000000002724783bULL, 0x000e660000004200ULL, 0x00000018ff777819ULL, 0x000fe40000011429ULL,
0x0000007300287306ULL, 0x000ea20000202400ULL, 0x00000018ff297819ULL, 0x000fe20000011430ULL,
0x0001000031307824ULL, 0x000fcc00078e00ffULL, 0x0000007500757306ULL, 0x000fe20000202400ULL,
0x000054102b287816ULL, 0x004fce0000000028ULL, 0x0000007700767306ULL, 0x000ea20000202400ULL,
0x00000018ff2b7819ULL, 0x000fe40000011430ULL, 0x0000888032307816ULL, 0x000fca00000000ffULL,
0x0000002900317306ULL, 0x0004f00000202400ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x0000541075297816ULL, 0x004fe40000000076ULL, 0x000000082a757c11ULL, 0x000fc4000f8e20ffULL,
0x00000018ff6e7819ULL, 0x002fc60000011424ULL, 0x0000002b00767306ULL, 0x000e620000202400ULL,
0x00000028202c723cULL, 0x000fee000004182cULL, 0x0000010032287824ULL, 0x040fe200078e00ffULL,
0x0000003000307306ULL, 0x000fe20000202400ULL, 0x0001000032327824ULL, 0x000fc600078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011428ULL, 0x0000541031287816ULL, 0x008fe40000000072ULL,
0x0000888033727816ULL, 0x040fe200000000ffULL, 0x0000007300317306ULL, 0x000ea20000202400ULL,
0x0000541076297816ULL, 0x002fe4000000006fULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x000000ffff6f7224ULL, 0x000fe400078e0072ULL, 0x0000010033727824ULL, 0x000fc400078e00ffULL,
0x0001000033337824ULL, 0x000fe200078e00ffULL, 0x0000005100517306ULL, 0x000fe20000202400ULL,
0x000000282028723cULL, 0x000fe20000041814ULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x000000007514783bULL, 0x0002e20000004200ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000541030307816ULL, 0x004fe40000000031ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x00000018ff737819ULL, 0x000fc40000011425ULL, 0x00000018ff757819ULL, 0x002fca0000011426ULL,
0x0000007200727306ULL, 0x000e700000202400ULL, 0x0000003200327306ULL, 0x000ea20000202400ULL,
0x000054106f317816ULL, 0x002fce0000000072ULL, 0x0000003300337306ULL, 0x000e620000202400ULL,
0x0000000407727811ULL, 0x000fe400078fe0ffULL, 0x00000018ff6f7819ULL, 0x000fe20000011427ULL,
0x000000302010723cULL, 0x000fe80000041810ULL, 0x0000006e006e7306ULL, 0x000fe60000202400ULL,
0x0000000772307812ULL, 0x000fca00078e786dULL, 0x0000007500727306ULL, 0x0009e20000202400ULL,
0x000000086d317824ULL, 0x000fe200078e0230ULL, 0x0000541032307816ULL, 0x004fe20000000051ULL,
0x0000010025327824ULL, 0x000fc600078e00ffULL, 0x0000000631517c11ULL, 0x000fe4000f8e20ffULL,
0x0000007300737306ULL, 0x000fe20000202400ULL, 0x0000541033317816ULL, 0x002fe40000000074ULL,
0x0000888025747816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x010fe40000011432ULL, 0x00000018ff337819ULL, 0x008fe20000011414ULL,
0x000000302020723cULL, 0x000fe20000041818ULL, 0x011000005118783bULL, 0x000e620000000200ULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x00000018ff257819ULL, 0x000fc40000011425ULL,
0x00000018ff327819ULL, 0x000fe40000011415ULL, 0x0000010024317824ULL, 0x040fe200078e00ffULL,
0x0000888024307816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x0000007500757306ULL, 0x000fe40000202400ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000018ff247819ULL, 0x000fc80000011424ULL, 0x0000003000307306ULL, 0x000ff00000202400ULL,
0x0000003100317306ULL, 0x000eb00000202400ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x0000541030307816ULL, 0x004fe20000000031ULL, 0x0000006b18188232ULL, 0x082fe20000200000ULL,
0x0000541074317816ULL, 0x000fe20000000075ULL, 0x0000006b1a1a8232ULL, 0x000fc80000200000ULL,
0x0000002400757306ULL, 0x000e620000202400ULL, 0x0000006c19198232ULL, 0x080fe40000200000ULL,
0x0000006c1b1b8232ULL, 0x000fca0000200000ULL, 0x0000002500747306ULL, 0x000ea40000202400ULL,
0x00000030181c723cULL, 0x000fe2000004181cULL, 0x0000541075247816ULL, 0x002fca000000006eULL,
0x0000003300337306ULL, 0x000fe20000202400ULL, 0x00008880266e7816ULL, 0x000fe400000000ffULL,
0x00000018ff317819ULL, 0x000fe40000011416ULL, 0x00000018ff307819ULL, 0x000fe40000011417ULL,
0x0000541074257816ULL, 0x004fe20000000073ULL, 0x0000010026737824ULL, 0x040fe200078e00ffULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x0001000026267824ULL, 0x000fc600078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011473ULL, 0x000000241844723cULL, 0x000fe60000041844ULL,
0x0000003200327306ULL, 0x000fe80000202400ULL, 0x0000010027247824ULL, 0x040fe200078e00ffULL,
0x0000888027257816ULL, 0x000fc600000000ffULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x00000018ff747819ULL, 0x000fe40000011424ULL, 0x00000018ff247819ULL, 0x000fe20000011426ULL,
0x0001000027267824ULL, 0x000fc800078e00ffULL, 0x0000002500257306ULL, 0x000fe20000202400ULL,
0x00000018ff757819ULL, 0x000fe40000011426ULL, 0x0000888014267816ULL, 0x000fca00000000ffULL,
0x0000007400747306ULL, 0x000e700000202400ULL, 0x0000002400277306ULL, 0x0005e20000202400ULL,
0x0000541025257816ULL, 0x002fce0000000074ULL, 0x0000002600267306ULL, 0x000fe20000202400ULL,
0x000054106e247816ULL, 0x004fe20000000073ULL, 0x0000010014737824ULL, 0x040fe400078e00ffULL,
0x0001000014147824ULL, 0x000fc800078e00ffULL, 0x000000241848723cULL, 0x000fe20000041848ULL,
0x00000075006e7306ULL, 0x0002a20000202400ULL, 0x00000018ff147819ULL, 0x000fca0000011414ULL,
0x00000018ff257819ULL, 0x000fe20000011473ULL, 0x0000010015737824ULL, 0x040fe200078e00ffULL,
0x0000888015247816ULL, 0x040fe200000000ffULL, 0x0000001400747306ULL, 0x0007e60000202400ULL,
0x00000018ff757819ULL, 0x002fe20000011473ULL, 0x0001000015737824ULL, 0x000fe200078e00ffULL,
0x000054106e157816ULL, 0x004fc6000000006fULL, 0x0000002500257306ULL, 0x000e620000202400ULL,
0x0000541027147816ULL, 0x008fe40000000072ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x000001803b6f7811ULL, 0x000fe400078e18ffULL, 0x0000888016727816ULL, 0x000fe200000000ffULL,
0x0000002400247306ULL, 0x000fe20000202400ULL, 0x000000141840723cULL, 0x000fe20000041840ULL,
0x000000013a6e7824ULL, 0x000fc400078e026fULL, 0x00000001396f7824ULL, 0x000fc800078e026fULL,
0x0000007500757306ULL, 0x000ea20000202400ULL, 0x0000541026147816ULL, 0x002fe40000000025ULL,
0x000000086e257c11ULL, 0x000fca000f8e20ffULL, 0x0000007300737306ULL, 0x000e620000202400ULL,
0x0000541024157816ULL, 0x004fe20000000075ULL, 0x0000010016757824ULL, 0x040fe200078e00ffULL,
0x000000002524783bULL, 0x000ea20000004200ULL, 0x0001000016167824ULL, 0x000fc800078e00ffULL,
0x0000003100317306ULL, 0x000fe20000202400ULL, 0x00000018ff777819ULL, 0x000fe20000011475ULL,
0x00000014182c723cULL, 0x000fe2000004182cULL, 0x0000888017757816ULL, 0x000fe400000000ffULL,
0x00000018ff167819ULL, 0x000fc60000011416ULL, 0x0000003000307306ULL, 0x000fe20000202400ULL,
0x0000010017147824ULL, 0x000fe200078e00ffULL, 0x0000541073157816ULL, 0x002fe20000000032ULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x0000000607327811ULL, 0x000fe400078fe0ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x0000000732327812ULL, 0x000fca00078e786dULL,
0x0000001400767306ULL, 0x0003e20000202400ULL, 0x000000086d6d7824ULL, 0x000fca00078e0232ULL,
0x000000066d6d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000013f067899ULL, 0x000fe20008011610ULL,
0x0000007700777306ULL, 0x000ee20000202400ULL, 0x0000541074147816ULL, 0x002fe40000000033ULL,
0x00000018ff737819ULL, 0x004fe20000011424ULL, 0x0000010025327824ULL, 0x000fc800078e00ffULL,
0x000000141828723cULL, 0x000fe20000041828ULL, 0x0000007500757306ULL, 0x000ff00000202400ULL,
0x0000001600747306ULL, 0x0006700000202400ULL, 0x0000001700157306ULL, 0x0005220000202400ULL,
0x0000541072167816ULL, 0x008fc40000000077ULL, 0x00000018ff727819ULL, 0x000fe40000011425ULL,
0x0000541074147816ULL, 0x002fe20000000031ULL, 0x0000010024317824ULL, 0x040fe200078e00ffULL,
0x0000541075177816ULL, 0x004fe20000000076ULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x00000018ff767819ULL, 0x000fe40000011432ULL, 0x00000018ff777819ULL, 0x000fe40000011431ULL,
0x0000541015157816ULL, 0x010fe20000000030ULL, 0x000000161810723cULL, 0x000fe20000041810ULL,
0x0000888024307816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x0000888025317816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x000000141820723cULL, 0x000fe20000041820ULL,
0x011000006d18783bULL, 0x000e620000000200ULL, 0x00000018ff247819ULL, 0x000fc40000011424ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x000000086f167c11ULL, 0x000fe2000f8e20ffULL,
0x0000003100317306ULL, 0x000fe20000202400ULL, 0x00000018ff757819ULL, 0x000fe20000011426ULL,
0x0000000506087291ULL, 0x000fe2000f8e703fULL, 0x00000018ff747819ULL, 0x000fe40000011427ULL,
0x000000001614783bULL, 0x000ea60000004200ULL, 0x0000002400247306ULL, 0x000ef00000202400ULL,
0x0000002500257306ULL, 0x000f220000202400ULL, 0x0000541024247816ULL, 0x008fce0000000073ULL,
0x0000007600767306ULL, 0x000ee20000202400ULL, 0x0000541025257816ULL, 0x010fce0000000072ULL,
0x0000007500757306ULL, 0x000fe20000202400ULL, 0x0000006b18188232ULL, 0x082fe40000200000ULL,
0x0000006b1a1a8232ULL, 0x000fe20000200000ULL, 0x00008880266b7816ULL, 0x040fe200000000ffULL,
0x0000006c19198232ULL, 0x080fe20000200000ULL, 0x0000541031317816ULL, 0x008fe20000000076ULL,
0x0000006c1b1b8232ULL, 0x000fe40000200000ULL, 0x00000100266c7824ULL, 0x040fe200078e00ffULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x000000ff69ff7812ULL, 0x000fc4000780c0ffULL, 0x00000018ff327819ULL, 0x004fe20000011414ULL,
0x000000241844723cULL, 0x000fe20000041844ULL, 0x00000018ff337819ULL, 0x000fe40000011415ULL,
0x0000006b006b7306ULL, 0x000fe20000202400ULL, 0x0000888015767816ULL, 0x000fc600000000ffULL,
0x00000018ff247819ULL, 0x000fe2000001146cULL, 0x00000100276c7824ULL, 0x040fe200078e00ffULL,
0x0000888027257816ULL, 0x040fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x0000003000307306ULL, 0x000fe40000202400ULL, 0x00000018ff727819ULL, 0x000fe4000001146cULL,
0x00000018ff6c7819ULL, 0x000fe40000011426ULL, 0x00000018ff277819ULL, 0x000fc40000011427ULL,
0x0000002400247306ULL, 0x000e620000202400ULL, 0x0000888014267816ULL, 0x000fce00000000ffULL,
0x0000002500257306ULL, 0x000fe20000202400ULL, 0x000054106b247816ULL, 0x002fce0000000024ULL,
0x0000007200727306ULL, 0x000e620000202400ULL, 0x00000100146b7824ULL, 0x040fe400078e00ffULL,
0x0001000014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001146bULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000541025257816ULL, 0x002fca0000000072ULL, 0x0000002700277306ULL, 0x000fe40000202400ULL,
0x000000241848723cULL, 0x000fec0000041848ULL, 0x0000007700777306ULL, 0x000e620000202400ULL,
0x0000010015247824ULL, 0x040fe400078e00ffULL, 0x0001000015157824ULL, 0x000fca00078e00ffULL,
0x0000001400257306ULL, 0x0005e20000202400ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000541030307816ULL, 0x002fca0000000077ULL, 0x0000001500727306ULL, 0x0003e20000202400ULL,
0x000054106c147816ULL, 0x004fe40000000075ULL, 0x00000018ff777819ULL, 0x000fe40000011424ULL,
0x0000888016247816ULL, 0x040fe200000000ffULL, 0x00000030181c723cULL, 0x000fe4000004181cULL,
0x0000002600267306ULL, 0x000fe20000202400ULL, 0x0000541027157816ULL, 0x002fe20000000074ULL,
0x0000010016277824ULL, 0x000fc600078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011416ULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x000000141840723cULL, 0x000fe20000041840ULL, 0x0000006b00797306ULL, 0x0003e20000202400ULL,
0x00000018ff307819ULL, 0x000fe40000011417ULL, 0x00000018ff6c7819ULL, 0x000fc60000011416ULL,
0x0000010017147824ULL, 0x040fe400078e00ffULL, 0x0000007600767306ULL, 0x000fe20000202400ULL,
0x00008880176b7816ULL, 0x042fe200000000ffULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fc80000011414ULL, 0x00000018ff757819ULL, 0x000fe20000011417ULL,
0x0000007700777306ULL, 0x000e700000202400ULL, 0x0000003200327306ULL, 0x000fe20000202400ULL,
0x0000541076157816ULL, 0x002fce0000000077ULL, 0x0000002400247306ULL, 0x000ff00000202400ULL,
0x0000002700737306ULL, 0x000e700000202400ULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x0000541024247816ULL, 0x002fce0000000073ULL, 0x0000001400747306ULL, 0x0002b00000202400ULL,
0x0000003300337306ULL, 0x000ee20000202400ULL, 0x0000541026147816ULL, 0x002fe40000000079ULL,
0x000000060f267c11ULL, 0x000fca000f8e10ffULL, 0x0000003100317306ULL, 0x000fe20000202400ULL,
0x00000014182c723cULL, 0x000fee000004182cULL, 0x0000003000307306ULL, 0x000fe20000202400ULL,
0x0000541025147816ULL, 0x000fe40000000032ULL, 0x000054106b257816ULL, 0x004fe20000000074ULL,
0x00000001ff6b7424ULL, 0x000fe200078e00ffULL, 0x0000541072157816ULL, 0x008fc60000000033ULL,
0x0000006c006c7306ULL, 0x000e620000202400ULL, 0x0000206bffff79a7ULL, 0x0005e20008500009ULL,
0x000000241810723cULL, 0x000fec0000041810ULL, 0x0000007500277306ULL, 0x000ee20000202400ULL,
0x000000141814723cULL, 0x000fe20000041828ULL, 0x01b6106bffff79a7ULL, 0x0005e20008500013ULL,
0x000054106c247816ULL, 0x002fc40000000031ULL, 0x00007610696c7816ULL, 0x000fe4000000006cULL,
0x00000001ff69b807ULL, 0x000fe40000000000ULL, 0x0000541027257816ULL, 0x008fce0000000030ULL,
0x000000241818723cULL, 0x000fee0000041820ULL, 0x0000008026207811ULL, 0x000fe200078e30ffULL,
0x000000ffff217224ULL, 0x000fe400078e0005ULL, 0x0000000105057824ULL, 0x000fe200078e0256ULL,
0x0000000d2000720cULL, 0x000fc40003f26070ULL, 0x00000001ff207807ULL, 0x000fc80001000000ULL,
0x00007610206a7816ULL, 0x000fce000000006aULL, 0x0000002800581947ULL, 0x004fea0003800000ULL,
0x0000000100057824ULL, 0x000fe200078e020fULL, 0x0000000d0a047899ULL, 0x000fe2000800063fULL,
0x8000000020207824ULL, 0x000fe400078e00ffULL, 0x0000000121567824ULL, 0x000fe200078e0256ULL,
0x0000000605227c11ULL, 0x000fe2000f8e10ffULL, 0x00002020ff0075a7ULL, 0x0002a600080c0049ULL,
0x0000000156247812ULL, 0x000fe200078ec0ffULL, 0x0000004022217824ULL, 0x000fc400078e00ffULL,
0x0000000105227836ULL, 0x000fe20000000000ULL, 0x000000012400780cULL, 0x000fe40003f05070ULL,
0x0000004008237812ULL, 0x000fe400078ef821ULL, 0x0000000104057807ULL, 0x000fe40004000000ULL,
0x000000032200720cULL, 0x000fe20003f06070ULL, 0x0000000706257c24ULL, 0x020fe2000f8e0223ULL,
0x000000210d067248ULL, 0x000fe20007fe0000ULL, 0x0000000156057824ULL, 0x000fc400078e0205ULL,
0x0000000164277824ULL, 0x000fe400078e0225ULL, 0x0000000106067824ULL, 0x000fe400078e0a21ULL,
0x0000000168217824ULL, 0x100fe400078e0225ULL, 0x0000000166237824ULL, 0x000fe200078e0225ULL,
0x0000004006067807ULL, 0x000fe20000000000ULL, 0x0000008021207825ULL, 0x002fc600078e0070ULL,
0x0000000b06067c48ULL, 0x000fe2000ffe0000ULL, 0x0000000162297824ULL, 0x100fe200078e0225ULL,
0x0000004e20207210ULL, 0x000fe20007f1e0ffULL, 0x00000001602b7824ULL, 0x100fe400078e0225ULL,
0x000000015e317824ULL, 0x100fe400078e0225ULL, 0x000000015c337824ULL, 0x100fe400078e0225ULL,
0x000000015a737824ULL, 0x000fe400078e0225ULL, 0x0000008027247825ULL, 0x000fc800078e0070ULL,
0x8000000b06067c36ULL, 0x000fe20008000000ULL, 0x00002000040b7892ULL, 0x000fe2000f8ec03fULL,
0x000000ffff217224ULL, 0x000fe200000e0621ULL, 0x0000004e24247210ULL, 0x000fe20007f1e0ffULL,
0x0000008029267825ULL, 0x100fe200078e0070ULL, 0x00013000080b7890ULL, 0x000fe2000fffe00bULL,
0x000000064f00720cULL, 0x000fe40003fa6070ULL, 0x0000008023227825ULL, 0x100fe200078e0070ULL,
0x0000004e26267210ULL, 0x000fe40007f7e0ffULL, 0x0000000b67677c11ULL, 0x000fe2000f8e20ffULL,
0x000000802b287825ULL, 0x000fe200078e0070ULL, 0x0000004e22227210ULL, 0x000fc40007f3e0ffULL,
0x0000000b65657c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff257224ULL, 0x000fe200000e0625ULL,
0x0000004e28287210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff237224ULL, 0x000fe200008e0623ULL,
0x000000064d00720cULL, 0x080fe20003f86070ULL, 0x000000ffff277224ULL, 0x000fe200018e0627ULL,
0x000000064c00720cULL, 0x080fe20003f46070ULL, 0x000000ffff297224ULL, 0x000fe200000e0629ULL,
0x000000063f00720cULL, 0x080fe20003f26070ULL, 0x0000008031307825ULL, 0x000fe200078e0070ULL,
0x000000063e00720cULL, 0x000fc40003f66070ULL, 0x000000020500720cULL, 0x000fe20003f06070ULL,
0x00000080332a7825ULL, 0x000fc800078e0070ULL, 0x0000008073707825ULL, 0x000fe200078e0070ULL,
0x0000000000146947ULL, 0x004fee0003800000ULL, 0x000000ff57ff7812ULL, 0x000fc800078cc0ffULL,
0x00000001ff327807ULL, 0x000fca0003000000ULL, 0x8000000032327824ULL, 0x000fc800078e00ffULL,
0x00002032ff0075a7ULL, 0x000e6400080c0149ULL, 0x000000c0003ce947ULL, 0x002fea0003800000ULL,
0x00008c00ff328b82ULL, 0x000e620000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020677faeULL, 0x0005e2000e901c4eULL, 0x0000000b63637c11ULL, 0x000fe2000f8e20ffULL,
0x000000030a0d7899ULL, 0x000fe2000800063fULL, 0x0000004e2a2a7210ULL, 0x000fe20007fde0ffULL,
0x0000000022657faeULL, 0x0007e2000e101c4eULL, 0x0000004e30307210ULL, 0x000fe20007f9e0ffULL,
0x000000080d0d7892ULL, 0x000fe2000f8ec03fULL, 0x000000063d00720cULL, 0x080fe20003fa6070ULL,
0x0000000024637faeULL, 0x0009e2000d101c4eULL, 0x000000063700720cULL, 0x080fe20003f46070ULL,
0x000000ffff317224ULL, 0x000fe200020e0631ULL, 0x000000063c00720cULL, 0x000fe20003f86070ULL,
0x000000ffff2b7224ULL, 0x000fe200030e062bULL, 0x0000004e70207210ULL, 0x004fe20007fde0ffULL,
0x0001b6480c0d7890ULL, 0x000fe2000fffe00dULL, 0x0000000b61617c11ULL, 0x000fe2000f8e20ffULL,
0x000000010e238824ULL, 0x008fe200078e0205ULL, 0x0000000b5f5f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff217224ULL, 0x000fe200030e0671ULL, 0x0000000b5d5d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000026617faeULL, 0x0005e2000c901c4eULL, 0x0000000b5b5b7c11ULL, 0x000fe2000f8e20ffULL,
0xffffffffff067424ULL, 0x000fe200078e00ffULL, 0x0000ffff69697812ULL, 0x000fe200078ec0ffULL,
0x0000000423328825ULL, 0x002fe200078e0032ULL, 0x0000000b58237c11ULL, 0x000fe2000f8e20ffULL,
0x00000000285f7faeULL, 0x0005e2000d901c4eULL, 0x0000888069257816ULL, 0x010fc600000000ffULL,
0x00000000305d7faeULL, 0x0005e8000e901c4eULL, 0x000000002a5b7faeULL, 0x0005e8000e101c4eULL,
0x0000000020237faeULL, 0x0005e2000d101c4eULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000e32068981ULL, 0x000562000c1e1900ULL, 0x8000000054547824ULL, 0x000fe400078e00ffULL,
0x8000000025257824ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a4dULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000025360075a7ULL, 0x0002620008000054ULL,
0x00000006100b7899ULL, 0x000fc8000800063fULL, 0xffffff800b0b7892ULL, 0x000fc8000f8ec03fULL,
0x00000100050b7890ULL, 0x000fcc000fffe00bULL, 0x0000000b59227c10ULL, 0x000fe2000fffe04eULL,
0x01b62854350075a7ULL, 0x000ee40008020145ULL, 0x000000bc009c9947ULL, 0x00afea0003800000ULL,
0x01b0000022207984ULL, 0x004e620000000800ULL, 0x0000200004047892ULL, 0x000fe2000f8e0c3fULL,
0x00000001ff587424ULL, 0x000fe400078e00ffULL, 0x01b2000022547984ULL, 0x0004a20000000800ULL,
0x00013000080b7890ULL, 0x000fcc000fffe004ULL, 0x0000000b554c7c11ULL, 0x000fe4000f8e20ffULL,
0x000000092000720bULL, 0x002fda0003f3d000ULL, 0x0000000000217806ULL, 0x000fc800008e0100ULL,
0x0000ffff21237812ULL, 0x000fda000782c0ffULL, 0x0000000000dc9947ULL, 0x004fea0003800000ULL,
0x000000092000720bULL, 0x000fe20003f34000ULL, 0x0000000210047891ULL, 0x000fe2000f8ff83fULL,
0x0000002009247209ULL, 0x000fc60007810000ULL, 0x000000100400728cULL, 0x000fe4000bf05270ULL,
0x8000002409217221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b21217820ULL, 0x000fe20000410000ULL,
0x000000000000781cULL, 0x000fe40003f4f008ULL, 0x0000000000097806ULL, 0x000fe400008e0100ULL,
0x0000000510048291ULL, 0x000fe2000f8e383fULL, 0x0000002100217308ULL, 0x000e620000000800ULL,
0x0000ffff09227812ULL, 0x000fc800078e3cffULL, 0x0000002223ff7212ULL, 0x000fc6000782c0ffULL,
0x000000045959ac10ULL, 0x000fe4000fffe04eULL, 0x00000001ff587807ULL, 0x000fc60000800000ULL,
0x01b400245900a388ULL, 0x000fe20000000800ULL, 0x000000210a0a7220ULL, 0x002fc60000410000ULL,
0x00001f5321097589ULL, 0x000e6200000e0000ULL, 0x8000002420221221ULL, 0x000fc60000010000ULL,
0x00001f5221207589ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b22221820ULL, 0x000fc80000410000ULL,
0x00000022000b1308ULL, 0x000ee20000000800ULL, 0x000000091c1c7220ULL, 0x082fe20000410000ULL,
0x000000091d1d7220ULL, 0x080fe20000410000ULL, 0x0000000944447220ULL, 0x080fe20000410000ULL,
0x0000000945457220ULL, 0x080fe20000410000ULL, 0x0000000948487220ULL, 0x080fe20000410000ULL,
0x0000000949497220ULL, 0x080fe20000410000ULL, 0x0000000940407220ULL, 0x080fe20000410000ULL,
0x0000000941417220ULL, 0x080fe20000410000ULL, 0x000000092c2c7220ULL, 0x080fe20000410000ULL,
0x000000092d2d7220ULL, 0x080fe20000410000ULL, 0x0000000914147220ULL, 0x080fe20000410000ULL,
0x0000000915157220ULL, 0x080fe20000410000ULL, 0x0000000910107220ULL, 0x080fe20000410000ULL,
0x0000000911117220ULL, 0x080fe20000410000ULL, 0x0000000918187220ULL, 0x080fe20000410000ULL,
0x0000000919197220ULL, 0x000fe20000410000ULL, 0x000000201e1e7220ULL, 0x084fe20000410000ULL,
0x000000201f1f7220ULL, 0x080fe20000410000ULL, 0x0000002046467220ULL, 0x080fe20000410000ULL,
0x0000002047477220ULL, 0x080fe20000410000ULL, 0x000000204a4a7220ULL, 0x080fe20000410000ULL,
0x000000204b4b7220ULL, 0x080fe20000410000ULL, 0x0000002042427220ULL, 0x080fe20000410000ULL,
0x0000002043437220ULL, 0x080fe20000410000ULL, 0x000000202e2e7220ULL, 0x080fe20000410000ULL,
0x000000202f2f7220ULL, 0x080fe20000410000ULL, 0x0000002016167220ULL, 0x080fe20000410000ULL,
0x0000002017177220ULL, 0x080fe20000410000ULL, 0x0000002012127220ULL, 0x080fe20000410000ULL,
0x0000002013137220ULL, 0x080fe20000410000ULL, 0x000000201a1a7220ULL, 0x080fe20000410000ULL,
0x000000201b1b7220ULL, 0x000fe20000410000ULL, 0x000000ffff097224ULL, 0x000fc400078e0024ULL,
0x000000540b541220ULL, 0x008fce0000410000ULL, 0x0000000000080947ULL, 0x000fea0003800000ULL,
0x00000025360075a7ULL, 0x000e640008000154ULL, 0x000000b800b08947ULL, 0x002fea0003800000ULL,
0x000000004c4c783bULL, 0x000e620000004200ULL, 0x0000000a10047899ULL, 0x000fe2000800063fULL,
0x000000803b207811ULL, 0x040fe200078e18ffULL, 0x000000010a00788cULL, 0x000fe2000bf05270ULL,
0x000001003b3b7811ULL, 0x000fe200078e18ffULL, 0xfffff80004047892ULL, 0x000fe2000f8ec03fULL,
0x0000000bff5e723eULL, 0x000fe200000010ffULL, 0x000000013a217824ULL, 0x100fe200078e0220ULL,
0x0000991058587816ULL, 0x000fe200000000ffULL, 0x0000000405047290ULL, 0x000fe2000fffe03fULL,
0x0000000139207824ULL, 0x040fe200078e0220ULL, 0x000054105e777816ULL, 0x000fe2000000005eULL,
0x000000013a3a7824ULL, 0x100fe200078e023bULL, 0x000000ff5800720cULL, 0x000fe20003f05270ULL,
0x0000000139397824ULL, 0x000fe200078e023bULL, 0x0000000438387c11ULL, 0x000fe2000f8e20ffULL,
0x00001f5377537589ULL, 0x000fe200000e0000ULL, 0x0000000b3a287c11ULL, 0x000fe2000f8e20ffULL,
0x0000000a540a7221ULL, 0x000fe20000010000ULL, 0x0000000b39307c11ULL, 0x000fc4000f8e20ffULL,
0x012000003838783bULL, 0x000ea20000000200ULL, 0x0000000b34347c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b6f6f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000003030783bULL, 0x000ee20000004200ULL,
0x0000000b213c7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b20207c11ULL, 0x000fe2000f8e20ffULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x000000000000781cULL, 0x000fe20003f2f008ULL,
0x000000010a047892ULL, 0x000fc4000f80c03fULL, 0x000000003c3c783bULL, 0x000fe80000004200ULL,
0x000000002020783bULL, 0x000fe20000004200ULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x000001004c247824ULL, 0x042fe200078e00ffULL, 0x000088804c597816ULL, 0x000fe200000000ffULL,
0x000001004d567824ULL, 0x040fe200078e00ffULL, 0x000088804d5d7816ULL, 0x000fe200000000ffULL,
0x000000002828783bULL, 0x000fe20000004200ULL, 0x00000018ff5c7819ULL, 0x000fc40000011424ULL,
0x0000000b6e247c11ULL, 0x000fe2000f8e20ffULL, 0x0000005900597306ULL, 0x000fe20000202400ULL,
0x00000018ff6e7819ULL, 0x000fe40000011456ULL, 0x00001f5277567589ULL, 0x000e6200000e0000ULL,
0x00000018ff627819ULL, 0x000fe2000001144cULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe2000001144dULL, 0x000000002424783bULL, 0x000e620000004200ULL,
0x0000005c005c7306ULL, 0x000f220000202400ULL, 0x00000018ff5a7819ULL, 0x000fc4000001144eULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000005338388232ULL, 0x084fe20000200000ULL,
0x00000018ff5b7819ULL, 0x000fe2000001144fULL, 0x000000533a3a8232ULL, 0x000fe40000200000ULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x00000018ff767819ULL, 0x008fe40000011432ULL,
0x00000018ff5e7819ULL, 0x000fe40000011431ULL, 0x00000018ff757819ULL, 0x010fc40000011434ULL,
0x0000541059587816ULL, 0x000fe2000000005cULL, 0x0000006e006e7306ULL, 0x000ea20000202400ULL,
0x00000018ff637819ULL, 0x000fe20000011435ULL, 0x0000005639398232ULL, 0x082fe20000200000ULL,
0x00000018ff747819ULL, 0x000fe20000011436ULL, 0x000000563b3b8232ULL, 0x000fe20000200000ULL,
0x00000018ff737819ULL, 0x000fc60000011437ULL, 0x0000006200627306ULL, 0x000fe20000202400ULL,
0x000088803c7d7816ULL, 0x000fe400000000ffULL, 0x00000018ff717819ULL, 0x000fe4000001143dULL,
0x00000018ff727819ULL, 0x000fe4000001143cULL, 0x000054105d597816ULL, 0x004fe2000000006eULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x00000018ff707819ULL, 0x000fe4000001143eULL,
0x00000018ff697819ULL, 0x000fc40000011420ULL, 0x00000018ff687819ULL, 0x000fe20000011421ULL,
0x00000058381c723cULL, 0x000fe2000004181cULL, 0x00000018ff6a7819ULL, 0x000fe2000001143fULL,
0x0000005a005a7306ULL, 0x000fe20000202400ULL, 0x00000018ff677819ULL, 0x000fe40000011422ULL,
0x00000018ff667819ULL, 0x000fe40000011423ULL, 0x000100004d587824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011433ULL, 0x0000004c004d7306ULL, 0x000e620000202400ULL,
0x00000018ff657819ULL, 0x000fc40000011429ULL, 0x00000018ff597819ULL, 0x000fe40000011458ULL,
0x000088804e587816ULL, 0x000fe400000000ffULL, 0x00000018ff647819ULL, 0x000fe20000011428ULL,
0x00000059006e7306ULL, 0x0004e20000202400ULL, 0x00000018ff607819ULL, 0x000fe4000001142bULL,
0x00000018ff617819ULL, 0x000fe4000001142aULL, 0x00000018ff527819ULL, 0x000fc40000011424ULL,
0x000054104d4c7816ULL, 0x002fe20000000062ULL, 0x000001004e4d7824ULL, 0x040fe200078e00ffULL,
0x0000005800587306ULL, 0x000fe20000202400ULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x004fe40000011425ULL, 0x00000018ff627819ULL, 0x000fe4000001144dULL,
0x000054106e4d7816ULL, 0x008fe40000000055ULL, 0x0000006200557306ULL, 0x0003e20000202400ULL,
0x000088804f6e7816ULL, 0x000fc400000000ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000004c3844723cULL, 0x000fe20000041844ULL, 0x00000018ff5f7819ULL, 0x000fe40000011430ULL,
0x0000005b005b7306ULL, 0x000fe80000202400ULL, 0x000001004f4c7824ULL, 0x040fe400078e00ffULL,
0x000100004f4f7824ULL, 0x000fc400078e00ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e006eULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000004e00777306ULL, 0x000ea20000202400ULL,
0x00000018ff627819ULL, 0x002fce000001144fULL, 0x0000004c006e7306ULL, 0x0003e20000202400ULL,
0x00005410775a7816ULL, 0x004fce000000005aULL, 0x0000004d004d7306ULL, 0x000ea20000202400ULL,
0x00005410584c7816ULL, 0x002fe40000000055ULL, 0x000088803e777816ULL, 0x000fe400000000ffULL,
0x00000018ff557819ULL, 0x000fc60000011426ULL, 0x0000006200587306ULL, 0x0002e20000202400ULL,
0x000054104d4d7816ULL, 0x004fce000000006eULL, 0x0000007500757306ULL, 0x000fe20000202400ULL,
0x00008880346e7816ULL, 0x000fe400000000ffULL, 0x00000018ff627819ULL, 0x002fe20000011427ULL,
0x0000004c384c723cULL, 0x000fe20000041848ULL, 0x00005410585b7816ULL, 0x008fe2000000005bULL,
0x0000010034587824ULL, 0x040fe400078e00ffULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x000000006f48783bULL, 0x0002a20000004200ULL, 0x0001000034347824ULL, 0x000fc400078e00ffULL,
0x0000005a3840723cULL, 0x000fe60000041840ULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000006300637306ULL, 0x000fe20000202400ULL, 0x00008880356f7816ULL, 0x042fe400000000ffULL,
0x00000018ff5a7819ULL, 0x000fe20000011458ULL, 0x0000010035587824ULL, 0x040fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc400078e00ffULL, 0x0000005a005b7306ULL, 0x000e660000202400ULL,
0x00000018ff357819ULL, 0x000fca0000011435ULL, 0x0000003400347306ULL, 0x000ee20000202400ULL,
0x000054106e5a7816ULL, 0x002fce000000005bULL, 0x00000076005d7306ULL, 0x0003e20000202400ULL,
0x0000541034347816ULL, 0x008fce0000000075ULL, 0x00000035006e7306ULL, 0x000ee20000202400ULL,
0x00000018ff767819ULL, 0x002fe40000011458ULL, 0x0000888037757816ULL, 0x000fe400000000ffULL,
0x00000018ff587819ULL, 0x004fc60000011448ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x000054106e357816ULL, 0x008fce0000000063ULL, 0x0000007600767306ULL, 0x000e620000202400ULL,
0x0000010036637824ULL, 0x000fe200078e00ffULL, 0x000000343814723cULL, 0x000fec0000041814ULL,
0x0000007500757306ULL, 0x000fe20000202400ULL, 0x00000018ff347819ULL, 0x000fe20000011463ULL,
0x0000010037637824ULL, 0x000fe200078e00ffULL, 0x000054106f5b7816ULL, 0x002fca0000000076ULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x00008880366f7816ULL, 0x040fe200000000ffULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe40000011463ULL,
0x00000018ff637819ULL, 0x000fe2000001144bULL, 0x0000005a382c723cULL, 0x000fe4000004182cULL,
0x0000006f006e7306ULL, 0x0003ea0000202400ULL, 0x00000018ff5b7819ULL, 0x000fc40000011449ULL,
0x00000018ff5a7819ULL, 0x000fe2000001144aULL, 0x0000003400357306ULL, 0x000ea20000202400ULL,
0x00000018ff6f7819ULL, 0x002fe20000011436ULL, 0x0001000037367824ULL, 0x000fca00078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000007600767306ULL, 0x000e620000202400ULL,
0x000054106e347816ULL, 0x004fce0000000035ULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x000088803f6e7816ULL, 0x000fe400000000ffULL, 0x0000541075357816ULL, 0x002fca0000000076ULL,
0x0000006f00377306ULL, 0x000fe20000202400ULL, 0x000088803d767816ULL, 0x040fe200000000ffULL,
0x000000343810723cULL, 0x000fec0000041810ULL, 0x0000003600367306ULL, 0x000e620000202400ULL,
0x000001003c347824ULL, 0x000fe400078e00ffULL, 0x000001003d357824ULL, 0x000fca00078e00ffULL,
0x0000007d007d7306ULL, 0x000fe20000202400ULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe40000011435ULL, 0x0000541036357816ULL, 0x002fe40000000073ULL,
0x0000003400787306ULL, 0x0002a20000202400ULL, 0x00000018ff3c7819ULL, 0x000fce000001143cULL,
0x0000007600767306ULL, 0x000fe20000202400ULL, 0x0000541037347816ULL, 0x002fce0000000074ULL,
0x000000343818723cULL, 0x000fe20000041818ULL, 0x012000005034783bULL, 0x000e620000000200ULL,
0x0000007b007b7306ULL, 0x000eea0000202400ULL, 0x000001003e387824ULL, 0x040fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe2000001143dULL, 0x000001003f397824ULL, 0x040fe200078e00ffULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x00000100203b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fc4000001143eULL, 0x0000003800747306ULL, 0x0005e20000202400ULL,
0x00008880203d7816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000003900757306ULL, 0x0007e20000202400ULL,
0x000054107d387816ULL, 0x004fe40000000078ULL, 0x0000888029787816ULL, 0x000fca00000000ffULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x0000541076397816ULL, 0x008fe4000000007bULL,
0x0000888028767816ULL, 0x000fe200000000ffULL, 0x0000005334348232ULL, 0x002fc80000200000ULL,
0x0000003c00797306ULL, 0x000e620000202400ULL, 0x0000005336368232ULL, 0x000fe40000200000ULL,
0x0000005635358232ULL, 0x080fe40000200000ULL, 0x0000005637378232ULL, 0x000fc60000200000ULL,
0x0000003a003a7306ULL, 0x000ea80000202400ULL, 0x00000038341c723cULL, 0x000fe8000004181cULL,
0x0000003e006f7306ULL, 0x0007e60000202400ULL, 0x0000010021387824ULL, 0x000fc400078e00ffULL,
0x0000010022397824ULL, 0x000fc600078e00ffULL, 0x0000003b00507306ULL, 0x000fe20000202400ULL,
0x00008880213e7816ULL, 0x048fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011438ULL, 0x0000888022387816ULL, 0x040fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x00000020003c7306ULL, 0x0003e20000202400ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff227819ULL, 0x000fca0000011422ULL, 0x00000021003b7306ULL, 0x0005e20000202400ULL,
0x0000541079207816ULL, 0x002fce0000000072ULL, 0x0000007700777306ULL, 0x000fe20000202400ULL,
0x000054103a217816ULL, 0x004fe40000000071ULL, 0x00008880233a7816ULL, 0x000fca00000000ffULL,
0x0000006e006e7306ULL, 0x000e620000202400ULL, 0x000000203444723cULL, 0x000fee0000041844ULL,
0x0000010023207824ULL, 0x040fe200078e00ffULL, 0x0000007000707306ULL, 0x000fe20000202400ULL,
0x0001000023237824ULL, 0x000fc600078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x000054106e217816ULL, 0x002fe20000000075ULL, 0x00000100286e7824ULL, 0x040fe200078e00ffULL,
0x00000020007d7306ULL, 0x0003e20000202400ULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x0001000028287824ULL, 0x000fe400078e00ffULL, 0x00000018ff6e7819ULL, 0x000fc6000001146eULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000006a006a7306ULL, 0x000fe20000202400ULL,
0x0000541077207816ULL, 0x002fce0000000074ULL, 0x0000003f003f7306ULL, 0x000e620000202400ULL,
0x00000020344c723cULL, 0x000fee000004184cULL, 0x0000010029207824ULL, 0x040fe200078e00ffULL,
0x0000003d003d7306ULL, 0x000fe20000202400ULL, 0x0001000029297824ULL, 0x000fc600078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x000054103f217816ULL, 0x002fe2000000006aULL,
0x000001002a6a7824ULL, 0x000fe200078e00ffULL, 0x0000002000797306ULL, 0x0003e20000202400ULL,
0x00000018ff297819ULL, 0x000fc60000011429ULL, 0x00000018ff6a7819ULL, 0x000fc8000001146aULL,
0x0000003e003e7306ULL, 0x000fe20000202400ULL, 0x000054106f207816ULL, 0x002fe40000000070ULL,
0x000088802b707816ULL, 0x000fca00000000ffULL, 0x0000007300737306ULL, 0x000e620000202400ULL,
0x000000203440723cULL, 0x000fee0000041840ULL, 0x000001002b207824ULL, 0x040fe200078e00ffULL,
0x0000006900697306ULL, 0x000fe20000202400ULL, 0x000100002b2b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x000054103e217816ULL, 0x002fe40000000073ULL,
0x0000002000757306ULL, 0x0003e20000202400ULL, 0x00000018ff2b7819ULL, 0x000fce000001142bULL,
0x0000006800687306ULL, 0x000ea20000202400ULL, 0x000054103d207816ULL, 0x002fce0000000050ULL,
0x00000020342c723cULL, 0x000fe2000004182cULL, 0x0000003800387306ULL, 0x000fec0000202400ULL,
0x0000010031207824ULL, 0x000fe200078e00ffULL, 0x000054103b217816ULL, 0x004fe20000000068ULL,
0x0000003900397306ULL, 0x000fe20000202400ULL, 0x00008880333b7816ULL, 0x000fc400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000888026687816ULL, 0x000fc600000000ffULL,
0x0000002000717306ULL, 0x0003f00000202400ULL, 0x0000003a003a7306ULL, 0x000ea20000202400ULL,
0x000054103c207816ULL, 0x002fce0000000069ULL, 0x000000203414723cULL, 0x000fe20000041814ULL,
0x0000006700677306ULL, 0x000fec0000202400ULL, 0x0000010033207824ULL, 0x040fe200078e00ffULL,
0x000054103a217816ULL, 0x004fe2000000007dULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x0001000033337824ULL, 0x000fc400078e00ffULL, 0x00000018ff207819ULL, 0x000fc60000011420ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000002200227306ULL, 0x000ff00000202400ULL,
0x0000002300237306ULL, 0x000e700000202400ULL, 0x00000020003c7306ULL, 0x0005f00000202400ULL,
0x0000002900747306ULL, 0x0007e20000202400ULL, 0x0000541038207816ULL, 0x004fce0000000039ULL,
0x000000203410723cULL, 0x000fe20000041810ULL, 0x0000003300397306ULL, 0x000fe20000202400ULL,
0x0000010030297824ULL, 0x008fca00078e00ffULL, 0x0000010025217824ULL, 0x040fe200078e00ffULL,
0x0000888025207816ULL, 0x040fe200000000ffULL, 0x0000006e007b7306ULL, 0x0005e20000202400ULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe40000011421ULL, 0x0000541023217816ULL, 0x002fe40000000066ULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000002000337306ULL, 0x0003e20000202400ULL,
0x000088802a6e7816ULL, 0x044fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x0000888027667816ULL, 0x000fc800000000ffULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000002900737306ULL, 0x0005e20000202400ULL, 0x0000541022207816ULL, 0x002fce0000000067ULL,
0x000000203434723cULL, 0x000fe20000041818ULL, 0x012000005120783bULL, 0x0002e20000000200ULL,
0x0000010032297824ULL, 0x004fe200078e00ffULL, 0x0000006400647306ULL, 0x000fe80000202400ULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0000010026187824ULL, 0x000fe400078e00ffULL,
0x0000010027197824ULL, 0x040fe200078e00ffULL, 0x0000006500657306ULL, 0x000ea20000202400ULL,
0x00000100481a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x002fc4000001141aULL,
0x0000002800777306ULL, 0x0003220000202400ULL, 0x00000018ff507819ULL, 0x000fe40000011426ULL,
0x0000888048267816ULL, 0x040fe200000000ffULL, 0x0001000048487824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000541074657816ULL, 0x004fe20000000065ULL,
0x0000006a00727306ULL, 0x0005e20000202400ULL, 0x0000888030287816ULL, 0x042fe200000000ffULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fc40000011448ULL,
0x0000541077647816ULL, 0x010fc60000000064ULL, 0x0000002b006f7306ULL, 0x0003e20000202400ULL,
0x00008880316a7816ULL, 0x044fe200000000ffULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000005320208232ULL, 0x008fc80000200000ULL,
0x00000029003d7306ULL, 0x0005e20000202400ULL, 0x00000018ff2b7819ULL, 0x002fe20000011431ULL,
0x0000010024317824ULL, 0x040fe400078e00ffULL, 0x0000005322228232ULL, 0x000fe40000200000ULL,
0x0000005621218232ULL, 0x080fe40000200000ULL, 0x0000005623238232ULL, 0x000fe20000200000ULL,
0x0000006e003f7306ULL, 0x000fe20000202400ULL, 0x0000888024297816ULL, 0x044fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fc60000011431ULL,
0x000000642044723cULL, 0x000fe20000041844ULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000007000707306ULL, 0x000e6a0000202400ULL, 0x0000010049657824ULL, 0x000fc600078e00ffULL,
0x0000002a006e7306ULL, 0x0005f00000202400ULL, 0x0000006100617306ULL, 0x000ee20000202400ULL,
0x00008880322a7816ULL, 0x044fe200000000ffULL, 0x0001000032327824ULL, 0x000fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000006000607306ULL, 0x000eb00000202400ULL,
0x0000002400317306ULL, 0x0009f00000202400ULL, 0x00000032003e7306ULL, 0x000fe20000202400ULL,
0x0000888049247816ULL, 0x050fe200000000ffULL, 0x0001000049497824ULL, 0x000fcc00078e00ffULL,
0x0000002500327306ULL, 0x0003f00000202400ULL, 0x0000002400647306ULL, 0x0009e20000202400ULL,
0x0000541070257816ULL, 0x002fce0000000075ULL, 0x0000002800287306ULL, 0x000e620000202400ULL,
0x000054103f247816ULL, 0x010fe40000000072ULL, 0x00000018ff3f7819ULL, 0x000fca0000011465ULL,
0x0000006a006a7306ULL, 0x000f220000202400ULL, 0x00000024204c723cULL, 0x000fee000004184cULL,
0x000054106e247816ULL, 0x008fe20000000061ULL, 0x0000005f005f7306ULL, 0x000fe20000202400ULL,
0x000054106f257816ULL, 0x004fce0000000060ULL, 0x0000007600767306ULL, 0x000fe20000202400ULL,
0x000000242040723cULL, 0x000fee0000041840ULL, 0x0000007800787306ULL, 0x000fe20000202400ULL,
0x0000541028247816ULL, 0x002fe40000000073ULL, 0x000054106a257816ULL, 0x010fc40000000071ULL,
0x00000018ff287819ULL, 0x000fc60000011449ULL, 0x0000003000307306ULL, 0x000e640000202400ULL,
0x00000024202c723cULL, 0x000fec000004182cULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x000088804a257816ULL, 0x000fe400000000ffULL, 0x0000541030247816ULL, 0x002fca000000005fULL,
0x0000002b002b7306ULL, 0x000e620000202400ULL, 0x000000ffff307224ULL, 0x000fce00078e0025ULL,
0x0000003b003b7306ULL, 0x000ea20000202400ULL, 0x000054102b257816ULL, 0x002fce000000005eULL,
0x0000001800677306ULL, 0x0003e20000202400ULL, 0x000000242014723cULL, 0x000fe20000041814ULL,
0x000054103b2b7816ULL, 0x004fcc000000003cULL, 0x0000001900697306ULL, 0x0005e20000202400ULL,
0x0000541076187816ULL, 0x002fe2000000007bULL, 0x000001004a257824ULL, 0x000fe200078e00ffULL,
0x000054103e247816ULL, 0x000fe2000000005dULL, 0x000100004a4a7824ULL, 0x000fc800078e00ffULL,
0x0000005c005c7306ULL, 0x000e620000202400ULL, 0x0000541078197816ULL, 0x004fe40000000079ULL,
0x00000018ff3b7819ULL, 0x000fca0000011425ULL, 0x0000002a002a7306ULL, 0x000ea20000202400ULL,
0x00000018201c723cULL, 0x000fe2000004181cULL, 0x012000006d18783bULL, 0x000ee20000000200ULL,
0x0000206bffff79a7ULL, 0x0009e20008500009ULL, 0x0000541039257816ULL, 0x002fc8000000005cULL,
0x0000005200527306ULL, 0x000e620000202400ULL, 0x01b6306bffff79a7ULL, 0x0009e40008500013ULL,
0x000000242034723cULL, 0x000fe20000041834ULL, 0x000054102a2a7816ULL, 0x004fc8000000003dULL,
0x0000005900597306ULL, 0x000ea60000202400ULL, 0x0000002a2010723cULL, 0x000fe20000041810ULL,
0x0000541031527816ULL, 0x002fc80000000052ULL, 0x0000006200627306ULL, 0x000fe40000202400ULL,
0x000001004b217824ULL, 0x040fe200078e00ffULL, 0x000088804b2a7816ULL, 0x040fe200000000ffULL,
0x000100004b237824ULL, 0x000fc800078e00ffULL, 0x0000002700277306ULL, 0x000e620000202400ULL,
0x00000018ff227819ULL, 0x000fe40000011421ULL, 0x00000018ff217819ULL, 0x000fe4000001144aULL,
0x00000018ff247819ULL, 0x000fc60000011423ULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x0000005318188232ULL, 0x088fe40000200000ULL, 0x000000531a1a8232ULL, 0x000fe20000200000ULL,
0x0000541032537816ULL, 0x004fe20000000059ULL, 0x0000005619198232ULL, 0x080fe20000200000ULL,
0x0000541027237816ULL, 0x002fe40000000062ULL, 0x0000005800587306ULL, 0x000fe20000202400ULL,
0x000000561b1b8232ULL, 0x000fe20000200000ULL, 0x000000ff6cff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff6c9807ULL, 0x000fe40000000000ULL, 0x0000005b005b7306ULL, 0x000fe20000202400ULL,
0x000000521844723cULL, 0x000fe20000041844ULL, 0x000000ff6cff7812ULL, 0x000fe4000780c0ffULL,
0x000000ff57ff7812ULL, 0x000fe4000782c0ffULL, 0x00000001ff6ca807ULL, 0x000fe40000000000ULL,
0x0000002900297306ULL, 0x000fe20000202400ULL, 0x00000001ff6a7807ULL, 0x000fce0004800000ULL,
0x0000003800387306ULL, 0x000e700000202400ULL, 0x0000003a003a7306ULL, 0x000ea20000202400ULL,
0x0000541029387816ULL, 0x002fce0000000038ULL, 0x0000006800687306ULL, 0x000e620000202400ULL,
0x0000541033397816ULL, 0x004fce000000003aULL, 0x0000006600667306ULL, 0x000ea20000202400ULL,
0x00000038181c723cULL, 0x000fe2000004181cULL, 0x0000541068687816ULL, 0x002fcc0000000067ULL,
0x0000005000507306ULL, 0x000fe20000202400ULL, 0x0000541066697816ULL, 0x004fce0000000069ULL,
0x0000002600267306ULL, 0x000ff00000202400ULL, 0x0000005100517306ULL, 0x000e700000202400ULL,
0x0000003f003f7306ULL, 0x000ea20000202400ULL, 0x0000541026267816ULL, 0x002fce0000000051ULL,
0x0000004800617306ULL, 0x0002e20000202400ULL, 0x0000541064277816ULL, 0x004fce000000003fULL,
0x0000002800287306ULL, 0x000ea20000202400ULL, 0x000000681848723cULL, 0x002fe2000004184cULL,
0x0000541061587816ULL, 0x008fcc0000000058ULL, 0x0000003000307306ULL, 0x000fe20000202400ULL,
0x00000026182c723cULL, 0x000fe2000004182cULL, 0x000076106c697816ULL, 0x000fe40000000069ULL,
0x0000541028597816ULL, 0x004fc8000000005bULL, 0x0000003b002b7306ULL, 0x000e660000202400ULL,
0x000000581814723cULL, 0x000fea0000041814ULL, 0x0000002a00207306ULL, 0x000fe20000202400ULL,
0x0000541030307816ULL, 0x002fce000000002bULL, 0x0000002200257306ULL, 0x0002b00000202400ULL,
0x0000005a005a7306ULL, 0x000fe20000202400ULL, 0x0000541050227816ULL, 0x002fe40000000055ULL,
0x0000541020317816ULL, 0x004fca0000000025ULL, 0x0000006300637306ULL, 0x000fe20000202400ULL,
0x000000221840723cULL, 0x000fec0000041840ULL, 0x000000301810723cULL, 0x000fe20000041810ULL,
0x0000002100217306ULL, 0x000e700000202400ULL, 0x0000002400247306ULL, 0x000ea20000202400ULL,
0x00005410215a7816ULL, 0x002fc4000000005aULL, 0x00005410245b7816ULL, 0x004fce0000000063ULL,
0x0000005a1818723cULL, 0x010fde0000041834ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x00000001000f7824ULL, 0x000fe200078e020fULL, 0x000000ff0cff7812ULL, 0x000fc8000780c0ffULL,
0x000000030f00720cULL, 0x000fe40003f26070ULL, 0x00000001ff0c7807ULL, 0x000fd60000000000ULL,
0xffffffa4009c9947ULL, 0x020fea000383ffffULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0001b00005047890ULL, 0x000fe4000fffe03fULL, 0x0000000106077899ULL, 0x000fe2000800063fULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000410087291ULL, 0x000fe4000f8e383fULL,
0x0000000207077892ULL, 0x000fc8000f8e0c3fULL, 0x00000008ff077e24ULL, 0x000fe2000f8e00ffULL,
0x0000000107077892ULL, 0x000fc8000f8ef810ULL, 0x0000000407077291ULL, 0x000fcc000f8e383fULL,
0x00000007ff0f7e24ULL, 0x000fe4000f8e00ffULL, 0x0000001002047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x100fe40000011602ULL, 0x00000002ff207819ULL, 0x000fe40000011602ULL,
0x00000070040c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c050d7812ULL, 0x000fe400078ec0ffULL,
0x000002000c047810ULL, 0x000fc40007ffe007ULL, 0x000000080d087c10ULL, 0x140fe4000fffe00cULL,
0x000000070d077c10ULL, 0x040fe2000fffe00cULL, 0x000000010d057824ULL, 0x000fe400078e0204ULL,
0x0000000908007388ULL, 0x000fe80000000800ULL, 0x0000000a05007388ULL, 0x0003e20000000800ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000002000c057810ULL, 0x002fc40007ffe00fULL,
0x00000008020c7811ULL, 0x000fc600078ff0ffULL, 0x000000010d057824ULL, 0x000fe200078e0205ULL,
0x0000000007077984ULL, 0x000e6a0000000800ULL, 0x0000000005057984ULL, 0x000ea20000000800ULL,
0x0000000907047209ULL, 0x002fca0007810000ULL, 0x0000000904067221ULL, 0x020fe20000010100ULL,
0x8000000407077221ULL, 0x000fc60000010000ULL, 0x3fb8aa3b060b7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b07077820ULL, 0x000fe20000410000ULL, 0x0000000000067919ULL, 0x000e660000002500ULL,
0x0000000700087308ULL, 0x000eb00000000800ULL, 0x0000000b000b7308ULL, 0x000ee20000000800ULL,
0x0000000805087220ULL, 0x004fe20000410000ULL, 0x00001f200b097589ULL, 0x008ea600000e0000ULL,
0x0000000a0b0a7223ULL, 0x000fe20000010008ULL, 0x00001f0c0b0d7589ULL, 0x000ee200000e0000ULL,
0x000000030600720cULL, 0x002fe20003f06070ULL, 0x0000001c091c7220ULL, 0x044fe20000410000ULL,
0x0000001d091d7220ULL, 0x040fe20000410000ULL, 0x0000004409447220ULL, 0x040fe20000410000ULL,
0x0000004509457220ULL, 0x040fe20000410000ULL, 0x0000004809487220ULL, 0x040fe20000410000ULL,
0x0000004909497220ULL, 0x040fe20000410000ULL, 0x0000004009407220ULL, 0x040fe20000410000ULL,
0x0000004109417220ULL, 0x040fe20000410000ULL, 0x0000002c092c7220ULL, 0x040fe20000410000ULL,
0x0000002d092d7220ULL, 0x040fe20000410000ULL, 0x0000001409147220ULL, 0x040fe20000410000ULL,
0x0000001509157220ULL, 0x040fe20000410000ULL, 0x0000001009107220ULL, 0x040fe20000410000ULL,
0x0000001109117220ULL, 0x040fe20000410000ULL, 0x0000001809187220ULL, 0x040fe20000410000ULL,
0x0000001909197220ULL, 0x000fe20000410000ULL, 0x0000001e0d1e7220ULL, 0x048fe20000410000ULL,
0x0000001f0d1f7220ULL, 0x040fe20000410000ULL, 0x000000460d467220ULL, 0x040fe20000410000ULL,
0x000000470d477220ULL, 0x040fe20000410000ULL, 0x0000004a0d4a7220ULL, 0x040fe20000410000ULL,
0x0000004b0d4b7220ULL, 0x040fe20000410000ULL, 0x000000420d427220ULL, 0x040fe20000410000ULL,
0x000000430d437220ULL, 0x040fe20000410000ULL, 0x0000002e0d2e7220ULL, 0x040fe20000410000ULL,
0x0000002f0d2f7220ULL, 0x040fe20000410000ULL, 0x000000160d167220ULL, 0x040fe20000410000ULL,
0x000000170d177220ULL, 0x040fe20000410000ULL, 0x000000120d127220ULL, 0x040fe20000410000ULL,
0x000000130d137220ULL, 0x040fe20000410000ULL, 0x0000001a0d1a7220ULL, 0x040fe20000410000ULL,
0x0000001b0d1b7220ULL, 0x000fe20000410000ULL, 0x0000000000d80947ULL, 0x000fec0003800000ULL,
0x018000000a027836ULL, 0x000fe20000000000ULL, 0x000000c000007945ULL, 0x000fe80003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000745000057802ULL, 0x000fce0000000f00ULL,
0x0000009c00a87944ULL, 0x000fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e0007ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000a00037308ULL, 0x000e640000001000ULL,
0xbf8000000a027423ULL, 0x002fc80000000003ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000203037223ULL, 0x000fce0000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009400ff087b82ULL, 0x000ea40000000a00ULL, 0x0000000e08087981ULL, 0x004ea2000c1e9900ULL,
0x0000000000027919ULL, 0x000ee40000000000ULL, 0x00000002ff207819ULL, 0x008fe40000011602ULL,
0x00000008020c7811ULL, 0x000fe200078ff0ffULL, 0x0000000308037220ULL, 0x004fca0000410000ULL,
0x00001f2003057589ULL, 0x000ea800000e0000ULL, 0x00001f0c03077589ULL, 0x000ee200000e0000ULL,
0x000000051c1c7220ULL, 0x084fe20000410000ULL, 0x000000051d1d7220ULL, 0x080fe20000410000ULL,
0x0000000544447220ULL, 0x080fe20000410000ULL, 0x0000000545457220ULL, 0x080fe20000410000ULL,
0x0000000548487220ULL, 0x080fe20000410000ULL, 0x0000000549497220ULL, 0x080fe20000410000ULL,
0x0000000540407220ULL, 0x080fe20000410000ULL, 0x0000000541417220ULL, 0x080fe20000410000ULL,
0x000000052c2c7220ULL, 0x080fe20000410000ULL, 0x000000052d2d7220ULL, 0x080fe20000410000ULL,
0x0000000514147220ULL, 0x080fe20000410000ULL, 0x0000000515157220ULL, 0x080fe20000410000ULL,
0x0000000510107220ULL, 0x080fe20000410000ULL, 0x0000000511117220ULL, 0x080fe20000410000ULL,
0x0000000518187220ULL, 0x080fe20000410000ULL, 0x0000000519197220ULL, 0x000fe20000410000ULL,
0x000000071e1e7220ULL, 0x088fe20000410000ULL, 0x000000071f1f7220ULL, 0x080fe20000410000ULL,
0x0000000746467220ULL, 0x080fe20000410000ULL, 0x0000000747477220ULL, 0x080fe20000410000ULL,
0x000000074a4a7220ULL, 0x080fe20000410000ULL, 0x000000074b4b7220ULL, 0x080fe20000410000ULL,
0x0000000742427220ULL, 0x080fe20000410000ULL, 0x0000000743437220ULL, 0x080fe20000410000ULL,
0x000000072e2e7220ULL, 0x080fe20000410000ULL, 0x000000072f2f7220ULL, 0x080fe20000410000ULL,
0x0000000716167220ULL, 0x080fe20000410000ULL, 0x0000000717177220ULL, 0x080fe20000410000ULL,
0x0000000712127220ULL, 0x080fe20000410000ULL, 0x0000000713137220ULL, 0x080fe20000410000ULL,
0x000000071a1a7220ULL, 0x080fe20000410000ULL, 0x000000071b1b7220ULL, 0x000fce0000410000ULL,
0x0000000202037812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000511077291ULL, 0x000fe2000f8e603fULL, 0x0000001c1d1c723eULL, 0x000fe400000010ffULL,
0x0000000203097811ULL, 0x040fe200078ff8ffULL, 0x0000000706137291ULL, 0x000fe2000f8e583fULL,
0x00000001ff057819ULL, 0x000fe40000011603ULL, 0x00000004030d7811ULL, 0x040fe400078ff8ffULL,
0x0000000603217811ULL, 0x000fc400078ff8ffULL, 0x0000000709077812ULL, 0x000fe400078e7820ULL,
0x0000000705037812ULL, 0x000fe400078e7820ULL, 0x000000070d087812ULL, 0x000fe200078e7820ULL,
0x00000008200b7824ULL, 0x040fe200078e0207ULL, 0x00000007210e7812ULL, 0x000fe200078e7820ULL,
0x0000000820037824ULL, 0x040fe200078e0203ULL, 0x0000000705057812ULL, 0x000fe200078e780cULL,
0x00000008200f7824ULL, 0x000fe200078e0208ULL, 0x0000000709097812ULL, 0x000fe200078e780cULL,
0x0000000802077824ULL, 0x000fe200078e00ffULL, 0x000000070d237812ULL, 0x000fe200078e780cULL,
0x0000000820207824ULL, 0x000fe200078e020eULL, 0x0000000721217812ULL, 0x000fe200078e780cULL,
0x000000080c057824ULL, 0x040fe200078e0205ULL, 0x0000000807087812ULL, 0x000fe200078ec0ffULL,
0x000000080c0d7824ULL, 0x040fe200078e0209ULL, 0x0000001303037c11ULL, 0x000fe2000f8e20ffULL,
0x000000080c237824ULL, 0x040fe200078e0223ULL, 0x000000130b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000080c217824ULL, 0x000fe200078e0221ULL, 0x000000130f0f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000103037824ULL, 0x000fe200078e0208ULL, 0x0000001305097c11ULL, 0x000fe2000f8e20ffULL,
0x00000001080b7824ULL, 0x000fe200078e020bULL, 0x0000001320077c11ULL, 0x000fe2000f8e20ffULL,
0x0000000108057824ULL, 0x040fe200078e020fULL, 0x000000130d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x00000001080c7824ULL, 0x040fe200078e0209ULL, 0x0000001323237c11ULL, 0x000fe2000f8e20ffULL,
0x0000000108077824ULL, 0x040fe200078e0207ULL, 0x0000001321217c11ULL, 0x000fe2000f8e20ffULL,
0x00000001080d7824ULL, 0x040fe200078e020dULL, 0x00000044450e723eULL, 0x000fe200000010ffULL,
0x0000000108237824ULL, 0x040fe200078e0223ULL, 0x000000484948723eULL, 0x000fe200000010ffULL,
0x0000000108217824ULL, 0x000fe200078e0221ULL, 0x000000404124723eULL, 0x000fc400000010ffULL,
0x0000002c2d2c723eULL, 0x000fe400000010ffULL, 0x000000141514723eULL, 0x000fe400000010ffULL,
0x000054101c267816ULL, 0x140fe4000000000eULL, 0x000076321c277816ULL, 0x000fe4000000000eULL,
0x000000101110723eULL, 0x000fe400000010ffULL, 0x000000181908723eULL, 0x000fe200000010ffULL,
0x0000002603007388ULL, 0x0005e20000000a00ULL, 0x0000001e1f1e723eULL, 0x000fc400000010ffULL,
0x00000046470f723eULL, 0x000fe400000010ffULL, 0x00005410481c7816ULL, 0x140fe40000000024ULL,
0x00007632481d7816ULL, 0x000fe40000000024ULL, 0x0000004a4b4a723eULL, 0x000fe400000010ffULL,
0x000000424325723eULL, 0x000fe200000010ffULL, 0x0000001c0b007388ULL, 0x0007e20000000a00ULL,
0x000054102c187816ULL, 0x140fe20000000014ULL, 0x000000ff00037306ULL, 0x004ea20000202400ULL,
0x000076322c197816ULL, 0x000fc40000000014ULL, 0x0000002e2f2e723eULL, 0x000fe400000010ffULL,
0x000000161717723eULL, 0x000fe200000010ffULL, 0x0000001805007388ULL, 0x0009e20000000a00ULL,
0x000000121312723eULL, 0x000fe400000010ffULL, 0x0000001a1b09723eULL, 0x000fe200000010ffULL,
0x00000006ff0b7e24ULL, 0x008fe2000f8e00ffULL, 0x0000541010147816ULL, 0x140fe40000000008ULL,
0x0000763210157816ULL, 0x000fe20000000008ULL, 0x000000200b0b7824ULL, 0x000fe200078e0202ULL,
0x000054101e0e7816ULL, 0x000fc4000000000fULL, 0x000076321e0f7816ULL, 0x000fe2000000000fULL,
0x0000001407007388ULL, 0x000fe20000000a00ULL, 0x000054104a247816ULL, 0x140fe40000000025ULL,
0x000076324a257816ULL, 0x000fe20000000025ULL, 0x0000000e0c007388ULL, 0x000fe20000000a00ULL,
0x000054102e1c7816ULL, 0x140fe40000000017ULL, 0x000076322e1d7816ULL, 0x000fe20000000017ULL,
0x000000240d007388ULL, 0x000fe20000000a00ULL, 0x0000541012087816ULL, 0x000fc40000000009ULL,
0x0000763212097816ULL, 0x000fe20000000009ULL, 0x0000001c23007388ULL, 0x000fe20000000a00ULL,
0x000000070b057c11ULL, 0x010fe4000f8e20ffULL, 0x000000010000780cULL, 0x000fe20003f05270ULL,
0x0000000821007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000050c7984ULL, 0x000ea80000000c00ULL, 0x0004000005147984ULL, 0x000ee80000000c00ULL,
0x0008000005107984ULL, 0x000f280000000c00ULL, 0x000c000005187984ULL, 0x000f620000000c00ULL,
0x0000000f030f7230ULL, 0x004fc40000200800ULL, 0x0000000e030e7230ULL, 0x040fe40000200800ULL,
0x0000000d030d7230ULL, 0x040fe40000200800ULL, 0x0000000c030c7230ULL, 0x040fe40000200800ULL,
0x0000001703177230ULL, 0x048fe40000200800ULL, 0x0000001603167230ULL, 0x040fe40000200800ULL,
0x0000001503157230ULL, 0x000fc40000200800ULL, 0x0000001403037230ULL, 0x000fe40000200800ULL,
0x000000130f0f7230ULL, 0x010fe40000200000ULL, 0x000000120e0e7230ULL, 0x000fe40000200000ULL,
0x000000110d0d7230ULL, 0x000fe40000200000ULL, 0x000000100c0c7230ULL, 0x000fe40000200000ULL,
0x0000001b17177230ULL, 0x020fc40000200000ULL, 0x0000001a16167230ULL, 0x000fe20000200000ULL,
0x0000000c05007388ULL, 0x0005e20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000200000ULL,
0x0000001803147230ULL, 0x000fca0000200000ULL, 0x0004001405007388ULL, 0x0005e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000002800888947ULL, 0x000fea0003800000ULL,
0x0000000000197919ULL, 0x000ee20000002700ULL, 0x00008400ff077b82ULL, 0x000ee20000000800ULL,
0x00000001063f7892ULL, 0x000fe2000f80f810ULL, 0x0000000000167919ULL, 0x004ee20000002600ULL,
0x00000000050c7984ULL, 0x0004aa0000000c00ULL, 0x00009200ff147b82ULL, 0x000f220000000800ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0004000005107984ULL, 0x00046c0000000c00ULL,
0x00009800ff087b82ULL, 0x000e620000000a00ULL, 0x0000000719197224ULL, 0x008fc400078e0216ULL,
0x0000000700077224ULL, 0x000fe400078e02ffULL, 0x0000000019037224ULL, 0x000fe400078e02ffULL,
0x0000001407077224ULL, 0x010fe400078e02ffULL, 0x00000001031b7824ULL, 0x000fc600078e0206ULL,
0x00000fff07167811ULL, 0x040fe400078e40ffULL, 0x01ffffff07177812ULL, 0x000fe200078ec0ffULL,
0x0000000000380947ULL, 0x004fec0003800000ULL, 0x00009800ff067b82ULL, 0x000ea20000000a00ULL,
0x000000011b157824ULL, 0x000fe200078e0217ULL, 0x00000001ff187819ULL, 0x000fe20000011602ULL,
0x0000001002057824ULL, 0x000fc600078e00ffULL, 0x0000000c18187812ULL, 0x000fe400078ec0ffULL,
0x0000007005057812ULL, 0x000fe200078ec0ffULL, 0x0000008015147825ULL, 0x004fc800078e0006ULL,
0x000000801b067825ULL, 0x000fe200078e0006ULL, 0x0000001418147210ULL, 0x140fe40007c7e005ULL,
0x0000000618067210ULL, 0x000fe40007a3e005ULL, 0x00000015ff157210ULL, 0x000fe40001fe84ffULL,
0x00000007ff077210ULL, 0x000fca0000fe44ffULL, 0x0000000406007986ULL, 0x0005e8000c10190eULL,
0x0000000a14007986ULL, 0x0005e4000c10190eULL, 0x0000001b16057211ULL, 0x000fe200078fa0ffULL,
0x0000000b10087899ULL, 0x000fe2000800063fULL, 0x000000ff0200720cULL, 0x000fe20000705670ULL,
0x000000400b157836ULL, 0x004fe20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x0000080008087892ULL, 0x000fe2000f8ee23fULL, 0x0000100005047825ULL, 0x002fca00078e0008ULL,
0x0000000804047c10ULL, 0x000fca000ff3e0ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x000000100b067825ULL, 0x000fc800078e0004ULL, 0x0000001015047825ULL, 0x000fe200078e0004ULL,
0x0000000c06007986ULL, 0x0003e8000c101d0eULL, 0x0000001004007986ULL, 0x0003e2000c101d0eULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000004c0947ULL, 0x000fea0003800000ULL,
0x00009600ff047b82ULL, 0x002e620000000a00ULL, 0xffffffff00077836ULL, 0x000fe40000000000ULL,
0x0000000419047825ULL, 0x002fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0003ec0000008000ULL,
0x0000000000007992ULL, 0x002fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000007040479a8ULL, 0x000ea800099ee1ceULL,
0x00000000ff00798fULL, 0x004fe20002000000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x000000070400720cULL, 0x000fc80003f05270ULL, 0x00000001ff067807ULL, 0x000fca0000000000ULL,
0x00000006ff007988ULL, 0x0003e80008000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000eb00000008800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000040000097882ULL, 0x000fc40000000000ULL, 0x0000065404097896ULL, 0x004fd20008000009ULL,
0x00000009ff047984ULL, 0x002e640008000000ULL, 0x000000ff0400720cULL, 0x002fda0003f05270ULL,
0x0000002400648947ULL, 0x000fea0003800000ULL, 0x00000010ff007c0cULL, 0x000fda000bf05270ULL,
0x0000000c00300947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x0000000000d88947ULL, 0x000fea0003800000ULL, 0x0000001002067824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011602ULL, 0x0000000103077836ULL, 0x040fe40000000000ULL,
0x0000008003047825ULL, 0x100fe200078e0008ULL, 0x0000007006157812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0c7812ULL, 0x000fe200078ec0ffULL, 0x0000008007067825ULL, 0x000fc600078e0008ULL,
0x000000040c0a7210ULL, 0x140fe4000791e015ULL, 0x000000060c067210ULL, 0x000fe40007b5e015ULL,
0x00000005ff0b7210ULL, 0x000fe400007e24ffULL, 0x00000007ff077210ULL, 0x000fc600017e64ffULL,
0x0000000e0a047981ULL, 0x000368000c1e1900ULL, 0x0000000e06057981ULL, 0x000362000c1e1900ULL,
0x000000020000780cULL, 0x000fda0003f05270ULL, 0x00000000009c8947ULL, 0x002fea0003800000ULL,
0x0000000203077836ULL, 0x000fc80000000000ULL, 0x0000008007067825ULL, 0x000fc600078e0008ULL,
0x000000060c067210ULL, 0x000fc8000791e015ULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x0000000e060b7981ULL, 0x000362000c1e1900ULL, 0x000000040000780cULL, 0x000fda0003f06070ULL,
0x0000000000808947ULL, 0x002fea0003800000ULL, 0x0000000303077836ULL, 0x000fc80000000000ULL,
0x0000008007067825ULL, 0x000fc600078e0008ULL, 0x000000060c067210ULL, 0x000fc8000791e015ULL,
0x00000007ff077210ULL, 0x000fca00007e24ffULL, 0x0000000e060d7981ULL, 0x000362000c1e1900ULL,
0x000000040000780cULL, 0x000fda0003f05270ULL, 0x0000000000648947ULL, 0x002fea0003800000ULL,
0x0000000403077836ULL, 0x000fc80000000000ULL, 0x0000008007067825ULL, 0x000fc600078e0008ULL,
0x000000060c067210ULL, 0x000fc8000791e015ULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x0000000e060f7981ULL, 0x000362000c1e1900ULL, 0x000000060000780cULL, 0x000fda0003f06070ULL,
0x0000000000488947ULL, 0x002fea0003800000ULL, 0x0000000503077836ULL, 0x000fc80000000000ULL,
0x0000008007067825ULL, 0x000fc600078e0008ULL, 0x000000060c067210ULL, 0x000fc8000791e015ULL,
0x00000007ff077210ULL, 0x000fca00007e24ffULL, 0x0000000e06117981ULL, 0x000362000c1e1900ULL,
0x000000060000780cULL, 0x000fda0003f05270ULL, 0x00000000002c8947ULL, 0x002fea0003800000ULL,
0x000000080000780cULL, 0x000fe20003f06070ULL, 0x0000000603077836ULL, 0x000fc80000000000ULL,
0x0000008007067825ULL, 0x000fc600078e0008ULL, 0x000000060c067210ULL, 0x000fca0007a3e015ULL,
0x0000000703130836ULL, 0x000fe20000000000ULL, 0x00000007ff077210ULL, 0x000fc60000fe44ffULL,
0x0000008013080825ULL, 0x000fe400078e0008ULL, 0x0000000e06137981ULL, 0x000362000c1e1900ULL,
0x000000080c080210ULL, 0x000fc80007c7e015ULL, 0x00000009ff090210ULL, 0x000fca0001fe84ffULL,
0x0000000e08150981ULL, 0x000368000c1e1900ULL, 0x0000000700067836ULL, 0x002fca0000000000ULL,
0x00000003ff0a7819ULL, 0x000fc80000011606ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x0000000800248947ULL, 0x000fea0003800000ULL, 0x00009800ff067b82ULL, 0x000e620000000a00ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0003ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff197224ULL, 0x020fe200078e0004ULL, 0x0000003f00057c82ULL, 0x000fcc0008000000ULL,
0x0000000400007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x000000050a007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400f41947ULL, 0x022fee0003800000ULL,
0x00000008040a7890ULL, 0x000fe2000fffe03fULL, 0x0000001904047209ULL, 0x000fe20007810000ULL,
0x00000001040b7890ULL, 0x000fc8000fffe03fULL, 0x0000000a00007c0cULL, 0x040fe4000bf23070ULL,
0x0000000b00007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001002087824ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011602ULL,
0x000000080c097836ULL, 0x000fc60000000000ULL, 0x0000007008197812ULL, 0x000fe200078ec0ffULL,
0x0000008009087825ULL, 0x002fe200078e0006ULL, 0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e019ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000e08197981ULL, 0x000368000c1e1900ULL, 0x0000000400b42947ULL, 0x000fea0003800000ULL,
0x00000009040a7890ULL, 0x000fe2000fffe03fULL, 0x0000000504047209ULL, 0x000fe20007810000ULL,
0x00000002040b7890ULL, 0x000fc8000fffe03fULL, 0x0000000a00007c0cULL, 0x040fe4000bf23070ULL,
0x0000000b00007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001002057824ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011602ULL,
0x000000090c097836ULL, 0x002fc60000000000ULL, 0x0000007005057812ULL, 0x000fe200078ec0ffULL,
0x0000008009087825ULL, 0x000fe200078e0006ULL, 0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e005ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000e08057981ULL, 0x000368000c1e1900ULL, 0x0000000400742947ULL, 0x000fea0003800000ULL,
0x0000000a040a7890ULL, 0x000fe2000fffe03fULL, 0x0000000b04047209ULL, 0x000fe20007810000ULL,
0x00000003040b7890ULL, 0x000fc8000fffe03fULL, 0x0000000a00007c0cULL, 0x040fe4000bf23070ULL,
0x0000000b00007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001002087824ULL, 0x002fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011602ULL,
0x0000000a0c097836ULL, 0x000fc60000000000ULL, 0x00000070080b7812ULL, 0x000fe200078ec0ffULL,
0x0000008009087825ULL, 0x000fe200078e0006ULL, 0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e00bULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000e080b7981ULL, 0x000368000c1e1900ULL, 0x0000000400342947ULL, 0x000fea0003800000ULL,
0x0000000b040a7890ULL, 0x000fe2000fffe03fULL, 0x0000000d04047209ULL, 0x000fe20007810000ULL,
0x00000004040b7890ULL, 0x000fc8000fffe03fULL, 0x0000000a00007c0cULL, 0x040fe4000bf23070ULL,
0x0000000b00007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001002087824ULL, 0x002fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011602ULL,
0x0000000b0c097836ULL, 0x000fc60000000000ULL, 0x00000070080d7812ULL, 0x000fe200078ec0ffULL,
0x0000008009087825ULL, 0x000fe200078e0006ULL, 0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000e080d7981ULL, 0x000368000c1e1900ULL, 0x0000000000f42947ULL, 0x000fea0003800000ULL,
0x0000000c040a7890ULL, 0x000fe2000fffe03fULL, 0x0000000f04047209ULL, 0x000fe20007810000ULL,
0x00000005040b7890ULL, 0x000fc8000fffe03fULL, 0x0000000a00007c0cULL, 0x040fe4000bf23070ULL,
0x0000000b00007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001002087824ULL, 0x002fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011602ULL,
0x0000000c0c097836ULL, 0x000fc60000000000ULL, 0x00000070080f7812ULL, 0x000fe200078ec0ffULL,
0x0000008009087825ULL, 0x000fe200078e0006ULL, 0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e00fULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000e080f7981ULL, 0x000368000c1e1900ULL, 0x0000000000b42947ULL, 0x000fea0003800000ULL,
0x0000000d040a7890ULL, 0x000fe2000fffe03fULL, 0x0000001104047209ULL, 0x000fe20007810000ULL,
0x00000006040b7890ULL, 0x000fc8000fffe03fULL, 0x0000000a00007c0cULL, 0x040fe4000bf23070ULL,
0x0000000b00007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001002087824ULL, 0x002fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011602ULL,
0x0000000d0c097836ULL, 0x000fc60000000000ULL, 0x0000007008117812ULL, 0x000fe200078ec0ffULL,
0x0000008009087825ULL, 0x000fe200078e0006ULL, 0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e011ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000e08117981ULL, 0x000368000c1e1900ULL, 0x0000000000742947ULL, 0x000fea0003800000ULL,
0x0000000e040a7890ULL, 0x000fe2000fffe03fULL, 0x0000001304047209ULL, 0x000fe20007810000ULL,
0x00000007040b7890ULL, 0x000fc8000fffe03fULL, 0x0000000a00007c0cULL, 0x040fe4000bf23070ULL,
0x0000000b00007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001002087824ULL, 0x002fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011602ULL,
0x0000000e0c097836ULL, 0x000fc60000000000ULL, 0x0000007008137812ULL, 0x000fe200078ec0ffULL,
0x0000008009087825ULL, 0x000fe200078e0006ULL, 0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e013ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000e08137981ULL, 0x000368000c1e1900ULL, 0x0000000000342947ULL, 0x000fea0003800000ULL,
0x0000000f040a7890ULL, 0x000fe2000fffe03fULL, 0x0000001504047209ULL, 0x000fca0007810000ULL,
0x0000000a00007c0cULL, 0x000fda000bf23070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001002087824ULL, 0x002fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011602ULL,
0x0000000f0c097836ULL, 0x000fc60000000000ULL, 0x0000007008157812ULL, 0x000fe200078ec0ffULL,
0x0000008009087825ULL, 0x000fe200078e0006ULL, 0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007a3e015ULL, 0x00000009ff097210ULL, 0x000fca0000fe44ffULL,
0x0000000e08157981ULL, 0x000368000c1e1900ULL, 0x0000000804047890ULL, 0x000fe2000fffe03fULL,
0x000000080c0c7836ULL, 0x000fe20000000000ULL, 0xfffffff400f08947ULL, 0x000ff4000383ffffULL,
0x0000000000027919ULL, 0x000ea40000000000ULL, 0x0000001002057824ULL, 0x024fe200078e00ffULL,
0x00000001ff067819ULL, 0x002fc80000011602ULL, 0x0000007005057812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ec0ffULL, 0x0000000906057c10ULL, 0x000fca000fffe005ULL,
0x0000000405007388ULL, 0x0003e40000000800ULL, 0x00009800ff0c7b82ULL, 0x000ea20000000a00ULL,
0x000000070200780cULL, 0x040fe20003f04070ULL, 0x00000006030f7c36ULL, 0x000fe20008000000ULL,
0x000000023f0b7899ULL, 0x000fe20008011610ULL, 0x0000001002187824ULL, 0x000fe200078e00ffULL,
0x0000000906047291ULL, 0x000fe2000f8e683fULL, 0x00000001ff197819ULL, 0x000fe20000011602ULL,
0x0000000b0b0a7899ULL, 0x000fe2000800063fULL, 0x0000000f16057211ULL, 0x002fe200078fa0ffULL,
0x0000000411057291ULL, 0x000fe2000f8e603fULL, 0x0000007018187812ULL, 0x000fe200078ec0ffULL,
0x000000010b047892ULL, 0x000fe2000f8ec03fULL, 0x0000000c19197812ULL, 0x000fe200078ec0ffULL,
0x000008000a0a7892ULL, 0x000fe2000f8ec03fULL, 0x0000000117078824ULL, 0x000fe200078e020fULL,
0x00000000003f7886ULL, 0x000fe20000000000ULL, 0x0000004002097836ULL, 0x040fe20000000000ULL,
0x0000000a050a7290ULL, 0x000fe2000fffe03fULL, 0x00000060020b7836ULL, 0x040fe20000000000ULL,
0x00000009191a7c10ULL, 0x000fe2000fffe018ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000009060b8291ULL, 0x000fe2000f8e483fULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x00000009060c8291ULL, 0x000fe2000f8e483fULL, 0x0000100005047825ULL, 0x104fe200078e000cULL,
0x0000000b110b8291ULL, 0x000fe2000f8e403fULL, 0x0000000a02117c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c110c8291ULL, 0x000fe2000f8e403fULL, 0x000000800f0e8825ULL, 0x100fe200078e000cULL,
0x0000000804047c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000b040b8291ULL, 0x000fe2000f8e383fULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00000080070c8825ULL, 0x000fe200078e000cULL,
0x0000000c040c8291ULL, 0x000fe2000f8e383fULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0x0000000600007c0cULL, 0x000fe2000bf23070ULL, 0x0000002002077836ULL, 0x040fe20000000000ULL,
0x0000000b02138c11ULL, 0x040fe2000f8e20ffULL, 0x0000001009087825ULL, 0x100fe200078e0004ULL,
0x0000000c02158c11ULL, 0x000fe4000f8e20ffULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000001007067825ULL, 0x000fe200078e0004ULL,
0x000000001a1a7984ULL, 0x000e620000000800ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000100b0a7825ULL, 0x100fe200078e0004ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000001002047825ULL, 0x000fe200078e0004ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fc4000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000010020c8825ULL, 0x040fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000004117faeULL, 0x0005e2000b901c4eULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000010020e8825ULL, 0x000fe200078e000eULL, 0x0038000006117faeULL, 0x0005e6000b901c4eULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x0058000008117faeULL, 0x0005e8000b901c4eULL,
0x007800000a117faeULL, 0x0005e8000b901c4eULL, 0x045800000c138faeULL, 0x0005e8000b901c4eULL,
0x041800000e158faeULL, 0x0005e8000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000800d41947ULL, 0x000fea0003800000ULL, 0x00009800ff147b82ULL, 0x004ea20000000a00ULL,
0x00000003ff047819ULL, 0x100fe20000011602ULL, 0x0000000906047291ULL, 0x000fe2000f8e483fULL,
0xfffffff8ff057812ULL, 0x000fe200078ee202ULL, 0x000000ffff3b7224ULL, 0x000fe200078e00ffULL,
0x0000000304047812ULL, 0x000fe200078ec0ffULL, 0x0000000411047291ULL, 0x000fe2000f8e403fULL,
0x00000002ff3e7819ULL, 0x000fe20000011602ULL, 0x0000000805077836ULL, 0x040fe20000000000ULL,
0x0000000404067812ULL, 0x000fe200078efcffULL, 0x00000008053d7824ULL, 0x000fe200078e00ffULL,
0x00000007043c7812ULL, 0x000fe200078e7805ULL, 0x000000083e427836ULL, 0x000fe20000000000ULL,
0x0000000704087812ULL, 0x000fe200078e7807ULL, 0x00000004ff417e24ULL, 0x000fe2000f8e00ffULL,
0x0000000706407812ULL, 0x000fe200078e7807ULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0x0000000706047812ULL, 0x000fe200078e7805ULL, 0x0000000600047c82ULL, 0x000fe20008000000ULL,
0x0000003d3c3c7212ULL, 0x000fc400078efcffULL, 0x0000003d043d7212ULL, 0x000fe400078efcffULL,
0x00000007083f7212ULL, 0x080fe400078efcffULL, 0x0000000740407212ULL, 0x004fce00078efcffULL,
0x00000002040a7890ULL, 0x000fcc000fffe03fULL, 0x0000000a00007c0cULL, 0x000fda000bf03070ULL,
0x0000000000b40947ULL, 0x000fea0003800000ULL, 0x000000070200780cULL, 0x040fe20003f24070ULL,
0x0000000a030b7c36ULL, 0x000fe20008000000ULL, 0x000000013f0b7899ULL, 0x000fe2000801160aULL,
0x0000004002097836ULL, 0x040fe20000000000ULL, 0x0000000a0a0c7899ULL, 0x000fe2000800063fULL,
0x0000006002437836ULL, 0x000fe20000000000ULL, 0x0000000b16057211ULL, 0x000fe200078fa0ffULL,
0x000000010b0b7892ULL, 0x000fe4000f8ec03fULL, 0x000008000c0c7892ULL, 0x000fe4000f8ec03fULL,
0x0000100005047825ULL, 0x000fc400078e0014ULL, 0x00000000003f7886ULL, 0x000fe40000800000ULL,
0x0000000bff107e24ULL, 0x000fe2000f8e00ffULL, 0x00000008040c7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000117079824ULL, 0x000fe200078e020bULL, 0x00000009060d8291ULL, 0x000fe2000f8e483fULL,
0x000000800b0a9825ULL, 0x000fe200078e0014ULL, 0x0000000906128291ULL, 0x000fe4000f8e483fULL,
0x0000000d110d8291ULL, 0x000fe2000f8e403fULL, 0x000000ffff0d7224ULL, 0x000fe200000e0605ULL,
0x0000001211128291ULL, 0x000fe2000f8e403fULL, 0x0000002002057836ULL, 0x000fe20000000000ULL,
0x0000000c050c7290ULL, 0x000fe2000fffe03fULL, 0x0000008007069825ULL, 0x000fc800078e0014ULL,
0x0000000dff419e24ULL, 0x000fe2000f8e00ffULL, 0x0000000c02117c11ULL, 0x040fe2000f8e20ffULL,
0x00000010020e7825ULL, 0x000fc800078e000cULL, 0x0000008010139824ULL, 0x000fe200078e0241ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000e117faeULL, 0x0005e2000b901c4eULL,
0x00000012ff419e24ULL, 0x000fe4000f8e00ffULL, 0x0000001005047825ULL, 0x000fc800078e000cULL,
0x0000001009087825ULL, 0x100fe200078e000cULL, 0x0038000004117faeULL, 0x0005e6000b901c4eULL,
0x00000010430c7825ULL, 0x000fe200078e000cULL, 0x0058000008117faeULL, 0x0005e6000b901c4eULL,
0x0000008010439824ULL, 0x000fe200078e0241ULL, 0x007800000c117faeULL, 0x0005e2000b901c4eULL,
0x0000001002069825ULL, 0x000fc800078e0006ULL, 0x0000001002139824ULL, 0x040fe400078e0213ULL,
0x00000010020a9825ULL, 0x000fc600078e000aULL, 0x0458000006139faeULL, 0x0005e2000b901c4eULL,
0x0000001002439824ULL, 0x000fca00078e0243ULL, 0x041800000a439faeULL, 0x0005e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000004000b7c82ULL, 0x000fe40008000000ULL,
0x000000060b047899ULL, 0x000fc8000800063fULL, 0x0000008004047892ULL, 0x000fcc000f8ec03fULL,
0x0000000418047c10ULL, 0x004fe2000fffe041ULL, 0x0000000a0b047899ULL, 0x000fc8000800063fULL,
0x0000000119437824ULL, 0x000fe200078e0204ULL, 0x0000080004047892ULL, 0x000fc8000f8ec03fULL,
0x0000018005047890ULL, 0x000fe2000fffe004ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00418000430d7984ULL, 0x000ea20000000800ULL, 0x000000043c047c11ULL, 0x000fe4000f8e20ffULL,
0x000000043d087c11ULL, 0x000fe2000f8e20ffULL, 0x0045800043457984ULL, 0x000fe20000000800ULL,
0x000000043f0c7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000440107c11ULL, 0x000fe2000f8e20ffULL,
0x000000000404783bULL, 0x000ee20000000200ULL, 0x0000000a00047c82ULL, 0x000fe40008000000ULL,
0x0000000400007c0cULL, 0x000fe2000bf03070ULL, 0x000000000808783bULL, 0x000f220000000200ULL,
0x0000000d1a117221ULL, 0x006fc60000010100ULL, 0x000000000c0c783bULL, 0x000e620000000200ULL,
0x3fb8aa3b11467820ULL, 0x000fc60000410000ULL, 0x000000001010783bULL, 0x000ea20000000200ULL,
0x0001000004437824ULL, 0x048fe200078e00ffULL, 0x0000763204047816ULL, 0x000fe20000000004ULL,
0x0000004600467308ULL, 0x000ee20000000800ULL, 0x0000763205447816ULL, 0x040fe20000000044ULL,
0x0001000008497824ULL, 0x010fe400078e00ffULL, 0x0001000005057824ULL, 0x000fe400078e00ffULL,
0x0001000004047824ULL, 0x000fe400078e00ffULL, 0x0001000009487824ULL, 0x000fc400078e00ffULL,
0x000100000a4b7824ULL, 0x000fe400078e00ffULL, 0x0001000006477824ULL, 0x000fe400078e00ffULL,
0x000100000b4a7824ULL, 0x000fe400078e00ffULL, 0x0000004546537220ULL, 0x008fe20000410000ULL,
0x0000763208467816ULL, 0x000fe20000000046ULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x0000763206457816ULL, 0x000fe20000000045ULL, 0x0000003a533a7221ULL, 0x000fe20000010000ULL,
0x00001f3e53547589ULL, 0x000ee200000e0000ULL, 0x0000763209087816ULL, 0x000fe20000000008ULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x000076320a097816ULL, 0x000fe20000000009ULL,
0x00001f4253537589ULL, 0x000f2200000e0000ULL, 0x000076320b0a7816ULL, 0x000fc4000000000aULL,
0x0000763207067816ULL, 0x040fe20000000006ULL, 0x0001000007077824ULL, 0x000fe400078e00ffULL,
0x0001000009097824ULL, 0x000fe200078e00ffULL, 0x000076320e4c7816ULL, 0x042fe2000000004cULL,
0x000100000e4f7824ULL, 0x000fe200078e00ffULL, 0x000076320c0b7816ULL, 0x040fe2000000000bULL,
0x000100000c4d7824ULL, 0x000fe200078e00ffULL, 0x000076320f0e7816ULL, 0x040fe2000000000eULL,
0x000100000f4e7824ULL, 0x000fe200078e00ffULL, 0x0000763211507816ULL, 0x044fe20000000050ULL,
0x0001000011527824ULL, 0x000fe200078e00ffULL, 0x000076320d0c7816ULL, 0x040fe2000000000cULL,
0x0001000006067824ULL, 0x000fe200078e00ffULL, 0x00007632100f7816ULL, 0x000fe2000000000fULL,
0x000100000d0d7824ULL, 0x000fc400078e00ffULL, 0x0000005404237223ULL, 0x088fe20000010023ULL,
0x0000005405227223ULL, 0x080fe20000010022ULL, 0x0001000045047824ULL, 0x000fe200078e00ffULL,
0x0000763212117816ULL, 0x000fe20000000011ULL, 0x0001000008057824ULL, 0x000fe200078e00ffULL,
0x0000763213517816ULL, 0x000fe20000000051ULL, 0x00000054041f7223ULL, 0x080fe2000001001fULL,
0x000100000b047824ULL, 0x000fe400078e00ffULL, 0x00000054052a7223ULL, 0x000fe2000001002aULL,
0x000100000e057824ULL, 0x000fc400078e00ffULL, 0x00000054061d7223ULL, 0x080fe2000001001dULL,
0x0000005304317223ULL, 0x090fe20000010031ULL, 0x0001000010107824ULL, 0x000fe400078e00ffULL,
0x00000053052e7223ULL, 0x000fe2000001002eULL, 0x0001000012127824ULL, 0x000fe400078e00ffULL,
0x0000005443247223ULL, 0x080fe20000010024ULL, 0x0001000013137824ULL, 0x000fe400078e00ffULL,
0x0000005444217223ULL, 0x000fe20000010021ULL, 0x000100000a0a7824ULL, 0x000fc400078e00ffULL,
0x0000005447207223ULL, 0x080fe20000010020ULL, 0x000100000c0c7824ULL, 0x000fe400078e00ffULL,
0x00000054071e7223ULL, 0x080fe2000001001eULL, 0x000100004c4c7824ULL, 0x000fe400078e00ffULL,
0x00000054491c7223ULL, 0x080fe2000001001cULL, 0x000100000f0f7824ULL, 0x000fe400078e00ffULL,
0x00000054461b7223ULL, 0x000fe2000001001bULL, 0x0001000050057824ULL, 0x000fc400078e00ffULL,
0x0000005448397223ULL, 0x080fe20000010039ULL, 0x0001000011047824ULL, 0x000fe400078e00ffULL,
0x000000544b387223ULL, 0x080fe20000010038ULL, 0x0001000051067824ULL, 0x000fe400078e00ffULL,
0x0000005409287223ULL, 0x080fe20000010028ULL, 0x000000544a377223ULL, 0x080fe20000010037ULL,
0x000000540a257223ULL, 0x000fe20000010025ULL, 0x000000534d367223ULL, 0x080fe20000010036ULL,
0x000000530d307223ULL, 0x080fe20000010030ULL, 0x000000530c357223ULL, 0x080fe20000010035ULL,
0x000000534f347223ULL, 0x080fe20000010034ULL, 0x000000534c337223ULL, 0x080fe20000010033ULL,
0x000000534e2f7223ULL, 0x080fe2000001002fULL, 0x00000053102d7223ULL, 0x080fe2000001002dULL,
0x000000530f2c7223ULL, 0x080fe2000001002cULL, 0x00000053522b7223ULL, 0x080fe2000001002bULL,
0x0000005305327223ULL, 0x080fe20000010032ULL, 0x0000005312297223ULL, 0x080fe20000010029ULL,
0x0000005304277223ULL, 0x080fe20000010027ULL, 0x0000005313267223ULL, 0x080fe20000010026ULL,
0x00000053063b7223ULL, 0x000fe2000001003bULL, 0xfffffff400888947ULL, 0x000fec000383ffffULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x00000011ff007c0cULL, 0x000fe2000bf05270ULL,
0x0000498009047890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x008fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002007812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000403007c10ULL, 0x000fe2000fffe000ULL,
0x0000000000200947ULL, 0x000fec0003800000ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x0000000906097291ULL, 0x000fe2000f8e383fULL, 0x0000001002037824ULL, 0x008fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ec0ffULL, 0x0000000902037c10ULL, 0x000fca000fffe003ULL,
0x0049803a03007388ULL, 0x0007e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000027984ULL, 0x000f280000000800ULL, 0x0000800000037984ULL, 0x008ee20000000800ULL,
0x00000002ff027221ULL, 0x010fc80000010000ULL, 0x0000000302027221ULL, 0x008fc80000010000ULL,
0x0180000002037836ULL, 0x000fca0000000000ULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0002ULL,
0x0000a16000057802ULL, 0x000fce0000000f00ULL, 0x0000007000647944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0007ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000200037308ULL, 0x000ee40000001000ULL, 0xbf80000002007423ULL, 0x008fc80000000003ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fce0000000003ULL,
0x0000000000027919ULL, 0x000ee20000000000ULL, 0x00000006ff177e24ULL, 0x000fe2000f8e00ffULL,
0x00000002ff037819ULL, 0x008fc60000011602ULL, 0x0000002017177824ULL, 0x100fe200078e0202ULL,
0x0000000802097811ULL, 0x004fe400078ff0ffULL, 0x00000003ff0d7819ULL, 0x000fe20000011602ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0300037589ULL, 0x000ea200000e0000ULL,
0xfffffff8ff107812ULL, 0x000fc400078ee202ULL, 0x000000030d0d7812ULL, 0x000fe200078ec0ffULL,
0x00001f09000c7589ULL, 0x00072200000e0000ULL, 0x0000000717177c11ULL, 0x000fe2000f8e20ffULL,
0x0000000810127836ULL, 0x000fe20000000000ULL, 0x000000040d0f7812ULL, 0x000fe200078efcffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x000000070d167812ULL, 0x000fe200078e7812ULL,
0x0000002403047220ULL, 0x044fe20000410000ULL, 0x0000002303237220ULL, 0x040fe20000410000ULL,
0x0000002203057220ULL, 0x040fe20000410000ULL, 0x0000002103067220ULL, 0x040fe20000410000ULL,
0x0000002003207220ULL, 0x040fe20000410000ULL, 0x0000001f031f7220ULL, 0x040fe20000410000ULL,
0x0000001e03077220ULL, 0x040fe20000410000ULL, 0x0000001d03087220ULL, 0x040fe20000410000ULL,
0x0000001c031c7220ULL, 0x040fe20000410000ULL, 0x0000001b031b7220ULL, 0x040fe20000410000ULL,
0x0000003903097220ULL, 0x048fe20000410000ULL, 0x0000002a032a7220ULL, 0x040fe20000410000ULL,
0x00000038030a7220ULL, 0x042fe20000410000ULL, 0x00000028030b7220ULL, 0x040fe20000410000ULL,
0x0000003703377220ULL, 0x040fe20000410000ULL, 0x0000002503007220ULL, 0x000fe20000410000ULL,
0x000000360c367220ULL, 0x050fe20000410000ULL, 0x000000310c317220ULL, 0x040fe20000410000ULL,
0x000000300c307220ULL, 0x040fe20000410000ULL, 0x000000350c357220ULL, 0x040fe20000410000ULL,
0x000000340c347220ULL, 0x040fe20000410000ULL, 0x000000330c337220ULL, 0x040fe20000410000ULL,
0x0000002f0c2f7220ULL, 0x040fe20000410000ULL, 0x0000002e0c2e7220ULL, 0x040fe20000410000ULL,
0x0000002d0c2d7220ULL, 0x040fe20000410000ULL, 0x0000002c0c2c7220ULL, 0x040fe20000410000ULL,
0x0000002b0c2b7220ULL, 0x040fe20000410000ULL, 0x000000320c327220ULL, 0x040fe20000410000ULL,
0x000000290c297220ULL, 0x040fe20000410000ULL, 0x000000270c0e7220ULL, 0x040fe20000410000ULL,
0x000000260c267220ULL, 0x040fe20000410000ULL, 0x0000003b0c3b7220ULL, 0x000fe20000410000ULL,
0x0000000810037824ULL, 0x000fe200078e00ffULL, 0x000000070d0c7812ULL, 0x000fe200078e7810ULL,
0x00000008120d7824ULL, 0x000fe200078e00ffULL, 0x000000070f107812ULL, 0x000fc400078e7810ULL,
0x000000070f127812ULL, 0x000fe400078e7812ULL, 0x000000030c147212ULL, 0x080fe400078efcffULL,
0x0000000310037212ULL, 0x000fe400078efcffULL, 0x0000000d16167212ULL, 0x080fe400078efcffULL,
0x0000000a0b0a723eULL, 0x000fe400000010ffULL, 0x0000000d12157212ULL, 0x000fc400078efcffULL,
0x000000050605723eULL, 0x000fe400000010ffULL, 0x00000037000b723eULL, 0x000fe400000010ffULL,
0x000000042304723eULL, 0x000fe400000010ffULL, 0x000000201f06723eULL, 0x000fe400000010ffULL,
0x000000070807723eULL, 0x000fe400000010ffULL, 0x0000001314007c11ULL, 0x000fc4000f8e20ffULL,
0x0000001c1b08723eULL, 0x000fe400000010ffULL, 0x000000092a09723eULL, 0x000fe200000010ffULL,
0x0000000400007844ULL, 0x000fe20000000200ULL, 0x0000001303037c11ULL, 0x000fe4000f8e20ffULL,
0x000000363110723eULL, 0x000fe400000010ffULL, 0x000000303511723eULL, 0x000fe200000010ffULL,
0x0000000803007844ULL, 0x000fe20000000200ULL, 0x000000343312723eULL, 0x000fc400000010ffULL,
0x0000002f2e13723eULL, 0x000fe400000010ffULL, 0x0000001316147c11ULL, 0x000fe4000f8e20ffULL,
0x0000002d2c0c723eULL, 0x000fe200000010ffULL, 0x000000ff00167306ULL, 0x000e620000202400ULL,
0x0000002b320d723eULL, 0x000fe200000010ffULL, 0x0000001014007844ULL, 0x000fe20000000200ULL,
0x000000290e0e723eULL, 0x000fe400000010ffULL, 0x000000263b0f723eULL, 0x000fc400000010ffULL,
0x0000001315157c11ULL, 0x000fca000f8e20ffULL, 0x0000000c15007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000017187984ULL, 0x000e680000000c00ULL,
0x0004000017207984ULL, 0x000ea80000000c00ULL, 0x00080000171c7984ULL, 0x000ee80000000c00ULL,
0x000c000017247984ULL, 0x000f220000000c00ULL, 0x0000001b161b7230ULL, 0x002fc40000200800ULL,
0x0000001a161a7230ULL, 0x040fe40000200800ULL, 0x0000001916197230ULL, 0x040fe40000200800ULL,
0x0000001816187230ULL, 0x040fe40000200800ULL, 0x0000002316237230ULL, 0x044fe40000200800ULL,
0x0000002216227230ULL, 0x040fe40000200800ULL, 0x0000002116217230ULL, 0x000fc40000200800ULL,
0x0000002016207230ULL, 0x000fe40000200800ULL, 0x0000001f1b1b7230ULL, 0x008fe40000200000ULL,
0x0000001e1a1a7230ULL, 0x000fe40000200000ULL, 0x0000001d19197230ULL, 0x000fe40000200000ULL,
0x0000001c18187230ULL, 0x000fe40000200000ULL, 0x0000002723237230ULL, 0x010fc40000200000ULL,
0x0000002622227230ULL, 0x000fe20000200000ULL, 0x0000001817007388ULL, 0x0003e20000000c00ULL,
0x0000002521217230ULL, 0x000fe40000200000ULL, 0x0000002420207230ULL, 0x000fca0000200000ULL,
0x0004002017007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000006ff007c0cULL, 0x000fda000bf05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x006e620000002600ULL, 0x00000003ff037819ULL, 0x000fe20000011602ULL,
0x00000011ff197e24ULL, 0x000fe2000f8e00ffULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000020021d7836ULL, 0x040fe20000000000ULL, 0x0000840000057ab9ULL, 0x000fe20000000800ULL,
0x00000008191b7824ULL, 0x040fe200078e00ffULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x0000004002187836ULL, 0x040fe20000000000ULL, 0x0000860000087ab9ULL, 0x000fe20000000a00ULL,
0x0000006002217836ULL, 0x000fe20000000000ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee202ULL,
0x0000000819147824ULL, 0x040fe200078e00ffULL, 0x00000003ff157819ULL, 0x000fe20000011618ULL,
0x00000008191e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fc40000011621ULL,
0x0000000715057812ULL, 0x000fe400078e4818ULL, 0x0000000716067812ULL, 0x000fe400078e4821ULL,
0x0ffffff805057812ULL, 0x000fe400078ef818ULL, 0x0ffffff806067812ULL, 0x000fe400078ef821ULL,
0x00000007050c7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000706107c11ULL, 0x000fe2000f8e20ffULL,
0x00000004050472a4ULL, 0x004fe2000f8e023fULL, 0xfffffff81e217812ULL, 0x000fc400078ee221ULL,
0x000000000c0c7984ULL, 0x000fe20000000c00ULL, 0x0000001017007824ULL, 0x042fe400078e00ffULL,
0x00000010171f7824ULL, 0x040fe200078e00ffULL, 0x0000000010107984ULL, 0x000fe20000000c00ULL,
0x00000010171a7824ULL, 0x040fe200078e00ffULL, 0xfffffff000007812ULL, 0x000fe200078ee203ULL,
0x0000001017177824ULL, 0x000fe200078e00ffULL, 0x0000000703037812ULL, 0x000fe400078e4802ULL,
0x0000000400007c10ULL, 0x000fc4000ff1e0ffULL, 0x0ffffff803037812ULL, 0x000fe400078ef802ULL,
0x00000003ff027819ULL, 0x000fe4000001161dULL, 0x0000000703037c11ULL, 0x000fe4000f8e20ffULL,
0x0000000702047812ULL, 0x000fe400078e481dULL, 0xfffffff01a157812ULL, 0x000fe400078ee215ULL,
0x0ffffff804047812ULL, 0x000fc400078ef81dULL, 0xfffffff8141d7812ULL, 0x000fe400078ee21dULL,
0x0000000704087c11ULL, 0x000fe4000f8e20ffULL, 0x0000000003047984ULL, 0x0002a20000000c00ULL,
0xfffffff01f147812ULL, 0x000fe200078ee202ULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0xfffffff017167812ULL, 0x000fe200078ee216ULL, 0x0000000008087984ULL, 0x000ee20000000c00ULL,
0x0000000415177c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee218ULL,
0x000000ffff037224ULL, 0x002fe200000e06ffULL, 0x0000000800027c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff1a7224ULL, 0x000fc600008e06ffULL, 0x0000000900037c11ULL, 0x000fe400080f4403ULL,
0x00000004141c7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000416007c10ULL, 0x000fe2000ff5e0ffULL,
0x000000101b027825ULL, 0x000fe200078e0002ULL, 0x0000000817167c11ULL, 0x000fc6000f8240ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x000000081c147c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x0000000800187c11ULL, 0x000fe4000f8440ffULL,
0x000000091c157c11ULL, 0x000fe400080f4415ULL, 0x0000000917177c11ULL, 0x000fe400088f441aULL,
0x0000000900197c11ULL, 0x000fe200090f4419ULL, 0x000000101d147825ULL, 0x000fc800078e0014ULL,
0x000000101f167825ULL, 0x000fc800078e0016ULL, 0x0000001021187825ULL, 0x000fe200078e0018ULL,
0x0000000402007986ULL, 0x004fe8000c101d0eULL, 0x0000000814007986ULL, 0x008fe8000c101d0eULL,
0x0000000c16007986ULL, 0x000fe8000c101d0eULL, 0x0000001018007986ULL, 0x000fe2000c101d0eULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00009400ff127b82ULL, 0x000ea20000000a00ULL,
0x000000013f047899ULL, 0x002fe20008011610ULL, 0xffffffffff067424ULL, 0x000fc600078e00ffULL,
0x01ffffff04047892ULL, 0x000fcc000f8ec03fULL, 0x000000040f077c11ULL, 0x000fc8000f8e08ffULL,
0x000000020700720cULL, 0x000fe20003f06070ULL, 0x0000000e12087981ULL, 0x004358000c1e9900ULL,
0x00009000ff058b82ULL, 0x000ea20000000800ULL, 0x000000020b048824ULL, 0x000fce00078e00ffULL,
0x00008c00ff108b82ULL, 0x000ee20000000a00ULL, 0x0000000610067899ULL, 0x000fe2000800063fULL,
0x0000000504058224ULL, 0x004fe400078e0207ULL, 0x000000010f047836ULL, 0x000fe40000000000ULL,
0x0000000405108825ULL, 0x008fca00078e0010ULL, 0x0000000e10068981ULL, 0x000362000c1e1900ULL,
0x000000030400720cULL, 0x000fe20003f06070ULL, 0x0000008009047824ULL, 0x000fe200078e00ffULL,
0x000000060f0c7c11ULL, 0x000fe2000f8e40ffULL, 0x0000000707077899ULL, 0x000fc6000800063fULL,
0x0000004004097812ULL, 0x000fce00078ef80cULL, 0x0000000c00408947ULL, 0x002fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x00008a00ff107b82ULL, 0x000ea20000000a00ULL,
0x0000000c0d177248ULL, 0x000fe20007fe0000ULL, 0x0000000706097c24ULL, 0x020fe2000f8e0209ULL,
0x0000040000047882ULL, 0x000fc60000000000ULL, 0x0000000117177824ULL, 0x000fe400078e0a0cULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x00000003ff0a7819ULL, 0x002fe20000011605ULL,
0x0000001005147824ULL, 0x040fe200078e00ffULL, 0x0ffffff805137812ULL, 0x000fe200078ec0ffULL,
0x0000065405057896ULL, 0x008fe20008000004ULL, 0x000000050a0e7212ULL, 0x0c0fe200078e3cffULL,
0x000000080a187836ULL, 0x040fe40000000000ULL, 0x000000040a127836ULL, 0x000fe20000000000ULL,
0x0000000713217812ULL, 0x000fe200078ef80eULL, 0x0000000818197824ULL, 0x040fe200078e00ffULL,
0x00000005180c7212ULL, 0x080fe200078e3cffULL, 0x0000000812157824ULL, 0x040fe200078e00ffULL,
0x0000000512067212ULL, 0x000fe200078e3cffULL, 0x0000000c0a207836ULL, 0x000fe20000000000ULL,
0xfffffff819167812ULL, 0x000fe200078ee20cULL, 0x0000000510047291ULL, 0x000fe2000f8e703fULL,
0x000000171200720cULL, 0x080fe20003fa6070ULL, 0x00000008201b7824ULL, 0x000fe200078e00ffULL,
0x0000007f120c7812ULL, 0x000fe200078ec0ffULL, 0x0000100004047890ULL, 0x000fe2000fffe03fULL,
0xfffffff8150e7812ULL, 0x000fe200078ee206ULL, 0x000000180a247836ULL, 0x000fe20000000000ULL,
0x0000007f18127812ULL, 0x000fe200078ec0ffULL, 0x0000000109157824ULL, 0x040fe200078e020cULL,
0x0000007f0a067812ULL, 0x040fe200078ec0ffULL, 0x0000001c0a2e7836ULL, 0x000fe20000000000ULL,
0x000000171800720cULL, 0x000fe20003f86070ULL, 0x0000000109197824ULL, 0x040fe200078e0212ULL,
0x0000007f200c7812ULL, 0x000fe200078ec0ffULL, 0x0000000109137824ULL, 0x000fe200078e0206ULL,
0x0000007014067812ULL, 0x000fe200078ec0ffULL, 0x0000008015147825ULL, 0x004fe200078e0010ULL,
0x00000005201a7212ULL, 0x000fc400078e3cffULL, 0x000000172000720cULL, 0x000fe20003f66070ULL,
0x0000008019187825ULL, 0x100fe200078e0010ULL, 0x00000006141e7210ULL, 0x000fe40007f3e0ffULL,
0xfffffff81b267812ULL, 0x000fe200078ee21aULL, 0x0000008013127825ULL, 0x000fe200078e0010ULL,
0x0000000618147210ULL, 0x000fe40007f5e0ffULL, 0x0000000421217c11ULL, 0x000fe2000f8e20ffULL,
0x000000100a187836ULL, 0x040fe20000000000ULL, 0x00000006121c7210ULL, 0x000fe20007f1e0ffULL,
0x000000140a207836ULL, 0x000fe20000000000ULL, 0x0000000524227212ULL, 0x000fe200078e3cffULL,
0x000000ffff1f7224ULL, 0x000fe200008e0615ULL, 0x0000007f18127812ULL, 0x040fe200078ec0ffULL,
0x000000ffff1d7224ULL, 0x000fe200000e0613ULL, 0x000000171800720cULL, 0x040fe20003f06070ULL,
0x0000000109137824ULL, 0x040fe200078e020cULL, 0x00000005180c7212ULL, 0x080fe200078e3cffULL,
0x00000001091b7824ULL, 0x000fe200078e0212ULL, 0x000000040e277c11ULL, 0x000fe2000f8e20ffULL,
0x0000008013127825ULL, 0x000fe200078e0010ULL, 0x000000052e0e7212ULL, 0x000fc600078e3cffULL,
0x000000801b1a7825ULL, 0x000fc800078e0010ULL, 0x000000ffff157224ULL, 0x000fe200010e0619ULL,
0x000000170a00720cULL, 0x000fe20003f46070ULL, 0x0000000818237824ULL, 0x000fe200078e00ffULL,
0x0000000520197212ULL, 0x040fe200078e3cffULL, 0x0000000820287824ULL, 0x000fe200078e00ffULL,
0x0000000612187210ULL, 0x000fe20007f3e0ffULL, 0x000000200a2c7836ULL, 0x000fe20000000000ULL,
0x000000061a127210ULL, 0x000fe20007fde0ffULL, 0x0000000824257824ULL, 0x000fe200078e00ffULL,
0x0000007f201a7812ULL, 0x000fe200078ec0ffULL, 0x000000082e297824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee219ULL, 0x000000ffff197224ULL, 0x000fe200008e0613ULL,
0x000000172000720cULL, 0x080fe20003f26070ULL, 0x000000ffff137224ULL, 0x000fe200030e061bULL,
0x0000007f24207812ULL, 0x040fe200078ec0ffULL, 0x00000001091b7824ULL, 0x000fe200078e021aULL,
0xfffffff8230c7812ULL, 0x000fe200078ee20cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c217faeULL, 0x0003e2000d101c4eULL, 0x000000172400720cULL, 0x000fe20003f46070ULL,
0x000000801b1a7825ULL, 0x000fe200078e0010ULL, 0x0000007f2e247812ULL, 0x000fe200078ec0ffULL,
0x000000001e277faeULL, 0x0005e2000e901c4eULL, 0xfffffff8252a7812ULL, 0x000fe200078ee222ULL,
0x0000000109237824ULL, 0x000fe200078e0220ULL, 0x000000061a207210ULL, 0x000fc40007fde0ffULL,
0x0000007f2c1a7812ULL, 0x000fe400078ec0ffULL, 0x000000172e00720cULL, 0x080fe20003fa6070ULL,
0x00000080231c7825ULL, 0x002fe200078e0010ULL, 0xfffffff8290e7812ULL, 0x000fe400078ee20eULL,
0x0000000416297c11ULL, 0x000fe2000f8e20ffULL, 0x0000000109237824ULL, 0x040fe200078e0224ULL,
0x00000004261f7c11ULL, 0x004fe2000f8e20ffULL, 0x000000ffff217224ULL, 0x000fe200030e061bULL,
0x000000061c227210ULL, 0x000fe20007fde0ffULL, 0x0000000109257824ULL, 0x000fe200078e021aULL,
0x0000000014297faeULL, 0x0003e2000e101c4eULL, 0x00000080231a7825ULL, 0x000fe200078e0010ULL,
0x000000172c00720cULL, 0x000fc40003f86070ULL, 0x00000000181f7faeULL, 0x0005e2000d901c4eULL,
0x000000240a2e7836ULL, 0x000fe40000000000ULL, 0x000000ffff237224ULL, 0x000fe200030e061dULL,
0x000000061a247210ULL, 0x000fe20007fde0ffULL, 0x00000080251c7825ULL, 0x000fe200078e0010ULL,
0x0000007f2e167812ULL, 0x000fe400078ec0ffULL, 0x000000040c157c11ULL, 0x002fe2000f8e20ffULL,
0x000000ffff257224ULL, 0x000fe200030e061bULL, 0x000000061c1c7210ULL, 0x000fe20007fde0ffULL,
0x00000001091b7824ULL, 0x000fe200078e0216ULL, 0x0000000428197c11ULL, 0x004fe2000f8e20ffULL,
0x000000280a0c7836ULL, 0x000fe20000000000ULL, 0x0000000012157faeULL, 0x000fe2000c101c4eULL,
0x000000082c277824ULL, 0x040fe200078e00ffULL, 0x000000052c167212ULL, 0x000fe200078e3cffULL,
0x000000801b1a7825ULL, 0x000fe200078e0010ULL, 0x000000042a1f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000020197faeULL, 0x0003e2000c901c4eULL, 0x000000172e00720cULL, 0x040fe20003f66070ULL,
0x000000082e2b7824ULL, 0x040fe200078e00ffULL, 0x000000052e1e7212ULL, 0x080fe200078e3cffULL,
0x0000002c0a147836ULL, 0x040fe20000000000ULL, 0xfffffff827167812ULL, 0x000fe200078ee216ULL,
0x000000300a267836ULL, 0x040fe20000000000ULL, 0xfffffff82b1e7812ULL, 0x000fe200078ee21eULL,
0x000000340a287836ULL, 0x000fe20000000000ULL, 0x000000040e277c11ULL, 0x000fe2000f8e20ffULL,
0x000000380a2a7836ULL, 0x000fe20000000000ULL, 0x0000000416297c11ULL, 0x000fe2000f8e20ffULL,
0x0000003c0a207836ULL, 0x002fe20000000000ULL, 0x0000007f0c0a7812ULL, 0x040fe200078ec0ffULL,
0x000000ffff1d7224ULL, 0x000fe200030e061dULL, 0x000000061a1a7210ULL, 0x000fe20007fde0ffULL,
0x000000080c157824ULL, 0x040fe200078e00ffULL, 0x000000050c0e7212ULL, 0x000fe200078e3cffULL,
0x0000000109137824ULL, 0x000fe200078e020aULL, 0x0000007f140a7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1b7224ULL, 0x000fe200030e061bULL, 0x000000041e197c11ULL, 0x000fe2000f8e20ffULL,
0x00000000221f7faeULL, 0x000fe2000d101c4eULL, 0x0000008013127825ULL, 0x000fe200078e0010ULL,
0xfffffff8150e7812ULL, 0x000fc400078ee20eULL, 0x0000000024277faeULL, 0x000fe2000e901c4eULL,
0x000000170c00720cULL, 0x080fe20003fc6070ULL, 0x0000000109157824ULL, 0x000fe200078e020aULL,
0x000000171400720cULL, 0x080fe20003fa6070ULL, 0x000000001c297faeULL, 0x0003e2000e101c4eULL,
0x000000172600720cULL, 0x080fe40003f86070ULL, 0x000000172800720cULL, 0x080fe20003f46070ULL,
0x000000001a197faeULL, 0x0005e2000d901c4eULL, 0x000000172a00720cULL, 0x080fe40003f26070ULL,
0x000000172000720cULL, 0x000fe20003f06070ULL, 0x0000000814177824ULL, 0x000fe200078e00ffULL,
0x0000007f260c7812ULL, 0x000fc400078ec0ffULL, 0x00000005140a7212ULL, 0x000fe200078e3cffULL,
0x0000008015147825ULL, 0x000fe200078e0010ULL, 0x0000000612167210ULL, 0x000fe40007f7e0ffULL,
0xfffffff8170a7812ULL, 0x000fe200078ee20aULL, 0x00000001091d7824ULL, 0x002fe200078e020cULL,
0x0000007f280c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff177224ULL, 0x000fe200018e0613ULL,
0x0000000614187210ULL, 0x000fe20007f7e0ffULL, 0x000000801d127825ULL, 0x000fe200078e0010ULL,
0x0000007f2a147812ULL, 0x000fc400078ec0ffULL, 0x00000005281c7212ULL, 0x000fe200078e3cffULL,
0x00000001091b7824ULL, 0x044fe200078e020cULL, 0x0000007f200c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff197224ULL, 0x000fe200018e0615ULL, 0x00000006121a7210ULL, 0x000fe20007f7e0ffULL,
0x00000001091d7824ULL, 0x000fe400078e0214ULL, 0x000000801b147825ULL, 0x000fc800078e0010ULL,
0x000000ffff1b7224ULL, 0x000fe200018e0613ULL, 0x0000000614147210ULL, 0x000fe20007f7e0ffULL,
0x00000001091f7824ULL, 0x000fe200078e020cULL, 0x0000000526097212ULL, 0x000fe200078e3cffULL,
0x000000801d127825ULL, 0x000fc800078e0010ULL, 0x00000008260c7824ULL, 0x000fe400078e00ffULL,
0x00000008281d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0x0000000612127210ULL, 0x000fe20007f7e0ffULL, 0x000000801f107825ULL, 0x000fe200078e0010ULL,
0xfffffff80c0c7812ULL, 0x000fe400078ee209ULL, 0x000000052a097212ULL, 0x0c0fe200078e3cffULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1c7812ULL, 0x000fe200078ee21cULL,
0x000000ffff137224ULL, 0x000fe200018e0613ULL, 0x00000005201d7212ULL, 0x040fe200078e3cffULL,
0x0000000820207824ULL, 0x000fe200078e00ffULL, 0x0000000610107210ULL, 0x000fc40007f7e0ffULL,
0xfffffff82a067812ULL, 0x000fe400078ee209ULL, 0x000000040e097c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff117224ULL, 0x000fe200018e0611ULL, 0xfffffff8200e7812ULL, 0x000fe400078ee21dULL,
0x000000040a1d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000016097faeULL, 0x0003e2000f101c4eULL,
0x000000040c1f7c11ULL, 0x000fe4000f8e20ffULL, 0x000000041c217c11ULL, 0x000fe2000f8e20ffULL,
0x00000000181d7faeULL, 0x0003e2000e901c4eULL, 0x0000000406237c11ULL, 0x000fc4000f8e20ffULL,
0x000000040e257c11ULL, 0x000fe2000f8e20ffULL, 0x000000001a1f7faeULL, 0x0003e8000e101c4eULL,
0x0000000014217faeULL, 0x0003e8000d101c4eULL, 0x0000000012237faeULL, 0x0003e8000c901c4eULL,
0x0000000010257faeULL, 0x0003e2000c101c4eULL, 0x0000000800f47947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x00000007061f7c24ULL, 0x020fe2000f8e0209ULL,
0x00000000000479c3ULL, 0x000ea20000008800ULL, 0x0000040000057882ULL, 0x000fe40000000000ULL,
0x0000065404057896ULL, 0x004fc80008000005ULL, 0x0000000510047291ULL, 0x000fe2000f8e703fULL,
0x00000003ff107819ULL, 0x002fe20000011605ULL, 0x00000010051e7824ULL, 0x040fe200078e00ffULL,
0x0ffffff805097812ULL, 0x000fe200078ec0ffULL, 0x0000100004047890ULL, 0x000fe2000fffe03fULL,
0x0000000510167212ULL, 0x0c0fe200078e3cffULL, 0x0000000810247836ULL, 0x040fe20000000000ULL,
0x0000007f10207812ULL, 0x040fe200078ec0ffULL, 0x0000000c10267836ULL, 0x040fe20000000000ULL,
0x0000000709167812ULL, 0x000fe200078ef816ULL, 0x00000014102a7836ULL, 0x000fe20000000000ULL,
0x00000005241a7212ULL, 0x080fe200078e3cffULL, 0x00000018102c7836ULL, 0x000fe20000000000ULL,
0x0000000526177212ULL, 0x080fe200078e3cffULL, 0x0000000824137824ULL, 0x000fe200078e00ffULL,
0x000000052a197212ULL, 0x080fe200078e3cffULL, 0x0000000826067824ULL, 0x000fe200078e00ffULL,
0x000000052c1c7212ULL, 0x080fe200078e3cffULL, 0x000000082a0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8131a7812ULL, 0x000fe200078ee21aULL, 0x000000082c097824ULL, 0x000fe200078e00ffULL,
0xfffffff806177812ULL, 0x000fe200078ee217ULL, 0x0000002c10367836ULL, 0x040fe20000000000ULL,
0xfffffff80c197812ULL, 0x000fe200078ee219ULL, 0x0000001c102e7836ULL, 0x040fe20000000000ULL,
0xfffffff8091c7812ULL, 0x000fe200078ee21cULL, 0x0000002410327836ULL, 0x000fe20000000000ULL,
0x00000005360c7212ULL, 0x0c0fe200078e3cffULL, 0x0000000836137824ULL, 0x000fe200078e00ffULL,
0x000000052e1d7212ULL, 0x0c0fe200078e3cffULL, 0x000000082e067824ULL, 0x000fe200078e00ffULL,
0x0000000532147212ULL, 0x0c0fe200078e3cffULL, 0x0000000832097824ULL, 0x000fe200078e00ffULL,
0xfffffff8130c7812ULL, 0x000fe200078ee20cULL, 0x00000034103a7836ULL, 0x040fe20000000000ULL,
0xfffffff8061d7812ULL, 0x000fe200078ee21dULL, 0x00000038103c7836ULL, 0x000fe20000000000ULL,
0xfffffff809147812ULL, 0x000fe200078ee214ULL, 0x000000083a127824ULL, 0x040fe200078e00ffULL,
0x000000053a097212ULL, 0x080fe200078e3cffULL, 0x000000083c137824ULL, 0x040fe200078e00ffULL,
0x000000053c067212ULL, 0x080fe200078e3cffULL, 0x0000000410227836ULL, 0x040fe20000000000ULL,
0xfffffff812097812ULL, 0x000fe200078ee209ULL, 0x0000001010287836ULL, 0x000fe20000000000ULL,
0xfffffff813067812ULL, 0x000fe200078ee206ULL, 0x0000000822117824ULL, 0x040fe200078e00ffULL,
0x00008a00ff127b82ULL, 0x000e620000000a00ULL, 0x0000000522187212ULL, 0x080fe200078e3cffULL,
0x00000008280a7824ULL, 0x040fe200078e00ffULL, 0x00000005281b7212ULL, 0x080fe200078e3cffULL,
0x0000002810347836ULL, 0x040fe20000000000ULL, 0xfffffff811187812ULL, 0x000fe200078ee218ULL,
0x0000002010307836ULL, 0x000fe20000000000ULL, 0xfffffff80a1b7812ULL, 0x000fe200078ee21bULL,
0x0000000834117824ULL, 0x040fe200078e00ffULL, 0x00000005340e7212ULL, 0x080fe200078e3cffULL,
0x00000008300a7824ULL, 0x040fe200078e00ffULL, 0x0000000530157212ULL, 0x080fe200078e3cffULL,
0x0000003010387836ULL, 0x040fe20000000000ULL, 0xfffffff8110e7812ULL, 0x000fe200078ee20eULL,
0x0000003c10107836ULL, 0x000fe20000000000ULL, 0xfffffff80a157812ULL, 0x000fe200078ee215ULL,
0x0000000838117824ULL, 0x040fe200078e00ffULL, 0x00000005380a7212ULL, 0x000fe200078e3cffULL,
0x00000008103f7824ULL, 0x000fe200078e00ffULL, 0x0000007f22227812ULL, 0x000fc400078ec0ffULL,
0xfffffff8110a7812ULL, 0x000fe200078ee20aULL, 0x000000011f117824ULL, 0x040fe200078e0220ULL,
0x0000007f24247812ULL, 0x000fe200078ec0ffULL, 0x000000011f217824ULL, 0x040fe200078e0222ULL,
0x0000007f26267812ULL, 0x000fe400078ec0ffULL, 0x0000007f10207812ULL, 0x000fe200078ec0ffULL,
0x000000011f237824ULL, 0x040fe200078e0224ULL, 0x0000007f28287812ULL, 0x000fe200078ec0ffULL,
0x000000011f257824ULL, 0x040fe200078e0226ULL, 0x0000007f2a2a7812ULL, 0x000fe200078ec0ffULL,
0x000000011f3d7824ULL, 0x040fe200078e0220ULL, 0x0000007f2c2c7812ULL, 0x000fe200078ec0ffULL,
0x000000011f277824ULL, 0x040fe200078e0228ULL, 0x0000007f2e2e7812ULL, 0x000fe200078ec0ffULL,
0x000000011f297824ULL, 0x040fe200078e022aULL, 0x0000007f30307812ULL, 0x000fe200078ec0ffULL,
0x000000011f2b7824ULL, 0x040fe200078e022cULL, 0x0000007f32327812ULL, 0x000fe200078ec0ffULL,
0x000000011f2d7824ULL, 0x040fe200078e022eULL, 0x0000007f34347812ULL, 0x000fe200078ec0ffULL,
0x000000011f2f7824ULL, 0x040fe200078e0230ULL, 0x0000007f36367812ULL, 0x000fe200078ec0ffULL,
0x000000011f317824ULL, 0x040fe200078e0232ULL, 0x0000007f38387812ULL, 0x000fe200078ec0ffULL,
0x000000011f337824ULL, 0x040fe200078e0234ULL, 0x0000007f3a3a7812ULL, 0x000fe200078ec0ffULL,
0x000000011f357824ULL, 0x040fe200078e0236ULL, 0x0000007f3c3c7812ULL, 0x000fe200078ec0ffULL,
0x000000011f377824ULL, 0x000fe200078e0238ULL, 0x00000005103e7212ULL, 0x000fe200078e3cffULL,
0x0000008011107825ULL, 0x002fe200078e0012ULL, 0x000000701e1e7812ULL, 0x000fc400078ec0ffULL,
0xfffffff83f3e7812ULL, 0x000fe200078ee23eULL, 0x000000011f397824ULL, 0x040fe200078e023aULL,
0x0000001e10107210ULL, 0x000fe20007f1e0ffULL, 0x000000011f3b7824ULL, 0x000fe200078e023cULL,
0x00000004163f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000008021207825ULL, 0x100fe200078e0012ULL,
0x0000000417177c11ULL, 0x000fe4000f8e20ffULL, 0x000000041b1b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000008023227825ULL, 0x000fe200078e0012ULL, 0x0000000419197c11ULL, 0x000fc4000f8e20ffULL,
0x000000041c417c11ULL, 0x000fe2000f8e20ffULL, 0x0000008025247825ULL, 0x100fe200078e0012ULL,
0x000000041d1d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000415157c11ULL, 0x000fe2000f8e20ffULL,
0x0000008027267825ULL, 0x000fe200078e0012ULL, 0x0000000409097c11ULL, 0x000fc6000f8e20ffULL,
0x0000008029287825ULL, 0x000fc800078e0012ULL, 0x000000802b2a7825ULL, 0x000fc800078e0012ULL,
0x000000802d2c7825ULL, 0x000fc800078e0012ULL, 0x000000802f2e7825ULL, 0x000fc800078e0012ULL,
0x0000008031307825ULL, 0x000fc800078e0012ULL, 0x0000008033327825ULL, 0x000fc800078e0012ULL,
0x0000008035347825ULL, 0x000fc800078e0012ULL, 0x0000008037367825ULL, 0x000fc800078e0012ULL,
0x0000008039387825ULL, 0x000fc800078e0012ULL, 0x000000803b3a7825ULL, 0x000fc800078e0012ULL,
0x000000803d3c7825ULL, 0x000fe200078e0012ULL, 0x0000001e20127210ULL, 0x000fe40007f3e0ffULL,
0x0000001e22207210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000001e24227210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0621ULL,
0x0000001e26247210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff217224ULL, 0x000fe200010e0623ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000103f7faeULL, 0x0003e2000b901c4eULL,
0x000000ffff237224ULL, 0x000fe200000e0625ULL, 0x0000001e28267210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff257224ULL, 0x000fe200008e0627ULL, 0x0000001e2a287210ULL, 0x000fc40007f5e0ffULL,
0x0000001e2c2a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0629ULL,
0x0000001e2e2c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff297224ULL, 0x000fe400010e062bULL,
0x000000ffff2b7224ULL, 0x000fe200008e062dULL, 0x0000001e302e7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e062fULL, 0x0000001e32307210ULL, 0x000fe40007f1e0ffULL,
0x0000000414117c11ULL, 0x002fe2000f8e20ffULL, 0x000000ffff2f7224ULL, 0x000fe200008e0631ULL,
0x0000001e34327210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff317224ULL, 0x000fe200000e0633ULL,
0x0000001e36347210ULL, 0x000fc60007f1e0ffULL, 0x000000ffff337224ULL, 0x000fe200008e0635ULL,
0x0000001e38367210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff357224ULL, 0x000fe200000e0637ULL,
0x0000001e3a387210ULL, 0x000fe40007f1e0ffULL, 0x0000001e3c1e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff377224ULL, 0x000fe400008e0639ULL, 0x000000ffff397224ULL, 0x000fe200000e063bULL,
0x00000004183b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e063dULL,
0x000000041a3d7c11ULL, 0x000fc6000f8e20ffULL, 0x00000000123b7faeULL, 0x0003e8000b901c4eULL,
0x00000000203d7faeULL, 0x000fe8000b901c4eULL, 0x0000000022177faeULL, 0x0007e8000b901c4eULL,
0x00000000241b7faeULL, 0x0009e2000b901c4eULL, 0x000000040e137c11ULL, 0x002fc6000f8e20ffULL,
0x0000000026197faeULL, 0x0003e8000b901c4eULL, 0x0000000028417faeULL, 0x000fe2000b901c4eULL,
0x000000040c177c11ULL, 0x008fc6000f8e20ffULL, 0x000000002a1d7faeULL, 0x0007e2000b901c4eULL,
0x00000004061b7c11ULL, 0x010fe4000f8e20ffULL, 0x000000040a197c11ULL, 0x002fe2000f8e20ffULL,
0x000000002c157faeULL, 0x0005e8000b901c4eULL, 0x000000002e117faeULL, 0x0005e2000b901c4eULL,
0x000000043e1d7c11ULL, 0x008fc6000f8e20ffULL, 0x0000000030137faeULL, 0x0005e8000b901c4eULL,
0x0000000032177faeULL, 0x0005e8000b901c4eULL, 0x0000000034197faeULL, 0x0005e8000b901c4eULL,
0x0000000036097faeULL, 0x0005e8000b901c4eULL, 0x00000000381b7faeULL, 0x0005e8000b901c4eULL,
0x000000001e1d7faeULL, 0x0005e4000b901c4eULL, 0x0000000200077824ULL, 0x000fe400078e0207ULL,
0xffffffffff067424ULL, 0x000fc600078e00ffULL, 0x000000020700720cULL, 0x000fda0003f06070ULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00009000ff097b82ULL, 0x006e620000000800ULL,
0x000000020b067824ULL, 0x000fce00078e00ffULL, 0x00008c00ff107b82ULL, 0x000ea20000000a00ULL,
0x0000000906097224ULL, 0x002fc800078e0207ULL, 0x0000000409107825ULL, 0x004fca00078e0010ULL,
0x0000000e10067981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01b600ffff0075a7ULL, 0x000ee20008000145ULL, 0x000000031000788cULL, 0x000fe2000bf04070ULL,
0x00000001ff1c7424ULL, 0x000fe400078e00ffULL, 0x80000000ff0e7424ULL, 0x000fc600078e00ffULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x0000004000fc8947ULL, 0x008fd80003800000ULL,
0x0000000000641947ULL, 0x000fea0003800000ULL, 0x00000010ff0a7e24ULL, 0x000fc8000f8e00ffULL,
0x000000200a097824ULL, 0x006fc800078e0205ULL, 0x00000010090c7824ULL, 0x000fe200078e00ffULL,
0x00000003ff0a7819ULL, 0x000fc80000011609ULL, 0x1ffffffe0a0a7812ULL, 0x000fe400078ec0ffULL,
0x000000f00c117812ULL, 0x000fe400078ec0ffULL, 0x000000010a0c7812ULL, 0x000fe400078efcffULL,
0x000000070a0a7812ULL, 0x000fe400078e7809ULL, 0x000000070c0c7812ULL, 0x000fc600078e7809ULL,
0x000000010a0a7824ULL, 0x000fe400078e0211ULL, 0x00000001110c7824ULL, 0x000fc600078e020cULL,
0x000000050a0a7c11ULL, 0x000fe4000f8e20ffULL, 0x000000050c0c7c11ULL, 0x000fc6000f8e20ffULL,
0x000000000a147984ULL, 0x000e680000000c00ULL, 0x000000000c107984ULL, 0x000ea20000000c00ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff147224ULL, 0x000fe400078e0015ULL,
0x000000ffff197224ULL, 0x000fe400078e0016ULL, 0x000000ffff157224ULL, 0x000fc400078e0017ULL,
0x000000ffff1a7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0012ULL,
0x000000ffff167224ULL, 0x000fe400078e0011ULL, 0x000000ffff177224ULL, 0x000fe200078e0013ULL,
0x000000180a007388ULL, 0x0003e80000000c00ULL, 0x000000140c007388ULL, 0x0003e40000000c00ULL,
0x01b6001cffff79a7ULL, 0x0007e20008500005ULL, 0x000000030f00720cULL, 0x000fe20003f26070ULL,
0x01b6000eff0075a7ULL, 0x000f240008000145ULL, 0x0000004000a08947ULL, 0x018ff40003800000ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x00009000ff0a7b82ULL, 0x002e620000000800ULL,
0x3db504f308087820ULL, 0x000fe20000410000ULL, 0xffffffff030c7836ULL, 0x000fe20000000000ULL,
0x00007610ff097816ULL, 0x004fe20000000009ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x0000000510087291ULL, 0x000fe2000f8e203fULL, 0x0000000a0b0a7224ULL, 0x002fd600078e02ffULL,
0x000000060f0e7c11ULL, 0x000fc8000f8e40ffULL, 0x0000000e0d00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00000001003c7824ULL, 0x000fe200078e020fULL,
0x00000001140b7812ULL, 0x000fc600078e0cffULL, 0x000000013c107836ULL, 0x040fe20000000000ULL,
0x000000063c127c11ULL, 0x000fc8000f8e40ffULL, 0x000000031000720cULL, 0x000fe40003f06070ULL,
0x0000004012117812ULL, 0x000fca00078ec0ffULL, 0x0000000104117824ULL, 0x000fcc00078e0211ULL,
0x0000000c00388947ULL, 0x000fea0003800000ULL, 0x00000003ff3e7819ULL, 0x000fe20000011605ULL,
0x0000000706117c24ULL, 0x020fe2000f8e0211ULL, 0x000000120d237248ULL, 0x000fe20007fe0000ULL,
0x0000000510047291ULL, 0x000fe4000f8e703fULL, 0x000000043e167836ULL, 0x000fe40000000000ULL,
0x0000000123237824ULL, 0x000fe400078e0a12ULL, 0x0000000816137824ULL, 0x040fe200078e00ffULL,
0x0000000516107212ULL, 0x000fe200078e3cffULL, 0x000000083e187836ULL, 0x000fe20000000000ULL,
0x000000231600720cULL, 0x000fe20003f46070ULL, 0x0000000c3e1a7836ULL, 0x000fe20000000000ULL,
0xfffffff8132c7812ULL, 0x000fe200078ee210ULL, 0x0000000818157824ULL, 0x000fe200078e00ffULL,
0x00008a00ff127b82ULL, 0x000e620000000a00ULL, 0x000000081a177824ULL, 0x000fe200078e00ffULL,
0x0000000518067212ULL, 0x080fe200078e3cffULL, 0x000000103e1c7836ULL, 0x000fe20000000000ULL,
0x000000051a107212ULL, 0x000fe200078e3cffULL, 0x000000143e227836ULL, 0x000fe20000000000ULL,
0x0000007f16167812ULL, 0x000fe200078ec0ffULL, 0x000000081c327824ULL, 0x000fe200078e00ffULL,
0x000000231800720cULL, 0x000fe20003f66070ULL, 0x0000000822347824ULL, 0x000fe200078e00ffULL,
0x0000007f18187812ULL, 0x000fe200078ec0ffULL, 0x0000000116197824ULL, 0x100fe200078e0211ULL,
0xfffffff8152e7812ULL, 0x000fe200078ee206ULL, 0x0000001005067824ULL, 0x000fe200078e00ffULL,
0xfffffff817307812ULL, 0x000fe200078ee210ULL, 0x00000001181b7824ULL, 0x000fe200078e0211ULL,
0x000000051c157212ULL, 0x080fe200078e3cffULL, 0x000000183e367836ULL, 0x000fe20000000000ULL,
0x0000000522177212ULL, 0x000fe200078e3cffULL, 0x0000001c3e387836ULL, 0x040fe20000000000ULL,
0x0000007f3e107812ULL, 0x040fe200078ec0ffULL, 0x000000203e3a7836ULL, 0x000fe20000000000ULL,
0x000000231c00720cULL, 0x000fe20003f26070ULL, 0x00000008362f7824ULL, 0x000fe200078e00ffULL,
0x0000007f1c1c7812ULL, 0x000fe200078ec0ffULL, 0x0000008019187825ULL, 0x002fe200078e0012ULL,
0xfffffff834347812ULL, 0x000fc400078ee217ULL, 0x0000007006067812ULL, 0x000fe200078ec0ffULL,
0x0000000110177824ULL, 0x100fe200078e0211ULL, 0x000000231a00720cULL, 0x000fe20003f06070ULL,
0x000000011c217824ULL, 0x000fe200078e0211ULL, 0x0000007f1a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000008017167825ULL, 0x100fe200078e0012ULL, 0x00000006181c7210ULL, 0x000fe40007f9e0ffULL,
0xfffffff832327812ULL, 0x000fe200078ee215ULL, 0x0000008021207825ULL, 0x000fe200078e0012ULL,
0x0000000616287210ULL, 0x000fc40007fbe0ffULL, 0x000000053e157212ULL, 0x000fe200078e3cffULL,
0x000000011a1f7824ULL, 0x000fe200078e0211ULL, 0x0000007f38247812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1d7224ULL, 0x000fe200020e0619ULL, 0x0000000620167210ULL, 0x000fe20007f9e0ffULL,
0x000000801f1e7825ULL, 0x000fe200078e0012ULL, 0x0000007f3a267812ULL, 0x000fc600078ec0ffULL,
0x000000ffff297224ULL, 0x000fe200028e0617ULL, 0x000000061e187210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200020e0621ULL, 0x000000232200720cULL, 0x0c0fe20003f86070ULL,
0x000000801b1a7825ULL, 0x000fe200078e0012ULL, 0x0000007f22227812ULL, 0x000fe400078ec0ffULL,
0x0000007f361e7812ULL, 0x000fe200078ec0ffULL, 0x00000004ff107e24ULL, 0x000fe2000f8e00ffULL,
0x000000061a1a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff197224ULL, 0x000fe200028e061fULL,
0x000000233e00720cULL, 0x000fe20003fa6070ULL, 0x00000001221f7824ULL, 0x000fe200078e0211ULL,
0x0000000715227812ULL, 0x000fe200078ec0ffULL, 0x000020000b157824ULL, 0x000fc400078e0210ULL,
0x000000011e217824ULL, 0x000fe200078e0211ULL, 0x0ffffff822227812ULL, 0x000fe200078ef805ULL,
0x000000801f1e7825ULL, 0x000fc800078e0012ULL, 0x0000100015157836ULL, 0x000fe40000000000ULL,
0x000000ffff1b7224ULL, 0x000fe200030e061bULL, 0x000000061e1e7210ULL, 0x000fe20007fde0ffULL,
0x0000008021207825ULL, 0x000fc800078e0012ULL, 0x00000010222d7824ULL, 0x000fe200078e0215ULL,
0x0000000536227212ULL, 0x000fe200078e3cffULL, 0x0000000124257824ULL, 0x000fe400078e0211ULL,
0x000000ffff1f7224ULL, 0x000fe200030e061fULL, 0x0000000620207210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282d7faeULL, 0x0003e2000e901c4eULL,
0x0000008025247825ULL, 0x000fe200078e0012ULL, 0x000000233600720cULL, 0x000fe40003fa6070ULL,
0xfffffff82f227812ULL, 0x000fe200078ee222ULL, 0x000000243e367836ULL, 0x000fc40000000000ULL,
0x000000ffff217224ULL, 0x000fe200030e0621ULL, 0x00000006242a7210ULL, 0x000fe20007fde0ffULL,
0x0000000126277824ULL, 0x000fe200078e0211ULL, 0x0000007f36247812ULL, 0x000fe200078ec0ffULL,
0x000000102c2f7824ULL, 0x100fe200078e0215ULL, 0x0000000538287212ULL, 0x082fe200078e3cffULL,
0x000000102e297824ULL, 0x000fe200078e0215ULL, 0x000000053a2c7212ULL, 0x000fe200078e3cffULL,
0x00000008382d7824ULL, 0x040fe200078e00ffULL, 0x000000001c2f7faeULL, 0x0003e2000d101c4eULL,
0x0000008027267825ULL, 0x000fe200078e0012ULL, 0x000000233800720cULL, 0x000fc40003f46070ULL,
0x000000001a297faeULL, 0x0005e2000d901c4eULL, 0x000000ffff2b7224ULL, 0x000fe200030e0625ULL,
0xfffffff82d287812ULL, 0x000fe200078ee228ULL, 0x0000000124257824ULL, 0x000fe200078e0211ULL,
0x0000000626267210ULL, 0x000fe20007fde0ffULL, 0x00000010222d7824ULL, 0x000fe200078e0215ULL,
0x000000233a00720cULL, 0x000fe20003f66070ULL, 0x0000008025247825ULL, 0x000fc800078e0012ULL,
0x00000010301d7824ULL, 0x102fe400078e0215ULL, 0x00000010321b7824ULL, 0x104fe400078e0215ULL,
0x0000001034297824ULL, 0x000fe200078e0215ULL, 0x00000000181d7faeULL, 0x0003e2000c101c4eULL,
0x000000083a317824ULL, 0x000fe400078e00ffULL, 0x000000283e1a7836ULL, 0x000fe20000000000ULL,
0x00000000161b7faeULL, 0x0005e2000c901c4eULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x0000000624247210ULL, 0x000fe20007fde0ffULL, 0x00000010282f7824ULL, 0x000fe200078e0215ULL,
0x000000001e297faeULL, 0x000fe2000e101c4eULL, 0xfffffff8312c7812ULL, 0x000fe200078ee22cULL,
0x000000303e1c7836ULL, 0x000fc40000000000ULL, 0x00000000202d7faeULL, 0x0007e2000e901c4eULL,
0x0000002c3e187836ULL, 0x002fe20000000000ULL, 0x000000231a00720cULL, 0x000fe20003fa6070ULL,
0x0000000836197824ULL, 0x000fe200078e00ffULL, 0x000000051a177212ULL, 0x084fe200078e3cffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x0000000536167212ULL, 0x000fe200078e3cffULL,
0x000000102c317824ULL, 0x100fe200078e0215ULL, 0x000000233600720cULL, 0x080fe20003fc6070ULL,
0x0000000818227824ULL, 0x000fe200078e00ffULL, 0x000000002a2f7faeULL, 0x000fe2000d101c4eULL,
0xfffffff819167812ULL, 0x000fe200078ee216ULL, 0x000000081a207824ULL, 0x048fe200078e00ffULL,
0x0000007f1a1a7812ULL, 0x000fe200078ec0ffULL, 0x0000000026317faeULL, 0x0003e2000d901c4eULL,
0x000000231800720cULL, 0x000fe20003f86070ULL, 0x00000010161b7824ULL, 0x000fe200078e0215ULL,
0xfffffff820207812ULL, 0x000fe200078ee217ULL, 0x000000343e287836ULL, 0x000fe20000000000ULL,
0x0000000518177212ULL, 0x080fe200078e3cffULL, 0x000000383e2c7836ULL, 0x000fe20000000000ULL,
0x000000051c197212ULL, 0x000fe200078e3cffULL, 0x00000000241b7faeULL, 0x0005e2000f101c4eULL,
0xfffffff822227812ULL, 0x000fe200078ee217ULL, 0x000000011a177824ULL, 0x000fe200078e0211ULL,
0x0000007f18187812ULL, 0x000fe200078ec0ffULL, 0x000000081c267824ULL, 0x042fe200078e00ffULL,
0x000000231c00720cULL, 0x040fe20003f66070ULL, 0x0000008017167825ULL, 0x000fe200078e0012ULL,
0x0000007f1c1c7812ULL, 0x000fc400078ec0ffULL, 0xfffffff826267812ULL, 0x000fe200078ee219ULL,
0x0000000118197824ULL, 0x000fe200078e0211ULL, 0x0000000616167210ULL, 0x000fe20007fde0ffULL,
0x00000008281f7824ULL, 0x040fe200078e00ffULL, 0x00000005281a7212ULL, 0x040fe200078e3cffULL,
0x0000008019187825ULL, 0x000fe200078e0012ULL, 0x000000232800720cULL, 0x040fe40003f46070ULL,
0x0000007f28287812ULL, 0x000fe200078ec0ffULL, 0x000000011c1d7824ULL, 0x000fe200078e0211ULL,
0xfffffff81f2a7812ULL, 0x000fe200078ee21aULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x00000006181c7210ULL, 0x000fe20007fde0ffULL, 0x000000801d1a7825ULL, 0x004fe200078e0012ULL,
0x0000007f2c187812ULL, 0x000fc400078ec0ffULL, 0x000000232c00720cULL, 0x080fe20003f26070ULL,
0x00000001281f7824ULL, 0x000fe400078e0211ULL, 0x0000003c3e2e7836ULL, 0x000fe40000000000ULL,
0x000000ffff1d7224ULL, 0x000fe200030e0619ULL, 0x000000061a1e7210ULL, 0x000fe20007fde0ffULL,
0x0000000118217824ULL, 0x000fe200078e0211ULL, 0x0000007f2e247812ULL, 0x040fe200078ec0ffULL,
0x000000801f187825ULL, 0x000fe200078e0012ULL, 0x000000232e00720cULL, 0x000fc40003f06070ULL,
0x000000052c237212ULL, 0x080fe200078e3cffULL, 0x000000ffff1f7224ULL, 0x000fe200030e061bULL,
0x0000000618187210ULL, 0x000fe20007fde0ffULL, 0x00000080211a7825ULL, 0x000fe200078e0012ULL,
0x000000052e217212ULL, 0x000fc600078e3cffULL, 0x0000000124117824ULL, 0x000fe400078e0211ULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x000000061a1a7210ULL, 0x000fe20007fde0ffULL,
0x000000082c247824ULL, 0x000fe400078e00ffULL, 0x000000082e287824ULL, 0x000fe400078e00ffULL,
0x0000008011127825ULL, 0x000fe200078e0012ULL, 0xfffffff824247812ULL, 0x000fe400078ee223ULL,
0xfffffff828287812ULL, 0x000fe200078ee221ULL, 0x000000ffff1b7224ULL, 0x000fe200030e061bULL,
0x0000000612127210ULL, 0x000fe20007fde0ffULL, 0x0000001020117824ULL, 0x000fc400078e0215ULL,
0x0000001022217824ULL, 0x100fe400078e0215ULL, 0x0000001026237824ULL, 0x100fe200078e0215ULL,
0x0000000016117faeULL, 0x0003e2000e901c4eULL, 0x000000102a257824ULL, 0x100fe400078e0215ULL,
0x0000001024277824ULL, 0x100fe200078e0215ULL, 0x000000001c217faeULL, 0x0003e2000e101c4eULL,
0x0000001028157824ULL, 0x000fe400078e0215ULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x000000001e237faeULL, 0x0003e8000d901c4eULL, 0x0000000018257faeULL, 0x0003e8000d101c4eULL,
0x000000001a277faeULL, 0x0003e8000c901c4eULL, 0x0000000012157faeULL, 0x0003e2000c101c4eULL,
0x0000000800ec7947ULL, 0x000fea0003800000ULL, 0x00000003ff3e7819ULL, 0x000fe20000011605ULL,
0x0000000706067c24ULL, 0x020fe2000f8e0211ULL, 0x0000000510047291ULL, 0x000fe4000f8e703fULL,
0x000000053e157212ULL, 0x0c0fe200078e3cffULL, 0x000000083e1a7836ULL, 0x040fe40000000000ULL,
0x000000143e207836ULL, 0x000fe40000000000ULL, 0x000000081a1f7824ULL, 0x040fe200078e00ffULL,
0x000000051a127212ULL, 0x080fe200078e3cffULL, 0x0000000820297824ULL, 0x000fe200078e00ffULL,
0x0000007f1a1d7812ULL, 0x000fe200078ec0ffULL, 0x000000203e267836ULL, 0x040fe20000000000ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee212ULL, 0x000000043e187836ULL, 0x000fe20000000000ULL,
0x0000000520127212ULL, 0x080fe200078e3cffULL, 0x0000000826397824ULL, 0x000fe200078e00ffULL,
0x0000007f20277812ULL, 0x000fe200078ec0ffULL, 0x000000103e1e7836ULL, 0x040fe20000000000ULL,
0xfffffff829297812ULL, 0x000fe200078ee212ULL, 0x0000002c3e2c7836ULL, 0x000fe20000000000ULL,
0x0000000526127212ULL, 0x080fe200078e3cffULL, 0x00000008181b7824ULL, 0x040fe200078e00ffULL,
0x0000000518107212ULL, 0x080fe200078e3cffULL, 0x0000000c3e1c7836ULL, 0x000fe20000000000ULL,
0xfffffff839397812ULL, 0x000fe200078ee212ULL, 0x000000081e167824ULL, 0x040fe200078e00ffULL,
0x000000051e117212ULL, 0x080fe200078e3cffULL, 0x000000082c457824ULL, 0x040fe200078e00ffULL,
0x000000052c127212ULL, 0x080fe200078e3cffULL, 0x000000383e327836ULL, 0x000fe20000000000ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee210ULL, 0x000000081c237824ULL, 0x040fe200078e00ffULL,
0x000000051c107212ULL, 0x080fe200078e3cffULL, 0x0000001c3e247836ULL, 0x040fe20000000000ULL,
0xfffffff816357812ULL, 0x000fe200078ee211ULL, 0x000000183e227836ULL, 0x000fe20000000000ULL,
0xfffffff845457812ULL, 0x000fe200078ee212ULL, 0x0000000824167824ULL, 0x000fe200078e00ffULL,
0x0000000532127212ULL, 0x0c0fe200078e3cffULL, 0x0000000832517824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee210ULL, 0x0000000822377824ULL, 0x000fe200078e00ffULL,
0x0000000524117212ULL, 0x080fe200078e3cffULL, 0x000000243e287836ULL, 0x000fe20000000000ULL,
0x0000000522107212ULL, 0x080fe200078e3cffULL, 0x000000283e2a7836ULL, 0x000fe20000000000ULL,
0xfffffff8162f7812ULL, 0x000fe200078ee211ULL, 0x00000008283b7824ULL, 0x000fe200078e00ffULL,
0xfffffff851517812ULL, 0x000fe200078ee212ULL, 0x000000082a167824ULL, 0x000fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fe200078ee210ULL, 0x00008a00ff127b82ULL, 0x000e620000000a00ULL,
0x0000000528107212ULL, 0x080fe200078e3cffULL, 0x000000303e2e7836ULL, 0x000fe20000000000ULL,
0x000000052a117212ULL, 0x080fe200078e3cffULL, 0x000000343e307836ULL, 0x000fe20000000000ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL, 0x000000082e497824ULL, 0x000fe200078e00ffULL,
0xfffffff816417812ULL, 0x000fe200078ee211ULL, 0x0000000830167824ULL, 0x000fe200078e00ffULL,
0x000000052e107212ULL, 0x080fe200078e3cffULL, 0x0000003c3e347836ULL, 0x000fe20000000000ULL,
0x0000000530117212ULL, 0x080fe200078e3cffULL, 0x000000011d1d7824ULL, 0x100fe200078e0206ULL,
0xfffffff849497812ULL, 0x000fe200078ee210ULL, 0x00000004ff107e24ULL, 0x000fe2000f8e00ffULL,
0xfffffff8164d7812ULL, 0x000fe200078ee211ULL, 0x0000000834557824ULL, 0x000fe200078e00ffULL,
0x0000007f3e117812ULL, 0x000fe200078ec0ffULL, 0x0000000127277824ULL, 0x000fe200078e0206ULL,
0x0000000715167812ULL, 0x000fe200078ec0ffULL, 0x000020000b157824ULL, 0x000fe200078e0210ULL,
0x00000005341a7212ULL, 0x000fe200078e3cffULL, 0x0000000111197824ULL, 0x000fe200078e0206ULL,
0x0000007f18177812ULL, 0x000fe200078ec0ffULL, 0x0000100015187836ULL, 0x000fe20000000000ULL,
0x0000007f1c217812ULL, 0x000fe200078ec0ffULL, 0x000000801d1c7825ULL, 0x002fe200078e0012ULL,
0x0000007f1e257812ULL, 0x000fc400078ec0ffULL, 0x0000007f222b7812ULL, 0x000fe200078ec0ffULL,
0x0000000117177824ULL, 0x100fe200078e0206ULL, 0x0000007f242d7812ULL, 0x000fe200078ec0ffULL,
0x0000000121217824ULL, 0x100fe200078e0206ULL, 0x0000007f26317812ULL, 0x000fe200078ec0ffULL,
0x0000000125257824ULL, 0x100fe200078e0206ULL, 0x0000007f28337812ULL, 0x000fe200078ec0ffULL,
0x000000012b2b7824ULL, 0x100fe200078e0206ULL, 0x0000007f2a3d7812ULL, 0x000fe200078ec0ffULL,
0x000000012d2d7824ULL, 0x100fe200078e0206ULL, 0x0000007f2c437812ULL, 0x000fe200078ec0ffULL,
0x0000000131317824ULL, 0x100fe200078e0206ULL, 0x0000007f2e477812ULL, 0x000fe200078ec0ffULL,
0x0000000133337824ULL, 0x100fe200078e0206ULL, 0x0000007f304b7812ULL, 0x000fe200078ec0ffULL,
0x000000013d3f7824ULL, 0x100fe200078e0206ULL, 0x0000007f324f7812ULL, 0x000fe200078ec0ffULL,
0x0000000143437824ULL, 0x100fe200078e0206ULL, 0x0000007f34537812ULL, 0x000fe200078ec0ffULL,
0x0000000147477824ULL, 0x100fe200078e0206ULL, 0x0ffffff816117812ULL, 0x000fe200078ef805ULL,
0x0000001005167824ULL, 0x000fe200078e00ffULL, 0xfffffff855557812ULL, 0x000fe200078ee21aULL,
0x000000014b4b7824ULL, 0x000fc400078e0206ULL, 0x000000014f4f7824ULL, 0x100fe400078e0206ULL,
0x0000000153537824ULL, 0x000fe400078e0206ULL, 0x0000001011117824ULL, 0x100fe400078e0218ULL,
0x000000101b067824ULL, 0x100fe400078e0218ULL, 0x000000101f157824ULL, 0x100fe400078e0218ULL,
0x0000001023347824ULL, 0x000fc400078e0218ULL, 0x0000001035357824ULL, 0x100fe400078e0218ULL,
0x0000001029367824ULL, 0x100fe400078e0218ULL, 0x0000001037377824ULL, 0x100fe400078e0218ULL,
0x000000102f387824ULL, 0x100fe400078e0218ULL, 0x0000001039397824ULL, 0x100fe400078e0218ULL,
0x000000103b3d7824ULL, 0x100fe200078e0218ULL, 0x00000070163b7812ULL, 0x000fe200078ec0ffULL,
0x0000001041417824ULL, 0x000fc400078e0218ULL, 0x0000001045457824ULL, 0x100fe200078e0218ULL,
0x0000003b1c1c7210ULL, 0x000fe20007f5e0ffULL, 0x0000001049497824ULL, 0x100fe400078e0218ULL,
0x000000104d4d7824ULL, 0x100fe400078e0218ULL, 0x0000001051517824ULL, 0x100fe400078e0218ULL,
0x0000001055557824ULL, 0x000fe400078e0218ULL, 0x0000008019187825ULL, 0x000fc800078e0012ULL,
0x00000080171a7825ULL, 0x000fe200078e0012ULL, 0x0000003b18187210ULL, 0x000fc60007f1e0ffULL,
0x00000080211e7825ULL, 0x000fe200078e0012ULL, 0x0000003b1a1a7210ULL, 0x000fc60007f3e0ffULL,
0x0000008025207825ULL, 0x000fe200078e0012ULL, 0x0000003b1e1e7210ULL, 0x000fc60007f7e0ffULL,
0x0000008027227825ULL, 0x000fc800078e0012ULL, 0x000000802b247825ULL, 0x000fc800078e0012ULL,
0x000000802d267825ULL, 0x000fc800078e0012ULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x0000003b20207210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e061bULL,
0x0000003b22227210ULL, 0x000fe20007f3e0ffULL, 0x0000008031287825ULL, 0x000fe200078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018117faeULL, 0x0003e6000b901c4eULL,
0x000000ffff1d7224ULL, 0x000fe200010e061dULL, 0x0000003b24247210ULL, 0x000fe20007f5e0ffULL,
0x00000080332a7825ULL, 0x000fe200078e0012ULL, 0x000000001a067faeULL, 0x0003e6000b901c4eULL,
0x000000ffff1f7224ULL, 0x000fe200018e061fULL, 0x0000003b26267210ULL, 0x000fe20007f7e0ffULL,
0x000000803f2c7825ULL, 0x100fe200078e0012ULL, 0x000000001c157faeULL, 0x0003e6000b901c4eULL,
0x00000080432e7825ULL, 0x000fe200078e0012ULL, 0x000000001e347faeULL, 0x0003e6000b901c4eULL,
0x000000ffff217224ULL, 0x000fe200000e0621ULL, 0x0000003b28287210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff237224ULL, 0x000fe200008e0623ULL, 0x0000003b2a2a7210ULL, 0x000fe20007f3e0ffULL,
0x0000008047307825ULL, 0x000fe200078e0012ULL, 0x0000000020357faeULL, 0x0003e6000b901c4eULL,
0x000000ffff257224ULL, 0x000fe200010e0625ULL, 0x0000003b2c2c7210ULL, 0x000fe20007f5e0ffULL,
0x000000804b327825ULL, 0x000fe200078e0012ULL, 0x0000000022367faeULL, 0x0003e6000b901c4eULL,
0x000000ffff277224ULL, 0x000fe200018e0627ULL, 0x0000003b2e2e7210ULL, 0x000fe20007f7e0ffULL,
0x000000804f167825ULL, 0x100fe200078e0012ULL, 0x0000000024377faeULL, 0x0003e6000b901c4eULL,
0x0000008053127825ULL, 0x000fe200078e0012ULL, 0x0000000026387faeULL, 0x0003e6000b901c4eULL,
0x000000ffff297224ULL, 0x000fe200000e0629ULL, 0x0000003b30307210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200008e062bULL, 0x0000003b32327210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200010e062dULL, 0x0000003b16167210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200018e062fULL, 0x0000003b12127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fe200000e0631ULL, 0x0000000028397faeULL, 0x0003e2000b901c4eULL,
0x000000ffff337224ULL, 0x000fc400008e0633ULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x000000002a3d7faeULL, 0x0003e2000b901c4eULL, 0x000000ffff137224ULL, 0x000fc600018e0613ULL,
0x000000002c417faeULL, 0x0003e8000b901c4eULL, 0x000000002e457faeULL, 0x0003e8000b901c4eULL,
0x0000000030497faeULL, 0x0003e8000b901c4eULL, 0x00000000324d7faeULL, 0x0003e8000b901c4eULL,
0x0000000016517faeULL, 0x0003e8000b901c4eULL, 0x0000000012557faeULL, 0x0003e4000b901c4eULL,
0x0000000200077824ULL, 0x000fe200078e0207ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff067424ULL, 0x002fc600078e00ffULL, 0x000000020700720cULL, 0x000fda0003f06070ULL,
0x00008c00ff128b82ULL, 0x000e620000000a00ULL, 0x000000020a118824ULL, 0x000fe200078e0207ULL,
0x0000000705407812ULL, 0x040fe200078ec0ffULL, 0x0000200014447824ULL, 0x000fe200078e0210ULL,
0xfffffff805107812ULL, 0x000fe200078ec0ffULL, 0x000000ffff427224ULL, 0x000fe200078e00ffULL,
0x00000004ff3f7819ULL, 0x000fe40000011605ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fc4000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000411128825ULL, 0x002fc800078e0012ULL,
0x0000002005117836ULL, 0x000fe20000000000ULL, 0x0000000e12068981ULL, 0x000362000c1e1900ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000100044447836ULL, 0x000fe20000000000ULL,
0x0000000710437812ULL, 0x000fe400078ef805ULL, 0x0000000840417812ULL, 0x000fe400078ef805ULL,
0xfffffff811127812ULL, 0x002fc800078ec0ffULL, 0x00000007123d7812ULL, 0x000fce00078ef805ULL,
0x0000000742107812ULL, 0x000fe200078e7843ULL, 0x0000000242787824ULL, 0x000fc800078e023fULL,
0x0000000843117824ULL, 0x000fe200078e0210ULL, 0x0000000742107812ULL, 0x000fc600078e783dULL,
0x0000001011187824ULL, 0x000fe400078e0244ULL, 0x000000083d117824ULL, 0x000fc800078e0210ULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0x0000001011117824ULL, 0x000fcc00078e0244ULL,
0x000000001110783bULL, 0x000ea20000000200ULL, 0x00000018ff5b7819ULL, 0x002fe20000011418ULL,
0x00010000181c7824ULL, 0x040fe200078e00ffULL, 0x00008880185f7816ULL, 0x040fe200000000ffULL,
0x0000010018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe20000011419ULL,
0x00010000191d7824ULL, 0x040fe200078e00ffULL, 0x0000888019747816ULL, 0x040fe200000000ffULL,
0x0000010019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000005b005b7306ULL, 0x000fe20000202400ULL, 0x00000018ff577819ULL, 0x000fc4000001141aULL,
0x000088801a567816ULL, 0x000fe400000000ffULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018ff6e7819ULL, 0x000fe2000001141bULL, 0x00000018005c7306ULL, 0x0002e20000202400ULL,
0x000088801b707816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x00000018ff687819ULL, 0x004fe20000011410ULL,
0x0000001900637306ULL, 0x0005e20000202400ULL, 0x000100001a187824ULL, 0x002fe200078e00ffULL,
0x00008880106c7816ULL, 0x000fe200000000ffULL, 0x000001001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011411ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x000100001b197824ULL, 0x044fe200078e00ffULL,
0x0000001c00767306ULL, 0x000fe20000202400ULL, 0x000001001b1b7824ULL, 0x000fe200078e00ffULL,
0x00008880116a7816ULL, 0x000fc400000000ffULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018ff1b7819ULL, 0x000fe4000001141bULL, 0x0000001a00727306ULL, 0x0003e20000202400ULL,
0x00000018ff5a7819ULL, 0x000fe40000011412ULL, 0x0000888012667816ULL, 0x000fe400000000ffULL,
0x00000018ff457819ULL, 0x000fe40000011413ULL, 0x0000888013617816ULL, 0x000fe200000000ffULL,
0x0000001b00717306ULL, 0x0005e20000202400ULL, 0x00000001421a7836ULL, 0x002fc40000000000ULL,
0x0000000242427836ULL, 0x000fc60000000000ULL, 0x000000071a1c7812ULL, 0x000fe400078e7843ULL,
0x0000001d00777306ULL, 0x0003e20000202400ULL, 0x000000071a1a7812ULL, 0x000fe400078e783dULL,
0x00000008431b7824ULL, 0x004fe200078e021cULL, 0x000000084200780cULL, 0x000fe40003f05270ULL,
0x000000083d477824ULL, 0x000fe400078e021aULL, 0x000000101b1b7824ULL, 0x000fe200078e0244ULL,
0x0000001800757306ULL, 0x0005e80000202400ULL, 0x000000001b1c783bULL, 0x002e680000000200ULL,
0x0000001900737306ULL, 0x0009e20000202400ULL, 0x0001000010187824ULL, 0x004fc400078e00ffULL,
0x0000010010107824ULL, 0x000fc600078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0001000011197824ULL, 0x050fe200078e00ffULL,
0x00000018006f7306ULL, 0x0005e20000202400ULL, 0x0000010011117824ULL, 0x000fc600078e00ffULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000010006d7306ULL, 0x0009e20000202400ULL, 0x0000001047187824ULL, 0x004fce00078e0244ULL,
0x0000001100697306ULL, 0x0005e20000202400ULL, 0x0001000012107824ULL, 0x050fe400078e00ffULL,
0x0000010012127824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0001000013117824ULL, 0x044fe200078e00ffULL,
0x0000001000677306ULL, 0x0005e20000202400ULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x002fe4000001141cULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff137819ULL, 0x000fc40000011413ULL, 0x0000001100627306ULL, 0x0003e20000202400ULL,
0x000100001c107824ULL, 0x044fe200078e00ffULL, 0x000088801c487816ULL, 0x040fe200000000ffULL,
0x000001001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001141dULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000001200657306ULL, 0x0005e20000202400ULL,
0x000100001d117824ULL, 0x002fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x000088801d4f7816ULL, 0x040fe200000000ffULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000001000517306ULL, 0x0003e20000202400ULL,
0x000100001e127824ULL, 0x004fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff4d7819ULL, 0x000fe4000001141eULL, 0x00000018ff597819ULL, 0x000fc40000011412ULL,
0x0000001300607306ULL, 0x000fe20000202400ULL, 0x0000000778107812ULL, 0x002fe200078e7841ULL,
0x0000000278787836ULL, 0x000fe20000000000ULL, 0x00000018ff4c7819ULL, 0x000fe4000001141fULL,
0x000088801e507816ULL, 0x040fe200000000ffULL, 0x0000001041107824ULL, 0x000fe200078e0210ULL,
0x0000000778787812ULL, 0x000fe200078e7841ULL, 0x0000001100527306ULL, 0x0003e20000202400ULL,
0x000088801f547816ULL, 0x000fe200000000ffULL, 0x000001001e1e7824ULL, 0x000fe200078e00ffULL,
0x0000000510107c11ULL, 0x000fe2000f8e20ffULL, 0x0000001041787824ULL, 0x000fc600078e0278ULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x00000019006b7306ULL, 0x0005e20000202400ULL,
0x000000001010783bULL, 0x002fee0000000200ULL, 0x0000005f005f7306ULL, 0x000e620000202400ULL,
0x000000001818783bULL, 0x004eae0000000200ULL, 0x0000001c00537306ULL, 0x0009f00000202400ULL,
0x0000001d00557306ULL, 0x0007e20000202400ULL, 0x000100001f1c7824ULL, 0x010fc400078e00ffULL,
0x000001001f1f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000005e005e7306ULL, 0x000fe20000202400ULL, 0x000054105c1d7816ULL, 0x008fe4000000005bULL,
0x00000018ff1f7819ULL, 0x000fca000001141fULL, 0x0000001c005d7306ULL, 0x0003f00000202400ULL,
0x0000005700577306ULL, 0x000ee20000202400ULL, 0x000054105f1c7816ULL, 0x002fe40000000076ULL,
0x00000018ff4b7819ULL, 0x004fc40000011418ULL, 0x00008880185c7816ULL, 0x000fe400000000ffULL,
0x00000018ff4a7819ULL, 0x000fe20000011419ULL, 0x0000007400747306ULL, 0x000e620000202400ULL,
0x0000001c1038723cULL, 0x000fe20000041838ULL, 0x00000018ff497819ULL, 0x000fe4000001141aULL,
0x00000018ff477819ULL, 0x000fe4000001141bULL, 0x0000541072577816ULL, 0x008fe40000000057ULL,
0x0000005600567306ULL, 0x000ea20000202400ULL, 0x00010000181d7824ULL, 0x000fc400078e00ffULL,
0x0000010018187824ULL, 0x000fc600078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000006e006e7306ULL, 0x000ee20000202400ULL, 0x00005410741c7816ULL, 0x002fe40000000077ULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000541056567816ULL, 0x004fc60000000075ULL,
0x0000007000707306ULL, 0x000e680000202400ULL, 0x000000561030723cULL, 0x000fe80000041830ULL,
0x0000001d005f7306ULL, 0x0005e60000202400ULL, 0x0000010019577824ULL, 0x000fca00078e00ffULL,
0x0000006c006c7306ULL, 0x000f220000202400ULL, 0x00005410631d7816ULL, 0x004fe4000000005eULL,
0x0000888019637816ULL, 0x000fe400000000ffULL, 0x00000018ff577819ULL, 0x000fc60000011457ULL,
0x0000001c1034723cULL, 0x000fe20000041834ULL, 0x0000006800687306ULL, 0x000eac0000202400ULL,
0x00010000191d7824ULL, 0x000fe200078e00ffULL, 0x0000541071197816ULL, 0x008fe2000000006eULL,
0x00000018005e7306ULL, 0x0003e20000202400ULL, 0x00000005781c7c11ULL, 0x000fc4000f8e20ffULL,
0x00000018ff727819ULL, 0x000fca000001141dULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x0000541070187816ULL, 0x002fce0000000073ULL, 0x0000006a006a7306ULL, 0x000e620000202400ULL,
0x00000018102c723cULL, 0x000fee000004182cULL, 0x000088801a197816ULL, 0x000fe200000000ffULL,
0x0000005a005a7306ULL, 0x000fe20000202400ULL, 0x000054106c187816ULL, 0x010fc6000000006fULL,
0x000000ffff6c7224ULL, 0x000fe200078e0019ULL, 0x000054106d197816ULL, 0x004fe20000000068ULL,
0x000100001a6d7824ULL, 0x040fe400078e00ffULL, 0x0000006600667306ULL, 0x000ea20000202400ULL,
0x000001001a1a7824ULL, 0x000fc600078e00ffULL, 0x000000181028723cULL, 0x000fe40000041828ULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x0000001e00587306ULL, 0x000fe60000202400ULL,
0x000054106a187816ULL, 0x002fe4000000006bULL, 0x0000541069197816ULL, 0x000fe40000000064ULL,
0x00000018ff697819ULL, 0x000fe2000001146dULL, 0x0000001f005b7306ULL, 0x0003e80000202400ULL,
0x000000181024723cULL, 0x000fe80000041824ULL, 0x0000004500457306ULL, 0x000ee20000202400ULL,
0x000000001c1c783bULL, 0x002e640000000200ULL, 0x0000541066187816ULL, 0x004fc40000000067ULL,
0x0000541065197816ULL, 0x000fe4000000005aULL, 0x000088801b5a7816ULL, 0x000fe200000000ffULL,
0x0000006100617306ULL, 0x000ea80000202400ULL, 0x000000181020723cULL, 0x000fe80000041820ULL,
0x0000004600467306ULL, 0x000fe60000202400ULL, 0x0000541060197816ULL, 0x008fe20000000045ULL,
0x000000ffff457224ULL, 0x000fe200078e005aULL, 0x0000541061187816ULL, 0x004fc60000000062ULL,
0x0000004800487306ULL, 0x000ea80000202400ULL, 0x000000181014723cULL, 0x000fe80000041814ULL,
0x0000004e004e7306ULL, 0x000ee60000202400ULL, 0x000100001b117824ULL, 0x000fc400078e00ffULL,
0x000001001b1b7824ULL, 0x000fe200078e00ffULL, 0x0000541048107816ULL, 0x004fe40000000051ULL,
0x0000005400547306ULL, 0x000ea20000202400ULL, 0x00000018ff137819ULL, 0x000fe40000011411ULL,
0x0000541053117816ULL, 0x000fe40000000046ULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x0000541055537816ULL, 0x008fe2000000004eULL, 0x0000004d004d7306ULL, 0x000ee40000202400ULL,
0x000000101c38723cULL, 0x002fe20000041838ULL, 0x0000541054547816ULL, 0x004fca000000005dULL,
0x0000004c004c7306ULL, 0x000e620000202400ULL, 0x0000541058517816ULL, 0x008fce000000004dULL,
0x0000004b004b7306ULL, 0x000ea20000202400ULL, 0x000054105b557816ULL, 0x002fce000000004cULL,
0x0000004a004a7306ULL, 0x000fe20000202400ULL, 0x000000541c2c723cULL, 0x000fe2000004182cULL,
0x000054105e5d7816ULL, 0x004fcc000000004bULL, 0x0000004900497306ULL, 0x000ff00000202400ULL,
0x0000004700477306ULL, 0x000ff00000202400ULL, 0x0000004f004f7306ULL, 0x000e700000202400ULL,
0x0000005000507306ULL, 0x000fe20000202400ULL, 0x000054104f527816ULL, 0x002fce0000000052ULL,
0x0000005900597306ULL, 0x000e620000202400ULL, 0x000000521c34723cULL, 0x000fee0000041834ULL,
0x0000005c005c7306ULL, 0x000ea20000202400ULL, 0x0000541050507816ULL, 0x002fce0000000059ULL,
0x0000006300637306ULL, 0x000fe20000202400ULL, 0x000000501c30723cULL, 0x000fe20000041830ULL,
0x000054105c5c7816ULL, 0x004fcc000000005fULL, 0x0000007200567306ULL, 0x000e620000202400ULL,
0x0000005c1c28723cULL, 0x000fee0000041828ULL, 0x0000005700577306ULL, 0x000ea20000202400ULL,
0x0000541063567816ULL, 0x002fce0000000056ULL, 0x0000006c00687306ULL, 0x000fe20000202400ULL,
0x0000541057577816ULL, 0x004fce000000004aULL, 0x0000006900697306ULL, 0x000e620000202400ULL,
0x000000561c24723cULL, 0x000fee0000041824ULL, 0x0000001a001a7306ULL, 0x000ea20000202400ULL,
0x0000541068487816ULL, 0x002fce0000000069ULL, 0x0000004500127306ULL, 0x000fe20000202400ULL,
0x000054101a497816ULL, 0x004fce0000000049ULL, 0x0000001300117306ULL, 0x000e620000202400ULL,
0x000000481c20723cULL, 0x000fee0000041820ULL, 0x0000001b00107306ULL, 0x000ea20000202400ULL,
0x0000541012127816ULL, 0x002fe40000000011ULL, 0x0000541010137816ULL, 0x004fce0000000047ULL,
0x000000121c14723cULL, 0x000fe20000041814ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xfffffff0003c0947ULL, 0x000fde000383ffffULL, 0x0000ffff09107812ULL, 0x000fe200078ec0ffULL,
0x00000008201a7220ULL, 0x080fe20000410000ULL, 0x0000000405207824ULL, 0x000fe200078e00ffULL,
0x0000000510097291ULL, 0x000fe2000f8e383fULL, 0x0000888010107816ULL, 0x000fe200000000ffULL,
0x0000000824187220ULL, 0x080fe20000410000ULL, 0x00000008211b7220ULL, 0x080fe20000410000ULL,
0x0000000838197220ULL, 0x080fe20000410000ULL, 0x0000000839397220ULL, 0x080fe20000410000ULL,
0x8000000010107824ULL, 0x000fe400078e00ffULL, 0x000000083a3a7220ULL, 0x080fe20000410000ULL,
0x000000083b3b7220ULL, 0x080fe20000410000ULL, 0x0000000834347220ULL, 0x080fe20000410000ULL,
0x01b61010ff0075a7ULL, 0x000e620008000148ULL, 0x0000000835357220ULL, 0x080fe20000410000ULL,
0x0000000836367220ULL, 0x080fe20000410000ULL, 0x0000000837377220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x0000000832327220ULL, 0x080fe20000410000ULL, 0x0000000833337220ULL, 0x080fe20000410000ULL,
0x000000082c2c7220ULL, 0x080fe20000410000ULL, 0x000000082d2d7220ULL, 0x080fe20000410000ULL,
0x000000082e2e7220ULL, 0x080fe20000410000ULL, 0x000000082f2f7220ULL, 0x080fe20000410000ULL,
0x0000000828287220ULL, 0x080fe20000410000ULL, 0x0000000829297220ULL, 0x080fe20000410000ULL,
0x000000082a2a7220ULL, 0x080fe20000410000ULL, 0x000000082b2b7220ULL, 0x080fe20000410000ULL,
0x0000000825257220ULL, 0x080fe20000410000ULL, 0x0000000826267220ULL, 0x080fe20000410000ULL,
0x0000000827277220ULL, 0x080fe20000410000ULL, 0x0000000822227220ULL, 0x080fe20000410000ULL,
0x0000000823237220ULL, 0x080fe20000410000ULL, 0x0000000814147220ULL, 0x080fe20000410000ULL,
0x0000000815157220ULL, 0x080fe20000410000ULL, 0x0000000816247220ULL, 0x080fe20000410000ULL,
0xfffffff020207812ULL, 0x000fe200078ec0ffULL, 0x0000000817217220ULL, 0x000fe20000410000ULL,
0x0000001400608947ULL, 0x002fec0003800000ULL, 0x01b4000920107984ULL, 0x0002a20008000c00ULL,
0x0000000c0f00720cULL, 0x000fda0003f05270ULL, 0x0000000400080947ULL, 0x002fea0003800000ULL,
0x00000002050f7824ULL, 0x000fe400078e00ffULL, 0x000000010d0e7824ULL, 0x000fc600078e0a0eULL,
0x000000060f0f7812ULL, 0x000fc800078ec0ffULL, 0x000000010f177812ULL, 0x040fe400078efcffULL,
0x000000080f1d7812ULL, 0x000fe400078efcffULL, 0x0000000e1700720cULL, 0x080fe40003f26070ULL,
0x000000100f177812ULL, 0x000fe400078efcffULL, 0x0000000e1d00720cULL, 0x080fe40003f06070ULL,
0x0000000e1700720cULL, 0x000fc40003fc6070ULL, 0x000000110f1d7812ULL, 0x040fe400078efcffULL,
0x000000180f177812ULL, 0x040fe400078efcffULL, 0x0000000e0f00720cULL, 0x080fe40003f46070ULL,
0x0000000e1d00720cULL, 0x080fe40003fa6070ULL, 0x0000000e1700720cULL, 0x000fe40003f66070ULL,
0x000000090f1f7812ULL, 0x000fc400078efcffULL, 0x000000190f1d7812ULL, 0x040fe400078efcffULL,
0x000000200f177812ULL, 0x000fe400078efcffULL, 0xff7fffff3a3a7808ULL, 0x000fe40005000000ULL,
0xff7fffff19197808ULL, 0x000fe40005000000ULL, 0xff7fffff3b3b7808ULL, 0x000fe40004800000ULL,
0xff7fffff39397808ULL, 0x000fc40004800000ULL, 0x0000000e1f00720cULL, 0x080fe40003f86070ULL,
0x0000000e1d00720cULL, 0x080fe40003f46070ULL, 0x0000000e1700720cULL, 0x000fe40003f26070ULL,
0x000000210f1d7812ULL, 0x040fe400078efcffULL, 0x000000280f177812ULL, 0x000fe400078efcffULL,
0xff7fffff36367808ULL, 0x000fc40004000000ULL, 0xff7fffff34347808ULL, 0x000fe40004000000ULL,
0xff7fffff37377808ULL, 0x000fe40006000000ULL, 0xff7fffff35357808ULL, 0x000fe40006000000ULL,
0x0000000e1d00720cULL, 0x080fe40003f06070ULL, 0x0000000e1700720cULL, 0x000fe40003f86070ULL,
0x000000290f1d7812ULL, 0x000fc400078efcffULL, 0x000000300f177812ULL, 0x000fe400078efcffULL,
0xff7fffff32327808ULL, 0x000fe40007000000ULL, 0xff7fffff30307808ULL, 0x000fe40007000000ULL,
0xff7fffff33337808ULL, 0x000fe40006800000ULL, 0xff7fffff31317808ULL, 0x000fe40006800000ULL,
0x0000000e1d00720cULL, 0x000fc40003fc6070ULL, 0x0000000e1700720cULL, 0x000fe40003fa6070ULL,
0x000000310f1d7812ULL, 0x040fe400078efcffULL, 0x000000380f177812ULL, 0x040fe400078efcffULL,
0x000000390f0f7812ULL, 0x000fe400078efcffULL, 0xff7fffff2e2e7808ULL, 0x000fe40005800000ULL,
0xff7fffff2c2c7808ULL, 0x000fc40005800000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL,
0xff7fffff2d2d7808ULL, 0x000fe40005000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL,
0xff7fffff28287808ULL, 0x000fe40004800000ULL, 0x0000000e1d00720cULL, 0x080fe40003f66070ULL,
0x0000000e1700720cULL, 0x000fc40003f46070ULL, 0x0000000e0f00720cULL, 0x000fe40003f26070ULL,
0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL, 0xff7fffff29297808ULL, 0x000fe40004000000ULL,
0xff7fffff26267808ULL, 0x000fe40006000000ULL, 0xff7fffff18187808ULL, 0x000fe40006000000ULL,
0xff7fffff27277808ULL, 0x000fc40007000000ULL, 0xff7fffff25257808ULL, 0x000fe40007000000ULL,
0xff7fffff22227808ULL, 0x000fe40006800000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL,
0xff7fffff23237808ULL, 0x000fe40005800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL,
0xff7fffff24247808ULL, 0x000fc40005000000ULL, 0xff7fffff14147808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40004800000ULL, 0xff7fffff15157808ULL, 0x000fce0004800000ULL,
0x0000001910107209ULL, 0x004fe20007810000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000003a110e7209ULL, 0x000fe40007810000ULL, 0x00000039100f7209ULL, 0x000fe40007810000ULL,
0x0000003b0e117209ULL, 0x000fe40007810000ULL, 0x000000340f0e7209ULL, 0x000fe40007810000ULL,
0x0000003611107209ULL, 0x000fc40007810000ULL, 0x000000350e0f7209ULL, 0x000fe40007810000ULL,
0x0000003710117209ULL, 0x000fe40007810000ULL, 0x000000300f0e7209ULL, 0x000fe40007810000ULL,
0x0000003211107209ULL, 0x000fe40007810000ULL, 0x000000310e0f7209ULL, 0x000fe40007810000ULL,
0x0000003310117209ULL, 0x000fc40007810000ULL, 0x0000002c0f0e7209ULL, 0x000fe40007810000ULL,
0x0000002e11107209ULL, 0x000fe40007810000ULL, 0x0000002d0e0f7209ULL, 0x000fe40007810000ULL,
0x0000002f10117209ULL, 0x000fe40007810000ULL, 0x000000280f0e7209ULL, 0x000fe40007810000ULL,
0x0000002a11107209ULL, 0x000fc40007810000ULL, 0x000000290e0f7209ULL, 0x000fe40007810000ULL,
0x0000002b10117209ULL, 0x000fe40007810000ULL, 0x000000180f0e7209ULL, 0x000fe40007810000ULL,
0x0000002611107209ULL, 0x000fe40007810000ULL, 0x000000250e0f7209ULL, 0x000fe40007810000ULL,
0x0000002710117209ULL, 0x000fc40007810000ULL, 0x0000001a0f0e7209ULL, 0x000fe40007810000ULL,
0x0000002211107209ULL, 0x000fe40007810000ULL, 0x0000001b0e0f7209ULL, 0x000fe40007810000ULL,
0x0000002310117209ULL, 0x000fe40007810000ULL, 0x000000ff09ff7812ULL, 0x000fe4000780c0ffULL,
0x000000140f0e7209ULL, 0x000fc40007810000ULL, 0x0000002411107209ULL, 0x000fe40007810000ULL,
0x00000001ff097807ULL, 0x000fe40000000000ULL, 0x000000150e0f7209ULL, 0x000fe40007810000ULL,
0x0000002110107209ULL, 0x000fe20007810000ULL, 0x0000000e04dc7947ULL, 0x000fec000b800000ULL,
0x0c401f000f0e7f89ULL, 0x000e6800000e0000ULL, 0x0c401f0010117f89ULL, 0x000ea800000e0000ULL,
0x0c401f00121d7f89ULL, 0x000ee800000e0000ULL, 0x0c401f00131c7f89ULL, 0x000f2200000e0000ULL,
0x0000000e0f167209ULL, 0x002fc40007810000ULL, 0x0000001110177209ULL, 0x004fc60007810000ULL,
0x0c201f0016117f89ULL, 0x000e6200000e0000ULL, 0x0000001d121d7209ULL, 0x008fc60007810000ULL,
0x0c201f00171e7f89ULL, 0x000ea200000e0000ULL, 0x0000001c130e7209ULL, 0x010fc60007810000ULL,
0x0c201f001d387f89ULL, 0x000ee800000e0000ULL, 0x0c201f000e0f7f89ULL, 0x00092200000e0000ULL,
0x0000001116107209ULL, 0x002fe40007810000ULL, 0x0000001e17117209ULL, 0x004fe40007810000ULL,
0x000000381d127209ULL, 0x008fce0007810000ULL, 0x3fb8aa3b10167820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b11417820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe40000000000ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010841ULL, 0x00000039001c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010816ULL, 0x0000001800397308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b1b1b7823ULL, 0x000fe20000010816ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010841ULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010841ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010841ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010841ULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b21217823ULL, 0x000fce0000010841ULL, 0x0000003500357308ULL, 0x000e700000000800ULL,
0x0000003a003a7308ULL, 0x000fe20000000800ULL, 0x000000343516723eULL, 0x002fce00000010ffULL,
0x0000003b003b7308ULL, 0x000ff00000000800ULL, 0x0000003600177308ULL, 0x000ff00000000800ULL,
0x0000003700187308ULL, 0x000e700000000800ULL, 0x0000002c00137308ULL, 0x0005e20000000800ULL,
0x000000171817723eULL, 0x002fce00000010ffULL, 0x0000002d00387308ULL, 0x0003e20000000800ULL,
0x00000004ff2c7e24ULL, 0x004fca000f8e00ffULL, 0x3f8000002c2c783eULL, 0x000fe400000010ffULL,
0x00000014003f7308ULL, 0x0005e60000000800ULL, 0x000000ffff2d7224ULL, 0x002fca00078e002cULL,
0x0000001500467308ULL, 0x0003e20000000800ULL, 0x000000191c14723eULL, 0x004fce00000010ffULL,
0x0000001b00447308ULL, 0x000fe20000000800ULL, 0x0000003a3b15723eULL, 0x002fe200000010ffULL,
0x0000000000007948ULL, 0x000fec0003800000ULL, 0x0000002c141c723cULL, 0x000fe200000418ffULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000003100317308ULL, 0x000e700000000800ULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x000000303118723eULL, 0x002fce00000010ffULL,
0x0000003300337308ULL, 0x000e700000000800ULL, 0x0000002e001b7308ULL, 0x000fe20000000800ULL,
0x000000323319723eULL, 0x002fce00000010ffULL, 0x0000002f00347308ULL, 0x000e700000000800ULL,
0x0000001a003d7308ULL, 0x0004e20000000800ULL, 0x0000001b341b723eULL, 0x002fce00000010ffULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x00000013381a723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b24137823ULL, 0x000fe20000010841ULL, 0x0000003d4424723eULL, 0x008fca00000010ffULL,
0x0000002c181c723cULL, 0x000fe2000004181cULL, 0x0000002900297308ULL, 0x000e700000000800ULL,
0x0000002500427308ULL, 0x000ea20000000800ULL, 0x000000282928723eULL, 0x002fce00000010ffULL,
0x0000002a00257308ULL, 0x0005f00000000800ULL, 0x0000002b00367308ULL, 0x000e620000000800ULL,
0x00000039422a723eULL, 0x004fce00000010ffULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x000000253629723eULL, 0x002fce00000010ffULL, 0x0000002700277308ULL, 0x000e700000000800ULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x00000026272b723eULL, 0x002fce00000010ffULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x0000003f4626723eULL, 0x000fe200000010ffULL,
0x0000002c281c723cULL, 0x000fec000004181cULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x000000222325723eULL, 0x002fce00000010ffULL, 0x00000021002e7308ULL, 0x000e640000000800ULL,
0x000000132e27723eULL, 0x002fe400000010ffULL, 0xfffffffc05137812ULL, 0x000fcc00078ec0ffULL,
0x0000002c242c723cULL, 0x000fee000004181cULL, 0x0000000fff1c7424ULL, 0x000fca00078e00ffULL,
0x000000131c237219ULL, 0x000fe400000006ffULL, 0x0000000f0e137209ULL, 0x010fd20007810000ULL,
0x001c1fff2c1c7589ULL, 0x00026200000e0000ULL, 0x0000000000227806ULL, 0x000fe200038e0100ULL,
0x00000000231e73a1ULL, 0x000eb000000e8000ULL, 0x00000000230473c4ULL, 0x000ee20000004000ULL,
0x00000000000a7886ULL, 0x000fc400038e0100ULL, 0x0000000a23ff7c12ULL, 0x004fda000f80401eULL,
0x0000000a04ec8947ULL, 0x00afea000b800000ULL, 0x001c1fff2e1d7589ULL, 0x0002a800000e0000ULL,
0x001c1fff1e1e7589ULL, 0x000ee800000e0000ULL, 0x001c1fff001f7589ULL, 0x00032400000e0000ULL,
0xfffffff8ff407812ULL, 0x000fe200078ee240ULL, 0x0000000510047291ULL, 0x000fe2000f8e583fULL,
0x000000033e237812ULL, 0x002fe200078ec0ffULL, 0x000000ffff307224ULL, 0x000fe200078e0014ULL,
0x0000000305ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000840227836ULL, 0x040fe20000000000ULL,
0x00000004232d7812ULL, 0x000fe200078efcffULL, 0x00000008400e7824ULL, 0x000fe200078e00ffULL,
0x00000007230f7812ULL, 0x000fe200078e7840ULL, 0x00000004ff2f7e24ULL, 0x000fe2000f8e00ffULL,
0x00000007232c7812ULL, 0x000fe200078e7822ULL, 0x0000000822237824ULL, 0x000fe200078e00ffULL,
0x000000072d217812ULL, 0x000fe200078e7840ULL, 0x000000ffff317224ULL, 0x000fe200078e0016ULL,
0x000000072d2e7812ULL, 0x000fe200078e7822ULL, 0x000110002f227836ULL, 0x000fe20000000000ULL,
0x0000000e0f0f7212ULL, 0x080fe200078efcffULL, 0x000000ffff327224ULL, 0x000fe200078e0018ULL,
0x0000000e21217212ULL, 0x000fe200078efcffULL, 0x000000ffff337224ULL, 0x000fe200078e001aULL,
0x000000232c2d7212ULL, 0x080fe200078efcffULL, 0x000000100f0e7824ULL, 0x100fe200078e0222ULL,
0x000000232e237212ULL, 0x000fe200078efcffULL, 0x0000001021217824ULL, 0x000fc400078e0222ULL,
0x000000ffff347224ULL, 0x000fe200078e0028ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x000000300e007844ULL, 0x0003e20000000200ULL, 0x000000ffff357224ULL, 0x000fe400078e002aULL,
0x000000ffff367224ULL, 0x000fe400078e0024ULL, 0x000000ffff377224ULL, 0x000fc400078e0026ULL,
0x000000102d2d7824ULL, 0x100fe400078e0222ULL, 0x000000ffff387224ULL, 0x000fe200078e0015ULL,
0x0000003421007844ULL, 0x0003e20000000200ULL, 0x000000ffff397224ULL, 0x000fe400078e0017ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0019ULL, 0x000000ffff3b7224ULL, 0x000fe400078e001bULL,
0x0000001023237824ULL, 0x000fc400078e0222ULL, 0x000000ffff187224ULL, 0x000fe200078e0029ULL,
0x000000382d007844ULL, 0x0003e20000000200ULL, 0x000000ffff197224ULL, 0x000fe400078e002bULL,
0x000000ffff1a7224ULL, 0x000fe400078e0025ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0027ULL,
0x00000001ff0f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff147224ULL, 0x000fe200078e000bULL,
0x0000001823007844ULL, 0x0003e80000000200ULL, 0x01b0001020008988ULL, 0x0003e80008000c09ULL,
0x01b2001c20008988ULL, 0x01c3e20008000c09ULL, 0x000000033c00720cULL, 0x000fe20003f06070ULL,
0x01b6080fffff79a7ULL, 0x0005e40008500008ULL, 0x000000ffff0f7224ULL, 0x004fd400078e003cULL,
0xffffffc0006c8947ULL, 0x022fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff297224ULL, 0x000fce00078e0028ULL, 0x00000009ff2b7e24ULL, 0x000fc8000f8e00ffULL,
0x000020292b0075a7ULL, 0x000262000806017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000b95dULL, 0x000fea0003900000ULL, 0x000020292b00b5a7ULL, 0x000e64000806007fULL,
0xfffffffc00e8b947ULL, 0x002fea000383ffffULL, 0xffffff10005c7947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fce00078e0020ULL, 0x0000000cff237e24ULL, 0x000fc8000f8e00ffULL,
0x01b60821230075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01b60821230095a7ULL, 0x000e64000802007fULL,
0xfffffffc00e89947ULL, 0x002fea000383ffffULL, 0xffffff1400ac7947ULL, 0x020fea000383ffffULL,
0x000000ffff207224ULL, 0x100fe400078e0025ULL, 0x000000ffff217224ULL, 0x000fce00078e0025ULL,
0x0000000dff237e24ULL, 0x000fc8000f8e00ffULL, 0x00000021230075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00000021230085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffff1800c07947ULL, 0x020fea000383ffffULL, 0x000000ffff337224ULL, 0x000fce00078e0032ULL,
0x00000009ff3f7e24ULL, 0x000fc8000f8e00ffULL, 0x000020333f0075a7ULL, 0x00026200080c017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000e95dULL, 0x000fea0003900000ULL,
0x000020333f00e5a7ULL, 0x000e6400080c007fULL, 0xfffffffc00e8e947ULL, 0x002fea000383ffffULL,
0xffffff3c00a47947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x104fe400078e0054ULL,
0x000000ffff217224ULL, 0x000fce00078e0054ULL, 0x0000000cff237e24ULL, 0x000fc8000f8e00ffULL,
0x01b62821230075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01b62821230095a7ULL, 0x000e64000802007fULL,
0xfffffffc00e89947ULL, 0x002fea000383ffffULL, 0xffffff4000407947ULL, 0x020fea000383ffffULL,
0x000000ffff207224ULL, 0x100fe400078e0025ULL, 0x000000ffff217224ULL, 0x000fce00078e0025ULL,
0x00000012ff237e24ULL, 0x000fc8000f8e00ffULL, 0x00000021230075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00000021230085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffff44002c7947ULL, 0x020fea000383ffffULL, 0x00000005ff097e24ULL, 0x006fc8000f8e00ffULL,
0x01b600ff090075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01b600ff090085a7ULL, 0x000e64000800007fULL,
0xfffffffc00e88947ULL, 0x002fea000383ffffULL, 0xffffffb800e87947ULL, 0x020fea000383ffffULL,
0x00000005ff097e24ULL, 0x006fe4000f8e00ffULL, 0x80000000ff107424ULL, 0x000fe400078e00ffULL,
0x80000000ff117424ULL, 0x000fc800078e00ffULL, 0x01b60011090075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01b60011090085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e08947ULL, 0x002fea000383ffffULL,
0xffffffbc003c7947ULL, 0x020fea000383ffffULL, 0x000000ffff117224ULL, 0x000fce00078e0010ULL,
0x00000008ff137e24ULL, 0x000fc8000f8e00ffULL, 0x01b61011130075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01b61011130085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffffe800807947ULL, 0x020fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff427224ULL, 0x000fe400078e000fULL, 0x00000002ff3f7424ULL, 0x000fe400078e00ffULL,
0x0000001fff447424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fce00078e00ffULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003f423d7389ULL, 0x0006e40000000044ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff427224ULL, 0x002fe400078e0010ULL, 0x00000002ff3f7424ULL, 0x000fe400078e00ffULL,
0x0000001fff447424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0e7224ULL, 0x004fce00078e003dULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003f423d7389ULL, 0x0002640000000044ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000000e0f167209ULL, 0x000fe20007810000ULL, 0x000000ffff427224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fce00078e003dULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003f423d7389ULL, 0x0002640000000044ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001110177209ULL, 0x000fe20007810000ULL, 0x000000ffff427224ULL, 0x000fe400078e0013ULL,
0x000000ffff1d7224ULL, 0x000fce00078e003dULL, 0x000000001f087348ULL, 0x000fea0003c00000ULL,
0x0c00003f423d7389ULL, 0x0002640000000044ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001d121d7209ULL, 0x000fe20007810000ULL, 0x000000ffff427224ULL, 0x000fe400078e0016ULL,
0x00000001ff3f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1c7224ULL, 0x000fce00078e003dULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003f423d7389ULL, 0x0002640000000044ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001c130e7209ULL, 0x000fe20007810000ULL,
0x000000ffff427224ULL, 0x000fe400078e0017ULL, 0x000000ffff117224ULL, 0x000fce00078e003dULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003f423d7389ULL, 0x0002640000000044ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001116107209ULL, 0x000fe20007810000ULL,
0x000000ffff427224ULL, 0x000fe400078e001dULL, 0x000000ffff1e7224ULL, 0x000fce00078e003dULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003f423d7389ULL, 0x0002640000000044ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001e17117209ULL, 0x000fe20007810000ULL,
0x000000ffff427224ULL, 0x000fe400078e000eULL, 0x000000ffff387224ULL, 0x000fce00078e003dULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0c00003f423d7389ULL, 0x0002640000000044ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000381d127209ULL, 0x000fe20007810000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e003dULL, 0xffffffec007c7947ULL, 0x020fec000383ffffULL,
0x0000007000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff0f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fce00078e0023ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0000000e2e1f7389ULL, 0x0006e4000000000fULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1d7224ULL, 0x004fe400078e001fULL,
0x000000ffff2e7224ULL, 0x002fe400078e001eULL, 0x000000ffff0e7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff0f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fce00078e0023ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0000000e2e1f7389ULL, 0x0006e4000000000fULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x004fe400078e001fULL,
0x000000ffff2e7224ULL, 0x002fe400078e0000ULL, 0x000000ffff0e7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff0f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fce00078e0023ULL,
0x000000001f087348ULL, 0x000fea0003c00000ULL, 0x0000000e2e1f7389ULL, 0x0006e4000000000fULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff000ac7947ULL, 0x026fea000383ffffULL, 0x018000000a027836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000002037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000000a00028308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000203ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff0aff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000203ff7212ULL, 0x000fe4000780c0ffULL,
0x800000000a037812ULL, 0x000fd600078ec0ffULL, 0x0080000003020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0003ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000a00027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x00cfe400078e0002ULL, 0x000000ffff027224ULL, 0x000fe400078e0005ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffee802e07950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001b680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000f8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000630ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000678ULL, 0x00000000000004fcULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b74ULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000b98ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000b98ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000bc8ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000c10ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000c18ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000c80ULL, 0x0000000000011580ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000012200ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000012210ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000012210ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000012210ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x00000000000128f8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000128f8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000c10ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000c80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000011580ULL, 0x0000000000011580ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000012200ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000012210ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_90_cubin_len = 76360;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
