/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000017910ULL, 0x0000000000017490ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000016050ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x00000000000161c0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000016200ULL, 0x0000000000000100ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000016300ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001605000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x00576c0400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001605000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080a90828808081ULL, 0x8808288080aa0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808088920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL,
0x000161c000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0xaa08288080a90828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080aa920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000016000000000ULL,
0x0001620000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x00081204000000f3ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005801600000000dULL, 0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0001510000183104ULL, 0x0001535000015340ULL,
0x000154d0000154c0ULL, 0x00e82904000154e0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001d0500001dULL, 0x0500001d0500001dULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000c000e82804ULL,
0x000018b0000000f0ULL, 0x000019e000001960ULL, 0x00002ed000001a10ULL, 0x0000462000002ef0ULL,
0x00004740000046c0ULL, 0x00005b4000004770ULL, 0x0000724000005b90ULL, 0x00007360000072e0ULL,
0x000086a000007390ULL, 0x00009ce000008730ULL, 0x00009e0000009d80ULL, 0x0000afd000009e30ULL,
0x0000c4100000b000ULL, 0x0000eef00000c420ULL, 0x0000f3f00000ef10ULL, 0x00014d600000f420ULL,
0x00014da000014d90ULL, 0x00014dd000014db0ULL, 0x00014e1000014df0ULL, 0x000154b000014e20ULL,
0x0001552000015510ULL, 0x00015b6000015530ULL, 0x00015c3000015bd0ULL, 0x00015ce000015c90ULL,
0x00015d8000015d30ULL, 0x00015e2000015dd0ULL, 0x00015ee000015e70ULL, 0x00015fc000015f60ULL,
0x03e0390400016020ULL, 0x000000ff00000170ULL, 0x003f01000000f600ULL, 0x0000000f000001b0ULL,
0x003f01300000f608ULL, 0x0000000f000001e0ULL, 0x003f01300000f610ULL, 0x0000000f00000210ULL,
0x003f01200000f648ULL, 0x0000000f00000240ULL, 0x003f01200000f668ULL, 0x000000ff00000460ULL,
0x003f01070000f600ULL, 0x0000003800000660ULL, 0x003f01020000f614ULL, 0x0000003800000780ULL,
0x003f01010000f610ULL, 0x000000ff00000ca0ULL, 0x0004010700000000ULL, 0x0000004200000d20ULL,
0x003f010100000020ULL, 0x0000004200000ea0ULL, 0x003f010600000024ULL, 0x0000004200000f50ULL,
0x003f010600000024ULL, 0x0000004200000fe0ULL, 0x003f010600000024ULL, 0x0000005900001640ULL,
0x0004010700000000ULL, 0x0000002b000016b0ULL, 0x0004010600000004ULL, 0x00000047000016d0ULL,
0x003f01060000f60cULL, 0x00000047000017d0ULL, 0x003f01060000f60cULL, 0x0000002b00001c80ULL,
0x0004010600000004ULL, 0x0000002b00001d20ULL, 0x0004010600000004ULL, 0x0000004200003d80ULL,
0x003f010100000020ULL, 0x0000000000003e00ULL, 0x003f010100000000ULL, 0x0000004200003eb0ULL,
0x003f010600000024ULL, 0x0000004200003f00ULL, 0x003f010600000024ULL, 0x0000004200003f90ULL,
0x003f010600000024ULL, 0x000000ff000043f0ULL, 0x0006010700000000ULL, 0x0000006700004460ULL,
0x003f010600000004ULL, 0x0000004700004480ULL, 0x003f01060000f61cULL, 0x0000004700004580ULL,
0x003f01060000f61cULL, 0x0000006200004a40ULL, 0x003f01060000f64cULL, 0x0000006200004af0ULL,
0x003f01060000f64cULL, 0x0000004200006990ULL, 0x003f010100000020ULL, 0x0000000000006a20ULL,
0x003f010100000000ULL, 0x0000004200006ac0ULL, 0x003f010600000024ULL, 0x0000004200006b20ULL,
0x003f010600000024ULL, 0x0000004200006bb0ULL, 0x003f010600000024ULL, 0x0000005900006ff0ULL,
0x0004010700000000ULL, 0x0000000000007060ULL, 0x003f010600000004ULL, 0x0000004700007080ULL,
0x003f01060000f62cULL, 0x00000047000071a0ULL, 0x003f01060000f62cULL, 0x0000000000007630ULL,
0x003f01060000f64cULL, 0x0000002500007710ULL, 0x003f010600000004ULL, 0x00000042000095b0ULL,
0x003f010100000020ULL, 0x0000000000009630ULL, 0x003f010100000000ULL, 0x00000042000096d0ULL,
0x003f010600000024ULL, 0x0000004200009720ULL, 0x003f010600000024ULL, 0x00000042000097b0ULL,
0x003f010600000024ULL, 0x000000ff00009ad0ULL, 0x0006010700000000ULL, 0x0000006700009b40ULL,
0x003f010600000004ULL, 0x0000004700009b60ULL, 0x003f01060000f63cULL, 0x0000004700009c40ULL,
0x003f01060000f63cULL, 0x000000000000a0e0ULL, 0x003f01060000f64cULL, 0x000000540000a170ULL,
0x003f010600000004ULL, 0x000000420000bf60ULL, 0x003f010100000020ULL, 0x000000470000bfc0ULL,
0x003f01010000f640ULL, 0x000000ff00010fb0ULL, 0x003f01060000f604ULL, 0x000000ff00011040ULL,
0x003f01060000f604ULL, 0x000000ff00011260ULL, 0x003f01010000f600ULL, 0x000000ff00011270ULL,
0x003f01060000f604ULL, 0x000000ff000112f0ULL, 0x003f01060000f604ULL, 0x0000004000014170ULL,
0x003f01060000f614ULL, 0x0000004000014640ULL, 0x003f01060000f614ULL, 0x0000004000015ab0ULL,
0x003f01010000f608ULL, 0x00141c0400053803ULL, 0x000102700000fe20ULL, 0x0001141000011340ULL,
0x0000040100015b10ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001ccULL, 0x0000001100000002ULL,
0x000000000000014cULL, 0x0000001100000002ULL, 0x00000000000000ccULL, 0x0000001100000002ULL,
0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001a2ULL, 0x0000001100000002ULL,
0x0000000000000122ULL, 0x0000001100000002ULL, 0x00000000000000a8ULL, 0x0000001100000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x00000004ff107424ULL, 0x000fe200078e00ffULL, 0x0000460000087ab9ULL, 0x000fe20000000a00ULL,
0x00005800ff3f7624ULL, 0x000fe200078e00ffULL, 0x0000000000037919ULL, 0x000e680000002200ULL,
0x0000000000077919ULL, 0x000ea80000002100ULL, 0x0000000000437919ULL, 0x000ee80000002700ULL,
0x00000000003e7919ULL, 0x000f220000002600ULL, 0x0000000106007824ULL, 0x002fc800078e0203ULL,
0x00000080000f7824ULL, 0x104fe200078e0207ULL, 0x00000005ff347819ULL, 0x000fe20000011607ULL,
0x00001fff06007589ULL, 0x00066600000e0000ULL, 0x000000ff0f00720cULL, 0x040fe40003f05270ULL,
0x000000030f00780cULL, 0x040fe20003f44070ULL, 0x00001fff34347589ULL, 0x000ea200000e0000ULL,
0x0000007f0f00780cULL, 0x000fe20003f24070ULL, 0x0000620043067625ULL, 0x008fe200078e0010ULL,
0x000000010f00780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL, 0x00f60002ff008388ULL, 0x0007e20000000a00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x3fffff80ff0aa424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0ba424ULL, 0x000fe200078e00ffULL, 0x00f608040f00a388ULL, 0x0007e2000000ca00ULL,
0x3fffffc0ff08a424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL,
0x00f6100a0f00a388ULL, 0x0007e2000000ca00ULL, 0xff317217ff0e9424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL, 0x00f648080f00a388ULL, 0x0007e20000008a00ULL,
0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL, 0x00f4000e0f009388ULL, 0x0007e80000004800ULL,
0x00f6680c0f00b388ULL, 0x0007e80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x01ce620000000000ULL,
0x0000000434047824ULL, 0x000fc400078e00ffULL, 0x000000103f027824ULL, 0x000fe400078e00ffULL,
0x000000103e037824ULL, 0x000fe400078e00ffULL, 0x00000100ff0e7424ULL, 0x000fe400078e00ffULL,
0x0000004302027224ULL, 0x000fe200078e0203ULL, 0x000000040d097211ULL, 0x042fe200078fe0ffULL,
0x000000100d047824ULL, 0x000fc600078e00ffULL, 0x00000002090b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000102037824ULL, 0x040fe200078e0209ULL, 0x0000000709057812ULL, 0x000fe400078ec0ffULL,
0x000000070b0c7812ULL, 0x000fe200078ec0ffULL, 0x00000001020a7824ULL, 0x000fe200078e020bULL,
0x000000f0040f7812ULL, 0x000fe200078ec0ffULL, 0x00005c0003027625ULL, 0x080fe200078e000eULL,
0x0000000f05087812ULL, 0x100fe400078e780dULL, 0x0000000f0c0c7812ULL, 0x000fe200078e780dULL,
0x00005c000a047625ULL, 0x000fe200078e000eULL, 0x0000000f02027210ULL, 0x000fc60007f1e0ffULL,
0x0000001009087824ULL, 0x000fe200078e0208ULL, 0x0000000f04047210ULL, 0x000fe20007f3e0ffULL,
0x000000100b0c7824ULL, 0x000fe400078e020cULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x0000001008097824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x000000100c0b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e8000b901c48ULL, 0x00000000040b7faeULL, 0x0003e8000b901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000806357981ULL, 0x014ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000004ff367e24ULL, 0x010fe2000f8e00ffULL, 0x0000007f35377810ULL, 0x004fc40007ffe0ffULL,
0x000000ff35397810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff377819ULL, 0x000fe40000011637ULL,
0x00000008ff397819ULL, 0x000fca0000011639ULL, 0x0000fd2000008947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe20000011634ULL, 0x0000001034387824ULL, 0x000fe400078e00ffULL,
0x00000003ff057424ULL, 0x00afe200078e00ffULL, 0x01ffffff00037812ULL, 0x000fe200078ec0ffULL,
0xffffffffff3a7424ULL, 0x000fc800078e00ffULL, 0x0000000236487824ULL, 0x000fca00078e0203ULL,
0x000000374800720cULL, 0x000fda0003f06070ULL, 0x0000000243008824ULL, 0x000fe400078e00ffULL,
0x00006400ff038624ULL, 0x000fc800078e00ffULL, 0x0000640000038624ULL, 0x000fc800078e0203ULL,
0x0000000148038824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6140538ff738cULL, 0x0003e20000000000ULL, 0x0000600003028625ULL, 0x000fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000008023a8981ULL, 0x0004e2000c1e1900ULL,
0x00000001343c7812ULL, 0x000fe200078ec0ffULL, 0x000000803e3e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff557819ULL, 0x000fe20000011634ULL, 0x00000000003b7919ULL, 0x000f220000000000ULL,
0x0000000136007810ULL, 0x000fe20007ffe0ffULL, 0x000000103c047824ULL, 0x000fe200078e00ffULL,
0x00000000550473c2ULL, 0x000f6200000e0000ULL, 0x00002000553d7824ULL, 0x000fe200078e00ffULL,
0x000000390000720cULL, 0x000fe20003f06070ULL, 0x0000000836027824ULL, 0x004fe200078e0255ULL,
0x00f6100038ff7f8cULL, 0x0005e2000c80043fULL, 0x000000803f3f7824ULL, 0x000fe200078e00ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000002002007824ULL, 0x000fe200078e00ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0xff317217ff407424ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x0000000035037217ULL, 0x000fe20007800000ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x0000f64855427811ULL, 0x000fe200078e18ffULL, 0x0000000103037824ULL, 0x100fe200078e0a00ULL,
0x000000603e007812ULL, 0x000fc400078ef800ULL, 0x00000003ff057819ULL, 0x012fe4000001163bULL,
0x0000002003037807ULL, 0x000fe20000000000ULL, 0x0000f64804047891ULL, 0x020fe2000f8e203fULL,
0x0000000405087810ULL, 0x040fe20007ffe0ffULL, 0x0000000104067824ULL, 0x000fe200078e0205ULL,
0x0000000c05107810ULL, 0x000fe40007ffe0ffULL, 0x0000000403037217ULL, 0x000fe20007800000ULL,
0x00000008060c7824ULL, 0x040fe200078e00ffULL, 0x0000003b06077212ULL, 0x000fe200078e3cffULL,
0x00000001040a7824ULL, 0x000fc400078e0208ULL, 0x0000000104127824ULL, 0x000fe200078e0210ULL,
0xfffffff80c077812ULL, 0x000fe200078ee207ULL, 0x000000080a097824ULL, 0x000fe200078e00ffULL,
0x00000008050c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000812147824ULL, 0x000fe200078e00ffULL,
0x0000003b0a027212ULL, 0x080fe400078e3cffULL, 0x0000003b120b7212ULL, 0x080fe200078e3cffULL,
0x00000001040e7824ULL, 0x000fe200078e020cULL, 0xfffffff809097812ULL, 0x000fe400078ee202ULL,
0xfffffff814157812ULL, 0x000fe200078ee20bULL, 0x000000080e0d7824ULL, 0x040fe200078e00ffULL,
0x0000003b0e027212ULL, 0x000fe200078e3cffULL, 0x00000001030b7824ULL, 0x000fe200078e0a04ULL,
0x0000007f06037812ULL, 0x000fe200078ec0ffULL, 0x00000080ff147424ULL, 0x000fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fc400078ee202ULL, 0x0000b0003d027810ULL, 0x000fe40007ffe0ffULL,
0x0000000b0500720cULL, 0x080fe40003f46070ULL, 0x0000007f0a057812ULL, 0x000fe200078ec0ffULL,
0x000000100d137824ULL, 0x100fe200078e0202ULL, 0x0000000b0800720cULL, 0x080fe20003f26070ULL,
0x000000103b0d7824ULL, 0x000fe200078e00ffULL, 0x0000000b0c00720cULL, 0x000fe20003f06070ULL,
0x00000010070f7824ULL, 0x100fe200078e0202ULL, 0x0000007f0e077812ULL, 0x000fe200078ec0ffULL,
0x0000001009117824ULL, 0x100fe200078e0202ULL, 0x0000007f12097812ULL, 0x000fe200078ec0ffULL,
0x0000001015157824ULL, 0x000fe200078e0202ULL, 0x000000700d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000003f3a007224ULL, 0x008fc800078e0200ULL, 0x0000000100037824ULL, 0x040fe400078e0203ULL,
0x0000000100057824ULL, 0x000fe400078e0205ULL, 0x00005e0003027625ULL, 0x000fc800078e0014ULL,
0x0000000100077824ULL, 0x000fe200078e0207ULL, 0x0000000d02027210ULL, 0x000fe20007f7e0ffULL,
0x0000000100097824ULL, 0x000fe400078e0209ULL, 0x00005e0005047625ULL, 0x000fc800078e0014ULL,
0x00005e0007067625ULL, 0x000fe200078e0014ULL, 0x0000000d040a7210ULL, 0x000fc60007f9e0ffULL,
0x00005e0009087625ULL, 0x000fe200078e0014ULL, 0x0000000d060c7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff037224ULL, 0x000fe200018e0603ULL, 0x0000000b1000720cULL, 0x000fe20003f66070ULL,
0x000000ffff0b7224ULL, 0x000fe200020e0605ULL, 0x0000000d08087210ULL, 0x000fe20007fde0ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020f7faeULL, 0x0005e2000d101c48ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x000000000a117faeULL, 0x0005e8000c901c48ULL, 0x000000000c137faeULL, 0x0005e2000c101c48ULL,
0x000000393600720cULL, 0x000fc60003f06070ULL, 0x0000000008157faeULL, 0x0005e8000d901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200042ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x004fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000b2c000000947ULL, 0x000fea0003800000ULL, 0x0000000243437824ULL, 0x002fe200078e00ffULL,
0x00007610ff717816ULL, 0x000fe20000000071ULL, 0x00006400ff007624ULL, 0x000fe200078e00ffULL,
0x00007610ff707816ULL, 0x000fe20000000070ULL, 0xff317217ff407424ULL, 0x000fe200078e00ffULL,
0x00007610ff447816ULL, 0x000fe20000000044ULL, 0x000000ffff727224ULL, 0x000fc400078e00ffULL,
0x0000640043437624ULL, 0x000fe400078e0200ULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0xffffffc038037812ULL, 0x000fca00078ec0ffULL, 0x0000010036007824ULL, 0x000fca00078e0203ULL,
0x000000350000720cULL, 0x000fda0003f06070ULL, 0x0000b19000000947ULL, 0x022fea0003800000ULL,
0x0000240042037984ULL, 0x000e620000000800ULL, 0x0000ffff71007812ULL, 0x000fe200078ec0ffULL,
0x000000ffff547224ULL, 0x000fe400078e0048ULL, 0x000000ffff457224ULL, 0x000fe200078e0072ULL,
0x0000888000027816ULL, 0x000fca00000000ffULL, 0x8000000002007824ULL, 0x000fca00078e00ffULL,
0x8000000003ff7812ULL, 0x002fe20007804800ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000761070567816ULL, 0x000fe40000000056ULL, 0x00007610719b7816ULL, 0x000fe2000000009bULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000240042037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000002037824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x0000240042027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007804803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000300ff577624ULL, 0x000fe200078e00ffULL, 0x0000000148007812ULL, 0x000fe200078ec0ffULL,
0x0000010036587824ULL, 0x000fe200078e00ffULL, 0x00000001ff557819ULL, 0x000fe40000011634ULL,
0x000000010000780cULL, 0x000fe40003f05070ULL, 0xffffffff57577811ULL, 0x000fe200078e08ffULL,
0x0000002055007824ULL, 0x000fc600078e0258ULL, 0x0000000157577807ULL, 0x000fe40004000000ULL,
0x0000004000007810ULL, 0x000fc60007ffe0ffULL, 0x0000000148487824ULL, 0x000fe200078e0257ULL,
0x000000603e027812ULL, 0x000fc800078ef800ULL, 0x000000374800720cULL, 0x000fe20003f06070ULL,
0x0000003f3a277224ULL, 0x000fe200078e0202ULL, 0x00000003ff2b7819ULL, 0x000fe2000001163bULL,
0xffffffffff3a7424ULL, 0x000fe200078e00ffULL, 0x0000001038267812ULL, 0x000fe400078ec0ffULL,
0x000000042b2f7810ULL, 0x000fce0007ffe0ffULL, 0x0000005743038210ULL, 0x000fe20007ffe054ULL,
0x00000004ff248424ULL, 0x000fe200078e00ffULL, 0x0000000035257217ULL, 0x000fe20007800000ULL,
0x000000012b287824ULL, 0x000fe400078e0226ULL, 0x0000600003028625ULL, 0x000fe200078e0024ULL,
0x0000000136247810ULL, 0x000fc60007ffe0ffULL, 0x000000012f4a7824ULL, 0x000fe200078e0226ULL,
0x00000008023a8981ULL, 0x000362000c1e1900ULL, 0x0000007f28497812ULL, 0x000fe200078ec0ffULL,
0x0000000125257824ULL, 0x000fe200078e0a00ULL, 0x000000392400720cULL, 0x000fe20003f06070ULL,
0x00000080ff2c7424ULL, 0x000fe200078e00ffULL, 0x0000003b4a697212ULL, 0x080fe200078e3cffULL,
0x000000103b4f7824ULL, 0x000fe200078e00ffULL, 0x000000082b317810ULL, 0x000fe20007ffe0ffULL,
0x00000008285a7824ULL, 0x000fe200078e00ffULL, 0x0000002025257807ULL, 0x000fe20000000000ULL,
0x000000084a027824ULL, 0x002fe200078e00ffULL, 0x0000003b28297212ULL, 0x080fe200078e3cffULL,
0x00000001312a7824ULL, 0x000fe200078e0226ULL, 0x000000704f2d7812ULL, 0x000fe200078ec0ffULL,
0x0000000834627824ULL, 0x000fe200078e00ffULL, 0xfffffff802697812ULL, 0x000fe200078ee269ULL,
0x0000000127027824ULL, 0x000fe200078e0249ULL, 0x0000002625257217ULL, 0x000fe20007800000ULL,
0x0000000434477824ULL, 0x000fe200078e00ffULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee229ULL,
0x00005e0002027625ULL, 0x000fe200078e002cULL, 0x0000003b2a6a7212ULL, 0x000fc400078e3cffULL,
0x0000000c2b337810ULL, 0x000fe20007ffe0ffULL, 0x000000082a297824ULL, 0x000fe200078e00ffULL,
0x0000002d02287210ULL, 0x000fe20007f1e0ffULL, 0x0000000125007824ULL, 0x100fe200078e0a26ULL,
0xfffffff062627812ULL, 0x000fe200078ec0ffULL, 0x00000001334c7824ULL, 0x000fe200078e0226ULL,
0xfffffff8296a7812ULL, 0x000fe200078ee26aULL, 0x000000ffff297224ULL, 0x000fe200000e0603ULL,
0x000000002b00720cULL, 0x000fe20003f06070ULL, 0x00000008722b7824ULL, 0x000fe200078e00ffULL,
0x0000003b4c6b7212ULL, 0x040fe200078e3cffULL, 0x000000084c247824ULL, 0x000fe200078e00ffULL,
0x00000000620473c2ULL, 0x000e6200000e0000ULL, 0x0000100072027824ULL, 0x000fe200078e00ffULL,
0x000000082b597812ULL, 0x000fc400078e0cffULL, 0x0000007f4a4a7812ULL, 0x000fe400078ec0ffULL,
0xfffffff8246b7812ULL, 0x000fe400078ee26bULL, 0x00000000590573c2ULL, 0x000ea200000e0000ULL,
0x0000100002247812ULL, 0x000fe200078e0cffULL, 0x0000000127027824ULL, 0x000fe200078e024aULL,
0x0000007f2a4b7812ULL, 0x000fe400078ec0ffULL, 0x0000007f4c4c7812ULL, 0x000fe200078ec0ffULL,
0x00005e0002027625ULL, 0x000fe200078e002cULL, 0x000000002f00720cULL, 0x000fc40003f26070ULL,
0x000000003300720cULL, 0x000fe20003f66070ULL, 0x0000000127257824ULL, 0x040fe200078e024bULL,
0x0000002d02027210ULL, 0x080fe20007f5e0ffULL, 0x0000000127277824ULL, 0x000fe200078e024cULL,
0xfffffff047477812ULL, 0x000fe200078ec0ffULL, 0x00002000552a7824ULL, 0x000fe400078e0224ULL,
0x00005e0025247625ULL, 0x080fe200078e002cULL, 0x0000f64804047890ULL, 0x002fe4000fffe03fULL,
0x0000b0002a2a7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0027267625ULL, 0x000fe200078e002cULL,
0x0000002d24247210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff037224ULL, 0x000fe200010e0603ULL,
0x000000003100720cULL, 0x000fe20003f46070ULL, 0x000000105a5a7824ULL, 0x100fe200078e022aULL,
0x0000002d26267210ULL, 0x000fe20007fbe0ffULL, 0x00000010695b7824ULL, 0x100fe200078e022aULL,
0x0000000504057290ULL, 0x004fe2000fffe03fULL, 0x000000ffff257224ULL, 0x000fe200020e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000285a7faeULL, 0x0003e2000c101c48ULL,
0x000000106a5c7824ULL, 0x100fe400078e022aULL, 0x000000ffff277224ULL, 0x000fe200028e0627ULL,
0x00000000025b7faeULL, 0x0003e2000c901c48ULL, 0x000000106b5d7824ULL, 0x000fc600078e022aULL,
0x00000000245c7faeULL, 0x0003e8000d101c48ULL, 0x00000000265d7faeULL, 0x0003e8000d901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000004042b037984ULL, 0x0022a20008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f60c0047257984ULL, 0x000ee20000000800ULL,
0x0000ffff70007812ULL, 0x000fc400078ec0ffULL, 0x0000ffff44027812ULL, 0x000fe400078ec0ffULL,
0x0000888000287816ULL, 0x000fe400000000ffULL, 0x00008880024d7816ULL, 0x000fc600000000ffULL,
0x8000000028007824ULL, 0x000fe400078e00ffULL, 0x800000004d027824ULL, 0x000fc600078e00ffULL,
0x8000000003ff7812ULL, 0x004fe40007804800ULL, 0x8000000025ff7812ULL, 0x008fe20007824802ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x800000004d037824ULL, 0x000fe400078e00ffULL,
0x0000000000027305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000020000735dULL, 0x008fe40003800000ULL, 0x00f60c0047027984ULL, 0x000ea40000000800ULL,
0x8000000002ff7812ULL, 0x004fc40007824803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x00000020344e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff507819ULL, 0x000fe2000001163bULL, 0x00000001ff517424ULL, 0x000fe200078e00ffULL,
0x000000704f4f7812ULL, 0x000fe400078ec0ffULL, 0xffffff804e4e7812ULL, 0x000fe400078ec0ffULL,
0x0000000c50507812ULL, 0x000fc800078ec0ffULL, 0x0000004e50007210ULL, 0x000fca0007ffe04fULL,
0x00f0000000037984ULL, 0x000ea80000000800ULL, 0x00f2000000027984ULL, 0x0007220000000800ULL,
0x000000400300720bULL, 0x004fda0003f3d000ULL, 0x0000000000247806ULL, 0x000fc800008e0100ULL,
0x0000ffff24297812ULL, 0x000fda000782c0ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000400300720bULL, 0x018fe40003f34000ULL, 0x00000003402a7209ULL, 0x040fe40007810000ULL,
0x00000002ff257819ULL, 0x000fe40000011634ULL, 0x00000002ff267819ULL, 0x000fe2000001163bULL,
0x8000002a40007221ULL, 0x100fe20000010000ULL, 0x000000ffff407224ULL, 0x000fe400078e002aULL,
0x0000000826277810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b00247820ULL, 0x000fc40000410000ULL,
0x0000000000007806ULL, 0x000fe400008e0100ULL, 0x000000342500720cULL, 0x000fe40003f25270ULL,
0x0000ffff00007812ULL, 0x000fe200078e3cffULL, 0x0000002400247308ULL, 0x000ea60000000800ULL,
0x0000000029ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff517807ULL, 0x000fc60001000000ULL,
0x0000008034259824ULL, 0x000fc800078e024fULL, 0x0000000150259824ULL, 0x000fe200078e0225ULL,
0x00001f2724277589ULL, 0x004ea200000e0000ULL, 0x8000002a03032221ULL, 0x000fe20000010000ULL,
0x0000002441417220ULL, 0x000fe40000410000ULL, 0x00001f2624267589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b03032820ULL, 0x000fc60000410000ULL, 0x00f4002a25009388ULL, 0x0009e20000000800ULL,
0x0000000300462308ULL, 0x000e620000000800ULL, 0x0000002707077220ULL, 0x084fe20000410000ULL,
0x0000002706067220ULL, 0x080fe20000410000ULL, 0x0000002723237220ULL, 0x080fe20000410000ULL,
0x0000002722227220ULL, 0x080fe20000410000ULL, 0x000000271f1f7220ULL, 0x080fe20000410000ULL,
0x000000271e1e7220ULL, 0x080fe20000410000ULL, 0x000000271b1b7220ULL, 0x080fe20000410000ULL,
0x000000271a1a7220ULL, 0x080fe20000410000ULL, 0x0000002717177220ULL, 0x080fe20000410000ULL,
0x0000002716167220ULL, 0x080fe20000410000ULL, 0x0000002713137220ULL, 0x080fe20000410000ULL,
0x0000002712127220ULL, 0x080fe20000410000ULL, 0x000000270f0f7220ULL, 0x080fe20000410000ULL,
0x000000270e0e7220ULL, 0x080fe20000410000ULL, 0x000000270b0b7220ULL, 0x080fe20000410000ULL,
0x000000270a0a7220ULL, 0x000fe20000410000ULL, 0x0000002605057220ULL, 0x088fe20000410000ULL,
0x0000002604047220ULL, 0x080fe20000410000ULL, 0x0000002621217220ULL, 0x080fe20000410000ULL,
0x0000002620207220ULL, 0x080fe20000410000ULL, 0x000000261d1d7220ULL, 0x080fe20000410000ULL,
0x000000261c1c7220ULL, 0x080fe20000410000ULL, 0x0000002619197220ULL, 0x080fe20000410000ULL,
0x0000002618187220ULL, 0x080fe20000410000ULL, 0x0000002615157220ULL, 0x080fe20000410000ULL,
0x0000002614147220ULL, 0x080fe20000410000ULL, 0x0000002611117220ULL, 0x080fe20000410000ULL,
0x0000002610107220ULL, 0x080fe20000410000ULL, 0x000000260d0d7220ULL, 0x080fe20000410000ULL,
0x000000260c0c7220ULL, 0x080fe20000410000ULL, 0x0000002609097220ULL, 0x080fe20000410000ULL,
0x0000002608087220ULL, 0x000fe20000410000ULL, 0x0000004602022220ULL, 0x002fc80000410000ULL,
0x0000004102417221ULL, 0x018fe20000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x000004042b007984ULL, 0x000ea20008000800ULL, 0x8000000028037824ULL, 0x000fca00078e00ffULL,
0x8000000000ff7812ULL, 0x004fe20007804803ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000028037824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000020000735dULL, 0x008fe40003800000ULL,
0x000004042b027984ULL, 0x000ea40008000800ULL, 0x8000000002ff7812ULL, 0x004fc40007804803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000434027824ULL, 0x040fe200078e00ffULL, 0x000000083b007812ULL, 0x000fe200078ec0ffULL,
0x0000100034037824ULL, 0x040fe200078e00ffULL, 0x0000991051ea7816ULL, 0x000fe200000000ffULL,
0x0000000234517824ULL, 0x000fe200078e00ffULL, 0x0000000402027812ULL, 0x000fe400078ec0ffULL,
0xffffe00003037812ULL, 0x000fe400078ec0ffULL, 0x0000000700257812ULL, 0x000fe400078ec83bULL,
0x000000023b247211ULL, 0x000fe200078fe0ffULL, 0x0000100072037824ULL, 0x000fe200078e0203ULL,
0x0000000700007812ULL, 0x000fe200078ef83bULL, 0x0000100072027824ULL, 0x000fe200078e023dULL,
0x00000024255f7212ULL, 0x000fc400078e3cffULL, 0x0000b00003277810ULL, 0x000fe40007ffe0ffULL,
0x00000080002c7811ULL, 0x040fe200078e18ffULL, 0x00000008005e7824ULL, 0x000fe200078e025fULL,
0x0000b000022e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000224247810ULL, 0x000fe20007ffe0ffULL,
0x000000105e287824ULL, 0x000fe200078e0227ULL, 0x0000000451e87812ULL, 0x000fe200078ec0ffULL,
0x000000015f5f7824ULL, 0x000fe200078e022cULL, 0x0000002425617212ULL, 0x000fc400078e3cffULL,
0x000000e83b517211ULL, 0x000fe200078fe0ffULL, 0x000000002828783bULL, 0x002e620000004200ULL,
0x000000105f307824ULL, 0x000fe200078e022eULL, 0x000000ffea00720cULL, 0x000fe20003f45270ULL,
0x0000000800607824ULL, 0x000fe200078e0261ULL, 0x0000000251eb7810ULL, 0x000fe20007ffe0ffULL,
0x0000000161617824ULL, 0x000fe400078e022cULL, 0x000000003030783bULL, 0x000fe20000004200ULL,
0x0000001060277824ULL, 0x000fe400078e0227ULL, 0x00000010612e7824ULL, 0x000fc800078e022eULL,
0x000000002724783bULL, 0x000ea80000004200ULL, 0x000000002e2c783bULL, 0x000ee20000004200ULL,
0x0001000028a97824ULL, 0x042fe200078e00ffULL, 0x00000018ffd87819ULL, 0x000fe20000011428ULL,
0x0000010028ab7824ULL, 0x000fe200078e00ffULL, 0x0000002900e27306ULL, 0x000fe20000009400ULL,
0x0000010029c67824ULL, 0x040fe200078e00ffULL, 0x00000018ffa97819ULL, 0x000fe200000114a9ULL,
0x0001000029d67824ULL, 0x000fe200078e00ffULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x000001002ac87824ULL, 0x040fe200078e00ffULL, 0x00000018ffc67819ULL, 0x000fe200000114c6ULL,
0x000001002bc77824ULL, 0x040fe200078e00ffULL, 0x000000a900e57306ULL, 0x000fe20000209400ULL,
0x00000018ffd67819ULL, 0x000fe200000114d6ULL, 0x000100002ac97824ULL, 0x000fe200078e00ffULL,
0x00000018ffc57819ULL, 0x000fe20000011429ULL, 0x000100002bc37824ULL, 0x000fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x0000010024d27824ULL, 0x004fe200078e00ffULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x000000a900e67306ULL, 0x0002a20000205400ULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x0000010032887824ULL, 0x000fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe2000001142aULL, 0x0000010030977824ULL, 0x000fe200078e00ffULL,
0x00000018ffb87819ULL, 0x000fe2000001142bULL, 0x00000100319a7824ULL, 0x040fe200078e00ffULL,
0x00000018ffc37819ULL, 0x000fe200000114c3ULL, 0x000000ab00e47306ULL, 0x000fe20000209400ULL,
0x000000a900a97245ULL, 0x002fe2000020d400ULL, 0x0001000032807824ULL, 0x000fe200078e00ffULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x00010000309d7824ULL, 0x000fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe20000011426ULL, 0x00010000319e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff957819ULL, 0x000fe20000011427ULL, 0x000000ab00e97306ULL, 0x0003220000205400ULL,
0x000000e6e500720bULL, 0x004fe20003f1d000ULL, 0x0001000024e57824ULL, 0x000fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe20000011430ULL, 0x00010000337a7824ULL, 0x040fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe20000011431ULL, 0x0000010033837824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe20000011488ULL, 0x000000c600de7306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x002fc4000020d400ULL, 0x00000018ff977819ULL, 0x000fe40000011497ULL,
0x00000018ff9a7819ULL, 0x000fe4000001149aULL, 0x00000001a9a90812ULL, 0x000fe200078efcffULL,
0x000000c600e17306ULL, 0x0002a20000205400ULL, 0x000000e9e400720bULL, 0x010fe20003f3d000ULL,
0x0000020034e97824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x00000018ff9d7819ULL, 0x000fc4000001149dULL, 0xfffff800e9ea7812ULL, 0x000fe200078ec0ffULL,
0x0000002900df7306ULL, 0x000f220000005400ULL, 0x000000c600c67245ULL, 0x002fe4000020d400ULL,
0x00000018ff757819ULL, 0x000fe40000011432ULL, 0x00000018ff9e7819ULL, 0x000fe4000001149eULL,
0x00000001abab1812ULL, 0x000fe200078efcffULL, 0x000000d800e07306ULL, 0x000fe20000209400ULL,
0x000000e1de00720bULL, 0x004fc40003fdd000ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x00000018ff6e7819ULL, 0x000fe40000011433ULL, 0x00000018ff837819ULL, 0x000fe20000011483ULL,
0x000000d800e37306ULL, 0x000e620000205400ULL, 0x000000dfe200720bULL, 0x010fe40003fbd000ULL,
0x00000018ffdf7819ULL, 0x000fc600000114e5ULL, 0x00000001c6c66812ULL, 0x000fe400078efcffULL,
0x000000d600dc7306ULL, 0x000ff00000209400ULL, 0x000000d600dd7306ULL, 0x000ea20000205400ULL,
0x000000e3e000720bULL, 0x002fce0003f9d000ULL, 0x0000002a00c27306ULL, 0x000ff00000009400ULL,
0x0000002a00d57306ULL, 0x000e620000005400ULL, 0x000000dddc00720bULL, 0x004fce0003f1d000ULL,
0x0000002800527306ULL, 0x000ff00000009400ULL, 0x0000002800e77306ULL, 0x000ea20000005400ULL,
0x000000d5c200720bULL, 0x002fe20003f3d000ULL, 0x0001000025d57824ULL, 0x000fe200078e00ffULL,
0x000000d800c27245ULL, 0x000fc8000020d400ULL, 0x00000001c2c24812ULL, 0x000fe200078efcffULL,
0x000000c500cf7306ULL, 0x000fe20000209400ULL, 0x00000018ffd57819ULL, 0x000fce00000114d5ULL,
0x000000c500ca7306ULL, 0x0003220000205400ULL, 0x000000e75200720bULL, 0x004fe20003f7d000ULL,
0x0000010025e77824ULL, 0x000fe200078e00ffULL, 0x000000073b527812ULL, 0x000fc800078ec0ffULL,
0x00000018ffe47819ULL, 0x000fe200000114e7ULL, 0x0000002900037306ULL, 0x0004e2000000d400ULL,
0x000000c500c57245ULL, 0x002fe4000020d400ULL, 0x0000000852527812ULL, 0x000fc800078ef83bULL,
0x0000000751517812ULL, 0x000fe200078e7852ULL, 0x0000003000d17306ULL, 0x000fe20000009400ULL,
0x000000cacf00720bULL, 0x010fe40003fdd000ULL, 0x00000018ff297819ULL, 0x004fe20000011424ULL,
0x0000000852517824ULL, 0x000fe200078e0251ULL, 0x00000007ebeb7812ULL, 0x000fc600078e7852ULL,
0x0000003000c47306ULL, 0x000e620000005400ULL, 0x0000000103035812ULL, 0x008fe200078efcffULL,
0x0000000852eb7824ULL, 0x000fe400078e02ebULL, 0x0000001051517824ULL, 0x100fe200078e02eaULL,
0x00000003c603723eULL, 0x000fe200000010ffULL, 0x00000010eb527824ULL, 0x000fe200078e02eaULL,
0x00000001c5c56812ULL, 0x000fe200078efcffULL, 0x000000c800ce7306ULL, 0x000ff00000209400ULL,
0x000000c800d37306ULL, 0x0004e20000205400ULL, 0x000000c4d100720bULL, 0x002fe20003f9d000ULL,
0x0001000026d17824ULL, 0x000fe200078e00ffULL, 0x000000d600c47245ULL, 0x000fc8000020d400ULL,
0x00000001c4c40812ULL, 0x000fe200078efcffULL, 0x000000c700d47306ULL, 0x000fe20000209400ULL,
0x000000c800c87245ULL, 0x004fe4000020d400ULL, 0x00000018ffd17819ULL, 0x000fca00000114d1ULL,
0x000000c700d77306ULL, 0x0002a20000205400ULL, 0x000000d3ce00720bULL, 0x008fe20003fbd000ULL,
0x0000010026ce7824ULL, 0x000fe400078e00ffULL, 0x0000010027d37824ULL, 0x000fc600078e00ffULL,
0x00000018ffce7819ULL, 0x000fe200000114ceULL, 0x0000002800027306ULL, 0x000722000000d400ULL,
0x000000c700c77245ULL, 0x002fe4000020d400ULL, 0x00000018ffd37819ULL, 0x000fc600000114d3ULL,
0x00000001c8c85812ULL, 0x000fe400078efcffULL, 0x0000002b00d97306ULL, 0x000fe20000009400ULL,
0x000000d7d400720bULL, 0x004fe20003f1d000ULL, 0x0001000027d47824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x008fc80000011425ULL, 0x00000018ffd47819ULL, 0x000fe200000114d4ULL,
0x0000002b00da7306ULL, 0x000e620000005400ULL, 0x0000000102023812ULL, 0x010fc800078efcffULL,
0x00000002ab02723eULL, 0x000fe400000010ffULL, 0x00000001c7c70812ULL, 0x000fe200078efcffULL,
0x000000c900cb7306ULL, 0x000ff00000209400ULL, 0x000000c900d07306ULL, 0x000ea20000205400ULL,
0x000000dad900720bULL, 0x002fce0003f7d000ULL, 0x000000bd00be7306ULL, 0x000ff00000209400ULL,
0x000000bd00c17306ULL, 0x0002e20000205400ULL, 0x000000d0cb00720bULL, 0x004fce0003fdd000ULL,
0x0000002a00877306ULL, 0x000ea2000000d400ULL, 0x000000bd00bd7245ULL, 0x002fce000020d400ULL,
0x000000b800c07306ULL, 0x000fe20000209400ULL, 0x000000c1be00720bULL, 0x008fe20003fbd000ULL,
0x000001002dc17824ULL, 0x040fe200078e00ffULL, 0x000000c900be7245ULL, 0x000fe2000020d400ULL,
0x000100002dc97824ULL, 0x000fc600078e00ffULL, 0x00000001bebe6812ULL, 0x000fe200078efcffULL,
0x000000b800bf7306ULL, 0x0002e20000205400ULL, 0x0000000187871812ULL, 0x004fe400078efcffULL,
0x00000018ffc97819ULL, 0x000fc600000114c9ULL, 0x00000001bdbd5812ULL, 0x000fe400078efcffULL,
0x000000c300cc7306ULL, 0x000fe20000209400ULL, 0x000000b800b87245ULL, 0x002fce000020d400ULL,
0x000000c300cd7306ULL, 0x0002a20000205400ULL, 0x000000bfc000720bULL, 0x008fe20003f3d000ULL,
0x000001002cbf7824ULL, 0x000fcc00078e00ffULL, 0x0000002b00867306ULL, 0x000ee2000000d400ULL,
0x000000c300c37245ULL, 0x002fca000020d400ULL, 0x00000001b8b81812ULL, 0x000fe400078efcffULL,
0x0000002400ba7306ULL, 0x000fe20000009400ULL, 0x000000cdcc00720bULL, 0x004fce0003f1d000ULL,
0x0000002400b97306ULL, 0x000e620000005400ULL, 0x0000000186863812ULL, 0x008fca00078efcffULL,
0x00000001c3c30812ULL, 0x000fe400078efcffULL, 0x000000d200db7306ULL, 0x000ff00000209400ULL,
0x000000d200e87306ULL, 0x000ea20000205400ULL, 0x000000b9ba00720bULL, 0x002fc40003fdd000ULL,
0x0000002900ba7245ULL, 0x000fca000020d400ULL, 0x0000002400797306ULL, 0x000e70000000d400ULL,
0x000000e400e77306ULL, 0x000fe20000209400ULL, 0x000000e8db00720bULL, 0x004fce0003f7d000ULL,
0x000000e400247306ULL, 0x000ea20000205400ULL, 0x0000000179796812ULL, 0x002fce00078efcffULL,
0x0000002500b67306ULL, 0x000ff00000009400ULL, 0x0000002500b77306ULL, 0x000e620000005400ULL,
0x00000024e700720bULL, 0x004fce0003fbd000ULL, 0x0000002500787306ULL, 0x000eb0000000d400ULL,
0x000000df00de7306ULL, 0x000fe20000209400ULL, 0x000000b7b600720bULL, 0x002fe40003f1d000ULL,
0x000000d200b67245ULL, 0x000fc4000020d400ULL, 0x000000e400b77245ULL, 0x000fe4000020d400ULL,
0x00000001b6b63812ULL, 0x000fe200078efcffULL, 0x000000df00257306ULL, 0x000e620000205400ULL,
0x00000001b7b75812ULL, 0x000fca00078efcffULL, 0x0000000178780812ULL, 0x004fe400078efcffULL,
0x0000002600b57306ULL, 0x000ff00000009400ULL, 0x0000002600b47306ULL, 0x000ea20000005400ULL,
0x00000025de00720bULL, 0x002fce0003f3d000ULL, 0x0000002900bc7306ULL, 0x000ff00000209400ULL,
0x0000002900bb7306ULL, 0x000e620000205400ULL, 0x000000b4b500720bULL, 0x004fe40003fdd000ULL,
0x000000df00b57245ULL, 0x000fc4000020d400ULL, 0x000000d500b47245ULL, 0x000fe4000020d400ULL,
0x00000001b5b51812ULL, 0x000fe200078efcffULL, 0x000000d500ca7306ULL, 0x000ff00000209400ULL,
0x000000d500cf7306ULL, 0x000ea20000205400ULL, 0x000000bbbc00720bULL, 0x002fc40003f7d000ULL,
0x00000002ffbb7819ULL, 0x000fca000001163bULL, 0x00000026006f7306ULL, 0x000e6c000000d400ULL,
0x00000001baba3812ULL, 0x000fe400078efcffULL, 0x0000002700b07306ULL, 0x000fe20000009400ULL,
0x000000cfca00720bULL, 0x004fe20003fbd000ULL, 0x000001002eca7824ULL, 0x000fca00078e00ffULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x0000002700b17306ULL, 0x000fe20000005400ULL,
0x000000016f6f6812ULL, 0x002fca00078efcffULL, 0x00000001b4b45812ULL, 0x000fe400078efcffULL,
0x00000027006d7306ULL, 0x000ff0000000d400ULL, 0x000000ce00267306ULL, 0x000ff00000209400ULL,
0x000000ce00277306ULL, 0x000e700000205400ULL, 0x0000003100b27306ULL, 0x000ff00000009400ULL,
0x0000003100b37306ULL, 0x000ea20000005400ULL, 0x000000272600720bULL, 0x002fce0003f3d000ULL,
0x000000d300b97306ULL, 0x000ff00000209400ULL, 0x000000d300c07306ULL, 0x000e620000205400ULL,
0x000000b3b200720bULL, 0x004fe40003f7d000ULL, 0x000000ce00b27245ULL, 0x000fc4000020d400ULL,
0x0000002800b37245ULL, 0x000fe4000020d400ULL, 0x00000001b2b21812ULL, 0x000fe200078efcffULL,
0x00000028002a7306ULL, 0x000fe20000209400ULL, 0x000000b1b000720bULL, 0x000fe40003f3d000ULL,
0x000000d300b07245ULL, 0x000fe4000020d400ULL, 0x000000d400b17245ULL, 0x000fe4000020d400ULL,
0x0000006fb2b2723eULL, 0x000fe200000010ffULL, 0x00000028002b7306ULL, 0x000ea20000205400ULL,
0x000000c0b900720bULL, 0x002fca0003fbd000ULL, 0x000000016d6d1812ULL, 0x000fe400078efcffULL,
0x000000d100247306ULL, 0x000fec0000209400ULL, 0x00000001b0b05812ULL, 0x000fe400078efcffULL,
0x000000d100257306ULL, 0x000e620000205400ULL, 0x0000002b2a00720bULL, 0x004fc40003f1d000ULL,
0x009000005128783bULL, 0x000fea0000000200ULL, 0x000000aa00ac7306ULL, 0x000fec0000209400ULL,
0x00000001b3b30812ULL, 0x000fc400078efcffULL, 0x000000aa00ad7306ULL, 0x0004e20000205400ULL,
0x000000252400720bULL, 0x002fe40003fdd000ULL, 0x009000005224783bULL, 0x000fea0000000200ULL,
0x0000003300537306ULL, 0x000fe20000009400ULL, 0x000000aa00aa7245ULL, 0x004fce000020d400ULL,
0x0000003300a47306ULL, 0x000e620000005400ULL, 0x000000adac00720bULL, 0x008fe40003fbd000ULL,
0x00000046ffad723eULL, 0x000fc800000010ffULL, 0x00005410adcc7816ULL, 0x000fe200000000adULL,
0x0000008c008f7306ULL, 0x000fec0000209400ULL, 0x00000001aaaa5812ULL, 0x000fe400078efcffULL,
0x000000a45300720bULL, 0x002fe20003f3d000ULL, 0x0000008c00927306ULL, 0x000fe20000205400ULL,
0x00000008bb537810ULL, 0x000fc40007ffe0ffULL, 0x00001fbbccbb7589ULL, 0x000e6200000e0000ULL,
0x00000018ffa47819ULL, 0x000fc6000001142fULL, 0x00001f53ccc07589ULL, 0x000ea200000e0000ULL,
0x0000003200ae7306ULL, 0x000ff00000009400ULL, 0x0000003200af7306ULL, 0x000ef00000005400ULL,
0x000000d400b97306ULL, 0x000fe20000209400ULL, 0x000000bb2828a231ULL, 0x002fc400003400ffULL,
0x000000bb2a2aa231ULL, 0x080fe400003400ffULL, 0x000000bb2424a231ULL, 0x000fc600003400ffULL,
0x000000d400bc7306ULL, 0x000e620000205400ULL, 0x000000bb2626a231ULL, 0x000fe200003400ffULL,
0x000000afae00720bULL, 0x008fe20003f1d000ULL, 0x000000c02929a231ULL, 0x084fe200003400ffULL,
0x000000d100af7245ULL, 0x000fe2000020d400ULL, 0x000000c02b2ba231ULL, 0x080fe200003400ffULL,
0x00000018ffae7819ULL, 0x000fe2000001142eULL, 0x000000c02525a231ULL, 0x080fe200003400ffULL,
0x00000030006c7306ULL, 0x000ea2000000d400ULL, 0x000000c02727a231ULL, 0x000fe200003400ffULL,
0x000000928f00720bULL, 0x000fc40003f5d000ULL, 0x00000001afaf6812ULL, 0x000fe200078efcffULL,
0x000000022808723cULL, 0x000fe20000041808ULL, 0x00000018ff8f7819ULL, 0x000fe400000114c1ULL,
0x0000008500917306ULL, 0x000fe20000209400ULL, 0x000000bcb900720bULL, 0x002fe20003fbd000ULL,
0x000001002fb97824ULL, 0x000fe200078e00ffULL, 0x0000009500bc7245ULL, 0x000fe4000020d400ULL,
0x00000087c802723eULL, 0x000fe400000010ffULL, 0x0000008800877245ULL, 0x000fe2000020d400ULL,
0x0000008500947306ULL, 0x0002e20000205400ULL, 0x000000016c6c4812ULL, 0x004fc400078efcffULL,
0x00000018ff307819ULL, 0x000fe4000001142dULL, 0x00000086c703723eULL, 0x000fe400000010ffULL,
0x00000001b1b15812ULL, 0x000fe200078efcffULL, 0x0000009500a87306ULL, 0x000fe20000209400ULL,
0x0000008500857245ULL, 0x002fe4000020d400ULL, 0x000000afaaaa723eULL, 0x000fe200000010ffULL,
0x000000022810723cULL, 0x000fe20000041810ULL, 0x00000018ffb97819ULL, 0x000fc600000114b9ULL,
0x0000009500a77306ULL, 0x0002a20000205400ULL, 0x000000949100720bULL, 0x008fe40003f9d000ULL,
0x0000008c00947245ULL, 0x000fe4000020d400ULL, 0x00000079b602723eULL, 0x000fe400000010ffULL,
0x0000000194942812ULL, 0x000fe200078efcffULL, 0x00000088009f7306ULL, 0x000fe20000209400ULL,
0x00000018ff957819ULL, 0x002fe400000114bfULL, 0x00000078b703723eULL, 0x000fc600000010ffULL,
0x0000000185854812ULL, 0x000fe400078efcffULL, 0x0000008800a07306ULL, 0x000e620000205400ULL,
0x000000a7a800720bULL, 0x004fe20003fdd000ULL, 0x000100002ea87824ULL, 0x000fe200078e00ffULL,
0x000000022818723cULL, 0x000fe80000041818ULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x0000009700987306ULL, 0x000fec0000209400ULL, 0x00000001bcbc6812ULL, 0x000fc400078efcffULL,
0x0000009700997306ULL, 0x0004e20000205400ULL, 0x000000a09f00720bULL, 0x002fe40003f5d000ULL,
0x000000b1bcab723eULL, 0x000fca00000010ffULL, 0x0000009a009c7306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x004fe2000020d400ULL, 0x000000aa2804723cULL, 0x000fe80000041804ULL,
0x0000000187872812ULL, 0x000fe400078efcffULL, 0x0000009a00a17306ULL, 0x000e620000205400ULL,
0x000000999800720bULL, 0x008fe40003fbd000ULL, 0x0000009a00997245ULL, 0x000fca000020d400ULL,
0x0000008000897306ULL, 0x000fec0000209400ULL, 0x0000000197975812ULL, 0x000fe400078efcffULL,
0x00000080008a7306ULL, 0x0004e20000205400ULL, 0x000000a19c00720bULL, 0x002fe40003fdd000ULL,
0x0000006c976c723eULL, 0x000fca00000010ffULL, 0x0000009d00a27306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x004fca000020d400ULL, 0x0000000199996812ULL, 0x000fe400078efcffULL,
0x0000009d00a37306ULL, 0x0002a20000205400ULL, 0x0000008a8900720bULL, 0x008fce0003f5d000ULL,
0x0000003100007306ULL, 0x000722000000d400ULL, 0x0000009d009d7245ULL, 0x002fca000020d400ULL,
0x0000000180802812ULL, 0x000fe400078efcffULL, 0x0000007500937306ULL, 0x000fe20000209400ULL,
0x00000018ff317819ULL, 0x008fe4000001142cULL, 0x000000a3a200720bULL, 0x004fca0003fbd000ULL,
0x0000007500967306ULL, 0x0002a20000205400ULL, 0x0000000100003812ULL, 0x010fce00078efcffULL,
0x0000009e00a57306ULL, 0x000fe20000209400ULL, 0x0000007500757245ULL, 0x002fe4000020d400ULL,
0x000000019d9d5812ULL, 0x000fc800078efcffULL, 0x0000009d9494723eULL, 0x000fe200000010ffULL,
0x0000009e00a67306ULL, 0x0002e20000205400ULL, 0x000000969300720bULL, 0x004fce0003fdd000ULL,
0x0000007a00827306ULL, 0x000fe20000209400ULL, 0x0000009e009e7245ULL, 0x002fca000020d400ULL,
0x0000000175756812ULL, 0x000fe400078efcffULL, 0x0000007a007f7306ULL, 0x000e620000205400ULL,
0x000000a6a500720bULL, 0x008fe40003f7d000ULL, 0x000000807580723eULL, 0x000fca00000010ffULL,
0x0000002c00817306ULL, 0x000fec0000009400ULL, 0x000000019e9e3812ULL, 0x000fe400078efcffULL,
0x0000002c00847306ULL, 0x000ea20000005400ULL, 0x0000007f8200720bULL, 0x002fce0003f5d000ULL,
0x0000002c00677306ULL, 0x0002f0000000d400ULL, 0x0000006e008e7306ULL, 0x000fe20000209400ULL,
0x000100002c2c7824ULL, 0x002fe200078e00ffULL, 0x000000848100720bULL, 0x004fc40003f9d000ULL,
0x0000007a00817245ULL, 0x000fe4000020d400ULL, 0x00000018ff8c7819ULL, 0x000fe4000001142cULL,
0x0000006e008b7306ULL, 0x0002a20000205400ULL, 0x000000a9c22c723eULL, 0x000fe400000010ffULL,
0x0000000181812812ULL, 0x000fc800078efcffULL, 0x0000000167674812ULL, 0x008fe200078efcffULL,
0x0000002d007b7306ULL, 0x000fe20000009400ULL, 0x0000006e006e7245ULL, 0x002fce000020d400ULL,
0x0000002d007c7306ULL, 0x000fe20000005400ULL, 0x0000008b8e00720bULL, 0x004fce0003fbd000ULL,
0x0000002d00657306ULL, 0x0003ec000000d400ULL, 0x000000016e6e5812ULL, 0x000fe400078efcffULL,
0x00000083008d7306ULL, 0x000fe20000209400ULL, 0x000000c4c52d723eULL, 0x002fe400000010ffULL,
0x000000816e81723eULL, 0x000fca00000010ffULL, 0x0000008300907306ULL, 0x0002a20000205400ULL,
0x0000002c280c723cULL, 0x000fee000004180cULL, 0x0000009500987306ULL, 0x000fe20000209400ULL,
0x000000bebd2c723eULL, 0x000fe400000010ffULL, 0x000000c3b82d723eULL, 0x000fc400000010ffULL,
0x0000008300837245ULL, 0x002fc6000020d400ULL, 0x0000009500a17306ULL, 0x000e620000205400ULL,
0x000000908d00720bULL, 0x004fe20003f7d000ULL, 0x0000002c2814723cULL, 0x000fe20000041814ULL,
0x000000c9008d7245ULL, 0x000fca000020d400ULL, 0x0000003300667306ULL, 0x000ea2000000d400ULL,
0x000000b5ba2c723eULL, 0x000fe400000010ffULL, 0x000000b4b32d723eULL, 0x000fe400000010ffULL,
0x0000006db0b3723eULL, 0x000fe400000010ffULL, 0x0000000183833812ULL, 0x000fe200078efcffULL,
0x0000002f00747306ULL, 0x000fe20000009400ULL, 0x000000a19800720bULL, 0x002fe20003fdd000ULL,
0x0000002c281c723cULL, 0x000fe2000004181cULL, 0x00000000996d723eULL, 0x000fc400000010ffULL,
0x0000008f00007245ULL, 0x000fc6000020d400ULL, 0x0000002f00777306ULL, 0x000e620000005400ULL,
0x0000000166661812ULL, 0x004fe200078efcffULL, 0x000000b22820723cULL, 0x000fe20000041820ULL,
0x00000095002c7245ULL, 0x000fe4000020d400ULL, 0x000000668303723eULL, 0x000fe400000010ffULL,
0x000000012c2c6812ULL, 0x000fe200078efcffULL, 0x0000003100737306ULL, 0x000fe20000209400ULL,
0x0000009e8595723eULL, 0x000fe200000010ffULL, 0x0000006c2408723cULL, 0x000fe20000041808ULL,
0x000000672c2c723eULL, 0x000fca00000010ffULL, 0x0000003100767306ULL, 0x0004e20000205400ULL,
0x000000777400720bULL, 0x002fe20003f3d000ULL, 0x00000094240c723cULL, 0x040fec000004180cULL,
0x0000003200687306ULL, 0x000e62000000d400ULL, 0x0000003100317245ULL, 0x004fe2000020d400ULL,
0x000000802414723cULL, 0x000fec0000041814ULL, 0x0000002e007e7306ULL, 0x000fe20000009400ULL,
0x000000767300720bULL, 0x008fce0003f5d000ULL, 0x0000002e007d7306ULL, 0x000ea20000005400ULL,
0x0000000168680812ULL, 0x002fe400078efcffULL, 0x0000007c7b00720bULL, 0x000fe40003f1d000ULL,
0x000000688702723eULL, 0x000fe400000010ffULL, 0x0000000131312812ULL, 0x000fe200078efcffULL,
0x0000003000337306ULL, 0x000fe80000209400ULL, 0x000000022410723cULL, 0x000fe80000041810ULL,
0x0000003000327306ULL, 0x0002e20000205400ULL, 0x0000007d7e00720bULL, 0x004fc40003f7d000ULL,
0x0000000165650812ULL, 0x000fe400078efcffULL, 0x000000ca00037245ULL, 0x000fe4000020d400ULL,
0x00000002ff027819ULL, 0x000fe20000011634ULL, 0x0000008f00927306ULL, 0x000fe20000209400ULL,
0x0000003000307245ULL, 0x002fce000020d400ULL, 0x0000008f00917306ULL, 0x000e620000205400ULL,
0x000000323300720bULL, 0x008fce0003fbd000ULL, 0x0000008c008b7306ULL, 0x000fec0000209400ULL,
0x0000000130305812ULL, 0x000fe400078efcffULL, 0x0000008c008e7306ULL, 0x0004e20000205400ULL,
0x000000919200720bULL, 0x002fce0003fdd000ULL, 0x0000002f00637306ULL, 0x000322000000d400ULL,
0x0000008c008c7245ULL, 0x004fca000020d400ULL, 0x0000000100006812ULL, 0x000fe400078efcffULL,
0x000000ca00797306ULL, 0x000fe20000209400ULL, 0x000100002f2f7824ULL, 0x002fe200078e00ffULL,
0x0000008e8b00720bULL, 0x008fc80003f9d000ULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x000000ca00747306ULL, 0x000e620000205400ULL, 0x0000000163631812ULL, 0x010fe400078efcffULL,
0x0000002f00a97245ULL, 0x000fc8000020d400ULL, 0x000000018c8c4812ULL, 0x000fe200078efcffULL,
0x0000002e00647306ULL, 0x000ea6000000d400ULL, 0x0000008c318c723eULL, 0x000fca00000010ffULL,
0x000000ae00ac7306ULL, 0x000fe20000209400ULL, 0x000000747900720bULL, 0x002fce0003f5d000ULL,
0x000000ae00ad7306ULL, 0x000e620000205400ULL, 0x0000000164643812ULL, 0x004fca00078efcffULL,
0x0000000103032812ULL, 0x000fe400078efcffULL, 0x000000a400a77306ULL, 0x000fe40000209400ULL,
0x000000640364723eULL, 0x000fe400000010ffULL, 0x000000ae00037245ULL, 0x000fc8000020d400ULL,
0x000000a4002e7306ULL, 0x0004e20000205400ULL, 0x000000adac00720bULL, 0x002fce0003fdd000ULL,
0x000000c900847306ULL, 0x000fe20000209400ULL, 0x000000a400a47245ULL, 0x004fca000020d400ULL,
0x0000000103036812ULL, 0x000fe400078efcffULL, 0x000000c900897306ULL, 0x000e620000205400ULL,
0x0000002ea700720bULL, 0x008fce0003f9d000ULL, 0x000000a8002d7306ULL, 0x000fec0000209400ULL,
0x00000001a4a44812ULL, 0x000fe400078efcffULL, 0x000000a800287306ULL, 0x0004e20000205400ULL,
0x000000898400720bULL, 0x002fce0003f1d000ULL, 0x0000002f00297306ULL, 0x000fe20000209400ULL,
0x000000a800a87245ULL, 0x004fca000020d400ULL, 0x000000018d8d0812ULL, 0x000fe400078efcffULL,
0x0000002f002a7306ULL, 0x000e620000205400ULL, 0x000000282d00720bULL, 0x008fe40003fbd000ULL,
0x00000065002d723eULL, 0x000fe400000010ffULL, 0x0000008d308d723eULL, 0x000fe400000010ffULL,
0x000000b900007245ULL, 0x000fe2000020d400ULL, 0x000000b9006f7306ULL, 0x000fe40000209400ULL,
0x0000002c2418723cULL, 0x000fe80000041818ULL, 0x00000001a8a85812ULL, 0x000fc400078efcffULL,
0x0000002a2900720bULL, 0x002fe20003f7d000ULL, 0x000000b900767306ULL, 0x000e620000205400ULL,
0x000000a803a8723eULL, 0x000fe200000010ffULL, 0x0000008c241c723cULL, 0x000ff4000004181cULL,
0x00000001a9a93812ULL, 0x000fc400078efcffULL, 0x000000766f00720bULL, 0x002fe40003f1d000ULL,
0x000000a9a4a9723eULL, 0x000fce00000010ffULL, 0x000000a82404723cULL, 0x000fe80000041804ULL,
0x0000000100000812ULL, 0x000fc800078efcffULL, 0x000000630065723eULL, 0x000fe400000010ffULL,
0x0000f61002007811ULL, 0x000fca00078e20ffULL, 0x000000642420723cULL, 0x000fee0000041820ULL,
0x0000010036657824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x0000200042ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004002027824ULL, 0x000fe200078e0265ULL, 0x000000ff70ff7812ULL, 0x000fe2000780c0ffULL,
0x0000000000ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff71ff7812ULL, 0x000fc4000784c0ffULL,
0x0000004002027810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff6f7807ULL, 0x000fe40000000000ULL,
0x000000350200720cULL, 0x000fe40003f06070ULL, 0x000000017200780cULL, 0x000fe40003f25270ULL,
0x00000001ff667807ULL, 0x000fe40001000000ULL, 0x000000706f707207ULL, 0x000fc40004800000ULL,
0x0000761066717816ULL, 0x000fe40000000071ULL, 0x0000000172727812ULL, 0x000fc600078e0cffULL,
0x0000818000000947ULL, 0x000fea0003800000ULL, 0x0000240042037984ULL, 0x004ea20000000800ULL,
0x8000000066007824ULL, 0x000fca00078e00ffULL, 0x8000000003ff7812ULL, 0x004fe20007804800ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000240042037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x004fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x8000000066037824ULL, 0x000fe400078e00ffULL,
0x0000000000027305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000020000735dULL, 0x008fe40003800000ULL, 0x0000240042027984ULL, 0x000ea40000000800ULL,
0x8000000002ff7812ULL, 0x004fc40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000001ff557819ULL, 0x000fe20000011634ULL,
0x00000008456e7824ULL, 0x000fe200078e00ffULL, 0x0000000136007810ULL, 0x000fe20007ffe0ffULL,
0x000058003a277a24ULL, 0x020fe200078e02ffULL, 0x0000001038267812ULL, 0x000fe200078ec0ffULL,
0x0000002055247824ULL, 0x000fe200078e0258ULL, 0x000000390000720cULL, 0x000fe20003f06070ULL,
0x00001000456d7824ULL, 0x000fe200078e00ffULL, 0x000000263b007211ULL, 0x000fe400078fe8ffULL,
0x0000008024247810ULL, 0x000fc40007ffe0ffULL, 0x0000003b00027212ULL, 0x040fe200078e3cffULL,
0x0000000800297824ULL, 0x000fe200078e00ffULL, 0x0000002435257217ULL, 0x000fe40007800000ULL,
0x000000086e037812ULL, 0x000fe400078ec0ffULL, 0x0000f648552a7811ULL, 0x000fe200078e20ffULL,
0x0000000125257824ULL, 0x100fe200078e0a24ULL, 0x000000603e247812ULL, 0x000fe200078ef824ULL,
0x00000000030773c2ULL, 0x0004e200000e0000ULL, 0x000000086e677812ULL, 0x000fc400078e0cffULL,
0x0000002025257807ULL, 0x000fe20000000000ULL, 0x0000008027247824ULL, 0x000fe200078e0224ULL,
0xfffffff829687812ULL, 0x000fe200078ee202ULL, 0x00000080ff277424ULL, 0x000fe200078e00ffULL,
0x0000002526257217ULL, 0x000fe20007800000ULL, 0x000000002a0673c2ULL, 0x0008e200000e0000ULL,
0x00000003ff287819ULL, 0x000fe2000001163bULL, 0x0000000149027824ULL, 0x000fe200078e0224ULL,
0x000010006d007812ULL, 0x000fe200078ec0ffULL, 0x0000000125257824ULL, 0x000fe200078e0a26ULL,
0x0000000c28267810ULL, 0x000fe20007ffe0ffULL, 0x000000012a677824ULL, 0x000fe200078e0267ULL,
0x00000004282a7810ULL, 0x010fe20007ffe0ffULL, 0x00005e0002027625ULL, 0x004fe200078e0027ULL,
0x000000252800720cULL, 0x000fc40003f66070ULL, 0x0000000828287810ULL, 0x000fe20007ffe0ffULL,
0x0000200055007824ULL, 0x000fe200078e0200ULL, 0x000000252a00720cULL, 0x080fe40003f46070ULL,
0x000000252800720cULL, 0x000fe40003f26070ULL, 0x0000004f02287210ULL, 0x000fe20007f9e0ffULL,
0x000000014a027824ULL, 0x100fe200078e0224ULL, 0x000000252600720cULL, 0x000fe20003f06070ULL,
0x000000014b257824ULL, 0x100fe200078e0224ULL, 0x0000b00000007810ULL, 0x000fe20007ffe0ffULL,
0x000000014c267824ULL, 0x000fe200078e0224ULL, 0x0000000706067290ULL, 0x008fe2000fffe03fULL,
0x000000ffff297224ULL, 0x000fc400020e0603ULL, 0x00005e0002027625ULL, 0x000fc800078e0027ULL,
0x00005e0025247625ULL, 0x000fe200078e0027ULL, 0x0000004f02027210ULL, 0x000fc60007f9e0ffULL,
0x00005e0026267625ULL, 0x000fe200078e0027ULL, 0x0000004f24247210ULL, 0x000fc60007fbe0ffULL,
0x0000001068687824ULL, 0x100fe200078e0200ULL, 0x0000004f26267210ULL, 0x000fe20007fde0ffULL,
0x0000001069697824ULL, 0x100fe400078e0200ULL, 0x000000ffff037224ULL, 0x000fe200020e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028687faeULL, 0x0005e2000d901c48ULL,
0x000000106a6a7824ULL, 0x100fe400078e0200ULL, 0x000000ffff257224ULL, 0x000fe200028e0625ULL,
0x0000000002697faeULL, 0x0005e2000d101c48ULL, 0x000000106b6b7824ULL, 0x000fc400078e0200ULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x00000000246a7faeULL, 0x0005e8000c901c48ULL,
0x00000000266b7faeULL, 0x0005e8000c101c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000040067037984ULL, 0x0044e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f61c0047027984ULL, 0x000f220000000800ULL, 0x0000ffff70707812ULL, 0x000fe200078ec0ffULL,
0x800000004d257824ULL, 0x000fc600078e00ffULL, 0x0000888070007816ULL, 0x000fca00000000ffULL,
0x8000000000007824ULL, 0x000fca00078e00ffULL, 0x8000000003ff7812ULL, 0x008fe40007804800ULL,
0x8000000002ff7812ULL, 0x010fe20007824825ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000434477824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x800000004d037824ULL, 0x000fe200078e00ffULL,
0xfffffff047477812ULL, 0x000fe400078ec0ffULL, 0x0000000000027305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000020000735dULL, 0x010fe40003800000ULL,
0x00f61c0047027984ULL, 0x000ee40000000800ULL, 0x8000000002ff7812ULL, 0x008fc40007824803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000804f037810ULL, 0x000fe20007ffe04eULL, 0x00000001ffb17424ULL, 0x000fc800078e00ffULL,
0x0000000150037824ULL, 0x000fca00078e0203ULL, 0x00f0000003257984ULL, 0x000ee80000000800ULL,
0x00f2000003007984ULL, 0x0008620000000800ULL, 0x000000402500720bULL, 0x008fda0003f3d000ULL,
0x0000000000027806ULL, 0x000fc800008e0100ULL, 0x0000ffff02267812ULL, 0x000fda000782c0ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000402500720bULL, 0x012fe40003f34000ULL,
0x0000002540287209ULL, 0x000fe40007810000ULL, 0x0000000134037811ULL, 0x000fe400078ff0ffULL,
0x00000002ff297819ULL, 0x000fe2000001163bULL, 0x8000002840027221ULL, 0x100fe20000010000ULL,
0x000000ffff407224ULL, 0x000fc600078e0028ULL, 0x3fb8aa3b02247820ULL, 0x000fe40000410000ULL,
0x0000000000027806ULL, 0x000fe400008e0100ULL, 0x000000340300720cULL, 0x000fe40003f25270ULL,
0x0000ffff02277812ULL, 0x000fe200078e3cffULL, 0x0000002400247308ULL, 0x000e660000000800ULL,
0x0000002726ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ffb17807ULL, 0x000fc60001000000ULL,
0x0000008034039824ULL, 0x000fc800078e024fULL, 0x0000000150279824ULL, 0x000fe200078e0203ULL,
0x00001f2924027589ULL, 0x002e6200000e0000ULL, 0x8000002825252221ULL, 0x000fe20000010000ULL,
0x0000002441417220ULL, 0x000fe40000410000ULL, 0x00001f5324037589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b25252820ULL, 0x000fc60000410000ULL, 0x00f4002827009388ULL, 0x0009e20000000800ULL,
0x0000002500462308ULL, 0x000f620000000800ULL, 0x0000000208087220ULL, 0x082fe20000410000ULL,
0x0000000209097220ULL, 0x080fe20000410000ULL, 0x000000020c0c7220ULL, 0x080fe20000410000ULL,
0x000000020d0d7220ULL, 0x080fe20000410000ULL, 0x0000000210107220ULL, 0x080fe20000410000ULL,
0x0000000211117220ULL, 0x080fe20000410000ULL, 0x0000000214147220ULL, 0x080fe20000410000ULL,
0x0000000215157220ULL, 0x080fe20000410000ULL, 0x0000000218187220ULL, 0x080fe20000410000ULL,
0x0000000219197220ULL, 0x080fe20000410000ULL, 0x000000021c1c7220ULL, 0x080fe20000410000ULL,
0x000000021d1d7220ULL, 0x080fe20000410000ULL, 0x0000000220207220ULL, 0x080fe20000410000ULL,
0x0000000221217220ULL, 0x080fe20000410000ULL, 0x0000000204047220ULL, 0x080fe20000410000ULL,
0x0000000205057220ULL, 0x000fe20000410000ULL, 0x000000030a0a7220ULL, 0x088fe20000410000ULL,
0x000000030b0b7220ULL, 0x080fe20000410000ULL, 0x000000030e0e7220ULL, 0x080fe20000410000ULL,
0x000000030f0f7220ULL, 0x080fe20000410000ULL, 0x0000000312127220ULL, 0x080fe20000410000ULL,
0x0000000313137220ULL, 0x080fe20000410000ULL, 0x0000000316167220ULL, 0x080fe20000410000ULL,
0x0000000317177220ULL, 0x080fe20000410000ULL, 0x000000031a1a7220ULL, 0x080fe20000410000ULL,
0x000000031b1b7220ULL, 0x080fe20000410000ULL, 0x000000031e1e7220ULL, 0x080fe20000410000ULL,
0x000000031f1f7220ULL, 0x080fe20000410000ULL, 0x0000000322227220ULL, 0x080fe20000410000ULL,
0x0000000323237220ULL, 0x080fe20000410000ULL, 0x0000000306067220ULL, 0x080fe20000410000ULL,
0x0000000307077220ULL, 0x000fe20000410000ULL, 0x0000000046002220ULL, 0x020fc80000410000ULL,
0x0000004100417221ULL, 0x012fe20000010000ULL, 0x0000015000000947ULL, 0x000fea0003800000ULL,
0x0000000845037824ULL, 0x040fe200078e00ffULL, 0x000000014500780cULL, 0x000fc80003f05270ULL,
0x0000000803037812ULL, 0x000fe400078e0cffULL, 0x000000566f007207ULL, 0x000fc60004000000ULL,
0x0000000162627824ULL, 0x000fe200078e0203ULL, 0x0000ffff00007812ULL, 0x000fc800078ec0ffULL,
0x00f64c0062037984ULL, 0x000e620000000800ULL, 0x0000888000027816ULL, 0x000fca00000000ffULL,
0x8000000002007824ULL, 0x000fca00078e00ffULL, 0x8000000003ff7812ULL, 0x002fe20007804800ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000002037824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x008fe40003800000ULL, 0x00f64c0062027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000100045007824ULL, 0x000fe400078e00ffULL,
0x0000100034027824ULL, 0x000fc600078e00ffULL, 0x0000100000007812ULL, 0x000fe400078e0cffULL,
0xffffe00002037812ULL, 0x000fc800078ec0ffULL, 0x0000b00003037810ULL, 0x100fe40007ffe000ULL,
0x0000b0003d007810ULL, 0x000fc60007ffe000ULL, 0x000000105e6c7824ULL, 0x100fe400078e0203ULL,
0x0000001060627824ULL, 0x000fe400078e0203ULL, 0x000000105f637824ULL, 0x100fe200078e0200ULL,
0x000000006c24783bULL, 0x000e620000004200ULL, 0x0000001061647824ULL, 0x000fc600078e0200ULL,
0x000000006228783bULL, 0x000ee80000004200ULL, 0x00000000632c783bULL, 0x000f280000004200ULL,
0x000000006430783bULL, 0x000f620000004200ULL, 0x0001000024ad7824ULL, 0x042fe200078e00ffULL,
0x0000002400d87306ULL, 0x000fe20000009400ULL, 0x0000010025c67824ULL, 0x040fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fe20000011424ULL, 0x0000010024bf7824ULL, 0x000fe200078e00ffULL,
0x00000018ffad7819ULL, 0x000fe200000114adULL, 0x0001000025d17824ULL, 0x000fe200078e00ffULL,
0x00000018ffc67819ULL, 0x000fe200000114c6ULL, 0x0000010026e67824ULL, 0x040fe200078e00ffULL,
0x000000ad00c37306ULL, 0x000fe20000209400ULL, 0x00000018ffbf7819ULL, 0x000fe200000114bfULL,
0x0001000026de7824ULL, 0x000fe200078e00ffULL, 0x00000018ffd07819ULL, 0x000fe20000011425ULL,
0x0000010027e27824ULL, 0x040fe200078e00ffULL, 0x00000018ffd17819ULL, 0x000fe200000114d1ULL,
0x0001000027db7824ULL, 0x000fe200078e00ffULL, 0x00000018ffe67819ULL, 0x000fe200000114e6ULL,
0x000000ad00ee7306ULL, 0x0002a20000205400ULL, 0x00000018ffde7819ULL, 0x000fe200000114deULL,
0x0001000029d67824ULL, 0x008fe200078e00ffULL, 0x00000018ffe27819ULL, 0x000fe200000114e2ULL,
0x000100002deb7824ULL, 0x010fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fc40000011427ULL,
0x00000018ffc47819ULL, 0x000fe20000011426ULL, 0x0000002400d77306ULL, 0x000ee20000005400ULL,
0x000000ad00ad7245ULL, 0x002fe4000020d400ULL, 0x00000018ffaa7819ULL, 0x000fe4000001142bULL,
0x00000018ff907819ULL, 0x000fe4000001142dULL, 0x00000018ffdb7819ULL, 0x000fe200000114dbULL,
0x000000c600ca7306ULL, 0x000fe20000209400ULL, 0x000000eec300720bULL, 0x004fc40003f5d000ULL,
0x00000018ffc07819ULL, 0x000fe40000011428ULL, 0x00000018ffd67819ULL, 0x000fe400000114d6ULL,
0x00000018ff7a7819ULL, 0x020fe20000011430ULL, 0x000000c600e97306ULL, 0x0002a20000205400ULL,
0x000000d7d800720bULL, 0x008fe40003f9d000ULL, 0x00000018ff987819ULL, 0x000fe40000011429ULL,
0x00000018ffa37819ULL, 0x000fc4000001142aULL, 0x00000001adad2812ULL, 0x000fe200078efcffULL,
0x000000b400b77306ULL, 0x000fe20000209400ULL, 0x000000c600c67245ULL, 0x002fe4000020d400ULL,
0x00000018ff967819ULL, 0x000fe4000001142cULL, 0x00000018ff887819ULL, 0x000fe4000001142eULL,
0x00000018ff837819ULL, 0x000fe2000001142fULL, 0x000000b400ec7306ULL, 0x000e620000205400ULL,
0x000000e9ca00720bULL, 0x004fe20003f5d000ULL, 0x000100002ce97824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fc40000011431ULL, 0x00000018ff717819ULL, 0x000fe40000011433ULL,
0x00000018ff727819ULL, 0x000fe20000011432ULL, 0x0000002400027306ULL, 0x0004ec000000d400ULL,
0x00000001c6c62812ULL, 0x000fe400078efcffULL, 0x000000bf00b27306ULL, 0x000fe20000209400ULL,
0x000000ecb700720bULL, 0x002fe20003f7d000ULL, 0x0000010029247824ULL, 0x004fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x000000bf00b37306ULL, 0x0002a20000205400ULL,
0x0000000102024812ULL, 0x008fce00078efcffULL, 0x0000002500f07306ULL, 0x000fe20000009400ULL,
0x000000bf00bf7245ULL, 0x002fce000020d400ULL, 0x0000002500ab7306ULL, 0x000e620000005400ULL,
0x000000b3b200720bULL, 0x004fce0003f3d000ULL, 0x0000002800ae7306ULL, 0x000fec0000009400ULL,
0x00000001bfbf1812ULL, 0x000fe400078efcffULL, 0x0000002800cb7306ULL, 0x000ea20000005400ULL,
0x000000abf000720bULL, 0x002fe40003fbd000ULL, 0x00000002bf02723eULL, 0x000fca00000010ffULL,
0x000000d000cd7306ULL, 0x000ff00000209400ULL, 0x000000d000ce7306ULL, 0x0002e20000205400ULL,
0x000000cbae00720bULL, 0x004fe20003f9d000ULL, 0x000100002ecb7824ULL, 0x000fe200078e00ffULL,
0x000000b400ae7245ULL, 0x000fc8000020d400ULL, 0x00000001aeae3812ULL, 0x000fe200078efcffULL,
0x000000d100cc7306ULL, 0x000fe20000209400ULL, 0x000000d000d07245ULL, 0x002fe4000020d400ULL,
0x00000018ffcb7819ULL, 0x000fca00000114cbULL, 0x000000d100e77306ULL, 0x000e620000205400ULL,
0x000000cecd00720bULL, 0x008fe20003f5d000ULL, 0x0000010030cd7824ULL, 0x040fe400078e00ffULL,
0x0001000030ce7824ULL, 0x000fc600078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe200000114cdULL,
0x0000002600ac7306ULL, 0x000fe20000009400ULL, 0x00000018ffce7819ULL, 0x000fca00000114ceULL,
0x00000001d0d02812ULL, 0x000fe400078efcffULL, 0x0000002600b97306ULL, 0x000ea20000005400ULL,
0x000000e7cc00720bULL, 0x002fe20003f7d000ULL, 0x000001002ee77824ULL, 0x000fe400078e00ffULL,
0x000100002fcc7824ULL, 0x000fc600078e00ffULL, 0x00000018ffe77819ULL, 0x000fe200000114e7ULL,
0x0000002700af7306ULL, 0x000fe20000009400ULL, 0x00000018ffcc7819ULL, 0x000fce00000114ccULL,
0x0000002700b07306ULL, 0x000e620000005400ULL, 0x000000b9ac00720bULL, 0x004fe20003fdd000ULL,
0x000001002bac7824ULL, 0x040fe400078e00ffULL, 0x000100002bb97824ULL, 0x000fc600078e00ffULL,
0x00000018ffac7819ULL, 0x000fe200000114acULL, 0x0000002500037306ULL, 0x0004e2000000d400ULL,
0x00000018ffb97819ULL, 0x000fce00000114b9ULL, 0x000000e600cf7306ULL, 0x000fe20000209400ULL,
0x0000010028257824ULL, 0x004fe200078e00ffULL, 0x000000b0af00720bULL, 0x002fe20003f1d000ULL,
0x000100002aaf7824ULL, 0x000fc600078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x000000e600d27306ULL, 0x000e620000205400ULL, 0x0000000103035812ULL, 0x008fe400078efcffULL,
0x00000018ffaf7819ULL, 0x000fe400000114afULL, 0x00000003c603723eULL, 0x000fc600000010ffULL,
0x000000de00e57306ULL, 0x000ff00000209400ULL, 0x000000de00e87306ULL, 0x000ea20000205400ULL,
0x000000d2cf00720bULL, 0x002fe20003fbd000ULL, 0x0000010031d27824ULL, 0x000fe200078e00ffULL,
0x00000018ffcf7819ULL, 0x000fc800000114e9ULL, 0x00000018ffd27819ULL, 0x000fe200000114d2ULL,
0x000000e200d37306ULL, 0x000ff00000209400ULL, 0x000000e200ea7306ULL, 0x000fe20000205400ULL,
0x000000e8e500720bULL, 0x004fc40003f5d000ULL, 0x00000018ffe57819ULL, 0x000fca00000114ebULL,
0x00000026008f7306ULL, 0x0002b0000000d400ULL, 0x0000002b00c77306ULL, 0x000fe20000009400ULL,
0x0001000028267824ULL, 0x002fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000002b00bc7306ULL, 0x000fe20000005400ULL, 0x000000018f8f6812ULL, 0x004fce00078efcffULL,
0x0000002b00817306ULL, 0x0003f0000000d400ULL, 0x000000bd00d47306ULL, 0x000fe20000209400ULL,
0x00009910b12b7816ULL, 0x002fe200000000ffULL, 0x000001002cb17824ULL, 0x000fc600078e00ffULL,
0x000000ff2b00720cULL, 0x000fe20003f25270ULL, 0x000001002d2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb17819ULL, 0x000fe200000114b1ULL, 0x000000bd00d57306ULL, 0x000e700000205400ULL,
0x00000027008d7306ULL, 0x000eb0000000d400ULL, 0x0000002500df7306ULL, 0x000fe20000209400ULL,
0x000000d5d400720bULL, 0x002fc40003fdd000ULL, 0x000000de00d47245ULL, 0x000fe4000020d400ULL,
0x000000c400d57245ULL, 0x000fe4000020d400ULL, 0x00000001d4d42812ULL, 0x000fe200078efcffULL,
0x0000002500e07306ULL, 0x000e620000205400ULL, 0x000000018d8d0812ULL, 0x004fce00078efcffULL,
0x000000c400c87306ULL, 0x000ff00000209400ULL, 0x000000c400dd7306ULL, 0x000fe20000205400ULL,
0x000000e0df00720bULL, 0x002fce0003f1d000ULL, 0x0000002d00a27306ULL, 0x000ff00000009400ULL,
0x0000002d00a97306ULL, 0x000ff00000005400ULL, 0x0000002d00007306ULL, 0x0003f0000000d400ULL,
0x0000002900b67306ULL, 0x000fe20000009400ULL, 0x000000d1002d7245ULL, 0x002fc8000020d400ULL,
0x000000012d2d3812ULL, 0x000fe400078efcffULL, 0x000000ead300720bULL, 0x000fe20003f7d000ULL,
0x0000002900c17306ULL, 0x000e620000005400ULL, 0x0000002dd02d723eULL, 0x000fce00000010ffULL,
0x000000db00e37306ULL, 0x000ff00000209400ULL, 0x000000db00e47306ULL, 0x0005e20000205400ULL,
0x000000c1b600720bULL, 0x002fe40003f5d000ULL, 0x000000bd00b67245ULL, 0x000fc4000020d400ULL,
0x0000002500bd7245ULL, 0x000fe4000020d400ULL, 0x00000001b6b66812ULL, 0x000fe200078efcffULL,
0x00000028008a7306ULL, 0x0002e2000000d400ULL, 0x00000001bdbd0812ULL, 0x000fe400078efcffULL,
0x000000db00db7245ULL, 0x004fca000020d400ULL, 0x0000003000a87306ULL, 0x000fe20000009400ULL,
0x000001002a287824ULL, 0x002fca00078e00ffULL, 0x00000018ffab7819ULL, 0x000fe40000011428ULL,
0x00000030009f7306ULL, 0x000fe20000005400ULL, 0x000000018a8a4812ULL, 0x008fc800078efcffULL,
0x0000008abd8a723eULL, 0x000fc600000010ffULL, 0x00000030007b7306ULL, 0x0003f0000000d400ULL,
0x000000c000c27306ULL, 0x000fe20000209400ULL, 0x000000e600307245ULL, 0x002fc8000020d400ULL,
0x0000000130305812ULL, 0x000fe400078efcffULL, 0x000000ddc800720bULL, 0x000fe20003fbd000ULL,
0x000000c000c97306ULL, 0x0002a20000205400ULL, 0x000000e200c87245ULL, 0x000fe4000020d400ULL,
0x0000008f3030723eULL, 0x000fe400000010ffULL, 0x00000001c8c83812ULL, 0x000fe400078efcffULL,
0x000000e4e300720bULL, 0x000fe20003f7d000ULL, 0x000000d600d97306ULL, 0x000fe20000209400ULL,
0x000000c000c07245ULL, 0x002fc6000020d400ULL, 0x00000001d5d55812ULL, 0x000fc800078efcffULL,
0x000000d600d87306ULL, 0x0002e20000205400ULL, 0x000000c9c200720bULL, 0x004fe40003fdd000ULL,
0x000000d4d5d4723eULL, 0x000fe400000010ffULL, 0x00000001dbdb3812ULL, 0x000fc600078efcffULL,
0x0000002600277306ULL, 0x000fe20000209400ULL, 0x000000d600d67245ULL, 0x002fe4000020d400ULL,
0x000000dbb6d5723eULL, 0x000fc600000010ffULL, 0x00000001c0c06812ULL, 0x000fe400078efcffULL,
0x0000002600da7306ULL, 0x000e620000205400ULL, 0x000000d8d900720bULL, 0x008fce0003f9d000ULL,
0x0000002a00b57306ULL, 0x000fec0000009400ULL, 0x00000001d6d64812ULL, 0x000fe400078efcffULL,
0x0000002a00be7306ULL, 0x000ea20000005400ULL, 0x000000da2700720bULL, 0x002fce0003f1d000ULL,
0x0000002400dc7306ULL, 0x000ff00000209400ULL, 0x0000002400e17306ULL, 0x0002e20000205400ULL,
0x000000beb500720bULL, 0x004fe40003f7d000ULL, 0x0000002600b57245ULL, 0x000fc4000020d400ULL,
0x0000002400be7245ULL, 0x000fe4000020d400ULL, 0x00000001b5b50812ULL, 0x000fe200078efcffULL,
0x0000002900897306ULL, 0x000ea2000000d400ULL, 0x009800005224783bULL, 0x002fee0000000200ULL,
0x0000002a00847306ULL, 0x000e62000000d400ULL, 0x000000e1dc00720bULL, 0x008fce0003fbd000ULL,
0x000000ab00d77306ULL, 0x000fe20000209400ULL, 0x0000000189892812ULL, 0x004fca00078efcffULL,
0x00000001bebe5812ULL, 0x000fe400078efcffULL, 0x000000ab00287306ULL, 0x0004e20000205400ULL,
0x000000bcc700720bULL, 0x000fe40003fbd000ULL, 0x0000000184843812ULL, 0x002fca00078efcffULL,
0x000000ac00297306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x004fca000020d400ULL,
0x0000000181815812ULL, 0x000fe400078efcffULL, 0x000000ac002a7306ULL, 0x0002a20000205400ULL,
0x00000028d700720bULL, 0x008fe40003fdd000ULL, 0x000000a9a200720bULL, 0x000fca0003fbd000ULL,
0x0000009800c57306ULL, 0x000fe20000209400ULL, 0x000000ac00ac7245ULL, 0x002fca000020d400ULL,
0x00000001abab6812ULL, 0x000fe400078efcffULL, 0x0000009800ba7306ULL, 0x000e620000205400ULL,
0x0000002a2900720bULL, 0x004fe40003f9d000ULL, 0x0000000100005812ULL, 0x000fca00078efcffULL,
0x0000002c00bb7306ULL, 0x000fec0000009400ULL, 0x00000001acac4812ULL, 0x000fe400078efcffULL,
0x0000002c00b87306ULL, 0x000ea20000005400ULL, 0x000000bac500720bULL, 0x002fe40003f1d000ULL,
0x00000046ffba723eULL, 0x000fc800000010ffULL, 0x00005410baba7816ULL, 0x000fe200000000baULL,
0x0000002c00807306ULL, 0x0002f0000000d400ULL, 0x000000a300a07306ULL, 0x000fe20000209400ULL,
0x00000018ff2c7819ULL, 0x002fe2000001142bULL, 0x000001002f2b7824ULL, 0x000fe200078e00ffULL,
0x000000b8bb00720bULL, 0x004fc40003f5d000ULL, 0x0000009800bb7245ULL, 0x000fe4000020d400ULL,
0x00000018ffc17819ULL, 0x000fe2000001142bULL, 0x000000a300a57306ULL, 0x000e620000205400ULL,
0x009800005128783bULL, 0x000fe20000000200ULL, 0x00000002ff987819ULL, 0x000fe4000001163bULL,
0x00000001bbbb0812ULL, 0x000fc800078efcffULL, 0x000000af00b07306ULL, 0x000fe20000209400ULL,
0x0000000180802812ULL, 0x008fe400078efcffULL, 0x000000d6bbbb723eULL, 0x000fca00000010ffULL,
0x000000af00b37306ULL, 0x0004e20000205400ULL, 0x000000a5a000720bULL, 0x002fe40003f1d000ULL,
0x00001f53baa07589ULL, 0x000e6a00000e0000ULL, 0x0000009600977306ULL, 0x000fe20000209400ULL,
0x000000af00af7245ULL, 0x004fe4000020d400ULL, 0x000000b3b000720bULL, 0x008fca0003fdd000ULL,
0x00000096009a7306ULL, 0x0004e20000205400ULL, 0x00001f98bab37589ULL, 0x00096e00000e0000ULL,
0x000000aa009d7306ULL, 0x000fe20000209400ULL, 0x0000009600967245ULL, 0x004fe2000020d400ULL,
0x000000a029299231ULL, 0x082fe200003400ffULL, 0x000000a300987245ULL, 0x010fe2000020d400ULL,
0x000000a02b2b9231ULL, 0x080fe200003400ffULL, 0x00000001afaf6812ULL, 0x000fe200078efcffULL,
0x000000a025259231ULL, 0x080fe200003400ffULL, 0x0000000198980812ULL, 0x000fe200078efcffULL,
0x000000aa009c7306ULL, 0x0002a20000205400ULL, 0x0000009a9700720bULL, 0x008fe20003f5d000ULL,
0x000000a027279231ULL, 0x000fe200003400ffULL, 0x000000b5c0ba723eULL, 0x000fca00000010ffULL,
0x0000009000a67306ULL, 0x000fe20000209400ULL, 0x000000b328289231ULL, 0x0a0fe200003400ffULL,
0x000000aa00aa7245ULL, 0x002fe2000020d400ULL, 0x000000b32a2a9231ULL, 0x080fe400003400ffULL,
0x000000b324249231ULL, 0x080fe200003400ffULL, 0x0000000196962812ULL, 0x000fe200078efcffULL,
0x000000b326269231ULL, 0x000fe200003400ffULL, 0x0000009000a17306ULL, 0x000e620000205400ULL,
0x0000009c9d00720bULL, 0x004fe20003f7d000ULL, 0x000000022808723cULL, 0x040fec0000041808ULL,
0x000000cf00d37306ULL, 0x000fe20000209400ULL, 0x00000084ab02723eULL, 0x000fe200000010ffULL,
0x000000d42814723cULL, 0x000fe20000041814ULL, 0x00000081ac03723eULL, 0x000fc600000010ffULL,
0x00000001aaaa3812ULL, 0x000fe400078efcffULL, 0x000000cf00e67306ULL, 0x0004e20000205400ULL,
0x000000a1a600720bULL, 0x002fe20003fbd000ULL, 0x000000ba281c723cULL, 0x040fec000004181cULL,
0x0000003100927306ULL, 0x000fe20000009400ULL, 0x000000cf00cf7245ULL, 0x004fe2000020d400ULL,
0x000000022820723cULL, 0x000fec0000041820ULL, 0x0000003100937306ULL, 0x000e620000005400ULL,
0x000000e6d300720bULL, 0x008fce0003f3d000ULL, 0x0000002c00ca7306ULL, 0x000fec0000209400ULL,
0x00000001cfcf1812ULL, 0x000fe400078efcffULL, 0x0000002c00d17306ULL, 0x000ea20000205400ULL,
0x000000939200720bULL, 0x002fe40003f5d000ULL, 0x0000009000927245ULL, 0x000fc4000020d400ULL,
0x000000cf9696723eULL, 0x000fe400000010ffULL, 0x0000000192925812ULL, 0x000fe200078efcffULL,
0x0000002e00a47306ULL, 0x000ff00000009400ULL, 0x0000002e00997306ULL, 0x000e620000005400ULL,
0x000000d1ca00720bULL, 0x004fce0003f7d000ULL, 0x000000b900b27306ULL, 0x000ff00000209400ULL,
0x000000b900b77306ULL, 0x0004e20000205400ULL, 0x00000099a400720bULL, 0x002fe40003fdd000ULL,
0x0000002c00997245ULL, 0x000fc4000020d400ULL, 0x000000adae2c723eULL, 0x000fe400000010ffULL,
0x0000000199993812ULL, 0x000fe200078efcffULL, 0x000000c100bc7306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x004fe4000020d400ULL, 0x000000009981723eULL, 0x000fe200000010ffULL,
0x0000002c280c723cULL, 0x000fe8000004180cULL, 0x000000c100c57306ULL, 0x000e620000205400ULL,
0x000000b7b200720bULL, 0x008fc40003f9d000ULL, 0x000000c1002c7245ULL, 0x000fca000020d400ULL,
0x000000e700dc7306ULL, 0x000fec0000209400ULL, 0x00000001b9b94812ULL, 0x000fe400078efcffULL,
0x000000e700c97306ULL, 0x0004e20000205400ULL, 0x000000c5bc00720bULL, 0x002fe40003fbd000ULL,
0x000000b9aab9723eULL, 0x000fca00000010ffULL, 0x0000002f00a77306ULL, 0x000fe20000009400ULL,
0x000000e700e77245ULL, 0x004fca000020d400ULL, 0x000000012c2c5812ULL, 0x000fe400078efcffULL,
0x0000002f009e7306ULL, 0x000e620000005400ULL, 0x000000c9dc00720bULL, 0x008fce0003f3d000ULL,
0x000000e500dd7306ULL, 0x000fec0000209400ULL, 0x00000001e7e71812ULL, 0x000fe400078efcffULL,
0x000000e500c47306ULL, 0x0004e20000205400ULL, 0x0000009ea700720bULL, 0x002fce0003f1d000ULL,
0x0000002e007c7306ULL, 0x000322000000d400ULL, 0x000000e500e57245ULL, 0x004fce000020d400ULL,
0x00000088008c7306ULL, 0x000fe20000209400ULL, 0x000000c4dd00720bULL, 0x008fe20003f7d000ULL,
0x00000100332e7824ULL, 0x002fcc00078e00ffULL, 0x00000088008b7306ULL, 0x0002a20000205400ULL,
0x000000017c7c6812ULL, 0x010fc800078efcffULL, 0x0000007ce702723eULL, 0x000fe400000010ffULL,
0x00000001e5e53812ULL, 0x000fe200078efcffULL, 0x000000b100c37306ULL, 0x000fe20000209400ULL,
0x0000008800887245ULL, 0x002fce000020d400ULL, 0x000000b100b47306ULL, 0x0002e20000205400ULL,
0x0000008b8c00720bULL, 0x004fe40003fbd000ULL, 0x00000089be8b723eULL, 0x000fe400000010ffULL,
0x000000cc00897245ULL, 0x000fc6000020d400ULL, 0x000000cb00b87306ULL, 0x000fe20000209400ULL,
0x000000b100b17245ULL, 0x002fe2000020d400ULL, 0x0000008a2818723cULL, 0x000fe80000041818ULL,
0x0000000188885812ULL, 0x000fe400078efcffULL, 0x000000cb00a57306ULL, 0x0002a20000205400ULL,
0x000000b4c300720bULL, 0x008fce0003f9d000ULL, 0x0000003300917306ULL, 0x000fe20000009400ULL,
0x000000cb00cb7245ULL, 0x002fca000020d400ULL, 0x00000001b1b14812ULL, 0x000fe400078efcffULL,
0x00000033008e7306ULL, 0x000e620000005400ULL, 0x000000a5b800720bULL, 0x004fe40003fdd000ULL,
0x0000009fa800720bULL, 0x000fe40003f9d000ULL, 0x000000af98b8723eULL, 0x000fe400000010ffULL,
0x00000080b180723eULL, 0x000fe200000010ffULL, 0x0000003100757306ULL, 0x0004e8000000d400ULL,
0x000000b82804723cULL, 0x000fe40000041804ULL, 0x00000001cbcb6812ULL, 0x000fc400078efcffULL,
0x0000002f00777306ULL, 0x000962000000d400ULL, 0x0001000031317824ULL, 0x004fe200078e00ffULL,
0x0000008e9100720bULL, 0x002fe40003f3d000ULL, 0x000000017b7b4812ULL, 0x000fe200078efcffULL,
0x000000802408723cULL, 0x000fe20000041808ULL, 0x00000018ff907819ULL, 0x000fe40000011431ULL,
0x0000003200947306ULL, 0x000fe20000009400ULL, 0x0000008dc831723eULL, 0x000fe200000010ffULL,
0x00000100322f7824ULL, 0x010fe200078e00ffULL, 0x0000000175752812ULL, 0x008fc400078efcffULL,
0x0000009000cf7245ULL, 0x000fe4000020d400ULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000003200957306ULL, 0x000e620000005400ULL, 0x0000000177770812ULL, 0x020fe200078efcffULL,
0x000000302810723cULL, 0x000fe20000041810ULL, 0x000000cb8888723eULL, 0x000fe400000010ffULL,
0x000000772c03723eULL, 0x000fc600000010ffULL, 0x0000008300877306ULL, 0x000fe20000209400ULL,
0x000000cd00307245ULL, 0x000fe4000020d400ULL, 0x0000007a00297245ULL, 0x000fca000020d400ULL,
0x0000008300867306ULL, 0x000ea20000205400ULL, 0x000000959400720bULL, 0x002fce0003f7d000ULL,
0x000000cc009c7306ULL, 0x000fe40000209400ULL, 0x000000022410723cULL, 0x000fec0000041810ULL,
0x000000cc00a37306ULL, 0x000e620000205400ULL, 0x000000868700720bULL, 0x004fe40003f1d000ULL,
0x00000018ff877819ULL, 0x000fc4000001142eULL, 0x00000083002e7245ULL, 0x000fe4000020d400ULL,
0x0000007200037245ULL, 0x000fe2000020d400ULL, 0x000000cd009e7306ULL, 0x000fec0000209400ULL,
0x000000012e2e0812ULL, 0x000fe400078efcffULL, 0x000000cd00a77306ULL, 0x000ea20000205400ULL,
0x000000a39c00720bULL, 0x002fce0003fdd000ULL, 0x00000090008e7306ULL, 0x000fec0000209400ULL,
0x0000000189896812ULL, 0x000fe400078efcffULL, 0x00000090002d7306ULL, 0x000e620000205400ULL,
0x000000a79e00720bULL, 0x004fe40003fbd000ULL, 0x000000892e89723eULL, 0x000fca00000010ffULL,
0x00000078007f7306ULL, 0x000fe40000209400ULL, 0x000000882414723cULL, 0x000fe80000041814ULL,
0x0000000130305812ULL, 0x000fe400078efcffULL, 0x00000078007e7306ULL, 0x0004e20000205400ULL,
0x0000002d8e00720bULL, 0x002fe40003f5d000ULL, 0x0000007b3030723eULL, 0x000fca00000010ffULL,
0x0000007a00827306ULL, 0x000fe20000209400ULL, 0x0000007800787245ULL, 0x004fca000020d400ULL,
0x00000001cfcf2812ULL, 0x000fe400078efcffULL, 0x0000007a00857306ULL, 0x000e620000205400ULL,
0x0000007e7f00720bULL, 0x008fce0003f1d000ULL, 0x000000d2009d7306ULL, 0x000fec0000209400ULL,
0x0000000178780812ULL, 0x000fe400078efcffULL, 0x000000d2009a7306ULL, 0x0004e20000205400ULL,
0x000000858200720bULL, 0x002fe40003fdd000ULL, 0x000000cf78cf723eULL, 0x000fca00000010ffULL,
0x000000ce00977306ULL, 0x000fe20000209400ULL, 0x000000d200d27245ULL, 0x004fca000020d400ULL,
0x0000000129296812ULL, 0x000fe400078efcffULL, 0x000000ce00947306ULL, 0x0002a20000205400ULL,
0x0000009a9d00720bULL, 0x008fce0003fbd000ULL, 0x0000003300737306ULL, 0x000722000000d400ULL,
0x000000ce00ce7245ULL, 0x002fca000020d400ULL, 0x00000001d2d25812ULL, 0x000fe400078efcffULL,
0x0000003200747306ULL, 0x000362000000d400ULL, 0x0001000033337824ULL, 0x008fe200078e00ffULL,
0x000000949700720bULL, 0x004fe40003f9d000ULL, 0x000000e59297723eULL, 0x000fe400000010ffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000008700847306ULL, 0x000fe20000209400ULL,
0x0001000032327824ULL, 0x002fe200078e00ffULL, 0x0000000173731812ULL, 0x010fe200078efcffULL,
0x00000096240c723cULL, 0x000fe6000004180cULL, 0x00000018ff327819ULL, 0x000fc40000011432ULL,
0x0000008700837306ULL, 0x000e620000205400ULL, 0x0000000174743812ULL, 0x020fe400078efcffULL,
0x00000001cece4812ULL, 0x000fc800078efcffULL, 0x000000ce29ce723eULL, 0x000fe200000010ffULL,
0x0000003300007306ULL, 0x000fec0000209400ULL, 0x000000ce241c723cULL, 0x000fe4000004181cULL,
0x00000033002d7306ULL, 0x0004e20000205400ULL, 0x000000838400720bULL, 0x002fce0003f5d000ULL,
0x0000007200797306ULL, 0x000fe20000209400ULL, 0x0000003300337245ULL, 0x004fce000020d400ULL,
0x0000007200707306ULL, 0x000e620000205400ULL, 0x0000002d0000720bULL, 0x008fe40003f7d000ULL,
0x0000008700007245ULL, 0x000fc8000020d400ULL, 0x0000000100002812ULL, 0x000fe200078efcffULL,
0x0000007100767306ULL, 0x000fec0000209400ULL, 0x0000000133333812ULL, 0x000fe400078efcffULL,
0x00000071007d7306ULL, 0x000ea20000205400ULL, 0x000000707900720bULL, 0x002fce0003fbd000ULL,
0x0000002f00317306ULL, 0x000fec0000209400ULL, 0x0000000103035812ULL, 0x000fe400078efcffULL,
0x0000002f00867306ULL, 0x0002e20000205400ULL, 0x0000007d7600720bULL, 0x004fce0003f9d000ULL,
0x00000032007e7306ULL, 0x000fe20000209400ULL, 0x0000002f002f7245ULL, 0x002fce000020d400ULL,
0x00000032002b7306ULL, 0x0002a20000205400ULL, 0x000000863100720bULL, 0x008fe40003fdd000ULL,
0x00000075d231723eULL, 0x000fe400000010ffULL, 0x000000730075723eULL, 0x000fe400000010ffULL,
0x0000007100007245ULL, 0x000fe4000020d400ULL, 0x0000003200327245ULL, 0x002fe2000020d400ULL,
0x000000302418723cULL, 0x000fe20000041818ULL, 0x0000000100004812ULL, 0x000fc600078efcffULL,
0x000000012f2f6812ULL, 0x000fe400078efcffULL, 0x0000002b7e00720bULL, 0x004fe40003f1d000ULL,
0x000000742f74723eULL, 0x000fe400000010ffULL, 0x000000330033723eULL, 0x000fca00000010ffULL,
0x000000742420723cULL, 0x000fe80000041820ULL, 0x0000000132320812ULL, 0x000fe400078efcffULL,
0x000000014500780cULL, 0x000fe40003f05270ULL, 0x000000320332723eULL, 0x000fe400000010ffULL,
0x00000002ff037819ULL, 0x000fc80000011634ULL, 0x0000f62003007811ULL, 0x000fe200078e20ffULL,
0x000000322404723cULL, 0x000fe20000041804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200042ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000566f6f7207ULL, 0x000fe20004000000ULL,
0x0000000436247824ULL, 0x000fe200078e0203ULL, 0x0000000145ff7812ULL, 0x000fe2000782c0ffULL,
0x0000000000ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff6fff7812ULL, 0x000fe4000784c0ffULL,
0x0000008024247811ULL, 0x000fe400078e30ffULL, 0x00000001ff027807ULL, 0x000fc40001000000ULL,
0x000000352400720cULL, 0x000fe40003f46070ULL, 0x000000ff9bff7812ULL, 0x000fe4000780c0ffULL,
0x0000006f02707207ULL, 0x000fe40004800000ULL, 0x00000001ff717807ULL, 0x000fe40004000000ULL,
0x0000000145727812ULL, 0x000fca00078ec0ffULL, 0x0000557000002947ULL, 0x000fea0003800000ULL,
0x0000240042037984ULL, 0x004ea20000000800ULL, 0x00000001ff247807ULL, 0x000fca0004000000ULL,
0x8000000024007824ULL, 0x000fca00078e00ffULL, 0x8000000003ff7812ULL, 0x004fe20007824800ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x0000240042037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x004fe40007824800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000024247824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000037305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000030000735dULL, 0x008fe40003800000ULL, 0x0000240042037984ULL, 0x000ea40000000800ULL,
0x8000000003ff7812ULL, 0x004fc40007824824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000154487824ULL, 0x000fe400078e0257ULL,
0x00000300ff007624ULL, 0x000fe400078e00ffULL, 0x000058003a267a24ULL, 0x000fe200078e02ffULL,
0x0000000148037812ULL, 0x000fe200078ec0ffULL, 0xffffffffff3a7424ULL, 0x000fe200078e00ffULL,
0xffffffff00007811ULL, 0x000fe400078e08ffULL, 0x000000010300780cULL, 0x000fc80003f25070ULL,
0x0000000100037807ULL, 0x000fca0004800000ULL, 0x0000000148487824ULL, 0x000fe200078e0203ULL,
0x00000001ff557819ULL, 0x000fc80000011634ULL, 0x000000374800720cULL, 0x000fe20003f26070ULL,
0x0000002055007824ULL, 0x000fca00078e0258ULL, 0x000000c000007810ULL, 0x000fc80007ffe0ffULL,
0x000000603e037812ULL, 0x000fc600078ef800ULL, 0x0000000148249824ULL, 0x000fe400078e0243ULL,
0x00000004ff259424ULL, 0x000fe200078e00ffULL, 0x0000000035277217ULL, 0x000fe20007800000ULL,
0x0000008026037824ULL, 0x000fe400078e0203ULL, 0x0000600024249625ULL, 0x000fe200078e0025ULL,
0x0000000136287810ULL, 0x000fc60007ffe0ffULL, 0x0000000127277824ULL, 0x000fe200078e0a00ULL,
0x00000008243a9981ULL, 0x000562000c1e1900ULL, 0x00000080ff297424ULL, 0x000fe200078e00ffULL,
0x000000392800720cULL, 0x000fe20003f26070ULL, 0x000000014a267824ULL, 0x100fe200078e0203ULL,
0x0000001038007812ULL, 0x000fe200078ec0ffULL, 0x000000014c287824ULL, 0x000fe200078e0203ULL,
0x0000002027277807ULL, 0x000fe40000800000ULL, 0x00000003ff2d7819ULL, 0x000fe2000001163bULL,
0x0000000149247824ULL, 0x004fe200078e0203ULL, 0x0000002700277217ULL, 0x000fc60007800000ULL,
0x00005e0024247625ULL, 0x000fc800078e0029ULL, 0x0000000127007824ULL, 0x000fe200078e0a00ULL,
0x0000004f242a7210ULL, 0x000fe40007f3e0ffULL, 0x000000042d277810ULL, 0x040fe40007ffe0ffULL,
0x000000002d00720cULL, 0x080fe20003f46070ULL, 0x000000ffff2b7224ULL, 0x000fe200008e0625ULL,
0x000000002700720cULL, 0x000fe20003f26070ULL, 0x00005e0026247625ULL, 0x000fc800078e0029ULL,
0x000000014b267824ULL, 0x000fe200078e0203ULL, 0x0000004f24247210ULL, 0x000fe40007f7e0ffULL,
0x000000082d037810ULL, 0x040fe20007ffe0ffULL, 0x00005e0026267625ULL, 0x080fe200078e0029ULL,
0x0000000c2d2d7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a5a7faeULL, 0x0005e4000d101c48ULL, 0x00005e0028287625ULL, 0x000fe200078e0029ULL,
0x0000004f26267210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff257224ULL, 0x000fe200018e0625ULL,
0x000000000300720cULL, 0x080fe20003f66070ULL, 0x000000ffff277224ULL, 0x000fe200020e0627ULL,
0x000000002d00720cULL, 0x000fe20003f86070ULL, 0x0000000834037824ULL, 0x000fe200078e00ffULL,
0x0000004f28287210ULL, 0x000fe20007fbe0ffULL, 0x00000000245b7faeULL, 0x0005e2000c901c48ULL,
0x000000086e007812ULL, 0x000fe400078ec0ffULL, 0xfffffff003037812ULL, 0x000fe200078ec0ffULL,
0x000000ffff297224ULL, 0x000fc600028e0629ULL, 0x0000f648032d7810ULL, 0x000fe20007ffe0ffULL,
0x00000000265c7faeULL, 0x0005e8000d901c48ULL, 0x00000000285d7faeULL, 0x0005e2000e101c48ULL,
0x000000012d007824ULL, 0x000fc600078e0200ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000040000257984ULL, 0x0044e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f62c0047247984ULL, 0x000f220000000800ULL, 0x0000000145ff7812ULL, 0x000fe2000782c0ffULL,
0x800000004d277824ULL, 0x000fe200078e00ffULL, 0x000000086e547812ULL, 0x000fe400078e0cffULL,
0x0000006f02567207ULL, 0x000fc80004800000ULL, 0x0000ffff56007812ULL, 0x004fc800078ec0ffULL,
0x0000888000287816ULL, 0x000fca00000000ffULL, 0x8000000028007824ULL, 0x000fca00078e00ffULL,
0x8000000025ff7812ULL, 0x008fe40007844800ULL, 0x8000000024ff7812ULL, 0x010fe20007864827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000012d547824ULL, 0x000fe200078e0254ULL,
0x0000009000003947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x800000004d257824ULL, 0x000fe400078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x00f62c0047247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007864825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000b947ULL, 0x000fea000383ffffULL,
0x000001004f257810ULL, 0x000fe20007ffe04eULL, 0x00000001ffb87424ULL, 0x000fc800078e00ffULL,
0x0000000150257824ULL, 0x000fca00078e0225ULL, 0x00f0000025277984ULL, 0x000ea80000000800ULL,
0x00f2000025007984ULL, 0x0007220000000800ULL, 0x000000402700720bULL, 0x004fda0003f7d000ULL,
0x0000000000247806ULL, 0x000fc800018e0100ULL, 0x0000ffff24297812ULL, 0x000fda000786c0ffULL,
0x000003700000b947ULL, 0x000fea0003800000ULL, 0x000000402700720bULL, 0x018fe40003f74000ULL,
0x00000027402b7209ULL, 0x000fe40007810000ULL, 0x0000000234257811ULL, 0x000fe400078ff0ffULL,
0x00000002ff2d7819ULL, 0x000fe2000001163bULL, 0x8000002b40247221ULL, 0x100fe20000010000ULL,
0x000000ffff407224ULL, 0x000fc600078e002bULL, 0x3fb8aa3b24267820ULL, 0x000fe40000410000ULL,
0x0000000000247806ULL, 0x000fe400018e0100ULL, 0x000000342500720cULL, 0x000fe40003f65270ULL,
0x0000ffff242a7812ULL, 0x000fe200078e3cffULL, 0x0000002600267308ULL, 0x000ea60000000800ULL,
0x0000002a29ff7212ULL, 0x000fc8000788c0ffULL, 0x00000001ffb87807ULL, 0x000fc60002000000ULL,
0x000000803425b824ULL, 0x000fc800078e024fULL, 0x00000001502ab824ULL, 0x000fe200078e0225ULL,
0x00001f2d26247589ULL, 0x004ea200000e0000ULL, 0x8000002b27274221ULL, 0x000fe20000010000ULL,
0x0000002641417220ULL, 0x000fe40000410000ULL, 0x00001f5326257589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b27274820ULL, 0x000fc60000410000ULL, 0x00f4002b2a00b388ULL, 0x0009e20000000800ULL,
0x0000002700464308ULL, 0x000e620000000800ULL, 0x0000002408087220ULL, 0x084fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002420207220ULL, 0x080fe20000410000ULL,
0x0000002421217220ULL, 0x080fe20000410000ULL, 0x0000002404047220ULL, 0x080fe20000410000ULL,
0x0000002405057220ULL, 0x000fe20000410000ULL, 0x000000250a0a7220ULL, 0x088fe20000410000ULL,
0x000000250b0b7220ULL, 0x080fe20000410000ULL, 0x000000250e0e7220ULL, 0x080fe20000410000ULL,
0x000000250f0f7220ULL, 0x080fe20000410000ULL, 0x0000002512127220ULL, 0x080fe20000410000ULL,
0x0000002513137220ULL, 0x080fe20000410000ULL, 0x0000002516167220ULL, 0x080fe20000410000ULL,
0x0000002517177220ULL, 0x080fe20000410000ULL, 0x000000251a1a7220ULL, 0x080fe20000410000ULL,
0x000000251b1b7220ULL, 0x080fe20000410000ULL, 0x000000251e1e7220ULL, 0x080fe20000410000ULL,
0x000000251f1f7220ULL, 0x080fe20000410000ULL, 0x0000002522227220ULL, 0x080fe20000410000ULL,
0x0000002523237220ULL, 0x080fe20000410000ULL, 0x0000002506067220ULL, 0x080fe20000410000ULL,
0x0000002507077220ULL, 0x000fe20000410000ULL, 0x0000000046004220ULL, 0x002fc80000410000ULL,
0x0000004100417221ULL, 0x018fe20000010000ULL, 0x0000015000002947ULL, 0x000fea0003800000ULL,
0x000000086e007812ULL, 0x000fe200078ec0ffULL, 0x8000000028257824ULL, 0x000fc800078e00ffULL,
0x0000000103007824ULL, 0x000fcc00078e0200ULL, 0x00f64c0000007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007844825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000834037824ULL, 0x000fe400078e00ffULL,
0x0000000845247824ULL, 0x000fe400078e00ffULL, 0x8000000028277824ULL, 0x000fe200078e00ffULL,
0xfffffff003037812ULL, 0x000fe200078ec0ffULL, 0x3e000000ff007424ULL, 0x000fe200078e00ffULL,
0x0000000824247812ULL, 0x000fc800078ec0ffULL, 0x0000f64824257810ULL, 0x000fe40007ffe003ULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x0000040025247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fe40007844827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000100034297824ULL, 0x000fe200078e00ffULL,
0x000010006d2c7812ULL, 0x000fc800078ec0ffULL, 0xffffe00029317812ULL, 0x000fe400078ec0ffULL,
0x0000b0003d007810ULL, 0x100fe40007ffe02cULL, 0x0000b00031317810ULL, 0x000fc60007ffe02cULL,
0x000000105f247824ULL, 0x100fe400078e0200ULL, 0x000000105e2c7824ULL, 0x100fe400078e0231ULL,
0x0000001060317824ULL, 0x000fe400078e0231ULL, 0x000000002424783bULL, 0x000ea20000004200ULL,
0x0000001061287824ULL, 0x000fc600078e0200ULL, 0x000000002c2c783bULL, 0x000ee80000004200ULL,
0x000000003130783bULL, 0x000f280000004200ULL, 0x000000002828783bULL, 0x000e620000004200ULL,
0x0000002400897306ULL, 0x004fe20000009400ULL, 0x00000018ff9f7819ULL, 0x000fe20000011424ULL,
0x0000010024a47824ULL, 0x040fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe20000011425ULL,
0x0001000024aa7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb97819ULL, 0x008fe2000001142cULL,
0x000001002de07824ULL, 0x040fe200078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe2000001142dULL,
0x00000024008c7306ULL, 0x000fe20000005400ULL, 0x000100002dd37824ULL, 0x000fe200078e00ffULL,
0x00000018ffc67819ULL, 0x000fe2000001142eULL, 0x000001002ecf7824ULL, 0x040fe200078e00ffULL,
0x00000018ffe07819ULL, 0x000fe200000114e0ULL, 0x0000010025917824ULL, 0x040fe200078e00ffULL,
0x00000018ffd37819ULL, 0x000fe200000114d3ULL, 0x0001000025ac7824ULL, 0x000fe200078e00ffULL,
0x0000002400737306ULL, 0x0005e2000000d400ULL, 0x00000018ffcf7819ULL, 0x000fe200000114cfULL,
0x000100002ed07824ULL, 0x000fe200078e00ffULL, 0x00000018ffc27819ULL, 0x000fe2000001142fULL,
0x000100002fd17824ULL, 0x000fe200078e00ffULL, 0x00000018ffb37819ULL, 0x010fe20000011431ULL,
0x00000100268d7824ULL, 0x000fe200078e00ffULL, 0x00000018ffd07819ULL, 0x000fe200000114d0ULL,
0x0000002c00da7306ULL, 0x000fe20000009400ULL, 0x000001002c247824ULL, 0x004fe200078e00ffULL,
0x00000018ffa67819ULL, 0x000fe20000011433ULL, 0x0000010027837824ULL, 0x000fe200078e00ffULL,
0x00000018ffbb7819ULL, 0x000fc40000011430ULL, 0x00000018ffe27819ULL, 0x000fe40000011424ULL,
0x0000002c00e17306ULL, 0x000ea20000005400ULL, 0x00000018ffd17819ULL, 0x000fe400000114d1ULL,
0x00000018ff957819ULL, 0x000fe40000011432ULL, 0x00000018ff7e7819ULL, 0x000fe40000011426ULL,
0x00000018ff7b7819ULL, 0x000fe20000011427ULL, 0x0000002c009c7306ULL, 0x000722000000d400ULL,
0x00000018ff5c7819ULL, 0x002fc40000011428ULL, 0x00000018ff5f7819ULL, 0x000fe40000011429ULL,
0x00000018ff6d7819ULL, 0x000fe4000001142aULL, 0x00000018ff707819ULL, 0x000fe2000001142bULL,
0x000000e200247306ULL, 0x000fe20000209400ULL, 0x000100002c2c7824ULL, 0x008fe200078e00ffULL,
0x000000e1da00720bULL, 0x004fe40003f9d000ULL, 0x00000018ff917819ULL, 0x000fe40000011491ULL,
0x00000018ffe47819ULL, 0x000fe2000001142cULL, 0x00000100302c7824ULL, 0x000fe200078e00ffULL,
0x000000e200e37306ULL, 0x000e620000205400ULL, 0x00000018ffaa7819ULL, 0x000fc400000114aaULL,
0x00000018ffa47819ULL, 0x000fe400000114a4ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x000000019c9c4812ULL, 0x010fe200078efcffULL, 0x000000b900dd7306ULL, 0x000fe20000209400ULL,
0x00000018ffac7819ULL, 0x000fe400000114acULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x00000018ff8d7819ULL, 0x000fc6000001148dULL, 0x000000b900dc7306ULL, 0x000ea20000205400ULL,
0x000000e32400720bULL, 0x002fce0003f5d000ULL, 0x000000e400e57306ULL, 0x000ff00000209400ULL,
0x000000e400e67306ULL, 0x000e620000205400ULL, 0x000000dcdd00720bULL, 0x004fe20003fdd000ULL,
0x0001000030dc7824ULL, 0x000fca00078e00ffULL, 0x00000018ffdc7819ULL, 0x000fe200000114dcULL,
0x0000002d00df7306ULL, 0x000ff00000009400ULL, 0x0000002d00de7306ULL, 0x000ea20000005400ULL,
0x000000e6e500720bULL, 0x002fce0003f7d000ULL, 0x000000cb00ce7306ULL, 0x000ff00000209400ULL,
0x000000cb00b77306ULL, 0x000e620000205400ULL, 0x000000dedf00720bULL, 0x004fce0003fbd000ULL,
0x000000e000e77306ULL, 0x000ff00000209400ULL, 0x000000e000e87306ULL, 0x000fe20000205400ULL,
0x000000b7ce00720bULL, 0x002fe40003f9d000ULL, 0x000000b900b77245ULL, 0x000fc4000020d400ULL,
0x000000e000b97245ULL, 0x000fe4000020d400ULL, 0x00000001b7b76812ULL, 0x000fe200078efcffULL,
0x0000002500a77306ULL, 0x000ff00000009400ULL, 0x0000002500967306ULL, 0x000ff00000005400ULL,
0x0000002500747306ULL, 0x0003f0000000d400ULL, 0x0000002d008e7306ULL, 0x0004e2000000d400ULL,
0x000001002f257824ULL, 0x002fca00078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x000000d300e97306ULL, 0x000fe20000209400ULL, 0x00000100312d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe4000001142dULL, 0x000000d300ea7306ULL, 0x000fe20000205400ULL,
0x000000e2002d7245ULL, 0x000fe4000020d400ULL, 0x000000018e8e5812ULL, 0x008fe400078efcffULL,
0x000000012d2d2812ULL, 0x000fe400078efcffULL, 0x000000e8e700720bULL, 0x000fe20003f5d000ULL,
0x000000cf00eb7306ULL, 0x000ff00000209400ULL, 0x000000cf00ec7306ULL, 0x000e680000205400ULL,
0x00000001b9b92812ULL, 0x000fc800078efcffULL, 0x0000002e00cd7306ULL, 0x000ff00000009400ULL,
0x0000002e00cc7306ULL, 0x000ea20000005400ULL, 0x000000eceb00720bULL, 0x002fce0003fdd000ULL,
0x0000002500d27306ULL, 0x000ff00000209400ULL, 0x0000002500d77306ULL, 0x000fe20000205400ULL,
0x000000cccd00720bULL, 0x004fe20003fbd000ULL, 0x0000010033cd7824ULL, 0x000fca00078e00ffULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x0000002e00867306ULL, 0x0002b0000000d400ULL,
0x0000002f00bf7306ULL, 0x000fe20000009400ULL, 0x000000e4002e7245ULL, 0x002fc8000020d400ULL,
0x000000012e2e3812ULL, 0x000fe400078efcffULL, 0x000000eae900720bULL, 0x000fe20003f7d000ULL,
0x0000002f00ca7306ULL, 0x000e620000005400ULL, 0x0000000186865812ULL, 0x004fe400078efcffULL,
0x0000002eb72e723eULL, 0x000fca00000010ffULL, 0x000000d000d87306ULL, 0x000ff00000209400ULL,
0x000000d000db7306ULL, 0x000ff00000205400ULL, 0x0000002f00847306ULL, 0x0004f0000000d400ULL,
0x0000003100c57306ULL, 0x000fe20000009400ULL, 0x00009910b82f7816ULL, 0x004fc400000000ffULL,
0x000000cb00b87245ULL, 0x000fe4000020d400ULL, 0x000000ff2f00720cULL, 0x000fe40003f45270ULL,
0x00000001b8b84812ULL, 0x000fe200078efcffULL, 0x0000003100bc7306ULL, 0x000fe20000005400ULL,
0x000000d7d200720bULL, 0x000fe20003f9d000ULL, 0x0001000033d27824ULL, 0x000fe200078e00ffULL,
0x000000d3002f7245ULL, 0x000fe2000020d400ULL, 0x0001000026d37824ULL, 0x000fc600078e00ffULL,
0x000000012f2f3812ULL, 0x000fe200078efcffULL, 0x00000031007f7306ULL, 0x0005e2000000d400ULL,
0x000000cabf00720bULL, 0x002fe20003f7d000ULL, 0x0000010032ca7824ULL, 0x000fe200078e00ffULL,
0x0000002500bf7245ULL, 0x000fe4000020d400ULL, 0x00000018ffd27819ULL, 0x000fe400000114d2ULL,
0x00000001bfbf4812ULL, 0x000fe200078efcffULL, 0x000000c600c87306ULL, 0x000fe20000209400ULL,
0x0001000031317824ULL, 0x004fe200078e00ffULL, 0x00000018ffca7819ULL, 0x000fc400000114caULL,
0x0000002fb82f723eULL, 0x000fe400000010ffULL, 0x00000018ffcc7819ULL, 0x000fe40000011431ULL,
0x000000c600c97306ULL, 0x000e620000205400ULL, 0x000000cf00317245ULL, 0x000fe4000020d400ULL,
0x0000000184843812ULL, 0x008fe400078efcffULL, 0x0000000131316812ULL, 0x000fe400078efcffULL,
0x000000dbd800720bULL, 0x000fe20003fdd000ULL, 0x000000c200be7306ULL, 0x000fe20000209400ULL,
0x000000863186723eULL, 0x000fce00000010ffULL, 0x000000c200c77306ULL, 0x0004e20000205400ULL,
0x000000c9c800720bULL, 0x002fce0003fbd000ULL, 0x0000002c00d67306ULL, 0x000fe20000209400ULL,
0x000000c200c27245ULL, 0x004fce000020d400ULL, 0x0000002c00d97306ULL, 0x000fe20000205400ULL,
0x000000c7be00720bULL, 0x008fe20003f9d000ULL, 0x0001000028c77824ULL, 0x000fe200078e00ffULL,
0x000000c600be7245ULL, 0x000fe4000020d400ULL, 0x0000002400c67245ULL, 0x000fe4000020d400ULL,
0x00000001bebe5812ULL, 0x000fe200078efcffULL, 0x0000003000c37306ULL, 0x000fe20000009400ULL,
0x00000018ffc77819ULL, 0x000fca00000114c7ULL, 0x00000001c2c24812ULL, 0x000fe400078efcffULL,
0x0000003000c47306ULL, 0x000e700000005400ULL, 0x0000002400da7306ULL, 0x000ff00000209400ULL,
0x0000002400dd7306ULL, 0x000ea20000205400ULL, 0x000000c4c300720bULL, 0x002fe20003fbd000ULL,
0x000001002ac47824ULL, 0x000fe200078e00ffULL, 0x0000002c00c37245ULL, 0x000fc8000020d400ULL,
0x00000018ffc47819ULL, 0x000fe200000114c4ULL, 0x0000003300b17306ULL, 0x000ff00000009400ULL,
0x0000003300b47306ULL, 0x000fe20000005400ULL, 0x000000ddda00720bULL, 0x004fce0003f9d000ULL,
0x0000003300787306ULL, 0x0003ec000000d400ULL, 0x00000001c6c64812ULL, 0x000fe400078efcffULL,
0x0000003000807306ULL, 0x000ea2000000d400ULL, 0x000000d000337245ULL, 0x002fc8000020d400ULL,
0x0000000133336812ULL, 0x000fe400078efcffULL, 0x000000d9d600720bULL, 0x000fe20003fdd000ULL,
0x000000dc00307306ULL, 0x000fe20000209400ULL, 0x0000010029d67824ULL, 0x000fce00078e00ffULL,
0x000000dc00df7306ULL, 0x0002e20000205400ULL, 0x0000000180805812ULL, 0x004fc600078efcffULL,
0x00000001c3c36812ULL, 0x000fc800078efcffULL, 0x000000d100d47306ULL, 0x000fe20000209400ULL,
0x000000dc00dc7245ULL, 0x002fe4000020d400ULL, 0x00000080c380723eULL, 0x000fca00000010ffULL,
0x000000d100d57306ULL, 0x0002a20000205400ULL, 0x000000df3000720bULL, 0x008fe20003fdd000ULL,
0x000100002b307824ULL, 0x000fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x000000bb00c17306ULL, 0x000fe20000209400ULL, 0x000000d100d17245ULL, 0x002fca000020d400ULL,
0x00000001dcdc6812ULL, 0x000fe400078efcffULL, 0x000000bb00c07306ULL, 0x0002e20000205400ULL,
0x000000d5d400720bULL, 0x004fe20003f7d000ULL, 0x0001000027d47824ULL, 0x000fe400078e00ffULL,
0x0000010028d57824ULL, 0x000fc800078e00ffULL, 0x000000cc00cb7306ULL, 0x000fe20000209400ULL,
0x000000bb00bb7245ULL, 0x002fca000020d400ULL, 0x00000001d1d13812ULL, 0x000fe400078efcffULL,
0x000000cc00ce7306ULL, 0x000e620000205400ULL, 0x000000c0c100720bULL, 0x008fe40003fbd000ULL,
0x000000bcc500720bULL, 0x000fe20003f7d000ULL, 0x0001000029c57824ULL, 0x000fe400078e00ffULL,
0x000001002bbc7824ULL, 0x000fe400078e00ffULL, 0x0000003200b67306ULL, 0x000fe20000009400ULL,
0x00000018ffc57819ULL, 0x000fc400000114c5ULL, 0x00000018ffbc7819ULL, 0x000fc600000114bcULL,
0x00000001bbbb5812ULL, 0x000fe400078efcffULL, 0x0000003200b57306ULL, 0x000ea20000005400ULL,
0x000000cecb00720bULL, 0x002fe40003f9d000ULL, 0x000000017f7f3812ULL, 0x000fe400078efcffULL,
0x000000dcbbdc723eULL, 0x000fc600000010ffULL, 0x000000ca00257306ULL, 0x000ff00000209400ULL,
0x000000ca00c87306ULL, 0x000e620000205400ULL, 0x000000b5b600720bULL, 0x004fe40003fdd000ULL,
0x000000cc00b57245ULL, 0x000fc4000020d400ULL, 0x000000b300b67245ULL, 0x000fe4000020d400ULL,
0x00000001b5b54812ULL, 0x000fe200078efcffULL, 0x0000003200797306ULL, 0x0004e2000000d400ULL,
0x000000b4b100720bULL, 0x000fe40003f9d000ULL, 0x000000ca00b47245ULL, 0x000fe4000020d400ULL,
0x00000046ffb1723eULL, 0x000fc600000010ffULL, 0x000000b300bd7306ULL, 0x000fe20000209400ULL,
0x0001000032327824ULL, 0x004fe200078e00ffULL, 0x000000c82500720bULL, 0x002fe40003fbd000ULL,
0x00005410b1c87816ULL, 0x000fe400000000b1ULL, 0x00000018ffc97819ULL, 0x000fe20000011432ULL,
0x000100002a327824ULL, 0x000fe200078e00ffULL, 0x000000b300ba7306ULL, 0x0002a20000205400ULL,
0x0000000178784812ULL, 0x000fe400078efcffULL, 0x0000000179796812ULL, 0x008fc400078efcffULL,
0x000000cd00b17245ULL, 0x000fe4000020d400ULL, 0x00000001b4b45812ULL, 0x000fe200078efcffULL,
0x000000a600a97306ULL, 0x000fe20000209400ULL, 0x00000018ffb37819ULL, 0x002fe400000114d3ULL,
0x00000018ff327819ULL, 0x000fca0000011432ULL, 0x000000a600987306ULL, 0x0002e20000205400ULL,
0x000000babd00720bULL, 0x004fe40003f7d000ULL, 0x00000002ffbd7819ULL, 0x000fca000001163bULL,
0x000000c9002c7306ULL, 0x000fe20000209400ULL, 0x000000a600a67245ULL, 0x002fe2000020d400ULL,
0x00001fbdc8bd7589ULL, 0x000fe800000e0000ULL, 0x00000001b6b63812ULL, 0x000fe400078efcffULL,
0x000000c900c17306ULL, 0x000e620000205400ULL, 0x00000098a900720bULL, 0x008fe40003f9d000ULL,
0x000000b5b6dd723eULL, 0x000fca00000010ffULL, 0x0000009500947306ULL, 0x000fec0000209400ULL,
0x00000001a6a64812ULL, 0x000fe400078efcffULL, 0x0000009500997306ULL, 0x0004e20000205400ULL,
0x000000c12c00720bULL, 0x002fe40003fbd000ULL, 0x00001f53c82c7589ULL, 0x000fea00000e0000ULL,
0x0000002600a07306ULL, 0x000fe20000009400ULL, 0x0000009500957245ULL, 0x004fce000020d400ULL,
0x0000002600937306ULL, 0x000e620000005400ULL, 0x000000999400720bULL, 0x008fe40003fdd000ULL,
0x000000c900947245ULL, 0x000fe4000020d400ULL, 0x00000018ff997819ULL, 0x000fe400000114d4ULL,
0x0000000194945812ULL, 0x000fe200078efcffULL, 0x0000002600597306ULL, 0x000ea2000000d400ULL,
0x0000008c8900720bULL, 0x000fe40003fbd000ULL, 0x000000d200897245ULL, 0x000fc4000020d400ULL,
0x00000018ff8c7819ULL, 0x000fe400000114d5ULL, 0x0000000195956812ULL, 0x000fe200078efcffULL,
0x00000027009e7306ULL, 0x000fe20000009400ULL, 0x00000096a700720bULL, 0x000fca0003fdd000ULL,
0x0000000173735812ULL, 0x000fe400078efcffULL, 0x00000027008f7306ULL, 0x000fe20000005400ULL,
0x00000093a000720bULL, 0x002fca0003fbd000ULL, 0x0000000174746812ULL, 0x000fe400078efcffULL,
0x0000002700587306ULL, 0x0003ec000000d400ULL, 0x0000000159595812ULL, 0x004fe400078efcffULL,
0x00000028008a7306ULL, 0x000fe20000009400ULL, 0x00a000005224783bULL, 0x002e6e0000000200ULL,
0x0000002800877306ULL, 0x000ff00000005400ULL, 0x0000002800577306ULL, 0x000ff0000000d400ULL,
0x0000002900887306ULL, 0x000ff00000009400ULL, 0x0000002900857306ULL, 0x000ff00000005400ULL,
0x00000029005b7306ULL, 0x000fe2000000d400ULL, 0x000000bd2424a231ULL, 0x002fc400003400ffULL,
0x000000bd2626a231ULL, 0x000fe400003400ffULL, 0x0000002c2525a231ULL, 0x080fe400003400ffULL,
0x0000002c2727a231ULL, 0x000fe200003400ffULL, 0x0000002a007a7306ULL, 0x000ff00000009400ULL,
0x0000002a00777306ULL, 0x000ff00000005400ULL, 0x0000002a00007306ULL, 0x000ff0000000d400ULL,
0x0000002b00757306ULL, 0x000ff00000009400ULL, 0x0000002b00767306ULL, 0x000ff00000005400ULL,
0x0000002b005a7306ULL, 0x0003f0000000d400ULL, 0x000000cd00cf7306ULL, 0x000fe20000209400ULL,
0x00a000005128783bULL, 0x002e6e0000000200ULL, 0x000000cd00d07306ULL, 0x000eb00000205400ULL,
0x0000009100a57306ULL, 0x000ff00000209400ULL, 0x0000009100a87306ULL, 0x0007220000205400ULL,
0x000000d0cf00720bULL, 0x004fce0003f7d000ULL, 0x000000d200c07306ULL, 0x000fe20000209400ULL,
0x0000009100917245ULL, 0x008fca000020d400ULL, 0x00000001b1b13812ULL, 0x000fe400078efcffULL,
0x000000d200cb7306ULL, 0x000ea20000205400ULL, 0x000000a8a500720bULL, 0x010fe20003f9d000ULL,
0x000000bd2828a231ULL, 0x082fe200003400ffULL, 0x00000078b1b1723eULL, 0x000fe200000010ffULL,
0x000000bd2a2aa231ULL, 0x000fe400003400ffULL, 0x0000002c2929a231ULL, 0x080fe400003400ffULL,
0x0000008b00a17306ULL, 0x000fe20000209400ULL, 0x0000002c2b2ba231ULL, 0x000fe200003400ffULL,
0x0000009c2d2c723eULL, 0x000fc400000010ffULL, 0x0000008eb92d723eULL, 0x000fe400000010ffULL,
0x0000000191914812ULL, 0x000fe400078efcffULL, 0x0000008b00927306ULL, 0x000e620000205400ULL,
0x000000cbc000720bULL, 0x004fe20003f7d000ULL, 0x0000002e280c723cULL, 0x000fe2000004180cULL,
0x0000007491a5723eULL, 0x000fca00000010ffULL, 0x000000aa00ab7306ULL, 0x000fe40000209400ULL,
0x0000002c2808723cULL, 0x040fe80000041808ULL, 0x0000000189893812ULL, 0x000fe400078efcffULL,
0x000000aa00ae7306ULL, 0x0004e20000205400ULL, 0x00000092a100720bULL, 0x002fe20003f9d000ULL,
0x000000dc281c723cULL, 0x000fe2000004181cULL, 0x00000033be2c723eULL, 0x000fc400000010ffULL,
0x000000d1c22d723eULL, 0x000fe400000010ffULL, 0x00000089a689723eULL, 0x000fe200000010ffULL,
0x000000a400977306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x004fe4000020d400ULL,
0x0000003000337245ULL, 0x000fe2000020d400ULL, 0x0000002c2814723cULL, 0x000fe80000041814ULL,
0x000000a400907306ULL, 0x0002a20000205400ULL, 0x000000aeab00720bULL, 0x008fc40003f5d000ULL,
0x0000008b00ab7245ULL, 0x000fe4000020d400ULL, 0x00000083008b7245ULL, 0x000fe4000020d400ULL,
0x00000001abab4812ULL, 0x000fe200078efcffULL, 0x000000ac00ad7306ULL, 0x000fe20000209400ULL,
0x000000a400a47245ULL, 0x002fe4000020d400ULL, 0x0000007b002c7245ULL, 0x000fc6000020d400ULL,
0x00000001aaaa2812ULL, 0x000fe400078efcffULL, 0x000000ac00b07306ULL, 0x0002e20000205400ULL,
0x000000909700720bULL, 0x004fe40003f7d000ULL, 0x00000018ff907819ULL, 0x000fe400000114d6ULL,
0x0000008f9e00720bULL, 0x000fc60003f5d000ULL, 0x0000007e00827306ULL, 0x000fe20000209400ULL,
0x000000ac00ac7245ULL, 0x002fca000020d400ULL, 0x00000001a4a43812ULL, 0x000fe400078efcffULL,
0x0000007e00817306ULL, 0x0002a20000205400ULL, 0x000000b0ad00720bULL, 0x008fe40003fdd000ULL,
0x0000000158582812ULL, 0x000fe400078efcffULL, 0x00000079b4b0723eULL, 0x000fe400000010ffULL,
0x00000073a4a4723eULL, 0x000fe200000010ffULL, 0x00000083009a7306ULL, 0x000fe20000209400ULL,
0x0000007e007e7245ULL, 0x002fc6000020d400ULL, 0x000000b02820723cULL, 0x000fe40000041820ULL,
0x00000001acac6812ULL, 0x000fe400078efcffULL, 0x00000083009d7306ULL, 0x000e620000205400ULL,
0x000000818200720bULL, 0x004fe40003fbd000ULL, 0x000000878a00720bULL, 0x000fe20003fdd000ULL,
0x000000a42408723cULL, 0x000fe20000041808ULL, 0x0000008d008a7245ULL, 0x000fe4000020d400ULL,
0x00000084bf87723eULL, 0x000fe200000010ffULL, 0x0000009f00a27306ULL, 0x000fe20000209400ULL,
0x0000007fc681723eULL, 0x000fc400000010ffULL, 0x00000099007f7245ULL, 0x000fe4000020d400ULL,
0x000000acabab723eULL, 0x000fe200000010ffULL, 0x000000862810723cULL, 0x000fe20000041810ULL,
0x000000017e7e5812ULL, 0x000fe200078efcffULL, 0x0000009f00a37306ULL, 0x0004e20000205400ULL,
0x0000009d9a00720bULL, 0x002fe40003f9d000ULL, 0x0000000157576812ULL, 0x000fc600078efcffULL,
0x000000802818723cULL, 0x000fe40000041818ULL, 0x000000b300ba7306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x004fca000020d400ULL, 0x000000018b8b4812ULL, 0x000fe400078efcffULL,
0x000000b300c17306ULL, 0x0002a20000205400ULL, 0x000000a3a200720bULL, 0x008fe40003f7d000ULL,
0x000000588b8b723eULL, 0x000fca00000010ffULL, 0x0000008c00967306ULL, 0x000fe20000209400ULL,
0x000000b300b37245ULL, 0x002fca000020d400ULL, 0x000000019f9f3812ULL, 0x000fe400078efcffULL,
0x0000008c00977306ULL, 0x0002e20000205400ULL, 0x000000c1ba00720bULL, 0x004fe40003f9d000ULL,
0x000000aa9faa723eULL, 0x000fca00000010ffULL, 0x0000007b007c7306ULL, 0x000fe20000209400ULL,
0x0000008c008c7245ULL, 0x002fe2000020d400ULL, 0x000000aa240c723cULL, 0x000fe8000004180cULL,
0x00000001b3b34812ULL, 0x000fe400078efcffULL, 0x0000007b007d7306ULL, 0x000e620000205400ULL,
0x000000979600720bULL, 0x008fe40003fbd000ULL, 0x000000b37e7e723eULL, 0x000fca00000010ffULL,
0x0000008d00af7306ULL, 0x000fec0000209400ULL, 0x000000018c8c5812ULL, 0x000fe400078efcffULL,
0x0000008d00b27306ULL, 0x000ea20000205400ULL, 0x0000007d7c00720bULL, 0x002fe40003f9d000ULL,
0x000000578c8c723eULL, 0x000fca00000010ffULL, 0x0000009000937306ULL, 0x000fec0000209400ULL,
0x000000012c2c4812ULL, 0x000fe400078efcffULL, 0x0000009000927306ULL, 0x0002e20000205400ULL,
0x000000b2af00720bULL, 0x004fe40003f7d000ULL, 0x000000767500720bULL, 0x000fca0003f9d000ULL,
0x000000c7008e7306ULL, 0x000fe20000209400ULL, 0x0000009000907245ULL, 0x002fca000020d400ULL,
0x000000018a8a3812ULL, 0x000fe400078efcffULL, 0x000000c7008d7306ULL, 0x0002a20000205400ULL,
0x000000929300720bULL, 0x008fe40003fbd000ULL, 0x000000858800720bULL, 0x000fe40003f7d000ULL,
0x000000949588723eULL, 0x000fe400000010ffULL, 0x000000598a8a723eULL, 0x000fe200000010ffULL,
0x0000009900987306ULL, 0x000fe20000209400ULL, 0x000000c700c77245ULL, 0x002fc4000020d400ULL,
0x000000015a5a4812ULL, 0x000fe200078efcffULL, 0x000000882804723cULL, 0x000fe40000041804ULL,
0x0000000190905812ULL, 0x000fe400078efcffULL, 0x0000009900a77306ULL, 0x000e620000205400ULL,
0x0000008d8e00720bULL, 0x004fe40003fdd000ULL, 0x0000005f00287245ULL, 0x000fe2000020d400ULL,
0x0000008a2410723cULL, 0x000fe20000041810ULL, 0x000000015b5b3812ULL, 0x000fc400078efcffULL,
0x000000c400297245ULL, 0x000fe2000020d400ULL, 0x0000005c005d7306ULL, 0x000fe20000209400ULL,
0x0000005b908d723eULL, 0x000fca00000010ffULL, 0x00000001c7c76812ULL, 0x000fe400078efcffULL,
0x0000005c005e7306ULL, 0x0004e20000205400ULL, 0x000000a79800720bULL, 0x002fe20003f5d000ULL,
0x0000008c2418723cULL, 0x000fec0000041818ULL, 0x0000005f00607306ULL, 0x000fe20000209400ULL,
0x0000005c005c7245ULL, 0x004fca000020d400ULL, 0x000000017f7f2812ULL, 0x000fe400078efcffULL,
0x0000005f00617306ULL, 0x000e620000205400ULL, 0x0000005e5d00720bULL, 0x008fe40003fbd000ULL,
0x000000777a00720bULL, 0x000fe40003f5d000ULL, 0x000000c5005d7245ULL, 0x000fe4000020d400ULL,
0x0000007f2c7f723eULL, 0x000fe200000010ffULL, 0x000000c5002e7306ULL, 0x000fec0000209400ULL,
0x000000015c5c5812ULL, 0x000fe200078efcffULL, 0x0000007e2414723cULL, 0x000fe20000041814ULL,
0x000000c5002f7306ULL, 0x000ea20000205400ULL, 0x000000616000720bULL, 0x002fc40003fdd000ULL,
0x0000000100002812ULL, 0x000fe400078efcffULL, 0x000000c75c5c723eULL, 0x000fc600000010ffULL,
0x000000c4002d7306ULL, 0x000fec0000209400ULL, 0x0000000128286812ULL, 0x000fe400078efcffULL,
0x000000c4007c7306ULL, 0x000e620000205400ULL, 0x0000002f2e00720bULL, 0x004fce0003f7d000ULL,
0x000000bc00317306ULL, 0x000fec0000209400ULL, 0x000000015d5d3812ULL, 0x000fe400078efcffULL,
0x000000bc00767306ULL, 0x000ea20000205400ULL, 0x0000007c2d00720bULL, 0x002fe40003fbd000ULL,
0x0000005d285d723eULL, 0x000fca00000010ffULL, 0x00000032002a7306ULL, 0x000fe40000209400ULL,
0x0000005c241c723cULL, 0x000fe8000004181cULL, 0x0000000129295812ULL, 0x000fe400078efcffULL,
0x00000032002b7306ULL, 0x0002e20000205400ULL, 0x000000763100720bULL, 0x004fe40003fdd000ULL,
0x000000002928723eULL, 0x000fca00000010ffULL, 0x0000006d006e7306ULL, 0x000fe20000209400ULL,
0x0000003200327245ULL, 0x002fce000020d400ULL, 0x0000006d006f7306ULL, 0x0002a20000205400ULL,
0x0000002b2a00720bULL, 0x008fe40003f5d000ULL, 0x000000bc002b7245ULL, 0x000fc8000020d400ULL,
0x000000012b2b6812ULL, 0x000fe200078efcffULL, 0x0000007000717306ULL, 0x000fe20000209400ULL,
0x0000006d006d7245ULL, 0x002fe4000020d400ULL, 0x0000005a2b29723eULL, 0x000fc600000010ffULL,
0x0000000132322812ULL, 0x000fe400078efcffULL, 0x0000007000727306ULL, 0x0002e20000205400ULL,
0x0000006f6e00720bULL, 0x004fe20003f7d000ULL, 0x000000282420723cULL, 0x000fec0000041820ULL,
0x00000030002e7306ULL, 0x000fe20000209400ULL, 0x0000007000707245ULL, 0x002fc4000020d400ULL,
0x00000002ff287819ULL, 0x000fc60000011634ULL, 0x000000016d6d3812ULL, 0x000fe400078efcffULL,
0x00000030002d7306ULL, 0x000e620000205400ULL, 0x000000727100720bULL, 0x008fe40003fbd000ULL,
0x000000326d32723eULL, 0x000fe400000010ffULL, 0x0000f63028007811ULL, 0x000fd200078e20ffULL,
0x0000000170705812ULL, 0x000fe400078efcffULL, 0x0000002d2e00720bULL, 0x002fda0003fdd000ULL,
0x0000000133336812ULL, 0x000fc800078efcffULL, 0x000000337033723eULL, 0x000fce00000010ffULL,
0x000000322404723cULL, 0x000fe20000041804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200042ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004028247824ULL, 0x000fe200078e0265ULL,
0x000000ff56ff7812ULL, 0x000fe2000784c0ffULL, 0x0000000000ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ff9bff7812ULL, 0x000fe4000786c0ffULL, 0x000000c024247810ULL, 0x000fe40007ffe0ffULL,
0x00000001ff2d7807ULL, 0x000fe40001000000ULL, 0x000000352400720cULL, 0x000fc40003f46070ULL,
0x0000000145727812ULL, 0x000fe400078ec0ffULL, 0x00000001ff717807ULL, 0x000fe40001800000ULL,
0x0000002d02707207ULL, 0x000fe40004800000ULL, 0x0000000172727812ULL, 0x000fca00078e3cffULL,
0x0000296000002947ULL, 0x000fea0003800000ULL, 0x0000240042007984ULL, 0x004ea20000000800ULL,
0x8000000066257824ULL, 0x000fca00078e00ffULL, 0x8000000000ff7812ULL, 0x004fe20007844825ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000002947ULL, 0x000fea0003800000ULL,
0x0000240042007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007844825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000066257824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x0000240042247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007844825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x00000001ff557819ULL, 0x000fe20000011634ULL,
0x00000080ff337424ULL, 0x000fe200078e00ffULL, 0x0000030036007a10ULL, 0x000fe40007ffe0ffULL,
0x0000001038277812ULL, 0x000fe400078ec0ffULL, 0x0000000100267810ULL, 0x040fe20007ffe0ffULL,
0x0000000800247824ULL, 0x000fe200078e0255ULL, 0x00000003ff297819ULL, 0x000fe4000001163bULL,
0x000000392600720cULL, 0x000fe20003f46070ULL, 0x0000002024247824ULL, 0x000fe200078e00ffULL,
0x00000004292f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000829317810ULL, 0x000fe40007ffe0ffULL,
0x0000002435257217ULL, 0x000fe40007800000ULL, 0x000000603e007812ULL, 0x000fc600078ef824ULL,
0x0000000125257824ULL, 0x000fe400078e0a24ULL, 0x0000003f3a267224ULL, 0x020fc600078e0200ULL,
0x0000002025257807ULL, 0x000fe20001000000ULL, 0x0000000149247824ULL, 0x100fe400078e0226ULL,
0x000000014c287824ULL, 0x000fe200078e0226ULL, 0x0000002527007217ULL, 0x000fe20007800000ULL,
0x00005e0024247625ULL, 0x000fc800078e0033ULL, 0x0000000100007824ULL, 0x000fe200078e0a27ULL,
0x0000004f242a7210ULL, 0x000fe20007f5e0ffULL, 0x000000014a277824ULL, 0x100fe400078e0226ULL,
0x000000014b247824ULL, 0x000fe200078e0226ULL, 0x000000002900720cULL, 0x080fe20003f66070ULL,
0x00005e0027267625ULL, 0x000fe200078e0033ULL, 0x000000003100720cULL, 0x000fc60003fc6070ULL,
0x000000ffff2b7224ULL, 0x000fe200010e0625ULL, 0x0000004f26267210ULL, 0x000fe20007fbe0ffULL,
0x00005e0024247625ULL, 0x080fe200078e0033ULL, 0x000000002f00720cULL, 0x080fe40003f46070ULL,
0x0000000c292f7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0028287625ULL, 0x000fe200078e0033ULL,
0x0000004f24247210ULL, 0x080fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a687faeULL, 0x0005e4000d901c48ULL, 0x000000ffff277224ULL, 0x000fe200028e0627ULL,
0x000000002f00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff257224ULL, 0x000fe200020e0625ULL,
0x0000004f28287210ULL, 0x000fc60007f9e0ffULL, 0x0000000026697faeULL, 0x0005e4000d101c48ULL,
0x000000ffff297224ULL, 0x000fe400020e0629ULL, 0x00000000246a7faeULL, 0x0005e8000f101c48ULL,
0x00000000286b7faeULL, 0x0005e8000e901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000040067677984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f63c0047247984ULL, 0x004ea20000000800ULL, 0x0000002d02027207ULL, 0x000fe20004800000ULL,
0x800000004d257824ULL, 0x000fc600078e00ffULL, 0x0000ffff02287812ULL, 0x000fca00078ec0ffULL,
0x8000000028007824ULL, 0x000fca00078e00ffULL, 0x8000000067ff7812ULL, 0x008fe40007844800ULL,
0x8000000024ff7812ULL, 0x004fe20007864825ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000003947ULL, 0x000fea0003800000ULL, 0x800000004d4d7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x00f63c0047247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc4000786484dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000b947ULL, 0x000fea000383ffffULL,
0x000001804f257810ULL, 0x000fe20007ffe04eULL, 0x00000001ff6a7424ULL, 0x000fc800078e00ffULL,
0x0000000150257824ULL, 0x000fca00078e0225ULL, 0x00f0000025277984ULL, 0x000ea80000000800ULL,
0x00f2000025007984ULL, 0x0007220000000800ULL, 0x000000402700720bULL, 0x004fda0003f7d000ULL,
0x0000000000247806ULL, 0x000fc800018e0100ULL, 0x0000ffff24297812ULL, 0x000fda000786c0ffULL,
0x000003700000b947ULL, 0x000fea0003800000ULL, 0x000000402700720bULL, 0x018fe40003f74000ULL,
0x00000027402b7209ULL, 0x000fe40007810000ULL, 0x0000000334257811ULL, 0x000fe400078ff0ffULL,
0x00000002ff2f7819ULL, 0x000fe2000001163bULL, 0x8000002b40247221ULL, 0x100fe20000010000ULL,
0x000000ffff407224ULL, 0x000fc600078e002bULL, 0x3fb8aa3b24267820ULL, 0x000fe40000410000ULL,
0x0000000000247806ULL, 0x000fe400018e0100ULL, 0x000000342500720cULL, 0x000fe40003f65270ULL,
0x0000ffff242a7812ULL, 0x000fe200078e3cffULL, 0x0000002600267308ULL, 0x000ea60000000800ULL,
0x0000002a29ff7212ULL, 0x000fc8000788c0ffULL, 0x00000001ff6a7807ULL, 0x000fc60002000000ULL,
0x00000080344fb824ULL, 0x000fc800078e024fULL, 0x000000015050b824ULL, 0x000fe200078e024fULL,
0x00001f2f26247589ULL, 0x004ea200000e0000ULL, 0x8000002b27274221ULL, 0x000fe20000010000ULL,
0x0000002641417220ULL, 0x000fe40000410000ULL, 0x00001f5326257589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b27274820ULL, 0x000fc60000410000ULL, 0x00f4002b5000b388ULL, 0x0009e20000000800ULL,
0x0000002700464308ULL, 0x000f620000000800ULL, 0x0000002408087220ULL, 0x084fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002420207220ULL, 0x080fe20000410000ULL,
0x0000002421217220ULL, 0x080fe20000410000ULL, 0x0000002404047220ULL, 0x080fe20000410000ULL,
0x0000002405057220ULL, 0x000fe20000410000ULL, 0x000000250a0a7220ULL, 0x088fe20000410000ULL,
0x000000250b0b7220ULL, 0x080fe20000410000ULL, 0x000000250e0e7220ULL, 0x080fe20000410000ULL,
0x000000250f0f7220ULL, 0x080fe20000410000ULL, 0x0000002512127220ULL, 0x080fe20000410000ULL,
0x0000002513137220ULL, 0x080fe20000410000ULL, 0x0000002516167220ULL, 0x080fe20000410000ULL,
0x0000002517177220ULL, 0x080fe20000410000ULL, 0x000000251a1a7220ULL, 0x080fe20000410000ULL,
0x000000251b1b7220ULL, 0x080fe20000410000ULL, 0x000000251e1e7220ULL, 0x080fe20000410000ULL,
0x000000251f1f7220ULL, 0x080fe20000410000ULL, 0x0000002522227220ULL, 0x080fe20000410000ULL,
0x0000002523237220ULL, 0x080fe20000410000ULL, 0x0000002506067220ULL, 0x080fe20000410000ULL,
0x0000002507077220ULL, 0x000fe20000410000ULL, 0x0000000046004220ULL, 0x020fc80000410000ULL,
0x0000004100417221ULL, 0x018fe20000010000ULL, 0x0000011000002947ULL, 0x000fea0003800000ULL,
0x0000000845007824ULL, 0x000fca00078e00ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000103007824ULL, 0x000fe400078e0200ULL, 0x8000000028037824ULL, 0x000fc800078e00ffULL,
0x00f64c0000007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007844803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000028287824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000037305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000030000735dULL, 0x008fe40003800000ULL, 0x0000040054037984ULL, 0x000ea40000000800ULL,
0x8000000003ff7812ULL, 0x004fc40007844828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000006c6c783bULL, 0x000ea80000004200ULL,
0x000000006224783bULL, 0x000ee80000004200ULL, 0x000000006328783bULL, 0x000f280000004200ULL,
0x000000006464783bULL, 0x000f620000004200ULL, 0x000100006cd37824ULL, 0x044fe200078e00ffULL,
0x0000006c00ae7306ULL, 0x000fe20000009400ULL, 0x000001006cd07824ULL, 0x000fe200078e00ffULL,
0x00000018ffb17819ULL, 0x000fe2000001146cULL, 0x000100006dcb7824ULL, 0x040fe200078e00ffULL,
0x00000018ffd37819ULL, 0x000fe200000114d3ULL, 0x000001006dce7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd07819ULL, 0x000fe200000114d0ULL, 0x000001006eb87824ULL, 0x040fe200078e00ffULL,
0x0000006c00af7306ULL, 0x000ea20000005400ULL, 0x00000018ffa87819ULL, 0x000fe2000001146dULL,
0x000001006fb77824ULL, 0x040fe200078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe200000114cbULL,
0x000100006eb47824ULL, 0x000fe200078e00ffULL, 0x00000018ffce7819ULL, 0x000fe200000114ceULL,
0x000100006fb57824ULL, 0x000fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe200000114b8ULL,
0x0000006c00777306ULL, 0x000e62000000d400ULL, 0x00000018ffb77819ULL, 0x000fe200000114b7ULL,
0x0000010024ad7824ULL, 0x048fe200078e00ffULL, 0x00000018ffa17819ULL, 0x000fe2000001146eULL,
0x0000010025ac7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x0001000024b27824ULL, 0x000fe200078e00ffULL, 0x00000018ffb57819ULL, 0x000fe200000114b5ULL,
0x000000d3006c7306ULL, 0x000fe20000209400ULL, 0x000000afae00720bULL, 0x004fe20003fdd000ULL,
0x00010000278d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe2000001146fULL,
0x0000010028957824ULL, 0x010fe200078e00ffULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x0000010029d87824ULL, 0x000fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fe20000011424ULL,
0x000000d300bf7306ULL, 0x0004e20000205400ULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x000001002ada7824ULL, 0x040fe200078e00ffULL, 0x00000018ffb27819ULL, 0x000fe200000114b2ULL,
0x000100002a9e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011425ULL,
0x000100002b947824ULL, 0x000fe200078e00ffULL, 0x0000000177776812ULL, 0x002fe200078efcffULL,
0x000000d000b07306ULL, 0x000fe20000209400ULL, 0x000000d300d37245ULL, 0x004fe2000020d400ULL,
0x0000010064ae7824ULL, 0x060fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe20000011426ULL,
0x0001000064af7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fc40000011427ULL,
0x00000018ff857819ULL, 0x000fe20000011428ULL, 0x000000d000b97306ULL, 0x0002a20000205400ULL,
0x000000bf6c00720bULL, 0x008fe20003fbd000ULL, 0x00010000656c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe40000011429ULL, 0x00000018ff617819ULL, 0x000fe4000001142aULL,
0x00000018ff5e7819ULL, 0x000fe2000001142bULL, 0x000000b100cc7306ULL, 0x000fe20000209400ULL,
0x000000d000d07245ULL, 0x002fc4000020d400ULL, 0x00000018ff8d7819ULL, 0x000fe4000001148dULL,
0x00000018ff957819ULL, 0x000fe40000011495ULL, 0x00000001d3d35812ULL, 0x000fe200078efcffULL,
0x000000b100cf7306ULL, 0x000e620000205400ULL, 0x000000b9b000720bULL, 0x004fe20003f7d000ULL,
0x0000010065b97824ULL, 0x000fe200078e00ffULL, 0x00000018ff947819ULL, 0x000fe40000011494ULL,
0x00000018ffae7819ULL, 0x000fc400000114aeULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x0000006d00c67306ULL, 0x000fe20000009400ULL, 0x00000018ff9e7819ULL, 0x000fe4000001149eULL,
0x00000018ffb97819ULL, 0x000fe400000114b9ULL, 0x00000018ffaf7819ULL, 0x000fe400000114afULL,
0x00000001d0d03812ULL, 0x000fe200078efcffULL, 0x0000006d00c17306ULL, 0x000ea20000005400ULL,
0x000000cfcc00720bULL, 0x002fc40003f5d000ULL, 0x00000018ffcc7819ULL, 0x000fe400000114d8ULL,
0x00000018ff337819ULL, 0x000fe40000011464ULL, 0x00000018ff4b7819ULL, 0x000fe20000011465ULL,
0x000000a800b67306ULL, 0x000fe20000209400ULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x00000018ff4e7819ULL, 0x000fe40000011466ULL, 0x00000018ff547819ULL, 0x000fc60000011467ULL,
0x000000a800b37306ULL, 0x0002e20000205400ULL, 0x000000c1c600720bULL, 0x004fce0003f9d000ULL,
0x000000cb00d77306ULL, 0x000fe20000209400ULL, 0x000000a800a87245ULL, 0x002fce000020d400ULL,
0x000000cb00d47306ULL, 0x0002a20000205400ULL, 0x000000b3b600720bULL, 0x008fe40003fdd000ULL,
0x000000b100b67245ULL, 0x000fe4000020d400ULL, 0x000000ce00b17245ULL, 0x000fe4000020d400ULL,
0x00000001b6b62812ULL, 0x000fe200078efcffULL, 0x000000ce00d67306ULL, 0x000fe20000209400ULL,
0x000000cb00cb7245ULL, 0x002fe4000020d400ULL, 0x000000d3b6b6723eULL, 0x000fc600000010ffULL,
0x00000001a8a86812ULL, 0x000fe400078efcffULL, 0x000000ce00d97306ULL, 0x000e620000205400ULL,
0x000000d4d700720bULL, 0x004fce0003fbd000ULL, 0x000000b800d27306ULL, 0x000fec0000209400ULL,
0x00000001cbcb5812ULL, 0x000fe400078efcffULL, 0x000000b800d57306ULL, 0x000ea20000205400ULL,
0x000000d9d600720bULL, 0x002fce0003f7d000ULL, 0x0000006d00767306ULL, 0x0002ec000000d400ULL,
0x00000001b1b13812ULL, 0x000fe400078efcffULL, 0x000000b700c27306ULL, 0x000fe20000209400ULL,
0x000000d5d200720bULL, 0x004fe20003f5d000ULL, 0x00000100276d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x000000b700d17306ULL, 0x000e620000205400ULL,
0x0000000176764812ULL, 0x008fc800078efcffULL, 0x00000076b1b1723eULL, 0x000fe400000010ffULL,
0x0000007500767245ULL, 0x000fe2000020d400ULL, 0x0000006f00a97306ULL, 0x000ff00000009400ULL,
0x0000006f00a67306ULL, 0x000ea20000005400ULL, 0x000000d1c200720bULL, 0x002fce0003f9d000ULL,
0x0000006e00ab7306ULL, 0x000ff00000009400ULL, 0x0000006e00aa7306ULL, 0x000e620000005400ULL,
0x000000a6a900720bULL, 0x004fe40003fbd000ULL, 0x000000b800a97245ULL, 0x000fc8000020d400ULL,
0x00000001a9a92812ULL, 0x000fe200078efcffULL, 0x000000a100a77306ULL, 0x000ff00000209400ULL,
0x000000a100a47306ULL, 0x0004e20000205400ULL, 0x000000aaab00720bULL, 0x002fce0003f7d000ULL,
0x000000b400ca7306ULL, 0x000fe20000209400ULL, 0x000000a100a17245ULL, 0x004fce000020d400ULL,
0x000000b400cd7306ULL, 0x0002a20000205400ULL, 0x000000a4a700720bULL, 0x008fe40003f5d000ULL,
0x000000b700a47245ULL, 0x000fe4000020d400ULL, 0x000000cba8b7723eULL, 0x000fe400000010ffULL,
0x00000001a4a44812ULL, 0x000fe200078efcffULL, 0x000000b500c87306ULL, 0x000fe20000209400ULL,
0x000000b400b47245ULL, 0x002fca000020d400ULL, 0x00000001a1a12812ULL, 0x000fe400078efcffULL,
0x000000b500c97306ULL, 0x0002e20000205400ULL, 0x000000cdca00720bULL, 0x004fce0003fdd000ULL,
0x0000006e00707306ULL, 0x000522000000d400ULL, 0x000000b500b57245ULL, 0x002fca000020d400ULL,
0x00000001b4b46812ULL, 0x000fe400078efcffULL, 0x0000006f00717306ULL, 0x000362000000d400ULL,
0x000000c9c800720bULL, 0x008fe20003f9d000ULL, 0x00010000266e7824ULL, 0x004fe200078e00ffULL,
0x000000b4a1b4723eULL, 0x000fc800000010ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001146eULL,
0x0000002400a57306ULL, 0x000fe20000009400ULL, 0x0000000170703812ULL, 0x010fe200078efcffULL,
0x00000100266f7824ULL, 0x002fc600078e00ffULL, 0x00000070a970723eULL, 0x000fe400000010ffULL,
0x00000001b5b54812ULL, 0x000fe200078efcffULL, 0x0000002400a27306ULL, 0x000e620000005400ULL,
0x0000000171715812ULL, 0x020fe400078efcffULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x00000071a471723eULL, 0x000fc600000010ffULL, 0x0000009f00a37306ULL, 0x000ff00000209400ULL,
0x0000009f00a07306ULL, 0x000ea20000205400ULL, 0x000000a2a500720bULL, 0x002fce0003f7d000ULL,
0x0000002400637306ULL, 0x0002f0000000d400ULL, 0x00000025009c7306ULL, 0x000fe20000009400ULL,
0x0001000025247824ULL, 0x002fe200078e00ffULL, 0x000000a0a300720bULL, 0x004fc40003fbd000ULL,
0x0000009f00a07245ULL, 0x000fe4000020d400ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000025009d7306ULL, 0x000e620000005400ULL, 0x0000000163633812ULL, 0x008fcc00078efcffULL,
0x00000001a0a05812ULL, 0x000fe200078efcffULL, 0x000000ad00c07306ULL, 0x000fe60000209400ULL,
0x000000b5a0b5723eULL, 0x000fca00000010ffULL, 0x000000ad00bb7306ULL, 0x000ea20000205400ULL,
0x0000009d9c00720bULL, 0x002fe40003f9d000ULL, 0x000000ad009c7245ULL, 0x000fca000020d400ULL,
0x000000ac00bc7306ULL, 0x000ff00000209400ULL, 0x000000ac00c37306ULL, 0x000e620000205400ULL,
0x000000bbc000720bULL, 0x004fce0003fdd000ULL, 0x00000092009a7306ULL, 0x000fec0000209400ULL,
0x000000019c9c6812ULL, 0x000fe400078efcffULL, 0x00000092009b7306ULL, 0x000ea20000205400ULL,
0x000000c3bc00720bULL, 0x002fce0003f5d000ULL, 0x0000002400c57306ULL, 0x000ff00000209400ULL,
0x0000002400c47306ULL, 0x000e620000205400ULL, 0x0000009b9a00720bULL, 0x004fe40003fbd000ULL,
0x000000ac009b7245ULL, 0x000fc8000020d400ULL, 0x000000019b9b2812ULL, 0x000fe200078efcffULL,
0x0000002500627306ULL, 0x000eb0000000d400ULL, 0x0000002700977306ULL, 0x000fe20000009400ULL,
0x000000c4c500720bULL, 0x002fce0003f7d000ULL, 0x0000002700987306ULL, 0x000e620000005400ULL,
0x0000000162624812ULL, 0x004fc800078efcffULL, 0x000000629b9b723eULL, 0x000fc600000010ffULL,
0x000000b200be7306ULL, 0x000ff00000209400ULL, 0x000000b200c77306ULL, 0x0004e20000205400ULL,
0x000000989700720bULL, 0x002fe40003f9d000ULL, 0x0000009200977245ULL, 0x000fc4000020d400ULL,
0x0000002400927245ULL, 0x000fe4000020d400ULL, 0x0000000197975812ULL, 0x000fe200078efcffULL,
0x0000002600997306ULL, 0x000fe20000009400ULL, 0x0000000192923812ULL, 0x000fe400078efcffULL,
0x000000b200b27245ULL, 0x004fca000020d400ULL, 0x0000002600967306ULL, 0x000e620000005400ULL,
0x000000c7be00720bULL, 0x008fce0003fdd000ULL, 0x00000026005c7306ULL, 0x000eac000000d400ULL,
0x00000001b2b26812ULL, 0x000fe400078efcffULL, 0x0000006f00257306ULL, 0x000fe20000209400ULL,
0x000000969900720bULL, 0x002fe40003f5d000ULL, 0x0000008000997245ULL, 0x000fc4000020d400ULL,
0x000000b297b2723eULL, 0x000fc600000010ffULL, 0x0000006f00ba7306ULL, 0x0002ec0000205400ULL,
0x000000015c5c2812ULL, 0x004fe400078efcffULL, 0x0000006d00bd7306ULL, 0x000fe20000209400ULL,
0x0000006f006f7245ULL, 0x002fce000020d400ULL, 0x0000006d00267306ULL, 0x000e620000205400ULL,
0x000000ba2500720bULL, 0x008fce0003fbd000ULL, 0x0000008000907306ULL, 0x000fec0000209400ULL,
0x000000016f6f5812ULL, 0x000fe400078efcffULL, 0x0000008000937306ULL, 0x000ea20000205400ULL,
0x00000026bd00720bULL, 0x002fce0003f7d000ULL, 0x00000027005b7306ULL, 0x0002f0000000d400ULL,
0x00000028007a7306ULL, 0x000fe20000009400ULL, 0x000001002b277824ULL, 0x002fe200078e00ffULL,
0x000000939000720bULL, 0x004fc40003fdd000ULL, 0x00000046ff90723eULL, 0x000fe400000010ffULL,
0x00000018ff967819ULL, 0x000fe40000011427ULL, 0x00000028007d7306ULL, 0x000fe20000005400ULL,
0x00a800005124783bULL, 0x0003e20000000200ULL, 0x00000002ff937819ULL, 0x000fe4000001163bULL,
0x0000541090ac7816ULL, 0x000fe40000000090ULL, 0x000000015b5b4812ULL, 0x008fc400078efcffULL,
0x0000002800007306ULL, 0x0005e2000000d400ULL, 0x00001f93ac937589ULL, 0x000ee200000e0000ULL,
0x000099106a517816ULL, 0x002fe400000000ffULL, 0x0000000199996812ULL, 0x000fe200078efcffULL,
0x00001f53ac807589ULL, 0x00032200000e0000ULL, 0x000000ff5100720cULL, 0x000fe40003f85270ULL,
0x0000002900837306ULL, 0x000fe20000009400ULL, 0x0001000028287824ULL, 0x004fe200078e00ffULL,
0x0000008400517245ULL, 0x000fc4000020d400ULL, 0x0000008b006a7245ULL, 0x000fe4000020d400ULL,
0x00000018ffb37819ULL, 0x000fe40000011428ULL, 0x0000002900787306ULL, 0x000fe20000005400ULL,
0x000000cc00537245ULL, 0x002fe4000020d400ULL, 0x0000009600db7245ULL, 0x000fca000020d400ULL,
0x0000002900307306ULL, 0x0003f0000000d400ULL, 0x0000002a00887306ULL, 0x000fe20000009400ULL,
0x0001000029297824ULL, 0x002fe200078e00ffULL, 0x000000932424c231ULL, 0x008fc400003400ffULL,
0x000000932626c231ULL, 0x000fe400003400ffULL, 0x00000018ffa67819ULL, 0x000fe20000011429ULL,
0x000000802525c231ULL, 0x090fe200003400ffULL, 0x0000002a007f7306ULL, 0x000fe20000005400ULL,
0x000000802727c231ULL, 0x000fce00003400ffULL, 0x0000002a002f7306ULL, 0x000fe2000000d400ULL,
0x000000b6240c723cULL, 0x040fee000004180cULL, 0x0000002b00867306ULL, 0x000fe20000009400ULL,
0x000000702410723cULL, 0x040fee0000041810ULL, 0x0000002b007b7306ULL, 0x000fe20000005400ULL,
0x000000b42414723cULL, 0x000fee0000041814ULL, 0x0000002b002e7306ULL, 0x0003f0000000d400ULL,
0x0000006e008c7306ULL, 0x000fe20000209400ULL, 0x00a800005228783bULL, 0x0022ae0000000200ULL,
0x0000006e008f7306ULL, 0x0007220000205400ULL, 0x0000006d00527245ULL, 0x002fc4000020d400ULL,
0x000000b3006d7245ULL, 0x000fe4000020d400ULL, 0x0000000152523812ULL, 0x000fc600078efcffULL,
0x00000084007c7306ULL, 0x000fe20000209400ULL, 0x0000006e006e7245ULL, 0x008fe4000020d400ULL,
0x0000005b525b723eULL, 0x000fca00000010ffULL, 0x0000008400797306ULL, 0x000e620000205400ULL,
0x0000008f8c00720bULL, 0x010fce0003fbd000ULL, 0x0000008b00817306ULL, 0x000fec0000209400ULL,
0x000000016e6e5812ULL, 0x000fe400078efcffULL, 0x0000008b00827306ULL, 0x000ee20000205400ULL,
0x000000797c00720bULL, 0x002fe20003fdd000ULL, 0x000000932828c231ULL, 0x084fe200003400ffULL,
0x0000007d7a00720bULL, 0x000fe20003fbd000ULL, 0x000000932a2ac231ULL, 0x000fe200003400ffULL,
0x000000a600797245ULL, 0x000fe2000020d400ULL, 0x000000802929c231ULL, 0x000fc400003400ffULL,
0x000000b300aa7306ULL, 0x000fe20000209400ULL, 0x000000802b2bc231ULL, 0x000fca00003400ffULL,
0x0000000151516812ULL, 0x000fe400078efcffULL, 0x000000b300ab7306ULL, 0x0002a20000205400ULL,
0x000000828100720bULL, 0x008fe40003f5d000ULL, 0x000000788300720bULL, 0x000fe40003fdd000ULL,
0x0000000100005812ULL, 0x000fe400078efcffULL, 0x0000007f8800720bULL, 0x000fe20003fbd000ULL,
0x0000008d008e7306ULL, 0x000fe20000209400ULL, 0x0000008500787245ULL, 0x000fc4000020d400ULL,
0x0000006e516e723eULL, 0x000fe400000010ffULL, 0x0000009299b3723eULL, 0x002fe400000010ffULL,
0x000000016a6a2812ULL, 0x000fe200078efcffULL, 0x0000008d00917306ULL, 0x0002e20000205400ULL,
0x000000abaa00720bULL, 0x004fe40003f9d000ULL, 0x0000000130306812ULL, 0x000fe200078efcffULL,
0x000000b2241c723cULL, 0x000fe2000004181cULL, 0x000000012f2f5812ULL, 0x000fc600078efcffULL,
0x000000cc00c17306ULL, 0x000fe20000209400ULL, 0x0000008d008d7245ULL, 0x002fca000020d400ULL,
0x000000016d6d4812ULL, 0x000fe400078efcffULL, 0x000000cc00c67306ULL, 0x000e620000205400ULL,
0x000000918e00720bULL, 0x008fe40003f7d000ULL, 0x0000007b8600720bULL, 0x000fca0003f9d000ULL,
0x0000007500877306ULL, 0x000fec0000209400ULL, 0x000000018d8d3812ULL, 0x000fe400078efcffULL,
0x00000075007e7306ULL, 0x000ea20000205400ULL, 0x000000c6c100720bULL, 0x002fe40003f5d000ULL,
0x000000012e2e4812ULL, 0x000fca00078efcffULL, 0x0000009500b07306ULL, 0x000fec0000209400ULL,
0x0000000153532812ULL, 0x000fe400078efcffULL, 0x0000009500bf7306ULL, 0x0002e20000205400ULL,
0x0000007e8700720bULL, 0x004fe40003f5d000ULL, 0x000000305353723eULL, 0x000fca00000010ffULL,
0x000000a600a27306ULL, 0x000fe20000209400ULL, 0x0000009500957245ULL, 0x002fca000020d400ULL,
0x0000000176762812ULL, 0x000fe400078efcffULL, 0x000000a600a37306ULL, 0x000e620000205400ULL,
0x000000bfb000720bULL, 0x008fe40003f7d000ULL, 0x00000077d0b0723eULL, 0x000fca00000010ffULL,
0x0000006100697306ULL, 0x000fe40000209400ULL, 0x000000b02408723cULL, 0x000fe80000041808ULL,
0x0000000195953812ULL, 0x000fe400078efcffULL, 0x0000006100687306ULL, 0x0004e20000205400ULL,
0x000000a3a200720bULL, 0x002fe40003fdd000ULL, 0x000000009552723eULL, 0x000fc400000010ffULL,
0x0000003300007245ULL, 0x000fc6000020d400ULL, 0x00000094007c7306ULL, 0x000fe20000209400ULL,
0x0000006100617245ULL, 0x004fca000020d400ULL, 0x0000000179796812ULL, 0x000fe400078efcffULL,
0x00000094007d7306ULL, 0x000e620000205400ULL, 0x000000686900720bULL, 0x008fe20003fbd000ULL,
0x000000522808723cULL, 0x000fe20000041808ULL, 0x000000797679723eULL, 0x000fca00000010ffULL,
0x0000006400747306ULL, 0x000fec0000009400ULL, 0x0000000161615812ULL, 0x000fe400078efcffULL,
0x0000006400737306ULL, 0x000ea20000005400ULL, 0x0000007d7c00720bULL, 0x002fce0003f9d000ULL,
0x0000008500897306ULL, 0x000ff00000209400ULL, 0x00000085008a7306ULL, 0x000e620000205400ULL,
0x000000737400720bULL, 0x004fce0003fdd000ULL, 0x0000009600987306ULL, 0x000ff00000209400ULL,
0x00000096009f7306ULL, 0x000ea20000205400ULL, 0x0000008a8900720bULL, 0x002fce0003f7d000ULL,
0x000000ae007a7306ULL, 0x000fec0000209400ULL, 0x0000000178783812ULL, 0x000fe400078efcffULL,
0x000000ae00817306ULL, 0x000e620000205400ULL, 0x0000009f9800720bULL, 0x004fe40003f5d000ULL,
0x00000094009f7245ULL, 0x000fc4000020d400ULL, 0x0000006d7878723eULL, 0x000fe400000010ffULL,
0x000000019f9f4812ULL, 0x000fe200078efcffULL, 0x00000066005d7306ULL, 0x000fe80000009400ULL,
0x00000078280c723cULL, 0x000fe4000004180cULL, 0x00000001dbdb2812ULL, 0x000fe400078efcffULL,
0x00000066005a7306ULL, 0x000ea20000005400ULL, 0x000000817a00720bULL, 0x002fc40003fbd000ULL,
0x0000002edbdb723eULL, 0x000fe400000010ffULL, 0x0000004b002e7245ULL, 0x000fc6000020d400ULL,
0x000000da009d7306ULL, 0x000ff00000209400ULL, 0x000000da009a7306ULL, 0x0002e20000205400ULL,
0x0000005a5d00720bULL, 0x004fe40003f9d000ULL, 0x000000ae005d7245ULL, 0x000fc4000020d400ULL,
0x0000005c6f5a723eULL, 0x000fe400000010ffULL, 0x000000015d5d5812ULL, 0x000fe200078efcffULL,
0x0000009e00907306ULL, 0x000fe20000209400ULL, 0x000000da00da7245ULL, 0x002fe4000020d400ULL,
0x0000008d6a6f723eULL, 0x000fe200000010ffULL, 0x0000005a2420723cULL, 0x000fe80000041820ULL,
0x0000009e008f7306ULL, 0x0002a20000205400ULL, 0x0000009a9d00720bULL, 0x008fc40003f7d000ULL,
0x000000639c9a723eULL, 0x000fe200000010ffULL, 0x0000006e2404723cULL, 0x000fe80000041804ULL,
0x00000064002c7306ULL, 0x000722000000d400ULL, 0x0000009e009e7245ULL, 0x002fc6000020d400ULL,
0x0000009a2418723cULL, 0x000fe40000041818ULL, 0x00000001dada3812ULL, 0x000fe400078efcffULL,
0x000000b9007f7306ULL, 0x000fe20000209400ULL, 0x0000008f9000720bULL, 0x004fe20003f5d000ULL,
0x0000010067647824ULL, 0x008fe200078e00ffULL, 0x0000002fdada723eULL, 0x000fe400000010ffULL,
0x0000006c00277245ULL, 0x000fe4000020d400ULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x000000b9007e7306ULL, 0x0002a20000205400ULL, 0x000000012c2c6812ULL, 0x010fe200078efcffULL,
0x000000da2810723cULL, 0x000fe60000041810ULL, 0x0000002c5d24723eULL, 0x000fc400000010ffULL,
0x000000019e9e2812ULL, 0x000fe200078efcffULL, 0x000000af00757306ULL, 0x000fe20000209400ULL,
0x000000b900b97245ULL, 0x002fe4000020d400ULL, 0x0000009e619e723eULL, 0x000fca00000010ffULL,
0x000000af00747306ULL, 0x0002e20000205400ULL, 0x0000007e7f00720bULL, 0x004fce0003fbd000ULL,
0x0000006500727306ULL, 0x000fe20000009400ULL, 0x000000af00af7245ULL, 0x002fca000020d400ULL,
0x00000001b9b95812ULL, 0x000fe400078efcffULL, 0x00000065006b7306ULL, 0x000e620000005400ULL,
0x000000747500720bULL, 0x008fce0003fdd000ULL, 0x0000005e005f7306ULL, 0x000fec0000209400ULL,
0x00000001afaf6812ULL, 0x000fe400078efcffULL, 0x0000005e00607306ULL, 0x0004e20000205400ULL,
0x0000006b7200720bULL, 0x002fce0003f7d000ULL, 0x0000003300497306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x004fce000020d400ULL, 0x00000033004a7306ULL, 0x000e620000205400ULL,
0x000000605f00720bULL, 0x008fce0003f5d000ULL, 0x0000004b004c7306ULL, 0x000fec0000209400ULL,
0x000000015e5e2812ULL, 0x000fe400078efcffULL, 0x0000004b004d7306ULL, 0x000ea20000205400ULL,
0x0000004a4900720bULL, 0x002fe40003fbd000ULL, 0x0000009f5e9f723eULL, 0x000fca00000010ffULL,
0x0000006500327306ULL, 0x0002e4000000d400ULL, 0x0000009e2814723cULL, 0x000fe80000041814ULL,
0x0000000100005812ULL, 0x000fe400078efcffULL, 0x0000006c006b7306ULL, 0x000fe20000209400ULL,
0x0000010066657824ULL, 0x002fe200078e00ffULL, 0x0000004d4c00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x0000006c00687306ULL, 0x000e620000205400ULL,
0x0000000132323812ULL, 0x008fe400078efcffULL, 0x0000006500307245ULL, 0x000fe4000020d400ULL,
0x00000032b925723eULL, 0x000fe400000010ffULL, 0x000000012e2e6812ULL, 0x000fe200078efcffULL,
0x0000006500627306ULL, 0x000fe80000209400ULL, 0x000000242818723cULL, 0x000fe80000041818ULL,
0x00000065005f7306ULL, 0x000ea20000205400ULL, 0x000000686b00720bULL, 0x002fce0003f7d000ULL,
0x00000064005c7306ULL, 0x000fec0000209400ULL, 0x0000000127273812ULL, 0x000fe400078efcffULL,
0x0000006400517306ULL, 0x0002e20000205400ULL, 0x0000005f6200720bULL, 0x004fe40003fbd000ULL,
0x000000272e27723eULL, 0x000fca00000010ffULL, 0x0000006600037306ULL, 0x000522000000d400ULL,
0x0000006400647245ULL, 0x002fca000020d400ULL, 0x0000000130305812ULL, 0x000fe400078efcffULL,
0x0000006700587306ULL, 0x000fe20000009400ULL, 0x0001000066667824ULL, 0x004fe200078e00ffULL,
0x000000515c00720bULL, 0x008fc80003fdd000ULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x0000006700597306ULL, 0x000e620000005400ULL, 0x0000000103034812ULL, 0x010fc800078efcffULL,
0x000000033030723eULL, 0x000fe400000010ffULL, 0x0000000164646812ULL, 0x000fe200078efcffULL,
0x0000006700317306ULL, 0x0004e2000000d400ULL, 0x0000004e00037245ULL, 0x000fce000020d400ULL,
0x0000004e004f7306ULL, 0x000fe20000209400ULL, 0x0001000067677824ULL, 0x004fe200078e00ffULL,
0x000000595800720bULL, 0x002fc80003f5d000ULL, 0x00000018ff677819ULL, 0x000fe40000011467ULL,
0x0000004e00507306ULL, 0x000e6e0000205400ULL, 0x0000000131312812ULL, 0x008fe200078efcffULL,
0x0000005400567306ULL, 0x000fe60000209400ULL, 0x000000316431723eULL, 0x000fca00000010ffULL,
0x0000005400577306ULL, 0x0004e20000205400ULL, 0x000000504f00720bULL, 0x002fe20003f7d000ULL,
0x000000302820723cULL, 0x000fec0000041820ULL, 0x0000006600267306ULL, 0x000fe20000209400ULL,
0x0000005400547245ULL, 0x004fca000020d400ULL, 0x0000000103033812ULL, 0x000fe400078efcffULL,
0x0000006600497306ULL, 0x0002a20000205400ULL, 0x000000575600720bULL, 0x008fce0003fbd000ULL,
0x00000067002f7306ULL, 0x000fe20000209400ULL, 0x0000006600667245ULL, 0x002fca000020d400ULL,
0x0000000154545812ULL, 0x000fe400078efcffULL, 0x00000067004a7306ULL, 0x0002e20000205400ULL,
0x000000492600720bULL, 0x004fe40003f9d000ULL, 0x000000af0026723eULL, 0x000fe400000010ffULL,
0x0000006700677245ULL, 0x002fca000020d400ULL, 0x00000026281c723cULL, 0x000fe8000004181cULL,
0x0000000166664812ULL, 0x000fe400078efcffULL, 0x0000004a2f00720bULL, 0x008fe40003fdd000ULL,
0x000000660366723eULL, 0x000fd600000010ffULL, 0x0000000167676812ULL, 0x000fc800078efcffULL,
0x000000675467723eULL, 0x000fce00000010ffULL, 0x000000662804723cULL, 0x000fe20000041804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200042ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6400047ff7f8cULL, 0x0005e2000c80043fULL, 0x0000991002007816ULL, 0x000fe400000000ffULL,
0x00000001ff717807ULL, 0x000fe40004000000ULL, 0x000000ff0000720cULL, 0x000fe40003f45270ULL,
0x0000000145727812ULL, 0x000fe400078ec0ffULL, 0x00000001ff2d9807ULL, 0x000fc80001000000ULL,
0x000076102d707816ULL, 0x000fe40000000070ULL, 0x0000030036367a10ULL, 0x004fe40007ffe0ffULL,
0x000000ff44ff7812ULL, 0x000fe4000780c0ffULL, 0x000000393600720cULL, 0x000fe40003f26070ULL,
0x00000001ff447807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff4dd000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x002e620000002500ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0023ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0020ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0022ULL, 0x000000ffff297224ULL, 0x000fe400078e001eULL,
0x000000ffff277224ULL, 0x000fe400078e001cULL, 0x000000ffff257224ULL, 0x000fc400078e001aULL,
0x000000ffff237224ULL, 0x000fe400078e0018ULL, 0x000000ffff207224ULL, 0x000fe400078e0017ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0021ULL, 0x000000ffff287224ULL, 0x000fe400078e001fULL,
0x000000ffff267224ULL, 0x000fe400078e001dULL, 0x000000ffff247224ULL, 0x000fe200078e001bULL,
0x0000000439007c0cULL, 0x002fe2000bf03070ULL, 0x000000ffff227224ULL, 0x000fc400078e0019ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0015ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0013ULL,
0x000000ffff187224ULL, 0x000fe400078e0011ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000fULL,
0x000000ffff177224ULL, 0x000fe400078e000dULL, 0x000000ffff307224ULL, 0x000fc400078e0007ULL,
0x000000ffff317224ULL, 0x000fe400078e0006ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0005ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0004ULL, 0x000000ffff217224ULL, 0x000fe400078e0016ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0014ULL, 0x000000ffff1d7224ULL, 0x000fc400078e0012ULL,
0x000000ffff197224ULL, 0x000fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e000eULL,
0x000000ffff157224ULL, 0x000fe400078e000cULL, 0x000000ffff137224ULL, 0x000fe400078e000bULL,
0x000000ffff117224ULL, 0x000fe400078e000aULL, 0x000000ffff0f7224ULL, 0x000fc400078e0009ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0008ULL, 0x0000037000000947ULL, 0x000fea0003800000ULL,
0x0180000041007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000c33000067802ULL, 0x000fe40000000f00ULL,
0x00009d2000007944ULL, 0x020fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000004100007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc80000000041ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x000f28000c1e9900ULL,
0x0000000000047919ULL, 0x000e680000000000ULL, 0x0000000000077919ULL, 0x000ee20000000000ULL,
0x00000002ff067819ULL, 0x002fe40000011604ULL, 0x0000000807047811ULL, 0x008fe200078ff0ffULL,
0x0000000003057220ULL, 0x014fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000000d000d7220ULL, 0x042fe20000410000ULL,
0x0000000f000f7220ULL, 0x040fe20000410000ULL, 0x0000001500157220ULL, 0x040fe20000410000ULL,
0x0000001700177220ULL, 0x040fe20000410000ULL, 0x0000001900197220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001f001f7220ULL, 0x040fe20000410000ULL,
0x0000001e001e7220ULL, 0x040fe20000410000ULL, 0x0000002300237220ULL, 0x040fe20000410000ULL,
0x0000002200227220ULL, 0x040fe20000410000ULL, 0x0000002700277220ULL, 0x040fe20000410000ULL,
0x0000002600267220ULL, 0x040fe20000410000ULL, 0x0000002b002b7220ULL, 0x040fe20000410000ULL,
0x0000002a002a7220ULL, 0x040fe20000410000ULL, 0x0000002f002f7220ULL, 0x040fe20000410000ULL,
0x0000002e002e7220ULL, 0x000fe20000410000ULL, 0x0000001104117220ULL, 0x044fe20000410000ULL,
0x0000001304137220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x000fe20000410000ULL, 0x0000000000007919ULL, 0x000e680000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000200027812ULL, 0x002fc400078ec0ffULL,
0x00000002ff0e7819ULL, 0x000fe40000011600ULL, 0x00000001ff037819ULL, 0x000fe40000011602ULL,
0x0000000402077811ULL, 0x000fe400078ff8ffULL, 0x0000000800167811ULL, 0x000fe400078ff0ffULL,
0x0000000202047811ULL, 0x040fe400078ff8ffULL, 0x00000006020a7811ULL, 0x000fc400078ff8ffULL,
0x0000000703027812ULL, 0x100fe400078e780eULL, 0x0000000707097812ULL, 0x040fe400078e780eULL,
0x0000000707077812ULL, 0x000fe200078e7816ULL, 0x000000080e067824ULL, 0x000fe200078e0202ULL,
0x0000000703037812ULL, 0x000fe200078e7816ULL, 0x000010003c027824ULL, 0x000fe200078e00ffULL,
0x0000000704057812ULL, 0x100fe200078e780eULL, 0x0000000816147824ULL, 0x000fe200078e0207ULL,
0x000000070a0b7812ULL, 0x000fe200078e780eULL, 0x0000000800077824ULL, 0x000fe200078e00ffULL,
0x0000000704047812ULL, 0x100fe200078e7816ULL, 0x0000000816107824ULL, 0x000fe200078e0203ULL,
0x000000070a0a7812ULL, 0x000fe200078e7816ULL, 0x0000080055037824ULL, 0x000fe200078e0202ULL,
0x0000000807077812ULL, 0x000fe200078ec0ffULL, 0x000000080e087824ULL, 0x040fe200078e0205ULL,
0x000000151705723eULL, 0x000fe200000010ffULL, 0x000000080e0c7824ULL, 0x000fc400078e0209ULL,
0x0000000816127824ULL, 0x000fe200078e0204ULL, 0x0000000d0f04723eULL, 0x000fe200000010ffULL,
0x000000080e0e7824ULL, 0x000fe400078e020bULL, 0x0000000816167824ULL, 0x000fe400078e020aULL,
0x0000001006067824ULL, 0x100fe400078e0203ULL, 0x00000010080a7824ULL, 0x100fe400078e0203ULL,
0x000000100c0c7824ULL, 0x000fc400078e0203ULL, 0x0000001010107824ULL, 0x100fe400078e0203ULL,
0x0000001012127824ULL, 0x100fe400078e0203ULL, 0x000000100e0e7824ULL, 0x100fe400078e0203ULL,
0x0000001014147824ULL, 0x100fe400078e0203ULL, 0x0000001016167824ULL, 0x000fe400078e0203ULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000191806723eULL, 0x000fe200000010ffULL,
0x00000001070a7824ULL, 0x040fe200078e020aULL, 0x0000541004187816ULL, 0x140fe20000000005ULL,
0x00000001070c7824ULL, 0x040fe200078e020cULL, 0x0000763204197816ULL, 0x000fe20000000005ULL,
0x0000000107107824ULL, 0x040fe200078e0210ULL, 0x000000232204723eULL, 0x000fe200000010ffULL,
0x0000000107127824ULL, 0x040fe200078e0212ULL, 0x000000272605723eULL, 0x000fe200000010ffULL,
0x00000001070e7824ULL, 0x040fe200078e020eULL, 0x0000001808007388ULL, 0x0003e20000000a00ULL,
0x0000000107147824ULL, 0x000fc400078e0214ULL, 0x0000000107167824ULL, 0x000fe200078e0216ULL,
0x0000001f1e07723eULL, 0x000fe200000010ffULL, 0x00000020550f7824ULL, 0x000fc600078e0200ULL,
0x0000763206097816ULL, 0x140fe40000000007ULL, 0x0000541006087816ULL, 0x002fe40000000007ULL,
0x0000002b2a06723eULL, 0x000fe400000010ffULL, 0x0000002f2e07723eULL, 0x000fe200000010ffULL,
0x000000080a007388ULL, 0x0003e40000000a00ULL, 0x0000541004087816ULL, 0x142fe20000000005ULL,
0x000000100f0a7824ULL, 0x000fe200078e0202ULL, 0x0000763204097816ULL, 0x000fc40000000005ULL,
0x000000111304723eULL, 0x000fe400000010ffULL, 0x0000001b1a05723eULL, 0x000fe200000010ffULL,
0x000000080c007388ULL, 0x0003e40000000a00ULL, 0x0000541006087816ULL, 0x142fe40000000007ULL,
0x0000763206097816ULL, 0x000fe40000000007ULL, 0x0000001d1c06723eULL, 0x000fe400000010ffULL,
0x000000212007723eULL, 0x000fe200000010ffULL, 0x000000080e007388ULL, 0x0003e40000000a00ULL,
0x0000541004087816ULL, 0x002fc40000000005ULL, 0x0000763204097816ULL, 0x000fe40000000005ULL,
0x000000252404723eULL, 0x000fe400000010ffULL, 0x000000292805723eULL, 0x000fe200000010ffULL,
0x0000000810007388ULL, 0x0003e40000000a00ULL, 0x0000541006087816ULL, 0x142fe40000000007ULL,
0x0000763206097816ULL, 0x000fe40000000007ULL, 0x0000002d2c06723eULL, 0x000fc400000010ffULL,
0x000000313007723eULL, 0x000fe200000010ffULL, 0x0000000812007388ULL, 0x0003e40000000a00ULL,
0x0000541004087816ULL, 0x142fe40000000005ULL, 0x0000763204097816ULL, 0x000fe40000000005ULL,
0x000000ff00047306ULL, 0x000fe60000205400ULL, 0x0000000814007388ULL, 0x0003ea0000000a00ULL,
0x000000ff00057306ULL, 0x000ea20000209400ULL, 0x0000541006087816ULL, 0x002fc40000000007ULL,
0x0000763206097816ULL, 0x000fca0000000007ULL, 0x0000000816007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000040500720bULL, 0x004fe40003f1d000ULL,
0x000000ff00047245ULL, 0x000fd6000020d400ULL, 0x0000000104040812ULL, 0x000fc800078efcffULL,
0x00000004040e723eULL, 0x000fe200000010ffULL, 0x000400000a1c7984ULL, 0x000e680000000c00ULL,
0x000c00000a207984ULL, 0x000ea80000000c00ULL, 0x000000000a107984ULL, 0x000ee80000000c00ULL,
0x000800000a187984ULL, 0x000f220000000c00ULL, 0x3f803f800e1c7831ULL, 0x002fc4000020001cULL,
0x3f803f800e1f7831ULL, 0x000fe4000020001fULL, 0x3f803f801c1c7831ULL, 0x004fe20000200020ULL,
0x00000300ff207624ULL, 0x000fe200078e00ffULL, 0x3f803f800e1e7831ULL, 0x040fe4000020001eULL,
0x3f803f800e137831ULL, 0x048fe40000200013ULL, 0x000000012000780cULL, 0x000fe20003f05270ULL,
0x3f803f800e127831ULL, 0x040fe40000200012ULL, 0x3f803f800e117831ULL, 0x000fc40000200011ULL,
0x3f803f800e107831ULL, 0x040fe40000200010ULL, 0x3f803f800e1d7831ULL, 0x000fe4000020001dULL,
0x3f803f8013137831ULL, 0x010fe4000020001bULL, 0x3f803f8012127831ULL, 0x000fe4000020001aULL,
0x3f803f8011117831ULL, 0x000fe40000200019ULL, 0x3f803f8010107831ULL, 0x000fc40000200018ULL,
0x3f803f801f1f7831ULL, 0x000fe40000200023ULL, 0x3f803f801e1e7831ULL, 0x000fe20000200022ULL,
0x000000100a007388ULL, 0x0003e20000000c00ULL, 0x3f803f801d1d7831ULL, 0x000fca0000200021ULL,
0x0004001c0a007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000306000008947ULL, 0x000fea0003800000ULL, 0x0000000000127919ULL, 0x002e620000002700ULL,
0x0000580020057a24ULL, 0x000fe200078e02ffULL, 0x0000000155ff7812ULL, 0x000fe2000780f834ULL,
0x00001000ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000077919ULL, 0x000e620000002600ULL,
0x00006600050b7a24ULL, 0x000fe200078e02ffULL, 0x000000400f117810ULL, 0x000fc40007ffe0ffULL,
0x000000000a147984ULL, 0x0004e40000000c00ULL, 0x00000fff0b057811ULL, 0x000fe400078e40ffULL,
0x000400000a187984ULL, 0x0005220000000c00ULL, 0x0000580012127a24ULL, 0x002fe400078e0207ULL,
0x000008003c077824ULL, 0x000fe400078e00ffULL, 0x0000030012067a24ULL, 0x000fca00078e02ffULL,
0x00000004060c7c10ULL, 0x000fc8000fffe0ffULL, 0x0000000c05087211ULL, 0x000fca00078fa0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0009ULL, 0x0000000708087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000ff0000720cULL, 0x000fc60000725670ULL,
0x000000100f0e7825ULL, 0x000fc800078e0008ULL, 0x0000001011107825ULL, 0x000fe200078e0008ULL,
0x01ffffff0b087812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010000a7824ULL, 0x01cfe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x000000010c0d7824ULL, 0x000fe200078e0208ULL,
0x000000700a137812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b1c7812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0a7625ULL, 0x000fc800078e0009ULL, 0x00006c000d0c7625ULL, 0x000fe200078e0009ULL,
0x0000000a1c0a7210ULL, 0x000fc80007a1e013ULL, 0x0000000c1c0c7210ULL, 0x000fe40007c7e013ULL,
0x0000000bff0b7210ULL, 0x000fe400007e44ffULL, 0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL,
0x000000400a007986ULL, 0x0003e8000c101908ULL, 0x000000410c007986ULL, 0x0003e4000c101908ULL,
0x000000140e007986ULL, 0x01c5e2000c101d08ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x0000001810007986ULL, 0x0005e8000c101d08ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0b7424ULL, 0x002fe200078e00ffULL,
0xffffffff20097810ULL, 0x000fc60007ffe0ffULL, 0x00006a00120a7625ULL, 0x000fe200078e000bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x000000090a0a79a8ULL, 0x000ee400099ee1c8ULL, 0x000000090a00720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0c7807ULL, 0x000fca0000000000ULL,
0x0000000cff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff097984ULL, 0x000ee40000000000ULL,
0x000000ff0900720cULL, 0x008fda0003f05270ULL, 0x00002c9000008947ULL, 0x000fea0003800000ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff0a7819ULL, 0x002fe20000011600ULL, 0x0000001000097824ULL, 0x000fe200078e00ffULL,
0x00000001060c7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0f7424ULL, 0x004fe200078e00ffULL,
0x0000000c0a137812ULL, 0x000fe400078ec0ffULL, 0x0000007009117812ULL, 0x000fe200078ec0ffULL,
0x00006c00060a7625ULL, 0x000fc800078e000fULL, 0x00006c000c0c7625ULL, 0x000fe200078e000fULL,
0x0000000a130a7210ULL, 0x000fc8000791e011ULL, 0x0000000c130c7210ULL, 0x000fe40007b5e011ULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x000000080a097981ULL, 0x000368000c1e1900ULL, 0x000000080c0e7981ULL, 0x000362000c1e1900ULL,
0x000000022000780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002060a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a130a7210ULL, 0x000fc8000791e011ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000080a107981ULL, 0x000362000c1e1900ULL, 0x000000042000780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003060a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a130a7210ULL, 0x000fc8000791e011ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000080a127981ULL, 0x000362000c1e1900ULL,
0x000000042000780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004060a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a130a7210ULL, 0x000fc8000791e011ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000080a147981ULL, 0x000362000c1e1900ULL, 0x000000062000780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005060a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a130a7210ULL, 0x000fc8000791e011ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000080a167981ULL, 0x000362000c1e1900ULL,
0x000000062000780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000082000780cULL, 0x002fe40003f06070ULL, 0x00000006060a7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a130a7210ULL, 0x000fe40007a3e011ULL,
0x00000007060c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006c000c0c0625ULL, 0x000fe400078e000fULL, 0x000000080a187981ULL, 0x000366000c1e1900ULL,
0x0000000c130c0210ULL, 0x000fc80007c7e011ULL, 0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL,
0x000000080c0c0981ULL, 0x000368000c1e1900ULL, 0x00000007200a7810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0d7819ULL, 0x000fc8000001160aULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff1a7224ULL, 0x004fe400078e00ffULL,
0x000000ffff1c7224ULL, 0x020fe400078e0009ULL, 0x000000081a0f7824ULL, 0x040fe200078e00ffULL,
0x000000011a1a7810ULL, 0x000fc80007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x0000000d1a00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080f0b7810ULL, 0x040fe40007ffe0ffULL, 0x000000010f0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001c09097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff137819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000080a1c7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090f0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000020f0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000000e09097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff137819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010000e7824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700e117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000080a0e7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0f0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000030f0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001009097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff137819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007010117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000080a107981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0f0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000040f0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001209097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000080a127981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0f0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000050f0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001409097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff137819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000080a147981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0f0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000060f0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001609097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff137819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000080a167981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0f0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000070f0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001809097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff137819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000080a187981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0f0f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c09097209ULL, 0x000fe40007810000ULL, 0x000003000f007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x002fe200078e020fULL,
0x00000001ff117819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700c0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007a3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000080a0c7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ee40000000000ULL, 0x00000010000a7824ULL, 0x00afe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011600ULL, 0x000000700a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL, 0x000000010b0a7824ULL, 0x000fca00078e020aULL,
0x000000090a007388ULL, 0x0203e40000000800ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000000155147824ULL, 0x004fe200078e0206ULL, 0x00000001ff0b7819ULL, 0x002fe20000011600ULL,
0x0000001000097824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00001000ff0f7424ULL, 0x000fe200078e00ffULL, 0x00000014050a7211ULL, 0x000fe200078fa0ffULL,
0x000000013d3d7824ULL, 0x000fe200078e0202ULL, 0x00000002ff0c7819ULL, 0x000fe20000011634ULL,
0x0000020034347824ULL, 0x000fe200078e00ffULL, 0x00000070090d7812ULL, 0x000fe200078ec0ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000c0b0e7812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000fULL, 0x000000010c097812ULL, 0x000fe200078ec0ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000040000f7810ULL, 0x000fe20007ffe0ffULL,
0x00000002550c8824ULL, 0x140fe200078e023cULL, 0x000000070a0a7210ULL, 0x000fe20007f3e0ffULL,
0x000000010e297824ULL, 0x000fe200078e020dULL, 0x00000020000d7810ULL, 0x000fe20007ffe0ffULL,
0x000000020c198824ULL, 0x100fe200078e0209ULL, 0x00000800340c7812ULL, 0x000fe200078ec0ffULL,
0x00000002550e8824ULL, 0x040fe200078e023cULL, 0x0000006000117810ULL, 0x000fe20007ffe0ffULL,
0x0000000108128824ULL, 0x000fe200078e0214ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000080ff138424ULL, 0x000fe200078e00ffULL, 0x0000000029297984ULL, 0x000e620000000800ULL,
0x000000020e1b8824ULL, 0x000fe200078e0209ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000030055007a0cULL, 0x000fe20003f26070ULL,
0x00000080ff158424ULL, 0x000fc400078e00ffULL, 0x000000013d097824ULL, 0x000fe400078e020cULL,
0x00006c0012128625ULL, 0x000fc800078e0013ULL, 0x000000100d0c7825ULL, 0x000fc800078e000aULL,
0x000000100f0e7825ULL, 0x000fc800078e000aULL, 0x0000001011107825ULL, 0x000fc800078e000aULL,
0x00006c0014148625ULL, 0x000fc800078e0015ULL, 0x0000000819198824ULL, 0x000fe400078e0200ULL,
0x0000001000177824ULL, 0x040fe400078e0209ULL, 0x00000010000a7825ULL, 0x040fe200078e000aULL,
0x00004580191d8811ULL, 0x000fe400078e20ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000081b1b8824ULL, 0x000fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a177faeULL, 0x0005e2000b901c48ULL, 0x0000001000128825ULL, 0x000fc600078e0012ULL,
0x000041801b1f8811ULL, 0x000fe200078e20ffULL, 0x0000001000148825ULL, 0x000fe200078e0014ULL,
0x003800000c177faeULL, 0x0007e2000b901c48ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x005800000e177faeULL, 0x0009e2000b901c48ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x004fe2000001ff00ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x0078000010177faeULL, 0x0005e8000b901c48ULL,
0x00000000121d8faeULL, 0x0003e2000b901c48ULL, 0x00000000000c7805ULL, 0x008fc6000001ff00ULL,
0x00000000141f8faeULL, 0x0007e2000b901c48ULL, 0x00000000000e7805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000107805ULL, 0x004fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x002fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x008fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000e0000001947ULL, 0x000fea0003800000ULL,
0x00000df000007945ULL, 0x000fe20003800000ULL, 0x000000ffff097224ULL, 0x000fe400078e00ffULL,
0x000000ffff2c7224ULL, 0x000fca00078e0055ULL, 0x000000022c377810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff437224ULL, 0x000fe200078e002cULL, 0x00000002ff587819ULL, 0x002fe20000011600ULL,
0x00000002552c7824ULL, 0x000fe200078e023cULL, 0x0000030037007a0cULL, 0x000fe20003f06070ULL,
0x00000040432b7824ULL, 0x000fe200078e00ffULL, 0x00000007582d7812ULL, 0x040fe200078ec0ffULL,
0x0000000858387824ULL, 0x040fe200078e00ffULL, 0x00000058ff487212ULL, 0x000fe200078e33ffULL,
0x00000008582a7824ULL, 0x040fe200078e00ffULL, 0x000000802b2b7812ULL, 0x000fe200078ec0ffULL,
0x00000008582f7824ULL, 0x008fe200078e00ffULL, 0x0000039000017945ULL, 0x000fe20003800000ULL,
0xfffffff838387812ULL, 0x100fe200078ee22dULL, 0x0000001000477824ULL, 0x000fe200078e00ffULL,
0x000000012a3a7812ULL, 0x020fe200078ef62dULL, 0x000001002c417824ULL, 0x000fe200078e002bULL,
0x000000022a3e7812ULL, 0x000fc400078ef62dULL, 0x000000032a407812ULL, 0x140fe400078ef62dULL,
0x000000042a427812ULL, 0x140fe400078ef62dULL, 0x000000052a447812ULL, 0x140fe400078ef62dULL,
0x000000062a467812ULL, 0x000fe400078ef62dULL, 0xfffffff82f487812ULL, 0x000fe400078ee248ULL,
0x00000008585a7810ULL, 0x000fe20007ffe0ffULL, 0x000002c000000947ULL, 0x000fea0003800000ULL,
0x0000000106347824ULL, 0x100fe200078e0237ULL, 0x000000070000780cULL, 0x000fe20003f24070ULL,
0x00001000ff2b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff2c7819ULL, 0x000fc40000011637ULL,
0x00000034052a7211ULL, 0x000fe400078fa0ffULL, 0x000000012c2d7812ULL, 0x000fe200078ec0ffULL,
0x00000400372c7824ULL, 0x000fe200078e00ffULL, 0x00000020002f7810ULL, 0x000fe20007ffe0ffULL,
0x00006c002a2a7625ULL, 0x000fe200078e002bULL, 0x0000004000317810ULL, 0x000fe40007ffe0ffULL,
0x000008002c2c7812ULL, 0x000fe200078ec0ffULL, 0x00000002552e9824ULL, 0x140fe200078e023cULL,
0x000000072a2a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000255309824ULL, 0x000fe200078e023cULL,
0x00000060003f7810ULL, 0x000fe20007ffe0ffULL, 0x000000022e3b9824ULL, 0x000fc400078e022dULL,
0x0000000230459824ULL, 0x000fe400078e022dULL, 0x000000013d2d7824ULL, 0x000fe400078e022cULL,
0x000000ffff2b7224ULL, 0x000fe400000e062bULL, 0x0000000108329824ULL, 0x000fe400078e0234ULL,
0x00000080ff339424ULL, 0x000fe400078e00ffULL, 0x00000080ff359424ULL, 0x000fc400078e00ffULL,
0x0000001000397824ULL, 0x000fe400078e022dULL, 0x00006c0032329625ULL, 0x000fc800078e0033ULL,
0x00000010002c7825ULL, 0x000fc800078e002aULL, 0x000000102f2e7825ULL, 0x100fe200078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800002c397faeULL, 0x0003e6000b901c48ULL,
0x0000001031307825ULL, 0x100fe200078e002aULL, 0x003800002e397faeULL, 0x0003e6000b901c48ULL,
0x00006c0034349625ULL, 0x000fe200078e0035ULL, 0x0058000030397faeULL, 0x0003e6000b901c48ULL,
0x000000103f2a7825ULL, 0x000fc800078e002aULL, 0x000000083b3b9824ULL, 0x100fe200078e0200ULL,
0x007800002a397faeULL, 0x0003e2000b901c48ULL, 0x00000008453f9824ULL, 0x000fe400078e0200ULL,
0x0000001000329825ULL, 0x040fe200078e0032ULL, 0x000045803b3b9811ULL, 0x000fe400078e20ffULL,
0x000041803f3f9811ULL, 0x000fe200078e20ffULL, 0x0000001000349825ULL, 0x000fe400078e0034ULL,
0x00000000323b9faeULL, 0x0003e8000b901c48ULL, 0x00000000343f9faeULL, 0x0003e4000b901c48ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000001ff2d7819ULL, 0x002fe20000011600ULL, 0x00000400432a7824ULL, 0x000fe200078e00ffULL,
0x0000007047507812ULL, 0x000fe200078ec0ffULL, 0x000000085a2c7824ULL, 0x040fe200078e00ffULL,
0x0000000c2d2d7812ULL, 0x000fe200078ec0ffULL, 0x000000085a2e7824ULL, 0x040fe200078e00ffULL,
0x000000075a2b7812ULL, 0x040fe200078ec0ffULL, 0x000000085a527824ULL, 0x000fe200078e00ffULL,
0x000000412d417210ULL, 0x000fc40007ffe050ULL, 0x000008002a2a7812ULL, 0x000fe400078ec0ffULL,
0x0000005aff2d7212ULL, 0x000fe400078e33ffULL, 0x000000012c307812ULL, 0x140fe400078ef62bULL,
0x000000022c327812ULL, 0x140fe400078ef62bULL, 0x000000032c347812ULL, 0x140fe400078ef62bULL,
0x000000042c4a7812ULL, 0x000fc400078ef62bULL, 0x000000052c4c7812ULL, 0x000fe200078ef62bULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800041507984ULL, 0x000e620000000800ULL,
0x000000062c4e7812ULL, 0x100fe200078ef62bULL, 0x00000004002c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee22bULL, 0x0045800041417984ULL, 0x000ea20000000800ULL,
0x000001803d2b7810ULL, 0x000fe40007ffe02aULL, 0xfffffff8522a7812ULL, 0x000fe400078ee22dULL,
0x0000000c2c2d7812ULL, 0x000fe200078ec0ffULL, 0x0000001038387824ULL, 0x000fc400078e022bULL,
0x000000103a3a7824ULL, 0x100fe400078e022bULL, 0x000000103e3e7824ULL, 0x100fe400078e022bULL,
0x0000001040407824ULL, 0x100fe400078e022bULL, 0x0000001042427824ULL, 0x100fe400078e022bULL,
0x0000001044447824ULL, 0x100fe400078e022bULL, 0x0000001046467824ULL, 0x000fc400078e022bULL,
0x0000001034347824ULL, 0x100fe400078e022bULL, 0x000000104a4a7824ULL, 0x100fe400078e022bULL,
0x000000104c4c7824ULL, 0x100fe400078e022bULL, 0x000000104e4e7824ULL, 0x100fe400078e022bULL,
0x0000001048487824ULL, 0x100fe400078e022bULL, 0x000000102e2e7824ULL, 0x000fc400078e022bULL,
0x0000001030307824ULL, 0x100fe400078e022bULL, 0x0000001032327824ULL, 0x100fe400078e022bULL,
0x000000102a2a7824ULL, 0x000fe200078e022bULL, 0x0000005029507221ULL, 0x002fe20000010100ULL,
0x0000000138387824ULL, 0x000fe400078e022dULL, 0x000000012d3a7824ULL, 0x040fe200078e023aULL,
0x3fb8aa3b50507820ULL, 0x000fe20000410000ULL, 0x000000012d3e7824ULL, 0x000fc400078e023eULL,
0x000000012d407824ULL, 0x040fe200078e0240ULL, 0x0000000038387984ULL, 0x000e620000000800ULL,
0x000000012d427824ULL, 0x040fe200078e0242ULL, 0x0000005000507308ULL, 0x000ea20000000800ULL,
0x000000012d447824ULL, 0x040fe200078e0244ULL, 0x000000003a3a7984ULL, 0x000ee20000000800ULL,
0x000000012d467824ULL, 0x040fe400078e0246ULL, 0x000000012d487824ULL, 0x040fe200078e0248ULL,
0x000000003e3e7984ULL, 0x000f220000000800ULL, 0x000000012d347824ULL, 0x000fc400078e0234ULL,
0x000000012d4a7824ULL, 0x040fe200078e024aULL, 0x0000000040407984ULL, 0x000f620000000800ULL,
0x000000012d4c7824ULL, 0x040fe400078e024cULL, 0x000000012d4e7824ULL, 0x040fe200078e024eULL,
0x0000000042427984ULL, 0x000f620000000800ULL, 0x000000012d2e7824ULL, 0x040fe200078e022eULL,
0x00000041502f7220ULL, 0x004fe20000410000ULL, 0x000000012d307824ULL, 0x040fe200078e0230ULL,
0x0000000044447984ULL, 0x000ea20000000800ULL, 0x000000012d327824ULL, 0x000fe200078e0232ULL,
0x000000362f367221ULL, 0x000fe20000010000ULL, 0x000000012d2a7824ULL, 0x000fe200078e022aULL,
0x0000000046467984ULL, 0x000ea20000000800ULL, 0x000000ffff2c7224ULL, 0x000fc600078e0037ULL,
0x0000000048487984ULL, 0x000ea40000000800ULL, 0x000003002c007a0cULL, 0x000fe40003f06070ULL,
0x0000000034347984ULL, 0x000ea80000000800ULL, 0x000000004a4a7984ULL, 0x000ea80000000800ULL,
0x000000004c4c7984ULL, 0x000ea20000000800ULL, 0x00005410ff337816ULL, 0x002fc40000000038ULL,
0x00007610ff387816ULL, 0x000fe20000000038ULL, 0x000000004e4e7984ULL, 0x000e620000000800ULL,
0x00005410ff357816ULL, 0x108fe4000000003aULL, 0x00007610ff3a7816ULL, 0x000fe2000000003aULL,
0x000000002e2e7984ULL, 0x000ee20000000800ULL, 0x00005410ff377816ULL, 0x110fe4000000003eULL,
0x00007610ff3e7816ULL, 0x000fe2000000003eULL, 0x0000000030307984ULL, 0x000f220000000800ULL,
0x00005410ff397816ULL, 0x020fc40000000040ULL, 0x00007610ff407816ULL, 0x000fe20000000040ULL,
0x0000000032327984ULL, 0x000f620000000800ULL, 0x00005410ff3b7816ULL, 0x100fe40000000042ULL,
0x00007610ff427816ULL, 0x000fe20000000042ULL, 0x000000002a2a7984ULL, 0x000f620000000800ULL,
0x00005410ff3f7816ULL, 0x104fe40000000044ULL, 0x00007610ff447816ULL, 0x000fe40000000044ULL,
0x00005410ff417816ULL, 0x000fc40000000046ULL, 0x00007610ff467816ULL, 0x000fe40000000046ULL,
0x00005410ff437816ULL, 0x100fe40000000048ULL, 0x00007610ff487816ULL, 0x000fe40000000048ULL,
0x00005410ff4b7816ULL, 0x100fe40000000034ULL, 0x00007610ff347816ULL, 0x000fe40000000034ULL,
0x00005410ff4d7816ULL, 0x000fc4000000004aULL, 0x00007610ff4a7816ULL, 0x000fe4000000004aULL,
0x00005410ff4f7816ULL, 0x100fe4000000004cULL, 0x00007610ff4c7816ULL, 0x000fe4000000004cULL,
0x00005410ff517816ULL, 0x102fe4000000004eULL, 0x00007610ff4e7816ULL, 0x000fe4000000004eULL,
0x00005410ff457816ULL, 0x008fc4000000002eULL, 0x00007610ff507816ULL, 0x000fe4000000002eULL,
0x00005410ff477816ULL, 0x110fe40000000030ULL, 0x00007610ff527816ULL, 0x000fe40000000030ULL,
0x00005410ff497816ULL, 0x120fe40000000032ULL, 0x00007610ff547816ULL, 0x000fe40000000032ULL,
0x00005410ff537816ULL, 0x000fc4000000002aULL, 0x00007610ff567816ULL, 0x000fe2000000002aULL,
0x00006c327f007947ULL, 0x000fea000b800000ULL, 0x00001f582f2d7589ULL, 0x0002a400000e0000ULL,
0x00006c827f007947ULL, 0x000fea000b800000ULL, 0x00001f5a2f2a7589ULL, 0x00072400000e0000ULL,
0x0000002d33287223ULL, 0x084fe20000010028ULL, 0x0000002d38277223ULL, 0x080fe20000010027ULL,
0x0000002d35267223ULL, 0x080fe20000010026ULL, 0x0000002d3a257223ULL, 0x080fe20000010025ULL,
0x0000002d37247223ULL, 0x080fe20000010024ULL, 0x0000002d3e237223ULL, 0x080fe20000010023ULL,
0x0000002d39227223ULL, 0x080fe20000010022ULL, 0x0000002d40217223ULL, 0x080fe20000010021ULL,
0x0000002d3b207223ULL, 0x080fe20000010020ULL, 0x0000002d421f7223ULL, 0x080fe2000001001fULL,
0x0000002d3f1e7223ULL, 0x080fe2000001001eULL, 0x0000002d441d7223ULL, 0x080fe2000001001dULL,
0x0000002d411c7223ULL, 0x080fe2000001001cULL, 0x0000002d461b7223ULL, 0x080fe2000001001bULL,
0x0000002d431a7223ULL, 0x080fe2000001001aULL, 0x0000002d48197223ULL, 0x000fe20000010019ULL,
0x0000002a45187223ULL, 0x090fe20000010018ULL, 0x0000002a50177223ULL, 0x080fe20000010017ULL,
0x0000002a47167223ULL, 0x080fe20000010016ULL, 0x0000002a52157223ULL, 0x080fe20000010015ULL,
0x0000002a49147223ULL, 0x080fe20000010014ULL, 0x0000002a54137223ULL, 0x080fe20000010013ULL,
0x0000002a4b127223ULL, 0x080fe20000010012ULL, 0x0000002a34117223ULL, 0x080fe20000010011ULL,
0x0000002a4d107223ULL, 0x080fe20000010010ULL, 0x0000002a4a0f7223ULL, 0x080fe2000001000fULL,
0x0000002a4f0e7223ULL, 0x080fe2000001000eULL, 0x0000002a4c0d7223ULL, 0x080fe2000001000dULL,
0x0000002a510c7223ULL, 0x080fe2000001000cULL, 0x0000002a4e0b7223ULL, 0x080fe2000001000bULL,
0x0000002a530a7223ULL, 0x080fe2000001000aULL, 0x0000002a56097223ULL, 0x000fe20000010009ULL,
0xfffff24000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x000000ff3c00720cULL, 0x000fe20003f05270ULL,
0x0000001000057824ULL, 0x004fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fc80000011600ULL,
0x0000007005057812ULL, 0x000fe400078ec0ffULL, 0x0000000c00007812ULL, 0x000fca00078ec0ffULL,
0x0000000100077824ULL, 0x000fe200078e0205ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000057824ULL, 0x004fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fc80000011600ULL, 0x0000007005007812ULL, 0x000fe400078ec0ffULL,
0x0000000c06057812ULL, 0x000fc600078ec0ffULL, 0x0000008055007824ULL, 0x000fc800078e0200ULL,
0x0000000105057824ULL, 0x000fca00078e0200ULL, 0x0049803605007388ULL, 0x0005e40000000800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800007007984ULL, 0x000f280000000800ULL,
0x004a000007057984ULL, 0x004ea20000000800ULL, 0x00000000ff007221ULL, 0x010fc80000010000ULL,
0x0000000500007221ULL, 0x004fca0000010000ULL, 0x0180000000057810ULL, 0x000fc80007ffe0ffULL,
0x7f80000005057812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0500780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff417224ULL, 0x000fe200078e0000ULL, 0x0000f33000067802ULL, 0x000fe40000000f00ULL,
0x00006d2000007944ULL, 0x02afea0003c00000ULL, 0x000000ffff057224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000057308ULL, 0x000ea40000001000ULL,
0xbf80000000067423ULL, 0x004fc80000000005ULL, 0x800000ff06067221ULL, 0x000fc80000010100ULL,
0x0000000605057223ULL, 0x000fe40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000800297811ULL, 0x004fe400078ff0ffULL, 0x00000002ff2c7819ULL, 0x000fe40000011600ULL,
0x00000029ff2a7212ULL, 0x000fe200078e33ffULL, 0x00001f2905077589ULL, 0x000ea200000e0000ULL,
0x00000008292b7824ULL, 0x000fc400078e00ffULL, 0x000000082c2e7824ULL, 0x000fe200078e00ffULL,
0x00001f2c05067589ULL, 0x00086400000e0000ULL, 0xfffffff82b2a7812ULL, 0x000fca00078ee22aULL,
0x000000102a2a7824ULL, 0x000fe200078e0203ULL, 0x0000002cff057212ULL, 0x010fc800078e33ffULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee205ULL, 0x000000072c057812ULL, 0x040fe200078ec0ffULL,
0x0000001807187220ULL, 0x044fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001607167220ULL, 0x040fe20000410000ULL, 0x0000001507157220ULL, 0x040fe20000410000ULL,
0x0000001407147220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001107117220ULL, 0x040fe20000410000ULL,
0x0000001007107220ULL, 0x040fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000000e070e7220ULL, 0x040fe20000410000ULL, 0x0000000d070d7220ULL, 0x040fe20000410000ULL,
0x0000000c070c7220ULL, 0x040fe20000410000ULL, 0x0000000b070b7220ULL, 0x040fe20000410000ULL,
0x0000000a070a7220ULL, 0x040fe20000410000ULL, 0x0000000907077220ULL, 0x000fe20000410000ULL,
0x000000082c097824ULL, 0x000fe200078e00ffULL, 0x0000002206227220ULL, 0x042fe20000410000ULL,
0x0000002106217220ULL, 0x040fe20000410000ULL, 0x0000002806287220ULL, 0x040fe20000410000ULL,
0x0000002706277220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000002506257220ULL, 0x040fe20000410000ULL, 0x0000002406247220ULL, 0x040fe20000410000ULL,
0x0000002306237220ULL, 0x040fe20000410000ULL, 0x0000002006207220ULL, 0x040fe20000410000ULL,
0x0000001f061f7220ULL, 0x040fe20000410000ULL, 0x0000001e061e7220ULL, 0x040fe20000410000ULL,
0x0000001d061d7220ULL, 0x040fe20000410000ULL, 0x0000001c061c7220ULL, 0x040fe20000410000ULL,
0x0000001b061b7220ULL, 0x040fe20000410000ULL, 0x0000001a061a7220ULL, 0x040fe20000410000ULL,
0x0000001906197220ULL, 0x000fe20000410000ULL, 0xfffffff809067812ULL, 0x000fc400078ee22cULL,
0x0000000105097812ULL, 0x040fe400078e3cffULL, 0x00000002052b7812ULL, 0x040fe200078e3cffULL,
0x0000001006067824ULL, 0x000fe200078e0203ULL, 0x00000003052d7812ULL, 0x040fe200078e3cffULL,
0x000000082c087824ULL, 0x000fe200078e0209ULL, 0x00000004052f7812ULL, 0x048fe400078e3cffULL,
0x0000000505317812ULL, 0x040fe200078e3cffULL, 0x0000001008087824ULL, 0x000fe200078e0203ULL,
0x0000000605057812ULL, 0x000fc400078e3cffULL, 0x000000222121723eULL, 0x000fe400000010ffULL,
0x0000000729227812ULL, 0x000fe400078ec0ffULL, 0x000000121111723eULL, 0x000fe200000010ffULL,
0x000000082c127824ULL, 0x000fe200078e0205ULL, 0x000000201f1f723eULL, 0x000fe400000010ffULL,
0x0000001e1d1d723eULL, 0x000fe200000010ffULL, 0x0000001012127824ULL, 0x000fe200078e0203ULL,
0x000000181717723eULL, 0x000fc400000010ffULL, 0x000000141313723eULL, 0x000fe200000010ffULL,
0x0000000829147824ULL, 0x000fe200078e00ffULL, 0x0000000122057812ULL, 0x040fe400078e3cffULL,
0x0000000222097812ULL, 0x040fe400078e3cffULL, 0x0000000322187812ULL, 0x040fe400078e3cffULL,
0x00000004221e7812ULL, 0x040fe400078e3cffULL, 0x0000000522207812ULL, 0x000fc400078e3cffULL,
0x000000242323723eULL, 0x000fe200000010ffULL, 0x0000000400247824ULL, 0x000fe200078e00ffULL,
0x0000000622227812ULL, 0x000fe200078e3cffULL, 0x00000008291e7824ULL, 0x000fe200078e021eULL,
0x0000001c1b1b723eULL, 0x000fe200000010ffULL, 0x00000008291c7824ULL, 0x000fe200078e0218ULL,
0x0000001a1919723eULL, 0x000fe200000010ffULL, 0x00000008291a7824ULL, 0x000fe200078e0209ULL,
0x000000161515723eULL, 0x000fe200000010ffULL, 0x0000000829167824ULL, 0x000fe200078e0205ULL,
0x0000000a0707723eULL, 0x000fe200000010ffULL, 0x000000082c0a7824ULL, 0x000fe200078e022bULL,
0x0000000c0b0b723eULL, 0x000fe200000010ffULL, 0x0000000829207824ULL, 0x040fe200078e0220ULL,
0xfffffff814147812ULL, 0x000fe200078ee229ULL, 0x0000000829227824ULL, 0x000fe200078e0222ULL,
0x0000000e0d0d723eULL, 0x000fe200000010ffULL, 0x000000082c0c7824ULL, 0x000fe200078e022dULL,
0x0000000c24297812ULL, 0x000fe200078ec0ffULL, 0x000000082c0e7824ULL, 0x040fe200078e022fULL,
0x000000100f0f723eULL, 0x000fe200000010ffULL, 0x000000082c107824ULL, 0x000fe200078e0231ULL,
0x000000282727723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x100fe200078e0203ULL,
0x000000262525723eULL, 0x000fe200000010ffULL, 0x000000100c0c7824ULL, 0x000fc400078e0203ULL,
0x0000000129067824ULL, 0x040fe400078e0206ULL, 0x000000100e0e7824ULL, 0x100fe400078e0203ULL,
0x0000001010107824ULL, 0x100fe200078e0203ULL, 0x0000002706007388ULL, 0x000fe20000000800ULL,
0x0000000129087824ULL, 0x040fe400078e0208ULL, 0x00000001290a7824ULL, 0x040fe400078e020aULL,
0x000000102e057824ULL, 0x000fe200078e0203ULL, 0x0000002508007388ULL, 0x000fe20000000800ULL,
0x00000001290c7824ULL, 0x000fc400078e020cULL, 0x0000001014097824ULL, 0x100fe200078e0203ULL,
0x000000230a007388ULL, 0x000fe20000000800ULL, 0x00000001290e7824ULL, 0x040fe400078e020eULL,
0x0000001016187824ULL, 0x100fe200078e0203ULL, 0x000000210c007388ULL, 0x000fe20000000800ULL,
0x0000000129107824ULL, 0x040fe400078e0210ULL, 0x000000101a1a7824ULL, 0x000fe200078e0203ULL,
0x0000001f0e007388ULL, 0x000fe20000000800ULL, 0x0000000129127824ULL, 0x000fc400078e0212ULL,
0x000000101c1c7824ULL, 0x000fe200078e0203ULL, 0x0000001d10007388ULL, 0x000fe20000000800ULL,
0x0000000129147824ULL, 0x040fe400078e0205ULL, 0x000000101e1e7824ULL, 0x000fe200078e0203ULL,
0x0000001b12007388ULL, 0x0003e20000000800ULL, 0x0000000129167824ULL, 0x040fe400078e0209ULL,
0x0000001020207824ULL, 0x000fe200078e0203ULL, 0x0000001914007388ULL, 0x000fe20000000800ULL,
0x0000000129187824ULL, 0x000fc400078e0218ULL, 0x0000001022227824ULL, 0x000fe200078e0203ULL,
0x0000001716007388ULL, 0x000fe20000000800ULL, 0x00000001291a7824ULL, 0x040fe200078e021aULL,
0x000000040412723eULL, 0x002fe200000010ffULL, 0x00000001291c7824ULL, 0x040fe200078e021cULL,
0x0000001518007388ULL, 0x000fe20000000800ULL, 0x00000001291e7824ULL, 0x040fe400078e021eULL,
0x0000000129207824ULL, 0x040fe200078e0220ULL, 0x000000131a007388ULL, 0x000fe20000000800ULL,
0x0000000129227824ULL, 0x000fc400078e0222ULL, 0x00000001292a7824ULL, 0x000fe200078e022aULL,
0x000000111c007388ULL, 0x000fe20000000800ULL, 0x0000002055037824ULL, 0x000fc600078e0200ULL,
0x0000000f1e007388ULL, 0x000fe20000000800ULL, 0x0000001003037824ULL, 0x000fc600078e0202ULL,
0x0000000d20007388ULL, 0x000fe80000000800ULL, 0x0000000b22007388ULL, 0x000fe80000000800ULL,
0x000000072a007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000003247984ULL, 0x000e680000000c00ULL, 0x00040000032c7984ULL, 0x000ea80000000c00ULL,
0x0008000003147984ULL, 0x000ee80000000c00ULL, 0x000c000003187984ULL, 0x000f220000000c00ULL,
0x3f803f8012277831ULL, 0x002fc40000200027ULL, 0x3f803f8012267831ULL, 0x040fe40000200026ULL,
0x3f803f8012257831ULL, 0x040fe40000200025ULL, 0x3f803f8012247831ULL, 0x040fe40000200024ULL,
0x3f803f80122f7831ULL, 0x044fe4000020002fULL, 0x3f803f80122e7831ULL, 0x040fe4000020002eULL,
0x3f803f80122d7831ULL, 0x000fc4000020002dULL, 0x3f803f80122c7831ULL, 0x000fe4000020002cULL,
0x3f803f8027277831ULL, 0x008fe40000200017ULL, 0x3f803f8026267831ULL, 0x000fe40000200016ULL,
0x3f803f8025257831ULL, 0x000fe40000200015ULL, 0x3f803f8024247831ULL, 0x000fe40000200014ULL,
0x3f803f802f2f7831ULL, 0x010fc4000020001bULL, 0x3f803f802e2e7831ULL, 0x000fe2000020001aULL,
0x0000002403007388ULL, 0x0003e20000000c00ULL, 0x3f803f802d2d7831ULL, 0x000fe40000200019ULL,
0x3f803f802c2c7831ULL, 0x000fca0000200018ULL, 0x0004002c03007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff5500720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000147919ULL, 0x004ea20000002600ULL,
0x0000002000157810ULL, 0x040fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000ee20000002700ULL,
0x0000004000177810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x00000003ff037819ULL, 0x002fe20000011600ULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x0000006000217810ULL, 0x000fe20007ffe0ffULL, 0x000000083c167824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fe40000011615ULL, 0x00000003ff087819ULL, 0x000fc40000011617ULL,
0x00000003ff0a7819ULL, 0x000fe40000011621ULL, 0x0000000705067812ULL, 0x000fe400078e4815ULL,
0x0000000708097812ULL, 0x000fe400078e4817ULL, 0x000000070a0b7812ULL, 0x000fe400078e4821ULL,
0x0ffffff806077812ULL, 0x000fe400078ef815ULL, 0x0ffffff809097812ULL, 0x000fe200078ef817ULL,
0x0000001014047824ULL, 0x004fe200078e00ffULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef821ULL,
0x0000001007077824ULL, 0x100fe200078e0202ULL, 0x00000004050472a4ULL, 0x008fe2000f8e023fULL,
0x0000001009097824ULL, 0x100fe200078e0202ULL, 0xfffffff004047812ULL, 0x000fe200078ee203ULL,
0x000000100b067824ULL, 0x000fe200078e0202ULL, 0x0000000703037812ULL, 0x100fe200078e4800ULL,
0x0000000007107984ULL, 0x0003e20000000c00ULL, 0x000000083c0b7824ULL, 0x000fe200078e00ffULL,
0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001014237824ULL, 0x040fe200078e00ffULL,
0x0ffffff803037812ULL, 0x100fe200078ef800ULL, 0x0000000009187984ULL, 0x000fe20000000c00ULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee200ULL, 0x0000001014007824ULL, 0x000fe200078e00ffULL,
0xfffffff023087812ULL, 0x000fe200078ee208ULL, 0x0000001003037824ULL, 0x000fe200078e0202ULL,
0x00000000061c7984ULL, 0x0005e20000000c00ULL, 0x000000083c027824ULL, 0x000fe200078e00ffULL,
0xfffffff000057812ULL, 0x000fe200078ee205ULL, 0x0000001014257824ULL, 0x000fe200078e00ffULL,
0x00000000030c7984ULL, 0x0007220000000c00ULL, 0x0000000408007c10ULL, 0x000fe2000ff3e0ffULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff802157812ULL, 0x000fc400078ee215ULL,
0xfffffff0250a7812ULL, 0x000fe200078ee20aULL, 0x000000ffff077224ULL, 0x002fe200008e06ffULL,
0x00005a0000067a11ULL, 0x004fe200078240ffULL, 0x000000ffff037224ULL, 0x008fe200000e06ffULL,
0x00005a0004027a11ULL, 0x000fe400078040ffULL, 0x000000040a0a7c10ULL, 0x000fe4000ff5e0ffULL,
0x00005b0004037a11ULL, 0x000fe400000f4403ULL, 0x0000000405057c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x00005a000a087a11ULL, 0x000fe200078440ffULL,
0x000000100b027825ULL, 0x000fe200078e0002ULL, 0xfffffff816177812ULL, 0x000fc400078ee217ULL,
0x00005b0000077a11ULL, 0x000fe200008f4407ULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x00005a0005047a11ULL, 0x000fe400078040ffULL, 0xfffffff83c217812ULL, 0x000fe200078ee221ULL,
0x0000001017067825ULL, 0x000fe200078e0006ULL, 0x00005b0005057a11ULL, 0x000fe400000f4414ULL,
0x00005b000a097a11ULL, 0x000fc600010f4409ULL, 0x0000001015047825ULL, 0x000fc800078e0004ULL,
0x0000001021087825ULL, 0x000fe200078e0008ULL, 0x0000000c02007986ULL, 0x010fe8000c101d08ULL,
0x0000001004007986ULL, 0x000fe8000c101d08ULL, 0x0000001806007986ULL, 0x000fe8000c101d08ULL,
0x0000001c08007986ULL, 0x000fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006800ff067624ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x00afe20000011634ULL,
0x00006900ff077624ULL, 0x000fc600078e00ffULL, 0x01ffffff03037812ULL, 0x000fe400078ec0ffULL,
0x00000008063a7981ULL, 0x000366000c1e9900ULL, 0x0000000236027824ULL, 0x000fca00078e0203ULL,
0x000000370200720cULL, 0x000fe40003f06070ULL, 0x0000000136007810ULL, 0x000fd60007ffe0ffULL,
0x0000000243038824ULL, 0x000fc800078e00ffULL, 0x0000640003048a24ULL, 0x000fe400078e0202ULL,
0xffffffffff037424ULL, 0x000fe400078e00ffULL, 0x0000600004048625ULL, 0x000fca00078e0010ULL,
0x0000000804038981ULL, 0x000362000c1e1900ULL, 0x000000390000720cULL, 0x000fe20003f06070ULL,
0x00000040343b7824ULL, 0x000fe400078e00ffULL, 0x000000803e387824ULL, 0x000fe400078e00ffULL,
0x00000100360b7824ULL, 0x000fe400078e023bULL, 0x000000803f3f7824ULL, 0x000fc600078e00ffULL,
0x0000004038127812ULL, 0x000fc600078ef80bULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x002e620000000000ULL, 0x000000033f127224ULL, 0x020fe200078e0212ULL,
0x0000000b35007217ULL, 0x000fe20007800000ULL, 0x00000080ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000100034157811ULL, 0x000fc600078e68ffULL, 0x0000000100007824ULL, 0x000fe200078e0a0bULL,
0x00000002ff1f7819ULL, 0x102fe20000011610ULL, 0x0000001010217824ULL, 0x000fe200078e00ffULL,
0x00000003ff137819ULL, 0x000fe40000011610ULL, 0x0000007f1f057812ULL, 0x040fe400078ec0ffULL,
0x000000081f0f7810ULL, 0x000fe40007ffe0ffULL, 0x0000003021217812ULL, 0x000fe200078ec0ffULL,
0x0000000112057824ULL, 0x000fe200078e0205ULL, 0x0000007f0f077812ULL, 0x040fe200078ec0ffULL,
0x000000040f147824ULL, 0x000fe200078e00ffULL, 0x000000101f237810ULL, 0x000fe20007ffe0ffULL,
0x00005e0005047625ULL, 0x000fe200078e001aULL, 0x000000181f257810ULL, 0x000fc40007ffe0ffULL,
0x0000007f23097812ULL, 0x000fe200078ec0ffULL, 0x0000000112077824ULL, 0x000fe200078e0207ULL,
0x00000021040a7210ULL, 0x080fe40007f1e0ffULL, 0x000000201f197810ULL, 0x000fe20007ffe0ffULL,
0x00005e0007067625ULL, 0x000fe200078e001aULL, 0x0000000313137812ULL, 0x000fe400078e4810ULL,
0x000000281f1b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0605ULL,
0x0000007f25057812ULL, 0x000fe200078ec0ffULL, 0x0000000112097824ULL, 0x000fe200078e0209ULL,
0x00000021060c7210ULL, 0x000fc40007f1e0ffULL, 0x000000301f1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000112057824ULL, 0x000fe200078e0205ULL, 0x000000002300720cULL, 0x000fe20003fa6070ULL,
0x00005e0009087625ULL, 0x000fe200078e001aULL, 0x000000002500720cULL, 0x000fc60003f86070ULL,
0x00005e0005047625ULL, 0x000fe200078e001aULL, 0x0000002108087210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e0607ULL, 0x0000007f19077812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x00000021040e7210ULL, 0x000fe20007f5e0ffULL,
0x000000041d167824ULL, 0x000fe200078e00ffULL, 0x000000001f00720cULL, 0x080fe20003f06070ULL,
0x0000000112077824ULL, 0x000fe200078e0207ULL, 0x000000000f00720cULL, 0x000fe20003f26070ULL,
0x000000ffff0f7224ULL, 0x000fe200010e0605ULL, 0x0ffffffc13047812ULL, 0x000fe200078ef810ULL,
0x00005e0007067625ULL, 0x000fe200078e001aULL, 0x0000007f1b057812ULL, 0x000fc400078ec0ffULL,
0x000000381f1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001004177824ULL, 0x000fe200078e0215ULL,
0x0000002106107210ULL, 0x000fe20007f7e0ffULL, 0x0000000112057824ULL, 0x000fe200078e0205ULL,
0xfffffffc14067812ULL, 0x000fe200078ee213ULL, 0x000000041b147824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a177faeULL, 0x0003e2000c101c48ULL,
0x00005e0005047625ULL, 0x000fe200078e001aULL, 0x000000001b00720cULL, 0x080fe40003f46070ULL,
0x000000001f00720cULL, 0x080fe20003f06070ULL, 0x000000ffff117224ULL, 0x000fe200018e0607ULL,
0x000000001900720cULL, 0x000fe20003f66070ULL, 0x0000001006077824ULL, 0x000fe200078e0215ULL,
0xfffffffc14147812ULL, 0x100fe200078ee213ULL, 0x000000041f187824ULL, 0x000fe200078e00ffULL,
0xfffffffc16167812ULL, 0x000fc400078ee213ULL, 0x0000007f1d0b7812ULL, 0x042fe200078ec0ffULL,
0x000000000c077faeULL, 0x0003e2000c901c48ULL, 0x00000021040a7210ULL, 0x000fe20007fde0ffULL,
0x00000010161b7824ULL, 0x000fe200078e0215ULL, 0x000000001d00720cULL, 0x000fe20003f26070ULL,
0x0000000112047824ULL, 0x000fe200078e020bULL, 0xfffffffc18187812ULL, 0x000fe200078ee213ULL,
0x000000ffff0b7224ULL, 0x000fe400030e0605ULL, 0x00005e0004047625ULL, 0x000fe200078e001aULL,
0x0000007f1f077812ULL, 0x002fc600078ec0ffULL, 0x0000000423007824ULL, 0x000fe200078e00ffULL,
0x0000002104047210ULL, 0x000fe20007fde0ffULL, 0x00000004250c7824ULL, 0x000fe400078e00ffULL,
0x0000000112077824ULL, 0x000fe200078e0207ULL, 0xfffffffc00007812ULL, 0x100fe200078ee213ULL,
0x0000000419127824ULL, 0x000fe200078e00ffULL, 0xfffffffc0c0c7812ULL, 0x000fe200078ee213ULL,
0x00005e0007067625ULL, 0x000fc600078e001aULL, 0xfffffffc12127812ULL, 0x000fe200078ee213ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x0000002106067210ULL, 0x000fe20007fde0ffULL,
0x00000010000d7824ULL, 0x100fe400078e0215ULL, 0x000000100c137824ULL, 0x100fe400078e0215ULL,
0x0000001012177824ULL, 0x100fe200078e0215ULL, 0x00000000080d7faeULL, 0x0003e2000e901c48ULL,
0x0000001014197824ULL, 0x100fe400078e0215ULL, 0x0000001018157824ULL, 0x000fe200078e0215ULL,
0x000000000e137faeULL, 0x0003e2000e101c48ULL, 0x000000ffff077224ULL, 0x000fc600030e0607ULL,
0x0000000010177faeULL, 0x0003e8000d901c48ULL, 0x000000000a197faeULL, 0x0003e8000d101c48ULL,
0x00000000041b7faeULL, 0x0003e8000c901c48ULL, 0x0000000006157faeULL, 0x0003e2000c101c48ULL,
0x000005a000007947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x002e620000000000ULL,
0x000000033f127224ULL, 0x020fe200078e0212ULL, 0x00000002ff047819ULL, 0x002fc40000011600ULL,
0x00000003ff057819ULL, 0x000fe40000011600ULL, 0x0000007f04077812ULL, 0x040fe400078ec0ffULL,
0x0000000804067810ULL, 0x040fe40007ffe0ffULL, 0x0000001004097810ULL, 0x040fe40007ffe0ffULL,
0x00000018040c7810ULL, 0x040fe40007ffe0ffULL, 0x00000020040f7810ULL, 0x000fc40007ffe0ffULL,
0x0000002804107810ULL, 0x000fe20007ffe0ffULL, 0x000000040c1c7824ULL, 0x000fe200078e00ffULL,
0x0000003004157810ULL, 0x040fe20007ffe0ffULL, 0x000000040f207824ULL, 0x000fe200078e00ffULL,
0x0000003804187810ULL, 0x000fe20007ffe0ffULL, 0x0000000112047824ULL, 0x000fe200078e0207ULL,
0x0000007f06077812ULL, 0x040fe200078ec0ffULL, 0x0000000406067824ULL, 0x000fe200078e00ffULL,
0x0000007f090b7812ULL, 0x000fe200078ec0ffULL, 0x0000000410227824ULL, 0x000fe200078e00ffULL,
0x0000007f0c0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000112087824ULL, 0x040fe200078e0207ULL,
0x0000007f0f117812ULL, 0x000fe200078ec0ffULL, 0x00000001120a7824ULL, 0x000fe200078e020bULL,
0x0000007f10137812ULL, 0x000fe200078ec0ffULL, 0x00000001120e7824ULL, 0x040fe200078e020dULL,
0x0000007f15177812ULL, 0x000fe200078ec0ffULL, 0x0000000112147824ULL, 0x000fe200078e0211ULL,
0x0000007f18197812ULL, 0x000fe200078ec0ffULL, 0x0000000112167824ULL, 0x040fe200078e0213ULL,
0x0000000305077812ULL, 0x100fe200078e4800ULL, 0x00000001121a7824ULL, 0x000fe200078e0217ULL,
0x00001000340b7811ULL, 0x000fe200078e68ffULL, 0x00000001121e7824ULL, 0x000fe200078e0219ULL,
0xfffffffc06067812ULL, 0x100fe200078ee207ULL, 0x0000000409127824ULL, 0x000fe200078e00ffULL,
0xfffffffc1c107812ULL, 0x100fe200078ee207ULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x0ffffffc07007812ULL, 0x000fe200078ef800ULL, 0x0000000415247824ULL, 0x000fe200078e00ffULL,
0xfffffffc120c7812ULL, 0x100fe200078ee207ULL, 0x0000000418267824ULL, 0x000fe200078e00ffULL,
0xfffffffc20127812ULL, 0x000fe200078ee207ULL, 0x00000080ff137424ULL, 0x000fe200078e00ffULL,
0x0000003005157812ULL, 0x000fe200078ec0ffULL, 0x0000001006197824ULL, 0x000fe200078e020bULL,
0xfffffffc22187812ULL, 0x100fe200078ee207ULL, 0x00005e0004047625ULL, 0x000fe200078e0013ULL,
0xfffffffc241c7812ULL, 0x000fc400078ee207ULL, 0xfffffffc26207812ULL, 0x000fe200078ee207ULL,
0x00005e0008067625ULL, 0x000fe200078e0013ULL, 0x0000001504047210ULL, 0x000fc60007f1e0ffULL,
0x0000001000177824ULL, 0x100fe200078e020bULL, 0x0000001506067210ULL, 0x000fe20007f3e0ffULL,
0x000000100c1b7824ULL, 0x100fe400078e020bULL, 0x00000010101d7824ULL, 0x100fe400078e020bULL,
0x00000010121f7824ULL, 0x100fe400078e020bULL, 0x0000001018217824ULL, 0x000fe400078e020bULL,
0x00005e000a087625ULL, 0x000fc800078e0013ULL, 0x000000101c237824ULL, 0x100fe200078e020bULL,
0x0000001508087210ULL, 0x000fe20007f5e0ffULL, 0x0000001020257824ULL, 0x000fe400078e020bULL,
0x00005e000e0a7625ULL, 0x000fc800078e0013ULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x000000150a0a7210ULL, 0x000fe20007f1e0ffULL, 0x00005e00140c7625ULL, 0x000fc600078e0013ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004177faeULL, 0x0003e2000b901c48ULL,
0x00005e00160e7625ULL, 0x000fc800078e0013ULL, 0x00005e001a107625ULL, 0x000fc800078e0013ULL,
0x00005e001e127625ULL, 0x000fc800078e0013ULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x000000150c0c7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x000000150e0e7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000001510107210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000001512127210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x0000000006197faeULL, 0x0003e2000b901c48ULL, 0x000000ffff117224ULL, 0x000fc400010e0611ULL,
0x000000ffff137224ULL, 0x000fe200018e0613ULL, 0x00000000081b7faeULL, 0x0003e8000b901c48ULL,
0x000000000a1d7faeULL, 0x0003e8000b901c48ULL, 0x000000000c1f7faeULL, 0x0003e8000b901c48ULL,
0x000000000e217faeULL, 0x0003e8000b901c48ULL, 0x0000000010237faeULL, 0x0003e8000b901c48ULL,
0x0000000012257faeULL, 0x0003e4000b901c48ULL, 0x00f60400ff007984ULL, 0x000ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000000ff7812ULL, 0x004fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x00f60400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000033400780cULL, 0x000fda0003f04070ULL, 0x0000017000000947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x002e640000000000ULL, 0x0000002034007824ULL, 0x002fc800078e0205ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7800ULL,
0x0000000707077812ULL, 0x000fc600078e7800ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001005007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ffff7f8cULL, 0x000fe8000c80043fULL, 0x00f60400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x00f60400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000393600720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000003c7919ULL, 0x000ea20000000000ULL,
0x3db504f33a3a7820ULL, 0x000fe20000410000ULL, 0x0000640043437a24ULL, 0x000fe200078e02ffULL,
0xffffffff39417810ULL, 0x000fe20007ffe0ffULL, 0x0000001034407824ULL, 0x000fe200078e00ffULL,
0x00007610ff3d7816ULL, 0x000fe2000000003dULL, 0x000000ffff3f7224ULL, 0x000fe200078e00ffULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x0000000704047899ULL, 0x000fe4000800063fULL,
0x00000100363e7824ULL, 0x000fe200078e023bULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000003e3500720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x028fea0003800000ULL,
0x000000ffff457224ULL, 0x000fe200078e003fULL, 0x0000000000207805ULL, 0x002fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fc4000001ff00ULL,
0x0000000100247810ULL, 0x000fe20007ffe0ffULL, 0x00000bd000007945ULL, 0x000fe20003800000ULL,
0x000000ffff427224ULL, 0x000fe200078e0000ULL, 0x00000001453f7812ULL, 0x000fc400078e0cffULL,
0x00000001ff257819ULL, 0x100fe20000011624ULL, 0x000000ffff007224ULL, 0x000fe200078e0024ULL,
0x000000022400780cULL, 0x040fe40003f06070ULL, 0x0000000124587812ULL, 0x000fe200078ec0ffULL,
0x0000030025267a24ULL, 0x000fca00078e0236ULL, 0x0000000126287810ULL, 0x040fe20007ffe0ffULL,
0x0000010026267824ULL, 0x000fc600078e023bULL, 0x000000392800720cULL, 0x000fe40003f26070ULL,
0x0000004026257812ULL, 0x000fca00078ec0ffULL, 0x0000000138287824ULL, 0x000fcc00078e0225ULL,
0x000005d000009947ULL, 0x020fea0003800000ULL, 0x0000002635247217ULL, 0x000fe20007800000ULL,
0x0000000403297c24ULL, 0x000fe2000f8e0228ULL, 0x00000002ff2f7819ULL, 0x104fe2000001163cULL,
0x0000000458317824ULL, 0x000fe200078e00ffULL, 0x00000003ff257819ULL, 0x000fe2000001163cULL,
0x0000000124287824ULL, 0x000fe200078e0a26ULL, 0x0000007f2f247812ULL, 0x040fe200078ec0ffULL,
0x00000002342a7824ULL, 0x000fe200078e023fULL, 0x000000082f277810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff517424ULL, 0x000fe200078e00ffULL, 0x0000000325337812ULL, 0x100fe200078e483cULL,
0x0000000124247824ULL, 0x000fe200078e0229ULL, 0x0000007f27267812ULL, 0x040fe200078ec0ffULL,
0x00000004272c7824ULL, 0x000fe200078e00ffULL, 0x000000282f00720cULL, 0x000fe20003f26070ULL,
0x00005e0024247625ULL, 0x000fe200078e0051ULL, 0xfffffffc31317812ULL, 0x000fc400078ee23cULL,
0x000010002a2a7811ULL, 0x000fe200078e60ffULL, 0x0000000126267824ULL, 0x000fe200078e0229ULL,
0x0ffffffc332b7812ULL, 0x000fe200078ef83cULL, 0x0000001031247825ULL, 0x000fe200078e0024ULL,
0x000000282f4d7810ULL, 0x000fe40007ffe0ffULL, 0x000000282700720cULL, 0x000fe20003f46070ULL,
0x00005e0026267625ULL, 0x000fe200078e0051ULL, 0x000000102f477810ULL, 0x040fe40007ffe0ffULL,
0x000000182f497810ULL, 0x000fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e022aULL,
0x000000202f4b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001031267825ULL, 0x000fe200078e0026ULL,
0x000000302f4f7810ULL, 0x000fc40007ffe0ffULL, 0x000000382f2f7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242b7faeULL, 0x0003e2000c901c48ULL,
0xfffffffc2c2d7812ULL, 0x000fe200078ee233ULL, 0x0000000449327824ULL, 0x000fe200078e00ffULL,
0x0000007f4d2c7812ULL, 0x000fe200078ec0ffULL, 0x000000044b447824ULL, 0x000fe200078e00ffULL,
0x0000007f4f2e7812ULL, 0x000fe200078ec0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e022aULL,
0x0000007f2f307812ULL, 0x000fe200078ec0ffULL, 0x000000044d467824ULL, 0x000fe200078e00ffULL,
0x000000284700720cULL, 0x080fe20003f26070ULL, 0x000000044f487824ULL, 0x000fe200078e00ffULL,
0x00000000262d7faeULL, 0x0005e2000d101c48ULL, 0x000000012c2b7824ULL, 0x102fe200078e0229ULL,
0x0000007f47247812ULL, 0x000fe200078ec0ffULL, 0x000000012e2c7824ULL, 0x100fe200078e0229ULL,
0x000000284900720cULL, 0x080fe20003f46070ULL, 0x00000001302e7824ULL, 0x100fe200078e0229ULL,
0x000000284b00720cULL, 0x080fe20003f66070ULL, 0x0000000447307824ULL, 0x000fe200078e00ffULL,
0x000000284d00720cULL, 0x080fe20003f86070ULL, 0x000000042f4a7824ULL, 0x000fe200078e00ffULL,
0x000000284f00720cULL, 0x080fe20003fa6070ULL, 0x0000000124247824ULL, 0x000fe200078e0229ULL,
0x000000282f00720cULL, 0x000fe20003fc6070ULL, 0x00005e002c2c7625ULL, 0x004fe200078e0051ULL,
0x0000007f49267812ULL, 0x000fc400078ec0ffULL, 0x0000007f4b287812ULL, 0x000fe200078ec0ffULL,
0x00005e002e2e7625ULL, 0x080fe200078e0051ULL, 0xfffffffc30257812ULL, 0x100fe400078ee233ULL,
0xfffffffc32477812ULL, 0x000fe200078ee233ULL, 0x0000000126267824ULL, 0x000fe200078e0229ULL,
0xfffffffc44497812ULL, 0x000fe200078ee233ULL, 0x0000000128287824ULL, 0x000fe200078e0229ULL,
0xfffffffc464b7812ULL, 0x100fe200078ee233ULL, 0x00005e0026267625ULL, 0x000fe200078e0051ULL,
0xfffffffc484d7812ULL, 0x000fc400078ee233ULL, 0xfffffffc4a4f7812ULL, 0x000fe200078ee233ULL,
0x0000001025337824ULL, 0x000fe400078e022aULL, 0x00005e0024247625ULL, 0x000fc800078e0051ULL,
0x0000001047477824ULL, 0x100fe400078e022aULL, 0x0000001049497824ULL, 0x100fe400078e022aULL,
0x000000104b4b7824ULL, 0x100fe400078e022aULL, 0x000000104d4d7824ULL, 0x100fe400078e022aULL,
0x000000104f4f7824ULL, 0x000fe400078e022aULL, 0x00005e0028287625ULL, 0x000fc800078e0051ULL,
0x00005e002b2a7625ULL, 0x000fc800078e0051ULL, 0x0000001031247825ULL, 0x000fc800078e0024ULL,
0x0000001031267825ULL, 0x040fe200078e0026ULL, 0x0000000024337faeULL, 0x0003e6000c901c48ULL,
0x0000001031287825ULL, 0x040fe200078e0028ULL, 0x0000000026477faeULL, 0x0003e6000d101c48ULL,
0x00000010312a7825ULL, 0x040fe200078e002aULL, 0x0000000028497faeULL, 0x0003e6000d901c48ULL,
0x00000010312c7825ULL, 0x040fe200078e002cULL, 0x000000002a4b7faeULL, 0x0003e6000e101c48ULL,
0x00000010312e7825ULL, 0x000fe200078e002eULL, 0x000000002c4d7faeULL, 0x0003e8000e901c48ULL,
0x000000002e4f7faeULL, 0x0003e2000f101c48ULL, 0x0000052000007947ULL, 0x000fea0003800000ULL,
0x00000002ff247819ULL, 0x004fe2000001163cULL, 0x0000000403287c24ULL, 0x000fc4000f8e0228ULL,
0x0000000234267824ULL, 0x000fe200078e023fULL, 0x0000007f24257812ULL, 0x040fe400078ec0ffULL,
0x00000008242a7810ULL, 0x040fe40007ffe0ffULL, 0x00000010242b7810ULL, 0x040fe40007ffe0ffULL,
0x00000018242d7810ULL, 0x040fe40007ffe0ffULL, 0x00000020242f7810ULL, 0x040fe40007ffe0ffULL,
0x0000002824327810ULL, 0x040fe20007ffe0ffULL, 0x000000042d4a7824ULL, 0x000fe200078e00ffULL,
0x0000003024467810ULL, 0x040fe20007ffe0ffULL, 0x000000042f4e7824ULL, 0x000fe200078e00ffULL,
0x0000003824497810ULL, 0x000fe20007ffe0ffULL, 0x0000000125247824ULL, 0x100fe200078e0228ULL,
0x0000007f2a257812ULL, 0x000fe200078ec0ffULL, 0x0000000432527824ULL, 0x000fe200078e00ffULL,
0x0000007f2b277812ULL, 0x000fe200078ec0ffULL, 0x0000000446547824ULL, 0x000fe200078e00ffULL,
0x0000007f2d297812ULL, 0x000fe200078ec0ffULL, 0x00000001252c7824ULL, 0x100fe200078e0228ULL,
0x0000007f2f317812ULL, 0x000fe200078ec0ffULL, 0x00000001272e7824ULL, 0x100fe200078e0228ULL,
0x0000007f32337812ULL, 0x000fe200078ec0ffULL, 0x0000000129307824ULL, 0x100fe200078e0228ULL,
0x0000007f46477812ULL, 0x000fe200078ec0ffULL, 0x0000000131447824ULL, 0x100fe200078e0228ULL,
0x0000007f494b7812ULL, 0x000fe200078ec0ffULL, 0x0000000133487824ULL, 0x000fe200078e0228ULL,
0x00000003ff257819ULL, 0x000fe2000001163cULL, 0x00000001474c7824ULL, 0x100fe200078e0228ULL,
0x0000100026297811ULL, 0x000fe200078e60ffULL, 0x000000014b507824ULL, 0x000fe200078e0228ULL,
0x0000000325277812ULL, 0x000fe200078e483cULL, 0x000000042a287824ULL, 0x000fc400078e00ffULL,
0x000000042b2a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc4a327812ULL, 0x100fe200078ee227ULL,
0x0000000449567824ULL, 0x000fe200078e00ffULL, 0x0ffffffc27267812ULL, 0x000fe200078ef83cULL,
0x0000000458477824ULL, 0x000fe200078e00ffULL, 0xfffffffc4e467812ULL, 0x100fe200078ee227ULL,
0x00000080ff337424ULL, 0x000fe200078e00ffULL, 0xfffffffc524a7812ULL, 0x000fe200078ee227ULL,
0x0000001026497824ULL, 0x000fe200078e0229ULL, 0xfffffffc28287812ULL, 0x100fe200078ee227ULL,
0x00005e0024247625ULL, 0x000fe200078e0033ULL, 0xfffffffc2a2a7812ULL, 0x000fc400078ee227ULL,
0xfffffffc544e7812ULL, 0x000fe200078ee227ULL, 0x00000010284b7824ULL, 0x000fe200078e0229ULL,
0xfffffffc56527812ULL, 0x000fe200078ee227ULL, 0x000000102a4d7824ULL, 0x100fe200078e0229ULL,
0xfffffffc47477812ULL, 0x000fe200078ee23cULL, 0x00000010324f7824ULL, 0x100fe400078e0229ULL,
0x0000001046517824ULL, 0x100fe400078e0229ULL, 0x000000104a537824ULL, 0x100fe400078e0229ULL,
0x000000104e557824ULL, 0x000fc400078e0229ULL, 0x0000001052577824ULL, 0x000fe400078e0229ULL,
0x00005e002c267625ULL, 0x000fc800078e0033ULL, 0x00005e002e287625ULL, 0x000fc800078e0033ULL,
0x00005e00302a7625ULL, 0x000fc800078e0033ULL, 0x00005e00442c7625ULL, 0x000fc800078e0033ULL,
0x00005e00482e7625ULL, 0x000fc800078e0033ULL, 0x0000001047247825ULL, 0x000fc800078e0024ULL,
0x00005e004c307625ULL, 0x080fe200078e0033ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024497faeULL, 0x0003e6000b901c48ULL, 0x00005e0050327625ULL, 0x000fc800078e0033ULL,
0x0000001047267825ULL, 0x000fc800078e0026ULL, 0x0000001047287825ULL, 0x040fe200078e0028ULL,
0x00000000264b7faeULL, 0x0003e6000b901c48ULL, 0x00000010472a7825ULL, 0x040fe200078e002aULL,
0x00000000284d7faeULL, 0x0003e6000b901c48ULL, 0x00000010472c7825ULL, 0x040fe200078e002cULL,
0x000000002a4f7faeULL, 0x0003e6000b901c48ULL, 0x00000010472e7825ULL, 0x040fe200078e002eULL,
0x000000002c517faeULL, 0x0003e6000b901c48ULL, 0x0000001047307825ULL, 0x040fe200078e0030ULL,
0x000000002e537faeULL, 0x0003e6000b901c48ULL, 0x0000001047327825ULL, 0x000fe200078e0032ULL,
0x0000000030557faeULL, 0x0003e8000b901c48ULL, 0x0000000032577faeULL, 0x0003e4000b901c48ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5800720cULL, 0x000fe20003f25270ULL,
0x000000b000007945ULL, 0x000fd80003800000ULL, 0x0000009000009947ULL, 0x000fea0003800000ULL,
0x00000300ff037624ULL, 0x000fc800078e00ffULL, 0x0000000203027824ULL, 0x000fe400078e0202ULL,
0xffffffffff037424ULL, 0x000fc600078e00ffULL, 0x000000370200720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000243247824ULL, 0x002fe400078e0202ULL,
0x00000004ff257424ULL, 0x000fc800078e00ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x0000000824037981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000842497824ULL, 0x002fe400078e00ffULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff83c257812ULL, 0x000fe200078ec0ffULL, 0x0000000234297824ULL, 0x000fe200078e0245ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000001472b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000725257812ULL, 0x000fe400078ef83cULL, 0x0000100029297811ULL, 0x000fc400078e60ffULL,
0x00000001ff247819ULL, 0x000fe40000011625ULL, 0x000000073ccf7812ULL, 0x000fe400078ec0ffULL,
0x0000000324247812ULL, 0x000fe400078ec0ffULL, 0x00000008cfcf7812ULL, 0x000fe400078ef83cULL,
0x0000004724267212ULL, 0x040fe400078e3cffULL, 0x0000002b24247212ULL, 0x000fc600078e3cffULL,
0x0000000425267824ULL, 0x040fe400078e0226ULL, 0x0000000425247824ULL, 0x000fe200078e0224ULL,
0x000000203c257810ULL, 0x000fe20007ffe0ffULL, 0x0000001026267824ULL, 0x100fe400078e0229ULL,
0x0000001024247824ULL, 0x000fe200078e0229ULL, 0xfffffff825257812ULL, 0x000fe400078ec0ffULL,
0x000000002630783bULL, 0x000e640000000200ULL, 0x0000000725287812ULL, 0x000fc400078ef83cULL,
0x00000000242c783bULL, 0x0004e40000000200ULL, 0x00000001ff247819ULL, 0x004fc80000011628ULL,
0x00000003242a7812ULL, 0x000fc800078ec0ffULL, 0x000000472a257212ULL, 0x040fe400078e3cffULL,
0x0000002b2a2b7212ULL, 0x000fe400078e3cffULL, 0x0000000247477810ULL, 0x000fe20007ffe0ffULL,
0x0000000428247824ULL, 0x040fe400078e0225ULL, 0x0000000428287824ULL, 0x000fe400078e022bULL,
0x0000001024247824ULL, 0x100fe400078e0229ULL, 0x0000001028287824ULL, 0x000fc800078e0229ULL,
0x000000002424783bULL, 0x000ea80000000200ULL, 0x000000002828783bULL, 0x000f220000000200ULL,
0x0000003000747306ULL, 0x002fe20000009400ULL, 0x00000018ffab7819ULL, 0x000fe20000011430ULL,
0x0001000030607824ULL, 0x000fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe20000011431ULL,
0x0000010032af7824ULL, 0x000fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe20000011432ULL,
0x0001000033ae7824ULL, 0x040fe200078e00ffULL, 0x00000018ffb27819ULL, 0x000fe20000011460ULL,
0x0000003000b37306ULL, 0x000e620000005400ULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x0000010033aa7824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe20000011433ULL,
0x000100002c7b7824ULL, 0x048fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe200000114aeULL,
0x000100002d7e7824ULL, 0x040fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x00000030005f7306ULL, 0x0006a2000000d400ULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x000001002c807824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x000001002d817824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe2000001142cULL,
0x000100002e757824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x000000b200b47306ULL, 0x000fe20000209400ULL, 0x0000010030307824ULL, 0x008fe200078e00ffULL,
0x000000b37400720bULL, 0x002fe20003f9d000ULL, 0x000001002e6d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fc4000001142eULL, 0x00000018ffb67819ULL, 0x000fe20000011430ULL,
0x0001000031307824ULL, 0x000fe200078e00ffULL, 0x000000b200b57306ULL, 0x000e620000205400ULL,
0x00000018ff817819ULL, 0x000fe40000011481ULL, 0x00000018ff9c7819ULL, 0x004fe20000011424ULL,
0x0001000024c87824ULL, 0x000fe200078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe20000011430ULL,
0x0001000032307824ULL, 0x000fe200078e00ffULL, 0x000000015f5f4812ULL, 0x000fe200078efcffULL,
0x000000b600b77306ULL, 0x000fe20000209400ULL, 0x00000018ffc87819ULL, 0x000fc400000114c8ULL,
0x00000018ffc17819ULL, 0x000fe40000011430ULL, 0x00000018ff997819ULL, 0x000fe40000011425ULL,
0x00000018ff967819ULL, 0x000fe20000011426ULL, 0x000000b600b87306ULL, 0x000ea20000205400ULL,
0x000000b5b400720bULL, 0x002fe20003f5d000ULL, 0x0000010027b57824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe40000011427ULL, 0x00000018ff647819ULL, 0x000fc4000001142dULL,
0x00000018ffb57819ULL, 0x000fe200000114b5ULL, 0x0000003100a77306ULL, 0x000fe20000009400ULL,
0x00000018ff507819ULL, 0x000fe4000001142fULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000018ff6d7819ULL, 0x000fc6000001146dULL, 0x0000003100a47306ULL, 0x000e620000005400ULL,
0x000000b8b700720bULL, 0x004fce0003f7d000ULL, 0x00000031005e7306ULL, 0x0004f0000000d400ULL,
0x000000ab00b97306ULL, 0x000fe20000209400ULL, 0x0000010031317824ULL, 0x004fe200078e00ffULL,
0x000000a4a700720bULL, 0x002fc40003f3d000ULL, 0x000000b600a77245ULL, 0x000fe4000020d400ULL,
0x00000018ffbe7819ULL, 0x000fe40000011431ULL, 0x000000ab00ba7306ULL, 0x000e620000205400ULL,
0x000000b200a47245ULL, 0x000fe4000020d400ULL, 0x00000001a7a73812ULL, 0x000fe400078efcffULL,
0x00000001a4a42812ULL, 0x000fe400078efcffULL, 0x000000015e5e1812ULL, 0x008fe200078efcffULL,
0x000000bb00bc7306ULL, 0x000ff00000209400ULL, 0x000000bb00bd7306ULL, 0x000ea20000205400ULL,
0x000000bab900720bULL, 0x002fce0003fdd000ULL, 0x000000be00bf7306ULL, 0x000ff00000209400ULL,
0x000000be00c07306ULL, 0x000e620000205400ULL, 0x000000bdbc00720bULL, 0x004fce0003fbd000ULL,
0x0000003200a57306ULL, 0x000ff00000009400ULL, 0x0000003200a67306ULL, 0x000ea20000005400ULL,
0x000000c0bf00720bULL, 0x002fce0003f7d000ULL, 0x000000a300ad7306ULL, 0x000ff00000209400ULL,
0x000000a300ac7306ULL, 0x000e620000205400ULL, 0x000000a6a500720bULL, 0x004fe40003f5d000ULL,
0x000000ab00a67245ULL, 0x000fc4000020d400ULL, 0x000000bb00a57245ULL, 0x000fe4000020d400ULL,
0x00000001a6a66812ULL, 0x000fe200078efcffULL, 0x0000003300a17306ULL, 0x000fe20000009400ULL,
0x00000001a5a55812ULL, 0x000fc800078efcffULL, 0x0000005ea55e723eULL, 0x000fc600000010ffULL,
0x0000003300a27306ULL, 0x000ea20000005400ULL, 0x000000acad00720bULL, 0x002fe20003f9d000ULL,
0x0001000026ac7824ULL, 0x000fca00078e00ffULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x0000002c009d7306ULL, 0x000ff00000009400ULL, 0x0000002c00a07306ULL, 0x000e620000005400ULL,
0x000000a2a100720bULL, 0x004fc40003fdd000ULL, 0x000000be00a17245ULL, 0x000fe4000020d400ULL,
0x0000009300a27245ULL, 0x000fe4000020d400ULL, 0x00000001a1a13812ULL, 0x000fe200078efcffULL,
0x000000c100c27306ULL, 0x000ff00000209400ULL, 0x000000c100c37306ULL, 0x000ea20000205400ULL,
0x000000a09d00720bULL, 0x002fe20003f3d000ULL, 0x00000100269d7824ULL, 0x000fe200078e00ffULL,
0x000000a300a07245ULL, 0x000fe2000020d400ULL, 0x0001000027a37824ULL, 0x000fc600078e00ffULL,
0x00000001a0a04812ULL, 0x000fe200078efcffULL, 0x000000af00c47306ULL, 0x000fe20000209400ULL,
0x00000018ffa37819ULL, 0x000fce00000114a3ULL, 0x000000af00c57306ULL, 0x000e620000205400ULL,
0x000000c3c200720bULL, 0x004fce0003fbd000ULL, 0x00000093009f7306ULL, 0x000ff00000209400ULL,
0x00000093009e7306ULL, 0x000ea20000205400ULL, 0x000000c5c400720bULL, 0x002fce0003f7d000ULL,
0x00000024008d7306ULL, 0x000ff00000009400ULL, 0x0000002400947306ULL, 0x000fe20000005400ULL,
0x0000009e9f00720bULL, 0x004fe40003f9d000ULL, 0x000000c1009e7245ULL, 0x000fc4000020d400ULL,
0x00000018ff9f7819ULL, 0x000fe4000001149dULL, 0x000000af009d7245ULL, 0x000fe2000020d400ULL,
0x0000002400567306ULL, 0x0003e2000000d400ULL, 0x000000019e9e5812ULL, 0x000fe400078efcffULL,
0x000000019d9d3812ULL, 0x000fe400078efcffULL, 0x0000008800af7245ULL, 0x000fe4000020d400ULL,
0x00000001a2a24812ULL, 0x000fe200078efcffULL, 0x00000032005b7306ULL, 0x0004e2000000d400ULL,
0x0000010024247824ULL, 0x002fca00078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe20000011424ULL,
0x0001000025247824ULL, 0x000fe200078e00ffULL, 0x0000008800957306ULL, 0x000fe20000209400ULL,
0x000001002f327824ULL, 0x004fc600078e00ffULL, 0x00000018ffce7819ULL, 0x000fe40000011424ULL,
0x000000493c247211ULL, 0x000fe400078fe0ffULL, 0x0000008800927306ULL, 0x000e620000205400ULL,
0x000000015b5b2812ULL, 0x008fe400078efcffULL, 0x0000000224747810ULL, 0x040fe40007ffe0ffULL,
0x0000000724247812ULL, 0x100fe400078e78cfULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x000000ae00c67306ULL, 0x000fe20000209400ULL, 0x0000000774747812ULL, 0x000fe200078e78cfULL,
0x00000010cf247824ULL, 0x000fe200078e0224ULL, 0x0000000449497810ULL, 0x000fc60007ffe0ffULL,
0x0000001024247824ULL, 0x000fe400078e00ffULL, 0x000000ae00c77306ULL, 0x0004e20000205400ULL,
0x000000929500720bULL, 0x002fe20003f5d000ULL, 0x00000010cf747824ULL, 0x000fcc00078e0274ULL,
0x000000aa00b17306ULL, 0x000fe20000209400ULL, 0x000000ae00ae7245ULL, 0x004fca000020d400ULL,
0x00000001afaf2812ULL, 0x000fe400078efcffULL, 0x000000aa00b07306ULL, 0x0002a20000205400ULL,
0x000000c7c600720bULL, 0x008fce0003fbd000ULL, 0x000000c800c97306ULL, 0x000fe20000209400ULL,
0x000000aa00aa7245ULL, 0x002fca000020d400ULL, 0x00000001aeae5812ULL, 0x000fe400078efcffULL,
0x000000c800ca7306ULL, 0x000e620000205400ULL, 0x000000b0b100720bULL, 0x004fe40003f7d000ULL,
0x000000948d00720bULL, 0x000fe40003fbd000ULL, 0x000000c8008d7245ULL, 0x000fc6000020d400ULL,
0x0000003300577306ULL, 0x0004ec000000d400ULL, 0x00000001aaaa3812ULL, 0x000fe400078efcffULL,
0x0000009c00a97306ULL, 0x000fe20000209400ULL, 0x000000cac900720bULL, 0x002fe20003f9d000ULL,
0x000100002f337824ULL, 0x004fe200078e00ffULL, 0x0000000156565812ULL, 0x000fc400078efcffULL,
0x000000aaafaf723eULL, 0x000fe400000010ffULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0000009c00a87306ULL, 0x0002a20000205400ULL, 0x0000000157576812ULL, 0x008fc800078efcffULL,
0x00000057aeae723eULL, 0x000fe400000010ffULL, 0x000000018d8d4812ULL, 0x000fe200078efcffULL,
0x000000ce00b37306ULL, 0x000fe20000209400ULL, 0x0000009c009c7245ULL, 0x002fe4000020d400ULL,
0x000000568d56723eULL, 0x000fca00000010ffULL, 0x000000ce00b47306ULL, 0x000e620000205400ULL,
0x000000a8a900720bULL, 0x004fce0003fdd000ULL, 0x000000cb00cc7306ULL, 0x000fec0000209400ULL,
0x000000019c9c6812ULL, 0x000fe400078efcffULL, 0x000000cb00cd7306ULL, 0x0004e20000205400ULL,
0x000000b4b300720bULL, 0x002fce0003f5d000ULL, 0x00000025008e7306ULL, 0x000fe20000009400ULL,
0x000000cb00cb7245ULL, 0x004fce000020d400ULL, 0x0000002500897306ULL, 0x000e620000005400ULL,
0x000000cdcc00720bULL, 0x008fce0003f7d000ULL, 0x00000099009a7306ULL, 0x000fec0000209400ULL,
0x00000001cbcb3812ULL, 0x000fe400078efcffULL, 0x00000099009b7306ULL, 0x0004e20000205400ULL,
0x000000898e00720bULL, 0x002fe40003f9d000ULL, 0x000000ce008e7245ULL, 0x000fc4000020d400ULL,
0x000000cb9c57723eULL, 0x000fe400000010ffULL, 0x000000018e8e2812ULL, 0x000fe200078efcffULL,
0x0000002600857306ULL, 0x000fe20000009400ULL, 0x0000009900997245ULL, 0x004fce000020d400ULL,
0x0000002600867306ULL, 0x000e620000005400ULL, 0x0000009b9a00720bULL, 0x008fce0003fdd000ULL,
0x00000026004f7306ULL, 0x000eac000000d400ULL, 0x0000000199996812ULL, 0x000fe400078efcffULL,
0x000000ac00ad7306ULL, 0x000fe20000209400ULL, 0x000000868500720bULL, 0x002fe40003f7d000ULL,
0x00000018ff857819ULL, 0x010fca000001142aULL, 0x000000ac00267306ULL, 0x000e6c0000205400ULL,
0x000000014f4f3812ULL, 0x004fe400078efcffULL, 0x0000002500557306ULL, 0x0004f0000000d400ULL,
0x0000002700797306ULL, 0x000fe20000009400ULL, 0x0000010025257824ULL, 0x004fe200078e00ffULL,
0x00000026ad00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000027007a7306ULL, 0x000fe20000005400ULL, 0x0000000155554812ULL, 0x008fe400078efcffULL,
0x0000002500887245ULL, 0x000fe4000020d400ULL, 0x000000558e8e723eULL, 0x000fc600000010ffULL,
0x00000027004e7306ULL, 0x000ff0000000d400ULL, 0x0000009f00277306ULL, 0x000ff00000209400ULL,
0x0000009f00927306ULL, 0x000e700000205400ULL, 0x000000a300937306ULL, 0x000ff00000209400ULL,
0x000000a300947306ULL, 0x0004e20000205400ULL, 0x000000922700720bULL, 0x002fc40003f9d000ULL,
0x000000ac00927245ULL, 0x000fc8000020d400ULL, 0x0000000192922812ULL, 0x000fe200078efcffULL,
0x0000002500b27306ULL, 0x000fe20000209400ULL, 0x0000007a7900720bULL, 0x000fe40003f5d000ULL,
0x000000a300a37245ULL, 0x004fe4000020d400ULL, 0x0000009f007a7245ULL, 0x000fe4000020d400ULL,
0x0000004f9292723eULL, 0x000fe200000010ffULL, 0x0000002500ab7306ULL, 0x000e620000205400ULL,
0x000000949300720bULL, 0x008fc40003fdd000ULL, 0x000000017a7a4812ULL, 0x000fe400078efcffULL,
0x0000009600937245ULL, 0x000fe4000020d400ULL, 0x000000014e4e2812ULL, 0x000fe200078efcffULL,
0x000000b500897306ULL, 0x000fec0000209400ULL, 0x00000001a3a36812ULL, 0x000fc400078efcffULL,
0x000000b500267306ULL, 0x0004e20000205400ULL, 0x000000abb200720bULL, 0x002fe40003fbd000ULL,
0x0000004ea34e723eULL, 0x000fca00000010ffULL, 0x0000008700907306ULL, 0x000fe20000209400ULL,
0x000000b500b57245ULL, 0x004fca000020d400ULL, 0x0000000188885812ULL, 0x000fe400078efcffULL,
0x0000008700917306ULL, 0x000e620000205400ULL, 0x000000268900720bULL, 0x008fe20003f7d000ULL,
0x0001000028897824ULL, 0x000fe200078e00ffULL, 0x000000002424783bULL, 0x000ea80000000200ULL,
0x00000018ff897819ULL, 0x000fe20000011489ULL, 0x0000007b008c7306ULL, 0x000fec0000209400ULL,
0x00000001b5b53812ULL, 0x000fc400078efcffULL, 0x0000007b008f7306ULL, 0x000ee20000205400ULL,
0x000000919000720bULL, 0x002fce0003fdd000ULL, 0x0000002c004d7306ULL, 0x000330000000d400ULL,
0x0000009600987306ULL, 0x000fe20000209400ULL, 0x0000008f8c00720bULL, 0x008fe40003f5d000ULL,
0x00000018ff2c7819ULL, 0x002fc40000011428ULL, 0x00000088998f723eULL, 0x000fc600000010ffULL,
0x0000009600977306ULL, 0x000e620000205400ULL, 0x000000014d4d1812ULL, 0x010fe200078efcffULL,
0x000000ae2414723cULL, 0x044fec0000041814ULL, 0x0000007e007f7306ULL, 0x000fe40000209400ULL,
0x000000562410723cULL, 0x040fec0000041810ULL, 0x0000007e00827306ULL, 0x000ea20000205400ULL,
0x000000979800720bULL, 0x002fe20003fbd000ULL, 0x0000008e240c723cULL, 0x000fec000004180cULL,
0x0000002d00737306ULL, 0x000fec0000009400ULL, 0x0000000193935812ULL, 0x000fc400078efcffULL,
0x0000002d00767306ULL, 0x000e620000005400ULL, 0x000000827f00720bULL, 0x004fe20003f3d000ULL,
0x00000100297f7824ULL, 0x000fe200078e00ffULL, 0x0000007a9393723eULL, 0x000fe200000010ffULL,
0x000001002a827824ULL, 0x000fc600078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x00000080008b7306ULL, 0x000fe20000209400ULL, 0x00000018ff827819ULL, 0x000fe20000011482ULL,
0x000000922408723cULL, 0x000fec0000041808ULL, 0x00000080008a7306ULL, 0x000ea20000205400ULL,
0x000000767300720bULL, 0x002fc40003f9d000ULL, 0x0000008700767245ULL, 0x000fe4000020d400ULL,
0x00000018ff737819ULL, 0x000fe4000001142bULL, 0x0000000176766812ULL, 0x000fe200078efcffULL,
0x0000002f00627306ULL, 0x000fe60000009400ULL, 0x000000b5764f723eULL, 0x000fca00000010ffULL,
0x0000002f00637306ULL, 0x000e620000005400ULL, 0x0000008a8b00720bULL, 0x004fe20003f7d000ULL,
0x0000004e2404723cULL, 0x000fe20000041804ULL, 0x0000007b008a7245ULL, 0x000fe4000020d400ULL,
0x00000080008b7245ULL, 0x000fe2000020d400ULL, 0x000100002a807824ULL, 0x000fe200078e00ffULL,
0x000000018a8a2812ULL, 0x000fe200078efcffULL, 0x0000006600677306ULL, 0x000fe60000209400ULL,
0x00000018ff807819ULL, 0x000fc40000011480ULL, 0x0000004d8a8a723eULL, 0x000fe400000010ffULL,
0x000000018b8b3812ULL, 0x000fe200078efcffULL, 0x00000066006a7306ULL, 0x0004e20000205400ULL,
0x000000636200720bULL, 0x002fe20003fdd000ULL, 0x0001000029627824ULL, 0x000fe200078e00ffULL,
0x0000007e00637245ULL, 0x000fc8000020d400ULL, 0x0000000163631812ULL, 0x000fe200078efcffULL,
0x0000002e00727306ULL, 0x000fe20000009400ULL, 0x0000006600667245ULL, 0x004fce000020d400ULL,
0x0000002e00717306ULL, 0x000e620000005400ULL, 0x0000006a6700720bULL, 0x008fce0003f5d000ULL,
0x0000005a006c7306ULL, 0x000fec0000209400ULL, 0x0000000166662812ULL, 0x000fe400078efcffULL,
0x0000005a00697306ULL, 0x0004e20000205400ULL, 0x000000717200720bULL, 0x002fe40003fbd000ULL,
0x0000008b668b723eULL, 0x000fca00000010ffULL, 0x0000008100837306ULL, 0x000fe20000209400ULL,
0x0000005a005a7245ULL, 0x004fce000020d400ULL, 0x0000008100847306ULL, 0x0002a20000205400ULL,
0x000000696c00720bULL, 0x008fce0003f3d000ULL, 0x0000006400687306ULL, 0x000fe20000209400ULL,
0x0000008100817245ULL, 0x002fca000020d400ULL, 0x000000015a5a1812ULL, 0x000fe400078efcffULL,
0x0000006400657306ULL, 0x0002e20000205400ULL, 0x000000848300720bULL, 0x004fe20003f7d000ULL,
0x000100002b837824ULL, 0x040fe400078e00ffULL, 0x000001002b847824ULL, 0x000fc600078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011483ULL, 0x0000002e004b7306ULL, 0x000ea2000000d400ULL,
0x0000006400647245ULL, 0x002fe4000020d400ULL, 0x00000018ff847819ULL, 0x000fc60000011484ULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x00000033006f7306ULL, 0x000fe20000209400ULL,
0x000000656800720bULL, 0x008fe40003f5d000ULL, 0x00000018ff687819ULL, 0x000fe40000011462ULL,
0x0000007500627245ULL, 0x000fc6000020d400ULL, 0x0000003300707306ULL, 0x0002e20000205400ULL,
0x000000014b4b5812ULL, 0x004fca00078efcffULL, 0x0000000164642812ULL, 0x000fe400078efcffULL,
0x0000003200607306ULL, 0x000fe20000209400ULL, 0x0000003300337245ULL, 0x002fe4000020d400ULL,
0x00000081644d723eULL, 0x000fca00000010ffULL, 0x0000003200617306ULL, 0x0002a20000205400ULL,
0x000000706f00720bULL, 0x008fce0003fbd000ULL, 0x00000028005d7306ULL, 0x000fe20000009400ULL,
0x0000003200327245ULL, 0x002fca000020d400ULL, 0x0000000133335812ULL, 0x000fe400078efcffULL,
0x00000028005c7306ULL, 0x000fe20000005400ULL, 0x000000616000720bULL, 0x004fce0003f3d000ULL,
0x00000028004a7306ULL, 0x0003ec000000d400ULL, 0x0000000132321812ULL, 0x000fe400078efcffULL,
0x0000002d004c7306ULL, 0x0004e2000000d400ULL, 0x0000010028287824ULL, 0x002fca00078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011428ULL, 0x00000050006b7306ULL, 0x000fe20000209400ULL,
0x00000018ff2d7819ULL, 0x004fe40000011429ULL, 0x0000005fa428723eULL, 0x000fe400000010ffULL,
0x000000a1a05f723eULL, 0x000fc600000010ffULL, 0x00000050006e7306ULL, 0x000e620000205400ULL,
0x000000014c4c4812ULL, 0x008fc600078efcffULL, 0x0000005e241c723cULL, 0x000fe2000004181cULL,
0x0000004c634c723eULL, 0x000fc600000010ffULL, 0x00000075007c7306ULL, 0x000ff00000209400ULL,
0x00000075007d7306ULL, 0x000ea20000205400ULL, 0x0000006e6b00720bULL, 0x002fce0003f9d000ULL,
0x0000002900597306ULL, 0x000ff00000009400ULL, 0x0000002900587306ULL, 0x000fe20000005400ULL,
0x0000007d7c00720bULL, 0x004fce0003f7d000ULL, 0x0000002900487306ULL, 0x0003ec000000d400ULL,
0x0000000162623812ULL, 0x000fe400078efcffULL, 0x0000006d00777306ULL, 0x000fe20000209400ULL,
0x000000a7a629723eULL, 0x002fe400000010ffULL, 0x0000005c5d00720bULL, 0x000fc40003f7d000ULL,
0x0000004b6262723eULL, 0x000fc600000010ffULL, 0x0000006d00787306ULL, 0x0002a20000205400ULL,
0x000000282420723cULL, 0x000fee0000041820ULL, 0x0000002a00527306ULL, 0x000fe20000009400ULL,
0x0000005b9e28723eULL, 0x000fe400000010ffULL, 0x0000009da229723eULL, 0x000fc400000010ffULL,
0x0000006d006d7245ULL, 0x002fe4000020d400ULL, 0x000000014a4a3812ULL, 0x000fe200078efcffULL,
0x0000002a00517306ULL, 0x000e620000005400ULL, 0x000000787700720bULL, 0x004fe20003f5d000ULL,
0x000000282418723cULL, 0x000fec0000041818ULL, 0x00000089007b7306ULL, 0x000fe20000209400ULL,
0x0000001074287824ULL, 0x000fe200078e00ffULL, 0x0000006800277245ULL, 0x000fc4000020d400ULL,
0x0000002d00267245ULL, 0x000fe4000020d400ULL, 0x000000016d6d2812ULL, 0x000fe400078efcffULL,
0x00000089006a7306ULL, 0x0004e20000205400ULL, 0x000000515200720bULL, 0x002fe40003fbd000ULL,
0x0000005000517245ULL, 0x000fe4000020d400ULL, 0x000000585900720bULL, 0x000fe40003f5d000ULL,
0x0000000151514812ULL, 0x000fe200078efcffULL, 0x00000067007e7306ULL, 0x000fe20000209400ULL,
0x0000008900897245ULL, 0x004fc4000020d400ULL, 0x000000325125723eULL, 0x000fe400000010ffULL,
0x0000006d5a63723eULL, 0x000fc600000010ffULL, 0x0000006700657306ULL, 0x0002a20000205400ULL,
0x0000006a7b00720bULL, 0x008fe40003f3d000ULL, 0x0000000148482812ULL, 0x000fca00078efcffULL,
0x0000002c00307306ULL, 0x000fe20000209400ULL, 0x0000006700677245ULL, 0x002fca000020d400ULL,
0x0000000189891812ULL, 0x000fe400078efcffULL, 0x0000002c00317306ULL, 0x0002e20000205400ULL,
0x000000657e00720bULL, 0x004fe40003f9d000ULL, 0x0000004a894a723eULL, 0x000fca00000010ffULL,
0x0000002f00427306ULL, 0x000ea2000000d400ULL, 0x0000002c002c7245ULL, 0x002fca000020d400ULL,
0x0000000167674812ULL, 0x000fe400078efcffULL, 0x0000002a00447306ULL, 0x000e62000000d400ULL,
0x000000313000720bULL, 0x008fce0003f3d000ULL, 0x0000002b00547306ULL, 0x000fe20000009400ULL,
0x0000000142426812ULL, 0x004fc800078efcffULL, 0x000000423324723eULL, 0x000fe400000010ffULL,
0x000000012c2c1812ULL, 0x000fe200078efcffULL, 0x0000002b00537306ULL, 0x000ea20000005400ULL,
0x0000000144445812ULL, 0x002fe400078efcffULL, 0x000000672c4b723eULL, 0x000fe400000010ffULL,
0x00000085002c7245ULL, 0x000fc6000020d400ULL, 0x0000002b00467306ULL, 0x0002f0000000d400ULL,
0x0000002d002e7306ULL, 0x000fe20000209400ULL, 0x000000002828783bULL, 0x002e620000000200ULL,
0x000000535400720bULL, 0x004fcc0003fdd000ULL, 0x0000002d002f7306ULL, 0x00052e0000205400ULL,
0x0000000146466812ULL, 0x008fe200078efcffULL, 0x0000006800697306ULL, 0x000fe20000209400ULL,
0x00000080002d7245ULL, 0x004fce000020d400ULL, 0x00000068006c7306ULL, 0x000ea20000205400ULL,
0x0000002f2e00720bULL, 0x010fce0003f9d000ULL, 0x0000007f005b7306ULL, 0x000fec0000209400ULL,
0x0000000126264812ULL, 0x000fe400078efcffULL, 0x0000007f00587306ULL, 0x0007220000205400ULL,
0x0000006c6900720bULL, 0x004fe20003f7d000ULL, 0x000000242814723cULL, 0x042fec0000041814ULL,
0x0000008000597306ULL, 0x000fe20000209400ULL, 0x0000007f007f7245ULL, 0x008fe2000020d400ULL,
0x0000008a2820723cULL, 0x000fe80000041820ULL, 0x0000000127273812ULL, 0x000fc400078efcffULL,
0x0000008000527306ULL, 0x000e620000205400ULL, 0x000000585b00720bULL, 0x010fe20003f3d000ULL,
0x0000004c281c723cULL, 0x000fe2000004181cULL, 0x000000482724723eULL, 0x000fe400000010ffULL,
0x0000008200277245ULL, 0x000fc6000020d400ULL, 0x0000008500867306ULL, 0x000fe40000209400ULL,
0x000000622818723cULL, 0x040fe80000041818ULL, 0x000000017f7f1812ULL, 0x000fe400078efcffULL,
0x0000008500797306ULL, 0x000ea20000205400ULL, 0x000000525900720bULL, 0x002fe20003f5d000ULL,
0x0000004a2810723cULL, 0x000fe20000041810ULL, 0x0000007f2625723eULL, 0x000fca00000010ffULL,
0x0000008200507306ULL, 0x000fe40000209400ULL, 0x00000024280c723cULL, 0x000fe8000004180cULL,
0x000000012d2d2812ULL, 0x000fe400078efcffULL, 0x0000008200537306ULL, 0x000e620000205400ULL,
0x000000798600720bULL, 0x004fe40003f7d000ULL, 0x0000008400257245ULL, 0x000fc4000020d400ULL,
0x000000442d26723eULL, 0x000fc600000010ffULL, 0x0000007300717306ULL, 0x000fec0000209400ULL,
0x000000012c2c3812ULL, 0x000fe400078efcffULL, 0x0000007300727306ULL, 0x000ea20000205400ULL,
0x000000535000720bULL, 0x002fce0003f9d000ULL, 0x0000008300307306ULL, 0x000fec0000209400ULL,
0x0000000127274812ULL, 0x000fe400078efcffULL, 0x00000083002f7306ULL, 0x0002e20000205400ULL,
0x000000727100720bULL, 0x004fe40003f3d000ULL, 0x000000272c27723eULL, 0x000fc400000010ffULL,
0x00000073002c7245ULL, 0x000fc6000020d400ULL, 0x00000084002e7306ULL, 0x000fe20000209400ULL,
0x0000008300837245ULL, 0x002fe2000020d400ULL, 0x000000262808723cULL, 0x000fe80000041808ULL,
0x000000012c2c1812ULL, 0x000fe400078efcffULL, 0x0000008400317306ULL, 0x000e620000205400ULL,
0x0000002f3000720bULL, 0x008fe40003f5d000ULL, 0x000000044700780cULL, 0x000fd60003f25270ULL,
0x0000000183832812ULL, 0x000fe400078efcffULL, 0x000000312e00720bULL, 0x002fe40003fbd000ULL,
0x000000468324723eULL, 0x000fd600000010ffULL, 0x0000000125255812ULL, 0x000fc800078efcffULL,
0x000000252c25723eULL, 0x000fce00000010ffULL, 0x000000242804723cULL, 0x000fe20000041804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe12000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff457224ULL, 0x000fe200078e003fULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd3e000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00f6140040257984ULL, 0x000e620000000800ULL,
0x0000ffff3d007812ULL, 0x000fe200078ec0ffULL, 0x0000001d3a1d7220ULL, 0x040fe20000410000ULL,
0x0000001a3a247220ULL, 0x040fe20000410000ULL, 0x000000143a147220ULL, 0x000fe20000410000ULL,
0x00008880002f7816ULL, 0x000fe200000000ffULL, 0x0000001e3a1e7220ULL, 0x040fe20000410000ULL,
0x0000001b3a267220ULL, 0x040fe20000410000ULL, 0x000000153a157220ULL, 0x040fe20000410000ULL,
0x0000000c3a1a7220ULL, 0x040fe20000410000ULL, 0x000000203a207220ULL, 0x040fe20000410000ULL,
0x000000213a217220ULL, 0x040fe20000410000ULL, 0x000000223a227220ULL, 0x040fe20000410000ULL,
0x0000001f3a1f7220ULL, 0x040fe20000410000ULL, 0x000000163a277220ULL, 0x040fe20000410000ULL,
0x000000173a287220ULL, 0x040fe20000410000ULL, 0x0000000d3a1b7220ULL, 0x040fe20000410000ULL,
0x800000002f007824ULL, 0x000fe200078e00ffULL, 0x000000233a237220ULL, 0x040fe20000410000ULL,
0x000000183a187220ULL, 0x040fe20000410000ULL, 0x000000193a197220ULL, 0x040fe20000410000ULL,
0x000000103a167220ULL, 0x040fe20000410000ULL, 0x000000113a177220ULL, 0x040fe20000410000ULL,
0x0000001c3a1c7220ULL, 0x040fe20000410000ULL, 0x000000123a297220ULL, 0x040fe20000410000ULL,
0x000000133a2a7220ULL, 0x040fe20000410000ULL, 0x0000000e3a2b7220ULL, 0x040fe20000410000ULL,
0x0000000f3a2c7220ULL, 0x040fe20000410000ULL, 0x000000083a087220ULL, 0x040fe20000410000ULL,
0x000000093a097220ULL, 0x040fe20000410000ULL, 0x0000000a3a2d7220ULL, 0x040fe20000410000ULL,
0x0000000b3a2e7220ULL, 0x040fe20000410000ULL, 0x000000043a047220ULL, 0x040fe20000410000ULL,
0x000000053a057220ULL, 0x040fe20000410000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e001dULL,
0x000000063a067220ULL, 0x040fe20000410000ULL, 0x000000ffff107224ULL, 0x000fe200078e0014ULL,
0x000000073a077220ULL, 0x000fe20000410000ULL, 0x000000ffff117224ULL, 0x000fc400078e0015ULL,
0x000000ffff147224ULL, 0x000fe200078e001aULL, 0x8000000025ff7812ULL, 0x002fe20007804800ULL,
0x000000ffff1d7224ULL, 0x000fe400078e001eULL, 0x000000ffff0b7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0021ULL, 0x000000ffff157224ULL, 0x000fe400078e001bULL,
0x000000ffff1a7224ULL, 0x000fc400078e0022ULL, 0x000000ffff1e7224ULL, 0x000fe400078e001fULL,
0x000000ffff0e7224ULL, 0x000fe400078e0018ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0019ULL,
0x000000ffff127224ULL, 0x000fe400078e0016ULL, 0x000000ffff137224ULL, 0x000fe400078e0017ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0023ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0024ULL,
0x000000ffff207224ULL, 0x000fe400078e0026ULL, 0x000000ffff217224ULL, 0x000fe400078e0027ULL,
0x000000ffff227224ULL, 0x000fe400078e0028ULL, 0x000000ffff0c7224ULL, 0x000fe400078e001cULL,
0x000000ffff167224ULL, 0x000fc400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e0009ULL,
0x000000ffff187224ULL, 0x000fe400078e0004ULL, 0x000000ffff197224ULL, 0x000fe400078e0005ULL,
0x000000ffff237224ULL, 0x000fe400078e0029ULL, 0x000000ffff247224ULL, 0x000fe400078e002aULL,
0x000000ffff257224ULL, 0x000fc400078e002bULL, 0x000000ffff267224ULL, 0x000fe400078e002cULL,
0x000000ffff277224ULL, 0x000fe400078e002dULL, 0x000000ffff287224ULL, 0x000fe200078e002eULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe400078e0006ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0007ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000002f2f7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x00f6140040047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fc4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000043c1c7824ULL, 0x000fe200078e00ffULL,
0x000000413600720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff01c057812ULL, 0x000fca00078ec0ffULL, 0x0000008034007824ULL, 0x000fca00078e0205ULL,
0x00f4000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000023c087824ULL, 0x000fe400078e00ffULL, 0x00000001353e7824ULL, 0x000fc600078e0a3eULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x00000001092b7812ULL, 0x040fe400078efcffULL,
0x00000008092d7812ULL, 0x000fe400078efcffULL, 0x0000003e2b00720cULL, 0x080fe40003f26070ULL,
0x00000010092b7812ULL, 0x000fe400078efcffULL, 0x0000003e2d00720cULL, 0x080fe40003f06070ULL,
0x0000003e2b00720cULL, 0x000fc40003fc6070ULL, 0x00000011092d7812ULL, 0x040fe400078efcffULL,
0x00000018092b7812ULL, 0x040fe400078efcffULL, 0x0000003e0900720cULL, 0x080fe40003f46070ULL,
0x0000003e2d00720cULL, 0x080fe40003fa6070ULL, 0x0000003e2b00720cULL, 0x000fe40003f66070ULL,
0x00000009092f7812ULL, 0x000fc400078efcffULL, 0x00000019092d7812ULL, 0x040fe400078efcffULL,
0x00000020092b7812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x0000003e2f00720cULL, 0x080fe40003f86070ULL,
0x0000003e2d00720cULL, 0x080fe40003f46070ULL, 0x0000003e2b00720cULL, 0x000fe40003f26070ULL,
0x00000021092d7812ULL, 0x040fe400078efcffULL, 0x00000028092b7812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x0000003e2d00720cULL, 0x080fe40003f06070ULL, 0x0000003e2b00720cULL, 0x000fe40003f86070ULL,
0x00000029092d7812ULL, 0x000fc400078efcffULL, 0x00000030092b7812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x0000003e2d00720cULL, 0x000fc40003fc6070ULL, 0x0000003e2b00720cULL, 0x000fe40003fa6070ULL,
0x00000031092d7812ULL, 0x040fe400078efcffULL, 0x00000038092b7812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x0000003e2d00720cULL, 0x080fe40003f66070ULL,
0x0000003e2b00720cULL, 0x000fc40003f46070ULL, 0x0000003e0900720cULL, 0x000fe40003f26070ULL,
0xff7fffff24247808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff25257808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff26267808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff27277808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff28287808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff29297808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000b04097209ULL, 0x004fe20007810000ULL,
0x0000001fff317424ULL, 0x000fe200078e00ffULL, 0x0000001a05047209ULL, 0x000fe20007810000ULL,
0xffffffffff327424ULL, 0x000fe200078e00ffULL, 0x0000000a09097209ULL, 0x000fe40007810000ULL,
0x0000001b04047209ULL, 0x000fc40007810000ULL, 0x0000000c09087209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x0000000d08097209ULL, 0x000fe40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x0000000e09087209ULL, 0x000fe40007810000ULL,
0x0000001f04057209ULL, 0x000fc40007810000ULL, 0x0000000f08097209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x0000001009087209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x0000001108097209ULL, 0x000fe40007810000ULL,
0x0000002205047209ULL, 0x000fc40007810000ULL, 0x0000001209087209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fe40007810000ULL, 0x0000001308097209ULL, 0x000fe40007810000ULL,
0x0000002405047209ULL, 0x000fe40007810000ULL, 0x0000001409087209ULL, 0x000fe40007810000ULL,
0x0000002504057209ULL, 0x000fc40007810000ULL, 0x0000001508097209ULL, 0x000fe40007810000ULL,
0x0000002605047209ULL, 0x000fe40007810000ULL, 0x0000001609087209ULL, 0x000fe40007810000ULL,
0x0000002704057209ULL, 0x000fe40007810000ULL, 0x0000001708097209ULL, 0x000fe40007810000ULL,
0x0000002805047209ULL, 0x000fc40007810000ULL, 0x0000001809087209ULL, 0x000fe40007810000ULL,
0x0000002904057209ULL, 0x000fe40007810000ULL, 0x00000019082d7209ULL, 0x000fe40007810000ULL,
0x0000002a052f7209ULL, 0x000fe20007810000ULL, 0x00000ea27f007947ULL, 0x000fea000b800000ULL,
0x0c401f002d047f89ULL, 0x0004e400000e0000ULL, 0x000000042d2d7209ULL, 0x00cfe20007810000ULL,
0x00000ed27f007947ULL, 0x000fea000b800000ULL, 0x0c401f002f047f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006057f89ULL, 0x000ee800000e0000ULL, 0x0c401f00072c7f89ULL, 0x000f2200000e0000ULL,
0x000000042f087209ULL, 0x004fc60007810000ULL, 0x0c201f002d047f89ULL, 0x000ea200000e0000ULL,
0x0000000506097209ULL, 0x008fc60007810000ULL, 0x0c201f0008057f89ULL, 0x000ee200000e0000ULL,
0x0000002c072c7209ULL, 0x010fc60007810000ULL, 0x0c201f00092e7f89ULL, 0x002e6800000e0000ULL,
0x0c201f002c2b7f89ULL, 0x00092200000e0000ULL, 0x000000042d047209ULL, 0x004fe40007810000ULL,
0x0000000508057209ULL, 0x008fe40007810000ULL, 0x0000002e09067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000057882ULL, 0x000fc40000000000ULL,
0x00000005ff2e7e24ULL, 0x002fe2000f8e00ffULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x3f8000002e2e783eULL, 0x000fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL, 0x000000ffff2f7224ULL, 0x000fe200078e002eULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010819ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2a197823ULL, 0x000fe20000010819ULL,
0x0000000000067886ULL, 0x000fc400038e0100ULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x000000080908723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000ff00000000800ULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000000c0d0a723eULL, 0x008fce00000010ffULL,
0x0000001d000b7308ULL, 0x0007f00000000800ULL, 0x0000001e001e7308ULL, 0x000f220000000800ULL,
0x0000001a1b09723eULL, 0x002fe200000010ffULL, 0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b1e0b723eULL, 0x010fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x0000002e0830723cULL, 0x000fee00000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ee20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x008fce00000010ffULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ee20000000800ULL,
0x0000001f200d723eULL, 0x002fce00000010ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000021220f723eULL, 0x008fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000002e0c30723cULL, 0x000fee0000041830ULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002400247308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fe400000010ffULL, 0xfffffffc3c147812ULL, 0x000fc800078ec0ffULL,
0x000000141d1d7219ULL, 0x000fe200000006ffULL, 0x0000002500257308ULL, 0x000fe60000000800ULL,
0x000000001d1e73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0573c4ULL, 0x000f280000004000ULL,
0x0000002600267308ULL, 0x000ea20000000800ULL, 0x000000232411723eULL, 0x002fce00000010ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000252613723eULL, 0x004fce00000010ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000061dff7c12ULL, 0x008fe2000f80401eULL,
0x0000002e1030723cULL, 0x000fec0000041830ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000000700077308ULL, 0x000ea20000000800ULL, 0x000000161714723eULL, 0x002fce00000010ffULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x000000180716723eULL, 0x004fe400000010ffULL, 0x0000002c2b077209ULL, 0x000fca0007810000ULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x00000019001a7308ULL, 0x000ea20000000800ULL,
0x000000272815723eULL, 0x002fe400000010ffULL, 0x000000291a17723eULL, 0x004fce00000010ffULL,
0x0000002e1420723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x000009e205008947ULL, 0x010fde000b800000ULL, 0x001c1fff20187589ULL, 0x0002a400000e0000ULL,
0x000000001d1a73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0573c4ULL, 0x000f220000004000ULL,
0x0000000000067886ULL, 0x000fe400038e0100ULL, 0x000000061dff7c12ULL, 0x008fda000f80401aULL,
0x00000a0205008947ULL, 0x010fea000b800000ULL, 0x001c1fff22197589ULL, 0x00072800000e0000ULL,
0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL, 0x001c1fff001b7589ULL, 0x0006a400000e0000ULL,
0x00000002ff1d7819ULL, 0x00afe4000001163cULL, 0x0000000c1c337812ULL, 0x000fc400078ec0ffULL,
0x000000071d1e7812ULL, 0x040fe200078ec0ffULL, 0x000000081d237824ULL, 0x040fe200078e00ffULL,
0x0000001dff217212ULL, 0x000fe200078e33ffULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0x000000033cff7812ULL, 0x000fe2000780c0ffULL, 0x000000081d2e7824ULL, 0x040fe200078e00ffULL,
0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823207812ULL, 0x100fe400078ee21eULL,
0x000000011f227812ULL, 0x100fe200078ef61eULL, 0x000000081d4a7824ULL, 0x000fe200078e00ffULL,
0x000000021f247812ULL, 0x100fe200078ef61eULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0x000000031f267812ULL, 0x000fc400078ef61eULL, 0x000000041f287812ULL, 0x140fe400078ef61eULL,
0x000000051f2a7812ULL, 0x140fe400078ef61eULL, 0x000000061f2c7812ULL, 0x000fe200078ef61eULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe400078ee221ULL,
0x0000001dff217212ULL, 0x000fe400078e33ffULL, 0x000000071d1e7812ULL, 0x000fc400078ec0ffULL,
0x00009000341d7811ULL, 0x000fe400078e58ffULL, 0xfffffff823307812ULL, 0x100fe400078ee21eULL,
0x000000011f327812ULL, 0x140fe200078ef61eULL, 0x00000010201c7824ULL, 0x000fe200078e021dULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee221ULL, 0x0000001024207824ULL, 0x100fe200078e021dULL,
0x000000021f3e7812ULL, 0x140fe200078ef61eULL, 0x0000001028247824ULL, 0x100fe200078e021dULL,
0x000000031f427812ULL, 0x140fe200078ef61eULL, 0x000000102c287824ULL, 0x100fe200078e021dULL,
0x000000041f447812ULL, 0x140fe200078ef61eULL, 0x00000010322c7824ULL, 0x100fe200078e021dULL,
0x000000051f467812ULL, 0x140fe200078ef61eULL, 0x000000103e2d7824ULL, 0x100fe200078e021dULL,
0x000000061f487812ULL, 0x000fe200078ef61eULL, 0x00000010221e7824ULL, 0x000fc400078e021dULL,
0x0000001026227824ULL, 0x100fe400078e021dULL, 0x000000102a267824ULL, 0x100fe400078e021dULL,
0x00000001331f7824ULL, 0x000fe400078e021cULL, 0x000000102e2a7824ULL, 0x100fe400078e021dULL,
0x00000010301c7824ULL, 0x100fe200078e021dULL, 0x000000081f007388ULL, 0x0003e20000000800ULL,
0x00000010422e7824ULL, 0x000fc400078e021dULL, 0x00000010442f7824ULL, 0x100fe400078e021dULL,
0x0000001046307824ULL, 0x100fe400078e021dULL, 0x0000001048317824ULL, 0x100fe400078e021dULL,
0x000000104a327824ULL, 0x000fe400078e021dULL, 0x00000001331d7824ULL, 0x040fe400078e021eULL,
0x0000000133217824ULL, 0x000fc400078e0220ULL, 0x0000000133237824ULL, 0x040fe200078e0222ULL,
0x0000000a1d007388ULL, 0x0007e20000000800ULL, 0x0000000133257824ULL, 0x040fe400078e0224ULL,
0x0000000133277824ULL, 0x040fe200078e0226ULL, 0x0000000c21007388ULL, 0x0007e20000000800ULL,
0x0000000133297824ULL, 0x040fe400078e0228ULL, 0x00000001332b7824ULL, 0x040fe200078e022aULL,
0x0000000e23007388ULL, 0x0007e20000000800ULL, 0x00000001331c7824ULL, 0x000fc400078e021cULL,
0x00000001332c7824ULL, 0x040fe200078e022cULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x00000001331e7824ULL, 0x040fe400078e022dULL, 0x00000001332e7824ULL, 0x040fe200078e022eULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x0000000133087824ULL, 0x042fe400078e022fULL,
0x0000000133307824ULL, 0x040fe200078e0230ULL, 0x0000001429007388ULL, 0x0007e20000000800ULL,
0x0000000133207824ULL, 0x000fc400078e0231ULL, 0x0000000133327824ULL, 0x000fe200078e0232ULL,
0x000000162b007388ULL, 0x0007e80000000800ULL, 0x000000091c007388ULL, 0x0007e80000000800ULL,
0x0000000b2c007388ULL, 0x0007e80000000800ULL, 0x0000000d1e007388ULL, 0x0007e80000000800ULL,
0x0000000f2e007388ULL, 0x0007e80000000800ULL, 0x0000001108007388ULL, 0x0007e80000000800ULL,
0x0000001330007388ULL, 0x0007e80000000800ULL, 0x0000001520007388ULL, 0x0007e80000000800ULL,
0x0000001732007388ULL, 0x0007e80000000800ULL, 0x00f0000400008388ULL, 0x0007e80000000c00ULL,
0x00f2001800008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030036367a10ULL, 0x000fe20007ffe0ffULL, 0x00f6080040ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff3dff7812ULL, 0x000fc4000780c0ffULL, 0x000000393600720cULL, 0x000fe40003f26070ULL,
0x00000001ff3d7807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffb8d000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e0058ULL, 0x00015b70002a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x0000069000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2d7224ULL, 0x004fe200078e002eULL,
0xffff937000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x002fe200078e005aULL,
0x00015be0002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x0000062000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff2a7224ULL, 0x004fe200078e002eULL, 0xffff932000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x000fe200078e002dULL, 0x00015c4000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x000fc400078e00ffULL, 0x0000058000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002bULL, 0xfffff11000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x000fe200078e002fULL, 0x00015ca000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000052000007944ULL, 0x020fea0003c00000ULL,
0x0000002b2f307209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0006ULL,
0x00015cf000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x002fc400078e00ffULL,
0x000004d000007944ULL, 0x000fea0003c00000ULL, 0x0000002b06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0007ULL, 0x00015d4000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000048000007944ULL, 0x000fea0003c00000ULL,
0x0000002b072c7209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e002dULL,
0x00015d9000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x0000002b2d047209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0030ULL, 0x00015de000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x002fc400078e00ffULL, 0x000003e000007944ULL, 0x000fea0003c00000ULL,
0x0000002b30057209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0006ULL,
0x00015e3000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000002b06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e002cULL, 0x00015e8000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0xffffefd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2f7224ULL, 0x000fe200078e0020ULL,
0x00015ef0002a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff307224ULL, 0x000fc400078e00ffULL,
0x00001c1fff317424ULL, 0x000fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fe400078e001dULL,
0x0000031000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e002eULL,
0xfffff5b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2f7224ULL, 0x002fe200078e0022ULL,
0x00015f70002a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff307224ULL, 0x000fe400078e00ffULL,
0x00001c1fff317424ULL, 0x000fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fe400078e001dULL,
0x0000029000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff307224ULL, 0x002fe200078e00ffULL,
0x00015fd0002a7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff317424ULL, 0x000fc400078e00ffULL,
0x000000ffff327224ULL, 0x000fe400078e001dULL, 0x000000ffff197224ULL, 0x004fe400078e002eULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff327224ULL, 0x002fe200078e001dULL,
0x00016030002a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff307224ULL, 0x000fe400078e00ffULL,
0x00001c1fff317424ULL, 0x000fe400078e00ffULL, 0x000000ffff1a7224ULL, 0x004fe400078e002eULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e002eULL,
0xfffff4f000007947ULL, 0x000fea000383ffffULL, 0x0180000041007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000004100008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000005ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff41ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000005ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000041057812ULL, 0x000fd600078ec0ffULL, 0x0080000005000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000004100007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffe9e4006007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003200007348ULL, 0x000fe80003800000ULL,
0x0c00002e2b2b7389ULL, 0x0002a200000e0031ULL, 0xfffe9e0008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2b7424ULL, 0x000fe200078e00ffULL, 0x0000003200007348ULL, 0x000fe80003800000ULL,
0x000000302f2e7389ULL, 0x0002a200000e0031ULL, 0xfffe9dc02a007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000778ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007f0ULL, 0x00000000000006b0ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ea0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ec0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ed0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ef0ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f60ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f68ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000f78ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000016300ULL, 0xf300001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017480ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000017490ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017490ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000017910ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f60ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000016520ULL, 0x0000000000016520ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017480ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000017910ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_86_cubin_len = 96752;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
