/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000018910ULL, 0x0000000000018490ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000017190ULL, 0x0000000000000180ULL, 0x000e002200000106ULL, 0x0000000000017310ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000017350ULL, 0x0000000000000130ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000017480ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001719000000000ULL, 0x0000040400000000ULL, 0x810c000000100400ULL, 0x005c440410288080ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8908288080860828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808089920000ULL, 0x0000000000000022ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001719000000000ULL, 0x0000018000000000ULL,
0x0000480400000000ULL, 0x8083288080860900ULL, 0x0900000010042880ULL, 0x2880808628808089ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x9008288080860828ULL, 0x288080ac08288080ULL,
0x8280162880808c08ULL, 0x0000000003102880ULL, 0x80808c9200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x0000010800000000ULL, 0x0001731000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8c08288080860828ULL,
0x2880809008288080ULL, 0x828016288080ac08ULL, 0x0000000003102880ULL, 0x8080ac9200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000019000000000ULL, 0x0001735000000000ULL,
0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000ffULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000001000000011ULL, 0x0000001100081104ULL, 0x0008120400000010ULL,
0x0000001000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000dULL,
0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0001611000183104ULL, 0x0001622000016210ULL, 0x00016500000164f0ULL,
0x00c0290400016510ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0500002005000020ULL, 0x0500002005000020ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000b000c02804ULL, 0x000020a000000100ULL, 0x000021e000002140ULL,
0x00003e2000002210ULL, 0x0000729000003e50ULL, 0x000073d000007340ULL, 0x0000a2f000007400ULL,
0x0000b8400000a310ULL, 0x0000bc000000b870ULL, 0x0000e6d00000bc10ULL, 0x0000ebc00000e6f0ULL,
0x00015d900000ebf0ULL, 0x00015dd000015dc0ULL, 0x00015e1000015de0ULL, 0x00015e4000015e30ULL,
0x000164e000015e50ULL, 0x0001655000016540ULL, 0x00016ba000016560ULL, 0x00016c9000016c10ULL,
0x00016d7000016d00ULL, 0x00016e5000016de0ULL, 0x00016f3000016ec0ULL, 0x0001702000016fa0ULL,
0x00017100000170a0ULL, 0x0280390400017160ULL, 0x000000ff00000170ULL, 0x003f01000001b600ULL,
0x00000009000001b0ULL, 0x003f01300001b608ULL, 0x00000009000001e0ULL, 0x003f01300001b610ULL,
0x0000000900000210ULL, 0x003f01200001b648ULL, 0x0000000900000240ULL, 0x003f01200001b668ULL,
0x000000ff00000470ULL, 0x003f01070001b600ULL, 0x0000000a00000670ULL, 0x003f010200000004ULL,
0x0000000a00000740ULL, 0x003f010100000000ULL, 0x000000ff00001050ULL, 0x0005010700000000ULL,
0x00000014000010d0ULL, 0x003f010100000020ULL, 0x0000001600001340ULL, 0x003f01060001b66cULL,
0x00000016000013d0ULL, 0x003f01060001b66cULL, 0x0000001600001460ULL, 0x003f01060001b66cULL,
0x0000002e00001e20ULL, 0x0005010700000000ULL, 0x0000003200001e90ULL, 0x0005010600000004ULL,
0x0000003000001eb0ULL, 0x003f01060001b60cULL, 0x0000000d00001fc0ULL, 0x003f010600000004ULL,
0x0000003200002490ULL, 0x0005010600000004ULL, 0x0000003200002530ULL, 0x0005010600000004ULL,
0x0000002100006500ULL, 0x003f010100000000ULL, 0x00000020000065a0ULL, 0x003f010100000000ULL,
0x0000001600006690ULL, 0x003f01060001b66cULL, 0x00000016000066e0ULL, 0x003f01060001b66cULL,
0x0000002100006770ULL, 0x003f010600000004ULL, 0x000000ff00007000ULL, 0x0005010700000000ULL,
0x0000002600007070ULL, 0x003f010600000004ULL, 0x0000002a00007090ULL, 0x003f01060001b62cULL,
0x0000002a000071a0ULL, 0x003f01060001b62cULL, 0x0000000800007700ULL, 0x003f01060001b64cULL,
0x00000026000077d0ULL, 0x003f010600000004ULL, 0x0000000e0000b4b0ULL, 0x003f010100000000ULL,
0x0000000d0000b540ULL, 0x003f010100000000ULL, 0x000000ff000113d0ULL, 0x003f01060001b604ULL,
0x000000ff000114f0ULL, 0x003f01060001b604ULL, 0x000000ff00011710ULL, 0x003f01010001b600ULL,
0x000000ff00011720ULL, 0x003f01060001b604ULL, 0x000000ff000117a0ULL, 0x003f01060001b604ULL,
0x0000004200015200ULL, 0x003f01060001b614ULL, 0x0000004200015690ULL, 0x003f01060001b614ULL,
0x0000004200016ae0ULL, 0x003f01010001b608ULL, 0x00141c0400053803ULL, 0x0000fa500000f600ULL,
0x000118c0000117f0ULL, 0x0000040100016b50ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL,
0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000204ULL,
0x0000001100000002ULL, 0x000000000000017cULL, 0x0000001100000002ULL, 0x00000000000000dcULL,
0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001dcULL,
0x0000001100000002ULL, 0x0000000000000154ULL, 0x0000001100000002ULL, 0x00000000000000b2ULL,
0x0000001100000002ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000107919ULL, 0x000e620000002300ULL,
0x00000004ff087424ULL, 0x000fe200078e00ffULL, 0x0000460000087ab9ULL, 0x000fe20000000a00ULL,
0xfffffff001017810ULL, 0x000fe20007ffe0ffULL, 0x0000000000037919ULL, 0x000e620000002200ULL,
0x0000580000047ab9ULL, 0x000fc60000000800ULL, 0x0000000000077919ULL, 0x000ea80000002100ULL,
0x0000000000437919ULL, 0x000ee80000002700ULL, 0x00000000002c7919ULL, 0x000f220000002600ULL,
0x0000000110007824ULL, 0x002fc600078e0203ULL, 0x00001fff10107589ULL, 0x000e6200000e0000ULL,
0x0000008000097824ULL, 0x104fe200078e0207ULL, 0x00000005ff007819ULL, 0x000fc80000011607ULL,
0x000000ff0900720cULL, 0x040fe40003f05270ULL, 0x000000030900780cULL, 0x040fe20003f44070ULL,
0x00001fff00007589ULL, 0x000ea200000e0000ULL, 0x0000007f0900780cULL, 0x040fe40003f24070ULL,
0x000000010900780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL, 0x01b60002ff008388ULL, 0x000fe20000000a00ULL,
0x000000ff1000720cULL, 0x002fe20003f05270ULL, 0x3fffffc0ff0aa424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL, 0x01b608040900a388ULL, 0x000fe2000000ca00ULL,
0x3fffffc0ff0ca424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff0da424ULL, 0x000fe200078e00ffULL,
0x01b6100a0900a388ULL, 0x000fe2000000ca00ULL, 0xff317217ff069424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0eb424ULL, 0x000fe200078e00ffULL, 0x01b6480c0900a388ULL, 0x000fe20000008a00ULL,
0x7fffffc0ff0fb424ULL, 0x000fc600078e00ffULL, 0x01b4000609009388ULL, 0x0007e80000004800ULL,
0x01b6680e0900b388ULL, 0x0003e20000008a00ULL, 0x0000620043067625ULL, 0x008fc600078e0008ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000026000000947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x016e620000000000ULL, 0x0000000400037824ULL, 0x000fe200078e00ffULL,
0x0000000404057899ULL, 0x000fe2000800063fULL, 0x000000102c027824ULL, 0x000fe400078e00ffULL,
0x00000100ff117424ULL, 0x000fc600078e00ffULL, 0x0000000543027c24ULL, 0x000fe2000f8e0202ULL,
0x000000030e097211ULL, 0x042fe200078fe0ffULL, 0x000000100e047824ULL, 0x000fc600078e00ffULL,
0x00000002090b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000102037824ULL, 0x040fe200078e0209ULL,
0x0000000709057812ULL, 0x000fe400078ec0ffULL, 0x000000070b0d7812ULL, 0x000fe200078ec0ffULL,
0x00000001020c7824ULL, 0x000fe200078e020bULL, 0x000000f0040f7812ULL, 0x000fe200078ec0ffULL,
0x00005c0003027625ULL, 0x000fe200078e0011ULL, 0x0000000f050a7812ULL, 0x000fc600078e780eULL,
0x00005c000c047625ULL, 0x000fe200078e0011ULL, 0x0000000f0d0c7812ULL, 0x000fe400078e780eULL,
0x0000000f02027210ULL, 0x080fe20007f1e0ffULL, 0x00000010090a7824ULL, 0x000fe200078e020aULL,
0x0000000f04047210ULL, 0x000fe20007f3e0ffULL, 0x000000100b0c7824ULL, 0x000fe400078e020cULL,
0x000000ffff037224ULL, 0x000fe400000e0603ULL, 0x000000100a097824ULL, 0x000fc400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400008e0605ULL, 0x000000100c0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000b901c48ULL,
0x00000000040b7faeULL, 0x0003e8000b901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000806027981ULL, 0x016ea2000c1e1900ULL, 0x00000000000579c3ULL, 0x000e620000002500ULL,
0x000000ff1000720cULL, 0x000fe20003f05270ULL, 0x00000005ff037e24ULL, 0x002fe2000f8e00ffULL,
0x0000007f02fb7810ULL, 0x004fc40007ffe0ffULL, 0x000000ff02047810ULL, 0x000fe40007ffe0ffULL,
0x00000007fffb7819ULL, 0x000fe400000116fbULL, 0x00000008ff047819ULL, 0x000fca0000011604ULL,
0x0000f4f000008947ULL, 0x000fea0003800000ULL, 0x00000002ff057819ULL, 0x000fe20000011600ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x0001b610000a7811ULL, 0x000fe200078e20ffULL,
0xffffffffff0b7424ULL, 0x000fe200078e00ffULL, 0x01ffffff05067812ULL, 0x000fca00078ec0ffULL,
0x00000002030c7824ULL, 0x000fca00078e0206ULL, 0x000000fb0c00720cULL, 0x000fda0003f06070ULL,
0x0000000243058824ULL, 0x000fe400078e00ffULL, 0x00006400ff068624ULL, 0x000fc800078e00ffULL,
0x0000640005058624ULL, 0x000fc800078e0206ULL, 0x000000010c058824ULL, 0x000fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000004090aff738cULL, 0x0003e20000000000ULL,
0x0000600005068625ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000008060b8981ULL, 0x0004e2000c1e1900ULL, 0x00000300ff097624ULL, 0x002fe200078e00ffULL,
0x000000010c057812ULL, 0x000fe400078ec0ffULL, 0x0000000100e97812ULL, 0x000fe200078ec0ffULL,
0x000000802c2c7824ULL, 0x000fe200078e00ffULL, 0xffffffff090d7811ULL, 0x000fe200078e08ffULL,
0x000000000aff7f8cULL, 0x000fe2000c80043fULL, 0x000000010500780cULL, 0x000fe20003f05070ULL,
0xffffffffff067424ULL, 0x004fc600078e00ffULL, 0x000000010d057807ULL, 0x000fe20004000000ULL,
0x0000000000077919ULL, 0x000e680000000000ULL, 0x000000010c057824ULL, 0x000fca00078e0205ULL,
0x000000fb0500720cULL, 0x000fe20003f06070ULL, 0x00000020e90f7824ULL, 0x000fd800078e00ffULL,
0x0000000243098824ULL, 0x000fe400078e00ffULL, 0x00006400ff0c8624ULL, 0x000fc800078e00ffULL,
0x00006400090c8624ULL, 0x000fe200078e020cULL, 0x00000003ff0e7819ULL, 0x002fc60000011607ULL,
0x000000010c098824ULL, 0x000fe200078e0205ULL, 0x000000040e117810ULL, 0x000fc60007ffe0ffULL,
0x0000600009088625ULL, 0x000fe200078e0008ULL, 0x00000001030d7810ULL, 0x000fe40007ffe0ffULL,
0x000000080e157810ULL, 0x040fe20007ffe0ffULL, 0x000000010f107824ULL, 0x000fe200078e020eULL,
0x0000000808068981ULL, 0x000362000c1e1900ULL, 0x000000040d00720cULL, 0x000fe20003f06070ULL,
0x000000010f147824ULL, 0x040fe200078e0211ULL, 0x0000000c0e1c7810ULL, 0x000fe20007ffe0ffULL,
0x00000008100d7824ULL, 0x000fe200078e00ffULL, 0x000000100e1e7810ULL, 0x040fe20007ffe0ffULL,
0x000000010f167824ULL, 0x040fe200078e0215ULL, 0x000000140e227810ULL, 0x000fe20007ffe0ffULL,
0x00000008140c7824ULL, 0x000fe200078e00ffULL, 0x000000180e267810ULL, 0x000fe20007ffe0ffULL,
0x000000010f187824ULL, 0x040fe200078e021cULL, 0x0000000710087212ULL, 0x082fe200078e3cffULL,
0x0000000816177824ULL, 0x000fe200078e00ffULL, 0x0000000714097212ULL, 0x080fe200078e3cffULL,
0x000000010f207824ULL, 0x000fe200078e021eULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee208ULL,
0x000000010f247824ULL, 0x000fe200078e0222ULL, 0x0000000716087212ULL, 0x080fe200078e3cffULL,
0x00000008201a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c137812ULL, 0x000fe200078ee209ULL,
0x00000008180c7824ULL, 0x040fe200078e00ffULL, 0x0000000718097212ULL, 0x080fe200078e3cffULL,
0x0000000824257824ULL, 0x000fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fe200078ee208ULL,
0x000000010f287824ULL, 0x000fe200078e0226ULL, 0x00000001ff087819ULL, 0x000fe20000011600ULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0xfffffff80c197812ULL, 0x000fe200078ee209ULL,
0x0000000828277824ULL, 0x000fe200078e00ffULL, 0x0000000720097212ULL, 0x080fe200078e3cffULL,
0x0000000403127824ULL, 0x000fe200078e0208ULL, 0x00000007240c7212ULL, 0x080fe200078e3cffULL,
0x00004000081d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a237812ULL, 0x000fe200078ee209ULL,
0x0000004012097824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee20cULL,
0x00000010072d7824ULL, 0x000fe200078e00ffULL, 0x00000007281a7212ULL, 0x000fe200078e3cffULL,
0x0000041d01007387ULL, 0x0003e20000100800ULL, 0x00000009020c7217ULL, 0x000fe20007800000ULL,
0x00000000080573c2ULL, 0x000ea200000e0000ULL, 0xfffffff827277812ULL, 0x000fc400078ee21aULL,
0x0000001c0e297810ULL, 0x000fe20007ffe0ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a09ULL,
0x000130001d127810ULL, 0x000fe40007ffe0ffULL, 0x0000007f10107812ULL, 0x000fe200078ec0ffULL,
0x000000010f2a7824ULL, 0x000fe200078e0229ULL, 0x000000400c0c7807ULL, 0x000fe20000000000ULL,
0x00000010131d7824ULL, 0x102fe200078e0212ULL, 0x0000007f16167812ULL, 0x000fe200078ec0ffULL,
0x00000080ff137424ULL, 0x000fe200078e00ffULL, 0x0000000f0c0c7217ULL, 0x000fe20007800000ULL,
0x000000082a2e7824ULL, 0x000fe200078e00ffULL, 0x0000007f14147812ULL, 0x000fe200078ec0ffULL,
0x0000001019217824ULL, 0x100fe200078e0212ULL, 0x000000072a1b7212ULL, 0x000fe200078e3cffULL,
0x000000010c1a7824ULL, 0x000fe200078e0a0fULL, 0x000000402c0c7812ULL, 0x000fe200078ef809ULL,
0x00000010171f7824ULL, 0x100fe200078e0212ULL, 0x000000702d2d7812ULL, 0x000fe200078ec0ffULL,
0x0000001023237824ULL, 0x100fe200078e0212ULL, 0x0000001a0e00720cULL, 0x000fe20003fa6070ULL,
0x0000001025257824ULL, 0x100fe200078e0212ULL, 0x0000007f18187812ULL, 0x000fe200078ec0ffULL,
0x0000001027277824ULL, 0x100fe200078e0212ULL, 0xfffffff82e2b7812ULL, 0x000fe200078ee21bULL,
0x000000100d1b7824ULL, 0x100fe200078e0212ULL, 0x0000007f24247812ULL, 0x000fe200078ec0ffULL,
0x0001b64805057891ULL, 0x004fe2000f8e203fULL, 0x0000007f20207812ULL, 0x000fe200078ec0ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0212ULL, 0x0000007f28287812ULL, 0x000fc400078ec0ffULL,
0x0000001a1500720cULL, 0x080fe40003f66070ULL, 0x0000001a1100720cULL, 0x000fe40003f86070ULL,
0x0000007f2a2a7812ULL, 0x000fe200078ec0ffULL, 0x000000040b097c24ULL, 0x008fc8000f8e020cULL,
0x00000001090a7824ULL, 0x040fe400078e0210ULL, 0x00000001090e7824ULL, 0x000fe400078e0216ULL,
0x00005e000a0a7625ULL, 0x000fc800078e0013ULL, 0x00000001090c7824ULL, 0x000fe200078e0214ULL,
0x0000002d0a147210ULL, 0x000fe20007f1e0ffULL, 0x00005e000e0e7625ULL, 0x000fc800078e0013ULL,
0x00005e000c0c7625ULL, 0x000fc800078e0013ULL, 0x0000000109107824ULL, 0x040fe200078e0218ULL,
0x0000002d0e187210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e060bULL,
0x0000002d0c167210ULL, 0x000fe20007f3e0ffULL, 0x0000000109247824ULL, 0x040fe400078e0224ULL,
0x00005e00100a7625ULL, 0x000fe200078e0013ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141b7faeULL, 0x0003e2000e901c48ULL, 0x0000001a2600720cULL, 0x000fe40003fa6070ULL,
0x0000000109207824ULL, 0x040fe200078e0220ULL, 0x0000002d0a0a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000109117824ULL, 0x000fc400078e0228ULL, 0x000000ffff197224ULL, 0x000fe400010e060fULL,
0x000000ffff177224ULL, 0x000fe400008e060dULL, 0x00005e00240e7625ULL, 0x080fe200078e0013ULL,
0x0001b64808147811ULL, 0x002fe400078e18ffULL, 0x00000000161d7faeULL, 0x0003e2000e101c48ULL,
0x00005e00200c7625ULL, 0x000fe200078e0013ULL, 0x0000002d0e0e7210ULL, 0x000fe40007f5e0ffULL,
0x0000001a2900720cULL, 0x000fe20003f86070ULL, 0x00005e0011107625ULL, 0x000fe200078e0013ULL,
0x0000002d0c0c7210ULL, 0x080fe20007f3e0ffULL, 0x00000000181f7faeULL, 0x0003e4000d901c48ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000002d10107210ULL, 0x000fe20007f1e0ffULL,
0x0000000109127824ULL, 0x000fc400078e022aULL, 0x000000ffff0f7224ULL, 0x000fe200010e060fULL,
0x0000001a1c00720cULL, 0x080fe20003f46070ULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x0000001a1e00720cULL, 0x080fe20003f26070ULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000001a2200720cULL, 0x000fe20003f06070ULL, 0x00005e0012127625ULL, 0x000fc800078e0013ULL,
0xff317217ff097424ULL, 0x000fe200078e00ffULL, 0x0000002d12127210ULL, 0x000fc60007fde0ffULL,
0x000000000a217faeULL, 0x0003e4000d101c48ULL, 0x000000ffff137224ULL, 0x000fe400030e0613ULL,
0x000000000c237faeULL, 0x0003e8000c901c48ULL, 0x000000000e257faeULL, 0x0003e2000c101c48ULL,
0x000000040300720cULL, 0x000fc60003f06070ULL, 0x0000000010277faeULL, 0x0003e8000e901c48ULL,
0x00000000122b7faeULL, 0x0003e8000e101c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200014ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0a7224ULL, 0x002fe200078e00ffULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000a41000000947ULL, 0x000fea0003800000ULL,
0x0000000243437824ULL, 0x004fe200078e00ffULL, 0x00007610ff147816ULL, 0x000fe20000000014ULL,
0x00006400ff0c7624ULL, 0x000fe200078e00ffULL, 0x00007610ff157816ULL, 0x000fe20000000015ULL,
0xff317217ff097424ULL, 0x000fe200078e00ffULL, 0x00007610ff137816ULL, 0x000fe20000000013ULL,
0x000000ffff117224ULL, 0x000fc400078e00ffULL, 0x00006400430b7624ULL, 0x000fe400078e020cULL,
0x000000ffff377224ULL, 0x000fe400078e00ffULL, 0x00000020000b7824ULL, 0x000fca00078e00ffULL,
0xffffffc00b0e7812ULL, 0x002fca00078ec0ffULL, 0x00000100030f7824ULL, 0x000fca00078e020eULL,
0x000000020f00720cULL, 0x000fda0003f06070ULL, 0x0000a2d000000947ULL, 0x000fea0003800000ULL,
0x0000000400387824ULL, 0x000fe200078e00ffULL, 0x0000ffff140b7812ULL, 0x000fe200078ec0ffULL,
0x000000fffffa7224ULL, 0x000fc600078e0005ULL, 0xfffffff838167812ULL, 0x000fe400078ec0ffULL,
0x000088800b107816ULL, 0x000fe200000000ffULL, 0x000000ffff0b7224ULL, 0x000fe400078e0011ULL,
0x01b66c00160e7984ULL, 0x000e640000000800ULL, 0x80000000100d7824ULL, 0x000fca00078e00ffULL,
0x800000000eff7812ULL, 0x002fe2000780480dULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00007610140e7816ULL, 0x000fe4000000000eULL, 0x0000761015127816ULL, 0x000fc60000000012ULL,
0x0000080e01007387ULL, 0x0003e80000100600ULL, 0x0000001201007387ULL, 0x0003e20000100600ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x01b66c00160e7984ULL, 0x002e640000000800ULL,
0x800000000eff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000010177824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL, 0x0000000d000e7305ULL, 0x0002a4000021f000ULL,
0x3fa000000d0d7823ULL, 0x002fe200000100ffULL, 0x0000000e0000735dULL, 0x004fe40003800000ULL,
0x01b66c00160e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fc40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000400013d7983ULL, 0x000ea20000100800ULL, 0x00000300ff0e7624ULL, 0x002fe200078e00ffULL,
0x00000001050d7812ULL, 0x000fe200078ec0ffULL, 0x00006400ff127624ULL, 0x000fe200078e00ffULL,
0x0000000000107919ULL, 0x000e640000002700ULL, 0xffffffff0e0e7811ULL, 0x000fe400078e08ffULL,
0x0000000000187919ULL, 0x000ee20000002600ULL, 0x000000010d00780cULL, 0x000fe40003f05070ULL,
0x000000800f0d7810ULL, 0x000fc40007ffe0ffULL, 0x000000010e177807ULL, 0x000fca0004000000ULL,
0x00000001050e7824ULL, 0x000fca00078e0217ULL, 0x000000fb0e00720cULL, 0x000fe20003f06070ULL,
0x0000000210107824ULL, 0x002fe400078e00ffULL, 0x0000008018187824ULL, 0x008fe400078e00ffULL,
0x0000640010107624ULL, 0x000fc600078e0212ULL, 0x00000040180f7812ULL, 0x000fca00078ef80dULL,
0x00000004ff198424ULL, 0x000fe200078e00ffULL, 0x00000017100e8210ULL, 0x000fe20007ffe005ULL,
0x0000002000ef7824ULL, 0x000fe200078e00ffULL, 0x00000003ff2d7819ULL, 0x000fe20000011607ULL,
0x0000000406127c24ULL, 0x020fe4000f8e020fULL, 0xffffffffff067424ULL, 0x000fe200078e00ffULL,
0x00000020ef1f7812ULL, 0x000fe200078ec0ffULL, 0x000060000e0e8625ULL, 0x000fe200078e0019ULL,
0x000000042d307810ULL, 0x000fe40007ffe0ffULL, 0x0000000103197810ULL, 0x000fc40007ffe0ffULL,
0x000000080e068981ULL, 0x000362000c1e1900ULL, 0x0000000c2d337810ULL, 0x040fe40007ffe0ffULL,
0x0000000d02107217ULL, 0x000fe40007800000ULL, 0x000000082d327810ULL, 0x000fe20007ffe0ffULL,
0x00000001300e7824ULL, 0x102fe200078e021fULL, 0x000000041900720cULL, 0x000fe20003f06070ULL,
0x000000012d207824ULL, 0x100fe400078e021fULL, 0x000000080e1c7824ULL, 0x040fe200078e00ffULL,
0x000000070e197212ULL, 0x080fe200078e3cffULL, 0x0000000133247824ULL, 0x000fe200078e021fULL,
0x000000102d397810ULL, 0x040fe20007ffe0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a0dULL,
0xfffffff81c197812ULL, 0x000fe200078ee219ULL, 0x0000000132227824ULL, 0x100fe200078e021fULL,
0x000000182d3b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008200d7824ULL, 0x040fe200078e00ffULL,
0x0000000720187212ULL, 0x080fe200078e3cffULL, 0x00000008241c7824ULL, 0x040fe200078e00ffULL,
0x00000007241b7212ULL, 0x080fe200078e3cffULL, 0x0000000139267824ULL, 0x100fe200078e021fULL,
0x00000007221a7212ULL, 0x0c0fe200078e3cffULL, 0x00000008220f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d187812ULL, 0x000fe200078ee218ULL, 0x000000013b2a7824ULL, 0x000fe200078e021fULL,
0xfffffff81c1b7812ULL, 0x000fe200078ee21bULL, 0x00000008260d7824ULL, 0x040fe200078e00ffULL,
0x00000007261c7212ULL, 0x000fc400078e3cffULL, 0xfffffff80f1a7812ULL, 0x000fe200078ee21aULL,
0x000000082a0f7824ULL, 0x040fe200078e00ffULL, 0x000000142d3a7810ULL, 0x000fe40007ffe0ffULL,
0x000000072a1e7212ULL, 0x000fe400078e3cffULL, 0xfffffff80d1c7812ULL, 0x000fe400078ee21cULL,
0x0000007f24237812ULL, 0x000fe400078ec0ffULL, 0x0000007f200d7812ULL, 0x000fe200078ec0ffULL,
0x000000013a287824ULL, 0x000fe200078e021fULL, 0xfffffff80f1e7812ULL, 0x000fe200078ee21eULL,
0x0000000112247824ULL, 0x000fe200078e0223ULL, 0x0000007f0e0f7812ULL, 0x000fe200078ec0ffULL,
0x00000001120d7824ULL, 0x000fc400078e020dULL, 0x00000080ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000001007237824ULL, 0x000fe200078e00ffULL, 0x00000007281d7212ULL, 0x040fe200078e3cffULL,
0x00000008282c7824ULL, 0x000fe200078e00ffULL, 0x0000001c2d3c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000112207824ULL, 0x000fe200078e020fULL, 0x0000007023317812ULL, 0x000fe200078ec0ffULL,
0x00005e000d0e7625ULL, 0x000fe200078e002fULL, 0xfffffff82c1d7812ULL, 0x000fe400078ee21dULL,
0x0000007f22217812ULL, 0x000fe200078ec0ffULL, 0x000000013c2c7824ULL, 0x000fe200078e021fULL,
0x0000004010107807ULL, 0x000fc40000000000ULL, 0x0000007f28277812ULL, 0x000fe400078ec0ffULL,
0x0000007f2a297812ULL, 0x000fe400078ec0ffULL, 0x000000310e287210ULL, 0x000fe20007f1e0ffULL,
0x0000000112227824ULL, 0x000fe200078e0221ULL, 0x0000007f2c2b7812ULL, 0x000fe200078ec0ffULL,
0x00000001122e7824ULL, 0x000fe200078e0229ULL, 0x0000001f10107217ULL, 0x000fe20007800000ULL,
0x000000ffff297224ULL, 0x000fe200000e060fULL, 0x000000072c217212ULL, 0x040fe200078e3cffULL,
0x000000082c2c7824ULL, 0x000fc400078e00ffULL, 0x00005e00240e7625ULL, 0x000fc800078e002fULL,
0x0000000110107824ULL, 0x000fe200078e0a1fULL, 0xfffffff82c1f7812ULL, 0x000fe400078ee221ULL,
0x000000310e2c7210ULL, 0x000fe20007f5e0ffULL, 0x00000008000e7824ULL, 0x000fe200078e00ffULL,
0x0000007f26257812ULL, 0x000fe400078ec0ffULL, 0x000000103200720cULL, 0x080fe20003f66070ULL,
0x0000000811327824ULL, 0x000fe200078e00ffULL, 0x000000103000720cULL, 0x000fe20003f86070ULL,
0x00005e0020207625ULL, 0x000fe200078e002fULL, 0xfffffff00e307812ULL, 0x000fc400078ec0ffULL,
0x000000102d00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff2d7224ULL, 0x000fe200010e060fULL,
0x00000000300573c2ULL, 0x000e6200000e0000ULL, 0x0000000112257824ULL, 0x000fe400078e0225ULL,
0x00005e002e0e7625ULL, 0x000fe200078e002fULL, 0x00000008322e7812ULL, 0x000fe400078e0cffULL,
0x00000031202a7210ULL, 0x000fe20007f1e0ffULL, 0x00002000110d7824ULL, 0x000fe400078e00ffULL,
0x00005e0022227625ULL, 0x080fe200078e002fULL, 0x000000002e0673c2ULL, 0x000ee600000e0000ULL,
0x00005e0025247625ULL, 0x000fe200078e002fULL, 0x000020000d0d7812ULL, 0x000fc600078e0cffULL,
0x0000000112277824ULL, 0x000fe200078e0227ULL, 0x0000003122227210ULL, 0x080fe20007f3e0ffULL,
0x0000000112127824ULL, 0x000fe400078e022bULL, 0x000000ffff2b7224ULL, 0x000fe200000e0621ULL,
0x0000003124247210ULL, 0x000fe20007f1e0ffULL, 0x00005e0027267625ULL, 0x000fc800078e002fULL,
0x00005e0012207625ULL, 0x000fc800078e002fULL, 0x000000ffff237224ULL, 0x000fe200008e0623ULL,
0x0000003126267210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e0625ULL,
0x000000310e0e7210ULL, 0x080fe40007f1e0ffULL, 0x0000003120207210ULL, 0x000fe20007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200008e0627ULL, 0x000000103300720cULL, 0x080fe20003f46070ULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0x000000103900720cULL, 0x080fe40003f26070ULL,
0x000000103a00720cULL, 0x000fe20003f06070ULL, 0x0001b64805057890ULL, 0x002fe2000fffe03fULL,
0x000000ffff217224ULL, 0x000fc600030e0621ULL, 0x0000000605067290ULL, 0x008fe2000fffe03fULL,
0x000130003d0d7810ULL, 0x004fca0007ffe00dULL, 0x00000010182f7824ULL, 0x100fe400078e020dULL,
0x0000001019317824ULL, 0x000fc600078e020dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282f7faeULL, 0x0003e2000e901c48ULL, 0x000000103b00720cULL, 0x000fc60003fa6070ULL,
0x000000002a317faeULL, 0x0005e2000e101c48ULL, 0x000000103c00720cULL, 0x000fe20003f86070ULL,
0x000000101a337824ULL, 0x100fe400078e020dULL, 0x000000101b397824ULL, 0x100fe400078e020dULL,
0x000000101c3b7824ULL, 0x100fe200078e020dULL, 0x0000000022337faeULL, 0x0005e2000d901c48ULL,
0x000000101d297824ULL, 0x102fe400078e020dULL, 0x000000101e2f7824ULL, 0x100fe200078e020dULL,
0x000000002c397faeULL, 0x0005e2000d101c48ULL, 0x000000101f0d7824ULL, 0x000fc600078e020dULL,
0x00000000243b7faeULL, 0x0005e8000c901c48ULL, 0x0000000026297faeULL, 0x0005e8000c101c48ULL,
0x000000000e2f7faeULL, 0x0005e8000e901c48ULL, 0x00000000200d7faeULL, 0x0005e8000e101c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a06ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000405320f7984ULL, 0x0042a20008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01b60c0030217984ULL, 0x000ee20000000800ULL,
0x0000ffff150d7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff130e7812ULL, 0x000fe400078ec0ffULL,
0x000088800d207816ULL, 0x000fe400000000ffULL, 0x000088800e0d7816ULL, 0x000fc600000000ffULL,
0x80000000200e7824ULL, 0x000fe400078e00ffULL, 0x800000000d107824ULL, 0x000fc600078e00ffULL,
0x800000000fff7812ULL, 0x004fe4000780480eULL, 0x8000000021ff7812ULL, 0x008fe20007824810ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x800000000d0f7824ULL, 0x000fe200078e00ffULL, 0x0001b608080d7811ULL, 0x000fe200078e20ffULL,
0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL, 0x0000000e00107305ULL, 0x0004e4000021f000ULL,
0x3fa000000e0e7823ULL, 0x004fe200000100ffULL, 0x000000100000735dULL, 0x008fe40003800000ULL,
0x000004000d107984ULL, 0x000ea40000000800ULL, 0x8000000010ff7812ULL, 0x004fc4000782480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000001007237824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011607ULL,
0x00000001ffae7424ULL, 0x000fc600078e00ffULL, 0x00000070230f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0d0e7812ULL, 0x000fc600078ec0ffULL, 0x00000080080d7824ULL, 0x000fc800078e020fULL,
0x000000010d0d7824ULL, 0x000fca00078e020eULL, 0x01b000000d0e7984ULL, 0x000ea80000000800ULL,
0x01b200000d0f7984ULL, 0x0007220000000800ULL, 0x000000090e00720bULL, 0x004fda0003f3d000ULL,
0x0000000000107806ULL, 0x000fc800008e0100ULL, 0x0000ffff10217812ULL, 0x000fda000782c0ffULL,
0x000003a000009947ULL, 0x000fea0003800000ULL, 0x000000090e00720bULL, 0x018fe40003f54000ULL,
0x0000000e09247209ULL, 0x040fe40007810000ULL, 0x00000002ff107819ULL, 0x000fe40000011607ULL,
0x000000000800720cULL, 0x000fe20003f25270ULL, 0x80000024090d7221ULL, 0x000fe20000010000ULL,
0x0000000810127810ULL, 0x000fc60007ffe0ffULL, 0x3fb8aa3b0d0d7820ULL, 0x000fe40000410000ULL,
0x0000000000097806ULL, 0x000fc800010e0100ULL, 0x0000ffff09227812ULL, 0x000fe200078e3cffULL,
0x0000000d000d7308ULL, 0x000ea20000000800ULL, 0x0000007023099812ULL, 0x000fe400078ec0ffULL,
0x0000002221ff7212ULL, 0x000fe4000784c0ffULL, 0x00000001ff219819ULL, 0x000fe20000011607ULL,
0x0000008000099824ULL, 0x000fe200078e0209ULL, 0x00000001ffae7807ULL, 0x000fe40001000000ULL,
0x0000000c21229812ULL, 0x000fca00078ec0ffULL, 0x0000000122099824ULL, 0x000fe200078e0209ULL,
0x00001f120d127589ULL, 0x004ea200000e0000ULL, 0x800000240e0e2221ULL, 0x000fe40000010000ULL,
0x0000000d0a0a7220ULL, 0x000fe20000410000ULL, 0x00001f100d107589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b0e0e2820ULL, 0x000fc60000410000ULL, 0x01b4002409009388ULL, 0x0009e20000000800ULL,
0x0000000e000c2308ULL, 0x000e620000000800ULL, 0x000000ffff097224ULL, 0x010fe400078e0024ULL,
0x0000001237377220ULL, 0x084fe40000410000ULL, 0x0000001236367220ULL, 0x080fe40000410000ULL,
0x0000001263637220ULL, 0x080fe40000410000ULL, 0x0000001262627220ULL, 0x000fc40000410000ULL,
0x000000125f5f7220ULL, 0x080fe40000410000ULL, 0x000000125e5e7220ULL, 0x080fe40000410000ULL,
0x000000125b5b7220ULL, 0x080fe40000410000ULL, 0x000000125a5a7220ULL, 0x080fe40000410000ULL,
0x0000001257577220ULL, 0x080fe40000410000ULL, 0x0000001256567220ULL, 0x000fc40000410000ULL,
0x0000001253537220ULL, 0x080fe40000410000ULL, 0x0000001252527220ULL, 0x080fe40000410000ULL,
0x000000124f4f7220ULL, 0x080fe40000410000ULL, 0x000000124e4e7220ULL, 0x080fe40000410000ULL,
0x000000124b4b7220ULL, 0x080fe40000410000ULL, 0x000000124a4a7220ULL, 0x000fc40000410000ULL,
0x0000001035357220ULL, 0x088fe40000410000ULL, 0x0000001034347220ULL, 0x080fe40000410000ULL,
0x0000001061617220ULL, 0x080fe40000410000ULL, 0x0000001060607220ULL, 0x080fe40000410000ULL,
0x000000105d5d7220ULL, 0x080fe40000410000ULL, 0x000000105c5c7220ULL, 0x000fc40000410000ULL,
0x0000001059597220ULL, 0x080fe40000410000ULL, 0x0000001058587220ULL, 0x080fe40000410000ULL,
0x0000001055557220ULL, 0x080fe40000410000ULL, 0x0000001054547220ULL, 0x080fe40000410000ULL,
0x0000001051517220ULL, 0x080fe40000410000ULL, 0x0000001050507220ULL, 0x000fc40000410000ULL,
0x000000104d4d7220ULL, 0x080fe40000410000ULL, 0x000000104c4c7220ULL, 0x080fe40000410000ULL,
0x0000001049497220ULL, 0x080fe40000410000ULL, 0x0000001048487220ULL, 0x000fe40000410000ULL,
0x0000000c0f0f2220ULL, 0x002fc80000410000ULL, 0x0000000a0f0a7221ULL, 0x018fe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000405320d7984ULL, 0x000ea20008000800ULL,
0x80000000200e7824ULL, 0x000fca00078e00ffULL, 0x800000000dff7812ULL, 0x004fe2000780480eULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x80000000200f7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL,
0x0000000d000e7305ULL, 0x0004e4000021f000ULL, 0x3fa000000d0d7823ULL, 0x004fe200000100ffULL,
0x0000000e0000735dULL, 0x008fe40003800000ULL, 0x00000405320e7984ULL, 0x000ea40008000800ULL,
0x800000000eff7812ULL, 0x004fc4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000040001107983ULL, 0x000ea20000100800ULL,
0x00000004380e7812ULL, 0x000fe400078ec0ffULL, 0x00000008070d7812ULL, 0x040fe400078ec0ffULL,
0x0000000e070e7211ULL, 0x000fe400078fe0ffULL, 0x000000070d417812ULL, 0x140fe400078ec807ULL,
0x000000070d0f7812ULL, 0x000fc800078ef807ULL, 0x000000800f297811ULL, 0x040fe400078e18ffULL,
0x000001000f757811ULL, 0x000fe200078e18ffULL, 0x0000200011267824ULL, 0x004fe200078e0210ULL,
0x0000000e41107212ULL, 0x000fe400078e3cffULL, 0x000000020e0e7810ULL, 0x000fe40007ffe0ffULL,
0x0001300026267810ULL, 0x000fe20007ffe0ffULL, 0x000000080f0d7824ULL, 0x000fe200078e0210ULL,
0x0000000e410e7212ULL, 0x000fe200078e3cffULL, 0x0000000110217824ULL, 0x000fc400078e0229ULL,
0x000000100d0d7824ULL, 0x100fe400078e0226ULL, 0x0000001021217824ULL, 0x100fe400078e0226ULL,
0x0000000110237824ULL, 0x000fe200078e0275ULL, 0x000000000d38783bULL, 0x000ea20000004200ULL,
0x000000010e297824ULL, 0x000fe400078e0229ULL, 0x0000001023237824ULL, 0x100fe200078e0226ULL,
0x000000002130783bULL, 0x0023e20000004200ULL, 0x0000001029297824ULL, 0x000fc400078e0226ULL,
0x000000010e757824ULL, 0x000fe200078e0275ULL, 0x00000000233c783bULL, 0x0007220000004200ULL,
0x00000018ff127819ULL, 0x004fe20000011439ULL, 0x0000003900287306ULL, 0x000fe20000009400ULL,
0x00000018ff217819ULL, 0x002fe4000001143aULL, 0x00000018ff237819ULL, 0x008fe4000001143bULL,
0x00000018ff0d7819ULL, 0x000fe40000011438ULL, 0x00000018ff2a7819ULL, 0x010fe2000001143cULL,
0x0000001200207306ULL, 0x000fe20000209400ULL, 0x00000018ff407819ULL, 0x000fc4000001143fULL,
0x00000018ff2c7819ULL, 0x000fe4000001143dULL, 0x00000018ff257819ULL, 0x000fe40000011430ULL,
0x00000018ff2e7819ULL, 0x000fe2000001143eULL, 0x0000001200dc7306ULL, 0x000e700000205400ULL,
0x0000001200787306ULL, 0x0004f0000020d400ULL, 0x0000002100687306ULL, 0x000fe20000209400ULL,
0x00000018ff127819ULL, 0x004fc40000011431ULL, 0x000000dc2000720bULL, 0x002fca0003f9d000ULL,
0x0000001200957306ULL, 0x000ff00000209400ULL, 0x0000001200967306ULL, 0x000fe20000205400ULL,
0x0000000178784812ULL, 0x008fce00078efcffULL, 0x00000012007a7306ULL, 0x0003f0000020d400ULL,
0x0000002100af7306ULL, 0x000fe20000205400ULL, 0x0000010038127824ULL, 0x002fce00078e00ffULL,
0x0000002100a97306ULL, 0x0003f0000020d400ULL, 0x0000002a00897306ULL, 0x000fe20000209400ULL,
0x00000018ff217819ULL, 0x002fce0000011432ULL, 0x0000002a00807306ULL, 0x000ff00000205400ULL,
0x0000002a002d7306ULL, 0x0003f0000020d400ULL, 0x0000003900e67306ULL, 0x000ea20000005400ULL,
0x00000018ff2a7819ULL, 0x002fe20000011412ULL, 0x0000010039127824ULL, 0x000fcc00078e00ffULL,
0x0000003900c57306ULL, 0x0002f0000000d400ULL, 0x0000002100877306ULL, 0x000fe20000209400ULL,
0x0001000039397824ULL, 0x002fe200078e00ffULL, 0x000000e62800720bULL, 0x004fcc0003f3d000ULL,
0x0000002100867306ULL, 0x000fee0000205400ULL, 0x00000001c5c51812ULL, 0x008fe200078efcffULL,
0x0000002100927306ULL, 0x000ff0000020d400ULL, 0x0000002a00217306ULL, 0x000ff00000209400ULL,
0x0000002a00e27306ULL, 0x000e700000205400ULL, 0x0000002a00d97306ULL, 0x0004f0000020d400ULL,
0x0000002300677306ULL, 0x000fe20000209400ULL, 0x00000018ff2a7819ULL, 0x004fe20000011439ULL,
0x000000080f397824ULL, 0x000fe200078e020eULL, 0x000000e22100720bULL, 0x002fc60003f5d000ULL,
0x0000001039397824ULL, 0x000fe400078e0226ULL, 0x00000023002f7306ULL, 0x000ff00000205400ULL,
0x0000002300ad7306ULL, 0x0003e2000020d400ULL, 0x00000001d9d92812ULL, 0x008fce00078efcffULL,
0x0000000d00e57306ULL, 0x000fe20000209400ULL, 0x00000018ff237819ULL, 0x002fce0000011433ULL,
0x0000000d00227306ULL, 0x000e700000205400ULL, 0x0000000d00737306ULL, 0x000eb0000020d400ULL,
0x00000023000d7306ULL, 0x000fe20000209400ULL, 0x00000022e500720bULL, 0x002fce0003f1d000ULL,
0x0000002300717306ULL, 0x000fec0000205400ULL, 0x0000000173730812ULL, 0x004fe400078efcffULL,
0x0000002300937306ULL, 0x000ff0000020d400ULL, 0x0000004000e07306ULL, 0x000ff00000209400ULL,
0x0000004000df7306ULL, 0x000ff00000205400ULL, 0x0000004000237306ULL, 0x0003f0000020d400ULL,
0x0000002c00d37306ULL, 0x000fe20000209400ULL, 0x000000003940783bULL, 0x002e6e0000004200ULL,
0x0000002c00d17306ULL, 0x000ff00000205400ULL, 0x0000002c002b7306ULL, 0x0005f0000020d400ULL,
0x0000003800277306ULL, 0x000fe20000009400ULL, 0x00000018ff2c7819ULL, 0x004fce0000011412ULL,
0x0000003800777306ULL, 0x000eb00000005400ULL, 0x0000003800c67306ULL, 0x000722000000d400ULL,
0x0000010043dc7824ULL, 0x002fca00078e00ffULL, 0x00000018ffdc7819ULL, 0x000fe400000114dcULL,
0x0000002500a27306ULL, 0x000fe20000209400ULL, 0x0001000038387824ULL, 0x008fe200078e00ffULL,
0x000000772700720bULL, 0x004fc80003fdd000ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000002500997306ULL, 0x000fee0000205400ULL, 0x00000001c6c66812ULL, 0x010fe200078efcffULL,
0x0000002500b67306ULL, 0x000ff0000020d400ULL, 0x0000002e00d77306ULL, 0x000ff00000209400ULL,
0x0000002e00d57306ULL, 0x000ff00000205400ULL, 0x0000002e00257306ULL, 0x0003f0000020d400ULL,
0x0000002c00127306ULL, 0x000fe20000209400ULL, 0x000001003a2e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000002c00ce7306ULL, 0x000e700000205400ULL,
0x0000002c00ca7306ULL, 0x0004f0000020d400ULL, 0x0000003a00247306ULL, 0x000fe20000009400ULL,
0x000001003b2c7824ULL, 0x004fe200078e00ffULL, 0x000000ce1200720bULL, 0x002fc80003fdd000ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000003a00de7306ULL, 0x000e6e0000005400ULL,
0x00000001caca6812ULL, 0x008fe200078efcffULL, 0x0000003a009f7306ULL, 0x0004f0000000d400ULL,
0x0000003b00dd7306ULL, 0x000fe20000009400ULL, 0x000100003a3a7824ULL, 0x004fe200078e00ffULL,
0x000000de2400720bULL, 0x002fc80003f7d000ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000003b00e47306ULL, 0x000e6e0000005400ULL, 0x000000019f9f3812ULL, 0x008fe200078efcffULL,
0x0000003b008b7306ULL, 0x0004f0000000d400ULL, 0x0000003800e17306ULL, 0x000fe20000209400ULL,
0x000100003b3b7824ULL, 0x004fe200078e00ffULL, 0x000000e4dd00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000003800e37306ULL, 0x000e6e0000205400ULL,
0x000000018b8b5812ULL, 0x008fe200078efcffULL, 0x0000003800b17306ULL, 0x0004f0000020d400ULL,
0x0000003a00cf7306ULL, 0x000fe20000209400ULL, 0x00000018ff387819ULL, 0x004fc40000011443ULL,
0x000000e3e100720bULL, 0x002fca0003f5d000ULL, 0x0000003a00d07306ULL, 0x000e700000205400ULL,
0x0000003a00cd7306ULL, 0x000ea2000020d400ULL, 0x00000001b1b12812ULL, 0x008fe400078efcffULL,
0x000000af6800720bULL, 0x000fe20003f5d000ULL, 0x0000010041af7824ULL, 0x000fc800078e00ffULL,
0x0000003b00d47306ULL, 0x000fe20000209400ULL, 0x000000d0cf00720bULL, 0x002fce0003f9d000ULL,
0x0000003b00d67306ULL, 0x000fe20000205400ULL, 0x00000001a9a92812ULL, 0x000fca00078efcffULL,
0x00000001cdcd4812ULL, 0x004fe400078efcffULL, 0x0000003b00c07306ULL, 0x000ff0000020d400ULL,
0x0000003800b07306ULL, 0x000ff00000209400ULL, 0x0000003800b87306ULL, 0x000ff00000205400ULL,
0x0000003800907306ULL, 0x0003f0000020d400ULL, 0x0000002a00be7306ULL, 0x000fe20000209400ULL,
0x000000002938783bULL, 0x002e6e0000004200ULL, 0x0000002a00bf7306ULL, 0x000eb00000205400ULL,
0x0000002a00a37306ULL, 0x000730000020d400ULL, 0x0000003000977306ULL, 0x000fe20000009400ULL,
0x00000018ff2a7819ULL, 0x008fc40000011440ULL, 0x000000bfbe00720bULL, 0x004fe40003f1d000ULL,
0x00000018ffbe7819ULL, 0x000fc600000114afULL, 0x0000002a00d87306ULL, 0x000ff00000209400ULL,
0x0000002a00db7306ULL, 0x000ea20000205400ULL, 0x00000018ff297819ULL, 0x002fe40000011438ULL,
0x00000001a3a30812ULL, 0x010fc400078efcffULL, 0x0000002f6700720bULL, 0x000fc60003f1d000ULL,
0x0000002a00b37306ULL, 0x0002f0000020d400ULL, 0x0000003000a07306ULL, 0x000fe20000005400ULL,
0x00000100302a7824ULL, 0x002fe200078e00ffULL, 0x00000001adad0812ULL, 0x000fc400078efcffULL,
0x000000dbd800720bULL, 0x004fe20003f7d000ULL, 0x0001000042db7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000003000bb7306ULL, 0x0003e4000000d400ULL,
0x00000018ffdb7819ULL, 0x000fcc00000114dbULL, 0x0000002c00c37306ULL, 0x000fe20000209400ULL,
0x0001000030307824ULL, 0x002fe200078e00ffULL, 0x00000001b3b33812ULL, 0x008fc800078efcffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000002c00c47306ULL, 0x000e700000205400ULL,
0x0000002c00a87306ULL, 0x0004f0000020d400ULL, 0x0000003000c97306ULL, 0x000fe20000209400ULL,
0x00000018ff2c7819ULL, 0x004fc40000011441ULL, 0x000000c4c300720bULL, 0x002fe40003f3d000ULL,
0x00000002ffc47819ULL, 0x000fc60000011607ULL, 0x0000002c00cb7306ULL, 0x000fe20000209400ULL,
0x00000008c4e67810ULL, 0x000fce0007ffe0ffULL, 0x0000002c00cc7306ULL, 0x000e620000205400ULL,
0x00000001a8a81812ULL, 0x008fce00078efcffULL, 0x0000002c00ac7306ULL, 0x0004f0000020d400ULL,
0x0000003000c87306ULL, 0x000fe20000205400ULL, 0x00000100312c7824ULL, 0x004fe200078e00ffULL,
0x000000cccb00720bULL, 0x002fc80003f3d000ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000003000b77306ULL, 0x0003ee000020d400ULL, 0x00000001acac1812ULL, 0x008fe200078efcffULL,
0x0000002a00bd7306ULL, 0x000fe20000209400ULL, 0x00000018ff307819ULL, 0x002fce000001143bULL,
0x0000002a00ba7306ULL, 0x000ff00000205400ULL, 0x0000002a00bc7306ULL, 0x0003f0000020d400ULL,
0x0000002c00b97306ULL, 0x000fe20000209400ULL, 0x00000100322a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000002c00b27306ULL, 0x000ff00000205400ULL,
0x0000002c00947306ULL, 0x0003f0000020d400ULL, 0x00000030007e7306ULL, 0x000fe20000209400ULL,
0x00000100332c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000003000857306ULL, 0x000ff00000205400ULL, 0x0000003000667306ULL, 0x0003f0000020d400ULL,
0x00000031009d7306ULL, 0x000fe20000009400ULL, 0x000001003f307824ULL, 0x002fca00078e00ffULL,
0x00000018ffe77819ULL, 0x000fe20000011430ULL, 0x0000001075307824ULL, 0x000fe200078e0226ULL,
0x0000003100a17306ULL, 0x000ff00000005400ULL, 0x0000003100917306ULL, 0x0003f0000000d400ULL,
0x0000003200a57306ULL, 0x000fe20000009400ULL, 0x0001000031317824ULL, 0x002fca00078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003200a67306ULL, 0x000ff00000005400ULL,
0x0000003200a47306ULL, 0x0003f0000000d400ULL, 0x00000033009c7306ULL, 0x000fe20000009400ULL,
0x0001000032327824ULL, 0x002fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x00000033009a7306ULL, 0x000ff00000005400ULL, 0x0000003300477306ULL, 0x0003f0000000d400ULL,
0x0000003100da7306ULL, 0x000fe20000209400ULL, 0x0001000033337824ULL, 0x002fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000003100c77306ULL, 0x000ff00000205400ULL,
0x0000003100a77306ULL, 0x000ff0000020d400ULL, 0x0000003200ec7306ULL, 0x000ff00000209400ULL,
0x0000003200eb7306ULL, 0x000ff00000205400ULL, 0x0000003200457306ULL, 0x000ff0000020d400ULL,
0x0000003300fc7306ULL, 0x000ff00000209400ULL, 0x0000003300ee7306ULL, 0x000ff00000205400ULL,
0x0000003300447306ULL, 0x0003f0000020d400ULL, 0x00000029006f7306ULL, 0x000fe20000209400ULL,
0x000000003030783bULL, 0x002e6e0000004200ULL, 0x0000002900817306ULL, 0x000ff00000205400ULL,
0x0000002900837306ULL, 0x0005f0000020d400ULL, 0x0000003c009b7306ULL, 0x000fe20000009400ULL,
0x000001003c297824ULL, 0x004fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000003c008c7306ULL, 0x000ff00000005400ULL, 0x0000003c006a7306ULL, 0x0005f0000000d400ULL,
0x0000002e00c17306ULL, 0x000fe20000209400ULL, 0x000100003c3c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000002e00c27306ULL, 0x000eb00000205400ULL,
0x0000002e00d27306ULL, 0x000730000020d400ULL, 0x00000029007c7306ULL, 0x000fe20000209400ULL,
0x00000018ff2e7819ULL, 0x008fc40000011442ULL, 0x000000c2c100720bULL, 0x004fca0003fdd000ULL,
0x00000029007d7306ULL, 0x000ff00000205400ULL, 0x00000029006b7306ULL, 0x0005e2000020d400ULL,
0x00000001d2d26812ULL, 0x010fe400078efcffULL, 0x000000d6d400720bULL, 0x000fca0003fdd000ULL,
0x0000002a00aa7306ULL, 0x000fe20000209400ULL, 0x000001003e297824ULL, 0x004fce00078e00ffULL,
0x0000002a00ab7306ULL, 0x000fe20000205400ULL, 0x00000001c0c06812ULL, 0x000fce00078efcffULL,
0x0000002a009e7306ULL, 0x0005f0000020d400ULL, 0x0000002e00b47306ULL, 0x000fe20000209400ULL,
0x00000018ff2a7819ULL, 0x004fce0000011439ULL, 0x0000002e00b57306ULL, 0x000eb00000205400ULL,
0x0000002e00987306ULL, 0x000ef0000020d400ULL, 0x0000003c00f97306ULL, 0x000fe20000209400ULL,
0x000000b5b400720bULL, 0x004fce0003f5d000ULL, 0x0000003c00f37306ULL, 0x000fec0000205400ULL,
0x0000000198982812ULL, 0x008fe400078efcffULL, 0x0000003c002e7306ULL, 0x0005e2000020d400ULL,
0x000000babd00720bULL, 0x000fce0003f5d000ULL, 0x0000002a006c7306ULL, 0x000fe20000209400ULL,
0x00000018ff3c7819ULL, 0x004fca0000011429ULL, 0x00000001bcbc2812ULL, 0x000fe400078efcffULL,
0x0000002a006d7306ULL, 0x000fe20000205400ULL, 0x000000c8c900720bULL, 0x000fce0003f5d000ULL,
0x0000002a007b7306ULL, 0x0005ec000020d400ULL, 0x00000001b7b72812ULL, 0x000fe400078efcffULL,
0x0000003d008d7306ULL, 0x000fe20000009400ULL, 0x000001003d2a7824ULL, 0x004fe200078e00ffULL,
0x000000c7da00720bULL, 0x000fc80003f5d000ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000003d008e7306ULL, 0x000fee0000005400ULL, 0x00000001a7a72812ULL, 0x000fe200078efcffULL,
0x0000003d00647306ULL, 0x0005e2000000d400ULL, 0x000000868700720bULL, 0x000fce0003f5d000ULL,
0x0000003c00727306ULL, 0x000fe20000209400ULL, 0x000100003d3d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00747306ULL, 0x000fe20000205400ULL,
0x0000000192922812ULL, 0x000fce00078efcffULL, 0x0000003c00297306ULL, 0x0005f0000020d400ULL,
0x0000002c008f7306ULL, 0x000fe20000209400ULL, 0x000100003e3c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000002c00827306ULL, 0x000ff00000205400ULL,
0x0000002c00467306ULL, 0x0005f0000020d400ULL, 0x0000003d00f67306ULL, 0x000fe20000209400ULL,
0x00000018ff2c7819ULL, 0x004fce000001143aULL, 0x0000002c00887306ULL, 0x000ff00000209400ULL,
0x0000002c00847306ULL, 0x000ff00000205400ULL, 0x0000002c00697306ULL, 0x000ff0000020d400ULL,
0x0000003d00f87306ULL, 0x000ff00000205400ULL, 0x0000003d002c7306ULL, 0x0005f0000020d400ULL,
0x0000003f00757306ULL, 0x000fe20000009400ULL, 0x000100003f3d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003f00777306ULL, 0x000ff00000005400ULL,
0x0000003f00277306ULL, 0x0003f0000000d400ULL, 0x0000003c00f77306ULL, 0x000fe20000209400ULL,
0x00000018ff3f7819ULL, 0x002fce0000011433ULL, 0x0000003c00f57306ULL, 0x000ff00000205400ULL,
0x0000003c00287306ULL, 0x0003f0000020d400ULL, 0x0000002a00767306ULL, 0x000fe20000209400ULL,
0x00000018ff3c7819ULL, 0x002fce0000011431ULL, 0x0000002a00797306ULL, 0x000ff00000205400ULL,
0x0000002a00657306ULL, 0x000ff0000020d400ULL, 0x0000003e007f7306ULL, 0x000ff00000009400ULL,
0x0000003e008a7306ULL, 0x000ff00000005400ULL, 0x0000003e002a7306ULL, 0x0003f0000000d400ULL,
0x0000003c00e47306ULL, 0x000fe20000209400ULL, 0x00000018ff3e7819ULL, 0x002fce0000011430ULL,
0x0000003c00e27306ULL, 0x000ff00000205400ULL, 0x0000003c00227306ULL, 0x0003f0000020d400ULL,
0x0000003f00f17306ULL, 0x000fe20000209400ULL, 0x00000100403c7824ULL, 0x002fce00078e00ffULL,
0x0000003f00f07306ULL, 0x000ff00000205400ULL, 0x0000003f00127306ULL, 0x000ff0000020d400ULL,
0x00000040003f7306ULL, 0x000ff00000009400ULL, 0x0000004000687306ULL, 0x000e700000005400ULL,
0x0000003d00f47306ULL, 0x000ff00000209400ULL, 0x0000003d00f27306ULL, 0x000ea20000205400ULL,
0x000000683f00720bULL, 0x002fe20003fbd000ULL, 0x00010000403f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000003d00247306ULL, 0x0003f0000020d400ULL,
0x0000003e00de7306ULL, 0x000fe20000209400ULL, 0x00000018ff3d7819ULL, 0x002fe20000011432ULL,
0x000000ffffba7224ULL, 0x004fcc00078e00f2ULL, 0x0000003e00dd7306ULL, 0x000ff00000205400ULL,
0x0000003e00217306ULL, 0x0003f0000020d400ULL, 0x000000e7006e7306ULL, 0x000fe20000209400ULL,
0x00000018ff3e7819ULL, 0x002fce000001143cULL, 0x000000e700707306ULL, 0x000ff00000205400ULL,
0x000000e700267306ULL, 0x000ff0000020d400ULL, 0x0000003d00e87306ULL, 0x000ff00000209400ULL,
0x0000003d00e77306ULL, 0x000ff00000205400ULL, 0x0000003d00207306ULL, 0x000ff0000020d400ULL,
0x0000003e003c7306ULL, 0x000ff00000209400ULL, 0x0000003e003d7306ULL, 0x000e700000205400ULL,
0x0000003e00ce7306ULL, 0x000ea2000020d400ULL, 0x0000003d3c00720bULL, 0x002fce0003f9d000ULL,
0x000000be003e7306ULL, 0x000ff00000209400ULL, 0x000000be002f7306ULL, 0x000e620000205400ULL,
0x00000001cece4812ULL, 0x004fce00078efcffULL, 0x0000003f00677306ULL, 0x000ff00000209400ULL,
0x0000003f003c7306ULL, 0x000ea20000205400ULL, 0x0000002f3e00720bULL, 0x002fce0003fdd000ULL,
0x000000be00c17306ULL, 0x0002e2000020d400ULL, 0x0000003c6700720bULL, 0x004fce0003f9d000ULL,
0x00000043002f7306ULL, 0x000fe20000009400ULL, 0x0000000707be7812ULL, 0x002fc800078ec0ffULL,
0x00000008bebe7812ULL, 0x100fe400078ef807ULL, 0x00000001c1c16812ULL, 0x008fe200078efcffULL,
0x00000043003c7306ULL, 0x000e700000005400ULL, 0x0000004100af7306ULL, 0x000ff00000009400ULL,
0x0000004100687306ULL, 0x000ea20000005400ULL, 0x0000003c2f00720bULL, 0x002fe20003fdd000ULL,
0x00000100423c7824ULL, 0x000fe200078e00ffULL, 0x00000004ff2f7819ULL, 0x000fc80000011607ULL,
0x000000072f2f7812ULL, 0x000fe200078e78beULL, 0x0000004000cf7306ULL, 0x0002e8000000d400ULL,
0x00000008be2f7824ULL, 0x000fc800078e022fULL, 0x00000042003d7306ULL, 0x000fe20000009400ULL,
0x00000068af00720bULL, 0x004fe20003f1d000ULL, 0x000000102f687824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x002fe4000001143cULL, 0x0000000cff2f723eULL, 0x000fe200000010ffULL,
0x00000800083c7824ULL, 0x000fe400078e0268ULL, 0x00000042003e7306ULL, 0x000e620000005400ULL,
0x00000001cfcf5812ULL, 0x008fce00078efcffULL, 0x0000003f00c27306ULL, 0x0004e2000020d400ULL,
0x0000003e3d00720bULL, 0x002fce0003fbd000ULL, 0x0000004100d07306ULL, 0x000322000000d400ULL,
0x011000003c3c783bULL, 0x004fe20000000200ULL, 0x00000001c2c24812ULL, 0x008fcc00078efcffULL,
0x0000004000d47306ULL, 0x000fe20000209400ULL, 0x0001000041417824ULL, 0x002fca00078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004000d67306ULL, 0x000e620000205400ULL,
0x00000001d0d00812ULL, 0x010fce00078efcffULL, 0x0000004100bf7306ULL, 0x000ff00000209400ULL,
0x0000004100d87306ULL, 0x000ea20000205400ULL, 0x000000d6d400720bULL, 0x002fce0003f7d000ULL,
0x0000004100c37306ULL, 0x0002f0000020d400ULL, 0x0000004000b47306ULL, 0x0008e2000020d400ULL,
0x000054102f417816ULL, 0x002fe4000000002fULL, 0x000000d8bf00720bULL, 0x004fc60003f9d000ULL,
0x00001fc441677589ULL, 0x000e6400000e0000ULL, 0x0000004300af7306ULL, 0x000ea2000000d400ULL,
0x00009910ae407816ULL, 0x010fe200000000ffULL, 0x00001fe6412f7589ULL, 0x00086600000e0000ULL,
0x000000ff4000720cULL, 0x000fe40003f05270ULL, 0x000000c6d940723eULL, 0x000fe200000010ffULL,
0x000000dc00cb7306ULL, 0x000fe20000209400ULL, 0x00000001c3c34812ULL, 0x008fe200078efcffULL,
0x0000010038d97824ULL, 0x000fe200078e00ffULL, 0x00000001b4b43812ULL, 0x000fc400078efcffULL,
0x000000c5ca41723eULL, 0x010fe200000010ffULL, 0x0001000043c57824ULL, 0x000fe200078e00ffULL,
0x000000b8b000720bULL, 0x000fe20003f9d000ULL, 0x000000dc00cc7306ULL, 0x000ee20000205400ULL,
0x00000001afaf6812ULL, 0x004fe400078efcffULL, 0x00000018ff437819ULL, 0x000fe400000114c5ULL,
0x00000099a200720bULL, 0x000fe20003fdd000ULL, 0x000000673c3c8231ULL, 0x082fe200003400ffULL,
0x00000018ffd97819ULL, 0x000fe200000114d9ULL, 0x000000673e3e8231ULL, 0x000fe200003400ffULL,
0x0000004200b57306ULL, 0x000e62000000d400ULL, 0x0000002f3d3d8231ULL, 0x080fe200003400ffULL,
0x000000ffffa27224ULL, 0x000fe200078e00f4ULL, 0x0000002f3f3f8231ULL, 0x000fe200003400ffULL,
0x0000000190904812ULL, 0x000fc400078efcffULL, 0x000000a09700720bULL, 0x000fe20003f9d000ULL,
0x000000ffffa07224ULL, 0x000fe200078e00f9ULL, 0x000000db00c47306ULL, 0x000fe20000209400ULL,
0x000000cccb00720bULL, 0x008fe20003f3d000ULL, 0x000000403c48723cULL, 0x000fe20000041848ULL,
0x00000001b6b66812ULL, 0x000fe200078efcffULL, 0x000000ffffbd7224ULL, 0x000fe200078e00a0ULL,
0x0000009a9c00720bULL, 0x000fc60003fdd000ULL, 0x000000db00c67306ULL, 0x000ea20000205400ULL,
0x000000b17340723eULL, 0x000fe400000010ffULL, 0x000000a37841723eULL, 0x000fe400000010ffULL,
0x00000001b5b55812ULL, 0x002fe400078efcffULL, 0x00000001bbbb4812ULL, 0x000fe200078efcffULL,
0x0000004300c57306ULL, 0x000fe20000209400ULL, 0x000000b2b900720bULL, 0x000fe20003f9d000ULL,
0x000000403c4c723cULL, 0x000fe2000004184cULL, 0x0000000147476812ULL, 0x000fca00078efcffULL,
0x0000004300ca7306ULL, 0x000e620000205400ULL, 0x0000009fd240723eULL, 0x000fe200000010ffULL,
0x0000010039d27824ULL, 0x000fe200078e00ffULL, 0x0000008ba841723eULL, 0x000fe400000010ffULL,
0x000000c6c400720bULL, 0x004fe40003f7d000ULL, 0x00000018ffd27819ULL, 0x000fe200000114d2ULL,
0x000000dc00ae7306ULL, 0x000ea2000020d400ULL, 0x0000000194944812ULL, 0x000fe200078efcffULL,
0x000000403c50723cULL, 0x000fe20000041850ULL, 0x0000008c9b00720bULL, 0x000fca0003f9d000ULL,
0x000000db00427306ULL, 0x000ee2000020d400ULL, 0x000000cda940723eULL, 0x000fe200000010ffULL,
0x0001000038cd7824ULL, 0x000fe200078e00ffULL, 0x000000c0ad41723eULL, 0x000fe400000010ffULL,
0x000000cac500720bULL, 0x002fe40003fbd000ULL, 0x00000018ffcd7819ULL, 0x000fe200000114cdULL,
0x0000004300437306ULL, 0x000e62000020d400ULL, 0x00000001aeae1812ULL, 0x004fe200078efcffULL,
0x000000403c54723cULL, 0x000fe20000041854ULL, 0x000000a19d00720bULL, 0x000fe20003f3d000ULL,
0x000000ffff9d7224ULL, 0x000fe200078e00f8ULL, 0x000000016a6a4812ULL, 0x000fe200078efcffULL,
0x000000ffffa17224ULL, 0x000fe200078e00f6ULL, 0x0000000142423812ULL, 0x008fe200078efcffULL,
0x0000003900c07306ULL, 0x000fe20000005400ULL, 0x000000cfce40723eULL, 0x000fe200000010ffULL,
0x000000ffffcf7224ULL, 0x000fe200078e00f7ULL, 0x000000d0c141723eULL, 0x000fe200000010ffULL,
0x000000ffffd07224ULL, 0x000fe200078e00f5ULL, 0x000000a6a500720bULL, 0x000fc40003f7d000ULL,
0x0000000143435812ULL, 0x002fe200078efcffULL, 0x0000003900c17306ULL, 0x000e620000009400ULL,
0x000000969500720bULL, 0x000fe20003fbd000ULL, 0x000000403c58723cULL, 0x000fe20000041858ULL,
0x0000000191911812ULL, 0x000fe400078efcffULL, 0x0000008e8d00720bULL, 0x000fc60003f3d000ULL,
0x0000003900b07306ULL, 0x0005e2000000d400ULL, 0x000000c2b340723eULL, 0x000fe400000010ffULL,
0x000000c3ac41723eULL, 0x000fe400000010ffULL, 0x00000001a4a43812ULL, 0x000fe400078efcffULL,
0x000000017a7a5812ULL, 0x000fe200078efcffULL, 0x0000003800b17306ULL, 0x000fe20000009400ULL,
0x000000abaa00720bULL, 0x000fe20003fbd000ULL, 0x000000403c5c723cULL, 0x000fe2000004185cULL,
0x000000710d00720bULL, 0x000fe20003f7d000ULL, 0x00010000320d7824ULL, 0x000fe200078e00ffULL,
0x000000c0c100720bULL, 0x002fe20003f5d000ULL, 0x000000ffffc07224ULL, 0x000fe200078e009dULL,
0x0000000164641812ULL, 0x000fe200078efcffULL, 0x0000003800bf7306ULL, 0x000e620000005400ULL,
0x0001000039407824ULL, 0x000fe200078e00ffULL, 0x000000afae39723eULL, 0x004fc400000010ffULL,
0x000000439041723eULL, 0x000fe400000010ffULL, 0x00000018ffaf7819ULL, 0x000fe40000011440ULL,
0x0000003800a87306ULL, 0x0004e2000000d400ULL, 0x000000429840723eULL, 0x000fe400000010ffULL,
0x000000019e9e5812ULL, 0x000fe400078efcffULL, 0x000000828f00720bULL, 0x000fe40003fbd000ULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x000000403c40723cULL, 0x040fe20000041834ULL,
0x000000b5b438723eULL, 0x004fe200000010ffULL, 0x0000003a00c27306ULL, 0x000fe20000009400ULL,
0x000000bfb100720bULL, 0x002fe20003fdd000ULL, 0x000000ffffbf7224ULL, 0x000fe200078e00baULL,
0x00000001b0b02812ULL, 0x000fe200078efcffULL, 0x000000ffffba7224ULL, 0x000fe200078e00d0ULL,
0x0000006d6c00720bULL, 0x000fe20003f5d000ULL, 0x000000383c60723cULL, 0x000fe20000041860ULL,
0x000001003b347824ULL, 0x000fe200078e00ffULL, 0x0000003a00c37306ULL, 0x000fe20000005400ULL,
0x0000010030377824ULL, 0x000fe200078e00ffULL, 0x0000000146465812ULL, 0x000fe200078efcffULL,
0x000000ffffd07224ULL, 0x000fe200078e00f3ULL, 0x00000018ff357819ULL, 0x000fe20000011434ULL,
0x000001003a387824ULL, 0x000fe200078e00ffULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x000000ffffb17224ULL, 0x000fe200078e00a2ULL, 0x0000003a00ac7306ULL, 0x0003e2000000d400ULL,
0x00000001a8a86812ULL, 0x008fc400078efcffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x000000ebec00720bULL, 0x000fe40003fbd000ULL, 0x000000017b7b2812ULL, 0x000fe200078efcffULL,
0x0000003b00c47306ULL, 0x000fe20000009400ULL, 0x000100003a3a7824ULL, 0x002fe200078e00ffULL,
0x0000000193933812ULL, 0x000fe400078efcffULL, 0x000000747200720bULL, 0x000fe40003f3d000ULL,
0x00000018ff347819ULL, 0x000fc4000001143aULL, 0x0000003b00c57306ULL, 0x000fe40000005400ULL,
0x0000000145455812ULL, 0x000fe400078efcffULL, 0x000000eefc00720bULL, 0x000fe20003fbd000ULL,
0x000000fffffc7224ULL, 0x000fe200078e00a1ULL, 0x000000459292723eULL, 0x000fe400000010ffULL,
0x0000003b00ae7306ULL, 0x0003e2000000d400ULL, 0x0000000129291812ULL, 0x000fe400078efcffULL,
0x000000c0fc00720bULL, 0x000fe20003f9d000ULL, 0x000000fffffc7224ULL, 0x000fe200078e00bfULL,
0x000000dfe000720bULL, 0x000fc60003f3d000ULL, 0x000000cd00e67306ULL, 0x000fe20000209400ULL,
0x000100003b3b7824ULL, 0x002fe200078e00ffULL, 0x0000000144445812ULL, 0x000fc800078efcffULL,
0x00000018ff367819ULL, 0x000fe4000001143bULL, 0x000000cd00e57306ULL, 0x000e620000205400ULL,
0x000000449393723eULL, 0x000fe400000010ffULL, 0x0000000123231812ULL, 0x000fe400078efcffULL,
0x000000012c2c4812ULL, 0x000fe400078efcffULL, 0x000000706e00720bULL, 0x000fe20003f9d000ULL,
0x000000d900737306ULL, 0x000ff00000209400ULL, 0x000000d900787306ULL, 0x000ea20000205400ULL,
0x000000e5e600720bULL, 0x002fc60003fdd000ULL, 0x0000000126264812ULL, 0x000fc800078efcffULL,
0x000000d900a37306ULL, 0x000e70000020d400ULL, 0x000000cd00ad7306ULL, 0x000ee2000020d400ULL,
0x000000787300720bULL, 0x004fce0003fbd000ULL, 0x0000003400d87306ULL, 0x000fec0000209400ULL,
0x00000001a3a35812ULL, 0x002fe400078efcffULL, 0x0000003400d97306ULL, 0x000fe20000205400ULL,
0x00000001adad6812ULL, 0x008fe400078efcffULL, 0x000000c3c200720bULL, 0x000fe20003fbd000ULL,
0x000000ffffc37224ULL, 0x000fc800078e00cfULL, 0x0000003400b47306ULL, 0x0003f0000020d400ULL,
0x00000035003f7306ULL, 0x000fe20000209400ULL, 0x0001000030347824ULL, 0x002fe200078e00ffULL,
0x00000001acac5812ULL, 0x000fc400078efcffULL, 0x0000008a7f00720bULL, 0x000fe40003fbd000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003500db7306ULL, 0x000e700000205400ULL,
0x0000003500b57306ULL, 0x0004e2000020d400ULL, 0x000000012a2a5812ULL, 0x000fc400078efcffULL,
0x000000fcb100720bULL, 0x000fe40003fbd000ULL, 0x0000002a292a723eULL, 0x000fc600000010ffULL,
0x0000003000cd7306ULL, 0x000fe20000009400ULL, 0x0000010031357824ULL, 0x004fe200078e00ffULL,
0x000000db3f00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003000a57306ULL, 0x000e620000005400ULL, 0x0000000124245812ULL, 0x000fc800078efcffULL,
0x000000242329723eULL, 0x000fe400000010ffULL, 0x00000001b5b52812ULL, 0x008fe200078efcffULL,
0x0000003000997306ULL, 0x0004e2000000d400ULL, 0x000000808900720bULL, 0x000fce0003f5d000ULL,
0x0000003100a67306ULL, 0x000fe20000009400ULL, 0x0001000031307824ULL, 0x004fe200078e00ffULL,
0x000000a5cd00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003100ce7306ULL, 0x000fe20000005400ULL, 0x000000012d2d2812ULL, 0x000fe400078efcffULL,
0x000000d1d300720bULL, 0x000fc80003f5d000ULL, 0x0000000199994812ULL, 0x008fe200078efcffULL,
0x0000003100957306ULL, 0x0003f0000000d400ULL, 0x000000af00ed7306ULL, 0x000fe20000209400ULL,
0x0000010032317824ULL, 0x002fe200078e00ffULL, 0x000000012b2b2812ULL, 0x000fcc00078efcffULL,
0x000000af00ea7306ULL, 0x000e700000205400ULL, 0x000000af00b37306ULL, 0x000eb0000020d400ULL,
0x0000003600e37306ULL, 0x000fe20000209400ULL, 0x000000eaed00720bULL, 0x002fce0003fdd000ULL,
0x0000003600e17306ULL, 0x000fec0000205400ULL, 0x00000001b3b36812ULL, 0x004fe400078efcffULL,
0x0000003600af7306ULL, 0x0003f0000020d400ULL, 0x000000d2008b7306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x002fe20000011431ULL, 0x0000010033317824ULL, 0x000fcc00078e00ffULL,
0x000000d2009f7306ULL, 0x000e700000205400ULL, 0x000000d200a97306ULL, 0x000eb0000020d400ULL,
0x0000003800c67306ULL, 0x000fe20000209400ULL, 0x0000009f8b00720bULL, 0x002fce0003f7d000ULL,
0x0000003800d27306ULL, 0x000e6c0000205400ULL, 0x00000001a9a93812ULL, 0x004fe400078efcffULL,
0x0000003800b87306ULL, 0x000ea2000020d400ULL, 0x000000816f00720bULL, 0x000fce0003f7d000ULL,
0x0000003400f57306ULL, 0x000fe20000209400ULL, 0x000000d2c600720bULL, 0x002fca0003fdd000ULL,
0x0000000183833812ULL, 0x000fe400078efcffULL, 0x0000003400f27306ULL, 0x000e620000205400ULL,
0x000000c5c400720bULL, 0x000fe20003f7d000ULL, 0x000000ffffc47224ULL, 0x000fc800078e00bdULL,
0x00000001b8b86812ULL, 0x004fe400078efcffULL, 0x0000003400967306ULL, 0x0004e2000020d400ULL,
0x000000d9d800720bULL, 0x000fca0003fdd000ULL, 0x00000001aeae3812ULL, 0x000fe400078efcffULL,
0x00000037003a7306ULL, 0x000fe20000209400ULL, 0x00000018ff347819ULL, 0x004fe40000011431ULL,
0x0000000207317811ULL, 0x000fe400078fe0ffULL, 0x000000848800720bULL, 0x000fe40003f7d000ULL,
0x0000000731317812ULL, 0x000fe200078e78beULL, 0x00000037003b7306ULL, 0x000fe20000205400ULL,
0x00000001b4b46812ULL, 0x000fc400078efcffULL, 0x000000e1e300720bULL, 0x000fe20003fdd000ULL,
0x00000008be317824ULL, 0x000fe200078e0231ULL, 0x000000f2f500720bULL, 0x002fc60003f3d000ULL,
0x0000003700987306ULL, 0x0003e2000020d400ULL, 0x00000010313d7824ULL, 0x000fe200078e00ffULL,
0x000001800f317811ULL, 0x000fe400078e18ffULL, 0x0000000169693812ULL, 0x000fe200078efcffULL,
0x0000080008da7824ULL, 0x000fe200078e023dULL, 0x000000857e00720bULL, 0x000fe20003f7d000ULL,
0x00000001100f7824ULL, 0x000fe200078e0231ULL, 0x0000003500387306ULL, 0x000fe20000209400ULL,
0x0000000607377811ULL, 0x002fe400078fe0ffULL, 0x00000001afaf6812ULL, 0x000fc400078efcffULL,
0x0000000737377812ULL, 0x000fe400078e78beULL, 0x0000007d7c00720bULL, 0x000fe20003fdd000ULL,
0x0000003500397306ULL, 0x000e620000205400ULL, 0x0000000196961812ULL, 0x008fe200078efcffULL,
0x00000008be377824ULL, 0x000fe200078e0237ULL, 0x0000000166663812ULL, 0x000fc600078efcffULL,
0x00000010373c7824ULL, 0x000fe400078e00ffULL, 0x0000003500907306ULL, 0x0004e4000020d400ULL,
0x0000080008c77824ULL, 0x000fe400078e023cULL, 0x000000016b6b6812ULL, 0x000fe400078efcffULL,
0x000000797600720bULL, 0x000fe40003fdd000ULL, 0x0000003000f97306ULL, 0x000fe20000209400ULL,
0x0000000407357811ULL, 0x004fc400078fe0ffULL, 0x000000393800720bULL, 0x002fe40003fbd000ULL,
0x0000000735357812ULL, 0x000fe400078e78beULL, 0x0000006a6b6a723eULL, 0x000fe200000010ffULL,
0x0000003000f47306ULL, 0x000e640000205400ULL, 0x00000008be357824ULL, 0x000fe200078e0235ULL,
0x0000000165656812ULL, 0x000fe400078efcffULL, 0x000000d5d700720bULL, 0x000fe20003fdd000ULL,
0x00000010353e7824ULL, 0x000fe200078e00ffULL, 0x00000064656b723eULL, 0x000fe200000010ffULL,
0x0000003000977306ULL, 0x000522000020d400ULL, 0x0000000190905812ULL, 0x008fe200078efcffULL,
0x0000080008c87824ULL, 0x000fe200078e023eULL, 0x00000001ff087819ULL, 0x000fc40000011600ULL,
0x000000e2e400720bULL, 0x000fc60003fbd000ULL, 0x0000000d00f87306ULL, 0x000fe20000209400ULL,
0x0000000208307824ULL, 0x004fe200078e0211ULL, 0x0000000125256812ULL, 0x000fe400078efcffULL,
0x0000003b3a00720bULL, 0x000fe40003fdd000ULL, 0x0001300030307811ULL, 0x000fe200078e68ffULL,
0x01100000da38783bULL, 0x000ea20000000200ULL, 0x0000000d00f77306ULL, 0x000fe20000205400ULL,
0x000000f4f900720bULL, 0x002fe40003f3d000ULL, 0x0000000122225812ULL, 0x000fca00078efcffULL,
0x0000000d00877306ULL, 0x0003e2000020d400ULL, 0x0000000198986812ULL, 0x000fe400078efcffULL,
0x000000ddde00720bULL, 0x000fe40003fdd000ULL, 0x000000999898723eULL, 0x000fe400000010ffULL,
0x0000000197971812ULL, 0x010fe200078efcffULL, 0x0000003400c97306ULL, 0x000fe20000209400ULL,
0x000000010e0d7824ULL, 0x002fe200078e0231ULL, 0x000000f0f100720bULL, 0x000fc40003f3d000ULL,
0x000000972297723eULL, 0x000fc800000010ffULL, 0x0000003400ca7306ULL, 0x000e620000205400ULL,
0x0000000121216812ULL, 0x000fc800078efcffULL, 0x000000962196723eULL, 0x000fe400000010ffULL,
0x0000000112121812ULL, 0x000fe200078efcffULL, 0x00000034008d7306ULL, 0x000722000020d400ULL,
0x0000006738388231ULL, 0x004fce00003400ffULL, 0x0000003200b27306ULL, 0x000fe20000009400ULL,
0x000000100f347824ULL, 0x108fe200078e0230ULL, 0x000000673a3a8231ULL, 0x000fe200003400ffULL,
0x000000100d307824ULL, 0x000fe200078e0230ULL, 0x0000002f39398231ULL, 0x080fe200003400ffULL,
0x000000cac900720bULL, 0x002fe20003fbd000ULL, 0x0000002f3b3b8231ULL, 0x000fe400003400ffULL,
0x0000003200dc7306ULL, 0x000fea0000005400ULL, 0x000000923854723cULL, 0x000fe60000041854ULL,
0x00000032008e7306ULL, 0x0003e4000000d400ULL, 0x000000018d8d5812ULL, 0x010fc400078efcffULL,
0x000000ad8392723eULL, 0x000fe400000010ffULL, 0x000000b37b93723eULL, 0x000fe400000010ffULL,
0x0000003300d47306ULL, 0x000fe20000009400ULL, 0x0001000033327824ULL, 0x002fc800078e00ffULL,
0x00000092385c723cULL, 0x040fe2000004185cULL, 0x00000018ff717819ULL, 0x000fe40000011432ULL,
0x0000003300d67306ULL, 0x000e680000005400ULL, 0x000000b46992723eULL, 0x000fe400000010ffULL,
0x000000af6693723eULL, 0x000fe400000010ffULL, 0x00000033008f7306ULL, 0x0004ea000000d400ULL,
0x000000923840723cULL, 0x000fe60000041840ULL, 0x0000003600cb7306ULL, 0x000fe20000209400ULL,
0x000000003030783bULL, 0x004ea20000004200ULL, 0x000000d6d400720bULL, 0x002fcc0003f9d000ULL,
0x0000003600cc7306ULL, 0x000e6e0000205400ULL, 0x000000018f8f4812ULL, 0x008fe200078efcffULL,
0x00000036008c7306ULL, 0x000726000020d400ULL, 0x0000008f8d8d723eULL, 0x000fca00000010ffULL,
0x0000007100f67306ULL, 0x000fe20000209400ULL, 0x000000003434783bULL, 0x008ee20000004200ULL,
0x000000cccb00720bULL, 0x002fcc0003fdd000ULL, 0x0000007100f37306ULL, 0x000e6e0000205400ULL,
0x000000018c8c6812ULL, 0x010fe200078efcffULL, 0x0000007100867306ULL, 0x000f22000020d400ULL,
0x00000018ff817819ULL, 0x004fe20000011431ULL, 0x0001000031c97824ULL, 0x000fe200078e00ffULL,
0x00000018ff9f7819ULL, 0x000fc40000011433ULL, 0x000000f7f800720bULL, 0x000fe40003fdd000ULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x0000008100ec7306ULL, 0x000ff00000209400ULL,
0x0000008100e57306ULL, 0x000fe40000205400ULL, 0x0000000187876812ULL, 0x000fcc00078efcffULL,
0x00000081006d7306ULL, 0x0005e2000020d400ULL, 0x00000018ffa07819ULL, 0x008fe20000011436ULL,
0x0001000034887824ULL, 0x040fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe20000011437ULL,
0x0000010037767824ULL, 0x000fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe40000011435ULL,
0x00000018ff9a7819ULL, 0x000fe20000011434ULL, 0x000000a0009c7306ULL, 0x000fe20000209400ULL,
0x0000010034817824ULL, 0x004fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fc40000011488ULL,
0x00000018ff797819ULL, 0x000fc80000011476ULL, 0x000000a0009d7306ULL, 0x000ff00000205400ULL,
0x000000a000737306ULL, 0x0005f0000020d400ULL, 0x0000008b00cf7306ULL, 0x000fe20000205400ULL,
0x000000ffffa07224ULL, 0x004fc400078e00baULL, 0x000000ffffba7224ULL, 0x000fe400078e00d0ULL,
0x000000ffff8a7224ULL, 0x000fc600078e00a0ULL, 0x0000008b00d07306ULL, 0x000ff00000209400ULL,
0x0000008b00717306ULL, 0x0005f0000020d400ULL, 0x0000009b00a17306ULL, 0x000fe20000209400ULL,
0x00000018ff8b7819ULL, 0x004fce0000011481ULL, 0x0000008b00bd7306ULL, 0x000ff00000209400ULL,
0x0000008b00be7306ULL, 0x000eb00000205400ULL, 0x0000008b00817306ULL, 0x000670000020d400ULL,
0x0000009b00a27306ULL, 0x000fe20000205400ULL, 0x000000ffff8b7224ULL, 0x008fca00078e00c3ULL,
0x0000008a8b00720bULL, 0x000fe40003f5d000ULL, 0x0000009b00787306ULL, 0x0007f0000020d400ULL,
0x0000009a00aa7306ULL, 0x000fe20000209400ULL, 0x00000018ff9b7819ULL, 0x008fc40000011432ULL,
0x0000000128282812ULL, 0x000fe400078efcffULL, 0x000000dcb200720bULL, 0x000fe40003f5d000ULL,
0x000000282528723eULL, 0x000fe200000010ffULL, 0x0000009b00ed7306ULL, 0x000ff00000209400ULL,
0x0000009b00ea7306ULL, 0x000fe40000205400ULL, 0x000000018e8e2812ULL, 0x000fc400078efcffULL,
0x000000f3f600720bULL, 0x002fe40003f5d000ULL, 0x0000008e8c8c723eULL, 0x000fe400000010ffULL,
0x0000009b006c7306ULL, 0x0003f0000020d400ULL, 0x0000009a00ab7306ULL, 0x000fe20000205400ULL,
0x000000ffff9b7224ULL, 0x002fe200078e00baULL, 0x0000000186862812ULL, 0x010fc400078efcffULL,
0x000000bebd00720bULL, 0x004fe40003f5d000ULL, 0x0000009bc400720bULL, 0x000fe40003f7d000ULL,
0x0000009a00827306ULL, 0x0003e2000020d400ULL, 0x000000861221723eULL, 0x000fce00000010ffULL,
0x0000003400c57306ULL, 0x000fe20000009400ULL, 0x00000018ff9a7819ULL, 0x002fe40000011430ULL,
0x000000012e2e3812ULL, 0x000fe400078efcffULL, 0x000000777500720bULL, 0x000fe40003f7d000ULL,
0x0000000181812812ULL, 0x000fe200078efcffULL, 0x0000003400c67306ULL, 0x000e620000005400ULL,
0x0000002e2d2e723eULL, 0x000fce00000010ffULL, 0x0000003400807306ULL, 0x0004e4000000d400ULL,
0x0000000127273812ULL, 0x000fe400078efcffULL, 0x000000cea600720bULL, 0x000fc80003f7d000ULL,
0x0000009a00eb7306ULL, 0x000fe20000209400ULL, 0x0001000035347824ULL, 0x004fe200078e00ffULL,
0x000000c6c500720bULL, 0x002fc80003fbd000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000009a00e67306ULL, 0x000fe20000205400ULL, 0x0000000195953812ULL, 0x000fe400078efcffULL,
0x000000e7e800720bULL, 0x000fe40003f7d000ULL, 0x000000959099723eULL, 0x000fe400000010ffULL,
0x0000000180805812ULL, 0x008fe200078efcffULL, 0x0000009a006f7306ULL, 0x0003e2000020d400ULL,
0x000000abaa00720bULL, 0x000fc40003fbd000ULL, 0x000000808180723eULL, 0x000fca00000010ffULL,
0x0000003500c17306ULL, 0x000fe20000009400ULL, 0x00000100359a7824ULL, 0x002fe200078e00ffULL,
0x0000000120203812ULL, 0x000fc800078efcffULL, 0x00000018ff9a7819ULL, 0x000fe4000001149aULL,
0x0000003500c27306ULL, 0x000e620000005400ULL, 0x0000000182825812ULL, 0x000fe400078efcffULL,
0x000000872020723eULL, 0x000fca00000010ffULL, 0x0000003500847306ULL, 0x0004f0000000d400ULL,
0x0000003400e17306ULL, 0x000fe20000209400ULL, 0x0000010036357824ULL, 0x004fe200078e00ffULL,
0x000000c2c100720bULL, 0x002fc80003f9d000ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400db7306ULL, 0x000fee0000205400ULL, 0x0000000184844812ULL, 0x008fe200078efcffULL,
0x00000034007c7306ULL, 0x0003f0000020d400ULL, 0x0000009f00ee7306ULL, 0x000fe20000209400ULL,
0x0001000036347824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000009f00d27306ULL, 0x000ff00000205400ULL, 0x0000009f003f7306ULL, 0x000ff0000020d400ULL,
0x0000008800d97306ULL, 0x000ff00000209400ULL, 0x0000008800d87306ULL, 0x000e700000205400ULL,
0x00000035009f7306ULL, 0x000ff00000209400ULL, 0x0000003500a07306ULL, 0x000ea20000205400ULL,
0x000000d8d900720bULL, 0x002fce0003f5d000ULL, 0x00000035007d7306ULL, 0x0002f0000020d400ULL,
0x0000009a00b97306ULL, 0x000fe20000209400ULL, 0x0001000037357824ULL, 0x002fe200078e00ffULL,
0x000000a09f00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000009a00ba7306ULL, 0x000e6e0000205400ULL, 0x000000017d7d5812ULL, 0x008fe200078efcffULL,
0x0000009a007f7306ULL, 0x000ea2000020d400ULL, 0x000000cfd000720bULL, 0x000fce0003fbd000ULL,
0x00000079009a7306ULL, 0x000fe20000209400ULL, 0x000000bab900720bULL, 0x002fca0003f3d000ULL,
0x0000000171715812ULL, 0x000fe400078efcffULL, 0x00000079009b7306ULL, 0x000fe20000205400ULL,
0x000000e6eb00720bULL, 0x000fca0003fbd000ULL, 0x000000017f7f1812ULL, 0x004fe400078efcffULL,
0x0000007900767306ULL, 0x000fe2000020d400ULL, 0x000000dbe100720bULL, 0x000fe40003f3d000ULL,
0x000000847f81723eULL, 0x000fc600000010ffULL, 0x000000016f6f5812ULL, 0x000fe400078efcffULL,
0x0000003400d37306ULL, 0x000fe20000209400ULL, 0x000000d2ee00720bULL, 0x000fca0003fbd000ULL,
0x000000017c7c1812ULL, 0x000fe400078efcffULL, 0x0000003400d17306ULL, 0x000fe20000205400ULL,
0x0000009d9c00720bULL, 0x000fca0003f3d000ULL, 0x000000013f3f5812ULL, 0x000fe400078efcffULL,
0x0000003400797306ULL, 0x0003ec000020d400ULL, 0x0000000173731812ULL, 0x000fe400078efcffULL,
0x0000003500d77306ULL, 0x000fe20000209400ULL, 0x0000010030347824ULL, 0x002fca00078e00ffULL,
0x00000018ffcb7819ULL, 0x000fe40000011434ULL, 0x0000003500d57306ULL, 0x000fe20000205400ULL,
0x000000bbbc34723eULL, 0x000fe200000010ffULL, 0x0000010031bb7824ULL, 0x000fe400078e00ffULL,
0x0001000030bc7824ULL, 0x000fc600078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x0000003500747306ULL, 0x0003e2000020d400ULL, 0x00000018ffbc7819ULL, 0x000fce00000114bcULL,
0x0000008800857306ULL, 0x000ea2000020d400ULL, 0x000000919435723eULL, 0x002fce00000010ffULL,
0x0000003600c37306ULL, 0x000fe20000009400ULL, 0x000000343848723cULL, 0x000fee0000041848ULL,
0x0000003600c47306ULL, 0x000e620000005400ULL, 0x000000a49e34723eULL, 0x000fe400000010ffULL,
0x000000474635723eULL, 0x000fc400000010ffULL, 0x01100000c844783bULL, 0x000ee20000000200ULL,
0x0000000185852812ULL, 0x004fe400078efcffULL, 0x00000036007e7306ULL, 0x000522000000d400ULL,
0x000000a2a100720bULL, 0x000fe20003f5d000ULL, 0x000000343850723cULL, 0x000fe20000041850ULL,
0x000000858282723eULL, 0x000fca00000010ffULL, 0x0000003700bf7306ULL, 0x000fe20000009400ULL,
0x000000b7b636723eULL, 0x004fe200000010ffULL, 0x0000010032b77824ULL, 0x000fe200078e00ffULL,
0x000000c4c300720bULL, 0x002fe20003fdd000ULL, 0x0000010033b67824ULL, 0x000fe400078e00ffULL,
0x0000000178782812ULL, 0x000fe400078efcffULL, 0x0000003700c07306ULL, 0x000e620000005400ULL,
0x0000009b9a00720bULL, 0x000fe40003f5d000ULL, 0x00000018ffb77819ULL, 0x000fc400000114b7ULL,
0x00000018ffb67819ULL, 0x000fc600000114b6ULL, 0x0000003700777306ULL, 0x0004e2000000d400ULL,
0x000000017e7e6812ULL, 0x010fe400078efcffULL, 0x000000d1d300720bULL, 0x000fe40003fdd000ULL,
0x0000007e7d7e723eULL, 0x000fe400000010ffULL, 0x0000000176762812ULL, 0x000fe200078efcffULL,
0x000000cb00917306ULL, 0x000fe20000209400ULL, 0x000000a77a37723eULL, 0x004fe200000010ffULL,
0x0001000032a77824ULL, 0x000fe200078e00ffULL, 0x000000c0bf00720bULL, 0x002fc40003f7d000ULL,
0x000000d5d700720bULL, 0x000fe20003f5d000ULL, 0x0000006744448231ULL, 0x088fe200003400ffULL,
0x00000018ffa77819ULL, 0x000fe200000114a7ULL, 0x00000036384c723cULL, 0x000fe2000004184cULL,
0x01100000c734783bULL, 0x000e620000000200ULL, 0x000000cb00947306ULL, 0x000ea20000205400ULL,
0x0000006746468231ULL, 0x000fe200003400ffULL, 0x0000000179796812ULL, 0x000fe200078efcffULL,
0x0000002f45458231ULL, 0x080fe400003400ffULL, 0x0000002f47478231ULL, 0x000fe200003400ffULL,
0x0000000177773812ULL, 0x000fc400078efcffULL, 0x0000003100a57306ULL, 0x000fe20000009400ULL,
0x0000000174742812ULL, 0x000fe400078efcffULL, 0x00000077767f723eULL, 0x000fe200000010ffULL,
0x000000284454723cULL, 0x000fe80000041854ULL, 0x0000003100a67306ULL, 0x000ee20000005400ULL,
0x000000949100720bULL, 0x004fc60003f7d000ULL, 0x0000006a4448723cULL, 0x040fe80000041848ULL,
0x0000003100727306ULL, 0x000528000000d400ULL, 0x00000096445c723cULL, 0x000fe8000004185cULL,
0x0000003000b17306ULL, 0x000fe20000009400ULL, 0x0001000033317824ULL, 0x004fe200078e00ffULL,
0x000000a6a500720bULL, 0x008fc40003f9d000ULL, 0x000000204440723cULL, 0x000fe40000041840ULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x0000006734348231ULL, 0x082fe200003400ffULL,
0x0000003000b27306ULL, 0x000e620000005400ULL, 0x0000006736368231ULL, 0x000fe400003400ffULL,
0x0000002f35358231ULL, 0x080fe200003400ffULL, 0x000000797320723eULL, 0x000fe200000010ffULL,
0x0000002f37378231ULL, 0x000fe200003400ffULL, 0x0000002c2b2f723eULL, 0x000fc400000010ffULL,
0x0000003200887306ULL, 0x000fe20000009400ULL, 0x00000027262b723eULL, 0x000fe400000010ffULL,
0x0000000172724812ULL, 0x010fe200078efcffULL, 0x000000803448723cULL, 0x000fe20000041848ULL,
0x000000eaed00720bULL, 0x000fe40003f9d000ULL, 0x000000747121723eULL, 0x000fe200000010ffULL,
0x0000003200897306ULL, 0x000ea20000005400ULL, 0x000000b2b100720bULL, 0x002fc60003f1d000ULL,
0x0000002a4450723cULL, 0x040fe80000041850ULL, 0x0000003200707306ULL, 0x0002e4000000d400ULL,
0x000000016c6c4812ULL, 0x000fe400078efcffULL, 0x0000002e444c723cULL, 0x000fe8000004184cULL,
0x00000033008a7306ULL, 0x000fe20000009400ULL, 0x000000a8a332723eULL, 0x002fc400000010ffULL,
0x000000898800720bULL, 0x004fe20003fdd000ULL, 0x000000203454723cULL, 0x040fe80000041854ULL,
0x00000033008b7306ULL, 0x000e680000005400ULL, 0x0000007e3450723cULL, 0x000fe80000041850ULL,
0x00000033006e7306ULL, 0x0005e2000000d400ULL, 0x0000000170706812ULL, 0x008fce00078efcffULL,
0x000000cb007a7306ULL, 0x000ee2000020d400ULL, 0x000000b0a933723eULL, 0x004fe400000010ffULL,
0x0000008b8a00720bULL, 0x002fca0003f3d000ULL, 0x000000bb009e7306ULL, 0x000fe20000209400ULL,
0x000000323858723cULL, 0x000fee0000041858ULL, 0x000000bb00a47306ULL, 0x000e620000205400ULL,
0x000000acb832723eULL, 0x000fe400000010ffULL, 0x000000aeb533723eULL, 0x000fc400000010ffULL,
0x000000017a7a3812ULL, 0x008fe400078efcffULL, 0x000000016e6e1812ULL, 0x000fe200078efcffULL,
0x000000bc00a37306ULL, 0x000fe40000209400ULL, 0x000000323860723cULL, 0x000fec0000041860ULL,
0x000000bc00837306ULL, 0x000ea20000205400ULL, 0x000000a49e00720bULL, 0x002fe20003f5d000ULL,
0x000000984458723cULL, 0x040fec0000041858ULL, 0x0000003000757306ULL, 0x000e70000000d400ULL,
0x000000bb00307306ULL, 0x000ee2000020d400ULL, 0x00000083a300720bULL, 0x004fe20003f7d000ULL,
0x0000008c4460723cULL, 0x000fe20000041860ULL, 0x0000007c7883723eULL, 0x000fca00000010ffULL,
0x000000bc007b7306ULL, 0x000ea2000020d400ULL, 0x0000000175750812ULL, 0x002fe200078efcffULL,
0x00000082344c723cULL, 0x000fe2000004184cULL, 0x000000e5ec00720bULL, 0x000fca0003f1d000ULL,
0x000000c900327306ULL, 0x000fe20000209400ULL, 0x0000000130302812ULL, 0x008fce00078efcffULL,
0x000000c900337306ULL, 0x000e620000205400ULL, 0x000000017b7b3812ULL, 0x004fe400078efcffULL,
0x000000016d6d0812ULL, 0x000fe400078efcffULL, 0x0000007b6f20723eULL, 0x000fc600000010ffULL,
0x000000b7002c7306ULL, 0x000ff00000209400ULL, 0x000000b700277306ULL, 0x000ea20000205400ULL,
0x000000333200720bULL, 0x002fce0003f5d000ULL, 0x000000a700127306ULL, 0x000ff00000209400ULL,
0x000000a700297306ULL, 0x000e620000205400ULL, 0x000000272c00720bULL, 0x004fce0003f7d000ULL,
0x000000c900387306ULL, 0x000eb0000020d400ULL, 0x000000b700257306ULL, 0x000ee2000020d400ULL,
0x000000291200720bULL, 0x002fce0003f1d000ULL, 0x000000b600237306ULL, 0x000fe20000209400ULL,
0x0000000138382812ULL, 0x004fc800078efcffULL, 0x000000386d21723eULL, 0x000fc600000010ffULL,
0x000000b600227306ULL, 0x000e620000205400ULL, 0x0000000125253812ULL, 0x008fc600078efcffULL,
0x00000020345c723cULL, 0x000fe2000004185cULL, 0x000000702570723eULL, 0x000fc600000010ffULL,
0x0000003100247306ULL, 0x000fe60000209400ULL, 0x0001b61008207811ULL, 0x040fe400078e20ffULL,
0x0001b66808217811ULL, 0x000fc600078e18ffULL, 0x00000031002d7306ULL, 0x000ea20000205400ULL,
0x000000222300720bULL, 0x002fe40003f5d000ULL, 0x000000757a22723eULL, 0x000fe400000010ffULL,
0x000000723023723eULL, 0x000fc600000010ffULL, 0x000000b6002b7306ULL, 0x000e68000020d400ULL,
0x000000223458723cULL, 0x000fe80000041858ULL, 0x000000a700a77306ULL, 0x000ee2000020d400ULL,
0x0000002d2400720bULL, 0x004fce0003f7d000ULL, 0x0000003100127306ULL, 0x000ea2000020d400ULL,
0x000000012b2b2812ULL, 0x002fc800078efcffULL, 0x0000006e2b71723eULL, 0x000fe400000010ffULL,
0x00000001a7a70812ULL, 0x008fc800078efcffULL, 0x000000a76c6c723eULL, 0x000fe200000010ffULL,
0x000000703460723cULL, 0x000fe20000041860ULL, 0x0000000112123812ULL, 0x004fc800078efcffULL,
0x000000123f6d723eULL, 0x000fce00000010ffULL, 0x0000006c3434723cULL, 0x000fe20000041840ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000021ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000403237824ULL, 0x000fe200078e0208ULL, 0x0000000105127812ULL, 0x000fe200078ec0ffULL,
0x00000300ffdf7624ULL, 0x000fe200078e00ffULL, 0x000000ff15ff7812ULL, 0x000fe2000780c0ffULL,
0x0000000020ff7f8cULL, 0x0005e2000c80043fULL, 0x0000008023237811ULL, 0x000fe400078e30ffULL,
0x000000011200780cULL, 0x000fe40003f65070ULL, 0x00000001ff127807ULL, 0x000fc40000000000ULL,
0x000000022300720cULL, 0x000fe40003f06070ULL, 0xffffffffdfdf7811ULL, 0x000fe400078e08ffULL,
0x000000ff14ff7812ULL, 0x000fe4000784c0ffULL, 0x00000001df147807ULL, 0x000fe40005800000ULL,
0x000000011100780cULL, 0x000fe40003f25270ULL, 0x00000001ff207807ULL, 0x004fe20001000000ULL,
0x0000000105057824ULL, 0x000fe200078e0214ULL, 0x0000001512157207ULL, 0x000fc40004800000ULL,
0x0000761020147816ULL, 0x000fe40000000014ULL, 0x0000000111117812ULL, 0x000fe200078e0cffULL,
0x00004f2000000947ULL, 0x000fea0003800000ULL, 0x01b66c0016087984ULL, 0x000ea20000000800ULL,
0x8000000020057824ULL, 0x000fca00078e00ffULL, 0x8000000008ff7812ULL, 0x004fe20007804805ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x01b66c0016167984ULL, 0x000ea40000000800ULL, 0x8000000016ff7812ULL, 0x004fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000020117824ULL, 0x000fe400078e00ffULL, 0x3e000000ff057424ULL, 0x000fc800078e00ffULL,
0x0000000500087305ULL, 0x0004e4000021f000ULL, 0x3fa0000005057823ULL, 0x004fe200000100ffULL,
0x000000080000735dULL, 0x008fe40003800000ULL, 0x0000040021087984ULL, 0x000ea40000000800ULL,
0x8000000008ff7812ULL, 0x004fc40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000001fafa7824ULL, 0x000fe200078e0217ULL,
0x0000000000167919ULL, 0x000ea20000002600ULL, 0x00000300ff087624ULL, 0x000fe200078e00ffULL,
0x00000001ff227819ULL, 0x000fe20000011600ULL, 0x00006400ff147624ULL, 0x000fe200078e00ffULL,
0x00000001fa057812ULL, 0x000fe400078ec0ffULL, 0xffffffff08087811ULL, 0x000fe400078e08ffULL,
0x000000010500780cULL, 0x000fe40003f05070ULL, 0x0000030003117a10ULL, 0x000fc40007ffe0ffULL,
0x0000000108057807ULL, 0x000fe40004000000ULL, 0x0000000000087919ULL, 0x000ee20000002700ULL,
0x0000000411217824ULL, 0x002fe400078e0222ULL, 0x00000001fa057824ULL, 0x000fe400078e0205ULL,
0x0000004021217824ULL, 0x000fc600078e00ffULL, 0x000000fb0500720cULL, 0x000fe20003f06070ULL,
0x0000008016167824ULL, 0x004fca00078e00ffULL, 0x0000004016177812ULL, 0x000fce00078ef821ULL,
0x00000004ff238424ULL, 0x000fe400078e00ffULL, 0x0000000208087824ULL, 0x008fc800078e00ffULL,
0x0000640008087624ULL, 0x000fe400078e0214ULL, 0x0000000406147c24ULL, 0x020fe4000f8e0217ULL,
0x0000000108168824ULL, 0x000fe400078e0205ULL, 0x000020000b087824ULL, 0x000fe400078e00ffULL,
0xffffffffff067424ULL, 0x000fe400078e00ffULL, 0x0000600016168625ULL, 0x000fe200078e0023ULL,
0x0000000111117810ULL, 0x000fc40007ffe0ffULL, 0x0000200008087812ULL, 0x000fe400078ec0ffULL,
0x0000000816068981ULL, 0x000362000c1e1900ULL, 0x000000041100720cULL, 0x000fe20003f06070ULL,
0x000000080b207824ULL, 0x000fe400078e00ffULL, 0x0000400022117824ULL, 0x000fe200078e0208ULL,
0x0000002102087217ULL, 0x000fe20007800000ULL, 0x0000000800237824ULL, 0x000fe200078e00ffULL,
0x0000000820207812ULL, 0x000fe200078ec0ffULL, 0x0000001007287824ULL, 0x000fe200078e00ffULL,
0x0001300011117810ULL, 0x000fe20007ffe0ffULL, 0x0000000108087824ULL, 0x000fe200078e0a21ULL,
0xfffffff0232a7812ULL, 0x000fe200078ec0ffULL, 0x00000000200673c2ULL, 0x0004e200000e0000ULL,
0x0000000820167812ULL, 0x002fe200078e3cffULL, 0x000000101b2d7824ULL, 0x000fe200078e0211ULL,
0x00000003ff1b7819ULL, 0x000fe20000011607ULL, 0x0000001018277824ULL, 0x100fe200078e0211ULL,
0x0001b6482a237810ULL, 0x000fe20007ffe0ffULL, 0x0000001019297824ULL, 0x100fe200078e0211ULL,
0x000000181b417810ULL, 0x000fe20007ffe0ffULL, 0x000000101a2b7824ULL, 0x100fe200078e0211ULL,
0x00000020ef207812ULL, 0x004fe200078ec0ffULL, 0x000000101c2f7824ULL, 0x100fe200078e0211ULL,
0x000000041b217810ULL, 0x000fe20007ffe0ffULL, 0x000000101d317824ULL, 0x100fe200078e0211ULL,
0x00000000230573c2ULL, 0x0002e200000e0000ULL, 0x000000101e337824ULL, 0x100fe200078e0211ULL,
0x000000141b457810ULL, 0x000fe20007ffe0ffULL, 0x000000101f397824ULL, 0x000fe200078e0211ULL,
0x0000001c1b3b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000123267824ULL, 0x000fe200078e0216ULL,
0x000000101b3f7810ULL, 0x040fe20007ffe0ffULL, 0x000000011b117824ULL, 0x140fe200078e0220ULL,
0x000000081b237810ULL, 0x002fe20007ffe0ffULL, 0x0000000141167824ULL, 0x100fe200078e0220ULL,
0x0000000c1b437810ULL, 0x000fe20007ffe0ffULL, 0x00000001211e7824ULL, 0x100fe200078e0220ULL,
0x0000007f11657812ULL, 0x000fe200078ec0ffULL, 0x00000001231c7824ULL, 0x100fe200078e0220ULL,
0x0000004008087807ULL, 0x000fe20000000000ULL, 0x0000000145187824ULL, 0x100fe200078e0220ULL,
0x0000007f16177812ULL, 0x000fe200078ec0ffULL, 0x000000013b117824ULL, 0x100fe200078e0220ULL,
0x0000007f1e477812ULL, 0x000fe200078ec0ffULL, 0x00000080ff677424ULL, 0x000fe200078e00ffULL,
0x0000000820087217ULL, 0x000fe20007800000ULL, 0x000000013f197824ULL, 0x100fe200078e0220ULL,
0x0000007f1c257812ULL, 0x000fe200078ec0ffULL, 0x00000001431a7824ULL, 0x000fe200078e0220ULL,
0x0000007f181d7812ULL, 0x000fe200078ec0ffULL, 0x0000000165167824ULL, 0x100fe200078e0214ULL,
0x0000007f111f7812ULL, 0x000fe200078ec0ffULL, 0x00000001171e7824ULL, 0x100fe200078e0214ULL,
0x0000007f19197812ULL, 0x000fe200078ec0ffULL, 0x0000000147187824ULL, 0x000fe200078e0214ULL,
0x0000007f1a117812ULL, 0x000fe200078ec0ffULL, 0x0000000108087824ULL, 0x000fe200078e0a20ULL,
0x0000007028477812ULL, 0x000fe200078ec0ffULL, 0x00005e0016167625ULL, 0x000fe200078e0067ULL,
0x0000000605057290ULL, 0x008fc4000fffe03fULL, 0x000000081b00720cULL, 0x080fe20003fa6070ULL,
0x00000001251a7824ULL, 0x100fe200078e0214ULL, 0x0000004716207210ULL, 0x000fe20007f1e0ffULL,
0x00000001191c7824ULL, 0x000fe200078e0214ULL, 0x000000082100720cULL, 0x080fe20003f86070ULL,
0x00005e001a1a7625ULL, 0x000fe200078e0067ULL, 0x000000082300720cULL, 0x000fc60003f66070ULL,
0x00005e0018187625ULL, 0x000fc800078e0067ULL, 0x0000000111117824ULL, 0x100fe200078e0214ULL,
0x0000004718227210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff217224ULL, 0x000fe200000e0617ULL,
0x000000471a247210ULL, 0x000fe20007f1e0ffULL, 0x000000011d1d7824ULL, 0x000fe400078e0214ULL,
0x00005e0011167625ULL, 0x000fe200078e0067ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020277faeULL, 0x0003e2000e901c48ULL, 0x000000084100720cULL, 0x000fe40003fa6070ULL,
0x000000ffff257224ULL, 0x000fe200000e061bULL, 0x0000004716167210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff237224ULL, 0x000fc400008e0619ULL, 0x00005e001d1a7625ULL, 0x000fc600078e0067ULL,
0x0000000022297faeULL, 0x0003e2000e101c48ULL, 0x00005e001c187625ULL, 0x000fe200078e0067ULL,
0x000000471a1a7210ULL, 0x000fe40007f5e0ffULL, 0x000000083b00720cULL, 0x000fe20003f86070ULL,
0x00005e001e1c7625ULL, 0x000fe200078e0067ULL, 0x0000004718187210ULL, 0x080fe20007f3e0ffULL,
0x00000000242b7faeULL, 0x0003e4000d901c48ULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x000000471c1c7210ULL, 0x000fe20007f1e0ffULL, 0x000000011f1f7824ULL, 0x000fc400078e0214ULL,
0x000000ffff1b7224ULL, 0x000fe200010e061bULL, 0x000000084300720cULL, 0x080fe20003f46070ULL,
0x000000ffff197224ULL, 0x000fe200008e0619ULL, 0x000000083f00720cULL, 0x080fe20003f26070ULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x000000084500720cULL, 0x000fe20003f06070ULL,
0x00005e001f1e7625ULL, 0x000fca00078e0067ULL, 0x000000471e1e7210ULL, 0x000fc60007fde0ffULL,
0x00000000162d7faeULL, 0x0003e4000d101c48ULL, 0x000000ffff1f7224ULL, 0x000fe400030e061fULL,
0x00000000182f7faeULL, 0x0003e8000c901c48ULL, 0x000000001a317faeULL, 0x0003e8000c101c48ULL,
0x000000001c337faeULL, 0x0003e8000e901c48ULL, 0x000000001e397faeULL, 0x0003e8000e101c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000040026117984ULL, 0x0004e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01b62c002a177984ULL, 0x002e620000000800ULL,
0x0000ffff15157812ULL, 0x000fc400078ec0ffULL, 0x0000ffff13087812ULL, 0x000fe400078ec0ffULL,
0x0000888015147816ULL, 0x000fe400000000ffULL, 0x0000888008157816ULL, 0x000fc600000000ffULL,
0x000000ffff087224ULL, 0x000fe400078e0014ULL, 0x8000000015147824ULL, 0x000fe400078e00ffULL,
0x8000000008087824ULL, 0x000fca00078e00ffULL, 0x8000000011ff7812ULL, 0x008fe40007804808ULL,
0x8000000017ff7812ULL, 0x002fe20007824814ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x8000000015117824ULL, 0x000fe400078e00ffULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x0000000800147305ULL, 0x0002e4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x000000140000735dULL, 0x008fe40003800000ULL,
0x01b62c002a147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fc40007824811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000004000087824ULL, 0x000fe200078e00ffULL, 0x0000007028157812ULL, 0x000fe200078ec0ffULL,
0x00000001ffac7424ULL, 0x000fe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe40000011607ULL,
0xffffff8008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c11117812ULL, 0x000fe400078ec0ffULL,
0x0000010015087810ULL, 0x000fca0007ffe008ULL, 0x0000000111087824ULL, 0x000fca00078e0208ULL,
0x01b0000008147984ULL, 0x000e680000000800ULL, 0x01b2000008117984ULL, 0x0007220000000800ULL,
0x000000091400720bULL, 0x002fda0003f3d000ULL, 0x0000000000157806ULL, 0x000fc800008e0100ULL,
0x0000ffff15167812ULL, 0x000fda000782c0ffULL, 0x000003b000009947ULL, 0x000fea0003800000ULL,
0x0000001409177209ULL, 0x058fe40007810000ULL, 0x000000091400720bULL, 0x000fe40003f54000ULL,
0x00000002ff187819ULL, 0x000fe20000011607ULL, 0x8000001709087221ULL, 0x000fe20000010000ULL,
0x0000000200097811ULL, 0x000fe400078ff8ffULL, 0x00000008181a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b08157820ULL, 0x000fe20000410000ULL, 0x000000000900720cULL, 0x000fca0003f25270ULL,
0x0000000000087806ULL, 0x000fe200010e0100ULL, 0x0000001500157308ULL, 0x000e660000000800ULL,
0x0000ffff08097812ULL, 0x000fc800078e3cffULL, 0x0000000916ff7212ULL, 0x000fe4000784c0ffULL,
0x0000007028199812ULL, 0x000fe400078ec0ffULL, 0x00000001ff099819ULL, 0x000fe40000011607ULL,
0x00000001ffac7807ULL, 0x000fe20001000000ULL, 0x0000008000169824ULL, 0x000fe200078e0219ULL,
0x0000000c09099812ULL, 0x000fe200078ec0ffULL, 0x00001f1815087589ULL, 0x002e6200000e0000ULL,
0x000000150a0a7220ULL, 0x000fc60000410000ULL, 0x0000000109169824ULL, 0x000fe400078e0216ULL,
0x00001f1a15097589ULL, 0x000ee200000e0000ULL, 0x8000001714142221ULL, 0x000fc60000010000ULL,
0x01b4001716009388ULL, 0x0009e20000000800ULL, 0x3fb8aa3b14142820ULL, 0x000fc80000410000ULL,
0x00000014000c2308ULL, 0x000ea20000000800ULL, 0x0000000848487220ULL, 0x082fe40000410000ULL,
0x0000000849497220ULL, 0x080fe40000410000ULL, 0x000000084c4c7220ULL, 0x000fe40000410000ULL,
0x000000094a4a7220ULL, 0x088fe40000410000ULL, 0x000000094b4b7220ULL, 0x080fe40000410000ULL,
0x000000094e4e7220ULL, 0x000fc40000410000ULL, 0x000000094f4f7220ULL, 0x080fe40000410000ULL,
0x0000000952527220ULL, 0x080fe40000410000ULL, 0x0000000953537220ULL, 0x080fe40000410000ULL,
0x0000000956567220ULL, 0x080fe40000410000ULL, 0x0000000957577220ULL, 0x080fe40000410000ULL,
0x000000095a5a7220ULL, 0x000fc40000410000ULL, 0x000000095b5b7220ULL, 0x080fe40000410000ULL,
0x000000095e5e7220ULL, 0x080fe40000410000ULL, 0x000000095f5f7220ULL, 0x080fe40000410000ULL,
0x0000000962627220ULL, 0x080fe40000410000ULL, 0x0000000963637220ULL, 0x080fe40000410000ULL,
0x0000000936367220ULL, 0x000fc40000410000ULL, 0x0000000937377220ULL, 0x000fe40000410000ULL,
0x000000084d4d7220ULL, 0x080fe40000410000ULL, 0x0000000850507220ULL, 0x080fe40000410000ULL,
0x0000000851517220ULL, 0x080fe40000410000ULL, 0x0000000854547220ULL, 0x080fe40000410000ULL,
0x0000000855557220ULL, 0x000fc40000410000ULL, 0x0000000858587220ULL, 0x080fe40000410000ULL,
0x0000000859597220ULL, 0x080fe40000410000ULL, 0x000000085c5c7220ULL, 0x080fe40000410000ULL,
0x000000085d5d7220ULL, 0x080fe40000410000ULL, 0x0000000860607220ULL, 0x080fe40000410000ULL,
0x0000000861617220ULL, 0x000fc40000410000ULL, 0x0000000834347220ULL, 0x080fe40000410000ULL,
0x0000000835357220ULL, 0x000fe40000410000ULL, 0x000000ffff097224ULL, 0x000fe400078e0017ULL,
0x000000110c112220ULL, 0x004fc80000410000ULL, 0x0000000a110a7221ULL, 0x018fe20000010000ULL,
0x0000018000000947ULL, 0x000fea0003800000ULL, 0x0000000001147983ULL, 0x000ee20000100800ULL,
0x000000080b087824ULL, 0x040fe200078e00ffULL, 0x000000010b00780cULL, 0x000fe20003f05270ULL,
0x0000000800117824ULL, 0x000fc600078e00ffULL, 0x0000000808087812ULL, 0x000fe400078e0cffULL,
0xfffffff011117812ULL, 0x000fca00078ec0ffULL, 0x0000000111087824ULL, 0x000fcc00078e0208ULL,
0x01b64c0008087984ULL, 0x000e620000000800ULL, 0x0000001412117207ULL, 0x008fc80004000000ULL,
0x0000ffff11117812ULL, 0x000fc800078ec0ffULL, 0x0000888011147816ULL, 0x000fca00000000ffULL,
0x8000000014117824ULL, 0x000fca00078e00ffULL, 0x8000000008ff7812ULL, 0x002fe20007804811ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000014147824ULL, 0x000fe400078e00ffULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800117305ULL, 0x0002e4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x008fe40003800000ULL, 0x0000040026117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007804814ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000020000b117824ULL, 0x000fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fe40000011600ULL, 0x0000000807157812ULL, 0x000fe400078ec0ffULL,
0x0000200011117812ULL, 0x000fe200078e0cffULL, 0x00000800083d7824ULL, 0x000fe200078e023dULL,
0x0000000715197812ULL, 0x000fc600078ef807ULL, 0x0000400008117824ULL, 0x000fe200078e0211ULL,
0x0000008019177811ULL, 0x040fe200078e18ffULL, 0x0000000819157824ULL, 0x000fc600078e0210ULL,
0x0001300011407810ULL, 0x000fe20007ffe0ffULL, 0x0000000819117824ULL, 0x000fc800078e020eULL,
0x0000001015387824ULL, 0x100fe400078e0240ULL, 0x0000001011647824ULL, 0x100fe400078e0240ULL,
0x000000100f247824ULL, 0x000fe400078e0240ULL, 0x000000003838783bULL, 0x000e680000004200ULL,
0x000000006464783bULL, 0x000ee80000004200ULL, 0x000000002424783bULL, 0x004fe20000004200ULL,
0x00000018ff117819ULL, 0x002fe20000011438ULL, 0x0000003800747306ULL, 0x000fe20000009400ULL,
0x00000018ff157819ULL, 0x000fe2000001143aULL, 0x000001003a8b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fc40000011439ULL, 0x00000018ff167819ULL, 0x000fe4000001143bULL,
0x00000018ff8b7819ULL, 0x000fe2000001148bULL, 0x0000001100a97306ULL, 0x000ff00000209400ULL,
0x0000001100b87306ULL, 0x000e700000205400ULL, 0x00000011006c7306ULL, 0x000530000020d400ULL,
0x0000001500297306ULL, 0x000fe20000209400ULL, 0x0000000110117824ULL, 0x104fe200078e0217ULL,
0x000000b8a900720bULL, 0x002fe20003fdd000ULL, 0x000000010e177824ULL, 0x000fc400078e0217ULL,
0x0000001011307824ULL, 0x000fe200078e0240ULL, 0x00000018ff117819ULL, 0x008fe20000011464ULL,
0x0000001017177824ULL, 0x000fe200078e0240ULL, 0x0000001500957306ULL, 0x000fe60000205400ULL,
0x000000003030783bULL, 0x000e680000004200ULL, 0x00000000172c783bULL, 0x0004e20000004200ULL,
0x0000001100867306ULL, 0x000fe20000209400ULL, 0x000000016c6c6812ULL, 0x010fc400078efcffULL,
0x0000010019177811ULL, 0x004fca00078e18ffULL, 0x0000001100877306ULL, 0x000fe20000205400ULL,
0x0000000110107824ULL, 0x100fe400078e0217ULL, 0x000000010e0e7824ULL, 0x000fe400078e0217ULL,
0x0000001010207824ULL, 0x000fc600078e0240ULL, 0x00000011009a7306ULL, 0x000fe2000020d400ULL,
0x000000100e0e7824ULL, 0x100fe400078e0240ULL, 0x000000100d407824ULL, 0x000fe200078e0240ULL,
0x000000002020783bULL, 0x000ea80000004200ULL, 0x0000001500ae7306ULL, 0x0009e2000020d400ULL,
0x000000000e44783bULL, 0x000ea80000004200ULL, 0x000000004040783bULL, 0x000ea60000004200ULL,
0x0000001400a37306ULL, 0x000fe20000209400ULL, 0x00000018ff157819ULL, 0x010fc40000011466ULL,
0x00000018ff117819ULL, 0x002fe40000011430ULL, 0x00000018ff107819ULL, 0x008fc6000001142cULL,
0x0000001100cf7306ULL, 0x000ff00000209400ULL, 0x0000001000967306ULL, 0x000ff00000209400ULL,
0x00000010001e7306ULL, 0x000fe20000205400ULL, 0x00000018ff0f7819ULL, 0x004fce0000011420ULL,
0x0000001000847306ULL, 0x0003e2000020d400ULL, 0x00000018ff6d7819ULL, 0x000fe40000011447ULL,
0x00000018ff0e7819ULL, 0x000fe40000011445ULL, 0x00000018ff7e7819ULL, 0x000fe40000011441ULL,
0x00000018ff7f7819ULL, 0x000fe20000011442ULL, 0x0000001100707306ULL, 0x000fe20000205400ULL,
0x00000018ff107819ULL, 0x002fe40000011421ULL, 0x00000018ff0d7819ULL, 0x000fc40000011444ULL,
0x00000018ff827819ULL, 0x000fc60000011443ULL, 0x0000001100a67306ULL, 0x0003f0000020d400ULL,
0x0000001000d27306ULL, 0x000fe20000209400ULL, 0x00000018ff117819ULL, 0x002fce000001142dULL,
0x00000010006e7306ULL, 0x000ff00000205400ULL, 0x00000010002b7306ULL, 0x0003f0000020d400ULL,
0x0000001100907306ULL, 0x000fe20000209400ULL, 0x00000018ff107819ULL, 0x002fce0000011424ULL,
0x0000001100917306ULL, 0x000ff00000205400ULL, 0x0000001100807306ULL, 0x0003f0000020d400ULL,
0x0000001000a57306ULL, 0x000fe20000209400ULL, 0x00000018ff117819ULL, 0x002fce0000011422ULL,
0x0000001000a47306ULL, 0x000ff00000205400ULL, 0x0000001000187306ULL, 0x0003f0000020d400ULL,
0x0000001100997306ULL, 0x000fe20000209400ULL, 0x00000018ff107819ULL, 0x002fce0000011427ULL,
0x00000011006b7306ULL, 0x000ff00000205400ULL, 0x00000011001d7306ULL, 0x000ff0000020d400ULL,
0x0000001000e17306ULL, 0x000ff00000209400ULL, 0x0000001000df7306ULL, 0x000ff00000205400ULL,
0x0000001000117306ULL, 0x000ff0000020d400ULL, 0x0000006d00d77306ULL, 0x000ff00000209400ULL,
0x0000006d00d67306ULL, 0x000ff00000205400ULL, 0x0000006d00107306ULL, 0x0003f0000020d400ULL,
0x0000001400ab7306ULL, 0x000fe20000205400ULL, 0x00000100386d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe2000001146dULL, 0x00010000386d7824ULL, 0x000fe200078e00ffULL,
0x0000001400697306ULL, 0x0003f0000020d400ULL, 0x0000001500dd7306ULL, 0x000fe20000209400ULL,
0x00000018ff147819ULL, 0x002fce0000011465ULL, 0x0000001500757306ULL, 0x000ff00000205400ULL,
0x0000001500b37306ULL, 0x0003f0000020d400ULL, 0x00000014007d7306ULL, 0x000fe20000209400ULL,
0x00000018ff157819ULL, 0x002fce0000011432ULL, 0x0000001400817306ULL, 0x000ff00000205400ULL,
0x0000001400c47306ULL, 0x0003f0000020d400ULL, 0x00000015001f7306ULL, 0x000fe20000209400ULL,
0x00000018ff147819ULL, 0x002fce0000011431ULL, 0x00000015001c7306ULL, 0x000ff00000205400ULL,
0x0000001500927306ULL, 0x0003f0000020d400ULL, 0x0000007800ef7306ULL, 0x000fe20000209400ULL,
0x00000018ff157819ULL, 0x002fce000001142fULL, 0x0000007800f37306ULL, 0x000e700000205400ULL,
0x0000001400bd7306ULL, 0x000ff00000209400ULL, 0x0000001400727306ULL, 0x000fe20000205400ULL,
0x000000f3ef00720bULL, 0x002fce0003f5d000ULL, 0x0000001400a27306ULL, 0x0003f0000020d400ULL,
0x0000001500287306ULL, 0x000fe20000209400ULL, 0x00000018ff147819ULL, 0x002fce000001142eULL,
0x00000015002a7306ULL, 0x000ff00000205400ULL, 0x0000001500737306ULL, 0x0003f0000020d400ULL,
0x0000001400897306ULL, 0x000fe20000209400ULL, 0x00000018ff157819ULL, 0x002fce0000011425ULL,
0x0000001400887306ULL, 0x000ff00000205400ULL, 0x00000014007c7306ULL, 0x0003f0000020d400ULL,
0x0000000f00ad7306ULL, 0x000fe20000209400ULL, 0x00000018ff147819ULL, 0x002fce0000011423ULL,
0x0000000f007b7306ULL, 0x000ff00000205400ULL, 0x0000000f006f7306ULL, 0x000ff0000020d400ULL,
0x0000001500947306ULL, 0x000ff00000209400ULL, 0x0000001500937306ULL, 0x000ff00000205400ULL,
0x00000015000f7306ULL, 0x000ff0000020d400ULL, 0x0000000e00cc7306ULL, 0x000ff00000209400ULL,
0x0000000e00cb7306ULL, 0x000ff00000205400ULL, 0x0000000e00157306ULL, 0x000ff0000020d400ULL,
0x0000007e00f87306ULL, 0x000ff00000209400ULL, 0x0000007e00e87306ULL, 0x000ff00000205400ULL,
0x0000007e000e7306ULL, 0x0003f0000020d400ULL, 0x00000014008a7306ULL, 0x000fe20000209400ULL,
0x00000018ff7e7819ULL, 0x002fce000001146dULL, 0x00000014009b7306ULL, 0x000ff00000205400ULL,
0x00000014001b7306ULL, 0x0003f0000020d400ULL, 0x0000003800c17306ULL, 0x000ea20000005400ULL,
0x00000018ff147819ULL, 0x002fce0000011446ULL, 0x00000038007a7306ULL, 0x000e70000000d400ULL,
0x0000007800387306ULL, 0x000ee2000020d400ULL, 0x000000c17400720bULL, 0x004fce0003f7d000ULL,
0x0000007e00db7306ULL, 0x000fec0000209400ULL, 0x000000017a7a3812ULL, 0x002fe400078efcffULL,
0x0000007e00dc7306ULL, 0x000e620000205400ULL, 0x0000000138382812ULL, 0x008fe400078efcffULL,
0x000000aba300720bULL, 0x000fc40003f7d000ULL, 0x0000007a3838723eULL, 0x000fc600000010ffULL,
0x0000001400d57306ULL, 0x000ff00000209400ULL, 0x0000001400d17306ULL, 0x000fe20000205400ULL,
0x000000dcdb00720bULL, 0x002fe40003f5d000ULL, 0x0000000169693812ULL, 0x000fc400078efcffULL,
0x000000952900720bULL, 0x000fe20003f7d000ULL, 0x0001000032297824ULL, 0x000fe400078e00ffULL,
0x0000001400197306ULL, 0x000ff0000020d400ULL, 0x0000007f00e57306ULL, 0x000fe40000209400ULL,
0x00000001aeae3812ULL, 0x000fcc00078efcffULL, 0x0000007f00e47306ULL, 0x000ff00000205400ULL,
0x0000007f00147306ULL, 0x0003f0000020d400ULL, 0x00000016008e7306ULL, 0x000fe20000209400ULL,
0x00000100397f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000001600857306ULL, 0x000ff00000205400ULL, 0x0000001600777306ULL, 0x0003f0000020d400ULL,
0x0000007e006d7306ULL, 0x0004e2000020d400ULL, 0x00000018ff167819ULL, 0x002fce0000011467ULL,
0x0000001600767306ULL, 0x000fe20000209400ULL, 0x000001003b7e7824ULL, 0x004fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000001600717306ULL, 0x000fe20000205400ULL,
0x000000016d6d2812ULL, 0x008fce00078efcffULL, 0x00000016003f7306ULL, 0x0003f0000020d400ULL,
0x0000007f00ca7306ULL, 0x000fe20000209400ULL, 0x00000018ff167819ULL, 0x002fce0000011433ULL,
0x0000007f00d37306ULL, 0x000e700000205400ULL, 0x0000001600977306ULL, 0x000ff00000209400ULL,
0x00000016009e7306ULL, 0x000fe20000205400ULL, 0x000000d3ca00720bULL, 0x002fce0003f5d000ULL,
0x00000016008c7306ULL, 0x0003f0000020d400ULL, 0x0000000d00c67306ULL, 0x000fe20000209400ULL,
0x00000018ff167819ULL, 0x002fce0000011426ULL, 0x0000000d00c57306ULL, 0x000ff00000205400ULL,
0x0000000d001a7306ULL, 0x0003f0000020d400ULL, 0x0000001600da7306ULL, 0x000fe20000209400ULL,
0x00000018ff0d7819ULL, 0x002fce0000011440ULL, 0x0000001600d87306ULL, 0x000ff00000205400ULL,
0x0000001600177306ULL, 0x000ff0000020d400ULL, 0x0000000d00fa7306ULL, 0x000ff00000209400ULL,
0x0000000d00f97306ULL, 0x000ff00000205400ULL, 0x0000000d00167306ULL, 0x000ff0000020d400ULL,
0x0000008200e37306ULL, 0x000ff00000209400ULL, 0x0000008200e27306ULL, 0x000ff00000205400ULL,
0x00000082000d7306ULL, 0x0003f0000020d400ULL, 0x0000003900e77306ULL, 0x000fe20000009400ULL,
0x0001000039827824ULL, 0x002fca00078e00ffULL, 0x00000018ff827819ULL, 0x000fe40000011482ULL,
0x0000003900e67306ULL, 0x000e700000005400ULL, 0x0000003900797306ULL, 0x000ff0000000d400ULL,
0x0000007f00397306ULL, 0x0004e2000020d400ULL, 0x000000e6e700720bULL, 0x002fce0003f3d000ULL,
0x0000008b009c7306ULL, 0x000fe20000209400ULL, 0x00000100647f7824ULL, 0x004fca00078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000008b00a17306ULL, 0x000e620000205400ULL,
0x0000000139392812ULL, 0x008fe400078efcffULL, 0x0000000179791812ULL, 0x000fc800078efcffULL,
0x000000793939723eULL, 0x000fe200000010ffULL, 0x0000008b00d97306ULL, 0x000eb0000020d400ULL,
0x0000007e00b57306ULL, 0x000fe20000209400ULL, 0x000000a19c00720bULL, 0x002fce0003f5d000ULL,
0x0000007e00c97306ULL, 0x000e6c0000205400ULL, 0x00000001d9d92812ULL, 0x004fe400078efcffULL,
0x0000003a00ee7306ULL, 0x000ff00000009400ULL, 0x0000003a00aa7306ULL, 0x000ea20000005400ULL,
0x000000c9b500720bULL, 0x002fce0003f5d000ULL, 0x0000003a00b97306ULL, 0x0003f0000000d400ULL,
0x0000007e00ba7306ULL, 0x000722000020d400ULL, 0x000100003a3a7824ULL, 0x002fe200078e00ffULL,
0x000000aaee00720bULL, 0x004fc80003f1d000ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000007f00af7306ULL, 0x000fe20000209400ULL, 0x00000100657e7824ULL, 0x008fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000003a008f7306ULL, 0x000fe20000209400ULL,
0x00000001baba2812ULL, 0x010fe400078efcffULL, 0x00000001b9b90812ULL, 0x000fe400078efcffULL,
0x000000858e00720bULL, 0x000fc60003f1d000ULL, 0x0000003a00b67306ULL, 0x000e700000205400ULL,
0x0000003a00b27306ULL, 0x0004e4000020d400ULL, 0x0000000177770812ULL, 0x000fc400078efcffULL,
0x000000878600720bULL, 0x000fe20003f1d000ULL, 0x000100002c877824ULL, 0x000fc600078e00ffULL,
0x0000007f00b07306ULL, 0x000f220000205400ULL, 0x000000b68f00720bULL, 0x002fe20003f5d000ULL,
0x00000100663a7824ULL, 0x004fca00078e00ffULL, 0x00000018ffc27819ULL, 0x000fe2000001143aULL,
0x0000007f00ce7306ULL, 0x000e62000020d400ULL, 0x000000019a9a0812ULL, 0x000fca00078efcffULL,
0x00000001b2b22812ULL, 0x008fe400078efcffULL, 0x0000007e009f7306ULL, 0x000fe20000209400ULL,
0x000000b0af00720bULL, 0x010fce0003f5d000ULL, 0x0000007e00ec7306ULL, 0x000eac0000205400ULL,
0x00000001cece2812ULL, 0x002fe400078efcffULL, 0x0000006400d07306ULL, 0x000ff00000009400ULL,
0x0000006400d47306ULL, 0x000e620000005400ULL, 0x000000ec9f00720bULL, 0x004fc40003f5d000ULL,
0x00000018ffec7819ULL, 0x000fca0000011487ULL, 0x00000064006a7306ULL, 0x0004f0000000d400ULL,
0x0000007e00cd7306ULL, 0x000f22000020d400ULL, 0x0001000064647824ULL, 0x004fe200078e00ffULL,
0x000000d4d000720bULL, 0x002fc80003f9d000ULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x0000003b00a87306ULL, 0x000fee0000009400ULL, 0x000000016a6a4812ULL, 0x008fe200078efcffULL,
0x0000006400bf7306ULL, 0x000fe20000209400ULL, 0x00000001cdcd2812ULL, 0x010fc400078efcffULL,
0x000000817d00720bULL, 0x000fe20003f9d000ULL, 0x000001002f7d7824ULL, 0x000fc800078e00ffULL,
0x0000006400eb7306ULL, 0x000e700000205400ULL, 0x0000003b00a77306ULL, 0x000ea20000005400ULL,
0x00000001c4c44812ULL, 0x000fce00078efcffULL, 0x0000003b00b17306ULL, 0x000722000000d400ULL,
0x000000ebbf00720bULL, 0x002fce0003f5d000ULL, 0x0000008200b47306ULL, 0x000fe20000209400ULL,
0x000100003b3b7824ULL, 0x008fe200078e00ffULL, 0x000000a7a800720bULL, 0x004fe20003fbd000ULL,
0x0001000030a77824ULL, 0x000fc600078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000008200be7306ULL, 0x000e620000205400ULL, 0x00000018ffef7819ULL, 0x000fcc00000114a7ULL,
0x00000001b1b15812ULL, 0x010fe200078efcffULL, 0x0000008200787306ULL, 0x000ff0000020d400ULL,
0x0000006400c87306ULL, 0x0004e2000020d400ULL, 0x000000beb400720bULL, 0x002fce0003fdd000ULL,
0x000000c200827306ULL, 0x000fe20000209400ULL, 0x0001000066647824ULL, 0x004fca00078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x000000c200bb7306ULL, 0x000e620000205400ULL,
0x00000001c8c82812ULL, 0x008fe400078efcffULL, 0x0000000178786812ULL, 0x000fca00078efcffULL,
0x0000003b00e07306ULL, 0x000ff00000209400ULL, 0x0000003b00f17306ULL, 0x000ea20000205400ULL,
0x000000bb8200720bULL, 0x002fce0003f5d000ULL, 0x0000003b00b77306ULL, 0x0002f0000020d400ULL,
0x000000c2003a7306ULL, 0x000f22000020d400ULL, 0x00000100673b7824ULL, 0x002fe200078e00ffULL,
0x000000f1e000720bULL, 0x004fc80003fbd000ULL, 0x00000018ffde7819ULL, 0x000fe4000001143bULL,
0x00000065009d7306ULL, 0x000fee0000009400ULL, 0x00000001b7b75812ULL, 0x008fe200078efcffULL,
0x000000de007e7306ULL, 0x000fe20000209400ULL, 0x000000013a3a2812ULL, 0x010fce00078efcffULL,
0x000000de007f7306ULL, 0x000e700000205400ULL, 0x0000006500837306ULL, 0x000eb00000005400ULL,
0x0000006500987306ULL, 0x000722000000d400ULL, 0x0000007f7e00720bULL, 0x002fce0003f5d000ULL,
0x000000de003b7306ULL, 0x000e62000020d400ULL, 0x0001000065657824ULL, 0x008fe200078e00ffULL,
0x000000839d00720bULL, 0x004fc80003f3d000ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000067008d7306ULL, 0x000fee0000009400ULL, 0x0000000198981812ULL, 0x010fe200078efcffULL,
0x0000006500bc7306ULL, 0x000fe20000209400ULL, 0x000000013b3b2812ULL, 0x002fc400078efcffULL,
0x00000075dd00720bULL, 0x000fca0003f5d000ULL, 0x0000006500c07306ULL, 0x000e700000205400ULL,
0x0000006500c77306ULL, 0x0004e2000020d400ULL, 0x00000001b3b32812ULL, 0x000fce00078efcffULL,
0x0000006700ed7306ULL, 0x000f220000005400ULL, 0x0001000067657824ULL, 0x004fe200078e00ffULL,
0x000000c0bc00720bULL, 0x002fc80003f3d000ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x0000006700c37306ULL, 0x0002ae000000d400ULL, 0x00000001c7c71812ULL, 0x008fe200078efcffULL,
0x0000006600a07306ULL, 0x000fe20000009400ULL, 0x0000010030677824ULL, 0x002fe200078e00ffULL,
0x000000ed8d00720bULL, 0x010fc80003f7d000ULL, 0x00000018ff677819ULL, 0x000fe40000011467ULL,
0x0000006600f27306ULL, 0x000e6e0000005400ULL, 0x00000001c3c33812ULL, 0x004fe200078efcffULL,
0x00000066008b7306ULL, 0x000ea2000000d400ULL, 0x000000717600720bULL, 0x000fc40003f7d000ULL,
0x000000c33b3b723eULL, 0x000fca00000010ffULL, 0x0000006400667306ULL, 0x000fe20000209400ULL,
0x000000f2a000720bULL, 0x002fca0003fdd000ULL, 0x000000013f3f3812ULL, 0x000fe400078efcffULL,
0x0000006400747306ULL, 0x000e620000205400ULL, 0x00000070cf00720bULL, 0x000fca0003f7d000ULL,
0x000000018b8b6812ULL, 0x004fe400078efcffULL, 0x0000006400c27306ULL, 0x000ea4000020d400ULL,
0x0000008b3a3a723eULL, 0x000fc800000010ffULL, 0x00000001a6a63812ULL, 0x000fe400078efcffULL,
0x0000006500de7306ULL, 0x000fe20000209400ULL, 0x000000746600720bULL, 0x002fce0003fdd000ULL,
0x0000006500ea7306ULL, 0x000e6c0000205400ULL, 0x00000001c2c26812ULL, 0x004fe400078efcffULL,
0x0000006500c17306ULL, 0x000eb0000020d400ULL, 0x0000006700647306ULL, 0x000fe20000209400ULL,
0x000000eade00720bULL, 0x002fce0003fdd000ULL, 0x0000006700657306ULL, 0x000e6c0000205400ULL,
0x00000001c1c16812ULL, 0x004fe400078efcffULL, 0x0000006700aa7306ULL, 0x0004f0000020d400ULL,
0x000000ef00e77306ULL, 0x000fe20000209400ULL, 0x000000656400720bULL, 0x002fe20003f5d000ULL,
0x0001000031677824ULL, 0x004fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x000000ef00e67306ULL, 0x000e6c0000205400ULL, 0x00000001aaaa2812ULL, 0x008fe400078efcffULL,
0x0000003000ee7306ULL, 0x000ff00000009400ULL, 0x0000003000f07306ULL, 0x000ea20000005400ULL,
0x000000e6e700720bULL, 0x002fce0003f5d000ULL, 0x0000003000a87306ULL, 0x0002f0000000d400ULL,
0x000000ef00a77306ULL, 0x000f22000020d400ULL, 0x0000010031307824ULL, 0x002fe200078e00ffULL,
0x000000f0ee00720bULL, 0x004fc80003fbd000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003100b87306ULL, 0x000fee0000009400ULL, 0x00000001a8a85812ULL, 0x008fe200078efcffULL,
0x0000003000dc7306ULL, 0x000fe20000209400ULL, 0x00000001a7a72812ULL, 0x010fc400078efcffULL,
0x00000072bd00720bULL, 0x000fca0003fbd000ULL, 0x0000003000f67306ULL, 0x000e700000205400ULL,
0x0000003100d07306ULL, 0x000ea20000005400ULL, 0x00000001a2a25812ULL, 0x000fce00078efcffULL,
0x0000003100a97306ULL, 0x000722000000d400ULL, 0x000000f6dc00720bULL, 0x002fce0003f5d000ULL,
0x0000003000ab7306ULL, 0x000322000020d400ULL, 0x0000010032317824ULL, 0x008fe200078e00ffULL,
0x000000d0b800720bULL, 0x004fc80003f1d000ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000006700db7306ULL, 0x000fe20000209400ULL, 0x0000010033307824ULL, 0x002fcc00078e00ffULL,
0x00000001a9a90812ULL, 0x010fe200078efcffULL, 0x0000003100d37306ULL, 0x000fe20000209400ULL,
0x00000001abab2812ULL, 0x000fce00078efcffULL, 0x0000003100d47306ULL, 0x000e700000205400ULL,
0x0000006700ef7306ULL, 0x000eb00000205400ULL, 0x0000006700a37306ULL, 0x000722000020d400ULL,
0x000000d4d300720bULL, 0x002fce0003f5d000ULL, 0x0000003200837306ULL, 0x000fe20000009400ULL,
0x00000018ff677819ULL, 0x008fe40000011430ULL, 0x000000efdb00720bULL, 0x004fca0003f7d000ULL,
0x0000003200b47306ULL, 0x000e700000005400ULL, 0x0000003200a07306ULL, 0x0004e2000000d400ULL,
0x00000001a3a33812ULL, 0x010fce00078efcffULL, 0x0000006700be7306ULL, 0x000fe20000209400ULL,
0x0001000033327824ULL, 0x004fe200078e00ffULL, 0x000000b48300720bULL, 0x002fc80003f3d000ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000006700ca7306ULL, 0x000fee0000205400ULL,
0x00000001a0a01812ULL, 0x008fe200078efcffULL, 0x00000067009c7306ULL, 0x000ff0000020d400ULL,
0x0000003300307306ULL, 0x000ff00000009400ULL, 0x0000003300677306ULL, 0x000e700000005400ULL,
0x00000033009d7306ULL, 0x0004f0000000d400ULL, 0x0000003100a17306ULL, 0x0008e2000020d400ULL,
0x000001002c337824ULL, 0x004fe200078e00ffULL, 0x000000673000720bULL, 0x002fc80003f9d000ULL,
0x00000018fff27819ULL, 0x000fe40000011433ULL, 0x0000003200b57306ULL, 0x000fe20000209400ULL,
0x00000018ff317819ULL, 0x010fcc0000011429ULL, 0x000000019d9d4812ULL, 0x008fe200078efcffULL,
0x0000003200f57306ULL, 0x000fe20000205400ULL, 0x00000001a1a12812ULL, 0x000fe400078efcffULL,
0x000000cabe00720bULL, 0x000fe40003f5d000ULL, 0x0000009e9700720bULL, 0x000fc60003f9d000ULL,
0x00000032008f7306ULL, 0x000ff0000020d400ULL, 0x0000002c00327306ULL, 0x000fe20000009400ULL,
0x000000019c9c2812ULL, 0x000fe400078efcffULL, 0x0000001c1f00720bULL, 0x000fe20003f5d000ULL,
0x00000100241f7824ULL, 0x000fe200078e00ffULL, 0x000000018c8c4812ULL, 0x000fc400078efcffULL,
0x0000001e9600720bULL, 0x000fe20003f9d000ULL, 0x0000002c00337306ULL, 0x000e700000005400ULL,
0x0000002c008d7306ULL, 0x0004e2000000d400ULL, 0x0000000192922812ULL, 0x000fc600078efcffULL,
0x0000000184844812ULL, 0x000fc800078efcffULL, 0x0000003100297306ULL, 0x000fe20000209400ULL,
0x000100002d2c7824ULL, 0x004fe200078e00ffULL, 0x000000333200720bULL, 0x002fc80003fdd000ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000003100c97306ULL, 0x000e6e0000205400ULL,
0x000000018d8d6812ULL, 0x008fe200078efcffULL, 0x0000003100957306ULL, 0x0004e2000020d400ULL,
0x000000919000720bULL, 0x000fce0003fdd000ULL, 0x0000002c009f7306ULL, 0x000fe20000209400ULL,
0x000001002d317824ULL, 0x004fe200078e00ffULL, 0x000000c92900720bULL, 0x002fc80003f3d000ULL,
0x00000018fff17819ULL, 0x000fe40000011431ULL, 0x0000002c00f07306ULL, 0x000fe20000205400ULL,
0x0000000180806812ULL, 0x000fcc00078efcffULL, 0x0000000195951812ULL, 0x008fe200078efcffULL,
0x0000002c00817306ULL, 0x0003e2000020d400ULL, 0x000000f5b500720bULL, 0x000fe40003f3d000ULL,
0x000000959292723eULL, 0x000fca00000010ffULL, 0x0000002d00317306ULL, 0x000fe20000009400ULL,
0x00000018ff2c7819ULL, 0x002fca000001147dULL, 0x000000018f8f1812ULL, 0x000fe400078efcffULL,
0x0000002c00bb7306ULL, 0x000ff00000209400ULL, 0x0000002c00bc7306ULL, 0x000e700000205400ULL,
0x0000002c007d7306ULL, 0x0004f0000020d400ULL, 0x0000002d00ee7306ULL, 0x000f220000005400ULL,
0x000100002e2c7824ULL, 0x004fe200078e00ffULL, 0x000000bcbb00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000002d00867306ULL, 0x0002ae000000d400ULL,
0x000000017d7d4812ULL, 0x008fe200078efcffULL, 0x0000002e00f37306ULL, 0x000fe20000009400ULL,
0x000001002e2d7824ULL, 0x002fe200078e00ffULL, 0x000000ee3100720bULL, 0x010fc80003f1d000ULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000002e00f47306ULL, 0x000e6e0000005400ULL,
0x0000000186860812ULL, 0x004fe200078efcffULL, 0x0000002e00837306ULL, 0x0004e2000000d400ULL,
0x000000f09f00720bULL, 0x000fce0003f1d000ULL, 0x0000002c00b47306ULL, 0x000fe20000209400ULL,
0x000100002f2e7824ULL, 0x004fe200078e00ffULL, 0x000000f4f300720bULL, 0x002fc80003f7d000ULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000002c00b87306ULL, 0x000e620000205400ULL,
0x0000000181810812ULL, 0x000fcc00078efcffULL, 0x0000000183833812ULL, 0x008fe200078efcffULL,
0x0000002c007f7306ULL, 0x0004f0000020d400ULL, 0x000000f200b67306ULL, 0x000fe20000209400ULL,
0x00000100202c7824ULL, 0x004fe200078e00ffULL, 0x000000b8b400720bULL, 0x002fc80003fdd000ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x000000f200e07306ULL, 0x000e6e0000205400ULL,
0x000000017f7f6812ULL, 0x008fe200078efcffULL, 0x0000002e00677306ULL, 0x000ff00000209400ULL,
0x0000002e00667306ULL, 0x000ea20000205400ULL, 0x000000e0b600720bULL, 0x002fce0003f5d000ULL,
0x0000002e00747306ULL, 0x0002f0000020d400ULL, 0x0000002000dd7306ULL, 0x000fe20000009400ULL,
0x00010000202e7824ULL, 0x002fe200078e00ffULL, 0x000000666700720bULL, 0x004fe20003fdd000ULL,
0x0001000026667824ULL, 0x000fc600078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x0000002000de7306ULL, 0x000e620000005400ULL, 0x00000018ff667819ULL, 0x000fcc0000011466ULL,
0x0000000174746812ULL, 0x008fe200078efcffULL, 0x0000002000757306ULL, 0x0004f0000000d400ULL,
0x0000002d00bf7306ULL, 0x000fe20000209400ULL, 0x0000010021207824ULL, 0x004fe200078e00ffULL,
0x000000dedd00720bULL, 0x002fc80003f3d000ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002d00c07306ULL, 0x000fee0000205400ULL, 0x0000000175751812ULL, 0x008fe200078efcffULL,
0x0000002d00827306ULL, 0x000fe2000020d400ULL, 0x0000007bad00720bULL, 0x000fce0003f3d000ULL,
0x000000f2008e7306ULL, 0x000e6c000020d400ULL, 0x000000016f6f1812ULL, 0x000fe400078efcffULL,
0x000000f100b07306ULL, 0x000ff00000209400ULL, 0x000000f100af7306ULL, 0x000ea20000205400ULL,
0x000000018e8e2812ULL, 0x002fc800078efcffULL, 0x0000008d8e8e723eULL, 0x000fc600000010ffULL,
0x000000f100857306ULL, 0x000e70000020d400ULL, 0x0000002f002d7306ULL, 0x000fe20000009400ULL,
0x000000afb000720bULL, 0x004fce0003f5d000ULL, 0x0000002f00d07306ULL, 0x000eac0000005400ULL,
0x0000000185852812ULL, 0x002fe400078efcffULL, 0x0000002f007e7306ULL, 0x000e70000000d400ULL,
0x000000ec00f27306ULL, 0x000fe20000209400ULL, 0x000000d02d00720bULL, 0x004fce0003fbd000ULL,
0x000000ec00f17306ULL, 0x000eac0000205400ULL, 0x000000017e7e5812ULL, 0x002fe400078efcffULL,
0x000000ec00877306ULL, 0x000e62000020d400ULL, 0x000000888900720bULL, 0x000fce0003fbd000ULL,
0x0000002c002f7306ULL, 0x000fe20000209400ULL, 0x000000f1f200720bULL, 0x004fca0003f5d000ULL,
0x000000017c7c5812ULL, 0x000fe400078efcffULL, 0x0000002c00307306ULL, 0x000ea20000205400ULL,
0x0000002a2800720bULL, 0x000fe20003fbd000ULL, 0x00010000272a7824ULL, 0x000fe200078e00ffULL,
0x0000007f7c7c723eULL, 0x000fc600000010ffULL, 0x0000000187872812ULL, 0x002fe400078efcffULL,
0x0000002c00767306ULL, 0x0002e2000020d400ULL, 0x000000c0bf00720bULL, 0x000fe40003f5d000ULL,
0x00000018ff677819ULL, 0x000fe4000001142aULL, 0x000000878484723eULL, 0x000fe400000010ffULL,
0x0000000173735812ULL, 0x000fe200078efcffULL, 0x0000002100ec7306ULL, 0x000fe20000009400ULL,
0x00010000212c7824ULL, 0x002fe200078e00ffULL, 0x000000302f00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000002100ed7306ULL, 0x000e620000005400ULL,
0x0000000182822812ULL, 0x000fc800078efcffULL, 0x000000838282723eULL, 0x000fe400000010ffULL,
0x0000000176766812ULL, 0x008fe200078efcffULL, 0x0000002100707306ULL, 0x0004e2000000d400ULL,
0x0000007e7d83723eULL, 0x000fe400000010ffULL, 0x00000074737d723eULL, 0x000fca00000010ffULL,
0x0000002000ea7306ULL, 0x000fe20000209400ULL, 0x0000010022217824ULL, 0x004fe200078e00ffULL,
0x000000edec00720bULL, 0x002fc80003f1d000ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002000eb7306ULL, 0x000fee0000205400ULL, 0x0000000170700812ULL, 0x008fe200078efcffULL,
0x0000002000727306ULL, 0x0003f0000020d400ULL, 0x0000002100dc7306ULL, 0x000fe20000209400ULL,
0x0000010023207824ULL, 0x002fca00078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002100db7306ULL, 0x000e700000205400ULL, 0x0000002100327306ULL, 0x0004f0000020d400ULL,
0x0000002c00e67306ULL, 0x000fe20000209400ULL, 0x0001000023217824ULL, 0x004fe200078e00ffULL,
0x000000dbdc00720bULL, 0x002fc80003f1d000ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002c00e77306ULL, 0x000e6e0000205400ULL, 0x0000000132320812ULL, 0x008fe200078efcffULL,
0x0000002c00337306ULL, 0x000ea2000020d400ULL, 0x0000006b9900720bULL, 0x000fce0003f1d000ULL,
0x0000002000d37306ULL, 0x000fe20000209400ULL, 0x000000e7e600720bULL, 0x002fca0003f3d000ULL,
0x000000011d1d0812ULL, 0x000fe400078efcffULL, 0x0000002000d47306ULL, 0x000fec0000205400ULL,
0x0000000133331812ULL, 0x004fe400078efcffULL, 0x00000020002c7306ULL, 0x0003f0000020d400ULL,
0x0000002100ca7306ULL, 0x000fe20000209400ULL, 0x0001000022207824ULL, 0x002fca00078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002100c97306ULL, 0x000ff00000205400ULL,
0x0000002100297306ULL, 0x0003f0000020d400ULL, 0x0000002e00647306ULL, 0x000fe20000209400ULL,
0x00000018ff217819ULL, 0x002fe2000001141fULL, 0x00010000241f7824ULL, 0x000fcc00078e00ffULL,
0x0000002e00657306ULL, 0x000e700000205400ULL, 0x0000002e00717306ULL, 0x000eb0000020d400ULL,
0x0000002000cf7306ULL, 0x000fe20000209400ULL, 0x000000656400720bULL, 0x002fce0003fbd000ULL,
0x0000002000d07306ULL, 0x000e6c0000205400ULL, 0x0000000171715812ULL, 0x004fe400078efcffULL,
0x00000020002e7306ULL, 0x000fe2000020d400ULL, 0x000000ebea00720bULL, 0x000fce0003fbd000ULL,
0x0000002100b57306ULL, 0x000fec0000209400ULL, 0x0000000172725812ULL, 0x000fe400078efcffULL,
0x0000002100b67306ULL, 0x000fe20000205400ULL, 0x0000006ed200720bULL, 0x000fce0003fbd000ULL,
0x0000002100207306ULL, 0x0005ec000020d400ULL, 0x000000012b2b5812ULL, 0x000fe400078efcffULL,
0x0000002200ee7306ULL, 0x000fe20000009400ULL, 0x0000010025217824ULL, 0x004fe200078e00ffULL,
0x000000d4d300720bULL, 0x000fcc0003fbd000ULL, 0x0000002200ef7306ULL, 0x000eae0000005400ULL,
0x000000012c2c5812ULL, 0x000fe200078efcffULL, 0x0000002200317306ULL, 0x000722000000d400ULL,
0x000000d0cf00720bULL, 0x002fce0003fbd000ULL, 0x0000002300bd7306ULL, 0x000fe20000009400ULL,
0x00000018ff227819ULL, 0x008fe4000001141fULL, 0x000000efee00720bULL, 0x004fc60003f5d000ULL,
0x000000012e2e5812ULL, 0x000fe400078efcffULL, 0x0000002300be7306ULL, 0x000e700000005400ULL,
0x00000023002d7306ULL, 0x0004e2000000d400ULL, 0x0000000131312812ULL, 0x010fc400078efcffULL,
0x0000009b8a00720bULL, 0x000fe40003f5d000ULL, 0x000000313232723eULL, 0x000fc600000010ffULL,
0x0000002200f57306ULL, 0x000fe20000209400ULL, 0x00000018ff237819ULL, 0x004fe20000011421ULL,
0x0001000025217824ULL, 0x000fe200078e00ffULL, 0x000000bebd00720bULL, 0x002fe40003f7d000ULL,
0x00000002ffbe7819ULL, 0x000fc60000011607ULL, 0x0000002200e07306ULL, 0x000e620000205400ULL,
0x00000008bebb7810ULL, 0x000fe40007ffe0ffULL, 0x000000011b1b2812ULL, 0x000fca00078efcffULL,
0x00000022001f7306ULL, 0x000ea2000020d400ULL, 0x000000012d2d3812ULL, 0x008fe400078efcffULL,
0x000000c9ca00720bULL, 0x000fca0003f7d000ULL, 0x0000002400f37306ULL, 0x000fe20000009400ULL,
0x000000e0f500720bULL, 0x002fce0003f5d000ULL, 0x0000002400f47306ULL, 0x000e620000005400ULL,
0x0000000129293812ULL, 0x000fe400078efcffULL, 0x000000b6b500720bULL, 0x000fe20003f7d000ULL,
0x0001000043b57824ULL, 0x000fe400078e00ffULL, 0x000000011f1f2812ULL, 0x004fe400078efcffULL,
0x00000024001c7306ULL, 0x0004e2000000d400ULL, 0x00000018ffb57819ULL, 0x000fce00000114b5ULL,
0x0000002300af7306ULL, 0x000fe20000209400ULL, 0x00000018ff247819ULL, 0x004fe40000011421ULL,
0x000000f4f300720bULL, 0x002fe40003f9d000ULL, 0x0000000120203812ULL, 0x000fc600078efcffULL,
0x0000002300b07306ULL, 0x000e700000205400ULL, 0x0000002300227306ULL, 0x000522000020d400ULL,
0x000000011c1c4812ULL, 0x008fc800078efcffULL, 0x0000001c201c723eULL, 0x000fc600000010ffULL,
0x0000002400f77306ULL, 0x000fe20000209400ULL, 0x0000010027237824ULL, 0x004fe200078e00ffULL,
0x000000b0af00720bULL, 0x002fcc0003f7d000ULL, 0x0000002400f67306ULL, 0x000e6e0000205400ULL,
0x0000000122223812ULL, 0x010fe200078efcffULL, 0x0000002400217306ULL, 0x0004f0000020d400ULL,
0x0000002500dd7306ULL, 0x000fe20000009400ULL, 0x00000018ff247819ULL, 0x004fc40000011423ULL,
0x000000f6f700720bULL, 0x002fca0003f5d000ULL, 0x0000002500de7306ULL, 0x000e700000005400ULL,
0x00000025001e7306ULL, 0x000522000000d400ULL, 0x0000000121212812ULL, 0x008fce00078efcffULL,
0x0000002400967306ULL, 0x000fe20000209400ULL, 0x0000010026257824ULL, 0x004fe200078e00ffULL,
0x000000dedd00720bULL, 0x002fc80003f3d000ULL, 0x00000018ff907819ULL, 0x000fe40000011425ULL,
0x0000002400977306ULL, 0x000e6e0000205400ULL, 0x000000011e1e1812ULL, 0x010fe200078efcffULL,
0x0000002400237306ULL, 0x000ea2000020d400ULL, 0x000000939400720bULL, 0x000fc40003f3d000ULL,
0x0000008f8c93723eULL, 0x000fe400000010ffULL, 0x00000086858f723eULL, 0x000fe400000010ffULL,
0x000000818085723eULL, 0x000fe200000010ffULL, 0x0000002600b47306ULL, 0x000fec0000009400ULL,
0x000000010f0f1812ULL, 0x000fc400078efcffULL, 0x0000002600b87306ULL, 0x000ee20000005400ULL,
0x000000979600720bULL, 0x002fce0003f3d000ULL, 0x0000002600247306ULL, 0x000e6c000000d400ULL,
0x0000000123231812ULL, 0x004fe400078efcffULL, 0x0000002700bf7306ULL, 0x000fe20000009400ULL,
0x000000b8b400720bULL, 0x008fe20003fbd000ULL, 0x0000010040b87824ULL, 0x000fca00078e00ffULL,
0x00000018ffc97819ULL, 0x000fe200000114b8ULL, 0x0000002700c07306ULL, 0x000ea20000005400ULL,
0x0001000042b87824ULL, 0x000fca00078e00ffULL, 0x0000000124245812ULL, 0x002fe400078efcffULL,
0x0000002700267306ULL, 0x0002e2000000d400ULL, 0x00000018ffb87819ULL, 0x000fce00000114b8ULL,
0x0000006600ee7306ULL, 0x000fe20000209400ULL, 0x0000010044277824ULL, 0x002fe200078e00ffULL,
0x000000c0bf00720bULL, 0x004fe20003f1d000ULL, 0x0000010043bf7824ULL, 0x000fe400078e00ffULL,
0x0000010042c07824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011427ULL,
0x0000040000277824ULL, 0x000fe200078e00ffULL, 0x0000006600ec7306ULL, 0x000e620000205400ULL,
0x00000018ffbf7819ULL, 0x000fe400000114bfULL, 0x00000018ffc07819ULL, 0x000fc400000114c0ULL,
0xfffff80027277812ULL, 0x000fe400078ec0ffULL, 0x0000000126260812ULL, 0x008fe200078efcffULL,
0x0000006600287306ULL, 0x000ea2000020d400ULL, 0x0001200027647810ULL, 0x000fe20007ffe068ULL,
0x0000010045687824ULL, 0x000fe200078e00ffULL, 0x0000000cff27723eULL, 0x000fe400000010ffULL,
0x000000262323723eULL, 0x000fe400000010ffULL, 0x0000541027ed7816ULL, 0x000fe20000000027ULL,
0x0000006700f17306ULL, 0x000fe20000209400ULL, 0x00000018ff687819ULL, 0x000fc40000011468ULL,
0x000000ecee00720bULL, 0x002fe20003fbd000ULL, 0x00001fbeedbe7589ULL, 0x000fe800000e0000ULL,
0x0000006700f07306ULL, 0x000fe20000205400ULL, 0x00001fbbedbb7589ULL, 0x000fee00000e0000ULL,
0x00000067002a7306ULL, 0x0003e2000020d400ULL, 0x0000000128285812ULL, 0x004fce00078efcffULL,
0x00000090009e7306ULL, 0x000fe20000209400ULL, 0x000000006464783bULL, 0x002e6e0000000200ULL,
0x00000090009f7306ULL, 0x000eb00000205400ULL, 0x0000009000257306ULL, 0x000ef0000020d400ULL,
0x0000003000917306ULL, 0x000fe20000209400ULL, 0x0000009f9e00720bULL, 0x004fce0003f7d000ULL,
0x0000003000907306ULL, 0x000eac0000205400ULL, 0x0000000125253812ULL, 0x008fe400078efcffULL,
0x00000030002f7306ULL, 0x000730000020d400ULL, 0x0000006800887306ULL, 0x000fe20000209400ULL,
0x00009910ac307816ULL, 0x008fc400000000ffULL, 0x000000909100720bULL, 0x004fe40003f1d000ULL,
0x000000ff3000720cULL, 0x000fc60003fc5270ULL, 0x0000006800897306ULL, 0x000eb00000205400ULL,
0x0000006800277306ULL, 0x0006a2000020d400ULL, 0x000000012f2f0812ULL, 0x010fe200078efcffULL,
0x000000be6464e231ULL, 0x082fe200003400ffULL, 0x000000c5c600720bULL, 0x000fe20003f1d000ULL,
0x000000be6666e231ULL, 0x000fc400003400ffULL, 0x000000bb6565e231ULL, 0x080fe400003400ffULL,
0x000000bb6767e231ULL, 0x000fe200003400ffULL, 0x0000004400bc7306ULL, 0x000fe20000009400ULL,
0x0001000044687824ULL, 0x008fe200078e00ffULL, 0x000000898800720bULL, 0x004fc80003f3d000ULL,
0x000000386448723cULL, 0x000fe20000041848ULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x0000004400bd7306ULL, 0x000e620000005400ULL, 0x000000011a1a0812ULL, 0x000fc800078efcffULL,
0x0001000045387824ULL, 0x000fe200078e00ffULL, 0x000000786939723eULL, 0x000fe200000010ffULL,
0x0000003a6460723cULL, 0x000fe20000041860ULL, 0x0000004400307306ULL, 0x000ea2000000d400ULL,
0x0000000127271812ULL, 0x000fe400078efcffULL, 0x00000018ff7a7819ULL, 0x000fe40000011438ULL,
0x0000006d6c38723eULL, 0x000fe200000010ffULL, 0x00000800083a7824ULL, 0x000fe200078e023eULL,
0x000000cbcc00720bULL, 0x000fe20003f3d000ULL, 0x0000004500ac7306ULL, 0x000fe20000009400ULL,
0x000000bdbc00720bULL, 0x002fe20003f9d000ULL, 0x00000100466c7824ULL, 0x000fc400078e00ffULL,
0x00000038644c723cULL, 0x000fe6000004184cULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x0000004500ad7306ULL, 0x000fe60000005400ULL, 0x0000010047387824ULL, 0x000fe200078e00ffULL,
0x000000b1ba39723eULL, 0x000fe400000010ffULL, 0x0000000130304812ULL, 0x004fc400078efcffULL,
0x0000004500447306ULL, 0x0003e2000000d400ULL, 0x0000000115151812ULL, 0x000fe400078efcffULL,
0x000000302f30723eULL, 0x000fca00000010ffULL, 0x0000006800ef7306ULL, 0x000fe20000209400ULL,
0x00000018ff457819ULL, 0x002fe40000011438ULL, 0x000000b9d938723eULL, 0x000fca00000010ffULL,
0x0000006800ea7306ULL, 0x000e640000205400ULL, 0x000000386450723cULL, 0x000fec0000041850ULL,
0x0000006800687306ULL, 0x000ea2000020d400ULL, 0x000000b2ae38723eULL, 0x000fe400000010ffULL,
0x000000b77739723eULL, 0x000fca00000010ffULL, 0x0000006c00787306ULL, 0x000fe20000209400ULL,
0x000000eaef00720bULL, 0x002fe20003f9d000ULL, 0x000000386454723cULL, 0x000fec0000041854ULL,
0x0000006c00797306ULL, 0x000e620000205400ULL, 0x0000006ace38723eULL, 0x000fe400000010ffULL,
0x00000098cd39723eULL, 0x000fc600000010ffULL, 0x0000000168684812ULL, 0x004fe400078efcffULL,
0x0000004600b97306ULL, 0x000fe40000009400ULL, 0x000000386458723cULL, 0x000fe20000041858ULL,
0x000000681a68723eULL, 0x000fca00000010ffULL, 0x0000004600ba7306ULL, 0x000ea20000005400ULL,
0x000000c89a38723eULL, 0x000fe200000010ffULL, 0x0001000040c87824ULL, 0x000fe200078e00ffULL,
0x000000c7c439723eULL, 0x000fe200000010ffULL, 0x0000080008c77824ULL, 0x000fe200078e023cULL,
0x000000797800720bULL, 0x002fe40003f9d000ULL, 0x00000018ffc87819ULL, 0x000fe200000114c8ULL,
0x00000046006e7306ULL, 0x0002e4000000d400ULL, 0x00000038645c723cULL, 0x000fec000004185cULL,
0x0000004700b17306ULL, 0x000fe20000009400ULL, 0x000000c13f39723eULL, 0x000fe200000010ffULL,
0x0001000046467824ULL, 0x002fe200078e00ffULL, 0x012000003d3c783bULL, 0x000e620000000200ULL,
0x000000c2b338723eULL, 0x000fc400000010ffULL, 0x000000bab900720bULL, 0x004fe40003f5d000ULL,
0x0000004700b27306ULL, 0x000ea20000005400ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x000000386464723cULL, 0x000fe20000041834ULL, 0x012000003a38783bULL, 0x000f280000000200ULL,
0x01200000c734783bULL, 0x0005220000000200ULL, 0x0000004000ae7306ULL, 0x000fe40000009400ULL,
0x000000016e6e2812ULL, 0x008fe200078efcffULL, 0x0001000041c77824ULL, 0x004fca00078e00ffULL,
0x0000004000b77306ULL, 0x000ea20000005400ULL, 0x000000b2b100720bULL, 0x000fe40003f7d000ULL,
0x00000018ffc77819ULL, 0x000fca00000114c7ULL, 0x00000040006a7306ULL, 0x000730000000d400ULL,
0x0000004600c47306ULL, 0x000fe20000209400ULL, 0x0000010041407824ULL, 0x008fe200078e00ffULL,
0x000000be3c3ce231ULL, 0x082fe200003400ffULL, 0x000000b7ae00720bULL, 0x004fe20003fbd000ULL,
0x000000be3e3ee231ULL, 0x000fc400003400ffULL, 0x000000bb3d3de231ULL, 0x080fe400003400ffULL,
0x0000004600c37306ULL, 0x000e620000205400ULL, 0x000000bb3f3fe231ULL, 0x080fe400003400ffULL,
0x000000be3838e231ULL, 0x090fe400003400ffULL, 0x000000be3a3ae231ULL, 0x080fe400003400ffULL,
0x000000be3434e231ULL, 0x080fe200003400ffULL, 0x0000004600b37306ULL, 0x000ea2000020d400ULL,
0x000000be3636e231ULL, 0x000fe200003400ffULL, 0x000000923c54723cULL, 0x040fe20000041854ULL,
0x000000bb3939e231ULL, 0x080fe200003400ffULL, 0x000000016a6a5812ULL, 0x000fe200078efcffULL,
0x000000bb3b3be231ULL, 0x080fe200003400ffULL, 0x000000e8f800720bULL, 0x000fe20003fbd000ULL,
0x000000bb3535e231ULL, 0x080fe200003400ffULL, 0x00000043008a7306ULL, 0x000fe20000009400ULL,
0x000000bb3737e231ULL, 0x000fe200003400ffULL, 0x000000a4a500720bULL, 0x000fe20003fdd000ULL,
0x0000008e3c58723cULL, 0x000fe20000041858ULL, 0x000000c3c400720bULL, 0x002fc80003f5d000ULL,
0x00000043008b7306ULL, 0x000e660000005400ULL, 0x000000843c5c723cULL, 0x000fe2000004185cULL,
0x000000010e0e5812ULL, 0x000fc600078efcffULL, 0x0000000118186812ULL, 0x000fe200078efcffULL,
0x0000004300467306ULL, 0x0007e2000000d400ULL, 0x000000adac00720bULL, 0x000fe40003fdd000ULL,
0x000000823c60723cULL, 0x000fe20000041860ULL, 0x00000001b3b32812ULL, 0x004fe400078efcffULL,
0x000000d8da00720bULL, 0x000fe40003f5d000ULL, 0x0000006c006c7306ULL, 0x000ea2000020d400ULL,
0x000000a9ab43723eULL, 0x008fc400000010ffULL, 0x00000018ffa97819ULL, 0x000fe20000011440ULL,
0x0000007c3c64723cULL, 0x000fe20000041864ULL, 0x000000a7a640723eULL, 0x000fe400000010ffULL,
0x0000000144446812ULL, 0x000fe200078efcffULL, 0x0000007a00ed7306ULL, 0x000fe20000209400ULL,
0x0000001f1818723eULL, 0x000fe400000010ffULL, 0x000000442731723eULL, 0x000fe400000010ffULL,
0x0000000117172812ULL, 0x000fc400078efcffULL, 0x0000008b8a00720bULL, 0x002fe20003f5d000ULL,
0x0000007a00eb7306ULL, 0x000e620000205400ULL, 0x000000016c6c4812ULL, 0x004fe200078efcffULL,
0x000000303858723cULL, 0x000fe20000041858ULL, 0x000000d1d500720bULL, 0x000fe40003f9d000ULL,
0x0000006e6c6c723eULL, 0x000fc600000010ffULL, 0x0000007a00697306ULL, 0x000fe8000020d400ULL,
0x0000000146462812ULL, 0x000fc800078efcffULL, 0x0000004700777306ULL, 0x0004e2000000d400ULL,
0x0000000119194812ULL, 0x000fe400078efcffULL, 0x000000f0f100720bULL, 0x000fe40003f9d000ULL,
0x000000ebed00720bULL, 0x002fe40003fdd000ULL, 0x000000b3191a723eULL, 0x000fe200000010ffULL,
0x0000004100987306ULL, 0x000fe20000009400ULL, 0x0001000047477824ULL, 0x004fe200078e00ffULL,
0x000000210f19723eULL, 0x000fc800000010ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000004100997306ULL, 0x000e620000005400ULL, 0x0000000177773812ULL, 0x008fe400078efcffULL,
0x000000d6d700720bULL, 0x000fe40003f7d000ULL, 0x000000012a2a4812ULL, 0x000fe400078efcffULL,
0x0000000169696812ULL, 0x000fe200078efcffULL, 0x00000041006b7306ULL, 0x0004e6000000d400ULL,
0x000000691569723eULL, 0x000fca00000010ffULL, 0x00000045007a7306ULL, 0x000fe20000209400ULL,
0x000000a3a241723eULL, 0x004fe200000010ffULL, 0x00000068385c723cULL, 0x000fe2000004185cULL,
0x0000000110103812ULL, 0x000fe400078efcffULL, 0x000000999800720bULL, 0x002fc60003f1d000ULL,
0x00000045007b7306ULL, 0x000e640000205400ULL, 0x000000403c4c723cULL, 0x000fec000004184cULL,
0x00000045006d7306ULL, 0x000ea4000020d400ULL, 0x000000016b6b0812ULL, 0x008fc400078efcffULL,
0x000000e4e500720bULL, 0x000fc80003f1d000ULL, 0x00000042009a7306ULL, 0x000fe20000009400ULL,
0x0000007b7a00720bULL, 0x002fce0003f3d000ULL, 0x00000042009b7306ULL, 0x000e620000005400ULL,
0x0000000114140812ULL, 0x000fca00078efcffULL, 0x000000016d6d1812ULL, 0x004fe400078efcffULL,
0x0000004200457306ULL, 0x0004e4000000d400ULL, 0x000000776d6d723eULL, 0x000fcc00000010ffULL,
0x0000004700c27306ULL, 0x000fe20000209400ULL, 0x000000a8aa42723eULL, 0x004fe200000010ffULL,
0x0000006c3860723cULL, 0x000fe20000041860ULL, 0x0000009b9a00720bULL, 0x002fca0003fdd000ULL,
0x0000004700c17306ULL, 0x000e640000205400ULL, 0x000000423c48723cULL, 0x000fec0000041848ULL,
0x000000c900b67306ULL, 0x000fe20000209400ULL, 0x000000a0a142723eULL, 0x000fe400000010ffULL,
0x0000009d9c43723eULL, 0x000fc400000010ffULL, 0x0000000145456812ULL, 0x008fc600078efcffULL,
0x000000c900a87306ULL, 0x000ea20000205400ULL, 0x000000c1c200720bULL, 0x002fe20003f3d000ULL,
0x000000423c50723cULL, 0x000fec0000041850ULL, 0x0000004700b47306ULL, 0x000e62000020d400ULL,
0x000000716f3c723eULL, 0x000fe400000010ffULL, 0x000000332b3d723eULL, 0x000fc400000010ffULL,
0x0000002d2c33723eULL, 0x000fe400000010ffULL, 0x0000002e1d2c723eULL, 0x000fe200000010ffULL,
0x000000c900477306ULL, 0x000ee2000020d400ULL, 0x000000a8b600720bULL, 0x004fe20003f7d000ULL,
0x0000003c384c723cULL, 0x040fe2000004184cULL, 0x000000291b2d723eULL, 0x000fe400000010ffULL,
0x000000757642723eULL, 0x000fe400000010ffULL, 0x000000707243723eULL, 0x000fe200000010ffULL,
0x000000a900a47306ULL, 0x000fe20000209400ULL, 0x00000001b4b41812ULL, 0x002fe200078efcffULL,
0x0000002c3854723cULL, 0x000fe20000041854ULL, 0x000000dfe100720bULL, 0x000fc40003f3d000ULL,
0x000000b4101b723eULL, 0x000fe400000010ffULL, 0x000000281710723eULL, 0x000fe200000010ffULL,
0x000000a900a27306ULL, 0x000e620000205400ULL, 0x0000000147473812ULL, 0x008fe200078efcffULL,
0x000000423848723cULL, 0x040fe20000041848ULL, 0x0000001e221d723eULL, 0x000fe400000010ffULL,
0x000000242522723eULL, 0x000fe400000010ffULL, 0x0000006a476a723eULL, 0x000fe200000010ffULL,
0x000000c800417306ULL, 0x000fe20000209400ULL, 0x0000000111111812ULL, 0x000fe200078efcffULL,
0x0000001a3864723cULL, 0x000fe20000041864ULL, 0x000000f9fa00720bULL, 0x000fc40003f3d000ULL,
0x0000002a1111723eULL, 0x000fc600000010ffULL, 0x000000c800867306ULL, 0x000ea20000205400ULL,
0x000000a2a400720bULL, 0x002fe20003f9d000ULL, 0x00000018344c723cULL, 0x040fec000004184cULL,
0x000000a900407306ULL, 0x000e62000020d400ULL, 0x0000000116161812ULL, 0x000fe200078efcffULL,
0x000000103454723cULL, 0x000fe20000041854ULL, 0x000000e2e300720bULL, 0x000fca0003f3d000ULL,
0x000000c800807306ULL, 0x000ee2000020d400ULL, 0x000000864100720bULL, 0x004fe20003f7d000ULL,
0x000000323850723cULL, 0x000fec0000041850ULL, 0x000000c7007e7306ULL, 0x000fe20000209400ULL,
0x0000000140404812ULL, 0x002fe200078efcffULL, 0x0000001c3448723cULL, 0x000fe20000041848ULL,
0x000000010d0d1812ULL, 0x000fc400078efcffULL, 0x0000006b406b723eULL, 0x000fe400000010ffULL,
0x000000010b117812ULL, 0x000fe2000782c0ffULL, 0x000000c700737306ULL, 0x000e620000205400ULL,
0x0000000180803812ULL, 0x008fc600078efcffULL, 0x0000006a3458723cULL, 0x000fe20000041858ULL,
0x000000801616723eULL, 0x000fc600000010ffULL, 0x000000c0002b7306ULL, 0x000fe80000209400ULL,
0x000000223450723cULL, 0x000fe80000041850ULL, 0x000000c0003c7306ULL, 0x000ea20000205400ULL,
0x000000737e00720bULL, 0x002fce0003f9d000ULL, 0x000000c7003f7306ULL, 0x000e70000020d400ULL,
0x000000c0002e7306ULL, 0x000ee2000020d400ULL, 0x0000003c2b00720bULL, 0x004fce0003f7d000ULL,
0x000000bf00277306ULL, 0x000fe20000209400ULL, 0x000000013f3f4812ULL, 0x002fc800078efcffULL,
0x0000003f0e17723eULL, 0x000fe400000010ffULL, 0x0001b668080e7811ULL, 0x000fe200078e18ffULL,
0x000000bf002c7306ULL, 0x000e620000205400ULL, 0x000000012e2e3812ULL, 0x008fc600078efcffULL,
0x00000016345c723cULL, 0x000fe2000004185cULL, 0x000000452e2e723eULL, 0x000fc600000010ffULL,
0x000000b800157306ULL, 0x000ff00000209400ULL, 0x000000b8001a7306ULL, 0x000ea20000205400ULL,
0x0000002c2700720bULL, 0x002fce0003f9d000ULL, 0x000000b5001b7306ULL, 0x000ff00000209400ULL,
0x000000b500187306ULL, 0x000e620000205400ULL, 0x0000001a1500720bULL, 0x004fce0003fbd000ULL,
0x000000bf002f7306ULL, 0x000eb0000020d400ULL, 0x000000b8000f7306ULL, 0x000ee2000020d400ULL,
0x000000181b00720bULL, 0x002fce0003f7d000ULL, 0x000000b500107306ULL, 0x000e62000020d400ULL,
0x000000012f2f4812ULL, 0x004fc800078efcffULL, 0x000000462f2f723eULL, 0x000fe400000010ffULL,
0x000000010f0f5812ULL, 0x008fc800078efcffULL, 0x0000000f1414723eULL, 0x000fe200000010ffULL,
0x0000002e3460723cULL, 0x000fe20000041860ULL, 0x0000000110103812ULL, 0x002fc800078efcffULL,
0x000000100d15723eULL, 0x000fe400000010ffULL, 0x0001b630080d7811ULL, 0x000fca00078e20ffULL,
0x000000143434723cULL, 0x000fe20000041864ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000000eff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000001f27983ULL, 0x000ea80000300800ULL,
0x0000080001fc7983ULL, 0x000ee20000300800ULL, 0x000000010b00780cULL, 0x000fc60003f05270ULL,
0x000000000dff7f8cULL, 0x0009e2000c80043fULL, 0x000000f212127207ULL, 0x004fc80004000000ULL,
0x000000ff12ff7812ULL, 0x000fe4000784c0ffULL, 0x000000fffcff7812ULL, 0x008fe4000780c0ffULL,
0x00000001ff129807ULL, 0x000fe40001000000ULL, 0x00000001ff147807ULL, 0x000fe40004000000ULL,
0x0000761012157816ULL, 0x000fe40000000015ULL, 0x0000030003037a10ULL, 0x010fe40007ffe0ffULL,
0x000000ff13ff7812ULL, 0x000fc4000780c0ffULL, 0x000000040300720cULL, 0x000fe40003f26070ULL,
0x00000001ff137807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff5c8000007947ULL, 0x000fea000383ffffULL, 0x00000000000d7919ULL, 0x004ea20000000000ULL,
0x0000000208027824ULL, 0x000fe200078e00ffULL, 0x00000000000479c3ULL, 0x000ee40000002500ULL,
0x0000000000007b1dULL, 0x000fe40000010000ULL, 0x0000000202037812ULL, 0x000fe200078e0cffULL,
0x0000008000027824ULL, 0x000fc600078e00ffULL, 0x0000000103037812ULL, 0x000fe200078ef800ULL,
0x000000100d057824ULL, 0x004fe200078e00ffULL, 0x00000001ff067819ULL, 0x120fe4000001160dULL,
0x00000002ff0d7819ULL, 0x000fe4000001160dULL, 0x00000070050f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c06107812ULL, 0x000fe200078ec0ffULL, 0x0000008003067824ULL, 0x000fe200078e00ffULL,
0x0001b0000f037810ULL, 0x000fc40007ffe002ULL, 0x0001b2000f057810ULL, 0x040fe40007ffe002ULL,
0x0001b0000f077810ULL, 0x140fe20007ffe006ULL, 0x0000000110027824ULL, 0x040fe200078e0203ULL,
0x0001b2000f067810ULL, 0x000fe20007ffe006ULL, 0x0000000110057824ULL, 0x000fe200078e0205ULL,
0x0000000404007c0cULL, 0x008fe2000bf03070ULL, 0x0000000110077824ULL, 0x040fe200078e0207ULL,
0x0000000902007388ULL, 0x000fe20000000800ULL, 0x0000000110067824ULL, 0x000fc600078e0206ULL,
0x0000000a05007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000007077984ULL, 0x000ea80000000800ULL, 0x0000000006067984ULL, 0x000ee20000000800ULL,
0x00000009070c7209ULL, 0x004fca0007810000ULL, 0x000000090c037221ULL, 0x000fe40000010100ULL,
0x8000000c07077221ULL, 0x000fe40000010000ULL, 0x3fb8aa3b030b7820ULL, 0x000fe40000410000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x3fb8aa3b07077820ULL, 0x000fe20000410000ULL,
0x0000000b000e7308ULL, 0x002e700000000800ULL, 0x0000000700077308ULL, 0x000ee20000000800ULL,
0x00001f0d0e027589ULL, 0x002e6200000e0000ULL, 0x0000000803097811ULL, 0x004fe200078ff0ffULL,
0x0000000706077220ULL, 0x008fc80000410000ULL, 0x00001f090e057589ULL, 0x000ea200000e0000ULL,
0x0000000a0e277223ULL, 0x000fe40000010007ULL, 0x0000004802487220ULL, 0x042fe40000410000ULL,
0x0000004902497220ULL, 0x040fe40000410000ULL, 0x0000004c024c7220ULL, 0x040fe40000410000ULL,
0x0000004d024d7220ULL, 0x040fe40000410000ULL, 0x0000005002507220ULL, 0x000fc40000410000ULL,
0x0000005102517220ULL, 0x040fe40000410000ULL, 0x0000005402547220ULL, 0x040fe40000410000ULL,
0x0000005502557220ULL, 0x040fe40000410000ULL, 0x0000005802587220ULL, 0x040fe40000410000ULL,
0x0000005902597220ULL, 0x040fe40000410000ULL, 0x0000005c025c7220ULL, 0x000fc40000410000ULL,
0x0000005d025d7220ULL, 0x040fe40000410000ULL, 0x0000006002607220ULL, 0x040fe40000410000ULL,
0x0000006102617220ULL, 0x040fe40000410000ULL, 0x0000003402347220ULL, 0x040fe40000410000ULL,
0x0000003502357220ULL, 0x000fe40000410000ULL, 0x0000004a054a7220ULL, 0x004fc40000410000ULL,
0x0000004b054b7220ULL, 0x040fe40000410000ULL, 0x0000004e054e7220ULL, 0x040fe40000410000ULL,
0x0000004f054f7220ULL, 0x040fe40000410000ULL, 0x0000005205527220ULL, 0x040fe40000410000ULL,
0x0000005305537220ULL, 0x040fe40000410000ULL, 0x0000005605567220ULL, 0x000fc40000410000ULL,
0x0000005705577220ULL, 0x040fe40000410000ULL, 0x0000005a055a7220ULL, 0x040fe40000410000ULL,
0x0000005b055b7220ULL, 0x040fe40000410000ULL, 0x0000005e055e7220ULL, 0x040fe40000410000ULL,
0x0000005f055f7220ULL, 0x040fe40000410000ULL, 0x0000006205627220ULL, 0x000fc40000410000ULL,
0x0000006305637220ULL, 0x040fe40000410000ULL, 0x0000003605367220ULL, 0x040fe40000410000ULL,
0x0000003705377220ULL, 0x000fe20000410000ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0180000027027810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e0027ULL,
0x0000bb2000097802ULL, 0x000fe40000000f00ULL, 0x0000b67000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x008fe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002700027308ULL, 0x000e640000001000ULL, 0xbf80000027037423ULL, 0x002fc80000000002ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fe40000000002ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff057624ULL, 0x000fe400078e00ffULL,
0x00006800ff047624ULL, 0x000fca00078e00ffULL, 0x0000000804057981ULL, 0x000ea8000c1e9900ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x00000002ff0b7819ULL, 0x002fe40000011603ULL,
0x0000000803097811ULL, 0x000fe200078ff0ffULL, 0x0000000205027220ULL, 0x004fca0000410000ULL,
0x00001f0b02067589ULL, 0x000e6800000e0000ULL, 0x00001f0902077589ULL, 0x000ea200000e0000ULL,
0x0000000648487220ULL, 0x082fe40000410000ULL, 0x0000000649497220ULL, 0x080fe40000410000ULL,
0x000000064c4c7220ULL, 0x080fe40000410000ULL, 0x000000064d4d7220ULL, 0x000fc40000410000ULL,
0x0000000650507220ULL, 0x080fe40000410000ULL, 0x0000000651517220ULL, 0x080fe40000410000ULL,
0x0000000654547220ULL, 0x080fe40000410000ULL, 0x0000000655557220ULL, 0x080fe40000410000ULL,
0x0000000658587220ULL, 0x080fe40000410000ULL, 0x0000000659597220ULL, 0x000fc40000410000ULL,
0x000000065c5c7220ULL, 0x080fe40000410000ULL, 0x000000065d5d7220ULL, 0x080fe40000410000ULL,
0x0000000660607220ULL, 0x080fe40000410000ULL, 0x0000000661617220ULL, 0x080fe40000410000ULL,
0x0000000634347220ULL, 0x080fe40000410000ULL, 0x0000000635357220ULL, 0x000fc40000410000ULL,
0x000000074a4a7220ULL, 0x084fe40000410000ULL, 0x000000074b4b7220ULL, 0x080fe40000410000ULL,
0x000000074e4e7220ULL, 0x080fe40000410000ULL, 0x000000074f4f7220ULL, 0x080fe40000410000ULL,
0x0000000752527220ULL, 0x080fe40000410000ULL, 0x0000000753537220ULL, 0x000fc40000410000ULL,
0x0000000756567220ULL, 0x080fe40000410000ULL, 0x0000000757577220ULL, 0x080fe40000410000ULL,
0x000000075a5a7220ULL, 0x080fe40000410000ULL, 0x000000075b5b7220ULL, 0x080fe40000410000ULL,
0x000000075e5e7220ULL, 0x080fe40000410000ULL, 0x000000075f5f7220ULL, 0x000fc40000410000ULL,
0x0000000762627220ULL, 0x080fe40000410000ULL, 0x0000000763637220ULL, 0x080fe40000410000ULL,
0x0000000736367220ULL, 0x080fe40000410000ULL, 0x0000000737377220ULL, 0x000fe40000410000ULL,
0x0000000203027812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff117819ULL, 0x100fe20000011603ULL, 0x0000002008127824ULL, 0x000fe200078e0203ULL,
0x0000000202067811ULL, 0x000fc400078ff8ffULL, 0x00000001ff047819ULL, 0x000fe40000011602ULL,
0x00000004020a7811ULL, 0x040fe400078ff8ffULL, 0x00000006020e7811ULL, 0x000fe400078ff8ffULL,
0x0000000706057812ULL, 0x100fe400078e7811ULL, 0x0000000704027812ULL, 0x100fe400078e7811ULL,
0x000000070a0d7812ULL, 0x000fe200078e7811ULL, 0x00000008110b7824ULL, 0x040fe200078e0205ULL,
0x000000070e0f7812ULL, 0x000fe200078e7811ULL, 0x0000000811077824ULL, 0x040fe200078e0202ULL,
0x0000000704047812ULL, 0x000fe200078e7809ULL, 0x00000008110d7824ULL, 0x000fe200078e020dULL,
0x000000484948723eULL, 0x000fe200000010ffULL, 0x00000008110f7824ULL, 0x000fe200078e020fULL,
0x0000004c4d24723eULL, 0x000fe200000010ffULL, 0x00001000e9057824ULL, 0x000fe200078e00ffULL,
0x0000000706067812ULL, 0x000fe200078e7809ULL, 0x0000000809117824ULL, 0x000fe200078e0204ULL,
0x0000541048167816ULL, 0x140fe20000000024ULL, 0x0000000803047824ULL, 0x000fe200078e00ffULL,
0x0000763248177816ULL, 0x000fe20000000024ULL, 0x0000080008027824ULL, 0x000fe200078e0205ULL,
0x000000505150723eULL, 0x000fe200000010ffULL, 0x0000000809137824ULL, 0x000fe200078e0206ULL,
0x0000000804047812ULL, 0x000fe200078ec0ffULL, 0x0000001007077824ULL, 0x100fe200078e0202ULL,
0x000000545528723eULL, 0x000fe200000010ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0202ULL,
0x000000070a0a7812ULL, 0x000fe200078e7809ULL, 0x0000000107077824ULL, 0x000fe200078e0204ULL,
0x0000541050067816ULL, 0x000fe20000000028ULL, 0x00000001040b7824ULL, 0x000fe200078e020bULL,
0x000000585958723eULL, 0x000fe200000010ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0202ULL,
0x0000001607007388ULL, 0x0003e20000000a00ULL, 0x0000005c5d2c723eULL, 0x000fe200000010ffULL,
0x0000000809157824ULL, 0x000fe200078e020aULL, 0x000000070e0e7812ULL, 0x000fe200078e7809ULL,
0x00000001040d7824ULL, 0x000fe200078e020dULL, 0x000000606160723eULL, 0x000fe200000010ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0202ULL, 0x000000343530723eULL, 0x000fe200000010ffULL,
0x0000000809097824ULL, 0x000fe200078e020eULL, 0x0000004a4b4a723eULL, 0x000fe200000010ffULL,
0x0000001011117824ULL, 0x100fe200078e0202ULL, 0x0000004e4f25723eULL, 0x000fe200000010ffULL,
0x0000001013137824ULL, 0x000fe200078e0202ULL, 0x0000763250077816ULL, 0x002fe20000000028ULL,
0x0000001015157824ULL, 0x100fe200078e0202ULL, 0x000000525352723eULL, 0x000fe200000010ffULL,
0x0000001009097824ULL, 0x000fe200078e0202ULL, 0x000000565729723eULL, 0x000fe200000010ffULL,
0x000000060b007388ULL, 0x0003e20000000a00ULL, 0x0000005a5b5a723eULL, 0x000fe200000010ffULL,
0x00000001040f7824ULL, 0x040fe200078e020fULL, 0x0000005e5f2d723eULL, 0x000fe200000010ffULL,
0x0000000104117824ULL, 0x040fe200078e0211ULL, 0x000000626362723eULL, 0x000fe200000010ffULL,
0x0000000104137824ULL, 0x040fe200078e0213ULL, 0x000000363731723eULL, 0x000fe200000010ffULL,
0x0000000104157824ULL, 0x000fe200078e0215ULL, 0x000054104a247816ULL, 0x000fe20000000025ULL,
0x0000000104097824ULL, 0x000fe200078e0209ULL, 0x000076324a257816ULL, 0x000fe20000000025ULL,
0x000000ff00047306ULL, 0x000fe2000020d400ULL, 0x0000541058067816ULL, 0x002fc4000000002cULL,
0x0000763258077816ULL, 0x000fe4000000002cULL, 0x0000541052287816ULL, 0x140fe40000000029ULL,
0x0000763252297816ULL, 0x000fe20000000029ULL, 0x000000060d007388ULL, 0x0003e20000000a00ULL,
0x000054105a2c7816ULL, 0x140fe4000000002dULL, 0x000076325a2d7816ULL, 0x000fe4000000002dULL,
0x0000541060067816ULL, 0x102fe20000000030ULL, 0x00000010120d7824ULL, 0x000fe200078e0205ULL,
0x0000763260077816ULL, 0x000fc40000000030ULL, 0x0000541062307816ULL, 0x140fe40000000031ULL,
0x0000763262317816ULL, 0x000fe20000000031ULL, 0x000000060f007388ULL, 0x0003e80000000a00ULL,
0x0000002411007388ULL, 0x000fe80000000a00ULL, 0x0000002813007388ULL, 0x000fe80000000a00ULL,
0x0000002c15007388ULL, 0x000fe20000000a00ULL, 0x000000ff00067306ULL, 0x002fe60000205400ULL,
0x0000003009007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff00077306ULL, 0x000e640000209400ULL, 0x000000060700720bULL, 0x002fe20003f1d000ULL,
0x000400000d207984ULL, 0x000e680000000c00ULL, 0x000c00000d147984ULL, 0x000ea80000000c00ULL,
0x000000000d187984ULL, 0x000ee80000000c00ULL, 0x0000000104040812ULL, 0x000fe200078efcffULL,
0x000800000d1c7984ULL, 0x000f260000000c00ULL, 0x000000040410723eULL, 0x000fca00000010ffULL,
0x3f803f8010237831ULL, 0x042fe40000200023ULL, 0x3f803f8010227831ULL, 0x040fe40000200022ULL,
0x3f803f8023237831ULL, 0x004fe20000200017ULL, 0x00000300ff177624ULL, 0x000fe200078e00ffULL,
0x3f803f8010217831ULL, 0x040fe40000200021ULL, 0x3f803f80101b7831ULL, 0x048fe4000020001bULL,
0x000000011700780cULL, 0x000fe20003f05270ULL, 0x3f803f80101a7831ULL, 0x000fc4000020001aULL,
0x3f803f8010197831ULL, 0x040fe40000200019ULL, 0x3f803f8010187831ULL, 0x040fe40000200018ULL,
0x3f803f8010207831ULL, 0x000fe40000200020ULL, 0x3f803f801b1b7831ULL, 0x010fe4000020001fULL,
0x3f803f801a1a7831ULL, 0x000fe4000020001eULL, 0x3f803f8019197831ULL, 0x000fc4000020001dULL,
0x3f803f8018187831ULL, 0x000fe4000020001cULL, 0x3f803f8022227831ULL, 0x000fe40000200016ULL,
0x3f803f8021217831ULL, 0x000fe20000200015ULL, 0x000000180d007388ULL, 0x0003e20000000c00ULL,
0x3f803f8020207831ULL, 0x000fca0000200014ULL, 0x000400200d007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000307000008947ULL, 0x000fea0003800000ULL,
0x0000000000167919ULL, 0x000ea20000002700ULL, 0x0000580017067a24ULL, 0x000fe200078e02ffULL,
0x0000000108ff7812ULL, 0x000fe2000780f800ULL, 0x00001000ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000000077919ULL, 0x000ea20000002600ULL, 0x00006600060e7a24ULL, 0x000fe200078e02ffULL,
0x0000004012157810ULL, 0x000fe20007ffe0ffULL, 0x00000800e9097824ULL, 0x000fe200078e00ffULL,
0x000000000d187984ULL, 0x0022e40000000c00ULL, 0x00000fff0e067811ULL, 0x000fc400078e40ffULL,
0x000400000d1c7984ULL, 0x0003220000000c00ULL, 0x0000580016167a24ULL, 0x004fc800078e0207ULL,
0x0000030016077a24ULL, 0x000fca00078e02ffULL, 0x00000004070f7c10ULL, 0x000fc8000fffe0ffULL,
0x0000000f060a7211ULL, 0x000fca00078fa0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000bULL,
0x000000090a0a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x000000ff0300720cULL, 0x000fc60000725670ULL, 0x0000001012127825ULL, 0x000fc800078e000aULL,
0x0000001015147825ULL, 0x000fe200078e000aULL, 0x01ffffff0e0a7812ULL, 0x000fe200078ec0ffULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000010030b7824ULL, 0x01afe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011603ULL, 0x00000080ff117424ULL, 0x000fe400078e00ffULL,
0x000000010f107824ULL, 0x000fe200078e020aULL, 0x000000700b0b7812ULL, 0x000fe200078ec0ffULL,
0x00006c000f0e7625ULL, 0x000fe200078e0011ULL, 0x0000000c0d0d7812ULL, 0x000fc600078ec0ffULL,
0x00006c0010107625ULL, 0x000fe200078e0011ULL, 0x0000000e0d0e7210ULL, 0x000fc80007a1e00bULL,
0x000000100d107210ULL, 0x000fe40007c7e00bULL, 0x0000000fff0f7210ULL, 0x000fe400007e44ffULL,
0x00000011ff117210ULL, 0x000fc60001fe84ffULL, 0x0000000c0e007986ULL, 0x0003e8000c101908ULL,
0x0000002710007986ULL, 0x0003e4000c101908ULL, 0x0000001812007986ULL, 0x01a3e2000c101d08ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x0000001c14007986ULL, 0x0003e8000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff0d7424ULL, 0x000fe200078e00ffULL, 0xffffffff170b7810ULL, 0x000fc60007ffe0ffULL,
0x00006a00160c7625ULL, 0x000fe200078e000dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000b0c0c79a8ULL, 0x000ea400099ee1c8ULL,
0x0000000b0c00720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0e7807ULL, 0x000fca0000000000ULL, 0x0000000eff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff0b7984ULL, 0x000ee40000000000ULL, 0x000000ff0b00720cULL, 0x008fda0003f05270ULL,
0x00002ca000008947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff0c7819ULL, 0x000fe20000011603ULL,
0x00000010030b7824ULL, 0x000fe200078e00ffULL, 0x00000001070e7810ULL, 0x004fe20007ffe0ffULL,
0x00000080ff117424ULL, 0x000fe200078e00ffULL, 0x0000000c0c157812ULL, 0x002fe400078ec0ffULL,
0x000000700b137812ULL, 0x000fe200078ec0ffULL, 0x00006c00070c7625ULL, 0x000fc800078e0011ULL,
0x00006c000e0e7625ULL, 0x000fe200078e0011ULL, 0x0000000c150c7210ULL, 0x000fc8000791e013ULL,
0x0000000e150e7210ULL, 0x000fe40007b5e013ULL, 0x0000000dff0d7210ULL, 0x000fe400007e24ffULL,
0x0000000fff0f7210ULL, 0x000fc600017e64ffULL, 0x000000080c0b7981ULL, 0x000368000c1e1900ULL,
0x000000080e107981ULL, 0x000362000c1e1900ULL, 0x000000021700780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002070c7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e0011ULL, 0x0000000c150c7210ULL, 0x000fc8000791e013ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c127981ULL, 0x000362000c1e1900ULL,
0x000000041700780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003070c7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e0011ULL,
0x0000000c150c7210ULL, 0x000fc8000791e013ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c147981ULL, 0x000362000c1e1900ULL, 0x000000041700780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004070c7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e0011ULL, 0x0000000c150c7210ULL, 0x000fc8000791e013ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c167981ULL, 0x000362000c1e1900ULL,
0x000000061700780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005070c7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e0011ULL,
0x0000000c150c7210ULL, 0x000fc8000791e013ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c187981ULL, 0x000362000c1e1900ULL, 0x000000061700780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081700780cULL, 0x002fe40003f06070ULL,
0x00000006070c7810ULL, 0x000fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e0011ULL,
0x0000000c150c7210ULL, 0x000fe40007a3e013ULL, 0x00000007070e0810ULL, 0x000fe40007ffe0ffULL,
0x0000000dff0d7210ULL, 0x000fc60000fe44ffULL, 0x00006c000e0e0625ULL, 0x000fe400078e0011ULL,
0x000000080c1a7981ULL, 0x000366000c1e1900ULL, 0x0000000e150e0210ULL, 0x000fc80007c7e013ULL,
0x0000000fff0f0210ULL, 0x000fca0001fe84ffULL, 0x000000080e1c0981ULL, 0x000368000c1e1900ULL,
0x00000007170c7810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0e7819ULL, 0x004fc8000001160cULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x020fe400078e000bULL,
0x000000080f117824ULL, 0x040fe200078e00ffULL, 0x000000010f0f7810ULL, 0x000fc80007ffe0ffULL,
0x0000030011007a0cULL, 0x000fe40003f26070ULL, 0x0000000e0f00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x00000008110c7810ULL, 0x040fe40007ffe0ffULL,
0x00000001110d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001e0b0b7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x00000001ff157819ULL, 0x000fe20000011603ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001003137824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007013137812ULL, 0x000fc800078ec0ffULL,
0x0000000c150c7210ULL, 0x000fc80007b3e013ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c1e7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x00000009110c7810ULL, 0x042fe40007ffe0ffULL, 0x00000002110d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x000000100b0b7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x00000001ff157819ULL, 0x000fe20000011603ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007010137812ULL, 0x000fc800078ec0ffULL, 0x0000000c150c7210ULL, 0x000fc80007b3e013ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c107981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a110c7810ULL, 0x042fe40007ffe0ffULL,
0x00000003110d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x000000120b0b7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x00000001ff157819ULL, 0x000fe20000011603ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001003127824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007012137812ULL, 0x000fc800078ec0ffULL,
0x0000000c150c7210ULL, 0x000fc80007b3e013ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c127981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b110c7810ULL, 0x042fe40007ffe0ffULL, 0x00000004110d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x000000140b0b7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001003137824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007013137812ULL, 0x000fc800078ec0ffULL, 0x0000000c140c7210ULL, 0x000fc80007b3e013ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c147981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c110c7810ULL, 0x042fe40007ffe0ffULL,
0x00000005110d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x000000160b0b7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x00000001ff157819ULL, 0x000fe20000011603ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001003137824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007013137812ULL, 0x000fc800078ec0ffULL,
0x0000000c150c7210ULL, 0x000fc80007b3e013ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c167981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d110c7810ULL, 0x042fe40007ffe0ffULL, 0x00000006110d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x000000180b0b7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x00000001ff157819ULL, 0x000fe20000011603ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001003137824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007013137812ULL, 0x000fc800078ec0ffULL, 0x0000000c150c7210ULL, 0x000fc80007b3e013ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c187981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e110c7810ULL, 0x042fe40007ffe0ffULL,
0x00000007110d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001a0b0b7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x00000001ff157819ULL, 0x000fe20000011603ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001003137824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007013137812ULL, 0x000fc800078ec0ffULL,
0x0000000c150c7210ULL, 0x000fc80007b3e013ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c1a7981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f110c7810ULL, 0x002fe40007ffe0ffULL, 0x0000001c0b0b7209ULL, 0x000fe40007810000ULL,
0x000003000c007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000c130c7210ULL, 0x000fc80007a3e011ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe44ffULL, 0x000000080c1c7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x00000010030c7824ULL, 0x006fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011603ULL,
0x000000700c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0d0d7812ULL, 0x000fca00078ec0ffULL,
0x000000010d0c7824ULL, 0x000fca00078e020cULL, 0x0000000b0c007388ULL, 0x0203e40000000800ULL,
0x0000000108177824ULL, 0x000fe200078e0207ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff0b7819ULL, 0x002fe20000011600ULL,
0x0000001003007824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011603ULL,
0x00001000ff137424ULL, 0x000fe200078e00ffULL, 0x00000017060c7211ULL, 0x000fe200078fa0ffULL,
0x00002000081a7824ULL, 0x000fe200078e0205ULL, 0x00000070000e7812ULL, 0x004fe200078ec0ffULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x0000000c0d117812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fe200078e0013ULL, 0x000000010b007812ULL, 0x000fe200078ec0ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000006003137810ULL, 0x000fe20007ffe0ffULL,
0x000008000b0b7824ULL, 0x000fe200078e00ffULL, 0x000000090c0c7210ULL, 0x000fe20007f3e0ffULL,
0x00000001112b7824ULL, 0x000fe200078e020eULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000002080f8824ULL, 0x140fe200078e02e9ULL, 0x000008000b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000208118824ULL, 0x000fe200078e02e9ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000020f188824ULL, 0x100fe200078e0200ULL, 0x00000020030f7810ULL, 0x000fe20007ffe0ffULL,
0x00000002111c8824ULL, 0x000fe200078e0200ULL, 0x0000004003117810ULL, 0x000fe20007ffe0ffULL,
0x000000010a148824ULL, 0x000fe200078e0217ULL, 0x000000002b2b7984ULL, 0x000e620000000800ULL,
0x00000080ff158424ULL, 0x000fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x0000030008007a0cULL, 0x000fe20003f26070ULL,
0x00000080ff168424ULL, 0x000fc400078e00ffULL, 0x000000011a007824ULL, 0x000fe400078e020bULL,
0x00006c0014148625ULL, 0x000fc800078e0015ULL, 0x000000100f0e7825ULL, 0x000fc800078e000cULL,
0x0000001011107825ULL, 0x000fc800078e000cULL, 0x0000001013127825ULL, 0x000fc800078e000cULL,
0x00006c0017168625ULL, 0x000fc800078e0016ULL, 0x0000000818188824ULL, 0x000fe400078e0203ULL,
0x0000001003197824ULL, 0x040fe400078e0200ULL, 0x00000010030c7825ULL, 0x000fe200078e000cULL,
0x00004580181f8811ULL, 0x000fc600078e20ffULL, 0x000000081c1c8824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c197faeULL, 0x0005e2000b901c48ULL,
0x0000001003148825ULL, 0x000fc600078e0014ULL, 0x000041801c218811ULL, 0x000fe200078e20ffULL,
0x0000001003168825ULL, 0x000fe200078e0016ULL, 0x003800000e197faeULL, 0x0007e2000b901c48ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x0058000010197faeULL, 0x0009e2000b901c48ULL, 0x000000ffff0b7224ULL, 0x000fe200078e00ffULL,
0x00000000000c7805ULL, 0x004fe2000001ff00ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x0078000012197faeULL, 0x0005e2000b901c48ULL, 0x000000ffff387224ULL, 0x000fc600078e00ffULL,
0x00000000141f8faeULL, 0x000be2000b901c48ULL, 0x00000000000e7805ULL, 0x008fc6000001ff00ULL,
0x0000000016218faeULL, 0x0007e2000b901c48ULL, 0x0000000000107805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000127805ULL, 0x004fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x020fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x008fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000e0000001947ULL, 0x000fea0003800000ULL,
0x00000df000007945ULL, 0x002fe20003800000ULL, 0x000000ffff007224ULL, 0x000fe400078e00ffULL,
0x000000ffff2e7224ULL, 0x000fca00078e0008ULL, 0x000000022e3a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff417224ULL, 0x000fe200078e002eULL, 0x00000002ff547819ULL, 0x002fe20000011603ULL,
0x00000002082e7824ULL, 0x000fe200078e02e9ULL, 0x000003003a007a0cULL, 0x000fe20003f06070ULL,
0x00000040412d7824ULL, 0x000fe200078e00ffULL, 0x00000007542f7812ULL, 0x040fe200078ec0ffULL,
0x00000008543c7824ULL, 0x040fe200078e00ffULL, 0x00000054ff4a7212ULL, 0x000fe200078e33ffULL,
0x00000008542c7824ULL, 0x040fe200078e00ffULL, 0x000000802d2d7812ULL, 0x000fe200078ec0ffULL,
0x0000000854317824ULL, 0x008fe200078e00ffULL, 0x0000039000017945ULL, 0x000fe20003800000ULL,
0xfffffff83c3c7812ULL, 0x100fe200078ee22fULL, 0x0000001003437824ULL, 0x000fe200078e00ffULL,
0x000000012c3e7812ULL, 0x000fe200078ef62fULL, 0x000001002e3f7824ULL, 0x000fe200078e002dULL,
0x000000022c407812ULL, 0x000fc400078ef62fULL, 0x000000032c427812ULL, 0x140fe400078ef62fULL,
0x000000042c447812ULL, 0x140fe400078ef62fULL, 0x000000052c467812ULL, 0x140fe400078ef62fULL,
0x000000062c487812ULL, 0x000fe400078ef62fULL, 0xfffffff8314a7812ULL, 0x000fe400078ee24aULL,
0x0000000854567810ULL, 0x000fe20007ffe0ffULL, 0x000002c000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x000fe20003f24070ULL, 0x0000000107377824ULL, 0x100fe200078e023aULL,
0x00000001ff2e7819ULL, 0x000fe2000001163aULL, 0x00001000ff2d7424ULL, 0x000fe200078e00ffULL,
0x0000002003317810ULL, 0x000fc40007ffe0ffULL, 0x00000037062c7211ULL, 0x000fe400078fa0ffULL,
0x000000012e2f7812ULL, 0x000fe200078ec0ffULL, 0x000004003a2e7824ULL, 0x000fe200078e00ffULL,
0x0000004003337810ULL, 0x040fe20007ffe0ffULL, 0x00006c002c2c7625ULL, 0x000fe200078e002dULL,
0x00000060033b7810ULL, 0x000fc60007ffe0ffULL, 0x00000002084c9824ULL, 0x100fe200078e02e9ULL,
0x000000092c2c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000208309824ULL, 0x000fe400078e02e9ULL,
0x000000024c4c9824ULL, 0x100fe400078e022fULL, 0x00000002304e9824ULL, 0x000fe200078e022fULL,
0x000008002e2f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2d7224ULL, 0x000fe400000e062dULL,
0x000000010a349824ULL, 0x000fc400078e0237ULL, 0x000000011a2e7824ULL, 0x000fe400078e022fULL,
0x00000080ff359424ULL, 0x000fe400078e00ffULL, 0x00000080ff369424ULL, 0x000fe400078e00ffULL,
0x0000001003397824ULL, 0x040fe400078e022eULL, 0x00000010032e7825ULL, 0x000fc800078e002cULL,
0x0000001031307825ULL, 0x100fe200078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800002e397faeULL, 0x0003e6000b901c48ULL, 0x0000001033327825ULL, 0x100fe200078e002cULL,
0x0038000030397faeULL, 0x0003e6000b901c48ULL, 0x00006c0034349625ULL, 0x000fe200078e0035ULL,
0x0058000032397faeULL, 0x0003e6000b901c48ULL, 0x000000103b2c7825ULL, 0x000fc800078e002cULL,
0x00006c0037369625ULL, 0x000fe200078e0036ULL, 0x007800002c397faeULL, 0x0003e6000b901c48ULL,
0x000000084c3b9824ULL, 0x100fe400078e0203ULL, 0x000000084e3d9824ULL, 0x000fe400078e0203ULL,
0x0000001003349825ULL, 0x000fe200078e0034ULL, 0x000045803b3b9811ULL, 0x000fe400078e20ffULL,
0x000041803d3d9811ULL, 0x000fe200078e20ffULL, 0x0000001003369825ULL, 0x000fc400078e0036ULL,
0x00000000343b9faeULL, 0x0003e8000b901c48ULL, 0x00000000363d9faeULL, 0x0003e4000b901c48ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000001ff2e7819ULL, 0x002fe20000011603ULL, 0x0000000856327824ULL, 0x040fe200078e00ffULL,
0x0000007043507812ULL, 0x000fe200078ec0ffULL, 0x0000000856307824ULL, 0x000fe200078e00ffULL,
0x0000000c2e2f7812ULL, 0x000fe200078ec0ffULL, 0x00000400412c7824ULL, 0x000fe200078e00ffULL,
0x00000007562d7812ULL, 0x000fc400078ec0ffULL, 0x0000003f2f3f7210ULL, 0x000fe20007ffe050ULL,
0x00000008562f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8322e7812ULL, 0x100fe400078ee22dULL,
0x0000000130327812ULL, 0x140fe400078ef62dULL, 0x0000000230347812ULL, 0x140fe400078ef62dULL,
0x0000000330367812ULL, 0x140fe400078ef62dULL, 0x00000004304c7812ULL, 0x000fc400078ef62dULL,
0x00000005304e7812ULL, 0x140fe400078ef62dULL, 0x0000000630307812ULL, 0x000fe200078ef62dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180003f527984ULL, 0x000e620000000800ULL,
0x000008002c2d7812ULL, 0x000fe200078ec0ffULL, 0x00000004032c7824ULL, 0x000fe200078e00ffULL,
0x00000056ff507212ULL, 0x000fe200078e33ffULL, 0x004580003f3f7984ULL, 0x000fe20000000800ULL,
0x000001801a2d7810ULL, 0x000fe40007ffe02dULL, 0xfffffff82f507812ULL, 0x000fe400078ee250ULL,
0x0000000c2c2f7812ULL, 0x000fe200078ec0ffULL, 0x0000001036367824ULL, 0x000fc400078e022dULL,
0x000000104c4c7824ULL, 0x100fe400078e022dULL, 0x000000103c3c7824ULL, 0x100fe400078e022dULL,
0x000000103e3e7824ULL, 0x100fe400078e022dULL, 0x0000001040407824ULL, 0x100fe400078e022dULL,
0x0000001042427824ULL, 0x100fe400078e022dULL, 0x0000001044447824ULL, 0x000fc400078e022dULL,
0x0000001046467824ULL, 0x100fe400078e022dULL, 0x0000001048487824ULL, 0x100fe400078e022dULL,
0x000000104e4e7824ULL, 0x100fe400078e022dULL, 0x000000104a4a7824ULL, 0x100fe400078e022dULL,
0x0000001032327824ULL, 0x100fe400078e022dULL, 0x0000001034347824ULL, 0x000fc400078e022dULL,
0x0000001030307824ULL, 0x100fe400078e022dULL, 0x0000001050507824ULL, 0x100fe400078e022dULL,
0x000000102e2e7824ULL, 0x000fe400078e022dULL, 0x000000012f367824ULL, 0x040fe400078e0236ULL,
0x000000012f4c7824ULL, 0x000fe400078e024cULL, 0x000000013c3c7824ULL, 0x000fc400078e022fULL,
0x000000012f3e7824ULL, 0x040fe200078e023eULL, 0x0000000036367984ULL, 0x000ea20000000800ULL,
0x000000012f407824ULL, 0x040fe400078e0240ULL, 0x000000012f427824ULL, 0x040fe200078e0242ULL,
0x000000004c4c7984ULL, 0x000ee20000000800ULL, 0x000000012f447824ULL, 0x040fe400078e0244ULL,
0x000000012f467824ULL, 0x040fe200078e0246ULL, 0x000000003c3c7984ULL, 0x000f220000000800ULL,
0x000000012f487824ULL, 0x000fc400078e0248ULL, 0x000000012f4a7824ULL, 0x040fe200078e024aULL,
0x000000003e3e7984ULL, 0x000f620000000800ULL, 0x000000012f4e7824ULL, 0x040fe400078e024eULL,
0x000000012f327824ULL, 0x040fe200078e0232ULL, 0x0000000040407984ULL, 0x000f620000000800ULL,
0x000000012f347824ULL, 0x040fe400078e0234ULL, 0x000000012f307824ULL, 0x040fe200078e0230ULL,
0x0000000042427984ULL, 0x000f620000000800ULL, 0x000000012f507824ULL, 0x000fc400078e0250ULL,
0x000000012f2e7824ULL, 0x000fe200078e022eULL, 0x0000000044447984ULL, 0x000f620000000800ULL,
0x000000522b527221ULL, 0x002fc60000010100ULL, 0x0000000046467984ULL, 0x000e620000000800ULL,
0x3fb8aa3b52527820ULL, 0x000fc60000410000ULL, 0x0000000048487984ULL, 0x000e660000000800ULL,
0x0000005200527308ULL, 0x000f220000000800ULL, 0x000000004a4a7984ULL, 0x000e680000000800ULL,
0x000000004e4e7984ULL, 0x000e620000000800ULL, 0x00005410ff4f7816ULL, 0x104fe40000000036ULL,
0x00007610ff517816ULL, 0x000fe20000000036ULL, 0x000000002e2c7984ULL, 0x0004620000000800ULL,
0x00005410ff367816ULL, 0x008fc4000000004cULL, 0x00007610ff537816ULL, 0x000fe2000000004cULL,
0x0000000032327984ULL, 0x000ee20000000800ULL, 0x00005410ff357816ULL, 0x010fe2000000003cULL,
0x0000003f52317220ULL, 0x000fe40000410000ULL, 0x0000000034347984ULL, 0x000f220000000800ULL,
0x000000ffff2e7224ULL, 0x004fe200078e003aULL, 0x00005410ff377816ULL, 0x020fe2000000003eULL,
0x0000003831387221ULL, 0x000fe20000010000ULL, 0x0000000030307984ULL, 0x000ea20000000800ULL,
0x00005410ff397816ULL, 0x000fc40000000040ULL, 0x000003002e007a0cULL, 0x000fe20003f06070ULL,
0x0000000050507984ULL, 0x000f620000000800ULL, 0x00005410ff3a7816ULL, 0x000fe40000000042ULL,
0x00007610ff3c7816ULL, 0x000fe4000000003cULL, 0x00005410ff3b7816ULL, 0x000fe40000000044ULL,
0x00007610ff3e7816ULL, 0x000fe4000000003eULL, 0x00005410ff3d7816ULL, 0x002fc40000000046ULL,
0x00007610ff407816ULL, 0x000fe40000000040ULL, 0x00005410ff3f7816ULL, 0x000fe40000000048ULL,
0x00007610ff427816ULL, 0x000fe40000000042ULL, 0x00005410ff417816ULL, 0x000fe4000000004aULL,
0x00007610ff447816ULL, 0x000fe40000000044ULL, 0x00005410ff4c7816ULL, 0x000fc4000000004eULL,
0x00007610ff557816ULL, 0x000fe4000000004eULL, 0x00007610ff467816ULL, 0x000fe40000000046ULL,
0x00007610ff487816ULL, 0x000fe40000000048ULL, 0x00007610ff4a7816ULL, 0x000fe4000000004aULL,
0x00005410ff437816ULL, 0x100fe4000000002cULL, 0x00007610ff457816ULL, 0x000fc4000000002cULL,
0x00005410ff477816ULL, 0x108fe40000000032ULL, 0x00007610ff497816ULL, 0x000fe40000000032ULL,
0x00005410ff4b7816ULL, 0x110fe40000000034ULL, 0x00007610ff4d7816ULL, 0x000fe40000000034ULL,
0x00005410ff4e7816ULL, 0x104fe40000000030ULL, 0x00007610ff577816ULL, 0x000fc40000000030ULL,
0x00005410ff527816ULL, 0x120fe40000000050ULL, 0x00007610ff597816ULL, 0x000fe20000000050ULL,
0x000084927f007947ULL, 0x000fea000b800000ULL, 0x00001f54312f7589ULL, 0x0002a400000e0000ULL,
0x000084e27f007947ULL, 0x000fea000b800000ULL, 0x00001f56312c7589ULL, 0x00072400000e0000ULL,
0x0000002f352a7223ULL, 0x084fe4000001002aULL, 0x0000002f3c297223ULL, 0x080fe40000010029ULL,
0x0000002f37287223ULL, 0x080fe40000010028ULL, 0x0000002f3e277223ULL, 0x080fe40000010027ULL,
0x0000002f39267223ULL, 0x000fc40000010026ULL, 0x0000002f40257223ULL, 0x080fe40000010025ULL,
0x0000002f3a247223ULL, 0x080fe40000010024ULL, 0x0000002f42237223ULL, 0x080fe40000010023ULL,
0x0000002f3b227223ULL, 0x080fe40000010022ULL, 0x0000002f44217223ULL, 0x080fe40000010021ULL,
0x0000002f3d207223ULL, 0x000fc40000010020ULL, 0x0000002f461f7223ULL, 0x080fe4000001001fULL,
0x0000002f3f1e7223ULL, 0x080fe4000001001eULL, 0x0000002f481d7223ULL, 0x080fe4000001001dULL,
0x0000002f411c7223ULL, 0x080fe4000001001cULL, 0x0000002f4a1b7223ULL, 0x000fe4000001001bULL,
0x0000002c43197223ULL, 0x010fc40000010019ULL, 0x0000002c45187223ULL, 0x080fe40000010018ULL,
0x0000002c47177223ULL, 0x080fe40000010017ULL, 0x0000002c49167223ULL, 0x080fe40000010016ULL,
0x0000002c4b157223ULL, 0x080fe40000010015ULL, 0x0000002c4d147223ULL, 0x080fe40000010014ULL,
0x0000002c4f137223ULL, 0x000fc40000010013ULL, 0x0000002c51127223ULL, 0x080fe40000010012ULL,
0x0000002c36117223ULL, 0x080fe40000010011ULL, 0x0000002c53107223ULL, 0x080fe40000010010ULL,
0x0000002c4c0f7223ULL, 0x080fe4000001000fULL, 0x0000002c550e7223ULL, 0x080fe4000001000eULL,
0x0000002c4e0d7223ULL, 0x000fc4000001000dULL, 0x0000002c570c7223ULL, 0x080fe4000001000cULL,
0x0000002c520b7223ULL, 0x080fe4000001000bULL, 0x0000002c59007223ULL, 0x000fe20000010000ULL,
0xfffff24000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x000000ffe900720cULL, 0x000fe20003f05270ULL,
0x0000001003067824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fca00078ec0ffULL,
0x0000000103097824ULL, 0x000fe200078e0206ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000001003067824ULL, 0x002fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006037812ULL, 0x000fe400078ec0ffULL,
0x0000000c07067812ULL, 0x000fc600078ec0ffULL, 0x0000008008037824ULL, 0x000fc800078e0203ULL,
0x0000000103037824ULL, 0x000fca00078e0206ULL, 0x0049803803007388ULL, 0x0003e40000000800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800009037984ULL, 0x002e680000000800ULL,
0x004a000009067984ULL, 0x000ea20000000800ULL, 0x00000003ff037221ULL, 0x002fc80000010000ULL,
0x0000000603037221ULL, 0x004fca0000010000ULL, 0x0180000003067810ULL, 0x000fc80007ffe0ffULL,
0x7f80000006067812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0600780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e0003ULL, 0x0000eb1000097802ULL, 0x000fe40000000f00ULL,
0x0000868000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff067224ULL, 0x008fe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000300067308ULL, 0x000e640000001000ULL,
0xbf80000003077423ULL, 0x002fc80000000006ULL, 0x800000ff07077221ULL, 0x000fc80000010100ULL,
0x0000000706067223ULL, 0x000fe40000000006ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e680000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff2b7819ULL, 0x002fe40000011603ULL, 0x0000000803317811ULL, 0x008fc600078ff0ffULL,
0x00001f2b06077589ULL, 0x000e6200000e0000ULL, 0x00000031ff337212ULL, 0x000fe200078e33ffULL,
0x00000008310a7824ULL, 0x000fe400078e00ffULL, 0x00001f3106097589ULL, 0x0004e200000e0000ULL,
0x000000082b357824ULL, 0x040fe400078e00ffULL, 0xfffffff80a337812ULL, 0x000fe200078ee233ULL,
0x000000082b0a7824ULL, 0x000fc800078e00ffULL, 0x0000001033337824ULL, 0x000fe200078e0202ULL,
0x0000002bff067212ULL, 0x004fc800078e33ffULL, 0xfffffff835357812ULL, 0x000fe400078ee206ULL,
0x000000072b067812ULL, 0x000fe200078ec0ffULL, 0x0000002a072a7220ULL, 0x002fc60000410000ULL,
0x00000002061a7812ULL, 0x000fe200078e3cffULL, 0x0000002907297220ULL, 0x040fe40000410000ULL,
0x0000002807287220ULL, 0x040fe40000410000ULL, 0x0000002707277220ULL, 0x000fe20000410000ULL,
0x0000002a2929723eULL, 0x000fe200000010ffULL, 0x0000002607267220ULL, 0x040fe40000410000ULL,
0x0000002507257220ULL, 0x000fe20000410000ULL, 0x000000282727723eULL, 0x000fe200000010ffULL,
0x0000002407247220ULL, 0x000fc40000410000ULL, 0x0000002307237220ULL, 0x000fe20000410000ULL,
0x000000262525723eULL, 0x000fe200000010ffULL, 0x0000002207227220ULL, 0x040fe40000410000ULL,
0x0000002107217220ULL, 0x000fe20000410000ULL, 0x000000242323723eULL, 0x000fe200000010ffULL,
0x0000002007207220ULL, 0x040fe40000410000ULL, 0x0000001f071f7220ULL, 0x000fe20000410000ULL,
0x000000222121723eULL, 0x000fe200000010ffULL, 0x0000001e071e7220ULL, 0x000fc40000410000ULL,
0x0000001d071d7220ULL, 0x000fe20000410000ULL, 0x000000201f1f723eULL, 0x000fe200000010ffULL,
0x0000001c071c7220ULL, 0x040fe20000410000ULL, 0x0000000506207812ULL, 0x040fe200078e3cffULL,
0x0000001b07077220ULL, 0x000fe20000410000ULL, 0x0000001e1d1d723eULL, 0x000fe200000010ffULL,
0x0000001909197220ULL, 0x048fe20000410000ULL, 0x00000004061e7812ULL, 0x040fe200078e3cffULL,
0x0000001809187220ULL, 0x000fe20000410000ULL, 0x0000001c0707723eULL, 0x000fe200000010ffULL,
0x0000001709177220ULL, 0x040fe20000410000ULL, 0x00000003061c7812ULL, 0x000fe200078e3cffULL,
0x0000001609167220ULL, 0x040fe20000410000ULL, 0x000000191818723eULL, 0x000fe200000010ffULL,
0x0000001509157220ULL, 0x000fe20000410000ULL, 0x0000000731197812ULL, 0x000fe200078ec0ffULL,
0x0000001409147220ULL, 0x040fe20000410000ULL, 0x000000171616723eULL, 0x000fe200000010ffULL,
0x0000001309137220ULL, 0x000fc40000410000ULL, 0x0000001209127220ULL, 0x040fe20000410000ULL,
0x000000151414723eULL, 0x000fe200000010ffULL, 0x0000001109117220ULL, 0x040fe40000410000ULL,
0x0000001009107220ULL, 0x040fe20000410000ULL, 0x000000131212723eULL, 0x000fe200000010ffULL,
0x0000000f090f7220ULL, 0x040fe40000410000ULL, 0x0000000e090e7220ULL, 0x040fe20000410000ULL,
0x000000111010723eULL, 0x000fe200000010ffULL, 0x0000000d090d7220ULL, 0x000fc40000410000ULL,
0x0000000c090c7220ULL, 0x040fe20000410000ULL, 0x0000000f0e0e723eULL, 0x000fe200000010ffULL,
0x0000000b090b7220ULL, 0x040fe40000410000ULL, 0x0000000009007220ULL, 0x000fe20000410000ULL,
0xfffffff80a097812ULL, 0x000fe200078ee22bULL, 0x0000000831247824ULL, 0x000fe200078e00ffULL,
0x00000001060a7812ULL, 0x040fe200078e3cffULL, 0x000000082b0f7824ULL, 0x040fe200078e021cULL,
0x0000000606067812ULL, 0x000fe200078e3cffULL, 0x000000082b117824ULL, 0x040fe200078e021eULL,
0x0000000d0c0c723eULL, 0x000fe200000010ffULL, 0x000000082b0d7824ULL, 0x040fe200078e021aULL,
0x0000000b0000723eULL, 0x000fe200000010ffULL, 0x000000082b0b7824ULL, 0x000fe200078e020aULL,
0x00000002190a7812ULL, 0x000fe200078e3cffULL, 0x000000082b157824ULL, 0x000fe200078e0206ULL,
0x0000000119067812ULL, 0x000fe200078e3cffULL, 0x000000082b137824ULL, 0x000fe200078e0220ULL,
0x00000003191a7812ULL, 0x000fe200078e3cffULL, 0x0000000403227824ULL, 0x000fe200078e00ffULL,
0x00000004191c7812ULL, 0x000fe200078e3cffULL, 0x00000008311b7824ULL, 0x000fe200078e020aULL,
0x00000005191e7812ULL, 0x000fe200078e3cffULL, 0x00000008312b7824ULL, 0x000fe200078e021aULL,
0x0000000619207812ULL, 0x000fe200078e3cffULL, 0x0000000831197824ULL, 0x040fe200078e0206ULL,
0xfffffff824177812ULL, 0x000fe200078ee231ULL, 0x00000008312d7824ULL, 0x040fe200078e021cULL,
0x0000000c22247812ULL, 0x000fe200078ec0ffULL, 0x00000008312f7824ULL, 0x000fc400078e021eULL,
0x0000000831317824ULL, 0x000fe400078e0220ULL, 0x0000001009097824ULL, 0x100fe400078e0202ULL,
0x00000010350a7824ULL, 0x100fe400078e0202ULL, 0x000000100b0b7824ULL, 0x100fe400078e0202ULL,
0x000000100d0d7824ULL, 0x100fe400078e0202ULL, 0x000000100f0f7824ULL, 0x000fc400078e0202ULL,
0x0000001017177824ULL, 0x100fe400078e0202ULL, 0x0000000124067824ULL, 0x000fe400078e0209ULL,
0x0000001011117824ULL, 0x100fe400078e0202ULL, 0x0000001013137824ULL, 0x100fe200078e0202ULL,
0x0000002906007388ULL, 0x0003e20000000800ULL, 0x0000001015157824ULL, 0x100fe400078e0202ULL,
0x0000001019197824ULL, 0x000fc400078e0202ULL, 0x000000101b1b7824ULL, 0x100fe400078e0202ULL,
0x000000102b2b7824ULL, 0x100fe400078e0202ULL, 0x000000102d2d7824ULL, 0x100fe400078e0202ULL,
0x000000102f2f7824ULL, 0x100fe400078e0202ULL, 0x0000001031317824ULL, 0x000fe400078e0202ULL,
0x0000000124227824ULL, 0x000fc400078e020aULL, 0x0000000124027824ULL, 0x040fe400078e020bULL,
0x00000001240a7824ULL, 0x040fe400078e020dULL, 0x00000001241a7824ULL, 0x040fe200078e020fULL,
0x0000002702007388ULL, 0x000fe20000000800ULL, 0x00000001241c7824ULL, 0x000fe200078e0211ULL,
0x00000004040f723eULL, 0x000fe200000010ffULL, 0x00000001241e7824ULL, 0x040fe200078e0213ULL,
0x000000250a007388ULL, 0x000fe20000000800ULL, 0x0000000124207824ULL, 0x000fc400078e0215ULL,
0x0000000124177824ULL, 0x040fe200078e0217ULL, 0x000000231a007388ULL, 0x000fe20000000800ULL,
0x0000000124197824ULL, 0x040fe400078e0219ULL, 0x00000001241b7824ULL, 0x040fe200078e021bULL,
0x000000211c007388ULL, 0x000fe20000000800ULL, 0x00000001242b7824ULL, 0x040fe400078e022bULL,
0x00000001242d7824ULL, 0x040fe200078e022dULL, 0x0000001f1e007388ULL, 0x000fe20000000800ULL,
0x00000001242f7824ULL, 0x000fc400078e022fULL, 0x0000000124317824ULL, 0x040fe200078e0231ULL,
0x0000001d20007388ULL, 0x000fe20000000800ULL, 0x0000000124337824ULL, 0x000fe400078e0233ULL,
0x0000002008067824ULL, 0x002fe200078e0203ULL, 0x0000000722007388ULL, 0x000fe60000000800ULL,
0x0000001006067824ULL, 0x000fe200078e0205ULL, 0x0000001817007388ULL, 0x000fe80000000800ULL,
0x0000001619007388ULL, 0x000fe80000000800ULL, 0x000000141b007388ULL, 0x000fe80000000800ULL,
0x000000122b007388ULL, 0x000fe80000000800ULL, 0x000000102d007388ULL, 0x000fe80000000800ULL,
0x0000000e2f007388ULL, 0x000fe80000000800ULL, 0x0000000c31007388ULL, 0x000fe80000000800ULL,
0x0000000033007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000061c7984ULL, 0x000e680000000c00ULL, 0x0004000006247984ULL, 0x000ea80000000c00ULL,
0x0008000006207984ULL, 0x000ee80000000c00ULL, 0x000c000006147984ULL, 0x000f220000000c00ULL,
0x3f803f800f1f7831ULL, 0x002fc4000020001fULL, 0x3f803f800f1e7831ULL, 0x040fe4000020001eULL,
0x3f803f800f1d7831ULL, 0x040fe4000020001dULL, 0x3f803f800f1c7831ULL, 0x040fe4000020001cULL,
0x3f803f800f277831ULL, 0x044fe40000200027ULL, 0x3f803f800f267831ULL, 0x040fe40000200026ULL,
0x3f803f800f257831ULL, 0x000fc40000200025ULL, 0x3f803f800f247831ULL, 0x000fe40000200024ULL,
0x3f803f801f1f7831ULL, 0x008fe40000200023ULL, 0x3f803f801e1e7831ULL, 0x000fe40000200022ULL,
0x3f803f801d1d7831ULL, 0x000fe40000200021ULL, 0x3f803f801c1c7831ULL, 0x000fe40000200020ULL,
0x3f803f8027277831ULL, 0x010fc40000200017ULL, 0x3f803f8026267831ULL, 0x000fe20000200016ULL,
0x0000001c06007388ULL, 0x0003e20000000c00ULL, 0x3f803f8025257831ULL, 0x000fe40000200015ULL,
0x3f803f8024247831ULL, 0x000fca0000200014ULL, 0x0004002406007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000147919ULL, 0x002e620000002600ULL,
0x0000002003157810ULL, 0x040fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000ee20000002700ULL,
0x0000004003177810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x00000003ff007819ULL, 0x000fe20000011603ULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x0000006003217810ULL, 0x000fe20007ffe0ffULL, 0x00000008e9167824ULL, 0x040fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fe20000011615ULL, 0x00000008e9207824ULL, 0x040fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fe20000011617ULL, 0x00000008e9227824ULL, 0x000fe200078e00ffULL,
0x00000003ff097819ULL, 0x000fc40000011621ULL, 0x0000000704067812ULL, 0x000fe400078e4815ULL,
0x0000000707087812ULL, 0x000fe400078e4817ULL, 0x00000007090a7812ULL, 0x000fe400078e4821ULL,
0x0ffffff806067812ULL, 0x000fe400078ef815ULL, 0x0ffffff808087812ULL, 0x000fe200078ef817ULL,
0x00000010140b7824ULL, 0x002fe200078e00ffULL, 0x0ffffff80a0a7812ULL, 0x000fe200078ef821ULL,
0x0000001006067824ULL, 0x100fe200078e0205ULL, 0x00000004050472a4ULL, 0x008fe2000f8e023fULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0xfffffff00b027812ULL, 0x000fe200078ee200ULL,
0x000000100a0a7824ULL, 0x000fe200078e0205ULL, 0x0000000700007812ULL, 0x100fe200078e4803ULL,
0x0000000006107984ULL, 0x000fe20000000c00ULL, 0xfffffff8160b7812ULL, 0x100fe200078ee203ULL,
0x0000001014167824ULL, 0x000fe200078e00ffULL, 0x0ffffff800007812ULL, 0x000fe200078ef803ULL,
0x0000000008187984ULL, 0x000fe20000000c00ULL, 0x0000000402037c10ULL, 0x000fc4000ff1e0ffULL,
0xfffffff016077812ULL, 0x000fe200078ee207ULL, 0x0000001000007824ULL, 0x000fe200078e0205ULL,
0x000000000a1c7984ULL, 0x0003e20000000c00ULL, 0x0000001014057824ULL, 0x040fe200078e00ffULL,
0x0000000407077c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001014147824ULL, 0x000fe200078e00ffULL,
0x00000000000c7984ULL, 0x0044e20000000c00ULL, 0x00000008e9167824ULL, 0x000fe200078e00ffULL,
0xfffffff005047812ULL, 0x000fe400078ee204ULL, 0xfffffff014097812ULL, 0x000fe200078ee209ULL,
0x000000ffff0a7224ULL, 0x002fe200008e06ffULL, 0x00005a0007067a11ULL, 0x000fe200078240ffULL,
0x000000ffff007224ULL, 0x004fe200000e06ffULL, 0x00005a0003027a11ULL, 0x000fc400078040ffULL,
0x0000000409097c10ULL, 0x000fe4000ff5e0ffULL, 0x00005b0003037a11ULL, 0x000fe400000f4400ULL,
0x0000000404057c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff007224ULL, 0x000fe200010e06ffULL,
0x00005a0009087a11ULL, 0x000fe200078440ffULL, 0x000000100b027825ULL, 0x000fe200078e0002ULL,
0xfffffff820157812ULL, 0x000fe400078ee215ULL, 0xfffffff822177812ULL, 0x000fe200078ee217ULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x00005a0005047a11ULL, 0x000fc400078040ffULL,
0x00005b0007077a11ULL, 0x000fe400008f440aULL, 0x00005b0005057a11ULL, 0x000fe400000f4414ULL,
0xfffffff816217812ULL, 0x000fe200078ee221ULL, 0x0000001017067825ULL, 0x000fe200078e0006ULL,
0x00005b0009097a11ULL, 0x000fc600010f4400ULL, 0x0000001015047825ULL, 0x000fc800078e0004ULL,
0x0000001021087825ULL, 0x000fe200078e0008ULL, 0x0000000c02007986ULL, 0x008fe8000c101d08ULL,
0x0000001004007986ULL, 0x000fe8000c101d08ULL, 0x0000001806007986ULL, 0x000fe8000c101d08ULL,
0x0000001c08007986ULL, 0x000fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006800ff3c7624ULL, 0x000fe200078e00ffULL, 0x00000001ff3a7819ULL, 0x000fe20000011600ULL,
0x00006900ff3d7624ULL, 0x000fc400078e00ffULL, 0xffffffffff097424ULL, 0x000fe200078e00ffULL,
0x01ffffff3a3a7812ULL, 0x000fe400078ec0ffULL, 0x000000083c3c7981ULL, 0x000366000c1e9900ULL,
0x00000002033a7824ULL, 0x000fca00078e023aULL, 0x000000fb3a00720cULL, 0x000fe40003f06070ULL,
0x0000000103057810ULL, 0x000fd60007ffe0ffULL, 0x0000000243078824ULL, 0x000fc800078e00ffULL,
0x0000640007078a24ULL, 0x000fc800078e023aULL, 0x0000600007068625ULL, 0x000fca00078e0008ULL,
0x0000000806098981ULL, 0x000362000c1e1900ULL, 0x000000040500720cULL, 0x000fe20003f06070ULL,
0x0000004000387824ULL, 0x000fe400078e00ffULL, 0x000000802c057824ULL, 0x000fe400078e00ffULL,
0x00000100030b7824ULL, 0x000fe200078e0238ULL, 0x0000000704047899ULL, 0x000fc8000800063fULL,
0x00000040051c7812ULL, 0x000fc600078ef80bULL, 0x00000cb000008947ULL, 0x000fea0003800000ULL,
0x0000000000257919ULL, 0x002e620000000000ULL, 0x0000000b02067217ULL, 0x000fe20007800000ULL,
0x00000004091c7c24ULL, 0x020fe2000f8e021cULL, 0x00001000001d7811ULL, 0x000fe200078e70ffULL,
0x00000080ff277424ULL, 0x000fe400078e00ffULL, 0x0000000106097824ULL, 0x000fe200078e0a0bULL,
0x00000003ff2e7819ULL, 0x002fc80000011625ULL, 0x000000042e0c7810ULL, 0x040fe40007ffe0ffULL,
0x000000102e127810ULL, 0x000fe40007ffe0ffULL, 0x000000250c077212ULL, 0x0c0fe200078e3cffULL,
0x000000080c1e7824ULL, 0x000fe200078e00ffULL, 0x0000000c2e107810ULL, 0x000fe20007ffe0ffULL,
0x0000000812247824ULL, 0x000fe200078e00ffULL, 0x000000082e0e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee207ULL, 0x00000008100b7824ULL, 0x000fe200078e00ffULL,
0x0000002512077212ULL, 0x080fe200078e3cffULL, 0x000000080e0d7824ULL, 0x000fe200078e00ffULL,
0x0000002510067212ULL, 0x000fc400078e3cffULL, 0x000000142e167810ULL, 0x000fe40007ffe0ffULL,
0xfffffff824247812ULL, 0x000fe400078ee207ULL, 0x000000250e0a7212ULL, 0x080fe400078e3cffULL,
0x0000007f2e077812ULL, 0x000fe400078ec0ffULL, 0xfffffff80b227812ULL, 0x000fe200078ee206ULL,
0x00000008160b7824ULL, 0x040fe200078e00ffULL, 0x0000002516067212ULL, 0x000fe200078e3cffULL,
0x000000011c077824ULL, 0x000fe200078e0207ULL, 0xfffffff80d207812ULL, 0x000fe200078ee20aULL,
0x00000010250a7824ULL, 0x000fe200078e00ffULL, 0x0000007f0e0d7812ULL, 0x000fc400078ec0ffULL,
0xfffffff80b267812ULL, 0x000fe200078ee206ULL, 0x00005e0007067625ULL, 0x000fe200078e0027ULL,
0x0000007f0c0b7812ULL, 0x000fe400078ec0ffULL, 0x000000700a297812ULL, 0x000fe200078ec0ffULL,
0x000000011c0d7824ULL, 0x000fe200078e020dULL, 0x0000007f100f7812ULL, 0x000fe200078ec0ffULL,
0x000000011c0b7824ULL, 0x000fe200078e020bULL, 0x000000090c00720cULL, 0x000fe20003f86070ULL,
0x00005e000d0c7625ULL, 0x000fe200078e0027ULL, 0x000000091000720cULL, 0x000fc40003f06070ULL,
0x0000007f12117812ULL, 0x000fe200078ec0ffULL, 0x00005e000b0a7625ULL, 0x000fe200078e0027ULL,
0x0000002906107210ULL, 0x000fe40007f3e0ffULL, 0x000000090e00720cULL, 0x000fe20003fa6070ULL,
0x000000011c067824ULL, 0x000fe200078e020fULL, 0x000000290c0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000011c0e7824ULL, 0x000fe200078e0211ULL, 0x000000091200720cULL, 0x000fe20003f46070ULL,
0x000000ffff117224ULL, 0x000fe200008e0607ULL, 0x000000290a127210ULL, 0x000fe20007f3e0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0027ULL, 0x000000182e287810ULL, 0x000fc40007ffe0ffULL,
0x0000001c2e307810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200018e060dULL,
0x0000002906147210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e060bULL,
0x0000007f160b7812ULL, 0x000fe200078ec0ffULL, 0x00005e000e0e7625ULL, 0x000fe200078e0027ULL,
0x0000007f30177812ULL, 0x000fe400078ec0ffULL, 0x000000091600720cULL, 0x000fe20003f26070ULL,
0x000000ffff157224ULL, 0x000fe200018e0607ULL, 0x0000007f28077812ULL, 0x000fe200078ec0ffULL,
0x000000011c067824ULL, 0x000fe200078e020bULL, 0x000000290e0e7210ULL, 0x000fe20007fde0ffULL,
0x0000000828217824ULL, 0x000fe200078e00ffULL, 0x000000072e187812ULL, 0x000fe200078e4825ULL,
0x000000011c0a7824ULL, 0x000fe200078e0207ULL, 0x000000202e2a7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0027ULL, 0x0ffffff8181a7812ULL, 0x000fc400078ef825ULL,
0x0000007f2a197812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0f7224ULL, 0x000fe200030e060fULL,
0x0000002906167210ULL, 0x000fe20007fde0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0027ULL,
0x000000092e00720cULL, 0x040fe40003f66070ULL, 0x000000242e2c7810ULL, 0x000fe20007ffe0ffULL,
0x000000011c067824ULL, 0x000fe400078e0217ULL, 0x000000ffff177224ULL, 0x000fe200030e0607ULL,
0x000000290a187210ULL, 0x000fe20007fde0ffULL, 0x00005e0006067625ULL, 0x000fc800078e0027ULL,
0x000000011c0a7824ULL, 0x000fe400078e0219ULL, 0x000000101a1f7824ULL, 0x000fe400078e021dULL,
0x000000ffff197224ULL, 0x000fe200030e060bULL, 0x00000029061a7210ULL, 0x000fe20007fde0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0027ULL, 0x0000002528067212ULL, 0x040fe200078e3cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101f7faeULL, 0x0003e2000d901c48ULL,
0x000000092800720cULL, 0x000fe20003f66070ULL, 0x000000ffff1b7224ULL, 0x000fe200030e0607ULL,
0x0000007f2c077812ULL, 0x000fe200078ec0ffULL, 0x000000082a237824ULL, 0x000fe200078e00ffULL,
0xfffffff821287812ULL, 0x000fe200078ee206ULL, 0x000000101e217824ULL, 0x000fe200078e021dULL,
0x000000290a0a7210ULL, 0x000fe20007fde0ffULL, 0x000000011c077824ULL, 0x000fe200078e0207ULL,
0x000000252a1e7212ULL, 0x000fc400078e3cffULL, 0x0000000012217faeULL, 0x0005e2000e101c48ULL,
0x00005e0007067625ULL, 0x000fe200078e0027ULL, 0x000000093000720cULL, 0x040fe40003f86070ULL,
0x0000002530117212ULL, 0x002fe200078e3cffULL, 0x00000010201f7824ULL, 0x000fe200078e021dULL,
0xfffffff8231e7812ULL, 0x000fe200078ee21eULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x0000002906107210ULL, 0x000fe20007fde0ffULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0x000000000c1f7faeULL, 0x0003e2000e901c48ULL, 0x000000092a00720cULL, 0x000fe20003fa6070ULL,
0x0000001022137824ULL, 0x104fe200078e021dULL, 0x0000002c2e127810ULL, 0x000fe20007ffe0ffULL,
0x000000101e237824ULL, 0x000fe200078e021dULL, 0xfffffff830067812ULL, 0x000fe200078ee211ULL,
0x000000ffff117224ULL, 0x000fe200030e0607ULL, 0x0000000014137faeULL, 0x0005e2000c101c48ULL,
0x0000001024077824ULL, 0x100fe200078e021dULL, 0x000000302e1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001006217824ULL, 0x100fe200078e021dULL, 0x000000382e207810ULL, 0x000fe20007ffe0ffULL,
0x00000010260d7824ULL, 0x102fe200078e021dULL, 0x000000282e0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000010281f7824ULL, 0x000fe200078e021dULL, 0x000000000e077faeULL, 0x0003e2000d101c48ULL,
0x0000003c2e227810ULL, 0x000fc40007ffe0ffULL, 0x000000252c067212ULL, 0x000fe200078e3cffULL,
0x000000080c147824ULL, 0x004fe200078e00ffULL, 0x00000000160d7faeULL, 0x0005e2000c901c48ULL,
0x000000092c00720cULL, 0x080fe40003fc6070ULL, 0x000000092000720cULL, 0x080fe20003f26070ULL,
0x00000000181f7faeULL, 0x0007e2000d901c48ULL, 0x000000091e00720cULL, 0x000fe40003f66070ULL,
0x000000250c077212ULL, 0x002fe200078e3cffULL, 0x000000001a217faeULL, 0x0003e2000e101c48ULL,
0x000000342e0e7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff814147812ULL, 0x000fe200078ee207ULL,
0x000000082c0d7824ULL, 0x004fe200078e00ffULL, 0x000000000a237faeULL, 0x0005e2000e901c48ULL,
0x0000007f0c077812ULL, 0x000fe200078ec0ffULL, 0x0000000812167824ULL, 0x000fe200078e00ffULL,
0x000000090c00720cULL, 0x080fe20003fa6070ULL, 0x0000000822177824ULL, 0x000fe200078e00ffULL,
0x000000091200720cULL, 0x080fe20003f86070ULL, 0x000000011c077824ULL, 0x000fe200078e0207ULL,
0x000000090e00720cULL, 0x0c0fe20003f46070ULL, 0x000000080e1a7824ULL, 0x002fe200078e00ffULL,
0x000000092200720cULL, 0x000fc40003f06070ULL, 0xfffffff80d067812ULL, 0x000fe200078ee206ULL,
0x000000081e0b7824ULL, 0x044fe200078e00ffULL, 0x000000251e0a7212ULL, 0x080fe400078e3cffULL,
0x0000002512097212ULL, 0x040fe400078e3cffULL, 0xfffffff80b187812ULL, 0x008fe400078ee20aULL,
0x0000007f120b7812ULL, 0x000fe400078ec0ffULL, 0xfffffff816167812ULL, 0x000fe200078ee209ULL,
0x0000001006097824ULL, 0x000fe200078e021dULL, 0x0000007f1e0d7812ULL, 0x000fe200078ec0ffULL,
0x00005e0007067625ULL, 0x000fe200078e0027ULL, 0x000000250e0f7212ULL, 0x000fc400078e3cffULL,
0x0000000010097faeULL, 0x0003e2000f101c48ULL, 0x000000011c0b7824ULL, 0x000fe200078e020bULL,
0x00000029060c7210ULL, 0x000fe20007fde0ffULL, 0x000000011c067824ULL, 0x000fe200078e020dULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee20fULL, 0x00005e000b0a7625ULL, 0x000fe200078e0027ULL,
0x0000007f22137812ULL, 0x000fc600078ec0ffULL, 0x000000ffff0d7224ULL, 0x000fe400030e0607ULL,
0x00005e0006067625ULL, 0x000fe200078e0027ULL, 0x0000007f0e097812ULL, 0x002fe400078ec0ffULL,
0x000000290a0e7210ULL, 0x080fe20007fde0ffULL, 0x000000011c157824ULL, 0x000fe200078e0213ULL,
0x0000007f20117812ULL, 0x000fe200078ec0ffULL, 0x000000011c097824ULL, 0x000fe400078e0209ULL,
0x000000ffff0f7224ULL, 0x000fe200030e060bULL, 0x0000002906107210ULL, 0x000fe20007fde0ffULL,
0x00005e00090a7625ULL, 0x000fe200078e0027ULL, 0x0000002520097212ULL, 0x000fc600078e3cffULL,
0x000000011c067824ULL, 0x000fe400078e0211ULL, 0x000000ffff117224ULL, 0x000fe200030e0607ULL,
0x000000290a127210ULL, 0x000fe20007fde0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0027ULL,
0x00000025220a7212ULL, 0x000fc600078e3cffULL, 0x000000ffff137224ULL, 0x000fe200030e060bULL,
0x0000002906067210ULL, 0x000fe20007fde0ffULL, 0x00000008201c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8171e7812ULL, 0x000fe200078ee20aULL, 0x00005e00150a7625ULL, 0x000fc600078e0027ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x000000290a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001014097824ULL, 0x100fe400078e021dULL,
0x0000001016157824ULL, 0x100fe400078e021dULL, 0x0000001018177824ULL, 0x100fe200078e021dULL,
0x000000000c097faeULL, 0x0003e2000e901c48ULL, 0x000000101a197824ULL, 0x100fe400078e021dULL,
0x000000101c1b7824ULL, 0x100fe200078e021dULL, 0x000000000e157faeULL, 0x0003e2000e101c48ULL,
0x000000101e1d7824ULL, 0x000fc400078e021dULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x0000000010177faeULL, 0x0003e8000d901c48ULL, 0x0000000012197faeULL, 0x0003e8000d101c48ULL,
0x00000000061b7faeULL, 0x0003e8000c901c48ULL, 0x000000000a1d7faeULL, 0x0003e2000c101c48ULL,
0x00000b8000007947ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x002e620000000000ULL,
0x0000000409097c24ULL, 0x020fc4000f8e021cULL, 0x00000080ff267424ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x002fc80000011606ULL, 0x00000004070f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000807137810ULL, 0x040fe40007ffe0ffULL, 0x0000001807237810ULL, 0x000fe20007ffe0ffULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0x0000000c07177810ULL, 0x000fe20007ffe0ffULL,
0x00000008130c7824ULL, 0x000fe200078e00ffULL, 0x000000060f0a7212ULL, 0x080fe200078e3cffULL,
0x0000000823107824ULL, 0x000fe200078e00ffULL, 0x00000010071b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000817197824ULL, 0x000fe200078e00ffULL, 0x00000006130b7212ULL, 0x000fc400078e3cffULL,
0x00000006230d7212ULL, 0x080fe200078e3cffULL, 0x000000081b0e7824ULL, 0x000fe200078e00ffULL,
0x00000028072d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff811117812ULL, 0x000fe400078ee20aULL,
0x0000001c07277810ULL, 0x000fe40007ffe0ffULL, 0x00000006170a7212ULL, 0x080fe400078e3cffULL,
0xfffffff80c157812ULL, 0x000fe200078ee20bULL, 0x0000000827377824ULL, 0x000fe200078e00ffULL,
0x000000061b0b7212ULL, 0x000fc400078e3cffULL, 0xfffffff810257812ULL, 0x000fe200078ee20dULL,
0x000000082d107824ULL, 0x000fe200078e00ffULL, 0x0000002007297810ULL, 0x040fe40007ffe0ffULL,
0x00000014071f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff819197812ULL, 0x000fe400078ee20aULL,
0x000000062d0d7212ULL, 0x000fe200078e3cffULL, 0x000000081f217824ULL, 0x000fe200078e00ffULL,
0x0000002c072f7810ULL, 0x000fc40007ffe0ffULL, 0x0000003807357810ULL, 0x000fe40007ffe0ffULL,
0x00000006270a7212ULL, 0x080fe200078e3cffULL, 0x000000082f497824ULL, 0x000fe200078e00ffULL,
0xfffffff80e1d7812ULL, 0x000fe200078ee20bULL, 0x00000008290e7824ULL, 0x000fe200078e00ffULL,
0x00000024072b7810ULL, 0x000fe40007ffe0ffULL, 0x00000006290b7212ULL, 0x080fe400078e3cffULL,
0xfffffff810457812ULL, 0x000fe200078ee20dULL, 0x0000000835107824ULL, 0x000fe200078e00ffULL,
0x0000003007317810ULL, 0x000fe20007ffe0ffULL, 0x000000082b3f7824ULL, 0x000fe200078e00ffULL,
0x000000061f0c7212ULL, 0x000fc400078e3cffULL, 0xfffffff837377812ULL, 0x000fe400078ee20aULL,
0x000000062f0a7212ULL, 0x080fe400078e3cffULL, 0x00000006350d7212ULL, 0x080fe400078e3cffULL,
0xfffffff80e3b7812ULL, 0x000fe200078ee20bULL, 0x00000008310e7824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe400078ee20cULL, 0x000000062b0c7212ULL, 0x000fc400078e3cffULL,
0x00000006310b7212ULL, 0x000fe400078e3cffULL, 0xfffffff849497812ULL, 0x000fe400078ee20aULL,
0xfffffff810557812ULL, 0x000fe400078ee20dULL, 0x0000003407337810ULL, 0x040fe40007ffe0ffULL,
0x0000007f070a7812ULL, 0x040fe400078ec0ffULL, 0x00000007070d7812ULL, 0x000fe200078e4806ULL,
0x0000000833517824ULL, 0x000fe200078e00ffULL, 0x0000003c07397810ULL, 0x000fe20007ffe0ffULL,
0x0000000109077824ULL, 0x000fe200078e020aULL, 0xfffffff83f3f7812ULL, 0x000fc400078ee20cULL,
0xfffffff80e4d7812ULL, 0x000fe200078ee20bULL, 0x00000010060b7824ULL, 0x000fe200078e00ffULL,
0x0000007f291a7812ULL, 0x000fe200078ec0ffULL, 0x00000008392a7824ULL, 0x000fe200078e00ffULL,
0x00000006330c7212ULL, 0x080fe400078e3cffULL, 0x0ffffff80d0d7812ULL, 0x000fe400078ef806ULL,
0x0000000639297212ULL, 0x040fe400078e3cffULL, 0x0000007f39067812ULL, 0x000fe200078ec0ffULL,
0x0000000109397824ULL, 0x000fe200078e021aULL, 0x0000007f0f0a7812ULL, 0x000fc400078ec0ffULL,
0x0000007f130e7812ULL, 0x000fe200078ec0ffULL, 0x0000000109577824ULL, 0x000fe200078e0206ULL,
0x0000007f17107812ULL, 0x000fe200078ec0ffULL, 0x00000001090f7824ULL, 0x000fe200078e020aULL,
0x0000007f1b127812ULL, 0x000fe200078ec0ffULL, 0x0000000109137824ULL, 0x000fe200078e020eULL,
0x0000007f1f147812ULL, 0x000fe200078ec0ffULL, 0x0000000109177824ULL, 0x000fe200078e0210ULL,
0x0000007f23167812ULL, 0x000fe200078ec0ffULL, 0x00000001091b7824ULL, 0x000fe200078e0212ULL,
0x0000007f27187812ULL, 0x000fe200078ec0ffULL, 0x00000001091f7824ULL, 0x000fe200078e0214ULL,
0x0000007f2b1c7812ULL, 0x000fe200078ec0ffULL, 0x0000000109237824ULL, 0x000fe200078e0216ULL,
0x0000007f2d1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000109277824ULL, 0x000fe200078e0218ULL,
0x0000007f2f207812ULL, 0x000fe200078ec0ffULL, 0x00000001093d7824ULL, 0x000fe200078e021cULL,
0x0000007f31227812ULL, 0x000fe200078ec0ffULL, 0x0000000109417824ULL, 0x000fe200078e021eULL,
0x0000007f33247812ULL, 0x000fe200078ec0ffULL, 0x0000000109477824ULL, 0x000fe200078e0220ULL,
0x0000007f35287812ULL, 0x000fe200078ec0ffULL, 0x00000001094b7824ULL, 0x000fe200078e0222ULL,
0xfffffff851517812ULL, 0x000fe200078ee20cULL, 0x00000001094f7824ULL, 0x040fe200078e0224ULL,
0x00001000000c7811ULL, 0x000fe200078e70ffULL, 0x0000000109537824ULL, 0x000fe200078e0228ULL,
0x000000700b097812ULL, 0x000fe200078ec0ffULL, 0x00005e0007067625ULL, 0x000fe200078e0026ULL,
0xfffffff82a597812ULL, 0x000fc600078ee229ULL, 0x00005e000f0a7625ULL, 0x000fe200078e0026ULL,
0x0000000906067210ULL, 0x000fc60007f1e0ffULL, 0x00000010112b7824ULL, 0x100fe400078e020cULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x000000090a0a7210ULL, 0x000fe20007f1e0ffULL,
0x000000100d297824ULL, 0x100fe400078e020cULL, 0x00000010152d7824ULL, 0x100fe400078e020cULL,
0x00000010192f7824ULL, 0x100fe200078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006297faeULL, 0x0003e2000b901c48ULL, 0x000000101d317824ULL, 0x000fc400078e020cULL,
0x0000001021337824ULL, 0x100fe400078e020cULL, 0x0000001025357824ULL, 0x100fe400078e020cULL,
0x0000001037377824ULL, 0x100fe400078e020cULL, 0x000000103b3b7824ULL, 0x100fe400078e020cULL,
0x000000103f3f7824ULL, 0x100fe400078e020cULL, 0x0000001045457824ULL, 0x000fc400078e020cULL,
0x0000001049497824ULL, 0x100fe400078e020cULL, 0x000000104d4d7824ULL, 0x100fe400078e020cULL,
0x0000001051517824ULL, 0x100fe400078e020cULL, 0x0000001055557824ULL, 0x100fe400078e020cULL,
0x0000001059597824ULL, 0x000fe400078e020cULL, 0x00005e001b107625ULL, 0x000fc800078e0026ULL,
0x00005e00130c7625ULL, 0x000fc800078e0026ULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000000910107210ULL, 0x080fe20007f1e0ffULL, 0x00005e0023147625ULL, 0x080fe200078e0026ULL,
0x000000090c0c7210ULL, 0x000fe40007f3e0ffULL, 0x000000000a2b7faeULL, 0x0003e2000b901c48ULL,
0x00005e001f127625ULL, 0x000fc800078e0026ULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000000914147210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x0000000912127210ULL, 0x000fe20007f3e0ffULL, 0x00005e00170e7625ULL, 0x000fc600078e0026ULL,
0x000000000c2d7faeULL, 0x0003e2000b901c48ULL, 0x00005e0039187625ULL, 0x000fe200078e0026ULL,
0x000000090e0e7210ULL, 0x000fc60007f5e0ffULL, 0x00005e0027167625ULL, 0x000fc800078e0026ULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x0000000918187210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0613ULL, 0x0000000916167210ULL, 0x000fe20007f3e0ffULL,
0x00005e00471e7625ULL, 0x000fc800078e0026ULL, 0x00005e003d1a7625ULL, 0x000fc800078e0026ULL,
0x00005e00411c7625ULL, 0x000fc800078e0026ULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x000000091e1e7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0617ULL,
0x000000091a1a7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e060fULL,
0x000000091c1c7210ULL, 0x000fe20007f5e0ffULL, 0x00005e004b207625ULL, 0x000fc600078e0026ULL,
0x000000000e2f7faeULL, 0x0003e2000b901c48ULL, 0x00005e004f227625ULL, 0x000fc600078e0026ULL,
0x0000000010317faeULL, 0x0003e2000b901c48ULL, 0x00005e0053247625ULL, 0x000fc600078e0026ULL,
0x0000000012337faeULL, 0x0003e2000b901c48ULL, 0x00005e0057267625ULL, 0x000fc600078e0026ULL,
0x0000000014357faeULL, 0x0003e2000b901c48ULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x0000000920207210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e061bULL,
0x0000000922227210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200010e061dULL,
0x0000000924247210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff217224ULL, 0x000fe200000e0621ULL,
0x0000000926267210ULL, 0x000fe20007f7e0ffULL, 0x0000000016377faeULL, 0x0003e2000b901c48ULL,
0x000000ffff237224ULL, 0x000fc400008e0623ULL, 0x000000ffff257224ULL, 0x000fe200010e0625ULL,
0x00000000183b7faeULL, 0x0003e2000b901c48ULL, 0x000000ffff277224ULL, 0x000fc600018e0627ULL,
0x000000001a3f7faeULL, 0x0003e8000b901c48ULL, 0x000000001c457faeULL, 0x0003e8000b901c48ULL,
0x000000001e497faeULL, 0x0003e8000b901c48ULL, 0x00000000204d7faeULL, 0x0003e8000b901c48ULL,
0x0000000022517faeULL, 0x0003e8000b901c48ULL, 0x0000000024557faeULL, 0x0003e8000b901c48ULL,
0x0000000026597faeULL, 0x0003e4000b901c48ULL, 0x01b60400ff067984ULL, 0x002e620000000800ULL,
0x00000300ff077624ULL, 0x000fc400078e00ffULL, 0xffffffffff397424ULL, 0x000fe400078e00ffULL,
0x00000002073a7824ULL, 0x000fca00078e023aULL, 0x000000fb3a00720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000243097824ULL, 0x000fc800078e00ffULL,
0x0000640009097a24ULL, 0x000fc800078e023aULL, 0x0000600009087625ULL, 0x000fca00078e0008ULL,
0x0000000808397981ULL, 0x000564000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000006ff7812ULL, 0x002fe2000780c0ffULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x0000000600077305ULL, 0x0002e4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x000000070000735dULL, 0x008fe40003800000ULL, 0x01b60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000030000780cULL, 0x000fda0003f04070ULL,
0x0000017000000947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x000e640000000000ULL,
0x0000002000067824ULL, 0x002fc800078e0207ULL, 0x0000001006087824ULL, 0x004fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fc80000011606ULL, 0x1ffffffe07077812ULL, 0x000fe400078ec0ffULL,
0x000000f008087812ULL, 0x000fe400078ec0ffULL, 0x0000000107097812ULL, 0x040fe400078efcffULL,
0x0000000707077812ULL, 0x100fe400078e7806ULL, 0x0000000709097812ULL, 0x000fc600078e7806ULL,
0x0000000107077824ULL, 0x000fe400078e0208ULL, 0x0000000108097824ULL, 0x000fc600078e0209ULL,
0x0000000007107984ULL, 0x000e68000000cc00ULL, 0x00000000090c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fc400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000001407007388ULL, 0x0003e8000000cc00ULL, 0x0000001009007388ULL, 0x0003e4000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b60000ffff7f8cULL, 0x000fe8000c80043fULL,
0x01b60400ff067984ULL, 0x000ee40000000800ULL, 0x8000000006ff7812ULL, 0x008fc40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff067424ULL, 0x000fc800078e00ffULL, 0x0000000600077305ULL, 0x0022e4000021f000ULL,
0x3fa0000006067823ULL, 0x002fe200000100ffULL, 0x000000070000735dULL, 0x008fe40003800000ULL,
0x01b60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000040300720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000003b7919ULL, 0x000ee20000000000ULL, 0x3db504f33c3c7820ULL, 0x000fe20000410000ULL,
0xffffffff04447810ULL, 0x000fe20007ffe0ffULL, 0x0000640043437a24ULL, 0x000fe200078e02ffULL,
0x00007610ff467816ULL, 0x000fe20000000046ULL, 0x0000001000427824ULL, 0x000fe200078e00ffULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff457224ULL, 0x000fe200078e00ffULL,
0x0000000704047899ULL, 0x000fe4000800063fULL, 0x0000010003477824ULL, 0x000fe200078e0238ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000470200720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000030003497a10ULL, 0x000fe20007ffe0ffULL,
0x000018b000007945ULL, 0x000fe20003800000ULL, 0x00000001454b7812ULL, 0x000fe400078e0cffULL,
0x0000000149077810ULL, 0x042fe20007ffe0ffULL, 0x0000010049097824ULL, 0x004fc600078e0238ULL,
0x000000040700720cULL, 0x000fe40003f06070ULL, 0x0000004009067812ULL, 0x000fca00078ec0ffULL,
0x0000000105067824ULL, 0x000fcc00078e0206ULL, 0x00000cb000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1c7819ULL, 0x008fe2000001163bULL, 0x0000000439397c24ULL, 0x020fe2000f8e0206ULL,
0x0000000902067217ULL, 0x000fe20007800000ULL, 0x00000080ff237424ULL, 0x000fe200078e00ffULL,
0x000000081c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000002001b7824ULL, 0x000fe200078e024bULL,
0x000000041c087810ULL, 0x000fe20007ffe0ffULL, 0x00000001061a7824ULL, 0x000fe200078e0a09ULL,
0x0000003b0a0b7212ULL, 0x0c0fe200078e3cffULL, 0x000000080a207824ULL, 0x000fe200078e00ffULL,
0x0000000c1c097810ULL, 0x000fe20007ffe0ffULL, 0x00000008081e7824ULL, 0x040fe200078e00ffULL,
0x0000003b08077212ULL, 0x000fc400078e3cffULL, 0xfffffff820207812ULL, 0x000fe200078ee20bULL,
0x00000008090d7824ULL, 0x040fe200078e00ffULL, 0x000000101c0b7810ULL, 0x000fe40007ffe0ffULL,
0x0000003b09067212ULL, 0x080fe400078e3cffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee207ULL,
0x000000080b247824ULL, 0x040fe200078e00ffULL, 0x0000003b0b077212ULL, 0x000fe400078e3cffULL,
0xfffffff80d227812ULL, 0x000fc400078ee206ULL, 0x0000007f1c067812ULL, 0x000fe400078ec0ffULL,
0xfffffff824247812ULL, 0x000fe200078ee207ULL, 0x000000103b077824ULL, 0x000fe200078e00ffULL,
0x0000001a0a00720cULL, 0x000fe20003fa6070ULL, 0x0000000106067824ULL, 0x000fe200078e0239ULL,
0x0000007f0a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000007007257812ULL, 0x000fe200078ec0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0023ULL, 0x000000141c137810ULL, 0x000fc40007ffe0ffULL,
0x0000007f0b107812ULL, 0x000fe200078ec0ffULL, 0x000000010a0a7824ULL, 0x100fe200078e0239ULL,
0x0000001a0800720cULL, 0x0c0fe20003f86070ULL, 0x00000008130d7824ULL, 0x000fe200078e00ffULL,
0x0000007f08087812ULL, 0x000fe400078ec0ffULL, 0x0000001a0b00720cULL, 0x080fe20003f46070ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0023ULL, 0x00000025060e7210ULL, 0x000fe40007f3e0ffULL,
0x0000003b130c7212ULL, 0x000fe200078e3cffULL, 0x0000000110067824ULL, 0x100fe200078e0239ULL,
0x000000250a0a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000108087824ULL, 0x000fe200078e0239ULL,
0xfffffff80d267812ULL, 0x000fe200078ee20cULL, 0x000000ffff0f7224ULL, 0x000fe200008e0607ULL,
0x0000007f090c7812ULL, 0x040fe200078ec0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0023ULL,
0x0000001a0900720cULL, 0x000fc40003f06070ULL, 0x000000181c197810ULL, 0x000fe20007ffe0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0023ULL, 0x0000001c1c217810ULL, 0x040fe40007ffe0ffULL,
0x000000071c167812ULL, 0x000fe200078e483bULL, 0x000000ffff0b7224ULL, 0x000fe200018e060bULL,
0x0000002506127210ULL, 0x080fe20007f7e0ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0239ULL,
0x0000007f13067812ULL, 0x000fe200078ec0ffULL, 0x00000008191f7824ULL, 0x040fe200078e00ffULL,
0x0000002508107210ULL, 0x000fe20007f3e0ffULL, 0x00005e000c0c7625ULL, 0x000fe200078e0023ULL,
0x0000007f19087812ULL, 0x000fc400078ec0ffULL, 0x0000007f21287812ULL, 0x000fe200078ec0ffULL,
0x0000000106067824ULL, 0x000fe200078e0239ULL, 0x000000250c0c7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0609ULL, 0x0000001a1300720cULL, 0x080fe20003f26070ULL,
0x000000ffff137224ULL, 0x000fe200018e0607ULL, 0x0ffffff816187812ULL, 0x000fe200078ef83bULL,
0x00005e0006067625ULL, 0x000fe200078e0023ULL, 0x000010001b1b7811ULL, 0x000fe400078e68ffULL,
0x000000201c277810ULL, 0x000fe20007ffe0ffULL, 0x0000000108087824ULL, 0x000fe200078e0239ULL,
0x0000001a1c00720cULL, 0x000fe20003f66070ULL, 0x000000ffff0d7224ULL, 0x000fe200030e060dULL,
0x0000002506147210ULL, 0x000fe20007fde0ffULL, 0x00005e0008087625ULL, 0x000fe200078e0023ULL,
0x0000007f272a7812ULL, 0x000fc400078ec0ffULL, 0x000000241c297810ULL, 0x000fe20007ffe0ffULL,
0x0000000128067824ULL, 0x000fe400078e0239ULL, 0x000000ffff157224ULL, 0x000fe200030e0607ULL,
0x0000002508167210ULL, 0x000fe20007fde0ffULL, 0x00005e0006067625ULL, 0x000fc800078e0023ULL,
0x00000010181d7824ULL, 0x000fe400078e021bULL, 0x000000ffff177224ULL, 0x000fe200030e0609ULL,
0x0000002506187210ULL, 0x000fe20007fde0ffULL, 0x000000012a087824ULL, 0x000fe200078e0239ULL,
0x0000003b19067212ULL, 0x040fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e1d7faeULL, 0x0003e2000d901c48ULL, 0x0000001a1900720cULL, 0x080fe20003f66070ULL,
0x00005e0008087625ULL, 0x000fe200078e0023ULL, 0xfffffff81f287812ULL, 0x000fe400078ee206ULL,
0x0000007f29067812ULL, 0x000fe200078ec0ffULL, 0x000000101e1f7824ULL, 0x000fe200078e021bULL,
0x0000003b271e7212ULL, 0x000fe200078e3cffULL, 0x000000ffff197224ULL, 0x000fe200030e0607ULL,
0x0000002508087210ULL, 0x000fe20007fde0ffULL, 0x0000000106067824ULL, 0x000fe200078e0239ULL,
0x00000000101f7faeULL, 0x0005e2000e101c48ULL, 0x00000010201d7824ULL, 0x002fe200078e021bULL,
0x0000003b210f7212ULL, 0x040fe200078e3cffULL, 0x00005e0006067625ULL, 0x000fe200078e0023ULL,
0x0000001a2100720cULL, 0x000fc40003f86070ULL, 0x000000000a1d7faeULL, 0x0003e2000e901c48ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x0000001a2700720cULL, 0x080fe20003fa6070ULL,
0x0000000821207824ULL, 0x000fe200078e00ffULL, 0x00000025060e7210ULL, 0x000fe20007fde0ffULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0x000000301c107810ULL, 0x004fe20007ffe0ffULL,
0x0000001022117824ULL, 0x000fe200078e021bULL, 0xfffffff820067812ULL, 0x000fe200078ee20fULL,
0x000000ffff0f7224ULL, 0x000fe200030e0607ULL, 0xfffffff8271e7812ULL, 0x000fe200078ee21eULL,
0x0000001024077824ULL, 0x100fe200078e021bULL, 0x000000000c117faeULL, 0x0005e2000c101c48ULL,
0x00000010260b7824ULL, 0x102fe200078e021bULL, 0x000000281c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010281d7824ULL, 0x100fe200078e021bULL, 0x0000001a2900720cULL, 0x040fe20003fc6070ULL,
0x00000010061f7824ULL, 0x100fe200078e021bULL, 0x0000003b29067212ULL, 0x040fe200078e3cffULL,
0x000000101e217824ULL, 0x000fe200078e021bULL, 0x0000000012077faeULL, 0x0003e2000d101c48ULL,
0x0000000829297824ULL, 0x000fc600078e00ffULL, 0x00000000140b7faeULL, 0x0007e2000c901c48ULL,
0x0000002c1c0c7810ULL, 0x044fe40007ffe0ffULL, 0xfffffff829067812ULL, 0x000fe200078ee206ULL,
0x00000000161d7faeULL, 0x0005e2000d901c48ULL, 0x000000341c117810ULL, 0x000fe40007ffe0ffULL,
0x0000001a1000720cULL, 0x080fe20003f66070ULL, 0x00000000181f7faeULL, 0x0009e2000e101c48ULL,
0x000000080a127824ULL, 0x042fe200078e00ffULL, 0x0000003b0a077212ULL, 0x000fe200078e3cffULL,
0x00000010060d7824ULL, 0x000fe200078e021bULL, 0x0000000008217faeULL, 0x0003e2000e901c48ULL,
0x0000001a0a00720cULL, 0x000fe20003fa6070ULL, 0x000000080c147824ULL, 0x008fe200078e00ffULL,
0x0000007f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x000000000e0d7faeULL, 0x0007e2000f101c48ULL,
0xfffffff812127812ULL, 0x000fc400078ee207ULL, 0x0000003b0c077212ULL, 0x080fe200078e3cffULL,
0x000000010a067824ULL, 0x000fe200078e0239ULL, 0x0000003b110b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000811187824ULL, 0x010fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee207ULL,
0x0000000810097824ULL, 0x042fe200078e00ffULL, 0x0000003b10087212ULL, 0x000fe200078e3cffULL,
0x00005e0006067625ULL, 0x000fe200078e0023ULL, 0x0000007f10107812ULL, 0x000fe400078ec0ffULL,
0xfffffff809167812ULL, 0x004fc400078ee208ULL, 0x0000007f0c087812ULL, 0x000fe400078ec0ffULL,
0x00000025060a7210ULL, 0x000fe20007fde0ffULL, 0x0000000110067824ULL, 0x000fe200078e0239ULL,
0xfffffff818187812ULL, 0x000fe200078ee20bULL, 0x0000000108087824ULL, 0x000fe200078e0239ULL,
0x0000007f110e7812ULL, 0x008fe200078ec0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e0607ULL,
0x0000001a0c00720cULL, 0x000fe20003f86070ULL, 0x00005e0008087625ULL, 0x000fe200078e0023ULL,
0x000000381c137810ULL, 0x000fc40007ffe0ffULL, 0x0000003c1c1c7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0023ULL, 0x00000025080c7210ULL, 0x000fe40007fde0ffULL,
0x0000007f13107812ULL, 0x000fe200078ec0ffULL, 0x000000010e087824ULL, 0x000fe200078e0239ULL,
0x0000001a1100720cULL, 0x080fe20003f46070ULL, 0x000000ffff0d7224ULL, 0x000fe200030e0609ULL,
0x0000001a1300720cULL, 0x080fe20003f26070ULL, 0x00005e0008087625ULL, 0x000fe200078e0023ULL,
0x0000001a1c00720cULL, 0x000fc40003f06070ULL, 0x0000007f1c1a7812ULL, 0x000fe200078ec0ffULL,
0x0000001016177824ULL, 0x000fe200078e021bULL, 0x00000025060e7210ULL, 0x000fe20007fde0ffULL,
0x0000000110067824ULL, 0x100fe200078e0239ULL, 0x0000003b13157212ULL, 0x040fe200078e3cffULL,
0x000000011a397824ULL, 0x000fe400078e0239ULL, 0x000000ffff0f7224ULL, 0x000fe200030e0607ULL,
0x0000002508107210ULL, 0x000fe20007fde0ffULL, 0x00000008131a7824ULL, 0x000fe200078e00ffULL,
0x0000003b1c087212ULL, 0x000fe200078e3cffULL, 0x00005e0006067625ULL, 0x000fc600078e0023ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee215ULL, 0x000000081c137824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200030e0609ULL, 0x0000002506067210ULL, 0x000fe20007fde0ffULL,
0x0000001014157824ULL, 0x000fe200078e021bULL, 0xfffffff8131c7812ULL, 0x000fe200078ee208ULL,
0x00005e0039087625ULL, 0x000fc800078e0023ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000002508087210ULL, 0x000fe20007fde0ffULL, 0x0000001012137824ULL, 0x100fe400078e021bULL,
0x0000001018197824ULL, 0x100fe400078e021bULL, 0x000000101a1d7824ULL, 0x100fe200078e021bULL,
0x000000000a137faeULL, 0x0003e2000e901c48ULL, 0x000000101c1b7824ULL, 0x000fe400078e021bULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x000000000c157faeULL, 0x0003e8000e101c48ULL,
0x000000000e177faeULL, 0x0003e8000d901c48ULL, 0x0000000010197faeULL, 0x0003e8000d101c48ULL,
0x00000000061d7faeULL, 0x0003e8000c901c48ULL, 0x00000000081b7faeULL, 0x0003e2000c101c48ULL,
0x00000b8000007947ULL, 0x000fea0003800000ULL, 0x00000003ff087819ULL, 0x008fe2000001163bULL,
0x0000000439067c24ULL, 0x020fc4000f8e0206ULL, 0x00000080ff247424ULL, 0x000fe200078e00ffULL,
0x00000004080c7810ULL, 0x040fe40007ffe0ffULL, 0x00000014081c7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c08147810ULL, 0x000fe20007ffe0ffULL, 0x000000080c0e7824ULL, 0x040fe200078e00ffULL,
0x0000003b0c077212ULL, 0x080fe200078e3cffULL, 0x000000081c0d7824ULL, 0x000fe200078e00ffULL,
0x0000000808107810ULL, 0x000fe20007ffe0ffULL, 0x0000000814167824ULL, 0x000fe200078e00ffULL,
0x0000003b1c0a7212ULL, 0x000fc400078e3cffULL, 0x00000024082e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000810127824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe400078ee207ULL,
0x0000001c08267810ULL, 0x000fe40007ffe0ffULL, 0x0000003b14077212ULL, 0x080fe400078e3cffULL,
0x0000001008187810ULL, 0x000fe20007ffe0ffULL, 0x0000000826287824ULL, 0x000fe200078e00ffULL,
0x0000003b10097212ULL, 0x000fc400078e3cffULL, 0xfffffff80d1e7812ULL, 0x000fe200078ee20aULL,
0x000000082e0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee207ULL,
0x00000008181a7824ULL, 0x000fe200078e00ffULL, 0x0000003b2e0a7212ULL, 0x080fe400078e3cffULL,
0x0000002c08367810ULL, 0x040fe40007ffe0ffULL, 0x00000034084a7810ULL, 0x040fe40007ffe0ffULL,
0x0000001808207810ULL, 0x000fe20007ffe0ffULL, 0x00000008363e7824ULL, 0x000fe200078e00ffULL,
0x0000003b26077212ULL, 0x000fc400078e3cffULL, 0xfffffff812127812ULL, 0x000fe200078ee209ULL,
0x0000000820227824ULL, 0x000fe200078e00ffULL, 0x00000020082a7810ULL, 0x000fe40007ffe0ffULL,
0x0000003b18097212ULL, 0x000fe400078e3cffULL, 0xfffffff80d307812ULL, 0x000fe200078ee20aULL,
0x000000084a0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee207ULL,
0x000000082a2c7824ULL, 0x000fe200078e00ffULL, 0x0000002808327810ULL, 0x000fc40007ffe0ffULL,
0x0000003b36077212ULL, 0x080fe400078e3cffULL, 0x0000003b4a0a7212ULL, 0x080fe200078e3cffULL,
0x0000000832347824ULL, 0x000fe200078e00ffULL, 0x0000003b200b7212ULL, 0x080fe400078e3cffULL,
0xfffffff81a1a7812ULL, 0x000fe400078ee209ULL, 0x0000003008407810ULL, 0x000fe40007ffe0ffULL,
0x0000003b2a097212ULL, 0x000fc400078e3cffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee207ULL,
0x0000000840487824ULL, 0x000fe200078e00ffULL, 0xfffffff80d4c7812ULL, 0x000fe400078ee20aULL,
0xfffffff822227812ULL, 0x000fe400078ee20bULL, 0x00000038084e7810ULL, 0x040fe40007ffe0ffULL,
0x0000007f08077812ULL, 0x040fe400078ec0ffULL, 0x00000007080a7812ULL, 0x000fe200078e483bULL,
0x000000084e507824ULL, 0x000fe200078e00ffULL, 0x0000003b320b7212ULL, 0x000fe200078e3cffULL,
0x0000000107077824ULL, 0x000fe200078e0206ULL, 0xfffffff82c2c7812ULL, 0x000fc400078ee209ULL,
0x0000003c08087810ULL, 0x000fe40007ffe0ffULL, 0x0000003b40097212ULL, 0x080fe400078e3cffULL,
0xfffffff834347812ULL, 0x000fe200078ee20bULL, 0x00000008082b7824ULL, 0x000fe200078e00ffULL,
0x0000007f0c0d7812ULL, 0x000fe400078ec0ffULL, 0x0000007f100f7812ULL, 0x000fe400078ec0ffULL,
0x0000007f14117812ULL, 0x000fe200078ec0ffULL, 0x000000010d0d7824ULL, 0x100fe200078e0206ULL,
0x0000007f18137812ULL, 0x000fe200078ec0ffULL, 0x000000010f0f7824ULL, 0x100fe200078e0206ULL,
0x0000007f1c157812ULL, 0x000fe200078ec0ffULL, 0x0000000111117824ULL, 0x100fe200078e0206ULL,
0x0000007f20177812ULL, 0x000fe200078ec0ffULL, 0x0000000113137824ULL, 0x100fe200078e0206ULL,
0x0000007f26197812ULL, 0x000fe200078ec0ffULL, 0x0000000115157824ULL, 0x100fe200078e0206ULL,
0x0000007f2a1b7812ULL, 0x000fe200078ec0ffULL, 0x0000000117177824ULL, 0x100fe200078e0206ULL,
0x0000007f2e1d7812ULL, 0x000fe200078ec0ffULL, 0x0000000119197824ULL, 0x100fe200078e0206ULL,
0x0000007f321f7812ULL, 0x000fe200078ec0ffULL, 0x000000011b1b7824ULL, 0x100fe200078e0206ULL,
0x0000007f36217812ULL, 0x000fe200078ec0ffULL, 0x000000011d1d7824ULL, 0x100fe200078e0206ULL,
0x0000007f40237812ULL, 0x000fe200078ec0ffULL, 0x000000011f1f7824ULL, 0x100fe200078e0206ULL,
0x0000007f4a257812ULL, 0x000fe200078ec0ffULL, 0x0000000121217824ULL, 0x100fe200078e0206ULL,
0x0000007f4e277812ULL, 0x000fe200078ec0ffULL, 0x0000000123237824ULL, 0x100fe200078e0206ULL,
0x0000007f08297812ULL, 0x000fe200078ec0ffULL, 0x0000000125257824ULL, 0x100fe200078e0206ULL,
0x0000003b4e0b7212ULL, 0x080fe200078e3cffULL, 0x0000000127517824ULL, 0x100fe200078e0206ULL,
0xfffffff848487812ULL, 0x000fe200078ee209ULL, 0x000000103b097824ULL, 0x000fe200078e00ffULL,
0xfffffff850507812ULL, 0x000fe200078ee20bULL, 0x0000000129557824ULL, 0x000fe200078e0206ULL,
0x0000003b080c7212ULL, 0x000fe200078e3cffULL, 0x00000002000b7824ULL, 0x000fe200078e024bULL,
0x0000007009277812ULL, 0x000fe200078ec0ffULL, 0x00005e0007067625ULL, 0x000fe200078e0024ULL,
0x0ffffff80a0a7812ULL, 0x000fc400078ef83bULL, 0x000010000b0b7811ULL, 0x000fe200078e68ffULL,
0x00005e000d087625ULL, 0x000fe200078e0024ULL, 0xfffffff82b0c7812ULL, 0x000fe400078ee20cULL,
0x0000002706067210ULL, 0x000fe20007f1e0ffULL, 0x000000100a297824ULL, 0x100fe400078e020bULL,
0x000000100e2b7824ULL, 0x100fe400078e020bULL, 0x00000010122d7824ULL, 0x100fe400078e020bULL,
0x00000010162f7824ULL, 0x000fc400078e020bULL, 0x000000101a317824ULL, 0x100fe400078e020bULL,
0x000000101e337824ULL, 0x100fe400078e020bULL, 0x0000001022357824ULL, 0x100fe400078e020bULL,
0x0000001028377824ULL, 0x100fe400078e020bULL, 0x000000102c397824ULL, 0x100fe400078e020bULL,
0x00000010303d7824ULL, 0x000fc400078e020bULL, 0x00000010343f7824ULL, 0x100fe400078e020bULL,
0x000000103e417824ULL, 0x100fe400078e020bULL, 0x00000010484d7824ULL, 0x100fe400078e020bULL,
0x000000104c4f7824ULL, 0x100fe400078e020bULL, 0x0000001050537824ULL, 0x100fe400078e020bULL,
0x000000100c577824ULL, 0x000fc400078e020bULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000002708087210ULL, 0x000fe20007f1e0ffULL, 0x00005e000f0a7625ULL, 0x000fc600078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006297faeULL, 0x0003e2000b901c48ULL,
0x00005e00130e7625ULL, 0x000fe200078e0024ULL, 0x000000270a0a7210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x000000270e0e7210ULL, 0x000fe20007f1e0ffULL,
0x00005e00110c7625ULL, 0x000fc600078e0024ULL, 0x00000000082b7faeULL, 0x0003e2000b901c48ULL,
0x00005e0017127625ULL, 0x000fe200078e0024ULL, 0x000000270c0c7210ULL, 0x000fc60007f5e0ffULL,
0x00005e0015107625ULL, 0x000fc800078e0024ULL, 0x000000ffff0f7224ULL, 0x000fe200000e060fULL,
0x0000002712127210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000002710107210ULL, 0x000fe20007f3e0ffULL, 0x00005e001b167625ULL, 0x000fc600078e0024ULL,
0x000000000a2d7faeULL, 0x0003e2000b901c48ULL, 0x00005e0019147625ULL, 0x000fc800078e0024ULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000002716167210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x0000002714147210ULL, 0x000fe20007f3e0ffULL,
0x00005e001d187625ULL, 0x000fc800078e0024ULL, 0x00005e00211c7625ULL, 0x000fc800078e0024ULL,
0x00005e001f1a7625ULL, 0x000fc800078e0024ULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x000000271c1c7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200008e0615ULL,
0x0000002718187210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e060dULL,
0x000000271a1a7210ULL, 0x000fe20007f5e0ffULL, 0x00005e00231e7625ULL, 0x000fc600078e0024ULL,
0x000000000c2f7faeULL, 0x0003e2000b901c48ULL, 0x00005e0025207625ULL, 0x000fc600078e0024ULL,
0x000000000e317faeULL, 0x0003e2000b901c48ULL, 0x00005e0051227625ULL, 0x000fc600078e0024ULL,
0x0000000010337faeULL, 0x0003e2000b901c48ULL, 0x00005e0055247625ULL, 0x000fc600078e0024ULL,
0x0000000012357faeULL, 0x0003e2000b901c48ULL, 0x000000ffff1d7224ULL, 0x000fe200000e061dULL,
0x000000271e1e7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x0000002720207210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200010e061bULL,
0x0000002722227210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e061fULL,
0x0000002724247210ULL, 0x000fe20007f7e0ffULL, 0x0000000014377faeULL, 0x0003e2000b901c48ULL,
0x000000ffff217224ULL, 0x000fc400008e0621ULL, 0x000000ffff237224ULL, 0x000fe200010e0623ULL,
0x0000000016397faeULL, 0x0003e2000b901c48ULL, 0x000000ffff257224ULL, 0x000fc600018e0625ULL,
0x00000000183d7faeULL, 0x0003e8000b901c48ULL, 0x000000001a3f7faeULL, 0x0003e8000b901c48ULL,
0x000000001c417faeULL, 0x0003e8000b901c48ULL, 0x000000001e4d7faeULL, 0x0003e8000b901c48ULL,
0x00000000204f7faeULL, 0x0003e8000b901c48ULL, 0x0000000022537faeULL, 0x0003e8000b901c48ULL,
0x0000000024577faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300ff077624ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff397424ULL, 0x000fc400078e00ffULL, 0x00000002073a7824ULL, 0x000fca00078e023aULL,
0x000000fb3a00720cULL, 0x000fda0003f06070ULL, 0x0000000243068824ULL, 0x000fe400078e023aULL,
0x00000004ff078424ULL, 0x000fe200078e00ffULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff4a7224ULL, 0x000fe200078e00ffULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000600006068625ULL, 0x000fe200078e0007ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x0000000806398981ULL, 0x000362000c1e1900ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x002fc80000000000ULL,
0xfffffff83b067812ULL, 0x000fe200078ec0ffULL, 0x00000002002d7824ULL, 0x000fe200078e0245ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000001482a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000706077812ULL, 0x000fe400078ef83bULL, 0x000010002d2d7811ULL, 0x000fe400078e68ffULL,
0x0000000748067812ULL, 0x100fe400078e7807ULL, 0x000000203b2b7810ULL, 0x000fe40007ffe0ffULL,
0x000000072a287812ULL, 0x000fe200078e7807ULL, 0x0000000807067824ULL, 0x000fe200078e0206ULL,
0x000000073be47812ULL, 0x000fc600078ec0ffULL, 0x0000001006067824ULL, 0x000fe200078e022dULL,
0x00000008e4e47812ULL, 0x000fe200078ef83bULL, 0x0000000807287824ULL, 0x000fc600078e0228ULL,
0x000000000634783bULL, 0x000e620000000200ULL, 0x0000001028287824ULL, 0x000fca00078e022dULL,
0x000000002830783bULL, 0x0004e20000000200ULL, 0x00000018ff067819ULL, 0x002fe20000011434ULL,
0x0001000034587824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x004fe20000011435ULL,
0x00000035008c7306ULL, 0x000fe20000009400ULL, 0x00000018ff297819ULL, 0x000fe20000011436ULL,
0x0001000035597824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000018ff4c7819ULL, 0x008fe40000011430ULL, 0x00000018ff3d7819ULL, 0x000fe20000011437ULL,
0x0000000600ac7306ULL, 0x000fe20000209400ULL, 0x00000018ff4f7819ULL, 0x000fc40000011433ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff4e7819ULL, 0x000fe40000011432ULL,
0x00000018ff4d7819ULL, 0x000fe20000011431ULL, 0x0000000600797306ULL, 0x000e700000205400ULL,
0x0000000600947306ULL, 0x0004f0000020d400ULL, 0x0000002800ad7306ULL, 0x000fe20000209400ULL,
0xfffffff82b067812ULL, 0x004fc400078ec0ffULL, 0x00000079ac00720bULL, 0x002fe40003f7d000ULL,
0x00000007062f7812ULL, 0x000fc600078ef83bULL, 0x0000002800ae7306ULL, 0x000e620000205400ULL,
0x0000000748067812ULL, 0x040fe400078e782fULL, 0x0000000248487810ULL, 0x000fc60007ffe0ffULL,
0x000000082f067824ULL, 0x000fe400078e0206ULL, 0x0000002800077306ULL, 0x000522000020d400ULL,
0x0000000194943812ULL, 0x008fce00078efcffULL, 0x0000002900a57306ULL, 0x000fe20000209400ULL,
0x0000001006287824ULL, 0x004fe200078e022dULL, 0x000000072a067812ULL, 0x000fe400078e782fULL,
0x000000aead00720bULL, 0x002fc60003f9d000ULL, 0x000000082f067824ULL, 0x000fe200078e0206ULL,
0x0000002900a27306ULL, 0x000fe60000205400ULL, 0x00000010062d7824ULL, 0x000fca00078e022dULL,
0x0000002900827306ULL, 0x0003e2000020d400ULL, 0x000000002d2c783bULL, 0x000ea20000000200ULL,
0x0000000107074812ULL, 0x010fcc00078efcffULL, 0x0000003500ab7306ULL, 0x000ee20000005400ULL,
0x000000002828783bULL, 0x002e6e0000000200ULL, 0x0000003500937306ULL, 0x0008b0000000d400ULL,
0x0000005800b87306ULL, 0x000fe20000209400ULL, 0x0000010035357824ULL, 0x010fe200078e00ffULL,
0x000000ab8c00720bULL, 0x008fc80003f3d000ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000005800b77306ULL, 0x000eee0000205400ULL, 0x0000000193931812ULL, 0x004fe200078efcffULL,
0x0000005800a07306ULL, 0x000522000020d400ULL, 0x00000018ff717819ULL, 0x000fe2000001142dULL,
0x000100002cac7824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fc4000001142eULL,
0x00000018ff627819ULL, 0x000fe4000001142cULL, 0x00000018ff757819ULL, 0x000fe2000001142fULL,
0x0000003500c37306ULL, 0x000fe20000209400ULL, 0x0001000036587824ULL, 0x004fe200078e00ffULL,
0x000000b7b800720bULL, 0x008fe20003fdd000ULL, 0x00010000286d7824ULL, 0x002fe200078e00ffULL,
0x000000a2a500720bULL, 0x000fe40003f3d000ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x0000003500c67306ULL, 0x000e620000205400ULL, 0x00000018ff6d7819ULL, 0x000fc4000001146dULL,
0x00000018ffac7819ULL, 0x000fc800000114acULL, 0x00000001a0a06812ULL, 0x010fe200078efcffULL,
0x00000035008e7306ULL, 0x0004e2000020d400ULL, 0x0000000182821812ULL, 0x000fce00078efcffULL,
0x0000003400907306ULL, 0x000fe20000009400ULL, 0x00000018ff357819ULL, 0x004fe40000011428ULL,
0x000000c6c300720bULL, 0x002fca0003fdd000ULL, 0x0000003400af7306ULL, 0x000e700000005400ULL,
0x0000003400977306ULL, 0x000522000000d400ULL, 0x000000018e8e6812ULL, 0x008fc800078efcffULL,
0x0000008e0707723eULL, 0x000fc600000010ffULL, 0x0000003500d07306ULL, 0x000fe20000209400ULL,
0x0000010034347824ULL, 0x004fe200078e00ffULL, 0x000000af9000720bULL, 0x002fc80003fbd000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003500d37306ULL, 0x000fee0000205400ULL,
0x0000000197975812ULL, 0x010fe200078efcffULL, 0x0000003500777306ULL, 0x0003f0000020d400ULL,
0x00000030009d7306ULL, 0x000fe20000009400ULL, 0x0001000030357824ULL, 0x002fca00078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000030009a7306ULL, 0x000ff00000005400ULL,
0x0000003000547306ULL, 0x0003f0000000d400ULL, 0x0000005800c87306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x002fce00078e00ffULL, 0x0000005800c97306ULL, 0x000ff00000205400ULL,
0x00000058008d7306ULL, 0x0003f0000020d400ULL, 0x0000003400b97306ULL, 0x000fe20000209400ULL,
0x00000018ff587819ULL, 0x002fce0000011429ULL, 0x0000005800d17306ULL, 0x000ff00000209400ULL,
0x0000005800ce7306ULL, 0x000ff00000205400ULL, 0x00000058006c7306ULL, 0x0003f0000020d400ULL,
0x0000003400b67306ULL, 0x000ea20000205400ULL, 0x00000018ff587819ULL, 0x002fce0000011430ULL,
0x0000003400a17306ULL, 0x0002f0000020d400ULL, 0x0000005800c77306ULL, 0x000fe20000209400ULL,
0x0001000037347824ULL, 0x002fe200078e00ffULL, 0x000000b6b900720bULL, 0x004fc80003f1d000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000005800c27306ULL, 0x000fee0000205400ULL,
0x00000001a1a10812ULL, 0x008fe200078efcffULL, 0x0000005800307306ULL, 0x0003e2000020d400ULL,
0x000000c9c800720bULL, 0x000fce0003f1d000ULL, 0x0000003700a77306ULL, 0x000fe20000009400ULL,
0x0001000033587824ULL, 0x002fca00078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011458ULL,
0x0000003700a47306ULL, 0x000e620000005400ULL, 0x000000018d8d0812ULL, 0x000fce00078efcffULL,
0x00000037007a7306ULL, 0x0004f0000000d400ULL, 0x0000003300957306ULL, 0x000fe20000009400ULL,
0x0000010037377824ULL, 0x004fe200078e00ffULL, 0x000000a4a700720bULL, 0x002fc80003f7d000ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000003300967306ULL, 0x000fee0000005400ULL,
0x000000017a7a3812ULL, 0x008fe200078efcffULL, 0x0000003300517306ULL, 0x0003f0000000d400ULL,
0x0000003600a67306ULL, 0x000fe20000009400ULL, 0x0000010033337824ULL, 0x002fca00078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe40000011433ULL, 0x0000003600a97306ULL, 0x000e700000005400ULL,
0x0000003600887306ULL, 0x0004f0000000d400ULL, 0x0000003400cc7306ULL, 0x000fe20000209400ULL,
0x0000010036367824ULL, 0x004fe200078e00ffULL, 0x000000a9a600720bULL, 0x002fc80003fbd000ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000003400cd7306ULL, 0x000e6e0000205400ULL,
0x0000000188885812ULL, 0x008fe200078efcffULL, 0x0000003400877306ULL, 0x0004f0000020d400ULL,
0x0000005c00737306ULL, 0x000fe20000209400ULL, 0x00000018ff347819ULL, 0x004fc4000001142aULL,
0x000000cdcc00720bULL, 0x002fca0003f9d000ULL, 0x0000005c00747306ULL, 0x000ff00000205400ULL,
0x0000005c00587306ULL, 0x000fe2000020d400ULL, 0x0000000187874812ULL, 0x008fc800078efcffULL,
0x0000007a877a723eULL, 0x000fc600000010ffULL, 0x00000071005b7306ULL, 0x000ff00000209400ULL,
0x00000071005c7306ULL, 0x000ff00000205400ULL, 0x00000071005d7306ULL, 0x0003f0000020d400ULL,
0x0000002800b57306ULL, 0x000fe20000009400ULL, 0x0001000029717824ULL, 0x002fca00078e00ffULL,
0x00000018ffd87819ULL, 0x000fe40000011471ULL, 0x0000002800b47306ULL, 0x000e700000005400ULL,
0x0000002800707306ULL, 0x0004f0000000d400ULL, 0x0000002900b27306ULL, 0x000fe20000009400ULL,
0x0000010028287824ULL, 0x004fe200078e00ffULL, 0x000000b4b500720bULL, 0x002fcc0003fbd000ULL,
0x0000002900b17306ULL, 0x000e6e0000005400ULL, 0x0000000170705812ULL, 0x008fe200078efcffULL,
0x00000029006b7306ULL, 0x0004f0000000d400ULL, 0x0000003700d27306ULL, 0x000fe20000209400ULL,
0x0000010029297824ULL, 0x004fe200078e00ffULL, 0x000000b1b200720bULL, 0x002fc80003f3d000ULL,
0x00000018ffdb7819ULL, 0x000fe20000011429ULL, 0x000100002a297824ULL, 0x000fe200078e00ffULL,
0x0000003700cf7306ULL, 0x000e680000205400ULL, 0x00000018ffdc7819ULL, 0x000fc60000011429ULL,
0x000000016b6b1812ULL, 0x008fe200078efcffULL, 0x00000037007b7306ULL, 0x0004f0000020d400ULL,
0x0000003400c57306ULL, 0x000fe20000209400ULL, 0x00000018ff377819ULL, 0x004fc4000001142bULL,
0x000000cfd200720bULL, 0x002fca0003f1d000ULL, 0x0000003400c47306ULL, 0x000e700000205400ULL,
0x0000003400687306ULL, 0x000522000020d400ULL, 0x000000017b7b0812ULL, 0x008fe400078efcffULL,
0x000000d3d000720bULL, 0x000fca0003f1d000ULL, 0x0000005f006f7306ULL, 0x000fe20000209400ULL,
0x0001000031347824ULL, 0x004fe200078e00ffULL, 0x000000c4c500720bULL, 0x002fcc0003f3d000ULL,
0x0000005f006e7306ULL, 0x000fe20000205400ULL, 0x0000000177770812ULL, 0x000fcc00078efcffULL,
0x0000000168681812ULL, 0x010fe200078efcffULL, 0x0000005f00337306ULL, 0x000fe2000020d400ULL,
0x000000969500720bULL, 0x000fce0003f3d000ULL, 0x00000072005e7306ULL, 0x000fec0000209400ULL,
0x0000000151511812ULL, 0x000fe400078efcffULL, 0x00000072005f7306ULL, 0x000ff00000205400ULL,
0x0000007200607306ULL, 0x0003f0000020d400ULL, 0x0000002a00b37306ULL, 0x000fe20000009400ULL,
0x00000018ff727819ULL, 0x002fce0000011428ULL, 0x0000002a00b07306ULL, 0x000e700000005400ULL,
0x0000002a00667306ULL, 0x0004f0000000d400ULL, 0x0000003600ca7306ULL, 0x000fe20000209400ULL,
0x000001002a2a7824ULL, 0x004fe200078e00ffULL, 0x000000b0b300720bULL, 0x002fc80003f9d000ULL,
0x00000018ffdf7819ULL, 0x000fe2000001142aULL, 0x000100002b2a7824ULL, 0x000fe200078e00ffULL,
0x0000003600cb7306ULL, 0x000fe80000205400ULL, 0x00000018ffe27819ULL, 0x000fe4000001142aULL,
0x0000004a3b2a7211ULL, 0x000fe400078fe0ffULL, 0x0000003600897306ULL, 0x000fe2000020d400ULL,
0x0000000166664812ULL, 0x008fc400078efcffULL, 0x000000044a4a7810ULL, 0x000fca0007ffe0ffULL,
0x0000003700c17306ULL, 0x000ff00000209400ULL, 0x0000003700be7306ULL, 0x000ff00000205400ULL,
0x0000003700367306ULL, 0x0003f0000020d400ULL, 0x0000003500bf7306ULL, 0x000fe20000209400ULL,
0x00000018ff377819ULL, 0x002fe20000011434ULL, 0x0000010031347824ULL, 0x000fcc00078e00ffULL,
0x0000003500c07306ULL, 0x000ff00000205400ULL, 0x0000003500657306ULL, 0x0003f0000020d400ULL,
0x0000003200987306ULL, 0x000fe20000009400ULL, 0x0001000032357824ULL, 0x002fca00078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe40000011435ULL, 0x00000032009b7306ULL, 0x000ff00000005400ULL,
0x00000032003e7306ULL, 0x0003f0000000d400ULL, 0x0000005900bb7306ULL, 0x000fe20000209400ULL,
0x0000010032327824ULL, 0x002fce00078e00ffULL, 0x0000005900ba7306ULL, 0x000e700000205400ULL,
0x0000007200287306ULL, 0x000ff00000209400ULL, 0x0000007200d77306ULL, 0x000ea20000205400ULL,
0x000000babb00720bULL, 0x002fce0003f5d000ULL, 0x0000003100997306ULL, 0x000ff00000009400ULL,
0x00000031009c7306ULL, 0x000fe20000005400ULL, 0x000000d72800720bULL, 0x004fe20003f7d000ULL,
0x000100002d287824ULL, 0x000fcc00078e00ffULL, 0x0000003100407306ULL, 0x000ff0000000d400ULL,
0x0000002b009e7306ULL, 0x000ff00000009400ULL, 0x0000002b009f7306ULL, 0x000ff00000005400ULL,
0x0000002b00577306ULL, 0x0003f0000000d400ULL, 0x0000005900aa7306ULL, 0x0004e2000020d400ULL,
0x000001002b2b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x0000003700bd7306ULL, 0x000fe20000209400ULL, 0x00000018ff597819ULL, 0x004fce0000011434ULL,
0x0000003700bc7306ULL, 0x000fe20000205400ULL, 0x00000001aaaa2812ULL, 0x008fe400078efcffULL,
0x000000cbca00720bULL, 0x000fca0003f5d000ULL, 0x0000003700317306ULL, 0x0003f0000020d400ULL,
0x0000005900927306ULL, 0x000fe20000209400ULL, 0x00000018ff377819ULL, 0x002fe40000011432ULL,
0x0000000189892812ULL, 0x000fca00078efcffULL, 0x00000059008f7306ULL, 0x000ff00000205400ULL,
0x0000005900347306ULL, 0x000ff0000020d400ULL, 0x0000005a00837306ULL, 0x000ff00000209400ULL,
0x0000005a00847306ULL, 0x000ff00000205400ULL, 0x0000005a00357306ULL, 0x000ff0000020d400ULL,
0x0000003700867306ULL, 0x000ff00000209400ULL, 0x0000003700857306ULL, 0x000ff00000205400ULL,
0x0000003700327306ULL, 0x000ff0000020d400ULL, 0x0000006200377306ULL, 0x000ff00000209400ULL,
0x00000062005a7306ULL, 0x000ff00000205400ULL, 0x0000006200597306ULL, 0x000ff0000020d400ULL,
0x0000007500617306ULL, 0x000ff00000209400ULL, 0x0000007500627306ULL, 0x000ff00000205400ULL,
0x0000007500637306ULL, 0x000ff0000020d400ULL, 0x0000007200807306ULL, 0x000e70000020d400ULL,
0x000000dc00da7306ULL, 0x000ff00000209400ULL, 0x000000dc00297306ULL, 0x000ea20000205400ULL,
0x0000000180803812ULL, 0x002fc800078efcffULL, 0x000000807777723eULL, 0x000fc600000010ffULL,
0x000000dc00757306ULL, 0x000e70000020d400ULL, 0x0000002b00dc7306ULL, 0x000fe20000209400ULL,
0x00000029da00720bULL, 0x004fce0003f7d000ULL, 0x0000002b00b77306ULL, 0x000eac0000205400ULL,
0x0000000175753812ULL, 0x002fe400078efcffULL, 0x0000003d00a37306ULL, 0x000fe20000209400ULL,
0x0000009c9900720bULL, 0x000fe20003f7d000ULL, 0x000100002e997824ULL, 0x000fe200078e00ffULL,
0x000000667566723eULL, 0x000fc800000010ffULL, 0x00000018ff997819ULL, 0x000fe20000011499ULL,
0x0000003d00a87306ULL, 0x000e620000205400ULL, 0x000000b7dc00720bULL, 0x004fca0003f9d000ULL,
0x0000000140403812ULL, 0x000fe400078efcffULL, 0x0000002b00797306ULL, 0x000ea2000020d400ULL,
0x000000848300720bULL, 0x000fce0003f7d000ULL, 0x0000006d00d57306ULL, 0x000fe20000209400ULL,
0x000000a8a300720bULL, 0x002fe40003fdd000ULL, 0x00000018ffa87819ULL, 0x000fc60000011428ULL,
0x0000000135353812ULL, 0x000fe400078efcffULL, 0x0000006d00d47306ULL, 0x000e620000205400ULL,
0x0000000179794812ULL, 0x004fe400078efcffULL, 0x000000c2c700720bULL, 0x000fe40003f9d000ULL,
0x000000747300720bULL, 0x000fc60003f7d000ULL, 0x000000db00dd7306ULL, 0x000ff00000209400ULL,
0x000000db00de7306ULL, 0x000ea20000205400ULL, 0x000000d4d500720bULL, 0x002fe40003f5d000ULL,
0x0000000130304812ULL, 0x000fc400078efcffULL, 0x0000008f9200720bULL, 0x000fe40003f9d000ULL,
0x0000000158583812ULL, 0x000fe200078efcffULL, 0x0000003d00767306ULL, 0x000e70000020d400ULL,
0x0000006d00817306ULL, 0x000ee2000020d400ULL, 0x000000dedd00720bULL, 0x004fc40003fbd000ULL,
0x0000000134344812ULL, 0x000fe400078efcffULL, 0x000000858600720bULL, 0x000fc60003f9d000ULL,
0x000000df00e07306ULL, 0x000fe20000209400ULL, 0x0000000176766812ULL, 0x002fe400078efcffULL,
0x000000ced100720bULL, 0x000fe40003fdd000ULL, 0x0000007b767b723eULL, 0x000fc600000010ffULL,
0x000000df00e17306ULL, 0x000e620000205400ULL, 0x0000000181812812ULL, 0x008fe400078efcffULL,
0x0000000132324812ULL, 0x000fe400078efcffULL, 0x0000006e6f00720bULL, 0x000fe40003f9d000ULL,
0x000000708176723eULL, 0x000fe200000010ffULL, 0x000000df006d7306ULL, 0x0005e2000020d400ULL,
0x000000016c6c6812ULL, 0x000fce00078efcffULL, 0x000000db00717306ULL, 0x000ee2000020d400ULL,
0x000000022adf7810ULL, 0x044fe40007ffe0ffULL, 0x000000072a2a7812ULL, 0x100fe400078e78e4ULL,
0x000000e1e000720bULL, 0x002fe40003f1d000ULL, 0x00000007dfdf7812ULL, 0x000fe200078e78e4ULL,
0x000000d800d67306ULL, 0x000fe20000209400ULL, 0x00000010e42a7824ULL, 0x000fe200078e022aULL,
0x0000000133334812ULL, 0x000fc400078efcffULL, 0x00000010e4907824ULL, 0x000fe400078e02dfULL,
0x000000102a2a7824ULL, 0x000fe400078e00ffULL, 0x000000d800d97306ULL, 0x000e620000205400ULL,
0x0000000171715812ULL, 0x008fe400078efcffULL, 0x0000009f9e00720bULL, 0x000fe20003fbd000ULL,
0x000000002a28783bULL, 0x000ea20000000200ULL, 0x000000016d6d0812ULL, 0x000fe400078efcffULL,
0x0000009b9800720bULL, 0x000fe20003f1d000ULL, 0x000000d800787306ULL, 0x000ee2000020d400ULL,
0x000001002f9b7824ULL, 0x000fe200078e00ffULL, 0x000000716c71723eULL, 0x000fc800000010ffULL,
0x00000018ff9b7819ULL, 0x000fe4000001149bULL, 0x000000e200d87306ULL, 0x000fe20000209400ULL,
0x000000d9d600720bULL, 0x002fe40003f5d000ULL, 0x0000000157575812ULL, 0x000fe400078efcffULL,
0x000000c0bf00720bULL, 0x000fe40003fbd000ULL, 0x000000013e3e0812ULL, 0x000fe200078efcffULL,
0x000000e200db7306ULL, 0x000e660000205400ULL, 0x0000003e353e723eULL, 0x000fc600000010ffULL,
0x0000000178782812ULL, 0x008fe400078efcffULL, 0x000000e200727306ULL, 0x000ee2000020d400ULL,
0x0000009a9d00720bULL, 0x000fe20003f5d000ULL, 0x000100002f9a7824ULL, 0x000fe200078e00ffULL,
0x0000000165655812ULL, 0x000fe400078efcffULL, 0x000000bcbd00720bULL, 0x000fe40003fbd000ULL,
0x0000006b7870723eULL, 0x000fe200000010ffULL, 0x0000004d008a7306ULL, 0x000fe20000209400ULL,
0x000000dbd800720bULL, 0x002fc40003fdd000ULL, 0x00000018ff9a7819ULL, 0x000fe2000001149aULL,
0x0000007a2820723cULL, 0x044fe40000041820ULL, 0x0000000154542812ULL, 0x000fe400078efcffULL,
0x0000004d008b7306ULL, 0x000e640000205400ULL, 0x0000000131315812ULL, 0x000fe400078efcffULL,
0x00000076281c723cULL, 0x000fe2000004181cULL, 0x000000546554723eULL, 0x000fc400000010ffULL,
0x0000000172726812ULL, 0x008fe200078efcffULL, 0x000000ac008c7306ULL, 0x000fe20000209400ULL,
0x000000bec100720bULL, 0x000fe40003fdd000ULL, 0x000000577272723eULL, 0x000fe200000010ffULL,
0x000000702818723cULL, 0x000fe20000041818ULL, 0x000000403140723eULL, 0x000fc600000010ffULL,
0x000000ac00a77306ULL, 0x000ea20000205400ULL, 0x0000008b8a00720bULL, 0x002fca0003f5d000ULL,
0x0000000136366812ULL, 0x000fe400078efcffULL, 0x0000004c00917306ULL, 0x000fe40000209400ULL,
0x000000793673723eULL, 0x000fcc00000010ffULL, 0x0000004c00067306ULL, 0x000e620000205400ULL,
0x000000a78c00720bULL, 0x004fe20003f7d000ULL, 0x000000722810723cULL, 0x000fec0000041810ULL,
0x0000002c006a7306ULL, 0x000ff00000009400ULL, 0x0000002c00697306ULL, 0x000fe20000005400ULL,
0x000000069100720bULL, 0x002fc40003fdd000ULL, 0x00000093aa06723eULL, 0x000fca00000010ffULL,
0x0000002c00507306ULL, 0x0003e4000000d400ULL, 0x000000062808723cULL, 0x000fec0000041808ULL,
0x0000004c00417306ULL, 0x000ea2000020d400ULL, 0x000001002c2c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000004f007f7306ULL, 0x000ff00000209400ULL,
0x0000004f007c7306ULL, 0x000e620000205400ULL, 0x0000000141416812ULL, 0x004fce00078efcffULL,
0x0000004f004c7306ULL, 0x000eb0000020d400ULL, 0x0000002d00647306ULL, 0x000fe20000009400ULL,
0x0000007c7f00720bULL, 0x002fce0003fbd000ULL, 0x0000002d00677306ULL, 0x000e6c0000005400ULL,
0x000000014c4c5812ULL, 0x004fe400078efcffULL, 0x0000002d004f7306ULL, 0x0005e2000000d400ULL,
0x0000005a3700720bULL, 0x000fe40003fbd000ULL, 0x000000334c33723eULL, 0x000fca00000010ffULL,
0x0000004d003f7306ULL, 0x000ee2000020d400ULL, 0x000001002d2d7824ULL, 0x004fe200078e00ffULL,
0x000000676400720bULL, 0x002fe40003f1d000ULL, 0x0000006d6867723eULL, 0x000fe400000010ffULL,
0x00000018ff957819ULL, 0x000fe4000001142dULL, 0x000000ac00a37306ULL, 0x000e62000020d400ULL,
0x000000a1942d723eULL, 0x000fe400000010ffULL, 0x000000662814723cULL, 0x000fe20000041814ULL,
0x0000000159595812ULL, 0x000fc400078efcffULL, 0x0000005f5e00720bULL, 0x000fe40003fbd000ULL,
0x0000002c00a27306ULL, 0x000fe20000209400ULL, 0x000000013f3f2812ULL, 0x008fe400078efcffULL,
0x000000696a00720bULL, 0x000fe40003f5d000ULL, 0x000000014f4f0812ULL, 0x000fe400078efcffULL,
0x000000626100720bULL, 0x000fe20003f1d000ULL, 0x0000002c00a57306ULL, 0x000ea20000205400ULL,
0x00000001a3a33812ULL, 0x002fc400078efcffULL, 0x0000000160605812ULL, 0x000fca00078efcffULL,
0x000000a800a67306ULL, 0x000fe20000209400ULL, 0x0000000150502812ULL, 0x000fe400078efcffULL,
0x0000005c5b00720bULL, 0x000fe40003f5d000ULL, 0x0000000163630812ULL, 0x000fe400078efcffULL,
0x000000084800780cULL, 0x000fe20003f05270ULL, 0x000000a8009d7306ULL, 0x000e620000205400ULL,
0x000000a5a200720bULL, 0x004fe40003f9d000ULL, 0x00000050a350723eULL, 0x000fca00000010ffULL,
0x0000002c00a47306ULL, 0x0004e2000020d400ULL, 0x000000015d5d2812ULL, 0x000fce00078efcffULL,
0x000000a800987306ULL, 0x000f22000020d400ULL, 0x00000097a02c723eULL, 0x004fe400000010ffULL,
0x0000009da600720bULL, 0x002fca0003f7d000ULL, 0x0000002c280c723cULL, 0x000fe2000004180cULL,
0x0000004e007d7306ULL, 0x000fe20000209400ULL, 0x00000001a4a44812ULL, 0x008fca00078efcffULL,
0x000000888d2c723eULL, 0x000fe400000010ffULL, 0x0000004e007e7306ULL, 0x000e620000205400ULL,
0x00000089822d723eULL, 0x000fe400000010ffULL, 0x0000000198983812ULL, 0x010fc800078efcffULL,
0x0000004f985c723eULL, 0x000fe200000010ffULL, 0x0000009500967306ULL, 0x000fe20000209400ULL,
0x0000002c2824723cULL, 0x000fee0000041824ULL, 0x0000009500977306ULL, 0x000ea20000205400ULL,
0x00000010902c7824ULL, 0x000fe200078e00ffULL, 0x0000007e7d00720bULL, 0x002fcc0003fdd000ULL,
0x0000009900887306ULL, 0x000ff00000209400ULL, 0x0000009900077306ULL, 0x000e620000205400ULL,
0x000000979600720bULL, 0x004fce0003f9d000ULL, 0x0000002e00557306ULL, 0x000ff00000009400ULL,
0x0000002e00567306ULL, 0x000fe20000005400ULL, 0x000000078800720bULL, 0x002fce0003f7d000ULL,
0x0000002e004d7306ULL, 0x0003f0000000d400ULL, 0x0000004e003d7306ULL, 0x000ea2000020d400ULL,
0x000001002e2e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe4000001142eULL,
0x0000002f00527306ULL, 0x000ff00000009400ULL, 0x0000002f00537306ULL, 0x000e620000005400ULL,
0x000000013d3d6812ULL, 0x004fc400078efcffULL, 0x000000565500720bULL, 0x000fe40003fdd000ULL,
0x000000304155723eULL, 0x000fe400000010ffULL, 0x000000343f41723eULL, 0x000fe200000010ffULL,
0x0000002f004e7306ULL, 0x0004e2000000d400ULL, 0x000000323d3f723eULL, 0x000fe400000010ffULL,
0x000000515832723eULL, 0x000fe400000010ffULL, 0x000000a45951723eULL, 0x000fc600000010ffULL,
0x0000009500947306ULL, 0x000f22000020d400ULL, 0x000000002c2c783bULL, 0x004ea20000000200ULL,
0x000000535200720bULL, 0x002fe40003f3d000ULL, 0x000000014d4d6812ULL, 0x000fc800078efcffULL,
0x0000009900067306ULL, 0x000e6e000020d400ULL, 0x000000014e4e1812ULL, 0x008fe200078efcffULL,
0x0000007a00697306ULL, 0x000fe20000209400ULL, 0x0000000194944812ULL, 0x010fc800078efcffULL,
0x000000945d5d723eULL, 0x000fc600000010ffULL, 0x0000007a00647306ULL, 0x000ee20000205400ULL,
0x0000000106063812ULL, 0x002fc800078efcffULL, 0x0000004d0606723eULL, 0x000fc600000010ffULL,
0x0000009a00367306ULL, 0x000ff00000209400ULL, 0x0000009a00297306ULL, 0x000e620000205400ULL,
0x000000646900720bULL, 0x008fe20003f9d000ULL, 0x000000542c0c723cULL, 0x044fec000004180cULL,
0x0000009b00287306ULL, 0x000fe40000209400ULL, 0x000000402c08723cULL, 0x040fec0000041808ULL,
0x0000009b00317306ULL, 0x000ea20000205400ULL, 0x000000293600720bULL, 0x002fe20003f5d000ULL,
0x0000003e2c24723cULL, 0x040fec0000041824ULL, 0x0000007a006b7306ULL, 0x000e64000020d400ULL,
0x000000322c20723cULL, 0x040fec0000041820ULL, 0x0000009a002b7306ULL, 0x000ee2000020d400ULL,
0x000000312800720bULL, 0x004fe20003f7d000ULL, 0x000000502c1c723cULL, 0x040fec000004181cULL,
0x0000009b002a7306ULL, 0x000ea2000020d400ULL, 0x000000016b6b4812ULL, 0x002fe200078efcffULL,
0x0000005c2c18723cULL, 0x000fe60000041818ULL, 0x0000006b6007723eULL, 0x000fc400000010ffULL,
0x000000012b2b2812ULL, 0x008fc800078efcffULL, 0x0000004e2b4e723eULL, 0x000fe200000010ffULL,
0x000000062c14723cULL, 0x000fe20000041814ULL, 0x000000012a2a3812ULL, 0x004fc800078efcffULL,
0x0000002a634f723eULL, 0x000fce00000010ffULL, 0x0000004e2c10723cULL, 0x000fe20000041810ULL,
0x0000001000008944ULL, 0x000fe20003c00000ULL, 0xffffe16000007947ULL, 0x000fec000383ffffULL,
0x01b6140042077984ULL, 0x000e620000000800ULL, 0x0000ffff46067812ULL, 0x000fe200078ec0ffULL,
0x000000203c207220ULL, 0x040fe40000410000ULL, 0x000000213c217220ULL, 0x000fe20000410000ULL,
0x0000888006367816ULL, 0x000fe200000000ffULL, 0x0000000e3c287220ULL, 0x040fe40000410000ULL,
0x0000000f3c297220ULL, 0x040fe40000410000ULL, 0x0000000a3c2a7220ULL, 0x000fc40000410000ULL,
0x0000000b3c2b7220ULL, 0x040fe40000410000ULL, 0x000000243c247220ULL, 0x040fe40000410000ULL,
0x000000253c257220ULL, 0x040fe40000410000ULL, 0x000000263c267220ULL, 0x040fe40000410000ULL,
0x000000273c277220ULL, 0x040fe40000410000ULL, 0x0000001c3c1c7220ULL, 0x000fc40000410000ULL,
0x0000001d3c1d7220ULL, 0x000fe40000410000ULL, 0x8000000036067824ULL, 0x000fe400078e00ffULL,
0x0000000c3c0c7220ULL, 0x040fe40000410000ULL, 0x0000000d3c0d7220ULL, 0x040fe40000410000ULL,
0x000000083c087220ULL, 0x040fe40000410000ULL, 0x000000093c097220ULL, 0x000fc40000410000ULL,
0x000000223c2c7220ULL, 0x040fe40000410000ULL, 0x000000233c2d7220ULL, 0x040fe40000410000ULL,
0x0000001e3c2e7220ULL, 0x040fe20000410000ULL, 0x8000000007ff7812ULL, 0x002fe20007804806ULL,
0x0000001f3c2f7220ULL, 0x040fe40000410000ULL, 0x0000001a3c307220ULL, 0x040fe40000410000ULL,
0x0000001b3c317220ULL, 0x000fc40000410000ULL, 0x000000163c327220ULL, 0x040fe40000410000ULL,
0x000000173c337220ULL, 0x040fe40000410000ULL, 0x000000103c0a7220ULL, 0x040fe40000410000ULL,
0x000000113c0b7220ULL, 0x040fe40000410000ULL, 0x000000143c1a7220ULL, 0x040fe40000410000ULL,
0x000000153c1b7220ULL, 0x000fc40000410000ULL, 0x000000123c347220ULL, 0x040fe40000410000ULL,
0x000000133c357220ULL, 0x000fe40000410000ULL, 0x000000ffff147224ULL, 0x000fe400078e0020ULL,
0x000000ffff157224ULL, 0x000fe400078e0021ULL, 0x000000ffff127224ULL, 0x000fe400078e0024ULL,
0x000000ffff137224ULL, 0x000fc400078e0025ULL, 0x000000ffff167224ULL, 0x000fe400078e001cULL,
0x000000ffff177224ULL, 0x000fe400078e001dULL, 0x000000ffff1e7224ULL, 0x000fe400078e0028ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0029ULL, 0x000000ffff207224ULL, 0x000fe400078e002aULL,
0x000000ffff217224ULL, 0x000fc400078e002bULL, 0x000000ffff227224ULL, 0x000fe400078e0026ULL,
0x000000ffff237224ULL, 0x000fe400078e0027ULL, 0x000000183c187220ULL, 0x040fe40000410000ULL,
0x000000193c197220ULL, 0x000fe40000410000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e000cULL,
0x000000ffff0e7224ULL, 0x000fc400078e000dULL, 0x000000ffff107224ULL, 0x000fe400078e0008ULL,
0x000000ffff117224ULL, 0x000fe400078e0009ULL, 0x000000ffff1c7224ULL, 0x000fe400078e000aULL,
0x000000ffff1d7224ULL, 0x000fe400078e000bULL, 0x000000ffff247224ULL, 0x000fe400078e002cULL,
0x000000ffff257224ULL, 0x000fc400078e002dULL, 0x000000ffff267224ULL, 0x000fe400078e002eULL,
0x000000ffff277224ULL, 0x000fe400078e002fULL, 0x000000ffff287224ULL, 0x000fe400078e0030ULL,
0x000000ffff297224ULL, 0x000fe400078e0031ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0032ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0033ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fc400078e0034ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0035ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000036367824ULL, 0x000fe400078e00ffULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x0000000600077305ULL, 0x0002a4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x000000070000735dULL, 0x004fe40003800000ULL, 0x01b6140042077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007804836ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000043b077824ULL, 0x000fe200078e00ffULL, 0x000000440300720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff007097812ULL, 0x000fca00078ec0ffULL,
0x0000008000067824ULL, 0x000fca00078e0209ULL, 0x01b4000006087984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x000000023b037824ULL, 0x000fe400078e00ffULL,
0x0000000102477824ULL, 0x000fc600078e0a47ULL, 0x00000006030c7812ULL, 0x000fc800078ec0ffULL,
0x000000010c2e7812ULL, 0x040fe400078efcffULL, 0x000000080c307812ULL, 0x000fe400078efcffULL,
0x000000472e00720cULL, 0x080fe40003f26070ULL, 0x000000100c2e7812ULL, 0x000fe400078efcffULL,
0x000000473000720cULL, 0x080fe40003f06070ULL, 0x000000472e00720cULL, 0x000fc40003fc6070ULL,
0x000000110c307812ULL, 0x040fe400078efcffULL, 0x000000180c2e7812ULL, 0x040fe400078efcffULL,
0x000000470c00720cULL, 0x080fe40003f46070ULL, 0x000000473000720cULL, 0x080fe40003fa6070ULL,
0x000000472e00720cULL, 0x000fe40003f66070ULL, 0x000000090c327812ULL, 0x000fc400078efcffULL,
0x000000190c307812ULL, 0x040fe400078efcffULL, 0x000000200c2e7812ULL, 0x000fe400078efcffULL,
0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40004800000ULL,
0x000000473200720cULL, 0x080fe40003f86070ULL, 0x000000473000720cULL, 0x080fe40003f46070ULL,
0x000000472e00720cULL, 0x000fe40003f26070ULL, 0x000000210c307812ULL, 0x040fe400078efcffULL,
0x000000280c2e7812ULL, 0x000fe400078efcffULL, 0xff7fffff20207808ULL, 0x000fc40004000000ULL,
0xff7fffff10107808ULL, 0x000fe40004000000ULL, 0xff7fffff21217808ULL, 0x000fe40006000000ULL,
0xff7fffff11117808ULL, 0x000fe40006000000ULL, 0x000000473000720cULL, 0x080fe40003f06070ULL,
0x000000472e00720cULL, 0x000fe40003f86070ULL, 0x000000290c307812ULL, 0x000fc400078efcffULL,
0x000000300c2e7812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40007000000ULL,
0xff7fffff12127808ULL, 0x000fe40007000000ULL, 0xff7fffff23237808ULL, 0x000fe40006800000ULL,
0xff7fffff13137808ULL, 0x000fe40006800000ULL, 0x000000473000720cULL, 0x000fc40003fc6070ULL,
0x000000472e00720cULL, 0x000fe40003fa6070ULL, 0x000000310c307812ULL, 0x040fe400078efcffULL,
0x000000380c2e7812ULL, 0x040fe400078efcffULL, 0x000000390c0c7812ULL, 0x000fe400078efcffULL,
0xff7fffff24247808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005800000ULL,
0xff7fffff25257808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff26267808ULL, 0x000fe40004800000ULL, 0xff7fffff16167808ULL, 0x000fe40004800000ULL,
0x000000473000720cULL, 0x080fe40003f66070ULL, 0x000000472e00720cULL, 0x000fc40003f46070ULL,
0x000000470c00720cULL, 0x000fe40003f26070ULL, 0xff7fffff27277808ULL, 0x000fe40004000000ULL,
0xff7fffff17177808ULL, 0x000fe40004000000ULL, 0xff7fffff28287808ULL, 0x000fe40006000000ULL,
0xff7fffff18187808ULL, 0x000fe40006000000ULL, 0xff7fffff29297808ULL, 0x000fc40007000000ULL,
0xff7fffff19197808ULL, 0x000fe40007000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40006800000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL, 0xff7fffff2b2b7808ULL, 0x000fe40005800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL, 0xff7fffff2c2c7808ULL, 0x000fc40005000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40004800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000f08037209ULL, 0x004fe40007810000ULL, 0x0000001e09087209ULL, 0x000fe40007810000ULL,
0x0000000e03037209ULL, 0x000fe40007810000ULL, 0x0000001f08097209ULL, 0x000fc40007810000ULL,
0x0000001003087209ULL, 0x000fe40007810000ULL, 0x00000020090c7209ULL, 0x000fe40007810000ULL,
0x0000001108037209ULL, 0x000fe40007810000ULL, 0x000000210c097209ULL, 0x000fe40007810000ULL,
0x0000001203087209ULL, 0x000fe40007810000ULL, 0x00000022090c7209ULL, 0x000fc40007810000ULL,
0x0000001308037209ULL, 0x000fe40007810000ULL, 0x000000230c097209ULL, 0x000fe40007810000ULL,
0x0000001403087209ULL, 0x000fe40007810000ULL, 0x00000024090c7209ULL, 0x000fe40007810000ULL,
0x0000001508037209ULL, 0x000fe40007810000ULL, 0x000000250c097209ULL, 0x000fc40007810000ULL,
0x0000001603087209ULL, 0x000fe40007810000ULL, 0x00000026090c7209ULL, 0x000fe40007810000ULL,
0x0000001708037209ULL, 0x000fe40007810000ULL, 0x000000270c097209ULL, 0x000fe40007810000ULL,
0x0000001803087209ULL, 0x000fe40007810000ULL, 0x00000028090c7209ULL, 0x000fc40007810000ULL,
0x0000001908037209ULL, 0x000fe40007810000ULL, 0x000000290c097209ULL, 0x000fe40007810000ULL,
0x0000001a03087209ULL, 0x000fe40007810000ULL, 0x0000002a090c7209ULL, 0x000fe40007810000ULL,
0x0000001b08037209ULL, 0x000fe40007810000ULL, 0x0000002b0c097209ULL, 0x000fc40007810000ULL,
0x0000001c03087209ULL, 0x000fe40007810000ULL, 0x0000002c090c7209ULL, 0x000fe40007810000ULL,
0x0000001d08087209ULL, 0x000fe40007810000ULL, 0x0000002d0c327209ULL, 0x000fe20007810000ULL,
0x00000eb27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0008037f89ULL, 0x0004e400000e0000ULL,
0x0000000308347209ULL, 0x00cfe20007810000ULL, 0x00000ef27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0032037f89ULL, 0x000ea800000e0000ULL, 0x0c401f000a097f89ULL, 0x000ee800000e0000ULL,
0x0c401f000b087f89ULL, 0x000f2200000e0000ULL, 0x0000000332037209ULL, 0x004fc40007810000ULL,
0x000000090a0c7209ULL, 0x008fc60007810000ULL, 0x0c201f0003307f89ULL, 0x002fe200000e0000ULL,
0x000000080b2e7209ULL, 0x010fc60007810000ULL, 0x0c201f0034097f89ULL, 0x000e6800000e0000ULL,
0x0c201f000c0d7f89ULL, 0x000ea800000e0000ULL, 0x0c201f002e2f7f89ULL, 0x00072200000e0000ULL,
0x0000000934087209ULL, 0x002fe40007810000ULL, 0x0000003003097209ULL, 0x000fc40007810000ULL,
0x0000000d0c0a7209ULL, 0x004fe40007810000ULL, 0x3fb8aa3b08037820ULL, 0x008fe20000410000ULL,
0x3f80000000057882ULL, 0x000fc60000000000ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe40000010803ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe40000010803ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010803ULL,
0x0000000f000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b11117823ULL, 0x100fe40000010803ULL,
0x3fb8aa3b12127823ULL, 0x100fe40000010803ULL, 0x3fb8aa3b13137823ULL, 0x000fc40000010803ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010803ULL, 0x0000000e000b7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b15157823ULL, 0x100fe40000010803ULL, 0x3fb8aa3b16167823ULL, 0x100fe40000010803ULL,
0x3fb8aa3b17177823ULL, 0x100fe40000010803ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010803ULL,
0x0000001000107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b19197823ULL, 0x000fc40000010803ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe40000010803ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe40000010803ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010803ULL, 0x0000001100117308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b1d037823ULL, 0x000fe20000010803ULL, 0x0000000c0b0c723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b091d7820ULL, 0x000fe20000410000ULL, 0xfffffffc3b0b7812ULL, 0x000fc600078ec0ffULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001081dULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe4000001081dULL, 0x3fb8aa3b20207823ULL, 0x100fe4000001081dULL,
0x3fb8aa3b21217823ULL, 0x100fe4000001081dULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001081dULL,
0x0000001e000d7308ULL, 0x0003e20000000800ULL, 0x00000010110e723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b23237823ULL, 0x000fc4000001081dULL, 0x3fb8aa3b24247823ULL, 0x100fe4000001081dULL,
0x3fb8aa3b25257823ULL, 0x100fe4000001081dULL, 0x0000001f00307308ULL, 0x0004e20000000800ULL,
0x00000005ff1e7e24ULL, 0x002fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001081dULL, 0x0000000000067886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001081dULL, 0x3f8000001e1e783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001081dULL, 0x00000020000f7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b29297823ULL, 0x000fc4000001081dULL, 0x000000ffff1f7224ULL, 0x004fe400078e001eULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe4000001081dULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001081dULL,
0x0000002100327308ULL, 0x000ea20000000800ULL, 0x0000000d300d723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe4000001081dULL, 0x0000000fff207424ULL, 0x002fe400078e00ffULL,
0x3fb8aa3b2d1d7823ULL, 0x000fc4000001081dULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000000b20207219ULL, 0x000fc800000006ffULL, 0x00000000200b73a1ULL, 0x000ee200000e8000ULL,
0x00000000200573c4ULL, 0x000f220000004000ULL, 0x0000000f320f723eULL, 0x004fe200000010ffULL,
0x0000001400147308ULL, 0x000fec0000000800ULL, 0x0000001e0c30723cULL, 0x000fe200000418ffULL,
0x000000121310723eULL, 0x002fe200000010ffULL, 0x0000001500157308ULL, 0x000e700000000800ULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x0000000620ff7c12ULL, 0x008fc4000f80400bULL,
0x0000002e2f0b7209ULL, 0x010fca0007810000ULL, 0x0000002300237308ULL, 0x000ea20000000800ULL,
0x000000141512723eULL, 0x002fce00000010ffULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000002500257308ULL, 0x000e620000000800ULL, 0x000000222311723eULL, 0x004fce00000010ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000242513723eULL, 0x002fce00000010ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x0000001e1030723cULL, 0x000fee0000041830ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000001900197308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000010ffULL, 0x0000002600267308ULL, 0x000ff00000000800ULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x000000181916723eULL, 0x004fce00000010ffULL,
0x0000002800287308ULL, 0x000ff00000000800ULL, 0x0000002900297308ULL, 0x000ea20000000800ULL,
0x000000262715723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x000000282917723eULL, 0x004fce00000010ffULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000001e1430723cULL, 0x000fee0000041830ULL, 0x0000001c001c7308ULL, 0x000ff00000000800ULL,
0x0000000300037308ULL, 0x000ea20000000800ULL, 0x0000001a1b18723eULL, 0x002fce00000010ffULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002b002b7308ULL, 0x000e620000000800ULL,
0x0000001c031a723eULL, 0x004fce00000010ffULL, 0x0000002c002c7308ULL, 0x000ff00000000800ULL,
0x0000001d001d7308ULL, 0x000ea20000000800ULL, 0x0000002a2b19723eULL, 0x002fe400000010ffULL,
0x0000002c1d1b723eULL, 0x004fce00000010ffULL, 0x0000001e1824723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000af205008947ULL, 0x000fde000b800000ULL,
0x001c1fff241c7589ULL, 0x0002a400000e0000ULL, 0x00000000200373a1ULL, 0x000ee200000e8000ULL,
0x00000000200573c4ULL, 0x000f220000004000ULL, 0x0000000000067886ULL, 0x000fe400038e0100ULL,
0x0000000620ff7c12ULL, 0x008fda000f804003ULL, 0x00000b1205008947ULL, 0x010fea000b800000ULL,
0x001c1fff261d7589ULL, 0x00072800000e0000ULL, 0x001c1fff011e7589ULL, 0x00066800000e0000ULL,
0x001c1fff1f1f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff037819ULL, 0x000fe4000001163bULL,
0x0000000c07357812ULL, 0x000fc400078ec0ffULL, 0x0000000703207812ULL, 0x04afe200078ec0ffULL,
0x0000000803257824ULL, 0x040fe200078e00ffULL, 0x00000003ff237212ULL, 0x000fe200078e33ffULL,
0x0000000803217824ULL, 0x000fe200078e00ffULL, 0x000000033bff7812ULL, 0x000fe2000780c0ffULL,
0x0000000803307824ULL, 0x040fe200078e00ffULL, 0x0000000803037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff825227812ULL, 0x100fe400078ee220ULL, 0x0000000121247812ULL, 0x100fe200078ef620ULL,
0x0000000803257824ULL, 0x000fe200078e00ffULL, 0x0000000221267812ULL, 0x100fe200078ef620ULL,
0x00000008034c7824ULL, 0x000fe200078e00ffULL, 0x0000000321287812ULL, 0x000fc400078ef620ULL,
0x00000004212a7812ULL, 0x140fe400078ef620ULL, 0x00000005212c7812ULL, 0x140fe400078ef620ULL,
0x00000006212e7812ULL, 0x000fe200078ef620ULL, 0x0000000803217824ULL, 0x040fe200078e00ffULL,
0xfffffff830307812ULL, 0x000fe400078ee223ULL, 0x00000003ff237212ULL, 0x000fe400078e33ffULL,
0x0000000703207812ULL, 0x000fc400078ec0ffULL, 0x0001100000037811ULL, 0x000fe400078e58ffULL,
0xfffffff825327812ULL, 0x100fe400078ee220ULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee223ULL,
0x0000001022077824ULL, 0x100fe200078e0203ULL, 0x0000000121347812ULL, 0x140fe200078ef620ULL,
0x0000001028227824ULL, 0x100fe200078e0203ULL, 0x0000000221367812ULL, 0x140fe200078ef620ULL,
0x000000102e287824ULL, 0x000fe200078e0203ULL, 0x00000003213e7812ULL, 0x100fe200078ef620ULL,
0x0000000135077824ULL, 0x000fe200078e0207ULL, 0x0000000421407812ULL, 0x140fe200078ef620ULL,
0x00000010342d7824ULL, 0x100fe200078e0203ULL, 0x0000000521487812ULL, 0x140fe200078ef620ULL,
0x00000010362e7824ULL, 0x100fe200078e0203ULL, 0x00000006214a7812ULL, 0x000fe200078ef620ULL,
0x0000001024207824ULL, 0x100fe200078e0203ULL, 0x0000000c07007388ULL, 0x0003e20000000800ULL,
0x0000001026217824ULL, 0x000fc400078e0203ULL, 0x000000102a247824ULL, 0x100fe400078e0203ULL,
0x000000102c267824ULL, 0x100fe400078e0203ULL, 0x00000010302a7824ULL, 0x100fe400078e0203ULL,
0x00000010322c7824ULL, 0x100fe400078e0203ULL, 0x000000103e2f7824ULL, 0x100fe400078e0203ULL,
0x0000001040307824ULL, 0x000fc400078e0203ULL, 0x0000001048317824ULL, 0x100fe400078e0203ULL,
0x000000104a327824ULL, 0x100fe400078e0203ULL, 0x000000104c337824ULL, 0x000fe400078e0203ULL,
0x0000000135037824ULL, 0x040fe400078e0220ULL, 0x0000000135217824ULL, 0x040fe400078e0221ULL,
0x0000000135237824ULL, 0x040fe200078e0222ULL, 0x0000000e03007388ULL, 0x0007e20000000800ULL,
0x0000000135257824ULL, 0x000fc400078e0224ULL, 0x0000000135277824ULL, 0x040fe200078e0226ULL,
0x0000001021007388ULL, 0x0007e20000000800ULL, 0x0000000135297824ULL, 0x040fe400078e0228ULL,
0x00000001352b7824ULL, 0x040fe200078e022aULL, 0x0000001223007388ULL, 0x0007e20000000800ULL,
0x00000001352c7824ULL, 0x040fe400078e022cULL, 0x0000000135207824ULL, 0x040fe200078e022dULL,
0x0000001425007388ULL, 0x0007e20000000800ULL, 0x00000001352e7824ULL, 0x000fc400078e022eULL,
0x00000001350c7824ULL, 0x042fe200078e022fULL, 0x0000001627007388ULL, 0x0007e20000000800ULL,
0x0000000135307824ULL, 0x040fe400078e0230ULL, 0x0000000135227824ULL, 0x040fe200078e0231ULL,
0x0000001829007388ULL, 0x0007e20000000800ULL, 0x0000000135327824ULL, 0x040fe400078e0232ULL,
0x0000000135247824ULL, 0x000fe200078e0233ULL, 0x0000001a2b007388ULL, 0x0007e80000000800ULL,
0x0000000d2c007388ULL, 0x0007e80000000800ULL, 0x0000000f20007388ULL, 0x0007e80000000800ULL,
0x000000112e007388ULL, 0x0007e80000000800ULL, 0x000000130c007388ULL, 0x0007e80000000800ULL,
0x0000001530007388ULL, 0x0007e80000000800ULL, 0x0000001722007388ULL, 0x0007e80000000800ULL,
0x0000001932007388ULL, 0x0007e80000000800ULL, 0x0000001b24007388ULL, 0x0007e80000000800ULL,
0x01b0000806008388ULL, 0x0007e80000000c00ULL, 0x01b2001c06008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000044900720cULL, 0x000fe20003f26070ULL,
0x01b6080042ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff46ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff037224ULL, 0x008fc400078e0049ULL, 0x000000ffff457224ULL, 0x000fe200078e004bULL,
0x00000001ff467807ULL, 0x000fce0000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffad4000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e0054ULL, 0x00016bb0002c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fe400078e00ffULL,
0x000007a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2f7224ULL, 0x004fe200078e0030ULL,
0xffff7b1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e0056ULL,
0x00016c20002c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fe400078e00ffULL, 0x0000073000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x004fe200078e0030ULL, 0xffff7ac000007947ULL, 0x000fea000383ffffULL,
0x000000ffff037224ULL, 0x000fe200078e0008ULL, 0x00016ca0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff307424ULL, 0x000fc400078e00ffULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000067000007944ULL, 0x022fea0003c00000ULL,
0xfffff0f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff037224ULL, 0x000fe200078e0032ULL,
0x00016d10000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff307424ULL, 0x002fe400078e00ffULL,
0x0000001fff2f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000060000007944ULL, 0x020fea0003c00000ULL, 0x0000000332327209ULL, 0x004fe20007810000ULL,
0x000000ffff037224ULL, 0x000fe200078e000aULL, 0x00016d80000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff307424ULL, 0x002fc400078e00ffULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000059000007944ULL, 0x000fea0003c00000ULL,
0x000000030a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff037224ULL, 0x000fe200078e000bULL,
0x00016df0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff307424ULL, 0x002fe400078e00ffULL,
0x0000001fff2f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000052000007944ULL, 0x000fea0003c00000ULL, 0x000000030b2e7209ULL, 0x004fe20007810000ULL,
0x000000ffff037224ULL, 0x000fe200078e0034ULL, 0x00016e60000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff307424ULL, 0x002fc400078e00ffULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x000004b000007944ULL, 0x000fea0003c00000ULL,
0x0000000334087209ULL, 0x004fe20007810000ULL, 0x000000ffff037224ULL, 0x000fe200078e0032ULL,
0x00016ed0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff307424ULL, 0x002fe400078e00ffULL,
0x0000001fff2f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000044000007944ULL, 0x000fea0003c00000ULL, 0x0000000332097209ULL, 0x004fe20007810000ULL,
0x000000ffff037224ULL, 0x000fe200078e000aULL, 0x00016f40000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff307424ULL, 0x002fc400078e00ffULL, 0x0000001fff2f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x000000030a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff037224ULL, 0x000fe200078e002eULL,
0x00016fb0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff307424ULL, 0x002fe400078e00ffULL,
0x0000001fff2f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2f7224ULL, 0x006fe200078e0003ULL,
0xffffeec000007947ULL, 0x000fea000383ffffULL, 0x000000ffff317224ULL, 0x000fe200078e0024ULL,
0x00017030002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fc400078e00ffULL,
0x00001c1fff337424ULL, 0x000fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fe400078e0020ULL,
0x0000032000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e0030ULL,
0xfffff4a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff317224ULL, 0x002fe200078e0026ULL,
0x000170b0002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fe400078e00ffULL,
0x00001c1fff337424ULL, 0x000fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fe400078e0020ULL,
0x000002a000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff327224ULL, 0x002fe200078e00ffULL,
0x00017110002c7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff337424ULL, 0x000fc400078e00ffULL,
0x000000ffff347224ULL, 0x000fe400078e0020ULL, 0x000000ffff1d7224ULL, 0x004fe400078e0030ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff347224ULL, 0x002fe200078e0020ULL,
0x00017170002c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fe400078e00ffULL,
0x00001c1fff337424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x004fe400078e0030ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x004fe200078e0030ULL,
0xfffff3e000007947ULL, 0x000fea000383ffffULL, 0x0180000006037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000000600038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff0a7807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x000000030aff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000006067812ULL, 0x002fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x000000030aff7212ULL, 0x000fda000780c0ffULL, 0x0080000006030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0006ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000600037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x006fe400078e0009ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffe8cf006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0c00003003037389ULL, 0x0002a200000e002fULL,
0xfffe8cb00c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2d7424ULL, 0x000fe200078e00ffULL,
0x0000003400007348ULL, 0x000fe80003800000ULL, 0x0000003231307389ULL, 0x0002a200000e0033ULL,
0xfffe8c702c007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001b680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x0000000000000218ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000007b0ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000828ULL, 0x0000000000000500ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d28ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d48ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000d58ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000d78ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000de8ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000df0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000e00ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001000ULL, 0x0000000000017480ULL, 0xff00001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018480ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000018490ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018490ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000018910ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000de8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000017698ULL, 0x0000000000017698ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000018480ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000018910ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_80_cubin_len = 100848;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
