/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000018cb8ULL, 0x0000000000018938ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x346a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4532336a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL,
0x2400000000000000ULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000017cULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b00010000020cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b000100000253ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b000100000299ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b000100000383ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000b0001000003d1ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00220000042cULL, 0x00000000000172f0ULL,
0x0000000000000210ULL, 0x00040003000004a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000017500ULL, 0x000d0003000004d2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000172f000000000ULL,
0x0001380400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x000172f000000000ULL, 0x0000021000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000b8ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0xffffffff00dc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000020000dc2804ULL, 0x000009f000000360ULL, 0x00002fa000002f30ULL, 0x000031b000003080ULL,
0x00003420000032e0ULL, 0x000039b0000039a0ULL, 0x000039d0000039c0ULL, 0x0000580000005770ULL,
0x00005a10000058e0ULL, 0x00005c8000005b40ULL, 0x0000612000006110ULL, 0x0000614000006130ULL,
0x00007ee000007e50ULL, 0x000080f000007fc0ULL, 0x0000836000008220ULL, 0x000087a000008790ULL,
0x000087c0000087b0ULL, 0x0000a5300000a4c0ULL, 0x0000a7500000a620ULL, 0x0000a9c00000a880ULL,
0x0000aec00000aeb0ULL, 0x0000aee00000aed0ULL, 0x0000c1700000c160ULL, 0x0000c1900000c180ULL,
0x00015b2000015a70ULL, 0x00015f0000015df0ULL, 0x000163d0000162c0ULL, 0x0001676000016670ULL,
0x0000053004303904ULL, 0x0001a600000000ffULL, 0x0000061000040100ULL, 0x0001a60800000008ULL,
0x00000720003f0100ULL, 0x0001a68800000008ULL, 0x00000860003f0100ULL, 0x0001a6a800000002ULL,
0x00000960003f0100ULL, 0x0001a6c800000004ULL, 0x000013d0003f0100ULL, 0x0001a60000000008ULL,
0x00001560003f0107ULL, 0x0001a68800000003ULL, 0x00001f30003f0101ULL, 0x00000000000000ffULL,
0x00001fb000040107ULL, 0x00000000000000ffULL, 0x0000203000040101ULL, 0x0000002000000002ULL,
0x00002140003f0101ULL, 0x0001a6c800000038ULL, 0x000022c0003f0109ULL, 0x0001a6c800000038ULL,
0x00002c50003f0109ULL, 0x0001a6b00000003aULL, 0x00002ca0003f0107ULL, 0x0001a6b00000003aULL,
0x00002cb0003f0101ULL, 0x0001a60800000080ULL, 0x00002cd0003f0101ULL, 0x0001a60800000080ULL,
0x00002e40003f0109ULL, 0x0001a60800000080ULL, 0x000035b0003f0109ULL, 0x0001a6a80000003aULL,
0x00003740003f0109ULL, 0x0001a6a80000003aULL, 0x00004b50003f0109ULL, 0x0001a6c800000034ULL,
0x00004b60003f0101ULL, 0x0001a6880000007dULL, 0x00004b90003f0101ULL, 0x0000000000000006ULL,
0x00004d00003f0109ULL, 0x0000000000000006ULL, 0x000054f0003f0109ULL, 0x00000000000000ffULL,
0x0000553000050107ULL, 0x00000000000000ffULL, 0x0000554000050101ULL, 0x0001a62800000080ULL,
0x00005560003f0101ULL, 0x0001a62800000080ULL, 0x000056d0003f0109ULL, 0x0001a62800000080ULL,
0x00005e60003f0109ULL, 0x0001a6b000000037ULL, 0x00005fd0003f0109ULL, 0x0001a6b000000037ULL,
0x000071b0003f0109ULL, 0x0001a6c800000034ULL, 0x000071c0003f0101ULL, 0x0001a69000000036ULL,
0x000071f0003f0101ULL, 0x0000000000000006ULL, 0x00007360003f0109ULL, 0x0000000000000006ULL,
0x00007b50003f0109ULL, 0x00000008000000ffULL, 0x00007c1000040107ULL, 0x0000000800000086ULL,
0x00007c20003f0101ULL, 0x0001a64800000080ULL, 0x00007c40003f0101ULL, 0x0001a64800000080ULL,
0x00007db0003f0109ULL, 0x0001a64800000080ULL, 0x00008510003f0109ULL, 0x00000000000000ffULL,
0x0000868000050109ULL, 0x00000000000000ffULL, 0x0000982000050109ULL, 0x0000000000000006ULL,
0x00009830003f0101ULL, 0x0001a69800000036ULL, 0x00009850003f0101ULL, 0x0000000000000006ULL,
0x000099c0003f0109ULL, 0x0000000000000006ULL, 0x0000a1f0003f0109ULL, 0x00000000000000ffULL,
0x0000a28000040107ULL, 0x00000000000000ffULL, 0x0000a29000050101ULL, 0x0001a66800000037ULL,
0x0000a2b0003f0101ULL, 0x0001a66800000037ULL, 0x0000a420003f0109ULL, 0x0001a66800000037ULL,
0x0000ab90003f0109ULL, 0x0001a6b000000037ULL, 0x0000ad00003f0109ULL, 0x0001a6b000000037ULL,
0x0000bf50003f0109ULL, 0x0000000000000006ULL, 0x0000bf90003f0101ULL, 0x0001a6a000000006ULL,
0x0000e1c0003f0101ULL, 0x0001a60000000008ULL, 0x0000fb50003f0101ULL, 0x0001a60000000008ULL,
0x0000fd10003f0109ULL, 0x0001a60000000008ULL, 0x00010060003f0109ULL, 0x0001a60000000008ULL,
0x00010080003f0101ULL, 0x0001a60000000008ULL, 0x000101f0003f0109ULL, 0x0001a60000000008ULL,
0x000130c0003f0109ULL, 0x0001a68800000002ULL, 0x00013490003f0101ULL, 0x0001a68800000002ULL,
0x00013600003f0109ULL, 0x0001a68800000002ULL, 0x00017290003f0109ULL, 0x0001a60800000078ULL,
0x000172a0003f0101ULL, 0x0001a61000000078ULL, 0x000172b0003f0101ULL, 0x0001a61800000078ULL,
0x000172c0003f0101ULL, 0x0001a62000000078ULL, 0x00053803003f0101ULL, 0x0000d0b000301c04ULL,
0x0000d3a00000d0e0ULL, 0x0000d7800000d590ULL, 0x0000db600000d970ULL, 0x0000df500000dd50ULL,
0x000102200000e100ULL, 0x000c0504000172e0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0068190300000000ULL, 0x0000001600080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL,
0x0000001500000002ULL, 0x00000000000172f0ULL, 0x0000000000000044ULL, 0x0000001500000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001500000002ULL, 0x0000000000000000ULL,
0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x00000000007a7919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff007b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff022b82ULL, 0x000ea20000000a00ULL,
0x000000017a052836ULL, 0x008fe40000000000ULL, 0x000000047a062825ULL, 0x004fc800078e0002ULL,
0x0000000405022825ULL, 0x000fe400078e0002ULL, 0x0000000606062981ULL, 0x000ea8000c1e1900ULL,
0x0000000602092981ULL, 0x0006a2000c1e1900ULL, 0x0000000000087306ULL, 0x010f220000209000ULL,
0x00000400ff0a7b82ULL, 0x000f620000000800ULL, 0x000000ff0000720cULL, 0x000fe20003f65070ULL,
0x0000000000767919ULL, 0x000ee20000002600ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x00000000000e7919ULL, 0x000ee40000002300ULL,
0x0000000800087308ULL, 0x010f240000001000ULL, 0x0ffffffe08047836ULL, 0x010fc40000000000ULL,
0x0000000000087919ULL, 0x000f280000002100ULL, 0x0000000400057305ULL, 0x000764000021f000ULL,
0x000000ffff047224ULL, 0x00afe400078e00ffULL, 0x000000ffff0b7224ULL, 0x020fc800078e0a05ULL,
0x000000000b0b7224ULL, 0x000fc800078e02ffULL, 0x0000000b05057227ULL, 0x000fe400078e0004ULL,
0x00000000000b7919ULL, 0x000e680000002200ULL, 0x0000000a05057227ULL, 0x000fe200078e00ffULL,
0x00000005ff777819ULL, 0x010fc60000011608ULL, 0x000000ffff037224ULL, 0x000fc600078e0a05ULL,
0x00001fff77777589ULL, 0x000f2200000e0000ULL, 0x0000000300037224ULL, 0x000fca00078e020aULL,
0x000000000300720cULL, 0x000fda0003f06070ULL, 0x0000000103030824ULL, 0x000fe400078e0a00ULL,
0x0000000105050836ULL, 0x000fc60000000000ULL, 0x000000000300720cULL, 0x000fda0003f26070ULL,
0x0000000105051836ULL, 0x000fe20000000000ULL, 0x00000000ff05b212ULL, 0x000fc800078e33ffULL,
0x0000000500047306ULL, 0x000ee20000209000ULL, 0x000000ff0500720cULL, 0x000fce0003f65070ULL,
0x0000000400047308ULL, 0x008ee40000001000ULL, 0x0ffffffe04027836ULL, 0x008fcc0000000000ULL,
0x0000000200037305ULL, 0x000764000021f000ULL, 0x000000ffff027224ULL, 0x008fe400078e00ffULL,
0x0000000305077224ULL, 0x020fc800078e02ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a07ULL,
0x0000000703037227ULL, 0x000fe400078e0002ULL, 0x00008400ff07ab82ULL, 0x000f280000000800ULL,
0x0000007603797227ULL, 0x000fc800078e00ffULL, 0x000000040e037c24ULL, 0x002fe2000f8e020bULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff027224ULL, 0x000fe200078e0a79ULL,
0x00001fff0e0e7589ULL, 0x000f2200000e0000ULL, 0x0000000403047c24ULL, 0x000fe4000f8e0208ULL,
0x0000000205027224ULL, 0x000fc600078e0276ULL, 0x0000007f0400780cULL, 0x000fe40003fa4070ULL,
0x000000050200720cULL, 0x000fe40003f06070ULL, 0x000000030400780cULL, 0x000fd20003f84070ULL,
0x00000000000ad919ULL, 0x000e640000008800ULL, 0x0000000102020824ULL, 0x000fe400078e0a05ULL,
0x0000000179790836ULL, 0x000fe20000000000ULL, 0x000000ff0400720cULL, 0x000fe40003f05270ULL,
0x000000050200720cULL, 0x000fda0003f26070ULL, 0x0000000179791836ULL, 0x000fe20000000000ULL,
0x00000005ff79b212ULL, 0x000fe400078e33ffULL, 0x0000000f0400780cULL, 0x040fe40003f24070ULL,
0x000000010400780cULL, 0x000fe20003f64070ULL, 0x000000ffff027224ULL, 0x000fc800078e0a79ULL,
0x0000000205767224ULL, 0x000fe400078e0276ULL, 0xff317217ff05d424ULL, 0x000fe400078e00ffULL,
0x0000000109032824ULL, 0x004fe200078e0a06ULL, 0x000004000009d802ULL, 0x000fc80000000f00ULL,
0x000006540a09d816ULL, 0x002fe20000000009ULL, 0x00008400ff03ab82ULL, 0x000ee80000000800ULL,
0x000000040402d824ULL, 0x000fe200078e0209ULL, 0x0000000000240947ULL, 0x010fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01a60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404087c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a60804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404087c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a68804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01a400050200d388ULL, 0x0003e20000000800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000002076767824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000404027c11ULL, 0x002fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6a804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000040912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6c804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000803057c24ULL, 0x00afe2000f8e02ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff027224ULL, 0x000fe200078e0a76ULL, 0x000000760500720cULL, 0x000fe20003f06070ULL,
0x000000077a06a224ULL, 0x000fc400078e02ffULL, 0x0000000800157c24ULL, 0x000fe2000f8e02ffULL,
0x00000020050b7446ULL, 0x000fe20003800002ULL, 0x000000040e027824ULL, 0x000fe400078e0277ULL,
0x00000015060a7224ULL, 0x000fe200078e02ffULL, 0x000000ff0b0b7207ULL, 0x000fe20000000000ULL,
0x0000000402027824ULL, 0x000fe400078e00ffULL, 0x0000000879197c24ULL, 0x000fe2000f8e020aULL,
0x000000200b00780cULL, 0x000fda0003f05270ULL, 0x00000004002c8947ULL, 0x000fea0003800000ULL,
0x0000000800087d06ULL, 0x000e620008209000ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00008c0000047ab9ULL, 0x000fca0000000a00ULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08057836ULL, 0x002fe20000000000ULL,
0x00000004ff077819ULL, 0x004fca0000011609ULL, 0x0000000500057305ULL, 0x000e62000021f000ULL,
0x0000000207107836ULL, 0x000fe40000000000ULL, 0x00000001020f7824ULL, 0x040fe400078e0207ULL,
0x0000000102117824ULL, 0x000fc800078e0210ULL, 0x0000000176127824ULL, 0x000fe400078e0211ULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a05ULL, 0x000000080d0d7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000d050d7227ULL, 0x000fc800078e0004ULL, 0x0000000176047824ULL, 0x000fc800078e020fULL,
0x000000040d057227ULL, 0x000fc800078e00ffULL, 0x000000120d0d7227ULL, 0x000fc800078e00ffULL,
0x000000ffff137224ULL, 0x000fe400078e0a05ULL, 0x000000ffff177224ULL, 0x000fe400078e0a0dULL,
0x0000000813087c24ULL, 0x000fe4000f8e0204ULL, 0x00000008170c7c24ULL, 0x000fe4000f8e0212ULL,
0x0000000000177919ULL, 0x000e620000008800ULL, 0x0000000808007c0cULL, 0x000fe4000bf06070ULL,
0x000000080c007c0cULL, 0x000fd6000bf46070ULL, 0x8000000808080c36ULL, 0x000fe40008000000ULL,
0x800000080c0c2c36ULL, 0x000fe40008000000ULL, 0x0000000105050836ULL, 0x000fe20000000000ULL,
0x0000000808007c0cULL, 0x000fe2000bf26070ULL, 0x000000010d0d2836ULL, 0x000fe20000000000ULL,
0x000000080c007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff087c12ULL, 0x000fce000f8e33ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x000000010d0d3836ULL, 0x000fe40000000000ULL, 0x00000005080c7207ULL, 0x000fc60004000000ULL,
0x0000000d08137207ULL, 0x000fe40004000000ULL, 0x000000ffff057224ULL, 0x000fe200078e0a0cULL,
0x0000040000087802ULL, 0x000fe40000000f00ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a13ULL,
0x0000000805047c24ULL, 0x000fe2000f8e0204ULL, 0x000000020b057248ULL, 0x000fe20007fe0000ULL,
0x000000080d127c24ULL, 0x000fe2000f8e0212ULL, 0x0000065417087816ULL, 0x002fe20000000008ULL,
0x00000001190d7824ULL, 0x000fc400078e0204ULL, 0x0000000119127824ULL, 0x000fe400078e0212ULL,
0x0000000105057824ULL, 0x000fe400078e0a02ULL, 0x000000150c047224ULL, 0x000fe400078e020dULL,
0x0000001009027824ULL, 0x000fe200078e00ffULL, 0x000000050700720cULL, 0x000fe20003f06070ULL,
0x00000015130c7224ULL, 0x000fe200078e0212ULL, 0x000000051000720cULL, 0x000fe20003f26070ULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x000000f002077812ULL, 0x000fc600078ec0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000704047212ULL, 0x000fc600078efcffULL,
0x000000010f107824ULL, 0x140fe200078e0209ULL, 0x000000070c0c7212ULL, 0x000fe200078efcffULL,
0x000000100f137824ULL, 0x000fe200078e00ffULL, 0x0000000404047c10ULL, 0x000fe2000ff5e0ffULL,
0x00000001110f7824ULL, 0x040fe200078e0209ULL, 0x000000040c0c7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001011127824ULL, 0x000fe200078e00ffULL, 0xfffffff013077812ULL, 0x000fe400078ee210ULL,
0x0000000505057c10ULL, 0x000fe400097fe4ffULL, 0xfffffff0120f7812ULL, 0x000fe200078ee20fULL,
0x0000001007077824ULL, 0x000fe200078e0208ULL, 0x000000050d0d7c10ULL, 0x000fc60009ffe4ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e8000c101c46ULL, 0x000000000c0f7faeULL, 0x0003e2000c901c46ULL,
0x0000000400107947ULL, 0x000fea0003800000ULL, 0x0000000800087d06ULL, 0x000e620008209000ULL,
0x0000000000097919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000000000f7919ULL, 0x000ee80000008800ULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08057836ULL, 0x002fe20000000000ULL,
0x0000000209077211ULL, 0x004fca00078fe0ffULL, 0x0000000500057305ULL, 0x000e62000021f000ULL,
0x0000000207107836ULL, 0x000fe40000000000ULL, 0x0000000176027824ULL, 0x040fe400078e0207ULL,
0x0000000176087824ULL, 0x000fe400078e0210ULL, 0x0000001007127824ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a05ULL, 0x000000080d0d7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000d050d7227ULL, 0x000fcc00078e0004ULL, 0x000000020d047227ULL, 0x000fc800078e00ffULL,
0x000000080d0c7227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a0cULL, 0x0000000805057c24ULL, 0x000fe4000f8e0202ULL,
0x000000080d0d7c24ULL, 0x000fc6000f8e0208ULL, 0x0000000805007c0cULL, 0x000fe4000bf06070ULL,
0x000000080d007c0cULL, 0x000fd6000bf46070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x800000080d0d2c36ULL, 0x000fe40008000000ULL, 0x0000000104040836ULL, 0x000fe20000000000ULL,
0x0000000805007c0cULL, 0x000fe2000bf26070ULL, 0x000000010c0c2836ULL, 0x000fe20000000000ULL,
0x000000080d007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff057c12ULL, 0x000fce000f8e33ffULL, 0x0000000104041836ULL, 0x000fe40000000000ULL,
0x000000010c0c3836ULL, 0x000fc60000000000ULL, 0x0000000405047207ULL, 0x040fe40004000000ULL,
0x0000000c050c7207ULL, 0x000fc60004000000ULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a0cULL, 0x0000000805027c24ULL, 0x000fe4000f8e0202ULL,
0x000000080d087c24ULL, 0x000fe4000f8e0208ULL, 0x0000000119057824ULL, 0x040fe400078e0202ULL,
0x00000001190d7824ULL, 0x000fe200078e0208ULL, 0x0000040000087802ULL, 0x000fe20000000f00ULL,
0x0000001009027824ULL, 0x000fc400078e00ffULL, 0x0000001504057224ULL, 0x080fe200078e0205ULL,
0x000006540f087816ULL, 0x008fe20000000008ULL, 0x000000150c0d7224ULL, 0x000fe200078e020dULL,
0x000000f002117812ULL, 0x000fe200078ec0ffULL, 0x0000010005047825ULL, 0x000fc800078e00ffULL,
0x000001000d0c7825ULL, 0x000fe200078e00ffULL, 0x0000001104047212ULL, 0x000fc600078efcffULL,
0x00000001070f7824ULL, 0x100fe200078e0209ULL, 0x000000110c0c7212ULL, 0x000fe200078efcffULL,
0x0000000110077824ULL, 0x040fe200078e0209ULL, 0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001010107824ULL, 0x000fe200078e00ffULL, 0xfffffff0120f7812ULL, 0x000fe400078ee20fULL,
0x000000040c0c7c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff010077812ULL, 0x000fe400078ee207ULL,
0x0000000505057c10ULL, 0x000fc400087fe4ffULL, 0x000000080f0f7211ULL, 0x000fe200078e20ffULL,
0x0000001007077824ULL, 0x000fe200078e0208ULL, 0x000000050d0d7c10ULL, 0x000fc60008ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e8000b901c46ULL,
0x000000000c077faeULL, 0x0003e4000b901c46ULL, 0x00000000080472caULL, 0x000fe200000e0000ULL,
0x00009400ff047b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0001a60004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x000000047a047825ULL, 0x002fe200078e0004ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000604747981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0e00720cULL, 0x000fe20003f05270ULL, 0x0000007f74757836ULL, 0x004fe40000000000ULL,
0x000000ff74077836ULL, 0x000fc60000000000ULL, 0x00000007ff757819ULL, 0x000fe40000011675ULL,
0x00000008ff627819ULL, 0x000fca0000011607ULL, 0x000000cc001c8947ULL, 0x000fea0003800000ULL,
0x00000003ff607819ULL, 0x000fe20000011677ULL, 0xffffffffff817424ULL, 0x000fc600078e00ffULL,
0x01ffffff60607812ULL, 0x000fc800078ec0ffULL, 0x000000756000720cULL, 0x000fda0003f06070ULL,
0x00009600ff068b82ULL, 0x000e620000000800ULL, 0x000000027a038824ULL, 0x000fce00078e00ffULL,
0x00009200ff048b82ULL, 0x000ea20000000a00ULL, 0x0000000603038224ULL, 0x002fe400078e0206ULL,
0x00000004ff067424ULL, 0x000fe400078e00ffULL, 0x00000001600d8824ULL, 0x000fe400078e0203ULL,
0x0000000877037824ULL, 0x000fe400078e0208ULL, 0x000000040d048825ULL, 0x004fe400078e0004ULL,
0x01a6880603ff79a7ULL, 0x0003e6000850003fULL, 0x0000000604818981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0700780cULL, 0x000fe20003f04070ULL, 0x00000080795a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff637819ULL, 0x000fc40000011677ULL, 0x0000000177067812ULL, 0x002fc600078ec0ffULL,
0x0000002063617824ULL, 0x000fe400078e00ffULL, 0x0000000081037224ULL, 0x004fc600078e02ffULL,
0x000000605a007812ULL, 0x000fe200078ef861ULL, 0x00000080030f7824ULL, 0x000fe200078e00ffULL,
0x0000000400080947ULL, 0x000fec0003800000ULL, 0x0000006174047248ULL, 0x000fe20007fe0000ULL,
0x0000001006037824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fe20000011609ULL,
0x00009000ff187b82ULL, 0x000e640000000a00ULL, 0x0000000104047824ULL, 0x000fe400078e0a61ULL,
0x0000000103067824ULL, 0x000fe400078e0205ULL, 0x00000004050c7836ULL, 0x000fe20000000000ULL,
0x0000000304047248ULL, 0x000fe20007fe0000ULL, 0x0000000106077824ULL, 0x000fc400078e0209ULL,
0x0000000806107824ULL, 0x000fe400078e00ffULL, 0x0000000104047824ULL, 0x000fe400078e0a03ULL,
0x0000000c050d7836ULL, 0x000fe20000000000ULL, 0xfffffff810107812ULL, 0x000fe200078ee207ULL,
0x0000000805077836ULL, 0x000fe20000000000ULL, 0x000000040c00720cULL, 0x080fe20003f46070ULL,
0x00000001030c7824ULL, 0x000fe200078e020cULL, 0x000000040500720cULL, 0x080fe40003f66070ULL,
0x000000040700720cULL, 0x080fe20003f26070ULL, 0x0000000103077824ULL, 0x000fe200078e0207ULL,
0x000000040d00720cULL, 0x000fe20003f06070ULL, 0x000000010c057824ULL, 0x040fe200078e0209ULL,
0x000000180f137211ULL, 0x002fe200078838ffULL, 0x000000080c127824ULL, 0x000fc400078e00ffULL,
0x0000000103037824ULL, 0x000fe200078e020dULL, 0x000000190f197211ULL, 0x000fe200020f3cffULL,
0x0000000100047824ULL, 0x040fe200078e0206ULL, 0xfffffff812127812ULL, 0x000fe200078ee205ULL,
0x0000000100067824ULL, 0x040fe400078e020cULL, 0x00000001000c7824ULL, 0x040fe400078e0207ULL,
0x00000001000e7824ULL, 0x000fe400078e0203ULL, 0x0000000107007824ULL, 0x000fc400078e0209ULL,
0x00000008070d7824ULL, 0x000fe400078e00ffULL, 0x0000008004047825ULL, 0x000fc600078e00ffULL,
0xfffffff80d147812ULL, 0x000fe200078ee200ULL, 0x0000000103077824ULL, 0x040fe200078e0209ULL,
0x0000007004047812ULL, 0x000fe200078ef802ULL, 0x0000000803167824ULL, 0x000fe400078e00ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000413047210ULL, 0x000fe40007f9e0ffULL,
0xfffffff816167812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000007006117812ULL, 0x000fe400078ef802ULL,
0x000000700c067812ULL, 0x000fe200078ef802ULL, 0x0000200063007824ULL, 0x000fe200078e0208ULL,
0x000000700e0c7812ULL, 0x000fe200078ef802ULL, 0x0000000105057824ULL, 0x000fe200020e0619ULL,
0x0000001311027210ULL, 0x000fe20007f9e0ffULL, 0x0001600000037836ULL, 0x000fe20000000000ULL,
0x0000001306067210ULL, 0x000fe40007fbe0ffULL, 0x000000130c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001012137824ULL, 0x100fe200078e0203ULL, 0x0000000310117211ULL, 0x000fe200078e20ffULL,
0x0000001014157824ULL, 0x000fc400078e0203ULL, 0x0000001016177824ULL, 0x000fe400078e0203ULL,
0x0000000107037824ULL, 0x100fe200020e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004117faeULL, 0x0003e2000d901c46ULL, 0x000000010d077824ULL, 0x100fe400028e0619ULL,
0x000000010f0d7824ULL, 0x000fe200030e0619ULL, 0x0000000002137faeULL, 0x0003e8000d101c46ULL,
0x0000000006157faeULL, 0x0003e8000c901c46ULL, 0x000000000c177faeULL, 0x0003e2000c101c46ULL,
0x0000000000d47947ULL, 0x000fea0003800000ULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x00009000ff127b82ULL, 0x000e680000000a00ULL, 0x0000000609037211ULL, 0x000fca00078fe8ffULL,
0x0000000103047824ULL, 0x140fe400078e0209ULL, 0x0000000803077824ULL, 0x000fe400078e00ffULL,
0x0000000403057836ULL, 0x000fe40000000000ULL, 0x0000000c030d7836ULL, 0x000fe20000000000ULL,
0xfffffff807107812ULL, 0x000fe200078ee204ULL, 0x0000000105067824ULL, 0x040fe400078e0209ULL,
0x0000000805117824ULL, 0x000fc400078e00ffULL, 0x0000000803077836ULL, 0x000fe40000000000ULL,
0x0000000100047824ULL, 0x040fe200078e0203ULL, 0xfffffff811037812ULL, 0x000fe200078ee206ULL,
0x0000000100067824ULL, 0x040fe200078e0205ULL, 0x000000120f157211ULL, 0x042fe200078038ffULL,
0x00000001000c7824ULL, 0x040fe400078e0207ULL, 0x00000001000e7824ULL, 0x000fe200078e020dULL,
0x000000130f197211ULL, 0x000fe200000f3cffULL, 0x0000000107007824ULL, 0x000fc400078e0209ULL,
0x0000000807117824ULL, 0x000fe400078e00ffULL, 0x0000008004047825ULL, 0x000fc600078e00ffULL,
0xfffffff811007812ULL, 0x000fe200078ee200ULL, 0x000000010d077824ULL, 0x040fe200078e0209ULL,
0x0000007004047812ULL, 0x000fe200078ef802ULL, 0x000000080d147824ULL, 0x000fe400078e00ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000415047210ULL, 0x000fe40007f1e0ffULL,
0xfffffff814127812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000007006117812ULL, 0x000fe400078ef802ULL,
0x000000700c067812ULL, 0x000fe200078ef802ULL, 0x0000200063137824ULL, 0x000fe200078e0208ULL,
0x000000700e0c7812ULL, 0x000fe200078ef802ULL, 0x0000000105057824ULL, 0x000fe200000e0619ULL,
0x0000001115027210ULL, 0x000fe20007f1e0ffULL, 0x0001600013177836ULL, 0x000fe20000000000ULL,
0x0000000615067210ULL, 0x000fe40007f3e0ffULL, 0x0000000c150c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001010117824ULL, 0x000fc400078e0217ULL, 0x0000001003137824ULL, 0x000fe400078e0217ULL,
0x0000000107037824ULL, 0x000fe200000e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004117faeULL, 0x0003e2000b901c46ULL, 0x0000001000157824ULL, 0x000fe400078e0217ULL,
0x000000010d077824ULL, 0x000fe200008e0619ULL, 0x0000000002137faeULL, 0x0003e2000b901c46ULL,
0x0000001012177824ULL, 0x000fe400078e0217ULL, 0x000000010f0d7824ULL, 0x000fe200010e0619ULL,
0x0000000006157faeULL, 0x0003e8000b901c46ULL, 0x000000000c177faeULL, 0x0003e4000b901c46ULL,
0x0001a6a808007836ULL, 0x000fe20000000000ULL, 0x00000000630472caULL, 0x000fe200000e0000ULL,
0x00000001ff037424ULL, 0x002fe200078e00ffULL, 0x000000ff6200720cULL, 0x000fe20003f05270ULL,
0x000000ffff847224ULL, 0x000fe200078e00ffULL, 0x00000000000572caULL, 0x000fe400000e0000ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000000e7805ULL, 0x000fc4000001ff00ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000527805ULL, 0x000fc4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x0000000063027211ULL, 0x000fe200078e18ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000003ff7e79a7ULL, 0x0002a20008500004ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x0000000000467805ULL, 0x000fe4000001ff00ULL,
0x0000000000447805ULL, 0x000fc4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00002003020279a7ULL, 0x002e62000850003fULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000009c00d48947ULL, 0x000fec0003800000ULL, 0x00009600ff007b82ULL, 0x000ee20000000800ULL,
0x000000027a077824ULL, 0x000fe200078e00ffULL, 0x00000002ff5b7819ULL, 0x000fe20000011677ULL,
0x000000ffff397224ULL, 0x002fe200078e0003ULL, 0x0000000163597812ULL, 0x000fe200078ec0ffULL,
0xff317217ff7a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff587224ULL, 0x000fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fe400078e00ffULL, 0x0000000007077224ULL, 0x008fce00078e0200ULL,
0x0000000000347805ULL, 0x016fce0000015200ULL, 0x0000000477067824ULL, 0x000fca00078e00ffULL,
0xfffffff806377812ULL, 0x000fca00078ec0ffULL, 0x0000000108387824ULL, 0x000fc800078e0237ULL,
0x01a6c839380075a7ULL, 0x000e62000800017fULL, 0x0001a6c838067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01a6c839380075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000001077347824ULL, 0x000fe200078e00ffULL, 0x0000850000057ab9ULL, 0x000fe20000000800ULL,
0x0000000158377836ULL, 0x000fe40000000000ULL, 0x0000000581817c24ULL, 0x000fe2000f8e02ffULL,
0xffffffe034357812ULL, 0x000fe400078ec0ffULL, 0x000000623700720cULL, 0x000fe20003f26070ULL,
0x0000008081817824ULL, 0x000fe400078e00ffULL, 0x0000010058357824ULL, 0x000fc800078e0235ULL,
0x0000004035397836ULL, 0x000fca0000000000ULL, 0x0000006039357812ULL, 0x000fca00078ec0ffULL,
0x000000015a4d7824ULL, 0x000fe200078e0235ULL, 0x0000000400109947ULL, 0x000fec0003800000ULL,
0x0000001034377812ULL, 0x000fe400078ec0ffULL, 0x0000003974347248ULL, 0x000fe40007fe0000ULL,
0x00000003ff3a7819ULL, 0x000fc60000011609ULL, 0x0000000134347824ULL, 0x000fe400078e0a39ULL,
0x000000013a387824ULL, 0x000fe400078e0237ULL, 0x000000083a4c7836ULL, 0x000fe20000000000ULL,
0x0000003734367248ULL, 0x000fe20007fe0000ULL, 0x0000000138397824ULL, 0x040fe200078e0209ULL,
0x00009000ff347b82ULL, 0x000e620000000a00ULL, 0x00000008384e7824ULL, 0x000fe400078e00ffULL,
0x0000000136367824ULL, 0x000fc400078e0a37ULL, 0x0000000c3a3b7836ULL, 0x000fe20000000000ULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee239ULL, 0x000000043a397836ULL, 0x000fe20000000000ULL,
0x000000363a00720cULL, 0x080fe20003f86070ULL, 0x000000013b647824ULL, 0x100fe200078e0237ULL,
0x000000364c00720cULL, 0x080fe20003f46070ULL, 0x00000001393a7824ULL, 0x040fe200078e0237ULL,
0x000000363900720cULL, 0x080fe20003f66070ULL, 0x0000001009397824ULL, 0x000fe200078e00ffULL,
0x000000363b00720cULL, 0x000fe20003f06070ULL, 0x000000013a367824ULL, 0x000fc400078e0209ULL,
0x000000083a3b7824ULL, 0x000fe200078e00ffULL, 0x00000070395d7812ULL, 0x000fe200078ec0ffULL,
0x000000014c4c7824ULL, 0x000fe400078e0237ULL, 0x000000014d387824ULL, 0x000fe200078e0238ULL,
0xfffffff83b5c7812ULL, 0x000fe200078ee236ULL, 0x000000014c377824ULL, 0x040fe200078e0209ULL,
0x0000003a4d367210ULL, 0x000fe20007ffe0ffULL, 0x000000084c5e7824ULL, 0x000fe200078e00ffULL,
0x00000034814f7211ULL, 0x002fe200078a38ffULL, 0x0000008038387825ULL, 0x000fc600078e00ffULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee237ULL, 0x000000014d3a7824ULL, 0x040fe200078e024cULL,
0x0000005d38347212ULL, 0x000fe200078efcffULL, 0x000000014d4c7824ULL, 0x000fe200078e0264ULL,
0x0000003581677211ULL, 0x000fe200028f3cffULL, 0x00000001643b7824ULL, 0x040fe200078e0209ULL,
0x000000344f347210ULL, 0x000fe20007fbe0ffULL, 0x0000000864647824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff864647812ULL, 0x000fe200078ee23bULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000005d36367212ULL, 0x000fc600078efcffULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x0000005d3a387212ULL, 0x000fc600078efcffULL,
0x0000000139357824ULL, 0x000fe200028e0667ULL, 0x0000004f36367210ULL, 0x000fe20007fbe0ffULL,
0x0000200063397824ULL, 0x000fe200078e0208ULL, 0x0000005d4c3a7212ULL, 0x000fc600078efcffULL,
0x0001700039397836ULL, 0x000fe20000000000ULL, 0x0000004f3a3a7210ULL, 0x000fe20007fde0ffULL,
0x0000000137377824ULL, 0x000fe200028e0667ULL, 0x0000004f38387210ULL, 0x000fe20007fbe0ffULL,
0x000000104e4f7824ULL, 0x100fe400078e0239ULL, 0x000000105c5d7824ULL, 0x100fe400078e0239ULL,
0x000000105e5f7824ULL, 0x100fe200078e0239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000344f7faeULL, 0x0003e2000e101c46ULL, 0x0000001064657824ULL, 0x000fc400078e0239ULL,
0x000000013b397824ULL, 0x100fe200028e0667ULL, 0x00000000365d7faeULL, 0x0003e2000d901c46ULL,
0x000000014d3b7824ULL, 0x000fc600030e0667ULL, 0x00000000385f7faeULL, 0x0003e8000d101c46ULL,
0x000000003a657faeULL, 0x0003e2000c101c46ULL, 0x0000000000dc7947ULL, 0x000fea0003800000ULL,
0x0000001034367812ULL, 0x000fe400078ec0ffULL, 0x00009000ff347b82ULL, 0x000e640000000a00ULL,
0x0000003609367211ULL, 0x000fca00078fe8ffULL, 0x0000000436387836ULL, 0x000fe40000000000ULL,
0x0000000136377824ULL, 0x140fe400078e0209ULL, 0x00000008364e7824ULL, 0x000fe400078e00ffULL,
0x0000000138397824ULL, 0x040fe400078e0209ULL, 0x00000008385c7824ULL, 0x000fe200078e00ffULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee237ULL, 0x000000014d377824ULL, 0x000fc400078e0236ULL,
0x00000008363a7836ULL, 0x000fe20000000000ULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee239ULL,
0x0000001009397824ULL, 0x000fe400078e00ffULL, 0x0000000c364c7836ULL, 0x000fe20000000000ULL,
0x00000034815d7211ULL, 0x002fe200078038ffULL, 0x0000008037367825ULL, 0x000fe200078e00ffULL,
0x00000070394f7812ULL, 0x000fe400078ec0ffULL, 0x0000003581817211ULL, 0x000fe200000f3cffULL,
0x000000014d3b7824ULL, 0x000fe200078e023aULL, 0x0000004f36347212ULL, 0x000fe200078efcffULL,
0x000000013a397824ULL, 0x000fc400078e0209ULL, 0x000000083a5e7824ULL, 0x000fe200078e00ffULL,
0x000000345d347210ULL, 0x000fe20007f1e0ffULL, 0x000000014c3a7824ULL, 0x040fe400078e0209ULL,
0x000000084c5f7824ULL, 0x000fe200078e00ffULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee239ULL,
0x000000014d387824ULL, 0x040fe400078e0238ULL, 0x000000014d4d7824ULL, 0x000fe200078e024cULL,
0xfffffff85f647812ULL, 0x000fe200078ee23aULL, 0x0000008038387825ULL, 0x000fc800078e00ffULL,
0x000000803b3a7825ULL, 0x000fe200078e00ffULL, 0x0000004f38367212ULL, 0x000fc600078efcffULL,
0x000000804d4c7825ULL, 0x000fe200078e00ffULL, 0x0000004f3a387212ULL, 0x000fc600078efcffULL,
0x0000000137357824ULL, 0x000fe200000e0681ULL, 0x0000004f4c3a7212ULL, 0x000fe200078efcffULL,
0x0000200063377824ULL, 0x000fe200078e0208ULL, 0x000000365d367210ULL, 0x000fe40007f1e0ffULL,
0x000000385d387210ULL, 0x000fe20007f5e0ffULL, 0x0001700037377836ULL, 0x000fe20000000000ULL,
0x0000003a5d3a7210ULL, 0x000fc60007f7e0ffULL, 0x000000104e4f7824ULL, 0x100fe200078e0237ULL,
0x0000003764657211ULL, 0x000fe200078e20ffULL, 0x000000105c5d7824ULL, 0x100fe400078e0237ULL,
0x000000105e5f7824ULL, 0x000fe200078e0237ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000344f7faeULL, 0x0003e2000b901c46ULL, 0x0000000139377824ULL, 0x100fe400000e0681ULL,
0x000000013b397824ULL, 0x100fe400010e0681ULL, 0x000000014d3b7824ULL, 0x000fe200018e0681ULL,
0x00000000365d7faeULL, 0x0003e8000b901c46ULL, 0x00000000385f7faeULL, 0x0003e8000b901c46ULL,
0x000000003a657faeULL, 0x0003e4000b901c46ULL, 0x0000000160367836ULL, 0x002fe40000000000ULL,
0xffffffffff7b7424ULL, 0x000fc600078e00ffULL, 0x000000753600720cULL, 0x000fda0003f06070ULL,
0x00009200ff348b82ULL, 0x000e620000000a00ULL, 0x0000000107378824ULL, 0x000fe400078e0236ULL,
0x0000000877367824ULL, 0x000fe400078e00ffULL, 0x0000000437348825ULL, 0x002fc600078e0034ULL,
0xfffffff036377812ULL, 0x040fe400078ec0ffULL, 0x0000001036387812ULL, 0x000fe200078ec0ffULL,
0x00000006347b8981ULL, 0x000324000c1e1900ULL, 0x00000001083a7824ULL, 0x000fe200078e0237ULL,
0xffffffe036377812ULL, 0x040fe200078ec0ffULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x0000000836807812ULL, 0x000fe400078ec0ffULL, 0x000000003a0572caULL, 0x000fc400000e0000ULL,
0x0000000838377210ULL, 0x000fe20007ffe037ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000137807824ULL, 0x000fcc00078e0280ULL, 0x0001a6b005057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x01a6b0393a8679a7ULL, 0x0002e4000850003fULL, 0x01a60839803879a7ULL, 0x0022a4000850003fULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x01a60839800075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a60839800075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x00000010096d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff707819ULL, 0x000fe20000011609ULL,
0x0000002077347824ULL, 0x000fe400078e00ffULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x000000706d6d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff857224ULL, 0x000fe200078e007aULL,
0xffffff8034347812ULL, 0x000fe400078ec0ffULL, 0x0000000c70707812ULL, 0x000fe400078ec0ffULL,
0x000000086d357210ULL, 0x000fca0007ffe034ULL, 0x0000000135357824ULL, 0x000fca00078e0270ULL,
0x01a0000035377984ULL, 0x000ea80000000800ULL, 0x01a2000035397984ULL, 0x000b620000000800ULL,
0x0000007a3700720bULL, 0x004fda0003f1d000ULL, 0x0000000000367806ULL, 0x000fc800000e0100ULL,
0x000000ff3600720cULL, 0x000fda0003f05270ULL, 0x00000004008c8947ULL, 0x02afea0003800000ULL,
0x000000775b00720cULL, 0x000fe40003f45270ULL, 0x0000007a3700720bULL, 0x0c0fe40003f14000ULL,
0x0000007a37857209ULL, 0x000fd20007810000ULL, 0x000000807734a824ULL, 0x000fe400078e0208ULL,
0x0000000000357806ULL, 0x000fc600000e0100ULL, 0x000000347034a210ULL, 0x000fe40007ffe06dULL,
0x000000ff3500720cULL, 0x000fc60003f05270ULL, 0x01a400853400a388ULL, 0x0003f40000000800ULL,
0x0000000400508947ULL, 0x002fea0003800000ULL, 0x0000007a85347221ULL, 0x000fe20000010100ULL,
0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0035ff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL, 0x00ff000035ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000035ff7812ULL, 0x000fe2000788c0ffULL, 0x00000034003b7308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x002fcc0000011609ULL,
0x00001f343b347589ULL, 0x004e6400000e0000ULL, 0x0000003454547220ULL, 0x082fe20000410000ULL,
0x0000003455557220ULL, 0x080fe20000410000ULL, 0x000000343c3c7220ULL, 0x080fe20000410000ULL,
0x000000343d3d7220ULL, 0x080fe20000410000ULL, 0x0000003440407220ULL, 0x080fe20000410000ULL,
0x0000003441417220ULL, 0x080fe20000410000ULL, 0x0000003444447220ULL, 0x080fe20000410000ULL,
0x0000003445457220ULL, 0x080fe20000410000ULL, 0x0000003448487220ULL, 0x080fe20000410000ULL,
0x0000003449497220ULL, 0x080fe20000410000ULL, 0x0000003450507220ULL, 0x080fe20000410000ULL,
0x0000003451517220ULL, 0x080fe20000410000ULL, 0x0000003428287220ULL, 0x080fe20000410000ULL,
0x0000003429297220ULL, 0x080fe20000410000ULL, 0x0000003424247220ULL, 0x080fe20000410000ULL,
0x0000003425257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000000809347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343b347589ULL, 0x004e6400000e0000ULL,
0x0000003456567220ULL, 0x082fe20000410000ULL, 0x0000003457577220ULL, 0x080fe20000410000ULL,
0x000000343e3e7220ULL, 0x080fe20000410000ULL, 0x000000343f3f7220ULL, 0x080fe20000410000ULL,
0x0000003442427220ULL, 0x080fe20000410000ULL, 0x0000003443437220ULL, 0x080fe20000410000ULL,
0x0000003446467220ULL, 0x080fe20000410000ULL, 0x0000003447477220ULL, 0x080fe20000410000ULL,
0x000000344a4a7220ULL, 0x080fe20000410000ULL, 0x000000344b4b7220ULL, 0x080fe20000410000ULL,
0x0000003452527220ULL, 0x080fe20000410000ULL, 0x0000003453537220ULL, 0x080fe20000410000ULL,
0x000000342a2a7220ULL, 0x080fe20000410000ULL, 0x000000342b2b7220ULL, 0x080fe20000410000ULL,
0x0000003426267220ULL, 0x080fe20000410000ULL, 0x0000003427277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x0000001009347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343b347589ULL, 0x004e6400000e0000ULL, 0x000000340c0c7220ULL, 0x082fe20000410000ULL,
0x000000340d0d7220ULL, 0x080fe20000410000ULL, 0x0000003410107220ULL, 0x080fe20000410000ULL,
0x0000003411117220ULL, 0x080fe20000410000ULL, 0x0000003414147220ULL, 0x080fe20000410000ULL,
0x0000003415157220ULL, 0x080fe20000410000ULL, 0x0000003418187220ULL, 0x080fe20000410000ULL,
0x0000003419197220ULL, 0x080fe20000410000ULL, 0x000000341c1c7220ULL, 0x080fe20000410000ULL,
0x000000341d1d7220ULL, 0x080fe20000410000ULL, 0x0000003420207220ULL, 0x080fe20000410000ULL,
0x0000003421217220ULL, 0x080fe20000410000ULL, 0x0000003430307220ULL, 0x080fe20000410000ULL,
0x0000003431317220ULL, 0x080fe20000410000ULL, 0x000000342c2c7220ULL, 0x080fe20000410000ULL,
0x000000342d2d7220ULL, 0x000fce0000410000ULL, 0x0000003b84847220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x0000001809347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343b347589ULL, 0x000e6400000e0000ULL, 0x000000340e0e7220ULL, 0x082fe20000410000ULL,
0x000000340f0f7220ULL, 0x080fe20000410000ULL, 0x0000003412127220ULL, 0x080fe20000410000ULL,
0x0000003413137220ULL, 0x080fe20000410000ULL, 0x0000003416167220ULL, 0x080fe20000410000ULL,
0x0000003417177220ULL, 0x080fe20000410000ULL, 0x000000341a1a7220ULL, 0x080fe20000410000ULL,
0x000000341b1b7220ULL, 0x080fe20000410000ULL, 0x000000341e1e7220ULL, 0x080fe20000410000ULL,
0x000000341f1f7220ULL, 0x080fe20000410000ULL, 0x0000003422227220ULL, 0x080fe20000410000ULL,
0x0000003423237220ULL, 0x080fe20000410000ULL, 0x0000003432327220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x000000342e2e7220ULL, 0x080fe20000410000ULL,
0x000000342f2f7220ULL, 0x000fce0000410000ULL, 0x0000003536ff7212ULL, 0x000fda00078030ffULL,
0x8000008537370221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b37370820ULL, 0x000fc80000410000ULL, 0x0000003700040308ULL, 0x000ea40000000800ULL,
0x0000000439390220ULL, 0x004fce0000410000ULL, 0x0000008439847221ULL, 0x000fce0000010000ULL,
0x0000000000347805ULL, 0x002fce0000015200ULL, 0x01a6a87f3a0075a7ULL, 0x000e62000800017fULL,
0x0001a6a83a397836ULL, 0x000fca0000000000ULL, 0x00000000390572caULL, 0x000fe200000e0000ULL,
0x0000000000600947ULL, 0x002fdc0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a6a87f3a0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000000390572caULL, 0x000fde00000e0000ULL, 0x00000002777d7824ULL, 0x000fe200078e00ffULL,
0x00000008096c7812ULL, 0x000fe200078ec0ffULL, 0x0000000477367824ULL, 0x000fe200078e00ffULL,
0x0000991038347816ULL, 0x000fe400000000ffULL, 0x000000047d727812ULL, 0x000fe400078ec0ffULL,
0x000000076c6c7812ULL, 0x000fe400078ef809ULL, 0x0000007209357211ULL, 0x000fe400078fe0ffULL,
0x000000ff3400720cULL, 0x000fe20003f05270ULL, 0x000000086c387824ULL, 0x040fe200078e00ffULL,
0x000000106c787812ULL, 0x040fe200078efcffULL, 0x000000016c7f7824ULL, 0x000fe200078e0235ULL,
0x0000000436367812ULL, 0x000fe200078ec0ffULL, 0x0000040077347824ULL, 0x000fc400078e00ffULL,
0x00000001357e7824ULL, 0x000fe200078e0278ULL, 0xfffffff8387f7812ULL, 0x000fe200078ee27fULL,
0x0000100077387824ULL, 0x000fe200078e00ffULL, 0x0000003609717211ULL, 0x000fe200078fe0ffULL,
0x0000000878357824ULL, 0x000fe200078e00ffULL, 0xfffff00034377812ULL, 0x000fe200078ec0ffULL,
0x000000086c3b7824ULL, 0x000fe200078e00ffULL, 0xffffe00038397812ULL, 0x000fe200078ec0ffULL,
0x000000016c4c7824ULL, 0x000fe200078e0271ULL, 0x00012000087a7810ULL, 0x000fe40007ffe037ULL,
0xfffffff8357e7812ULL, 0x000fc400078ee27eULL, 0x00016000084d7810ULL, 0x000fe20007ffe039ULL,
0x000000107f367824ULL, 0x000fe200078e027aULL, 0xfffffff83b6e7812ULL, 0x000fe400078ee24cULL,
0x0000007a7e387211ULL, 0x000fe200078e20ffULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000001003057836ULL, 0x000fe20000000000ULL, 0x0000541000347816ULL, 0x000fe20000000000ULL,
0x0000000803357836ULL, 0x000fe40000000000ULL, 0x0000001803377836ULL, 0x000fe40000000000ULL,
0x00001f0534057589ULL, 0x0002a800000e0000ULL, 0x00001f3534027589ULL, 0x0002e800000e0000ULL,
0x00001f0334037589ULL, 0x00026800000e0000ULL, 0x00001f3734007589ULL, 0x00026400000e0000ULL,
0x000000003634783bULL, 0x002e620000000200ULL, 0x000000106e5c7824ULL, 0x000fc600078e024dULL,
0x000000003838783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000235357232ULL, 0x088fe40000200000ULL, 0x0000000237377232ULL, 0x000fe40000200000ULL,
0x0000000538387232ULL, 0x084fe40000200000ULL, 0x000000053a3a7232ULL, 0x000fc40000200000ULL,
0x0000000039397232ULL, 0x080fe40000200000ULL, 0x000000003b3b7232ULL, 0x000fce0000200000ULL,
0x000000086c4e7824ULL, 0x000fe200078e00ffULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x000000024c737836ULL, 0x000fe20000000000ULL, 0x0000000272727812ULL, 0x000fc800078efcffULL,
0xfffffff84e737812ULL, 0x000fca00078ee273ULL, 0x00000010734d7824ULL, 0x000fcc00078e024dULL,
0x000000004d4c783bULL, 0x000f640000004200ULL, 0x000001005d657824ULL, 0x068fe200078e00ffULL,
0x000088805d907816ULL, 0x040fe200000000ffULL, 0x000001005c647824ULL, 0x040fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001145dULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x0000009000907306ULL, 0x000fe20000202400ULL, 0x000088805c817816ULL, 0x000fc400000000ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001145cULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fe2000001145dULL, 0x000001005e5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe2000001145eULL, 0x0000006500937306ULL, 0x0007620000202400ULL,
0x00000018ff677819ULL, 0x004fe2000001144dULL, 0x000001004d687824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe2000001144cULL, 0x000001004e697824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fc4000001145cULL, 0x00000018ff8f7819ULL, 0x000fe2000001145dULL,
0x0000006400927306ULL, 0x0005e20000202400ULL, 0x000001004c657824ULL, 0x008fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001145fULL, 0x000088805e5c7816ULL, 0x040fe200000000ffULL,
0x000100005e5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fe40000011465ULL,
0x000088804d657816ULL, 0x000fe200000000ffULL, 0x000001005f647824ULL, 0x004fe200078e00ffULL,
0x0000008100817306ULL, 0x000ea20000202400ULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x000088805f5d7816ULL, 0x040fe200000000ffULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fc40000011464ULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000008d008d7306ULL, 0x000fe20000202400ULL, 0x00000018ff887819ULL, 0x000fe40000011468ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff6a7819ULL, 0x000fe4000001144eULL,
0x000088804e687816ULL, 0x040fe200000000ffULL, 0x0000004d00827306ULL, 0x000be20000202400ULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fc40000011469ULL,
0x00000018ff6b7819ULL, 0x000fe4000001144fULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x0000004c00837306ULL, 0x0007e20000202400ULL, 0x00005410904d7816ULL, 0x022fe20000000093ULL,
0x000100004f907824ULL, 0x040fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x000088804f697816ULL, 0x040fe400000000ffULL, 0x00000018ff907819ULL, 0x000fe20000011490ULL,
0x0000008c008c7306ULL, 0x000fe20000202400ULL, 0x000001004f4c7824ULL, 0x008fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fc8000001144eULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000008b008b7306ULL, 0x000ff00000202400ULL, 0x0000004c007c7306ULL, 0x0005f00000202400ULL,
0x0000008a008a7306ULL, 0x000fe20000202400ULL, 0x00005410814c7816ULL, 0x004fce0000000092ULL,
0x0000006600667306ULL, 0x000e620000202400ULL, 0x0000004c3454723cULL, 0x000fec0000041854ULL,
0x0000004c380c723cULL, 0x000fe2000004180cULL, 0x0000006700677306ULL, 0x000eac0000202400ULL,
0x00000001784c7824ULL, 0x000fe200078e0271ULL, 0x0000541083667816ULL, 0x002fe20000000066ULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x0000541082677816ULL, 0x004fce0000000067ULL,
0x0000006b006b7306ULL, 0x000fe20000202400ULL, 0x000000663450723cULL, 0x000fee0000041850ULL,
0x0000008e008e7306ULL, 0x000fe20000202400ULL, 0x000000663820723cULL, 0x000fee0000041820ULL,
0x0000009100917306ULL, 0x000e700000202400ULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x00005410914f7816ULL, 0x002fce000000008cULL, 0x0000008f008f7306ULL, 0x000e700000202400ULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x000054105c5c7816ULL, 0x002fce000000008fULL,
0x0000009400947306ULL, 0x000e700000202400ULL, 0x0000005e005e7306ULL, 0x000ea20000202400ULL,
0x000054105d5d7816ULL, 0x002fce0000000094ULL, 0x0000005f005f7306ULL, 0x000e620000202400ULL,
0x0000005c3440723cULL, 0x000fe20000041840ULL, 0x000054105e5e7816ULL, 0x004fcc000000008bULL,
0x0000006400647306ULL, 0x000fe20000202400ULL, 0x0000005c3814723cULL, 0x000fe20000041814ULL,
0x000054105f5f7816ULL, 0x002fcc000000008aULL, 0x0000008900897306ULL, 0x000e620000202400ULL,
0x0000005e3444723cULL, 0x000fee0000041844ULL, 0x0000006500657306ULL, 0x000fe20000202400ULL,
0x0000005e3818723cULL, 0x000fe20000041818ULL, 0x0000541064647816ULL, 0x002fcc0000000089ULL,
0x0000008800887306ULL, 0x000e700000202400ULL, 0x0000006800687306ULL, 0x000fe20000202400ULL,
0x0000541065657816ULL, 0x002fce0000000088ULL, 0x0000006f006f7306ULL, 0x000e620000202400ULL,
0x000000643448723cULL, 0x000fee0000041848ULL, 0x0000006900697306ULL, 0x000ea20000202400ULL,
0x00000064381c723cULL, 0x000fe2000004181cULL, 0x0000541068687816ULL, 0x002fcc000000006fULL,
0x0000004e00817306ULL, 0x0002e20000202400ULL, 0x0000541069697816ULL, 0x004fce000000007cULL,
0x0000009000907306ULL, 0x000ea20000202400ULL, 0x000054108e4e7816ULL, 0x002fe2000000008dULL,
0x000000683428723cULL, 0x000fe20000041828ULL, 0x00005410816a7816ULL, 0x008fca000000006aULL,
0x0000004e343c723cULL, 0x000fe2000004183cULL, 0x00005410906b7816ULL, 0x004fca000000006bULL,
0x0000004e3810723cULL, 0x000fec0000041810ULL, 0x0000006a3424723cULL, 0x000fec0000041824ULL,
0x000000683830723cULL, 0x000fe20000041830ULL, 0x0000007209357211ULL, 0x000fe200078fe0ffULL,
0x000000086c347824ULL, 0x000fc400078e00ffULL, 0x0000000878377824ULL, 0x000fe400078e00ffULL,
0x000000016c6f7824ULL, 0x100fe200078e0235ULL, 0x0000006a3838723cULL, 0x000fe2000004182cULL,
0x0000000178357824ULL, 0x040fe200078e0235ULL, 0xfffffff8377c7812ULL, 0x000fe200078ee24cULL,
0x0000200063727824ULL, 0x000fe200078e0208ULL, 0xfffffff8346f7812ULL, 0x000fe200078ee26fULL,
0x0000000878347824ULL, 0x000fe400078e00ffULL, 0x0001600072837836ULL, 0x000fc60000000000ULL,
0xfffffff834717812ULL, 0x000fe200078ee235ULL, 0x000000106f347824ULL, 0x100fe400078e027aULL,
0x000000107c5c7824ULL, 0x000fe400078e0283ULL, 0x00000010717a7824ULL, 0x000fe400078e027aULL,
0x000000003434783bULL, 0x000e680000000200ULL, 0x000000007a2c783bULL, 0x0004e20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000200000ULL,
0x0000000336367232ULL, 0x000fe40000200000ULL, 0x0000000235357232ULL, 0x080fe40000200000ULL,
0x0000000237377232ULL, 0x000fe40000200000ULL, 0x000000052c2c7232ULL, 0x088fe40000200000ULL,
0x000000052e2e7232ULL, 0x000fc40000200000ULL, 0x000000002d2d7232ULL, 0x080fe40000200000ULL,
0x000000002f2f7232ULL, 0x000fce0000200000ULL, 0x00000008784d7824ULL, 0x000fe200078e00ffULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x000000024c7a7836ULL, 0x004fe20000000000ULL,
0xfffffff87d7d7812ULL, 0x000fc800078ec0ffULL, 0xfffffff84d7a7812ULL, 0x000fe200078ee27aULL,
0x00000001087d7824ULL, 0x000fc600078e027dULL, 0x000000837a4c7211ULL, 0x000fcc00078e20ffULL,
0x000000004c4c783bULL, 0x000ea20000004200ULL, 0x000001005c647824ULL, 0x020fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe2000001145dULL, 0x000001005d657824ULL, 0x040fe200078e00ffULL,
0x000088805d947816ULL, 0x040fe200000000ffULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000009000907306ULL, 0x000fe20000202400ULL, 0x00000018ff957819ULL, 0x000fe2000001145dULL,
0x000001005e5d7824ULL, 0x000fe200078e00ffULL, 0x000088805c897816ULL, 0x000fc400000000ffULL,
0x00000018ff927819ULL, 0x000fe2000001145cULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fe2000001145dULL, 0x0000006400967306ULL, 0x000be20000202400ULL,
0x00000018ff667819ULL, 0x004fe2000001144cULL, 0x000001004d687824ULL, 0x000fe200078e00ffULL,
0x000088805f5d7816ULL, 0x040fe200000000ffULL, 0x000001004e697824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe4000001144dULL, 0x00000018ff937819ULL, 0x000fe2000001145cULL,
0x0000006500977306ULL, 0x0005e20000202400ULL, 0x000001005f647824ULL, 0x028fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fc4000001145eULL, 0x00000018ff8e7819ULL, 0x000fe2000001145fULL,
0x000100005f5f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe40000011464ULL,
0x0000009400947306ULL, 0x000fe20000202400ULL, 0x000001004c657824ULL, 0x044fe200078e00ffULL,
0x000088804c647816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x000088805e5c7816ULL, 0x040fe200000000ffULL, 0x000100005e5e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fc40000011465ULL, 0x000088804d657816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x0000008900897306ULL, 0x000fe20000202400ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff8c7819ULL, 0x000fe40000011468ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff6a7819ULL, 0x000fe2000001144eULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x000088804e687816ULL, 0x040fe200000000ffULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fc40000011469ULL,
0x00000018ff6b7819ULL, 0x000fe4000001144fULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000008a008a7306ULL, 0x000ea20000202400ULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x000088804f697816ULL, 0x000fe400000000ffULL, 0x00000018ff4e7819ULL, 0x000fc6000001144eULL,
0x0000004c008b7306ULL, 0x0007e20000202400ULL, 0x000054105d5d7816ULL, 0x004fce000000008aULL,
0x0000004d00887306ULL, 0x0005e20000202400ULL, 0x000001004f4c7824ULL, 0x008fca00078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000009200927306ULL, 0x000fe20000202400ULL,
0x00005410944d7816ULL, 0x004fe20000000097ULL, 0x000100004f947824ULL, 0x000fca00078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011494ULL, 0x0000004c00827306ULL, 0x0005f00000202400ULL,
0x0000008f008f7306ULL, 0x000fe20000202400ULL, 0x00005410894c7816ULL, 0x004fce0000000096ULL,
0x0000008e008e7306ULL, 0x000fe20000202400ULL, 0x0000004c3454723cULL, 0x002fec0000041854ULL,
0x0000004c2c0c723cULL, 0x000fe2000004180cULL, 0x0000006600667306ULL, 0x000e700000202400ULL,
0x0000006700677306ULL, 0x000ea20000202400ULL, 0x000054108b667816ULL, 0x002fce0000000066ULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x0000541088677816ULL, 0x004fce0000000067ULL,
0x0000006b006b7306ULL, 0x000fe20000202400ULL, 0x000000663450723cULL, 0x000fee0000041850ULL,
0x0000009300937306ULL, 0x000fe20000202400ULL, 0x000000662c20723cULL, 0x000fee0000041820ULL,
0x0000009500957306ULL, 0x000e700000202400ULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x00005410954f7816ULL, 0x002fce0000000090ULL, 0x0000009100917306ULL, 0x000e700000202400ULL,
0x0000005e005e7306ULL, 0x000ea20000202400ULL, 0x000054105c5c7816ULL, 0x002fce0000000091ULL,
0x0000005f005f7306ULL, 0x000e620000202400ULL, 0x0000005c3440723cULL, 0x000fe20000041840ULL,
0x000054105e5e7816ULL, 0x004fcc000000008fULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x0000005c2c14723cULL, 0x000fe20000041814ULL, 0x000054105f5f7816ULL, 0x002fcc000000008eULL,
0x0000008d008d7306ULL, 0x000e620000202400ULL, 0x0000005e3444723cULL, 0x000fee0000041844ULL,
0x0000006500657306ULL, 0x000fe20000202400ULL, 0x0000005e2c18723cULL, 0x000fe20000041818ULL,
0x0000541064647816ULL, 0x002fcc000000008dULL, 0x0000008c008c7306ULL, 0x000e700000202400ULL,
0x0000006800687306ULL, 0x000fe20000202400ULL, 0x0000541065657816ULL, 0x002fce000000008cULL,
0x0000008100817306ULL, 0x000e620000202400ULL, 0x000000643448723cULL, 0x000fee0000041848ULL,
0x0000006900697306ULL, 0x000ea20000202400ULL, 0x000000642c1c723cULL, 0x000fe2000004181cULL,
0x0000541068687816ULL, 0x002fcc0000000081ULL, 0x0000004e00897306ULL, 0x0002e20000202400ULL,
0x0000541069697816ULL, 0x004fce0000000082ULL, 0x00000094008a7306ULL, 0x000ea20000202400ULL,
0x00005410934e7816ULL, 0x002fe20000000092ULL, 0x000000683428723cULL, 0x000fe20000041828ULL,
0x00005410896a7816ULL, 0x008fca000000006aULL, 0x0000004e343c723cULL, 0x000fe2000004183cULL,
0x000054108a6b7816ULL, 0x004fca000000006bULL, 0x0000004e2c10723cULL, 0x000fec0000041810ULL,
0x0000006a3424723cULL, 0x000fec0000041824ULL, 0x000000682c30723cULL, 0x000fe20000041830ULL,
0x0000000863347824ULL, 0x000fc400078e0208ULL, 0x00000001ff367424ULL, 0x000fc600078e00ffULL,
0x0000006a2c38723cULL, 0x000fe20000041838ULL, 0x01a6c836343479a7ULL, 0x0002a2000850003fULL,
0x01a688367dff79a7ULL, 0x0003de000850003fULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x00000035060075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff367224ULL, 0x002fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000010772c7824ULL, 0x000fe200078e00ffULL, 0x0000850000087ab9ULL, 0x000fe40000000800ULL,
0x000000087b7b7c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe02c2d7812ULL, 0x000fe400078ec0ffULL,
0x000000807b817824ULL, 0x000fc600078e00ffULL, 0x00000100582d7824ULL, 0x000fc800078e022dULL,
0x000000802d2f7836ULL, 0x000fca0000000000ULL, 0x000000602f2d7812ULL, 0x000fca00078ec0ffULL,
0x000000015a4d7824ULL, 0x000fe200078e022dULL, 0x0000000400009947ULL, 0x000fec0003800000ULL,
0x000000102c357812ULL, 0x000fe400078ec0ffULL, 0x0000002f742c7248ULL, 0x000fe40007fe0000ULL,
0x00000003ff347819ULL, 0x000fc60000011609ULL, 0x000000012c2e7824ULL, 0x000fe400078e0a2fULL,
0x00009000ff2c7b82ULL, 0x000ea20000000a00ULL, 0x0000000134367824ULL, 0x002fe400078e0235ULL,
0x0000002e352e7248ULL, 0x000fe20007fe0000ULL, 0x0000000834377836ULL, 0x000fe40000000000ULL,
0x00000001362f7824ULL, 0x040fe400078e0209ULL, 0x00000008364e7824ULL, 0x000fe200078e00ffULL,
0x0000004d36367210ULL, 0x000fe20007ffe0ffULL, 0x000000012e2e7824ULL, 0x000fc400078e0a35ULL,
0x0000000c344f7836ULL, 0x000fe20000000000ULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee22fULL,
0x00000004342f7836ULL, 0x000fe20000000000ULL, 0x0000002e3400720cULL, 0x080fe20003f86070ULL,
0x00000001374c7824ULL, 0x140fe200078e0235ULL, 0x0000002e3700720cULL, 0x080fe20003f46070ULL,
0x000000012f347824ULL, 0x140fe200078e0235ULL, 0x0000002e2f00720cULL, 0x080fe20003f66070ULL,
0x000000014f647824ULL, 0x040fe200078e0235ULL, 0x0000002e4f00720cULL, 0x000fe20003f06070ULL,
0x000000014c2e7824ULL, 0x000fc400078e0209ULL, 0x000000084c357824ULL, 0x000fe200078e00ffULL,
0x0000002c814f7211ULL, 0x004fe200078a38ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff8355e7812ULL, 0x000fe200078ee22eULL, 0x00000001342f7824ULL, 0x000fe200078e0209ULL,
0x0000006d362c7212ULL, 0x000fe200078efcffULL, 0x00000008345c7824ULL, 0x040fe200078e00ffULL,
0x0000002d815d7211ULL, 0x000fe200028f3cffULL, 0x0000000134347824ULL, 0x100fe200078e024dULL,
0x0000002c4f2c7210ULL, 0x000fe20007fbe0ffULL, 0x000000014c4c7824ULL, 0x000fe200078e024dULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee22fULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x00000001642e7824ULL, 0x000fe200078e024dULL, 0x0000006d34347212ULL, 0x000fe200078efcffULL,
0x000000804c4c7825ULL, 0x000fc800078e00ffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000006d4c367212ULL, 0x000fc600078efcffULL, 0x00000001372d7824ULL, 0x000fe200028e065dULL,
0x0000004f34347210ULL, 0x000fe20007fbe0ffULL, 0x0000000164377824ULL, 0x000fe200078e0209ULL,
0x0000006d2e2e7212ULL, 0x000fe200078efcffULL, 0x00000008644c7824ULL, 0x000fe400078e00ffULL,
0x0000000135357824ULL, 0x000fe200028e065dULL, 0x0000004f36367210ULL, 0x000fe40007fbe0ffULL,
0x0000004f2e2e7210ULL, 0x000fe20007fde0ffULL, 0x000000104e4f7824ULL, 0x000fe200078e0283ULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee237ULL, 0x000000014d377824ULL, 0x000fc400028e065dULL,
0x000000012f2f7824ULL, 0x000fe200030e065dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c4f7faeULL, 0x0003e2000e101c46ULL, 0x000000105c4d7824ULL, 0x100fe400078e0283ULL,
0x000000105e5d7824ULL, 0x100fe400078e0283ULL, 0x000000104c5f7824ULL, 0x000fe200078e0283ULL,
0x00000000344d7faeULL, 0x0003e8000d901c46ULL, 0x00000000365d7faeULL, 0x0003e8000d101c46ULL,
0x000000002e5f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x000000102c2c7812ULL, 0x000fe200078ec0ffULL, 0x00009000ff2e7b82ULL, 0x000ea60000000a00ULL,
0x0000002c092c7211ULL, 0x000fca00078fe8ffULL, 0x000000012c2d7824ULL, 0x040fe400078e0209ULL,
0x000000082c4e7824ULL, 0x040fe400078e00ffULL, 0x000000042c347836ULL, 0x000fe40000000000ULL,
0x000000082c5c7836ULL, 0x000fe20000000000ULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee22dULL,
0x0000000c2c5e7836ULL, 0x000fe40000000000ULL, 0x000000012c367824ULL, 0x002fc400078e024dULL,
0x00000001344c7824ULL, 0x040fe400078e024dULL, 0x00000001342d7824ULL, 0x040fe400078e0209ULL,
0x0000000834647824ULL, 0x000fe200078e00ffULL, 0x0000002e814f7211ULL, 0x044fe200078038ffULL,
0x000000015c347824ULL, 0x100fe400078e024dULL, 0x000000015e2c7824ULL, 0x040fe200078e024dULL,
0x0000002f815d7211ULL, 0x000fe200000f3cffULL, 0x000000015e4d7824ULL, 0x000fc400078e0209ULL,
0x000000085e687824ULL, 0x000fe400078e00ffULL, 0x000000015c357824ULL, 0x040fe400078e0209ULL,
0x000000085c667824ULL, 0x000fe200078e00ffULL, 0xfffffff8645c7812ULL, 0x000fe200078ee22dULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0xfffffff868647812ULL, 0x000fe400078ee24dULL,
0xfffffff8665e7812ULL, 0x000fe200078ee235ULL, 0x000000804c4c7825ULL, 0x000fe200078e00ffULL,
0x0000006d362e7212ULL, 0x000fc600078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000006d4c367212ULL, 0x080fe400078efcffULL, 0x0000002e4f2e7210ULL, 0x000fe20007f1e0ffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000006d34347212ULL, 0x080fe400078efcffULL,
0x000000364f367210ULL, 0x000fe20007f5e0ffULL, 0x00000010645f7824ULL, 0x000fe200078e0283ULL,
0x0000006d2c2c7212ULL, 0x000fe400078efcffULL, 0x0000005d372f7210ULL, 0x000fe200007fe4ffULL,
0x000000014d377824ULL, 0x000fe200010e065dULL, 0x000000344f347210ULL, 0x000fe20007f1e0ffULL,
0x000000104e4d7824ULL, 0x100fe200078e0283ULL, 0x0000002c4f2c7210ULL, 0x000fe20007f7e0ffULL,
0x000000105c4f7824ULL, 0x000fc400078e0283ULL, 0x0000000135357824ULL, 0x100fe200000e065dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e4d7faeULL, 0x0003e2000b901c46ULL,
0x000000012d2d7824ULL, 0x000fe400018e065dULL, 0x000000105e5d7824ULL, 0x000fe200078e0283ULL,
0x00000000364f7faeULL, 0x0003e8000b901c46ULL, 0x00000000345d7faeULL, 0x0003e8000b901c46ULL,
0x000000002c5f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff2d7424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000002dff8879a7ULL, 0x0002a40008500005ULL,
0x01a6282d802c79a7ULL, 0x0022e4000850003fULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x01a6282d800075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x000000342e377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e2fULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6282d800075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x00000020772c7824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0xffffff802c2d7812ULL, 0x000fc800078ec0ffULL,
0x00000080082c7810ULL, 0x000fc80007ffe02dULL, 0x0000002c702c7210ULL, 0x000fca0007ffe06dULL,
0x01a000002c2e7984ULL, 0x000ee80000000800ULL, 0x01a200002c2d7984ULL, 0x0009220000000800ULL,
0x000000852e00720bULL, 0x008fda0003f1d000ULL, 0x00000000002f7806ULL, 0x000fc800000e0100ULL,
0x000000ff2f00720cULL, 0x000fda0003f05270ULL, 0x00000004009c8947ULL, 0x016fea0003800000ULL,
0x000000015b2c7836ULL, 0x000fe20000000000ULL, 0x000000852e00720bULL, 0x000fc80003f14000ULL,
0x000000772c00720cULL, 0x000fda0003f45270ULL, 0x000000807734a824ULL, 0x000fe200078e0208ULL,
0x000000852e2ca209ULL, 0x000fc80007810000ULL, 0x000000347035a210ULL, 0x000fe40007ffe06dULL,
0x0000000000347806ULL, 0x000fc600000e0100ULL, 0x01a4002c3500a388ULL, 0x0003e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x0000000400548947ULL, 0x002fea0003800000ULL,
0x000000852e2c7209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x000000852c2c7221ULL, 0x000fe20000010100ULL,
0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000034ff7812ULL, 0x000fe2000788c0ffULL,
0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL, 0x0000002c00357308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff2c7819ULL, 0x002fcc0000011609ULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x000000542c547220ULL, 0x042fe20000410000ULL,
0x000000552c557220ULL, 0x040fe20000410000ULL, 0x0000003c2c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2c3d7220ULL, 0x040fe20000410000ULL, 0x000000402c407220ULL, 0x040fe20000410000ULL,
0x000000412c417220ULL, 0x040fe20000410000ULL, 0x000000442c447220ULL, 0x040fe20000410000ULL,
0x000000452c457220ULL, 0x040fe20000410000ULL, 0x000000482c487220ULL, 0x040fe20000410000ULL,
0x000000492c497220ULL, 0x040fe20000410000ULL, 0x000000502c507220ULL, 0x040fe20000410000ULL,
0x000000512c517220ULL, 0x040fe20000410000ULL, 0x000000282c287220ULL, 0x040fe20000410000ULL,
0x000000292c297220ULL, 0x040fe20000410000ULL, 0x000000242c247220ULL, 0x040fe20000410000ULL,
0x000000252c257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000008092c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x000000562c567220ULL, 0x042fe20000410000ULL, 0x000000572c577220ULL, 0x040fe20000410000ULL,
0x0000003e2c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2c3f7220ULL, 0x040fe20000410000ULL,
0x000000422c427220ULL, 0x040fe20000410000ULL, 0x000000432c437220ULL, 0x040fe20000410000ULL,
0x000000462c467220ULL, 0x040fe20000410000ULL, 0x000000472c477220ULL, 0x040fe20000410000ULL,
0x0000004a2c4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2c4b7220ULL, 0x040fe20000410000ULL,
0x000000522c527220ULL, 0x040fe20000410000ULL, 0x000000532c537220ULL, 0x040fe20000410000ULL,
0x0000002a2c2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2c2b7220ULL, 0x040fe20000410000ULL,
0x000000262c267220ULL, 0x040fe20000410000ULL, 0x000000272c277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x00000010092c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x0000000c2c0c7220ULL, 0x042fe20000410000ULL,
0x0000000d2c0d7220ULL, 0x040fe20000410000ULL, 0x000000102c107220ULL, 0x040fe20000410000ULL,
0x000000112c117220ULL, 0x040fe20000410000ULL, 0x000000142c147220ULL, 0x040fe20000410000ULL,
0x000000152c157220ULL, 0x040fe20000410000ULL, 0x000000182c187220ULL, 0x040fe20000410000ULL,
0x000000192c197220ULL, 0x040fe20000410000ULL, 0x0000001c2c1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2c1d7220ULL, 0x040fe20000410000ULL, 0x000000202c207220ULL, 0x040fe20000410000ULL,
0x000000212c217220ULL, 0x040fe20000410000ULL, 0x000000302c307220ULL, 0x040fe20000410000ULL,
0x000000312c317220ULL, 0x040fe20000410000ULL, 0x000000382c387220ULL, 0x040fe20000410000ULL,
0x000000392c397220ULL, 0x000fce0000410000ULL, 0x0000003584847220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x00000018092c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x000e6400000e0000ULL, 0x0000000e2c0e7220ULL, 0x042fe20000410000ULL,
0x0000000f2c0f7220ULL, 0x040fe20000410000ULL, 0x000000122c127220ULL, 0x040fe20000410000ULL,
0x000000132c137220ULL, 0x040fe20000410000ULL, 0x000000162c167220ULL, 0x040fe20000410000ULL,
0x000000172c177220ULL, 0x040fe20000410000ULL, 0x0000001a2c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2c1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2c1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2c1f7220ULL, 0x040fe20000410000ULL, 0x000000222c227220ULL, 0x040fe20000410000ULL,
0x000000232c237220ULL, 0x040fe20000410000ULL, 0x000000322c327220ULL, 0x040fe20000410000ULL,
0x000000332c337220ULL, 0x040fe20000410000ULL, 0x0000003a2c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2c3b7220ULL, 0x000fce0000410000ULL, 0x000000342fff7212ULL, 0x000fe200078030ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x000000852e857209ULL, 0x000fd60007810000ULL,
0x800000852e2e0221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL, 0x0000002e00040308ULL, 0x000ea40000000800ULL,
0x000000042d2d0220ULL, 0x004fce0000410000ULL, 0x000000842d847221ULL, 0x000fe20000010000ULL,
0x00000000002c7805ULL, 0x002fe20000015200ULL, 0x00000008772e7824ULL, 0x000fca00078e00ffULL,
0xfffffff02e2f7812ULL, 0x000fca00078ec0ffULL, 0x0000000108377824ULL, 0x000fc800078e022fULL,
0x01a6b087370075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fcc0000015200ULL,
0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000352e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6b087370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009910342c7816ULL, 0x000fe200000000ffULL,
0x00000400772d7824ULL, 0x040fe400078e00ffULL, 0x00001000772e7824ULL, 0x000fe200078e00ffULL,
0x000000ff2c00720cULL, 0x000fe40003f05270ULL, 0xfffff0002d2d7812ULL, 0x000fe400078ec0ffULL,
0xffffe0002e2f7812ULL, 0x000fe400078ec0ffULL, 0x0001300008827810ULL, 0x000fc40007ffe02dULL,
0x00017000084c7810ULL, 0x000fc60007ffe02fULL, 0x000000107f347824ULL, 0x100fe400078e0282ULL,
0x000000107e2c7824ULL, 0x000fe400078e0282ULL, 0x000000106e5c7824ULL, 0x000fe200078e024cULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff2e7819ULL, 0x000fe40000011609ULL,
0x00000004ff00723eULL, 0x000fc600000010ffULL, 0x000000082e027836ULL, 0x000fe20000000000ULL,
0x00005410002d7816ULL, 0x000fe20000000000ULL, 0x000000102e367836ULL, 0x000fe40000000000ULL,
0x000000182e4e7836ULL, 0x000fe40000000000ULL, 0x00001f022d027589ULL, 0x0002a800000e0000ULL,
0x00001f362d057589ULL, 0x0002e800000e0000ULL, 0x00001f2e2d037589ULL, 0x00026800000e0000ULL,
0x00001f4e2d007589ULL, 0x00026400000e0000ULL, 0x000000003434783bULL, 0x002e680000000200ULL,
0x000000002c2c783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000235357232ULL, 0x084fe40000200000ULL, 0x0000000237377232ULL, 0x000fe40000200000ULL,
0x000000052c2c7232ULL, 0x088fe40000200000ULL, 0x000000052e2e7232ULL, 0x000fc40000200000ULL,
0x000000002d2d7232ULL, 0x080fe40000200000ULL, 0x000000002f2f7232ULL, 0x000fce0000200000ULL,
0x000000005c5c783bULL, 0x000f220000004200ULL, 0x00000010734c7824ULL, 0x000fcc00078e024cULL,
0x000000004c4c783bULL, 0x000f620000004200ULL, 0x00000018ff927819ULL, 0x010fe2000001145dULL,
0x000001005d657824ULL, 0x040fe200078e00ffULL, 0x000088805d957816ULL, 0x040fe200000000ffULL,
0x000001005c647824ULL, 0x000fe200078e00ffULL, 0x000000105d5d7819ULL, 0x000fe400000006ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001145fULL, 0x000001004d687824ULL, 0x028fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe2000001145dULL, 0x000001005e5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0000009200927306ULL, 0x000fe20000202400ULL,
0x00000018ff657819ULL, 0x000fc40000011465ULL, 0x00000018ff917819ULL, 0x000fe4000001145dULL,
0x000088805f5d7816ULL, 0x000fe400000000ffULL, 0x00000018ff667819ULL, 0x000fe2000001144cULL,
0x0000006400967306ULL, 0x0007e20000202400ULL, 0x000088805c7d7816ULL, 0x040fe400000000ffULL,
0x00000018ff937819ULL, 0x000fe2000001145cULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fc4000001145eULL, 0x00000018ff8e7819ULL, 0x000fe20000011468ULL,
0x0000006500987306ULL, 0x0009e20000202400ULL, 0x000001005f647824ULL, 0x048fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe2000001145cULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x000088805e5c7816ULL, 0x040fe200000000ffULL, 0x000100005e5e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe40000011464ULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x000001004c657824ULL, 0x050fe200078e00ffULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x0000005f00907306ULL, 0x0007e20000202400ULL,
0x00000018ff677819ULL, 0x000fc4000001144dULL, 0x00000018ff8b7819ULL, 0x000fe40000011465ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff6a7819ULL, 0x000fe2000001144eULL,
0x0000007d007d7306ULL, 0x000fe20000202400ULL, 0x000001004e5f7824ULL, 0x048fe200078e00ffULL,
0x000088804d657816ULL, 0x040fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x000088804e687816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fc4000001145fULL, 0x0000005d005d7306ULL, 0x000fe20000202400ULL,
0x00000018ff6b7819ULL, 0x000fe4000001144fULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x000088804f697816ULL, 0x000fe400000000ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000008c008c7306ULL, 0x000ee20000202400ULL, 0x00000018ff4e7819ULL, 0x000fce000001144eULL,
0x0000004c00877306ULL, 0x0009e20000202400ULL, 0x000054105d5d7816ULL, 0x008fce000000008cULL,
0x0000005f007b7306ULL, 0x0007e20000202400ULL, 0x000001004f4c7824ULL, 0x010fca00078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000009300937306ULL, 0x000fe20000202400ULL,
0x000100004f5f7824ULL, 0x008fca00078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x0000004c00867306ULL, 0x0007f00000202400ULL, 0x0000008f008f7306ULL, 0x000fe20000202400ULL,
0x000054107d4c7816ULL, 0x008fce0000000096ULL, 0x0000008d008d7306ULL, 0x000ff00000202400ULL,
0x0000006600667306ULL, 0x000ef00000202400ULL, 0x0000006700677306ULL, 0x000fe20000202400ULL,
0x0000541087667816ULL, 0x008fce0000000066ULL, 0x0000006a006a7306ULL, 0x000ff00000202400ULL,
0x0000006b006b7306ULL, 0x000ff00000202400ULL, 0x0000009500957306ULL, 0x000ff00000202400ULL,
0x0000009400947306ULL, 0x000ff00000202400ULL, 0x0000009700977306ULL, 0x000ef00000202400ULL,
0x0000005c005c7306ULL, 0x000fe20000202400ULL, 0x00005410974f7816ULL, 0x008fce0000000092ULL,
0x0000009100917306ULL, 0x000ef00000202400ULL, 0x0000005e005e7306ULL, 0x000f220000202400ULL,
0x000054105c5c7816ULL, 0x008fce0000000091ULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x0000005c3440723cULL, 0x002fe20000041840ULL, 0x000054105e5e7816ULL, 0x010fcc000000008fULL,
0x0000008b008b7306ULL, 0x000e620000202400ULL, 0x0000005c2c14723cULL, 0x000fee0000041814ULL,
0x0000006500657306ULL, 0x000fe20000202400ULL, 0x0000541064647816ULL, 0x002fce000000008bULL,
0x0000008e008e7306ULL, 0x000e700000202400ULL, 0x0000004d008a7306ULL, 0x0007220000202400ULL,
0x0000541065657816ULL, 0x002fce000000008eULL, 0x0000006800687306ULL, 0x000e620000202400ULL,
0x00005410954d7816ULL, 0x008fe20000000098ULL, 0x000000643448723cULL, 0x000fe20000041848ULL,
0x000054108a677816ULL, 0x010fca0000000067ULL, 0x0000006900697306ULL, 0x000ee20000202400ULL,
0x0000004c3454723cULL, 0x000fe20000041854ULL, 0x0000541068687816ULL, 0x002fcc000000007bULL,
0x0000004e007d7306ULL, 0x0003220000202400ULL, 0x00017000727b7836ULL, 0x000fe20000000000ULL,
0x000000663450723cULL, 0x000fe20000041850ULL, 0x0000541069697816ULL, 0x008fca0000000086ULL,
0x0000005f008c7306ULL, 0x0007620000202400ULL, 0x00005410944e7816ULL, 0x002fe20000000093ULL,
0x0000004c2c0c723cULL, 0x000fe2000004180cULL, 0x000054107d6a7816ULL, 0x010fca000000006aULL,
0x0000004e343c723cULL, 0x000fe2000004183cULL, 0x00005410905f7816ULL, 0x008fe2000000008dULL,
0x000000107c7d7824ULL, 0x000fc800078e027bULL, 0x000000683428723cULL, 0x000fe20000041828ULL,
0x000054108c6b7816ULL, 0x024fca000000006bULL, 0x0000005e3444723cULL, 0x000fec0000041844ULL,
0x0000006a3424723cULL, 0x000fec0000041824ULL, 0x0000004e2c10723cULL, 0x000fe20000041810ULL,
0x000000106f347824ULL, 0x000fc400078e0282ULL, 0x0000001071827824ULL, 0x000fc600078e0282ULL,
0x0000005e2c18723cULL, 0x000fe20000041818ULL, 0x000000003434783bULL, 0x000e6a0000000200ULL,
0x000000642c1c723cULL, 0x000fec000004181cULL, 0x000000662c20723cULL, 0x000fec0000041820ULL,
0x000000682c30723cULL, 0x000fec0000041830ULL, 0x0000006a2c38723cULL, 0x000fe20000041838ULL,
0x00000000822c783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x082fe40000200000ULL,
0x0000000336367232ULL, 0x000fe40000200000ULL, 0x0000000235357232ULL, 0x080fe40000200000ULL,
0x0000000237377232ULL, 0x000fe40000200000ULL, 0x000000052c2c7232ULL, 0x088fe40000200000ULL,
0x000000052e2e7232ULL, 0x000fc40000200000ULL, 0x000000002d2d7232ULL, 0x080fe40000200000ULL,
0x000000002f2f7232ULL, 0x000fce0000200000ULL, 0x000000007d5c783bULL, 0x000f220000004200ULL,
0x000000107a4c7824ULL, 0x000fcc00078e027bULL, 0x000000004c4c783bULL, 0x000f620000004200ULL,
0x000001005c647824ULL, 0x010fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe2000001145dULL,
0x000001005d657824ULL, 0x040fe200078e00ffULL, 0x000088805d947816ULL, 0x040fe200000000ffULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x000001004d697824ULL, 0x024fe200078e00ffULL,
0x0000006400967306ULL, 0x0005e20000202400ULL, 0x00000018ff927819ULL, 0x000fe2000001145cULL,
0x000001004c687824ULL, 0x000fe200078e00ffULL, 0x000088805c8b7816ULL, 0x040fe200000000ffULL,
0x000100005c5c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff977819ULL, 0x000fe2000001145dULL,
0x000001005e5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe2000001145eULL,
0x0000006500997306ULL, 0x0009e20000202400ULL, 0x000001005f647824ULL, 0x004fe200078e00ffULL,
0x00000018ff957819ULL, 0x000fe2000001145cULL, 0x000001004e827824ULL, 0x000fe200078e00ffULL,
0x000088805e5c7816ULL, 0x000fc400000000ffULL, 0x00000018ff677819ULL, 0x000fe4000001144dULL,
0x0000009400947306ULL, 0x000ea20000202400ULL, 0x00000018ff657819ULL, 0x010fe20000011464ULL,
0x000100005e647824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe4000001144cULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000018ff917819ULL, 0x000fe20000011464ULL,
0x00000065005e7306ULL, 0x0009e20000202400ULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fc4000001145dULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000008a008a7306ULL, 0x000fe20000202400ULL, 0x000088804d657816ULL, 0x050fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001145fULL,
0x000088805f5d7816ULL, 0x040fe200000000ffULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000009700977306ULL, 0x000f220000202400ULL,
0x00000018ff6a7819ULL, 0x000fc4000001144eULL, 0x00000018ff6b7819ULL, 0x000fe4000001144fULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x00000018ff877819ULL, 0x000fe20000011482ULL,
0x0000008b008b7306ULL, 0x000f700000202400ULL, 0x0000004d00867306ULL, 0x0005f00000202400ULL,
0x0000004c008d7306ULL, 0x0009e20000202400ULL, 0x00005410944d7816ULL, 0x004fe20000000099ULL,
0x000100004f947824ULL, 0x000fcc00078e00ffULL, 0x00000068008f7306ULL, 0x0005e20000202400ULL,
0x000001004f4c7824ULL, 0x012fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000069008c7306ULL, 0x0003e20000202400ULL, 0x000088804e687816ULL, 0x044fe200000000ffULL,
0x000100004e4e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000004c00827306ULL, 0x000be20000202400ULL, 0x000088804f697816ULL, 0x002fe400000000ffULL,
0x00005410974f7816ULL, 0x000fe4000000008aULL, 0x00000018ff8a7819ULL, 0x000fc60000011494ULL,
0x0000005d005d7306ULL, 0x000e620000202400ULL, 0x000054108b4c7816ULL, 0x028fce0000000096ULL,
0x0000009200927306ULL, 0x000fe20000202400ULL, 0x0000004c3454723cULL, 0x000fe20000041854ULL,
0x000054105d5d7816ULL, 0x002fcc000000005eULL, 0x0000009000907306ULL, 0x000fe20000202400ULL,
0x0000004c2c0c723cULL, 0x000fee000004180cULL, 0x0000008e008e7306ULL, 0x000ff00000202400ULL,
0x0000006600667306ULL, 0x000e700000202400ULL, 0x0000006700677306ULL, 0x000ea20000202400ULL,
0x000054108d667816ULL, 0x002fce0000000066ULL, 0x0000006a006a7306ULL, 0x000fe20000202400ULL,
0x0000541086677816ULL, 0x004fce0000000067ULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x000000663450723cULL, 0x000fee0000041850ULL, 0x0000009500957306ULL, 0x000fe20000202400ULL,
0x000000662c20723cULL, 0x000fee0000041820ULL, 0x0000005c005c7306ULL, 0x000ff00000202400ULL,
0x0000009300937306ULL, 0x000e700000202400ULL, 0x0000009100917306ULL, 0x000ea20000202400ULL,
0x000054105c5c7816ULL, 0x002fce0000000093ULL, 0x0000005f005f7306ULL, 0x000e620000202400ULL,
0x0000005c3440723cULL, 0x000fe20000041840ULL, 0x00005410915e7816ULL, 0x004fcc0000000090ULL,
0x0000006400647306ULL, 0x000ea20000202400ULL, 0x0000005c2c14723cULL, 0x000fe20000041814ULL,
0x000054105f5f7816ULL, 0x002fcc000000008eULL, 0x0000006500657306ULL, 0x000e620000202400ULL,
0x0000005e3444723cULL, 0x000fe20000041844ULL, 0x0000541064647816ULL, 0x004fcc000000008fULL,
0x0000006800687306ULL, 0x000fe20000202400ULL, 0x0000005e2c18723cULL, 0x000fe20000041818ULL,
0x0000541065657816ULL, 0x002fcc000000008cULL, 0x0000008700877306ULL, 0x000e620000202400ULL,
0x000000643448723cULL, 0x000fee0000041848ULL, 0x0000006900697306ULL, 0x000ea20000202400ULL,
0x000000642c1c723cULL, 0x000fe2000004181cULL, 0x0000541068687816ULL, 0x002fcc0000000087ULL,
0x0000004e008b7306ULL, 0x0002e20000202400ULL, 0x0000541069697816ULL, 0x004fce0000000082ULL,
0x0000008a008a7306ULL, 0x000ea20000202400ULL, 0x00005410954e7816ULL, 0x002fe20000000092ULL,
0x000000683428723cULL, 0x000fe20000041828ULL, 0x000054108b6a7816ULL, 0x008fca000000006aULL,
0x0000004e343c723cULL, 0x000fe2000004183cULL, 0x000054108a6b7816ULL, 0x004fca000000006bULL,
0x0000004e2c10723cULL, 0x000fec0000041810ULL, 0x0000006a3424723cULL, 0x000fec0000041824ULL,
0x000000682c30723cULL, 0x000fe20000041830ULL, 0x0000000277347824ULL, 0x000fe200078e00ffULL,
0x0000000100377802ULL, 0x000fc80000000f00ULL, 0xfffffff834357812ULL, 0x000fe200078ec0ffULL,
0x0000000863347824ULL, 0x000fe200078e0208ULL, 0x0000006a2c38723cULL, 0x000fe60000041838ULL,
0x0000000108367824ULL, 0x000fe400078e0235ULL, 0x01a6c837343479a7ULL, 0x0002a4000850003fULL,
0x01a6903736ff79a7ULL, 0x0003de000850003fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x00000035060075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff367224ULL, 0x002fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000010058827824ULL, 0x000fc800078e0261ULL, 0x000000c0822f7836ULL, 0x000fca0000000000ULL,
0x000000602f2d7812ULL, 0x000fca00078ec0ffULL, 0x000000015a357824ULL, 0x000fe200078e022dULL,
0x0000000400049947ULL, 0x000fec0003800000ULL, 0x0000002f742c7248ULL, 0x000fe20007fe0000ULL,
0x00000010772d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff347819ULL, 0x000fc60000011609ULL,
0x000000012c2c7824ULL, 0x000fe200078e0a2fULL, 0x000000102d2d7812ULL, 0x000fe200078ec0ffULL,
0x00009000ff2e7b82ULL, 0x000ea20000000a00ULL, 0x0000000434367836ULL, 0x002fe40000000000ULL,
0x0000002c2d2c7248ULL, 0x000fe20007fe0000ULL, 0x0000000834377836ULL, 0x000fe40000000000ULL,
0x0000000c344c7836ULL, 0x000fe40000000000ULL, 0x000000012c2c7824ULL, 0x000fc400078e0a2dULL,
0x00000001375e7824ULL, 0x140fe400078e022dULL, 0x00000001364e7824ULL, 0x100fe200078e022dULL,
0x0000002c3400720cULL, 0x0c0fe20003f86070ULL, 0x0000000134347824ULL, 0x100fe200078e022dULL,
0x0000002c3600720cULL, 0x080fe20003f66070ULL, 0x000000014c647824ULL, 0x000fe200078e022dULL,
0x0000002c3700720cULL, 0x080fe20003f46070ULL, 0x0000000834377824ULL, 0x000fe200078e00ffULL,
0x0000002c4c00720cULL, 0x000fe20003f06070ULL, 0x00000001342c7824ULL, 0x000fc400078e0209ULL,
0x0000000134367824ULL, 0x000fe400078e0235ULL, 0x000000015e347824ULL, 0x140fe200078e0209ULL,
0xfffffff8374c7812ULL, 0x000fe200078ee22cULL, 0x000000085e4d7824ULL, 0x000fe400078e00ffULL,
0x000000014e2d7824ULL, 0x040fe400078e0209ULL, 0x000000084e5c7824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee22dULL,
0x000000014e2c7824ULL, 0x100fe200078e0235ULL, 0xfffffff84d4e7812ULL, 0x000fe200078ee234ULL,
0x0000000164347824ULL, 0x100fe200078e0235ULL, 0x0000002e814d7211ULL, 0x044fe200078a38ffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000006d36367212ULL, 0x000fe400078efcffULL,
0x0000002f81817211ULL, 0x000fe200028f3cffULL, 0x000000015e2e7824ULL, 0x000fe200078e0235ULL,
0x0000004d36367210ULL, 0x000fe20007fbe0ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000006d2c2c7212ULL, 0x000fc600078efcffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000006d34347212ULL, 0x000fc600078efcffULL, 0x0000000137377824ULL, 0x000fe200028e0681ULL,
0x0000004d2c2c7210ULL, 0x000fe20007fbe0ffULL, 0x00000001644f7824ULL, 0x000fe200078e0209ULL,
0x0000006d2e2e7212ULL, 0x000fe200078efcffULL, 0x00000008645e7824ULL, 0x000fe200078e00ffULL,
0x0000004d34347210ULL, 0x000fe20007fde0ffULL, 0x000000012d2d7824ULL, 0x000fe200028e0681ULL,
0x0000004d2e2e7210ULL, 0x000fe20007fbe0ffULL, 0x000000104c4d7824ULL, 0x100fe200078e027bULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee24fULL, 0x000000104e5d7824ULL, 0x000fe200078e027bULL,
0x0000007b5c4f7211ULL, 0x000fe200078e20ffULL, 0x000000012f2f7824ULL, 0x100fe200028e0681ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000364d7faeULL, 0x0003e2000e101c46ULL,
0x0000000135357824ULL, 0x000fc400030e0681ULL, 0x000000105e5f7824ULL, 0x000fe200078e027bULL,
0x000000002c4f7faeULL, 0x0003e8000d901c46ULL, 0x000000002e5d7faeULL, 0x0003e8000d101c46ULL,
0x00000000345f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000d07947ULL, 0x000fea0003800000ULL,
0x00000010772c7824ULL, 0x000fca00078e00ffULL, 0x000000102c2c7812ULL, 0x000fc800078ec0ffULL,
0x0000002c092e7211ULL, 0x000fe400078fe8ffULL, 0x00009000ff2c7b82ULL, 0x000ea60000000a00ULL,
0x000000012e2f7824ULL, 0x040fe400078e0209ULL, 0x000000082e4e7824ULL, 0x000fe400078e00ffULL,
0x000000042e347836ULL, 0x000fe40000000000ULL, 0x000000082e5c7836ULL, 0x000fe20000000000ULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee22fULL, 0x0000000c2e5e7836ULL, 0x000fc40000000000ULL,
0x000000012e4c7824ULL, 0x100fe400078e0235ULL, 0x00000001342e7824ULL, 0x040fe400078e0235ULL,
0x00000001342f7824ULL, 0x040fe400078e0209ULL, 0x0000000834647824ULL, 0x000fe400078e00ffULL,
0x000000015c347824ULL, 0x100fe400078e0235ULL, 0x000000015e367824ULL, 0x002fe200078e0235ULL,
0x0000002c814f7211ULL, 0x004fe200078038ffULL, 0x000000015c357824ULL, 0x000fc400078e0209ULL,
0x000000085c667824ULL, 0x000fe200078e00ffULL, 0xfffffff8645c7812ULL, 0x000fe200078ee22fULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x0000002d81817211ULL, 0x000fc600000f3cffULL,
0x000000015e377824ULL, 0x000fe200078e0209ULL, 0x0000006d4c2c7212ULL, 0x080fe200078efcffULL,
0x000000085e687824ULL, 0x000fe200078e00ffULL, 0xfffffff8665e7812ULL, 0x000fe200078ee235ULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000004f2c2c7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff868647812ULL, 0x000fe200078ee237ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000006d2e2e7212ULL, 0x000fc600078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000006d34347212ULL, 0x080fe400078efcffULL, 0x0000004f2e2e7210ULL, 0x000fe20007f5e0ffULL,
0x000000014d2d7824ULL, 0x000fe200000e0681ULL, 0x0000006d36367212ULL, 0x000fe200078efcffULL,
0x000000104e4d7824ULL, 0x000fe200078e027bULL, 0x0000004f34347210ULL, 0x000fe20007f1e0ffULL,
0x000000012f2f7824ULL, 0x000fe200010e0681ULL, 0x0000004f36367210ULL, 0x000fe20007f7e0ffULL,
0x000000105c4f7824ULL, 0x000fe200078e027bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c4d7faeULL, 0x0003e2000b901c46ULL, 0x0000000135357824ULL, 0x000fc400000e0681ULL,
0x000000105e5d7824ULL, 0x000fe200078e027bULL, 0x000000002e4f7faeULL, 0x0003e2000b901c46ULL,
0x0000000137377824ULL, 0x000fe400018e0681ULL, 0x00000010645f7824ULL, 0x000fe200078e027bULL,
0x00000000345d7faeULL, 0x0003e8000b901c46ULL, 0x00000000365f7faeULL, 0x0003e4000b901c46ULL,
0x0000000260607836ULL, 0x000fe20000000000ULL, 0x0000000804087890ULL, 0x000fe2000fffe03fULL,
0xffffffffff817424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x000000756000720cULL, 0x000fca0003f06070ULL, 0x00000000ff0079b0ULL, 0x000ff00008000a48ULL,
0x00009200ff2c8b82ULL, 0x000e620000000a00ULL, 0x00000001602f8824ULL, 0x000fe400078e0207ULL,
0x00000008772e7824ULL, 0x000fc400078e00ffULL, 0x000000042f2c8825ULL, 0x002fca00078e002cULL,
0x000000062c818981ULL, 0x000322000c1e1900ULL, 0xfffffff02e2f7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff357424ULL, 0x000fc600078e00ffULL, 0x0001a6a82f867810ULL, 0x000fe20007ffe008ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000835868679a7ULL, 0x0004e2000850003fULL,
0x01a64835802c79a7ULL, 0x002464000850003fULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x01a6482d800075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x004fce0000015200ULL,
0x000000342e377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e2fULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6482d800075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000005772c7819ULL, 0x000fe200000006ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0xffffff802c2d7812ULL, 0x000fc800078ec0ffULL,
0x00000100082c7810ULL, 0x000fc80007ffe02dULL, 0x0000002c702c7210ULL, 0x000fca0007ffe06dULL,
0x01a000002c2e7984ULL, 0x000e680000000800ULL, 0x01a200002c2d7984ULL, 0x000b620000000800ULL,
0x000000852e00720bULL, 0x002fda0003f1d000ULL, 0x00000000002f7806ULL, 0x000fc800000e0100ULL,
0x000000ff2f00720cULL, 0x000fda0003f05270ULL, 0x00000004009c8947ULL, 0x02cfea0003800000ULL,
0x000000025b2c7836ULL, 0x000fe20000000000ULL, 0x000000852e00720bULL, 0x000fc80003f14000ULL,
0x000000772c00720cULL, 0x000fda0003f45270ULL, 0x000000807734a824ULL, 0x000fe200078e0208ULL,
0x000000852e2ca209ULL, 0x000fc80007810000ULL, 0x000000347035a210ULL, 0x000fe40007ffe06dULL,
0x0000000000347806ULL, 0x000fc600000e0100ULL, 0x01a4002c3500a388ULL, 0x0003e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x0000000400548947ULL, 0x002fea0003800000ULL,
0x000000852e2c7209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x000000852c2c7221ULL, 0x000fe20000010100ULL,
0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000034ff7812ULL, 0x000fe2000788c0ffULL,
0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL, 0x0000002c00357308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff2c7819ULL, 0x002fcc0000011609ULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x000000542c547220ULL, 0x042fe20000410000ULL,
0x000000552c557220ULL, 0x040fe20000410000ULL, 0x0000003c2c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2c3d7220ULL, 0x040fe20000410000ULL, 0x000000402c407220ULL, 0x040fe20000410000ULL,
0x000000412c417220ULL, 0x040fe20000410000ULL, 0x000000442c447220ULL, 0x040fe20000410000ULL,
0x000000452c457220ULL, 0x040fe20000410000ULL, 0x000000482c487220ULL, 0x040fe20000410000ULL,
0x000000492c497220ULL, 0x040fe20000410000ULL, 0x000000502c507220ULL, 0x040fe20000410000ULL,
0x000000512c517220ULL, 0x040fe20000410000ULL, 0x000000282c287220ULL, 0x040fe20000410000ULL,
0x000000292c297220ULL, 0x040fe20000410000ULL, 0x000000242c247220ULL, 0x040fe20000410000ULL,
0x000000252c257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000008092c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x000000562c567220ULL, 0x042fe20000410000ULL, 0x000000572c577220ULL, 0x040fe20000410000ULL,
0x0000003e2c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2c3f7220ULL, 0x040fe20000410000ULL,
0x000000422c427220ULL, 0x040fe20000410000ULL, 0x000000432c437220ULL, 0x040fe20000410000ULL,
0x000000462c467220ULL, 0x040fe20000410000ULL, 0x000000472c477220ULL, 0x040fe20000410000ULL,
0x0000004a2c4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2c4b7220ULL, 0x040fe20000410000ULL,
0x000000522c527220ULL, 0x040fe20000410000ULL, 0x000000532c537220ULL, 0x040fe20000410000ULL,
0x0000002a2c2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2c2b7220ULL, 0x040fe20000410000ULL,
0x000000262c267220ULL, 0x040fe20000410000ULL, 0x000000272c277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x00000010092c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x0000000c2c0c7220ULL, 0x042fe20000410000ULL,
0x0000000d2c0d7220ULL, 0x040fe20000410000ULL, 0x000000102c107220ULL, 0x040fe20000410000ULL,
0x000000112c117220ULL, 0x040fe20000410000ULL, 0x000000142c147220ULL, 0x040fe20000410000ULL,
0x000000152c157220ULL, 0x040fe20000410000ULL, 0x000000182c187220ULL, 0x040fe20000410000ULL,
0x000000192c197220ULL, 0x040fe20000410000ULL, 0x0000001c2c1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2c1d7220ULL, 0x040fe20000410000ULL, 0x000000202c207220ULL, 0x040fe20000410000ULL,
0x000000212c217220ULL, 0x040fe20000410000ULL, 0x000000302c307220ULL, 0x040fe20000410000ULL,
0x000000312c317220ULL, 0x040fe20000410000ULL, 0x000000382c387220ULL, 0x040fe20000410000ULL,
0x000000392c397220ULL, 0x000fce0000410000ULL, 0x0000003584847220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x00000018092c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x000e6400000e0000ULL, 0x0000000e2c0e7220ULL, 0x042fe20000410000ULL,
0x0000000f2c0f7220ULL, 0x040fe20000410000ULL, 0x000000122c127220ULL, 0x040fe20000410000ULL,
0x000000132c137220ULL, 0x040fe20000410000ULL, 0x000000162c167220ULL, 0x040fe20000410000ULL,
0x000000172c177220ULL, 0x040fe20000410000ULL, 0x0000001a2c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2c1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2c1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2c1f7220ULL, 0x040fe20000410000ULL, 0x000000222c227220ULL, 0x040fe20000410000ULL,
0x000000232c237220ULL, 0x040fe20000410000ULL, 0x000000322c327220ULL, 0x040fe20000410000ULL,
0x000000332c337220ULL, 0x040fe20000410000ULL, 0x0000003a2c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2c3b7220ULL, 0x000fce0000410000ULL, 0x000000342fff7212ULL, 0x000fe200078030ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x000000852e857209ULL, 0x000fd60007810000ULL,
0x800000852e2e0221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL, 0x0000002e00040308ULL, 0x000ea40000000800ULL,
0x000000042d2d0220ULL, 0x004fce0000410000ULL, 0x000000842d847221ULL, 0x000fce0000010000ULL,
0x00000000002c7805ULL, 0x002fce0000015200ULL, 0x00000089ff0075a7ULL, 0x000e640008000145ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000089ff0075a7ULL, 0x000e640008000145ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009910342c7816ULL, 0x000fe200000000ffULL, 0x00000400772d7824ULL, 0x000fe400078e00ffULL,
0x000000106e5c7824ULL, 0x000fe200078e0283ULL, 0x000000ff2c00720cULL, 0x000fe40003f05270ULL,
0xfffff0002d2d7812ULL, 0x000fc800078ec0ffULL, 0x0001400008807810ULL, 0x000fca0007ffe02dULL,
0x000000107f347824ULL, 0x100fe400078e0280ULL, 0x000000107e2c7824ULL, 0x000fe200078e0280ULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff2e7819ULL, 0x000fe40000011609ULL,
0x00000004ff00723eULL, 0x000fc600000010ffULL, 0x000000082e027836ULL, 0x000fe20000000000ULL,
0x00005410002d7816ULL, 0x000fe20000000000ULL, 0x000000102e367836ULL, 0x000fe40000000000ULL,
0x000000182e4c7836ULL, 0x000fe40000000000ULL, 0x00001f022d027589ULL, 0x0002a800000e0000ULL,
0x00001f362d057589ULL, 0x0002e800000e0000ULL, 0x00001f2e2d037589ULL, 0x00026800000e0000ULL,
0x00001f4c2d007589ULL, 0x00026400000e0000ULL, 0x000000003434783bULL, 0x002e680000000200ULL,
0x000000002c2c783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000235357232ULL, 0x084fe40000200000ULL, 0x0000000237377232ULL, 0x000fe40000200000ULL,
0x000000052c2c7232ULL, 0x088fe40000200000ULL, 0x000000052e2e7232ULL, 0x000fc40000200000ULL,
0x000000002d2d7232ULL, 0x080fe40000200000ULL, 0x000000002f2f7232ULL, 0x000fce0000200000ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x00000010734c7824ULL, 0x000fcc00078e0283ULL,
0x000000004c4c783bULL, 0x000f640000004200ULL, 0x00000018ff8a7819ULL, 0x028fe2000001145dULL,
0x000001005d657824ULL, 0x040fe200078e00ffULL, 0x000088805d937816ULL, 0x040fe200000000ffULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe2000001145fULL,
0x000001005c647824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000008a008a7306ULL, 0x000fe20000202400ULL, 0x00000018ff957819ULL, 0x000fe2000001145dULL,
0x000001005e5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x000001004d687824ULL, 0x004fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fc4000001144cULL,
0x00000018ff917819ULL, 0x000fe2000001145dULL, 0x0000006400947306ULL, 0x0005e20000202400ULL,
0x000088805f5d7816ULL, 0x040fe400000000ffULL, 0x000088805c7f7816ULL, 0x040fe400000000ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001145cULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001145eULL, 0x0000006500967306ULL, 0x0007e20000202400ULL,
0x000001005f647824ULL, 0x044fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe20000011468ULL,
0x000100005f5f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fc4000001145cULL,
0x00000018ff907819ULL, 0x000fe40000011464ULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x000001004c657824ULL, 0x048fe200078e00ffULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x0000005f008e7306ULL, 0x0005e20000202400ULL,
0x000088805e5c7816ULL, 0x040fe200000000ffULL, 0x000100005e5e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe40000011465ULL, 0x00000018ff4c7819ULL, 0x000fc4000001144cULL,
0x00000018ff677819ULL, 0x000fe2000001144dULL, 0x0000007f007f7306ULL, 0x000fe20000202400ULL,
0x000001004e5f7824ULL, 0x044fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001144eULL,
0x000088804d657816ULL, 0x040fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000009500957306ULL, 0x000ea20000202400ULL,
0x000088804e687816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fc4000001144fULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x000088804f697816ULL, 0x000fe200000000ffULL, 0x0000004c00837306ULL, 0x0007e20000202400ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff4e7819ULL, 0x000fca000001144eULL,
0x0000005f00737306ULL, 0x000be20000202400ULL, 0x000001004f4c7824ULL, 0x008fca00078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000008f008f7306ULL, 0x000fe20000202400ULL,
0x000100004f5f7824ULL, 0x022fe200078e00ffULL, 0x00005410954f7816ULL, 0x004fc8000000008aULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000004c007e7306ULL, 0x0003f00000202400ULL,
0x0000008d008d7306ULL, 0x000fe20000202400ULL, 0x000054107f4c7816ULL, 0x002fce0000000094ULL,
0x0000008b008b7306ULL, 0x000ff00000202400ULL, 0x0000006600667306ULL, 0x000e700000202400ULL,
0x0000006700677306ULL, 0x000fe20000202400ULL, 0x0000541083667816ULL, 0x002fce0000000066ULL,
0x0000006a006a7306ULL, 0x000ff00000202400ULL, 0x0000006b006b7306ULL, 0x000ff00000202400ULL,
0x0000009300937306ULL, 0x000ff00000202400ULL, 0x0000009200927306ULL, 0x000ff00000202400ULL,
0x0000005c005c7306ULL, 0x000ff00000202400ULL, 0x0000009100917306ULL, 0x000e700000202400ULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x000054105c5c7816ULL, 0x002fce0000000091ULL,
0x0000009000907306ULL, 0x000e700000202400ULL, 0x0000005e005e7306ULL, 0x000ea20000202400ULL,
0x000054105d5d7816ULL, 0x002fce0000000090ULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x0000005c3440723cULL, 0x000fe20000041840ULL, 0x000054105e5e7816ULL, 0x004fcc000000008dULL,
0x0000008900897306ULL, 0x000e620000202400ULL, 0x0000005c2c14723cULL, 0x000fee0000041814ULL,
0x0000006500657306ULL, 0x000fe20000202400ULL, 0x0000541064647816ULL, 0x002fce0000000089ULL,
0x0000008c008c7306ULL, 0x000e700000202400ULL, 0x0000004d00887306ULL, 0x0004e20000202400ULL,
0x0000541065657816ULL, 0x002fce000000008cULL, 0x0000006800687306ULL, 0x000e620000202400ULL,
0x00005410934d7816ULL, 0x004fe20000000096ULL, 0x000000643448723cULL, 0x000fe20000041848ULL,
0x0000541088677816ULL, 0x008fca0000000067ULL, 0x0000006900697306ULL, 0x000ea20000202400ULL,
0x0000004c3454723cULL, 0x000fe20000041854ULL, 0x0000541068687816ULL, 0x002fcc0000000073ULL,
0x0000004e007f7306ULL, 0x0002e20000202400ULL, 0x0001600072737836ULL, 0x000fe20000000000ULL,
0x000000663450723cULL, 0x000fe80000041850ULL, 0x000000737c5c7211ULL, 0x000fe400078e20ffULL,
0x0000005f008a7306ULL, 0x000b620000202400ULL, 0x00005410924e7816ULL, 0x002fe2000000008fULL,
0x0000004c2c0c723cULL, 0x000fe2000004180cULL, 0x0000541069697816ULL, 0x004fc4000000007eULL,
0x000054107f6a7816ULL, 0x008fc6000000006aULL, 0x0000004e343c723cULL, 0x000fe2000004183cULL,
0x000054108e5f7816ULL, 0x020fca000000008bULL, 0x000000683428723cULL, 0x000fe20000041828ULL,
0x000054108a6b7816ULL, 0x000fca000000006bULL, 0x0000005e3444723cULL, 0x000fec0000041844ULL,
0x0000006a3424723cULL, 0x000fec0000041824ULL, 0x0000004e2c10723cULL, 0x000fe20000041810ULL,
0x000000106f347824ULL, 0x000fc400078e0280ULL, 0x0000001071807824ULL, 0x000fc600078e0280ULL,
0x0000005e2c18723cULL, 0x000fe20000041818ULL, 0x000000003434783bULL, 0x000e6a0000000200ULL,
0x000000642c1c723cULL, 0x000fec000004181cULL, 0x000000662c20723cULL, 0x000fec0000041820ULL,
0x000000682c30723cULL, 0x000fec0000041830ULL, 0x0000006a2c38723cULL, 0x000fe20000041838ULL,
0x00000000802c783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x082fe40000200000ULL,
0x0000000336367232ULL, 0x000fe40000200000ULL, 0x0000000235357232ULL, 0x080fe40000200000ULL,
0x0000000237377232ULL, 0x000fe40000200000ULL, 0x000000052c2c7232ULL, 0x088fe40000200000ULL,
0x000000052e2e7232ULL, 0x000fc40000200000ULL, 0x000000002d2d7232ULL, 0x080fe40000200000ULL,
0x000000002f2f7232ULL, 0x000fce0000200000ULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x000000107a4c7824ULL, 0x000fcc00078e0273ULL, 0x000000004c4c783bULL, 0x000f640000004200ULL,
0x000001005c647824ULL, 0x064fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe2000001145cULL,
0x000001005d657824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe4000001145dULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x000001004d697824ULL, 0x008fe200078e00ffULL, 0x0000006400917306ULL, 0x0005e20000202400ULL,
0x000088805c7a7816ULL, 0x040fe200000000ffULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x000088805d8c7816ULL, 0x040fe200000000ffULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe2000001145eULL, 0x000001004c687824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001145cULL, 0x0000006500977306ULL, 0x0007e20000202400ULL,
0x000001005f647824ULL, 0x004fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe2000001145dULL,
0x000001005e5d7824ULL, 0x040fe200078e00ffULL, 0x000088805e5c7816ULL, 0x000fe200000000ffULL,
0x000001004e7f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fc4000001144dULL,
0x0000007a007a7306ULL, 0x000ea20000202400ULL, 0x00000018ff657819ULL, 0x008fe20000011464ULL,
0x000100005e647824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe4000001144cULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000018ff937819ULL, 0x000fe20000011464ULL,
0x00000065005e7306ULL, 0x0007e20000202400ULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fc4000001145dULL,
0x00000018ff7e7819ULL, 0x000fe4000001145fULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000008c008c7306ULL, 0x000f620000202400ULL, 0x000088804d657816ULL, 0x048fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x000088805f5d7816ULL, 0x040fe200000000ffULL,
0x000100005f5f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000004c00897306ULL, 0x0005e20000202400ULL,
0x00000018ff6a7819ULL, 0x000fc4000001144eULL, 0x00000018ff6b7819ULL, 0x000fe4000001144fULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x00000018ff837819ULL, 0x000fe2000001147fULL,
0x0000004d00727306ULL, 0x0007e20000202400ULL, 0x000054107a4c7816ULL, 0x004fce0000000091ULL,
0x00000068008b7306ULL, 0x0005e20000202400ULL, 0x000001004f4d7824ULL, 0x008fca00078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001144dULL, 0x000054108c4d7816ULL, 0x022fe20000000097ULL,
0x000100004f8c7824ULL, 0x000fe200078e00ffULL, 0x000088804e687816ULL, 0x044fe200000000ffULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000069007c7306ULL, 0x0003e40000202400ULL,
0x00000018ff8c7819ULL, 0x000fe2000001148cULL, 0x0000004c3454723cULL, 0x000fe20000041854ULL,
0x00000018ff4e7819ULL, 0x000fc8000001144eULL, 0x0000005d005d7306ULL, 0x000ea20000202400ULL,
0x000088804f697816ULL, 0x002fe200000000ffULL, 0x0000004c2c0c723cULL, 0x000fec000004180cULL,
0x0000008a008a7306ULL, 0x000fe20000202400ULL, 0x000054105d5d7816ULL, 0x004fce000000005eULL,
0x0000008800887306ULL, 0x000ff00000202400ULL, 0x0000008000807306ULL, 0x000ff00000202400ULL,
0x0000007e007e7306ULL, 0x000ff00000202400ULL, 0x0000006600667306ULL, 0x000e700000202400ULL,
0x0000006700677306ULL, 0x000ea20000202400ULL, 0x0000541089667816ULL, 0x002fce0000000066ULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x0000541072677816ULL, 0x004fce0000000067ULL,
0x0000006b006b7306ULL, 0x000fe20000202400ULL, 0x000000663450723cULL, 0x000fee0000041850ULL,
0x0000008f008f7306ULL, 0x000fe20000202400ULL, 0x000000662c20723cULL, 0x000fee0000041820ULL,
0x0000009500957306ULL, 0x000e700000202400ULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x00005410954f7816ULL, 0x002fce0000000088ULL, 0x0000008d008d7306ULL, 0x000e700000202400ULL,
0x0000009300937306ULL, 0x000ea20000202400ULL, 0x000054105c5c7816ULL, 0x002fce000000008dULL,
0x0000005f005f7306ULL, 0x000e620000202400ULL, 0x0000005c3440723cULL, 0x000fe20000041840ULL,
0x00005410935e7816ULL, 0x004fcc0000000080ULL, 0x0000006400647306ULL, 0x000ea20000202400ULL,
0x0000005c2c14723cULL, 0x000fe20000041814ULL, 0x000054105f5f7816ULL, 0x002fcc000000007eULL,
0x0000006500657306ULL, 0x000e620000202400ULL, 0x0000005e3444723cULL, 0x000fe20000041844ULL,
0x0000541064647816ULL, 0x004fcc000000008bULL, 0x0000006800687306ULL, 0x000fe20000202400ULL,
0x0000005e2c18723cULL, 0x000fe20000041818ULL, 0x0000541065657816ULL, 0x002fcc000000007cULL,
0x0000008300837306ULL, 0x000e620000202400ULL, 0x000000643448723cULL, 0x000fee0000041848ULL,
0x0000004e007f7306ULL, 0x0004e20000202400ULL, 0x000000642c1c723cULL, 0x000fe2000004181cULL,
0x0000541068687816ULL, 0x002fcc0000000083ULL, 0x0000006900697306ULL, 0x000fe20000202400ULL,
0x000054108f4e7816ULL, 0x004fe4000000008aULL, 0x000054107f6a7816ULL, 0x008fca000000006aULL,
0x0000007a007a7306ULL, 0x000e620000202400ULL, 0x0000004e343c723cULL, 0x000fec000004183cULL,
0x0000004e2c10723cULL, 0x000fe20000041810ULL, 0x0000008c008c7306ULL, 0x000ea20000202400ULL,
0x0000541069697816ULL, 0x002fce000000007aULL, 0x000000683428723cULL, 0x000fe20000041828ULL,
0x000054108c6b7816ULL, 0x004fca000000006bULL, 0x000000682c30723cULL, 0x000fec0000041830ULL,
0x0000006a3424723cULL, 0x000fec0000041824ULL, 0x0000006a2c38723cULL, 0x000fe20000041838ULL,
0x0000000277347824ULL, 0x000fc400078e00ffULL, 0x00000001ff377424ULL, 0x000fc600078e00ffULL,
0xfffffff834357812ULL, 0x000fca00078ec0ffULL, 0x0000000108367824ULL, 0x000fe400078e0235ULL,
0x00000037063479a7ULL, 0x0002a4000850003fULL, 0x01a6983736ff79a7ULL, 0x0003f2000850003fULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x00000035060075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff367224ULL, 0x002fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000001582d7836ULL, 0x000fca0000000000ULL, 0x000000622d00720cULL, 0x000fda0003f06070ULL,
0x0000000400f80947ULL, 0x000fea0003800000ULL, 0x00000002582d7836ULL, 0x000fe20000000000ULL,
0x0000850000087ab9ULL, 0x000fe20000000800ULL, 0x00000100822f7836ULL, 0x000fe40000000000ULL,
0x00000008814e7c24ULL, 0x010fe2000f8e02ffULL, 0x000000622d00720cULL, 0x000fe40003f06070ULL,
0x000000602f2d7812ULL, 0x000fe200078ec0ffULL, 0x000000804e4e7824ULL, 0x000fc800078e00ffULL,
0x000000015a357824ULL, 0x000fcc00078e022dULL, 0x0000000400048947ULL, 0x000fea0003800000ULL,
0x0000002f742c7248ULL, 0x000fe20007fe0000ULL, 0x00000010772d7824ULL, 0x000fe200078e00ffULL,
0x00000003ff347819ULL, 0x000fc60000011609ULL, 0x000000012c2c7824ULL, 0x000fe200078e0a2fULL,
0x000000102d2f7812ULL, 0x000fe200078ec0ffULL, 0x0000000434367836ULL, 0x002fe40000000000ULL,
0x0000000834377836ULL, 0x000fe20000000000ULL, 0x0000002c2f2e7248ULL, 0x000fe20007fe0000ULL,
0x0000000c344d7836ULL, 0x000fe20000000000ULL, 0x00009000ff2c7b82ULL, 0x000e620000000a00ULL,
0x00000001364c7824ULL, 0x100fe400078e022fULL, 0x000000012e2e7824ULL, 0x000fc400078e0a2fULL,
0x0000000137647824ULL, 0x100fe400078e022fULL, 0x000000014d667824ULL, 0x000fe200078e022fULL,
0x0000002e3400720cULL, 0x080fe20003f86070ULL, 0x000000084c5e7824ULL, 0x000fe200078e00ffULL,
0x0000002f34347210ULL, 0x000fe20007ffe0ffULL, 0x00000001642f7824ULL, 0x100fe200078e0209ULL,
0x0000002e3600720cULL, 0x080fe40003f66070ULL, 0x0000002e3700720cULL, 0x080fe20003f46070ULL,
0x0000000134367824ULL, 0x040fe200078e0209ULL, 0x0000002e4d00720cULL, 0x000fe20003f06070ULL,
0x00000008344f7824ULL, 0x000fc400078e00ffULL, 0x000000014c377824ULL, 0x000fe400078e0209ULL,
0x00000001342e7824ULL, 0x100fe200078e0235ULL, 0xfffffff84f5c7812ULL, 0x000fe200078ee236ULL,
0x0000000164367824ULL, 0x140fe200078e0235ULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee237ULL,
0x0000000864647824ULL, 0x000fe200078e00ffULL, 0x0000002c4e4f7211ULL, 0x002fe200078a38ffULL,
0x000000014c347824ULL, 0x100fe400078e0235ULL, 0x00000001664c7824ULL, 0x040fe200078e0235ULL,
0xfffffff864647812ULL, 0x000fe200078ee22fULL, 0x0000000166377824ULL, 0x000fe200078e0209ULL,
0x0000002d4e5d7211ULL, 0x000fe200028f3cffULL, 0x0000000866667824ULL, 0x000fc400078e00ffULL,
0x000000802e2e7825ULL, 0x000fc600078e00ffULL, 0xfffffff866667812ULL, 0x000fe200078ee237ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000006d2e2c7212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006d342e7212ULL, 0x080fe400078efcffULL,
0x0000002c4f2c7210ULL, 0x000fe20007fbe0ffULL, 0x000000804c4c7825ULL, 0x000fe200078e00ffULL,
0x0000004f2e2e7210ULL, 0x000fe40007fde0ffULL, 0x0000006d36347212ULL, 0x080fe200078efcffULL,
0x000000012f2d7824ULL, 0x100fe200028e065dULL, 0x0000006d4c367212ULL, 0x000fe200078efcffULL,
0x00000001352f7824ULL, 0x000fe200030e065dULL, 0x0000004f34347210ULL, 0x000fe20007fbe0ffULL,
0x000000105e5f7824ULL, 0x100fe200078e0273ULL, 0x0000004f36367210ULL, 0x000fe20007fde0ffULL,
0x000000105c4f7824ULL, 0x000fc400078e0273ULL, 0x0000001064657824ULL, 0x000fe400078e0273ULL,
0x0000000137357824ULL, 0x000fe200028e065dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c4f7faeULL, 0x0003e2000e101c46ULL, 0x0000001066737824ULL, 0x000fe400078e0273ULL,
0x000000014d377824ULL, 0x000fe200030e065dULL, 0x000000002e5f7faeULL, 0x0003e8000d901c46ULL,
0x0000000034657faeULL, 0x0003e8000d101c46ULL, 0x0000000036737faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x00000010772c7824ULL, 0x000fe200078e00ffULL,
0x00009000ff4c7b82ULL, 0x000ea80000000a00ULL, 0x000000102c2c7812ULL, 0x000fc800078ec0ffULL,
0x0000002c092e7211ULL, 0x000fca00078fe8ffULL, 0x000000012e2c7824ULL, 0x040fe400078e0209ULL,
0x000000082e2d7824ULL, 0x040fe400078e00ffULL, 0x000000042e347836ULL, 0x000fe40000000000ULL,
0x000000082e5e7836ULL, 0x000fe20000000000ULL, 0xfffffff82d5c7812ULL, 0x000fe200078ee22cULL,
0x000000012e2c7824ULL, 0x100fe400078e0235ULL, 0x0000000c2e647836ULL, 0x000fe20000000000ULL,
0x0000004c4e4f7211ULL, 0x004fe200078038ffULL, 0x00000001342e7824ULL, 0x000fc400078e0235ULL,
0x00000001342f7824ULL, 0x000fe200078e0209ULL, 0x0000004d4e4d7211ULL, 0x000fe200000f3cffULL,
0x0000000834667824ULL, 0x000fe400078e00ffULL, 0x000000802c2c7825ULL, 0x000fc800078e00ffULL,
0x000000015e347824ULL, 0x100fe200078e0235ULL, 0x0000006d2c2c7212ULL, 0x000fe200078efcffULL,
0x0000000164367824ULL, 0x002fe200078e0235ULL, 0x000000095e357210ULL, 0x000fe20007ffe0ffULL,
0x000000085e687824ULL, 0x000fe200078e00ffULL, 0xfffffff8665e7812ULL, 0x000fe200078ee22fULL,
0x0000000164377824ULL, 0x040fe200078e0209ULL, 0x0000002c4f2c7210ULL, 0x000fe20007f1e0ffULL,
0x00000008646a7824ULL, 0x000fe200078e00ffULL, 0xfffffff868647812ULL, 0x000fe200078ee235ULL,
0x000000802e2e7825ULL, 0x000fc600078e00ffULL, 0xfffffff86a667812ULL, 0x000fe200078ee237ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000006d2e2e7212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006d34347212ULL, 0x000fc600078efcffULL,
0x000000012d2d7824ULL, 0x000fe200000e064dULL, 0x0000006d36367212ULL, 0x000fe200078efcffULL,
0x000000105e5d7824ULL, 0x100fe200078e0273ULL, 0x0000002e4f2e7210ULL, 0x000fe20007f1e0ffULL,
0x00000010645f7824ULL, 0x100fe200078e0273ULL, 0x000000344f347210ULL, 0x000fe40007f5e0ffULL,
0x000000364f367210ULL, 0x000fe20007f7e0ffULL, 0x000000105c4f7824ULL, 0x000fe400078e0273ULL,
0x000000012f2f7824ULL, 0x000fc400000e064dULL, 0x0000000135357824ULL, 0x000fe200010e064dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c4f7faeULL, 0x0003e2000b901c46ULL,
0x0000001066737824ULL, 0x000fe400078e0273ULL, 0x0000000137377824ULL, 0x000fe200018e064dULL,
0x000000002e5d7faeULL, 0x0003e8000b901c46ULL, 0x00000000345f7faeULL, 0x0003e8000b901c46ULL,
0x0000000036737faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000008772d7824ULL, 0x000fe400078e00ffULL, 0x000000205b2c7824ULL, 0x000fe200078e0208ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x000000082d2d7812ULL, 0x000fe200078ec0ffULL, 0x00000010592c7824ULL, 0x000fe200078e022cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000012d377824ULL, 0x000fe200078e022cULL,
0x00000034ff7e79a7ULL, 0x0002a60008500005ULL, 0x01a66834373479a7ULL, 0x0022e6000850003fULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x01a66835370075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c4d7210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09004d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x0000004d2e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a66835370075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x000000805b2c7824ULL, 0x000fe400078e0208ULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x000000ffff7a7224ULL, 0x000fe200078e0085ULL, 0x000001806d2d7810ULL, 0x000fca0007ffe02cULL,
0x00000001702d7824ULL, 0x000fca00078e022dULL, 0x01a000002d2c7984ULL, 0x000ee80000000800ULL,
0x01a200002d2f7984ULL, 0x000b620000000800ULL, 0x000000852c00720bULL, 0x008fda0003f1d000ULL,
0x0000000000357806ULL, 0x000fc800000e0100ULL, 0x000000ff3500720cULL, 0x000fda0003f05270ULL,
0x0000000400948947ULL, 0x026fea0003800000ULL, 0x000000035b2e7836ULL, 0x000fe20000000000ULL,
0x000000852c00720bULL, 0x0c0fe40003f14000ULL, 0x000000852c7a7209ULL, 0x000fe40007810000ULL,
0x000000772e00720cULL, 0x000fd20003f45270ULL, 0x00000000002e7806ULL, 0x000fc800000e0100ULL,
0x00000080772da824ULL, 0x000fe200078e0208ULL, 0x000000ff2e00720cULL, 0x000fc80003f05270ULL,
0x0000002d702da210ULL, 0x000fca0007ffe06dULL, 0x01a4007a2d00a388ULL, 0x0003e80000000800ULL,
0x0000000400508947ULL, 0x000fea0003800000ULL, 0x000000857a2d7221ULL, 0x002fe20000010100ULL,
0x000000ff2eff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff002eff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b2d2d7820ULL, 0x000fe20000410000ULL, 0x00ff00002eff7812ULL, 0x040fe4000786c0ffULL,
0xff0000002eff7812ULL, 0x000fe2000788c0ffULL, 0x0000002d00377308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x000fca0000011609ULL,
0x00001f34372d7589ULL, 0x006e6400000e0000ULL, 0x000000542d547220ULL, 0x042fe20000410000ULL,
0x000000552d557220ULL, 0x040fe20000410000ULL, 0x0000003c2d3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2d3d7220ULL, 0x040fe20000410000ULL, 0x000000402d407220ULL, 0x040fe20000410000ULL,
0x000000412d417220ULL, 0x040fe20000410000ULL, 0x000000442d447220ULL, 0x040fe20000410000ULL,
0x000000452d457220ULL, 0x040fe20000410000ULL, 0x000000482d487220ULL, 0x040fe20000410000ULL,
0x000000492d497220ULL, 0x040fe20000410000ULL, 0x000000502d507220ULL, 0x040fe20000410000ULL,
0x000000512d517220ULL, 0x040fe20000410000ULL, 0x000000282d287220ULL, 0x040fe20000410000ULL,
0x000000292d297220ULL, 0x040fe20000410000ULL, 0x000000242d247220ULL, 0x040fe20000410000ULL,
0x000000252d257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000000809347811ULL, 0x000fca00078ff0ffULL, 0x00001f34372d7589ULL, 0x006e6400000e0000ULL,
0x000000562d567220ULL, 0x042fe20000410000ULL, 0x000000572d577220ULL, 0x040fe20000410000ULL,
0x0000003e2d3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2d3f7220ULL, 0x040fe20000410000ULL,
0x000000422d427220ULL, 0x040fe20000410000ULL, 0x000000432d437220ULL, 0x040fe20000410000ULL,
0x000000462d467220ULL, 0x040fe20000410000ULL, 0x000000472d477220ULL, 0x040fe20000410000ULL,
0x0000004a2d4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2d4b7220ULL, 0x040fe20000410000ULL,
0x000000522d527220ULL, 0x040fe20000410000ULL, 0x000000532d537220ULL, 0x040fe20000410000ULL,
0x0000002a2d2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2d2b7220ULL, 0x040fe20000410000ULL,
0x000000262d267220ULL, 0x040fe20000410000ULL, 0x000000272d277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x0000001009347811ULL, 0x000fca00078ff0ffULL,
0x00001f34372d7589ULL, 0x006e6400000e0000ULL, 0x0000000c2d0c7220ULL, 0x042fe20000410000ULL,
0x0000000d2d0d7220ULL, 0x040fe20000410000ULL, 0x000000102d107220ULL, 0x040fe20000410000ULL,
0x000000112d117220ULL, 0x040fe20000410000ULL, 0x000000142d147220ULL, 0x040fe20000410000ULL,
0x000000152d157220ULL, 0x040fe20000410000ULL, 0x000000182d187220ULL, 0x040fe20000410000ULL,
0x000000192d197220ULL, 0x040fe20000410000ULL, 0x0000001c2d1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2d1d7220ULL, 0x040fe20000410000ULL, 0x000000202d207220ULL, 0x040fe20000410000ULL,
0x000000212d217220ULL, 0x040fe20000410000ULL, 0x000000302d307220ULL, 0x040fe20000410000ULL,
0x000000312d317220ULL, 0x040fe20000410000ULL, 0x000000382d387220ULL, 0x040fe20000410000ULL,
0x000000392d397220ULL, 0x000fce0000410000ULL, 0x0000003784847220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x0000001809347811ULL, 0x000fca00078ff0ffULL,
0x00001f34372d7589ULL, 0x002e6400000e0000ULL, 0x0000000e2d0e7220ULL, 0x042fe20000410000ULL,
0x0000000f2d0f7220ULL, 0x040fe20000410000ULL, 0x000000122d127220ULL, 0x040fe20000410000ULL,
0x000000132d137220ULL, 0x040fe20000410000ULL, 0x000000162d167220ULL, 0x040fe20000410000ULL,
0x000000172d177220ULL, 0x040fe20000410000ULL, 0x0000001a2d1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2d1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2d1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2d1f7220ULL, 0x040fe20000410000ULL, 0x000000222d227220ULL, 0x040fe20000410000ULL,
0x000000232d237220ULL, 0x040fe20000410000ULL, 0x000000322d327220ULL, 0x040fe20000410000ULL,
0x000000332d337220ULL, 0x040fe20000410000ULL, 0x0000003a2d3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2d3b7220ULL, 0x000fce0000410000ULL, 0x0000002e35ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff347424ULL, 0x000fd800078e00ffULL, 0x0000002c7a2c0221ULL, 0x000fe20000010100ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2c2c0820ULL, 0x000fc80000410000ULL,
0x0000002c00040308ULL, 0x000ea40000000800ULL, 0x000000042f2f0220ULL, 0x004fce0000410000ULL,
0x000000842f847221ULL, 0x000fce0000010000ULL, 0x00000000002c7805ULL, 0x002fce0000015200ULL,
0x00000008772e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2f7812ULL, 0x000fca00078ec0ffULL,
0x0000000108377824ULL, 0x000fc800078e022fULL, 0x01a6b087370075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6b087370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000004ff2e7819ULL, 0x000fe20000011609ULL, 0x000000086c357824ULL, 0x000fe200078e00ffULL,
0x00009910342c7816ULL, 0x000fe200000000ffULL, 0x00000004772f7824ULL, 0x000fe200078e00ffULL,
0x000000085b7e7211ULL, 0x000fe200078e60ffULL, 0x00000004592d7824ULL, 0x000fe200078e022eULL,
0x000000ff2c00720cULL, 0x000fe20003f05270ULL, 0x0000000878377824ULL, 0x000fe400078e00ffULL,
0x000000016c2c7824ULL, 0x100fe400078e022dULL, 0x00000001782e7824ULL, 0x000fc400078e022dULL,
0x000150007e7e7836ULL, 0x000fe20000000000ULL, 0xfffffff8352d7812ULL, 0x000fe200078ee22cULL,
0x000000106e4c7824ULL, 0x000fe200078e027bULL, 0x000000042f2c7812ULL, 0x000fe400078ec0ffULL,
0xfffffff8372f7812ULL, 0x000fe200078ee22eULL, 0x000000102d2d7824ULL, 0x000fe200078e027eULL,
0x000000022c2c7812ULL, 0x000fc600078efcffULL, 0x000000102f2f7824ULL, 0x000fe200078e027eULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe40000011609ULL,
0x00000004ff00723eULL, 0x000fc600000010ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x00005410002e7816ULL, 0x000fe20000000000ULL, 0x0000000803357836ULL, 0x000fe40000000000ULL,
0x0000001803377836ULL, 0x000fe40000000000ULL, 0x00001f052e057589ULL, 0x0002a800000e0000ULL,
0x00001f352e027589ULL, 0x0002e800000e0000ULL, 0x00001f032e037589ULL, 0x00026800000e0000ULL,
0x00001f372e007589ULL, 0x00026400000e0000ULL, 0x000000002d5c783bULL, 0x0006a80000000200ULL,
0x000000002f34783bULL, 0x0026620000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x000000035c5c7232ULL, 0x084fe40000200000ULL, 0x000000035e5e7232ULL, 0x000fe40000200000ULL,
0x000000025d5d7232ULL, 0x088fe40000200000ULL, 0x000000025f5f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x082fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x0000002c09837211ULL, 0x000fe200078fe0ffULL, 0x000000004c4c783bULL, 0x000f620000004200ULL,
0x000000086c2d7824ULL, 0x008fc600078e00ffULL, 0x000000016c6c7824ULL, 0x000fca00078e0283ULL,
0xfffffff82d6c7812ULL, 0x000fca00078ee26cULL, 0x000000106c2c7824ULL, 0x000fcc00078e027bULL,
0x000000002c2c783bULL, 0x000ee20000004200ULL, 0x00000018ff647819ULL, 0x020fe2000001144cULL,
0x000001004c677824ULL, 0x040fe200078e00ffULL, 0x000088804c667816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe2000001144dULL,
0x000001004d687824ULL, 0x040fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe20000011467ULL,
0x000001004e697824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x000088804d677816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fc40000011469ULL,
0x00000018ff6b7819ULL, 0x000fe4000001144fULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000004c008d7306ULL, 0x000be20000202400ULL, 0x000088804f697816ULL, 0x000fe400000000ffULL,
0x00000018ff867819ULL, 0x000fe20000011468ULL, 0x000001002e857824ULL, 0x008fe200078e00ffULL,
0x000088804e687816ULL, 0x000fe200000000ffULL, 0x000001002f887824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001144eULL, 0x0000004d00827306ULL, 0x0007e20000202400ULL,
0x000001004f4c7824ULL, 0x064fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001142cULL,
0x000100004f4f7824ULL, 0x000fe200078e00ffULL, 0x000088802c6c7816ULL, 0x000fc400000000ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001144cULL, 0x000100004e4c7824ULL, 0x000fe200078e00ffULL,
0x0000008700877306ULL, 0x000ea20000202400ULL, 0x000001002c4d7824ULL, 0x008fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe4000001142dULL, 0x00000018ff8b7819ULL, 0x000fe4000001144cULL,
0x00000018ff4c7819ULL, 0x000fe4000001144fULL, 0x00000018ff4f7819ULL, 0x000fe2000001144dULL,
0x0000006500657306ULL, 0x000ee20000202400ULL, 0x000001002d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fc4000001142fULL, 0x00000018ff727819ULL, 0x000fe4000001142eULL,
0x00000018ff7c7819ULL, 0x000fe2000001144dULL, 0x000100002c4d7824ULL, 0x000fe200078e00ffULL,
0x0000006800687306ULL, 0x000fe20000202400ULL, 0x000088802e707816ULL, 0x040fe200000000ffULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x0000541066667816ULL, 0x004fe40000000087ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff857819ULL, 0x000fe20000011485ULL,
0x0000008900897306ULL, 0x000ea20000202400ULL, 0x00000018ff877819ULL, 0x000fc40000011488ULL,
0x0000541082657816ULL, 0x008fe40000000065ULL, 0x00000018ff2e7819ULL, 0x000fc6000001142eULL,
0x0000006d004e7306ULL, 0x0007e20000202400ULL, 0x0000541068687816ULL, 0x004fce0000000089ULL,
0x0000007c002c7306ULL, 0x0005e20000202400ULL, 0x000088802d6d7816ULL, 0x048fe200000000ffULL,
0x000100002d2d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000006b006b7306ULL, 0x000fe20000202400ULL, 0x000088802f7c7816ULL, 0x044fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff827819ULL, 0x000fe2000001142fULL,
0x0000004c004c7306ULL, 0x000eb00000202400ULL, 0x0000006d006d7306ULL, 0x000ee20000202400ULL,
0x000054104c6b7816ULL, 0x004fce000000006bULL, 0x0000006400647306ULL, 0x000ea20000202400ULL,
0x000000106f4c7824ULL, 0x000fe200078e027eULL, 0x000054106d6d7816ULL, 0x008fcc000000002cULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x00000010712c7824ULL, 0x000fe200078e027eULL,
0x000054108d647816ULL, 0x004fcc0000000064ULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x000000643410723cULL, 0x002fee0000041810ULL, 0x0000008000807306ULL, 0x000fe20000202400ULL,
0x000000645c3c723cULL, 0x000fee000004183cULL, 0x0000006700677306ULL, 0x000ff00000202400ULL,
0x0000008600867306ULL, 0x000e700000202400ULL, 0x0000006900697306ULL, 0x000ea20000202400ULL,
0x0000541067677816ULL, 0x002fce0000000086ULL, 0x0000008b008b7306ULL, 0x000e620000202400ULL,
0x00000066340c723cULL, 0x000fe2000004180cULL, 0x0000541069697816ULL, 0x004fcc000000004eULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x000000665c54723cULL, 0x000fe20000041854ULL,
0x000054108b6a7816ULL, 0x002fcc000000006aULL, 0x0000004f004f7306ULL, 0x000e620000202400ULL,
0x000000683414723cULL, 0x000fee0000041814ULL, 0x0000004d004d7306ULL, 0x000ea20000202400ULL,
0x0000006a3418723cULL, 0x000fe20000041818ULL, 0x000054106c6c7816ULL, 0x002fcc000000004fULL,
0x0000002d002d7306ULL, 0x000e620000202400ULL, 0x000000685c40723cULL, 0x000fe20000041840ULL,
0x000054104d6e7816ULL, 0x004fcc000000006eULL, 0x0000007000707306ULL, 0x000fe20000202400ULL,
0x0000006c341c723cULL, 0x000fe2000004181cULL, 0x000000004c4c783bULL, 0x000ea20000000200ULL,
0x000054102d6f7816ULL, 0x002fca0000000080ULL, 0x0000008500857306ULL, 0x000e620000202400ULL,
0x0000006a5c44723cULL, 0x000fec0000041844ULL, 0x0000006e3420723cULL, 0x000fe20000041820ULL,
0x0000007c007c7306ULL, 0x000fea0000202400ULL, 0x0000006c5c48723cULL, 0x000fe20000041848ULL,
0x0000541070707816ULL, 0x002fc40000000085ULL, 0x0000008700877306ULL, 0x000e660000202400ULL,
0x0000006e5c50723cULL, 0x000fea0000041850ULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x000054107c717816ULL, 0x002fce0000000087ULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x000000703430723cULL, 0x000fee0000041830ULL, 0x0000002e00897306ULL, 0x0002e20000202400ULL,
0x000000705c28723cULL, 0x000fee0000041828ULL, 0x0000008200827306ULL, 0x000f620000202400ULL,
0x000000002c2c783bULL, 0x002e620000000200ULL, 0x0000541089727816ULL, 0x008fc40000000072ULL,
0x0000541082737816ULL, 0x020fce0000000073ULL, 0x000000725c24723cULL, 0x000fec0000041824ULL,
0x000000723434723cULL, 0x000fe20000041838ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000200947ULL, 0x004fde0003800000ULL, 0x000000034c4c7232ULL, 0x080fe40000200000ULL,
0x000000034e4e7232ULL, 0x000fe40000200000ULL, 0x000000024d4d7232ULL, 0x080fe40000200000ULL,
0x000000024f4f7232ULL, 0x000fe40000200000ULL, 0x000000052c2c7232ULL, 0x082fe40000200000ULL,
0x000000052e2e7232ULL, 0x000fc40000200000ULL, 0x000000002d2d7232ULL, 0x080fe40000200000ULL,
0x000000002f2f7232ULL, 0x000fce0000200000ULL, 0x000000007d5c783bULL, 0x000ea20000004200ULL,
0x0000000178837824ULL, 0x000fe400078e0283ULL, 0x0000000158587836ULL, 0x000fe40000000000ULL,
0x000001005c387824ULL, 0x004fe200078e00ffULL, 0x000000085d397819ULL, 0x000fe200000006ffULL,
0x000001005e647824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001145cULL,
0x00000018ff7c7819ULL, 0x000fe20000011438ULL, 0x0000000878387824ULL, 0x000fe200078e00ffULL,
0x000088805c677816ULL, 0x040fe200000000ffULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001145eULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0xfffffff838387812ULL, 0x000fc400078ee283ULL, 0x00000018ff837819ULL, 0x000fe40000011439ULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000001038387824ULL, 0x000fe200078e027bULL,
0x000088805e727816ULL, 0x040fe200000000ffULL, 0x000100005e5e7824ULL, 0x000fe200078e00ffULL,
0x0000005c007d7306ULL, 0x0005e20000202400ULL, 0x000088805d807816ULL, 0x000fe400000000ffULL,
0x000000003838783bULL, 0x000ee20000004200ULL, 0x00000018ff6c7819ULL, 0x000fc4000001145fULL,
0x000088805f737816ULL, 0x040fe400000000ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001145dULL,
0x000001005f5c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x000100005f5f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000006700677306ULL, 0x000fe20000202400ULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fc8000001145fULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x0000007c007c7306ULL, 0x000eb00000202400ULL,
0x0000008000807306ULL, 0x000ff00000202400ULL, 0x0000008300837306ULL, 0x000f620000202400ULL,
0x00000018ff657819ULL, 0x008fe2000001143aULL, 0x000001003a827824ULL, 0x000fcc00078e00ffULL,
0x0000005c00787306ULL, 0x000fe20000202400ULL, 0x00000018ff5f7819ULL, 0x000fe40000011438ULL,
0x0000888038697816ULL, 0x000fe400000000ffULL, 0x0000888039687816ULL, 0x000fc600000000ffULL,
0x00000064007b7306ULL, 0x0007f00000202400ULL, 0x0000005e00707306ULL, 0x0005e20000202400ULL,
0x00000018ff647819ULL, 0x008fce0000011439ULL, 0x00000065005c7306ULL, 0x0007e20000202400ULL,
0x00000100385e7824ULL, 0x046fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x0000010039657824ULL, 0x048fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011465ULL,
0x0000005d007e7306ULL, 0x0002a20000202400ULL, 0x00000018ff397819ULL, 0x000fce0000011439ULL,
0x0000003800667306ULL, 0x0007e20000202400ULL, 0x00000018ff5d7819ULL, 0x002fce000001143bULL,
0x0000003900657306ULL, 0x000be20000202400ULL, 0x0000541067387816ULL, 0x008fe2000000007cULL,
0x000001003b7c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fc80000011482ULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x0000541080397816ULL, 0x020fce0000000083ULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x000000384c54723cULL, 0x000fec0000041854ULL, 0x000000382c0c723cULL, 0x000fe2000004180cULL,
0x0000007100717306ULL, 0x000e6c0000202400ULL, 0x000054107d387816ULL, 0x000fc4000000006eULL,
0x0000007200727306ULL, 0x000ee20000202400ULL, 0x000088803b6e7816ULL, 0x040fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x000054107e397816ULL, 0x004fc8000000006fULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000005e006a7306ULL, 0x0005e20000202400ULL,
0x0000541071717816ULL, 0x002fe2000000006cULL, 0x000000384c3c723cULL, 0x000fec000004183cULL,
0x0000005f005f7306ULL, 0x000fe20000202400ULL, 0x000088803a5e7816ULL, 0x044fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000000382c10723cULL, 0x000fe80000041810ULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0000006400647306ULL, 0x000fe40000202400ULL,
0x0000541073397816ULL, 0x000fc40000000078ULL, 0x0000541072387816ULL, 0x008fc8000000007bULL,
0x0000006900697306ULL, 0x000e660000202400ULL, 0x000000384c40723cULL, 0x000fea0000041840ULL,
0x0000006800687306ULL, 0x000fe20000202400ULL, 0x000000382c14723cULL, 0x000fee0000041814ULL,
0x0000006b006b7306ULL, 0x000ea20000202400ULL, 0x0000541069387816ULL, 0x002fce000000006aULL,
0x0000006d006d7306ULL, 0x000e620000202400ULL, 0x0000541068397816ULL, 0x004fce000000006bULL,
0x0000005e005e7306ULL, 0x000fe20000202400ULL, 0x000000384c48723cULL, 0x000fe20000041848ULL,
0x0000541070707816ULL, 0x002fcc000000006dULL, 0x0000006700677306ULL, 0x000e620000202400ULL,
0x000000382c1c723cULL, 0x000fee000004181cULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x000000702c18723cULL, 0x000fe20000041818ULL, 0x000054105e5e7816ULL, 0x002fcc0000000067ULL,
0x0000007c00737306ULL, 0x000e620000202400ULL, 0x000000704c44723cULL, 0x000fee0000041844ULL,
0x0000005d005d7306ULL, 0x000ff00000202400ULL, 0x0000003a006f7306ULL, 0x0004f00000202400ULL,
0x0000003b006c7306ULL, 0x000b620000202400ULL, 0x00005410663a7816ULL, 0x004fc4000000005fULL,
0x000054106e5f7816ULL, 0x002fe40000000073ULL, 0x000054106f5c7816ULL, 0x008fe4000000005cULL,
0x00005410653b7816ULL, 0x020fc60000000064ULL, 0x0000005e2c30723cULL, 0x000fe20000041830ULL,
0x000054106c5d7816ULL, 0x000fca000000005dULL, 0x0000003a4c50723cULL, 0x000fec0000041850ULL,
0x0000003a2c20723cULL, 0x000fec0000041820ULL, 0x0000005e4c28723cULL, 0x000fe20000041828ULL,
0x00000001ff3b7424ULL, 0x000fc800078e00ffULL, 0x0000003b063879a7ULL, 0x0002a2000850003fULL,
0x0000005c4c24723cULL, 0x000fec0000041824ULL, 0x0000005c2c2c723cULL, 0x000fe20000041834ULL,
0x000000085b067824ULL, 0x002fc800078e0208ULL, 0x01a6a03b06ff79a7ULL, 0x0003e2000850003fULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0xffffff6000509947ULL, 0x000fde000383ffffULL,
0x000000ff6200720cULL, 0x000fe20003f05270ULL, 0x000000ffff377224ULL, 0x000fe400078e0041ULL,
0x000000ffff357224ULL, 0x000fe400078e0040ULL, 0x000000ffff097224ULL, 0x000fd000078e003cULL,
0x0000000400648947ULL, 0x000fea0003800000ULL, 0x0180000084007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000c08000047802ULL, 0x000fce0000000f00ULL, 0x000000b0009c7944ULL, 0x016fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000008400037308ULL, 0x002e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000084ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009a00ff027b82ULL, 0x000f640000000a00ULL, 0x0000000602037981ULL, 0x02aee2000c1e9900ULL,
0x0000000000067919ULL, 0x000e640000000000ULL, 0x0000000806057811ULL, 0x042fe400078ff0ffULL,
0x0000001806077811ULL, 0x040fe400078ff0ffULL, 0x00000002ff397819ULL, 0x004fe40000011606ULL,
0x00000010063b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x008fca0000410000ULL,
0x00001f3900047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea800000e0000ULL,
0x00001f3b00067589ULL, 0x000ee800000e0000ULL, 0x00001f0700077589ULL, 0x000f6200000e0000ULL,
0x0000005404547220ULL, 0x042fe20000410000ULL, 0x0000005504557220ULL, 0x040fe20000410000ULL,
0x0000000904097220ULL, 0x040fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000004404447220ULL, 0x040fe20000410000ULL, 0x0000004504457220ULL, 0x040fe20000410000ULL,
0x0000004804487220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000005004507220ULL, 0x040fe20000410000ULL, 0x0000005104517220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000005605567220ULL, 0x044fe20000410000ULL, 0x0000005705577220ULL, 0x040fe20000410000ULL,
0x0000003e053e7220ULL, 0x040fe20000410000ULL, 0x0000003f053f7220ULL, 0x040fe20000410000ULL,
0x0000004205427220ULL, 0x040fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000004605467220ULL, 0x040fe20000410000ULL, 0x0000004705477220ULL, 0x040fe20000410000ULL,
0x0000004a054a7220ULL, 0x040fe20000410000ULL, 0x0000004b054b7220ULL, 0x040fe20000410000ULL,
0x0000005205527220ULL, 0x040fe20000410000ULL, 0x0000005305537220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x000fe20000410000ULL,
0x0000000c060c7220ULL, 0x048fe20000410000ULL, 0x0000000d060d7220ULL, 0x040fe20000410000ULL,
0x0000001006107220ULL, 0x040fe20000410000ULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x0000001406147220ULL, 0x040fe20000410000ULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x0000001806187220ULL, 0x040fe20000410000ULL, 0x0000001906197220ULL, 0x040fe20000410000ULL,
0x0000001c061c7220ULL, 0x040fe20000410000ULL, 0x0000001d061d7220ULL, 0x040fe20000410000ULL,
0x0000002006207220ULL, 0x040fe20000410000ULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x0000003006307220ULL, 0x040fe20000410000ULL, 0x0000003106317220ULL, 0x040fe20000410000ULL,
0x0000002c062c7220ULL, 0x040fe20000410000ULL, 0x0000002d062d7220ULL, 0x000fe20000410000ULL,
0x0000000e070e7220ULL, 0x060fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001607167220ULL, 0x040fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x0000000177777812ULL, 0x000fe400078ec0ffULL,
0x000000484948723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000200077087824ULL, 0x000fe200078e0208ULL, 0x000000505150723eULL, 0x000fc400000010ffULL,
0x000000282928723eULL, 0x000fe400000010ffULL, 0x000000242524723eULL, 0x000fe400000010ffULL,
0x000000565756723eULL, 0x000fe400000010ffULL, 0x0000003e3f3e723eULL, 0x000fe400000010ffULL,
0x000000424342723eULL, 0x000fe400000010ffULL, 0x000000464746723eULL, 0x000fc400000010ffULL,
0x0000004a4b4a723eULL, 0x000fe400000010ffULL, 0x000000525325723eULL, 0x000fe400000010ffULL,
0x0000002a2b2a723eULL, 0x000fe400000010ffULL, 0x000000262726723eULL, 0x000fe200000010ffULL,
0x0000000161617824ULL, 0x008fe200078e0200ULL, 0x0000000800057811ULL, 0x040fe400078ff0ffULL,
0x0000000200027812ULL, 0x002fe200078ec0ffULL, 0x0000001061617824ULL, 0x000fe200078e0208ULL,
0x00000002ff077819ULL, 0x000fe20000011600ULL, 0x0000000805387824ULL, 0x004fe200078e00ffULL,
0x0000000502037211ULL, 0x000fc400078ff8ffULL, 0x0000001000057811ULL, 0x040fe200078ff0ffULL,
0x0000000807347824ULL, 0x040fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe200078ee203ULL,
0x0000000807367824ULL, 0x000fe200078e00ffULL, 0x0000001800397811ULL, 0x000fe200078ff0ffULL,
0x00000008053b7824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x040fe400078ff8ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x00000008393c7824ULL, 0x000fe200078e00ffULL,
0x0000003902057211ULL, 0x000fe200078ff8ffULL, 0x0000000807397824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3a7812ULL, 0x000fe200078ee204ULL, 0x0000000203027836ULL, 0x000fe20000000000ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee205ULL, 0x0000000403057836ULL, 0x000fe20000000000ULL,
0x0000000c0d0c723eULL, 0x000fe200000010ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff839067812ULL, 0x000fe200078ee202ULL, 0x0000000807027824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ee205ULL, 0x0000000603077836ULL, 0x000fe20000000000ULL,
0x0000000804057812ULL, 0x000fc400078ec0ffULL, 0xfffffff802027812ULL, 0x000fe200078ee203ULL,
0x0000100063037824ULL, 0x000fe200078e0208ULL, 0xfffffff836367812ULL, 0x000fe400078ee207ULL,
0x000000141514723eULL, 0x000fe200000010ffULL, 0x0000001038387824ULL, 0x100fe200078e0203ULL,
0x0000000302047211ULL, 0x000fe200078e20ffULL, 0x000000103a3a7824ULL, 0x100fe200078e0203ULL,
0x000000545502723eULL, 0x000fe200000010ffULL, 0x000000103c3c7824ULL, 0x100fe200078e0203ULL,
0x000000181918723eULL, 0x000fe200000010ffULL, 0x0000001006067824ULL, 0x100fe200078e0203ULL,
0x0000001c1d1c723eULL, 0x000fe200000010ffULL, 0x0000001034347824ULL, 0x100fe200078e0203ULL,
0x000000202120723eULL, 0x000fe200000010ffULL, 0x0000001036367824ULL, 0x000fe200078e0203ULL,
0x000000093d03723eULL, 0x000fe200000010ffULL, 0x0000000104047824ULL, 0x000fe200078e0205ULL,
0x000000303130723eULL, 0x000fe200000010ffULL, 0x0000000105387824ULL, 0x040fe200078e0238ULL,
0x0000541002407816ULL, 0x140fe20000000003ULL, 0x00000001053a7824ULL, 0x040fe200078e023aULL,
0x0000763202417816ULL, 0x000fe20000000003ULL, 0x00000001053c7824ULL, 0x000fe200078e023cULL,
0x000000353702723eULL, 0x000fe200000010ffULL, 0x0000000105097824ULL, 0x000fe200078e0206ULL,
0x000000444503723eULL, 0x000fe200000010ffULL, 0x0000004004007388ULL, 0x0003e20000000a00ULL,
0x0000000105347824ULL, 0x000fe200078e0234ULL, 0x000000101106723eULL, 0x000fe200000010ffULL,
0x0000000105367824ULL, 0x000fe200078e0236ULL, 0x0000763202057816ULL, 0x000fc40000000003ULL,
0x0000000e0f0e723eULL, 0x000fe400000010ffULL, 0x000000121307723eULL, 0x000fe400000010ffULL,
0x000000161716723eULL, 0x000fe400000010ffULL, 0x0000541002047816ULL, 0x002fe40000000003ULL,
0x0000541048027816ULL, 0x140fe40000000050ULL, 0x0000763248037816ULL, 0x000fe20000000050ULL,
0x0000000409007388ULL, 0x000fe20000000a00ULL, 0x0000001a1b1a723eULL, 0x000fc400000010ffULL,
0x0000001e1f1e723eULL, 0x000fe200000010ffULL, 0x0000000234007388ULL, 0x0003e20000000a00ULL,
0x00000022230f723eULL, 0x000fe400000010ffULL, 0x000000323332723eULL, 0x000fe400000010ffULL,
0x0000002e2f19723eULL, 0x000fe400000010ffULL, 0x000000ff6300720cULL, 0x000fe40003f05270ULL,
0x0000763232297816ULL, 0x000fc40000000019ULL, 0x0000541028027816ULL, 0x142fe40000000024ULL,
0x0000763228037816ULL, 0x000fe40000000024ULL, 0x000054104a247816ULL, 0x140fe40000000025ULL,
0x000076324a257816ULL, 0x000fe20000000025ULL, 0x0000000236007388ULL, 0x0003e20000000a00ULL,
0x0000541032287816ULL, 0x000fe40000000019ULL, 0x0000541056027816ULL, 0x002fc4000000003eULL,
0x0000763256037816ULL, 0x000fca000000003eULL, 0x0000000238007388ULL, 0x0003e40000000a00ULL,
0x0000541042027816ULL, 0x142fe40000000046ULL, 0x0000763242037816ULL, 0x000fca0000000046ULL,
0x0004000209007388ULL, 0x0003e80000000a00ULL, 0x0004002434007388ULL, 0x000fe20000000a00ULL,
0x000054102a027816ULL, 0x142fe40000000026ULL, 0x000076322a037816ULL, 0x000fca0000000026ULL,
0x0004000236007388ULL, 0x0003e40000000a00ULL, 0x000054100c027816ULL, 0x142fe40000000006ULL,
0x000076320c037816ULL, 0x000fe40000000006ULL, 0x000054100e067816ULL, 0x140fe40000000007ULL,
0x000076320e077816ULL, 0x000fe20000000007ULL, 0x000000023a007388ULL, 0x0003e40000000a00ULL,
0x0000541014027816ULL, 0x002fc40000000018ULL, 0x0000763214037816ULL, 0x000fe40000000018ULL,
0x0000002c2d18723eULL, 0x000fc600000010ffULL, 0x0008000209007388ULL, 0x0003e40000000a00ULL,
0x000054101c027816ULL, 0x142fe40000000020ULL, 0x000076321c037816ULL, 0x000fca0000000020ULL,
0x0008000234007388ULL, 0x0003e40000000a00ULL, 0x0000541030027816ULL, 0x142fe40000000018ULL,
0x0000763230037816ULL, 0x000fca0000000018ULL, 0x0008000236007388ULL, 0x0003e80000000a00ULL,
0x000000063c007388ULL, 0x000fe20000000a00ULL, 0x0000541016027816ULL, 0x142fe4000000001aULL,
0x0000763216037816ULL, 0x000fca000000001aULL, 0x000c000209007388ULL, 0x0003e40000000a00ULL,
0x000054101e027816ULL, 0x142fe4000000000fULL, 0x000076321e037816ULL, 0x000fca000000000fULL,
0x000c000234007388ULL, 0x0003e80000000a00ULL, 0x000c002836007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff00027306ULL, 0x002e620000202400ULL,
0x0000000061047984ULL, 0x000e680000000c00ULL, 0x0004000061107984ULL, 0x000ea80000000c00ULL,
0x0008000061187984ULL, 0x000ee80000000c00ULL, 0x000c000061207984ULL, 0x000f680000000c00ULL,
0x00100000610c7984ULL, 0x000ee80000000c00ULL, 0x0014000061147984ULL, 0x000f680000000c00ULL,
0x00180000611c7984ULL, 0x000f680000000c00ULL, 0x001c000061247984ULL, 0x000f620000000c00ULL,
0x0000000702077230ULL, 0x002fc40000200800ULL, 0x0000000602067230ULL, 0x040fe40000200800ULL,
0x0000000502057230ULL, 0x040fe40000200800ULL, 0x0000000402047230ULL, 0x040fe40000200800ULL,
0x0000001302137230ULL, 0x044fe40000200800ULL, 0x0000001202127230ULL, 0x040fe40000200800ULL,
0x0000001102117230ULL, 0x000fc40000200800ULL, 0x0000001002107230ULL, 0x040fe40000200800ULL,
0x0000001b021b7230ULL, 0x048fe40000200800ULL, 0x0000001a021a7230ULL, 0x040fe40000200800ULL,
0x0000001902197230ULL, 0x040fe40000200800ULL, 0x0000001802187230ULL, 0x040fe40000200800ULL,
0x0000002302237230ULL, 0x020fc40000200800ULL, 0x0000002202227230ULL, 0x040fe40000200800ULL,
0x0000002102217230ULL, 0x040fe40000200800ULL, 0x0000002002027230ULL, 0x000fe40000200800ULL,
0x0000000f07077230ULL, 0x000fe40000200000ULL, 0x0000000e06067230ULL, 0x000fe40000200000ULL,
0x0000000d05057230ULL, 0x000fc40000200000ULL, 0x0000000c04047230ULL, 0x000fe40000200000ULL,
0x0000001713137230ULL, 0x000fe40000200000ULL, 0x0000001612127230ULL, 0x000fe20000200000ULL,
0x0000000461007388ULL, 0x0003e20000000c00ULL, 0x0000001511117230ULL, 0x000fe40000200000ULL,
0x0000001410107230ULL, 0x000fe40000200000ULL, 0x0000001f1b1b7230ULL, 0x000fc40000200000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000200000ULL, 0x0004001061007388ULL, 0x0003e20000000c00ULL,
0x0000001d19197230ULL, 0x000fe40000200000ULL, 0x0000001c18187230ULL, 0x000fe40000200000ULL,
0x0000002723237230ULL, 0x000fe40000200000ULL, 0x0000002622227230ULL, 0x000fe20000200000ULL,
0x0008001861007388ULL, 0x0003e20000000c00ULL, 0x0000002521217230ULL, 0x000fc40000200000ULL,
0x0000002402207230ULL, 0x000fca0000200000ULL, 0x000c002061007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fc80000011600ULL, 0x0000000b0900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000000176047824ULL, 0x002fe200078e0209ULL, 0x0000000800067d06ULL, 0x000e620008209000ULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000700127812ULL, 0x000fca00078ec0ffULL, 0x0000000600067308ULL, 0x002e640000001000ULL,
0x0ffffffe06027836ULL, 0x002fcc0000000000ULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a03ULL,
0x0000000805057c24ULL, 0x000fc8000f8e02ffULL, 0x0000000503037227ULL, 0x000fc800078e0002ULL,
0x0000000109027824ULL, 0x000fe400078e0200ULL, 0x0000000403077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x0000000805007c0cULL, 0x000fda000bf06070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x0000000107070836ULL, 0x000fe20000000000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x0000000805007c0cULL, 0x000fe4000bf26070ULL, 0x0000000702057812ULL, 0x000fe400078ec0ffULL,
0x00000008ff027c12ULL, 0x000fe4000f8e33ffULL, 0x0ffffff805057812ULL, 0x000fca00078ef800ULL,
0x0000001005067824ULL, 0x000fe400078e0208ULL, 0x0000000107071836ULL, 0x000fc60000000000ULL,
0x00000000060c7984ULL, 0x0002a40000000c00ULL, 0x0000000702107207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a10ULL, 0x0000000910057c24ULL, 0x000fe4000f8e0279ULL,
0x0000000807047c24ULL, 0x000fe4000f8e0204ULL, 0x0000002000067836ULL, 0x002fe40000000000ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000877077824ULL, 0x000fe200078e0212ULL,
0x00000003ff097819ULL, 0x000fc40000011606ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4410ULL, 0x0000000b0900720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000176047824ULL, 0x102fe400078e0209ULL,
0x0000000106097824ULL, 0x000fe400078e0209ULL, 0x0000000403057227ULL, 0x000fc600078e00ffULL,
0x0000000709097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc600078e0a05ULL,
0x0ffffff809097812ULL, 0x000fe200078ef806ULL, 0x0000000807077c24ULL, 0x000fe2000f8e0204ULL,
0x0000000706067812ULL, 0x000fc600078ec0ffULL, 0x0000001009097824ULL, 0x000fe200078e0208ULL,
0x0000000807007c0cULL, 0x000fc8000bf26070ULL, 0x00000000090c7984ULL, 0x0002a40000000c00ULL,
0x0000004000097836ULL, 0x002fce0000000000ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000105051836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fda000bf46070ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x0000000502107207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a10ULL, 0x0000000910057c24ULL, 0x000fe4000f8e0279ULL,
0x0000000807047c24ULL, 0x000fe4000f8e0204ULL, 0x0000000877077824ULL, 0x000fe200078e0206ULL,
0x00000003ff067819ULL, 0x000fe20000011609ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4410ULL,
0x0000000b0600720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000176047824ULL, 0x102fe400078e0206ULL, 0x0000000109067824ULL, 0x000fe400078e0206ULL,
0x0000000403077227ULL, 0x000fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x8000000805051c36ULL, 0x000fe40008000000ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef809ULL, 0x0000001005067824ULL, 0x000fca00078e0208ULL,
0x00000000060c7984ULL, 0x0002a20000000c00ULL, 0x0000000107072836ULL, 0x000fca0000000000ULL,
0x0000000702107207ULL, 0x000fe20004000000ULL, 0x0000006000067836ULL, 0x002fc80000000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a10ULL, 0x0000000910057c24ULL, 0x000fe2000f8e0279ULL,
0x0000000709107812ULL, 0x000fe200078ec0ffULL, 0x0000000807047c24ULL, 0x000fe2000f8e0204ULL,
0x00000003ff097819ULL, 0x000fc60000011606ULL, 0x0000000805057c24ULL, 0x000fe4000f8e0204ULL,
0x0000000877077824ULL, 0x000fc600078e0210ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4412ULL, 0x0000000b0900720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000176047824ULL, 0x102fe400078e0209ULL,
0x0000000106097824ULL, 0x000fe400078e0209ULL, 0x0000000403057227ULL, 0x000fc600078e00ffULL,
0x0000000709097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc600078e0a05ULL,
0x0ffffff809097812ULL, 0x000fe200078ef806ULL, 0x0000000807077c24ULL, 0x000fe2000f8e0204ULL,
0x0000000706067812ULL, 0x000fc600078ec0ffULL, 0x0000001009097824ULL, 0x000fe200078e0208ULL,
0x0000000807007c0cULL, 0x000fc8000bf26070ULL, 0x00000000090c7984ULL, 0x0002a40000000c00ULL,
0x0000008000097836ULL, 0x002fce0000000000ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000105051836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fda000bf46070ULL,
0x0000000105052836ULL, 0x000fca0000000000ULL, 0x0000000502107207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a10ULL, 0x0000000910057c24ULL, 0x000fe4000f8e0279ULL,
0x0000000807047c24ULL, 0x000fe4000f8e0204ULL, 0x0000000877077824ULL, 0x000fe200078e0206ULL,
0x00000003ff067819ULL, 0x000fe20000011609ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4410ULL,
0x0000000b0600720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000176047824ULL, 0x102fe400078e0206ULL, 0x0000000109067824ULL, 0x000fe400078e0206ULL,
0x0000000403077227ULL, 0x000fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x8000000805051c36ULL, 0x000fe40008000000ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef809ULL, 0x0000001005067824ULL, 0x000fca00078e0208ULL,
0x00000000060c7984ULL, 0x0002a20000000c00ULL, 0x0000000107072836ULL, 0x000fca0000000000ULL,
0x0000000702107207ULL, 0x000fe40004000000ULL, 0x000000a000067810ULL, 0x002fc60007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe400078e0a10ULL, 0x0000000910057c24ULL, 0x000fe2000f8e0279ULL,
0x0000000709107812ULL, 0x000fe200078ec0ffULL, 0x0000000807047c24ULL, 0x000fe2000f8e0204ULL,
0x00000003ff097819ULL, 0x000fc60000011606ULL, 0x0000000805057c24ULL, 0x000fe4000f8e0204ULL,
0x0000000877077824ULL, 0x000fc600078e0210ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4412ULL, 0x0000000b0900720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000176047824ULL, 0x102fe400078e0209ULL,
0x0000000106097824ULL, 0x000fe400078e0209ULL, 0x0000000403057227ULL, 0x000fc600078e00ffULL,
0x0000000709097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc600078e0a05ULL,
0x0ffffff809097812ULL, 0x000fe200078ef806ULL, 0x0000000807077c24ULL, 0x000fe2000f8e0204ULL,
0x0000000706067812ULL, 0x000fc600078ec0ffULL, 0x0000001009097824ULL, 0x000fe200078e0208ULL,
0x0000000807007c0cULL, 0x000fc8000bf26070ULL, 0x00000000090c7984ULL, 0x0002a40000000c00ULL,
0x000000c000097836ULL, 0x002fce0000000000ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000105051836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fda000bf46070ULL,
0x0000000105052836ULL, 0x000fca0000000000ULL, 0x0000000502107207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a10ULL, 0x0000000910057c24ULL, 0x000fe4000f8e0279ULL,
0x0000000807047c24ULL, 0x000fe4000f8e0204ULL, 0x0000000877077824ULL, 0x000fe200078e0206ULL,
0x00000003ff067819ULL, 0x000fe20000011609ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4410ULL,
0x0000000b0600720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000176047824ULL, 0x102fe400078e0206ULL, 0x0000000109067824ULL, 0x000fe400078e0206ULL,
0x0000000403077227ULL, 0x000fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a07ULL, 0x000000e000007836ULL, 0x000fe40000000000ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x8000000805051c36ULL, 0x000fe40008000000ULL, 0x0000000107071836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef809ULL,
0x0000001005067824ULL, 0x000fca00078e0208ULL, 0x00000000060c7984ULL, 0x000e620000000c00ULL,
0x0000000107072836ULL, 0x000fca0000000000ULL, 0x0000000702107207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a10ULL, 0x0000000910057c24ULL, 0x000fe2000f8e0279ULL,
0x0000000709107812ULL, 0x000fe200078ec0ffULL, 0x0000000807047c24ULL, 0x000fe2000f8e0204ULL,
0x00000003ff097819ULL, 0x000fc60000011600ULL, 0x0000000805057c24ULL, 0x000fe4000f8e0204ULL,
0x0000000877077824ULL, 0x000fe400078e0210ULL, 0x0000000176767824ULL, 0x000fe200078e0209ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4412ULL,
0x0000000b0900720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0023ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000007603037227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x002fe400078e0a03ULL,
0x0000000100097824ULL, 0x000fe400078e0209ULL, 0x0000000805047c24ULL, 0x000fc6000f8e0276ULL,
0x0000000709097812ULL, 0x000fe400078ec0ffULL, 0x0000000804007c0cULL, 0x000fe4000bf26070ULL,
0xfffffff809097812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001009097824ULL, 0x000fe400078e0208ULL, 0x0000000877777824ULL, 0x000fc800078e0200ULL,
0x8000000804041c36ULL, 0x000fe40008000000ULL, 0x0000000103031836ULL, 0x000fc60000000000ULL,
0x0000000804007c0cULL, 0x000fe4000bf46070ULL, 0x0000000009047984ULL, 0x000e760000000c00ULL,
0x0000000103032836ULL, 0x000fca0000000000ULL, 0x0000000302027207ULL, 0x000fca0004000000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a02ULL, 0x0000000902037c24ULL, 0x000fe4000f8e0279ULL,
0x000000080b767c24ULL, 0x000fc8000f8e0276ULL, 0x0000000803037c24ULL, 0x000fca000f8e0276ULL,
0x000000030a037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000403027c11ULL, 0x000fc8000f8040ffULL, 0x0000000503037c11ULL, 0x000fc600080f4408ULL,
0x0000001077027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff7e7819ULL, 0x000fe20000011677ULL,
0x00009a00ff0e7b82ULL, 0x000e620000000a00ULL, 0xffffffff000d7802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x000000757e00720cULL, 0x000fda0003f06070ULL,
0x00009600ff048b82ULL, 0x000ea20000000800ULL, 0x000000027a058824ULL, 0x000fce00078e00ffULL,
0x00009200ff0a8b82ULL, 0x000ee20000000a00ULL, 0x000000060e6f7981ULL, 0x002322000c1e9900ULL,
0x0000000405058224ULL, 0x004fc800078e027eULL, 0x00000004050a8825ULL, 0x008fe400078e000aULL,
0x01a60011080479a7ULL, 0x000266000850003fULL, 0x000000060a0d8981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0700780cULL, 0x000fe20003f04070ULL, 0x0000008079797824ULL, 0x000fe400078e00ffULL,
0x00000040777c7824ULL, 0x000fe400078e00ffULL, 0x0000008000007824ULL, 0x000fc600078e00ffULL,
0x00000040790c7812ULL, 0x000fe200078ef87cULL, 0x0000000d00367224ULL, 0x004fc800078e02ffULL,
0x0000000c002c0947ULL, 0x002fea0003800000ULL, 0x00009000ff0e7b82ULL, 0x000e620000000a00ULL,
0x00000003ff2f7819ULL, 0x000fca0000011609ULL, 0x000000082f157836ULL, 0x000fe40000000000ULL,
0x000000010c0a7824ULL, 0x000fe400078e022fULL, 0x00000001150b7824ULL, 0x040fe400078e0209ULL,
0x0000000815247824ULL, 0x000fe400078e00ffULL, 0x000000042f137836ULL, 0x000fe40000000000ULL,
0x000000102f117836ULL, 0x000fe20000000000ULL, 0xfffffff824247812ULL, 0x000fe200078ee20bULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x0000000113077824ULL, 0x140fe200078e0209ULL,
0x000000700a167812ULL, 0x000fe200078ef802ULL, 0x0000000813227824ULL, 0x000fe200078e00ffULL,
0x0000000e360d7211ULL, 0x042fe200078038ffULL, 0x0000000c2f197836ULL, 0x000fe40000000000ULL,
0x00000001110a7824ULL, 0x140fe200078e0209ULL, 0xfffffff822227812ULL, 0x000fe200078ee207ULL,
0x00000008111b7824ULL, 0x000fe200078e00ffULL, 0x0000000f36077211ULL, 0x000fe200000f3cffULL,
0x00000001190e7824ULL, 0x040fe200078e0209ULL, 0x000000160d167210ULL, 0x000fe20007f1e0ffULL,
0x0000000819177824ULL, 0x000fe200078e00ffULL, 0x0000007c740f7248ULL, 0x000fe20007fe0000ULL,
0x000000010c107824ULL, 0x040fe200078e0219ULL, 0xfffffff81b287812ULL, 0x000fe200078ee20aULL,
0x000000010c0a7824ULL, 0x000fe200078e0213ULL, 0xfffffff817267812ULL, 0x000fe200078ee20eULL,
0x000000010b177824ULL, 0x000fc400000e0607ULL, 0x000000010f207824ULL, 0x000fe400078e0a7cULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0x000000201100720cULL, 0x080fe20003f06070ULL,
0x000000010c0e7824ULL, 0x040fe200078e0215ULL, 0x000000700a187812ULL, 0x000fe200078ef802ULL,
0x000000010c127824ULL, 0x000fe200078e0211ULL, 0x000000201300720cULL, 0x080fe20003fa6070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000d18187210ULL, 0x000fe40007f7e0ffULL,
0x000000201900720cULL, 0x080fe20003f46070ULL, 0x000000142f1f7836ULL, 0x000fe20000000000ULL,
0x00000070101c7812ULL, 0x000fe200078ef802ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000201500720cULL, 0x000fc60003f26070ULL, 0x000000010c147824ULL, 0x000fe200078e021fULL,
0x000000700e1a7812ULL, 0x000fe200078ef802ULL, 0x000000182f257836ULL, 0x000fe40000000000ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000d1a1a7210ULL, 0x000fc60007f9e0ffULL,
0x000000010b197824ULL, 0x000fe200018e0607ULL, 0x0000000d1c1c7210ULL, 0x000fe20007f7e0ffULL,
0x00004000770a7824ULL, 0x000fe200078e0208ULL, 0x00000070120e7812ULL, 0x000fe200078ef802ULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x000000010c0b7824ULL, 0x000fe200078e0225ULL,
0x0000007014107812ULL, 0x000fe200078ef802ULL, 0x000020000a217836ULL, 0x000fe40000000000ULL,
0x000000800b0a7825ULL, 0x000fc800078e00ffULL, 0x00000001111d7824ULL, 0x000fe200018e0607ULL,
0x0000000d0e0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000012f127824ULL, 0x000fe200078e0209ULL,
0x000000700a147812ULL, 0x000fe200078ef802ULL, 0x000000010f1b7824ULL, 0x100fe200020e0607ULL,
0x0000000d10107210ULL, 0x000fe20007f9e0ffULL, 0x00000001130f7824ULL, 0x100fe200018e0607ULL,
0x0000000712127812ULL, 0x000fe200078ec0ffULL, 0x0000001c2f277836ULL, 0x000fe20000000000ULL,
0x000000201f00720cULL, 0x080fe20003f66070ULL, 0x0000000115117824ULL, 0x000fe200020e0607ULL,
0x000000091f0a7210ULL, 0x000fe20007ffe0ffULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0x0000000d14147210ULL, 0x000fe20007fde0ffULL, 0x000000202f297836ULL, 0x000fe20000000000ULL,
0x0ffffff8121e7812ULL, 0x000fe200078ef809ULL, 0x000000010c127824ULL, 0x000fe200078e0227ULL,
0x000000202f00720cULL, 0x000fe20003f86070ULL, 0x000000010b157824ULL, 0x000fe200030e0607ULL,
0xfffffff81f2a7812ULL, 0x000fe200078ee20aULL, 0x00000080120a7825ULL, 0x000fc800078e00ffULL,
0x000000101e237824ULL, 0x000fe200078e0221ULL, 0x000000700a1e7812ULL, 0x000fe200078ef802ULL,
0x000000242f2b7836ULL, 0x000fe40000000000ULL, 0x000000010c127824ULL, 0x040fe200078e0229ULL,
0x0000000d1e1e7210ULL, 0x000fe20007fde0ffULL, 0x00000001250a7824ULL, 0x040fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0003e2000e101c46ULL,
0x00000008251f7824ULL, 0x040fe200078e00ffULL, 0x000000202500720cULL, 0x000fe20003f86070ULL,
0x000000010c257824ULL, 0x000fc400078e022bULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffff81f2c7812ULL, 0x000fc600078ee20aULL, 0x000000010b1f7824ULL, 0x000fe200030e0607ULL,
0x0000007012127812ULL, 0x000fe200078ef802ULL, 0x00000080250a7825ULL, 0x000fc600078e00ffULL,
0x0000000d12127210ULL, 0x000fe20007fde0ffULL, 0x0000001022237824ULL, 0x102fe200078e0221ULL,
0x000000700a167812ULL, 0x000fe200078ef802ULL, 0x0000001024257824ULL, 0x000fe400078e0221ULL,
0x000000282f2d7836ULL, 0x000fe20000000000ULL, 0x0000000018237faeULL, 0x0003e2000e901c46ULL,
0x0000000127177824ULL, 0x040fe200078e0209ULL, 0x000000202700720cULL, 0x0c0fe20003fa6070ULL,
0x0000000827227824ULL, 0x000fe200078e00ffULL, 0x000000001a257faeULL, 0x0005e2000c901c46ULL,
0x000000202900720cULL, 0x000fe20003f26070ULL, 0x0000000113137824ULL, 0x000fe200030e0607ULL,
0x0000000d16167210ULL, 0x000fe20007fde0ffULL, 0x000000010c0a7824ULL, 0x000fe200078e022dULL,
0xfffffff822227812ULL, 0x000fe200078ee217ULL, 0x000000082b247824ULL, 0x000fc400078e00ffULL,
0x0000000129187824ULL, 0x042fe400078e0209ULL, 0x0000000829297824ULL, 0x000fe400078e00ffULL,
0x000000010b177824ULL, 0x000fe400030e0607ULL, 0x0000001026197824ULL, 0x000fe200078e0221ULL,
0xfffffff829187812ULL, 0x000fe200078ee218ULL, 0x0000002c2f297836ULL, 0x000fe40000000000ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000001c197faeULL, 0x0003e2000d101c46ULL,
0x000000202b00720cULL, 0x000fc40003f46070ULL, 0x00000010281b7824ULL, 0x104fe200078e0221ULL,
0x000000700a0a7812ULL, 0x000fe200078ef802ULL, 0x0000001018257824ULL, 0x000fe400078e0221ULL,
0x000000012b237824ULL, 0x000fe200078e0209ULL, 0x000000000e1b7faeULL, 0x0005e2000c101c46ULL,
0x000000010c187824ULL, 0x000fe200078e0229ULL, 0x0000000d0a0a7210ULL, 0x000fe20007fde0ffULL,
0x0000003c2f2b7836ULL, 0x000fe20000000000ULL, 0xfffffff8241a7812ULL, 0x000fe200078ee223ULL,
0x000000102a197824ULL, 0x002fc400078e0221ULL, 0x000000102c1d7824ULL, 0x100fe200078e0221ULL,
0x000000202b00720cULL, 0x080fe20003f06070ULL, 0x0000001022237824ULL, 0x000fe200078e0221ULL,
0x0000000010197faeULL, 0x0003e2000d901c46ULL, 0x000000010b0b7824ULL, 0x000fe400030e0607ULL,
0x00000080180e7825ULL, 0x004fe200078e00ffULL, 0x00000000141d7faeULL, 0x0005e2000e101c46ULL,
0x000000202900720cULL, 0x080fe40003f86070ULL, 0x000000302f1b7836ULL, 0x000fe20000000000ULL,
0x000000700e0e7812ULL, 0x000fe200078ef802ULL, 0x000000001e237faeULL, 0x000fe2000e901c46ULL,
0x000000101a277824ULL, 0x000fe200078e0221ULL, 0x000000202d00720cULL, 0x080fe20003fa6070ULL,
0x000000342f197836ULL, 0x002fe20000000000ULL, 0x0000000012257faeULL, 0x0003e2000c901c46ULL,
0x000000201b00720cULL, 0x080fe20003f66070ULL, 0x000000082d187824ULL, 0x040fe200078e00ffULL,
0x000000382f1d7810ULL, 0x004fe20007ffe0ffULL, 0x000000010c107824ULL, 0x000fe200078e0219ULL,
0x0000000016277faeULL, 0x0005e2000d101c46ULL, 0x000000012d157824ULL, 0x000fe200078e0209ULL,
0x000000201900720cULL, 0x080fe20003f46070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000201d00720cULL, 0x000fc40003f26070ULL, 0xfffffff818187812ULL, 0x000fe200078ee215ULL,
0x000000082b227824ULL, 0x000fe200078e00ffULL, 0x0000000d0e127210ULL, 0x002fe20007fde0ffULL,
0x000000010c0e7824ULL, 0x000fe400078e021bULL, 0x0000000129167824ULL, 0x004fe400078e0209ULL,
0x000000010f137824ULL, 0x000fe400030e0607ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x000000700e147812ULL, 0x000fe200078ef802ULL,
0x000000011b0e7824ULL, 0x040fe400078e0209ULL, 0x000000081b1b7824ULL, 0x000fe200078e00ffULL,
0x0000000d14147210ULL, 0x000fe20007fde0ffULL, 0x0000000819177824ULL, 0x000fe200078e00ffULL,
0xfffffff8291a7812ULL, 0x000fe400078ee216ULL, 0xfffffff81b1c7812ULL, 0x000fe200078ee20eULL,
0x000000010c0e7824ULL, 0x000fe200078e021dULL, 0x0000007010167812ULL, 0x000fe200078ef802ULL,
0x000000010f157824ULL, 0x000fc400030e0607ULL, 0x0000000119107824ULL, 0x000fe200078e0209ULL,
0x0000000d16167210ULL, 0x000fe20007fde0ffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff8171e7812ULL, 0x000fe200078ee210ULL, 0x000000010c197824ULL, 0x000fe200078e022bULL,
0x000000700e0e7812ULL, 0x000fe200078ef802ULL, 0x0000000111177824ULL, 0x000fe400030e0607ULL,
0x0000008019107825ULL, 0x000fe200078e00ffULL, 0x0000000d0e0e7210ULL, 0x000fc60007fde0ffULL,
0x000000011d0c7824ULL, 0x140fe200078e0209ULL, 0x0000007010207812ULL, 0x000fe200078ef802ULL,
0x000000081d1d7824ULL, 0x000fe400078e00ffULL, 0x000000012b097824ULL, 0x000fe400078e0209ULL,
0x000000010f0f7824ULL, 0x000fe200030e0607ULL, 0xfffffff81d027812ULL, 0x000fe200078ee20cULL,
0x000000101a197824ULL, 0x100fe200078e0221ULL, 0xfffffff822107812ULL, 0x000fe200078ee209ULL,
0x0000001018097824ULL, 0x100fe200078e0221ULL, 0x0000000d200c7210ULL, 0x000fe20007fde0ffULL,
0x000000101c1b7824ULL, 0x000fc400078e0221ULL, 0x000000101e1d7824ULL, 0x100fe200078e0221ULL,
0x000000000a097faeULL, 0x0003e2000e901c46ULL, 0x00000010021f7824ULL, 0x100fe400078e0221ULL,
0x0000001010217824ULL, 0x000fe200078e0221ULL, 0x0000000012197faeULL, 0x0003e2000e101c46ULL,
0x00000001110d7824ULL, 0x000fc600030e0607ULL, 0x00000000141b7faeULL, 0x0003e8000d901c46ULL,
0x00000000161d7faeULL, 0x0003e8000d101c46ULL, 0x000000000e1f7faeULL, 0x0003e8000c901c46ULL,
0x000000000c217faeULL, 0x0003e2000c101c46ULL, 0x0000000800dc7947ULL, 0x000fea0003800000ULL,
0x0000000809117811ULL, 0x000fe200078fe8ffULL, 0x00004000772b7824ULL, 0x000fe200078e0208ULL,
0x0000000c09137811ULL, 0x040fe400078fe8ffULL, 0x00000004090f7811ULL, 0x000fe200078fe8ffULL,
0x00000001110a7824ULL, 0x100fe200078e0209ULL, 0x0000001809197811ULL, 0x000fe200078fe8ffULL,
0x0000000811177824ULL, 0x000fe200078e00ffULL, 0x0000001c091b7811ULL, 0x000fe200078fe8ffULL,
0x00000001130b7824ULL, 0x100fe200078e0209ULL, 0x0000002809217811ULL, 0x000fe200078fe8ffULL,
0x0000000813147824ULL, 0x000fe200078e00ffULL, 0xfffffff817127812ULL, 0x000fe200078ee20aULL,
0x000000010f077824ULL, 0x100fe200078e0209ULL, 0x0000001409177811ULL, 0x000fe200078fe8ffULL,
0x000000080f107824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee20bULL,
0x00000001190a7824ULL, 0x100fe200078e0209ULL, 0x0000002c09237811ULL, 0x000fe200078fe8ffULL,
0x00000008191f7824ULL, 0x000fe200078e00ffULL, 0x0000001009157811ULL, 0x000fe200078fe8ffULL,
0x000000011b0b7824ULL, 0x140fe200078e0209ULL, 0xfffffff810107812ULL, 0x000fe200078ee207ULL,
0x000000081b1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1a7812ULL, 0x000fe200078ee20aULL,
0x0000000117077824ULL, 0x100fe200078e0209ULL, 0x00000024091f7811ULL, 0x000fe200078fe8ffULL,
0x0000000817187824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL,
0x00000001210a7824ULL, 0x100fe200078e0209ULL, 0x0000000315167819ULL, 0x000fe200000006ffULL,
0x0000000821277824ULL, 0x000fe200078e00ffULL, 0x00000020091d7811ULL, 0x000fe200078fe8ffULL,
0x00000001230b7824ULL, 0x140fe200078e0209ULL, 0xfffffff818187812ULL, 0x000fe200078ee207ULL,
0x0000000823247824ULL, 0x000fe200078e00ffULL, 0xfffffff827227812ULL, 0x000fe200078ee20aULL,
0x00000001150d7824ULL, 0x100fe200078e0209ULL, 0x0000003009257811ULL, 0x000fe200078fe8ffULL,
0x000000011f077824ULL, 0x140fe200078e0209ULL, 0xfffffff824247812ULL, 0x000fe200078ee20bULL,
0x000000081f207824ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee20dULL,
0x00009000ff0a7b82ULL, 0x000e620000000a00ULL, 0x000000011d0d7824ULL, 0x000fe200078e0209ULL,
0x0000003409277811ULL, 0x000fe200078fe8ffULL, 0x000000081d1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee207ULL, 0x0000000825267824ULL, 0x000fe200078e00ffULL,
0x0000000909077211ULL, 0x000fe200078fe8ffULL, 0x000000010c2c7824ULL, 0x040fe200078e0223ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20dULL, 0x00000001250d7824ULL, 0x000fe200078e0209ULL,
0x0000003809287811ULL, 0x040fe200078fe8ffULL, 0x000000010c0f7824ULL, 0x040fe200078e020fULL,
0x0000003c09297811ULL, 0x000fe200078fe8ffULL, 0x000000010c117824ULL, 0x040fe200078e0211ULL,
0x00000007070e7812ULL, 0x000fe200078ec0ffULL, 0x000000010c137824ULL, 0x040fe200078e0213ULL,
0xfffffff826267812ULL, 0x000fe200078ee20dULL, 0x000000010c157824ULL, 0x040fe200078e0215ULL,
0x0000000c090d7211ULL, 0x000fe200078fe8ffULL, 0x000000010c177824ULL, 0x040fe200078e0217ULL,
0x000000290c347210ULL, 0x000fe20007ffe0ffULL, 0x000000010c197824ULL, 0x040fe200078e0219ULL,
0x0ffffff80e0e7812ULL, 0x000fe200078ef809ULL, 0x000000010c1b7824ULL, 0x000fe200078e021bULL,
0x0000000a36477211ULL, 0x002fe200078038ffULL, 0x000000010c1d7824ULL, 0x000fc400078e021dULL,
0x000000010c1f7824ULL, 0x000fe200078e021fULL, 0x0000000b36497211ULL, 0x000fe200000f3cffULL,
0x000000010c2a7824ULL, 0x040fe400078e0221ULL, 0x000000010c2e7824ULL, 0x040fe400078e0225ULL,
0x000000010c307824ULL, 0x040fe400078e0227ULL, 0x0000000127077824ULL, 0x000fe400078e0209ULL,
0x000000010c327824ULL, 0x000fc400078e0228ULL, 0x0000000128237824ULL, 0x100fe400078e0209ULL,
0x0000000129097824ULL, 0x040fe400078e0209ULL, 0x00000008290c7824ULL, 0x000fe400078e00ffULL,
0x0000000827387824ULL, 0x000fe400078e00ffULL, 0x000020002b457836ULL, 0x000fe20000000000ULL,
0xfffffff80c257812ULL, 0x000fe200078ee209ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff838217812ULL, 0x000fc600078ee207ULL, 0x000000100e077824ULL, 0x100fe200078e0245ULL,
0x000000700c0a7812ULL, 0x000fe200078ef802ULL, 0x0000001010097824ULL, 0x000fe400078e0245ULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x0000000a470a7210ULL, 0x000fc60007f1e0ffULL,
0x00000010122b7824ULL, 0x000fe200078e0245ULL, 0x000000700e0c7812ULL, 0x000fe200078ef802ULL,
0x0000008011107825ULL, 0x000fc600078e00ffULL, 0x0000000c470c7210ULL, 0x000fe20007f3e0ffULL,
0x0000008013127825ULL, 0x000fe200078e00ffULL, 0x00000070100e7812ULL, 0x000fc600078ef802ULL,
0x000000010d0b7824ULL, 0x000fe200000e0649ULL, 0x0000007012107812ULL, 0x000fe200078ef802ULL,
0x00000010142d7824ULL, 0x000fe200078e0245ULL, 0x0000000e470e7210ULL, 0x000fe20007f1e0ffULL,
0x0000008015147825ULL, 0x000fe200078e00ffULL, 0x0000001047107210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a077faeULL, 0x0003e4000b901c46ULL,
0x000000010f0d7824ULL, 0x000fe400008e0649ULL, 0x0000001020397824ULL, 0x000fe200078e0245ULL,
0x0000007014207812ULL, 0x000fe200078ef802ULL, 0x00000001110f7824ULL, 0x100fe200000e0649ULL,
0x000000000c097faeULL, 0x0003e2000b901c46ULL, 0x0000000113117824ULL, 0x000fe200010e0649ULL,
0x0000002047207210ULL, 0x000fe20007f1e0ffULL, 0x0000008017127825ULL, 0x000fe200078e00ffULL,
0x000000000e2b7faeULL, 0x0003e6000b901c46ULL, 0x00000010162f7824ULL, 0x100fe200078e0245ULL,
0x00000000102d7faeULL, 0x0003e2000b901c46ULL, 0x0000001018317824ULL, 0x000fc400078e0245ULL,
0x0000008019167825ULL, 0x000fc800078e00ffULL, 0x0000000828287824ULL, 0x000fe400078e00ffULL,
0x000000101a337824ULL, 0x000fe400078e0245ULL, 0x000000801b187825ULL, 0x000fe200078e00ffULL,
0xfffffff828237812ULL, 0x000fc600078ee223ULL, 0x00000010223b7824ULL, 0x000fe200078e0245ULL,
0x0000007012227812ULL, 0x000fe200078ef802ULL, 0x000000801d1a7825ULL, 0x000fc800078e00ffULL,
0x00000010243d7824ULL, 0x100fe200078e0245ULL, 0x0000007016247812ULL, 0x000fe200078ef802ULL,
0x00000010263f7824ULL, 0x100fe200078e0245ULL, 0x0000007018267812ULL, 0x000fe200078ef802ULL,
0x0000001021417824ULL, 0x000fe200078e0245ULL, 0x000000701a287812ULL, 0x000fe200078ef802ULL,
0x0000000115217824ULL, 0x000fe200000e0649ULL, 0x0000002247227210ULL, 0x000fe20007f1e0ffULL,
0x0000001023437824ULL, 0x100fe200078e0245ULL, 0x0000002447247210ULL, 0x000fe20007f3e0ffULL,
0x000000101c357824ULL, 0x100fe200078e0245ULL, 0x0000002647267210ULL, 0x000fe20007f5e0ffULL,
0x000000101e377824ULL, 0x000fe200078e0245ULL, 0x0000002847287210ULL, 0x000fe20007f7e0ffULL,
0x0000000113237824ULL, 0x000fe200000e0649ULL, 0x00000000202f7faeULL, 0x0003e2000b901c46ULL,
0x0000001025457824ULL, 0x000fc400078e0245ULL, 0x000000801f127825ULL, 0x000fe200078e00ffULL,
0x0000000022317faeULL, 0x0003e6000b901c46ULL, 0x0000000117257824ULL, 0x000fe200008e0649ULL,
0x0000007012127812ULL, 0x000fe200078ef802ULL, 0x000000802a147825ULL, 0x000fc600078e00ffULL,
0x0000001247127210ULL, 0x000fe20007f1e0ffULL, 0x0000000119277824ULL, 0x100fe200010e0649ULL,
0x0000007014147812ULL, 0x000fe200078ef802ULL, 0x000000802c167825ULL, 0x000fe200078e00ffULL,
0x0000000024337faeULL, 0x0003e4000b901c46ULL, 0x0000001447147210ULL, 0x000fe20007f3e0ffULL,
0x000000011b297824ULL, 0x000fe200018e0649ULL, 0x0000007016167812ULL, 0x000fe200078ef802ULL,
0x000000802e187825ULL, 0x000fe200078e00ffULL, 0x0000000026357faeULL, 0x0003e4000b901c46ULL,
0x0000001647167210ULL, 0x000fe20007f5e0ffULL, 0x00000080301a7825ULL, 0x000fe200078e00ffULL,
0x0000007018187812ULL, 0x000fe200078ef802ULL, 0x0000000028377faeULL, 0x0003e4000b901c46ULL,
0x00000080321c7825ULL, 0x000fe200078e00ffULL, 0x000000701a1a7812ULL, 0x000fc400078ef802ULL,
0x0000001847187210ULL, 0x000fe20007f7e0ffULL, 0x00000080341e7825ULL, 0x000fe200078e00ffULL,
0x000000701c1c7812ULL, 0x000fe400078ef802ULL, 0x0000001a471a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000113137824ULL, 0x100fe200000e0649ULL, 0x000000701e027812ULL, 0x000fe200078ef802ULL,
0x0000000115157824ULL, 0x100fe200008e0649ULL, 0x0000001c471c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000117177824ULL, 0x100fe200010e0649ULL, 0x00000002471e7210ULL, 0x000fe20007fde0ffULL,
0x0000000119197824ULL, 0x100fe200018e0649ULL, 0x0000000012397faeULL, 0x0003e2000b901c46ULL,
0x000000011b1b7824ULL, 0x000fc400020e0649ULL, 0x000000011d1d7824ULL, 0x100fe200028e0649ULL,
0x00000000143b7faeULL, 0x0003e2000b901c46ULL, 0x000000011f1f7824ULL, 0x000fc600030e0649ULL,
0x00000000163d7faeULL, 0x0003e8000b901c46ULL, 0x00000000183f7faeULL, 0x0003e8000b901c46ULL,
0x000000001a417faeULL, 0x0003e8000b901c46ULL, 0x000000001c437faeULL, 0x0003e8000b901c46ULL,
0x000000001e457faeULL, 0x0003e4000b901c46ULL, 0x000000027e7e7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff7b7424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x000000757e00720cULL, 0x000fda0003f06070ULL,
0x00009600ff028b82ULL, 0x000ea20000000800ULL, 0x000000027a078824ULL, 0x002fce00078e00ffULL,
0x00009200ff0a8b82ULL, 0x000e620000000a00ULL, 0x0000000207078224ULL, 0x004fc800078e027eULL,
0x00000004070a8825ULL, 0x002fca00078e000aULL, 0x000000060a7b8981ULL, 0x000322000c1e1900ULL,
0x0000001f04047890ULL, 0x000fc8000fffe03fULL, 0x000000053f047899ULL, 0x000fd80008011604ULL,
0x00000000000a7805ULL, 0x002fce0000015200ULL, 0x01a60005080075a7ULL, 0x000e62000800017fULL,
0x00000001746e7824ULL, 0x000fe400078e0a03ULL, 0x0000000406077c24ULL, 0x000fc6000f8e02ffULL,
0x00000008ff6e7819ULL, 0x000fe2000001166eULL, 0x00008e00ff987b82ULL, 0x000ea40000000a00ULL,
0x0000000407987825ULL, 0x004fe200078e0098ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x000000060a097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e0bULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011407ULL, 0x0000000902027211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000202027819ULL, 0x000fc80000001207ULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x01a60005080075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x0000002077027824ULL, 0x002fc800078e0202ULL, 0x0000000102067836ULL, 0x000fe20000000000ULL,
0x00000004ff047819ULL, 0x000fc80000011602ULL, 0x0ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x0000001f02047812ULL, 0x000fc600078ec0ffULL, 0x0000000105097824ULL, 0x000fe400078e0206ULL,
0x0000000102077824ULL, 0x000fe400078e0205ULL, 0x00000010040c7824ULL, 0x040fe200078e00ffULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x00000010040a7824ULL, 0x040fe200078e00ffULL,
0x0000000f07077812ULL, 0x000fe200078ec0ffULL, 0x0000000805057836ULL, 0x000fe20000000000ULL,
0x000001f00c097812ULL, 0x000fe200078ee209ULL, 0x00000010040b7824ULL, 0x000fe200078e00ffULL,
0x000001f00a077812ULL, 0x000fe200078ee207ULL, 0x0000000102027824ULL, 0x000fc400078e0205ULL,
0x0000001009097824ULL, 0x100fe400078e0208ULL, 0x0000001007077824ULL, 0x000fe200078e0208ULL,
0x0000000f02027812ULL, 0x000fe200078ec0ffULL, 0x0000000106057824ULL, 0x000fe200078e0205ULL,
0x00000000090c7984ULL, 0x000e620000000c00ULL, 0x0000001004157824ULL, 0x000fc600078e00ffULL,
0x0000000007107984ULL, 0x000ea20000000c00ULL, 0x0000000f05047812ULL, 0x000fe400078ec0ffULL,
0x000001f00b057812ULL, 0x000fe400078ee202ULL, 0x000001f0150b7812ULL, 0x000fc600078ee204ULL,
0x0000001005057824ULL, 0x100fe400078e0208ULL, 0x000000100b027824ULL, 0x000fe400078e0208ULL,
0x00000001ff0b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff167224ULL, 0x002fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff147224ULL, 0x004fc400078e0010ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fe200078e000fULL, 0x0000001407007388ULL, 0x000fe20000000c00ULL,
0x000000ffff187224ULL, 0x000fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fca00078e0013ULL,
0x0000001809007388ULL, 0x000fe80000000c00ULL, 0x00000000020c7984ULL, 0x000e680000000c00ULL,
0x0000000005107984ULL, 0x000ea20000000c00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000eULL,
0x000000ffff1e7224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe200078e000dULL,
0x00000011000c7202ULL, 0x004fe20000000f00ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff0d7224ULL, 0x000fc600078e0013ULL,
0x0000001c05007388ULL, 0x0003e80000000c00ULL, 0x0000000c02007388ULL, 0x0003e20000000c00ULL,
0x01a6000b080a79a7ULL, 0x0002a4000850003fULL, 0x0000000000047805ULL, 0x002fce0000015200ULL,
0x01a6000b080075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011407ULL, 0x0000000902027211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000202027819ULL, 0x000fc80000001207ULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x01a6000b080075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff6200720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00009600ff057b82ULL, 0x000e620000000800ULL,
0x0000000000097919ULL, 0x000ea20000000000ULL, 0x000001007c7c7836ULL, 0x000fe40000000000ULL,
0x3db504f36f6f7820ULL, 0x010fe20000410000ULL, 0x0000000877027824ULL, 0x140fe200078e0208ULL,
0x0000000104057899ULL, 0x000fe2000800063fULL, 0xffffffff03637836ULL, 0x000fe40000000000ULL,
0x00000009035d7836ULL, 0x000fe40000000000ULL, 0x0000002077787824ULL, 0x000fc400078e0208ULL,
0x000000ffff737224ULL, 0x000fe400078e00ffULL, 0x000000ffff0a7224ULL, 0x000fe400078e00ffULL,
0x000000057a7a7224ULL, 0x002fce00078e02ffULL, 0x0000000273057836ULL, 0x002fe20000000000ULL,
0x000000010a5c7812ULL, 0x000fe200078e0cffULL, 0x00000100735b7824ULL, 0x000fe400078e027cULL,
0x0000007b007b7224ULL, 0x010fe200078e02ffULL, 0x000000620500720cULL, 0x000fe40003f06070ULL,
0x000000405b047812ULL, 0x000fca00078ec0ffULL, 0x0000000179047824ULL, 0x000fcc00078e0204ULL,
0x0000000c00388947ULL, 0x000fea0003800000ULL, 0x00009000ff0c7b82ULL, 0x000e620000000a00ULL,
0x00000003ff277819ULL, 0x004fca0000011609ULL, 0x00000008270f7836ULL, 0x000fe40000000000ULL,
0x0000000427057836ULL, 0x000fe40000000000ULL, 0x000000010f0b7824ULL, 0x140fe400078e0209ULL,
0x000000080f0e7824ULL, 0x000fe400078e00ffULL, 0x0000000105067824ULL, 0x040fe400078e0209ULL,
0x0000000805217824ULL, 0x000fe200078e00ffULL, 0xfffffff80e237812ULL, 0x000fe200078ee20bULL,
0x00000010090b7824ULL, 0x000fe200078e00ffULL, 0x0000005b740e7248ULL, 0x000fe20007fe0000ULL,
0x0000001027137836ULL, 0x000fe20000000000ULL, 0xfffffff821217812ULL, 0x000fe200078ee206ULL,
0x0000000c27117836ULL, 0x000fe20000000000ULL, 0x000000700b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000813297824ULL, 0x000fe200078e00ffULL, 0x0000000c7b077211ULL, 0x002fe200078038ffULL,
0x00000001270c7824ULL, 0x000fe200078e0204ULL, 0x0000000411127210ULL, 0x000fe20007ffe0ffULL,
0x000000010e227824ULL, 0x000fe200078e0a5bULL, 0x0000000d7b067211ULL, 0x000fe200000f3cffULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0x000000220f00720cULL, 0x080fe20003f26070ULL,
0x00000014271b7836ULL, 0x000fe20000000000ULL, 0x0000000b0c167212ULL, 0x000fe200078efcffULL,
0x00000001130c7824ULL, 0x000fe200078e0209ULL, 0x000000221100720cULL, 0x080fe20003f46070ULL,
0x0000000113147824ULL, 0x100fe200078e0204ULL, 0x0000001607167210ULL, 0x000fe20007f1e0ffULL,
0x000000010f0e7824ULL, 0x100fe200078e0204ULL, 0xfffffff829297812ULL, 0x000fe200078ee20cULL,
0x00000001050c7824ULL, 0x040fe200078e0204ULL, 0x000000220500720cULL, 0x080fe20003fa6070ULL,
0x000000010d177824ULL, 0x000fe200000e0606ULL, 0x000000221300720cULL, 0x000fe20003f06070ULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000b0c1e7212ULL, 0x000fc600078efcffULL, 0x000000011b187824ULL, 0x000fe200078e0204ULL,
0x000000071e1e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000111107824ULL, 0x040fe200078e0209ULL,
0x0000000b12127212ULL, 0x000fe200078efcffULL, 0x0000000811257824ULL, 0x000fe400078e00ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee210ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000000b0e107212ULL, 0x000fc600078efcffULL,
0x000000010d1f7824ULL, 0x100fe200018e0606ULL, 0x0000000712127210ULL, 0x000fe20007f7e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000b180e7212ULL, 0x080fe400078efcffULL,
0x0000000710107210ULL, 0x000fe20007f9e0ffULL, 0x0000000113137824ULL, 0x100fe200018e0606ULL,
0x000000070e0e7210ULL, 0x000fe20007f7e0ffULL, 0x00000018271d7836ULL, 0x000fe20000000000ULL,
0x0000000b140c7212ULL, 0x000fe200078efcffULL, 0x000000010f117824ULL, 0x000fc400020e0606ULL,
0x00000001190f7824ULL, 0x000fe200018e0606ULL, 0x000000070c0c7210ULL, 0x000fe20007f9e0ffULL,
0x0000000127197824ULL, 0x000fe200078e0209ULL, 0x000000221b00720cULL, 0x080fe20003f66070ULL,
0x0000400077057824ULL, 0x000fe400078e0208ULL, 0x00000001150d7824ULL, 0x000fe200020e0606ULL,
0x00000007191a7812ULL, 0x000fe200078ec0ffULL, 0x000000011d147824ULL, 0x000fe200078e0204ULL,
0x000000222700720cULL, 0x000fe20003f86070ULL, 0x000020005c187824ULL, 0x000fe200078e0205ULL,
0x0ffffff81a197812ULL, 0x000fe200078ef809ULL, 0x0000001c272f7836ULL, 0x000fc40000000000ULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x0000200018187836ULL, 0x000fe20000000000ULL,
0x0000000b14147212ULL, 0x000fe200078efcffULL, 0x000000011b1c7824ULL, 0x040fe400078e0209ULL,
0x000000081b2b7824ULL, 0x000fe200078e00ffULL, 0x0000000714147210ULL, 0x000fe20007fde0ffULL,
0x000000012f1a7824ULL, 0x000fe400078e0204ULL, 0x0000002027317836ULL, 0x000fe20000000000ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee21cULL, 0x0000001019197824ULL, 0x000fc400078e0218ULL,
0x000000801a1a7825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e2000e101c46ULL, 0x00000001311c7824ULL, 0x000fe200078e0204ULL,
0x000000221d00720cULL, 0x040fe20003f86070ULL, 0x0000002427337836ULL, 0x000fe20000000000ULL,
0x0000000b1a1a7212ULL, 0x000fe200078efcffULL, 0x000000011d247824ULL, 0x040fe400078e0209ULL,
0x000000081d2d7824ULL, 0x000fe400078e00ffULL, 0x000000801c1c7825ULL, 0x000fc600078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee224ULL, 0x0000000133207824ULL, 0x000fe200078e0204ULL,
0x0000000b1c1c7212ULL, 0x000fe200078efcffULL, 0x0000000115157824ULL, 0x000fe200030e0606ULL,
0x000000071a1a7210ULL, 0x000fe20007fde0ffULL, 0x0000008020167825ULL, 0x002fc800078e00ffULL,
0x000000011b1b7824ULL, 0x000fe200030e0606ULL, 0x000000071c1c7210ULL, 0x000fe20007fde0ffULL,
0x0000001021197824ULL, 0x100fe200078e0218ULL, 0x0000000b16207212ULL, 0x000fe200078efcffULL,
0x000000012f217824ULL, 0x040fe400078e0209ULL, 0x000000082f167824ULL, 0x000fe200078e00ffULL,
0x000000001e197faeULL, 0x0003e2000e901c46ULL, 0x0000001023237824ULL, 0x000fe200078e0218ULL,
0x000000222f00720cULL, 0x080fe20003fa6070ULL, 0x0000002827357836ULL, 0x000fe20000000000ULL,
0xfffffff8162f7812ULL, 0x000fe200078ee221ULL, 0x000000011d1d7824ULL, 0x000fe200030e0606ULL,
0x0000000720207210ULL, 0x000fe20007fde0ffULL, 0x0000000135167824ULL, 0x000fe200078e0204ULL,
0x0000000010237faeULL, 0x0005e2000c901c46ULL, 0x000000223100720cULL, 0x000fe20003f26070ULL,
0x0000000833247824ULL, 0x000fc400078e00ffULL, 0x0000000117217824ULL, 0x000fe200030e0606ULL,
0x00000009311e7210ULL, 0x002fe20007ffe0ffULL, 0x0000001025197824ULL, 0x000fe400078e0218ULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0x0000000012197faeULL, 0x0003e2000d101c46ULL,
0x0000001029117824ULL, 0x004fe200078e0218ULL, 0x0000000b16167212ULL, 0x000fe200078efcffULL,
0x0000002c27297836ULL, 0x000fe20000000000ULL, 0x000000223300720cULL, 0x000fe20003f46070ULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0x000000000c117faeULL, 0x0005e2000c101c46ULL,
0x0000000129107824ULL, 0x000fe200078e0204ULL, 0x0000000716167210ULL, 0x000fe20007fde0ffULL,
0x00000001331f7824ULL, 0x000fe200078e0209ULL, 0xfffffff831237812ULL, 0x000fe200078ee21eULL,
0x000000102b137824ULL, 0x002fc400078e0218ULL, 0x00000030272b7836ULL, 0x000fe20000000000ULL,
0xfffffff824257812ULL, 0x000fe200078ee21fULL, 0x0000000117177824ULL, 0x000fe200030e0606ULL,
0x000000000e137faeULL, 0x0003e2000d901c46ULL, 0x00000080100c7825ULL, 0x004fe200078e00ffULL,
0x000000222b00720cULL, 0x000fc60003f66070ULL, 0x000000102d197824ULL, 0x000fe200078e0218ULL,
0x0000000b0c107212ULL, 0x000fe200078efcffULL, 0x000000012b0c7824ULL, 0x000fe400078e0204ULL,
0x00000034272d7836ULL, 0x000fe20000000000ULL, 0x0000000710107210ULL, 0x000fe20007fde0ffULL,
0x000000102f1f7824ULL, 0x100fe200078e0218ULL, 0x0000000014197faeULL, 0x0005e2000e101c46ULL,
0x0000001023237824ULL, 0x000fe200078e0218ULL, 0x000000222900720cULL, 0x080fe20003f86070ULL,
0x000000010d117824ULL, 0x000fe200030e0606ULL, 0x000000001a1f7faeULL, 0x0007e2000e901c46ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000223500720cULL, 0x000fc40003fa6070ULL,
0x000000001c237faeULL, 0x0009e2000c901c46ULL, 0x000000012d0e7824ULL, 0x002fe200078e0204ULL,
0x0000000b0c127212ULL, 0x000fe200078efcffULL, 0x000000012b0c7824ULL, 0x100fe400078e0209ULL,
0x0000000129147824ULL, 0x004fe200078e0209ULL, 0x0000000712127210ULL, 0x000fe20007fde0ffULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x00000008291b7824ULL, 0x008fe400078e00ffULL,
0x000000082b1d7824ULL, 0x010fe400078e00ffULL, 0x00000038272f7836ULL, 0x000fe20000000000ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee214ULL, 0x0000000135137824ULL, 0x140fe200078e0209ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee20cULL, 0x00000008351a7824ULL, 0x000fe200078e00ffULL,
0x0000000b0e147212ULL, 0x000fe200078efcffULL, 0x000000012f0c7824ULL, 0x040fe200078e0204ULL,
0x000000222f00720cULL, 0x080fe20003f26070ULL, 0x0000003c27277836ULL, 0x000fe20000000000ULL,
0xfffffff81a197812ULL, 0x000fe200078ee213ULL, 0x000000010d137824ULL, 0x000fe200030e0606ULL,
0x0000000714147210ULL, 0x000fe20007fde0ffULL, 0x000000012d157824ULL, 0x000fe200078e0209ULL,
0x000000222700720cULL, 0x000fe20003f06070ULL, 0x000000082d1a7824ULL, 0x000fc400078e00ffULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff81a1f7812ULL, 0x000fe200078ee215ULL,
0x00000001270e7824ULL, 0x000fe200078e0204ULL, 0x0000000b0c0c7212ULL, 0x080fe200078efcffULL,
0x0000001025257824ULL, 0x000fe400078e0218ULL, 0x000000010f157824ULL, 0x000fe200030e0606ULL,
0x000000070c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000020257faeULL, 0x0003e2000d101c46ULL, 0x000000222d00720cULL, 0x000fe40003f46070ULL,
0x000000012f047824ULL, 0x100fe200078e0209ULL, 0x0000000b0e0e7212ULL, 0x000fe200078efcffULL,
0x00000001271a7824ULL, 0x040fe200078e0209ULL, 0x000000060d0d7210ULL, 0x000fe200037fe4ffULL,
0x0000000827237824ULL, 0x000fe200078e00ffULL, 0x000000070e0e7210ULL, 0x000fe20007fde0ffULL,
0x0000001019077824ULL, 0x000fc400078e0218ULL, 0x000000101b0b7824ULL, 0x100fe200078e0218ULL,
0xfffffff823237812ULL, 0x000fe200078ee21aULL, 0x000000082f217824ULL, 0x002fe200078e00ffULL,
0x0000000016077faeULL, 0x0003e2000e901c46ULL, 0x000000101d197824ULL, 0x100fe400078e0218ULL,
0x000000101f1b7824ULL, 0x100fe200078e0218ULL, 0xfffffff821217812ULL, 0x000fe200078ee204ULL,
0x00000010231f7824ULL, 0x000fe200078e0218ULL, 0x00000000100b7faeULL, 0x0003e2000e101c46ULL,
0x000000010f0f7824ULL, 0x000fc400030e0606ULL, 0x00000010211d7824ULL, 0x000fe200078e0218ULL,
0x0000000012197faeULL, 0x0003e8000d901c46ULL, 0x00000000141b7faeULL, 0x0003e8000d101c46ULL,
0x000000000c1d7faeULL, 0x0003e8000c901c46ULL, 0x000000000e1f7faeULL, 0x0003e2000c101c46ULL,
0x0000000800e87947ULL, 0x000fea0003800000ULL, 0x0000000809107811ULL, 0x044fe400078fe8ffULL,
0x0000001809187811ULL, 0x040fe400078fe8ffULL, 0x0000001009147811ULL, 0x040fe200078fe8ffULL,
0x0000000110067824ULL, 0x140fe200078e0209ULL, 0x0000001409167811ULL, 0x040fe200078fe8ffULL,
0x00000008102d7824ULL, 0x000fe200078e00ffULL, 0x00000028091f7811ULL, 0x040fe200078fe8ffULL,
0x00000001180b7824ULL, 0x140fe200078e0209ULL, 0x00000004090e7811ULL, 0x040fe200078fe8ffULL,
0x00000008181c7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee206ULL,
0x0000000114067824ULL, 0x140fe200078e0209ULL, 0x00000024091e7811ULL, 0x040fe200078fe8ffULL,
0x0000000814317824ULL, 0x000fe200078e00ffULL, 0xfffffff81c357812ULL, 0x000fe200078ee20bULL,
0x0000000116077824ULL, 0x140fe200078e0209ULL, 0x00000020091c7811ULL, 0x040fe200078fe8ffULL,
0x00000008161a7824ULL, 0x000fe200078e00ffULL, 0x0000000c09127811ULL, 0x000fe200078fe8ffULL,
0x000000011f0b7824ULL, 0x140fe200078e0209ULL, 0xfffffff831317812ULL, 0x000fe200078ee206ULL,
0x000000081f227824ULL, 0x000fe200078e00ffULL, 0xfffffff81a337812ULL, 0x000fe200078ee207ULL,
0x000000010e057824ULL, 0x140fe200078e0209ULL, 0x0000003009217811ULL, 0x040fe200078fe8ffULL,
0x000000080e0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8223d7812ULL, 0x000fe200078ee20bULL,
0x000000011c067824ULL, 0x140fe200078e0209ULL, 0x0000003409227811ULL, 0x040fe200078fe8ffULL,
0x000000081c397824ULL, 0x000fe200078e00ffULL, 0xfffffff80c2b7812ULL, 0x000fe200078ee205ULL,
0x000000011e077824ULL, 0x140fe200078e0209ULL, 0x0000001c091a7811ULL, 0x040fe200078fe8ffULL,
0x000000081e207824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee206ULL,
0x0000000112057824ULL, 0x140fe200078e0209ULL, 0x0000003809247811ULL, 0x000fe200078fe8ffULL,
0x00000008120c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8203b7812ULL, 0x000fe200078ee207ULL,
0x0000000121067824ULL, 0x100fe200078e0209ULL, 0x0000002c09207811ULL, 0x000fe200078fe8ffULL,
0x0000000821417824ULL, 0x000fe200078e00ffULL, 0xfffffff80c2f7812ULL, 0x000fe200078ee205ULL,
0x0000000122077824ULL, 0x140fe200078e0209ULL, 0x0000003c090d7811ULL, 0x000fe200078fe8ffULL,
0x0000000822267824ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee206ULL,
0x000000011a057824ULL, 0x000fc400078e0209ULL, 0x000000081a0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff826437812ULL, 0x000fe200078ee207ULL, 0x00000001240b7824ULL, 0x140fe200078e0209ULL,
0x00009000ff067b82ULL, 0x000e620000000a00ULL, 0x0000000824287824ULL, 0x000fe200078e00ffULL,
0xfffffff80c377812ULL, 0x000fe200078ee205ULL, 0x0000000120057824ULL, 0x140fe400078e0209ULL,
0x00000008200c7824ULL, 0x000fe200078e00ffULL, 0xfffffff828457812ULL, 0x000fe200078ee20bULL,
0x000000010d267824ULL, 0x100fe200078e0204ULL, 0x00000009090b7211ULL, 0x000fe200078fe8ffULL,
0x000000010d0f7824ULL, 0x040fe200078e0209ULL, 0xfffffff80c3f7812ULL, 0x000fe200078ee205ULL,
0x000000080d2a7824ULL, 0x000fe200078e00ffULL, 0x0000000877057211ULL, 0x000fe200078e70ffULL,
0x000000010e0e7824ULL, 0x100fe200078e0204ULL, 0x000000070b287812ULL, 0x000fe200078ec0ffULL,
0x0000000110107824ULL, 0x100fe200078e0204ULL, 0x00000004090c7211ULL, 0x000fe200078fe8ffULL,
0x0000000112127824ULL, 0x100fe200078e0204ULL, 0x0ffffff8280b7812ULL, 0x000fe200078ef809ULL,
0x0000000114147824ULL, 0x100fe200078e0204ULL, 0xfffffff82a0f7812ULL, 0x000fe200078ee20fULL,
0x0000000116167824ULL, 0x000fc400078e0204ULL, 0x0000000118187824ULL, 0x100fe200078e0204ULL,
0x000000067b4b7211ULL, 0x042fe200078038ffULL, 0x000000011a1a7824ULL, 0x100fe400078e0204ULL,
0x000000011c1c7824ULL, 0x100fe200078e0204ULL, 0x000000077b7b7211ULL, 0x000fe200000f3cffULL,
0x000000011e1e7824ULL, 0x100fe400078e0204ULL, 0x000000011f1f7824ULL, 0x100fe400078e0204ULL,
0x0000000120207824ULL, 0x000fc400078e0204ULL, 0x0000000121217824ULL, 0x100fe400078e0204ULL,
0x0000000122227824ULL, 0x100fe400078e0204ULL, 0x0000000124247824ULL, 0x000fe400078e0204ULL,
0x000020005c0d7824ULL, 0x000fe400078e0205ULL, 0x0000001009047824ULL, 0x000fe400078e00ffULL,
0x000020000d287836ULL, 0x000fc40000000000ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000007004497812ULL, 0x000fe400078ec0ffULL, 0x000000280f477211ULL, 0x000fe200078e20ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000490c067212ULL, 0x000fc600078efcffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000064b067210ULL, 0x000fe40007f1e0ffULL,
0x000000490e0c7212ULL, 0x080fe200078efcffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x00000049100e7212ULL, 0x080fe400078efcffULL, 0x0000000c4b0c7210ULL, 0x000fe20007f3e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000004912107212ULL, 0x000fc600078efcffULL,
0x000000010d077824ULL, 0x100fe200000e067bULL, 0x0000000e4b0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004914127212ULL, 0x080fe400078efcffULL,
0x000000104b107210ULL, 0x000fe20007f5e0ffULL, 0x000000010f0d7824ULL, 0x000fe200008e067bULL,
0x0000004916147212ULL, 0x000fe200078efcffULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x00000001110f7824ULL, 0x000fe200000e067bULL, 0x000000124b127210ULL, 0x000fe20007f1e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000004918167212ULL, 0x000fc600078efcffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000491a187212ULL, 0x000fe400078efcffULL,
0x000000164b167210ULL, 0x000fe20007f3e0ffULL, 0x000000100b0b7824ULL, 0x100fe400078e0228ULL,
0x000000102b2b7824ULL, 0x100fe400078e0228ULL, 0x000000102d2d7824ULL, 0x100fe200078e0228ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e2000b901c46ULL,
0x000000102f2f7824ULL, 0x000fc400078e0228ULL, 0x0000001031317824ULL, 0x100fe200078e0228ULL,
0x000000000c2b7faeULL, 0x0003e2000b901c46ULL, 0x0000001033337824ULL, 0x100fe400078e0228ULL,
0x0000001035357824ULL, 0x100fe200078e0228ULL, 0x000000000e2d7faeULL, 0x0003e2000b901c46ULL,
0x0000001037377824ULL, 0x100fe400078e0228ULL, 0x0000001039397824ULL, 0x100fe400078e0228ULL,
0x000000103b3b7824ULL, 0x000fc400078e0228ULL, 0x000000103d3d7824ULL, 0x100fe400078e0228ULL,
0x000000103f3f7824ULL, 0x100fe400078e0228ULL, 0x0000001041417824ULL, 0x100fe400078e0228ULL,
0x0000001043437824ULL, 0x100fe400078e0228ULL, 0x0000001045457824ULL, 0x000fe200078e0228ULL,
0x000000491c287212ULL, 0x080fe200078efcffULL, 0x0000000113117824ULL, 0x100fe200010e067bULL,
0x000000184b187210ULL, 0x000fe20007f5e0ffULL, 0x0000000115137824ULL, 0x100fe200000e067bULL,
0x000000144b147210ULL, 0x000fe20007f1e0ffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x000000284b287210ULL, 0x000fe20007f7e0ffULL, 0x00000000102f7faeULL, 0x0003e4000b901c46ULL,
0x0000000117157824ULL, 0x100fe200000e067bULL, 0x0000004922227212ULL, 0x000fe200078efcffULL,
0x0000000119177824ULL, 0x100fe200008e067bULL, 0x0000000012317faeULL, 0x0003e2000b901c46ULL,
0x000000011b197824ULL, 0x100fe200010e067bULL, 0x000000224b227210ULL, 0x000fe20007f9e0ffULL,
0x000000011d297824ULL, 0x000fe200018e067bULL, 0x0000000014337faeULL, 0x0003e2000b901c46ULL,
0x000000801e1a7825ULL, 0x000fc600078e00ffULL, 0x0000000016357faeULL, 0x0003e2000b901c46ULL,
0x000000801f1c7825ULL, 0x000fe200078e00ffULL, 0x000000491a1a7212ULL, 0x080fe400078efcffULL,
0x0000000018377faeULL, 0x0003e2000b901c46ULL, 0x00000080201e7825ULL, 0x000fe200078e00ffULL,
0x000000491c1c7212ULL, 0x080fe400078efcffULL, 0x0000001a4b1a7210ULL, 0x000fe20007f1e0ffULL,
0x0000008021207825ULL, 0x000fe200078e00ffULL, 0x000000491e1e7212ULL, 0x080fe200078efcffULL,
0x0000000028397faeULL, 0x0003e2000b901c46ULL, 0x0000001c4b1c7210ULL, 0x000fe20007f3e0ffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000004920207212ULL, 0x000fc400078efcffULL,
0x0000001e4b1e7210ULL, 0x000fe20007f5e0ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000004924247212ULL, 0x080fe400078efcffULL, 0x000000204b207210ULL, 0x000fe20007f7e0ffULL,
0x000000011b1b7824ULL, 0x100fe200000e067bULL, 0x0000004926267212ULL, 0x000fe200078efcffULL,
0x000000011d1d7824ULL, 0x100fe200008e067bULL, 0x000000244b247210ULL, 0x000fe20007fbe0ffULL,
0x000000011f1f7824ULL, 0x100fe200010e067bULL, 0x000000264b267210ULL, 0x000fe20007fde0ffULL,
0x0000000121217824ULL, 0x100fe200018e067bULL, 0x000000001a3b7faeULL, 0x0003e2000b901c46ULL,
0x0000000123237824ULL, 0x000fc400020e067bULL, 0x0000000125257824ULL, 0x100fe200028e067bULL,
0x000000001c3d7faeULL, 0x0003e2000b901c46ULL, 0x0000000127277824ULL, 0x000fc600030e067bULL,
0x000000001e3f7faeULL, 0x0003e8000b901c46ULL, 0x0000000020417faeULL, 0x0003e8000b901c46ULL,
0x0000000022437faeULL, 0x0003e8000b901c46ULL, 0x0000000024457faeULL, 0x0003e8000b901c46ULL,
0x0000000026477faeULL, 0x0003e4000b901c46ULL, 0x000000027e7e7836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff7b7424ULL, 0x000fc600078e00ffULL,
0x000000757e00720cULL, 0x000fda0003f06070ULL, 0x00009200ff0c8b82ULL, 0x002e620000000a00ULL,
0x000000027a078824ULL, 0x000fe200078e027eULL, 0x00000008095a7812ULL, 0x040fe200078ec0ffULL,
0x0000002009707836ULL, 0x000fe40000000000ULL, 0x000020000a597824ULL, 0x000fe200078e0205ULL,
0x00000004ff0b7819ULL, 0x000fe20000011609ULL, 0x000000ffff727224ULL, 0x000fe200078e00ffULL,
0x0000000709587812ULL, 0x000fe400078ec0ffULL, 0x0000000000167805ULL, 0x000fc4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fc4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x00000004070c8825ULL, 0x002fe200078e000cULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x000000060c7b8981ULL, 0x000322000c1e1900ULL,
0xfffffff8090a7812ULL, 0x000fc400078ec0ffULL, 0x0000000000067805ULL, 0x000fe4000001ff00ULL,
0xfffffff870707812ULL, 0x000fe400078ec0ffULL, 0x0000000000047805ULL, 0x000fe4000001ff00ULL,
0x000000075a5a7812ULL, 0x000fe400078ef809ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x000000070a717812ULL, 0x000fc400078ef809ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x0000000000467805ULL, 0x000fe4000001ff00ULL,
0x0000000000447805ULL, 0x000fc4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fe4000001ff00ULL, 0x00000000004e7805ULL, 0x000fe4000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000200059597836ULL, 0x000fe20000000000ULL,
0x0000000770707812ULL, 0x000fe200078ef809ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000105a0a7812ULL, 0x002fce00078efcffULL, 0x00000001710c7824ULL, 0x140fe400078e0272ULL,
0x00000008710d7824ULL, 0x000fe400078e00ffULL, 0x0000000170107824ULL, 0x040fe400078e0272ULL,
0x0000000870117824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0c7812ULL, 0x000fe200078ee20cULL,
0x0000000272957824ULL, 0x000fe400078e020bULL, 0x000000100aa17824ULL, 0x000fe200078e00ffULL,
0xfffffff811107812ULL, 0x000fe200078ee210ULL, 0x000000100c0c7824ULL, 0x000fc800078e0259ULL,
0x0000001010107824ULL, 0x000fe400078e0259ULL, 0x000000000c0c783bULL, 0x000e680000000200ULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x00000018ff507819ULL, 0x002fe2000001140cULL,
0x000100000c527824ULL, 0x040fe200078e00ffULL, 0x000088800c517816ULL, 0x040fe200000000ffULL,
0x000001000c0c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001140dULL,
0x000100000d547824ULL, 0x040fe200078e00ffULL, 0x000088800d6a7816ULL, 0x040fe200000000ffULL,
0x000001000d0d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x0000005100517306ULL, 0x000fe20000202400ULL, 0x00000018ff6d7819ULL, 0x000fc4000001140eULL,
0x000088800e6c7816ULL, 0x000fe400000000ffULL, 0x00000018ff0d7819ULL, 0x000fe4000001140dULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000000c00537306ULL, 0x0003e20000202400ULL,
0x00000018ff657819ULL, 0x004fe40000011410ULL, 0x0000888010647816ULL, 0x000fe400000000ffULL,
0x00000018ff677819ULL, 0x000fc40000011411ULL, 0x0000888011667816ULL, 0x000fe200000000ffULL,
0x0000000d00847306ULL, 0x0005e20000202400ULL, 0x000100000e0c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe2000001140fULL, 0x000001000e0e7824ULL, 0x000fe200078e00ffULL,
0x000088800f607816ULL, 0x040fe400000000ffULL, 0x00000018ff0c7819ULL, 0x000fe4000001140cULL,
0x00000018ff0e7819ULL, 0x000fe2000001140eULL, 0x00000054009f7306ULL, 0x0003e20000202400ULL,
0x000000100f0d7819ULL, 0x044fe200000006ffULL, 0x000001000f0f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fc40000011452ULL, 0x00000018ff0d7819ULL, 0x000fe4000001140dULL,
0x00000018ff0f7819ULL, 0x000fe2000001140fULL, 0x0000000e009e7306ULL, 0x0005e20000202400ULL,
0x0000000871547824ULL, 0x002fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe40000011412ULL,
0x00000018ff5f7819ULL, 0x000fe40000011413ULL, 0x0000888012687816ULL, 0x000fe400000000ffULL,
0x0000000d008f7306ULL, 0x0003e20000202400ULL, 0x00000001720e7836ULL, 0x004fe20000000000ULL,
0x00008880135e7816ULL, 0x000fe200000000ffULL, 0x0000000272727836ULL, 0x000fca0000000000ULL,
0x0000000c009d7306ULL, 0x0005e20000202400ULL, 0x00000001710d7824ULL, 0x102fe200078e020eULL,
0x000000087200780cULL, 0x000fe20003f05270ULL, 0x00000001700e7824ULL, 0x000fc600078e020eULL,
0xfffffff854547812ULL, 0x000fe200078ee20dULL, 0x00010000110d7824ULL, 0x040fe200078e00ffULL,
0x0000005200527306ULL, 0x000e620000202400ULL, 0x00010000100c7824ULL, 0x004fe400078e00ffULL,
0x0000001054547824ULL, 0x000fe200078e0259ULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x0000000f009c7306ULL, 0x0005e20000202400ULL,
0x000000005454783bULL, 0x000ee20000000200ULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x00000018ff117819ULL, 0x000fc80000011411ULL, 0x00000010009a7306ULL, 0x000be20000202400ULL,
0x00000008700f7824ULL, 0x004fca00078e00ffULL, 0xfffffff80f0e7812ULL, 0x000fe400078ee20eULL,
0x0000001100967306ULL, 0x0005e20000202400ULL, 0x0001000013107824ULL, 0x060fe400078e00ffULL,
0x0000010013137824ULL, 0x000fe400078e00ffULL, 0x000000100e0e7824ULL, 0x000fe200078e0259ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000000c009b7306ULL, 0x000be20000202400ULL,
0x000000105a117824ULL, 0x004fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fcc0000011413ULL,
0x0000001000937306ULL, 0x0005e20000202400ULL, 0x00010000120c7824ULL, 0x060fe400078e00ffULL,
0x0000010012127824ULL, 0x000fc600078e00ffULL, 0x00000018ff977819ULL, 0x000fe4000001140cULL,
0x0000005000507306ULL, 0x000f620000202400ULL, 0x000000015a107824ULL, 0x004fe200078e0295ULL,
0x00000018ff8b7819ULL, 0x008fe20000011454ULL, 0x0001000055867824ULL, 0x040fe200078e00ffULL,
0x00008880548d7816ULL, 0x040fe400000000ffULL, 0xfffffff011117812ULL, 0x000fe200078ee210ULL,
0x0001000054107824ULL, 0x040fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011455ULL,
0x0000010054547824ULL, 0x000fe200078e00ffULL, 0x0000888055897816ULL, 0x040fe200000000ffULL,
0x0000010055557824ULL, 0x000fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0000001011117824ULL, 0x000fe200078e0208ULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000001300947306ULL, 0x000fe20000202400ULL, 0x00000018ff8a7819ULL, 0x000fe20000011455ULL,
0x0001000056557824ULL, 0x000fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fc40000011410ULL,
0x00000018ff837819ULL, 0x000fe40000011456ULL, 0x00000018ff887819ULL, 0x000fe20000011455ULL,
0x00000054008e7306ULL, 0x0005e20000202400ULL, 0x0000888056877816ULL, 0x040fe200000000ffULL,
0x0000010056567824ULL, 0x000fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe40000011486ULL,
0x00000018ff827819ULL, 0x000fc60000011457ULL, 0x0000001200927306ULL, 0x0007e20000202400ULL,
0x000000010a547824ULL, 0x004fe400078e0295ULL, 0x0000000295957836ULL, 0x000fc60000000000ULL,
0xfffffff0a1557812ULL, 0x000fe400078ee254ULL, 0x0000541051547816ULL, 0x002fe20000000052ULL,
0x0000000d00917306ULL, 0x0003e20000202400ULL, 0x000000001110783bULL, 0x008ea20000000200ULL,
0x0000001055517824ULL, 0x000fe200078e0208ULL, 0x0000541053557816ULL, 0x020fca0000000050ULL,
0x000000005150783bULL, 0x000ee20000000200ULL, 0x0000006b006b7306ULL, 0x000f660000202400ULL,
0x000000000e0c783bULL, 0x002e6a0000000200ULL, 0x0000006d006d7306ULL, 0x000f640000202400ULL,
0x00005410846b7816ULL, 0x020fcc000000006bULL, 0x0000006100617306ULL, 0x000f620000202400ULL,
0x000054109e6d7816ULL, 0x000fce000000006dULL, 0x0000006500657306ULL, 0x000e620000202400ULL,
0x000054109c617816ULL, 0x020fce0000000061ULL, 0x0000006700677306ULL, 0x000f620000202400ULL,
0x00000054104c723cULL, 0x004fe2000004184cULL, 0x000054109a657816ULL, 0x002fcc0000000065ULL,
0x0000006900697306ULL, 0x000e620000202400ULL, 0x00000054502c723cULL, 0x008fe2000004182cULL,
0x00000018ff817819ULL, 0x000fe4000001140cULL, 0x00000018ff807819ULL, 0x000fe4000001140dULL,
0x0000541096677816ULL, 0x020fe40000000067ULL, 0x0000005f005f7306ULL, 0x000ea20000202400ULL,
0x000100000c967824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fc4000001140eULL,
0x00000018ff7d7819ULL, 0x000fe4000001140fULL, 0x0000541092697816ULL, 0x002fe40000000069ULL,
0x0000006a006a7306ULL, 0x000e620000202400ULL, 0x00005410945f7816ULL, 0x004fce000000005fULL,
0x0000006c006c7306ULL, 0x000ea20000202400ULL, 0x000054106a6a7816ULL, 0x002fce000000009fULL,
0x0000006000607306ULL, 0x000e620000202400ULL, 0x0000006a1048723cULL, 0x000fe20000041848ULL,
0x000054106c6c7816ULL, 0x004fcc000000009dULL, 0x0000006400647306ULL, 0x000ea20000202400ULL,
0x00010000579d7824ULL, 0x000fe200078e00ffULL, 0x0000006a5028723cULL, 0x000fe20000041828ULL,
0x0000541060607816ULL, 0x002fca000000008fULL, 0x0000006600667306ULL, 0x000e620000202400ULL,
0x00000018ff8f7819ULL, 0x000fe2000001149dULL, 0x0000006c1044723cULL, 0x000fe20000041844ULL,
0x0000541064647816ULL, 0x004fca000000009bULL, 0x0000006800687306ULL, 0x000fe20000202400ULL,
0x000000601040723cULL, 0x000fe20000041840ULL, 0x0000541066667816ULL, 0x002fcc0000000091ULL,
0x0000009700977306ULL, 0x000e620000202400ULL, 0x00000064103c723cULL, 0x000fec000004183cULL,
0x000000661038723cULL, 0x000fe20000041838ULL, 0x0000005e005e7306ULL, 0x000eaa0000202400ULL,
0x00000064501c723cULL, 0x000fe2000004181cULL, 0x0000541068687816ULL, 0x002fc40000000097ULL,
0x00000086008c7306ULL, 0x0003e60000202400ULL, 0x000000605020723cULL, 0x000fe20000041820ULL,
0x000054105e5e7816ULL, 0x004fc80000000093ULL, 0x0000007f007f7306ULL, 0x000fe20000202400ULL,
0x00000018ff867819ULL, 0x002fe20000011456ULL, 0x000000681034723cULL, 0x000fe20000041834ULL,
0x0000888057567816ULL, 0x040fe200000000ffULL, 0x0000010057577824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fc60000011496ULL, 0x0000005600847306ULL, 0x0003e20000202400ULL,
0x0000005e1030723cULL, 0x000fe20000041830ULL, 0x00000018ff577819ULL, 0x000fca0000011457ULL,
0x0000006c5024723cULL, 0x000fe20000041824ULL, 0x000088800d107816ULL, 0x040fe200000000ffULL,
0x000000105a117824ULL, 0x000fe200078e00ffULL, 0x000088800c567816ULL, 0x042fe200000000ffULL,
0x000001000c0c7824ULL, 0x000fe200078e00ffULL, 0x0000005700917306ULL, 0x000fe20000202400ULL,
0x000000ffff6a7224ULL, 0x000fe200078e0010ULL, 0x000088800e107816ULL, 0x000fe200000000ffULL,
0x000000100a127824ULL, 0x040fe200078e00ffULL, 0x00000018ff947819ULL, 0x000fe2000001140cULL,
0x000000665018723cULL, 0x000fe20000041818ULL, 0x000000955a0c7210ULL, 0x000fe20007ffe0ffULL,
0x000000010a957824ULL, 0x000fe200078e0295ULL, 0x0000005600927306ULL, 0x0003e20000202400ULL,
0x000000ffff647224ULL, 0x000fe200078e0010ULL, 0xfffffff011117812ULL, 0x000fe200078ee20cULL,
0x000100000e107824ULL, 0x040fe200078e00ffULL, 0xfffffff012957812ULL, 0x000fe200078ee295ULL,
0x000100000d0c7824ULL, 0x000fe200078e00ffULL, 0x000000685014723cULL, 0x000fe20000041814ULL,
0x0000001011117824ULL, 0x000fe200078e0208ULL, 0x00000018ff657819ULL, 0x000fe20000011410ULL,
0x0000001095107824ULL, 0x000fe200078e0208ULL, 0x000088800f677816ULL, 0x000fe200000000ffULL,
0x000001000d0d7824ULL, 0x000fe200078e00ffULL, 0x000000001154783bULL, 0x002e620000000200ULL,
0x000001000e0e7824ULL, 0x000fe200078e00ffULL, 0x0000005e5004723cULL, 0x000fe20000041804ULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x000000001010783bULL, 0x000ea20000000200ULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x00000018ff0e7819ULL, 0x000fc4000001140eULL, 0x000001000f507824ULL, 0x000fca00078e00ffULL,
0x0000000d00617306ULL, 0x0007e20000202400ULL, 0x00000018ff527819ULL, 0x000fce0000011450ULL,
0x0000006500657306ULL, 0x000f620000202400ULL, 0x000100000f0d7824ULL, 0x008fca00078e00ffULL,
0x00000018ff687819ULL, 0x000fe4000001140dULL, 0x0000000e00667306ULL, 0x000ee20000202400ULL,
0x0000541064647816ULL, 0x020fce0000000065ULL, 0x0000006700677306ULL, 0x000fe20000202400ULL,
0x0000541066657816ULL, 0x008fce000000007fULL, 0x0000006800687306ULL, 0x000ee20000202400ULL,
0x000000645434723cULL, 0x002fee0000041834ULL, 0x0000008b008b7306ULL, 0x000e620000202400ULL,
0x000000641014723cULL, 0x004fe20000041814ULL, 0x0000541067667816ULL, 0x008fcc0000000068ULL,
0x0000008500857306ULL, 0x000fe20000202400ULL, 0x000054108e0d7816ULL, 0x002fce000000008bULL,
0x0000008300837306ULL, 0x000ff00000202400ULL, 0x0000008200827306ULL, 0x000e700000202400ULL,
0x0000008100817306ULL, 0x000fe20000202400ULL, 0x0000541091537816ULL, 0x002fce0000000082ULL,
0x0000008000807306ULL, 0x000e700000202400ULL, 0x0000007d007d7306ULL, 0x000fe20000202400ULL,
0x0000541061617816ULL, 0x002fce0000000080ULL, 0x0000008d008d7306ULL, 0x000ff00000202400ULL,
0x0000009000907306ULL, 0x000ff00000202400ULL, 0x0000008900897306ULL, 0x000e700000202400ULL,
0x0000008a008a7306ULL, 0x000ea20000202400ULL, 0x00005410890e7816ULL, 0x002fce000000008cULL,
0x0000008700877306ULL, 0x000fe20000202400ULL, 0x000054108a0f7816ULL, 0x004fce0000000085ULL,
0x0000008800887306ULL, 0x000e620000202400ULL, 0x0000000e5448723cULL, 0x000fee0000041848ULL,
0x0000008600867306ULL, 0x000ea20000202400ULL, 0x0000000e1028723cULL, 0x000fe20000041828ULL,
0x0000541087507816ULL, 0x002fcc0000000088ULL, 0x0000008f008f7306ULL, 0x000fe20000202400ULL,
0x0000541086517816ULL, 0x004fce0000000083ULL, 0x0000009300937306ULL, 0x000e620000202400ULL,
0x000000505444723cULL, 0x000fee0000041844ULL, 0x0000009400947306ULL, 0x000ea20000202400ULL,
0x000000501024723cULL, 0x000fe20000041824ULL, 0x00005410925e7816ULL, 0x002fcc0000000093ULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x00005410945f7816ULL, 0x004fce0000000081ULL,
0x0000000c006b7306ULL, 0x0002a20000202400ULL, 0x0000005e543c723cULL, 0x000fee000004183cULL,
0x00000052006c7306ULL, 0x0007620000202400ULL, 0x000054108d0c7816ULL, 0x002fe20000000090ULL,
0x0000005e101c723cULL, 0x000fe2000004181cULL, 0x000054106a607816ULL, 0x004fc4000000006bULL,
0x0000541084527816ULL, 0x008fc6000000008fULL, 0x0000000c544c723cULL, 0x000fe2000004184cULL,
0x000054106c677816ULL, 0x020fca000000007dULL, 0x000000525440723cULL, 0x000fec0000041840ULL,
0x000000605438723cULL, 0x000fec0000041838ULL, 0x000000665430723cULL, 0x000fec0000041830ULL,
0x0000000c102c723cULL, 0x000fec000004182cULL, 0x000000521020723cULL, 0x000fec0000041820ULL,
0x000000601018723cULL, 0x000fec0000041818ULL, 0x000000661004723cULL, 0x000fe20000041804ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffffec00bc0947ULL, 0x000fde000383ffffULL,
0x00000001ff117424ULL, 0x000fe400078e00ffULL, 0x0000006f4c0b7220ULL, 0x080fe20000410000ULL,
0x0000006f4d4d7220ULL, 0x080fe20000410000ULL, 0x0000006f4e4e7220ULL, 0x080fe20000410000ULL,
0x0000006f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000006f48487220ULL, 0x080fe20000410000ULL,
0x01a68811021079a7ULL, 0x000262000850003fULL, 0x0000006f49497220ULL, 0x080fe20000410000ULL,
0x0000006f4a4a7220ULL, 0x080fe20000410000ULL, 0x0000006f4b4b7220ULL, 0x080fe20000410000ULL,
0x0000006f44447220ULL, 0x080fe20000410000ULL, 0x0000006f45457220ULL, 0x080fe20000410000ULL,
0x0000006f46467220ULL, 0x080fe20000410000ULL, 0x0000006f47477220ULL, 0x080fe20000410000ULL,
0x0000006f40407220ULL, 0x080fe20000410000ULL, 0x0000006f41417220ULL, 0x080fe20000410000ULL,
0x0000006f42427220ULL, 0x080fe20000410000ULL, 0x0000006f43437220ULL, 0x080fe20000410000ULL,
0x0000006f3c3c7220ULL, 0x080fe20000410000ULL, 0x0000006f3d3d7220ULL, 0x080fe20000410000ULL,
0x0000006f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000006f3f3f7220ULL, 0x080fe20000410000ULL,
0x0000006f38387220ULL, 0x080fe20000410000ULL, 0x0000006f39397220ULL, 0x080fe20000410000ULL,
0x0000006f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000006f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000006f34347220ULL, 0x080fe20000410000ULL, 0x0000006f35357220ULL, 0x080fe20000410000ULL,
0x0000006f36367220ULL, 0x080fe20000410000ULL, 0x0000006f37377220ULL, 0x080fe20000410000ULL,
0x0000006f30307220ULL, 0x080fe20000410000ULL, 0x0000006f31317220ULL, 0x080fe20000410000ULL,
0x0000006f32327220ULL, 0x080fe20000410000ULL, 0x0000006f33337220ULL, 0x080fe20000410000ULL,
0x0000006f2c0d7220ULL, 0x080fe20000410000ULL, 0x0000006f2d2d7220ULL, 0x080fe20000410000ULL,
0x0000006f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000006f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000006f28287220ULL, 0x080fe20000410000ULL, 0x0000006f29297220ULL, 0x080fe20000410000ULL,
0x0000006f2a2a7220ULL, 0x080fe20000410000ULL, 0x0000006f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000006f24247220ULL, 0x080fe20000410000ULL, 0x0000006f25257220ULL, 0x080fe20000410000ULL,
0x0000006f26267220ULL, 0x080fe20000410000ULL, 0x0000006f27277220ULL, 0x080fe20000410000ULL,
0x0000006f20207220ULL, 0x080fe20000410000ULL, 0x0000006f21217220ULL, 0x080fe20000410000ULL,
0x0000006f22227220ULL, 0x080fe20000410000ULL, 0x0000006f23237220ULL, 0x080fe20000410000ULL,
0x0000006f1c1c7220ULL, 0x080fe20000410000ULL, 0x0000006f1d1d7220ULL, 0x080fe20000410000ULL,
0x0000006f1e1e7220ULL, 0x080fe20000410000ULL, 0x0000006f1f1f7220ULL, 0x080fe20000410000ULL,
0x0000006f18187220ULL, 0x080fe20000410000ULL, 0x0000006f19197220ULL, 0x080fe20000410000ULL,
0x0000006f1a1a7220ULL, 0x080fe20000410000ULL, 0x0000006f1b1b7220ULL, 0x080fe20000410000ULL,
0x0000006f14147220ULL, 0x080fe20000410000ULL, 0x0000006f15157220ULL, 0x080fe20000410000ULL,
0x0000006f16167220ULL, 0x080fe20000410000ULL, 0x0000006f17177220ULL, 0x080fe20000410000ULL,
0x0000006f040a7220ULL, 0x080fe20000410000ULL, 0x0000006f050c7220ULL, 0x080fe20000410000ULL,
0x0000006f060e7220ULL, 0x080fe20000410000ULL, 0x0000006f070f7220ULL, 0x002fce0000410000ULL,
0x0000000000067805ULL, 0x000fce0000015200ULL, 0x01a68811020075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff127224ULL, 0x000fce00078e00ffULL,
0x000000101200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fce0000015200ULL, 0x0000000406137210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e07ULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000001304047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000112127836ULL, 0x000fce0000000000ULL,
0x01a68811020075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000409047824ULL, 0x000fe200078e00ffULL, 0x0000006e7300720cULL, 0x000fe20003f06070ULL,
0x0000008077057824ULL, 0x000fc600078e0208ULL, 0xfffffff004047812ULL, 0x000fca00078ec0ffULL,
0x0000000105107824ULL, 0x000fca00078e0204ULL, 0x01a4000010047984ULL, 0x0002a20000000c00ULL,
0x0000002000648947ULL, 0x000fea0003800000ULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x00000004002c7d06ULL, 0x000ee20008209000ULL,
0x0000007609117211ULL, 0x040fe200078ff0ffULL, 0xffffff005b5b7836ULL, 0x000fe40000000000ULL,
0x0000000209b07824ULL, 0x000fe400078e00ffULL, 0x00000018114c7836ULL, 0x000fc60000000000ULL,
0x00000006b0b07812ULL, 0x000fca00078ec0ffULL, 0x00000001b0ae7824ULL, 0x000fe200078e0203ULL,
0x0000002c002c7308ULL, 0x008ee40000001000ULL, 0x0ffffffe2c137836ULL, 0x008fe40000000000ULL,
0x00000010112c7836ULL, 0x000fc80000000000ULL, 0x0000001300137305ULL, 0x000ee4000021f000ULL,
0x000000ffff517224ULL, 0x008fc800078e0a13ULL, 0x0000000451517c24ULL, 0x000fc8000f8e02ffULL,
0x0000005113557227ULL, 0x000fc800078e0012ULL, 0x0000000811127836ULL, 0x000fe40000000000ULL,
0x0000001155137227ULL, 0x000fc800078e00ffULL, 0x0000001255507227ULL, 0x000fc800078e00ffULL,
0x000000ffff537224ULL, 0x000fe400078e0a50ULL, 0x000000ffff547224ULL, 0x000fe400078e0a13ULL,
0x0000000453127c24ULL, 0x000fe4000f8e0212ULL, 0x0000000454117c24ULL, 0x000fe4000f8e0211ULL,
0x0000002c55517227ULL, 0x000fe200078e00ffULL, 0x0000000412007c0cULL, 0x000fe4000bf06070ULL,
0x0000000411007c0cULL, 0x000fe2000bfa6070ULL, 0x0000004c55527227ULL, 0x000fc800078e00ffULL,
0x000000ffff537224ULL, 0x000fe400078e0a51ULL, 0x000000ffff557224ULL, 0x000fe400078e0a52ULL,
0x00000004532c7c24ULL, 0x000fe4000f8e022cULL, 0x00000004554c7c24ULL, 0x000fe4000f8e024cULL,
0x8000000412120c36ULL, 0x000fe20008000000ULL, 0x000000042c007c0cULL, 0x000fe2000bf46070ULL,
0x8000000411115c36ULL, 0x000fe20008000000ULL, 0x000000044c007c0cULL, 0x000fe2000bf66070ULL,
0x0000000150500836ULL, 0x000fe20000000000ULL, 0x0000000412007c0cULL, 0x000fe2000bfc6070ULL,
0x0000000113135836ULL, 0x000fe20000000000ULL, 0x0000000411007c0cULL, 0x000fc4000bf86070ULL,
0x0000005b74127248ULL, 0x000fe40007fe0000ULL, 0x00000004ff117c12ULL, 0x000fc6000f8e33ffULL,
0x800000042c2c2c10ULL, 0x000fe2000fffe0ffULL, 0x0000000112af7824ULL, 0x000fe400078e0a5bULL,
0x800000044c4c3c36ULL, 0x000fe20008000000ULL, 0x000000042c007c0cULL, 0x000fe2000bf26070ULL,
0x0000000150506836ULL, 0x000fe20000000000ULL, 0x00000004ff007c0cULL, 0x000fe2000bfc5070ULL,
0x0000000113134836ULL, 0x000fe20000000000ULL, 0x000000044c007c0cULL, 0x000fe2000bf06070ULL,
0x000000015d4c7824ULL, 0x000fe200078e02b0ULL, 0x000000afae00720cULL, 0x000fe20003f86070ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0aafULL, 0x0000001311127207ULL, 0x000fe20007000000ULL,
0x0000000151512836ULL, 0x000fe20000000000ULL, 0x000000af4c00720cULL, 0x000fe20003fa6070ULL,
0x0000000152523836ULL, 0x000fe20000000000ULL, 0x0000002c4c4c7246ULL, 0x000fe20003800063ULL,
0x0000000151511836ULL, 0x000fe20000000000ULL, 0x0000001263127248ULL, 0x000fc40003fe0000ULL,
0x0000002caeb27246ULL, 0x000fe20003800063ULL, 0x0000000152520836ULL, 0x000fe20000000000ULL,
0x00000004ff4c7819ULL, 0x000fe2000001164cULL, 0x00000005127f7c24ULL, 0x000fe2000f8e02ffULL,
0x000000ffb2b27207ULL, 0x000fe40002000000ULL, 0x000000ff4c4c7207ULL, 0x000fe40002800000ULL,
0x0000005011507207ULL, 0x040fe40007000000ULL, 0x0000005111127207ULL, 0x000fe20007000000ULL,
0x000000017f577824ULL, 0x000fe200078e024cULL, 0x0000007fb2137211ULL, 0x000fc400078fe0ffULL,
0x0000005063507248ULL, 0x000fe20003fe0000ULL, 0x0000000257567825ULL, 0x100fe200078e0098ULL,
0x0000001263717248ULL, 0x000fe40003fe0000ULL, 0x0000005211527207ULL, 0x000fe20007000000ULL,
0x0000000213127825ULL, 0x000fe200078e0098ULL, 0x0000000656ad7981ULL, 0x004ea4000c1e9500ULL,
0x0000005263527248ULL, 0x000fe20003fe0000ULL, 0x0000000550597c24ULL, 0x000fe2000f8e02ffULL,
0x0000000612ac7981ULL, 0x000ea2000c1e9500ULL, 0x0000000571717c24ULL, 0x000fc4000f8e02ffULL,
0x000000014c517824ULL, 0x000fe200078e0259ULL, 0x00000059b2537211ULL, 0x000fe200078fe0ffULL,
0x00000005527d7c24ULL, 0x000fe2000f8e02ffULL, 0x00000071b2917211ULL, 0x000fe200078fe0ffULL,
0x000000014c5b7824ULL, 0x000fe200078e0271ULL, 0x00000010b0967812ULL, 0x000fe200078efcffULL,
0x0000000251507825ULL, 0x000fe200078e0098ULL, 0x0000007db2117211ULL, 0x000fc600078fe0ffULL,
0x0000000253527825ULL, 0x100fe200078e0098ULL, 0x0000000650557981ULL, 0x000766000c1e9500ULL,
0x0000000291907825ULL, 0x100fe400078e0098ULL, 0x0000000652527981ULL, 0x000f64000c1e9500ULL,
0x000000025b5a7825ULL, 0x000fe400078e0098ULL, 0x0000000690907981ULL, 0x000f64000c1e9500ULL,
0x000000015d507824ULL, 0x00afc400078e0296ULL, 0x0000000211127825ULL, 0x000fe400078e0098ULL,
0x000000065a117981ULL, 0x000ee2000c1e9500ULL, 0x0000002c50547246ULL, 0x000fe20003800063ULL,
0x00000001969a7824ULL, 0x000fe400078e0203ULL, 0x000000014c5f7824ULL, 0x000fe200078e027dULL,
0x000000af5000720cULL, 0x080fe20003f26070ULL, 0x0000000612517981ULL, 0x000ee2000c1e9500ULL,
0x000000af9a00720cULL, 0x000fe20003f06070ULL, 0x000000025f567825ULL, 0x000fe200078e0098ULL,
0x00000004ff547819ULL, 0x000fc40000011654ULL, 0x0000002c9aa47246ULL, 0x000fe40003800063ULL,
0x000000ff54547207ULL, 0x000fe20000800000ULL, 0x00000006564c7981ULL, 0x0002e2000c1e9500ULL,
0x000000ffa4a47207ULL, 0x000fc60000000000ULL, 0x00000001549d7824ULL, 0x000fe200078e0259ULL,
0x0000007fa49f7211ULL, 0x040fe400078fe0ffULL, 0x00000059a4617211ULL, 0x000fe200078fe0ffULL,
0x000000017f577824ULL, 0x002fe200078e0254ULL, 0x00000020b0807812ULL, 0x000fe200078efcffULL,
0x000000029f9e7825ULL, 0x000fe200078e0098ULL, 0x0000007da4537211ULL, 0x000fc600078fe0ffULL,
0x000000029d9c7825ULL, 0x100fe400078e0098ULL, 0x000000069e9e7981ULL, 0x000ee4000c1e9500ULL,
0x0000000257567825ULL, 0x100fe400078e0098ULL, 0x000000069c9c7981ULL, 0x000ee4000c1e9500ULL,
0x0000000261607825ULL, 0x000fe400078e0098ULL, 0x0000000656677981ULL, 0x0002e4000c1e9500ULL,
0x0000000154137824ULL, 0x000fc400078e0271ULL, 0x00000001545b7824ULL, 0x000fe200078e027dULL,
0x00000006606d7981ULL, 0x0002e2000c1e9500ULL, 0x000000015d547824ULL, 0x000fe200078e0280ULL,
0x00000071a45f7211ULL, 0x000fe200078fe0ffULL, 0x0000000180827824ULL, 0x000fe400078e0203ULL,
0x0000000253567825ULL, 0x102fe200078e0098ULL, 0x0000002c54537246ULL, 0x000fe40003800063ULL,
0x000000af5400720cULL, 0x080fe20003f26070ULL, 0x0000000213127825ULL, 0x000fe200078e0098ULL,
0x000000af8200720cULL, 0x000fe20003f06070ULL, 0x0000000656697981ULL, 0x000ee2000c1e9500ULL,
0x00000004ff537819ULL, 0x000fe20000011653ULL, 0x000000025f5e7825ULL, 0x100fe200078e0098ULL,
0x0000002c82a27246ULL, 0x000fe20003800063ULL, 0x0000000612127981ULL, 0x000ee4000c1e9500ULL,
0x000000025b5a7825ULL, 0x000fe200078e0098ULL, 0x000000ff53547207ULL, 0x000fe20000800000ULL,
0x000000065e6b7981ULL, 0x0002e2000c1e9500ULL, 0x000000ffa2a27207ULL, 0x000fc60000000000ULL,
0x000000065a507981ULL, 0x000ee2000c1e9500ULL, 0x0000007fa2617211ULL, 0x000fe200078fe0ffULL,
0x0000000154897824ULL, 0x000fe200078e0259ULL, 0x00000059a25f7211ULL, 0x002fc600078fe0ffULL,
0x0000000261607825ULL, 0x000fc800078e0098ULL, 0x0000000289887825ULL, 0x100fe200078e0098ULL,
0x0000000660657981ULL, 0x0002e6000c1e9500ULL, 0x000000025f5e7825ULL, 0x000fe400078e0098ULL,
0x0000000688887981ULL, 0x000ee2000c1e9500ULL, 0x00000071a2877211ULL, 0x040fe200078fe0ffULL,
0x000000017f8b7824ULL, 0x000fe200078e0254ULL, 0x0000007da2857211ULL, 0x000fe200078fe0ffULL,
0x000000065e617981ULL, 0x002ee2000c1e9500ULL, 0x00000001545b7824ULL, 0x000fe200078e0271ULL,
0x00000030b0607812ULL, 0x000fe200078efcffULL, 0x0000000154577824ULL, 0x000fc400078e027dULL,
0x000000028b8a7825ULL, 0x000fc800078e0098ULL, 0x0000000287867825ULL, 0x100fe400078e0098ULL,
0x000000068a8a7981ULL, 0x000ee4000c1e9500ULL, 0x0000000285847825ULL, 0x100fe400078e0098ULL,
0x0000000686867981ULL, 0x000ee4000c1e9500ULL, 0x000000025b5a7825ULL, 0x100fe400078e0098ULL,
0x0000000684847981ULL, 0x000ee4000c1e9500ULL, 0x0000000257567825ULL, 0x000fc400078e0098ULL,
0x000000065a137981ULL, 0x000ee4000c1e9500ULL, 0x000000015d547824ULL, 0x000fe400078e0260ULL,
0x0000000656537981ULL, 0x0002e2000c1e9500ULL, 0x0000000160647824ULL, 0x000fe400078e0203ULL,
0x0000002c54667246ULL, 0x000fe40003800063ULL, 0x000000af5400720cULL, 0x000fe40003f26070ULL,
0x00000004ff667819ULL, 0x000fc40000011666ULL, 0x000000af6400720cULL, 0x000fe40003f06070ULL,
0x0000002c64a07246ULL, 0x000fe40003800063ULL, 0x000000ff66667207ULL, 0x000fe40000800000ULL,
0x000000ffa0a07207ULL, 0x000fc60000000000ULL, 0x00000001668d7824ULL, 0x000fe200078e0271ULL,
0x0000007fa0577211ULL, 0x042fe200078fe0ffULL, 0x000000017f937824ULL, 0x000fe200078e0266ULL,
0x00000071a0717211ULL, 0x000fe200078fe0ffULL, 0x000000028d8c7825ULL, 0x000fc800078e0098ULL,
0x0000000293927825ULL, 0x100fe200078e0098ULL, 0x00000059a05b7211ULL, 0x000fe200078fe0ffULL,
0x000000068c2c7981ULL, 0x000ee4000c1e9500ULL, 0x0000000257567825ULL, 0x100fe400078e0098ULL,
0x00000006926a7981ULL, 0x000ee4000c1e9500ULL, 0x0000000271707825ULL, 0x000fe400078e0098ULL,
0x00000006565f7981ULL, 0x0002e4000c1e9500ULL, 0x00000001668f7824ULL, 0x000fc400078e0259ULL,
0x0000000670597981ULL, 0x000ee2000c1e9500ULL, 0x000000025b5a7825ULL, 0x000fc800078e0098ULL,
0x000000028f8e7825ULL, 0x000fe400078e0098ULL, 0x000000065a5b7981ULL, 0x000ee2000c1e9500ULL,
0x0000007da0577211ULL, 0x002fc600078fe0ffULL, 0x000000068e687981ULL, 0x000ee2000c1e9500ULL,
0x0000000166a77824ULL, 0x000fe400078e027dULL, 0x0000000257567825ULL, 0x000fc800078e0098ULL,
0x00000002a7a67825ULL, 0x000fe400078e0098ULL, 0x0000000656577981ULL, 0x000ee8000c1e9500ULL,
0x00000006a6667981ULL, 0x0002e2000c1e9500ULL, 0xfffffff0b2b27812ULL, 0x000fca00078ec0ffULL,
0x00000001af937824ULL, 0x000fe200078e02b2ULL, 0x0000000100547802ULL, 0x000fc60000000f00ULL,
0x00000001aeab7824ULL, 0x000fe200078e0a93ULL, 0x00000001b0aa7812ULL, 0x000fc800078efcffULL,
0x000000ab54ab7219ULL, 0x000fe200000006ffULL, 0x00000001aaa97824ULL, 0x000fe200078e0203ULL,
0x00000008b0a87812ULL, 0x000fc600078efcffULL, 0x00000001a9a77824ULL, 0x002fe200078e0a93ULL,
0x00000009b0947812ULL, 0x000fe200078efcffULL, 0x00000001a8a67824ULL, 0x000fc600078e0203ULL,
0x000000a754a77219ULL, 0x000fe200000006ffULL, 0x0000000194717824ULL, 0x000fe400078e0203ULL,
0x00000001a6917824ULL, 0x100fe400078e0a93ULL, 0x0000000171937824ULL, 0x000fe200078e0a93ULL,
0x00000011b0927812ULL, 0x000fe400078efcffULL, 0xfffffff0a4a47812ULL, 0x000fe400078ec0ffULL,
0x0000009154917219ULL, 0x000fc400000006ffULL, 0x0000009354937219ULL, 0x000fe200000006ffULL,
0x00000001927d7824ULL, 0x000fe400078e0203ULL, 0x00000001afa47824ULL, 0x000fc800078e02a4ULL,
0x000000019a957824ULL, 0x100fe400078e0aa4ULL, 0x000000017d977824ULL, 0x000fe200078e0aa4ULL,
0x00000018b08e7812ULL, 0x040fe400078efcffULL, 0x00000019b08c7812ULL, 0x000fe400078efcffULL,
0x0000009554957219ULL, 0x000fe400000006ffULL, 0x00005410acac7816ULL, 0x004fc800000000adULL,
0x000000acabff7212ULL, 0x000fc800078ac0ffULL, 0x000000afae00720cULL, 0x000fc80002fa1470ULL,
0x000000afb000720cULL, 0x000fe40002fa1070ULL, 0x000000aca7ff7212ULL, 0x000fe4000782c0ffULL,
0xff8000000b0b7808ULL, 0x000fe40002800000ULL, 0x0000541052527816ULL, 0x020fc80000000055ULL,
0x00000052abff7212ULL, 0x080fe4000784c0ffULL, 0x00000052a7ff7212ULL, 0x000fe400078ac0ffULL,
0x0000541090907816ULL, 0x008fc80000000011ULL, 0x00000090abff7212ULL, 0x000fe4000788c0ffULL,
0x000000afae00720cULL, 0x0c0fe40001741470ULL, 0x000000afae00720cULL, 0x080fe40002781470ULL,
0x000000afa900720cULL, 0x0c0fe40000f21470ULL, 0x000000afa900720cULL, 0x080fe40002fa1470ULL,
0x000000afb000720cULL, 0x000fc40001741070ULL, 0x000000afb000720cULL, 0x080fe40002781070ULL,
0x000000afaa00720cULL, 0x0c0fe40000f21070ULL, 0x000000afaa00720cULL, 0x000fe40002fa1070ULL,
0x00005410514c7816ULL, 0x000fe4000000004cULL, 0xff8000004e4e7808ULL, 0x000fe40001000000ULL,
0xff8000000d0d7808ULL, 0x000fc40002000000ULL, 0xff8000004d4d7808ULL, 0x000fe40000800000ULL,
0xff8000004f4f7808ULL, 0x000fe40002800000ULL, 0x000000ac91ff7212ULL, 0x000fe4000786c0ffULL,
0x0000004cabff7212ULL, 0x000fe4000780c0ffULL, 0x00000090a7ff7212ULL, 0x040fe4000784c0ffULL,
0x0000004ca7ff7212ULL, 0x000fc4000788c0ffULL, 0x0000005293ff7212ULL, 0x000fe4000782c0ffULL,
0x0000009091ff7212ULL, 0x000fe400078ac0ffULL, 0x000000afae00720cULL, 0x080fe40000701470ULL,
0x000000afa900720cULL, 0x0c0fe40001741470ULL, 0x000000afa900720cULL, 0x080fe40002781470ULL,
0x000000afa600720cULL, 0x000fc40001f61470ULL, 0x000000afa600720cULL, 0x080fe40002fa1470ULL,
0x000000af7100720cULL, 0x080fe40000f21470ULL, 0x000000afb000720cULL, 0x080fe40000701070ULL,
0x000000afaa00720cULL, 0x0c0fe40001741070ULL, 0x000000afaa00720cULL, 0x080fe40002781070ULL,
0x000000afa800720cULL, 0x000fc40001f61070ULL, 0x000000afa800720cULL, 0x080fe40002fa1070ULL,
0x000000af9400720cULL, 0x000fe40000f21070ULL, 0x0000009754977219ULL, 0x000fe400000006ffULL,
0x000054109e9e7816ULL, 0x000fe40000000067ULL, 0x000054106d9c7816ULL, 0x000fe2000000009cULL,
0x000000018e7f7824ULL, 0x100fe200078e0203ULL, 0xff8000002e2e7808ULL, 0x000fe20000000000ULL,
0x000000018c817824ULL, 0x000fe200078e0203ULL, 0xff8000002d2d7808ULL, 0x000fc40001000000ULL,
0xff8000002f2f7808ULL, 0x000fe40002000000ULL, 0xff80000048487808ULL, 0x000fe40001800000ULL,
0xff80000028287808ULL, 0x000fe40002800000ULL, 0xff8000004b4b7808ULL, 0x000fe40000800000ULL,
0x0000005291ff7212ULL, 0x000fe4000780c0ffULL, 0x0000009093ff7212ULL, 0x000fc4000784c0ffULL,
0x0000004c91ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004c93ff7212ULL, 0x000fe4000786c0ffULL,
0x0000009e97ff7212ULL, 0x000fe400078ac0ffULL, 0x0000009c95ff7212ULL, 0x000fe2000782c0ffULL,
0x000000017f9b7824ULL, 0x100fe200078e0aa4ULL, 0x000000afa600720cULL, 0x0c0fe20000701470ULL,
0x00000001819d7824ULL, 0x000fe200078e0aa4ULL, 0x000000afa600720cULL, 0x000fc40002781470ULL,
0x000000af7100720cULL, 0x0c0fe40001741470ULL, 0x000000af7100720cULL, 0x080fe40001f61470ULL,
0x000000af9a00720cULL, 0x080fe40000f21470ULL, 0x000000af7d00720cULL, 0x080fe40002fa1470ULL,
0xfffffff0a2a27812ULL, 0x000fe400078ec0ffULL, 0x000000afa800720cULL, 0x000fc40000701070ULL,
0x000000afa800720cULL, 0x080fe40002781070ULL, 0x000000af9400720cULL, 0x0c0fe40001741070ULL,
0x000000af9400720cULL, 0x080fe40001f61070ULL, 0x000000af9600720cULL, 0x080fe40000f21070ULL,
0x000000af9200720cULL, 0x000fe40002fa1070ULL, 0x0000009b549b7219ULL, 0x000fc400000006ffULL,
0x0000009d549d7219ULL, 0x000fe400000006ffULL, 0x000054106b127816ULL, 0x000fe40000000012ULL,
0x0000541069507816ULL, 0x000fe20000000050ULL, 0x00000001afa27824ULL, 0x000fe200078e02a2ULL,
0xff8000004a4a7808ULL, 0x000fe40000000000ULL, 0xff8000002a2a7808ULL, 0x000fe40002000000ULL,
0xff80000029297808ULL, 0x000fc40001000000ULL, 0xff8000002b2b7808ULL, 0x000fe40001800000ULL,
0xff80000046467808ULL, 0x000fe40000800000ULL, 0xff80000045457808ULL, 0x000fe40002800000ULL,
0x0000009e95ff7212ULL, 0x080fe4000780c0ffULL, 0x0000009e9bff7212ULL, 0x000fe4000788c0ffULL,
0x0000001295ff7212ULL, 0x000fc4000784c0ffULL, 0x0000005095ff7212ULL, 0x000fe4000786c0ffULL,
0x0000001297ff7212ULL, 0x000fe4000782c0ffULL, 0x0000009c9dff7212ULL, 0x000fe200078ac0ffULL,
0x00000001829f7824ULL, 0x000fe200078e0aa2ULL, 0x000000af9a00720cULL, 0x0c0fe40000701470ULL,
0x000000af9a00720cULL, 0x0c0fe40001741470ULL, 0x000000af9a00720cULL, 0x000fc40001f61470ULL,
0x000000af7d00720cULL, 0x080fe40000f21470ULL, 0x000000af7f00720cULL, 0x080fe40002781470ULL,
0x000000af8100720cULL, 0x080fe40002fa1470ULL, 0x00000021b0727812ULL, 0x000fe400078efcffULL,
0x000000af9600720cULL, 0x0c0fe40000701070ULL, 0x000000af9600720cULL, 0x000fc40001741070ULL,
0x000000af9600720cULL, 0x080fe40001f61070ULL, 0x000000af9200720cULL, 0x080fe40000f21070ULL,
0x000000af8e00720cULL, 0x080fe40002781070ULL, 0x000000af8c00720cULL, 0x000fe40002fa1070ULL,
0x0000009f549f7219ULL, 0x000fe400000006ffULL, 0x0000541061617816ULL, 0x000fe20000000088ULL,
0x0000000172837824ULL, 0x000fe200078e0203ULL, 0x00000031b05e7812ULL, 0x000fc400078efcffULL,
0x00000038b05a7812ULL, 0x040fe400078efcffULL, 0x00000039b0567812ULL, 0x000fe400078efcffULL,
0xfffffff0a0a07812ULL, 0x000fe400078ec0ffULL, 0xff80000044447808ULL, 0x000fe40000000000ULL,
0xff80000024247808ULL, 0x000fe40001000000ULL, 0xff80000026267808ULL, 0x000fc40001800000ULL,
0xff80000025257808ULL, 0x000fe40000800000ULL, 0xff80000040407808ULL, 0x000fe40002000000ULL,
0xff80000043437808ULL, 0x000fe40002800000ULL, 0x0000009c97ff7212ULL, 0x040fe4000780c0ffULL,
0x0000005097ff7212ULL, 0x000fe4000784c0ffULL, 0x0000009c9bff7212ULL, 0x000fc4000786c0ffULL,
0x000000129dff7212ULL, 0x040fe4000782c0ffULL, 0x000000509dff7212ULL, 0x000fe4000788c0ffULL,
0x000000619fff7212ULL, 0x000fe200078ac0ffULL, 0x000000015e897824ULL, 0x100fe200078e0203ULL,
0x000000af7d00720cULL, 0x0c0fe20000701470ULL, 0x000000015a8b7824ULL, 0x100fe200078e0203ULL,
0x000000af7d00720cULL, 0x080fe20001741470ULL, 0x00000001568d7824ULL, 0x000fe200078e0203ULL,
0x000000af7f00720cULL, 0x080fe20001f61470ULL, 0x00000001afa07824ULL, 0x000fe200078e02a0ULL,
0x000000af8100720cULL, 0x080fe20000f21470ULL, 0x0000000183b57824ULL, 0x000fe200078e0aa2ULL,
0x000000af8100720cULL, 0x000fc40002781470ULL, 0x000000af8200720cULL, 0x080fe20002fa1470ULL,
0x0000000164a37824ULL, 0x100fe200078e0aa0ULL, 0x00000028b0707812ULL, 0x040fe200078efcffULL,
0x0000000189b17824ULL, 0x100fe200078e0aa0ULL, 0x00000029b06c7812ULL, 0x000fe200078efcffULL,
0x000000018ba57824ULL, 0x100fe200078e0aa0ULL, 0x000000af9200720cULL, 0x0c0fe20000701070ULL,
0x000000018d8f7824ULL, 0x000fe200078e0aa0ULL, 0x000000af9200720cULL, 0x080fe40001741070ULL,
0x000000af8e00720cULL, 0x000fc40001f61070ULL, 0x000000af8c00720cULL, 0x0c0fe40000f21070ULL,
0x000000af8c00720cULL, 0x080fe40002781070ULL, 0x000000af8000720cULL, 0x000fe40002fa1070ULL,
0x000000b554a07219ULL, 0x000fe400000006ffULL, 0x0000541065657816ULL, 0x000fe4000000008aULL,
0x0000541086137816ULL, 0x000fc40000000013ULL, 0x0000541084537816ULL, 0x000fe20000000053ULL,
0x0000000170857824ULL, 0x100fe200078e0203ULL, 0xff80000047477808ULL, 0x000fe20000000000ULL,
0x000000016c877824ULL, 0x000fe200078e0203ULL, 0xff80000027277808ULL, 0x000fe40001000000ULL,
0xff80000042427808ULL, 0x000fe40001800000ULL, 0xff80000021217808ULL, 0x000fe40000800000ULL,
0xff80000023237808ULL, 0x000fc40002000000ULL, 0xff8000003e3e7808ULL, 0x000fe40002800000ULL,
0x000000ac93ff7212ULL, 0x000fe400078cc0ffULL, 0x000000129bff7212ULL, 0x040fe4000780c0ffULL,
0x000000509bff7212ULL, 0x000fe4000784c0ffULL, 0x000000659fff7212ULL, 0x040fe4000786c0ffULL,
0x000000139fff7212ULL, 0x000fc4000782c0ffULL, 0x000000539fff7212ULL, 0x000fe4000788c0ffULL,
0x00000013a0ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000185a17824ULL, 0x100fe200078e0aa2ULL,
0x000000af7100720cULL, 0x080fe200037c1470ULL, 0x0000000187b37824ULL, 0x000fe200078e0aa2ULL,
0x000000af7f00720cULL, 0x0c0fe40000701470ULL, 0x000000af7f00720cULL, 0x080fe40001741470ULL,
0x000000af8200720cULL, 0x000fc40001f61470ULL, 0x000000af8200720cULL, 0x0c0fe40000f21470ULL,
0x000000af8200720cULL, 0x080fe40002781470ULL, 0x000000af8300720cULL, 0x080fe40002fa1470ULL,
0x000000af9400720cULL, 0x080fe400037c1070ULL, 0x000000af8e00720cULL, 0x0c0fe40000701070ULL,
0x000000af8e00720cULL, 0x000fc40001741070ULL, 0x000000af8000720cULL, 0x0c0fe40001f61070ULL,
0x000000af8000720cULL, 0x0c0fe40000f21070ULL, 0x000000af8000720cULL, 0x080fe40002781070ULL,
0x000000af7200720cULL, 0x000fe40002fa1070ULL, 0x000000a154a17219ULL, 0x040fe400000006ffULL,
0x000000b354a27219ULL, 0x000fc400000006ffULL, 0xff80000049497808ULL, 0x000fe40003000000ULL,
0xff80000020207808ULL, 0x000fe40000000000ULL, 0xff80000022227808ULL, 0x000fe40001000000ULL,
0xff8000003c3c7808ULL, 0x000fe40001800000ULL, 0xff8000001c1c7808ULL, 0x000fe40000800000ULL,
0xff8000001e1e7808ULL, 0x000fc40002000000ULL, 0xff8000001d1d7808ULL, 0x000fe40002800000ULL,
0x0000009e9dff7212ULL, 0x000fe400078cc0ffULL, 0x00000065a0ff7212ULL, 0x0c0fe4000780c0ffULL,
0x00000065a1ff7212ULL, 0x000fe4000784c0ffULL, 0x00000061a0ff7212ULL, 0x040fe4000786c0ffULL,
0x00000053a0ff7212ULL, 0x000fc4000782c0ffULL, 0x00000061a1ff7212ULL, 0x000fe4000788c0ffULL,
0x00000013a2ff7212ULL, 0x000fe400078ac0ffULL, 0x000000af8100720cULL, 0x080fe400037c1470ULL,
0x000000af8300720cULL, 0x0c0fe40000701470ULL, 0x000000af8300720cULL, 0x0c0fe40001f61470ULL,
0x000000af8300720cULL, 0x000fc40000f21470ULL, 0x000000af8500720cULL, 0x0c0fe40001741470ULL,
0x000000af8500720cULL, 0x080fe40002781470ULL, 0x000000af8700720cULL, 0x080fe40002fa1470ULL,
0x000000af8c00720cULL, 0x080fe400037c1070ULL, 0x000000af7200720cULL, 0x0c0fe40000701070ULL,
0x000000af7200720cULL, 0x000fc40001f61070ULL, 0x000000af7200720cULL, 0x080fe40000f21070ULL,
0x000000af7000720cULL, 0x0c0fe40001741070ULL, 0x000000af7000720cULL, 0x080fe40002781070ULL,
0x000000af6c00720cULL, 0x000fe40002fa1070ULL, 0x000000a354a37219ULL, 0x000fe400000006ffULL,
0x000054105f6a7816ULL, 0x000fc4000000006aULL, 0x00005410592c7816ULL, 0x000fe4000000002cULL,
0xff80000041417808ULL, 0x000fe40003000000ULL, 0xff8000003d3d7808ULL, 0x000fe40000000000ULL,
0xff8000003f3f7808ULL, 0x000fe40001800000ULL, 0xff8000001f1f7808ULL, 0x000fe40000800000ULL,
0xff80000038387808ULL, 0x000fc40001000000ULL, 0xff8000003a3a7808ULL, 0x000fe40002000000ULL,
0xff80000019197808ULL, 0x000fe40002800000ULL, 0x00000065a2ff7212ULL, 0x040fe400078cc0ffULL,
0x00000061a2ff7212ULL, 0x000fe4000780c0ffULL, 0x00000013a1ff7212ULL, 0x040fe4000786c0ffULL,
0x00000053a1ff7212ULL, 0x000fc4000782c0ffULL, 0x00000053a2ff7212ULL, 0x000fe4000784c0ffULL,
0x0000006aa3ff7212ULL, 0x040fe4000788c0ffULL, 0x0000002ca3ff7212ULL, 0x000fe400078ac0ffULL,
0x000000af8500720cULL, 0x0c0fe40001f61470ULL, 0x000000af8500720cULL, 0x080fe40000f21470ULL,
0x000000af8700720cULL, 0x000fc400037c1470ULL, 0x000000af8700720cULL, 0x0c0fe40000701470ULL,
0x000000af8700720cULL, 0x080fe40001741470ULL, 0x000000af6400720cULL, 0x0c0fe40002781470ULL,
0x000000af6400720cULL, 0x080fe40002fa1470ULL, 0x000000af7000720cULL, 0x0c0fe40001f61070ULL,
0x000000af7000720cULL, 0x000fc40000f21070ULL, 0x000000af6c00720cULL, 0x0c0fe400037c1070ULL,
0x000000af6c00720cULL, 0x0c0fe40000701070ULL, 0x000000af6c00720cULL, 0x080fe40001741070ULL,
0x000000af6000720cULL, 0x0c0fe40002781070ULL, 0x000000af6000720cULL, 0x000fe40002fa1070ULL,
0x000000b154a47219ULL, 0x000fc400000006ffULL, 0x000000a554a57219ULL, 0x040fe400000006ffULL,
0x0000008f548f7219ULL, 0x000fe400000006ffULL, 0x000054105b687816ULL, 0x000fe40000000068ULL,
0xff80000018187808ULL, 0x000fe40001800000ULL, 0xff8000001a1a7808ULL, 0x000fe40000800000ULL,
0xff80000039397808ULL, 0x000fc40003000000ULL, 0xff8000003b3b7808ULL, 0x000fe40000000000ULL,
0xff8000001b1b7808ULL, 0x000fe40001000000ULL, 0xff80000034347808ULL, 0x000fe40002000000ULL,
0xff80000014147808ULL, 0x000fe40002800000ULL, 0x0000006aa4ff7212ULL, 0x080fe4000786c0ffULL,
0x0000006aa5ff7212ULL, 0x000fc4000782c0ffULL, 0x0000006a8fff7212ULL, 0x000fe400078cc0ffULL,
0x00000068a3ff7212ULL, 0x080fe4000780c0ffULL, 0x00000068a4ff7212ULL, 0x0c0fe4000784c0ffULL,
0x00000068a5ff7212ULL, 0x000fe4000788c0ffULL, 0x0000002ca4ff7212ULL, 0x000fe400078ac0ffULL,
0x000000af6400720cULL, 0x000fc40000701470ULL, 0x000000af8900720cULL, 0x0c0fe40001f61470ULL,
0x000000af8900720cULL, 0x0c0fe40001741470ULL, 0x000000af8900720cULL, 0x080fe40002fa1470ULL,
0x000000af8b00720cULL, 0x080fe40000f21470ULL, 0x000000af8d00720cULL, 0x080fe400037c1470ULL,
0x000000af8b00720cULL, 0x000fc40002781470ULL, 0x000000af6000720cULL, 0x080fe40000701070ULL,
0x000000af5e00720cULL, 0x0c0fe40001f61070ULL, 0x000000af5e00720cULL, 0x0c0fe40001741070ULL,
0x000000af5e00720cULL, 0x080fe40002fa1070ULL, 0x000000af5a00720cULL, 0x080fe40000f21070ULL,
0x000000af5600720cULL, 0x000fc400037c1070ULL, 0x000000af5a00720cULL, 0x000fe40002781070ULL,
0x0000541057667816ULL, 0x000fe40000000066ULL, 0xff80000036367808ULL, 0x000fe40000000000ULL,
0xff80000035357808ULL, 0x000fe40001800000ULL, 0xff80000037377808ULL, 0x000fe40001000000ULL,
0xff80000015157808ULL, 0x000fc40002800000ULL, 0xff80000030307808ULL, 0x000fe40000800000ULL,
0xff80000031317808ULL, 0x000fe40003000000ULL, 0xff80000032327808ULL, 0x000fe40002000000ULL,
0x000000688fff7212ULL, 0x000fe4000780c0ffULL, 0x0000002ca5ff7212ULL, 0x080fe4000786c0ffULL,
0x0000002c8fff7212ULL, 0x000fc4000784c0ffULL, 0x00000066a3ff7212ULL, 0x080fe400078ac0ffULL,
0x00000066a4ff7212ULL, 0x080fe4000782c0ffULL, 0x00000066a5ff7212ULL, 0x080fe400078cc0ffULL,
0x000000668fff7212ULL, 0x000fe4000788c0ffULL, 0x000000af6400720cULL, 0x080fe40002fa1470ULL,
0x000000af8900720cULL, 0x000fc40000f21470ULL, 0x000000af8b00720cULL, 0x0c0fe40001f61470ULL,
0x000000af8b00720cULL, 0x080fe400037c1470ULL, 0x000000af8d00720cULL, 0x0c0fe40000701470ULL,
0x000000af8d00720cULL, 0x0c0fe40001741470ULL, 0x000000af8d00720cULL, 0x080fe40002781470ULL,
0x000000af6000720cULL, 0x000fc40002fa1070ULL, 0x000000af5e00720cULL, 0x080fe40000f21070ULL,
0x000000af5600720cULL, 0x080fe40000701070ULL, 0x000000af5a00720cULL, 0x0c0fe40001f61070ULL,
0x000000af5a00720cULL, 0x080fe400037c1070ULL, 0x000000af5600720cULL, 0x0c0fe40001741070ULL,
0x000000af5600720cULL, 0x000fc40002781070ULL, 0xff80000033337808ULL, 0x000fe40000000000ULL,
0xff8000000a0a7808ULL, 0x000fe40001800000ULL, 0xff8000000c0c7808ULL, 0x000fe40001000000ULL,
0xff80000016167808ULL, 0x000fe40002800000ULL, 0xff80000017177808ULL, 0x000fe40000800000ULL,
0xff8000000e0e7808ULL, 0x000fc40003000000ULL, 0xff8000000f0f7808ULL, 0x000fce0002000000ULL,
0x0000000b0400720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0xfffffff8ff587812ULL, 0x000fe200078ee258ULL, 0x0000000173737836ULL, 0x000fe20000000000ULL,
0x000000040b047208ULL, 0x000fc80004000000ULL, 0x0000004d0400720bULL, 0x000fc80003f1e000ULL,
0x000000044d117208ULL, 0x000fc80004000000ULL, 0x000000481100720bULL, 0x000fc80003f1e000ULL,
0x0000001148047208ULL, 0x000fc80004000000ULL, 0x000000490400720bULL, 0x000fc80003f1e000ULL,
0x0000000449117208ULL, 0x000fc80004000000ULL, 0x000000441100720bULL, 0x000fc80003f1e000ULL,
0x0000001144047208ULL, 0x000fc80004000000ULL, 0x000000450400720bULL, 0x000fc80003f1e000ULL,
0x0000000445117208ULL, 0x000fc80004000000ULL, 0x000000401100720bULL, 0x000fc80003f1e000ULL,
0x0000001140047208ULL, 0x000fc80004000000ULL, 0x000000410400720bULL, 0x000fc80003f1e000ULL,
0x0000000441117208ULL, 0x000fc80004000000ULL, 0x0000003c1100720bULL, 0x000fc80003f1e000ULL,
0x000000113c047208ULL, 0x000fc80004000000ULL, 0x0000003d0400720bULL, 0x000fc80003f1e000ULL,
0x000000043d117208ULL, 0x000fc80004000000ULL, 0x000000381100720bULL, 0x000fc80003f1e000ULL,
0x0000001138047208ULL, 0x000fc80004000000ULL, 0x000000390400720bULL, 0x000fc80003f1e000ULL,
0x0000000439117208ULL, 0x000fc80004000000ULL, 0x000000341100720bULL, 0x000fc80003f1e000ULL,
0x0000001134047208ULL, 0x000fc80004000000ULL, 0x000000350400720bULL, 0x000fc80003f1e000ULL,
0x0000000435117208ULL, 0x000fc80004000000ULL, 0x000000301100720bULL, 0x000fc80003f1e000ULL,
0x0000001130047208ULL, 0x000fe40004000000ULL, 0x0000004e0500720bULL, 0x000fe40003f1e000ULL,
0x000000310400720bULL, 0x000fc80003f3e000ULL, 0x0000000431117208ULL, 0x000fe40004800000ULL,
0x000000054e047208ULL, 0x000fc60004000000ULL, 0x0c401f0011127f89ULL, 0x000ea200000e0000ULL,
0x0000004f0400720bULL, 0x000fc80003f1e000ULL, 0x000000044f057208ULL, 0x000fc80004000000ULL,
0x0000004a0500720bULL, 0x000fc80003f1e000ULL, 0x000000054a047208ULL, 0x000fc80004000000ULL,
0x0000004b0400720bULL, 0x000fc80003f1e000ULL, 0x000000044b057208ULL, 0x000fe40004000000ULL,
0x000000121100720bULL, 0x004fe40003f3e000ULL, 0x000000460500720bULL, 0x000fe40003f1e000ULL,
0x0000001112137208ULL, 0x000fe40004800000ULL, 0x0000000546047208ULL, 0x000fc60004000000ULL,
0x0c201f0013127f89ULL, 0x000ea200000e0000ULL, 0x000000470400720bULL, 0x000fc80003f1e000ULL,
0x0000000447057208ULL, 0x000fc80004000000ULL, 0x000000420500720bULL, 0x000fc80003f1e000ULL,
0x0000000542047208ULL, 0x000fc80004000000ULL, 0x000000430400720bULL, 0x000fc80003f1e000ULL,
0x0000000443057208ULL, 0x000fe40004000000ULL, 0x000000121300720bULL, 0x004fe40003f3e000ULL,
0x0000003e0500720bULL, 0x000fe40003f1e000ULL, 0x0000001312047208ULL, 0x000fe40004800000ULL,
0x000000053e127208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b04507820ULL, 0x000fe20000410000ULL,
0x0000003f1200720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b4d2c7823ULL, 0x100fe20000010850ULL,
0x000000123f057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b30137823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010850ULL,
0x0000003a0500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b49497823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b44447823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010850ULL,
0x000000053a127208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010850ULL,
0x0000003b1200720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b39397823ULL, 0x000fe20000010850ULL,
0x000000123b057208ULL, 0x000fe20004000000ULL, 0x0000000b000b7308ULL, 0x000fe60000000800ULL,
0x000000360500720bULL, 0x000fc80003f1e000ULL, 0x0000000536127208ULL, 0x000fe20004000000ULL,
0x0000002c002c7308ULL, 0x000ea60000000800ULL, 0x000000371200720bULL, 0x000fc80003f1e000ULL,
0x0000001237057208ULL, 0x000fe20004000000ULL, 0x0000004400447308ULL, 0x000fe60000000800ULL,
0x000000320500720bULL, 0x000fc80003f1e000ULL, 0x0000000532127208ULL, 0x000fe20004000000ULL,
0x0000004500457308ULL, 0x000fe60000000800ULL, 0x000000331200720bULL, 0x000fc80003f1e000ULL,
0x0000001233127208ULL, 0x000fe20004000000ULL, 0x0000004000407308ULL, 0x000fe20000000800ULL,
0x0000000d0600720bULL, 0x000fc60003f1e000ULL, 0x0c401f0012117f89ULL, 0x000ee200000e0000ULL,
0x000000060d067208ULL, 0x000fc60004000000ULL, 0x0000004100417308ULL, 0x000fe20000000800ULL,
0x0000002d0600720bULL, 0x000fc80003f1e000ULL, 0x000000062d057208ULL, 0x000fc60004000000ULL,
0x0000004800487308ULL, 0x000fe20000000800ULL, 0x000000280500720bULL, 0x000fc80003f1e000ULL,
0x0000000528067208ULL, 0x000fc60004000000ULL, 0x0000004900497308ULL, 0x000fe20000000800ULL,
0x000000290600720bULL, 0x000fe40003f1e000ULL, 0x000000111200720bULL, 0x008fe40003f3e000ULL,
0x0000000629057208ULL, 0x000fe40004000000ULL, 0x00000012114c7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b35127823ULL, 0x100fe20000010850ULL, 0x000000240500720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b34117823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b31347823ULL, 0x000fe20000010850ULL,
0x0c201f004c4d7f89ULL, 0x000ee200000e0000ULL, 0x0000000524067208ULL, 0x000fe20004000000ULL,
0x0000003800387308ULL, 0x000fe60000000800ULL, 0x000000250600720bULL, 0x000fc80003f1e000ULL,
0x0000000625057208ULL, 0x000fe20004000000ULL, 0x0000003900397308ULL, 0x000fe60000000800ULL,
0x000000200500720bULL, 0x000fc80003f1e000ULL, 0x0000000520067208ULL, 0x000fe20004000000ULL,
0x0000003c003c7308ULL, 0x000fe60000000800ULL, 0x000000210600720bULL, 0x000fe40003f1e000ULL,
0x0000004d4c00720bULL, 0x008fe40003f3e000ULL, 0x0000000621357208ULL, 0x000fe20004000000ULL,
0x0000003d003d7308ULL, 0x000fe20000000800ULL, 0x0000004c4d057208ULL, 0x000fc40004800000ULL,
0x0000001c3500720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b05507820ULL, 0x000fe20000410000ULL,
0x000000351c067208ULL, 0x000fe20004000000ULL, 0x0000001300137308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b4e4c7823ULL, 0x100fe20000010850ULL, 0x0000001d0600720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b32357823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b4f4d7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010850ULL, 0x000000061d317208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010850ULL, 0x000000183100720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010850ULL, 0x0000003118067208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3b3b7823ULL, 0x000fe20000010850ULL, 0x0000004c004c7308ULL, 0x000fe40000000800ULL,
0x000000190600720bULL, 0x000fc80003f1e000ULL, 0x0000000619317208ULL, 0x000fe40004000000ULL,
0x0000002e0700720bULL, 0x000fe20003f1e000ULL, 0x0000004d004d7308ULL, 0x000ee20000000800ULL,
0x000000143100720bULL, 0x000fe40003f3e000ULL, 0x000000072e067208ULL, 0x000fe40004000000ULL,
0x0000003114307208ULL, 0x000fe40004800000ULL, 0x0000002f0600720bULL, 0x000fe20003f1e000ULL,
0x0000004a004a7308ULL, 0x000fe20000000800ULL, 0x000000153000720bULL, 0x000fc40003f3e000ULL,
0x000000062f077208ULL, 0x000fe40004000000ULL, 0x0000003015317208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b3e307823ULL, 0x100fe20000010850ULL, 0x0000002a0700720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b3a3e7823ULL, 0x100fe20000010850ULL, 0x0000000a3100720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b333a7823ULL, 0x000fe20000010850ULL, 0x000000072a067208ULL, 0x000fe20004000000ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x000000310a317208ULL, 0x000fc40004800000ULL,
0x0000002b0600720bULL, 0x000fe40003f1e000ULL, 0x0000000c3100720bULL, 0x000fe40003f3e000ULL,
0x000000062b077208ULL, 0x000fe20004000000ULL, 0x0000004600467308ULL, 0x000fe20000000800ULL,
0x000000310c317208ULL, 0x000fe40004800000ULL, 0x000000260700720bULL, 0x000fc60003f1e000ULL,
0x0c401f00314e7f89ULL, 0x000f6200000e0000ULL, 0x0000000726067208ULL, 0x000fe20004000000ULL,
0x0000004700477308ULL, 0x000fe60000000800ULL, 0x000000270600720bULL, 0x000fc80003f1e000ULL,
0x0000000627077208ULL, 0x000fe20004000000ULL, 0x0000004200427308ULL, 0x000fe60000000800ULL,
0x000000220700720bULL, 0x000fc80003f1e000ULL, 0x0000000722067208ULL, 0x000fe20004000000ULL,
0x0000004300437308ULL, 0x000fe60000000800ULL, 0x000000230600720bULL, 0x000fe40003f1e000ULL,
0x0000004e3100720bULL, 0x022fe40003f3e000ULL, 0x0000000623077208ULL, 0x000fe20004000000ULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x000000314e4e7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b36317823ULL, 0x100fe20000010850ULL, 0x0000001e0700720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b37367823ULL, 0x000fc40000010850ULL, 0x0c201f004e4f7f89ULL, 0x000e6200000e0000ULL,
0x000000071e067208ULL, 0x000fe20004000000ULL, 0x0000003f003f7308ULL, 0x000fe60000000800ULL,
0x0000001f0600720bULL, 0x000fc80003f1e000ULL, 0x000000061f077208ULL, 0x000fe20004000000ULL,
0x0000003e003e7308ULL, 0x000fe60000000800ULL, 0x0000001a0700720bULL, 0x000fc80003f1e000ULL,
0x000000071a067208ULL, 0x000fe20004000000ULL, 0x0000003b003b7308ULL, 0x000fe60000000800ULL,
0x0000001b0600720bULL, 0x000fe40003f1e000ULL, 0x0000004f4e00720bULL, 0x002fe40003f3e000ULL,
0x000000061b077208ULL, 0x000fe20004000000ULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x0000004e4f067208ULL, 0x000fc40004800000ULL, 0x000000160700720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b06507820ULL, 0x000fe20000410000ULL, 0x0000000716327208ULL, 0x000fe20004000000ULL,
0x0000001100117308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b1c337823ULL, 0x100fe20000010850ULL,
0x000000173200720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010850ULL,
0x0000003217077208ULL, 0x000fe20004000000ULL, 0x0000000d00537308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b25527823ULL, 0x100fe20000010850ULL,
0x0000000e0700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b20517823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b21567823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b1d547823ULL, 0x100fe20000010850ULL,
0x000000070e327208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b240d7823ULL, 0x102fe20000010850ULL, 0x3fb8aa3b14377823ULL, 0x100fe20000010850ULL,
0x0000000f3200720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b154e7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b0a4f7823ULL, 0x000fe20000010850ULL, 0x0000002d005a7308ULL, 0x000e620000000800ULL,
0x000000320f327208ULL, 0x000fc40004000000ULL, 0x0000000b2c24723eULL, 0x004fe400000010ffULL,
0x0000004c4d25723eULL, 0x008fe200000010ffULL, 0x0c401f0032077f89ULL, 0x000ea200000e0000ULL,
0x00000008584d7810ULL, 0x000fe20007ffe0ffULL, 0x0000002800557308ULL, 0x0007e20000000800ULL,
0x000000535a20723eULL, 0x002fce00000010ffULL, 0x00000029005e7308ULL, 0x0003e20000000800ULL,
0x00000003ff5a7819ULL, 0x000fe20000011609ULL, 0x0000001058537836ULL, 0x000fe20000000000ULL,
0x000000444528723eULL, 0x008fca00000010ffULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x000000464729723eULL, 0x002fe400000010ffULL, 0x000000073200720bULL, 0x004fca0003f1e000ULL,
0x0000005200527308ULL, 0x000fe20000000800ULL, 0x0000003207077208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b18327823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b0c507823ULL, 0x000fc60000010850ULL,
0x0c201f00071c7f89ULL, 0x000e6400000e0000ULL, 0x0000005100517308ULL, 0x000ff00000000800ULL,
0x0000005600567308ULL, 0x000ff00000000800ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x0000001c0700720bULL, 0x002fce0003f1e000ULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x000000071c077208ULL, 0x000fe40004000000ULL, 0x0000000309ff7812ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b070c7820ULL, 0x000fe40000410000ULL, 0x0000003300337308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2a0a7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b261c7823ULL, 0x100fe4000001080cULL, 0x0000002e00217308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b270b7823ULL, 0x100fe2000001080cULL, 0x00000040412a723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080cULL, 0x000000484926723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b1f477823ULL, 0x000fe2000001080cULL, 0x0000004a4b27723eULL, 0x000fe200000010ffULL,
0x000000084d417824ULL, 0x000fe200078e00ffULL, 0x0000002f00147308ULL, 0x000e620000000800ULL,
0x0000000853497824ULL, 0x000fc400078e00ffULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b174a7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b0f4c7823ULL, 0x000fe2000001080cULL, 0x0000003e3b17723eULL, 0x000fe200000010ffULL,
0x00000008533b7824ULL, 0x000fe200078e00ffULL, 0x0000000a00157308ULL, 0x0005e20000000800ULL,
0x000000ffff3e7224ULL, 0x000fe200078e0028ULL, 0x000000211421723eULL, 0x002fcc00000010ffULL,
0x0000002b00187308ULL, 0x0002e20000000800ULL, 0x00000004ff0a7e24ULL, 0x004fe4000f8e00ffULL,
0x3fb8aa3b23147823ULL, 0x000fc6000001080cULL, 0x3f8000000a0a783eULL, 0x000fe400000010ffULL,
0x0000001c00577308ULL, 0x0005e20000000800ULL, 0x00000042432b723eULL, 0x002fe200000010ffULL,
0x0000000858437824ULL, 0x000fe200078e00ffULL, 0x000000151823723eULL, 0x008fca00000010ffULL,
0x0000000b00447308ULL, 0x0002e20000000800ULL, 0x0000000409157810ULL, 0x000fe20007ffe05aULL,
0x3fb8aa3b221c7823ULL, 0x004fe2000001080cULL, 0x000000555e22723eULL, 0x000fe200000010ffULL,
0x0000001858557836ULL, 0x000fe20000000000ULL, 0x0000000715407812ULL, 0x000fe200078ec0ffULL,
0x000000ffff157224ULL, 0x100fe400078e000aULL, 0x0000001400187308ULL, 0x0005e20000000800ULL,
0x000000ffff0b7224ULL, 0x002fe200078e000aULL, 0xfffffff841427812ULL, 0x000fe200078ee240ULL,
0x00000008554b7824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fc400078ee240ULL,
0xfffffff849417812ULL, 0x000fe200078ee240ULL, 0x3fb8aa3b16497823ULL, 0x000fe2000001080cULL,
0x0000001c00457308ULL, 0x000e620000000800ULL, 0x000000ffff147224ULL, 0x004fe200078e000aULL,
0x0000000a242c723cULL, 0x000fe200000418ffULL, 0xfffffff84b407812ULL, 0x000fe200078ee240ULL,
0x3fb8aa3b0e4b7823ULL, 0x000fe2000001080cULL, 0x0000000d520c723eULL, 0x000fe400000010ffULL,
0x00000051560e723eULL, 0x000fe200000010ffULL, 0x0000001e00467308ULL, 0x0005e20000000800ULL,
0x00000057440d723eULL, 0x008fc400000010ffULL, 0x000000383916723eULL, 0x000fe200000010ffULL,
0x000000ffff387224ULL, 0x100fe400078e000aULL, 0x000000ffff397224ULL, 0x000fe200078e000aULL,
0x00000045180f723eULL, 0x002fe200000010ffULL, 0x0000005400547308ULL, 0x000e620000000800ULL,
0x00000014201c723cULL, 0x004fe200000418ffULL, 0x0000000855457824ULL, 0x000fcc00078e00ffULL,
0x0000004700477308ULL, 0x000ea20000000800ULL, 0x0000003c3d14723eULL, 0x000fe200000010ffULL,
0x0000000a282c723cULL, 0x000fe2000004182cULL, 0x000000303f15723eULL, 0x000fca00000010ffULL,
0x000000ffff3c7224ULL, 0x100fe200078e000aULL, 0x000000035a307812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e000aULL, 0x000000335418723eULL, 0x002fe200000010ffULL,
0x0000001a00487308ULL, 0x0003e20000000800ULL, 0x000000ffff3f7224ULL, 0x000fe400078e002aULL,
0x0000000130307824ULL, 0x000fe400078e0209ULL, 0x000000ffff287224ULL, 0x000fe400078e0020ULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0000001b001b7308ULL, 0x000ee20000000800ULL,
0x0000000a0c1c723cULL, 0x000fe2000004181cULL, 0x00000032191a723eULL, 0x002fe200000010ffULL,
0x000000ffff207224ULL, 0x000fe200078e0021ULL, 0x000000464719723eULL, 0x004fc600000010ffULL,
0x000000ffff467224ULL, 0x100fe200078e000aULL, 0x0000000730307812ULL, 0x000fe200078ec0ffULL,
0x000000ffff477224ULL, 0x000fe200078e000aULL, 0x0000001200127308ULL, 0x000e620000000800ULL,
0x00000008580b7824ULL, 0x000fe200078e00ffULL, 0x00000038142c723cULL, 0x000fe2000004182cULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee230ULL, 0x000000ffff217224ULL, 0x000fe200078e0023ULL,
0xfffffff845457812ULL, 0x000fe200078ee230ULL, 0x000000ffff237224ULL, 0x000fe200078e000fULL,
0x000000481b1b723eULL, 0x008fe200000010ffULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0x000000084d397824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee230ULL,
0x000000ffff387224ULL, 0x000fe200078e0014ULL, 0x000000133432723eULL, 0x000fe200000010ffULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0xfffffff839397812ULL, 0x000fe200078ee230ULL,
0x000000ffff157224ULL, 0x000fe200078e0017ULL, 0x0000003600367308ULL, 0x000ea20000000800ULL,
0x0000003c181c723cULL, 0x000fe2000004181cULL, 0x000000111230723eULL, 0x002fe200000010ffULL,
0x0000100077117824ULL, 0x000fc800078e0208ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0019ULL,
0x0001200011127836ULL, 0x000fe20000000000ULL, 0x0000003500357308ULL, 0x000fe60000000800ULL,
0x000000100b0b7824ULL, 0x100fe400078e0212ULL, 0x00000010390a7824ULL, 0x100fe200078e0212ULL,
0x000000313631723eULL, 0x004fe400000010ffULL, 0x0000003a003a7308ULL, 0x000e620000000800ULL,
0x000000103b117824ULL, 0x100fe200078e0212ULL, 0x00000032003b7202ULL, 0x000fe20000000f00ULL,
0x0000001043437824ULL, 0x000fc400078e0212ULL, 0x000000ffff397224ULL, 0x000fe400078e0016ULL,
0x0000001042427824ULL, 0x100fe200078e0212ULL, 0x0000003700377308ULL, 0x000fe20000000800ULL,
0x000000ffff167224ULL, 0x000fe400078e0031ULL, 0x0000001041417824ULL, 0x100fe400078e0212ULL,
0x0000001045457824ULL, 0x000fe200078e0212ULL, 0x000000353a33723eULL, 0x002fe400000010ffULL,
0x0000004e004e7308ULL, 0x000e620000000800ULL, 0x000000ffff3a7224ULL, 0x000fc400078e0030ULL,
0x0000001040407824ULL, 0x000fe400078e0212ULL, 0x000000ffff177224ULL, 0x000fe200078e0033ULL,
0x0000003c302c723cULL, 0x000fe4000004182cULL, 0x0000004f004f7308ULL, 0x000fea0000000800ULL,
0x000000ffff3c7224ULL, 0x000fe200078e0024ULL, 0x000000374e34723eULL, 0x002fc400000010ffULL,
0x0000005000507308ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe400078e0026ULL,
0x000000ffff247224ULL, 0x000fe400078e0025ULL, 0x000000ffff257224ULL, 0x000fe200078e0027ULL,
0x0000003c0b007844ULL, 0x0005e20000000200ULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x0000004900497308ULL, 0x000fe20000000800ULL, 0x000000ffff277224ULL, 0x000fe200078e002bULL,
0x0000003843007844ULL, 0x000fe20000000200ULL, 0x000000ffff297224ULL, 0x000fc400078e0022ULL,
0x000000ffff2b7224ULL, 0x000fe200078e000eULL, 0x000000240a007844ULL, 0x0007e20000000200ULL,
0x0000004f5036723eULL, 0x002fe200000010ffULL, 0x0000004a004a7308ULL, 0x000e620000000800ULL,
0x000000ffff307224ULL, 0x000fe200078e0018ULL, 0x0000001442007844ULL, 0x000be20000000200ULL,
0x000000ffff317224ULL, 0x000fe400078e001aULL, 0x000000ffff327224ULL, 0x000fe200078e0034ULL,
0x0000002811007844ULL, 0x000be20000000200ULL, 0x000000ffff337224ULL, 0x000fe200078e0036ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x000000ffff227224ULL, 0x000fc400078e000dULL,
0x000000ffff0d7224ULL, 0x000fe200078e001bULL, 0x0000003041007844ULL, 0x000be20000000200ULL,
0x000000ffff2d7224ULL, 0x000fe200078e002eULL, 0x000000494a35723eULL, 0x002fe400000010ffULL,
0x0000004c004c7308ULL, 0x000e620000000800ULL, 0x0000002045007844ULL, 0x000be20000000200ULL,
0x00000001ff0b7424ULL, 0x004fe400078e00ffULL, 0x000000ffff0e7224ULL, 0x000fe400078e0035ULL,
0x000000ffff0a7224ULL, 0x008fe200078e005cULL, 0x0000004b4c37723eULL, 0x002fca00000010ffULL,
0x000000ffff0f7224ULL, 0x000fe400078e0037ULL, 0x00000046341c723cULL, 0x000fe6000004181cULL,
0x0000000c40007844ULL, 0x0003e80000000200ULL, 0x01a0000410008388ULL, 0x0003de0000000c00ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e001cULL,
0x000000ffff2f7224ULL, 0x000fca00078e001eULL, 0x01a2002c10008388ULL, 0x0003e20000000c00ULL,
0x000000627300720cULL, 0x000fe20003f06070ULL, 0x01a6080b78ff79a7ULL, 0x0003e2000850003fULL,
0x01a6100b78ff79a7ULL, 0x0003e2000850003fULL, 0x01a6180b78ff79a7ULL, 0x0003e2000850003fULL,
0x01a6200b78ff79a7ULL, 0x0003f2000850003fULL, 0xffffff9000048947ULL, 0x020fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000084007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000008400008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff84ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000084027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000008400007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe8802e47950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004ebULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000668ULL, 0x0000000000000228ULL,
0x0000001500000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000890ULL, 0x00000000000000e0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000970ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000009c4ULL, 0x0000000000000710ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010d8ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010d8ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001120ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000017500ULL,
0x0000001500000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000018680ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000186c0ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000186c0ULL, 0x0000000000000278ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000018cb8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000018cb8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001120ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000017500ULL, 0x0000000000017500ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000018680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000186c0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000278ULL, 0x0000000000000278ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_90_cubin_len = 101896;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
