/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001e6c0ULL, 0x000000000001e340ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL,
0x326d735f61647563ULL, 0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL,
0x746e695f5f240068ULL, 0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL,
0x66625f636e79736cULL, 0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL,
0x5f30376d735f6164ULL, 0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL,
0x5f5f245f335f6c61ULL, 0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL,
0x2e616c65722e0074ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL,
0x766e2e0066754265ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL,
0x65642e006d617261ULL, 0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL,
0x616c65722e00656dULL, 0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL,
0x00000000006e6f69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000037fULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000003cdULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b002200000413ULL,
0x000000000001c760ULL, 0x0000000000000180ULL, 0x000b002200000446ULL, 0x000000000001c8e0ULL,
0x0000000000000040ULL, 0x000b002200000471ULL, 0x000000000001c920ULL, 0x0000000000000050ULL,
0x000b00220000049bULL, 0x000000000001c970ULL, 0x0000000000000110ULL, 0x000a000300000509ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000529ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000559ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001ca80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001c76000000000ULL, 0x0000040400000000ULL, 0x810c000001880400ULL, 0x0070440400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001c76000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080830828ULL,
0x2880808c08288080ULL, 0x808e082880808d08ULL, 0x082880808f082880ULL, 0x8080a808288080a5ULL,
0xbd08288080aa0828ULL, 0x288080ec08288080ULL, 0x80f208288080f008ULL, 0x08288080f3082880ULL,
0x8082801628808088ULL, 0x0000000000031028ULL, 0x2880808892000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x000000f000000000ULL, 0x0001c8e000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8808288080830828ULL,
0x2880808c08288080ULL, 0x808e082880808d08ULL, 0x082880808f082880ULL, 0x8080a908288080a5ULL,
0xbd08288080aa0828ULL, 0x288080ec08288080ULL, 0x80f208288080f008ULL, 0x08288080f3082880ULL,
0x80828016288080a8ULL, 0x0000000000031028ULL, 0x288080a892000000ULL, 0x0000000000002200ULL,
0x0000002cffffffffULL, 0x000001b000000000ULL, 0x0001c92000000000ULL, 0x0000005000000000ULL,
0x0000100400000000ULL, 0x80aa288080a80900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8808288080830828ULL, 0x2880808c08288080ULL, 0x808e082880808d08ULL,
0x082880808f082880ULL, 0x8080a808288080a5ULL, 0xbd08288080aa0828ULL, 0x288080ec08288080ULL,
0x80f208288080f008ULL, 0x08288080f3082880ULL, 0x80828016288080a9ULL, 0x0000000000031028ULL,
0x288080a992000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL, 0x0000028000000000ULL,
0x0001c97000000000ULL, 0x0000011000000000ULL, 0x0000080400000000ULL, 0x80aa288080a90900ULL,
0x0000000000002880ULL, 0x0000001900082f04ULL, 0x00082304000000f6ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008230400000000ULL, 0x0000000000000019ULL, 0x0000001900081204ULL, 0x0008110400000000ULL,
0x0000000000000019ULL, 0x0000007b00043704ULL, 0x0000001600080a04ULL, 0x0068190300680160ULL,
0x00000000000c1704ULL, 0x0021f0000060000aULL, 0x00000000000c1704ULL, 0x0021f00000580009ULL,
0x00000000000c1704ULL, 0x0011f00000500008ULL, 0x00000000000c1704ULL, 0x0081f00000300007ULL,
0x00000000000c1704ULL, 0x0021f00000280006ULL, 0x00000000000c1704ULL, 0x0021f00000200005ULL,
0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL, 0x0021f00000100003ULL,
0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL, 0x0011f00000040001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL, 0x019c290400000eb0ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x019c2804ffffffffULL,
0x0000034000000170ULL, 0x00002c80000005a0ULL, 0x00002e4000002d30ULL, 0x0000312000002fb0ULL,
0x0000370000003280ULL, 0x0000375000003740ULL, 0x0000686000003780ULL, 0x00006a10000068f0ULL,
0x00006cf000006b80ULL, 0x000072d000006e50ULL, 0x0000732000007310ULL, 0x0000a22000007350ULL,
0x0000a3d00000a2c0ULL, 0x0000a6b00000a540ULL, 0x0000ac600000a810ULL, 0x0000acb00000aca0ULL,
0x0000db600000ace0ULL, 0x0000dd100000dc00ULL, 0x0000dff00000de80ULL, 0x0000e5c00000e150ULL,
0x0000e6100000e600ULL, 0x000109a00000e640ULL, 0x000109c0000109b0ULL, 0x0001a380000109d0ULL,
0x0001a3d00001a3c0ULL, 0x0001a4300001a3e0ULL, 0x0001a4700001a450ULL, 0x0001b8d00001a480ULL,
0x0001b9700001b920ULL, 0x0001b9f00001b9b0ULL, 0x0001ba800001ba30ULL, 0x0001bb200001bad0ULL,
0x0001bbc00001bb70ULL, 0x0001bc600001bc10ULL, 0x0001bce00001bca0ULL, 0x0001bd700001bd20ULL,
0x0001be100001bdc0ULL, 0x0001beb00001be60ULL, 0x0001bf500001bf00ULL, 0x0001bfd00001bf90ULL,
0x0001c0600001c010ULL, 0x0001c1000001c0b0ULL, 0x0001c1a00001c150ULL, 0x0001c2400001c1f0ULL,
0x0001c2c00001c280ULL, 0x0001c3500001c300ULL, 0x0001c3f00001c3a0ULL, 0x0001c4a00001c440ULL,
0x0001c5600001c500ULL, 0x0001c6200001c5c0ULL, 0x0001c6e00001c680ULL, 0x044039040001c740ULL,
0x000000ff00000430ULL, 0x003f010000012600ULL, 0x0000000f00000470ULL, 0x003f012000012608ULL,
0x0000000f000004f0ULL, 0x003f012000012688ULL, 0x0000000f00000510ULL, 0x003f0120000126a8ULL,
0x0000000f00000530ULL, 0x003f0120000126c8ULL, 0x000000ff00000ed0ULL, 0x003f010700012600ULL,
0x00000002000010c0ULL, 0x003f010200000004ULL, 0x0000000200001170ULL, 0x003f010100000000ULL,
0x000000ff00001ae0ULL, 0x0004010700000000ULL, 0x000000ff00001b60ULL, 0x0004010100000000ULL,
0x0000000600001bc0ULL, 0x003f0101000126c8ULL, 0x0000000800001d50ULL, 0x003f0105000126ccULL,
0x0000000800001f30ULL, 0x003f0105000126ccULL, 0x0000000a00002870ULL, 0x003f0107000126b0ULL,
0x0000000a00002920ULL, 0x003f0101000126b0ULL, 0x0000002300002980ULL, 0x003f010100012608ULL,
0x00000023000029a0ULL, 0x003f01050001260cULL, 0x0000002300002b70ULL, 0x003f01050001260cULL,
0x0000000a00003430ULL, 0x003f0105000126acULL, 0x0000000a00003620ULL, 0x003f0105000126acULL,
0x0000006c00005a20ULL, 0x003f010100000000ULL, 0x0000002500005a80ULL, 0x003f010100012688ULL,
0x0000001300005ab0ULL, 0x003f010500000004ULL, 0x0000001300005c70ULL, 0x003f010500000004ULL,
0x0000001000006460ULL, 0x003f010700000000ULL, 0x0000001000006540ULL, 0x003f010100000000ULL,
0x00000023000065a0ULL, 0x003f010100012628ULL, 0x00000023000065c0ULL, 0x003f01050001262cULL,
0x0000002300006790ULL, 0x003f01050001262cULL, 0x0000006e00007040ULL, 0x003f0105000126b4ULL,
0x0000006e00007210ULL, 0x003f0105000126b4ULL, 0x0000006e000093c0ULL, 0x003f010100000000ULL,
0x0000002800009420ULL, 0x003f010100012690ULL, 0x0000001300009450ULL, 0x003f010500000004ULL,
0x0000001300009610ULL, 0x003f010500000004ULL, 0x000000ff00009e10ULL, 0x0004010700000008ULL,
0x0000002a00009f00ULL, 0x003f0101000126b0ULL, 0x0000002300009f60ULL, 0x003f010100012648ULL,
0x0000002300009f80ULL, 0x003f01050001264cULL, 0x000000230000a150ULL, 0x003f01050001264cULL,
0x000000100000a9d0ULL, 0x003f010500000004ULL, 0x000000100000aba0ULL, 0x003f010500000004ULL,
0x000000130000cd10ULL, 0x003f010100000000ULL, 0x000000020000cd70ULL, 0x003f010100012698ULL,
0x000000130000cda0ULL, 0x003f010500000004ULL, 0x000000130000cf60ULL, 0x003f010500000004ULL,
0x000000ff0000d7c0ULL, 0x0004010700000000ULL, 0x000000100000d850ULL, 0x003f010100000000ULL,
0x000000060000d8b0ULL, 0x003f010100012668ULL, 0x000000060000d8e0ULL, 0x003f01050001266cULL,
0x000000060000dab0ULL, 0x003f01050001266cULL, 0x000000120000e320ULL, 0x003f0105000126b4ULL,
0x000000120000e4f0ULL, 0x003f0105000126b4ULL, 0x0000001300010750ULL, 0x003f010100000000ULL,
0x00000006000107d0ULL, 0x003f010100000000ULL, 0x000000ff00012a50ULL, 0x003f010100012600ULL,
0x000000ff000136b0ULL, 0x003f010500012604ULL, 0x000000ff000138c0ULL, 0x003f010500012604ULL,
0x000000ff00013c40ULL, 0x003f010100012600ULL, 0x000000ff00013c70ULL, 0x003f010500012604ULL,
0x000000ff00013e30ULL, 0x003f010500012604ULL, 0x00000068000175f0ULL, 0x003f010100000000ULL,
0x00000068000176e0ULL, 0x003f010500000004ULL, 0x00000068000178b0ULL, 0x003f010500000004ULL,
0x0000006c0001b730ULL, 0x003f010100000000ULL, 0x0000006c0001b790ULL, 0x003f010100000008ULL,
0x0000006c0001b7f0ULL, 0x003f010100000010ULL, 0x0000006c0001b860ULL, 0x003f010100000018ULL,
0x00301c0400053803ULL, 0x0001196000011930ULL, 0x00011df000011c00ULL, 0x000121d000011fe0ULL,
0x000125b0000123c0ULL, 0x00012960000127b0ULL, 0x0001b8a000013e90ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000032cULL, 0x0000001900000002ULL, 0x000000000000025cULL,
0x0000001900000002ULL, 0x000000000000019cULL, 0x0000001900000002ULL, 0x00000000000000ccULL,
0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL, 0x0000000000000303ULL,
0x0000001900000002ULL, 0x0000000000000233ULL, 0x0000001900000002ULL, 0x0000000000000173ULL,
0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL, 0x0000000000012700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff030424ULL, 0x000fe200078e00ffULL,
0x0000000104060810ULL, 0x002fca0007ffe0ffULL, 0x00005c0006060625ULL, 0x000fc800078e0003ULL,
0x00005c0004020625ULL, 0x000fe200078e0003ULL, 0x0000000606610981ULL, 0x0002aa000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff107624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x00000000001e7919ULL, 0x000e620000002600ULL, 0x00005a00ff117624ULL, 0x000fc600078e00ffULL,
0x00000000000e7919ULL, 0x000e620000002300ULL, 0x0000590011117a24ULL, 0x000fc600078e02ffULL,
0x00000000000a7919ULL, 0x000e620000002100ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00087810ULL, 0x010fe40007ffe0ffULL, 0x00000005ff1f7819ULL, 0x002fc8000001160aULL,
0x0000000800097305ULL, 0x000324000021f000ULL, 0x00001fff1f1f7589ULL, 0x000fe200000e0000ULL,
0x000000ffff087224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a09ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000509097227ULL, 0x000fcc00078e0008ULL,
0x0000040009057a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x008fc800078e0a05ULL,
0x0000040003007624ULL, 0x000fca00078e0210ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff05ba12ULL, 0x000fc800078e33ffULL, 0x0000000500007306ULL, 0x000e620000209000ULL,
0x000000ff0500720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00067810ULL, 0x002fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x0002e4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x0000000705037224ULL, 0x008fc800078e02ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a03ULL, 0x0000000307077227ULL, 0x000fe400078e0006ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x0000001e07207227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a20ULL, 0x0000000005007224ULL, 0x000fca00078e021eULL,
0x000000050000720cULL, 0x000fe20003fa6070ULL, 0x000001000e037a24ULL, 0x002fe400078e0203ULL,
0x00001fff0e0e7589ULL, 0x000e6400000e0000ULL, 0x00000000030f7a24ULL, 0x000fd000078e020aULL,
0x0000000100005824ULL, 0x000fe200078e0a05ULL, 0x0000000120205810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0f00720cULL, 0x040fe40003f65270ULL, 0x000000050000720cULL, 0x000fe40003fc6070ULL,
0x0000000f0f00780cULL, 0x040fe40003f24070ULL, 0x000000030f00780cULL, 0x040fe40003fa4070ULL,
0x0000007f0f00780cULL, 0x000fca0003f44070ULL, 0x3fffff80ff06b424ULL, 0x000fe400078e00ffULL,
0x0000000120206810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff07b424ULL, 0x000fe200078e00ffULL,
0x00000005ff20c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff089424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL, 0x01260006ff00b388ULL, 0x0007e20000000a00ULL,
0x000000ffff007224ULL, 0x000fe200078e0a20ULL, 0x000000010f00780cULL, 0x000fe20003f64070ULL,
0x3fffff80ff0ad424ULL, 0x000fe200078e00ffULL, 0x012608080f009388ULL, 0x000fe20000008a00ULL,
0x00000000051e7224ULL, 0x000fc400078e021eULL, 0x7fffff80ff0bd424ULL, 0x000fe400078e00ffULL,
0x000000201e1e7824ULL, 0x000fe400078e00ffULL, 0x3fffff60ff06d424ULL, 0x008fe400078e00ffULL,
0x7fffff60ff07d424ULL, 0x000fe400078e00ffULL, 0xff317217ff12a424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL, 0x012688060f00d388ULL, 0x000fe20000008a00ULL,
0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL, 0x0126a80a0f00d388ULL, 0x000fe80000008a00ULL,
0x012400120f00a388ULL, 0x000fe80000004800ULL, 0x0126c80c0f00b388ULL, 0x000fe20000008a00ULL,
0x0000000161610824ULL, 0x004fe400078e0a02ULL, 0x00005800ff618624ULL, 0x000fc400078e00ffULL,
0x0000580004028a24ULL, 0x000fe400078e02ffULL, 0x00005a0061037a24ULL, 0x000fe400078e02ffULL,
0x0000001102777224ULL, 0x000fe400078e02ffULL, 0x0000000103007824ULL, 0x040fe200078e0a1eULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001e0300720cULL, 0x000fe20003f26070ULL,
0x00005a0020127a24ULL, 0x000fe200078e0277ULL, 0x0000002000007817ULL, 0x000fc80003800000ULL,
0x000000ff00767207ULL, 0x000fe20000800000ULL, 0x000000040e007824ULL, 0x002fc600078e021fULL,
0x000000207600780cULL, 0x000fe20003f05270ULL, 0x0000000400007824ULL, 0x000fd800078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a0000037b06ULL, 0x000e620000209000ULL,
0x00000000001d7919ULL, 0x000ea20000000000ULL, 0x000000ffff067224ULL, 0x000fcc00078e00ffULL,
0x0000000300037308ULL, 0x002e620000001000ULL, 0x00000004ff057819ULL, 0x004fc8000001161dULL,
0x0000000205097810ULL, 0x000fe20007ffe0ffULL, 0x00000001000a7824ULL, 0x000fe200078e0205ULL,
0x0ffffffe03077810ULL, 0x002fc60007ffe0ffULL, 0x00000001000b7824ULL, 0x000fc600078e0209ULL,
0x0000000700077305ULL, 0x000e62000021f000ULL, 0x000000011e0c7824ULL, 0x000fe400078e020bULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d07037227ULL, 0x000fc800078e0006ULL, 0x000000011e067824ULL, 0x000fe400078e020aULL,
0x0000000c030d7227ULL, 0x000fc800078e00ffULL, 0x0000000603077227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a07ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a0dULL,
0x00005a0003037a24ULL, 0x000fe400078e0206ULL, 0x00005a000f087a24ULL, 0x000fc600078e020cULL,
0x00005a0003007a0cULL, 0x000fe40003f06070ULL, 0x00005a0008007a0cULL, 0x000fd60003f46070ULL,
0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f26070ULL, 0x00005a0008007a0cULL, 0x000fe40003f66070ULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff087a12ULL, 0x000fe400078e33ffULL,
0x0000000076037217ULL, 0x000fe40007800000ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x000000010d0d3810ULL, 0x000fe20007ffe0ffULL, 0x0000000103007824ULL, 0x000fe200078e0a00ULL,
0x0000000708077207ULL, 0x040fe20004000000ULL, 0x000000101d037824ULL, 0x000fe200078e00ffULL,
0x0000000d08087207ULL, 0x000fc40004000000ULL, 0x000000000500720cULL, 0x080fe20003f06070ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0a07ULL, 0x000000000900720cULL, 0x000fe20003f26070ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0a08ULL, 0x000000f003057812ULL, 0x000fe200078ec0ffULL,
0x00005a000d067a24ULL, 0x000fe400078e0206ULL, 0x00005a000f0c7a24ULL, 0x000fe400078e020cULL,
0x0000000112067824ULL, 0x040fe400078e0206ULL, 0x00000001120d7824ULL, 0x000fc400078e020cULL,
0x0000001107067224ULL, 0x080fe400078e0206ULL, 0x0000001108087224ULL, 0x000fe400078e020dULL,
0x0000010006067825ULL, 0x000fc800078e00ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000506067212ULL, 0x000fc600078efcffULL, 0x000000010a007824ULL, 0x100fe200078e021dULL,
0x0000000508057212ULL, 0x000fe200078efcffULL, 0x000000100a0d7824ULL, 0x000fe200078e00ffULL,
0x0000600006067a10ULL, 0x000fe20007f5e0ffULL, 0x000000010b0a7824ULL, 0x000fe200078e021dULL,
0x0000600005087a10ULL, 0x000fe20007f7e0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff00d007812ULL, 0x000fe400078ee200ULL, 0x0000610007077a10ULL, 0x000fe400017fe4ffULL,
0xfffffff00b0a7812ULL, 0x000fe200078ee20aULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x0000610009097a10ULL, 0x000fc60001ffe4ffULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e8000c101c46ULL,
0x00000000080b7faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a0000037b06ULL, 0x000e620000209000ULL, 0x00000000001d7919ULL, 0x000eae0000000000ULL,
0x0000000300037308ULL, 0x002e620000001000ULL, 0x000000001d007211ULL, 0x004fc800078fe0ffULL,
0x00000002000a7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe03067810ULL, 0x002fe20007ffe0ffULL,
0x000000011e037824ULL, 0x000fc600078e0200ULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fc800078e02ffULL, 0x0000000507087227ULL, 0x000fc800078e0006ULL,
0x000000011e077824ULL, 0x000fe400078e020aULL, 0x0000000308057227ULL, 0x000fc800078e00ffULL,
0x0000000708087227ULL, 0x000fc800078e00ffULL, 0x000000ffff067224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x00005a0006067a24ULL, 0x000fe400078e0203ULL,
0x00005a000c097a24ULL, 0x000fc600078e0207ULL, 0x00005a0006007a0cULL, 0x000fe40003f06070ULL,
0x00005a0009007a0cULL, 0x000fd60003f46070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00005a0009007a0cULL, 0x000fe40003f66070ULL, 0x0000000105050810ULL, 0x000fe40007ffe0ffULL,
0x0000000108082810ULL, 0x000fc40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a00ff067a12ULL, 0x000fc600078e33ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x0000000108083810ULL, 0x000fe40007ffe0ffULL, 0x0000000506057207ULL, 0x040fe40004000000ULL,
0x0000000806087207ULL, 0x000fc60004000000ULL, 0x000000ffff067224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x00005a0006037a24ULL, 0x000fe400078e0203ULL,
0x00005a000c077a24ULL, 0x000fe400078e0207ULL, 0x0000000112067824ULL, 0x040fe400078e0203ULL,
0x0000000112077824ULL, 0x000fc400078e0207ULL, 0x000000101d037824ULL, 0x000fe400078e00ffULL,
0x0000001105067224ULL, 0x080fe400078e0206ULL, 0x0000001108087224ULL, 0x000fe200078e0207ULL,
0x000000f0030b7812ULL, 0x000fe200078ec0ffULL, 0x0000010006067825ULL, 0x000fc800078e00ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000000b06067212ULL, 0x000fc600078efcffULL,
0x0000000100057824ULL, 0x100fe200078e021dULL, 0x0000000b08087212ULL, 0x000fe200078efcffULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x0000600006067a10ULL, 0x000fe20007f1e0ffULL,
0x000000010a007824ULL, 0x000fe200078e021dULL, 0x0000600008087a10ULL, 0x000fe20007f3e0ffULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00c057812ULL, 0x000fe400078ee205ULL,
0x0000610007077a10ULL, 0x000fe400007fe4ffULL, 0xfffffff00b007812ULL, 0x000fe200078ee200ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x0000610009097a10ULL, 0x000fc60000ffe4ffULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e8000b901c46ULL, 0x00000000080b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x0000000000007806ULL, 0x000fe200038e0000ULL,
0x00000004ff2b7424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000057300ULL, 0x000e7000000e0000ULL, 0x0000000000077309ULL, 0x000ea20000000000ULL,
0x000000060500720cULL, 0x002fe20003f02070ULL, 0x000000ffff057224ULL, 0x004fc400078e0a07ULL,
0x0000680004067625ULL, 0x000fd400078e002bULL, 0x01260405ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01260000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006061c7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fe40003f05270ULL,
0x0000007f1c1b7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff1c057810ULL, 0x002fc40007ffe0ffULL,
0x00000007ff1b7819ULL, 0x000fe4000001161bULL, 0x00000008ff1a7819ULL, 0x000fca0000011605ULL,
0x0001196000008947ULL, 0x000fea0003800000ULL, 0x00000003ff197819ULL, 0x000fe2000001161fULL,
0x00000003ff097424ULL, 0x000fe200078e00ffULL, 0x000126881f027811ULL, 0x000fe200078e18ffULL,
0xffffffffff247424ULL, 0x000fe200078e00ffULL, 0x01ffffff19197812ULL, 0x000fc800078ec0ffULL,
0x0000001b1900720cULL, 0x000fda0003f06070ULL, 0x0000000204008824ULL, 0x000fe400078e00ffULL,
0x00006a00ff078624ULL, 0x000fc800078e00ffULL, 0x00006a0000008624ULL, 0x000fc800078e0207ULL,
0x0000000119008824ULL, 0x000fe200078e0200ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040902ff738cULL, 0x0003e20000000000ULL, 0x0000660000068625ULL, 0x000fe200078e002bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000606248981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0500780cULL, 0x000fe20003f04070ULL, 0x0000008020177824ULL, 0x000fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe2000001161fULL, 0x0000000002ff7f8cULL, 0x0007e2000c80043fULL,
0x000000011f007812ULL, 0x000fc600078ec0ffULL, 0x0000002018807824ULL, 0x000fca00078e00ffULL,
0x0000006017057812ULL, 0x000fe200078ef880ULL, 0x0000590024087a24ULL, 0x004fc800078e02ffULL,
0x0000008008157824ULL, 0x000fe200078e00ffULL, 0x0000040000000947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x10afe2000001161dULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x000000801c077217ULL, 0x000fe40007800000ULL, 0x0000000402097810ULL, 0x000fe20007ffe0ffULL,
0x0000000100067824ULL, 0x000fe200078e0202ULL, 0x00006400150f7a11ULL, 0x000fe200078838ffULL,
0x0000000107077824ULL, 0x000fe400078e0a80ULL, 0x0000000106087824ULL, 0x040fe200078e021dULL,
0x0000650015157a11ULL, 0x000fe200020f3cffULL, 0x00000008060b7824ULL, 0x000fe200078e00ffULL,
0x0000000007077217ULL, 0x000fe20007800000ULL, 0x0000000105067824ULL, 0x000fc600078e0206ULL,
0xfffffff80b0e7812ULL, 0x000fe200078ee208ULL, 0x0000000107077824ULL, 0x000fe200078e0a00ULL,
0x0000000802087810ULL, 0x040fe40007ffe0ffULL, 0x0000000c020b7810ULL, 0x040fe40007ffe0ffULL,
0x000000070200720cULL, 0x080fe20003f66070ULL, 0x00000001000a7824ULL, 0x000fe200078e0208ULL,
0x000000070800720cULL, 0x080fe20003f26070ULL, 0x0000000100027824ULL, 0x000fe200078e0209ULL,
0x000000070900720cULL, 0x080fe20003f46070ULL, 0x000000010a087824ULL, 0x040fe200078e021dULL,
0x000000070b00720cULL, 0x000fe20003f06070ULL, 0x000000080a0d7824ULL, 0x000fc400078e00ffULL,
0x00000001000c7824ULL, 0x000fe400078e020bULL, 0x0000000102007824ULL, 0x040fe200078e021dULL,
0xfffffff80d107812ULL, 0x000fe200078ee208ULL, 0x0000000802097824ULL, 0x000fe400078e00ffULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0xfffffff809007812ULL, 0x000fe200078ee200ULL,
0x0000000105087824ULL, 0x040fe200078e0202ULL, 0x0000007006067812ULL, 0x000fe200078ef803ULL,
0x00000001050a7824ULL, 0x040fe400078e020aULL, 0x00000001050d7824ULL, 0x000fe200078e020cULL,
0x000000060f067210ULL, 0x000fe20007f9e0ffULL, 0x000000010c027824ULL, 0x040fe400078e021dULL,
0x000000080c057824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff805127812ULL, 0x000fe200078ee202ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008027812ULL, 0x000fc600078ef803ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a087812ULL, 0x000fc600078ef803ULL, 0x0000000107077824ULL, 0x000fe200020e0615ULL,
0x000000700c0a7812ULL, 0x000fe400078ef803ULL, 0x0000e00018037811ULL, 0x000fe400078e68ffULL,
0x0000000f02027210ULL, 0x080fe40007f9e0ffULL, 0x0000000f08087210ULL, 0x080fe20007fbe0ffULL,
0x000000100e057824ULL, 0x100fe200078e0203ULL, 0x0000000f0a0a7210ULL, 0x000fe20007fde0ffULL,
0x00000010000f7824ULL, 0x000fc400078e0203ULL, 0x0000001010117824ULL, 0x100fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000d901c46ULL,
0x0000001012137824ULL, 0x000fe400078e0203ULL, 0x0000000109037824ULL, 0x100fe400020e0615ULL,
0x000000010b097824ULL, 0x100fe400028e0615ULL, 0x000000010d0b7824ULL, 0x000fe200030e0615ULL,
0x00000000020f7faeULL, 0x0003e8000d101c46ULL, 0x0000000008117faeULL, 0x0003e8000c901c46ULL,
0x000000000a137faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001000007824ULL, 0x008fe200078e00ffULL, 0x0000640015117a11ULL, 0x000fc400078038ffULL,
0x0000e00018137811ULL, 0x000fe400078e68ffULL, 0x000000001d007211ULL, 0x000fe400078fe8ffULL,
0x0000650015157a11ULL, 0x000fe400000f3cffULL, 0x00000008000a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000100027824ULL, 0x042fe200078e021dULL, 0x0000000400087810ULL, 0x040fe20007ffe0ffULL,
0x0000000800077824ULL, 0x000fe400078e00ffULL, 0x000000080a107824ULL, 0x000fc400078e00ffULL,
0x0000000105067824ULL, 0x000fe200078e0200ULL, 0xfffffff8070e7812ULL, 0x000fe200078ee202ULL,
0x000000010a077824ULL, 0x100fe200078e021dULL, 0x0000000c00007810ULL, 0x000fe20007ffe0ffULL,
0x0000000108027824ULL, 0x040fe400078e021dULL, 0x00000008080f7824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee202ULL, 0x0000000105087824ULL, 0x040fe200078e0208ULL,
0x0000007006067812ULL, 0x000fe200078ef803ULL, 0x00000001050a7824ULL, 0x040fe400078e020aULL,
0x00000001050c7824ULL, 0x000fe200078e0200ULL, 0x0000000611067210ULL, 0x000fe20007f1e0ffULL,
0x0000000100027824ULL, 0x040fe400078e021dULL, 0x0000000800057824ULL, 0x000fe400078e00ffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff805007812ULL, 0x000fe200078ee202ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007008027812ULL, 0x000fc600078ef803ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a087812ULL, 0x000fc600078ef803ULL,
0x0000000107077824ULL, 0x000fe200000e0615ULL, 0x000000700c037812ULL, 0x000fe200078ef803ULL,
0x000000100e057824ULL, 0x100fe200078e0213ULL, 0x0000000211027210ULL, 0x000fe20007f1e0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0213ULL, 0x0000000811087210ULL, 0x040fe40007f3e0ffULL,
0x00000003110a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000109037824ULL, 0x000fe200000e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000b901c46ULL,
0x0000001010117824ULL, 0x000fc400078e0213ULL, 0x000000010b097824ULL, 0x000fe200008e0615ULL,
0x00000000020f7faeULL, 0x0003e2000b901c46ULL, 0x0000001000137824ULL, 0x000fe400078e0213ULL,
0x000000010d0b7824ULL, 0x000fe200010e0615ULL, 0x0000000008117faeULL, 0x0003e8000b901c46ULL,
0x000000000a137faeULL, 0x0003e4000b901c46ULL, 0x00000000180473c2ULL, 0x000ea200000e0000ULL,
0x000000ff1a00720cULL, 0x000fe20003f05270ULL, 0x0000000818067824ULL, 0x002fe200078e00ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x000126a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3d7224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff027f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126c80006067f8cULL, 0x000ea2000c80043fULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000eba000008947ULL, 0x000fea0003800000ULL, 0x0000000204167824ULL, 0x000fe200078e00ffULL,
0x00000002ff157819ULL, 0x000fe2000001161fULL, 0x00006a00ff057624ULL, 0x000fe200078e00ffULL,
0x0000000118757812ULL, 0x000fe200078ec0ffULL, 0x000000ffff007224ULL, 0x002fc400078e0003ULL,
0x000000ffff037224ULL, 0x004fe400078e0007ULL, 0x00006a0016167624ULL, 0x000fe400078e0205ULL,
0xff317217ff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff147224ULL, 0x000fe400078e00ffULL,
0x000000ffff6b7224ULL, 0x000fc400078e00ffULL, 0x0000000000047805ULL, 0x01afca0000015200ULL,
0x000000041f067824ULL, 0x000fca00078e00ffULL, 0xfffffff806087812ULL, 0x000fc800078ec0ffULL,
0x000126c808137810ULL, 0x000fe20007ffe0ffULL, 0x0126cc0008067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126cc0008067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101f037824ULL, 0x000fe200078e00ffULL,
0x0000000114077810ULL, 0x000fe20007ffe0ffULL, 0x0000590024247a24ULL, 0x000fc600078e02ffULL,
0xffffffe003057812ULL, 0x000fe200078ec0ffULL, 0x0000008024247824ULL, 0x000fe200078e00ffULL,
0x0000001a0700720cULL, 0x000fc60003f46070ULL, 0x0000010014057824ULL, 0x000fca00078e0205ULL,
0x0000004005057810ULL, 0x000fc80007ffe0ffULL, 0x0000006005047812ULL, 0x000fca00078ec0ffULL,
0x00000001170b7824ULL, 0x000fe200078e0204ULL, 0x000004200000a947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe200078ec0ffULL, 0x000000101d087824ULL, 0x000fe200078e00ffULL,
0x000000051c037217ULL, 0x000fe40007800000ULL, 0x00000003ff077819ULL, 0x000fe4000001161dULL,
0x0000007008257812ULL, 0x000fe200078ec0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a05ULL,
0x0000000407087810ULL, 0x040fe20007ffe0ffULL, 0x0000000107067824ULL, 0x040fe200078e0204ULL,
0x0000000807097810ULL, 0x000fc40007ffe0ffULL, 0x0000000403037217ULL, 0x000fe20007800000ULL,
0x0000000106057824ULL, 0x040fe200078e021dULL, 0x0000000c070a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000806107824ULL, 0x000fe200078e00ffULL, 0x0000640024237a11ULL, 0x000fe200078c38ffULL,
0x0000000103037824ULL, 0x100fe400078e0a04ULL, 0x000000010a267824ULL, 0x000fe200078e0204ULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x000000010b057824ULL, 0x000fe200078e0206ULL,
0x000000030800720cULL, 0x0c0fe20003f86070ULL, 0x0000000108067824ULL, 0x100fe200078e0204ULL,
0x000000030700720cULL, 0x080fe20003fa6070ULL, 0x0000000109087824ULL, 0x040fe200078e0204ULL,
0x000000030a00720cULL, 0x080fe20003f06070ULL, 0x0000000106077824ULL, 0x040fe200078e021dULL,
0x000000030900720cULL, 0x000fe20003f66070ULL, 0x0000000806127824ULL, 0x000fe200078e00ffULL,
0x0000650024277a11ULL, 0x000fe200030f3cffULL, 0x0000008005047825ULL, 0x000fc600078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x000000010b067824ULL, 0x040fe200078e0206ULL,
0x00000025040a7212ULL, 0x000fe200078efcffULL, 0x000000010b097824ULL, 0x000fe400078e0208ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000000a230a7210ULL, 0x000fc60007fde0ffULL,
0x0000000108037824ULL, 0x000fe200078e021dULL, 0x0000002506067212ULL, 0x000fe200078efcffULL,
0x0000000808247824ULL, 0x000fe400078e00ffULL, 0x0000008009087825ULL, 0x000fc600078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee203ULL, 0x000000010b047824ULL, 0x000fe200078e0226ULL,
0x0000002508087212ULL, 0x000fe200078efcffULL, 0x00000001050b7824ULL, 0x000fe200030e0627ULL,
0x0000002306067210ULL, 0x000fe20007fde0ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x0000f00018037811ULL, 0x000fc600078e68ffULL, 0x0000000107077824ULL, 0x000fe200030e0627ULL,
0x0000002308087210ULL, 0x000fe20007fde0ffULL, 0x0000000126217824ULL, 0x000fe200078e021dULL,
0x0000002504047212ULL, 0x000fe200078efcffULL, 0x0000000826267824ULL, 0x000fe400078e00ffULL,
0x0000000109097824ULL, 0x000fe200030e0627ULL, 0x0000002304047210ULL, 0x000fe20007fde0ffULL,
0x0000001012237824ULL, 0x000fe200078e0203ULL, 0xfffffff826267812ULL, 0x000fe200078ee221ULL,
0x0000001010217824ULL, 0x000fc400078e0203ULL, 0x0000001024257824ULL, 0x100fe400078e0203ULL,
0x0000001026037824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a217faeULL, 0x0003e2000e901c46ULL, 0x0000000105057824ULL, 0x000fc600030e0627ULL,
0x0000000006237faeULL, 0x0003e8000e101c46ULL, 0x0000000008257faeULL, 0x0003e8000d901c46ULL,
0x0000000004037faeULL, 0x0003e2000c101c46ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe200078ec0ffULL, 0x000000101d097824ULL, 0x000fe200078e00ffULL,
0x0000640024257a11ULL, 0x000fc400078038ffULL, 0x000000041d047211ULL, 0x000fe400078fe8ffULL,
0x0000007009237812ULL, 0x000fe400078ec0ffULL, 0x0000000404067810ULL, 0x040fe20007ffe0ffULL,
0x0000000104037824ULL, 0x140fe200078e021dULL, 0x0000000804087810ULL, 0x040fe20007ffe0ffULL,
0x00000008040a7824ULL, 0x000fe200078e00ffULL, 0x0000650024277a11ULL, 0x000fe200000f3cffULL,
0x0000000106057824ULL, 0x000fe200078e021dULL, 0x0000f00018297811ULL, 0x000fe200078e68ffULL,
0x0000000806107824ULL, 0x000fe200078e00ffULL, 0xfffffff80a037812ULL, 0x000fe200078ee203ULL,
0x0000000108077824ULL, 0x000fe200078e021dULL, 0x0000000c040a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000808127824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee205ULL,
0x000000010b057824ULL, 0x000fc400078e0204ULL, 0x000000010b067824ULL, 0x000fe200078e0206ULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x0000008005047825ULL, 0x000fc800078e00ffULL,
0x000000010b087824ULL, 0x040fe200078e0208ULL, 0x0000002304047212ULL, 0x000fe200078efcffULL,
0x000000010b0b7824ULL, 0x000fe400078e020aULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000000425047210ULL, 0x000fc60007f1e0ffULL, 0x000000010a217824ULL, 0x000fe200078e021dULL,
0x0000002306067212ULL, 0x000fe200078efcffULL, 0x000000080a247824ULL, 0x000fe400078e00ffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee221ULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x0000002308087212ULL, 0x000fc600078efcffULL,
0x0000000105057824ULL, 0x000fe200000e0627ULL, 0x000000230a0a7212ULL, 0x000fe200078efcffULL,
0x0000001003037824ULL, 0x100fe200078e0229ULL, 0x0000000625067210ULL, 0x040fe20007f1e0ffULL,
0x0000001010217824ULL, 0x100fe200078e0229ULL, 0x0000000825087210ULL, 0x040fe20007f7e0ffULL,
0x0000001012237824ULL, 0x000fe200078e0229ULL, 0x0000000a250a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000107077824ULL, 0x100fe200000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e2000b901c46ULL, 0x0000000109097824ULL, 0x000fc400018e0627ULL,
0x0000001024257824ULL, 0x000fe200078e0229ULL, 0x0000000006217faeULL, 0x0003e2000b901c46ULL,
0x000000010b0b7824ULL, 0x000fc600020e0627ULL, 0x0000000008237faeULL, 0x0003e8000b901c46ULL,
0x000000000a257faeULL, 0x0003e4000b901c46ULL, 0x000000081f037824ULL, 0x002fe200078e00ffULL,
0x0000000119047810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff0030a7812ULL, 0x040fe400078ec0ffULL, 0x0000001b0400720cULL, 0x000fe40003f06070ULL,
0x000000000a0573c2ULL, 0x000e6200000e0000ULL, 0xffffffe003237812ULL, 0x040fe400078ec0ffULL,
0x0000001003067812ULL, 0x040fe400078ec0ffULL, 0x0000000803037812ULL, 0x000fcc00078ec0ffULL,
0x0000000116048824ULL, 0x000fe400078e0204ULL, 0x00000004ff058424ULL, 0x000fe200078e00ffULL,
0x0000002303237210ULL, 0x000fe40007ffe006ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000660004048625ULL, 0x000fca00078e0005ULL, 0x0000000604248981ULL, 0x000522000c1e1900ULL,
0x000126b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0126b0000a267f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126080023087f8cULL, 0x000664000c80043fULL, 0x0000000000047805ULL, 0x000fc40000015200ULL,
0x01260c0023037984ULL, 0x000ee40000000800ULL, 0x8000000003ff7812ULL, 0x00afe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260c0023037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101d127824ULL, 0x000fe200078e00ffULL, 0x00000001ff747819ULL, 0x000fe2000001161dULL,
0x000000201f037824ULL, 0x000fe400078e00ffULL, 0xffffffffff817424ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x000fc400078ec0ffULL, 0xffffff8003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c74747812ULL, 0x000fc800078ec0ffULL, 0x0000000374037210ULL, 0x000fca0007ffe012ULL,
0x0120000003057984ULL, 0x000e680000000800ULL, 0x0122000003047984ULL, 0x0006a20000000800ULL,
0x000000020500720bULL, 0x002fe20003f1d000ULL, 0x00018c327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000037806ULL, 0x008fc800000e0100ULL, 0x000000ff0300720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x000000ffff217224ULL, 0x000fc400078e0002ULL, 0x0000001fff837424ULL, 0x000fe400078e00ffULL,
0xffffffffff827424ULL, 0x000fca00078e00ffULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x0000001f1500720cULL, 0x000fe40003f05270ULL, 0x000000020500720bULL, 0x000fe20003f74000ULL,
0x00018bd27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x000fc400018e0100ULL,
0x000000801f078824ULL, 0x000fe200078e0212ULL, 0x0000000205217209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000174108824ULL, 0x000fca00078e0207ULL,
0x0124002110008388ULL, 0x0003e20000000800ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000000221027221ULL, 0x002fe20000010100ULL,
0x000000ff08ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b02027820ULL, 0x000fcc0000410000ULL, 0x0000000200027308ULL, 0x000e640000000800ULL,
0x0000000222227220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161dULL, 0x00018b127f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0008ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081d297811ULL, 0x000fe200078ff0ffULL,
0x000189e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2902297589ULL, 0x00066400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000008ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101d297811ULL, 0x000fe200078ff0ffULL, 0x000188b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000008ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181d297811ULL, 0x000fe200078ff0ffULL, 0x000187927f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000000803ff7212ULL, 0x000fda00078030ffULL, 0x8000002105050221ULL, 0x000fe20000010000ULL,
0x00007610ff060816ULL, 0x000fc60000000006ULL, 0x3fb8aa3b05050820ULL, 0x000fc80000410000ULL,
0x0000000500110308ULL, 0x000e640000000800ULL, 0x0000001104040220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002204227221ULL, 0x004fc20000010000ULL,
0x0000000000027805ULL, 0x008fcc0000015200ULL, 0x0126ac000a057984ULL, 0x000e620000000800ULL,
0x000126a80a107810ULL, 0x000fe40007ffe0ffULL, 0x8000000005ff7812ULL, 0x002fe20007804800ULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000704047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0126ac000a057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991006007816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff037819ULL, 0x000fe4000001161dULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000183527f007947ULL, 0x000fea000b800000ULL,
0x00001f03000f7589ULL, 0x0002a400000e0000ULL, 0x0000000803297810ULL, 0x000fe20007ffe0ffULL,
0x000183827f007947ULL, 0x000fea000b800000ULL, 0x00000010030d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f29000e7589ULL, 0x00066a00000e0000ULL, 0x00001f0d000d7589ULL, 0x0006a400000e0000ULL,
0x0000001803297810ULL, 0x008fe20007ffe0ffULL, 0x000183d27f007947ULL, 0x000fea000b800000ULL,
0x00001f29000c7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000021f257824ULL, 0x000fe200078e00ffULL, 0x000000081d007812ULL, 0x00afe200078ec0ffULL,
0x000000041f047824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000010001f057824ULL, 0x000fe200078e00ffULL, 0x0000000425027812ULL, 0x000fe200078ec0ffULL,
0x0000024000007945ULL, 0x000fe20003800000ULL, 0x00000007000b7812ULL, 0x000fc400078ef81dULL,
0x000000021d007211ULL, 0x000fe400078fe0ffULL, 0x000000100b0a7812ULL, 0x040fe200078efcffULL,
0x000000080b067824ULL, 0x040fe200078e00ffULL, 0x0000000404047812ULL, 0x000fe200078ec0ffULL,
0x000000010b097824ULL, 0x000fe200078e0200ULL, 0xffffe00005057812ULL, 0x000fe200078ec0ffULL,
0x0000000100087824ULL, 0x000fe400078e020aULL, 0x000004001f007824ULL, 0x000fe200078e00ffULL,
0xfffffff806097812ULL, 0x000fe200078ee209ULL, 0x000000080a037824ULL, 0x000fe200078e00ffULL,
0x0000e00005057810ULL, 0x000fe20007ffe0ffULL, 0x000000080b077824ULL, 0x040fe200078e00ffULL,
0xfffff00000007812ULL, 0x000fe200078ec0ffULL, 0x000000080b797824ULL, 0x000fe200078e00ffULL,
0xfffffff803087812ULL, 0x000fc400078ee208ULL, 0x000000041d037211ULL, 0x000fe400078fe0ffULL,
0x0000a00000007810ULL, 0x000fc60007ffe0ffULL, 0x000000010b047824ULL, 0x000fe400078e0203ULL,
0x00000010096c7824ULL, 0x100fe400078e0200ULL, 0x0000001008287824ULL, 0x000fe200078e0200ULL,
0xfffffff807077812ULL, 0x000fe400078ee204ULL, 0x0000000204067810ULL, 0x000fe20007ffe0ffULL,
0x000000006c6c783bULL, 0x000e640000000200ULL, 0x0000001007707824ULL, 0x000fc400078e0205ULL,
0x000000002828783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f6c6c7231ULL, 0x086fe400003400ffULL, 0x0000000f6e6e7231ULL, 0x000fe400003400ffULL,
0x0000000e6d6d7231ULL, 0x080fe400003400ffULL, 0x0000000e6f6f7231ULL, 0x000fe400003400ffULL,
0x0000000d28287231ULL, 0x088fe400003400ffULL, 0x0000000d2a2a7231ULL, 0x000fc400003400ffULL,
0x0000000c29297231ULL, 0x080fe400003400ffULL, 0x0000000c2b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007070783bULL, 0x000ee20000004200ULL,
0xfffffff879067812ULL, 0x000fe200078ee206ULL, 0x0000107000007945ULL, 0x000fe20003800000ULL,
0x0000000202027812ULL, 0x000fc600078efcffULL, 0x0000001006787824ULL, 0x000fe200078e0205ULL,
0x000000021d027211ULL, 0x000fca00078fe0ffULL, 0x000000007878783bULL, 0x000ea20000004200ULL,
0x0000010070907824ULL, 0x008fe200078e00ffULL, 0x0000007000047306ULL, 0x000fe20000009400ULL,
0x0000010071937824ULL, 0x000fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe20000011470ULL,
0x0000010073a87824ULL, 0x040fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe20000011490ULL,
0x0000010072a57824ULL, 0x000fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe20000011493ULL,
0x0001000073b17824ULL, 0x000fe200078e00ffULL, 0x0000009000917306ULL, 0x000fe20000209400ULL,
0x00000018ffa07819ULL, 0x000fc40000011471ULL, 0x00000018ffae7819ULL, 0x000fe200000114a8ULL,
0x0000010078b97824ULL, 0x004fe200078e00ffULL, 0x00000018ffa57819ULL, 0x000fe400000114a5ULL,
0x00000018ffa97819ULL, 0x000fe20000011472ULL, 0x0000009000927306ULL, 0x000ea20000205400ULL,
0x00000018ffb17819ULL, 0x000fe400000114b1ULL, 0x00000018ffb47819ULL, 0x000fe40000011473ULL,
0x00000018ffb97819ULL, 0x000fc400000114b9ULL, 0x00000018ffbb7819ULL, 0x000fe20000011478ULL,
0x0000007000057306ULL, 0x000ee20000005400ULL, 0x00000018ff8c7819ULL, 0x000fe40000011479ULL,
0x00000018ff7c7819ULL, 0x000fe4000001147bULL, 0x00000018ff7d7819ULL, 0x000fc6000001147aULL,
0x00000070008f7306ULL, 0x0002e2000000d400ULL, 0x000000929100720bULL, 0x004fce0003fdd000ULL,
0x0000009b009c7306ULL, 0x000fe20000209400ULL, 0x0001000070707824ULL, 0x002fe200078e00ffULL,
0x000000050400720bULL, 0x008fe20003fbd000ULL, 0x0000010079047824ULL, 0x000fe200078e00ffULL,
0x0000009b00057245ULL, 0x000fe4000020d400ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000009b009d7306ULL, 0x0002ae0000205400ULL, 0x000000018f8f5812ULL, 0x000fe200078efcffULL,
0x0000007100987306ULL, 0x000fe20000009400ULL, 0x000001007b9b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe4000001149bULL, 0x0000007100997306ULL, 0x000e620000005400ULL,
0x0000009d9c00720bULL, 0x004fe40003f7d000ULL, 0x00000018ff9c7819ULL, 0x000fe40000011404ULL,
0x0000009000047245ULL, 0x000fc6000020d400ULL, 0x00000071009a7306ULL, 0x0004e2000000d400ULL,
0x0000000104046812ULL, 0x000fc800078efcffULL, 0x0000008f0404723eULL, 0x000fe400000010ffULL,
0x0000000105053812ULL, 0x000fe200078efcffULL, 0x0000007000937306ULL, 0x000fe20000209400ULL,
0x0001000071717824ULL, 0x004fe200078e00ffULL, 0x000000999800720bULL, 0x002fc80003f9d000ULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x0000007000947306ULL, 0x0002ae0000205400ULL,
0x000000019a9a4812ULL, 0x008fe200078efcffULL, 0x00000071009e7306ULL, 0x000fe20000209400ULL,
0x0000007000707245ULL, 0x002fc4000020d400ULL, 0x0000009a0505723eULL, 0x000fca00000010ffULL,
0x00000071009f7306ULL, 0x0002e20000205400ULL, 0x000000949300720bULL, 0x004fe20003fdd000ULL,
0x000000046c2c723cULL, 0x080f6c000004182cULL, 0x0000009500967306ULL, 0x000fe20000209400ULL,
0x0000007100717245ULL, 0x002fe2000020d400ULL, 0x00000004284c723cULL, 0x000b68000004184cULL,
0x0000000170706812ULL, 0x000fc400078efcffULL, 0x0000009500977306ULL, 0x0002a20000205400ULL,
0x0000009f9e00720bULL, 0x008fe20003f7d000ULL, 0x000100007b9e7824ULL, 0x000fe400078e00ffULL,
0x000000010b057824ULL, 0x120fe400078e0202ULL, 0x000000010a047824ULL, 0x040fe200078e0202ULL,
0x00000018ff9e7819ULL, 0x000fe2000001149eULL, 0x0000007200a37306ULL, 0x000fe20000009400ULL,
0x0000009500957245ULL, 0x002fe2000020d400ULL, 0x000000080a027824ULL, 0x000fc800078e00ffULL,
0x0000000171713812ULL, 0x000fe400078efcffULL, 0x0000007200a47306ULL, 0x000e620000005400ULL,
0x000000979600720bULL, 0x004fce0003fbd000ULL, 0x000000a000a17306ULL, 0x000fec0000209400ULL,
0x0000000195955812ULL, 0x000fe400078efcffULL, 0x000000a000a27306ULL, 0x0004e20000205400ULL,
0x000000a4a300720bULL, 0x002fe40003fdd000ULL, 0x000000709570723eULL, 0x000fc400000010ffULL,
0x0000009e00957245ULL, 0x000fc6000020d400ULL, 0x000000ae00af7306ULL, 0x000fe20000209400ULL,
0x000000a000a07245ULL, 0x004fce000020d400ULL, 0x000000ae00b07306ULL, 0x0002a20000205400ULL,
0x000000a2a100720bULL, 0x008fce0003f9d000ULL, 0x000000a500a67306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x002fca000020d400ULL, 0x00000001a0a04812ULL, 0x000fe400078efcffULL,
0x000000a500a77306ULL, 0x0002e20000205400ULL, 0x000000b0af00720bULL, 0x004fe40003f7d000ULL,
0x00000071a071723eULL, 0x000fca00000010ffULL, 0x00000072008e7306ULL, 0x0004e2000000d400ULL,
0x000000a500a57245ULL, 0x002fe2000020d400ULL, 0x000000706c30723cULL, 0x080f680000041830ULL,
0x00000001aeae3812ULL, 0x000fe400078efcffULL, 0x0000007300ac7306ULL, 0x000fe20000009400ULL,
0x0001000072727824ULL, 0x004fe200078e00ffULL, 0x000000a7a600720bULL, 0x008fe20003fbd000ULL,
0x000000702850723cULL, 0x000f660000041850ULL, 0x00000018ff727819ULL, 0x000fc40000011472ULL,
0x0000007300ad7306ULL, 0x000e620000005400ULL, 0x000000018e8e6812ULL, 0x000fcc00078efcffULL,
0x00000001a5a55812ULL, 0x000fe200078efcffULL, 0x000000a900aa7306ULL, 0x000ff00000209400ULL,
0x000000a900ab7306ULL, 0x0004e20000205400ULL, 0x000000adac00720bULL, 0x002fce0003f9d000ULL,
0x000000b100b27306ULL, 0x000fe20000209400ULL, 0x000000a900a97245ULL, 0x004fce000020d400ULL,
0x000000b100b37306ULL, 0x000e620000205400ULL, 0x000000abaa00720bULL, 0x008fce0003fdd000ULL,
0x00000073008d7306ULL, 0x000eac000000d400ULL, 0x00000001a9a96812ULL, 0x000fe400078efcffULL,
0x0000007200a87306ULL, 0x000fe20000209400ULL, 0x000000b3b200720bULL, 0x002fce0003f7d000ULL,
0x0000007200737306ULL, 0x000e620000205400ULL, 0x000000018d8d4812ULL, 0x004fce00078efcffULL,
0x000000b400b57306ULL, 0x000ff00000209400ULL, 0x000000b400b67306ULL, 0x0004e20000205400ULL,
0x00000073a800720bULL, 0x002fce0003fbd000ULL, 0x000000b900ba7306ULL, 0x000fe20000209400ULL,
0x000000b400b47245ULL, 0x004fce000020d400ULL, 0x000000b900917306ULL, 0x000e620000205400ULL,
0x000000b6b500720bULL, 0x008fce0003f9d000ULL, 0x0000007800b77306ULL, 0x000fec0000009400ULL,
0x00000001b4b44812ULL, 0x000fe400078efcffULL, 0x0000007800b87306ULL, 0x000ea20000005400ULL,
0x00000091ba00720bULL, 0x002fce0003fdd000ULL, 0x0000007800877306ULL, 0x0002f0000000d400ULL,
0x0000009c00907306ULL, 0x000fe20000209400ULL, 0x0001000078787824ULL, 0x002fca00078e00ffULL,
0x00000018ff927819ULL, 0x000fe20000011478ULL, 0x000001007a787824ULL, 0x000fe200078e00ffULL,
0x0000009c00977306ULL, 0x000fe80000205400ULL, 0x00000018ff997819ULL, 0x000fe40000011478ULL,
0x0000007200787245ULL, 0x000fe4000020d400ULL, 0x0000007900be7306ULL, 0x000fe40000009400ULL,
0x0000000178785812ULL, 0x000fc400078efcffULL, 0x000000b8b700720bULL, 0x004fe40003fbd000ULL,
0x00000078a978723eULL, 0x000fe400000010ffULL, 0x0000007900bf7306ULL, 0x000e700000005400ULL,
0x0000007900867306ULL, 0x000462000000d400ULL, 0x0000000187875812ULL, 0x008fce00078efcffULL,
0x0000009200937306ULL, 0x000fe20000209400ULL, 0x0001000079797824ULL, 0x004fe200078e00ffULL,
0x000000bfbe00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff967819ULL, 0x000fe40000011479ULL,
0x0000009200947306ULL, 0x0002a20000205400ULL, 0x000000b100797245ULL, 0x000fc8000020d400ULL,
0x0000000179793812ULL, 0x000fe400078efcffULL, 0x000000979000720bULL, 0x000fe20003f7d000ULL,
0x000000bb00bc7306ULL, 0x000fe20000209400ULL, 0x000000b900907245ULL, 0x000fe4000020d400ULL,
0x0000009200927245ULL, 0x002fe4000020d400ULL, 0x0000000190906812ULL, 0x000fe400078efcffULL,
0x0000000186864812ULL, 0x000fe200078efcffULL, 0x000000bb00bd7306ULL, 0x0002e20000205400ULL,
0x000000949300720bULL, 0x004fc40003fdd000ULL, 0x0000009600937245ULL, 0x000fe4000020d400ULL,
0x00000079b479723eULL, 0x000fc600000010ffULL, 0x0000008c00c07306ULL, 0x000fe20000209400ULL,
0x000000bb00bb7245ULL, 0x002fc6000020d400ULL, 0x000000786c38723cULL, 0x000f640000041838ULL,
0x0000000192926812ULL, 0x000fe400078efcffULL, 0x0000008c00c17306ULL, 0x0002a20000205400ULL,
0x000000bdbc00720bULL, 0x008fc60003fbd000ULL, 0x000000782858723cULL, 0x000b680000041858ULL,
0x0000009600987306ULL, 0x000fe20000209400ULL, 0x0000008c008c7245ULL, 0x002fe4000020d400ULL,
0x000000080a797824ULL, 0x020fc600078e00ffULL, 0x00000001bbbb5812ULL, 0x000fe400078efcffULL,
0x0000009600737306ULL, 0x000e620000205400ULL, 0x000000c1c000720bULL, 0x004fe40003f9d000ULL,
0x00000092bb92723eULL, 0x000fca00000010ffULL, 0x0000009900727306ULL, 0x000fec0000209400ULL,
0x000000018c8c4812ULL, 0x000fe400078efcffULL, 0x0000009900917306ULL, 0x000ea20000205400ULL,
0x000000739800720bULL, 0x002fe40003fdd000ULL, 0x0000008dae73723eULL, 0x000fca00000010ffULL,
0x0000007b008a7306ULL, 0x000fec0000009400ULL, 0x0000000193936812ULL, 0x000fe400078efcffULL,
0x0000007b008b7306ULL, 0x000e620000005400ULL, 0x000000917200720bULL, 0x004fe40003fbd000ULL,
0x0000008ea572723eULL, 0x000fc400000010ffULL, 0x000000938c93723eULL, 0x000fc600000010ffULL,
0x0000007b007e7306ULL, 0x0004e4000000d400ULL, 0x000000726c34723cULL, 0x040f6c0000041834ULL,
0x0000007a00c27306ULL, 0x000fe20000009400ULL, 0x0000009c007b7245ULL, 0x004fe2000020d400ULL,
0x000000926c40723cULL, 0x000f620000041840ULL, 0x0000008b8a00720bULL, 0x002fc40003fdd000ULL,
0x000000017b7b3812ULL, 0x000fe400078efcffULL, 0x00000099008a7245ULL, 0x000fe2000020d400ULL,
0x0000007a00c37306ULL, 0x000e620000005400ULL, 0x0000009b008b7245ULL, 0x000fe2000020d400ULL,
0x000000722854723cULL, 0x000f620000041854ULL, 0x000000018a8a5812ULL, 0x000fe400078efcffULL,
0x000000867b7b723eULL, 0x000fc600000010ffULL, 0x0000009b009d7306ULL, 0x000fe20000209400ULL,
0x000000017e7e6812ULL, 0x008fe200078efcffULL, 0x000000922860723cULL, 0x000f6c0000041860ULL,
0x0000009b009c7306ULL, 0x000ea20000205400ULL, 0x000000c3c200720bULL, 0x002fce0003f7d000ULL,
0x0000007a007f7306ULL, 0x0002f0000000d400ULL, 0x0000007d00887306ULL, 0x000fe20000209400ULL,
0x000100007a7a7824ULL, 0x002fe200078e00ffULL, 0x0000009c9d00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff947819ULL, 0x000fe4000001147aULL, 0x0000007d00897306ULL, 0x0002a20000205400ULL,
0x000000017f7f3812ULL, 0x008fe400078efcffULL, 0x00000087907a723eULL, 0x000fe400000010ffULL,
0x0000007f8a8a723eULL, 0x000fe400000010ffULL, 0x000000018b8b4812ULL, 0x000fe200078efcffULL,
0x0000007c00857306ULL, 0x000fe20000209400ULL, 0x0000007d007d7245ULL, 0x002fe2000020d400ULL,
0x0000007a6c3c723cULL, 0x000f62000004183cULL, 0x0000007e8b8b723eULL, 0x000fca00000010ffULL,
0x0000007c00847306ULL, 0x0002e20000205400ULL, 0x000000898800720bULL, 0x004fe20003fbd000ULL,
0x0000008a6c44723cULL, 0x000f6c0000041844ULL, 0x0000009400977306ULL, 0x000fe20000209400ULL,
0x0000007c007c7245ULL, 0x002fe2000020d400ULL, 0x0000007a285c723cULL, 0x000f68000004185cULL,
0x000000017d7d5812ULL, 0x000fc400078efcffULL, 0x0000009400987306ULL, 0x0002a20000205400ULL,
0x000000848500720bULL, 0x008fe20003f7d000ULL, 0x0000008a2864723cULL, 0x000f6c0000041864ULL,
0x0000009e008d7306ULL, 0x000fe20000209400ULL, 0x0000009400947245ULL, 0x002fca000020d400ULL,
0x000000017c7c3812ULL, 0x000fe400078efcffULL, 0x0000009e008e7306ULL, 0x000e620000205400ULL,
0x000000989700720bULL, 0x004fda0003f9d000ULL, 0x0000000194944812ULL, 0x000fe400078efcffULL,
0x0000008e8d00720bULL, 0x002fe40003fdd000ULL, 0x000000947d94723eULL, 0x000fd600000010ffULL,
0x0000000195956812ULL, 0x000fc800078efcffULL, 0x000000957c95723eULL, 0x000fce00000010ffULL,
0x000000946c48723cULL, 0x080b6e0000041848ULL, 0x000000080b6c7824ULL, 0x020fe200078e00ffULL,
0x000000942868723cULL, 0x000b620000041868ULL, 0x000000080a6f7824ULL, 0x040fe400078e00ffULL,
0x000000010a6d7824ULL, 0x000fe200078e0203ULL, 0xfffffff86c057812ULL, 0x000fc400078ee205ULL,
0xfffffff86f047812ULL, 0x000fe400078ee204ULL, 0x0000e00018037811ULL, 0x000fe200078e68ffULL,
0x00000010056c7824ULL, 0x100fe200078e0200ULL, 0xfffffff802027812ULL, 0x000fe200078ee26dULL,
0x0000001004007824ULL, 0x000fe200078e0200ULL, 0x000000026d787810ULL, 0x000fc60007ffe0ffULL,
0x000000006c6c783bULL, 0x000e620000000200ULL, 0x0000001002707824ULL, 0x000fc600078e0203ULL,
0x000000000028783bULL, 0x0204e20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f6c6c7231ULL, 0x082fe400003400ffULL, 0x0000000f6e6e7231ULL, 0x000fe400003400ffULL,
0x0000000e6d6d7231ULL, 0x080fe400003400ffULL, 0x0000000e6f6f7231ULL, 0x000fe400003400ffULL,
0x0000000d28287231ULL, 0x088fe400003400ffULL, 0x0000000d2a2a7231ULL, 0x000fc400003400ffULL,
0x0000000c29297231ULL, 0x080fe400003400ffULL, 0x0000000c2b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007070783bULL, 0x000ea40000004200ULL,
0xfffffff879007812ULL, 0x004fe400078ee278ULL, 0xfffffff825257812ULL, 0x000fc600078ec0ffULL,
0x0000001000787824ULL, 0x000fcc00078e0203ULL, 0x000000007878783bULL, 0x000ea20000004200ULL,
0x0000010070937824ULL, 0x000fe200078e00ffULL, 0x0000007000907306ULL, 0x000fe20000009400ULL,
0x00000018ff977819ULL, 0x000fe20000011470ULL, 0x0000010071967824ULL, 0x040fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe20000011471ULL, 0x0001000071a07824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011493ULL, 0x0000010072a87824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe20000011496ULL, 0x0000007000917306ULL, 0x000ee20000005400ULL,
0x00000018ffae7819ULL, 0x000fe20000011472ULL, 0x0000010073ab7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa87819ULL, 0x000fe200000114a8ULL, 0x000100007bcc7824ULL, 0x004fe200078e00ffULL,
0x00000018ffb97819ULL, 0x000fc40000011473ULL, 0x00000018ffb37819ULL, 0x000fe200000114abULL,
0x0000009300947306ULL, 0x000fe20000209400ULL, 0x00000018ff8f7819ULL, 0x000fe40000011478ULL,
0x00000018ff8a7819ULL, 0x000fe40000011479ULL, 0x00000018ffa07819ULL, 0x000fe400000114a0ULL,
0x00000018ff7e7819ULL, 0x000fe2000001147aULL, 0x0000009300957306ULL, 0x0004620000205400ULL,
0x000000919000720bULL, 0x008fe20003f9d000ULL, 0x000001007a907824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fc4000001147bULL, 0x00000018ffcc7819ULL, 0x000fc600000114ccULL,
0x0000007000927306ULL, 0x000662000000d400ULL, 0x0000009300937245ULL, 0x004fce000020d400ULL,
0x00000071009a7306ULL, 0x000fe20000009400ULL, 0x0001000070707824ULL, 0x008fe200078e00ffULL,
0x000000959400720bULL, 0x002fc80003fdd000ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x00000071009b7306ULL, 0x000e620000005400ULL, 0x0000000192924812ULL, 0x000fcc00078efcffULL,
0x0000000193936812ULL, 0x000fe200078efcffULL, 0x00000071009c7306ULL, 0x000eb0000000d400ULL,
0x0000007000967306ULL, 0x000fe20000209400ULL, 0x0000009b9a00720bULL, 0x002fce0003f1d000ULL,
0x0000007000717306ULL, 0x000e6c0000205400ULL, 0x000000019c9c0812ULL, 0x004fe400078efcffULL,
0x0000009700987306ULL, 0x000ff00000209400ULL, 0x0000009700997306ULL, 0x0004e20000205400ULL,
0x000000719600720bULL, 0x002fc40003fdd000ULL, 0x0000009d00717245ULL, 0x000fca000020d400ULL,
0x0000007200a67306ULL, 0x000fe20000009400ULL, 0x0000009700977245ULL, 0x004fce000020d400ULL,
0x0000007200a77306ULL, 0x000e620000005400ULL, 0x000000999800720bULL, 0x008fe40003fbd000ULL,
0x00000018ff987819ULL, 0x000fe40000011490ULL, 0x000000b300907245ULL, 0x000fc6000020d400ULL,
0x00000072008c7306ULL, 0x0004ec000000d400ULL, 0x0000000197975812ULL, 0x000fe400078efcffULL,
0x000000a300a47306ULL, 0x000fe20000209400ULL, 0x0001000072727824ULL, 0x004fe200078e00ffULL,
0x000000a7a600720bULL, 0x002fc80003f9d000ULL, 0x00000018ffab7819ULL, 0x000fe20000011472ULL,
0x0000010078727824ULL, 0x000fe200078e00ffULL, 0x000000a300a57306ULL, 0x000e680000205400ULL,
0x00000018ffbe7819ULL, 0x000fe20000011472ULL, 0x0000010079727824ULL, 0x000fe400078e00ffULL,
0x000000018c8c4812ULL, 0x008fe200078efcffULL, 0x000000a800a97306ULL, 0x000fe40000209400ULL,
0x00000018ffc57819ULL, 0x000fc40000011472ULL, 0x0000007000727245ULL, 0x000fc8000020d400ULL,
0x000000a800aa7306ULL, 0x000ea20000205400ULL, 0x000000a5a400720bULL, 0x002fe40003f1d000ULL,
0x0000000172726812ULL, 0x000fc800078efcffULL, 0x000000729772723eULL, 0x000fe200000010ffULL,
0x000000b300b47306ULL, 0x000ff00000209400ULL, 0x000000b300b57306ULL, 0x000e620000205400ULL,
0x000000aaa900720bULL, 0x004fce0003fdd000ULL, 0x0000007300b17306ULL, 0x000ff00000009400ULL,
0x0000007300b27306ULL, 0x000fe20000005400ULL, 0x000000b5b400720bULL, 0x002fce0003fbd000ULL,
0x00000073008b7306ULL, 0x0003ec000000d400ULL, 0x0000000190905812ULL, 0x000fe400078efcffULL,
0x000000ab00ac7306ULL, 0x000fe20000209400ULL, 0x0001000073737824ULL, 0x002fca00078e00ffULL,
0x00000018ffb67819ULL, 0x000fe40000011473ULL, 0x000000ab00ad7306ULL, 0x000e620000205400ULL,
0x000000a000737245ULL, 0x000fce000020d400ULL, 0x000000ae00af7306ULL, 0x000ff00000209400ULL,
0x000000ae00b07306ULL, 0x000ff00000205400ULL, 0x0000007800bc7306ULL, 0x000ff00000009400ULL,
0x0000007800bd7306ULL, 0x000ff00000005400ULL, 0x0000007800857306ULL, 0x0005f0000000d400ULL,
0x0000009d009e7306ULL, 0x000fe20000209400ULL, 0x0001000078787824ULL, 0x004fca00078e00ffULL,
0x00000018ff917819ULL, 0x000fe40000011478ULL, 0x0000009d009f7306ULL, 0x000ea20000205400ULL,
0x000000a300787245ULL, 0x000fc8000020d400ULL, 0x0000000178780812ULL, 0x000fe400078efcffULL,
0x000000adac00720bULL, 0x002fe20003f1d000ULL, 0x000000b600b77306ULL, 0x000ff00000209400ULL,
0x000000b600b87306ULL, 0x0002e20000205400ULL, 0x0000009f9e00720bULL, 0x004fe20003f7d000ULL,
0x000100007a9e7824ULL, 0x000fc400078e00ffULL, 0x000001007b9f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe2000001149eULL, 0x0000007900c37306ULL, 0x000fe20000009400ULL,
0x000000b600b67245ULL, 0x002fe4000020d400ULL, 0x00000018ff9f7819ULL, 0x000fc6000001149fULL,
0x0000000171713812ULL, 0x000fe400078efcffULL, 0x0000007900c47306ULL, 0x000e620000005400ULL,
0x000000b8b700720bULL, 0x008fe40003fbd000ULL, 0x0000009c7171723eULL, 0x000fca00000010ffULL,
0x0000007900847306ULL, 0x0004ec000000d400ULL, 0x00000001b6b65812ULL, 0x000fe400078efcffULL,
0x000000c500c67306ULL, 0x000fe20000209400ULL, 0x0001000079797824ULL, 0x004fe200078e00ffULL,
0x000000c4c300720bULL, 0x002fc80003fbd000ULL, 0x00000018ff967819ULL, 0x000fe40000011479ULL,
0x000000a800797245ULL, 0x000fe2000020d400ULL, 0x000000c500c77306ULL, 0x0003e60000205400ULL,
0x0000000179796812ULL, 0x000fe400078efcffULL, 0x000000b0af00720bULL, 0x000fe40003fdd000ULL,
0x0000000184845812ULL, 0x008fe200078efcffULL, 0x000000a000a17306ULL, 0x000fe20000209400ULL,
0x000000c500c57245ULL, 0x002fce000020d400ULL, 0x000000a000a27306ULL, 0x000e700000205400ULL,
0x0000007a00c87306ULL, 0x000ff00000009400ULL, 0x0000007a00c97306ULL, 0x000fe20000005400ULL,
0x000000a2a100720bULL, 0x002fce0003f7d000ULL, 0x0000007a007c7306ULL, 0x0003ec000000d400ULL,
0x0000000173733812ULL, 0x000fe400078efcffULL, 0x0000007b00ca7306ULL, 0x000fe20000009400ULL,
0x000000ab007a7245ULL, 0x002fe4000020d400ULL, 0x000000b2b100720bULL, 0x000fc40003f7d000ULL,
0x000000017a7a0812ULL, 0x000fe400078efcffULL, 0x000000bdbc00720bULL, 0x000fe20003f1d000ULL,
0x0000007b00cb7306ULL, 0x000fe20000005400ULL, 0x000000737873723eULL, 0x000fe400000010ffULL,
0x0000008c7978723eULL, 0x000fca00000010ffULL, 0x0000007b007d7306ULL, 0x0003e2000000d400ULL,
0x000000018b8b3812ULL, 0x000fe200078efcffULL, 0x000000722850723cULL, 0x080f640000041850ULL,
0x0000000185850812ULL, 0x000fe400078efcffULL, 0x0000008b9079723eULL, 0x000fe400000010ffULL,
0x0000008f00c17306ULL, 0x000fe20000209400ULL, 0x000000ae007b7245ULL, 0x002fe2000020d400ULL,
0x000000726c30723cULL, 0x000f620000041830ULL, 0x00000098008b7245ULL, 0x000fc4000020d400ULL,
0x000000017b7b6812ULL, 0x000fe400078efcffULL, 0x000000c7c600720bULL, 0x000fe20003fdd000ULL,
0x0000008f00c27306ULL, 0x000e620000205400ULL, 0x0000007a7b7a723eULL, 0x000fe200000010ffULL,
0x000000782854723cULL, 0x080f6c0000041854ULL, 0x0000009100947306ULL, 0x000fe40000209400ULL,
0x000000786c34723cULL, 0x000f640000041834ULL, 0x00000001c5c56812ULL, 0x000fc800078efcffULL,
0x0000009100957306ULL, 0x0004e20000205400ULL, 0x000000c2c100720bULL, 0x002fce0003f1d000ULL,
0x000000b900ba7306ULL, 0x000fe20000209400ULL, 0x0000009100917245ULL, 0x004fce000020d400ULL,
0x000000b900bb7306ULL, 0x0002a20000205400ULL, 0x000000959400720bULL, 0x008fce0003fdd000ULL,
0x0000009600707306ULL, 0x000fe20000209400ULL, 0x000000b900b97245ULL, 0x002fca000020d400ULL,
0x0000000191916812ULL, 0x000fe400078efcffULL, 0x0000009600997306ULL, 0x000e620000205400ULL,
0x000000bbba00720bULL, 0x004fce0003f9d000ULL, 0x00000098009a7306ULL, 0x000fec0000209400ULL,
0x00000001b9b94812ULL, 0x000fe400078efcffULL, 0x00000098009b7306ULL, 0x000ea20000205400ULL,
0x000000997000720bULL, 0x002fe40003fbd000ULL, 0x000000929370723eULL, 0x000fc400000010ffULL,
0x0000008f00927245ULL, 0x000fe4000020d400ULL, 0x0000009600937245ULL, 0x000fe2000020d400ULL,
0x0000008a008e7306ULL, 0x000fe20000209400ULL, 0x0000000192920812ULL, 0x000fe200078efcffULL,
0x00000070284c723cULL, 0x080f62000004184cULL, 0x000000c9c800720bULL, 0x000fe40003f9d000ULL,
0x000000b6b97b723eULL, 0x000fe400000010ffULL, 0x0000000193935812ULL, 0x000fe200078efcffULL,
0x0000008a008d7306ULL, 0x0002e20000205400ULL, 0x0000009b9a00720bULL, 0x004fe20003f1d000ULL,
0x000000706c2c723cULL, 0x000f62000004182cULL, 0x000000919292723eULL, 0x000fca00000010ffULL,
0x000000be00bf7306ULL, 0x000fe20000209400ULL, 0x0000008a008a7245ULL, 0x002fe2000020d400ULL,
0x0000007a2858723cULL, 0x000f620000041858ULL, 0x000000017c7c4812ULL, 0x000fc600078efcffULL,
0x000000018b8b0812ULL, 0x000fe400078efcffULL, 0x000000be00c07306ULL, 0x0002a20000205400ULL,
0x0000008d8e00720bULL, 0x008fe20003fdd000ULL, 0x0000007a6c38723cULL, 0x000f620000041838ULL,
0x0000007c8b7c723eULL, 0x000fca00000010ffULL, 0x0000009f009d7306ULL, 0x000fe20000209400ULL,
0x000000be00be7245ULL, 0x002fca000020d400ULL, 0x000000018a8a6812ULL, 0x000fe400078efcffULL,
0x0000009f00a07306ULL, 0x000e620000205400ULL, 0x000000c0bf00720bULL, 0x004fe40003f7d000ULL,
0x000000938a93723eULL, 0x000fca00000010ffULL, 0x0000007f00887306ULL, 0x000fe40000209400ULL,
0x000000922860723cULL, 0x080f680000041860ULL, 0x00000001bebe3812ULL, 0x000fe400078efcffULL,
0x0000007f00877306ULL, 0x000ea20000205400ULL, 0x000000a09d00720bULL, 0x002fe20003fbd000ULL,
0x000000926c40723cULL, 0x000f620000041840ULL, 0x000000cbca00720bULL, 0x000fca0003f7d000ULL,
0x0000007e00867306ULL, 0x000ff00000209400ULL, 0x0000007e00897306ULL, 0x000e620000205400ULL,
0x000000878800720bULL, 0x004fe40003f1d000ULL, 0x0000009f00887245ULL, 0x000fc4000020d400ULL,
0x000000cc009f7245ULL, 0x000fe4000020d400ULL, 0x0000000188885812ULL, 0x000fe200078efcffULL,
0x0000009e00947306ULL, 0x000fe20000209400ULL, 0x000000017d7d3812ULL, 0x000fe400078efcffULL,
0x00000084c587723eULL, 0x000fe400000010ffULL, 0x0000007d887d723eULL, 0x000fc600000010ffULL,
0x0000009e00957306ULL, 0x0004e20000205400ULL, 0x000000898600720bULL, 0x002fe40003fdd000ULL,
0x00000085be86723eULL, 0x000fe200000010ffULL, 0x0000007c2864723cULL, 0x040f620000041864ULL,
0x0000007e00857245ULL, 0x000fe4000020d400ULL, 0x0000007f007e7245ULL, 0x000fe2000020d400ULL,
0x000000cc008d7306ULL, 0x000fe20000209400ULL, 0x0000009e009e7245ULL, 0x004fe4000020d400ULL,
0x000000017e7e0812ULL, 0x000fe200078efcffULL, 0x00000086285c723cULL, 0x000f64000004185cULL,
0x0000000185856812ULL, 0x000fc400078efcffULL, 0x000000cc008c7306ULL, 0x000e620000205400ULL,
0x000000959400720bULL, 0x008fc60003f9d000ULL, 0x000000866c3c723cULL, 0x040f70000004183cULL,
0x0000007c6c44723cULL, 0x000f640000041844ULL, 0x000000019e9e4812ULL, 0x000fc400078efcffULL,
0x0000008c8d00720bULL, 0x002fe40003fbd000ULL, 0x0000009e859e723eULL, 0x000fd600000010ffULL,
0x000000019f9f5812ULL, 0x000fc800078efcffULL, 0x0000009f7e9f723eULL, 0x000fce00000010ffULL,
0x0000009e2868723cULL, 0x080f700000041868ULL, 0x0000009e6c48723cULL, 0x000b6e0000041848ULL,
0x000126c8186c7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006c6c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126880025ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff6e7224ULL, 0x000fc600078e00ffULL,
0x0000000000287805ULL, 0x000fc80000015200ULL, 0x0000040013257984ULL, 0x004ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fc4000780486dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09002a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001142bULL,
0x0000002a25257211ULL, 0x000fca00078110ffULL, 0x000000ffff2a7224ULL, 0x000fca00000e062bULL,
0x0000000225257819ULL, 0x000fc8000000122aULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040013257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101f257824ULL, 0x000fe400078e00ffULL, 0x0000590024247a24ULL, 0x010fc600078e02ffULL,
0xffffffe025297812ULL, 0x000fe200078ec0ffULL, 0x0000008024247824ULL, 0x000fc800078e00ffULL,
0x0000010014297824ULL, 0x000fca00078e0229ULL, 0x0000008029297810ULL, 0x000fc80007ffe0ffULL,
0x0000006029287812ULL, 0x000fca00078ec0ffULL, 0x0000000117707824ULL, 0x000fe200078e0228ULL,
0x000003f00000a947ULL, 0x000fea0003800000ULL, 0x0000001025727812ULL, 0x000fe400078ec0ffULL,
0x000000291c257217ULL, 0x000fe40007800000ULL, 0x00000003ff2b7819ULL, 0x000fe4000001161dULL,
0x0000640024717a11ULL, 0x000fe200078838ffULL, 0x0000000125257824ULL, 0x000fe200078e0a29ULL,
0x000000042b2a7810ULL, 0x040fe20007ffe0ffULL, 0x000000012b287824ULL, 0x040fe200078e0272ULL,
0x000000082b6f7810ULL, 0x000fc40007ffe0ffULL, 0x0000002572257217ULL, 0x000fe20007800000ULL,
0x0000000128297824ULL, 0x040fe200078e021dULL, 0x0000000c2b7b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000828787824ULL, 0x000fe200078e00ffULL, 0x0000650024737a11ULL, 0x000fe200020f3cffULL,
0x0000000125257824ULL, 0x100fe400078e0a72ULL, 0x000000012a797824ULL, 0x000fe200078e0272ULL,
0xfffffff878787812ULL, 0x000fe200078ee229ULL, 0x0000000128287824ULL, 0x100fe200078e0270ULL,
0x000000252a00720cULL, 0x080fe20003f66070ULL, 0x00000001792a7824ULL, 0x000fe200078e0270ULL,
0x000000252b00720cULL, 0x080fe20003f06070ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x000000256f00720cULL, 0x000fc60003f86070ULL, 0x000000016f7a7824ULL, 0x000fe200078e0272ULL,
0x00000012286e7212ULL, 0x000fe200078efcffULL, 0x000000802a2a7825ULL, 0x000fc600078e00ffULL,
0x0000006e716e7210ULL, 0x000fe20007fbe0ffULL, 0x000000017a6c7824ULL, 0x000fe200078e0270ULL,
0x000000122a2a7212ULL, 0x000fe200078efcffULL, 0x000000017b727824ULL, 0x000fe400078e0272ULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x000000712a2a7210ULL, 0x000fc60007fde0ffULL,
0x0000000172287824ULL, 0x000fe200078e0270ULL, 0x000000126c6c7212ULL, 0x000fe200078efcffULL,
0x00000001296f7824ULL, 0x000fe200028e0673ULL, 0x000000257b00720cULL, 0x000fe20003fa6070ULL,
0x0000000179707824ULL, 0x040fe400078e021dULL, 0x0000000879797824ULL, 0x000fe400078e00ffULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff879707812ULL, 0x000fe200078ee270ULL,
0x000000012b2b7824ULL, 0x000fe200030e0673ULL, 0x000000716c6c7210ULL, 0x080fe20007fde0ffULL,
0x000000017a257824ULL, 0x100fe200078e021dULL, 0x0000001228287212ULL, 0x000fe200078efcffULL,
0x000000087a7a7824ULL, 0x000fe400078e00ffULL, 0x0000000172797824ULL, 0x040fe400078e021dULL,
0x00000008727c7824ULL, 0x000fe200078e00ffULL, 0xfffffff87a727812ULL, 0x000fe200078ee225ULL,
0x000000016d6d7824ULL, 0x000fe200030e0673ULL, 0x0000007128287210ULL, 0x000fe20007fde0ffULL,
0x0000001078257824ULL, 0x000fe200078e0203ULL, 0xfffffff87c787812ULL, 0x000fe200078ee279ULL,
0x0000001070717824ULL, 0x000fc400078e0203ULL, 0x0000000129297824ULL, 0x000fe200030e0673ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006e257faeULL, 0x0003e2000c101c46ULL,
0x0000001072737824ULL, 0x100fe400078e0203ULL, 0x0000001078797824ULL, 0x000fe200078e0203ULL,
0x000000002a717faeULL, 0x0003e8000d901c46ULL, 0x000000006c737faeULL, 0x0003e8000e101c46ULL,
0x0000000028797faeULL, 0x0003e2000e901c46ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001025287812ULL, 0x000fc800078ec0ffULL, 0x000000281d257211ULL, 0x000fc800078fe8ffULL,
0x00000004252b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000125297824ULL, 0x040fe200078e021dULL,
0x0000000c256d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000825727824ULL, 0x040fe400078e00ffULL,
0x0000000125287824ULL, 0x100fe400078e0270ULL, 0x000000012b2a7824ULL, 0x040fe200078e0270ULL,
0xfffffff872727812ULL, 0x000fe200078ee229ULL, 0x000000082b787824ULL, 0x000fe200078e00ffULL,
0x0000000825297810ULL, 0x000fe20007ffe0ffULL, 0x000000012b257824ULL, 0x000fc400078e021dULL,
0x000000016d6f7824ULL, 0x100fe400078e021dULL, 0x00000001296c7824ULL, 0x040fe400078e0270ULL,
0x00000001292b7824ULL, 0x040fe400078e021dULL, 0x00000008297a7824ULL, 0x000fe400078e00ffULL,
0x000000086d7c7824ULL, 0x000fe400078e00ffULL, 0x0000008028287825ULL, 0x000fc800078e00ffULL,
0x000000016d6e7824ULL, 0x000fe200078e0270ULL, 0xfffffff878707812ULL, 0x000fe200078ee225ULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0xfffffff87a787812ULL, 0x000fe400078ee22bULL,
0x0000640024257a11ULL, 0x000fe200078038ffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0xfffffff87c7a7812ULL, 0x000fe400078ee26fULL, 0x0000001228287212ULL, 0x000fe200078efcffULL,
0x000000806e6e7825ULL, 0x000fe200078e00ffULL, 0x0000650024717a11ULL, 0x000fc400000f3cffULL,
0x0000002825287210ULL, 0x000fe20007f1e0ffULL, 0x0000001078737824ULL, 0x100fe200078e0203ULL,
0x000000122a2a7212ULL, 0x080fe200078efcffULL, 0x000000107a797824ULL, 0x000fe200078e0203ULL,
0x000000126c6c7212ULL, 0x080fe200078efcffULL, 0x0000000129297824ULL, 0x000fe200000e0671ULL,
0x000000126e6e7212ULL, 0x000fe400078efcffULL, 0x0000002a252a7210ULL, 0x040fe40007f7e0ffULL,
0x0000006c256c7210ULL, 0x000fc40007f1e0ffULL, 0x0000006e256e7210ULL, 0x000fe20007f9e0ffULL,
0x000000012b2b7824ULL, 0x000fe400018e0671ULL, 0x0000001072257824ULL, 0x000fe400078e0203ULL,
0x000000016d6d7824ULL, 0x100fe400000e0671ULL, 0x000000016f6f7824ULL, 0x000fe200020e0671ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028257faeULL, 0x0003e2000b901c46ULL,
0x0000001070717824ULL, 0x000fca00078e0203ULL, 0x000000002a717faeULL, 0x0003e8000b901c46ULL,
0x000000006c737faeULL, 0x0003e8000b901c46ULL, 0x000000006e797faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000100503c2ULL, 0x000e640000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x002fe20008000a05ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000106c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01262800236e7f8cULL, 0x000664000c80043fULL, 0x0000000000287805ULL, 0x000fc40000015200ULL,
0x01262c0023257984ULL, 0x000f240000000800ULL, 0x8000000025ff7812ULL, 0x012fc4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09002a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001142bULL,
0x0000002a25257211ULL, 0x000fca00078110ffULL, 0x000000ffff2a7224ULL, 0x000fca00000e062bULL,
0x0000000225257819ULL, 0x000fc8000000122aULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01262c0023257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201f257824ULL, 0x000fca00078e00ffULL, 0xffffff8025257812ULL, 0x000fc800078ec0ffULL,
0x0000008012257810ULL, 0x000fca0007ffe025ULL, 0x0000000174257824ULL, 0x000fca00078e0225ULL,
0x01200000256e7984ULL, 0x000e680000000800ULL, 0x01220000256f7984ULL, 0x0006a20000000800ULL,
0x000000216e00720bULL, 0x002fe20003f1d000ULL, 0x000153427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000257806ULL, 0x008fc800000e0100ULL, 0x000000ff2500720cULL, 0x000fe20003f05270ULL,
0x0000077000007945ULL, 0x000fe20003800000ULL, 0x00000001ff707424ULL, 0x000fd600078e00ffULL,
0x0000074000008947ULL, 0x000fea0003800000ULL, 0x0000000115287810ULL, 0x000fe40007ffe0ffULL,
0x000000216e00720bULL, 0x000fe40003f74000ULL, 0x0000001f2800720cULL, 0x000fe20003f05270ULL,
0x000153027f007947ULL, 0x000fd4000b800000ULL, 0x0000000000707806ULL, 0x000fc400018e0100ULL,
0x000000801f298824ULL, 0x000fe200078e0212ULL, 0x000000216e288209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x0000000174298824ULL, 0x000fca00078e0229ULL,
0x0124002829008388ULL, 0x0003e20000000800ULL, 0x000000ff7000720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x000000216e287209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff70ff7812ULL, 0x000fc6000780c0ffULL,
0x0000002128287221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL,
0x0000002800717308ULL, 0x000e640000000800ULL, 0x0000007122227220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe2000001161dULL,
0x000152327f007947ULL, 0x000fea000b800000ULL, 0x00001f2971297589ULL, 0x0002e400000e0000ULL,
0x000000292c2c7220ULL, 0x08cfe20000410000ULL, 0x000000292d2d7220ULL, 0x080fe20000410000ULL,
0x0000002930307220ULL, 0x080fe20000410000ULL, 0x0000002931317220ULL, 0x080fe20000410000ULL,
0x0000002934347220ULL, 0x080fe20000410000ULL, 0x0000002935357220ULL, 0x080fe20000410000ULL,
0x0000002938387220ULL, 0x080fe20000410000ULL, 0x0000002939397220ULL, 0x080fe20000410000ULL,
0x000000293c3c7220ULL, 0x080fe20000410000ULL, 0x000000293d3d7220ULL, 0x080fe20000410000ULL,
0x0000002940407220ULL, 0x080fe20000410000ULL, 0x0000002941417220ULL, 0x080fe20000410000ULL,
0x0000002944447220ULL, 0x080fe20000410000ULL, 0x0000002945457220ULL, 0x080fe20000410000ULL,
0x0000002948487220ULL, 0x080fe20000410000ULL, 0x0000002949497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0070ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000081d297811ULL, 0x000fe200078ff0ffULL, 0x000151027f007947ULL, 0x000fea000b800000ULL,
0x00001f2971297589ULL, 0x00066400000e0000ULL, 0x000000292e2e7220ULL, 0x086fe20000410000ULL,
0x000000292f2f7220ULL, 0x080fe20000410000ULL, 0x0000002932327220ULL, 0x080fe20000410000ULL,
0x0000002933337220ULL, 0x080fe20000410000ULL, 0x0000002936367220ULL, 0x080fe20000410000ULL,
0x0000002937377220ULL, 0x080fe20000410000ULL, 0x000000293a3a7220ULL, 0x080fe20000410000ULL,
0x000000293b3b7220ULL, 0x080fe20000410000ULL, 0x000000293e3e7220ULL, 0x080fe20000410000ULL,
0x000000293f3f7220ULL, 0x080fe20000410000ULL, 0x0000002942427220ULL, 0x080fe20000410000ULL,
0x0000002943437220ULL, 0x080fe20000410000ULL, 0x0000002946467220ULL, 0x080fe20000410000ULL,
0x0000002947477220ULL, 0x080fe20000410000ULL, 0x000000294a4a7220ULL, 0x080fe20000410000ULL,
0x000000294b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000070ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000101d297811ULL, 0x000fe200078ff0ffULL,
0x00014fd27f007947ULL, 0x000fea000b800000ULL, 0x00001f2971297589ULL, 0x0002e400000e0000ULL,
0x000000294c4c7220ULL, 0x08cfe20000410000ULL, 0x000000294d4d7220ULL, 0x080fe20000410000ULL,
0x0000002950507220ULL, 0x080fe20000410000ULL, 0x0000002951517220ULL, 0x080fe20000410000ULL,
0x0000002954547220ULL, 0x080fe20000410000ULL, 0x0000002955557220ULL, 0x080fe20000410000ULL,
0x0000002958587220ULL, 0x080fe20000410000ULL, 0x0000002959597220ULL, 0x080fe20000410000ULL,
0x000000295c5c7220ULL, 0x080fe20000410000ULL, 0x000000295d5d7220ULL, 0x080fe20000410000ULL,
0x0000002960607220ULL, 0x080fe20000410000ULL, 0x0000002961617220ULL, 0x080fe20000410000ULL,
0x0000002964647220ULL, 0x080fe20000410000ULL, 0x0000002965657220ULL, 0x080fe20000410000ULL,
0x0000002968687220ULL, 0x080fe20000410000ULL, 0x0000002969697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000070ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000181d297811ULL, 0x000fe200078ff0ffULL,
0x00014eb27f007947ULL, 0x000fea000b800000ULL, 0x00001f2971297589ULL, 0x0002e400000e0000ULL,
0x000000294e4e7220ULL, 0x08cfe20000410000ULL, 0x000000294f4f7220ULL, 0x080fe20000410000ULL,
0x0000002952527220ULL, 0x080fe20000410000ULL, 0x0000002953537220ULL, 0x080fe20000410000ULL,
0x0000002956567220ULL, 0x080fe20000410000ULL, 0x0000002957577220ULL, 0x080fe20000410000ULL,
0x000000295a5a7220ULL, 0x080fe20000410000ULL, 0x000000295b5b7220ULL, 0x080fe20000410000ULL,
0x000000295e5e7220ULL, 0x080fe20000410000ULL, 0x000000295f5f7220ULL, 0x080fe20000410000ULL,
0x0000002962627220ULL, 0x080fe20000410000ULL, 0x0000002963637220ULL, 0x080fe20000410000ULL,
0x0000002966667220ULL, 0x080fe20000410000ULL, 0x0000002967677220ULL, 0x080fe20000410000ULL,
0x000000296a6a7220ULL, 0x080fe20000410000ULL, 0x000000296b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000007025ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff707424ULL, 0x000fe200078e00ffULL, 0x000000216e217209ULL, 0x000fd60007810000ULL,
0x800000216e6e0221ULL, 0x000fe20000010000ULL, 0x00007610ff700816ULL, 0x000fc60000000070ULL,
0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL, 0x0000006e00110308ULL, 0x000e640000000800ULL,
0x000000116f6f0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000226f227221ULL, 0x004fc20000010000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x000000081f257824ULL, 0x000fca00078e00ffULL, 0xfffffff0256e7812ULL, 0x000fca00078ec0ffULL,
0x0126b4006e257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09002a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001142bULL,
0x0000002a25257211ULL, 0x000fca00078110ffULL, 0x000000ffff2a7224ULL, 0x000fca00000e062bULL,
0x0000000225257819ULL, 0x000fc8000000122aULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016f6f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b4006e257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991070257816ULL, 0x000fc800000000ffULL, 0x000000ff2500720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000011ff0c723eULL, 0x000fe400000010ffULL,
0x00000002ff257819ULL, 0x000fe4000001161dULL, 0x000054100c0c7816ULL, 0x000fe2000000000cULL,
0x00014a727f007947ULL, 0x000fea000b800000ULL, 0x00001f250c0f7589ULL, 0x0002a400000e0000ULL,
0x0000000825297810ULL, 0x000fe20007ffe0ffULL, 0x00014aa27f007947ULL, 0x000fea000b800000ULL,
0x00000010250d7810ULL, 0x000fe20007ffe0ffULL, 0x00001f290c0e7589ULL, 0x0002ea00000e0000ULL,
0x00001f0d0c0d7589ULL, 0x0002a400000e0000ULL, 0x0000001825297810ULL, 0x002fe20007ffe0ffULL,
0x00014af27f007947ULL, 0x000fea000b800000ULL, 0x00001f290c0c7589ULL, 0x0002e400000e0000ULL,
0x000004001f257824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000010001f267824ULL, 0x000fe200078e00ffULL, 0x0000013000007945ULL, 0x000fe40003800000ULL,
0xfffff00025257812ULL, 0x000fc400078ec0ffULL, 0xffffe00026277812ULL, 0x000fe400078ec0ffULL,
0x0000b00025267810ULL, 0x000fe40007ffe0ffULL, 0x0000f00027257810ULL, 0x000fc60007ffe0ffULL,
0x0000001009707824ULL, 0x100fe400078e0226ULL, 0x0000001008287824ULL, 0x000fe400078e0226ULL,
0x0000001007787824ULL, 0x000fe400078e0225ULL, 0x000000007070783bULL, 0x008ee80000000200ULL,
0x000000002828783bULL, 0x002e620000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f70707231ULL, 0x08cfe400003400ffULL, 0x0000000f72727231ULL, 0x000fc400003400ffULL,
0x0000000e71717231ULL, 0x080fe400003400ffULL, 0x0000000e73737231ULL, 0x000fe400003400ffULL,
0x0000000d28287231ULL, 0x082fe400003400ffULL, 0x0000000d2a2a7231ULL, 0x000fe400003400ffULL,
0x0000000c29297231ULL, 0x080fe400003400ffULL, 0x0000000c2b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x00000010067c7824ULL, 0x000fe200078e0225ULL, 0x00000f9000007945ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x0000010078927824ULL, 0x010fe200078e00ffULL,
0x00000078006e7306ULL, 0x000fe20000009400ULL, 0x0000010079957824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe20000011478ULL, 0x000001007baa7824ULL, 0x040fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe20000011492ULL, 0x000001007aa77824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe20000011495ULL, 0x000100007bb37824ULL, 0x000fe200078e00ffULL,
0x0000009200937306ULL, 0x000fe20000209400ULL, 0x00000018ffa27819ULL, 0x000fe20000011479ULL,
0x000001007cbb7824ULL, 0x008fe200078e00ffULL, 0x00000018ffb07819ULL, 0x000fc400000114aaULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x00000018ffab7819ULL, 0x000fe2000001147aULL,
0x0000009200947306ULL, 0x000ee20000205400ULL, 0x00000018ffb37819ULL, 0x000fe400000114b3ULL,
0x00000018ffb67819ULL, 0x000fe4000001147bULL, 0x00000018ffbb7819ULL, 0x000fe400000114bbULL,
0x00000018ffbd7819ULL, 0x000fe2000001147cULL, 0x00000078006f7306ULL, 0x000f220000005400ULL,
0x00000018ff8e7819ULL, 0x000fc4000001147dULL, 0x00000018ff857819ULL, 0x000fe4000001147fULL,
0x00000018ff847819ULL, 0x000fc6000001147eULL, 0x0000007800917306ULL, 0x000462000000d400ULL,
0x000000949300720bULL, 0x008fce0003fdd000ULL, 0x0000009d009e7306ULL, 0x000fe20000209400ULL,
0x0001000078787824ULL, 0x004fe200078e00ffULL, 0x0000006f6e00720bULL, 0x010fe20003fbd000ULL,
0x000001007d6e7824ULL, 0x000fe200078e00ffULL, 0x0000009d006f7245ULL, 0x000fe4000020d400ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000009d009f7306ULL, 0x0004ee0000205400ULL,
0x0000000191915812ULL, 0x002fe200078efcffULL, 0x00000079009a7306ULL, 0x000fe20000009400ULL,
0x000001007f9d7824ULL, 0x004fca00078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe4000001149dULL,
0x00000079009b7306ULL, 0x000e620000005400ULL, 0x0000009f9e00720bULL, 0x008fe40003f7d000ULL,
0x00000018ff9e7819ULL, 0x000fe4000001146eULL, 0x00000092006e7245ULL, 0x000fc6000020d400ULL,
0x00000079009c7306ULL, 0x0004e2000000d400ULL, 0x000000016e6e6812ULL, 0x000fc800078efcffULL,
0x000000916e6e723eULL, 0x000fe400000010ffULL, 0x000000016f6f3812ULL, 0x000fe200078efcffULL,
0x0000007800957306ULL, 0x000fe20000209400ULL, 0x0001000079797824ULL, 0x004fe200078e00ffULL,
0x0000009b9a00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000007800967306ULL, 0x0002ae0000205400ULL, 0x000000019c9c4812ULL, 0x008fe200078efcffULL,
0x0000007900a07306ULL, 0x000fe20000209400ULL, 0x0000007800787245ULL, 0x002fc4000020d400ULL,
0x0000009c6f6f723eULL, 0x000fca00000010ffULL, 0x0000007900a17306ULL, 0x0002e20000205400ULL,
0x000000969500720bULL, 0x004fe20003fdd000ULL, 0x0000006e702c723cULL, 0x080f6c000004182cULL,
0x0000009700987306ULL, 0x000fe20000209400ULL, 0x0000007900797245ULL, 0x002fe2000020d400ULL,
0x0000006e284c723cULL, 0x000f68000004184cULL, 0x0000000178786812ULL, 0x000fc400078efcffULL,
0x0000009700997306ULL, 0x0002a20000205400ULL, 0x000000a1a000720bULL, 0x008fe20003f7d000ULL,
0x000100007fa07824ULL, 0x000fca00078e00ffULL, 0x00000018ffa07819ULL, 0x000fe200000114a0ULL,
0x0000007a00a57306ULL, 0x000fe20000009400ULL, 0x0000009700977245ULL, 0x002fca000020d400ULL,
0x0000000179793812ULL, 0x000fe400078efcffULL, 0x0000007a00a67306ULL, 0x000e620000005400ULL,
0x000000999800720bULL, 0x004fce0003fbd000ULL, 0x000000a200a37306ULL, 0x000fec0000209400ULL,
0x0000000197975812ULL, 0x000fe400078efcffULL, 0x000000a200a47306ULL, 0x0004e20000205400ULL,
0x000000a6a500720bULL, 0x002fe40003fdd000ULL, 0x000000789778723eULL, 0x000fc400000010ffULL,
0x000000a000977245ULL, 0x000fc6000020d400ULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x000000a200a27245ULL, 0x004fce000020d400ULL, 0x000000b000b27306ULL, 0x0002a20000205400ULL,
0x000000a4a300720bULL, 0x008fce0003f9d000ULL, 0x000000a700a87306ULL, 0x000fe20000209400ULL,
0x000000b000b07245ULL, 0x002fca000020d400ULL, 0x00000001a2a24812ULL, 0x000fe400078efcffULL,
0x000000a700a97306ULL, 0x0002e20000205400ULL, 0x000000b2b100720bULL, 0x004fe40003f7d000ULL,
0x00000079a279723eULL, 0x000fca00000010ffULL, 0x0000007a00907306ULL, 0x000522000000d400ULL,
0x000000a700a77245ULL, 0x002fe2000020d400ULL, 0x000000787030723cULL, 0x080f680000041830ULL,
0x00000001b0b03812ULL, 0x000fe400078efcffULL, 0x0000007b00ae7306ULL, 0x000fe20000009400ULL,
0x000100007a7a7824ULL, 0x004fe200078e00ffULL, 0x000000a9a800720bULL, 0x008fe20003fbd000ULL,
0x000000782850723cULL, 0x000f660000041850ULL, 0x00000018ff7a7819ULL, 0x000fc4000001147aULL,
0x0000007b00af7306ULL, 0x000e620000005400ULL, 0x0000000190906812ULL, 0x010fcc00078efcffULL,
0x00000001a7a75812ULL, 0x000fe200078efcffULL, 0x000000ab00ac7306ULL, 0x000ff00000209400ULL,
0x000000ab00ad7306ULL, 0x0004e20000205400ULL, 0x000000afae00720bULL, 0x002fce0003f9d000ULL,
0x000000b300b47306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x004fce000020d400ULL,
0x000000b300b57306ULL, 0x000e620000205400ULL, 0x000000adac00720bULL, 0x008fce0003fdd000ULL,
0x0000007b008f7306ULL, 0x000eac000000d400ULL, 0x00000001abab6812ULL, 0x000fe400078efcffULL,
0x0000007a00aa7306ULL, 0x000fe20000209400ULL, 0x000000b5b400720bULL, 0x002fce0003f7d000ULL,
0x0000007a007b7306ULL, 0x000e620000205400ULL, 0x000000018f8f4812ULL, 0x004fce00078efcffULL,
0x000000b600b77306ULL, 0x000ff00000209400ULL, 0x000000b600b87306ULL, 0x0004e20000205400ULL,
0x0000007baa00720bULL, 0x002fce0003fbd000ULL, 0x000000bb00bc7306ULL, 0x000fe20000209400ULL,
0x000000b600b67245ULL, 0x004fce000020d400ULL, 0x000000bb00937306ULL, 0x000e620000205400ULL,
0x000000b8b700720bULL, 0x008fce0003f9d000ULL, 0x0000007c00b97306ULL, 0x000fec0000009400ULL,
0x00000001b6b64812ULL, 0x000fe400078efcffULL, 0x0000007c00ba7306ULL, 0x000ea20000005400ULL,
0x00000093bc00720bULL, 0x002fce0003fdd000ULL, 0x0000007c00897306ULL, 0x0002f0000000d400ULL,
0x0000009e00927306ULL, 0x000fe20000209400ULL, 0x000100007c7c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff947819ULL, 0x000fe2000001147cULL, 0x000001007e7c7824ULL, 0x000fe200078e00ffULL,
0x0000009e00997306ULL, 0x000fe80000205400ULL, 0x00000018ff9b7819ULL, 0x000fe4000001147cULL,
0x0000007a007c7245ULL, 0x000fe4000020d400ULL, 0x0000007d00c07306ULL, 0x000fe40000009400ULL,
0x000000017c7c5812ULL, 0x000fc400078efcffULL, 0x000000bab900720bULL, 0x004fe40003fbd000ULL,
0x0000007cab7c723eULL, 0x000fe400000010ffULL, 0x0000007d00c17306ULL, 0x000e700000005400ULL,
0x0000007d00887306ULL, 0x000522000000d400ULL, 0x0000000189895812ULL, 0x008fce00078efcffULL,
0x0000009400957306ULL, 0x000fe20000209400ULL, 0x000100007d7d7824ULL, 0x004fe200078e00ffULL,
0x000000c1c000720bULL, 0x002fc80003f9d000ULL, 0x00000018ff987819ULL, 0x000fe4000001147dULL,
0x0000009400967306ULL, 0x0002a20000205400ULL, 0x000000b3007d7245ULL, 0x000fc8000020d400ULL,
0x000000017d7d3812ULL, 0x000fe400078efcffULL, 0x000000999200720bULL, 0x000fe20003f7d000ULL,
0x000000bd00be7306ULL, 0x000fe20000209400ULL, 0x000000bb00927245ULL, 0x000fe4000020d400ULL,
0x0000009400947245ULL, 0x002fe4000020d400ULL, 0x0000000192926812ULL, 0x000fe400078efcffULL,
0x0000000188884812ULL, 0x010fe200078efcffULL, 0x000000bd00bf7306ULL, 0x0002e20000205400ULL,
0x000000969500720bULL, 0x004fc40003fdd000ULL, 0x0000009800957245ULL, 0x000fe4000020d400ULL,
0x0000007db67d723eULL, 0x000fc600000010ffULL, 0x0000008e00c27306ULL, 0x000fe20000209400ULL,
0x000000bd00bd7245ULL, 0x002fc6000020d400ULL, 0x0000007c7038723cULL, 0x000f640000041838ULL,
0x0000000194946812ULL, 0x000fe400078efcffULL, 0x0000008e00c37306ULL, 0x0002a20000205400ULL,
0x000000bfbe00720bULL, 0x008fc60003fbd000ULL, 0x0000007c2858723cULL, 0x000f680000041858ULL,
0x00000098009a7306ULL, 0x000fe20000209400ULL, 0x0000008e008e7245ULL, 0x002fca000020d400ULL,
0x00000001bdbd5812ULL, 0x000fe400078efcffULL, 0x00000098007b7306ULL, 0x000e620000205400ULL,
0x000000c3c200720bULL, 0x004fe40003f9d000ULL, 0x00000094bd94723eULL, 0x000fca00000010ffULL,
0x0000009b007a7306ULL, 0x000fec0000209400ULL, 0x000000018e8e4812ULL, 0x000fe400078efcffULL,
0x0000009b00937306ULL, 0x000ea20000205400ULL, 0x0000007b9a00720bULL, 0x002fe40003fdd000ULL,
0x0000008fb07b723eULL, 0x000fca00000010ffULL, 0x0000007f008d7306ULL, 0x000fec0000009400ULL,
0x0000000195956812ULL, 0x000fe400078efcffULL, 0x0000007f008c7306ULL, 0x000e620000005400ULL,
0x000000937a00720bULL, 0x004fe40003fbd000ULL, 0x00000090a77a723eULL, 0x000fc400000010ffULL,
0x000000958e95723eULL, 0x000fc600000010ffULL, 0x0000007f00277306ULL, 0x0004e4000000d400ULL,
0x0000007a7034723cULL, 0x040f6c0000041834ULL, 0x0000007e00c47306ULL, 0x000fe20000009400ULL,
0x0000009e007f7245ULL, 0x004fe2000020d400ULL, 0x000000947040723cULL, 0x000f620000041840ULL,
0x0000008c8d00720bULL, 0x002fc40003fdd000ULL, 0x000000017f7f3812ULL, 0x000fe400078efcffULL,
0x0000009b008c7245ULL, 0x000fe2000020d400ULL, 0x0000007e00c57306ULL, 0x000e620000005400ULL,
0x000000887f7f723eULL, 0x000fe200000010ffULL, 0x0000007a2854723cULL, 0x000f620000041854ULL,
0x0000009d00887245ULL, 0x000fe4000020d400ULL, 0x000000018c8c5812ULL, 0x000fc600078efcffULL,
0x0000009d009f7306ULL, 0x000fe20000209400ULL, 0x0000000127276812ULL, 0x008fe200078efcffULL,
0x000000942860723cULL, 0x000f6c0000041860ULL, 0x0000009d009e7306ULL, 0x000ea20000205400ULL,
0x000000c5c400720bULL, 0x002fce0003f7d000ULL, 0x0000007e00257306ULL, 0x0002f0000000d400ULL,
0x00000084008a7306ULL, 0x000fe20000209400ULL, 0x000100007e7e7824ULL, 0x002fe200078e00ffULL,
0x0000009e9f00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff967819ULL, 0x000fe4000001147eULL,
0x00000084008b7306ULL, 0x0002a20000205400ULL, 0x0000000125253812ULL, 0x008fe400078efcffULL,
0x00000089927e723eULL, 0x000fe400000010ffULL, 0x000000258c8c723eULL, 0x000fe400000010ffULL,
0x0000000188884812ULL, 0x000fe200078efcffULL, 0x0000008500877306ULL, 0x000fe20000209400ULL,
0x0000008400257245ULL, 0x000fe2000020d400ULL, 0x0000007e703c723cULL, 0x000f62000004183cULL,
0x0000008500847245ULL, 0x002fc4000020d400ULL, 0x00000027888d723eULL, 0x000fe200000010ffULL,
0x0000001004277824ULL, 0x000fe400078e0226ULL, 0x0000008500867306ULL, 0x000e620000205400ULL,
0x0000008b8a00720bULL, 0x004fe20003fbd000ULL, 0x0000007e285c723cULL, 0x000f6c000004185cULL,
0x0000009600997306ULL, 0x000fe40000209400ULL, 0x0000008c7044723cULL, 0x000f680000041844ULL,
0x0000000125255812ULL, 0x000fc400078efcffULL, 0x00000096009a7306ULL, 0x0004e20000205400ULL,
0x000000868700720bULL, 0x002fe20003f7d000ULL, 0x0000008c2864723cULL, 0x000f6c0000041864ULL,
0x000000a0008f7306ULL, 0x000fe20000209400ULL, 0x0000009600967245ULL, 0x004fca000020d400ULL,
0x0000000184843812ULL, 0x000fe400078efcffULL, 0x000000a000907306ULL, 0x000e620000205400ULL,
0x0000009a9900720bULL, 0x008fda0003f9d000ULL, 0x0000000196964812ULL, 0x000fe400078efcffULL,
0x000000908f00720bULL, 0x002fe40003fdd000ULL, 0x000000962596723eULL, 0x000fe400000010ffULL,
0x0000100003257810ULL, 0x000fd20007ffe0ffULL, 0x0000000197976812ULL, 0x000fc800078efcffULL,
0x000000978497723eULL, 0x000fce00000010ffULL, 0x000000967048723cULL, 0x080b6e0000041848ULL,
0x0000001005707824ULL, 0x020fe200078e0226ULL, 0x000000962868723cULL, 0x000b620000041868ULL,
0x0000001002267824ULL, 0x000fe200078e0225ULL, 0x000000002728783bULL, 0x0202a80000000200ULL,
0x000000007070783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fd80003800000ULL,
0x0000000f70707231ULL, 0x088fe400003400ffULL, 0x0000000f72727231ULL, 0x000fc400003400ffULL,
0x0000000e71717231ULL, 0x080fe400003400ffULL, 0x0000000e73737231ULL, 0x000fe400003400ffULL,
0x0000000d28287231ULL, 0x084fe400003400ffULL, 0x0000000d2a2a7231ULL, 0x000fe400003400ffULL,
0x0000000c29297231ULL, 0x080fe400003400ffULL, 0x0000000c2b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000002678783bULL, 0x000f220000004200ULL,
0x00000010007c7824ULL, 0x000fcc00078e0225ULL, 0x000000007c7c783bULL, 0x000e620000004200ULL,
0x0000010078947824ULL, 0x010fe200078e00ffULL, 0x00000078006e7306ULL, 0x000fe20000009400ULL,
0x00000018ff997819ULL, 0x000fe20000011478ULL, 0x0000010079977824ULL, 0x000fe200078e00ffULL,
0x00000018ffa47819ULL, 0x000fe20000011479ULL, 0x000001007aa97824ULL, 0x000fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011494ULL, 0x000001007bac7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9f7819ULL, 0x000fe20000011497ULL, 0x00000078006f7306ULL, 0x000f220000005400ULL,
0x00000018ffa97819ULL, 0x000fc400000114a9ULL, 0x00000018ffb47819ULL, 0x000fe400000114acULL,
0x00000018ffaf7819ULL, 0x000fe4000001147aULL, 0x00000018ffba7819ULL, 0x000fe2000001147bULL,
0x0000009400957306ULL, 0x000fe20000209400ULL, 0x00000018ff927819ULL, 0x002fe4000001147cULL,
0x00000018ff8d7819ULL, 0x000fe4000001147dULL, 0x00000018ff857819ULL, 0x000fc4000001147eULL,
0x00000018ff867819ULL, 0x000fe2000001147fULL, 0x0000009400967306ULL, 0x000e620000205400ULL,
0x0000006f6e00720bULL, 0x010fe40003f9d000ULL, 0x00000094006e7245ULL, 0x000fe4000020d400ULL,
0x0000009f006f7245ULL, 0x000fc6000020d400ULL, 0x0000007800937306ULL, 0x0008e2000000d400ULL,
0x000000969500720bULL, 0x002fe20003fdd000ULL, 0x0001000078787824ULL, 0x010fcc00078e00ffULL,
0x00000079009c7306ULL, 0x000fe20000009400ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000000193934812ULL, 0x008fca00078efcffULL, 0x0000007800977306ULL, 0x000fe20000209400ULL,
0x000000016e6e6812ULL, 0x000fc800078efcffULL, 0x000000936e6e723eULL, 0x000fc600000010ffULL,
0x0000007800987306ULL, 0x0002f00000205400ULL, 0x00000079009d7306ULL, 0x000f220000005400ULL,
0x0000007800787245ULL, 0x002fce000020d400ULL, 0x00000099009a7306ULL, 0x000fe20000209400ULL,
0x000000989700720bULL, 0x008fce0003fdd000ULL, 0x00000099009b7306ULL, 0x0002e20000205400ULL,
0x0000009d9c00720bULL, 0x010fe20003f1d000ULL, 0x000100007e9d7824ULL, 0x000fc800078e00ffULL,
0x0000000178786812ULL, 0x000fe400078efcffULL, 0x0000007a00a77306ULL, 0x000fe20000009400ULL,
0x0000009900997245ULL, 0x002fe4000020d400ULL, 0x00000018ff9d7819ULL, 0x000fca000001149dULL,
0x0000007a00a87306ULL, 0x000e620000005400ULL, 0x0000009b9a00720bULL, 0x008fce0003fbd000ULL,
0x0000007a008f7306ULL, 0x00072c000000d400ULL, 0x0000000199995812ULL, 0x000fe400078efcffULL,
0x000000a900aa7306ULL, 0x000fe20000209400ULL, 0x000100007a7a7824ULL, 0x008fe200078e00ffULL,
0x000000a8a700720bULL, 0x002fc40003f9d000ULL, 0x000000789978723eULL, 0x000fe400000010ffULL,
0x00000018ffac7819ULL, 0x000fe2000001147aULL, 0x000001007c7a7824ULL, 0x000fe200078e00ffULL,
0x000000a900ab7306ULL, 0x000e680000205400ULL, 0x00000018ffbf7819ULL, 0x000fe2000001147aULL,
0x000001007d7a7824ULL, 0x000fe400078e00ffULL, 0x000000018f8f4812ULL, 0x010fe200078efcffULL,
0x00000079009e7306ULL, 0x000724000000d400ULL, 0x00000018ffc67819ULL, 0x000fe2000001147aULL,
0x000001007e7a7824ULL, 0x000fca00078e00ffULL, 0x000000a400a57306ULL, 0x000fe20000209400ULL,
0x000000abaa00720bULL, 0x002fe20003fdd000ULL, 0x0001000079797824ULL, 0x008fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe4000001147aULL, 0x000000a9007a7245ULL, 0x000fe4000020d400ULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x000000a400a67306ULL, 0x0002e20000205400ULL,
0x000000019e9e0812ULL, 0x010fca00078efcffULL, 0x000000017a7a6812ULL, 0x000fe400078efcffULL,
0x000000b400b57306ULL, 0x000fe20000209400ULL, 0x000000a400a47245ULL, 0x002fe4000020d400ULL,
0x0000008f7a7a723eULL, 0x000fca00000010ffULL, 0x000000b400b67306ULL, 0x000e620000205400ULL,
0x000000a6a500720bULL, 0x008fce0003f1d000ULL, 0x0000007b00b27306ULL, 0x000fec0000009400ULL,
0x00000001a4a40812ULL, 0x000fe400078efcffULL, 0x0000007b00b37306ULL, 0x000fe20000005400ULL,
0x000000b6b500720bULL, 0x002fce0003fbd000ULL, 0x0000007b008e7306ULL, 0x0003f0000000d400ULL,
0x000000af00b07306ULL, 0x000fe20000209400ULL, 0x000100007b7b7824ULL, 0x002fca00078e00ffULL,
0x00000018ffb77819ULL, 0x000fe4000001147bULL, 0x000000af00b17306ULL, 0x0002e20000205400ULL,
0x000000b4007b7245ULL, 0x000fc8000020d400ULL, 0x000000017b7b5812ULL, 0x000fc600078efcffULL,
0x0000009f00a07306ULL, 0x000fe20000209400ULL, 0x000000af00af7245ULL, 0x002fce000020d400ULL,
0x0000009f00a17306ULL, 0x000e620000205400ULL, 0x000000b1b000720bULL, 0x008fce0003fdd000ULL,
0x000000ac00ad7306ULL, 0x000fec0000209400ULL, 0x00000001afaf6812ULL, 0x000fe400078efcffULL,
0x000000ac00ae7306ULL, 0x000ee20000205400ULL, 0x000000a1a000720bULL, 0x002fe20003f7d000ULL,
0x000001007fa07824ULL, 0x000fc400078e00ffULL, 0x000100007fa17824ULL, 0x000fc600078e00ffULL,
0x00000018ffa07819ULL, 0x000fe200000114a0ULL, 0x000000b700b87306ULL, 0x000fe20000209400ULL,
0x00000018ffa17819ULL, 0x000fca00000114a1ULL, 0x000000016f6f3812ULL, 0x000fe400078efcffULL,
0x000000b700b97306ULL, 0x000e620000205400ULL, 0x000000aead00720bULL, 0x008fe40003f1d000ULL,
0x0000009e6f6f723eULL, 0x000fca00000010ffULL, 0x000000c600c77306ULL, 0x000fe40000209400ULL,
0x0000006e702c723cULL, 0x080f6c000004182cULL, 0x000000c600967306ULL, 0x0007220000205400ULL,
0x000000b9b800720bULL, 0x002fe20003fbd000ULL, 0x0000006e284c723cULL, 0x004b6c000004184cULL,
0x0000007c00bd7306ULL, 0x000fe20000009400ULL, 0x000000c600c67245ULL, 0x008fc4000020d400ULL,
0x000126c8186e7811ULL, 0x020fca00078e18ffULL, 0x0000007c00be7306ULL, 0x000fe20000005400ULL,
0x00000096c700720bULL, 0x010fce0003fdd000ULL, 0x0000007d00c47306ULL, 0x000fec0000009400ULL,
0x00000001c6c66812ULL, 0x000fe400078efcffULL, 0x0000007d00c57306ULL, 0x000ff00000005400ULL,
0x0000007900a27306ULL, 0x000ff00000209400ULL, 0x0000007900a37306ULL, 0x0002b00000205400ULL,
0x0000007c008a7306ULL, 0x000722000000d400ULL, 0x0000007900797245ULL, 0x002fce000020d400ULL,
0x0000007d00877306ULL, 0x000322000000d400ULL, 0x000100007c7c7824ULL, 0x008fe200078e00ffULL,
0x000000a3a200720bULL, 0x004fc80003f7d000ULL, 0x00000018ff957819ULL, 0x000fe4000001147cULL,
0x0000007e00c87306ULL, 0x000fe20000009400ULL, 0x000100007d7d7824ULL, 0x002fe200078e00ffULL,
0x000000ac007c7245ULL, 0x000fc8000020d400ULL, 0x00000018ff947819ULL, 0x000fe4000001147dULL,
0x0000007e00c97306ULL, 0x000fe20000005400ULL, 0x000000b7007d7245ULL, 0x000fe4000020d400ULL,
0x000000017c7c0812ULL, 0x000fe400078efcffULL, 0x000000017d7d5812ULL, 0x000fe400078efcffULL,
0x000000bebd00720bULL, 0x000fe20003f1d000ULL, 0x0000007e00277306ULL, 0x000fe2000000d400ULL,
0x000000c5c400720bULL, 0x000fc40003fbd000ULL, 0x0000000179793812ULL, 0x000fe400078efcffULL,
0x000000b3b200720bULL, 0x000fe40003f7d000ULL, 0x0000009400937245ULL, 0x000fe2000020d400ULL,
0x0000007f00ca7306ULL, 0x000fe20000009400ULL, 0x00000079a479723eULL, 0x000fe400000010ffULL,
0x0000007caf7c723eULL, 0x000fe400000010ffULL, 0x000000018a8a0812ULL, 0x010fc400078efcffULL,
0x0000000187875812ULL, 0x000fe200078efcffULL, 0x0000007f00cb7306ULL, 0x000fe20000005400ULL,
0x000000787030723cULL, 0x000f620000041830ULL, 0x000000018e8e3812ULL, 0x000fc800078efcffULL,
0x0000008e7b7b723eULL, 0x000fe400000010ffULL, 0x0000007f00847306ULL, 0x000fe2000000d400ULL,
0x000000782850723cULL, 0x000f6e0000041850ULL, 0x00000095007e7306ULL, 0x000fe20000209400ULL,
0x0000007a7034723cULL, 0x080f6e0000041834ULL, 0x00000095007f7306ULL, 0x0002a20000205400ULL,
0x0000007a2854723cULL, 0x000f6e0000041854ULL, 0x000000ba00bb7306ULL, 0x000fe20000209400ULL,
0x0000009500957245ULL, 0x002fce000020d400ULL, 0x000000ba00bc7306ULL, 0x0002e20000205400ULL,
0x0000007f7e00720bULL, 0x004fe40003fdd000ULL, 0x0000008d007e7245ULL, 0x000fca000020d400ULL,
0x0000009200c27306ULL, 0x000fe20000209400ULL, 0x000000ba00ba7245ULL, 0x002fca000020d400ULL,
0x0000000195956812ULL, 0x000fe400078efcffULL, 0x0000009200c37306ULL, 0x0002a20000205400ULL,
0x000000bcbb00720bULL, 0x008fce0003f9d000ULL, 0x0000009400977306ULL, 0x000fe20000209400ULL,
0x0000009200927245ULL, 0x002fca000020d400ULL, 0x00000001baba4812ULL, 0x000fe400078efcffULL,
0x0000009400987306ULL, 0x000e620000205400ULL, 0x000000c3c200720bULL, 0x004fe40003f1d000ULL,
0x000000c9c800720bULL, 0x000fe40003f9d000ULL, 0x0000007dba7d723eULL, 0x000fc600000010ffULL,
0x0000008d00917306ULL, 0x000fe80000209400ULL, 0x0000007c7038723cULL, 0x080f640000041838ULL,
0x0000000192920812ULL, 0x000fe400078efcffULL, 0x0000008d00907306ULL, 0x000ea20000205400ULL,
0x000000989700720bULL, 0x002fe40003fbd000ULL, 0x0000000127274812ULL, 0x000fe200078efcffULL,
0x0000007c2858723cULL, 0x000f620000041858ULL, 0x000000959292723eULL, 0x000fc600000010ffULL,
0x000000bf00c07306ULL, 0x000fec0000209400ULL, 0x0000000193935812ULL, 0x000fe400078efcffULL,
0x000000bf00c17306ULL, 0x0002e20000205400ULL, 0x000000909100720bULL, 0x004fce0003fdd000ULL,
0x0000009a009b7306ULL, 0x000fe20000209400ULL, 0x000000bf00bf7245ULL, 0x002fca000020d400ULL,
0x000000017e7e6812ULL, 0x000fe400078efcffULL, 0x0000009a009c7306ULL, 0x0002a20000205400ULL,
0x000000c1c000720bULL, 0x008fe40003f7d000ULL, 0x000000937e93723eULL, 0x000fe400000010ffULL,
0x00000085007e7245ULL, 0x000fc6000020d400ULL, 0x000000a0009f7306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x002fe2000020d400ULL, 0x000000927040723cULL, 0x080f680000041840ULL,
0x00000001bfbf3812ULL, 0x000fe400078efcffULL, 0x000000a000a27306ULL, 0x000e620000205400ULL,
0x0000009c9b00720bULL, 0x004fe20003f1d000ULL, 0x000000922860723cULL, 0x000f620000041860ULL,
0x000000a0009b7245ULL, 0x000fc4000020d400ULL, 0x000000cbca00720bULL, 0x000fe40003f7d000ULL,
0x0000008abf8a723eULL, 0x000fe200000010ffULL, 0x0000008500887306ULL, 0x000fec0000209400ULL,
0x000000019a9a0812ULL, 0x000fe400078efcffULL, 0x00000085008b7306ULL, 0x000ea20000205400ULL,
0x000000a29f00720bULL, 0x002fc40003fbd000ULL, 0x0000000184843812ULL, 0x000fe400078efcffULL,
0x000000279a9a723eULL, 0x000fe200000010ffULL, 0x000000021f277824ULL, 0x000fe400078e00ffULL,
0x00000086008c7306ULL, 0x000fec0000209400ULL, 0x000000019b9b5812ULL, 0x000fc400078efcffULL,
0x0000008600897306ULL, 0x0002e20000205400ULL, 0x0000008b8800720bULL, 0x004fe40003fdd000ULL,
0x00000087c68b723eULL, 0x000fe400000010ffULL, 0x000000849b9b723eULL, 0x000fc600000010ffULL,
0x0000009d007f7306ULL, 0x000fe20000209400ULL, 0x0000008600867245ULL, 0x002fe2000020d400ULL,
0x0000008a703c723cULL, 0x040f68000004183cULL, 0x000000017e7e6812ULL, 0x000fe400078efcffULL,
0x0000009d00967306ULL, 0x0002a20000205400ULL, 0x000000898c00720bULL, 0x008fe20003f1d000ULL,
0x0000009a7044723cULL, 0x000f6c0000041844ULL, 0x000000a100907306ULL, 0x000fe20000209400ULL,
0x0000009d009d7245ULL, 0x002fe2000020d400ULL, 0x0000008a285c723cULL, 0x000f68000004185cULL,
0x0000000186860812ULL, 0x000fc400078efcffULL, 0x000000a1008f7306ULL, 0x000e620000205400ULL,
0x000000967f00720bULL, 0x004fe20003f9d000ULL, 0x0000009a2864723cULL, 0x000f620000041864ULL,
0x000000a1007f7245ULL, 0x000fd6000020d400ULL, 0x000000019d9d4812ULL, 0x000fe400078efcffULL,
0x0000008f9000720bULL, 0x002fe40003fbd000ULL, 0x0000009d7e7e723eULL, 0x000fd600000010ffULL,
0x000000017f7f5812ULL, 0x000fc800078efcffULL, 0x0000007f867f723eULL, 0x000fce00000010ffULL,
0x0000007e7048723cULL, 0x080f700000041848ULL, 0x0000007e2868723cULL, 0x000b6e0000041868ULL,
0xfffffff827287812ULL, 0x020fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006e6e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126900028ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff277224ULL, 0x000fc600078e00ffULL,
0x0000000000287805ULL, 0x004fc80000015200ULL, 0x00000400132b7984ULL, 0x000ea40000000800ULL,
0x800000002bff7812ULL, 0x006fc4000780486fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28717210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09007100780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407100780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x000000712a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000127277810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400132b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010014277824ULL, 0x000fca00078e0280ULL, 0x000000c027297810ULL, 0x000fc80007ffe0ffULL,
0x0000006029287812ULL, 0x000fca00078ec0ffULL, 0x0000000117727824ULL, 0x000fe200078e0228ULL,
0x000004000000a947ULL, 0x000fea0003800000ULL, 0x000000101f2a7824ULL, 0x000fe200078e00ffULL,
0x000000291c287217ULL, 0x000fe40007800000ULL, 0x00000003ff707819ULL, 0x000fe4000001161dULL,
0x000000102a737812ULL, 0x000fe200078ec0ffULL, 0x0000000128287824ULL, 0x000fe200078e0a29ULL,
0x00000004706e7810ULL, 0x040fe40007ffe0ffULL, 0x00000008707c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000170787824ULL, 0x100fe200078e0273ULL, 0x0000002873287217ULL, 0x000fe20007800000ULL,
0x000000016e7a7824ULL, 0x000fe200078e0273ULL, 0x0000640024797a11ULL, 0x000fe200078038ffULL,
0x0000000178297824ULL, 0x000fc400078e0272ULL, 0x0000000128717824ULL, 0x100fe200078e0a73ULL,
0x00006500247b7a11ULL, 0x000fe200000f3cffULL, 0x0000008029287825ULL, 0x000fe200078e00ffULL,
0x0000000c70247810ULL, 0x000fe40007ffe0ffULL, 0x000000716e00720cULL, 0x080fe20003f66070ULL,
0x000000017a2a7824ULL, 0x000fe200078e0272ULL, 0x00000012286e7212ULL, 0x000fe200078efcffULL,
0x000000017c7d7824ULL, 0x000fe200078e0273ULL, 0x000000717000720cULL, 0x000fe20003f86070ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x000000796e6e7210ULL, 0x000fc40007fbe0ffULL,
0x000000717c00720cULL, 0x000fe20003f06070ULL, 0x000000017d287824ULL, 0x000fe200078e0272ULL,
0x000000122a707212ULL, 0x000fe200078efcffULL, 0x00000001247c7824ULL, 0x000fe400078e0273ULL,
0x00000001296f7824ULL, 0x000fe200028e067bULL, 0x0000007970707210ULL, 0x000fe20007fde0ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x000000712400720cULL, 0x000fc60003fa6070ULL,
0x000000017c2a7824ULL, 0x000fe200078e0272ULL, 0x0000001228287212ULL, 0x000fe200078efcffULL,
0x000000012b717824ULL, 0x000fe400030e067bULL, 0x0000000178247824ULL, 0x000fe200078e021dULL,
0x0000007928287210ULL, 0x000fe20007fde0ffULL, 0x0000000878737824ULL, 0x000fe400078e00ffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0xfffffff873247812ULL, 0x000fe200078ee224ULL,
0x000000017a727824ULL, 0x100fe200078e021dULL, 0x000000122a2a7212ULL, 0x000fe200078efcffULL,
0x000000087a7f7824ULL, 0x000fe400078e00ffULL, 0x000000017d737824ULL, 0x140fe400078e021dULL,
0x000000087d787824ULL, 0x000fe200078e00ffULL, 0xfffffff87f727812ULL, 0x000fe200078ee272ULL,
0x000000017c7a7824ULL, 0x040fe400078e021dULL, 0x000000087c7d7824ULL, 0x000fe200078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee273ULL, 0x0000000129297824ULL, 0x000fe200030e067bULL,
0x000000792a2a7210ULL, 0x000fe20007fde0ffULL, 0x0000001024737824ULL, 0x100fe200078e0225ULL,
0xfffffff87d7a7812ULL, 0x000fe200078ee27aULL, 0x0000001072797824ULL, 0x000fc400078e0225ULL,
0x000000012b2b7824ULL, 0x000fe200030e067bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e737faeULL, 0x0003e2000e101c46ULL, 0x00000010787b7824ULL, 0x100fe400078e0225ULL,
0x000000107a7d7824ULL, 0x000fe200078e0225ULL, 0x0000000070797faeULL, 0x0003e8000d901c46ULL,
0x00000000287b7faeULL, 0x0003e8000c101c46ULL, 0x000000002a7d7faeULL, 0x0003e2000e901c46ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x000000101f287824ULL, 0x000fe200078e00ffULL,
0x0000640024737a11ULL, 0x000fc800078038ffULL, 0x0000001028287812ULL, 0x000fe400078ec0ffULL,
0x0000650024797a11ULL, 0x000fe400000f3cffULL, 0x000000281d297211ULL, 0x000fc800078fe8ffULL,
0x00000004292b7810ULL, 0x040fe20007ffe0ffULL, 0x00000001292a7824ULL, 0x140fe200078e021dULL,
0x0000000c29717810ULL, 0x040fe20007ffe0ffULL, 0x00000008296f7824ULL, 0x040fe400078e00ffULL,
0x0000000129287824ULL, 0x000fe400078e0272ULL, 0x000000082b7a7824ULL, 0x000fe200078e00ffULL,
0xfffffff86f787812ULL, 0x000fe200078ee22aULL, 0x000000012b2a7824ULL, 0x000fe200078e0272ULL,
0x00000008296f7810ULL, 0x000fe20007ffe0ffULL, 0x000000012b297824ULL, 0x000fc400078e021dULL,
0x0000000171707824ULL, 0x100fe400078e0272ULL, 0x000000016f6e7824ULL, 0x040fe200078e0272ULL,
0xfffffff87a727812ULL, 0x000fe200078ee229ULL, 0x000000016f2b7824ULL, 0x140fe400078e021dULL,
0x000000086f7c7824ULL, 0x000fe400078e00ffULL, 0x00000001716f7824ULL, 0x040fe400078e021dULL,
0x00000008717e7824ULL, 0x000fe200078e00ffULL, 0xfffffff87c7a7812ULL, 0x000fe200078ee22bULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff87e7c7812ULL, 0x000fe200078ee26fULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001228287212ULL, 0x000fc600078efcffULL,
0x000000806e6e7825ULL, 0x000fe200078e00ffULL, 0x0000007328287210ULL, 0x080fe40007f1e0ffULL,
0x000000122a2a7212ULL, 0x080fe200078efcffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000126e6e7212ULL, 0x080fe400078efcffULL, 0x000000732a2a7210ULL, 0x080fe20007f7e0ffULL,
0x0000000129297824ULL, 0x000fe200000e0679ULL, 0x0000001270707212ULL, 0x000fe200078efcffULL,
0x000000107a7b7824ULL, 0x000fe200078e0225ULL, 0x000000736e6e7210ULL, 0x080fe20007f1e0ffULL,
0x000000012b2b7824ULL, 0x000fe200018e0679ULL, 0x0000007370707210ULL, 0x000fe20007f9e0ffULL,
0x0000001078737824ULL, 0x000fc400078e0225ULL, 0x000000016f6f7824ULL, 0x100fe400000e0679ULL,
0x0000000171717824ULL, 0x000fe200020e0679ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028737faeULL, 0x0003e2000b901c46ULL, 0x0000001072797824ULL, 0x100fe400078e0225ULL,
0x000000107c7d7824ULL, 0x000fc600078e0225ULL, 0x000000002a797faeULL, 0x0003e8000b901c46ULL,
0x000000006e7b7faeULL, 0x0003e8000b901c46ULL, 0x00000000707d7faeULL, 0x0003e4000b901c46ULL,
0x0000000219197810ULL, 0x000fe20007ffe0ffULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0xffffffffff247424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000001b1900720cULL, 0x000fcc0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fee0008000a05ULL,
0x0000000119288824ULL, 0x000fe400078e0216ULL, 0x00000004ff298424ULL, 0x000fc800078e00ffULL,
0x0000660028288625ULL, 0x000fca00078e0029ULL, 0x0000000628248981ULL, 0x000322000c1e1900ULL,
0x000000081f2a7824ULL, 0x000fca00078e00ffULL, 0xfffffff02a2a7812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126b0002a6e7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126480023707f8cULL, 0x0002a4000c80043fULL, 0x0000000000287805ULL, 0x002fc40000015200ULL,
0x01264c00232b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x006fe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28737210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09007300780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407300780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x000000732a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01264c00232b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201f237824ULL, 0x000fca00078e00ffULL, 0xffffff8023237812ULL, 0x000fc800078ec0ffULL,
0x0000010012237810ULL, 0x000fca0007ffe023ULL, 0x0000000174237824ULL, 0x000fca00078e0223ULL,
0x0120000023707984ULL, 0x000e680000000800ULL, 0x0122000023717984ULL, 0x0004e20000000800ULL,
0x000000217000720bULL, 0x002fe20003f1d000ULL, 0x00011c727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000727806ULL, 0x004fc800000e0100ULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff737424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fd200078e0021ULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x0000000215287810ULL, 0x000fe40007ffe0ffULL, 0x000000217000720bULL, 0x000fe40003f74000ULL,
0x0000001f2800720cULL, 0x000fe20003f05270ULL, 0x00011c227f007947ULL, 0x000fd4000b800000ULL,
0x0000000000737806ULL, 0x000fc400018e0100ULL, 0x000000801f298824ULL, 0x000fe200078e0212ULL,
0x0000002170237209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000174288824ULL, 0x000fca00078e0229ULL, 0x0124002328008388ULL, 0x0003e20000000800ULL,
0x000000ff7300720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000002123217221ULL, 0x002fe20000010100ULL, 0x000000ff73ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b21217820ULL, 0x000fcc0000410000ULL,
0x0000002100217308ULL, 0x000e640000000800ULL, 0x0000002122227220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe2000001161dULL,
0x00011b627f007947ULL, 0x000fea000b800000ULL, 0x00001f2921297589ULL, 0x0002a400000e0000ULL,
0x000000292c2c7220ULL, 0x084fe20000410000ULL, 0x000000292d2d7220ULL, 0x080fe20000410000ULL,
0x0000002930307220ULL, 0x080fe20000410000ULL, 0x0000002931317220ULL, 0x080fe20000410000ULL,
0x0000002934347220ULL, 0x080fe20000410000ULL, 0x0000002935357220ULL, 0x080fe20000410000ULL,
0x0000002938387220ULL, 0x080fe20000410000ULL, 0x0000002939397220ULL, 0x080fe20000410000ULL,
0x000000293c3c7220ULL, 0x080fe20000410000ULL, 0x000000293d3d7220ULL, 0x080fe20000410000ULL,
0x0000002940407220ULL, 0x080fe20000410000ULL, 0x0000002941417220ULL, 0x080fe20000410000ULL,
0x0000002944447220ULL, 0x080fe20000410000ULL, 0x0000002945457220ULL, 0x080fe20000410000ULL,
0x0000002948487220ULL, 0x080fe20000410000ULL, 0x0000002949497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0073ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000081d297811ULL, 0x000fe200078ff0ffULL, 0x00011a327f007947ULL, 0x000fea000b800000ULL,
0x00001f2921297589ULL, 0x00046400000e0000ULL, 0x000000292e2e7220ULL, 0x086fe20000410000ULL,
0x000000292f2f7220ULL, 0x080fe20000410000ULL, 0x0000002932327220ULL, 0x080fe20000410000ULL,
0x0000002933337220ULL, 0x080fe20000410000ULL, 0x0000002936367220ULL, 0x080fe20000410000ULL,
0x0000002937377220ULL, 0x080fe20000410000ULL, 0x000000293a3a7220ULL, 0x080fe20000410000ULL,
0x000000293b3b7220ULL, 0x080fe20000410000ULL, 0x000000293e3e7220ULL, 0x080fe20000410000ULL,
0x000000293f3f7220ULL, 0x080fe20000410000ULL, 0x0000002942427220ULL, 0x080fe20000410000ULL,
0x0000002943437220ULL, 0x080fe20000410000ULL, 0x0000002946467220ULL, 0x080fe20000410000ULL,
0x0000002947477220ULL, 0x080fe20000410000ULL, 0x000000294a4a7220ULL, 0x080fe20000410000ULL,
0x000000294b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000073ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000101d297811ULL, 0x000fe200078ff0ffULL,
0x000119027f007947ULL, 0x000fea000b800000ULL, 0x00001f2921297589ULL, 0x00046400000e0000ULL,
0x000000294c4c7220ULL, 0x086fe20000410000ULL, 0x000000294d4d7220ULL, 0x080fe20000410000ULL,
0x0000002950507220ULL, 0x080fe20000410000ULL, 0x0000002951517220ULL, 0x080fe20000410000ULL,
0x0000002954547220ULL, 0x080fe20000410000ULL, 0x0000002955557220ULL, 0x080fe20000410000ULL,
0x0000002958587220ULL, 0x080fe20000410000ULL, 0x0000002959597220ULL, 0x080fe20000410000ULL,
0x000000295c5c7220ULL, 0x080fe20000410000ULL, 0x000000295d5d7220ULL, 0x080fe20000410000ULL,
0x0000002960607220ULL, 0x080fe20000410000ULL, 0x0000002961617220ULL, 0x080fe20000410000ULL,
0x0000002964647220ULL, 0x080fe20000410000ULL, 0x0000002965657220ULL, 0x080fe20000410000ULL,
0x0000002968687220ULL, 0x080fe20000410000ULL, 0x0000002969697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000073ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000181d297811ULL, 0x000fe200078ff0ffULL,
0x000117e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2921297589ULL, 0x00046400000e0000ULL,
0x000000294e4e7220ULL, 0x086fe20000410000ULL, 0x000000294f4f7220ULL, 0x080fe20000410000ULL,
0x0000002952527220ULL, 0x080fe20000410000ULL, 0x0000002953537220ULL, 0x080fe20000410000ULL,
0x0000002956567220ULL, 0x080fe20000410000ULL, 0x0000002957577220ULL, 0x080fe20000410000ULL,
0x000000295a5a7220ULL, 0x080fe20000410000ULL, 0x000000295b5b7220ULL, 0x080fe20000410000ULL,
0x000000295e5e7220ULL, 0x080fe20000410000ULL, 0x000000295f5f7220ULL, 0x080fe20000410000ULL,
0x0000002962627220ULL, 0x080fe20000410000ULL, 0x0000002963637220ULL, 0x080fe20000410000ULL,
0x0000002966667220ULL, 0x080fe20000410000ULL, 0x0000002967677220ULL, 0x080fe20000410000ULL,
0x000000296a6a7220ULL, 0x080fe20000410000ULL, 0x000000296b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000007372ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff737424ULL, 0x000fd800078e00ffULL, 0x8000002370700221ULL, 0x000fe20000010000ULL,
0x00007610ff730816ULL, 0x000fc60000000073ULL, 0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL,
0x0000007000110308ULL, 0x000e640000000800ULL, 0x0000001171710220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002271227221ULL, 0x008fc20000010000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000040010217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff217819ULL, 0x000fc8000001142bULL, 0x0000002a21217211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000221217819ULL, 0x000fc8000000122aULL,
0x000000210000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040010217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991073217816ULL, 0x000fc800000000ffULL,
0x000000ff2100720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff0c723eULL, 0x000fe400000010ffULL, 0x00000002ff217819ULL, 0x000fe4000001161dULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x000113d27f007947ULL, 0x000fea000b800000ULL,
0x00001f210c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000821297810ULL, 0x000fe20007ffe0ffULL,
0x000114027f007947ULL, 0x000fea000b800000ULL, 0x00000010210d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x00066a00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0006a400000e0000ULL,
0x0000001821297810ULL, 0x008fe20007ffe0ffULL, 0x000114527f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0022e400000e0000ULL, 0x000004001f217824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x0000001007787824ULL, 0x000fc400078e0203ULL, 0xfffff00021217812ULL, 0x000fc800078ec0ffULL,
0x0000c00021217810ULL, 0x000fca0007ffe0ffULL, 0x0000001009097824ULL, 0x100fe400078e0221ULL,
0x0000001008087824ULL, 0x000fc600078e0221ULL, 0x000000000970783bULL, 0x0002e80000000200ULL,
0x000000000828783bULL, 0x0022a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f70707231ULL, 0x08cfe400003400ffULL, 0x0000000f72727231ULL, 0x000fe400003400ffULL,
0x0000000e71717231ULL, 0x080fe400003400ffULL, 0x0000000e73737231ULL, 0x000fc400003400ffULL,
0x0000000d28287231ULL, 0x080fe400003400ffULL, 0x0000000d2a2a7231ULL, 0x000fe400003400ffULL,
0x0000000c29297231ULL, 0x080fe400003400ffULL, 0x0000000c2b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000e620000004200ULL,
0x00000010067c7824ULL, 0x000fe200078e0203ULL, 0x00000f8000007945ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000100786d7824ULL, 0x002fe200078e00ffULL,
0x0000007800087306ULL, 0x000fe20000009400ULL, 0x0000010079957824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe20000011478ULL, 0x000001007aa77824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x000001007bae7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe20000011495ULL, 0x000001007cb37824ULL, 0x008fe200078e00ffULL,
0x0000007800097306ULL, 0x000e620000005400ULL, 0x00000018ffa27819ULL, 0x000fe20000011479ULL,
0x000001007db67824ULL, 0x000fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fc400000114a7ULL,
0x00000018ffae7819ULL, 0x000fe400000114aeULL, 0x00000018ffb37819ULL, 0x000fe200000114b3ULL,
0x00000079009a7306ULL, 0x000fe20000009400ULL, 0x00000018ffbd7819ULL, 0x000fe400000114b6ULL,
0x00000018ffb87819ULL, 0x000fe4000001147cULL, 0x00000018ffc17819ULL, 0x000fe4000001147dULL,
0x00000018ff8a7819ULL, 0x000fe2000001147aULL, 0x00000079009b7306ULL, 0x000ee20000005400ULL,
0x000000090800720bULL, 0x002fe20003fdd000ULL, 0x000001007e087824ULL, 0x000fe200078e00ffULL,
0x0000009d00097245ULL, 0x000fc4000020d400ULL, 0x00000018ff897819ULL, 0x000fe4000001147bULL,
0x00000018ff847819ULL, 0x000fe2000001147fULL, 0x0000006d00937306ULL, 0x000fe20000209400ULL,
0x00000018ff067819ULL, 0x000fce000001147eULL, 0x0000006d00947306ULL, 0x0002a20000205400ULL,
0x0000009b9a00720bULL, 0x008fe40003f9d000ULL, 0x00000018ff9a7819ULL, 0x000fe20000011408ULL,
0x000001007f087824ULL, 0x000fc800078e00ffULL, 0x0000009d009e7306ULL, 0x000fe20000209400ULL,
0x0000006d006d7245ULL, 0x002fce000020d400ULL, 0x0000009d009f7306ULL, 0x000e620000205400ULL,
0x000000949300720bULL, 0x004fce0003fbd000ULL, 0x00000078006c7306ULL, 0x0004ec000000d400ULL,
0x000000016d6d5812ULL, 0x000fe400078efcffULL, 0x00000079009c7306ULL, 0x0006e2000000d400ULL,
0x0001000078787824ULL, 0x004fe200078e00ffULL, 0x0000009f9e00720bULL, 0x002fc40003f7d000ULL,
0x00000018ff9f7819ULL, 0x000fe20000011408ULL, 0x000100007b087824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000009700987306ULL, 0x000fe20000209400ULL,
0x0001000079797824ULL, 0x008fe200078e00ffULL, 0x000000016c6c6812ULL, 0x000fc800078efcffULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000009700997306ULL, 0x0002a20000205400ULL,
0x000000019c9c4812ULL, 0x000fe400078efcffULL, 0x0000000109093812ULL, 0x000fc800078efcffULL,
0x0000009c0909723eULL, 0x000fe200000010ffULL, 0x000000a200a37306ULL, 0x000fe20000209400ULL,
0x0000009700977245ULL, 0x002fce000020d400ULL, 0x000000a200a47306ULL, 0x0002e20000205400ULL,
0x000000999800720bULL, 0x004fe40003fdd000ULL, 0x0000009a00997245ULL, 0x000fca000020d400ULL,
0x0000007800957306ULL, 0x000fe20000209400ULL, 0x000000a200a27245ULL, 0x002fca000020d400ULL,
0x0000000197976812ULL, 0x000fe400078efcffULL, 0x0000007800967306ULL, 0x0002a20000205400ULL,
0x000000a4a300720bULL, 0x008fe20003f9d000ULL, 0x000100007fa37824ULL, 0x000fca00078e00ffULL,
0x00000018ffa37819ULL, 0x000fe200000114a3ULL, 0x0000007900a07306ULL, 0x000fe20000209400ULL,
0x0000007800787245ULL, 0x002fca000020d400ULL, 0x00000001a2a24812ULL, 0x000fe400078efcffULL,
0x0000007900a17306ULL, 0x0002e20000205400ULL, 0x000000969500720bULL, 0x004fe40003fbd000ULL,
0x000000bd00967245ULL, 0x000fe4000020d400ULL, 0x000000b800957245ULL, 0x000fc6000020d400ULL,
0x0000007a00a57306ULL, 0x000fe20000009400ULL, 0x0000007900797245ULL, 0x002fca000020d400ULL,
0x0000000178785812ULL, 0x000fe400078efcffULL, 0x0000007a00a67306ULL, 0x000e620000005400ULL,
0x000000a1a000720bULL, 0x008fce0003f7d000ULL, 0x0000007b00ac7306ULL, 0x000fec0000009400ULL,
0x0000000179793812ULL, 0x000fe400078efcffULL, 0x0000007b00ad7306ULL, 0x000ea20000005400ULL,
0x000000a6a500720bULL, 0x002fce0003fdd000ULL, 0x000000a700a87306ULL, 0x000ff00000209400ULL,
0x000000a700a97306ULL, 0x0002e20000205400ULL, 0x000000adac00720bULL, 0x004fce0003f9d000ULL,
0x000000ae00af7306ULL, 0x000fe20000209400ULL, 0x000000a700a77245ULL, 0x002fce000020d400ULL,
0x000000ae00b07306ULL, 0x0002a20000205400ULL, 0x000000a9a800720bULL, 0x008fce0003fbd000ULL,
0x0000007a00907306ULL, 0x0006e2000000d400ULL, 0x000000ae00ae7245ULL, 0x002fca000020d400ULL,
0x00000001a7a75812ULL, 0x000fe400078efcffULL, 0x0000007b008f7306ULL, 0x000262000000d400ULL,
0x000000b0af00720bULL, 0x004fe20003f7d000ULL, 0x000100007a7a7824ULL, 0x008fcc00078e00ffULL,
0x0000007c00b17306ULL, 0x000fe20000009400ULL, 0x0000000190906812ULL, 0x000fe400078efcffULL,
0x00000018ff7b7819ULL, 0x002fc6000001147aULL, 0x00000001aeae3812ULL, 0x000fe400078efcffULL,
0x0000007c00b27306ULL, 0x000e620000005400ULL, 0x000000018f8f4812ULL, 0x000fce00078efcffULL,
0x0000007d00bb7306ULL, 0x000ff00000009400ULL, 0x0000007d00bc7306ULL, 0x000ea20000005400ULL,
0x000000b2b100720bULL, 0x002fce0003fdd000ULL, 0x000000b300b47306ULL, 0x000ff00000209400ULL,
0x000000b300b57306ULL, 0x0002e20000205400ULL, 0x000000bcbb00720bULL, 0x004fce0003f9d000ULL,
0x000000bd00be7306ULL, 0x000fe20000209400ULL, 0x000000b300b37245ULL, 0x002fce000020d400ULL,
0x000000bd00bf7306ULL, 0x000e620000205400ULL, 0x000000b5b400720bULL, 0x008fce0003fbd000ULL,
0x0000007c008e7306ULL, 0x0004ec000000d400ULL, 0x00000001b3b35812ULL, 0x000fe400078efcffULL,
0x0000007d008d7306ULL, 0x0006e2000000d400ULL, 0x000100007c7c7824ULL, 0x004fe200078e00ffULL,
0x000000bfbe00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x000000b800b97306ULL, 0x000fe20000209400ULL, 0x000100007d7d7824ULL, 0x008fe200078e00ffULL,
0x000000018e8e6812ULL, 0x000fc800078efcffULL, 0x00000018ffc07819ULL, 0x000fe4000001147dULL,
0x000000b800ba7306ULL, 0x000e620000205400ULL, 0x000000018d8d4812ULL, 0x000fe400078efcffULL,
0x0000000196963812ULL, 0x000fca00078efcffULL, 0x000000c100c27306ULL, 0x000ff00000209400ULL,
0x000000c100c37306ULL, 0x0004e20000205400ULL, 0x000000bab900720bULL, 0x002fce0003fdd000ULL,
0x0000007c00b67306ULL, 0x000fe20000209400ULL, 0x000000c100c17245ULL, 0x004fca000020d400ULL,
0x0000000195956812ULL, 0x000fe400078efcffULL, 0x0000007c00b77306ULL, 0x000e620000205400ULL,
0x000000c3c200720bULL, 0x008fce0003f9d000ULL, 0x000000c000937306ULL, 0x000fec0000209400ULL,
0x00000001c1c14812ULL, 0x000fe400078efcffULL, 0x000000c000947306ULL, 0x0004e20000205400ULL,
0x000000b7b600720bULL, 0x002fce0003fbd000ULL, 0x0000007e00c47306ULL, 0x000fe20000009400ULL,
0x000000c000c07245ULL, 0x004fce000020d400ULL, 0x0000007e00c57306ULL, 0x000e620000005400ULL,
0x000000949300720bULL, 0x008fe40003f7d000ULL, 0x00000018ff937819ULL, 0x000fe40000011408ULL,
0x0000007c00947245ULL, 0x000fe4000020d400ULL, 0x0000006c6d08723eULL, 0x000fe200000010ffULL,
0x0000009f00a07306ULL, 0x000fe20000209400ULL, 0x0000000194945812ULL, 0x000fe400078efcffULL,
0x00000078976c723eULL, 0x000fc400000010ffULL, 0x00000079a26d723eULL, 0x000fe200000010ffULL,
0x00000008702c723cULL, 0x040f62000004182cULL, 0x00000001c0c03812ULL, 0x000fe200078efcffULL,
0x0000009f00a17306ULL, 0x000ea20000205400ULL, 0x000000c5c400720bULL, 0x002fe40003fdd000ULL,
0x00000090a778723eULL, 0x000fe400000010ffULL, 0x0000008fae79723eULL, 0x000fe200000010ffULL,
0x0000006c7030723cULL, 0x040f640000041830ULL, 0x0000007f00c67306ULL, 0x000fec0000009400ULL,
0x000000787034723cULL, 0x000f640000041834ULL, 0x0000007f00c77306ULL, 0x000e620000005400ULL,
0x000000a1a000720bULL, 0x004fca0003f9d000ULL, 0x00000008284c723cULL, 0x040f64000004184cULL,
0x0000009a009b7306ULL, 0x000fec0000209400ULL, 0x0000006c2850723cULL, 0x000f640000041850ULL,
0x0000009a00987306ULL, 0x000ea20000205400ULL, 0x000000c7c600720bULL, 0x002fca0003f7d000ULL,
0x000000782854723cULL, 0x000b640000041854ULL, 0x0000007e00867306ULL, 0x0002ea000000d400ULL,
0x0000001002787824ULL, 0x020fc600078e0203ULL, 0x0000007b007a7306ULL, 0x000fe20000209400ULL,
0x000000989b00720bULL, 0x004fe20003fbd000ULL, 0x000100007e7e7824ULL, 0x002fe200078e00ffULL,
0x0000009f00987245ULL, 0x000fc8000020d400ULL, 0x00000018ff9d7819ULL, 0x000fe2000001147eULL,
0x0000007b007d7306ULL, 0x0002a20000205400ULL, 0x0000000186866812ULL, 0x008fe400078efcffULL,
0x0000000198984812ULL, 0x000fe400078efcffULL, 0x0000007b007e7245ULL, 0x000fe4000020d400ULL,
0x0000000199995812ULL, 0x000fe200078efcffULL, 0x0000008900917306ULL, 0x000fe20000209400ULL,
0x0000008d967b723eULL, 0x002fc400000010ffULL, 0x000000869986723eULL, 0x000fca00000010ffULL,
0x0000008900927306ULL, 0x000e620000205400ULL, 0x0000007d7a00720bULL, 0x004fe40003fdd000ULL,
0x0000008eb37a723eULL, 0x000fe400000010ffULL, 0x000000c0c17d723eULL, 0x000fc600000010ffULL,
0x0000007f00857306ULL, 0x000ea4000000d400ULL, 0x0000007a703c723cULL, 0x080f68000004183cULL,
0x000000017e7e6812ULL, 0x000fe400078efcffULL, 0x0000008a00aa7306ULL, 0x000fe20000209400ULL,
0x000000929100720bULL, 0x002fe20003f9d000ULL, 0x0000007a285c723cULL, 0x000f6c000004185cULL,
0x0000008a00ab7306ULL, 0x000e620000205400ULL, 0x0000000185853812ULL, 0x004fce00078efcffULL,
0x00000093007c7306ULL, 0x000ff00000209400ULL, 0x00000093007f7306ULL, 0x0004e20000205400ULL,
0x000000abaa00720bULL, 0x002fce0003fbd000ULL, 0x00000006008c7306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x004fce000020d400ULL, 0x00000006008b7306ULL, 0x0002a20000205400ULL,
0x0000007f7c00720bULL, 0x008fe40003f7d000ULL, 0x0000008a007f7245ULL, 0x000fe4000020d400ULL,
0x00000089008a7245ULL, 0x000fe4000020d400ULL, 0x000000017f7f5812ULL, 0x000fe200078efcffULL,
0x0000008400887306ULL, 0x000fe20000209400ULL, 0x000000018a8a4812ULL, 0x000fe400078efcffULL,
0x0000000600067245ULL, 0x002fc4000020d400ULL, 0x0000007e7f7e723eULL, 0x000fe400000010ffULL,
0x0000000193933812ULL, 0x000fe200078efcffULL, 0x0000008400877306ULL, 0x000e620000205400ULL,
0x0000008b8c00720bULL, 0x004fe40003fdd000ULL, 0x00000094957c723eULL, 0x000fe400000010ffULL,
0x000000938a7f723eULL, 0x000fc600000010ffULL, 0x0000009d009e7306ULL, 0x000fe40000209400ULL,
0x0000007c7040723cULL, 0x040f680000041840ULL, 0x0000000106066812ULL, 0x000fe400078efcffULL,
0x0000009d00977306ULL, 0x0004e20000205400ULL, 0x000000878800720bULL, 0x002fe20003fbd000ULL,
0x0000007e7038723cULL, 0x000f620000041838ULL, 0x000000859887723eULL, 0x000fc400000010ffULL,
0x0000008400887245ULL, 0x000fe4000020d400ULL, 0x000000a300857245ULL, 0x000fe2000020d400ULL,
0x000000a300917306ULL, 0x000fe20000209400ULL, 0x0000009d009d7245ULL, 0x004fe2000020d400ULL,
0x000000867044723cULL, 0x000f680000041844ULL, 0x0000000188885812ULL, 0x000fe400078efcffULL,
0x000000a3008e7306ULL, 0x000e620000205400ULL, 0x000000979e00720bULL, 0x008fe20003f7d000ULL,
0x0000007c2860723cULL, 0x040f700000041860ULL, 0x000000862864723cULL, 0x000f680000041864ULL,
0x000000019d9d3812ULL, 0x000fc400078efcffULL, 0x0000008e9100720bULL, 0x002fe40003f9d000ULL,
0x0000009d0684723eULL, 0x000fe200000010ffULL, 0x0000007e2858723cULL, 0x000f740000041858ULL,
0x0000000185854812ULL, 0x000fc800078efcffULL, 0x000000858885723eULL, 0x000fce00000010ffULL,
0x000000847048723cULL, 0x080b6e0000041848ULL, 0x0000001005707824ULL, 0x120fe200078e0221ULL,
0x000000842828723cULL, 0x000b620000041868ULL, 0x0000001004217824ULL, 0x000fc800078e0221ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000002168783bULL, 0x0204e20000000200ULL,
0x0000008000000947ULL, 0x000fd20003800000ULL, 0x0000000f70707231ULL, 0x082fe400003400ffULL,
0x0000000f72727231ULL, 0x000fe400003400ffULL, 0x0000000e71717231ULL, 0x080fe400003400ffULL,
0x0000000e73737231ULL, 0x000fc400003400ffULL, 0x0000000d68687231ULL, 0x088fe400003400ffULL,
0x0000000d6a6a7231ULL, 0x000fe400003400ffULL, 0x0000000c69697231ULL, 0x080fe400003400ffULL,
0x0000000c6b6b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007878783bULL, 0x000ea20000004200ULL, 0x00000010007c7824ULL, 0x000fcc00078e0203ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000100798f7824ULL, 0x004fe200078e00ffULL,
0x0000007800087306ULL, 0x000fe20000009400ULL, 0x00000018ff917819ULL, 0x000fe20000011478ULL,
0x00000100786d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9c7819ULL, 0x000fe20000011479ULL,
0x000001007aa17824ULL, 0x000fe200078e00ffULL, 0x00000018ff977819ULL, 0x000fe2000001148fULL,
0x000001007cb57824ULL, 0x008fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000007800097306ULL, 0x000ea20000005400ULL, 0x00000018ffa17819ULL, 0x000fe200000114a1ULL,
0x000001007ba47824ULL, 0x000fe200078e00ffULL, 0x00000018ffa57819ULL, 0x000fe2000001147aULL,
0x000001007dbd7824ULL, 0x000fe200078e00ffULL, 0x00000018ffb57819ULL, 0x000fe200000114b5ULL,
0x000100007bad7824ULL, 0x000fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe200000114a4ULL,
0x0000009700987306ULL, 0x000fe20000209400ULL, 0x00000018ffb87819ULL, 0x000fc4000001147cULL,
0x00000018ffbd7819ULL, 0x000fe400000114bdULL, 0x00000018ffb07819ULL, 0x000fe4000001147bULL,
0x00000018ff897819ULL, 0x000fe2000001147dULL, 0x0000009700997306ULL, 0x000ee20000205400ULL,
0x000000090800720bULL, 0x004fe40003fbd000ULL, 0x0000009700097245ULL, 0x000fe4000020d400ULL,
0x00000018ffad7819ULL, 0x000fc400000114adULL, 0x00000018ff027819ULL, 0x000fe2000001147eULL,
0x00000078006c7306ULL, 0x000462000000d400ULL, 0x00000018ff007819ULL, 0x000fce000001147fULL,
0x0000007900947306ULL, 0x000fe20000009400ULL, 0x0001000078787824ULL, 0x004fe200078e00ffULL,
0x000000999800720bULL, 0x008fe20003f7d000ULL, 0x000001007f987824ULL, 0x040fe400078e00ffULL,
0x000100007f997824ULL, 0x000fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007900957306ULL, 0x000ea20000005400ULL, 0x000000016c6c5812ULL, 0x002fe400078efcffULL,
0x00000018ff987819ULL, 0x000fc40000011498ULL, 0x00000018ff997819ULL, 0x000fe40000011499ULL,
0x0000000109093812ULL, 0x000fe200078efcffULL, 0x0000007900967306ULL, 0x0002f0000000d400ULL,
0x00000078008f7306ULL, 0x000fe20000209400ULL, 0x0001000079797824ULL, 0x002fe200078e00ffULL,
0x000000959400720bULL, 0x004fe20003f9d000ULL, 0x000001007e947824ULL, 0x000fc400078e00ffULL,
0x000100007e957824ULL, 0x000fe200078e00ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000007800907306ULL, 0x0002a20000205400ULL, 0x00000018ff947819ULL, 0x000fcc0000011494ULL,
0x0000000196964812ULL, 0x008fe200078efcffULL, 0x00000079009a7306ULL, 0x000fe20000209400ULL,
0x0000007800787245ULL, 0x002fe4000020d400ULL, 0x000000960909723eULL, 0x000fca00000010ffULL,
0x00000079009b7306ULL, 0x0002e20000205400ULL, 0x000000908f00720bULL, 0x004fce0003fdd000ULL,
0x000000a100a27306ULL, 0x000fe20000209400ULL, 0x0000007900797245ULL, 0x002fca000020d400ULL,
0x0000000178786812ULL, 0x000fe400078efcffULL, 0x000000a100a37306ULL, 0x0002a20000205400ULL,
0x0000009b9a00720bULL, 0x008fce0003f7d000ULL, 0x0000007b00a87306ULL, 0x000fe20000009400ULL,
0x000000a100a17245ULL, 0x002fca000020d400ULL, 0x0000000179793812ULL, 0x000fe400078efcffULL,
0x0000007b00a97306ULL, 0x000e620000005400ULL, 0x000000a3a200720bULL, 0x004fce0003fdd000ULL,
0x0000009100927306ULL, 0x000fec0000209400ULL, 0x00000001a1a16812ULL, 0x000fe400078efcffULL,
0x0000009100937306ULL, 0x0004e20000205400ULL, 0x000000a9a800720bULL, 0x002fce0003f7d000ULL,
0x0000006d008d7306ULL, 0x000fe20000209400ULL, 0x0000009100917245ULL, 0x004fce000020d400ULL,
0x0000006d008e7306ULL, 0x0002a20000205400ULL, 0x000000939200720bULL, 0x008fce0003fbd000ULL,
0x0000009c009d7306ULL, 0x000fe20000209400ULL, 0x0000006d006d7245ULL, 0x002fca000020d400ULL,
0x0000000191915812ULL, 0x000fe400078efcffULL, 0x0000009c009e7306ULL, 0x0002e20000205400ULL,
0x0000008e8d00720bULL, 0x004fe20003f1d000ULL, 0x000100007d8e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001148eULL, 0x000000a500a67306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fca000020d400ULL, 0x000000016d6d0812ULL, 0x000fe400078efcffULL,
0x000000a500a77306ULL, 0x0002a20000205400ULL, 0x0000009e9d00720bULL, 0x008fce0003f9d000ULL,
0x0000007b008b7306ULL, 0x000ee2000000d400ULL, 0x000000a500a57245ULL, 0x002fca000020d400ULL,
0x000000019c9c4812ULL, 0x000fe400078efcffULL, 0x000000b500b67306ULL, 0x000fe20000209400ULL,
0x000000a7a600720bULL, 0x004fce0003fdd000ULL, 0x000000b500b77306ULL, 0x0002a20000205400ULL,
0x000000018b8b3812ULL, 0x008fca00078efcffULL, 0x00000001a5a56812ULL, 0x000fe400078efcffULL,
0x0000007a009f7306ULL, 0x000fe20000009400ULL, 0x000000b500b57245ULL, 0x002fce000020d400ULL,
0x0000007a00a07306ULL, 0x000e620000005400ULL, 0x000000b7b600720bULL, 0x004fce0003f7d000ULL,
0x0000007a008c7306ULL, 0x0004ec000000d400ULL, 0x00000001b5b53812ULL, 0x000fe400078efcffULL,
0x0000007c00b37306ULL, 0x000fe20000009400ULL, 0x000100007a7a7824ULL, 0x004fe200078e00ffULL,
0x000000a09f00720bULL, 0x002fc80003f1d000ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x0000007c00b47306ULL, 0x000fee0000005400ULL, 0x000000018c8c0812ULL, 0x008fe200078efcffULL,
0x0000007c008a7306ULL, 0x0003f0000000d400ULL, 0x000000aa00ab7306ULL, 0x000fe20000209400ULL,
0x000100007c7c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x000000aa00ac7306ULL, 0x0002b00000205400ULL, 0x0000007a00a47306ULL, 0x000fe20000209400ULL,
0x000000aa00aa7245ULL, 0x002fce000020d400ULL, 0x0000007a007b7306ULL, 0x000e620000205400ULL,
0x000000acab00720bULL, 0x004fce0003fbd000ULL, 0x000000bd00be7306ULL, 0x000fec0000209400ULL,
0x00000001aaaa5812ULL, 0x000fe400078efcffULL, 0x000000bd008d7306ULL, 0x000ea20000205400ULL,
0x0000007ba400720bULL, 0x002fe40003f9d000ULL, 0x000000bd007b7245ULL, 0x000fca000020d400ULL,
0x0000007d00bb7306ULL, 0x000ff00000009400ULL, 0x0000007d00bc7306ULL, 0x000fe20000005400ULL,
0x0000008dbe00720bULL, 0x004fe40003fdd000ULL, 0x00000018ff8d7819ULL, 0x000fca0000011495ULL,
0x0000007d00887306ULL, 0x000fec000000d400ULL, 0x000000017b7b6812ULL, 0x000fe400078efcffULL,
0x0000007c00087306ULL, 0x000ff00000209400ULL, 0x0000007c007d7306ULL, 0x0002b00000205400ULL,
0x000000ad00ae7306ULL, 0x000fe20000209400ULL, 0x0000007c007c7245ULL, 0x002fce000020d400ULL,
0x000000ad00af7306ULL, 0x000e620000205400ULL, 0x0000007d0800720bULL, 0x004fe40003f7d000ULL,
0x000000b8007d7245ULL, 0x000fe4000020d400ULL, 0x0000006c6d08723eULL, 0x000fe400000010ffULL,
0x00000078916c723eULL, 0x000fe200000010ffULL, 0x000000b800b97306ULL, 0x000fe20000209400ULL,
0x000000799c6d723eULL, 0x000fe400000010ffULL, 0x0000008ca178723eULL, 0x000fe200000010ffULL,
0x00000008684c723cULL, 0x000b62000004184cULL, 0x0000008baa79723eULL, 0x000fc400000010ffULL,
0x000000017c7c3812ULL, 0x000fe200078efcffULL, 0x000000b800ba7306ULL, 0x000ea20000205400ULL,
0x000000afae00720bULL, 0x002fc60003fbd000ULL, 0x0000006c6850723cULL, 0x040b680000041850ULL,
0x0000008e008f7306ULL, 0x000fe80000209400ULL, 0x000000786854723cULL, 0x000b680000041854ULL,
0x0000008e00907306ULL, 0x0002e20000205400ULL, 0x000000bab900720bULL, 0x004fc60003fdd000ULL,
0x00000008702c723cULL, 0x000b68000004182cULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x0000008e008e7245ULL, 0x002fc6000020d400ULL, 0x0000006c7030723cULL, 0x040b640000041830ULL,
0x000000017d7d6812ULL, 0x000fe400078efcffULL, 0x000000b000b27306ULL, 0x0002a20000205400ULL,
0x000000908f00720bULL, 0x008fe40003f7d000ULL, 0x0000007c7d7c723eULL, 0x000fe200000010ffULL,
0x000000787034723cULL, 0x000b680000041834ULL, 0x0000007e00c17306ULL, 0x000fe20000009400ULL,
0x000000b000b07245ULL, 0x002fca000020d400ULL, 0x000000018e8e3812ULL, 0x000fe400078efcffULL,
0x0000007e00c27306ULL, 0x000e620000005400ULL, 0x000000b2b100720bULL, 0x004fce0003f1d000ULL,
0x0000007e00217306ULL, 0x0004ec000000d400ULL, 0x00000001b0b00812ULL, 0x000fe400078efcffULL,
0x0000009400927306ULL, 0x000fe20000209400ULL, 0x0000007a007e7245ULL, 0x004fe4000020d400ULL,
0x000000c2c100720bULL, 0x002fc40003f1d000ULL, 0x000000017e7e4812ULL, 0x000fe400078efcffULL,
0x000000b4b300720bULL, 0x000fe20003f9d000ULL, 0x0000009400937306ULL, 0x0002a20000205400ULL,
0x0000007ea57e723eULL, 0x000fce00000010ffULL, 0x0000007f00c37306ULL, 0x000fe20000009400ULL,
0x0000009400947245ULL, 0x002fe4000020d400ULL, 0x0000000121210812ULL, 0x008fe400078efcffULL,
0x000000018a8a4812ULL, 0x000fc600078efcffULL, 0x0000007f00c47306ULL, 0x000e620000005400ULL,
0x000000939200720bULL, 0x004fce0003fdd000ULL, 0x0000007f00067306ULL, 0x0004ec000000d400ULL,
0x0000000194946812ULL, 0x000fe400078efcffULL, 0x00000098007a7306ULL, 0x000fe20000209400ULL,
0x000000ad007f7245ULL, 0x004fe4000020d400ULL, 0x000000c4c300720bULL, 0x002fc40003f9d000ULL,
0x000000017f7f5812ULL, 0x000fe400078efcffULL, 0x000000bcbb00720bULL, 0x000fe20003fbd000ULL,
0x0000009800977306ULL, 0x000e620000205400ULL, 0x000000219494723eULL, 0x000fe400000010ffULL,
0x0000007fb07f723eULL, 0x000fca00000010ffULL, 0x0000008900bf7306ULL, 0x000fe20000209400ULL,
0x0000000106064812ULL, 0x008fe200078efcffULL, 0x0000007e6858723cULL, 0x000b640000041858ULL,
0x0000000188885812ULL, 0x000fc800078efcffULL, 0x0000008900c07306ULL, 0x0004e20000205400ULL,
0x000000977a00720bULL, 0x002fe20003f7d000ULL, 0x0000007e7038723cULL, 0x000b620000041838ULL,
0x0000008ab57a723eULL, 0x000fe400000010ffULL, 0x000000887b7b723eULL, 0x000fc600000010ffULL,
0x0000000000847306ULL, 0x000fe20000209400ULL, 0x0000008900897245ULL, 0x004fc6000020d400ULL,
0x0000007a685c723cULL, 0x000b68000004185cULL, 0x0000000000857306ULL, 0x0002a20000205400ULL,
0x000000c0bf00720bULL, 0x008fc60003fbd000ULL, 0x0000007a703c723cULL, 0x000b68000004183cULL,
0x0000000200867306ULL, 0x000fe20000209400ULL, 0x0000000000007245ULL, 0x002fca000020d400ULL,
0x0000000189895812ULL, 0x000fe400078efcffULL, 0x0000000200877306ULL, 0x0002e20000205400ULL,
0x000000858400720bULL, 0x004fe40003fdd000ULL, 0x0000009800857245ULL, 0x000fe4000020d400ULL,
0x0000008e897d723eULL, 0x000fe400000010ffULL, 0x0000000185853812ULL, 0x000fe200078efcffULL,
0x0000008d00957306ULL, 0x000fe20000209400ULL, 0x0000000200027245ULL, 0x002fc6000020d400ULL,
0x0000007c6860723cULL, 0x000b640000041860ULL, 0x0000000100006812ULL, 0x000fe400078efcffULL,
0x0000008d00907306ULL, 0x0002a20000205400ULL, 0x000000878600720bULL, 0x008fc60003fbd000ULL,
0x0000007c7040723cULL, 0x000b680000041840ULL, 0x00000099008f7306ULL, 0x000fe20000209400ULL,
0x0000008d008d7245ULL, 0x002fca000020d400ULL, 0x0000000102025812ULL, 0x000fe400078efcffULL,
0x00000099008a7306ULL, 0x000e620000205400ULL, 0x000000909500720bULL, 0x004fe40003f1d000ULL,
0x000000068595723eULL, 0x000fe400000010ffULL, 0x0000009900857245ULL, 0x000fca000020d400ULL,
0x000000946864723cULL, 0x080b680000041864ULL, 0x000000018d8d0812ULL, 0x000fe400078efcffULL,
0x0000008a8f00720bULL, 0x002fe40003f7d000ULL, 0x0000008d0284723eULL, 0x000fe200000010ffULL,
0x000000947044723cULL, 0x000b740000041844ULL, 0x0000000185853812ULL, 0x000fc800078efcffULL,
0x000000850085723eULL, 0x000fe200000010ffULL, 0x000000021f007824ULL, 0x000fca00078e00ffULL,
0xfffffff800027812ULL, 0x000fe200078ec0ffULL, 0x000000847048723cULL, 0x080b700000041848ULL,
0x000000846868723cULL, 0x000b620000041828ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x00000000132a7f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126980002ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff007224ULL, 0x000fc600078e00ffULL, 0x0000000000087805ULL, 0x000fc80000015200ULL,
0x0000040013217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x006fc4000780482bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002808217210ULL, 0x000fca0007f1e1ffULL, 0x0000000129287824ULL, 0x000fe200000e0e09ULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x008fc80000011428ULL, 0x0000002102027211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0628ULL, 0x0000000202027819ULL, 0x000fc80000001221ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000100007810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040013217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000114097810ULL, 0x000fc80007ffe0ffULL,
0x0000001a0900720cULL, 0x000fda0003f06070ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x0000000214097810ULL, 0x000fe20007ffe0ffULL, 0x0000590024027a24ULL, 0x018fe200078e02ffULL,
0x0000010027277810ULL, 0x000fe40007ffe0ffULL, 0x0000001a0900720cULL, 0x000fe20003f06070ULL,
0x0000008002067824ULL, 0x000fe200078e00ffULL, 0x0000006027007812ULL, 0x000fca00078ec0ffULL,
0x0000000117027824ULL, 0x000fcc00078e0200ULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x000000271c007217ULL, 0x000fe20007800000ULL, 0x000000101f087824ULL, 0x000fe200078e00ffULL,
0x00000003ff287819ULL, 0x000fe4000001161dULL, 0x0000640006217a11ULL, 0x000fe200078038ffULL,
0x0000000100007824ULL, 0x000fe200078e0a27ULL, 0x00000010082b7812ULL, 0x000fe400078ec0ffULL,
0x0000000428097810ULL, 0x040fe40007ffe0ffULL, 0x000000002b007217ULL, 0x000fe20007800000ULL,
0x0000000128297824ULL, 0x100fe200078e022bULL, 0x0000650006277a11ULL, 0x000fe200000f3cffULL,
0x00000001096d7824ULL, 0x100fe200078e022bULL, 0x0000000828067810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a2bULL, 0x0000000c286c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000129087824ULL, 0x000fc400078e0202ULL, 0x0000000106707824ULL, 0x000fe200078e022bULL,
0x000000000900720cULL, 0x080fe20003f86070ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000002800720cULL, 0x080fe40003fa6070ULL, 0x000000000600720cULL, 0x000fe20003f66070ULL,
0x000000016d287824ULL, 0x000fe200078e0202ULL, 0x00000012082a7212ULL, 0x000fe200078efcffULL,
0x0000000129067824ULL, 0x040fe200078e021dULL, 0x000000006c00720cULL, 0x000fe20003f06070ULL,
0x0000000829717824ULL, 0x000fe200078e00ffULL, 0x0000002a212a7210ULL, 0x000fe20007fde0ffULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff871067812ULL, 0x000fe200078ee206ULL,
0x000000016c727824ULL, 0x000fe200078e022bULL, 0x00000012286c7212ULL, 0x000fe200078efcffULL,
0x0000000170087824ULL, 0x000fe400078e0202ULL, 0x000000016d007824ULL, 0x000fe400078e021dULL,
0x00000001092b7824ULL, 0x000fe200030e0627ULL, 0x000000216c6c7210ULL, 0x000fe20007fde0ffULL,
0x000000086d6d7824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff86d007812ULL, 0x000fe200078ee200ULL, 0x0000000172287824ULL, 0x000fe200078e0202ULL,
0x0000001208087212ULL, 0x000fe200078efcffULL, 0x00000001296d7824ULL, 0x000fe400030e0627ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000002108087210ULL, 0x000fc60007fde0ffULL,
0x0000000170717824ULL, 0x100fe200078e021dULL, 0x0000001228027212ULL, 0x000fe200078efcffULL,
0x0000000870787824ULL, 0x000fe400078e00ffULL, 0x0000000172707824ULL, 0x040fe400078e021dULL,
0x0000000872737824ULL, 0x000fe200078e00ffULL, 0xfffffff878287812ULL, 0x000fe200078ee271ULL,
0x0000000109097824ULL, 0x000fe200030e0627ULL, 0x0000002102027210ULL, 0x000fe20007fde0ffULL,
0x0000001006217824ULL, 0x100fe200078e0203ULL, 0xfffffff873707812ULL, 0x000fe200078ee270ULL,
0x0000001000717824ULL, 0x000fc400078e0203ULL, 0x0000001028737824ULL, 0x100fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a217faeULL, 0x0003e2000e901c46ULL,
0x0000001070797824ULL, 0x000fe400078e0203ULL, 0x0000000129037824ULL, 0x000fe200030e0627ULL,
0x000000006c717faeULL, 0x0003e8000e101c46ULL, 0x0000000008737faeULL, 0x0003e8000d901c46ULL,
0x0000000002797faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x000000101f007824ULL, 0x000fca00078e00ffULL, 0x0000001000007812ULL, 0x000fc800078ec0ffULL,
0x000000001d007211ULL, 0x000fc800078fe8ffULL, 0x0000000400217810ULL, 0x040fe20007ffe0ffULL,
0x0000000100097824ULL, 0x040fe200078e021dULL, 0x0000000c00277810ULL, 0x040fe20007ffe0ffULL,
0x0000000800707824ULL, 0x040fe400078e00ffULL, 0x0000000100087824ULL, 0x100fe400078e0202ULL,
0x0000000121287824ULL, 0x040fe200078e0202ULL, 0xfffffff870707812ULL, 0x000fe200078ee209ULL,
0x0000000821297824ULL, 0x040fe200078e00ffULL, 0x0000000800097810ULL, 0x000fe20007ffe0ffULL,
0x0000000121007824ULL, 0x000fc400078e021dULL, 0x00000001276c7824ULL, 0x100fe400078e0202ULL,
0x00000001092a7824ULL, 0x000fe200078e0202ULL, 0xfffffff829007812ULL, 0x000fe200078ee200ULL,
0x0000000127217824ULL, 0x140fe400078e021dULL, 0x0000000827787824ULL, 0x000fe400078e00ffULL,
0x0000000109027824ULL, 0x040fe400078e021dULL, 0x00000008092b7824ULL, 0x000fe200078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee221ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000640006217a11ULL, 0x000fc400078038ffULL, 0xfffffff82b727812ULL, 0x000fe200078ee202ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000001208087212ULL, 0x000fe400078efcffULL,
0x0000650006277a11ULL, 0x000fe200000f3cffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000000821087210ULL, 0x000fe40007f1e0ffULL, 0x0000001228027212ULL, 0x080fe200078efcffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x000000122a287212ULL, 0x000fc600078efcffULL,
0x0000000109097824ULL, 0x000fe200000e0627ULL, 0x000000126c2a7212ULL, 0x000fe200078efcffULL,
0x0000001000717824ULL, 0x100fe200078e0203ULL, 0x0000000221027210ULL, 0x040fe20007f1e0ffULL,
0x0000001072737824ULL, 0x100fe200078e0203ULL, 0x0000002821287210ULL, 0x040fe20007f7e0ffULL,
0x0000001078797824ULL, 0x100fe200078e0203ULL, 0x0000002a212a7210ULL, 0x000fe20007f9e0ffULL,
0x0000001070217824ULL, 0x000fe400078e0203ULL, 0x0000000129037824ULL, 0x000fc400000e0627ULL,
0x000000012b297824ULL, 0x100fe200018e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008217faeULL, 0x0003e2000b901c46ULL, 0x000000016d2b7824ULL, 0x000fc600020e0627ULL,
0x0000000002717faeULL, 0x0003e8000b901c46ULL, 0x0000000028737faeULL, 0x0003e8000b901c46ULL,
0x000000002a797faeULL, 0x0003e4000b901c46ULL, 0x000000081f007824ULL, 0x000fe400078e00ffULL,
0x0000000215067824ULL, 0x000fc600078e0275ULL, 0x0000000800037812ULL, 0x002fe400078ec0ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000001006067824ULL, 0x000fe200078e0003ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000010027f8cULL, 0x0082a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126680006287f8cULL, 0x000662000c80043fULL,
0x000000ffff007224ULL, 0x004fc600078e0003ULL, 0x0000000000027805ULL, 0x000fc80000015200ULL,
0x01266c0006097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x006fc40007804829ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000802217210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e03ULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000002108087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01266c0006097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018015037811ULL, 0x000fc800078e38ffULL, 0x0000000374037210ULL, 0x000fca0007ffe012ULL,
0x0120000003067984ULL, 0x008e680000000800ULL, 0x0122000003087984ULL, 0x0004e20000000800ULL,
0x000000230600720bULL, 0x002fe20003f1d000ULL, 0x0000e6227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000037806ULL, 0x004fc800000e0100ULL, 0x000000ff0300720cULL, 0x000fe20003f05270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x00000001ff107424ULL, 0x000fe400078e00ffULL,
0x000000ffff027224ULL, 0x000fd200078e0023ULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x0000000315027810ULL, 0x000fe40007ffe0ffULL, 0x000000230600720bULL, 0x000fe40003f74000ULL,
0x0000001f0200720cULL, 0x000fe20003f05270ULL, 0x0000e5d27f007947ULL, 0x000fd4000b800000ULL,
0x00000000006c7806ULL, 0x000fc400018e0100ULL, 0x000000801f098824ULL, 0x000fe200078e0212ULL,
0x0000002306027209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000174098824ULL, 0x000fca00078e0209ULL, 0x0124000209008388ULL, 0x0003e20000000800ULL,
0x000000ff6c00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000002302097221ULL, 0x002fe20000010100ULL, 0x000000ff6cff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b09097820ULL, 0x000fcc0000410000ULL,
0x0000000900097308ULL, 0x000e640000000800ULL, 0x0000000922227220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe2000001161dULL,
0x0000e5127f007947ULL, 0x000fea000b800000ULL, 0x00001f2909297589ULL, 0x0002a400000e0000ULL,
0x000000292c2c7220ULL, 0x084fe20000410000ULL, 0x000000292d2d7220ULL, 0x080fe20000410000ULL,
0x0000002930307220ULL, 0x080fe20000410000ULL, 0x0000002931317220ULL, 0x080fe20000410000ULL,
0x0000002934347220ULL, 0x080fe20000410000ULL, 0x0000002935357220ULL, 0x080fe20000410000ULL,
0x0000002938387220ULL, 0x080fe20000410000ULL, 0x0000002939397220ULL, 0x080fe20000410000ULL,
0x000000293c3c7220ULL, 0x080fe20000410000ULL, 0x000000293d3d7220ULL, 0x080fe20000410000ULL,
0x0000002940407220ULL, 0x080fe20000410000ULL, 0x0000002941417220ULL, 0x080fe20000410000ULL,
0x0000002944447220ULL, 0x080fe20000410000ULL, 0x0000002945457220ULL, 0x080fe20000410000ULL,
0x0000002948487220ULL, 0x080fe20000410000ULL, 0x0000002949497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff006cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000081d297811ULL, 0x000fe200078ff0ffULL, 0x0000e3e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2909297589ULL, 0x00046400000e0000ULL, 0x000000292e2e7220ULL, 0x086fe20000410000ULL,
0x000000292f2f7220ULL, 0x080fe20000410000ULL, 0x0000002932327220ULL, 0x080fe20000410000ULL,
0x0000002933337220ULL, 0x080fe20000410000ULL, 0x0000002936367220ULL, 0x080fe20000410000ULL,
0x0000002937377220ULL, 0x080fe20000410000ULL, 0x000000293a3a7220ULL, 0x080fe20000410000ULL,
0x000000293b3b7220ULL, 0x080fe20000410000ULL, 0x000000293e3e7220ULL, 0x080fe20000410000ULL,
0x000000293f3f7220ULL, 0x080fe20000410000ULL, 0x0000002942427220ULL, 0x080fe20000410000ULL,
0x0000002943437220ULL, 0x080fe20000410000ULL, 0x0000002946467220ULL, 0x080fe20000410000ULL,
0x0000002947477220ULL, 0x080fe20000410000ULL, 0x000000294a4a7220ULL, 0x080fe20000410000ULL,
0x000000294b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00006cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000101d297811ULL, 0x000fe200078ff0ffULL,
0x0000e2b27f007947ULL, 0x000fea000b800000ULL, 0x00001f2909297589ULL, 0x00046400000e0000ULL,
0x000000294c4c7220ULL, 0x086fe20000410000ULL, 0x000000294d4d7220ULL, 0x080fe20000410000ULL,
0x0000002950507220ULL, 0x080fe20000410000ULL, 0x0000002951517220ULL, 0x080fe20000410000ULL,
0x0000002954547220ULL, 0x080fe20000410000ULL, 0x0000002955557220ULL, 0x080fe20000410000ULL,
0x0000002958587220ULL, 0x080fe20000410000ULL, 0x0000002959597220ULL, 0x080fe20000410000ULL,
0x000000295c5c7220ULL, 0x080fe20000410000ULL, 0x000000295d5d7220ULL, 0x080fe20000410000ULL,
0x0000002960607220ULL, 0x080fe20000410000ULL, 0x0000002961617220ULL, 0x080fe20000410000ULL,
0x0000002964647220ULL, 0x080fe20000410000ULL, 0x0000002965657220ULL, 0x080fe20000410000ULL,
0x0000002968687220ULL, 0x080fe20000410000ULL, 0x0000002969697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000006cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000181d297811ULL, 0x000fe200078ff0ffULL,
0x0000e1927f007947ULL, 0x000fea000b800000ULL, 0x00001f2909297589ULL, 0x00046400000e0000ULL,
0x000000294e4e7220ULL, 0x086fe20000410000ULL, 0x000000294f4f7220ULL, 0x080fe20000410000ULL,
0x0000002952527220ULL, 0x080fe20000410000ULL, 0x0000002953537220ULL, 0x080fe20000410000ULL,
0x0000002956567220ULL, 0x080fe20000410000ULL, 0x0000002957577220ULL, 0x080fe20000410000ULL,
0x000000295a5a7220ULL, 0x080fe20000410000ULL, 0x000000295b5b7220ULL, 0x080fe20000410000ULL,
0x000000295e5e7220ULL, 0x080fe20000410000ULL, 0x000000295f5f7220ULL, 0x080fe20000410000ULL,
0x0000002962627220ULL, 0x080fe20000410000ULL, 0x0000002963637220ULL, 0x080fe20000410000ULL,
0x0000002966667220ULL, 0x080fe20000410000ULL, 0x0000002967677220ULL, 0x080fe20000410000ULL,
0x000000296a6a7220ULL, 0x080fe20000410000ULL, 0x000000296b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000006c03ff7212ULL, 0x000fda00078030ffULL,
0x0000000602060221ULL, 0x000fe20000010100ULL, 0x00007610ff100816ULL, 0x000fc60000000010ULL,
0x3fb8aa3b06060820ULL, 0x000fc80000410000ULL, 0x0000000600110308ULL, 0x000e640000000800ULL,
0x0000001108080220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002208227221ULL, 0x008fc40000010000ULL, 0x0000000000087805ULL, 0x000fca0000015200ULL,
0x000000081f037824ULL, 0x000fca00078e00ffULL, 0xfffffff003127812ULL, 0x000fca00078ec0ffULL,
0x0126b40012037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002808067210ULL, 0x000fca0007f1e1ffULL,
0x0000000129287824ULL, 0x000fe200000e0e09ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011428ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0628ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000121217810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b40012037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991010037816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff03723eULL, 0x000fe400000010ffULL, 0x00000002ff067819ULL, 0x000fe4000001161dULL,
0x0000541003037816ULL, 0x000fe20000000003ULL, 0x0000dd627f007947ULL, 0x000fea000b800000ULL,
0x00001f06030f7589ULL, 0x0002a400000e0000ULL, 0x0000000806297810ULL, 0x000fe20007ffe0ffULL,
0x0000dd927f007947ULL, 0x000fea000b800000ULL, 0x0000001006087810ULL, 0x000fe20007ffe0ffULL,
0x00001f29030e7589ULL, 0x00066800000e0000ULL, 0x00001f08030d7589ULL, 0x0006a400000e0000ULL,
0x0000001806297810ULL, 0x008fe20007ffe0ffULL, 0x0000dde27f007947ULL, 0x000fea000b800000ULL,
0x00001f29030c7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff067819ULL, 0x002fe2000001161dULL, 0x000000080b097824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000041f087824ULL, 0x000fe200078e00ffULL,
0x000001b000007945ULL, 0x000fe20003800000ULL, 0x0000000475037824ULL, 0x008fc400078e0206ULL,
0x000000080a107824ULL, 0x000fe200078e00ffULL, 0x0000000408087812ULL, 0x000fe200078ec0ffULL,
0x000000010b067824ULL, 0x100fe400078e0203ULL, 0x000000010a037824ULL, 0x000fe200078e0203ULL,
0x0000000208087812ULL, 0x000fe200078efcffULL, 0x0000001007787824ULL, 0x000fe200078e0225ULL,
0xfffffff809097812ULL, 0x000fe400078ee206ULL, 0x0000d00015067811ULL, 0x000fe400078e60ffULL,
0xfffffff810217812ULL, 0x000fc400078ee203ULL, 0x000000081d037211ULL, 0x000fe200078fe0ffULL,
0x0000001009097824ULL, 0x100fe400078e0206ULL, 0x0000001021217824ULL, 0x000fe400078e0206ULL,
0x000000080b087824ULL, 0x040fe200078e00ffULL, 0x00000000096c783bULL, 0x0002e20000000200ULL,
0x000000010b0b7824ULL, 0x000fc600078e0203ULL, 0x000000002128783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f6c6c7231ULL, 0x08cfe400003400ffULL,
0x0000000f6e6e7231ULL, 0x000fe400003400ffULL, 0x0000000e6d6d7231ULL, 0x080fe400003400ffULL,
0x0000000e6f6f7231ULL, 0x000fe400003400ffULL, 0x0000000d28287231ULL, 0x080fe400003400ffULL,
0x0000000d2a2a7231ULL, 0x000fc400003400ffULL, 0x0000000c29297231ULL, 0x080fe400003400ffULL,
0x0000000c2b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007878783bULL, 0x000e620000004200ULL, 0xfffffff808087812ULL, 0x000fe200078ee20bULL,
0x0000001004047824ULL, 0x000fe200078e0206ULL, 0x00000fa000007945ULL, 0x000fe20003800000ULL,
0x000000010a037824ULL, 0x000fe400078e0203ULL, 0x0000001008087824ULL, 0x000fca00078e0225ULL,
0x000000000870783bULL, 0x000ee20000004200ULL, 0x0000010078827824ULL, 0x002fe200078e00ffULL,
0x00000078007e7306ULL, 0x000fe20000009400ULL, 0x0000010079857824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe20000011478ULL, 0x000001007b9b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x000001007a987824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe40000011485ULL, 0x0000008200837306ULL, 0x000fe20000209400ULL,
0x00000018ff927819ULL, 0x000fe20000011479ULL, 0x0000010070ad7824ULL, 0x008fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fc4000001149bULL, 0x00000018ff9d7819ULL, 0x000fe4000001147aULL,
0x00000018ffa87819ULL, 0x000fe2000001147bULL, 0x0000008200847306ULL, 0x0002e20000205400ULL,
0x00000018ff987819ULL, 0x000fe40000011498ULL, 0x00000018ffad7819ULL, 0x000fe400000114adULL,
0x00000018ffaf7819ULL, 0x000fe40000011470ULL, 0x00000018ffb47819ULL, 0x000fe20000011471ULL,
0x00000078007f7306ULL, 0x000ea20000005400ULL, 0x0000008200827245ULL, 0x002fc4000020d400ULL,
0x00000018ff0b7819ULL, 0x000fe40000011472ULL, 0x00000018ff097819ULL, 0x000fc60000011473ULL,
0x0000007800817306ULL, 0x0002a2000000d400ULL, 0x000000848300720bULL, 0x008fce0003fdd000ULL,
0x0000008d008e7306ULL, 0x000fe20000209400ULL, 0x0001000078787824ULL, 0x002fe200078e00ffULL,
0x0000007f7e00720bULL, 0x004fe20003fbd000ULL, 0x00000100717e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000008d008f7306ULL, 0x0002a20000205400ULL,
0x0000000182826812ULL, 0x000fcc00078efcffULL, 0x0000000181815812ULL, 0x000fe200078efcffULL,
0x00000079008a7306ULL, 0x000fe20000009400ULL, 0x0000008d008d7245ULL, 0x002fce000020d400ULL,
0x00000079008b7306ULL, 0x000e620000005400ULL, 0x0000008f8e00720bULL, 0x004fe40003f7d000ULL,
0x00000018ff8e7819ULL, 0x000fca000001147eULL, 0x00000079008c7306ULL, 0x0004ec000000d400ULL,
0x000000018d8d3812ULL, 0x000fe400078efcffULL, 0x0000007800857306ULL, 0x000fe20000209400ULL,
0x0001000079797824ULL, 0x004fe200078e00ffULL, 0x0000008b8a00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000007800867306ULL, 0x0002ae0000205400ULL,
0x000000018c8c4812ULL, 0x008fe200078efcffULL, 0x0000007900907306ULL, 0x000fe20000209400ULL,
0x0000007800787245ULL, 0x002fce000020d400ULL, 0x0000007900917306ULL, 0x0002e20000205400ULL,
0x000000868500720bULL, 0x004fce0003fdd000ULL, 0x0000007a00957306ULL, 0x000fe20000009400ULL,
0x0000007900797245ULL, 0x002fca000020d400ULL, 0x0000000178786812ULL, 0x000fe400078efcffULL,
0x0000007a00967306ULL, 0x000e620000005400ULL, 0x000000919000720bULL, 0x008fce0003f7d000ULL,
0x0000008700887306ULL, 0x000fec0000209400ULL, 0x0000000179793812ULL, 0x000fe400078efcffULL,
0x0000008700897306ULL, 0x0004e20000205400ULL, 0x000000969500720bULL, 0x002fce0003fdd000ULL,
0x0000009200937306ULL, 0x000fe20000209400ULL, 0x0000008700877245ULL, 0x004fce000020d400ULL,
0x0000009200947306ULL, 0x0002a20000205400ULL, 0x000000898800720bULL, 0x008fce0003fbd000ULL,
0x000000a300a47306ULL, 0x000fe20000209400ULL, 0x0000009200927245ULL, 0x002fca000020d400ULL,
0x0000000187875812ULL, 0x000fe400078efcffULL, 0x000000a300a57306ULL, 0x0002e20000205400ULL,
0x000000949300720bULL, 0x004fe20003f9d000ULL, 0x0001000073937824ULL, 0x000fca00078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011493ULL, 0x0000007b00a07306ULL, 0x000fe20000009400ULL,
0x000000a300a37245ULL, 0x002fca000020d400ULL, 0x0000000192924812ULL, 0x000fe400078efcffULL,
0x0000007b00a17306ULL, 0x000e620000005400ULL, 0x000000a5a400720bULL, 0x008fce0003f7d000ULL,
0x0000007b00a27306ULL, 0x0005ec000000d400ULL, 0x00000001a3a33812ULL, 0x000fe400078efcffULL,
0x0000007a00977306ULL, 0x0006e2000000d400ULL, 0x000100007b7b7824ULL, 0x004fe200078e00ffULL,
0x000000a1a000720bULL, 0x002fc80003f9d000ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x0000009d009e7306ULL, 0x000fe20000209400ULL, 0x000100007a7a7824ULL, 0x008fca00078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000009d009f7306ULL, 0x0002a20000205400ULL,
0x0000000197976812ULL, 0x000fe400078efcffULL, 0x00000001a2a24812ULL, 0x000fca00078efcffULL,
0x0000009800997306ULL, 0x000fe20000209400ULL, 0x0000009d009d7245ULL, 0x002fce000020d400ULL,
0x00000098009a7306ULL, 0x0002e20000205400ULL, 0x0000009f9e00720bULL, 0x004fce0003fdd000ULL,
0x0000007b00a67306ULL, 0x000fe20000209400ULL, 0x0000009800987245ULL, 0x002fca000020d400ULL,
0x000000019d9d6812ULL, 0x000fe400078efcffULL, 0x0000007b00a77306ULL, 0x0002a20000205400ULL,
0x0000009a9900720bULL, 0x008fce0003fbd000ULL, 0x000000ad00ae7306ULL, 0x000fe20000209400ULL,
0x0000007b007b7245ULL, 0x002fca000020d400ULL, 0x0000000198985812ULL, 0x000fe400078efcffULL,
0x000000ad007f7306ULL, 0x000e620000205400ULL, 0x000000a7a600720bULL, 0x004fce0003f7d000ULL,
0x000000a800a97306ULL, 0x000fec0000209400ULL, 0x000000017b7b3812ULL, 0x000fe400078efcffULL,
0x000000a800aa7306ULL, 0x0004e20000205400ULL, 0x0000007fae00720bULL, 0x002fe40003fdd000ULL,
0x0000008e007f7245ULL, 0x000fca000020d400ULL, 0x0000007a009b7306ULL, 0x000fe20000209400ULL,
0x000000a800a87245ULL, 0x004fce000020d400ULL, 0x0000007a009c7306ULL, 0x0002a20000205400ULL,
0x000000aaa900720bULL, 0x008fce0003f9d000ULL, 0x0000007000ab7306ULL, 0x000fe20000009400ULL,
0x0000007a007a7245ULL, 0x002fca000020d400ULL, 0x00000001a8a84812ULL, 0x000fe400078efcffULL,
0x0000007000ac7306ULL, 0x000e620000005400ULL, 0x0000009c9b00720bULL, 0x004fe40003fbd000ULL,
0x0000007ba87b723eULL, 0x000fca00000010ffULL, 0x0000007000237306ULL, 0x0004ec000000d400ULL,
0x000000017a7a5812ULL, 0x000fe400078efcffULL, 0x0000008e007e7306ULL, 0x000fe20000209400ULL,
0x0001000070707824ULL, 0x004fe200078e00ffULL, 0x000000acab00720bULL, 0x002fc40003fbd000ULL,
0x0000007a9d7a723eULL, 0x000fe400000010ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000008e00857306ULL, 0x000e660000205400ULL, 0x0000007a6c38723cULL, 0x080b680000041838ULL,
0x0000000123235812ULL, 0x008fe200078efcffULL, 0x0000007000837306ULL, 0x000fe60000209400ULL,
0x0000007a2858723cULL, 0x000b6a0000041858ULL, 0x0000007000847306ULL, 0x000ea20000205400ULL,
0x000000857e00720bULL, 0x002fc40003f7d000ULL, 0x000000ad007e7245ULL, 0x000fc8000020d400ULL,
0x000000017e7e6812ULL, 0x000fe200078efcffULL, 0x0000007100b27306ULL, 0x000fe60000009400ULL,
0x000000237e7e723eULL, 0x000fc600000010ffULL, 0x000000017f7f3812ULL, 0x000fe400078efcffULL,
0x0000007100b37306ULL, 0x000e620000005400ULL, 0x000000848300720bULL, 0x004fe40003fdd000ULL,
0x0000007000837245ULL, 0x000fe4000020d400ULL, 0x000000818270723eULL, 0x000fe400000010ffULL,
0x000000af00827245ULL, 0x000fe2000020d400ULL, 0x0000007100127306ULL, 0x0004e2000000d400ULL,
0x000000b400817245ULL, 0x000fca000020d400ULL, 0x0000000183836812ULL, 0x000fe400078efcffULL,
0x000000af00b07306ULL, 0x000fe20000209400ULL, 0x0001000071717824ULL, 0x004fe200078e00ffULL,
0x000000b3b200720bULL, 0x002fc80003f9d000ULL, 0x00000018ff867819ULL, 0x000fe20000011471ULL,
0x0000010072717824ULL, 0x000fe200078e00ffULL, 0x000000af00b17306ULL, 0x000e680000205400ULL,
0x00000018ff8a7819ULL, 0x000fe20000011471ULL, 0x0000010073717824ULL, 0x000fe400078e00ffULL,
0x0000000112124812ULL, 0x008fe200078efcffULL, 0x0000008600887306ULL, 0x000fe40000209400ULL,
0x00000018ff8f7819ULL, 0x000fc40000011471ULL, 0x0000008c8d71723eULL, 0x000fe400000010ffULL,
0x000000127f7f723eULL, 0x000fe400000010ffULL, 0x0000008600897306ULL, 0x0004e20000205400ULL,
0x000000b1b000720bULL, 0x002fe40003fbd000ULL, 0x000000706c2c723cULL, 0x000b6a000004182cULL,
0x000000b400b57306ULL, 0x000fe20000209400ULL, 0x0000008600867245ULL, 0x004fc4000020d400ULL,
0x0000007e6c3c723cULL, 0x000b66000004183cULL, 0x0000000182825812ULL, 0x000fe400078efcffULL,
0x000000b400b67306ULL, 0x000e620000205400ULL, 0x000000898800720bULL, 0x008fe40003fdd000ULL,
0x000000838282723eULL, 0x000fe200000010ffULL, 0x00000070284c723cULL, 0x040b68000004184cULL,
0x00000073007d7306ULL, 0x000fe80000009400ULL, 0x0000007e285c723cULL, 0x000b64000004185cULL,
0x0000000186866812ULL, 0x000fc400078efcffULL, 0x00000073007c7306ULL, 0x000ea20000005400ULL,
0x000000b6b500720bULL, 0x002fce0003f9d000ULL, 0x0000007200b77306ULL, 0x000fec0000009400ULL,
0x0000000181814812ULL, 0x000fe400078efcffULL, 0x0000007200b87306ULL, 0x000e620000005400ULL,
0x0000007c7d00720bULL, 0x004fe40003fdd000ULL, 0x000000868183723eULL, 0x000fca00000010ffULL,
0x0000008a008b7306ULL, 0x000fe40000209400ULL, 0x000000826c40723cULL, 0x080b6c0000041840ULL,
0x0000008a00907306ULL, 0x0004e20000205400ULL, 0x000000b8b700720bULL, 0x002fe20003f7d000ULL,
0x000000822860723cULL, 0x000b6c0000041860ULL, 0x0000008f00917306ULL, 0x000fe20000209400ULL,
0x0000008a008a7245ULL, 0x004fce000020d400ULL, 0x0000008f008e7306ULL, 0x000e620000205400ULL,
0x000000908b00720bULL, 0x008fe40003fbd000ULL, 0x0000008f008b7245ULL, 0x000fca000020d400ULL,
0x0000007200077306ULL, 0x0004ec000000d400ULL, 0x000000018a8a5812ULL, 0x000fe400078efcffULL,
0x0000007300087306ULL, 0x0006e2000000d400ULL, 0x0001000072727824ULL, 0x004fe200078e00ffULL,
0x0000008e9100720bULL, 0x002fc80003f9d000ULL, 0x00000018ff847819ULL, 0x000fe40000011472ULL,
0x000000788772723eULL, 0x000fe200000010ffULL, 0x0000000b00277306ULL, 0x000fe20000209400ULL,
0x0000000107073812ULL, 0x008fe400078efcffULL, 0x000000799273723eULL, 0x000fe400000010ffULL,
0x000000979878723eULL, 0x000fe400000010ffULL, 0x000000018b8b4812ULL, 0x000fe200078efcffULL,
0x0000000b00747306ULL, 0x0002a20000205400ULL, 0x0000000108086812ULL, 0x000fe200078efcffULL,
0x000000726c30723cULL, 0x000b620000041830ULL, 0x000000a2a379723eULL, 0x000fc400000010ffULL,
0x000000088b8b723eULL, 0x000fe400000010ffULL, 0x0000000900087245ULL, 0x000fe2000020d400ULL,
0x0000000900107306ULL, 0x000fe20000209400ULL, 0x0000000b000b7245ULL, 0x002fe2000020d400ULL,
0x000000786c34723cULL, 0x000b620000041834ULL, 0x000000078a8a723eULL, 0x000fca00000010ffULL,
0x0000000900217306ULL, 0x000e620000205400ULL, 0x000000742700720bULL, 0x004fe20003fbd000ULL,
0x0000008a6c44723cULL, 0x000b6c0000041844ULL, 0x0000008400857306ULL, 0x000fe40000209400ULL,
0x000000722850723cULL, 0x000b680000041850ULL, 0x000000010b0b5812ULL, 0x000fc400078efcffULL,
0x0000008400887306ULL, 0x0004e20000205400ULL, 0x000000211000720bULL, 0x002fe20003f7d000ULL,
0x000000080a107824ULL, 0x000fe200078e00ffULL, 0x000000782854723cULL, 0x040b6a0000041854ULL,
0x0000009300877306ULL, 0x000fe20000209400ULL, 0x0000008400847245ULL, 0x004fe4000020d400ULL,
0x0000008a2864723cULL, 0x000b660000041864ULL, 0x0000000108083812ULL, 0x000fc400078efcffULL,
0x00000093007c7306ULL, 0x000e620000205400ULL, 0x000000888500720bULL, 0x008fe40003f9d000ULL,
0x0000009300857245ULL, 0x000fd6000020d400ULL, 0x0000000184844812ULL, 0x000fe400078efcffULL,
0x0000007c8700720bULL, 0x002fe40003fdd000ULL, 0x000000840b84723eULL, 0x000fd600000010ffULL,
0x0000000185856812ULL, 0x000fc800078efcffULL, 0x000000850885723eULL, 0x000fe200000010ffULL,
0x0000001005087824ULL, 0x000fe400078e0206ULL, 0x000000000404783bULL, 0x000e680000000200ULL,
0x000000846c48723cULL, 0x080b620000041848ULL, 0x000000000808783bULL, 0x000eae0000000200ULL,
0x000000842868723cULL, 0x000b620000041868ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000f08087231ULL, 0x084fe400003400ffULL,
0x0000000f0a0a7231ULL, 0x000fc400003400ffULL, 0x0000000e09097231ULL, 0x080fe400003400ffULL,
0x0000000e0b0b7231ULL, 0x000fe400003400ffULL, 0x0000000d04047231ULL, 0x082fe400003400ffULL,
0x0000000d06067231ULL, 0x000fe400003400ffULL, 0x0000000c05057231ULL, 0x080fe400003400ffULL,
0x0000000c07077231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000002628783bULL, 0x020ee20000004200ULL, 0xfffffff810107812ULL, 0x000fca00078ee203ULL,
0x0000001010107824ULL, 0x000fca00078e0225ULL, 0x00000000106c783bULL, 0x000ea20000004200ULL,
0x0000010028267824ULL, 0x008fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe20000011428ULL,
0x0000002900817306ULL, 0x000fe20000009400ULL, 0x00000100297b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011429ULL, 0x000001002a8f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x000001002b927824ULL, 0x000fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe4000001147bULL, 0x0000002900827306ULL, 0x000ee20000005400ULL,
0x00000018ff8f7819ULL, 0x000fc4000001148fULL, 0x00000018ff9b7819ULL, 0x000fe40000011492ULL,
0x00000018ffa17819ULL, 0x000fe4000001142bULL, 0x00000018ff957819ULL, 0x000fe2000001142aULL,
0x0000007d007e7306ULL, 0x000fe20000209400ULL, 0x00000018ffa97819ULL, 0x004fe4000001146cULL,
0x00000018ffb07819ULL, 0x000fe4000001146dULL, 0x00000018ff217819ULL, 0x000fc4000001146eULL,
0x00000018ff037819ULL, 0x000fe2000001146fULL, 0x0000007d007f7306ULL, 0x0004620000205400ULL,
0x000000828100720bULL, 0x008fe20003fdd000ULL, 0x000001006f817824ULL, 0x000fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000002600797306ULL, 0x000fe20000209400ULL,
0x0000007d007d7245ULL, 0x004fce000020d400ULL, 0x00000026007a7306ULL, 0x000ea20000205400ULL,
0x0000007f7e00720bULL, 0x002fce0003fbd000ULL, 0x0000002800277306ULL, 0x000fec0000009400ULL,
0x000000017d7d5812ULL, 0x000fe400078efcffULL, 0x0000002800747306ULL, 0x000e620000005400ULL,
0x0000007a7900720bULL, 0x004fce0003f1d000ULL, 0x0000002800787306ULL, 0x0005f0000000d400ULL,
0x0000002900837306ULL, 0x0006e2000000d400ULL, 0x0001000028287824ULL, 0x004fe200078e00ffULL,
0x000000742700720bULL, 0x002fc40003f7d000ULL, 0x0000002600277245ULL, 0x000fe4000020d400ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000008400857306ULL, 0x000fe20000209400ULL,
0x0001000029297824ULL, 0x008fe200078e00ffULL, 0x0000000127270812ULL, 0x000fc800078efcffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000008400867306ULL, 0x0002a20000205400ULL,
0x0000000183836812ULL, 0x000fe400078efcffULL, 0x0000000178783812ULL, 0x000fca00078efcffULL,
0x00000028007b7306ULL, 0x000fe20000209400ULL, 0x0000008400847245ULL, 0x002fce000020d400ULL,
0x00000028007c7306ULL, 0x0002e20000205400ULL, 0x000000868500720bULL, 0x004fe20003f9d000ULL,
0x000100006f867824ULL, 0x000fca00078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x0000008f00907306ULL, 0x000fe20000209400ULL, 0x0000002800287245ULL, 0x002fca000020d400ULL,
0x0000000184844812ULL, 0x000fe400078efcffULL, 0x0000008f00917306ULL, 0x0002a20000205400ULL,
0x0000007c7b00720bULL, 0x008fce0003f1d000ULL, 0x0000009b009c7306ULL, 0x000fe20000209400ULL,
0x0000008f008f7245ULL, 0x002fca000020d400ULL, 0x0000000128280812ULL, 0x000fe400078efcffULL,
0x0000009b009d7306ULL, 0x000e620000205400ULL, 0x000000919000720bULL, 0x004fe40003fdd000ULL,
0x000000287d28723eULL, 0x000fca00000010ffULL, 0x0000002b00987306ULL, 0x000fec0000009400ULL,
0x000000018f8f6812ULL, 0x000fe400078efcffULL, 0x0000002b00997306ULL, 0x000fe20000005400ULL,
0x0000009d9c00720bULL, 0x002fce0003fbd000ULL, 0x0000002b009a7306ULL, 0x0003f0000000d400ULL,
0x0000002a008c7306ULL, 0x000fe20000009400ULL, 0x000100002b2b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe2000001142bULL, 0x000001006e2b7824ULL, 0x000fe200078e00ffULL,
0x0000002a008d7306ULL, 0x000e680000005400ULL, 0x00000018ff7a7819ULL, 0x000fe4000001142bULL,
0x0000009b002b7245ULL, 0x000fe4000020d400ULL, 0x0000002a008e7306ULL, 0x0004e4000000d400ULL,
0x000000012b2b5812ULL, 0x000fcc00078efcffULL, 0x00000089008a7306ULL, 0x000fe20000209400ULL,
0x000100002a2a7824ULL, 0x004fe200078e00ffULL, 0x0000008d8c00720bULL, 0x002fc80003f1d000ULL,
0x00000018ff927819ULL, 0x000fe2000001142aULL, 0x000001006c2a7824ULL, 0x000fe200078e00ffULL,
0x00000089008b7306ULL, 0x000e680000205400ULL, 0x00000018ffa67819ULL, 0x000fe2000001142aULL,
0x000001006d2a7824ULL, 0x040fe400078e00ffULL, 0x000000018e8e0812ULL, 0x008fe200078efcffULL,
0x0000009500967306ULL, 0x000fe40000209400ULL, 0x00000018ffae7819ULL, 0x000fe2000001142aULL,
0x000100006d2a7824ULL, 0x000fca00078e00ffULL, 0x0000009500977306ULL, 0x0004e20000205400ULL,
0x0000008b8a00720bULL, 0x002fe40003f7d000ULL, 0x00000018ff797819ULL, 0x000fe4000001142aULL,
0x00000089002a7245ULL, 0x000fc6000020d400ULL, 0x0000002900877306ULL, 0x000fe20000209400ULL,
0x0000009500957245ULL, 0x004fca000020d400ULL, 0x000000012a2a3812ULL, 0x000fe400078efcffULL,
0x0000002900887306ULL, 0x0002a20000205400ULL, 0x000000979600720bULL, 0x008fce0003fdd000ULL,
0x0000009e009f7306ULL, 0x000fe20000209400ULL, 0x0000002900297245ULL, 0x002fca000020d400ULL,
0x0000000195956812ULL, 0x000fe400078efcffULL, 0x0000009e00a07306ULL, 0x000e620000205400ULL,
0x000000888700720bULL, 0x004fce0003f9d000ULL, 0x0000009200937306ULL, 0x000fec0000209400ULL,
0x0000000129294812ULL, 0x000fe400078efcffULL, 0x0000009200947306ULL, 0x0004e20000205400ULL,
0x000000a09f00720bULL, 0x002fe40003fbd000ULL, 0x000000999800720bULL, 0x000fc40003f9d000ULL,
0x000000292a29723eULL, 0x000fe400000010ffULL, 0x0000008e8f2a723eULL, 0x000fe200000010ffULL,
0x0000006c00a47306ULL, 0x000fe20000009400ULL, 0x0000009200927245ULL, 0x004fc6000020d400ULL,
0x000000280830723cULL, 0x080b680000041830ULL, 0x0000006c00a57306ULL, 0x000e620000005400ULL,
0x000000949300720bULL, 0x008fe40003f7d000ULL, 0x0000009e00937245ULL, 0x000fe2000020d400ULL,
0x000000280450723cULL, 0x000b620000041850ULL, 0x000000019a9a4812ULL, 0x000fe400078efcffULL,
0x0000000193935812ULL, 0x000fe200078efcffULL, 0x0000006d00ac7306ULL, 0x000fe20000009400ULL,
0x0000009a2b2b723eULL, 0x000fca00000010ffULL, 0x0000000192923812ULL, 0x000fe400078efcffULL,
0x0000006d00ad7306ULL, 0x000ea20000005400ULL, 0x000000a5a400720bULL, 0x002fe20003f1d000ULL,
0x0000002a0834723cULL, 0x000b620000041834ULL, 0x000000929592723eULL, 0x000fca00000010ffULL,
0x000000ae00af7306ULL, 0x000fe40000209400ULL, 0x0000002a0454723cULL, 0x000b6c0000041854ULL,
0x000000ae00747306ULL, 0x0002e20000205400ULL, 0x000000adac00720bULL, 0x004fce0003fbd000ULL,
0x0000006c00257306ULL, 0x0004e2000000d400ULL, 0x000000ae00ae7245ULL, 0x002fce000020d400ULL,
0x0000006d00237306ULL, 0x000262000000d400ULL, 0x000100006c6c7824ULL, 0x004fe200078e00ffULL,
0x00000074af00720bULL, 0x008fcc0003fdd000ULL, 0x0000006e00b37306ULL, 0x000fe20000009400ULL,
0x00000018ff6d7819ULL, 0x002fe2000001146cULL, 0x000100006e6c7824ULL, 0x000fe200078e00ffULL,
0x0000000125250812ULL, 0x000fc800078efcffULL, 0x00000001aeae6812ULL, 0x000fe200078efcffULL,
0x0000006e00b47306ULL, 0x000fe20000005400ULL, 0x0000000123235812ULL, 0x000fe400078efcffULL,
0x00000018ff7e7819ULL, 0x000fe4000001146cULL, 0x000000a1006c7245ULL, 0x000fc6000020d400ULL,
0x0000006e00127306ULL, 0x000ff0000000d400ULL, 0x0000006f00b57306ULL, 0x000ff00000009400ULL,
0x0000006f00b67306ULL, 0x000ff00000005400ULL, 0x0000006f00107306ULL, 0x000ff0000000d400ULL,
0x000000a100a27306ULL, 0x000ff00000209400ULL, 0x000000a100a37306ULL, 0x000e700000205400ULL,
0x000000a900aa7306ULL, 0x000ff00000209400ULL, 0x000000a900ab7306ULL, 0x000ea20000205400ULL,
0x000000a3a200720bULL, 0x002fce0003f9d000ULL, 0x0000006d00267306ULL, 0x000fec0000209400ULL,
0x000000016c6c4812ULL, 0x000fe400078efcffULL, 0x0000006d006f7306ULL, 0x0002e20000205400ULL,
0x000000abaa00720bULL, 0x004fe40003f1d000ULL, 0x000000b4b300720bULL, 0x000fc40003f9d000ULL,
0x000000936c93723eULL, 0x000fc600000010ffULL, 0x00000079006e7306ULL, 0x000fe20000209400ULL,
0x0000006d006d7245ULL, 0x002fc6000020d400ULL, 0x000000920838723cULL, 0x080b680000041838ULL,
0x00000079007b7306ULL, 0x0002a20000205400ULL, 0x0000006f2600720bULL, 0x008fe40003fdd000ULL,
0x00000079006f7245ULL, 0x000fe2000020d400ULL, 0x000000920458723cULL, 0x000b620000041858ULL,
0x000000782726723eULL, 0x000fe400000010ffULL, 0x0000000112124812ULL, 0x000fe200078efcffULL,
0x000000a600a77306ULL, 0x000fe20000209400ULL, 0x0000007a00797245ULL, 0x002fc4000020d400ULL,
0x000000838427723eULL, 0x000fc600000010ffULL, 0x000000016d6d6812ULL, 0x000fe400078efcffULL,
0x000000a600a87306ULL, 0x0002e20000205400ULL, 0x0000007b6e00720bULL, 0x004fe20003fbd000ULL,
0x00000026082c723cULL, 0x000b62000004182cULL, 0x000000a9006e7245ULL, 0x000fc8000020d400ULL,
0x000000016e6e0812ULL, 0x000fe200078efcffULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x000000a600a67245ULL, 0x002fe2000020d400ULL, 0x00000026044c723cULL, 0x000b62000004184cULL,
0x0000006d6e6e723eULL, 0x000fc600000010ffULL, 0x000000016f6f5812ULL, 0x000fe400078efcffULL,
0x000000b000b27306ULL, 0x0002a20000205400ULL, 0x000000a8a700720bULL, 0x008fe40003f7d000ULL,
0x00000023aea7723eULL, 0x000fca00000010ffULL, 0x0000007a007c7306ULL, 0x000fe20000209400ULL,
0x000000b000b07245ULL, 0x002fca000020d400ULL, 0x00000001a6a63812ULL, 0x000fe400078efcffULL,
0x0000007a007f7306ULL, 0x000e620000205400ULL, 0x000000b2b100720bULL, 0x004fe40003fdd000ULL,
0x000000b6b500720bULL, 0x000fe40003f7d000ULL, 0x00000025a6a6723eULL, 0x000fc600000010ffULL,
0x0000008100827306ULL, 0x000fe80000209400ULL, 0x000000a6083c723cULL, 0x080b64000004183cULL,
0x00000001b0b06812ULL, 0x000fe400078efcffULL, 0x0000008100857306ULL, 0x0004e20000205400ULL,
0x0000007f7c00720bULL, 0x002fe40003f1d000ULL, 0x0000000110103812ULL, 0x000fe200078efcffULL,
0x000000a6045c723cULL, 0x000b62000004185cULL, 0x00000086007f7245ULL, 0x000fc4000020d400ULL,
0x0000006fb06f723eULL, 0x000fe200000010ffULL, 0x0000002100717306ULL, 0x000fe20000209400ULL,
0x0000008100817245ULL, 0x004fca000020d400ULL, 0x0000000179790812ULL, 0x000fe200078efcffULL,
0x0000006e0840723cULL, 0x000b620000041840ULL, 0x0000002100727306ULL, 0x0002a20000205400ULL,
0x000000858200720bULL, 0x008fe40003fbd000ULL, 0x00000012796c723eULL, 0x000fc800000010ffULL,
0x0000006e0460723cULL, 0x000b620000041860ULL, 0x0000000300737306ULL, 0x000fe20000209400ULL,
0x0000002100217245ULL, 0x002fca000020d400ULL, 0x0000000181815812ULL, 0x000fe400078efcffULL,
0x0000000300707306ULL, 0x000e620000205400ULL, 0x000000727100720bULL, 0x004fe40003fdd000ULL,
0x00000010816d723eULL, 0x000fe400000010ffULL, 0x0000000300107245ULL, 0x000fc6000020d400ULL,
0x0000007e00747306ULL, 0x000fe40000209400ULL, 0x0000006c0844723cULL, 0x080b680000041844ULL,
0x0000000121216812ULL, 0x000fe400078efcffULL, 0x0000007e007b7306ULL, 0x0004e20000205400ULL,
0x000000707300720bULL, 0x002fe20003f1d000ULL, 0x0000006c0464723cULL, 0x000b6c0000041864ULL,
0x0000008600787306ULL, 0x000fe20000209400ULL, 0x0000007e007e7245ULL, 0x004fca000020d400ULL,
0x0000000110100812ULL, 0x000fe400078efcffULL, 0x00000086007d7306ULL, 0x000e620000205400ULL,
0x0000007b7400720bULL, 0x008fda0003f9d000ULL, 0x000000017e7e4812ULL, 0x000fe400078efcffULL,
0x0000007d7800720bULL, 0x002fe40003fbd000ULL, 0x0000007e217e723eULL, 0x000fd600000010ffULL,
0x000000017f7f5812ULL, 0x000fc800078efcffULL, 0x0000007f107f723eULL, 0x000fce00000010ffULL,
0x0000007e0848723cULL, 0x080b700000041848ULL, 0x0000007e0468723cULL, 0x000b620000041868ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000013047f8cULL, 0x0202a2000c80043fULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x000126a015067811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000006ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff037224ULL, 0x004fe200078e0005ULL, 0x0000001000002944ULL, 0x000fe20003c00000ULL,
0xffff150000007947ULL, 0x000fea000383ffffULL, 0x000000ff1a00720cULL, 0x000fda0003f05270ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0180000022007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x000108a000047802ULL, 0x000fc40000000f00ULL, 0x0000bec000007944ULL, 0x01efea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002200037308ULL, 0x002e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000022ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006f00ff037624ULL, 0x000fe400078e00ffULL, 0x00006e00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000087919ULL, 0x000e680000000000ULL,
0x0000000000047919ULL, 0x000ea20000000000ULL, 0x0000001808057811ULL, 0x042fe400078ff0ffULL,
0x0000000808097811ULL, 0x000fc400078ff0ffULL, 0x00000002ff077819ULL, 0x004fe40000011604ULL,
0x00000010080b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003067220ULL, 0x008fca0000410000ULL,
0x00001f0706007589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea800000e0000ULL,
0x00001f0906047589ULL, 0x000ee800000e0000ULL, 0x00001f0b06027589ULL, 0x000ea200000e0000ULL,
0x0000002c002c7220ULL, 0x042fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000003400347220ULL, 0x040fe20000410000ULL, 0x0000003500357220ULL, 0x040fe20000410000ULL,
0x0000003800387220ULL, 0x040fe20000410000ULL, 0x0000003900397220ULL, 0x040fe20000410000ULL,
0x0000003c003c7220ULL, 0x040fe20000410000ULL, 0x0000003d003d7220ULL, 0x040fe20000410000ULL,
0x0000004000407220ULL, 0x040fe20000410000ULL, 0x0000004100417220ULL, 0x040fe20000410000ULL,
0x0000004400447220ULL, 0x040fe20000410000ULL, 0x0000004500457220ULL, 0x040fe20000410000ULL,
0x0000004800487220ULL, 0x040fe20000410000ULL, 0x0000004900497220ULL, 0x000fe20000410000ULL,
0x0000004e054e7220ULL, 0x044fe20000410000ULL, 0x0000004f054f7220ULL, 0x040fe20000410000ULL,
0x0000005205527220ULL, 0x040fe20000410000ULL, 0x0000005305537220ULL, 0x040fe20000410000ULL,
0x0000005605567220ULL, 0x040fe20000410000ULL, 0x0000005705577220ULL, 0x040fe20000410000ULL,
0x0000005a055a7220ULL, 0x040fe20000410000ULL, 0x0000005b055b7220ULL, 0x040fe20000410000ULL,
0x0000005e055e7220ULL, 0x040fe20000410000ULL, 0x0000005f055f7220ULL, 0x040fe20000410000ULL,
0x0000006205627220ULL, 0x040fe20000410000ULL, 0x0000006305637220ULL, 0x040fe20000410000ULL,
0x0000006605667220ULL, 0x040fe20000410000ULL, 0x0000006705677220ULL, 0x040fe20000410000ULL,
0x0000006a056a7220ULL, 0x040fe20000410000ULL, 0x0000006b056b7220ULL, 0x000fe20000410000ULL,
0x000000042e2e7220ULL, 0x088fe20000410000ULL, 0x000000042f2f7220ULL, 0x080fe20000410000ULL,
0x0000000432327220ULL, 0x080fe20000410000ULL, 0x0000000433337220ULL, 0x080fe20000410000ULL,
0x0000000436367220ULL, 0x080fe20000410000ULL, 0x0000000437377220ULL, 0x080fe20000410000ULL,
0x000000043a3a7220ULL, 0x080fe20000410000ULL, 0x000000043b3b7220ULL, 0x080fe20000410000ULL,
0x000000043e3e7220ULL, 0x080fe20000410000ULL, 0x000000043f3f7220ULL, 0x080fe20000410000ULL,
0x0000000442427220ULL, 0x080fe20000410000ULL, 0x0000000443437220ULL, 0x080fe20000410000ULL,
0x0000000446467220ULL, 0x080fe20000410000ULL, 0x0000000447477220ULL, 0x080fe20000410000ULL,
0x000000044a4a7220ULL, 0x080fe20000410000ULL, 0x000000044b4b7220ULL, 0x000fe20000410000ULL,
0x000000024c4c7220ULL, 0x080fe20000410000ULL, 0x000000024d4d7220ULL, 0x080fe20000410000ULL,
0x0000000250507220ULL, 0x080fe20000410000ULL, 0x0000000251517220ULL, 0x080fe20000410000ULL,
0x0000000254547220ULL, 0x080fe20000410000ULL, 0x0000000255557220ULL, 0x080fe20000410000ULL,
0x0000000258587220ULL, 0x080fe20000410000ULL, 0x0000000259597220ULL, 0x080fe20000410000ULL,
0x000000025c5c7220ULL, 0x080fe20000410000ULL, 0x000000025d5d7220ULL, 0x080fe20000410000ULL,
0x0000000260607220ULL, 0x080fe20000410000ULL, 0x0000000261617220ULL, 0x080fe20000410000ULL,
0x0000000264647220ULL, 0x080fe20000410000ULL, 0x0000000265657220ULL, 0x080fe20000410000ULL,
0x0000000268687220ULL, 0x080fe20000410000ULL, 0x0000000269697220ULL, 0x000fc20000410000ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x0000002e2f2e723eULL, 0x000fc400000010ffULL,
0x000000323317723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000363736723eULL, 0x000fe400000010ffULL, 0x0000003a3b1b723eULL, 0x000fe400000010ffULL,
0x0000003e3f3e723eULL, 0x000fc400000010ffULL, 0x000000424342723eULL, 0x000fe400000010ffULL,
0x000054102e167816ULL, 0x140fe40000000017ULL, 0x000076322e177816ULL, 0x000fe40000000017ULL,
0x00005410361a7816ULL, 0x000fe4000000001bULL, 0x0000000803057811ULL, 0x042fe200078ff0ffULL,
0x0000000180807824ULL, 0x000fe200078e0203ULL, 0x0000000203007812ULL, 0x000fc400078ec0ffULL,
0x0000001803097811ULL, 0x000fe200078ff0ffULL, 0x0000000805077824ULL, 0x004fe200078e00ffULL,
0x0000000500027211ULL, 0x040fe400078ff8ffULL, 0x0000001003057811ULL, 0x000fe200078ff0ffULL,
0x0000000809127824ULL, 0x000fe200078e00ffULL, 0xfffffff8070c7812ULL, 0x000fe400078ee202ULL,
0x00000002ff077819ULL, 0x000fe20000011603ULL, 0x00000008050b7824ULL, 0x000fe200078e00ffULL,
0x0000000500047211ULL, 0x000fc400078ff8ffULL, 0x0000000700027211ULL, 0x040fe200078ff8ffULL,
0x00000008070a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b107812ULL, 0x000fe200078ee204ULL,
0x000020001f047824ULL, 0x000fe200078e00ffULL, 0x0000000900057211ULL, 0x000fe200078ff8ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0x0000000202007810ULL, 0x000fe20007ffe0ffULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe400078ee205ULL,
0x0000200004057812ULL, 0x000fc400078ee2ffULL, 0xfffffff809067812ULL, 0x048fe400078ee200ULL,
0xfffffff809007812ULL, 0x000fe200078ee202ULL, 0x0000100018077824ULL, 0x100fe200078e0205ULL,
0x0000000402047810ULL, 0x000fe20007ffe0ffULL, 0x0000001080807824ULL, 0x000fe200078e0205ULL,
0x0000000602097810ULL, 0x000fe20007ffe0ffULL, 0x0000000803027824ULL, 0x000fe200078e00ffULL,
0xfffffff80b087812ULL, 0x000fe200078ee204ULL, 0x0000001000047824ULL, 0x000fe200078e0207ULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee209ULL, 0x000000100c0e7824ULL, 0x100fe200078e0207ULL,
0x0000000802097812ULL, 0x000fe200078ec0ffULL, 0x0000001010107824ULL, 0x100fe200078e0207ULL,
0x0000002c2d00723eULL, 0x000fe200000010ffULL, 0x0000001012127824ULL, 0x100fe200078e0207ULL,
0x000000303102723eULL, 0x000fe200000010ffULL, 0x0000001006067824ULL, 0x000fe200078e0207ULL,
0x00007632361b7816ULL, 0x000fe2000000001bULL, 0x0000001008087824ULL, 0x100fe200078e0207ULL,
0x0000541000147816ULL, 0x100fe20000000002ULL, 0x000000100a0c7824ULL, 0x000fe200078e0207ULL,
0x0000763200157816ULL, 0x000fe20000000002ULL, 0x0000000104077824ULL, 0x000fe200078e0209ULL,
0x000000343500723eULL, 0x000fe200000010ffULL, 0x00000001090a7824ULL, 0x000fe200078e0206ULL,
0x000000383902723eULL, 0x000fe200000010ffULL, 0x00000001090b7824ULL, 0x000fe200078e0208ULL,
0x0000001407007388ULL, 0x0003e20000000a00ULL, 0x0000003c3d04723eULL, 0x000fe200000010ffULL,
0x00000001090c7824ULL, 0x000fe200078e020cULL, 0x000000404106723eULL, 0x000fe200000010ffULL,
0x00000001090e7824ULL, 0x000fe200078e020eULL, 0x000000484908723eULL, 0x000fe200000010ffULL,
0x0000000109107824ULL, 0x000fe200078e0210ULL, 0x000000464746723eULL, 0x000fe200000010ffULL,
0x0000000109127824ULL, 0x000fe200078e0212ULL, 0x0000004a4b23723eULL, 0x000fc400000010ffULL,
0x0000004c4d4c723eULL, 0x000fe400000010ffULL, 0x0000541000147816ULL, 0x142fe40000000002ULL,
0x0000763200157816ULL, 0x000fe40000000002ULL, 0x000000444507723eULL, 0x000fe400000010ffULL,
0x000000505126723eULL, 0x000fe200000010ffULL, 0x000000140a007388ULL, 0x0003e20000000a00ULL,
0x000000545554723eULL, 0x000fc400000010ffULL, 0x00000058592a723eULL, 0x000fe400000010ffULL,
0x0000541046227816ULL, 0x140fe40000000023ULL, 0x0000763246237816ULL, 0x000fe40000000023ULL,
0x0000763254097816ULL, 0x000fe4000000002aULL, 0x0000005c5d5c723eULL, 0x000fe400000010ffULL,
0x0000541004147816ULL, 0x002fc40000000006ULL, 0x0000763204157816ULL, 0x000fe40000000006ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x000000140b007388ULL, 0x000fe20000000a00ULL, 0x0000541054087816ULL, 0x000fe4000000002aULL,
0x000000606160723eULL, 0x000fe200000010ffULL, 0x000000060c007388ULL, 0x0003e20000000a00ULL,
0x000000646564723eULL, 0x000fc400000010ffULL, 0x000000686932723eULL, 0x000fe200000010ffULL,
0x000000160e007388ULL, 0x000fe20000000a00ULL, 0x0000004e4f00723eULL, 0x000fe400000010ffULL,
0x000000525302723eULL, 0x000fe200000010ffULL, 0x0004001a0a007388ULL, 0x000fe20000000a00ULL,
0x000000565704723eULL, 0x000fe400000010ffULL, 0x000054103e067816ULL, 0x142fe40000000042ULL,
0x000076323e077816ULL, 0x000fca0000000042ULL, 0x000400060b007388ULL, 0x0003e80000000a00ULL,
0x000400220c007388ULL, 0x000fe20000000a00ULL, 0x000054104c067816ULL, 0x142fe40000000026ULL,
0x000076324c077816ULL, 0x000fca0000000026ULL, 0x0000000610007388ULL, 0x0003e80000000a00ULL,
0x000800080a007388ULL, 0x0005e20000000a00ULL, 0x0000005a5b06723eULL, 0x002fe200000010ffULL,
0x000000ff00077306ULL, 0x000fe20000209400ULL, 0x000054105c087816ULL, 0x144fe40000000060ULL,
0x000076325c097816ULL, 0x000fca0000000060ULL, 0x000800080b007388ULL, 0x0003e40000000a00ULL,
0x0000541064087816ULL, 0x142fe40000000032ULL, 0x0000763264097816ULL, 0x000fca0000000032ULL,
0x000800080c007388ULL, 0x0003e40000000a00ULL, 0x0000541000087816ULL, 0x142fe40000000002ULL,
0x0000763200097816ULL, 0x000fe40000000002ULL, 0x0000005e5f00723eULL, 0x000fe400000010ffULL,
0x000000626302723eULL, 0x000fe200000010ffULL, 0x0000000812007388ULL, 0x0003e40000000a00ULL,
0x0000541004087816ULL, 0x002fc40000000006ULL, 0x0000763204097816ULL, 0x000fe40000000006ULL,
0x000000666704723eULL, 0x000fe400000010ffULL, 0x0000006a6b06723eULL, 0x000fe200000010ffULL,
0x000c00080a007388ULL, 0x0003e60000000a00ULL, 0x00005410040e7816ULL, 0x140fe40000000006ULL,
0x00007632040f7816ULL, 0x000fc40000000006ULL, 0x0000541000087816ULL, 0x142fe40000000002ULL,
0x0000763200097816ULL, 0x000fe40000000002ULL, 0x000000ff00007306ULL, 0x000e660000205400ULL,
0x000c00080b007388ULL, 0x000fe80000000a00ULL, 0x000c000e0c007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000080107984ULL, 0x000ea20000000c00ULL,
0x000000000700720bULL, 0x002fc40003f1d000ULL, 0x000000ff00007245ULL, 0x000fe2000020d400ULL,
0x0004000080087984ULL, 0x000e680000000c00ULL, 0x0008000080287984ULL, 0x000ee80000000c00ULL,
0x000c000080307984ULL, 0x000ee40000000c00ULL, 0x0000000100000812ULL, 0x000fc400078efcffULL,
0x0010000080147984ULL, 0x000ee20000000c00ULL, 0x000000ff1800720cULL, 0x000fe40003f05270ULL,
0x000000000004723eULL, 0x000fe200000010ffULL, 0x0014000080247984ULL, 0x010ee80000000c00ULL,
0x00180000802c7984ULL, 0x000ee80000000c00ULL, 0x001c0000800c7984ULL, 0x000ee20000000c00ULL,
0x3f803f8004137831ULL, 0x004fc40000200013ULL, 0x3f803f8004127831ULL, 0x040fe40000200012ULL,
0x3f803f8004117831ULL, 0x040fe40000200011ULL, 0x3f803f8004107831ULL, 0x040fe40000200010ULL,
0x3f803f80040b7831ULL, 0x042fe4000020000bULL, 0x3f803f80040a7831ULL, 0x040fe4000020000aULL,
0x3f803f8004097831ULL, 0x000fc40000200009ULL, 0x3f803f8004087831ULL, 0x040fe40000200008ULL,
0x3f803f80042b7831ULL, 0x048fe4000020002bULL, 0x3f803f80042a7831ULL, 0x040fe4000020002aULL,
0x3f803f8004297831ULL, 0x040fe40000200029ULL, 0x3f803f8004287831ULL, 0x040fe40000200028ULL,
0x3f803f8004337831ULL, 0x000fc40000200033ULL, 0x3f803f8004327831ULL, 0x040fe40000200032ULL,
0x3f803f8004317831ULL, 0x040fe40000200031ULL, 0x3f803f8004307831ULL, 0x000fe40000200030ULL,
0x3f803f8013137831ULL, 0x000fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fc40000200015ULL, 0x3f803f8010107831ULL, 0x000fe40000200014ULL,
0x3f803f800b0b7831ULL, 0x000fe40000200027ULL, 0x3f803f800a0a7831ULL, 0x000fe20000200026ULL,
0x0000001080007388ULL, 0x000fe20000000c00ULL, 0x3f803f8009097831ULL, 0x000fe40000200025ULL,
0x3f803f8008087831ULL, 0x000fe40000200024ULL, 0x3f803f802b2b7831ULL, 0x000fc4000020002fULL,
0x3f803f802a2a7831ULL, 0x000fe2000020002eULL, 0x0004000880007388ULL, 0x000fe20000000c00ULL,
0x3f803f8029297831ULL, 0x000fe4000020002dULL, 0x3f803f8028287831ULL, 0x000fe4000020002cULL,
0x3f803f8033337831ULL, 0x000fe4000020000fULL, 0x3f803f8032327831ULL, 0x000fe2000020000eULL,
0x0008002880007388ULL, 0x000fe20000000c00ULL, 0x3f803f8031317831ULL, 0x000fc4000020000dULL,
0x3f803f8030307831ULL, 0x000fca000020000cULL, 0x000c003080007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fc80000011603ULL, 0x000000760900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000027b06ULL, 0x000e620000209000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00005a00ff137a12ULL, 0x000fe200078e33ffULL,
0x000000011e007824ULL, 0x000fe200078e0209ULL, 0x000000011f1f7812ULL, 0x000fc800078ec0ffULL,
0x0000000200027308ULL, 0x002e640000001000ULL, 0x0ffffffe02087810ULL, 0x002fe20007ffe0ffULL,
0x0000000109027824ULL, 0x000fca00078e0203ULL, 0x0000000800077305ULL, 0x000e62000021f000ULL,
0x0000000702027812ULL, 0x000fc800078ec0ffULL, 0x0ffffff802027812ULL, 0x000fca00078ef803ULL,
0x0000001002027824ULL, 0x000fe400078e0205ULL, 0x000000ffff0b7224ULL, 0x002fc800078e0a07ULL,
0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b07117227ULL, 0x000fe400078e0006ULL,
0x0000000002087984ULL, 0x0002a80000000c00ULL, 0x0000000011047227ULL, 0x000fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fe200078e0a04ULL, 0x0000000703027812ULL, 0x002fc600078ec0ffULL,
0x00005a0007067a24ULL, 0x000fca00078e0200ULL, 0x00005a0006007a0cULL, 0x000fda0003f06070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104040810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x00005a00ff007a0cULL, 0x000fd60003f05070ULL,
0x0000000104041810ULL, 0x000fc80007ffe0ffULL, 0x0000000413077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0220ULL,
0x00005a000d007a24ULL, 0x000fe400078e0200ULL, 0x000000081f0d7824ULL, 0x000fe400078e0202ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x0000000077047210ULL, 0x000fe40007f3e0ffULL,
0x0000002003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0004067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011600ULL,
0x00005f0004077a11ULL, 0x000fe400008f4407ULL, 0x000000760f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000011e027824ULL, 0x100fe400078e020fULL,
0x00000001000f7824ULL, 0x000fe400078e020fULL, 0x0000000211067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000613077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0220ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x000000081f0d7824ULL, 0x000fe400078e0200ULL, 0x00005a0007027a24ULL, 0x000fca00078e0202ULL,
0x0000000277077210ULL, 0x000fe40007f3e0ffULL, 0x0000004003027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011602ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x000000760f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000011e007824ULL, 0x100fe400078e020fULL, 0x00000001020f7824ULL, 0x000fe400078e020fULL,
0x0000000011067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0200ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef802ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000613077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0220ULL,
0x00005a000d007a24ULL, 0x000fe400078e0200ULL, 0x000000081f0d7824ULL, 0x000fe400078e0202ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x0000000077077210ULL, 0x000fe40007f3e0ffULL,
0x0000006003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011600ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x000000760f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000011e027824ULL, 0x100fe400078e020fULL,
0x00000001000f7824ULL, 0x000fe400078e020fULL, 0x0000000211067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000613077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0220ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x000000081f0d7824ULL, 0x000fe400078e0200ULL, 0x00005a0007027a24ULL, 0x000fca00078e0202ULL,
0x0000000277077210ULL, 0x000fe40007f3e0ffULL, 0x0000008003027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011602ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x000000760f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000011e007824ULL, 0x100fe400078e020fULL, 0x00000001020f7824ULL, 0x000fe400078e020fULL,
0x0000000011067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0200ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef802ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000613077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0220ULL,
0x00005a000d007a24ULL, 0x000fe400078e0200ULL, 0x000000081f0d7824ULL, 0x000fe400078e0202ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x0000000077077210ULL, 0x000fe40007f3e0ffULL,
0x000000a003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011600ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x000000760f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000011e027824ULL, 0x100fe200078e020fULL,
0x000000c0030c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001000f7824ULL, 0x000fe400078e020fULL,
0x0000000211067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef800ULL, 0x00000003ff0f7819ULL, 0x000fe4000001160cULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000613077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0220ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x000000081f0d7824ULL, 0x000fe400078e0200ULL, 0x00005a0007027a24ULL, 0x000fca00078e0202ULL,
0x0000000277027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0002067a11ULL, 0x000fc800078240ffULL, 0x00005f0002077a11ULL, 0x000fe400008f4407ULL,
0x000000760f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000011e007824ULL, 0x100fe400078e020fULL, 0x000000010c0f7824ULL, 0x000fe400078e020fULL,
0x0000000011067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007027a24ULL, 0x000fca00078e0200ULL,
0x00005a0002007a0cULL, 0x000fda0003f26070ULL, 0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0002007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f027812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001002047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000613077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0220ULL,
0x00005a000d007a24ULL, 0x000fc800078e0200ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x0000000077067210ULL, 0x000fe40007f3e0ffULL, 0x000000e003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0006027a11ULL, 0x040fe400078240ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011600ULL, 0x00005f0006037a11ULL, 0x000fe200008f4407ULL,
0x000000081f077824ULL, 0x000fe200078e020cULL, 0x000000760d00720cULL, 0x000fe20003f26070ULL,
0x000000011e1e7824ULL, 0x000fe400078e020dULL, 0x0000001007027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000001e11037227ULL, 0x002fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e0a03ULL,
0x00000001000d7824ULL, 0x000fe400078e020dULL, 0x00005a0007027a24ULL, 0x000fc600078e021eULL,
0x000000070d0d7812ULL, 0x000fe400078ec0ffULL, 0x00005a0002007a0cULL, 0x000fda0003f26070ULL,
0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103031810ULL, 0x000fe40007ffe0ffULL,
0x00005a0002007a0cULL, 0x000fe40003f46070ULL, 0xfffffff80d027812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001002057824ULL, 0x000fca00078e0205ULL,
0x0000000005087984ULL, 0x0002a20000000c00ULL, 0x0000000103032810ULL, 0x000fc80007ffe0ffULL,
0x0000000313037207ULL, 0x000fe20004000000ULL, 0x000000081f057824ULL, 0x002fc800078e0200ULL,
0x000000ffff077224ULL, 0x000fe400078e0a03ULL, 0x0000590003037a24ULL, 0x000fe400078e0220ULL,
0x00005a00071e7a24ULL, 0x000fc800078e021eULL, 0x00005a00031e7a24ULL, 0x000fca00078e021eULL,
0x0000001e771e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005e001e027a11ULL, 0x000fc800078040ffULL, 0x00005f001e037a11ULL, 0x000fca00000f4403ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x004fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff007819ULL, 0x000fe2000001161fULL,
0xffffffffff607424ULL, 0x000fc600078e00ffULL, 0x0000001b0000720cULL, 0x000fda0003f06070ULL,
0x0000000204078824ULL, 0x000fc800078e00ffULL, 0x00006a0007088a24ULL, 0x000fc800078e0200ULL,
0x0000660008088625ULL, 0x000fe200078e002bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006e00ff667624ULL, 0x000fe200078e00ffULL, 0x0000000608608981ULL, 0x000ea2000c1e1900ULL,
0x00006f00ff677624ULL, 0x000fc600078e00ffULL, 0x01260000ff067f8cULL, 0x000e68000c80043fULL,
0x0000000666667981ULL, 0x000722000c1e9900ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x00005800ff057624ULL, 0x000fe400078e00ffULL, 0x0000008020627824ULL, 0x000fe400078e00ffULL,
0x000000401f657824ULL, 0x000fe200078e00ffULL, 0x0000001f05057810ULL, 0x000fe20007ffe0ffULL,
0x0000008010637824ULL, 0x000fc600078e00ffULL, 0x0000004062167812ULL, 0x000fe400078ef865ULL,
0x00000005ff057819ULL, 0x000fe20000011605ULL, 0x0000006360277224ULL, 0x004fe200078e02ffULL,
0x0000062000000947ULL, 0x000fea0003800000ULL, 0x00000002ff237819ULL, 0x00afe4000001161dULL,
0x0000640027257a11ULL, 0x000fe400078038ffULL, 0x0000000823137810ULL, 0x040fe20007ffe0ffULL,
0x0000000116087824ULL, 0x000fe200078e0223ULL, 0x0000001023247810ULL, 0x000fc40007ffe0ffULL,
0x0000001823267810ULL, 0x000fe20007ffe0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000650027277a11ULL, 0x000fe400000f3cffULL, 0x0000002023197810ULL, 0x000fe20007ffe0ffULL,
0x00000001160a7824ULL, 0x000fe200078e0213ULL, 0x0000003008107812ULL, 0x000fe200078ef803ULL,
0x00000001160c7824ULL, 0x000fe200078e0224ULL, 0x000000651c087217ULL, 0x000fe20007800000ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001025107210ULL, 0x000fc40007f1e0ffULL,
0x0000001d1d127211ULL, 0x000fe200078fe8ffULL, 0x00000001160e7824ULL, 0x000fe200078e0226ULL,
0x000000300a0a7812ULL, 0x000fe200078ef803ULL, 0x0000000109117824ULL, 0x000fe200000e0627ULL,
0x0000000312187812ULL, 0x000fe200078ec0ffULL, 0x0000000116097824ULL, 0x000fe200078e0219ULL,
0x000000250a0a7210ULL, 0x000fe20007f3e0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000002823217810ULL, 0x000fe40007ffe0ffULL, 0x000020001f207811ULL, 0x000fe200078e68ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000300c0c7812ULL, 0x000fc400078ef803ULL,
0x0ffffffc181d7812ULL, 0x000fe200078ef81dULL, 0x0000000108157824ULL, 0x000fe200078e0a65ULL,
0x000000300e0e7812ULL, 0x000fe200078ef803ULL, 0x0000008009087825ULL, 0x000fe200078e00ffULL,
0x000000250c0c7210ULL, 0x080fe40007f1e0ffULL, 0x0000003023227810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0b7824ULL, 0x000fe200008e0627ULL, 0x0000003008127812ULL, 0x000fe200078ef803ULL,
0x0000000116087824ULL, 0x000fe200078e0221ULL, 0x000000250e0e7210ULL, 0x080fe20007f3e0ffULL,
0x000000010d0d7824ULL, 0x100fe200000e0627ULL, 0x0000002512127210ULL, 0x000fe20007f5e0ffULL,
0x0000000413177824ULL, 0x000fe200078e00ffULL, 0x000000152300720cULL, 0x080fe20003f06070ULL,
0x000000010f0f7824ULL, 0x100fe200008e0627ULL, 0x000000151300720cULL, 0x000fe20003f26070ULL,
0x0000000109137824ULL, 0x000fe200010e0627ULL, 0xfffffffc17177812ULL, 0x000fe200078ee218ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000003823237810ULL, 0x000fc40007ffe0ffULL,
0x000000152400720cULL, 0x080fe20003fa6070ULL, 0x000000101d1d7824ULL, 0x100fe200078e0220ULL,
0x0000003008147812ULL, 0x000fe200078ef803ULL, 0x0000001017177824ULL, 0x000fe200078e0220ULL,
0x000000152600720cULL, 0x000fe20003f86070ULL, 0x0000000116087824ULL, 0x000fe200078e0222ULL,
0x0000002514147210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101d7faeULL, 0x0003e2000c101c46ULL, 0x000000151900720cULL, 0x0c0fe20003f66070ULL,
0x0000000419197824ULL, 0x000fe200078e00ffULL, 0x000000152100720cULL, 0x080fe20003f46070ULL,
0x000000000a177faeULL, 0x0005e2000c901c46ULL, 0x000000152200720cULL, 0x000fc40003f26070ULL,
0x000000152300720cULL, 0x000fe20003f06070ULL, 0x0000000109157824ULL, 0x000fe200030e0627ULL,
0xfffffffc19197812ULL, 0x000fe200078ee218ULL, 0x0000008008087825ULL, 0x000fc800078e00ffULL,
0x0000000424117824ULL, 0x002fe200078e00ffULL, 0x0000003008087812ULL, 0x000fe200078ef803ULL,
0x00000001160a7824ULL, 0x004fe400078e0223ULL, 0x0000000426177824ULL, 0x000fe200078e00ffULL,
0x0000002508087210ULL, 0x000fe20007fde0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffffc11117812ULL, 0x100fe400078ee218ULL, 0xfffffffc17177812ULL, 0x000fe200078ee218ULL,
0x00000004211d7824ULL, 0x000fe200078e00ffULL, 0x000000300a0a7812ULL, 0x000fe200078ef803ULL,
0x0000000422217824ULL, 0x000fc400078e00ffULL, 0x0000000423237824ULL, 0x000fe200078e00ffULL,
0xfffffffc1d1d7812ULL, 0x100fe200078ee218ULL, 0x0000000109097824ULL, 0x000fe200030e0627ULL,
0xfffffffc21037812ULL, 0x000fe200078ee218ULL, 0x0000001011117824ULL, 0x000fe200078e0220ULL,
0xfffffffc23217812ULL, 0x000fe200078ee218ULL, 0x0000001017177824ULL, 0x100fe200078e0220ULL,
0x000000250a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001019197824ULL, 0x100fe200078e0220ULL,
0x000000000c117faeULL, 0x0003e2000e901c46ULL, 0x000000101d1d7824ULL, 0x000fc400078e0220ULL,
0x0000001003037824ULL, 0x100fe200078e0220ULL, 0x000000000e177faeULL, 0x0003e2000e101c46ULL,
0x0000001021217824ULL, 0x000fe400078e0220ULL, 0x000000010b0b7824ULL, 0x000fe200030e0627ULL,
0x0000000012197faeULL, 0x0003e8000d901c46ULL, 0x00000000141d7faeULL, 0x0003e8000d101c46ULL,
0x0000000008037faeULL, 0x0003e8000c901c46ULL, 0x000000000a217faeULL, 0x0003e2000c101c46ULL,
0x0000056000007947ULL, 0x000fea0003800000ULL, 0x000000201d097811ULL, 0x04afe400078ff0ffULL,
0x000000161d087211ULL, 0x000fc400078ff0ffULL, 0x000000181d157811ULL, 0x040fe200078ff0ffULL,
0x0000000116107824ULL, 0x000fe200078e0209ULL, 0x000000381d0f7811ULL, 0x000fe200078ff0ffULL,
0x0000000409197824ULL, 0x000fe200078e00ffULL, 0x0000001d1d0a7211ULL, 0x040fe200078fe8ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000000081d117811ULL, 0x040fe400078ff0ffULL,
0x000000101d137811ULL, 0x000fe200078ff0ffULL, 0x0000000415177824ULL, 0x000fe200078e00ffULL,
0x000000281d0b7811ULL, 0x040fe200078ff0ffULL, 0x00000001160e7824ULL, 0x000fe200078e0215ULL,
0x000000301d0d7811ULL, 0x000fe200078ff0ffULL, 0x000000040f257824ULL, 0x000fe200078e00ffULL,
0x000000030a187812ULL, 0x000fe200078ec0ffULL, 0x00000001160a7824ULL, 0x040fe200078e0211ULL,
0x00006400272d7a11ULL, 0x000fe200078038ffULL, 0x00000001160c7824ULL, 0x040fe200078e0213ULL,
0x000020001f207811ULL, 0x000fe200078e68ffULL, 0x0000000116127824ULL, 0x040fe200078e020bULL,
0x00006500272f7a11ULL, 0x000fe200000f3cffULL, 0x0000000116147824ULL, 0x000fe200078e020dULL,
0x0ffffffc181d7812ULL, 0x000fe200078ef81dULL, 0x000000040d237824ULL, 0x000fc400078e00ffULL,
0x0000000116157824ULL, 0x000fe200078e020fULL, 0x0000003008167812ULL, 0x000fe200078ef803ULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0xfffffffc170f7812ULL, 0x100fe200078ee218ULL,
0x0000000413137824ULL, 0x000fe200078e00ffULL, 0xfffffffc25177812ULL, 0x100fe200078ee218ULL,
0x000000040b217824ULL, 0x000fe200078e00ffULL, 0xfffffffc23087812ULL, 0x000fe200078ee218ULL,
0x000000101d317824ULL, 0x100fe200078e0220ULL, 0x000000162d167210ULL, 0x000fe20007f1e0ffULL,
0x0000001017297824ULL, 0x000fe200078e0220ULL, 0xfffffffc110b7812ULL, 0x000fe200078ee218ULL,
0x0000001008277824ULL, 0x000fe200078e0220ULL, 0xfffffffc130d7812ULL, 0x100fe200078ee218ULL,
0x0000000109177824ULL, 0x000fe200000e062fULL, 0xfffffffc19117812ULL, 0x000fe200078ee218ULL,
0x000000100b197824ULL, 0x000fe200078e0220ULL, 0xfffffffc21137812ULL, 0x000fe200078ee218ULL,
0x000000800a087825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016317faeULL, 0x0003e6000b901c46ULL, 0x000000100d1d7824ULL, 0x000fe200078e0220ULL,
0x0000003008087812ULL, 0x000fe200078ef803ULL, 0x000000800c0a7825ULL, 0x000fc600078e00ffULL,
0x000000082d087210ULL, 0x000fe20007f1e0ffULL, 0x000000100f217824ULL, 0x000fe200078e0220ULL,
0x000000300a0a7812ULL, 0x000fe200078ef803ULL, 0x000000800e0c7825ULL, 0x000fc600078e00ffULL,
0x0000000a2d0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000001011237824ULL, 0x000fe200078e0220ULL,
0x000000300c0c7812ULL, 0x000fe200078ef803ULL, 0x00000080100e7825ULL, 0x000fc600078e00ffULL,
0x0000000c2d0c7210ULL, 0x000fe20007f5e0ffULL, 0x0000001013257824ULL, 0x000fe200078e0220ULL,
0x000000300e0e7812ULL, 0x000fe200078ef803ULL, 0x0000008012107825ULL, 0x000fc600078e00ffULL,
0x0000000e2d0e7210ULL, 0x000fe20007f7e0ffULL, 0x0000008014127825ULL, 0x000fe200078e00ffULL,
0x0000003010107812ULL, 0x000fc600078ef803ULL, 0x0000008015147825ULL, 0x000fe200078e00ffULL,
0x0000003012127812ULL, 0x000fe400078ef803ULL, 0x000000102d107210ULL, 0x000fe20007f9e0ffULL,
0x0000000109097824ULL, 0x000fe200000e062fULL, 0x0000003014037812ULL, 0x000fe200078ef803ULL,
0x000000010b0b7824ULL, 0x100fe200008e062fULL, 0x000000122d127210ULL, 0x000fe20007fbe0ffULL,
0x000000010d0d7824ULL, 0x100fe200010e062fULL, 0x000000032d147210ULL, 0x000fe20007fde0ffULL,
0x000000010f0f7824ULL, 0x100fe200018e062fULL, 0x0000000008197faeULL, 0x0003e2000b901c46ULL,
0x0000000111117824ULL, 0x000fc400020e062fULL, 0x0000000113137824ULL, 0x100fe200028e062fULL,
0x000000000a1d7faeULL, 0x0003e2000b901c46ULL, 0x0000000115157824ULL, 0x000fc600030e062fULL,
0x000000000c217faeULL, 0x0003e8000b901c46ULL, 0x000000000e237faeULL, 0x0003e8000b901c46ULL,
0x0000000010257faeULL, 0x0003e8000b901c46ULL, 0x0000000012277faeULL, 0x0003e8000b901c46ULL,
0x0000000014297faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x01260400ff037984ULL, 0x000e620000000800ULL,
0x0000000502027224ULL, 0x000fc400078e02ffULL, 0x000000011c1d7824ULL, 0x000fe400078e0a61ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x8000000003ff7812ULL, 0x002fe20007804807ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620002027625ULL, 0x000fe200078e002bULL, 0x00000008ff1d7819ULL, 0x000fe2000001161dULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000000d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e640000000000ULL,
0x000000201f067824ULL, 0x002fca00078e0206ULL, 0x00000004ff077819ULL, 0x000fe40000011606ULL,
0x0000000106087810ULL, 0x040fe40007ffe0ffULL, 0x0ffffffe07097812ULL, 0x000fe400078ec0ffULL,
0x0000001f06077812ULL, 0x000fc600078ec0ffULL, 0x00000001090b7824ULL, 0x040fe400078e0208ULL,
0x00000001060a7824ULL, 0x000fe200078e0209ULL, 0x0000000809097810ULL, 0x000fe20007ffe0ffULL,
0x00000010070c7824ULL, 0x000fe200078e00ffULL, 0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x00000010070d7824ULL, 0x000fe200078e00ffULL, 0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000108087824ULL, 0x000fe200078e0209ULL, 0x000001f00c0b7812ULL, 0x000fe200078ee20bULL,
0x0000000106067824ULL, 0x000fe200078e0209ULL, 0x000001f00d0a7812ULL, 0x000fe200078ee20aULL,
0x0000001007097824ULL, 0x040fe200078e00ffULL, 0x0000000f08087812ULL, 0x000fe200078ec0ffULL,
0x000000000b0c7984ULL, 0x000e62000000cc00ULL, 0x0000001007077824ULL, 0x000fe200078e00ffULL,
0x0000000f06067812ULL, 0x000fc400078ec0ffULL, 0x000000000a107984ULL, 0x000ea4000000cc00ULL,
0x000001f007087812ULL, 0x000fe400078ee208ULL, 0x000001f009067812ULL, 0x000fe200078ee206ULL,
0x000000ffff167224ULL, 0x002fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff147224ULL, 0x004fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fc400078e0012ULL,
0x000000ffff227224ULL, 0x000fe400078e000dULL, 0x000000ffff237224ULL, 0x000fe200078e000fULL,
0x000000140a007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff207224ULL, 0x000fe400078e0011ULL,
0x000000ffff217224ULL, 0x000fca00078e0013ULL, 0x000000200b007388ULL, 0x000fe8000000cc00ULL,
0x00000000080c7984ULL, 0x000e68000000cc00ULL, 0x0000000006107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff277224ULL, 0x002fe400078e000eULL, 0x000000ffff267224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff247224ULL, 0x004fe400078e0010ULL,
0x000000ffff257224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000002406007388ULL, 0x0003e8000000cc00ULL,
0x0000000c08007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01260000ff0a7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0c7224ULL, 0x002fc600078e00ffULL,
0x0000000000067805ULL, 0x000fc80000015200ULL, 0x01260400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x006fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000000d08087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff1a00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000677919ULL, 0x000e620000000000ULL, 0x00006a0004697a24ULL, 0x000fe200078e02ffULL,
0x3db504f366667820ULL, 0x010fe20000410000ULL, 0x0000000205647824ULL, 0x000fe200078e00ffULL,
0x000126881f687811ULL, 0x000fe200078e18ffULL, 0x000000ffff6e7224ULL, 0x000fe200078e00ffULL,
0xffffffff616a7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x00000009616b7810ULL, 0x000fe40007ffe0ffULL, 0x000126081f6c7811ULL, 0x000fc400078e28ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff727224ULL, 0x000fe200078e0070ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000000ffff6d7224ULL, 0x000fe200078e00ffULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x01cfc4000001ff00ULL, 0x000000016d00780cULL, 0x040fe20003f25270ULL,
0x00000c2000007945ULL, 0x000fe20003800000ULL, 0x000000016e187810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff767224ULL, 0x000fe200078e006dULL, 0x000000016d197810ULL, 0x000fe20007ffe0ffULL,
0x00000063605e7224ULL, 0x010fe200078e02ffULL, 0x0000000172707812ULL, 0x000fc400078e0cffULL,
0x000000021900780cULL, 0x000fe20003f06070ULL, 0x000000ffff6d7224ULL, 0x000fc800078e0019ULL,
0x000000ffff181224ULL, 0x000fc800078e026eULL, 0x0000010018287824ULL, 0x060fe200078e0265ULL,
0x0000000118297810ULL, 0x000fe40007ffe0ffULL, 0x000000ff19187207ULL, 0x000fe40000800000ULL,
0x0000001a2900720cULL, 0x000fe40003f46070ULL, 0x0000004028297812ULL, 0x000fca00078ec0ffULL,
0x00000001625c7824ULL, 0x000fcc00078e0229ULL, 0x000005f00000a947ULL, 0x000fea0003800000ULL,
0x0000001067297824ULL, 0x002fe200078e00ffULL, 0x000000281c197217ULL, 0x000fe20007800000ULL,
0x000000021f5a7824ULL, 0x000fe200078e0270ULL, 0x00000002ff737819ULL, 0x000fe40000011667ULL,
0x0000003029297812ULL, 0x000fe200078ec0ffULL, 0x0000000119197824ULL, 0x000fe200078e0a28ULL,
0x0000001873747810ULL, 0x040fe20007ffe0ffULL, 0x00000001732b7824ULL, 0x140fe200078e025cULL,
0x0000000873587810ULL, 0x040fe20007ffe0ffULL, 0x0000004018287824ULL, 0x000fe200078e0229ULL,
0x000064005e6f7a11ULL, 0x000fe200078238ffULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x0000001073597810ULL, 0x000fe20007ffe0ffULL, 0x0000000174557824ULL, 0x000fe200078e025cULL,
0x000065005e717a11ULL, 0x000fe200008f3cffULL, 0x000000802b2a7825ULL, 0x000fe200078e0028ULL,
0x0000002073757810ULL, 0x000fc40007ffe0ffULL, 0x000020005a5a7811ULL, 0x000fe200078e60ffULL,
0x0000000158517824ULL, 0x000fe200078e025cULL, 0x0000006f2a567210ULL, 0x000fe20007f3e0ffULL,
0x0000008055547825ULL, 0x000fe200078e0028ULL, 0x00000067672a7211ULL, 0x000fe400078fe8ffULL,
0x0000002873777810ULL, 0x000fe20007ffe0ffULL, 0x000000015c537824ULL, 0x000fe200078e0259ULL,
0x000000032a5e7812ULL, 0x000fe200078ec0ffULL, 0x0000008051507825ULL, 0x000fe200078e0028ULL,
0x0000003073787810ULL, 0x000fc40007ffe0ffULL, 0x0ffffffc5e5b7812ULL, 0x000fe200078ef867ULL,
0x000000012b577824ULL, 0x000fe200008e0671ULL, 0x0000006f54547210ULL, 0x080fe20007f3e0ffULL,
0x00000001752b7824ULL, 0x000fe200078e025cULL, 0x0000006f50507210ULL, 0x000fe20007f5e0ffULL,
0x0000008053527825ULL, 0x000fe200078e0028ULL, 0x000000197400720cULL, 0x000fc60003fa6070ULL,
0x000000802b2a7825ULL, 0x000fe200078e0028ULL, 0x0000006f52527210ULL, 0x000fc60007f7e0ffULL,
0x0000000155557824ULL, 0x100fe200008e0671ULL, 0x000000197300720cULL, 0x080fe20003f26070ULL,
0x0000000151517824ULL, 0x100fe200010e0671ULL, 0x000000195800720cULL, 0x040fe20003f46070ULL,
0x00000004585d7824ULL, 0x000fe200078e00ffULL, 0x0000006f2a587210ULL, 0x000fe20007f9e0ffULL,
0x00000004595f7824ULL, 0x000fe200078e00ffULL, 0x0000003873737810ULL, 0x000fe20007ffe0ffULL,
0x0000000153537824ULL, 0x100fe200018e0671ULL, 0x000000195900720cULL, 0x080fe20003f66070ULL,
0x000000012b597824ULL, 0x000fe200020e0671ULL, 0xfffffffc5d5d7812ULL, 0x000fe200078ee25eULL,
0x000000105b5b7824ULL, 0x000fe200078e025aULL, 0xfffffffc5f5f7812ULL, 0x000fe200078ee25eULL,
0x00000001772b7824ULL, 0x000fe200078e025cULL, 0x000000197500720cULL, 0x080fe20003f86070ULL,
0x000000105d5d7824ULL, 0x000fe200078e025aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000565b7faeULL, 0x0003e2000c901c46ULL, 0x000000802b2a7825ULL, 0x000fe200078e0028ULL,
0x000000197300720cULL, 0x000fc40003f26070ULL, 0x00000000505d7faeULL, 0x0005e2000d101c46ULL,
0x000000105f5f7824ULL, 0x000fe200078e025aULL, 0x0000006f2a2a7210ULL, 0x000fe40007fde0ffULL,
0x000000197800720cULL, 0x0c0fe40003f46070ULL, 0x00000000525f7faeULL, 0x0007e2000d901c46ULL,
0x000000197700720cULL, 0x000fe20003f66070ULL, 0x0000000178577824ULL, 0x102fe400078e025cULL,
0x00000001735b7824ULL, 0x000fc400078e025cULL, 0x0000008057507825ULL, 0x004fc800078e0028ULL,
0x0000000474197824ULL, 0x000fe400078e00ffULL, 0x0000000475537824ULL, 0x008fe400078e00ffULL,
0x000000805b287825ULL, 0x000fe200078e0028ULL, 0xfffffffc19197812ULL, 0x100fe400078ee25eULL,
0xfffffffc53537812ULL, 0x000fe200078ee25eULL, 0x000000012b2b7824ULL, 0x000fe200030e0671ULL,
0x0000006f50507210ULL, 0x000fe20007fde0ffULL, 0x0000000477577824ULL, 0x000fc400078e00ffULL,
0x00000004785b7824ULL, 0x000fe400078e00ffULL, 0x00000004735d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc57577812ULL, 0x100fe200078ee25eULL, 0x0000000151517824ULL, 0x000fe200030e0671ULL,
0xfffffffc5b5b7812ULL, 0x000fe200078ee25eULL, 0x0000001019197824ULL, 0x000fe200078e025aULL,
0xfffffffc5d5d7812ULL, 0x000fe200078ee25eULL, 0x0000001053537824ULL, 0x100fe200078e025aULL,
0x0000006f28287210ULL, 0x000fe20007fde0ffULL, 0x0000001057577824ULL, 0x100fe200078e025aULL,
0x0000000054197faeULL, 0x0003e2000e901c46ULL, 0x000000105b5b7824ULL, 0x000fc400078e025aULL,
0x000000105d5d7824ULL, 0x000fe200078e025aULL, 0x0000000058537faeULL, 0x0003e2000e101c46ULL,
0x0000000129297824ULL, 0x000fc600030e0671ULL, 0x000000002a577faeULL, 0x0003e8000d901c46ULL,
0x00000000505b7faeULL, 0x0003e8000d101c46ULL, 0x00000000285d7faeULL, 0x0003e2000c901c46ULL,
0x0000053000007947ULL, 0x000fea0003800000ULL, 0x000000021f297824ULL, 0x000fe200078e0270ULL,
0x0000000867517811ULL, 0x042fe200078ff0ffULL, 0x0000001067197824ULL, 0x040fe200078e00ffULL,
0x0000001067537811ULL, 0x000fc400078ff0ffULL, 0x0000001867557811ULL, 0x000fe200078ff0ffULL,
0x00000001512b7824ULL, 0x100fe200078e025cULL, 0x0000002067577811ULL, 0x000fe200078ff0ffULL,
0x00000004535d7824ULL, 0x000fe200078e00ffULL, 0x0000002867597811ULL, 0x000fe200078ff0ffULL,
0x00000004555f7824ULL, 0x000fe200078e00ffULL, 0x0000200029777811ULL, 0x000fe200078e60ffULL,
0x0000000451297824ULL, 0x000fe200078e00ffULL, 0x00000030675b7811ULL, 0x000fe200078ff0ffULL,
0x0000000153517824ULL, 0x100fe200078e025cULL, 0x0000003867757811ULL, 0x000fe200078ff0ffULL,
0x0000000155537824ULL, 0x100fe200078e025cULL, 0x0000006767287211ULL, 0x000fe200078fe8ffULL,
0x0000000157557824ULL, 0x100fe200078e025cULL, 0x0000003019197812ULL, 0x000fe200078ec0ffULL,
0x00000004576f7824ULL, 0x000fe200078e00ffULL, 0x0000000328287812ULL, 0x000fe200078ec0ffULL,
0x0000000159577824ULL, 0x040fe200078e025cULL, 0x000064005e797a11ULL, 0x000fe200078238ffULL,
0x0000000459717824ULL, 0x000fe200078e00ffULL, 0xfffffffc292a7812ULL, 0x000fe200078ee228ULL,
0x000000015b597824ULL, 0x000fe200078e025cULL, 0xfffffffc5d507812ULL, 0x100fe200078ee228ULL,
0x000000045b5b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc5f527812ULL, 0x100fe200078ee228ULL,
0x0000000475737824ULL, 0x000fe200078e00ffULL, 0xfffffffc6f547812ULL, 0x100fe200078ee228ULL,
0x00000040185a7824ULL, 0x000fe200078e0219ULL, 0xfffffffc71567812ULL, 0x000fe200078ee228ULL,
0x0000000175757824ULL, 0x000fe200078e025cULL, 0xfffffffc5b587812ULL, 0x100fe200078ee228ULL,
0x000000ffff5b7224ULL, 0x000fe200078e00ffULL, 0xfffffffc73747812ULL, 0x000fe200078ee228ULL,
0x000000102a197824ULL, 0x000fe200078e0277ULL, 0x0ffffffc28287812ULL, 0x000fe200078ef867ULL,
0x00000010505d7824ULL, 0x100fe200078e0277ULL, 0x0000005c67297211ULL, 0x000fe200078ff0ffULL,
0x00000010525f7824ULL, 0x000fc400078e0277ULL, 0x00000010287b7824ULL, 0x000fe400078e0277ULL,
0x0000008029287825ULL, 0x000fc800078e005aULL, 0x00000010546f7824ULL, 0x100fe400078e0277ULL,
0x0000001056717824ULL, 0x100fe400078e0277ULL, 0x0000001058737824ULL, 0x000fe400078e0277ULL,
0x000000802b2a7825ULL, 0x000fc800078e005aULL, 0x0000008051507825ULL, 0x000fe200078e005aULL,
0x000000792a2a7210ULL, 0x000fc60007f5e0ffULL, 0x0000008053527825ULL, 0x000fe200078e005aULL,
0x0000007950507210ULL, 0x000fc60007f7e0ffULL, 0x0000008055547825ULL, 0x000fe200078e005aULL,
0x0000007952527210ULL, 0x000fc60007f9e0ffULL, 0x0000008057567825ULL, 0x000fc800078e005aULL,
0x0000008059587825ULL, 0x000fc800078e005aULL, 0x00000080755a7825ULL, 0x000fe200078e005aULL,
0x000065005e757a11ULL, 0x000fe400008f3cffULL, 0x0000007928287210ULL, 0x080fe20007f3e0ffULL,
0x0000001074777824ULL, 0x000fe400078e0277ULL, 0x000000012b2b7824ULL, 0x100fe200010e0675ULL,
0x0000007956567210ULL, 0x080fe20007f5e0ffULL, 0x0000000129297824ULL, 0x100fe200008e0675ULL,
0x0000007954547210ULL, 0x080fe20007f3e0ffULL, 0x0000000151517824ULL, 0x100fe200018e0675ULL,
0x0000007958587210ULL, 0x080fe20007f7e0ffULL, 0x0000000153537824ULL, 0x100fe200020e0675ULL,
0x000000795a5a7210ULL, 0x000fe20007f9e0ffULL, 0x0000000155557824ULL, 0x100fe200008e0675ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000287b7faeULL, 0x0003e2000b901c46ULL,
0x0000000157577824ULL, 0x000fc400010e0675ULL, 0x0000000159597824ULL, 0x100fe200018e0675ULL,
0x000000002a197faeULL, 0x0003e2000b901c46ULL, 0x000000015b5b7824ULL, 0x000fc600020e0675ULL,
0x00000000505d7faeULL, 0x0003e8000b901c46ULL, 0x00000000525f7faeULL, 0x0003e8000b901c46ULL,
0x00000000546f7faeULL, 0x0003e8000b901c46ULL, 0x0000000056717faeULL, 0x0003e8000b901c46ULL,
0x0000000058737faeULL, 0x0003e8000b901c46ULL, 0x000000005a777faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000011800780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x0000000200007810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff607424ULL, 0x000fc600078e00ffULL,
0x0000001b0000720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000269187824ULL, 0x000fe400078e0200ULL, 0x00000004ff197424ULL, 0x002fc800078e00ffULL,
0x0000660018187625ULL, 0x000fca00078e0019ULL, 0x0000000618607981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000876717824ULL, 0x002fe400078e00ffULL, 0x000000ffffd37224ULL, 0x000fe400078e00ffULL,
0x00000010ff737424ULL, 0x000fe200078e00ffULL, 0x0000001271747810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff6f7224ULL, 0x000fe200078e00ffULL, 0x0000000271717810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff867187812ULL, 0x000fe200078ec0ffULL,
0x000000021f507824ULL, 0x020fe200078e0272ULL, 0x000000016f517810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000718187812ULL, 0x000fc400078ef867ULL,
0x0000200050507811ULL, 0x000fe400078e60ffULL, 0x00000001ff287819ULL, 0x000fe20000011618ULL,
0x00000004182a7824ULL, 0x040fe200078e00ffULL, 0x0000002067527810ULL, 0x000fe20007ffe0ffULL,
0x0000000418537824ULL, 0x000fe400078e00ffULL, 0x0000000128197824ULL, 0x000fe200078e026fULL,
0xfffffff852527812ULL, 0x000fe200078ec0ffULL, 0x0000000128187824ULL, 0x000fc600078e0251ULL,
0xfffffffc2a197812ULL, 0x000fe400078ee219ULL, 0x0000000752527812ULL, 0x000fe400078ef867ULL,
0xfffffffc53537812ULL, 0x000fe200078ee218ULL, 0x0000001019197824ULL, 0x000fe200078e0250ULL,
0x00000001ff547819ULL, 0x000fe20000011652ULL, 0x00000004525c7824ULL, 0x000fe400078e00ffULL,
0x0000001053537824ULL, 0x000fe200078e0250ULL, 0x000000001928783bULL, 0x0002a20000000200ULL,
0x0000000154517824ULL, 0x000fc400078e0251ULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x000000005358783bULL, 0x000ee20000000200ULL, 0x0000000154197824ULL, 0x002fc600078e026fULL,
0xfffffffc52517812ULL, 0x000fe400078ee251ULL, 0x000000026f6f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffffc5c197812ULL, 0x000fe200078ee219ULL, 0x0000001051517824ULL, 0x000fc800078e0250ULL,
0x0000001019197824ULL, 0x000fe400078e0250ULL, 0x000000005150783bULL, 0x000fe80000000200ULL,
0x00000000195c783bULL, 0x000e620000000200ULL, 0x0000002800897306ULL, 0x004fe20000009400ULL,
0x0001000028e77824ULL, 0x040fe200078e00ffULL, 0x00000018ffe27819ULL, 0x000fe20000011428ULL,
0x0001000029db7824ULL, 0x040fe200078e00ffULL, 0x00000018ffd97819ULL, 0x000fe20000011429ULL,
0x0000010028d87824ULL, 0x000fe200078e00ffULL, 0x00000018ffe77819ULL, 0x000fe200000114e7ULL,
0x0000010029d67824ULL, 0x000fe200078e00ffULL, 0x00000028008a7306ULL, 0x000ea20000005400ULL,
0x00000018ffdb7819ULL, 0x000fe200000114dbULL, 0x000100002acd7824ULL, 0x040fe200078e00ffULL,
0x00000018ffd87819ULL, 0x000fe200000114d8ULL, 0x000001002acc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd67819ULL, 0x000fe200000114d6ULL, 0x000100002be87824ULL, 0x040fe200078e00ffULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x000000e200927306ULL, 0x000fe20000209400ULL,
0x00000018ffcc7819ULL, 0x000fe200000114ccULL, 0x000001002be57824ULL, 0x000fe200078e00ffULL,
0x00000018ffd17819ULL, 0x000fe2000001142aULL, 0x0001000058b87824ULL, 0x048fe200078e00ffULL,
0x00000018ffe87819ULL, 0x000fe200000114e8ULL, 0x0000010058a77824ULL, 0x000fe200078e00ffULL,
0x00000018ffc97819ULL, 0x000fe2000001142bULL, 0x000000e200eb7306ULL, 0x0006620000205400ULL,
0x0000008a8900720bULL, 0x004fe20003fbd000ULL, 0x0001000059a57824ULL, 0x040fe200078e00ffULL,
0x00000018ffa27819ULL, 0x000fe20000011458ULL, 0x00000100599f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011459ULL, 0x000100005a9c7824ULL, 0x040fe200078e00ffULL,
0x00000018ffe57819ULL, 0x000fe200000114e5ULL, 0x000000e700ec7306ULL, 0x000fe20000209400ULL,
0x000000e200e27245ULL, 0x008fe2000020d400ULL, 0x000001005a977824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fc4000001145aULL, 0x00000018ffd57819ULL, 0x002fe4000001145cULL,
0x00000018ffb77819ULL, 0x000fe2000001145fULL, 0x000000e700f37306ULL, 0x0002a20000205400ULL,
0x000000eb9200720bULL, 0x000fe20003fdd000ULL, 0x000100005b927824ULL, 0x000fe200078e00ffULL,
0x00000018ffc57819ULL, 0x000fe4000001145dULL, 0x00000018ffbf7819ULL, 0x000fe4000001145eULL,
0x00000018ff827819ULL, 0x000fe2000001145bULL, 0x0000002800da7306ULL, 0x000ee2000000d400ULL,
0x000000e700e77245ULL, 0x002fc4000020d400ULL, 0x00000018ffb87819ULL, 0x000fe400000114b8ULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x00000001e2e26812ULL, 0x000fe200078efcffULL,
0x000000db00ea7306ULL, 0x000fe20000209400ULL, 0x000000f3ec00720bULL, 0x004fe20003f7d000ULL,
0x000100005fec7824ULL, 0x000fe200078e00ffULL, 0x00000018ff977819ULL, 0x000fe40000011497ULL,
0x00000018ff927819ULL, 0x000fc40000011492ULL, 0x00000018ff8c7819ULL, 0x000fe20000011450ULL,
0x000000db00f17306ULL, 0x0002a20000205400ULL, 0x00000001dada5812ULL, 0x008fe400078efcffULL,
0x00000018ff9f7819ULL, 0x000fe4000001149fULL, 0x00000018ffa57819ULL, 0x000fe400000114a5ULL,
0x00000001e7e73812ULL, 0x000fe200078efcffULL, 0x000000d800ef7306ULL, 0x000fe20000209400ULL,
0x000000db00db7245ULL, 0x002fc4000020d400ULL, 0x00000018ff887819ULL, 0x000fe40000011451ULL,
0x00000018ff8a7819ULL, 0x000fe40000011452ULL, 0x00000018ff9c7819ULL, 0x000fe2000001149cULL,
0x000000d800e67306ULL, 0x000e620000205400ULL, 0x000000f1ea00720bULL, 0x004fce0003fbd000ULL,
0x000000d600aa7306ULL, 0x000fec0000209400ULL, 0x00000001dbdb5812ULL, 0x000fe400078efcffULL,
0x000000d600e37306ULL, 0x0004e20000205400ULL, 0x000000e6ef00720bULL, 0x002fe40003f7d000ULL,
0x0000000867e67812ULL, 0x000fca00078ec0ffULL, 0x000000cd00d47306ULL, 0x000fe20000209400ULL,
0x000000d600d67245ULL, 0x004fce000020d400ULL, 0x000000cd00e97306ULL, 0x0002a20000205400ULL,
0x000000e3aa00720bULL, 0x008fe20003fdd000ULL, 0x0000000876e37824ULL, 0x000fcc00078e02d3ULL,
0x0000002a008d7306ULL, 0x000fe20000009400ULL, 0x000000cd00cd7245ULL, 0x002fca000020d400ULL,
0x00000001d6d66812ULL, 0x000fe400078efcffULL, 0x0000002a00e47306ULL, 0x000e620000005400ULL,
0x000000e9d400720bULL, 0x004fe20003fbd000ULL, 0x0000000876e97824ULL, 0x000fcc00078e0273ULL,
0x0000002900947306ULL, 0x000fec0000009400ULL, 0x00000001cdcd5812ULL, 0x000fe400078efcffULL,
0x0000002900917306ULL, 0x000ea20000005400ULL, 0x000000e48d00720bULL, 0x002fe20003f3d000ULL,
0x000100005ce47824ULL, 0x000fca00078e00ffULL, 0x00000018ffe47819ULL, 0x000fe200000114e4ULL,
0x000000cc00d27306ULL, 0x000ff00000209400ULL, 0x000000cc00ed7306ULL, 0x0002e20000205400ULL,
0x000000919400720bULL, 0x004fc40003f9d000ULL, 0x00000018ff917819ULL, 0x000fca0000011453ULL,
0x000000d900a67306ULL, 0x000fe20000209400ULL, 0x000000cc00cc7245ULL, 0x002fce000020d400ULL,
0x000000d900e17306ULL, 0x0003e20000205400ULL, 0x000000edd200720bULL, 0x008fce0003fdd000ULL,
0x0000002a00c67306ULL, 0x000ea2000000d400ULL, 0x000000d900d97245ULL, 0x002fca000020d400ULL,
0x00000001cccc6812ULL, 0x000fe400078efcffULL, 0x0000002b00907306ULL, 0x000ff00000009400ULL,
0x0000002b00997306ULL, 0x000e620000005400ULL, 0x00000001c6c61812ULL, 0x004fce00078efcffULL,
0x0000002b00c07306ULL, 0x000eb0000000d400ULL, 0x000000d100557306ULL, 0x000fe20000209400ULL,
0x000000999000720bULL, 0x002fce0003f5d000ULL, 0x000000d100547306ULL, 0x0002ec0000205400ULL,
0x00000001c0c02812ULL, 0x004fe400078efcffULL, 0x0000005800d77306ULL, 0x000fe20000009400ULL,
0x000000d100d17245ULL, 0x002fce000020d400ULL, 0x0000005800ca7306ULL, 0x000fe20000005400ULL,
0x000000545500720bULL, 0x008fce0003fbd000ULL, 0x0000005800857306ULL, 0x0003ec000000d400ULL,
0x00000001d1d15812ULL, 0x000fe400078efcffULL, 0x0000005900577306ULL, 0x000fe20000009400ULL,
0x000000e667587211ULL, 0x002fe400078fe0ffULL, 0x00000007e6e67812ULL, 0x000fc800078ef867ULL,
0x00000010e6d47812ULL, 0x000fe200078efcffULL, 0x0000005900567306ULL, 0x000fe80000005400ULL,
0x00000010d4ef7824ULL, 0x000fc800078e00ffULL, 0x0000005900787306ULL, 0x0003f0000000d400ULL,
0x000000e8002a7306ULL, 0x000fe20000209400ULL, 0x0000000767597812ULL, 0x002fce00078ec0ffULL,
0x000000e8002b7306ULL, 0x000e700000205400ULL, 0x0000005a00bb7306ULL, 0x000ff00000009400ULL,
0x0000005a00ba7306ULL, 0x000fe20000005400ULL, 0x0000002b2a00720bULL, 0x002fce0003f3d000ULL,
0x0000005a00757306ULL, 0x0003f0000000d400ULL, 0x0000002900187306ULL, 0x000ea2000000d400ULL,
0x00000001595a7824ULL, 0x002fe200078e0258ULL, 0x000000d800597245ULL, 0x000fc6000020d400ULL,
0x000000015ae37824ULL, 0x000fe200078e02e3ULL, 0x0000000159593812ULL, 0x000fe400078efcffULL,
0x000000e500287306ULL, 0x000fe20000209400ULL, 0x000000e1a600720bULL, 0x000fe20003f7d000ULL,
0x000001005ce17824ULL, 0x000fe200078e00ffULL, 0x000000715aaa7210ULL, 0x140fe40007ffe0d3ULL,
0x000000745aa67210ULL, 0x040fe20007ffe0d3ULL, 0x000000015a5a7824ULL, 0x000fe200078e02e9ULL,
0x00000018ffe17819ULL, 0x000fe200000114e1ULL, 0x000000e500297306ULL, 0x000e620000205400ULL,
0x00000010d4e97824ULL, 0x000fe200078e00ffULL, 0x0000000118184812ULL, 0x004fe200078efcffULL,
0x000100005dd37824ULL, 0x000fe200078e00ffULL, 0x000000cad700720bULL, 0x000fe20003f9d000ULL,
0x000001005fd47824ULL, 0x000fe200078e00ffULL, 0xfffffff0e95a7812ULL, 0x000fe200078ee25aULL,
0x000001005dca7824ULL, 0x000fe200078e00ffULL, 0x000000c900df7306ULL, 0x000fe20000209400ULL,
0x00000018ffd37819ULL, 0x000fc400000114d3ULL, 0x000000105a2a7824ULL, 0x000fe200078e00ffULL,
0x00000001d9d93812ULL, 0x000fe200078efcffULL, 0x000001005b5a7824ULL, 0x000fe200078e00ffULL,
0x000000565700720bULL, 0x000fe40003f7d000ULL, 0x000000c900e07306ULL, 0x0004e20000205400ULL,
0x000000292800720bULL, 0x002fe40003fdd000ULL, 0x000000002a28783bULL, 0x000fe20000000200ULL,
0x00000018ffca7819ULL, 0x000fe400000114caULL, 0x00000059e259723eULL, 0x000fc400000010ffULL,
0x000000e400ea7306ULL, 0x000fe20000209400ULL, 0x000000c900c97245ULL, 0x004fe4000020d400ULL,
0x00000018ffd47819ULL, 0x000fe400000114d4ULL, 0x00000018db18723eULL, 0x000fe400000010ffULL,
0xfffffff0efa67812ULL, 0x000fe200078ee2a6ULL, 0x000000e400eb7306ULL, 0x000fe20000205400ULL,
0x000000e0df00720bULL, 0x008fe40003fbd000ULL, 0x0000000185854812ULL, 0x000fc400078efcffULL,
0x0000000178783812ULL, 0x000fc600078efcffULL, 0x0000005c00c77306ULL, 0x000fec0000009400ULL,
0x00000001c9c95812ULL, 0x000fe400078efcffULL, 0x0000005c00de7306ULL, 0x000e700000005400ULL,
0x0000005c00b67306ULL, 0x0004f0000000d400ULL, 0x000000e100587306ULL, 0x000fe20000209400ULL,
0x00000010e65c7824ULL, 0x004fe200078e00ffULL, 0x000000dec700720bULL, 0x002fc80003f5d000ULL,
0xfffffff05c5c7812ULL, 0x000fe200078ee2e3ULL, 0x00000010e6e37824ULL, 0x000fe200078e00ffULL,
0x000000e100e97306ULL, 0x000fe80000205400ULL, 0xfffffff0e3aa7812ULL, 0x000fc600078ee2aaULL,
0x00000001b6b62812ULL, 0x008fe200078efcffULL, 0x0000005f00c17306ULL, 0x000ff00000009400ULL,
0x0000005f00c27306ULL, 0x000ff00000005400ULL, 0x0000005f00ac7306ULL, 0x0003f0000000d400ULL,
0x0000005d00cf7306ULL, 0x000fe20000009400ULL, 0x000000e8005f7245ULL, 0x002fc8000020d400ULL,
0x000000015f5f1812ULL, 0x000fe400078efcffULL, 0x000000ebea00720bULL, 0x000fe20003f3d000ULL,
0x0000005d00ce7306ULL, 0x000e700000005400ULL, 0x0000005d00b37306ULL, 0x0004f0000000d400ULL,
0x000000d500dc7306ULL, 0x000fe20000209400ULL, 0x000000105c5d7824ULL, 0x004fe200078e00ffULL,
0x000000cecf00720bULL, 0x002fe20003f5d000ULL, 0x000100005e5c7824ULL, 0x000fe200078e00ffULL,
0x000000d500ce7245ULL, 0x000fc4000020d400ULL, 0x000000005d54783bULL, 0x0002a40000000200ULL,
0x000000d500dd7306ULL, 0x000ee20000205400ULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x000001005e5d7824ULL, 0x002fca00078e00ffULL, 0x00000001b3b32812ULL, 0x008fe200078efcffULL,
0x000000d300e37306ULL, 0x000fe20000209400ULL, 0x00000018ffc77819ULL, 0x000fe4000001145dULL,
0x000000e1005d7245ULL, 0x000fca000020d400ULL, 0x000000d300e67306ULL, 0x000fe20000205400ULL,
0x000000dddc00720bULL, 0x000fce0003fbd000ULL, 0x0000005e00197306ULL, 0x000fec0000009400ULL,
0x00000001cece5812ULL, 0x000fe400078efcffULL, 0x0000005e00d07306ULL, 0x000e700000005400ULL,
0x0000005e00af7306ULL, 0x000670000000d400ULL, 0x0000005b00b57306ULL, 0x000fe20000009400ULL,
0x000000e5005e7245ULL, 0x008fc8000020d400ULL, 0x000000015e5e6812ULL, 0x000fe400078efcffULL,
0x000000e95800720bULL, 0x000fe20003fdd000ULL, 0x0000005b00b47306ULL, 0x000fe20000005400ULL,
0x000000dae758723eULL, 0x000fe400000010ffULL, 0x00000018ffda7819ULL, 0x000fca00000114ecULL,
0x0000005b00777306ULL, 0x0007e2000000d400ULL, 0x000000585430723cULL, 0x084fe60000041830ULL,
0x000000015d5d6812ULL, 0x000fe400078efcffULL, 0x000000d01900720bULL, 0x002fe40003fdd000ULL,
0x000000ca00d77306ULL, 0x000fe20000209400ULL, 0x000000e4005b7245ULL, 0x008fe2000020d400ULL,
0x000000582834723cULL, 0x000b620000041834ULL, 0x000000d300d07245ULL, 0x000fc4000020d400ULL,
0x000000015b5b1812ULL, 0x000fe400078efcffULL, 0x000000e6e300720bULL, 0x000fe20003f3d000ULL,
0x000000ca00d87306ULL, 0x0002a20000205400ULL, 0x000000d6d919723eULL, 0x000fe400000010ffULL,
0x000000c6cd58723eULL, 0x020fe400000010ffULL, 0x00000001afaf6812ULL, 0x000fe400078efcffULL,
0x000000ccd159723eULL, 0x000fe200000010ffULL, 0x000000c500c87306ULL, 0x000fe20000209400ULL,
0x000000ca00ca7245ULL, 0x002fe2000020d400ULL, 0x000000185438723cULL, 0x000fe20000041838ULL,
0x0000005dce5d723eULL, 0x000fc400000010ffULL, 0x00000001d0d01812ULL, 0x000fe400078efcffULL,
0xfffffff473d37810ULL, 0x000fe20007ffe0ffULL, 0x000000c500cb7306ULL, 0x0002e20000205400ULL,
0x000000d8d700720bULL, 0x004fe20003fbd000ULL, 0x00000018283c723cULL, 0x000bec000004183cULL,
0x0000005c00d27306ULL, 0x000fe20000209400ULL, 0x000000c500c57245ULL, 0x002fe2000020d400ULL,
0x000000585440723cULL, 0x000fe20000041840ULL, 0x0000005ec919723eULL, 0x020fc400000010ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145aULL, 0x00000001caca5812ULL, 0x000fe200078efcffULL,
0x0000005c00df7306ULL, 0x0002a20000205400ULL, 0x000000cbc800720bULL, 0x008fe20003f3d000ULL,
0x000000582844723cULL, 0x000fe20000041844ULL, 0x000000c2c100720bULL, 0x000fe40003fbd000ULL,
0x0000005c00c27245ULL, 0x000fe4000020d400ULL, 0x000000bf005a7245ULL, 0x000fe2000020d400ULL,
0x000000c700de7306ULL, 0x000fe20000209400ULL, 0x000000b65b5c723eULL, 0x002fc400000010ffULL,
0x000000c05f18723eULL, 0x000fe400000010ffULL, 0x000000b7005b7245ULL, 0x000fe4000020d400ULL,
0x00000001c5c51812ULL, 0x000fe200078efcffULL, 0x000000c700dd7306ULL, 0x0002e20000205400ULL,
0x000000dfd200720bULL, 0x004fe20003f5d000ULL, 0x00000018544c723cULL, 0x000f62000004184cULL,
0x00000001acac5812ULL, 0x000fca00078efcffULL, 0x000000bf00c37306ULL, 0x000fe20000209400ULL,
0x000000c700c77245ULL, 0x002fe2000020d400ULL, 0x000000182848723cULL, 0x000b680000041848ULL,
0x00000001c2c22812ULL, 0x000fe400078efcffULL, 0x000000bf00c47306ULL, 0x000e620000205400ULL,
0x000000ddde00720bULL, 0x008fe20003f3d000ULL, 0x0000005c542c723cULL, 0x000fe2000004182cULL,
0x000000b3d018723eULL, 0x020fc400000010ffULL, 0x000000cac519723eULL, 0x000fe400000010ffULL,
0x000000afc258723eULL, 0x000fe200000010ffULL, 0x000000da00cf7306ULL, 0x000fe20000209400ULL,
0x0001000051af7824ULL, 0x000fe200078e00ffULL, 0x0000005c2810723cULL, 0x000be80000041810ULL,
0x00000001c7c71812ULL, 0x000fe400078efcffULL, 0x000000da00d67306ULL, 0x000ea20000205400ULL,
0x000000c4c300720bULL, 0x002fe20003f5d000ULL, 0x000000185424723cULL, 0x000f620000041824ULL,
0x000000babb00720bULL, 0x000fc40003f3d000ULL, 0x000000da00bb7245ULL, 0x000fe4000020d400ULL,
0x00000093005c7245ULL, 0x020fe2000020d400ULL, 0x000000b800bc7306ULL, 0x000fe20000209400ULL,
0x00000018ffaf7819ULL, 0x000fe200000114afULL, 0x00000018280c723cULL, 0x000b68000004180cULL,
0x000000015a5a2812ULL, 0x000fe400078efcffULL, 0x000000b800bd7306ULL, 0x0002e20000205400ULL,
0x000000d6cf00720bULL, 0x004fc40003fdd000ULL, 0x000000c75a59723eULL, 0x000fe400000010ffULL,
0x0000000175751812ULL, 0x000fc600078efcffULL, 0x000000b700b97306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x002fe2000020d400ULL, 0x000000585414723cULL, 0x080f680000041814ULL,
0x00000001bbbb6812ULL, 0x000fe400078efcffULL, 0x000000b700be7306ULL, 0x0002a20000205400ULL,
0x000000bdbc00720bULL, 0x008fe20003fbd000ULL, 0x000000582808723cULL, 0x000f620000041808ULL,
0x000000acbb5a723eULL, 0x000fe200000010ffULL, 0x0000010053ac7824ULL, 0x000fc800078e00ffULL,
0x000000d400c67306ULL, 0x000fe20000209400ULL, 0x0001000053b77824ULL, 0x002fe200078e00ffULL,
0x00000018ffac7819ULL, 0x000fc800000114acULL, 0x00000001b8b85812ULL, 0x000fe400078efcffULL,
0x000000d400c17306ULL, 0x0002e20000205400ULL, 0x000000beb900720bULL, 0x004fe20003fdd000ULL,
0x0001000050b97824ULL, 0x000fe200078e00ffULL, 0x00000085b818723eULL, 0x020fe400000010ffULL,
0x00000018ffb77819ULL, 0x000fe400000114b7ULL, 0x00000018ffb97819ULL, 0x000fe200000114b9ULL,
0x000000a700b17306ULL, 0x000fe20000209400ULL, 0x000000d400d47245ULL, 0x002fca000020d400ULL,
0x000000015b5b6812ULL, 0x000fe400078efcffULL, 0x000000a700b27306ULL, 0x0002a20000205400ULL,
0x000000c1c600720bULL, 0x008fce0003f5d000ULL, 0x0000009300a37306ULL, 0x000fe20000209400ULL,
0x000000a700a77245ULL, 0x002fca000020d400ULL, 0x00000001d4d42812ULL, 0x000fe400078efcffULL,
0x0000009300a47306ULL, 0x0002e20000205400ULL, 0x000000b2b100720bULL, 0x004fe20003fbd000ULL,
0x0000010051b27824ULL, 0x000fe200078e00ffULL, 0x000000d45b5b723eULL, 0x000fe400000010ffULL,
0x000000b4b500720bULL, 0x000fe20003f5d000ULL, 0x0001000052b47824ULL, 0x040fe200078e00ffULL,
0x00000018ffb27819ULL, 0x000fe200000114b2ULL, 0x000000a200b07306ULL, 0x000fe20000209400ULL,
0x0000010052b57824ULL, 0x000fe200078e00ffULL, 0x0000005a5420723cULL, 0x000b620000041820ULL,
0x0000005e00937245ULL, 0x002fc4000020d400ULL, 0x00000018ffb47819ULL, 0x000fe400000114b4ULL,
0x00000001a7a75812ULL, 0x000fe200078efcffULL, 0x000000a200ad7306ULL, 0x0002a20000205400ULL,
0x000000a4a300720bULL, 0x008fe20003fbd000ULL, 0x00000010a6547824ULL, 0x020fe200078e00ffULL,
0x0000000177772812ULL, 0x000fe200078efcffULL, 0x0000005a2804723cULL, 0x000b620000041804ULL,
0x00000018ffb57819ULL, 0x000fc600000114b5ULL, 0x0000005000957306ULL, 0x000fe20000009400ULL,
0x000000005454783bULL, 0x000ee20000000200ULL, 0x000000a200a27245ULL, 0x002fe4000020d400ULL,
0x0000007900287245ULL, 0x020fe4000020d400ULL, 0x000000015c5c5812ULL, 0x000fe400078efcffULL,
0x0000005000987306ULL, 0x000fe20000005400ULL, 0x000000adb000720bULL, 0x004fe40003fdd000ULL,
0x000000af002a7245ULL, 0x000fc4000020d400ULL, 0x000000b2002b7245ULL, 0x000fc6000020d400ULL,
0x00000050007a7306ULL, 0x0003ec000000d400ULL, 0x00000001a2a26812ULL, 0x000fe400078efcffULL,
0x00000097009d7306ULL, 0x000fe20000209400ULL, 0x0000010050507824ULL, 0x002fe200078e00ffULL,
0x000000a7a219723eULL, 0x000fc800000010ffULL, 0x00000018ffad7819ULL, 0x000fe20000011450ULL,
0x00000010aa507824ULL, 0x000fe200078e00ffULL, 0x00000097009e7306ULL, 0x000e700000205400ULL,
0x0000009200997306ULL, 0x000fe20000209400ULL, 0x000000185434723cULL, 0x008f6e0000041834ULL,
0x0000009200c07306ULL, 0x0004e20000205400ULL, 0x0000009e9d00720bULL, 0x002fc40003fbd000ULL,
0x00000097009d7245ULL, 0x000fca000020d400ULL, 0x0000005100877306ULL, 0x000fe20000009400ULL,
0x0000009200927245ULL, 0x004fca000020d400ULL, 0x000000019d9d5812ULL, 0x000fe400078efcffULL,
0x0000005100867306ULL, 0x000fe20000005400ULL, 0x000000c09900720bULL, 0x008fce0003f3d000ULL,
0x00000051007b7306ULL, 0x000fec000000d400ULL, 0x0000000192921812ULL, 0x000fe400078efcffULL,
0x00000052007c7306ULL, 0x000fe40000009400ULL, 0x000000779292723eULL, 0x000fcc00000010ffULL,
0x00000052007d7306ULL, 0x000ff00000005400ULL, 0x00000052007e7306ULL, 0x000ff0000000d400ULL,
0x00000053007f7306ULL, 0x000ff00000009400ULL, 0x0000005300807306ULL, 0x000ff00000005400ULL,
0x0000005300817306ULL, 0x0003f0000000d400ULL, 0x0000009f00a97306ULL, 0x000fe20000209400ULL,
0x000000005050783bULL, 0x002e6e0000000200ULL, 0x0000009f00a87306ULL, 0x0004f00000205400ULL,
0x000000a500ab7306ULL, 0x000fe20000209400ULL, 0x0000009f009f7245ULL, 0x004fce000020d400ULL,
0x000000a500ae7306ULL, 0x0004620000205400ULL, 0x000000a8a900720bULL, 0x008fce0003fdd000ULL,
0x0000005e005f7306ULL, 0x000fe20000209400ULL, 0x000000a500a57245ULL, 0x004fca000020d400ULL,
0x000000019f9f6812ULL, 0x000fe400078efcffULL, 0x0000005e00ba7306ULL, 0x000ea20000205400ULL,
0x000000aeab00720bULL, 0x002fe20003f9d000ULL, 0x000000185030723cULL, 0x000b620000041830ULL,
0x000000989500720bULL, 0x000fca0003fdd000ULL, 0x0000008200837306ULL, 0x000fe20000209400ULL,
0x000000ad00197245ULL, 0x020fca000020d400ULL, 0x00000001a5a54812ULL, 0x000fe400078efcffULL,
0x0000008200847306ULL, 0x0002e20000205400ULL, 0x000000ba5f00720bULL, 0x004fe40003fbd000ULL,
0x000000017a7a6812ULL, 0x000fe400078efcffULL, 0x000000807f00720bULL, 0x000fe40003fdd000ULL,
0x000000b5007f7245ULL, 0x000fe2000020d400ULL, 0x000000b900b67306ULL, 0x000fe20000209400ULL,
0x0000008200827245ULL, 0x002fc4000020d400ULL, 0x00000078a578723eULL, 0x000fc600000010ffULL,
0x0000000193935812ULL, 0x000fe400078efcffULL, 0x000000b900b37306ULL, 0x0002a20000205400ULL,
0x000000848300720bULL, 0x008fe40003f3d000ULL, 0x0000000181816812ULL, 0x000fca00078efcffULL,
0x000000ad00b07306ULL, 0x000fe20000209400ULL, 0x000000b900b97245ULL, 0x002fca000020d400ULL,
0x0000000182821812ULL, 0x000fe400078efcffULL, 0x000000ad00b17306ULL, 0x000e620000205400ULL,
0x000000b3b600720bULL, 0x004fe40003f5d000ULL, 0x000000938293723eULL, 0x000fca00000010ffULL,
0x0000008c008f7306ULL, 0x000fe40000209400ULL, 0x00000092504c723cULL, 0x080f68000004184cULL,
0x00000001b9b92812ULL, 0x000fe400078efcffULL, 0x0000008c00967306ULL, 0x0004e20000205400ULL,
0x000000b1b000720bULL, 0x002fe20003fbd000ULL, 0x000000925448723cULL, 0x000f6c0000041848ULL,
0x00000079009a7306ULL, 0x000fe20000209400ULL, 0x0000008c008c7245ULL, 0x004fca000020d400ULL,
0x0000000119195812ULL, 0x000fe400078efcffULL, 0x00000079009b7306ULL, 0x0002a20000205400ULL,
0x000000968f00720bULL, 0x008fce0003f3d000ULL, 0x0000009c00a07306ULL, 0x000fe20000209400ULL,
0x0000009f5c79723eULL, 0x002fca00000010ffULL, 0x000000018c8c1812ULL, 0x000fe400078efcffULL,
0x0000009c00a17306ULL, 0x0002e20000205400ULL, 0x0000009b9a00720bULL, 0x004fe20003f7d000ULL,
0x000000785038723cULL, 0x000f620000041838ULL, 0x000000198c19723eULL, 0x000fca00000010ffULL,
0x000000af00ab7306ULL, 0x000fe20000209400ULL, 0x0000009c009c7245ULL, 0x002fe2000020d400ULL,
0x00000078543c723cULL, 0x000f68000004183cULL, 0x0000000128283812ULL, 0x000fe400078efcffULL,
0x000000af00a47306ULL, 0x000e620000205400ULL, 0x000000a1a000720bULL, 0x008fe40003f9d000ULL,
0x0000007d7c00720bULL, 0x000fc40003f7d000ULL, 0x0000009d289d723eULL, 0x000fe400000010ffULL,
0x000000b700287245ULL, 0x000fe2000020d400ULL, 0x000000b2005d7306ULL, 0x000fec0000209400ULL,
0x000000019c9c4812ULL, 0x000fe400078efcffULL, 0x000000b200987306ULL, 0x000ea20000205400ULL,
0x000000a4ab00720bULL, 0x002fc40003f5d000ULL, 0x000000868700720bULL, 0x000fe40003f9d000ULL,
0x000000017e7e3812ULL, 0x000fe400078efcffULL, 0x000000759c9c723eULL, 0x000fe200000010ffULL,
0x00000088008e7306ULL, 0x000fec0000209400ULL, 0x000000012a2a2812ULL, 0x000fe200078efcffULL,
0x0000009c5040723cULL, 0x000f620000041840ULL, 0x00000088008b7306ULL, 0x0002e20000205400ULL,
0x000000985d00720bULL, 0x004fc40003fbd000ULL, 0x000000017b7b4812ULL, 0x000fc800078efcffULL,
0x0000007b2a2a723eULL, 0x000fe200000010ffULL, 0x000000b400587306ULL, 0x000fe20000209400ULL,
0x0000008800887245ULL, 0x002fe2000020d400ULL, 0x0000009c5444723cULL, 0x000f680000041844ULL,
0x000000012b2b5812ULL, 0x000fe400078efcffULL, 0x000000b400297306ULL, 0x000e620000205400ULL,
0x0000008b8e00720bULL, 0x008fce0003f3d000ULL, 0x000000b500597306ULL, 0x000fec0000209400ULL,
0x0000000188881812ULL, 0x000fe400078efcffULL, 0x000000b500187306ULL, 0x000ea20000205400ULL,
0x000000295800720bULL, 0x002fe40003f5d000ULL, 0x000000b400297245ULL, 0x000fc4000020d400ULL,
0x0000009100587245ULL, 0x000fe4000020d400ULL, 0x0000002b882b723eULL, 0x000fe200000010ffULL,
0x0000008a00897306ULL, 0x000fec0000209400ULL, 0x0000000129292812ULL, 0x000fe200078efcffULL,
0x0000002a5024723cULL, 0x000f620000041824ULL, 0x0000008a00947306ULL, 0x0002e20000205400ULL,
0x000000185900720bULL, 0x004fc40003f3d000ULL, 0x0000007ab918723eULL, 0x000fe400000010ffULL,
0x0000007e297e723eULL, 0x000fe400000010ffULL, 0x000000ac00297245ULL, 0x000fe2000020d400ULL,
0x00000091008d7306ULL, 0x000fe20000209400ULL, 0x0000008a008a7245ULL, 0x002fe2000020d400ULL,
0x00000018502c723cULL, 0x000f68000004182cULL, 0x000000017f7f1812ULL, 0x000fc400078efcffULL,
0x0000009100907306ULL, 0x000e620000205400ULL, 0x000000948900720bULL, 0x008fe20003f9d000ULL,
0x000000185410723cULL, 0x040b6c0000041810ULL, 0x000000b7005a7306ULL, 0x000fe20000209400ULL,
0x0000000473187810ULL, 0x020fe20007ffe0ffULL, 0x0000002a540c723cULL, 0x000b66000004180cULL,
0x000000181800780cULL, 0x000fe20003f25270ULL, 0x000000ffff737224ULL, 0x000fe200078e0018ULL,
0x000000018a8a4812ULL, 0x000fe200078efcffULL, 0x000000b7005b7306ULL, 0x000ea20000205400ULL,
0x000000908d00720bULL, 0x002fc40003fbd000ULL, 0x0000007f8a7f723eULL, 0x000fca00000010ffULL,
0x000000ac005c7306ULL, 0x000fe40000209400ULL, 0x0000007e5014723cULL, 0x080b680000041814ULL,
0x0000000158585812ULL, 0x000fe400078efcffULL, 0x000000ac005d7306ULL, 0x000e620000205400ULL,
0x0000005b5a00720bULL, 0x004fe20003f5d000ULL, 0x0000007e5408723cULL, 0x000b580000041808ULL,
0x0000000128282812ULL, 0x000fe400078efcffULL, 0x0000005d5c00720bULL, 0x002fe40003f7d000ULL,
0x000000812828723eULL, 0x000fd600000010ffULL, 0x0000000129293812ULL, 0x000fc800078efcffULL,
0x000000295829723eULL, 0x000fce00000010ffULL, 0x000000285020723cULL, 0x080b700000041820ULL,
0x000000285404723cULL, 0x000b620000041804ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffdee000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff727224ULL, 0x000fe200078e0070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd12000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x000000664c587220ULL, 0x080fe20000410000ULL, 0x000000664d567220ULL, 0x0a0fe20000410000ULL,
0x000000664e187220ULL, 0x080fe20000410000ULL, 0x000000664f197220ULL, 0x080fe20000410000ULL,
0x0000006632327220ULL, 0x080fe20000410000ULL, 0x0000006633337220ULL, 0x080fe20000410000ULL,
0x000000663b3b7220ULL, 0x080fe20000410000ULL, 0x0000006643437220ULL, 0x080fe20000410000ULL,
0x000000662e2e7220ULL, 0x080fe20000410000ULL, 0x000000662f2f7220ULL, 0x080fe20000410000ULL,
0x00000066144f7220ULL, 0x080fe20000410000ULL, 0x00000066154e7220ULL, 0x080fe20000410000ULL,
0x00000066204d7220ULL, 0x080fe20000410000ULL, 0x00000066214c7220ULL, 0x080fe20000410000ULL,
0x000000663a3a7220ULL, 0x080fe20000410000ULL, 0x0000006626267220ULL, 0x080fe20000410000ULL,
0x0000006627277220ULL, 0x080fe20000410000ULL, 0x0000006616167220ULL, 0x080fe20000410000ULL,
0x0000006617177220ULL, 0x080fe20000410000ULL, 0x0000006622227220ULL, 0x080fe20000410000ULL,
0x0000006623237220ULL, 0x080fe20000410000ULL, 0x000000663c147220ULL, 0x080fe20000410000ULL,
0x000000663d157220ULL, 0x080fe20000410000ULL, 0x0000006648207220ULL, 0x080fe20000410000ULL,
0x0000006649217220ULL, 0x080fe20000410000ULL, 0x0000006608087220ULL, 0x080fe20000410000ULL,
0x00000066305b7220ULL, 0x080fe20000410000ULL, 0x0000006641557220ULL, 0x080fe20000410000ULL,
0x0000006631537220ULL, 0x080fe20000410000ULL, 0x0000006640597220ULL, 0x080fe20000410000ULL,
0x0000006642417220ULL, 0x080fe20000410000ULL, 0x000000662c577220ULL, 0x080fe20000410000ULL,
0x000000662d527220ULL, 0x080fe20000410000ULL, 0x0000006624517220ULL, 0x080fe20000410000ULL,
0x0000006625507220ULL, 0x080fe20000410000ULL, 0x0000006644307220ULL, 0x080fe20000410000ULL,
0x000000664a5c7220ULL, 0x080fe20000410000ULL, 0x000000664b5d7220ULL, 0x080fe20000410000ULL,
0x00000066385a7220ULL, 0x080fe20000410000ULL, 0x0000006639547220ULL, 0x080fe20000410000ULL,
0x00000066342d7220ULL, 0x080fe20000410000ULL, 0x00000066352c7220ULL, 0x080fe20000410000ULL,
0x00000066362a7220ULL, 0x080fe20000410000ULL, 0x0000006637287220ULL, 0x080fe20000410000ULL,
0x000000663e297220ULL, 0x080fe20000410000ULL, 0x000000663f2b7220ULL, 0x080fe20000410000ULL,
0x0000006645317220ULL, 0x080fe20000410000ULL, 0x0000006646247220ULL, 0x080fe20000410000ULL,
0x0000006647257220ULL, 0x080fe20000410000ULL, 0x000000ffff407224ULL, 0x000fe200078e0032ULL,
0x0000006610347220ULL, 0x080fe20000410000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e0033ULL,
0x0000006611357220ULL, 0x080fe20000410000ULL, 0x000000ffff427224ULL, 0x000fe200078e003bULL,
0x0000006612127220ULL, 0x080fe20000410000ULL, 0x000000ffff497224ULL, 0x000fe200078e0043ULL,
0x0000006613137220ULL, 0x080fe20000410000ULL, 0x000000ffff447224ULL, 0x000fe200078e002eULL,
0x000000660c367220ULL, 0x080fe20000410000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e002fULL,
0x000000660d377220ULL, 0x080fe20000410000ULL, 0x000000660e0e7220ULL, 0x080fe20000410000ULL,
0x000000660f0f7220ULL, 0x080fe20000410000ULL, 0x0000006609387220ULL, 0x080fe20000410000ULL,
0x000000660a0a7220ULL, 0x080fe20000410000ULL, 0x000000660b0b7220ULL, 0x080fe20000410000ULL,
0x0000006604397220ULL, 0x080fe20000410000ULL, 0x0000006605057220ULL, 0x080fe20000410000ULL,
0x0000006606067220ULL, 0x080fe20000410000ULL, 0x0000006607077220ULL, 0x000fe20000410000ULL,
0x000000ffff3f7224ULL, 0x000fc400078e003aULL, 0x000000ffff437224ULL, 0x000fe400078e0018ULL,
0x000000ffff457224ULL, 0x000fe400078e0019ULL, 0x000000ffff467224ULL, 0x000fe400078e0026ULL,
0x000000ffff487224ULL, 0x000fe400078e0027ULL, 0x000000ffff477224ULL, 0x000fe400078e0016ULL,
0x000000ffff3e7224ULL, 0x000fc400078e0017ULL, 0x000000ffff3d7224ULL, 0x000fe400078e0022ULL,
0x000000ffff3c7224ULL, 0x000fe400078e0023ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0014ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0015ULL, 0x000000ffff327224ULL, 0x000fe400078e0020ULL,
0x000000ffff337224ULL, 0x000fc400078e0021ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000068087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff277224ULL, 0x000fe400078e0024ULL, 0x000000ffff267224ULL, 0x000fe400078e0025ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0005ULL, 0x000000ffff257224ULL, 0x000fe400078e005cULL,
0x000000ffff237224ULL, 0x000fc400078e005dULL, 0x000000ffff247224ULL, 0x000fe400078e0012ULL,
0x000000ffff227224ULL, 0x000fe400078e0013ULL, 0x000000ffff217224ULL, 0x000fe400078e000eULL,
0x000000ffff207224ULL, 0x000fe400078e000fULL, 0x000000ffff197224ULL, 0x000fe400078e000aULL,
0x000000ffff187224ULL, 0x000fc400078e000bULL, 0x000000ffff177224ULL, 0x000fe400078e0006ULL,
0x000000ffff167224ULL, 0x000fc400078e0007ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x0000040068077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040068077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000467157824ULL, 0x000fe200078e00ffULL, 0x0000001d6e00720cULL, 0x000fc80003f06070ULL,
0xfffffff015147812ULL, 0x000fca00078ec0ffULL, 0x000000801f147824ULL, 0x000fca00078e0214ULL,
0x0124000014047984ULL, 0x0002a20000000c00ULL, 0x000021f000008947ULL, 0x000fea0003800000ULL,
0x00005a00000b7b06ULL, 0x000ee20000209000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x0000001e670a7211ULL, 0x040fe200078ff0ffULL, 0x00000002675d7824ULL, 0x000fe200078e00ffULL,
0x00005a00ff137a12ULL, 0x000fe400078e33ffULL, 0x000000100a0e7810ULL, 0x000fe40007ffe0ffULL,
0x000000065d5d7812ULL, 0x000fca00078ec0ffULL, 0x000000015d5f7824ULL, 0x000fe200078e0261ULL,
0x0000000b000b7308ULL, 0x008ee40000001000ULL, 0x0ffffffe0b0d7810ULL, 0x008fcc0007ffe0ffULL,
0x0000000d00097305ULL, 0x000ee4000021f000ULL, 0x000000ffff0f7224ULL, 0x008fc800078e0a09ULL,
0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL, 0x0000000f090f7227ULL, 0x000fe200078e0008ULL,
0x000000080a097810ULL, 0x000fca0007ffe0ffULL, 0x000000090f0c7227ULL, 0x000fc800078e00ffULL,
0x0000000a0f087227ULL, 0x000fc800078e00ffULL, 0x000000ffff127224ULL, 0x000fe400078e0a0cULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a08ULL, 0x00005a00120d7a24ULL, 0x000fe400078e0209ULL,
0x00005a000b0b7a24ULL, 0x000fe200078e020aULL, 0x000000180a0a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000e0f107227ULL, 0x000fe200078e00ffULL, 0x00005a000d007a0cULL, 0x000fe40003fa6070ULL,
0x00005a000b007a0cULL, 0x000fe20003f06070ULL, 0x0000000a0f127227ULL, 0x000fc800078e00ffULL,
0x000000ffff097224ULL, 0x000fe400078e0a10ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a12ULL,
0x00005a00090e7a24ULL, 0x000fe400078e020eULL, 0x00005a000f0a7a24ULL, 0x000fe200078e020aULL,
0x80005a000d0d5a10ULL, 0x000fe20007ffe0ffULL, 0x000001006e097824ULL, 0x000fe200078e0265ULL,
0x00005a000e007a0cULL, 0x000fe40003f26070ULL, 0x80005a000b0b0a10ULL, 0x000fc40007ffe0ffULL,
0x00005a000a007a0cULL, 0x000fe40003f66070ULL, 0x00005a000d007a0cULL, 0x000fe40003fc6070ULL,
0x000000091c5c7217ULL, 0x000fe40007800000ULL, 0x00005a000b007a0cULL, 0x000fe20003f46070ULL,
0x000000016b0b7824ULL, 0x000fe200078e025dULL, 0x000000010c0c5810ULL, 0x000fe20007ffe0ffULL,
0x000000015c5c7824ULL, 0x000fe200078e0a09ULL, 0x80005a000e0e1a10ULL, 0x000fc40007ffe0ffULL,
0x0000000108080810ULL, 0x000fe20007ffe0ffULL, 0x000000015f097824ULL, 0x100fe200078e0a5cULL,
0x0000005c0b00720cULL, 0x040fe20003f06070ULL, 0x000000010b0b7824ULL, 0x000fe200078e0a5cULL,
0x80005a000a0a3a10ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL,
0x000000010c0c6810ULL, 0x000fe40007ffe0ffULL, 0x00005a000e007a0cULL, 0x000fc40003f86070ULL,
0x0000000108082810ULL, 0x000fe40007ffe0ffULL, 0x00005a000a007a0cULL, 0x000fe40003f46070ULL,
0x000000096a7d7217ULL, 0x040fe40003800000ULL, 0x0000000b6a0b7217ULL, 0x000fe40003800000ULL,
0x0000000c130d7207ULL, 0x040fe40006800000ULL, 0x0000000813097207ULL, 0x000fc40006800000ULL,
0x00000004ff0b7819ULL, 0x000fe4000001160bULL, 0x0000000d6a0f7217ULL, 0x040fe40003800000ULL,
0x000000096a097217ULL, 0x000fe40003800000ULL, 0x0000000110101810ULL, 0x000fe20007ffe0ffULL,
0x0000000f648c7224ULL, 0x040fe200078e02ffULL, 0x0000005c5f00720cULL, 0x000fe20003fc6070ULL,
0x0000000964887224ULL, 0x000fe200078e02ffULL, 0x0000000112123810ULL, 0x000fc40007ffe0ffULL,
0x000000ff0b0d7207ULL, 0x000fe40000000000ULL, 0x0000000110104810ULL, 0x000fe40007ffe0ffULL,
0x000000ff7d7d7207ULL, 0x000fe20003000000ULL, 0x000000010d0f7824ULL, 0x000fe200078e028cULL,
0x0000000112122810ULL, 0x000fe20007ffe0ffULL, 0x00000001880b7824ULL, 0x000fe200078e020dULL,
0x0000001013117207ULL, 0x000fe20006800000ULL, 0x000000020f0e7825ULL, 0x000fe200078e0002ULL,
0x000000105d777812ULL, 0x000fc400078efcffULL, 0x000000887d097211ULL, 0x000fe200078fe0ffULL,
0x000000020b0a7825ULL, 0x000fe200078e0002ULL, 0x0000001213137207ULL, 0x000fe20006800000ULL,
0x000000060e6f7981ULL, 0x0046a2000c1e9500ULL, 0x000000116a117217ULL, 0x040fe20003800000ULL,
0x000000016b797824ULL, 0x000fe200078e0277ULL, 0x000000136a137217ULL, 0x000fe20003800000ULL,
0x0000000209087825ULL, 0x000fe200078e0002ULL, 0x000000060a5e7981ULL, 0x0002a6000c1e9500ULL,
0x00000011648e7224ULL, 0x040fe200078e02ffULL, 0x00000006086d7981ULL, 0x0002a2000c1e9500ULL,
0x00000001790f7824ULL, 0x008fe200078e0a5cULL, 0x0000008c7d117211ULL, 0x040fe200078fe0ffULL,
0x0000001364907224ULL, 0x000fe200078e02ffULL, 0x0000008e7d137211ULL, 0x000fe200078fe0ffULL,
0x000000010d717824ULL, 0x040fe200078e028eULL, 0x0000000f6a0e7217ULL, 0x000fe20003800000ULL,
0x000000010d757824ULL, 0x000fc400078e0290ULL, 0x00000002110c7825ULL, 0x000fe200078e0002ULL,
0x0000005c7900720cULL, 0x000fe40003f26070ULL, 0x00000004ff0e7819ULL, 0x000fe2000001160eULL,
0x0000000271107825ULL, 0x100fe200078e0002ULL, 0x000000060c727981ULL, 0x0006a6000c1e9500ULL,
0x00000002130a7825ULL, 0x102fe200078e0002ULL, 0x0000000610717981ULL, 0x0002a6000c1e9500ULL,
0x0000000275127825ULL, 0x000fe200078e0002ULL, 0x000000060a747981ULL, 0x0002a2000c1e9500ULL,
0x000000ff0e0d7207ULL, 0x008fc40000800000ULL, 0x0000000177757824ULL, 0x000fe200078e0261ULL,
0x000000907d737211ULL, 0x000fc600078fe0ffULL, 0x00000001750f7824ULL, 0x040fe400078e0a5cULL,
0x00000001880b7824ULL, 0x002fe200078e020dULL, 0x0000005c7500720cULL, 0x000fe20003f06070ULL,
0x0000000273087825ULL, 0x100fe200078e0002ULL, 0x0000000f6a0f7217ULL, 0x000fe20003800000ULL,
0x0000000612737981ULL, 0x0002e4000c1e9500ULL, 0x000000020b0a7825ULL, 0x000fe200078e0002ULL,
0x000000ff0f827207ULL, 0x000fe20000000000ULL, 0x0000000608767981ULL, 0x0002e4000c1e9500ULL,
0x000000010d817824ULL, 0x000fc400078e0290ULL, 0x000000060a787981ULL, 0x0002e2000c1e9500ULL,
0x000000010d7b7824ULL, 0x000fe200078e028cULL, 0x0000008c820f7211ULL, 0x040fe400078fe0ffULL,
0x0000008e82137211ULL, 0x042fe400078fe0ffULL, 0x0000008882097211ULL, 0x000fe200078fe0ffULL,
0x00000002810a7825ULL, 0x000fe200078e0002ULL, 0x000000205d817812ULL, 0x000fc600078efcffULL,
0x000000027b7a7825ULL, 0x000fc800078e0002ULL, 0x000000010d117824ULL, 0x000fe200078e028eULL,
0x00000090827f7211ULL, 0x000fe200078fe0ffULL, 0x000000016b877824ULL, 0x000fe200078e0281ULL,
0x000000067a7a7981ULL, 0x0002e2000c1e9500ULL, 0x0000000209087825ULL, 0x000fc600078e0002ULL,
0x000000060a7e7981ULL, 0x0002e2000c1e9500ULL, 0x000000020f0c7825ULL, 0x000fc600078e0002ULL,
0x0000000608797981ULL, 0x0002e2000c1e9500ULL, 0x00000002130e7825ULL, 0x000fc600078e0002ULL,
0x000000060c7b7981ULL, 0x0022e2000c1e9500ULL, 0x0000000187137824ULL, 0x000fe400078e0a5cULL,
0x0000000181837824ULL, 0x000fc600078e0261ULL, 0x000000136a127217ULL, 0x040fe20003800000ULL,
0x0000000183137824ULL, 0x000fe200078e0a5cULL, 0x0000005c8700720cULL, 0x080fe40003f26070ULL,
0x00000004ff127819ULL, 0x000fe20000011612ULL, 0x0000000211107825ULL, 0x100fe200078e0002ULL,
0x0000005c8300720cULL, 0x000fe40003f06070ULL, 0x000000136a137217ULL, 0x000fe20003800000ULL,
0x000000027f087825ULL, 0x000fe200078e0002ULL, 0x000000ff120b7207ULL, 0x000fe20000800000ULL,
0x00000006107c7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff13977207ULL, 0x000fc60000000000ULL,
0x000000060e7f7981ULL, 0x0002e2000c1e9500ULL, 0x000000010b877824ULL, 0x000fc600078e028cULL,
0x0000000608857981ULL, 0x0002e4000c1e9500ULL, 0x0000008c97117211ULL, 0x002fe200078fe0ffULL,
0x0000000287867825ULL, 0x000fe200078e0002ULL, 0x00000090978b7211ULL, 0x000fc600078fe0ffULL,
0x0000000188097824ULL, 0x000fe200078e020bULL, 0x0000008897137211ULL, 0x000fe200078fe0ffULL,
0x0000000211107825ULL, 0x100fe200078e0002ULL, 0x0000000686867981ULL, 0x0002e6000c1e9500ULL,
0x0000000209087825ULL, 0x000fe200078e0002ULL, 0x0000008e970d7211ULL, 0x000fc800078fe0ffULL,
0x0000000608807981ULL, 0x0002e2000c1e9500ULL, 0x000000010b0f7824ULL, 0x000fc600078e028eULL,
0x0000000610877981ULL, 0x0022e2000c1e9500ULL, 0x0000000213127825ULL, 0x000fc800078e0002ULL,
0x000000028b087825ULL, 0x000fe200078e0002ULL, 0x000000305d8b7812ULL, 0x000fe200078efcffULL,
0x0000000612897981ULL, 0x0002e4000c1e9500ULL, 0x000000010b0b7824ULL, 0x000fe400078e0290ULL,
0x000000016b917824ULL, 0x000fe200078e028bULL, 0x0000000608d97981ULL, 0x0002e2000c1e9500ULL,
0x000000020f0e7825ULL, 0x000fc800078e0002ULL, 0x000000020d0c7825ULL, 0x100fe200078e0002ULL,
0x000000060e847981ULL, 0x0002e6000c1e9500ULL, 0x000000020b0a7825ULL, 0x000fe200078e0002ULL,
0x000000060c8f7981ULL, 0x0002e6000c1e9500ULL, 0x0000000191137824ULL, 0x002fe200078e0a5cULL,
0x000000060a987981ULL, 0x0002e2000c1e9500ULL, 0x000000018b8d7824ULL, 0x000fc600078e0261ULL,
0x000000136a127217ULL, 0x040fe20003800000ULL, 0x000000018d137824ULL, 0x000fe200078e0a5cULL,
0x0000005c9100720cULL, 0x080fe40003f26070ULL, 0x0000005c8d00720cULL, 0x000fe40003f06070ULL,
0x00000004ff127819ULL, 0x000fe40000011612ULL, 0x000000136a137217ULL, 0x000fe40003800000ULL,
0x000000ff12917207ULL, 0x000fc40000800000ULL, 0x000000ff139d7207ULL, 0x000fc60000000000ULL,
0x0000000188117824ULL, 0x000fe200078e0291ULL, 0x000000889d137211ULL, 0x000fe200078fe0ffULL,
0x00000001910d7824ULL, 0x000fe200078e028eULL, 0x0000008e9d0f7211ULL, 0x000fe200078fe0ffULL,
0x0000000211107825ULL, 0x000fc800078e0002ULL, 0x0000000213127825ULL, 0x100fe200078e0002ULL,
0x00000006108a7981ULL, 0x0002e6000c1e9500ULL, 0x000000020d0c7825ULL, 0x100fe200078e0002ULL,
0x0000000612bf7981ULL, 0x0002e6000c1e9500ULL, 0x000000020f0e7825ULL, 0x000fe200078e0002ULL,
0x000000060c967981ULL, 0x0002e4000c1e9500ULL, 0x0000008c9d0b7211ULL, 0x002fc400078fe0ffULL,
0x000000060ed77981ULL, 0x0002e2000c1e9500ULL, 0x0000000191097824ULL, 0x000fe400078e028cULL,
0x000000020b0a7825ULL, 0x000fc800078e0002ULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x000000060ad57981ULL, 0x0002e2000c1e9500ULL, 0x000000909d117211ULL, 0x000fc600078fe0ffULL,
0x0000000608947981ULL, 0x0002e2000c1e9500ULL, 0x0000000191137824ULL, 0x000fe400078e0290ULL,
0x0000000211107825ULL, 0x000fc800078e0002ULL, 0x0000000213127825ULL, 0x000fe200078e0002ULL,
0x0000000610db7981ULL, 0x0002e8000c1e9500ULL, 0x00000006129a7981ULL, 0x0002e2000c1e9500ULL,
0xfffffff07d7d7812ULL, 0x000fe200078ec0ffULL, 0x00000001ffd37424ULL, 0x000fc800078e00ffULL,
0x000000015c087824ULL, 0x002fc800078e027dULL, 0x000000015f097824ULL, 0x000fe200078e0a08ULL,
0x000000015d917812ULL, 0x000fc800078efcffULL, 0x00000009d3097219ULL, 0x000fe200000006ffULL,
0x00000001910b7824ULL, 0x000fe200078e0261ULL, 0xfffffff0820d7812ULL, 0x000fc600078ec0ffULL,
0x000000010b0a7824ULL, 0x100fe200078e0a08ULL, 0x000000085d937812ULL, 0x040fe200078efcffULL,
0x000000015c0e7824ULL, 0x000fe200078e020dULL, 0x000000095d957812ULL, 0x000fe400078efcffULL,
0x0000000ad30d7219ULL, 0x000fe200000006ffULL, 0x00000001930f7824ULL, 0x100fe400078e0261ULL,
0x0000000195137824ULL, 0x000fe400078e0261ULL, 0x000000010f0c7824ULL, 0x000fc400078e0a08ULL,
0x0000000113087824ULL, 0x000fe200078e0a08ULL, 0x000000115d997812ULL, 0x000fe400078efcffULL,
0x0000000cd3117219ULL, 0x040fe400000006ffULL, 0x00000008d37d7219ULL, 0x000fe200000006ffULL,
0x00000001999b7824ULL, 0x000fe200078e0261ULL, 0xfffffff097977812ULL, 0x000fe200078ec0ffULL,
0x0000000175087824ULL, 0x100fe200078e0a0eULL, 0xfffffff09d9d7812ULL, 0x000fe200078ec0ffULL,
0x000000019b0a7824ULL, 0x000fe200078e0a0eULL, 0x000000185d9f7812ULL, 0x000fe200078efcffULL,
0x000000015c107824ULL, 0x000fe200078e0297ULL, 0x000054106d5e7816ULL, 0x004fc8000000005eULL,
0x0000005e09ff7212ULL, 0x000fc800078ac0ffULL, 0x0000005c5f00720cULL, 0x000fc80002fa1470ULL,
0x0000005c5d00720cULL, 0x000fe40002fa1070ULL, 0x0000541072727816ULL, 0x000fe4000000006fULL,
0xff8000005b5b7808ULL, 0x000fe40002800000ULL, 0x0000005e0dff7212ULL, 0x000fe4000782c0ffULL,
0x0000541074747816ULL, 0x000fe40000000071ULL, 0x0000007209ff7212ULL, 0x000fc4000784c0ffULL,
0x0000007409ff7212ULL, 0x000fe4000788c0ffULL, 0x000000720dff7212ULL, 0x000fe400078ac0ffULL,
0x0000005c5f00720cULL, 0x0c0fe40001741470ULL, 0x0000005c5f00720cULL, 0x080fe40002781470ULL,
0x0000005c0b00720cULL, 0x0c0fe40000f21470ULL, 0x0000005c0b00720cULL, 0x000fc40002fa1470ULL,
0x0000005c5d00720cULL, 0x0c0fe40001741070ULL, 0x0000005c5d00720cULL, 0x080fe40002781070ULL,
0x0000005c9100720cULL, 0x0c0fe40000f21070ULL, 0x0000005c9100720cULL, 0x000fe40002fa1070ULL,
0x0000541076767816ULL, 0x008fe40000000073ULL, 0xff80000040407808ULL, 0x000fc40001000000ULL,
0xff8000002d2d7808ULL, 0x000fe40002000000ULL, 0xff80000053537808ULL, 0x000fe40000800000ULL,
0xff8000004b4b7808ULL, 0x000fe40002800000ULL, 0x0000005e11ff7212ULL, 0x000fe4000786c0ffULL,
0x0000007609ff7212ULL, 0x000fe4000780c0ffULL, 0x000000740dff7212ULL, 0x000fc4000784c0ffULL,
0x000000760dff7212ULL, 0x000fe4000788c0ffULL, 0x000000727dff7212ULL, 0x000fe4000782c0ffULL,
0x0000007411ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005c5f00720cULL, 0x080fe40000701470ULL,
0x0000005c0b00720cULL, 0x0c0fe40001741470ULL, 0x0000005c0b00720cULL, 0x000fc40002781470ULL,
0x0000005c0f00720cULL, 0x0c0fe40001f61470ULL, 0x0000005c0f00720cULL, 0x080fe40002fa1470ULL,
0x0000005c1300720cULL, 0x080fe20000f21470ULL, 0x000000015c8c7824ULL, 0x000fe200078e029dULL,
0x000000195da57812ULL, 0x040fe400078efcffULL, 0x0000005c5d00720cULL, 0x080fe40000701070ULL,
0x0000005c9100720cULL, 0x000fc40001741070ULL, 0x0000005c9100720cULL, 0x080fe40002781070ULL,
0x0000005c9300720cULL, 0x0c0fe40001f61070ULL, 0x0000005c9300720cULL, 0x080fe40002fa1070ULL,
0x0000005c9500720cULL, 0x000fe40000f21070ULL, 0x00000008d3977219ULL, 0x040fe400000006ffULL,
0x0000000ad39d7219ULL, 0x000fc400000006ffULL, 0x0000541079787816ULL, 0x000fe40000000078ULL,
0x000054107b7a7816ULL, 0x000fe2000000007aULL, 0x000000019fa17824ULL, 0x100fe200078e0261ULL,
0xff8000002a2a7808ULL, 0x000fe20000000000ULL, 0x00000001a5a77824ULL, 0x000fe200078e0261ULL,
0xff8000002c2c7808ULL, 0x000fe40001000000ULL, 0xff80000028287808ULL, 0x000fe40002000000ULL,
0xff8000005a5a7808ULL, 0x000fc40001800000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0xff80000042427808ULL, 0x000fe40000800000ULL, 0x0000007211ff7212ULL, 0x000fe4000780c0ffULL,
0x000000747dff7212ULL, 0x000fe4000784c0ffULL, 0x0000007611ff7212ULL, 0x080fe4000788c0ffULL,
0x000000767dff7212ULL, 0x000fc4000786c0ffULL, 0x000000789dff7212ULL, 0x000fe400078ac0ffULL,
0x0000007a97ff7212ULL, 0x000fe2000782c0ffULL, 0x00000001a10c7824ULL, 0x100fe200078e0a0eULL,
0x0000005c0f00720cULL, 0x080fe20000701470ULL, 0x00000001a70e7824ULL, 0x000fe200078e0a0eULL,
0x0000005c0f00720cULL, 0x080fe40002781470ULL, 0x0000005c1300720cULL, 0x0c0fe40001741470ULL,
0x0000005c1300720cULL, 0x000fc40001f61470ULL, 0x0000005c7500720cULL, 0x080fe40000f21470ULL,
0x0000005c9b00720cULL, 0x080fe40002fa1470ULL, 0x0000005c9300720cULL, 0x0c0fe40000701070ULL,
0x0000005c9300720cULL, 0x080fe40002781070ULL, 0x0000005c9500720cULL, 0x0c0fe40001741070ULL,
0x0000005c9500720cULL, 0x000fc40001f61070ULL, 0x0000005c7700720cULL, 0x080fe40000f21070ULL,
0x0000005c9900720cULL, 0x000fe40002fa1070ULL, 0x0000000cd3a37219ULL, 0x040fe400000006ffULL,
0x0000000ed3a97219ULL, 0x000fe400000006ffULL, 0x000054107f7c7816ULL, 0x000fe4000000007cULL,
0x00005410857e7816ULL, 0x000fc4000000007eULL, 0xff8000003f3f7808ULL, 0x000fe40000000000ULL,
0xff80000029297808ULL, 0x000fe40002000000ULL, 0xff8000002f2f7808ULL, 0x000fe40001000000ULL,
0xff8000002b2b7808ULL, 0x000fe40001800000ULL, 0xff80000041417808ULL, 0x000fe40000800000ULL,
0xff80000055557808ULL, 0x000fc40002800000ULL, 0x0000007897ff7212ULL, 0x080fe4000780c0ffULL,
0x00000078a3ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007c97ff7212ULL, 0x040fe4000784c0ffULL,
0x0000007e97ff7212ULL, 0x000fe4000786c0ffULL, 0x0000007c9dff7212ULL, 0x000fe4000782c0ffULL,
0x0000007aa9ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000183127824ULL, 0x000fe200078e0a10ULL,
0x0000005c7500720cULL, 0x000fc40000701470ULL, 0x0000005c7500720cULL, 0x0c0fe40001741470ULL,
0x0000005c7500720cULL, 0x080fe40001f61470ULL, 0x0000005c9b00720cULL, 0x080fe40000f21470ULL,
0x0000005ca100720cULL, 0x080fe40002781470ULL, 0x0000005ca700720cULL, 0x000fe40002fa1470ULL,
0x000000215dad7812ULL, 0x000fc400078efcffULL, 0x0000005c7700720cULL, 0x0c0fe40000701070ULL,
0x0000005c7700720cULL, 0x0c0fe40001741070ULL, 0x0000005c7700720cULL, 0x080fe40001f61070ULL,
0x0000005c9900720cULL, 0x080fe40000f21070ULL, 0x0000005c9f00720cULL, 0x080fe40002781070ULL,
0x0000005ca500720cULL, 0x000fc40002fa1070ULL, 0x00000012d3ab7219ULL, 0x000fe400000006ffULL,
0x0000541087867816ULL, 0x000fe20000000086ULL, 0x00000001adaf7824ULL, 0x000fe200078e0261ULL,
0xff80000059597808ULL, 0x000fe40000000000ULL, 0xff80000030307808ULL, 0x000fe40001000000ULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff80000031317808ULL, 0x000fc40000800000ULL,
0xff80000058587808ULL, 0x000fe40002000000ULL, 0xff80000045457808ULL, 0x000fe40002800000ULL,
0x0000007a9dff7212ULL, 0x040fe4000780c0ffULL, 0x0000007e9dff7212ULL, 0x000fe4000784c0ffULL,
0x0000007aa3ff7212ULL, 0x000fe4000786c0ffULL, 0x0000007ca9ff7212ULL, 0x000fc4000782c0ffULL,
0x0000007ea9ff7212ULL, 0x000fe4000788c0ffULL, 0x00000086abff7212ULL, 0x000fe200078ac0ffULL,
0x00000001af827824ULL, 0x000fe200078e0a10ULL, 0x0000005c9b00720cULL, 0x0c0fe40000701470ULL,
0x0000005c9b00720cULL, 0x080fe40001741470ULL, 0x0000005ca100720cULL, 0x080fe40001f61470ULL,
0x0000005ca700720cULL, 0x000fc40000f21470ULL, 0x0000005ca700720cULL, 0x080fe40002781470ULL,
0x0000005c8300720cULL, 0x080fe40002fa1470ULL, 0x000000285db37812ULL, 0x040fe400078efcffULL,
0x000000295db97812ULL, 0x000fe400078efcffULL, 0x0000005c9900720cULL, 0x0c0fe40000701070ULL,
0x0000005c9900720cULL, 0x000fc40001741070ULL, 0x0000005c9f00720cULL, 0x080fe40001f61070ULL,
0x0000005ca500720cULL, 0x0c0fe40000f21070ULL, 0x0000005ca500720cULL, 0x080fe40002781070ULL,
0x0000005c8100720cULL, 0x000fe40002fa1070ULL, 0x00000082d3b17219ULL, 0x000fe400000006ffULL,
0x0000541089807816ULL, 0x000fc40000000080ULL, 0x000054108f847816ULL, 0x000fe40000000084ULL,
0x00005410d9987816ULL, 0x000fe20000000098ULL, 0x00000001b3b57824ULL, 0x100fe200078e0261ULL,
0xff80000049497808ULL, 0x000fe20000000000ULL, 0x00000001b9bb7824ULL, 0x000fe200078e0261ULL,
0xff80000026267808ULL, 0x000fe40001000000ULL, 0xff80000043437808ULL, 0x000fe40001800000ULL,
0xff80000033337808ULL, 0x000fc40000800000ULL, 0xff80000023237808ULL, 0x000fe40002000000ULL,
0xff80000044447808ULL, 0x000fe40002800000ULL, 0x0000005e7dff7212ULL, 0x000fe400078cc0ffULL,
0x0000007ca3ff7212ULL, 0x040fe4000780c0ffULL, 0x0000007ea3ff7212ULL, 0x000fe4000784c0ffULL,
0x00000080abff7212ULL, 0x000fc4000786c0ffULL, 0x00000084abff7212ULL, 0x040fe4000782c0ffULL,
0x00000098abff7212ULL, 0x000fe4000788c0ffULL, 0x00000084b1ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b5887824ULL, 0x100fe200078e0a10ULL, 0x0000005c1300720cULL, 0x080fe200037c1470ULL,
0x00000001bb107824ULL, 0x000fe200078e0a10ULL, 0x0000005ca100720cULL, 0x0c0fe40000701470ULL,
0x0000005ca100720cULL, 0x000fc40001741470ULL, 0x0000005c8300720cULL, 0x0c0fe40001f61470ULL,
0x0000005c8300720cULL, 0x0c0fe40000f21470ULL, 0x0000005c8300720cULL, 0x080fe40002781470ULL,
0x0000005caf00720cULL, 0x080fe40002fa1470ULL, 0x0000005c9500720cULL, 0x080fe400037c1070ULL,
0x0000005c9f00720cULL, 0x000fc40000701070ULL, 0x0000005c9f00720cULL, 0x080fe40001741070ULL,
0x0000005c8100720cULL, 0x0c0fe40001f61070ULL, 0x0000005c8100720cULL, 0x0c0fe40000f21070ULL,
0x0000005c8100720cULL, 0x080fe40002781070ULL, 0x0000005cad00720cULL, 0x000fe40002fa1070ULL,
0x00000088d3b77219ULL, 0x000fc400000006ffULL, 0x00000010d3bd7219ULL, 0x000fe400000006ffULL,
0xff80000054547808ULL, 0x000fe40003000000ULL, 0xff80000032327808ULL, 0x000fe40000000000ULL,
0xff80000025257808ULL, 0x000fe40001000000ULL, 0xff80000057577808ULL, 0x000fe40001800000ULL,
0xff80000034347808ULL, 0x000fc40000800000ULL, 0xff80000024247808ULL, 0x000fe40002000000ULL,
0xff80000035357808ULL, 0x000fe40002800000ULL, 0x00000078a9ff7212ULL, 0x000fe400078cc0ffULL,
0x00000080b1ff7212ULL, 0x080fe4000780c0ffULL, 0x00000080b7ff7212ULL, 0x000fe4000784c0ffULL,
0x00000086b1ff7212ULL, 0x000fc4000786c0ffULL, 0x00000098b1ff7212ULL, 0x000fe4000782c0ffULL,
0x00000086b7ff7212ULL, 0x000fe4000788c0ffULL, 0x00000084bdff7212ULL, 0x000fe200078ac0ffULL,
0x000000018d8e7824ULL, 0x000fe200078e0a8cULL, 0x0000005ca700720cULL, 0x080fe400037c1470ULL,
0x0000005caf00720cULL, 0x0c0fe40000701470ULL, 0x0000005caf00720cULL, 0x000fc40001f61470ULL,
0x0000005caf00720cULL, 0x080fe40000f21470ULL, 0x0000005cb500720cULL, 0x0c0fe40001741470ULL,
0x0000005cb500720cULL, 0x080fe40002781470ULL, 0x0000005cbb00720cULL, 0x000fe40002fa1470ULL,
0x000000315dc37812ULL, 0x040fe400078efcffULL, 0x000000385dc97812ULL, 0x000fc400078efcffULL,
0x000000395dcf7812ULL, 0x000fe400078efcffULL, 0x0000005ca500720cULL, 0x080fe400037c1070ULL,
0x0000005cad00720cULL, 0x0c0fe40000701070ULL, 0x0000005cad00720cULL, 0x0c0fe40001f61070ULL,
0x0000005cad00720cULL, 0x080fe40000f21070ULL, 0x0000005cb300720cULL, 0x000fc40001741070ULL,
0x0000005cb300720cULL, 0x080fe40002781070ULL, 0x0000005cb900720cULL, 0x000fe40002fa1070ULL,
0x0000008ed3c17219ULL, 0x000fe400000006ffULL, 0x00005410bf8a7816ULL, 0x000fe4000000008aULL,
0x00005410d7967816ULL, 0x000fe20000000096ULL, 0x00000001c3c57824ULL, 0x100fe200078e0261ULL,
0xff80000056567808ULL, 0x000fe20003000000ULL, 0x00000001c9cb7824ULL, 0x100fe200078e0261ULL,
0xff80000052527808ULL, 0x000fe20000000000ULL, 0x00000001cfd17824ULL, 0x000fe200078e0261ULL,
0xff8000004a4a7808ULL, 0x000fc40001800000ULL, 0xff80000022227808ULL, 0x000fe40000800000ULL,
0xff80000051517808ULL, 0x000fe40001000000ULL, 0xff80000046467808ULL, 0x000fe40002000000ULL,
0xff80000037377808ULL, 0x000fe40002800000ULL, 0x00000080bdff7212ULL, 0x040fe400078cc0ffULL,
0x00000086bdff7212ULL, 0x000fc4000780c0ffULL, 0x00000084b7ff7212ULL, 0x040fe4000786c0ffULL,
0x00000098b7ff7212ULL, 0x080fe4000782c0ffULL, 0x00000098bdff7212ULL, 0x000fe4000784c0ffULL,
0x0000008ac1ff7212ULL, 0x040fe4000788c0ffULL, 0x00000096c1ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c5907824ULL, 0x100fe200078e0a8cULL, 0x0000005cb500720cULL, 0x080fe20001f61470ULL,
0x00000001cb927824ULL, 0x100fe200078e0a8cULL, 0x0000005cb500720cULL, 0x080fe20000f21470ULL,
0x00000001d18c7824ULL, 0x000fe200078e0a8cULL, 0x0000005cbb00720cULL, 0x000fc400037c1470ULL,
0x0000005cbb00720cULL, 0x0c0fe40000701470ULL, 0x0000005cbb00720cULL, 0x080fe40001741470ULL,
0x0000005c8d00720cULL, 0x0c0fe40002781470ULL, 0x0000005c8d00720cULL, 0x000fe40002fa1470ULL,
0x00000090d3c77219ULL, 0x040fe400000006ffULL, 0x00000092d3cd7219ULL, 0x000fc400000006ffULL,
0x0000005cb300720cULL, 0x0c0fe40001f61070ULL, 0x0000005cb300720cULL, 0x080fe40000f21070ULL,
0x0000005cb900720cULL, 0x0c0fe400037c1070ULL, 0x0000005cb900720cULL, 0x0c0fe40000701070ULL,
0x0000005cb900720cULL, 0x080fe40001741070ULL, 0x0000005c8b00720cULL, 0x000fc40002781070ULL,
0x0000005c8b00720cULL, 0x000fe40002fa1070ULL, 0x0000008cd3d37219ULL, 0x000fe400000006ffULL,
0x00005410d5947816ULL, 0x000fe40000000094ULL, 0xff80000036367808ULL, 0x000fe40001800000ULL,
0xff80000021217808ULL, 0x000fe40000800000ULL, 0xff80000050507808ULL, 0x000fc40003000000ULL,
0xff80000048487808ULL, 0x000fe40000000000ULL, 0xff80000020207808ULL, 0x000fe40001000000ULL,
0xff8000004f4f7808ULL, 0x000fe40002000000ULL, 0xff8000003b3b7808ULL, 0x000fe40002800000ULL,
0x0000008ac7ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008acdff7212ULL, 0x000fc4000782c0ffULL,
0x0000008ad3ff7212ULL, 0x000fe400078cc0ffULL, 0x00000094c1ff7212ULL, 0x080fe4000780c0ffULL,
0x00000094c7ff7212ULL, 0x080fe4000784c0ffULL, 0x00000094cdff7212ULL, 0x000fe4000788c0ffULL,
0x00000096c7ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005c8d00720cULL, 0x000fc40000701470ULL,
0x0000005cc500720cULL, 0x0c0fe40001f61470ULL, 0x0000005cc500720cULL, 0x0c0fe40001741470ULL,
0x0000005cc500720cULL, 0x080fe40002fa1470ULL, 0x0000005ccb00720cULL, 0x080fe40000f21470ULL,
0x0000005cd100720cULL, 0x080fe400037c1470ULL, 0x0000005ccb00720cULL, 0x000fc40002781470ULL,
0x0000005c8b00720cULL, 0x080fe40000701070ULL, 0x0000005cc300720cULL, 0x0c0fe40001f61070ULL,
0x0000005cc300720cULL, 0x0c0fe40001741070ULL, 0x0000005cc300720cULL, 0x080fe40002fa1070ULL,
0x0000005cc900720cULL, 0x080fe40000f21070ULL, 0x0000005ccf00720cULL, 0x000fc400037c1070ULL,
0x0000005cc900720cULL, 0x000fe40002781070ULL, 0x00005410db9a7816ULL, 0x000fe4000000009aULL,
0xff80000047477808ULL, 0x000fe40000000000ULL, 0xff8000004e4e7808ULL, 0x000fe40001800000ULL,
0xff8000003e3e7808ULL, 0x000fe40001000000ULL, 0xff80000038387808ULL, 0x000fc40002800000ULL,
0xff8000004d4d7808ULL, 0x000fe40000800000ULL, 0xff8000004c4c7808ULL, 0x000fe40003000000ULL,
0xff8000003d3d7808ULL, 0x000fe40002000000ULL, 0x00000094d3ff7212ULL, 0x000fe4000780c0ffULL,
0x00000096cdff7212ULL, 0x080fe4000786c0ffULL, 0x00000096d3ff7212ULL, 0x000fc4000784c0ffULL,
0x0000009ac1ff7212ULL, 0x080fe400078ac0ffULL, 0x0000009ac7ff7212ULL, 0x080fe4000782c0ffULL,
0x0000009acdff7212ULL, 0x080fe400078cc0ffULL, 0x0000009ad3ff7212ULL, 0x000fe4000788c0ffULL,
0x0000005c8d00720cULL, 0x080fe40002fa1470ULL, 0x0000005cc500720cULL, 0x000fc40000f21470ULL,
0x0000005ccb00720cULL, 0x0c0fe40001f61470ULL, 0x0000005ccb00720cULL, 0x080fe400037c1470ULL,
0x0000005cd100720cULL, 0x0c0fe40000701470ULL, 0x0000005cd100720cULL, 0x0c0fe40001741470ULL,
0x0000005cd100720cULL, 0x080fe40002781470ULL, 0x0000005c8b00720cULL, 0x000fc40002fa1070ULL,
0x0000005cc300720cULL, 0x080fe40000f21070ULL, 0x0000005ccf00720cULL, 0x080fe40000701070ULL,
0x0000005cc900720cULL, 0x0c0fe40001f61070ULL, 0x0000005cc900720cULL, 0x080fe400037c1070ULL,
0x0000005ccf00720cULL, 0x0c0fe40001741070ULL, 0x0000005ccf00720cULL, 0x000fc40002781070ULL,
0xff8000003c3c7808ULL, 0x000fe40000000000ULL, 0xff80000039397808ULL, 0x000fe40001800000ULL,
0xff8000003a3a7808ULL, 0x000fe40001000000ULL, 0xff80000019197808ULL, 0x000fe40002800000ULL,
0xff80000018187808ULL, 0x000fe40000800000ULL, 0xff80000017177808ULL, 0x000fc40003000000ULL,
0xff80000016167808ULL, 0x000fc40002000000ULL, 0x0000005b0400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff107424ULL, 0x000fe200078e00ffULL, 0x000000400500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x0000002d0600720bULL, 0x000fe40003f5e000ULL,
0x0000002a0700720bULL, 0x000fe40003f7e000ULL, 0x000000045b047208ULL, 0x000fe40004000000ULL,
0x0000000540087208ULL, 0x000fc40004800000ULL, 0x000000062d057208ULL, 0x000fe40005000000ULL,
0x000000072a077208ULL, 0x000fe40005800000ULL, 0x000000530400720bULL, 0x000fe40003f1e000ULL,
0x0000002c0500720bULL, 0x000fe40003f5e000ULL, 0x0000004b0800720bULL, 0x000fe40003f3e000ULL,
0x000000280700720bULL, 0x000fc40003f7e000ULL, 0x0000000453097208ULL, 0x000fe40004000000ULL,
0x000000052c057208ULL, 0x000fe40005000000ULL, 0x000000084b087208ULL, 0x000fe40004800000ULL,
0x0000000728047208ULL, 0x000fe40005800000ULL, 0x0000005a0900720bULL, 0x000fe40003f1e000ULL,
0x0000002e0500720bULL, 0x000fc40003f5e000ULL, 0x0000003f0800720bULL, 0x000fe40003f3e000ULL,
0x000000290400720bULL, 0x000fe40003f7e000ULL, 0x000000095a097208ULL, 0x000fe40004000000ULL,
0x000000052e067208ULL, 0x000fe40005000000ULL, 0x000000083f077208ULL, 0x000fe40004800000ULL,
0x0000000429047208ULL, 0x000fc40005800000ULL, 0x000000540900720bULL, 0x000fe40003f1e000ULL,
0x0000002f0600720bULL, 0x000fe40003f5e000ULL, 0x000000420700720bULL, 0x000fe40003f3e000ULL,
0x0000002b0400720bULL, 0x000fe40003f7e000ULL, 0x0000000954087208ULL, 0x000fe40004000000ULL,
0x000000062f057208ULL, 0x000fc40005000000ULL, 0x00000007420a7208ULL, 0x000fe40004800000ULL,
0x000000042b047208ULL, 0x000fe40005800000ULL, 0x000000590800720bULL, 0x000fe40003f1e000ULL,
0x000000300500720bULL, 0x000fe40003f5e000ULL, 0x000000410a00720bULL, 0x000fe40003f3e000ULL,
0x000000270400720bULL, 0x000fc40003f7e000ULL, 0x0000000859087208ULL, 0x000fe40004000000ULL,
0x0000000530067208ULL, 0x000fe40005000000ULL, 0x0000000a410a7208ULL, 0x000fe40004800000ULL,
0x0000000427057208ULL, 0x000fe40005800000ULL, 0x000000550800720bULL, 0x000fe40003f1e000ULL,
0x000000310600720bULL, 0x000fc40003f5e000ULL, 0x000000490a00720bULL, 0x000fe40003f3e000ULL,
0x000000260500720bULL, 0x000fe40003f7e000ULL, 0x0000000855077208ULL, 0x000fe40004000000ULL,
0x0000000631097208ULL, 0x000fe40005000000ULL, 0x0000000a490a7208ULL, 0x000fe40004800000ULL,
0x0000000526047208ULL, 0x000fc40005800000ULL, 0x000000580700720bULL, 0x000fe40003f1e000ULL,
0x000000320900720bULL, 0x000fe40003f5e000ULL, 0x000000430a00720bULL, 0x000fe40003f3e000ULL,
0x000000250400720bULL, 0x000fe40003f7e000ULL, 0x0000000758077208ULL, 0x000fe40004000000ULL,
0x0000000932067208ULL, 0x000fc40005000000ULL, 0x0000000a430a7208ULL, 0x000fe40004800000ULL,
0x0000000425047208ULL, 0x000fe40005800000ULL, 0x000000560700720bULL, 0x000fe40003f1e000ULL,
0x000000330600720bULL, 0x000fe40003f5e000ULL, 0x000000450a00720bULL, 0x000fe40003f3e000ULL,
0x000000230400720bULL, 0x000fc40003f7e000ULL, 0x0000000756087208ULL, 0x000fe40004000000ULL,
0x0000000633077208ULL, 0x000fe40005000000ULL, 0x0000000a45057208ULL, 0x000fe40004800000ULL,
0x0000000423097208ULL, 0x000fe40005800000ULL, 0x000000570800720bULL, 0x000fe40003f1e000ULL,
0x000000340700720bULL, 0x000fc40003f5e000ULL, 0x000000440500720bULL, 0x000fe40003f3e000ULL,
0x000000240900720bULL, 0x000fe40003f7e000ULL, 0x00000008570b7208ULL, 0x000fe40004000000ULL,
0x0000000734047208ULL, 0x000fe40005000000ULL, 0x0000000544057208ULL, 0x000fe40004800000ULL,
0x0000000924097208ULL, 0x000fc40005800000ULL, 0x000000520b00720bULL, 0x000fe40003f1e000ULL,
0x000000350400720bULL, 0x000fe40003f5e000ULL, 0x0000004a0500720bULL, 0x000fe40003f3e000ULL,
0x000000220900720bULL, 0x000fe40003f7e000ULL, 0x0000000b52067208ULL, 0x000fe40004000000ULL,
0x0000000435077208ULL, 0x000fc40005000000ULL, 0x000000054a057208ULL, 0x000fe40004800000ULL,
0x0000000922047208ULL, 0x000fe40005800000ULL, 0x000000510600720bULL, 0x000fe40003f1e000ULL,
0x000000360700720bULL, 0x000fe40003f5e000ULL, 0x000000460500720bULL, 0x000fe40003f3e000ULL,
0x000000210400720bULL, 0x000fc40003f7e000ULL, 0x0000000651097208ULL, 0x000fe40004000000ULL,
0x0000000736067208ULL, 0x000fe40005000000ULL, 0x0000000546057208ULL, 0x000fe40004800000ULL,
0x0000000421077208ULL, 0x000fe40005800000ULL, 0x000000500900720bULL, 0x000fe40003f1e000ULL,
0x000000480500720bULL, 0x000fc40003f3e000ULL, 0x000000370600720bULL, 0x000fe40003f5e000ULL,
0x000000200700720bULL, 0x000fe40003f7e000ULL, 0x0000000950047208ULL, 0x000fe40004000000ULL,
0x0000000548087208ULL, 0x000fe40004800000ULL, 0x0000000637067208ULL, 0x000fe40005000000ULL,
0x00000007200a7208ULL, 0x000fc40005800000ULL, 0x0000004f0400720bULL, 0x000fe40003f1e000ULL,
0x000000470800720bULL, 0x000fe40003f3e000ULL, 0x0000003b0600720bULL, 0x000fe40003f5e000ULL,
0x000000190a00720bULL, 0x000fe40003f7e000ULL, 0x000000044f057208ULL, 0x000fe40004000000ULL,
0x0000000847077208ULL, 0x000fc40004800000ULL, 0x000000063b097208ULL, 0x000fe40005000000ULL,
0x0000000a190b7208ULL, 0x000fe40005800000ULL, 0x0000004e0500720bULL, 0x000fe40003f1e000ULL,
0x0000003e0700720bULL, 0x000fe40003f3e000ULL, 0x000000380900720bULL, 0x000fe40003f5e000ULL,
0x000000180b00720bULL, 0x000fc40003f7e000ULL, 0x000000054e047208ULL, 0x000fe40004000000ULL,
0x000000073e067208ULL, 0x000fe40004800000ULL, 0x0000000938087208ULL, 0x000fe40005000000ULL,
0x0000000b180a7208ULL, 0x000fe40005800000ULL, 0x0000004d0400720bULL, 0x000fe40003f1e000ULL,
0x0000003d0600720bULL, 0x000fc40003f3e000ULL, 0x000000390800720bULL, 0x000fe40003f5e000ULL,
0x000000170a00720bULL, 0x000fe40003f7e000ULL, 0x000000044d057208ULL, 0x000fe40004000000ULL,
0x000000063d077208ULL, 0x000fe40004800000ULL, 0x0000000839097208ULL, 0x000fe40005000000ULL,
0x0000000a170b7208ULL, 0x000fc40005800000ULL, 0x0000004c0500720bULL, 0x000fe40003f1e000ULL,
0x0000003c0700720bULL, 0x000fe40003f3e000ULL, 0x0000003a0900720bULL, 0x000fe40003f5e000ULL,
0x000000160b00720bULL, 0x000fe40003f7e000ULL, 0x000000054c057208ULL, 0x000fe40004000000ULL,
0x000000073c0a7208ULL, 0x000fc40004800000ULL, 0x000000093a0e7208ULL, 0x000fe40005000000ULL,
0x0000000b160d7208ULL, 0x000fe20005800000ULL, 0x000020f27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x0004e400000e0000ULL, 0x000000040500720bULL, 0x008fc80003f1e000ULL,
0x00000005040f7208ULL, 0x000fe20004000000ULL, 0x000021127f007947ULL, 0x000fea000b800000ULL,
0x0c401f000a047f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e057f89ULL, 0x004ea800000e0000ULL,
0x0c401f000d067f89ULL, 0x000e6200000e0000ULL, 0x000000040a00720bULL, 0x008fc40003f1e000ULL,
0x000000050e00720bULL, 0x004fe40003f3e000ULL, 0x0000000a04077208ULL, 0x002fe40004000000ULL,
0x0000000e05087208ULL, 0x000fe20004800000ULL, 0x0c201f000f047f89ULL, 0x000e6200000e0000ULL,
0x000000060d00720bULL, 0x000fc60003f1e000ULL, 0x0c201f00070c7f89ULL, 0x000ea200000e0000ULL,
0x0000000d060a7208ULL, 0x000fc60004000000ULL, 0x0c201f0008097f89ULL, 0x000ee800000e0000ULL,
0x0c201f000a0b7f89ULL, 0x0002e400000e0000ULL, 0x000000040f00720bULL, 0x002fe40003f1e000ULL,
0x0000000c0700720bULL, 0x004fe40003f3e000ULL, 0x0000000f04047208ULL, 0x000fc40004000000ULL,
0x000000090800720bULL, 0x008fe40003f5e000ULL, 0x000000070c057208ULL, 0x000fe40004800000ULL,
0x0000000809067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b5b5b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b5a5a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b54547823ULL, 0x100fe20000010807ULL, 0x0000005300097308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b59597823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b55557823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b58587823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b56567823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b51517823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b57537823ULL, 0x102fe20000010807ULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4c4c7823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b05077820ULL, 0x000fe20000410000ULL, 0x0000005b00087308ULL, 0x000e660000000800ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010807ULL, 0x0000003f00107308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b473f7823ULL, 0x104fe20000010807ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3c3c7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b06077820ULL, 0x000fe20000410000ULL,
0x00000056000f7308ULL, 0x0005e20000000800ULL, 0x00000002ff5b7819ULL, 0x000fc40000011667ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b38387823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3a3a7823ULL, 0x000fe20000010807ULL,
0x0000000a0b077208ULL, 0x000fe20004000000ULL, 0x0000004a00577308ULL, 0x000fe20000000800ULL,
0x000000085b0b7824ULL, 0x040fe200078e00ffULL, 0x000000015b0a7810ULL, 0x040fe20007ffe0ffULL,
0x000000085b5e7824ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b07567820ULL, 0x004fe20000410000ULL,
0x000000080908723eULL, 0x002fc400000010ffULL, 0x0000000367ff7812ULL, 0x000fe2000780c0ffULL,
0x0000004200117308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010856ULL,
0x00000039004a7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010856ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010856ULL, 0x3fb8aa3b17177823ULL, 0x000fc60000010856ULL,
0x0000003000427308ULL, 0x0005e20000000800ULL, 0x000000085b397824ULL, 0x002fce00078e00ffULL,
0x0000004900127308ULL, 0x000fe20000000800ULL, 0x000000045b307810ULL, 0x004fc80007ffe0ffULL,
0xfffffff839727812ULL, 0x000fe200078ee230ULL, 0x00000004ff307e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000005a005a7308ULL, 0x000fe60000000800ULL,
0x3f8000003030783eULL, 0x000fca00000010ffULL, 0x00000054000d7308ULL, 0x000fe20000000800ULL,
0x000000ffff767224ULL, 0x100fe400078e0030ULL, 0x000000ffff777224ULL, 0x100fe400078e0030ULL,
0x000000ffff787224ULL, 0x100fe400078e0030ULL, 0x000000ffff797224ULL, 0x000fe200078e0030ULL,
0x0000004800497308ULL, 0x000ff00000000800ULL, 0x0000004000407308ULL, 0x000ff00000000800ULL,
0x0000004b004b7308ULL, 0x000e700000000800ULL, 0x0000004100417308ULL, 0x000eb00000000800ULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x000000404b09723eULL, 0x002fc400000010ffULL,
0x000000065b407810ULL, 0x000fca0007ffe0ffULL, 0x0000002c002c7308ULL, 0x000e700000000800ULL,
0x0000003800487308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000ff00000000800ULL,
0x0000002800137308ULL, 0x000ef00000000800ULL, 0x0000002e002e7308ULL, 0x000ff00000000800ULL,
0x0000002f002f7308ULL, 0x000e700000000800ULL, 0x0000002900387308ULL, 0x000ff00000000800ULL,
0x0000002b00397308ULL, 0x000e700000000800ULL, 0x0000004500547308ULL, 0x000ff00000000800ULL,
0x00000058000e7308ULL, 0x0002b00000000800ULL, 0x0000003100457308ULL, 0x0005e20000000800ULL,
0xfffffff80b587812ULL, 0x002fc400078ee20aULL, 0x000000025b0a7810ULL, 0x040fe40007ffe0ffULL,
0x000000035b0b7810ULL, 0x000fc60007ffe0ffULL, 0x0000004300437308ULL, 0x000e620000000800ULL,
0x000000085b317824ULL, 0x004fe200078e00ffULL, 0xfffffff85e5e7812ULL, 0x000fe400078ee20bULL,
0x00000010110b723eULL, 0x000fe400000010ffULL, 0xfffffff8315c7812ULL, 0x000fe200078ee20aULL,
0x000000ffff317224ULL, 0x100fe200078e0030ULL, 0x0000005a0d0a723eULL, 0x000fe200000010ffULL,
0x00000059000c7308ULL, 0x000fe20000000800ULL, 0x00000041120d723eULL, 0x000fe200000010ffULL,
0x000000085b417824ULL, 0x000fe200078e00ffULL, 0x0000002d2c10723eULL, 0x000fe200000010ffULL,
0x000000ffff2c7224ULL, 0x100fe200078e0030ULL, 0x0000002a1311723eULL, 0x008fe200000010ffULL,
0x000000ffff2d7224ULL, 0x000fe200078e0030ULL, 0x0000002e2f12723eULL, 0x000fe200000010ffULL,
0x0000003a00597308ULL, 0x000fe20000000800ULL, 0x000000383913723eULL, 0x000fe200000010ffULL,
0x000000300828723cULL, 0x000f6200000418ffULL, 0x0000000e0f0e723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b24397823ULL, 0x000fe20000010856ULL, 0x00000043540f723eULL, 0x002fe200000010ffULL,
0x000000085b437824ULL, 0x000fe200078e00ffULL, 0x000000424524723eULL, 0x000fe200000010ffULL,
0x0000005500557308ULL, 0x000e620000000800ULL, 0x000000085b547824ULL, 0x040fe200078e00ffULL,
0x0000002c102c723cULL, 0x000f6200000418ffULL, 0x000000085b427810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8415a7812ULL, 0x000fe200078ee240ULL, 0x000000085b407824ULL, 0x000fe400078e00ffULL,
0x0000002700277308ULL, 0x000fe60000000800ULL, 0xfffffff840407812ULL, 0x000fca00078ee25bULL,
0x00000026003a7308ULL, 0x0004e20000000800ULL, 0x0000000c550c723eULL, 0x002fce00000010ffULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0xffffffff5b267810ULL, 0x004fe20007ffe0ffULL,
0x000000760c28723cULL, 0x020be60000041828ULL, 0xfffffff843747812ULL, 0x000fc600078ee226ULL,
0x0000003300337308ULL, 0x000e620000000800ULL, 0x000000105b767810ULL, 0x020fce0007ffe0ffULL,
0x0000002500317308ULL, 0x0007f00000000800ULL, 0x0000002300387308ULL, 0x0004a20000000800ULL,
0x000000273a25723eULL, 0x008fe200000010ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0030ULL,
0x000000323326723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b18337823ULL, 0x000fc80000010856ULL,
0x0000005300537308ULL, 0x000fe20000000800ULL, 0x0000000842237824ULL, 0x004fca00078e00ffULL,
0xfffffff823427812ULL, 0x000fe400078ee242ULL, 0x000000313827723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b20317823ULL, 0x100fe20000010856ULL, 0x0000005200527308ULL, 0x000e620000000800ULL,
0x3fb8aa3b16567823ULL, 0x000fc80000010856ULL, 0x00000078242c723cULL, 0x000f66000004182cULL,
0x0000005100517308ULL, 0x000ff00000000800ULL, 0x0000005000507308ULL, 0x000fe20000000800ULL,
0x000000535220723eULL, 0x002fce00000010ffULL, 0x0000004400447308ULL, 0x000ff00000000800ULL,
0x0000004600467308ULL, 0x000e700000000800ULL, 0x0000003400347308ULL, 0x000ff00000000800ULL,
0x0000003500357308ULL, 0x000ea20000000800ULL, 0x000000464923723eULL, 0x002fce00000010ffULL,
0x0000003600367308ULL, 0x000ff00000000800ULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x000000343534723eULL, 0x004fce00000010ffULL, 0x0000003900397308ULL, 0x000ff00000000800ULL,
0x0000002200327308ULL, 0x0004e20000000800ULL, 0x000000363736723eULL, 0x002fce00000010ffULL,
0x0000002100187308ULL, 0x0003e20000000800ULL, 0x000000515022723eULL, 0x004fe200000010ffULL,
0x000000ffff507224ULL, 0x100fe400078e0030ULL, 0x000000ffff517224ULL, 0x000fc800078e0030ULL,
0x0000003100317308ULL, 0x000ea20000000800ULL, 0x000000445721723eULL, 0x002fe400000010ffULL,
0x000000393235723eULL, 0x008fca00000010ffULL, 0x0000003b00477308ULL, 0x0003e20000000800ULL,
0x000000183137723eULL, 0x004fce00000010ffULL, 0x0000004d004d7308ULL, 0x000fe20000000800ULL,
0x000000055b3b7810ULL, 0x042fe40007ffe0ffULL, 0x000000185b5b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff854547812ULL, 0x000fe200078ee23bULL, 0x00000008763b7824ULL, 0x000fe200078e00ffULL,
0x00000050342c723cULL, 0x020fe2000004182cULL, 0x0000004c004c7308ULL, 0x000e620000000800ULL,
0x000000085b447824ULL, 0x000fe200078e00ffULL, 0x0000a0001f317811ULL, 0x000fc400078e60ffULL,
0xfffffff83b767812ULL, 0x000fe200078ee276ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0030ULL,
0xfffffff844447812ULL, 0x000fe200078ee25bULL, 0x0000001040407824ULL, 0x100fe200078e0231ULL,
0x0000004f004f7308ULL, 0x000fe20000000800ULL, 0x0000001058587824ULL, 0x100fe400078e0231ULL,
0x000000105c5c7824ULL, 0x100fe200078e0231ULL, 0x0000003a2028723cULL, 0x000b620000041828ULL,
0x000000105e5e7824ULL, 0x100fe400078e0231ULL, 0x0000001072727824ULL, 0x100fe200078e0231ULL,
0x0000004e004e7308ULL, 0x000ea20000000800ULL, 0x0000001054547824ULL, 0x000fc400078e0231ULL,
0x0000004d4c3a723eULL, 0x022fe200000010ffULL, 0x000000105a5a7824ULL, 0x100fe400078e0231ULL,
0x0000001074747824ULL, 0x100fe400078e0231ULL, 0x0000003f003f7308ULL, 0x000fe20000000800ULL,
0x000000ffff4c7224ULL, 0x100fe400078e0030ULL, 0x000000ffff4d7224ULL, 0x000fe400078e0030ULL,
0x0000001042427824ULL, 0x000fc400078e0231ULL, 0x0000001076767824ULL, 0x100fe200078e0231ULL,
0x0000003e003e7308ULL, 0x000e620000000800ULL, 0x0000004f4e38723eULL, 0x004fe200000010ffULL,
0x0000001044447824ULL, 0x000fe400078e0231ULL, 0x000000ffff317224ULL, 0x000fe400078e0030ULL,
0x0000000115587824ULL, 0x040fe400078e0258ULL, 0x0000003d003d7308ULL, 0x000fe20000000800ULL,
0x00000001155c7824ULL, 0x000fc400078e025cULL, 0x00000001155e7824ULL, 0x040fe400078e025eULL,
0x0000000115727824ULL, 0x040fe400078e0272ULL, 0x0000000115547824ULL, 0x040fe200078e0254ULL,
0x0000003c003c7308ULL, 0x000ea20000000800ULL, 0x0000003f3e39723eULL, 0x002fe200000010ffULL,
0x00000001155a7824ULL, 0x000fe200078e025aULL, 0x0000004a593e723eULL, 0x000fe200000010ffULL,
0x0000000115747824ULL, 0x040fe400078e0274ULL, 0x0000000115427824ULL, 0x000fc400078e0242ULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x0000000115447824ULL, 0x000fce00078e0244ULL,
0x0000003300167308ULL, 0x0002e20000000800ULL, 0x0000003d3c3b723eULL, 0x004fe400000010ffULL,
0x00000047483c723eULL, 0x000fca00000010ffULL, 0x0000001700177308ULL, 0x000fe20000000800ULL,
0x0000000140337824ULL, 0x002fe200078e0215ULL, 0x0000004c3828723cULL, 0x000f680000041828ULL,
0x0000000833007388ULL, 0x0003e40000000800ULL, 0x0000005600567308ULL, 0x000ea20000000800ULL,
0x00000019163d723eULL, 0x008fe200000010ffULL, 0x0000000a58007388ULL, 0x0003e80000000800ULL,
0x0000000c5c007388ULL, 0x0003e80000000800ULL, 0x0000000e5e007388ULL, 0x0003e80000000800ULL,
0x0000002072007388ULL, 0x0003e20000000800ULL, 0x00000017563f723eULL, 0x004fe200000010ffULL,
0x0000000115177824ULL, 0x000fc400078e0276ULL, 0x0000002254007388ULL, 0x0003e20000000800ULL,
0x000000ffff297224ULL, 0x020fc600078e002aULL, 0x000000385a007388ULL, 0x0003e20000000800ULL,
0x000000303c2c723cULL, 0x000f66000004182cULL, 0x0000003a74007388ULL, 0x0003e80000000800ULL,
0x0000000942007388ULL, 0x0003e80000000800ULL, 0x0004000b58007388ULL, 0x0003e80000000800ULL,
0x0004000d5c007388ULL, 0x0003e80000000800ULL, 0x0004000f5e007388ULL, 0x0003e80000000800ULL,
0x0004002172007388ULL, 0x0003e20000000800ULL, 0x000000ffff2a7224ULL, 0x020fc400078e002cULL,
0x000000ffff2b7224ULL, 0x000fe200078e002eULL, 0x0004002354007388ULL, 0x0003e80000000800ULL,
0x000400395a007388ULL, 0x0003e80000000800ULL, 0x0004003b74007388ULL, 0x0003e80000000800ULL,
0x0000001017007388ULL, 0x0003e80000000800ULL, 0x0008001258007388ULL, 0x0003e80000000800ULL,
0x000800245c007388ULL, 0x0003e80000000800ULL, 0x000800265e007388ULL, 0x0003e80000000800ULL,
0x0008003472007388ULL, 0x0003e80000000800ULL, 0x0008003654007388ULL, 0x0003e80000000800ULL,
0x0008003c5a007388ULL, 0x0003e80000000800ULL, 0x0008003e74007388ULL, 0x0003e80000000800ULL,
0x0000001144007388ULL, 0x0003e80000000800ULL, 0x000c001358007388ULL, 0x0003e80000000800ULL,
0x000c00255c007388ULL, 0x0003e80000000800ULL, 0x000c00275e007388ULL, 0x0003e80000000800ULL,
0x000c003572007388ULL, 0x0003e80000000800ULL, 0x000c003754007388ULL, 0x0003e80000000800ULL,
0x000c003d5a007388ULL, 0x0003e80000000800ULL, 0x000c003f74007388ULL, 0x0003e80000000800ULL,
0x0120000414008388ULL, 0x0003e80000000c00ULL, 0x0122002814008388ULL, 0x0003e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000006cff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008006cff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010006cff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000016e6e7810ULL, 0x000fe20007ffe0ffULL,
0x000018006cff7f8cULL, 0x0003e6000c80043fULL, 0x0000001a6e00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff86a000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff287807ULL, 0x008fe40004000000ULL,
0x0001b8e000297802ULL, 0x000fc40000000f00ULL, 0x0000109000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e0028ULL, 0xfffe739000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40005800000ULL, 0x0001b93000297802ULL, 0x000fc40000000f00ULL,
0x0000104000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0028ULL,
0xfffe73f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x0001b98000287802ULL, 0x000fc40000000f00ULL, 0x00000fa000007944ULL, 0x014fea0003c00000ULL,
0xfffe74c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x0001b9c000287802ULL, 0x000fc40000000f00ULL, 0x00000f6000007944ULL, 0x016fea0003c00000ULL,
0xfffe75f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x0001ba0000287802ULL, 0x000fc40000000f00ULL, 0x00000f2000007944ULL, 0x01efea0003c00000ULL,
0xfffe772000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x0001ba4000287802ULL, 0x000fc40000000f00ULL, 0x00000ee000007944ULL, 0x01efea0003c00000ULL,
0xfffe784000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x0001ba9000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0003ULL,
0x00000e9000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xfffe7c6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x0001bae000287802ULL, 0x000fc40000000f00ULL, 0x00000e4000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001003297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x0001bb3000287802ULL, 0x000fc40000000f00ULL,
0x00000df000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xfffe7c1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x0001bb8000287802ULL, 0x000fc40000000f00ULL, 0x00000da000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xfffe7bf000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x008fe40004000000ULL, 0x0001bbd000297802ULL, 0x000fc40000000f00ULL,
0x00000da000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff257224ULL, 0x000fe200078e0028ULL,
0xfffeac8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe40005800000ULL,
0x0001bc2000297802ULL, 0x000fc40000000f00ULL, 0x00000d5000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff707224ULL, 0x000fe200078e0028ULL, 0xfffeacc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0071ULL, 0x0001bc7000287802ULL, 0x000fc40000000f00ULL,
0x00000cb000007944ULL, 0x004fea0003c00000ULL, 0xfffeada000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0071ULL, 0x0001bcb000287802ULL, 0x000fc40000000f00ULL,
0x00000c7000007944ULL, 0x006fea0003c00000ULL, 0xfffeaed000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0071ULL, 0x0001bcf000287802ULL, 0x000fc40000000f00ULL,
0x00000c3000007944ULL, 0x00efea0003c00000ULL, 0xfffeb00000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0071ULL, 0x0001bd3000287802ULL, 0x000fc40000000f00ULL,
0x00000bf000007944ULL, 0x00efea0003c00000ULL, 0xfffeb12000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001bd8000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0025ULL, 0x00000ba000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xfffeb54000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001bdd000287802ULL, 0x000fc40000000f00ULL,
0x00000b5000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001025297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001be2000287802ULL, 0x000fc40000000f00ULL, 0x00000b0000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xfffeb4f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001be7000287802ULL, 0x000fc40000000f00ULL,
0x00000ab000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xfffeb4d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe40004000000ULL,
0x0001bec000297802ULL, 0x000fc40000000f00ULL, 0x00000ab000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff727224ULL, 0x000fe200078e0028ULL, 0xfffee35000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40005800000ULL, 0x0001bf1000297802ULL, 0x000fc40000000f00ULL,
0x00000a6000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff737224ULL, 0x000fe200078e0028ULL,
0xfffee3a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0021ULL,
0x0001bf6000287802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x018fea0003c00000ULL,
0xfffee47000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0021ULL,
0x0001bfa000287802ULL, 0x000fc40000000f00ULL, 0x0000098000007944ULL, 0x01afea0003c00000ULL,
0xfffee5a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0021ULL,
0x0001bfe000287802ULL, 0x000fc40000000f00ULL, 0x0000094000007944ULL, 0x01afea0003c00000ULL,
0xfffee6d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0021ULL,
0x0001c02000287802ULL, 0x000fc40000000f00ULL, 0x0000090000007944ULL, 0x01afea0003c00000ULL,
0xfffee7f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001c07000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0021ULL,
0x000008b000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xfffeebe000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001c0c000287802ULL, 0x000fc40000000f00ULL, 0x0000086000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001021297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001c11000287802ULL, 0x000fc40000000f00ULL,
0x0000081000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xfffeeb9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001c16000287802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xfffeeb7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x004fe40004000000ULL, 0x0001c1b000297802ULL, 0x000fc40000000f00ULL,
0x000007c000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e0028ULL,
0xffff19a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe40005800000ULL,
0x0001c20000297802ULL, 0x000fc40000000f00ULL, 0x0000077000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff6c7224ULL, 0x000fe200078e0028ULL, 0xffff19f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0009ULL, 0x0001c25000287802ULL, 0x000fc40000000f00ULL,
0x000006d000007944ULL, 0x018fea0003c00000ULL, 0xffff1ac000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0009ULL, 0x0001c29000287802ULL, 0x000fc40000000f00ULL,
0x0000069000007944ULL, 0x01afea0003c00000ULL, 0xffff1bf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0009ULL, 0x0001c2d000287802ULL, 0x000fc40000000f00ULL,
0x0000065000007944ULL, 0x01afea0003c00000ULL, 0xffff1d2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0009ULL, 0x0001c31000287802ULL, 0x000fc40000000f00ULL,
0x0000061000007944ULL, 0x01afea0003c00000ULL, 0xffff1e4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x0001c36000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0006ULL, 0x000005c000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xffff225000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x0001c3b000287802ULL, 0x000fc40000000f00ULL,
0x0000057000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001006297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x0001c40000287802ULL, 0x000fc40000000f00ULL, 0x0000052000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xffff220000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x0001c45000287802ULL, 0x000fc40000000f00ULL,
0x000004d000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xffff21e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x000fe200078e0005ULL,
0x0001c4b000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fc400078e00ffULL,
0x0000043000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000bULL,
0xffffdec000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x002fe200078e000aULL,
0x0001c51000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x014fea0003c00000ULL, 0x0000000b0a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000eULL, 0x0001c57000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000a0b067208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000dULL, 0x0001c5d000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000e0b0e7208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000fULL, 0x0001c63000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000d0b0a7208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0006ULL, 0x0001c69000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000f0b047208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000eULL, 0x0001c6f000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x000000060b057208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000aULL, 0x0001c75000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000e0b067208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffdd9000007947ULL, 0x000fea000383ffffULL,
0x0180000022007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002200008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff22ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000022027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002200007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe372002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000001100007348ULL, 0x000fe80003800000ULL,
0x0c00000c070b7389ULL, 0x0002a200000e0010ULL, 0xfffe36e008007950ULL, 0x000fea0003c3ffffULL,
0x0000008200007348ULL, 0x000fe80003800000ULL, 0x000000292a297389ULL, 0x0002a200000e0083ULL,
0x00000000ff2b7424ULL, 0x000fc400078e00ffULL, 0x000000ffff2a7224ULL, 0x002fc800078e0028ULL,
0xfffe36902a007950ULL, 0x000fea0003c3ffffULL, 0x000000012800780cULL, 0x000fe20003f65070ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0029ULL, 0x0000008100007348ULL, 0x000fe80003800000ULL,
0x00000000ff2b7424ULL, 0x000fce00078e00ffULL, 0x0000000000287806ULL, 0x000fc800058e0100ULL,
0x0000008128287212ULL, 0x000fe200078ec0ffULL, 0xfffe36202a007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000568ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000350ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c88ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d48ULL,
0x00000000000008acULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001608ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001698ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000169cULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x000000000001ca80ULL, 0xf600001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001e300ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001e340ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001e6c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001698ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001cc68ULL,
0x000000000001cc68ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001e300ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001e6c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_89_cubin_len = 124832;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
