/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000204c0ULL, 0x0000000000020140ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL,
0x326d735f61647563ULL, 0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL,
0x746e695f5f240068ULL, 0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL,
0x66625f636e79736cULL, 0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL,
0x5f30376d735f6164ULL, 0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL,
0x5f5f245f335f6c61ULL, 0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL,
0x2e616c65722e0074ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL,
0x766e2e0066754265ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL,
0x65642e006d617261ULL, 0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL,
0x616c65722e00656dULL, 0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL,
0x00000000006e6f69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000037fULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000003cdULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b002200000413ULL,
0x000000000001e530ULL, 0x0000000000000180ULL, 0x000b002200000446ULL, 0x000000000001e6b0ULL,
0x0000000000000040ULL, 0x000b002200000471ULL, 0x000000000001e6f0ULL, 0x0000000000000050ULL,
0x000b00220000049bULL, 0x000000000001e740ULL, 0x0000000000000140ULL, 0x000a000300000509ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000529ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000559ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001e880ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001e53000000000ULL, 0x0000040400000000ULL, 0x810c000001880400ULL, 0x0077b80400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001e53000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8084288080860900ULL,
0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080890828808081ULL, 0x8d082880808a0828ULL,
0x2880808f08288080ULL, 0x8094082880809308ULL, 0x0828808095082880ULL, 0x8080990828808096ULL,
0xa808288080a50828ULL, 0x288080aa08288080ULL, 0x80f208288080ec08ULL, 0x08288080f3082880ULL,
0x80809008288080f8ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880809092ULL,
0x0000001cffffffffULL, 0x000000f000000000ULL, 0x0001e6b000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080890828808081ULL, 0x8d082880808a0828ULL,
0x2880808f08288080ULL, 0x8094082880809308ULL, 0x0828808095082880ULL, 0x8080a50828808096ULL,
0xaa08288080a90828ULL, 0x288080ec08288080ULL, 0x80f308288080f208ULL, 0x08288080f8082880ULL,
0x80828016288080a8ULL, 0x0000000000031028ULL, 0x288080a892000000ULL, 0x0000000000002200ULL,
0x0000002cffffffffULL, 0x000001b000000000ULL, 0x0001e6f000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x80aa288080a80900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080890828808081ULL, 0x8d082880808a0828ULL, 0x2880808f08288080ULL, 0x8094082880809308ULL,
0x0828808095082880ULL, 0x8080a50828808096ULL, 0xaa08288080a80828ULL, 0x288080ec08288080ULL,
0x80f308288080f208ULL, 0x08288080f8082880ULL, 0x80828016288080a9ULL, 0x0000000000031028ULL,
0x288080a992000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL, 0x0000028000000000ULL,
0x0001e74000000000ULL, 0x0000014000000000ULL, 0x0000180400000000ULL, 0x80aa288080a90900ULL,
0x0000000000002880ULL, 0x0000001900082f04ULL, 0x00082304000000f9ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008230400000000ULL, 0x0000000000000019ULL, 0x0000001900081204ULL, 0x0008110400000000ULL,
0x0000000000000019ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0068016000000016ULL,
0x000c170400681903ULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL,
0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000eb000043104ULL,
0xffffffff019c2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x00000320019c2804ULL, 0x000005f000000490ULL, 0x00002d0000002c70ULL, 0x00002f8000002e10ULL,
0x00003250000030f0ULL, 0x00003710000036d0ULL, 0x0000375000003720ULL, 0x000068c000006830ULL,
0x00006b50000069e0ULL, 0x00006e2000006cc0ULL, 0x000072e0000072a0ULL, 0x00007320000072f0ULL,
0x0000a2900000a1f0ULL, 0x0000a5100000a3a0ULL, 0x0000a7e00000a680ULL, 0x0000ac700000ac30ULL,
0x0000acb00000ac80ULL, 0x0000dbd00000db30ULL, 0x0000de500000dce0ULL, 0x0000e1200000dfc0ULL,
0x0000e5d00000e590ULL, 0x0000e6100000e5e0ULL, 0x0001097000010960ULL, 0x0001099000010980ULL,
0x0001bc100001bbd0ULL, 0x0001bc300001bc20ULL, 0x0001bca00001bc40ULL, 0x0001bce00001bcc0ULL,
0x0001d1a00001d140ULL, 0x0001d2700001d210ULL, 0x0001d3300001d2d0ULL, 0x0001d4100001d3a0ULL,
0x0001d4f00001d480ULL, 0x0001d5b00001d550ULL, 0x0001d6800001d620ULL, 0x0001d7400001d6e0ULL,
0x0001d8200001d7b0ULL, 0x0001d9000001d890ULL, 0x0001d9c00001d960ULL, 0x0001da900001da30ULL,
0x0001db500001daf0ULL, 0x0001dc300001dbc0ULL, 0x0001dd100001dca0ULL, 0x0001ddd00001dd70ULL,
0x0001dea00001de40ULL, 0x0001df600001df00ULL, 0x0001e0400001dfd0ULL, 0x0001e1200001e0b0ULL,
0x0001e2100001e190ULL, 0x0001e3100001e290ULL, 0x0001e4100001e390ULL, 0x0001e5100001e490ULL,
0x0000042004403904ULL, 0x0001a600000000ffULL, 0x00000460003f0100ULL, 0x0001a60800000013ULL,
0x00000580003f0120ULL, 0x0001a68800000013ULL, 0x000005b0003f0120ULL, 0x0001a6a800000013ULL,
0x000005e0003f0120ULL, 0x0001a6c800000013ULL, 0x00000f10003f0120ULL, 0x0001a600000000ffULL,
0x000010c0003f0107ULL, 0x000000040000000cULL, 0x00001170003f0102ULL, 0x000000000000000cULL,
0x00001ae0003f0101ULL, 0x00000000000000ffULL, 0x00001b6000040107ULL, 0x00000000000000ffULL,
0x00001bc000040101ULL, 0x000000200000000cULL, 0x00001d50003f0101ULL, 0x0001a6cc0000000fULL,
0x00001f30003f0105ULL, 0x0001a6cc0000000fULL, 0x00002870003f0105ULL, 0x0001a6b000000010ULL,
0x00002920003f0107ULL, 0x0001a6b000000010ULL, 0x00002980003f0101ULL, 0x0001a60800000023ULL,
0x000029a0003f0101ULL, 0x0001a60c00000023ULL, 0x00002b70003f0105ULL, 0x0001a60c00000023ULL,
0x00003400003f0105ULL, 0x0001a6ac00000010ULL, 0x000035f0003f0105ULL, 0x0001a6ac00000010ULL,
0x000059f0003f0105ULL, 0x000000000000006cULL, 0x00005a50003f0101ULL, 0x0001a68800000025ULL,
0x00005a80003f0101ULL, 0x000000040000001aULL, 0x00005c40003f0105ULL, 0x000000040000001aULL,
0x00006430003f0105ULL, 0x0000000000000017ULL, 0x00006510003f0107ULL, 0x0000000000000017ULL,
0x00006570003f0101ULL, 0x0001a62800000023ULL, 0x00006590003f0101ULL, 0x0001a62c00000023ULL,
0x00006760003f0105ULL, 0x0001a62c00000023ULL, 0x00007010003f0105ULL, 0x0001a6b40000006eULL,
0x000071e0003f0105ULL, 0x0001a6b40000006eULL, 0x00009390003f0105ULL, 0x000000000000006eULL,
0x000093f0003f0101ULL, 0x0001a69000000028ULL, 0x00009420003f0101ULL, 0x000000040000001aULL,
0x000095e0003f0105ULL, 0x000000040000001aULL, 0x00009de0003f0105ULL, 0x00000008000000ffULL,
0x00009ed000040107ULL, 0x0001a6b00000002aULL, 0x00009f30003f0101ULL, 0x0001a64800000023ULL,
0x00009f50003f0101ULL, 0x0001a64c00000023ULL, 0x0000a120003f0105ULL, 0x0001a64c00000023ULL,
0x0000a9a0003f0105ULL, 0x0000000400000017ULL, 0x0000ab70003f0105ULL, 0x0000000400000017ULL,
0x0000cce0003f0105ULL, 0x000000000000001aULL, 0x0000cd40003f0101ULL, 0x0001a69800000009ULL,
0x0000cd70003f0101ULL, 0x000000040000001aULL, 0x0000cf30003f0105ULL, 0x000000040000001aULL,
0x0000d760003f0105ULL, 0x00000000000000ffULL, 0x0000d82000040107ULL, 0x0000000000000017ULL,
0x0000d880003f0101ULL, 0x0001a66800000009ULL, 0x0000d8b0003f0101ULL, 0x0001a66c00000009ULL,
0x0000da80003f0105ULL, 0x0001a66c00000009ULL, 0x0000e2f0003f0105ULL, 0x0001a6b40000000fULL,
0x0000e4c0003f0105ULL, 0x0001a6b40000000fULL, 0x00010710003f0105ULL, 0x000000000000001aULL,
0x00010790003f0101ULL, 0x000000000000000cULL, 0x00012a10003f0101ULL, 0x0001a600000000ffULL,
0x00014340003f0101ULL, 0x0001a604000000ffULL, 0x00014550003f0105ULL, 0x0001a604000000ffULL,
0x000148d0003f0105ULL, 0x0001a600000000ffULL, 0x00014900003f0101ULL, 0x0001a604000000ffULL,
0x00014ac0003f0105ULL, 0x0001a604000000ffULL, 0x00018ea0003f0105ULL, 0x00000000000000beULL,
0x00018f50003f0101ULL, 0x00000004000000beULL, 0x00019120003f0105ULL, 0x00000004000000beULL,
0x0001cf80003f0105ULL, 0x00000000000000bfULL, 0x0001cfe0003f0101ULL, 0x00000008000000bfULL,
0x0001d040003f0101ULL, 0x00000010000000bfULL, 0x0001d0b0003f0101ULL, 0x00000018000000bfULL,
0x00053803003f0101ULL, 0x000118f000301c04ULL, 0x00011bc000011920ULL, 0x00011fa000011db0ULL,
0x0001238000012190ULL, 0x0001277000012570ULL, 0x00014b2000012920ULL, 0x000004010001d100ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000032cULL, 0x0000001900000002ULL, 0x000000000000025cULL,
0x0000001900000002ULL, 0x000000000000019cULL, 0x0000001900000002ULL, 0x00000000000000ccULL,
0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL, 0x0000000000000303ULL,
0x0000001900000002ULL, 0x0000000000000233ULL, 0x0000001900000002ULL, 0x0000000000000178ULL,
0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL, 0x000000000001a700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000c27919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff0b0424ULL, 0x000fe200078e00ffULL,
0x00000001c2020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e000bULL,
0x00005c00c20a0625ULL, 0x000fe200078e000bULL, 0x0000000602090981ULL, 0x0002aa000c1e1900ULL,
0x000000060a0a0981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff177624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000067919ULL, 0x000e620000002600ULL, 0x00005a00ff157624ULL, 0x000fc600078e00ffULL,
0x0000000000117919ULL, 0x000e620000002300ULL, 0x0000590015157a24ULL, 0x000fc600078e02ffULL,
0x00000000000b7919ULL, 0x008ee20000002100ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00047810ULL, 0x010fcc0007ffe0ffULL, 0x0000000400057305ULL, 0x000864000021f000ULL,
0x000000ffff047224ULL, 0x010fe400078e00ffULL, 0x000000ffff077224ULL, 0x002fc800078e0a05ULL,
0x0000590007077a24ULL, 0x000fc800078e02ffULL, 0x0000000705057227ULL, 0x000fcc00078e0004ULL,
0x00000400050d7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff027224ULL, 0x000fc800078e0a0dULL,
0x0000040002007624ULL, 0x000fca00078e0217ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d1810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x000000010d0d2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0dba12ULL, 0x000fc800078e33ffULL, 0x0000000d00007306ULL, 0x000e620000209000ULL,
0x000000ff0d00720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000030d047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000e640000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000000603077227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a07ULL, 0x000000000d007224ULL, 0x000fca00078e0206ULL,
0x0000000d0000720cULL, 0x000fe20003fa6070ULL, 0x0000010011027a24ULL, 0x002fe400078e0204ULL,
0x00001fff11117589ULL, 0x000fe400000e0000ULL, 0x0000000002137a24ULL, 0x108fe200078e020bULL,
0x00000005ff0b7819ULL, 0x000fc8000001160bULL, 0x000000ff1300720cULL, 0x000fc60003f65270ULL,
0x0000000100005824ULL, 0x000fe200078e0a0dULL, 0x0000000f1300780cULL, 0x000fe40003f24070ULL,
0x0000000107075810ULL, 0x000fe40007ffe0ffULL, 0x0000000d0000720cULL, 0x000fe40003fc6070ULL,
0x000000031300780cULL, 0x040fe40003fa4070ULL, 0x0000007f1300780cULL, 0x000fe20003f44070ULL,
0x3fffff80ff02b424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff049424ULL, 0x000fc800078e00ffULL, 0x0000000107076810ULL, 0x000fe20007ffe0ffULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x0000000dff07c212ULL, 0x000fe200078e33ffULL,
0x01a60002ff00b388ULL, 0x0003e20000000a00ULL, 0x000000011300780cULL, 0x000fe20003f64070ULL,
0x3fffff80ff0cd424ULL, 0x000fe400078e00ffULL, 0x000000ffff087224ULL, 0x000fe200078e0a07ULL,
0x01a6080413009388ULL, 0x0007e20000008a00ULL, 0xff317217ff10a424ULL, 0x000fe400078e00ffULL,
0x000000080d067224ULL, 0x000fe200078e0206ULL, 0x00001fff0b027589ULL, 0x000f2200000e0000ULL,
0x3fffff60ff08d424ULL, 0x000fc400078e00ffULL, 0x0000002006037824ULL, 0x002fe200078e00ffULL,
0x01a400101300a388ULL, 0x000fe20000004800ULL, 0x7fffff80ff0dd424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0eb424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff0fb424ULL, 0x000fe400078e00ffULL,
0x0000000109000824ULL, 0x004fe400078e0a0aULL, 0x00005800ff008624ULL, 0x000fc400078e00ffULL,
0x00005800c20a8a24ULL, 0x000fe400078e02ffULL, 0x00005a0000047a24ULL, 0x008fe400078e02ffULL,
0x7fffff60ff09d424ULL, 0x000fe400078e00ffULL, 0x0000000104057824ULL, 0x040fe200078e0a03ULL,
0x000000030400720cULL, 0x000fe20003f26070ULL, 0x0000000411047824ULL, 0x010fe200078e0202ULL,
0x01a688081300d388ULL, 0x000fe20000008a00ULL, 0x000000150a777224ULL, 0x000fe200078e02ffULL,
0x0000002005057817ULL, 0x000fc40003800000ULL, 0x01a6a80c1300d388ULL, 0x000fe20000008a00ULL,
0x00005a0007147a24ULL, 0x000fe200078e0277ULL, 0x000000ff05767207ULL, 0x000fe40000800000ULL,
0x01a6c80e1300b388ULL, 0x000fe80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000207600780cULL, 0x000fe20003f05270ULL, 0x0000000404097824ULL, 0x000fd800078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a00000b7b06ULL, 0x000e620000209000ULL,
0x0000000000087919ULL, 0x000eae0000000000ULL, 0x0000000b000b7308ULL, 0x002e620000001000ULL,
0x00000004ff067819ULL, 0x004fc80000011608ULL, 0x00000002060d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001090e7824ULL, 0x000fe200078e0206ULL, 0x0ffffffe0b047810ULL, 0x002fc60007ffe0ffULL,
0x00000001090f7824ULL, 0x000fe200078e020dULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000ffff137224ULL, 0x004fc800078e0a05ULL,
0x00005a0013137a24ULL, 0x000fc800078e02ffULL, 0x00000013050c7227ULL, 0x000fc800078e0004ULL,
0x0000000103057824ULL, 0x040fe400078e020eULL, 0x0000000103137824ULL, 0x000fe400078e020fULL,
0x000000050c047227ULL, 0x000fc800078e00ffULL, 0x000000130c107227ULL, 0x000fc800078e00ffULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x000000ffff127224ULL, 0x000fe400078e0a10ULL,
0x00005a000c0b7a24ULL, 0x000fe400078e0205ULL, 0x00005a00120c7a24ULL, 0x000fc600078e0213ULL,
0x00005a000b007a0cULL, 0x000fe40003f06070ULL, 0x00005a000c007a0cULL, 0x000fd60003f46070ULL,
0x80005a000b0b0a10ULL, 0x000fe40007ffe0ffULL, 0x80005a000c0c2a10ULL, 0x000fe40007ffe0ffULL,
0x00005a000b007a0cULL, 0x000fe40003f26070ULL, 0x00005a000c007a0cULL, 0x000fe40003f66070ULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x0000000110102810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff0b7a12ULL, 0x000fc600078e33ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x0000000110103810ULL, 0x000fe40007ffe0ffULL,
0x000000040b0c7207ULL, 0x040fe40004000000ULL, 0x000000100b0b7207ULL, 0x000fe40004000000ULL,
0x0000000976047217ULL, 0x000fe20007800000ULL, 0x000000ffff107224ULL, 0x000fe400078e0a0cULL,
0x000000ffff127224ULL, 0x000fc400078e0a0bULL, 0x00005a0010057a24ULL, 0x000fe400078e0205ULL,
0x00005a0012137a24ULL, 0x000fe400078e0213ULL, 0x0000000114057824ULL, 0x040fe400078e0205ULL,
0x0000000114107824ULL, 0x000fe400078e0213ULL, 0x0000000104047824ULL, 0x000fe400078e0a09ULL,
0x000000150c057224ULL, 0x000fc400078e0205ULL, 0x0000001008097824ULL, 0x000fe200078e00ffULL,
0x000000040600720cULL, 0x080fe20003f06070ULL, 0x000000150b0c7224ULL, 0x000fe200078e0210ULL,
0x000000040d00720cULL, 0x000fe20003f26070ULL, 0x0000010005047825ULL, 0x000fe200078e00ffULL,
0x000000f0090b7812ULL, 0x000fc600078ec0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000b04047212ULL, 0x000fc600078efcffULL, 0x000000010e067824ULL, 0x100fe200078e0208ULL,
0x0000000b0c0b7212ULL, 0x000fe200078efcffULL, 0x000000100e137824ULL, 0x000fe200078e00ffULL,
0x0000600004047a10ULL, 0x000fe20007f5e0ffULL, 0x000000010f0e7824ULL, 0x000fe200078e0208ULL,
0x000060000b0c7a10ULL, 0x000fe20007f7e0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff013067812ULL, 0x000fe400078ee206ULL, 0x0000610005057a10ULL, 0x000fe400017fe4ffULL,
0xfffffff00f0e7812ULL, 0x000fe200078ee20eULL, 0x00000010060b7824ULL, 0x000fe200078e00ffULL,
0x000061000d0d7a10ULL, 0x000fc60001ffe4ffULL, 0x000000100e0f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e8000c101c46ULL,
0x000000000c0f7faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a00000b7b06ULL, 0x000e620000209000ULL, 0x0000000000087919ULL, 0x000eae0000000000ULL,
0x0000000b000b7308ULL, 0x002e620000001000ULL, 0x0000000908067211ULL, 0x004fc800078fe0ffULL,
0x00000002060e7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe0b0c7810ULL, 0x002fc60007ffe0ffULL,
0x00000001030b7824ULL, 0x000fe200078e020eULL, 0x0000000c00057305ULL, 0x000e64000021f000ULL,
0x000000ffff047224ULL, 0x002fc800078e0a05ULL, 0x00005a0004097a24ULL, 0x000fe400078e02ffULL,
0x000000ffff047224ULL, 0x000fc800078e00ffULL, 0x0000000905097227ULL, 0x000fc800078e0004ULL,
0x0000000103047824ULL, 0x000fe400078e0206ULL, 0x0000000b090c7227ULL, 0x000fc800078e00ffULL,
0x0000000409057227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a05ULL,
0x000000ffff107224ULL, 0x000fe400078e0a0cULL, 0x00005a0009097a24ULL, 0x000fe400078e0204ULL,
0x00005a00100d7a24ULL, 0x000fc600078e020bULL, 0x00005a0009007a0cULL, 0x000fe40003f06070ULL,
0x00005a000d007a0cULL, 0x000fd60003f46070ULL, 0x80005a0009090a10ULL, 0x000fe40007ffe0ffULL,
0x80005a000d0d2a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0009007a0cULL, 0x000fe40003f26070ULL,
0x00005a000d007a0cULL, 0x000fe40003f66070ULL, 0x0000000105050810ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c2810ULL, 0x000fc40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a00ff097a12ULL, 0x000fc600078e33ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c3810ULL, 0x000fe40007ffe0ffULL, 0x0000000509057207ULL, 0x040fe40004000000ULL,
0x0000000c090c7207ULL, 0x000fc60004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a05ULL,
0x000000ffff107224ULL, 0x000fe400078e0a0cULL, 0x00005a0009047a24ULL, 0x000fe400078e0204ULL,
0x00005a00100b7a24ULL, 0x000fe400078e020bULL, 0x0000000114047824ULL, 0x040fe400078e0204ULL,
0x00000001140b7824ULL, 0x000fc400078e020bULL, 0x0000001008097824ULL, 0x000fe400078e00ffULL,
0x0000001505047224ULL, 0x080fe400078e0204ULL, 0x000000150c0c7224ULL, 0x000fe200078e020bULL,
0x000000f0090f7812ULL, 0x000fe200078ec0ffULL, 0x0000010004047825ULL, 0x000fc800078e00ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000f04047212ULL, 0x000fc600078efcffULL,
0x00000001060b7824ULL, 0x100fe200078e0208ULL, 0x0000000f0c0c7212ULL, 0x000fe200078efcffULL,
0x0000001006107824ULL, 0x000fe200078e00ffULL, 0x0000600004047a10ULL, 0x000fe20007f1e0ffULL,
0x000000010e067824ULL, 0x000fe200078e0208ULL, 0x000060000c0c7a10ULL, 0x000fe20007f3e0ffULL,
0x000000100e0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff0100b7812ULL, 0x000fe400078ee20bULL,
0x0000610005057a10ULL, 0x000fe400007fe4ffULL, 0xfffffff00f067812ULL, 0x000fe200078ee206ULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x000061000d0d7a10ULL, 0x000fc60000ffe4ffULL,
0x00000010060f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e8000b901c46ULL, 0x000000000c0f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000067919ULL, 0x000ea20000000000ULL, 0x0000000000047806ULL, 0x002fe200038e0000ULL,
0x00000004ff837424ULL, 0x000fc600078e00ffULL, 0x0000000400057300ULL, 0x000ea200000e0000ULL,
0x00006800c20c7625ULL, 0x000fce00078e0083ULL, 0x00000004000b7309ULL, 0x000e620000000000ULL,
0x000000060500720cULL, 0x004fe40003f02070ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff057224ULL, 0x002fd400078e0a0bULL, 0x01a60405ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01a60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000060c047981ULL, 0x000ea2000c1e1900ULL, 0x000000ff1100720cULL, 0x000fe40003f05270ULL,
0x0000007f04057810ULL, 0x046fe40007ffe0ffULL, 0x000000ff04117810ULL, 0x000fc40007ffe0ffULL,
0x00000007ff057819ULL, 0x000fe40000011605ULL, 0x00000008ff067819ULL, 0x000fca0000011611ULL,
0x0001192000008947ULL, 0x000fea0003800000ULL, 0x00000003ff207819ULL, 0x000fe20000011602ULL,
0x00000003ff0d7424ULL, 0x000fe200078e00ffULL, 0x0001a688020c7811ULL, 0x000fe200078e18ffULL,
0xffffffffff247424ULL, 0x000fe200078e00ffULL, 0x01ffffff20207812ULL, 0x000fc800078ec0ffULL,
0x000000052000720cULL, 0x000fda0003f06070ULL, 0x00000002c2008824ULL, 0x000fe400078e00ffULL,
0x00006a00ff0b8624ULL, 0x000fc800078e00ffULL, 0x00006a00000b8624ULL, 0x000fc800078e020bULL,
0x00000001200a8824ULL, 0x000fe200078e020bULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040d0cff738cULL, 0x0003e20000000000ULL, 0x000066000a0a8625ULL, 0x000fe200078e0083ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060a248981ULL, 0x000ea2000c1e1900ULL,
0x000001ff1100780cULL, 0x000fe20003f04070ULL, 0x00000080071e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff1f7819ULL, 0x000fe20000011602ULL, 0x000000000cff7f8cULL, 0x0007e2000c80043fULL,
0x0000000102007812ULL, 0x000fc600078ec0ffULL, 0x000000201f807824ULL, 0x000fca00078e00ffULL,
0x000000601e0d7812ULL, 0x002fe200078ef880ULL, 0x00005900240e7a24ULL, 0x004fc800078e02ffULL,
0x000000800e197824ULL, 0x000fe200078e00ffULL, 0x0000040000000947ULL, 0x000fea0003800000ULL,
0x00000080040b7217ULL, 0x008fe20007800000ULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x00000003ff0a7819ULL, 0x000fe40000011608ULL, 0x0000640019157a11ULL, 0x000fe200078838ffULL,
0x000000010b0b7824ULL, 0x000fe200078e0a80ULL, 0x000000040a0f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001000c7824ULL, 0x000fe200078e020aULL, 0x0000000c0a107810ULL, 0x000fe40007ffe0ffULL,
0x000000000b0b7217ULL, 0x000fe20007800000ULL, 0x000000010c0e7824ULL, 0x040fe200078e0208ULL,
0x0000650019197a11ULL, 0x000fe200020f3cffULL, 0x000000080c117824ULL, 0x000fc400078e00ffULL,
0x000000010b0b7824ULL, 0x000fc600078e0a00ULL, 0xfffffff811127812ULL, 0x000fe200078ee20eULL,
0x0000000100117824ULL, 0x000fe200078e0210ULL, 0x000000080a0e7810ULL, 0x040fe40007ffe0ffULL,
0x0000000b0a00720cULL, 0x080fe20003f66070ULL, 0x000000010d0a7824ULL, 0x000fe200078e020cULL,
0x0000000b0e00720cULL, 0x080fe20003f26070ULL, 0x00000001000e7824ULL, 0x040fe200078e020eULL,
0x0000000b0f00720cULL, 0x080fe20003f46070ULL, 0x00000001000f7824ULL, 0x000fe200078e020fULL,
0x0000000b1000720cULL, 0x000fe20003f06070ULL, 0x000000010e0c7824ULL, 0x000fc400078e0208ULL,
0x000000080e177824ULL, 0x000fe400078e00ffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0xfffffff817147812ULL, 0x000fe200078ee20cULL, 0x000000010f007824ULL, 0x040fe200078e0208ULL,
0x000000700a0a7812ULL, 0x000fe200078ef809ULL, 0x000000080f137824ULL, 0x000fe400078e00ffULL,
0x000000010d0c7824ULL, 0x000fe200078e020fULL, 0x0000000a150a7210ULL, 0x000fe20007f9e0ffULL,
0x000000010d0e7824ULL, 0x000fe200078e020eULL, 0xfffffff813007812ULL, 0x000fe200078ee200ULL,
0x000000010d107824ULL, 0x000fe400078e0211ULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x0000000111137824ULL, 0x040fe200078e0208ULL, 0x000000700c0c7812ULL, 0x000fe200078ef809ULL,
0x0000000811167824ULL, 0x000fe400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee213ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fc600078ef809ULL, 0x000000010b0b7824ULL, 0x000fe200020e0619ULL,
0x0000007010107812ULL, 0x000fe400078ef809ULL, 0x000160001f097811ULL, 0x000fe400078e68ffULL,
0x000000150c0c7210ULL, 0x080fe40007f9e0ffULL, 0x000000150e0e7210ULL, 0x080fe20007fbe0ffULL,
0x0000001012137824ULL, 0x100fe200078e0209ULL, 0x0000001510107210ULL, 0x000fe20007fde0ffULL,
0x0000001000157824ULL, 0x000fc400078e0209ULL, 0x000000010d0d7824ULL, 0x000fe200020e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a137faeULL, 0x0003e2000d901c46ULL,
0x0000001014177824ULL, 0x000fe400078e0209ULL, 0x000000010f0f7824ULL, 0x000fe200028e0619ULL,
0x000000000c157faeULL, 0x0003e2000d101c46ULL, 0x0000001016097824ULL, 0x000fe400078e0209ULL,
0x0000000111117824ULL, 0x000fe200030e0619ULL, 0x000000000e177faeULL, 0x0003e8000c901c46ULL,
0x0000000010097faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010000b7824ULL, 0x008fe200078e00ffULL, 0x0000640019177a11ULL, 0x000fc400078038ffULL,
0x000160001f1b7811ULL, 0x000fe400078e68ffULL, 0x0000000b08007211ULL, 0x000fe400078fe8ffULL,
0x0000650019197a11ULL, 0x000fe400000f3cffULL, 0x00000004000c7810ULL, 0x040fe20007ffe0ffULL,
0x00000001000a7824ULL, 0x040fe200078e0208ULL, 0x00000008000e7810ULL, 0x040fe20007ffe0ffULL,
0x00000008000b7824ULL, 0x000fe400078e00ffULL, 0x000000080c107824ULL, 0x000fc400078e00ffULL,
0x000000010e0f7824ULL, 0x000fe200078e0208ULL, 0xfffffff80b127812ULL, 0x000fe200078ee20aULL,
0x000000010c0b7824ULL, 0x000fe400078e0208ULL, 0x000000010d0a7824ULL, 0x000fe200078e0200ULL,
0x0000000c00007810ULL, 0x000fe20007ffe0ffULL, 0x000000080e147824ULL, 0x000fe200078e00ffULL,
0xfffffff810137812ULL, 0x000fe200078ee20bULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20fULL, 0x000000010d0c7824ULL, 0x040fe200078e020cULL,
0x000000700a0a7812ULL, 0x000fe200078ef809ULL, 0x000000010d0e7824ULL, 0x040fe400078e020eULL,
0x000000010d107824ULL, 0x000fe200078e0200ULL, 0x0000000a170a7210ULL, 0x000fe20007f1e0ffULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fc600078ef809ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fc600078ef809ULL, 0x0000000100157824ULL, 0x000fe200078e0208ULL,
0x0000007010097812ULL, 0x000fe200078ef809ULL, 0x0000000800007824ULL, 0x000fe200078e00ffULL,
0x0000000e170e7210ULL, 0x000fe20007f3e0ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0619ULL,
0x0000000c170c7210ULL, 0x000fe20007f1e0ffULL, 0x0000001013137824ULL, 0x000fe200078e021bULL,
0xfffffff800007812ULL, 0x000fe200078ee215ULL, 0x0000001014157824ULL, 0x100fe200078e021bULL,
0x0000000917107210ULL, 0x000fe20007f5e0ffULL, 0x0000001012097824ULL, 0x000fc400078e021bULL,
0x000000010d0d7824ULL, 0x100fe400000e0619ULL, 0x000000010f0f7824ULL, 0x000fe200008e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a097faeULL, 0x0003e2000b901c46ULL,
0x0000001000177824ULL, 0x000fe400078e021bULL, 0x0000000111117824ULL, 0x000fe200010e0619ULL,
0x000000000c137faeULL, 0x0003e8000b901c46ULL, 0x000000000e157faeULL, 0x0003e8000b901c46ULL,
0x0000000010177faeULL, 0x0003e4000b901c46ULL, 0x000000001f0473c2ULL, 0x000ea200000e0000ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x0001a6a81f0c7811ULL, 0x002fe200078e18ffULL, 0x00000000006a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0001a6a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3d7224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff0a7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000020000c0c7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000eb6000008947ULL, 0x000fea0003800000ULL, 0x00000002c21d7824ULL, 0x000fe200078e00ffULL,
0x00000002ff1c7819ULL, 0x000fe20000011602ULL, 0x00006a00ff0a7624ULL, 0x002fe200078e00ffULL,
0x000000011f757812ULL, 0x000fe200078ec0ffULL, 0x000000ffff007224ULL, 0x000fc400078e000bULL,
0x000000ffff0e7224ULL, 0x004fe400078e000dULL, 0x00006a001d1d7624ULL, 0x000fe400078e020aULL,
0xff317217ff097424ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff6b7224ULL, 0x000fc400078e00ffULL, 0x00000000000a7805ULL, 0x01afca0000015200ULL,
0x00000004020c7824ULL, 0x000fca00078e00ffULL, 0xfffffff80c0f7812ULL, 0x000fc800078ec0ffULL,
0x0001a6c80f1a7810ULL, 0x000fe20007ffe0ffULL, 0x01a6cc000f0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a117210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc8000001140dULL,
0x000000110c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060dULL,
0x000000020c0c7819ULL, 0x000fc8000000120dULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6cc000f0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010020a7824ULL, 0x000fe200078e00ffULL,
0x000000011b0b7810ULL, 0x000fe20007ffe0ffULL, 0x0000590024247a24ULL, 0x000fc600078e02ffULL,
0xffffffe00a0c7812ULL, 0x000fe200078ec0ffULL, 0x0000008024257824ULL, 0x000fe200078e00ffULL,
0x000000060b00720cULL, 0x000fc60003f46070ULL, 0x000001001b0c7824ULL, 0x000fca00078e020cULL,
0x000000400c0f7810ULL, 0x000fc80007ffe0ffULL, 0x000000600f0b7812ULL, 0x000fca00078ec0ffULL,
0x000000011e267824ULL, 0x000fe200078e020bULL, 0x000004200000a947ULL, 0x000fea0003800000ULL,
0x000000100a0b7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0e7819ULL, 0x000fe40000011608ULL,
0x0000000f040a7217ULL, 0x000fe40007800000ULL, 0x000000080e107810ULL, 0x040fe20007ffe0ffULL,
0x000000010e0d7824ULL, 0x000fe200078e020bULL, 0x0000640025217a11ULL, 0x000fe200078c38ffULL,
0x000000010a0a7824ULL, 0x000fc400078e0a0fULL, 0x00000010080f7824ULL, 0x000fe200078e00ffULL,
0x0000650025257a11ULL, 0x000fe200030f3cffULL, 0x000000010d0c7824ULL, 0x040fe200078e0208ULL,
0x0000000b0a0a7217ULL, 0x000fe20007800000ULL, 0x000000080d117824ULL, 0x000fe200078e00ffULL,
0x000000700f237812ULL, 0x000fe400078ec0ffULL, 0x000000040e0f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff811127812ULL, 0x000fe200078ee20cULL, 0x000000010a0c7824ULL, 0x000fe200078e0a0bULL,
0x0000000c0e117810ULL, 0x000fe20007ffe0ffULL, 0x00000001260a7824ULL, 0x000fc400078e020dULL,
0x000000010f0d7824ULL, 0x140fe200078e020bULL, 0x0000000c0f00720cULL, 0x080fe20003f86070ULL,
0x00000001100f7824ULL, 0x100fe200078e020bULL, 0x0000000c0e00720cULL, 0x080fe20003fa6070ULL,
0x0000000111177824ULL, 0x040fe200078e020bULL, 0x0000000c1000720cULL, 0x080fe20003f66070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000c1100720cULL, 0x000fc60003f06070ULL,
0x000000010d0e7824ULL, 0x140fe200078e0208ULL, 0x000000230a107212ULL, 0x000fe200078efcffULL,
0x000000080d197824ULL, 0x000fe400078e00ffULL, 0x00000001260d7824ULL, 0x000fe200078e020dULL,
0x0000001021107210ULL, 0x000fe20007fde0ffULL, 0x000000010f0a7824ULL, 0x000fe200078e0208ULL,
0xfffffff819247812ULL, 0x000fe200078ee20eULL, 0x000000800d0c7825ULL, 0x000fc800078e00ffULL,
0x00000001260e7824ULL, 0x000fe200078e020fULL, 0x000000230c0c7212ULL, 0x000fe200078efcffULL,
0x000000080f277824ULL, 0x000fe400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000000126197824ULL, 0x000fe200078e0217ULL, 0xfffffff827267812ULL, 0x000fe200078ee20aULL,
0x000000010b117824ULL, 0x000fe200030e0625ULL, 0x000000210c0c7210ULL, 0x000fe20007fde0ffULL,
0x00000080190a7825ULL, 0x000fe200078e00ffULL, 0x000000230e0e7212ULL, 0x000fc600078efcffULL,
0x000000010d0d7824ULL, 0x100fe200030e0625ULL, 0x000000210e0e7210ULL, 0x000fe20007fde0ffULL,
0x0000000117197824ULL, 0x040fe200078e0208ULL, 0x000000230a0a7212ULL, 0x000fe200078efcffULL,
0x0000000817287824ULL, 0x000fe200078e00ffULL, 0x000170001f177811ULL, 0x000fe200078e68ffULL,
0x000000010f0f7824ULL, 0x000fe200030e0625ULL, 0x000000210a0a7210ULL, 0x000fe40007fde0ffULL,
0xfffffff828287812ULL, 0x000fe200078ee219ULL, 0x0000001012197824ULL, 0x000fc400078e0217ULL,
0x0000001024217824ULL, 0x100fe400078e0217ULL, 0x0000001026237824ULL, 0x100fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010197faeULL, 0x0003e2000e901c46ULL,
0x0000001028177824ULL, 0x000fe400078e0217ULL, 0x000000010b0b7824ULL, 0x000fe200030e0625ULL,
0x000000000c217faeULL, 0x0003e8000e101c46ULL, 0x000000000e237faeULL, 0x0003e8000d901c46ULL,
0x000000000a177faeULL, 0x0003e2000c101c46ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x000000100a0b7812ULL, 0x000fe400078ec0ffULL, 0x0000640025297a11ULL, 0x000fc400078038ffULL,
0x0000000b080b7211ULL, 0x000fe400078fe8ffULL, 0x0000650025257a11ULL, 0x000fe400000f3cffULL,
0x000000040b0d7810ULL, 0x040fe20007ffe0ffULL, 0x000000010b0a7824ULL, 0x140fe200078e0208ULL,
0x000000080b0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000080b117824ULL, 0x000fe400078e00ffULL,
0x000000010d0c7824ULL, 0x040fe400078e0208ULL, 0x000000080d197824ULL, 0x000fe200078e00ffULL,
0xfffffff811127812ULL, 0x000fe200078ee20aULL, 0x00000001260a7824ULL, 0x000fe200078e020bULL,
0x0000000c0b117810ULL, 0x000fe20007ffe0ffULL, 0x000000010f0e7824ULL, 0x000fe200078e0208ULL,
0xfffffff819197812ULL, 0x000fe200078ee20cULL, 0x00000010080c7824ULL, 0x000fc400078e00ffULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0x000000700c277812ULL, 0x000fe200078ec0ffULL,
0x000000080f217824ULL, 0x000fe400078e00ffULL, 0x00000001260d7824ULL, 0x000fe200078e020dULL,
0x000000270a0a7212ULL, 0x000fe200078efcffULL, 0x00000001260f7824ULL, 0x040fe200078e020fULL,
0xfffffff821217812ULL, 0x000fe200078ee20eULL, 0x0000000126107824ULL, 0x000fe200078e0211ULL,
0x0000000a290a7210ULL, 0x000fe20007f1e0ffULL, 0x000000800d0c7825ULL, 0x000fc800078e00ffULL,
0x0000000111177824ULL, 0x040fe200078e0208ULL, 0x000000270c0c7212ULL, 0x000fe200078efcffULL,
0x0000000811247824ULL, 0x000fe400078e00ffULL, 0x000000800f0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff824237812ULL, 0x000fe200078ee217ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000270e0e7212ULL, 0x080fe400078efcffULL, 0x000170001f247811ULL, 0x000fe200078e68ffULL,
0x000000010b0b7824ULL, 0x100fe200000e0625ULL, 0x0000002710107212ULL, 0x000fe400078efcffULL,
0x0000000c290c7210ULL, 0x040fe20007f1e0ffULL, 0x0000001012177824ULL, 0x100fe200078e0224ULL,
0x0000000e290e7210ULL, 0x000fe20007f7e0ffULL, 0x0000001019197824ULL, 0x100fe200078e0224ULL,
0x0000001029107210ULL, 0x000fe20007f9e0ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a177faeULL, 0x0003e2000b901c46ULL,
0x0000001021217824ULL, 0x000fc400078e0224ULL, 0x000000010f0f7824ULL, 0x100fe200018e0625ULL,
0x000000000c197faeULL, 0x0003e2000b901c46ULL, 0x0000001023237824ULL, 0x000fe400078e0224ULL,
0x0000000111117824ULL, 0x000fe200020e0625ULL, 0x000000000e217faeULL, 0x0003e8000b901c46ULL,
0x0000000010237faeULL, 0x0003e4000b901c46ULL, 0x00000008020c7824ULL, 0x002fe200078e00ffULL,
0x00000001200a7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff00c107812ULL, 0x000fe400078ec0ffULL, 0x000000050a00720cULL, 0x000fe40003f06070ULL,
0x00000000100573c2ULL, 0x000e6200000e0000ULL, 0xffffffe00c237812ULL, 0x040fe400078ec0ffULL,
0x000000100c0e7812ULL, 0x040fe400078ec0ffULL, 0x000000080c0c7812ULL, 0x000fcc00078ec0ffULL,
0x000000011d0a8824ULL, 0x000fe400078e020aULL, 0x00000004ff0b8424ULL, 0x000fe200078e00ffULL,
0x000000230c237210ULL, 0x000fe40007ffe00eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000066000a0a8625ULL, 0x000fca00078e000bULL, 0x000000060a248981ULL, 0x000522000c1e1900ULL,
0x0001a6b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x01a6b00010267f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a60800230e7f8cULL, 0x000664000c80043fULL, 0x00000000000a7805ULL, 0x000fc40000015200ULL,
0x01a60c00230d7984ULL, 0x000ee40000000800ULL, 0x800000000dff7812ULL, 0x00afe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a117210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc8000001140dULL,
0x000000110c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060dULL,
0x000000020c0c7819ULL, 0x000fc8000000120dULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60c00230d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001008197824ULL, 0x000fe200078e00ffULL, 0x00000001ff747819ULL, 0x000fe20000011608ULL,
0x00000020020a7824ULL, 0x000fc600078e00ffULL, 0x0000007019197812ULL, 0x000fe400078ec0ffULL,
0xffffff800a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000000c74747812ULL, 0x000fc800078ec0ffULL,
0x0000000a740a7210ULL, 0x000fca0007ffe019ULL, 0x01a000000a0c7984ULL, 0x000e680000000800ULL,
0x01a200000a0b7984ULL, 0x0006a20000000800ULL, 0x000000090c00720bULL, 0x002fe20003f1d000ULL,
0x0001a4a27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000a7806ULL, 0x008fc800000e0100ULL,
0x000000ff0a00720cULL, 0x000fe20003f05270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff217224ULL, 0x000fd200078e0009ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x000000021c00720cULL, 0x000fe40003f05270ULL,
0x000000090c00720bULL, 0x000fe20003f74000ULL, 0x0001a4727f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x000fc400018e0100ULL, 0x00000080020f8824ULL, 0x000fe200078e0219ULL,
0x000000090c217209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000174128824ULL, 0x000fca00078e020fULL, 0x01a4002112008388ULL, 0x0003e20000000800ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000000921097221ULL, 0x002fe20000010100ULL, 0x000000ff0dff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x0000000900127308ULL, 0x000e640000000800ULL, 0x0000001222227220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe20000011608ULL,
0x0001a3c27f007947ULL, 0x000fea000b800000ULL, 0x00001f2912297589ULL, 0x0002e400000e0000ULL,
0x000000292c2c7220ULL, 0x08cfe40000410000ULL, 0x000000292d2d7220ULL, 0x080fe40000410000ULL,
0x0000002930307220ULL, 0x080fe40000410000ULL, 0x0000002931317220ULL, 0x080fe40000410000ULL,
0x0000002934347220ULL, 0x080fe40000410000ULL, 0x0000002935357220ULL, 0x000fc40000410000ULL,
0x0000002938387220ULL, 0x080fe40000410000ULL, 0x0000002939397220ULL, 0x080fe40000410000ULL,
0x000000293c3c7220ULL, 0x080fe40000410000ULL, 0x000000293d3d7220ULL, 0x080fe40000410000ULL,
0x0000002940407220ULL, 0x080fe40000410000ULL, 0x0000002941417220ULL, 0x000fc40000410000ULL,
0x0000002944447220ULL, 0x080fe40000410000ULL, 0x0000002945457220ULL, 0x080fe40000410000ULL,
0x0000002948487220ULL, 0x080fe40000410000ULL, 0x0000002949497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000dff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000808297811ULL, 0x000fe200078ff0ffULL, 0x0001a2b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2912297589ULL, 0x00066400000e0000ULL, 0x000000292e2e7220ULL, 0x086fe40000410000ULL,
0x000000292f2f7220ULL, 0x080fe40000410000ULL, 0x0000002932327220ULL, 0x080fe40000410000ULL,
0x0000002933337220ULL, 0x080fe40000410000ULL, 0x0000002936367220ULL, 0x080fe40000410000ULL,
0x0000002937377220ULL, 0x000fc40000410000ULL, 0x000000293a3a7220ULL, 0x080fe40000410000ULL,
0x000000293b3b7220ULL, 0x080fe40000410000ULL, 0x000000293e3e7220ULL, 0x080fe40000410000ULL,
0x000000293f3f7220ULL, 0x080fe40000410000ULL, 0x0000002942427220ULL, 0x080fe40000410000ULL,
0x0000002943437220ULL, 0x000fc40000410000ULL, 0x0000002946467220ULL, 0x080fe40000410000ULL,
0x0000002947477220ULL, 0x080fe40000410000ULL, 0x000000294a4a7220ULL, 0x080fe40000410000ULL,
0x000000294b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00000dff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001008297811ULL, 0x000fe200078ff0ffULL,
0x0001a1a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2912297589ULL, 0x0002e400000e0000ULL,
0x000000294c4c7220ULL, 0x08cfe40000410000ULL, 0x000000294d4d7220ULL, 0x080fe40000410000ULL,
0x0000002950507220ULL, 0x080fe40000410000ULL, 0x0000002951517220ULL, 0x080fe40000410000ULL,
0x0000002954547220ULL, 0x080fe40000410000ULL, 0x0000002955557220ULL, 0x000fc40000410000ULL,
0x0000002958587220ULL, 0x080fe40000410000ULL, 0x0000002959597220ULL, 0x080fe40000410000ULL,
0x000000295c5c7220ULL, 0x080fe40000410000ULL, 0x000000295d5d7220ULL, 0x080fe40000410000ULL,
0x0000002960607220ULL, 0x080fe40000410000ULL, 0x0000002961617220ULL, 0x000fc40000410000ULL,
0x0000002964647220ULL, 0x080fe40000410000ULL, 0x0000002965657220ULL, 0x080fe40000410000ULL,
0x0000002968687220ULL, 0x080fe40000410000ULL, 0x0000002969697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000000dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001808297811ULL, 0x000fe200078ff0ffULL,
0x0001a0a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2912297589ULL, 0x0002e400000e0000ULL,
0x000000294e4e7220ULL, 0x08cfe40000410000ULL, 0x000000294f4f7220ULL, 0x080fe40000410000ULL,
0x0000002952527220ULL, 0x080fe40000410000ULL, 0x0000002953537220ULL, 0x080fe40000410000ULL,
0x0000002956567220ULL, 0x080fe40000410000ULL, 0x0000002957577220ULL, 0x000fc40000410000ULL,
0x000000295a5a7220ULL, 0x080fe40000410000ULL, 0x000000295b5b7220ULL, 0x080fe40000410000ULL,
0x000000295e5e7220ULL, 0x080fe40000410000ULL, 0x000000295f5f7220ULL, 0x080fe40000410000ULL,
0x0000002962627220ULL, 0x080fe40000410000ULL, 0x0000002963637220ULL, 0x000fc40000410000ULL,
0x0000002966667220ULL, 0x080fe40000410000ULL, 0x0000002967677220ULL, 0x080fe40000410000ULL,
0x000000296a6a7220ULL, 0x080fe40000410000ULL, 0x000000296b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000000d0aff7212ULL, 0x000fda00078030ffULL,
0x800000210c0c0221ULL, 0x000fe20000010000ULL, 0x00007610ff0e0816ULL, 0x000fc6000000000eULL,
0x3fb8aa3b0c0c0820ULL, 0x000fc80000410000ULL, 0x0000000c00180308ULL, 0x000e640000000800ULL,
0x000000180b0b0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000220b227221ULL, 0x004fc40000010000ULL, 0x00000000000a7805ULL, 0x000fca0000015200ULL,
0x01a6ac0010097984ULL, 0x000e620000000800ULL, 0x0001a6a810177810ULL, 0x000fe40007ffe0ffULL,
0x8000000009ff7812ULL, 0x002fe20007804800ULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc8000001140dULL,
0x0000000c09097211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x0000000209097819ULL, 0x000fc8000000120cULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6ac0010097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100e007816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000018ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff097819ULL, 0x000fe40000011608ULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x00019c827f007947ULL, 0x000fea000b800000ULL, 0x00001f0900167589ULL, 0x0002a400000e0000ULL,
0x0000000809297810ULL, 0x000fe20007ffe0ffULL, 0x00019cd27f007947ULL, 0x000fea000b800000ULL,
0x00000010090b7810ULL, 0x000fe20007ffe0ffULL, 0x00001f2900157589ULL, 0x0002e800000e0000ULL,
0x00001f0b00147589ULL, 0x0002a400000e0000ULL, 0x0000001809297810ULL, 0x002fe20007ffe0ffULL,
0x00019d627f007947ULL, 0x000fea000b800000ULL, 0x00001f2900137589ULL, 0x0002e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000202257824ULL, 0x000fe200078e00ffULL,
0x00000008080b7812ULL, 0x000fe200078ec0ffULL, 0x00001000020c7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000026000007945ULL, 0x000fe20003800000ULL,
0x0000000425097812ULL, 0x000fc400078ec0ffULL, 0x000000070b127812ULL, 0x008fe200078ef808ULL,
0x00000004020b7824ULL, 0x000fe200078e00ffULL, 0x0000000908007211ULL, 0x002fe400078fe0ffULL,
0x0000001012117812ULL, 0x040fe200078efcffULL, 0x00000008120d7824ULL, 0x040fe200078e00ffULL,
0x000000040b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000112107824ULL, 0x000fe200078e0200ULL,
0xffffe0000c0c7812ULL, 0x000fe200078ec0ffULL, 0x00000001000f7824ULL, 0x000fe400078e0211ULL,
0x0000040002007824ULL, 0x000fe200078e00ffULL, 0xfffffff80d107812ULL, 0x000fe200078ee210ULL,
0x00000008110a7824ULL, 0x000fe200078e00ffULL, 0x000160000c0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000008120e7824ULL, 0x000fe200078e00ffULL, 0xfffff00000007812ULL, 0x000fe200078ec0ffULL,
0x0000000812787824ULL, 0x000fe200078e00ffULL, 0xfffffff80a0f7812ULL, 0x000fc400078ee20fULL,
0x0000000b080a7211ULL, 0x000fe400078fe0ffULL, 0x0001200000007810ULL, 0x000fc60007ffe0ffULL,
0x00000001120b7824ULL, 0x000fe400078e020aULL, 0x00000010106c7824ULL, 0x100fe400078e0200ULL,
0x000000100f287824ULL, 0x000fe200078e0200ULL, 0xfffffff80e0e7812ULL, 0x000fe400078ee20bULL,
0x000000020b0d7810ULL, 0x000fe20007ffe0ffULL, 0x000000006c6c783bULL, 0x000e640000000200ULL,
0x000000100e707824ULL, 0x000fc400078e020cULL, 0x000000002828783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x000000166c6c7231ULL, 0x086fe400003400ffULL,
0x000000166e6e7231ULL, 0x000fe400003400ffULL, 0x000000156d6d7231ULL, 0x080fe400003400ffULL,
0x000000156f6f7231ULL, 0x000fe400003400ffULL, 0x0000001428287231ULL, 0x088fe400003400ffULL,
0x000000142a2a7231ULL, 0x000fc400003400ffULL, 0x0000001329297231ULL, 0x080fe400003400ffULL,
0x000000132b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff8780d7812ULL, 0x000fe200078ee20dULL, 0x000000007070783bULL, 0x000ee20000004200ULL,
0x0000000209097812ULL, 0x000fe200078efcffULL, 0x0000106000007945ULL, 0x000fe40003800000ULL,
0x000000100d787824ULL, 0x000fe200078e020cULL, 0x0000000908097211ULL, 0x000fca00078fe0ffULL,
0x000000007878783bULL, 0x000ea20000004200ULL, 0x0000010070957824ULL, 0x008fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe20000011472ULL, 0x0000010071987824ULL, 0x000fe200078e00ffULL,
0x0000007000927306ULL, 0x000fe20000009400ULL, 0x00000018ff0c7819ULL, 0x000fe20000011470ULL,
0x0000010072a97824ULL, 0x000fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe20000011495ULL,
0x0000010073ac7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9e7819ULL, 0x000fe40000011498ULL,
0x00000018ff967819ULL, 0x004fe20000011479ULL, 0x0000007e00ae7306ULL, 0x000fe20000209400ULL,
0x00000018ff7d7819ULL, 0x000fe20000011471ULL, 0x0000010078bb7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe2000001147aULL, 0x0000010079be7824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fc40000011473ULL, 0x00000018ff9d7819ULL, 0x000fe2000001147bULL,
0x0000007e00af7306ULL, 0x000fe20000205400ULL, 0x00000018ffa97819ULL, 0x000fe400000114a9ULL,
0x00000018ffb27819ULL, 0x000fe400000114acULL, 0x00000018ffbb7819ULL, 0x000fe400000114bbULL,
0x00000018ffc47819ULL, 0x000fe200000114beULL, 0x0000007e008b7306ULL, 0x000ff0000020d400ULL,
0x0000009600c77306ULL, 0x000ff00000209400ULL, 0x0000009600ca7306ULL, 0x000ff00000205400ULL,
0x00000096007e7306ULL, 0x000ff0000020d400ULL, 0x0000007000937306ULL, 0x000eb00000005400ULL,
0x00000071009c7306ULL, 0x000ff00000009400ULL, 0x0000007100a17306ULL, 0x000ee20000005400ULL,
0x000000939200720bULL, 0x004fce0003fdd000ULL, 0x0000009500967306ULL, 0x000ff00000209400ULL,
0x0000009500977306ULL, 0x000ea20000205400ULL, 0x000000a19c00720bULL, 0x008fce0003f9d000ULL,
0x0000009e00a07306ULL, 0x000ff00000209400ULL, 0x0000009e00a37306ULL, 0x000ee20000205400ULL,
0x000000979600720bULL, 0x004fce0003fbd000ULL, 0x0000007000947306ULL, 0x000470000000d400ULL,
0x0000007100917306ULL, 0x000262000000d400ULL, 0x0001000070707824ULL, 0x004fe200078e00ffULL,
0x000000a3a000720bULL, 0x008fc80003f7d000ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000007d00a57306ULL, 0x000fe20000209400ULL, 0x0001000071717824ULL, 0x002fe200078e00ffULL,
0x0000000194946812ULL, 0x000fc800078efcffULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000007d00a87306ULL, 0x000e620000205400ULL, 0x0000000191914812ULL, 0x000fce00078efcffULL,
0x0000007d008f7306ULL, 0x000eb0000020d400ULL, 0x0000009b00857306ULL, 0x000fe20000209400ULL,
0x000000a8a500720bULL, 0x002fce0003f9d000ULL, 0x0000009b00887306ULL, 0x000fec0000205400ULL,
0x000000018f8f4812ULL, 0x004fe400078efcffULL, 0x0000009b007d7306ULL, 0x000ff0000020d400ULL,
0x0000009500997306ULL, 0x000e70000020d400ULL, 0x0000009e00a27306ULL, 0x000eb0000020d400ULL,
0x0000000c009a7306ULL, 0x000fe20000209400ULL, 0x0000000199995812ULL, 0x002fce00078efcffULL,
0x0000000c009f7306ULL, 0x000e620000205400ULL, 0x00000001a2a23812ULL, 0x004fce00078efcffULL,
0x0000007000987306ULL, 0x000ff00000209400ULL, 0x00000070009b7306ULL, 0x000ea20000205400ULL,
0x0000009f9a00720bULL, 0x002fce0003fdd000ULL, 0x0000007100957306ULL, 0x000ff00000209400ULL,
0x0000007100a47306ULL, 0x000e620000205400ULL, 0x0000009b9800720bULL, 0x004fce0003fbd000ULL,
0x0000000c00907306ULL, 0x0004f0000020d400ULL, 0x0000008600b77306ULL, 0x000fe20000209400ULL,
0x00000018ff0c7819ULL, 0x004fe40000011478ULL, 0x000000a49500720bULL, 0x002fca0003f7d000ULL,
0x0000008600ba7306ULL, 0x000fe20000205400ULL, 0x0000000190906812ULL, 0x008fce00078efcffULL,
0x0000008600837306ULL, 0x000ff0000020d400ULL, 0x0000000c00c07306ULL, 0x000ff00000209400ULL,
0x0000000c00c17306ULL, 0x000ff00000205400ULL, 0x0000000c00817306ULL, 0x000ff0000020d400ULL,
0x0000009d00897306ULL, 0x000ff00000209400ULL, 0x0000009d00867306ULL, 0x000ff00000205400ULL,
0x0000009d000c7306ULL, 0x000ff0000020d400ULL, 0x00000070009d7306ULL, 0x000e70000020d400ULL,
0x0000007100a67306ULL, 0x000eb0000020d400ULL, 0x0000007200a77306ULL, 0x000fe20000009400ULL,
0x000000019d9d5812ULL, 0x002fce00078efcffULL, 0x0000007200aa7306ULL, 0x000e620000005400ULL,
0x00000001a6a63812ULL, 0x004fce00078efcffULL, 0x0000007300b07306ULL, 0x000ff00000009400ULL,
0x0000007300b17306ULL, 0x000ea20000005400ULL, 0x000000aaa700720bULL, 0x002fce0003fdd000ULL,
0x000000a9009e7306ULL, 0x000ff00000209400ULL, 0x000000a900ab7306ULL, 0x000e620000205400ULL,
0x000000b1b000720bULL, 0x004fce0003f9d000ULL, 0x000000b200b37306ULL, 0x000ff00000209400ULL,
0x000000b200b47306ULL, 0x000ea20000205400ULL, 0x000000ab9e00720bULL, 0x002fce0003fbd000ULL,
0x00000072008e7306ULL, 0x0002f0000000d400ULL, 0x00000073008a7306ULL, 0x0006e2000000d400ULL,
0x0001000072727824ULL, 0x002fe200078e00ffULL, 0x000000b4b300720bULL, 0x004fc80003f7d000ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x000000a900ad7306ULL, 0x000e62000020d400ULL,
0x0001000073737824ULL, 0x008fe200078e00ffULL, 0x000000018e8e6812ULL, 0x000fe400078efcffULL,
0x000000afae00720bULL, 0x000fe40003fdd000ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x000000b200b57306ULL, 0x000ea2000020d400ULL, 0x000000018a8a4812ULL, 0x000fc400078efcffULL,
0x000000bab700720bULL, 0x000fca0003f9d000ULL, 0x0000007200707306ULL, 0x000fe20000209400ULL,
0x00000001adad5812ULL, 0x002fe400078efcffULL, 0x000000018b8b6812ULL, 0x000fca00078efcffULL,
0x0000007200717306ULL, 0x000e620000205400ULL, 0x00000001b5b53812ULL, 0x004fe400078efcffULL,
0x0000000183834812ULL, 0x000fca00078efcffULL, 0x0000007300a97306ULL, 0x000ff00000209400ULL,
0x0000007300b67306ULL, 0x000ea20000205400ULL, 0x000000717000720bULL, 0x002fe40003fbd000ULL,
0x00000091a271723eULL, 0x000fc400000010ffULL, 0x000000949970723eULL, 0x000fc600000010ffULL,
0x0000007200ac7306ULL, 0x000e68000020d400ULL, 0x000000706c2c723cULL, 0x000f68000004182cULL,
0x0000007300b87306ULL, 0x000ee2000020d400ULL, 0x000000b6a900720bULL, 0x004fc60003f7d000ULL,
0x00000070284c723cULL, 0x000f68000004184cULL, 0x0000007800b97306ULL, 0x000fe20000009400ULL,
0x00000001acac5812ULL, 0x002fce00078efcffULL, 0x0000007800bc7306ULL, 0x000e620000005400ULL,
0x00000001b8b83812ULL, 0x008fce00078efcffULL, 0x0000007900c27306ULL, 0x000ff00000009400ULL,
0x0000007900c37306ULL, 0x000ea20000005400ULL, 0x000000bcb900720bULL, 0x002fce0003fdd000ULL,
0x000000bb00b27306ULL, 0x000ff00000209400ULL, 0x000000bb00bd7306ULL, 0x000e620000205400ULL,
0x000000c3c200720bULL, 0x004fce0003f9d000ULL, 0x000000c400c57306ULL, 0x000ff00000209400ULL,
0x000000c400c67306ULL, 0x000ea20000205400ULL, 0x000000bdb200720bULL, 0x002fce0003fbd000ULL,
0x0000007800827306ULL, 0x0002f0000000d400ULL, 0x00000079007f7306ULL, 0x0006e2000000d400ULL,
0x0001000078787824ULL, 0x002fe200078e00ffULL, 0x000000c6c500720bULL, 0x004fc80003f7d000ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x000000bb00bf7306ULL, 0x000e62000020d400ULL,
0x0001000079797824ULL, 0x008fe200078e00ffULL, 0x0000000182826812ULL, 0x000fe400078efcffULL,
0x000000c1c000720bULL, 0x000fe40003fdd000ULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x000000c400c87306ULL, 0x000ea2000020d400ULL, 0x000000017f7f4812ULL, 0x000fce00078efcffULL,
0x0000007800727306ULL, 0x000fe20000209400ULL, 0x00000001bfbf5812ULL, 0x002fe400078efcffULL,
0x0000000181816812ULL, 0x000fe400078efcffULL, 0x00000082bf82723eULL, 0x000fc600000010ffULL,
0x0000007800737306ULL, 0x000e620000205400ULL, 0x00000001c8c83812ULL, 0x004fe400078efcffULL,
0x000000cac700720bULL, 0x000fca0003f7d000ULL, 0x0000007900927306ULL, 0x000ff00000209400ULL,
0x0000007900937306ULL, 0x000ea20000205400ULL, 0x000000737200720bULL, 0x002fe40003fbd000ULL,
0x0000009d9072723eULL, 0x000fc400000010ffULL, 0x000000a68f73723eULL, 0x000fe400000010ffULL,
0x000000017e7e3812ULL, 0x000fe200078efcffULL, 0x0000007800be7306ULL, 0x0002e8000020d400ULL,
0x000000726c30723cULL, 0x000f680000041830ULL, 0x0000007900977306ULL, 0x0006e2000020d400ULL,
0x000001007a787824ULL, 0x002fe200078e00ffULL, 0x000000939200720bULL, 0x004fc40003f9d000ULL,
0x000000722850723cULL, 0x000f640000041850ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007a008c7306ULL, 0x000fe20000009400ULL, 0x000001007b797824ULL, 0x008fe200078e00ffULL,
0x00000001bebe5812ULL, 0x000fc800078efcffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000007a008d7306ULL, 0x000e620000005400ULL, 0x0000000197974812ULL, 0x000fe400078efcffULL,
0x000000be81be723eULL, 0x000fe400000010ffULL, 0x000000977ebf723eULL, 0x000fc600000010ffULL,
0x0000007b00847306ULL, 0x000fe80000009400ULL, 0x000000be6c40723cULL, 0x000f680000041840ULL,
0x0000007b00877306ULL, 0x000ea20000005400ULL, 0x0000008d8c00720bULL, 0x002fc60003fdd000ULL,
0x000000be2860723cULL, 0x000f680000041860ULL, 0x0000007800957306ULL, 0x000ff00000209400ULL,
0x0000007800967306ULL, 0x000e620000205400ULL, 0x000000878400720bULL, 0x004fce0003f7d000ULL,
0x00000079009c7306ULL, 0x000ff00000209400ULL, 0x00000079009f7306ULL, 0x000ea20000205400ULL,
0x000000969500720bULL, 0x002fce0003fbd000ULL, 0x0000007a007c7306ULL, 0x0002f0000000d400ULL,
0x0000007b000b7306ULL, 0x0006e2000000d400ULL, 0x000100007a7a7824ULL, 0x002fe200078e00ffULL,
0x0000009f9c00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff987819ULL, 0x000fe4000001147aULL,
0x00000079009e7306ULL, 0x0002a2000020d400ULL, 0x000100007b7b7824ULL, 0x008fe200078e00ffULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x000000868900720bULL, 0x000fe40003fdd000ULL,
0x00000018ff907819ULL, 0x000fe4000001147bULL, 0x00000078009b7306ULL, 0x0006e2000020d400ULL,
0x0000008ab579723eULL, 0x002fc400000010ffULL, 0x000000010b0b3812ULL, 0x000fe400078efcffULL,
0x000000b8837b723eULL, 0x000fe400000010ffULL, 0x0000007fc883723eULL, 0x000fe200000010ffULL,
0x00000098009a7306ULL, 0x000fe20000209400ULL, 0x000000019e9e4812ULL, 0x004fe400078efcffULL,
0x000000010c0c6812ULL, 0x000fe400078efcffULL, 0x0000008ead78723eULL, 0x008fe200000010ffULL,
0x000000826c3c723cULL, 0x000f62000004183cULL, 0x000000ac8b7a723eULL, 0x000fe200000010ffULL,
0x0000009800917306ULL, 0x000e620000205400ULL, 0x000000019b9b5812ULL, 0x000fc400078efcffULL,
0x000000888500720bULL, 0x000fe40003fbd000ULL, 0x0000007c9b7e723eULL, 0x000fe200000010ffULL,
0x000000786c34723cULL, 0x000f620000041834ULL, 0x0000000b9e7f723eULL, 0x000fe200000010ffULL,
0x00000090008f7306ULL, 0x000fe20000209400ULL, 0x00000001110b7824ULL, 0x000fca00078e0209ULL,
0x0000007a6c38723cULL, 0x000f640000041838ULL, 0x00000090008a7306ULL, 0x000ea20000205400ULL,
0x000000919a00720bULL, 0x002fe40003f9d000ULL, 0x000000017d7d5812ULL, 0x000fc600078efcffULL,
0x0000007e6c44723cULL, 0x000f640000041844ULL, 0x0000009800987306ULL, 0x000e6c000020d400ULL,
0x000000782854723cULL, 0x000b640000041854ULL, 0x0000009000997306ULL, 0x000ee2000020d400ULL,
0x0000008a8f00720bULL, 0x004fc80003f7d000ULL, 0x0000000811797824ULL, 0x020fe200078e00ffULL,
0x0000007a2858723cULL, 0x000f620000041858ULL, 0x0000000198984812ULL, 0x002fc800078efcffULL,
0x000000987d98723eULL, 0x000fc600000010ffULL, 0x00000082285c723cULL, 0x000f62000004185cULL,
0x0000000199993812ULL, 0x008fc800078efcffULL, 0x000000990c99723eULL, 0x000fe200000010ffULL,
0x00000001120c7824ULL, 0x040fe400078e0209ULL, 0x0000007e2864723cULL, 0x000f700000041864ULL,
0x000000986c48723cULL, 0x080b6e0000041848ULL, 0x00000008126d7824ULL, 0x020fe200078e00ffULL,
0x000000982868723cULL, 0x000b620000041868ULL, 0x00000008116c7824ULL, 0x000fc400078e00ffULL,
0x00000008116e7824ULL, 0x000fe200078e00ffULL, 0xfffffff86d0c7812ULL, 0x000fe200078ee20cULL,
0x00000001116d7824ULL, 0x000fe200078e020aULL, 0xfffffff86c0b7812ULL, 0x000fe400078ee20bULL,
0x000160001f0a7811ULL, 0x000fe200078e68ffULL, 0x000000100c6c7824ULL, 0x100fe200078e0200ULL,
0xfffffff86e097812ULL, 0x000fe200078ee26dULL, 0x000000100b007824ULL, 0x000fe200078e0200ULL,
0x000000026d787810ULL, 0x000fc60007ffe0ffULL, 0x000000006c6c783bULL, 0x000e620000000200ULL,
0x0000001009707824ULL, 0x000fc600078e020aULL, 0x000000000028783bULL, 0x0204e20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x000000166c6c7231ULL, 0x082fe400003400ffULL,
0x000000166e6e7231ULL, 0x000fe400003400ffULL, 0x000000156d6d7231ULL, 0x080fe400003400ffULL,
0x000000156f6f7231ULL, 0x000fe400003400ffULL, 0x0000001428287231ULL, 0x088fe400003400ffULL,
0x000000142a2a7231ULL, 0x000fc400003400ffULL, 0x0000001329297231ULL, 0x080fe400003400ffULL,
0x000000132b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff879007812ULL, 0x004fe200078ee278ULL, 0x000000007070783bULL, 0x000ea20000004200ULL,
0xfffffff825257812ULL, 0x000fc600078ec0ffULL, 0x0000001000787824ULL, 0x000fcc00078e020aULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x0000007000987306ULL, 0x004fe20000009400ULL,
0x00000018ff7c7819ULL, 0x000fe20000011470ULL, 0x00000100709a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe20000011471ULL, 0x00000100719f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011472ULL, 0x0000010072af7824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe20000011473ULL, 0x00000070009b7306ULL, 0x000ea20000005400ULL,
0x00000018ffa67819ULL, 0x000fe2000001149fULL, 0x0000010073b27824ULL, 0x000fe200078e00ffULL,
0x00000018ffa07819ULL, 0x008fe2000001147aULL, 0x0000010078c17824ULL, 0x000fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe20000011479ULL, 0x0000010079c47824ULL, 0x000fe200078e00ffULL,
0x00000018ffa17819ULL, 0x000fe2000001147bULL, 0x0000007000957306ULL, 0x000662000000d400ULL,
0x00000018ff9a7819ULL, 0x000fc4000001149aULL, 0x00000018ffaf7819ULL, 0x000fe400000114afULL,
0x00000018ffb87819ULL, 0x000fe400000114b2ULL, 0x00000018ffc17819ULL, 0x000fe200000114c1ULL,
0x0000007100a47306ULL, 0x000fe20000009400ULL, 0x0001000070707824ULL, 0x008fe200078e00ffULL,
0x0000009b9800720bULL, 0x004fe20003f7d000ULL, 0x000001007a9b7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe400000114c4ULL, 0x00000018ff707819ULL, 0x000fc40000011470ULL,
0x0000007100a57306ULL, 0x000ea20000005400ULL, 0x00000018ff9b7819ULL, 0x000fcc000001149bULL,
0x0000000195953812ULL, 0x002fe200078efcffULL, 0x0000007f00ab7306ULL, 0x000ff00000209400ULL,
0x0000007f00ae7306ULL, 0x000fe20000205400ULL, 0x000000a5a400720bULL, 0x004fce0003f9d000ULL,
0x0000007f008f7306ULL, 0x000ff0000020d400ULL, 0x000000a000877306ULL, 0x000ff00000209400ULL,
0x000000a0008a7306ULL, 0x000ff00000205400ULL, 0x000000a0007f7306ULL, 0x000ff0000020d400ULL,
0x00000070009f7306ULL, 0x000ff00000209400ULL, 0x0000007000a07306ULL, 0x000e700000205400ULL,
0x0000007100937306ULL, 0x0004f0000000d400ULL, 0x0000007c00a27306ULL, 0x000fe20000209400ULL,
0x0001000071717824ULL, 0x004fe200078e00ffULL, 0x000000a09f00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x0000007c00a37306ULL, 0x000fe20000205400ULL,
0x0000000193934812ULL, 0x008fe400078efcffULL, 0x000000aeab00720bULL, 0x000fca0003f9d000ULL,
0x0000007c00927306ULL, 0x0003f0000020d400ULL, 0x0000008100b47306ULL, 0x000fe20000209400ULL,
0x00000018ff7c7819ULL, 0x002fe40000011478ULL, 0x000000018f8f4812ULL, 0x000fca00078efcffULL,
0x0000008100b57306ULL, 0x000ff00000205400ULL, 0x00000081008d7306ULL, 0x000ff0000020d400ULL,
0x0000008800bd7306ULL, 0x000ff00000209400ULL, 0x0000008800c07306ULL, 0x000ff00000205400ULL,
0x0000008800857306ULL, 0x000ff0000020d400ULL, 0x0000007c00c67306ULL, 0x000ff00000209400ULL,
0x0000007c00c77306ULL, 0x000ff00000205400ULL, 0x0000007c00837306ULL, 0x000ff0000020d400ULL,
0x0000009c00907306ULL, 0x000ff00000209400ULL, 0x0000009c00917306ULL, 0x000ff00000205400ULL,
0x0000009c00817306ULL, 0x000ff0000020d400ULL, 0x000000a1008b7306ULL, 0x000ff00000209400ULL,
0x000000a100887306ULL, 0x000ff00000205400ULL, 0x000000a1007c7306ULL, 0x000ff0000020d400ULL,
0x0000009a009c7306ULL, 0x000ff00000209400ULL, 0x0000009a009d7306ULL, 0x000e700000205400ULL,
0x0000009a009e7306ULL, 0x000eb0000020d400ULL, 0x000000a600a77306ULL, 0x000fe20000209400ULL,
0x0000009d9c00720bULL, 0x002fce0003f1d000ULL, 0x000000a600a87306ULL, 0x000e6c0000205400ULL,
0x000000019e9e0812ULL, 0x004fe400078efcffULL, 0x000000a600aa7306ULL, 0x000ea2000020d400ULL,
0x000000a3a200720bULL, 0x000fce0003f1d000ULL, 0x0000007000a17306ULL, 0x000ee2000020d400ULL,
0x000000a8a700720bULL, 0x002fca0003fbd000ULL, 0x0000000192920812ULL, 0x000fe400078efcffULL,
0x00000071009a7306ULL, 0x000fec0000209400ULL, 0x00000001aaaa5812ULL, 0x004fe400078efcffULL,
0x0000007100a97306ULL, 0x000e620000205400ULL, 0x00000001a1a16812ULL, 0x008fce00078efcffULL,
0x000000af00a67306ULL, 0x000ff00000209400ULL, 0x000000af00b17306ULL, 0x000ea20000205400ULL,
0x000000a99a00720bULL, 0x002fce0003f7d000ULL, 0x0000007200ad7306ULL, 0x000ff00000009400ULL,
0x0000007200b07306ULL, 0x000e620000005400ULL, 0x000000b1a600720bULL, 0x004fce0003fdd000ULL,
0x00000072008e7306ULL, 0x0004f0000000d400ULL, 0x0000007100ac7306ULL, 0x000ee2000020d400ULL,
0x0001000072727824ULL, 0x004fe200078e00ffULL, 0x000000b0ad00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x000000af00b37306ULL, 0x000e6e000020d400ULL,
0x000000018e8e5812ULL, 0x008fe200078efcffULL, 0x0000007200707306ULL, 0x000fe20000209400ULL,
0x00000001acac3812ULL, 0x000fce00078efcffULL, 0x0000007200717306ULL, 0x000ea20000205400ULL,
0x00000001b3b36812ULL, 0x002fe400078efcffULL, 0x000000b5b400720bULL, 0x000fca0003fdd000ULL,
0x0000007300b67306ULL, 0x000ff00000009400ULL, 0x0000007300b77306ULL, 0x000e620000005400ULL,
0x000000717000720bULL, 0x004fe40003f9d000ULL, 0x000000018d8d6812ULL, 0x000fc400078efcffULL,
0x00000093aa71723eULL, 0x000fe400000010ffULL, 0x000000959e70723eULL, 0x000fe200000010ffULL,
0x00000073008c7306ULL, 0x0004ec000000d400ULL, 0x00000070284c723cULL, 0x000f64000004184cULL,
0x0000007200b27306ULL, 0x000ee2000020d400ULL, 0x0001000073737824ULL, 0x004fe200078e00ffULL,
0x000000b7b600720bULL, 0x002fc80003f7d000ULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x000000706c2c723cULL, 0x000f62000004182cULL, 0x0000007800bf7306ULL, 0x000fee0000009400ULL,
0x000000018c8c3812ULL, 0x008fe200078efcffULL, 0x0000007800c27306ULL, 0x000e620000005400ULL,
0x00000001b2b24812ULL, 0x000fce00078efcffULL, 0x000000b800b97306ULL, 0x000ff00000209400ULL,
0x000000b800ba7306ULL, 0x000ea20000205400ULL, 0x000000c2bf00720bULL, 0x002fce0003f9d000ULL,
0x000000b800bb7306ULL, 0x000e70000020d400ULL, 0x0000007300af7306ULL, 0x000fe20000209400ULL,
0x000000bab900720bULL, 0x004fce0003f1d000ULL, 0x0000007300bc7306ULL, 0x000eac0000205400ULL,
0x00000001bbbb0812ULL, 0x002fe400078efcffULL, 0x000000c100b87306ULL, 0x000fe20000209400ULL,
0x000000c0bd00720bULL, 0x000fce0003f1d000ULL, 0x000000c100c37306ULL, 0x000e620000205400ULL,
0x000000bcaf00720bULL, 0x004fca0003fbd000ULL, 0x0000000185850812ULL, 0x000fe400078efcffULL,
0x000000c800c97306ULL, 0x000ff00000209400ULL, 0x000000c800ca7306ULL, 0x000ea20000205400ULL,
0x000000c3b800720bULL, 0x002fce0003f7d000ULL, 0x0000007800847306ULL, 0x0002f0000000d400ULL,
0x0000007900967306ULL, 0x000fe20000009400ULL, 0x0001000078787824ULL, 0x002fe200078e00ffULL,
0x000000cac900720bULL, 0x004fc80003fdd000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007900997306ULL, 0x000fe20000005400ULL, 0x0000000184844812ULL, 0x008fe400078efcffULL,
0x000000c7c600720bULL, 0x000fca0003f9d000ULL, 0x0000007900827306ULL, 0x0003f0000000d400ULL,
0x0000007300be7306ULL, 0x000ea2000020d400ULL, 0x0001000079797824ULL, 0x002fe200078e00ffULL,
0x0000000183834812ULL, 0x000fc800078efcffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x000000c100c57306ULL, 0x000e70000020d400ULL, 0x000000c800cb7306ULL, 0x000ee2000020d400ULL,
0x00000001bebe5812ULL, 0x004fc400078efcffULL, 0x000000999600720bULL, 0x000fca0003fbd000ULL,
0x0000007800727306ULL, 0x000fe20000209400ULL, 0x00000001c5c53812ULL, 0x002fc800078efcffULL,
0x00000084c584723eULL, 0x000fc600000010ffULL, 0x0000007800737306ULL, 0x000e620000205400ULL,
0x00000001cbcb6812ULL, 0x008fe400078efcffULL, 0x0000000182825812ULL, 0x000fe400078efcffULL,
0x000000919000720bULL, 0x000fc60003fbd000ULL, 0x0000007900c17306ULL, 0x000ff00000209400ULL,
0x0000007900cc7306ULL, 0x000ea20000205400ULL, 0x000000737200720bULL, 0x002fe40003f7d000ULL,
0x000000a19272723eULL, 0x000fc400000010ffULL, 0x000000ac8f73723eULL, 0x000fe400000010ffULL,
0x0000000181815812ULL, 0x000fe200078efcffULL, 0x0000007900987306ULL, 0x0002e2000020d400ULL,
0x0000008a8700720bULL, 0x000fc60003fbd000ULL, 0x000000722850723cULL, 0x080f680000041850ULL,
0x0000007b00867306ULL, 0x000fe20000009400ULL, 0x000001007b797824ULL, 0x002fe200078e00ffULL,
0x000000ccc100720bULL, 0x004fe40003fdd000ULL, 0x000000726c30723cULL, 0x000f640000041830ULL,
0x00000018ff797819ULL, 0x000fc40000011479ULL, 0x0000007b00897306ULL, 0x000e620000005400ULL,
0x000000017f7f5812ULL, 0x000fcc00078efcffULL, 0x0000000198986812ULL, 0x008fe200078efcffULL,
0x0000007800c47306ULL, 0x000ea6000020d400ULL, 0x0000009881c5723eULL, 0x000fca00000010ffULL,
0x0000009b00787306ULL, 0x000fe20000209400ULL, 0x000000898600720bULL, 0x002fce0003f9d000ULL,
0x0000009b009d7306ULL, 0x000e620000205400ULL, 0x00000001c4c43812ULL, 0x004fc800078efcffULL,
0x000000c483c4723eULL, 0x000fc600000010ffULL, 0x0000009b009f7306ULL, 0x000ea8000020d400ULL,
0x000000c42860723cULL, 0x080f680000041860ULL, 0x0000007a00977306ULL, 0x000fe20000009400ULL,
0x0000009d7800720bULL, 0x002fe40003f7d000ULL, 0x0000008eb378723eULL, 0x000fe200000010ffULL,
0x000000c46c40723cULL, 0x000f680000041840ULL, 0x0000007a00947306ULL, 0x000e6c0000005400ULL,
0x000000019f9f3812ULL, 0x004fc400078efcffULL, 0x00000079009c7306ULL, 0x000fe20000209400ULL,
0x000000888b00720bULL, 0x000fce0003f7d000ULL, 0x00000079009b7306ULL, 0x000ea20000205400ULL,
0x000000949700720bULL, 0x002fca0003f1d000ULL, 0x000000017c7c3812ULL, 0x000fe400078efcffULL,
0x0000007a007e7306ULL, 0x0002f0000000d400ULL, 0x0000007b007d7306ULL, 0x0006e2000000d400ULL,
0x000100007a7a7824ULL, 0x002fe200078e00ffULL, 0x0000009b9c00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff9a7819ULL, 0x000fe4000001147aULL, 0x0000007900a07306ULL, 0x0002a2000020d400ULL,
0x000100007b7b7824ULL, 0x008fe200078e00ffULL, 0x000000017e7e0812ULL, 0x000fe400078efcffULL,
0x000000b28d7a723eULL, 0x000fe400000010ffULL, 0x00000018ff927819ULL, 0x000fe4000001147bULL,
0x0000009a00967306ULL, 0x000fe20000209400ULL, 0x000000017d7d4812ULL, 0x000fc400078efcffULL,
0x000000be857b723eULL, 0x000fe400000010ffULL, 0x00000082cb85723eULL, 0x000fe400000010ffULL,
0x0000008cbb79723eULL, 0x002fe200000010ffULL, 0x0000009a00937306ULL, 0x000e620000205400ULL,
0x00000001a0a06812ULL, 0x004fe200078efcffULL, 0x0000007a2858723cULL, 0x000f620000041858ULL,
0x0000007e9f82723eULL, 0x000fe400000010ffULL, 0x0000007da083723eULL, 0x000fc600000010ffULL,
0x00000092008f7306ULL, 0x000fe40000209400ULL, 0x000000782854723cULL, 0x040f6c0000041854ULL,
0x0000009200867306ULL, 0x000ea20000205400ULL, 0x000000939600720bULL, 0x002fe20003f1d000ULL,
0x00000084285c723cULL, 0x040f6c000004185cULL, 0x0000009a009a7306ULL, 0x000e64000020d400ULL,
0x000000822864723cULL, 0x000f6c0000041864ULL, 0x00000092009b7306ULL, 0x000ee2000020d400ULL,
0x000000868f00720bULL, 0x004fe20003fdd000ULL, 0x000000786c34723cULL, 0x000f620000041834ULL,
0x000000019a9a0812ULL, 0x002fce00078efcffULL, 0x0000007a6c38723cULL, 0x000f620000041838ULL,
0x0000009a7f9a723eULL, 0x000fc600000010ffULL, 0x000000019b9b6812ULL, 0x008fc800078efcffULL,
0x000000846c3c723cULL, 0x000f62000004183cULL, 0x0000009b7c9b723eULL, 0x000fce00000010ffULL,
0x000000826c44723cULL, 0x000f700000041844ULL, 0x0000009a2868723cULL, 0x080f700000041868ULL,
0x0000009a6c48723cULL, 0x000b6e0000041848ULL, 0x0001a6c81f6c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006c6c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6880025ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff6e7224ULL, 0x000fc600078e00ffULL, 0x0000000000287805ULL, 0x000fc80000015200ULL,
0x000004001a257984ULL, 0x004ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc4000780486dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004001a257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001002297824ULL, 0x000fe400078e00ffULL,
0x0000590024247a24ULL, 0x010fc600078e02ffULL, 0xffffffe029287812ULL, 0x000fe200078ec0ffULL,
0x0000008024247824ULL, 0x000fc800078e00ffULL, 0x000001001b287824ULL, 0x000fca00078e0228ULL,
0x0000008028287810ULL, 0x000fc80007ffe0ffULL, 0x0000006028257812ULL, 0x000fca00078ec0ffULL,
0x000000011e707824ULL, 0x000fe200078e0225ULL, 0x000003f00000a947ULL, 0x000fea0003800000ULL,
0x0000002804257217ULL, 0x000fe40007800000ULL, 0x0000001029727812ULL, 0x000fe400078ec0ffULL,
0x00000003ff2b7819ULL, 0x000fe20000011608ULL, 0x0000000125257824ULL, 0x000fe200078e0a28ULL,
0x0000640024717a11ULL, 0x000fe400078838ffULL, 0x000000042b2a7810ULL, 0x040fe20007ffe0ffULL,
0x000000012b297824ULL, 0x000fe200078e0272ULL, 0x0000002572257217ULL, 0x000fc40007800000ULL,
0x000000082b6f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000129287824ULL, 0x000fe200078e0208ULL,
0x0000000c2b787810ULL, 0x000fe20007ffe0ffULL, 0x0000000829797824ULL, 0x000fe200078e00ffULL,
0x0000650024737a11ULL, 0x000fe200020f3cffULL, 0x0000000125257824ULL, 0x100fe400078e0a72ULL,
0x000000012a7b7824ULL, 0x040fe200078e0272ULL, 0xfffffff879797812ULL, 0x000fe200078ee228ULL,
0x0000000129287824ULL, 0x100fe200078e0270ULL, 0x000000252a00720cULL, 0x080fe20003f66070ULL,
0x000000017b2a7824ULL, 0x000fe200078e0270ULL, 0x000000252b00720cULL, 0x080fe20003f06070ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x000000256f00720cULL, 0x000fc60003f86070ULL,
0x000000016f7d7824ULL, 0x000fe200078e0272ULL, 0x00000019286e7212ULL, 0x000fe200078efcffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0x0000006e716e7210ULL, 0x000fe20007fbe0ffULL,
0x000000017d6c7824ULL, 0x000fe200078e0270ULL, 0x000000192a2a7212ULL, 0x000fe200078efcffULL,
0x00000001787f7824ULL, 0x000fe400078e0272ULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x000000712a2a7210ULL, 0x000fc60007fde0ffULL, 0x000000017f287824ULL, 0x000fe200078e0270ULL,
0x000000196c6c7212ULL, 0x000fe200078efcffULL, 0x000000017b707824ULL, 0x000fe400078e0208ULL,
0x00000001296f7824ULL, 0x000fe200028e0673ULL, 0x000000257800720cULL, 0x000fe20003fa6070ULL,
0x000000087b7b7824ULL, 0x000fe400078e00ffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee270ULL, 0x000000012b2b7824ULL, 0x000fe200030e0673ULL,
0x000000716c6c7210ULL, 0x000fe20007fde0ffULL, 0x000000017d257824ULL, 0x140fe200078e0208ULL,
0x0000001928287212ULL, 0x000fe200078efcffULL, 0x000000087d727824ULL, 0x000fe400078e00ffULL,
0x000000017f707824ULL, 0x040fe400078e0208ULL, 0x000000087f7f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8727d7812ULL, 0x000fe200078ee225ULL, 0x000000016d6d7824ULL, 0x000fe200030e0673ULL,
0x0000007128287210ULL, 0x000fe20007fde0ffULL, 0x0000001079257824ULL, 0x000fe200078e020aULL,
0xfffffff87f797812ULL, 0x000fe200078ee270ULL, 0x000000107b717824ULL, 0x000fc400078e020aULL,
0x0000000129297824ULL, 0x000fe200030e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e257faeULL, 0x0003e2000c101c46ULL, 0x000000107d737824ULL, 0x100fe400078e020aULL,
0x0000001079797824ULL, 0x000fe200078e020aULL, 0x000000002a717faeULL, 0x0003e8000d901c46ULL,
0x000000006c737faeULL, 0x0003e8000e101c46ULL, 0x0000000028797faeULL, 0x0003e2000e901c46ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001029297812ULL, 0x000fe400078ec0ffULL,
0x0000640024717a11ULL, 0x000fc400078038ffULL, 0x0000002908297211ULL, 0x000fe400078fe8ffULL,
0x0000650024737a11ULL, 0x000fe400000f3cffULL, 0x00000004292b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000129257824ULL, 0x040fe200078e0208ULL, 0x00000008296d7810ULL, 0x040fe20007ffe0ffULL,
0x00000008292a7824ULL, 0x040fe200078e00ffULL, 0x0000000c296f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000129287824ULL, 0x000fe400078e0270ULL, 0x000000012b297824ULL, 0x040fe200078e0208ULL,
0xfffffff82a257812ULL, 0x000fe200078ee225ULL, 0x000000082b727824ULL, 0x000fc400078e00ffULL,
0x000000012b2a7824ULL, 0x100fe400078e0270ULL, 0x000000016d6c7824ULL, 0x100fe200078e0270ULL,
0xfffffff872797812ULL, 0x000fe200078ee229ULL, 0x000000016f6e7824ULL, 0x000fe400078e0270ULL,
0x000000016d2b7824ULL, 0x140fe400078e0208ULL, 0x000000086d707824ULL, 0x000fe400078e00ffULL,
0x000000016f6d7824ULL, 0x000fc400078e0208ULL, 0x000000086f787824ULL, 0x000fe200078e00ffULL,
0xfffffff8707b7812ULL, 0x000fe200078ee22bULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff8787d7812ULL, 0x000fe200078ee26dULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000001928287212ULL, 0x000fc600078efcffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000002871287210ULL, 0x040fe40007f1e0ffULL, 0x000000192a2a7212ULL, 0x080fe200078efcffULL,
0x000000806e6e7825ULL, 0x000fe200078e00ffULL, 0x000000196c6c7212ULL, 0x080fe400078efcffULL,
0x0000002a712a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000129297824ULL, 0x100fe200000e0673ULL,
0x000000196e6e7212ULL, 0x000fe200078efcffULL, 0x0000001025257824ULL, 0x100fe200078e020aULL,
0x0000006c716c7210ULL, 0x000fe20007f1e0ffULL, 0x000000012b2b7824ULL, 0x100fe200018e0673ULL,
0x0000006e716e7210ULL, 0x000fe20007f9e0ffULL, 0x0000001079717824ULL, 0x000fe200078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028257faeULL, 0x0003e2000b901c46ULL,
0x000000016d6d7824ULL, 0x000fc400000e0673ULL, 0x000000016f6f7824ULL, 0x000fe200020e0673ULL,
0x000000002a717faeULL, 0x0003e2000b901c46ULL, 0x000000107b737824ULL, 0x100fe400078e020aULL,
0x000000107d797824ULL, 0x000fc600078e020aULL, 0x000000006c737faeULL, 0x0003e8000b901c46ULL,
0x000000006e797faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000170503c2ULL, 0x000e640000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x002fe20008000a05ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000176c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a62800236e7f8cULL, 0x000664000c80043fULL,
0x0000000000287805ULL, 0x000fc40000015200ULL, 0x01a62c0023257984ULL, 0x000f240000000800ULL,
0x8000000025ff7812ULL, 0x012fc4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a62c0023257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002002257824ULL, 0x000fca00078e00ffULL,
0xffffff8025287812ULL, 0x000fc800078ec0ffULL, 0x0000008019257810ULL, 0x000fca0007ffe028ULL,
0x0000000174257824ULL, 0x000fca00078e0225ULL, 0x01a00000256e7984ULL, 0x000e680000000800ULL,
0x01a20000256f7984ULL, 0x0006a20000000800ULL, 0x000000216e00720bULL, 0x002fe20003f1d000ULL,
0x00016cf27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x008fc800000e0100ULL,
0x000000ff2500720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff707424ULL, 0x000fd600078e00ffULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x000000011c297810ULL, 0x000fe40007ffe0ffULL, 0x000000216e00720bULL, 0x000fe40003f74000ULL,
0x000000022900720cULL, 0x000fe20003f05270ULL, 0x00016cc27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000727806ULL, 0x000fc400018e0100ULL, 0x0000008002298824ULL, 0x000fe200078e0219ULL,
0x000000216e288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000174298824ULL, 0x000fca00078e0229ULL, 0x01a4002829008388ULL, 0x0003e20000000800ULL,
0x000000ff7200720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x000000216e287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff72ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002128287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x0000002800717308ULL, 0x000e640000000800ULL,
0x0000007122227220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe20000011608ULL, 0x00016c027f007947ULL, 0x000fea000b800000ULL,
0x00001f2971297589ULL, 0x0002e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0072ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000808297811ULL, 0x000fe200078ff0ffULL,
0x00016af27f007947ULL, 0x000fea000b800000ULL, 0x00001f2971297589ULL, 0x00066400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000072ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001008297811ULL, 0x000fe200078ff0ffULL, 0x000169e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2971297589ULL, 0x0002e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000072ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001808297811ULL, 0x000fe200078ff0ffULL, 0x000168e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2971297589ULL, 0x0002e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007225ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff707424ULL, 0x000fe200078e00ffULL,
0x000000216e217209ULL, 0x000fd60007810000ULL, 0x800000216e6e0221ULL, 0x000fe20000010000ULL,
0x00007610ff700816ULL, 0x000fc60000000070ULL, 0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL,
0x0000006e00180308ULL, 0x000e640000000800ULL, 0x000000186f6f0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000226f227221ULL, 0x004fc40000010000ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x0000000802257824ULL, 0x000fca00078e00ffULL,
0xfffffff0256e7812ULL, 0x000fca00078ec0ffULL, 0x01a6b4006e257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016f6f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6b4006e257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991070257816ULL, 0x000fc800000000ffULL,
0x000000ff2500720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000018ff13723eULL, 0x000fe400000010ffULL, 0x00000002ff267819ULL, 0x000fe40000011608ULL,
0x0000541013137816ULL, 0x000fe20000000013ULL, 0x000164c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2613167589ULL, 0x0002a400000e0000ULL, 0x0000000826297810ULL, 0x000fe20007ffe0ffULL,
0x000165127f007947ULL, 0x000fea000b800000ULL, 0x0000001026147810ULL, 0x000fe20007ffe0ffULL,
0x00001f2913157589ULL, 0x0002ea00000e0000ULL, 0x00001f1413147589ULL, 0x0002a400000e0000ULL,
0x0000001826297810ULL, 0x002fe20007ffe0ffULL, 0x000165a27f007947ULL, 0x000fea000b800000ULL,
0x00001f2913137589ULL, 0x0002e400000e0000ULL, 0x0000040002257824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100002267824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00025257812ULL, 0x000fc400078ec0ffULL,
0xffffe00026277812ULL, 0x000fe400078ec0ffULL, 0x0001300025267810ULL, 0x000fe40007ffe0ffULL,
0x0001700027257810ULL, 0x000fc60007ffe0ffULL, 0x0000001010707824ULL, 0x100fe400078e0226ULL,
0x000000100f287824ULL, 0x000fe400078e0226ULL, 0x000000100e787824ULL, 0x000fe400078e0225ULL,
0x000000007070783bULL, 0x008ee80000000200ULL, 0x000000002828783bULL, 0x002e620000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001670707231ULL, 0x08cfe400003400ffULL,
0x0000001672727231ULL, 0x000fc400003400ffULL, 0x0000001571717231ULL, 0x080fe400003400ffULL,
0x0000001573737231ULL, 0x000fe400003400ffULL, 0x0000001428287231ULL, 0x082fe400003400ffULL,
0x000000142a2a7231ULL, 0x000fe400003400ffULL, 0x0000001329297231ULL, 0x080fe400003400ffULL,
0x000000132b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100d7c7824ULL, 0x000fe200078e0225ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x00000f9000007945ULL, 0x000fe80003800000ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x0000010078977824ULL, 0x010fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe2000001147aULL,
0x00000100799a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011478ULL,
0x0000007800957306ULL, 0x000fe20000009400ULL, 0x00000018ff987819ULL, 0x008fe2000001147dULL,
0x000001007aab7824ULL, 0x000fe200078e00ffULL, 0x00000018ff977819ULL, 0x000fe20000011497ULL,
0x000001007bae7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa07819ULL, 0x000fe2000001149aULL,
0x000001007cbd7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe2000001147bULL,
0x0000008300b07306ULL, 0x000fe20000209400ULL, 0x00000018ffa57819ULL, 0x000fe2000001147fULL,
0x000001007dc07824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fc40000011479ULL,
0x00000018ff9d7819ULL, 0x000fe4000001147eULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x0000008300b17306ULL, 0x000fe20000205400ULL, 0x00000018ffb47819ULL, 0x000fe400000114aeULL,
0x00000018ffbd7819ULL, 0x000fe400000114bdULL, 0x00000018ffc67819ULL, 0x000fc600000114c0ULL,
0x00000083008f7306ULL, 0x000ff0000020d400ULL, 0x0000009800ca7306ULL, 0x000ff00000209400ULL,
0x0000009800cb7306ULL, 0x000ff00000205400ULL, 0x0000009800837306ULL, 0x000ff0000020d400ULL,
0x0000009700987306ULL, 0x000ff00000209400ULL, 0x0000009700997306ULL, 0x000ef00000205400ULL,
0x00000027009c7306ULL, 0x000ff00000209400ULL, 0x00000027009f7306ULL, 0x000fe20000205400ULL,
0x000000999800720bULL, 0x008fce0003fbd000ULL, 0x0000002700947306ULL, 0x0007f0000020d400ULL,
0x0000007800967306ULL, 0x000f220000005400ULL, 0x00000018ff277819ULL, 0x008fce000001147cULL,
0x00000078006e7306ULL, 0x0006b0000000d400ULL, 0x00000079009e7306ULL, 0x000fe20000009400ULL,
0x0001000078787824ULL, 0x008fe200078e00ffULL, 0x000000969500720bULL, 0x010fc80003fdd000ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000007900a17306ULL, 0x000eee0000005400ULL,
0x000000016e6e6812ULL, 0x004fe200078efcffULL, 0x000000a000a27306ULL, 0x000fe20000209400ULL,
0x0000009f9c00720bULL, 0x000fce0003fdd000ULL, 0x000000a000a37306ULL, 0x000ea20000205400ULL,
0x000000a19e00720bULL, 0x008fca0003f9d000ULL, 0x0000000194946812ULL, 0x000fe400078efcffULL,
0x0000008a00b97306ULL, 0x000ff00000209400ULL, 0x0000008a00bc7306ULL, 0x000fe20000205400ULL,
0x000000a3a200720bULL, 0x004fce0003f7d000ULL, 0x0000008a00877306ULL, 0x000ff0000020d400ULL,
0x0000002700c27306ULL, 0x000ff00000209400ULL, 0x0000002700c37306ULL, 0x000ff00000205400ULL,
0x0000002700857306ULL, 0x000ff0000020d400ULL, 0x000000a5008d7306ULL, 0x000ff00000209400ULL,
0x000000a5008a7306ULL, 0x000ff00000205400ULL, 0x000000a500277306ULL, 0x0005f0000020d400ULL,
0x0000008200a77306ULL, 0x000fe20000209400ULL, 0x0001000079a57824ULL, 0x004fca00078e00ffULL,
0x00000018ffa57819ULL, 0x000fe400000114a5ULL, 0x0000008200aa7306ULL, 0x000ff00000205400ULL,
0x0000008200937306ULL, 0x000ff0000020d400ULL, 0x0000009d00897306ULL, 0x000ff00000209400ULL,
0x0000009d008c7306ULL, 0x000ff00000205400ULL, 0x0000009d00827306ULL, 0x000ff0000020d400ULL,
0x00000097009b7306ULL, 0x000eb0000020d400ULL, 0x00000078009a7306ULL, 0x000ff00000209400ULL,
0x00000078009d7306ULL, 0x000ee20000205400ULL, 0x000000019b9b5812ULL, 0x004fc800078efcffULL,
0x0000006e9b6e723eULL, 0x000fc600000010ffULL, 0x00000079006f7306ULL, 0x000eb0000000d400ULL,
0x000000a000a47306ULL, 0x000f22000020d400ULL, 0x0000009d9a00720bULL, 0x008fe20003fbd000ULL,
0x000100007f9d7824ULL, 0x000fcc00078e00ffULL, 0x000000a500977306ULL, 0x000fe20000209400ULL,
0x000000016f6f4812ULL, 0x004fe400078efcffULL, 0x000000aaa700720bULL, 0x000fca0003f9d000ULL,
0x000000a500a67306ULL, 0x000ea20000205400ULL, 0x00000001a4a43812ULL, 0x010fc800078efcffULL,
0x0000006fa46f723eULL, 0x000fc600000010ffULL, 0x0000007800797306ULL, 0x000ee2000020d400ULL,
0x0000000193934812ULL, 0x000fc600078efcffULL, 0x0000006e702c723cULL, 0x000f68000004182cULL,
0x000000ab00a07306ULL, 0x000fe20000209400ULL, 0x000000a69700720bULL, 0x004fc60003f7d000ULL,
0x0000006e284c723cULL, 0x002f68000004184cULL, 0x000000ab00ad7306ULL, 0x000e620000205400ULL,
0x0000000179795812ULL, 0x008fce00078efcffULL, 0x000000a500a87306ULL, 0x000eb0000020d400ULL,
0x0000007a00a97306ULL, 0x000fe20000009400ULL, 0x000000ada000720bULL, 0x002fce0003fbd000ULL,
0x0000007a00ac7306ULL, 0x000e620000005400ULL, 0x00000001a8a83812ULL, 0x004fce00078efcffULL,
0x0000007a00927306ULL, 0x0004f0000000d400ULL, 0x0000007b00b27306ULL, 0x000fe20000009400ULL,
0x000100007a7a7824ULL, 0x004fe200078e00ffULL, 0x000000aca900720bULL, 0x002fc80003fdd000ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000007b00b37306ULL, 0x000e6e0000005400ULL,
0x0000000192926812ULL, 0x008fe200078efcffULL, 0x000000b400b57306ULL, 0x000fe20000209400ULL,
0x000000b1b000720bULL, 0x000fce0003fdd000ULL, 0x000000b400b67306ULL, 0x000ea20000205400ULL,
0x000000b3b200720bULL, 0x002fca0003f9d000ULL, 0x000000018f8f6812ULL, 0x000fe400078efcffULL,
0x0000007b008e7306ULL, 0x0002f0000000d400ULL, 0x000000ab00af7306ULL, 0x000f22000020d400ULL,
0x000100007b7b7824ULL, 0x002fe200078e00ffULL, 0x000000b6b500720bULL, 0x004fc80003f7d000ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x0000007a00787306ULL, 0x000fe20000209400ULL,
0x000000018e8e4812ULL, 0x008fe400078efcffULL, 0x000000bcb900720bULL, 0x000fca0003f9d000ULL,
0x0000007a00a57306ULL, 0x000e620000205400ULL, 0x00000001afaf5812ULL, 0x010fce00078efcffULL,
0x000000b400b77306ULL, 0x000ea2000020d400ULL, 0x0000000187874812ULL, 0x000fce00078efcffULL,
0x0000007b00ab7306ULL, 0x000fe20000209400ULL, 0x000000a57800720bULL, 0x002fe40003fbd000ULL,
0x000000799478723eULL, 0x000fe400000010ffULL, 0x00000018ff947819ULL, 0x000fe4000001149dULL,
0x000000a89379723eULL, 0x000fe200000010ffULL, 0x0000007b00b87306ULL, 0x000e620000205400ULL,
0x00000001b7b73812ULL, 0x004fca00078efcffULL, 0x000000787030723cULL, 0x080f640000041830ULL,
0x0000007a00ae7306ULL, 0x000eac000020d400ULL, 0x000000782850723cULL, 0x000f640000041850ULL,
0x000000bd00b47306ULL, 0x000fe20000209400ULL, 0x000000b8ab00720bULL, 0x002fce0003f7d000ULL,
0x000000bd00bf7306ULL, 0x000e620000205400ULL, 0x00000001aeae5812ULL, 0x004fce00078efcffULL,
0x0000007b00ba7306ULL, 0x000eb0000020d400ULL, 0x0000007c00bb7306ULL, 0x000fe20000009400ULL,
0x000000bfb400720bULL, 0x002fce0003fbd000ULL, 0x0000007c00be7306ULL, 0x000e620000005400ULL,
0x00000001baba3812ULL, 0x004fce00078efcffULL, 0x0000007c00867306ULL, 0x0004f0000000d400ULL,
0x0000007d00c47306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x004fe200078e00ffULL,
0x000000bebb00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007d00c57306ULL, 0x000e6e0000005400ULL, 0x0000000186866812ULL, 0x008fe200078efcffULL,
0x000000c600c77306ULL, 0x000fe20000209400ULL, 0x000000c3c200720bULL, 0x000fce0003fdd000ULL,
0x000000c600c87306ULL, 0x000ea20000205400ULL, 0x000000c5c400720bULL, 0x002fca0003f9d000ULL,
0x0000000185856812ULL, 0x000fe400078efcffULL, 0x0000007d00847306ULL, 0x0002f0000000d400ULL,
0x000000bd00c17306ULL, 0x000f22000020d400ULL, 0x000100007d7d7824ULL, 0x002fe200078e00ffULL,
0x000000c8c700720bULL, 0x004fc80003f7d000ULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000007c007a7306ULL, 0x000fe20000209400ULL, 0x0000000184844812ULL, 0x008fce00078efcffULL,
0x0000007c007b7306ULL, 0x000e620000205400ULL, 0x00000001c1c15812ULL, 0x010fc800078efcffULL,
0x00000086c186723eULL, 0x000fc600000010ffULL, 0x000000c600c97306ULL, 0x000eb0000020d400ULL,
0x0000007c00c07306ULL, 0x000722000020d400ULL, 0x0000007b7a00720bULL, 0x002fe40003fbd000ULL,
0x0000008eb77b723eULL, 0x000fc400000010ffULL, 0x00000092af7a723eULL, 0x000fc600000010ffULL,
0x0000007d00957306ULL, 0x000fe20000209400ULL, 0x000001007e7c7824ULL, 0x008fe200078e00ffULL,
0x00000001c9c93812ULL, 0x004fe400078efcffULL, 0x000000cbca00720bULL, 0x000fe20003f7d000ULL,
0x0000007a7034723cULL, 0x000f620000041834ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007d00967306ULL, 0x000e620000205400ULL, 0x00000001c0c05812ULL, 0x010fc800078efcffULL,
0x000000c085c0723eULL, 0x000fe200000010ffULL, 0x0000007a2854723cULL, 0x000f640000041854ULL,
0x0000007d00987306ULL, 0x0004e2000020d400ULL, 0x0000000183833812ULL, 0x000fce00078efcffULL,
0x0000007c00977306ULL, 0x000fe20000209400ULL, 0x000001007f7d7824ULL, 0x004fe200078e00ffULL,
0x000000969500720bULL, 0x002fc80003f9d000ULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000007c009a7306ULL, 0x000e6e0000205400ULL, 0x0000000198984812ULL, 0x008fe200078efcffULL,
0x0000007c009c7306ULL, 0x000ea6000020d400ULL, 0x0000009883c1723eULL, 0x000fca00000010ffULL,
0x0000007e00907306ULL, 0x000fe20000009400ULL, 0x0000009a9700720bULL, 0x002fe20003fbd000ULL,
0x000000c07040723cULL, 0x080f6c0000041840ULL, 0x0000007e00917306ULL, 0x000e640000005400ULL,
0x000000c02860723cULL, 0x000f680000041860ULL, 0x000000019c9c5812ULL, 0x004fc400078efcffULL,
0x0000007f00887306ULL, 0x000fe20000009400ULL, 0x0000008c8900720bULL, 0x000fce0003fbd000ULL,
0x0000007f008b7306ULL, 0x000ea20000005400ULL, 0x000000919000720bULL, 0x002fca0003fdd000ULL,
0x0000000182825812ULL, 0x000fe400078efcffULL, 0x0000007d00997306ULL, 0x000ff00000209400ULL,
0x0000007d007c7306ULL, 0x000e620000205400ULL, 0x0000008b8800720bULL, 0x004fce0003f7d000ULL,
0x0000007e00817306ULL, 0x0004f0000000d400ULL, 0x0000007f00257306ULL, 0x000f22000000d400ULL,
0x000100007e7e7824ULL, 0x004fe200078e00ffULL, 0x0000007c9900720bULL, 0x002fc40003f9d000ULL,
0x000000ae8f7c723eULL, 0x000fe400000010ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007d00a07306ULL, 0x0002a2000020d400ULL, 0x0000000181816812ULL, 0x008fe400078efcffULL,
0x0000008a8d00720bULL, 0x000fe40003fdd000ULL, 0x000000819c9c723eULL, 0x000fc600000010ffULL,
0x0000007e007f7306ULL, 0x000fe20000209400ULL, 0x0000000125253812ULL, 0x010fe400078efcffULL,
0x000000ba877d723eULL, 0x002fe400000010ffULL, 0x00000084c987723eULL, 0x000fc600000010ffULL,
0x0000007e009e7306ULL, 0x000e620000205400ULL, 0x00000001a0a04812ULL, 0x004fe200078efcffULL,
0x0000007c7038723cULL, 0x040f620000041838ULL, 0x0000000127276812ULL, 0x000fe400078efcffULL,
0x00000025a09d723eULL, 0x000fe400000010ffULL, 0x000010000a257810ULL, 0x000fe20007ffe0ffULL,
0x0000009400937306ULL, 0x000fe40000209400ULL, 0x00000086703c723cULL, 0x040f6c000004183cULL,
0x00000094008e7306ULL, 0x000ea20000205400ULL, 0x0000009e7f00720bULL, 0x002fe20003f9d000ULL,
0x0000009c7044723cULL, 0x000f6c0000041844ULL, 0x0000007e00897306ULL, 0x000e64000020d400ULL,
0x0000007c2858723cULL, 0x040f6c0000041858ULL, 0x0000009400947306ULL, 0x000ee2000020d400ULL,
0x0000008e9300720bULL, 0x004fe20003f7d000ULL, 0x00000086285c723cULL, 0x000f62000004185cULL,
0x0000000189894812ULL, 0x002fce00078efcffULL, 0x0000009c2864723cULL, 0x000f620000041864ULL,
0x000000898282723eULL, 0x000fc600000010ffULL, 0x0000000194943812ULL, 0x008fc800078efcffULL,
0x000000942783723eULL, 0x000fe200000010ffULL, 0x000000100b277824ULL, 0x000fcc00078e0226ULL,
0x000000827048723cULL, 0x080b6e0000041848ULL, 0x000000100c707824ULL, 0x020fe200078e0226ULL,
0x000000822868723cULL, 0x000b620000041868ULL, 0x0000001009267824ULL, 0x000fe200078e0225ULL,
0x000000002728783bULL, 0x0202a80000000200ULL, 0x000000007070783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fd80003800000ULL, 0x0000001670707231ULL, 0x088fe400003400ffULL,
0x0000001672727231ULL, 0x000fc400003400ffULL, 0x0000001571717231ULL, 0x080fe400003400ffULL,
0x0000001573737231ULL, 0x000fe400003400ffULL, 0x0000001428287231ULL, 0x084fe400003400ffULL,
0x000000142a2a7231ULL, 0x000fe400003400ffULL, 0x0000001329297231ULL, 0x080fe400003400ffULL,
0x000000132b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010007c7824ULL, 0x000fe200078e0225ULL, 0x000000002678783bULL, 0x000f2a0000004200ULL,
0x000000007c7c783bULL, 0x000e620000004200ULL, 0x00000078009e7306ULL, 0x010fe20000009400ULL,
0x00000018ff817819ULL, 0x000fe20000011478ULL, 0x0000010078a07824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011479ULL, 0x0000010079a47824ULL, 0x000fe200078e00ffULL,
0x00000018ffa57819ULL, 0x002fe2000001147eULL, 0x000001007ab47824ULL, 0x000fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe2000001147aULL, 0x00000078009f7306ULL, 0x000e620000005400ULL,
0x00000018ffab7819ULL, 0x000fe200000114a4ULL, 0x000001007bb77824ULL, 0x000fe200078e00ffULL,
0x00000018ffa17819ULL, 0x000fe2000001147dULL, 0x000001007cc47824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001147bULL, 0x000001007dc77824ULL, 0x040fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe200000114a0ULL, 0x0000007800967306ULL, 0x0008e2000000d400ULL,
0x00000018ffa67819ULL, 0x000fe2000001147fULL, 0x000100007dcb7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb47819ULL, 0x000fc400000114b4ULL, 0x00000018ffbd7819ULL, 0x000fe400000114b7ULL,
0x00000018ffc47819ULL, 0x000fe200000114c4ULL, 0x0000007900a97306ULL, 0x000fe20000009400ULL,
0x0001000078787824ULL, 0x010fe200078e00ffULL, 0x0000009f9e00720bULL, 0x002fe20003f7d000ULL,
0x000001007e9e7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc77819ULL, 0x000fe400000114c7ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000007900aa7306ULL, 0x000e620000005400ULL,
0x00000018ffcb7819ULL, 0x000fc400000114cbULL, 0x00000018ff9e7819ULL, 0x000fc8000001149eULL,
0x0000000196963812ULL, 0x008fe200078efcffULL, 0x0000008300b07306ULL, 0x000ff00000209400ULL,
0x0000008300b37306ULL, 0x000fe20000205400ULL, 0x000000aaa900720bULL, 0x002fce0003f9d000ULL,
0x0000008300927306ULL, 0x000ff0000020d400ULL, 0x000000a500897306ULL, 0x000ff00000209400ULL,
0x000000a5008c7306ULL, 0x000ff00000205400ULL, 0x000000a500837306ULL, 0x000ff0000020d400ULL,
0x0000007800a47306ULL, 0x000ff00000209400ULL, 0x0000007800a57306ULL, 0x000e700000205400ULL,
0x00000079006f7306ULL, 0x000730000000d400ULL, 0x0000008100a77306ULL, 0x000fe20000209400ULL,
0x0001000079797824ULL, 0x008fe200078e00ffULL, 0x000000a5a400720bULL, 0x002fc80003fdd000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000008100a87306ULL, 0x000fe20000205400ULL,
0x000000016f6f4812ULL, 0x010fe400078efcffULL, 0x000000b3b000720bULL, 0x000fca0003f9d000ULL,
0x0000008100957306ULL, 0x0003f0000020d400ULL, 0x0000008400b97306ULL, 0x000fe20000209400ULL,
0x00000018ff817819ULL, 0x002fe4000001147cULL, 0x0000000192924812ULL, 0x000fca00078efcffULL,
0x0000008400ba7306ULL, 0x000ff00000205400ULL, 0x0000008400907306ULL, 0x000ff0000020d400ULL,
0x000000a100937306ULL, 0x000ff00000209400ULL, 0x000000a100947306ULL, 0x000ff00000205400ULL,
0x000000a100847306ULL, 0x000ff0000020d400ULL, 0x000000a000a17306ULL, 0x000ff00000209400ULL,
0x000000a000a27306ULL, 0x000e700000205400ULL, 0x0000008a00c27306ULL, 0x000ff00000209400ULL,
0x0000008a00c57306ULL, 0x000fe20000205400ULL, 0x000000a2a100720bULL, 0x002fce0003f1d000ULL,
0x0000008a00887306ULL, 0x000ff0000020d400ULL, 0x00000081009c7306ULL, 0x000ff00000209400ULL,
0x00000081009b7306ULL, 0x000ff00000205400ULL, 0x0000008100867306ULL, 0x000ff0000020d400ULL,
0x000000a6008b7306ULL, 0x000ff00000209400ULL, 0x000000a6008a7306ULL, 0x000ff00000205400ULL,
0x000000a600817306ULL, 0x000ff0000020d400ULL, 0x000000a000a37306ULL, 0x000e70000020d400ULL,
0x000000ab00ac7306ULL, 0x000ff00000209400ULL, 0x000000ab00ad7306ULL, 0x000ee20000205400ULL,
0x00000001a3a30812ULL, 0x002fc400078efcffULL, 0x000000a8a700720bULL, 0x000fca0003f1d000ULL,
0x000000ab00ae7306ULL, 0x000e70000020d400ULL, 0x0000007800a67306ULL, 0x000f22000020d400ULL,
0x000000adac00720bULL, 0x008fe40003fbd000ULL, 0x0000000195950812ULL, 0x000fca00078efcffULL,
0x0000007900a07306ULL, 0x000fec0000209400ULL, 0x00000001aeae5812ULL, 0x002fe400078efcffULL,
0x0000007900af7306ULL, 0x000e620000205400ULL, 0x00000001a6a66812ULL, 0x010fe400078efcffULL,
0x0000006fae6f723eULL, 0x000fca00000010ffULL, 0x000000b400ab7306ULL, 0x000ff00000209400ULL,
0x000000b400b67306ULL, 0x000ee20000205400ULL, 0x000000afa000720bULL, 0x002fe20003f7d000ULL,
0x000001007fa07824ULL, 0x000fca00078e00ffULL, 0x00000018ffa07819ULL, 0x000fe200000114a0ULL,
0x0000007a00b27306ULL, 0x000ff00000009400ULL, 0x0000007a00b57306ULL, 0x000e620000005400ULL,
0x000000b6ab00720bULL, 0x008fce0003fdd000ULL, 0x0000007a00917306ULL, 0x000730000000d400ULL,
0x0000007900b17306ULL, 0x000ea2000020d400ULL, 0x000100007a7a7824ULL, 0x008fe200078e00ffULL,
0x000000b5b200720bULL, 0x002fc80003fbd000ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x000000b400b87306ULL, 0x000e6e000020d400ULL, 0x0000000191915812ULL, 0x010fe200078efcffULL,
0x0000007a00787306ULL, 0x000fe20000209400ULL, 0x00000001b1b13812ULL, 0x004fce00078efcffULL,
0x0000007a00797306ULL, 0x000ea20000205400ULL, 0x00000001b8b86812ULL, 0x002fe400078efcffULL,
0x000000bab900720bULL, 0x000fca0003fdd000ULL, 0x0000007b00bb7306ULL, 0x000ff00000009400ULL,
0x0000007b00bc7306ULL, 0x000e620000005400ULL, 0x000000797800720bULL, 0x004fe20003f9d000ULL,
0x000100007f797824ULL, 0x000fe200078e00ffULL, 0x0000000190906812ULL, 0x000fc400078efcffULL,
0x000000a69578723eULL, 0x000fe400000010ffULL, 0x00000018ff957819ULL, 0x000fe20000011479ULL,
0x0000007b008f7306ULL, 0x0004e2000000d400ULL, 0x000000b19279723eULL, 0x000fce00000010ffULL,
0x000000bd00be7306ULL, 0x000fe20000209400ULL, 0x000100007b7b7824ULL, 0x004fe200078e00ffULL,
0x000000bcbb00720bULL, 0x002fe20003f7d000ULL, 0x000000787030723cULL, 0x080f660000041830ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x000000bd00bf7306ULL, 0x000e660000205400ULL,
0x000000782850723cULL, 0x000f680000041850ULL, 0x000000018f8f3812ULL, 0x008fe200078efcffULL,
0x0000007a00b77306ULL, 0x000eb0000020d400ULL, 0x0000007c009d7306ULL, 0x000fe20000009400ULL,
0x000000bfbe00720bULL, 0x002fce0003f1d000ULL, 0x0000007c009a7306ULL, 0x000e620000005400ULL,
0x00000001b7b74812ULL, 0x004fc800078efcffULL, 0x000000b79090723eULL, 0x000fc600000010ffULL,
0x000000bd00c07306ULL, 0x000eb0000020d400ULL, 0x0000007b00b47306ULL, 0x000fe20000209400ULL,
0x0000009a9d00720bULL, 0x002fce0003f9d000ULL, 0x0000007b00c17306ULL, 0x000e620000205400ULL,
0x00000001c0c00812ULL, 0x004fe400078efcffULL, 0x000000c5c200720bULL, 0x000fca0003f1d000ULL,
0x000000c400bd7306ULL, 0x000ff00000209400ULL, 0x000000c400c67306ULL, 0x000ea20000205400ULL,
0x000000c1b400720bULL, 0x002fe40003fbd000ULL, 0x0000000188880812ULL, 0x000fca00078efcffULL,
0x000000c700c97306ULL, 0x000ff00000209400ULL, 0x000000c700ca7306ULL, 0x000e620000205400ULL,
0x000000c6bd00720bULL, 0x004fce0003f7d000ULL, 0x0000007c00877306ULL, 0x0004f0000000d400ULL,
0x0000007b00c37306ULL, 0x000f22000020d400ULL, 0x000100007c7c7824ULL, 0x004fe200078e00ffULL,
0x000000cac900720bULL, 0x002fc80003fdd000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x000000c400c87306ULL, 0x000e62000020d400ULL, 0x0000000187874812ULL, 0x008fe400078efcffULL,
0x0000009b9c00720bULL, 0x000fca0003f9d000ULL, 0x000000c700cc7306ULL, 0x000ea2000020d400ULL,
0x00000001c3c35812ULL, 0x010fce00078efcffULL, 0x0000007d00987306ULL, 0x000fe20000009400ULL,
0x00000001c8c83812ULL, 0x002fe400078efcffULL, 0x0000000186864812ULL, 0x000fe400078efcffULL,
0x00000087c8c8723eULL, 0x000fc600000010ffULL, 0x0000007d00997306ULL, 0x000e620000005400ULL,
0x00000001cccc6812ULL, 0x004fce00078efcffULL, 0x0000007c007a7306ULL, 0x000ff00000209400ULL,
0x0000007c007b7306ULL, 0x000ea20000205400ULL, 0x000000999800720bULL, 0x002fce0003fbd000ULL,
0x000000cb00c47306ULL, 0x000ff00000209400ULL, 0x000000cb00cd7306ULL, 0x000e620000205400ULL,
0x0000007b7a00720bULL, 0x004fe40003f7d000ULL, 0x00000091b87a723eULL, 0x000fc400000010ffULL,
0x000000c38891723eULL, 0x000fe400000010ffULL, 0x0000008fc07b723eULL, 0x000fe200000010ffULL,
0x0000007e00977306ULL, 0x000fe80000009400ULL, 0x000000907038723cULL, 0x000f680000041838ULL,
0x0000007e006e7306ULL, 0x000ea20000005400ULL, 0x000000cdc400720bULL, 0x002fc60003fdd000ULL,
0x0000007a7034723cULL, 0x080f680000041834ULL, 0x0000007f008d7306ULL, 0x000fe80000009400ULL,
0x0000007a2854723cULL, 0x000f680000041854ULL, 0x0000007f008e7306ULL, 0x000e620000005400ULL,
0x0000006e9700720bULL, 0x004fc40003f1d000ULL, 0x00000096a36e723eULL, 0x000fe200000010ffULL,
0x000000902858723cULL, 0x000f680000041858ULL, 0x0000007d00857306ULL, 0x000ea8000000d400ULL,
0x0000006e702c723cULL, 0x000f68000004182cULL, 0x0000007c007d7306ULL, 0x000ee2000020d400ULL,
0x0000008e8d00720bULL, 0x002fc60003f9d000ULL, 0x0000006e284c723cULL, 0x000b68000004184cULL,
0x000000cb009f7306ULL, 0x000e62000020d400ULL, 0x0000000185855812ULL, 0x004fe400078efcffULL,
0x000000949300720bULL, 0x000fe40003fbd000ULL, 0x00000085ccc9723eULL, 0x000fe400000010ffULL,
0x0001a6c81f6e7811ULL, 0x020fe200078e18ffULL, 0x0000009e007c7306ULL, 0x000fe20000209400ULL,
0x000000017d7d3812ULL, 0x008fc600078efcffULL, 0x000000c8703c723cULL, 0x000f62000004183cULL,
0x0000007d8686723eULL, 0x000fc600000010ffULL, 0x0000009e00a17306ULL, 0x000ea20000205400ULL,
0x000000019f9f6812ULL, 0x002fe400078efcffULL, 0x0000000184845812ULL, 0x000fe200078efcffULL,
0x000000c8285c723cULL, 0x000f62000004185cULL, 0x0000008c8900720bULL, 0x000fe40003fbd000ULL,
0x0000009f8487723eULL, 0x000fe200000010ffULL, 0x000000a000a27306ULL, 0x000fec0000209400ULL,
0x000000867040723cULL, 0x000f640000041840ULL, 0x000000a000a77306ULL, 0x000e620000205400ULL,
0x000000a17c00720bULL, 0x004fc40003f7d000ULL, 0x0000000183835812ULL, 0x000fc600078efcffULL,
0x000000862860723cULL, 0x000f640000041860ULL, 0x0000007e00827306ULL, 0x0004f0000000d400ULL,
0x0000009e00a57306ULL, 0x000f22000020d400ULL, 0x000100007e7e7824ULL, 0x004fe200078e00ffULL,
0x000000a7a200720bULL, 0x002fc80003fdd000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007f00277306ULL, 0x000e62000000d400ULL, 0x0000000182820812ULL, 0x008fce00078efcffULL,
0x000000a0009e7306ULL, 0x000ea2000020d400ULL, 0x00000001a5a53812ULL, 0x010fe400078efcffULL,
0x0000008a8b00720bULL, 0x000fe40003f7d000ULL, 0x00000082a57c723eULL, 0x000fc600000010ffULL,
0x0000007e007f7306ULL, 0x000fe20000209400ULL, 0x0000000127274812ULL, 0x002fce00078efcffULL,
0x0000007e00967306ULL, 0x000e620000205400ULL, 0x000000019e9e6812ULL, 0x004fe400078efcffULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x000000279e7d723eULL, 0x000fe200000010ffULL,
0x0000000202277824ULL, 0x000fe400078e00ffULL, 0x0000009500927306ULL, 0x000fe80000209400ULL,
0x0000007c7044723cULL, 0x000f680000041844ULL, 0x00000095008d7306ULL, 0x000ea20000205400ULL,
0x000000967f00720bULL, 0x002fc60003f1d000ULL, 0x0000007c2864723cULL, 0x000f680000041864ULL,
0x0000007e007e7306ULL, 0x000e70000020d400ULL, 0x0000009500887306ULL, 0x000ee2000020d400ULL,
0x0000008d9200720bULL, 0x004fc40003fdd000ULL, 0x000000017e7e0812ULL, 0x002fc800078efcffULL,
0x0000007e837e723eULL, 0x000fce00000010ffULL, 0x0000000188886812ULL, 0x008fc800078efcffULL,
0x00000088817f723eULL, 0x000fce00000010ffULL, 0x0000007e7048723cULL, 0x080f700000041848ULL,
0x0000007e2868723cULL, 0x000b6e0000041868ULL, 0xfffffff827287812ULL, 0x020fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006e6e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6900028ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff277224ULL, 0x000fc600078e00ffULL, 0x0000000000287805ULL, 0x004fc80000015200ULL,
0x000004001a2b7984ULL, 0x000ea40000000800ULL, 0x800000002bff7812ULL, 0x006fc4000780486fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a28717210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09007100780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c407100780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2a7819ULL, 0x000fc8000001142bULL, 0x000000712a2a7211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x000000022a2a7819ULL, 0x000fc8000000122bULL,
0x0000002a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000127277810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004001a2b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001001b277824ULL, 0x000fca00078e0280ULL,
0x000000c0272b7810ULL, 0x000fc80007ffe0ffULL, 0x000000602b297812ULL, 0x000fca00078ec0ffULL,
0x000000011e727824ULL, 0x000fe200078e0229ULL, 0x000004000000a947ULL, 0x000fea0003800000ULL,
0x0000001002297824ULL, 0x000fe200078e00ffULL, 0x0000002b04287217ULL, 0x000fe40007800000ULL,
0x00000003ff707819ULL, 0x000fe40000011608ULL, 0x0000001029737812ULL, 0x000fe200078ec0ffULL,
0x0000000128287824ULL, 0x000fe200078e0a2bULL, 0x00000004706e7810ULL, 0x040fe40007ffe0ffULL,
0x0000000870787810ULL, 0x040fe20007ffe0ffULL, 0x0000000170797824ULL, 0x100fe200078e0273ULL,
0x0000002873287217ULL, 0x000fe20007800000ULL, 0x000000016e7f7824ULL, 0x000fe200078e0273ULL,
0x00006400247b7a11ULL, 0x000fe200078038ffULL, 0x0000000179297824ULL, 0x000fc400078e0272ULL,
0x0000000128717824ULL, 0x100fe200078e0a73ULL, 0x00006500247d7a11ULL, 0x000fe200000f3cffULL,
0x0000008029287825ULL, 0x000fe200078e00ffULL, 0x0000000c70247810ULL, 0x000fe40007ffe0ffULL,
0x000000716e00720cULL, 0x000fe20003f66070ULL, 0x000000017f2a7824ULL, 0x000fe200078e0272ULL,
0x00000019286e7212ULL, 0x000fe200078efcffULL, 0x0000000178817824ULL, 0x000fe200078e0273ULL,
0x000000717000720cULL, 0x000fe20003f86070ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000007b6e6e7210ULL, 0x000fc40007fbe0ffULL, 0x000000717800720cULL, 0x000fe20003f06070ULL,
0x0000000181287824ULL, 0x000fe200078e0272ULL, 0x000000192a707212ULL, 0x000fe200078efcffULL,
0x0000000124837824ULL, 0x000fe400078e0273ULL, 0x00000001296f7824ULL, 0x000fe200028e067dULL,
0x0000007b70707210ULL, 0x000fe20007fde0ffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x000000712400720cULL, 0x000fc60003fa6070ULL, 0x00000001832a7824ULL, 0x000fe200078e0272ULL,
0x0000001928287212ULL, 0x000fe200078efcffULL, 0x0000000179247824ULL, 0x000fe400078e0208ULL,
0x000000012b717824ULL, 0x000fe200030e067dULL, 0x0000007b28287210ULL, 0x000fe20007fde0ffULL,
0x0000000879797824ULL, 0x000fe400078e00ffULL, 0x000000802a2a7825ULL, 0x000fc600078e00ffULL,
0xfffffff879247812ULL, 0x000fe200078ee224ULL, 0x000000017f727824ULL, 0x140fe200078e0208ULL,
0x000000192a2a7212ULL, 0x000fe200078efcffULL, 0x000000087f7f7824ULL, 0x000fe400078e00ffULL,
0x0000000181737824ULL, 0x040fe400078e0208ULL, 0x0000000881787824ULL, 0x000fe200078e00ffULL,
0xfffffff87f727812ULL, 0x000fe200078ee272ULL, 0x0000000183797824ULL, 0x040fe400078e0208ULL,
0x00000008837a7824ULL, 0x000fe200078e00ffULL, 0xfffffff878787812ULL, 0x000fe200078ee273ULL,
0x0000000129297824ULL, 0x000fe200030e067dULL, 0x0000007b2a2a7210ULL, 0x000fe20007fde0ffULL,
0x0000001024737824ULL, 0x000fe200078e0225ULL, 0xfffffff87a247812ULL, 0x000fe200078ee279ULL,
0x0000001072797824ULL, 0x000fc400078e0225ULL, 0x000000012b2b7824ULL, 0x000fe200030e067dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006e737faeULL, 0x0003e2000e101c46ULL,
0x00000010787b7824ULL, 0x100fe400078e0225ULL, 0x00000010247d7824ULL, 0x000fe200078e0225ULL,
0x0000000070797faeULL, 0x0003e8000d901c46ULL, 0x00000000287b7faeULL, 0x0003e8000c101c46ULL,
0x000000002a7d7faeULL, 0x0003e2000e901c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001002287824ULL, 0x000fe200078e00ffULL, 0x0000640024737a11ULL, 0x000fc800078038ffULL,
0x0000001028297812ULL, 0x000fe400078ec0ffULL, 0x0000650024797a11ULL, 0x000fe400000f3cffULL,
0x0000002908297211ULL, 0x000fc800078fe8ffULL, 0x00000004292b7810ULL, 0x040fe20007ffe0ffULL,
0x00000001292a7824ULL, 0x040fe200078e0208ULL, 0x0000000c29717810ULL, 0x040fe20007ffe0ffULL,
0x00000008296f7824ULL, 0x040fe400078e00ffULL, 0x0000000129287824ULL, 0x000fe400078e0272ULL,
0x000000082b7a7824ULL, 0x000fe200078e00ffULL, 0xfffffff86f787812ULL, 0x000fe200078ee22aULL,
0x000000012b2a7824ULL, 0x000fe200078e0272ULL, 0x00000008296f7810ULL, 0x000fe20007ffe0ffULL,
0x000000012b297824ULL, 0x000fc400078e0208ULL, 0x0000000171707824ULL, 0x100fe400078e0272ULL,
0x000000016f6e7824ULL, 0x040fe200078e0272ULL, 0xfffffff87a727812ULL, 0x000fe200078ee229ULL,
0x000000016f2b7824ULL, 0x140fe400078e0208ULL, 0x000000086f7c7824ULL, 0x000fe400078e00ffULL,
0x00000001716f7824ULL, 0x040fe400078e0208ULL, 0x00000008717e7824ULL, 0x000fe200078e00ffULL,
0xfffffff87c7a7812ULL, 0x000fe200078ee22bULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff87e7c7812ULL, 0x000fe200078ee26fULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000001928287212ULL, 0x000fc600078efcffULL, 0x000000806e6e7825ULL, 0x000fe200078e00ffULL,
0x0000007328287210ULL, 0x000fe40007f1e0ffULL, 0x000000192a2a7212ULL, 0x080fe200078efcffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000196e6e7212ULL, 0x000fe400078efcffULL,
0x000000732a2a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000129297824ULL, 0x000fe200000e0679ULL,
0x0000001970707212ULL, 0x000fe200078efcffULL, 0x000000107a7b7824ULL, 0x000fe200078e0225ULL,
0x000000736e6e7210ULL, 0x080fe20007f1e0ffULL, 0x000000012b2b7824ULL, 0x000fe200018e0679ULL,
0x0000007370707210ULL, 0x000fe20007f9e0ffULL, 0x0000001078737824ULL, 0x000fc400078e0225ULL,
0x000000016f6f7824ULL, 0x100fe400000e0679ULL, 0x0000000171717824ULL, 0x000fe200020e0679ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028737faeULL, 0x0003e2000b901c46ULL,
0x0000001072797824ULL, 0x100fe400078e0225ULL, 0x000000107c7d7824ULL, 0x000fc600078e0225ULL,
0x000000002a797faeULL, 0x0003e8000b901c46ULL, 0x000000006e7b7faeULL, 0x0003e8000b901c46ULL,
0x00000000707d7faeULL, 0x0003e4000b901c46ULL, 0x0000000220207810ULL, 0x000fe20007ffe0ffULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0xffffffffff247424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000052000720cULL, 0x000fcc0003f06070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fee0008000a05ULL, 0x0000000120288824ULL, 0x000fe400078e021dULL,
0x00000004ff298424ULL, 0x000fc800078e00ffULL, 0x0000660028288625ULL, 0x000fca00078e0029ULL,
0x0000000628248981ULL, 0x000322000c1e1900ULL, 0x00000008022a7824ULL, 0x000fca00078e00ffULL,
0xfffffff02a2a7812ULL, 0x000fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6b0002a6e7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6480023707f8cULL, 0x0002a4000c80043fULL,
0x0000000000287805ULL, 0x002fc40000015200ULL, 0x01a64c00232b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x006fe40007804871ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff727224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a28737210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09007300780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c407300780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2a7819ULL, 0x000fc8000001142bULL, 0x000000732a2a7211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x000000022a2a7819ULL, 0x000fc8000000122bULL,
0x0000002a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000172727810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a64c00232b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x002fe40007804871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002002237824ULL, 0x000fca00078e00ffULL,
0xffffff8023287812ULL, 0x000fc800078ec0ffULL, 0x0000010019237810ULL, 0x000fca0007ffe028ULL,
0x0000000174237824ULL, 0x000fca00078e0223ULL, 0x01a0000023727984ULL, 0x000e680000000800ULL,
0x01a2000023717984ULL, 0x0004e20000000800ULL, 0x000000217200720bULL, 0x002fe20003f1d000ULL,
0x000137427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000737806ULL, 0x004fc800000e0100ULL,
0x000000ff7300720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff707424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fd200078e0021ULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x000000021c237810ULL, 0x000fe40007ffe0ffULL,
0x000000217200720bULL, 0x000fe40003f74000ULL, 0x000000022300720cULL, 0x000fe20003f05270ULL,
0x000137027f007947ULL, 0x000fd4000b800000ULL, 0x0000000000787806ULL, 0x000fc400018e0100ULL,
0x0000008002298824ULL, 0x000fe200078e0219ULL, 0x0000002172237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000174288824ULL, 0x000fca00078e0229ULL,
0x01a4002328008388ULL, 0x0003e20000000800ULL, 0x000000ff7800720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000002123217221ULL, 0x002fe20000010100ULL,
0x000000ff78ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b21217820ULL, 0x000fcc0000410000ULL, 0x0000002100217308ULL, 0x000e640000000800ULL,
0x0000002122227220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe20000011608ULL, 0x000136527f007947ULL, 0x000fea000b800000ULL,
0x00001f2921297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0078ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000808297811ULL, 0x000fe200078ff0ffULL,
0x000135427f007947ULL, 0x000fea000b800000ULL, 0x00001f2921297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000078ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001008297811ULL, 0x000fe200078ff0ffULL, 0x000134327f007947ULL, 0x000fea000b800000ULL,
0x00001f2921297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000078ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001808297811ULL, 0x000fe200078ff0ffULL, 0x000133327f007947ULL, 0x000fea000b800000ULL,
0x00001f2921297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007873ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff707424ULL, 0x000fd800078e00ffULL,
0x8000002372720221ULL, 0x000fe20000010000ULL, 0x00007610ff700816ULL, 0x000fc60000000070ULL,
0x3fb8aa3b72720820ULL, 0x000fc80000410000ULL, 0x0000007200180308ULL, 0x000e640000000800ULL,
0x0000001871710220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002271227221ULL, 0x008fc40000010000ULL, 0x0000000000287805ULL, 0x000fca0000015200ULL,
0x0000040017217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09002a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff217819ULL, 0x000fc8000001142bULL,
0x0000002a21217211ULL, 0x000fca00078110ffULL, 0x000000ffff2a7224ULL, 0x000fca00000e062bULL,
0x0000000221217819ULL, 0x000fc8000000122aULL, 0x000000210000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000171717810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040017217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991070217816ULL, 0x000fc800000000ffULL, 0x000000ff2100720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000018ff13723eULL, 0x000fe400000010ffULL,
0x00000002ff6c7819ULL, 0x000fe40000011608ULL, 0x0000541013137816ULL, 0x000fe20000000013ULL,
0x00012f427f007947ULL, 0x000fea000b800000ULL, 0x00001f6c13167589ULL, 0x0002a400000e0000ULL,
0x000000086c297810ULL, 0x000fe20007ffe0ffULL, 0x00012f927f007947ULL, 0x000fea000b800000ULL,
0x000000106c147810ULL, 0x000fe20007ffe0ffULL, 0x00001f2913157589ULL, 0x00066a00000e0000ULL,
0x00001f1413147589ULL, 0x0006a400000e0000ULL, 0x000000186c297810ULL, 0x008fe20007ffe0ffULL,
0x000130227f007947ULL, 0x000fea000b800000ULL, 0x00001f2913137589ULL, 0x0022e400000e0000ULL,
0x0000040002217824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x000000100e787824ULL, 0x000fc400078e020aULL,
0xfffff00021217812ULL, 0x000fc800078ec0ffULL, 0x0001400021217810ULL, 0x000fca0007ffe0ffULL,
0x0000001010107824ULL, 0x100fe400078e0221ULL, 0x000000100f0f7824ULL, 0x000fc600078e0221ULL,
0x000000001070783bULL, 0x0002e80000000200ULL, 0x000000000f28783bULL, 0x0022a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001670707231ULL, 0x08cfe400003400ffULL,
0x0000001672727231ULL, 0x000fe400003400ffULL, 0x0000001571717231ULL, 0x080fe400003400ffULL,
0x0000001573737231ULL, 0x000fc400003400ffULL, 0x0000001428287231ULL, 0x080fe400003400ffULL,
0x000000142a2a7231ULL, 0x000fe400003400ffULL, 0x0000001329297231ULL, 0x080fe400003400ffULL,
0x000000132b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100d7c7824ULL, 0x000fe200078e020aULL, 0x000000007878783bULL, 0x000e620000004200ULL,
0x00000f8000007945ULL, 0x000fe80003800000ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000100789a7824ULL, 0x002fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x000fe20000011479ULL,
0x00000100799e7824ULL, 0x000fe200078e00ffULL, 0x0000007800987306ULL, 0x000fe20000009400ULL,
0x00000018ff0d7819ULL, 0x000fe20000011478ULL, 0x000001007aae7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x008fe2000001147eULL, 0x000001007bb37824ULL, 0x000fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe2000001149aULL, 0x000001007cb87824ULL, 0x000fe200078e00ffULL,
0x00000018ffa57819ULL, 0x000fe2000001149eULL, 0x0000000f00aa7306ULL, 0x000fe20000209400ULL,
0x00000018ff8d7819ULL, 0x000fe2000001147dULL, 0x000001007dbb7824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe2000001147aULL, 0x000001007ec87824ULL, 0x000fe200078e00ffULL,
0x00000018ff9f7819ULL, 0x000fe2000001147bULL, 0x000001007fcb7824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe2000001147cULL, 0x0000000f00ad7306ULL, 0x000fe20000205400ULL,
0x00000018ffa07819ULL, 0x000fc4000001147fULL, 0x00000018ffae7819ULL, 0x000fe400000114aeULL,
0x00000018ffb37819ULL, 0x000fe400000114b3ULL, 0x00000018ffb87819ULL, 0x000fe200000114b8ULL,
0x0000000f00907306ULL, 0x000fe2000020d400ULL, 0x00000018ffc17819ULL, 0x000fe400000114bbULL,
0x00000018ffc87819ULL, 0x000fe400000114c8ULL, 0x00000018ffcb7819ULL, 0x000fc600000114cbULL,
0x0000009b00877306ULL, 0x000ff00000209400ULL, 0x0000009b008a7306ULL, 0x000ff00000205400ULL,
0x0000009b000f7306ULL, 0x000ff0000020d400ULL, 0x0000009a009b7306ULL, 0x000ff00000209400ULL,
0x0000009a009c7306ULL, 0x000e700000205400ULL, 0x0000007800997306ULL, 0x000ef00000005400ULL,
0x00000078006c7306ULL, 0x0004e2000000d400ULL, 0x0000009c9b00720bULL, 0x002fce0003fbd000ULL,
0x0000007900a37306ULL, 0x000fe20000009400ULL, 0x0001000078787824ULL, 0x004fe200078e00ffULL,
0x000000999800720bULL, 0x008fc80003fdd000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007900a47306ULL, 0x000e6e0000005400ULL, 0x000000016c6c6812ULL, 0x000fe200078efcffULL,
0x000000a500a67306ULL, 0x000ff00000209400ULL, 0x000000a500a77306ULL, 0x000ea20000205400ULL,
0x000000a4a300720bULL, 0x002fce0003f9d000ULL, 0x00000079006d7306ULL, 0x0002f0000000d400ULL,
0x0000008d00c67306ULL, 0x000fe20000209400ULL, 0x0001000079797824ULL, 0x002fe200078e00ffULL,
0x000000a7a600720bULL, 0x004fc80003f7d000ULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000008d00c97306ULL, 0x000fe20000205400ULL, 0x000000016d6d4812ULL, 0x008fe400078efcffULL,
0x000000adaa00720bULL, 0x000fca0003f9d000ULL, 0x0000008d00847306ULL, 0x000ff0000020d400ULL,
0x0000008100917306ULL, 0x000fe20000209400ULL, 0x0000000190904812ULL, 0x000fce00078efcffULL,
0x0000008100927306ULL, 0x000ff00000205400ULL, 0x0000008100827306ULL, 0x000ff0000020d400ULL,
0x0000009f008d7306ULL, 0x000ff00000209400ULL, 0x0000009f008e7306ULL, 0x000ff00000205400ULL,
0x0000009f00817306ULL, 0x000ff0000020d400ULL, 0x0000009a009d7306ULL, 0x000e70000020d400ULL,
0x00000078009e7306ULL, 0x000ff00000209400ULL, 0x00000078009f7306ULL, 0x000ea20000205400ULL,
0x000000019d9d5812ULL, 0x002fc800078efcffULL, 0x0000006c9d6c723eULL, 0x000fc600000010ffULL,
0x000000a500a87306ULL, 0x000e70000020d400ULL, 0x0000000d00a17306ULL, 0x000fe20000209400ULL,
0x0000009f9e00720bULL, 0x004fce0003fbd000ULL, 0x0000000d00a27306ULL, 0x000ea20000205400ULL,
0x00000001a8a83812ULL, 0x002fc800078efcffULL, 0x0000006da86d723eULL, 0x000fc600000010ffULL,
0x00000079009a7306ULL, 0x000fe80000209400ULL, 0x0000006c702c723cULL, 0x000f68000004182cULL,
0x0000007900a97306ULL, 0x000e620000205400ULL, 0x000000a2a100720bULL, 0x004fc60003fdd000ULL,
0x0000006c284c723cULL, 0x000f68000004184cULL, 0x0000000d00937306ULL, 0x000eb0000020d400ULL,
0x0000008800bd7306ULL, 0x000fe20000209400ULL, 0x000000a99a00720bULL, 0x002fce0003f7d000ULL,
0x0000008800be7306ULL, 0x000fe20000205400ULL, 0x0000000193936812ULL, 0x004fce00078efcffULL,
0x0000008800867306ULL, 0x000ff0000020d400ULL, 0x000000a000897306ULL, 0x000ff00000209400ULL,
0x000000a000887306ULL, 0x000ff00000205400ULL, 0x000000a0000d7306ULL, 0x000ff0000020d400ULL,
0x0000007800a07306ULL, 0x000e70000020d400ULL, 0x000000ae00a57306ULL, 0x000ff00000209400ULL,
0x000000ae00b07306ULL, 0x000ea20000205400ULL, 0x00000001a0a05812ULL, 0x002fce00078efcffULL,
0x0000007900ab7306ULL, 0x000e70000020d400ULL, 0x0000007a00ac7306ULL, 0x000fe20000009400ULL,
0x000000b0a500720bULL, 0x004fce0003fbd000ULL, 0x0000007a00af7306ULL, 0x000ea20000005400ULL,
0x00000001abab3812ULL, 0x002fce00078efcffULL, 0x0000007b00b17306ULL, 0x000ff00000009400ULL,
0x0000007b00b47306ULL, 0x000e620000005400ULL, 0x000000afac00720bULL, 0x004fce0003fdd000ULL,
0x000000b300787306ULL, 0x000ff00000209400ULL, 0x000000b300b57306ULL, 0x000ea20000205400ULL,
0x000000b4b100720bULL, 0x002fce0003f9d000ULL, 0x000000ae00b27306ULL, 0x000e70000020d400ULL,
0x000000b800797306ULL, 0x000fe20000209400ULL, 0x000000b57800720bULL, 0x004fe20003f7d000ULL,
0x000100007e787824ULL, 0x000fca00078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe20000011478ULL,
0x000000b800ba7306ULL, 0x000ea20000205400ULL, 0x00000001b2b25812ULL, 0x002fe400078efcffULL,
0x000000a09378723eULL, 0x000fca00000010ffULL, 0x0000007a008f7306ULL, 0x0002f0000000d400ULL,
0x0000007b008c7306ULL, 0x0006e2000000d400ULL, 0x000000ba7900720bULL, 0x004fe20003fbd000ULL,
0x000100007a7a7824ULL, 0x002fc400078e00ffULL, 0x000100007f797824ULL, 0x000fc600078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x0000007c00b67306ULL, 0x000fe20000009400ULL,
0x000000018f8f6812ULL, 0x008fe200078efcffULL, 0x000100007b7b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe40000011479ULL, 0x000000ab9079723eULL, 0x000fe400000010ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000007c00b97306ULL, 0x000e620000005400ULL,
0x000000018c8c4812ULL, 0x000fc600078efcffULL, 0x000000787030723cULL, 0x080f680000041830ULL,
0x0000007c008b7306ULL, 0x0004e8000000d400ULL, 0x000000782850723cULL, 0x000b680000041850ULL,
0x000000b300b77306ULL, 0x000ee2000020d400ULL, 0x000100007c7c7824ULL, 0x004fe200078e00ffULL,
0x000000b9b600720bULL, 0x002fe20003fdd000ULL, 0x0000001009787824ULL, 0x020fc600078e020aULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007d00bf7306ULL, 0x000fee0000009400ULL,
0x000000018b8b6812ULL, 0x008fe200078efcffULL, 0x0000007d00c07306ULL, 0x000e620000005400ULL,
0x00000001b7b73812ULL, 0x000fc400078efcffULL, 0x000000bebd00720bULL, 0x000fca0003fdd000ULL,
0x000000c100c27306ULL, 0x000ff00000209400ULL, 0x000000c100c37306ULL, 0x000ea20000205400ULL,
0x000000c0bf00720bULL, 0x002fe40003f9d000ULL, 0x0000000186866812ULL, 0x000fca00078efcffULL,
0x0000007d00857306ULL, 0x0002f0000000d400ULL, 0x000000b800bc7306ULL, 0x000ee2000020d400ULL,
0x000100007d7d7824ULL, 0x002fe200078e00ffULL, 0x000000c3c200720bULL, 0x004fc80003f7d000ULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x0000007c00ae7306ULL, 0x000fe20000209400ULL,
0x0000000185854812ULL, 0x008fe400078efcffULL, 0x000000c9c600720bULL, 0x000fca0003f9d000ULL,
0x0000007c00b37306ULL, 0x000e620000205400ULL, 0x00000001bcbc5812ULL, 0x000fce00078efcffULL,
0x000000c100c47306ULL, 0x000ea2000020d400ULL, 0x0000000184844812ULL, 0x000fce00078efcffULL,
0x0000007d00b87306ULL, 0x000fe20000209400ULL, 0x000000b3ae00720bULL, 0x002fce0003fbd000ULL,
0x0000007d00c57306ULL, 0x000e620000205400ULL, 0x00000001c4c43812ULL, 0x004fce00078efcffULL,
0x0000007c00bb7306ULL, 0x000eb0000020d400ULL, 0x000000c800c17306ULL, 0x000fe20000209400ULL,
0x000000c5b800720bULL, 0x002fce0003f7d000ULL, 0x000000c800ca7306ULL, 0x000e620000205400ULL,
0x00000001bbbb5812ULL, 0x004fc800078efcffULL, 0x000000bb8686723eULL, 0x000fc600000010ffULL,
0x0000007d00c77306ULL, 0x000eb0000020d400ULL, 0x0000007e00967306ULL, 0x000fe20000009400ULL,
0x000000cac100720bULL, 0x002fce0003fbd000ULL, 0x0000007e00977306ULL, 0x000e620000005400ULL,
0x00000001c7c73812ULL, 0x004fce00078efcffULL, 0x0000007f00957306ULL, 0x000ff00000009400ULL,
0x0000007f00947306ULL, 0x000ea20000005400ULL, 0x000000979600720bULL, 0x002fce0003fdd000ULL,
0x000000cb009c7306ULL, 0x000ff00000209400ULL, 0x000000cb00a37306ULL, 0x000e620000205400ULL,
0x000000949500720bULL, 0x004fce0003f7d000ULL, 0x000000c800cc7306ULL, 0x000eb0000020d400ULL,
0x0000007a007c7306ULL, 0x000fe20000209400ULL, 0x000000a39c00720bULL, 0x002fce0003f9d000ULL,
0x0000007a007d7306ULL, 0x000e620000205400ULL, 0x00000001cccc5812ULL, 0x004fce00078efcffULL,
0x0000007e00837306ULL, 0x000eb0000000d400ULL, 0x0000007f00107306ULL, 0x000ee2000000d400ULL,
0x0000007d7c00720bULL, 0x002fe40003fbd000ULL, 0x0000008bbc7c723eULL, 0x000fc400000010ffULL,
0x00000085c47d723eULL, 0x000fc600000010ffULL, 0x000000cb00cd7306ULL, 0x000e62000020d400ULL,
0x0000000183836812ULL, 0x004fe400078efcffULL, 0x000000929100720bULL, 0x000fe20003fdd000ULL,
0x0000007c703c723cULL, 0x000f62000004183cULL, 0x00000083cccc723eULL, 0x000fc600000010ffULL,
0x0000007b00987306ULL, 0x000fe20000209400ULL, 0x0000000110103812ULL, 0x008fe400078efcffULL,
0x0000008e8d00720bULL, 0x000fe20003f7d000ULL, 0x0000007c285c723cULL, 0x000f68000004185cULL,
0x0000007b009b7306ULL, 0x000ea20000205400ULL, 0x00000001cdcd4812ULL, 0x002fe400078efcffULL,
0x0000000182826812ULL, 0x000fc400078efcffULL, 0x000000888900720bULL, 0x000fe40003fdd000ULL,
0x00000010cdcd723eULL, 0x000fe200000010ffULL, 0x0000007a00997306ULL, 0x0002e2000020d400ULL,
0x0000000181813812ULL, 0x000fca00078efcffULL, 0x000000cc7044723cULL, 0x080f640000041844ULL,
0x0000007b007e7306ULL, 0x0006e2000020d400ULL, 0x0000008fb27a723eULL, 0x002fe400000010ffULL,
0x0000009b9800720bULL, 0x004fe40003f9d000ULL, 0x000000010d0d6812ULL, 0x000fe200078efcffULL,
0x000000cc2864723cULL, 0x000f640000041864ULL, 0x0000009a007f7306ULL, 0x000fe20000209400ULL,
0x0000000199995812ULL, 0x008fc400078efcffULL, 0x0000008a8700720bULL, 0x000fe40003fbd000ULL,
0x000000c78487723eULL, 0x000fe400000010ffULL, 0x0000008cb77b723eULL, 0x000fe200000010ffULL,
0x0000009a00947306ULL, 0x000e620000205400ULL, 0x000000017e7e4812ULL, 0x000fe400078efcffULL,
0x000000998282723eULL, 0x000fe200000010ffULL, 0x000000867040723cULL, 0x000f620000041840ULL,
0x0000007e8183723eULL, 0x000fc600000010ffULL, 0x0000009300907306ULL, 0x000fe20000209400ULL,
0x000000010f0f5812ULL, 0x000fc600078efcffULL, 0x0000007a7034723cULL, 0x000f680000041834ULL,
0x00000093008f7306ULL, 0x000ea20000205400ULL, 0x000000947f00720bULL, 0x002fc60003f9d000ULL,
0x000000827038723cULL, 0x000f680000041838ULL, 0x0000009a009a7306ULL, 0x000e68000020d400ULL,
0x0000007a2854723cULL, 0x000f680000041854ULL, 0x0000009300847306ULL, 0x000ee2000020d400ULL,
0x0000008f9000720bULL, 0x004fc60003f7d000ULL, 0x000000862860723cULL, 0x000f620000041860ULL,
0x000000019a9a4812ULL, 0x002fc800078efcffULL, 0x0000009a0f9a723eULL, 0x000fc600000010ffULL,
0x000000822858723cULL, 0x000f640000041858ULL, 0x0000000184843812ULL, 0x008fc800078efcffULL,
0x000000840d9b723eULL, 0x000fce00000010ffULL, 0x0000009a7048723cULL, 0x080b6e0000041848ULL,
0x000000100c707824ULL, 0x120fe200078e0221ULL, 0x0000009a2828723cULL, 0x000b620000041868ULL,
0x000000100b217824ULL, 0x000fc800078e0221ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000002168783bULL, 0x0204e20000000200ULL, 0x0000008000000947ULL, 0x000fd20003800000ULL,
0x0000001670707231ULL, 0x082fe400003400ffULL, 0x0000001672727231ULL, 0x000fe400003400ffULL,
0x0000001571717231ULL, 0x080fe400003400ffULL, 0x0000001573737231ULL, 0x000fc400003400ffULL,
0x0000001468687231ULL, 0x088fe400003400ffULL, 0x000000146a6a7231ULL, 0x000fe400003400ffULL,
0x0000001369697231ULL, 0x080fe400003400ffULL, 0x000000136b6b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000ea20000004200ULL,
0x00000010007c7824ULL, 0x000fcc00078e020aULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000100788c7824ULL, 0x004fe200078e00ffULL, 0x00000078006c7306ULL, 0x000fe20000009400ULL,
0x00000018ff827819ULL, 0x000fe2000001147aULL, 0x0001000079a17824ULL, 0x000fe200078e00ffULL,
0x00000018ff007819ULL, 0x000fe40000011478ULL, 0x00000018ff8c7819ULL, 0x000fe2000001148cULL,
0x000001007cb77824ULL, 0x008fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe2000001147dULL,
0x00000078006d7306ULL, 0x000ea20000005400ULL, 0x00000018ffa17819ULL, 0x000fe200000114a1ULL,
0x000001007dba7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x000fc40000011479ULL,
0x00000018ff847819ULL, 0x000fe4000001147bULL, 0x00000018ff967819ULL, 0x000fe2000001147eULL,
0x0000008c00937306ULL, 0x000fe20000209400ULL, 0x00000018ff977819ULL, 0x000fe4000001147fULL,
0x00000018ffb77819ULL, 0x000fe400000114b7ULL, 0x00000018ffc07819ULL, 0x000fc600000114baULL,
0x0000008c00947306ULL, 0x000ee20000205400ULL, 0x0000006d6c00720bULL, 0x004fe20003f7d000ULL,
0x000001007e6c7824ULL, 0x000fe400078e00ffULL, 0x000001007f6d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x00000079009b7306ULL, 0x000fe20000009400ULL,
0x00000018ff6d7819ULL, 0x000fce000001146dULL, 0x00000079009c7306ULL, 0x000ea20000005400ULL,
0x000000949300720bULL, 0x008fce0003f9d000ULL, 0x0000008200ac7306ULL, 0x000ff00000209400ULL,
0x0000008200ad7306ULL, 0x000fe20000205400ULL, 0x0000009c9b00720bULL, 0x004fce0003fdd000ULL,
0x0000008200107306ULL, 0x000ff0000020d400ULL, 0x0000008f00c37306ULL, 0x000ff00000209400ULL,
0x0000008f00c87306ULL, 0x000ff00000205400ULL, 0x0000008f00827306ULL, 0x0005f0000020d400ULL,
0x0000008c00957306ULL, 0x000662000020d400ULL, 0x00000100798f7824ULL, 0x004fca00078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe4000001148fULL, 0x0000007800927306ULL, 0x000462000000d400ULL,
0x000001007a8c7824ULL, 0x008fca00078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe4000001148cULL,
0x0000000000987306ULL, 0x000fe20000209400ULL, 0x0001000078787824ULL, 0x004fe200078e00ffULL,
0x0000000195954812ULL, 0x002fc800078efcffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000000000997306ULL, 0x000e620000205400ULL, 0x0000000192923812ULL, 0x000fce00078efcffULL,
0x000000a100a27306ULL, 0x000ff00000209400ULL, 0x000000a100a37306ULL, 0x000ea20000205400ULL,
0x000000999800720bULL, 0x002fce0003f9d000ULL, 0x00000079009d7306ULL, 0x000e70000000d400ULL,
0x0000008f009e7306ULL, 0x000fe20000209400ULL, 0x000000a3a200720bULL, 0x004fce0003f7d000ULL,
0x0000008f009f7306ULL, 0x000ea20000205400ULL, 0x000000019d9d6812ULL, 0x002fce00078efcffULL,
0x0000008c00a97306ULL, 0x000ff00000209400ULL, 0x0000008c00aa7306ULL, 0x000e620000205400ULL,
0x0000009f9e00720bULL, 0x004fce0003f1d000ULL, 0x0000008f00a07306ULL, 0x0004f0000020d400ULL,
0x00000000009a7306ULL, 0x0006e2000020d400ULL, 0x000001007b8f7824ULL, 0x004fe200078e00ffULL,
0x000000aaa900720bULL, 0x002fc80003fdd000ULL, 0x00000018ffb07819ULL, 0x000fe4000001148fULL,
0x000000a100a47306ULL, 0x000e62000020d400ULL, 0x00000018ff007819ULL, 0x008fe4000001147cULL,
0x00000001a0a00812ULL, 0x000fca00078efcffULL, 0x0000007b00ae7306ULL, 0x000fe20000009400ULL,
0x000000019a9a4812ULL, 0x000fce00078efcffULL, 0x0000007b00af7306ULL, 0x000ea20000005400ULL,
0x00000001a4a43812ULL, 0x002fce00078efcffULL, 0x000000b000b17306ULL, 0x000ff00000209400ULL,
0x000000b000b27306ULL, 0x000e620000205400ULL, 0x000000afae00720bULL, 0x004fce0003f7d000ULL,
0x0000000d00a57306ULL, 0x000ff00000209400ULL, 0x0000000d00a67306ULL, 0x000ea20000205400ULL,
0x000000b2b100720bULL, 0x002fce0003f9d000ULL, 0x0000000d00917306ULL, 0x000e70000020d400ULL,
0x00000084008a7306ULL, 0x000fe20000209400ULL, 0x000000a6a500720bULL, 0x004fce0003f1d000ULL,
0x00000084008b7306ULL, 0x000fec0000205400ULL, 0x0000000191910812ULL, 0x002fe400078efcffULL,
0x0000008400097306ULL, 0x000ff0000020d400ULL, 0x0000000000bc7306ULL, 0x000ff00000209400ULL,
0x0000000000bd7306ULL, 0x000ff00000205400ULL, 0x0000000000837306ULL, 0x000ff0000020d400ULL,
0x0000009600867306ULL, 0x000ff00000209400ULL, 0x0000009600877306ULL, 0x000ff00000205400ULL,
0x00000096000d7306ULL, 0x000ff0000020d400ULL, 0x0000009700857306ULL, 0x000ff00000209400ULL,
0x0000009700847306ULL, 0x000ff00000205400ULL, 0x0000009700007306ULL, 0x000ff0000020d400ULL,
0x0000008c00ab7306ULL, 0x000e70000020d400ULL, 0x0000007800967306ULL, 0x000ff00000209400ULL,
0x0000007800977306ULL, 0x000ea20000205400ULL, 0x00000001abab6812ULL, 0x002fc400078efcffULL,
0x000000adac00720bULL, 0x000fca0003fdd000ULL, 0x0000007a00a77306ULL, 0x000ff00000009400ULL,
0x0000007a00a87306ULL, 0x000fe20000005400ULL, 0x000000979600720bULL, 0x004fe40003fbd000ULL,
0x0000000110106812ULL, 0x000fca00078efcffULL, 0x0000007a00907306ULL, 0x0003f0000000d400ULL,
0x0000007b00897306ULL, 0x0004e2000000d400ULL, 0x000100007a7a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x000000b000b47306ULL, 0x000e62000020d400ULL,
0x000100007b7b7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x0000007c00b57306ULL, 0x000fe20000009400ULL, 0x0000000189893812ULL, 0x008fce00078efcffULL,
0x0000007c00b87306ULL, 0x000ea20000005400ULL, 0x00000001b4b44812ULL, 0x002fce00078efcffULL,
0x000000b700b07306ULL, 0x000ff00000209400ULL, 0x000000b700b97306ULL, 0x000e620000205400ULL,
0x000000b8b500720bULL, 0x004fce0003f7d000ULL, 0x0000007800797306ULL, 0x000eb0000020d400ULL,
0x0000007a00787306ULL, 0x000fe20000209400ULL, 0x000000b9b000720bULL, 0x002fce0003f9d000ULL,
0x0000007a00a17306ULL, 0x000e620000205400ULL, 0x0000000179795812ULL, 0x004fe400078efcffULL,
0x000000a8a700720bULL, 0x000fca0003fbd000ULL, 0x0000007d00be7306ULL, 0x000ff00000009400ULL,
0x0000007d00bf7306ULL, 0x000ea20000005400ULL, 0x000000a17800720bULL, 0x002fe40003f1d000ULL,
0x0000000190905812ULL, 0x000fc400078efcffULL, 0x000000799a78723eULL, 0x000fe400000010ffULL,
0x000000a49179723eULL, 0x000fe200000010ffULL, 0x0000007c00887306ULL, 0x0002ec000000d400ULL,
0x000000786850723cULL, 0x000b640000041850ULL, 0x0000007d00817306ULL, 0x0006e2000000d400ULL,
0x000100007c7c7824ULL, 0x002fe200078e00ffULL, 0x000000bfbe00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x000000787030723cULL, 0x000b620000041830ULL,
0x0000007a008f7306ULL, 0x000e62000020d400ULL, 0x000100007d7d7824ULL, 0x008fe200078e00ffULL,
0x0000000188883812ULL, 0x000fe400078efcffULL, 0x000000bdbc00720bULL, 0x000fe40003f7d000ULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x0000007b00b37306ULL, 0x000fe20000209400ULL,
0x0000000181816812ULL, 0x000fce00078efcffULL, 0x0000007b00b67306ULL, 0x000ea20000205400ULL,
0x000000018f8f0812ULL, 0x002fe400078efcffULL, 0x0000000183833812ULL, 0x000fca00078efcffULL,
0x0000007b008c7306ULL, 0x000e70000020d400ULL, 0x000000b700bb7306ULL, 0x000ee2000020d400ULL,
0x000000b6b300720bULL, 0x004fce0003fbd000ULL, 0x0000007c007a7306ULL, 0x000fec0000209400ULL,
0x000000018c8c5812ULL, 0x002fe400078efcffULL, 0x0000007c007b7306ULL, 0x000e620000205400ULL,
0x00000001bbbb4812ULL, 0x008fc800078efcffULL, 0x00000088bb88723eULL, 0x000fc600000010ffULL,
0x000000c000c17306ULL, 0x000ff00000209400ULL, 0x000000c000c27306ULL, 0x000ea20000205400ULL,
0x0000007b7a00720bULL, 0x002fe40003f9d000ULL, 0x00000089b47b723eULL, 0x000fc400000010ffULL,
0x00000090ab7a723eULL, 0x000fc600000010ffULL, 0x0000007d00b77306ULL, 0x000fe80000209400ULL,
0x0000007a6854723cULL, 0x000b680000041854ULL, 0x0000007d00c67306ULL, 0x000e620000205400ULL,
0x000000c2c100720bULL, 0x004fc60003f1d000ULL, 0x0000007a7034723cULL, 0x000b680000041834ULL,
0x0000007c00ba7306ULL, 0x000eb0000020d400ULL, 0x0000007f008d7306ULL, 0x000fe20000009400ULL,
0x000000c6b700720bULL, 0x002fce0003fdd000ULL, 0x0000007f008e7306ULL, 0x000e620000005400ULL,
0x00000001baba4812ULL, 0x004fc800078efcffULL, 0x000000ba83ba723eULL, 0x000fc600000010ffULL,
0x0000006c007c7306ULL, 0x000ff00000209400ULL, 0x0000006c00977306ULL, 0x000ea20000205400ULL,
0x0000008e8d00720bULL, 0x002fce0003f7d000ULL, 0x000000c000c47306ULL, 0x000e70000020d400ULL,
0x0000007d00937306ULL, 0x000ee2000020d400ULL, 0x000000977c00720bULL, 0x004fce0003f9d000ULL,
0x0000007e00c57306ULL, 0x000fe20000009400ULL, 0x00000001c4c40812ULL, 0x002fe400078efcffULL,
0x000000c8c300720bULL, 0x000fe40003f1d000ULL, 0x00000081c489723eULL, 0x000fc600000010ffULL,
0x0000007e00ca7306ULL, 0x000e620000005400ULL, 0x0000000193936812ULL, 0x008fc600078efcffULL,
0x00000088685c723cULL, 0x080b68000004185cULL, 0x0000006d00967306ULL, 0x000fe20000209400ULL,
0x0000000182820812ULL, 0x000fe400078efcffULL, 0x0000008b8a00720bULL, 0x000fe20003f1d000ULL,
0x00000088703c723cULL, 0x000b62000004183cULL, 0x0000009382bb723eULL, 0x000fc600000010ffULL,
0x0000006d00997306ULL, 0x000ea20000205400ULL, 0x000000cac500720bULL, 0x002fc60003fbd000ULL,
0x000000ba6860723cULL, 0x000b680000041860ULL, 0x0000007e00217306ULL, 0x0002e2000000d400ULL,
0x0000000109090812ULL, 0x000fc600078efcffULL, 0x000000ba7040723cULL, 0x000b680000041840ULL,
0x0000007f000f7306ULL, 0x0006e2000000d400ULL, 0x000100007e7e7824ULL, 0x002fe200078e00ffULL,
0x000000999600720bULL, 0x004fc80003fdd000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000006c00947306ULL, 0x0002a2000020d400ULL, 0x000100007f7f7824ULL, 0x008fe200078e00ffULL,
0x0000000121215812ULL, 0x000fe400078efcffULL, 0x000000848500720bULL, 0x000fe40003fbd000ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000006d00987306ULL, 0x0006e2000020d400ULL,
0x00000092956c723eULL, 0x002fc400000010ffULL, 0x000000010f0f3812ULL, 0x000fca00078efcffULL,
0x0000007e007d7306ULL, 0x000fe20000209400ULL, 0x0000000194944812ULL, 0x004fe400078efcffULL,
0x000000878600720bULL, 0x000fe40003f9d000ULL, 0x0000000100005812ULL, 0x000fe400078efcffULL,
0x0000009da06d723eULL, 0x008fe200000010ffULL, 0x0000007e00927306ULL, 0x000e620000205400ULL,
0x0000000198986812ULL, 0x000fe400078efcffULL, 0x000000219494723eULL, 0x000fc400000010ffULL,
0x0000000f9895723eULL, 0x000fe200000010ffULL, 0x0000006c684c723cULL, 0x000b64000004184cULL,
0x0000007f007c7306ULL, 0x000fe20000209400ULL, 0x000000010d0d4812ULL, 0x000fca00078efcffULL,
0x000000946864723cULL, 0x000b640000041864ULL, 0x0000007f008d7306ULL, 0x000ea20000205400ULL,
0x000000927d00720bULL, 0x002fe40003fdd000ULL, 0x0000008c097d723eULL, 0x000fc600000010ffULL,
0x0000006c702c723cULL, 0x040b64000004182cULL, 0x0000007e007e7306ULL, 0x000e6c000020d400ULL,
0x000000947044723cULL, 0x000b640000041844ULL, 0x0000007f007f7306ULL, 0x000ee2000020d400ULL,
0x0000008d7c00720bULL, 0x004fc40003f7d000ULL, 0x0000008f107c723eULL, 0x000fe400000010ffULL,
0x000000017e7e6812ULL, 0x002fca00078efcffULL, 0x0000007c6858723cULL, 0x000b620000041858ULL,
0x0000007e0d7e723eULL, 0x000fc600000010ffULL, 0x000000017f7f3812ULL, 0x008fc800078efcffULL,
0x0000007c7038723cULL, 0x000b620000041838ULL, 0x0000007f007f723eULL, 0x000fe200000010ffULL,
0x0000000202007824ULL, 0x000fca00078e00ffULL, 0xfffffff800097812ULL, 0x000fe200078ec0ffULL,
0x0000007e7048723cULL, 0x080b700000041848ULL, 0x0000007e6868723cULL, 0x000b620000041828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000001a6c7f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6980009ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x000fc600078e00ffULL,
0x0000000000287805ULL, 0x000fc80000015200ULL, 0x000004001a097984ULL, 0x008ee40000000800ULL,
0x8000000009ff7812ULL, 0x00cfc4000780486dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28107210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2a7824ULL, 0x000fe200000e0e29ULL, 0x003d09001000780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401000780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc8000001142aULL,
0x0000001009097211ULL, 0x000fca00078110ffULL, 0x000000ffff107224ULL, 0x000fca00000e062aULL,
0x0000000209097819ULL, 0x000fc80000001210ULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000100007810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004001a097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000011b097810ULL, 0x000fc80007ffe0ffULL, 0x000000060900720cULL, 0x000fda0003f06070ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x000000021b097810ULL, 0x000fe20007ffe0ffULL,
0x0000590024007a24ULL, 0x010fe200078e02ffULL, 0x0000010027277810ULL, 0x000fe40007ffe0ffULL,
0x000000060900720cULL, 0x000fe20003f06070ULL, 0x00000080000d7824ULL, 0x000fe200078e00ffULL,
0x0000006027097812ULL, 0x000fca00078ec0ffULL, 0x000000011e0f7824ULL, 0x000fcc00078e0209ULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x0000002704007217ULL, 0x000fe20007800000ULL,
0x0000001002097824ULL, 0x000fe200078e00ffULL, 0x00000003ff107819ULL, 0x000fc60000011608ULL,
0x0000000100007824ULL, 0x000fe200078e0a27ULL, 0x0000001009217812ULL, 0x000fe400078ec0ffULL,
0x0000000410297810ULL, 0x040fe40007ffe0ffULL, 0x0000000021007217ULL, 0x000fe20007800000ULL,
0x0000000110277824ULL, 0x140fe200078e0221ULL, 0x00000008102b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000129717824ULL, 0x100fe200078e0221ULL, 0x000064000d097a11ULL, 0x000fe200078038ffULL,
0x0000000100007824ULL, 0x000fe200078e0a21ULL, 0x0000000c106d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127287824ULL, 0x100fe200078e020fULL, 0x000065000d0d7a11ULL, 0x000fe200000f3cffULL,
0x00000001712a7824ULL, 0x000fe200078e020fULL, 0x000000002900720cULL, 0x080fe20003f86070ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x000000002b00720cULL, 0x000fc40003f66070ULL,
0x000000001000720cULL, 0x080fe20003fa6070ULL, 0x000000012b727824ULL, 0x000fe200078e0221ULL,
0x00000019286c7212ULL, 0x080fe200078efcffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x000000006d00720cULL, 0x000fe40003f06070ULL, 0x0000006c096c7210ULL, 0x000fe20007fde0ffULL,
0x0000000172287824ULL, 0x000fe200078e020fULL, 0x000000192a707212ULL, 0x000fe200078efcffULL,
0x0000000127107824ULL, 0x040fe400078e0208ULL, 0x0000000827737824ULL, 0x000fc400078e00ffULL,
0x000000016d277824ULL, 0x000fe400078e0221ULL, 0x0000000171007824ULL, 0x000fe200078e0208ULL,
0xfffffff873217812ULL, 0x000fe200078ee210ULL, 0x00000001296d7824ULL, 0x000fe200030e060dULL,
0x0000000970707210ULL, 0x000fe20007fde0ffULL, 0x0000000871717824ULL, 0x000fe400078e00ffULL,
0x0000008028287825ULL, 0x000fc800078e00ffULL, 0x00000001272a7824ULL, 0x000fe200078e020fULL,
0xfffffff8710f7812ULL, 0x000fe200078ee200ULL, 0x000000012b717824ULL, 0x000fe200030e060dULL,
0x0000001928287212ULL, 0x000fe200078efcffULL, 0x000000802a2a7825ULL, 0x000fc600078e00ffULL,
0x0000000928287210ULL, 0x000fe20007fde0ffULL, 0x0000000172007824ULL, 0x100fe200078e0208ULL,
0x000000192a2a7212ULL, 0x000fe200078efcffULL, 0x0000000872737824ULL, 0x000fe400078e00ffULL,
0x0000000127107824ULL, 0x040fe400078e0208ULL, 0x0000000827797824ULL, 0x000fe200078e00ffULL,
0xfffffff873277812ULL, 0x000fe200078ee200ULL, 0x0000000129297824ULL, 0x000fe200030e060dULL,
0x000000092a2a7210ULL, 0x000fe20007fde0ffULL, 0x0000001021217824ULL, 0x000fe200078e020aULL,
0xfffffff879737812ULL, 0x000fe200078ee210ULL, 0x000000100f0f7824ULL, 0x000fc400078e020aULL,
0x0000001027277824ULL, 0x100fe200078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c217faeULL, 0x0005e2000e901c46ULL, 0x0000001073737824ULL, 0x000fe400078e020aULL,
0x000000012b2b7824ULL, 0x000fe200030e060dULL, 0x00000000700f7faeULL, 0x0005e8000e101c46ULL,
0x0000000028277faeULL, 0x0005e8000d901c46ULL, 0x000000002a737faeULL, 0x0005e2000c101c46ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001002007824ULL, 0x000fca00078e00ffULL,
0x0000001000097812ULL, 0x000fc800078ec0ffULL, 0x0000000908097211ULL, 0x000fc800078fe8ffULL,
0x0000000409107810ULL, 0x040fe20007ffe0ffULL, 0x0000000109007824ULL, 0x040fe200078e0208ULL,
0x0000000809277810ULL, 0x040fe20007ffe0ffULL, 0x0000000809217824ULL, 0x040fe200078e00ffULL,
0x0000000c09297810ULL, 0x040fe20007ffe0ffULL, 0x0000000109287824ULL, 0x100fe400078e020fULL,
0x00000001102a7824ULL, 0x040fe200078e020fULL, 0xfffffff821217812ULL, 0x000fe200078ee200ULL,
0x0000000110007824ULL, 0x040fe400078e0208ULL, 0x00000008102b7824ULL, 0x000fc400078e00ffULL,
0x0000000127097824ULL, 0x140fe400078e0208ULL, 0x0000000827727824ULL, 0x000fe400078e00ffULL,
0x0000000129707824ULL, 0x040fe400078e020fULL, 0x0000000129107824ULL, 0x040fe400078e0208ULL,
0x0000000829737824ULL, 0x000fe400078e00ffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff873737812ULL, 0x000fe200078ee210ULL, 0x00000001276c7824ULL, 0x000fe200078e020fULL,
0xfffffff872277812ULL, 0x000fe200078ee209ULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000064000d097a11ULL, 0x000fe400078038ffULL, 0xfffffff82b0f7812ULL, 0x000fe200078ee200ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001928287212ULL, 0x000fe400078efcffULL,
0x000065000d0d7a11ULL, 0x000fe200000f3cffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000002809287210ULL, 0x000fc40007f1e0ffULL, 0x000000192a2a7212ULL, 0x080fe200078efcffULL,
0x0000001021217824ULL, 0x100fe200078e020aULL, 0x000000196c6c7212ULL, 0x080fe200078efcffULL,
0x0000000129297824ULL, 0x100fe200000e060dULL, 0x0000001970707212ULL, 0x000fe200078efcffULL,
0x000000100f0f7824ULL, 0x100fe200078e020aULL, 0x0000002a092a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001027277824ULL, 0x100fe200078e020aULL, 0x0000006c096c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001073737824ULL, 0x000fe200078e020aULL, 0x0000007009707210ULL, 0x000fe20007f9e0ffULL,
0x000000012b2b7824ULL, 0x100fe200000e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028217faeULL, 0x0005e2000b901c46ULL, 0x000000016d6d7824ULL, 0x000fc400018e060dULL,
0x0000000171717824ULL, 0x000fe200020e060dULL, 0x000000002a0f7faeULL, 0x0005e8000b901c46ULL,
0x000000006c277faeULL, 0x0005e8000b901c46ULL, 0x0000000070737faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000802007824ULL, 0x000fc400078e00ffULL,
0x000000021c097824ULL, 0x000fe200078e0275ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x0000000800007812ULL, 0x000fca00078ec0ffULL, 0x0000001009097824ULL, 0x000fe200078e0000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000017287f8cULL, 0x0044e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a66800096c7f8cULL, 0x0002a2000c80043fULL, 0x000000ffff007224ULL, 0x008fc600078e0029ULL,
0x0000000000287805ULL, 0x000fc80000015200ULL, 0x01a66c00090d7984ULL, 0x000ee40000000800ULL,
0x800000000dff7812ULL, 0x00cfe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a280d7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2a7824ULL, 0x000fe200000e0e29ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001142aULL, 0x0000000d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e062aULL, 0x000000020a0a7819ULL, 0x000fc8000000120dULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a66c00090d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001801c097811ULL, 0x002fc800078e38ffULL,
0x0000000974097210ULL, 0x000fca0007ffe019ULL, 0x01a00000090a7984ULL, 0x000e680000000800ULL,
0x01a20000090d7984ULL, 0x0004e20000000800ULL, 0x000000230a00720bULL, 0x002fe20003f1d000ULL,
0x000102127f007947ULL, 0x000fd8000b800000ULL, 0x00000000000f7806ULL, 0x004fc800000e0100ULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x00000001ff107424ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fd200078e0023ULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x000000031c097810ULL, 0x000fe40007ffe0ffULL,
0x000000230a00720bULL, 0x000fe40003f74000ULL, 0x000000020900720cULL, 0x000fe20003f05270ULL,
0x000101d27f007947ULL, 0x000fd4000b800000ULL, 0x00000000006c7806ULL, 0x000fc400018e0100ULL,
0x0000008002198824ULL, 0x000fe200078e0219ULL, 0x000000230a097209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000174748824ULL, 0x000fca00078e0219ULL,
0x01a4000974008388ULL, 0x0003e20000000800ULL, 0x000000ff6c00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000002309177221ULL, 0x002fe20000010100ULL,
0x000000ff6cff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b17177820ULL, 0x000fcc0000410000ULL, 0x0000001700177308ULL, 0x000e640000000800ULL,
0x0000001722227220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe20000011608ULL, 0x000101227f007947ULL, 0x000fea000b800000ULL,
0x00001f2917297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff006cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000808297811ULL, 0x000fe200078ff0ffULL,
0x000100127f007947ULL, 0x000fea000b800000ULL, 0x00001f2917297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00006cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001008297811ULL, 0x000fe200078ff0ffULL, 0x0000ff027f007947ULL, 0x000fea000b800000ULL,
0x00001f2917297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000006cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001808297811ULL, 0x000fe200078ff0ffULL, 0x0000fe027f007947ULL, 0x000fea000b800000ULL,
0x00001f2917297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006c0fff7212ULL, 0x000fda00078030ffULL, 0x0000000a090a0221ULL, 0x000fe20000010100ULL,
0x00007610ff100816ULL, 0x000fc60000000010ULL, 0x3fb8aa3b0a0a0820ULL, 0x000fc80000410000ULL,
0x0000000a00180308ULL, 0x000e640000000800ULL, 0x000000180d0d0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000220d227221ULL, 0x008fc40000010000ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x00000008020a7824ULL, 0x000fca00078e00ffULL,
0xfffffff00a0f7812ULL, 0x000fca00078ec0ffULL, 0x01a6b4000f0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff177224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a280d7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2a7824ULL, 0x000fe200000e0e29ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001142aULL, 0x0000000d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e062aULL, 0x000000020a0a7819ULL, 0x000fc8000000120dULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000117177810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6b4000f0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910100a7816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000018ff0a723eULL, 0x000fe400000010ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011608ULL, 0x000054100a0a7816ULL, 0x000fe2000000000aULL,
0x0000f9f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0a167589ULL, 0x0002a400000e0000ULL,
0x000000080d297810ULL, 0x000fe20007ffe0ffULL, 0x0000fa427f007947ULL, 0x000fea000b800000ULL,
0x000000100d0f7810ULL, 0x000fe20007ffe0ffULL, 0x00001f290a157589ULL, 0x00066800000e0000ULL,
0x00001f0f0a147589ULL, 0x0006a400000e0000ULL, 0x000000180d297810ULL, 0x008fe20007ffe0ffULL,
0x0000fad27f007947ULL, 0x000fea000b800000ULL, 0x00001f290a137589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff0a7819ULL, 0x00afe20000011608ULL,
0x0000000812107824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000811177824ULL, 0x000fe200078e00ffULL, 0x000001b000007945ULL, 0x000fe20003800000ULL,
0x00000004750a7824ULL, 0x000fc400078e020aULL, 0x00000004020f7824ULL, 0x000fe400078e00ffULL,
0x00000001120d7824ULL, 0x100fe400078e020aULL, 0x00000001110a7824ULL, 0x000fe200078e020aULL,
0x000000040f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000100e787824ULL, 0x000fe200078e0225ULL,
0xfffffff810107812ULL, 0x000fe400078ee20dULL, 0x000150001c0d7811ULL, 0x000fe400078e60ffULL,
0xfffffff817287812ULL, 0x000fc400078ee20aULL, 0x000000020f0f7812ULL, 0x000fe200078efcffULL,
0x0000001010107824ULL, 0x100fe400078e020dULL, 0x0000001028287824ULL, 0x000fe200078e020dULL,
0x0000000f080a7211ULL, 0x000fe200078fe0ffULL, 0x00000008120f7824ULL, 0x040fe200078e00ffULL,
0x00000000106c783bULL, 0x0002e60000000200ULL, 0x0000000112127824ULL, 0x000fe200078e020aULL,
0x000000002828783bULL, 0x000ea20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x000000166c6c7231ULL, 0x08cfe400003400ffULL, 0x000000166e6e7231ULL, 0x000fc400003400ffULL,
0x000000156d6d7231ULL, 0x080fe400003400ffULL, 0x000000156f6f7231ULL, 0x000fe400003400ffULL,
0x0000001428287231ULL, 0x080fe400003400ffULL, 0x000000142a2a7231ULL, 0x000fe400003400ffULL,
0x0000001329297231ULL, 0x080fe400003400ffULL, 0x000000132b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff80f127812ULL, 0x000fe200078ee212ULL,
0x000000007878783bULL, 0x000e620000004200ULL, 0x00000fa000007945ULL, 0x000fe20003800000ULL,
0x00000001110a7824ULL, 0x000fc400078e020aULL, 0x0000001012127824ULL, 0x000fe400078e0225ULL,
0x0000000811117824ULL, 0x000fc600078e00ffULL, 0x000000001270783bULL, 0x000ee20000004200ULL,
0x00000100788a7824ULL, 0x002fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x000fe20000011478ULL,
0x00000100798d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff197819ULL, 0x000fe2000001147aULL,
0x0000007800877306ULL, 0x000fe20000009400ULL, 0x00000018ff8a7819ULL, 0x000fe2000001148aULL,
0x000001007aa27824ULL, 0x000fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe2000001148dULL,
0x000001007ba67824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x008fe20000011471ULL,
0x0000010070b47824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe2000001147bULL,
0x0000007800887306ULL, 0x000e620000005400ULL, 0x00000018ff997819ULL, 0x000fe20000011473ULL,
0x0000010071b97824ULL, 0x000fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fc40000011479ULL,
0x00000018ff907819ULL, 0x000fe40000011472ULL, 0x00000018ffa27819ULL, 0x000fe200000114a2ULL,
0x0000000f008f7306ULL, 0x000fe20000209400ULL, 0x00000018ffa97819ULL, 0x000fe400000114a6ULL,
0x00000018ffb47819ULL, 0x000fe400000114b4ULL, 0x00000018ffb97819ULL, 0x000fc600000114b9ULL,
0x0000000f00927306ULL, 0x000fe20000205400ULL, 0x000000888700720bULL, 0x002fce0003fdd000ULL,
0x0000000f00947306ULL, 0x0003f0000020d400ULL, 0x0000001900a57306ULL, 0x000fe20000209400ULL,
0x00000018ff0f7819ULL, 0x002fce0000011470ULL, 0x0000001900a87306ULL, 0x000ff00000205400ULL,
0x0000001900837306ULL, 0x000ff0000020d400ULL, 0x0000008b00bd7306ULL, 0x000ff00000209400ULL,
0x0000008b00c47306ULL, 0x000ff00000205400ULL, 0x0000008b00197306ULL, 0x000ff0000020d400ULL,
0x0000007900917306ULL, 0x000ff00000009400ULL, 0x0000007900967306ULL, 0x000e700000005400ULL,
0x0000008a008b7306ULL, 0x000ff00000209400ULL, 0x0000008a008c7306ULL, 0x000ee20000205400ULL,
0x000000969100720bULL, 0x002fce0003f9d000ULL, 0x0000009500977306ULL, 0x000ff00000209400ULL,
0x0000009500987306ULL, 0x000e620000205400ULL, 0x0000008c8b00720bULL, 0x008fce0003fbd000ULL,
0x0000007d00b07306ULL, 0x000ff00000209400ULL, 0x0000007d00b17306ULL, 0x000fe20000205400ULL,
0x000000989700720bULL, 0x002fce0003f7d000ULL, 0x0000007d00277306ULL, 0x000ff0000020d400ULL,
0x0000000f00b57306ULL, 0x000ff00000209400ULL, 0x0000000f00bc7306ULL, 0x000ff00000205400ULL,
0x0000000f00217306ULL, 0x000ff0000020d400ULL, 0x0000007800897306ULL, 0x0002f0000000d400ULL,
0x00000099007e7306ULL, 0x000fe20000209400ULL, 0x0001000078787824ULL, 0x002fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000099007d7306ULL, 0x000fe20000205400ULL,
0x0000000189896812ULL, 0x008fe400078efcffULL, 0x000000928f00720bULL, 0x000fca0003fdd000ULL,
0x00000099000f7306ULL, 0x0003f0000020d400ULL, 0x00000012009d7306ULL, 0x000fe20000209400ULL,
0x0001000079997824ULL, 0x002fe200078e00ffULL, 0x0000000194946812ULL, 0x000fc800078efcffULL,
0x00000018ff997819ULL, 0x000fe40000011499ULL, 0x00000012009e7306ULL, 0x000ff00000205400ULL,
0x00000012009f7306ULL, 0x000ff0000020d400ULL, 0x0000007900937306ULL, 0x000e70000000d400ULL,
0x00000090007c7306ULL, 0x000ff00000209400ULL, 0x0000009000817306ULL, 0x000fe20000205400ULL,
0x0000000193934812ULL, 0x002fc400078efcffULL, 0x0000009e9d00720bULL, 0x000fca0003f9d000ULL,
0x0000009000127306ULL, 0x000ff0000020d400ULL, 0x0000008a008e7306ULL, 0x000e62000020d400ULL,
0x000000019f9f4812ULL, 0x000fce00078efcffULL, 0x00000095009a7306ULL, 0x000ef0000020d400ULL,
0x00000078008d7306ULL, 0x000fe20000209400ULL, 0x000000018e8e5812ULL, 0x002fce00078efcffULL,
0x0000007800907306ULL, 0x000e620000205400ULL, 0x000000019a9a3812ULL, 0x008fce00078efcffULL,
0x00000099008a7306ULL, 0x000ff00000209400ULL, 0x00000099009b7306ULL, 0x000ee20000205400ULL,
0x000000908d00720bULL, 0x002fce0003fbd000ULL, 0x0000007a00a07306ULL, 0x000ff00000009400ULL,
0x0000007a00a17306ULL, 0x000e620000005400ULL, 0x0000009b8a00720bULL, 0x008fce0003f7d000ULL,
0x0000007800797306ULL, 0x000ef0000020d400ULL, 0x00000099009c7306ULL, 0x000ea2000020d400ULL,
0x000000a1a000720bULL, 0x002fce0003fdd000ULL, 0x0000007b00a77306ULL, 0x000fe20000009400ULL,
0x0000000179795812ULL, 0x008fce00078efcffULL, 0x0000007b00aa7306ULL, 0x000e620000005400ULL,
0x000000019c9c3812ULL, 0x004fce00078efcffULL, 0x000000a200957306ULL, 0x000ff00000209400ULL,
0x000000a200a47306ULL, 0x000ea20000205400ULL, 0x000000aaa700720bULL, 0x002fce0003f9d000ULL,
0x000000a900ab7306ULL, 0x000ff00000209400ULL, 0x000000a900ac7306ULL, 0x000e620000205400ULL,
0x000000a49500720bULL, 0x004fce0003fbd000ULL, 0x0000007a00867306ULL, 0x0004f0000000d400ULL,
0x0000007b00827306ULL, 0x0006e2000000d400ULL, 0x000100007a7a7824ULL, 0x004fe200078e00ffULL,
0x000000acab00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x000000a200a37306ULL, 0x000e62000020d400ULL, 0x000100007b7b7824ULL, 0x008fe200078e00ffULL,
0x0000000186866812ULL, 0x000fe400078efcffULL, 0x000000a8a500720bULL, 0x000fe40003fdd000ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x000000a900ad7306ULL, 0x000ea2000020d400ULL,
0x0000000182824812ULL, 0x000fc400078efcffULL, 0x000000b1b000720bULL, 0x000fca0003f9d000ULL,
0x0000007a00787306ULL, 0x000fe20000209400ULL, 0x00000001a3a35812ULL, 0x002fe400078efcffULL,
0x0000000183836812ULL, 0x000fca00078efcffULL, 0x0000007a00997306ULL, 0x000e620000205400ULL,
0x00000001adad3812ULL, 0x004fe400078efcffULL, 0x0000000127274812ULL, 0x000fca00078efcffULL,
0x0000007b00a27306ULL, 0x000ff00000209400ULL, 0x0000007b00af7306ULL, 0x000ea20000205400ULL,
0x000000997800720bULL, 0x002fe40003fbd000ULL, 0x00000086a378723eULL, 0x000fca00000010ffULL,
0x0000007000b27306ULL, 0x000ff00000009400ULL, 0x0000007000b37306ULL, 0x000e620000005400ULL,
0x000000afa200720bULL, 0x004fce0003f7d000ULL, 0x0000007a00a67306ULL, 0x000eb0000020d400ULL,
0x0000007b00ae7306ULL, 0x000ee2000020d400ULL, 0x000000b3b200720bULL, 0x002fce0003fdd000ULL,
0x0000007100b77306ULL, 0x000fe20000009400ULL, 0x00000001a6a65812ULL, 0x004fc800078efcffULL,
0x000000a683a6723eULL, 0x000fc600000010ffULL, 0x0000007100be7306ULL, 0x000e620000005400ULL,
0x00000001aeae3812ULL, 0x008fc800078efcffULL, 0x000000ae27a7723eULL, 0x000fc600000010ffULL,
0x000000b400a97306ULL, 0x000fe80000209400ULL, 0x000000a62858723cULL, 0x000f680000041858ULL,
0x000000b400b67306ULL, 0x000ea20000205400ULL, 0x000000beb700720bULL, 0x002fc60003f9d000ULL,
0x000000a66c38723cULL, 0x000f680000041838ULL, 0x000000b900bb7306ULL, 0x000ff00000209400ULL,
0x000000b900c07306ULL, 0x000e620000205400ULL, 0x000000b6a900720bULL, 0x004fce0003fbd000ULL,
0x0000007000237306ULL, 0x0004f0000000d400ULL, 0x0000007100177306ULL, 0x0006e2000000d400ULL,
0x0001000070707824ULL, 0x004fe200078e00ffULL, 0x000000c0bb00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x000000b400b87306ULL, 0x000e62000020d400ULL,
0x0001000071717824ULL, 0x008fe200078e00ffULL, 0x0000000123236812ULL, 0x000fe400078efcffULL,
0x000000bcb500720bULL, 0x000fe40003fdd000ULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x000000b900c27306ULL, 0x000ea2000020d400ULL, 0x0000000117174812ULL, 0x000fce00078efcffULL,
0x00000070007a7306ULL, 0x000fe20000209400ULL, 0x00000001b8b85812ULL, 0x002fe400078efcffULL,
0x0000000121216812ULL, 0x000fe400078efcffULL, 0x00000023b8b8723eULL, 0x000fc600000010ffULL,
0x00000070007b7306ULL, 0x000e620000205400ULL, 0x00000001c2c23812ULL, 0x004fe400078efcffULL,
0x000000c4bd00720bULL, 0x000fe40003f7d000ULL, 0x00000017c2b9723eULL, 0x000fc600000010ffULL,
0x0000007100877306ULL, 0x000fe80000209400ULL, 0x000000b8285c723cULL, 0x080f68000004185cULL,
0x0000007100887306ULL, 0x000ea20000205400ULL, 0x0000007b7a00720bULL, 0x002fe40003fbd000ULL,
0x0000000119193812ULL, 0x000fe200078efcffULL, 0x000000b86c3c723cULL, 0x000f68000004183cULL,
0x0000007000ba7306ULL, 0x0002f0000020d400ULL, 0x00000071008c7306ULL, 0x0006e2000020d400ULL,
0x0000010072707824ULL, 0x002fe200078e00ffULL, 0x000000888700720bULL, 0x004fc80003f9d000ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000007200847306ULL, 0x000fe20000009400ULL,
0x0000010073717824ULL, 0x008fe200078e00ffULL, 0x00000001baba5812ULL, 0x000fc800078efcffULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x0000007200857306ULL, 0x000e620000005400ULL,
0x000000018c8c4812ULL, 0x000fe400078efcffULL, 0x000000ba21ba723eULL, 0x000fe400000010ffULL,
0x0000008c19bb723eULL, 0x000fc600000010ffULL, 0x0000007300747306ULL, 0x000fe80000009400ULL,
0x000000ba2860723cULL, 0x000f680000041860ULL, 0x00000073007f7306ULL, 0x000ea20000005400ULL,
0x000000858400720bULL, 0x002fc60003fdd000ULL, 0x000000ba6c40723cULL, 0x000f680000041840ULL,
0x00000070008a7306ULL, 0x000ff00000209400ULL, 0x00000070008b7306ULL, 0x000e620000205400ULL,
0x0000007f7400720bULL, 0x004fce0003f7d000ULL, 0x0000007100907306ULL, 0x000ff00000209400ULL,
0x0000007100917306ULL, 0x000ea20000205400ULL, 0x0000008b8a00720bULL, 0x002fce0003fbd000ULL,
0x0000007200107306ULL, 0x0002f0000000d400ULL, 0x00000073000e7306ULL, 0x0006e2000000d400ULL,
0x0001000072727824ULL, 0x002fe200078e00ffULL, 0x000000919000720bULL, 0x004fc80003f9d000ULL,
0x00000018ff8f7819ULL, 0x000fe40000011472ULL, 0x00000070008d7306ULL, 0x0002a2000020d400ULL,
0x0001000073737824ULL, 0x008fe200078e00ffULL, 0x0000000110106812ULL, 0x000fe400078efcffULL,
0x0000007d7e00720bULL, 0x000fe40003fdd000ULL, 0x00000018ff877819ULL, 0x000fe40000011473ULL,
0x0000007100957306ULL, 0x0006e2000020d400ULL, 0x000000010e0e3812ULL, 0x000fc400078efcffULL,
0x000000799472723eULL, 0x000fe400000010ffULL, 0x000000898e70723eULL, 0x002fe400000010ffULL,
0x0000009c9f73723eULL, 0x000fe200000010ffULL, 0x0000008f007a7306ULL, 0x000fe20000209400ULL,
0x000000018d8d5812ULL, 0x004fe400078efcffULL, 0x000000817c00720bULL, 0x000fe40003fbd000ULL,
0x000000010f0f6812ULL, 0x000fe200078efcffULL, 0x000000722850723cULL, 0x000f620000041850ULL,
0x000000939a71723eULL, 0x008fe200000010ffULL, 0x0000008f007b7306ULL, 0x000e620000205400ULL,
0x0000000195954812ULL, 0x000fc400078efcffULL, 0x00000082ad79723eULL, 0x000fc600000010ffULL,
0x00000070284c723cULL, 0x000f64000004184cULL, 0x0000008700887306ULL, 0x000fe20000209400ULL,
0x0000000112125812ULL, 0x000fca00078efcffULL, 0x000000782854723cULL, 0x000f640000041854ULL,
0x0000008700857306ULL, 0x000ea20000205400ULL, 0x0000007b7a00720bULL, 0x002fe40003f9d000ULL,
0x0000000e957b723eULL, 0x000fe400000010ffULL, 0x000000108d7a723eULL, 0x000fe200000010ffULL,
0x000000100c107824ULL, 0x100fe200078e020dULL, 0x000000706c2c723cULL, 0x000f62000004182cULL,
0x0000008f008f7306ULL, 0x000e62000020d400ULL, 0x000000100b0d7824ULL, 0x000fcc00078e020dULL,
0x0000007a2864723cULL, 0x000f620000041864ULL, 0x0000008700747306ULL, 0x000ee2000020d400ULL,
0x000000858800720bULL, 0x004fcc0003f7d000ULL, 0x000000726c30723cULL, 0x000f620000041830ULL,
0x000000018f8f4812ULL, 0x002fc800078efcffULL, 0x0000008f120e723eULL, 0x000fc600000010ffULL,
0x000000786c34723cULL, 0x000f620000041834ULL, 0x0000000174743812ULL, 0x008fc800078efcffULL,
0x000000740f0f723eULL, 0x000fc600000010ffULL, 0x0000007a6c44723cULL, 0x040f700000041844ULL,
0x0000000e6c48723cULL, 0x080f700000041848ULL, 0x0000000e2868723cULL, 0x000b640000041868ULL,
0x000000001028783bULL, 0x0202a80000000200ULL, 0x000000000d0c783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fd80003800000ULL, 0x0000001628287231ULL, 0x084fe400003400ffULL,
0x000000162a2a7231ULL, 0x000fc400003400ffULL, 0x0000001529297231ULL, 0x080fe400003400ffULL,
0x000000152b2b7231ULL, 0x000fe400003400ffULL, 0x000000140c0c7231ULL, 0x088fe400003400ffULL,
0x000000140e0e7231ULL, 0x000fe400003400ffULL, 0x000000130d0d7231ULL, 0x080fe400003400ffULL,
0x000000130f0f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff8110a7812ULL, 0x000fe200078ee20aULL, 0x00000000266c783bULL, 0x000e680000004200ULL,
0x000000100a0a7824ULL, 0x000fca00078e0225ULL, 0x000000000a70783bULL, 0x000ee20000004200ULL,
0x0000006c00277306ULL, 0x002fe20000009400ULL, 0x00000018ff0b7819ULL, 0x000fe2000001146cULL,
0x000001006c267824ULL, 0x000fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fe2000001146dULL,
0x000001006d817824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe2000001146fULL,
0x000001006e987824ULL, 0x000fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fe2000001146eULL,
0x0000006c007e7306ULL, 0x000e620000005400ULL, 0x00000018ff867819ULL, 0x008fe20000011472ULL,
0x000001006f9d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe20000011473ULL,
0x0000010070ab7824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fe20000011481ULL,
0x000100006fa37824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe20000011471ULL,
0x0000006c007d7306ULL, 0x0006a2000000d400ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000010071b07824ULL, 0x000fe200078e00ffULL, 0x00000018ff987819ULL, 0x000fc40000011498ULL,
0x00000018ff9d7819ULL, 0x000fe4000001149dULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x0000000b00837306ULL, 0x000fe20000209400ULL, 0x000100006c6c7824ULL, 0x008fe200078e00ffULL,
0x0000007e2700720bULL, 0x002fe20003f7d000ULL, 0x0000010072277824ULL, 0x000fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe400000114a3ULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000000b00887306ULL, 0x000fe20000205400ULL, 0x00000018ffb17819ULL, 0x000fc400000114b0ULL,
0x00000018ff277819ULL, 0x000fc80000011427ULL, 0x000000017d7d3812ULL, 0x004fe200078efcffULL,
0x0000000b008a7306ULL, 0x0003f0000020d400ULL, 0x0000001100927306ULL, 0x000fe20000209400ULL,
0x00000018ff0b7819ULL, 0x002fce0000011470ULL, 0x0000001100937306ULL, 0x000ff00000205400ULL,
0x0000001100947306ULL, 0x000ff0000020d400ULL, 0x0000008600747306ULL, 0x000ff00000209400ULL,
0x0000008600797306ULL, 0x000ff00000205400ULL, 0x0000008600117306ULL, 0x000ff0000020d400ULL,
0x0000002500a77306ULL, 0x000ff00000209400ULL, 0x0000002500a87306ULL, 0x000ff00000205400ULL,
0x0000002500237306ULL, 0x000ff0000020d400ULL, 0x0000000b00ad7306ULL, 0x000ff00000209400ULL,
0x0000000b00b27306ULL, 0x000ff00000205400ULL, 0x0000000b00197306ULL, 0x000ff0000020d400ULL,
0x0000006c00817306ULL, 0x000ff00000209400ULL, 0x0000006c00867306ULL, 0x000e700000205400ULL,
0x0000008d007a7306ULL, 0x000ff00000209400ULL, 0x0000008d00257306ULL, 0x000fe20000205400ULL,
0x000000868100720bULL, 0x002fce0003fdd000ULL, 0x0000008d000b7306ULL, 0x0003f0000020d400ULL,
0x0000001200997306ULL, 0x000fe20000209400ULL, 0x000100006d8d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe4000001148dULL, 0x00000012009e7306ULL, 0x000ff00000205400ULL,
0x0000001200a07306ULL, 0x000ff0000020d400ULL, 0x0000007f00b57306ULL, 0x000ff00000209400ULL,
0x0000007f00bc7306ULL, 0x000ff00000205400ULL, 0x0000007f00127306ULL, 0x000ff0000020d400ULL,
0x00000026007f7306ULL, 0x000ff00000209400ULL, 0x0000002600827306ULL, 0x000e700000205400ULL,
0x0000002600847306ULL, 0x000eb0000020d400ULL, 0x0000008d00267306ULL, 0x000fe20000209400ULL,
0x000000827f00720bULL, 0x002fe20003f1d000ULL, 0x0001000073827824ULL, 0x000fca00078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000008d008f7306ULL, 0x000e6c0000205400ULL,
0x0000000184840812ULL, 0x004fe400078efcffULL, 0x0000006d00857306ULL, 0x000fe20000009400ULL,
0x000000888300720bULL, 0x000fce0003f1d000ULL, 0x0000006d008c7306ULL, 0x000ea20000005400ULL,
0x0000008f2600720bULL, 0x002fe20003f7d000ULL, 0x0000010073267824ULL, 0x000fc800078e00ffULL,
0x000000018a8a0812ULL, 0x000fe400078efcffULL, 0x0000006d00877306ULL, 0x000e62000000d400ULL,
0x00000018ff267819ULL, 0x000fce0000011426ULL, 0x00000089008b7306ULL, 0x000fe20000209400ULL,
0x0000008c8500720bULL, 0x004fce0003f9d000ULL, 0x00000089008e7306ULL, 0x000eac0000205400ULL,
0x0000000187874812ULL, 0x002fe400078efcffULL, 0x0000008900907306ULL, 0x000e62000020d400ULL,
0x000000939200720bULL, 0x000fce0003f9d000ULL, 0x0000006c006d7306ULL, 0x000ee2000020d400ULL,
0x0000008e8b00720bULL, 0x004fca0003fbd000ULL, 0x0000000194944812ULL, 0x000fe400078efcffULL,
0x0000009800897306ULL, 0x000fec0000209400ULL, 0x0000000190905812ULL, 0x002fe400078efcffULL,
0x00000098009a7306ULL, 0x000e620000205400ULL, 0x000000016d6d6812ULL, 0x008fce00078efcffULL,
0x0000008d00917306ULL, 0x000eb0000020d400ULL, 0x0000006f009b7306ULL, 0x000fe20000009400ULL,
0x0000009a8900720bULL, 0x002fce0003fdd000ULL, 0x0000006f00a27306ULL, 0x000e620000005400ULL,
0x0000000191913812ULL, 0x004fce00078efcffULL, 0x00000098009c7306ULL, 0x000eb0000020d400ULL,
0x0000006e00957306ULL, 0x000fe20000009400ULL, 0x000000a29b00720bULL, 0x002fce0003f7d000ULL,
0x0000006e00967306ULL, 0x000e620000005400ULL, 0x000000019c9c6812ULL, 0x004fe400078efcffULL,
0x0000009e9900720bULL, 0x000fca0003fdd000ULL, 0x0000006e00977306ULL, 0x0004f0000000d400ULL,
0x0000006f007c7306ULL, 0x000ee2000000d400ULL, 0x000100006e6e7824ULL, 0x004fe200078e00ffULL,
0x000000969500720bULL, 0x002fc40003fbd000ULL, 0x00000001a0a06812ULL, 0x000fe400078efcffULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x0000009d009f7306ULL, 0x000fee0000209400ULL,
0x0000000197975812ULL, 0x008fe200078efcffULL, 0x0000009d00a47306ULL, 0x000e620000205400ULL,
0x000000017c7c3812ULL, 0x000fc400078efcffULL, 0x000000979c9c723eULL, 0x000fca00000010ffULL,
0x0000009d00a17306ULL, 0x000eb0000020d400ULL, 0x000000ab009d7306ULL, 0x000fe20000209400ULL,
0x000000a49f00720bULL, 0x002fce0003f1d000ULL, 0x000000ab00ac7306ULL, 0x000e6c0000205400ULL,
0x00000001a1a10812ULL, 0x004fe400078efcffULL, 0x0000006e006c7306ULL, 0x000fe20000209400ULL,
0x000000a8a700720bULL, 0x000fce0003f1d000ULL, 0x0000006e008d7306ULL, 0x000ea20000205400ULL,
0x000000ac9d00720bULL, 0x002fe40003f7d000ULL, 0x0000007ca19d723eULL, 0x000fc600000010ffULL,
0x0000000123230812ULL, 0x000fe400078efcffULL, 0x000000a300987306ULL, 0x000fe40000209400ULL,
0x0000009c2834723cULL, 0x080b6c0000041834ULL, 0x000000a300a57306ULL, 0x000e620000205400ULL,
0x0000008d6c00720bULL, 0x004fe20003f9d000ULL, 0x0000009c0c54723cULL, 0x000b620000041854ULL,
0x0000006d8a6c723eULL, 0x000fc400000010ffULL, 0x00000091946d723eULL, 0x000fc600000010ffULL,
0x000000b100b37306ULL, 0x000fe80000209400ULL, 0x0000006c2830723cULL, 0x000b680000041830ULL,
0x000000b100b67306ULL, 0x000ea20000205400ULL, 0x000000a59800720bULL, 0x002fc60003fbd000ULL,
0x0000006c0c50723cULL, 0x000b680000041850ULL, 0x0000007000a97306ULL, 0x000ff00000009400ULL,
0x0000007000aa7306ULL, 0x000fe20000005400ULL, 0x000000b6b300720bULL, 0x004fce0003fdd000ULL,
0x0000007000217306ULL, 0x0003f0000000d400ULL, 0x0000007100af7306ULL, 0x000fe20000009400ULL,
0x0001000070707824ULL, 0x002fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000007100b47306ULL, 0x000ff00000005400ULL, 0x0000007100177306ULL, 0x0003f0000000d400ULL,
0x0000006e006f7306ULL, 0x000ea2000020d400ULL, 0x0001000071717824ULL, 0x002fca00078e00ffULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x000000a300a67306ULL, 0x000e70000020d400ULL,
0x000000ab00ae7306ULL, 0x000ee2000020d400ULL, 0x000000016f6f4812ULL, 0x004fc400078efcffULL,
0x000000aaa900720bULL, 0x000fe40003f9d000ULL, 0x0000006fa0a0723eULL, 0x000fc600000010ffULL,
0x00000070006e7306ULL, 0x000fe20000209400ULL, 0x00000001a6a65812ULL, 0x002fe400078efcffULL,
0x000000b4af00720bULL, 0x000fe40003fbd000ULL, 0x000000a623a1723eULL, 0x000fc600000010ffULL,
0x0000007000a37306ULL, 0x000e620000205400ULL, 0x00000001aeae3812ULL, 0x008fe400078efcffULL,
0x0000000121214812ULL, 0x000fe200078efcffULL, 0x000000a02838723cULL, 0x080b620000041838ULL,
0x000000b2ad00720bULL, 0x000fe40003f9d000ULL, 0x00000021aeae723eULL, 0x000fe200000010ffULL,
0x000000b100b87306ULL, 0x000ea2000020d400ULL, 0x0000000117175812ULL, 0x000fe400078efcffULL,
0x000000bcb500720bULL, 0x000fe20003fbd000ULL, 0x000000a00c58723cULL, 0x000b680000041858ULL,
0x0000007100ab7306ULL, 0x000fe20000209400ULL, 0x000000a36e00720bULL, 0x002fc40003f7d000ULL,
0x0000000119194812ULL, 0x000fca00078efcffULL, 0x0000007100ba7306ULL, 0x000e620000205400ULL,
0x00000001b8b86812ULL, 0x004fe400078efcffULL, 0x0000000112125812ULL, 0x000fe400078efcffULL,
0x000000797400720bULL, 0x000fe40003fbd000ULL, 0x00000017b8af723eULL, 0x000fe200000010ffULL,
0x0000007000b07306ULL, 0x000eac000020d400ULL, 0x000000ae283c723cULL, 0x000b64000004183cULL,
0x0000002700707306ULL, 0x000fe20000209400ULL, 0x000000baab00720bULL, 0x002fc40003fdd000ULL,
0x0000000111115812ULL, 0x000fc600078efcffULL, 0x000000ae0c5c723cULL, 0x000b64000004185cULL,
0x00000027007f7306ULL, 0x000e620000205400ULL, 0x00000001b0b03812ULL, 0x004fc800078efcffULL,
0x000000b019b0723eULL, 0x000fc600000010ffULL, 0x0000007100b17306ULL, 0x000eb0000020d400ULL,
0x0000007200b77306ULL, 0x000fe20000009400ULL, 0x0000007f7000720bULL, 0x002fce0003f7d000ULL,
0x0000007200be7306ULL, 0x000e620000005400ULL, 0x00000001b1b16812ULL, 0x004fc800078efcffULL,
0x000000b112b1723eULL, 0x000fc600000010ffULL, 0x00000026007e7306ULL, 0x000fe80000209400ULL,
0x000000b02840723cULL, 0x000b680000041840ULL, 0x0000002600817306ULL, 0x000ea20000205400ULL,
0x000000beb700720bULL, 0x002fc60003f1d000ULL, 0x000000b00c60723cULL, 0x000b680000041860ULL,
0x0000007200107306ULL, 0x0002f0000000d400ULL, 0x0000002600837306ULL, 0x0006e2000020d400ULL,
0x0001000072727824ULL, 0x002fe200078e00ffULL, 0x000000817e00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000007300787306ULL, 0x000fe20000009400ULL,
0x0000007d8426723eULL, 0x008fe400000010ffULL, 0x0000000110100812ULL, 0x000fca00078efcffULL,
0x00000073007b7306ULL, 0x000e620000005400ULL, 0x0000000183836812ULL, 0x000fce00078efcffULL,
0x00000073000a7306ULL, 0x000eb0000000d400ULL, 0x0000002700717306ULL, 0x0006a2000020d400ULL,
0x0000007b7800720bULL, 0x002fce0003f9d000ULL, 0x0000007200737306ULL, 0x000fe20000209400ULL,
0x000000879027723eULL, 0x008fca00000010ffULL, 0x000000010a0a4812ULL, 0x004fe400078efcffULL,
0x00000072006e7306ULL, 0x000e620000205400ULL, 0x0000000171713812ULL, 0x000fe200078efcffULL,
0x00000026282c723cULL, 0x000b62000004182cULL, 0x000000257a00720bULL, 0x000fe40003f7d000ULL,
0x0000000a836f723eULL, 0x000fc600000010ffULL, 0x00000082007d7306ULL, 0x000fe40000209400ULL,
0x000000260c4c723cULL, 0x000b6c000004184cULL, 0x0000008200707306ULL, 0x000ea20000205400ULL,
0x0000006e7300720bULL, 0x002fe40003f1d000ULL, 0x000000010b0b3812ULL, 0x000fc400078efcffULL,
0x00000010716e723eULL, 0x000fc600000010ffULL, 0x0000007200727306ULL, 0x000e68000020d400ULL,
0x0000006e2844723cULL, 0x000b680000041844ULL, 0x0000008200827306ULL, 0x000ee2000020d400ULL,
0x000000707d00720bULL, 0x004fc60003fdd000ULL, 0x0000006e0c64723cULL, 0x000b620000041864ULL,
0x0000000172720812ULL, 0x002fc800078efcffULL, 0x00000072110a723eULL, 0x000fca00000010ffULL,
0x0000000182826812ULL, 0x008fc800078efcffULL, 0x000000820b0b723eULL, 0x000fce00000010ffULL,
0x0000000a2848723cULL, 0x080b700000041848ULL, 0x0000000a0c68723cULL, 0x000b620000041868ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x000000001a0a7f8cULL, 0x0202a2000c80043fULL,
0x000000011b1b7810ULL, 0x000fc40007ffe0ffULL, 0x0001a6a01c0c7811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000cff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff0e7224ULL, 0x004fe200078e000bULL, 0x0000001000002944ULL, 0x000fe20003c00000ULL,
0xffff154000007947ULL, 0x000fea000383ffffULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0180000022007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0001086000067802ULL, 0x000fc40000000f00ULL, 0x0000dcd000007944ULL, 0x01efea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002200057308ULL, 0x000ee40000001000ULL,
0xbf80000005007423ULL, 0x008fc80000000022ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000005007223ULL, 0x000fc40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006f00ff057624ULL, 0x000fe400078e00ffULL, 0x00006e00ff047624ULL, 0x000fca00078e00ffULL,
0x0000000604057981ULL, 0x008ee8000c1e9900ULL, 0x0000000000067919ULL, 0x000ea80000000000ULL,
0x00000000000b7919ULL, 0x002e620000000000ULL, 0x00000002ff0a7819ULL, 0x004fe40000011606ULL,
0x000000180b087811ULL, 0x002fc400078ff0ffULL, 0x000000080b067811ULL, 0x040fe400078ff0ffULL,
0x000000100b0c7811ULL, 0x000fe200078ff0ffULL, 0x0000000005097220ULL, 0x008fca0000410000ULL,
0x00001f0a09007589ULL, 0x000e6800000e0000ULL, 0x00001f0809087589ULL, 0x000ea800000e0000ULL,
0x00001f0609067589ULL, 0x000ee800000e0000ULL, 0x00001f0c09047589ULL, 0x000ea200000e0000ULL,
0x0000002c002c7220ULL, 0x002fc40000410000ULL, 0x0000002d002d7220ULL, 0x040fe40000410000ULL,
0x0000003000307220ULL, 0x040fe40000410000ULL, 0x0000003100317220ULL, 0x040fe40000410000ULL,
0x0000003400347220ULL, 0x040fe40000410000ULL, 0x0000003500357220ULL, 0x040fe40000410000ULL,
0x0000003800387220ULL, 0x000fc40000410000ULL, 0x0000003900397220ULL, 0x040fe40000410000ULL,
0x0000003c003c7220ULL, 0x040fe40000410000ULL, 0x0000003d003d7220ULL, 0x040fe40000410000ULL,
0x0000004000407220ULL, 0x040fe40000410000ULL, 0x0000004100417220ULL, 0x040fe40000410000ULL,
0x0000004400447220ULL, 0x000fc40000410000ULL, 0x0000004500457220ULL, 0x040fe40000410000ULL,
0x0000004800487220ULL, 0x040fe40000410000ULL, 0x0000004900497220ULL, 0x000fe40000410000ULL,
0x0000004e084e7220ULL, 0x044fe40000410000ULL, 0x0000004f084f7220ULL, 0x040fe40000410000ULL,
0x0000005208527220ULL, 0x000fc40000410000ULL, 0x0000005308537220ULL, 0x040fe40000410000ULL,
0x0000005608567220ULL, 0x040fe40000410000ULL, 0x0000005708577220ULL, 0x040fe40000410000ULL,
0x0000005a085a7220ULL, 0x040fe40000410000ULL, 0x0000005b085b7220ULL, 0x040fe40000410000ULL,
0x0000005e085e7220ULL, 0x000fc40000410000ULL, 0x0000005f085f7220ULL, 0x040fe40000410000ULL,
0x0000006208627220ULL, 0x040fe40000410000ULL, 0x0000006308637220ULL, 0x040fe40000410000ULL,
0x0000006608667220ULL, 0x040fe40000410000ULL, 0x0000006708677220ULL, 0x040fe40000410000ULL,
0x0000006a086a7220ULL, 0x000fc40000410000ULL, 0x0000006b086b7220ULL, 0x000fe40000410000ULL,
0x000000062e2e7220ULL, 0x088fe40000410000ULL, 0x000000062f2f7220ULL, 0x080fe40000410000ULL,
0x0000000632327220ULL, 0x080fe40000410000ULL, 0x0000000633337220ULL, 0x080fe40000410000ULL,
0x0000000636367220ULL, 0x000fc40000410000ULL, 0x0000000637377220ULL, 0x080fe40000410000ULL,
0x000000063a3a7220ULL, 0x080fe40000410000ULL, 0x000000063b3b7220ULL, 0x080fe40000410000ULL,
0x000000063e3e7220ULL, 0x080fe40000410000ULL, 0x000000063f3f7220ULL, 0x080fe40000410000ULL,
0x0000000642427220ULL, 0x000fc40000410000ULL, 0x0000000643437220ULL, 0x080fe40000410000ULL,
0x0000000646467220ULL, 0x080fe40000410000ULL, 0x0000000647477220ULL, 0x080fe40000410000ULL,
0x000000064a4a7220ULL, 0x080fe40000410000ULL, 0x000000064b4b7220ULL, 0x000fe40000410000ULL,
0x000000044c4c7220ULL, 0x000fc40000410000ULL, 0x000000044d4d7220ULL, 0x080fe40000410000ULL,
0x0000000450507220ULL, 0x080fe40000410000ULL, 0x0000000451517220ULL, 0x080fe40000410000ULL,
0x0000000454547220ULL, 0x080fe40000410000ULL, 0x0000000455557220ULL, 0x080fe40000410000ULL,
0x0000000458587220ULL, 0x000fc40000410000ULL, 0x0000000459597220ULL, 0x080fe40000410000ULL,
0x000000045c5c7220ULL, 0x080fe40000410000ULL, 0x000000045d5d7220ULL, 0x080fe40000410000ULL,
0x0000000460607220ULL, 0x080fe40000410000ULL, 0x0000000461617220ULL, 0x080fe40000410000ULL,
0x0000000464647220ULL, 0x000fc40000410000ULL, 0x0000000465657220ULL, 0x080fe40000410000ULL,
0x0000000468687220ULL, 0x080fe40000410000ULL, 0x0000000469697220ULL, 0x000fc40000410000ULL,
0x0000000000057919ULL, 0x000ee20000000000ULL, 0x0000002e2f2e723eULL, 0x000fe400000010ffULL,
0x000000323317723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000363736723eULL, 0x000fc400000010ffULL, 0x0000003a3b1b723eULL, 0x000fe400000010ffULL,
0x0000003e3f3e723eULL, 0x000fe400000010ffULL, 0x000000424342723eULL, 0x000fe400000010ffULL,
0x00005410361a7816ULL, 0x142fe4000000001bULL, 0x00007632361b7816ULL, 0x000fe4000000001bULL,
0x000000464746723eULL, 0x000fc400000010ffULL, 0x0000000205007812ULL, 0x048fe400078ec0ffULL,
0x0000000805097811ULL, 0x040fe400078ff0ffULL, 0x00000010050b7811ULL, 0x000fe400078ff0ffULL,
0x0000000900047211ULL, 0x040fe200078ff8ffULL, 0x0000000809097824ULL, 0x000fe200078e00ffULL,
0x00000018050d7811ULL, 0x004fe200078ff0ffULL, 0x000000080b0f7824ULL, 0x000fe200078e00ffULL,
0x0000000b00067211ULL, 0x000fc400078ff8ffULL, 0xfffffff8090c7812ULL, 0x000fe400078ee204ULL,
0x00000002ff097819ULL, 0x000fe40000011605ULL, 0x0000000d00087211ULL, 0x040fe200078ff8ffULL,
0x000000080d0d7824ULL, 0x000fe200078e00ffULL, 0x0000000900047211ULL, 0x000fe200078ff8ffULL,
0x00000008090b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f147812ULL, 0x000fe200078ee206ULL,
0x0000200002067824ULL, 0x000fe200078e00ffULL, 0x0000000204007810ULL, 0x000fe20007ffe0ffULL,
0x0000000809107824ULL, 0x000fe200078e00ffULL, 0xfffffff80d167812ULL, 0x000fe200078ee208ULL,
0x00000008090d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0a7812ULL, 0x000fc400078ee200ULL,
0x0000200006007812ULL, 0x000fe400078ee2ffULL, 0xfffffff80b067812ULL, 0x000fe400078ee204ULL,
0x0000000404087810ULL, 0x040fe20007ffe0ffULL, 0x000010001f097824ULL, 0x000fe200078e0200ULL,
0x00000006040b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000805047824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0e7812ULL, 0x000fe200078ee208ULL, 0x0000001006087824ULL, 0x000fe200078e0209ULL,
0xfffffff810107812ULL, 0x000fe200078ee20bULL, 0x000000100c127824ULL, 0x100fe200078e0209ULL,
0x00000008040b7812ULL, 0x000fe200078ec0ffULL, 0x000000100a0c7824ULL, 0x100fe200078e0209ULL,
0x0000002c2d04723eULL, 0x000fe200000010ffULL, 0x0000001014147824ULL, 0x000fe200078e0209ULL,
0x000000303106723eULL, 0x000fe200000010ffULL, 0x00000001080a7824ULL, 0x000fe200078e020bULL,
0x0000003c3d08723eULL, 0x000fe200000010ffULL, 0x0000001016167824ULL, 0x100fe200078e0209ULL,
0x0000541004187816ULL, 0x100fe20000000006ULL, 0x000000100e0e7824ULL, 0x100fe200078e0209ULL,
0x0000763204197816ULL, 0x000fe20000000006ULL, 0x0000001010107824ULL, 0x000fe200078e0209ULL,
0x000000343504723eULL, 0x000fe200000010ffULL, 0x000000010b0c7824ULL, 0x000fe200078e020cULL,
0x000000383906723eULL, 0x000fe200000010ffULL, 0x000000180a007388ULL, 0x0003e20000000a00ULL,
0x000000010b127824ULL, 0x000fe200078e0212ULL, 0x000000404109723eULL, 0x000fe200000010ffULL,
0x000000010b147824ULL, 0x000fe200078e0214ULL, 0x0000004a4b23723eULL, 0x000fe200000010ffULL,
0x000000010b167824ULL, 0x000fe200078e0216ULL, 0x0000004c4d4c723eULL, 0x000fe200000010ffULL,
0x000000010b0e7824ULL, 0x000fe200078e020eULL, 0x000000505126723eULL, 0x000fe200000010ffULL,
0x000000010b107824ULL, 0x000fe200078e0210ULL, 0x00000048490b723eULL, 0x000fc400000010ffULL,
0x0000541004187816ULL, 0x142fe40000000006ULL, 0x0000763204197816ULL, 0x000fe40000000006ULL,
0x00000044450a723eULL, 0x000fe400000010ffULL, 0x000000545554723eULL, 0x000fe200000010ffULL,
0x000000180c007388ULL, 0x0003e20000000a00ULL, 0x00000058592a723eULL, 0x000fe400000010ffULL,
0x0000541046227816ULL, 0x000fc40000000023ULL, 0x0000763246237816ULL, 0x000fe40000000023ULL,
0x0000005c5d5c723eULL, 0x000fe400000010ffULL, 0x000000606160723eULL, 0x000fe400000010ffULL,
0x000000646564723eULL, 0x000fe400000010ffULL, 0x0000541008187816ULL, 0x142fe40000000009ULL,
0x0000763208197816ULL, 0x000fc40000000009ULL, 0x000054100a087816ULL, 0x140fe4000000000bULL,
0x000076320a097816ULL, 0x000fe2000000000bULL, 0x000000180e007388ULL, 0x000fe20000000a00ULL,
0x00005410540a7816ULL, 0x140fe4000000002aULL, 0x00007632540b7816ULL, 0x000fe2000000002aULL,
0x0000000810007388ULL, 0x0003e20000000a00ULL, 0x000000686932723eULL, 0x000fe400000010ffULL,
0x0000004e4f04723eULL, 0x000fc400000010ffULL, 0x000000525306723eULL, 0x000fe400000010ffULL,
0x000054102e087816ULL, 0x142fe40000000017ULL, 0x000076322e097816ULL, 0x000fca0000000017ULL,
0x0000000812007388ULL, 0x0003e80000000a00ULL, 0x0004001a0c007388ULL, 0x000fe20000000a00ULL,
0x000054103e087816ULL, 0x142fe40000000042ULL, 0x000076323e097816ULL, 0x000fca0000000042ULL,
0x000400080e007388ULL, 0x0003e80000000a00ULL, 0x0004002210007388ULL, 0x000fe20000000a00ULL,
0x000054104c087816ULL, 0x142fe40000000026ULL, 0x000076324c097816ULL, 0x000fca0000000026ULL,
0x0000000814007388ULL, 0x0003e80000000a00ULL, 0x0008000a0c007388ULL, 0x0005e20000000a00ULL,
0x000000565708723eULL, 0x002fe400000010ffULL, 0x0000005a5b09723eULL, 0x000fe400000010ffULL,
0x000054105c0a7816ULL, 0x144fe40000000060ULL, 0x000076325c0b7816ULL, 0x000fc40000000060ULL,
0x0000541008127816ULL, 0x140fe40000000009ULL, 0x0000763208137816ULL, 0x000fe20000000009ULL,
0x0008000a0e007388ULL, 0x0003e20000000a00ULL, 0x000000666708723eULL, 0x000fe400000010ffULL,
0x0000006a6b09723eULL, 0x000fe400000010ffULL, 0x00005410640a7816ULL, 0x142fe40000000032ULL,
0x00007632640b7816ULL, 0x000fca0000000032ULL, 0x0008000a10007388ULL, 0x0003e40000000a00ULL,
0x00005410040a7816ULL, 0x142fe40000000006ULL, 0x00007632040b7816ULL, 0x000fe40000000006ULL,
0x0000005e5f04723eULL, 0x000fe400000010ffULL, 0x000000626306723eULL, 0x000fe200000010ffULL,
0x0000000a16007388ULL, 0x0003e60000000a00ULL, 0x00007632040d7816ULL, 0x100fe20000000006ULL,
0x000c00120c007388ULL, 0x0005e20000000a00ULL, 0x00000001800b7824ULL, 0x002fe200078e0205ULL,
0x00005410040c7816ULL, 0x004fc60000000006ULL, 0x000000100b0b7824ULL, 0x000fe200078e0200ULL,
0x0000541008127816ULL, 0x140fe20000000009ULL, 0x000000ff00047306ULL, 0x000fe20000205400ULL,
0x0000763208137816ULL, 0x000fe20000000009ULL, 0x000c000c0e007388ULL, 0x000fe80000000a00ULL,
0x000c001210007388ULL, 0x000fe40000000a00ULL, 0x000000ff00097306ULL, 0x000e640000209400ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000b147984ULL, 0x000ea20000000c00ULL,
0x000000ff00067306ULL, 0x000ee6000020d400ULL, 0x000400000b0c7984ULL, 0x000ea80000000c00ULL,
0x000800000b247984ULL, 0x010ea20000000c00ULL, 0x000000040900720bULL, 0x002fc60003f1d000ULL,
0x000c00000b107984ULL, 0x000e680000000c00ULL, 0x001000000b187984ULL, 0x000e680000000c00ULL,
0x001400000b207984ULL, 0x000e640000000c00ULL, 0x0000000106060812ULL, 0x008fc400078efcffULL,
0x001800000b287984ULL, 0x000ee20000000c00ULL, 0x000000ff1f00720cULL, 0x000fe40003f05270ULL,
0x000000060606723eULL, 0x000fe200000010ffULL, 0x001c00000b2c7984ULL, 0x000ee80000000c00ULL,
0x3f803f8006177831ULL, 0x044fe40000200017ULL, 0x3f803f8006167831ULL, 0x000fc40000200016ULL,
0x3f803f8006157831ULL, 0x040fe40000200015ULL, 0x3f803f8006147831ULL, 0x040fe40000200014ULL,
0x3f803f80060f7831ULL, 0x040fe4000020000fULL, 0x3f803f80060e7831ULL, 0x040fe4000020000eULL,
0x3f803f80060d7831ULL, 0x040fe4000020000dULL, 0x3f803f80060c7831ULL, 0x000fc4000020000cULL,
0x3f803f8006277831ULL, 0x040fe40000200027ULL, 0x3f803f8006267831ULL, 0x040fe40000200026ULL,
0x3f803f8006257831ULL, 0x040fe40000200025ULL, 0x3f803f8006247831ULL, 0x040fe40000200024ULL,
0x3f803f8006137831ULL, 0x042fe40000200013ULL, 0x3f803f8006127831ULL, 0x000fc40000200012ULL,
0x3f803f8006117831ULL, 0x040fe40000200011ULL, 0x3f803f8006107831ULL, 0x000fe40000200010ULL,
0x3f803f8017177831ULL, 0x000fe4000020001bULL, 0x3f803f8016167831ULL, 0x000fe4000020001aULL,
0x3f803f8015157831ULL, 0x000fe40000200019ULL, 0x3f803f8014147831ULL, 0x000fc40000200018ULL,
0x3f803f800f0f7831ULL, 0x000fe40000200023ULL, 0x3f803f800e0e7831ULL, 0x000fe20000200022ULL,
0x000000140b007388ULL, 0x000fe20000000c00ULL, 0x3f803f800d0d7831ULL, 0x000fe40000200021ULL,
0x3f803f800c0c7831ULL, 0x000fe40000200020ULL, 0x3f803f8027277831ULL, 0x008fe4000020002bULL,
0x3f803f8026267831ULL, 0x000fe2000020002aULL, 0x0004000c0b007388ULL, 0x000fe20000000c00ULL,
0x3f803f8025257831ULL, 0x000fc40000200029ULL, 0x3f803f8024247831ULL, 0x000fe40000200028ULL,
0x3f803f8013137831ULL, 0x000fe4000020002fULL, 0x3f803f8012127831ULL, 0x000fe2000020002eULL,
0x000800240b007388ULL, 0x000fe20000000c00ULL, 0x3f803f8011117831ULL, 0x000fe4000020002dULL,
0x3f803f8010107831ULL, 0x000fca000020002cULL, 0x000c00100b007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff067819ULL, 0x000fc80000011605ULL, 0x000000760600720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a00000a7b06ULL, 0x000e620000209000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x00005a00ff197a12ULL, 0x000fe200078e33ffULL,
0x0000000103047824ULL, 0x000fe200078e0206ULL, 0x0000000102157812ULL, 0x000fe200078ec0ffULL,
0x0000000106067824ULL, 0x000fe200078e0205ULL, 0x0000002005027810ULL, 0x000fc80007ffe0ffULL,
0x0000000706067812ULL, 0x000fe400078ec0ffULL, 0x00000003ff117819ULL, 0x000fe20000011602ULL,
0x0000000a000a7308ULL, 0x002e640000001000ULL, 0x0ffffffe0a0b7810ULL, 0x002fcc0007ffe0ffULL,
0x0000000b00097305ULL, 0x000e64000021f000ULL, 0x000000ffff0d7224ULL, 0x002fc800078e0a09ULL,
0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL, 0x0000000d09177227ULL, 0x000fcc00078e0008ULL,
0x0000000417087227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a08ULL,
0x00005a0009097a24ULL, 0x000fca00078e0204ULL, 0x00005a0009007a0cULL, 0x000fda0003f06070ULL,
0x80005a0009090a10ULL, 0x000fe40007ffe0ffULL, 0x0000000108080810ULL, 0x000fe40007ffe0ffULL,
0x00005a0009007a0cULL, 0x000fe40003f26070ULL, 0x0ffffff806097812ULL, 0x000fe400078ef805ULL,
0x00005a00ff007a0cULL, 0x000fc60003f05070ULL, 0x0000001009067824ULL, 0x000fca00078e0200ULL,
0x00000000060c7984ULL, 0x0002a20000000c00ULL, 0x0000000108081810ULL, 0x000fc80007ffe0ffULL,
0x0000000819087207ULL, 0x000fe40004000000ULL, 0x0000000705067812ULL, 0x002fc600078ec0ffULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a08ULL, 0x0000590008097a24ULL, 0x000fe400078e0207ULL,
0x00005a000b047a24ULL, 0x000fe400078e0204ULL, 0x00000008150b7824ULL, 0x000fe400078e0206ULL,
0x00005a0009047a24ULL, 0x000fca00078e0204ULL, 0x0000000477047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00005e0004087a11ULL, 0x000fc800078240ffULL,
0x00005f0004097a11ULL, 0x000fe400008f4409ULL, 0x000000761100720cULL, 0x000fc60003f26070ULL,
0x000000100b087825ULL, 0x000fca00078e0008ULL, 0x0000000c08007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000103047824ULL, 0x100fe400078e0211ULL,
0x0000000102117824ULL, 0x000fe400078e0211ULL, 0x0000000417067227ULL, 0x000fc600078e00ffULL,
0x0000000711117812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x002fc600078e0a06ULL,
0x0ffffff811117812ULL, 0x000fe200078ef802ULL, 0x00005a0009087a24ULL, 0x000fe200078e0204ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001011117824ULL, 0x000fe200078e0200ULL,
0x00005a0008007a0cULL, 0x000fca0003f26070ULL, 0x0000000011107984ULL, 0x000e700000000c00ULL,
0x80005a0008081a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fc40007ffe0ffULL,
0x00005a0008007a0cULL, 0x000fda0003f46070ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000619067207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a06ULL,
0x0000590006097a24ULL, 0x000fe400078e0207ULL, 0x00005a000b047a24ULL, 0x000fe400078e0204ULL,
0x00000008150b7824ULL, 0x000fe400078e0202ULL, 0x00005a0009047a24ULL, 0x000fca00078e0204ULL,
0x0000000477067210ULL, 0x000fe40007f3e0ffULL, 0x0000004005047810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00005e0006087a11ULL, 0x040fe400078240ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011604ULL, 0x00005f0006097a11ULL, 0x000fe400008f4409ULL,
0x000000760d00720cULL, 0x000fc60003f26070ULL, 0x000000100b087825ULL, 0x000fca00078e0008ULL,
0x0000001008007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000103027824ULL, 0x100fe400078e020dULL, 0x00000001040d7824ULL, 0x000fe400078e020dULL,
0x0000000217067227ULL, 0x000fc600078e00ffULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x002fc600078e0a06ULL, 0x0ffffff80d0d7812ULL, 0x000fe200078ef804ULL,
0x00005a0009087a24ULL, 0x000fe200078e0202ULL, 0x0000000704047812ULL, 0x000fc600078ec0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0200ULL, 0x00005a0008007a0cULL, 0x000fca0003f26070ULL,
0x000000000d0c7984ULL, 0x000e700000000c00ULL, 0x80005a0008081a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fc40007ffe0ffULL, 0x00005a0008007a0cULL, 0x000fda0003f46070ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000619067207ULL, 0x000fca0004000000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a06ULL, 0x0000590006097a24ULL, 0x000fe400078e0207ULL,
0x00005a000b027a24ULL, 0x000fe400078e0202ULL, 0x00000008150b7824ULL, 0x000fe400078e0204ULL,
0x00005a0009027a24ULL, 0x000fca00078e0202ULL, 0x0000000277067210ULL, 0x000fe40007f3e0ffULL,
0x0000006005027810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x00005e0006087a11ULL, 0x040fe400078240ffULL, 0x00000003ff117819ULL, 0x000fe40000011602ULL,
0x00005f0006097a11ULL, 0x000fe400008f4409ULL, 0x000000761100720cULL, 0x000fc60003f26070ULL,
0x000000100b087825ULL, 0x000fca00078e0008ULL, 0x0000000c08007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000103047824ULL, 0x100fe400078e0211ULL,
0x0000000102117824ULL, 0x000fe400078e0211ULL, 0x0000000417067227ULL, 0x000fc600078e00ffULL,
0x0000000711117812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x002fc600078e0a06ULL,
0x0ffffff811117812ULL, 0x000fe200078ef802ULL, 0x00005a0009087a24ULL, 0x000fe200078e0204ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001011117824ULL, 0x000fe200078e0200ULL,
0x00005a0008007a0cULL, 0x000fca0003f26070ULL, 0x0000000011107984ULL, 0x000e700000000c00ULL,
0x80005a0008081a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fc40007ffe0ffULL,
0x00005a0008007a0cULL, 0x000fda0003f46070ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000619067207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a06ULL,
0x0000590006097a24ULL, 0x000fe400078e0207ULL, 0x00005a000b047a24ULL, 0x000fe400078e0204ULL,
0x00000008150b7824ULL, 0x000fe400078e0202ULL, 0x00005a0009047a24ULL, 0x000fca00078e0204ULL,
0x0000000477067210ULL, 0x000fe40007f3e0ffULL, 0x0000008005047810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00005e0006087a11ULL, 0x040fe400078240ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011604ULL, 0x00005f0006097a11ULL, 0x000fe400008f4409ULL,
0x000000760d00720cULL, 0x000fc60003f26070ULL, 0x000000100b087825ULL, 0x000fca00078e0008ULL,
0x0000001008007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000103027824ULL, 0x100fe400078e020dULL, 0x00000001040d7824ULL, 0x000fe400078e020dULL,
0x0000000217067227ULL, 0x000fc600078e00ffULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x002fc600078e0a06ULL, 0x0ffffff80d0d7812ULL, 0x000fe200078ef804ULL,
0x00005a0009087a24ULL, 0x000fe200078e0202ULL, 0x0000000704047812ULL, 0x000fc600078ec0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0200ULL, 0x00005a0008007a0cULL, 0x000fca0003f26070ULL,
0x000000000d0c7984ULL, 0x000e700000000c00ULL, 0x80005a0008081a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fc40007ffe0ffULL, 0x00005a0008007a0cULL, 0x000fda0003f46070ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000619067207ULL, 0x000fca0004000000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a06ULL, 0x0000590006097a24ULL, 0x000fe400078e0207ULL,
0x00005a000b027a24ULL, 0x000fe400078e0202ULL, 0x00000008150b7824ULL, 0x000fe400078e0204ULL,
0x00005a0009027a24ULL, 0x000fca00078e0202ULL, 0x0000000277067210ULL, 0x000fe40007f3e0ffULL,
0x000000a005027810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x00005e0006087a11ULL, 0x040fe400078240ffULL, 0x00000003ff117819ULL, 0x000fe40000011602ULL,
0x00005f0006097a11ULL, 0x000fe400008f4409ULL, 0x000000761100720cULL, 0x000fc60003f26070ULL,
0x000000100b087825ULL, 0x000fca00078e0008ULL, 0x0000000c08007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000103047824ULL, 0x100fe400078e0211ULL,
0x0000000102117824ULL, 0x000fe400078e0211ULL, 0x0000000417067227ULL, 0x000fc600078e00ffULL,
0x0000000711117812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x002fc600078e0a06ULL,
0x0ffffff811117812ULL, 0x000fe200078ef802ULL, 0x00005a0009087a24ULL, 0x000fe200078e0204ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001011117824ULL, 0x000fe200078e0200ULL,
0x00005a0008007a0cULL, 0x000fca0003f26070ULL, 0x0000000011107984ULL, 0x000e700000000c00ULL,
0x80005a0008081a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fc40007ffe0ffULL,
0x00005a0008007a0cULL, 0x000fda0003f46070ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000619067207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a06ULL,
0x0000590006097a24ULL, 0x000fe200078e0207ULL, 0x000000c005067810ULL, 0x000fe20007ffe0ffULL,
0x00005a000b047a24ULL, 0x000fe400078e0204ULL, 0x00000008150b7824ULL, 0x000fe200078e0202ULL,
0x00000003ff0d7819ULL, 0x000fe20000011606ULL, 0x00005a0009047a24ULL, 0x000fca00078e0204ULL,
0x0000000477047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x00005e0004087a11ULL, 0x000fc800078240ffULL, 0x00005f0004097a11ULL, 0x000fe400008f4409ULL,
0x000000760d00720cULL, 0x000fc60003f26070ULL, 0x000000100b087825ULL, 0x000fca00078e0008ULL,
0x0000001008007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000103027824ULL, 0x100fe400078e020dULL, 0x00000001060d7824ULL, 0x000fe400078e020dULL,
0x0000000217047227ULL, 0x000fc600078e00ffULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x002fc600078e0a04ULL, 0x0ffffff80d0d7812ULL, 0x000fe200078ef806ULL,
0x00005a0009087a24ULL, 0x000fe200078e0202ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0200ULL, 0x00005a0008007a0cULL, 0x000fca0003f26070ULL,
0x000000000d0c7984ULL, 0x000e700000000c00ULL, 0x80005a0008081a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fc40007ffe0ffULL, 0x00005a0008007a0cULL, 0x000fe40003f46070ULL,
0x000000e005087810ULL, 0x000fd60007ffe0ffULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x0000000419047207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a04ULL,
0x0000590004097a24ULL, 0x000fe400078e0207ULL, 0x00005a000b027a24ULL, 0x000fe200078e0202ULL,
0x00000003ff0b7819ULL, 0x000fc60000011608ULL, 0x00005a0009027a24ULL, 0x000fe400078e0202ULL,
0x0000000103037824ULL, 0x000fc600078e020bULL, 0x0000000277027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00005e0002047a11ULL, 0x000fc800078240ffULL,
0x00005f0002057a11ULL, 0x000fe200008f4409ULL, 0x0000000815097824ULL, 0x000fe200078e0206ULL,
0x000000760b00720cULL, 0x000fc60003f26070ULL, 0x0000001009047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000317027227ULL, 0x000fc800078e00ffULL, 0x000000ffff047224ULL, 0x002fe400078e0a02ULL,
0x00000001080b7824ULL, 0x000fe400078e020bULL, 0x00005a0004047a24ULL, 0x000fc600078e0203ULL,
0x000000070b0b7812ULL, 0x000fe400078ec0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f26070ULL,
0xfffffff80b0b7812ULL, 0x000fe400078ef808ULL, 0x0000000708087812ULL, 0x000fc600078ec0ffULL,
0x000000100b0b7824ULL, 0x000fe400078e0200ULL, 0x0000000815057824ULL, 0x000fc600078e0208ULL,
0x000000000b0c7984ULL, 0x000e620000000c00ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000102021810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fda0003f46070ULL,
0x0000000102022810ULL, 0x000fc80007ffe0ffULL, 0x0000000219027207ULL, 0x000fca0004000000ULL,
0x000000ffff047224ULL, 0x000fe400078e0a02ULL, 0x0000590002007a24ULL, 0x000fe400078e0207ULL,
0x00005a0004037a24ULL, 0x000fc800078e0203ULL, 0x00005a0000007a24ULL, 0x000fca00078e0203ULL,
0x0000000077007210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005e0000027a11ULL, 0x000fc800078040ffULL, 0x00005f0000037a11ULL, 0x000fca00000f4403ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff107819ULL, 0x000fc80000011602ULL,
0x000000051000720cULL, 0x000fda0003f06070ULL, 0x00000002c20b8824ULL, 0x000fc800078e00ffULL,
0x00006a000b128a24ULL, 0x000fe400078e0210ULL, 0xffffffffff0b7424ULL, 0x000fe400078e00ffULL,
0x0000660012128625ULL, 0x000fe200078e0083ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006e00ff0e7624ULL, 0x000fe200078e00ffULL, 0x00000006120b8981ULL, 0x000ea2000c1e1900ULL,
0x00006f00ff0f7624ULL, 0x000fc600078e00ffULL, 0x01a60000ff0c7f8cULL, 0x000e68000c80043fULL,
0x000000060e0e7981ULL, 0x000722000c1e9900ULL, 0x000001ff1100780cULL, 0x000fe20003f04070ULL,
0x0000008007077824ULL, 0x000fe400078e00ffULL, 0x0000004002bc7824ULL, 0x000fe400078e00ffULL,
0x0000008017c07824ULL, 0x000fc600078e00ffULL, 0x0000004007117812ULL, 0x000fe200078ef8bcULL,
0x0000000bc0317224ULL, 0x004fc800078e02ffULL, 0x00000c9000000947ULL, 0x000fea0003800000ULL,
0x00000003ff387819ULL, 0x00afe40000011608ULL, 0x00006400312d7a11ULL, 0x000fe400078038ffULL,
0x0000000438147810ULL, 0x040fe20007ffe0ffULL, 0x0000000111127824ULL, 0x000fe200078e0238ULL,
0x0000001038187810ULL, 0x040fe40007ffe0ffULL, 0x0000000838167810ULL, 0x000fe20007ffe0ffULL,
0x00000001140b7824ULL, 0x040fe200078e0208ULL, 0x00006500312f7a11ULL, 0x000fe200000f3cffULL,
0x0000000814267824ULL, 0x000fe200078e00ffULL, 0x0000000c381a7810ULL, 0x000fe20007ffe0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000001438227810ULL, 0x000fc40007ffe0ffULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x0000000818157824ULL, 0x000fe200078e00ffULL,
0x000000bc040b7217ULL, 0x000fe20007800000ULL, 0x00000001160f7824ULL, 0x100fe200078e0208ULL,
0x00000070121c7812ULL, 0x000fe200078ef809ULL, 0x0000000118127824ULL, 0x000fe200078e0208ULL,
0x0000001c38327810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x000fe200078e0abcULL,
0x0000001c2d1c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000816287824ULL, 0x000fe200078e00ffULL,
0xfffffff8152c7812ULL, 0x000fe200078ee212ULL, 0x0000000111127824ULL, 0x040fe200078e0214ULL,
0x0000000b1400720cULL, 0x080fe20003fa6070ULL, 0x0000000111147824ULL, 0x000fe200078e0216ULL,
0xfffffff828287812ULL, 0x000fe200078ee20fULL, 0x00000001131d7824ULL, 0x000fe200000e062fULL,
0x0000000b1600720cULL, 0x080fe20003f26070ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000b1a00720cULL, 0x000fc40003f46070ULL, 0x0000000b1800720cULL, 0x000fe20003f06070ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x00000070121e7812ULL, 0x100fe400078ef809ULL,
0x0000002038347810ULL, 0x000fe20007ffe0ffULL, 0x000000011a0f7824ULL, 0x000fe200078e0208ULL,
0x0000007014207812ULL, 0x000fe200078ef809ULL, 0x000000081a2a7824ULL, 0x000fe200078e00ffULL,
0x0000001838147810ULL, 0x000fe20007ffe0ffULL, 0x0000000111167824ULL, 0x040fe200078e021aULL,
0x0000002d1e1e7210ULL, 0x080fe20007f7e0ffULL, 0x0000000111187824ULL, 0x040fe200078e0218ULL,
0x0000002d20207210ULL, 0x000fe20007f9e0ffULL, 0x00000001111a7824ULL, 0x000fe200078e0222ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee20fULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00002000020f7811ULL, 0x000fc400078e70ffULL, 0x0000002438367810ULL, 0x000fe20007ffe0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000007016167812ULL, 0x000fc600078ef809ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000007018187812ULL, 0x000fc600078ef809ULL,
0x0000000111127824ULL, 0x000fe200078e0214ULL, 0x000000701a1a7812ULL, 0x000fe200078ef809ULL,
0x00000001131f7824ULL, 0x100fe200018e062fULL, 0x0000002d16167210ULL, 0x080fe20007f7e0ffULL,
0x0000000115217824ULL, 0x000fe200020e062fULL, 0x0000002d18187210ULL, 0x080fe20007f9e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000002d1a1a7210ULL, 0x000fc60007fde0ffULL,
0x0000000138157824ULL, 0x100fe200078e0208ULL, 0x0000007012237812ULL, 0x000fe200078ef809ULL,
0x0000000117177824ULL, 0x100fe200018e062fULL, 0x0000000b2200720cULL, 0x080fe20003f66070ULL,
0x0000000119197824ULL, 0x100fe200020e062fULL, 0x0000000715157812ULL, 0x000fe200078ec0ffULL,
0x000000011b1b7824ULL, 0x000fe200030e062fULL, 0x0000000b3800720cULL, 0x000fe20003f86070ULL,
0x0000000122127824ULL, 0x140fe200078e0208ULL, 0x0ffffff815247812ULL, 0x000fe200078ef808ULL,
0x0000000822257824ULL, 0x000fe200078e00ffULL, 0x0000002d23227210ULL, 0x000fe20007fde0ffULL,
0x0000000111157824ULL, 0x000fc400078e0232ULL, 0x0000001024277824ULL, 0x000fe200078e020fULL,
0xfffffff8252e7812ULL, 0x000fe200078ee212ULL, 0x0000000113237824ULL, 0x000fe400030e062fULL,
0x0000008015127825ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c277faeULL, 0x0003e2000e101c46ULL, 0x0000000b1400720cULL, 0x000fe20003f86070ULL,
0x0000000111157824ULL, 0x000fe200078e0234ULL, 0x0000007012247812ULL, 0x000fe200078ef809ULL,
0x0000000114127824ULL, 0x000fc400078e0208ULL, 0x0000000814257824ULL, 0x000fe200078e00ffULL,
0x0000002d24247210ULL, 0x000fe20007fde0ffULL, 0x0000008015147825ULL, 0x000fc600078e00ffULL,
0xfffffff825307812ULL, 0x000fe200078ee212ULL, 0x0000000111297824ULL, 0x000fe200078e0236ULL,
0x0000007014147812ULL, 0x000fe200078ef809ULL, 0x0000001026277824ULL, 0x002fe400078e020fULL,
0x0000000113257824ULL, 0x000fe200030e062fULL, 0x0000002d14147210ULL, 0x000fe20007fde0ffULL,
0x0000008029127825ULL, 0x000fe200078e00ffULL, 0x000000001e277faeULL, 0x0003e2000e901c46ULL,
0x0000000b3200720cULL, 0x040fe40003fa6070ULL, 0x00000001321d7824ULL, 0x000fe200078e0208ULL,
0x00000070121c7812ULL, 0x000fe200078ef809ULL, 0x0000000832267824ULL, 0x000fe200078e00ffULL,
0x0000002838327810ULL, 0x000fe20007ffe0ffULL, 0x0000000115157824ULL, 0x000fe200030e062fULL,
0x0000002d1c1c7210ULL, 0x000fe20007fde0ffULL, 0x0000001028297824ULL, 0x000fe200078e020fULL,
0xfffffff826267812ULL, 0x000fe200078ee21dULL, 0x0000000111127824ULL, 0x000fc400078e0232ULL,
0x00000001131d7824ULL, 0x000fe200030e062fULL, 0x0000000020297faeULL, 0x0005e2000c901c46ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000b3400720cULL, 0x000fc60003f26070ULL,
0x00000001341f7824ULL, 0x102fe200078e0208ULL, 0x00000070121e7812ULL, 0x000fe200078ef809ULL,
0x0000000834347824ULL, 0x000fe400078e00ffULL, 0x000000102a277824ULL, 0x000fe200078e020fULL,
0x0000002d1e1e7210ULL, 0x000fe20007fde0ffULL, 0x0000000136287824ULL, 0x000fe200078e0208ULL,
0xfffffff834127812ULL, 0x000fe200078ee21fULL, 0x000000102c217824ULL, 0x004fe200078e020fULL,
0x0000002c38207810ULL, 0x000fe20007ffe0ffULL, 0x00000001131f7824ULL, 0x000fe200030e062fULL,
0x0000000016277faeULL, 0x0003e2000d101c46ULL, 0x000000102e137824ULL, 0x100fe200078e020fULL,
0x0000000b3600720cULL, 0x000fe20003f46070ULL, 0x0000001012297824ULL, 0x000fe200078e020fULL,
0x0000000018217faeULL, 0x0005e2000c101c46ULL, 0x0000000111127824ULL, 0x000fc400078e0220ULL,
0x00000008362b7824ULL, 0x000fe200078e00ffULL, 0x000000001a137faeULL, 0x0007e2000d901c46ULL,
0x0000001030177824ULL, 0x002fc600078e020fULL, 0xfffffff82b287812ULL, 0x000fe200078ee228ULL,
0x0000001026277824ULL, 0x100fe200078e020fULL, 0x0000003838267810ULL, 0x000fe20007ffe0ffULL,
0x0000000120197824ULL, 0x004fe200078e0208ULL, 0x0000003038187810ULL, 0x000fe20007ffe0ffULL,
0x0000000022177faeULL, 0x0003e2000e101c46ULL, 0x00000010282b7824ULL, 0x000fe200078e020fULL,
0x00000034381a7810ULL, 0x008fe20007ffe0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000024277faeULL, 0x0005e2000e901c46ULL, 0x0000003c38287810ULL, 0x000fc40007ffe0ffULL,
0x0000000b3200720cULL, 0x080fe20003fa6070ULL, 0x0000000014297faeULL, 0x0007e2000c901c46ULL,
0x0000007012167812ULL, 0x000fe200078ef809ULL, 0x0000000111127824ULL, 0x000fe200078e0218ULL,
0x0000000b2000720cULL, 0x000fe20003f86070ULL, 0x000000001c2b7faeULL, 0x0007e2000d101c46ULL,
0x0000002d16167210ULL, 0x000fe20007fde0ffULL, 0x0000000820207824ULL, 0x000fe200078e00ffULL,
0x0000000b1800720cULL, 0x080fe20003f66070ULL, 0x000000081a247824ULL, 0x044fe200078e00ffULL,
0x0000000b1a00720cULL, 0x080fe20003f46070ULL, 0x0000000113177824ULL, 0x002fe200030e062fULL,
0x0000000b2600720cULL, 0x080fe20003f26070ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000b2800720cULL, 0x000fc40003f06070ULL, 0xfffffff820207812ULL, 0x000fe200078ee219ULL,
0x0000000111147824ULL, 0x008fe200078e021aULL, 0x00000070121b7812ULL, 0x000fe200078ef809ULL,
0x0000000118127824ULL, 0x040fe400078e0208ULL, 0x00000008181d7824ULL, 0x000fe200078e00ffULL,
0x0000002d1b187210ULL, 0x000fe20007fde0ffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff81d227812ULL, 0x000fe200078ee212ULL, 0x00000001320b7824ULL, 0x000fe200078e0208ULL,
0x00000070141b7812ULL, 0x000fe200078ef809ULL, 0x00000008321c7824ULL, 0x000fe400078e00ffULL,
0x0000000111127824ULL, 0x000fe400078e0226ULL, 0x0000000113197824ULL, 0x000fe200030e062fULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL, 0x000000011a0b7824ULL, 0x000fe200078e0208ULL,
0x0000002d1b1a7210ULL, 0x000fe20007fde0ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20bULL, 0x0000000111147824ULL, 0x000fe200078e0228ULL,
0x0000007012127812ULL, 0x000fe200078ef809ULL, 0x00000001151b7824ULL, 0x000fe400030e062fULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x00000001260b7824ULL, 0x100fe400078e0208ULL,
0x0000000128117824ULL, 0x000fe200078e0208ULL, 0x0000002d12087210ULL, 0x080fe20007fde0ffULL,
0x0000000826267824ULL, 0x000fe200078e00ffULL, 0x0000007014127812ULL, 0x000fe200078ef809ULL,
0x0000000828287824ULL, 0x000fe400078e00ffULL, 0x0000000113097824ULL, 0x000fe200030e062fULL,
0xfffffff826147812ULL, 0x000fe200078ee20bULL, 0x000000101c0b7824ULL, 0x000fe200078e020fULL,
0xfffffff828267812ULL, 0x000fe200078ee211ULL, 0x0000001020117824ULL, 0x100fe200078e020fULL,
0x0000002d12127210ULL, 0x000fe20007fde0ffULL, 0x00000010221d7824ULL, 0x100fe200078e020fULL,
0x000000001e0b7faeULL, 0x0003e2000e901c46ULL, 0x0000001024217824ULL, 0x000fc400078e020fULL,
0x0000001014237824ULL, 0x100fe200078e020fULL, 0x0000000016117faeULL, 0x0003e2000e101c46ULL,
0x00000010260f7824ULL, 0x000fe400078e020fULL, 0x0000000115137824ULL, 0x000fe200030e062fULL,
0x00000000181d7faeULL, 0x0003e8000d901c46ULL, 0x000000001a217faeULL, 0x0003e8000d101c46ULL,
0x0000000008237faeULL, 0x0003e8000c901c46ULL, 0x00000000120f7faeULL, 0x0003e2000c101c46ULL,
0x00000b5000007947ULL, 0x000fea0003800000ULL, 0x00000004080f7811ULL, 0x04afe400078fe8ffULL,
0x00000010081a7811ULL, 0x000fc400078fe8ffULL, 0x0000000808137811ULL, 0x040fe200078fe8ffULL,
0x000000010f0b7824ULL, 0x140fe200078e0208ULL, 0x0000000c08187811ULL, 0x040fe200078fe8ffULL,
0x000000080f1c7824ULL, 0x000fe200078e00ffULL, 0x0000002008227811ULL, 0x000fe200078fe8ffULL,
0x000000011a167824ULL, 0x100fe200078e0208ULL, 0x00000018081e7811ULL, 0x000fe200078fe8ffULL,
0x000000081a1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c157812ULL, 0x000fe200078ee20bULL,
0x0000000113127824ULL, 0x140fe200078e0208ULL, 0x00000014081c7811ULL, 0x040fe200078fe8ffULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0x0000001c08207811ULL, 0x000fe200078fe8ffULL,
0x0000000118147824ULL, 0x000fe200078e0208ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee216ULL,
0x000000011c0b7824ULL, 0x040fe200078e0208ULL, 0xfffffff817177812ULL, 0x000fe200078ee212ULL,
0x000000081c247824ULL, 0x000fe200078e00ffULL, 0x00000030082c7811ULL, 0x000fe200078fe8ffULL,
0x0000000818197824ULL, 0x000fe200078e00ffULL, 0x0000002808267811ULL, 0x000fe200078fe8ffULL,
0x0000000122167824ULL, 0x000fe200078e0208ULL, 0xfffffff8241d7812ULL, 0x000fe200078ee20bULL,
0x0000000822237824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee214ULL,
0x000000011e127824ULL, 0x100fe200078e0208ULL, 0x0000002408247811ULL, 0x000fe200078fe8ffULL,
0x000000081e1f7824ULL, 0x000fe200078e00ffULL, 0x0000002c08287811ULL, 0x000fe200078fe8ffULL,
0x0000000120147824ULL, 0x040fe200078e0208ULL, 0xfffffff823237812ULL, 0x000fe200078ee216ULL,
0x0000000820217824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee212ULL,
0x000000012c167824ULL, 0x000fe200078e0208ULL, 0x00000038082f7811ULL, 0x000fe200078fe8ffULL,
0x000000082c2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee214ULL,
0x00000001240b7824ULL, 0x000fe200078e0208ULL, 0x00000034082e7811ULL, 0x000fe200078fe8ffULL,
0x00000008242a7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee216ULL,
0x0000000126127824ULL, 0x100fe200078e0208ULL, 0x0000003c08307811ULL, 0x000fe200078fe8ffULL,
0x0000000826277824ULL, 0x000fe200078e00ffULL, 0xfffffff82a257812ULL, 0x000fe200078ee20bULL,
0x0000000128147824ULL, 0x000fe200078e0208ULL, 0x00000008080b7211ULL, 0x000fe200078fe8ffULL,
0x00000008282b7824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee212ULL,
0x0000000111167824ULL, 0x040fe200078e0213ULL, 0x0000001108127211ULL, 0x000fe200078fe8ffULL,
0x0000000111297824ULL, 0x000fe200078e0220ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee214ULL,
0x000000012f137824ULL, 0x100fe200078e0208ULL, 0x000000070b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000082f207824ULL, 0x000fe200078e00ffULL, 0x00006400314d7a11ULL, 0x000fe200078038ffULL,
0x0000000111147824ULL, 0x000fe200078e020fULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef808ULL,
0x00000001113a7824ULL, 0x000fe200078e022eULL, 0xfffffff820207812ULL, 0x000fe200078ee213ULL,
0x000000012e0f7824ULL, 0x000fe200078e0208ULL, 0x00006500314f7a11ULL, 0x000fe200000f3cffULL,
0x0000000111187824ULL, 0x000fc400078e0218ULL, 0x00000001111a7824ULL, 0x040fe400078e021aULL,
0x00000001111c7824ULL, 0x040fe400078e021cULL, 0x00000001111e7824ULL, 0x040fe400078e021eULL,
0x00000001112a7824ULL, 0x040fe400078e0222ULL, 0x0000000111327824ULL, 0x040fe200078e0224ULL,
0x0000200002247811ULL, 0x000fe200078e70ffULL, 0x0000000111347824ULL, 0x000fc400078e0226ULL,
0x0000000111367824ULL, 0x040fe400078e0228ULL, 0x0000000111387824ULL, 0x040fe400078e022cULL,
0x000000082e2e7824ULL, 0x000fe400078e00ffULL, 0x00000001113c7824ULL, 0x040fe400078e022fULL,
0x00000001113e7824ULL, 0x000fe400078e0230ULL, 0x0000000130117824ULL, 0x000fe200078e0208ULL,
0xfffffff82e087812ULL, 0x000fe200078ee20fULL, 0x0000000830227824ULL, 0x000fc400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee211ULL,
0x00000010150f7824ULL, 0x100fe400078e0224ULL, 0x0000001020497824ULL, 0x100fe200078e0224ULL,
0x0000007012207812ULL, 0x000fe200078ef809ULL, 0x0000001017117824ULL, 0x000fe400078e0224ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000204d207210ULL, 0x000fc60007f1e0ffULL,
0x0000001019337824ULL, 0x000fe400078e0224ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x00000010224b7824ULL, 0x100fe200078e0224ULL,
0x0000007014227812ULL, 0x100fe200078ef809ULL, 0x000000100b0b7824ULL, 0x100fe200078e0224ULL,
0x0000007018267812ULL, 0x000fe200078ef809ULL, 0x000000101b357824ULL, 0x100fe200078e0224ULL,
0x000000224d227210ULL, 0x000fe20007f3e0ffULL, 0x000000101d377824ULL, 0x100fe200078e0224ULL,
0x000000264d267210ULL, 0x000fe20007f5e0ffULL, 0x000000101f397824ULL, 0x100fe400078e0224ULL,
0x00000010213b7824ULL, 0x000fc400078e0224ULL, 0x00000010233d7824ULL, 0x100fe400078e0224ULL,
0x00000010253f7824ULL, 0x100fe400078e0224ULL, 0x0000001027417824ULL, 0x100fe400078e0224ULL,
0x000000102b437824ULL, 0x100fe400078e0224ULL, 0x000000102d457824ULL, 0x100fe400078e0224ULL,
0x0000001008477824ULL, 0x000fe200078e0224ULL, 0x0000007016247812ULL, 0x000fe200078ef809ULL,
0x000000801a1a7825ULL, 0x000fc800078e00ffULL, 0x0000000113217824ULL, 0x100fe200000e064fULL,
0x000000244d247210ULL, 0x000fe20007f1e0ffULL, 0x0000000115237824ULL, 0x000fe200008e064fULL,
0x000000701a287812ULL, 0x000fe200078ef809ULL, 0x000000801c127825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000200b7faeULL, 0x0003e6000b901c46ULL,
0x0000000117257824ULL, 0x100fe200000e064fULL, 0x000000284d287210ULL, 0x000fe20007f1e0ffULL,
0x000000801e147825ULL, 0x000fe200078e00ffULL, 0x00000000220f7faeULL, 0x0003e6000b901c46ULL,
0x0000000119277824ULL, 0x000fe200010e064fULL, 0x00000070142c7812ULL, 0x100fe200078ef809ULL,
0x0000008029167825ULL, 0x000fe200078e00ffULL, 0x0000000024117faeULL, 0x0003e4000b901c46ULL,
0x0000002c4d2c7210ULL, 0x000fe20007f3e0ffULL, 0x000000802a187825ULL, 0x000fe200078e00ffULL,
0x00000070122a7812ULL, 0x100fe200078ef809ULL, 0x0000000026337faeULL, 0x0003e2000b901c46ULL,
0x00000070162e7812ULL, 0x000fe200078ef809ULL, 0x000000011b297824ULL, 0x000fe200000e064fULL,
0x0000007018307812ULL, 0x000fe200078ef809ULL, 0x00000001152d7824ULL, 0x100fe200008e064fULL,
0x0000002a4d2a7210ULL, 0x040fe20007f1e0ffULL, 0x0000008034147825ULL, 0x000fe200078e00ffULL,
0x0000002e4d2e7210ULL, 0x040fe20007f5e0ffULL, 0x0000000028357faeULL, 0x0003e2000b901c46ULL,
0x000000304d307210ULL, 0x000fe20007f7e0ffULL, 0x00000001132b7824ULL, 0x000fc400000e064fULL,
0x0000008032127825ULL, 0x000fc600078e00ffULL, 0x000000002a377faeULL, 0x0003e2000b901c46ULL,
0x00000001172f7824ULL, 0x000fe200010e064fULL, 0x0000007012087812ULL, 0x000fe200078ef809ULL,
0x0000000119317824ULL, 0x000fe200018e064fULL, 0x0000007014127812ULL, 0x100fe200078ef809ULL,
0x0000008036167825ULL, 0x000fe200078e00ffULL, 0x000000084d087210ULL, 0x040fe20007f1e0ffULL,
0x000000002c397faeULL, 0x0003e2000b901c46ULL, 0x000000124d127210ULL, 0x040fe20007f3e0ffULL,
0x0000008038187825ULL, 0x000fe200078e00ffULL, 0x0000007016147812ULL, 0x100fe200078ef809ULL,
0x000000002e3b7faeULL, 0x0003e4000b901c46ULL, 0x000000803a1a7825ULL, 0x000fe200078e00ffULL,
0x0000007018167812ULL, 0x100fe200078ef809ULL, 0x00000000303d7faeULL, 0x0003e2000b901c46ULL,
0x000000144d147210ULL, 0x000fe20007f5e0ffULL, 0x000000803c1c7825ULL, 0x000fe200078e00ffULL,
0x000000701a187812ULL, 0x000fc400078ef809ULL, 0x000000164d167210ULL, 0x040fe20007f7e0ffULL,
0x000000803e1e7825ULL, 0x000fe200078e00ffULL, 0x000000701c1a7812ULL, 0x100fe400078ef809ULL,
0x000000184d187210ULL, 0x040fe40007f9e0ffULL, 0x000000701e097812ULL, 0x000fe400078ef809ULL,
0x0000001a4d1a7210ULL, 0x040fe40007fbe0ffULL, 0x000000094d1c7210ULL, 0x000fe20007fde0ffULL,
0x0000000113097824ULL, 0x000fc400000e064fULL, 0x0000000115137824ULL, 0x100fe400008e064fULL,
0x0000000117157824ULL, 0x100fe200010e064fULL, 0x00000000083f7faeULL, 0x0003e2000b901c46ULL,
0x0000000119177824ULL, 0x100fe400018e064fULL, 0x000000011b197824ULL, 0x100fe200020e064fULL,
0x0000000012417faeULL, 0x0003e2000b901c46ULL, 0x000000011d1b7824ULL, 0x100fe400028e064fULL,
0x000000011f1d7824ULL, 0x000fe200030e064fULL, 0x0000000014437faeULL, 0x0003e8000b901c46ULL,
0x0000000016457faeULL, 0x0003e8000b901c46ULL, 0x0000000018477faeULL, 0x0003e8000b901c46ULL,
0x000000001a497faeULL, 0x0003e8000b901c46ULL, 0x000000001c4b7faeULL, 0x0003e4000b901c46ULL,
0x0000000210087810ULL, 0x002fe20007ffe0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000050800720cULL, 0x000fda0003f06070ULL, 0x00000002c2098824ULL, 0x000fc800078e00ffULL,
0x00006a0009108a24ULL, 0x000fe400078e0208ULL, 0xffffffffff097424ULL, 0x000fe400078e00ffULL,
0x0000660010108625ULL, 0x000fca00078e0083ULL, 0x0000000610098981ULL, 0x000322000c1e1900ULL,
0x00005800ff0b7624ULL, 0x000fca00078e00ffULL, 0x0000001f0b0b7810ULL, 0x000fc80007ffe0ffULL,
0x00000005ff137819ULL, 0x000fc4000001160bULL, 0x0000000000107805ULL, 0x002fca0000015200ULL,
0x01a60400ff0b7984ULL, 0x000e620000000800ULL, 0x000000130a827224ULL, 0x000fe400078e02ffULL,
0x0000000104bb7824ULL, 0x000fe400078e0a00ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x800000000bff7812ULL, 0x002fe2000780480dULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000620082827625ULL, 0x000fe200078e0083ULL,
0x00000008ffbb7819ULL, 0x000fe200000116bbULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a100f7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e11ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000000f0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000b7919ULL, 0x000e640000000000ULL, 0x00000020020a7824ULL, 0x002fca00078e020bULL,
0x00000004ff0b7819ULL, 0x000fe4000001160aULL, 0x000000010a0c7810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe0b0d7812ULL, 0x000fe400078ec0ffULL, 0x0000001f0a0b7812ULL, 0x000fc600078ec0ffULL,
0x000000010d107824ULL, 0x040fe400078e020cULL, 0x000000010a0f7824ULL, 0x000fe200078e020dULL,
0x000000080d0d7810ULL, 0x000fe20007ffe0ffULL, 0x000000100b117824ULL, 0x040fe200078e00ffULL,
0x0000000f10107812ULL, 0x000fe200078ec0ffULL, 0x000000100b127824ULL, 0x000fe200078e00ffULL,
0x0000000f0f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000010c0c7824ULL, 0x100fe200078e020dULL,
0x000001f011107812ULL, 0x000fe200078ee210ULL, 0x000000010a0a7824ULL, 0x000fe200078e020dULL,
0x000001f0120f7812ULL, 0x000fe200078ee20fULL, 0x000000100b0d7824ULL, 0x040fe200078e00ffULL,
0x0000000f0c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000010147984ULL, 0x000e62000000cc00ULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x0000000f0a0a7812ULL, 0x000fc400078ec0ffULL,
0x000000000f187984ULL, 0x000ea4000000cc00ULL, 0x000001f00b0c7812ULL, 0x000fe400078ee20cULL,
0x000001f00d0a7812ULL, 0x000fe200078ee20aULL, 0x000000ffff1e7224ULL, 0x002fe400078e0014ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0016ULL, 0x000000ffff1c7224ULL, 0x004fe400078e0018ULL,
0x000000ffff1d7224ULL, 0x000fc400078e001aULL, 0x000000ffff227224ULL, 0x000fe400078e0015ULL,
0x000000ffff237224ULL, 0x000fe200078e0017ULL, 0x0000001c0f007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff207224ULL, 0x000fe400078e0019ULL, 0x000000ffff217224ULL, 0x000fca00078e001bULL,
0x0000002010007388ULL, 0x000fe8000000cc00ULL, 0x000000000c147984ULL, 0x000e68000000cc00ULL,
0x000000000a187984ULL, 0x000ea2000000cc00ULL, 0x000000ffff277224ULL, 0x002fe400078e0016ULL,
0x000000ffff267224ULL, 0x000fc400078e0014ULL, 0x000000ffff167224ULL, 0x000fe400078e0015ULL,
0x000000ffff247224ULL, 0x004fe400078e0018ULL, 0x000000ffff257224ULL, 0x000fe400078e001aULL,
0x000000ffff147224ULL, 0x000fe400078e0019ULL, 0x000000ffff157224ULL, 0x000fe200078e001bULL,
0x000000240a007388ULL, 0x0003e8000000cc00ULL, 0x000000140c007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a60000ff107f8cULL, 0x000ea2000c80043fULL,
0x000000ffff127224ULL, 0x000fc600078e00ffULL, 0x00000000000a7805ULL, 0x002fc80000015200ULL,
0x01a60400ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x006fc40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a0f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e0bULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc8000001140dULL, 0x0000000f0c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e060dULL, 0x000000020c0c7819ULL, 0x000fc8000000120dULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a60400ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000000000ULL,
0x3db504f30e0c7820ULL, 0x010fe20000410000ULL, 0x00000100bcbc7810ULL, 0x000fe20007ffe0ffULL,
0x00006a00c2c27a24ULL, 0x000fe200078e02ffULL, 0x0001a68802be7811ULL, 0x000fe200078e18ffULL,
0x00000002130b7824ULL, 0x000fe200078e00ffULL, 0xffffffff000d7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x00000009000e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0001a60802bf7811ULL, 0x000fc400078e28ffULL,
0x000000020f137810ULL, 0x044fe20007ffe0ffULL, 0x000001000f117824ULL, 0x000fe200078e02bcULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000009c0317224ULL, 0x010fe200078e02ffULL,
0x000000061300720cULL, 0x000fc40003f06070ULL, 0x0000004011147812ULL, 0x000fe400078ec0ffULL,
0x0000000110127812ULL, 0x000fc600078e0cffULL, 0x0000000107097824ULL, 0x000fcc00078e0214ULL,
0x00000cc000008947ULL, 0x008fea0003800000ULL, 0x00000003ff2a7819ULL, 0x002fe2000001160aULL,
0x0000000202287824ULL, 0x000fe200078e0212ULL, 0x00006400312f7a11ULL, 0x040fe400078038ffULL,
0x000000042a187810ULL, 0x040fe40007ffe0ffULL, 0x000000082a1a7810ULL, 0x040fe40007ffe0ffULL,
0x000000102a207810ULL, 0x000fe20007ffe0ffULL, 0x0000000118137824ULL, 0x100fe200078e020aULL,
0x0000000c2a1c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000818147824ULL, 0x000fe200078e00ffULL,
0x0000650031317a11ULL, 0x000fe200000f3cffULL, 0x000000011a157824ULL, 0x000fe200078e020aULL,
0x000000142a267810ULL, 0x000fe20007ffe0ffULL, 0x000000081a167824ULL, 0x000fe200078e00ffULL,
0xfffffff814277812ULL, 0x000fe200078ee213ULL, 0x000000012a147824ULL, 0x040fe200078e0209ULL,
0x000000182a2c7810ULL, 0x000fe20007ffe0ffULL, 0x000000100a137824ULL, 0x000fe200078e00ffULL,
0xfffffff8162b7812ULL, 0x000fe200078ee215ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000001104167217ULL, 0x000fc40007800000ULL, 0x0000007013337812ULL, 0x000fe200078ec0ffULL,
0x0000000820357824ULL, 0x000fe200078e00ffULL, 0x0000001c2a307810ULL, 0x000fe20007ffe0ffULL,
0x000000011c137824ULL, 0x100fe200078e020aULL, 0x00000033141e7212ULL, 0x000fe200078efcffULL,
0x0000000120147824ULL, 0x000fe200078e020aULL, 0x000000202a327810ULL, 0x000fe20007ffe0ffULL,
0x000000081c227824ULL, 0x000fe200078e00ffULL, 0x0000001e2f1e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000826377824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee214ULL,
0x0000000118147824ULL, 0x000fe200078e0209ULL, 0xfffffff8222d7812ULL, 0x000fe200078ee213ULL,
0x0000000116137824ULL, 0x000fe200078e0a11ULL, 0x0000200028287811ULL, 0x000fe200078e68ffULL,
0x00000001151f7824ULL, 0x000fe200000e0631ULL, 0x000000242a347810ULL, 0x000fe20007ffe0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000131a00720cULL, 0x000fc40003f26070ULL,
0x000000132000720cULL, 0x080fe20003f06070ULL, 0x000000011a167824ULL, 0x100fe200078e0209ULL,
0x000000131800720cULL, 0x000fe20003fa6070ULL, 0x00000001201a7824ULL, 0x100fe200078e0209ULL,
0x0000003314207212ULL, 0x000fe200078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000131c00720cULL, 0x000fe40003f46070ULL, 0x0000002f20207210ULL, 0x000fe20007f7e0ffULL,
0x000000011c187824ULL, 0x100fe200078e0209ULL, 0x0000003316227212ULL, 0x000fe200078efcffULL,
0x00000001261c7824ULL, 0x000fc400078e0209ULL, 0x000000012c147824ULL, 0x000fe200078e0209ULL,
0x0000002f22227210ULL, 0x000fe20007f9e0ffULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000003318187212ULL, 0x000fc600078efcffULL,
0x0000000115217824ULL, 0x000fe200018e0631ULL, 0x000000331c1c7212ULL, 0x000fe200078efcffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000002f18187210ULL, 0x000fc60007f7e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000003314247212ULL, 0x000fc600078efcffULL,
0x0000000117237824ULL, 0x000fe200020e0631ULL, 0x0000002f1c1c7210ULL, 0x000fe20007f9e0ffULL,
0x000000012a167824ULL, 0x100fe200078e020aULL, 0x000000331a1a7212ULL, 0x000fe200078efcffULL,
0x0000000130147824ULL, 0x000fe200078e0209ULL, 0x0000002f24247210ULL, 0x080fe20007fde0ffULL,
0x0000000119197824ULL, 0x100fe200018e0631ULL, 0x0000002f1a1a7210ULL, 0x000fe20007f7e0ffULL,
0x000000011d1d7824ULL, 0x100fe200020e0631ULL, 0x0000000716177812ULL, 0x000fe200078ec0ffULL,
0x0000000126167824ULL, 0x100fe200078e020aULL, 0x000000132a00720cULL, 0x000fe20003f86070ULL,
0x0000000115257824ULL, 0x000fe200030e0631ULL, 0x0ffffff817177812ULL, 0x000fe200078ef80aULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffff837377812ULL, 0x000fc600078ee216ULL,
0x000000011b1b7824ULL, 0x000fe200018e0631ULL, 0x000000132600720cULL, 0x000fe20003f66070ULL,
0x0000000132167824ULL, 0x100fe200078e0209ULL, 0x0000003314267212ULL, 0x000fe200078efcffULL,
0x0000001017297824ULL, 0x000fe400078e0228ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000002f26267210ULL, 0x000fe40007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e297faeULL, 0x0003e2000e101c46ULL, 0x0000000134147824ULL, 0x000fe200078e0209ULL,
0x0000003316167212ULL, 0x000fe200078efcffULL, 0x000000012c2e7824ULL, 0x040fe200078e020aULL,
0x000000132c00720cULL, 0x040fe20003f86070ULL, 0x000000082c397824ULL, 0x000fe200078e00ffULL,
0x000000282a2c7810ULL, 0x000fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fc600078e0228ULL,
0xfffffff839397812ULL, 0x000fe200078ee22eULL, 0x0000001027297824ULL, 0x002fe200078e0228ULL,
0x000000302a2e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000115277824ULL, 0x100fe200030e0631ULL,
0x0000002f16167210ULL, 0x000fe20007fde0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000020297faeULL, 0x0003e2000e901c46ULL, 0x000000133000720cULL, 0x040fe40003fa6070ULL,
0x00000001301f7824ULL, 0x000fe200078e020aULL, 0x00000033141e7212ULL, 0x000fe200078efcffULL,
0x0000000830307824ULL, 0x000fe200078e00ffULL, 0x00000000222b7faeULL, 0x0005e2000c901c46ULL,
0x0000000117177824ULL, 0x000fe200030e0631ULL, 0x0000002f1e1e7210ULL, 0x000fe20007fde0ffULL,
0x000000012c147824ULL, 0x000fe200078e0209ULL, 0xfffffff8303b7812ULL, 0x000fc400078ee21fULL,
0x000000133200720cULL, 0x000fe20003f26070ULL, 0x00000001151f7824ULL, 0x000fe200030e0631ULL,
0x000000342a307810ULL, 0x000fe20007ffe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000002c2a227810ULL, 0x004fc60007ffe0ffULL, 0x0000000132217824ULL, 0x002fe200078e020aULL,
0x0000003314207212ULL, 0x000fe200078efcffULL, 0x0000000832327824ULL, 0x000fe400078e00ffULL,
0x000000102d297824ULL, 0x000fe200078e0228ULL, 0x0000002f20207210ULL, 0x000fe20007fde0ffULL,
0x0000000134147824ULL, 0x000fe200078e020aULL, 0xfffffff8322b7812ULL, 0x000fe200078ee221ULL,
0x00000008342d7824ULL, 0x040fe200078e00ffULL, 0x0000000018297faeULL, 0x0003e2000d101c46ULL,
0x0000001035237824ULL, 0x000fe200078e0228ULL, 0x000000133400720cULL, 0x000fe20003f46070ULL,
0x0000000115217824ULL, 0x000fe200030e0631ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee214ULL,
0x0000001037157824ULL, 0x000fe200078e0228ULL, 0x000000001a237faeULL, 0x0005e2000c101c46ULL,
0x0000000122147824ULL, 0x000fc400078e0209ULL, 0x000000102b2b7824ULL, 0x100fe200078e0228ULL,
0x000000001c157faeULL, 0x0007e2000d901c46ULL, 0x000000102d2d7824ULL, 0x100fe200078e0228ULL,
0x000000132e00720cULL, 0x000fe20003f66070ULL, 0x0000001039197824ULL, 0x102fe400078e0228ULL,
0x000000103b297824ULL, 0x000fc600078e0228ULL, 0x0000000024197faeULL, 0x0003e2000e101c46ULL,
0x000000082e237824ULL, 0x004fe200078e00ffULL, 0x000000132200720cULL, 0x0c0fe20003f86070ULL,
0x00000001221b7824ULL, 0x100fe200078e020aULL, 0x0000000026297faeULL, 0x0005e2000e901c46ULL,
0x0000008014147825ULL, 0x008fe200078e00ffULL, 0x000000132c00720cULL, 0x000fe40003fa6070ULL,
0x00000000162b7faeULL, 0x0007e2000c901c46ULL, 0x0000000822227824ULL, 0x000fe200078e00ffULL,
0x0000003314187212ULL, 0x000fe200078efcffULL, 0x000000012e147824ULL, 0x000fe200078e0209ULL,
0x000000382a247810ULL, 0x002fe20007ffe0ffULL, 0x000000001e2d7faeULL, 0x0003e2000d101c46ULL,
0x0000002f18187210ULL, 0x000fe20007fde0ffULL, 0x00000001301d7824ULL, 0x000fe200078e020aULL,
0x0000003c2a2a7810ULL, 0x000fc40007ffe0ffULL, 0x000000133000720cULL, 0x080fe20003f46070ULL,
0x0000000115197824ULL, 0x000fe200030e0631ULL, 0x000000132400720cULL, 0x080fe20003f26070ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000132a00720cULL, 0x000fc60003f06070ULL,
0x0000000130167824ULL, 0x008fe200078e0209ULL, 0x00000033141a7212ULL, 0x000fe200078efcffULL,
0x000000012e147824ULL, 0x000fe200078e020aULL, 0xfffffff8221f7812ULL, 0x002fe200078ee21bULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000002f1a1a7210ULL, 0x000fe40007fde0ffULL,
0xfffffff823237812ULL, 0x000fe200078ee214ULL, 0x0000000124147824ULL, 0x000fe200078e0209ULL,
0x00000033161c7212ULL, 0x000fe200078efcffULL, 0x00000001151b7824ULL, 0x000fc400030e0631ULL,
0x0000000830307824ULL, 0x000fe200078e00ffULL, 0x0000002f1c1c7210ULL, 0x000fe20007fde0ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff830257812ULL, 0x000fe200078ee21dULL,
0x000000012a167824ULL, 0x000fe200078e0209ULL, 0x0000003314147212ULL, 0x000fe200078efcffULL,
0x000000012c137824ULL, 0x040fe400078e020aULL, 0x000000082c2c7824ULL, 0x000fe400078e00ffULL,
0x00000001171d7824ULL, 0x000fe200030e0631ULL, 0x0000002f14147210ULL, 0x000fe20007fde0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0xfffffff82c137812ULL, 0x000fc600078ee213ULL,
0x0000000124097824ULL, 0x100fe200078e020aULL, 0x0000003316167212ULL, 0x000fe200078efcffULL,
0x0000000824247824ULL, 0x000fe400078e00ffULL, 0x000000012a1e7824ULL, 0x040fe400078e020aULL,
0x000000082a297824ULL, 0x004fe200078e00ffULL, 0xfffffff824277812ULL, 0x000fe200078ee209ULL,
0x0000000115157824ULL, 0x000fe200030e0631ULL, 0x0000002f16167210ULL, 0x000fe20007fde0ffULL,
0x0000001013097824ULL, 0x000fe200078e0228ULL, 0xfffffff829297812ULL, 0x000fe200078ee21eULL,
0x000000101f137824ULL, 0x000fc400078e0228ULL, 0x00000010231f7824ULL, 0x100fe200078e0228ULL,
0x0000000020097faeULL, 0x0003e2000e901c46ULL, 0x0000001025237824ULL, 0x100fe400078e0228ULL,
0x0000001027257824ULL, 0x100fe200078e0228ULL, 0x0000000018137faeULL, 0x0003e2000e101c46ULL,
0x0000001029277824ULL, 0x000fe400078e0228ULL, 0x0000000117177824ULL, 0x000fe200030e0631ULL,
0x000000001a1f7faeULL, 0x0003e8000d901c46ULL, 0x000000001c237faeULL, 0x0003e8000d101c46ULL,
0x0000000014257faeULL, 0x0003e8000c901c46ULL, 0x0000000016277faeULL, 0x0003e2000c101c46ULL,
0x00000b8000007947ULL, 0x000fea0003800000ULL, 0x000000040a167811ULL, 0x042fe400078fe8ffULL,
0x0000000c0a1a7811ULL, 0x000fc400078fe8ffULL, 0x000000080a187811ULL, 0x000fe200078fe8ffULL,
0x0000000116137824ULL, 0x100fe200078e020aULL, 0x000000180a1f7811ULL, 0x000fe200078fe8ffULL,
0x00000008161c7824ULL, 0x000fe200078e00ffULL, 0x000000240a347811ULL, 0x000fe200078fe8ffULL,
0x000000011a157824ULL, 0x100fe200078e020aULL, 0x000000200a217811ULL, 0x000fe200078fe8ffULL,
0x000000081a1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c177812ULL, 0x000fe200078ee213ULL,
0x0000000118147824ULL, 0x100fe200078e020aULL, 0x000000100a1c7811ULL, 0x000fe200078fe8ffULL,
0x0000000818357824ULL, 0x000fe200078e00ffULL, 0xfffffff81e377812ULL, 0x000fe200078ee215ULL,
0x000000011f157824ULL, 0x100fe200078e020aULL, 0x000000140a1e7811ULL, 0x000fe200078fe8ffULL,
0x000000011c137824ULL, 0x040fe200078e020aULL, 0xfffffff835357812ULL, 0x000fe200078ee214ULL,
0x000000081c207824ULL, 0x000fe200078e00ffULL, 0x000000280a367811ULL, 0x040fe200078fe8ffULL,
0x000000081f227824ULL, 0x000fe200078e00ffULL, 0x000000300a3a7811ULL, 0x000fe200078fe8ffULL,
0x000000011e147824ULL, 0x100fe200078e020aULL, 0xfffffff820397812ULL, 0x000fe200078ee213ULL,
0x000000081e3b7824ULL, 0x000fe200078e00ffULL, 0x0000001c0a207811ULL, 0x000fe200078fe8ffULL,
0x0000000834247824ULL, 0x000fe200078e00ffULL, 0xfffffff8223d7812ULL, 0x000fe200078ee215ULL,
0x0000000134157824ULL, 0x000fe200078e020aULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee214ULL,
0x0000000120137824ULL, 0x100fe200078e020aULL, 0x0000002c0a387811ULL, 0x000fe200078fe8ffULL,
0x0000000820227824ULL, 0x000fe200078e00ffULL, 0x000000340a3c7811ULL, 0x000fe200078fe8ffULL,
0x0000000121147824ULL, 0x140fe200078e020aULL, 0xfffffff824437812ULL, 0x000fe200078ee215ULL,
0x0000000821417824ULL, 0x000fe200078e00ffULL, 0xfffffff8223f7812ULL, 0x000fe200078ee213ULL,
0x0000000136137824ULL, 0x000fe200078e020aULL, 0x0000003c0a407811ULL, 0x000fe200078fe8ffULL,
0x0000000836227824ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee214ULL,
0x000000013a157824ULL, 0x100fe200078e020aULL, 0x000000380a3e7811ULL, 0x000fe200078fe8ffULL,
0x000000083a247824ULL, 0x000fe200078e00ffULL, 0xfffffff822457812ULL, 0x000fe200078ee213ULL,
0x0000000138147824ULL, 0x140fe200078e020aULL, 0x0000640031537a11ULL, 0x040fe200078038ffULL,
0x0000000838477824ULL, 0x000fe200078e00ffULL, 0xfffffff824497812ULL, 0x000fe200078ee215ULL,
0x000000013c137824ULL, 0x040fe200078e020aULL, 0x0000650031557a11ULL, 0x000fe200000f3cffULL,
0x000000083c227824ULL, 0x000fe200078e00ffULL, 0xfffffff847477812ULL, 0x000fe200078ee214ULL,
0x0000000140157824ULL, 0x000fc400078e020aULL, 0x0000000840247824ULL, 0x000fe200078e00ffULL,
0xfffffff8224b7812ULL, 0x000fe200078ee213ULL, 0x000000013e147824ULL, 0x000fe200078e020aULL,
0x0000000a0a137211ULL, 0x000fe200078fe8ffULL, 0x000000083e4d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8244f7812ULL, 0x000fe200078ee215ULL, 0x0000000202157824ULL, 0x000fe200078e0212ULL,
0x0000000713137812ULL, 0x000fe200078ec0ffULL, 0x0000000116167824ULL, 0x100fe200078e0209ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee214ULL, 0x0000000118187824ULL, 0x100fe200078e0209ULL,
0x000000090a147211ULL, 0x000fe200078fe8ffULL, 0x000000011a1a7824ULL, 0x100fe200078e0209ULL,
0x0000200015227811ULL, 0x000fe200078e68ffULL, 0x000000011c1c7824ULL, 0x100fe200078e0209ULL,
0x0ffffff813137812ULL, 0x000fe200078ef80aULL, 0x000000011e1e7824ULL, 0x000fc400078e0209ULL,
0x000000011f1f7824ULL, 0x100fe400078e0209ULL, 0x0000000120207824ULL, 0x100fe400078e0209ULL,
0x0000000121217824ULL, 0x100fe400078e0209ULL, 0x0000000134347824ULL, 0x100fe400078e0209ULL,
0x0000000136367824ULL, 0x100fe400078e0209ULL, 0x0000000138387824ULL, 0x000fc400078e0209ULL,
0x000000013a3a7824ULL, 0x100fe400078e0209ULL, 0x000000013c3c7824ULL, 0x100fe400078e0209ULL,
0x000000013e3e7824ULL, 0x100fe400078e0209ULL, 0x0000000140407824ULL, 0x000fe400078e0209ULL,
0x000000100a097824ULL, 0x000fe400078e00ffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x0000007009517812ULL, 0x000fe200078ec0ffULL, 0x0000001013097824ULL, 0x100fe400078e0222ULL,
0x0000001017137824ULL, 0x100fe400078e0222ULL, 0x0000001035357824ULL, 0x100fe400078e0222ULL,
0x0000001037377824ULL, 0x100fe400078e0222ULL, 0x0000001039397824ULL, 0x100fe400078e0222ULL,
0x000000103b3b7824ULL, 0x000fc400078e0222ULL, 0x000000103d3d7824ULL, 0x100fe400078e0222ULL,
0x000000103f3f7824ULL, 0x100fe400078e0222ULL, 0x0000001041417824ULL, 0x100fe400078e0222ULL,
0x0000001043437824ULL, 0x100fe400078e0222ULL, 0x0000001045457824ULL, 0x100fe400078e0222ULL,
0x0000001047477824ULL, 0x000fc400078e0222ULL, 0x0000001049497824ULL, 0x100fe400078e0222ULL,
0x000000104b4b7824ULL, 0x100fe400078e0222ULL, 0x000000104d4d7824ULL, 0x100fe400078e0222ULL,
0x000000104f4f7824ULL, 0x000fe200078e0222ULL, 0x0000005114227212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0x0000002253227210ULL, 0x000fe20007f1e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000005116247212ULL, 0x000fc600078efcffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000005118267212ULL, 0x080fe400078efcffULL,
0x0000002453247210ULL, 0x000fe20007f3e0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000511a287212ULL, 0x000fc600078efcffULL, 0x0000000115237824ULL, 0x100fe200000e0655ULL,
0x0000002653267210ULL, 0x000fe20007f1e0ffULL, 0x0000000117257824ULL, 0x100fe200008e0655ULL,
0x0000002853287210ULL, 0x000fe20007f5e0ffULL, 0x000000801e147825ULL, 0x000fe200078e00ffULL,
0x000000511c2a7212ULL, 0x080fe200078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022097faeULL, 0x0003e4000b901c46ULL, 0x0000000119277824ULL, 0x100fe200000e0655ULL,
0x0000002a532a7210ULL, 0x000fe20007f1e0ffULL, 0x000000801f167825ULL, 0x000fe200078e00ffULL,
0x00000051142c7212ULL, 0x080fe200078efcffULL, 0x0000000024137faeULL, 0x0003e4000b901c46ULL,
0x000000011b297824ULL, 0x100fe200010e0655ULL, 0x00000051162e7212ULL, 0x080fe200078efcffULL,
0x0000008020187825ULL, 0x000fe200078e00ffULL, 0x0000000026357faeULL, 0x0003e4000b901c46ULL,
0x0000002e532e7210ULL, 0x000fe20007f3e0ffULL, 0x00000080211a7825ULL, 0x000fe200078e00ffULL,
0x0000005118307212ULL, 0x080fe200078efcffULL, 0x0000000028377faeULL, 0x0003e4000b901c46ULL,
0x000000011d2b7824ULL, 0x100fe200000e0655ULL, 0x000000511a327212ULL, 0x080fe200078efcffULL,
0x00000001172f7824ULL, 0x100fe200008e0655ULL, 0x0000002c532c7210ULL, 0x040fe20007f1e0ffULL,
0x0000008036167825ULL, 0x000fe200078e00ffULL, 0x0000003053307210ULL, 0x040fe20007f5e0ffULL,
0x000000002a397faeULL, 0x0003e2000b901c46ULL, 0x0000003253327210ULL, 0x000fe20007f7e0ffULL,
0x00000001152d7824ULL, 0x000fe200000e0655ULL, 0x0000005116167212ULL, 0x000fe200078efcffULL,
0x0000008034147825ULL, 0x000fc600078e00ffULL, 0x0000001653167210ULL, 0x000fe20007f3e0ffULL,
0x0000000119317824ULL, 0x100fe200010e0655ULL, 0x0000005114147212ULL, 0x080fe200078efcffULL,
0x000000011b337824ULL, 0x000fe200018e0655ULL, 0x000000002c3b7faeULL, 0x0003e2000b901c46ULL,
0x0000008038187825ULL, 0x000fe200078e00ffULL, 0x0000001453147210ULL, 0x000fe40007f1e0ffULL,
0x000000002e3d7faeULL, 0x0003e2000b901c46ULL, 0x000000803a1a7825ULL, 0x000fe200078e00ffULL,
0x0000005118187212ULL, 0x000fc400078efcffULL, 0x00000000303f7faeULL, 0x0003e2000b901c46ULL,
0x000000803c1c7825ULL, 0x000fe200078e00ffULL, 0x000000511a1a7212ULL, 0x080fe400078efcffULL,
0x0000001853187210ULL, 0x040fe20007f5e0ffULL, 0x000000803e1e7825ULL, 0x000fe200078e00ffULL,
0x000000511c1c7212ULL, 0x080fe200078efcffULL, 0x0000000032417faeULL, 0x0003e2000b901c46ULL,
0x0000001a531a7210ULL, 0x000fe20007f7e0ffULL, 0x0000008040207825ULL, 0x000fe200078e00ffULL,
0x000000511e1e7212ULL, 0x000fc400078efcffULL, 0x0000001c531c7210ULL, 0x000fe20007f9e0ffULL,
0x0000000115157824ULL, 0x100fe200000e0655ULL, 0x0000005120207212ULL, 0x000fe200078efcffULL,
0x0000000117177824ULL, 0x100fe200008e0655ULL, 0x0000001e531e7210ULL, 0x000fe20007fbe0ffULL,
0x0000000119197824ULL, 0x100fe200010e0655ULL, 0x0000002053207210ULL, 0x000fe20007fde0ffULL,
0x000000011b1b7824ULL, 0x100fe200018e0655ULL, 0x0000000014437faeULL, 0x0003e2000b901c46ULL,
0x000000011d1d7824ULL, 0x100fe400020e0655ULL, 0x000000011f1f7824ULL, 0x100fe200028e0655ULL,
0x0000000016457faeULL, 0x0003e2000b901c46ULL, 0x0000000121217824ULL, 0x000fc600030e0655ULL,
0x0000000018477faeULL, 0x0003e8000b901c46ULL, 0x000000001a497faeULL, 0x0003e8000b901c46ULL,
0x000000001c4b7faeULL, 0x0003e8000b901c46ULL, 0x000000001e4d7faeULL, 0x0003e8000b901c46ULL,
0x00000000204f7faeULL, 0x0003e4000b901c46ULL, 0x0000000208087810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff097424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000050800720cULL, 0x000fda0003f06070ULL, 0x00000002c2168824ULL, 0x000fe400078e0208ULL,
0x00000004ff178424ULL, 0x000fc800078e00ffULL, 0x0000660016168625ULL, 0x000fe200078e0017ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x0000000616098981ULL, 0x000322000c1e1900ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000006e7805ULL, 0x000fe2000001ff00ULL, 0x00000000006c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x002fc80000000000ULL, 0xfffffff80a137812ULL, 0x000fe200078ec0ffULL,
0x0000000202717824ULL, 0x020fe200078e0210ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000115727810ULL, 0x000fc40007ffe0ffULL, 0x0000000713137812ULL, 0x000fe400078ef80aULL,
0x0000200071717811ULL, 0x000fc600078e68ffULL, 0x0000000113147824ULL, 0x040fe400078e0215ULL,
0x0000000813177824ULL, 0x040fe400078e00ffULL, 0x0000000813167824ULL, 0x040fe400078e00ffULL,
0x0000000113137824ULL, 0x000fe200078e0272ULL, 0xfffffff817147812ULL, 0x000fc800078ee214ULL,
0xfffffff816167812ULL, 0x000fe200078ee213ULL, 0x0000001014147824ULL, 0x000fe200078e0271ULL,
0x000000200a137810ULL, 0x000fc60007ffe0ffULL, 0x0000001016167824ULL, 0x000fe200078e0271ULL,
0x000000001428783bULL, 0x000e620000000200ULL, 0xfffffff813137812ULL, 0x000fc600078ec0ffULL,
0x00000000162c783bULL, 0x0004e20000000200ULL, 0x0000000713737812ULL, 0x000fca00078ef80aULL,
0x0000000173137824ULL, 0x040fe400078e0215ULL, 0x0000000873187824ULL, 0x040fe400078e00ffULL,
0x0000000173727824ULL, 0x040fe400078e0272ULL, 0x0000000873737824ULL, 0x000fca00078e00ffULL,
0xfffffff873727812ULL, 0x000fe400078ee272ULL, 0x00000018ff147819ULL, 0x002fe20000011428ULL,
0x0000002800f67306ULL, 0x000fe20000009400ULL, 0x00000018ff167819ULL, 0x004fe40000011429ULL,
0x00000018ff1f7819ULL, 0x008fe2000001142cULL, 0x000100002f767824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe4000001142eULL, 0x00000018ff177819ULL, 0x000fe2000001142aULL,
0x0000001400917306ULL, 0x000fe20000209400ULL, 0x00000018ff747819ULL, 0x000fc4000001142fULL,
0x00000018ff307819ULL, 0x000fca000001142dULL, 0x0000001400f27306ULL, 0x000e700000205400ULL,
0x00000014009f7306ULL, 0x0004f0000020d400ULL, 0x0000001600927306ULL, 0x000fe20000209400ULL,
0xfffffff818147812ULL, 0x004fc400078ee213ULL, 0x00000018ff137819ULL, 0x000fe4000001142bULL,
0x000000f29100720bULL, 0x002fe20003f9d000ULL, 0x0000001014147824ULL, 0x000fe400078e0271ULL,
0x0000001600997306ULL, 0x000e660000205400ULL, 0x000000001468783bULL, 0x000eaa0000000200ULL,
0x0000001600a27306ULL, 0x000e64000020d400ULL, 0x000000019f9f4812ULL, 0x008fcc00078efcffULL,
0x0000001f00af7306ULL, 0x000fe20000209400ULL, 0x000000999200720bULL, 0x002fce0003fdd000ULL,
0x0000001f00b07306ULL, 0x000fec0000205400ULL, 0x00000001a2a26812ULL, 0x000fe400078efcffULL,
0x0000001f00167306ULL, 0x0003f0000020d400ULL, 0x0000002800c57306ULL, 0x000ee20000005400ULL,
0x00010000281f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000002800a37306ULL, 0x0002b0000000d400ULL, 0x0000001f00e67306ULL, 0x000fe20000209400ULL,
0x0000010028287824ULL, 0x002fe200078e00ffULL, 0x000000c5f600720bULL, 0x008fc80003f7d000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000001f00f57306ULL, 0x000e6e0000205400ULL,
0x00000001a3a33812ULL, 0x004fe200078efcffULL, 0x0000002800d47306ULL, 0x000ff00000209400ULL,
0x0000002800d57306ULL, 0x000fe20000205400ULL, 0x000000f5e600720bULL, 0x002fce0003fbd000ULL,
0x0000002800c87306ULL, 0x0003f0000020d400ULL, 0x0000001f00d67306ULL, 0x0004e2000020d400ULL,
0x000100002b287824ULL, 0x002fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000070001d7306ULL, 0x000fe20000209400ULL, 0x000100002a1f7824ULL, 0x004fca00078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000007000197306ULL, 0x000fe20000205400ULL,
0x00000001d6d65812ULL, 0x008fe400078efcffULL, 0x000000d5d400720bULL, 0x000fca0003fbd000ULL,
0x00000070001a7306ULL, 0x0003f0000020d400ULL, 0x0000002800d77306ULL, 0x000fe20000209400ULL,
0x0001000029707824ULL, 0x002fe200078e00ffULL, 0x00000001c8c85812ULL, 0x000fc800078efcffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000002800ee7306ULL, 0x000ff00000205400ULL,
0x0000002800d87306ULL, 0x0003f0000020d400ULL, 0x0000002900f37306ULL, 0x000fe20000009400ULL,
0x00000018ff287819ULL, 0x002fce000001146aULL, 0x00000029008e7306ULL, 0x000e700000005400ULL,
0x0000002900a67306ULL, 0x0004f0000000d400ULL, 0x0000002a00937306ULL, 0x000fe20000009400ULL,
0x0000010029297824ULL, 0x004fe200078e00ffULL, 0x0000008ef300720bULL, 0x002fc80003f3d000ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002a00f47306ULL, 0x000e6e0000005400ULL,
0x00000001a6a61812ULL, 0x008fe200078efcffULL, 0x0000002a00df7306ULL, 0x0004f0000000d400ULL,
0x0000002b00947306ULL, 0x000fe20000009400ULL, 0x000001002a2a7824ULL, 0x004fe200078e00ffULL,
0x000000f49300720bULL, 0x002fc80003f1d000ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000002b00f17306ULL, 0x000e6e0000005400ULL, 0x00000001dfdf0812ULL, 0x008fe200078efcffULL,
0x0000002b00d37306ULL, 0x0004f0000000d400ULL, 0x0000001f00977306ULL, 0x000fe20000209400ULL,
0x000001002b2b7824ULL, 0x004fe200078e00ffULL, 0x000000f19400720bULL, 0x002fc80003f5d000ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000001f00987306ULL, 0x000e6e0000205400ULL,
0x00000001d3d32812ULL, 0x008fe200078efcffULL, 0x0000001f00e47306ULL, 0x0004f0000020d400ULL,
0x0000002800bd7306ULL, 0x000fe20000209400ULL, 0x00000018ff1f7819ULL, 0x004fc40000011468ULL,
0x000000989700720bULL, 0x002fca0003fdd000ULL, 0x0000002800ce7306ULL, 0x000ff00000205400ULL,
0x00000028009c7306ULL, 0x0003e2000020d400ULL, 0x00000001e4e46812ULL, 0x008fce00078efcffULL,
0x0000001f00e57306ULL, 0x000fe20000209400ULL, 0x000100002d287824ULL, 0x002fce00078e00ffULL,
0x0000001f00e87306ULL, 0x000e700000205400ULL, 0x0000001f00a17306ULL, 0x0004f0000020d400ULL,
0x0000001700c37306ULL, 0x000fe20000209400ULL, 0x000100002c1f7824ULL, 0x004fe200078e00ffULL,
0x000000e8e500720bULL, 0x002fcc0003f5d000ULL, 0x0000001700c47306ULL, 0x000e6e0000205400ULL,
0x00000001a1a12812ULL, 0x008fe200078efcffULL, 0x0000001700b17306ULL, 0x000eb0000020d400ULL,
0x00000013009e7306ULL, 0x000fe20000209400ULL, 0x000000c4c300720bULL, 0x002fc40003fbd000ULL,
0x000000080ac37812ULL, 0x000fc800078ec0ffULL, 0x00000007c3c37812ULL, 0x000fe200078ef80aULL,
0x0000001300d17306ULL, 0x000fe60000205400ULL, 0x00000010c3c47812ULL, 0x000fc600078efcffULL,
0x00000001b1b15812ULL, 0x004fe400078efcffULL, 0x0000001300b47306ULL, 0x000ff0000020d400ULL,
0x0000007400147306ULL, 0x000ff00000209400ULL, 0x0000007400137306ULL, 0x000ff00000205400ULL,
0x0000007400177306ULL, 0x0003f0000020d400ULL, 0x0000002900c97306ULL, 0x000fe20000209400ULL,
0x00000018ff747819ULL, 0x002fe20000011428ULL, 0x0000001072287824ULL, 0x000fcc00078e0271ULL,
0x0000002900d27306ULL, 0x000e700000205400ULL, 0x0000002900e77306ULL, 0x0004f0000020d400ULL,
0x0000002a00957306ULL, 0x000fe20000209400ULL, 0x00000018ff297819ULL, 0x004fc40000011469ULL,
0x000000d2c900720bULL, 0x002fca0003f9d000ULL, 0x0000002a00967306ULL, 0x000e700000205400ULL,
0x0000002a00e07306ULL, 0x000462000020d400ULL, 0x00000001e7e74812ULL, 0x008fce00078efcffULL,
0x0000002b00ef7306ULL, 0x000fe20000209400ULL, 0x00000018ff2a7819ULL, 0x004fe4000001146bULL,
0x000000969500720bULL, 0x002fca0003fdd000ULL, 0x0000002b00f07306ULL, 0x000e700000205400ULL,
0x0000002b00d97306ULL, 0x0004e2000020d400ULL, 0x00000001e0e06812ULL, 0x000fe400078efcffULL,
0x000000eed700720bULL, 0x000fca0003fdd000ULL, 0x0000002900da7306ULL, 0x000fe20000209400ULL,
0x00000018ff2b7819ULL, 0x004fe4000001141fULL, 0x000000f0ef00720bULL, 0x002fca0003fbd000ULL,
0x0000002900b77306ULL, 0x000fe20000205400ULL, 0x00000001d8d86812ULL, 0x000fce00078efcffULL,
0x00000029009b7306ULL, 0x000fe2000020d400ULL, 0x00000001d9d95812ULL, 0x008fce00078efcffULL,
0x0000002a00cf7306ULL, 0x000ff00000209400ULL, 0x0000002a00d07306ULL, 0x000ff00000205400ULL,
0x0000002a009d7306ULL, 0x000ff0000020d400ULL, 0x0000002b00b97306ULL, 0x000ff00000209400ULL,
0x0000002b00ba7306ULL, 0x000ff00000205400ULL, 0x0000002b008d7306ULL, 0x0003f0000020d400ULL,
0x0000002c00b67306ULL, 0x000fe20000009400ULL, 0x000000002828783bULL, 0x002e6e0000000200ULL,
0x0000002c00b57306ULL, 0x000ff00000005400ULL, 0x0000002c008a7306ULL, 0x0005f0000000d400ULL,
0x0000002d00ab7306ULL, 0x000fe20000009400ULL, 0x000001002c2c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000002d00a97306ULL, 0x000ff00000005400ULL,
0x0000002d001e7306ULL, 0x0005f0000000d400ULL, 0x0000002c00b37306ULL, 0x000fe20000209400ULL,
0x000001002d2d7824ULL, 0x004fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002c00b27306ULL, 0x000ff00000205400ULL, 0x0000002c001f7306ULL, 0x0005f0000020d400ULL,
0x0000002e00ad7306ULL, 0x000fe20000009400ULL, 0x000100002e2c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000002e00ac7306ULL, 0x000ff00000005400ULL,
0x0000002e001c7306ULL, 0x0005f0000000d400ULL, 0x0000002d00a77306ULL, 0x000fe20000209400ULL,
0x000001002e2e7824ULL, 0x004fca00078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x0000002d00a87306ULL, 0x000ff00000205400ULL, 0x0000002d00717306ULL, 0x0005f0000020d400ULL,
0x0000007000c67306ULL, 0x000fe20000209400ULL, 0x00000018ff2d7819ULL, 0x004fce0000011476ULL,
0x0000007000c77306ULL, 0x000eb00000205400ULL, 0x0000007000eb7306ULL, 0x000ef0000020d400ULL,
0x0000002c00907306ULL, 0x000fe20000209400ULL, 0x000000c7c600720bULL, 0x004fce0003f7d000ULL,
0x0000002c008f7306ULL, 0x000fec0000205400ULL, 0x00000001ebeb3812ULL, 0x008fe400078efcffULL,
0x0000002c00727306ULL, 0x0003e2000020d400ULL, 0x000000d19e00720bULL, 0x000fce0003f7d000ULL,
0x0000007400a47306ULL, 0x000fe20000209400ULL, 0x00000018ff2c7819ULL, 0x002fca0000011428ULL,
0x00000001b4b43812ULL, 0x000fe400078efcffULL, 0x0000007400a57306ULL, 0x000ff00000205400ULL,
0x0000007400707306ULL, 0x000ff0000020d400ULL, 0x0000002e00737306ULL, 0x000ff00000209400ULL,
0x0000002e00747306ULL, 0x000ff00000205400ULL, 0x0000002e00757306ULL, 0x0003f0000020d400ULL,
0x0000002d00767306ULL, 0x000fe20000209400ULL, 0x00000018ff2e7819ULL, 0x002fce0000011429ULL,
0x0000002d00777306ULL, 0x000ff00000205400ULL, 0x0000002d00787306ULL, 0x0003f0000020d400ULL,
0x0000002c007c7306ULL, 0x000fe20000209400ULL, 0x00000018ff2d7819ULL, 0x002fce000001142aULL,
0x0000002c007d7306ULL, 0x000ff00000205400ULL, 0x0000002c007e7306ULL, 0x0003f0000020d400ULL,
0x0000002e007f7306ULL, 0x000fe20000209400ULL, 0x00010000682c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000002e00807306ULL, 0x000ff00000205400ULL,
0x0000002e00817306ULL, 0x0003f0000020d400ULL, 0x00000030008b7306ULL, 0x000fe20000209400ULL,
0x000100006a2e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x00000030008c7306ULL, 0x000ff00000205400ULL, 0x0000003000187306ULL, 0x000ff0000020d400ULL,
0x0000002d00847306ULL, 0x000ff00000209400ULL, 0x0000002d00857306ULL, 0x000ff00000205400ULL,
0x0000002d00867306ULL, 0x0003f0000020d400ULL, 0x0000006900307306ULL, 0x000fe20000009400ULL,
0x00010000692d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000006900317306ULL, 0x000e700000005400ULL, 0x00000069009a7306ULL, 0x0004f0000000d400ULL,
0x0000002c00ec7306ULL, 0x000fe20000209400ULL, 0x0000010069697824ULL, 0x004fe200078e00ffULL,
0x000000313000720bULL, 0x002fcc0003f9d000ULL, 0x0000002c00ed7306ULL, 0x000e6e0000205400ULL,
0x000000019a9a4812ULL, 0x008fe200078efcffULL, 0x0000002c00c17306ULL, 0x0004e2000020d400ULL,
0x000000d0cf00720bULL, 0x000fce0003f9d000ULL, 0x0000002e00dd7306ULL, 0x000fe20000209400ULL,
0x00000018ff2c7819ULL, 0x004fe40000011469ULL, 0x000000edec00720bULL, 0x002fc60003fdd000ULL,
0x000000019d9d4812ULL, 0x000fe400078efcffULL, 0x0000002e00de7306ULL, 0x000e620000205400ULL,
0x000000acad00720bULL, 0x000fce0003f9d000ULL, 0x0000002e00b87306ULL, 0x000462000020d400ULL,
0x00000001c1c16812ULL, 0x008fca00078efcffULL, 0x000000011c1c4812ULL, 0x000fe400078efcffULL,
0x0000002c00db7306ULL, 0x000fe20000209400ULL, 0x00000004ff2e7819ULL, 0x004fe4000001160aULL,
0x000000dedd00720bULL, 0x002fc60003f5d000ULL, 0x0000000215c97824ULL, 0x040fe200078e022eULL,
0x0000000215157810ULL, 0x000fe20007ffe0ffULL, 0x0000002c00dc7306ULL, 0x000fe20000205400ULL,
0x00000010c42e7824ULL, 0x000fce00078e00ffULL, 0x0000002c00ca7306ULL, 0x0003e2000020d400ULL,
0x00000001b8b82812ULL, 0x000fce00078efcffULL, 0x0000002d00e17306ULL, 0x000fe20000209400ULL,
0x000100006b2c7824ULL, 0x002fca00078e00ffULL, 0x00000018fff17819ULL, 0x000fe2000001142cULL,
0x00000001c32c7824ULL, 0x040fe200078e02c9ULL, 0x0000002d00e27306ULL, 0x000e700000205400ULL,
0x0000002d00cd7306ULL, 0x0004f0000020d400ULL, 0x0000002f00aa7306ULL, 0x000fe20000009400ULL,
0x00000010c32d7824ULL, 0x004fe200078e00ffULL, 0x000000e2e100720bULL, 0x002fc80003fdd000ULL,
0xfffffff02d2c7812ULL, 0x000fe200078ee22cULL, 0x00000001c42d7824ULL, 0x000fe200078e02c9ULL,
0x0000002f00ae7306ULL, 0x000fe20000005400ULL, 0x00000002c9c97810ULL, 0x000fe40007ffe0ffULL,
0x000000102c307824ULL, 0x000fe200078e00ffULL, 0xfffffff02e2d7812ULL, 0x000fc600078ee22dULL,
0x00000001cdcd6812ULL, 0x008fe200078efcffULL, 0x0000002f001b7306ULL, 0x0003e2000000d400ULL,
0x000000102d2d7824ULL, 0x000fe200078e00ffULL, 0x000000cebd00720bULL, 0x000fe40003fdd000ULL,
0x0000009acd9a723eULL, 0x000fc800000010ffULL, 0x0000006800327306ULL, 0x000fe20000009400ULL,
0x000001002f2f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x0000006800337306ULL, 0x000e620000005400ULL, 0x000000019c9c6812ULL, 0x000fe400078efcffULL,
0x000000b0af00720bULL, 0x000fca0003fdd000ULL, 0x0000006800a07306ULL, 0x0004f0000000d400ULL,
0x0000002f00797306ULL, 0x000fe20000209400ULL, 0x0000010068687824ULL, 0x004fe200078e00ffULL,
0x000000333200720bULL, 0x002fc40003f3d000ULL, 0x000000003030783bULL, 0x000e620000000200ULL,
0x0000000116166812ULL, 0x000fe400078efcffULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x0000002f007a7306ULL, 0x000fe20000205400ULL, 0x0000008f9000720bULL, 0x000fcc0003fdd000ULL,
0x00000001a0a01812ULL, 0x008fe200078efcffULL, 0x0000002f007b7306ULL, 0x0005e2000020d400ULL,
0x000000b7da00720bULL, 0x000fe40003f3d000ULL, 0x000000a0c1a0723eULL, 0x000fc600000010ffULL,
0x0000000172726812ULL, 0x000fe400078efcffULL, 0x0000006800e97306ULL, 0x000fe20000209400ULL,
0x00000018ff2f7819ULL, 0x004fe4000001142bULL, 0x000000777600720bULL, 0x000fe40003fdd000ULL,
0x0000001c721c723eULL, 0x000fe400000010ffULL, 0x000000019b9b1812ULL, 0x000fe200078efcffULL,
0x0000006800ea7306ULL, 0x000eb00000205400ULL, 0x0000006800cc7306ULL, 0x000ee2000020d400ULL,
0x0000000178786812ULL, 0x000fce00078efcffULL, 0x0000006a00687306ULL, 0x000fe20000009400ULL,
0x000000eae900720bULL, 0x004fce0003fbd000ULL, 0x0000006a00697306ULL, 0x000eac0000005400ULL,
0x00000001cccc5812ULL, 0x008fe400078efcffULL, 0x0000002f00877306ULL, 0x000fe20000209400ULL,
0x000000dcdb00720bULL, 0x000fe40003fbd000ULL, 0x000000cca1a1723eULL, 0x000fca00000010ffULL,
0x0000002f00887306ULL, 0x000fe20000205400ULL, 0x000000696800720bULL, 0x004fe20003f1d000ULL,
0x000000a03044723cULL, 0x042fe20000041844ULL, 0x000000a3d668723eULL, 0x000fe400000010ffULL,
0x000000c89f69723eULL, 0x000fe400000010ffULL, 0x00000001caca5812ULL, 0x000fe200078efcffULL,
0x0000002f00897306ULL, 0x0003e6000020d400ULL, 0x000000ca9b9b723eULL, 0x000fe200000010ffULL,
0x000000683064723cULL, 0x040fe80000041864ULL, 0x0000006b00e37306ULL, 0x000fe20000009400ULL,
0x000000002d2c783bULL, 0x002e660000000200ULL, 0x0000009a3040723cULL, 0x000fe80000041840ULL,
0x0000006b00e67306ULL, 0x000eb00000005400ULL, 0x0000006b00c57306ULL, 0x000670000000d400ULL,
0x000000f100d17306ULL, 0x000fe20000209400ULL, 0x000001006b6b7824ULL, 0x008fe200078e00ffULL,
0x000000e6e300720bULL, 0x004fcc0003f7d000ULL, 0x000000f100d27306ULL, 0x000eae0000205400ULL,
0x00000001c5c53812ULL, 0x002fe200078efcffULL, 0x000000f100c67306ULL, 0x0003e2000020d400ULL,
0x000000a9ab00720bULL, 0x000fe20003f7d000ULL, 0x000000682c60723cULL, 0x040b6c0000041860ULL,
0x0000006a00cb7306ULL, 0x0006e2000000d400ULL, 0x00000018fff17819ULL, 0x002fe2000001146bULL,
0x000000a02c38723cULL, 0x000fe20000041838ULL, 0x000000d2d100720bULL, 0x004fc40003f3d000ULL,
0x000000dfe468723eULL, 0x020fe400000010ffULL, 0x000000e0b169723eULL, 0x000fe200000010ffULL,
0x000000f100d67306ULL, 0x000fe20000209400ULL, 0x000001006a6a7824ULL, 0x008fe200078e00ffULL,
0x000000e7a26b723eULL, 0x000fe200000010ffULL, 0x0000009a2c34723cULL, 0x000be20000041834ULL,
0x000000011e1e3812ULL, 0x000fe400078efcffULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x000000f100d77306ULL, 0x000e620000205400ULL, 0x00000001cbcb0812ULL, 0x000fe200078efcffULL,
0x000100002b9a7824ULL, 0x020fe200078e00ffULL, 0x000000bab900720bULL, 0x000fe20003f1d000ULL,
0x000000683054723cULL, 0x000fe20000041854ULL, 0x00000001c6c61812ULL, 0x000fc400078efcffULL,
0x000000b5b600720bULL, 0x000fe20003f3d000ULL, 0x0000006a00d47306ULL, 0x000fe20000209400ULL,
0x000000747300720bULL, 0x000fe40003f7d000ULL, 0x00000018ff9a7819ULL, 0x000fe2000001149aULL,
0x000000682c50723cULL, 0x000be80000041850ULL, 0x0000006a00d57306ULL, 0x000ea20000205400ULL,
0x000000d7d600720bULL, 0x002fc40003f5d000ULL, 0x0001000029687824ULL, 0x020fe200078e00ffULL,
0x000000018d8d0812ULL, 0x000fe400078efcffULL, 0x000000a5a400720bULL, 0x000fe40003f1d000ULL,
0x000000f100c87306ULL, 0x000e62000020d400ULL, 0x00000018ff697819ULL, 0x000fe20000011468ULL,
0x0000010029687824ULL, 0x000fe200078e00ffULL, 0x000000018a8a1812ULL, 0x000fe400078efcffULL,
0x0000000175753812ULL, 0x000fc400078efcffULL, 0x000000a8a700720bULL, 0x000fe20003f3d000ULL,
0x0000006a00c77306ULL, 0x000662000020d400ULL, 0x000000d5d400720bULL, 0x004fe40003fbd000ULL,
0x0000007a7900720bULL, 0x000fe40003f7d000ULL, 0x0000000170700812ULL, 0x000fe400078efcffULL,
0x000000191d00720bULL, 0x000fe20003f1d000ULL, 0x00000028008e7306ULL, 0x000fe20000009400ULL,
0x00010000286a7824ULL, 0x008fe200078e00ffULL, 0x00000001c8c82812ULL, 0x002fc400078efcffULL,
0x000000b2b300720bULL, 0x000fe40003f5d000ULL, 0x00000018ffee7819ULL, 0x000fe4000001146aULL,
0x0000002800937306ULL, 0x000e620000005400ULL, 0x000000a6eb6a723eULL, 0x000fe400000010ffULL,
0x00000001c7c75812ULL, 0x000fe400078efcffULL, 0x000000c89d9d723eULL, 0x000fe400000010ffULL,
0x000000aeaa00720bULL, 0x000fe20003fbd000ULL, 0x0000002800947306ULL, 0x0004e2000000d400ULL,
0x0000006a305c723cULL, 0x000fe2000004185cULL, 0x000000011f1f2812ULL, 0x000fc400078efcffULL,
0x0000008c8b00720bULL, 0x000fe40003f5d000ULL, 0x0000000171711812ULL, 0x000fe400078efcffULL,
0x0000002900917306ULL, 0x000fe20000009400ULL, 0x0000010028287824ULL, 0x004fe200078e00ffULL,
0x0000006a2c58723cULL, 0x000b620000041858ULL, 0x000000017b7b3812ULL, 0x000fe400078efcffULL,
0x000000011b1b5812ULL, 0x000fe400078efcffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000002900927306ULL, 0x000fe20000005400ULL, 0x000000d9b46b723eULL, 0x020fc400000010ffULL,
0x000000d3d86a723eULL, 0x000fe400000010ffULL, 0x0000000118182812ULL, 0x000fe400078efcffULL,
0x000000938e00720bULL, 0x002fe20003f5d000ULL, 0x0000002900997306ULL, 0x0003e2000000d400ULL,
0x000000131400720bULL, 0x000fe20003f3d000ULL, 0x0000006a304c723cULL, 0x000fe2000004184cULL,
0x0000007d7c00720bULL, 0x000fe40003fbd000ULL, 0x000000011a1a0812ULL, 0x000fc400078efcffULL,
0x0000001f168b723eULL, 0x000fe200000010ffULL, 0x0000002800b17306ULL, 0x000fe20000209400ULL,
0x000000c79c29723eULL, 0x002fe200000010ffULL, 0x0000006a2c48723cULL, 0x000b620000041848ULL,
0x000000c5c69c723eULL, 0x000fe400000010ffULL, 0x00000018ffc77819ULL, 0x000fe20000011468ULL,
0x00000001c3687824ULL, 0x140fe200078e02c9ULL, 0x0000000194942812ULL, 0x008fe200078efcffULL,
0x0000002800b77306ULL, 0x000e620000205400ULL, 0x00000010c36b7824ULL, 0x020fe200078e00ffULL,
0x0000009c306c723cULL, 0x000fe2000004186cULL, 0x00000001c4c97824ULL, 0x000fe200078e02c9ULL,
0x000000711871723eULL, 0x000fe200000010ffULL, 0x00000010c4c47824ULL, 0x000fe200078e00ffULL,
0xfffffff06b687812ULL, 0x000fc400078ee268ULL, 0x0000002800b47306ULL, 0x0004e2000020d400ULL,
0x000000751a1d723eULL, 0x000fe200000010ffULL, 0x0000009c2c24723cULL, 0x000fe20000041824ULL,
0xfffffff0c4c97812ULL, 0x000fe200078ee2c9ULL, 0x0000001068687824ULL, 0x000fe200078e00ffULL,
0x0000000117171812ULL, 0x000fe400078efcffULL, 0x000000017e7e5812ULL, 0x000fe200078efcffULL,
0x000000c700c37306ULL, 0x000fe20000209400ULL, 0x000000cbb828723eULL, 0x004fe400000010ffULL,
0x000000b7b100720bULL, 0x002fc40003f7d000ULL, 0x000000929100720bULL, 0x000fe40003f9d000ULL,
0x0000008a8d8a723eULL, 0x000fe200000010ffULL, 0x00000028303c723cULL, 0x080b62000004183cULL,
0x000000c700c67306ULL, 0x000e620000205400ULL, 0x0000001e7070723eULL, 0x000fe400000010ffULL,
0x0000001b7816723eULL, 0x000fe400000010ffULL, 0x0000007b1717723eULL, 0x000fe200000010ffULL,
0x000100002a317824ULL, 0x020fe200078e00ffULL, 0x000000282c20723cULL, 0x000b620000041820ULL,
0x0000002a00977306ULL, 0x000fe20000009400ULL, 0x00000010c9307824ULL, 0x000fe200078e00ffULL,
0x00000001b4b43812ULL, 0x008fc400078efcffULL, 0x00000018ffb57819ULL, 0x000fe40000011431ULL,
0x000000807f00720bULL, 0x000fe20003f7d000ULL, 0x000000003030783bULL, 0x000ea20000000200ULL,
0x0000002a00987306ULL, 0x000ee20000005400ULL, 0x000000c6c300720bULL, 0x002fe40003f5d000ULL,
0x0000000199994812ULL, 0x000fe400078efcffULL, 0x000000888700720bULL, 0x000fe40003f9d000ULL,
0x000000b47ea7723eULL, 0x000fe200000010ffULL, 0x0000002a00957306ULL, 0x0002e6000000d400ULL,
0x0000000181813812ULL, 0x000fca00078efcffULL, 0x000000ee00a37306ULL, 0x000fe20000209400ULL,
0x000001002a2a7824ULL, 0x002fe200078e00ffULL, 0x000000989700720bULL, 0x008fe40003f1d000ULL,
0x0000000189894812ULL, 0x000fe400078efcffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x000000ee00a27306ULL, 0x000e6e0000205400ULL, 0x0000000195950812ULL, 0x000fe200078efcffULL,
0x0000006900bd7306ULL, 0x000fe20000209400ULL, 0x000000081500780cULL, 0x000fe20003f05270ULL,
0x0000008a3060723cULL, 0x044b6c0000041860ULL, 0x0000006900c17306ULL, 0x000ea20000205400ULL,
0x000000a2a300720bULL, 0x002fe20003fdd000ULL, 0x000000703058723cULL, 0x040b6c0000041858ULL,
0x000000b500a07306ULL, 0x000fe40000209400ULL, 0x0000001c3050723cULL, 0x040b6c0000041850ULL,
0x000000b5009b7306ULL, 0x000e620000205400ULL, 0x000000c1bd00720bULL, 0x004fe20003f3d000ULL,
0x000000163048723cULL, 0x000b6c0000041848ULL, 0x0000002b00967306ULL, 0x000ff00000009400ULL,
0x0000002b009e7306ULL, 0x000fe20000005400ULL, 0x0000009ba000720bULL, 0x002fce0003fbd000ULL,
0x0000002b009f7306ULL, 0x0003f0000000d400ULL, 0x000000c700c47306ULL, 0x000ea2000020d400ULL,
0x000001002b2b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x0000002a001f7306ULL, 0x000ff00000209400ULL, 0x0000002a00147306ULL, 0x000e620000205400ULL,
0x00000001c4c42812ULL, 0x004fc800078efcffULL, 0x000000c48181723eULL, 0x000fc600000010ffULL,
0x000000ee00a67306ULL, 0x000eb0000020d400ULL, 0x0000006900b87306ULL, 0x0006a2000020d400ULL,
0x000000141f00720bULL, 0x002fce0003f5d000ULL, 0x000000b500287306ULL, 0x020e62000020d400ULL,
0x000000006868783bULL, 0x008ee20000000200ULL, 0x00000001a6a66812ULL, 0x004fe400078efcffULL,
0x0000009e9600720bULL, 0x000fe40003fdd000ULL, 0x00000094a6a6723eULL, 0x000fe400000010ffULL,
0x0000009a00137306ULL, 0x000fe20000209400ULL, 0x00000001b8b81812ULL, 0x000fe400078efcffULL,
0x000000858400720bULL, 0x000fc40003f3d000ULL, 0x00000099b880723eULL, 0x000fe200000010ffULL,
0x000000a63038723cULL, 0x040b640000041838ULL, 0x0000009a00187306ULL, 0x000ea20000205400ULL,
0x0000000128285812ULL, 0x002fe400078efcffULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x000000952828723eULL, 0x000fe200000010ffULL, 0x000000803034723cULL, 0x000b640000041834ULL,
0x0000002b00197306ULL, 0x000fe20000209400ULL, 0x0000000186861812ULL, 0x000fce00078efcffULL,
0x0000002b001a7306ULL, 0x000e620000205400ULL, 0x000000181300720bULL, 0x004fce0003f7d000ULL,
0x0000002a00297306ULL, 0x000ea2000020d400ULL, 0x0000008a6864723cULL, 0x048b6e0000041864ULL,
0x0000009a009a7306ULL, 0x000ee2000020d400ULL, 0x0000001a1900720bULL, 0x002fe20003fbd000ULL,
0x00000070685c723cULL, 0x040b6c000004185cULL, 0x0000002b00147306ULL, 0x000e62000020d400ULL,
0x0000000129292812ULL, 0x004fe200078efcffULL, 0x0000001c6854723cULL, 0x000b660000041854ULL,
0x000000298629723eULL, 0x000fc400000010ffULL, 0x000000019a9a3812ULL, 0x008fc600078efcffULL,
0x00000016684c723cULL, 0x000b62000004184cULL, 0x0000009f9a88723eULL, 0x000fe400000010ffULL,
0x0000000114145812ULL, 0x002fca00078efcffULL, 0x000000a66844723cULL, 0x000b620000041844ULL,
0x000000148989723eULL, 0x000fce00000010ffULL, 0x000000806840723cULL, 0x040b700000041840ULL,
0x00000028683c723cULL, 0x040b70000004183cULL, 0x00000088686c723cULL, 0x000b70000004186cULL,
0x000000283020723cULL, 0x040b700000041820ULL, 0x000000883024723cULL, 0x000b620000041824ULL,
0x0000001000008944ULL, 0x000fe20003c00000ULL, 0xffffdf5000007947ULL, 0x000fcc000383ffffULL,
0x0000000c5c5c7220ULL, 0x0a0fe40000410000ULL, 0x0000000c5d5d7220ULL, 0x000fc40000410000ULL,
0x0000000c55557220ULL, 0x080fe40000410000ULL, 0x0000000c4d4d7220ULL, 0x080fe40000410000ULL,
0x0000000c4e4e7220ULL, 0x080fe40000410000ULL, 0x0000000c45457220ULL, 0x080fe40000410000ULL,
0x0000000c5f137220ULL, 0x080fe40000410000ULL, 0x0000000c54547220ULL, 0x000fc40000410000ULL,
0x0000000c40407220ULL, 0x080fe40000410000ULL, 0x0000000c42427220ULL, 0x080fe40000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe40000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000c3f3f7220ULL, 0x080fe40000410000ULL, 0x0000000c64647220ULL, 0x000fc40000410000ULL,
0x0000000c65657220ULL, 0x080fe40000410000ULL, 0x0000000c66667220ULL, 0x080fe40000410000ULL,
0x0000000c67677220ULL, 0x080fe40000410000ULL, 0x0000000c5e107220ULL, 0x080fe40000410000ULL,
0x0000000c56147220ULL, 0x080fe40000410000ULL, 0x0000000c57157220ULL, 0x000fc40000410000ULL,
0x0000000c4c5f7220ULL, 0x080fe40000410000ULL, 0x0000000c46167220ULL, 0x080fe40000410000ULL,
0x0000000c47177220ULL, 0x080fe40000410000ULL, 0x0000000c6c6c7220ULL, 0x080fe40000410000ULL,
0x0000000c6d6d7220ULL, 0x080fe40000410000ULL, 0x0000000c60187220ULL, 0x000fc40000410000ULL,
0x0000000c62327220ULL, 0x080fe40000410000ULL, 0x0000000c58197220ULL, 0x080fe40000410000ULL,
0x0000000c591a7220ULL, 0x080fe40000410000ULL, 0x0000000c5b307220ULL, 0x080fe40000410000ULL,
0x0000000c501b7220ULL, 0x080fe40000410000ULL, 0x0000000c511c7220ULL, 0x000fc40000410000ULL,
0x0000000c481d7220ULL, 0x080fe40000410000ULL, 0x0000000c491e7220ULL, 0x080fe40000410000ULL,
0x0000000c381f7220ULL, 0x080fe40000410000ULL, 0x0000000c34287220ULL, 0x080fe40000410000ULL,
0x0000000c35297220ULL, 0x080fe40000410000ULL, 0x0000000c20207220ULL, 0x000fc40000410000ULL,
0x0000000c21217220ULL, 0x080fe40000410000ULL, 0x0000000c24247220ULL, 0x080fe40000410000ULL,
0x0000000c4f4c7220ULL, 0x080fe40000410000ULL, 0x0000000c4a2b7220ULL, 0x000fe40000410000ULL,
0x000000ffff627224ULL, 0x000fe400078e005cULL, 0x000000ffff5b7224ULL, 0x000fc400078e005dULL,
0x0000000c445e7220ULL, 0x080fe40000410000ULL, 0x0000000c434f7220ULL, 0x080fe40000410000ULL,
0x0000000c3c567220ULL, 0x080fe40000410000ULL, 0x0000000c63317220ULL, 0x000fe40000410000ULL,
0x000000ffff5c7224ULL, 0x000fe400078e0055ULL, 0x000000ffff5d7224ULL, 0x000fc400078e004dULL,
0x000000ffff597224ULL, 0x000fe400078e0045ULL, 0x000000ffff4a7224ULL, 0x000fe400078e004eULL,
0x0000000c41577220ULL, 0x080fe40000410000ULL, 0x0000000c6e447220ULL, 0x080fe40000410000ULL,
0x0000000c6f437220ULL, 0x080fe40000410000ULL, 0x0000000c61337220ULL, 0x000fc40000410000ULL,
0x0000000c5a2f7220ULL, 0x080fe40000410000ULL, 0x0000000c522e7220ULL, 0x080fe40000410000ULL,
0x0000000c532a7220ULL, 0x080fe40000410000ULL, 0x0000000c4b2c7220ULL, 0x080fe40000410000ULL,
0x0000000c393c7220ULL, 0x080fe40000410000ULL, 0x0000000c3a2d7220ULL, 0x000fc40000410000ULL,
0x0000000c3b637220ULL, 0x080fe40000410000ULL, 0x0000000c36687220ULL, 0x080fe40000410000ULL,
0x0000000c37697220ULL, 0x000fe40000410000ULL, 0x000000ffff607224ULL, 0x000fe400078e0054ULL,
0x000000ffff587224ULL, 0x000fe400078e0040ULL, 0x000000ffff557224ULL, 0x000fc400078e003dULL,
0x000000ffff4d7224ULL, 0x000fe400078e0042ULL, 0x000000ffff4e7224ULL, 0x000fe400078e003eULL,
0x000000ffff457224ULL, 0x000fe400078e003fULL, 0x0000000c226a7220ULL, 0x080fe40000410000ULL,
0x0000000c236b7220ULL, 0x080fe40000410000ULL, 0x0000000c25417220ULL, 0x000fc40000410000ULL,
0x0000000c266e7220ULL, 0x080fe40000410000ULL, 0x0000000c276f7220ULL, 0x000fe40000410000ULL,
0x000000ffff617224ULL, 0x000fe400078e0064ULL, 0x000000ffff5a7224ULL, 0x000fe400078e0065ULL,
0x000000ffff547224ULL, 0x000fe400078e006cULL, 0x000000ffff537224ULL, 0x000fc400078e006dULL,
0x000000ffff467224ULL, 0x000fe400078e0066ULL, 0x000000ffff527224ULL, 0x000fe400078e0067ULL,
0x000000ffff477224ULL, 0x000fe400078e0010ULL, 0x000000ffff497224ULL, 0x000fe400078e0013ULL,
0x000000ffff487224ULL, 0x000fe400078e0014ULL, 0x000000ffff507224ULL, 0x000fc400078e0015ULL,
0x000000ffff4b7224ULL, 0x000fe400078e0016ULL, 0x000000ffff517224ULL, 0x000fe400078e0017ULL,
0x000000ffff357224ULL, 0x000fe400078e0018ULL, 0x000000ffff347224ULL, 0x000fe400078e0019ULL,
0x000000ffff367224ULL, 0x000fe400078e001aULL, 0x000000ffff377224ULL, 0x000fc400078e001bULL,
0x000000ffff387224ULL, 0x000fe400078e001cULL, 0x000000ffff397224ULL, 0x000fe400078e001dULL,
0x000000ffff3a7224ULL, 0x000fe400078e001eULL, 0x000000ffff3b7224ULL, 0x000fe400078e001fULL,
0x000000ffff3d7224ULL, 0x000fe400078e0028ULL, 0x000000ffff3e7224ULL, 0x000fc400078e0029ULL,
0x000000ffff427224ULL, 0x000fe400078e0020ULL, 0x000000ffff3f7224ULL, 0x000fe400078e0021ULL,
0x000000ffff407224ULL, 0x000fe200078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000be187f8cULL, 0x0002a2000c80043fULL, 0x000000ffff227224ULL, 0x000fe400078e002aULL,
0x000000ffff237224ULL, 0x000fe400078e002bULL, 0x000000ffff2b7224ULL, 0x000fc400078e0063ULL,
0x000000ffff257224ULL, 0x000fe400078e0068ULL, 0x000000ffff267224ULL, 0x000fe400078e0069ULL,
0x000000ffff277224ULL, 0x000fe400078e006aULL, 0x000000ffff287224ULL, 0x000fe400078e006bULL,
0x000000ffff297224ULL, 0x000fe400078e006eULL, 0x000000ffff2a7224ULL, 0x000fc400078e006fULL,
0x0000000000147805ULL, 0x002fca0000015200ULL, 0x00000400be137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x006fc40007804819ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614137210ULL, 0x000fca0007f1e1ffULL, 0x0000000117167824ULL, 0x000fe200000e0e15ULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff1600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff1600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc80000011416ULL, 0x0000001310107211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0616ULL, 0x0000000210107819ULL, 0x000fc80000001213ULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400be137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000040a247824ULL, 0x000fe200078e00ffULL,
0x000000bb0f00720cULL, 0x000fc80003f06070ULL, 0xfffffff024137812ULL, 0x000fca00078ec0ffULL,
0x0000008002137824ULL, 0x000fca00078e0213ULL, 0x01a4000013147984ULL, 0x0002a20000000c00ULL,
0x000021f000008947ULL, 0x000fea0003800000ULL, 0x00005a00001a7b06ULL, 0x000ee20000209000ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x000000030a107211ULL, 0x040fe200078ff0ffULL,
0x000000020a647824ULL, 0x000fe200078e00ffULL, 0xffffff0011117810ULL, 0x000fe40007ffe0ffULL,
0x00000010101c7810ULL, 0x040fe40007ffe0ffULL, 0x00000018101e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000664647812ULL, 0x000fca00078ec0ffULL, 0x0000000164667824ULL, 0x000fe200078e0200ULL,
0x0000001a001a7308ULL, 0x008ee40000001000ULL, 0x0ffffffe1a1d7810ULL, 0x008fcc0007ffe0ffULL,
0x0000001d00197305ULL, 0x000ee4000021f000ULL, 0x000000ffff1b7224ULL, 0x008fc800078e0a19ULL,
0x00005a001b1b7a24ULL, 0x000fc800078e02ffULL, 0x0000001b19637227ULL, 0x000fe200078e0018ULL,
0x0000000810197810ULL, 0x000fca0007ffe0ffULL, 0x00000019631b7227ULL, 0x000fc800078e00ffULL,
0x0000001063187227ULL, 0x000fc800078e00ffULL, 0x000000ffff1a7224ULL, 0x000fe400078e0a1bULL,
0x000000ffff1f7224ULL, 0x000fe400078e0a18ULL, 0x00005a001a1a7a24ULL, 0x000fe400078e0219ULL,
0x00005a001f197a24ULL, 0x000fe200078e0210ULL, 0x0000001104107217ULL, 0x000fe20007800000ULL,
0x0000001c631d7227ULL, 0x000fe200078e00ffULL, 0x00005a001a007a0cULL, 0x000fe40003fa6070ULL,
0x00005a0019007a0cULL, 0x000fe20003f06070ULL, 0x000000ffff217224ULL, 0x000fc400078e0a1dULL,
0x0000001e631f7227ULL, 0x000fc800078e00ffULL, 0x00005a00211c7a24ULL, 0x000fe400078e021cULL,
0x000000ffff217224ULL, 0x000fe400078e0a1fULL, 0x80005a001a1a5a10ULL, 0x000fe20007ffe0ffULL,
0x0000000110637824ULL, 0x000fe200078e0a11ULL, 0x00005a001c007a0cULL, 0x000fe20003f26070ULL,
0x00005a00211e7a24ULL, 0x000fe200078e021eULL, 0x80005a0019190a10ULL, 0x000fe20007ffe0ffULL,
0x0000000166107824ULL, 0x000fe200078e0a63ULL, 0x00005a001a007a0cULL, 0x000fe20003fc6070ULL,
0x000000010e1a7824ULL, 0x000fe200078e0264ULL, 0x00005a0019007a0cULL, 0x000fc40003f46070ULL,
0x00005a001e007a0cULL, 0x000fe40003f66070ULL, 0x0000000118180810ULL, 0x000fe40007ffe0ffULL,
0x000000011b1b5810ULL, 0x000fe40007ffe0ffULL, 0x80005a001c1c1a10ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL, 0x00005a001c007a0cULL, 0x000fc40003f86070ULL,
0x00005a00ff1c7a12ULL, 0x000fe400078e33ffULL, 0x0000000118182810ULL, 0x000fe40007ffe0ffULL,
0x000000631a00720cULL, 0x040fe20003f06070ULL, 0x000000011a1a7824ULL, 0x000fe200078e0a63ULL,
0x80005a001e1e3a10ULL, 0x000fe40007ffe0ffULL, 0x000000181c187207ULL, 0x000fe40006800000ULL,
0x00005a001e007a0cULL, 0x000fc40003f46070ULL, 0x0000001a0d1a7217ULL, 0x000fe40003800000ULL,
0x000000011b1b6810ULL, 0x000fe40007ffe0ffULL, 0x000000180d187217ULL, 0x040fe40003800000ULL,
0x000000636600720cULL, 0x000fe40003fc6070ULL, 0x000000100d107217ULL, 0x000fe20003800000ULL,
0x000000180b8c7224ULL, 0x000fe200078e02ffULL, 0x000000011d1d1810ULL, 0x000fc40007ffe0ffULL,
0x00000004ff1a7819ULL, 0x000fe4000001161aULL, 0x000000ff10737207ULL, 0x000fe40003000000ULL,
0x000000011d1d4810ULL, 0x000fe40007ffe0ffULL, 0x0000001b1c107207ULL, 0x000fe40006800000ULL,
0x000000011f1f3810ULL, 0x000fe40007ffe0ffULL, 0x000000ff1a197207ULL, 0x000fc40000000000ULL,
0x0000001d1c187207ULL, 0x000fe40006800000ULL, 0x000000100d107217ULL, 0x000fe20003800000ULL,
0x000000018c117824ULL, 0x000fe200078e0219ULL, 0x0000008c73697211ULL, 0x000fe400078fe0ffULL,
0x000000011f1f2810ULL, 0x000fe20007ffe0ffULL, 0x000000100b907224ULL, 0x000fe200078e02ffULL,
0x000000180d187217ULL, 0x000fe20003800000ULL, 0x0000000269687825ULL, 0x000fe200078e0082ULL,
0x0000001f1c1a7207ULL, 0x000fc60006800000ULL, 0x0000000211107825ULL, 0x000fe200078e0082ULL,
0x0000001a0d1c7217ULL, 0x000fe20003800000ULL, 0x0000000668687981ULL, 0x0046a4000c1e9500ULL,
0x000000180b927224ULL, 0x000fe200078e02ffULL, 0x0000001064707812ULL, 0x000fe200078efcffULL,
0x00000001191b7824ULL, 0x000fe200078e0290ULL, 0x0000000610657981ULL, 0x0002a2000c1e9500ULL,
0x0000001c0b947224ULL, 0x000fe200078e02ffULL, 0x00000092736d7211ULL, 0x000fe200078fe0ffULL,
0x000000021b1a7825ULL, 0x000fe200078e0082ULL, 0x00000090731d7211ULL, 0x000fc600078fe0ffULL,
0x00000001191f7824ULL, 0x040fe200078e0292ULL, 0x000000061a677981ULL, 0x0002a2000c1e9500ULL,
0x000000010e207824ULL, 0x000fe400078e0270ULL, 0x00000001196b7824ULL, 0x000fe400078e0294ULL,
0x000000026d6c7825ULL, 0x000fc800078e0082ULL, 0x000000021d187825ULL, 0x100fe400078e0082ULL,
0x000000066c6c7981ULL, 0x0006a4000c1e9500ULL, 0x000000021f107825ULL, 0x002fe400078e0082ULL,
0x00000006186a7981ULL, 0x0002a4000c1e9500ULL, 0x00000001201a7824ULL, 0x100fe400078e0a63ULL,
0x00000001706e7824ULL, 0x000fe200078e0200ULL, 0x0000000610697981ULL, 0x0086a4000c1e9500ULL,
0x0000001a0d1b7217ULL, 0x000fe20003800000ULL, 0x000000016e1a7824ULL, 0x000fe200078e0a63ULL,
0x0000009473217211ULL, 0x000fc400078fe0ffULL, 0x000000632000720cULL, 0x080fe40003f26070ULL,
0x00000004ff1b7819ULL, 0x000fe2000001161bULL, 0x000000026b1e7825ULL, 0x100fe200078e0082ULL,
0x000000636e00720cULL, 0x000fe40003f06070ULL, 0x0000001a0d1a7217ULL, 0x000fe20003800000ULL,
0x00000002211c7825ULL, 0x000fe200078e0082ULL, 0x000000ff1b1b7207ULL, 0x000fe20000800000ULL,
0x000000061e6b7981ULL, 0x0006a2000c1e9500ULL, 0x000000ff1a797207ULL, 0x000fc40000000000ULL,
0x00000020647a7812ULL, 0x000fe200078efcffULL, 0x000000061c727981ULL, 0x0006a2000c1e9500ULL,
0x000000011b197824ULL, 0x002fe200078e0290ULL, 0x0000008c79757211ULL, 0x040fe400078fe0ffULL,
0x0000009079777211ULL, 0x000fe200078fe0ffULL, 0x000000018c117824ULL, 0x008fe400078e021bULL,
0x0000000219187825ULL, 0x000fc800078e0082ULL, 0x000000010e1e7824ULL, 0x000fe200078e027aULL,
0x00000006186f7981ULL, 0x0002e2000c1e9500ULL, 0x0000000275747825ULL, 0x000fc800078e0082ULL,
0x0000000277767825ULL, 0x100fe200078e0082ULL, 0x00000094797f7211ULL, 0x000fe200078fe0ffULL,
0x0000000674747981ULL, 0x0002e4000c1e9500ULL, 0x0000000211107825ULL, 0x000fe400078e0082ULL,
0x0000000676767981ULL, 0x0002e4000c1e9500ULL, 0x000000011e187824ULL, 0x002fe400078e0a63ULL,
0x000000017a7c7824ULL, 0x000fe200078e0200ULL, 0x00000006106d7981ULL, 0x0002e2000c1e9500ULL,
0x00000092791f7211ULL, 0x000fc400078fe0ffULL, 0x000000180d197217ULL, 0x000fe20003800000ULL,
0x000000017c187824ULL, 0x000fe400078e0a63ULL, 0x000000011b1d7824ULL, 0x040fe400078e0292ULL,
0x000000011b217824ULL, 0x000fe200078e0294ULL, 0x000000631e00720cULL, 0x080fe20003f26070ULL,
0x000000027f7e7825ULL, 0x000fe200078e0082ULL, 0x00000004ff197819ULL, 0x000fe40000011619ULL,
0x000000637c00720cULL, 0x000fe20003f06070ULL, 0x000000021d1c7825ULL, 0x100fe200078e0082ULL,
0x000000180d187217ULL, 0x000fe20003800000ULL, 0x000000067e7e7981ULL, 0x0002e4000c1e9500ULL,
0x000000021f1a7825ULL, 0x100fe200078e0082ULL, 0x000000ff19197207ULL, 0x000fe20000800000ULL,
0x000000061c717981ULL, 0x0002e4000c1e9500ULL, 0x0000000221107825ULL, 0x002fc400078e0082ULL,
0x000000061a787981ULL, 0x0002e2000c1e9500ULL, 0x000000ff187f7207ULL, 0x000fc60000000000ULL,
0x0000000610757981ULL, 0x0002e2000c1e9500ULL, 0x0000000119817824ULL, 0x000fe200078e0290ULL,
0x000000907f1f7211ULL, 0x040fe400078fe0ffULL, 0x000000947f7b7211ULL, 0x000fe200078fe0ffULL,
0x0000000281807825ULL, 0x000fc800078e0082ULL, 0x000000018c117824ULL, 0x002fe200078e0219ULL,
0x0000008c7f217211ULL, 0x000fe200078fe0ffULL, 0x000000021f1e7825ULL, 0x100fe200078e0082ULL,
0x0000000680807981ULL, 0x0002e6000c1e9500ULL, 0x0000000211107825ULL, 0x000fe200078e0082ULL,
0x0000003064867812ULL, 0x000fc800078efcffULL, 0x0000000610777981ULL, 0x0002e2000c1e9500ULL,
0x00000001191d7824ULL, 0x000fe200078e0292ULL, 0x000000927f1b7211ULL, 0x000fe200078fe0ffULL,
0x0000000221207825ULL, 0x000fc800078e0082ULL, 0x000000027b107825ULL, 0x002fe200078e0082ULL,
0x0000000620847981ULL, 0x0002e8000c1e9500ULL, 0x000000061e7b7981ULL, 0x0002e2000c1e9500ULL,
0x0000000119197824ULL, 0x000fe400078e0294ULL, 0x000000010e8e7824ULL, 0x000fe200078e0286ULL,
0x0000000610de7981ULL, 0x0002e2000c1e9500ULL, 0x000000021d1c7825ULL, 0x000fc800078e0082ULL,
0x000000021b1a7825ULL, 0x100fe200078e0082ULL, 0x000000061c7d7981ULL, 0x0002e6000c1e9500ULL,
0x0000000219187825ULL, 0x000fe200078e0082ULL, 0x000000061a8a7981ULL, 0x0002e6000c1e9500ULL,
0x000000018e207824ULL, 0x002fe200078e0a63ULL, 0x00000006188f7981ULL, 0x0002e2000c1e9500ULL,
0x0000000186887824ULL, 0x000fc600078e0200ULL, 0x000000200d217217ULL, 0x040fe20003800000ULL,
0x0000000188207824ULL, 0x000fe200078e0a63ULL, 0x000000638e00720cULL, 0x080fe40003f26070ULL,
0x000000638800720cULL, 0x000fe40003f06070ULL, 0x00000004ff217819ULL, 0x000fe40000011621ULL,
0x000000200d207217ULL, 0x000fe40003800000ULL, 0x000000ff21857207ULL, 0x000fc40000800000ULL,
0x000000ff20817207ULL, 0x000fc60000000000ULL, 0x000000018c1f7824ULL, 0x000fe200078e0285ULL,
0x0000008c81217211ULL, 0x000fe200078fe0ffULL, 0x00000001851b7824ULL, 0x000fe200078e0292ULL,
0x00000092811d7211ULL, 0x000fe200078fe0ffULL, 0x000000021f1e7825ULL, 0x000fc800078e0082ULL,
0x0000000221207825ULL, 0x100fe200078e0082ULL, 0x000000061e877981ULL, 0x0002e6000c1e9500ULL,
0x000000021b1a7825ULL, 0x100fe200078e0082ULL, 0x0000000620c47981ULL, 0x0002e6000c1e9500ULL,
0x000000021d1c7825ULL, 0x000fe200078e0082ULL, 0x000000061a8d7981ULL, 0x0002e4000c1e9500ULL,
0x0000009081197211ULL, 0x002fc400078fe0ffULL, 0x000000061cdc7981ULL, 0x0002e2000c1e9500ULL,
0x0000000185117824ULL, 0x000fe400078e0290ULL, 0x0000000219187825ULL, 0x000fc800078e0082ULL,
0x0000000211107825ULL, 0x000fe200078e0082ULL, 0x0000000618da7981ULL, 0x0002e2000c1e9500ULL,
0x00000094811f7211ULL, 0x000fc600078fe0ffULL, 0x00000006108b7981ULL, 0x0002e2000c1e9500ULL,
0x0000000185217824ULL, 0x000fe400078e0294ULL, 0x000000021f1e7825ULL, 0x000fc800078e0082ULL,
0x0000000221207825ULL, 0x000fe200078e0082ULL, 0x000000061ee07981ULL, 0x0002e8000c1e9500ULL,
0x0000000620917981ULL, 0x0002e4000c1e9500ULL, 0xfffffff073107812ULL, 0x002fe200078ec0ffULL,
0x00000001ffd87424ULL, 0x000fc800078e00ffULL, 0x0000000163117824ULL, 0x000fc800078e0210ULL,
0x0000000166107824ULL, 0x000fe200078e0a11ULL, 0x00000001648c7812ULL, 0x000fc800078efcffULL,
0x00000010d8107219ULL, 0x000fe200000006ffULL, 0x000000018c187824ULL, 0x000fe200078e0200ULL,
0xfffffff0791a7812ULL, 0x000fc600078ec0ffULL, 0x0000000118197824ULL, 0x100fe200078e0a11ULL,
0x00000008648e7812ULL, 0x040fe200078efcffULL, 0x00000001631d7824ULL, 0x000fe200078e021aULL,
0x0000000964907812ULL, 0x000fe400078efcffULL, 0x00000019d81a7219ULL, 0x000fe200000006ffULL,
0x000000018e1c7824ULL, 0x100fe400078e0200ULL, 0x0000000190207824ULL, 0x000fe200078e0200ULL,
0xfffffff07f1e7812ULL, 0x000fe200078ec0ffULL, 0x000000011c1b7824ULL, 0x100fe200078e0a11ULL,
0xfffffff081927812ULL, 0x000fe200078ec0ffULL, 0x0000000120117824ULL, 0x000fe200078e0a11ULL,
0x0000001164967812ULL, 0x000fe200078efcffULL, 0x00000001631f7824ULL, 0x040fe200078e021eULL,
0x0000001bd81e7219ULL, 0x040fe200000006ffULL, 0x00000001637f7824ULL, 0x000fe200078e0292ULL,
0x00000011d8927219ULL, 0x000fe200000006ffULL, 0x0000000196987824ULL, 0x000fc400078e0200ULL,
0x000000016e117824ULL, 0x100fe400078e0a1dULL, 0x0000000198197824ULL, 0x000fe200078e0a1dULL,
0x0000541068657816ULL, 0x004fc80000000065ULL, 0x0000006510ff7212ULL, 0x000fc800078ac0ffULL,
0x000000636600720cULL, 0x000fc80002fa1470ULL, 0x000000636400720cULL, 0x000fe40002fa1070ULL,
0x000000651aff7212ULL, 0x000fe4000782c0ffULL, 0xff80000061617808ULL, 0x000fe40002800000ULL,
0x000054106a677816ULL, 0x000fe40000000067ULL, 0x000054106c697816ULL, 0x000fe40000000069ULL,
0x0000006710ff7212ULL, 0x000fc4000784c0ffULL, 0x0000006910ff7212ULL, 0x000fe4000788c0ffULL,
0x000000671aff7212ULL, 0x000fe400078ac0ffULL, 0x000000636600720cULL, 0x0c0fe40001741470ULL,
0x000000636600720cULL, 0x080fe40002781470ULL, 0x000000631800720cULL, 0x0c0fe40000f21470ULL,
0x000000631800720cULL, 0x000fc40002fa1470ULL, 0x000000636400720cULL, 0x0c0fe40001741070ULL,
0x000000636400720cULL, 0x080fe40002781070ULL, 0x000000638c00720cULL, 0x0c0fe40000f21070ULL,
0x000000638c00720cULL, 0x000fe40002fa1070ULL, 0x00005410726b7816ULL, 0x000fe4000000006bULL,
0xff80000046467808ULL, 0x000fc40001000000ULL, 0xff80000035357808ULL, 0x000fe40002000000ULL,
0xff8000005a5a7808ULL, 0x000fe40000800000ULL, 0xff80000052527808ULL, 0x000fe40002800000ULL,
0x000000651eff7212ULL, 0x000fe4000786c0ffULL, 0x0000006b10ff7212ULL, 0x000fe4000780c0ffULL,
0x000000691aff7212ULL, 0x000fc4000784c0ffULL, 0x0000006b1aff7212ULL, 0x000fe4000788c0ffULL,
0x0000006792ff7212ULL, 0x000fe4000782c0ffULL, 0x000000691eff7212ULL, 0x000fe400078ac0ffULL,
0x000000636600720cULL, 0x080fe40000701470ULL, 0x000000631800720cULL, 0x0c0fe40001741470ULL,
0x000000631800720cULL, 0x000fc40002781470ULL, 0x000000631c00720cULL, 0x0c0fe40001f61470ULL,
0x000000631c00720cULL, 0x080fe40002fa1470ULL, 0x000000632000720cULL, 0x080fe40000f21470ULL,
0x00000018649c7812ULL, 0x040fe400078efcffULL, 0x0000001964a27812ULL, 0x040fe400078efcffULL,
0x000000636400720cULL, 0x000fc40000701070ULL, 0x000000638c00720cULL, 0x0c0fe40001741070ULL,
0x000000638c00720cULL, 0x080fe40002781070ULL, 0x000000638e00720cULL, 0x0c0fe40001f61070ULL,
0x000000638e00720cULL, 0x080fe40002fa1070ULL, 0x000000639000720cULL, 0x000fe40000f21070ULL,
0x00000011d8947219ULL, 0x000fc400000006ffULL, 0x00000019d89a7219ULL, 0x000fe400000006ffULL,
0x00005410746d7816ULL, 0x008fe4000000006dULL, 0x00005410766f7816ULL, 0x000fe2000000006fULL,
0x000000019c9e7824ULL, 0x100fe200078e0200ULL, 0xff80000032327808ULL, 0x000fe20000000000ULL,
0x00000001a2a47824ULL, 0x000fe200078e0200ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff80000031317808ULL, 0x000fc40002000000ULL, 0xff80000062627808ULL, 0x000fe40001800000ULL,
0xff80000034347808ULL, 0x000fe40002800000ULL, 0xff80000049497808ULL, 0x000fe40000800000ULL,
0x000000671eff7212ULL, 0x000fe4000780c0ffULL, 0x0000006992ff7212ULL, 0x000fe4000784c0ffULL,
0x0000006b1eff7212ULL, 0x000fc4000788c0ffULL, 0x0000006b92ff7212ULL, 0x000fe4000786c0ffULL,
0x0000006d9aff7212ULL, 0x000fe400078ac0ffULL, 0x0000006f94ff7212ULL, 0x000fe2000782c0ffULL,
0x000000019e1b7824ULL, 0x100fe200078e0a1dULL, 0x000000631c00720cULL, 0x080fe20000701470ULL,
0x00000001a41d7824ULL, 0x000fe200078e0a1dULL, 0x000000631c00720cULL, 0x080fe40002781470ULL,
0x000000632000720cULL, 0x000fc40001741470ULL, 0x000000632000720cULL, 0x080fe40001f61470ULL,
0x000000636e00720cULL, 0x080fe40000f21470ULL, 0x000000639800720cULL, 0x080fe40002fa1470ULL,
0x000000638e00720cULL, 0x0c0fe40000701070ULL, 0x000000638e00720cULL, 0x080fe40002781070ULL,
0x000000639000720cULL, 0x000fc40001741070ULL, 0x000000639000720cULL, 0x080fe40001f61070ULL,
0x000000637000720cULL, 0x080fe40000f21070ULL, 0x000000639600720cULL, 0x000fe40002fa1070ULL,
0x0000001bd8a07219ULL, 0x040fe400000006ffULL, 0x0000001dd8a67219ULL, 0x000fe400000006ffULL,
0x0000541078717816ULL, 0x000fc40000000071ULL, 0x000054107e757816ULL, 0x000fe40000000075ULL,
0xff80000047477808ULL, 0x000fe40000000000ULL, 0xff8000002f2f7808ULL, 0x000fe40002000000ULL,
0xff80000036367808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fe40001800000ULL,
0xff80000048487808ULL, 0x000fc40000800000ULL, 0xff8000005c5c7808ULL, 0x000fe40002800000ULL,
0x0000006d94ff7212ULL, 0x080fe4000780c0ffULL, 0x0000006da0ff7212ULL, 0x000fe4000788c0ffULL,
0x0000007194ff7212ULL, 0x040fe4000784c0ffULL, 0x0000007594ff7212ULL, 0x000fe4000786c0ffULL,
0x000000719aff7212ULL, 0x000fc4000782c0ffULL, 0x0000006fa6ff7212ULL, 0x000fe200078ac0ffULL,
0x000000017c217824ULL, 0x000fe200078e0a1fULL, 0x000000636e00720cULL, 0x0c0fe40000701470ULL,
0x000000636e00720cULL, 0x0c0fe40001741470ULL, 0x000000636e00720cULL, 0x080fe40001f61470ULL,
0x000000639800720cULL, 0x080fe40000f21470ULL, 0x000000639e00720cULL, 0x000fc40002781470ULL,
0x00000063a400720cULL, 0x080fe40002fa1470ULL, 0x0000002164aa7812ULL, 0x000fe400078efcffULL,
0x000000637000720cULL, 0x0c0fe40000701070ULL, 0x000000637000720cULL, 0x0c0fe40001741070ULL,
0x000000637000720cULL, 0x080fe40001f61070ULL, 0x000000639600720cULL, 0x000fc40000f21070ULL,
0x000000639c00720cULL, 0x080fe40002781070ULL, 0x00000063a200720cULL, 0x000fe40002fa1070ULL,
0x00000021d8a87219ULL, 0x000fe400000006ffULL, 0x000054107b7b7816ULL, 0x000fe20000000080ULL,
0x00000001aaac7824ULL, 0x000fe200078e0200ULL, 0xff80000060607808ULL, 0x000fe40000000000ULL,
0xff80000037377808ULL, 0x000fc40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40001800000ULL,
0xff80000038387808ULL, 0x000fe40000800000ULL, 0xff8000005f5f7808ULL, 0x000fe40002000000ULL,
0xff8000004c4c7808ULL, 0x000fe40002800000ULL, 0x0000006f9aff7212ULL, 0x040fe4000780c0ffULL,
0x000000759aff7212ULL, 0x000fc4000784c0ffULL, 0x0000006fa0ff7212ULL, 0x000fe4000786c0ffULL,
0x00000071a6ff7212ULL, 0x040fe4000782c0ffULL, 0x00000075a6ff7212ULL, 0x000fe4000788c0ffULL,
0x0000007ba8ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001ac737824ULL, 0x000fe200078e0a1fULL,
0x000000639800720cULL, 0x0c0fe40000701470ULL, 0x000000639800720cULL, 0x000fc40001741470ULL,
0x000000639e00720cULL, 0x080fe40001f61470ULL, 0x00000063a400720cULL, 0x0c0fe40000f21470ULL,
0x00000063a400720cULL, 0x080fe40002781470ULL, 0x000000637c00720cULL, 0x000fe40002fa1470ULL,
0x0000002864b07812ULL, 0x040fe400078efcffULL, 0x0000002964b67812ULL, 0x000fc400078efcffULL,
0x000000639600720cULL, 0x0c0fe40000701070ULL, 0x000000639600720cULL, 0x080fe40001741070ULL,
0x000000639c00720cULL, 0x080fe40001f61070ULL, 0x00000063a200720cULL, 0x0c0fe40000f21070ULL,
0x00000063a200720cULL, 0x080fe40002781070ULL, 0x000000637a00720cULL, 0x000fc40002fa1070ULL,
0x00000073d8ae7219ULL, 0x000fe400000006ffULL, 0x0000541084777816ULL, 0x000fe40000000077ULL,
0x000054108a7d7816ULL, 0x000fe4000000007dULL, 0x00005410de8f7816ULL, 0x000fe2000000008fULL,
0x00000001b0b27824ULL, 0x100fe200078e0200ULL, 0xff80000050507808ULL, 0x000fe20000000000ULL,
0x00000001b6b87824ULL, 0x000fe200078e0200ULL, 0xff80000022227808ULL, 0x000fc40001000000ULL,
0xff8000004a4a7808ULL, 0x000fe40001800000ULL, 0xff8000003a3a7808ULL, 0x000fe40000800000ULL,
0xff8000002c2c7808ULL, 0x000fe40002000000ULL, 0xff8000004b4b7808ULL, 0x000fe40002800000ULL,
0x0000006592ff7212ULL, 0x000fe400078cc0ffULL, 0x00000071a0ff7212ULL, 0x000fc4000780c0ffULL,
0x00000075a0ff7212ULL, 0x000fe4000784c0ffULL, 0x00000077a8ff7212ULL, 0x040fe4000786c0ffULL,
0x0000007da8ff7212ULL, 0x040fe4000782c0ffULL, 0x0000008fa8ff7212ULL, 0x000fe4000788c0ffULL,
0x0000007daeff7212ULL, 0x000fe200078ac0ffULL, 0x00000001b2797824ULL, 0x100fe200078e0a1fULL,
0x000000632000720cULL, 0x080fe200037c1470ULL, 0x00000001b81f7824ULL, 0x000fe200078e0a1fULL,
0x000000639e00720cULL, 0x000fc40000701470ULL, 0x000000639e00720cULL, 0x080fe40001741470ULL,
0x000000637c00720cULL, 0x0c0fe40001f61470ULL, 0x000000637c00720cULL, 0x0c0fe40000f21470ULL,
0x000000637c00720cULL, 0x080fe40002781470ULL, 0x00000063ac00720cULL, 0x080fe40002fa1470ULL,
0x000000639000720cULL, 0x000fc400037c1070ULL, 0x000000639c00720cULL, 0x0c0fe40000701070ULL,
0x000000639c00720cULL, 0x080fe40001741070ULL, 0x000000637a00720cULL, 0x0c0fe40001f61070ULL,
0x000000637a00720cULL, 0x0c0fe40000f21070ULL, 0x000000637a00720cULL, 0x080fe40002781070ULL,
0x00000063aa00720cULL, 0x000fc40002fa1070ULL, 0x00000079d8b47219ULL, 0x040fe400000006ffULL,
0x0000001fd8ba7219ULL, 0x000fe400000006ffULL, 0xff8000005b5b7808ULL, 0x000fe40003000000ULL,
0xff80000039397808ULL, 0x000fe40000000000ULL, 0xff80000023237808ULL, 0x000fe40001000000ULL,
0xff8000005e5e7808ULL, 0x000fc40001800000ULL, 0xff8000003b3b7808ULL, 0x000fe40000800000ULL,
0xff8000002d2d7808ULL, 0x000fe40002000000ULL, 0xff8000003c3c7808ULL, 0x000fe40002800000ULL,
0x0000006da6ff7212ULL, 0x000fe400078cc0ffULL, 0x00000077aeff7212ULL, 0x080fe4000780c0ffULL,
0x00000077b4ff7212ULL, 0x000fc4000784c0ffULL, 0x0000007baeff7212ULL, 0x040fe4000786c0ffULL,
0x0000008faeff7212ULL, 0x000fe4000782c0ffULL, 0x0000007bb4ff7212ULL, 0x000fe4000788c0ffULL,
0x0000007dbaff7212ULL, 0x000fe200078ac0ffULL, 0x0000000188817824ULL, 0x000fe200078e0a7fULL,
0x00000063a400720cULL, 0x080fe400037c1470ULL, 0x00000063ac00720cULL, 0x000fc40000701470ULL,
0x00000063ac00720cULL, 0x0c0fe40001f61470ULL, 0x00000063ac00720cULL, 0x080fe40000f21470ULL,
0x00000063b200720cULL, 0x0c0fe40001741470ULL, 0x00000063b200720cULL, 0x080fe40002781470ULL,
0x00000063b800720cULL, 0x000fe40002fa1470ULL, 0x0000003164c87812ULL, 0x000fc400078efcffULL,
0x0000003864ce7812ULL, 0x040fe400078efcffULL, 0x0000003964d47812ULL, 0x000fe400078efcffULL,
0x00000063a200720cULL, 0x080fe400037c1070ULL, 0x00000063aa00720cULL, 0x0c0fe40000701070ULL,
0x00000063aa00720cULL, 0x0c0fe40001f61070ULL, 0x00000063aa00720cULL, 0x000fc40000f21070ULL,
0x00000063b000720cULL, 0x0c0fe40001741070ULL, 0x00000063b000720cULL, 0x080fe40002781070ULL,
0x00000063b600720cULL, 0x000fe40002fa1070ULL, 0x00000081d8c67219ULL, 0x000fe400000006ffULL,
0x00005410c4877816ULL, 0x000fe40000000087ULL, 0x00005410dc8d7816ULL, 0x000fe2000000008dULL,
0x00000001c8ca7824ULL, 0x100fe200078e0200ULL, 0xff8000005d5d7808ULL, 0x000fe20003000000ULL,
0x00000001ced07824ULL, 0x100fe200078e0200ULL, 0xff80000059597808ULL, 0x000fe20000000000ULL,
0x00000001d4d67824ULL, 0x000fe200078e0200ULL, 0xff80000051517808ULL, 0x000fc40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40000800000ULL, 0xff80000058587808ULL, 0x000fe40001000000ULL,
0xff8000004d4d7808ULL, 0x000fe40002000000ULL, 0xff8000003e3e7808ULL, 0x000fe40002800000ULL,
0x00000077baff7212ULL, 0x040fe400078cc0ffULL, 0x0000007bbaff7212ULL, 0x000fc4000780c0ffULL,
0x0000007db4ff7212ULL, 0x040fe4000786c0ffULL, 0x0000008fb4ff7212ULL, 0x080fe4000782c0ffULL,
0x0000008fbaff7212ULL, 0x000fe4000784c0ffULL, 0x00000087c6ff7212ULL, 0x040fe4000788c0ffULL,
0x0000008dc6ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001ca857824ULL, 0x100fe200078e0a7fULL,
0x00000063b200720cULL, 0x080fe20001f61470ULL, 0x00000001d0897824ULL, 0x100fe200078e0a7fULL,
0x00000063b200720cULL, 0x080fe20000f21470ULL, 0x00000001d67f7824ULL, 0x000fe200078e0a7fULL,
0x00000063b800720cULL, 0x000fc400037c1470ULL, 0x00000063b800720cULL, 0x0c0fe40000701470ULL,
0x00000063b800720cULL, 0x080fe40001741470ULL, 0x000000638800720cULL, 0x0c0fe40002781470ULL,
0x000000638800720cULL, 0x000fe40002fa1470ULL, 0x00000085d8cc7219ULL, 0x040fe400000006ffULL,
0x00000089d8d27219ULL, 0x000fc400000006ffULL, 0x00000063b000720cULL, 0x0c0fe40001f61070ULL,
0x00000063b000720cULL, 0x080fe40000f21070ULL, 0x00000063b600720cULL, 0x0c0fe400037c1070ULL,
0x00000063b600720cULL, 0x0c0fe40000701070ULL, 0x00000063b600720cULL, 0x080fe40001741070ULL,
0x000000638600720cULL, 0x000fc40002781070ULL, 0x000000638600720cULL, 0x000fe40002fa1070ULL,
0x0000007fd8d87219ULL, 0x000fe400000006ffULL, 0x00005410da8b7816ULL, 0x000fe4000000008bULL,
0xff8000003d3d7808ULL, 0x000fe40001800000ULL, 0xff80000025257808ULL, 0x000fe40000800000ULL,
0xff80000057577808ULL, 0x000fc40003000000ULL, 0xff8000004f4f7808ULL, 0x000fe40000000000ULL,
0xff80000026267808ULL, 0x000fe40001000000ULL, 0xff80000056567808ULL, 0x000fe40002000000ULL,
0xff80000042427808ULL, 0x000fe40002800000ULL, 0x00000087ccff7212ULL, 0x080fe4000786c0ffULL,
0x00000087d2ff7212ULL, 0x000fc4000782c0ffULL, 0x00000087d8ff7212ULL, 0x000fe400078cc0ffULL,
0x0000008bc6ff7212ULL, 0x080fe4000780c0ffULL, 0x0000008bccff7212ULL, 0x080fe4000784c0ffULL,
0x0000008bd2ff7212ULL, 0x000fe4000788c0ffULL, 0x0000008dccff7212ULL, 0x000fe400078ac0ffULL,
0x000000638800720cULL, 0x000fc40000701470ULL, 0x00000063ca00720cULL, 0x0c0fe40001f61470ULL,
0x00000063ca00720cULL, 0x0c0fe40001741470ULL, 0x00000063ca00720cULL, 0x080fe40002fa1470ULL,
0x00000063d000720cULL, 0x080fe40000f21470ULL, 0x00000063d600720cULL, 0x080fe400037c1470ULL,
0x00000063d000720cULL, 0x000fc40002781470ULL, 0x000000638600720cULL, 0x080fe40000701070ULL,
0x00000063c800720cULL, 0x0c0fe40001f61070ULL, 0x00000063c800720cULL, 0x0c0fe40001741070ULL,
0x00000063c800720cULL, 0x080fe40002fa1070ULL, 0x00000063ce00720cULL, 0x080fe40000f21070ULL,
0x00000063d400720cULL, 0x000fc400037c1070ULL, 0x00000063ce00720cULL, 0x000fe40002781070ULL,
0x00005410e0917816ULL, 0x000fe40000000091ULL, 0xff8000004e4e7808ULL, 0x000fe40000000000ULL,
0xff80000055557808ULL, 0x000fe40001800000ULL, 0xff80000045457808ULL, 0x000fe40001000000ULL,
0xff8000003f3f7808ULL, 0x000fc40002800000ULL, 0xff80000054547808ULL, 0x000fe40000800000ULL,
0xff80000053537808ULL, 0x000fe40003000000ULL, 0xff80000044447808ULL, 0x000fe40002000000ULL,
0x0000008bd8ff7212ULL, 0x000fe4000780c0ffULL, 0x0000008dd2ff7212ULL, 0x080fe4000786c0ffULL,
0x0000008dd8ff7212ULL, 0x000fc4000784c0ffULL, 0x00000091c6ff7212ULL, 0x080fe400078ac0ffULL,
0x00000091ccff7212ULL, 0x080fe4000782c0ffULL, 0x00000091d2ff7212ULL, 0x080fe400078cc0ffULL,
0x00000091d8ff7212ULL, 0x000fe4000788c0ffULL, 0x000000638800720cULL, 0x080fe40002fa1470ULL,
0x00000063ca00720cULL, 0x000fc40000f21470ULL, 0x00000063d000720cULL, 0x0c0fe40001f61470ULL,
0x00000063d000720cULL, 0x080fe400037c1470ULL, 0x00000063d600720cULL, 0x0c0fe40000701470ULL,
0x00000063d600720cULL, 0x0c0fe40001741470ULL, 0x00000063d600720cULL, 0x080fe40002781470ULL,
0x000000638600720cULL, 0x000fc40002fa1070ULL, 0x00000063c800720cULL, 0x080fe40000f21070ULL,
0x00000063d400720cULL, 0x080fe40000701070ULL, 0x00000063ce00720cULL, 0x0c0fe40001f61070ULL,
0x00000063ce00720cULL, 0x080fe400037c1070ULL, 0x00000063d400720cULL, 0x0c0fe40001741070ULL,
0x00000063d400720cULL, 0x000fc40002781070ULL, 0xff80000043437808ULL, 0x000fe40000000000ULL,
0xff80000040407808ULL, 0x000fe40001800000ULL, 0xff80000041417808ULL, 0x000fe40001000000ULL,
0xff80000027277808ULL, 0x000fe40002800000ULL, 0xff80000028287808ULL, 0x000fe40000800000ULL,
0xff80000029297808ULL, 0x000fc40003000000ULL, 0xff8000002a2a7808ULL, 0x000fc40002000000ULL,
0x000000611400720bULL, 0x004fe40003f1e000ULL, 0x000000461500720bULL, 0x000fe40003f3e000ULL,
0x000000351600720bULL, 0x000fe40003f5e000ULL, 0x000000321700720bULL, 0x000fe40003f7e000ULL,
0x0000001461117208ULL, 0x000fe40004000000ULL, 0x0000001546157208ULL, 0x000fc40004800000ULL,
0x0000001635167208ULL, 0x000fe40005000000ULL, 0x0000001732107208ULL, 0x000fe40005800000ULL,
0x0000005a1100720bULL, 0x000fe40003f1e000ULL, 0x000000521500720bULL, 0x000fe40003f3e000ULL,
0x000000331600720bULL, 0x000fe40003f5e000ULL, 0x000000311000720bULL, 0x000fc40003f7e000ULL,
0x000000115a117208ULL, 0x000fe40004000000ULL, 0x0000001552147208ULL, 0x000fe40004800000ULL,
0x0000001633157208ULL, 0x000fe40005000000ULL, 0x0000001031107208ULL, 0x000fe40005800000ULL,
0x000000621100720bULL, 0x000fe40003f1e000ULL, 0x000000471400720bULL, 0x000fc40003f3e000ULL,
0x000000341500720bULL, 0x000fe40003f5e000ULL, 0x0000002f1000720bULL, 0x000fe40003f7e000ULL,
0x0000001162167208ULL, 0x000fe40004000000ULL, 0x0000001447147208ULL, 0x000fe40004800000ULL,
0x0000001534157208ULL, 0x000fe40005000000ULL, 0x000000102f117208ULL, 0x000fc40005800000ULL,
0x0000005b1600720bULL, 0x000fe40003f1e000ULL, 0x000000491400720bULL, 0x000fe40003f3e000ULL,
0x000000361500720bULL, 0x000fe40003f5e000ULL, 0x000000301100720bULL, 0x000fe40003f7e000ULL,
0x000000165b177208ULL, 0x000fe40004000000ULL, 0x0000001449197208ULL, 0x000fc40004800000ULL,
0x0000001536107208ULL, 0x000fe40005000000ULL, 0x0000001130117208ULL, 0x000fe40005800000ULL,
0x000000601700720bULL, 0x000fe40003f1e000ULL, 0x000000481900720bULL, 0x000fe40003f3e000ULL,
0x000000371000720bULL, 0x000fe40003f5e000ULL, 0x0000002e1100720bULL, 0x000fc40003f7e000ULL,
0x0000001760177208ULL, 0x000fe40004000000ULL, 0x0000001948197208ULL, 0x000fe40004800000ULL,
0x0000001037157208ULL, 0x000fe40005000000ULL, 0x000000112e117208ULL, 0x000fe40005800000ULL,
0x0000005c1700720bULL, 0x000fe40003f1e000ULL, 0x000000501900720bULL, 0x000fc40003f3e000ULL,
0x000000381500720bULL, 0x000fe40003f5e000ULL, 0x000000221100720bULL, 0x000fe40003f7e000ULL,
0x000000175c107208ULL, 0x000fe40004000000ULL, 0x0000001950197208ULL, 0x000fe40004800000ULL,
0x0000001538147208ULL, 0x000fe40005000000ULL, 0x0000001122167208ULL, 0x000fc40005800000ULL,
0x0000005f1000720bULL, 0x000fe40003f1e000ULL, 0x0000004a1900720bULL, 0x000fe40003f3e000ULL,
0x000000391400720bULL, 0x000fe40003f5e000ULL, 0x000000231600720bULL, 0x000fe40003f7e000ULL,
0x000000105f107208ULL, 0x000fe40004000000ULL, 0x000000194a197208ULL, 0x000fc40004800000ULL,
0x0000001439117208ULL, 0x000fe40005000000ULL, 0x0000001623157208ULL, 0x000fe40005800000ULL,
0x0000005d1000720bULL, 0x000fe40003f1e000ULL, 0x0000004c1900720bULL, 0x000fe40003f3e000ULL,
0x0000003a1100720bULL, 0x000fe40003f5e000ULL, 0x0000002c1500720bULL, 0x000fc40003f7e000ULL,
0x000000105d177208ULL, 0x000fe40004000000ULL, 0x000000194c107208ULL, 0x000fe40004800000ULL,
0x000000113a147208ULL, 0x000fe40005000000ULL, 0x000000152c167208ULL, 0x000fe40005800000ULL,
0x0000005e1700720bULL, 0x000fe40003f1e000ULL, 0x0000004b1000720bULL, 0x000fc40003f3e000ULL,
0x0000003b1400720bULL, 0x000fe40003f5e000ULL, 0x0000002d1600720bULL, 0x000fe40003f7e000ULL,
0x000000175e187208ULL, 0x000fe40004000000ULL, 0x000000104b107208ULL, 0x000fe40004800000ULL,
0x000000143b117208ULL, 0x000fe40005000000ULL, 0x000000162d167208ULL, 0x000fc40005800000ULL,
0x000000591800720bULL, 0x000fe40003f1e000ULL, 0x000000511000720bULL, 0x000fe40003f3e000ULL,
0x0000003c1100720bULL, 0x000fe40003f5e000ULL, 0x0000002b1600720bULL, 0x000fe40003f7e000ULL,
0x0000001859157208ULL, 0x000fe40004000000ULL, 0x0000001051107208ULL, 0x000fc40004800000ULL,
0x000000113c147208ULL, 0x000fe40005000000ULL, 0x000000162b167208ULL, 0x000fe40005800000ULL,
0x000000581500720bULL, 0x000fe40003f1e000ULL, 0x0000004d1000720bULL, 0x000fe40003f3e000ULL,
0x0000003d1400720bULL, 0x000fe40003f5e000ULL, 0x000000251600720bULL, 0x000fc40003f7e000ULL,
0x0000001558187208ULL, 0x000fe40004000000ULL, 0x000000104d107208ULL, 0x000fe40004800000ULL,
0x000000143d117208ULL, 0x000fe40005000000ULL, 0x0000001625157208ULL, 0x000fe40005800000ULL,
0x0000004f1000720bULL, 0x000fe40003f3e000ULL, 0x0000003e1100720bULL, 0x000fc40003f5e000ULL,
0x000000571800720bULL, 0x000fe40003f1e000ULL, 0x000000261500720bULL, 0x000fe40003f7e000ULL,
0x000000104f197208ULL, 0x000fe40004800000ULL, 0x000000113e117208ULL, 0x000fe40005000000ULL,
0x0000001857177208ULL, 0x000fe40004000000ULL, 0x0000001526107208ULL, 0x000fc40005800000ULL,
0x000000421100720bULL, 0x000fe40003f5e000ULL, 0x000000561700720bULL, 0x000fe40003f1e000ULL,
0x0000004e1900720bULL, 0x000fe40003f3e000ULL, 0x000000271000720bULL, 0x000fe40003f7e000ULL,
0x0000001142187208ULL, 0x000fe40005000000ULL, 0x0000001756147208ULL, 0x000fc40004000000ULL,
0x000000194e167208ULL, 0x000fe40004800000ULL, 0x0000001027117208ULL, 0x000fe40005800000ULL,
0x000000551400720bULL, 0x000fe40003f1e000ULL, 0x000000451600720bULL, 0x000fe40003f3e000ULL,
0x0000003f1800720bULL, 0x000fe40003f5e000ULL, 0x000000281100720bULL, 0x000fc40003f7e000ULL,
0x0000001455157208ULL, 0x000fe40004000000ULL, 0x0000001645177208ULL, 0x000fe40004800000ULL,
0x000000183f197208ULL, 0x000fe40005000000ULL, 0x0000001128107208ULL, 0x000fe40005800000ULL,
0x000000541500720bULL, 0x000fe40003f1e000ULL, 0x000000441700720bULL, 0x000fc40003f3e000ULL,
0x000000401900720bULL, 0x000fe40003f5e000ULL, 0x000000291000720bULL, 0x000fe40003f7e000ULL,
0x0000001554147208ULL, 0x000fe40004000000ULL, 0x0000001744167208ULL, 0x000fe40004800000ULL,
0x0000001940187208ULL, 0x000fe40005000000ULL, 0x0000001029117208ULL, 0x000fc40005800000ULL,
0x000000531400720bULL, 0x000fe40003f1e000ULL, 0x000000431600720bULL, 0x000fe40003f3e000ULL,
0x000000411800720bULL, 0x000fe40003f5e000ULL, 0x0000002a1100720bULL, 0x000fe40003f7e000ULL,
0x0000001453197208ULL, 0x000fe40004000000ULL, 0x0000001643177208ULL, 0x000fc40004800000ULL,
0x00000018411b7208ULL, 0x000fe40005000000ULL, 0x000000112a1d7208ULL, 0x000fe20005800000ULL,
0x000025827f007947ULL, 0x000fea000b800000ULL, 0x0c401f0019107f89ULL, 0x0004e400000e0000ULL,
0x000000101900720bULL, 0x008fc80003f1e000ULL, 0x00000019101c7208ULL, 0x000fe20004000000ULL,
0x000025b27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0017107f89ULL, 0x000ee800000e0000ULL,
0x0c401f001b117f89ULL, 0x000e6800000e0000ULL, 0x0c401f001d147f89ULL, 0x000ea800000e0000ULL,
0x0c201f001c157f89ULL, 0x000ea200000e0000ULL, 0x000000101700720bULL, 0x008fc40003f1e000ULL,
0x000000111b00720bULL, 0x002fe40003f3e000ULL, 0x0000001710107208ULL, 0x000fe40004000000ULL,
0x0000001b11117208ULL, 0x000fe40004800000ULL, 0x000000141d00720bULL, 0x004fe20003f1e000ULL,
0x0c201f0010197f89ULL, 0x000e6600000e0000ULL, 0x0000001d14177208ULL, 0x000fe20004000000ULL,
0x0c201f0011167f89ULL, 0x000ea200000e0000ULL, 0x000000151c00720bULL, 0x000fc60003f1e000ULL,
0x0c201f0017187f89ULL, 0x0006e200000e0000ULL, 0x0000001c15147208ULL, 0x000fe40004000000ULL,
0x000000191000720bULL, 0x002fe40003f3e000ULL, 0x000000161100720bULL, 0x004fe40003f5e000ULL,
0x0000001019157208ULL, 0x000fe40004800000ULL, 0x0000001116167208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b14107820ULL, 0x008fe20000410000ULL, 0x000000181700720bULL, 0x004fe20003f1e000ULL,
0x3f80000000047882ULL, 0x000fc40000000000ULL, 0x3fb8aa3b5a5a7823ULL, 0x100fe20000010810ULL,
0x0000001718177208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b61617823ULL, 0x100fe20000010810ULL,
0x000000030aff7812ULL, 0x000fe2000780c0ffULL, 0x0000005a001a7308ULL, 0x0023e20000000800ULL,
0x3fb8aa3b62627823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b5b5b7823ULL, 0x100fe40000010810ULL,
0x3fb8aa3b60607823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b5c5c7823ULL, 0x100fe20000010810ULL,
0x0000006100617308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b5f5f7823ULL, 0x000fc40000010810ULL,
0x3fb8aa3b5d5d7823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b5e5a7823ULL, 0x102fe40000010810ULL,
0x3fb8aa3b59597823ULL, 0x100fe20000010810ULL, 0x0000005f001e7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b58587823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b57577823ULL, 0x100fe40000010810ULL,
0x3fb8aa3b56567823ULL, 0x000fc40000010810ULL, 0x3fb8aa3b55557823ULL, 0x100fe20000010810ULL,
0x00000060001c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b54547823ULL, 0x000fe20000010810ULL,
0x00000002ff5f7819ULL, 0x002fe2000001160aULL, 0x3fb8aa3b53537823ULL, 0x000fe40000010810ULL,
0x3fb8aa3b15107820ULL, 0x000fe20000410000ULL, 0x000000015f187810ULL, 0x040fe20007ffe0ffULL,
0x000000085f667824ULL, 0x040fe200078e00ffULL, 0x0000005c00117308ULL, 0x000e620000000800ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010810ULL, 0x000000105f6a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b52527823ULL, 0x000fc40000010810ULL, 0x3fb8aa3b47477823ULL, 0x100fe40000010810ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010810ULL, 0x0000004600197308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b48487823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b50507823ULL, 0x100fe40000010810ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010810ULL,
0x0000004900207308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010810ULL,
0x0000001c111c723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b51517823ULL, 0x000fc40000010810ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010810ULL,
0x0000006200627308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4e467823ULL, 0x104fe40000010810ULL,
0x3fb8aa3b45457823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b44447823ULL, 0x100fe40000010810ULL,
0x3fb8aa3b43437823ULL, 0x000fe20000010810ULL, 0x0000005b005b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b16107820ULL, 0x000fc40000410000ULL, 0x3fb8aa3b174e7820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b35357823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010810ULL,
0x0000005200527308ULL, 0x000e620000000800ULL, 0x3fb8aa3b34347823ULL, 0x100fe40000010810ULL,
0x3fb8aa3b36367823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b37377823ULL, 0x000fc40000010810ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010810ULL, 0x00000047001b7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b39397823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe40000010810ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010810ULL,
0x0000004a001f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010810ULL,
0x000000195219723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b3e3e7823ULL, 0x000fc40000010810ULL,
0x3fb8aa3b42427823ULL, 0x100fe40000010810ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010810ULL,
0x00000033004a7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010810ULL,
0x0000001b201b723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b41107823ULL, 0x000fe40000010810ULL,
0x3fb8aa3b32327823ULL, 0x100fe4000001084eULL, 0x3fb8aa3b31317823ULL, 0x000fe2000001084eULL,
0x0000003f00497308ULL, 0x0005e20000000800ULL, 0x000000085f337824ULL, 0x002fc400078e00ffULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe4000001084eULL, 0x3fb8aa3b30307823ULL, 0x000fe2000001084eULL,
0xfffffff8335e7812ULL, 0x000fe200078ee218ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001084eULL,
0x0000001000417308ULL, 0x0003e20000000800ULL, 0x000000085f3f7824ULL, 0x044fe200078e00ffULL,
0x000000025f187810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001084eULL,
0x000000045f337810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b26267823ULL, 0x000fc4000001084eULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001084eULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x000000035f107810ULL, 0x002fe20007ffe0ffULL, 0x3fb8aa3b27277823ULL, 0x000fe2000001084eULL,
0xfffffff866667812ULL, 0x000fe200078ee233ULL, 0x000000085f527824ULL, 0x000fe200078e00ffULL,
0xfffffff83f647812ULL, 0x000fe200078ee210ULL, 0x00000004ff107e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000003600217308ULL, 0x000e660000000800ULL,
0x3f8000001010783eULL, 0x000fca00000010ffULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x000000ffff117224ULL, 0x100fe400078e0010ULL, 0x000000ffff687224ULL, 0x100fe400078e0010ULL,
0x000000ffff697224ULL, 0x100fe400078e0010ULL, 0x000000ffff6c7224ULL, 0x100fe200078e0010ULL,
0x0000003100317308ULL, 0x000ea20000000800ULL, 0x000000ffff6d7224ULL, 0x000fce00078e0010ULL,
0x0000003700477308ULL, 0x0007f00000000800ULL, 0x0000003500357308ULL, 0x000ea20000000800ULL,
0x000000085f377824ULL, 0x008fca00078e00ffULL, 0xfffffff837607812ULL, 0x000fe200078ee218ULL,
0x3fb8aa3b22377823ULL, 0x000fe2000001084eULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x000000611a18723eULL, 0x000fe400000010ffULL, 0x000000625b1a723eULL, 0x000fe200000010ffULL,
0x000000085f5b7824ULL, 0x000fe200078e00ffULL, 0x000000342122723eULL, 0x002fe200000010ffULL,
0x000000ffff347224ULL, 0x100fe200078e0010ULL, 0x000000323121723eULL, 0x004fe200000010ffULL,
0x0000003000367308ULL, 0x0002a20000000800ULL, 0x000000354a20723eULL, 0x000fe200000010ffULL,
0x000000ffff357224ULL, 0x000fcc00078e0010ULL, 0x0000004c004c7308ULL, 0x000ee20000000800ULL,
0x000000101830723cULL, 0x002b6e00000418ffULL, 0x0000005d005d7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b23117823ULL, 0x120fe2000001084eULL, 0x0000002f3623723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b2c2f7823ULL, 0x000fe2000001084eULL, 0xffffffff5f2c7810ULL, 0x000fc80007ffe0ffULL,
0x00000048001d7308ULL, 0x000fe20000000800ULL, 0x0000001f4c1f723eULL, 0x008fce00000010ffULL,
0x0000005000507308ULL, 0x000ea20000000800ULL, 0x0000001e5d1e723eULL, 0x002fe200000010ffULL,
0x000000085f5d7824ULL, 0x000fca00078e00ffULL, 0xfffffff85d627812ULL, 0x000fe200078ee22cULL,
0x00000037004a7308ULL, 0x0003f00000000800ULL, 0x0000003800387308ULL, 0x000ee20000000800ULL,
0x000000342034723cULL, 0x002f6200000418ffULL, 0x0000001d501d723eULL, 0x004fcc00000010ffULL,
0x0000003900397308ULL, 0x000fe20000000800ULL, 0x000000681c30723cULL, 0x000b6e0000041830ULL,
0x0000003a003a7308ULL, 0x000e620000000800ULL, 0x00000047382c723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b29477823ULL, 0x000fe2000001084eULL, 0x000000085f687810ULL, 0x020fca0007ffe0ffULL,
0x0000002e003f7308ULL, 0x0005f00000000800ULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0x000000055f2e7810ULL, 0x004fc80007ffe0ffULL, 0xfffffff85b507812ULL, 0x000fe200078ee22eULL,
0x000000ffff5b7224ULL, 0x000fe200078e0010ULL, 0x000000393a2e723eULL, 0x002fe200000010ffULL,
0x0000002f004c7308ULL, 0x000e620000000800ULL, 0x0000000868397824ULL, 0x000fca00078e00ffULL,
0xfffffff839687812ULL, 0x000fe400078ee268ULL, 0x0000005a005a7308ULL, 0x000ff00000000800ULL,
0x0000005900597308ULL, 0x000ea20000000800ULL, 0x000000114c2f723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b28117823ULL, 0x000fc4000001084eULL, 0x000000085f4c7824ULL, 0x000fc800078e00ffULL,
0x0000005800587308ULL, 0x000fe20000000800ULL, 0xfffffff84c4c7812ULL, 0x000fce00078ee25fULL,
0x0000005700577308ULL, 0x000fe20000000800ULL, 0x0000005a5928723eULL, 0x004fe200000010ffULL,
0x000000ffff5a7224ULL, 0x000fcc00078e0010ULL, 0x0000004b004b7308ULL, 0x000ff00000000800ULL,
0x00000051005c7308ULL, 0x0002b00000000800ULL, 0x0000004d004d7308ULL, 0x000fe20000000800ULL,
0x000000065f517810ULL, 0x002fc40007ffe0ffULL, 0x000000185f5f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff852527812ULL, 0x000fc600078ee251ULL, 0x0000004f00487308ULL, 0x0003e20000000800ULL,
0x0000004b5c29723eULL, 0x004fce00000010ffULL, 0x0000003b003b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2d4f7823ULL, 0x102fe2000001084eULL, 0x0000003f4a2d723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b2a4e7823ULL, 0x000fe2000001084eULL, 0x00000058572a723eULL, 0x000fe200000010ffULL,
0x000000086a3f7824ULL, 0x000fe400078e00ffULL, 0x000000085f587824ULL, 0x000fe200078e00ffULL,
0x0000003c003c7308ULL, 0x000e620000000800ULL, 0x0000006c2c34723cULL, 0x000f620000041834ULL,
0xfffffff83f6a7812ULL, 0x000fc400078ee26aULL, 0xfffffff858587812ULL, 0x000fc800078ee25fULL,
0x0000003d003d7308ULL, 0x000ff00000000800ULL, 0x0000003e003e7308ULL, 0x000ea20000000800ULL,
0x0000003b3c38723eULL, 0x002fce00000010ffULL, 0x0000004f004f7308ULL, 0x000ff00000000800ULL,
0x0000002b004a7308ULL, 0x0002e20000000800ULL, 0x0000003d3e3a723eULL, 0x004fce00000010ffULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x0000004d482b723eULL, 0x002fce00000010ffULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x0000005a2830723cULL, 0x000f620000041830ULL,
0x0000004f4a39723eULL, 0x008fcc00000010ffULL, 0x0000004600467308ULL, 0x000ff00000000800ULL,
0x0000004500457308ULL, 0x000ea20000000800ULL, 0x00000025263b723eULL, 0x002fe400000010ffULL,
0x0001200002257811ULL, 0x000fca00078e60ffULL, 0x0000004400447308ULL, 0x000fe20000000800ULL,
0x000000104c4c7824ULL, 0x100fe400078e0225ULL, 0x000000105e5e7824ULL, 0x100fe400078e0225ULL,
0x0000001060607824ULL, 0x100fe400078e0225ULL, 0x0000001064647824ULL, 0x000fe200078e0225ULL,
0x0000004300437308ULL, 0x000e620000000800ULL, 0x00000046453d723eULL, 0x004fe200000010ffULL,
0x000000ffff457224ULL, 0x000fc400078e0010ULL, 0x0000001066667824ULL, 0x100fe400078e0225ULL,
0x0000001050507824ULL, 0x100fe400078e0225ULL, 0x0000005600567308ULL, 0x000fe20000000800ULL,
0x0000001052527824ULL, 0x100fe400078e0225ULL, 0x0000001062627824ULL, 0x100fe400078e0225ULL,
0x0000001068687824ULL, 0x100fe400078e0225ULL, 0x000000106a6a7824ULL, 0x000fe200078e0225ULL,
0x0000005500557308ULL, 0x000ea20000000800ULL, 0x00000044433f723eULL, 0x002fe200000010ffULL,
0x000000ffff447224ULL, 0x000fc400078e0010ULL, 0x0000001058587824ULL, 0x000fc800078e0225ULL,
0x0000005400547308ULL, 0x000ff00000000800ULL, 0x0000005300537308ULL, 0x000e620000000800ULL,
0x00000056553c723eULL, 0x004fce00000010ffULL, 0x0000001100487308ULL, 0x0005f00000000800ULL,
0x0000004000407308ULL, 0x000ee20000000800ULL, 0x000000ffff117224ULL, 0x004fe200078e0010ULL,
0x00000054533e723eULL, 0x002fcc00000010ffULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x000000103834723cULL, 0x020bee0000041834ULL, 0x0000004200427308ULL, 0x000ea20000000800ULL,
0x0000000c24117812ULL, 0x020fe200078ec0ffULL, 0x000000443c30723cULL, 0x000f620000041830ULL,
0x000000404126723eULL, 0x008fe200000010ffULL, 0x000000ffff407224ULL, 0x000fc400078e0010ULL,
0x000000014c437824ULL, 0x000fe400078e0211ULL, 0x0000004700477308ULL, 0x000fe20000000800ULL,
0x000000274825723eULL, 0x002fe200000010ffULL, 0x000000ffff417224ULL, 0x000fe200078e0010ULL,
0x0000001843007388ULL, 0x000fe20000000800ULL, 0x00000001115e7824ULL, 0x040fe400078e025eULL,
0x0000000111607824ULL, 0x000fe400078e0260ULL, 0x0000004e004e7308ULL, 0x000e620000000800ULL,
0x000000424924723eULL, 0x004fe200000010ffULL, 0x0000000111647824ULL, 0x040fe200078e0264ULL,
0x0000001a5e007388ULL, 0x000fe20000000800ULL, 0x0000000111667824ULL, 0x000fc400078e0266ULL,
0x0000000111507824ULL, 0x040fe200078e0250ULL, 0x0000001c60007388ULL, 0x000fe20000000800ULL,
0x0000000111527824ULL, 0x040fe400078e0252ULL, 0x0000000111627824ULL, 0x040fe200078e0262ULL,
0x0000001e64007388ULL, 0x000fe20000000800ULL, 0x0000000111687824ULL, 0x040fe400078e0268ULL,
0x0000000111317824ULL, 0x060fe200078e026aULL, 0x0000002866007388ULL, 0x000fe20000000800ULL,
0x000000474e27723eULL, 0x002fe200000010ffULL, 0x0000000111587824ULL, 0x000fc400078e0258ULL,
0x0000002a50007388ULL, 0x000fe80000000800ULL, 0x000000402434723cULL, 0x000f620000041834ULL,
0x0000003c52007388ULL, 0x000fe80000000800ULL, 0x0000003e62007388ULL, 0x000fe80000000800ULL,
0x0000001968007388ULL, 0x000fe80000000800ULL, 0x0004001b5e007388ULL, 0x000fe80000000800ULL,
0x0004001d60007388ULL, 0x000fe80000000800ULL, 0x0004001f64007388ULL, 0x000fe60000000800ULL,
0x000000ffff337224ULL, 0x020fe200078e0036ULL, 0x0004002966007388ULL, 0x000fe80000000800ULL,
0x0004002b50007388ULL, 0x000fe80000000800ULL, 0x0004003d52007388ULL, 0x000fe80000000800ULL,
0x0004003f62007388ULL, 0x000fe80000000800ULL, 0x0000002031007388ULL, 0x0003e80000000800ULL,
0x000800225e007388ULL, 0x0005e80000000800ULL, 0x0008002c60007388ULL, 0x0005e20000000800ULL,
0x000000ffff317224ULL, 0x002fc600078e0032ULL, 0x0008002e64007388ULL, 0x0005e20000000800ULL,
0x000000ffff327224ULL, 0x000fc600078e0034ULL, 0x0008003866007388ULL, 0x0005e80000000800ULL,
0x0008003a50007388ULL, 0x0005e80000000800ULL, 0x0008002452007388ULL, 0x0005e80000000800ULL,
0x0008002662007388ULL, 0x0005e80000000800ULL, 0x0000002158007388ULL, 0x0005e80000000800ULL,
0x000c00235e007388ULL, 0x0005e80000000800ULL, 0x000c002d60007388ULL, 0x0005e80000000800ULL,
0x000c002f64007388ULL, 0x0005e80000000800ULL, 0x000c003966007388ULL, 0x0005e80000000800ULL,
0x000c003b50007388ULL, 0x0005e80000000800ULL, 0x000c002552007388ULL, 0x0005e80000000800ULL,
0x000c002762007388ULL, 0x0005e80000000800ULL, 0x01a0001413008388ULL, 0x0005e80000000c00ULL,
0x01a2003013008388ULL, 0x0005e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000bfff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000800bfff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00001000bfff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000010f0f7810ULL, 0x000fe20007ffe0ffULL, 0x00001800bfff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff107224ULL, 0x000fc400078e0012ULL, 0x000000060f00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff7ae000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff287807ULL, 0x008fe20004000000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001d15000297802ULL, 0x000fc40000000f00ULL,
0x000015f000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0028ULL,
0xfffe5b1000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20005800000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001d1b000297802ULL, 0x000fc40000000f00ULL,
0x0000159000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0028ULL,
0xfffe5b4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0012ULL,
0x0001d22000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000014d000007944ULL, 0x014fea0003c00000ULL,
0xfffe5bf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0012ULL,
0x0001d28000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000147000007944ULL, 0x016fea0003c00000ULL,
0xfffe5d0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0012ULL,
0x0001d2e000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000141000007944ULL, 0x01efea0003c00000ULL,
0xfffe5e1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0012ULL,
0x0001d34000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000013b000007944ULL, 0x01efea0003c00000ULL,
0xfffe5f1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x0001d3b000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0009ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000134000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0029ULL,
0xfffe631000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x0001d42000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000012d000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0029ULL, 0x0000001009297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x0001d49000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000126000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0029ULL,
0xfffe628000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x0001d50000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000011f000007944ULL, 0x01cfea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0029ULL, 0xfffe624000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x008fe20004000000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x0001d56000297802ULL, 0x000fc40000000f00ULL, 0x000011e000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff257224ULL, 0x000fe200078e0028ULL, 0xfffe92c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe20005800000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x0001d5c000297802ULL, 0x000fc40000000f00ULL, 0x0000118000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff727224ULL, 0x000fe200078e0028ULL, 0xfffe92f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0071ULL, 0x0001d63000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000010c000007944ULL, 0x004fea0003c00000ULL, 0xfffe93b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0071ULL, 0x0001d69000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000106000007944ULL, 0x006fea0003c00000ULL, 0xfffe94c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0071ULL, 0x0001d6f000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000100000007944ULL, 0x00efea0003c00000ULL, 0xfffe95d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0071ULL, 0x0001d75000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000fa000007944ULL, 0x00efea0003c00000ULL, 0xfffe96d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0013ULL, 0x0001d7c000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe400078e0026ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000f3000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0029ULL, 0xfffe9ad000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0013ULL, 0x0001d83000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000ec000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0029ULL,
0x0000001026297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0013ULL,
0x0001d8a000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000e5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0029ULL, 0xfffe9a4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0013ULL, 0x0001d91000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000de000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0029ULL,
0xfffe9a0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe20004000000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001d97000297802ULL, 0x000fc40000000f00ULL,
0x00000dd000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff737224ULL, 0x000fe200078e0028ULL,
0xfffec87000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20005800000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001d9d000297802ULL, 0x000fc40000000f00ULL,
0x00000d7000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff787224ULL, 0x000fe200078e0028ULL,
0xfffec8b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0021ULL,
0x0001da4000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000cb000007944ULL, 0x018fea0003c00000ULL,
0xfffec96000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0021ULL,
0x0001daa000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000c5000007944ULL, 0x01afea0003c00000ULL,
0xfffeca7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0021ULL,
0x0001db0000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000bf000007944ULL, 0x01afea0003c00000ULL,
0xfffecb8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0021ULL,
0x0001db6000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000b9000007944ULL, 0x01afea0003c00000ULL,
0xfffecc8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0013ULL,
0x0001dbd000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe400078e006cULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000b2000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0029ULL,
0xfffed05000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0013ULL,
0x0001dc4000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000ab000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0029ULL, 0x000000106c297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0013ULL, 0x0001dcb000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000a4000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0029ULL,
0xfffecfc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0013ULL,
0x0001dd2000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000009d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0029ULL, 0xfffecf8000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x004fe20004000000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x0001dd8000297802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0028ULL, 0xfffefda000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe20005800000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x0001dde000297802ULL, 0x000fc40000000f00ULL, 0x0000096000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff6c7224ULL, 0x000fe200078e0028ULL, 0xfffefde000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0017ULL, 0x0001de5000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000008a000007944ULL, 0x018fea0003c00000ULL, 0xfffefe9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0017ULL, 0x0001deb000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000084000007944ULL, 0x01afea0003c00000ULL, 0xfffeffa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0017ULL, 0x0001df1000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000007e000007944ULL, 0x01afea0003c00000ULL, 0xffff00b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0017ULL, 0x0001df7000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000078000007944ULL, 0x01afea0003c00000ULL, 0xffff01b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x0001dfe000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe400078e000dULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000071000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0029ULL, 0xffff05a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x0001e05000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0029ULL,
0x000000100d297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000aULL,
0x0001e0c000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0029ULL, 0xffff051000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x0001e13000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0029ULL,
0xffff04d000007947ULL, 0x000fea000383ffffULL, 0x00000002ff1a7424ULL, 0x000fe200078e00ffULL,
0x0001e1a000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff187424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0018ULL, 0xffffda2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff197224ULL, 0x006fe200078e0017ULL, 0x0001e22000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff1a7424ULL, 0x000fc400078e00ffULL, 0x0000001fff187424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x010fea0003c00000ULL,
0x000000181700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff197224ULL, 0x002fe200078e001bULL,
0x0001e2a000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000001718157208ULL, 0x000fe20004000000ULL, 0x0000001fff187424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x000000181b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff197224ULL, 0x002fe200078e001dULL,
0x0001e32000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000001b181b7208ULL, 0x000fe20004000000ULL, 0x0000001fff187424ULL, 0x000fc400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000181d00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff197224ULL, 0x002fe200078e001cULL,
0x0001e3a000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000001d18177208ULL, 0x000fe20004000000ULL, 0x0000001fff187424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000181c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff197224ULL, 0x002fe200078e0015ULL,
0x0001e42000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000001c18147208ULL, 0x000fe20004000000ULL, 0x0000001fff187424ULL, 0x000fc400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x000000181500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff197224ULL, 0x002fe200078e001bULL,
0x0001e4a000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000001518157208ULL, 0x000fe20004000000ULL, 0x0000001fff187424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000181b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff197224ULL, 0x002fe200078e0017ULL,
0x0001e52000107802ULL, 0x000fe20000000f00ULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000001b18167208ULL, 0x000fe20004000000ULL, 0x0000001fff187424ULL, 0x000fc400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffd81000007947ULL, 0x000fea000383ffffULL, 0x0180000022007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000047812ULL, 0x000fc800078ec0ffULL,
0x018000000400780cULL, 0x000fda0003f05070ULL, 0x0000002200008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0400720cULL, 0x040fe40003f25070ULL,
0x008000000400780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000005ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff22ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000022047812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fda000780c0ffULL, 0x0080000004000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0004ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe400078e0006ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffe195004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff117424ULL, 0x000fe200078e00ffULL,
0x0000001f00007348ULL, 0x000fe80003800000ULL, 0x0c00001a19187389ULL, 0x0002a200000e0018ULL,
0xfffe191010007950ULL, 0x000fea0003c3ffffULL, 0x0000002b00007348ULL, 0x000fe80003800000ULL,
0x000000292a297389ULL, 0x0002a400000e0070ULL, 0x000000ffff2a7224ULL, 0x002fc400078e0028ULL,
0x00000000ff2b7424ULL, 0x000fc800078e00ffULL, 0xfffe18c02a007950ULL, 0x000fea0003c3ffffULL,
0x000000012800780cULL, 0x000fe20003f65070ULL, 0x0000002a00007348ULL, 0x000fe80003800000ULL,
0x00000000ff2b7424ULL, 0x000fd000078e00ffULL, 0x0000000000287806ULL, 0x000fc800058e0100ULL,
0x0000002a28287212ULL, 0x000fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x000fc800078e0029ULL,
0xfffe18502a007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000568ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000350ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c88ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d48ULL,
0x00000000000008b0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001608ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001698ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000169cULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x000000000001e880ULL, 0xf900001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000020100ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000020140ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x00000000000204c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001698ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001ea68ULL,
0x000000000001ea68ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000020100ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000204c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_80_cubin_len = 132512;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
