/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000019b50ULL, 0x00000000000197d0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x0000000000017c80ULL, 0x0000000000000180ULL, 0x000b0022000004daULL, 0x0000000000017e00ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x0000000000017e40ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x0000000000017e90ULL, 0x00000000000000f0ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000017f80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00017c8000000000ULL, 0x0000040400000000ULL, 0x810c000001880400ULL, 0x005d8c0400288080ULL,
0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9208288080820828ULL,
0x2880809308288080ULL, 0x8084082880809b08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080849200ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x00017c8000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL,
0x2880808228808084ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880809208288080ULL, 0x809b082880809308ULL, 0x1628808090082880ULL, 0x0000031028808280ULL,
0x9092000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000011000000000ULL,
0x00017e0000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880809208288080ULL, 0x8093082880809b08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080939200ULL, 0x0000002cffffffffULL,
0x000001a000000000ULL, 0x00017e4000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x8092288080930900ULL, 0x0000000000002880ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880809308288080ULL, 0x8092082880809b08ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080929200ULL, 0x0000001cffffffffULL, 0x0000023800000000ULL,
0x00017e9000000000ULL, 0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL,
0x0008230400000080ULL, 0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL,
0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL,
0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL,
0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL, 0x0000007b00043704ULL,
0x0000001800080a04ULL, 0x0068190300680160ULL, 0x00000000000c1704ULL, 0x0021f0000060000aULL,
0x00000000000c1704ULL, 0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0011f00000500008ULL,
0x00000000000c1704ULL, 0x0081f00000300007ULL, 0x00000000000c1704ULL, 0x0021f00000280006ULL,
0x00000000000c1704ULL, 0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL,
0x00000000000c1704ULL, 0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL,
0x00000000000c1704ULL, 0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400801b03ULL, 0x0134290400000b70ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x01342804ffffffffULL, 0x00000450000002f0ULL, 0x00002830000005a0ULL, 0x00002a00000028e0ULL,
0x00002fd000002b60ULL, 0x0000305000003000ULL, 0x00005ec0000030a0ULL, 0x0000608000005f50ULL,
0x00006670000061e0ULL, 0x000066f0000066a0ULL, 0x0000939000006740ULL, 0x0000955000009430ULL,
0x00009b30000096b0ULL, 0x00009bb000009b60ULL, 0x0000c8a000009c00ULL, 0x0000ca600000c940ULL,
0x0000d0800000cbc0ULL, 0x0000d1000000d0b0ULL, 0x0000f2d00000d150ULL, 0x000165400000f2e0ULL,
0x0001659000016580ULL, 0x000165f0000165a0ULL, 0x0001663000016610ULL, 0x000172c000016640ULL,
0x0001735000017300ULL, 0x000173e000017390ULL, 0x0001748000017430ULL, 0x00017510000174c0ULL,
0x000175a000017550ULL, 0x00017640000175f0ULL, 0x000176d000017680ULL, 0x0001776000017710ULL,
0x00017800000177b0ULL, 0x0001789000017840ULL, 0x00017920000178d0ULL, 0x000179c000017970ULL,
0x00017a8000017a20ULL, 0x00017b4000017ae0ULL, 0x00017c0000017ba0ULL, 0x0440390400017c60ULL,
0x000000ff000003e0ULL, 0x003f01000000f600ULL, 0x0000000900000410ULL, 0x003f01200000f608ULL,
0x0000000900000500ULL, 0x003f01200000f688ULL, 0x0000000900000520ULL, 0x003f01200000f6a8ULL,
0x0000000900000530ULL, 0x003f01200000f6c8ULL, 0x000000ff00000bd0ULL, 0x003f01070000f600ULL,
0x0000000000000d80ULL, 0x003f010200000004ULL, 0x0000000000000e30ULL, 0x003f010100000000ULL,
0x0000006f00001620ULL, 0x003f01070000f6a8ULL, 0x0000006f00001730ULL, 0x003f01010000f6a8ULL,
0x0000000600001790ULL, 0x003f01010000f6c8ULL, 0x0000000c00001900ULL, 0x003f01050000f6ccULL,
0x0000000c00001ae0ULL, 0x003f01050000f6ccULL, 0x000000ff00002450ULL, 0x000501070000f6b0ULL,
0x000000ff000024d0ULL, 0x000501010000f6b0ULL, 0x0000000b00002530ULL, 0x003f01010000f608ULL,
0x0000000b00002550ULL, 0x003f01050000f60cULL, 0x0000000b00002720ULL, 0x003f01050000f60cULL,
0x0000002c00002d30ULL, 0x003f01050000f6acULL, 0x0000002c00002f00ULL, 0x003f01050000f6acULL,
0x00000010000050a0ULL, 0x003f010100000000ULL, 0x0000005500005100ULL, 0x003f01010000f688ULL,
0x0000000500005130ULL, 0x003f010500000004ULL, 0x00000005000052f0ULL, 0x003f010500000004ULL,
0x0000000c00005b10ULL, 0x003f01070000f6a8ULL, 0x0000000c00005ba0ULL, 0x003f01010000f6a8ULL,
0x0000000b00005c00ULL, 0x003f01010000f628ULL, 0x0000000b00005c20ULL, 0x003f01050000f62cULL,
0x0000000b00005df0ULL, 0x003f01050000f62cULL, 0x00000038000063d0ULL, 0x003f01050000f6b4ULL,
0x00000038000065a0ULL, 0x003f01050000f6b4ULL, 0x0000000e00008520ULL, 0x003f010100000000ULL,
0x0000001200008580ULL, 0x003f01010000f690ULL, 0x00000005000085b0ULL, 0x003f010500000004ULL,
0x0000000500008770ULL, 0x003f010500000004ULL, 0x0000006f00008f70ULL, 0x003f01070000f6b0ULL,
0x0000000a00009070ULL, 0x003f01010000f6b0ULL, 0x0000000b000090d0ULL, 0x003f01010000f648ULL,
0x0000000b000090f0ULL, 0x003f01050000f64cULL, 0x0000000b000092c0ULL, 0x003f01050000f64cULL,
0x0000000b00009890ULL, 0x003f01050000f6acULL, 0x0000000b00009a60ULL, 0x003f01050000f6acULL,
0x000000100000ba40ULL, 0x003f010100000000ULL, 0x0000000b0000baa0ULL, 0x003f010100000000ULL,
0x000000050000bad0ULL, 0x003f010500000004ULL, 0x000000050000bc90ULL, 0x003f010500000004ULL,
0x000000ff0000c4f0ULL, 0x0004010700000000ULL, 0x0000006f0000c5a0ULL, 0x003f01010000f6a8ULL,
0x000000050000c600ULL, 0x003f01010000f668ULL, 0x000000050000c620ULL, 0x003f01050000f66cULL,
0x000000050000c7f0ULL, 0x003f01050000f66cULL, 0x0000006f0000cd80ULL, 0x003f01050000f6b4ULL,
0x0000006f0000cfa0ULL, 0x003f01050000f6b4ULL, 0x000000050000f0a0ULL, 0x003f010100000000ULL,
0x0000000c0000f120ULL, 0x003f010100000000ULL, 0x000000ff000104e0ULL, 0x003f01010000f600ULL,
0x000000ff00011140ULL, 0x003f01050000f604ULL, 0x000000ff00011350ULL, 0x003f01050000f604ULL,
0x000000ff00011580ULL, 0x003f01010000f600ULL, 0x000000ff000115b0ULL, 0x003f01050000f604ULL,
0x000000ff00011770ULL, 0x003f01050000f604ULL, 0x0000007900014900ULL, 0x003f010100000000ULL,
0x00000079000149a0ULL, 0x003f010500000004ULL, 0x0000007900014b70ULL, 0x003f010500000004ULL,
0x0000007c00017120ULL, 0x003f010100000000ULL, 0x0000007c00017180ULL, 0x003f010100000008ULL,
0x0000007c000171e0ULL, 0x003f010100000010ULL, 0x0000007c00017250ULL, 0x003f010100000018ULL,
0x00201c0400053803ULL, 0x0000fbc00000fb90ULL, 0x000100400000fe50ULL, 0x000103f000010240ULL,
0x00017290000117d0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000002acULL,
0x0000001b00000002ULL, 0x0000000000000214ULL, 0x0000001b00000002ULL, 0x000000000000018cULL,
0x0000001b00000002ULL, 0x00000000000000e4ULL, 0x0000001b00000002ULL, 0x0000000000000044ULL,
0x0000001b00000002ULL, 0x0000000000000289ULL, 0x0000001b00000002ULL, 0x00000000000001f1ULL,
0x0000001b00000002ULL, 0x0000000000000166ULL, 0x0000001b00000002ULL, 0x00000000000000c1ULL,
0x0000001b00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000087919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000087ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff050424ULL, 0x000fe200078e00ffULL,
0x0000000108020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e0005ULL,
0x00005c0008040625ULL, 0x000fe200078e0005ULL, 0x0000000802000981ULL, 0x0002a8000c1e1900ULL,
0x0000000804070981ULL, 0x0006a2000c1e1900ULL, 0x0000590000067b06ULL, 0x000f220000209000ULL,
0x00005900ff767624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000117919ULL, 0x000e680000002300ULL, 0x00000000000c7919ULL, 0x000e620000002200ULL,
0x0000000600067308ULL, 0x010f240000001000ULL, 0x0ffffffe060a7810ULL, 0x010fc40007ffe0ffULL,
0x0000000000067919ULL, 0x000f280000002100ULL, 0x0000000a000b7305ULL, 0x0002e4000021f000ULL,
0x000000ffff0a7224ULL, 0x002fe400078e00ffULL, 0x000000ffff097224ULL, 0x008fc800078e0a0bULL,
0x0000590009097a24ULL, 0x000fc800078e02ffULL, 0x000000090b0b7227ULL, 0x000fe400078e000aULL,
0x00000000000a7919ULL, 0x000e680000002600ULL, 0x000004000b0b7a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a0bULL, 0x0000040003027624ULL, 0x000fca00078e0276ULL,
0x0000590002007a0cULL, 0x000fda0003f26070ULL, 0x8000590002021a10ULL, 0x000fe40007ffe0ffULL,
0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL, 0x0000590002007a0cULL, 0x000fda0003f46070ULL,
0x000000010b0b2810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff0bba12ULL, 0x000fc800078e33ffULL,
0x0000000b00047306ULL, 0x000ee20000209000ULL, 0x000000ff0b00720cULL, 0x000fce0003f85070ULL,
0x0000000400047308ULL, 0x008ee40000001000ULL, 0x0ffffffe04027810ULL, 0x008fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x000664000021f000ULL, 0x000000ffff027224ULL, 0x008fe400078e00ffULL,
0x000000030b057224ULL, 0x002fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a05ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000000a03727227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a72ULL, 0x000000030b027224ULL, 0x000fe400078e020aULL,
0x0000010011037a24ULL, 0x000fe400078e020cULL, 0x00001fff11117589ULL, 0x000fe200000e0000ULL,
0x0000000b0200720cULL, 0x000fe20003fa6070ULL, 0x0000000003097a24ULL, 0x110fe200078e0206ULL,
0x00000005ff067819ULL, 0x000fc80000011606ULL, 0x000000ff0900720cULL, 0x040fe40003f65270ULL,
0x0000000f0900780cULL, 0x040fe40003f24070ULL, 0x0000007f0900780cULL, 0x000fc60003f44070ULL,
0x0000000102025824ULL, 0x000fe200078e0a0bULL, 0x0000000172725810ULL, 0x000fe40007ffe0ffULL,
0x000000030900780cULL, 0x000fe40003fa4070ULL, 0x0000000b0200720cULL, 0x000fe20003fc6070ULL,
0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff049424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00b388ULL, 0x000fe20000000a00ULL, 0x000000010900780cULL, 0x000fe20003f64070ULL,
0xff317217ff10a424ULL, 0x000fe400078e00ffULL, 0x00f6080409009388ULL, 0x000fe20000008a00ULL,
0x0000000172726810ULL, 0x000fe20007ffe0ffULL, 0x3fffff80ff0cd424ULL, 0x000fe200078e00ffULL,
0x0000000bff72c212ULL, 0x000fe200078e33ffULL, 0x00001fff06027589ULL, 0x000e6200000e0000ULL,
0x7fffff80ff0dd424ULL, 0x000fc600078e00ffULL, 0x000000ffff7b7224ULL, 0x000fe200078e0a72ULL,
0x00f400100900a388ULL, 0x0007e20000004800ULL, 0x3fffffc0ff0eb424ULL, 0x000fe400078e00ffULL,
0x0000007b0b7b7224ULL, 0x000fe400078e020aULL, 0x3fffff60ff0ad424ULL, 0x000fe400078e00ffULL,
0x000000107b7b7824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff0bd424ULL, 0x000fc400078e00ffULL,
0x00005a00ff107624ULL, 0x008fe400078e00ffULL, 0x7fffffc0ff0fb424ULL, 0x000fe200078e00ffULL,
0x00f6880a0900d388ULL, 0x000fe20000008a00ULL, 0x0000590010107a24ULL, 0x000fc600078e02ffULL,
0x00f6a80c0900d388ULL, 0x000fe80000008a00ULL, 0x00f6c80e0900b388ULL, 0x000fe20000008a00ULL,
0x0000000100000824ULL, 0x004fe400078e0a07ULL, 0x00005800ff008624ULL, 0x000fe400078e00ffULL,
0x0000580008078a24ULL, 0x000fe400078e02ffULL, 0x00005a0000047a24ULL, 0x000fc400078e02ffULL,
0x0000001007777224ULL, 0x000fe400078e02ffULL, 0x0000000104037824ULL, 0x040fe200078e0a7bULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000007b0400720cULL, 0x000fe20003f26070ULL,
0x00005a00720d7a24ULL, 0x000fe200078e0277ULL, 0x0000001003037817ULL, 0x000fc80003800000ULL,
0x000000ff03737207ULL, 0x000fe20000800000ULL, 0x0000000411037824ULL, 0x002fc600078e0202ULL,
0x000000107300780cULL, 0x000fe20003f05270ULL, 0x0000000203037824ULL, 0x000fd800078e00ffULL,
0x000002c000008947ULL, 0x000fea0003800000ULL, 0x00005a0000097b06ULL, 0x000e620000209000ULL,
0x0000000000487919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000900097308ULL, 0x002e620000001000ULL,
0x00000004ff067819ULL, 0x004fca0000011648ULL, 0x00000001030a7824ULL, 0x000fe200078e0206ULL,
0x0ffffffe09057810ULL, 0x002fcc0007ffe0ffULL, 0x0000000500057305ULL, 0x000e64000021f000ULL,
0x000000ffff0b7224ULL, 0x002fc800078e0a05ULL, 0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b050b7227ULL, 0x000fc800078e0004ULL, 0x000000017b047824ULL, 0x000fc800078e020aULL,
0x000000040b0b7227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a0bULL,
0x00005a0009057a24ULL, 0x000fe400078e0204ULL, 0x0000001048097824ULL, 0x000fc600078e00ffULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x000000010b0b0810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff0baa12ULL, 0x000fca00078e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a0bULL, 0x00005a0005047a24ULL, 0x000fc800078e0204ULL,
0x000000010d0c7824ULL, 0x000fe200078e0204ULL, 0x0000000373047217ULL, 0x000fc60007800000ULL,
0x000000100b057224ULL, 0x000fe200078e020cULL, 0x000000f0090b7812ULL, 0x000fe200078ec0ffULL,
0x0000000104037824ULL, 0x000fe400078e0a03ULL, 0x0000010005047825ULL, 0x000fc600078e00ffULL,
0x000000030600720cULL, 0x000fe20003f06070ULL, 0x000000010a037824ULL, 0x000fe200078e0248ULL,
0x0000000b040b7212ULL, 0x000fe200078efcffULL, 0x000000100a0a7824ULL, 0x000fc600078e00ffULL,
0x000060000b047a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00a037812ULL, 0x000fe400078ee203ULL,
0x0000610005057a10ULL, 0x000fc60000ffe4ffULL, 0x0000001003037824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e2000c101c48ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000000487919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000600067308ULL, 0x002e620000001000ULL,
0x0000000348037211ULL, 0x004fe400078fe0ffULL, 0x0ffffffe060a7810ULL, 0x002fca0007ffe0ffULL,
0x0000000a00057305ULL, 0x000e64000021f000ULL, 0x000000ffff097224ULL, 0x002fc800078e0a05ULL,
0x00005a0009097a24ULL, 0x000fc800078e02ffULL, 0x0000000905057227ULL, 0x000fc800078e0004ULL,
0x000000017b047824ULL, 0x000fc800078e0203ULL, 0x0000000405057227ULL, 0x000fc800078e00ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a05ULL, 0x00005a0009067a24ULL, 0x000fca00078e0204ULL,
0x00005a0006007a0cULL, 0x000fda0003f06070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe20003f26070ULL,
0x0000000103067824ULL, 0x040fe400078e0248ULL, 0x0000001003037824ULL, 0x000fca00078e00ffULL,
0xfffffff003067812ULL, 0x000fca00078ee206ULL, 0x0000000105051810ULL, 0x000fe20007ffe0ffULL,
0x0000001006037824ULL, 0x000fe200078e00ffULL, 0x00005a00ff05aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a05ULL, 0x00005a0009047a24ULL, 0x000fe400078e0204ULL,
0x0000001048097824ULL, 0x000fe400078e00ffULL, 0x000000010d047824ULL, 0x000fc600078e0204ULL,
0x000000f0090b7812ULL, 0x000fe200078ec0ffULL, 0x0000001005047224ULL, 0x000fc800078e0204ULL,
0x0000010004047825ULL, 0x000fca00078e00ffULL, 0x0000000b04047212ULL, 0x000fc800078efcffULL,
0x0000600004047a10ULL, 0x000fc80007f1e0ffULL, 0x0000610005057a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e8000b901c48ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x0000000000037806ULL, 0x000fe200038e0000ULL,
0x00000004ff437424ULL, 0x000fc600078e00ffULL, 0x0000000300047300ULL, 0x000e6200000e0000ULL,
0x00006800080a7625ULL, 0x000fce00078e0043ULL, 0x0000000300067309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe40003f02070ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff047224ULL, 0x004fd400078e0a06ULL, 0x00f60404ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000080a037981ULL, 0x000ea2000c1e1900ULL, 0x000000ff1100720cULL, 0x000fe40003f05270ULL,
0x0000007f03717810ULL, 0x044fe40007ffe0ffULL, 0x000000ff03107810ULL, 0x000fc40007ffe0ffULL,
0x00000007ff717819ULL, 0x000fe40000011671ULL, 0x00000008ff047819ULL, 0x002fca0000011610ULL,
0x0000f73000008947ULL, 0x000fea0003800000ULL, 0x00000003ff687819ULL, 0x000fe20000011602ULL,
0x00000003ff0b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff497424ULL, 0x000fe200078e00ffULL,
0x01ffffff68687812ULL, 0x000fc800078ec0ffULL, 0x000000716800720cULL, 0x000fda0003f06070ULL,
0x0000000208008824ULL, 0x000fe400078e00ffULL, 0x00006a00ff058624ULL, 0x000fc800078e00ffULL,
0x00006a0000058624ULL, 0x000fe200078e0205ULL, 0x0000f68802007811ULL, 0x000fc600078e18ffULL,
0x0000000168068824ULL, 0x000fe200078e0205ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040b00ff738cULL, 0x0003e20000000000ULL, 0x0000660006068625ULL, 0x000fe200078e0043ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000806498981ULL, 0x000ea2000c1e1900ULL,
0x000001ff1000780cULL, 0x000fe20003f04070ULL, 0x0000008072697824ULL, 0x000fe200078e00ffULL,
0x00000001ff4a7819ULL, 0x000fe20000011602ULL, 0x0000000000ff7f8cULL, 0x0007e2000c80043fULL,
0x0000000102707812ULL, 0x000fc600078ec0ffULL, 0x000000204a797824ULL, 0x000fca00078e00ffULL,
0x0000006069057812ULL, 0x000fe200078ef879ULL, 0x00005900490a7a24ULL, 0x004fc800078e02ffULL,
0x000000800a157824ULL, 0x000fe200078e00ffULL, 0x0000040000000947ULL, 0x000fea0003800000ULL,
0x0000007903007217ULL, 0x00afe20007800000ULL, 0x0000001070077824ULL, 0x000fe200078e00ffULL,
0x00000003ff067819ULL, 0x000fe40000011648ULL, 0x0000640015117a11ULL, 0x000fe200078838ffULL,
0x0000000100007824ULL, 0x000fe200078e0a79ULL, 0x00000004060c7810ULL, 0x040fe20007ffe0ffULL,
0x00000001070a7824ULL, 0x000fe200078e0206ULL, 0x0000000c060d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000700007217ULL, 0x000fe20007800000ULL, 0x000000010a0b7824ULL, 0x040fe200078e0248ULL,
0x0000650015157a11ULL, 0x000fe200020f3cffULL, 0x000000080a107824ULL, 0x000fc400078e00ffULL,
0x0000000100007824ULL, 0x000fe400078e0a07ULL, 0x00000001070e7824ULL, 0x040fe200078e020dULL,
0xfffffff810107812ULL, 0x000fe400078ee20bULL, 0x00000008060b7810ULL, 0x000fe20007ffe0ffULL,
0x000000080e147824ULL, 0x000fe200078e00ffULL, 0x000000000c00720cULL, 0x080fe20003f46070ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x000000000b00720cULL, 0x080fe20003f26070ULL,
0x00000001070b7824ULL, 0x000fe200078e020bULL, 0x000000000600720cULL, 0x080fe20003f66070ULL,
0x000000010c077824ULL, 0x040fe200078e0248ULL, 0x000000000d00720cULL, 0x000fe20003f06070ULL,
0x000000080c127824ULL, 0x000fc400078e00ffULL, 0x0000000105067824ULL, 0x000fe400078e020aULL,
0x000000010b0a7824ULL, 0x040fe200078e0248ULL, 0xfffffff812007812ULL, 0x000fe200078ee207ULL,
0x000000080b0f7824ULL, 0x000fe400078e00ffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff80f127812ULL, 0x000fe200078ee20aULL, 0x00000001050a7824ULL, 0x040fe200078e020cULL,
0x0000007006067812ULL, 0x000fe200078ef809ULL, 0x00000001050c7824ULL, 0x040fe400078e020bULL,
0x00000001050f7824ULL, 0x000fe200078e020eULL, 0x0000000611067210ULL, 0x000fe20007f9e0ffULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x000000010e057824ULL, 0x000fe200078e0248ULL,
0x000000700a0a7812ULL, 0x000fe200078ef809ULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fe400078ef809ULL, 0x0000b0004a057811ULL, 0x000fe200078e68ffULL,
0x0000000107077824ULL, 0x000fe200020e0615ULL, 0x000000700e097812ULL, 0x000fe400078ef809ULL,
0x000000110a0a7210ULL, 0x080fe20007f9e0ffULL, 0x0000001012137824ULL, 0x000fe200078e0205ULL,
0x000000110c0c7210ULL, 0x000fc40007fbe0ffULL, 0x00000011090e7210ULL, 0x000fe20007fde0ffULL,
0x0000001010097824ULL, 0x100fe400078e0205ULL, 0x0000001000117824ULL, 0x000fe400078e0205ULL,
0x000000010b0b7824ULL, 0x100fe200020e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000d901c48ULL, 0x000000010d0d7824ULL, 0x000fe400028e0615ULL,
0x0000001014057824ULL, 0x000fe200078e0205ULL, 0x000000000a117faeULL, 0x0003e2000d101c48ULL,
0x000000010f0f7824ULL, 0x000fc600030e0615ULL, 0x000000000c137faeULL, 0x0003e8000c901c48ULL,
0x000000000e057faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001070077824ULL, 0x008fe200078e00ffULL, 0x0000640015137a11ULL, 0x000fe400078038ffULL,
0x0000b0004a177811ULL, 0x000fe400078e68ffULL, 0x0000000748007211ULL, 0x002fc400078fe8ffULL,
0x0000650015157a11ULL, 0x000fe400000f3cffULL, 0x00000004000a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000100067824ULL, 0x140fe200078e0248ULL, 0x00000008000b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000800077824ULL, 0x000fe400078e00ffULL, 0x000000080a0e7824ULL, 0x040fe400078e00ffULL,
0x000000010b0c7824ULL, 0x000fe200078e0248ULL, 0xfffffff807107812ULL, 0x000fe200078ee206ULL,
0x000000010a077824ULL, 0x000fc400078e0248ULL, 0x0000000105067824ULL, 0x000fe200078e0200ULL,
0x0000000c00007810ULL, 0x000fe20007ffe0ffULL, 0x000000080b0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e117812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff80d127812ULL, 0x000fe200078ee20cULL, 0x00000001050a7824ULL, 0x040fe200078e020aULL,
0x0000007006067812ULL, 0x000fe200078ef809ULL, 0x00000001050c7824ULL, 0x040fe400078e020bULL,
0x00000001050e7824ULL, 0x000fe200078e0200ULL, 0x0000000613067210ULL, 0x000fe20007f1e0ffULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a0a7812ULL, 0x000fc600078ef809ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fc600078ef809ULL, 0x0000000100057824ULL, 0x000fe200078e0248ULL,
0x000000700e097812ULL, 0x000fe200078ef809ULL, 0x0000000800007824ULL, 0x000fe200078e00ffULL,
0x0000000c130c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000107077824ULL, 0x000fe200000e0615ULL,
0x0000000a130a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001011117824ULL, 0x000fe200078e0217ULL,
0xfffffff800007812ULL, 0x000fe200078ee205ULL, 0x0000001010057824ULL, 0x000fe200078e0217ULL,
0x00000009130e7210ULL, 0x000fe20007f5e0ffULL, 0x000000010b0b7824ULL, 0x000fc400000e0615ULL,
0x0000001012097824ULL, 0x000fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e2000b901c48ULL, 0x000000010d0d7824ULL, 0x000fe400008e0615ULL,
0x0000001000137824ULL, 0x000fe200078e0217ULL, 0x000000000a117faeULL, 0x0003e2000b901c48ULL,
0x000000010f0f7824ULL, 0x000fc600010e0615ULL, 0x000000000c097faeULL, 0x0003e8000b901c48ULL,
0x000000000e137faeULL, 0x0003e4000b901c48ULL, 0x000000104a6f7824ULL, 0x000fe200078e00ffULL,
0x000000ff0400720cULL, 0x000fe20003f05270ULL, 0x000000084a067824ULL, 0x002fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x000000006f0473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8006f0e7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6c80006067f8cULL, 0x000ee2000c80043fULL,
0x000000ffff207224ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000d92000008947ULL, 0x000fea0003800000ULL,
0x00000002086b7824ULL, 0x000fe200078e00ffULL, 0x00000002ff6c7819ULL, 0x000fe20000011602ULL,
0x00006a00ff007624ULL, 0x000fc400078e00ffULL, 0x000000ffff097224ULL, 0x008fe400078e0007ULL,
0x00006a006b6b7624ULL, 0x000fe400078e0200ULL, 0xff317217ff107424ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fe400078e00ffULL, 0x000000ffff177224ULL, 0x000fc400078e00ffULL,
0x00000000000a7805ULL, 0x01afca0000015200ULL, 0x0000000402057824ULL, 0x000fca00078e00ffULL,
0xfffffff8050c7812ULL, 0x000fc800078ec0ffULL, 0x0000f6c80c057810ULL, 0x000fe20007ffe0ffULL,
0x00f6cc000c0e7984ULL, 0x004ea40000000800ULL, 0x800000000eff7812ULL, 0x004fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000102c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x000000120a117210ULL, 0x000fca0007f1e1ffULL, 0x0000000113127824ULL, 0x000fe200000e0e0bULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc80000011412ULL, 0x000000110e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0612ULL, 0x000000020e0e7819ULL, 0x000fc80000001211ULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6cc000c0e7984ULL, 0x000ea40000000800ULL, 0x800000000eff7812ULL, 0x004fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001002097824ULL, 0x000fe200078e00ffULL, 0x0000000100117810ULL, 0x000fe20007ffe0ffULL,
0x0000590049497a24ULL, 0x000fc600078e02ffULL, 0xffffffe0090b7812ULL, 0x000fe200078ec0ffULL,
0x0000008049497824ULL, 0x000fe200078e00ffULL, 0x000000041100720cULL, 0x000fc60003f26070ULL,
0x00000100000b7824ULL, 0x000fca00078e020bULL, 0x000000400b0c7810ULL, 0x000fc80007ffe0ffULL,
0x000000600c0a7812ULL, 0x000fca00078ec0ffULL, 0x0000000169367824ULL, 0x000fe200078e020aULL,
0x0000042000009947ULL, 0x000fea0003800000ULL, 0x00000010090a7812ULL, 0x000fe200078ec0ffULL,
0x0000001048127824ULL, 0x000fe200078e00ffULL, 0x0000000c03097217ULL, 0x000fe40007800000ULL,
0x00000003ff0e7819ULL, 0x000fe40000011648ULL, 0x0000007012377812ULL, 0x000fe200078ec0ffULL,
0x0000000109097824ULL, 0x000fe200078e0a0cULL, 0x000000040e117810ULL, 0x040fe20007ffe0ffULL,
0x000000010e0b7824ULL, 0x000fe200078e020aULL, 0x0000640049357a11ULL, 0x000fc400078a38ffULL,
0x0000000a09097217ULL, 0x000fe20007800000ULL, 0x000000010b0c7824ULL, 0x000fe200078e0248ULL,
0x00006500493d7a11ULL, 0x000fe200028f3cffULL, 0x000000080b137824ULL, 0x000fe400078e00ffULL,
0x0000000109097824ULL, 0x000fe400078e0a0aULL, 0x00000001360b7824ULL, 0x000fe200078e020bULL,
0xfffffff8130c7812ULL, 0x000fe400078ee20cULL, 0x000000080e137810ULL, 0x000fc40007ffe0ffULL,
0x000000090e00720cULL, 0x0c0fe40003f86070ULL, 0x0000000c0e0e7810ULL, 0x000fe40007ffe0ffULL,
0x000000091300720cULL, 0x0c0fe20003f46070ULL, 0x0000000113137824ULL, 0x100fe200078e020aULL,
0x000000091100720cULL, 0x0c0fe20003f66070ULL, 0x0000000111117824ULL, 0x100fe200078e020aULL,
0x000000090e00720cULL, 0x040fe20003f06070ULL, 0x000000010e2d7824ULL, 0x000fe400078e020aULL,
0x00000001130a7824ULL, 0x000fc400078e0248ULL, 0x00000008132f7824ULL, 0x000fe400078e00ffULL,
0x00000001362e7824ULL, 0x000fe400078e0211ULL, 0x0000000111097824ULL, 0x000fe200078e0248ULL,
0xfffffff82f347812ULL, 0x000fe200078ee20aULL, 0x000000800b0a7825ULL, 0x000fc800078e00ffULL,
0x00000008110e7824ULL, 0x000fe200078e00ffULL, 0x000000370a0a7212ULL, 0x000fe200078efcffULL,
0x000000802e2e7825ULL, 0x000fc600078e00ffULL, 0x0000000a350a7210ULL, 0x000fe20007fbe0ffULL,
0x0000000136137824ULL, 0x000fe200078e0213ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL,
0x00000001362c7824ULL, 0x000fe200078e022dULL, 0x000000372e2e7212ULL, 0x000fe200078efcffULL,
0x000000012d097824ULL, 0x040fe400078e0248ULL, 0x000000082d367824ULL, 0x000fe400078e00ffULL,
0x0000008013127825ULL, 0x000fc600078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee209ULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000003712127212ULL, 0x000fe400078efcffULL,
0x0000c0004a097811ULL, 0x000fe200078e68ffULL, 0x000000010b0b7824ULL, 0x000fe200028e063dULL,
0x000000352e2e7210ULL, 0x000fe40007fbe0ffULL, 0x000000372c2c7212ULL, 0x000fe200078efcffULL,
0x000000100c117824ULL, 0x000fe400078e0209ULL, 0x000000012f2f7824ULL, 0x000fe200028e063dULL,
0x0000003512127210ULL, 0x080fe20007fbe0ffULL, 0x0000001034377824ULL, 0x100fe200078e0209ULL,
0x000000352c2c7210ULL, 0x000fe20007fde0ffULL, 0x000000100e357824ULL, 0x000fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a117faeULL, 0x0005e2000e101c48ULL,
0x0000000113137824ULL, 0x000fc400028e063dULL, 0x0000001036097824ULL, 0x000fe200078e0209ULL,
0x000000002e357faeULL, 0x0005e2000d901c48ULL, 0x000000012d2d7824ULL, 0x000fc600030e063dULL,
0x0000000012377faeULL, 0x0005e8000d101c48ULL, 0x000000002c097faeULL, 0x0005e2000c101c48ULL,
0x0000035000007947ULL, 0x000fea0003800000ULL, 0x0000001009097812ULL, 0x000fe400078ec0ffULL,
0x0000640049377a11ULL, 0x040fe400078038ffULL, 0x0000000948097211ULL, 0x000fe400078fe8ffULL,
0x0000650049497a11ULL, 0x000fc400000f3cffULL, 0x0000000409117810ULL, 0x040fe20007ffe0ffULL,
0x00000001090a7824ULL, 0x140fe200078e0248ULL, 0x0000000809137810ULL, 0x040fe20007ffe0ffULL,
0x00000008092d7824ULL, 0x000fe200078e00ffULL, 0x0000c0004a3d7811ULL, 0x000fe200078e68ffULL,
0x00000001110b7824ULL, 0x040fe400078e0248ULL, 0x00000008110e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d0c7812ULL, 0x000fe200078ee20aULL, 0x0000000113127824ULL, 0x040fe400078e0248ULL,
0x00000008132d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee20bULL,
0x00000010480b7824ULL, 0x000fc400078e00ffULL, 0x00000001360a7824ULL, 0x040fe200078e0209ULL,
0x0000000c09097810ULL, 0x000fe20007ffe0ffULL, 0x00000001362c7824ULL, 0x000fe200078e0213ULL,
0x000000700b357812ULL, 0x000fe200078ec0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff82d347812ULL, 0x000fc600078ee212ULL, 0x0000000136127824ULL, 0x000fe200078e0211ULL,
0x000000350a0a7212ULL, 0x000fe200078efcffULL, 0x00000001362e7824ULL, 0x000fe400078e0209ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000a370a7210ULL, 0x000fc60007f1e0ffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000003512127212ULL, 0x000fc600078efcffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x000000352c2c7212ULL, 0x000fc600078efcffULL,
0x0000000109117824ULL, 0x040fe200078e0248ULL, 0x000000352e2e7212ULL, 0x000fe200078efcffULL,
0x0000000809367824ULL, 0x000fe200078e00ffULL, 0x0000002c372c7210ULL, 0x000fe20007f5e0ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0649ULL, 0x0000001237127210ULL, 0x040fe20007f1e0ffULL,
0x000000100c097824ULL, 0x000fe200078e023dULL, 0xfffffff836367812ULL, 0x000fe200078ee211ULL,
0x000000100e117824ULL, 0x000fe200078e023dULL, 0x0000002e372e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000113137824ULL, 0x000fe200000e0649ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a097faeULL, 0x0005e2000b901c48ULL, 0x0000001034357824ULL, 0x000fc400078e023dULL,
0x000000012d2d7824ULL, 0x000fe200010e0649ULL, 0x0000000012117faeULL, 0x0005e2000b901c48ULL,
0x0000001036377824ULL, 0x000fe400078e023dULL, 0x000000012f2f7824ULL, 0x000fe200018e0649ULL,
0x000000002c357faeULL, 0x0005e8000b901c48ULL, 0x000000002e377faeULL, 0x0005e4000b901c48ULL,
0x00000008020c7824ULL, 0x000fe200078e00ffULL, 0x0000000168127810ULL, 0x004fe20007ffe0ffULL,
0xffffffffff0a7424ULL, 0x000fc400078e00ffULL, 0x000000000c0573c2ULL, 0x000ea200000e0000ULL,
0x000000711200720cULL, 0x000fe40003f06070ULL, 0x000000080c097812ULL, 0x040fe400078ec0ffULL,
0xffffffe00c0b7812ULL, 0x040fe400078ec0ffULL, 0x000000100c0e7812ULL, 0x000fce00078ec0ffULL,
0x000000016b128824ULL, 0x000fe400078e0212ULL, 0x00000004ff138424ULL, 0x000fe200078e00ffULL,
0xfffffff005057892ULL, 0x004fc6000f8ec03fULL, 0x0000660012128625ULL, 0x000fe200078e0013ULL,
0x0000f6b005067890ULL, 0x000fe2000fffe03fULL, 0x0000000b090b7210ULL, 0x000fc60007ffe00eULL,
0x00000008120a8981ULL, 0x000528000c1e1900ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6b000ff347f8cULL, 0x000ee2000c800405ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f608000b2e7f8cULL, 0x0002a4000c80043fULL,
0x0000000000127805ULL, 0x004fc40000015200ULL, 0x00f60c000b097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fc4000780482fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0000002c120e7210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2c7824ULL, 0x000fe200000e0e13ULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff2c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff2c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc8000001142cULL, 0x0000000e09097211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e062cULL, 0x0000000209097819ULL, 0x000fc8000000120eULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000111117810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60c000b097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010484f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff657819ULL, 0x000fe20000011648ULL, 0x0000002002097824ULL, 0x000fe400078e00ffULL,
0xffffffffff7a7424ULL, 0x000fe200078e00ffULL, 0x000000704f4f7812ULL, 0x000fc400078ec0ffULL,
0xffffff80090e7812ULL, 0x000fe400078ec0ffULL, 0x0000000c65657812ULL, 0x000fc800078ec0ffULL,
0x0000000e650e7210ULL, 0x000fca0007ffe04fULL, 0x00f000000e117984ULL, 0x000ea80000000800ULL,
0x00f200000e2c7984ULL, 0x0002e20000000800ULL, 0x000000101100720bULL, 0x004fe20003f1d000ULL,
0x00014a727f007947ULL, 0x000fd8000b800000ULL, 0x00000000000e7806ULL, 0x002fc800000e0100ULL,
0x0000ffff0e2e7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fc400078e0010ULL,
0x0000001fff7d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff7c7424ULL, 0x000fca00078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000026c00720cULL, 0x000fe40003f05270ULL,
0x000000101100720bULL, 0x000fe20003f54000ULL, 0x00014a027f007947ULL, 0x000fd8000b800000ULL,
0x00000000002d7806ULL, 0x000fc400010e0100ULL, 0x00000080020e8824ULL, 0x000fe200078e024fULL,
0x0000001011097209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x000099102d127816ULL, 0x000fe200000000ffULL, 0x00000001650e8824ULL, 0x000fca00078e020eULL,
0x00f400090e008388ULL, 0x0003e20000000800ULL, 0x000000ff1200720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x00000010090e7221ULL, 0x002fe20000010100ULL,
0x000000ff2dff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0e0e7820ULL, 0x000fc80000410000ULL, 0x0000000e002f7308ULL, 0x000e640000000800ULL,
0x0000002f0d0d7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0e7819ULL, 0x000fe20000011648ULL, 0x000149327f007947ULL, 0x000fea000b800000ULL,
0x00001f0e2f0e7589ULL, 0x0002a400000e0000ULL, 0x0000000e30307220ULL, 0x084fe20000410000ULL,
0x0000000e31317220ULL, 0x080fe20000410000ULL, 0x0000000e38387220ULL, 0x080fe20000410000ULL,
0x0000000e39397220ULL, 0x080fe20000410000ULL, 0x0000000e28287220ULL, 0x080fe20000410000ULL,
0x0000000e29297220ULL, 0x080fe20000410000ULL, 0x0000000e24247220ULL, 0x080fe20000410000ULL,
0x0000000e25257220ULL, 0x080fe20000410000ULL, 0x0000000e20207220ULL, 0x080fe20000410000ULL,
0x0000000e21217220ULL, 0x080fe20000410000ULL, 0x0000000e1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000e1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000e18187220ULL, 0x080fe20000410000ULL,
0x0000000e19197220ULL, 0x080fe20000410000ULL, 0x0000000e14147220ULL, 0x080fe20000410000ULL,
0x0000000e15157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff002dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008480e7811ULL, 0x000fe200078ff0ffULL, 0x000148127f007947ULL, 0x000fea000b800000ULL,
0x00001f0e2f0e7589ULL, 0x00046400000e0000ULL, 0x0000000e32327220ULL, 0x086fe20000410000ULL,
0x0000000e33337220ULL, 0x080fe20000410000ULL, 0x0000000e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000e3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000e2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000e2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000e26267220ULL, 0x080fe20000410000ULL,
0x0000000e27277220ULL, 0x080fe20000410000ULL, 0x0000000e22227220ULL, 0x080fe20000410000ULL,
0x0000000e23237220ULL, 0x080fe20000410000ULL, 0x0000000e1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000e1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000e1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000e1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000e16167220ULL, 0x080fe20000410000ULL,
0x0000000e17177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff2eff7812ULL, 0x000fe2000780602dULL, 0x00000001ff0e7424ULL, 0x000fd800078e00ffULL,
0x8000000911110221ULL, 0x000fe20000010000ULL, 0x00007610ff0e0816ULL, 0x000fc6000000000eULL,
0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL, 0x0000001100060308ULL, 0x000e640000000800ULL,
0x000000062c2c0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000d2c0d7221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0xfffffff00c2c7812ULL, 0x000fca00078ec0ffULL, 0x00f6ac002c0c7984ULL, 0x000e640000000800ULL,
0x800000000cff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x00000012102d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc80000011413ULL, 0x0000002d0c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x000000020c0c7819ULL, 0x000fc80000001213ULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac002c0c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100e0c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000006ff07723eULL, 0x000fe400000010ffULL,
0x00000002ff0c7819ULL, 0x000fe40000011648ULL, 0x00005410070f7816ULL, 0x000fe20000000007ULL,
0x000143e27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0f077589ULL, 0x0002a400000e0000ULL,
0x000000080c0e7810ULL, 0x000fe20007ffe0ffULL, 0x000144127f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0f087589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100c0e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e000fULL,
0x0000306000137802ULL, 0x000fc40000000f00ULL, 0x00014de000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180c0e7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e000fULL, 0x000030b000137802ULL, 0x000fc40000000f00ULL,
0x00014d9000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000202557824ULL, 0x000fe200078e00ffULL, 0x0000000748117812ULL, 0x000fe200078ec0ffULL,
0x00000200020c7824ULL, 0x002fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000848587812ULL, 0x000fc400078ec0ffULL, 0x00000004550f7812ULL, 0x008fe400078ec0ffULL,
0x0000000811547812ULL, 0x000fe400078ef848ULL, 0x0000000f480f7211ULL, 0x000fc600078fe0ffULL,
0x00000008544e7824ULL, 0x040fe400078e00ffULL, 0x0000000154637824ULL, 0x000fe200078e020fULL,
0xfffff8000c0f7812ULL, 0x000fc800078ec0ffULL, 0xfffffff84e4e7812ULL, 0x000fca00078ee263ULL,
0x000000104e4e7824ULL, 0x000fc400078e020fULL, 0x00000004020c7824ULL, 0x000fe200078e00ffULL,
0x00000004ff5f7819ULL, 0x000fe40000011648ULL, 0x0000001158377212ULL, 0x000fe400078efcffULL,
0x000000040c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000b0004a647811ULL, 0x000fe200078e68ffULL,
0x0000000837137824ULL, 0x000fe200078e00ffULL, 0x0000001058587812ULL, 0x000fe200078efe11ULL,
0x000000015f0c7824ULL, 0x000fe200078e020cULL, 0xfffffff855557812ULL, 0x000fc600078ec0ffULL,
0x00000001373c7824ULL, 0x040fe400078e020cULL, 0x0000000837377824ULL, 0x000fe400078e00ffULL,
0x00000008580e7824ULL, 0x004fe200078e00ffULL, 0xfffffff813447812ULL, 0x000fe200078ee23cULL,
0x000000010c4b7824ULL, 0x000fe200078e0258ULL, 0x009000004e10783bULL, 0x000e620000000200ULL,
0x000000023c4c7810ULL, 0x000fe40007ffe0ffULL, 0x0000001044407824ULL, 0x000fe200078e0264ULL,
0xfffffff80e4d7812ULL, 0x000fc400078ee24bULL, 0xfffffff8374c7812ULL, 0x000fe400078ee24cULL,
0x000000024b4b7810ULL, 0x000fe20007ffe0ffULL, 0x000000004040783bULL, 0x000ea20000004200ULL,
0x000000104d2c7824ULL, 0x100fe400078e0264ULL, 0x000000104c3c7824ULL, 0x000fc800078e0264ULL,
0x000000002c2c783bULL, 0x000fe20000004200ULL, 0x0000000710108231ULL, 0x082fe400003400ffULL,
0x0000000712128231ULL, 0x000fe400003400ffULL, 0x0000000811118231ULL, 0x080fe400003400ffULL,
0x0000000813138231ULL, 0x000fe200003400ffULL, 0x0000010041607824ULL, 0x004fe200078e00ffULL,
0x0000004100457306ULL, 0x000fe20000009400ULL, 0x0000010040467824ULL, 0x000fc600078e00ffULL,
0x00000018ff607819ULL, 0x000fe40000011460ULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000004100627306ULL, 0x000e700000005400ULL, 0x0000006000617306ULL, 0x000ff00000209400ULL,
0x0000006000667306ULL, 0x0004e20000205400ULL, 0x000000624500720bULL, 0x002fe20003f9d000ULL,
0x0001000040627824ULL, 0x000fca00078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011462ULL,
0x00000046003e7306ULL, 0x000fe20000209400ULL, 0x0000006000607245ULL, 0x004fce000020d400ULL,
0x00000046003f7306ULL, 0x000e620000205400ULL, 0x000000666100720bULL, 0x008fe40003fbd000ULL,
0x0000004600617245ULL, 0x000fca000020d400ULL, 0x0000004000367306ULL, 0x000fec0000009400ULL,
0x0000000160605812ULL, 0x000fe400078efcffULL, 0x00000040003d7306ULL, 0x000ea20000005400ULL,
0x0000003f3e00720bULL, 0x002fce0003f7d000ULL, 0x0000004100577306ULL, 0x000e6c000000d400ULL,
0x0000000161613812ULL, 0x000fe400078efcffULL, 0x0000004000567306ULL, 0x000ee2000000d400ULL,
0x0000003d3600720bULL, 0x004fe40003f5d000ULL, 0x000000003c3c783bULL, 0x000ea20000004200ULL,
0x0000000157574812ULL, 0x002fc800078efcffULL, 0x00000043005e7306ULL, 0x000fe20000009400ULL,
0x000000576057723eULL, 0x000fe400000010ffULL, 0x00000018ff607819ULL, 0x000fc60000011440ULL,
0x0000000156562812ULL, 0x008fe400078efcffULL, 0x0000004300597306ULL, 0x000e640000005400ULL,
0x000000566156723eULL, 0x000fcc00000010ffULL, 0x0000006000617306ULL, 0x000fe20000209400ULL,
0x000000561030723cULL, 0x000b6e0000041830ULL, 0x00000060006e7306ULL, 0x000ee20000205400ULL,
0x00000018ff567819ULL, 0x020fe20000011441ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x000000595e00720bULL, 0x002fe20003f7d000ULL, 0x0000010042597824ULL, 0x000fc600078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0000006200677306ULL, 0x000fe20000209400ULL,
0x00000018ff597819ULL, 0x000fce0000011459ULL, 0x00000062006a7306ULL, 0x000e620000205400ULL,
0x0000006e6100720bULL, 0x008fce0003fdd000ULL, 0x0000005600577306ULL, 0x000ff00000209400ULL,
0x0000005600407306ULL, 0x0006a20000205400ULL, 0x0000006a6700720bULL, 0x002fce0003f9d000ULL,
0x0000004100667306ULL, 0x000fe20000209400ULL, 0x0000005600567245ULL, 0x008fce000020d400ULL,
0x0000004100617306ULL, 0x0002e20000205400ULL, 0x000000405700720bULL, 0x004fe40003fbd000ULL,
0x0000006200407245ULL, 0x000fe2000020d400ULL, 0x0000010043627824ULL, 0x000fc600078e00ffULL,
0x0000000140404812ULL, 0x000fe200078efcffULL, 0x00000059005e7306ULL, 0x000fe20000209400ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000004100417245ULL, 0x002fc6000020d400ULL,
0x0000000156565812ULL, 0x000fe400078efcffULL, 0x0000005900677306ULL, 0x000e620000205400ULL,
0x000000616600720bULL, 0x008fe40003f9d000ULL, 0x0000006000617245ULL, 0x000fc8000020d400ULL,
0x0000000161616812ULL, 0x000fe200078efcffULL, 0x00000042005c7306ULL, 0x000fe60000009400ULL,
0x000000406140723eULL, 0x000fc600000010ffULL, 0x0000000141414812ULL, 0x000fe400078efcffULL,
0x00000042005d7306ULL, 0x000ea20000005400ULL, 0x000000675e00720bULL, 0x002fe40003fdd000ULL,
0x000000415641723eULL, 0x000fca00000010ffULL, 0x0000006200667306ULL, 0x000fe40000209400ULL,
0x000000401038723cULL, 0x000bec0000041838ULL, 0x0000006200677306ULL, 0x0002e20000205400ULL,
0x0000005d5c00720bULL, 0x004fe40003f5d000ULL, 0x0000005900417245ULL, 0x020fc8000020d400ULL,
0x0000000141416812ULL, 0x000fe200078efcffULL, 0x00000042005a7306ULL, 0x000ea2000000d400ULL,
0x0000006200627245ULL, 0x002fce000020d400ULL, 0x00000043005b7306ULL, 0x000e62000000d400ULL,
0x000000676600720bULL, 0x008fce0003f9d000ULL, 0x0000003c005c7306ULL, 0x000fe20000009400ULL,
0x000000015a5a2812ULL, 0x004fc800078efcffULL, 0x0000005a4140723eULL, 0x000fe400000010ffULL,
0x0000000162624812ULL, 0x000fe200078efcffULL, 0x0000003c005d7306ULL, 0x000ea20000005400ULL,
0x000000015b5b3812ULL, 0x002fc800078efcffULL, 0x0000005b6241723eULL, 0x000fe200000010ffULL,
0x0001000042627824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe20000011442ULL,
0x0000003d005e7306ULL, 0x000fe20000009400ULL, 0x0001000043427824ULL, 0x000fe400078e00ffULL,
0x00000018ff627819ULL, 0x000fe20000011462ULL, 0x000000401028723cULL, 0x000b640000041828ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x0000003d00617306ULL, 0x000e620000005400ULL,
0x0000005d5c00720bULL, 0x004fc40003f5d000ULL, 0x00000018ff407819ULL, 0x020fca0000011443ULL,
0x0000006200667306ULL, 0x000ff00000209400ULL, 0x00000062005d7306ULL, 0x000ea20000205400ULL,
0x000000615e00720bULL, 0x002fe20003f7d000ULL, 0x000001003c617824ULL, 0x000fca00078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000005b00607306ULL, 0x000ff00000209400ULL,
0x0000005b00677306ULL, 0x000e620000205400ULL, 0x0000005d6600720bULL, 0x004fce0003f9d000ULL,
0x0000004000417306ULL, 0x000ff00000209400ULL, 0x00000040006a7306ULL, 0x000ea20000205400ULL,
0x000000676000720bULL, 0x002fe40003fdd000ULL, 0x0000005b00607245ULL, 0x000fca000020d400ULL,
0x00000061005d7306ULL, 0x000fec0000209400ULL, 0x0000000160606812ULL, 0x000fe400078efcffULL,
0x0000006100667306ULL, 0x000e620000205400ULL, 0x0000006a4100720bULL, 0x004fe40003fbd000ULL,
0x0000006200417245ULL, 0x000fe2000020d400ULL, 0x000001003d627824ULL, 0x000fc600078e00ffULL,
0x0000000141414812ULL, 0x000fe200078efcffULL, 0x0000004200437306ULL, 0x000fe20000209400ULL,
0x00000018ff627819ULL, 0x000fce0000011462ULL, 0x00000042005e7306ULL, 0x0004e20000205400ULL,
0x000000665d00720bULL, 0x002fce0003fdd000ULL, 0x0000006200677306ULL, 0x000fe20000209400ULL,
0x0000004200427245ULL, 0x004fe4000020d400ULL, 0x0000005e4300720bULL, 0x008fca0003f9d000ULL,
0x0000006200667306ULL, 0x000e620000205400ULL, 0x0000004000437245ULL, 0x000fe4000020d400ULL,
0x000000416040723eULL, 0x000fe400000010ffULL, 0x0000000143435812ULL, 0x000fe400078efcffULL,
0x00000018ff607819ULL, 0x000fe2000001143cULL, 0x0000003c00577306ULL, 0x000ea2000000d400ULL,
0x0000000142424812ULL, 0x000fce00078efcffULL, 0x0000003d00567306ULL, 0x000ee2000000d400ULL,
0x000000666700720bULL, 0x002fe40003f9d000ULL, 0x000000424341723eULL, 0x000fe400000010ffULL,
0x00000018ff427819ULL, 0x000fe4000001142cULL, 0x0000000157572812ULL, 0x004fe200078efcffULL,
0x0000003e00597306ULL, 0x000fe40000009400ULL, 0x000000401024723cULL, 0x000b620000041824ULL,
0x0000000156563812ULL, 0x008fca00078efcffULL, 0x0000003e005a7306ULL, 0x000e620000005400ULL,
0x0000006100407245ULL, 0x020fe4000020d400ULL, 0x0000006200417245ULL, 0x000fe4000020d400ULL,
0x0000000140406812ULL, 0x000fe400078efcffULL, 0x0000000141414812ULL, 0x000fe200078efcffULL,
0x0000003f005e7306ULL, 0x000fe20000009400ULL, 0x000000574040723eULL, 0x000fe400000010ffULL,
0x000000564141723eULL, 0x000fc400000010ffULL, 0x00000018ff567819ULL, 0x000fc6000001143dULL,
0x0000003f005b7306ULL, 0x000ea20000005400ULL, 0x0000005a5900720bULL, 0x002fe20003f9d000ULL,
0x000000401020723cULL, 0x000b620000041820ULL, 0x000100003d597824ULL, 0x000fe400078e00ffULL,
0x000001003e5a7824ULL, 0x000fc600078e00ffULL, 0x0000006000617306ULL, 0x000fe20000209400ULL,
0x000100003c417824ULL, 0x020fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143eULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000006000627306ULL, 0x000e620000205400ULL, 0x0000005b5e00720bULL, 0x004fe40003f7d000ULL,
0x00000018ff5a7819ULL, 0x000fca000001145aULL, 0x0000004100667306ULL, 0x000ff00000209400ULL,
0x0000004100677306ULL, 0x000ea20000205400ULL, 0x000000626100720bULL, 0x002fe40003f5d000ULL,
0x0000005900617245ULL, 0x000fca000020d400ULL, 0x0000005600577306ULL, 0x000ff00000209400ULL,
0x0000005600407306ULL, 0x000e620000205400ULL, 0x000000676600720bULL, 0x004fe40003fbd000ULL,
0x0000005600667245ULL, 0x000fca000020d400ULL, 0x00000059006a7306ULL, 0x000ff00000209400ULL,
0x00000059005b7306ULL, 0x000ea20000205400ULL, 0x000000405700720bULL, 0x002fe40003fdd000ULL,
0x0000004100407245ULL, 0x000fc4000020d400ULL, 0x00000018ff417819ULL, 0x000fe4000001143fULL,
0x0000000140405812ULL, 0x000fe200078efcffULL, 0x0000003c003d7306ULL, 0x000fec0000209400ULL,
0x0000000166666812ULL, 0x000fe400078efcffULL, 0x0000003c00627306ULL, 0x000e620000205400ULL,
0x0000005b6a00720bULL, 0x004fc40003fbd000ULL, 0x00000060005b7245ULL, 0x000fe2000020d400ULL,
0x000100003e607824ULL, 0x000fc600078e00ffULL, 0x000000015b5b2812ULL, 0x000fe200078efcffULL,
0x0000005a005e7306ULL, 0x000fe20000209400ULL, 0x00000018ff607819ULL, 0x000fca0000011460ULL,
0x0000000161615812ULL, 0x000fe400078efcffULL, 0x0000005a00677306ULL, 0x000ea20000205400ULL,
0x000000623d00720bULL, 0x002fe20003f5d000ULL, 0x000001003f3d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000004100577306ULL, 0x000ff00000209400ULL,
0x0000004100627306ULL, 0x000e620000205400ULL, 0x000000675e00720bULL, 0x004fe20003fbd000ULL,
0x000100003f5e7824ULL, 0x000fe200078e00ffULL, 0x0000005a00677245ULL, 0x000fc4000020d400ULL,
0x00000018ff5a7819ULL, 0x000fe4000001142eULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000003e005c7306ULL, 0x000eac000000d400ULL, 0x0000000167675812ULL, 0x000fe400078efcffULL,
0x0000003f005d7306ULL, 0x000ee2000000d400ULL, 0x000000625700720bULL, 0x002fc40003fdd000ULL,
0x00000018ff577819ULL, 0x000fca000001142dULL, 0x0000003d00597306ULL, 0x000fe20000209400ULL,
0x000000015c5c4812ULL, 0x004fce00078efcffULL, 0x0000003d006a7306ULL, 0x000e620000205400ULL,
0x000000015d5d3812ULL, 0x008fce00078efcffULL, 0x00000060003e7306ULL, 0x000ff00000209400ULL,
0x00000060003f7306ULL, 0x000ea20000205400ULL, 0x0000006a5900720bULL, 0x002fce0003fbd000ULL,
0x0000005e006d7306ULL, 0x000ff00000209400ULL, 0x0000005e00627306ULL, 0x000e620000205400ULL,
0x0000003f3e00720bULL, 0x004fe20003f9d000ULL, 0x00000008583e7824ULL, 0x000fe200078e00ffULL,
0x00000061663f723eULL, 0x000fc400000010ffULL, 0x0000003c00617245ULL, 0x000fe4000020d400ULL,
0xfffffff83e4b7812ULL, 0x000fe200078ee24bULL, 0x0000002d00527306ULL, 0x000fe20000009400ULL,
0x000000405b3e723eULL, 0x000fe400000010ffULL, 0x0000006000407245ULL, 0x000fe4000020d400ULL,
0x0000004100607245ULL, 0x000fe4000020d400ULL, 0x0000005e00417245ULL, 0x000fe2000020d400ULL,
0x0000003e101c723cULL, 0x000b62000004181cULL, 0x000000626d00720bULL, 0x002fe20003f7d000ULL,
0x0000002d00507306ULL, 0x000e620000005400ULL, 0x0000003d00627245ULL, 0x000fc4000020d400ULL,
0x0000000161612812ULL, 0x000fe400078efcffULL, 0x0000000162625812ULL, 0x000fe200078efcffULL,
0x000000104b3e7824ULL, 0x020fe200078e0264ULL, 0x0000000140404812ULL, 0x000fe200078efcffULL,
0x0000002c00477306ULL, 0x000fe20000009400ULL, 0x0000000160606812ULL, 0x000fe400078efcffULL,
0x0000005c673c723eULL, 0x000fe400000010ffULL, 0x0000000141413812ULL, 0x000fc400078efcffULL,
0x0000005d623d723eULL, 0x000fe200000010ffULL, 0x000001002c627824ULL, 0x000fe200078e00ffULL,
0x000000406140723eULL, 0x000fe200000010ffULL, 0x000000044a617824ULL, 0x000fe200078e025fULL,
0x000000416041723eULL, 0x000fe200000010ffULL, 0x0000002c00537306ULL, 0x000ea20000005400ULL,
0x00000018ff5f7819ULL, 0x000fe20000011462ULL, 0x0000003c1018723cULL, 0x000b620000041818ULL,
0x000000505200720bULL, 0x002fe20003f9d000ULL, 0x000000003e3c783bULL, 0x020fe20000004200ULL,
0x0000000261617810ULL, 0x000fc40007ffe054ULL, 0x00000018ff5d7819ULL, 0x000fe2000001142fULL,
0x0000002d00497306ULL, 0x000e64000000d400ULL, 0x000000401010723cULL, 0x000b6c0000041814ULL,
0x0000005f00407306ULL, 0x020fe20000209400ULL, 0x000001002d157824ULL, 0x000fe200078e00ffULL,
0x000000534700720bULL, 0x004fe20003f5d000ULL, 0x0000000854147824ULL, 0x000fc600078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011415ULL, 0x0000005f00417306ULL, 0x000ea20000205400ULL,
0xfffffff814147812ULL, 0x000fe400078ee261ULL, 0x0000000149494812ULL, 0x002fc600078efcffULL,
0x00000010140f7824ULL, 0x000fe400078e020fULL, 0x00000067006a7306ULL, 0x000fe60000209400ULL,
0x009000000f14783bULL, 0x000e6a0000000200ULL, 0x00000067006d7306ULL, 0x000ee20000205400ULL,
0x000000414000720bULL, 0x004fc40003f7d000ULL, 0x0000005f00407245ULL, 0x000fca000020d400ULL,
0x0000002e000c7306ULL, 0x000fec0000009400ULL, 0x0000000140403812ULL, 0x000fe400078efcffULL,
0x0000002e000e7306ULL, 0x000ea20000005400ULL, 0x0000006d6a00720bULL, 0x008fe40003fbd000ULL,
0x00000067006a7245ULL, 0x000fca000020d400ULL, 0x0000002c00517306ULL, 0x00066c000000d400ULL,
0x000000016a6a5812ULL, 0x000fe400078efcffULL, 0x0000000e0c00720bULL, 0x004fe20003f9d000ULL,
0x000100002c2c7824ULL, 0x008fe200078e00ffULL, 0x0000002f00377306ULL, 0x000fe20000009400ULL,
0x000000496a41723eULL, 0x000fe200000010ffULL, 0x000001002f0e7824ULL, 0x000fe200078e00ffULL,
0x0000000714148231ULL, 0x082fe200003400ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0000000716168231ULL, 0x000fe200003400ffULL, 0x0000000151512812ULL, 0x000fe200078efcffULL,
0x0000000815158231ULL, 0x080fe200003400ffULL, 0x0000002c000c7306ULL, 0x000fe20000209400ULL,
0x00000018ff0e7819ULL, 0x000fe2000001140eULL, 0x0000000817178231ULL, 0x000fe200003400ffULL,
0x000000514040723eULL, 0x000fe200000010ffULL, 0x000100002d517824ULL, 0x000fc800078e00ffULL,
0x0000002c006d7306ULL, 0x0002a20000205400ULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x000000401430723cULL, 0x000b6c0000041830ULL, 0x0000002f00457306ULL, 0x000ee20000005400ULL,
0x0000002c002c7245ULL, 0x002fce000020d400ULL, 0x00000051002d7306ULL, 0x000fe20000209400ULL,
0x0000006d0c00720bULL, 0x004fce0003fdd000ULL, 0x00000051006a7306ULL, 0x000e620000205400ULL,
0x000000453700720bULL, 0x008fe20003f5d000ULL, 0x000001002e377824ULL, 0x000fc800078e00ffULL,
0x000000012c2c6812ULL, 0x000fe400078efcffULL, 0x0000004200437306ULL, 0x000fe20000209400ULL,
0x00000018ff377819ULL, 0x000fce0000011437ULL, 0x0000004200567306ULL, 0x0004e20000205400ULL,
0x0000006a2d00720bULL, 0x002fe40003fdd000ULL, 0x00000042002d7245ULL, 0x000fca000020d400ULL,
0x0000003700677306ULL, 0x000fe20000209400ULL, 0x00000018ff427819ULL, 0x004fce000001143dULL,
0x00000037006e7306ULL, 0x0003e20000205400ULL, 0x000000564300720bULL, 0x008fe20003f7d000ULL,
0x000100002f567824ULL, 0x000fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000005700597306ULL, 0x000fe20000209400ULL, 0x0000003700377245ULL, 0x002fca000020d400ULL,
0x000000012d2d3812ULL, 0x000fe400078efcffULL, 0x0000005700587306ULL, 0x0002a40000205400ULL,
0x0000002c2d2c723eULL, 0x000fcc00000010ffULL, 0x0000002f00467306ULL, 0x0006a2000000d400ULL,
0x0000005700577245ULL, 0x002fce000020d400ULL, 0x0000000e000c7306ULL, 0x000fe20000209400ULL,
0x00000051002f7245ULL, 0x008fe4000020d400ULL, 0x000000585900720bULL, 0x004fe20003f1d000ULL,
0x000100002e587824ULL, 0x000fe200078e00ffULL, 0x000000012f2f6812ULL, 0x000fe400078efcffULL,
0x0000006e6700720bULL, 0x000fe20003fdd000ULL, 0x0000000e006d7306ULL, 0x000e620000205400ULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000000146462812ULL, 0x000fca00078efcffULL,
0x0000005d005e7306ULL, 0x000fe20000209400ULL, 0x0000000157570812ULL, 0x000fc600078efcffULL,
0x0000000137376812ULL, 0x000fe400078efcffULL, 0x0000002f572d723eULL, 0x000fe400000010ffULL,
0x0000005d00607306ULL, 0x0004e20000205400ULL, 0x0000006d0c00720bULL, 0x002fe40003fdd000ULL,
0x00000018ff0c7819ULL, 0x000fca000001143eULL, 0x0000005a005b7306ULL, 0x000fe20000209400ULL,
0x0000005d005d7245ULL, 0x004fce000020d400ULL, 0x0000005a005c7306ULL, 0x000e620000205400ULL,
0x000000605e00720bULL, 0x008fe40003f7d000ULL, 0x0000000e00607245ULL, 0x000fe4000020d400ULL,
0x00000018ff0e7819ULL, 0x000fe4000001143fULL, 0x0000000160606812ULL, 0x000fe200078efcffULL,
0x0000005800437306ULL, 0x000fec0000209400ULL, 0x000000015d5d3812ULL, 0x000fc400078efcffULL,
0x0000005800457306ULL, 0x0004e20000205400ULL, 0x0000005c5b00720bULL, 0x002fce0003fbd000ULL,
0x0000003c00627306ULL, 0x000fe20000009400ULL, 0x0000005800587245ULL, 0x004fce000020d400ULL,
0x0000003c00617306ULL, 0x000e620000005400ULL, 0x000000454300720bULL, 0x008fce0003fdd000ULL,
0x0000003e00527306ULL, 0x000fec0000009400ULL, 0x0000000158586812ULL, 0x000fe400078efcffULL,
0x0000003e005f7306ULL, 0x000ea20000005400ULL, 0x000000616200720bULL, 0x002fe20003f1d000ULL,
0x000001003c617824ULL, 0x000fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x00000056005c7306ULL, 0x000ff00000209400ULL, 0x00000056006a7306ULL, 0x0002e20000205400ULL,
0x0000005f5200720bULL, 0x004fe20003f5d000ULL, 0x000100003c527824ULL, 0x000fca00078e00ffULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x0000002e00367306ULL, 0x0004a2000000d400ULL,
0x0000005600567245ULL, 0x002fce000020d400ULL, 0x0000003d00537306ULL, 0x000fe20000009400ULL,
0x0000006a5c00720bULL, 0x008fe40003fdd000ULL, 0x00000018ff2e7819ULL, 0x004fe4000001143cULL,
0x0000005a005c7245ULL, 0x000fe4000020d400ULL, 0x0000002e00577245ULL, 0x000fe2000020d400ULL,
0x0000003d00667306ULL, 0x000e620000005400ULL, 0x0000000136364812ULL, 0x000fe400078efcffULL,
0x000000015c5c5812ULL, 0x000fc400078efcffULL, 0x000000363736723eULL, 0x000fe400000010ffULL,
0x0000000156566812ULL, 0x000fe200078efcffULL, 0x0000003f00497306ULL, 0x000fe20000009400ULL,
0x000000466037723eULL, 0x000fe400000010ffULL, 0x0000005200467245ULL, 0x000fca000020d400ULL,
0x0000003f00417306ULL, 0x020ea20000005400ULL, 0x000000665300720bULL, 0x002fe20003f9d000ULL,
0x000001003d667824ULL, 0x000fe200078e00ffULL, 0x000000361428723cULL, 0x000f680000041828ULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x00000061005f7306ULL, 0x000ff00000209400ULL,
0x0000006100627306ULL, 0x000e620000205400ULL, 0x000000414900720bULL, 0x004fc40003fbd000ULL,
0x0000006600497245ULL, 0x000fca000020d400ULL, 0x0000002e00597306ULL, 0x000ff00000209400ULL,
0x0000002e00677306ULL, 0x0004e20000205400ULL, 0x000000625f00720bULL, 0x002fe20003fdd000ULL,
0x000100003d5f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x00000066005a7306ULL, 0x000fe20000209400ULL, 0x0000002c142c723cULL, 0x004b6e0000041838ULL,
0x0000006600417306ULL, 0x000e620000205400ULL, 0x000000675900720bULL, 0x008fc40003f7d000ULL,
0x0000006100597245ULL, 0x000fe4000020d400ULL, 0x000000585c38723eULL, 0x020fe400000010ffULL,
0x0000000159596812ULL, 0x000fe200078efcffULL, 0x0000003c00547306ULL, 0x000ea2000000d400ULL,
0x000000565d39723eULL, 0x000fca00000010ffULL, 0x0000000157573812ULL, 0x000fe400078efcffULL,
0x0000003d00507306ULL, 0x000ee2000000d400ULL, 0x000000415a00720bULL, 0x002fe20003fdd000ULL,
0x000001003e5a7824ULL, 0x000fe200078e00ffULL, 0x000000381424723cULL, 0x000b620000041824ULL,
0x000001003f417824ULL, 0x000fc600078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x00000052003c7306ULL, 0x000fe20000209400ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000000154540812ULL, 0x004fc600078efcffULL, 0x0000000149496812ULL, 0x000fe400078efcffULL,
0x00000052003d7306ULL, 0x000e620000205400ULL, 0x0000000150504812ULL, 0x008fe400078efcffULL,
0x000000545936723eULL, 0x000fe400000010ffULL, 0x000000504937723eULL, 0x000fc600000010ffULL,
0x00000042005b7306ULL, 0x000fe80000209400ULL, 0x000000361420723cULL, 0x000f680000041820ULL,
0x00000042005e7306ULL, 0x0004e20000205400ULL, 0x0000003d3c00720bULL, 0x002fe20003fdd000ULL,
0x000100003e3c7824ULL, 0x000fc400078e00ffULL, 0x000100003f3d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000005f00677306ULL, 0x000fe20000209400ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000004200427245ULL, 0x004fc6000020d400ULL,
0x0000000146466812ULL, 0x000fe400078efcffULL, 0x0000005f006a7306ULL, 0x0002a20000205400ULL,
0x0000005e5b00720bULL, 0x008fe40003f1d000ULL, 0x000000465738723eULL, 0x020fca00000010ffULL,
0x0000005a00617306ULL, 0x000fe20000209400ULL, 0x0000005f005f7245ULL, 0x002fca000020d400ULL,
0x0000000142420812ULL, 0x000fe400078efcffULL, 0x0000005a00627306ULL, 0x0002e20000205400ULL,
0x0000006a6700720bULL, 0x004fce0003f9d000ULL, 0x0000003e00477306ULL, 0x000ea2000000d400ULL,
0x0000005a005a7245ULL, 0x002fca000020d400ULL, 0x000000015f5f4812ULL, 0x000fe400078efcffULL,
0x0000003f00407306ULL, 0x000e62000000d400ULL, 0x000000626100720bULL, 0x008fe40003f7d000ULL,
0x0000005f4239723eULL, 0x000fca00000010ffULL, 0x0000000c00517306ULL, 0x000fe20000209400ULL,
0x0000000147472812ULL, 0x004fe200078efcffULL, 0x00000038141c723cULL, 0x000b68000004181cULL,
0x000000015a5a3812ULL, 0x000fe400078efcffULL, 0x0000000c00537306ULL, 0x000ea20000205400ULL,
0x0000000c00397245ULL, 0x020fe4000020d400ULL, 0x0000003c00387245ULL, 0x000fc4000020d400ULL,
0x0000000140405812ULL, 0x002fe400078efcffULL, 0x000000475a36723eULL, 0x000fe200000010ffULL,
0x00000041005b7306ULL, 0x000ff00000209400ULL, 0x00000041005e7306ULL, 0x0002e20000205400ULL,
0x000000535100720bULL, 0x004fce0003fdd000ULL, 0x0000003c003e7306ULL, 0x000fe20000209400ULL,
0x0000004100417245ULL, 0x002fca000020d400ULL, 0x0000000139396812ULL, 0x000fe400078efcffULL,
0x0000003c003f7306ULL, 0x000e620000205400ULL, 0x0000005e5b00720bULL, 0x008fce0003f1d000ULL,
0x0000000e00437306ULL, 0x000fec0000209400ULL, 0x0000000141410812ULL, 0x000fe400078efcffULL,
0x0000000e00457306ULL, 0x0004e20000205400ULL, 0x0000003f3e00720bULL, 0x002fe40003f7d000ULL,
0x000000404137723eULL, 0x000fca00000010ffULL, 0x0000003d00527306ULL, 0x000fe20000209400ULL,
0x0000000e000e7245ULL, 0x004fe2000020d400ULL, 0x000000361418723cULL, 0x000f680000041818ULL,
0x0000000138383812ULL, 0x000fe400078efcffULL, 0x0000003d003b7306ULL, 0x0002a20000205400ULL,
0x000000454300720bULL, 0x008fe40003f9d000ULL, 0x000000383938723eULL, 0x000fc400000010ffULL,
0x0000003d003d7245ULL, 0x002fd2000020d400ULL, 0x000000010e0e4812ULL, 0x000fe400078efcffULL,
0x0000003b5200720bULL, 0x004fda0003f5d000ULL, 0x000000013d3d2812ULL, 0x000fc800078efcffULL,
0x0000003d0e39723eULL, 0x000fce00000010ffULL, 0x000000381414723cULL, 0x000b6e0000041810ULL,
0x0000f6c84a107811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000010107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6880055ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff0c7224ULL, 0x000fc600078e00ffULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x0000040005377984ULL, 0x000ee40000000800ULL,
0x8000000037ff7812ULL, 0x00afc40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003612397210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e13ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc80000011437ULL,
0x000000390e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x000000020e0e7819ULL, 0x000fc80000001237ULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040005377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001002107824ULL, 0x000fe400078e00ffULL, 0x000059000a0a7a24ULL, 0x010fc600078e02ffULL,
0xffffffe010117812ULL, 0x000fe200078ec0ffULL, 0x000000800a0a7824ULL, 0x000fc800078e00ffULL,
0x00000100000e7824ULL, 0x000fca00078e0211ULL, 0x000000800e0e7810ULL, 0x000fc80007ffe0ffULL,
0x000000600e0c7812ULL, 0x000fca00078ec0ffULL, 0x0000000169137824ULL, 0x000fe200078e020cULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x0000000e030c7217ULL, 0x000fe40007800000ULL,
0x0000001010117812ULL, 0x000fe400078ec0ffULL, 0x00000003ff107819ULL, 0x000fe20000011648ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a0eULL, 0x000064000a3b7a11ULL, 0x000fe400078a38ffULL,
0x0000000410367810ULL, 0x040fe20007ffe0ffULL, 0x00000001100e7824ULL, 0x000fe200078e0211ULL,
0x0000000c110c7217ULL, 0x000fc40007800000ULL, 0x0000000c10377810ULL, 0x000fe20007ffe0ffULL,
0x000000010e127824ULL, 0x000fe200078e0248ULL, 0x000065000a3d7a11ULL, 0x000fe200028f3cffULL,
0x000000080e3f7824ULL, 0x000fe400078e00ffULL, 0x000000010c0c7824ULL, 0x100fe400078e0a11ULL,
0x00000001373a7824ULL, 0x000fe200078e0211ULL, 0xfffffff83f3f7812ULL, 0x000fe400078ee212ULL,
0x0000000810127810ULL, 0x000fe20007ffe0ffULL, 0x000000083a457824ULL, 0x000fe200078e00ffULL,
0x0000000c1000720cULL, 0x080fe20003f86070ULL, 0x000000010e107824ULL, 0x000fe200078e0213ULL,
0x0000000c3600720cULL, 0x0c0fe20003f66070ULL, 0x0000000136367824ULL, 0x100fe200078e0211ULL,
0x0000000c1200720cULL, 0x0c0fe20003f46070ULL, 0x0000000112127824ULL, 0x000fe200078e0211ULL,
0x0000000c3700720cULL, 0x000fe20003f06070ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x00000001360e7824ULL, 0x100fe200078e0248ULL, 0x0000004f10107212ULL, 0x000fe200078efcffULL,
0x0000000836417824ULL, 0x040fe400078e00ffULL, 0x0000000136367824ULL, 0x000fe200078e0213ULL,
0x000000103b107210ULL, 0x000fe20007fbe0ffULL, 0x00000001120c7824ULL, 0x000fe200078e0248ULL,
0xfffffff841417812ULL, 0x000fe200078ee20eULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x0000000812437824ULL, 0x000fe200078e00ffULL, 0x0000004f36367212ULL, 0x000fe200078efcffULL,
0x0000000112387824ULL, 0x100fe400078e0213ULL, 0x000000013a127824ULL, 0x000fe200078e0213ULL,
0xfffffff843437812ULL, 0x000fe200078ee20cULL, 0x0000008038387825ULL, 0x000fc800078e00ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000004f38387212ULL, 0x000fc600078efcffULL,
0x0000000111117824ULL, 0x000fe200028e063dULL, 0x0000003b36367210ULL, 0x000fe20007fbe0ffULL,
0x000000013a0c7824ULL, 0x000fe200078e0248ULL, 0x0000004f12127212ULL, 0x000fc600078efcffULL,
0x0000000137377824ULL, 0x100fe200028e063dULL, 0x0000003b38387210ULL, 0x080fe40007fbe0ffULL,
0x0000003b12127210ULL, 0x000fe20007fde0ffULL, 0x000000103f3b7824ULL, 0x000fe200078e0264ULL,
0xfffffff845457812ULL, 0x000fe200078ee20cULL, 0x0000000139397824ULL, 0x100fe400028e063dULL,
0x0000000113137824ULL, 0x000fe200030e063dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000103b7faeULL, 0x0003e2000e101c48ULL, 0x00000010413d7824ULL, 0x000fc400078e0264ULL,
0x00000010433f7824ULL, 0x100fe400078e0264ULL, 0x0000001045417824ULL, 0x000fe200078e0264ULL,
0x00000000363d7faeULL, 0x0003e8000d901c48ULL, 0x00000000383f7faeULL, 0x0003e8000d101c48ULL,
0x0000000012417faeULL, 0x0003e2000c101c48ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001010117812ULL, 0x000fe400078ec0ffULL, 0x000064000a3d7a11ULL, 0x000fc400078038ffULL,
0x0000001148117211ULL, 0x000fe400078fe8ffULL, 0x000065000a3f7a11ULL, 0x000fe400000f3cffULL,
0x00000004110e7810ULL, 0x040fe20007ffe0ffULL, 0x00000001110c7824ULL, 0x040fe200078e0248ULL,
0x0000000811377810ULL, 0x040fe20007ffe0ffULL, 0x00000008113b7824ULL, 0x040fe400078e00ffULL,
0x0000000111127824ULL, 0x140fe200078e0213ULL, 0x0000000c11117810ULL, 0x000fe20007ffe0ffULL,
0x000000010e367824ULL, 0x040fe200078e0213ULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee20cULL,
0x000000010e0c7824ULL, 0x000fc400078e0248ULL, 0x000000080e417824ULL, 0x000fe400078e00ffULL,
0x0000000137387824ULL, 0x100fe400078e0213ULL, 0x0000000111107824ULL, 0x000fe200078e0213ULL,
0xfffffff841417812ULL, 0x000fe200078ee20cULL, 0x00000001370e7824ULL, 0x140fe400078e0248ULL,
0x0000000837437824ULL, 0x000fe400078e00ffULL, 0x0000000111377824ULL, 0x000fc400078e0248ULL,
0x00000008113a7824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee20eULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff83a457812ULL, 0x000fe200078ee237ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004f12127212ULL, 0x000fc600078efcffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x000000123d127210ULL, 0x040fe40007f1e0ffULL,
0x0000004f36367212ULL, 0x080fe200078efcffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000004f38387212ULL, 0x080fe400078efcffULL, 0x000000363d367210ULL, 0x000fe20007f5e0ffULL,
0x0000000113137824ULL, 0x100fe200000e063fULL, 0x0000004f10107212ULL, 0x000fe200078efcffULL,
0x000000103b3b7824ULL, 0x100fe200078e0264ULL, 0x000000383d387210ULL, 0x000fe20007f1e0ffULL,
0x0000000137377824ULL, 0x100fe200010e063fULL, 0x000000103d107210ULL, 0x000fe20007f7e0ffULL,
0x00000010413d7824ULL, 0x000fe200078e0264ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000123b7faeULL, 0x0003e2000b901c48ULL, 0x0000000139397824ULL, 0x000fc400000e063fULL,
0x0000000111117824ULL, 0x000fe200018e063fULL, 0x00000000363d7faeULL, 0x0003e2000b901c48ULL,
0x00000010433f7824ULL, 0x100fe400078e0264ULL, 0x0000001045417824ULL, 0x000fc600078e0264ULL,
0x00000000383f7faeULL, 0x0003e8000b901c48ULL, 0x0000000010417faeULL, 0x0003e4000b901c48ULL,
0x00000008020c7824ULL, 0x000fca00078e00ffULL, 0xfffffff00c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000000c0573c2ULL, 0x000ee200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000f6a805057890ULL, 0x008fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a8000c107f8cULL, 0x0022e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f628000b127f8cULL, 0x0002a4000c80043fULL, 0x0000000000367805ULL, 0x000fc40000015200ULL,
0x00f62c000b397984ULL, 0x000f240000000800ULL, 0x8000000039ff7812ULL, 0x014fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038363b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e37ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x002fc80000011439ULL,
0x0000003b0c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x000000020c0c7819ULL, 0x000fc80000001239ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c000b397984ULL, 0x000ea40000000800ULL,
0x8000000039ff7812ULL, 0x004fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020020c7824ULL, 0x002fca00078e00ffULL, 0xffffff800c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000804f0c7810ULL, 0x000fca0007ffe00cULL, 0x00000001650c7824ULL, 0x000fca00078e020cULL,
0x00f000000c367984ULL, 0x000e680000000800ULL, 0x00f200000c377984ULL, 0x0004e20000000800ULL,
0x000000093600720bULL, 0x002fe20003f1d000ULL, 0x000115a27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000e7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0e397812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0c7424ULL, 0x000fd600078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x000000016c137810ULL, 0x000fe40007ffe0ffULL,
0x000000093600720bULL, 0x000fe40003f54000ULL, 0x000000021300720cULL, 0x000fe20003f05270ULL,
0x000115527f007947ULL, 0x000fd4000b800000ULL, 0x00000000000c7806ULL, 0x000fc400010e0100ULL,
0x0000008002128824ULL, 0x000fe200078e024fULL, 0x00000009360e8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x0000000165138824ULL, 0x000fe200078e0212ULL,
0x000099100c127816ULL, 0x000fc800000000ffULL, 0x00f4000e13008388ULL, 0x0003e20000000800ULL,
0x000000ff1200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x00000009360e7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0cff7812ULL, 0x000fc6000780c0ffULL, 0x000000090e0e7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0e0e7820ULL, 0x000fc80000410000ULL, 0x0000000e00387308ULL, 0x000e640000000800ULL,
0x000000380d0d7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0e7819ULL, 0x000fe20000011648ULL, 0x000114727f007947ULL, 0x000fea000b800000ULL,
0x00001f0e380e7589ULL, 0x0002a400000e0000ULL, 0x0000000e30307220ULL, 0x084fe20000410000ULL,
0x0000000e31317220ULL, 0x080fe20000410000ULL, 0x0000000e2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000e2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000e28287220ULL, 0x080fe20000410000ULL,
0x0000000e29297220ULL, 0x080fe20000410000ULL, 0x0000000e24247220ULL, 0x080fe20000410000ULL,
0x0000000e25257220ULL, 0x080fe20000410000ULL, 0x0000000e20207220ULL, 0x080fe20000410000ULL,
0x0000000e21217220ULL, 0x080fe20000410000ULL, 0x0000000e1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000e1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000e18187220ULL, 0x080fe20000410000ULL,
0x0000000e19197220ULL, 0x080fe20000410000ULL, 0x0000000e14147220ULL, 0x080fe20000410000ULL,
0x0000000e15157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008480e7811ULL, 0x000fe200078ff0ffULL, 0x000113527f007947ULL, 0x000fea000b800000ULL,
0x00001f0e380e7589ULL, 0x00046400000e0000ULL, 0x0000000e32327220ULL, 0x086fe20000410000ULL,
0x0000000e33337220ULL, 0x080fe20000410000ULL, 0x0000000e2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000e2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000e2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000e2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000e26267220ULL, 0x080fe20000410000ULL,
0x0000000e27277220ULL, 0x080fe20000410000ULL, 0x0000000e22227220ULL, 0x080fe20000410000ULL,
0x0000000e23237220ULL, 0x080fe20000410000ULL, 0x0000000e1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000e1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000e1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000e1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000e16167220ULL, 0x080fe20000410000ULL,
0x0000000e17177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff39ff7812ULL, 0x000fe2000780600cULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000936097209ULL, 0x000fd60007810000ULL, 0x8000000936360221ULL, 0x000fe20000010000ULL,
0x00007610ff0c0816ULL, 0x000fc6000000000cULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600060308ULL, 0x000e640000000800ULL, 0x0000000637370220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000d370d7221ULL, 0x008fc20000010000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x00000008020e7824ULL, 0x000fca00078e00ffULL,
0xfffffff00e387812ULL, 0x000fca00078ec0ffULL, 0x00f6b40038377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003612397210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e13ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc80000011437ULL, 0x000000390e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x000000020e0e7819ULL, 0x000fc80000001237ULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6b40038377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100c0c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0c00720cULL, 0x000fda0003f65270ULL,
0x0000012000003947ULL, 0x000fea0003800000ULL, 0x00000006ff07723eULL, 0x000fe400000010ffULL,
0x00000002ff357819ULL, 0x000fe40000011648ULL, 0x00005410070c7816ULL, 0x000fe20000000007ULL,
0x00010f027f007947ULL, 0x000fea000b800000ULL, 0x00001f350c077589ULL, 0x0002a400000e0000ULL,
0x00000008350e7810ULL, 0x000fe20007ffe0ffULL, 0x00010f327f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0c087589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010350e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e000cULL,
0x0000670000137802ULL, 0x000fc40000000f00ULL, 0x0001174000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018350e7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e000cULL, 0x0000675000137802ULL, 0x000fc40000000f00ULL,
0x000116f000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00001000640c7810ULL, 0x00afca0007ffe0ffULL,
0x0000001044407824ULL, 0x100fe400078e020cULL, 0x000000104c3c7824ULL, 0x100fe400078e020cULL,
0x000000104d347824ULL, 0x000fe400078e020cULL, 0x000000004040783bULL, 0x000e680000004200ULL,
0x000000003c3c783bULL, 0x000fe80000004200ULL, 0x000000003434783bULL, 0x000fe20000004200ULL,
0x0000010041387824ULL, 0x002fe200078e00ffULL, 0x00000040000e7306ULL, 0x004fe20000009400ULL,
0x0000010040127824ULL, 0x000fc400078e00ffULL, 0x0000010043747824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe40000011438ULL, 0x009800004e38783bULL, 0x000e620000000200ULL,
0x00000018ff507819ULL, 0x000fe20000011412ULL, 0x0000004000137306ULL, 0x000ea20000005400ULL,
0x00000018ff747819ULL, 0x000fce0000011474ULL, 0x0000004100627306ULL, 0x000ff00000009400ULL,
0x0000004100677306ULL, 0x000ee20000005400ULL, 0x000000130e00720bULL, 0x004fe40003f1d000ULL,
0x0000005000137245ULL, 0x000fca000020d400ULL, 0x0000005000127306ULL, 0x000ff00000209400ULL,
0x0000005000457306ULL, 0x0005220000205400ULL, 0x000000676200720bULL, 0x008fe20003f9d000ULL,
0x000000073838b231ULL, 0x002fcc00003400ffULL, 0x00000066006a7306ULL, 0x000fe20000209400ULL,
0x00000018ff507819ULL, 0x004fe20000011440ULL, 0x000000073a3ab231ULL, 0x000fe400003400ffULL,
0x000000083939b231ULL, 0x080fe400003400ffULL, 0x000000083b3bb231ULL, 0x000fe400003400ffULL,
0x00000066006d7306ULL, 0x0002a20000205400ULL, 0x000000451200720bULL, 0x010fce0003f5d000ULL,
0x0000004000467306ULL, 0x000722000000d400ULL, 0x0000006600667245ULL, 0x002fca000020d400ULL,
0x0000000113132812ULL, 0x000fe400078efcffULL, 0x0000004100477306ULL, 0x000e62000000d400ULL,
0x0000006d6a00720bULL, 0x004fe20003fbd000ULL, 0x0001000040407824ULL, 0x008fca00078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000004200497306ULL, 0x000fe20000009400ULL,
0x0000000146460812ULL, 0x010fc800078efcffULL, 0x000000461346723eULL, 0x000fe400000010ffULL,
0x0000000166665812ULL, 0x000fe200078efcffULL, 0x00000042005a7306ULL, 0x000ea20000005400ULL,
0x0000000147474812ULL, 0x002fc800078efcffULL, 0x000000476647723eULL, 0x000fe400000010ffULL,
0x00000018ff667819ULL, 0x000fe20000011441ULL, 0x0000004000677306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x000fc600078e00ffULL, 0x000000463830723cULL, 0x000b640000041830ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000005a4900720bULL, 0x004fe20003f9d000ULL,
0x0000005000627306ULL, 0x000ff00000209400ULL, 0x00000040005a7306ULL, 0x0002b00000205400ULL,
0x00000050006d7306ULL, 0x000ee20000205400ULL, 0x0000004000407245ULL, 0x002fce000020d400ULL,
0x0000006600477306ULL, 0x020fe20000209400ULL, 0x0000005a6700720bULL, 0x004fe20003fbd000ULL,
0x00000100425a7824ULL, 0x000fe200078e00ffULL, 0x0000005000677245ULL, 0x000fc8000020d400ULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x00000066006a7306ULL, 0x000e620000205400ULL,
0x0000006d6200720bULL, 0x008fca0003fdd000ULL, 0x0000000140405812ULL, 0x000fe400078efcffULL,
0x00000043005c7306ULL, 0x000fec0000009400ULL, 0x0000000167676812ULL, 0x000fe400078efcffULL,
0x0000004300617306ULL, 0x000ea20000005400ULL, 0x0000006a4700720bULL, 0x002fc40003f1d000ULL,
0x000000406740723eULL, 0x000fca00000010ffULL, 0x0000004100477306ULL, 0x000ff00000209400ULL,
0x0000004100627306ULL, 0x0002e20000205400ULL, 0x000000615c00720bULL, 0x004fce0003f5d000ULL,
0x0000005a00617306ULL, 0x000fe20000209400ULL, 0x0000004100417245ULL, 0x002fce000020d400ULL,
0x0000005a006a7306ULL, 0x000e620000205400ULL, 0x000000624700720bULL, 0x008fe40003fbd000ULL,
0x00000018ff627819ULL, 0x000fca0000011443ULL, 0x00000074005c7306ULL, 0x000fec0000209400ULL,
0x0000000141415812ULL, 0x000fe400078efcffULL, 0x00000074006d7306ULL, 0x0004e20000205400ULL,
0x0000006a6100720bULL, 0x002fe40003fdd000ULL, 0x00000018ff617819ULL, 0x000fc40000011442ULL,
0x00000066006a7245ULL, 0x000fc6000020d400ULL, 0x0000004200587306ULL, 0x000322000000d400ULL,
0x000000016a6a0812ULL, 0x000fe400078efcffULL, 0x0000007400747245ULL, 0x004fe4000020d400ULL,
0x000000416a41723eULL, 0x000fc600000010ffULL, 0x0000004300577306ULL, 0x000522000000d400ULL,
0x0001000042427824ULL, 0x002fe200078e00ffULL, 0x0000006d5c00720bULL, 0x008fe40003fbd000ULL,
0x00000040382c723cULL, 0x000b64000004182cULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x0000006100477306ULL, 0x000fe20000209400ULL, 0x0001000043437824ULL, 0x004fe200078e00ffULL,
0x0000000158584812ULL, 0x010fc400078efcffULL, 0x0000005a00417245ULL, 0x020fe4000020d400ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000006100677306ULL, 0x0002a20000205400ULL,
0x0000000141416812ULL, 0x000fe400078efcffULL, 0x0000000157572812ULL, 0x000fe400078efcffULL,
0x0000000174745812ULL, 0x000fe400078efcffULL, 0x000000584140723eULL, 0x000fe200000010ffULL,
0x00000062005c7306ULL, 0x000fe20000209400ULL, 0x000000577441723eULL, 0x000fc400000010ffULL,
0x0000006100617245ULL, 0x002fca000020d400ULL, 0x0000006200667306ULL, 0x0002e20000205400ULL,
0x000000674700720bULL, 0x004fe20003f5d000ULL, 0x000000403828723cULL, 0x000b6c0000041828ULL,
0x00000042006a7306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x002fe4000020d400ULL,
0x0000004200407245ULL, 0x020fc4000020d400ULL, 0x0000004300417245ULL, 0x000fe4000020d400ULL,
0x0000000161612812ULL, 0x000fe200078efcffULL, 0x00000042006e7306ULL, 0x000e620000205400ULL,
0x000000665c00720bULL, 0x008fe40003fbd000ULL, 0x00000018ff667819ULL, 0x000fca000001143dULL,
0x00000043006d7306ULL, 0x000fec0000209400ULL, 0x0000000162625812ULL, 0x000fe400078efcffULL,
0x0000004300757306ULL, 0x000ea20000205400ULL, 0x0000006e6a00720bULL, 0x002fe20003f1d000ULL,
0x000001003c6a7824ULL, 0x000fc400078e00ffULL, 0x000100003d6e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000003d005f7306ULL, 0x000fe20000009400ULL,
0x00000018ff6e7819ULL, 0x000fca000001146eULL, 0x0000000140400812ULL, 0x000fe400078efcffULL,
0x000000756d00720bULL, 0x004fe20003f9d000ULL, 0x000001003d6d7824ULL, 0x000fe200078e00ffULL,
0x000000406140723eULL, 0x000fe200000010ffULL, 0x0000003d00607306ULL, 0x000e620000005400ULL,
0x00000018ff617819ULL, 0x000fe4000001143cULL, 0x00000018ff6d7819ULL, 0x000fca000001146dULL,
0x0000006d00437306ULL, 0x000fe40000209400ULL, 0x0000000141414812ULL, 0x000fc800078efcffULL,
0x000000416241723eULL, 0x000fe400000010ffULL, 0x0000003c005d7306ULL, 0x000fe20000009400ULL,
0x000000605f00720bULL, 0x002fc80003f9d000ULL, 0x000000403824723cULL, 0x000b660000041824ULL,
0x0000006d00407306ULL, 0x020e680000205400ULL, 0x000000104b417824ULL, 0x000fc800078e020cULL,
0x0000003c005e7306ULL, 0x000eb00000005400ULL, 0x0000006a00427306ULL, 0x000fe20000209400ULL,
0x000000404300720bULL, 0x002fce0003fbd000ULL, 0x0000006a00677306ULL, 0x000e620000205400ULL,
0x0000005e5d00720bULL, 0x004fe40003f1d000ULL, 0x0000006d005e7245ULL, 0x000fc8000020d400ULL,
0x000000015e5e5812ULL, 0x000fe200078efcffULL, 0x0000003d00597306ULL, 0x000eb0000000d400ULL,
0x0000003c005b7306ULL, 0x000722000000d400ULL, 0x000000674200720bULL, 0x002fe20003f5d000ULL,
0x000100003c677824ULL, 0x000fe200078e00ffULL, 0x000000004140783bULL, 0x000e680000004200ULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000006100627306ULL, 0x000fe20000209400ULL,
0x0000000159594812ULL, 0x004fc400078efcffULL, 0x0000006a003c7245ULL, 0x008fe4000020d400ULL,
0x000000595e3d723eULL, 0x000fe400000010ffULL, 0x000000013c3c2812ULL, 0x000fe200078efcffULL,
0x0000006100747306ULL, 0x0004e20000205400ULL, 0x000000015b5b0812ULL, 0x010fc800078efcffULL,
0x0000005b3c3c723eULL, 0x000fc600000010ffULL, 0x00000066005f7306ULL, 0x000fe20000209400ULL,
0x0000006100617245ULL, 0x004fc6000020d400ULL, 0x0000003c3820723cULL, 0x000b680000041820ULL,
0x0000006600757306ULL, 0x0005220000205400ULL, 0x000000746200720bULL, 0x008fe20003f5d000ULL,
0x000001003e627824ULL, 0x000fe200078e00ffULL, 0x0000006600747245ULL, 0x000fe2000020d400ULL,
0x000001003f3c7824ULL, 0x020fe200078e00ffULL, 0x0000006e003d7245ULL, 0x000fe4000020d400ULL,
0x00000018ff627819ULL, 0x000fe20000011462ULL, 0x0000006700607306ULL, 0x000fe20000209400ULL,
0x00000018ff667819ULL, 0x004fc4000001143cULL, 0x00000067003c7245ULL, 0x000fc6000020d400ULL,
0x0000000161612812ULL, 0x000fe400078efcffULL, 0x0000006700767306ULL, 0x000ea20000205400ULL,
0x000000755f00720bULL, 0x010fe40003fbd000ULL, 0x0000006600757245ULL, 0x000fca000020d400ULL,
0x0000006e006a7306ULL, 0x000fec0000209400ULL, 0x0000000174745812ULL, 0x000fe400078efcffULL,
0x0000006e00597306ULL, 0x000ee20000205400ULL, 0x000000766000720bULL, 0x004fce0003f1d000ULL,
0x0000003f00557306ULL, 0x000fec0000009400ULL, 0x000000013c3c0812ULL, 0x000fe400078efcffULL,
0x000000596a00720bULL, 0x008fe20003f9d000ULL, 0x0000003f00547306ULL, 0x000ea20000005400ULL,
0x0000003c613c723eULL, 0x000fce00000010ffULL, 0x0000006600677306ULL, 0x000fe80000209400ULL,
0x000000013d3d4812ULL, 0x000fc800078efcffULL, 0x00000066006e7306ULL, 0x000ee20000205400ULL,
0x0000003d743d723eULL, 0x000fe400000010ffULL, 0x000000545500720bULL, 0x004fe40003fbd000ULL,
0x00000018ff547819ULL, 0x000fe4000001143eULL, 0x00000018ff557819ULL, 0x000fe2000001143fULL,
0x00000062006a7306ULL, 0x000fe20000209400ULL, 0x0000003c381c723cULL, 0x000b6e000004181cULL,
0x00000062006d7306ULL, 0x000ea20000205400ULL, 0x0000006e6700720bULL, 0x008fe20003fdd000ULL,
0x000100003e677824ULL, 0x000fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000003e00537306ULL, 0x000fec0000009400ULL, 0x0000000175756812ULL, 0x000fe400078efcffULL,
0x0000003e00517306ULL, 0x000ee20000005400ULL, 0x0000006d6a00720bULL, 0x004fe20003f9d000ULL,
0x000100003f6a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x00000054003c7306ULL, 0x020ff00000209400ULL, 0x00000054003d7306ULL, 0x000ea20000205400ULL,
0x000000515300720bULL, 0x008fce0003f5d000ULL, 0x0000003e00567306ULL, 0x000ef0000000d400ULL,
0x0000003f00527306ULL, 0x000f22000000d400ULL, 0x0000003d3c00720bULL, 0x004fe40003f1d000ULL,
0x00000062003d7245ULL, 0x000fc8000020d400ULL, 0x000000013d3d4812ULL, 0x000fe200078efcffULL,
0x00000067006d7306ULL, 0x000fe20000209400ULL, 0x0000000156562812ULL, 0x008fc800078efcffULL,
0x000000563d3c723eULL, 0x000fe400000010ffULL, 0x00000018ff567819ULL, 0x000fe20000011434ULL,
0x0000006700767306ULL, 0x000ea20000205400ULL, 0x0000000152525812ULL, 0x010fc800078efcffULL,
0x00000052753d723eULL, 0x000fc600000010ffULL, 0x0000005500537306ULL, 0x000fe80000209400ULL,
0x0000003c3818723cULL, 0x000b680000041818ULL, 0x00000055006e7306ULL, 0x0007220000205400ULL,
0x000000766d00720bULL, 0x004fe40003f5d000ULL, 0x00000054003d7245ULL, 0x020fc4000020d400ULL,
0x00000067003c7245ULL, 0x000fe4000020d400ULL, 0x0000006a00547245ULL, 0x000fe2000020d400ULL,
0x0000006a003f7306ULL, 0x000fe20000209400ULL, 0x0000005500557245ULL, 0x008fe4000020d400ULL,
0x000000013d3d0812ULL, 0x000fc600078efcffULL, 0x000000013c3c2812ULL, 0x000fe400078efcffULL,
0x0000006a00747306ULL, 0x000ea20000205400ULL, 0x0000006e5300720bULL, 0x010fe40003fbd000ULL,
0x0000003c3d3c723eULL, 0x000fca00000010ffULL, 0x0000003400127306ULL, 0x000fec0000009400ULL,
0x0000000155555812ULL, 0x000fe400078efcffULL, 0x000000743f00720bULL, 0x004fe20003f9d000ULL,
0x0000003400457306ULL, 0x000eb00000005400ULL, 0x0000003500137306ULL, 0x000fe80000009400ULL,
0x0000000154544812ULL, 0x000fc800078efcffULL, 0x00000054553d723eULL, 0x000fe200000010ffULL,
0x0000003500497306ULL, 0x000ee20000005400ULL, 0x000000451200720bULL, 0x004fe20003f9d000ULL,
0x0000010035127824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011435ULL,
0x00000018ff457819ULL, 0x000fe20000011437ULL, 0x0000003c3838723cULL, 0x000b620000041814ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x00000056006a7306ULL, 0x000fea0000209400ULL,
0x0000010034147824ULL, 0x020fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc40000011436ULL,
0x0000005600677306ULL, 0x0005e20000205400ULL, 0x000000491300720bULL, 0x008fe40003f1d000ULL,
0x00000018ff757819ULL, 0x000fe40000011414ULL, 0x00000018ff497819ULL, 0x002fc60000011440ULL,
0x0000007500157306ULL, 0x000fe20000209400ULL, 0x0000005600567245ULL, 0x004fce000020d400ULL,
0x0000007500167306ULL, 0x0002b00000205400ULL, 0x00000034000e7306ULL, 0x000ee2000000d400ULL,
0x0000007500757245ULL, 0x002fe4000020d400ULL, 0x000000161500720bULL, 0x004fca0003f5d000ULL,
0x0000003700587306ULL, 0x000fe20000009400ULL, 0x000000010e0e4812ULL, 0x008fce00078efcffULL,
0x00000037005c7306ULL, 0x000e620000005400ULL, 0x0000000175752812ULL, 0x000fe400078efcffULL,
0x000000676a00720bULL, 0x000fca0003f5d000ULL, 0x0000001200147306ULL, 0x000fe20000209400ULL,
0x0000000e750e723eULL, 0x000fce00000010ffULL, 0x0000001200137306ULL, 0x0004e20000205400ULL,
0x0000005c5800720bULL, 0x002fe20003fbd000ULL, 0x00010000345c7824ULL, 0x000fe200078e00ffULL,
0x0000000156562812ULL, 0x000fe400078efcffULL, 0x00000018ff347819ULL, 0x000fe40000011441ULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x00000040005d7306ULL, 0x000fe20000009400ULL,
0x0000001200127245ULL, 0x004fce000020d400ULL, 0x00000040005e7306ULL, 0x000e620000005400ULL,
0x000000131400720bULL, 0x008fe20003f9d000ULL, 0x0001000035137824ULL, 0x000fe200078e00ffULL,
0x009800000f14783bULL, 0x0004e80000000200ULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0000003500467306ULL, 0x000f2c000000d400ULL, 0x0000000112124812ULL, 0x000fc400078efcffULL,
0x0000005e5d00720bULL, 0x002fe20003f5d000ULL, 0x00000041005f7306ULL, 0x000fe20000009400ULL,
0x00000100365d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x0000004100607306ULL, 0x000e620000005400ULL, 0x0000000146460812ULL, 0x010fc800078efcffULL,
0x00000046120f723eULL, 0x004fe400000010ffULL, 0x00000018ff127819ULL, 0x000fe20000011442ULL,
0x0000005c00677306ULL, 0x000ff00000209400ULL, 0x0000005c005e7306ULL, 0x0005220000205400ULL,
0x000000605f00720bULL, 0x002fe20003f9d000ULL, 0x000000071414b231ULL, 0x008fc400003400ffULL,
0x000000071616b231ULL, 0x000fe400003400ffULL, 0x000000081515b231ULL, 0x080fe400003400ffULL,
0x0000001300607306ULL, 0x000fe20000209400ULL, 0x0000005c005c7245ULL, 0x004fe2000020d400ULL,
0x000000081717b231ULL, 0x000fe200003400ffULL, 0x0000005e6700720bULL, 0x010fca0003f1d000ULL,
0x0000005400557306ULL, 0x000fe20000209400ULL, 0x0000000e1430723cULL, 0x000b6e0000041830ULL,
0x0000001300677306ULL, 0x000e620000205400ULL, 0x00000100370e7824ULL, 0x020fe200078e00ffULL,
0x00000013000f7245ULL, 0x000fc4000020d400ULL, 0x000000015c5c0812ULL, 0x000fe400078efcffULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x00000054006d7306ULL, 0x000eb00000205400ULL,
0x0000005d005e7306ULL, 0x000fe20000209400ULL, 0x000000676000720bULL, 0x002fce0003f1d000ULL,
0x0000005d005f7306ULL, 0x0002e20000205400ULL, 0x0000006d5500720bULL, 0x004fca0003f7d000ULL,
0x000000010f0f0812ULL, 0x000fe400078efcffULL, 0x0000004200617306ULL, 0x000fe20000009400ULL,
0x0000005d005d7245ULL, 0x002fce000020d400ULL, 0x0000004200517306ULL, 0x000fe20000005400ULL,
0x0000005f5e00720bULL, 0x008fe20003f1d000ULL, 0x00010000365f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000003600507306ULL, 0x000fec0000009400ULL,
0x000000015d5d0812ULL, 0x000fe400078efcffULL, 0x00000036005a7306ULL, 0x000e700000005400ULL,
0x0000000e00137306ULL, 0x000ff00000209400ULL, 0x0000000e00607306ULL, 0x000ea20000205400ULL,
0x0000005a5000720bULL, 0x002fce0003fdd000ULL, 0x0000003600477306ULL, 0x0002f0000000d400ULL,
0x0000005f005e7306ULL, 0x000fe20000209400ULL, 0x0000005400367245ULL, 0x002fe4000020d400ULL,
0x000000601300720bULL, 0x004fe20003f1d000ULL, 0x0001000037607824ULL, 0x000fe200078e00ffULL,
0x0000000136363812ULL, 0x000fc400078efcffULL, 0x000000516100720bULL, 0x000fe20003f7d000ULL,
0x0000003700577306ULL, 0x000e62000000d400ULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000010040617824ULL, 0x000fe200078e00ffULL, 0x0000000147476812ULL, 0x008fe400078efcffULL,
0x00000018ff137819ULL, 0x000fe40000011443ULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000005f00517306ULL, 0x000ea20000205400ULL, 0x0000000f360f723eULL, 0x000fce00000010ffULL,
0x0000004300527306ULL, 0x000fe20000009400ULL, 0x0000000157575812ULL, 0x002fce00078efcffULL,
0x0000004300537306ULL, 0x000e620000005400ULL, 0x000000515e00720bULL, 0x004fe40003fdd000ULL,
0x0000000e005e7245ULL, 0x000fc8000020d400ULL, 0x000000015e5e0812ULL, 0x000fe200078efcffULL,
0x0000003c003d7306ULL, 0x000fe60000209400ULL, 0x000000575e57723eULL, 0x000fca00000010ffULL,
0x0000003c00627306ULL, 0x000ea20000205400ULL, 0x000000535200720bULL, 0x002fe40003f1d000ULL,
0x0000005f00527245ULL, 0x000fe4000020d400ULL, 0x0000003c00537245ULL, 0x000fe4000020d400ULL,
0x0000000152526812ULL, 0x000fe200078efcffULL, 0x0000006000677306ULL, 0x000ff00000209400ULL,
0x00000060000e7306ULL, 0x000e620000205400ULL, 0x000000623d00720bULL, 0x004fe20003fbd000ULL,
0x0001000040627824ULL, 0x000fe200078e00ffULL, 0x00000060003d7245ULL, 0x000fc8000020d400ULL,
0x00000018ff627819ULL, 0x000fe20000011462ULL, 0x0000004500667306ULL, 0x000fec0000209400ULL,
0x0000000153535812ULL, 0x000fe400078efcffULL, 0x0000004500507306ULL, 0x0004e20000205400ULL,
0x0000000e6700720bULL, 0x002fe20003fdd000ULL, 0x00000100410e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff0e7819ULL, 0x000fe2000001140eULL, 0x00000061005f7306ULL, 0x000fe20000209400ULL,
0x0000004500457245ULL, 0x004fca000020d400ULL, 0x000000013d3d6812ULL, 0x000fe400078efcffULL,
0x00000061006a7306ULL, 0x000e620000205400ULL, 0x000000506600720bULL, 0x008fe20003fbd000ULL,
0x0000010042507824ULL, 0x000fca00078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000004900587306ULL, 0x000fec0000209400ULL, 0x0000000145455812ULL, 0x000fe400078efcffULL,
0x00000049005a7306ULL, 0x0004e20000205400ULL, 0x0000006a5f00720bULL, 0x002fe20003fdd000ULL,
0x00010000415f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000000e003c7306ULL, 0x000fe20000209400ULL, 0x0000004900497245ULL, 0x004fce000020d400ULL,
0x0000000e006d7306ULL, 0x000e620000205400ULL, 0x0000005a5800720bULL, 0x008fe40003fbd000ULL,
0x0000006100587245ULL, 0x000fc8000020d400ULL, 0x0000000158586812ULL, 0x000fe200078efcffULL,
0x0000006200677306ULL, 0x000fec0000209400ULL, 0x0000000149495812ULL, 0x000fe400078efcffULL,
0x00000062006a7306ULL, 0x000ea20000205400ULL, 0x0000006d3c00720bULL, 0x002fe20003fdd000ULL,
0x00000100433c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x00000040005b7306ULL, 0x0002f0000000d400ULL, 0x0000003400357306ULL, 0x000fe20000209400ULL,
0x0000000e00407245ULL, 0x002fc4000020d400ULL, 0x0000005c560e723eULL, 0x000fe400000010ffULL,
0x0000000140406812ULL, 0x000fe400078efcffULL, 0x0000006a6700720bULL, 0x004fe20003fdd000ULL,
0x0000003400557306ULL, 0x0002a20000205400ULL, 0x000000015b5b2812ULL, 0x008fe200078efcffULL,
0x0000000e142c723cULL, 0x000b62000004182cULL, 0x000000475d56723eULL, 0x000fe400000010ffULL,
0x0000005b5858723eULL, 0x000fc600000010ffULL, 0x0000004100597306ULL, 0x000ee2000000d400ULL,
0x00000052530e723eULL, 0x020fe200000010ffULL, 0x000000561428723cULL, 0x000f620000041828ULL,
0x0000003400347245ULL, 0x002fe4000020d400ULL, 0x0000003d450f723eULL, 0x000fc600000010ffULL,
0x0000005f00667306ULL, 0x000fe20000209400ULL, 0x000000553500720bULL, 0x004fe20003f5d000ULL,
0x0001000042357824ULL, 0x000fe400078e00ffULL, 0x0000000e1424723cULL, 0x000b660000041824ULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000005f00757306ULL, 0x0002a20000205400ULL,
0x0000000159594812ULL, 0x008fc800078efcffULL, 0x000000594059723eULL, 0x000fe400000010ffULL,
0x0000000134342812ULL, 0x000fe200078efcffULL, 0x0000001200467306ULL, 0x000fe20000209400ULL,
0x0000005f005f7245ULL, 0x002fc6000020d400ULL, 0x000000581420723cULL, 0x000f680000041820ULL,
0x0000001200547306ULL, 0x000fe20000205400ULL, 0x000000756600720bULL, 0x004fce0003f9d000ULL,
0x0000005000607306ULL, 0x000fec0000209400ULL, 0x000000015f5f4812ULL, 0x000fe400078efcffULL,
0x0000005000617306ULL, 0x000e640000205400ULL, 0x0000005f340f723eULL, 0x020fcc00000010ffULL,
0x00000043003f7306ULL, 0x0004f0000000d400ULL, 0x0000001300377306ULL, 0x000fe20000209400ULL,
0x0001000043437824ULL, 0x004fe200078e00ffULL, 0x000000616000720bULL, 0x002fc80003fbd000ULL,
0x00000018ff367819ULL, 0x000fe40000011443ULL, 0x0000001300517306ULL, 0x0002a20000205400ULL,
0x0000006200437245ULL, 0x000fe4000020d400ULL, 0x000000013f3f0812ULL, 0x008fe400078efcffULL,
0x0000000143436812ULL, 0x000fe400078efcffULL, 0x000000544600720bULL, 0x000fe20003fdd000ULL,
0x00000042003e7306ULL, 0x000ee2000000d400ULL, 0x00000043490e723eULL, 0x000fc400000010ffULL,
0x0000001300137245ULL, 0x002fca000020d400ULL, 0x0000003c00557306ULL, 0x000fe20000209400ULL,
0x000000513700720bULL, 0x004fe20003f9d000ULL, 0x0000000e141c723cULL, 0x000b62000004181cULL,
0x0000005000377245ULL, 0x000fc8000020d400ULL, 0x0000000137375812ULL, 0x000fe200078efcffULL,
0x0000003c005a7306ULL, 0x0002a20000205400ULL, 0x000000013e3e3812ULL, 0x008fe400078efcffULL,
0x00000012000f7245ULL, 0x020fe2000020d400ULL, 0x0000000202127824ULL, 0x000fe200078e00ffULL,
0x00000035000e7245ULL, 0x000fe4000020d400ULL, 0x000000010f0f6812ULL, 0x000fe200078efcffULL,
0x0000003500417306ULL, 0x000fe20000209400ULL, 0x0000003c003c7245ULL, 0x002fc4000020d400ULL,
0x0000000113134812ULL, 0x000fe400078efcffULL, 0x0000003e373e723eULL, 0x000fe400000010ffULL,
0xfffffff812127812ULL, 0x000fe200078ec0ffULL, 0x0000003500427306ULL, 0x000e620000205400ULL,
0x0000005a5500720bULL, 0x004fce0003f5d000ULL, 0x0000003600477306ULL, 0x000fec0000209400ULL,
0x000000013c3c2812ULL, 0x000fe400078efcffULL, 0x0000003600467306ULL, 0x0004e20000205400ULL,
0x000000424100720bULL, 0x002fe40003fbd000ULL, 0x0000003f3c3f723eULL, 0x000fc400000010ffULL,
0x0000003600367245ULL, 0x004fca000020d400ULL, 0x0000003e1418723cULL, 0x000f680000041818ULL,
0x000000010e0e5812ULL, 0x000fe400078efcffULL, 0x000000464700720bULL, 0x008fe40003f7d000ULL,
0x0000000e0f0e723eULL, 0x000fd600000010ffULL, 0x0000000136363812ULL, 0x000fc800078efcffULL,
0x00000036130f723eULL, 0x000fce00000010ffULL, 0x0000000e1414723cULL, 0x000b6e0000041838ULL,
0x0000f6c84a0e7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000000e0e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6900012ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff367224ULL, 0x000fc600078e00ffULL,
0x0000000000127805ULL, 0x004fc80000015200ULL, 0x0000040005357984ULL, 0x000ea40000000800ULL,
0x8000000035ff7812ULL, 0x006fc4000780480fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003412377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e13ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040005357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000100000f7824ULL, 0x000fca00078e0279ULL, 0x000000c00f127810ULL, 0x000fc80007ffe0ffULL,
0x00000060120e7812ULL, 0x000fca00078ec0ffULL, 0x0000000169137824ULL, 0x000fe200078e020eULL,
0x0000040000009947ULL, 0x000fea0003800000ULL, 0x00000012030e7217ULL, 0x000fe20007800000ULL,
0x0000001002347824ULL, 0x000fe200078e00ffULL, 0x000064000a3d7a11ULL, 0x000fc600078a38ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0a12ULL, 0x0000001034357812ULL, 0x000fe400078ec0ffULL,
0x00000003ff127819ULL, 0x000fe40000011648ULL, 0x0000000e350e7217ULL, 0x000fe40007800000ULL,
0x0000000412347810ULL, 0x040fe40007ffe0ffULL, 0x0000000812377810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0e7824ULL, 0x100fe200078e0a35ULL, 0x0000000c12387810ULL, 0x000fe20007ffe0ffULL,
0x0000000134367824ULL, 0x000fe200078e0235ULL, 0x000065000a3f7a11ULL, 0x000fc400028f3cffULL,
0x0000000e1200720cULL, 0x0c0fe20003f86070ULL, 0x0000000112127824ULL, 0x100fe200078e0235ULL,
0x0000000e3400720cULL, 0x080fe20003f66070ULL, 0x00000001383a7824ULL, 0x000fe200078e0235ULL,
0x0000000e3700720cULL, 0x0c0fe20003f46070ULL, 0x0000000112347824ULL, 0x000fe200078e0213ULL,
0x0000000e3800720cULL, 0x000fe20003f06070ULL, 0x0000000137377824ULL, 0x000fe400078e0235ULL,
0x00000001120e7824ULL, 0x040fe400078e0248ULL, 0x00000008123b7824ULL, 0x000fc400078e00ffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee20eULL,
0x0000000136127824ULL, 0x100fe200078e0248ULL, 0x0000004f34347212ULL, 0x000fe200078efcffULL,
0x0000000836417824ULL, 0x040fe400078e00ffULL, 0x0000000136367824ULL, 0x100fe200078e0213ULL,
0x0000003d34347210ULL, 0x000fe20007fbe0ffULL, 0x00000001370e7824ULL, 0x000fe200078e0248ULL,
0xfffffff841417812ULL, 0x000fe200078ee212ULL, 0x0000000837437824ULL, 0x040fe400078e00ffULL,
0x0000000137387824ULL, 0x000fc400078e0213ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fc600078ee20eULL, 0x000000013a127824ULL, 0x000fe200078e0213ULL,
0x0000004f36367212ULL, 0x000fe200078efcffULL, 0x0000008038387825ULL, 0x000fc800078e00ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000004f38387212ULL, 0x000fc600078efcffULL,
0x0000000135357824ULL, 0x100fe200028e063fULL, 0x0000003d36367210ULL, 0x000fe20007fbe0ffULL,
0x000000013a0a7824ULL, 0x000fe200078e0248ULL, 0x0000004f12127212ULL, 0x000fe200078efcffULL,
0x000000083a457824ULL, 0x000fe400078e00ffULL, 0x0000000137377824ULL, 0x100fe200028e063fULL,
0x0000003d38387210ULL, 0x080fe20007fbe0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e020cULL,
0x0000003d12127210ULL, 0x000fe20007fde0ffULL, 0x00000010413d7824ULL, 0x000fe200078e020cULL,
0xfffffff845457812ULL, 0x000fe200078ee20aULL, 0x0000000139397824ULL, 0x100fe200028e063fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000343b7faeULL, 0x0003e2000e101c48ULL,
0x0000000113137824ULL, 0x000fc400030e063fULL, 0x00000010433f7824ULL, 0x100fe200078e020cULL,
0x00000000363d7faeULL, 0x0003e2000d901c48ULL, 0x0000001045417824ULL, 0x000fc600078e020cULL,
0x00000000383f7faeULL, 0x0003e8000d101c48ULL, 0x0000000012417faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x00000010020e7824ULL, 0x000fe200078e00ffULL,
0x000064000a3d7a11ULL, 0x000fc800078038ffULL, 0x000000100e357812ULL, 0x000fe400078ec0ffULL,
0x000065000a3f7a11ULL, 0x000fe400000f3cffULL, 0x0000003548357211ULL, 0x000fc800078fe8ffULL,
0x0000000435127810ULL, 0x040fe20007ffe0ffULL, 0x00000001350e7824ULL, 0x040fe200078e0248ULL,
0x0000000835377810ULL, 0x040fe20007ffe0ffULL, 0x00000008353b7824ULL, 0x040fe400078e00ffULL,
0x0000000135367824ULL, 0x140fe200078e0213ULL, 0x0000000c35357810ULL, 0x000fe20007ffe0ffULL,
0x0000000112387824ULL, 0x040fe200078e0213ULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee20eULL,
0x00000001120e7824ULL, 0x040fe400078e0248ULL, 0x0000000812417824ULL, 0x000fc400078e00ffULL,
0x0000000137347824ULL, 0x100fe400078e0213ULL, 0x0000000135127824ULL, 0x000fe200078e0213ULL,
0xfffffff841417812ULL, 0x000fe200078ee20eULL, 0x0000000137137824ULL, 0x140fe400078e0248ULL,
0x00000008373a7824ULL, 0x000fe400078e00ffULL, 0x0000000135397824ULL, 0x040fe400078e0248ULL,
0x00000008353c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83a437812ULL, 0x000fe200078ee213ULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff83c457812ULL, 0x000fe200078ee239ULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000004f36367212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000003d36367210ULL, 0x000fe40007f1e0ffULL,
0x0000004f38387212ULL, 0x080fe200078efcffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000004f34347212ULL, 0x000fe400078efcffULL, 0x0000003d38387210ULL, 0x000fe20007f5e0ffULL,
0x0000000137377824ULL, 0x100fe200000e063fULL, 0x0000004f12127212ULL, 0x000fe200078efcffULL,
0x000000103b3b7824ULL, 0x100fe200078e020cULL, 0x0000003d34347210ULL, 0x080fe20007f1e0ffULL,
0x0000000139397824ULL, 0x100fe200010e063fULL, 0x0000003d12127210ULL, 0x000fe20007f7e0ffULL,
0x00000010413d7824ULL, 0x000fe200078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000363b7faeULL, 0x0003e2000b901c48ULL, 0x0000000135357824ULL, 0x000fc400000e063fULL,
0x0000000113137824ULL, 0x000fe200018e063fULL, 0x00000000383d7faeULL, 0x0003e2000b901c48ULL,
0x00000010433f7824ULL, 0x100fe400078e020cULL, 0x0000001045417824ULL, 0x000fc600078e020cULL,
0x00000000343f7faeULL, 0x0003e8000b901c48ULL, 0x0000000012417faeULL, 0x0003e4000b901c48ULL,
0x000000006f0573c2ULL, 0x000ea200000e0000ULL, 0x0000000268687810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff497424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000716800720cULL, 0x000fda0003f06070ULL, 0x0000000168128824ULL, 0x002fe400078e026bULL,
0x00000004ff138424ULL, 0x000fe200078e00ffULL, 0x0000f6b005057890ULL, 0x004fc6000fffe03fULL,
0x0000660012128625ULL, 0x000fca00078e0013ULL, 0x0000000812498981ULL, 0x000322000c1e1900ULL,
0x00000008020a7824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a05ULL,
0xfffffff00a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6b0000a347f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f648000b127f8cULL, 0x0022a4000c80043fULL,
0x0000000000367805ULL, 0x000fc40000015200ULL, 0x00f64c000b397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x006fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x00000038363b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e37ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc80000011439ULL, 0x0000003b0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x000000020a0a7819ULL, 0x000fc80000001239ULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f64c000b397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020020a7824ULL, 0x000fca00078e00ffULL,
0xffffff800a0a7812ULL, 0x000fc800078ec0ffULL, 0x000001004f0a7810ULL, 0x000fca0007ffe00aULL,
0x00000001650a7824ULL, 0x000fca00078e020aULL, 0x00f000000a367984ULL, 0x000e680000000800ULL,
0x00f200000a0b7984ULL, 0x0004e20000000800ULL, 0x000000093600720bULL, 0x002fe20003f1d000ULL,
0x0000e2927f007947ULL, 0x000fd8000b800000ULL, 0x00000000000e7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0e387812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff0a7224ULL, 0x000fd200078e0009ULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x000000026c137810ULL, 0x000fe40007ffe0ffULL,
0x000000093600720bULL, 0x000fe40003f54000ULL, 0x000000021300720cULL, 0x000fe20003f05270ULL,
0x0000e2327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000377806ULL, 0x000fc400010e0100ULL,
0x00000080020e8824ULL, 0x000fe200078e024fULL, 0x00000009360a7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x0000000165138824ULL, 0x000fe200078e020eULL,
0x00009910370e7816ULL, 0x000fc800000000ffULL, 0x00f4000a13008388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x000000090a097221ULL, 0x002fe20000010100ULL, 0x000000ff37ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x00000009003a7308ULL, 0x000e640000000800ULL, 0x0000003a0d0d7220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0e7819ULL, 0x000fe20000011648ULL,
0x0000e1627f007947ULL, 0x000fea000b800000ULL, 0x00001f0e3a0e7589ULL, 0x0002a400000e0000ULL,
0x0000000e30307220ULL, 0x084fe20000410000ULL, 0x0000000e31317220ULL, 0x080fe20000410000ULL,
0x0000000e2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000e2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000e28287220ULL, 0x080fe20000410000ULL, 0x0000000e29297220ULL, 0x080fe20000410000ULL,
0x0000000e24247220ULL, 0x080fe20000410000ULL, 0x0000000e25257220ULL, 0x080fe20000410000ULL,
0x0000000e20207220ULL, 0x080fe20000410000ULL, 0x0000000e21217220ULL, 0x080fe20000410000ULL,
0x0000000e1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000e1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000e18187220ULL, 0x080fe20000410000ULL, 0x0000000e19197220ULL, 0x080fe20000410000ULL,
0x0000000e14147220ULL, 0x080fe20000410000ULL, 0x0000000e15157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0037ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008480e7811ULL, 0x000fe200078ff0ffULL,
0x0000e0427f007947ULL, 0x000fea000b800000ULL, 0x00001f0e3a0e7589ULL, 0x00046400000e0000ULL,
0x0000000e32327220ULL, 0x086fe20000410000ULL, 0x0000000e33337220ULL, 0x080fe20000410000ULL,
0x0000000e2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000e2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000e2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000e2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000e26267220ULL, 0x080fe20000410000ULL, 0x0000000e27277220ULL, 0x080fe20000410000ULL,
0x0000000e22227220ULL, 0x080fe20000410000ULL, 0x0000000e23237220ULL, 0x080fe20000410000ULL,
0x0000000e1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000e1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000e1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000e1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000e16167220ULL, 0x080fe20000410000ULL, 0x0000000e17177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff38ff7812ULL, 0x000fe20007806037ULL,
0x00000001ff0e7424ULL, 0x000fd800078e00ffULL, 0x8000000a36360221ULL, 0x000fe20000010000ULL,
0x00007610ff0e0816ULL, 0x000fc6000000000eULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600060308ULL, 0x000e640000000800ULL, 0x000000060b0b0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000d0b0d7221ULL, 0x008fc20000010000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000000802097824ULL, 0x000fca00078e00ffULL,
0xfffffff0090b7812ULL, 0x000fca00078ec0ffULL, 0x00f6ac000b097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003612367210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e13ULL,
0x003d09003600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011437ULL, 0x0000003609097211ULL, 0x000fca00078110ffULL,
0x000000ffff367224ULL, 0x000fca00000e0637ULL, 0x0000000209097819ULL, 0x000fc80000001236ULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac000b097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100e097816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0900720cULL, 0x000fda0003f65270ULL,
0x0000012000003947ULL, 0x000fea0003800000ULL, 0x00000006ff07723eULL, 0x000fe400000010ffULL,
0x00000002ff107819ULL, 0x000fe40000011648ULL, 0x0000541007097816ULL, 0x000fe20000000007ULL,
0x0000dc027f007947ULL, 0x000fea000b800000ULL, 0x00001f1009077589ULL, 0x0002a400000e0000ULL,
0x00000008100e7810ULL, 0x000fe20007ffe0ffULL, 0x0000dc327f007947ULL, 0x000fea000b800000ULL,
0x00001f0e09087589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010100e7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e0009ULL,
0x00009bc000137802ULL, 0x000fc40000000f00ULL, 0x0000e28000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018100e7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e0009ULL, 0x00009c1000137802ULL, 0x000fc40000000f00ULL,
0x0000e23000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001044447824ULL, 0x100fe200078e0264ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000104d107824ULL, 0x002fc400078e0264ULL, 0x000000104c387824ULL, 0x000fe400078e0264ULL,
0x000000004444783bULL, 0x000e680000004200ULL, 0x000000003838783bULL, 0x000fe80000004200ULL,
0x000000001010783bULL, 0x000fe20000004200ULL, 0x0000010044507824ULL, 0x002fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011444ULL, 0x00000044000e7306ULL, 0x00cfe20000009400ULL,
0x00000018ff427819ULL, 0x000fc40000011445ULL, 0x00000018ff507819ULL, 0x000fca0000011450ULL,
0x00000044003d7306ULL, 0x000e700000005400ULL, 0x00000036003e7306ULL, 0x000ff00000209400ULL,
0x0000003600437306ULL, 0x000ea20000205400ULL, 0x0000003d0e00720bULL, 0x002fe20003fbd000ULL,
0x00000100450e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x00000050003c7306ULL, 0x000ff00000209400ULL, 0x00000050003f7306ULL, 0x000e620000205400ULL,
0x000000433e00720bULL, 0x004fe20003f1d000ULL, 0x0001000044437824ULL, 0x000fca00078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x00000045004d7306ULL, 0x000ff00000009400ULL,
0x0000004500667306ULL, 0x000ea20000005400ULL, 0x0000003f3c00720bULL, 0x002fc40003fdd000ULL,
0x00a000004e3c783bULL, 0x000e6a0000000200ULL, 0x0000004200677306ULL, 0x000ff00000209400ULL,
0x00000042006a7306ULL, 0x0006e20000205400ULL, 0x000000664d00720bULL, 0x004fce0003f9d000ULL,
0x0000004400407306ULL, 0x000ea2000000d400ULL, 0x0000004200427245ULL, 0x008fce000020d400ULL,
0x0000000e00517306ULL, 0x000fe20000209400ULL, 0x0000006a6700720bULL, 0x000fe40003f5d000ULL,
0x0000005000677245ULL, 0x000fc8000020d400ULL, 0x0000000167676812ULL, 0x000fe200078efcffULL,
0x0000000e00667306ULL, 0x0006e20000205400ULL, 0x0000000140405812ULL, 0x004fe200078efcffULL,
0x000000073c3cb231ULL, 0x002fc600003400ffULL, 0x000000406740723eULL, 0x000fe200000010ffULL,
0x000000073e3eb231ULL, 0x000fe200003400ffULL, 0x0000000142422812ULL, 0x000fe200078efcffULL,
0x0000004500417306ULL, 0x0002a2000000d400ULL, 0x0000000e000e7245ULL, 0x008fe2000020d400ULL,
0x000000083d3db231ULL, 0x080fe400003400ffULL, 0x000000083f3fb231ULL, 0x000fe200003400ffULL,
0x000000665100720bULL, 0x000fe20003fdd000ULL, 0x0001000045457824ULL, 0x002fe400078e00ffULL,
0x0000004300447306ULL, 0x000fe60000209400ULL, 0x00000018ff457819ULL, 0x000fc40000011445ULL,
0x0000000141414812ULL, 0x004fc600078efcffULL, 0x0000004300517306ULL, 0x000e640000205400ULL,
0x000000010e0e6812ULL, 0x000fc800078efcffULL, 0x000000410e41723eULL, 0x000fe400000010ffULL,
0x0000004500667306ULL, 0x000fea0000209400ULL, 0x000000403c30723cULL, 0x000b660000041830ULL,
0x0000004500677306ULL, 0x0004e20000205400ULL, 0x000000514400720bULL, 0x002fe20003f9d000ULL,
0x0000010046447824ULL, 0x000fc400078e00ffULL, 0x0000003600417245ULL, 0x020fe4000020d400ULL,
0x0000004300407245ULL, 0x000fe4000020d400ULL, 0x0000004700597306ULL, 0x000fe20000009400ULL,
0x0000004500457245ULL, 0x004fe4000020d400ULL, 0x0000000141410812ULL, 0x000fe400078efcffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000000140404812ULL, 0x000fe200078efcffULL,
0x00000047005c7306ULL, 0x000e620000005400ULL, 0x000000676600720bULL, 0x008fc40003fbd000ULL,
0x000000404140723eULL, 0x000fca00000010ffULL, 0x0000004700587306ULL, 0x000eac000000d400ULL,
0x0000000145455812ULL, 0x000fe400078efcffULL, 0x00000046005a7306ULL, 0x000fe20000009400ULL,
0x0000005c5900720bULL, 0x002fe20003f9d000ULL, 0x00010000475c7824ULL, 0x040fe200078e00ffULL,
0x000000454241723eULL, 0x000fe200000010ffULL, 0x0000010047457824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fc40000011447ULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x00000046005d7306ULL, 0x000e620000005400ULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x000000403c40723cULL, 0x000be8000004182cULL, 0x0000000158584812ULL, 0x004fe400078efcffULL,
0x0000004500677306ULL, 0x000fe20000209400ULL, 0x000000104b2d7824ULL, 0x020fce00078e0264ULL,
0x00000045002c7306ULL, 0x0004e20000205400ULL, 0x0000005d5a00720bULL, 0x002fe40003f1d000ULL,
0x00000018ff5d7819ULL, 0x000fca0000011446ULL, 0x0000004400667306ULL, 0x000fe20000209400ULL,
0x0000004500457245ULL, 0x004fe4000020d400ULL, 0x0000002c6700720bULL, 0x008fca0003fbd000ULL,
0x00000044006d7306ULL, 0x0002a20000205400ULL, 0x0001000046677824ULL, 0x000fe200078e00ffULL,
0x000000002d2c783bULL, 0x000ee80000004200ULL, 0x00000018ff677819ULL, 0x000fe40000011467ULL,
0x00000046005b7306ULL, 0x000ea2000000d400ULL, 0x0000004400447245ULL, 0x002fe4000020d400ULL,
0x0000000145455812ULL, 0x000fc400078efcffULL, 0x0000006d6600720bULL, 0x004fc60003f5d000ULL,
0x0000005d006a7306ULL, 0x000fe20000209400ULL, 0x000000584545723eULL, 0x000fe400000010ffULL,
0x000000015b5b0812ULL, 0x000fca00078efcffULL, 0x0000005d00667306ULL, 0x0002a40000205400ULL,
0x0000000144442812ULL, 0x000fcc00078efcffULL, 0x00000059006e7306ULL, 0x000fe20000209400ULL,
0x0000005b4444723eULL, 0x000fe400000010ffULL, 0x0000005d005d7245ULL, 0x002fca000020d400ULL,
0x0000005900747306ULL, 0x0002e20000205400ULL, 0x000000666a00720bULL, 0x004fe20003f5d000ULL,
0x000000443c28723cULL, 0x000b620000041828ULL, 0x00000018ff667819ULL, 0x000fe20000011438ULL,
0x00000100396a7824ULL, 0x000fc800078e00ffULL, 0x00000067006d7306ULL, 0x000fe20000209400ULL,
0x0000005900447245ULL, 0x020fe4000020d400ULL, 0x0000005c00597245ULL, 0x002fe4000020d400ULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x000000015d5d2812ULL, 0x000fe200078efcffULL,
0x0000006700757306ULL, 0x000e620000205400ULL, 0x000000746e00720bULL, 0x008fce0003fbd000ULL,
0x0000005c00767306ULL, 0x000fec0000209400ULL, 0x0000000144445812ULL, 0x000fe400078efcffULL,
0x0000005c00587306ULL, 0x000ea20000205400ULL, 0x000000756d00720bULL, 0x002fce0003f1d000ULL,
0x0000003800607306ULL, 0x000fe20000009400ULL, 0x000000587600720bULL, 0x004fce0003f9d000ULL,
0x00000038005f7306ULL, 0x000e620000005400ULL, 0x0000006700587245ULL, 0x000fe2000020d400ULL,
0x0000010038677824ULL, 0x000fc600078e00ffULL, 0x0000000158580812ULL, 0x000fe400078efcffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000006600747306ULL, 0x000fe20000209400ULL,
0x000000585d58723eULL, 0x000fe400000010ffULL, 0x0000000159594812ULL, 0x000fca00078efcffULL,
0x0000006600757306ULL, 0x000ea20000205400ULL, 0x000000594459723eULL, 0x000fe400000010ffULL,
0x0000005f6000720bULL, 0x002fca0003fdd000ULL, 0x0000003900627306ULL, 0x000fe20000009400ULL,
0x000000583c24723cULL, 0x000bee0000041824ULL, 0x0000003900617306ULL, 0x000e620000005400ULL,
0x00000018ff587819ULL, 0x020fe20000011439ULL, 0x0001000038597824ULL, 0x000fe200078e00ffULL,
0x000000757400720bULL, 0x004fc80003f5d000ULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x00000038005e7306ULL, 0x000eb0000000d400ULL, 0x0000006a006d7306ULL, 0x000fe20000209400ULL,
0x000000616200720bULL, 0x002fe20003f1d000ULL, 0x0001000039617824ULL, 0x000fca00078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000006a006e7306ULL, 0x0002e20000205400ULL,
0x000000015e5e6812ULL, 0x004fce00078efcffULL, 0x0000005800607306ULL, 0x000fe20000209400ULL,
0x0000006a006a7245ULL, 0x002fce000020d400ULL, 0x0000005800757306ULL, 0x000e620000205400ULL,
0x0000006e6d00720bULL, 0x008fce0003fbd000ULL, 0x0000006700767306ULL, 0x000fec0000209400ULL,
0x000000016a6a5812ULL, 0x000fe400078efcffULL, 0x0000006700787306ULL, 0x0004e20000205400ULL,
0x000000756000720bULL, 0x002fce0003fdd000ULL, 0x0000003900377306ULL, 0x000e62000000d400ULL,
0x0000006700677245ULL, 0x004fce000020d400ULL, 0x0000005900627306ULL, 0x000fe20000209400ULL,
0x000000787600720bULL, 0x008fce0003f9d000ULL, 0x00000059006d7306ULL, 0x000ea20000205400ULL,
0x0000000137370812ULL, 0x002fc800078efcffULL, 0x000000376a39723eULL, 0x000fe400000010ffULL,
0x0000000167674812ULL, 0x000fe200078efcffULL, 0x00000061006e7306ULL, 0x000fe60000209400ULL,
0x0000005e6738723eULL, 0x000fe400000010ffULL, 0x0000006600677245ULL, 0x000fe2000020d400ULL,
0x000001003b667824ULL, 0x000fe400078e00ffULL, 0x0000006100757306ULL, 0x0002e20000205400ULL,
0x0000006d6200720bULL, 0x004fe20003f1d000ULL, 0x000000383c20723cULL, 0x000f620000041820ULL,
0x0000005800627245ULL, 0x000fe2000020d400ULL, 0x00000100116d7824ULL, 0x000fe200078e00ffULL,
0x0000005900587245ULL, 0x000fc4000020d400ULL, 0x0000006100597245ULL, 0x000fe2000020d400ULL,
0x0000003a00577306ULL, 0x000fe20000009400ULL, 0x0000000167672812ULL, 0x000fe400078efcffULL,
0x0000000162626812ULL, 0x000fe400078efcffULL, 0x00000018ff617819ULL, 0x002fe4000001143aULL,
0x0000000158580812ULL, 0x000fe200078efcffULL, 0x0000003a00557306ULL, 0x000e620000005400ULL,
0x000000756e00720bULL, 0x008fc40003f9d000ULL, 0x000000586758723eULL, 0x000fe400000010ffULL,
0x00000018ff667819ULL, 0x000fe40000011466ULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000006100677306ULL, 0x000fec0000205400ULL, 0x0000000159594812ULL, 0x000fc400078efcffULL,
0x000000555700720bULL, 0x002fe20003fdd000ULL, 0x0000003b00567306ULL, 0x000fe20000009400ULL,
0x000000596259723eULL, 0x000fe400000010ffULL, 0x00000018ff577819ULL, 0x000fca000001143bULL,
0x000000583c1c723cULL, 0x000b62000004181cULL, 0x0000006100627306ULL, 0x0002ac0000209400ULL,
0x000001003a597824ULL, 0x020fe400078e00ffULL, 0x0000003b00547306ULL, 0x000ee20000005400ULL,
0x0000006100617245ULL, 0x002fc4000020d400ULL, 0x00000018ff597819ULL, 0x000fca0000011459ULL,
0x0000005900587306ULL, 0x000fe20000209400ULL, 0x000000676200720bULL, 0x004fe20003f1d000ULL,
0x000100003b627824ULL, 0x000fca00078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011462ULL,
0x0000005900557306ULL, 0x000e620000205400ULL, 0x000000545600720bULL, 0x008fca0003fbd000ULL,
0x0000000161610812ULL, 0x000fe400078efcffULL, 0x00000066006a7306ULL, 0x000fe20000209400ULL,
0x000000555800720bULL, 0x002fce0003f5d000ULL, 0x0000006600677306ULL, 0x000e620000205400ULL,
0x000100003a587824ULL, 0x000fca00078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x0000003a00537306ULL, 0x0004f0000000d400ULL, 0x0000003b00527306ULL, 0x000ee2000000d400ULL,
0x000000676a00720bULL, 0x002fc40003f9d000ULL, 0x00000059003a7245ULL, 0x004fe4000020d400ULL,
0x00000018ff597819ULL, 0x000fe40000011412ULL, 0x000000013a3a2812ULL, 0x000fe200078efcffULL,
0x0000005800547306ULL, 0x000fe20000209400ULL, 0x0000000153536812ULL, 0x008fc800078efcffULL,
0x000000533a3a723eULL, 0x000fc600000010ffULL, 0x00000058003b7306ULL, 0x000e620000205400ULL,
0x0000000152525812ULL, 0x000fce00078efcffULL, 0x0000005700557306ULL, 0x000ff00000209400ULL,
0x0000005700567306ULL, 0x000ea20000205400ULL, 0x0000003b5400720bULL, 0x002fe40003fdd000ULL,
0x00000066003b7245ULL, 0x000fc8000020d400ULL, 0x000000013b3b4812ULL, 0x000fe200078efcffULL,
0x0000006200677306ULL, 0x000fe60000209400ULL, 0x000000523b3b723eULL, 0x000fca00000010ffULL,
0x00000062006a7306ULL, 0x000e620000205400ULL, 0x000000565500720bULL, 0x004fe20003f5d000ULL,
0x0000003a3c18723cULL, 0x000b620000041818ULL, 0x00000018ff557819ULL, 0x000fe40000011410ULL,
0x00000018ff567819ULL, 0x000fc60000011411ULL, 0x0000001000097306ULL, 0x000fe20000009400ULL,
0x00000058003a7245ULL, 0x020fe4000020d400ULL, 0x00000062003b7245ULL, 0x000fe4000020d400ULL,
0x000000013a3a6812ULL, 0x000fe400078efcffULL, 0x00000018ff587819ULL, 0x000fe20000011413ULL,
0x00000010004c7306ULL, 0x000ea20000005400ULL, 0x0000006a6700720bULL, 0x002fe40003f9d000ULL,
0x00000057006a7245ULL, 0x000fc4000020d400ULL, 0x0000003a613a723eULL, 0x000fe400000010ffULL,
0x000000016a6a2812ULL, 0x000fe200078efcffULL, 0x00000011004d7306ULL, 0x000fec0000009400ULL,
0x000000013b3b4812ULL, 0x000fe400078efcffULL, 0x00000011004e7306ULL, 0x000e620000005400ULL,
0x0000004c0900720bULL, 0x004fc40003f1d000ULL, 0x0000003b6a3b723eULL, 0x000fca00000010ffULL,
0x00000010000b7306ULL, 0x0004e4000000d400ULL, 0x0000003a3c3c723cULL, 0x000b6c0000041814ULL,
0x00000013005a7306ULL, 0x000fe20000009400ULL, 0x0000010010147824ULL, 0x020fe200078e00ffULL,
0x0000000748177812ULL, 0x000fe200078ec0ffULL, 0x0001000010107824ULL, 0x004fe200078e00ffULL,
0x0000004e4d00720bULL, 0x002fc40003fbd000ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000001300477306ULL, 0x000e620000005400ULL,
0x0000000817177812ULL, 0x000fe400078ef848ULL, 0x000000010b0b0812ULL, 0x008fe400078efcffULL,
0x00000018ff3a7819ULL, 0x000fe2000001142cULL, 0x00000008174c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001142dULL, 0x0000001400167306ULL, 0x000ff00000209400ULL,
0x0000001400097306ULL, 0x000ea20000205400ULL, 0x000000475a00720bULL, 0x002fce0003fdd000ULL,
0x0000001000157306ULL, 0x000ff00000209400ULL, 0x00000010004e7306ULL, 0x000e620000205400ULL,
0x000000091600720bULL, 0x004fe20003f5d000ULL, 0x0000020002167824ULL, 0x000fe200078e00ffULL,
0x0000000263097810ULL, 0x000fc80007ffe0ffULL, 0xfffffff84c097812ULL, 0x000fe200078ee209ULL,
0x0000001200507306ULL, 0x000fe20000009400ULL, 0xfffff80016167812ULL, 0x000fe400078ec0ffULL,
0x00000014004c7245ULL, 0x000fc6000020d400ULL, 0x0000001009147824ULL, 0x000fe200078e0216ULL,
0x000000014c4c2812ULL, 0x000fe200078efcffULL, 0x0000001200517306ULL, 0x000ea20000005400ULL,
0x0000004e1500720bULL, 0x002fe40003f5d000ULL, 0x00000010004e7245ULL, 0x000fe2000020d400ULL,
0x00a000001414783bULL, 0x000e680000000200ULL, 0x0000005500547306ULL, 0x000fec0000209400ULL,
0x000000014e4e2812ULL, 0x000fc400078efcffULL, 0x0000005500527306ULL, 0x0006e20000205400ULL,
0x000000515000720bULL, 0x004fe20003f9d000ULL, 0x0001000011517824ULL, 0x000fca00078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0000006d004d7306ULL, 0x000fe20000209400ULL,
0x0000005500557245ULL, 0x008fce000020d400ULL, 0x0000006d005a7306ULL, 0x0004e20000205400ULL,
0x000000525400720bULL, 0x000fce0003f1d000ULL, 0x0000002c004b7306ULL, 0x000fe20000009400ULL,
0x0000006d006d7245ULL, 0x004fe2000020d400ULL, 0x000000071414b231ULL, 0x002fc800003400ffULL,
0x0000000155550812ULL, 0x000fe200078efcffULL, 0x000000071616b231ULL, 0x000fe200003400ffULL,
0x0000002c005b7306ULL, 0x000e620000005400ULL, 0x0000005a4d00720bULL, 0x008fe20003f5d000ULL,
0x00000100125a7824ULL, 0x000fe200078e00ffULL, 0x000000081515b231ULL, 0x080fe400003400ffULL,
0x000000081717b231ULL, 0x000fe400003400ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x00000011000e7306ULL, 0x000eac000000d400ULL, 0x000000016d6d2812ULL, 0x000fc400078efcffULL,
0x0000005100107306ULL, 0x000fe20000209400ULL, 0x0000005b4b00720bULL, 0x002fe20003f1d000ULL,
0x00000100135b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0000005100117306ULL, 0x0002e20000205400ULL, 0x000000010e0e5812ULL, 0x004fce00078efcffULL,
0x0000005600537306ULL, 0x000fe20000209400ULL, 0x0000005100517245ULL, 0x002fce000020d400ULL,
0x0000005600667306ULL, 0x0002a20000205400ULL, 0x000000111000720bULL, 0x008fe40003fbd000ULL,
0x00000018ff107819ULL, 0x000fca000001142eULL, 0x0000005a004b7306ULL, 0x000fe20000209400ULL,
0x0000005600567245ULL, 0x002fca000020d400ULL, 0x0000000151515812ULL, 0x000fe400078efcffULL,
0x0000005a00527306ULL, 0x0002e20000205400ULL, 0x000000665300720bULL, 0x004fe20003f7d000ULL,
0x0001000012537824ULL, 0x000fe400078e00ffULL, 0x000001002d667824ULL, 0x000fc600078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000002d005d7306ULL, 0x000fe20000009400ULL,
0x0000005a005a7245ULL, 0x002fe4000020d400ULL, 0x00000018ff667819ULL, 0x000fc60000011466ULL,
0x0000000156563812ULL, 0x000fe400078efcffULL, 0x0000002d005c7306ULL, 0x000e620000005400ULL,
0x000000524b00720bULL, 0x008fce0003fbd000ULL, 0x0000005b00117306ULL, 0x000fec0000209400ULL,
0x000000015a5a5812ULL, 0x000fe400078efcffULL, 0x0000005b00527306ULL, 0x0004e20000205400ULL,
0x0000005c5d00720bULL, 0x002fe20003f5d000ULL, 0x000001002c5c7824ULL, 0x000fcc00078e00ffULL,
0x0000001200367306ULL, 0x000e62000000d400ULL, 0x0000005b005b7245ULL, 0x004fce000020d400ULL,
0x0000005300127306ULL, 0x000fe20000209400ULL, 0x000000521100720bULL, 0x008fe20003fbd000ULL,
0x0001000013527824ULL, 0x000fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fc8000001142fULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x00000053005d7306ULL, 0x0004e20000205400ULL,
0x0000000136364812ULL, 0x002fca00078efcffULL, 0x000000015b5b5812ULL, 0x000fe400078efcffULL,
0x0000001300467306ULL, 0x000e62000000d400ULL, 0x0000005300537245ULL, 0x004fce000020d400ULL,
0x0000005900577306ULL, 0x000fe20000209400ULL, 0x0000005d1200720bULL, 0x008fce0003f9d000ULL,
0x0000005900617306ULL, 0x0004e20000205400ULL, 0x0000000146466812ULL, 0x002fca00078efcffULL,
0x0000000153534812ULL, 0x000fe400078efcffULL, 0x0000005200137306ULL, 0x000fe20000209400ULL,
0x0000005900597245ULL, 0x004fce000020d400ULL, 0x0000005200127306ULL, 0x0002a20000205400ULL,
0x000000615700720bULL, 0x008fe40003fdd000ULL, 0x00000018ff577819ULL, 0x000fca000001145cULL,
0x0000002f005e7306ULL, 0x000fe20000009400ULL, 0x0000005200527245ULL, 0x002fca000020d400ULL,
0x0000000159596812ULL, 0x000fe400078efcffULL, 0x0000002f00397306ULL, 0x000e620000005400ULL,
0x000000121300720bULL, 0x004fce0003f9d000ULL, 0x00000057005c7306ULL, 0x000fec0000209400ULL,
0x0000000152524812ULL, 0x000fe400078efcffULL, 0x00000057005d7306ULL, 0x0004e20000205400ULL,
0x000000395e00720bULL, 0x002fe20003fbd000ULL, 0x000100002c5e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000002c00457306ULL, 0x000e62000000d400ULL,
0x0000005700577245ULL, 0x004fce000020d400ULL, 0x0000005800627306ULL, 0x000fe20000209400ULL,
0x0000005d5c00720bULL, 0x008fe20003f9d000ULL, 0x000100002d5d7824ULL, 0x000fe400078e00ffULL,
0x000001002e5c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x00000058006a7306ULL, 0x0004e20000205400ULL, 0x0000000145450812ULL, 0x002fe400078efcffULL,
0x00000018ff5c7819ULL, 0x000fc6000001145cULL, 0x0000000157574812ULL, 0x000fe400078efcffULL,
0x0000006600127306ULL, 0x000fe20000209400ULL, 0x0000005800587245ULL, 0x004fce000020d400ULL,
0x0000006600137306ULL, 0x000e620000205400ULL, 0x0000006a6200720bULL, 0x008fce0003fdd000ULL,
0x0000002d00447306ULL, 0x000eac000000d400ULL, 0x0000000158586812ULL, 0x000fe400078efcffULL,
0x0000002e005f7306ULL, 0x000fe20000009400ULL, 0x000000131200720bULL, 0x002fe40003f1d000ULL,
0x0000000b4c12723eULL, 0x000fe200000010ffULL, 0x000100002e0b7824ULL, 0x000fe200078e00ffULL,
0x0000000e6d13723eULL, 0x000fe200000010ffULL, 0x000100002f4c7824ULL, 0x000fc400078e00ffULL,
0x0000002e00607306ULL, 0x000e620000005400ULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x000000121430723cULL, 0x000b620000041830ULL,
0x0000000144442812ULL, 0x004fc600078efcffULL, 0x0000003a00677306ULL, 0x000fe60000209400ULL,
0x000000365a12723eULL, 0x020fe400000010ffULL, 0x000000465b13723eULL, 0x000fc600000010ffULL,
0x0000003a00507306ULL, 0x000ea20000205400ULL, 0x000000605f00720bULL, 0x002fc60003f7d000ULL,
0x000000121428723cULL, 0x000b680000041828ULL, 0x0000005e002c7306ULL, 0x000fe60000209400ULL,
0x000000455712723eULL, 0x020fca00000010ffULL, 0x0000005e002d7306ULL, 0x0002e20000205400ULL,
0x000000506700720bULL, 0x004fe20003fdd000ULL, 0x000001002f507824ULL, 0x000fca00078e00ffULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000002e00377306ULL, 0x0004e2000000d400ULL,
0x0000005e005e7245ULL, 0x002fce000020d400ULL, 0x0000003b00547306ULL, 0x000fe20000209400ULL,
0x00000066002e7245ULL, 0x004fc8000020d400ULL, 0x000000012e2e0812ULL, 0x000fe400078efcffULL,
0x0000002d2c00720bULL, 0x008fe20003f1d000ULL, 0x0000003b006e7306ULL, 0x000e620000205400ULL,
0x00000051562d723eULL, 0x000fe400000010ffULL, 0x0000003a00517245ULL, 0x000fe4000020d400ULL,
0x0000003b003a7245ULL, 0x000fe4000020d400ULL, 0x0000000151516812ULL, 0x000fe200078efcffULL,
0x0000001000477306ULL, 0x000fe20000209400ULL, 0x0000000137373812ULL, 0x000fc400078efcffULL,
0x0000004e552c723eULL, 0x000fe400000010ffULL, 0x000000015e5e0812ULL, 0x000fe400078efcffULL,
0x000000442e13723eULL, 0x000fe200000010ffULL, 0x00000010004d7306ULL, 0x0004e20000205400ULL,
0x0000006e5400720bULL, 0x002fe20003f9d000ULL, 0x0000002c1440723cULL, 0x040b6c0000041840ULL,
0x0000005d00627306ULL, 0x000fe20000209400ULL, 0x00000053592c723eULL, 0x020fe200000010ffULL,
0x000000121420723cULL, 0x000f620000041820ULL, 0x00000052582d723eULL, 0x000fc400000010ffULL,
0x0000001000107245ULL, 0x004fe4000020d400ULL, 0x000000013a3a4812ULL, 0x000fe200078efcffULL,
0x0000005d00677306ULL, 0x0002a20000205400ULL, 0x0000004d4700720bULL, 0x008fe20003f1d000ULL,
0x0000002c1424723cULL, 0x000b6c0000041824ULL, 0x0000005c00607306ULL, 0x000fe20000209400ULL,
0x0000005d005d7245ULL, 0x002fc4000020d400ULL, 0x0000005e512c723eULL, 0x020fc600000010ffULL,
0x0000000110100812ULL, 0x000fe400078efcffULL, 0x0000005c00617306ULL, 0x0002e20000205400ULL,
0x000000676200720bULL, 0x004fce0003f5d000ULL, 0x0000002f00387306ULL, 0x000ea2000000d400ULL,
0x0000005c005c7245ULL, 0x002fca000020d400ULL, 0x000000015d5d2812ULL, 0x000fe400078efcffULL,
0x0000005000547306ULL, 0x000fe20000209400ULL, 0x000000616000720bULL, 0x008fe40003fdd000ULL,
0x0000005d3a2d723eULL, 0x000fca00000010ffULL, 0x00000050005f7306ULL, 0x000e620000205400ULL,
0x0000000138385812ULL, 0x004fe200078efcffULL, 0x0000002c141c723cULL, 0x000f68000004181cULL,
0x000000015c5c6812ULL, 0x000fe400078efcffULL, 0x00000011004b7306ULL, 0x000fe40000209400ULL,
0x000000375c12723eULL, 0x000fcc00000010ffULL, 0x0000001100397306ULL, 0x000ea20000205400ULL,
0x0000005f5400720bULL, 0x002fce0003f9d000ULL, 0x0000000b000e7306ULL, 0x000ff00000209400ULL,
0x0000000b002f7306ULL, 0x0002e20000205400ULL, 0x000000394b00720bULL, 0x004fce0003f5d000ULL,
0x0000004c00367306ULL, 0x000fe20000209400ULL, 0x0000000b000b7245ULL, 0x002fce000020d400ULL,
0x0000004c00477306ULL, 0x000e620000205400ULL, 0x0000002f0e00720bULL, 0x008fe40003fdd000ULL,
0x00000050002f7245ULL, 0x000fe4000020d400ULL, 0x00000011000e7245ULL, 0x000fe4000020d400ULL,
0x0000004c00117245ULL, 0x000fe4000020d400ULL, 0x000000012f2f4812ULL, 0x000fe400078efcffULL,
0x000000010e0e2812ULL, 0x000fc400078efcffULL, 0x000000382f13723eULL, 0x000fe400000010ffULL,
0x000000010b0b6812ULL, 0x000fe400078efcffULL, 0x000000473600720bULL, 0x002fe40003f7d000ULL,
0x0000000b1010723eULL, 0x000fe200000010ffULL, 0x000000121418723cULL, 0x000f620000041818ULL,
0x0000f6986c0b7811ULL, 0x000fd200078e18ffULL, 0x0000000111113812ULL, 0x000fc800078efcffULL,
0x000000110e11723eULL, 0x000fce00000010ffULL, 0x000000101414723cULL, 0x000b6e000004183cULL,
0x0000f6c84a107811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000010107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000bff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff0e7224ULL, 0x000fc600078e00ffULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x00000400050b7984ULL, 0x004ea40000000800ULL,
0x800000000bff7812ULL, 0x006fc40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fcc0000015200ULL, 0x0000002c122c7210ULL, 0x000fca0007f1e1ffULL,
0x000000012d2d7824ULL, 0x000fe200000e0e13ULL, 0x003d09002c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc8000001142dULL,
0x0000002c0b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff2c7224ULL, 0x000fca00000e062dULL,
0x000000020b0b7819ULL, 0x000fc8000000122cULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400050b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000100057810ULL, 0x000fc80007ffe0ffULL, 0x000000040500720cULL, 0x000fda0003f06070ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x0000000200057810ULL, 0x000fe20007ffe0ffULL,
0x00005900490b7a24ULL, 0x010fe200078e02ffULL, 0x000001000f107810ULL, 0x000fe40007ffe0ffULL,
0x000000040500720cULL, 0x000fe20003f06070ULL, 0x000000800b057824ULL, 0x000fe200078e00ffULL,
0x00000060100e7812ULL, 0x000fca00078ec0ffULL, 0x00000001690f7824ULL, 0x000fcc00078e020eULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x00000010030b7217ULL, 0x000fe20007800000ULL,
0x00000010020e7824ULL, 0x000fc800078e00ffULL, 0x000000010b0b7824ULL, 0x000fe200078e0a10ULL,
0x000000100e0e7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff107819ULL, 0x000fe40000011648ULL,
0x0000000b0e0b7217ULL, 0x000fe40007800000ULL, 0x0000000410117810ULL, 0x040fe40007ffe0ffULL,
0x0000000810137810ULL, 0x040fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x100fe200078e0a0eULL,
0x0000000c102c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000111127824ULL, 0x000fc400078e020eULL,
0x00000001132d7824ULL, 0x100fe200078e020eULL, 0x0000000b1000720cULL, 0x0c0fe20003f86070ULL,
0x0000000110107824ULL, 0x100fe200078e020eULL, 0x0000000b1100720cULL, 0x080fe20003f66070ULL,
0x000000012c2e7824ULL, 0x040fe200078e020eULL, 0x0000000b2c00720cULL, 0x080fe20003f06070ULL,
0x0000000110117824ULL, 0x040fe200078e0248ULL, 0x0000000b1300720cULL, 0x000fe20003f46070ULL,
0x0000000810367824ULL, 0x040fe400078e00ffULL, 0x00000001102c7824ULL, 0x000fc400078e020fULL,
0x0000000112137824ULL, 0x100fe200078e0248ULL, 0xfffffff8362f7812ULL, 0x000fe200078ee211ULL,
0x0000000812387824ULL, 0x040fe400078e00ffULL, 0x0000000112107824ULL, 0x100fe400078e020fULL,
0x000000012d0e7824ULL, 0x040fe200078e020fULL, 0xfffffff838377812ULL, 0x000fe200078ee213ULL,
0x000000012d0b7824ULL, 0x040fe400078e0248ULL, 0x000000082d367824ULL, 0x000fc400078e00ffULL,
0x000000012e127824ULL, 0x040fe400078e020fULL, 0x000000012e0f7824ULL, 0x000fe200078e0248ULL,
0xfffffff836397812ULL, 0x000fe200078ee20bULL, 0x000000082e2e7824ULL, 0x000fe200078e00ffULL,
0x00006400050b7a11ULL, 0x000fe200078a38ffULL, 0x000000802c2c7825ULL, 0x000fc600078e00ffULL,
0xfffffff82e3b7812ULL, 0x000fe200078ee20fULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000004f2c2c7212ULL, 0x080fe400078efcffULL, 0x0000650005057a11ULL, 0x000fe200028f3cffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000004f10107212ULL, 0x000fe400078efcffULL,
0x0000002c0b2c7210ULL, 0x000fe20007fbe0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000b10107210ULL, 0x000fc40007fde0ffULL, 0x0000004f0e0e7212ULL, 0x080fe200078efcffULL,
0x000000012d2d7824ULL, 0x100fe200028e0605ULL, 0x0000004f12127212ULL, 0x000fe200078efcffULL,
0x0000000111117824ULL, 0x100fe200030e0605ULL, 0x0000000b0e0e7210ULL, 0x080fe20007fbe0ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0264ULL, 0x0000000b12127210ULL, 0x000fe20007fde0ffULL,
0x0000001037377824ULL, 0x100fe400078e0264ULL, 0x0000001039397824ULL, 0x000fe200078e0264ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000e101c48ULL,
0x000000010f0f7824ULL, 0x000fc400028e0605ULL, 0x000000103b3b7824ULL, 0x000fe200078e0264ULL,
0x0000000010377faeULL, 0x0003e2000d901c48ULL, 0x0000000113137824ULL, 0x000fc600030e0605ULL,
0x000000000e397faeULL, 0x0003e8000d101c48ULL, 0x00000000123b7faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x00000010020b7824ULL, 0x000fca00078e00ffULL,
0x000000100b0b7812ULL, 0x000fc800078ec0ffULL, 0x0000000b480b7211ULL, 0x000fc800078fe8ffULL,
0x000000040b117810ULL, 0x040fe20007ffe0ffULL, 0x000000010b107824ULL, 0x140fe200078e0248ULL,
0x000000080b137810ULL, 0x040fe20007ffe0ffULL, 0x000000080b2f7824ULL, 0x040fe200078e00ffULL,
0x0000000c0b2d7810ULL, 0x040fe20007ffe0ffULL, 0x000000010b0e7824ULL, 0x100fe400078e020fULL,
0x00000001110b7824ULL, 0x000fe200078e0248ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee210ULL,
0x00000008112e7824ULL, 0x040fe400078e00ffULL, 0x0000000111107824ULL, 0x000fc400078e020fULL,
0x0000000113127824ULL, 0x000fe200078e020fULL, 0xfffffff82e377812ULL, 0x000fe200078ee20bULL,
0x000000012d2c7824ULL, 0x000fe200078e020fULL, 0x00006400050b7a11ULL, 0x000fe200078038ffULL,
0x0000000113117824ULL, 0x040fe400078e0248ULL, 0x0000000813367824ULL, 0x000fe200078e00ffULL,
0x0000650005057a11ULL, 0x000fe200000f3cffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff836397812ULL, 0x000fe200078ee211ULL, 0x000000012d137824ULL, 0x040fe200078e0248ULL,
0x0000004f0e0e7212ULL, 0x080fe200078efcffULL, 0x000000082d387824ULL, 0x000fe400078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000e0b0e7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff8383b7812ULL, 0x000fe200078ee213ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000004f10107212ULL, 0x000fc600078efcffULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x0000004f12127212ULL, 0x000fc600078efcffULL, 0x000000010f0f7824ULL, 0x100fe200000e0605ULL,
0x0000004f2c2c7212ULL, 0x000fe200078efcffULL, 0x000000102f2f7824ULL, 0x100fe200078e0264ULL,
0x000000100b107210ULL, 0x000fe20007f1e0ffULL, 0x0000001037377824ULL, 0x100fe200078e0264ULL,
0x000000120b127210ULL, 0x000fe20007f5e0ffULL, 0x0000001039397824ULL, 0x000fe200078e0264ULL,
0x0000002c0b2c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000111117824ULL, 0x100fe200000e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e2f7faeULL, 0x0003e2000b901c48ULL,
0x0000000113137824ULL, 0x000fc400010e0605ULL, 0x000000103b3b7824ULL, 0x000fe200078e0264ULL,
0x0000000010377faeULL, 0x0003e2000b901c48ULL, 0x000000012d2d7824ULL, 0x000fc600018e0605ULL,
0x0000000012397faeULL, 0x0003e8000b901c48ULL, 0x000000002c3b7faeULL, 0x0003e4000b901c48ULL,
0x00000008020b7824ULL, 0x000fe400078e00ffULL, 0x000000104a057824ULL, 0x000fc600078e00ffULL,
0x000000080b0e7812ULL, 0x002fe400078ec0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000001005057812ULL, 0x000fc600078ee2ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x000000206c057824ULL, 0x000fc800078e0205ULL, 0x000000010e057824ULL, 0x000fe200078e0205ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a8006f0e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6680005107f8cULL, 0x000664000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x00f66c00050b7984ULL, 0x000ee40000000800ULL, 0x800000000bff7812ULL, 0x00afe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fcc0000015200ULL, 0x0000002c120e7210ULL, 0x004fca0007f1e1ffULL,
0x000000012d2c7824ULL, 0x000fe200000e0e13ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff2c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff2c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc8000001142cULL,
0x0000000e0b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e062cULL,
0x000000020b0b7819ULL, 0x000fc8000000120eULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c00050b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001806c0e7811ULL, 0x004fc800078e38ffULL, 0x0000000e650e7210ULL, 0x000fca0007ffe04fULL,
0x00f000000e057984ULL, 0x000e680000000800ULL, 0x00f200000e0b7984ULL, 0x0004e20000000800ULL,
0x0000000a0500720bULL, 0x002fe20003f1d000ULL, 0x0000af427f007947ULL, 0x000fd8000b800000ULL,
0x00000000000e7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0e2c7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff107224ULL, 0x000fd200078e000aULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000036c117810ULL, 0x000fe40007ffe0ffULL, 0x0000000a0500720bULL, 0x000fe40003f54000ULL,
0x000000021100720cULL, 0x000fe20003f05270ULL, 0x0000aee27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000117806ULL, 0x000fc400010e0100ULL, 0x00000080020e8824ULL, 0x000fe200078e024fULL,
0x0000000a05107209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x0000000165658824ULL, 0x000fe200078e020eULL, 0x00009910110e7816ULL, 0x000fc800000000ffULL,
0x00f4001065008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000a100a7221ULL, 0x002fe20000010100ULL,
0x000000ff11ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fcc0000410000ULL, 0x0000000a000a7308ULL, 0x000e640000000800ULL,
0x0000000a0d0d7220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0e7819ULL, 0x000fe20000011648ULL, 0x0000ae127f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0a0e7589ULL, 0x0002a400000e0000ULL, 0x0000000e30307220ULL, 0x084fe20000410000ULL,
0x0000000e31317220ULL, 0x080fe20000410000ULL, 0x0000000e40407220ULL, 0x080fe20000410000ULL,
0x0000000e41417220ULL, 0x080fe20000410000ULL, 0x0000000e28287220ULL, 0x080fe20000410000ULL,
0x0000000e29297220ULL, 0x080fe20000410000ULL, 0x0000000e24247220ULL, 0x080fe20000410000ULL,
0x0000000e25257220ULL, 0x080fe20000410000ULL, 0x0000000e20207220ULL, 0x080fe20000410000ULL,
0x0000000e21217220ULL, 0x080fe20000410000ULL, 0x0000000e1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000e1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000e18187220ULL, 0x080fe20000410000ULL,
0x0000000e19197220ULL, 0x080fe20000410000ULL, 0x0000000e14147220ULL, 0x080fe20000410000ULL,
0x0000000e15157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0011ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008480e7811ULL, 0x000fe200078ff0ffULL, 0x0000acf27f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0a0e7589ULL, 0x00046400000e0000ULL, 0x0000000e32327220ULL, 0x086fe20000410000ULL,
0x0000000e33337220ULL, 0x080fe20000410000ULL, 0x0000000e42427220ULL, 0x080fe20000410000ULL,
0x0000000e43437220ULL, 0x080fe20000410000ULL, 0x0000000e2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000e2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000e26267220ULL, 0x080fe20000410000ULL,
0x0000000e27277220ULL, 0x080fe20000410000ULL, 0x0000000e22227220ULL, 0x080fe20000410000ULL,
0x0000000e23237220ULL, 0x080fe20000410000ULL, 0x0000000e1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000e1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000e1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000e1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000e16167220ULL, 0x080fe20000410000ULL,
0x0000000e17177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff2cff7812ULL, 0x000fe20007806011ULL, 0x00000001ff0e7424ULL, 0x000fd800078e00ffULL,
0x0000000510050221ULL, 0x000fe20000010100ULL, 0x00007610ff0e0816ULL, 0x000fc6000000000eULL,
0x3fb8aa3b05050820ULL, 0x000fc80000410000ULL, 0x0000000500060308ULL, 0x000e640000000800ULL,
0x000000060b0b0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000d0b0d7221ULL, 0x008fc40000010000ULL, 0x00000000000a7805ULL, 0x000fca0000015200ULL,
0x00f6b4006f117984ULL, 0x000e620000000800ULL, 0x0000000402057824ULL, 0x000fca00078e00ffULL,
0x00000004052c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc600078e00ffULL,
0x000000022c2c7810ULL, 0x000fe40007ffe0ffULL, 0x8000000011ff7812ULL, 0x002fe20007804835ULL,
0x0000000470117824ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x000000120a2d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e0bULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000002d12127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6b4006f137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100e057816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0500720cULL, 0x000fda0003fa5270ULL, 0x0000012000005947ULL, 0x000fea0003800000ULL,
0x00000006ff05723eULL, 0x000fe400000010ffULL, 0x00000002ff0a7819ULL, 0x000fe40000011648ULL,
0x0000541005057816ULL, 0x000fe20000000005ULL, 0x0000a8727f007947ULL, 0x000fea000b800000ULL,
0x00001f0a05077589ULL, 0x0002a400000e0000ULL, 0x000000080a0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000a8a27f007947ULL, 0x000fea000b800000ULL, 0x00001f0e05087589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100a0e7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e0005ULL, 0x0000d11000137802ULL, 0x000fc40000000f00ULL,
0x0000ad3000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180a0e7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff127224ULL, 0x000fe200078e0005ULL,
0x0000d16000137802ULL, 0x000fc40000000f00ULL, 0x0000ace000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000007480b7812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000036c587810ULL, 0x000fc40007ffe0ffULL,
0x000000080b057812ULL, 0x00afc600078ef848ULL, 0x0000080058587824ULL, 0x000fe400078e00ffULL,
0x00000008050a7824ULL, 0x000fca00078e00ffULL, 0xfffffff80a637812ULL, 0x000fe400078ee263ULL,
0x00000008480a7812ULL, 0x000fc600078ec0ffULL, 0x0000001063447824ULL, 0x000fc400078e0258ULL,
0x0000001148117211ULL, 0x000fe400078fe0ffULL, 0x0000000b0a0e7212ULL, 0x044fe400078efcffULL,
0x000000100a397812ULL, 0x000fe400078efe0bULL, 0x0000002c48387211ULL, 0x000fe200078fe0ffULL,
0x000000010e057824ULL, 0x140fe400078e0211ULL, 0x000000080e127824ULL, 0x000fe400078e00ffULL,
0x00000001390a7824ULL, 0x000fc400078e0211ULL, 0x00000008390b7824ULL, 0x000fe200078e00ffULL,
0xfffffff812057812ULL, 0x000fc800078ee205ULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee20aULL,
0x0000001005057824ULL, 0x000fe400078e020cULL, 0x000000010e0a7824ULL, 0x040fe400078e0238ULL,
0x000000100b347824ULL, 0x000fe200078e020cULL, 0x00000000053c783bULL, 0x000e620000004200ULL,
0x0000000139387824ULL, 0x040fe400078e0238ULL, 0x000000080e0b7824ULL, 0x000fe400078e00ffULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0x000000003434783bULL, 0x000fe40000004200ULL,
0xfffffff80b0b7812ULL, 0x000fc400078ee20aULL, 0xfffffff839397812ULL, 0x000fc600078ee238ULL,
0x000000100b2c7824ULL, 0x100fe400078e020cULL, 0x0000001039397824ULL, 0x000fc800078e020cULL,
0x000000002c2c783bULL, 0x000fe20000004200ULL, 0x000001003d457824ULL, 0x002fe200078e00ffULL,
0x0000003c005e7306ULL, 0x000fe20000009400ULL, 0x000001003c387824ULL, 0x000fc600078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe40000011445ULL, 0x009000004444783bULL, 0x000e620000000200ULL,
0x00000018ff0c7819ULL, 0x000fe20000011438ULL, 0x0000003c00517306ULL, 0x000ea40000005400ULL,
0x000000003938783bULL, 0x000eec0000004200ULL, 0x0000003d00527306ULL, 0x000ff00000009400ULL,
0x0000003d00057306ULL, 0x000e620000005400ULL, 0x000000515e00720bULL, 0x004fce0003f1d000ULL,
0x0000000c00597306ULL, 0x000ff00000209400ULL, 0x0000000c006a7306ULL, 0x0004e20000205400ULL,
0x000000055200720bULL, 0x002fe40003f7d000ULL, 0x0000000c00057245ULL, 0x000fe2000020d400ULL,
0x000000074444d231ULL, 0x000fc800003400ffULL, 0x0000006d006e7306ULL, 0x000fe20000209400ULL,
0x0000006d000c7245ULL, 0x004fe2000020d400ULL, 0x000000074646d231ULL, 0x000fe400003400ffULL,
0x000000084545d231ULL, 0x080fe400003400ffULL, 0x000000084747d231ULL, 0x000fe400003400ffULL,
0x0000006d00757306ULL, 0x0002a20000205400ULL, 0x0000006a5900720bULL, 0x008fce0003f5d000ULL,
0x0000003c000a7306ULL, 0x000ee2000000d400ULL, 0x000100003c6d7824ULL, 0x002fca00078e00ffULL,
0x0000000105052812ULL, 0x000fe400078efcffULL, 0x0000003d000b7306ULL, 0x000e62000000d400ULL,
0x000000756e00720bULL, 0x004fe40003f9d000ULL, 0x00000018ff6d7819ULL, 0x000fca000001146dULL,
0x0000003e00567306ULL, 0x000fe20000009400ULL, 0x000000010a0a0812ULL, 0x008fc800078efcffULL,
0x0000000a050a723eULL, 0x000fe400000010ffULL, 0x000000010c0c4812ULL, 0x000fe200078efcffULL,
0x0000003e00557306ULL, 0x000ea20000005400ULL, 0x000000010b0b3812ULL, 0x002fc800078efcffULL,
0x0000000b0c0b723eULL, 0x000fe400000010ffULL, 0x00000018ff0c7819ULL, 0x000fe2000001143cULL,
0x0000003f00547306ULL, 0x000fe80000009400ULL, 0x0000000a4430723cULL, 0x000be20000041830ULL,
0x000000555600720bULL, 0x004fc60003f1d000ULL, 0x0000006d000b7306ULL, 0x020fe60000209400ULL,
0x00000018ff0a7819ULL, 0x000fe2000001143dULL, 0x000100003d3d7824ULL, 0x000fc800078e00ffULL,
0x0000006d00567306ULL, 0x000e620000205400ULL, 0x00000018ff3d7819ULL, 0x000fce000001143dULL,
0x0000003f00537306ULL, 0x000eb00000005400ULL, 0x0000000a003c7306ULL, 0x000fe20000209400ULL,
0x000000560b00720bULL, 0x002fe20003f7d000ULL, 0x000001003e0b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff0b7819ULL, 0x000fe2000001140bULL, 0x0000000a007d7306ULL, 0x000e620000205400ULL,
0x000000535400720bULL, 0x004fce0003f5d000ULL, 0x0000000c006a7306ULL, 0x000ff00000209400ULL,
0x0000000c00757306ULL, 0x000ea20000205400ULL, 0x0000007d3c00720bULL, 0x002fe40003f9d000ULL,
0x0000006d003c7245ULL, 0x000fc8000020d400ULL, 0x000000013c3c3812ULL, 0x000fe200078efcffULL,
0x0000003d00557306ULL, 0x000ff00000209400ULL, 0x0000003d00547306ULL, 0x0002e20000205400ULL,
0x000000756a00720bULL, 0x004fe20003fdd000ULL, 0x000001003f6a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000000b00567306ULL, 0x000fe20000209400ULL,
0x0000003d003d7245ULL, 0x002fce000020d400ULL, 0x0000000b006d7306ULL, 0x000e620000205400ULL,
0x000000545500720bULL, 0x008fe40003f7d000ULL, 0x0000000c00557245ULL, 0x000fe4000020d400ULL,
0x0000000a000c7245ULL, 0x000fe4000020d400ULL, 0x0000000155556812ULL, 0x000fe200078efcffULL,
0x0000006a006e7306ULL, 0x000fe20000209400ULL, 0x000000010c0c4812ULL, 0x000fe400078efcffULL,
0x0000003c553c723eULL, 0x000fc600000010ffULL, 0x000000013d3d3812ULL, 0x000fe400078efcffULL,
0x0000006d5600720bULL, 0x002fe20003fdd000ULL, 0x0000002c00627306ULL, 0x000fe20000009400ULL,
0x0000003d0c3d723eULL, 0x000fe400000010ffULL, 0x00000018ff0c7819ULL, 0x000fca000001143eULL,
0x0000006a006d7306ULL, 0x0002a20000205400ULL, 0x0000003c4440723cULL, 0x000bee0000041840ULL,
0x0000002c00637306ULL, 0x000ee20000005400ULL, 0x0000006a006a7245ULL, 0x002fe4000020d400ULL,
0x0000000b003c7245ULL, 0x020fc8000020d400ULL, 0x000000013c3c6812ULL, 0x000fe200078efcffULL,
0x0000003f00677306ULL, 0x000e62000000d400ULL, 0x0000006d6e00720bULL, 0x004fce0003f7d000ULL,
0x0000003e00577306ULL, 0x000eac000000d400ULL, 0x000000016a6a3812ULL, 0x000fe400078efcffULL,
0x000000636200720bULL, 0x008fe20003f7d000ULL, 0x000100003e627824ULL, 0x000fe200078e00ffULL,
0x0000000167672812ULL, 0x002fe200078efcffULL, 0x0000002d00647306ULL, 0x000fe20000009400ULL,
0x000100003f637824ULL, 0x000fc400078e00ffULL, 0x000000676a3d723eULL, 0x000fe400000010ffULL,
0x0000000157570812ULL, 0x004fe400078efcffULL, 0x00000018ff627819ULL, 0x000fe20000011462ULL,
0x0000002d00667306ULL, 0x000e620000005400ULL, 0x000000573c3c723eULL, 0x000fe400000010ffULL,
0x00000018ff637819ULL, 0x000fca0000011463ULL, 0x0000000c00677306ULL, 0x000fe20000209400ULL,
0x0000003c4428723cULL, 0x000bee0000041828ULL, 0x0000000c006a7306ULL, 0x000ea20000205400ULL,
0x00000018ff3c7819ULL, 0x020fe2000001143fULL, 0x000001002c3f7824ULL, 0x000fe200078e00ffULL,
0x000000666400720bULL, 0x002fc80003f5d000ULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x00000062003e7306ULL, 0x000ff00000209400ULL, 0x00000062006d7306ULL, 0x000e620000205400ULL,
0x0000006a6700720bULL, 0x004fce0003fdd000ULL, 0x0000003c003d7306ULL, 0x000ff00000209400ULL,
0x0000003c006e7306ULL, 0x000ea20000205400ULL, 0x0000006d3e00720bULL, 0x002fe20003f9d000ULL,
0x000001002d3e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000006300647306ULL, 0x000ff00000209400ULL, 0x0000006300677306ULL, 0x000e620000205400ULL,
0x0000006e3d00720bULL, 0x004fc40003f1d000ULL, 0x00000062003d7245ULL, 0x000fe4000020d400ULL,
0x0000003f006e7245ULL, 0x000fe4000020d400ULL, 0x000000013d3d4812ULL, 0x000fe200078efcffULL,
0x0000003f00667306ULL, 0x000ff00000209400ULL, 0x0000003f006d7306ULL, 0x0004e20000205400ULL,
0x000000676400720bULL, 0x002fc40003f9d000ULL, 0x0000000c00647245ULL, 0x000fc8000020d400ULL,
0x0000000164646812ULL, 0x000fe200078efcffULL, 0x0000003e006a7306ULL, 0x000fe20000209400ULL,
0x00000018ff3f7819ULL, 0x004fce000001142cULL, 0x0000003e00677306ULL, 0x000e620000205400ULL,
0x0000006d6600720bULL, 0x008fe40003fdd000ULL, 0x0000006300667245ULL, 0x000fe4000020d400ULL,
0x0000003c006d7245ULL, 0x000fe4000020d400ULL, 0x0000000166664812ULL, 0x000fe200078efcffULL,
0x0000002c00617306ULL, 0x0004e2000000d400ULL, 0x000000016d6d0812ULL, 0x000fe400078efcffULL,
0x0000003d643c723eULL, 0x000fc400000010ffULL, 0x000000666d3d723eULL, 0x000fe400000010ffULL,
0x000000016e6e6812ULL, 0x000fe200078efcffULL, 0x0000002d00607306ULL, 0x000ee2000000d400ULL,
0x000000676a00720bULL, 0x002fe20003f9d000ULL, 0x000100002c2c7824ULL, 0x004fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011434ULL, 0x0000003c4424723cULL, 0x000b620000041824ULL,
0x00000018ff647819ULL, 0x000fe40000011435ULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0000002f005d7306ULL, 0x000fe20000009400ULL, 0x0000000161613812ULL, 0x008fc400078efcffULL,
0x0000003e003d7245ULL, 0x020fe4000020d400ULL, 0x000000616e3c723eULL, 0x000fe400000010ffULL,
0x000000013d3d4812ULL, 0x000fe200078efcffULL, 0x0000002f005e7306ULL, 0x000e620000005400ULL,
0x0000000160602812ULL, 0x000fc800078efcffULL, 0x000000603d3d723eULL, 0x000fc600000010ffULL,
0x0000002c00607306ULL, 0x000fe80000209400ULL, 0x0000003c4420723cULL, 0x000b680000041820ULL,
0x0000002c006d7306ULL, 0x0004e20000205400ULL, 0x0000005e5d00720bULL, 0x002fe40003f5d000ULL,
0x000100002d3d7824ULL, 0x020fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001142dULL,
0x000001002e2d7824ULL, 0x000fc600078e00ffULL, 0x0000002e005b7306ULL, 0x000fe20000009400ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002c002c7245ULL, 0x004fc6000020d400ULL, 0x0000002e005c7306ULL, 0x000e620000005400ULL,
0x0000006d6000720bULL, 0x008fe20003f9d000ULL, 0x000001002f6d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fc80000011436ULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000003f003e7306ULL, 0x000fec0000209400ULL, 0x000000012c2c4812ULL, 0x000fe400078efcffULL,
0x0000003f00617306ULL, 0x0004e20000205400ULL, 0x0000005c5b00720bULL, 0x002fce0003f7d000ULL,
0x0000003d005e7306ULL, 0x000fe20000209400ULL, 0x0000003f003f7245ULL, 0x004fce000020d400ULL,
0x0000003d00757306ULL, 0x0002a20000205400ULL, 0x000000613e00720bULL, 0x008fe40003fdd000ULL,
0x0000003c003e7245ULL, 0x000fe4000020d400ULL, 0x00000018ff617819ULL, 0x000fc60000011437ULL,
0x0000003c005b7306ULL, 0x000fe20000209400ULL, 0x0000003d003d7245ULL, 0x002fca000020d400ULL,
0x000000013f3f6812ULL, 0x000fe400078efcffULL, 0x0000003c005c7306ULL, 0x0002e20000205400ULL,
0x000000755e00720bULL, 0x004fce0003f9d000ULL, 0x0000002d006e7306ULL, 0x000fe20000209400ULL,
0x0000002c3f3c723eULL, 0x002fe200000010ffULL, 0x00000010093f7824ULL, 0x000fe200078e0258ULL,
0x00000018ff587819ULL, 0x000fc6000001142eULL, 0x000000013d3d4812ULL, 0x000fe400078efcffULL,
0x0000002d007d7306ULL, 0x0002a20000205400ULL, 0x0000005c5b00720bULL, 0x008fce0003f1d000ULL,
0x0000006d005d7306ULL, 0x000fe20000209400ULL, 0x0000002d002d7245ULL, 0x002fca000020d400ULL,
0x000000013e3e0812ULL, 0x000fe400078efcffULL, 0x0000006d00747306ULL, 0x000e620000205400ULL,
0x0000007d6e00720bULL, 0x004fe40003fdd000ULL, 0x0000003d3e3d723eULL, 0x000fe400000010ffULL,
0x0000006d003e7245ULL, 0x000fe4000020d400ULL, 0x00000018ff6e7819ULL, 0x000fe2000001142fULL,
0x0000002e005a7306ULL, 0x000ea4000000d400ULL, 0x0000003c441c723cULL, 0x000b68000004181cULL,
0x000000012d2d6812ULL, 0x000fc400078efcffULL, 0x0000002f00597306ULL, 0x000ee2000000d400ULL,
0x000000745d00720bULL, 0x002fe20003f9d000ULL, 0x0000010034747824ULL, 0x000fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x00000036004e7306ULL, 0x000fe20000009400ULL,
0x000000015a5a3812ULL, 0x004fc800078efcffULL, 0x0000005a2d2c723eULL, 0x000fe400000010ffULL,
0x000000013e3e4812ULL, 0x000fe200078efcffULL, 0x0000007400757306ULL, 0x000fe20000205400ULL,
0x0000000159592812ULL, 0x008fc800078efcffULL, 0x000000593e2d723eULL, 0x000fe400000010ffULL,
0x009000003f3c783bULL, 0x020e620000000200ULL, 0x0000003600137306ULL, 0x000ea80000005400ULL,
0x0000002c4418723cULL, 0x000b680000041818ULL, 0x00000074002c7306ULL, 0x020fe60000209400ULL,
0x00000018ff2d7819ULL, 0x000fca0000011438ULL, 0x0000003800527306ULL, 0x000fe20000009400ULL,
0x000000134e00720bULL, 0x004fe20003f7d000ULL, 0x00010000354e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000003800517306ULL, 0x000eb00000005400ULL,
0x0000003400657306ULL, 0x000fe20000009400ULL, 0x000000073c3cd231ULL, 0x002fce00003400ffULL,
0x00000034005f7306ULL, 0x000e620000005400ULL, 0x000000073e3ed231ULL, 0x000fe200003400ffULL,
0x000000515200720bULL, 0x004fe20003f1d000ULL, 0x000000083d3dd231ULL, 0x080fe200003400ffULL,
0x0000010035517824ULL, 0x000fe200078e00ffULL, 0x000000083f3fd231ULL, 0x000fe200003400ffULL,
0x000000752c00720bULL, 0x000fe40003fbd000ULL, 0x00000034004b7306ULL, 0x0004e2000000d400ULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000007400527245ULL, 0x000fc4000020d400ULL,
0x00000018ff2c7819ULL, 0x000fc60000011439ULL, 0x00000037004c7306ULL, 0x000fe20000009400ULL,
0x0001000034347824ULL, 0x004fe200078e00ffULL, 0x0000005f6500720bULL, 0x002fe40003f9d000ULL,
0x0000000152525812ULL, 0x000fe400078efcffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000037004d7306ULL, 0x000e6e0000005400ULL, 0x000000014b4b4812ULL, 0x008fe200078efcffULL,
0x0000006300677306ULL, 0x000ff00000209400ULL, 0x0000006300667306ULL, 0x0004e20000205400ULL,
0x0000004d4c00720bULL, 0x002fc40003fdd000ULL, 0x00000034004d7245ULL, 0x000fca000020d400ULL,
0x0000003400767306ULL, 0x000fe20000209400ULL, 0x0000006300637245ULL, 0x004fce000020d400ULL,
0x0000003400137306ULL, 0x000e620000205400ULL, 0x000000666700720bULL, 0x008fce0003fbd000ULL,
0x00000035004f7306ULL, 0x000fec0000009400ULL, 0x0000000163635812ULL, 0x000fe400078efcffULL,
0x0000003500507306ULL, 0x000ea20000005400ULL, 0x000000137600720bULL, 0x002fe40003f9d000ULL,
0x0000005800767245ULL, 0x000fc4000020d400ULL, 0x00000018ff137819ULL, 0x000fc6000001143aULL,
0x0000003500127306ULL, 0x000e6c000000d400ULL, 0x000000014d4d4812ULL, 0x000fe400078efcffULL,
0x00000051004c7306ULL, 0x000fe20000209400ULL, 0x000000504f00720bULL, 0x004fce0003f5d000ULL,
0x0000005100357306ULL, 0x0004ec0000205400ULL, 0x0000000112122812ULL, 0x002fe400078efcffULL,
0x0000003900537306ULL, 0x000fe20000009400ULL, 0x0000005100517245ULL, 0x004fce000020d400ULL,
0x0000003900547306ULL, 0x000e620000005400ULL, 0x000000354c00720bULL, 0x008fce0003fbd000ULL,
0x0000004e00757306ULL, 0x000fec0000209400ULL, 0x0000000151515812ULL, 0x000fe400078efcffULL,
0x0000004e00747306ULL, 0x0004e20000205400ULL, 0x000000545300720bULL, 0x002fe20003f9d000ULL,
0x0000010036537824ULL, 0x000fc400078e00ffULL, 0x0000010037547824ULL, 0x000fc600078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x00000064006a7306ULL, 0x000fe20000209400ULL,
0x0000004e004e7245ULL, 0x004fe4000020d400ULL, 0x00000018ff547819ULL, 0x000fca0000011454ULL,
0x00000064005c7306ULL, 0x0002a20000205400ULL, 0x000000747500720bULL, 0x008fce0003f5d000ULL,
0x0000003a00557306ULL, 0x000fe20000009400ULL, 0x0000006400647245ULL, 0x002fca000020d400ULL,
0x000000014e4e2812ULL, 0x000fe400078efcffULL, 0x0000003a00567306ULL, 0x000e620000005400ULL,
0x0000005c6a00720bULL, 0x004fce0003fbd000ULL, 0x0000005300677306ULL, 0x000fec0000209400ULL,
0x0000000164645812ULL, 0x000fe400078efcffULL, 0x00000053005c7306ULL, 0x0004e20000205400ULL,
0x000000565500720bULL, 0x002fe20003f5d000ULL, 0x0001000036567824ULL, 0x000fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x0000003600117306ULL, 0x000e62000000d400ULL,
0x0000005300537245ULL, 0x004fce000020d400ULL, 0x00000060005b7306ULL, 0x000fe20000209400ULL,
0x0000005c6700720bULL, 0x008fce0003fbd000ULL, 0x00000060005d7306ULL, 0x0004e20000205400ULL,
0x0000000111113812ULL, 0x002fca00078efcffULL, 0x0000000153535812ULL, 0x000fe400078efcffULL,
0x0000005400347306ULL, 0x000fe20000209400ULL, 0x0000006000607245ULL, 0x004fce000020d400ULL,
0x0000005400757306ULL, 0x0002a20000205400ULL, 0x0000005d5b00720bULL, 0x008fce0003f7d000ULL,
0x00000037000e7306ULL, 0x0006a2000000d400ULL, 0x0000005400547245ULL, 0x002fca000020d400ULL,
0x0000000160603812ULL, 0x000fe400078efcffULL, 0x0000005600557306ULL, 0x000fe20000209400ULL,
0x0001000037377824ULL, 0x008fe200078e00ffULL, 0x000000753400720bULL, 0x004fe40003fbd000ULL,
0x00000018ff347819ULL, 0x000fe4000001143bULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x00000056005c7306ULL, 0x000e620000205400ULL, 0x000000010e0e6812ULL, 0x000fcc00078efcffULL,
0x0000000154545812ULL, 0x000fe200078efcffULL, 0x00000037005b7306ULL, 0x000ff00000209400ULL,
0x0000003700747306ULL, 0x000ea20000205400ULL, 0x0000005c5500720bULL, 0x002fe20003fdd000ULL,
0x000100002e5c7824ULL, 0x000fc400078e00ffULL, 0x000100002f557824ULL, 0x000fe200078e00ffULL,
0x00000056002f7245ULL, 0x000fe4000020d400ULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x00000061005e7306ULL, 0x000fe20000209400ULL, 0x00000018ff557819ULL, 0x000fca0000011455ULL,
0x000000012f2f6812ULL, 0x000fe400078efcffULL, 0x0000006100097306ULL, 0x0002e20000205400ULL,
0x000000745b00720bULL, 0x004fe20003fbd000ULL, 0x00000100385b7824ULL, 0x000fe200078e00ffULL,
0x0000002f6060723eULL, 0x000fe400000010ffULL, 0x0000002c002f7245ULL, 0x000fe4000020d400ULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x0000005c006a7306ULL, 0x000fe20000209400ULL,
0x0000006100617245ULL, 0x002fce000020d400ULL, 0x0000005c00757306ULL, 0x000e620000205400ULL,
0x000000095e00720bULL, 0x008fe40003fdd000ULL, 0x0000003700097245ULL, 0x000fc8000020d400ULL,
0x0000000109095812ULL, 0x000fe200078efcffULL, 0x0000005800597306ULL, 0x000fec0000209400ULL,
0x0000000161616812ULL, 0x000fe400078efcffULL, 0x00000058006d7306ULL, 0x000ea20000205400ULL,
0x000000756a00720bULL, 0x002fc40003fbd000ULL, 0x000000096161723eULL, 0x000fca00000010ffULL,
0x0000005500567306ULL, 0x000fe40000209400ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x0000005500677306ULL, 0x000e620000205400ULL, 0x0000006d5900720bULL, 0x004fe20003f7d000ULL,
0x0000010039597824ULL, 0x000fe200078e00ffULL, 0x0000005c006d7245ULL, 0x000fc8000020d400ULL,
0x000000016d6d5812ULL, 0x000fe200078efcffULL, 0x0000006e005a7306ULL, 0x000fe20000209400ULL,
0x00000018ff597819ULL, 0x000fca0000011459ULL, 0x0000000176763812ULL, 0x000fe400078efcffULL,
0x0000006e005f7306ULL, 0x0004e20000205400ULL, 0x000000675600720bULL, 0x002fe20003fbd000ULL,
0x0001000039567824ULL, 0x000fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000005b005d7306ULL, 0x000fe20000209400ULL, 0x0000006e006e7245ULL, 0x004fce000020d400ULL,
0x0000005b00747306ULL, 0x000fe20000205400ULL, 0x0000005f5a00720bULL, 0x008fe20003fdd000ULL,
0x00010000385a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000003b00577306ULL, 0x000fec0000009400ULL, 0x000000016e6e6812ULL, 0x000fe400078efcffULL,
0x0000003b00627306ULL, 0x000e700000005400ULL, 0x00000039000a7306ULL, 0x0005f0000000d400ULL,
0x0000003800057306ULL, 0x000ee2000000d400ULL, 0x0000005500397245ULL, 0x004fe2000020d400ULL,
0x000001003a557824ULL, 0x000fe200078e00ffULL, 0x000000625700720bULL, 0x002fe20003f7d000ULL,
0x000100003b627824ULL, 0x000fe200078e00ffULL, 0x0000000139395812ULL, 0x000fc400078efcffULL,
0x000000745d00720bULL, 0x000fe20003fbd000ULL, 0x0000005900377306ULL, 0x000fe20000209400ULL,
0x0000005b00577245ULL, 0x000fe4000020d400ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x000000396e39723eULL, 0x000fe400000010ffULL, 0x00000018ff627819ULL, 0x000fe20000011462ULL,
0x0000005900387306ULL, 0x000e620000205400ULL, 0x0000000105050812ULL, 0x008fc400078efcffULL,
0x000000010a0a4812ULL, 0x000fe400078efcffULL, 0x0000000157575812ULL, 0x000fc600078efcffULL,
0x0000002c00507306ULL, 0x000ff00000209400ULL, 0x0000002c00667306ULL, 0x0004e20000205400ULL,
0x000000383700720bULL, 0x002fe20003fbd000ULL, 0x000100003a377824ULL, 0x000fe200078e00ffULL,
0x0000006d7638723eULL, 0x000fc800000010ffULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000002d004f7306ULL, 0x000fe20000209400ULL, 0x00000005572c723eULL, 0x004fe200000010ffULL,
0x000000384414723cULL, 0x000b620000041814ULL, 0x000000044a057810ULL, 0x000fc80007ffe0ffULL,
0x0000f6a805057811ULL, 0x000fe200078e18ffULL, 0x0000002d00657306ULL, 0x000e620000205400ULL,
0x000000665000720bULL, 0x008fe40003f1d000ULL, 0x0000005900507245ULL, 0x000fe4000020d400ULL,
0x000000115344723eULL, 0x020fe400000010ffULL, 0x0000000150505812ULL, 0x000fe200078efcffULL,
0x0000005a005e7306ULL, 0x000fe20000209400ULL, 0x0000002d00117245ULL, 0x000fc4000020d400ULL,
0x0000000e5445723eULL, 0x000fe400000010ffULL, 0x00000055000e7245ULL, 0x000fe4000020d400ULL,
0x000000012f2f0812ULL, 0x000fe200078efcffULL, 0x0000005a005f7306ULL, 0x0004e20000205400ULL,
0x000000654f00720bULL, 0x002fe20003fdd000ULL, 0x000001003b4f7824ULL, 0x000fe200078e00ffULL,
0x0000000a502d723eULL, 0x000fe200000010ffULL, 0x000000443c28723cULL, 0x000b620000041828ULL,
0x0000004d6338723eULL, 0x000fc400000010ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000001300357306ULL, 0x000fe20000209400ULL, 0x0000005a005a7245ULL, 0x004fe4000020d400ULL,
0x0000004e6439723eULL, 0x000fe200000010ffULL, 0x0000002c3c20723cULL, 0x000b640000041820ULL,
0x0000000111116812ULL, 0x000fe400078efcffULL, 0x00000013004c7306ULL, 0x000e620000205400ULL,
0x0000005f5e00720bULL, 0x008fce0003fbd000ULL, 0x0000005600677306ULL, 0x000fec0000209400ULL,
0x000000015a5a5812ULL, 0x000fe400078efcffULL, 0x00000056006a7306ULL, 0x0004e20000205400ULL,
0x0000004c3500720bULL, 0x002fe40003fbd000ULL, 0x0000005a115a723eULL, 0x000fca00000010ffULL,
0x00000055005c7306ULL, 0x000fe20000209400ULL, 0x0000005600567245ULL, 0x004fce000020d400ULL,
0x00000055005d7306ULL, 0x000e620000205400ULL, 0x0000006a6700720bULL, 0x008fce0003f9d000ULL,
0x0000004f00587306ULL, 0x000fec0000209400ULL, 0x0000000156564812ULL, 0x000fe400078efcffULL,
0x0000004f005b7306ULL, 0x0004e20000205400ULL, 0x0000005d5c00720bULL, 0x002fce0003fdd000ULL,
0x0000003b000c7306ULL, 0x0002e2000000d400ULL, 0x0000004f004f7245ULL, 0x004fca000020d400ULL,
0x000000010e0e6812ULL, 0x000fe400078efcffULL, 0x0000003a000b7306ULL, 0x0004a2000000d400ULL,
0x00000012513b723eULL, 0x002fe400000010ffULL, 0x0000005b5800720bULL, 0x008fe40003f1d000ULL,
0x000000562f5b723eULL, 0x000fc600000010ffULL, 0x0000003400367306ULL, 0x000fe20000209400ULL,
0x000000010c0c3812ULL, 0x000fe400078efcffULL, 0x0000004b523a723eULL, 0x004fe200000010ffULL,
0x0000005a3c1c723cULL, 0x040b68000004181cULL, 0x00000034002e7306ULL, 0x0002a20000205400ULL,
0x000000010b0b2812ULL, 0x000fe400078efcffULL, 0x000000014f4f0812ULL, 0x000fe200078efcffULL,
0x0000003a3c30723cULL, 0x000b620000041830ULL, 0x0000000b0e0a723eULL, 0x000fc400000010ffULL,
0x0000000c4f0b723eULL, 0x000fe200000010ffULL, 0x0000003700597306ULL, 0x000fe20000209400ULL,
0x00000013000c7245ULL, 0x000fe4000020d400ULL, 0x0000003400347245ULL, 0x002fe2000020d400ULL,
0x000000383c38723cULL, 0x000b620000041840ULL, 0x0000006200137245ULL, 0x000fe4000020d400ULL,
0x000000010c0c5812ULL, 0x000fe200078efcffULL, 0x0000003700127306ULL, 0x0002e20000205400ULL,
0x0000002e3600720bULL, 0x004fc60003f9d000ULL, 0x0000000a3c18723cULL, 0x000b680000041818ULL,
0x0000006200467306ULL, 0x000fe20000209400ULL, 0x0000003700377245ULL, 0x002fca000020d400ULL,
0x0000000134344812ULL, 0x000fe400078efcffULL, 0x0000006200357306ULL, 0x000e620000205400ULL,
0x000000125900720bULL, 0x008fda0003fdd000ULL, 0x0000000137376812ULL, 0x000fe400078efcffULL,
0x000000354600720bULL, 0x002fe40003f5d000ULL, 0x000000370c12723eULL, 0x000fd600000010ffULL,
0x0000000113132812ULL, 0x000fc800078efcffULL, 0x000000133413723eULL, 0x000fce00000010ffULL,
0x000000123c14723cULL, 0x000b620000041814ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x00000000050a7f8cULL, 0x0202a2000c80043fULL, 0x0000000100007810ULL, 0x000fe40007ffe0ffULL,
0x0000f6a06c0c7811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000cff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff097224ULL, 0x004fe200078e000bULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff276000007947ULL, 0x000fea000383ffffULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x018000000d007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000f1f000047802ULL, 0x000fc40000000f00ULL,
0x00008a9000007944ULL, 0x01efea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000d00007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc8000000000dULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000047919ULL, 0x000e680000000000ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x00000002ff067819ULL, 0x002fe40000011604ULL, 0x0000000807047811ULL, 0x004fe200078ff0ffULL,
0x0000000003057220ULL, 0x008fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000003000307220ULL, 0x042fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003800387220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001900197220ULL, 0x040fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000001500157220ULL, 0x000fe20000410000ULL, 0x0000003204327220ULL, 0x044fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000003a043a7220ULL, 0x040fe20000410000ULL,
0x0000003b043b7220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x0000001c1d1c723eULL, 0x000fc400000010ffULL, 0x000000181918723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002a2b2a723eULL, 0x000fe400000010ffULL,
0x000000222322723eULL, 0x000fe400000010ffULL, 0x0000001a1b1a723eULL, 0x000fc400000010ffULL,
0x00000016170d723eULL, 0x000fc800000010ffULL, 0x000076321a197816ULL, 0x000fe4000000000dULL,
0x00000002ff057819ULL, 0x002fe40000011600ULL, 0x0000000200027812ULL, 0x040fe400078ec0ffULL,
0x0000000800077811ULL, 0x008fe200078ff0ffULL, 0x0000000805097824ULL, 0x040fe200078e00ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fe200078ff8ffULL, 0x00000008070e7824ULL, 0x004fe200078e00ffULL,
0x0000000204027810ULL, 0x040fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x0000000404067810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL,
0x0000100070037824ULL, 0x000fe200078e00ffULL, 0xfffffff809087812ULL, 0x000fe400078ee202ULL,
0xfffffff807027812ULL, 0x000fe200078ee204ULL, 0x000008004a057824ULL, 0x000fe200078e0203ULL,
0x0000000604077810ULL, 0x000fe20007ffe0ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff8090a7812ULL, 0x000fe200078ee206ULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x0000001008087824ULL, 0x100fe200078e0205ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x000000100e0e7824ULL, 0x100fe200078e0205ULL,
0x000000303102723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0205ULL,
0x000000383904723eULL, 0x000fe200000010ffULL, 0x0000000106067824ULL, 0x000fc400078e0207ULL,
0x000000100c0c7824ULL, 0x000fe200078e0205ULL, 0x0000541002107816ULL, 0x040fe20000000004ULL,
0x0000000107087824ULL, 0x040fe200078e0208ULL, 0x0000763202117816ULL, 0x000fe20000000004ULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x000000282902723eULL, 0x000fe200000010ffULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x000000242504723eULL, 0x000fe200000010ffULL,
0x0000001006007388ULL, 0x0003e20000000a00ULL, 0x0000000107077824ULL, 0x000fe200078e020cULL,
0x000000202105723eULL, 0x000fc400000010ffULL, 0x00000014150c723eULL, 0x000fe400000010ffULL,
0x000000262715723eULL, 0x000fe400000010ffULL, 0x0000541018127816ULL, 0x140fe4000000000cULL,
0x0000763218137816ULL, 0x000fe4000000000cULL, 0x0000541002107816ULL, 0x142fe40000000004ULL,
0x0000763202117816ULL, 0x000fc40000000004ULL, 0x000000323302723eULL, 0x000fe400000010ffULL,
0x0000003a3b04723eULL, 0x000fe200000010ffULL, 0x0000001008007388ULL, 0x0003e20000000a00ULL,
0x000054102a147816ULL, 0x140fe40000000015ULL, 0x000076322a157816ULL, 0x000fe40000000015ULL,
0x000054101a187816ULL, 0x000fe4000000000dULL, 0x0000541005107816ULL, 0x002fc4000000001cULL,
0x0000763205117816ULL, 0x000fe4000000001cULL, 0x000000ff00057306ULL, 0x000fe60000209400ULL,
0x000000100a007388ULL, 0x0003e80000000a00ULL, 0x0000001207007388ULL, 0x0005e20000000a00ULL,
0x0000001e1f11723eULL, 0x002fc400000010ffULL, 0x0000541002127816ULL, 0x144fe40000000004ULL,
0x0000763202137816ULL, 0x000fe20000000004ULL, 0x0000000179027824ULL, 0x000fe200078e0200ULL,
0x0000763222097816ULL, 0x000fe20000000011ULL, 0x000000ff00047306ULL, 0x000e640000205400ULL,
0x000000120e007388ULL, 0x000fe20000000a00ULL, 0x0000001002067824ULL, 0x000fe200078e0203ULL,
0x000000ff00027245ULL, 0x000fe4000020d400ULL, 0x0004001408007388ULL, 0x0005e20000000a00ULL,
0x000000040500720bULL, 0x002fc40003f1d000ULL, 0x0000541022087816ULL, 0x004fca0000000011ULL,
0x000400080a007388ULL, 0x000fe80000000a00ULL, 0x0004001807007388ULL, 0x000fe40000000a00ULL,
0x0000000102020812ULL, 0x000fe400078efcffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000060c7984ULL, 0x000e620000000c00ULL, 0x000000020204723eULL, 0x000fc400000010ffULL,
0x000000ff4a00720cULL, 0x000fe20003f05270ULL, 0x0004000006087984ULL, 0x000ea80000000c00ULL,
0x0008000006107984ULL, 0x000ee80000000c00ULL, 0x000c000006147984ULL, 0x000ee20000000c00ULL,
0x3f803f80040f7831ULL, 0x002fc4000020000fULL, 0x3f803f80040e7831ULL, 0x040fe4000020000eULL,
0x3f803f80040d7831ULL, 0x040fe4000020000dULL, 0x3f803f80040c7831ULL, 0x040fe4000020000cULL,
0x3f803f80040b7831ULL, 0x044fe4000020000bULL, 0x3f803f80040a7831ULL, 0x040fe4000020000aULL,
0x3f803f8004097831ULL, 0x000fc40000200009ULL, 0x3f803f8004087831ULL, 0x000fe40000200008ULL,
0x3f803f800f0f7831ULL, 0x008fe40000200013ULL, 0x3f803f800e0e7831ULL, 0x000fe40000200012ULL,
0x3f803f800d0d7831ULL, 0x000fe40000200011ULL, 0x3f803f800c0c7831ULL, 0x000fe40000200010ULL,
0x3f803f800b0b7831ULL, 0x000fc40000200017ULL, 0x3f803f800a0a7831ULL, 0x000fe20000200016ULL,
0x0000000c06007388ULL, 0x000fe20000000c00ULL, 0x3f803f8009097831ULL, 0x000fe40000200015ULL,
0x3f803f8008087831ULL, 0x000fca0000200014ULL, 0x0004000806007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff067819ULL, 0x000fc80000011600ULL, 0x000000730600720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000087b06ULL, 0x000e620000209000ULL,
0x000000017b027824ULL, 0x000fe200078e0206ULL, 0x00005a00ff0f7a12ULL, 0x000fcc00078e33ffULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08047810ULL, 0x002fcc0007ffe0ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000ffff077224ULL, 0x004fc800078e0a05ULL, 0x00005a0007077a24ULL, 0x000fc800078e02ffULL,
0x00000007050d7227ULL, 0x000fc800078e0004ULL, 0x0000000106047824ULL, 0x000fe400078e0200ULL,
0x000000020d077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fca00078e0202ULL, 0x00005a0005007a0cULL, 0x000fda0003f06070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x0000000704057812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x0ffffff805047812ULL, 0x000fca00078ef800ULL,
0x0000001004067824ULL, 0x000fe400078e0203ULL, 0x0000000107071810ULL, 0x000fc60007ffe0ffULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x000000070f077207ULL, 0x000fca0004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0272ULL,
0x00005a0005027a24ULL, 0x000fc800078e0202ULL, 0x00005a0007027a24ULL, 0x000fe200078e0202ULL,
0x0000000700077812ULL, 0x000fc800078ec0ffULL, 0x0000000277057210ULL, 0x000fe20007f3e0ffULL,
0x0000000870077824ULL, 0x000fe200078e0207ULL, 0x0000002000027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x040fe400078240ffULL,
0x00000003ff067819ULL, 0x002fe40000011602ULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x000000730600720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d08ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000017b047824ULL, 0x102fe200078e0206ULL, 0x00000040000c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000102067824ULL, 0x000fe400078e0206ULL, 0x000000040d077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x00005a0005057a24ULL, 0x000fca00078e0204ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0000000706057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805067812ULL, 0x000fca00078ef802ULL,
0x0000001006067824ULL, 0x000fe400078e0203ULL, 0x0000000107072810ULL, 0x000fc60007ffe0ffULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x000000070f077207ULL, 0x000fca0004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0272ULL,
0x00005a0005047a24ULL, 0x000fc800078e0204ULL, 0x00005a0007047a24ULL, 0x000fe200078e0204ULL,
0x0000000702077812ULL, 0x000fe400078ec0ffULL, 0x00000003ff027819ULL, 0x000fe4000001160cULL,
0x0000000477057210ULL, 0x000fe20007f3e0ffULL, 0x0000000870077824ULL, 0x000fc800078e0207ULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440eULL, 0x000000730200720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000017b047824ULL, 0x102fe200078e0202ULL,
0x0000006000007810ULL, 0x000fe20007ffe0ffULL, 0x000000010c027824ULL, 0x000fe400078e0202ULL,
0x000000040d067227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a06ULL,
0x00005a0005057a24ULL, 0x000fca00078e0204ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0000000702057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805027812ULL, 0x000fca00078ef80cULL, 0x0000001002027824ULL, 0x000fe400078e0203ULL,
0x0000000106062810ULL, 0x000fc60007ffe0ffULL, 0x0000000002087984ULL, 0x0002a20000000c00ULL,
0x000000060f057207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x0000590005057a24ULL, 0x000fe200078e0272ULL, 0x00000003ff027819ULL, 0x002fe20000011600ULL,
0x00005a0007047a24ULL, 0x000fe200078e0204ULL, 0x000000070c077812ULL, 0x000fc600078ec0ffULL,
0x00005a0005047a24ULL, 0x000fe400078e0204ULL, 0x0000000870077824ULL, 0x000fe400078e0207ULL,
0x000000017b7b7824ULL, 0x000fe200078e0202ULL, 0x0000000477057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f4406ULL, 0x000000730200720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d08ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000007b0d067227ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x002fe400078e0a06ULL, 0x0000000100027824ULL, 0x000fe400078e0202ULL,
0x00005a0004047a24ULL, 0x000fc600078e027bULL, 0x0000000702057812ULL, 0x000fe400078ec0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f26070ULL, 0xfffffff805027812ULL, 0x000fe400078ef800ULL,
0x0000000700057812ULL, 0x000fca00078ec0ffULL, 0x0000000870057824ULL, 0x000fc800078e0205ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe20003f46070ULL, 0x0000001002047824ULL, 0x000fca00078e0203ULL,
0x0000000004087984ULL, 0x000e6e0000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x000000060f037207ULL, 0x000fca0004000000ULL, 0x000000ffff067224ULL, 0x000fe400078e0a03ULL,
0x0000590003027a24ULL, 0x000fe400078e0272ULL, 0x00005a00067b7a24ULL, 0x000fc800078e027bULL,
0x00005a0002027a24ULL, 0x000fca00078e027bULL, 0x0000000277777210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005e0077027a11ULL, 0x000fc800078040ffULL,
0x00005f0077037a11ULL, 0x000fca00000f4406ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff057819ULL, 0x000fe20000011602ULL, 0xffffffffff067424ULL, 0x000fc600078e00ffULL,
0x000000710500720cULL, 0x000fda0003f06070ULL, 0x00000002080e8824ULL, 0x000fc800078e00ffULL,
0x00006a000e0e8a24ULL, 0x000fc800078e0205ULL, 0x000066000e0e8625ULL, 0x000fe200078e0043ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006e00ff0c7624ULL, 0x000fe200078e00ffULL,
0x000000080e068981ULL, 0x0002a2000c1e1900ULL, 0x00006f00ff0d7624ULL, 0x000fc600078e00ffULL,
0x00f60000ff0a7f8cULL, 0x000ee8000c80043fULL, 0x000000080c0c7981ULL, 0x000322000c1e9900ULL,
0x000001ff1000780cULL, 0x000fe20003f04070ULL, 0x00005800ff107624ULL, 0x000fe400078e00ffULL,
0x0000008072727824ULL, 0x000fe400078e00ffULL, 0x00000040027a7824ULL, 0x000fe200078e00ffULL,
0x0000001f10107810ULL, 0x000fe20007ffe0ffULL, 0x0000008076767824ULL, 0x000fc600078e00ffULL,
0x00000040721f7812ULL, 0x000fe400078ef87aULL, 0x00000005ff0e7819ULL, 0x002fe20000011610ULL,
0x0000007606297224ULL, 0x004fe200078e02ffULL, 0x0000062000000947ULL, 0x000fea0003800000ULL,
0x00000002ff247819ULL, 0x008fe40000011648ULL, 0x0000640029277a11ULL, 0x000fe400078038ffULL,
0x00000008241c7810ULL, 0x040fe20007ffe0ffULL, 0x000000011f107824ULL, 0x000fe200078e0224ULL,
0x0000001824287810ULL, 0x000fc40007ffe0ffULL, 0x0000001024267810ULL, 0x000fe20007ffe0ffULL,
0x000000011f127824ULL, 0x000fe200078e021cULL, 0x0000650029297a11ULL, 0x000fe200000f3cffULL,
0x000000011f167824ULL, 0x000fe200078e0228ULL, 0x00000048480f7211ULL, 0x000fe200078fe8ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000002824207810ULL, 0x000fe40007ffe0ffULL,
0x000000030f0f7812ULL, 0x000fe200078ec0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000030121a7812ULL, 0x000fc400078ef809ULL, 0x0000007a030d7217ULL, 0x000fe20007800000ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000271a1a7210ULL, 0x080fe40007f3e0ffULL,
0x0000003016127812ULL, 0x100fe200078ef809ULL, 0x000000011f147824ULL, 0x000fe200078e0226ULL,
0x0000003010187812ULL, 0x000fe200078ef809ULL, 0x00000001131b7824ULL, 0x000fe200008e0629ULL,
0x0000002712127210ULL, 0x000fe20007f3e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000001827187210ULL, 0x000fc40007f1e0ffULL, 0x0000100002217811ULL, 0x000fe200078e68ffULL,
0x000000041c167824ULL, 0x000fe200078e00ffULL, 0x0000003014107812ULL, 0x000fe200078ef809ULL,
0x0000000117137824ULL, 0x100fe200008e0629ULL, 0x00000020241e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111197824ULL, 0x000fe200000e0629ULL, 0xfffffffc16167812ULL, 0x000fe200078ee20fULL,
0x000000011f177824ULL, 0x000fe200078e0220ULL, 0x0000002710107210ULL, 0x000fe20007f1e0ffULL,
0x000000010d0d7824ULL, 0x000fe200078e0a7aULL, 0x0ffffffc0f487812ULL, 0x000fe200078ef848ULL,
0x0000001016257824ULL, 0x000fe200078e0221ULL, 0x0000003024227810ULL, 0x000fe20007ffe0ffULL,
0x0000008017167825ULL, 0x000fe200078e00ffULL, 0x0000000d1c00720cULL, 0x000fc40003f26070ULL,
0x0000000d2800720cULL, 0x080fe20003f86070ULL, 0x0000000115117824ULL, 0x000fe200000e0629ULL,
0x0000000d2400720cULL, 0x000fe20003f06070ULL, 0x000000011f147824ULL, 0x040fe200078e021eULL,
0x00000030161c7812ULL, 0x000fe200078ef809ULL, 0x0000001048237824ULL, 0x000fe200078e0221ULL,
0x0000003824247810ULL, 0x000fe20007ffe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000271c1c7210ULL, 0x000fe40007fde0ffULL, 0x0000000d2600720cULL, 0x080fe20003fa6070ULL,
0x000000011f167824ULL, 0x000fe200078e0222ULL, 0x0000003014147812ULL, 0x000fe200078ef809ULL,
0x00000001171d7824ULL, 0x000fe200030e0629ULL, 0x0000000d1e00720cULL, 0x000fe20003f66070ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e2000c101c48ULL, 0x0000002714147210ULL, 0x000fc40007f5e0ffULL,
0x0000000428287824ULL, 0x000fe200078e00ffULL, 0x000000001a257faeULL, 0x0005e2000c901c48ULL,
0x0000003016167812ULL, 0x000fe200078ef809ULL, 0x00000004202a7824ULL, 0x000fe200078e00ffULL,
0x0000000d2200720cULL, 0x000fe20003f26070ULL, 0x0000000115157824ULL, 0x000fe200010e0629ULL,
0x0000002716167210ULL, 0x000fe20007fde0ffULL, 0x00000004222c7824ULL, 0x000fe200078e00ffULL,
0x0000000d2000720cULL, 0x080fe20003f46070ULL, 0x000000011f187824ULL, 0x002fe200078e0224ULL,
0x0000000d2400720cULL, 0x040fe20003f06070ULL, 0x00000004242e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc2a227812ULL, 0x100fe200078ee20fULL, 0x00000004261a7824ULL, 0x004fe200078e00ffULL,
0xfffffffc2c247812ULL, 0x000fe200078ee20fULL, 0x0000008018187825ULL, 0x000fc600078e00ffULL,
0xfffffffc1a1a7812ULL, 0x000fe200078ee20fULL, 0x000000041e267824ULL, 0x000fe200078e00ffULL,
0x0000003018097812ULL, 0x000fe200078ef809ULL, 0x0000000117177824ULL, 0x000fe200030e0629ULL,
0xfffffffc281e7812ULL, 0x000fe200078ee20fULL, 0x00000010221b7824ULL, 0x000fe200078e0221ULL,
0xfffffffc26207812ULL, 0x000fe200078ee20fULL, 0x00000010241f7824ULL, 0x100fe200078e0221ULL,
0x0000002709187210ULL, 0x000fe20007fde0ffULL, 0x000000101a097824ULL, 0x000fe200078e0221ULL,
0xfffffffc2e267812ULL, 0x000fe200078ee20fULL, 0x000000101e0d7824ULL, 0x000fc400078e0221ULL,
0x00000010200f7824ULL, 0x100fe200078e0221ULL, 0x0000000010097faeULL, 0x0003e2000e901c48ULL,
0x0000001026217824ULL, 0x000fe400078e0221ULL, 0x0000000119197824ULL, 0x000fe200030e0629ULL,
0x00000000120d7faeULL, 0x0003e8000e101c48ULL, 0x00000000140f7faeULL, 0x0003e8000d901c48ULL,
0x000000001c1b7faeULL, 0x0003e8000d101c48ULL, 0x00000000161f7faeULL, 0x0003e8000c901c48ULL,
0x0000000018217faeULL, 0x0003e2000c101c48ULL, 0x0000056000007947ULL, 0x000fea0003800000ULL,
0x0000001048147811ULL, 0x048fe400078ff0ffULL, 0x0000001848167811ULL, 0x000fc400078ff0ffULL,
0x0000002048187811ULL, 0x040fe200078ff0ffULL, 0x000000011f157824ULL, 0x040fe200078e0214ULL,
0x00000028481a7811ULL, 0x040fe200078ff0ffULL, 0x000000011f177824ULL, 0x040fe200078e0216ULL,
0x00000048480d7211ULL, 0x000fe200078fe8ffULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0x0000000848207811ULL, 0x000fe200078ff0ffULL, 0x0000000416167824ULL, 0x000fe200078e00ffULL,
0x00000030481c7811ULL, 0x040fe200078ff0ffULL, 0x000000011f197824ULL, 0x040fe200078e0218ULL,
0x00000038481e7811ULL, 0x000fe200078ff0ffULL, 0x0000000418187824ULL, 0x000fe200078e00ffULL,
0x0000001f48107211ULL, 0x000fe200078ff0ffULL, 0x000000011f1b7824ULL, 0x000fe200078e021aULL,
0x000000030d217812ULL, 0x000fe200078ec0ffULL, 0x000000011f127824ULL, 0x040fe200078e0220ULL,
0x00001000022f7811ULL, 0x000fe200078e68ffULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc140f7812ULL, 0x100fe200078ee221ULL, 0x000000011f1d7824ULL, 0x040fe200078e021cULL,
0xfffffffc16137812ULL, 0x100fe200078ee221ULL, 0x000000041c1c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc18147812ULL, 0x100fe200078ee221ULL, 0x000000011f1f7824ULL, 0x000fe200078e021eULL,
0xfffffffc1a167812ULL, 0x100fe200078ee221ULL, 0x0000000420207824ULL, 0x000fe200078e00ffULL,
0xfffffffc1c187812ULL, 0x000fe200078ee221ULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x00006400292b7a11ULL, 0x000fe200078038ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0ffffffc21487812ULL, 0x000fc400078ef848ULL, 0xfffffffc200d7812ULL, 0x000fe200078ee221ULL,
0x0000001014237824ULL, 0x000fe200078e022fULL, 0xfffffffc1e1a7812ULL, 0x000fe200078ee221ULL,
0x0000001013217824ULL, 0x000fe200078e022fULL, 0x0000003010107812ULL, 0x000fe200078ef809ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00006500292d7a11ULL, 0x000fe400000f3cffULL,
0x000000102b107210ULL, 0x000fe20007f1e0ffULL, 0x0000001016257824ULL, 0x000fe200078e022fULL,
0x0000003012127812ULL, 0x000fe200078ef809ULL, 0x0000008015147825ULL, 0x000fc800078e00ffULL,
0x0000001018277824ULL, 0x000fe200078e022fULL, 0x0000003014147812ULL, 0x000fe200078ef809ULL,
0x0000008017167825ULL, 0x000fc600078e00ffULL, 0x000000142b147210ULL, 0x000fe20007f3e0ffULL,
0x000000101a297824ULL, 0x000fe200078e022fULL, 0x0000003016167812ULL, 0x000fe200078ef809ULL,
0x0000008019187825ULL, 0x000fc600078e00ffULL, 0x000000162b167210ULL, 0x000fe20007f5e0ffULL,
0x000000801b1a7825ULL, 0x000fe200078e00ffULL, 0x0000003018187812ULL, 0x000fc600078ef809ULL,
0x000000801d1c7825ULL, 0x000fe200078e00ffULL, 0x000000301a1a7812ULL, 0x100fe400078ef809ULL,
0x000000182b187210ULL, 0x000fe20007f7e0ffULL, 0x000000801f1e7825ULL, 0x000fe200078e00ffULL,
0x000000301c1c7812ULL, 0x000fe400078ef809ULL, 0x0000001a2b1a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000111117824ULL, 0x000fe200000e062dULL, 0x000000122b127210ULL, 0x000fe20007f1e0ffULL,
0x0000001048317824ULL, 0x000fe200078e022fULL, 0x000000301e097812ULL, 0x000fe200078ef809ULL,
0x000000100d0d7824ULL, 0x000fe200078e022fULL, 0x0000001c2b1c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000113137824ULL, 0x000fe200000e062dULL, 0x000000092b1e7210ULL, 0x000fe20007fde0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e022fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010317faeULL, 0x0003e2000b901c48ULL, 0x0000000115157824ULL, 0x000fc400008e062dULL,
0x0000000117177824ULL, 0x100fe200010e062dULL, 0x00000000120d7faeULL, 0x0003e2000b901c48ULL,
0x0000000119197824ULL, 0x100fe400018e062dULL, 0x000000011b1b7824ULL, 0x100fe200020e062dULL,
0x00000000140f7faeULL, 0x0003e2000b901c48ULL, 0x000000011d1d7824ULL, 0x100fe400028e062dULL,
0x000000011f1f7824ULL, 0x000fe200030e062dULL, 0x0000000016217faeULL, 0x0003e8000b901c48ULL,
0x0000000018237faeULL, 0x0003e8000b901c48ULL, 0x000000001a257faeULL, 0x0003e8000b901c48ULL,
0x000000001c277faeULL, 0x0003e8000b901c48ULL, 0x000000001e297faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000107805ULL, 0x002fc40000015200ULL,
0x00f60400ff097984ULL, 0x000e620000000800ULL, 0x0000000e07427224ULL, 0x000fc400078e02ffULL,
0x0000000103787824ULL, 0x000fe200078e0a00ULL, 0x8000000009ff7812ULL, 0x002fe2000780480bULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000ff00000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000620042427625ULL, 0x000fe200078e0043ULL,
0x00000008ff787819ULL, 0x000fe20000011678ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011413ULL,
0x0000001207077211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x0000000207077819ULL, 0x000fc80000001212ULL, 0x000000070000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000109097810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e640000000000ULL, 0x0000002002077824ULL, 0x002fca00078e0207ULL,
0x00000003ff097819ULL, 0x000fc80000011607ULL, 0x1ffffffe090a7812ULL, 0x000fe400078ec0ffULL,
0x0000000f07097812ULL, 0x000fc600078ec0ffULL, 0x00000001070a7824ULL, 0x000fe400078e020aULL,
0x0000001009107824ULL, 0x040fe400078e00ffULL, 0x0000001009097824ULL, 0x000fe200078e00ffULL,
0x0000000f0a077812ULL, 0x040fe400078ec0ffULL, 0x000000010a0a7810ULL, 0x000fe40007ffe0ffULL,
0x000000f010077812ULL, 0x000fe400078ee207ULL, 0x0000000f0a0a7812ULL, 0x000fc600078ec0ffULL,
0x0000000007147984ULL, 0x000e62000000cc00ULL, 0x000000f0090a7812ULL, 0x000fca00078ee20aULL,
0x000000000a107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff187224ULL, 0x002fe400078e0014ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000ffff1a7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0012ULL, 0x000000ffff167224ULL, 0x000fe400078e0011ULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x0000001807007388ULL, 0x0003e8000000cc00ULL,
0x000000140a007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff127f8cULL, 0x000ea2000c80043fULL, 0x000000ffff097224ULL, 0x000fc600078e00ffULL,
0x00000000000a7805ULL, 0x002fc80000015200ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fc40007804813ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100a107210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0bULL, 0x003d09001000780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401000780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011411ULL,
0x0000001007077211ULL, 0x000fca00078110ffULL, 0x000000ffff107224ULL, 0x000fca00000e0611ULL,
0x0000000207077819ULL, 0x000fc80000001210ULL, 0x000000070000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000109097810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e620000000000ULL, 0x00006a0008777a24ULL, 0x000fe200078e02ffULL,
0x3db504f30c087820ULL, 0x010fe20000410000ULL, 0x000000020e757824ULL, 0x000fe200078e00ffULL,
0x0000f68802797811ULL, 0x000fe200078e18ffULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0xffffffff00737810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x0000000900747810ULL, 0x000fe40007ffe0ffULL, 0x0000f608027c7811ULL, 0x000fc400078e28ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e000aULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x018fc4000001ff00ULL, 0x000000010c00780cULL, 0x000fe20003f25270ULL,
0x00000c2000007945ULL, 0x000fe20003800000ULL, 0x00000001090d7810ULL, 0x000fc40007ffe0ffULL,
0x000000010c1c7810ULL, 0x020fe40007ffe0ffULL, 0x000000010b0a7812ULL, 0x000fe400078e0cffULL,
0x000000021c00780cULL, 0x040fe40003f06070ULL, 0x000000ff1c0e7207ULL, 0x000fc60000800000ULL,
0x000000ffff0d1224ULL, 0x000fc800078e0209ULL, 0x000001000d3f7824ULL, 0x040fe200078e027aULL,
0x000000010d0f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe200078e001cULL, 0x000000040f00720cULL, 0x000fe20003f46070ULL,
0x00000076060f7224ULL, 0x010fe200078e02ffULL, 0x000000403f1d7812ULL, 0x000fca00078ec0ffULL,
0x00000001723c7824ULL, 0x000fcc00078e021dULL, 0x000005f00000a947ULL, 0x000fea0003800000ULL,
0x00000010071d7824ULL, 0x002fe200078e00ffULL, 0x0000003f031c7217ULL, 0x000fe20007800000ULL,
0x00000002023e7824ULL, 0x000fe200078e020aULL, 0x00000002ff407819ULL, 0x000fe40000011607ULL,
0x000000301d1d7812ULL, 0x000fe200078ec0ffULL, 0x000000011c3f7824ULL, 0x000fe200078e0a3fULL,
0x0000001840487810ULL, 0x040fe20007ffe0ffULL, 0x0000000140357824ULL, 0x140fe200078e023cULL,
0x0000001040467810ULL, 0x000fe20007ffe0ffULL, 0x000000400e1c7824ULL, 0x000fe200078e021dULL,
0x0000000840417810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0x000064000f3d7a11ULL, 0x000fe200078238ffULL, 0x00000001481f7824ULL, 0x000fe200078e023cULL,
0x00000020404a7810ULL, 0x000fe20007ffe0ffULL, 0x0000008035347825ULL, 0x000fe200078e001cULL,
0x000065000f0f7a11ULL, 0x000fc400008f3cffULL, 0x000010003e3e7811ULL, 0x000fe200078e60ffULL,
0x00000001463b7824ULL, 0x100fe200078e023cULL, 0x0000003d34387210ULL, 0x000fe20007f3e0ffULL,
0x0000000141377824ULL, 0x000fe200078e023cULL, 0x0000000707347211ULL, 0x000fe200078fe8ffULL,
0x000000801f1e7825ULL, 0x100fe200078e001cULL, 0x00000030404b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000334447812ULL, 0x000fe200078ec0ffULL, 0x000000803b3a7825ULL, 0x000fe200078e001cULL,
0x00000038404c7810ULL, 0x000fc40007ffe0ffULL, 0x0ffffffc44457812ULL, 0x000fe200078ef807ULL,
0x0000008037367825ULL, 0x000fe200078e001cULL, 0x0000003d3a3a7210ULL, 0x000fe40007f7e0ffULL,
0x0000003f4800720cULL, 0x000fe20003fa6070ULL, 0x0000000135397824ULL, 0x100fe200008e060fULL,
0x0000003d1e1e7210ULL, 0x080fe20007f3e0ffULL, 0x000000013b3b7824ULL, 0x100fe200018e060fULL,
0x0000003d36367210ULL, 0x000fe20007f5e0ffULL, 0x0000000441477824ULL, 0x000fe200078e00ffULL,
0x0000003f4600720cULL, 0x080fe20003f66070ULL, 0x000000011f1f7824ULL, 0x100fe200008e060fULL,
0x0000003f4000720cULL, 0x080fe20003f26070ULL, 0x0000000137377824ULL, 0x000fe200010e060fULL,
0x0000003f4100720cULL, 0x000fe20003f46070ULL, 0x0000000446497824ULL, 0x000fe200078e00ffULL,
0x0000002840467810ULL, 0x000fe20007ffe0ffULL, 0x000000014a357824ULL, 0x000fe200078e023cULL,
0xfffffffc47477812ULL, 0x000fe200078ee244ULL, 0x0000001045457824ULL, 0x000fe200078e023eULL,
0xfffffffc49497812ULL, 0x000fe200078ee244ULL, 0x0000000146417824ULL, 0x000fc400078e023cULL,
0x0000008035347825ULL, 0x000fe400078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038457faeULL, 0x0003e2000c901c48ULL, 0x0000003f4c00720cULL, 0x000fe20003f26070ULL,
0x0000001047477824ULL, 0x000fe200078e023eULL, 0x0000003d34347210ULL, 0x000fe20007f9e0ffULL,
0x0000008041407825ULL, 0x000fc600078e001cULL, 0x0000000036477faeULL, 0x0005e2000d101c48ULL,
0x0000001049497824ULL, 0x000fe200078e023eULL, 0x0000003f4b00720cULL, 0x080fe20003f46070ULL,
0x0000000135357824ULL, 0x000fe200020e060fULL, 0x0000003f4a00720cULL, 0x080fe20003f86070ULL,
0x000000014b397824ULL, 0x102fe200078e023cULL, 0x000000003a497faeULL, 0x0003e2000d901c48ULL,
0x000000014c457824ULL, 0x000fe200078e023cULL, 0x0000003f4600720cULL, 0x000fe20003f66070ULL,
0x0000008039387825ULL, 0x000fe200078e001cULL, 0x0000003d40367210ULL, 0x004fc60007fde0ffULL,
0x000000044a3f7824ULL, 0x000fe400078e00ffULL, 0x00000080451c7825ULL, 0x000fc600078e001cULL,
0xfffffffc3f3f7812ULL, 0x100fe200078ee244ULL, 0x00000004483b7824ULL, 0x002fe400078e00ffULL,
0x0000000141377824ULL, 0x100fe200030e060fULL, 0x0000003d38387210ULL, 0x080fe20007fde0ffULL,
0x0000000446417824ULL, 0x000fe200078e00ffULL, 0xfffffffc3b3b7812ULL, 0x100fe200078ee244ULL,
0x000000044b457824ULL, 0x000fe400078e00ffULL, 0x000000044c477824ULL, 0x000fe200078e00ffULL,
0xfffffffc41417812ULL, 0x100fe200078ee244ULL, 0x0000000139397824ULL, 0x000fe200030e060fULL,
0xfffffffc45457812ULL, 0x000fe200078ee244ULL, 0x000000103b3b7824ULL, 0x000fe200078e023eULL,
0xfffffffc47477812ULL, 0x000fe200078ee244ULL, 0x000000103f3f7824ULL, 0x100fe200078e023eULL,
0x0000003d1c1c7210ULL, 0x000fe20007fde0ffULL, 0x00000010413d7824ULL, 0x100fe200078e023eULL,
0x000000001e3b7faeULL, 0x0003e2000e901c48ULL, 0x0000001045417824ULL, 0x000fc400078e023eULL,
0x0000001047457824ULL, 0x000fe200078e023eULL, 0x00000000343f7faeULL, 0x0003e2000e101c48ULL,
0x000000011d1d7824ULL, 0x000fc600030e060fULL, 0x00000000363d7faeULL, 0x0003e8000d901c48ULL,
0x0000000038417faeULL, 0x0003e8000d101c48ULL, 0x000000001c457faeULL, 0x0003e2000c901c48ULL,
0x0000053000007947ULL, 0x000fea0003800000ULL, 0x0000000807357811ULL, 0x042fe200078ff0ffULL,
0x00000010071c7824ULL, 0x040fe200078e00ffULL, 0x00000010073b7811ULL, 0x040fe200078ff0ffULL,
0x00000002021e7824ULL, 0x000fe200078e020aULL, 0x00000018073d7811ULL, 0x000fe200078ff0ffULL,
0x0000000135377824ULL, 0x100fe200078e023cULL, 0x00000007071d7211ULL, 0x000fe200078fe8ffULL,
0x0000000435357824ULL, 0x000fe200078e00ffULL, 0x00000020073f7811ULL, 0x000fe200078ff0ffULL,
0x000000013b397824ULL, 0x100fe200078e023cULL, 0x0000002807417811ULL, 0x000fe200078ff0ffULL,
0x000000043b477824ULL, 0x000fe200078e00ffULL, 0x0000003007457811ULL, 0x000fe200078ff0ffULL,
0x000000013d3b7824ULL, 0x140fe200078e023cULL, 0x000000301c1f7812ULL, 0x000fe200078ec0ffULL,
0x000000043d497824ULL, 0x000fe200078e00ffULL, 0x000000031d1c7812ULL, 0x000fe200078ec0ffULL,
0x000000013f3d7824ULL, 0x100fe200078e023cULL, 0x00000038074f7811ULL, 0x000fe200078ff0ffULL,
0x000000043f4b7824ULL, 0x000fe200078e00ffULL, 0x000010001e517811ULL, 0x000fe200078e60ffULL,
0x00000001413f7824ULL, 0x000fe200078e023cULL, 0xfffffffc35347812ULL, 0x100fe200078ee21cULL,
0x0000000441417824ULL, 0x000fe200078e00ffULL, 0xfffffffc47367812ULL, 0x000fe200078ee21cULL,
0x00000001451d7824ULL, 0x000fe200078e023cULL, 0x0000003c07357211ULL, 0x000fe200078ff0ffULL,
0x0000000445457824ULL, 0x000fe200078e00ffULL, 0xfffffffc49387812ULL, 0x100fe200078ee21cULL,
0x000000400e1e7824ULL, 0x000fe200078e021fULL, 0xfffffffc4b3a7812ULL, 0x100fe200078ee21cULL,
0x000000044f4d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc413e7812ULL, 0x100fe200078ee21cULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0xfffffffc45407812ULL, 0x100fe200078ee21cULL,
0x0000001034417824ULL, 0x100fe200078e0251ULL, 0x000064000f537a11ULL, 0x000fe200078238ffULL,
0x0000001036457824ULL, 0x000fe200078e0251ULL, 0xfffffffc4d447812ULL, 0x000fe200078ee21cULL,
0x0000008035347825ULL, 0x000fe200078e001eULL, 0x0ffffffc1c1c7812ULL, 0x000fc400078ef807ULL,
0x000065000f0f7a11ULL, 0x000fe200008f3cffULL, 0x0000001038477824ULL, 0x000fe200078e0251ULL,
0x0000005334347210ULL, 0x000fe20007f3e0ffULL, 0x0000008037367825ULL, 0x000fc800078e001eULL,
0x000000103a497824ULL, 0x000fe200078e0251ULL, 0x0000005336367210ULL, 0x000fe20007f5e0ffULL,
0x0000008039387825ULL, 0x000fc800078e001eULL, 0x000000803b3a7825ULL, 0x000fe200078e001eULL,
0x0000005338387210ULL, 0x000fc60007f7e0ffULL, 0x000000014f4f7824ULL, 0x000fe200078e023cULL,
0x000000533a3a7210ULL, 0x000fe20007f9e0ffULL, 0x000000103e4b7824ULL, 0x000fe400078e0251ULL,
0x000000803d3c7825ULL, 0x000fc800078e001eULL, 0x000000101c557824ULL, 0x000fe400078e0251ULL,
0x000000803f3e7825ULL, 0x000fc800078e001eULL, 0x000000801d1c7825ULL, 0x000fc800078e001eULL,
0x000000804f1e7825ULL, 0x000fc800078e001eULL, 0x0000000135357824ULL, 0x100fe200008e060fULL,
0x000000533c3c7210ULL, 0x080fe20007f3e0ffULL, 0x0000000137377824ULL, 0x100fe200010e060fULL,
0x000000533e3e7210ULL, 0x080fe20007f5e0ffULL, 0x0000000139397824ULL, 0x100fe200018e060fULL,
0x000000531c1c7210ULL, 0x080fe20007f7e0ffULL, 0x000000013b3b7824ULL, 0x100fe200020e060fULL,
0x000000531e1e7210ULL, 0x000fe20007f9e0ffULL, 0x000000013d3d7824ULL, 0x100fe200008e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034557faeULL, 0x0003e2000b901c48ULL,
0x000000013f3f7824ULL, 0x000fc400010e060fULL, 0x00000010404d7824ULL, 0x000fe200078e0251ULL,
0x0000000036417faeULL, 0x0003e2000b901c48ULL, 0x000000011d1d7824ULL, 0x000fe400018e060fULL,
0x0000001044517824ULL, 0x000fe200078e0251ULL, 0x0000000038457faeULL, 0x0003e2000b901c48ULL,
0x000000011f1f7824ULL, 0x000fc600020e060fULL, 0x000000003a477faeULL, 0x0003e8000b901c48ULL,
0x000000003c497faeULL, 0x0003e8000b901c48ULL, 0x000000003e4b7faeULL, 0x0003e8000b901c48ULL,
0x000000001c4d7faeULL, 0x0003e8000b901c48ULL, 0x000000001e517faeULL, 0x0003e4000b901c48ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010e00780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x0000000205057810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff067424ULL, 0x000fc600078e00ffULL,
0x000000710500720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x00000002770e7824ULL, 0x000fe400078e0205ULL, 0x00000004ff0f7424ULL, 0x000fc800078e00ffULL,
0x000066000e0e7625ULL, 0x000fca00078e000fULL, 0x000000080e067981ULL, 0x000524000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff8071c7812ULL, 0x022fe200078ec0ffULL, 0x0000000202597824ULL, 0x000fe200078e020bULL,
0x000000010e5a7810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000071c1c7812ULL, 0x000fe400078ef807ULL, 0x0000100059597811ULL, 0x000fe400078e60ffULL,
0x00000001ff0f7819ULL, 0x000fe2000001161cULL, 0x000000041c1e7824ULL, 0x000fc400078e00ffULL,
0x000000041c1c7824ULL, 0x000fe400078e00ffULL, 0x000000010f1d7824ULL, 0x040fe400078e020eULL,
0x000000010f0f7824ULL, 0x000fc600078e025aULL, 0xfffffffc1e1e7812ULL, 0x000fe400078ee21dULL,
0xfffffffc1c1c7812ULL, 0x000fc600078ee20fULL, 0x000000101e1e7824ULL, 0x100fe400078e0259ULL,
0x000000101c1c7824ULL, 0x000fc600078e0259ULL, 0x000000001e3c783bULL, 0x000e680000000200ULL,
0x000000001c34783bULL, 0x0005e40000000200ULL, 0x00000020071c7810ULL, 0x004fc80007ffe0ffULL,
0xfffffff81c1c7812ULL, 0x000fc800078ec0ffULL, 0x000000071c637812ULL, 0x000fc800078ef807ULL,
0x00000001ff647819ULL, 0x000fe20000011663ULL, 0x00000004631c7824ULL, 0x040fe400078e00ffULL,
0x0000000463637824ULL, 0x000fe400078e00ffULL, 0x00000001640f7824ULL, 0x040fe400078e020eULL,
0x0000000164647824ULL, 0x000fc600078e025aULL, 0xfffffffc1c1c7812ULL, 0x000fca00078ee20fULL,
0x000000101c1c7824ULL, 0x000fe200078e0259ULL, 0x0000003d005d7306ULL, 0x002fe20000009400ULL,
0x00000018ff567819ULL, 0x000fe2000001143cULL, 0x000100003d697824ULL, 0x040fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe2000001143dULL, 0x000000001c38783bULL, 0x0002a20000000200ULL,
0x000001003d6a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe2000001143eULL,
0x000100003e617824ULL, 0x000fe200078e00ffULL, 0x0000003d005e7306ULL, 0x000ee20000005400ULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x000001003f6d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x000100003c1c7824ULL, 0x002fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fc40000011461ULL, 0x00000018ff467819ULL, 0x000fe2000001143fULL,
0x0000003e001e7306ULL, 0x000fe20000009400ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff6d7819ULL, 0x000fca000001146dULL, 0x0000003e001f7306ULL, 0x000e620000005400ULL,
0x0000005e5d00720bULL, 0x008fe40003f5d000ULL, 0x0000001c005d7245ULL, 0x000fca000020d400ULL,
0x0000005600537306ULL, 0x000ff00000209400ULL, 0x0000005600627306ULL, 0x000ee20000205400ULL,
0x0000001f1e00720bULL, 0x002fe20003f3d000ULL, 0x000000040d1f7824ULL, 0x000fe200078e020eULL,
0x000000020e0e7810ULL, 0x000fe20007ffe0ffULL, 0x0001000039707824ULL, 0x004fc800078e00ffULL,
0x0000005700487306ULL, 0x000fe20000209400ULL, 0x00000018ff707819ULL, 0x000fce0000011470ULL,
0x0000005700477306ULL, 0x000e620000205400ULL, 0x000000625300720bULL, 0x008fe40003fbd000ULL,
0x0000000707627812ULL, 0x000fca00078ec0ffULL, 0x0000003c001d7306ULL, 0x000ff00000009400ULL,
0x0000003c00507306ULL, 0x000ea20000005400ULL, 0x000000474800720bULL, 0x002fe20003f9d000ULL,
0x000000021f487824ULL, 0x000fe200078e00ffULL, 0x0000000862477812ULL, 0x000fc800078ef807ULL,
0x0000004807627211ULL, 0x000fe200078fe0ffULL, 0x0000001c00557306ULL, 0x000fe20000209400ULL,
0x00000010471f7824ULL, 0x040fe200078e00ffULL, 0x0000000248487810ULL, 0x000fe40007ffe0ffULL,
0x0000000147627824ULL, 0x000fc800078e0262ULL, 0x0000001c005e7306ULL, 0x0002e20000205400ULL,
0x000000501d00720bULL, 0x004fe40003f7d000ULL, 0xfffffff01f627812ULL, 0x000fca00078ee262ULL,
0x0000003c00547306ULL, 0x0004a2000000d400ULL, 0x00000010621c7824ULL, 0x002fe200078e00ffULL,
0x0000005e5500720bULL, 0x008fe20003fdd000ULL, 0x000001003c3c7824ULL, 0x004fca00078e00ffULL,
0x0000006900537306ULL, 0x000fe20000209400ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000000154543812ULL, 0x000fca00078efcffULL, 0x0000003c001d7306ULL, 0x000fe20000209400ULL,
0x000000015d5d6812ULL, 0x000fce00078efcffULL, 0x0000003c001e7306ULL, 0x000e700000205400ULL,
0x00000069005e7306ULL, 0x0004e20000205400ULL, 0x0000001e1d00720bULL, 0x002fce0003fdd000ULL,
0x0000003d005c7306ULL, 0x000e62000000d400ULL, 0x000000001c1c783bULL, 0x000e620000000200ULL,
0x0000006900697245ULL, 0x004fe4000020d400ULL, 0x0000005e5300720bULL, 0x008fc80003f7d000ULL,
0x0000006a003d7306ULL, 0x000fe20000209400ULL, 0x0000003c005e7245ULL, 0x000fe4000020d400ULL,
0x000000545d3c723eULL, 0x000fe400000010ffULL, 0x000000015e5e6812ULL, 0x000fc600078efcffULL,
0x0000006a00627306ULL, 0x000ea20000205400ULL, 0x000000015c5c2812ULL, 0x002fe400078efcffULL,
0x0000000169693812ULL, 0x000fca00078efcffULL, 0x00000049006b7306ULL, 0x000ff00000209400ULL,
0x00000049006c7306ULL, 0x000e620000205400ULL, 0x000000623d00720bULL, 0x004fe40003fdd000ULL,
0x00000056003d7245ULL, 0x000fc8000020d400ULL, 0x000000013d3d5812ULL, 0x000fe200078efcffULL,
0x0000003e005b7306ULL, 0x0004e6000000d400ULL, 0x0000005e3d3d723eULL, 0x000fe400000010ffULL,
0x0000006c6b00720bULL, 0x002fe20003fbd000ULL, 0x000001003e3e7824ULL, 0x004fe400078e00ffULL,
0x00000061005d7306ULL, 0x000fe40000209400ULL, 0x0000003c1c30723cULL, 0x000be20000041830ULL,
0x00000057006c7245ULL, 0x000fc4000020d400ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x000000016c6c4812ULL, 0x000fe200078efcffULL, 0x0000006100627306ULL, 0x000e620000205400ULL,
0x0000006a003d7245ULL, 0x020fe4000020d400ULL, 0x0000005c693c723eULL, 0x000fe400000010ffULL,
0x000000013d3d6812ULL, 0x000fe400078efcffULL, 0x00000049006a7245ULL, 0x000fe2000020d400ULL,
0x0000003e005e7306ULL, 0x000fe20000209400ULL, 0x0000003d6c3d723eULL, 0x000fe200000010ffULL,
0x000100003f6c7824ULL, 0x000fe200078e00ffULL, 0x000000015b5b1812ULL, 0x008fc400078efcffULL,
0x000000016a6a5812ULL, 0x000fe400078efcffULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x0000003e006b7306ULL, 0x000ea20000205400ULL, 0x000000625d00720bULL, 0x002fe20003f5d000ULL,
0x0000003c1c2c723cULL, 0x000b62000004182cULL, 0x00000018ff5c7819ULL, 0x000fca0000011434ULL,
0x0000003f005f7306ULL, 0x000fe20000009400ULL, 0x00000061003c7245ULL, 0x020fe4000020d400ULL,
0x0000003e003d7245ULL, 0x000fc6000020d400ULL, 0x000000013c3c2812ULL, 0x000fe400078efcffULL,
0x0000006b5e00720bULL, 0x004fe20003f7d000ULL, 0x0000003f00607306ULL, 0x000e620000005400ULL,
0x0000005b3c3c723eULL, 0x000fe400000010ffULL, 0x00000018ff5b7819ULL, 0x000fca0000011435ULL,
0x0000004600657306ULL, 0x000fe80000209400ULL, 0x000000013d3d3812ULL, 0x000fc800078efcffULL,
0x0000004600667306ULL, 0x0004e20000205400ULL, 0x0000003d6a3d723eULL, 0x000fe400000010ffULL,
0x000000605f00720bULL, 0x002fe20003fdd000ULL, 0x0001000038607824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fc60000011438ULL, 0x0000003c1c28723cULL, 0x000be20000041828ULL,
0x0000006c00697306ULL, 0x000fe20000209400ULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x0000004600467245ULL, 0x004fc6000020d400ULL, 0xfffffffc633c7812ULL, 0x020fe400078ee264ULL,
0x0000006c006e7306ULL, 0x000e620000205400ULL, 0x000000666500720bULL, 0x008fe40003f3d000ULL,
0x000000103c3c7824ULL, 0x000fca00078e0259ULL, 0x0000005f00637306ULL, 0x000fec0000209400ULL,
0x0000000146461812ULL, 0x000fe400078efcffULL, 0x0000005f00647306ULL, 0x000ea20000205400ULL,
0x0000006e6900720bULL, 0x002fe40003f7d000ULL, 0x00000018ff6e7819ULL, 0x000fca000001143aULL,
0x0000006d005a7306ULL, 0x000ff00000209400ULL, 0x0000006d006b7306ULL, 0x0002e20000205400ULL,
0x000000646300720bULL, 0x004fce0003fbd000ULL, 0x0000003f00587306ULL, 0x0004a2000000d400ULL,
0x0000006d006d7245ULL, 0x002fce000020d400ULL, 0x0000003800677306ULL, 0x000fe20000009400ULL,
0x0000006b5a00720bULL, 0x008fe20003f9d000ULL, 0x000000003c3c783bULL, 0x004e620000000200ULL,
0x00000018ff5a7819ULL, 0x000fca0000011436ULL, 0x0000003800687306ULL, 0x000ea20000005400ULL,
0x0000000158586812ULL, 0x000fca00078efcffULL, 0x000000016d6d4812ULL, 0x000fe400078efcffULL,
0x0000003800457306ULL, 0x000670000000d400ULL, 0x0000006000597306ULL, 0x000fe20000209400ULL,
0x0000010038387824ULL, 0x008fe200078e00ffULL, 0x000000686700720bULL, 0x004fc80003f5d000ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000006000667306ULL, 0x000eae0000205400ULL,
0x0000000145452812ULL, 0x002fe200078efcffULL, 0x0000003800647306ULL, 0x000ff00000209400ULL,
0x0000003800657306ULL, 0x000e620000205400ULL, 0x000000665900720bULL, 0x004fc40003fdd000ULL,
0x0000006c00597245ULL, 0x000fe4000020d400ULL, 0x0000005f006c7245ULL, 0x000fe4000020d400ULL,
0x0000000159593812ULL, 0x000fe200078efcffULL, 0x00000034004f7306ULL, 0x000fe20000009400ULL,
0x000000016c6c5812ULL, 0x000fe400078efcffULL, 0x000000585958723eULL, 0x000fe400000010ffULL,
0x0000006d4659723eULL, 0x000fe200000010ffULL, 0x000001003a6d7824ULL, 0x000fe200078e00ffULL,
0x000000656400720bULL, 0x002fe20003f3d000ULL, 0x0000003400517306ULL, 0x000e660000005400ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x000000581c24723cULL, 0x000b680000041824ULL,
0x0000003500527306ULL, 0x000fe60000009400ULL, 0x0000006000587245ULL, 0x020fe2000020d400ULL,
0x0001000034607824ULL, 0x000fe200078e00ffULL, 0x0000003800597245ULL, 0x000fc4000020d400ULL,
0x0000000158586812ULL, 0x000fe400078efcffULL, 0x0000000159591812ULL, 0x000fe200078efcffULL,
0x00000035004d7306ULL, 0x000ea20000005400ULL, 0x000000455858723eULL, 0x000fe400000010ffULL,
0x000000596c59723eULL, 0x000fe200000010ffULL, 0x000100003a6c7824ULL, 0x000fe200078e00ffULL,
0x000000514f00720bULL, 0x002fe20003f7d000ULL, 0x00000100394f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe20000011460ULL, 0x0000003900507306ULL, 0x000fe20000009400ULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x000000581c20723cULL, 0x000b620000041820ULL,
0x00000018ff4f7819ULL, 0x000fca000001144fULL, 0x0000003900557306ULL, 0x000e620000005400ULL,
0x0000004d5200720bULL, 0x004fe40003fdd000ULL, 0x00000018ff4d7819ULL, 0x000fe40000011439ULL,
0x00000018ff597819ULL, 0x020fc6000001143cULL, 0x0000007000587306ULL, 0x000ff00000209400ULL,
0x0000007000517306ULL, 0x0004e20000205400ULL, 0x000000555000720bULL, 0x002fce0003f5d000ULL,
0x0000004d00527306ULL, 0x000fe20000209400ULL, 0x0000007000707245ULL, 0x004fce000020d400ULL,
0x0000004d00557306ULL, 0x000e620000205400ULL, 0x000000515800720bULL, 0x008fe40003f3d000ULL,
0x0000005c00587245ULL, 0x000fca000020d400ULL, 0x0000004f00507306ULL, 0x000fec0000209400ULL,
0x0000000170701812ULL, 0x000fe400078efcffULL, 0x0000004f00517306ULL, 0x0004e20000205400ULL,
0x000000555200720bULL, 0x002fce0003f9d000ULL, 0x0000003900537306ULL, 0x000e62000000d400ULL,
0x0000004f004f7245ULL, 0x004fce000020d400ULL, 0x0000006c00397306ULL, 0x000fe20000209400ULL,
0x000000515000720bULL, 0x008fce0003f3d000ULL, 0x0000006c00527306ULL, 0x0004e20000205400ULL,
0x0000000153532812ULL, 0x002fca00078efcffULL, 0x000000014f4f1812ULL, 0x000fe400078efcffULL,
0x00000036004e7306ULL, 0x000fe20000009400ULL, 0x0000006c006c7245ULL, 0x004fce000020d400ULL,
0x00000036004c7306ULL, 0x000e620000005400ULL, 0x000000523900720bULL, 0x008fce0003f5d000ULL,
0x0000003a00547306ULL, 0x000fec0000009400ULL, 0x000000016c6c2812ULL, 0x000fe400078efcffULL,
0x0000003a00567306ULL, 0x000ea20000005400ULL, 0x0000004c4e00720bULL, 0x002fe20003f3d000ULL,
0x000100003b4c7824ULL, 0x000fe200078e00ffULL, 0x0000004d004e7245ULL, 0x000fc8000020d400ULL,
0x000000014e4e4812ULL, 0x000fe200078efcffULL, 0x0000003b005d7306ULL, 0x000ff00000009400ULL,
0x0000003b005e7306ULL, 0x000e620000005400ULL, 0x000000565400720bULL, 0x004fe20003fbd000ULL,
0x0000010034567824ULL, 0x000fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000006d00507306ULL, 0x000ff00000209400ULL, 0x0000006d00397306ULL, 0x0004e20000205400ULL,
0x0000005e5d00720bULL, 0x002fe20003f9d000ULL, 0x000001003b5e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fc8000001144cULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x0000003a00577306ULL, 0x000e62000000d400ULL, 0x0000006d006d7245ULL, 0x004fce000020d400ULL,
0x0000006e003a7306ULL, 0x000fe20000209400ULL, 0x000000395000720bULL, 0x008fce0003f5d000ULL,
0x0000006e004d7306ULL, 0x0004e20000205400ULL, 0x0000000157575812ULL, 0x002fca00078efcffULL,
0x000000016d6d2812ULL, 0x000fe400078efcffULL, 0x0000005d004c7306ULL, 0x000fe20000209400ULL,
0x0000006e006e7245ULL, 0x004fce000020d400ULL, 0x0000005d00517306ULL, 0x0002a20000205400ULL,
0x0000004d3a00720bULL, 0x008fce0003fbd000ULL, 0x0000005e00507306ULL, 0x000fe20000209400ULL,
0x0000005d005d7245ULL, 0x002fca000020d400ULL, 0x000000016e6e5812ULL, 0x000fe400078efcffULL,
0x0000005e004d7306ULL, 0x0002e20000205400ULL, 0x000000514c00720bULL, 0x004fe20003f5d000ULL,
0x0000010035517824ULL, 0x000fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000003b00497306ULL, 0x0004e2000000d400ULL, 0x0000005e005e7245ULL, 0x002fca000020d400ULL,
0x000000015d5d2812ULL, 0x000fe400078efcffULL, 0x00000037004b7306ULL, 0x000fe20000009400ULL,
0x00000018ff3b7819ULL, 0x004fe4000001143bULL, 0x0000004d5000720bULL, 0x008fe40003fbd000ULL,
0x0000003b005f7245ULL, 0x000fc6000020d400ULL, 0x00000037004a7306ULL, 0x000e620000005400ULL,
0x0000000149494812ULL, 0x000fce00078efcffULL, 0x0000003b00397306ULL, 0x000fe20000209400ULL,
0x000000015e5e5812ULL, 0x000fce00078efcffULL, 0x0000003b004c7306ULL, 0x000ea20000205400ULL,
0x0000004a4b00720bULL, 0x002fce0003f5d000ULL, 0x00000060004d7306ULL, 0x000ff00000209400ULL,
0x0000006000507306ULL, 0x0002e20000205400ULL, 0x0000004c3900720bULL, 0x004fe20003f9d000ULL,
0x00010000364c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x00000056003a7306ULL, 0x000fe20000209400ULL, 0x0000006000607245ULL, 0x002fca000020d400ULL,
0x000000015f5f4812ULL, 0x000fe400078efcffULL, 0x00000056004b7306ULL, 0x0002a20000205400ULL,
0x000000504d00720bULL, 0x008fe20003fbd000ULL, 0x0001000035507824ULL, 0x000fe400078e00ffULL,
0x00000100364d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000005c00627306ULL, 0x000fe20000209400ULL, 0x0000005600567245ULL, 0x002fe4000020d400ULL,
0x00000018ff4d7819ULL, 0x000fc6000001144dULL, 0x0000000160605812ULL, 0x000fe400078efcffULL,
0x0000005c00617306ULL, 0x000e620000205400ULL, 0x0000004b3a00720bULL, 0x004fce0003f9d000ULL,
0x00000050004a7306ULL, 0x000fec0000209400ULL, 0x0000000156564812ULL, 0x000fe400078efcffULL,
0x00000050004b7306ULL, 0x0004e20000205400ULL, 0x000000616200720bULL, 0x002fe40003fbd000ULL,
0x00000018ff617819ULL, 0x000fca0000011437ULL, 0x00000051003b7306ULL, 0x000fe20000209400ULL,
0x0000005000507245ULL, 0x004fca000020d400ULL, 0x0000000158585812ULL, 0x000fe400078efcffULL,
0x0000005100527306ULL, 0x0002a20000205400ULL, 0x0000004b4a00720bULL, 0x008fe40003f9d000ULL,
0x00000018ff4b7819ULL, 0x000fca000001143dULL, 0x0000005a00697306ULL, 0x000fe20000209400ULL,
0x0000005100517245ULL, 0x002fca000020d400ULL, 0x0000000150504812ULL, 0x000fe400078efcffULL,
0x0000005a00687306ULL, 0x0002e20000205400ULL, 0x000000523b00720bULL, 0x004fe40003fbd000ULL,
0x0000005b00527245ULL, 0x000fca000020d400ULL, 0x0000003400447306ULL, 0x000ea2000000d400ULL,
0x0000005a005a7245ULL, 0x002fca000020d400ULL, 0x0000000151515812ULL, 0x000fe400078efcffULL,
0x0000005b006a7306ULL, 0x000fe20000209400ULL, 0x000000686900720bULL, 0x008fe20003f9d000ULL,
0x0000010037687824ULL, 0x000fca00078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x0000005b006b7306ULL, 0x000e620000205400ULL, 0x0000000144443812ULL, 0x004fca00078efcffULL,
0x000000015a5a4812ULL, 0x000fe400078efcffULL, 0x0000004c004a7306ULL, 0x000ff00000209400ULL,
0x0000004c003b7306ULL, 0x0004e20000205400ULL, 0x0000006b6a00720bULL, 0x002fce0003f7d000ULL,
0x00000036000f7306ULL, 0x000e62000000d400ULL, 0x0000004c004c7245ULL, 0x004fca000020d400ULL,
0x0000000152523812ULL, 0x000fe400078efcffULL, 0x0000004d00367306ULL, 0x000fe20000209400ULL,
0x0000003b4a00720bULL, 0x008fe40003fbd000ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143eULL,
0x000000515251723eULL, 0x000fc600000010ffULL, 0x0000004d00697306ULL, 0x0004e20000205400ULL,
0x000000010f0f1812ULL, 0x002fca00078efcffULL, 0x000000014c4c5812ULL, 0x000fe400078efcffULL,
0x0000003d00657306ULL, 0x000fe20000009400ULL, 0x0000004d004d7245ULL, 0x004fe4000020d400ULL,
0x0000000f4c4c723eULL, 0x000fca00000010ffULL, 0x0000003d00667306ULL, 0x000e620000005400ULL,
0x000000693600720bULL, 0x008fe20003f7d000ULL, 0x000100003c367824ULL, 0x000fe400078e00ffULL,
0x0001000037697824ULL, 0x000fc600078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000003500407306ULL, 0x000ea2000000d400ULL, 0x00000018ff697819ULL, 0x000fca0000011469ULL,
0x000000014d4d3812ULL, 0x000fe400078efcffULL, 0x0000003c00637306ULL, 0x000fe20000009400ULL,
0x000000666500720bULL, 0x002fe40003fbd000ULL, 0x0000004d5a4d723eULL, 0x000fca00000010ffULL,
0x0000003c00647306ULL, 0x000e620000005400ULL, 0x0000000140406812ULL, 0x004fc800078efcffULL,
0x000000405050723eULL, 0x000fc600000010ffULL, 0x0000003e00677306ULL, 0x000ff00000009400ULL,
0x0000003e006f7306ULL, 0x000ea20000005400ULL, 0x000000646300720bULL, 0x002fe20003fdd000ULL,
0x000001003c647824ULL, 0x000fca00078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x0000003f00557306ULL, 0x000ff00000009400ULL, 0x0000003f00347306ULL, 0x000e620000005400ULL,
0x0000006f6700720bULL, 0x004fce0003f3d000ULL, 0x00000036004a7306ULL, 0x000ff00000209400ULL,
0x0000003600657306ULL, 0x000ea20000205400ULL, 0x000000345500720bULL, 0x002fce0003f7d000ULL,
0x0000003c00467306ULL, 0x0002f0000000d400ULL, 0x0000006100357306ULL, 0x000fe20000209400ULL,
0x000000654a00720bULL, 0x004fe40003f9d000ULL, 0x00000036003c7245ULL, 0x002fca000020d400ULL,
0x00000061003a7306ULL, 0x0002a20000205400ULL, 0x0000000146466812ULL, 0x008fca00078efcffULL,
0x000000013c3c4812ULL, 0x000fe400078efcffULL, 0x0000006400347306ULL, 0x000fe20000209400ULL,
0x0000006100617245ULL, 0x002fe4000020d400ULL, 0x000000463c3c723eULL, 0x000fca00000010ffULL,
0x0000006400677306ULL, 0x000e620000205400ULL, 0x0000003a3500720bULL, 0x004fe40003f9d000ULL,
0x0000004f4e35723eULL, 0x000fe400000010ffULL, 0x00000064004f7245ULL, 0x000fe4000020d400ULL,
0x00000018ff3a7819ULL, 0x000fe2000001143fULL, 0x0000006900657306ULL, 0x000fec0000209400ULL,
0x0000000161614812ULL, 0x000fc400078efcffULL, 0x0000006900667306ULL, 0x0004e20000205400ULL,
0x000000673400720bULL, 0x002fe40003fdd000ULL, 0x000000537034723eULL, 0x000fe200000010ffULL,
0x000100003d537824ULL, 0x000fc800078e00ffULL, 0x0000003700417306ULL, 0x000e62000000d400ULL,
0x0000006900697245ULL, 0x004fe2000020d400ULL, 0x000000341c14723cULL, 0x000b620000041814ULL,
0x00000018ff537819ULL, 0x000fc60000011453ULL, 0x000000014f4f6812ULL, 0x000fe400078efcffULL,
0x0000006800367306ULL, 0x000fe20000209400ULL, 0x0000004807347211ULL, 0x020fe400078fe0ffULL,
0x000000666500720bULL, 0x008fe40003fdd000ULL, 0x0000006d6e35723eULL, 0x000fe200000010ffULL,
0x0000000147347824ULL, 0x040fe400078e0234ULL, 0x0000006800377306ULL, 0x0004e20000205400ULL,
0x0000001047477824ULL, 0x000fe200078e00ffULL, 0x0000000141412812ULL, 0x002fc800078efcffULL,
0xfffffff047647812ULL, 0x000fe400078ee234ULL, 0x000000576c34723eULL, 0x000fe200000010ffULL,
0x0000005300487306ULL, 0x000fe20000209400ULL, 0x0000000169696812ULL, 0x000fe200078efcffULL,
0x00000010646a7824ULL, 0x000fe200078e00ffULL, 0x0000006800687245ULL, 0x004fe2000020d400ULL,
0x000100003e647824ULL, 0x000fe400078e00ffULL, 0x000000341c18723cULL, 0x000b620000041818ULL,
0x000000373600720bULL, 0x008fe20003fdd000ULL, 0x0000005300477306ULL, 0x0002a20000205400ULL,
0x000000006a34783bULL, 0x020ee20000000200ULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x000001003e577824ULL, 0x000fca00078e00ffULL, 0x0000005900627306ULL, 0x000fe20000209400ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000005300537245ULL, 0x002fe4000020d400ULL,
0x0000000168686812ULL, 0x000fc600078efcffULL, 0x0000005900637306ULL, 0x000e620000205400ULL,
0x000000474800720bULL, 0x004fe20003fdd000ULL, 0x000100003f477824ULL, 0x000fe200078e00ffULL,
0x000000495d48723eULL, 0x000fe400000010ffULL, 0x0000005e5f49723eULL, 0x000fe200000010ffULL,
0x000001003f5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000003d00387306ULL, 0x0004e8000000d400ULL, 0x000000481c10723cULL, 0x000b640000041810ULL,
0x0000000153536812ULL, 0x000fc400078efcffULL, 0x0000004b005b7306ULL, 0x000fe20000209400ULL,
0x000001003d3d7824ULL, 0x004fe200078e00ffULL, 0x000000636200720bULL, 0x002fe40003f5d000ULL,
0x00000041691c723eULL, 0x020fe400000010ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000004b005c7306ULL, 0x000e620000205400ULL, 0x00000068611d723eULL, 0x000fe200000010ffULL,
0x00000050342c723cULL, 0x008f62000004182cULL, 0x0000005900487245ULL, 0x000fc4000020d400ULL,
0x00000018ff1e7819ULL, 0x000fe4000001145eULL, 0x0000000148482812ULL, 0x000fe200078efcffULL,
0x0000003d00657306ULL, 0x000fe20000209400ULL, 0x0000000138385812ULL, 0x000fe200078efcffULL,
0x0000001c3424723cULL, 0x040b6c0000041824ULL, 0x0000003d00667306ULL, 0x0004e20000205400ULL,
0x0000005c5b00720bULL, 0x002fe20003f9d000ULL, 0x0000004c3428723cULL, 0x000f640000041828ULL,
0x0000003d001d7245ULL, 0x020fc8000020d400ULL, 0x0000006400677306ULL, 0x000fe20000209400ULL,
0x0000004f483d723eULL, 0x004fce00000010ffULL, 0x0000006400637306ULL, 0x0002a20000205400ULL,
0x000000666500720bULL, 0x008fe20003f5d000ULL, 0x0000003c3420723cULL, 0x000f620000041820ULL,
0x0000005700657245ULL, 0x000fca000020d400ULL, 0x0000003e00457306ULL, 0x0006a2000000d400ULL,
0x0000006400647245ULL, 0x002fca000020d400ULL, 0x000000011d1d2812ULL, 0x000fe400078efcffULL,
0x0000003f00397306ULL, 0x000262000000d400ULL, 0x00000044603e723eULL, 0x008fe400000010ffULL,
0x000000636700720bULL, 0x004fca0003fbd000ULL, 0x0000001e001c7306ULL, 0x000fe20000205400ULL,
0x00000056583f723eULL, 0x002fe400000010ffULL, 0x0000000145451812ULL, 0x000fca00078efcffULL,
0x0000003e3430723cULL, 0x000b620000041830ULL, 0x0000003b00547306ULL, 0x000fe20000209400ULL,
0x0000000164645812ULL, 0x000fe400078efcffULL, 0x0000000139393812ULL, 0x000fe400078efcffULL,
0x000000456464723eULL, 0x000fe400000010ffULL, 0x0000004b003e7245ULL, 0x020fe2000020d400ULL,
0x0000001e003f7306ULL, 0x000e660000209400ULL, 0x000000013e3e4812ULL, 0x000fc800078efcffULL,
0x0000001d3e1d723eULL, 0x000fe200000010ffULL, 0x0000003b00557306ULL, 0x000eb00000205400ULL,
0x0000003a004a7306ULL, 0x000fe20000209400ULL, 0x0000001c3f00720bULL, 0x002fc40003f3d000ULL,
0x00000038531c723eULL, 0x000fe400000010ffULL, 0x0000003b00387245ULL, 0x000fc6000020d400ULL,
0x0000003a004e7306ULL, 0x0002e20000205400ULL, 0x000000555400720bULL, 0x004fe20003fdd000ULL,
0x0000001c3414723cULL, 0x000b6c0000041814ULL, 0x0000005700627306ULL, 0x000fe20000209400ULL,
0x0000001e001d7245ULL, 0x020fe4000020d400ULL, 0x00000047001c7245ULL, 0x000fc4000020d400ULL,
0x0000003a003a7245ULL, 0x002fe4000020d400ULL, 0x000000011d1d1812ULL, 0x000fe200078efcffULL,
0x00000057005d7306ULL, 0x000e620000205400ULL, 0x0000004e4a00720bULL, 0x008fe40003f5d000ULL,
0x000000040e00780cULL, 0x000fe40003f25270ULL, 0x0000000138386812ULL, 0x000fc600078efcffULL,
0x0000004700447306ULL, 0x000fec0000209400ULL, 0x000000013a3a2812ULL, 0x000fe400078efcffULL,
0x00000047001f7306ULL, 0x000ea20000205400ULL, 0x0000005d6200720bULL, 0x002fe40003f9d000ULL,
0x0000001d3a1d723eULL, 0x000fd600000010ffULL, 0x0000000165654812ULL, 0x000fe400078efcffULL,
0x0000001f4400720bULL, 0x004fe40003fbd000ULL, 0x000000653865723eULL, 0x000fce00000010ffULL,
0x000000643418723cULL, 0x000b680000041818ULL, 0x000000011c1c5812ULL, 0x000fc800078efcffULL,
0x000000391c1c723eULL, 0x000fce00000010ffULL, 0x0000001c3410723cULL, 0x000b620000041810ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe0c000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e000aULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd35000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x000000082c0b7220ULL, 0x080fe20000410000ULL, 0x000000082d0c7220ULL, 0x080fe20000410000ULL,
0x0000000814147220ULL, 0x080fe20000410000ULL, 0x00000008301f7220ULL, 0x080fe20000410000ULL,
0x00000008320e7220ULL, 0x080fe20000410000ULL, 0x00000008331e7220ULL, 0x080fe20000410000ULL,
0x0000000828337220ULL, 0x080fe20000410000ULL, 0x0000000821307220ULL, 0x080fe20000410000ULL,
0x0000000818347220ULL, 0x0a0fe20000410000ULL, 0x0000000819327220ULL, 0x080fe20000410000ULL,
0x000000082e0f7220ULL, 0x080fe20000410000ULL, 0x000000082f1c7220ULL, 0x080fe20000410000ULL,
0x000000082a287220ULL, 0x080fe20000410000ULL, 0x000000082b1d7220ULL, 0x080fe20000410000ULL,
0x0000000820367220ULL, 0x080fe20000410000ULL, 0x0000000823217220ULL, 0x080fe20000410000ULL,
0x000000081a187220ULL, 0x080fe20000410000ULL, 0x000000081b197220ULL, 0x080fe20000410000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0031ULL, 0x00000008292e7220ULL, 0x080fe20000410000ULL,
0x00000008242f7220ULL, 0x080fe20000410000ULL, 0x0000000825387220ULL, 0x080fe20000410000ULL,
0x00000008262a7220ULL, 0x080fe20000410000ULL, 0x0000000827377220ULL, 0x080fe20000410000ULL,
0x0000000822227220ULL, 0x080fe20000410000ULL, 0x0000000815357220ULL, 0x080fe20000410000ULL,
0x0000000816167220ULL, 0x080fe20000410000ULL, 0x0000000817177220ULL, 0x080fe20000410000ULL,
0x00000008102b7220ULL, 0x080fe20000410000ULL, 0x0000000811207220ULL, 0x080fe20000410000ULL,
0x00000008121a7220ULL, 0x080fe20000410000ULL, 0x00000008131b7220ULL, 0x000fe20000410000ULL,
0x000000ffff2d7224ULL, 0x000fc400078e000bULL, 0x000000ffff237224ULL, 0x000fe400078e000cULL,
0x000000ffff317224ULL, 0x000fe200078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000790c7f8cULL, 0x0002a2000c80043fULL, 0x000000ffff297224ULL, 0x000fe400078e001cULL,
0x000000ffff277224ULL, 0x000fe400078e001dULL, 0x000000ffff1d7224ULL, 0x000fe400078e0022ULL,
0x000000ffff1c7224ULL, 0x000fc400078e0021ULL, 0x000000ffff267224ULL, 0x000fe400078e000eULL,
0x000000ffff257224ULL, 0x000fe400078e000fULL, 0x000000ffff217224ULL, 0x000fe400078e0016ULL,
0x000000ffff227224ULL, 0x000fc400078e0017ULL, 0x00000000000e7805ULL, 0x002fca0000015200ULL,
0x00000400790b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x006fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100e107210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0fULL, 0x003d09001000780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401000780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011411ULL,
0x000000100b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff107224ULL, 0x000fca00000e0611ULL,
0x000000020b0b7819ULL, 0x000fc80000001210ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400790b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000407247824ULL, 0x000fe200078e00ffULL, 0x000000780900720cULL, 0x000fc80003f06070ULL,
0xfffffff0240b7812ULL, 0x000fca00078ec0ffULL, 0x00000080020b7824ULL, 0x000fca00078e020bULL,
0x00f400000b0c7984ULL, 0x0002a20000000c00ULL, 0x000014f000008947ULL, 0x000fea0003800000ULL,
0x00005a0000127b06ULL, 0x000ee20000209000ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fe20003f85070ULL, 0x00000002073a7824ULL, 0x000fe200078e00ffULL,
0x00005a00ff167a12ULL, 0x000fc800078e33ffULL, 0x000000063a3a7812ULL, 0x000fca00078ec0ffULL,
0x000000013a3c7824ULL, 0x000fe200078e0200ULL, 0x0000001200127308ULL, 0x008ee40000001000ULL,
0x0ffffffe12147810ULL, 0x008fcc0007ffe0ffULL, 0x0000001400117305ULL, 0x000ee4000021f000ULL,
0x000000ffff137224ULL, 0x008fc800078e0a11ULL, 0x00005a0013137a24ULL, 0x000fc800078e02ffULL,
0x0000001311157227ULL, 0x000fe200078e0010ULL, 0x0000007b07107211ULL, 0x000fca00078ff0ffULL,
0x0000001015117227ULL, 0x000fc800078e00ffULL, 0x000000ffff137224ULL, 0x000fc800078e0a11ULL,
0x00005a0013127a24ULL, 0x000fe200078e0210ULL, 0x0000000810107810ULL, 0x000fc80007ffe0ffULL,
0x00005a0012007a0cULL, 0x000fe20003f06070ULL, 0x0000001015147227ULL, 0x000fc800078e00ffULL,
0x000000ffff137224ULL, 0x000fc800078e0a14ULL, 0x00005a0013137a24ULL, 0x000fe400078e0210ULL,
0x0000010009107824ULL, 0x000fe400078e027aULL, 0x80005a0012120a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0013007a0cULL, 0x000fe40003f46070ULL, 0x00005a0012007a0cULL, 0x000fe40003f26070ULL,
0x0000001003397217ULL, 0x000fc40007800000ULL, 0x0000000111110810ULL, 0x000fc60007ffe0ffULL,
0x0000000139397824ULL, 0x000fe400078e0a10ULL, 0x0000000174107824ULL, 0x000fe400078e023aULL,
0x80005a0013132a10ULL, 0x000fe40007ffe0ffULL, 0x0000000111111810ULL, 0x000fe20007ffe0ffULL,
0x0000000110127824ULL, 0x040fe200078e0a39ULL, 0x000000391000720cULL, 0x000fe40003f66070ULL,
0x0000001116107207ULL, 0x000fc40006000000ULL, 0x00005a0013007a0cULL, 0x000fe40003f06070ULL,
0x0000001273117217ULL, 0x040fe20003800000ULL, 0x000000013c127824ULL, 0x040fe200078e0a39ULL,
0x0000001073107217ULL, 0x000fe40003800000ULL, 0x00000004ff117819ULL, 0x000fe40000011611ULL,
0x000000393c00720cULL, 0x000fe20003f26070ULL, 0x0000001075527224ULL, 0x000fe200078e02ffULL,
0x0000001273127217ULL, 0x000fc40003800000ULL, 0x000000ff11157207ULL, 0x000fe40001800000ULL,
0x0000000114142810ULL, 0x000fe40007ffe0ffULL, 0x000000ff124f7207ULL, 0x000fe20000800000ULL,
0x0000000152117824ULL, 0x000fe200078e0215ULL, 0x0000000114140810ULL, 0x000fe40007ffe0ffULL,
0x000000524f137211ULL, 0x000fe200078fe0ffULL, 0x0000000211107825ULL, 0x000fe200078e0042ULL,
0x0000001416147207ULL, 0x000fc40006000000ULL, 0x000000103a3b7812ULL, 0x000fe200078efcffULL,
0x0000000213127825ULL, 0x000fe200078e0042ULL, 0x0000001473147217ULL, 0x000fe20003800000ULL,
0x0000000810507981ULL, 0x0046a8000c1e9500ULL, 0x0000000812537981ULL, 0x0002a2000c1e9500ULL,
0x0000001475547224ULL, 0x000fc800078e02ffULL, 0x0000000115157824ULL, 0x000fe200078e0254ULL,
0x000000203a3d7812ULL, 0x000fe200078efcffULL, 0x0000000174107824ULL, 0x008fe200078e023bULL,
0x000000544f177211ULL, 0x000fe200078fe0ffULL, 0x0000000215147825ULL, 0x000fc800078e0042ULL,
0x0000000110127824ULL, 0x042fe200078e0a39ULL, 0x000000391000720cULL, 0x000fe20003f26070ULL,
0x000000013b3e7824ULL, 0x000fe200078e0200ULL, 0x00000008144d7981ULL, 0x0002e2000c1e9500ULL,
0x0000000174467824ULL, 0x000fe200078e023dULL, 0x0000001273127217ULL, 0x000fe20003800000ULL,
0x000000013e107824ULL, 0x000fe400078e0a39ULL, 0x0000000217167825ULL, 0x000fe200078e0042ULL,
0x00000004ff127819ULL, 0x000fc80000011612ULL, 0x000000ff12157207ULL, 0x002fe20000800000ULL,
0x0000000146487824ULL, 0x000fe200078e0a39ULL, 0x000000393e00720cULL, 0x080fe20003f06070ULL,
0x000000013d447824ULL, 0x000fe200078e0200ULL, 0x0000001073107217ULL, 0x040fe20003800000ULL,
0x0000000152117824ULL, 0x000fe200078e0215ULL, 0x0000004873477217ULL, 0x000fe20003800000ULL,
0x0000000816587981ULL, 0x0002e2000c1e9500ULL, 0x000000ff103f7207ULL, 0x000fe20000000000ULL,
0x0000000211107825ULL, 0x000fe200078e0042ULL, 0x000000394600720cULL, 0x000fc40003f26070ULL,
0x00000004ff477819ULL, 0x000fe40000011647ULL, 0x0000000810407981ULL, 0x0002e2000c1e9500ULL,
0x000000303a467812ULL, 0x000fe400078efcffULL, 0x000000ff47497207ULL, 0x000fe20000800000ULL,
0x0000000115157824ULL, 0x000fe200078e0254ULL, 0x000000523f137211ULL, 0x040fe200078fe0ffULL,
0x0000000144107824ULL, 0x002fe200078e0a39ULL, 0x000000543f177211ULL, 0x000fe200078fe0ffULL,
0x0000000152117824ULL, 0x000fe200078e0249ULL, 0x000000394400720cULL, 0x000fc40003f06070ULL,
0x0000001073107217ULL, 0x000fe20003800000ULL, 0x0000000174567824ULL, 0x000fe400078e0246ULL,
0x0000000213127825ULL, 0x000fe200078e0042ULL, 0x000000ff104b7207ULL, 0x000fc60000000000ULL,
0x0000000215147825ULL, 0x100fe200078e0042ULL, 0x0000000812417981ULL, 0x0002e6000c1e9500ULL,
0x0000000217167825ULL, 0x100fe200078e0042ULL, 0x0000000814457981ULL, 0x0002e6000c1e9500ULL,
0x0000000211107825ULL, 0x000fe200078e0042ULL, 0x0000000816487981ULL, 0x0002e6000c1e9500ULL,
0x00000001564e7824ULL, 0x000fe200078e0a39ULL, 0x0000000810477981ULL, 0x0002e2000c1e9500ULL,
0x00000001464c7824ULL, 0x000fe200078e0200ULL, 0x000000524b137211ULL, 0x002fc400078fe0ffULL,
0x0000004e73517217ULL, 0x000fe20003800000ULL, 0x0000000149157824ULL, 0x000fe200078e0254ULL,
0x000000544b177211ULL, 0x000fe200078fe0ffULL, 0x000000014c107824ULL, 0x000fe200078e0a39ULL,
0x000000395600720cULL, 0x080fe40003f26070ULL, 0x00000004ff517819ULL, 0x000fe20000011651ULL,
0x0000000213127825ULL, 0x100fe200078e0042ULL, 0x000000394c00720cULL, 0x000fe40003f06070ULL,
0x0000001073107217ULL, 0x000fe20003800000ULL, 0x0000000215147825ULL, 0x100fe200078e0042ULL,
0x000000ff51557207ULL, 0x000fe20000800000ULL, 0x00000008124a7981ULL, 0x0002e4000c1e9500ULL,
0x0000000217167825ULL, 0x000fe200078e0042ULL, 0x000000ff10517207ULL, 0x000fe20000000000ULL,
0x0000000814497981ULL, 0x0002e8000c1e9500ULL, 0x00000008164e7981ULL, 0x0002e2000c1e9500ULL,
0x0000000152117824ULL, 0x000fe200078e0255ULL, 0x0000005251137211ULL, 0x002fc600078fe0ffULL,
0x0000000211107825ULL, 0x000fc800078e0042ULL, 0x0000000213127825ULL, 0x000fe400078e0042ULL,
0x0000000810107981ULL, 0x0002e2000c1e9500ULL, 0x0000005451157211ULL, 0x000fc600078fe0ffULL,
0x0000000812137981ULL, 0x0002e2000c1e9500ULL, 0x0000000155177824ULL, 0x000fe400078e0254ULL,
0x0000000215147825ULL, 0x000fc800078e0042ULL, 0x0000000217167825ULL, 0x000fe400078e0042ULL,
0x0000000814147981ULL, 0x0002e8000c1e9500ULL, 0x0000000816177981ULL, 0x0002e2000c1e9500ULL,
0xfffffff04f547812ULL, 0x000fe200078ec0ffULL, 0x00000001ff4f7424ULL, 0x000fc800078e00ffULL,
0x0000000139117824ULL, 0x002fc800078e0254ULL, 0x000000013c5a7824ULL, 0x000fe200078e0a11ULL,
0x000000093a127812ULL, 0x000fc800078efcffULL, 0x0000005a4f5a7219ULL, 0x000fe200000006ffULL,
0x0000000112167824ULL, 0x000fe200078e0200ULL, 0xfffffff03f3f7812ULL, 0x000fc600078ec0ffULL,
0x0000000116607824ULL, 0x000fe200078e0a11ULL, 0x000000113a6a7812ULL, 0x040fe400078efcffULL,
0x000000013a527812ULL, 0x040fe400078efcffULL, 0x000000183a687812ULL, 0x040fe400078efcffULL,
0x000000604f607219ULL, 0x000fe200000006ffULL, 0x00000001393f7824ULL, 0x000fe200078e023fULL,
0x000000193a667812ULL, 0x000fe400078efcffULL, 0xfffffff04b4b7812ULL, 0x000fe200078ec0ffULL,
0x000000016a707824ULL, 0x000fc400078e0200ULL, 0x0000000152567824ULL, 0x100fe400078e0200ULL,
0x00000001686e7824ULL, 0x100fe400078e0200ULL, 0x00000001666c7824ULL, 0x000fe400078e0200ULL,
0x0000000139657824ULL, 0x000fe400078e024bULL, 0x000000013e157824ULL, 0x100fe400078e0a3fULL,
0x00000001704b7824ULL, 0x000fc400078e0a3fULL, 0x00000001565c7824ULL, 0x000fe400078e0a11ULL,
0x000000016e597824ULL, 0x100fe400078e0a3fULL, 0x000000016c697824ULL, 0x000fe200078e0a3fULL,
0x000000154f3f7219ULL, 0x040fe400000006ffULL, 0x0000004b4f157219ULL, 0x040fe400000006ffULL,
0x0000005c4f5c7219ULL, 0x040fe400000006ffULL, 0x000000594f4b7219ULL, 0x000fe200000006ffULL,
0x00000001445d7824ULL, 0x000fe200078e0a65ULL, 0x000000213a627812ULL, 0x000fc400078efcffULL,
0xfffffff051517812ULL, 0x000fe400078ec0ffULL, 0x000000694f597219ULL, 0x040fe400000006ffULL,
0x0000005d4f5d7219ULL, 0x000fe200000006ffULL, 0x0000000162647824ULL, 0x000fc800078e0200ULL,
0x00000001645f7824ULL, 0x000fca00078e0a65ULL, 0x0000005f4f5f7219ULL, 0x000fe400000006ffULL,
0x0000541053537816ULL, 0x004fe40000000050ULL, 0x000000083a507812ULL, 0x000fe400078efcffULL,
0x000000535aff7212ULL, 0x000fc6000780c0ffULL, 0x0000000150547824ULL, 0x000fe200078e0200ULL,
0x000000393c00720cULL, 0x000fc60000701470ULL, 0x00000001545e7824ULL, 0x000fe200078e0a11ULL,
0x000000393a00720cULL, 0x000fc800007a1070ULL, 0x0000005e4f5e7219ULL, 0x000fe400000006ffULL,
0xff8000001f1f7808ULL, 0x000fe40002800000ULL, 0x00005410584d7816ULL, 0x008fc8000000004dULL,
0x0000004d5aff7212ULL, 0x080fe4000784c0ffULL, 0x0000004d5eff7212ULL, 0x080fe400078cc0ffULL,
0x0000004d60ff7212ULL, 0x000fe400078ac0ffULL, 0x000000393c00720cULL, 0x080fe40001741470ULL,
0x000000395400720cULL, 0x080fe400037c1470ULL, 0x000000391600720cULL, 0x000fc40002fa1470ULL,
0x000000393a00720cULL, 0x080fe40001741070ULL, 0x000000395000720cULL, 0x080fe400037c1070ULL,
0x000000391200720cULL, 0x000fe40002fa1070ULL, 0xff80000026267808ULL, 0x000fe40001000000ULL,
0xff80000025257808ULL, 0x000fe40003000000ULL, 0xff80000029297808ULL, 0x000fc40002800000ULL,
0x0000541041407816ULL, 0x000fe40000000040ULL, 0x000000535cff7212ULL, 0x080fe4000782c0ffULL,
0x000000535eff7212ULL, 0x080fe4000786c0ffULL, 0x0000541048487816ULL, 0x000fe40000000045ULL,
0x0000005360ff7212ULL, 0x000fe4000788c0ffULL, 0x0000004d5cff7212ULL, 0x000fc4000780c0ffULL,
0x000000403fff7212ULL, 0x040fe4000784c0ffULL, 0x000000483fff7212ULL, 0x080fe400078cc0ffULL,
0x000000484bff7212ULL, 0x000fe400078ac0ffULL, 0x000000395600720cULL, 0x0c0fe40000f21470ULL,
0x000000395600720cULL, 0x080fe40000701470ULL, 0x000000395400720cULL, 0x000fc40001f61470ULL,
0x000000391600720cULL, 0x080fe40002781470ULL, 0x000000393e00720cULL, 0x0c0fe40001741470ULL,
0x000000393e00720cULL, 0x080fe400037c1470ULL, 0x000000396e00720cULL, 0x000fe40002fa1470ULL,
0x000000283a607812ULL, 0x040fe400078efcffULL, 0x000000293a5e7812ULL, 0x000fc400078efcffULL,
0x000000395200720cULL, 0x0c0fe40000f21070ULL, 0x000000395200720cULL, 0x080fe40000701070ULL,
0x000000395000720cULL, 0x080fe40001f61070ULL, 0x000000391200720cULL, 0x080fe40002781070ULL,
0x000000393b00720cULL, 0x0c0fe40001741070ULL, 0x000000393b00720cULL, 0x000fc400037c1070ULL,
0x000000396800720cULL, 0x000fe40002fa1070ULL, 0x000054104a4a7816ULL, 0x000fe40000000047ULL,
0x000054104e4e7816ULL, 0x000fe20000000049ULL, 0x0000000160117824ULL, 0x100fe200078e0200ULL,
0xff8000002c2c7808ULL, 0x000fe20000800000ULL, 0x000000015e577824ULL, 0x000fe200078e0200ULL,
0xff8000001e1e7808ULL, 0x000fe20000000000ULL, 0x00000001394d7824ULL, 0x000fe200078e0251ULL,
0xff8000002d2d7808ULL, 0x000fc40001800000ULL, 0xff80000023237808ULL, 0x000fe40002000000ULL,
0xff80000033337808ULL, 0x000fe40001000000ULL, 0xff80000028287808ULL, 0x000fe40003000000ULL,
0xff8000002a2a7808ULL, 0x000fe40002800000ULL, 0x0000004015ff7212ULL, 0x080fe4000782c0ffULL,
0x000000404bff7212ULL, 0x000fc4000780c0ffULL, 0x0000004059ff7212ULL, 0x000fe4000786c0ffULL,
0x0000004815ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004859ff7212ULL, 0x000fe4000784c0ffULL,
0x0000004a5dff7212ULL, 0x040fe400078cc0ffULL, 0x0000004e5dff7212ULL, 0x000fe200078ac0ffULL,
0x0000000111677824ULL, 0x100fe200078e0a65ULL, 0x000000397000720cULL, 0x0c0fe20000f21470ULL,
0x0000000157657824ULL, 0x000fe200078e0a65ULL, 0x000000397000720cULL, 0x080fe20002781470ULL,
0x000000014c637824ULL, 0x000fe200078e0a4dULL, 0x000000396e00720cULL, 0x000fc40000701470ULL,
0x000000396c00720cULL, 0x0c0fe40001f61470ULL, 0x000000396c00720cULL, 0x080fe40001741470ULL,
0x000000394400720cULL, 0x0c0fe400037c1470ULL, 0x000000394400720cULL, 0x000fe40002fa1470ULL,
0x000000313a5c7812ULL, 0x040fe400078efcffULL, 0x000000383a5a7812ULL, 0x000fc400078efcffULL,
0x000000393a587812ULL, 0x000fe400078efcffULL, 0x000000396a00720cULL, 0x0c0fe40000f21070ULL,
0x000000396a00720cULL, 0x080fe40002781070ULL, 0x000000396800720cULL, 0x080fe40000701070ULL,
0x000000396600720cULL, 0x0c0fe40001f61070ULL, 0x000000396600720cULL, 0x000fc40001741070ULL,
0x000000393d00720cULL, 0x0c0fe400037c1070ULL, 0x000000393d00720cULL, 0x000fe40002fa1070ULL,
0x000000674f677219ULL, 0x040fe400000006ffULL, 0x000000654f657219ULL, 0x040fe400000006ffULL,
0x000000634f637219ULL, 0x000fe400000006ffULL, 0x0000541013107816ULL, 0x000fe20000000010ULL,
0x000000015c557824ULL, 0x100fe200078e0200ULL, 0xff8000002e2e7808ULL, 0x000fe20000800000ULL,
0x000000015a537824ULL, 0x100fe200078e0200ULL, 0xff80000027277808ULL, 0x000fe20002000000ULL,
0x0000000158517824ULL, 0x000fe200078e0200ULL, 0xff8000002f2f7808ULL, 0x000fc40000000000ULL,
0xff80000038387808ULL, 0x000fe40001800000ULL, 0xff80000037377808ULL, 0x000fe40001000000ULL,
0xff80000036367808ULL, 0x000fe40003000000ULL, 0xff8000001d1d7808ULL, 0x000fe40002800000ULL,
0x0000004a5fff7212ULL, 0x080fe4000782c0ffULL, 0x0000004a67ff7212ULL, 0x000fc4000788c0ffULL,
0x0000004a65ff7212ULL, 0x000fe4000780c0ffULL, 0x0000004e5fff7212ULL, 0x080fe4000786c0ffULL,
0x0000004e67ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004e65ff7212ULL, 0x000fe400078cc0ffULL,
0x0000001063ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000155617824ULL, 0x100fe200078e0a4dULL,
0x000000396400720cULL, 0x0c0fe20000f21470ULL, 0x00000001535b7824ULL, 0x100fe200078e0a4dULL,
0x000000396400720cULL, 0x080fe20001f61470ULL, 0x00000001514d7824ULL, 0x000fe200078e0a4dULL,
0x000000391100720cULL, 0x000fc40002781470ULL, 0x000000391100720cULL, 0x080fe40001741470ULL,
0x000000395700720cULL, 0x0c0fe40000701470ULL, 0x000000395700720cULL, 0x080fe400037c1470ULL,
0x000000394c00720cULL, 0x080fe40002fa1470ULL, 0x000000396200720cULL, 0x0c0fe40000f21070ULL,
0x000000396200720cULL, 0x000fc40001f61070ULL, 0x000000396000720cULL, 0x0c0fe40002781070ULL,
0x000000396000720cULL, 0x080fe40001741070ULL, 0x000000395e00720cULL, 0x0c0fe40000701070ULL,
0x000000395e00720cULL, 0x080fe400037c1070ULL, 0x000000394600720cULL, 0x000fe40002fa1070ULL,
0x000000614f617219ULL, 0x000fc400000006ffULL, 0x0000005b4f5b7219ULL, 0x040fe400000006ffULL,
0x0000004d4f4d7219ULL, 0x000fe400000006ffULL, 0x0000541014147816ULL, 0x000fe40000000017ULL,
0xff80000030307808ULL, 0x000fe40000800000ULL, 0xff8000001c1c7808ULL, 0x000fe40001800000ULL,
0xff80000031317808ULL, 0x000fc40002000000ULL, 0xff80000021217808ULL, 0x000fe40001000000ULL,
0xff80000035357808ULL, 0x000fe40000000000ULL, 0xff80000022227808ULL, 0x000fe40003000000ULL,
0xff80000034347808ULL, 0x000fe40002800000ULL, 0x0000001061ff7212ULL, 0x080fe4000782c0ffULL,
0x000000105bff7212ULL, 0x000fc4000786c0ffULL, 0x000000104dff7212ULL, 0x000fe4000788c0ffULL,
0x0000001463ff7212ULL, 0x080fe4000784c0ffULL, 0x0000001461ff7212ULL, 0x080fe4000780c0ffULL,
0x000000145bff7212ULL, 0x080fe400078cc0ffULL, 0x000000144dff7212ULL, 0x000fe400078ac0ffULL,
0x000000394c00720cULL, 0x000fc40001741470ULL, 0x000000395500720cULL, 0x0c0fe40000f21470ULL,
0x000000395500720cULL, 0x080fe40000701470ULL, 0x000000395300720cULL, 0x0c0fe40001f61470ULL,
0x000000395300720cULL, 0x080fe400037c1470ULL, 0x000000395100720cULL, 0x0c0fe40002781470ULL,
0x000000395100720cULL, 0x000fc40002fa1470ULL, 0x000000394600720cULL, 0x080fe40001741070ULL,
0x000000395c00720cULL, 0x0c0fe40000f21070ULL, 0x000000395c00720cULL, 0x080fe40000701070ULL,
0x000000395a00720cULL, 0x0c0fe40001f61070ULL, 0x000000395a00720cULL, 0x080fe400037c1070ULL,
0x000000395800720cULL, 0x000fc40002781070ULL, 0x000000395800720cULL, 0x000fe40002fa1070ULL,
0xff80000032327808ULL, 0x000fe40000800000ULL, 0xff8000002b2b7808ULL, 0x000fe40001800000ULL,
0xff80000020207808ULL, 0x000fe40002000000ULL, 0xff80000018187808ULL, 0x000fe40001000000ULL,
0xff80000019197808ULL, 0x000fc40000000000ULL, 0xff8000001a1a7808ULL, 0x000fe40003000000ULL,
0xff8000001b1b7808ULL, 0x000fc40002800000ULL, 0x0000001f0c00720bULL, 0x004fe20003f1e000ULL,
0x0000001fff147424ULL, 0x000fe200078e00ffULL, 0x000000260d00720bULL, 0x000fe20003f3e000ULL,
0xffffffffff3b7424ULL, 0x000fe200078e00ffULL, 0x0000000c1f117208ULL, 0x000fe40004000000ULL,
0x0000000d260d7208ULL, 0x000fe40004800000ULL, 0x0000002c1100720bULL, 0x000fc40003f1e000ULL,
0x0000001e0d00720bULL, 0x000fe40003f3e000ULL, 0x000000112c0c7208ULL, 0x000fe40004000000ULL,
0x0000000d1e107208ULL, 0x000fe40004800000ULL, 0x0000002d0c00720bULL, 0x000fe40003f1e000ULL,
0x000000251000720bULL, 0x000fe40003f3e000ULL, 0x0000000c2d0c7208ULL, 0x000fc40004000000ULL,
0x0000001025107208ULL, 0x000fe40004800000ULL, 0x000000230c00720bULL, 0x000fe40003f1e000ULL,
0x000000291000720bULL, 0x000fe40003f3e000ULL, 0x0000000c230c7208ULL, 0x000fe40004000000ULL,
0x00000010290d7208ULL, 0x000fe40004800000ULL, 0x000000330c00720bULL, 0x000fc40003f1e000ULL,
0x000000280d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c33117208ULL, 0x000fe40004000000ULL,
0x0000000d280c7208ULL, 0x000fe40004800000ULL, 0x0000002e1100720bULL, 0x000fe40003f1e000ULL,
0x000000270c00720bULL, 0x000fe40003f3e000ULL, 0x000000112e107208ULL, 0x000fc40004000000ULL,
0x0000000c270d7208ULL, 0x000fe40004800000ULL, 0x0000002f1000720bULL, 0x000fe40003f1e000ULL,
0x0000002a0d00720bULL, 0x000fe40003f3e000ULL, 0x000000102f117208ULL, 0x000fe40004000000ULL,
0x0000000d2a0c7208ULL, 0x000fe40004800000ULL, 0x000000381100720bULL, 0x000fc40003f1e000ULL,
0x000000370c00720bULL, 0x000fe40003f3e000ULL, 0x0000001138117208ULL, 0x000fe40004000000ULL,
0x0000000c370c7208ULL, 0x000fe40004800000ULL, 0x000000361100720bULL, 0x000fe40003f1e000ULL,
0x0000001d0c00720bULL, 0x000fe40003f3e000ULL, 0x0000001136117208ULL, 0x000fc40004000000ULL,
0x0000000c1d0d7208ULL, 0x000fe40004800000ULL, 0x000000301100720bULL, 0x000fe40003f1e000ULL,
0x0000001c0d00720bULL, 0x000fe40003f3e000ULL, 0x00000011300c7208ULL, 0x000fe40004000000ULL,
0x0000000d1c107208ULL, 0x000fe40004800000ULL, 0x000000310c00720bULL, 0x000fc40003f1e000ULL,
0x000000211000720bULL, 0x000fe40003f3e000ULL, 0x0000000c310c7208ULL, 0x000fe40004000000ULL,
0x00000010210d7208ULL, 0x000fe40004800000ULL, 0x000000350c00720bULL, 0x000fe40003f1e000ULL,
0x000000220d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c35117208ULL, 0x000fc40004000000ULL,
0x0000000d220d7208ULL, 0x000fe40004800000ULL, 0x000000341100720bULL, 0x000fe40003f1e000ULL,
0x000000180d00720bULL, 0x000fe40003f3e000ULL, 0x0000001134117208ULL, 0x000fe40004000000ULL,
0x0000000d180c7208ULL, 0x000fe40004800000ULL, 0x000000321100720bULL, 0x000fc40003f1e000ULL,
0x000000190c00720bULL, 0x000fe40003f3e000ULL, 0x0000001132107208ULL, 0x000fe40004000000ULL,
0x0000000c190d7208ULL, 0x000fe40004800000ULL, 0x0000002b1000720bULL, 0x000fe40003f1e000ULL,
0x0000001a0d00720bULL, 0x000fe40003f3e000ULL, 0x000000102b117208ULL, 0x000fc40004000000ULL,
0x0000000d1a0c7208ULL, 0x000fe40004800000ULL, 0x000000201100720bULL, 0x000fe40003f1e000ULL,
0x0000001b0c00720bULL, 0x000fe40003f3e000ULL, 0x0000001120127208ULL, 0x000fe40004000000ULL,
0x0000000c1b157208ULL, 0x000fe20004800000ULL, 0x000014627f007947ULL, 0x000fec000b800000ULL,
0x0c401f00120c7f89ULL, 0x0004e400000e0000ULL, 0x0000000c1200720bULL, 0x008fc80003f1e000ULL,
0x000000120c177208ULL, 0x000fe20004000000ULL, 0x000014727f007947ULL, 0x000fea000b800000ULL,
0x0c401f00150c7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0d7f89ULL, 0x000e6800000e0000ULL,
0x0c401f000f127f89ULL, 0x006e6200000e0000ULL, 0x0000000c1500720bULL, 0x008fc40003f1e000ULL,
0x0000000d0e00720bULL, 0x000fe40003f3e000ULL, 0x000000150c107208ULL, 0x000fe40004000000ULL,
0x0000000e0d117208ULL, 0x000fe20004800000ULL, 0x0c201f00170c7f89ULL, 0x000ea200000e0000ULL,
0x000000120f00720bULL, 0x002fc60003f1e000ULL, 0x0c201f00100d7f89ULL, 0x000e6200000e0000ULL,
0x0000000f12397208ULL, 0x000fc60004000000ULL, 0x0c201f0011147f89ULL, 0x000ee800000e0000ULL,
0x0c201f00393a7f89ULL, 0x0002e200000e0000ULL, 0x0000000c1700720bULL, 0x004fe40003f1e000ULL,
0x0000000d1000720bULL, 0x002fe40003f3e000ULL, 0x000000170c0c7208ULL, 0x000fe40004000000ULL,
0x000000141100720bULL, 0x008fc40003f5e000ULL, 0x000000100d0d7208ULL, 0x000fe40004800000ULL,
0x00000011140e7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b0c0f7820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000c24247812ULL, 0x000fe400078ec0ffULL,
0x3fb8aa3b2f167823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b312f7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b0d317820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b2d2d7823ULL, 0x000fe2000001080fULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b25257823ULL, 0x000fe20000010831ULL,
0x3fb8aa3b23237823ULL, 0x000fe2000001080fULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b29297823ULL, 0x000fe20000010831ULL, 0x0000002c00117308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b33337823ULL, 0x000fe2000001080fULL, 0x3fb8aa3b27277823ULL, 0x000fe20000010831ULL,
0x3fb8aa3b2e157823ULL, 0x000fe2000001080fULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b37377823ULL, 0x000fe20000010831ULL,
0x3fb8aa3b38387823ULL, 0x100fe2000001080fULL, 0x0000001f00107308ULL, 0x000e620000000800ULL,
0x3fb8aa3b322c7823ULL, 0x108fe2000001080fULL, 0x3fb8aa3b302e7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b35307823ULL, 0x000fe2000001080fULL, 0x3fb8aa3b21217823ULL, 0x000fe20000010831ULL,
0x3fb8aa3b2b2b7823ULL, 0x000fe2000001080fULL, 0x0000000307ff7812ULL, 0x000fc4000780c0ffULL,
0x0000002d00127308ULL, 0x0023e20000000800ULL, 0x0000003a3900720bULL, 0x004fce0003f3e000ULL,
0x0000002300137308ULL, 0x0004e20000000800ULL, 0x000000101110723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b362d7823ULL, 0x002fcc000001080fULL, 0x00000026001f7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b34237823ULL, 0x004fe2000001080fULL, 0x00000002ff347819ULL, 0x000fe20000011607ULL,
0x3fb8aa3b200f7823ULL, 0x000fe2000001080fULL, 0x3fb8aa3b18207823ULL, 0x000fe40000010831ULL,
0x0000000134187810ULL, 0x040fe40007ffe0ffULL, 0x0000001e001e7308ULL, 0x000ea20000000800ULL,
0x00000004ff267e24ULL, 0x002fe2000f8e00ffULL, 0x000000121312723eULL, 0x008fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008343b7810ULL, 0x000fc40007ffe0ffULL,
0x3f8000002626783eULL, 0x000fe400000010ffULL, 0x0000002500257308ULL, 0x000fe60000000800ULL,
0x000000ffff367224ULL, 0x000fca00078e0026ULL, 0x0000002900327308ULL, 0x0002e20000000800ULL,
0x0000001f1e11723eULL, 0x004fce00000010ffULL, 0x0000003300147308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c297823ULL, 0x002fce0000010831ULL, 0x0000002700337308ULL, 0x0003e20000000800ULL,
0x000000253213723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b1d257823ULL, 0x000fcc0000010831ULL,
0x0000001500157308ULL, 0x000ea20000000800ULL, 0x000000ffff277224ULL, 0x002fce00078e0026ULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x00000026101c723cULL, 0x000b6e00000418ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b22277823ULL, 0x020fe20000010831ULL,
0x000000141514723eULL, 0x004fcc00000010ffULL, 0x0000003800177308ULL, 0x000ea20000000800ULL,
0x000000283315723eULL, 0x002fe200000010ffULL, 0x0000000834337824ULL, 0x000fca00078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee218ULL, 0x0000002a002a7308ULL, 0x000ff00000000800ULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x000000161716723eULL, 0x004fce00000010ffULL,
0x0000002700287308ULL, 0x0005e20000000800ULL, 0x0000002a3717723eULL, 0x002fe200000010ffULL,
0x000000ffff277224ULL, 0x004fcc00078e0026ULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1a2a7823ULL, 0x000fe20000010831ULL, 0x000000ffff377224ULL, 0x000fe200078e0026ULL,
0x00000026141c723cULL, 0x000f6a000004181cULL, 0x0000002e002e7308ULL, 0x000e700000000800ULL,
0x0000002f002f7308ULL, 0x000ff00000000800ULL, 0x0000003000307308ULL, 0x000ea20000000800ULL,
0x0000002d2e18723eULL, 0x002fe200000010ffULL, 0x00000008342e7824ULL, 0x000fcc00078e00ffULL,
0x0000002500257308ULL, 0x000ff00000000800ULL, 0x0000002900327308ULL, 0x0002e20000000800ULL,
0x0000002f301a723eULL, 0x004fe200000010ffULL, 0x0000000834307824ULL, 0x000fc400078e00ffULL,
0x00000008342f7824ULL, 0x000fc800078e00ffULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b19297823ULL, 0x102fe20000010831ULL, 0x3fb8aa3b1b317823ULL, 0x000fe20000010831ULL,
0x000000253219723eULL, 0x008fca00000010ffULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x000000083b327824ULL, 0x000fca00078e00ffULL, 0xfffffff8323b7812ULL, 0x000fe400078ee23bULL,
0x00000021281b723eULL, 0x004fe200000010ffULL, 0x0000002c002c7308ULL, 0x000e620000000800ULL,
0x0000000334217810ULL, 0x000fc80007ffe0ffULL, 0xfffffff8302d7812ULL, 0x000fe200078ee221ULL,
0x00000036181c723cULL, 0x020b62000004181cULL, 0x0000000634217810ULL, 0x000fe20007ffe0ffULL,
0x0000002000277308ULL, 0x0005e60000000800ULL, 0xfffffff830357812ULL, 0x000fe400078ee221ULL,
0x0000000834377824ULL, 0x020fc600078e00ffULL, 0x0000002900287308ULL, 0x0006620000000800ULL,
0x0000000434207810ULL, 0x004fce0007ffe0ffULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0xfffffff82f297812ULL, 0x008fe400078ee220ULL, 0x0000000534207810ULL, 0x000fc80007ffe0ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee220ULL, 0x0000000f00227308ULL, 0x0004e20000000800ULL,
0x000000232c20723eULL, 0x002fe400000010ffULL, 0x000000272821723eULL, 0x000fe200000010ffULL,
0x000000ffff277224ULL, 0x000fe200078e0026ULL, 0x00009000022c7811ULL, 0x000fc600078e58ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x00000002340f7810ULL, 0x004fe20007ffe0ffULL,
0x0000001033337824ULL, 0x100fe400078e022cULL, 0x000000102d2d7824ULL, 0x100fe200078e022cULL,
0xfffffff82e257812ULL, 0x000fe200078ee20fULL, 0x00000008340f7824ULL, 0x040fe200078e00ffULL,
0xffffffff342e7810ULL, 0x000fe20007ffe0ffULL, 0x0000003100317308ULL, 0x000e620000000800ULL,
0x0000002b2222723eULL, 0x008fe200000010ffULL, 0x0000001025257824ULL, 0x000fe200078e022cULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee234ULL, 0x0000001029297824ULL, 0x000fe200078e022cULL,
0xfffffff837377812ULL, 0x000fe200078ee22eULL, 0x000000102f2f7824ULL, 0x000fc400078e022cULL,
0x000000100f0f7824ULL, 0x000fe400078e022cULL, 0x0000000124337824ULL, 0x040fe400078e0233ULL,
0x000000010f0f7824ULL, 0x000fe400078e0224ULL, 0x0000001035357824ULL, 0x100fe200078e022cULL,
0x0000002a3123723eULL, 0x002fe200000010ffULL, 0x0000000124257824ULL, 0x000fe200078e0225ULL,
0x000000100f007388ULL, 0x0003e20000000800ULL, 0x0000001037377824ULL, 0x000fc400078e022cULL,
0x00000001242d7824ULL, 0x040fe200078e022dULL, 0x0000001233007388ULL, 0x0005e20000000800ULL,
0x00000026201c723cULL, 0x000f62000004181cULL, 0x000000103b3b7824ULL, 0x000fe400078e022cULL,
0x0000000124297824ULL, 0x040fe200078e0229ULL, 0x0000001425007388ULL, 0x0005e20000000800ULL,
0x00000001242f7824ULL, 0x000fe200078e022fULL, 0x000000393a0f7208ULL, 0x002fe20004800000ULL,
0x0000000124357824ULL, 0x040fe200078e0235ULL, 0x000000162d007388ULL, 0x0005e20000000800ULL,
0x0000000124377824ULL, 0x000fc400078e0237ULL, 0x0000000124247824ULL, 0x000fe200078e023bULL,
0x0000001829007388ULL, 0x0005e80000000800ULL, 0x0000001a2f007388ULL, 0x0005e80000000800ULL,
0x0000002035007388ULL, 0x0005e80000000800ULL, 0x0000002237007388ULL, 0x0005e20000000800ULL,
0x000000ffff1d7224ULL, 0x020fc600078e001eULL, 0x0000001124007388ULL, 0x0005e80000000800ULL,
0x0004001333007388ULL, 0x0005e80000000800ULL, 0x0004001525007388ULL, 0x0005e80000000800ULL,
0x000400172d007388ULL, 0x0005e80000000800ULL, 0x0004001929007388ULL, 0x0005e80000000800ULL,
0x0004001b2f007388ULL, 0x0005e80000000800ULL, 0x0004002135007388ULL, 0x0005e80000000800ULL,
0x0004002337007388ULL, 0x0005e80000000800ULL, 0x00f0000c0b008388ULL, 0x0005e80000000c00ULL,
0x00f2001c0b008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000007cff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008007cff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010007cff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000109097810ULL, 0x000fe20007ffe0ffULL, 0x000018007cff7f8cULL, 0x0003e6000c80043fULL,
0x000000040900720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffa5f000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0e7807ULL, 0x002fe40004000000ULL, 0x000172d000127802ULL, 0x000fc40000000f00ULL,
0x00000bc000007944ULL, 0x018fea0003c00000ULL, 0xfffeb56000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0e7807ULL, 0x000fe40005000000ULL, 0x0001731000127802ULL, 0x000fc40000000f00ULL,
0x00000b8000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e000eULL,
0xfffeb5c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e002fULL,
0x0001736000137802ULL, 0x000fc40000000f00ULL, 0x00000ae000007944ULL, 0x018fea0003c00000ULL,
0xfffeb6a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e002fULL,
0x000173a000137802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x01afea0003c00000ULL,
0xfffeb7c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000fULL,
0x000173f000137802ULL, 0x000fe20000000f00ULL, 0x000000ffff0e7224ULL, 0x000fc400078e000cULL,
0x00000a5000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000eULL,
0xfffebbd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000fULL,
0x0001744000137802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e000eULL, 0xfffebbb000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0e7807ULL, 0x004fe40004000000ULL, 0x0001749000127802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x008fea0003c00000ULL, 0xfffeea3000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0e7807ULL, 0x000fe40005000000ULL, 0x000174d000127802ULL, 0x000fc40000000f00ULL,
0x000009c000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000eULL,
0xfffeea7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0038ULL,
0x0001752000137802ULL, 0x000fc40000000f00ULL, 0x0000092000007944ULL, 0x008fea0003c00000ULL,
0xfffeeb6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0038ULL,
0x0001756000137802ULL, 0x000fc40000000f00ULL, 0x000008e000007944ULL, 0x00afea0003c00000ULL,
0xfffeec8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000cULL,
0x000175b000137802ULL, 0x000fe20000000f00ULL, 0x000000ffff0e7224ULL, 0x000fc400078e0035ULL,
0x0000089000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000eULL,
0xfffef0b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000cULL,
0x0001760000137802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e000eULL, 0xfffef09000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0e7807ULL, 0x004fe40004000000ULL, 0x0001765000127802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x018fea0003c00000ULL, 0xffff1d4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0e7807ULL, 0x000fe40005000000ULL, 0x0001769000127802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff377224ULL, 0x000fe200078e000eULL,
0xffff1d9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e003aULL,
0x000176e000137802ULL, 0x000fc40000000f00ULL, 0x0000076000007944ULL, 0x018fea0003c00000ULL,
0xffff1e7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e003aULL,
0x0001772000137802ULL, 0x000fc40000000f00ULL, 0x0000072000007944ULL, 0x01afea0003c00000ULL,
0xffff1f9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0009ULL,
0x0001777000137802ULL, 0x000fe20000000f00ULL, 0x000000ffff0e7224ULL, 0x000fc400078e0010ULL,
0x000006d000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000eULL,
0xffff23b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0009ULL,
0x000177c000137802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e000eULL, 0xffff239000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0e7807ULL, 0x004fe40004000000ULL, 0x0001781000127802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x018fea0003c00000ULL, 0xffff509000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0e7807ULL, 0x000fe40005000000ULL, 0x0001785000127802ULL, 0x000fc40000000f00ULL,
0x0000064000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff117224ULL, 0x000fe200078e000eULL,
0xffff50e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000aULL,
0x000178a000137802ULL, 0x000fc40000000f00ULL, 0x000005a000007944ULL, 0x018fea0003c00000ULL,
0xffff51c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e000aULL,
0x000178e000137802ULL, 0x000fc40000000f00ULL, 0x0000056000007944ULL, 0x01afea0003c00000ULL,
0xffff52e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0005ULL,
0x0001793000137802ULL, 0x000fe20000000f00ULL, 0x000000ffff0e7224ULL, 0x000fc400078e000aULL,
0x0000051000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000eULL,
0xffff574000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x000fe200078e0005ULL,
0x0001798000137802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e000eULL, 0xffff572000007947ULL, 0x000fea000383ffffULL,
0x00000002ff137424ULL, 0x000fe200078e00ffULL, 0x000179d000107802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e003aULL,
0xffffeb6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff127224ULL, 0x006fe200078e0015ULL,
0x00017a3000107802ULL, 0x000fe20000000f00ULL, 0x00000002ff137424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x010fea0003c00000ULL, 0x0000003a1500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e000eULL, 0x00017a9000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff137424ULL, 0x000fe200078e00ffULL, 0x000000153a0d7208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x0000003a0e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e000fULL, 0x00017af000107802ULL, 0x000fe20000000f00ULL,
0x00000002ff137424ULL, 0x000fe200078e00ffULL, 0x0000000e3a157208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x0000003a0f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e0017ULL, 0x00017b5000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x0000000f3a397208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x0000003a1700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e000dULL, 0x00017bb000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x000000173a0c7208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x0000003a0d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e0015ULL, 0x00017c1000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x0000000d3a0d7208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x0000003a1500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff127224ULL, 0x002fe200078e0039ULL, 0x00017c7000107802ULL, 0x000fe20000000f00ULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x000000153a0e7208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffea3000007947ULL, 0x000fea000383ffffULL,
0x018000000d007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000000d00008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0dff7812ULL, 0x040fe4000780c0ffULL, 0x800000000d027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000d00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe820002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff117424ULL, 0x000fe200078e00ffULL, 0x0000003b00007348ULL, 0x000fe80003800000ULL,
0x0c000013123a7389ULL, 0x0002a200000e0014ULL, 0xfffe81c010007950ULL, 0x000fea0003c3ffffULL,
0x0000007c00007348ULL, 0x000fe80003800000ULL, 0x0000000e120e7389ULL, 0x0002a400000e007dULL,
0x000000ffff127224ULL, 0x002fc400078e0013ULL, 0x00000000ff137424ULL, 0x000fc800078e00ffULL,
0xfffe817012007950ULL, 0x000fea0003c3ffffULL, 0x000000010e00780cULL, 0x000fe20003f45070ULL,
0x00000000ff137424ULL, 0x000fe200078e00ffULL, 0x0000007a00007348ULL, 0x000ff60003800000ULL,
0x00000000000e7806ULL, 0x000fc800050e0100ULL, 0x0000007a0e0e7212ULL, 0x000fe200078ec0ffULL,
0xfffe811012007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x00000000000002c0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000cb8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d78ULL, 0x00000000000007ccULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001548ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001558ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015e8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015ecULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000017f80ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019780ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000197d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000019b50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000015e8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000018198ULL, 0x0000000000018198ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000019780ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000019b50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_89_cubin_len = 105520;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
