/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b950ULL, 0x000000000001b5d0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x0000000000019a10ULL, 0x0000000000000180ULL, 0x000b0022000004daULL, 0x0000000000019b90ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x0000000000019bd0ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x0000000000019c20ULL, 0x0000000000000160ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000019d80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00019a1000000000ULL, 0x0000040400000000ULL, 0x810c000000100400ULL, 0x0066680408288080ULL,
0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9408288080820828ULL,
0x2880809508288080ULL, 0x80be08288080a808ULL, 0x1628808084082880ULL, 0x0000031028808280ULL,
0x8492000000000000ULL, 0x0000002200288080ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x00019a1000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808084ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x9408288080820828ULL, 0x2880809508288080ULL, 0x80be08288080a808ULL, 0x1628808088082880ULL,
0x0000031028808280ULL, 0x8892000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x0000011800000000ULL, 0x00019b9000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9408288080820828ULL, 0x2880809508288080ULL,
0x80be08288080a808ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080be9200ULL,
0x0000002cffffffffULL, 0x000001a800000000ULL, 0x00019bd000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x8094288080be0900ULL, 0x0000000000002880ULL, 0x00000054ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x9408288080820828ULL, 0x288080a808288080ULL, 0x809508288080be08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080959200ULL, 0x0000002cffffffffULL,
0x0000024000000000ULL, 0x00019c2000000000ULL, 0x0000016000000000ULL, 0x0000080400000000ULL,
0x8094288080950900ULL, 0x0000000000002880ULL, 0x0000001b00082f04ULL, 0x0008230400000080ULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL,
0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL,
0x0008110400000008ULL, 0x000000080000001bULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0068016000000018ULL, 0x000c170400681903ULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0x00000ba000043104ULL, 0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000031001342804ULL, 0x000005b0000003d0ULL, 0x000028f000002860ULL, 0x00002b7000002a10ULL,
0x0000301000002fe0ULL, 0x000030f000003080ULL, 0x00005fa000005f10ULL, 0x00006230000060d0ULL,
0x000066f0000066c0ULL, 0x000067d000006760ULL, 0x000094d000009430ULL, 0x00009750000095f0ULL,
0x00009c0000009bd0ULL, 0x00009ce000009c70ULL, 0x0000ca400000c9a0ULL, 0x0000ccc00000cb60ULL,
0x0000d1b00000d180ULL, 0x0000d2900000d220ULL, 0x0000f4200000f410ULL, 0x00017f4000017f00ULL,
0x00017f6000017f50ULL, 0x00017fd000017fb0ULL, 0x0001800000017ff0ULL, 0x00018d3000018ce0ULL,
0x00018e0000018da0ULL, 0x00018ee000018e70ULL, 0x00018f9000018f40ULL, 0x0001906000019000ULL,
0x00019140000190d0ULL, 0x000191f0000191a0ULL, 0x000192c000019260ULL, 0x000193a000019330ULL,
0x0001945000019400ULL, 0x00019520000194c0ULL, 0x0001960000019590ULL, 0x000196f000019670ULL,
0x000197f000019770ULL, 0x000198f000019870ULL, 0x000199f000019970ULL, 0x0000040004403904ULL,
0x00017600000000ffULL, 0x00000480003f0100ULL, 0x0001760800000011ULL, 0x00000500003f0120ULL,
0x0001768800000011ULL, 0x00000530003f0120ULL, 0x000176a800000011ULL, 0x00000540003f0120ULL,
0x000176c800000011ULL, 0x00000bc0003f0120ULL, 0x00017600000000ffULL, 0x00000db0003f0107ULL,
0x0000000400000004ULL, 0x00000e60003f0102ULL, 0x0000000000000004ULL, 0x00001650003f0101ULL,
0x000176a80000007cULL, 0x00001760003f0107ULL, 0x000176a80000007cULL, 0x000017c0003f0101ULL,
0x000176c800000006ULL, 0x00001930003f0101ULL, 0x000176cc00000009ULL, 0x00001b20003f0105ULL,
0x000176cc00000009ULL, 0x00002490003f0105ULL, 0x000176b0000000ffULL, 0x0000251000050107ULL,
0x000176b0000000ffULL, 0x0000257000050101ULL, 0x0001760800000009ULL, 0x00002590003f0101ULL,
0x0001760c00000009ULL, 0x00002760003f0105ULL, 0x0001760c00000009ULL, 0x00002d40003f0105ULL,
0x000176ac00000014ULL, 0x00002f10003f0105ULL, 0x000176ac00000014ULL, 0x000050f0003f0105ULL,
0x0000000000000012ULL, 0x00005150003f0101ULL, 0x0001768800000068ULL, 0x00005180003f0101ULL,
0x000000040000000aULL, 0x00005340003f0105ULL, 0x000000040000000aULL, 0x00005b60003f0105ULL,
0x000176a800000010ULL, 0x00005bf0003f0107ULL, 0x000176a800000010ULL, 0x00005c50003f0101ULL,
0x0001762800000009ULL, 0x00005c70003f0101ULL, 0x0001762c00000009ULL, 0x00005e40003f0105ULL,
0x0001762c00000009ULL, 0x00006420003f0105ULL, 0x000176b40000003aULL, 0x000065f0003f0105ULL,
0x000176b40000003aULL, 0x000085b0003f0105ULL, 0x0000000000000014ULL, 0x00008610003f0101ULL,
0x0001769000000016ULL, 0x00008640003f0101ULL, 0x000000040000000aULL, 0x00008800003f0105ULL,
0x000000040000000aULL, 0x00009010003f0105ULL, 0x000176b00000007cULL, 0x00009110003f0107ULL,
0x000176b000000016ULL, 0x00009170003f0101ULL, 0x0001764800000009ULL, 0x00009190003f0101ULL,
0x0001764c00000009ULL, 0x00009360003f0105ULL, 0x0001764c00000009ULL, 0x00009930003f0105ULL,
0x000176ac0000003cULL, 0x00009b00003f0105ULL, 0x000176ac0000003cULL, 0x0000bb30003f0105ULL,
0x0000000000000014ULL, 0x0000bb90003f0101ULL, 0x0000000000000003ULL, 0x0000bbc0003f0101ULL,
0x000000040000000aULL, 0x0000bd80003f0105ULL, 0x000000040000000aULL, 0x0000c5b0003f0105ULL,
0x00000000000000ffULL, 0x0000c69000040107ULL, 0x000176a80000007cULL, 0x0000c6f0003f0101ULL,
0x000176680000000aULL, 0x0000c720003f0101ULL, 0x0001766c0000000aULL, 0x0000c8f0003f0105ULL,
0x0001766c0000000aULL, 0x0000ce80003f0105ULL, 0x000176b40000007cULL, 0x0000d0a0003f0105ULL,
0x000176b40000007cULL, 0x0000f1e0003f0105ULL, 0x0000000000000005ULL, 0x0000f260003f0101ULL,
0x0000000000000009ULL, 0x00010650003f0101ULL, 0x00017600000000ffULL, 0x00011f80003f0101ULL,
0x00017604000000ffULL, 0x00012190003f0105ULL, 0x00017604000000ffULL, 0x000123c0003f0105ULL,
0x00017600000000ffULL, 0x000123f0003f0101ULL, 0x00017604000000ffULL, 0x000125b0003f0105ULL,
0x00017604000000ffULL, 0x00016310003f0105ULL, 0x000000000000007aULL, 0x00016380003f0101ULL,
0x000000040000007aULL, 0x00016550003f0105ULL, 0x000000040000007aULL, 0x00018b20003f0105ULL,
0x000000000000007cULL, 0x00018b80003f0101ULL, 0x000000080000007cULL, 0x00018be0003f0101ULL,
0x000000100000007cULL, 0x00018c50003f0101ULL, 0x000000180000007cULL, 0x00053803003f0101ULL,
0x0000fce000201c04ULL, 0x0000ffc00000fd20ULL, 0x000103b0000101b0ULL, 0x0001261000010560ULL,
0x0000040100018ca0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000002b4ULL, 0x0000001b00000002ULL,
0x000000000000021cULL, 0x0000001b00000002ULL, 0x0000000000000194ULL, 0x0000001b00000002ULL,
0x00000000000000ecULL, 0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL,
0x0000000000000291ULL, 0x0000001b00000002ULL, 0x00000000000001f9ULL, 0x0000001b00000002ULL,
0x000000000000016eULL, 0x0000001b00000002ULL, 0x00000000000000c6ULL, 0x0000001b00000002ULL,
0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000087ab9ULL, 0x000fe20000000a00ULL,
0xfffffff801017810ULL, 0x000fe40007ffe0ffULL, 0x00005d00ff007a0cULL, 0x000fda0003f05300ULL,
0x00000004ff060424ULL, 0x000fe200078e00ffULL, 0x0000000103040810ULL, 0x002fca0007ffe0ffULL,
0x00005c0004040625ULL, 0x000fc800078e0006ULL, 0x00005c0003060625ULL, 0x000fe200078e0006ULL,
0x0000000804660981ULL, 0x0002aa000c1e1900ULL, 0x0000000806070981ULL, 0x0006a2000c1e1900ULL,
0x0000590000007b06ULL, 0x000f220000209000ULL, 0x00005900ff7d7624ULL, 0x000fe200078e00ffULL,
0x00005900ff007a0cULL, 0x000fe20003f65070ULL, 0x00000000000f7919ULL, 0x000e680000002300ULL,
0x00000000000d7919ULL, 0x000e680000002100ULL, 0x0000000000067919ULL, 0x008ee20000002600ULL,
0x0000000000007308ULL, 0x010f240000001000ULL, 0x0ffffffe00087810ULL, 0x010fcc0007ffe0ffULL,
0x0000000800097305ULL, 0x000864000021f000ULL, 0x000000ffff087224ULL, 0x010fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x002fc800078e0a09ULL, 0x000059000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b09097227ULL, 0x000fcc00078e0008ULL, 0x00000400090b7a27ULL, 0x000fc800078e00ffULL,
0x000000ffff027224ULL, 0x000fc800078e0a0bULL, 0x0000040002007624ULL, 0x000fca00078e027dULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x8000590000001a10ULL, 0x000fe40007ffe0ffULL,
0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f46070ULL,
0x000000010b0b2810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff0bba12ULL, 0x000fc800078e33ffULL,
0x0000000b00007306ULL, 0x000e620000209000ULL, 0x000000ff0b00720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00047810ULL, 0x002fcc0007ffe0ffULL,
0x0000000400057305ULL, 0x000324000021f000ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000050b027224ULL, 0x010fc800078e02ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a02ULL,
0x0000000000027919ULL, 0x000e640000002200ULL, 0x0000000905057227ULL, 0x000fcc00078e0004ULL,
0x00000006057a7227ULL, 0x008fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a7aULL,
0x000000000b007224ULL, 0x000fca00078e0206ULL, 0x0000000b0000720cULL, 0x000fe20003fa6070ULL,
0x000001000f027a24ULL, 0x002fe400078e0202ULL, 0x00001fff0f0f7589ULL, 0x000fe400000e0000ULL,
0x0000000002117a24ULL, 0x000fca00078e020dULL, 0x000000ff1100720cULL, 0x000fc60003f65270ULL,
0x0000000100005824ULL, 0x000fe200078e0a0bULL, 0x000000017a7a5810ULL, 0x000fe40007ffe0ffULL,
0x0000007f1100780cULL, 0x040fe40003f44070ULL, 0x0000000b0000720cULL, 0x000fe40003fc6070ULL,
0x0000000f1100780cULL, 0x040fe40003f24070ULL, 0x00000005ff007819ULL, 0x000fe4000001160dULL,
0x000000031100780cULL, 0x000fe20003fa4070ULL, 0x3fffff80ff04b424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff05b424ULL, 0x000fe200078e00ffULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0xff317217ff0ea424ULL, 0x000fe400078e00ffULL, 0x000000017a7a6810ULL, 0x000fe20007ffe0ffULL,
0x01760004ff00b388ULL, 0x0007e20000000a00ULL, 0x0000000bff7ac212ULL, 0x000fe200078e33ffULL,
0x3fffffc0ff089424ULL, 0x000fe200078e00ffULL, 0x000000011100780cULL, 0x000fe20003f64070ULL,
0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL, 0x0174000e1100a388ULL, 0x0009e20000004800ULL,
0x000000ffff7b7224ULL, 0x000fc400078e0a7aULL, 0x3fffff80ff0ad424ULL, 0x000fe200078e00ffULL,
0x0176080811009388ULL, 0x000fe20000008a00ULL, 0x0000007b0b7b7224ULL, 0x000fe400078e0206ULL,
0x3fffff60ff04d424ULL, 0x008fe400078e00ffULL, 0x000000107b7b7824ULL, 0x000fe400078e00ffULL,
0x00005a00ff0e7624ULL, 0x010fe400078e00ffULL, 0x7fffff60ff05d424ULL, 0x000fc400078e00ffULL,
0x000059000e0e7a24ULL, 0x000fe400078e02ffULL, 0x7fffff80ff0bd424ULL, 0x000fe200078e00ffULL,
0x017688041100d388ULL, 0x000fe20000008a00ULL, 0x3fffffc0ff0cb424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff0db424ULL, 0x000fe200078e00ffULL, 0x0176a80a1100d388ULL, 0x000fe80000008a00ULL,
0x0176c80c1100b388ULL, 0x000fe20000008a00ULL, 0x0000000166660824ULL, 0x004fc400078e0a07ULL,
0x00005800ff668624ULL, 0x000fe400078e00ffULL, 0x0000580003078a24ULL, 0x000fe400078e02ffULL,
0x00005a0066027a24ULL, 0x000fe400078e02ffULL, 0x0000000e07127224ULL, 0x000fe400078e02ffULL,
0x0000000102067824ULL, 0x040fe200078e0a7bULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000007b0200720cULL, 0x000fe20003f26070ULL, 0x000000040f027824ULL, 0x002fe200078e0200ULL,
0x0000001006067817ULL, 0x000fe20003800000ULL, 0x00005a007a117a24ULL, 0x000fc400078e0212ULL,
0x0000000202097824ULL, 0x000fe200078e00ffULL, 0x000000ff06107207ULL, 0x000fc80000800000ULL,
0x000000101000780cULL, 0x000fe20003f05270ULL, 0x0000001001007387ULL, 0x0003e80000100800ULL,
0x0000041201007387ULL, 0x0003f00000100800ULL, 0x000002c000008947ULL, 0x000fea0003800000ULL,
0x00005a0000067b06ULL, 0x000ea20000209000ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fca0003f45070ULL,
0x0000000600067308ULL, 0x004ea20000001000ULL, 0x00000004ff087819ULL, 0x008fca0000011602ULL,
0x00000001090a7824ULL, 0x000fe200078e0208ULL, 0x0ffffffe06057810ULL, 0x004fcc0007ffe0ffULL,
0x0000000500057305ULL, 0x000ea4000021f000ULL, 0x000000ffff0b7224ULL, 0x004fc800078e0a05ULL,
0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b050b7227ULL, 0x000fc800078e0004ULL,
0x000000017b047824ULL, 0x000fc800078e020aULL, 0x000000040b0b7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a0bULL, 0x00005a000d057a24ULL, 0x000fca00078e0204ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x000000010b0b0810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff0baa12ULL, 0x000fca00078e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a0bULL, 0x00005a0005047a24ULL, 0x000fc800078e0204ULL,
0x0000000111067824ULL, 0x000fe200078e0204ULL, 0x0000000910047217ULL, 0x000fc60007800000ULL,
0x0000000e0b057224ULL, 0x000fe400078e0206ULL, 0x0000001002067824ULL, 0x000fe400078e00ffULL,
0x0000000104097824ULL, 0x000fe400078e0a09ULL, 0x0000010005047825ULL, 0x000fe200078e00ffULL,
0x000000f0060b7812ULL, 0x000fe400078ec0ffULL, 0x000000090800720cULL, 0x000fe20003f06070ULL,
0x000000010a087824ULL, 0x000fe200078e0202ULL, 0x0000000b040b7212ULL, 0x000fe200078efcffULL,
0x000000100a097824ULL, 0x000fc600078e00ffULL, 0x000060000b047a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff009087812ULL, 0x000fe400078ee208ULL, 0x0000610005057a10ULL, 0x000fc60000ffe4ffULL,
0x0000001008097824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0005e2000c101c48ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00005a0000067b06ULL, 0x000ea20000209000ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fca0003f45070ULL,
0x0000000600067308ULL, 0x004ea20000001000ULL, 0x0000000902097211ULL, 0x008fe400078fe0ffULL,
0x0ffffffe06087810ULL, 0x004fca0007ffe0ffULL, 0x0000000800057305ULL, 0x0004e4000021f000ULL,
0x0000000109087824ULL, 0x004fe400078e0202ULL, 0x000000ffff0b7224ULL, 0x008fc800078e0a05ULL,
0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b05057227ULL, 0x000fc800078e0004ULL,
0x000000017b047824ULL, 0x000fe400078e0209ULL, 0x0000001009097824ULL, 0x000fe400078e00ffULL,
0x0000000405057227ULL, 0x000fc600078e00ffULL, 0xfffffff009087812ULL, 0x000fe200078ee208ULL,
0x000000ffff0b7224ULL, 0x000fc800078e0a05ULL, 0x00005a000b067a24ULL, 0x000fe400078e0204ULL,
0x0000001008097824ULL, 0x000fc600078e00ffULL, 0x00005a0006007a0cULL, 0x000fda0003f06070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105050810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe20003f26070ULL, 0x0000001002067824ULL, 0x000fd800078e00ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff05aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff0b7224ULL, 0x000fc800078e0a05ULL, 0x00005a000b047a24ULL, 0x000fe200078e0204ULL,
0x000000f0060b7812ULL, 0x000fc600078ec0ffULL, 0x0000000111047824ULL, 0x000fc800078e0204ULL,
0x0000000e05047224ULL, 0x000fc800078e0204ULL, 0x0000010004047825ULL, 0x000fca00078e00ffULL,
0x0000000b04047212ULL, 0x000fc800078efcffULL, 0x0000600004047a10ULL, 0x000fc80007f1e0ffULL,
0x0000610005057a10ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0005e8000b901c48ULL, 0x0000000000057919ULL, 0x004ea20000000000ULL,
0x0000000000087806ULL, 0x000fe200038e0000ULL, 0x00000004ff467424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000800047300ULL, 0x000eb000000e0000ULL,
0x0000000800097309ULL, 0x000ee20000000000ULL, 0x000000050400720cULL, 0x004fe20003f02070ULL,
0x0000680003047625ULL, 0x000fc800078e0046ULL, 0x000000ffff097224ULL, 0x008fd000078e0a09ULL,
0x01760409ffff038cULL, 0x0005e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01760000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000804707981ULL, 0x000ee2000c1e1900ULL,
0x000000ff0f00720cULL, 0x000fe40003f05270ULL, 0x0000007f70797810ULL, 0x048fe40007ffe0ffULL,
0x000000ff70097810ULL, 0x004fc40007ffe0ffULL, 0x00000007ff797819ULL, 0x000fe40000011679ULL,
0x00000008ff717819ULL, 0x000fca0000011609ULL, 0x0000f87000008947ULL, 0x000fea0003800000ULL,
0x00000003ff5f7819ULL, 0x000fe20000011600ULL, 0xffffffffff0d7424ULL, 0x000fc600078e00ffULL,
0x01ffffff5f5f7812ULL, 0x000fc800078ec0ffULL, 0x000000795f00720cULL, 0x000fda0003f06070ULL,
0x0000000203048824ULL, 0x000fe400078e00ffULL, 0x00006a00ff058624ULL, 0x000fc800078e00ffULL,
0x00006a0004088624ULL, 0x000fe200078e0205ULL, 0x0001768800047811ULL, 0x000fe200078e18ffULL,
0x00000003ff057424ULL, 0x000fe400078e00ffULL, 0x000000015f478824ULL, 0x000fe200078e0208ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040504ff738cULL, 0x0005e20000000000ULL,
0x0000660047468625ULL, 0x000fe200078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000008460d8981ULL, 0x000ee2000c1e1900ULL, 0x000001ff0900780cULL, 0x000fe20003f04070ULL,
0x000000807a6e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011600ULL,
0x0000000004ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001007d7812ULL, 0x000fc600078ec0ffULL,
0x000000200c0a7824ULL, 0x000fca00078e00ffULL, 0x000000606e077812ULL, 0x000fe200078ef80aULL,
0x000059000d057a24ULL, 0x00cfc800078e02ffULL, 0x0000008005197824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x0000000a70047217ULL, 0x002fe20007800000ULL,
0x000000107d057824ULL, 0x000fe200078e00ffULL, 0x00000003ff087819ULL, 0x000fe40000011602ULL,
0x0000640019137a11ULL, 0x000fe200078838ffULL, 0x0000000104047824ULL, 0x000fe200078e0a0aULL,
0x00000004080b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000105097824ULL, 0x000fe200078e0208ULL,
0x0000000c080e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000504047217ULL, 0x000fe20007800000ULL,
0x00000001090a7824ULL, 0x000fe200078e0202ULL, 0x0000650019197a11ULL, 0x000fe200020f3cffULL,
0x00000008090f7824ULL, 0x000fc400078e00ffULL, 0x0000000104047824ULL, 0x000fe400078e0a05ULL,
0x0000000107097824ULL, 0x000fe200078e0209ULL, 0xfffffff80f107812ULL, 0x000fe200078ee20aULL,
0x00000001050f7824ULL, 0x000fe200078e020eULL, 0x00000008080a7810ULL, 0x000fe40007ffe0ffULL,
0x000000040b00720cULL, 0x080fe20003f46070ULL, 0x00000001050b7824ULL, 0x040fe200078e020bULL,
0x000000040a00720cULL, 0x080fe20003f26070ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x000000040800720cULL, 0x080fe20003f66070ULL, 0x000000010b057824ULL, 0x040fe200078e0202ULL,
0x000000040e00720cULL, 0x000fe20003f06070ULL, 0x000000080b127824ULL, 0x000fc400078e00ffULL,
0x000000010a087824ULL, 0x040fe400078e0202ULL, 0x000000080a117824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee205ULL, 0x0000008009047825ULL, 0x000fc600078e00ffULL,
0xfffffff811147812ULL, 0x000fe200078ee208ULL, 0x0000000107087824ULL, 0x040fe200078e020bULL,
0x0000007004047812ULL, 0x000fe200078ef806ULL, 0x00000001070a7824ULL, 0x040fe400078e020aULL,
0x00000001070e7824ULL, 0x000fe200078e020fULL, 0x0000000413047210ULL, 0x000fe20007f9e0ffULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x000000010f077824ULL, 0x040fe200078e0202ULL,
0x0000007008117812ULL, 0x000fe200078ef806ULL, 0x000000080f167824ULL, 0x000fe400078e00ffULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee207ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700a087812ULL, 0x100fe400078ef806ULL,
0x000130000c077811ULL, 0x000fe200078e68ffULL, 0x0000000105057824ULL, 0x000fe200020e0619ULL,
0x000000700e0a7812ULL, 0x000fe400078ef806ULL, 0x0000001311067210ULL, 0x080fe20007f9e0ffULL,
0x0000001010117824ULL, 0x100fe200078e0207ULL, 0x0000001308087210ULL, 0x080fe20007fbe0ffULL,
0x0000001014157824ULL, 0x100fe200078e0207ULL, 0x000000130a0a7210ULL, 0x000fe20007fde0ffULL,
0x0000001012137824ULL, 0x100fe200078e0207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004117faeULL, 0x0003e2000d901c48ULL, 0x0000001016177824ULL, 0x000fc400078e0207ULL,
0x0000000109077824ULL, 0x100fe400020e0619ULL, 0x000000010b097824ULL, 0x100fe400028e0619ULL,
0x000000010f0b7824ULL, 0x000fe200030e0619ULL, 0x0000000006137faeULL, 0x0003e8000d101c48ULL,
0x0000000008157faeULL, 0x0003e8000c901c48ULL, 0x000000000a177faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x000000107d057824ULL, 0x002fe200078e00ffULL,
0x0000640019137a11ULL, 0x000fc400078038ffULL, 0x000130000c177811ULL, 0x000fe400078e68ffULL,
0x0000000502047211ULL, 0x000fe400078fe8ffULL, 0x0000650019197a11ULL, 0x000fe400000f3cffULL,
0x0000000404087810ULL, 0x040fe20007ffe0ffULL, 0x0000000104057824ULL, 0x140fe200078e0202ULL,
0x00000008040a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000804107824ULL, 0x000fe400078e00ffULL,
0x0000000108097824ULL, 0x000fc400078e0202ULL, 0x0000000808127824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x0000000107057824ULL, 0x000fe400078e0204ULL,
0x000000010a0b7824ULL, 0x000fe200078e0202ULL, 0xfffffff812127812ULL, 0x000fe200078ee209ULL,
0x000000080a147824ULL, 0x000fe200078e00ffULL, 0x0000000c04097810ULL, 0x000fe20007ffe0ffULL,
0x0000008005047825ULL, 0x000fc600078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee20bULL,
0x0000000107087824ULL, 0x040fe200078e0208ULL, 0x0000007004047812ULL, 0x000fe200078ef806ULL,
0x00000001070a7824ULL, 0x040fe400078e020aULL, 0x00000001070e7824ULL, 0x000fe200078e0209ULL,
0x0000000413047210ULL, 0x000fe20007f1e0ffULL, 0x0000000109077824ULL, 0x040fe400078e0202ULL,
0x0000000809167824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff816077812ULL, 0x000fe200078ee207ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008117812ULL, 0x000fc600078ef806ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700a087812ULL, 0x000fc600078ef806ULL, 0x0000000105057824ULL, 0x000fe200000e0619ULL,
0x000000700e0a7812ULL, 0x000fe200078ef806ULL, 0x0000001014157824ULL, 0x100fe200078e0217ULL,
0x0000001113067210ULL, 0x040fe20007f1e0ffULL, 0x0000001010117824ULL, 0x100fe200078e0217ULL,
0x0000000813087210ULL, 0x040fe40007f3e0ffULL, 0x0000000a130a7210ULL, 0x000fe20007f5e0ffULL,
0x0000001012137824ULL, 0x100fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004117faeULL, 0x0003e2000b901c48ULL, 0x0000001007177824ULL, 0x000fc400078e0217ULL,
0x0000000109077824ULL, 0x100fe400000e0619ULL, 0x000000010b097824ULL, 0x100fe400008e0619ULL,
0x000000010f0b7824ULL, 0x000fe200010e0619ULL, 0x0000000006137faeULL, 0x0003e8000b901c48ULL,
0x0000000008157faeULL, 0x0003e8000b901c48ULL, 0x000000000a177faeULL, 0x0003e4000b901c48ULL,
0x000000100c7c7824ULL, 0x040fe200078e00ffULL, 0x000000ff7100720cULL, 0x000fe20003f05270ULL,
0x000000080c067824ULL, 0x002fe200078e00ffULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x000000007c0473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x000176a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a8007c047f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176c80006067f8cULL, 0x000ee2000c80043fULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000da3000008947ULL, 0x000fea0003800000ULL, 0x0000000203737824ULL, 0x000fe200078e00ffULL,
0x00000002ff787819ULL, 0x000fe20000011600ULL, 0x00006a00ff047624ULL, 0x004fc400078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0005ULL, 0x00006a0073737624ULL, 0x000fe400078e0204ULL,
0x000000ffff057224ULL, 0x008fe400078e0007ULL, 0xff317217ff047424ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff3b7224ULL, 0x000fc400078e00ffULL,
0x0000000000107805ULL, 0x038fca0000015200ULL, 0x0000000400097824ULL, 0x000fca00078e00ffULL,
0xfffffff809097812ULL, 0x000fca00078ec0ffULL, 0x0176cc00090a7984ULL, 0x000ea40000000800ULL,
0x800000000aff7812ULL, 0x004fe40007804805ULL, 0x000176c8090a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000ff00000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210157210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc80000011413ULL, 0x000000150e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x000000020e0e7819ULL, 0x000fc80000001213ULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0176cc00090e7984ULL, 0x000ea40000000800ULL, 0x800000000eff7812ULL, 0x004fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0x000000010b107810ULL, 0x000fe20007ffe0ffULL,
0x000059000d0d7a24ULL, 0x000fc600078e02ffULL, 0xffffffe0050e7812ULL, 0x000fe200078ec0ffULL,
0x000000800d3d7824ULL, 0x000fe200078e00ffULL, 0x000000711000720cULL, 0x000fc60003f26070ULL,
0x000001000b0e7824ULL, 0x000fca00078e020eULL, 0x000000400e117810ULL, 0x000fc80007ffe0ffULL,
0x0000006011097812ULL, 0x000fca00078ec0ffULL, 0x000000016e367824ULL, 0x000fe200078e0209ULL,
0x0000042000009947ULL, 0x000fea0003800000ULL, 0x00000010050e7812ULL, 0x000fe400078ec0ffULL,
0x0000001170057217ULL, 0x000fe40007800000ULL, 0x00000003ff107819ULL, 0x000fe40000011602ULL,
0x000064003d377a11ULL, 0x000fe200078a38ffULL, 0x0000000105057824ULL, 0x000fe200078e0a11ULL,
0x0000000410137810ULL, 0x040fe20007ffe0ffULL, 0x0000000110097824ULL, 0x040fe200078e020eULL,
0x0000000810157810ULL, 0x000fe20007ffe0ffULL, 0x0000001002117824ULL, 0x000fe200078e00ffULL,
0x0000000e05057217ULL, 0x000fe20007800000ULL, 0x00000001090d7824ULL, 0x000fe200078e0202ULL,
0x000065003d3d7a11ULL, 0x000fe200028f3cffULL, 0x0000000809127824ULL, 0x000fe200078e00ffULL,
0x00000070113f7812ULL, 0x000fe200078ec0ffULL, 0x0000000105057824ULL, 0x000fc600078e0a0eULL,
0xfffffff8120d7812ULL, 0x000fe400078ee20dULL, 0x000000051000720cULL, 0x0c0fe40003f86070ULL,
0x0000000c10107810ULL, 0x000fe40007ffe0ffULL, 0x000000051500720cULL, 0x0c0fe20003f46070ULL,
0x0000000115157824ULL, 0x100fe200078e020eULL, 0x000000051000720cULL, 0x0c0fe20003f06070ULL,
0x0000000110357824ULL, 0x000fe200078e020eULL, 0x000000051300720cULL, 0x000fe20003f66070ULL,
0x0000000136107824ULL, 0x000fc400078e0209ULL, 0x0000000113137824ULL, 0x000fe400078e020eULL,
0x00000001150e7824ULL, 0x040fe400078e0202ULL, 0x0000000815177824ULL, 0x000fe400078e00ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff817097812ULL, 0x000fe200078ee20eULL,
0x0000000113057824ULL, 0x040fe200078e0202ULL, 0x0000003f10107212ULL, 0x000fe200078efcffULL,
0x0000000813127824ULL, 0x000fe400078e00ffULL, 0x0000000136167824ULL, 0x040fe200078e0213ULL,
0x0000001037107210ULL, 0x000fe20007fbe0ffULL, 0x0000000136147824ULL, 0x000fe200078e0235ULL,
0xfffffff812057812ULL, 0x000fe200078ee205ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000000136127824ULL, 0x000fe200078e0215ULL, 0x0000003f16167212ULL, 0x000fe200078efcffULL,
0x00000001350e7824ULL, 0x000fe400078e0202ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000835357824ULL, 0x000fe200078e00ffULL, 0x0000003f12127212ULL, 0x000fe200078efcffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee20eULL,
0x0000000111117824ULL, 0x100fe200028e063dULL, 0x0000003716167210ULL, 0x000fe40007fbe0ffULL,
0x0000003f14147212ULL, 0x000fe400078efcffULL, 0x000140000c0e7811ULL, 0x000fe200078e68ffULL,
0x0000000117177824ULL, 0x000fe200028e063dULL, 0x0000003712127210ULL, 0x080fe40007fbe0ffULL,
0x0000003714147210ULL, 0x000fe20007fde0ffULL, 0x000000100d0d7824ULL, 0x000fc400078e020eULL,
0x0000001005057824ULL, 0x100fe400078e020eULL, 0x0000001009097824ULL, 0x100fe200078e020eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100d7faeULL, 0x0005e2000e101c48ULL,
0x0000000113137824ULL, 0x100fe400028e063dULL, 0x0000001035357824ULL, 0x000fe200078e020eULL,
0x0000000016057faeULL, 0x0005e2000d901c48ULL, 0x0000000115157824ULL, 0x000fc600030e063dULL,
0x0000000012097faeULL, 0x0005e8000d101c48ULL, 0x0000000014357faeULL, 0x0005e2000c101c48ULL,
0x0000035000007947ULL, 0x000fea0003800000ULL, 0x0000001005057812ULL, 0x000fe200078ec0ffULL,
0x0000001002127824ULL, 0x040fe200078e00ffULL, 0x000064003d3f7a11ULL, 0x000fe400078038ffULL,
0x0000000502057211ULL, 0x000fe400078fe8ffULL, 0x0000007012377812ULL, 0x000fc400078ec0ffULL,
0x0000000805137810ULL, 0x040fe20007ffe0ffULL, 0x0000000105097824ULL, 0x140fe200078e0202ULL,
0x00000004050d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000805107824ULL, 0x000fe200078e00ffULL,
0x000065003d3d7a11ULL, 0x000fe200000f3cffULL, 0x0000000113117824ULL, 0x140fe400078e0202ULL,
0x0000000813347824ULL, 0x000fe200078e00ffULL, 0xfffffff810097812ULL, 0x000fe200078ee209ULL,
0x0000000136107824ULL, 0x000fe200078e0205ULL, 0x0000000c05057810ULL, 0x000fe20007ffe0ffULL,
0x000000010d0e7824ULL, 0x000fe200078e0202ULL, 0xfffffff834347812ULL, 0x000fe200078ee211ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x000000080d157824ULL, 0x000fe200078e00ffULL,
0x0000003710107212ULL, 0x000fe200078efcffULL, 0x0000000136127824ULL, 0x040fe400078e020dULL,
0x0000000136147824ULL, 0x040fe200078e0213ULL, 0xfffffff8150e7812ULL, 0x000fe200078ee20eULL,
0x0000000136167824ULL, 0x000fe200078e0205ULL, 0x000000103f107210ULL, 0x000fe20007f1e0ffULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000003712127212ULL, 0x000fc600078efcffULL, 0x00000001050d7824ULL, 0x040fe200078e0202ULL,
0x0000003714147212ULL, 0x080fe200078efcffULL, 0x0000000805367824ULL, 0x000fe400078e00ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x000000143f147210ULL, 0x000fe40007f5e0ffULL,
0xfffffff836357812ULL, 0x000fe200078ee20dULL, 0x0000000111117824ULL, 0x100fe200000e063dULL,
0x0000003716167212ULL, 0x000fe200078efcffULL, 0x0000000115157824ULL, 0x000fe200010e063dULL,
0x000140000c367811ULL, 0x000fc400078e68ffULL, 0x000000123f127210ULL, 0x040fe40007f1e0ffULL,
0x000000163f167210ULL, 0x000fe20007f7e0ffULL, 0x0000001009097824ULL, 0x100fe400078e0236ULL,
0x000000100e057824ULL, 0x100fe400078e0236ULL, 0x0000000113137824ULL, 0x100fe200000e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0005e2000b901c48ULL,
0x00000010340d7824ULL, 0x100fe400078e0236ULL, 0x0000001035357824ULL, 0x000fe200078e0236ULL,
0x0000000012057faeULL, 0x0005e2000b901c48ULL, 0x0000000117177824ULL, 0x000fc600018e063dULL,
0x00000000140d7faeULL, 0x0005e8000b901c48ULL, 0x0000000016357faeULL, 0x0005e4000b901c48ULL,
0x0000000800057824ULL, 0x004fe200078e00ffULL, 0x000000015f107810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0d7424ULL, 0x000fe400078e00ffULL, 0x00000000050573c2ULL, 0x000ea200000e0000ULL,
0x000000791000720cULL, 0x000fe40003f06070ULL, 0x00000010050e7812ULL, 0x000fc400078ec0ffULL,
0xffffffe005097812ULL, 0x040fe400078ec0ffULL, 0x0000000805127812ULL, 0x000fce00078ec0ffULL,
0x0000000173108824ULL, 0x000fe400078e0210ULL, 0x00000004ff118424ULL, 0x000fe200078e00ffULL,
0xfffffff005057892ULL, 0x004fc6000f8ec03fULL, 0x0000660010108625ULL, 0x000fe200078e0011ULL,
0x000176b005067890ULL, 0x000fe2000fffe03fULL, 0x0000000912097210ULL, 0x000fc60007ffe00eULL,
0x00000008100d8981ULL, 0x000528000c1e1900ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176b000ff167f8cULL, 0x000ee2000c800405ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176080009147f8cULL, 0x0002a4000c80043fULL,
0x0000000000107805ULL, 0x004fc40000015200ULL, 0x01760c0009137984ULL, 0x000ea40000000800ULL,
0x8000000013ff7812ULL, 0x004fc40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210357210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc80000011413ULL, 0x000000350e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x000000020e0e7819ULL, 0x000fc80000001213ULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760c0009137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x004fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001002607824ULL, 0x000fe200078e00ffULL,
0x00000001ff777819ULL, 0x000fe20000011602ULL, 0x00000020000e7824ULL, 0x000fc600078e00ffULL,
0x0000007060607812ULL, 0x000fe400078ec0ffULL, 0xffffff800e0e7812ULL, 0x000fe400078ec0ffULL,
0x0000000c77777812ULL, 0x000fc800078ec0ffULL, 0x0000000e770e7210ULL, 0x000fca0007ffe060ULL,
0x017000000e117984ULL, 0x000ea80000000800ULL, 0x017200000e107984ULL, 0x0002e20000000800ULL,
0x000000041100720bULL, 0x004fe20003f1d000ULL, 0x000164527f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x002fc800000e0100ULL, 0x0000ffff3c357812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff127424ULL, 0x000fe400078e00ffULL,
0x000000ffff0e7224ULL, 0x000fd200078e0004ULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000007800720cULL, 0x000fe40003f05270ULL, 0x000000041100720bULL, 0x000fe20003f54000ULL,
0x000164127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000127806ULL, 0x000fc400010e0100ULL,
0x0000008000148824ULL, 0x000fe200078e0260ULL, 0x00000004110e7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x0000000177138824ULL, 0x000fe200078e0214ULL,
0x0000991012147816ULL, 0x000fc800000000ffULL, 0x0174000e13008388ULL, 0x0003e20000000800ULL,
0x000000ff1400720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x000000040e047221ULL, 0x002fe20000010100ULL, 0x000000ff12ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b04047820ULL, 0x000fc80000410000ULL,
0x0000000400137308ULL, 0x000e640000000800ULL, 0x000000130f0f7220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x000fe20000011602ULL,
0x000163527f007947ULL, 0x000fea000b800000ULL, 0x00001f14133c7589ULL, 0x0002a400000e0000ULL,
0x0000003c18187220ULL, 0x084fe40000410000ULL, 0x0000003c19197220ULL, 0x080fe40000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe40000410000ULL, 0x0000003c1d1d7220ULL, 0x080fe40000410000ULL,
0x0000003c20207220ULL, 0x080fe40000410000ULL, 0x0000003c21217220ULL, 0x000fc40000410000ULL,
0x0000003c24247220ULL, 0x080fe40000410000ULL, 0x0000003c25257220ULL, 0x080fe40000410000ULL,
0x0000003c28287220ULL, 0x080fe40000410000ULL, 0x0000003c29297220ULL, 0x080fe40000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000003c2d2d7220ULL, 0x000fc40000410000ULL,
0x0000003c30307220ULL, 0x080fe40000410000ULL, 0x0000003c31317220ULL, 0x080fe40000410000ULL,
0x0000003c38387220ULL, 0x080fe40000410000ULL, 0x0000003c39397220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0012ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802147811ULL, 0x002fe200078ff0ffULL,
0x000162527f007947ULL, 0x000fea000b800000ULL, 0x00001f14133c7589ULL, 0x0002a400000e0000ULL,
0x0000003c1a1a7220ULL, 0x084fe40000410000ULL, 0x0000003c1b1b7220ULL, 0x080fe40000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe40000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe40000410000ULL,
0x0000003c22227220ULL, 0x080fe40000410000ULL, 0x0000003c23237220ULL, 0x000fc40000410000ULL,
0x0000003c26267220ULL, 0x080fe40000410000ULL, 0x0000003c27277220ULL, 0x080fe40000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe40000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe40000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe40000410000ULL, 0x0000003c2f2f7220ULL, 0x000fc40000410000ULL,
0x0000003c32327220ULL, 0x080fe40000410000ULL, 0x0000003c33337220ULL, 0x080fe40000410000ULL,
0x0000003c3a3a7220ULL, 0x080fe40000410000ULL, 0x0000003c3b3b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806012ULL,
0x00000001ff127424ULL, 0x000fd800078e00ffULL, 0x8000000e11110221ULL, 0x000fe20000010000ULL,
0x00007610ff120816ULL, 0x000fc60000000012ULL, 0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL,
0x0000001100080308ULL, 0x000e640000000800ULL, 0x0000000810100220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000f100f7221ULL, 0x008fc40000010000ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0xfffffff005147812ULL, 0x000fca00078ec0ffULL,
0x0176ac0014047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000410137210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e11ULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000001304047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000115157810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac0014047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991012037816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000008ff03723eULL, 0x000fe400000010ffULL, 0x00000002ff047819ULL, 0x000fe40000011602ULL,
0x0000541003037816ULL, 0x000fe20000000003ULL, 0x00015e427f007947ULL, 0x000fea000b800000ULL,
0x00001f0403077589ULL, 0x0002a400000e0000ULL, 0x0000000804147810ULL, 0x000fe20007ffe0ffULL,
0x00015e927f007947ULL, 0x000fea000b800000ULL, 0x00001f1403067589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001004147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e0003ULL, 0x00003090003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x00016b4000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001804147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e0003ULL,
0x00003100003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x004fc400078e00ffULL, 0x00016ad000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000200687824ULL, 0x000fe200078e00ffULL,
0x0000000702107812ULL, 0x000fe200078ec0ffULL, 0x0000020000477824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008024f7812ULL, 0x000fe400078ec0ffULL,
0x0000000468037812ULL, 0x00afe400078ec0ffULL, 0x0000000810487812ULL, 0x000fe400078ef802ULL,
0x0000000302037211ULL, 0x000fc400078fe0ffULL, 0xfffff80047477812ULL, 0x000fe200078ec0ffULL,
0x0000000848047824ULL, 0x040fe400078e00ffULL, 0x00000001486b7824ULL, 0x000fca00078e0203ULL,
0xfffffff804047812ULL, 0x000fca00078ee26bULL, 0x0000001004457824ULL, 0x000fc400078e0247ULL,
0x0000000400037824ULL, 0x000fe200078e00ffULL, 0x00000004ff747819ULL, 0x000fe40000011602ULL,
0x000000104f3c7212ULL, 0x004fe400078efcffULL, 0x0000000403037812ULL, 0x000fe400078ec0ffULL,
0x000130000c6d7811ULL, 0x000fe200078e68ffULL, 0x000000083c057824ULL, 0x000fe200078e00ffULL,
0x000000104f4f7812ULL, 0x000fe200078efe10ULL, 0x0000000174037824ULL, 0x000fe200078e0203ULL,
0xfffffff868687812ULL, 0x000fc600078ec0ffULL, 0x000000013c047824ULL, 0x000fe400078e0203ULL,
0x000000084f107824ULL, 0x000fe400078e00ffULL, 0x0000000103037824ULL, 0x000fe200078e024fULL,
0xfffffff805447812ULL, 0x000fe400078ee204ULL, 0x0000000204047810ULL, 0x000fe40007ffe0ffULL,
0xfffffff810057812ULL, 0x000fe200078ee203ULL, 0x0000001044347824ULL, 0x000fe200078e026dULL,
0x0000000203037810ULL, 0x000fc60007ffe0ffULL, 0x0000001005107824ULL, 0x000fe400078e026dULL,
0x000000003434783bULL, 0x000e680000004200ULL, 0x000000001010783bULL, 0x000ea20000004200ULL,
0x00000018ff3f7819ULL, 0x002fe20000011436ULL, 0x0000003400597306ULL, 0x000fe20000009400ULL,
0x00000018ff3d7819ULL, 0x000fe20000011434ULL, 0x0000010037627824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fc40000011435ULL, 0x00000018ff4d7819ULL, 0x000fe40000011437ULL,
0x00000018ff4e7819ULL, 0x004fe20000011410ULL, 0x0000003f00567306ULL, 0x000fe20000209400ULL,
0x00000018ff6f7819ULL, 0x000fce0000011462ULL, 0x0000003f00497306ULL, 0x000ff00000205400ULL,
0x0000003f00647306ULL, 0x0003f0000020d400ULL, 0x0000003d00437306ULL, 0x000fe20000209400ULL,
0x000000083c3f7824ULL, 0x002fca00078e00ffULL, 0xfffffff83f047812ULL, 0x000fe400078ee204ULL,
0x0000003d005c7306ULL, 0x000e660000205400ULL, 0x00000010043c7824ULL, 0x000fca00078e026dULL,
0x0000003d00537306ULL, 0x0004f0000020d400ULL, 0x00000034005e7306ULL, 0x000ee20000005400ULL,
0x00000100343d7824ULL, 0x004fe200078e00ffULL, 0x0000005c4300720bULL, 0x002fc80003f9d000ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003400507306ULL, 0x0002ae000000d400ULL,
0x0000000153534812ULL, 0x008fe200078efcffULL, 0x0000003e004b7306ULL, 0x000fe20000209400ULL,
0x0001000034347824ULL, 0x002fe200078e00ffULL, 0x0000005e5900720bULL, 0x000fc80003f5d000ULL,
0x00000018ff577819ULL, 0x000fe40000011434ULL, 0x0000003e005a7306ULL, 0x000e6e0000205400ULL,
0x0000000150502812ULL, 0x004fe200078efcffULL, 0x0000003e00527306ULL, 0x0004f0000020d400ULL,
0x0000003d004a7306ULL, 0x000fe20000209400ULL, 0x00000100353e7824ULL, 0x004fe200078e00ffULL,
0x0000005a4b00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff5d7819ULL, 0x000fe4000001143eULL,
0x0000003d00617306ULL, 0x000e6e0000205400ULL, 0x0000000152522812ULL, 0x008fe200078efcffULL,
0x0000003d00677306ULL, 0x0004f0000020d400ULL, 0x0000005700347306ULL, 0x000fe20000209400ULL,
0x000000003c3c783bULL, 0x004ea20000004200ULL, 0x000000614a00720bULL, 0x002fcc0003fbd000ULL,
0x0000005700657306ULL, 0x000e6e0000205400ULL, 0x0000000167675812ULL, 0x008fe200078efcffULL,
0x0000003500147306ULL, 0x000fe60000009400ULL, 0x000000506750723eULL, 0x000fca00000010ffULL,
0x0000003500157306ULL, 0x000ee20000005400ULL, 0x000000653400720bULL, 0x002fce0003f7d000ULL,
0x0000003500517306ULL, 0x0003f0000000d400ULL, 0x0000005700547306ULL, 0x0004a2000020d400ULL,
0x0001000035357824ULL, 0x002fe200078e00ffULL, 0x000000151400720bULL, 0x008fe20003fdd000ULL,
0x000001003d347824ULL, 0x004fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fc4000001143cULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000004d00427306ULL, 0x000fe20000209400ULL,
0x0000010036577824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fc80000011434ULL,
0x00000018ff697819ULL, 0x000fe40000011457ULL, 0x0000004d00417306ULL, 0x000fe20000205400ULL,
0x0000000154543812ULL, 0x000fe400078efcffULL, 0x000000495600720bULL, 0x000fe40003f7d000ULL,
0x0000000151516812ULL, 0x000fc600078efcffULL, 0x0000004d00637306ULL, 0x000ff0000020d400ULL,
0x0000005d004d7306ULL, 0x000fe20000209400ULL, 0x0000000164643812ULL, 0x000fce00078efcffULL,
0x0000005d00667306ULL, 0x000e700000205400ULL, 0x0000003500557306ULL, 0x000ff00000209400ULL,
0x00000035006a7306ULL, 0x000ea20000205400ULL, 0x000000664d00720bULL, 0x002fce0003fbd000ULL,
0x0000004e004c7306ULL, 0x000ff00000209400ULL, 0x0000004e00467306ULL, 0x000fe20000205400ULL,
0x0000006a5500720bULL, 0x004fe40003f9d000ULL, 0x00000018ff557819ULL, 0x000fc4000001143fULL,
0x00000018ff6a7819ULL, 0x000fc60000011412ULL, 0x0000004e00407306ULL, 0x000ff0000020d400ULL,
0x0000005d004e7306ULL, 0x000e70000020d400ULL, 0x00000069005b7306ULL, 0x000ff00000209400ULL,
0x00000069006c7306ULL, 0x000ea20000205400ULL, 0x000000014e4e5812ULL, 0x002fc800078efcffULL,
0x000000514e51723eULL, 0x000fc600000010ffULL, 0x00000037004b7306ULL, 0x000ff00000009400ULL,
0x0000003700567306ULL, 0x000e620000005400ULL, 0x0000006c5b00720bULL, 0x004fe20003fbd000ULL,
0x00010000376c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fc8000001143dULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x0000006f005d7306ULL, 0x000ff00000209400ULL,
0x0000006f00727306ULL, 0x000ea20000205400ULL, 0x000000564b00720bULL, 0x002fe20003f5d000ULL,
0x000100003c4b7824ULL, 0x000fcc00078e00ffULL, 0x0000003500587306ULL, 0x0002f0000020d400ULL,
0x0000003600667306ULL, 0x000fe20000009400ULL, 0x000001003c357824ULL, 0x002fe200078e00ffULL,
0x000000725d00720bULL, 0x004fcc0003fdd000ULL, 0x00000036004d7306ULL, 0x000e620000005400ULL,
0x0000000158584812ULL, 0x008fce00078efcffULL, 0x0000006900577306ULL, 0x0004f0000020d400ULL,
0x0000003c00497306ULL, 0x000fe20000009400ULL, 0x00000018ff697819ULL, 0x004fe40000011435ULL,
0x0000004d6600720bULL, 0x002fc40003f9d000ULL, 0x00000018ff4d7819ULL, 0x000fc6000001144bULL,
0x0000003c005a7306ULL, 0x000e620000005400ULL, 0x0000000157575812ULL, 0x008fce00078efcffULL,
0x0000006f00627306ULL, 0x000eb0000020d400ULL, 0x0000006900437306ULL, 0x000fe20000209400ULL,
0x0000005a4900720bULL, 0x002fce0003fbd000ULL, 0x00000069004a7306ULL, 0x000e620000205400ULL,
0x0000000162626812ULL, 0x004fce00078efcffULL, 0x0000006100347306ULL, 0x000ff00000209400ULL,
0x0000006100357306ULL, 0x000fe20000205400ULL, 0x0000004a4300720bULL, 0x002fce0003fdd000ULL,
0x00000061005c7306ULL, 0x000ff0000020d400ULL, 0x0000003700657306ULL, 0x000e70000000d400ULL,
0x0000003c00617306ULL, 0x000eb0000000d400ULL, 0x0000004d004b7306ULL, 0x000fe20000209400ULL,
0x0000000165652812ULL, 0x002fc400078efcffULL, 0x000000353400720bULL, 0x000fca0003f5d000ULL,
0x0000004d003c7306ULL, 0x000e620000205400ULL, 0x0000000161615812ULL, 0x004fce00078efcffULL,
0x00000069005e7306ULL, 0x000ea2000020d400ULL, 0x000000015c5c2812ULL, 0x000fce00078efcffULL,
0x0000003d00567306ULL, 0x000fe20000009400ULL, 0x0000003c4b00720bULL, 0x002fce0003fbd000ULL,
0x0000003d00497306ULL, 0x000e620000005400ULL, 0x000000015e5e6812ULL, 0x004fce00078efcffULL,
0x0000003600697306ULL, 0x0004f0000000d400ULL, 0x0000003d005d7306ULL, 0x000ee2000000d400ULL,
0x0001000036367824ULL, 0x004fe200078e00ffULL, 0x000000495600720bULL, 0x002fc40003fdd000ULL,
0x00000018ff567819ULL, 0x000fe4000001143eULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000004d005a7306ULL, 0x000e62000020d400ULL, 0x0000000169694812ULL, 0x008fe400078efcffULL,
0x000000414200720bULL, 0x000fe40003f9d000ULL, 0x00000018ff417819ULL, 0x000fc60000011411ULL,
0x0000005b00347306ULL, 0x000fe20000209400ULL, 0x000000015d5d6812ULL, 0x000fce00078efcffULL,
0x0000003600357306ULL, 0x000fe20000209400ULL, 0x000000015a5a5812ULL, 0x002fe400078efcffULL,
0x0000000163634812ULL, 0x000fca00078efcffULL, 0x00000036004a7306ULL, 0x000e700000205400ULL,
0x0000005b004b7306ULL, 0x000eb00000205400ULL, 0x0000003600667306ULL, 0x0006e2000020d400ULL,
0x0000004a3500720bULL, 0x002fc40003fdd000ULL, 0x0000004b3400720bULL, 0x004fca0003fbd000ULL,
0x0000007500147306ULL, 0x000fe20000209400ULL, 0x011000004534783bULL, 0x008e6a0000000200ULL,
0x0000000166666812ULL, 0x000fe400078efcffULL, 0x0000007500157306ULL, 0x000eb00000205400ULL,
0x0000007500597306ULL, 0x000ee2000020d400ULL, 0x000000151400720bULL, 0x004fce0003f5d000ULL,
0x00000055003c7306ULL, 0x000ff00000205400ULL, 0x0000005500157306ULL, 0x000ea20000209400ULL,
0x0000000159592812ULL, 0x008fce00078efcffULL, 0x0000005600147306ULL, 0x000fe20000209400ULL,
0x0000000734348231ULL, 0x082fe400003400ffULL, 0x0000000736368231ULL, 0x000fe400003400ffULL,
0x0000000635358231ULL, 0x080fe400003400ffULL, 0x0000000637378231ULL, 0x000fe200003400ffULL,
0x0000005600497306ULL, 0x000e620000205400ULL, 0x0000003c1500720bULL, 0x004fe40003fdd000ULL,
0x00000018ff3c7819ULL, 0x000fc60000011413ULL, 0x000000503418723cULL, 0x000fe40000041818ULL,
0x0000006c004d7306ULL, 0x000ff00000209400ULL, 0x0000006c004a7306ULL, 0x000ea20000205400ULL,
0x000000491400720bULL, 0x002fce0003f5d000ULL, 0x0000006a00497306ULL, 0x000ff00000209400ULL,
0x0000006a004b7306ULL, 0x000fe20000205400ULL, 0x0000004a4d00720bULL, 0x004fce0003f7d000ULL,
0x0000006a00157306ULL, 0x0003f0000020d400ULL, 0x0000003c004d7306ULL, 0x000fe20000209400ULL,
0x000100003d6a7824ULL, 0x002fe200078e00ffULL, 0x00000058523d723eULL, 0x000fe200000010ffULL,
0x000001003e527824ULL, 0x000fc600078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x0000003c004a7306ULL, 0x000ff00000205400ULL, 0x0000003c00147306ULL, 0x0003f0000020d400ULL,
0x0000006c00677306ULL, 0x0004e2000020d400ULL, 0x00000054533c723eULL, 0x002fce00000010ffULL,
0x0000003c341c723cULL, 0x000b62000004181cULL, 0x00000018ff6c7819ULL, 0x004fe20000011452ULL,
0x0000006a004e7306ULL, 0x000fea0000209400ULL, 0x00000100103c7824ULL, 0x060fe200078e00ffULL,
0x0000000167673812ULL, 0x008fe400078efcffULL, 0x0000006c00527306ULL, 0x000fe40000209400ULL,
0x00000018ff6f7819ULL, 0x000fe2000001143cULL, 0x00010000103c7824ULL, 0x000fca00078e00ffULL,
0x0000006c003d7306ULL, 0x000e620000205400ULL, 0x00000018ff727819ULL, 0x000fe4000001143cULL,
0x00000069573c723eULL, 0x000fca00000010ffULL, 0x0000006a00507306ULL, 0x000ea20000205400ULL,
0x0000003d5200720bULL, 0x002fce0003f9d000ULL, 0x0000005b005b7306ULL, 0x000e62000020d400ULL,
0x00000065623d723eULL, 0x000fe400000010ffULL, 0x000000504e00720bULL, 0x004fca0003f7d000ULL,
0x0000003c3420723cULL, 0x000be20000041820ULL, 0x0000006a00657306ULL, 0x000eac000020d400ULL,
0x00000066643c723eULL, 0x020fe200000010ffULL, 0x000001003f647824ULL, 0x000fe200078e00ffULL,
0x00000067633d723eULL, 0x000fe200000010ffULL, 0x0000003e00697306ULL, 0x000fe20000009400ULL,
0x000000015b5b5812ULL, 0x002fc400078efcffULL, 0x00000018ff647819ULL, 0x000fc60000011464ULL,
0x0000003c3424723cULL, 0x000be20000041824ULL, 0x0000000165653812ULL, 0x004fe200078efcffULL,
0x0000003e00667306ULL, 0x000e6a0000005400ULL, 0x0000005d5c3d723eULL, 0x020fc600000010ffULL,
0x0000006400677306ULL, 0x000ff00000209400ULL, 0x00000064003c7306ULL, 0x000ea20000205400ULL,
0x000000666900720bULL, 0x002fe20003f7d000ULL, 0x000100003e697824ULL, 0x000fca00078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0000003e00637306ULL, 0x000e62000000d400ULL,
0x0000003c6700720bULL, 0x004fce0003fbd000ULL, 0x0000003f00667306ULL, 0x000fe20000009400ULL,
0x000000615e3c723eULL, 0x000fe400000010ffULL, 0x0000000163633812ULL, 0x002fca00078efcffULL,
0x0000003f00677306ULL, 0x000e620000005400ULL, 0x0000003c3428723cULL, 0x000b6e0000041828ULL,
0x0000006c00627306ULL, 0x0004e2000020d400ULL, 0x000000655b3d723eULL, 0x020fe400000010ffULL,
0x0000005a593c723eULL, 0x000fca00000010ffULL, 0x00000069003e7306ULL, 0x000fe20000209400ULL,
0x000000676600720bULL, 0x002fe20003f7d000ULL, 0x000100003f677824ULL, 0x000fe200078e00ffULL,
0x0000003c342c723cULL, 0x000b62000004182cULL, 0x00000100116c7824ULL, 0x004fc600078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x00000069006a7306ULL, 0x000e620000205400ULL,
0x0000000162624812ULL, 0x008fe400078efcffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x00000063623c723eULL, 0x020fc600000010ffULL, 0x0000003f00657306ULL, 0x0004e2000000d400ULL,
0x0000006a3e00720bULL, 0x002fce0003f9d000ULL, 0x00000067005b7306ULL, 0x000fe20000209400ULL,
0x00010000113f7824ULL, 0x004fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000067006a7306ULL, 0x000e620000205400ULL, 0x0000000165653812ULL, 0x008fce00078efcffULL,
0x0000006400647306ULL, 0x000eb0000020d400ULL, 0x0000005600567306ULL, 0x000ee2000020d400ULL,
0x0000006a5b00720bULL, 0x002fce0003f7d000ULL, 0x0000005500557306ULL, 0x000e62000020d400ULL,
0x0000000164645812ULL, 0x004fc800078efcffULL, 0x00000065643d723eULL, 0x000fc600000010ffULL,
0x00000069003e7306ULL, 0x000ea2000020d400ULL, 0x0000000156562812ULL, 0x008fc600078efcffULL,
0x0000003c3430723cULL, 0x000b680000041830ULL, 0x0000006700667306ULL, 0x000ee2000020d400ULL,
0x0000000155556812ULL, 0x002fce00078efcffULL, 0x0000001100617306ULL, 0x000fe20000009400ULL,
0x000000013e3e4812ULL, 0x004fc800078efcffULL, 0x0000003e563c723eULL, 0x020fe200000010ffULL,
0x000000084f3e7824ULL, 0x000fe400078e00ffULL, 0x0000001100597306ULL, 0x000e620000005400ULL,
0x0000000166663812ULL, 0x008fe400078efcffULL, 0xfffffff83e037812ULL, 0x000fe400078ee203ULL,
0x00000066553d723eULL, 0x000fc600000010ffULL, 0x00000011005a7306ULL, 0x0004e8000000d400ULL,
0x0000003c3438723cULL, 0x000b680000041838ULL, 0x0000001200347306ULL, 0x020fe20000009400ULL,
0x0000010012117824ULL, 0x044fe200078e00ffULL, 0x000000596100720bULL, 0x002fe20003fdd000ULL,
0x0001000012377824ULL, 0x000fc400078e00ffULL, 0x00000010033c7824ULL, 0x000fe200078e026dULL,
0x00000018ff657819ULL, 0x000fe20000011411ULL, 0x0000010013117824ULL, 0x000fe200078e00ffULL,
0x0000001000517306ULL, 0x000fe20000009400ULL, 0x00000018ff377819ULL, 0x000fc60000011437ULL,
0x00000018ff697819ULL, 0x000fc60000011411ULL, 0x000000015a5a6812ULL, 0x008fe200078efcffULL,
0x0000001200117306ULL, 0x000e700000005400ULL, 0x0000001000537306ULL, 0x000eb00000005400ULL,
0x0000006500647306ULL, 0x000fe20000209400ULL, 0x000000113400720bULL, 0x002fe20003fbd000ULL,
0x000000040c117824ULL, 0x000fca00078e0274ULL, 0x0000000211117810ULL, 0x000fe20007ffe048ULL,
0x0000006500557306ULL, 0x000fe20000205400ULL, 0x000000535100720bULL, 0x004fce0003f9d000ULL,
0x00000065004f7306ULL, 0x000ff0000020d400ULL, 0x0000001200657306ULL, 0x0002b0000000d400ULL,
0x0000006f00547306ULL, 0x000fe20000209400ULL, 0x0001000013127824ULL, 0x002fca00078e00ffULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x0000006f00527306ULL, 0x000e620000205400ULL,
0x0000000165655812ULL, 0x004fce00078efcffULL, 0x0000003f00627306ULL, 0x000ff00000209400ULL,
0x0000003f005b7306ULL, 0x000ea20000205400ULL, 0x000000525400720bULL, 0x002fce0003f7d000ULL,
0x0000003f00637306ULL, 0x0002f0000020d400ULL, 0x0000006f00507306ULL, 0x000ee2000020d400ULL,
0x000000003c3c783bULL, 0x002e620000004200ULL, 0x0000005b6200720bULL, 0x004fcc0003fdd000ULL,
0x0000006c005e7306ULL, 0x000fee0000209400ULL, 0x0000000163636812ULL, 0x008fe200078efcffULL,
0x0000006c005d7306ULL, 0x000fe20000205400ULL, 0x0000000150503812ULL, 0x000fe400078efcffULL,
0x000000464c00720bULL, 0x000fc40003f7d000ULL, 0x000000556400720bULL, 0x000fc60003fdd000ULL,
0x0000006c005c7306ULL, 0x000ff0000020d400ULL, 0x0000001300357306ULL, 0x000fe20000009400ULL,
0x0000000140403812ULL, 0x000fe400078efcffULL, 0x000000014f4f6812ULL, 0x000fca00078efcffULL,
0x0000001300367306ULL, 0x000ea20000005400ULL, 0x00000018ff597819ULL, 0x002fe4000001143dULL,
0x00000018ff747819ULL, 0x000fca000001143eULL, 0x00000012006c7306ULL, 0x000ff00000209400ULL,
0x00000012006f7306ULL, 0x000fe20000205400ULL, 0x000000363500720bULL, 0x004fce0003f5d000ULL,
0x0000001200517306ULL, 0x0003f0000020d400ULL, 0x00000010004e7306ULL, 0x000ea2000000d400ULL,
0x0000000848127824ULL, 0x002fca00078e00ffULL, 0xfffffff812127812ULL, 0x000fe400078ee211ULL,
0x0000007200587306ULL, 0x000fe60000209400ULL, 0x0000001012117824ULL, 0x000fca00078e0247ULL,
0x0000007200577306ULL, 0x000e620000205400ULL, 0x000000014e4e4812ULL, 0x004fce00078efcffULL,
0x0000003700617306ULL, 0x000ff00000209400ULL, 0x00000037006a7306ULL, 0x000fe20000205400ULL,
0x000000575800720bULL, 0x002fce0003f9d000ULL, 0x0000003700527306ULL, 0x0003f0000020d400ULL,
0x0000007200107306ULL, 0x000ea2000020d400ULL, 0x011000001134783bULL, 0x002e6e0000000200ULL,
0x0000004100437306ULL, 0x000ff00000209400ULL, 0x0000004100427306ULL, 0x000ee20000205400ULL,
0x0000000110104812ULL, 0x004fc400078efcffULL, 0x0000005d5e00720bULL, 0x000fe40003f9d000ULL,
0x00000018ff5d7819ULL, 0x000fe4000001143fULL, 0x000000104040723eULL, 0x000fe200000010ffULL,
0x0000004100417306ULL, 0x000eb0000020d400ULL, 0x0000006900667306ULL, 0x000fe20000209400ULL,
0x000000424300720bULL, 0x008fe20003f7d000ULL, 0x000001003c437824ULL, 0x000fe200078e00ffULL,
0x000000015c5c4812ULL, 0x000fc400078efcffULL, 0x0000004b4900720bULL, 0x000fe40003f9d000ULL,
0x00000018ff4b7819ULL, 0x000fe20000011443ULL, 0x0000006900677306ULL, 0x000ee20000205400ULL,
0x0000000734348231ULL, 0x082fe200003400ffULL, 0x000001003d437824ULL, 0x000fe200078e00ffULL,
0x0000000736368231ULL, 0x000fe400003400ffULL, 0x0000000635358231ULL, 0x080fe200003400ffULL,
0x0000000141413812ULL, 0x004fe200078efcffULL, 0x0000000637378231ULL, 0x000fe200003400ffULL,
0x0000005900577306ULL, 0x000fe20000209400ULL, 0x0000004a4d00720bULL, 0x000fc40003f1d000ULL,
0x00000018ff5b7819ULL, 0x000fe40000011443ULL, 0x0000000115154812ULL, 0x000fe400078efcffULL,
0x000000634141723eULL, 0x000fe200000010ffULL, 0x0000005900587306ULL, 0x000fe20000205400ULL,
0x000000676600720bULL, 0x008fca0003f7d000ULL, 0x0000000114140812ULL, 0x000fe200078efcffULL,
0x00000040341c723cULL, 0x000f62000004181cULL, 0x0000005900467306ULL, 0x000ff0000020d400ULL,
0x0000003c00597306ULL, 0x000ff00000009400ULL, 0x0000003c005e7306ULL, 0x000e700000005400ULL,
0x0000006900567306ULL, 0x000eb0000020d400ULL, 0x0000001300537306ULL, 0x0006a2000000d400ULL,
0x0000005e5900720bULL, 0x002fe20003fdd000ULL, 0x000100003c597824ULL, 0x000fcc00078e00ffULL,
0x0000004b00767306ULL, 0x000fe20000209400ULL, 0x00000018ff137819ULL, 0x008fe4000001143cULL,
0x0000000156563812ULL, 0x004fe400078efcffULL, 0x0000006a6100720bULL, 0x000fc60003f7d000ULL,
0x0000004b00757306ULL, 0x000e620000205400ULL, 0x0000000153532812ULL, 0x000fe400078efcffULL,
0x0000006f6c00720bULL, 0x000fca0003f5d000ULL, 0x0000004b00497306ULL, 0x000ea4000020d400ULL,
0x0000000152523812ULL, 0x000fcc00078efcffULL, 0x0000003d004a7306ULL, 0x000fe20000009400ULL,
0x000000757600720bULL, 0x002fe40003f9d000ULL, 0x0000000151512812ULL, 0x000fc800078efcffULL,
0x000000511451723eULL, 0x000fe200000010ffULL, 0x0000003d004b7306ULL, 0x000e6c0000005400ULL,
0x0000000149494812ULL, 0x004fe400078efcffULL, 0x0000001300697306ULL, 0x000ff00000209400ULL,
0x0000001300727306ULL, 0x000ea20000205400ULL, 0x0000004b4a00720bULL, 0x002fe20003fbd000ULL,
0x000100003d4a7824ULL, 0x000fcc00078e00ffULL, 0x00000013004c7306ULL, 0x000e70000020d400ULL,
0x0000005d00477306ULL, 0x000fe20000209400ULL, 0x000000726900720bULL, 0x004fce0003f7d000ULL,
0x0000005d00427306ULL, 0x000fec0000205400ULL, 0x000000014c4c3812ULL, 0x002fe400078efcffULL,
0x0000005d00137306ULL, 0x0003f0000020d400ULL, 0x0000007400487306ULL, 0x000fe20000209400ULL,
0x00000018ff5d7819ULL, 0x002fce0000011459ULL, 0x0000007400547306ULL, 0x000e700000205400ULL,
0x0000007400127306ULL, 0x000eb0000020d400ULL, 0x0000005d00667306ULL, 0x000fe20000209400ULL,
0x000000544800720bULL, 0x002fce0003f7d000ULL, 0x0000005d00677306ULL, 0x000e6c0000205400ULL,
0x0000000112123812ULL, 0x004fe400078efcffULL, 0x0000005b00747306ULL, 0x000ff00000209400ULL,
0x0000005b004d7306ULL, 0x000ea20000205400ULL, 0x000000676600720bULL, 0x002fe20003f1d000ULL,
0x000100003e667824ULL, 0x000fca00078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000003d00557306ULL, 0x0002f0000000d400ULL, 0x0000005b00437306ULL, 0x000ee2000020d400ULL,
0x000001003e3d7824ULL, 0x002fe200078e00ffULL, 0x0000004d7400720bULL, 0x004fc80003f5d000ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c005b7306ULL, 0x0002a2000000d400ULL,
0x0000000155555812ULL, 0x008fe400078efcffULL, 0x000000585700720bULL, 0x000fca0003fbd000ULL,
0x0000003e00617306ULL, 0x000fe20000009400ULL, 0x00000018ff3c7819ULL, 0x002fe4000001144aULL,
0x0000000143432812ULL, 0x000fc800078efcffULL, 0x000000554343723eULL, 0x000fe200000010ffULL,
0x0000003e00697306ULL, 0x000e620000005400ULL, 0x000000015b5b6812ULL, 0x004fe400078efcffULL,
0x0000000146465812ULL, 0x000fca00078efcffULL, 0x0000005d00597306ULL, 0x000eb0000020d400ULL,
0x0000003c00627306ULL, 0x000fe20000209400ULL, 0x000000696100720bULL, 0x002fce0003f9d000ULL,
0x0000003c00647306ULL, 0x000e620000205400ULL, 0x0000000159590812ULL, 0x004fc800078efcffULL,
0x000000594c14723eULL, 0x000fc600000010ffULL, 0x0000003c004a7306ULL, 0x0004f0000020d400ULL,
0x0000003d005d7306ULL, 0x000fe20000209400ULL, 0x0000004e503c723eULL, 0x004fe200000010ffULL,
0x000001003f4e7824ULL, 0x000fe200078e00ffULL, 0x000000646200720bULL, 0x002fc80003f5d000ULL,
0x00000018ff6c7819ULL, 0x000fe2000001144eULL, 0x0000003d005e7306ULL, 0x000e700000205400ULL,
0x0000003d004b7306ULL, 0x000462000020d400ULL, 0x000000014a4a2812ULL, 0x008fc400078efcffULL,
0x000000424700720bULL, 0x000fe40003f5d000ULL, 0x0000005b4942723eULL, 0x000fc600000010ffULL,
0x0000003e004e7306ULL, 0x000ee2000000d400ULL, 0x0000005a5c3d723eULL, 0x004fe400000010ffULL,
0x0000005e5d00720bULL, 0x002fe20003f1d000ULL, 0x000000423428723cULL, 0x000f680000041828ULL,
0x0000003f00507306ULL, 0x000fe20000009400ULL, 0x0000000113132812ULL, 0x000fc600078efcffULL,
0x0000003c3418723cULL, 0x000b680000041818ULL, 0x0000003f006a7306ULL, 0x000e620000005400ULL,
0x000000014b4b0812ULL, 0x000fe400078efcffULL, 0x000100003f3c7824ULL, 0x020fe200078e00ffULL,
0x00000053563d723eULL, 0x000fe400000010ffULL, 0x000000014e4e4812ULL, 0x008fc400078efcffULL,
0x0000003f003e7306ULL, 0x0004e4000000d400ULL, 0x0000004e4b4c723eULL, 0x000fcc00000010ffULL,
0x0000006600617306ULL, 0x000fe20000209400ULL, 0x00000018ff3f7819ULL, 0x004fe4000001143cULL,
0x000000654f3c723eULL, 0x000fe400000010ffULL, 0x0000006a5000720bULL, 0x002fe40003fdd000ULL,
0x000000521550723eULL, 0x000fe200000010ffULL, 0x0000006600107306ULL, 0x000e620000205400ULL,
0x0000004a4615723eULL, 0x000fe200000010ffULL, 0x0000003c3420723cULL, 0x040b6c0000041820ULL,
0x0000006c005c7306ULL, 0x000fe40000209400ULL, 0x000000013e3e6812ULL, 0x008fe200078efcffULL,
0x000000503424723cULL, 0x000f6a0000041824ULL, 0x0000006c005a7306ULL, 0x000ea20000205400ULL,
0x000000106100720bULL, 0x002fc40003f1d000ULL, 0x00000014342c723cULL, 0x000f6a000004182cULL,
0x0000003f00627306ULL, 0x000ff00000209400ULL, 0x0000003f00417306ULL, 0x000e620000205400ULL,
0x0000005a5c00720bULL, 0x004fce0003fbd000ULL, 0x0000006c004d7306ULL, 0x000eb0000020d400ULL,
0x00000066003d7306ULL, 0x020ee2000020d400ULL, 0x000000416200720bULL, 0x002fce0003f9d000ULL,
0x0000003f00107306ULL, 0x000e62000020d400ULL, 0x000000014d4d5812ULL, 0x004fc800078efcffULL,
0x0000003e4d4d723eULL, 0x000fe400000010ffULL, 0x000000013d3d0812ULL, 0x008fc800078efcffULL,
0x0000003d1212723eULL, 0x000fe200000010ffULL, 0x0000004c3430723cULL, 0x000f620000041830ULL,
0x0000000110104812ULL, 0x002fc800078efcffULL, 0x000000101313723eULL, 0x000fce00000010ffULL,
0x000000123434723cULL, 0x000b6e0000041838ULL, 0x000176c80c127811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000012127f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176880068ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff107224ULL, 0x000fc600078e00ffULL, 0x0000000000147805ULL, 0x000fc80000015200ULL,
0x000004000a397984ULL, 0x000ee40000000800ULL, 0x8000000039ff7812ULL, 0x00afc40007804813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x00000038143b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e15ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff387819ULL, 0x000fc80000011439ULL, 0x0000003b38387211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x0000000238387819ULL, 0x000fc80000001239ULL,
0x000000380000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000110107810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000a397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000107824ULL, 0x000fe400078e00ffULL,
0x000059000d0d7a24ULL, 0x010fc600078e02ffULL, 0xffffffe010127812ULL, 0x000fe200078ec0ffULL,
0x000000800d0d7824ULL, 0x000fc800078e00ffULL, 0x000001000b127824ULL, 0x000fca00078e0212ULL,
0x0000008012157810ULL, 0x000fc80007ffe0ffULL, 0x0000006015137812ULL, 0x000fca00078ec0ffULL,
0x000000016e3a7824ULL, 0x000fe200078e0213ULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x0000001010137812ULL, 0x000fe400078ec0ffULL, 0x0000001570107217ULL, 0x000fe40007800000ULL,
0x00000003ff127819ULL, 0x000fe40000011602ULL, 0x000064000d3d7a11ULL, 0x000fe200078a38ffULL,
0x0000000110107824ULL, 0x000fe200078e0a15ULL, 0x0000000412387810ULL, 0x040fe20007ffe0ffULL,
0x0000000112157824ULL, 0x040fe200078e0213ULL, 0x0000000c123b7810ULL, 0x000fc40007ffe0ffULL,
0x0000001013107217ULL, 0x000fe20007800000ULL, 0x0000000115147824ULL, 0x000fe200078e0202ULL,
0x000065000d3f7a11ULL, 0x000fe200028f3cffULL, 0x0000000815397824ULL, 0x000fe400078e00ffULL,
0x0000000110107824ULL, 0x100fe400078e0a13ULL, 0x000000013b417824ULL, 0x100fe200078e0213ULL,
0xfffffff8393c7812ULL, 0x000fe400078ee214ULL, 0x0000000812147810ULL, 0x040fe20007ffe0ffULL,
0x0000000141407824ULL, 0x000fe200078e0202ULL, 0x000000101200720cULL, 0x080fe20003f86070ULL,
0x0000000115127824ULL, 0x000fe200078e023aULL, 0x000000101400720cULL, 0x080fe20003f46070ULL,
0x0000000138157824ULL, 0x140fe200078e0213ULL, 0x000000103800720cULL, 0x080fe20003f66070ULL,
0x0000000114397824ULL, 0x000fe200078e0213ULL, 0x000000103b00720cULL, 0x000fe20003f06070ULL,
0x0000000115137824ULL, 0x000fc400078e0202ULL, 0x0000000815147824ULL, 0x000fe400078e00ffULL,
0x0000000139387824ULL, 0x040fe400078e0202ULL, 0x00000008393b7824ULL, 0x000fe200078e00ffULL,
0xfffffff814107812ULL, 0x000fe200078ee213ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff83b3e7812ULL, 0x000fe200078ee238ULL, 0x0000000115147824ULL, 0x100fe200078e023aULL,
0x0000006012127212ULL, 0x000fe200078efcffULL, 0x0000000139387824ULL, 0x000fe400078e023aULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000123d127210ULL, 0x000fc60007fbe0ffULL,
0x00000001413a7824ULL, 0x000fe200078e023aULL, 0x0000006014147212ULL, 0x000fe200078efcffULL,
0x0000008038387825ULL, 0x000fc800078e00ffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000006038387212ULL, 0x000fc600078efcffULL, 0x0000000113137824ULL, 0x000fe200028e063fULL,
0x0000003d14147210ULL, 0x000fe20007fbe0ffULL, 0x0000000841417824ULL, 0x000fe200078e00ffULL,
0x000000603a3a7212ULL, 0x000fc600078efcffULL, 0x0000000115157824ULL, 0x000fe200028e063fULL,
0x0000003d38387210ULL, 0x080fe40007fbe0ffULL, 0x0000003d3a3a7210ULL, 0x000fe20007fde0ffULL,
0x000000103c3d7824ULL, 0x000fe200078e026dULL, 0xfffffff841407812ULL, 0x000fe200078ee240ULL,
0x0000000139397824ULL, 0x100fe400028e063fULL, 0x000000013b3b7824ULL, 0x000fe200030e063fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000123d7faeULL, 0x0003e2000e101c48ULL,
0x00000010103f7824ULL, 0x000fc400078e026dULL, 0x000000103e417824ULL, 0x100fe400078e026dULL,
0x0000001040437824ULL, 0x000fe200078e026dULL, 0x00000000143f7faeULL, 0x0003e8000d901c48ULL,
0x0000000038417faeULL, 0x0003e8000d101c48ULL, 0x000000003a437faeULL, 0x0003e2000c101c48ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001010137812ULL, 0x000fe400078ec0ffULL,
0x000064000d3f7a11ULL, 0x000fc400078038ffULL, 0x0000001302137211ULL, 0x000fe400078fe8ffULL,
0x000065000d417a11ULL, 0x000fe400000f3cffULL, 0x0000000413157810ULL, 0x040fe20007ffe0ffULL,
0x0000000113107824ULL, 0x040fe200078e0202ULL, 0x0000000c133b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000813397824ULL, 0x040fe400078e00ffULL, 0x0000000113127824ULL, 0x000fe400078e023aULL,
0x00000008153e7824ULL, 0x000fe200078e00ffULL, 0xfffffff839107812ULL, 0x000fe200078ee210ULL,
0x00000001153c7824ULL, 0x000fe200078e023aULL, 0x0000000813397810ULL, 0x000fe20007ffe0ffULL,
0x0000000115137824ULL, 0x000fc400078e0202ULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL, 0x0000000139387824ULL, 0x040fe400078e023aULL,
0x0000000139147824ULL, 0x040fe400078e0202ULL, 0x0000000839397824ULL, 0x000fe400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff839407812ULL, 0x000fe200078ee214ULL,
0x000000013b3a7824ULL, 0x040fe200078e023aULL, 0x0000006012147212ULL, 0x080fe200078efcffULL,
0x000000013b157824ULL, 0x040fe200078e0202ULL, 0x000000603c127212ULL, 0x000fe200078efcffULL,
0x000000083b427824ULL, 0x000fe200078e00ffULL, 0x000000143f147210ULL, 0x040fe20007f1e0ffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x000000123f127210ULL, 0x000fe40007f5e0ffULL,
0xfffffff842427812ULL, 0x000fe200078ee215ULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000006038387212ULL, 0x000fc600078efcffULL, 0x0000000113157824ULL, 0x100fe200000e0641ULL,
0x000000603a3a7212ULL, 0x000fe200078efcffULL, 0x000000013d137824ULL, 0x000fe200010e0641ULL,
0x000000383f387210ULL, 0x040fe20007f1e0ffULL, 0x00000010103d7824ULL, 0x100fe200078e026dULL,
0x0000003a3f3a7210ULL, 0x000fe20007f7e0ffULL, 0x000000103e3f7824ULL, 0x000fe400078e026dULL,
0x0000000139397824ULL, 0x100fe200000e0641ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000b901c48ULL, 0x000000013b3b7824ULL, 0x000fc400018e0641ULL,
0x0000001040417824ULL, 0x100fe200078e026dULL, 0x00000000123f7faeULL, 0x0003e2000b901c48ULL,
0x0000001042437824ULL, 0x000fc600078e026dULL, 0x0000000038417faeULL, 0x0003e8000b901c48ULL,
0x000000003a437faeULL, 0x0003e4000b901c48ULL, 0x0000000800107824ULL, 0x000fca00078e00ffULL,
0xfffffff010107812ULL, 0x000fc800078ec0ffULL, 0x00000000100573c2ULL, 0x000ee200000e0000ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000176a805057890ULL, 0x008fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a80010127f8cULL, 0x0002e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176280009147f8cULL, 0x0002a4000c80043fULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x01762c00093b7984ULL, 0x000f240000000800ULL,
0x800000003bff7812ULL, 0x014fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x002fc8000001143bULL, 0x0000003d10107211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x0000000210107819ULL, 0x000fc8000000123bULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01762c00093b7984ULL, 0x000ea40000000800ULL, 0x800000003bff7812ULL, 0x004fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000107824ULL, 0x002fca00078e00ffULL,
0xffffff8010157812ULL, 0x000fc800078ec0ffULL, 0x0000008060107810ULL, 0x000fca0007ffe015ULL,
0x0000000177107824ULL, 0x000fca00078e0210ULL, 0x0170000010397984ULL, 0x000e680000000800ULL,
0x0172000010387984ULL, 0x0004e20000000800ULL, 0x0000000e3900720bULL, 0x002fe20003f1d000ULL,
0x000130027f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x004fc800000e0100ULL,
0x0000ffff3c3b7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff107424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x0000000178157810ULL, 0x000fe40007ffe0ffULL, 0x0000000e3900720bULL, 0x000fe40003f54000ULL,
0x000000001500720cULL, 0x000fe20003f05270ULL, 0x00012fc27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000107806ULL, 0x000fc400010e0100ULL, 0x00000080003a8824ULL, 0x000fe200078e0260ULL,
0x0000000e39148209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991010157816ULL, 0x000fe200000000ffULL, 0x00000001773d8824ULL, 0x000fca00078e023aULL,
0x017400143d008388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000e39157209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff10ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000e15147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x00000014003a7308ULL, 0x000e640000000800ULL, 0x0000003a0f0f7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x000fe20000011602ULL,
0x00012ef27f007947ULL, 0x000fea000b800000ULL, 0x00001f143a3c7589ULL, 0x0002a400000e0000ULL,
0x0000003c18187220ULL, 0x084fe40000410000ULL, 0x0000003c19197220ULL, 0x080fe40000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe40000410000ULL, 0x0000003c1d1d7220ULL, 0x000fc40000410000ULL,
0x0000003c20207220ULL, 0x080fe40000410000ULL, 0x0000003c21217220ULL, 0x080fe40000410000ULL,
0x0000003c24247220ULL, 0x080fe40000410000ULL, 0x0000003c25257220ULL, 0x080fe40000410000ULL,
0x0000003c28287220ULL, 0x080fe40000410000ULL, 0x0000003c29297220ULL, 0x000fc40000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000003c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000003c30307220ULL, 0x080fe40000410000ULL, 0x0000003c31317220ULL, 0x080fe40000410000ULL,
0x0000003c34347220ULL, 0x080fe40000410000ULL, 0x0000003c35357220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0010ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802147811ULL, 0x002fe200078ff0ffULL,
0x00012df27f007947ULL, 0x000fea000b800000ULL, 0x00001f143a3c7589ULL, 0x0002a400000e0000ULL,
0x0000003c1a1a7220ULL, 0x084fe40000410000ULL, 0x0000003c1b1b7220ULL, 0x080fe40000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe40000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe40000410000ULL,
0x0000003c22227220ULL, 0x080fe40000410000ULL, 0x0000003c23237220ULL, 0x000fc40000410000ULL,
0x0000003c26267220ULL, 0x080fe40000410000ULL, 0x0000003c27277220ULL, 0x080fe40000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe40000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe40000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe40000410000ULL, 0x0000003c2f2f7220ULL, 0x000fc40000410000ULL,
0x0000003c32327220ULL, 0x080fe40000410000ULL, 0x0000003c33337220ULL, 0x080fe40000410000ULL,
0x0000003c36367220ULL, 0x080fe40000410000ULL, 0x0000003c37377220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff3bff7812ULL, 0x000fe20007806010ULL,
0x00000001ff107424ULL, 0x000fe200078e00ffULL, 0x0000000e390e7209ULL, 0x000fd60007810000ULL,
0x8000000e39390221ULL, 0x000fe20000010000ULL, 0x00007610ff100816ULL, 0x000fc60000000010ULL,
0x3fb8aa3b39390820ULL, 0x000fc80000410000ULL, 0x0000003900080308ULL, 0x000e640000000800ULL,
0x0000000838380220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000f380f7221ULL, 0x008fc40000010000ULL, 0x0000000000147805ULL, 0x000fca0000015200ULL,
0x0000000800387824ULL, 0x000fca00078e00ffULL, 0xfffffff0383a7812ULL, 0x000fca00078ec0ffULL,
0x0176b4003a397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038143b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e15ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff387819ULL, 0x000fc80000011439ULL,
0x0000003b38387211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000238387819ULL, 0x000fc80000001239ULL, 0x000000380000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176b4003a397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991010107816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003fc5270ULL, 0x0000016000006947ULL, 0x000fea0003800000ULL,
0x00000008ff06723eULL, 0x000fe400000010ffULL, 0x00000002ff177819ULL, 0x000fe40000011602ULL,
0x0000541006107816ULL, 0x000fe20000000006ULL, 0x000129c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1710077589ULL, 0x0002a400000e0000ULL, 0x0000000817147810ULL, 0x000fe20007ffe0ffULL,
0x00012a127f007947ULL, 0x000fea000b800000ULL, 0x00001f1410067589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001017147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e0010ULL, 0x00006770003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0001346000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001817147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e0010ULL,
0x000067e0003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x004fc400078e00ffULL, 0x000133f000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000010006d107810ULL, 0x00afca0007ffe0ffULL, 0x0000001044387824ULL, 0x100fe400078e0210ULL,
0x0000001004147824ULL, 0x000fc800078e0210ULL, 0x000000003838783bULL, 0x000e680000004200ULL,
0x000000001414783bULL, 0x000ee20000004200ULL, 0x00000018ff477819ULL, 0x002fe2000001143bULL,
0x00000038006c7306ULL, 0x000fe20000009400ULL, 0x00000018ff3c7819ULL, 0x004fe40000011438ULL,
0x00000018ff567819ULL, 0x008fe40000011415ULL, 0x00000018ff3e7819ULL, 0x000fc4000001143aULL,
0x00000018ff577819ULL, 0x000fe20000011416ULL, 0x00000047004c7306ULL, 0x000fe20000209400ULL,
0x00000018ff3d7819ULL, 0x000fe40000011439ULL, 0x00000018ff497819ULL, 0x000fe40000011414ULL,
0x00000018ff587819ULL, 0x000fc60000011417ULL, 0x00000047004b7306ULL, 0x000ff00000205400ULL,
0x00000047004a7306ULL, 0x0003f0000020d400ULL, 0x0000003800657306ULL, 0x000ea20000005400ULL,
0x0000010038477824ULL, 0x002fca00078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe40000011447ULL,
0x0000003800487306ULL, 0x0002f0000000d400ULL, 0x0000004e00697306ULL, 0x000fe20000209400ULL,
0x0001000038387824ULL, 0x002fe200078e00ffULL, 0x000000656c00720bULL, 0x004fc80003f1d000ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000004e00727306ULL, 0x000e6e0000205400ULL,
0x0000000148480812ULL, 0x008fe200078efcffULL, 0x0000004e00477306ULL, 0x000eb0000020d400ULL,
0x0000005600417306ULL, 0x000fe20000209400ULL, 0x000000726900720bULL, 0x002fce0003f5d000ULL,
0x0000005600407306ULL, 0x000fec0000205400ULL, 0x0000000147472812ULL, 0x004fe400078efcffULL,
0x00000056005d7306ULL, 0x000fe4000020d400ULL, 0x000000484748723eULL, 0x000fcc00000010ffULL,
0x0000003800617306ULL, 0x000ff00000209400ULL, 0x00000038006a7306ULL, 0x000e700000205400ULL,
0x0000003e004d7306ULL, 0x000ff00000209400ULL, 0x0000003e00507306ULL, 0x000fe20000205400ULL,
0x0000006a6100720bULL, 0x002fce0003f5d000ULL, 0x0000003e005a7306ULL, 0x000ff0000020d400ULL,
0x0000003800567306ULL, 0x0002b0000020d400ULL, 0x00000057003f7306ULL, 0x000fe20000209400ULL,
0x000001003a387824ULL, 0x002fca00078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011438ULL,
0x000001003b387824ULL, 0x000fe200078e00ffULL, 0x00000057003e7306ULL, 0x000fe20000205400ULL,
0x0000000156562812ULL, 0x004fce00078efcffULL, 0x0000005700527306ULL, 0x0003f0000020d400ULL,
0x0000003900667306ULL, 0x000fe20000009400ULL, 0x0000010039577824ULL, 0x002fca00078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe40000011457ULL, 0x0000003900637306ULL, 0x000e700000005400ULL,
0x0000003d00537306ULL, 0x000ff00000209400ULL, 0x0000003d00687306ULL, 0x000ea20000205400ULL,
0x000000636600720bULL, 0x002fce0003fbd000ULL, 0x0000006f00577306ULL, 0x000ff00000209400ULL,
0x0000006f005c7306ULL, 0x000e620000205400ULL, 0x000000685300720bULL, 0x004fe20003f9d000ULL,
0x000100003a537824ULL, 0x000fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011453ULL,
0x0000006f004e7306ULL, 0x0004f0000020d400ULL, 0x0000003c004f7306ULL, 0x000fe20000209400ULL,
0x00000018ff6f7819ULL, 0x004fc40000011438ULL, 0x0000005c5700720bULL, 0x002fca0003f5d000ULL,
0x0000003c00547306ULL, 0x000e700000205400ULL, 0x0000003c00557306ULL, 0x000ea2000020d400ULL,
0x000000014e4e2812ULL, 0x008fce00078efcffULL, 0x0000003d00467306ULL, 0x000ee2000020d400ULL,
0x000000544f00720bULL, 0x002fce0003f7d000ULL, 0x0000004900437306ULL, 0x000fec0000209400ULL,
0x0000000155553812ULL, 0x004fe400078efcffULL, 0x0000004900427306ULL, 0x000fe20000205400ULL,
0x0000000146464812ULL, 0x008fe400078efcffULL, 0x000000504d00720bULL, 0x000fca0003f9d000ULL,
0x00000049005e7306ULL, 0x000ff0000020d400ULL, 0x00000058003c7306ULL, 0x000fe20000209400ULL,
0x000000015a5a4812ULL, 0x000fe400078efcffULL, 0x000000404100720bULL, 0x000fca0003f9d000ULL,
0x00000058003d7306ULL, 0x000ff00000205400ULL, 0x0000005800517306ULL, 0x0003e2000020d400ULL,
0x000000015d5d4812ULL, 0x000fce00078efcffULL, 0x0000003900497306ULL, 0x000ea2000000d400ULL,
0x0001000039587824ULL, 0x002fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011458ULL,
0x0000006f00387306ULL, 0x000ff00000209400ULL, 0x0000006f00397306ULL, 0x000e620000205400ULL,
0x0000000149495812ULL, 0x004fc800078efcffULL, 0x000000494e49723eULL, 0x000fc600000010ffULL,
0x0000003a00657306ULL, 0x000ff00000009400ULL, 0x0000003a006c7306ULL, 0x000ea20000005400ULL,
0x000000393800720bULL, 0x002fe20003fbd000ULL, 0x0000001005387824ULL, 0x000fcc00078e0210ULL,
0x0000007500597306ULL, 0x000ff00000209400ULL, 0x0000007500627306ULL, 0x000e620000205400ULL,
0x0000006c6500720bULL, 0x004fce0003f1d000ULL, 0x0000003a00697306ULL, 0x0004f0000000d400ULL,
0x0000006f00667306ULL, 0x000f22000020d400ULL, 0x000100003b3a7824ULL, 0x004fe200078e00ffULL,
0x000000625900720bULL, 0x002fc80003f5d000ULL, 0x00000018ff637819ULL, 0x000fe2000001143aULL,
0x00000100143a7824ULL, 0x000fe200078e00ffULL, 0x0000006100537306ULL, 0x000fe20000209400ULL,
0x0000000169690812ULL, 0x008fe400078efcffULL, 0x000000424300720bULL, 0x000fe20003f1d000ULL,
0x0000010015427824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fc6000001143aULL,
0x00000061005c7306ULL, 0x000e620000205400ULL, 0x0000000166665812ULL, 0x010fe400078efcffULL,
0x00000018ff4d7819ULL, 0x000fca0000011442ULL, 0x00000074005b7306ULL, 0x000fe20000209400ULL,
0x000000015e5e0812ULL, 0x000fce00078efcffULL, 0x0000007400647306ULL, 0x000ea20000205400ULL,
0x0000005c5300720bULL, 0x002fce0003fbd000ULL, 0x0000006100687306ULL, 0x000e70000020d400ULL,
0x0000006500597306ULL, 0x000fe20000209400ULL, 0x000000645b00720bULL, 0x004fce0003f7d000ULL,
0x0000006500627306ULL, 0x000ea20000205400ULL, 0x0000000168685812ULL, 0x002fce00078efcffULL,
0x0000007400587306ULL, 0x000e70000020d400ULL, 0x0000003b004f7306ULL, 0x000fe20000009400ULL,
0x000000625900720bULL, 0x004fce0003fbd000ULL, 0x0000003b00547306ULL, 0x000ea20000005400ULL,
0x0000000158583812ULL, 0x002fce00078efcffULL, 0x0000006500647306ULL, 0x0002f0000020d400ULL,
0x0000004d00427306ULL, 0x000fe20000209400ULL, 0x000000544f00720bULL, 0x004fe20003f7d000ULL,
0x0001000014657824ULL, 0x002fca00078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000004d00437306ULL, 0x000e620000205400ULL, 0x0000000164645812ULL, 0x008fce00078efcffULL,
0x0000003b006a7306ULL, 0x0004f0000000d400ULL, 0x0000006300577306ULL, 0x000fe20000209400ULL,
0x000000003838783bULL, 0x004ea20000004200ULL, 0x000000434200720bULL, 0x002fc60003fbd000ULL,
0x011800004540783bULL, 0x000e660000000200ULL, 0x00000063006c7306ULL, 0x000f220000205400ULL,
0x000000016a6a3812ULL, 0x008fce00078efcffULL, 0x0000007500677306ULL, 0x000ef0000020d400ULL,
0x00000063005b7306ULL, 0x000ea2000020d400ULL, 0x0000006c5700720bULL, 0x010fce0003f7d000ULL,
0x00000014004f7306ULL, 0x000fe20000009400ULL, 0x0000000167672812ULL, 0x008fe400078efcffULL,
0x0000004b4c00720bULL, 0x000fca0003f5d000ULL, 0x0000001400727306ULL, 0x000ee20000005400ULL,
0x000000015b5b3812ULL, 0x004fe400078efcffULL, 0x00000018ff577819ULL, 0x000fe40000011438ULL,
0x00000018ff6c7819ULL, 0x000fe20000011439ULL, 0x000000074040e231ULL, 0x082fe200003400ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001143aULL, 0x0000001400637306ULL, 0x000e62000000d400ULL,
0x000000014a4a2812ULL, 0x000fe200078efcffULL, 0x000000074242e231ULL, 0x000fe200003400ffULL,
0x0000003e3f00720bULL, 0x000fe20003f5d000ULL, 0x000000064141e231ULL, 0x000fc400003400ffULL,
0x000000064343e231ULL, 0x000fe400003400ffULL, 0x0000004d00627306ULL, 0x000ea2000020d400ULL,
0x000000724f00720bULL, 0x008fc80003f7d000ULL, 0x000000484018723cULL, 0x000b660000041818ULL,
0x00000015004b7306ULL, 0x000fe20000009400ULL, 0x0000000152522812ULL, 0x000fca00078efcffULL,
0x0000000163633812ULL, 0x002fe400078efcffULL, 0x0000001500547306ULL, 0x000e620000005400ULL,
0x0000003d3c00720bULL, 0x000fe20003f7d000ULL, 0x00000010033c7824ULL, 0x000fe200078e0210ULL,
0x0000000162625812ULL, 0x004fca00078efcffULL, 0x0000001500617306ULL, 0x0004e2000000d400ULL,
0x000000003c3c783bULL, 0x000f2a0000004200ULL, 0x0000000151513812ULL, 0x000fe400078efcffULL,
0x0000005700537306ULL, 0x000fe20000209400ULL, 0x000000544b00720bULL, 0x002fe20003fbd000ULL,
0x0001000015157824ULL, 0x004fcc00078e00ffULL, 0x0000005700507306ULL, 0x000e6c0000205400ULL,
0x0000000161615812ULL, 0x008fe400078efcffULL, 0x00000057004c7306ULL, 0x000eb0000020d400ULL,
0x0000006500577306ULL, 0x000fe20000209400ULL, 0x000000505300720bULL, 0x002fce0003f7d000ULL,
0x0000006500147306ULL, 0x000e620000205400ULL, 0x00000018ff727819ULL, 0x010fe4000001143dULL,
0x00000018ff497819ULL, 0x020fc6000001143cULL, 0x000000014c4c3812ULL, 0x004fe400078efcffULL,
0x0000006c005c7306ULL, 0x000ff00000209400ULL, 0x0000006c00597306ULL, 0x000ea20000205400ULL,
0x000000145700720bULL, 0x002fc40003fbd000ULL, 0x000000565514723eULL, 0x000fca00000010ffULL,
0x0000006c004b7306ULL, 0x0002f0000020d400ULL, 0x0000006f004d7306ULL, 0x000fe20000209400ULL,
0x00000018ff6c7819ULL, 0x002fe4000001143bULL, 0x000000595c00720bULL, 0x004fca0003f7d000ULL,
0x0000006c004e7306ULL, 0x000ff00000209400ULL, 0x0000006c00547306ULL, 0x000fe20000205400ULL,
0x000000014b4b3812ULL, 0x008fce00078efcffULL, 0x0000006c00487306ULL, 0x0003f0000020d400ULL,
0x0000006f004f7306ULL, 0x000fe20000205400ULL, 0x00000018ff6c7819ULL, 0x002fe40000011415ULL,
0x000000584615723eULL, 0x000fca00000010ffULL, 0x0000006f00477306ULL, 0x000fe4000020d400ULL,
0x00000014401c723cULL, 0x000b6c000004181cULL, 0x0000006c006f7306ULL, 0x000fe20000209400ULL,
0x000000696714723eULL, 0x020fe200000010ffULL, 0x0000010016677824ULL, 0x000fe200078e00ffULL,
0x0000006a6615723eULL, 0x000fe200000010ffULL, 0x0000010017697824ULL, 0x000fc600078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000006c00467306ULL, 0x000fe20000205400ULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x000000144020723cULL, 0x000b6c0000041820ULL,
0x0000006c00667306ULL, 0x000fe2000020d400ULL, 0x000000685a14723eULL, 0x020fc400000010ffULL,
0x0000005b4a15723eULL, 0x000fca00000010ffULL, 0x0000006500657306ULL, 0x000e64000020d400ULL,
0x000000144024723cULL, 0x000bec0000041824ULL, 0x00000067006c7306ULL, 0x000ff00000209400ULL,
0x00000067006a7306ULL, 0x000ea20000205400ULL, 0x0000000165655812ULL, 0x002fc400078efcffULL,
0x000000466f00720bULL, 0x000fca0003fbd000ULL, 0x0000006700677306ULL, 0x000e70000020d400ULL,
0x0000001700147306ULL, 0x020fe20000009400ULL, 0x0000006a6c00720bULL, 0x004fe40003f1d000ULL,
0x0000000166665812ULL, 0x000fca00078efcffULL, 0x0000001700157306ULL, 0x000eac0000005400ULL,
0x0000000167670812ULL, 0x002fe400078efcffULL, 0x0000007200557306ULL, 0x000ff00000209400ULL,
0x0000007200587306ULL, 0x000fe20000205400ULL, 0x000000151400720bULL, 0x004fe20003f1d000ULL,
0x0001000016147824ULL, 0x000fe200078e00ffULL, 0x000000616215723eULL, 0x000fca00000010ffULL,
0x0000007200467306ULL, 0x000ff0000020d400ULL, 0x0000001600727306ULL, 0x000ff00000009400ULL,
0x00000016006a7306ULL, 0x000e700000005400ULL, 0x00000069006f7306ULL, 0x000ff00000209400ULL,
0x00000069005a7306ULL, 0x000ea20000205400ULL, 0x0000006a7200720bULL, 0x002fc40003f9d000ULL,
0x00000018ff727819ULL, 0x000fe20000011414ULL, 0x0001000017147824ULL, 0x000fc800078e00ffULL,
0x0000006900687306ULL, 0x000e62000020d400ULL, 0x0000005a6f00720bULL, 0x004fce0003fbd000ULL,
0x0000001700697306ULL, 0x0004e2000000d400ULL, 0x00000018ff6f7819ULL, 0x000fce000001143eULL,
0x0000006f005a7306ULL, 0x000fe20000209400ULL, 0x00000018ff177819ULL, 0x004fe40000011414ULL,
0x000000636414723eULL, 0x000fe400000010ffULL, 0x0000000168685812ULL, 0x002fc600078efcffULL,
0x0000006f005b7306ULL, 0x000fe20000205400ULL, 0x0000000169690812ULL, 0x008fe200078efcffULL,
0x000000144028723cULL, 0x000b6c0000041828ULL, 0x0000006f004a7306ULL, 0x000fe2000020d400ULL,
0x000000655e14723eULL, 0x020fe200000010ffULL, 0x0000010038657824ULL, 0x000fe200078e00ffULL,
0x000000665d15723eULL, 0x000fc400000010ffULL, 0x00000018ff667819ULL, 0x000fc6000001143fULL,
0x00000016006a7306ULL, 0x000e64000000d400ULL, 0x00000014402c723cULL, 0x000b6c000004182cULL,
0x00000072006c7306ULL, 0x000fe20000209400ULL, 0x000000696815723eULL, 0x020fce00000010ffULL,
0x00000072006f7306ULL, 0x000ea20000205400ULL, 0x000000016a6a4812ULL, 0x002fc800078efcffULL,
0x0000006a6714723eULL, 0x000fe200000010ffULL, 0x0001000039677824ULL, 0x000fe400078e00ffULL,
0x0000001700637306ULL, 0x000fe80000209400ULL, 0x000000144030723cULL, 0x000b680000041830ULL,
0x0000001700617306ULL, 0x000e620000205400ULL, 0x0000006f6c00720bULL, 0x004fc40003f9d000ULL,
0x00000018ff6f7819ULL, 0x000fca0000011467ULL, 0x0000007200167306ULL, 0x000eb0000020d400ULL,
0x0000001700627306ULL, 0x000ee2000020d400ULL, 0x000000616300720bULL, 0x002fe40003fbd000ULL,
0x0000000116164812ULL, 0x004fca00078efcffULL, 0x0000003800177306ULL, 0x000fe20000009400ULL,
0x000000165214723eULL, 0x020fca00000010ffULL, 0x0000000162625812ULL, 0x008fe400078efcffULL,
0x00000038005e7306ULL, 0x000e640000005400ULL, 0x000000625115723eULL, 0x000fe400000010ffULL,
0x00000018ff627819ULL, 0x000fc80000011465ULL, 0x0000003800637306ULL, 0x000ea2000000d400ULL,
0x000000144034723cULL, 0x000b6e0000041834ULL, 0x0000006200517306ULL, 0x000fe20000209400ULL,
0x0001000038147824ULL, 0x020fe200078e00ffULL, 0x0000005e1700720bULL, 0x002fe20003fbd000ULL,
0x0000010039417824ULL, 0x000fc400078e00ffULL, 0x000001003b177824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011414ULL, 0x0000006200407306ULL, 0x000e620000205400ULL,
0x00000018ff437819ULL, 0x000fcc0000011441ULL, 0x0000000163635812ULL, 0x004fe200078efcffULL,
0x0000006200387306ULL, 0x000eb0000020d400ULL, 0x0000003900647306ULL, 0x000fe20000009400ULL,
0x000000405100720bULL, 0x002fce0003f5d000ULL, 0x0000003900167306ULL, 0x000e6c0000005400ULL,
0x0000000138382812ULL, 0x004fe400078efcffULL, 0x0000004200147306ULL, 0x000fe40000209400ULL,
0x000000633838723eULL, 0x000fe200000010ffULL, 0x000100003e637824ULL, 0x000fca00078e00ffULL,
0x0000004200157306ULL, 0x000ea20000205400ULL, 0x000000166400720bULL, 0x002fe40003f1d000ULL,
0x00000018ff637819ULL, 0x000fca0000011463ULL, 0x0000004300417306ULL, 0x000ff00000209400ULL,
0x00000043006a7306ULL, 0x000e620000205400ULL, 0x000000151400720bULL, 0x004fe20003f9d000ULL,
0x000100003a147824ULL, 0x000fca00078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011414ULL,
0x00000066005d7306ULL, 0x000fe20000209400ULL, 0x000100003b147824ULL, 0x000fce00078e00ffULL,
0x0000006600617306ULL, 0x000fe20000205400ULL, 0x0000006a4100720bULL, 0x002fce0003f5d000ULL,
0x0000006600527306ULL, 0x000ff0000020d400ULL, 0x0000003900667306ULL, 0x000e70000000d400ULL,
0x0000004300397306ULL, 0x0004f0000020d400ULL, 0x0000004200657306ULL, 0x0008e2000020d400ULL,
0x00000018ff437819ULL, 0x004fc40000011417ULL, 0x0000000166660812ULL, 0x002fca00078efcffULL,
0x0000003a00177306ULL, 0x000fe20000009400ULL, 0x000001003a427824ULL, 0x010fe200078e00ffULL,
0x0000000139392812ULL, 0x008fe400078efcffULL, 0x0000004f4d00720bULL, 0x000fe40003f5d000ULL,
0x00000018ff727819ULL, 0x000fe40000011442ULL, 0x0000003a00167306ULL, 0x000e620000005400ULL,
0x0000000165654812ULL, 0x000fe400078efcffULL, 0x000000663939723eULL, 0x000fc400000010ffULL,
0x000000654c4c723eULL, 0x000fc600000010ffULL, 0x0000003b00157306ULL, 0x000fe20000009400ULL,
0x0000000147472812ULL, 0x000fce00078efcffULL, 0x0000003b006a7306ULL, 0x000ea20000005400ULL,
0x000000161700720bULL, 0x002fce0003fbd000ULL, 0x0000007200677306ULL, 0x000ff00000209400ULL,
0x0000007200427306ULL, 0x000fe20000205400ULL, 0x0000006a1500720bULL, 0x004fce0003f9d000ULL,
0x00000072005e7306ULL, 0x0003f0000020d400ULL, 0x0000006f00687306ULL, 0x000fe20000209400ULL,
0x00000018ff727819ULL, 0x002fe40000011414ULL, 0x011800001114783bULL, 0x000e6a0000000200ULL,
0x0000006f00697306ULL, 0x000eb00000205400ULL, 0x0000006f00627306ULL, 0x000ef0000020d400ULL,
0x00000043006c7306ULL, 0x000fe20000209400ULL, 0x000000696800720bULL, 0x004fce0003f1d000ULL,
0x00000043006f7306ULL, 0x000eac0000205400ULL, 0x0000000162620812ULL, 0x008fe400078efcffULL,
0x0000004300407306ULL, 0x000ee2000020d400ULL, 0x000000544e00720bULL, 0x000fe20003f1d000ULL,
0x000100003c547824ULL, 0x000fe200078e00ffULL, 0x000000071414e231ULL, 0x002fc400003400ffULL,
0x000000071616e231ULL, 0x000fe400003400ffULL, 0x000000061515e231ULL, 0x080fe200003400ffULL,
0x0000003a00647306ULL, 0x000e62000000d400ULL, 0x0000006f6c00720bULL, 0x004fe20003f7d000ULL,
0x000000061717e231ULL, 0x000fe200003400ffULL, 0x000000426700720bULL, 0x000fe40003fdd000ULL,
0x00000018ff6f7819ULL, 0x000fe40000011454ULL, 0x0000000148480812ULL, 0x000fe200078efcffULL,
0x00000053003a7306ULL, 0x000fe20000209400ULL, 0x000000381418723cULL, 0x000b6a0000041818ULL,
0x0000000140403812ULL, 0x008fc400078efcffULL, 0x00000053006a7306ULL, 0x000ea20000205400ULL,
0x000000015e5e6812ULL, 0x000fe400078efcffULL, 0x0000000164645812ULL, 0x002fca00078efcffULL,
0x0000003b00507306ULL, 0x0002f0000000d400ULL, 0x0000005300517306ULL, 0x000f22000020d400ULL,
0x000001003c3b7824ULL, 0x002fe200078e00ffULL, 0x0000006a3a00720bULL, 0x004fc80003f7d000ULL,
0x00000018ff5c7819ULL, 0x000fe2000001143bULL, 0x000001003d3b7824ULL, 0x000fe200078e00ffULL,
0x0000007200417306ULL, 0x000fe20000209400ULL, 0x0000000150504812ULL, 0x008fc800078efcffULL,
0x000000504039723eULL, 0x020fc600000010ffULL, 0x0000007200117306ULL, 0x000e620000205400ULL,
0x0000000151513812ULL, 0x010fce00078efcffULL, 0x0000003c00427306ULL, 0x000ff00000009400ULL,
0x0000003c00537306ULL, 0x000ea20000005400ULL, 0x000000114100720bULL, 0x002fe20003f7d000ULL,
0x000001003f117824ULL, 0x000fcc00078e00ffULL, 0x0000005c00597306ULL, 0x000ff00000209400ULL,
0x0000005c004d7306ULL, 0x000e620000205400ULL, 0x000000534200720bULL, 0x004fce0003fdd000ULL,
0x0000007200437306ULL, 0x0004f0000020d400ULL, 0x0000003d004e7306ULL, 0x000fe20000009400ULL,
0x00000018ff727819ULL, 0x004fe4000001143bULL, 0x0000004d5900720bULL, 0x002fca0003f5d000ULL,
0x0000003d00677306ULL, 0x000e620000005400ULL, 0x0000000143433812ULL, 0x008fce00078efcffULL,
0x0000007200687306ULL, 0x000ff00000209400ULL, 0x0000007200697306ULL, 0x000ea20000205400ULL,
0x000000674e00720bULL, 0x002fce0003fbd000ULL, 0x0000006f00547306ULL, 0x000ff00000209400ULL,
0x0000006f006c7306ULL, 0x000e620000205400ULL, 0x000000696800720bULL, 0x004fce0003f7d000ULL,
0x0000005c004f7306ULL, 0x0004f0000020d400ULL, 0x0000003c00537306ULL, 0x0008e2000000d400ULL,
0x000100003d5c7824ULL, 0x004fe200078e00ffULL, 0x0000006c5400720bULL, 0x002fcc0003f1d000ULL,
0x0000003f00597306ULL, 0x000fe20000009400ULL, 0x000001003e3c7824ULL, 0x010fe200078e00ffULL,
0x000000014f4f2812ULL, 0x008fc800078efcffULL, 0x00000018ff6a7819ULL, 0x000fe4000001143cULL,
0x0000003f00387306ULL, 0x000e620000005400ULL, 0x0000000153536812ULL, 0x000fce00078efcffULL,
0x0000003e004d7306ULL, 0x000ff00000009400ULL, 0x0000003e00667306ULL, 0x000ea20000005400ULL,
0x000000385900720bULL, 0x002fe20003fdd000ULL, 0x000100003f387824ULL, 0x000fcc00078e00ffULL,
0x00000072003b7306ULL, 0x0002f0000020d400ULL, 0x0000004900577306ULL, 0x000fe20000209400ULL,
0x00000018ff727819ULL, 0x002fe4000001145cULL, 0x000000664d00720bULL, 0x004fc40003f5d000ULL,
0x000000624b4d723eULL, 0x000fe400000010ffULL, 0x00000018ff4b7819ULL, 0x000fe20000011438ULL,
0x0000004900567306ULL, 0x000e620000205400ULL, 0x000000013b3b3812ULL, 0x008fe400078efcffULL,
0x000000645e38723eULL, 0x000fe200000010ffULL, 0x0000004c141c723cULL, 0x040f68000004181cULL,
0x00000072005c7306ULL, 0x000fe80000209400ULL, 0x000000381420723cULL, 0x000b680000041820ULL,
0x0000007200677306ULL, 0x000ea20000205400ULL, 0x000000565700720bULL, 0x002fc40003f9d000ULL,
0x000000534f38723eULL, 0x020fca00000010ffULL, 0x0000003d00427306ULL, 0x000e70000000d400ULL,
0x0000006f004e7306ULL, 0x000722000020d400ULL, 0x000000675c00720bULL, 0x004fce0003f7d000ULL,
0x0000006a003c7306ULL, 0x000fe20000209400ULL, 0x00000018ff6f7819ULL, 0x008fe40000011411ULL,
0x0000000142425812ULL, 0x002fe400078efcffULL, 0x000000585500720bULL, 0x000fe40003fbd000ULL,
0x000000423b39723eULL, 0x000fe200000010ffULL, 0x0000006a003d7306ULL, 0x000e620000205400ULL,
0x000000014e4e0812ULL, 0x010fca00078efcffULL, 0x000000381428723cULL, 0x000f640000041828ULL,
0x0000003e00547306ULL, 0x000ea4000000d400ULL, 0x0000000146465812ULL, 0x000fcc00078efcffULL,
0x0000004900497306ULL, 0x000ee2000020d400ULL, 0x0000003d3c00720bULL, 0x002fe40003f1d000ULL,
0x00000051473c723eULL, 0x000fe400000010ffULL, 0x00000043483d723eULL, 0x000fc600000010ffULL,
0x00000072003a7306ULL, 0x000e62000020d400ULL, 0x0000000154542812ULL, 0x004fc600078efcffULL,
0x0000003c1424723cULL, 0x000f680000041824ULL, 0x0000006a00417306ULL, 0x000ea2000020d400ULL,
0x0000000149494812ULL, 0x008fe400078efcffULL, 0x0000005b5a00720bULL, 0x000fe40003f9d000ULL,
0x0000004e494e723eULL, 0x000fc600000010ffULL, 0x0000003f003e7306ULL, 0x000ee2000000d400ULL,
0x000000013a3a3812ULL, 0x002fe400078efcffULL, 0x000000615d00720bULL, 0x000fe40003f7d000ULL,
0x0000003a464f723eULL, 0x000fc600000010ffULL, 0x0000006f00567306ULL, 0x000fe20000209400ULL,
0x0000000141410812ULL, 0x004fe400078efcffULL, 0x000000014a4a4812ULL, 0x000fe200078efcffULL,
0x0000004e142c723cULL, 0x000f62000004182cULL, 0x000000544154723eULL, 0x000fc600000010ffULL,
0x0000006f00577306ULL, 0x000e620000205400ULL, 0x000000013e3e6812ULL, 0x008fe400078efcffULL,
0x0000000152523812ULL, 0x000fca00078efcffULL, 0x0000006300597306ULL, 0x000ff00000209400ULL,
0x00000063003f7306ULL, 0x000ea20000205400ULL, 0x000000575600720bULL, 0x002fce0003fbd000ULL,
0x0000004b005c7306ULL, 0x000ff00000209400ULL, 0x0000004b004d7306ULL, 0x000e620000205400ULL,
0x0000003f5900720bULL, 0x004fce0003f1d000ULL, 0x0000006f00117306ULL, 0x000eb0000020d400ULL,
0x0000006300637306ULL, 0x000ee2000020d400ULL, 0x0000004d5c00720bULL, 0x002fce0003f5d000ULL,
0x0000004b004b7306ULL, 0x000e62000020d400ULL, 0x0000000111115812ULL, 0x004fc800078efcffULL,
0x0000003e1155723eULL, 0x000fe200000010ffULL, 0x0000000200117824ULL, 0x000fe200078e00ffULL,
0x0000000163630812ULL, 0x008fc800078efcffULL, 0x000000634a4a723eULL, 0x000fe200000010ffULL,
0x000000541430723cULL, 0x000f620000041830ULL, 0x000000014b4b2812ULL, 0x002fc800078efcffULL,
0x0000004b524b723eULL, 0x000fce00000010ffULL, 0x0000004a1434723cULL, 0x000b6e0000041834ULL,
0x000176c80c147811ULL, 0x020fe400078e18ffULL, 0xfffffff811167812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000000014147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176900016ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff117224ULL, 0x000fc600078e00ffULL, 0x0000000000167805ULL, 0x004fc80000015200ULL,
0x000004000a397984ULL, 0x000ea40000000800ULL, 0x8000000039ff7812ULL, 0x006fc40007804815ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x00000038163b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e17ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff387819ULL, 0x000fc80000011439ULL, 0x0000003b38387211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x0000000238387819ULL, 0x000fc80000001239ULL,
0x000000380000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000111117810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000a397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000200c387824ULL, 0x000fc800078e00ffULL,
0x000001000b117824ULL, 0x000fca00078e0238ULL, 0x000000c011177810ULL, 0x000fc80007ffe0ffULL,
0x0000006017157812ULL, 0x000fca00078ec0ffULL, 0x000000016e3a7824ULL, 0x000fe200078e0215ULL,
0x0000040000009947ULL, 0x000fea0003800000ULL, 0x0000001770147217ULL, 0x000fe20007800000ULL,
0x0000001000157824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe40000011602ULL,
0x000064000d3f7a11ULL, 0x000fe200078a38ffULL, 0x0000000114147824ULL, 0x000fe200078e0a17ULL,
0x0000001015157812ULL, 0x000fe400078ec0ffULL, 0x0000000416387810ULL, 0x040fe40007ffe0ffULL,
0x0000001415147217ULL, 0x000fe20007800000ULL, 0x0000000116177824ULL, 0x140fe200078e0215ULL,
0x00000008163b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000138397824ULL, 0x100fe200078e0215ULL,
0x0000000c163c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000114147824ULL, 0x000fe200078e0a15ULL,
0x000065000d417a11ULL, 0x000fe200028f3cffULL, 0x0000000839437824ULL, 0x000fc400078e00ffULL,
0x000000013c497824ULL, 0x100fe200078e0215ULL, 0x000000143b00720cULL, 0x0c0fe20003f46070ULL,
0x000000013b3b7824ULL, 0x000fe200078e0215ULL, 0x000000143800720cULL, 0x080fe20003f66070ULL,
0x0000000117157824ULL, 0x040fe200078e0202ULL, 0x000000141600720cULL, 0x080fe20003f86070ULL,
0x0000000817387824ULL, 0x040fe200078e00ffULL, 0x000000143c00720cULL, 0x000fe20003f06070ULL,
0x0000000117147824ULL, 0x000fe400078e023aULL, 0x0000000139167824ULL, 0x100fe200078e0202ULL,
0xfffffff8383d7812ULL, 0x000fe200078ee215ULL, 0x000000013b177824ULL, 0x000fc400078e0202ULL,
0x000000083b387824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee216ULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff838477812ULL, 0x000fe200078ee217ULL,
0x0000000139167824ULL, 0x100fe200078e023aULL, 0x0000006014147212ULL, 0x000fe200078efcffULL,
0x000000013b387824ULL, 0x000fe400078e023aULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003f14147210ULL, 0x000fc60007fbe0ffULL, 0x00000001493a7824ULL, 0x000fe200078e023aULL,
0x0000006016167212ULL, 0x000fe200078efcffULL, 0x0000008038387825ULL, 0x000fc800078e00ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000006038387212ULL, 0x000fc600078efcffULL,
0x0000000115157824ULL, 0x100fe200028e0641ULL, 0x0000003f16167210ULL, 0x080fe20007fbe0ffULL,
0x00000001490d7824ULL, 0x040fe200078e0202ULL, 0x000000603a3a7212ULL, 0x000fe200078efcffULL,
0x00000008493c7824ULL, 0x000fe400078e00ffULL, 0x0000000117177824ULL, 0x000fe200028e0641ULL,
0x0000003f38387210ULL, 0x080fe40007fbe0ffULL, 0x0000003f3a3a7210ULL, 0x000fe20007fde0ffULL,
0x00000010473f7824ULL, 0x100fe200078e0210ULL, 0xfffffff83c497812ULL, 0x000fe200078ee20dULL,
0x000000103d0d7824ULL, 0x000fc400078e0210ULL, 0x00000010433d7824ULL, 0x100fe400078e0210ULL,
0x0000000139397824ULL, 0x100fe200028e0641ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e2000e101c48ULL, 0x000000013b3b7824ULL, 0x000fe400030e0641ULL,
0x0000001049417824ULL, 0x000fe200078e0210ULL, 0x00000000163d7faeULL, 0x0003e8000d901c48ULL,
0x00000000383f7faeULL, 0x0003e8000d101c48ULL, 0x000000003a417faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001000147824ULL, 0x000fe200078e00ffULL,
0x000064000d417a11ULL, 0x000fc800078038ffULL, 0x0000001014157812ULL, 0x000fe400078ec0ffULL,
0x000065000d437a11ULL, 0x000fe400000f3cffULL, 0x0000001502157211ULL, 0x000fc800078fe8ffULL,
0x0000000415177810ULL, 0x040fe20007ffe0ffULL, 0x0000000115167824ULL, 0x040fe200078e0202ULL,
0x0000000815397810ULL, 0x040fe20007ffe0ffULL, 0x00000008153f7824ULL, 0x040fe200078e00ffULL,
0x0000000c153b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000115147824ULL, 0x000fe400078e023aULL,
0x0000000117157824ULL, 0x000fe200078e0202ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee216ULL,
0x00000008173e7824ULL, 0x000fe400078e00ffULL, 0x0000000139167824ULL, 0x000fc400078e0202ULL,
0x0000000839497824ULL, 0x000fe200078e00ffULL, 0xfffffff83e477812ULL, 0x000fe200078ee215ULL,
0x00000001173c7824ULL, 0x000fe400078e023aULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fc600078ee216ULL, 0x0000000139387824ULL, 0x100fe200078e023aULL,
0x0000006014167212ULL, 0x000fe200078efcffULL, 0x000000013b3a7824ULL, 0x000fe400078e023aULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000004116167210ULL, 0x000fc60007f1e0ffULL,
0x000000013b177824ULL, 0x040fe200078e0202ULL, 0x000000603c147212ULL, 0x080fe200078efcffULL,
0x000000083b407824ULL, 0x000fe400078e00ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000004114147210ULL, 0x000fe40007f5e0ffULL, 0xfffffff8404b7812ULL, 0x000fe200078ee217ULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000006038387212ULL, 0x000fc600078efcffULL,
0x0000000115177824ULL, 0x100fe200000e0643ULL, 0x000000603a3a7212ULL, 0x000fe200078efcffULL,
0x000000013d157824ULL, 0x100fe200010e0643ULL, 0x0000004138387210ULL, 0x080fe20007f1e0ffULL,
0x000000103f0d7824ULL, 0x100fe200078e0210ULL, 0x000000413a3a7210ULL, 0x000fe20007f7e0ffULL,
0x00000010473d7824ULL, 0x100fe400078e0210ULL, 0x0000000139397824ULL, 0x000fe200000e0643ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000160d7faeULL, 0x0003e2000b901c48ULL,
0x00000010493f7824ULL, 0x000fc400078e0210ULL, 0x000000013b3b7824ULL, 0x000fe200018e0643ULL,
0x00000000143d7faeULL, 0x0003e2000b901c48ULL, 0x000000104b417824ULL, 0x000fc600078e0210ULL,
0x00000000383f7faeULL, 0x0003e8000b901c48ULL, 0x000000003a417faeULL, 0x0003e4000b901c48ULL,
0x000000007c0573c2ULL, 0x000ea200000e0000ULL, 0x000000025f5f7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0d7424ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000795f00720cULL, 0x000fda0003f06070ULL, 0x000000015f148824ULL, 0x000fe400078e0273ULL,
0x00000004ff158424ULL, 0x000fe200078e00ffULL, 0x000176b005057890ULL, 0x004fc6000fffe03fULL,
0x0000660014148625ULL, 0x000fca00078e0015ULL, 0x00000008140d8981ULL, 0x000322000c1e1900ULL,
0x0000000800167824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a05ULL,
0xfffffff016167812ULL, 0x000fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176b00016167f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176480009147f8cULL, 0x0022e4000c80043fULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x01764c00093b7984ULL, 0x000e640000000800ULL,
0x800000003bff7812ULL, 0x00afe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01764c00093b7984ULL, 0x000e640000000800ULL, 0x800000003bff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000097824ULL, 0x000fca00078e00ffULL,
0xffffff8009097812ULL, 0x000fc800078ec0ffULL, 0x0000010060147810ULL, 0x000fca0007ffe009ULL,
0x0000000177147824ULL, 0x000fca00078e0214ULL, 0x0170000014397984ULL, 0x000e680000000800ULL,
0x0172000014387984ULL, 0x0006a20000000800ULL, 0x0000000e3900720bULL, 0x002fe20003f1d000ULL,
0x0000fd427f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff3c3b7812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff3a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fd200078e000eULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x0000000278097810ULL, 0x000fe40007ffe0ffULL,
0x0000000e3900720bULL, 0x000fe40003f54000ULL, 0x000000000900720cULL, 0x000fe20003f05270ULL,
0x0000fcf27f007947ULL, 0x000fd4000b800000ULL, 0x00000000003a7806ULL, 0x000fc400010e0100ULL,
0x0000008000148824ULL, 0x000fe200078e0260ULL, 0x0000000e39097209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x00000001773c8824ULL, 0x000fe200078e0214ULL,
0x000099103a147816ULL, 0x000fc800000000ffULL, 0x017400093c008388ULL, 0x0003e20000000800ULL,
0x000000ff1400720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000e090e7221ULL, 0x002fe20000010100ULL, 0x000000ff3aff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0e0e7820ULL, 0x000fcc0000410000ULL,
0x0000000e000e7308ULL, 0x000e640000000800ULL, 0x0000000e0f0f7220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x000fe20000011602ULL,
0x0000fc327f007947ULL, 0x000fea000b800000ULL, 0x00001f140e3c7589ULL, 0x0002e400000e0000ULL,
0x0000003c18187220ULL, 0x08cfe40000410000ULL, 0x0000003c19197220ULL, 0x080fe40000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe40000410000ULL, 0x0000003c1d1d7220ULL, 0x000fc40000410000ULL,
0x0000003c20207220ULL, 0x080fe40000410000ULL, 0x0000003c21217220ULL, 0x080fe40000410000ULL,
0x0000003c24247220ULL, 0x080fe40000410000ULL, 0x0000003c25257220ULL, 0x080fe40000410000ULL,
0x0000003c28287220ULL, 0x080fe40000410000ULL, 0x0000003c29297220ULL, 0x000fc40000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000003c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000003c30307220ULL, 0x080fe40000410000ULL, 0x0000003c31317220ULL, 0x080fe40000410000ULL,
0x0000003c34347220ULL, 0x080fe40000410000ULL, 0x0000003c35357220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff003aff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802147811ULL, 0x002fe200078ff0ffULL,
0x0000fb327f007947ULL, 0x000fea000b800000ULL, 0x00001f140e3c7589ULL, 0x0002e400000e0000ULL,
0x0000003c1a1a7220ULL, 0x08cfe40000410000ULL, 0x0000003c1b1b7220ULL, 0x080fe40000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe40000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe40000410000ULL,
0x0000003c22227220ULL, 0x080fe40000410000ULL, 0x0000003c23237220ULL, 0x000fc40000410000ULL,
0x0000003c26267220ULL, 0x080fe40000410000ULL, 0x0000003c27277220ULL, 0x080fe40000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe40000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe40000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe40000410000ULL, 0x0000003c2f2f7220ULL, 0x000fc40000410000ULL,
0x0000003c32327220ULL, 0x080fe40000410000ULL, 0x0000003c33337220ULL, 0x080fe40000410000ULL,
0x0000003c36367220ULL, 0x080fe40000410000ULL, 0x0000003c37377220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff3bff7812ULL, 0x000fe2000780603aULL,
0x00000001ff3a7424ULL, 0x000fd800078e00ffULL, 0x8000000939390221ULL, 0x000fe20000010000ULL,
0x00007610ff3a0816ULL, 0x000fc6000000003aULL, 0x3fb8aa3b39390820ULL, 0x000fc80000410000ULL,
0x0000003900080308ULL, 0x000e640000000800ULL, 0x0000000838380220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000f380f7221ULL, 0x004fc40000010000ULL,
0x0000000000147805ULL, 0x000fca0000015200ULL, 0x00000008000e7824ULL, 0x000fca00078e00ffULL,
0xfffffff00e3c7812ULL, 0x000fca00078ec0ffULL, 0x0176ac003c397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x00000038143b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e15ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc80000011439ULL, 0x0000003b0e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x000000020e0e7819ULL, 0x000fc80000001239ULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac003c397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099103a0e7816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0e00720cULL, 0x000fda0003fc5270ULL,
0x0000016000006947ULL, 0x000fea0003800000ULL, 0x00000008ff06723eULL, 0x000fe400000010ffULL,
0x00000002ff137819ULL, 0x000fe40000011602ULL, 0x00005410060e7816ULL, 0x000fe20000000006ULL,
0x0000f7127f007947ULL, 0x000fea000b800000ULL, 0x00001f130e077589ULL, 0x0002a400000e0000ULL,
0x0000000813147810ULL, 0x000fe20007ffe0ffULL, 0x0000f7627f007947ULL, 0x000fea000b800000ULL,
0x00001f140e067589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001013147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e000eULL,
0x00009c80003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000ff5000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001813147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e000eULL, 0x00009cf0003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x004fc400078e00ffULL,
0x0000fee000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001044407824ULL, 0x100fe200078e026dULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001004387824ULL, 0x100fe400078e026dULL, 0x00000010053c7824ULL, 0x004fe400078e026dULL,
0x000000004040783bULL, 0x000ea80000004200ULL, 0x000000003838783bULL, 0x000ee80000004200ULL,
0x000000003c3c783bULL, 0x000e620000004200ULL, 0x00000018ff047819ULL, 0x004fe20000011440ULL,
0x0000004000687306ULL, 0x000fe20000005400ULL, 0x00000018ff127819ULL, 0x000fe20000011442ULL,
0x0001000040647824ULL, 0x000fe200078e00ffULL, 0x00000018ff057819ULL, 0x008fc40000011438ULL,
0x00000018ff0e7819ULL, 0x002fe40000011441ULL, 0x00000018ff137819ULL, 0x000fe20000011439ULL,
0x0000000400677306ULL, 0x000fe20000209400ULL, 0x00000018ff4b7819ULL, 0x000fe4000001143dULL,
0x00000018ff697819ULL, 0x000fe4000001143eULL, 0x00000018ff727819ULL, 0x000fc60000011464ULL,
0x0000000400147306ULL, 0x000e700000205400ULL, 0x00000004004c7306ULL, 0x0004f0000020d400ULL,
0x0000000500467306ULL, 0x000fe20000209400ULL, 0x00000018ff047819ULL, 0x004fc40000011443ULL,
0x000000146700720bULL, 0x002fe20003f5d000ULL, 0x0000010041147824ULL, 0x000fc800078e00ffULL,
0x00000004005d7306ULL, 0x000ff00000209400ULL, 0x00000004005e7306ULL, 0x000fe20000205400ULL,
0x000000014c4c2812ULL, 0x008fce00078efcffULL, 0x0000000400637306ULL, 0x0003f0000020d400ULL,
0x0000000500477306ULL, 0x000fe20000205400ULL, 0x00000018ff047819ULL, 0x002fce000001143bULL,
0x00000005005b7306ULL, 0x0003f0000020d400ULL, 0x0000000400517306ULL, 0x000fe20000209400ULL,
0x00000018ff057819ULL, 0x002fce000001143cULL, 0x0000000400527306ULL, 0x000ff00000205400ULL,
0x0000000400567306ULL, 0x0003f0000020d400ULL, 0x00000005004d7306ULL, 0x000fe20000209400ULL,
0x0000010040047824ULL, 0x002fca00078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011404ULL,
0x00000005004e7306ULL, 0x000ff00000205400ULL, 0x0000000500157306ULL, 0x000ff0000020d400ULL,
0x0000004000057306ULL, 0x000e700000009400ULL, 0x0000004100617306ULL, 0x000ff00000009400ULL,
0x0000004100627306ULL, 0x000ea20000005400ULL, 0x000000680500720bULL, 0x002fce0003f7d000ULL,
0x0000006a00667306ULL, 0x000ff00000209400ULL, 0x0000006a006f7306ULL, 0x000e620000205400ULL,
0x000000626100720bULL, 0x004fe20003f9d000ULL, 0x0001000041627824ULL, 0x000fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011462ULL, 0x0000001200447306ULL, 0x000ff00000209400ULL,
0x0000001200577306ULL, 0x000fe20000205400ULL, 0x0000006f6600720bULL, 0x002fce0003fbd000ULL,
0x0000001200657306ULL, 0x0003f0000020d400ULL, 0x0000006a00047306ULL, 0x0004e2000020d400ULL,
0x00000018ff127819ULL, 0x002fce000001143aULL, 0x0000000e00537306ULL, 0x000fe20000209400ULL,
0x00000018ff6a7819ULL, 0x004fce0000011414ULL, 0x0000000e00587306ULL, 0x000e620000205400ULL,
0x0000000104045812ULL, 0x008fce00078efcffULL, 0x0000000e005c7306ULL, 0x000eb0000020d400ULL,
0x0000001300507306ULL, 0x000fe20000209400ULL, 0x000000585300720bULL, 0x002fce0003f1d000ULL,
0x0000001300557306ULL, 0x000fec0000205400ULL, 0x000000015c5c0812ULL, 0x004fe400078efcffULL,
0x00000013005a7306ULL, 0x000fe2000020d400ULL, 0x000000574400720bULL, 0x000fce0003f1d000ULL,
0x00000012000e7306ULL, 0x000fec0000209400ULL, 0x0000000165650812ULL, 0x000fe400078efcffULL,
0x00000012004f7306ULL, 0x000ff00000205400ULL, 0x0000001200547306ULL, 0x000ff0000020d400ULL,
0x0000004b00597306ULL, 0x000ff00000209400ULL, 0x0000004b00487306ULL, 0x000ff00000205400ULL,
0x0000004b00137306ULL, 0x000ff0000020d400ULL, 0x0000006900497306ULL, 0x000ff00000209400ULL,
0x00000069004a7306ULL, 0x000ff00000205400ULL, 0x0000006900127306ULL, 0x000ff0000020d400ULL,
0x00000040004b7306ULL, 0x000e70000000d400ULL, 0x0000004100057306ULL, 0x0004f0000000d400ULL,
0x0000007200647306ULL, 0x000fe20000209400ULL, 0x0000010042417824ULL, 0x004fe200078e00ffULL,
0x000000014b4b3812ULL, 0x002fc800078efcffULL, 0x0000004b0404723eULL, 0x000fe400000010ffULL,
0x0000007200697306ULL, 0x000e620000205400ULL, 0x0000000105054812ULL, 0x008fce00078efcffULL,
0x0000006a00407306ULL, 0x000ff00000209400ULL, 0x0000006a00617306ULL, 0x000ea20000205400ULL,
0x000000696400720bULL, 0x002fce0003fbd000ULL, 0x00000072006c7306ULL, 0x0002f0000020d400ULL,
0x0000007400627306ULL, 0x000fe20000209400ULL, 0x00000018ff727819ULL, 0x002fe20000011441ULL,
0x0000010043417824ULL, 0x000fe200078e00ffULL, 0x000000614000720bULL, 0x004fca0003f7d000ULL,
0x0000007200687306ULL, 0x000fe20000209400ULL, 0x000000016c6c5812ULL, 0x008fce00078efcffULL,
0x00000072006f7306ULL, 0x000e700000205400ULL, 0x0000007400677306ULL, 0x000eb00000205400ULL,
0x0000006a00147306ULL, 0x0006a2000020d400ULL, 0x0000006f6800720bULL, 0x002fce0003f5d000ULL,
0x0000004200407306ULL, 0x000fe20000009400ULL, 0x00000018ff6a7819ULL, 0x008fe40000011441ULL,
0x000000676200720bULL, 0x004fe20003fbd000ULL, 0x0001000043677824ULL, 0x000fc800078e00ffULL,
0x0000004200697306ULL, 0x000e620000005400ULL, 0x0000000114143812ULL, 0x000fc800078efcffULL,
0x000000051405723eULL, 0x000fc600000010ffULL, 0x0000004300617306ULL, 0x000ff00000009400ULL,
0x0000004300687306ULL, 0x000ea20000005400ULL, 0x000000694000720bULL, 0x002fe20003f7d000ULL,
0x0001000042407824ULL, 0x000fca00078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011440ULL,
0x0000007400667306ULL, 0x000e70000020d400ULL, 0x0000006a00647306ULL, 0x000fe20000209400ULL,
0x000000686100720bULL, 0x004fce0003f9d000ULL, 0x0000006a00417306ULL, 0x000ea20000205400ULL,
0x0000000166665812ULL, 0x002fce00078efcffULL, 0x0000006a00537306ULL, 0x000e70000020d400ULL,
0x0000007200587306ULL, 0x000662000020d400ULL, 0x000000416400720bULL, 0x004fe20003fbd000ULL,
0x0000010038417824ULL, 0x000fca00078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011441ULL,
0x0000006200407306ULL, 0x000fe20000209400ULL, 0x00000018ff727819ULL, 0x008fca0000011467ULL,
0x0000000153535812ULL, 0x002fe400078efcffULL, 0x0000006200617306ULL, 0x000e620000205400ULL,
0x0000000158582812ULL, 0x000fe400078efcffULL, 0x0000005e5d00720bULL, 0x000fca0003f5d000ULL,
0x0000004200697306ULL, 0x000eb0000000d400ULL, 0x00000043006a7306ULL, 0x000ee2000000d400ULL,
0x000000614000720bULL, 0x002fe40003fbd000ULL, 0x0000000163632812ULL, 0x000fca00078efcffULL,
0x0000007200427306ULL, 0x000fe20000209400ULL, 0x0000000169693812ULL, 0x004fe400078efcffULL,
0x000000474600720bULL, 0x000fca0003f7d000ULL, 0x00000072006f7306ULL, 0x000e620000205400ULL,
0x000000016a6a4812ULL, 0x008fce00078efcffULL, 0x0000006200687306ULL, 0x000ea2000020d400ULL,
0x000000015b5b3812ULL, 0x000fe400078efcffULL, 0x0000006f4200720bULL, 0x002fca0003f9d000ULL,
0x0000006400417306ULL, 0x000fe20000209400ULL, 0x0000010039427824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fc8000001143fULL, 0x00000018ff577819ULL, 0x000fe40000011442ULL,
0x0000006400447306ULL, 0x000e620000205400ULL, 0x0000000168685812ULL, 0x004fe400078efcffULL,
0x000000555000720bULL, 0x000fca0003fbd000ULL, 0x0000007200677306ULL, 0x0004f0000020d400ULL,
0x0000003800407306ULL, 0x000fe20000009400ULL, 0x000000444100720bULL, 0x002fe20003f1d000ULL,
0x0001000039727824ULL, 0x004fe200078e00ffULL, 0x000000015a5a5812ULL, 0x000fc800078efcffULL,
0x00000018ff727819ULL, 0x000fe20000011472ULL, 0x0000003800437306ULL, 0x000e620000005400ULL,
0x0000000167674812ULL, 0x008fce00078efcffULL, 0x0000005700427306ULL, 0x000ff00000209400ULL,
0x0000005700557306ULL, 0x000ea20000205400ULL, 0x000000434000720bULL, 0x002fe20003f9d000ULL,
0x0000001003407824ULL, 0x000fc400078e026dULL, 0x0001000038037824ULL, 0x000fc800078e00ffULL,
0x00000064005e7306ULL, 0x000e62000020d400ULL, 0x00000018ff037819ULL, 0x000fce0000011403ULL,
0x0000003900467306ULL, 0x000fe20000009400ULL, 0x000000554200720bULL, 0x004fe40003f5d000ULL,
0x000000004040783bULL, 0x000eaa0000004200ULL, 0x0000003900477306ULL, 0x000ee20000005400ULL,
0x000000015e5e0812ULL, 0x002fce00078efcffULL, 0x0000003800627306ULL, 0x000e62000000d400ULL,
0x000000474600720bULL, 0x008fce0003f1d000ULL, 0x0000003900647306ULL, 0x000ee2000000d400ULL,
0x012000004544783bULL, 0x000ea20000000200ULL, 0x0000000162624812ULL, 0x002fcc00078efcffULL,
0x0000000300387306ULL, 0x000fe20000209400ULL, 0x0000004f0e00720bULL, 0x000fce0003f9d000ULL,
0x0000000300557306ULL, 0x000e620000205400ULL, 0x0000000164640812ULL, 0x008fe400078efcffULL,
0x00000018ff757819ULL, 0x004fe40000011442ULL, 0x00000018ff747819ULL, 0x000fe40000011441ULL,
0x0000000154544812ULL, 0x000fe200078efcffULL, 0x0000005700617306ULL, 0x000eb0000020d400ULL,
0x00000003005d7306ULL, 0x000ee2000020d400ULL, 0x000000553800720bULL, 0x002fc40003f1d000ULL,
0x00000018ff387819ULL, 0x000fca0000011440ULL, 0x0000007200147306ULL, 0x000fe20000209400ULL,
0x0000000161612812ULL, 0x004fe200078efcffULL, 0x000000074444e231ULL, 0x080fe200003400ffULL,
0x000000525100720bULL, 0x000fe20003f5d000ULL, 0x000000074646e231ULL, 0x000fe400003400ffULL,
0x000000064545e231ULL, 0x080fe400003400ffULL, 0x0000007200397306ULL, 0x000e620000205400ULL,
0x000000015d5d0812ULL, 0x008fe200078efcffULL, 0x000000064747e231ULL, 0x000fcc00003400ffULL,
0x0000003800517306ULL, 0x000fe20000209400ULL, 0x000000044418723cULL, 0x000f620000041818ULL,
0x0000000156562812ULL, 0x000fe400078efcffULL, 0x0000004e4d00720bULL, 0x000fe20003f5d000ULL,
0x00000100404d7824ULL, 0x000fe200078e00ffULL, 0x000000391400720bULL, 0x002fe40003f1d000ULL,
0x0000003800557306ULL, 0x000fe20000205400ULL, 0x000000665c39723eULL, 0x000fce00000010ffULL,
0x0000003800147306ULL, 0x0003e2000020d400ULL, 0x0000000115152812ULL, 0x000fce00078efcffULL,
0x0000006f00507306ULL, 0x000fe20000209400ULL, 0x0000006c4c38723eULL, 0x002fce00000010ffULL,
0x0000006f004f7306ULL, 0x000fe20000205400ULL, 0x00000038441c723cULL, 0x000b6e000004181cULL,
0x0000006f000e7306ULL, 0x0003e2000020d400ULL, 0x000000695838723eULL, 0x020fe200000010ffULL,
0x000001003b697824ULL, 0x000fe200078e00ffULL, 0x0000006a5339723eULL, 0x000fc800000010ffULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0000003b006a7306ULL, 0x000fe20000009400ULL,
0x000001003a6f7824ULL, 0x002fe200078e00ffULL, 0x000000384420723cULL, 0x000be80000041820ULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000006900587306ULL, 0x000fe20000209400ULL,
0x000000686538723eULL, 0x020fe200000010ffULL, 0x000100003b687824ULL, 0x000fca00078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x0000006f00037306ULL, 0x000ff00000209400ULL,
0x0000006f00047306ULL, 0x000e700000205400ULL, 0x0000006f005c7306ULL, 0x000eb0000020d400ULL,
0x00000069006f7306ULL, 0x000ee20000205400ULL, 0x000000040300720bULL, 0x002fce0003f7d000ULL,
0x0000003b00397306ULL, 0x000e6c0000005400ULL, 0x000000015c5c3812ULL, 0x004fe400078efcffULL,
0x0000007200667306ULL, 0x0004a2000020d400ULL, 0x0000006f5800720bULL, 0x008fe20003fbd000ULL,
0x000100003a6f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001146fULL,
0x0000003a00057306ULL, 0x000fe20000009400ULL, 0x000000396a00720bULL, 0x002fe40003f7d000ULL,
0x000000676339723eULL, 0x000fe400000010ffULL, 0x00000018ff727819ULL, 0x004fc60000011443ULL,
0x0000003a00537306ULL, 0x000e620000005400ULL, 0x0000000166660812ULL, 0x000fe200078efcffULL,
0x000000384424723cULL, 0x000b6c0000041824ULL, 0x0000006900697306ULL, 0x000ea2000020d400ULL,
0x000000625e38723eULL, 0x020fe200000010ffULL, 0x000001003c5e7824ULL, 0x000fe200078e00ffULL,
0x000000646139723eULL, 0x000fca00000010ffULL, 0x0000003a006a7306ULL, 0x000ee2000000d400ULL,
0x000000530500720bULL, 0x002fe20003f1d000ULL, 0x000000384428723cULL, 0x000b6c0000041828ULL,
0x0000006f006c7306ULL, 0x000fe20000209400ULL, 0x0000000169695812ULL, 0x004fe400078efcffULL,
0x0000005d5b38723eULL, 0x020fc400000010ffULL, 0x000000665a39723eULL, 0x000fc600000010ffULL,
0x0000006f00637306ULL, 0x000e620000205400ULL, 0x000000016a6a0812ULL, 0x008fc600078efcffULL,
0x00000038442c723cULL, 0x000be8000004182cULL, 0x0000006800657306ULL, 0x000fe60000209400ULL,
0x0000006a5c38723eULL, 0x020fca00000010ffULL, 0x0000006800677306ULL, 0x000ea20000205400ULL,
0x000000636c00720bULL, 0x002fe20003f1d000ULL, 0x000100003c637824ULL, 0x000fca00078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x0000003b003a7306ULL, 0x000e70000000d400ULL,
0x0000006f003b7306ULL, 0x000ee2000020d400ULL, 0x000000676500720bULL, 0x004fce0003fbd000ULL,
0x0000006800647306ULL, 0x000ea2000020d400ULL, 0x000000013a3a3812ULL, 0x002fc800078efcffULL,
0x0000003a6939723eULL, 0x000fe400000010ffULL, 0x000000013b3b0812ULL, 0x008fe200078efcffULL,
0x0000007200537306ULL, 0x000fe80000209400ULL, 0x000000384430723cULL, 0x000b620000041830ULL,
0x0000000164645812ULL, 0x004fc600078efcffULL, 0x0000007200587306ULL, 0x000fe60000205400ULL,
0x0000003b5438723eULL, 0x020fe200000010ffULL, 0x000001003d3b7824ULL, 0x000fe200078e00ffULL,
0x000000645639723eULL, 0x000fc600000010ffULL, 0x0000007200057306ULL, 0x0003e2000020d400ULL,
0x00000018ff3b7819ULL, 0x000fc6000001143bULL, 0x000000384434723cULL, 0x000b680000041834ULL,
0x0000003d005c7306ULL, 0x000fe20000009400ULL, 0x00000018ff727819ULL, 0x002fe4000001145eULL,
0x000100003d387824ULL, 0x020fca00078e00ffULL, 0x00000018ff447819ULL, 0x000fe20000011438ULL,
0x000001003e387824ULL, 0x000fe200078e00ffULL, 0x0000007200617306ULL, 0x000ff00000209400ULL,
0x0000007200627306ULL, 0x000e700000205400ULL, 0x0000003d00657306ULL, 0x000eb00000005400ULL,
0x0000003d00547306ULL, 0x0006a2000000d400ULL, 0x000000626100720bULL, 0x002fc40003f7d000ULL,
0x00000018ff627819ULL, 0x000fca000001144dULL, 0x0000003e00397306ULL, 0x000fe20000009400ULL,
0x00000018ff3d7819ULL, 0x008fe40000011438ULL, 0x000000655c00720bULL, 0x004fca0003f9d000ULL,
0x0000003e00387306ULL, 0x000e700000005400ULL, 0x0000003c005b7306ULL, 0x000fe20000009400ULL,
0x0000000154544812ULL, 0x000fe400078efcffULL, 0x0000004a4900720bULL, 0x000fe20003f9d000ULL,
0x00010000404a7824ULL, 0x000fc800078e00ffULL, 0x0000003c005d7306ULL, 0x000ea20000005400ULL,
0x000000383900720bULL, 0x002fe20003fbd000ULL, 0x000100003e387824ULL, 0x000fca00078e00ffULL,
0x00000018ff397819ULL, 0x000fe20000011438ULL, 0x00000072005e7306ULL, 0x000e62000020d400ULL,
0x000100003f387824ULL, 0x000fe200078e00ffULL, 0x0000000112124812ULL, 0x000fcc00078efcffULL,
0x00000063003a7306ULL, 0x000fe20000209400ULL, 0x0000005d5b00720bULL, 0x004fce0003f1d000ULL,
0x0000006300677306ULL, 0x000ea20000205400ULL, 0x000000015e5e3812ULL, 0x002fce00078efcffULL,
0x0000003d00697306ULL, 0x000ff00000209400ULL, 0x0000003d006a7306ULL, 0x000fe20000205400ULL,
0x000000673a00720bULL, 0x004fce0003f7d000ULL, 0x0000003d00567306ULL, 0x0003f0000020d400ULL,
0x0000003b00667306ULL, 0x000fe20000209400ULL, 0x00000007023d7812ULL, 0x002fc800078ec0ffULL,
0x000000083d3d7812ULL, 0x000fc600078ef802ULL, 0x0000003b00727306ULL, 0x000e640000205400ULL,
0x000000083d3a7824ULL, 0x000fe200078e00ffULL, 0x000000026b3d7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff83a3d7812ULL, 0x000fe200078ee23dULL, 0x0000003b00647306ULL, 0x0004f0000020d400ULL,
0x0000003c005a7306ULL, 0x000ee2000000d400ULL, 0x000001003f3b7824ULL, 0x004fe200078e00ffULL,
0x000000726600720bULL, 0x002fc80003f5d000ULL, 0x00000018ff477819ULL, 0x000fe4000001143bULL,
0x0000003f003b7306ULL, 0x000fee0000009400ULL, 0x0000000164642812ULL, 0x008fe200078efcffULL,
0x0000003f004e7306ULL, 0x000e620000005400ULL, 0x000000015a5a0812ULL, 0x000fc800078efcffULL,
0x0000005a5e5a723eULL, 0x000fc600000010ffULL, 0x0000003f005d7306ULL, 0x0004f0000000d400ULL,
0x00000075004b7306ULL, 0x000fe20000209400ULL, 0x00000018ff3f7819ULL, 0x004fe20000011438ULL,
0x0000020000387824ULL, 0x000fe200078e00ffULL, 0x0000004e3b00720bULL, 0x002fc80003f1d000ULL,
0xfffff80038387812ULL, 0x000fe200078ec0ffULL, 0x00000075004c7306ULL, 0x000fe80000205400ULL,
0x000000103d387824ULL, 0x000fc800078e0238ULL, 0x0000007500037306ULL, 0x000fe2000020d400ULL,
0x000000015d5d0812ULL, 0x008fce00078efcffULL, 0x0000003e005c7306ULL, 0x000e70000000d400ULL,
0x00000039003e7306ULL, 0x000ff00000209400ULL, 0x0000003900757306ULL, 0x000fe20000205400ULL,
0x000000015c5c5812ULL, 0x002fc400078efcffULL, 0x0000004f5000720bULL, 0x000fca0003fbd000ULL,
0x0000003900617306ULL, 0x0003f0000020d400ULL, 0x00000063003c7306ULL, 0x000ea2000020d400ULL,
0x012000003838783bULL, 0x002e620000000200ULL, 0x000000010e0e5812ULL, 0x000fcc00078efcffULL,
0x00000044006c7306ULL, 0x000ff00000209400ULL, 0x0000004400687306ULL, 0x000ee20000205400ULL,
0x000000013c3c3812ULL, 0x004fe400078efcffULL, 0x000000485900720bULL, 0x000fca0003f7d000ULL,
0x0000004700457306ULL, 0x000ff00000209400ULL, 0x0000004700467306ULL, 0x000ea20000205400ULL,
0x000000686c00720bULL, 0x008fe40003f5d000ULL, 0x0000000113133812ULL, 0x000fca00078efcffULL,
0x0000007400527306ULL, 0x000fe20000209400ULL, 0x000000073838e231ULL, 0x082fe400003400ffULL,
0x000000073a3ae231ULL, 0x000fe400003400ffULL, 0x000000063939e231ULL, 0x080fe400003400ffULL,
0x000000063b3be231ULL, 0x000fe200003400ffULL, 0x0000007400577306ULL, 0x000fe20000205400ULL,
0x0000006a6900720bULL, 0x000fce0003fdd000ULL, 0x0000007400047306ULL, 0x000fec000020d400ULL,
0x0000000156566812ULL, 0x000fe400078efcffULL, 0x0000004400637306ULL, 0x000e62000020d400ULL,
0x000000464500720bULL, 0x004fce0003fdd000ULL, 0x00000062006f7306ULL, 0x000ff00000209400ULL,
0x0000006200747306ULL, 0x000ea20000205400ULL, 0x0000000163632812ULL, 0x002fce00078efcffULL,
0x00000062004d7306ULL, 0x000e70000020d400ULL, 0x0000004000487306ULL, 0x000fe20000009400ULL,
0x000000746f00720bULL, 0x004fce0003f9d000ULL, 0x0000004000597306ULL, 0x000eac0000005400ULL,
0x000000014d4d4812ULL, 0x002fe400078efcffULL, 0x0000004100497306ULL, 0x000ff00000009400ULL,
0x0000004100627306ULL, 0x000e620000005400ULL, 0x000000594800720bULL, 0x004fce0003f5d000ULL,
0x0000004700447306ULL, 0x000eb0000020d400ULL, 0x0000003f005b7306ULL, 0x000fe20000209400ULL,
0x000000624900720bULL, 0x002fe20003f7d000ULL, 0x0001000041627824ULL, 0x000fca00078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011462ULL, 0x0000003f004e7306ULL, 0x000e620000205400ULL,
0x0000000144446812ULL, 0x004fe400078efcffULL, 0x000000753e00720bULL, 0x000fe20003fdd000ULL,
0x00000100433e7824ULL, 0x000fc800078e00ffULL, 0x0000003f00477306ULL, 0x0004f0000020d400ULL,
0x0000004100487306ULL, 0x0006e2000000d400ULL, 0x00000100413f7824ULL, 0x004fe200078e00ffULL,
0x0000004e5b00720bULL, 0x002fc40003f1d000ULL, 0x0000000161616812ULL, 0x000fe400078efcffULL,
0x00000018ff657819ULL, 0x000fe4000001143fULL, 0x0000004000597306ULL, 0x000e62000000d400ULL,
0x0000010042417824ULL, 0x048fe200078e00ffULL, 0x000000555100720bULL, 0x000fe20003fdd000ULL,
0x0001000042557824ULL, 0x000fe200078e00ffULL, 0x00000054645b723eULL, 0x000fe400000010ffULL,
0x00000018ff697819ULL, 0x000fc40000011441ULL, 0x0000006500727306ULL, 0x000fe20000209400ULL,
0x0000000147470812ULL, 0x000fe400078efcffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000005a3818723cULL, 0x000f620000041818ULL, 0x0000000148483812ULL, 0x000fe400078efcffULL,
0x000000575200720bULL, 0x000fe20003f7d000ULL, 0x0000006500767306ULL, 0x000ea20000205400ULL,
0x000000611212723eULL, 0x000fe400000010ffULL, 0x0000000159592812ULL, 0x002fc400078efcffULL,
0x0000000114146812ULL, 0x000fe400078efcffULL, 0x0000004c4b00720bULL, 0x000fe20003fdd000ULL,
0x00000065003f7306ULL, 0x0002e8000020d400ULL, 0x0000000104043812ULL, 0x000fc800078efcffULL,
0x0000004200417306ULL, 0x000fe20000009400ULL, 0x00000018ff657819ULL, 0x002fe4000001144aULL,
0x000000767200720bULL, 0x004fe40003f1d000ULL, 0x0000000103036812ULL, 0x000fc600078efcffULL,
0x0000006500407306ULL, 0x000ff00000209400ULL, 0x0000006500497306ULL, 0x000e620000205400ULL,
0x000000013f3f0812ULL, 0x008fce00078efcffULL, 0x00000042004e7306ULL, 0x000eb00000005400ULL,
0x00000065004a7306ULL, 0x000ee2000020d400ULL, 0x000000494000720bULL, 0x002fe40003fbd000ULL,
0x0000003c1540723eULL, 0x000fca00000010ffULL, 0x0000006800667306ULL, 0x000fe20000209400ULL,
0x0000004e4100720bULL, 0x004fe20003f9d000ULL, 0x0001000043417824ULL, 0x000fca00078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011441ULL, 0x0000006800677306ULL, 0x000e620000205400ULL,
0x000000014a4a5812ULL, 0x008fe400078efcffULL, 0x000000631341723eULL, 0x000fe400000010ffULL,
0x000000470e13723eULL, 0x000fe400000010ffULL, 0x0000004a1414723eULL, 0x000fe200000010ffULL,
0x0000006900627306ULL, 0x000fe40000209400ULL, 0x00000040381c723cULL, 0x040b6c000004181cULL,
0x0000006900657306ULL, 0x000ea20000205400ULL, 0x000000676600720bULL, 0x002fe20003f1d000ULL,
0x000000123824723cULL, 0x000b640000041824ULL, 0x000000594d40723eULL, 0x020fc400000010ffULL,
0x000000483f41723eULL, 0x000fe400000010ffULL, 0x0000006800457306ULL, 0x0002ea000020d400ULL,
0x000000403828723cULL, 0x000f660000041828ULL, 0x0000006900467306ULL, 0x000ee2000020d400ULL,
0x00000018ff687819ULL, 0x002fc4000001143eULL, 0x000000656200720bULL, 0x004fca0003fbd000ULL,
0x0000006800507306ULL, 0x000fe20000209400ULL, 0x0000000145450812ULL, 0x008fe400078efcffULL,
0x000000585300720bULL, 0x000fca0003f1d000ULL, 0x00000068004f7306ULL, 0x000e620000205400ULL,
0x0000000146465812ULL, 0x000fce00078efcffULL, 0x00000068003e7306ULL, 0x000ea2000020d400ULL,
0x0000000105050812ULL, 0x000fce00078efcffULL, 0x00000042004e7306ULL, 0x0006a2000000d400ULL,
0x0000004f5000720bULL, 0x002fce0003f7d000ULL, 0x0000004300687306ULL, 0x000fe20000009400ULL,
0x0000005c5642723eULL, 0x008fca00000010ffULL, 0x000000013e3e3812ULL, 0x004fe400078efcffULL,
0x0000004300697306ULL, 0x000e620000005400ULL, 0x000000014e4e4812ULL, 0x000fc800078efcffULL,
0x0000004e4646723eULL, 0x000fc600000010ffULL, 0x0000005500517306ULL, 0x000ff00000209400ULL,
0x0000005500547306ULL, 0x000ea20000205400ULL, 0x000000696800720bULL, 0x002fce0003f5d000ULL,
0x00000015003c7306ULL, 0x000ff00000209400ULL, 0x0000001500577306ULL, 0x000e620000205400ULL,
0x000000545100720bULL, 0x004fce0003fbd000ULL, 0x0000004300497306ULL, 0x0004f0000000d400ULL,
0x00000055000e7306ULL, 0x000ee2000020d400ULL, 0x000000573c00720bULL, 0x002fe40003f9d000ULL,
0x0000005d4443723eULL, 0x004fca00000010ffULL, 0x0000001500127306ULL, 0x0002a2000020d400ULL,
0x0000000149492812ULL, 0x008fe200078efcffULL, 0x000000423820723cULL, 0x040f660000041820ULL,
0x000000493e47723eULL, 0x000fe400000010ffULL, 0x000000010e0e5812ULL, 0x000fe400078efcffULL,
0x000000450415723eULL, 0x002fe400000010ffULL, 0x0000000e0304723eULL, 0x000fe200000010ffULL,
0x000000463830723cULL, 0x000f620000041830ULL, 0x0001769878037811ULL, 0x000fc400078e18ffULL,
0x0000000112124812ULL, 0x004fc800078efcffULL, 0x000000120505723eULL, 0x000fe200000010ffULL,
0x00000014382c723cULL, 0x040b6e000004182cULL, 0x000176c80c147811ULL, 0x020fe200078e18ffULL,
0x000000043834723cULL, 0x000b620000041834ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000014147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000003ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0e7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x020fc80000015200ULL,
0x000004000a037984ULL, 0x004ea40000000800ULL, 0x8000000003ff7812ULL, 0x006fc40007804815ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001204127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e05ULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011413ULL, 0x0000001203037211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x0000000203037819ULL, 0x000fc80000001212ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000a037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010b047810ULL, 0x000fc80007ffe0ffULL,
0x000000710400720cULL, 0x000fda0003f06070ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x000000020b047810ULL, 0x000fe20007ffe0ffULL, 0x000059000d037a24ULL, 0x010fe200078e02ffULL,
0x0000010011117810ULL, 0x000fe40007ffe0ffULL, 0x000000710400720cULL, 0x000fe20003f06070ULL,
0x0000008003037824ULL, 0x000fe200078e00ffULL, 0x0000006011057812ULL, 0x000fca00078ec0ffULL,
0x000000016e057824ULL, 0x000fcc00078e0205ULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x0000001170047217ULL, 0x000fe20007800000ULL, 0x00000010000a7824ULL, 0x000fc800078e00ffULL,
0x0000000104047824ULL, 0x000fe200078e0a11ULL, 0x000000100a117812ULL, 0x000fe400078ec0ffULL,
0x00000003ff0a7819ULL, 0x000fe40000011602ULL, 0x0000000411047217ULL, 0x000fe40007800000ULL,
0x000000040a0e7810ULL, 0x040fe40007ffe0ffULL, 0x000000080a127810ULL, 0x000fe20007ffe0ffULL,
0x0000000104047824ULL, 0x100fe200078e0a11ULL, 0x0000000c0a147810ULL, 0x000fe20007ffe0ffULL,
0x000000010e387824ULL, 0x000fc400078e0211ULL, 0x0000000112137824ULL, 0x100fe200078e0211ULL,
0x000000040a00720cULL, 0x0c0fe20003f86070ULL, 0x000000010a0a7824ULL, 0x100fe200078e0211ULL,
0x000000041200720cULL, 0x080fe20003f46070ULL, 0x0000000138127824ULL, 0x100fe200078e0202ULL,
0x000000040e00720cULL, 0x080fe20003f66070ULL, 0x0000000838397824ULL, 0x000fe200078e00ffULL,
0x000000041400720cULL, 0x000fe20003f06070ULL, 0x000000010a0e7824ULL, 0x040fe400078e0202ULL,
0x000000080a157824ULL, 0x000fe200078e00ffULL, 0xfffffff8393a7812ULL, 0x000fe200078ee212ULL,
0x0000000114117824ULL, 0x000fc400078e0211ULL, 0x000000010a147824ULL, 0x100fe200078e0205ULL,
0xfffffff8150e7812ULL, 0x000fe200078ee20eULL, 0x0000000138387824ULL, 0x100fe400078e0205ULL,
0x0000000113047824ULL, 0x100fe400078e0205ULL, 0x0000000111127824ULL, 0x000fe400078e0205ULL,
0x00000001130a7824ULL, 0x100fe400078e0202ULL, 0x0000000111057824ULL, 0x000fc400078e0202ULL,
0x00000008113c7824ULL, 0x000fe200078e00ffULL, 0x0000640003117a11ULL, 0x000fe200078a38ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee205ULL,
0x0000000813137824ULL, 0x000fe200078e00ffULL, 0x0000006014147212ULL, 0x080fe200078efcffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000650003037a11ULL, 0x000fe400028f3cffULL,
0xfffffff8130a7812ULL, 0x000fe200078ee20aULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x0000006038387212ULL, 0x000fe400078efcffULL, 0x0000001411147210ULL, 0x000fe20007fbe0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000001138387210ULL, 0x000fc40007fde0ffULL,
0x0000006004047212ULL, 0x080fe200078efcffULL, 0x0000000115157824ULL, 0x100fe200028e0603ULL,
0x0000006012127212ULL, 0x000fe200078efcffULL, 0x0000000139397824ULL, 0x000fe200030e0603ULL,
0x0000001104047210ULL, 0x080fe20007fbe0ffULL, 0x000000103a3b7824ULL, 0x100fe200078e026dULL,
0x0000001112127210ULL, 0x000fe20007fde0ffULL, 0x000000100e117824ULL, 0x100fe400078e026dULL,
0x000000100a3f7824ULL, 0x000fe400078e026dULL, 0x0000000105057824ULL, 0x000fe200028e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014117faeULL, 0x0003e2000e101c48ULL,
0x000000103c6d7824ULL, 0x000fc400078e026dULL, 0x0000000113137824ULL, 0x000fe200030e0603ULL,
0x00000000383b7faeULL, 0x0003e8000d901c48ULL, 0x00000000043f7faeULL, 0x0003e8000d101c48ULL,
0x00000000126d7faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001000047824ULL, 0x000fca00078e00ffULL, 0x0000001004117812ULL, 0x000fc800078ec0ffULL,
0x0000001102117211ULL, 0x000fc800078fe8ffULL, 0x00000004110e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000111047824ULL, 0x040fe200078e0202ULL, 0x0000000c11157810ULL, 0x040fe20007ffe0ffULL,
0x0000000811137824ULL, 0x040fe400078e00ffULL, 0x0000000111387824ULL, 0x100fe400078e0205ULL,
0x0000000115127824ULL, 0x100fe200078e0205ULL, 0xfffffff8130a7812ULL, 0x000fe200078ee204ULL,
0x000000010e047824ULL, 0x040fe200078e0205ULL, 0x0000000811137810ULL, 0x000fe20007ffe0ffULL,
0x000000010e117824ULL, 0x000fc400078e0202ULL, 0x000000080e0e7824ULL, 0x000fe400078e00ffULL,
0x0000000113147824ULL, 0x040fe400078e0205ULL, 0x0000000113057824ULL, 0x040fe200078e0202ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee211ULL, 0x00000008133a7824ULL, 0x000fe200078e00ffULL,
0x0000640003117a11ULL, 0x000fe200078038ffULL, 0x0000008038387825ULL, 0x000fc600078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee205ULL, 0x0000000115137824ULL, 0x040fe200078e0202ULL,
0x0000006038387212ULL, 0x000fe200078efcffULL, 0x00000008153c7824ULL, 0x000fe200078e00ffULL,
0x0000650003037a11ULL, 0x000fe200000f3cffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x0000003811387210ULL, 0x000fe40007f1e0ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000006004047212ULL, 0x000fc600078efcffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000006014147212ULL, 0x000fc600078efcffULL,
0x0000000139397824ULL, 0x000fe200000e0603ULL, 0x0000006012127212ULL, 0x000fe200078efcffULL,
0x000000100e3b7824ULL, 0x100fe200078e026dULL, 0x0000000411047210ULL, 0x040fe20007f1e0ffULL,
0x000000103a3f7824ULL, 0x100fe200078e026dULL, 0x0000001411147210ULL, 0x040fe40007f5e0ffULL,
0x0000001211127210ULL, 0x000fe20007f7e0ffULL, 0x000000100a117824ULL, 0x000fe400078e026dULL,
0x0000000105057824ULL, 0x000fc400000e0603ULL, 0x0000000115157824ULL, 0x000fe200010e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038117faeULL, 0x0003e2000b901c48ULL,
0x000000103c6d7824ULL, 0x000fe400078e026dULL, 0x0000000113137824ULL, 0x000fe200018e0603ULL,
0x00000000043b7faeULL, 0x0003e8000b901c48ULL, 0x00000000143f7faeULL, 0x0003e8000b901c48ULL,
0x00000000126d7faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000100c037824ULL, 0x000fc400078e00ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x0000001003037812ULL, 0x000fe400078ee2ffULL,
0x0000000804047812ULL, 0x000fc600078ec0ffULL, 0x0000002078037824ULL, 0x000fc800078e0203ULL,
0x00000001040a7824ULL, 0x000fe200078e0203ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a8007c047f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x017668000a147f8cULL, 0x000662000c80043fULL,
0x000000ffff037224ULL, 0x004fc600078e0005ULL, 0x0000000000047805ULL, 0x000fc80000015200ULL,
0x01766c000a117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x006fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001204117210ULL, 0x000fca0007f1e1ffULL,
0x0000000113127824ULL, 0x000fe200000e0e05ULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc80000011412ULL,
0x000000110e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0612ULL,
0x000000020e0e7819ULL, 0x000fc80000001211ULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01766c000a117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018078047811ULL, 0x000fc800078e38ffULL, 0x0000000477047210ULL, 0x000fca0007ffe060ULL,
0x01700000040a7984ULL, 0x008e680000000800ULL, 0x0172000004057984ULL, 0x0004e20000000800ULL,
0x000000090a00720bULL, 0x002fe20003f1d000ULL, 0x0000ca327f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x004fc800000e0100ULL, 0x0000ffff3c137812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff047224ULL, 0x000fd200078e0009ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x0000000378117810ULL, 0x000fe40007ffe0ffULL, 0x000000090a00720bULL, 0x000fe40003f54000ULL,
0x000000001100720cULL, 0x000fe20003f05270ULL, 0x0000c9e27f007947ULL, 0x000fd4000b800000ULL,
0x00000000000e7806ULL, 0x000fc400010e0100ULL, 0x0000008000608824ULL, 0x000fe200078e0260ULL,
0x000000090a047209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x000099100e117816ULL, 0x000fe200000000ffULL, 0x0000000177778824ULL, 0x000fca00078e0260ULL,
0x0174000477008388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000904097221ULL, 0x002fe20000010100ULL,
0x000000ff0eff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x0000000900127308ULL, 0x000e640000000800ULL,
0x000000120f0f7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x000fe20000011602ULL, 0x0000c9227f007947ULL, 0x000fea000b800000ULL,
0x00001f14123c7589ULL, 0x0002a400000e0000ULL, 0x0000003c18187220ULL, 0x084fe40000410000ULL,
0x0000003c19197220ULL, 0x080fe40000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe40000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe40000410000ULL, 0x0000003c20207220ULL, 0x080fe40000410000ULL,
0x0000003c21217220ULL, 0x000fc40000410000ULL, 0x0000003c24247220ULL, 0x080fe40000410000ULL,
0x0000003c25257220ULL, 0x080fe40000410000ULL, 0x0000003c28287220ULL, 0x080fe40000410000ULL,
0x0000003c29297220ULL, 0x080fe40000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe40000410000ULL,
0x0000003c2d2d7220ULL, 0x000fc40000410000ULL, 0x0000003c30307220ULL, 0x080fe40000410000ULL,
0x0000003c31317220ULL, 0x080fe40000410000ULL, 0x0000003c34347220ULL, 0x080fe40000410000ULL,
0x0000003c35357220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000eff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802147811ULL, 0x002fe200078ff0ffULL, 0x0000c8227f007947ULL, 0x000fea000b800000ULL,
0x00001f14123c7589ULL, 0x0002a400000e0000ULL, 0x0000003c1a1a7220ULL, 0x084fe40000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe40000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe40000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe40000410000ULL, 0x0000003c22227220ULL, 0x080fe40000410000ULL,
0x0000003c23237220ULL, 0x000fc40000410000ULL, 0x0000003c26267220ULL, 0x080fe40000410000ULL,
0x0000003c27277220ULL, 0x080fe40000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe40000410000ULL,
0x0000003c2b2b7220ULL, 0x080fe40000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe40000410000ULL,
0x0000003c2f2f7220ULL, 0x000fc40000410000ULL, 0x0000003c32327220ULL, 0x080fe40000410000ULL,
0x0000003c33337220ULL, 0x080fe40000410000ULL, 0x0000003c36367220ULL, 0x080fe40000410000ULL,
0x0000003c37377220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff13ff7812ULL, 0x000fe2000780600eULL, 0x00000001ff0e7424ULL, 0x000fd800078e00ffULL,
0x0000000a040a0221ULL, 0x000fe20000010100ULL, 0x00007610ff0e0816ULL, 0x000fc6000000000eULL,
0x3fb8aa3b0a0a0820ULL, 0x000fc80000410000ULL, 0x0000000a00080308ULL, 0x000e640000000800ULL,
0x0000000805050220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000f050f7221ULL, 0x008fc40000010000ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0x0176b4007c057984ULL, 0x000e620000000800ULL, 0x0000000400097824ULL, 0x000fe400078e00ffULL,
0x000000047d0a7824ULL, 0x000fc600078e00ffULL, 0x0000000409117812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x8000000005ff7812ULL, 0x002fe40007804817ULL,
0x0000000211057810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001412147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e13ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff117819ULL, 0x000fc80000011415ULL, 0x0000001411117211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x0000000211117819ULL, 0x000fc80000001214ULL,
0x000000110000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000109097810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0176b4007c117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100e097816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0900720cULL, 0x000fda0003fc5270ULL, 0x0000016000006947ULL, 0x000fea0003800000ULL,
0x00000008ff06723eULL, 0x000fe400000010ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011602ULL,
0x0000541006097816ULL, 0x000fe20000000006ULL, 0x0000c3c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0e09077589ULL, 0x0002a400000e0000ULL, 0x000000080e147810ULL, 0x000fe20007ffe0ffULL,
0x0000c4127f007947ULL, 0x000fea000b800000ULL, 0x00001f1409067589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100e147810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e0009ULL, 0x0000d230003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000c9a000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180e147810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200078e0009ULL,
0x0000d2a0003e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3c7424ULL, 0x004fc400078e00ffULL, 0x0000c93000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000702117812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000378527810ULL, 0x000fe40007ffe0ffULL,
0x0000000811097812ULL, 0x00afc600078ef802ULL, 0x0000080052527824ULL, 0x000fe400078e00ffULL,
0x00000008090e7824ULL, 0x000fca00078e00ffULL, 0xfffffff80e6d7812ULL, 0x000fe400078ee26bULL,
0x00000008020e7812ULL, 0x000fc600078ec0ffULL, 0x000000106d6d7824ULL, 0x000fc400078e0252ULL,
0x0000000a020a7211ULL, 0x000fe400078fe0ffULL, 0x000000110e137212ULL, 0x040fe400078efcffULL,
0x000000100e4b7812ULL, 0x000fc600078efe11ULL, 0x0000000113097824ULL, 0x140fe400078e020aULL,
0x0000000813127824ULL, 0x000fe400078e00ffULL, 0x000000014b0a7824ULL, 0x040fe400078e020aULL,
0x000000084b117824ULL, 0x000fe200078e00ffULL, 0xfffffff812097812ULL, 0x000fe400078ee209ULL,
0x0000000502127211ULL, 0x000fe400078fe0ffULL, 0xfffffff811117812ULL, 0x000fe200078ee20aULL,
0x0000001009097824ULL, 0x000fc400078e0210ULL, 0x0000000113057824ULL, 0x000fe400078e0212ULL,
0x0000001011117824ULL, 0x000fe200078e0210ULL, 0x000000000938783bULL, 0x000e680000004200ULL,
0x000000001114783bULL, 0x000ee20000004200ULL, 0x00000018ff0a7819ULL, 0x002fe20000011438ULL,
0x0000003800657306ULL, 0x000fe20000009400ULL, 0x0000010038567824ULL, 0x000fe200078e00ffULL,
0x00000018ff097819ULL, 0x000fc40000011439ULL, 0x00000018ff0e7819ULL, 0x008fe40000011414ULL,
0x00000018ff117819ULL, 0x000fe40000011415ULL, 0x0000000a00597306ULL, 0x000fe20000209400ULL,
0x00000018ff6b7819ULL, 0x000fe40000011456ULL, 0x00000018ff537819ULL, 0x000fe40000011417ULL,
0x00000018ff3f7819ULL, 0x000fc60000011416ULL, 0x0000000a00647306ULL, 0x000e700000205400ULL,
0x0000000a00687306ULL, 0x0006b0000020d400ULL, 0x0000000e00477306ULL, 0x000fe20000209400ULL,
0x00000008130a7824ULL, 0x008fe200078e00ffULL, 0x000000645900720bULL, 0x002fc80003f1d000ULL,
0xfffffff80a057812ULL, 0x000fe400078ee205ULL, 0x0000000e004a7306ULL, 0x000fe60000205400ULL,
0x0000001005057824ULL, 0x000fc800078e0210ULL, 0x0000000168680812ULL, 0x004fe200078efcffULL,
0x0000000e004c7306ULL, 0x0003e2000020d400ULL, 0x000000000540783bULL, 0x000eae0000004200ULL,
0x0000001100497306ULL, 0x000fe20000209400ULL, 0x000000014b0e7824ULL, 0x002fce00078e0212ULL,
0x00000011004d7306ULL, 0x000ff00000205400ULL, 0x0000001100447306ULL, 0x0003f0000020d400ULL,
0x00000038005c7306ULL, 0x000ee20000005400ULL, 0x000000084b117824ULL, 0x002fca00078e00ffULL,
0xfffffff811117812ULL, 0x000fe400078ee20eULL, 0x0000006b00697306ULL, 0x000fe20000209400ULL,
0x00000018ff677819ULL, 0x004fe40000011443ULL, 0x0000001011117824ULL, 0x000fe200078e0210ULL,
0x00000018ff0e7819ULL, 0x000fe4000001143bULL, 0x00000018ff4f7819ULL, 0x000fe40000011440ULL,
0x0000006b00747306ULL, 0x000e620000205400ULL, 0x000000001110783bULL, 0x000ea20000004200ULL,
0x0000005c6500720bULL, 0x008fc40003f5d000ULL, 0x00000018ff517819ULL, 0x000fe40000011441ULL,
0x00000018ff577819ULL, 0x000fe40000011442ULL, 0x0000000900617306ULL, 0x000ff00000209400ULL,
0x00000009006a7306ULL, 0x000ee20000205400ULL, 0x000000746900720bULL, 0x002fce0003f9d000ULL,
0x0000000900667306ULL, 0x0002b0000020d400ULL, 0x00000039005c7306ULL, 0x000fe20000009400ULL,
0x00000018ff097819ULL, 0x002fe4000001143aULL, 0x0000006a6100720bULL, 0x008fca0003fbd000ULL,
0x0000003900657306ULL, 0x000e620000005400ULL, 0x00000018ff6f7819ULL, 0x004fce0000011410ULL,
0x00000053004b7306ULL, 0x000fe20000209400ULL, 0x0000000166665812ULL, 0x000fce00078efcffULL,
0x0000005300507306ULL, 0x000fe20000205400ULL, 0x000000655c00720bULL, 0x002fe20003f7d000ULL,
0x00010000395c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff757819ULL, 0x000fe2000001145cULL,
0x00000053003c7306ULL, 0x000ff0000020d400ULL, 0x0000006700557306ULL, 0x000ff00000209400ULL,
0x0000006700587306ULL, 0x000ff00000205400ULL, 0x0000006700537306ULL, 0x0003f0000020d400ULL,
0x00000009000a7306ULL, 0x000fe20000209400ULL, 0x0001000038677824ULL, 0x002fce00078e00ffULL,
0x0000000900457306ULL, 0x000e700000205400ULL, 0x0000000900627306ULL, 0x000eb0000020d400ULL,
0x0000003f00487306ULL, 0x000fe20000209400ULL, 0x000000450a00720bULL, 0x002fe20003f1d000ULL,
0x000100003a0a7824ULL, 0x000fcc00078e00ffULL, 0x0000003f00467306ULL, 0x000fec0000205400ULL,
0x0000000162620812ULL, 0x004fe400078efcffULL, 0x0000003f003e7306ULL, 0x000ff0000020d400ULL,
0x0000000e004e7306ULL, 0x000ff00000209400ULL, 0x0000000e005d7306ULL, 0x000ff00000205400ULL,
0x0000000e00637306ULL, 0x000ff0000020d400ULL, 0x0000004f006c7306ULL, 0x000ff00000209400ULL,
0x0000004f003f7306ULL, 0x000ff00000205400ULL, 0x0000004f005b7306ULL, 0x000ff0000020d400ULL,
0x0000005100097306ULL, 0x000ff00000209400ULL, 0x0000005100607306ULL, 0x000ff00000205400ULL,
0x00000051005a7306ULL, 0x000ff0000020d400ULL, 0x0000005700057306ULL, 0x000ff00000209400ULL,
0x00000057005e7306ULL, 0x000ff00000205400ULL, 0x0000005700547306ULL, 0x000ff0000020d400ULL,
0x0000006f004f7306ULL, 0x000ff00000209400ULL, 0x0000006f00517306ULL, 0x000ff00000205400ULL,
0x0000006f000e7306ULL, 0x0003f0000020d400ULL, 0x0000003800577306ULL, 0x0004e2000000d400ULL,
0x00000018ff6f7819ULL, 0x002fce0000011467ULL, 0x0000006b00567306ULL, 0x000e62000020d400ULL,
0x0000010039387824ULL, 0x004fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011438ULL,
0x0000006f00677306ULL, 0x000fe20000209400ULL, 0x0000000157572812ULL, 0x008fce00078efcffULL,
0x0000006f00727306ULL, 0x000ea20000205400ULL, 0x0000000156564812ULL, 0x002fc800078efcffULL,
0x000000575656723eULL, 0x000fc600000010ffULL, 0x0000007400387306ULL, 0x000ff00000209400ULL,
0x0000007400657306ULL, 0x000e620000205400ULL, 0x000000726700720bULL, 0x004fce0003f9d000ULL,
0x0000006f006b7306ULL, 0x0004f0000020d400ULL, 0x00000075005c7306ULL, 0x000fe20000209400ULL,
0x000000653800720bULL, 0x002fe20003f5d000ULL, 0x000001003b387824ULL, 0x000fca00078e00ffULL,
0x00000018ff6f7819ULL, 0x004fe20000011438ULL, 0x0000007500697306ULL, 0x000e620000205400ULL,
0x000000016b6b4812ULL, 0x008fce00078efcffULL, 0x0000003900597306ULL, 0x0004f0000000d400ULL,
0x0000007400647306ULL, 0x000ee2000020d400ULL, 0x000001003a397824ULL, 0x004fe200078e00ffULL,
0x000000695c00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff677819ULL, 0x000fe40000011439ULL,
0x00000075006a7306ULL, 0x0002a2000020d400ULL, 0x0000000159593812ULL, 0x008fce00078efcffULL,
0x0000006700727306ULL, 0x000fe20000209400ULL, 0x00000018ff757819ULL, 0x002fe4000001140aULL,
0x0000000164642812ULL, 0x000fe400078efcffULL, 0x0000005d4e00720bULL, 0x000fe40003f5d000ULL,
0x000000596457723eULL, 0x000fe200000010ffULL, 0x0000006700397306ULL, 0x000e620000205400ULL,
0x000000016a6a4812ULL, 0x004fce00078efcffULL, 0x0000003a00657306ULL, 0x000fe40000009400ULL,
0x0000000163632812ULL, 0x000fcc00078efcffULL, 0x0000003a00747306ULL, 0x000ea20000005400ULL,
0x000000397200720bULL, 0x002fce0003f7d000ULL, 0x0000006f00387306ULL, 0x000ff00000209400ULL,
0x0000006f00697306ULL, 0x000e620000205400ULL, 0x000000746500720bULL, 0x004fe40003f9d000ULL,
0x00000018ff747819ULL, 0x000fca0000011411ULL, 0x0000006700617306ULL, 0x000eb0000020d400ULL,
0x0000006f005c7306ULL, 0x000ee2000020d400ULL, 0x000000693800720bULL, 0x002fe20003fbd000ULL,
0x000100003b697824ULL, 0x000fca00078e00ffULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x0000003a00677306ULL, 0x000e62000000d400ULL, 0x0000000161613812ULL, 0x004fe400078efcffULL,
0x0000003f6c00720bULL, 0x000fca0003f7d000ULL, 0x0000003b00397306ULL, 0x000fe20000009400ULL,
0x000000015c5c5812ULL, 0x008fce00078efcffULL, 0x0000003b00727306ULL, 0x000ea20000005400ULL,
0x0000000167674812ULL, 0x002fe400078efcffULL, 0x000000015b5b3812ULL, 0x000fca00078efcffULL,
0x00000075003a7306ULL, 0x000ff00000209400ULL, 0x00000075005d7306ULL, 0x000e620000205400ULL,
0x000000723900720bULL, 0x004fe40003f9d000ULL, 0x00000018ff727819ULL, 0x000fca0000011412ULL,
0x0000007400457306ULL, 0x000ff00000209400ULL, 0x00000074004e7306ULL, 0x000fe20000205400ULL,
0x0000005d3a00720bULL, 0x002fce0003fbd000ULL, 0x00000074000a7306ULL, 0x000ff0000020d400ULL,
0x0000003b006c7306ULL, 0x0002b0000000d400ULL, 0x00000069006f7306ULL, 0x000fe20000209400ULL,
0x011000006d38783bULL, 0x002e6e0000000200ULL, 0x0000006900747306ULL, 0x000ee20000205400ULL,
0x000000016c6c4812ULL, 0x004fc400078efcffULL, 0x000000600900720bULL, 0x000fca0003f9d000ULL,
0x00000072005d7306ULL, 0x000fe20000209400ULL, 0x000000746f00720bULL, 0x008fe20003f1d000ULL,
0x00000100406f7824ULL, 0x000fcc00078e00ffULL, 0x00000072003f7306ULL, 0x000fe20000205400ULL,
0x0001000041747824ULL, 0x000fe200078e00ffULL, 0x000000015a5a4812ULL, 0x000fe400078efcffULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x0000007200097306ULL, 0x000fe2000020d400ULL, 0x000000073838e231ULL, 0x002fce00003400ffULL,
0x0000006900697306ULL, 0x000e62000020d400ULL, 0x000000073a3ae231ULL, 0x000fe400003400ffULL,
0x000000063939e231ULL, 0x080fe400003400ffULL, 0x000000063b3be231ULL, 0x000fc600003400ffULL,
0x0000006f006d7306ULL, 0x000fe80000209400ULL, 0x000000563818723cULL, 0x000be80000041818ULL,
0x0000006f00727306ULL, 0x000ea20000205400ULL, 0x0000000169690812ULL, 0x002fe400078efcffULL,
0x0000006a6657723eULL, 0x020fe200000010ffULL, 0x00000100416a7824ULL, 0x000fe200078e00ffULL,
0x0000006b6856723eULL, 0x000fc600000010ffULL, 0x0000004000597306ULL, 0x000fe20000009400ULL,
0x00000018ff6a7819ULL, 0x000fc6000001146aULL, 0x00000056381c723cULL, 0x000be2000004181cULL,
0x000000726d00720bULL, 0x004fc60003f1d000ULL, 0x0000006f00647306ULL, 0x000e66000020d400ULL,
0x0000010014567824ULL, 0x020fca00078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011456ULL,
0x00000040006d7306ULL, 0x000eb00000005400ULL, 0x0000006a006b7306ULL, 0x000fe20000209400ULL,
0x0000000164640812ULL, 0x002fce00078efcffULL, 0x0000006a00727306ULL, 0x000e620000205400ULL,
0x0000006d5900720bULL, 0x004fce0003f5d000ULL, 0x0000004000667306ULL, 0x0004f0000000d400ULL,
0x0000004100687306ULL, 0x000fe20000009400ULL, 0x000000726b00720bULL, 0x002fe20003f1d000ULL,
0x0001000040407824ULL, 0x004fcc00078e00ffULL, 0x00000041006d7306ULL, 0x000e620000005400ULL,
0x0000000166662812ULL, 0x008fce00078efcffULL, 0x0000007500657306ULL, 0x0004f0000020d400ULL,
0x00000041006b7306ULL, 0x0006e2000000d400ULL, 0x0000006d6800720bULL, 0x002fe40003f5d000ULL,
0x00000018ff757819ULL, 0x004fca0000011413ULL, 0x00000074006d7306ULL, 0x000fe20000209400ULL,
0x0000006c5c41723eULL, 0x008fe400000010ffULL, 0x0000000165655812ULL, 0x000fe400078efcffULL,
0x0000005e0500720bULL, 0x000fc60003fbd000ULL, 0x00000074006c7306ULL, 0x000e620000205400ULL,
0x000000016b6b2812ULL, 0x000fce00078efcffULL, 0x0000007500607306ULL, 0x000fe40000209400ULL,
0x0000000154545812ULL, 0x000fcc00078efcffULL, 0x00000075005e7306ULL, 0x000fe20000205400ULL,
0x0000006c6d00720bULL, 0x002fe20003f5d000ULL, 0x00000100426c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x0000007500057306ULL, 0x0003f0000020d400ULL,
0x0000006a006a7306ULL, 0x000ea2000020d400ULL, 0x00000018ff757819ULL, 0x002fc40000011440ULL,
0x000000676140723eULL, 0x000fca00000010ffULL, 0x00000075006f7306ULL, 0x000fe40000209400ULL,
0x000000403820723cULL, 0x000b6c0000041820ULL, 0x0000007500727306ULL, 0x000e620000205400ULL,
0x000000656240723eULL, 0x020fe400000010ffULL, 0x000000696341723eULL, 0x000fe200000010ffULL,
0x0000010043697824ULL, 0x000fe200078e00ffULL, 0x000000016a6a0812ULL, 0x004fc600078efcffULL,
0x0000007400677306ULL, 0x000ea2000020d400ULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x000000403824723cULL, 0x000bec0000041824ULL, 0x0000007500687306ULL, 0x000ee2000020d400ULL,
0x000000726f00720bULL, 0x002fce0003f1d000ULL, 0x0000006c00417306ULL, 0x020fe20000209400ULL,
0x0000000167672812ULL, 0x004fce00078efcffULL, 0x0000006c00747306ULL, 0x000e620000205400ULL,
0x0000000168680812ULL, 0x008fce00078efcffULL, 0x0000004200657306ULL, 0x000ff00000009400ULL,
0x0000004200727306ULL, 0x000ea20000005400ULL, 0x000000744100720bULL, 0x002fce0003f7d000ULL,
0x0000004300407306ULL, 0x000fe20000009400ULL, 0x000000726500720bULL, 0x004fce0003f1d000ULL,
0x0000004300417306ULL, 0x000e700000005400ULL, 0x0000006900727306ULL, 0x000ff00000209400ULL,
0x0000006900637306ULL, 0x000ea20000205400ULL, 0x000000414000720bULL, 0x002fc40003f9d000ULL,
0x0000006b6a41723eULL, 0x000fe200000010ffULL, 0x00010000436b7824ULL, 0x000fe200078e00ffULL,
0x000000666440723eULL, 0x000fc600000010ffULL, 0x0000006c006c7306ULL, 0x000e62000020d400ULL,
0x00000018ff6b7819ULL, 0x000fc6000001146bULL, 0x000000403828723cULL, 0x000b620000041828ULL,
0x000000637200720bULL, 0x004fe20003f5d000ULL, 0x0001000042727824ULL, 0x000fe400078e00ffULL,
0x0000006900697306ULL, 0x000ea6000020d400ULL, 0x000000685b40723eULL, 0x020fe400000010ffULL,
0x000000675a41723eULL, 0x000fe400000010ffULL, 0x00000018ff727819ULL, 0x000fc40000011472ULL,
0x000000016c6c3812ULL, 0x002fe200078efcffULL, 0x00000042006d7306ULL, 0x000e62000000d400ULL,
0x000000585500720bULL, 0x000fe20003f7d000ULL, 0x00000040382c723cULL, 0x000b6c000004182cULL,
0x00000072006f7306ULL, 0x000fe20000209400ULL, 0x0000000169692812ULL, 0x004fca00078efcffULL,
0x0000000153533812ULL, 0x000fe400078efcffULL, 0x0000007200667306ULL, 0x000ea20000205400ULL,
0x000000016d6d0812ULL, 0x002fc800078efcffULL, 0x0000006d6c40723eULL, 0x020fc600000010ffULL,
0x0000006b00647306ULL, 0x000ff00000209400ULL, 0x0000006b006a7306ULL, 0x000e620000205400ULL,
0x000000666f00720bULL, 0x004fce0003f1d000ULL, 0x0000004300427306ULL, 0x000eb0000000d400ULL,
0x0000007200437306ULL, 0x000ee2000020d400ULL, 0x0000006a6400720bULL, 0x002fce0003f5d000ULL,
0x0000006b005b7306ULL, 0x000e62000020d400ULL, 0x0000000142424812ULL, 0x004fc800078efcffULL,
0x000000426941723eULL, 0x000fe200000010ffULL, 0x0000010015427824ULL, 0x000fe200078e00ffULL,
0x0000000143430812ULL, 0x008fe200078efcffULL, 0x00000014005c7306ULL, 0x000fe60000009400ULL,
0x00000018ff697819ULL, 0x000fe20000011442ULL, 0x000000403830723cULL, 0x000b620000041830ULL,
0x000000435454723eULL, 0x000fe200000010ffULL, 0x0000010016437824ULL, 0x000fe200078e00ffULL,
0x000000015b5b2812ULL, 0x002fe200078efcffULL, 0x0000001400617306ULL, 0x000e660000005400ULL,
0x0001000015417824ULL, 0x020fe200078e00ffULL, 0x0000005b5355723eULL, 0x000fc400000010ffULL,
0x00000018ff5b7819ULL, 0x000fe40000011443ULL, 0x00000018ff6c7819ULL, 0x000fe20000011441ULL,
0x0000001400627306ULL, 0x0004e4000000d400ULL, 0x000000543838723cULL, 0x000b6c0000041834ULL,
0x0000006900427306ULL, 0x000fe20000209400ULL, 0x0000010017347824ULL, 0x020fe200078e00ffULL,
0x000000615c00720bULL, 0x002fe20003f5d000ULL, 0x0001000014147824ULL, 0x004fc600078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011434ULL, 0x0001000016347824ULL, 0x000fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011414ULL, 0x0000006900647306ULL, 0x000fec0000205400ULL,
0x0000000162622812ULL, 0x008fe400078efcffULL, 0x0000007400657306ULL, 0x000ff00000209400ULL,
0x0000007400147306ULL, 0x000e700000205400ULL, 0x0000007400637306ULL, 0x0004f0000020d400ULL,
0x0000006900407306ULL, 0x000fe2000020d400ULL, 0x00000018ff747819ULL, 0x004fe20000011434ULL,
0x000000103d347824ULL, 0x000fe200078e0252ULL, 0x000000146500720bULL, 0x002fe20003f5d000ULL,
0x00010000173d7824ULL, 0x000fc400078e00ffULL, 0x0001000010147824ULL, 0x000fe400078e00ffULL,
0x0000003500697306ULL, 0x000fe20000209400ULL, 0x00000018ff757819ULL, 0x000fe4000001143dULL,
0x00000018ff147819ULL, 0x000fca0000011414ULL, 0x00000035006a7306ULL, 0x000fe20000205400ULL,
0x0000000163632812ULL, 0x008fe400078efcffULL, 0x0000004d4900720bULL, 0x000fca0003f5d000ULL,
0x0000003500537306ULL, 0x0003f0000020d400ULL, 0x0000001500587306ULL, 0x000fe20000009400ULL,
0x011000003434783bULL, 0x002e620000000200ULL, 0x0000000144442812ULL, 0x000fcc00078efcffULL,
0x00000015005a7306ULL, 0x000eb00000005400ULL, 0x0000001500667306ULL, 0x000ef0000000d400ULL,
0x0000006c00417306ULL, 0x000fe20000209400ULL, 0x0000005a5800720bULL, 0x004fce0003fbd000ULL,
0x0000006c00687306ULL, 0x000eac0000205400ULL, 0x0000000166665812ULL, 0x008fe400078efcffULL,
0x0000007600567306ULL, 0x000fe20000209400ULL, 0x000000073434e231ULL, 0x082fe400003400ffULL,
0x000000073636e231ULL, 0x000fc400003400ffULL, 0x000000063535e231ULL, 0x080fe400003400ffULL,
0x000000063737e231ULL, 0x000fe200003400ffULL, 0x0000004a4700720bULL, 0x000fe20003fdd000ULL,
0x0000007600577306ULL, 0x000e620000205400ULL, 0x000000684100720bULL, 0x004fce0003fbd000ULL,
0x0000006c00157306ULL, 0x000ea8000020d400ULL, 0x000000014c4c6812ULL, 0x000fe400078efcffULL,
0x000000644200720bULL, 0x000fe40003fdd000ULL, 0x0000001600677306ULL, 0x000fe20000009400ULL,
0x000000575600720bULL, 0x002fe20003f9d000ULL, 0x0000010011567824ULL, 0x000fe200078e00ffULL,
0x000000634c4c723eULL, 0x000fc800000010ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x00000016006d7306ULL, 0x000e620000005400ULL, 0x0000000115155812ULL, 0x004fe400078efcffULL,
0x0000006a6900720bULL, 0x000fe40003fbd000ULL, 0x0000000140406812ULL, 0x000fc600078efcffULL,
0x0000005b00437306ULL, 0x000ff00000209400ULL, 0x0000005b006b7306ULL, 0x000ea20000205400ULL,
0x0000006d6700720bULL, 0x002fe40003f7d000ULL, 0x0000000153535812ULL, 0x000fca00078efcffULL,
0x00000017006f7306ULL, 0x000ff00000009400ULL, 0x0000001700727306ULL, 0x000e620000005400ULL,
0x0000006b4300720bULL, 0x004fce0003fdd000ULL, 0x0000007600597306ULL, 0x000eb0000020d400ULL,
0x0000001600557306ULL, 0x000ee2000000d400ULL, 0x000000726f00720bULL, 0x002fce0003f1d000ULL,
0x00000010005a7306ULL, 0x000fe20000009400ULL, 0x0000000159594812ULL, 0x004fce00078efcffULL,
0x0000001000577306ULL, 0x000e620000005400ULL, 0x0000000155553812ULL, 0x008fce00078efcffULL,
0x00000074005c7306ULL, 0x000ff00000209400ULL, 0x0000007400617306ULL, 0x000ea20000205400ULL,
0x000000575a00720bULL, 0x002fce0003f9d000ULL, 0x00000075006c7306ULL, 0x000ff00000209400ULL,
0x0000007500587306ULL, 0x000e620000205400ULL, 0x000000615c00720bULL, 0x004fce0003f7d000ULL,
0x0000005b00547306ULL, 0x000eb0000020d400ULL, 0x0000001700167306ULL, 0x0006a2000000d400ULL,
0x000000586c00720bULL, 0x002fce0003fbd000ULL, 0x00000010004a7306ULL, 0x000262000000d400ULL,
0x0000010010177824ULL, 0x008fe200078e00ffULL, 0x0000000154546812ULL, 0x004fe400078efcffULL,
0x000000464800720bULL, 0x000fe20003fdd000ULL, 0x0001000012467824ULL, 0x000fe200078e00ffULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x0000001100767306ULL, 0x000fe20000009400ULL,
0x0001000011107824ULL, 0x002fe200078e00ffULL, 0x0000000116160812ULL, 0x000fc400078efcffULL,
0x000000504b00720bULL, 0x000fe20003f1d000ULL, 0x0001000013507824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000001100777306ULL, 0x000e620000005400ULL,
0x000000014a4a4812ULL, 0x000fe400078efcffULL, 0x000000013e3e6812ULL, 0x000fe400078efcffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000001100477306ULL, 0x0004e2000000d400ULL, 0x000000013c3c0812ULL, 0x000fc400078efcffULL,
0x000000555454723eULL, 0x000fe400000010ffULL, 0x000000165355723eULL, 0x000fc600000010ffULL,
0x00000074005b7306ULL, 0x000ee2000020d400ULL, 0x0000010012117824ULL, 0x004fe200078e00ffULL,
0x000000777600720bULL, 0x002fe40003f5d000ULL, 0x000000543420723cULL, 0x000f640000041820ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000007500527306ULL, 0x000e6e000020d400ULL,
0x0000000147472812ULL, 0x008fe200078efcffULL, 0x00000017006d7306ULL, 0x000fe20000209400ULL,
0x000000015b5b3812ULL, 0x000fc400078efcffULL, 0x0000004e4500720bULL, 0x000fe40003f5d000ULL,
0x0000005b3e3e723eULL, 0x000fc600000010ffULL, 0x0000001700677306ULL, 0x000ea20000205400ULL,
0x0000000152525812ULL, 0x002fce00078efcffULL, 0x00000056006f7306ULL, 0x000fe20000209400ULL,
0x000000010a0a2812ULL, 0x000fce00078efcffULL, 0x0000005600727306ULL, 0x000e620000205400ULL,
0x000000676d00720bULL, 0x004fce0003f7d000ULL, 0x0000001400757306ULL, 0x000ff00000209400ULL,
0x00000014004d7306ULL, 0x000ea20000205400ULL, 0x000000726f00720bULL, 0x002fce0003fbd000ULL,
0x0000001000657306ULL, 0x000ff00000209400ULL, 0x0000001000747306ULL, 0x000fe20000205400ULL,
0x0000004d7500720bULL, 0x004fe40003f9d000ULL, 0x00000015444d723eULL, 0x000fca00000010ffULL,
0x0000001000417306ULL, 0x000fe4000020d400ULL, 0x0000004c341c723cULL, 0x000f6c000004181cULL,
0x0000001100577306ULL, 0x000ff00000209400ULL, 0x00000011005a7306ULL, 0x000ff00000205400ULL,
0x0000001100427306ULL, 0x000ff0000020d400ULL, 0x0000001200107306ULL, 0x000ff00000009400ULL,
0x0000001200117306ULL, 0x000e700000005400ULL, 0x00000017003d7306ULL, 0x000eb0000020d400ULL,
0x0000005600177306ULL, 0x000ee2000020d400ULL, 0x000000111000720bULL, 0x002fc40003fdd000ULL,
0x000000625910723eULL, 0x000fe400000010ffULL, 0x000000664011723eULL, 0x000fc600000010ffULL,
0x0000001400497306ULL, 0x0002e2000020d400ULL, 0x000000013d3d3812ULL, 0x004fe400078efcffULL,
0x000000514f00720bULL, 0x000fe20003f7d000ULL, 0x000000103418723cULL, 0x000b620000041818ULL,
0x0000004a3d16723eULL, 0x000fc600000010ffULL, 0x0000001200437306ULL, 0x000ea2000000d400ULL,
0x0000010013147824ULL, 0x002fe200078e00ffULL, 0x0000000117175812ULL, 0x008fe400078efcffULL,
0x000000746500720bULL, 0x000fe40003fbd000ULL, 0x00000018ff687819ULL, 0x000fe40000011414ULL,
0x0000001300487306ULL, 0x000fe20000009400ULL, 0x0000000149494812ULL, 0x000fe400078efcffULL,
0x0000005a5700720bULL, 0x000fc40003f9d000ULL, 0x000000010e0e3812ULL, 0x000fe400078efcffULL,
0x0000003f5d00720bULL, 0x000fe20003f7d000ULL, 0x00000013004b7306ULL, 0x000e620000005400ULL,
0x0000000141415812ULL, 0x000fe400078efcffULL, 0x0000000143436812ULL, 0x004fe400078efcffULL,
0x0000005e6000720bULL, 0x000fe40003fbd000ULL, 0x000000471717723eULL, 0x000fe200000010ffULL,
0x0000001300127306ULL, 0x000ea2000000d400ULL, 0x0000000142424812ULL, 0x000fc400078efcffULL,
0x000000523c3f723eULL, 0x000fe400000010ffULL, 0x0000000109093812ULL, 0x000fe200078efcffULL,
0x000000163428723cULL, 0x040b620000041828ULL, 0x000000434242723eULL, 0x000fe200000010ffULL,
0x0000006800567306ULL, 0x000fe20000209400ULL, 0x0000004b4800720bULL, 0x002fe40003f1d000ULL,
0x0000000105055812ULL, 0x000fe400078efcffULL, 0x000000410a41723eULL, 0x000fe200000010ffULL,
0x0000003e3424723cULL, 0x000b640000041824ULL, 0x0000006800647306ULL, 0x000e6c0000205400ULL,
0x0000000112120812ULL, 0x004fc400078efcffULL, 0x0000004600137306ULL, 0x000ff00000209400ULL,
0x0000004600407306ULL, 0x000ea20000205400ULL, 0x000000645600720bULL, 0x002fce0003f5d000ULL,
0x0000005000107306ULL, 0x020ff00000209400ULL, 0x0000005000117306ULL, 0x000e620000205400ULL,
0x000000401300720bULL, 0x004fe40003f9d000ULL, 0x000000490e40723eULL, 0x000fca00000010ffULL,
0x0000006800147306ULL, 0x000ea4000020d400ULL, 0x00000040342c723cULL, 0x000b6c000004182cULL,
0x0000004600467306ULL, 0x000ee2000020d400ULL, 0x000000111000720bULL, 0x002fce0003fdd000ULL,
0x0000005000507306ULL, 0x000e62000020d400ULL, 0x0000000114142812ULL, 0x004fc800078efcffULL,
0x000000121443723eULL, 0x000fe400000010ffULL, 0x0000000146464812ULL, 0x008fc800078efcffULL,
0x000000460946723eULL, 0x000fe200000010ffULL, 0x000000423430723cULL, 0x000b620000041830ULL,
0x0000000150506812ULL, 0x002fc800078efcffULL, 0x000000500547723eULL, 0x000fe400000010ffULL,
0x000000040c057810ULL, 0x000fc80007ffe0ffULL, 0x000176a805057811ULL, 0x000fe200078e18ffULL,
0x000000463438723cULL, 0x000b620000041838ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000005107f8cULL, 0x0002a2000c80043fULL, 0x000000010b0b7810ULL, 0x000fe40007ffe0ffULL,
0x000176a078097811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000009ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff057224ULL, 0x006fe200078e0011ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff266000007947ULL, 0x000fea000383ffffULL,
0x000000ff7100720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x018000000f007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000f33000047802ULL, 0x004fc40000000f00ULL,
0x0000a6e000007944ULL, 0x03afea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000f00007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc8000000000fULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000047919ULL, 0x004ea80000000000ULL, 0x0000000000077919ULL, 0x000e620000000000ULL,
0x00000002ff067819ULL, 0x004fe40000011604ULL, 0x0000000807047811ULL, 0x002fe200078ff0ffULL,
0x0000000003057220ULL, 0x008fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000001800187220ULL, 0x042fe40000410000ULL,
0x0000001900197220ULL, 0x040fe40000410000ULL, 0x0000001c001c7220ULL, 0x040fe40000410000ULL,
0x0000001d001d7220ULL, 0x000fc40000410000ULL, 0x0000002000207220ULL, 0x040fe40000410000ULL,
0x0000002100217220ULL, 0x040fe40000410000ULL, 0x0000002400247220ULL, 0x040fe40000410000ULL,
0x0000002500257220ULL, 0x040fe40000410000ULL, 0x0000002800287220ULL, 0x040fe40000410000ULL,
0x0000002900297220ULL, 0x000fc40000410000ULL, 0x0000002c002c7220ULL, 0x060fe40000410000ULL,
0x0000002d002d7220ULL, 0x040fe40000410000ULL, 0x0000003000307220ULL, 0x040fe40000410000ULL,
0x0000003100317220ULL, 0x040fe40000410000ULL, 0x0000003800387220ULL, 0x040fe40000410000ULL,
0x0000003900397220ULL, 0x000fc40000410000ULL, 0x0000001a041a7220ULL, 0x044fe40000410000ULL,
0x0000001b041b7220ULL, 0x040fe40000410000ULL, 0x0000001e041e7220ULL, 0x040fe40000410000ULL,
0x0000001f041f7220ULL, 0x040fe40000410000ULL, 0x0000002204227220ULL, 0x040fe40000410000ULL,
0x0000002304237220ULL, 0x000fc40000410000ULL, 0x0000002604267220ULL, 0x040fe40000410000ULL,
0x0000002704277220ULL, 0x040fe40000410000ULL, 0x0000002a042a7220ULL, 0x040fe40000410000ULL,
0x0000002b042b7220ULL, 0x040fe40000410000ULL, 0x0000002e042e7220ULL, 0x040fe40000410000ULL,
0x0000002f042f7220ULL, 0x000fc40000410000ULL, 0x0000003204327220ULL, 0x040fe40000410000ULL,
0x0000003304337220ULL, 0x040fe40000410000ULL, 0x0000003a043a7220ULL, 0x040fe40000410000ULL,
0x0000003b043b7220ULL, 0x000fc40000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x0000002c2d2c723eULL, 0x020fe200000010ffULL, 0x000000200c0b7824ULL, 0x000fe200078e00ffULL,
0x000000303130723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000222322723eULL, 0x000fc400000010ffULL, 0x000000262711723eULL, 0x000fe400000010ffULL,
0x0000002a2b2a723eULL, 0x000fe400000010ffULL, 0x0000002e2f15723eULL, 0x000fe400000010ffULL,
0x000000323332723eULL, 0x000fe400000010ffULL, 0x00000002ff057819ULL, 0x006fe40000011600ULL,
0x0000000200027812ULL, 0x000fc400078ec0ffULL, 0x0000000800077811ULL, 0x008fe200078ff0ffULL,
0x0000000805097824ULL, 0x040fe200078e00ffULL, 0x0000000502047211ULL, 0x040fe200078ff8ffULL,
0x00000008050e7824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x000fe200078ff8ffULL,
0x0000000807107824ULL, 0x000fe200078e00ffULL, 0x0000000204027810ULL, 0x040fe20007ffe0ffULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0x0000000404067810ULL, 0x000fe40007ffe0ffULL,
0xfffffff810107812ULL, 0x000fe200078ee203ULL, 0x000010007d037824ULL, 0x000fe200078e00ffULL,
0xfffffff809087812ULL, 0x000fc400078ee202ULL, 0xfffffff807027812ULL, 0x000fe200078ee204ULL,
0x000008000c057824ULL, 0x000fe200078e0203ULL, 0x0000000604077810ULL, 0x000fe20007ffe0ffULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x000fe200078ee206ULL,
0x0000001002067824ULL, 0x000fe200078e0205ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL,
0x0000001010107824ULL, 0x100fe200078e0205ULL, 0x0000000804077812ULL, 0x000fe200078ec0ffULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0x000000181902723eULL, 0x000fe200000010ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0205ULL, 0x0000001c1d04723eULL, 0x000fe200000010ffULL,
0x0000000106067824ULL, 0x000fe200078e0207ULL, 0x000000383918723eULL, 0x000fe200000010ffULL,
0x000000100e0e7824ULL, 0x000fe200078e0205ULL, 0x0000541002127816ULL, 0x040fe20000000004ULL,
0x0000000107107824ULL, 0x040fe200078e0210ULL, 0x0000763202137816ULL, 0x000fe20000000004ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x000000202102723eULL, 0x000fe200000010ffULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x000000242504723eULL, 0x000fe200000010ffULL,
0x0000001206007388ULL, 0x0003e20000000a00ULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x000000282905723eULL, 0x000fc400000010ffULL, 0x0000763202077816ULL, 0x100fe40000000004ULL,
0x0000003a3b19723eULL, 0x000fe400000010ffULL, 0x000076322a097816ULL, 0x000fe40000000015ULL,
0x00005410321c7816ULL, 0x000fe40000000019ULL, 0x0000541002067816ULL, 0x002fe40000000004ULL,
0x0000001a1b02723eULL, 0x000fc400000010ffULL, 0x0000001e1f04723eULL, 0x000fe200000010ffULL,
0x0000000608007388ULL, 0x0003e20000000a00ULL, 0x00007632321d7816ULL, 0x000fe40000000019ULL,
0x0000541005067816ULL, 0x142fe4000000002cULL, 0x0000763205077816ULL, 0x000fe4000000002cULL,
0x000000ff00057306ULL, 0x000fe60000209400ULL, 0x000000060a007388ULL, 0x0003e40000000a00ULL,
0x0000541030067816ULL, 0x002fc40000000018ULL, 0x0000763230077816ULL, 0x000fca0000000018ULL,
0x000000060e007388ULL, 0x0003e40000000a00ULL, 0x0000541002067816ULL, 0x142fe40000000004ULL,
0x0000763202077816ULL, 0x000fe20000000004ULL, 0x000000010b027824ULL, 0x000fe200078e0200ULL,
0x000000ff00047306ULL, 0x000e660000205400ULL, 0x0000000610007388ULL, 0x0005e40000000a00ULL,
0x0000541022107816ULL, 0x004fe20000000011ULL, 0x0000001002067824ULL, 0x000fe200078e0203ULL,
0x0000763222117816ULL, 0x000fe20000000011ULL, 0x000000ff00027306ULL, 0x000ea2000020d400ULL,
0x000000040500720bULL, 0x002fc60003f1d000ULL, 0x0004001008007388ULL, 0x0003e40000000a00ULL,
0x000054102a087816ULL, 0x002fd00000000015ULL, 0x0000000102020812ULL, 0x004fe400078efcffULL,
0x000000ff0c00720cULL, 0x000fe20003f05270ULL, 0x000400080a007388ULL, 0x000fe20000000a00ULL,
0x000000020204723eULL, 0x000fc600000010ffULL, 0x0004001c0e007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000006107984ULL, 0x000e680000000c00ULL,
0x0004000006087984ULL, 0x000ea80000000c00ULL, 0x0008000006147984ULL, 0x000ee80000000c00ULL,
0x000c000006187984ULL, 0x000ee20000000c00ULL, 0x3f803f8004137831ULL, 0x002fc40000200013ULL,
0x3f803f8004127831ULL, 0x040fe40000200012ULL, 0x3f803f8004117831ULL, 0x040fe40000200011ULL,
0x3f803f8004107831ULL, 0x040fe40000200010ULL, 0x3f803f80040b7831ULL, 0x044fe4000020000bULL,
0x3f803f80040a7831ULL, 0x040fe4000020000aULL, 0x3f803f8004097831ULL, 0x000fc40000200009ULL,
0x3f803f8004087831ULL, 0x000fe40000200008ULL, 0x3f803f8013137831ULL, 0x008fe40000200017ULL,
0x3f803f8012127831ULL, 0x000fe40000200016ULL, 0x3f803f8011117831ULL, 0x000fe40000200015ULL,
0x3f803f8010107831ULL, 0x000fe40000200014ULL, 0x3f803f800b0b7831ULL, 0x000fc4000020001bULL,
0x3f803f800a0a7831ULL, 0x000fe2000020001aULL, 0x0000001006007388ULL, 0x000fe20000000c00ULL,
0x3f803f8009097831ULL, 0x000fe40000200019ULL, 0x3f803f8008087831ULL, 0x000fca0000200018ULL,
0x0004000806007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000011e7983ULL, 0x000ea20000100800ULL,
0x00000003ff067819ULL, 0x000fc80000011600ULL, 0x0000001e0600720cULL, 0x004fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000400010f7983ULL, 0x000ea20000100800ULL,
0x00005a0000087b06ULL, 0x000e620000209000ULL, 0x000000017b027824ULL, 0x000fe200078e0206ULL,
0x00005a00ff107a12ULL, 0x000fe400078e33ffULL, 0x00000007000e7812ULL, 0x000fc800078ec0ffULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08047810ULL, 0x002fcc0007ffe0ffULL,
0x0000000400057305ULL, 0x0002e4000021f000ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000ffff077224ULL, 0x008fc800078e0a05ULL, 0x00005a0007077a24ULL, 0x000fc800078e02ffULL,
0x00000007050d7227ULL, 0x010fc800078e0004ULL, 0x0000000106047824ULL, 0x000fe400078e0200ULL,
0x000000020d077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fca00078e0202ULL, 0x00005a0005007a0cULL, 0x000fda0003f06070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x0000000704057812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x0ffffff805047812ULL, 0x000fca00078ef800ULL,
0x0000001004067824ULL, 0x000fe400078e0203ULL, 0x0000000107071810ULL, 0x000fc60007ffe0ffULL,
0x0000000006087984ULL, 0x0002e20000000c00ULL, 0x0000000710077207ULL, 0x000fca0004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e027aULL,
0x00005a0005027a24ULL, 0x000fc800078e0202ULL, 0x00005a0007027a24ULL, 0x000fe400078e0202ULL,
0x000000087d077824ULL, 0x000fc600078e020eULL, 0x000000020f057210ULL, 0x004fe40007f3e0ffULL,
0x0000002000027810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x040fe400078240ffULL, 0x00000003ff067819ULL, 0x002fe40000011602ULL,
0x00005f0005057a11ULL, 0x000fe400008f440cULL, 0x0000001e0600720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0083ea000c101d08ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000017b047824ULL, 0x102fe200078e0206ULL,
0x00000040000c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000102067824ULL, 0x000fe400078e0206ULL,
0x000000040d077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fca00078e0204ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0000000706057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805067812ULL, 0x000fe400078ef802ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001006067824ULL, 0x000fe400078e0203ULL, 0x0000000107072810ULL, 0x000fc60007ffe0ffULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000710077207ULL, 0x000fca0004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe200078e027aULL,
0x00000003ff067819ULL, 0x002fe2000001160cULL, 0x00005a0005047a24ULL, 0x000fc800078e0204ULL,
0x00005a0007047a24ULL, 0x000fe400078e0204ULL, 0x000000087d077824ULL, 0x000fc600078e0202ULL,
0x000000040f057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f440eULL,
0x0000001e0600720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d08ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000017b027824ULL, 0x100fe200078e0206ULL, 0x0000006000007810ULL, 0x000fe20007ffe0ffULL,
0x000000010c067824ULL, 0x000fe400078e0206ULL, 0x000000020d077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x002fc800078e0a07ULL, 0x00005a0005047a24ULL, 0x000fe200078e0202ULL,
0x0000000706057812ULL, 0x000fc800078ec0ffULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff805047812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fca00078e0203ULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000107072810ULL, 0x000fc80007ffe0ffULL,
0x0000000710077207ULL, 0x000fca0004000000ULL, 0x000000ffff057224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e027aULL, 0x00005a0005027a24ULL, 0x000fc800078e0202ULL,
0x00005a0007027a24ULL, 0x000fe400078e0202ULL, 0x000000087d077824ULL, 0x000fc600078e020cULL,
0x000000020f027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005e0002047a11ULL, 0x000fc800078240ffULL, 0x00005f0002057a11ULL, 0x000fe400008f4405ULL,
0x00000003ff027819ULL, 0x000fc60000011600ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000001e0200720cULL, 0x000fc60003f26070ULL, 0x000000017b7b7824ULL, 0x000fe200078e0202ULL,
0x0000000804007986ULL, 0x0023f2000c101d08ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000007b0d087227ULL, 0x002fc800078e00ffULL, 0x000000ffff047224ULL, 0x000fe400078e0a08ULL,
0x0000000100027824ULL, 0x000fe400078e0202ULL, 0x00005a0004047a24ULL, 0x000fc600078e027bULL,
0x0000000702057812ULL, 0x000fe400078ec0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f26070ULL,
0xfffffff805027812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fca00078ec0ffULL,
0x000000087d7d7824ULL, 0x000fc800078e0200ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000108081810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe20003f46070ULL,
0x0000001002047824ULL, 0x000fcc00078e0203ULL, 0x0000000004047984ULL, 0x000e6c0000000c00ULL,
0x0000000108082810ULL, 0x000fc80007ffe0ffULL, 0x0000000810037207ULL, 0x000fca0004000000ULL,
0x000000ffff027224ULL, 0x000fe400078e0a03ULL, 0x00005900037a7a24ULL, 0x000fe400078e027aULL,
0x00005a00027b7a24ULL, 0x000fc800078e027bULL, 0x00005a007a7b7a24ULL, 0x000fca00078e027bULL,
0x0000007b0f7b7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e007b027a11ULL, 0x000fc800078040ffULL, 0x00005f007b037a11ULL, 0x000fca00000f4408ULL,
0x000000107d027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff6c7819ULL, 0x000fe20000011600ULL,
0xffffffffff0a7424ULL, 0x000fc600078e00ffULL, 0x000000796c00720cULL, 0x000fda0003f06070ULL,
0x00000002030d8824ULL, 0x000fc800078e00ffULL, 0x00006a000d0d8a24ULL, 0x000fc800078e026cULL,
0x000066000d0c8625ULL, 0x000fe200078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006e00ff0e7624ULL, 0x000fe200078e00ffULL, 0x000000080c0a8981ULL, 0x000ea2000c1e1900ULL,
0x00006f00ff0f7624ULL, 0x000fc600078e00ffULL, 0x01760000ff047f8cULL, 0x000ee8000c80043fULL,
0x000000080e087981ULL, 0x000322000c1e9900ULL, 0x000001ff0900780cULL, 0x000fe20003f04070ULL,
0x000000807a727824ULL, 0x000fe400078e00ffULL, 0x0000004000097824ULL, 0x000fe400078e00ffULL,
0x000000807d7d7824ULL, 0x000fc600078e00ffULL, 0x00000040720b7812ULL, 0x000fe200078ef809ULL,
0x0000000a7d3d7224ULL, 0x004fc800078e02ffULL, 0x00000c9000000947ULL, 0x000fea0003800000ULL,
0x00000003ff1c7819ULL, 0x00afe40000011602ULL, 0x000064003d127a11ULL, 0x000fe400078038ffULL,
0x000000081c167810ULL, 0x040fe20007ffe0ffULL, 0x000000010b0c7824ULL, 0x000fe200078e021cULL,
0x000000041c107810ULL, 0x040fe40007ffe0ffULL, 0x000000101c147810ULL, 0x000fe20007ffe0ffULL,
0x00000001160d7824ULL, 0x100fe200078e0202ULL, 0x0000000c1c187810ULL, 0x000fe20007ffe0ffULL,
0x0000000816247824ULL, 0x000fe200078e00ffULL, 0x00000009700e7217ULL, 0x000fe20007800000ULL,
0x00000001100a7824ULL, 0x000fe200078e0202ULL, 0x000000141c2a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008100f7824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee20dULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000001c1c2e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80f227812ULL, 0x000fe200078ee20aULL, 0x0000000814117824ULL, 0x000fe200078e00ffULL,
0x000000700c1f7812ULL, 0x000fe200078ef806ULL, 0x00000001140c7824ULL, 0x100fe200078e0202ULL,
0x000065003d0a7a11ULL, 0x000fe200000f3cffULL, 0x00000001180f7824ULL, 0x000fe200078e0202ULL,
0x0000001f121e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000818267824ULL, 0x000fe200078e00ffULL,
0xfffffff811287812ULL, 0x000fe200078ee20cULL, 0x000000010b0c7824ULL, 0x000fe200078e0210ULL,
0x0000100000137811ULL, 0x000fe200078e70ffULL, 0x000000010d1f7824ULL, 0x000fe200000e060aULL,
0xfffffff826267812ULL, 0x000fe200078ee20fULL, 0x000000010e1d7824ULL, 0x000fe200078e0a09ULL,
0x000000201c307810ULL, 0x000fe20007ffe0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000241c327810ULL, 0x000fc40007ffe0ffULL, 0x0000001d1000720cULL, 0x080fe20003fa6070ULL,
0x000000010b0e7824ULL, 0x040fe200078e0216ULL, 0x000000700c1b7812ULL, 0x000fe200078ef806ULL,
0x000000010b107824ULL, 0x000fe200078e0218ULL, 0x0000001d1800720cULL, 0x080fe20003f46070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000121b1a7210ULL, 0x000fe40007f7e0ffULL,
0x0000001d1400720cULL, 0x080fe20003f06070ULL, 0x000000010b207824ULL, 0x000fe200078e022aULL,
0x000000700e157812ULL, 0x000fe200078ef806ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001d1600720cULL, 0x000fc60003f26070ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000007010177812ULL, 0x000fc600078ef806ULL, 0x000000010b187824ULL, 0x000fe200078e0214ULL,
0x0000001215147210ULL, 0x080fe20007f9e0ffULL, 0x000000010d1b7824ULL, 0x000fe200018e060aULL,
0x00000070200d7812ULL, 0x000fe200078ef806ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x000000181c207810ULL, 0x000fe40007ffe0ffULL, 0x0000001217167210ULL, 0x080fe20007f7e0ffULL,
0x000000010f157824ULL, 0x000fe200020e060aULL, 0x00000070180f7812ULL, 0x000fe200078ef806ULL,
0x000000010b107824ULL, 0x000fe200078e0220ULL, 0x000000120d0c7210ULL, 0x080fe20007fde0ffULL,
0x0000000111177824ULL, 0x000fe200018e060aULL, 0x000000120f0e7210ULL, 0x000fe20007f9e0ffULL,
0x000000011c187824ULL, 0x000fe200078e0202ULL, 0x0000001d2a00720cULL, 0x000fe20003f66070ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x00000001210d7824ULL, 0x100fe200030e060aULL,
0x0000000718217812ULL, 0x000fe200078ec0ffULL, 0x00000001190f7824ULL, 0x000fe200020e060aULL,
0x0000001d1c00720cULL, 0x000fe20003f86070ULL, 0x000000012a187824ULL, 0x000fe200078e0202ULL,
0x0000007010197812ULL, 0x000fe200078ef806ULL, 0x000000082a237824ULL, 0x000fe200078e00ffULL,
0x0ffffff8212c7812ULL, 0x000fe200078ef802ULL, 0x000000010b217824ULL, 0x000fe200078e0230ULL,
0x0000001219107210ULL, 0x000fe20007fde0ffULL, 0x000000010b197824ULL, 0x000fe200078e022eULL,
0xfffffff8232a7812ULL, 0x000fe200078ee218ULL, 0x000000102c237824ULL, 0x000fc400078e0213ULL,
0x0000008019187825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e237faeULL, 0x0003e2000e101c48ULL, 0x0000001d2000720cULL, 0x040fe20003f86070ULL,
0x0000000120257824ULL, 0x000fe200078e0202ULL, 0x0000007018297812ULL, 0x000fe200078ef806ULL,
0x00000008202c7824ULL, 0x000fe400078e00ffULL, 0x0000008021207825ULL, 0x000fc600078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee225ULL, 0x0000000111117824ULL, 0x000fe200030e060aULL,
0x0000001229187210ULL, 0x000fe20007fde0ffULL, 0x000000010b277824ULL, 0x000fe200078e0232ULL,
0x00000070201f7812ULL, 0x002fe200078ef806ULL, 0x0000001022257824ULL, 0x000fe400078e0213ULL,
0x0000008027227825ULL, 0x000fc600078e00ffULL, 0x000000001a257faeULL, 0x0003e2000e901c48ULL,
0x0000000119197824ULL, 0x000fe200030e060aULL, 0x000000121f1e7210ULL, 0x080fe20007fde0ffULL,
0x000000012e277824ULL, 0x000fe200078e0202ULL, 0x0000007022297812ULL, 0x000fe200078ef806ULL,
0x000000082e227824ULL, 0x040fe200078e00ffULL, 0x0000001d2e00720cULL, 0x000fe20003fa6070ULL,
0x00000001211f7824ULL, 0x000fe200030e060aULL, 0x0000001229207210ULL, 0x000fe20007fde0ffULL,
0x00000008302b7824ULL, 0x000fe200078e00ffULL, 0x000000281c2e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff822227812ULL, 0x000fe200078ee227ULL, 0x0000001024277824ULL, 0x100fe400078e0213ULL,
0x0000000123217824ULL, 0x000fe400030e060aULL, 0x0000001026237824ULL, 0x000fe200078e0213ULL,
0x0000000014277faeULL, 0x0005e2000c901c48ULL, 0x000000010b1a7824ULL, 0x002fe200078e022eULL,
0x0000001d3000720cULL, 0x080fe20003f26070ULL, 0x0000000132257824ULL, 0x040fe200078e0202ULL,
0x0000000016237faeULL, 0x0003e2000d101c48ULL, 0x0000001d3200720cULL, 0x000fe20003f46070ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x000000381c267810ULL, 0x000fc60007ffe0ffULL,
0x0000000832327824ULL, 0x000fe200078e00ffULL, 0x000000701a297812ULL, 0x000fe200078ef806ULL,
0x0000001028157824ULL, 0x004fe200078e0213ULL, 0x0000003c1c287810ULL, 0x000fe20007ffe0ffULL,
0x0000000130247824ULL, 0x000fe200078e0202ULL, 0xfffffff832147812ULL, 0x000fe200078ee225ULL,
0x000000102a177824ULL, 0x102fe200078e0213ULL, 0x0000002c1c167810ULL, 0x000fe20007ffe0ffULL,
0x000000000e157faeULL, 0x0003e2000c101c48ULL, 0x00000012291a7210ULL, 0x000fe20007fde0ffULL,
0x0000001014297824ULL, 0x100fe200078e0213ULL, 0xfffffff82b247812ULL, 0x000fe200078ee224ULL,
0x000000010b147824ULL, 0x040fe200078e0216ULL, 0x000000000c177faeULL, 0x0005e2000d901c48ULL,
0x0000001022257824ULL, 0x100fe200078e0213ULL, 0x000000301c227810ULL, 0x000fe20007ffe0ffULL,
0x000000102c237824ULL, 0x100fe200078e0213ULL, 0x0000001d2800720cULL, 0x080fe20003f06070ULL,
0x0000001024277824ULL, 0x000fe200078e0213ULL, 0x000000341c247810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0e7824ULL, 0x002fe200078e0222ULL, 0x0000000010237faeULL, 0x0003e2000e101c48ULL,
0x000000011b1b7824ULL, 0x000fe200030e060aULL, 0x0000001d1600720cULL, 0x0c0fe20003f86070ULL,
0x00000008161c7824ULL, 0x000fe200078e00ffULL, 0x0000000018257faeULL, 0x0007e2000e901c48ULL,
0x00000080140c7825ULL, 0x004fe200078e00ffULL, 0x0000001d2e00720cULL, 0x000fc40003fa6070ULL,
0x000000001e277faeULL, 0x0005e2000c901c48ULL, 0x0000001d2200720cULL, 0x080fe20003f66070ULL,
0x0000000116177824ULL, 0x000fe200078e0202ULL, 0x000000700c0f7812ULL, 0x000fe200078ef806ULL,
0x000000010b107824ULL, 0x002fe200078e0224ULL, 0x0000000020297faeULL, 0x0003e2000d101c48ULL,
0x0000001d2400720cULL, 0x080fe20003f46070ULL, 0x000000012e157824ULL, 0x000fe200078e0202ULL,
0x000000120f0c7210ULL, 0x000fe20007fde0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001d2600720cULL, 0x000fc40003f26070ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee217ULL,
0x00000008221d7824ULL, 0x000fe200078e00ffULL, 0x000000700e197812ULL, 0x008fe200078ef806ULL,
0x00000001220e7824ULL, 0x000fe400078e0202ULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff81d1e7812ULL, 0x004fe200078ee20eULL, 0x000000010d0d7824ULL, 0x000fe200030e060aULL,
0x0000001219147210ULL, 0x080fe20007fde0ffULL, 0x000000082e187824ULL, 0x000fe200078e00ffULL,
0x0000007010177812ULL, 0x000fe200078ef806ULL, 0x000000010b0e7824ULL, 0x000fe400078e0226ULL,
0x0000000124107824ULL, 0x000fe200078e0202ULL, 0xfffffff818187812ULL, 0x000fe200078ee215ULL,
0x000000010f157824ULL, 0x000fe200030e060aULL, 0x0000001217167210ULL, 0x000fe20007fde0ffULL,
0x00000008241d7824ULL, 0x000fc400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff81d207812ULL, 0x002fe200078ee210ULL, 0x000000010b197824ULL, 0x000fe200078e0228ULL,
0x000000700e1d7812ULL, 0x000fe200078ef806ULL, 0x0000000111177824ULL, 0x000fe400030e060aULL,
0x0000008019107825ULL, 0x000fe200078e00ffULL, 0x000000121d0e7210ULL, 0x000fc60007fde0ffULL,
0x00000001260b7824ULL, 0x000fe200078e0202ULL, 0x00000070101d7812ULL, 0x000fe200078ef806ULL,
0x0000000128197824ULL, 0x000fe400078e0202ULL, 0x0000000826267824ULL, 0x000fe400078e00ffULL,
0x0000000828287824ULL, 0x000fe400078e00ffULL, 0x000000010f0f7824ULL, 0x000fe200030e060aULL,
0xfffffff826027812ULL, 0x000fe200078ee20bULL, 0x00000010180b7824ULL, 0x000fe200078e0213ULL,
0xfffffff828067812ULL, 0x000fe200078ee219ULL, 0x000000101c197824ULL, 0x100fe200078e0213ULL,
0x000000121d127210ULL, 0x000fe20007fde0ffULL, 0x000000101e1d7824ULL, 0x100fe200078e0213ULL,
0x000000001a0b7faeULL, 0x0003e2000e901c48ULL, 0x00000010201f7824ULL, 0x000fc400078e0213ULL,
0x0000001002217824ULL, 0x100fe200078e0213ULL, 0x000000000c197faeULL, 0x0003e2000e101c48ULL,
0x0000001006237824ULL, 0x000fe400078e0213ULL, 0x0000000111137824ULL, 0x000fe200030e060aULL,
0x00000000141d7faeULL, 0x0003e8000d901c48ULL, 0x00000000161f7faeULL, 0x0003e8000d101c48ULL,
0x000000000e217faeULL, 0x0003e8000c901c48ULL, 0x0000000012237faeULL, 0x0003e2000c101c48ULL,
0x00000b5000007947ULL, 0x000fea0003800000ULL, 0x00000008020f7811ULL, 0x04afe400078fe8ffULL,
0x00000004020e7811ULL, 0x000fc400078fe8ffULL, 0x0000000c02107811ULL, 0x040fe200078fe8ffULL,
0x000000010f0c7824ULL, 0x140fe200078e0202ULL, 0x0000001802157811ULL, 0x040fe200078fe8ffULL,
0x000000080f217824ULL, 0x000fe200078e00ffULL, 0x0000001002117811ULL, 0x000fe200078fe8ffULL,
0x000000010e0a7824ULL, 0x000fe200078e0202ULL, 0x0000001402137811ULL, 0x000fe200078fe8ffULL,
0x000000080e1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee20cULL,
0x00000001100d7824ULL, 0x100fe200078e0202ULL, 0x0000001c02177811ULL, 0x000fe200078fe8ffULL,
0x0000000810147824ULL, 0x000fe200078e00ffULL, 0x0000002802307811ULL, 0x040fe200078fe8ffULL,
0x00000001150c7824ULL, 0x000fe200078e0202ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20aULL,
0x0000000815297824ULL, 0x000fe200078e00ffULL, 0x0000002002197811ULL, 0x000fe200078fe8ffULL,
0x0000000111127824ULL, 0x140fe200078e0202ULL, 0xfffffff814237812ULL, 0x000fe200078ee20dULL,
0x0000000811257824ULL, 0x000fe200078e00ffULL, 0x00000024022e7811ULL, 0x040fe200078fe8ffULL,
0x00000001130a7824ULL, 0x000fe200078e0202ULL, 0xfffffff829297812ULL, 0x000fe200078ee20cULL,
0x0000000813277824ULL, 0x000fe200078e00ffULL, 0x0000002c02327811ULL, 0x000fe200078fe8ffULL,
0x00000001170d7824ULL, 0x000fe200078e0202ULL, 0xfffffff825257812ULL, 0x000fe200078ee212ULL,
0x0000000817147824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee20aULL,
0x00000001300c7824ULL, 0x100fe200078e0202ULL, 0x0000003002347811ULL, 0x000fe200078fe8ffULL,
0x00000008301d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8142b7812ULL, 0x000fe200078ee20dULL,
0x0000000119127824ULL, 0x040fe200078e0202ULL, 0x0000003c02247811ULL, 0x000fe200078fe8ffULL,
0x00000008192d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1e7812ULL, 0x000fe200078ee20cULL,
0x000000012e0a7824ULL, 0x000fe200078e0202ULL, 0x00000002020c7211ULL, 0x000fe200078fe8ffULL,
0x000000082e1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee212ULL,
0x00000001320d7824ULL, 0x000fe200078e0202ULL, 0x00000038021d7811ULL, 0x000fe200078fe8ffULL,
0x0000000832207824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1c7812ULL, 0x000fe200078ee20aULL,
0x0000000134127824ULL, 0x000fe200078e0202ULL, 0x00000034021b7811ULL, 0x000fe200078fe8ffULL,
0x00000008342f7824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee20dULL,
0x000000010b0f7824ULL, 0x040fe200078e020fULL, 0x000000070c0d7812ULL, 0x000fe200078ec0ffULL,
0x000000010b0c7824ULL, 0x000fe200078e020eULL, 0xfffffff82f227812ULL, 0x000fe200078ee212ULL,
0x000000010b127824ULL, 0x040fe200078e0211ULL, 0x0000000b020a7211ULL, 0x000fe200078fe8ffULL,
0x000000010b107824ULL, 0x000fe200078e0210ULL, 0x0ffffff80d0d7812ULL, 0x000fe200078ef802ULL,
0x000000010b147824ULL, 0x040fe200078e0213ULL, 0x00001000002a7811ULL, 0x000fe200078e70ffULL,
0x000000010b167824ULL, 0x000fc400078e0215ULL, 0x000000010b187824ULL, 0x040fe400078e0217ULL,
0x000000010b1a7824ULL, 0x040fe400078e0219ULL, 0x000000010b2e7824ULL, 0x040fe400078e022eULL,
0x000000010b307824ULL, 0x040fe400078e0230ULL, 0x000000010b327824ULL, 0x040fe400078e0232ULL,
0x000000010b347824ULL, 0x000fc400078e0234ULL, 0x000000010b3a7824ULL, 0x000fe400078e021bULL,
0x000000011b0e7824ULL, 0x100fe400078e0202ULL, 0x000000010b387824ULL, 0x000fe400078e021dULL,
0x000000011d117824ULL, 0x000fe400078e0202ULL, 0x000000010b367824ULL, 0x000fe400078e0224ULL,
0x0000000124027824ULL, 0x000fc400078e0202ULL, 0x00000008240b7824ULL, 0x000fe400078e00ffULL,
0x000000081b1b7824ULL, 0x000fe400078e00ffULL, 0x000000081d267824ULL, 0x000fe200078e00ffULL,
0xfffffff80b287812ULL, 0x000fe200078ee202ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff81b0e7812ULL, 0x000fe400078ee20eULL, 0x000064003d027a11ULL, 0x000fe200078038ffULL,
0x000000100d1d7824ULL, 0x000fe200078e022aULL, 0x000000700a157812ULL, 0x000fe200078ef806ULL,
0x000000100e247824ULL, 0x000fe200078e022aULL, 0xfffffff826117812ULL, 0x000fe200078ee211ULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x000065003d3d7a11ULL, 0x000fc400000f3cffULL,
0x00000015020a7210ULL, 0x000fe20007f1e0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000700e177812ULL, 0x000fc600078ef806ULL, 0x0000001011267824ULL, 0x000fe200078e022aULL,
0x000000700c197812ULL, 0x000fe200078ef806ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x00000019020c7210ULL, 0x000fe20007f3e0ffULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x000000010b0b7824ULL, 0x100fe200000e063dULL, 0x00000017020e7210ULL, 0x000fe20007f1e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000007012177812ULL, 0x100fe400078ef806ULL,
0x0000007010157812ULL, 0x100fe200078ef806ULL, 0x000000010f0f7824ULL, 0x000fe200000e063dULL,
0x0000001702127210ULL, 0x000fe20007f1e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000001502107210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a1d7faeULL, 0x0003e2000b901c48ULL, 0x000000701a2f7812ULL, 0x100fe200078ef806ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000007018317812ULL, 0x000fc400078ef806ULL,
0x0000002f021a7210ULL, 0x000fe20007f7e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000007016337812ULL, 0x000fc600078ef806ULL, 0x0000000111117824ULL, 0x100fe200010e063dULL,
0x0000007014357812ULL, 0x000fe200078ef806ULL, 0x000000010d0d7824ULL, 0x000fe200008e063dULL,
0x0000003102187210ULL, 0x000fe20007f5e0ffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000003302167210ULL, 0x000fc60007f3e0ffULL, 0x0000000113137824ULL, 0x000fe200000e063dULL,
0x0000003502147210ULL, 0x000fe20007f1e0ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x000000702e4b7812ULL, 0x000fc600078ef806ULL, 0x0000008032327825ULL, 0x000fe200078e00ffULL,
0x0000007030497812ULL, 0x000fc600078ef806ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000007032477812ULL, 0x000fc600078ef806ULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000007034457812ULL, 0x000fc600078ef806ULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x000000703a437812ULL, 0x000fc600078ef806ULL, 0x000000101f1f7824ULL, 0x000fe200078e022aULL,
0x0000007038417812ULL, 0x000fe200078ef806ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x00000043023a7210ULL, 0x000fe40007f9e0ffULL, 0x000000000c1f7faeULL, 0x0003e2000b901c48ULL,
0x0000001021217824ULL, 0x000fe200078e022aULL, 0x00000070363f7812ULL, 0x000fe200078ef806ULL,
0x0000001023237824ULL, 0x100fe200078e022aULL, 0x0000004102387210ULL, 0x040fe20007fbe0ffULL,
0x0000000115157824ULL, 0x100fe200000e063dULL, 0x0000004b022e7210ULL, 0x040fe20007f1e0ffULL,
0x0000001025257824ULL, 0x100fe200078e022aULL, 0x000000000e217faeULL, 0x0003e2000b901c48ULL,
0x0000000117177824ULL, 0x100fe200008e063dULL, 0x0000004902307210ULL, 0x040fe20007f3e0ffULL,
0x0000001027277824ULL, 0x100fe200078e022aULL, 0x0000000010237faeULL, 0x0003e2000b901c48ULL,
0x0000000119197824ULL, 0x100fe200010e063dULL, 0x0000004702327210ULL, 0x040fe20007f5e0ffULL,
0x0000001029297824ULL, 0x100fe200078e022aULL, 0x0000000012257faeULL, 0x0003e2000b901c48ULL,
0x000000011b1b7824ULL, 0x000fe200018e063dULL, 0x0000004502347210ULL, 0x040fe20007f7e0ffULL,
0x000000102b2b7824ULL, 0x100fe200078e022aULL, 0x0000003f02367210ULL, 0x000fe20007fde0ffULL,
0x000000102d2d7824ULL, 0x100fe200078e022aULL, 0x0000000014277faeULL, 0x0003e2000b901c48ULL,
0x000000101c1c7824ULL, 0x000fc400078e022aULL, 0x000000012f2f7824ULL, 0x100fe200000e063dULL,
0x0000000016297faeULL, 0x0003e2000b901c48ULL, 0x000000101e1e7824ULL, 0x100fe400078e022aULL,
0x0000000131317824ULL, 0x100fe200008e063dULL, 0x00000000182b7faeULL, 0x0003e2000b901c48ULL,
0x0000001020207824ULL, 0x100fe400078e022aULL, 0x0000000133337824ULL, 0x000fe200010e063dULL,
0x000000001a2d7faeULL, 0x0003e2000b901c48ULL, 0x0000001022227824ULL, 0x000fc400078e022aULL,
0x0000000135357824ULL, 0x100fe200018e063dULL, 0x000000002e1c7faeULL, 0x0003e2000b901c48ULL,
0x000000013b3b7824ULL, 0x100fe400020e063dULL, 0x0000000139397824ULL, 0x100fe200028e063dULL,
0x00000000301e7faeULL, 0x0003e2000b901c48ULL, 0x0000001028287824ULL, 0x000fe400078e022aULL,
0x0000000137377824ULL, 0x000fe200030e063dULL, 0x0000000032207faeULL, 0x0003e8000b901c48ULL,
0x0000000034227faeULL, 0x0003e8000b901c48ULL, 0x000000003a247faeULL, 0x0003e8000b901c48ULL,
0x0000000038267faeULL, 0x0003e8000b901c48ULL, 0x0000000036287faeULL, 0x0003e4000b901c48ULL,
0x000000026c6c7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff6e7424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000796c00720cULL, 0x000fda0003f06070ULL,
0x00000002030b8824ULL, 0x002fc800078e00ffULL, 0x00006a000b0b8a24ULL, 0x000fc800078e026cULL,
0x000066000b0a8625ULL, 0x000fca00078e0046ULL, 0x000000080a6e8981ULL, 0x000322000c1e1900ULL,
0x00005800ff027624ULL, 0x000fca00078e00ffULL, 0x0000001f02027810ULL, 0x000fc80007ffe0ffULL,
0x00000005ff147819ULL, 0x000fc40000011602ULL, 0x00000000000a7805ULL, 0x002fca0000015200ULL,
0x01760400ff0d7984ULL, 0x000e620000000800ULL, 0x0000001407477224ULL, 0x000fe400078e02ffULL,
0x0000000170777824ULL, 0x000fe400078e0a66ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x800000000dff7812ULL, 0x002fe20007804805ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000620047467625ULL, 0x000fe200078e0046ULL,
0x00000008ff777819ULL, 0x000fe20000011677ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x000000060a0d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e0bULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011407ULL,
0x0000000d02027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002000027824ULL, 0x002fca00078e0205ULL,
0x00000003ff047819ULL, 0x000fc80000011602ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x0000000f02047812ULL, 0x000fc600078ec0ffULL, 0x0000000102057824ULL, 0x000fe400078e0205ULL,
0x0000001004077824ULL, 0x040fe400078e00ffULL, 0x0000001004047824ULL, 0x000fe200078e00ffULL,
0x0000000f05027812ULL, 0x040fe400078ec0ffULL, 0x0000000105057810ULL, 0x000fe40007ffe0ffULL,
0x000000f007027812ULL, 0x000fe400078ee202ULL, 0x0000000f05057812ULL, 0x000fc600078ec0ffULL,
0x0000000002107984ULL, 0x000e62000000cc00ULL, 0x000000f004057812ULL, 0x000fca00078ee205ULL,
0x00000000050c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff187224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fe400078e0013ULL, 0x000000ffff1a7224ULL, 0x004fe400078e000cULL,
0x000000ffff1b7224ULL, 0x000fc400078e000eULL, 0x000000ffff127224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe200078e000fULL, 0x0000001802007388ULL, 0x0003e8000000cc00ULL,
0x0000001005007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01760000ff0a7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0c7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x002fc80000015200ULL, 0x01760400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011407ULL,
0x0000000d02027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff7100720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x0000010009787810ULL, 0x000fe20007ffe0ffULL,
0x00000002146f7824ULL, 0x000fe200078e00ffULL, 0x00017688007a7811ULL, 0x000fe200078e18ffULL,
0x3db504f308037820ULL, 0x010fe20000410000ULL, 0xffffffff66677810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff687224ULL, 0x000fe200078e00ffULL, 0x00000009666a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00017608007c7811ULL, 0x000fc400078e28ffULL,
0x0000000268067810ULL, 0x040fe20007ffe0ffULL, 0x0000010068697824ULL, 0x000fe200078e0278ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000006e7d6e7224ULL, 0x010fe200078e02ffULL,
0x000000710600720cULL, 0x000fc40003f06070ULL, 0x0000004069057812ULL, 0x000fe400078ec0ffULL,
0x00000001046d7812ULL, 0x000fc600078e0cffULL, 0x0000000172057824ULL, 0x000fcc00078e0205ULL,
0x00000cc000008947ULL, 0x00cfea0003800000ULL, 0x00000003ff0b7819ULL, 0x102fe20000011602ULL,
0x0000000200187824ULL, 0x000fe200078e026dULL, 0x000064006e077a11ULL, 0x000fe400078038ffULL,
0x000000080b0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000010b087824ULL, 0x040fe200078e0205ULL,
0x000000040b0d7810ULL, 0x040fe40007ffe0ffULL, 0x000000100b137810ULL, 0x000fe20007ffe0ffULL,
0x000000010f1b7824ULL, 0x000fe200078e0202ULL, 0x0000000c0b117810ULL, 0x000fe20007ffe0ffULL,
0x000000080f0a7824ULL, 0x000fe200078e00ffULL, 0x00000069701a7217ULL, 0x000fe20007800000ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000000140b1f7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80a1b7812ULL, 0x000fe200078ee21bULL, 0x00000010020a7824ULL, 0x000fe200078e00ffULL,
0x000000180b297810ULL, 0x000fe20007ffe0ffULL, 0x000000010d067824ULL, 0x100fe200078e0202ULL,
0x0000001c0b2b7810ULL, 0x000fe20007ffe0ffULL, 0x000000080d237824ULL, 0x000fe200078e00ffULL,
0x000000700a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000113197824ULL, 0x100fe200078e0202ULL,
0x0000100018187811ULL, 0x000fe200078e68ffULL, 0x00000001110c7824ULL, 0x000fe200078e0202ULL,
0x0000000a08167212ULL, 0x000fe200078efcffULL, 0x0000000813087824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee206ULL, 0x0000000811257824ULL, 0x000fe200078e00ffULL,
0x000065006e067a11ULL, 0x000fe200000f3cffULL, 0x000000011a1a7824ULL, 0x000fe200078e0a69ULL,
0x0000001607167210ULL, 0x000fe20007f1e0ffULL, 0x00000001110e7824ULL, 0x000fe200078e0205ULL,
0xfffffff808197812ULL, 0x000fe200078ee219ULL, 0x000000010d087824ULL, 0x100fe200078e0205ULL,
0xfffffff825257812ULL, 0x000fe200078ee20cULL, 0x000000010f0c7824ULL, 0x000fe200078e0205ULL,
0x0000001a0d00720cULL, 0x080fe20003fa6070ULL, 0x0000000109177824ULL, 0x000fe200000e0606ULL,
0x0000001a0f00720cULL, 0x080fe20003f26070ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000001a1100720cULL, 0x000fc40003f46070ULL, 0x0000001a1300720cULL, 0x000fe20003f06070ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000a08087212ULL, 0x080fe400078efcffULL,
0x000000200b2d7810ULL, 0x000fe20007ffe0ffULL, 0x000000011f1c7824ULL, 0x100fe200078e0205ULL,
0x0000000a0c127212ULL, 0x080fe200078efcffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000708087210ULL, 0x080fe40007f7e0ffULL, 0x0000000712127210ULL, 0x000fe20007f9e0ffULL,
0x0000000113107824ULL, 0x000fe200078e0205ULL, 0x0000000a0e147212ULL, 0x000fe200078efcffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000240b2f7810ULL, 0x000fc40007ffe0ffULL,
0x000000280b317810ULL, 0x000fe20007ffe0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000a1c0c7212ULL, 0x000fc600078efcffULL, 0x0000000109097824ULL, 0x100fe200018e0606ULL,
0x0000000714147210ULL, 0x080fe20007f7e0ffULL, 0x000000010d137824ULL, 0x000fe200020e0606ULL,
0x0000000a100e7212ULL, 0x000fe200078efcffULL, 0x000000010b1c7824ULL, 0x000fe200078e0202ULL,
0x000000070c0c7210ULL, 0x080fe20007f9e0ffULL, 0x000000010f157824ULL, 0x100fe200018e0606ULL,
0x000000070e0e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000129107824ULL, 0x000fe400078e0205ULL,
0x000000011d0d7824ULL, 0x100fe200020e0606ULL, 0x000000071c1d7812ULL, 0x000fe200078ec0ffULL,
0x00000001110f7824ULL, 0x000fe200018e0606ULL, 0x0000001a0b00720cULL, 0x000fe20003f86070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0ffffff81d1d7812ULL, 0x000fc400078ef802ULL,
0x0000001a1f00720cULL, 0x040fe20003f66070ULL, 0x000000011f1e7824ULL, 0x040fe200078e0202ULL,
0x0000000a10107212ULL, 0x000fe200078efcffULL, 0x000000081f277824ULL, 0x000fe400078e00ffULL,
0x000000012b1c7824ULL, 0x000fe200078e0205ULL, 0x0000000710107210ULL, 0x000fe20007fde0ffULL,
0x000000101d217824ULL, 0x000fe200078e0218ULL, 0xfffffff827277812ULL, 0x000fe200078ee21eULL,
0x000000801c1c7825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016217faeULL, 0x0003e2000e101c48ULL, 0x000000012d1e7824ULL, 0x000fe200078e0205ULL,
0x0000000a1c1c7212ULL, 0x000fe200078efcffULL, 0x0000000111117824ULL, 0x000fe200030e0606ULL,
0x0000001a2900720cULL, 0x000fe20003f86070ULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x000000071c1c7210ULL, 0x000fc60007fde0ffULL, 0x000000012f207824ULL, 0x000fe400078e0205ULL,
0x000000011d1d7824ULL, 0x000fe200030e0606ULL, 0x0000000a1e167212ULL, 0x002fe200078efcffULL,
0x0000008020207825ULL, 0x000fc600078e00ffULL, 0x0000000716167210ULL, 0x080fe20007fde0ffULL,
0x0000000129227824ULL, 0x040fe200078e0202ULL, 0x0000000a201e7212ULL, 0x000fe200078efcffULL,
0x0000000829297824ULL, 0x000fe400078e00ffULL, 0x0000001023237824ULL, 0x000fe400078e0218ULL,
0x000000011f177824ULL, 0x000fe200030e0606ULL, 0xfffffff829297812ULL, 0x000fe200078ee222ULL,
0x000000101b1b7824ULL, 0x000fe200078e0218ULL, 0x0000000008237faeULL, 0x0003e2000e901c48ULL,
0x000000071e1e7210ULL, 0x000fe20007fde0ffULL, 0x000000012b227824ULL, 0x040fe200078e0202ULL,
0x0000001a2b00720cULL, 0x0c0fe20003fa6070ULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x00000000121b7faeULL, 0x0005e2000c901c48ULL, 0x00000001211f7824ULL, 0x000fe200030e0606ULL,
0x0000001a2d00720cULL, 0x000fe20003f26070ULL, 0x0000001025217824ULL, 0x000fe200078e0218ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee222ULL, 0x000000012d207824ULL, 0x000fc400078e0202ULL,
0x0000000131087824ULL, 0x002fe200078e0205ULL, 0x0000000014217faeULL, 0x0003e2000d101c48ULL,
0x000000082d237824ULL, 0x000fe200078e00ffULL, 0x0000001a2f00720cULL, 0x000fe20003f46070ULL,
0x0000001019197824ULL, 0x100fe400078e0218ULL, 0x0000001027137824ULL, 0x004fe200078e0218ULL,
0x0000002c0b277810ULL, 0x000fe20007ffe0ffULL, 0x000000012f227824ULL, 0x000fe200078e0202ULL,
0xfffffff823237812ULL, 0x000fe200078ee220ULL, 0x000000082f257824ULL, 0x000fe200078e00ffULL,
0x000000000e197faeULL, 0x0005e2000c101c48ULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee222ULL, 0x0000000127127824ULL, 0x000fe200078e0205ULL,
0x0000000a08087212ULL, 0x000fe200078efcffULL, 0x000000000c137faeULL, 0x0007e2000d901c48ULL,
0x0000001023217824ULL, 0x102fe400078e0218ULL, 0x0000001029157824ULL, 0x100fe200078e0218ULL,
0x0000000708087210ULL, 0x000fe20007fde0ffULL, 0x0000001025237824ULL, 0x100fe200078e0218ULL,
0x000000300b197810ULL, 0x004fe20007ffe0ffULL, 0x000000102b1b7824ULL, 0x000fe200078e0218ULL,
0x000000340b257810ULL, 0x000fe20007ffe0ffULL, 0x0000000010157faeULL, 0x0003e2000e101c48ULL,
0x0000000109097824ULL, 0x000fe200030e0606ULL, 0x000000380b297810ULL, 0x040fe20007ffe0ffULL,
0x00000080120c7825ULL, 0x008fe200078e00ffULL, 0x000000001c1b7faeULL, 0x0005e2000e901c48ULL,
0x0000003c0b2b7810ULL, 0x000fc40007ffe0ffULL, 0x00000001190e7824ULL, 0x100fe200078e0205ULL,
0x0000000a0c0c7212ULL, 0x000fe200078efcffULL, 0x0000000016217faeULL, 0x0007e2000c901c48ULL,
0x00000001310b7824ULL, 0x100fe200078e0202ULL, 0x0000001a1900720cULL, 0x080fe20003f66070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000070c0c7210ULL, 0x000fe20007fde0ffULL,
0x000000001e237faeULL, 0x0009e2000d101c48ULL, 0x0000001a3100720cULL, 0x000fe20003fa6070ULL,
0x0000000125107824ULL, 0x002fe200078e0205ULL, 0x0000000a0e0e7212ULL, 0x000fe200078efcffULL,
0x0000000831147824ULL, 0x000fe200078e00ffULL, 0x0000001a2700720cULL, 0x0c0fe20003f86070ULL,
0x0000000127127824ULL, 0x000fe200078e0202ULL, 0x0000001a2500720cULL, 0x080fe20003f46070ULL,
0x0000000827177824ULL, 0x008fe200078e00ffULL, 0xfffffff8140b7812ULL, 0x000fe200078ee20bULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000001a2900720cULL, 0x000fc40003f26070ULL,
0xfffffff817177812ULL, 0x000fe200078ee212ULL, 0x000000010d0d7824ULL, 0x000fe200030e0606ULL,
0x000000070e0e7210ULL, 0x080fe20007fde0ffULL, 0x0000000119137824ULL, 0x040fe200078e0202ULL,
0x0000000a10147212ULL, 0x000fe200078efcffULL, 0x0000000819167824ULL, 0x000fe200078e00ffULL,
0x0000001a2b00720cULL, 0x000fe20003f06070ULL, 0x0000000129127824ULL, 0x000fe400078e0205ULL,
0x000000010f0f7824ULL, 0x000fe200030e0606ULL, 0xfffffff816197812ULL, 0x000fe200078ee213ULL,
0x0000000125157824ULL, 0x040fe200078e0202ULL, 0x0000000714147210ULL, 0x000fe20007fde0ffULL,
0x0000000825167824ULL, 0x000fc400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff8161b7812ULL, 0x004fe200078ee215ULL, 0x000000012b107824ULL, 0x000fe200078e0205ULL,
0x0000000a12127212ULL, 0x000fe200078efcffULL, 0x0000000111157824ULL, 0x000fe400030e0606ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000712127210ULL, 0x000fc60007fde0ffULL,
0x0000000129057824ULL, 0x140fe200078e0202ULL, 0x0000000a100a7212ULL, 0x000fe200078efcffULL,
0x00000008291a7824ULL, 0x000fe400078e00ffULL, 0x000000012b167824ULL, 0x040fe400078e0202ULL,
0x000000082b1f7824ULL, 0x010fe200078e00ffULL, 0xfffffff81a1d7812ULL, 0x000fe200078ee205ULL,
0x0000000113137824ULL, 0x000fe200030e0606ULL, 0x000000070a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000100b057824ULL, 0x000fe200078e0218ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee216ULL,
0x0000001017077824ULL, 0x000fc400078e0218ULL, 0x0000001019177824ULL, 0x100fe200078e0218ULL,
0x0000000008057faeULL, 0x0003e2000e901c48ULL, 0x000000101b197824ULL, 0x100fe400078e0218ULL,
0x000000101d1b7824ULL, 0x100fe200078e0218ULL, 0x000000000c077faeULL, 0x0003e2000e101c48ULL,
0x000000101f1d7824ULL, 0x000fe400078e0218ULL, 0x00000001110b7824ULL, 0x000fe200030e0606ULL,
0x000000000e177faeULL, 0x0003e8000d901c48ULL, 0x0000000014197faeULL, 0x0003e8000d101c48ULL,
0x00000000121b7faeULL, 0x0003e8000c901c48ULL, 0x000000000a1d7faeULL, 0x0003e2000c101c48ULL,
0x00000b8000007947ULL, 0x000fea0003800000ULL, 0x0000000c020c7811ULL, 0x042fe200078fe8ffULL,
0x0000001002437824ULL, 0x040fe200078e00ffULL, 0x00000008020a7811ULL, 0x000fc400078fe8ffULL,
0x0000001802127811ULL, 0x000fe200078fe8ffULL, 0x000000010c097824ULL, 0x100fe200078e0202ULL,
0x0000000402087811ULL, 0x000fe200078fe8ffULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0x0000002402247811ULL, 0x000fe200078fe8ffULL, 0x000000010a077824ULL, 0x100fe200078e0202ULL,
0x0000002c02207811ULL, 0x000fe200078fe8ffULL, 0x000000080a0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff810397812ULL, 0x000fe200078ee209ULL, 0x0000000112097824ULL, 0x100fe200078e0202ULL,
0x0000001402107811ULL, 0x000fe200078fe8ffULL, 0x0000000812167824ULL, 0x000fe200078e00ffULL,
0xfffffff80e3b7812ULL, 0x000fe200078ee207ULL, 0x0000000108067824ULL, 0x100fe200078e0202ULL,
0x00000010020e7811ULL, 0x000fe200078fe8ffULL, 0x00000008083d7824ULL, 0x000fe200078e00ffULL,
0xfffffff816337812ULL, 0x000fe200078ee209ULL, 0x0000000110077824ULL, 0x000fe200078e0202ULL,
0x0000002002167811ULL, 0x000fe200078fe8ffULL, 0x0000000810147824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee206ULL, 0x000000010e067824ULL, 0x100fe200078e0202ULL,
0x00000030021e7811ULL, 0x000fe200078fe8ffULL, 0x000000080e377824ULL, 0x000fe200078e00ffULL,
0xfffffff814357812ULL, 0x000fe200078ee207ULL, 0x0000000116077824ULL, 0x000fe200078e0202ULL,
0x0000001c02147811ULL, 0x000fe200078fe8ffULL, 0x0000000816187824ULL, 0x000fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fe200078ee206ULL, 0x0000000124097824ULL, 0x100fe200078e0202ULL,
0x0000002802227811ULL, 0x000fe200078fe8ffULL, 0x00000008241a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8182f7812ULL, 0x000fe200078ee207ULL, 0x0000000114067824ULL, 0x100fe200078e0202ULL,
0x0000003c021c7811ULL, 0x000fe200078fe8ffULL, 0x0000000814317824ULL, 0x000fe200078e00ffULL,
0xfffffff81a2d7812ULL, 0x000fe200078ee209ULL, 0x0000000120077824ULL, 0x040fe200078e0202ULL,
0x0000007043437812ULL, 0x000fe200078ec0ffULL, 0x0000000820187824ULL, 0x000fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fe200078ee206ULL, 0x000000011e097824ULL, 0x100fe200078e0202ULL,
0x000064006e2a7a11ULL, 0x000fe200078038ffULL, 0x000000081e1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff818297812ULL, 0x000fe200078ee207ULL, 0x0000000122067824ULL, 0x100fe200078e0202ULL,
0x0000003402187811ULL, 0x000fe200078fe8ffULL, 0x00000008222b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a0b7812ULL, 0x000fe200078ee209ULL, 0x000000011c097824ULL, 0x000fe200078e0202ULL,
0x00000038021a7811ULL, 0x000fe200078fe8ffULL, 0x0000000818277824ULL, 0x040fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee206ULL, 0x0000000118067824ULL, 0x100fe200078e0202ULL,
0x000065006e417a11ULL, 0x000fe200000f3cffULL, 0x000000011a077824ULL, 0x000fc400078e0202ULL,
0x000000081a267824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee206ULL,
0x000000081c287824ULL, 0x000fe200078e00ffULL, 0x0000000202067211ULL, 0x000fe200078fe8ffULL,
0x000000010a0a7824ULL, 0x000fe200078e0205ULL, 0xfffffff8260d7812ULL, 0x000fe200078ee207ULL,
0x000000010c0c7824ULL, 0x000fe200078e0205ULL, 0xfffffff8280f7812ULL, 0x000fe200078ee209ULL,
0x0000000200097824ULL, 0x000fe200078e026dULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x0000000108087824ULL, 0x100fe200078e0205ULL, 0x0000000502067211ULL, 0x000fe200078fe8ffULL,
0x000000010e0e7824ULL, 0x100fe200078e0205ULL, 0x0ffffff8073f7812ULL, 0x000fe200078ef802ULL,
0x0000000110107824ULL, 0x000fe200078e0205ULL, 0x00001000092c7811ULL, 0x000fe200078e68ffULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x000000100b287824ULL, 0x000fe200078e022cULL,
0x0000004306117212ULL, 0x000fe200078efcffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0x000000112a067210ULL, 0x000fe20007f1e0ffULL, 0x000000100d267824ULL, 0x000fe200078e022cULL,
0x000000430a137212ULL, 0x000fe200078efcffULL, 0x0000000112127824ULL, 0x100fe400078e0205ULL,
0x0000000114147824ULL, 0x100fe400078e0205ULL, 0x0000000116167824ULL, 0x100fe400078e0205ULL,
0x0000000124247824ULL, 0x100fe400078e0205ULL, 0x0000000122227824ULL, 0x000fc400078e0205ULL,
0x0000000120207824ULL, 0x100fe400078e0205ULL, 0x000000011e1e7824ULL, 0x100fe400078e0205ULL,
0x0000000118187824ULL, 0x100fe400078e0205ULL, 0x000000011a1a7824ULL, 0x100fe400078e0205ULL,
0x000000011c1c7824ULL, 0x000fe400078e0205ULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000100f057824ULL, 0x000fe200078e022cULL, 0x000000430c117212ULL, 0x000fe200078efcffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0x000000112a0c7210ULL, 0x000fe20007f5e0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000004308157212ULL, 0x000fc600078efcffULL,
0x0000000107077824ULL, 0x100fe200000e0641ULL, 0x000000132a0a7210ULL, 0x000fe20007f1e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000430e137212ULL, 0x000fe400078efcffULL,
0x000000152a087210ULL, 0x040fe20007f3e0ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0641ULL,
0x000000132a0e7210ULL, 0x000fe20007f1e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000043101f7212ULL, 0x000fc600078efcffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000004316197212ULL, 0x000fc600078efcffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x00000043121d7212ULL, 0x000fe400078efcffULL, 0x000000192a167210ULL, 0x000fe20007f7e0ffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x00000043141b7212ULL, 0x000fc600078efcffULL,
0x000000010f0f7824ULL, 0x000fe200000e0641ULL, 0x0000001f2a107210ULL, 0x000fe20007f1e0ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000004324517212ULL, 0x000fc600078efcffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x00000043224f7212ULL, 0x000fc600078efcffULL,
0x0000000109097824ULL, 0x100fe200008e0641ULL, 0x0000001d2a127210ULL, 0x040fe20007f3e0ffULL,
0x000000010d0d7824ULL, 0x000fe200010e0641ULL, 0x0000001b2a147210ULL, 0x000fe20007f5e0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x00000043204d7212ULL, 0x000fc600078efcffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x000000431e4b7212ULL, 0x000fc600078efcffULL,
0x000000103f3f7824ULL, 0x000fe200078e022cULL, 0x0000004318497212ULL, 0x000fe200078efcffULL,
0x000000801a1a7825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000063f7faeULL, 0x0003e2000b901c48ULL, 0x000000103d3d7824ULL, 0x100fe200078e022cULL,
0x000000431a457212ULL, 0x000fe200078efcffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000492a187210ULL, 0x000fe40007f9e0ffULL, 0x00000000083d7faeULL, 0x0003e2000b901c48ULL,
0x000000103b3b7824ULL, 0x100fe200078e022cULL, 0x000000431c437212ULL, 0x000fe200078efcffULL,
0x0000001039397824ULL, 0x100fe200078e022cULL, 0x000000452a1a7210ULL, 0x040fe20007fbe0ffULL,
0x0000000111117824ULL, 0x100fe200000e0641ULL, 0x000000512a247210ULL, 0x040fe20007f1e0ffULL,
0x0000001037377824ULL, 0x100fe200078e022cULL, 0x000000000a3b7faeULL, 0x0003e2000b901c48ULL,
0x0000000113137824ULL, 0x100fe200008e0641ULL, 0x0000004f2a227210ULL, 0x040fe20007f3e0ffULL,
0x0000001035357824ULL, 0x100fe200078e022cULL, 0x000000000c397faeULL, 0x0003e2000b901c48ULL,
0x0000000115157824ULL, 0x100fe200010e0641ULL, 0x0000004d2a207210ULL, 0x040fe20007f5e0ffULL,
0x0000001033337824ULL, 0x100fe200078e022cULL, 0x000000000e377faeULL, 0x0003e2000b901c48ULL,
0x0000000117177824ULL, 0x000fe200018e0641ULL, 0x0000004b2a1e7210ULL, 0x040fe20007f7e0ffULL,
0x0000001031317824ULL, 0x100fe200078e022cULL, 0x000000432a1c7210ULL, 0x000fe20007fde0ffULL,
0x000000102f2f7824ULL, 0x100fe200078e022cULL, 0x0000000010357faeULL, 0x0003e2000b901c48ULL,
0x000000102d2d7824ULL, 0x000fc400078e022cULL, 0x0000000125257824ULL, 0x100fe200000e0641ULL,
0x0000000012337faeULL, 0x0003e2000b901c48ULL, 0x000000102b2b7824ULL, 0x100fe400078e022cULL,
0x0000000123237824ULL, 0x100fe200008e0641ULL, 0x0000000014317faeULL, 0x0003e2000b901c48ULL,
0x0000001029297824ULL, 0x000fe400078e022cULL, 0x0000000121217824ULL, 0x100fe200010e0641ULL,
0x00000000162f7faeULL, 0x0003e2000b901c48ULL, 0x000000011f1f7824ULL, 0x000fc400018e0641ULL,
0x0000001027277824ULL, 0x000fe200078e022cULL, 0x00000000242d7faeULL, 0x0003e2000b901c48ULL,
0x0000000119197824ULL, 0x100fe400020e0641ULL, 0x000000011b1b7824ULL, 0x100fe200028e0641ULL,
0x00000000222b7faeULL, 0x0003e2000b901c48ULL, 0x000000011d1d7824ULL, 0x000fc600030e0641ULL,
0x0000000020297faeULL, 0x0003e8000b901c48ULL, 0x000000001e287faeULL, 0x0003e8000b901c48ULL,
0x0000000018277faeULL, 0x0003e8000b901c48ULL, 0x000000001a267faeULL, 0x0003e8000b901c48ULL,
0x000000001c057faeULL, 0x0003e4000b901c48ULL, 0x0000000000057919ULL, 0x002e620000002700ULL,
0x000000026c6c7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff6e7424ULL, 0x000fc400078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000796c00720cULL, 0x000fda0003f06070ULL,
0x00000004ff078424ULL, 0x000fe400078e00ffULL, 0x00006a0005057a24ULL, 0x002fc800078e02ffULL,
0x0000000205068824ULL, 0x000fe200078e026cULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000660006068625ULL, 0x000fe200078e0007ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000008066e8981ULL, 0x000322000c1e1900ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x002fc80000000000ULL, 0xfffffff802077812ULL, 0x000fe200078ec0ffULL,
0x0000000200417824ULL, 0x000fe200078e0204ULL, 0x0000000105407810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000707077812ULL, 0x000fc400078ef802ULL,
0x0000100041417811ULL, 0x000fc600078e68ffULL, 0x0000000107067824ULL, 0x040fe400078e0205ULL,
0x0000000807097824ULL, 0x040fe400078e00ffULL, 0x0000000807087824ULL, 0x040fe400078e00ffULL,
0x0000000107077824ULL, 0x000fe200078e0240ULL, 0xfffffff809067812ULL, 0x000fc800078ee206ULL,
0xfffffff808087812ULL, 0x000fe200078ee207ULL, 0x0000001006067824ULL, 0x000fc800078e0241ULL,
0x0000001008087824ULL, 0x000fe200078e0241ULL, 0x000000000620783bULL, 0x000e680000000200ULL,
0x000000000810783bULL, 0x000ea20000000200ULL, 0x0000002000597306ULL, 0x002fe20000009400ULL,
0x00000018ff077819ULL, 0x000fe20000011421ULL, 0x0001000020447824ULL, 0x000fe200078e00ffULL,
0x00000018ff067819ULL, 0x000fe40000011420ULL, 0x00000018ff457819ULL, 0x004fc40000011411ULL,
0x00000018ff087819ULL, 0x000fe20000011422ULL, 0x00000020005c7306ULL, 0x000e620000005400ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x00000018ff4a7819ULL, 0x020fe40000011412ULL,
0x00000018ff097819ULL, 0x000fe40000011423ULL, 0x00000018ff0a7819ULL, 0x000fe20000011410ULL,
0x0000002000427306ULL, 0x0004e2000000d400ULL, 0x00000018ff527819ULL, 0x000fce0000011413ULL,
0x0000002100487306ULL, 0x000fe20000009400ULL, 0x0000010020207824ULL, 0x004fe200078e00ffULL,
0x0000005c5900720bULL, 0x002fe40003f1d000ULL, 0x0000002002597810ULL, 0x000fc80007ffe0ffULL,
0x0000002100497306ULL, 0x000e620000005400ULL, 0xfffffff859597812ULL, 0x000fc800078ec0ffULL,
0x0000000759597812ULL, 0x000fe400078ef802ULL, 0x0000000142420812ULL, 0x008fe200078efcffULL,
0x0000000700547306ULL, 0x000fe40000209400ULL, 0x0000000159407824ULL, 0x000fcc00078e0240ULL,
0x0000000700577306ULL, 0x000fe20000205400ULL, 0x000000494800720bULL, 0x002fe20003fbd000ULL,
0x0000000159497824ULL, 0x000fcc00078e0205ULL, 0x00000007004d7306ULL, 0x000ff0000020d400ULL,
0x00000045000d7306ULL, 0x000ff00000209400ULL, 0x00000045000c7306ULL, 0x000ff00000205400ULL,
0x0000004500077306ULL, 0x0003f0000020d400ULL, 0x00000021004f7306ULL, 0x0004e2000000d400ULL,
0x00000018ff457819ULL, 0x002fe20000011420ULL, 0x0001000021207824ULL, 0x000fca00078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe20000011420ULL, 0x0000002200167306ULL, 0x000fe20000009400ULL,
0x0000010021217824ULL, 0x004fca00078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe20000011421ULL,
0x0001000022217824ULL, 0x000fe200078e00ffULL, 0x0000002200177306ULL, 0x000e620000005400ULL,
0x000000014f4f5812ULL, 0x008fc600078efcffULL, 0x00000018ff607819ULL, 0x000fc80000011421ULL,
0x0000005b00207306ULL, 0x000ff00000209400ULL, 0x0000005b005d7306ULL, 0x000fe20000205400ULL,
0x000000171600720bULL, 0x002fce0003f3d000ULL, 0x0000005b00747306ULL, 0x0003f0000020d400ULL,
0x0000002200587306ULL, 0x0004e2000000d400ULL, 0x00000100225b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145bULL, 0x0000004500507306ULL, 0x000fe20000209400ULL,
0x0000000859227824ULL, 0x044fe400078e00ffULL, 0x0000000859597824ULL, 0x000fc600078e00ffULL,
0xfffffff822227812ULL, 0x000fe400078ee249ULL, 0x0000004500557306ULL, 0x000e620000205400ULL,
0x0000000158581812ULL, 0x008fe400078efcffULL, 0x0000001022167824ULL, 0x000fe200078e0241ULL,
0xfffffff859407812ULL, 0x000fc800078ee240ULL, 0x00000044004e7306ULL, 0x000fe20000209400ULL,
0x0000001040407824ULL, 0x000fce00078e0241ULL, 0x00000044005f7306ULL, 0x000ea20000205400ULL,
0x000000555000720bULL, 0x002fce0003fdd000ULL, 0x0000002300217306ULL, 0x000ff00000009400ULL,
0x0000002300227306ULL, 0x000e620000005400ULL, 0x0000005f4e00720bULL, 0x004fe20003f9d000ULL,
0x00010000234e7824ULL, 0x000fcc00078e00ffULL, 0x00000008003e7306ULL, 0x000ff00000209400ULL,
0x00000008003f7306ULL, 0x000ea20000205400ULL, 0x000000222100720bULL, 0x002fe20003f7d000ULL,
0x0000010023217824ULL, 0x000fe200078e00ffULL, 0x00000004ff227819ULL, 0x000fc80000011602ULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000000800517306ULL, 0x000e70000020d400ULL,
0x0000004a003c7306ULL, 0x000fe20000209400ULL, 0x0000003f3e00720bULL, 0x004fe20003f1d000ULL,
0x00000002053f7824ULL, 0x040fe200078e0222ULL, 0x0000000205057810ULL, 0x000fca0007ffe0ffULL,
0x0000004a003d7306ULL, 0x000fec0000205400ULL, 0x0000000151510812ULL, 0x002fe400078efcffULL,
0x0000004a00087306ULL, 0x000ff0000020d400ULL, 0x00000045004a7306ULL, 0x000e70000020d400ULL,
0x0000002300617306ULL, 0x0004f0000000d400ULL, 0x00000044004b7306ULL, 0x000ee2000020d400ULL,
0x0000000702237812ULL, 0x004fc400078ec0ffULL, 0x000000014a4a6812ULL, 0x002fe400078efcffULL,
0x00000008233e7812ULL, 0x000fe400078ef802ULL, 0x0000005d2000720bULL, 0x000fe20003fdd000ULL,
0x0000000600157306ULL, 0x000fe20000209400ULL, 0x0000000161613812ULL, 0x008fe200078efcffULL,
0x000000013e207824ULL, 0x140fe200078e023fULL, 0x000000023e3f7810ULL, 0x040fe20007ffe03fULL,
0x000000103e237824ULL, 0x040fe400078e00ffULL, 0x000000103e3e7824ULL, 0x000fc400078e00ffULL,
0x0000000600147306ULL, 0x000e620000205400ULL, 0xfffffff023207812ULL, 0x000fe400078ee220ULL,
0x000000014b4b4812ULL, 0x000fe400078efcffULL, 0x000000575400720bULL, 0x000fe20003f9d000ULL,
0x0000001020207824ULL, 0x000fe200078e00ffULL, 0x000000424b42723eULL, 0x000fe200000010ffULL,
0x0000002100557306ULL, 0x000fe20000209400ULL, 0x0000000174746812ULL, 0x000fe400078efcffULL,
0xfffffff03e3f7812ULL, 0x000fca00078ee23fULL, 0x0000002100577306ULL, 0x000ea20000205400ULL,
0x000000141500720bULL, 0x002fe40003f5d000ULL, 0x000000001614783bULL, 0x000e620000000200ULL,
0x000000014d4d4812ULL, 0x000fc800078efcffULL, 0x0000002100657306ULL, 0x0006b0000020d400ULL,
0x0000000600437306ULL, 0x000ea2000020d400ULL, 0x000000002020783bULL, 0x008ee20000000200ULL,
0x000000575500720bULL, 0x004fcc0003f3d000ULL, 0x0000000900537306ULL, 0x000fee0000209400ULL,
0x0000000165651812ULL, 0x000fe200078efcffULL, 0x00000009004c7306ULL, 0x000ea20000205400ULL,
0x0000000143432812ULL, 0x000fc800078efcffULL, 0x0000004a4343723eULL, 0x000fc600000010ffULL,
0x00000009005a7306ULL, 0x000ee2000020d400ULL, 0x00000018ff757819ULL, 0x002fe20000011415ULL,
0x0001000017597824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011414ULL,
0x00000018ff767819ULL, 0x000fc60000011417ULL, 0x0000000a000e7306ULL, 0x000fe20000209400ULL,
0x0000004c5300720bULL, 0x004fe40003f5d000ULL, 0x00000018ff4c7819ULL, 0x000fe40000011416ULL,
0x00000018ff597819ULL, 0x000fc60000011459ULL, 0x0000000a000f7306ULL, 0x000fe20000205400ULL,
0x000000422038723cULL, 0x008bea0000041838ULL, 0x000000015a5a2812ULL, 0x000fe400078efcffULL,
0x0000000a00067306ULL, 0x000fe2000020d400ULL, 0x0001000010427824ULL, 0x020fce00078e00ffULL,
0x0000005200097306ULL, 0x000ff00000209400ULL, 0x00000052000a7306ULL, 0x000ff00000205400ULL,
0x00000052000b7306ULL, 0x000ff0000020d400ULL, 0x0000005e00527306ULL, 0x000ff00000209400ULL,
0x0000005e00637306ULL, 0x000e700000205400ULL, 0x0000005e00737306ULL, 0x0004f0000020d400ULL,
0x0000006000447306ULL, 0x000fe20000209400ULL, 0x000000635200720bULL, 0x002fc40003fdd000ULL,
0x00000018ff5e7819ULL, 0x004fca000001144eULL, 0x0000006000457306ULL, 0x000e6c0000205400ULL,
0x0000000173736812ULL, 0x008fe400078efcffULL, 0x0000005c00487306ULL, 0x000fe40000209400ULL,
0x000000734d43723eULL, 0x000fcc00000010ffULL, 0x0000005c00497306ULL, 0x000ea20000205400ULL,
0x000000454400720bULL, 0x002fce0003fbd000ULL, 0x0000006000567306ULL, 0x000e70000020d400ULL,
0x0000005e004e7306ULL, 0x000fe20000209400ULL, 0x000000494800720bULL, 0x004fce0003fdd000ULL,
0x0000005e00507306ULL, 0x000ea20000205400ULL, 0x0000000156565812ULL, 0x002fce00078efcffULL,
0x00000075005f7306ULL, 0x000ff00000209400ULL, 0x0000007500607306ULL, 0x000e620000205400ULL,
0x000000504e00720bULL, 0x004fce0003f9d000ULL, 0x00000075005d7306ULL, 0x0005f0000020d400ULL,
0x0000005c005b7306ULL, 0x000ee2000020d400ULL, 0x00000018ff757819ULL, 0x004fe20000011442ULL,
0x0000010010427824ULL, 0x000fe200078e00ffULL, 0x000000605f00720bULL, 0x002fca0003f5d000ULL,
0x0000001000447306ULL, 0x000ff00000009400ULL, 0x0000001000497306ULL, 0x000fe20000005400ULL,
0x000000015b5b6812ULL, 0x008fe400078efcffULL, 0x000000015d5d2812ULL, 0x000fca00078efcffULL,
0x0000001000457306ULL, 0x0003f0000000d400ULL, 0x0000005e006b7306ULL, 0x000ea2000020d400ULL,
0x00000018ff107819ULL, 0x002fe40000011442ULL, 0x0000004f7442723eULL, 0x000fe200000010ffULL,
0x0001000015747824ULL, 0x000fc800078e00ffULL, 0x00000011004e7306ULL, 0x000fe20000009400ULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x000000422034723cULL, 0x000b620000041834ULL,
0x000000016b6b4812ULL, 0x004fcc00078efcffULL, 0x0001000011427824ULL, 0x020fe200078e00ffULL,
0x0000005b5143723eULL, 0x000fe200000010ffULL, 0x0000001100577306ULL, 0x000fe20000005400ULL,
0x0000010011517824ULL, 0x000fe400078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011442ULL,
0x000000585642723eULL, 0x000fe400000010ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000001100507306ULL, 0x000fe8000000d400ULL, 0x000000422030723cULL, 0x000b680000041830ULL,
0x00000054005c7306ULL, 0x000fe60000209400ULL, 0x000000655a43723eULL, 0x020fe200000010ffULL,
0x0001000014657824ULL, 0x040fe200078e00ffULL, 0x000000616b42723eULL, 0x000fe200000010ffULL,
0x00000100146b7824ULL, 0x000fc400078e00ffULL, 0x00000054005e7306ULL, 0x000e620000205400ULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000018ff6b7819ULL, 0x000fe2000001146bULL,
0x00000042202c723cULL, 0x000b68000004182cULL, 0x0000007300557306ULL, 0x000ff00000209400ULL,
0x0000007300567306ULL, 0x000fe20000205400ULL, 0x0000005e5c00720bULL, 0x002fe20003fbd000ULL,
0x00010000125e7824ULL, 0x000fcc00078e00ffULL, 0x0000007300117306ULL, 0x000ff0000020d400ULL,
0x00000014005a7306ULL, 0x000ff00000009400ULL, 0x0000001400617306ULL, 0x000e700000005400ULL,
0x0000001500427306ULL, 0x020ff00000009400ULL, 0x0000001500437306ULL, 0x000ea20000005400ULL,
0x000000615a00720bULL, 0x002fce0003f9d000ULL, 0x0000006500607306ULL, 0x000ff00000209400ULL,
0x0000006500737306ULL, 0x000e620000205400ULL, 0x000000434200720bULL, 0x004fce0003f7d000ULL,
0x00000014005c7306ULL, 0x000ea2000000d400ULL, 0x000000736000720bULL, 0x002fce0003f1d000ULL,
0x0000006b00147306ULL, 0x000fe20000209400ULL, 0x0000010015737824ULL, 0x000fca00078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000006b00617306ULL, 0x000e620000205400ULL,
0x000000015c5c4812ULL, 0x004fce00078efcffULL, 0x0000007400437306ULL, 0x000ff00000209400ULL,
0x0000007400607306ULL, 0x000ea20000205400ULL, 0x000000611400720bULL, 0x002fce0003fdd000ULL,
0x0000005400647306ULL, 0x000e70000020d400ULL, 0x0000004c00627306ULL, 0x000fe20000209400ULL,
0x000000604300720bULL, 0x004fce0003f3d000ULL, 0x0000004c00637306ULL, 0x000ea20000205400ULL,
0x0000000164645812ULL, 0x002fce00078efcffULL, 0x0000004c00547306ULL, 0x000e70000020d400ULL,
0x00000075004c7306ULL, 0x000fe20000209400ULL, 0x000000636200720bULL, 0x004fe20003f9d000ULL,
0x0001000016637824ULL, 0x000fca00078e00ffULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x00000075004a7306ULL, 0x000fec0000205400ULL, 0x0000000154544812ULL, 0x002fe400078efcffULL,
0x0000007500487306ULL, 0x0003f0000020d400ULL, 0x0000007600527306ULL, 0x000fe20000209400ULL,
0x00000018ff757819ULL, 0x002fce000001145eULL, 0x00000075005e7306ULL, 0x000ff00000209400ULL,
0x00000075005f7306ULL, 0x000ff00000205400ULL, 0x00000075005a7306ULL, 0x000ff0000020d400ULL,
0x0000006500757306ULL, 0x0002b0000020d400ULL, 0x0000007600537306ULL, 0x000fe20000205400ULL,
0x0000010012657824ULL, 0x002fce00078e00ffULL, 0x00000076004b7306ULL, 0x000fe2000020d400ULL,
0x0000000175750812ULL, 0x004fce00078efcffULL, 0x0000007300147306ULL, 0x000ff00000209400ULL,
0x0000007300607306ULL, 0x000e700000205400ULL, 0x0000006b00767306ULL, 0x000eb0000020d400ULL,
0x0000007400437306ULL, 0x0006e2000020d400ULL, 0x000000601400720bULL, 0x002fc40003f1d000ULL,
0x0000005c7514723eULL, 0x000fca00000010ffULL, 0x0000001500427306ULL, 0x000262000000d400ULL,
0x0000000176766812ULL, 0x004fe400078efcffULL, 0x00000018ff747819ULL, 0x008fca0000011465ULL,
0x00000073006b7306ULL, 0x000ea2000020d400ULL, 0x000000766415723eULL, 0x002fe400000010ffULL,
0x0000000143431812ULL, 0x000fe400078efcffULL, 0x0000000142423812ULL, 0x000fc600078efcffULL,
0x000000142028723cULL, 0x000b620000041828ULL, 0x0000001600627306ULL, 0x000fe20000009400ULL,
0x000000016b6b0812ULL, 0x004fca00078efcffULL, 0x000000424314723eULL, 0x020fe400000010ffULL,
0x0000001200617306ULL, 0x000fe20000009400ULL, 0x0000006b5d15723eULL, 0x000fce00000010ffULL,
0x0000001600437306ULL, 0x000e620000005400ULL, 0x000000142024723cULL, 0x000b6e0000041824ULL,
0x0000010016157824ULL, 0x020fe200078e00ffULL, 0x0000001200607306ULL, 0x000ea80000005400ULL,
0x00000018ff157819ULL, 0x000fc40000011415ULL, 0x000000436200720bULL, 0x002fe40003f5d000ULL,
0x00000012005c7306ULL, 0x000e70000000d400ULL, 0x0000007400647306ULL, 0x000fe20000209400ULL,
0x000000606100720bULL, 0x004fce0003fdd000ULL, 0x0000007400657306ULL, 0x000fec0000205400ULL,
0x000000015c5c6812ULL, 0x002fe400078efcffULL, 0x0000007400127306ULL, 0x000ff0000020d400ULL,
0x0000006300427306ULL, 0x000ff00000209400ULL, 0x0000006300737306ULL, 0x000e700000205400ULL,
0x0000001700437306ULL, 0x000ff00000009400ULL, 0x0000001700747306ULL, 0x000ea20000005400ULL,
0x000000734200720bULL, 0x002fce0003f7d000ULL, 0x00000016005d7306ULL, 0x000e70000000d400ULL,
0x00000015006b7306ULL, 0x000fe20000209400ULL, 0x000000744300720bULL, 0x004fe40003f1d000ULL,
0x000000004040783bULL, 0x000eaa0000000200ULL, 0x0000001500167306ULL, 0x000ee20000205400ULL,
0x000000015d5d2812ULL, 0x002fce00078efcffULL, 0x0000005900627306ULL, 0x000ff00000209400ULL,
0x0000005900757306ULL, 0x000e620000205400ULL, 0x000000166b00720bULL, 0x008fe20003fbd000ULL,
0x00000100176b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001146bULL,
0x0000006300147306ULL, 0x000ee2000020d400ULL, 0x000000756200720bULL, 0x002fce0003f3d000ULL,
0x0000006b00737306ULL, 0x000fe20000209400ULL, 0x0001000040607824ULL, 0x004fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe40000011443ULL, 0x0000000114143812ULL, 0x008fc800078efcffULL,
0x0000006b00627306ULL, 0x000e620000205400ULL, 0x000000535200720bULL, 0x000fe40003f7d000ULL,
0x0000005d1414723eULL, 0x000fe400000010ffULL, 0x00000018ff5d7819ULL, 0x000fc60000011440ULL,
0x0000001500637306ULL, 0x000eac000020d400ULL, 0x000000014b4b3812ULL, 0x000fe400078efcffULL,
0x00000010004f7306ULL, 0x000fe20000209400ULL, 0x000000627300720bULL, 0x002fe40003f5d000ULL,
0x00000018ff627819ULL, 0x000fca0000011441ULL, 0x00000010004d7306ULL, 0x000e620000205400ULL,
0x0000000163635812ULL, 0x004fe400078efcffULL, 0x0000004a4c00720bULL, 0x000fe20003fbd000ULL,
0x00000100404c7824ULL, 0x000fe200078e00ffULL, 0x000000635415723eULL, 0x000fe400000010ffULL,
0x00000018ff637819ULL, 0x000fe20000011442ULL, 0x0000001700167306ULL, 0x000ea8000000d400ULL,
0x00000014201c723cULL, 0x000b68000004181cULL, 0x0000005900177306ULL, 0x000ee2000020d400ULL,
0x0000004d4f00720bULL, 0x002fe20003f7d000ULL, 0x00010000414d7824ULL, 0x040fe200078e00ffULL,
0x0000000148485812ULL, 0x000fe200078efcffULL, 0x00000100414f7824ULL, 0x000fe200078e00ffULL,
0x000000565500720bULL, 0x000fc40003fbd000ULL, 0x00000018ff557819ULL, 0x000fe2000001144dULL,
0x0000006b00527306ULL, 0x000e62000020d400ULL, 0x0000000116160812ULL, 0x004fe400078efcffULL,
0x000000494400720bULL, 0x000fe20003f1d000ULL, 0x0000010013497824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fc6000001144fULL, 0x0000001000107306ULL, 0x000ea2000020d400ULL,
0x0000000117171812ULL, 0x008fe400078efcffULL, 0x0000000f0e00720bULL, 0x000fe40003f3d000ULL,
0x000000161714723eULL, 0x020fe400000010ffULL, 0x00000018ff767819ULL, 0x000fe20000011449ULL,
0x00000013006b7306ULL, 0x000fe20000009400ULL, 0x0000000152522812ULL, 0x002fe400078efcffULL,
0x000000574e00720bULL, 0x000fc40003f5d000ULL, 0x000000524b15723eULL, 0x000fe400000010ffULL,
0x0000000145450812ULL, 0x000fe200078efcffULL, 0x0000001300737306ULL, 0x000e620000005400ULL,
0x0000000110103812ULL, 0x004fe400078efcffULL, 0x0000000c0d00720bULL, 0x000fe20003f7d000ULL,
0x000000142018723cULL, 0x000b620000041818ULL, 0x0000000106061812ULL, 0x000fe400078efcffULL,
0x0000003d3c00720bULL, 0x000fe20003f3d000ULL, 0x0000005100587306ULL, 0x000fe20000209400ULL,
0x0000000111115812ULL, 0x000fc400078efcffULL, 0x0000000150502812ULL, 0x000fc800078efcffULL,
0x000000501150723eULL, 0x000fe200000010ffULL, 0x00000051005b7306ULL, 0x000ea20000205400ULL,
0x000000736b00720bULL, 0x002fe40003f9d000ULL, 0x0000000107073812ULL, 0x000fe400078efcffULL,
0x000000656400720bULL, 0x000fe40003f7d000ULL, 0x0000000108081812ULL, 0x000fe200078efcffULL,
0x0000005d00547306ULL, 0x000ff00000209400ULL, 0x0000005d00537306ULL, 0x000e620000205400ULL,
0x0000005b5800720bULL, 0x004fc40003f1d000ULL, 0x0000000112123812ULL, 0x000fca00078efcffULL,
0x0000005d00167306ULL, 0x0004f0000020d400ULL, 0x0000006300237306ULL, 0x020fe20000209400ULL,
0x00010000135d7824ULL, 0x004fe200078e00ffULL, 0x000000535400720bULL, 0x002fe20003f7d000ULL,
0x0001000043547824ULL, 0x000fc600078e00ffULL, 0x00000018ff747819ULL, 0x000fe4000001145dULL,
0x0000006300597306ULL, 0x000fe20000205400ULL, 0x00000018ff547819ULL, 0x000fcc0000011454ULL,
0x0000000116163812ULL, 0x008fe200078efcffULL, 0x0000006300157306ULL, 0x000fe2000020d400ULL,
0x0000000a0900720bULL, 0x000fce0003f7d000ULL, 0x00000074005d7306ULL, 0x000fec0000209400ULL,
0x000000010b0b3812ULL, 0x000fe400078efcffULL, 0x0000007400637306ULL, 0x000ff00000205400ULL,
0x0000007400447306ULL, 0x0003f0000020d400ULL, 0x0000005100517306ULL, 0x000ea2000020d400ULL,
0x00000018ff747819ULL, 0x002fce0000011460ULL, 0x0000007500207306ULL, 0x000ff00000209400ULL,
0x0000007500217306ULL, 0x000fe20000205400ULL, 0x0000000151510812ULL, 0x004fe400078efcffULL,
0x0000005f5e00720bULL, 0x000fc40003f1d000ULL, 0x000000510751723eULL, 0x000fc600000010ffULL,
0x0000007500147306ULL, 0x000ff0000020d400ULL, 0x00000040004e7306ULL, 0x000fe20000009400ULL,
0x000000015a5a0812ULL, 0x000fc800078efcffULL, 0x0000005c5a5a723eULL, 0x000fc600000010ffULL,
0x0000004000757306ULL, 0x000e700000005400ULL, 0x00000074006b7306ULL, 0x000ff00000209400ULL,
0x0000007400737306ULL, 0x000ea20000205400ULL, 0x000000754e00720bULL, 0x002fce0003fbd000ULL,
0x00000062004b7306ULL, 0x000ff00000209400ULL, 0x0000006200527306ULL, 0x000fe20000205400ULL,
0x000000736b00720bULL, 0x004fce0003fdd000ULL, 0x0000006200177306ULL, 0x000ff0000020d400ULL,
0x0000001300227306ULL, 0x000e70000000d400ULL, 0x0000007600627306ULL, 0x000ff00000209400ULL,
0x0000007600577306ULL, 0x000fe20000205400ULL, 0x0000000122224812ULL, 0x002fce00078efcffULL,
0x0000007600137306ULL, 0x0003f0000020d400ULL, 0x00000041000e7306ULL, 0x000fe20000009400ULL,
0x00000018ff767819ULL, 0x002fce000001144cULL, 0x00000041000f7306ULL, 0x000e700000005400ULL,
0x0000007600607306ULL, 0x000ff00000209400ULL, 0x0000007600617306ULL, 0x000ea20000205400ULL,
0x0000000f0e00720bULL, 0x002fe20003f5d000ULL, 0x00010000420e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff0e7819ULL, 0x000fe2000001140eULL, 0x0000004000497306ULL, 0x000e70000000d400ULL,
0x00000074004a7306ULL, 0x000ee2000020d400ULL, 0x000000616000720bULL, 0x004fce0003f3d000ULL,
0x0000007600407306ULL, 0x000ea2000020d400ULL, 0x0000000149495812ULL, 0x002fe400078efcffULL,
0x000000635d00720bULL, 0x000fe20003fbd000ULL, 0x00000100435d7824ULL, 0x000fc800078e00ffULL,
0x00000042000c7306ULL, 0x000fe20000009400ULL, 0x000000014a4a6812ULL, 0x008fe400078efcffULL,
0x00000018ff097819ULL, 0x000fe4000001145dULL, 0x000000494a4a723eULL, 0x000fc600000010ffULL,
0x00000042000d7306ULL, 0x000e620000005400ULL, 0x0000000140401812ULL, 0x004fe400078efcffULL,
0x0000000144445812ULL, 0x000fe400078efcffULL, 0x000000524b00720bULL, 0x000fe40003fbd000ULL,
0x00000040164b723eULL, 0x000fe200000010ffULL, 0x0000005500747306ULL, 0x000fe20000209400ULL,
0x00000022440a723eULL, 0x000fce00000010ffULL, 0x0000005500767306ULL, 0x000ea20000205400ULL,
0x0000000d0c00720bULL, 0x002fe20003f1d000ULL, 0x00000100420c7824ULL, 0x000fe200078e00ffULL,
0x0000000117175812ULL, 0x000fc800078efcffULL, 0x00000018ff3c7819ULL, 0x000fe2000001140cULL,
0x00000056004f7306ULL, 0x000fe20000209400ULL, 0x000000103f0c7824ULL, 0x000fce00078e00ffULL,
0x00000056005b7306ULL, 0x000e620000205400ULL, 0x000000767400720bULL, 0x004fce0003fdd000ULL,
0x00000043003d7306ULL, 0x000ff00000009400ULL, 0x0000004300607306ULL, 0x000ea20000005400ULL,
0x0000005b4f00720bULL, 0x002fe40003f9d000ULL, 0x00000012085b723eULL, 0x000fca00000010ffULL,
0x00000055004d7306ULL, 0x000e70000020d400ULL, 0x0000000e00557306ULL, 0x000fe20000209400ULL,
0x000000603d00720bULL, 0x004fe40003f3d000ULL, 0x00000010063d723eULL, 0x000fca00000010ffULL,
0x0000000e005e7306ULL, 0x000ea20000205400ULL, 0x000000014d4d6812ULL, 0x002fe400078efcffULL,
0x000000576200720bULL, 0x000fca0003fdd000ULL, 0x00000041004c7306ULL, 0x000e70000000d400ULL,
0x00000042004e7306ULL, 0x000ee2000000d400ULL, 0x0000005e5500720bULL, 0x004fe40003f7d000ULL,
0x0000000113136812ULL, 0x000fc400078efcffULL, 0x000000592300720bULL, 0x000fe40003fdd000ULL,
0x000000130b0b723eULL, 0x000fe200000010ffULL, 0x0000005600417306ULL, 0x000ea2000020d400ULL,
0x000000014c4c2812ULL, 0x002fe400078efcffULL, 0x000000212000720bULL, 0x000fe40003f5d000ULL,
0x0000004c4d16723eULL, 0x000fc600000010ffULL, 0x0000000e00427306ULL, 0x0002a2000020d400ULL,
0x000000014e4e0812ULL, 0x008fe400078efcffULL, 0x000000080500780cULL, 0x000fe40003f05270ULL,
0x0000000115156812ULL, 0x000fc600078efcffULL, 0x0000003c00567306ULL, 0x000fe20000209400ULL,
0x000000000c0c783bULL, 0x002e620000000200ULL, 0x0000000141414812ULL, 0x004fe400078efcffULL,
0x0000000114142812ULL, 0x000fe400078efcffULL, 0x000000411717723eULL, 0x000fe400000010ffULL,
0x0000003c00587306ULL, 0x000ea20000205400ULL, 0x0000000142423812ULL, 0x000fc800078efcffULL,
0x0000004e4242723eULL, 0x000fc600000010ffULL, 0x0000005400537306ULL, 0x000ff00000209400ULL,
0x0000005400067306ULL, 0x000ee20000205400ULL, 0x000000585600720bULL, 0x004fce0003f9d000ULL,
0x0000000900077306ULL, 0x000ff00000209400ULL, 0x0000000900087306ULL, 0x000ea20000205400ULL,
0x000000065300720bULL, 0x008fe20003fbd000ULL, 0x000000500c34723cULL, 0x042b6c0000041834ULL,
0x0000003c003e7306ULL, 0x0002e4000020d400ULL, 0x0000005a0c30723cULL, 0x040b6c0000041830ULL,
0x00000043003f7306ULL, 0x0006e2000000d400ULL, 0x000000080700720bULL, 0x004fe20003f7d000ULL,
0x0000000a0c2c723cULL, 0x000b62000004182cULL, 0x00000045483c723eULL, 0x002fca00000010ffULL,
0x0000005400547306ULL, 0x000e62000020d400ULL, 0x000000013e3e4812ULL, 0x008fe200078efcffULL,
0x0000003c0c38723cULL, 0x000b660000041838ULL, 0x0000003e1543723eULL, 0x000fc600000010ffULL,
0x0000000900557306ULL, 0x000ea2000020d400ULL, 0x000000013f3f1812ULL, 0x000fe200078efcffULL,
0x0000004a0c28723cULL, 0x000b620000041828ULL, 0x0000000154545812ULL, 0x002fce00078efcffULL,
0x000000160c24723cULL, 0x000b620000041824ULL, 0x0000003f5454723eULL, 0x000fe400000010ffULL,
0x0000000155553812ULL, 0x004fca00078efcffULL, 0x000000420c1c723cULL, 0x000b62000004181cULL,
0x000000551455723eULL, 0x000fce00000010ffULL, 0x000000540c18723cULL, 0x000b620000041818ULL,
0x0000001000008944ULL, 0x000fe20003c00000ULL, 0xffffe11000007947ULL, 0x000fcc000383ffffULL,
0x0000000331317220ULL, 0x0a0fe40000410000ULL, 0x000000032d2d7220ULL, 0x080fe40000410000ULL,
0x0000000339397220ULL, 0x080fe40000410000ULL, 0x0000000334347220ULL, 0x080fe40000410000ULL,
0x0000000335357220ULL, 0x080fe40000410000ULL, 0x0000000330307220ULL, 0x000fc40000410000ULL,
0x000000032c047220ULL, 0x080fe40000410000ULL, 0x000000031c1c7220ULL, 0x080fe40000410000ULL,
0x000000032a157220ULL, 0x080fe40000410000ULL, 0x0000000327087220ULL, 0x080fe40000410000ULL,
0x000000032e237220ULL, 0x080fe40000410000ULL, 0x000000032f067220ULL, 0x000fc40000410000ULL,
0x00000003242a7220ULL, 0x080fe40000410000ULL, 0x000000ffff277224ULL, 0x000fe400078e0031ULL,
0x00000003282f7220ULL, 0x080fe40000410000ULL, 0x000000032b147220ULL, 0x080fe40000410000ULL,
0x00000003252e7220ULL, 0x080fe40000410000ULL, 0x0000000326077220ULL, 0x000fc40000410000ULL,
0x0000000318247220ULL, 0x080fe40000410000ULL, 0x000000031b137220ULL, 0x080fe40000410000ULL,
0x000000ffff317224ULL, 0x000fe400078e002dULL, 0x0000000338177220ULL, 0x080fe40000410000ULL,
0x000000033a3a7220ULL, 0x080fe40000410000ULL, 0x000000033b167220ULL, 0x000fc40000410000ULL,
0x0000000336367220ULL, 0x080fe40000410000ULL, 0x0000000337227220ULL, 0x080fe40000410000ULL,
0x0000000332217220ULL, 0x080fe40000410000ULL, 0x0000000333207220ULL, 0x080fe40000410000ULL,
0x0000000329297220ULL, 0x080fe40000410000ULL, 0x000000031d2b7220ULL, 0x000fc40000410000ULL,
0x000000031e107220ULL, 0x080fe40000410000ULL, 0x000000031f117220ULL, 0x080fe40000410000ULL,
0x0000000319187220ULL, 0x080fe40000410000ULL, 0x000000031a127220ULL, 0x000fe40000410000ULL,
0x000000ffff257224ULL, 0x000fe400078e0039ULL, 0x000000ffff267224ULL, 0x000fc400078e0034ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0035ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0030ULL,
0x000000ffff287224ULL, 0x000fe400078e0004ULL, 0x000000ffff2d7224ULL, 0x000fe200078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000007a047f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1e7224ULL, 0x000fe400078e003aULL, 0x000000ffff1f7224ULL, 0x000fc400078e0036ULL,
0x000000ffff307224ULL, 0x000fe400078e0006ULL, 0x000000ffff197224ULL, 0x000fe400078e0007ULL,
0x000000ffff1a7224ULL, 0x000fc400078e0008ULL, 0x0000000000067805ULL, 0x002fca0000015200ULL,
0x000004007a097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x006fe40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000000b08087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004007a097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004021d7824ULL, 0x000fe200078e00ffULL, 0x000000776800720cULL, 0x000fc80003f06070ULL,
0xfffffff01d057812ULL, 0x000fca00078ec0ffULL, 0x00000080001c7824ULL, 0x000fca00078e0205ULL,
0x017400001c047984ULL, 0x0002a20000000c00ULL, 0x000014f000008947ULL, 0x000fea0003800000ULL,
0x00005a00000a7b06ULL, 0x000ee20000209000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0xffffff0069697810ULL, 0x000fe20007ffe0ffULL, 0x0000000202337824ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f85070ULL, 0x0000006970327217ULL, 0x000fe40007800000ULL,
0x0000000633337812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff0e7a12ULL, 0x000fe200078e33ffULL,
0x0000000132327824ULL, 0x000fc400078e0a69ULL, 0x0000000133357824ULL, 0x000fe200078e0266ULL,
0x0000000a000a7308ULL, 0x008ee40000001000ULL, 0x0ffffffe0a0c7810ULL, 0x008fcc0007ffe0ffULL,
0x0000000c00097305ULL, 0x000ee4000021f000ULL, 0x000000ffff0b7224ULL, 0x008fc800078e0a09ULL,
0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b090d7227ULL, 0x000fe200078e0008ULL,
0x0000007b02087211ULL, 0x000fca00078ff0ffULL, 0x000000080d097227ULL, 0x000fc800078e00ffULL,
0x000000ffff0b7224ULL, 0x000fc800078e0a09ULL, 0x00005a000b0a7a24ULL, 0x000fe200078e0208ULL,
0x0000000808087810ULL, 0x000fc80007ffe0ffULL, 0x00005a000a007a0cULL, 0x000fe20003f06070ULL,
0x000000080d0d7227ULL, 0x000fc800078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc800078e0a0dULL,
0x00005a000b0c7a24ULL, 0x000fe400078e0208ULL, 0x000000016a0b7824ULL, 0x000fe400078e0233ULL,
0x80005a000a0a0a10ULL, 0x000fe40007ffe0ffULL, 0x00005a000c007a0cULL, 0x000fe40003f46070ULL,
0x00005a000a007a0cULL, 0x000fe20003f26070ULL, 0x000000010b0a7824ULL, 0x000fe200078e0a32ULL,
0x0000000109090810ULL, 0x000fc40007ffe0ffULL, 0x000000320b00720cULL, 0x000fce0003f66070ULL,
0x80005a000c0c2a10ULL, 0x000fe40007ffe0ffULL, 0x0000000109091810ULL, 0x000fe40007ffe0ffULL,
0x00005a000c007a0cULL, 0x000fe40003f06070ULL, 0x000000090e087207ULL, 0x000fe40006000000ULL,
0x0000000a67097217ULL, 0x000fe20003800000ULL, 0x00000001350a7824ULL, 0x000fe200078e0a32ULL,
0x0000000867087217ULL, 0x000fc40003800000ULL, 0x00000004ff097819ULL, 0x000fe40000011609ULL,
0x000000010d0d2810ULL, 0x000fe20007ffe0ffULL, 0x000000086f4f7224ULL, 0x000fe200078e02ffULL,
0x000000ff090c7207ULL, 0x000fe40001800000ULL, 0x000000323500720cULL, 0x000fe40003f26070ULL,
0x0000000a670a7217ULL, 0x000fe20003800000ULL, 0x000000014f097824ULL, 0x000fe200078e020cULL,
0x000000010d0d0810ULL, 0x000fc40007ffe0ffULL, 0x000000ff0a427207ULL, 0x000fe20000800000ULL,
0x0000000209087825ULL, 0x000fe200078e0046ULL, 0x0000000d0e0e7207ULL, 0x000fe40006000000ULL,
0x0000001033397812ULL, 0x000fe400078efcffULL, 0x0000004f420b7211ULL, 0x000fe200078fe0ffULL,
0x0000000808487981ULL, 0x0046a2000c1e9500ULL, 0x0000000e670e7217ULL, 0x000fc60003800000ULL,
0x000000020b0a7825ULL, 0x000fc800078e0046ULL, 0x000000016a097824ULL, 0x008fe200078e0239ULL,
0x000000080a4d7981ULL, 0x0006a2000c1e9500ULL, 0x0000000e6f517224ULL, 0x000fe400078e02ffULL,
0x0000000109087824ULL, 0x000fe400078e0a32ULL, 0x000000010c0d7824ULL, 0x000fe200078e0251ULL,
0x00000020333b7812ULL, 0x000fe200078efcffULL, 0x0000000139377824ULL, 0x000fe200078e0266ULL,
0x00000008670a7217ULL, 0x008fe20003800000ULL, 0x000000020d0c7825ULL, 0x000fe200078e0046ULL,
0x000000320900720cULL, 0x000fc40003f26070ULL, 0x00000004ff0a7819ULL, 0x000fe2000001160aULL,
0x0000000137087824ULL, 0x140fe200078e0a32ULL, 0x000000080c407981ULL, 0x0006a2000c1e9500ULL,
0x000000016a417824ULL, 0x000fe200078e023bULL, 0x000000323700720cULL, 0x000fe40003f06070ULL,
0x0000000867087217ULL, 0x000fe20003800000ULL, 0x00000001413a7824ULL, 0x000fe200078e0a32ULL,
0x000000ff0a0c7207ULL, 0x008fe40000800000ULL, 0x00000051420f7211ULL, 0x000fc600078fe0ffULL,
0x000000014f097824ULL, 0x000fe200078e020cULL, 0x000000ff08347207ULL, 0x000fe40000000000ULL,
0x0000003a673a7217ULL, 0x000fe20003800000ULL, 0x0000000209087825ULL, 0x000fe200078e0046ULL,
0x000000324100720cULL, 0x000fe40003f26070ULL, 0x00000004ff3a7819ULL, 0x000fe2000001163aULL,
0x000000020f0e7825ULL, 0x000fe200078e0046ULL, 0x0000000808367981ULL, 0x0006a6000c1e9500ULL,
0x000000013b3f7824ULL, 0x000fe200078e0266ULL, 0x000000080e557981ULL, 0x0002a2000c1e9500ULL,
0x000000ff3a3c7207ULL, 0x000fc40000800000ULL, 0x0000003033417812ULL, 0x000fe200078efcffULL,
0x000000013f087824ULL, 0x048fe200078e0a32ULL, 0x0000004f340b7211ULL, 0x000fe200078fe0ffULL,
0x000000010c0d7824ULL, 0x000fe200078e0251ULL, 0x000000323f00720cULL, 0x000fe40003f06070ULL,
0x00000051340f7211ULL, 0x002fe200078fe0ffULL, 0x000000014f097824ULL, 0x000fe200078e023cULL,
0x0000000867087217ULL, 0x000fe20003800000ULL, 0x000000016a537824ULL, 0x000fe400078e0241ULL,
0x000000020b0a7825ULL, 0x000fe200078e0046ULL, 0x000000ff083e7207ULL, 0x000fc60000000000ULL,
0x000000020d0c7825ULL, 0x100fe200078e0046ULL, 0x000000080a3d7981ULL, 0x0002e6000c1e9500ULL,
0x000000020f0e7825ULL, 0x100fe200078e0046ULL, 0x000000080c387981ULL, 0x0002e6000c1e9500ULL,
0x0000000209087825ULL, 0x000fe200078e0046ULL, 0x000000080e437981ULL, 0x0002e6000c1e9500ULL,
0x0000000153447824ULL, 0x000fe200078e0a32ULL, 0x00000008083a7981ULL, 0x0002e2000c1e9500ULL,
0x0000000141497824ULL, 0x000fe200078e0266ULL, 0x0000004f3e0b7211ULL, 0x002fc400078fe0ffULL,
0x0000004467447217ULL, 0x000fe20003800000ULL, 0x000000013c0d7824ULL, 0x000fe200078e0251ULL,
0x000000513e0f7211ULL, 0x000fe200078fe0ffULL, 0x0000000149087824ULL, 0x000fe200078e0a32ULL,
0x000000325300720cULL, 0x080fe40003f26070ULL, 0x00000004ff447819ULL, 0x000fe20000011644ULL,
0x000000020b0a7825ULL, 0x100fe200078e0046ULL, 0x000000324900720cULL, 0x000fe40003f06070ULL,
0x0000000867087217ULL, 0x000fe20003800000ULL, 0x000000020d0c7825ULL, 0x100fe200078e0046ULL,
0x000000ff444a7207ULL, 0x000fe20000800000ULL, 0x000000080a457981ULL, 0x0002e4000c1e9500ULL,
0x000000020f0e7825ULL, 0x000fe200078e0046ULL, 0x000000ff08447207ULL, 0x000fe20000000000ULL,
0x000000080c3c7981ULL, 0x0002e8000c1e9500ULL, 0x000000080e4b7981ULL, 0x0002e2000c1e9500ULL,
0x000000014f097824ULL, 0x000fe200078e024aULL, 0x0000004f440b7211ULL, 0x002fc600078fe0ffULL,
0x0000000209087825ULL, 0x000fc800078e0046ULL, 0x000000020b0a7825ULL, 0x000fe400078e0046ULL,
0x0000000808087981ULL, 0x0002e2000c1e9500ULL, 0x00000051440d7211ULL, 0x000fc600078fe0ffULL,
0x000000080a0b7981ULL, 0x0002e2000c1e9500ULL, 0x000000014a0f7824ULL, 0x000fe400078e0251ULL,
0x000000020d0c7825ULL, 0x000fc800078e0046ULL, 0x000000020f0e7825ULL, 0x000fe400078e0046ULL,
0x000000080c0c7981ULL, 0x0002e8000c1e9500ULL, 0x000000080e0f7981ULL, 0x0002e2000c1e9500ULL,
0xfffffff042517812ULL, 0x000fe200078ec0ffULL, 0x00000001ff427424ULL, 0x000fc800078e00ffULL,
0x00000001324a7824ULL, 0x000fc800078e0251ULL, 0x0000000135577824ULL, 0x000fe200078e0a4aULL,
0x0000000933097812ULL, 0x002fc800078efcffULL, 0x0000005742577219ULL, 0x000fe200000006ffULL,
0x00000001090d7824ULL, 0x000fe200078e0266ULL, 0xfffffff034347812ULL, 0x000fc600078ec0ffULL,
0x000000010d5d7824ULL, 0x000fe200078e0a4aULL, 0x0000001133697812ULL, 0x040fe400078efcffULL,
0x00000001334f7812ULL, 0x040fe400078efcffULL, 0x0000001833657812ULL, 0x040fe400078efcffULL,
0x0000005d425d7219ULL, 0x000fe200000006ffULL, 0x0000000132347824ULL, 0x000fe200078e0234ULL,
0x0000001933637812ULL, 0x000fe400078efcffULL, 0xfffffff03e3e7812ULL, 0x000fe200078ec0ffULL,
0x0000000169757824ULL, 0x000fc400078e0266ULL, 0x000000014f537824ULL, 0x100fe400078e0266ULL,
0x0000000165737824ULL, 0x100fe400078e0266ULL, 0x00000001636b7824ULL, 0x000fe400078e0266ULL,
0x00000001325a7824ULL, 0x000fe400078e023eULL, 0x00000001370e7824ULL, 0x100fe400078e0a34ULL,
0x00000001753e7824ULL, 0x000fc400078e0a34ULL, 0x0000000153597824ULL, 0x000fe400078e0a4aULL,
0x00000001734e7824ULL, 0x100fe400078e0a34ULL, 0x000000016b5e7824ULL, 0x000fe200078e0a34ULL,
0x0000000e42347219ULL, 0x040fe400000006ffULL, 0x0000003e420e7219ULL, 0x040fe400000006ffULL,
0x0000005942597219ULL, 0x040fe400000006ffULL, 0x0000004e423e7219ULL, 0x000fe200000006ffULL,
0x000000013f527824ULL, 0x000fe200078e0a5aULL, 0x00000021335f7812ULL, 0x000fc400078efcffULL,
0xfffffff044447812ULL, 0x000fe400078ec0ffULL, 0x0000005e424e7219ULL, 0x040fe400000006ffULL,
0x0000005242527219ULL, 0x000fe200000006ffULL, 0x000000015f617824ULL, 0x000fc800078e0266ULL,
0x0000000161547824ULL, 0x000fca00078e0a5aULL, 0x0000005442547219ULL, 0x000fe400000006ffULL,
0x000054104d487816ULL, 0x004fe40000000048ULL, 0x00000008334d7812ULL, 0x000fe400078efcffULL,
0x0000004857ff7212ULL, 0x000fc6000780c0ffULL, 0x000000014d517824ULL, 0x000fe200078e0266ULL,
0x000000323500720cULL, 0x000fc60000701470ULL, 0x00000001515b7824ULL, 0x000fe200078e0a4aULL,
0x000000323300720cULL, 0x000fc800007a1070ULL, 0x0000005b425b7219ULL, 0x000fe400000006ffULL,
0xff80000017177808ULL, 0x000fe40002800000ULL, 0x0000004859ff7212ULL, 0x080fe4000782c0ffULL,
0x000000485bff7212ULL, 0x080fe4000786c0ffULL, 0x000000485dff7212ULL, 0x000fe4000788c0ffULL,
0x0000541055407816ULL, 0x000fc80000000040ULL, 0x0000004057ff7212ULL, 0x080fe4000784c0ffULL,
0x000000405bff7212ULL, 0x080fe400078cc0ffULL, 0x000000405dff7212ULL, 0x000fe400078ac0ffULL,
0x000000323500720cULL, 0x080fe40001741470ULL, 0x000000325100720cULL, 0x080fe400037c1470ULL,
0x000000320d00720cULL, 0x000fc40002fa1470ULL, 0x000000323300720cULL, 0x080fe40001741070ULL,
0x000000324d00720cULL, 0x080fe400037c1070ULL, 0x000000320900720cULL, 0x000fe40002fa1070ULL,
0x000054103d3d7816ULL, 0x008fe40000000036ULL, 0xff8000001e1e7808ULL, 0x000fe40001000000ULL,
0xff8000001f1f7808ULL, 0x000fc40003000000ULL, 0x0000541043437816ULL, 0x000fe40000000038ULL,
0xff80000022227808ULL, 0x000fe40002800000ULL, 0x0000004059ff7212ULL, 0x000fe4000780c0ffULL,
0x0000003d34ff7212ULL, 0x040fe4000784c0ffULL, 0x0000004334ff7212ULL, 0x080fe400078cc0ffULL,
0x000000433eff7212ULL, 0x000fc400078ac0ffULL, 0x000000325300720cULL, 0x0c0fe40000f21470ULL,
0x000000325300720cULL, 0x080fe40000701470ULL, 0x000000325100720cULL, 0x080fe40001f61470ULL,
0x000000320d00720cULL, 0x080fe40002781470ULL, 0x000000323700720cULL, 0x0c0fe40001741470ULL,
0x000000323700720cULL, 0x000fc400037c1470ULL, 0x000000327300720cULL, 0x080fe40002fa1470ULL,
0x00000028335d7812ULL, 0x040fe400078efcffULL, 0x00000029335b7812ULL, 0x000fe400078efcffULL,
0x000000324f00720cULL, 0x0c0fe40000f21070ULL, 0x000000324f00720cULL, 0x080fe40000701070ULL,
0x000000324d00720cULL, 0x000fc40001f61070ULL, 0x000000320900720cULL, 0x080fe40002781070ULL,
0x000000323900720cULL, 0x0c0fe40001741070ULL, 0x000000323900720cULL, 0x080fe400037c1070ULL,
0x000000326500720cULL, 0x000fe40002fa1070ULL, 0x0000541045457816ULL, 0x000fe4000000003aULL,
0x000054104b4b7816ULL, 0x000fe2000000003cULL, 0x000000015d0a7824ULL, 0x100fe200078e0266ULL,
0xff80000025257808ULL, 0x000fe20000800000ULL, 0x000000015b4c7824ULL, 0x000fe200078e0266ULL,
0xff80000016167808ULL, 0x000fe20000000000ULL, 0x0000000132407824ULL, 0x000fe200078e0244ULL,
0xff80000026267808ULL, 0x000fc40001800000ULL, 0xff8000001b1b7808ULL, 0x000fe40002000000ULL,
0xff8000002c2c7808ULL, 0x000fe40001000000ULL, 0xff80000021217808ULL, 0x000fe40003000000ULL,
0xff80000023237808ULL, 0x000fe40002800000ULL, 0x0000003d0eff7212ULL, 0x080fe4000782c0ffULL,
0x0000003d3eff7212ULL, 0x000fc4000780c0ffULL, 0x0000003d4eff7212ULL, 0x000fe4000786c0ffULL,
0x000000430eff7212ULL, 0x080fe4000788c0ffULL, 0x000000434eff7212ULL, 0x000fe4000784c0ffULL,
0x0000004552ff7212ULL, 0x040fe400078cc0ffULL, 0x0000004b52ff7212ULL, 0x000fe200078ac0ffULL,
0x000000010a5c7824ULL, 0x100fe200078e0a5aULL, 0x000000327500720cULL, 0x0c0fe20000f21470ULL,
0x000000014c5a7824ULL, 0x000fe200078e0a5aULL, 0x000000327500720cULL, 0x080fe20002781470ULL,
0x0000000149587824ULL, 0x000fe200078e0a40ULL, 0x000000327300720cULL, 0x000fc40000701470ULL,
0x000000326b00720cULL, 0x0c0fe40001f61470ULL, 0x000000326b00720cULL, 0x080fe40001741470ULL,
0x000000323f00720cULL, 0x0c0fe400037c1470ULL, 0x000000323f00720cULL, 0x000fe40002fa1470ULL,
0x0000003133597812ULL, 0x040fe400078efcffULL, 0x0000003833577812ULL, 0x000fc400078efcffULL,
0x0000003933557812ULL, 0x000fe400078efcffULL, 0x000000326900720cULL, 0x0c0fe40000f21070ULL,
0x000000326900720cULL, 0x080fe40002781070ULL, 0x000000326500720cULL, 0x080fe40000701070ULL,
0x000000326300720cULL, 0x0c0fe40001f61070ULL, 0x000000326300720cULL, 0x000fc40001741070ULL,
0x000000323b00720cULL, 0x0c0fe400037c1070ULL, 0x000000323b00720cULL, 0x000fe40002fa1070ULL,
0x0000005c425c7219ULL, 0x040fe400000006ffULL, 0x0000005a425a7219ULL, 0x040fe400000006ffULL,
0x0000005842587219ULL, 0x000fe400000006ffULL, 0x000054100b0b7816ULL, 0x000fe20000000008ULL,
0x00000001594a7824ULL, 0x100fe200078e0266ULL, 0xff80000027277808ULL, 0x000fe20000800000ULL,
0x0000000157487824ULL, 0x100fe200078e0266ULL, 0xff80000020207808ULL, 0x000fe20002000000ULL,
0x0000000155447824ULL, 0x000fe200078e0266ULL, 0xff80000028287808ULL, 0x000fc40000000000ULL,
0xff80000031317808ULL, 0x000fe40001800000ULL, 0xff80000030307808ULL, 0x000fe40001000000ULL,
0xff8000002f2f7808ULL, 0x000fe40003000000ULL, 0xff80000015157808ULL, 0x000fe40002800000ULL,
0x0000004554ff7212ULL, 0x080fe4000782c0ffULL, 0x000000455cff7212ULL, 0x000fc4000788c0ffULL,
0x000000455aff7212ULL, 0x000fe4000780c0ffULL, 0x0000004b54ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004b5cff7212ULL, 0x080fe4000784c0ffULL, 0x0000004b5aff7212ULL, 0x000fe400078cc0ffULL,
0x0000000b58ff7212ULL, 0x000fe200078ac0ffULL, 0x000000014a567824ULL, 0x100fe200078e0a40ULL,
0x000000326100720cULL, 0x0c0fe20000f21470ULL, 0x0000000148507824ULL, 0x100fe200078e0a40ULL,
0x000000326100720cULL, 0x080fe20001f61470ULL, 0x0000000144407824ULL, 0x000fe200078e0a40ULL,
0x000000320a00720cULL, 0x000fc40002781470ULL, 0x000000320a00720cULL, 0x080fe40001741470ULL,
0x000000324c00720cULL, 0x0c0fe40000701470ULL, 0x000000324c00720cULL, 0x080fe400037c1470ULL,
0x000000324900720cULL, 0x080fe40002fa1470ULL, 0x000000325f00720cULL, 0x0c0fe40000f21070ULL,
0x000000325f00720cULL, 0x000fc40001f61070ULL, 0x000000325d00720cULL, 0x0c0fe40002781070ULL,
0x000000325d00720cULL, 0x080fe40001741070ULL, 0x000000325b00720cULL, 0x0c0fe40000701070ULL,
0x000000325b00720cULL, 0x080fe400037c1070ULL, 0x000000324100720cULL, 0x000fe40002fa1070ULL,
0x0000005642567219ULL, 0x000fc400000006ffULL, 0x0000005042507219ULL, 0x040fe400000006ffULL,
0x0000004042407219ULL, 0x000fe400000006ffULL, 0x000054100c0f7816ULL, 0x000fe4000000000fULL,
0xff80000029297808ULL, 0x000fe40000800000ULL, 0xff80000014147808ULL, 0x000fe40001800000ULL,
0xff8000002a2a7808ULL, 0x000fc40002000000ULL, 0xff80000019197808ULL, 0x000fe40001000000ULL,
0xff8000002e2e7808ULL, 0x000fe40000000000ULL, 0xff8000001a1a7808ULL, 0x000fe40003000000ULL,
0xff8000002d2d7808ULL, 0x000fe40002800000ULL, 0x0000000b56ff7212ULL, 0x080fe4000782c0ffULL,
0x0000000b50ff7212ULL, 0x000fc4000786c0ffULL, 0x0000000b40ff7212ULL, 0x000fe4000788c0ffULL,
0x0000000f58ff7212ULL, 0x080fe4000784c0ffULL, 0x0000000f56ff7212ULL, 0x080fe4000780c0ffULL,
0x0000000f50ff7212ULL, 0x080fe400078cc0ffULL, 0x0000000f40ff7212ULL, 0x000fe400078ac0ffULL,
0x000000324900720cULL, 0x000fc40001741470ULL, 0x000000324a00720cULL, 0x0c0fe40000f21470ULL,
0x000000324a00720cULL, 0x080fe40000701470ULL, 0x000000324800720cULL, 0x0c0fe40001f61470ULL,
0x000000324800720cULL, 0x080fe400037c1470ULL, 0x000000324400720cULL, 0x0c0fe40002781470ULL,
0x000000324400720cULL, 0x000fc40002fa1470ULL, 0x000000324100720cULL, 0x080fe40001741070ULL,
0x000000325900720cULL, 0x0c0fe40000f21070ULL, 0x000000325900720cULL, 0x080fe40000701070ULL,
0x000000325700720cULL, 0x0c0fe40001f61070ULL, 0x000000325700720cULL, 0x080fe400037c1070ULL,
0x000000325500720cULL, 0x000fc40002781070ULL, 0x000000325500720cULL, 0x000fe40002fa1070ULL,
0xff8000002b2b7808ULL, 0x000fe40000800000ULL, 0xff80000024247808ULL, 0x000fe40001800000ULL,
0xff80000018187808ULL, 0x000fe40002000000ULL, 0xff80000010107808ULL, 0x000fe40001000000ULL,
0xff80000011117808ULL, 0x000fc40000000000ULL, 0xff80000012127808ULL, 0x000fe40003000000ULL,
0xff80000013137808ULL, 0x000fc40002800000ULL, 0x000000170400720bULL, 0x004fe40003f1e000ULL,
0x0000001e0500720bULL, 0x000fe40003f3e000ULL, 0x0000000417047208ULL, 0x000fe40004000000ULL,
0x000000051e057208ULL, 0x000fe40004800000ULL, 0x000000250400720bULL, 0x000fc40003f1e000ULL,
0x000000160500720bULL, 0x000fe40003f3e000ULL, 0x0000000425097208ULL, 0x000fe40004000000ULL,
0x0000000516047208ULL, 0x000fe40004800000ULL, 0x000000260900720bULL, 0x000fe40003f1e000ULL,
0x0000001f0400720bULL, 0x000fe40003f3e000ULL, 0x0000000926087208ULL, 0x000fc40004000000ULL,
0x000000041f057208ULL, 0x000fe40004800000ULL, 0x0000001b0800720bULL, 0x000fe40003f1e000ULL,
0x000000220500720bULL, 0x000fe40003f3e000ULL, 0x000000081b097208ULL, 0x000fe40004000000ULL,
0x0000000522047208ULL, 0x000fe40004800000ULL, 0x0000002c0900720bULL, 0x000fc40003f1e000ULL,
0x000000210400720bULL, 0x000fe40003f3e000ULL, 0x000000092c087208ULL, 0x000fe40004000000ULL,
0x0000000421057208ULL, 0x000fe40004800000ULL, 0x000000270800720bULL, 0x000fe40003f1e000ULL,
0x000000200500720bULL, 0x000fe40003f3e000ULL, 0x0000000827097208ULL, 0x000fc40004000000ULL,
0x0000000520047208ULL, 0x000fe40004800000ULL, 0x000000280900720bULL, 0x000fe40003f1e000ULL,
0x000000230400720bULL, 0x000fe40003f3e000ULL, 0x0000000928087208ULL, 0x000fe40004000000ULL,
0x0000000423057208ULL, 0x000fe40004800000ULL, 0x000000310800720bULL, 0x000fc40003f1e000ULL,
0x000000300500720bULL, 0x000fe40003f3e000ULL, 0x0000000831087208ULL, 0x000fe40004000000ULL,
0x0000000530047208ULL, 0x000fe40004800000ULL, 0x0000002f0800720bULL, 0x000fe40003f1e000ULL,
0x000000150400720bULL, 0x000fe40003f3e000ULL, 0x000000082f087208ULL, 0x000fc40004000000ULL,
0x0000000415057208ULL, 0x000fe40004800000ULL, 0x000000290800720bULL, 0x000fe40003f1e000ULL,
0x000000140500720bULL, 0x000fe40003f3e000ULL, 0x0000000829097208ULL, 0x000fe40004000000ULL,
0x0000000514047208ULL, 0x000fe40004800000ULL, 0x0000002a0900720bULL, 0x000fc40003f1e000ULL,
0x000000190400720bULL, 0x000fe40003f3e000ULL, 0x000000092a097208ULL, 0x000fe40004000000ULL,
0x0000000419057208ULL, 0x000fe40004800000ULL, 0x0000002e0900720bULL, 0x000fe40003f1e000ULL,
0x0000001a0500720bULL, 0x000fe40003f3e000ULL, 0x000000092e047208ULL, 0x000fc40004000000ULL,
0x000000051a057208ULL, 0x000fe40004800000ULL, 0x0000002d0400720bULL, 0x000fe40003f1e000ULL,
0x000000100500720bULL, 0x000fe40003f3e000ULL, 0x000000042d047208ULL, 0x000fe40004000000ULL,
0x0000000510087208ULL, 0x000fe40004800000ULL, 0x0000002b0400720bULL, 0x000fc40003f1e000ULL,
0x000000110800720bULL, 0x000fe40003f3e000ULL, 0x000000042b057208ULL, 0x000fe40004000000ULL,
0x0000000811097208ULL, 0x000fe40004800000ULL, 0x000000240500720bULL, 0x000fe40003f1e000ULL,
0x000000120900720bULL, 0x000fe40003f3e000ULL, 0x0000000524057208ULL, 0x000fc40004000000ULL,
0x0000000912047208ULL, 0x000fe40004800000ULL, 0x000000180500720bULL, 0x000fe40003f1e000ULL,
0x000000130400720bULL, 0x000fe40003f3e000ULL, 0x00000005180a7208ULL, 0x000fe40004000000ULL,
0x00000004130c7208ULL, 0x000fe20004800000ULL, 0x000017327f007947ULL, 0x000fec000b800000ULL,
0x0c401f000a047f89ULL, 0x0004e400000e0000ULL, 0x000000040a00720bULL, 0x008fc80003f1e000ULL,
0x0000000a040d7208ULL, 0x000fe20004000000ULL, 0x000017627f007947ULL, 0x000fea000b800000ULL,
0x0c401f000c047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000e6800000e0000ULL,
0x0c401f0007327f89ULL, 0x000ea200000e0000ULL, 0x000000040c00720bULL, 0x008fc40003f1e000ULL,
0x000000050600720bULL, 0x002fe40003f3e000ULL, 0x0000000c04087208ULL, 0x000fe40004000000ULL,
0x0000000605097208ULL, 0x000fe20004800000ULL, 0x0c201f000d047f89ULL, 0x000e6200000e0000ULL,
0x000000320700720bULL, 0x004fc60003f1e000ULL, 0x0c201f0008057f89ULL, 0x000ea200000e0000ULL,
0x0000000732327208ULL, 0x000fc60004000000ULL, 0x0c201f00090a7f89ULL, 0x000ee800000e0000ULL,
0x0c201f0032337f89ULL, 0x0002e400000e0000ULL, 0x000000040d00720bULL, 0x002fe40003f1e000ULL,
0x000000050800720bULL, 0x004fe40003f3e000ULL, 0x0000000d04047208ULL, 0x000fc40004000000ULL,
0x0000000a0900720bULL, 0x008fe40003f5e000ULL, 0x0000000805057208ULL, 0x000fe40004800000ULL,
0x000000090a067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04347820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000302ff7812ULL, 0x000fe4000780c0ffULL,
0x3fb8aa3b280d7823ULL, 0x100fe20000010834ULL, 0x000000333200720bULL, 0x004fe20003f3e000ULL,
0x3fb8aa3b29287823ULL, 0x000fc40000010834ULL, 0x3fb8aa3b05297820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010834ULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b22227823ULL, 0x100fe40000010829ULL,
0x3fb8aa3b1b077823ULL, 0x100fe40000010834ULL, 0x3fb8aa3b16167823ULL, 0x000fe20000010829ULL,
0x00000026000a7308ULL, 0x0023e20000000800ULL, 0x3fb8aa3b17177823ULL, 0x000fc40000010834ULL,
0x3fb8aa3b25257823ULL, 0x100fe40000010834ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe40000010829ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010829ULL, 0x00000007000b7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b20207823ULL, 0x000fe40000010829ULL, 0x3fb8aa3b27277823ULL, 0x100fe40000010834ULL,
0x3fb8aa3b31317823ULL, 0x000fc40000010834ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010829ULL,
0x0000001700087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b30307823ULL, 0x100fe40000010829ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe40000010834ULL, 0x3fb8aa3b2b267823ULL, 0x102fe40000010834ULL,
0x3fb8aa3b142b7823ULL, 0x000fe20000010829ULL, 0x0000002500097308ULL, 0x0002e20000000800ULL,
0x0000000a0b0a723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b2f1b7823ULL, 0x000fc40000010834ULL,
0x3fb8aa3b1a1a7823ULL, 0x000fe40000010829ULL, 0x3fb8aa3b24247823ULL, 0x100fe40000010834ULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a257823ULL, 0x102fe40000010834ULL,
0x3fb8aa3b2e2a7823ULL, 0x100fe40000010834ULL, 0x3fb8aa3b2d077823ULL, 0x100fe40000010834ULL,
0x3fb8aa3b18187823ULL, 0x000fe20000010834ULL, 0x0000002200227308ULL, 0x000e620000000800ULL,
0x000000080908723eULL, 0x008fce00000010ffULL, 0x0000001e000f7308ULL, 0x0005f00000000800ULL,
0x0000001600167308ULL, 0x000ee20000000800ULL, 0x00000004ff1e7e24ULL, 0x004fe2000f8e00ffULL,
0x0000001f220b723eULL, 0x002fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x3f8000001e1e783eULL, 0x000fc400000010ffULL, 0x00000031000e7308ULL, 0x000e660000000800ULL,
0x000000ffff1f7224ULL, 0x100fe400078e001eULL, 0x000000ffff2e7224ULL, 0x100fe400078e001eULL,
0x000000ffff2f7224ULL, 0x100fe200078e001eULL, 0x0000000f1609723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b150f7823ULL, 0x000fe20000010829ULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x000000ffff347224ULL, 0x000fc800078e001eULL, 0x0000001e0814723cULL, 0x000b6200000418ffULL,
0x0000000d0e0e723eULL, 0x002fe400000010ffULL, 0x0000002000207308ULL, 0x000e680000000800ULL,
0x3fb8aa3b191f7823ULL, 0x020fc80000010829ULL, 0x0000002c000c7308ULL, 0x0005f00000000800ULL,
0x0000002700277308ULL, 0x000ee20000000800ULL, 0x00000021200d723eULL, 0x002fe200000010ffULL,
0x000000ffff207224ULL, 0x000fe200078e001eULL, 0x00000002ff2c7819ULL, 0x004fe20000011602ULL,
0x000000ffff217224ULL, 0x000fc800078e001eULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x000000082c317824ULL, 0x040fe400078e00ffULL, 0x000000082c357824ULL, 0x000fca00078e00ffULL,
0x0000003000307308ULL, 0x000e620000000800ULL, 0x0000000c270c723eULL, 0x008fe200000010ffULL,
0x000000082c277824ULL, 0x000fcc00078e00ffULL, 0x0000000f00227308ULL, 0x0003f00000000800ULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x00000023300f723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b12237823ULL, 0x000fcc0000010829ULL, 0x000000200c14723cULL, 0x000b620000041814ULL,
0x0000002800287308ULL, 0x000e6c0000000800ULL, 0x3fb8aa3b10207823ULL, 0x120fe20000010829ULL,
0x000000012c107810ULL, 0x000fe20007ffe0ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b11217823ULL, 0x000fc40000010829ULL, 0x3fb8aa3b13297823ULL, 0x000fe20000010829ULL,
0xfffffff827277812ULL, 0x000fc800078ee210ULL, 0x0000002a002a7308ULL, 0x000ea20000000800ULL,
0x0000001b2810723eULL, 0x002fe400000010ffULL, 0xffffffff2c287810ULL, 0x000fca0007ffe0ffULL,
0x0000002b002b7308ULL, 0x000e700000000800ULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x000000252a12723eULL, 0x004fe200000010ffULL, 0x000000082c257824ULL, 0x040fe200078e00ffULL,
0x000000082c2a7810ULL, 0x000fca0007ffe0ffULL, 0x0000001a001a7308ULL, 0x000ea20000000800ULL,
0x000000222b11723eULL, 0x002fe200000010ffULL, 0x000000082c227824ULL, 0x040fe400078e00ffULL,
0x000000082c2b7824ULL, 0x000fe400078e00ffULL, 0x000000082a377824ULL, 0x000fe400078e00ffULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x0000001f1a13723eULL, 0x004fce00000010ffULL,
0x0000001800197308ULL, 0x0002a20000000800ULL, 0x000000042c1f7810ULL, 0x040fe40007ffe0ffULL,
0x000000032c1a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8222d7812ULL, 0x000fe200078ee21fULL,
0x0000002e1014723cULL, 0x000b620000041814ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee21aULL,
0x0000000700077308ULL, 0x000fe20000000800ULL, 0x000000022c187810ULL, 0x042fe20007ffe0ffULL,
0x000000082c1f7824ULL, 0x040fe200078e00ffULL, 0x000000062c1a7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff825257812ULL, 0x000fe200078ee218ULL, 0x000000082c2f7824ULL, 0x060fe200078e00ffULL,
0x000000052c187810ULL, 0x000fe20007ffe0ffULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0xfffffff81f1f7812ULL, 0x000fce00078ee22cULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000ef00000000800ULL, 0x00000023001b7308ULL, 0x0003f00000000800ULL,
0x0000002900227308ULL, 0x000ee20000000800ULL, 0xfffffff82f237812ULL, 0x002fc400078ee218ULL,
0xfffffff8312f7812ULL, 0x000fe400078ee21aULL, 0xfffffff835317812ULL, 0x000fe200078ee228ULL,
0x000000ffff357224ULL, 0x000fe200078e001eULL, 0x00000024191a723eULL, 0x004fe400000010ffULL,
0x000000072618723eULL, 0x000fe400000010ffULL, 0x000000202119723eULL, 0x008fe400000010ffULL,
0x0001100000247811ULL, 0x000fc400078e58ffULL, 0x0000000c1d207812ULL, 0x000fe400078ec0ffULL,
0x0000001b221b723eULL, 0x000fe200000010ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0224ULL,
0xfffffff837297812ULL, 0x000fe200078ee22aULL, 0x0000001027277824ULL, 0x100fe200078e0224ULL,
0x0000003233077208ULL, 0x000fe20004800000ULL, 0x0000001025257824ULL, 0x100fe400078e0224ULL,
0x000000341814723cULL, 0x000f620000041814ULL, 0x000000102b2b7824ULL, 0x000fc400078e0224ULL,
0x000000102d2d7824ULL, 0x000fe400078e0224ULL, 0x000000011f1f7824ULL, 0x000fe400078e0220ULL,
0x0000001023237824ULL, 0x100fe400078e0224ULL, 0x0000000120277824ULL, 0x040fe200078e0227ULL,
0x000000081f007388ULL, 0x0003e20000000800ULL, 0x000000102f2f7824ULL, 0x100fe400078e0224ULL,
0x0000000120257824ULL, 0x000fe200078e0225ULL, 0x0000000a27007388ULL, 0x0003e20000000800ULL,
0x0000001031317824ULL, 0x000fc400078e0224ULL, 0x00000001202b7824ULL, 0x040fe200078e022bULL,
0x0000000c25007388ULL, 0x0003e20000000800ULL, 0x0000001029297824ULL, 0x000fe400078e0224ULL,
0x00000001202d7824ULL, 0x040fe200078e022dULL, 0x0000000e2b007388ULL, 0x0003e20000000800ULL,
0x0000000120237824ULL, 0x040fe400078e0223ULL, 0x00000001202f7824ULL, 0x040fe200078e022fULL,
0x000000102d007388ULL, 0x0003e20000000800ULL, 0x0000000120317824ULL, 0x000fc400078e0231ULL,
0x0000000120207824ULL, 0x000fe200078e0229ULL, 0x0000001223007388ULL, 0x0003e20000000800ULL,
0x000000ffff157224ULL, 0x020fc600078e0016ULL, 0x000000182f007388ULL, 0x0003e80000000800ULL,
0x0000001a31007388ULL, 0x0003e80000000800ULL, 0x0000000920007388ULL, 0x0003e80000000800ULL,
0x0004000b27007388ULL, 0x0003e80000000800ULL, 0x0004000d25007388ULL, 0x0003e80000000800ULL,
0x0004000f2b007388ULL, 0x0003e80000000800ULL, 0x000400112d007388ULL, 0x0003e80000000800ULL,
0x0004001323007388ULL, 0x0003e80000000800ULL, 0x000400192f007388ULL, 0x0003e80000000800ULL,
0x0004001b31007388ULL, 0x0003e80000000800ULL, 0x017000041c008388ULL, 0x0003e80000000c00ULL,
0x017200141c008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000007cff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008007cff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010007cff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000168687810ULL, 0x000fe20007ffe0ffULL, 0x000018007cff7f8cULL, 0x0003e4000c80043fULL,
0x000000ffff047224ULL, 0x002fe200078e006dULL, 0x000000716800720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff9a2000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff147807ULL, 0x002fe20004000000ULL,
0xffffffffff3e7424ULL, 0x000fe200078e00ffULL, 0x00018cf000157802ULL, 0x000fc40000000f00ULL,
0x00000f3000007944ULL, 0x018fea0003c00000ULL, 0xfffe9b7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x000fe20005000000ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x00018d4000157802ULL, 0x000fc40000000f00ULL, 0x00000ee000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff127224ULL, 0x000fe200078e003cULL, 0xfffe9ba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e0013ULL, 0x00018db0003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x00000e2000007944ULL, 0x018fea0003c00000ULL, 0xfffe9c6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e0013ULL, 0x00018e10003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x00000dc000007944ULL, 0x018fea0003c00000ULL, 0xfffe9d6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e0003ULL, 0x00018e80003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff147224ULL, 0x000fe400078e0004ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000d5000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e003cULL, 0xfffea15000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e0003ULL, 0x00018ef0003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x00000ce000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e003cULL,
0xfffea11000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x004fe20004000000ULL,
0xffffffffff3e7424ULL, 0x000fe200078e00ffULL, 0x00018f5000157802ULL, 0x000fc40000000f00ULL,
0x00000cd000007944ULL, 0x008fea0003c00000ULL, 0xfffecfc000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x000fe20005000000ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x00018fa000157802ULL, 0x000fc40000000f00ULL, 0x00000c8000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e003cULL, 0xfffecff000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e003aULL, 0x00019010003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x00000bc000007944ULL, 0x008fea0003c00000ULL, 0xfffed0c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e003aULL, 0x00019070003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x00000b6000007944ULL, 0x008fea0003c00000ULL, 0xfffed1c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e0010ULL, 0x000190e0003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff147224ULL, 0x000fe400078e0017ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x00000af000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e003cULL, 0xfffed5d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e0010ULL, 0x00019150003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x00000a8000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e003cULL,
0xfffed59000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x008fe20004000000ULL,
0xffffffffff3e7424ULL, 0x000fe200078e00ffULL, 0x000191b000157802ULL, 0x000fc40000000f00ULL,
0x00000a7000007944ULL, 0x014fea0003c00000ULL, 0xffff028000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x000fe20005000000ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x0001920000157802ULL, 0x000fc40000000f00ULL, 0x00000a2000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e003cULL, 0xffff02c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e000eULL, 0x00019270003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000096000007944ULL, 0x014fea0003c00000ULL, 0xffff038000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e000eULL, 0x000192d0003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000090000007944ULL, 0x014fea0003c00000ULL, 0xffff048000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e000eULL, 0x00019340003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff147224ULL, 0x000fe400078e0013ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000089000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e003cULL, 0xffff088000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e000eULL, 0x000193b0003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000082000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e003cULL,
0xffff084000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x004fe20004000000ULL,
0xffffffffff3e7424ULL, 0x000fe200078e00ffULL, 0x0001941000157802ULL, 0x000fc40000000f00ULL,
0x0000081000007944ULL, 0x018fea0003c00000ULL, 0xffff359000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x000fe20005000000ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x0001946000157802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e003cULL, 0xffff35d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e0012ULL, 0x000194d0003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x0000070000007944ULL, 0x018fea0003c00000ULL, 0xffff369000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e0012ULL, 0x00019530003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x018fea0003c00000ULL, 0xffff379000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e0009ULL, 0x000195a0003e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff147224ULL, 0x000fe400078e000eULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e003cULL, 0xffff3bd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff157224ULL, 0x000fe200078e0009ULL, 0x00019610003e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e003cULL,
0xffff3b9000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0b7424ULL, 0x000fe200078e00ffULL,
0x0001968000087802ULL, 0x000fe20000000f00ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0033ULL, 0xffffe87000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0a7224ULL, 0x006fe200078e000cULL, 0x0001970000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x010fea0003c00000ULL,
0x000000330c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0006ULL,
0x0001978000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000c330c7208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x000000330600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0007ULL,
0x0001980000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000633067208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000330700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e000dULL,
0x0001988000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000733327208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000330d00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e000cULL,
0x0001990000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000d33047208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x000000330c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0006ULL,
0x0001998000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000c33057208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000330600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0032ULL,
0x00019a0000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000633067208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe66000007947ULL, 0x000fea000383ffffULL, 0x018000000f007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000f00008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff0fff7812ULL, 0x040fe4000780c0ffULL,
0x800000000f027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000f00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe647002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000000e00007348ULL, 0x000fe80003800000ULL, 0x0c00000b0a337389ULL, 0x0002a200000e0033ULL,
0xfffe643008007950ULL, 0x000fea0003c3ffffULL, 0x0000003c00007348ULL, 0x000fe80003800000ULL,
0x00000014153c7389ULL, 0x0002a400000e003fULL, 0x000000ffff147224ULL, 0x002fc400078e003eULL,
0x00000000ff157424ULL, 0x000fc800078e00ffULL, 0xfffe63e014007950ULL, 0x000fea0003c3ffffULL,
0x000000011400780cULL, 0x000fe20003f45070ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0x0000003e00007348ULL, 0x000fe80003800000ULL, 0x00000000ff157424ULL, 0x000fce00078e00ffULL,
0x00000000003c7806ULL, 0x000fc800050e0100ULL, 0x0000003e3c3c7212ULL, 0x000fe200078ec0ffULL,
0xfffe637014007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x00000000000002d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000cd0ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d90ULL, 0x00000000000007d0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001560ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001570ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001600ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001604ULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000019d80ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001b580ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001b5d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001b950ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001600ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000019f80ULL, 0x0000000000019f80ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001b580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001b950ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_80_cubin_len = 113200;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
