/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000018390ULL, 0x0000000000017f10ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x00000000000164b0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000016620ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000016660ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x00000000000166a0ULL,
0x0000000000000160ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000016800ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000164b000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x0057e80400288080ULL, 0x0000000000000000ULL, 0x000000dcffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x9908288080980828ULL, 0x2880809b08288080ULL, 0x809d082880809c08ULL, 0x082880809f082880ULL,
0x8080a208288080a0ULL, 0xa508288080a40828ULL, 0x288080a708288080ULL, 0x80a908288080a808ULL,
0x08288080aa082880ULL, 0x8080ad08288080abULL, 0xb008288080ae0828ULL, 0x288080b108288080ULL,
0x80ba08288080b208ULL, 0x08288080c0082880ULL, 0x8080eb08288080eaULL, 0xfd08288080fc0828ULL,
0x2880818008288080ULL, 0x818b082880818a08ULL, 0x0828808193082880ULL, 0x8082801628808086ULL,
0x0000000000031028ULL, 0x2880808692000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x000164b000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x000000ecffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8c08288080840828ULL, 0x2880808d08288080ULL,
0x8090082880808e08ULL, 0x0828808091082880ULL, 0x8080980828808092ULL, 0x9a08288080990828ULL,
0x2880809b08288080ULL, 0x809f082880809e08ULL, 0x08288080a1082880ULL, 0x8080a308288080a2ULL,
0xa508288080a40828ULL, 0x288080a708288080ULL, 0x80aa08288080a808ULL, 0x08288080ab082880ULL,
0x8080b208288080b1ULL, 0xc008288080ba0828ULL, 0x288080ea08288080ULL, 0x80fc08288080eb08ULL,
0x08288080fd082880ULL, 0x80818a0828808180ULL, 0x93082880818b0828ULL, 0x2880808808288081ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808088ULL, 0x0000001cffffffffULL,
0x0000018000000000ULL, 0x0001662000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x000000f4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8808288080840828ULL, 0x2880808c08288080ULL,
0x808e082880808d08ULL, 0x0828808090082880ULL, 0x8080920828808091ULL, 0x9908288080980828ULL,
0x2880809a08288080ULL, 0x809e082880809b08ULL, 0x082880809f082880ULL, 0x8080a208288080a1ULL,
0xa508288080a30828ULL, 0x288080a708288080ULL, 0x80a908288080a808ULL, 0x08288080aa082880ULL,
0x8080b108288080abULL, 0xba08288080b20828ULL, 0x288080c008288080ULL, 0x80eb08288080ea08ULL,
0x08288080fc082880ULL, 0x80818008288080fdULL, 0x8b082880818a0828ULL, 0x2880819308288081ULL,
0x828016288080a408ULL, 0x0000000003102880ULL, 0x8080a49200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x000002a000000000ULL, 0x0001666000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x000000f4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8808288080840828ULL,
0x2880808c08288080ULL, 0x808e082880808d08ULL, 0x0828808090082880ULL, 0x8080920828808091ULL,
0x9908288080980828ULL, 0x2880809a08288080ULL, 0x809e082880809b08ULL, 0x082880809f082880ULL,
0x8080a208288080a1ULL, 0xa408288080a30828ULL, 0x288080a508288080ULL, 0x80a808288080a708ULL,
0x08288080aa082880ULL, 0x8080b108288080abULL, 0xba08288080b20828ULL, 0x288080c008288080ULL,
0x80eb08288080ea08ULL, 0x08288080fc082880ULL, 0x80818008288080fdULL, 0x8b082880818a0828ULL,
0x2880819308288081ULL, 0x828016288080a908ULL, 0x0000000003102880ULL, 0x8080a99200000000ULL,
0x0000000000220028ULL, 0x0000002cffffffffULL, 0x000003c800000000ULL, 0x000166a000000000ULL,
0x0000016000000000ULL, 0x0000180400000000ULL, 0x80a4288080a90900ULL, 0x0000000000002880ULL,
0x0000001200082f04ULL, 0x00081204000000f3ULL, 0x000000000000000dULL, 0x0000000d00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005001600000000eULL, 0x000c170400501903ULL, 0x0048000700000000ULL, 0x000c17040021f000ULL,
0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL,
0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x00014e2000014be0ULL,
0x00014fa000014e30ULL, 0x00014fc000014fb0ULL, 0xffffffff01602904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001dffffffffULL, 0x0500001d0500001dULL,
0xffffffff0500001dULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01602804ffffffffULL, 0x0000012000000100ULL,
0x00001740000016b0ULL, 0x0000183000001800ULL, 0x00001c3000001c00ULL, 0x00001cf000001c90ULL,
0x000046d000004640ULL, 0x000048c0000047a0ULL, 0x00004c0000004be0ULL, 0x00004cc000004c60ULL,
0x00007260000071d0ULL, 0x0000745000007330ULL, 0x0000778000007760ULL, 0x00007840000077e0ULL,
0x00009e1000009d80ULL, 0x0000a00000009ee0ULL, 0x0000a3400000a320ULL, 0x0000a4000000a3a0ULL,
0x0000c5e00000c5d0ULL, 0x0000ecb00000ebd0ULL, 0x0000f4c00000f490ULL, 0x0001487000014840ULL,
0x0001489000014880ULL, 0x000148d0000148b0ULL, 0x00014900000148f0ULL, 0x00014ff000014f90ULL,
0x0001501000015000ULL, 0x0001577000015720ULL, 0x00015870000157f0ULL, 0x00015950000158e0ULL,
0x000159f0000159a0ULL, 0x00015ad000015a60ULL, 0x00015ba000015b30ULL, 0x00015c4000015bf0ULL,
0x00015d2000015cb0ULL, 0x00015df000015d80ULL, 0x00015e9000015e40ULL, 0x00015f6000015ef0ULL,
0x0001603000015fc0ULL, 0x000160f000016090ULL, 0x0001619000016140ULL, 0x00016230000161e0ULL,
0x000162d000016280ULL, 0x000163c000016340ULL, 0x0001648000016420ULL, 0x0000021004c03904ULL,
0x0000f600000000ffULL, 0x000002b0003f0100ULL, 0x0000f60800000003ULL, 0x000002f0003f0120ULL,
0x0000f68800000003ULL, 0x00000370003f0120ULL, 0x0000f6a800000003ULL, 0x000003b0003f0120ULL,
0x0000f6c800000003ULL, 0x00000460003f0120ULL, 0x0000f600000000ffULL, 0x00000720003f0107ULL,
0x0000f68c0000003dULL, 0x00000a00003f0102ULL, 0x0000f6880000003dULL, 0x00000b40003f0101ULL,
0x00000000000000ffULL, 0x00000bd000040107ULL, 0x00000000000000ffULL, 0x00000c3000040101ULL,
0x0000002000000038ULL, 0x00000d40003f0101ULL, 0x0000000400000092ULL, 0x00000da0003f0105ULL,
0x0000002400000038ULL, 0x00000e20003f0105ULL, 0x0000002400000038ULL, 0x00001380003f0105ULL,
0x000000000000005cULL, 0x00001450003f0107ULL, 0x000000000000005cULL, 0x00001460003f0101ULL,
0x000000040000002eULL, 0x000014d0003f0105ULL, 0x0000f60800000040ULL, 0x000014f0003f0101ULL,
0x0000f60c00000040ULL, 0x000015b0003f0105ULL, 0x0000f60c00000026ULL, 0x00001af0003f0105ULL,
0x000000040000002eULL, 0x00001b70003f0105ULL, 0x000000040000002eULL, 0x00003cd0003f0105ULL,
0x0000002000000038ULL, 0x00003d50003f0101ULL, 0x0000f68800000053ULL, 0x00003da0003f0101ULL,
0x0000000400000092ULL, 0x00003df0003f0105ULL, 0x0000002400000038ULL, 0x00003e70003f0105ULL,
0x0000002400000038ULL, 0x00004390003f0105ULL, 0x0000000000000056ULL, 0x00004410003f0107ULL,
0x0000000000000056ULL, 0x00004420003f0101ULL, 0x000000040000005bULL, 0x00004490003f0105ULL,
0x0000f62800000040ULL, 0x000044b0003f0101ULL, 0x0000f62c00000040ULL, 0x00004590003f0105ULL,
0x0000f62c00000024ULL, 0x00004ab0003f0105ULL, 0x0000f6ac00000024ULL, 0x00004b30003f0105ULL,
0x0000f6ac00000024ULL, 0x00006ae0003f0105ULL, 0x0000002000000038ULL, 0x00006b50003f0101ULL,
0x0000f69000000053ULL, 0x00006b90003f0101ULL, 0x0000000400000092ULL, 0x00006be0003f0105ULL,
0x0000002400000038ULL, 0x00006c60003f0105ULL, 0x0000002400000038ULL, 0x00006f70003f0105ULL,
0x000000000000005bULL, 0x00006ff0003f0107ULL, 0x000000000000005bULL, 0x00007000003f0101ULL,
0x0000000400000056ULL, 0x00007070003f0105ULL, 0x0000f64800000040ULL, 0x00007090003f0101ULL,
0x0000f64c00000040ULL, 0x00007120003f0105ULL, 0x0000f64c00000040ULL, 0x00007630003f0105ULL,
0x0000f6ac00000025ULL, 0x000076b0003f0105ULL, 0x0000f6ac00000025ULL, 0x00009650003f0105ULL,
0x0000002000000038ULL, 0x000096c0003f0101ULL, 0x0000f69800000053ULL, 0x00009710003f0101ULL,
0x0000000400000092ULL, 0x00009760003f0105ULL, 0x0000002400000038ULL, 0x000097e0003f0105ULL,
0x0000002400000038ULL, 0x00009b20003f0105ULL, 0x0000000000000056ULL, 0x00009ba0003f0107ULL,
0x0000000000000060ULL, 0x00009bb0003f0101ULL, 0x000000040000005bULL, 0x00009c20003f0105ULL,
0x0000f66800000040ULL, 0x00009c40003f0101ULL, 0x0000f66c00000040ULL, 0x00009cd0003f0105ULL,
0x0000f66c00000040ULL, 0x0000a1f0003f0105ULL, 0x0000f6ac00000024ULL, 0x0000a270003f0105ULL,
0x0000f6ac00000024ULL, 0x0000c180003f0105ULL, 0x0000002000000038ULL, 0x0000c1e0003f0101ULL,
0x0000f6a000000053ULL, 0x000101c0003f0101ULL, 0x0000f600000000ffULL, 0x00010cb0003f0101ULL,
0x0000f604000000ffULL, 0x00010d50003f0105ULL, 0x0000f604000000ffULL, 0x00010f60003f0105ULL,
0x0000f600000000ffULL, 0x00010f70003f0101ULL, 0x0000f604000000ffULL, 0x00011000003f0105ULL,
0x0000f604000000ffULL, 0x00013ca0003f0105ULL, 0x000000000000003aULL, 0x00013ce0003f0101ULL,
0x000000040000003aULL, 0x00014140003f0105ULL, 0x000000040000003aULL, 0x00015580003f0105ULL,
0x0000000000000038ULL, 0x000155e0003f0101ULL, 0x0000000800000038ULL, 0x00015640003f0101ULL,
0x0000001000000038ULL, 0x000156b0003f0101ULL, 0x0000001800000038ULL, 0x00053803003f0101ULL,
0x0000fec000141c04ULL, 0x0001106000010110ULL, 0x000156f000011100ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x00000000000004dcULL, 0x0000001200000002ULL, 0x00000000000003b4ULL,
0x0000001200000002ULL, 0x000000000000028cULL, 0x0000001200000002ULL, 0x000000000000016cULL,
0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL, 0x00000000000004b4ULL,
0x0000001200000002ULL, 0x000000000000038cULL, 0x0000001200000002ULL, 0x0000000000000267ULL,
0x0000001200000002ULL, 0x0000000000000143ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff097624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000f7919ULL, 0x000ea20000002300ULL,
0x0000001200067300ULL, 0x000ee200000e0000ULL, 0x0000000809097824ULL, 0x000fe400078e00ffULL,
0x0000000000007919ULL, 0x000ea20000002200ULL, 0x00000100ff0d7424ULL, 0x000fc600078e00ffULL,
0x0000000000417919ULL, 0x000f220000000000ULL, 0x0000001200127309ULL, 0x000f660000000000ULL,
0x0000000000367919ULL, 0x000ee80000002600ULL, 0x00000000003f7919ULL, 0x000f620000002700ULL,
0x00000005ff027819ULL, 0x002fc60000011603ULL, 0x0000000000077919ULL, 0x000e680000000000ULL,
0x00001fff02027589ULL, 0x000fe200000e0000ULL, 0x000000010f007824ULL, 0x004fc600078e0200ULL,
0x00001fff0f0f7589ULL, 0x000ea200000e0000ULL, 0x0000008000037824ULL, 0x000fe200078e0203ULL,
0x00000004ff117819ULL, 0x010fe20000011641ULL, 0x00000010410e7824ULL, 0x000fe400078e00ffULL,
0x0000000836007824ULL, 0x008fe200078e00ffULL, 0x000000ff0300720cULL, 0x040fe40003f45270ULL,
0x0000007f0300780cULL, 0x000fe20003f84070ULL, 0x0000003f09007224ULL, 0x020fe200078e0200ULL,
0x0000000f0300780cULL, 0x000fc40003f64070ULL, 0x000000030300780cULL, 0x000fe40003f24070ULL,
0x000000070600720cULL, 0x002fca0003f02070ULL, 0x3fffff80ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff05a424ULL, 0x000fe400078e00ffULL, 0x000000040f087824ULL, 0x004fe400078e0202ULL,
0xff317217ff0cc424ULL, 0x000fe200078e00ffULL, 0x00f60004ff00a388ULL, 0x0003e20000000a00ULL,
0x00000002080a7824ULL, 0x000fe200078e00ffULL, 0x000000010300780cULL, 0x000fe20003f44070ULL,
0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL, 0x00f4000c0300c388ULL, 0x000fe20000004800ULL,
0x000000010a137824ULL, 0x040fe200078e0211ULL, 0x000000080a0b7817ULL, 0x000fe20007800000ULL,
0x7fffffc0ff07b424ULL, 0x000fc400078e00ffULL, 0x3fffff60ff089424ULL, 0x000fe400078e00ffULL,
0x0000000100047824ULL, 0x002fe200078e0213ULL, 0x00f608060300b388ULL, 0x0003e20000008a00ULL,
0x7fffff60ff099424ULL, 0x000fe400078e00ffULL, 0x000000010b007824ULL, 0x000fe400078e0a0aULL,
0x00005c0004047625ULL, 0x000fe200078e000dULL, 0x00f6880803009388ULL, 0x0005e40000008a00ULL,
0x000000001100720cULL, 0x000fe20003f66070ULL, 0x3fffff80ff0a9424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL, 0x0000000713067812ULL, 0x002fe200078ec0ffULL,
0x3fffffc0ff0ca424ULL, 0x000fe200078e00ffULL, 0x000000f00e077812ULL, 0x000fe200078ec0ffULL,
0x7fffffc0ff0da424ULL, 0x000fe200078e00ffULL, 0x00f6a80a03009388ULL, 0x0003e20000008a00ULL,
0x0000000f06107812ULL, 0x000fe200078e7841ULL, 0x000000ffff007224ULL, 0x000fe200078e0a12ULL,
0x0000000704067210ULL, 0x000fe20007f9e0ffULL, 0x00f6c80c0300a388ULL, 0x0003e20000008a00ULL,
0x00000004ff047424ULL, 0x000fc400078e00ffULL, 0x0000001013107824ULL, 0x000fe400078e0210ULL,
0x000000ffff077224ULL, 0x000fe400020e0605ULL, 0x0000001010097824ULL, 0x004fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000060003f047625ULL, 0x000fca00078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604037981ULL, 0x002ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x00000004ff347e24ULL, 0x002fe2000f8e00ffULL,
0x000000ff03357810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff357819ULL, 0x000fce0000011635ULL,
0x0000fbd000008947ULL, 0x000fea0003800000ULL, 0x00000010023e7824ULL, 0x000fe200078e00ffULL,
0x0000000134047810ULL, 0x000fe20007ffe0ffULL, 0x000000023f3f7824ULL, 0x000fe200078e00ffULL,
0x00000003ff0c7819ULL, 0x000fe20000011641ULL, 0x00000008023d7824ULL, 0x000fe200078e00ffULL,
0x000000103e3e7812ULL, 0x000fe200078ec0ffULL, 0x00000003ff167424ULL, 0x000fe200078e00ffULL,
0x0000580036007a10ULL, 0x000fe40007ffe0ffULL, 0x000000350400720cULL, 0x000fe20003f06070ULL,
0x000000013e047824ULL, 0x000fe200078e020cULL, 0x00000001ff487819ULL, 0x000fe20000011602ULL,
0x000058003f3f7a24ULL, 0x000fe200078e0200ULL, 0x000000040c107810ULL, 0x000fe20007ffe0ffULL,
0x0000000804077824ULL, 0x040fe200078e00ffULL, 0x0000004104007212ULL, 0x000fe200078e3cffULL,
0x0000000834057824ULL, 0x000fe200078e0248ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0xfffffff807077812ULL, 0x000fe200078ee200ULL, 0x000000013e087824ULL, 0x000fe200078e0210ULL,
0x0000000c0c147810ULL, 0x040fe20007ffe0ffULL, 0x0000002005007824ULL, 0x000fe200078e00ffULL,
0x000000080c127810ULL, 0x000fe20007ffe0ffULL, 0x0000000808097824ULL, 0x040fe200078e00ffULL,
0x0000004108067212ULL, 0x080fe200078e3cffULL, 0x000000013e0b7824ULL, 0x040fe200078e0214ULL,
0x0000000003057217ULL, 0x000fe20007800000ULL, 0x000000013e0a7824ULL, 0x000fe200078e0212ULL,
0xfffffff809097812ULL, 0x000fe200078ee206ULL, 0x00002000483c7824ULL, 0x000fe200078e00ffULL,
0x00f68c163dff738cULL, 0x0003e20000000000ULL, 0x0000000105067824ULL, 0x100fe200078e0a00ULL,
0x000000410b0d7212ULL, 0x080fe200078e3cffULL, 0x000062003f007a24ULL, 0x000fe200078e0200ULL,
0x000000410a057212ULL, 0x000fe200078e3cffULL, 0x000000080b187824ULL, 0x000fe200078e00ffULL,
0x00000000480473c2ULL, 0x0004e200000e0000ULL, 0x0000000100047824ULL, 0x000fe200078e0204ULL,
0x000000700e197812ULL, 0x000fe200078ec0ffULL, 0x0000000100087824ULL, 0x000fe200078e0208ULL,
0xfffffff8180d7812ULL, 0x000fe200078ee20dULL, 0x000000080a167824ULL, 0x002fc400078e00ffULL,
0x00000001000a7824ULL, 0x040fe400078e020aULL, 0x0000000100157824ULL, 0x000fe200078e020bULL,
0x0000b0003c007810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff1b7424ULL, 0x000fe200078e00ffULL,
0xfffffff8160b7812ULL, 0x000fc600078ee205ULL, 0x00005e0004047625ULL, 0x000fc800078e001bULL,
0x000000100d177824ULL, 0x100fe200078e0200ULL, 0x00000020060d7807ULL, 0x000fe20000000000ULL,
0x00000010070f7824ULL, 0x100fe200078e0200ULL, 0x0000001904047210ULL, 0x000fe20007f1e0ffULL,
0x0000001009117824ULL, 0x000fe200078e0200ULL, 0x0000003e0d0d7217ULL, 0x000fe20007800000ULL,
0x00005e0008067625ULL, 0x000fc800078e001bULL, 0x000000100b137824ULL, 0x000fe400078e0200ULL,
0x00005e000a087625ULL, 0x000fc800078e001bULL, 0x00005e00150a7625ULL, 0x000fe200078e001bULL,
0x0000001908087210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000001906067210ULL, 0x080fe20007f1e0ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0a3eULL,
0x000000190a0a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe400008e0609ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000000d0c00720cULL, 0x080fe20003f06070ULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000000d1000720cULL, 0x080fe40003f26070ULL,
0x0000000d1200720cULL, 0x000fc40003f46070ULL, 0x0000000d1400720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x00cfec0000008000ULL, 0x0000f6a804047891ULL, 0x000fe2000f8e203fULL,
0x00f688003dff7f8cULL, 0x0003e2000c80043fULL, 0x00000001023b7812ULL, 0x000fe200078ec0ffULL,
0xff317217ff3a7424ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e2000c101c46ULL,
0x000000353400720cULL, 0x000fe20003f06070ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000006117faeULL, 0x0003e2000c901c46ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000008137faeULL, 0x0003e2000d101c46ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000f6a848387811ULL, 0x000fe200078e18ffULL, 0x000000000a177faeULL, 0x0005e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000167805ULL, 0x004fc6000001ff00ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x002fec0000008000ULL, 0x00000000ff607f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200038247f8cULL, 0x0004e2000c80043fULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000002038927810ULL, 0x000fe20007ffe0ffULL, 0x0000b56000000947ULL, 0x000fea0003800000ULL,
0xff317217ff3a7424ULL, 0x004fe400078e00ffULL, 0x000000ffff637224ULL, 0x000fc400078e00ffULL,
0x000000ffff237224ULL, 0x000fe400078e00ffULL, 0x0000010034007824ULL, 0x000fca00078e00ffULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x0000b4c000000947ULL, 0x006fea0003800000ULL,
0x0000040092007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff377224ULL, 0x000fe200078e0063ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240038007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x0000240038247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000003ff2f7819ULL, 0x000fe20000011641ULL,
0x0000010034497824ULL, 0x040fe200078e00ffULL, 0x0000000134007810ULL, 0x000fe20007ffe0ffULL,
0x0000100063247824ULL, 0x000fe200078e00ffULL, 0x00000001ff487819ULL, 0x000fe20000011602ULL,
0x000000013e267824ULL, 0x000fe200078e022fULL, 0x000000350000720cULL, 0x000fe20003f06070ULL,
0x0000001041437824ULL, 0x000fe200078e00ffULL, 0x000000082f477810ULL, 0x040fe20007ffe0ffULL,
0x0000002048007824ULL, 0x000fe200078e0249ULL, 0x0000004126257212ULL, 0x0c0fe200078e3cffULL,
0x00000008264a7824ULL, 0x000fe200078e00ffULL, 0x000000042f457810ULL, 0x040fe20007ffe0ffULL,
0x000000013e2c7824ULL, 0x000fe200078e0247ULL, 0x0000000c2f4f7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff317424ULL, 0x000fe200078e00ffULL, 0x0000004000007810ULL, 0x000fe20007ffe0ffULL,
0x000000013e287824ULL, 0x000fe200078e0245ULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee225ULL,
0x000000082c4c7824ULL, 0x000fe200078e00ffULL, 0x0000000003257217ULL, 0x000fe20007800000ULL,
0x000000013e2b7824ULL, 0x000fe200078e024fULL, 0x000000412c297212ULL, 0x080fe200078e3cffULL,
0x00000008282d7824ULL, 0x000fe200078e00ffULL, 0x0000100024277812ULL, 0x000fe200078e0cffULL,
0x0000000125257824ULL, 0x100fe200078e0a00ULL, 0x0000004128247212ULL, 0x080fe200078e3cffULL,
0x000000082b2e7824ULL, 0x000fe200078e00ffULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee229ULL,
0x000062003f007a24ULL, 0x000fe200078e0200ULL, 0x000000412b297212ULL, 0x000fe200078e3cffULL,
0x0000200048277824ULL, 0x000fe200078e0227ULL, 0xfffffff82d2a7812ULL, 0x000fe200078ee224ULL,
0x0000000126247824ULL, 0x100fe200078e0200ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee229ULL,
0x0000000128267824ULL, 0x000fe200078e0200ULL, 0x0000002025297807ULL, 0x000fe20000000000ULL,
0x00005e0024247625ULL, 0x080fe200078e0031ULL, 0x0000b000274d7810ULL, 0x000fe20007ffe0ffULL,
0x0000033000007945ULL, 0x000fe20003800000ULL, 0x0000007043337812ULL, 0x000fe200078ec0ffULL,
0x00005e0026267625ULL, 0x000fe200078e0031ULL, 0x000000293e297217ULL, 0x000fc40007800000ULL,
0x0000003324287210ULL, 0x080fe20007f1e0ffULL, 0x000000012c2c7824ULL, 0x100fe200078e0200ULL,
0x000000083d407812ULL, 0x000fe200078ec0ffULL, 0x000000012b2d7824ULL, 0x000fe400078e0200ULL,
0x000000102a4b7824ULL, 0x000fe200078e024dULL, 0x00000033262a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000129007824ULL, 0x000fe400078e0a3eULL, 0x000000ffff297224ULL, 0x000fe400000e0625ULL,
0x000000ffff2b7224ULL, 0x000fe200010e0627ULL, 0x000000002f00720cULL, 0x080fe20003f06070ULL,
0x00005e002c247625ULL, 0x000fe200078e0031ULL, 0x000000004500720cULL, 0x000fc40003f46070ULL,
0x000000004700720cULL, 0x080fe20003f66070ULL, 0x00005e002d267625ULL, 0x000fe200078e0031ULL,
0x000000004f00720cULL, 0x000fe40003f86070ULL, 0x0000003324247210ULL, 0x080fe20007fbe0ffULL,
0x00000008632f7824ULL, 0x000fe200078e00ffULL, 0x0000003326267210ULL, 0x000fe20007fde0ffULL,
0x00000010482c7824ULL, 0x000fe200078e00ffULL, 0xffffffe03d007812ULL, 0x000fe200078ec0ffULL,
0x000000104a4a7824ULL, 0x100fe200078e024dULL, 0x000000082f2d7812ULL, 0x000fe200078e0cffULL,
0x000000104c4c7824ULL, 0x000fc400078e024dULL, 0x000000102e4d7824ULL, 0x000fe200078e024dULL,
0x0000f6a82c2e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff257224ULL, 0x000fe200028e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000284a7faeULL, 0x0005e2000c101c46ULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x000000012e5c7824ULL, 0x000fe200078e022dULL, 0x000000002a4b7faeULL, 0x0005e2000d101c46ULL,
0x000000102c2d7812ULL, 0x000fc600078ec0ffULL, 0x00000000244c7faeULL, 0x0005e2000d901c46ULL,
0x0000000040407210ULL, 0x000fc60007ffe02dULL, 0x00000000264d7faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000000005c0403c2ULL, 0x000ee40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x008fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000012e2e7824ULL, 0x000fe200078e022fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000005c5c7f8cULL, 0x000ee8000c80043fULL,
0x000004002e267984ULL, 0x0045220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6080040247f8cULL, 0x000fe2000c80043fULL,
0x8000000026ff7812ULL, 0x012fc60007844861ULL, 0x00f60c0040277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000b000000947ULL, 0x000fea0003800000ULL,
0x000000103d277812ULL, 0x000fca00078ec0ffULL, 0x0000000100267824ULL, 0x000fe400078e0227ULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x000000083b267824ULL, 0x000fe400078e0226ULL,
0x0000000000277305ULL, 0x000324000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000270000735dULL, 0x010fe40003800000ULL, 0x00f60c0026277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002002427824ULL, 0x000fe200078e00ffULL, 0x00000001ff447819ULL, 0x000fe20000011641ULL,
0xffffffffff457424ULL, 0x000fe200078e00ffULL, 0x0000007043437812ULL, 0x000fe400078ec0ffULL,
0xffffff8042427812ULL, 0x000fe400078ec0ffULL, 0x0000000c44447812ULL, 0x000fc800078ec0ffULL,
0x0000004244007210ULL, 0x000fca0007ffe043ULL, 0x00f0000000277984ULL, 0x000e680000000800ULL,
0x00f2000000267984ULL, 0x0008a20000000800ULL, 0x0000003a2700720bULL, 0x002fe20003f1d000ULL,
0x000140527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x010fc800000e0100ULL,
0x0000ffff002a7812ULL, 0x000fe2000780c0ffULL, 0x000003e000007945ULL, 0x000fe20003800000ULL,
0x00000001ff527424ULL, 0x000fd600078e00ffULL, 0x000003b000008947ULL, 0x000fea0003800000ULL,
0x00000002ff257819ULL, 0x000fe40000011602ULL, 0x0000003a2700720bULL, 0x000fe40003f14000ULL,
0x000000022500720cULL, 0x000fe20003f65270ULL, 0x000140127f007947ULL, 0x000ff4000b800000ULL,
0x0000000000007806ULL, 0x000fe400000e0100ULL, 0x000000800225b824ULL, 0x000fe200078e0243ULL,
0x000000273a307209ULL, 0x000fe40007810000ULL, 0x0000ffff00297812ULL, 0x000fe200078e3cffULL,
0x000000014425b824ULL, 0x000fe200078e0225ULL, 0x00000002ff007819ULL, 0x000fe20000011641ULL,
0x800000303a247221ULL, 0x000fe20000010000ULL, 0x000000292aff7212ULL, 0x000fc4000780c0ffULL,
0x00f400302500b388ULL, 0x0003e20000000800ULL, 0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL,
0x00000024002f7308ULL, 0x0003220000000800ULL, 0x00013fa27f007947ULL, 0x000fea000b800000ULL,
0x00001f002f287589ULL, 0x01086400000e0000ULL, 0x0000000800007810ULL, 0x010fe20007ffe0ffULL,
0x00013ff27f007947ULL, 0x000fea000b800000ULL, 0x00001f002f007589ULL, 0x0008e400000e0000ULL,
0x8000003027270221ULL, 0x100fe20000010000ULL, 0x0000002f39397220ULL, 0x000fe20000410000ULL,
0x0000000023237220ULL, 0x088fe20000410000ULL, 0x0000000022227220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x0000002700360308ULL, 0x000ee20000000800ULL, 0x000000001a1a7220ULL, 0x080fe20000410000ULL,
0x0000000017177220ULL, 0x080fe20000410000ULL, 0x0000000016167220ULL, 0x080fe20000410000ULL,
0x0000000013137220ULL, 0x080fe20000410000ULL, 0x0000000012127220ULL, 0x080fe20000410000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x000000000b0b7220ULL, 0x080fe20000410000ULL, 0x000000000a0a7220ULL, 0x080fe20000410000ULL,
0x0000000007077220ULL, 0x080fe20000410000ULL, 0x0000000006067220ULL, 0x000fe20000410000ULL,
0x00000001ff527807ULL, 0x000fe20000000000ULL, 0x0000002821217220ULL, 0x082fe20000410000ULL,
0x0000002820207220ULL, 0x080fe20000410000ULL, 0x000000281d1d7220ULL, 0x080fe20000410000ULL,
0x000000281c1c7220ULL, 0x080fe20000410000ULL, 0x0000002819197220ULL, 0x080fe20000410000ULL,
0x0000002818187220ULL, 0x080fe20000410000ULL, 0x0000002815157220ULL, 0x080fe20000410000ULL,
0x0000002814147220ULL, 0x080fe20000410000ULL, 0x0000002811117220ULL, 0x080fe20000410000ULL,
0x0000002810107220ULL, 0x080fe20000410000ULL, 0x000000280d0d7220ULL, 0x080fe20000410000ULL,
0x000000280c0c7220ULL, 0x080fe20000410000ULL, 0x0000002809097220ULL, 0x080fe20000410000ULL,
0x0000002808087220ULL, 0x080fe20000410000ULL, 0x0000002805057220ULL, 0x080fe20000410000ULL,
0x0000002804047220ULL, 0x000fe20000410000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e0030ULL,
0x0000003626260220ULL, 0x00cfc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000003926397221ULL, 0x004fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x000004002e007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007804861ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x004fe40003800000ULL, 0x000004002e247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007804861ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000036ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff277819ULL, 0x000fc40000011641ULL,
0x00005410002a7816ULL, 0x000fe20000000000ULL, 0x00013ca27f007947ULL, 0x000fea000b800000ULL,
0x00001f272a8b7589ULL, 0x0002a400000e0000ULL, 0x0000000827467810ULL, 0x000fe20007ffe0ffULL,
0x00013ce27f007947ULL, 0x000fea000b800000ULL, 0x00001f462a807589ULL, 0x00032400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x00000010272b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff2c7424ULL, 0x000fe200078e00ffULL, 0x00001ca000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x000149c000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x00000018272b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff2c7424ULL, 0x000fe200078e00ffULL, 0x00001d0000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0001496000007944ULL, 0x01cfea0003c00000ULL,
0x0000000202587824ULL, 0x040fe200078e00ffULL, 0x0000000741a87812ULL, 0x000fe200078ec0ffULL,
0x0000020002a97824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000000458007812ULL, 0x000fc400078ec0ffULL, 0x00000008a8a87812ULL, 0x000fe400078ef841ULL,
0x0000000041ab7211ULL, 0x000fe400078fe0ffULL, 0xfffff800a9a97812ULL, 0x000fe400078ec0ffULL,
0x00000007ab257812ULL, 0x000fe400078e78a8ULL, 0x0000000841007812ULL, 0x000fc600078ec0ffULL,
0x00000008a8247824ULL, 0x000fc800078e0225ULL, 0x0000001024477824ULL, 0x000fe400078e02a9ULL,
0x0000000402247824ULL, 0x000fe200078e00ffULL, 0x0000000700257812ULL, 0x100fe200078ec841ULL,
0x0000100002267824ULL, 0x000fe200078e00ffULL, 0x0000000700007812ULL, 0x000fe400078ef841ULL,
0x0000000424247812ULL, 0x000fe400078ec0ffULL, 0xffffe00026267812ULL, 0x000fe400078ec0ffULL,
0x0000002441247211ULL, 0x000fe400078fe0ffULL, 0x00000080002c7811ULL, 0x002fe200078e18ffULL,
0x0000100063267824ULL, 0x000fe200078e0226ULL, 0x00000024254f7212ULL, 0x000fc400078e3cffULL,
0x0000000224247810ULL, 0x000fe40007ffe0ffULL, 0x0000b00026277810ULL, 0x000fe20007ffe0ffULL,
0x00000008004e7824ULL, 0x000fe200078e024fULL, 0x0000002425517212ULL, 0x000fe200078e3cffULL,
0x0000100063267824ULL, 0x000fe200078e023cULL, 0x00000002abe37810ULL, 0x000fe20007ffe0ffULL,
0x000000104e307824ULL, 0x000fe200078e0227ULL, 0x0000991052e27816ULL, 0x000fe200000000ffULL,
0x0000000800507824ULL, 0x000fe200078e0251ULL, 0x0000b000262e7810ULL, 0x000fe20007ffe0ffULL,
0x000000014f4f7824ULL, 0x000fe200078e022cULL, 0x00000007e3e37812ULL, 0x000fe200078e78a8ULL,
0x000000003030783bULL, 0x000e620000004200ULL, 0x0000001050277824ULL, 0x000fc400078e0227ULL,
0x000000104f287824ULL, 0x000fe400078e022eULL, 0x00000008a8527824ULL, 0x000fe400078e02e3ULL,
0x000000002724783bULL, 0x000f620000004200ULL, 0x000000ffffa87224ULL, 0x000fe400078e00e2ULL,
0x0000001052527824ULL, 0x000fe200078e02a9ULL, 0x000000002828783bULL, 0x004ea20000004200ULL,
0x0000000151517824ULL, 0x000fe200078e022cULL, 0x000000ffa800720cULL, 0x000fc60003f45270ULL,
0x00000010512e7824ULL, 0x000fcc00078e022eULL, 0x000000002e2c783bULL, 0x010f220000004200ULL,
0x0000010030db7824ULL, 0x042fe200078e00ffULL, 0x0000003100bd7306ULL, 0x000fe20000009400ULL,
0x0001000030da7824ULL, 0x000fe200078e00ffULL, 0x00000018ffbc7819ULL, 0x000fe20000011431ULL,
0x0000010031d57824ULL, 0x040fe200078e00ffULL, 0x00000018ffdb7819ULL, 0x000fe200000114dbULL,
0x0001000031cd7824ULL, 0x000fe200078e00ffULL, 0x00000018ffda7819ULL, 0x000fe200000114daULL,
0x0000010032c77824ULL, 0x040fe200078e00ffULL, 0x000000db00d47306ULL, 0x000fe20000209400ULL,
0x00000018ffd57819ULL, 0x000fe200000114d5ULL, 0x0000010033c87824ULL, 0x000fe200078e00ffULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x0001000025a97824ULL, 0x020fe200078e00ffULL,
0x000000db00a87245ULL, 0x000fe2000020d400ULL, 0x0001000032cb7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x000000db00e17306ULL, 0x000e620000205400ULL,
0x00000018ffc47819ULL, 0x000fe20000011430ULL, 0x0001000033ca7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe200000114c8ULL, 0x0000010028967824ULL, 0x044fe200078e00ffULL,
0x00000018ffcb7819ULL, 0x000fe200000114cbULL, 0x00010000289e7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb37819ULL, 0x000fe20000011432ULL, 0x000000da00e07306ULL, 0x000fe20000209400ULL,
0x00000018ffae7819ULL, 0x000fe20000011433ULL, 0x0000010029997824ULL, 0x040fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe20000011428ULL, 0x00010000299b7824ULL, 0x000fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fe200000114caULL, 0x000001002a767824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe20000011429ULL, 0x000000da00df7306ULL, 0x000ea20000205400ULL,
0x000000e1d400720bULL, 0x002fe20003fbd000ULL, 0x000100002a697824ULL, 0x000fe200078e00ffULL,
0x00000018ffa77819ULL, 0x000fe20000011424ULL, 0x000001002b757824ULL, 0x040fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe2000001142aULL, 0x000100002b6d7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa67819ULL, 0x000fe20000011425ULL, 0x000000d500dd7306ULL, 0x000fe20000209400ULL,
0x00000018ff607819ULL, 0x000fc4000001142bULL, 0x00000018ff907819ULL, 0x000fe40000011426ULL,
0x00000018ff937819ULL, 0x000fe40000011427ULL, 0x00000001a8a85812ULL, 0x000fe200078efcffULL,
0x000000d500de7306ULL, 0x000e620000205400ULL, 0x000000dfe000720bULL, 0x004fe40003f1d000ULL,
0x00000018ff967819ULL, 0x000fe40000011496ULL, 0x00000018ff997819ULL, 0x000fc40000011499ULL,
0x00000018ff9e7819ULL, 0x000fe2000001149eULL, 0x0000003100ba7306ULL, 0x000ea20000005400ULL,
0x00000018ff9b7819ULL, 0x000fe4000001149bULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x0000003000c17306ULL, 0x000fe20000009400ULL, 0x000000dedd00720bULL, 0x002fc40003fbd000ULL,
0x00000018ff6d7819ULL, 0x000fca000001146dULL, 0x0000003000be7306ULL, 0x000e620000005400ULL,
0x000000babd00720bULL, 0x004fe40003f9d000ULL, 0x00000018ffbd7819ULL, 0x000fe400000114a9ULL,
0x000000da00a97245ULL, 0x000fe4000020d400ULL, 0x000000d500ba7245ULL, 0x000fe2000020d400ULL,
0x000000cd00dc7306ULL, 0x000fe20000209400ULL, 0x00000001a9a90812ULL, 0x000fe400078efcffULL,
0x00000001baba5812ULL, 0x000fca00078efcffULL, 0x000000cd00d97306ULL, 0x0005620000205400ULL,
0x000000bec100720bULL, 0x002fe20003fdd000ULL, 0x0000010026c17824ULL, 0x000fca00078e00ffULL,
0x00000018ffc17819ULL, 0x000fe200000114c1ULL, 0x000000bc00bf7306ULL, 0x000fe20000209400ULL,
0x000000cd00cd7245ULL, 0x004fce000020d400ULL, 0x000000bc00c07306ULL, 0x0002a20000205400ULL,
0x000000d9dc00720bULL, 0x020fce0003f1d000ULL, 0x00000031007b7306ULL, 0x000962000000d400ULL,
0x000000bc00bc7245ULL, 0x002fca000020d400ULL, 0x00000001cdcd0812ULL, 0x000fe400078efcffULL,
0x000000c700cc7306ULL, 0x000fe20000209400ULL, 0x000000c0bf00720bULL, 0x004fe40003fbd000ULL,
0x00000018ff317819ULL, 0x010fca000001142cULL, 0x000000c700c97306ULL, 0x0002a20000205400ULL,
0x000000017b7b4812ULL, 0x020fca00078efcffULL, 0x00000001bcbc5812ULL, 0x000fe400078efcffULL,
0x0000003000877306ULL, 0x000962000000d400ULL, 0x000000c700c77245ULL, 0x002fce000020d400ULL,
0x000000c400d77306ULL, 0x000fe20000209400ULL, 0x000000c9cc00720bULL, 0x004fe40003f9d000ULL,
0x00000018ff307819ULL, 0x010fca000001142dULL, 0x000000c400d87306ULL, 0x000e620000205400ULL,
0x0000000187876812ULL, 0x020fca00078efcffULL, 0x00000001c7c74812ULL, 0x000fe400078efcffULL,
0x0000003200b97306ULL, 0x000ff00000009400ULL, 0x0000003200b67306ULL, 0x000ea20000005400ULL,
0x000000d8d700720bULL, 0x002fce0003f7d000ULL, 0x000000c800cf7306ULL, 0x000ff00000209400ULL,
0x000000c800d67306ULL, 0x0003220000205400ULL, 0x000000b6b900720bULL, 0x004fe40003fdd000ULL,
0x000000c400b67245ULL, 0x000fc8000020d400ULL, 0x00000001b6b63812ULL, 0x000fe200078efcffULL,
0x000000cb00ce7306ULL, 0x000fe20000209400ULL, 0x000000c800c87245ULL, 0x002fce000020d400ULL,
0x000000cb00d37306ULL, 0x0002a20000205400ULL, 0x000000d6cf00720bULL, 0x010fce0003f1d000ULL,
0x000000b300bb7306ULL, 0x000fe20000209400ULL, 0x000000cb00cb7245ULL, 0x002fca000020d400ULL,
0x00000001c8c80812ULL, 0x000fe400078efcffULL, 0x000000b300b87306ULL, 0x000e620000205400ULL,
0x000000d3ce00720bULL, 0x004fce0003fbd000ULL, 0x0000003200747306ULL, 0x000eac000000d400ULL,
0x00000001cbcb5812ULL, 0x000fe400078efcffULL, 0x0000003300b17306ULL, 0x000fe20000009400ULL,
0x000000b8bb00720bULL, 0x002fce0003f9d000ULL, 0x0000003300b07306ULL, 0x000e620000005400ULL,
0x0000000174746812ULL, 0x004fce00078efcffULL, 0x000000ae00b47306ULL, 0x000ff00000209400ULL,
0x000000ae00b77306ULL, 0x000ea20000205400ULL, 0x000000b0b100720bULL, 0x002fe20003f7d000ULL,
0x0000010027b07824ULL, 0x000fc400078e00ffULL, 0x0001000026b17824ULL, 0x000fc600078e00ffULL,
0x00000018ffc07819ULL, 0x000fe200000114b0ULL, 0x00000028008f7306ULL, 0x000fe20000009400ULL,
0x000000b300b07245ULL, 0x000fc8000020d400ULL, 0x00000001b0b04812ULL, 0x000fc600078efcffULL,
0x0000002800847306ULL, 0x000fe20000005400ULL, 0x000000b7b400720bULL, 0x004fe40003fdd000ULL,
0x000000cbb0b0723eULL, 0x000fca00000010ffULL, 0x00000028005a7306ULL, 0x0003f0000000d400ULL,
0x00000029008c7306ULL, 0x000fe20000009400ULL, 0x0000010025287824ULL, 0x002fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000029007f7306ULL, 0x000ff00000005400ULL,
0x0000002900007306ULL, 0x0003f0000000d400ULL, 0x0000002400b27306ULL, 0x000fe20000009400ULL,
0x0000010024297824ULL, 0x002fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002400b57306ULL, 0x000e700000005400ULL, 0x0000002400647306ULL, 0x000530000000d400ULL,
0x000000ca00d07306ULL, 0x000fe20000209400ULL, 0x0001000024247824ULL, 0x004fe200078e00ffULL,
0x000000b5b200720bULL, 0x002fc40003fbd000ULL, 0x00000018ffb27819ULL, 0x000fe400000114b1ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x000000ca00d17306ULL, 0x0002a20000205400ULL,
0x000000ae00b17245ULL, 0x000fc8000020d400ULL, 0x00000001b1b16812ULL, 0x000fe400078efcffULL,
0x0000000164645812ULL, 0x010fe200078efcffULL, 0x0000002a008d7306ULL, 0x000fe20000009400ULL,
0x000000ca00ca7245ULL, 0x002fce000020d400ULL, 0x0000002a007e7306ULL, 0x000fe20000005400ULL,
0x000000d1d000720bULL, 0x004fce0003f1d000ULL, 0x0000002a00577306ULL, 0x000fec000000d400ULL,
0x00000001caca0812ULL, 0x000fe400078efcffULL, 0x00000028002a7306ULL, 0x000fe40000209400ULL,
0x000000cab1b1723eULL, 0x000fcc00000010ffULL, 0x0000002800ab7306ULL, 0x000e700000205400ULL,
0x0000002500ad7306ULL, 0x000ff00000009400ULL, 0x0000002500aa7306ULL, 0x000ea20000005400ULL,
0x000000ab2a00720bULL, 0x002fc40003f9d000ULL, 0x0000002900ab7245ULL, 0x000fca000020d400ULL,
0x0000002500627306ULL, 0x000e70000000d400ULL, 0x0000002400d47306ULL, 0x000fe20000209400ULL,
0x000000aaad00720bULL, 0x004fe40003f1d000ULL, 0x0000002800ad7245ULL, 0x000fc4000020d400ULL,
0x0000002400aa7245ULL, 0x000fe4000020d400ULL, 0x00000001adad4812ULL, 0x000fe200078efcffULL,
0x0000002400257306ULL, 0x000eac0000205400ULL, 0x0000000162620812ULL, 0x002fe400078efcffULL,
0x000000bd00be7306ULL, 0x000ff00000209400ULL, 0x000000bd00b97306ULL, 0x0003220000205400ULL,
0x00000025d400720bULL, 0x004fce0003fdd000ULL, 0x0000003300737306ULL, 0x000ea2000000d400ULL,
0x000000bd00bd7245ULL, 0x002fca000020d400ULL, 0x00000001aaaa6812ULL, 0x000fe400078efcffULL,
0x0000002b008a7306ULL, 0x000fe20000009400ULL, 0x000000b9be00720bULL, 0x010fce0003f9d000ULL,
0x0000002b00837306ULL, 0x000fe20000005400ULL, 0x0000000173733812ULL, 0x004fca00078efcffULL,
0x00000001bdbd4812ULL, 0x000fe400078efcffULL, 0x0000002b00567306ULL, 0x000ff0000000d400ULL,
0x0000002600ac7306ULL, 0x000ff00000009400ULL, 0x0000002600af7306ULL, 0x000ff00000005400ULL,
0x0000002600617306ULL, 0x000ff0000000d400ULL, 0x0000002900d27306ULL, 0x000ff00000209400ULL,
0x00000029002b7306ULL, 0x000e700000205400ULL, 0x000000c100bf7306ULL, 0x000ff00000209400ULL,
0x000000c100267306ULL, 0x000ea20000205400ULL, 0x0000002bd200720bULL, 0x002fc40003f7d000ULL,
0x009000004728783bULL, 0x000e6a0000000200ULL, 0x00000027008e7306ULL, 0x000fec0000009400ULL,
0x00000001abab3812ULL, 0x000fc400078efcffULL, 0x0000002700917306ULL, 0x000f220000005400ULL,
0x00000026bf00720bULL, 0x004fe40003fdd000ULL, 0x000000afac00720bULL, 0x000fe40003f7d000ULL,
0x000000c100ac7245ULL, 0x000fc6000020d400ULL, 0x00000027005b7306ULL, 0x00056c000000d400ULL,
0x00000001acac6812ULL, 0x000fe400078efcffULL, 0x000000a600c37306ULL, 0x000fe20000209400ULL,
0x0001000027277824ULL, 0x004fe200078e00ffULL, 0x000000918e00720bULL, 0x010fc40003f9d000ULL,
0x0000000161613812ULL, 0x000fe400078efcffULL, 0x00000018ffb47819ULL, 0x000fe40000011427ULL,
0x009000005224783bULL, 0x000ea20000000200ULL, 0x000000a600c27306ULL, 0x0008e20000205400ULL,
0x000000848f00720bULL, 0x000fe20003f7d000ULL, 0x0000008b2828a231ULL, 0x082fe200003400ffULL,
0x000000b2008f7245ULL, 0x000fe2000020d400ULL, 0x0000008b2a2aa231ULL, 0x000fe200003400ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001142eULL, 0x000000802929a231ULL, 0x080fe200003400ffULL,
0x000000015b5b4812ULL, 0x020fe200078efcffULL, 0x0000009300947306ULL, 0x000fe20000209400ULL,
0x000000a600a67245ULL, 0x010fe2000020d400ULL, 0x000000802b2ba231ULL, 0x000fe200003400ffULL,
0x00000061acac723eULL, 0x000fc600000010ffULL, 0x000000015a5a3812ULL, 0x000fe400078efcffULL,
0x0000009300957306ULL, 0x0003220000205400ULL, 0x000000c2c300720bULL, 0x008fe20003f1d000ULL,
0x000000b02810723cULL, 0x000fec0000041810ULL, 0x0000009000a47306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x002fca000020d400ULL, 0x00000001a6a60812ULL, 0x000fe400078efcffULL,
0x0000009000a57306ULL, 0x0002e20000205400ULL, 0x000000959400720bULL, 0x010fe20003f9d000ULL,
0x0000008b2424a231ULL, 0x004fcc00003400ffULL, 0x000000a700c67306ULL, 0x000fe20000209400ULL,
0x0000009000907245ULL, 0x002fe2000020d400ULL, 0x0000008b2626a231ULL, 0x000fe200003400ffULL,
0x000001002c8b7824ULL, 0x000fe200078e00ffULL, 0x000000802525a231ULL, 0x080fe400003400ffULL,
0x0000000193934812ULL, 0x000fe200078efcffULL, 0x000000802727a231ULL, 0x000fe200003400ffULL,
0x000000a700c57306ULL, 0x0002a20000205400ULL, 0x000000a5a400720bULL, 0x008fe20003fdd000ULL,
0x000100002f807824ULL, 0x000fe200078e00ffULL, 0x000000c000a47245ULL, 0x000fc8000020d400ULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x000000b200ae7306ULL, 0x000fe20000209400ULL,
0x000000a700a77245ULL, 0x002fca000020d400ULL, 0x0000000190906812ULL, 0x000fe400078efcffULL,
0x000000b200af7306ULL, 0x000e620000205400ULL, 0x000000c5c600720bULL, 0x004fe40003fbd000ULL,
0x0000007e8d00720bULL, 0x000fe40003fdd000ULL, 0x00000018ff8d7819ULL, 0x000fe4000001148bULL,
0x00000096008b7245ULL, 0x000fe2000020d400ULL, 0x0000009600977306ULL, 0x000fe20000209400ULL,
0x00000018ff7e7819ULL, 0x000fca000001142fULL, 0x00000001a7a75812ULL, 0x000fe400078efcffULL,
0x0000009600987306ULL, 0x0004e20000205400ULL, 0x000000afae00720bULL, 0x002fe40003f1d000ULL,
0x0000000157576812ULL, 0x000fe400078efcffULL, 0x000000aaa7aa723eULL, 0x000fc600000010ffULL,
0x00000099009a7306ULL, 0x000fe20000209400ULL, 0x000100002c967824ULL, 0x004fca00078e00ffULL,
0x000000018f8f0812ULL, 0x000fe400078efcffULL, 0x00000099009f7306ULL, 0x0002a20000205400ULL,
0x000000989700720bULL, 0x008fe20003f9d000ULL, 0x000100002d987824ULL, 0x000fe200078e00ffULL,
0x0000007f8c00720bULL, 0x000fe40003f1d000ULL, 0x000000b4008c7245ULL, 0x000fe4000020d400ULL,
0x00000018ff967819ULL, 0x000fe20000011496ULL, 0x000000c000b87306ULL, 0x000fe20000209400ULL,
0x0000009900997245ULL, 0x002fc4000020d400ULL, 0x00000018ff987819ULL, 0x000fc60000011498ULL,
0x000000018b8b4812ULL, 0x000fe400078efcffULL, 0x000000c000b37306ULL, 0x000e620000205400ULL,
0x0000009f9a00720bULL, 0x004fe20003f5d000ULL, 0x000001002e9a7824ULL, 0x000fe200078e00ffULL,
0x0000000100000812ULL, 0x000fe400078efcffULL, 0x0000009b009f7245ULL, 0x000fe4000020d400ULL,
0x00000018ff9a7819ULL, 0x000fe2000001149aULL, 0x0000009e00a07306ULL, 0x000fe20000209400ULL,
0x0000005a8b5a723eULL, 0x000fca00000010ffULL, 0x0000000199992812ULL, 0x000fe400078efcffULL,
0x0000009e00a37306ULL, 0x0004e20000205400ULL, 0x000000b3b800720bULL, 0x002fce0003fbd000ULL,
0x0000007c00857306ULL, 0x000fe20000209400ULL, 0x0000009e009e7245ULL, 0x004fca000020d400ULL,
0x00000001a4a45812ULL, 0x000fe400078efcffULL, 0x0000007c00827306ULL, 0x000e620000205400ULL,
0x000000a3a000720bULL, 0x008fe20003f9d000ULL, 0x000100002ea07824ULL, 0x000fe400078e00ffULL,
0x000001002fa37824ULL, 0x000fc600078e00ffULL, 0x00000018ffa07819ULL, 0x000fe200000114a0ULL,
0x0000009b00a17306ULL, 0x000fe20000209400ULL, 0x00000018ffa37819ULL, 0x000fca00000114a3ULL,
0x000000019e9e4812ULL, 0x000fe400078efcffULL, 0x0000009b00a27306ULL, 0x000ea20000205400ULL,
0x000000828500720bULL, 0x002fce0003f7d000ULL, 0x0000007700817306ULL, 0x000ff00000209400ULL,
0x0000007700867306ULL, 0x000e620000205400ULL, 0x000000a2a100720bULL, 0x004fe40003f5d000ULL,
0x0000008000a17245ULL, 0x000fca000020d400ULL, 0x000000b400b57306ULL, 0x000fec0000209400ULL,
0x000000019f9f2812ULL, 0x000fe400078efcffULL, 0x000000b400be7306ULL, 0x000ea20000205400ULL,
0x000000868100720bULL, 0x002fe40003f1d000ULL, 0x0000007c00817245ULL, 0x000fc8000020d400ULL,
0x0000000181813812ULL, 0x000fe200078efcffULL, 0x0000006600887306ULL, 0x000fe60000209400ULL,
0x0000009e819e723eULL, 0x000fca00000010ffULL, 0x0000006600897306ULL, 0x0002e20000205400ULL,
0x000000beb500720bULL, 0x004fce0003fbd000ULL, 0x0000006000797306ULL, 0x000fe20000209400ULL,
0x0000006600667245ULL, 0x002fca000020d400ULL, 0x000000018c8c5812ULL, 0x000fe400078efcffULL,
0x0000006000787306ULL, 0x0002a20000205400ULL, 0x000000898800720bULL, 0x008fe40003f9d000ULL,
0x000000838a00720bULL, 0x000fca0003fbd000ULL, 0x00000076009c7306ULL, 0x000fe20000209400ULL,
0x0000006000607245ULL, 0x002fca000020d400ULL, 0x0000000166664812ULL, 0x000fe400078efcffULL,
0x00000076009d7306ULL, 0x0002e20000205400ULL, 0x000000787900720bULL, 0x004fe40003f7d000ULL,
0x0000007700787245ULL, 0x000fe4000020d400ULL, 0x0000007500777245ULL, 0x000fe4000020d400ULL,
0x0000000178780812ULL, 0x000fe200078efcffULL, 0x00000075007a7306ULL, 0x000fe20000209400ULL,
0x0000007600767245ULL, 0x002fc4000020d400ULL, 0x0000000156565812ULL, 0x000fe400078efcffULL,
0x0000009f789f723eULL, 0x000fe400000010ffULL, 0x0000000160603812ULL, 0x000fe200078efcffULL,
0x00000075007d7306ULL, 0x000e620000205400ULL, 0x0000009d9c00720bULL, 0x008fce0003f5d000ULL,
0x00000069006f7306ULL, 0x000fec0000209400ULL, 0x0000000176762812ULL, 0x000fe400078efcffULL,
0x0000006900707306ULL, 0x0004e20000205400ULL, 0x0000007d7a00720bULL, 0x002fe40003f1d000ULL,
0x000000577676723eULL, 0x000fca00000010ffULL, 0x0000008d00947306ULL, 0x000fe20000209400ULL,
0x0000006900697245ULL, 0x004fca000020d400ULL, 0x0000000177770812ULL, 0x000fe400078efcffULL,
0x0000008d00957306ULL, 0x000e620000205400ULL, 0x000000706f00720bULL, 0x008fe40003fdd000ULL,
0x000000567777723eULL, 0x000fca00000010ffULL, 0x0000002c006e7306ULL, 0x000fec0000009400ULL,
0x0000000169696812ULL, 0x000fe400078efcffULL, 0x0000002c006b7306ULL, 0x000ea20000005400ULL,
0x000000959400720bULL, 0x002fe40003f9d000ULL, 0x000000696666723eULL, 0x000fca00000010ffULL,
0x0000002c00597306ULL, 0x0002f0000000d400ULL, 0x0000002d00677306ULL, 0x000fe20000009400ULL,
0x000001002d2c7824ULL, 0x002fe200078e00ffULL, 0x0000006b6e00720bULL, 0x004fc80003f5d000ULL,
0x00000018ff977819ULL, 0x000fe4000001142cULL, 0x0000002d006c7306ULL, 0x000e620000005400ULL,
0x00000087a82c723eULL, 0x000fcc00000010ffULL, 0x0000000159592812ULL, 0x008fe200078efcffULL,
0x0000002d00557306ULL, 0x0004f0000000d400ULL, 0x0000002e00657306ULL, 0x000fe20000009400ULL,
0x0000007bba2d723eULL, 0x004fc400000010ffULL, 0x0000006c6700720bULL, 0x002fe40003f1d000ULL,
0x0000006d00677245ULL, 0x000fc6000020d400ULL, 0x0000002e006a7306ULL, 0x000e620000005400ULL,
0x0000002c2804723cULL, 0x000fee0000041804ULL, 0x0000006d00717306ULL, 0x000fe20000209400ULL,
0x00000074c72c723eULL, 0x000fe400000010ffULL, 0x00000073c82d723eULL, 0x000fc400000010ffULL,
0x0000000155550812ULL, 0x008fc600078efcffULL, 0x0000006d00727306ULL, 0x000ea20000205400ULL,
0x0000006a6500720bULL, 0x002fe20003fdd000ULL, 0x0000002c280c723cULL, 0x000fec000004180cULL,
0x0000003100337306ULL, 0x000fe20000209400ULL, 0x00000064ab2c723eULL, 0x000fe400000010ffULL,
0x00000062ad2d723eULL, 0x000fc400000010ffULL, 0x000000bda6ab723eULL, 0x000fe400000010ffULL,
0x0000005ba4ad723eULL, 0x000fe200000010ffULL, 0x0000003100687306ULL, 0x0002e20000205400ULL,
0x000000727100720bULL, 0x004fe20003fbd000ULL, 0x0000002c2814723cULL, 0x000fe20000041814ULL,
0x00000000995b723eULL, 0x000fca00000010ffULL, 0x0000009700827306ULL, 0x000fe20000209400ULL,
0x0000008f902c723eULL, 0x000fe200000010ffULL, 0x000000aa2818723cULL, 0x040fe20000041818ULL,
0x0000008c932d723eULL, 0x000fe400000010ffULL, 0x0000003100317245ULL, 0x002fe4000020d400ULL,
0x0000000167675812ULL, 0x000fe200078efcffULL, 0x0000009700857306ULL, 0x000fe20000205400ULL,
0x000000683300720bULL, 0x008fe20003f7d000ULL, 0x000000ac281c723cULL, 0x000fe2000004181cULL,
0x000000676067723eULL, 0x000fca00000010ffULL, 0x0000002e00547306ULL, 0x0002a4000000d400ULL,
0x0000002c2820723cULL, 0x000fe80000041820ULL, 0x0000000131313812ULL, 0x000fe400078efcffULL,
0x0000002f005f7306ULL, 0x000fe20000009400ULL, 0x000000a9b62e723eULL, 0x002fe200000010ffULL,
0x0000005a2404723cULL, 0x040fec0000041804ULL, 0x0000002f005e7306ULL, 0x000e620000005400ULL,
0x0000000154546812ULL, 0x004fe200078efcffULL, 0x00000076240c723cULL, 0x040fec000004180cULL,
0x0000002f00537306ULL, 0x0005e4000000d400ULL, 0x000000662410723cULL, 0x000fec0000041810ULL,
0x0000003000327306ULL, 0x000fe20000209400ULL, 0x000000cdbc2f723eULL, 0x004fc400000010ffULL,
0x0000005e5f00720bULL, 0x002fca0003fbd000ULL, 0x0000003000917306ULL, 0x0002a20000205400ULL,
0x0000002e2808723cULL, 0x000fee0000041808ULL, 0x0000008d002e7245ULL, 0x000fe2000020d400ULL,
0x0000009600797306ULL, 0x000fe20000209400ULL, 0x0000003000307245ULL, 0x002fc4000020d400ULL,
0x000000012e2e4812ULL, 0x000fe400078efcffULL, 0x000000858200720bULL, 0x000fe40003f9d000ULL,
0x000000913200720bULL, 0x004fe20003f5d000ULL, 0x0000009600747306ULL, 0x0002a20000205400ULL,
0x0000009700327245ULL, 0x000fe4000020d400ULL, 0x0000009800977245ULL, 0x000fe4000020d400ULL,
0x0000009a00297245ULL, 0x000fc4000020d400ULL, 0x0000000153535812ULL, 0x000fe200078efcffULL,
0x00000098002f7306ULL, 0x000fe20000209400ULL, 0x0000009600967245ULL, 0x002fe2000020d400ULL,
0x0000009e2408723cULL, 0x000fe20000041808ULL, 0x0000000132324812ULL, 0x000fe400078efcffULL,
0x0000000130302812ULL, 0x000fe400078efcffULL, 0x000000592e2e723eULL, 0x000fe200000010ffULL,
0x00000098006c7306ULL, 0x000e620000205400ULL, 0x000000747900720bULL, 0x004fce0003f9d000ULL,
0x0000009a00647306ULL, 0x000fec0000209400ULL, 0x0000000196964812ULL, 0x000fe400078efcffULL,
0x0000009a00657306ULL, 0x000ea20000205400ULL, 0x0000006c2f00720bULL, 0x002fe40003f1d000ULL,
0x00000055322f723eULL, 0x000fc400000010ffULL, 0x000000963196723eULL, 0x000fc600000010ffULL,
0x0000008e00847306ULL, 0x000fe40000209400ULL, 0x0000002e2414723cULL, 0x000fe80000041814ULL,
0x0000000197970812ULL, 0x000fe400078efcffULL, 0x0000008e007f7306ULL, 0x000e620000205400ULL,
0x000000656400720bULL, 0x004fe40003f7d000ULL, 0x000000973097723eULL, 0x000fca00000010ffULL,
0x0000007e00837306ULL, 0x000fe40000209400ULL, 0x000000962418723cULL, 0x000fe80000041818ULL,
0x0000000129293812ULL, 0x000fe400078efcffULL, 0x0000007e008a7306ULL, 0x0004e20000205400ULL,
0x0000007f8400720bULL, 0x002fe40003f9d000ULL, 0x000000542954723eULL, 0x000fc400000010ffULL,
0x0000008e00297245ULL, 0x000fc6000020d400ULL, 0x000000a3005e7306ULL, 0x000fe20000209400ULL,
0x0000007e007e7245ULL, 0x004fca000020d400ULL, 0x0000000129294812ULL, 0x000fe400078efcffULL,
0x000000a3005f7306ULL, 0x000e620000205400ULL, 0x0000008a8300720bULL, 0x008fce0003f1d000ULL,
0x000000a000337306ULL, 0x000fec0000209400ULL, 0x000000017e7e0812ULL, 0x000fe400078efcffULL,
0x000000a000007306ULL, 0x0004e20000205400ULL, 0x0000005f5e00720bULL, 0x002fce0003f5d000ULL,
0x0000008000287306ULL, 0x000fe20000209400ULL, 0x000000a000a07245ULL, 0x004fce000020d400ULL,
0x00000080002b7306ULL, 0x000e620000205400ULL, 0x000000003300720bULL, 0x008fe40003f7d000ULL,
0x000000a300007245ULL, 0x000fc8000020d400ULL, 0x0000000100002812ULL, 0x000fc800078efcffULL,
0x000000530055723eULL, 0x000fc600000010ffULL, 0x00000001a0a03812ULL, 0x000fe400078efcffULL,
0x0000002b2800720bULL, 0x002fe40003fdd000ULL, 0x000000a029a0723eULL, 0x000fe200000010ffULL,
0x00000054241c723cULL, 0x000ff4000004181cULL, 0x00000001a1a16812ULL, 0x000fc800078efcffULL,
0x000000a17ea1723eULL, 0x000fce00000010ffULL, 0x000000a02420723cULL, 0x000fe20000041820ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200038247f8cULL, 0x0002a2000c80043fULL,
0xfffffff858537812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004049007810ULL, 0x000fe20007ffe0ffULL, 0x00f6880053ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff617224ULL, 0x000fe200078e005dULL, 0x0000000163637812ULL, 0x000fe400078e0cffULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x0000846000000947ULL, 0x000fea0003800000ULL,
0x0000040092007984ULL, 0x008ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000240038007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x0000240038247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000441257811ULL, 0x000fe200078fe8ffULL, 0x00000080ff337424ULL, 0x000fe200078e00ffULL,
0x00000001ff487819ULL, 0x000fe20000011602ULL, 0x0000000837547824ULL, 0x000fe200078e00ffULL,
0x0000003e41007211ULL, 0x000fe200078fe8ffULL, 0x000000013e247824ULL, 0x000fe200078e0225ULL,
0x00000003ff2f7819ULL, 0x000fe20000011641ULL, 0x0000002048277824ULL, 0x000fe200078e0249ULL,
0x0000004100257212ULL, 0x0c0fe200078e3cffULL, 0x0000000800287824ULL, 0x000fe200078e00ffULL,
0x0000004124007212ULL, 0x040fe200078e3cffULL, 0x0000000824297824ULL, 0x000fe200078e00ffULL,
0x0000008027247810ULL, 0x000fe20007ffe0ffULL, 0x0000100037607824ULL, 0x000fe200078e00ffULL,
0xfffffff828577812ULL, 0x000fc400078ee225ULL, 0xfffffff829587812ULL, 0x000fe200078ee200ULL,
0x000062003f2d7a24ULL, 0x100fe200078e0224ULL, 0x0000002403297217ULL, 0x000fe40007800000ULL,
0x0000000841257811ULL, 0x000fe400078fe8ffULL, 0x0000000134267810ULL, 0x000fe20007ffe0ffULL,
0x0000000129297824ULL, 0x000fe200078e0a24ULL, 0x0000000c41277811ULL, 0x000fe200078fe8ffULL,
0x000000013e007824ULL, 0x000fe200078e0225ULL, 0x000000042f317810ULL, 0x000fc40007ffe0ffULL,
0x000000352600720cULL, 0x000fe20003f06070ULL, 0x000000013e267824ULL, 0x000fe200078e0227ULL,
0x0000002f2d247210ULL, 0x140fe20007ffe03eULL, 0x0000000800597824ULL, 0x000fe200078e00ffULL,
0x000000312d277210ULL, 0x000fe20007ffe03eULL, 0x00000008262b7824ULL, 0x000fe200078e00ffULL,
0x0000002029297807ULL, 0x000fe20000000000ULL, 0x00005e0024247625ULL, 0x000fe200078e0033ULL,
0x0000004100287212ULL, 0x080fe400078e3cffULL, 0x0000004126007212ULL, 0x000fe200078e3cffULL,
0x00005e0027267625ULL, 0x000fe200078e0033ULL, 0x000000293e297217ULL, 0x000fc40007800000ULL,
0xfffffff859597812ULL, 0x000fe400078ee228ULL, 0x0000004324287210ULL, 0x080fe20007f1e0ffULL,
0x00000001292c7824ULL, 0x000fe200078e0a3eULL, 0x00000043262a7210ULL, 0x000fe40007f5e0ffULL,
0x0000f6a848557811ULL, 0x000fe200078e20ffULL, 0x000000ffff297224ULL, 0x000fe200000e0625ULL,
0x00000008542e7812ULL, 0x000fe400078ec0ffULL, 0xfffffff82b007812ULL, 0x000fe200078ee200ULL,
0x000000ffff2b7224ULL, 0x000fe200010e0627ULL, 0x0000100060257812ULL, 0x000fe200078ec0ffULL,
0x0000000155567824ULL, 0x000fe200078e022eULL, 0x000000082f277810ULL, 0x000fc40007ffe0ffULL,
0x0000002c2f00720cULL, 0x0c0fe20003f06070ULL, 0x0000200048257824ULL, 0x000fe200078e0225ULL,
0x0000000c2f2f7810ULL, 0x000fe20007ffe0ffULL, 0x00000000560473c2ULL, 0x000ea200000e0000ULL,
0x000000272d247210ULL, 0x140fe40007ffe03eULL, 0x0000002f2d267210ULL, 0x000fe40007ffe03eULL,
0x0000b000255a7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0024247625ULL, 0x000fe200078e0033ULL,
0x0000002c2700720cULL, 0x000fc40003f66070ULL, 0x0000002c3100720cULL, 0x080fe20003f46070ULL,
0x00005e0026267625ULL, 0x000fe200078e0033ULL, 0x0000002c2f00720cULL, 0x000fe40003f86070ULL,
0x0000004324247210ULL, 0x080fe20007fbe0ffULL, 0x0000001057577824ULL, 0x100fe200078e025aULL,
0x0000004326267210ULL, 0x000fe20007fde0ffULL, 0x0000001058587824ULL, 0x100fe400078e025aULL,
0x0000001059597824ULL, 0x100fe200078e025aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028577faeULL, 0x0007e2000c101c46ULL, 0x00000010005a7824ULL, 0x000fe200078e025aULL,
0x000000082e007812ULL, 0x000fe200078e3cffULL, 0x000000ffff257224ULL, 0x000fe200028e0625ULL,
0x000000002a587faeULL, 0x0007e2000d101c46ULL, 0x000000ffff277224ULL, 0x000fc400030e0627ULL,
0x00000001555b7824ULL, 0x000fe200078e0200ULL, 0x0000000024597faeULL, 0x0007e8000d901c46ULL,
0x00000000265a7faeULL, 0x0007e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x004fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000056247f8cULL, 0x0084e8000c80043fULL,
0x000004005b297984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6280040267f8cULL, 0x000fe2000c80043fULL,
0x8000000029ff7812ULL, 0x010fc6000784485dULL, 0x00f62c00402b7984ULL, 0x000f240000000800ULL,
0x800000002bff7812ULL, 0x010fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff617224ULL, 0x008fe200078e0025ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000000083d247812ULL, 0x040fe200078ec0ffULL,
0x3e000000ff007424ULL, 0x000fe200078e00ffULL, 0xffffffe03d257812ULL, 0x040fe400078ec0ffULL,
0x000000103d287812ULL, 0x000fc800078ec0ffULL, 0x0000002524247210ULL, 0x000fe40007ffe028ULL,
0x0000000000257305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000250000735dULL, 0x010fe40003800000ULL, 0x00f62c0024257984ULL, 0x000ee40000000800ULL,
0x8000000025ff7812ULL, 0x008fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008043257810ULL, 0x000fca0007ffe042ULL, 0x0000000144257824ULL, 0x000fca00078e0225ULL,
0x00f0000025277984ULL, 0x000ee80000000800ULL, 0x00f2000025007984ULL, 0x0008620000000800ULL,
0x0000003a2700720bULL, 0x008fe20003f1d000ULL, 0x000113427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x010fc800000e0100ULL, 0x0000ffff24267812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ffa47424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000102257811ULL, 0x000fe400078ff0ffULL,
0x0000003a2700720bULL, 0x000fe40003f14000ULL, 0x000000022500720cULL, 0x000fe20003f65270ULL,
0x000113027f007947ULL, 0x000ff4000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x000000273a287209ULL, 0x000fe20007810000ULL, 0x000000800229b824ULL, 0x000fc800078e0243ULL,
0x00000001442bb824ULL, 0x000fe200078e0229ULL, 0x800000283a257221ULL, 0x000fe20000010000ULL,
0x0000ffff24297812ULL, 0x000fc600078e3cffULL, 0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL,
0x00f400282b00b388ULL, 0x0007e20000000800ULL, 0x0000002926ff7212ULL, 0x000fe4000780c0ffULL,
0x00000025002a7308ULL, 0x000f220000000800ULL, 0x00000002ff297819ULL, 0x000fe20000011641ULL,
0x0000002a39397220ULL, 0x010fe20000410000ULL, 0x000112827f007947ULL, 0x000fec000b800000ULL,
0x00001f292a247589ULL, 0x00872400000e0000ULL, 0x0000002404047220ULL, 0x090fe20000410000ULL,
0x0000002405057220ULL, 0x080fe20000410000ULL, 0x0000002408087220ULL, 0x080fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002420207220ULL, 0x080fe20000410000ULL,
0x0000002421217220ULL, 0x000fe20000410000ULL, 0x000111d27f007947ULL, 0x000fea000b800000ULL,
0x00001f462a247589ULL, 0x0008a400000e0000ULL, 0x8000002827270221ULL, 0x100fe20000010000ULL,
0x00000001ffa47807ULL, 0x000fe20000000000ULL, 0x0000002406067220ULL, 0x084fe20000410000ULL,
0x0000002407077220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x0000002700360308ULL, 0x000ea20000000800ULL,
0x000000240f0f7220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x0000002422227220ULL, 0x080fe20000410000ULL,
0x0000002423237220ULL, 0x000fe20000410000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e0028ULL,
0x0000000036000220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000003900397221ULL, 0x002fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x0000000837007824ULL, 0x000fe200078e00ffULL,
0xfffffff03d257812ULL, 0x000fc800078ec0ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000100247824ULL, 0x000fca00078e0225ULL, 0x00f6ac0024257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000257305ULL, 0x000364000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000250000735dULL, 0x020fe40003800000ULL, 0x00f6ac0024257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc4000780485dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff2b7819ULL, 0x000fe40000011641ULL, 0x00000036ff24723eULL, 0x000fe400000010ffULL,
0x000000182b007810ULL, 0x040fe40007ffe0ffULL, 0x000000102b267810ULL, 0x000fe40007ffe0ffULL,
0x00005410242a7816ULL, 0x018fe20000000024ULL, 0x00010f227f007947ULL, 0x000fea000b800000ULL,
0x00001f2b2a937589ULL, 0x0002e400000e0000ULL, 0x00010f627f007947ULL, 0x000fea000b800000ULL,
0x00001f462a8a7589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0026ULL, 0x00004c7000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x000119f000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0000ULL, 0x00004cd000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0001199000007944ULL, 0x01cfea0003c00000ULL, 0x0000100037297824ULL, 0x004fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100002007824ULL, 0x000fc600078e00ffULL,
0x0000100029297812ULL, 0x000fe400078e0cffULL, 0xffffe00000007812ULL, 0x000fe400078ec0ffULL,
0x0000b0003c5e7810ULL, 0x100fe40007ffe029ULL, 0x0000b00000257810ULL, 0x000fc60007ffe029ULL,
0x000000104f5d7824ULL, 0x100fe400078e025eULL, 0x000000104e5f7824ULL, 0x100fe400078e0225ULL,
0x00000010505c7824ULL, 0x000fe200078e0225ULL, 0x000000005d28783bULL, 0x012e620000004200ULL,
0x00000010515e7824ULL, 0x000fc600078e025eULL, 0x000000005f30783bULL, 0x000ea80000004200ULL,
0x000000005c24783bULL, 0x000f280000004200ULL, 0x000000005e2c783bULL, 0x000f620000004200ULL,
0x00000028008c7306ULL, 0x002fe20000009400ULL, 0x00000018ff9f7819ULL, 0x000fe20000011428ULL,
0x0001000028e77824ULL, 0x000fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011429ULL,
0x0000010030b47824ULL, 0x044fe200078e00ffULL, 0x00000018ffb27819ULL, 0x000fe20000011430ULL,
0x0001000030bb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffdb7819ULL, 0x000fe20000011431ULL,
0x0000003000f07306ULL, 0x000fe20000009400ULL, 0x00000018ffb47819ULL, 0x000fe200000114b4ULL,
0x0001000031e27824ULL, 0x000fe200078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe200000114bbULL,
0x0000010033d77824ULL, 0x040fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe20000011432ULL,
0x0001000033cf7824ULL, 0x000fe200078e00ffULL, 0x00000018ffe27819ULL, 0x000fe200000114e2ULL,
0x0000003000a37306ULL, 0x000e620000005400ULL, 0x00000018ffd77819ULL, 0x000fe200000114d7ULL,
0x0000010024c67824ULL, 0x050fe200078e00ffULL, 0x00000018ffcf7819ULL, 0x000fe200000114cfULL,
0x0000010025c47824ULL, 0x000fe200078e00ffULL, 0x00000018ffbe7819ULL, 0x000fe20000011433ULL,
0x0000010031b87824ULL, 0x000fe200078e00ffULL, 0x00000018ffc67819ULL, 0x000fe200000114c6ULL,
0x000000b400ad7306ULL, 0x000fe20000209400ULL, 0x00000018ffc47819ULL, 0x000fe200000114c4ULL,
0x0001000024c57824ULL, 0x000fe200078e00ffULL, 0x00000018ffa57819ULL, 0x000fe20000011424ULL,
0x0001000025c27824ULL, 0x000fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe200000114b8ULL,
0x0000010032dc7824ULL, 0x000fe200078e00ffULL, 0x00000018ffc57819ULL, 0x000fe200000114c5ULL,
0x000000b400ec7306ULL, 0x0005220000205400ULL, 0x000000a3f000720bULL, 0x002fe20003f1d000ULL,
0x0001000032d27824ULL, 0x000fe200078e00ffULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x0001000027a67824ULL, 0x000fe200078e00ffULL, 0x00000018ffdc7819ULL, 0x000fe200000114dcULL,
0x0000010029e97824ULL, 0x000fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe20000011425ULL,
0x000000b200aa7306ULL, 0x000fe20000209400ULL, 0x000000b400b47245ULL, 0x004fc4000020d400ULL,
0x00000018ff9d7819ULL, 0x000fe40000011426ULL, 0x00000018ff987819ULL, 0x000fe40000011427ULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x000000b200b17306ULL, 0x0002a20000205400ULL,
0x000000ecad00720bULL, 0x010fe40003f5d000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001142aULL,
0x00000018ff787819ULL, 0x000fc4000001142bULL, 0x00000018ffa67819ULL, 0x000fe200000114a6ULL,
0x000000bb00ee7306ULL, 0x000fe20000209400ULL, 0x000000b200b27245ULL, 0x002fe4000020d400ULL,
0x00000018ff687819ULL, 0x020fe4000001142dULL, 0x00000018ff6d7819ULL, 0x000fe4000001142cULL,
0x00000001b4b42812ULL, 0x000fe200078efcffULL, 0x000000bb00b37306ULL, 0x000e620000205400ULL,
0x000000b1aa00720bULL, 0x004fe20003fbd000ULL, 0x000100002bb17824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fc4000001142eULL, 0x00000018ff627819ULL, 0x000fe4000001142fULL,
0x00000018ffb17819ULL, 0x000fe200000114b1ULL, 0x0000003000877306ULL, 0x00052c000000d400ULL,
0x00000001b2b25812ULL, 0x000fe400078efcffULL, 0x0000003100e87306ULL, 0x000fe20000009400ULL,
0x000000b3ee00720bULL, 0x002fe20003fdd000ULL, 0x0000010027307824ULL, 0x004fc400078e00ffULL,
0x000100002ab37824ULL, 0x000fc600078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000003100af7306ULL, 0x000e620000005400ULL, 0x0000000187870812ULL, 0x010fc800078efcffULL,
0x00000087b4b4723eULL, 0x000fc600000010ffULL, 0x000000e200ea7306ULL, 0x000ff00000209400ULL,
0x000000e200e57306ULL, 0x000ea20000205400ULL, 0x000000afe800720bULL, 0x002fe40003f5d000ULL,
0x000000bb00af7245ULL, 0x000fc8000020d400ULL, 0x00000001afaf6812ULL, 0x000fe200078efcffULL,
0x000000db00de7306ULL, 0x000fe60000209400ULL, 0x000000afb2b2723eULL, 0x000fca00000010ffULL,
0x000000db00df7306ULL, 0x000e620000205400ULL, 0x000000e5ea00720bULL, 0x004fce0003f1d000ULL,
0x0000003200b97306ULL, 0x000ff00000009400ULL, 0x0000003200e07306ULL, 0x000ea20000005400ULL,
0x000000dfde00720bULL, 0x002fe40003fbd000ULL, 0x000000db00de7245ULL, 0x000fc4000020d400ULL,
0x00000018ffdb7819ULL, 0x000fc600000114e7ULL, 0x0000003100857306ULL, 0x00032c000000d400ULL,
0x00000001dede5812ULL, 0x000fe400078efcffULL, 0x0000003300d67306ULL, 0x000fe20000009400ULL,
0x000000e0b900720bULL, 0x004fe20003fdd000ULL, 0x0000010026317824ULL, 0x002fe200078e00ffULL,
0x000000e200b97245ULL, 0x000fc8000020d400ULL, 0x00000001b9b90812ULL, 0x000fe200078efcffULL,
0x0000003300d57306ULL, 0x000e620000005400ULL, 0x0000000185852812ULL, 0x010fe400078efcffULL,
0x00000018ff317819ULL, 0x000fca0000011431ULL, 0x000000d700e17306ULL, 0x000ff00000209400ULL,
0x000000d700e47306ULL, 0x000ea20000205400ULL, 0x000000d5d600720bULL, 0x002fe40003f1d000ULL,
0x000000dc00d57245ULL, 0x000fca000020d400ULL, 0x000000c300cd7306ULL, 0x000ff00000209400ULL,
0x000000c300d07306ULL, 0x0003220000205400ULL, 0x000000e4e100720bULL, 0x004fce0003f5d000ULL,
0x00000033007f7306ULL, 0x000ea2000000d400ULL, 0x000000c300c37245ULL, 0x002fce000020d400ULL,
0x000000cf00d97306ULL, 0x000fe20000209400ULL, 0x000000d0cd00720bULL, 0x010fe40003fbd000ULL,
0x000000d700d07245ULL, 0x000fc8000020d400ULL, 0x00000001d0d02812ULL, 0x000fe200078efcffULL,
0x000000cf00da7306ULL, 0x0003220000205400ULL, 0x000000017f7f0812ULL, 0x004fca00078efcffULL,
0x00000001c3c35812ULL, 0x000fe400078efcffULL, 0x000000c600d37306ULL, 0x000fe20000209400ULL,
0x000000cf00cf7245ULL, 0x002fce000020d400ULL, 0x000000c600d47306ULL, 0x0002a20000205400ULL,
0x000000dad900720bULL, 0x010fce0003f5d000ULL, 0x0000003200807306ULL, 0x000962000000d400ULL,
0x000000c600c67245ULL, 0x002fca000020d400ULL, 0x00000001cfcf2812ULL, 0x000fe400078efcffULL,
0x000000be00cb7306ULL, 0x000fe20000209400ULL, 0x000000d4d300720bULL, 0x004fe20003f1d000ULL,
0x0001000026327824ULL, 0x010fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x000000be00ca7306ULL, 0x0002a20000205400ULL, 0x0000000180806812ULL, 0x020fca00078efcffULL,
0x00000001c6c60812ULL, 0x000fe400078efcffULL, 0x000000c400cc7306ULL, 0x000fe20000209400ULL,
0x000000be00be7245ULL, 0x002fce000020d400ULL, 0x000000c400d17306ULL, 0x000e620000205400ULL,
0x000000cacb00720bULL, 0x004fce0003fdd000ULL, 0x0000002500bc7306ULL, 0x000fec0000009400ULL,
0x00000001bebe6812ULL, 0x000fe400078efcffULL, 0x0000002500bd7306ULL, 0x000ea20000005400ULL,
0x000000d1cc00720bULL, 0x002fe40003fbd000ULL, 0x000000cfbecf723eULL, 0x000fca00000010ffULL,
0x000000a500ba7306ULL, 0x000ff00000209400ULL, 0x000000a500b77306ULL, 0x000e620000205400ULL,
0x000000bdbc00720bULL, 0x004fce0003f5d000ULL, 0x000000b800b57306ULL, 0x000ff00000209400ULL,
0x000000b800b67306ULL, 0x0005220000205400ULL, 0x000000b7ba00720bULL, 0x002fe40003f1d000ULL,
0x000000c400b77245ULL, 0x000fe2000020d400ULL, 0x000001002dc47824ULL, 0x000fc600078e00ffULL,
0x00000001b7b75812ULL, 0x000fe200078efcffULL, 0x000000c500c77306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x004fce000020d400ULL, 0x000000c500ce7306ULL, 0x0002a20000205400ULL,
0x000000b6b500720bULL, 0x010fe40003f9d000ULL, 0x00000018ffb57819ULL, 0x000fca00000114e9ULL,
0x000000c200c87306ULL, 0x000fe20000209400ULL, 0x000000c500c57245ULL, 0x002fca000020d400ULL,
0x00000001b8b84812ULL, 0x000fe400078efcffULL, 0x000000c200c97306ULL, 0x0003220000205400ULL,
0x000000cec700720bULL, 0x004fe20003fdd000ULL, 0x000100002dc77824ULL, 0x000fca00078e00ffULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x00000025007c7306ULL, 0x000ea2000000d400ULL,
0x000000c200c27245ULL, 0x002fca000020d400ULL, 0x00000001c5c56812ULL, 0x000fe400078efcffULL,
0x0000002700ae7306ULL, 0x000fe20000009400ULL, 0x000000c9c800720bULL, 0x010fce0003fbd000ULL,
0x0000002700a77306ULL, 0x000e620000005400ULL, 0x000000017c7c2812ULL, 0x004fc800078efcffULL,
0x0000007cb7b7723eULL, 0x000fe400000010ffULL, 0x00000001c2c25812ULL, 0x000fe200078efcffULL,
0x000000dc00e37306ULL, 0x000ff00000209400ULL, 0x000000dc00e67306ULL, 0x000ea20000205400ULL,
0x000000a7ae00720bULL, 0x002fc40003f5d000ULL, 0x000000a500ae7245ULL, 0x000fe2000020d400ULL,
0x000001002ea57824ULL, 0x000fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fe400000114b3ULL,
0x00000001aeae0812ULL, 0x000fe200078efcffULL, 0x0000002400c07306ULL, 0x000fe20000009400ULL,
0x00000018ffa57819ULL, 0x000fe400000114a5ULL, 0x000000b9deb3723eULL, 0x000fe400000010ffULL,
0x000000c5aeae723eULL, 0x000fc600000010ffULL, 0x0000002400c17306ULL, 0x000fe20000005400ULL,
0x000000e6e300720bULL, 0x004fce0003f9d000ULL, 0x00000024007d7306ULL, 0x000fec000000d400ULL,
0x00000001d5d54812ULL, 0x000fe400078efcffULL, 0x0000002600b07306ULL, 0x000fe40000009400ULL,
0x00000080d580723eULL, 0x000fcc00000010ffULL, 0x0000002600ab7306ULL, 0x000ff00000005400ULL,
0x0000002600797306ULL, 0x000ff0000000d400ULL, 0x0000009a00ac7306ULL, 0x000ff00000209400ULL,
0x0000009a00a97306ULL, 0x000e700000205400ULL, 0x0000003100247306ULL, 0x000ff00000209400ULL,
0x0000003100257306ULL, 0x000ea20000205400ULL, 0x000000a9ac00720bULL, 0x002fce0003fdd000ULL,
0x0000003000bf7306ULL, 0x000ff00000209400ULL, 0x0000003000267306ULL, 0x0003220000205400ULL,
0x000000252400720bULL, 0x004fce0003f1d000ULL, 0x0000002700737306ULL, 0x000562000000d400ULL,
0x0000003000307245ULL, 0x002fce000020d400ULL, 0x00000028009b7306ULL, 0x000e620000005400ULL,
0x00009910a4277816ULL, 0x004fe200000000ffULL, 0x0000010028a47824ULL, 0x000fe200078e00ffULL,
0x00000026bf00720bULL, 0x010fe20003fbd000ULL, 0x000001002cbf7824ULL, 0x000fe200078e00ffULL,
0x000000ff2700720cULL, 0x000fe20003f65270ULL, 0x000001002b277824ULL, 0x000fe200078e00ffULL,
0x00000018ffa47819ULL, 0x000fe200000114a4ULL, 0x0000002800727306ULL, 0x000522000000d400ULL,
0x0000000173732812ULL, 0x020fe400078efcffULL, 0x00000018ffa97819ULL, 0x000fc40000011427ULL,
0x009800005224783bULL, 0x000f660000000200ULL, 0x00000029008e7306ULL, 0x000fe20000009400ULL,
0x000001002a287824ULL, 0x004fe200078e00ffULL, 0x0000000130305812ULL, 0x000fe400078efcffULL,
0x0000009b8c00720bULL, 0x002fe40003f5d000ULL, 0x00000018ffbc7819ULL, 0x000fe40000011428ULL,
0x0000002900897306ULL, 0x000fe20000005400ULL, 0x0000009f008c7245ULL, 0x000fc4000020d400ULL,
0x000000bc00877245ULL, 0x000fe4000020d400ULL, 0x00000073309b723eULL, 0x000fc600000010ffULL,
0x0000002900007306ULL, 0x0003e2000000d400ULL, 0x0000000172722812ULL, 0x010fce00078efcffULL,
0x000000d200d87306ULL, 0x000fe20000209400ULL, 0x0001000029297824ULL, 0x002fca00078e00ffULL,
0x00000018ffca7819ULL, 0x000fe40000011429ULL, 0x000000d200dd7306ULL, 0x0002a20000205400ULL,
0x000000932424b231ULL, 0x0a8fe400003400ffULL, 0x000000932626b231ULL, 0x000fca00003400ffULL,
0x0000002a00997306ULL, 0x000fe20000009400ULL, 0x000000d200d27245ULL, 0x002fe2000020d400ULL,
0x0000008a2525b231ULL, 0x080fe400003400ffULL, 0x0000008a2727b231ULL, 0x000fc800003400ffULL,
0x0000002a00887306ULL, 0x000fe20000005400ULL, 0x000000ddd800720bULL, 0x004fce0003f9d000ULL,
0x0000002a006c7306ULL, 0x000fec000000d400ULL, 0x00000001d2d24812ULL, 0x000fe400078efcffULL,
0x0000002b00a27306ULL, 0x000fe20000009400ULL, 0x000000c1c000720bULL, 0x000fe20003f9d000ULL,
0x000100002cc17824ULL, 0x000fe200078e00ffULL, 0x000000d2c3ce723eULL, 0x000fca00000010ffULL,
0x0000002b008d7306ULL, 0x000e6c0000005400ULL, 0x000000017d7d4812ULL, 0x000fe400078efcffULL,
0x0000002b006b7306ULL, 0x0004e2000000d400ULL, 0x000000abb000720bULL, 0x000fce0003f9d000ULL,
0x000000db00d67306ULL, 0x000fe20000209400ULL, 0x009800004728783bULL, 0x004ea20000000200ULL,
0x0000008da200720bULL, 0x002fe40003f5d000ULL, 0x00000086008d7245ULL, 0x000fe4000020d400ULL,
0x0000000179794812ULL, 0x000fe400078efcffULL, 0x000000db00cb7306ULL, 0x00032e0000205400ULL,
0x000000016b6b2812ULL, 0x008fe200078efcffULL, 0x0000009d008f7306ULL, 0x000fe20000209400ULL,
0x000000db00db7245ULL, 0x002fce000020d400ULL, 0x0000009d00967306ULL, 0x0003f00000205400ULL,
0x000000bc00ba7306ULL, 0x000fe20000209400ULL, 0x0000009d009d7245ULL, 0x002fce000020d400ULL,
0x000000bc00ab7306ULL, 0x000e620000205400ULL, 0x000000932828b231ULL, 0x084fe400003400ffULL,
0x000000932a2ab231ULL, 0x000fe400003400ffULL, 0x0000008a2929b231ULL, 0x080fe400003400ffULL,
0x0000008a2b2bb231ULL, 0x000fe200003400ffULL, 0x000000cbd600720bULL, 0x010fe20003f7d000ULL,
0x0000002d009e7306ULL, 0x000fe20000009400ULL, 0x00000018ff8a7819ULL, 0x000fc800000114c4ULL,
0x000000b22808723cULL, 0x040fe60000041808ULL, 0x0000002d00957306ULL, 0x000fe80000005400ULL,
0x00000001dbdb3812ULL, 0x000fe200078efcffULL, 0x000000ce2810723cULL, 0x000fe20000041810ULL,
0x000000abba00720bULL, 0x002fe40003f7d000ULL, 0x0000002d00667306ULL, 0x0003f0000000d400ULL,
0x000000a600a37306ULL, 0x000fe20000209400ULL, 0x0000009a002d7245ULL, 0x002fc4000020d400ULL,
0x00000031009a7245ULL, 0x000fe4000020d400ULL, 0x000000012d2d6812ULL, 0x000fe400078efcffULL,
0x000000968f00720bULL, 0x000fe20003fdd000ULL, 0x000000a600aa7306ULL, 0x0002a20000205400ULL,
0x000000019a9a0812ULL, 0x000fe400078efcffULL, 0x0000000187873812ULL, 0x000fe400078efcffULL,
0x0000009800317245ULL, 0x000fc4000020d400ULL, 0x000000c22daf723eULL, 0x000fe200000010ffULL,
0x0000003200337306ULL, 0x000fe20000209400ULL, 0x000000a600a67245ULL, 0x002fe4000020d400ULL,
0x000000799a9a723eULL, 0x000fe400000010ffULL, 0x000000019d9d6812ULL, 0x000fe200078efcffULL,
0x000000ae2818723cULL, 0x000fe20000041818ULL, 0x000000889900720bULL, 0x000fe20003fdd000ULL,
0x0000003200a87306ULL, 0x0002e20000205400ULL, 0x000000aaa300720bULL, 0x004fc40003fbd000ULL,
0x00000018ff887819ULL, 0x000fe400000114bfULL, 0x0000008a002d7245ULL, 0x000fe2000020d400ULL,
0x0000009a281c723cULL, 0x000fe4000004181cULL, 0x0000009800917306ULL, 0x000fe20000209400ULL,
0x0000003200327245ULL, 0x002fc6000020d400ULL, 0x000000016c6c6812ULL, 0x000fe400078efcffULL,
0x00000001a6a65812ULL, 0x000fe400078efcffULL, 0x00000098009c7306ULL, 0x000e620000205400ULL,
0x000000a83300720bULL, 0x008fe40003f1d000ULL, 0x000000a400337245ULL, 0x000fca000020d400ULL,
0x000000a900b07306ULL, 0x000fec0000209400ULL, 0x0000000132320812ULL, 0x000fe400078efcffULL,
0x000000a900bd7306ULL, 0x000ea20000205400ULL, 0x0000009c9100720bULL, 0x002fe40003f9d000ULL,
0x000000898e00720bULL, 0x000fc40003f1d000ULL, 0x000000b500897245ULL, 0x000fe4000020d400ULL,
0x000000329d30723eULL, 0x000fe200000010ffULL, 0x000000a400ad7306ULL, 0x000fec0000209400ULL,
0x0000000131314812ULL, 0x000fe400078efcffULL, 0x000000a400b67306ULL, 0x000e620000205400ULL,
0x000000bdb000720bULL, 0x004fc40003f7d000ULL, 0x0000000100000812ULL, 0x000fe400078efcffULL,
0x000000a63131723eULL, 0x000fc600000010ffULL, 0x0000007e00817306ULL, 0x000fe80000209400ULL,
0x000000302820723cULL, 0x000fe80000041820ULL, 0x0000007e00827306ULL, 0x0004e20000205400ULL,
0x000000b6ad00720bULL, 0x002fe40003fbd000ULL, 0x0000007dc6b6723eULL, 0x000fca00000010ffULL,
0x000000b500bb7306ULL, 0x000fe20000209400ULL, 0x0000007e007e7245ULL, 0x004fe2000020d400ULL,
0x000000b62814723cULL, 0x000fe80000041814ULL, 0x0000000133335812ULL, 0x000fe400078efcffULL,
0x000000b500e07306ULL, 0x0002a20000205400ULL, 0x000000828100720bULL, 0x008fe40003fdd000ULL,
0x000000a900827245ULL, 0x000fc4000020d400ULL, 0x0000007fd081723eULL, 0x000fe400000010ffULL,
0x0000000182823812ULL, 0x000fe200078efcffULL, 0x000000a700ac7306ULL, 0x000fe20000209400ULL,
0x00000085b8b5723eULL, 0x002fe400000010ffULL, 0x000000b1007f7245ULL, 0x000fe2000020d400ULL,
0x00000080280c723cULL, 0x000fe2000004180cULL, 0x000000723372723eULL, 0x000fe400000010ffULL,
0x000000017e7e6812ULL, 0x000fe200078efcffULL, 0x000000a7008f7306ULL, 0x0002e20000205400ULL,
0x000000e0bb00720bULL, 0x004fc60003f9d000ULL, 0x000000b42804723cULL, 0x000fe80000041804ULL,
0x0000009f00a17306ULL, 0x000fe20000209400ULL, 0x000000a700a77245ULL, 0x002fe4000020d400ULL,
0x000000a5002a7245ULL, 0x000fe4000020d400ULL, 0x0000006c8728723eULL, 0x000fe400000010ffULL,
0x0000000189894812ULL, 0x000fe200078efcffULL, 0x0000009f00947306ULL, 0x000e620000205400ULL,
0x0000008fac00720bULL, 0x008fc40003f7d000ULL, 0x000000008973723eULL, 0x000fe400000010ffULL,
0x0000006d00007245ULL, 0x000fe4000020d400ULL, 0x0000006b8229723eULL, 0x000fe200000010ffULL,
0x0000008600a07306ULL, 0x000fe80000209400ULL, 0x000000722404723cULL, 0x000fe40000041804ULL,
0x00000001a7a73812ULL, 0x000fc400078efcffULL, 0x0000008600977306ULL, 0x000ea20000205400ULL,
0x00000094a100720bULL, 0x002fe40003fbd000ULL, 0x000000a77e7e723eULL, 0x000fe200000010ffULL,
0x00000028240c723cULL, 0x000fe8000004180cULL, 0x00000078007a7306ULL, 0x000fec0000209400ULL,
0x000000018c8c5812ULL, 0x000fc400078efcffULL, 0x00000078007b7306ULL, 0x0002e20000205400ULL,
0x00000097a000720bULL, 0x004fe40003f1d000ULL, 0x000000db8c8c723eULL, 0x000fca00000010ffULL,
0x000000ca00cd7306ULL, 0x000fe20000209400ULL, 0x0000007800787245ULL, 0x002fca000020d400ULL,
0x000000018d8d0812ULL, 0x000fe400078efcffULL, 0x000000ca00c07306ULL, 0x0002a20000205400ULL,
0x0000007b7a00720bULL, 0x008fce0003f7d000ULL, 0x0000008800967306ULL, 0x000fe20000209400ULL,
0x000000ca00ca7245ULL, 0x002fca000020d400ULL, 0x0000000178783812ULL, 0x000fe400078efcffULL,
0x0000008800937306ULL, 0x0002e20000205400ULL, 0x000000c0cd00720bULL, 0x004fce0003f9d000ULL,
0x0000002c008b7306ULL, 0x000fe20000009400ULL, 0x0000008800887245ULL, 0x002fca000020d400ULL,
0x00000001caca4812ULL, 0x000fe400078efcffULL, 0x0000002c00907306ULL, 0x000e620000005400ULL,
0x000000939600720bULL, 0x008fe40003fdd000ULL, 0x000000959e00720bULL, 0x000fe40003f9d000ULL,
0x000000ca8d8d723eULL, 0x000fc600000010ffULL, 0x0000002e00847306ULL, 0x000fe80000009400ULL,
0x0000008c2408723cULL, 0x000fe40000041808ULL, 0x0000000188886812ULL, 0x000fe400078efcffULL,
0x0000002e00837306ULL, 0x000ea20000005400ULL, 0x000000908b00720bULL, 0x002fe40003fbd000ULL,
0x00000018ff8b7819ULL, 0x000fc400000114c1ULL, 0x0000000166664812ULL, 0x000fc600078efcffULL,
0x000000b100917306ULL, 0x000ff00000209400ULL, 0x000000b1008e7306ULL, 0x000e620000205400ULL,
0x000000838400720bULL, 0x004fce0003f1d000ULL, 0x0000006d00747306ULL, 0x000ff00000209400ULL,
0x0000006d00757306ULL, 0x000ea20000205400ULL, 0x0000008e9100720bULL, 0x002fce0003f5d000ULL,
0x0000008a00947306ULL, 0x000fec0000209400ULL, 0x000000017f7f2812ULL, 0x000fe400078efcffULL,
0x0000008a00977306ULL, 0x000e620000205400ULL, 0x000000757400720bULL, 0x004fe40003f7d000ULL,
0x0000007f787f723eULL, 0x000fca00000010ffULL, 0x0000002f00777306ULL, 0x000fe40000009400ULL,
0x0000007e2410723cULL, 0x000fe80000041810ULL, 0x0000000100003812ULL, 0x000fe400078efcffULL,
0x0000002f00767306ULL, 0x000ea20000005400ULL, 0x000000979400720bULL, 0x002fce0003fdd000ULL,
0x0000002c006f7306ULL, 0x0002ec000000d400ULL, 0x000000012d2d6812ULL, 0x000fe400078efcffULL,
0x0000006800717306ULL, 0x000fe20000209400ULL, 0x000001002f2c7824ULL, 0x002fe200078e00ffULL,
0x000000767700720bULL, 0x004fc40003f5d000ULL, 0x000000662d89723eULL, 0x000fe400000010ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001142cULL, 0x0000006800707306ULL, 0x0002a20000205400ULL,
0x000000016f6f5812ULL, 0x008fc800078efcffULL, 0x0000006f8888723eULL, 0x000fc600000010ffULL,
0x0000008b00867306ULL, 0x000fe20000209400ULL, 0x0000006800687245ULL, 0x002fc6000020d400ULL,
0x000000882414723cULL, 0x000fe80000041814ULL, 0x0000008b00837306ULL, 0x0002e20000205400ULL,
0x000000707100720bULL, 0x004fce0003fbd000ULL, 0x000000c700847306ULL, 0x000fe20000209400ULL,
0x0000008b008b7245ULL, 0x002fca000020d400ULL, 0x0000000168685812ULL, 0x000fe400078efcffULL,
0x000000c700857306ULL, 0x0002a20000205400ULL, 0x000000838600720bULL, 0x008fce0003fdd000ULL,
0x000000a5007c7306ULL, 0x000fe20000209400ULL, 0x000000c700c77245ULL, 0x002fca000020d400ULL,
0x000000018b8b6812ULL, 0x000fe400078efcffULL, 0x000000a5007b7306ULL, 0x000e620000205400ULL,
0x000000858400720bULL, 0x004fe40003f9d000ULL, 0x0000008b0028723eULL, 0x000fca00000010ffULL,
0x0000002e00657306ULL, 0x0004ec000000d400ULL, 0x00000001c7c74812ULL, 0x000fe400078efcffULL,
0x0000002f00647306ULL, 0x000962000000d400ULL, 0x000100002e2e7824ULL, 0x004fe200078e00ffULL,
0x0000007b7c00720bULL, 0x002fc40003f7d000ULL, 0x000000c76829723eULL, 0x000fe400000010ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000006300697306ULL, 0x000fe20000209400ULL,
0x000100002f2f7824ULL, 0x010fe200078e00ffULL, 0x0000000165650812ULL, 0x008fe200078efcffULL,
0x000000282418723cULL, 0x000fe60000041818ULL, 0x00000018ff2f7819ULL, 0x000fc4000001142fULL,
0x00000063006a7306ULL, 0x0002a20000205400ULL, 0x000000012a2a3812ULL, 0x000fe400078efcffULL,
0x0000000164642812ULL, 0x020fe400078efcffULL, 0x000000652a2a723eULL, 0x000fc600000010ffULL,
0x0000006200677306ULL, 0x000fe20000209400ULL, 0x0000006300637245ULL, 0x002fce000020d400ULL,
0x00000062006e7306ULL, 0x0002e20000205400ULL, 0x0000006a6900720bULL, 0x004fce0003fdd000ULL,
0x0000007a00767306ULL, 0x000fe20000209400ULL, 0x0000006200627245ULL, 0x002fca000020d400ULL,
0x0000000163636812ULL, 0x000fe400078efcffULL, 0x0000007a00757306ULL, 0x000e620000205400ULL,
0x0000006e6700720bULL, 0x008fce0003f9d000ULL, 0x0000002e002c7306ULL, 0x000fec0000209400ULL,
0x0000000162624812ULL, 0x000fe400078efcffULL, 0x0000002e002b7306ULL, 0x0004e20000205400ULL,
0x000000757600720bULL, 0x002fce0003fbd000ULL, 0x0000002f00307306ULL, 0x000fe20000209400ULL,
0x0000002e002e7245ULL, 0x004fce000020d400ULL, 0x0000002f00317306ULL, 0x0002a20000205400ULL,
0x0000002b2c00720bULL, 0x008fe40003f7d000ULL, 0x0000007a002b7245ULL, 0x000fc8000020d400ULL,
0x000000012b2b5812ULL, 0x000fe400078efcffULL, 0x0000002f002f7245ULL, 0x002fe4000020d400ULL,
0x000000642b2b723eULL, 0x000fc600000010ffULL, 0x000000012e2e3812ULL, 0x000fe400078efcffULL,
0x000000313000720bULL, 0x004fe40003f1d000ULL, 0x0000002e632e723eULL, 0x000fe200000010ffULL,
0x0000002a241c723cULL, 0x000ff4000004181cULL, 0x000000012f2f0812ULL, 0x000fc800078efcffULL,
0x0000002f622f723eULL, 0x000fce00000010ffULL, 0x0000002e2420723cULL, 0x000fe20000041820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200038247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008049007810ULL, 0x000fe20007ffe0ffULL, 0x00f6900053ff7f8cULL, 0x0007e2000c80043fULL,
0x0000000137637812ULL, 0x000fe400078ec0ffULL, 0x000000030000720cULL, 0x000fda0003f06070ULL,
0x0000567000000947ULL, 0x000fea0003800000ULL, 0x0000040092007984ULL, 0x008ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240038007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x0000240038247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff487819ULL, 0x000fe20000011602ULL,
0x00000080ff637424ULL, 0x000fe200078e00ffULL, 0x00000003ff2d7819ULL, 0x000fe20000011641ULL,
0x000000005b0473c2ULL, 0x000ea200000e0000ULL, 0x0000000134267810ULL, 0x000fe20007ffe0ffULL,
0x0000002048007824ULL, 0x000fe200078e0249ULL, 0x000000042d317810ULL, 0x000fe40007ffe0ffULL,
0x000000352600720cULL, 0x000fe40003f06070ULL, 0x000000c000007810ULL, 0x000fc40007ffe0ffULL,
0x000000082d337810ULL, 0x000fe40007ffe0ffULL, 0x0000000003257217ULL, 0x000fe20007800000ULL,
0x000062003f277a24ULL, 0x000fe200078e0200ULL, 0x0000000c2d2f7810ULL, 0x000fc60007ffe0ffULL,
0x0000000125007824ULL, 0x000fe200078e0a00ULL, 0x0000002d27247210ULL, 0x140fe40007ffe03eULL,
0x0000003327267210ULL, 0x140fe40007ffe03eULL, 0x0000002000297807ULL, 0x000fe20000000000ULL,
0x00005e0024247625ULL, 0x000fe200078e0063ULL, 0x0000002f27287210ULL, 0x000fe40007ffe03eULL,
0x000000293e297217ULL, 0x000fe40007800000ULL, 0x00000043242a7210ULL, 0x000fc40007f1e0ffULL,
0x0000003127247210ULL, 0x100fe20007ffe03eULL, 0x0000000129007824ULL, 0x000fe400078e0a3eULL,
0x000000ffff2b7224ULL, 0x000fe400000e0625ULL, 0x00005e0024247625ULL, 0x080fe200078e0063ULL,
0x000000002d00720cULL, 0x080fe40003f46070ULL, 0x000000003100720cULL, 0x000fe20003f06070ULL,
0x00005e0026267625ULL, 0x000fe200078e0063ULL, 0x0000004324247210ULL, 0x000fc40007f7e0ffULL,
0x000000002f00720cULL, 0x000fe20003f86070ULL, 0x00005e0028287625ULL, 0x000fe200078e0063ULL,
0x0000004326267210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff257224ULL, 0x000fe200018e0625ULL,
0x000000003300720cULL, 0x000fe20003f66070ULL, 0x000000ffff277224ULL, 0x000fe200028e0627ULL,
0x0000004328287210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a4a7faeULL, 0x0007e8000d101c46ULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x00000000244b7faeULL, 0x0007ea000c101c46ULL, 0x00000000264c7faeULL, 0x0007e8000d901c46ULL,
0x00000000284d7faeULL, 0x0007e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x004fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000005b4a7f8cULL, 0x0084e8000c80043fULL,
0x0000040056007984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480040247f8cULL, 0x000fe2000c80043fULL,
0x8000000000ff7812ULL, 0x010fc60007844861ULL, 0x00f64c0040277984ULL, 0x000f240000000800ULL,
0x8000000027ff7812ULL, 0x010fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x000964000021f000ULL,
0x3fa0000000007823ULL, 0x010fe200000100ffULL, 0x000000260000735dULL, 0x020fe20003800000ULL,
0x00f64c0040277984ULL, 0x000f240000000800ULL, 0x8000000027ff7812ULL, 0x010fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010043257810ULL, 0x000fca0007ffe042ULL,
0x0000000144257824ULL, 0x000fca00078e0225ULL, 0x00f0000025277984ULL, 0x000f280000000800ULL,
0x00f2000025007984ULL, 0x0002a20000000800ULL, 0x0000003a2700720bULL, 0x010fe20003f1d000ULL,
0x0000ea027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x002fc800000e0100ULL,
0x0000ffff24267812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ffae7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000202257811ULL, 0x000fe400078ff0ffULL, 0x0000003a2700720bULL, 0x000fe40003f14000ULL,
0x000000022500720cULL, 0x000fe20003f65270ULL, 0x0000e9c27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x000000273a287209ULL, 0x000fe20007810000ULL,
0x000000800229b824ULL, 0x000fc800078e0243ULL, 0x00000001442bb824ULL, 0x000fe200078e0229ULL,
0x800000283a257221ULL, 0x000fe20000010000ULL, 0x0000ffff24297812ULL, 0x000fc600078e3cffULL,
0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL, 0x00f400282b00b388ULL, 0x0003e20000000800ULL,
0x0000002926ff7212ULL, 0x000fe4000780c0ffULL, 0x00000025002a7308ULL, 0x000f220000000800ULL,
0x00000002ff297819ULL, 0x000fe20000011641ULL, 0x0000002a39397220ULL, 0x010fe20000410000ULL,
0x0000e9427f007947ULL, 0x000fec000b800000ULL, 0x00001f292a247589ULL, 0x00232400000e0000ULL,
0x0000002404047220ULL, 0x090fe20000410000ULL, 0x0000002405057220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x000000240c0c7220ULL, 0x080fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002420207220ULL, 0x080fe20000410000ULL, 0x0000002421217220ULL, 0x000fe20000410000ULL,
0x0000e8927f007947ULL, 0x000fea000b800000ULL, 0x00001f462a247589ULL, 0x00086400000e0000ULL,
0x8000002827270221ULL, 0x100fe20000010000ULL, 0x00000001ffae7807ULL, 0x000fe20000000000ULL,
0x0000002406067220ULL, 0x082fe20000410000ULL, 0x0000002407077220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL, 0x000000240a0a7220ULL, 0x080fe20000410000ULL,
0x000000240b0b7220ULL, 0x080fe20000410000ULL, 0x000000240e0e7220ULL, 0x080fe20000410000ULL,
0x0000002700360308ULL, 0x000e620000000800ULL, 0x000000240f0f7220ULL, 0x080fe20000410000ULL,
0x0000002412127220ULL, 0x080fe20000410000ULL, 0x0000002413137220ULL, 0x080fe20000410000ULL,
0x0000002416167220ULL, 0x080fe20000410000ULL, 0x0000002417177220ULL, 0x080fe20000410000ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x000000241e1e7220ULL, 0x080fe20000410000ULL, 0x000000241f1f7220ULL, 0x080fe20000410000ULL,
0x0000002422227220ULL, 0x080fe20000410000ULL, 0x0000002423237220ULL, 0x000fe20000410000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0028ULL, 0x0000000036000220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000003900397221ULL, 0x004fe20000010000ULL, 0x000000f000002947ULL, 0x000fea0003800000ULL,
0x0000000854257812ULL, 0x000fe400078ec0ffULL, 0xfffffff03d007812ULL, 0x000fca00078ec0ffULL,
0x0000000100257824ULL, 0x000fca00078e0225ULL, 0x00f6ac0025007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804861ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x004fe40003800000ULL, 0x00f6ac0025247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fc40007804861ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff2b7819ULL, 0x000fe40000011641ULL, 0x00000036ff24723eULL, 0x000fe400000010ffULL,
0x000000182b007810ULL, 0x040fe40007ffe0ffULL, 0x000000102b267810ULL, 0x000fe40007ffe0ffULL,
0x00005410242a7816ULL, 0x010fe20000000024ULL, 0x0000e5f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2b2a7d7589ULL, 0x0002a400000e0000ULL, 0x0000e6327f007947ULL, 0x000fea000b800000ULL,
0x00001f462a7c7589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0026ULL, 0x000077f000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000ee7000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0000ULL, 0x0000785000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000ee1000007944ULL, 0x01cfea0003c00000ULL, 0x0000100002287824ULL, 0x000fe200078e00ffULL,
0x0000100060317812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00009910aeae7816ULL, 0x000fe400000000ffULL, 0xffffe00028287812ULL, 0x000fe400078ec0ffULL,
0x0000b0003c007810ULL, 0x000fc40007ffe031ULL, 0x0000b00028317810ULL, 0x000fe40007ffe031ULL,
0x000000ffae00720cULL, 0x000fe20003f65270ULL, 0x000000104f247824ULL, 0x100fe400078e0200ULL,
0x000000104e287824ULL, 0x100fe400078e0231ULL, 0x0000001050317824ULL, 0x000fe400078e0231ULL,
0x000000002424783bULL, 0x000f620000004200ULL, 0x00000010512c7824ULL, 0x002fc600078e0200ULL,
0x000000002828783bULL, 0x014e680000004200ULL, 0x000000003130783bULL, 0x000ea80000004200ULL,
0x000000002c2c783bULL, 0x000f220000004200ULL, 0x00000024007e7306ULL, 0x020fe20000009400ULL,
0x00000018ff9c7819ULL, 0x000fe20000011424ULL, 0x00000100248c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011425ULL, 0x0000010028e07824ULL, 0x042fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe20000011428ULL, 0x0001000028dc7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc07819ULL, 0x000fe20000011429ULL, 0x0000002800db7306ULL, 0x000fe20000009400ULL,
0x00000018ffe07819ULL, 0x000fe200000114e0ULL, 0x0001000029d97824ULL, 0x000fe200078e00ffULL,
0x00000018ffdc7819ULL, 0x000fe200000114dcULL, 0x0001000024a37824ULL, 0x000fe200078e00ffULL,
0x00000018ffb17819ULL, 0x004fe20000011430ULL, 0x00000100259d7824ULL, 0x040fe200078e00ffULL,
0x00000018ffd97819ULL, 0x000fe200000114d9ULL, 0x0000002800d67306ULL, 0x000e620000005400ULL,
0x0001000025a87824ULL, 0x000fe200078e00ffULL, 0x00000018ffa57819ULL, 0x000fe20000011431ULL,
0x0000010033e87824ULL, 0x000fe200078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe2000001142aULL,
0x0000010032e77824ULL, 0x000fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe20000011433ULL,
0x0000010029d77824ULL, 0x000fe200078e00ffULL, 0x000000e000d57306ULL, 0x000fe20000209400ULL,
0x00000018ffb97819ULL, 0x000fe2000001142bULL, 0x0000010026a27824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe20000011432ULL, 0x00000100277b7824ULL, 0x000fe200078e00ffULL,
0x00000018ffd77819ULL, 0x000fc400000114d7ULL, 0x00000018ffe87819ULL, 0x000fe200000114e8ULL,
0x000000e000da7306ULL, 0x000ea20000205400ULL, 0x000000d6db00720bULL, 0x002fe20003f5d000ULL,
0x0001000033d67824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011426ULL,
0x0001000032db7824ULL, 0x000fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011427ULL,
0x000000d700ae7245ULL, 0x000fe2000020d400ULL, 0x000000c800cc7306ULL, 0x000fe20000209400ULL,
0x00000018ffa37819ULL, 0x000fc400000114a3ULL, 0x00000018ffa27819ULL, 0x000fe400000114a2ULL,
0x00000018ffd67819ULL, 0x000fe400000114d6ULL, 0x00000018ff657819ULL, 0x010fe2000001142cULL,
0x000000c800cb7306ULL, 0x000e620000205400ULL, 0x000000dad500720bULL, 0x004fe40003fdd000ULL,
0x00000018ffdb7819ULL, 0x000fe400000114dbULL, 0x00000018ff7b7819ULL, 0x000fc4000001147bULL,
0x00000018ff8c7819ULL, 0x000fe2000001148cULL, 0x00000028009a7306ULL, 0x000522000000d400ULL,
0x00000018ff9d7819ULL, 0x000fe4000001149dULL, 0x00000018ffa87819ULL, 0x000fe400000114a8ULL,
0x00000018ff607819ULL, 0x000fe4000001142dULL, 0x00000018ff4d7819ULL, 0x000fe2000001142eULL,
0x0000002900ca7306ULL, 0x000fe20000009400ULL, 0x000001002b287824ULL, 0x004fe200078e00ffULL,
0x000000cbcc00720bULL, 0x002fc40003fbd000ULL, 0x00000018ff4c7819ULL, 0x000fe4000001142fULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002900c97306ULL, 0x000fe20000005400ULL,
0x000000019a9a2812ULL, 0x010fce00078efcffULL, 0x000000dc00e17306ULL, 0x000ff00000209400ULL,
0x000000dc00e27306ULL, 0x000e700000205400ULL, 0x000000d900e57306ULL, 0x000ff00000209400ULL,
0x000000d900e67306ULL, 0x000ea20000205400ULL, 0x000000e2e100720bULL, 0x002fce0003f1d000ULL,
0x0000002400837306ULL, 0x000ff00000005400ULL, 0x0000002400687306ULL, 0x0003e2000000d400ULL,
0x000000e6e500720bULL, 0x004fce0003f5d000ULL, 0x0000003000bf7306ULL, 0x000fe20000009400ULL,
0x0000010030247824ULL, 0x002fca00078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000003000bc7306ULL, 0x000ff00000005400ULL, 0x0000003000757306ULL, 0x0003f0000000d400ULL,
0x000000c000c67306ULL, 0x000fe20000209400ULL, 0x0001000030307824ULL, 0x002fca00078e00ffULL,
0x00000018ffd57819ULL, 0x000fe20000011430ULL, 0x0001000031307824ULL, 0x040fe200078e00ffULL,
0x000000c000c77306ULL, 0x000ff00000205400ULL, 0x0000002500887306ULL, 0x000ff00000009400ULL,
0x0000002500857306ULL, 0x000ff00000005400ULL, 0x0000002500007306ULL, 0x0003f0000000d400ULL,
0x0000003100b77306ULL, 0x000fe20000009400ULL, 0x0000010031257824ULL, 0x002fca00078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000003100b87306ULL, 0x000ff00000005400ULL,
0x0000003100747306ULL, 0x0003f0000000d400ULL, 0x0000002900817306ULL, 0x000522000000d400ULL,
0x000000e000317245ULL, 0x002fc8000020d400ULL, 0x0000000131316812ULL, 0x000fe400078efcffULL,
0x000000c9ca00720bULL, 0x000fe20003fdd000ULL, 0x0000002a00c47306ULL, 0x000fe20000009400ULL,
0x00000018ffc97819ULL, 0x000fe20000011430ULL, 0x000001002a297824ULL, 0x004fe200078e00ffULL,
0x000000dc00307245ULL, 0x000fe4000020d400ULL, 0x0000009a319a723eULL, 0x000fe400000010ffULL,
0x0000000130300812ULL, 0x000fe200078efcffULL, 0x0000002a00c57306ULL, 0x000e620000005400ULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x0000008200317245ULL, 0x000fe4000020d400ULL,
0x0000000181816812ULL, 0x010fc600078efcffULL, 0x0000002b00c27306ULL, 0x000ff00000009400ULL,
0x0000002b00c37306ULL, 0x000ea20000005400ULL, 0x000000c5c400720bULL, 0x002fe20003f1d000ULL,
0x0001000026c47824ULL, 0x000fe200078e00ffULL, 0x000000c000c57245ULL, 0x000fe2000020d400ULL,
0x0001000027c07824ULL, 0x000fc800078e00ffULL, 0x0000002800d87306ULL, 0x000fe20000209400ULL,
0x00000018ffc07819ULL, 0x000fce00000114c0ULL, 0x0000002800dd7306ULL, 0x000fe20000205400ULL,
0x000000c3c200720bULL, 0x004fe40003fdd000ULL, 0x00000018ffc27819ULL, 0x000fe400000114e7ULL,
0x0000002900c37245ULL, 0x000fc6000020d400ULL, 0x0000003300b27306ULL, 0x000ff00000009400ULL,
0x0000003300af7306ULL, 0x000ff00000005400ULL, 0x00000033006b7306ULL, 0x0003f0000000d400ULL,
0x0000002b00777306ULL, 0x000522000000d400ULL, 0x000000c800337245ULL, 0x002fc8000020d400ULL,
0x0000000133335812ULL, 0x000fe400078efcffULL, 0x000000c7c600720bULL, 0x000fe20003fbd000ULL,
0x000000bb00c17306ULL, 0x000fe20000209400ULL, 0x000100002b2b7824ULL, 0x004fe400078e00ffULL,
0x000001002dc67824ULL, 0x000fc600078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x000000bb00be7306ULL, 0x0002a20000205400ULL, 0x0000000177776812ULL, 0x010fe400078efcffULL,
0x00000018ffc67819ULL, 0x000fe400000114c6ULL, 0x00000001c5c55812ULL, 0x000fc600078efcffULL,
0x0000003200b37306ULL, 0x000fe20000009400ULL, 0x000000bb00bb7245ULL, 0x002fce000020d400ULL,
0x0000003200b47306ULL, 0x000fe20000005400ULL, 0x000000bec100720bULL, 0x004fe20003fbd000ULL,
0x000100002cc17824ULL, 0x000fe200078e00ffULL, 0x0000002800be7245ULL, 0x000fc8000020d400ULL,
0x00000018ffc17819ULL, 0x000fe200000114c1ULL, 0x0000003200717306ULL, 0x0003ec000000d400ULL,
0x00000001bbbb5812ULL, 0x000fe400078efcffULL, 0x000000b900bd7306ULL, 0x000fe20000209400ULL,
0x000000d900327245ULL, 0x002fc8000020d400ULL, 0x0000000132322812ULL, 0x000fe400078efcffULL,
0x000000ddd800720bULL, 0x000fe20003f5d000ULL, 0x000000b900ba7306ULL, 0x0002b00000205400ULL,
0x0000002b00d17306ULL, 0x000fe20000209400ULL, 0x000000b900b97245ULL, 0x002fc6000020d400ULL,
0x00000001bebe2812ULL, 0x000fc800078efcffULL, 0x0000002b00d27306ULL, 0x000e620000205400ULL,
0x000000babd00720bULL, 0x004fe40003fdd000ULL, 0x0000002b00ba7245ULL, 0x000fca000020d400ULL,
0x0000002a007a7306ULL, 0x00052c000000d400ULL, 0x00000001b9b96812ULL, 0x000fe400078efcffULL,
0x0000002500ce7306ULL, 0x000fe20000209400ULL, 0x000000d2d100720bULL, 0x002fe20003f5d000ULL,
0x000100002a2a7824ULL, 0x004fca00078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000002500d37306ULL, 0x000e620000205400ULL, 0x000000017a7a0812ULL, 0x010fe400078efcffULL,
0x000000bcbf00720bULL, 0x000fe20003f1d000ULL, 0x000001002cbf7824ULL, 0x000fe200078e00ffULL,
0x0000002a00bc7245ULL, 0x000fe4000020d400ULL, 0x00000001baba2812ULL, 0x000fe200078efcffULL,
0x000000d500da7306ULL, 0x000fe20000209400ULL, 0x000000b8b700720bULL, 0x000fc40003f5d000ULL,
0x0000002500b77245ULL, 0x000fe4000020d400ULL, 0x0000002400b87245ULL, 0x000fe4000020d400ULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x000000d500cb7306ULL, 0x0005220000205400ULL,
0x000000d3ce00720bULL, 0x002fe40003fbd000ULL, 0x0000000175750812ULL, 0x000fc600078efcffULL,
0x0000000174742812ULL, 0x000fe400078efcffULL, 0x000000b100b57306ULL, 0x000fe20000209400ULL,
0x000000d500d57245ULL, 0x004fe4000020d400ULL, 0x000000afb200720bULL, 0x000fe20003f5d000ULL,
0x000001002faf7824ULL, 0x000fe200078e00ffULL, 0x000000b100b27245ULL, 0x000fe4000020d400ULL,
0x00000001b7b75812ULL, 0x000fe200078efcffULL, 0x000000b100b67306ULL, 0x0002a20000205400ULL,
0x000000cbda00720bULL, 0x010fc40003fdd000ULL, 0x00000074b7b7723eULL, 0x000fe400000010ffULL,
0x00000018ffaf7819ULL, 0x000fc600000114afULL, 0x000000c900c87306ULL, 0x000fe20000209400ULL,
0x000000016b6b2812ULL, 0x000fe200078efcffULL, 0x000001002eb17824ULL, 0x002fe200078e00ffULL,
0x000000837e00720bULL, 0x000fe40003f5d000ULL, 0x000000a200837245ULL, 0x000fe4000020d400ULL,
0x00000001d5d56812ULL, 0x000fe200078efcffULL, 0x000000c900c77306ULL, 0x000e620000205400ULL,
0x000000b6b500720bULL, 0x004fe40003f1d000ULL, 0x000000d6007e7245ULL, 0x000fca000020d400ULL,
0x000000a500b07306ULL, 0x000fe20000209400ULL, 0x0000000168682812ULL, 0x000fca00078efcffULL,
0x00000001b2b20812ULL, 0x000fe400078efcffULL, 0x000000a500ad7306ULL, 0x000ea20000205400ULL,
0x000000c7c800720bULL, 0x002fe20003fbd000ULL, 0x000100002dc77824ULL, 0x000fca00078e00ffULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x000000d700e37306ULL, 0x000ff00000209400ULL,
0x000000d700e47306ULL, 0x000e620000205400ULL, 0x000000adb000720bULL, 0x004fc40003fdd000ULL,
0x000000c900ad7245ULL, 0x000fe4000020d400ULL, 0x000000c200b07245ULL, 0x000fe4000020d400ULL,
0x00000001adad5812ULL, 0x000fe200078efcffULL, 0x0000002600937306ULL, 0x000ff00000009400ULL,
0x0000002600847306ULL, 0x000fe20000005400ULL, 0x000000e4e300720bULL, 0x002fce0003f9d000ULL,
0x0000002600647306ULL, 0x000fec000000d400ULL, 0x00000001aeae4812ULL, 0x000fe400078efcffULL,
0x0000002700a07306ULL, 0x000ff00000009400ULL, 0x0000002700877306ULL, 0x000e700000005400ULL,
0x0000002700637306ULL, 0x000eb0000000d400ULL, 0x0000002900de7306ULL, 0x000fe20000209400ULL,
0x00000087a000720bULL, 0x002fce0003f5d000ULL, 0x0000002900df7306ULL, 0x000e6c0000205400ULL,
0x0000000163632812ULL, 0x004fe400078efcffULL, 0x000000c200267306ULL, 0x000ff00000209400ULL,
0x000000c200277306ULL, 0x000ea20000205400ULL, 0x000000dfde00720bULL, 0x002fce0003f9d000ULL,
0x000000e800287306ULL, 0x000fec0000209400ULL, 0x00000001c3c34812ULL, 0x000fe400078efcffULL,
0x000000e800297306ULL, 0x000e620000205400ULL, 0x000000272600720bULL, 0x004fe40003f1d000ULL,
0x0000007ac37a723eULL, 0x000fca00000010ffULL, 0x0000002a00cf7306ULL, 0x000fec0000209400ULL,
0x00000001b0b00812ULL, 0x000fe400078efcffULL, 0x0000002a00d47306ULL, 0x0005220000205400ULL,
0x000000292800720bULL, 0x002fce0003fbd000ULL, 0x0000002400d07306ULL, 0x000fe20000209400ULL,
0x00a000004728783bULL, 0x004e6e0000000200ULL, 0x0000002400cd7306ULL, 0x0005620000205400ULL,
0x000000d4cf00720bULL, 0x010fce0003f9d000ULL, 0x000000a300a67306ULL, 0x000fe20000209400ULL,
0x00a000005224783bULL, 0x004eaa0000000200ULL, 0x00000001bcbc4812ULL, 0x000fe400078efcffULL,
0x000000a300ab7306ULL, 0x0009e20000205400ULL, 0x000000cdd000720bULL, 0x020fe40003f9d000ULL,
0x000000bcbbbc723eULL, 0x000fca00000010ffULL, 0x00000097008d7306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x010fca000020d400ULL, 0x00000001b8b84812ULL, 0x000fe400078efcffULL,
0x0000009700947306ULL, 0x000f220000205400ULL, 0x0000007d2828b231ULL, 0x082fe200003400ffULL,
0x000000b4b300720bULL, 0x000fe20003f9d000ULL, 0x0000007d2a2ab231ULL, 0x000fe200003400ffULL,
0x000000a500b47245ULL, 0x000fe2000020d400ULL, 0x0000007c2929b231ULL, 0x080fe200003400ffULL,
0x00000018ffb37819ULL, 0x000fe200000114c4ULL, 0x0000007c2b2bb231ULL, 0x000fe200003400ffULL,
0x000000a200aa7306ULL, 0x000fe20000209400ULL, 0x00000001b4b46812ULL, 0x000fc800078efcffULL,
0x000000adb4ad723eULL, 0x000fe400000010ffULL, 0x0000000171714812ULL, 0x000fe200078efcffULL,
0x000000a200a77306ULL, 0x000e620000205400ULL, 0x0000007d2424b231ULL, 0x084fe200003400ffULL,
0x000000948d00720bULL, 0x010fe20003fdd000ULL, 0x0000007d2626b231ULL, 0x000fe200003400ffULL,
0x000000e800947245ULL, 0x000fe2000020d400ULL, 0x0000007c2525b231ULL, 0x080fe200003400ffULL,
0x0000008c007d7245ULL, 0x000fe2000020d400ULL, 0x0000007c2727b231ULL, 0x000fe200003400ffULL,
0x000000aba600720bULL, 0x000fe20003f7d000ULL, 0x0000002c00867306ULL, 0x000fe20000009400ULL,
0x0000000194945812ULL, 0x000fc400078efcffULL, 0x00000071b0b0723eULL, 0x000fca00000010ffULL,
0x0000002c00897306ULL, 0x000fe80000005400ULL, 0x00000001a3a33812ULL, 0x000fe400078efcffULL,
0x000000a7aa00720bULL, 0x002fe40003f7d000ULL, 0x0000002c00677306ULL, 0x000ff0000000d400ULL,
0x000000d600b57306ULL, 0x000fe60000209400ULL, 0x0000000183833812ULL, 0x000fca00078efcffULL,
0x000000d6002c7306ULL, 0x000e700000205400ULL, 0x00000095008b7306ULL, 0x000ff00000209400ULL,
0x0000009500967306ULL, 0x0005220000205400ULL, 0x0000002cb500720bULL, 0x002fc40003fbd000ULL,
0x00000030332c723eULL, 0x000fe400000010ffULL, 0x0000007b00307245ULL, 0x000fc6000020d400ULL,
0x000000db00bd7306ULL, 0x000fe20000209400ULL, 0x0000009500957245ULL, 0x004fca000020d400ULL,
0x000000017e7e5812ULL, 0x000fe400078efcffULL, 0x000000db00b67306ULL, 0x000e620000205400ULL,
0x000000968b00720bULL, 0x010fe40003f9d000ULL, 0x0000009700967245ULL, 0x000fe4000020d400ULL,
0x000000db008b7245ULL, 0x000fe4000020d400ULL, 0x0000000196966812ULL, 0x000fe200078efcffULL,
0x0000007b00987306ULL, 0x000fe20000209400ULL, 0x000000849300720bULL, 0x000fca0003fdd000ULL,
0x0000000195954812ULL, 0x000fe400078efcffULL, 0x0000007b00997306ULL, 0x0005220000205400ULL,
0x000000b6bd00720bULL, 0x002fe40003f1d000ULL, 0x000000bab9bd723eULL, 0x000fe400000010ffULL,
0x0000007e9595723eULL, 0x000fe400000010ffULL, 0x0000000164646812ULL, 0x000fe200078efcffULL,
0x0000008c008a7306ULL, 0x000fe20000209400ULL, 0x00000077be7b723eULL, 0x004fe200000010ffULL,
0x000000bc2810723cULL, 0x000fe20000041810ULL, 0x000000c000777245ULL, 0x000fc6000020d400ULL,
0x000000018b8b0812ULL, 0x000fe400078efcffULL, 0x0000008c008f7306ULL, 0x000e620000205400ULL,
0x000000999800720bULL, 0x010fe20003f7d000ULL, 0x0000007a280c723cULL, 0x000fe2000004180cULL,
0x000000858800720bULL, 0x000fca0003f1d000ULL, 0x0000007600797306ULL, 0x000fec0000209400ULL,
0x0000000130303812ULL, 0x000fe400078efcffULL, 0x0000007600787306ULL, 0x0005220000205400ULL,
0x0000008f8a00720bULL, 0x002fe40003fbd000ULL, 0x0000000100000812ULL, 0x000fca00078efcffULL,
0x0000009d00a17306ULL, 0x000fe20000209400ULL, 0x0000007600767245ULL, 0x004fca000020d400ULL,
0x000000017d7d5812ULL, 0x000fe400078efcffULL, 0x0000009d00a47306ULL, 0x0002a20000205400ULL,
0x000000787900720bULL, 0x010fe40003fdd000ULL, 0x000000687d68723eULL, 0x000fca00000010ffULL,
0x000000b300a57306ULL, 0x000fe20000209400ULL, 0x0000009d009d7245ULL, 0x002fca000020d400ULL,
0x0000000176766812ULL, 0x000fe400078efcffULL, 0x000000b300b67306ULL, 0x0003220000205400ULL,
0x000000a4a100720bULL, 0x004fce0003f9d000ULL, 0x0000009c009f7306ULL, 0x000fe20000209400ULL,
0x000000b300b37245ULL, 0x002fca000020d400ULL, 0x000000019d9d4812ULL, 0x000fe400078efcffULL,
0x0000009c008e7306ULL, 0x0002a20000205400ULL, 0x000000b6a500720bULL, 0x010fe40003f7d000ULL,
0x00000075b8b6723eULL, 0x000fe400000010ffULL, 0x00000018ff757819ULL, 0x000fe400000114b1ULL,
0x0000006b94b1723eULL, 0x000fe200000010ffULL, 0x0000007000737306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fe2000020d400ULL, 0x000000b62814723cULL, 0x000fe20000041814ULL,
0x0000008b9694723eULL, 0x000fc600000010ffULL, 0x00000001b3b33812ULL, 0x000fe400078efcffULL,
0x0000007000727306ULL, 0x0003220000205400ULL, 0x0000008e9f00720bULL, 0x004fe20003fbd000ULL,
0x000000b0281c723cULL, 0x000fe2000004181cULL, 0x000000b37676723eULL, 0x000fca00000010ffULL,
0x000000a800a97306ULL, 0x000fe20000209400ULL, 0x0000007000707245ULL, 0x002fe2000020d400ULL,
0x000000942820723cULL, 0x000fe80000041820ULL, 0x000000019c9c5812ULL, 0x000fe400078efcffULL,
0x000000a800ac7306ULL, 0x0002a20000205400ULL, 0x000000727300720bULL, 0x010fe40003f7d000ULL,
0x000000898600720bULL, 0x000fc40003fbd000ULL, 0x000000a39c9c723eULL, 0x000fc600000010ffULL,
0x000000bf00857306ULL, 0x000fe20000209400ULL, 0x000000a800a87245ULL, 0x002fca000020d400ULL,
0x0000000170703812ULL, 0x000fe400078efcffULL, 0x000000bf007c7306ULL, 0x000e620000205400ULL,
0x000000aca900720bULL, 0x004fe40003f9d000ULL, 0x000000d5b2ac723eULL, 0x000fe400000010ffULL,
0x0000000167675812ULL, 0x000fc600078efcffULL, 0x00000082009e7306ULL, 0x000fe40000209400ULL,
0x000000ac2818723cULL, 0x000fe80000041818ULL, 0x00000001a8a84812ULL, 0x000fe400078efcffULL,
0x0000008200917306ULL, 0x000ea20000205400ULL, 0x0000007c8500720bULL, 0x002fce0003fdd000ULL,
0x000000c0008d7306ULL, 0x000ff00000209400ULL, 0x000000c000847306ULL, 0x000e620000205400ULL,
0x000000919e00720bULL, 0x004fce0003f1d000ULL, 0x0000002d009b7306ULL, 0x000fec0000009400ULL,
0x0000000131310812ULL, 0x000fe400078efcffULL, 0x0000002d00907306ULL, 0x000ea20000005400ULL,
0x000000848d00720bULL, 0x002fce0003f5d000ULL, 0x00000065006c7306ULL, 0x000fec0000209400ULL,
0x0000000177772812ULL, 0x000fe400078efcffULL, 0x00000065006d7306ULL, 0x000e620000205400ULL,
0x000000909b00720bULL, 0x004fe40003f9d000ULL, 0x00000081ae9b723eULL, 0x000fc400000010ffULL,
0x000000777077723eULL, 0x000fc600000010ffULL, 0x000000c600877306ULL, 0x000fe40000209400ULL,
0x0000009a2804723cULL, 0x000fec0000041804ULL, 0x000000c600887306ULL, 0x000fe20000205400ULL,
0x0000006d6c00720bULL, 0x002fe20003f7d000ULL, 0x000000762410723cULL, 0x000fec0000041810ULL,
0x0000002d00507306ULL, 0x0002b0000000d400ULL, 0x00000060006a7306ULL, 0x000fe20000209400ULL,
0x00000032c52d723eULL, 0x002fce00000010ffULL, 0x0000006000697306ULL, 0x000e620000205400ULL,
0x0000002c2808723cULL, 0x000fe20000041808ULL, 0x0000000150504812ULL, 0x004fcc00078efcffULL,
0x0000002f006f7306ULL, 0x000fe20000009400ULL, 0x000000bf002c7245ULL, 0x000fe4000020d400ULL,
0x000000c6002d7245ULL, 0x000fe4000020d400ULL, 0x000000012c2c6812ULL, 0x000fe400078efcffULL,
0x000000888700720bULL, 0x000fe20003fdd000ULL, 0x0000002f006e7306ULL, 0x000ea20000005400ULL,
0x000000696a00720bULL, 0x002fe40003fbd000ULL, 0x000000009d69723eULL, 0x000fc400000010ffULL,
0x0000006500007245ULL, 0x000fe4000020d400ULL, 0x000000a8319d723eULL, 0x000fe200000010ffULL,
0x0000002e00807306ULL, 0x000fe20000009400ULL, 0x000000633029723eULL, 0x000fe200000010ffULL,
0x000000682404723cULL, 0x040fe20000041804ULL, 0x0000000100003812ULL, 0x000fe400078efcffULL,
0x000000012d2d6812ULL, 0x000fe400078efcffULL, 0x0000006000607245ULL, 0x000fe2000020d400ULL,
0x0000002e007f7306ULL, 0x000e620000005400ULL, 0x0000006e6f00720bULL, 0x004fe20003f5d000ULL,
0x0000009c2408723cULL, 0x000fe20000041808ULL, 0x00000075002a7245ULL, 0x000fc4000020d400ULL,
0x0000000160605812ULL, 0x000fe400078efcffULL, 0x000000648328723eULL, 0x000fe200000010ffULL,
0x000000c100827306ULL, 0x000fe20000209400ULL, 0x000000672c2c723eULL, 0x000fe400000010ffULL,
0x000000502d2d723eULL, 0x000fc600000010ffULL, 0x00000028240c723cULL, 0x000fe4000004180cULL,
0x000000c100337306ULL, 0x0005220000205400ULL, 0x0000007f8000720bULL, 0x002fca0003f1d000ULL,
0x0000002c2414723cULL, 0x000fe40000041814ULL, 0x000000c700327306ULL, 0x000fe20000209400ULL,
0x000000c100c17245ULL, 0x004fce000020d400ULL, 0x000000c700797306ULL, 0x0002a20000205400ULL,
0x000000338200720bULL, 0x010fce0003fdd000ULL, 0x0000007500747306ULL, 0x000fe20000209400ULL,
0x000000c700c77245ULL, 0x002fca000020d400ULL, 0x00000001c1c16812ULL, 0x000fe400078efcffULL,
0x0000007500737306ULL, 0x000e620000205400ULL, 0x000000793200720bULL, 0x004fe40003f9d000ULL,
0x000000c10028723eULL, 0x000fca00000010ffULL, 0x0000002e004f7306ULL, 0x00052c000000d400ULL,
0x00000001c7c74812ULL, 0x000fe400078efcffULL, 0x0000002f004e7306ULL, 0x000ae2000000d400ULL,
0x000100002e2e7824ULL, 0x004fe200078e00ffULL, 0x000000737400720bULL, 0x002fc40003f7d000ULL,
0x000000c76029723eULL, 0x000fe400000010ffULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x0000004d00617306ULL, 0x000fe20000209400ULL, 0x000100002f2f7824ULL, 0x020fe200078e00ffULL,
0x000000014f4f0812ULL, 0x010fe200078efcffULL, 0x000000282418723cULL, 0x000fe60000041818ULL,
0x00000018ff2f7819ULL, 0x000fc4000001142fULL, 0x0000004d00627306ULL, 0x0002a20000205400ULL,
0x000000012a2a3812ULL, 0x000fe400078efcffULL, 0x000000014e4e2812ULL, 0x008fe400078efcffULL,
0x0000004f2a2a723eULL, 0x000fc600000010ffULL, 0x0000004c00517306ULL, 0x000fe20000209400ULL,
0x0000004d004d7245ULL, 0x002fce000020d400ULL, 0x0000004c00667306ULL, 0x0002e20000205400ULL,
0x000000626100720bULL, 0x004fce0003fdd000ULL, 0x000000af006e7306ULL, 0x000fe20000209400ULL,
0x0000004c004c7245ULL, 0x002fca000020d400ULL, 0x000000014d4d6812ULL, 0x000fe400078efcffULL,
0x000000af006b7306ULL, 0x000e620000205400ULL, 0x000000665100720bULL, 0x008fce0003f9d000ULL,
0x0000002e006a7306ULL, 0x000fec0000209400ULL, 0x000000014c4c4812ULL, 0x000fe400078efcffULL,
0x0000002e002b7306ULL, 0x0004e20000205400ULL, 0x0000006b6e00720bULL, 0x002fce0003fbd000ULL,
0x0000002f00307306ULL, 0x000fe20000209400ULL, 0x0000002e002e7245ULL, 0x004fce000020d400ULL,
0x0000002f00317306ULL, 0x0002a20000205400ULL, 0x0000002b6a00720bULL, 0x008fe40003f7d000ULL,
0x000000af002b7245ULL, 0x000fc8000020d400ULL, 0x000000012b2b5812ULL, 0x000fe400078efcffULL,
0x0000002f002f7245ULL, 0x002fe4000020d400ULL, 0x0000004e2b2b723eULL, 0x000fc600000010ffULL,
0x000000012e2e3812ULL, 0x000fe400078efcffULL, 0x000000313000720bULL, 0x004fe40003f1d000ULL,
0x0000002e4d2e723eULL, 0x000fe200000010ffULL, 0x0000002a241c723cULL, 0x000ff4000004181cULL,
0x000000012f2f0812ULL, 0x000fc800078efcffULL, 0x0000002f4c2f723eULL, 0x000fce00000010ffULL,
0x0000002e2420723cULL, 0x000fe20000041820ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200038247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c049007810ULL, 0x000fe20007ffe0ffULL,
0x00f6980053ff7f8cULL, 0x0007e2000c80043fULL, 0x0000000137637812ULL, 0x000fe200078e0cffULL,
0x000000ffff617224ULL, 0x000fe200078e004bULL, 0x000000030000720cULL, 0x000fda0003f06070ULL,
0x00002af000000947ULL, 0x000fea0003800000ULL, 0x0000040092007984ULL, 0x008ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240038007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x0000240038247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff487819ULL, 0x000fe20000011602ULL,
0x00000080ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000030034257a10ULL, 0x000fe20007ffe0ffULL,
0x00000000560473c2ULL, 0x0004e200000e0000ULL, 0x00000003ff2c7819ULL, 0x000fe40000011641ULL,
0x0000000125267810ULL, 0x040fe20007ffe0ffULL, 0x0000000825007824ULL, 0x000fe200078e0248ULL,
0x000000042c2e7810ULL, 0x000fe40007ffe0ffULL, 0x000000352600720cULL, 0x000fe20003f06070ULL,
0x0000002000007824ULL, 0x000fe200078e00ffULL, 0x0000000c2c307810ULL, 0x000fc40007ffe0ffULL,
0x0000000854607812ULL, 0x000fe200078ec0ffULL, 0x000062003f2b7a24ULL, 0x000fe200078e0200ULL,
0x0000000003277217ULL, 0x000fc60007800000ULL, 0x0000000155607824ULL, 0x000fe200078e0260ULL,
0x0000002c2b247210ULL, 0x000fe20007ffe03eULL, 0x0000000127277824ULL, 0x000fe200078e0a00ULL,
0x0000002e2b267210ULL, 0x000fe40007ffe03eULL, 0x000000082c007810ULL, 0x000fe20007ffe0ffULL,
0x00005e0024247625ULL, 0x000fe200078e002fULL, 0x00000020272d7807ULL, 0x000fc60000000000ULL,
0x00005e0026267625ULL, 0x000fe200078e002fULL, 0x0000002d3e2d7217ULL, 0x000fe40007800000ULL,
0x0000004324287210ULL, 0x080fe40007f5e0ffULL, 0x00000043262a7210ULL, 0x000fe20007f1e0ffULL,
0x000000012d2d7824ULL, 0x100fe200078e0a3eULL, 0x000000002b247210ULL, 0x140fe20007ffe03eULL,
0x000000ffff297224ULL, 0x000fe200010e0625ULL, 0x000000302b267210ULL, 0x000fe20007ffe03eULL,
0x000000ffff2b7224ULL, 0x000fe200000e0627ULL, 0x0000002d2c00720cULL, 0x000fe20003f06070ULL,
0x00005e0024247625ULL, 0x000fe200078e002fULL, 0x0000002d2e00720cULL, 0x000fc40003f46070ULL,
0x0000002d0000720cULL, 0x000fe20003f66070ULL, 0x00005e0026267625ULL, 0x000fe200078e002fULL,
0x0000002d3000720cULL, 0x000fe40003f86070ULL, 0x0000004324247210ULL, 0x080fe40007fbe0ffULL,
0x0000004326267210ULL, 0x000fc60007fde0ffULL, 0x000000ffff257224ULL, 0x000fe200028e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028577faeULL, 0x0009e2000c101c46ULL,
0x000000ffff277224ULL, 0x000fc600030e0627ULL, 0x000000002a587faeULL, 0x0009e8000d101c46ULL,
0x0000000024597faeULL, 0x0009e8000d901c46ULL, 0x00000000265a7faeULL, 0x0009e8000e101c46ULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x008fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000060607f8cULL, 0x000ea8000c80043fULL, 0x000004005b5b7984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6680040247f8cULL, 0x010fe2000c80043fULL, 0x800000005bff7812ULL, 0x008fc6000784484bULL,
0x00f66c0040277984ULL, 0x000ee40000000800ULL, 0x8000000027ff7812ULL, 0x008fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000267305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000260000735dULL, 0x010fe20003800000ULL, 0x00f66c0040277984ULL, 0x000ee40000000800ULL,
0x8000000027ff7812ULL, 0x008fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018043257810ULL, 0x000fca0007ffe042ULL, 0x0000000144257824ULL, 0x000fca00078e0225ULL,
0x00f0000025277984ULL, 0x000ee80000000800ULL, 0x00f2000025007984ULL, 0x0008620000000800ULL,
0x0000003a2700720bULL, 0x008fe20003f1d000ULL, 0x0000c0a27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x010fc800000e0100ULL, 0x0000ffff24267812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff9b7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000302257811ULL, 0x000fe400078ff0ffULL,
0x0000003a2700720bULL, 0x000fe40003f14000ULL, 0x000000022500720cULL, 0x000fe20003f65270ULL,
0x0000c0627f007947ULL, 0x000ff4000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x000000273a287209ULL, 0x000fe20007810000ULL, 0x000000800243b824ULL, 0x000fe200078e0243ULL,
0x0000ffff24297812ULL, 0x000fe400078e3cffULL, 0x00000002ff2b7819ULL, 0x000fe20000011641ULL,
0x000000014443b824ULL, 0x000fe200078e0243ULL, 0x800000283a257221ULL, 0x000fe20000010000ULL,
0x0000002926ff7212ULL, 0x000fc6000780c0ffULL, 0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL,
0x00f400284300b388ULL, 0x0007e60000000800ULL, 0x00000025002a7308ULL, 0x000f240000000800ULL,
0x0000002a39397220ULL, 0x010fe20000410000ULL, 0x0000bfe27f007947ULL, 0x000fea000b800000ULL,
0x00001f2b2a247589ULL, 0x00872400000e0000ULL, 0x0000002404047220ULL, 0x090fe20000410000ULL,
0x0000002405057220ULL, 0x080fe20000410000ULL, 0x0000002408087220ULL, 0x080fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002420207220ULL, 0x080fe20000410000ULL,
0x0000002421217220ULL, 0x000fe20000410000ULL, 0x0000bf227f007947ULL, 0x000fea000b800000ULL,
0x00001f462a247589ULL, 0x0008e400000e0000ULL, 0x8000002827270221ULL, 0x100fe20000010000ULL,
0x00000001ff9b7807ULL, 0x000fe20000000000ULL, 0x0000002406067220ULL, 0x088fe20000410000ULL,
0x0000002407077220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x0000002700360308ULL, 0x000ee20000000800ULL,
0x000000240f0f7220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x0000002422227220ULL, 0x080fe20000410000ULL,
0x0000002423237220ULL, 0x000fe20000410000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e0028ULL,
0x0000000036000220ULL, 0x00afc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000003900397221ULL, 0x002fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x0000000837007824ULL, 0x000fe200078e00ffULL,
0xfffffff03d257812ULL, 0x000fc800078ec0ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000100247824ULL, 0x000fca00078e0225ULL, 0x00f6ac0024257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000257305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000250000735dULL, 0x008fe40003800000ULL, 0x00f6ac0024257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc4000780484bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff2b7819ULL, 0x000fe40000011641ULL, 0x00000036ff24723eULL, 0x000fe400000010ffULL,
0x000000182b007810ULL, 0x040fe40007ffe0ffULL, 0x000000102b267810ULL, 0x000fe40007ffe0ffULL,
0x00005410242a7816ULL, 0x010fe20000000024ULL, 0x0000bc727f007947ULL, 0x000fea000b800000ULL,
0x00001f2b2a6b7589ULL, 0x0002e400000e0000ULL, 0x0000bcb27f007947ULL, 0x000fea000b800000ULL,
0x00001f462a6a7589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0026ULL, 0x0000a3b000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000c2b000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2b7224ULL, 0x002fe200078e0000ULL, 0x0000a41000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000c25000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000005f24783bULL, 0x000f620000004200ULL, 0x000099109b9e7816ULL, 0x000fc600000000ffULL,
0x000000005d30783bULL, 0x000f220000004200ULL, 0x000000ff9e00720cULL, 0x000fc60003f65270ULL,
0x000000005c2c783bULL, 0x002e680000004200ULL, 0x000000005e28783bULL, 0x0145220000004200ULL,
0x0000010024967824ULL, 0x020fe200078e00ffULL, 0x00000024009d7306ULL, 0x000fe20000009400ULL,
0x00000018ffad7819ULL, 0x000fe40000011424ULL, 0x00000018ffa67819ULL, 0x000fe20000011425ULL,
0x0000010030a87824ULL, 0x040fe200078e00ffULL, 0x00000018ffa17819ULL, 0x000fe20000011496ULL,
0x0001000030d17824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011430ULL,
0x0000002400a27306ULL, 0x000f620000005400ULL, 0x00000018ff657819ULL, 0x000fe20000011432ULL,
0x0000010032d37824ULL, 0x000fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe20000011426ULL,
0x000001002cac7824ULL, 0x042fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fe20000011427ULL,
0x0000010033d47824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x004fe20000011433ULL,
0x00000024006f7306ULL, 0x0002a2000000d400ULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x000001002dab7824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe2000001142cULL,
0x000100002caa7824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe2000001142dULL,
0x000100002e967824ULL, 0x000fe200078e00ffULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x000000a100a47306ULL, 0x000fe20000209400ULL, 0x0001000024247824ULL, 0x002fe200078e00ffULL,
0x000000a29d00720bULL, 0x020fe20003f1d000ULL, 0x0000010031a27824ULL, 0x000fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x00010000339d7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa97819ULL, 0x000fe20000011424ULL, 0x0000010025247824ULL, 0x000fe200078e00ffULL,
0x000000a100a57306ULL, 0x000e620000205400ULL, 0x00000018ffd17819ULL, 0x000fe200000114d1ULL,
0x0001000031d27824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fc4000001142eULL,
0x00000018ffb37819ULL, 0x000fe20000011424ULL, 0x0000010026247824ULL, 0x000fe200078e00ffULL,
0x000000016f6f0812ULL, 0x004fe200078efcffULL, 0x0000002500b17306ULL, 0x000fe20000009400ULL,
0x00000018ffd37819ULL, 0x000fe400000114d3ULL, 0x00000018ffbd7819ULL, 0x000fe20000011424ULL,
0x0000010027247824ULL, 0x000fe200078e00ffULL, 0x00000018ff967819ULL, 0x000fe40000011496ULL,
0x00000018ff7f7819ULL, 0x000fe2000001142fULL, 0x0000002500b27306ULL, 0x000fe20000005400ULL,
0x000000a5a400720bULL, 0x002fc40003f5d000ULL, 0x00000018ffc37819ULL, 0x000fe40000011424ULL,
0x00000018ffd47819ULL, 0x000fe400000114d4ULL, 0x00000018ff707819ULL, 0x000fe20000011431ULL,
0x00000025006e7306ULL, 0x0003e2000000d400ULL, 0x00000018ffd27819ULL, 0x000fe400000114d2ULL,
0x00000018ff517819ULL, 0x010fe40000011428ULL, 0x00000018ff4c7819ULL, 0x000fc40000011429ULL,
0x00000018ff9d7819ULL, 0x000fe2000001149dULL, 0x000000ad00af7306ULL, 0x000fe20000209400ULL,
0x0001000025257824ULL, 0x002fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe4000001142aULL,
0x00000018ff407819ULL, 0x000fe4000001142bULL, 0x00000018ffb67819ULL, 0x000fe20000011425ULL,
0x000100002d257824ULL, 0x000fe200078e00ffULL, 0x000000ad00b07306ULL, 0x000e640000205400ULL,
0x000000b600a57245ULL, 0x000fc4000020d400ULL, 0x00000018ff257819ULL, 0x000fc80000011425ULL,
0x000000b300b47306ULL, 0x000ff00000209400ULL, 0x000000b300b57306ULL, 0x000ea20000205400ULL,
0x000000b0af00720bULL, 0x002fe20003fbd000ULL, 0x000001002aaf7824ULL, 0x000fc400078e00ffULL,
0x000001002bb07824ULL, 0x000fc600078e00ffULL, 0x00000018ffaf7819ULL, 0x000fe200000114afULL,
0x000000a900a77306ULL, 0x000fe20000209400ULL, 0x00000018ffb07819ULL, 0x000fce00000114b0ULL,
0x000000a900ae7306ULL, 0x000e620000205400ULL, 0x000000b5b400720bULL, 0x004fce0003f9d000ULL,
0x000000b600b77306ULL, 0x000ff00000209400ULL, 0x000000b600b87306ULL, 0x000ea20000205400ULL,
0x000000aea700720bULL, 0x002fe40003fdd000ULL, 0x00000018ffa77819ULL, 0x000fc400000114a2ULL,
0x000000ad00a27245ULL, 0x000fe2000020d400ULL, 0x0001000029ad7824ULL, 0x000fe400078e00ffULL,
0x0000003000747306ULL, 0x000fe20000009400ULL, 0x00000001a2a25812ULL, 0x000fe400078efcffULL,
0x00000018ffad7819ULL, 0x000fca00000114adULL, 0x0000003000817306ULL, 0x000fe20000005400ULL,
0x000000b8b700720bULL, 0x004fce0003f1d000ULL, 0x0000003000567306ULL, 0x0003ec000000d400ULL,
0x00000001a5a50812ULL, 0x000fe400078efcffULL, 0x000000a600b97306ULL, 0x000fe20000209400ULL,
0x00000018ff307819ULL, 0x002fe200000114a8ULL, 0x0001000032a87824ULL, 0x000fca00078e00ffULL,
0x00000018ffa87819ULL, 0x000fe200000114a8ULL, 0x000000a600ba7306ULL, 0x0002b00000205400ULL,
0x000000bd00be7306ULL, 0x000fe20000209400ULL, 0x000000a600a67245ULL, 0x002fce000020d400ULL,
0x000000bd00bf7306ULL, 0x000e620000205400ULL, 0x000000bab900720bULL, 0x004fce0003fbd000ULL,
0x00000032007e7306ULL, 0x000fec0000009400ULL, 0x00000001a6a65812ULL, 0x000fe400078efcffULL,
0x0000003200717306ULL, 0x000ff00000005400ULL, 0x0000003200507306ULL, 0x0005f0000000d400ULL,
0x0000002600bb7306ULL, 0x000fe20000009400ULL, 0x000000a100327245ULL, 0x004fc4000020d400ULL,
0x000000b300a17245ULL, 0x000fe4000020d400ULL, 0x0000000132322812ULL, 0x000fe400078efcffULL,
0x000000b2b100720bULL, 0x000fe20003f5d000ULL, 0x0000002600bc7306ULL, 0x000fe20000005400ULL,
0x00000001a1a14812ULL, 0x000fe400078efcffULL, 0x000000bfbe00720bULL, 0x002fca0003f9d000ULL,
0x0000002600697306ULL, 0x0003e8000000d400ULL, 0x000000016e6e2812ULL, 0x000fc800078efcffULL,
0x000000c300c47306ULL, 0x000fe20000209400ULL, 0x0001000026267824ULL, 0x002fca00078e00ffULL,
0x00000018ffc07819ULL, 0x000fe40000011426ULL, 0x000000c300c57306ULL, 0x000e700000205400ULL,
0x0000002700a07306ULL, 0x000ff00000009400ULL, 0x00000027009f7306ULL, 0x000ea20000005400ULL,
0x000000c5c400720bULL, 0x002fce0003f5d000ULL, 0x0000002700667306ULL, 0x000330000000d400ULL,
0x0000009500997306ULL, 0x000fe20000209400ULL, 0x0001000027277824ULL, 0x002fe200078e00ffULL,
0x0000009fa000720bULL, 0x004fc40003f1d000ULL, 0x000000bd00a07245ULL, 0x000fe4000020d400ULL,
0x00000018ffc67819ULL, 0x000fe40000011427ULL, 0x00000095009c7306ULL, 0x000e620000205400ULL,
0x00000001a0a04812ULL, 0x000fcc00078efcffULL, 0x0000000166660812ULL, 0x010fe200078efcffULL,
0x000000c000c17306ULL, 0x000ff00000209400ULL, 0x000000c000c27306ULL, 0x000ea20000205400ULL,
0x0000009c9900720bULL, 0x002fc40003fbd000ULL, 0x000000c300997245ULL, 0x000fc8000020d400ULL,
0x0000000199992812ULL, 0x000fe200078efcffULL, 0x0000003300857306ULL, 0x000fe60000009400ULL,
0x000000669999723eULL, 0x000fca00000010ffULL, 0x0000003300767306ULL, 0x000fe20000005400ULL,
0x000000c2c100720bULL, 0x004fce0003f9d000ULL, 0x00000033004f7306ULL, 0x0003f0000000d400ULL,
0x000000c600c77306ULL, 0x000fe20000209400ULL, 0x000000a900337245ULL, 0x002fc8000020d400ULL,
0x0000000133336812ULL, 0x000fe400078efcffULL, 0x000000bcbb00720bULL, 0x000fe20003fdd000ULL,
0x000000c600c87306ULL, 0x000e620000205400ULL, 0x00000033a2a2723eULL, 0x000fce00000010ffULL,
0x00000091009a7306ULL, 0x000fe80000209400ULL, 0x0000000169696812ULL, 0x000fc800078efcffULL,
0x0000009100977306ULL, 0x000ea20000205400ULL, 0x000000c8c700720bULL, 0x002fce0003f5d000ULL,
0x000000ac00c97306ULL, 0x000ff00000209400ULL, 0x000000ac00ca7306ULL, 0x000e620000205400ULL,
0x000000979a00720bULL, 0x004fe40003fdd000ULL, 0x000000c000977245ULL, 0x000fc4000020d400ULL,
0x00000095009a7245ULL, 0x000fe4000020d400ULL, 0x0000000197974812ULL, 0x000fe200078efcffULL,
0x0000002c00937306ULL, 0x000fe20000009400ULL, 0x000000019a9a5812ULL, 0x000fc800078efcffULL,
0x000000979a9a723eULL, 0x000fc600000010ffULL, 0x0000002c00947306ULL, 0x000ea20000005400ULL,
0x000000cac900720bULL, 0x002fce0003f1d000ULL, 0x000000ab00cd7306ULL, 0x000ff00000209400ULL,
0x000000ab00ce7306ULL, 0x000e620000205400ULL, 0x000000949300720bULL, 0x004fe40003f9d000ULL,
0x000000c600937245ULL, 0x000fc4000020d400ULL, 0x0000009100947245ULL, 0x000fe4000020d400ULL,
0x0000000193932812ULL, 0x000fe200078efcffULL, 0x0000002d00907306ULL, 0x000fe20000009400ULL,
0x0000000194946812ULL, 0x000fce00078efcffULL, 0x0000002d008f7306ULL, 0x000ea20000005400ULL,
0x000000cecd00720bULL, 0x002fce0003fbd000ULL, 0x00000046008e7306ULL, 0x000ff00000209400ULL,
0x00000046008d7306ULL, 0x000e620000205400ULL, 0x0000008f9000720bULL, 0x004fe40003f5d000ULL,
0x000000ac008f7245ULL, 0x000fe2000020d400ULL, 0x0000010029ac7824ULL, 0x000fc600078e00ffULL,
0x000000018f8f0812ULL, 0x000fe200078efcffULL, 0x000000aa00cb7306ULL, 0x000fe20000209400ULL,
0x00000018ffac7819ULL, 0x000fc800000114acULL, 0x000000ac00337245ULL, 0x000fc6000020d400ULL,
0x000000aa00cc7306ULL, 0x000ea20000205400ULL, 0x0000008d8e00720bULL, 0x002fe40003f1d000ULL,
0x000000ab008d7245ULL, 0x000fe2000020d400ULL, 0x0000010028ab7824ULL, 0x000fe200078e00ffULL,
0x00000088008e7245ULL, 0x000fe4000020d400ULL, 0x000000018d8d5812ULL, 0x000fe200078efcffULL,
0x0000002500cf7306ULL, 0x000fe20000209400ULL, 0x00000018ffab7819ULL, 0x000fce00000114abULL,
0x0000002500d07306ULL, 0x000e620000205400ULL, 0x000000cccb00720bULL, 0x004fce0003fdd000ULL,
0x0000002c00647306ULL, 0x000530000000d400ULL, 0x0000002d00627306ULL, 0x000ae2000000d400ULL,
0x000001002f2c7824ULL, 0x004fe200078e00ffULL, 0x000000d0cf00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000002e008b7306ULL, 0x000fe20000009400ULL,
0x000001002e2d7824ULL, 0x020fe200078e00ffULL, 0x0000000164644812ULL, 0x010fc800078efcffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000002e008c7306ULL, 0x000e620000005400ULL,
0x0000000162622812ULL, 0x008fc800078efcffULL, 0x000000628d8d723eULL, 0x000fc600000010ffULL,
0x0000002f008a7306ULL, 0x000ff00000009400ULL, 0x0000002f00897306ULL, 0x000ea20000005400ULL,
0x0000008c8b00720bULL, 0x002fe40003f9d000ULL, 0x000000aa008b7245ULL, 0x000fc8000020d400ULL,
0x000000018b8b6812ULL, 0x000fe200078efcffULL, 0x0000008800457306ULL, 0x000ff00000209400ULL,
0x0000008800447306ULL, 0x000e620000205400ULL, 0x000000898a00720bULL, 0x004fc40003f5d000ULL,
0x00000046008a7245ULL, 0x000fe4000020d400ULL, 0x0000002500897245ULL, 0x000fe4000020d400ULL,
0x000000018a8a0812ULL, 0x000fe200078efcffULL, 0x0000002d00277306ULL, 0x000fe20000209400ULL,
0x0000000189895812ULL, 0x000fce00078efcffULL, 0x0000002d00247306ULL, 0x000ea20000205400ULL,
0x000000444500720bULL, 0x002fe40003fdd000ULL, 0x00a800004744783bULL, 0x000e6a0000000200ULL,
0x0000002c00267306ULL, 0x000fec0000209400ULL, 0x000000018e8e6812ULL, 0x000fc400078efcffULL,
0x0000002c00a37306ULL, 0x0007220000205400ULL, 0x000000242700720bULL, 0x004fe40003f1d000ULL,
0x000000898e89723eULL, 0x000fca00000010ffULL, 0x000000d1009f7306ULL, 0x000fe20000209400ULL,
0x0000002c002c7245ULL, 0x008fe4000020d400ULL, 0x000000a32600720bULL, 0x010fca0003fbd000ULL,
0x000000d1009c7306ULL, 0x0005e20000205400ULL, 0x00a800005224783bULL, 0x00072e0000000200ULL,
0x0000008200777306ULL, 0x000fe20000209400ULL, 0x000000d100d17245ULL, 0x004fe2000020d400ULL,
0x0000006b4444b231ULL, 0x082fe200003400ffULL, 0x0000002d00527245ULL, 0x008fe2000020d400ULL,
0x0000006b4646b231ULL, 0x000fe200003400ffULL, 0x00000082002d7245ULL, 0x000fe2000020d400ULL,
0x0000006a4545b231ULL, 0x080fe200003400ffULL, 0x0000000152520812ULL, 0x000fe200078efcffULL,
0x00000082007c7306ULL, 0x000e620000205400ULL, 0x0000006a4747b231ULL, 0x000fe200003400ffULL,
0x000000012c2c5812ULL, 0x000fcc00078efcffULL, 0x000000d300917306ULL, 0x000ff00000209400ULL,
0x000000d3008c7306ULL, 0x0005e20000205400ULL, 0x0000007c7700720bULL, 0x002fce0003fdd000ULL,
0x0000002e005f7306ULL, 0x0002e2000000d400ULL, 0x0000006b2424b231ULL, 0x090fe200003400ffULL,
0x000000d300d37245ULL, 0x004fe2000020d400ULL, 0x0000006b2626b231ULL, 0x000fe400003400ffULL,
0x0000006a2525b231ULL, 0x080fe200003400ffULL, 0x000000012d2d6812ULL, 0x000fe200078efcffULL,
0x0000006a2727b231ULL, 0x000fe200003400ffULL, 0x0000009c9f00720bULL, 0x000fe20003f7d000ULL,
0x000100002f2e7824ULL, 0x002fe200078e00ffULL, 0x0000002f00597306ULL, 0x000e62000000d400ULL,
0x000000717e00720bULL, 0x000fc60003fdd000ULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x000000015f5f4812ULL, 0x008fe400078efcffULL, 0x0000009600987306ULL, 0x000fe60000209400ULL,
0x00000001d1d13812ULL, 0x000fe400078efcffULL, 0x0000008c9100720bULL, 0x000fe40003f7d000ULL,
0x0000000150506812ULL, 0x000fe200078efcffULL, 0x00000096002f7306ULL, 0x0004e20000205400ULL,
0x0000000159592812ULL, 0x002fc400078efcffULL, 0x000000817400720bULL, 0x000fe40003f5d000ULL,
0x000000648f8c723eULL, 0x000fc600000010ffULL, 0x000000d400aa7306ULL, 0x000fe20000209400ULL,
0x0000009600967245ULL, 0x004fe4000020d400ULL, 0x00000001d3d33812ULL, 0x000fe200078efcffULL,
0x0000008c4414723cULL, 0x000fe80000041814ULL, 0x000000d400a37306ULL, 0x0002a20000205400ULL,
0x0000002f9800720bULL, 0x008fe40003f1d000ULL, 0x00000030002f7245ULL, 0x000fc4000020d400ULL,
0x0000000156562812ULL, 0x000fe400078efcffULL, 0x000000768500720bULL, 0x000fe20003f5d000ULL,
0x0000007f00797306ULL, 0x000fe20000209400ULL, 0x000000d400d47245ULL, 0x002fe4000020d400ULL,
0x00000069a098723eULL, 0x000fc600000010ffULL, 0x0000000196960812ULL, 0x000fe400078efcffULL,
0x0000007f00807306ULL, 0x0002e20000205400ULL, 0x000000a3aa00720bULL, 0x004fe20003f7d000ULL,
0x00000098440c723cULL, 0x040fe2000004180cULL, 0x000000a5a6a3723eULL, 0x000fe400000010ffULL,
0x000000962d96723eULL, 0x000fe400000010ffULL, 0x000000014f4f2812ULL, 0x000fe200078efcffULL,
0x0000002e009b7306ULL, 0x000fe20000209400ULL, 0x0000007f007f7245ULL, 0x002fe2000020d400ULL,
0x000000a24408723cULL, 0x000fe80000041808ULL, 0x00000001d4d43812ULL, 0x000fc400078efcffULL,
0x0000002e009e7306ULL, 0x0002a20000205400ULL, 0x000000807900720bULL, 0x008fce0003f9d000ULL,
0x0000003100757306ULL, 0x000fe20000009400ULL, 0x0000002e002e7245ULL, 0x002fca000020d400ULL,
0x000000017f7f4812ULL, 0x000fe400078efcffULL, 0x0000003100727306ULL, 0x000e620000005400ULL,
0x0000009e9b00720bULL, 0x004fe40003fbd000ULL, 0x00000093949b723eULL, 0x000fca00000010ffULL,
0x0000003100007306ULL, 0x000ea4000000d400ULL, 0x0000009a4410723cULL, 0x000fe80000041810ULL,
0x000000012e2e5812ULL, 0x000fe400078efcffULL, 0x0000006500687306ULL, 0x000fe20000209400ULL,
0x000000727500720bULL, 0x002fe40003f1d000ULL, 0x0000002e7f97723eULL, 0x000fca00000010ffULL,
0x0000006500677306ULL, 0x0002e40000205400ULL, 0x000000964420723cULL, 0x000fe80000041820ULL,
0x0000000100000812ULL, 0x004fe400078efcffULL, 0x000000a800887306ULL, 0x000fe20000209400ULL,
0x0000006500657245ULL, 0x002fce000020d400ULL, 0x000000a800777306ULL, 0x0002a20000205400ULL,
0x000000676800720bULL, 0x008fce0003fdd000ULL, 0x0000003000317306ULL, 0x000fe20000209400ULL,
0x000000a800a87245ULL, 0x002fca000020d400ULL, 0x0000000165656812ULL, 0x000fe400078efcffULL,
0x0000003000a47306ULL, 0x0002e20000205400ULL, 0x000000778800720bULL, 0x004fe40003f7d000ULL,
0x0000008b8a88723eULL, 0x000fca00000010ffULL, 0x000000a700a97306ULL, 0x000fe20000209400ULL,
0x0000008300307245ULL, 0x002fe2000020d400ULL, 0x000000884418723cULL, 0x000fe80000041818ULL,
0x00000001a8a83812ULL, 0x000fe400078efcffULL, 0x000000a700ae7306ULL, 0x0002a20000205400ULL,
0x000000a43100720bULL, 0x008fe40003fbd000ULL, 0x000000d200317245ULL, 0x000fc4000020d400ULL,
0x000000a865a8723eULL, 0x000fc600000010ffULL, 0x0000007000867306ULL, 0x000fe20000209400ULL,
0x000000a700a77245ULL, 0x002fca000020d400ULL, 0x000000012f2f5812ULL, 0x000fe400078efcffULL,
0x00000070007d7306ULL, 0x0002e20000205400ULL, 0x000000aea900720bULL, 0x004fe40003f9d000ULL,
0x0000009d00a97245ULL, 0x000fe4000020d400ULL, 0x000000562f56723eULL, 0x000fc600000010ffULL,
0x0000005e00607306ULL, 0x000fe20000209400ULL, 0x0000007000707245ULL, 0x002fca000020d400ULL,
0x00000001a7a74812ULL, 0x000fe400078efcffULL, 0x0000005e00637306ULL, 0x0002a20000205400ULL,
0x0000007d8600720bULL, 0x008fce0003f1d000ULL, 0x000000ab00727306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x002fca000020d400ULL, 0x0000000170700812ULL, 0x000fe400078efcffULL,
0x000000ab006b7306ULL, 0x000e620000205400ULL, 0x000000636000720bULL, 0x004fce0003f7d000ULL,
0x0000008300877306ULL, 0x000fec0000209400ULL, 0x000000015e5e3812ULL, 0x000fe400078efcffULL,
0x00000083007a7306ULL, 0x000ea20000205400ULL, 0x0000006b7200720bULL, 0x002fe40003fdd000ULL,
0x000000ad006b7245ULL, 0x000fca000020d400ULL, 0x000000d200957306ULL, 0x000ff00000209400ULL,
0x000000d200907306ULL, 0x000e620000205400ULL, 0x0000007a8700720bULL, 0x004fce0003fbd000ULL,
0x0000002a006d7306ULL, 0x000fec0000009400ULL, 0x0000000130305812ULL, 0x000fe400078efcffULL,
0x0000002a006c7306ULL, 0x000ea20000005400ULL, 0x000000909500720bULL, 0x002fe40003f9d000ULL,
0x000000d13030723eULL, 0x000fca00000010ffULL, 0x00000051005a7306ULL, 0x000fec0000209400ULL,
0x0000000131314812ULL, 0x000fe400078efcffULL, 0x00000051005b7306ULL, 0x0002e20000205400ULL,
0x0000006c6d00720bULL, 0x004fe40003f1d000ULL, 0x000000317031723eULL, 0x000fca00000010ffULL,
0x000000ac00757306ULL, 0x000fe20000209400ULL, 0x0000005100517245ULL, 0x002fe2000020d400ULL,
0x000000302408723cULL, 0x000fec0000041808ULL, 0x000000ac00767306ULL, 0x000fe20000205400ULL,
0x0000005b5a00720bULL, 0x008fce0003f7d000ULL, 0x0000002800737306ULL, 0x000fec0000009400ULL,
0x0000000151513812ULL, 0x000fe400078efcffULL, 0x0000002800787306ULL, 0x000e700000005400ULL,
0x0000002900847306ULL, 0x000ff00000009400ULL, 0x00000029007b7306ULL, 0x000ea20000005400ULL,
0x000000787300720bULL, 0x002fce0003fbd000ULL, 0x0000002800557306ULL, 0x0002f0000000d400ULL,
0x00000029004a7306ULL, 0x000962000000d400ULL, 0x0001000028287824ULL, 0x002fe200078e00ffULL,
0x0000007b8400720bULL, 0x004fc80003f9d000ULL, 0x00000018ff6a7819ULL, 0x000fe40000011428ULL,
0x0000006f3228723eULL, 0x000fe200000010ffULL, 0x000000af00627306ULL, 0x000fe20000209400ULL,
0x000000ab00327245ULL, 0x000fe4000020d400ULL, 0x0000006ea129723eULL, 0x010fe400000010ffULL,
0x0000000132326812ULL, 0x000fe400078efcffULL, 0x000000767500720bULL, 0x000fe20003fdd000ULL,
0x0000006a006f7306ULL, 0x000fe20000209400ULL, 0x0000000155555812ULL, 0x008fe200078efcffULL,
0x000000284404723cULL, 0x000fe20000041804ULL, 0x000000014a4a4812ULL, 0x020fc400078efcffULL,
0x000000553232723eULL, 0x000fc600000010ffULL, 0x0000006a006c7306ULL, 0x0002a20000205400ULL,
0x000000592c29723eULL, 0x000fe400000010ffULL, 0x0000005f5228723eULL, 0x000fe400000010ffULL,
0x0000000133336812ULL, 0x000fc600078efcffULL, 0x000000af00637306ULL, 0x000ee20000205400ULL,
0x0000006a006a7245ULL, 0x002fe2000020d400ULL, 0x00000028441c723cULL, 0x000fe2000004181cULL,
0x0000004a3333723eULL, 0x000fca00000010ffULL, 0x0000004c00577306ULL, 0x000fe20000209400ULL,
0x0000006c6f00720bULL, 0x004fe20003fdd000ULL, 0x000000322414723cULL, 0x000fe20000041814ULL,
0x00000050d328723eULL, 0x000fe400000010ffULL, 0x0000004fd429723eULL, 0x000fc600000010ffULL,
0x0000004c00587306ULL, 0x0002a20000205400ULL, 0x000000636200720bULL, 0x008fc60003f7d000ULL,
0x00000028240c723cULL, 0x000fe4000004180cULL, 0x000000016a6a6812ULL, 0x000fe400078efcffULL,
0x0000009d00747306ULL, 0x000fe20000209400ULL, 0x0000004c004c7245ULL, 0x002fe4000020d400ULL,
0x0000006a516a723eULL, 0x000fca00000010ffULL, 0x0000009d00717306ULL, 0x000e620000205400ULL,
0x000000585700720bULL, 0x004fe40003fbd000ULL, 0x00000000a757723eULL, 0x000fe400000010ffULL,
0x000000af00007245ULL, 0x000fc6000020d400ULL, 0x000000ad00677306ULL, 0x000fe20000209400ULL,
0x0000000100003812ULL, 0x000fe200078efcffULL, 0x000000562404723cULL, 0x000fe80000041804ULL,
0x000000014c4c5812ULL, 0x000fe400078efcffULL, 0x000000ad00667306ULL, 0x000ea20000205400ULL,
0x000000717400720bULL, 0x002fce0003f5d000ULL, 0x0000002a00497306ULL, 0x0002ec000000d400ULL,
0x00000001a9a92812ULL, 0x000fe400078efcffULL, 0x0000002b005d7306ULL, 0x000fe20000009400ULL,
0x000100002a2a7824ULL, 0x002fe200078e00ffULL, 0x000000666700720bULL, 0x004fc40003f9d000ULL,
0x000000a95ea9723eULL, 0x000fe400000010ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000002b005c7306ULL, 0x000e620000005400ULL, 0x0000000149490812ULL, 0x008fe400078efcffULL,
0x000000a82410723cULL, 0x000fe40000041810ULL, 0x000000490028723eULL, 0x000fe400000010ffULL,
0x000000016b6b4812ULL, 0x000fe200078efcffULL, 0x0000002b00437306ULL, 0x0004e6000000d400ULL,
0x0000006b4c6b723eULL, 0x000fca00000010ffULL, 0x00000042004d7306ULL, 0x000fe20000209400ULL,
0x000100002b2b7824ULL, 0x004fe200078e00ffULL, 0x0000005c5d00720bULL, 0x002fe20003f5d000ULL,
0x0000006a2418723cULL, 0x000fe60000041818ULL, 0x00000018ff2e7819ULL, 0x000fe4000001142bULL,
0x00000042004e7306ULL, 0x000e6e0000205400ULL, 0x0000000143432812ULL, 0x008fe200078efcffULL,
0x0000002a002c7306ULL, 0x000ff00000209400ULL, 0x0000002a002d7306ULL, 0x0004e20000205400ULL,
0x0000004e4d00720bULL, 0x002fce0003fdd000ULL, 0x00000040004b7306ULL, 0x000fe20000209400ULL,
0x0000002a002a7245ULL, 0x004fce000020d400ULL, 0x0000004000547306ULL, 0x000e620000205400ULL,
0x0000002d2c00720bULL, 0x008fe40003f7d000ULL, 0x00000040002d7245ULL, 0x000fca000020d400ULL,
0x000000b000527306ULL, 0x000fec0000209400ULL, 0x000000012a2a3812ULL, 0x000fe400078efcffULL,
0x000000b000597306ULL, 0x0004e20000205400ULL, 0x000000544b00720bULL, 0x002fce0003f9d000ULL,
0x0000002e002b7306ULL, 0x000fe20000209400ULL, 0x000000b000b07245ULL, 0x004fca000020d400ULL,
0x000000012d2d4812ULL, 0x000fe400078efcffULL, 0x0000002e00307306ULL, 0x0002a20000205400ULL,
0x000000595200720bULL, 0x008fe40003fbd000ULL, 0x0000002e002e7245ULL, 0x002fd6000020d400ULL,
0x00000001b0b05812ULL, 0x000fe400078efcffULL, 0x000000302b00720bULL, 0x004fe40003f1d000ULL,
0x00000042002b7245ULL, 0x000fe4000020d400ULL, 0x00000043b029723eULL, 0x000fe400000010ffULL,
0x000000012b2b6812ULL, 0x000fc800078efcffULL, 0x0000002a2b2a723eULL, 0x000fe200000010ffULL,
0x00000028241c723cULL, 0x000fe4000004181cULL, 0x000000012e2e0812ULL, 0x000fc800078efcffULL,
0x0000002e2d2b723eULL, 0x000fce00000010ffULL, 0x0000002a2420723cULL, 0x000fe20000041820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200038247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a00053ff7f8cULL, 0x0007e2000c80043fULL, 0x0000000137637812ULL, 0x000fc600078ec0ffULL,
0x0000030034347a10ULL, 0x008fc80007ffe0ffULL, 0x000000353400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff4ad000007947ULL, 0x000fea000383ffffULL,
0x00000000000479c3ULL, 0x004ea20000002500ULL, 0x000000ffff317224ULL, 0x000fe400078e0023ULL,
0x000000ffff327224ULL, 0x000fe400078e0022ULL, 0x000000ffff2d7224ULL, 0x000fe400078e001fULL,
0x000000ffff2b7224ULL, 0x000fe400078e001cULL, 0x000000ffff307224ULL, 0x000fe400078e0021ULL,
0x000000ffff2f7224ULL, 0x000fc400078e0020ULL, 0x000000ffff2e7224ULL, 0x000fe400078e001eULL,
0x000000ffff2c7224ULL, 0x000fe400078e001dULL, 0x000000ffff297224ULL, 0x000fe400078e001bULL,
0x000000ffff2a7224ULL, 0x000fe400078e001aULL, 0x000000ffff287224ULL, 0x000fe400078e0019ULL,
0x000000ffff277224ULL, 0x000fe200078e0018ULL, 0x0000000435007c0cULL, 0x004fe2000bf03070ULL,
0x000000ffff267224ULL, 0x000fc400078e0016ULL, 0x000000ffff237224ULL, 0x000fe400078e0014ULL,
0x000000ffff227224ULL, 0x000fe400078e0012ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0010ULL,
0x000000ffff1c7224ULL, 0x000fe400078e000eULL, 0x000000ffff257224ULL, 0x008fe400078e0017ULL,
0x000000ffff247224ULL, 0x000fc400078e0015ULL, 0x000000ffff217224ULL, 0x000fe400078e0013ULL,
0x000000ffff207224ULL, 0x000fe400078e0011ULL, 0x000000ffff1e7224ULL, 0x000fe400078e000fULL,
0x000000ffff187224ULL, 0x000fe400078e000dULL, 0x000000ffff1d7224ULL, 0x000fe400078e000cULL,
0x000000ffff1a7224ULL, 0x000fc400078e000bULL, 0x000000ffff167224ULL, 0x000fe400078e000aULL,
0x000000ffff147224ULL, 0x000fe400078e0009ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0008ULL,
0x000000ffff127224ULL, 0x000fe400078e0007ULL, 0x000000ffff107224ULL, 0x000fe400078e0006ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0005ULL, 0x000000ffff197224ULL, 0x000fe200078e0004ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x0180000039007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000c4e000067802ULL, 0x000fe40000000f00ULL, 0x00009fd000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003900007308ULL, 0x000ea40000001000ULL, 0xbf80000000037423ULL, 0x004fc80000000039ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff057624ULL, 0x000fe400078e00ffULL,
0x00006600ff047624ULL, 0x000fca00078e00ffULL, 0x0000000604057981ULL, 0x000ea8000c1e9900ULL,
0x0000000000037919ULL, 0x000ee80000000000ULL, 0x0000000000087919ULL, 0x000f220000000000ULL,
0x00000002ff077819ULL, 0x008fe40000011603ULL, 0x0000000808037811ULL, 0x010fe200078ff0ffULL,
0x0000000005067220ULL, 0x004fca0000410000ULL, 0x00001f0706007589ULL, 0x000ea800000e0000ULL,
0x00001f0306037589ULL, 0x000ee200000e0000ULL, 0x0000001900197220ULL, 0x044fe20000410000ULL,
0x0000000e000e7220ULL, 0x040fe20000410000ULL, 0x0000001b001b7220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001f001f7220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002300237220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002700277220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002b002b7220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002f002f7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x000fe20000410000ULL, 0x0000001003107220ULL, 0x048fe20000410000ULL,
0x0000001203127220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000001c031c7220ULL, 0x040fe20000410000ULL,
0x0000001e031e7220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002103217220ULL, 0x040fe20000410000ULL, 0x0000002603267220ULL, 0x040fe20000410000ULL,
0x0000002503257220ULL, 0x040fe20000410000ULL, 0x0000002a032a7220ULL, 0x040fe20000410000ULL,
0x0000002903297220ULL, 0x040fe20000410000ULL, 0x0000002e032e7220ULL, 0x040fe20000410000ULL,
0x0000002d032d7220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000003103317220ULL, 0x000fc40000410000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000203007812ULL, 0x004fc400078ec0ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011603ULL, 0x0000000200067811ULL, 0x040fe400078ff8ffULL,
0x0000000400087811ULL, 0x000fe400078ff8ffULL, 0x0000000803177811ULL, 0x000fe400078ff0ffULL,
0x00000001ff047819ULL, 0x000fe40000011600ULL, 0x0000000706057812ULL, 0x000fc400078e780fULL,
0x00000007080a7812ULL, 0x040fe400078e780fULL, 0x0000000708087812ULL, 0x000fe200078e7817ULL,
0x000000080f097824ULL, 0x000fe200078e0205ULL, 0x00000006000b7811ULL, 0x000fe200078ff8ffULL,
0x000010003b057824ULL, 0x000fe200078e00ffULL, 0x0000000704007812ULL, 0x140fe200078e780fULL,
0x0000000817157824ULL, 0x000fe200078e0208ULL, 0x000000070b0c7812ULL, 0x000fe200078e780fULL,
0x0000000803087824ULL, 0x000fe200078e00ffULL, 0x0000000704047812ULL, 0x100fe200078e7817ULL,
0x000000080f077824ULL, 0x000fe200078e0200ULL, 0x0000000706067812ULL, 0x000fe200078e7817ULL,
0x0000080048007824ULL, 0x000fe200078e0205ULL, 0x000000070b0b7812ULL, 0x000fe200078e7817ULL,
0x000000080f0d7824ULL, 0x000fe200078e020aULL, 0x0000000808087812ULL, 0x000fe200078ec0ffULL,
0x0000000817117824ULL, 0x040fe200078e0204ULL, 0x000000190e04723eULL, 0x000fe200000010ffULL,
0x0000000817137824ULL, 0x000fe200078e0206ULL, 0x0000001b1406723eULL, 0x000fe200000010ffULL,
0x000000080f0f7824ULL, 0x000fc400078e020cULL, 0x0000000817177824ULL, 0x000fe200078e020bULL,
0x0000763204197816ULL, 0x000fe20000000006ULL, 0x0000001007077824ULL, 0x100fe400078e0200ULL,
0x00000010090b7824ULL, 0x100fe400078e0200ULL, 0x000000100d0d7824ULL, 0x100fe400078e0200ULL,
0x0000001011117824ULL, 0x100fe400078e0200ULL, 0x0000001013137824ULL, 0x000fc400078e0200ULL,
0x000000100f0f7824ULL, 0x100fe400078e0200ULL, 0x0000001015157824ULL, 0x100fe400078e0200ULL,
0x0000001017177824ULL, 0x000fe400078e0200ULL, 0x0000000107097824ULL, 0x000fe200078e0208ULL,
0x0000001d1807723eULL, 0x000fe200000010ffULL, 0x00000001080b7824ULL, 0x000fe200078e020bULL,
0x0000541004187816ULL, 0x000fe20000000006ULL, 0x00000001080d7824ULL, 0x000fe200078e020dULL,
0x000000232404723eULL, 0x000fe200000010ffULL, 0x0000000108117824ULL, 0x000fe200078e0211ULL,
0x000000272806723eULL, 0x000fe200000010ffULL, 0x0000000108137824ULL, 0x040fe200078e0213ULL,
0x0000001809007388ULL, 0x0005e20000000a00ULL, 0x00000001080f7824ULL, 0x000fe200078e020fULL,
0x00005410040a7816ULL, 0x000fe20000000006ULL, 0x0000000108157824ULL, 0x000fc400078e0215ULL,
0x0000000108177824ULL, 0x000fe200078e0217ULL, 0x0000001f2008723eULL, 0x000fc800000010ffULL,
0x0000541007187816ULL, 0x144fe20000000008ULL, 0x0000002048097824ULL, 0x000fe200078e0203ULL,
0x0000763207197816ULL, 0x000fe40000000008ULL, 0x0000002b2c07723eULL, 0x000fe200000010ffULL,
0x00000010090c7824ULL, 0x000fe200078e0205ULL, 0x0000002f3008723eULL, 0x000fe200000010ffULL,
0x000000180b007388ULL, 0x0005e40000000a00ULL, 0x00007632040b7816ULL, 0x004fe40000000006ULL,
0x000000101204723eULL, 0x000fc400000010ffULL, 0x000000161a06723eULL, 0x000fe200000010ffULL,
0x0000000a0d007388ULL, 0x0005e40000000a00ULL, 0x00005410070a7816ULL, 0x144fe40000000008ULL,
0x00007632070b7816ULL, 0x000fe40000000008ULL, 0x0000001c1e07723eULL, 0x000fe400000010ffULL,
0x000000222108723eULL, 0x000fe200000010ffULL, 0x0000000a0f007388ULL, 0x0005e40000000a00ULL,
0x00005410040a7816ULL, 0x004fc40000000006ULL, 0x00007632040b7816ULL, 0x000fe40000000006ULL,
0x000000262504723eULL, 0x000fe400000010ffULL, 0x0000002a2906723eULL, 0x000fe200000010ffULL,
0x0000000a11007388ULL, 0x0005e40000000a00ULL, 0x00005410070a7816ULL, 0x144fe40000000008ULL,
0x00007632070b7816ULL, 0x000fe40000000008ULL, 0x0000002e2d07723eULL, 0x000fc400000010ffULL,
0x000000323108723eULL, 0x000fe200000010ffULL, 0x0000000a13007388ULL, 0x0005e40000000a00ULL,
0x00005410040a7816ULL, 0x144fe40000000006ULL, 0x00007632040b7816ULL, 0x000fe40000000006ULL,
0x000000ff00047306ULL, 0x000fe60000205400ULL, 0x0000000a15007388ULL, 0x0005e40000000a00ULL,
0x00005410070a7816ULL, 0x004fc40000000008ULL, 0x00007632070b7816ULL, 0x000fe40000000008ULL,
0x000000ff00077306ULL, 0x000ea60000209400ULL, 0x0000000a17007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000040700720bULL, 0x004fc40003f1d000ULL,
0x000000ff00047245ULL, 0x000fd6000020d400ULL, 0x0000000104040812ULL, 0x000fe200078efcffULL,
0x000000000c107984ULL, 0x000ea60000000c00ULL, 0x000000040408723eULL, 0x000fe200000010ffULL,
0x000800000c187984ULL, 0x000ee80000000c00ULL, 0x000400000c1c7984ULL, 0x000f280000000c00ULL,
0x000c00000c207984ULL, 0x000f620000000c00ULL, 0x3f803f8008107831ULL, 0x004fc40000200010ULL,
0x3f803f8008137831ULL, 0x000fe40000200013ULL, 0x3f803f8010107831ULL, 0x008fe20000200018ULL,
0x00000300ff187624ULL, 0x000fe200078e00ffULL, 0x3f803f8008127831ULL, 0x040fe40000200012ULL,
0x3f803f8008117831ULL, 0x040fe40000200011ULL, 0x000000011800780cULL, 0x000fe20003f05270ULL,
0x3f803f80081f7831ULL, 0x050fe4000020001fULL, 0x3f803f80081e7831ULL, 0x000fc4000020001eULL,
0x3f803f80081d7831ULL, 0x040fe4000020001dULL, 0x3f803f80081c7831ULL, 0x000fe4000020001cULL,
0x3f803f8013137831ULL, 0x000fe4000020001bULL, 0x3f803f8012127831ULL, 0x000fe4000020001aULL,
0x3f803f8011117831ULL, 0x000fe40000200019ULL, 0x3f803f801f1f7831ULL, 0x020fc40000200023ULL,
0x3f803f801e1e7831ULL, 0x000fe20000200022ULL, 0x000000100c007388ULL, 0x0005e20000000c00ULL,
0x3f803f801d1d7831ULL, 0x000fe40000200021ULL, 0x3f803f801c1c7831ULL, 0x000fca0000200020ULL,
0x0004001c0c007388ULL, 0x0005e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f4000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x004ea20000002700ULL,
0x0000580018067a24ULL, 0x000fe200078e02ffULL, 0x0000000148ff7812ULL, 0x000fe2000780f802ULL,
0x00000800ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000000077919ULL, 0x000ea20000002600ULL,
0x00006400060d7a24ULL, 0x000fe200078e02ffULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000004003b087824ULL, 0x000fe200078e00ffULL, 0x000000000c147984ULL, 0x0007220000000c00ULL,
0x000000ff0300720cULL, 0x000fc40000725670ULL, 0x000007ff0d067811ULL, 0x000fe200078e40ffULL,
0x0000580010107a24ULL, 0x004fc800078e0207ULL, 0x0000030010077a24ULL, 0x000fca00078e02ffULL,
0x0000000407117c10ULL, 0x000fc8000fffe0ffULL, 0x00000011060a7211ULL, 0x000fca00078fa8ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e000bULL, 0x000000080a0e7210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fc800010e060bULL, 0x00000010090e7825ULL, 0x000fe200078e000eULL,
0x01ffffff0d097812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010030a7824ULL, 0x018fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x00000001110c7824ULL, 0x000fe200078e0209ULL,
0x000000700a137812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b127812ULL, 0x000fe200078ec0ffULL,
0x00006a00110a7625ULL, 0x000fc800078e000dULL, 0x00006a000c0c7625ULL, 0x000fe200078e000dULL,
0x0000000a120a7210ULL, 0x000fc80007a1e013ULL, 0x0000000c120c7210ULL, 0x000fe40007c7e013ULL,
0x0000000bff0b7210ULL, 0x000fe400007e44ffULL, 0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL,
0x0000003a0a007986ULL, 0x0005e8000c101906ULL, 0x000000390c007986ULL, 0x0005e4000c101906ULL,
0x0000000000007941ULL, 0x018fea0003800000ULL, 0x000000140e007986ULL, 0x0007e2000c101d06ULL,
0x0000011000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0b7424ULL, 0x004fe200078e00ffULL,
0xffffffff180d7810ULL, 0x000fc60007ffe0ffULL, 0x00006800100a7625ULL, 0x000fe200078e000bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000d0a0a79a8ULL, 0x000ea400099ee1c6ULL, 0x0000000d0a00720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0c7807ULL, 0x000fca0000000000ULL,
0x0000000cff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff0a7984ULL, 0x004ea40000000000ULL,
0x000000ff0a00720cULL, 0x004fda0003f05270ULL, 0x00002b9000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000010030a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x00000080ff197424ULL, 0x000fe200078e00ffULL, 0x00000001070c7810ULL, 0x000fe40007ffe0ffULL,
0x000000700a1b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b107812ULL, 0x000fe200078ec0ffULL,
0x00006a00070a7625ULL, 0x000fc800078e0019ULL, 0x00006a000c0c7625ULL, 0x000fe200078e0019ULL,
0x0000000a100a7210ULL, 0x000fc8000791e01bULL, 0x0000000c100c7210ULL, 0x000fe40007b5e01bULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x000000060a0e7981ULL, 0x008568000c1e1900ULL, 0x000000060c0f7981ULL, 0x000562000c1e1900ULL,
0x000000021800780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002070a7810ULL, 0x004fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a100a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a117981ULL, 0x000562000c1e1900ULL, 0x000000041800780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003070a7810ULL, 0x004fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a100a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a137981ULL, 0x000562000c1e1900ULL,
0x000000041800780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004070a7810ULL, 0x004fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a100a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a157981ULL, 0x000562000c1e1900ULL, 0x000000061800780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005070a7810ULL, 0x004fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a100a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a177981ULL, 0x000562000c1e1900ULL,
0x000000061800780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081800780cULL, 0x004fe40003f06070ULL, 0x00000006070a7810ULL, 0x000fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a100a7210ULL, 0x000fe40007a3e01bULL,
0x00000007070c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006a000c0c0625ULL, 0x000fe400078e0019ULL, 0x000000060a197981ULL, 0x000566000c1e1900ULL,
0x0000000c100c0210ULL, 0x000fc80007c7e01bULL, 0x0000000dff0d0210ULL, 0x000fcc0001fe84ffULL,
0x000000060c0d0981ULL, 0x000566000c1e1900ULL, 0x00000007180a7810ULL, 0x004fc80007ffe0ffULL,
0x00000003ff0c7819ULL, 0x000fc8000001160aULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x020fe400078e000eULL, 0x000000081b107824ULL, 0x040fe200078e00ffULL,
0x000000011b1b7810ULL, 0x000fc80007ffe0ffULL, 0x0000030010007a0cULL, 0x000fe40003f26070ULL,
0x0000000c1b00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x024fea0003800000ULL,
0x00000008100a7810ULL, 0x040fe40007ffe0ffULL, 0x00000001100b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001d0e0e7209ULL, 0x008fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x00000070121d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a140a7210ULL, 0x000fc80007b3e01dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a1d7981ULL, 0x000568000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x00000009100a7810ULL, 0x044fe40007ffe0ffULL,
0x00000002100b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000f0e0e7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a0f7981ULL, 0x000568000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a100a7810ULL, 0x044fe40007ffe0ffULL, 0x00000003100b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x000000110e0e7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a117981ULL, 0x000568000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b100a7810ULL, 0x044fe40007ffe0ffULL,
0x00000004100b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x000000130e0e7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff147819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007012137812ULL, 0x000fc800078ec0ffULL,
0x0000000a140a7210ULL, 0x000fc80007b3e013ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a137981ULL, 0x000568000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c100a7810ULL, 0x044fe40007ffe0ffULL, 0x00000005100b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x000000150e0e7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007012157812ULL, 0x000fc800078ec0ffULL, 0x0000000a140a7210ULL, 0x000fc80007b3e015ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a157981ULL, 0x000568000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d100a7810ULL, 0x044fe40007ffe0ffULL,
0x00000006100b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x000000170e0e7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff147819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007012177812ULL, 0x000fc800078ec0ffULL,
0x0000000a140a7210ULL, 0x000fc80007b3e017ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a177981ULL, 0x000568000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e100a7810ULL, 0x044fe40007ffe0ffULL, 0x00000007100b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x000000190e0e7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007012197812ULL, 0x000fc800078ec0ffULL, 0x0000000a140a7210ULL, 0x000fc80007b3e019ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a197981ULL, 0x000568000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f100a7810ULL, 0x004fe40007ffe0ffULL,
0x0000000d0e0e7209ULL, 0x000fe40007810000ULL, 0x000003000a007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030d7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007a3e00dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000060a0d7981ULL, 0x000568000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000f240000000000ULL, 0x00000010030a7824ULL, 0x014fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011603ULL, 0x000000700a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL, 0x000000010b0b7824ULL, 0x000fca00078e020aULL,
0x0000000e0b007388ULL, 0x0205e40000000800ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x00000010030b7824ULL, 0x004fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011603ULL,
0x0000000148127824ULL, 0x000fe200078e0207ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff0e7819ULL, 0x008fe20000011602ULL, 0x00000800ff0f7424ULL, 0x000fe200078e00ffULL,
0x000000700b0c7812ULL, 0x000fe200078ec0ffULL, 0x0000020002027824ULL, 0x000fe200078e00ffULL,
0x0000000c0d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000013c3c7824ULL, 0x000fe200078e0205ULL,
0x00000012060a7211ULL, 0x000fe200078fa8ffULL, 0x000010d000007945ULL, 0x000fe20003800000ULL,
0x0000000109108824ULL, 0x000fe200078e0212ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000010d297824ULL, 0x000fe200078e020cULL, 0x000000010e0c7812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fe200078e000fULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000002480d8824ULL, 0x100fe200078e023bULL, 0x000000080a0a7210ULL, 0x000fe20007f3e0ffULL,
0x00000002480f8824ULL, 0x000fe200078e023bULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000020d0e8824ULL, 0x100fe200078e020cULL, 0x00000800020d7812ULL, 0x000fe200078ec0ffULL,
0x00000080ff118424ULL, 0x000fe200078e00ffULL, 0x0000000029297984ULL, 0x000ea20000000800ULL,
0x00000080ff138424ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000020f148824ULL, 0x000fe200078e020cULL, 0x00000020030f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000030048007a0cULL, 0x000fe20003f26070ULL,
0x000000013c027824ULL, 0x000fe200078e020dULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00006a0010108625ULL, 0x000fc800078e0011ULL, 0x00006a0012128625ULL, 0x000fc800078e0013ULL,
0x000000080e178824ULL, 0x100fe400078e0203ULL, 0x0000000814148824ULL, 0x000fe400078e0203ULL,
0x0000001003157824ULL, 0x000fe200078e0202ULL, 0x0000458017178811ULL, 0x000fe200078e20ffULL,
0x00000010030c7825ULL, 0x000fe200078e000aULL, 0x00004180141f8811ULL, 0x000fc600078e20ffULL,
0x000000100f0e7825ULL, 0x000fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000c157faeULL, 0x0007e2000b901c46ULL, 0x00000000000a7805ULL, 0x000fe4000001ff00ULL,
0x0000001003108825ULL, 0x040fe200078e0010ULL, 0x003800000e157faeULL, 0x0009e6000b901c46ULL,
0x0000001003128825ULL, 0x000fe200078e0012ULL, 0x0000000010178faeULL, 0x000be6000b901c46ULL,
0x000000ffff027224ULL, 0x000fe200078e00ffULL, 0x00000000121f8faeULL, 0x0003e2000b901c46ULL,
0x00000000000c7805ULL, 0x008fe2000001ff00ULL, 0x000000ffff287224ULL, 0x000fc400078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000e7805ULL, 0x010fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x000000ffff327224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x020fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x002fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000d5000001947ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x004fe400078e00ffULL,
0x000000ffff337224ULL, 0x000fca00078e0048ULL, 0x0000000233347810ULL, 0x000fe20007ffe0ffULL,
0x0000029000017945ULL, 0x000fe60003800000ULL, 0x0000030034007a0cULL, 0x000fda0003f06070ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x000000070300780cULL, 0x000fe20003f24070ULL,
0x0000000107307824ULL, 0x100fe200078e0234ULL, 0x00000001ff2a7819ULL, 0x000fe20000011634ULL,
0x00000800ff367424ULL, 0x000fe200078e00ffULL, 0x0000002003377810ULL, 0x000fe20007ffe0ffULL,
0x00000400342c7824ULL, 0x000fe200078e00ffULL, 0x00000030062b7211ULL, 0x000fe400078fa8ffULL,
0x000000012a2e7812ULL, 0x000fc600078ec0ffULL, 0x00006a002b2a7625ULL, 0x000fc800078e0036ULL,
0x00000002482f9824ULL, 0x100fe200078e023bULL, 0x000000082a2a7210ULL, 0x000fe20007f1e0ffULL,
0x00000001092d9824ULL, 0x000fe400078e0230ULL, 0x000000022f369824ULL, 0x100fe200078e022eULL,
0x000008002c2f7812ULL, 0x000fe200078ec0ffULL, 0x0000000248319824ULL, 0x000fe400078e023bULL,
0x00000080ff389424ULL, 0x000fe400078e00ffULL, 0x00000002313a9824ULL, 0x000fc400078e022eULL,
0x00006a002d2c9625ULL, 0x000fc800078e0038ULL, 0x00000080ff319424ULL, 0x000fe400078e00ffULL,
0x000000013c2e7824ULL, 0x000fe400078e022fULL, 0x000000ffff2b7224ULL, 0x000fe400000e062bULL,
0x00006a0030309625ULL, 0x000fc800078e0031ULL, 0x0000001003357824ULL, 0x040fe400078e022eULL,
0x0000000836369824ULL, 0x000fe400078e0203ULL, 0x00000010032e9825ULL, 0x000fc800078e002cULL,
0x000000083a399824ULL, 0x000fe400078e0203ULL, 0x00000010372c7825ULL, 0x100fe200078e002aULL,
0x0000458036379811ULL, 0x000fe400078e20ffULL, 0x0000418039399811ULL, 0x000fe200078e20ffULL,
0x00000010032a7825ULL, 0x000fc800078e002aULL, 0x0000001003309825ULL, 0x000fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800002a357faeULL, 0x0003e8000b901c46ULL,
0x003800002c357faeULL, 0x0003e8000b901c46ULL, 0x000000002e379faeULL, 0x0003e8000b901c46ULL,
0x0000000030399faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000040332a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff2c7819ULL, 0x000fe20000011603ULL, 0x00000002482d7824ULL, 0x000fe200078e023bULL,
0x00000002ff547819ULL, 0x000fe20000011603ULL, 0x00000010032b7824ULL, 0x000fe200078e00ffULL,
0x000000802a2a7812ULL, 0x000fc400078ec0ffULL, 0x0000000c2c2c7812ULL, 0x000fe200078ec0ffULL,
0x00000008542f7824ULL, 0x040fe200078e00ffULL, 0x000000702b2b7812ULL, 0x000fe200078ec0ffULL,
0x000001002d2a7824ULL, 0x000fe200078e002aULL, 0x0000000754427812ULL, 0x040fe200078ec0ffULL,
0x00000008542d7824ULL, 0x040fe200078e00ffULL, 0x0000000854567810ULL, 0x000fe40007ffe0ffULL,
0x0000002a2c2c7210ULL, 0x000fe20007ffe02bULL, 0x00000008542b7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2a7812ULL, 0x100fe200078ee242ULL, 0x00000008562d7824ULL, 0x040fe200078e00ffULL,
0x00000056ff507212ULL, 0x000fe200078e33ffULL, 0x0000000856447824ULL, 0x000fe200078e00ffULL,
0x000000012b2e7812ULL, 0x000fe200078ef642ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180002c3e7984ULL, 0x000e620000000800ULL, 0x000000022b307812ULL, 0x140fe400078ef642ULL,
0x000000032b367812ULL, 0x140fe200078ef642ULL, 0x004580002c527984ULL, 0x0002a20000000800ULL,
0x000000042b387812ULL, 0x140fe400078ef642ULL, 0x000000052b3a7812ULL, 0x000fe400078ef642ULL,
0x00000054ff407212ULL, 0x000fe400078e33ffULL, 0xfffffff82d507812ULL, 0x000fc400078ee250ULL,
0xfffffff82f407812ULL, 0x000fe400078ee240ULL, 0x00000007562f7812ULL, 0x000fe200078ec0ffULL,
0x0000003e292c7221ULL, 0x002fe20000010100ULL, 0x000000062b3e7812ULL, 0x000fe200078ef642ULL,
0x00000400332b7824ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b2c317820ULL, 0x000fe20000410000ULL,
0x00000004032c7824ULL, 0x000fe400078e00ffULL, 0x000008002b2b7812ULL, 0x000fe200078ec0ffULL,
0x0000000856427824ULL, 0x000fc400078e00ffULL, 0x0000000c2c2d7812ULL, 0x000fe200078ec0ffULL,
0x0000003100317308ULL, 0x000ea20000000800ULL, 0x000001803c2b7810ULL, 0x000fe20007ffe02bULL,
0x000000ffff337224ULL, 0x000fe200078e0034ULL, 0xfffffff8442c7812ULL, 0x100fe400078ee22fULL,
0x0000000142447812ULL, 0x000fe200078ef62fULL, 0x000000102a2a7824ULL, 0x000fe200078e022bULL,
0x0000000242467812ULL, 0x000fe200078ef62fULL, 0x0000001040407824ULL, 0x000fe200078e022bULL,
0x00000003424a7812ULL, 0x000fe200078ef62fULL, 0x000000012a2a7824ULL, 0x000fe200078e022dULL,
0x00000004424c7812ULL, 0x140fe200078ef62fULL, 0x000000012d407824ULL, 0x040fe200078e0240ULL,
0x00000005424e7812ULL, 0x000fe200078ef62fULL, 0x000000102e2e7824ULL, 0x000fe200078e022bULL,
0x0000000642427812ULL, 0x000fe200078ef62fULL, 0x0000001030307824ULL, 0x100fe200078e022bULL,
0x000000002a2f7984ULL, 0x000e620000000800ULL, 0x000000012d2e7824ULL, 0x000fe200078e022eULL,
0x0000005231317220ULL, 0x004fe20000410000ULL, 0x000000012d307824ULL, 0x000fe200078e0230ULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x0000001036367824ULL, 0x100fe200078e022bULL,
0x0000030033007a0cULL, 0x000fe20003f06070ULL, 0x0000001038387824ULL, 0x100fe200078e022bULL,
0x000000002e2e7984ULL, 0x000fe20000000800ULL, 0x000000012d367824ULL, 0x000fe200078e0236ULL,
0x0000003231327221ULL, 0x000fe20000010000ULL, 0x000000012d387824ULL, 0x000fe200078e0238ULL,
0x0000000030307984ULL, 0x000fe20000000800ULL, 0x000000103a3a7824ULL, 0x000fc400078e022bULL,
0x000000103e3e7824ULL, 0x100fe200078e022bULL, 0x00001f54312a7589ULL, 0x000ea200000e0000ULL,
0x000000012d3a7824ULL, 0x000fe400078e023aULL, 0x000000102c2c7824ULL, 0x100fe200078e022bULL,
0x0000000036367984ULL, 0x000ee20000000800ULL, 0x0000001044447824ULL, 0x100fe400078e022bULL,
0x0000001046467824ULL, 0x100fe200078e022bULL, 0x0000000038387984ULL, 0x000f220000000800ULL,
0x000000104a4a7824ULL, 0x000fc400078e022bULL, 0x000000104c4c7824ULL, 0x100fe200078e022bULL,
0x000000003a3a7984ULL, 0x000f620000000800ULL, 0x000000104e4e7824ULL, 0x100fe400078e022bULL,
0x0000001042427824ULL, 0x100fe400078e022bULL, 0x0000001050507824ULL, 0x000fe400078e022bULL,
0x000000012d3e7824ULL, 0x040fe200078e023eULL, 0x00001f56312b7589ULL, 0x000fe200000e0000ULL,
0x000000012d2c7824ULL, 0x000fc400078e022cULL, 0x000000012d447824ULL, 0x040fe200078e0244ULL,
0x00007610ff527816ULL, 0x002fe2000000002fULL, 0x000000012d467824ULL, 0x040fe200078e0246ULL,
0x000000003e3e7984ULL, 0x000e620000000800ULL, 0x000000012d4a7824ULL, 0x040fe400078e024aULL,
0x000000012d4c7824ULL, 0x040fe200078e024cULL, 0x000000002c2c7984ULL, 0x000e620000000800ULL,
0x000000012d4e7824ULL, 0x040fe200078e024eULL, 0x0000002a52277223ULL, 0x004fe20000010027ULL,
0x000000012d427824ULL, 0x040fe200078e0242ULL, 0x0000000044447984ULL, 0x000ea20000000800ULL,
0x000000012d507824ULL, 0x000fe200078e0250ULL, 0x00005410ff2d7816ULL, 0x000fc4000000002fULL,
0x0000000046467984ULL, 0x000e660000000800ULL, 0x0000002a2d287223ULL, 0x000fe20000010028ULL,
0x00005410ff2d7816ULL, 0x100fe20000000040ULL, 0x000000004a4a7984ULL, 0x000ea20000000800ULL,
0x00007610ff407816ULL, 0x000fc60000000040ULL, 0x0000002a2d1a7223ULL, 0x080fe2000001001aULL,
0x00005410ff2d7816ULL, 0x100fe2000000002eULL, 0x000000004c4c7984ULL, 0x000ea20000000800ULL,
0x00007610ff2e7816ULL, 0x000fe2000000002eULL, 0x0000002a40197223ULL, 0x080fe40000010019ULL,
0x0000002a2d267223ULL, 0x080fe20000010026ULL, 0x00005410ff2d7816ULL, 0x100fe20000000030ULL,
0x000000004e4e7984ULL, 0x000ea20000000800ULL, 0x00007610ff307816ULL, 0x000fe20000000030ULL,
0x0000002a2e257223ULL, 0x000fc40000010025ULL, 0x0000002a2d247223ULL, 0x080fe20000010024ULL,
0x00005410ff2d7816ULL, 0x108fe20000000036ULL, 0x0000000042427984ULL, 0x000ee20000000800ULL,
0x00007610ff367816ULL, 0x000fe20000000036ULL, 0x0000002a30237223ULL, 0x080fe40000010023ULL,
0x0000002a2d227223ULL, 0x080fe20000010022ULL, 0x00005410ff2d7816ULL, 0x110fe20000000038ULL,
0x0000000050507984ULL, 0x000f220000000800ULL, 0x00007610ff387816ULL, 0x000fe20000000038ULL,
0x0000002a36217223ULL, 0x000fc40000010021ULL, 0x0000002a2d207223ULL, 0x080fe20000010020ULL,
0x00005410ff2d7816ULL, 0x120fe2000000003aULL, 0x0000002a381f7223ULL, 0x000fe2000001001fULL,
0x00007610ff3a7816ULL, 0x000fc6000000003aULL, 0x0000002a2d1e7223ULL, 0x080fe2000001001eULL,
0x00005410ff2d7816ULL, 0x102fe2000000003eULL, 0x0000002a3a1d7223ULL, 0x000fe2000001001dULL,
0x00007610ff3e7816ULL, 0x000fc6000000003eULL, 0x0000002a2d1c7223ULL, 0x080fe2000001001cULL,
0x00005410ff2d7816ULL, 0x100fe2000000002cULL, 0x0000002a3e1b7223ULL, 0x000fe2000001001bULL,
0x00007610ff2c7816ULL, 0x000fc6000000002cULL, 0x0000002b2d187223ULL, 0x080fe20000010018ULL,
0x00005410ff2d7816ULL, 0x104fe20000000044ULL, 0x0000002b2c177223ULL, 0x000fe20000010017ULL,
0x00007610ff447816ULL, 0x000fc60000000044ULL, 0x0000002b2d167223ULL, 0x080fe20000010016ULL,
0x00005410ff2d7816ULL, 0x100fe20000000046ULL, 0x0000002b44157223ULL, 0x000fe20000010015ULL,
0x00007610ff467816ULL, 0x000fc60000000046ULL, 0x0000002b2d147223ULL, 0x080fe20000010014ULL,
0x00005410ff2d7816ULL, 0x100fe2000000004aULL, 0x0000002b46137223ULL, 0x000fe20000010013ULL,
0x00007610ff4a7816ULL, 0x000fc6000000004aULL, 0x0000002b2d127223ULL, 0x080fe20000010012ULL,
0x00005410ff2d7816ULL, 0x100fe2000000004cULL, 0x0000002b4a117223ULL, 0x000fe20000010011ULL,
0x00007610ff4c7816ULL, 0x000fc6000000004cULL, 0x0000002b2d107223ULL, 0x080fe20000010010ULL,
0x00005410ff2d7816ULL, 0x100fe2000000004eULL, 0x0000002b4c0f7223ULL, 0x000fe2000001000fULL,
0x00007610ff4e7816ULL, 0x000fc6000000004eULL, 0x0000002b2d0e7223ULL, 0x080fe2000001000eULL,
0x00005410ff2d7816ULL, 0x108fe20000000042ULL, 0x0000002b4e0d7223ULL, 0x000fe2000001000dULL,
0x00007610ff427816ULL, 0x000fc60000000042ULL, 0x0000002b2d0c7223ULL, 0x080fe2000001000cULL,
0x00005410ff2d7816ULL, 0x010fe20000000050ULL, 0x0000002b420b7223ULL, 0x000fc8000001000bULL,
0x0000002b2d0a7223ULL, 0x000fe2000001000aULL, 0x00007610ff2d7816ULL, 0x000fca0000000050ULL,
0x0000002b2d027223ULL, 0x000fe20000010002ULL, 0xfffff2d000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x004fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x000000ff3b00720cULL, 0x000fe20003f05270ULL, 0x0000001003067824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fca00078ec0ffULL, 0x0000000103087824ULL, 0x000fe200078e0206ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000001003067824ULL, 0x002fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011603ULL,
0x0000007006037812ULL, 0x000fe400078ec0ffULL, 0x0000000c07067812ULL, 0x000fc600078ec0ffULL,
0x0000008048037824ULL, 0x000fc800078e0203ULL, 0x0000000106037824ULL, 0x000fca00078e0203ULL,
0x0049803203007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800008037984ULL, 0x002e680000000800ULL,
0x004a000008067984ULL, 0x000ea20000000800ULL, 0x00000003ff037221ULL, 0x002fc80000010000ULL,
0x0000000603037221ULL, 0x004fca0000010000ULL, 0x0180000003067810ULL, 0x000fc80007ffe0ffULL,
0x7f80000006067812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0600780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff397224ULL, 0x000fe200078e0003ULL, 0x0000f3d000067802ULL, 0x000fe40000000f00ULL,
0x000070e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff067224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000300067308ULL, 0x000e640000001000ULL,
0xbf80000003077423ULL, 0x002fc80000000006ULL, 0x800000ff07077221ULL, 0x000fc80000010100ULL,
0x0000000706067223ULL, 0x000fe40000000006ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000803437811ULL, 0x004fe400078ff0ffULL, 0x00000002ff337819ULL, 0x000fe40000011603ULL,
0x00000043ff457212ULL, 0x000fe200078e33ffULL, 0x00001f4306097589ULL, 0x000ea200000e0000ULL,
0x0000000843087824ULL, 0x000fc400078e00ffULL, 0x0000000833477824ULL, 0x000fe200078e00ffULL,
0x00001f3306077589ULL, 0x00072400000e0000ULL, 0xfffffff808457812ULL, 0x000fca00078ee245ULL,
0x0000001045457824ULL, 0x000fe200078e0200ULL, 0x00000033ff067212ULL, 0x008fc800078e33ffULL,
0xfffffff847477812ULL, 0x000fe200078ee206ULL, 0x0000000833067824ULL, 0x000fe200078e00ffULL,
0x0000001809187220ULL, 0x044fe20000410000ULL, 0x0000001709177220ULL, 0x040fe20000410000ULL,
0x0000001609167220ULL, 0x040fe20000410000ULL, 0x0000001509157220ULL, 0x040fe20000410000ULL,
0x0000001409147220ULL, 0x040fe20000410000ULL, 0x0000001309137220ULL, 0x040fe20000410000ULL,
0x0000001209127220ULL, 0x040fe20000410000ULL, 0x0000001109117220ULL, 0x040fe20000410000ULL,
0x0000001009107220ULL, 0x040fe20000410000ULL, 0x0000000f090f7220ULL, 0x040fe20000410000ULL,
0x0000000e090e7220ULL, 0x040fe20000410000ULL, 0x0000000d090d7220ULL, 0x040fe20000410000ULL,
0x0000000c090c7220ULL, 0x040fe20000410000ULL, 0x0000000b090b7220ULL, 0x040fe20000410000ULL,
0x0000000a090a7220ULL, 0x040fe20000410000ULL, 0x0000000209097220ULL, 0x000fe20000410000ULL,
0x0000000733027812ULL, 0x000fe200078ec0ffULL, 0x0000002807287220ULL, 0x050fe20000410000ULL,
0x0000002707277220ULL, 0x040fe20000410000ULL, 0x0000002607267220ULL, 0x040fe20000410000ULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000002207227220ULL, 0x040fe20000410000ULL,
0x0000002107217220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000001f071f7220ULL, 0x040fe20000410000ULL, 0x0000001e071e7220ULL, 0x040fe20000410000ULL,
0x0000001d071d7220ULL, 0x040fe20000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000001b071b7220ULL, 0x040fe20000410000ULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x0000001907077220ULL, 0x000fe20000410000ULL, 0x0000000e0d0d723eULL, 0x000fc400000010ffULL,
0x0000000c0b0b723eULL, 0x000fe400000010ffULL, 0x0000000a0909723eULL, 0x000fe400000010ffULL,
0xfffffff806197812ULL, 0x000fe400078ee233ULL, 0x0000000102067812ULL, 0x040fe400078e3cffULL,
0x0000000202087812ULL, 0x040fe200078e3cffULL, 0x0000001019197824ULL, 0x000fe200078e0200ULL,
0x00000003020a7812ULL, 0x040fe200078e3cffULL, 0x0000000833297824ULL, 0x040fe200078e0206ULL,
0x00000004020c7812ULL, 0x040fe200078e3cffULL, 0x00000008332b7824ULL, 0x040fe200078e0208ULL,
0x00000005020e7812ULL, 0x040fe200078e3cffULL, 0x00000008332d7824ULL, 0x040fe200078e020aULL,
0x0000000602027812ULL, 0x000fe200078e3cffULL, 0x00000008332f7824ULL, 0x000fe200078e020cULL,
0x000000121111723eULL, 0x000fe200000010ffULL, 0x0000000833317824ULL, 0x000fe200078e020eULL,
0x0000000743127812ULL, 0x000fe200078ec0ffULL, 0x0000000833337824ULL, 0x000fe200078e0202ULL,
0x000000141313723eULL, 0x000fe200000010ffULL, 0x0000000843147824ULL, 0x000fe200078e00ffULL,
0x000000100f0f723eULL, 0x000fe200000010ffULL, 0x0000000403107824ULL, 0x000fe200078e00ffULL,
0x0000000112027812ULL, 0x040fe200078e3cffULL, 0x0000001029297824ULL, 0x100fe200078e0200ULL,
0x0000000212067812ULL, 0x040fe200078e3cffULL, 0x000000102b2b7824ULL, 0x000fe200078e0200ULL,
0x0000000312087812ULL, 0x040fe200078e3cffULL, 0x0000000843377824ULL, 0x040fe200078e0202ULL,
0x00000004120a7812ULL, 0x040fe200078e3cffULL, 0x0000000843397824ULL, 0x042fe200078e0206ULL,
0x00000005120c7812ULL, 0x040fe200078e3cffULL, 0x00000008433d7824ULL, 0x040fe200078e0208ULL,
0x00000006120e7812ULL, 0x000fe200078e3cffULL, 0x00000008433f7824ULL, 0x000fe200078e020aULL,
0x0000001c1b1b723eULL, 0x000fe200000010ffULL, 0x0000000843417824ULL, 0x040fe200078e020cULL,
0xfffffff814357812ULL, 0x000fe200078ee243ULL, 0x0000000843437824ULL, 0x000fe200078e020eULL,
0x0000000c101c7812ULL, 0x000fe200078ec0ffULL, 0x0000001047067824ULL, 0x100fe200078e0200ULL,
0x000000282727723eULL, 0x000fe200000010ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0200ULL,
0x000000262525723eULL, 0x000fe200000010ffULL, 0x0000001035357824ULL, 0x100fe200078e0200ULL,
0x000000242323723eULL, 0x000fe200000010ffULL, 0x000000011c027824ULL, 0x000fe200078e0219ULL,
0x000000222121723eULL, 0x000fe200000010ffULL, 0x000000102f2f7824ULL, 0x100fe200078e0200ULL,
0x000000201f1f723eULL, 0x000fe200000010ffULL, 0x0000001031317824ULL, 0x100fe200078e0200ULL,
0x0000001e1d1d723eULL, 0x000fe200000010ffULL, 0x0000001033337824ULL, 0x100fe200078e0200ULL,
0x0000002702007388ULL, 0x0003e20000000800ULL, 0x0000001037377824ULL, 0x100fe200078e0200ULL,
0x0000001a0707723eULL, 0x000fe200000010ffULL, 0x0000001039397824ULL, 0x100fe200078e0200ULL,
0x000000181717723eULL, 0x000fe200000010ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0200ULL,
0x000000161515723eULL, 0x000fe200000010ffULL, 0x000000103f3f7824ULL, 0x000fc400078e0200ULL,
0x0000001041417824ULL, 0x100fe400078e0200ULL, 0x0000001043437824ULL, 0x000fe400078e0200ULL,
0x000000011c107824ULL, 0x040fe400078e0206ULL, 0x000000011c007824ULL, 0x040fe400078e0229ULL,
0x000000011c067824ULL, 0x040fe400078e022bULL, 0x000000011c087824ULL, 0x040fe200078e022dULL,
0x0000002500007388ULL, 0x0005e20000000800ULL, 0x000000011c0a7824ULL, 0x000fc400078e022fULL,
0x000000011c0c7824ULL, 0x040fe200078e0231ULL, 0x0000002306007388ULL, 0x000fe20000000800ULL,
0x000000011c0e7824ULL, 0x040fe400078e0233ULL, 0x000000011c127824ULL, 0x040fe200078e0235ULL,
0x0000002108007388ULL, 0x000fe20000000800ULL, 0x000000011c147824ULL, 0x040fe400078e0237ULL,
0x000000011c027824ULL, 0x042fe200078e0239ULL, 0x0000001f0a007388ULL, 0x000fe20000000800ULL,
0x000000011c167824ULL, 0x000fc400078e023dULL, 0x000000011c187824ULL, 0x040fe200078e023fULL,
0x0000001d0c007388ULL, 0x000fe20000000800ULL, 0x000000011c1e7824ULL, 0x040fe400078e0245ULL,
0x000000011c1a7824ULL, 0x040fe200078e0241ULL, 0x0000001b0e007388ULL, 0x000fe20000000800ULL,
0x000000011c1c7824ULL, 0x000fe400078e0243ULL, 0x0000002048207824ULL, 0x000fe200078e0203ULL,
0x0000000710007388ULL, 0x0003e60000000800ULL, 0x0000001020007824ULL, 0x004fe200078e0205ULL,
0x0000001712007388ULL, 0x000fe80000000800ULL, 0x0000001514007388ULL, 0x000fe20000000800ULL,
0x000000040410723eULL, 0x002fc600000010ffULL, 0x0000001302007388ULL, 0x000fe80000000800ULL,
0x0000001116007388ULL, 0x000fe80000000800ULL, 0x0000000f18007388ULL, 0x000fe80000000800ULL,
0x0000000d1a007388ULL, 0x000fe80000000800ULL, 0x0000000b1c007388ULL, 0x000fe80000000800ULL,
0x000000091e007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000207984ULL, 0x000e680000000c00ULL, 0x0004000000287984ULL, 0x000ea80000000c00ULL,
0x0008000000247984ULL, 0x000ee80000000c00ULL, 0x000c0000002c7984ULL, 0x000f220000000c00ULL,
0x3f803f8010237831ULL, 0x002fc40000200023ULL, 0x3f803f8010227831ULL, 0x040fe40000200022ULL,
0x3f803f8010217831ULL, 0x040fe40000200021ULL, 0x3f803f8010207831ULL, 0x040fe40000200020ULL,
0x3f803f80102b7831ULL, 0x044fe4000020002bULL, 0x3f803f80102a7831ULL, 0x040fe4000020002aULL,
0x3f803f8010297831ULL, 0x000fc40000200029ULL, 0x3f803f8010287831ULL, 0x000fe40000200028ULL,
0x3f803f8023237831ULL, 0x008fe40000200027ULL, 0x3f803f8022227831ULL, 0x000fe40000200026ULL,
0x3f803f8021217831ULL, 0x000fe40000200025ULL, 0x3f803f8020207831ULL, 0x000fe40000200024ULL,
0x3f803f802b2b7831ULL, 0x010fc4000020002fULL, 0x3f803f802a2a7831ULL, 0x000fe2000020002eULL,
0x0000002000007388ULL, 0x0003e20000000c00ULL, 0x3f803f8029297831ULL, 0x000fe4000020002dULL,
0x3f803f8028287831ULL, 0x000fca000020002cULL, 0x0004002800007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff4800720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002003117810ULL, 0x004fe20007ffe0ffULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x00000003ff107819ULL, 0x000fe20000011603ULL,
0x00000000000579c3ULL, 0x000f220000002700ULL, 0x00000003ff047819ULL, 0x000fe20000011611ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000710007812ULL, 0x002fe200078e4803ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000704027812ULL, 0x000fe200078e4811ULL,
0x000000083b127824ULL, 0x000fe200078e00ffULL, 0x0ffffff800007812ULL, 0x000fc400078ef803ULL,
0x0ffffff802027812ULL, 0x100fe400078ef811ULL, 0xfffffff812117812ULL, 0x000fe200078ee211ULL,
0x0000001000007824ULL, 0x100fe400078e0205ULL, 0x0000001002057824ULL, 0x000fc600078e0205ULL,
0x0000000000087984ULL, 0x0003680000000c00ULL, 0x00000000050c7984ULL, 0x0087620000000c00ULL,
0x0000000806077824ULL, 0x044fe400078e00ffULL, 0x0000000806137824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x010fe2000f8e023fULL, 0x000000083b007824ULL, 0x002fe200078e00ffULL,
0xfffffff807027812ULL, 0x000fc400078ee210ULL, 0xfffffff813047812ULL, 0x000fe400078ee204ULL,
0x0000000402107c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000404027c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff800037812ULL, 0x000fe200078ee203ULL, 0x000000ffff057224ULL, 0x008fe200000e06ffULL,
0x00005a0010047a11ULL, 0x000fe200078040ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005a0002067a11ULL, 0x000fc400078240ffULL, 0x00005b0010057a11ULL, 0x000fe400000f4405ULL,
0x00005b0002077a11ULL, 0x000fc600008f4407ULL, 0x0000001003027825ULL, 0x000fc800078e0004ULL,
0x0000001011047825ULL, 0x000fe200078e0006ULL, 0x0000000802007986ULL, 0x020fe8000c101d06ULL,
0x0000000c04007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff047624ULL, 0x000fe400078e00ffULL, 0x00006700ff057624ULL, 0x000fca00078e00ffULL,
0x00000006043c7981ULL, 0x000362000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000134007810ULL, 0x000fe20007ffe0ffULL, 0x000000023f3f7824ULL, 0x000fe200078e00ffULL,
0x00f60000ff047f8cULL, 0x002e62000c80043fULL, 0x0000004002377824ULL, 0x000fe200078e00ffULL,
0x000000350000720cULL, 0x000fe20003f06070ULL, 0x000058003f367a24ULL, 0x000fe400078e0236ULL,
0x00000100340b7824ULL, 0x000fc800078e0237ULL, 0x00006200361a7a24ULL, 0x000fcc00078e020bULL,
0x000005a000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1d7819ULL, 0x000fe20000011641ULL,
0x00000080ff217424ULL, 0x000fe200078e00ffULL, 0x000000300e1f7812ULL, 0x000fe400078ec0ffULL,
0x000000081d117810ULL, 0x040fe20007ffe0ffULL, 0x000000011d067824ULL, 0x140fe200078e021aULL,
0x000000101d237810ULL, 0x040fe40007ffe0ffULL, 0x000000181d257810ULL, 0x000fe20007ffe0ffULL,
0x0000000111087824ULL, 0x000fe200078e021aULL, 0x000000201d177810ULL, 0x000fe20007ffe0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0x0000000b03007217ULL, 0x000fc40007800000ULL,
0x000000281d197810ULL, 0x000fe20007ffe0ffULL, 0x00005e0008087625ULL, 0x000fe200078e0021ULL,
0x0000001f060e7210ULL, 0x080fe40007f1e0ffULL, 0x00000003ff147819ULL, 0x100fe20000011641ULL,
0x00000001230a7824ULL, 0x100fe200078e021aULL, 0x0000001f08087210ULL, 0x000fe20007f3e0ffULL,
0x00000001250c7824ULL, 0x000fe200078e021aULL, 0x0000000314147812ULL, 0x000fe200078e4841ULL,
0x000000011a067824ULL, 0x000fe200078e0217ULL, 0x0000100002167811ULL, 0x000fe200078e68ffULL,
0x0000000100007824ULL, 0x000fe200078e0a0bULL, 0x0ffffffc14417812ULL, 0x000fe200078ef841ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0021ULL, 0x000000301d1b7810ULL, 0x000fc40007ffe0ffULL,
0x000000001700720cULL, 0x080fe20003f66070ULL, 0x00005e000c0c7625ULL, 0x000fe200078e0021ULL,
0x000000002300720cULL, 0x080fe40003fa6070ULL, 0x000000002500720cULL, 0x000fe20003f86070ULL,
0x000000ffff0f7224ULL, 0x000fe200000e0607ULL, 0x0000001f0a0a7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0006067625ULL, 0x000fc800078e0021ULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x0000001f0c0c7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000001f06107210ULL, 0x000fe20007f5e0ffULL, 0x000000011a067824ULL, 0x000fe200078e0219ULL,
0x000000001d00720cULL, 0x080fe20003f06070ULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x000000001100720cULL, 0x0c0fe20003f26070ULL, 0x0000000411137824ULL, 0x000fe200078e00ffULL,
0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200010e0607ULL,
0x000000001900720cULL, 0x000fe20003f46070ULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0xfffffffc13137812ULL, 0x000fc600078ee214ULL, 0x0000001041417824ULL, 0x100fe200078e0216ULL,
0x0000001f06127210ULL, 0x000fe20007fde0ffULL, 0x0000001013157824ULL, 0x000fe400078e0216ULL,
0x000000011a067824ULL, 0x000fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e417faeULL, 0x0005e2000c101c46ULL, 0x000000ffff137224ULL, 0x000fe200030e0607ULL,
0x000000001d00720cULL, 0x080fe20003f06070ULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x0000000008157faeULL, 0x0007e2000c901c46ULL, 0x000000001b00720cULL, 0x000fc40003f26070ULL,
0x0000000417177824ULL, 0x000fe200078e00ffULL, 0x0000001f06067210ULL, 0x000fe20007fde0ffULL,
0x0000000419197824ULL, 0x000fe400078e00ffULL, 0x000000041b1b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc17177812ULL, 0x100fe200078ee214ULL, 0x00000004230f7824ULL, 0x004fe200078e00ffULL,
0xfffffffc19197812ULL, 0x100fe200078ee214ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0xfffffffc1b1b7812ULL, 0x100fe200078ee214ULL, 0x0000000425157824ULL, 0x008fe200078e00ffULL,
0xfffffffc0f0f7812ULL, 0x000fe200078ee214ULL, 0x000000011a087824ULL, 0x000fc400078e021dULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc15157812ULL, 0x000fe200078ee214ULL,
0x00005e0008087625ULL, 0x000fc600078e0021ULL, 0xfffffffc1d1d7812ULL, 0x000fe200078ee214ULL,
0x000000100f0f7824ULL, 0x100fe200078e0216ULL, 0x0000001f08087210ULL, 0x000fe20007fde0ffULL,
0x0000001015157824ULL, 0x100fe400078e0216ULL, 0x0000001017177824ULL, 0x100fe200078e0216ULL,
0x000000000a0f7faeULL, 0x0005e2000e901c46ULL, 0x0000001019197824ULL, 0x100fe400078e0216ULL,
0x000000101b1b7824ULL, 0x100fe200078e0216ULL, 0x000000000c157faeULL, 0x0005e2000e101c46ULL,
0x000000101d1d7824ULL, 0x000fc400078e0216ULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x0000000010177faeULL, 0x0005e8000d901c46ULL, 0x0000000012197faeULL, 0x0005e8000d101c46ULL,
0x00000000061b7faeULL, 0x0005e8000c901c46ULL, 0x00000000081d7faeULL, 0x0005e2000c101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x0000001041077811ULL, 0x040fe200078ff0ffULL,
0x00000080ff257424ULL, 0x000fe200078e00ffULL, 0x0000001a41067211ULL, 0x000fc400078ff0ffULL,
0x00000003ff007819ULL, 0x000fe20000011641ULL, 0x000000011a087824ULL, 0x000fe200078e0207ULL,
0x00000008410f7811ULL, 0x000fe200078ff0ffULL, 0x0000000407137824ULL, 0x000fe200078e00ffULL,
0x00000020410b7811ULL, 0x040fe200078ff0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0025ULL,
0x000000300e277812ULL, 0x000fe400078ec0ffULL, 0x0000001841097811ULL, 0x000fe200078ff0ffULL,
0x000000040f117824ULL, 0x040fe200078e00ffULL, 0x00000003001c7812ULL, 0x000fe200078e4841ULL,
0x000000010f007824ULL, 0x000fe200078e021aULL, 0x00000028410c7811ULL, 0x040fe200078ff0ffULL,
0x000000011a0f7824ULL, 0x000fe200078e020bULL, 0x00000030410d7811ULL, 0x000fe200078ff0ffULL,
0x000000040b0b7824ULL, 0x000fe200078e00ffULL, 0x0000002706107210ULL, 0x000fe20007f1e0ffULL,
0x000000011a0a7824ULL, 0x040fe200078e0209ULL, 0x00000038410e7811ULL, 0x000fe200078ff0ffULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b127812ULL, 0x000fe200078ee21cULL,
0x000000011a167824ULL, 0x000fe200078e020cULL, 0x0000100002237811ULL, 0x000fe200078e68ffULL,
0x000000040c157824ULL, 0x000fe200078e00ffULL, 0xfffffffc110c7812ULL, 0x000fe200078ee21cULL,
0x000000011a187824ULL, 0x000fe200078e020dULL, 0x0ffffffc1c417812ULL, 0x000fe200078ef841ULL,
0x000000ffff117224ULL, 0x000fc400000e0607ULL, 0x000000011a1a7824ULL, 0x000fe400078e020eULL,
0x000000040e197824ULL, 0x000fe200078e00ffULL, 0xfffffffc090e7812ULL, 0x000fe200078ee21cULL,
0x00005e0000067625ULL, 0x000fc800078e0025ULL, 0x000000040d177824ULL, 0x000fe200078e00ffULL,
0xfffffffc130d7812ULL, 0x100fe200078ee21cULL, 0x00005e0008087625ULL, 0x000fe200078e0025ULL,
0xfffffffc15137812ULL, 0x100fe400078ee21cULL, 0xfffffffc17157812ULL, 0x100fe200078ee21cULL,
0x00000010121d7824ULL, 0x100fe200078e0223ULL, 0x0000002706127210ULL, 0x000fe20007f1e0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0025ULL, 0x0000002708147210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc191c7812ULL, 0x000fe200078ee21cULL, 0x00000010131f7824ULL, 0x000fc400078e0223ULL,
0x000000ffff137224ULL, 0x000fe200000e0607ULL, 0x000000270a0a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001015217824ULL, 0x000fe400078e0223ULL, 0x000000ffff157224ULL, 0x000fe400008e0609ULL,
0x00005e000f067625ULL, 0x000fc800078e0025ULL, 0x000000100c177824ULL, 0x100fe400078e0223ULL,
0x000000100d197824ULL, 0x000fe400078e0223ULL, 0x00005e0016087625ULL, 0x000fc800078e0025ULL,
0x000000100e1b7824ULL, 0x000fe200078e0223ULL, 0x0000002708087210ULL, 0x000fe20007f3e0ffULL,
0x00005e00180c7625ULL, 0x000fc800078e0025ULL, 0x00005e001a0e7625ULL, 0x000fe200078e0025ULL,
0x000000270c0c7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000002706067210ULL, 0x080fe20007f1e0ffULL, 0x0000001041417824ULL, 0x000fe200078e0223ULL,
0x000000270e0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff097224ULL, 0x000fe400008e0609ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010417faeULL, 0x0005e2000b901c46ULL, 0x000000ffff0d7224ULL, 0x000fe400010e060dULL,
0x000000101c237824ULL, 0x000fe200078e0223ULL, 0x0000000012177faeULL, 0x0005e2000b901c46ULL,
0x000000ffff0f7224ULL, 0x000fc600018e060fULL, 0x0000000014197faeULL, 0x0005e8000b901c46ULL,
0x000000000a1b7faeULL, 0x0005e8000b901c46ULL, 0x00000000061d7faeULL, 0x0005e8000b901c46ULL,
0x00000000081f7faeULL, 0x0005e8000b901c46ULL, 0x000000000c217faeULL, 0x0005e8000b901c46ULL,
0x000000000e237faeULL, 0x0005e4000b901c46ULL, 0x00f60400ff077984ULL, 0x004ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000007ff7812ULL, 0x006fc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe20003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002002007824ULL, 0x002fc800078e0205ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7800ULL,
0x0000000707077812ULL, 0x000fc600078e7800ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001005007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff047f8cULL, 0x002fe8000c80043fULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000353400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000003d7919ULL, 0x000e620000000000ULL,
0x3db504f33c3c7820ULL, 0x020fe20000410000ULL, 0x0000f688023a7811ULL, 0x040fe200078e18ffULL,
0x000000ffff397224ULL, 0x000fe200078e00ffULL, 0xffffffff353b7810ULL, 0x000fe40007ffe0ffULL,
0x0000f60802387811ULL, 0x000fe400078e28ffULL, 0x00000100343e7824ULL, 0x000fe200078e0237ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003e0300720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e0039ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fc4000001ff00ULL, 0x0000000100247810ULL, 0x000fe20007ffe0ffULL,
0x00000a9000007945ULL, 0x000fe20003800000ULL, 0x000000ffff407224ULL, 0x000fe200078e0000ULL,
0x000000013f397812ULL, 0x000fc400078e0cffULL, 0x00000001ff257819ULL, 0x100fe20000011624ULL,
0x000000ffff007224ULL, 0x000fe200078e0024ULL, 0x000000022400780cULL, 0x000fc60003f06070ULL,
0x0000030025267a24ULL, 0x000fe200078e0234ULL, 0x0000000124257812ULL, 0x000fc600078ec0ffULL,
0x0000010026277824ULL, 0x040fe200078e0237ULL, 0x0000000126287810ULL, 0x000fc60007ffe0ffULL,
0x0000620036327a24ULL, 0x000fe200078e0227ULL, 0x000000352800720cULL, 0x000fda0003f26070ULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x0000002703247217ULL, 0x000fe20007800000ULL,
0x00000004252a7824ULL, 0x000fe200078e00ffULL, 0x00000002ff2d7819ULL, 0x002fe2000001163dULL,
0x0000000202307824ULL, 0x000fe200078e0239ULL, 0x00000003ff267819ULL, 0x000fe2000001163dULL,
0x0000000124287824ULL, 0x000fe200078e0a27ULL, 0x000000082d257810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000000326427812ULL, 0x100fe200078e483dULL,
0x000000012d247824ULL, 0x140fe200078e0232ULL, 0x000000282d00720cULL, 0x080fe20003f26070ULL,
0x0000000125267824ULL, 0x040fe200078e0232ULL, 0x000000282500720cULL, 0x040fe20003f46070ULL,
0x00000004252b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc2a317812ULL, 0x000fe200078ee23dULL,
0x00005e0024247625ULL, 0x000fe200078e002fULL, 0x0000100030307811ULL, 0x000fc400078e60ffULL,
0x0ffffffc42297812ULL, 0x000fe200078ef83dULL, 0x00005e0026267625ULL, 0x000fe200078e002fULL,
0xfffffffc2b2b7812ULL, 0x000fe400078ee242ULL, 0x000000102d337810ULL, 0x000fe20007ffe0ffULL,
0x0000001029297824ULL, 0x000fe200078e0230ULL, 0x000000182d417810ULL, 0x000fe20007ffe0ffULL,
0x0000001031247825ULL, 0x000fe200078e0024ULL, 0x000000202d437810ULL, 0x040fe40007ffe0ffULL,
0x000000282d457810ULL, 0x000fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0230ULL,
0x000000302d477810ULL, 0x000fe20007ffe0ffULL, 0x0000001031267825ULL, 0x000fe200078e0026ULL,
0x000000382d2d7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024297faeULL, 0x0003e2000c901c46ULL, 0x000000283300720cULL, 0x080fe20003f26070ULL,
0x00000001452a7824ULL, 0x100fe200078e0232ULL, 0x000000284300720cULL, 0x080fe20003f66070ULL,
0x00000000262b7faeULL, 0x0005e2000d101c46ULL, 0x000000284100720cULL, 0x080fe20003f46070ULL,
0x00000001472c7824ULL, 0x100fe200078e0232ULL, 0x000000284500720cULL, 0x080fe20003f86070ULL,
0x000000012d2e7824ULL, 0x100fe200078e0232ULL, 0x000000284700720cULL, 0x080fe20003fa6070ULL,
0x000000042d497824ULL, 0x040fe200078e00ffULL, 0x000000282d00720cULL, 0x000fe20003fc6070ULL,
0x0000000133247824ULL, 0x002fc400078e0232ULL, 0x0000000143287824ULL, 0x000fe200078e0232ULL,
0xfffffffc49497812ULL, 0x000fe200078ee242ULL, 0x0000000141267824ULL, 0x004fe400078e0232ULL,
0x0000000433337824ULL, 0x000fe400078e00ffULL, 0x0000000441417824ULL, 0x000fe400078e00ffULL,
0x0000000443437824ULL, 0x000fe200078e00ffULL, 0xfffffffc33337812ULL, 0x100fe200078ee242ULL,
0x00005e0024247625ULL, 0x000fe200078e002fULL, 0xfffffffc41417812ULL, 0x000fc400078ee242ULL,
0xfffffffc43437812ULL, 0x000fe200078ee242ULL, 0x00005e0026267625ULL, 0x000fc800078e002fULL,
0x00005e0028287625ULL, 0x000fc800078e002fULL, 0x00005e002a2a7625ULL, 0x000fc800078e002fULL,
0x00005e002c2c7625ULL, 0x000fc800078e002fULL, 0x0000000445457824ULL, 0x000fe400078e00ffULL,
0x00005e002e2e7625ULL, 0x000fc600078e002fULL, 0xfffffffc45457812ULL, 0x000fe200078ee242ULL,
0x0000000447477824ULL, 0x000fe400078e00ffULL, 0x0000001031247825ULL, 0x000fc600078e0024ULL,
0xfffffffc47477812ULL, 0x000fe200078ee242ULL, 0x0000001031267825ULL, 0x000fc800078e0026ULL,
0x0000001031287825ULL, 0x000fc800078e0028ULL, 0x00000010312a7825ULL, 0x000fc800078e002aULL,
0x00000010312c7825ULL, 0x000fc800078e002cULL, 0x00000010312e7825ULL, 0x000fc800078e002eULL,
0x0000001033317824ULL, 0x100fe400078e0230ULL, 0x0000001041337824ULL, 0x100fe400078e0230ULL,
0x0000001043417824ULL, 0x100fe200078e0230ULL, 0x0000000024317faeULL, 0x0003e2000c901c46ULL,
0x0000001045437824ULL, 0x100fe400078e0230ULL, 0x0000001047457824ULL, 0x100fe200078e0230ULL,
0x0000000026337faeULL, 0x0003e2000d101c46ULL, 0x0000001049477824ULL, 0x000fc600078e0230ULL,
0x0000000028417faeULL, 0x0003e8000d901c46ULL, 0x000000002a437faeULL, 0x0003e8000e101c46ULL,
0x000000002c457faeULL, 0x0003e8000e901c46ULL, 0x000000002e477faeULL, 0x0003e2000f101c46ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x0000000425287824ULL, 0x000fe200078e00ffULL,
0x00000003ff267819ULL, 0x002fe2000001163dULL, 0x0000000202257824ULL, 0x000fe200078e0239ULL,
0x000000083d277811ULL, 0x040fe200078ff0ffULL, 0x00000080ff337424ULL, 0x000fe200078e00ffULL,
0x000000103d297811ULL, 0x000fc400078ff0ffULL, 0x000000183d2b7811ULL, 0x040fe400078ff0ffULL,
0x000000203d2d7811ULL, 0x040fe400078ff0ffULL, 0x000000283d2f7811ULL, 0x000fe200078ff0ffULL,
0x000000012b2a7824ULL, 0x100fe200078e0232ULL, 0x000000303d317811ULL, 0x000fe200078ff0ffULL,
0x000000012d2c7824ULL, 0x100fe200078e0232ULL, 0x000000383d437811ULL, 0x000fe200078ff0ffULL,
0x000000012f2e7824ULL, 0x100fe200078e0232ULL, 0xfffffffc28417812ULL, 0x100fe200078ee23dULL,
0x0000000129287824ULL, 0x100fe200078e0232ULL, 0x0000000326427812ULL, 0x000fe200078e483dULL,
0x0000000127267824ULL, 0x100fe200078e0232ULL, 0x000000323d247211ULL, 0x000fe200078ff0ffULL,
0x0000000131307824ULL, 0x000fe200078e0232ULL, 0x00001000254d7811ULL, 0x000fe200078e60ffULL,
0x0000000427277824ULL, 0x000fc400078e00ffULL, 0x0000000429297824ULL, 0x000fe400078e00ffULL,
0x000000042b2b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc27447812ULL, 0x100fe200078ee242ULL,
0x000000042d2d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc29467812ULL, 0x100fe200078ee242ULL,
0x000000042f2f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc2b487812ULL, 0x100fe200078ee242ULL,
0x0000000431317824ULL, 0x000fe200078e00ffULL, 0xfffffffc2d4a7812ULL, 0x000fe200078ee242ULL,
0x0000000143327824ULL, 0x000fe200078e0232ULL, 0xfffffffc2f4c7812ULL, 0x100fe200078ee242ULL,
0x0000000443437824ULL, 0x000fe200078e00ffULL, 0xfffffffc314e7812ULL, 0x000fe200078ee242ULL,
0x00005e0024247625ULL, 0x000fc600078e0033ULL, 0xfffffffc43507812ULL, 0x000fe200078ee242ULL,
0x00005e0026267625ULL, 0x000fe200078e0033ULL, 0x0ffffffc42427812ULL, 0x000fc600078ef83dULL,
0x00005e0028287625ULL, 0x000fc800078e0033ULL, 0x00005e002a2a7625ULL, 0x000fc800078e0033ULL,
0x00005e002c2c7625ULL, 0x000fc800078e0033ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0033ULL,
0x00005e0030307625ULL, 0x000fc800078e0033ULL, 0x00005e0032327625ULL, 0x000fc800078e0033ULL,
0x0000001041247825ULL, 0x000fc800078e0024ULL, 0x0000001041267825ULL, 0x000fc800078e0026ULL,
0x0000001041287825ULL, 0x000fc800078e0028ULL, 0x00000010412a7825ULL, 0x000fc800078e002aULL,
0x00000010412c7825ULL, 0x000fc800078e002cULL, 0x00000010412e7825ULL, 0x000fc800078e002eULL,
0x0000001041307825ULL, 0x000fc800078e0030ULL, 0x0000001041327825ULL, 0x000fc800078e0032ULL,
0x00000010424f7824ULL, 0x100fe400078e024dULL, 0x0000001044417824ULL, 0x100fe400078e024dULL,
0x0000001046437824ULL, 0x100fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000244f7faeULL, 0x0003e2000b901c46ULL, 0x0000001048457824ULL, 0x100fe400078e024dULL,
0x000000104a477824ULL, 0x100fe200078e024dULL, 0x0000000026417faeULL, 0x0003e2000b901c46ULL,
0x000000104c497824ULL, 0x000fc400078e024dULL, 0x000000104e4b7824ULL, 0x100fe200078e024dULL,
0x0000000028437faeULL, 0x0003e2000b901c46ULL, 0x00000010504d7824ULL, 0x000fc600078e024dULL,
0x000000002a457faeULL, 0x0003e8000b901c46ULL, 0x000000002c477faeULL, 0x0003e8000b901c46ULL,
0x000000002e497faeULL, 0x0003e8000b901c46ULL, 0x00000000304b7faeULL, 0x0003e8000b901c46ULL,
0x00000000324d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000840427824ULL, 0x000fc400078e00ffULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff83d247812ULL, 0x002fe200078ec0ffULL, 0x0000000202287824ULL, 0x000fe200078e023fULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000001402a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000724247812ULL, 0x000fe400078ef83dULL, 0x0000100028287811ULL, 0x000fe400078e60ffULL,
0x00000001ff257819ULL, 0x000fc40000011624ULL, 0x000000073dcc7812ULL, 0x000fe400078ec0ffULL,
0x0000000325257812ULL, 0x000fe400078ec0ffULL, 0x00000008cccc7812ULL, 0x000fe400078ef83dULL,
0x0000004025277212ULL, 0x040fe400078e3cffULL, 0x0000002a25257212ULL, 0x000fc600078e3cffULL,
0x0000000424277824ULL, 0x040fe400078e0227ULL, 0x0000000424257824ULL, 0x000fe200078e0225ULL,
0x000000203d247810ULL, 0x000fe20007ffe0ffULL, 0x0000001027277824ULL, 0x100fe400078e0228ULL,
0x0000001025257824ULL, 0x000fe200078e0228ULL, 0xfffffff824247812ULL, 0x000fe400078ec0ffULL,
0x000000002730783bULL, 0x000e640000000200ULL, 0x0000000724297812ULL, 0x000fc400078ef83dULL,
0x00000000252c783bULL, 0x0004e40000000200ULL, 0x00000001ff247819ULL, 0x000fc80000011629ULL,
0x00000003242b7812ULL, 0x000fc800078ec0ffULL, 0x000000402b247212ULL, 0x040fe400078e3cffULL,
0x0000002a2b2a7212ULL, 0x000fe400078e3cffULL, 0x0000000240407810ULL, 0x000fe20007ffe0ffULL,
0x0000000429257824ULL, 0x044fe400078e0224ULL, 0x0000000429297824ULL, 0x000fe400078e022aULL,
0x0000001025257824ULL, 0x100fe400078e0228ULL, 0x0000001029297824ULL, 0x000fc800078e0228ULL,
0x000000002524783bULL, 0x000ea80000000200ULL, 0x000000002928783bULL, 0x000f220000000200ULL,
0x0000003000717306ULL, 0x002fe20000009400ULL, 0x00000018ffad7819ULL, 0x000fe20000011430ULL,
0x00010000305c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe20000011431ULL,
0x000100002c777824ULL, 0x048fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe20000011433ULL,
0x000100002d7a7824ULL, 0x040fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fe2000001145cULL,
0x0000003000a67306ULL, 0x000e620000005400ULL, 0x00000018ff947819ULL, 0x000fe20000011432ULL,
0x000001002c7c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x000001002e697824ULL, 0x040fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe2000001142cULL,
0x000001002d7f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x00000030005b7306ULL, 0x000762000000d400ULL, 0x00000018ff607819ULL, 0x000fe2000001142dULL,
0x000100002e727824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fc4000001147cULL,
0x00000018ff567819ULL, 0x000fe4000001142eULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x000000a700a87306ULL, 0x000fe20000209400ULL, 0x0000010030307824ULL, 0x008fe200078e00ffULL,
0x000000a67100720bULL, 0x002fe40003f9d000ULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0001000024c47824ULL, 0x004fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe20000011430ULL,
0x0001000031307824ULL, 0x000fe200078e00ffULL, 0x000000a700a97306ULL, 0x000e620000205400ULL,
0x00000018ff9d7819ULL, 0x000fc40000011424ULL, 0x00000018ff917819ULL, 0x000fe40000011425ULL,
0x00000018ffb07819ULL, 0x000fe20000011430ULL, 0x0001000032307824ULL, 0x000fe200078e00ffULL,
0x000000015b5b4812ULL, 0x020fe200078efcffULL, 0x0000003100a27306ULL, 0x000fe20000009400ULL,
0x00000018ffc47819ULL, 0x000fe400000114c4ULL, 0x00000018ffb87819ULL, 0x000fe20000011430ULL,
0x0001000033307824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fc40000011426ULL,
0x00000018ff837819ULL, 0x000fe20000011427ULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x000000a9a800720bULL, 0x002fe20003f5d000ULL, 0x0000010025a87824ULL, 0x000fe200078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe20000011430ULL, 0x0001000026a97824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x000000b000b27306ULL, 0x000e620000205400ULL, 0x00000018ffa97819ULL, 0x000fc400000114a9ULL,
0x000000a800cb7245ULL, 0x000fe4000020d400ULL, 0x00000018ff4c7819ULL, 0x000fc6000001142fULL,
0x0000003100a37306ULL, 0x000eb00000005400ULL, 0x0000003200a07306ULL, 0x000fe20000009400ULL,
0x000000b2b100720bULL, 0x002fce0003fbd000ULL, 0x0000003200a17306ULL, 0x000e620000005400ULL,
0x000000a3a200720bULL, 0x004fe40003f3d000ULL, 0x000000a700a27245ULL, 0x000fe4000020d400ULL,
0x000000aa00a37245ULL, 0x000fe4000020d400ULL, 0x00000001a2a22812ULL, 0x000fe200078efcffULL,
0x000000b800b97306ULL, 0x000fe60000209400ULL, 0x0000005ba2a2723eULL, 0x000fca00000010ffULL,
0x000000b800ba7306ULL, 0x0004e20000205400ULL, 0x000000a1a000720bULL, 0x002fe40003f5d000ULL,
0x000000b000a17245ULL, 0x000fe4000020d400ULL, 0x000000ad00a07245ULL, 0x000fe4000020d400ULL,
0x00000001a1a15812ULL, 0x000fe200078efcffULL, 0x000000aa00ab7306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x004fce000020d400ULL, 0x000000aa00ac7306ULL, 0x000e620000205400ULL,
0x000000bab900720bULL, 0x008fce0003fbd000ULL, 0x00000031005a7306ULL, 0x0004ec000000d400ULL,
0x00000001b8b85812ULL, 0x000fe400078efcffULL, 0x0000009f00b67306ULL, 0x000fe20000209400ULL,
0x0000010031317824ULL, 0x004fe200078e00ffULL, 0x000000acab00720bULL, 0x002fc80003f7d000ULL,
0x00000018ffb37819ULL, 0x000fe40000011431ULL, 0x0000009f00b77306ULL, 0x000e620000205400ULL,
0x000000015a5a1812ULL, 0x008fc800078efcffULL, 0x0000005aa15a723eULL, 0x000fe400000010ffULL,
0x00000001a3a33812ULL, 0x000fe200078efcffULL, 0x000000be00bf7306ULL, 0x000ff00000209400ULL,
0x000000be00c07306ULL, 0x0004e20000205400ULL, 0x000000b7b600720bULL, 0x002fce0003f9d000ULL,
0x000000ad00ae7306ULL, 0x000fe20000209400ULL, 0x000000be00be7245ULL, 0x004fce000020d400ULL,
0x000000ad00af7306ULL, 0x000e620000205400ULL, 0x000000c0bf00720bULL, 0x008fce0003fbd000ULL,
0x00000024008d7306ULL, 0x000fec0000009400ULL, 0x00000001bebe5812ULL, 0x000fe400078efcffULL,
0x0000002400907306ULL, 0x000ea20000005400ULL, 0x000000afae00720bULL, 0x002fce0003fdd000ULL,
0x0000002400527306ULL, 0x0003ec000000d400ULL, 0x00000001a0a06812ULL, 0x000fe400078efcffULL,
0x0000003200577306ULL, 0x000762000000d400ULL, 0x0000010024247824ULL, 0x002fe200078e00ffULL,
0x000000908d00720bULL, 0x004fc40003fbd000ULL, 0x000000c4008d7245ULL, 0x000fe4000020d400ULL,
0x00000018ffc77819ULL, 0x000fe20000011424ULL, 0x0001000025247824ULL, 0x000fe200078e00ffULL,
0x0000008400967306ULL, 0x000fe20000209400ULL, 0x0000010032327824ULL, 0x008fe200078e00ffULL,
0x0000009100907245ULL, 0x000fe4000020d400ULL, 0x00000018ffca7819ULL, 0x000fe40000011424ULL,
0x00000018ffbb7819ULL, 0x000fe20000011432ULL, 0x000001002f327824ULL, 0x000fe200078e00ffULL,
0x0000008400937306ULL, 0x0002a20000205400ULL, 0x0000000157572812ULL, 0x020fc400078efcffULL,
0x0000000152525812ULL, 0x000fe400078efcffULL, 0x000000bb00b97245ULL, 0x000fe4000020d400ULL,
0x000000423d247211ULL, 0x000fe200078fe0ffULL, 0x0000002c00957306ULL, 0x000fe20000009400ULL,
0x0000008400847245ULL, 0x002fe4000020d400ULL, 0x0000000224717810ULL, 0x040fe40007ffe0ffULL,
0x0000000724247812ULL, 0x000fc400078e78ccULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000002c009a7306ULL, 0x000e620000005400ULL, 0x000000939600720bULL, 0x004fe20003f5d000ULL,
0x00000010cc247824ULL, 0x000fe200078e0224ULL, 0x0000000771717812ULL, 0x000fe400078e78ccULL,
0x00000057b8b8723eULL, 0x000fe200000010ffULL, 0x0000001024247824ULL, 0x000fe200078e00ffULL,
0x000000a3a0a3723eULL, 0x000fe200000010ffULL, 0x000000b300b47306ULL, 0x000fe20000209400ULL,
0x00000010cc717824ULL, 0x000fe200078e0271ULL, 0x0000000442427810ULL, 0x000fc80007ffe0ffULL,
0x0000000184842812ULL, 0x000fe400078efcffULL, 0x000000b300b57306ULL, 0x000ea20000205400ULL,
0x0000009a9500720bULL, 0x002fe40003f3d000ULL, 0x0000009f009a7245ULL, 0x000fe2000020d400ULL,
0x00000100279f7824ULL, 0x000fc600078e00ffULL, 0x000000019a9a4812ULL, 0x000fe200078efcffULL,
0x0000009400997306ULL, 0x000fe20000209400ULL, 0x00000018ff9f7819ULL, 0x000fce000001149fULL,
0x00000094009c7306ULL, 0x0002e20000205400ULL, 0x000000b5b400720bULL, 0x004fce0003f7d000ULL,
0x00000033009e7306ULL, 0x000fe20000009400ULL, 0x0000009400947245ULL, 0x002fce000020d400ULL,
0x00000033009b7306ULL, 0x000e620000005400ULL, 0x0000009c9900720bULL, 0x008fe20003f9d000ULL,
0x0001000027997824ULL, 0x000fca00078e00ffULL, 0x00000018ff997819ULL, 0x000fe20000011499ULL,
0x00000025008b7306ULL, 0x000fec0000009400ULL, 0x0000000194944812ULL, 0x000fe400078efcffULL,
0x0000002500887306ULL, 0x000fe20000005400ULL, 0x0000009b9e00720bULL, 0x002fc40003fdd000ULL,
0x000000b3009b7245ULL, 0x000fc8000020d400ULL, 0x000000019b9b3812ULL, 0x000fe200078efcffULL,
0x00000025004d7306ULL, 0x000fe6000000d400ULL, 0x0000009b9a5b723eULL, 0x000fca00000010ffULL,
0x000000ca00a67306ULL, 0x000ff00000209400ULL, 0x000000ca00257306ULL, 0x0002b00000205400ULL,
0x000000bb00bc7306ULL, 0x000fe20000209400ULL, 0x000000ca00ca7245ULL, 0x002fce000020d400ULL,
0x000000bb00bd7306ULL, 0x000e620000205400ULL, 0x00000025a600720bULL, 0x004fce0003f5d000ULL,
0x0000003300537306ULL, 0x0004ec000000d400ULL, 0x00000001caca2812ULL, 0x000fe400078efcffULL,
0x000000c400c57306ULL, 0x000fe20000209400ULL, 0x0000010033337824ULL, 0x004fe200078e00ffULL,
0x000000bdbc00720bULL, 0x002fc80003f7d000ULL, 0x00000018ffc17819ULL, 0x000fe20000011433ULL,
0x000100002f337824ULL, 0x000fe200078e00ffULL, 0x000000c400c67306ULL, 0x000e620000205400ULL,
0x0000000153536812ULL, 0x008fe400078efcffULL, 0x000000c100bf7245ULL, 0x000fe4000020d400ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x00000001b9b93812ULL, 0x000fe200078efcffULL,
0x000000a800a77306ULL, 0x000fe20000209400ULL, 0x00000053bebe723eULL, 0x000fc400000010ffULL,
0x000000b994b9723eULL, 0x000fca00000010ffULL, 0x000000a800aa7306ULL, 0x000ea20000205400ULL,
0x000000c6c500720bULL, 0x002fce0003f9d000ULL, 0x0000009d00a57306ULL, 0x000fec0000209400ULL,
0x000000018d8d4812ULL, 0x000fe400078efcffULL, 0x0000009d00a47306ULL, 0x000e620000205400ULL,
0x000000aaa700720bULL, 0x004fe40003fbd000ULL, 0x000000888b00720bULL, 0x000fc40003f9d000ULL,
0x0000009d00887245ULL, 0x000fe4000020d400ULL, 0x000000528d52723eULL, 0x000fe200000010ffULL,
0x000000a9009e7306ULL, 0x000fec0000209400ULL, 0x00000001cbcb5812ULL, 0x000fe400078efcffULL,
0x000000a900957306ULL, 0x000ea20000205400ULL, 0x000000a4a500720bULL, 0x002fc40003fdd000ULL,
0x000000014d4d4812ULL, 0x000fc800078efcffULL, 0x0000004dcaca723eULL, 0x000fe200000010ffULL,
0x000000c100c27306ULL, 0x000fec0000209400ULL, 0x0000000188886812ULL, 0x000fe400078efcffULL,
0x000000c100c37306ULL, 0x000e620000205400ULL, 0x000000959e00720bULL, 0x004fce0003f5d000ULL,
0x0000008e00927306ULL, 0x000ff00000209400ULL, 0x0000008e008f7306ULL, 0x0004e20000205400ULL,
0x000000c3c200720bULL, 0x002fce0003f7d000ULL, 0x0000002700757306ULL, 0x000fe20000009400ULL,
0x0000008e008e7245ULL, 0x004fca000020d400ULL, 0x00000001bfbf3812ULL, 0x000fe400078efcffULL,
0x0000002700767306ULL, 0x000e620000005400ULL, 0x0000008f9200720bULL, 0x008fe40003fbd000ULL,
0x000000a900927245ULL, 0x000fe4000020d400ULL, 0x000000bf84bf723eULL, 0x000fe400000010ffULL,
0x0000000192922812ULL, 0x000fe200078efcffULL, 0x0000009100977306ULL, 0x000fec0000209400ULL,
0x000000018e8e5812ULL, 0x000fc400078efcffULL, 0x0000009100987306ULL, 0x000ea20000205400ULL,
0x000000767500720bULL, 0x002fe40003f5d000ULL, 0x0000007700767245ULL, 0x000fca000020d400ULL,
0x000000c700c87306ULL, 0x000ff00000209400ULL, 0x000000c700c97306ULL, 0x0002e20000205400ULL,
0x000000989700720bULL, 0x004fce0003fdd000ULL, 0x00000026007d7306ULL, 0x000fe20000009400ULL,
0x000000c700c77245ULL, 0x002fca000020d400ULL, 0x0000000190906812ULL, 0x000fe400078efcffULL,
0x00000026007e7306ULL, 0x000e620000005400ULL, 0x000000c9c800720bULL, 0x008fe40003f7d000ULL,
0x000000cb90cb723eULL, 0x000fca00000010ffULL, 0x00000026004b7306ULL, 0x0004ec000000d400ULL,
0x00000001c7c73812ULL, 0x000fe400078efcffULL, 0x00000027004a7306ULL, 0x000f62000000d400ULL,
0x0000010026267824ULL, 0x004fe200078e00ffULL, 0x0000007e7d00720bULL, 0x002fc40003f7d000ULL,
0x000000c78853723eULL, 0x000fe400000010ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000007700877306ULL, 0x000fe20000209400ULL, 0x00000018ff7d7819ULL, 0x010fcc000001142aULL,
0x000000014b4b3812ULL, 0x008fe200078efcffULL, 0x00000077008a7306ULL, 0x0002a20000205400ULL,
0x000000014a4a2812ULL, 0x020fe400078efcffULL, 0x0000004b9292723eULL, 0x000fca00000010ffULL,
0x0000009900937306ULL, 0x000fe20000209400ULL, 0x0000007c00777245ULL, 0x002fce000020d400ULL,
0x00000099009c7306ULL, 0x0002e20000205400ULL, 0x0000008a8700720bULL, 0x004fce0003f5d000ULL,
0x0000002600277306ULL, 0x000fe20000209400ULL, 0x0000009900997245ULL, 0x002fca000020d400ULL,
0x0000000176762812ULL, 0x000fe400078efcffULL, 0x0000002600967306ULL, 0x000e620000205400ULL,
0x0000009c9300720bULL, 0x008fe40003fdd000ULL, 0x0000002600937245ULL, 0x000fca000020d400ULL,
0x0000006200637306ULL, 0x000fec0000209400ULL, 0x0000000199996812ULL, 0x000fe400078efcffULL,
0x0000006200667306ULL, 0x0004e20000205400ULL, 0x000000962700720bULL, 0x002fe40003f9d000ULL,
0x0000004a994a723eULL, 0x000fca00000010ffULL, 0x0000008300897306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x004fca000020d400ULL, 0x0000000193934812ULL, 0x000fe400078efcffULL,
0x00000083008c7306ULL, 0x000e620000205400ULL, 0x000000666300720bULL, 0x008fe40003f5d000ULL,
0x000000938e93723eULL, 0x000fca00000010ffULL, 0x0000009f00257306ULL, 0x000fec0000209400ULL,
0x0000000162622812ULL, 0x000fe400078efcffULL, 0x0000009f00987306ULL, 0x0004e20000205400ULL,
0x0000008c8900720bULL, 0x002fce0003fdd000ULL, 0x0000002c00457306ULL, 0x000322000000d400ULL,
0x0000009f009f7245ULL, 0x004fce000020d400ULL, 0x0000007a007b7306ULL, 0x000fe20000209400ULL,
0x000000982500720bULL, 0x008fe40003f7d000ULL, 0x000000002424783bULL, 0x000ea20000000200ULL,
0x00000018ff2c7819ULL, 0x002fc80000011428ULL, 0x0000007a00807306ULL, 0x000e620000205400ULL,
0x0000000145451812ULL, 0x010fc800078efcffULL, 0x000000457676723eULL, 0x000fe400000010ffULL,
0x000000019f9f3812ULL, 0x000fe200078efcffULL, 0x0000002d006f7306ULL, 0x000ff00000009400ULL,
0x0000002d00707306ULL, 0x000ee20000005400ULL, 0x000000807b00720bULL, 0x002fe20003f3d000ULL,
0x00010000297b7824ULL, 0x000fc400078e00ffULL, 0x000001002a807824ULL, 0x000fc600078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000002f005e7306ULL, 0x000fe20000009400ULL,
0x00000018ff807819ULL, 0x000fce0000011480ULL, 0x0000002f005f7306ULL, 0x000e620000005400ULL,
0x000000706f00720bULL, 0x008fe40003f9d000ULL, 0x0000008300707245ULL, 0x000fe2000020d400ULL,
0x0000005a241c723cULL, 0x044fe2000004181cULL, 0x00000018ff6f7819ULL, 0x000fe4000001142bULL,
0x0000000170706812ULL, 0x000fe200078efcffULL, 0x0000006000647306ULL, 0x000fe60000209400ULL,
0x0000009f704b723eULL, 0x000fe200000010ffULL, 0x000000a22414723cULL, 0x000fe80000041814ULL,
0x0000006000617306ULL, 0x0004e20000205400ULL, 0x0000005f5e00720bULL, 0x002fc40003fdd000ULL,
0x0000007a005f7245ULL, 0x000fe2000020d400ULL, 0x000000b82420723cULL, 0x000fe60000041820ULL,
0x000000015f5f1812ULL, 0x000fe200078efcffULL, 0x0000007c00867306ULL, 0x000fe20000209400ULL,
0x0000006000607245ULL, 0x004fc6000020d400ULL, 0x000000be2418723cULL, 0x000fe80000041818ULL,
0x0000007c00857306ULL, 0x0002a20000205400ULL, 0x000000616400720bULL, 0x008fc60003f5d000ULL,
0x000000522410723cULL, 0x000fe80000041810ULL, 0x0000005600687306ULL, 0x000fe20000209400ULL,
0x000100002a7c7824ULL, 0x002fc600078e00ffULL, 0x000000ca240c723cULL, 0x040fe4000004180cULL,
0x0000000160602812ULL, 0x000fe400078efcffULL, 0x0000005600657306ULL, 0x0002e20000205400ULL,
0x000000858600720bULL, 0x004fe20003f7d000ULL, 0x0001000028857824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x000000922408723cULL, 0x000fe60000041808ULL,
0x00000018ff857819ULL, 0x000fe20000011485ULL, 0x0000006900737306ULL, 0x000fe20000209400ULL,
0x0000005600567245ULL, 0x002fc6000020d400ULL, 0x0000004a2404723cULL, 0x000fe40000041804ULL,
0x0000000177773812ULL, 0x000fe400078efcffULL, 0x0000006900747306ULL, 0x000e620000205400ULL,
0x000000656800720bULL, 0x008fe40003f3d000ULL, 0x0000007c00257245ULL, 0x000fe4000020d400ULL,
0x000000776277723eULL, 0x000fc600000010ffULL, 0x0000007f00817306ULL, 0x000fec0000209400ULL,
0x0000000156561812ULL, 0x000fe400078efcffULL, 0x0000007f00827306ULL, 0x0004e20000205400ULL,
0x000000747300720bULL, 0x002fe40003f5d000ULL, 0x0000006900737245ULL, 0x000fca000020d400ULL,
0x0000002e006e7306ULL, 0x000fe20000009400ULL, 0x0000007f007f7245ULL, 0x004fca000020d400ULL,
0x0000000173732812ULL, 0x000fe400078efcffULL, 0x0000002e006d7306ULL, 0x000e620000005400ULL,
0x000000828100720bULL, 0x008fe20003f7d000ULL, 0x000100002b817824ULL, 0x040fe200078e00ffULL,
0x000000735673723eULL, 0x000fe200000010ffULL, 0x000001002b827824ULL, 0x000fc600078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x00000032005c7306ULL, 0x000fe20000209400ULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x0000008100267245ULL, 0x000fc6000020d400ULL,
0x000000017f7f3812ULL, 0x000fe400078efcffULL, 0x00000032005d7306ULL, 0x000ea20000205400ULL,
0x0000006d6e00720bULL, 0x002fe40003fbd000ULL, 0x0000007f6045723eULL, 0x000fca00000010ffULL,
0x0000002900557306ULL, 0x000ff00000009400ULL, 0x0000002900547306ULL, 0x000e620000005400ULL,
0x0000005d5c00720bULL, 0x004fce0003f3d000ULL, 0x0000007200787306ULL, 0x000ff00000209400ULL,
0x0000007200797306ULL, 0x0004e20000205400ULL, 0x000000545500720bULL, 0x002fe40003f5d000ULL,
0x0000003200557245ULL, 0x000fc4000020d400ULL, 0x0000003300547245ULL, 0x000fe4000020d400ULL,
0x0000000155551812ULL, 0x000fe200078efcffULL, 0x0000002d00447306ULL, 0x000322000000d400ULL,
0x0000007200727245ULL, 0x004fe4000020d400ULL, 0x0000008500327245ULL, 0x000fca000020d400ULL,
0x0000002e00437306ULL, 0x000ea2000000d400ULL, 0x000000797800720bULL, 0x008fe40003f7d000ULL,
0x00000018ff2d7819ULL, 0x002fca0000011429ULL, 0x0000004c00677306ULL, 0x000fe20000209400ULL,
0x0000000144444812ULL, 0x010fc800078efcffULL, 0x000000445f44723eULL, 0x000fe400000010ffULL,
0x0000000172723812ULL, 0x000fe200078efcffULL, 0x0000004c006a7306ULL, 0x0002e20000205400ULL,
0x0000000143435812ULL, 0x004fc800078efcffULL, 0x000000437272723eULL, 0x000fc600000010ffULL,
0x00000033006b7306ULL, 0x000fe20000209400ULL, 0x0000004c004c7245ULL, 0x002fce000020d400ULL,
0x00000033006c7306ULL, 0x000e620000205400ULL, 0x0000006a6700720bULL, 0x008fce0003f9d000ULL,
0x00000085005e7306ULL, 0x000fec0000209400ULL, 0x000000014c4c4812ULL, 0x000fe400078efcffULL,
0x0000008500637306ULL, 0x000ea20000205400ULL, 0x0000006c6b00720bULL, 0x002fe40003fbd000ULL,
0x000000554c55723eULL, 0x000fca00000010ffULL, 0x0000002800597306ULL, 0x000fec0000009400ULL,
0x0000000154545812ULL, 0x000fe400078efcffULL, 0x0000002800587306ULL, 0x000e620000005400ULL,
0x000000635e00720bULL, 0x004fce0003f3d000ULL, 0x0000002800497306ULL, 0x0004ec000000d400ULL,
0x0000000132321812ULL, 0x000fe400078efcffULL, 0x0000002a004f7306ULL, 0x000fe20000009400ULL,
0x0000010028287824ULL, 0x004fe200078e00ffULL, 0x000000585900720bULL, 0x002fc80003f7d000ULL,
0x00000018ff667819ULL, 0x000fe20000011428ULL, 0x0000001071287824ULL, 0x000fe200078e00ffULL,
0x0000002a004e7306ULL, 0x000e640000005400ULL, 0x0000006600337245ULL, 0x000fca000020d400ULL,
0x0000000149493812ULL, 0x008fe200078efcffULL, 0x00000066007a7306ULL, 0x000fe60000209400ULL,
0x000000493232723eULL, 0x000fca00000010ffULL, 0x0000006600617306ULL, 0x000ea20000205400ULL,
0x0000004e4f00720bULL, 0x002fce0003fbd000ULL, 0x0000002c00307306ULL, 0x000ff00000209400ULL,
0x0000002c00317306ULL, 0x0002e20000205400ULL, 0x000000617a00720bULL, 0x004fce0003f9d000ULL,
0x0000002900487306ULL, 0x000522000000d400ULL, 0x0000002c002c7245ULL, 0x002fca000020d400ULL,
0x0000000133334812ULL, 0x000fe400078efcffULL, 0x0000002f00417306ULL, 0x000e62000000d400ULL,
0x0000010029297824ULL, 0x004fe200078e00ffULL, 0x000000313000720bULL, 0x008fc80003f3d000ULL,
0x00000018ff5a7819ULL, 0x000fe40000011429ULL, 0x0000002b00517306ULL, 0x000fe20000009400ULL,
0x0000000148482812ULL, 0x010fcc00078efcffULL, 0x000000012c2c1812ULL, 0x000fe200078efcffULL,
0x0000002b00507306ULL, 0x000ea20000005400ULL, 0x0000000141416812ULL, 0x002fe400078efcffULL,
0x000000332c33723eULL, 0x000fe400000010ffULL, 0x0000006f002c7245ULL, 0x000fe4000020d400ULL,
0x000000415454723eULL, 0x000fe200000010ffULL, 0x0000002d002e7306ULL, 0x000ff00000209400ULL,
0x0000002d002f7306ULL, 0x0002e20000205400ULL, 0x000000505100720bULL, 0x004fce0003fdd000ULL,
0x0000005a00587306ULL, 0x000fe20000209400ULL, 0x0000002d002d7245ULL, 0x002fce000020d400ULL,
0x0000005a00597306ULL, 0x0002a20000205400ULL, 0x0000002f2e00720bULL, 0x008fce0003f9d000ULL,
0x0000007b00647306ULL, 0x000fe20000209400ULL, 0x0000005a005a7245ULL, 0x002fca000020d400ULL,
0x000000012d2d4812ULL, 0x000fe400078efcffULL, 0x0000007b00577306ULL, 0x0002e20000205400ULL,
0x000000595800720bULL, 0x004fce0003f3d000ULL, 0x0000007c005b7306ULL, 0x000fe20000209400ULL,
0x0000007b007b7245ULL, 0x002fca000020d400ULL, 0x000000015a5a1812ULL, 0x000fe400078efcffULL,
0x0000007c004e7306ULL, 0x000e620000205400ULL, 0x000000576400720bULL, 0x008fe40003f7d000ULL,
0x0000005a2d49723eULL, 0x000fca00000010ffULL, 0x0000006f006d7306ULL, 0x000fec0000209400ULL,
0x000000017b7b3812ULL, 0x000fe400078efcffULL, 0x0000006f006e7306ULL, 0x000ea20000205400ULL,
0x0000004e5b00720bULL, 0x002fe40003f5d000ULL, 0x000000487b48723eULL, 0x000fca00000010ffULL,
0x0000002a00467306ULL, 0x000e6c000000d400ULL, 0x0000000125252812ULL, 0x000fe400078efcffULL,
0x0000002b00477306ULL, 0x000722000000d400ULL, 0x0000006e6d00720bULL, 0x004fce0003f3d000ULL,
0x0000007d007e7306ULL, 0x000fe20000209400ULL, 0x000000002828783bULL, 0x008ea20000000200ULL,
0x0000000146465812ULL, 0x002fc800078efcffULL, 0x000000012c2c1812ULL, 0x000fe400078efcffULL,
0x0000007d00757306ULL, 0x0002e20000205400ULL, 0x000000044000780cULL, 0x000fe40003f25270ULL,
0x0000000147476812ULL, 0x010fca00078efcffULL, 0x00000080004d7306ULL, 0x000fe20000209400ULL,
0x0000007d007d7245ULL, 0x002fce000020d400ULL, 0x0000008000507306ULL, 0x0003220000205400ULL,
0x000000757e00720bULL, 0x008fce0003f7d000ULL, 0x0000008100307306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fca000020d400ULL, 0x000000017d7d3812ULL, 0x000fe400078efcffULL,
0x0000008100277306ULL, 0x000e620000205400ULL, 0x000000504d00720bULL, 0x010fe20003f9d000ULL,
0x000000762814723cULL, 0x044fec0000041814ULL, 0x0000008200247306ULL, 0x000fe40000209400ULL,
0x00000044281c723cULL, 0x000fe8000004181cULL, 0x0000000180804812ULL, 0x000fc400078efcffULL,
0x00000082002f7306ULL, 0x000ea20000205400ULL, 0x000000273000720bULL, 0x002fe20003f5d000ULL,
0x000000722820723cULL, 0x000fe20000041820ULL, 0x0000008200277245ULL, 0x000fce000020d400ULL,
0x000000542818723cULL, 0x040fe80000041818ULL, 0x0000000126262812ULL, 0x000fe400078efcffULL,
0x0000002f2400720bULL, 0x004fe40003fbd000ULL, 0x000000462524723eULL, 0x000fe200000010ffULL,
0x000000322810723cULL, 0x000fe20000041810ULL, 0x000000807d25723eULL, 0x000fc400000010ffULL,
0x000000472626723eULL, 0x000fca00000010ffULL, 0x00000048280c723cULL, 0x000fe4000004180cULL,
0x0000000127275812ULL, 0x000fc800078efcffULL, 0x000000272c27723eULL, 0x000fe400000010ffULL,
0x000000242808723cULL, 0x040ff00000041808ULL, 0x000000262804723cULL, 0x000fe20000041804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe12000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e0039ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd5f000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003a247f8cULL, 0x000fe2000c80043fULL, 0x0000001d3c1d7220ULL, 0x040fe20000410000ULL,
0x0000001e3c1e7220ULL, 0x040fe20000410000ULL, 0x000000153c157220ULL, 0x040fe20000410000ULL,
0x000004003a277984ULL, 0x000e620000000800ULL, 0x0000001f3c1f7220ULL, 0x040fe20000410000ULL,
0x0000001a3c297220ULL, 0x040fe20000410000ULL, 0x000000143c147220ULL, 0x040fe20000410000ULL,
0x000000163c267220ULL, 0x040fe20000410000ULL, 0x000000173c287220ULL, 0x040fe20000410000ULL,
0x000000203c207220ULL, 0x040fe20000410000ULL, 0x000000213c217220ULL, 0x040fe20000410000ULL,
0x000000223c227220ULL, 0x040fe20000410000ULL, 0x0000000d3c1a7220ULL, 0x040fe20000410000ULL,
0x000000233c237220ULL, 0x040fe20000410000ULL, 0x000000183c187220ULL, 0x040fe20000410000ULL,
0x000000193c197220ULL, 0x040fe20000410000ULL, 0x0000001b3c2a7220ULL, 0x040fe20000410000ULL,
0x000000113c167220ULL, 0x040fe20000410000ULL, 0x0000000c3c177220ULL, 0x040fe20000410000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e001dULL, 0x0000001c3c1c7220ULL, 0x040fe20000410000ULL,
0x000000103c007220ULL, 0x040fe20000410000ULL, 0x000000123c2b7220ULL, 0x040fe20000410000ULL,
0x000000133c2c7220ULL, 0x040fe20000410000ULL, 0x0000000e3c2d7220ULL, 0x040fe20000410000ULL,
0x0000000f3c2e7220ULL, 0x040fe20000410000ULL, 0x000000083c087220ULL, 0x040fe20000410000ULL,
0x000000093c097220ULL, 0x040fe20000410000ULL, 0x0000000a3c2f7220ULL, 0x040fe20000410000ULL,
0x0000000b3c307220ULL, 0x040fe20000410000ULL, 0x000000043c047220ULL, 0x040fe20000410000ULL,
0x000000053c057220ULL, 0x040fe20000410000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e001eULL,
0x000000063c067220ULL, 0x040fe20000410000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0015ULL,
0x000000073c077220ULL, 0x000fe20000410000ULL, 0x000000ffff1e7224ULL, 0x000fc400078e001fULL,
0x000000ffff0b7224ULL, 0x000fe400078e0014ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0021ULL, 0x8000000027ff7812ULL, 0x002fe20007804825ULL,
0x000000ffff157224ULL, 0x000fe400078e001aULL, 0x000000ffff1f7224ULL, 0x000fe400078e0022ULL,
0x000000ffff107224ULL, 0x000fc400078e0018ULL, 0x000000ffff117224ULL, 0x000fe400078e0019ULL,
0x000000ffff137224ULL, 0x000fe400078e0016ULL, 0x000000ffff147224ULL, 0x000fe400078e0017ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0026ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0028ULL,
0x000000ffff207224ULL, 0x000fc400078e0023ULL, 0x000000ffff217224ULL, 0x000fe400078e0029ULL,
0x000000ffff227224ULL, 0x000fe400078e002aULL, 0x000000ffff0c7224ULL, 0x000fe400078e001cULL,
0x000000ffff127224ULL, 0x000fe400078e0000ULL, 0x000000ffff167224ULL, 0x000fe400078e0008ULL,
0x000000ffff177224ULL, 0x000fc400078e0009ULL, 0x000000ffff187224ULL, 0x000fe400078e0004ULL,
0x000000ffff197224ULL, 0x000fe400078e0005ULL, 0x000000ffff237224ULL, 0x000fe400078e002bULL,
0x000000ffff267224ULL, 0x000fe400078e002cULL, 0x000000ffff277224ULL, 0x000fe400078e002dULL,
0x000000ffff287224ULL, 0x000fc400078e002eULL, 0x000000ffff297224ULL, 0x000fe400078e002fULL,
0x000000ffff2a7224ULL, 0x000fe200078e0030ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0006ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0007ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe20003800000ULL,
0x000004003a057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000043d1c7824ULL, 0x000fe200078e00ffULL,
0x0000003b3400720cULL, 0x000fc80003f05270ULL, 0xfffffff01c057812ULL, 0x000fca00078ec0ffULL,
0x0000008002007824ULL, 0x000fca00078e0205ULL, 0x00f4000000047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x000000023d087824ULL, 0x000fe400078e00ffULL,
0x00000001033e7824ULL, 0x000fc600078e0a3eULL, 0x0000000608097812ULL, 0x000fc800078ec0ffULL,
0x0000000109257812ULL, 0x040fe400078efcffULL, 0x00000008092d7812ULL, 0x000fe400078efcffULL,
0x0000003e2500720cULL, 0x080fe40003f26070ULL, 0x0000001009257812ULL, 0x000fe400078efcffULL,
0x0000003e2d00720cULL, 0x080fe40003f06070ULL, 0x0000003e2500720cULL, 0x000fc40003fc6070ULL,
0x00000011092d7812ULL, 0x040fe400078efcffULL, 0x0000001809257812ULL, 0x040fe400078efcffULL,
0x0000003e0900720cULL, 0x080fe40003f46070ULL, 0x0000003e2d00720cULL, 0x080fe40003fa6070ULL,
0x0000003e2500720cULL, 0x000fe40003f66070ULL, 0x00000009092f7812ULL, 0x000fc400078efcffULL,
0x00000019092d7812ULL, 0x040fe400078efcffULL, 0x0000002009257812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL,
0x0000003e2f00720cULL, 0x080fe40003f86070ULL, 0x0000003e2d00720cULL, 0x080fe40003f46070ULL,
0x0000003e2500720cULL, 0x000fe40003f26070ULL, 0x00000021092d7812ULL, 0x040fe400078efcffULL,
0x0000002809257812ULL, 0x000fe400078efcffULL, 0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL, 0x0000003e2d00720cULL, 0x080fe40003f06070ULL,
0x0000003e2500720cULL, 0x000fe40003f86070ULL, 0x00000029092d7812ULL, 0x000fc400078efcffULL,
0x0000003009257812ULL, 0x000fe400078efcffULL, 0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL, 0xff7fffff20207808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL, 0x0000003e2d00720cULL, 0x000fc40003fc6070ULL,
0x0000003e2500720cULL, 0x000fe40003fa6070ULL, 0x00000031092d7812ULL, 0x040fe400078efcffULL,
0x0000003809257812ULL, 0x040fe400078efcffULL, 0x0000003909097812ULL, 0x000fe400078efcffULL,
0xff7fffff21217808ULL, 0x000fe40005800000ULL, 0xff7fffff10107808ULL, 0x000fc40005800000ULL,
0xff7fffff22227808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40005000000ULL,
0xff7fffff23237808ULL, 0x000fe40004800000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0x0000003e2d00720cULL, 0x080fe40003f66070ULL, 0x0000003e2500720cULL, 0x000fc40003f46070ULL,
0x0000003e0900720cULL, 0x000fe40003f26070ULL, 0xff7fffff26267808ULL, 0x000fe40004000000ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff27277808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff28287808ULL, 0x000fc40007000000ULL,
0xff7fffff15157808ULL, 0x000fe40007000000ULL, 0xff7fffff29297808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff2b2b7808ULL, 0x000fc40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40005000000ULL, 0xff7fffff2c2c7808ULL, 0x000fe40004800000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0x0000000b04097209ULL, 0x004fe20007810000ULL,
0x0000001fff317424ULL, 0x000fe200078e00ffULL, 0x0000001a05047209ULL, 0x000fe20007810000ULL,
0xffffffffff327424ULL, 0x000fe200078e00ffULL, 0x0000000a09097209ULL, 0x000fe40007810000ULL,
0x0000001b04047209ULL, 0x000fc40007810000ULL, 0x0000000c09087209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x0000000d08097209ULL, 0x000fe40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x0000000e09087209ULL, 0x000fe40007810000ULL,
0x0000001f04057209ULL, 0x000fc40007810000ULL, 0x0000000f08097209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x0000001009087209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x0000001108097209ULL, 0x000fe40007810000ULL,
0x0000002205047209ULL, 0x000fc40007810000ULL, 0x0000001209087209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fe40007810000ULL, 0x0000001308097209ULL, 0x000fe40007810000ULL,
0x0000002605047209ULL, 0x000fe40007810000ULL, 0x0000001409087209ULL, 0x000fe40007810000ULL,
0x0000002704057209ULL, 0x000fc40007810000ULL, 0x0000001508097209ULL, 0x000fe40007810000ULL,
0x0000002805047209ULL, 0x000fe40007810000ULL, 0x0000001609087209ULL, 0x000fe40007810000ULL,
0x0000002904057209ULL, 0x000fe40007810000ULL, 0x0000001708097209ULL, 0x000fe40007810000ULL,
0x0000002a05047209ULL, 0x000fc40007810000ULL, 0x0000001809087209ULL, 0x000fe40007810000ULL,
0x0000002b04057209ULL, 0x000fe40007810000ULL, 0x00000019082d7209ULL, 0x000fe40007810000ULL,
0x0000002c052f7209ULL, 0x000fe20007810000ULL, 0x000018227f007947ULL, 0x000fea000b800000ULL,
0x0c401f002d047f89ULL, 0x0004e400000e0000ULL, 0x000000042d2d7209ULL, 0x00cfe20007810000ULL,
0x000018527f007947ULL, 0x000fea000b800000ULL, 0x0c401f002f047f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006057f89ULL, 0x000ee800000e0000ULL, 0x0c401f0007247f89ULL, 0x000f2200000e0000ULL,
0x000000042f087209ULL, 0x004fc60007810000ULL, 0x0c201f002d047f89ULL, 0x000ea200000e0000ULL,
0x0000000506097209ULL, 0x008fc60007810000ULL, 0x0c201f0008057f89ULL, 0x000ee200000e0000ULL,
0x0000002407247209ULL, 0x010fc60007810000ULL, 0x0c201f00092e7f89ULL, 0x002e6800000e0000ULL,
0x0c201f0024257f89ULL, 0x00092200000e0000ULL, 0x000000042d047209ULL, 0x004fe40007810000ULL,
0x0000000508057209ULL, 0x008fe40007810000ULL, 0x0000002e09067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fc40000000000ULL,
0x00000004ff2e7e24ULL, 0x002fe2000f8e00ffULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x3f8000002e2e783eULL, 0x000fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL, 0x000000ffff2f7224ULL, 0x000fe200078e002eULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010819ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2c197823ULL, 0x000fe20000010819ULL,
0x0000000000057886ULL, 0x000fc400038e0100ULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x000000080908723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000ff00000000800ULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000000c0d0a723eULL, 0x008fce00000010ffULL,
0x0000001d000b7308ULL, 0x0007f00000000800ULL, 0x0000001e001e7308ULL, 0x000f620000000800ULL,
0x0000001a1b09723eULL, 0x002fe200000010ffULL, 0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b1e0b723eULL, 0x020fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x0000002e0830723cULL, 0x000fee00000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ee20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x008fce00000010ffULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ee20000000800ULL,
0x0000001f200d723eULL, 0x002fce00000010ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000021220f723eULL, 0x008fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000002e0c30723cULL, 0x000fee0000041830ULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fe400000010ffULL, 0xfffffffc3d147812ULL, 0x000fc800078ec0ffULL,
0x000000141d1d7219ULL, 0x000fe200000006ffULL, 0x0000002700277308ULL, 0x000fe60000000800ULL,
0x000000001d1e73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0473c4ULL, 0x000f680000004000ULL,
0x0000002800287308ULL, 0x000f220000000800ULL, 0x000000232611723eULL, 0x002fce00000010ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000272813723eULL, 0x010fce00000010ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000051dff7c12ULL, 0x008fe2000f80401eULL,
0x0000002e1030723cULL, 0x000fec0000041830ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000000700077308ULL, 0x000ee20000000800ULL, 0x000000161714723eULL, 0x002fce00000010ffULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x000000180716723eULL, 0x008fe400000010ffULL, 0x0000002425077209ULL, 0x004fca0007810000ULL,
0x0000002b002b7308ULL, 0x000ff00000000800ULL, 0x00000019001a7308ULL, 0x000ea20000000800ULL,
0x000000292a15723eULL, 0x002fe400000010ffULL, 0x0000002b1a17723eULL, 0x004fce00000010ffULL,
0x0000002e1430723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000136204008947ULL, 0x020fde000b800000ULL, 0x001c1fff30187589ULL, 0x0002a400000e0000ULL,
0x000000001d1a73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x000000051dff7c12ULL, 0x008fda000f80401aULL,
0x0000138204008947ULL, 0x010fea000b800000ULL, 0x001c1fff32197589ULL, 0x00072800000e0000ULL,
0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL, 0x001c1fff001b7589ULL, 0x0006a400000e0000ULL,
0x00000002ff1d7819ULL, 0x00afe4000001163dULL, 0x0000000c1c337812ULL, 0x000fc400078ec0ffULL,
0x000000071d1e7812ULL, 0x040fe200078ec0ffULL, 0x000000081d237824ULL, 0x040fe200078e00ffULL,
0x0000001dff217212ULL, 0x000fe200078e33ffULL, 0x000000081d1f7824ULL, 0x000fe200078e00ffULL,
0x000000033dff7812ULL, 0x000fe2000780c0ffULL, 0x000000081d2e7824ULL, 0x040fe200078e00ffULL,
0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823207812ULL, 0x100fe400078ee21eULL,
0x000000011f227812ULL, 0x100fe200078ef61eULL, 0x000000081d487824ULL, 0x000fe200078e00ffULL,
0x000000021f247812ULL, 0x100fe200078ef61eULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0x000000031f267812ULL, 0x000fc400078ef61eULL, 0x000000041f287812ULL, 0x140fe400078ef61eULL,
0x000000051f2a7812ULL, 0x140fe400078ef61eULL, 0x000000061f2c7812ULL, 0x000fe200078ef61eULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe400078ee221ULL,
0x0000001dff217212ULL, 0x000fe400078e33ffULL, 0x000000071d1e7812ULL, 0x000fc400078ec0ffULL,
0x00009000021d7811ULL, 0x000fe400078e58ffULL, 0xfffffff823307812ULL, 0x100fe400078ee21eULL,
0x000000011f327812ULL, 0x140fe200078ef61eULL, 0x00000010201c7824ULL, 0x000fe200078e021dULL,
0xfffffff848487812ULL, 0x000fe200078ee221ULL, 0x0000001024207824ULL, 0x100fe200078e021dULL,
0x000000021f3e7812ULL, 0x140fe200078ef61eULL, 0x0000001028247824ULL, 0x100fe200078e021dULL,
0x000000031f407812ULL, 0x140fe200078ef61eULL, 0x000000102c287824ULL, 0x100fe200078e021dULL,
0x000000041f427812ULL, 0x140fe200078ef61eULL, 0x00000010322c7824ULL, 0x100fe200078e021dULL,
0x000000051f447812ULL, 0x140fe200078ef61eULL, 0x000000103e2d7824ULL, 0x100fe200078e021dULL,
0x000000061f467812ULL, 0x000fe200078ef61eULL, 0x00000010221e7824ULL, 0x000fc400078e021dULL,
0x0000001026227824ULL, 0x100fe400078e021dULL, 0x000000102a267824ULL, 0x100fe400078e021dULL,
0x00000001331f7824ULL, 0x000fe400078e021cULL, 0x000000102e2a7824ULL, 0x100fe400078e021dULL,
0x00000010301c7824ULL, 0x100fe200078e021dULL, 0x000000081f007388ULL, 0x0003e20000000800ULL,
0x00000010402e7824ULL, 0x000fc400078e021dULL, 0x00000010422f7824ULL, 0x100fe400078e021dULL,
0x0000001044307824ULL, 0x100fe400078e021dULL, 0x0000001046317824ULL, 0x100fe400078e021dULL,
0x0000001048327824ULL, 0x000fe400078e021dULL, 0x00000001331d7824ULL, 0x040fe400078e021eULL,
0x0000000133217824ULL, 0x000fc400078e0220ULL, 0x0000000133237824ULL, 0x040fe200078e0222ULL,
0x0000000a1d007388ULL, 0x0007e20000000800ULL, 0x0000000133257824ULL, 0x040fe400078e0224ULL,
0x0000000133277824ULL, 0x040fe200078e0226ULL, 0x0000000c21007388ULL, 0x0007e20000000800ULL,
0x0000000133297824ULL, 0x040fe400078e0228ULL, 0x00000001332b7824ULL, 0x040fe200078e022aULL,
0x0000000e23007388ULL, 0x0007e20000000800ULL, 0x00000001331c7824ULL, 0x000fc400078e021cULL,
0x00000001332c7824ULL, 0x040fe200078e022cULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x00000001331e7824ULL, 0x040fe400078e022dULL, 0x00000001332e7824ULL, 0x040fe200078e022eULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x0000000133087824ULL, 0x042fe400078e022fULL,
0x0000000133307824ULL, 0x040fe200078e0230ULL, 0x0000001429007388ULL, 0x0007e20000000800ULL,
0x0000000133207824ULL, 0x000fc400078e0231ULL, 0x0000000133327824ULL, 0x000fe200078e0232ULL,
0x000000162b007388ULL, 0x0007e80000000800ULL, 0x000000091c007388ULL, 0x0007e80000000800ULL,
0x0000000b2c007388ULL, 0x0007e80000000800ULL, 0x0000000d1e007388ULL, 0x0007e80000000800ULL,
0x0000000f2e007388ULL, 0x0007e80000000800ULL, 0x0000001108007388ULL, 0x0007e80000000800ULL,
0x0000001330007388ULL, 0x0007e80000000800ULL, 0x0000001520007388ULL, 0x0007e80000000800ULL,
0x0000001732007388ULL, 0x0007e80000000800ULL, 0x00f0000400008388ULL, 0x0007e80000000c00ULL,
0x00f2001800008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000038ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080038ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100038ff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030034347a10ULL, 0x000fe20007ffe0ffULL, 0x0000180038ff7f8cULL, 0x0003e6000c80043fULL,
0x000000353400720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffb9e000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff247807ULL, 0x010fe40004000000ULL, 0x0001573000297802ULL, 0x000fe40000000f00ULL,
0x00000f7000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0028ULL,
0xfffebf7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe40004000000ULL,
0x0001578000297802ULL, 0x000fe40000000f00ULL, 0x00000f2000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0028ULL, 0xfffebfb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x010fe200078e002fULL, 0x0001580000247802ULL, 0x002fe20000000f00ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0000ULL, 0x0000001fff2c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000e6000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e0029ULL, 0xfffebff000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e0000ULL, 0x0001588000247802ULL, 0x000fe20000000f00ULL,
0x000000ffff2a7224ULL, 0x000fe400078e002fULL, 0x0000001fff2c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000de000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0029ULL, 0xfffebfa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x000fe200078e0027ULL, 0x000158f000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x00000d7000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff8b7224ULL, 0x004fe200078e0029ULL,
0xfffec30000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e0046ULL,
0x0001596000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000d0000007944ULL, 0x01cfea0003c00000ULL,
0x000000ffff807224ULL, 0x004fe200078e0029ULL, 0xfffec2c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x010fe40004000000ULL, 0x000159b000297802ULL, 0x000fe40000000f00ULL,
0x00000cf000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xfffeec8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe40004000000ULL,
0x00015a0000297802ULL, 0x000fc40000000f00ULL, 0x00000ca000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xfffeecc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x008fe200078e0029ULL, 0x00015a7000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x00000bf000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e0029ULL,
0xfffeed2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e0046ULL,
0x00015ae000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000b8000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0029ULL, 0xfffeedd000007947ULL, 0x000fea000383ffffULL,
0x0000001fff2c7424ULL, 0x000fe200078e00ffULL, 0x00015b4000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000b2000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff937224ULL, 0x004fe200078e0029ULL, 0xfffef09000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e0046ULL, 0x00015bb000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x00000ab000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff8a7224ULL, 0x004fe200078e0029ULL,
0xfffef04000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x002fe40004000000ULL,
0x00015c0000297802ULL, 0x000fe40000000f00ULL, 0x00000aa000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff15c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004000000ULL, 0x00015c5000297802ULL, 0x000fe40000000f00ULL,
0x00000a5000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xffff160000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e0029ULL,
0x00015cc000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x000009a000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0029ULL, 0xffff166000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e0046ULL, 0x00015d3000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000093000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e0029ULL,
0xffff171000007947ULL, 0x000fea000383ffffULL, 0x0000001fff2c7424ULL, 0x000fe200078e00ffULL,
0x00015d9000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x000008d000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff7d7224ULL, 0x004fe200078e0029ULL,
0xffff19c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e0046ULL,
0x00015e0000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0000086000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff7c7224ULL, 0x004fe200078e0029ULL, 0xffff197000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x010fe40004000000ULL, 0x00015e5000297802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xffff3f2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe40004000000ULL,
0x00015ea000297802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff3f6000007947ULL, 0x000fea000383ffffULL,
0x0000001fff2c7424ULL, 0x008fe200078e00ffULL, 0x00015f0000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x0000076000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0029ULL, 0xffff3fd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x00afe200078e0046ULL, 0x00015f7000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff2c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x000006f000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e0029ULL,
0xffff408000007947ULL, 0x000fea000383ffffULL, 0x0000001fff2c7424ULL, 0x000fe200078e00ffULL,
0x00015fd000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000069000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff6b7224ULL, 0x004fe200078e0029ULL,
0xffff434000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e0046ULL,
0x0001604000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0000062000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff6a7224ULL, 0x004fe200078e0029ULL, 0xffff42f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff257224ULL, 0x000fe200078e002dULL, 0x000160a000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x000fc400078e00ffULL, 0x0000058000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0025ULL, 0xffffe79000007947ULL, 0x000fea000383ffffULL,
0x000000ffff257224ULL, 0x000fe200078e002fULL, 0x0001610000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000052000007944ULL, 0x000fea0003c00000ULL,
0x000000252f307209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0006ULL,
0x0001615000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x002fc400078e00ffULL,
0x000004d000007944ULL, 0x000fea0003c00000ULL, 0x0000002506067209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0007ULL, 0x000161a000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000048000007944ULL, 0x000fea0003c00000ULL,
0x0000002507247209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e002dULL,
0x000161f000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x000000252d047209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0030ULL, 0x0001624000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x002fc400078e00ffULL, 0x000003e000007944ULL, 0x000fea0003c00000ULL,
0x0000002530057209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0006ULL,
0x0001629000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000002506067209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0024ULL, 0x000162e000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0xffffe65000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0030ULL,
0x0001635000247802ULL, 0x000fe20000000f00ULL, 0x000000ffff2b7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff2c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2d7224ULL, 0x000fe400078e001dULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e0029ULL,
0xffffec3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x002fe200078e0032ULL,
0x000163d000247802ULL, 0x000fe20000000f00ULL, 0x000000ffff2b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff2c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff2d7224ULL, 0x000fe400078e001dULL,
0x0000029000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2b7224ULL, 0x002fe200078e00ffULL,
0x0001643000247802ULL, 0x000fe20000000f00ULL, 0x00001c1fff2c7424ULL, 0x000fc400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fe400078e001dULL, 0x000000ffff197224ULL, 0x004fe400078e0029ULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2d7224ULL, 0x002fe200078e001dULL,
0x0001649000247802ULL, 0x000fe20000000f00ULL, 0x000000ffff2b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff2c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1a7224ULL, 0x004fe400078e0029ULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0029ULL,
0xffffeb7000007947ULL, 0x000fea000383ffffULL, 0x0180000039037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000003900038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff087807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000308ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff39ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000039077812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000308ff7212ULL, 0x000fda000780c0ffULL, 0x0080000007030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0007ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003900037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffe99e006007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003200007348ULL, 0x000fe80003800000ULL,
0x0c00002e25257389ULL, 0x0002a200000e0031ULL, 0xfffe99a008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff257424ULL, 0x000fe200078e00ffULL, 0x0000002d00007348ULL, 0x000fe80003800000ULL,
0x0000002b2a297389ULL, 0x0002a200000e002cULL, 0xfffe996024007950ULL, 0x000fea0003c3ffffULL,
0x000000012400780cULL, 0x000fe20003f05070ULL, 0x0000004500007348ULL, 0x000fe80003800000ULL,
0x00000000ff257424ULL, 0x000fd000078e00ffULL, 0x0000000000247806ULL, 0x000fc800040e0100ULL,
0x0000004524287212ULL, 0x000fe200078ec0ffULL, 0x000000ffff247224ULL, 0x000fc800078e0029ULL,
0xfffe98f024007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000500ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ae0ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000b70ULL, 0x0000000000000884ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000013f4ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001418ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001428ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001448ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000014d8ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000014e0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000014f0ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001700ULL, 0x0000000000016800ULL, 0xf300001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017f00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000017f10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017f10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000018390ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000014d8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000016a28ULL, 0x0000000000016a28ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017f00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000018390ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_86_cubin_len = 99440;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
