/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000018090ULL, 0x0000000000017c10ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x00000000000163e0ULL, 0x0000000000000180ULL,
0x000e002200000106ULL, 0x0000000000016560ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x00000000000165a0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x00000000000165e0ULL,
0x0000000000000120ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000016700ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000163e000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x0057b40400288080ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x8c08288080860828ULL, 0x2880809408288080ULL, 0x809a082880809608ULL, 0x08288080a0082880ULL,
0x8080aa08288080a9ULL, 0xaf08288080ab0828ULL, 0x288080b008288080ULL, 0x808808288080b408ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080889200ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x000163e000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8082288080860900ULL, 0x0900000010042880ULL, 0x2880808628808088ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x8808288080860828ULL, 0x2880809408288080ULL, 0x809a082880809608ULL,
0x08288080a0082880ULL, 0x8080aa08288080a9ULL, 0xaf08288080ab0828ULL, 0x288080b008288080ULL,
0x808c08288080b408ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x22002880808c9200ULL,
0x0000001cffffffffULL, 0x0000013800000000ULL, 0x0001656000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8808288080860828ULL,
0x2880808c08288080ULL, 0x8096082880809408ULL, 0x082880809a082880ULL, 0x8080a908288080a0ULL,
0xab08288080aa0828ULL, 0x288080af08288080ULL, 0x80b008288080b408ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080b09200ULL, 0x0000001cffffffffULL, 0x000001e800000000ULL,
0x000165a000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x8808288080860828ULL, 0x2880808c08288080ULL, 0x8096082880809408ULL,
0x08288080a0082880ULL, 0x8080aa08288080a9ULL, 0xaf08288080ab0828ULL, 0x288080b008288080ULL,
0x809a08288080b408ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x22002880809a9200ULL,
0x0000002cffffffffULL, 0x0000029800000000ULL, 0x000165e000000000ULL, 0x0000012000000000ULL,
0x0000180400000000ULL, 0x80942880809a0900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL,
0x00081204000000faULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005001600000000eULL,
0x000c170400501903ULL, 0x0048000700000000ULL, 0x000c17040021f000ULL, 0x0040000600000000ULL,
0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x00014c1000014780ULL, 0x00014d9000014c20ULL,
0x00014db000014da0ULL, 0xffffffff01602904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x05000024ffffffffULL, 0x0500002405000024ULL, 0xffffffff05000024ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01602804ffffffffULL, 0x00000110000000f0ULL, 0x00001740000016b0ULL,
0x0000183000001800ULL, 0x00001c3000001c00ULL, 0x00001cf000001c90ULL, 0x000046d000004640ULL,
0x000048c0000047a0ULL, 0x00004c0000004be0ULL, 0x00004cc000004c60ULL, 0x00007280000071f0ULL,
0x0000747000007350ULL, 0x000077a000007780ULL, 0x0000786000007800ULL, 0x00009e4000009db0ULL,
0x0000a03000009f10ULL, 0x0000a3700000a350ULL, 0x0000a4300000a3d0ULL, 0x0000c4300000c420ULL,
0x0000eaf00000ea00ULL, 0x0000f3300000f300ULL, 0x0001466000014630ULL, 0x0001468000014670ULL,
0x000146c0000146a0ULL, 0x000146f0000146e0ULL, 0x00014de000014d80ULL, 0x00014e0000014df0ULL,
0x0001558000015520ULL, 0x00015660000155f0ULL, 0x00015740000156d0ULL, 0x00015800000157a0ULL,
0x000158d000015860ULL, 0x000159a000015930ULL, 0x00015a6000015a00ULL, 0x00015b3000015ac0ULL,
0x00015c0000015b90ULL, 0x00015cc000015c60ULL, 0x00015d9000015d20ULL, 0x00015e6000015df0ULL,
0x00015f6000015ee0ULL, 0x0001604000015fd0ULL, 0x00016120000160b0ULL, 0x0001620000016190ULL,
0x000162f000016270ULL, 0x000163b000016350ULL, 0x000001f004c03904ULL, 0x0000f600000000ffULL,
0x00000270003f0100ULL, 0x0000f60800000003ULL, 0x000002c0003f0120ULL, 0x0000f68800000003ULL,
0x00000360003f0120ULL, 0x0000f6a800000003ULL, 0x00000390003f0120ULL, 0x0000f6c800000003ULL,
0x00000460003f0120ULL, 0x0000f600000000ffULL, 0x00000710003f0107ULL, 0x0000f68c00000008ULL,
0x00000a00003f0102ULL, 0x0000f68800000008ULL, 0x00000b50003f0101ULL, 0x00000000000000ffULL,
0x00000bd000040107ULL, 0x00000000000000ffULL, 0x00000c3000040101ULL, 0x0000002000000017ULL,
0x00000d50003f0101ULL, 0x000000040000001dULL, 0x00000db0003f0105ULL, 0x0000002400000017ULL,
0x00000e30003f0105ULL, 0x0000002400000017ULL, 0x00001390003f0105ULL, 0x000000000000001cULL,
0x00001460003f0107ULL, 0x000000000000001cULL, 0x00001470003f0101ULL, 0x000000040000001bULL,
0x000014e0003f0105ULL, 0x0000f60800000025ULL, 0x00001500003f0101ULL, 0x0000f60c00000025ULL,
0x000015c0003f0105ULL, 0x0000f60c00000013ULL, 0x00001af0003f0105ULL, 0x000000040000001bULL,
0x00001b70003f0105ULL, 0x000000040000001bULL, 0x00003cc0003f0105ULL, 0x0000002000000017ULL,
0x00003d40003f0101ULL, 0x0000f68800000059ULL, 0x00003da0003f0101ULL, 0x000000040000001dULL,
0x00003df0003f0105ULL, 0x0000002400000017ULL, 0x00003e70003f0105ULL, 0x0000002400000017ULL,
0x00004390003f0105ULL, 0x0000000000000065ULL, 0x00004410003f0107ULL, 0x0000000000000065ULL,
0x00004420003f0101ULL, 0x000000040000006aULL, 0x00004490003f0105ULL, 0x0000f62800000025ULL,
0x000044b0003f0101ULL, 0x0000f62c00000025ULL, 0x00004590003f0105ULL, 0x0000f62c00000010ULL,
0x00004ab0003f0105ULL, 0x0000f6ac00000012ULL, 0x00004b30003f0105ULL, 0x0000f6ac00000012ULL,
0x00006af0003f0105ULL, 0x0000002000000017ULL, 0x00006b60003f0101ULL, 0x0000f69000000059ULL,
0x00006bb0003f0101ULL, 0x000000040000001dULL, 0x00006c00003f0105ULL, 0x0000002400000017ULL,
0x00006c80003f0105ULL, 0x0000002400000017ULL, 0x00006f90003f0105ULL, 0x000000000000006aULL,
0x00007010003f0107ULL, 0x000000000000006aULL, 0x00007020003f0101ULL, 0x0000000400000065ULL,
0x00007090003f0105ULL, 0x0000f64800000025ULL, 0x000070b0003f0101ULL, 0x0000f64c00000025ULL,
0x00007140003f0105ULL, 0x0000f64c00000025ULL, 0x00007650003f0105ULL, 0x0000f6ac00000015ULL,
0x000076d0003f0105ULL, 0x0000f6ac00000015ULL, 0x00009670003f0105ULL, 0x0000002000000017ULL,
0x000096e0003f0101ULL, 0x0000f69800000059ULL, 0x00009730003f0101ULL, 0x000000040000001dULL,
0x00009780003f0105ULL, 0x0000002400000017ULL, 0x00009800003f0105ULL, 0x0000002400000017ULL,
0x00009b40003f0105ULL, 0x0000000000000065ULL, 0x00009bc0003f0107ULL, 0x0000000000000064ULL,
0x00009bd0003f0101ULL, 0x000000040000006aULL, 0x00009c40003f0105ULL, 0x0000f66800000025ULL,
0x00009c60003f0101ULL, 0x0000f66c00000025ULL, 0x00009d00003f0105ULL, 0x0000f66c00000025ULL,
0x0000a220003f0105ULL, 0x0000f6ac00000016ULL, 0x0000a2a0003f0105ULL, 0x0000f6ac00000016ULL,
0x0000c1b0003f0105ULL, 0x0000002000000017ULL, 0x0000c210003f0101ULL, 0x0000f6a000000059ULL,
0x00010030003f0101ULL, 0x0000f600000000ffULL, 0x00010b20003f0101ULL, 0x0000f604000000ffULL,
0x00010bc0003f0105ULL, 0x0000f604000000ffULL, 0x00010dd0003f0105ULL, 0x0000f600000000ffULL,
0x00010de0003f0101ULL, 0x0000f604000000ffULL, 0x00010e70003f0105ULL, 0x0000f604000000ffULL,
0x00013b10003f0105ULL, 0x0000000000000039ULL, 0x00013b40003f0101ULL, 0x0000000400000039ULL,
0x00013f50003f0105ULL, 0x0000000400000039ULL, 0x00015370003f0105ULL, 0x000000000000003aULL,
0x000153d0003f0101ULL, 0x000000080000003aULL, 0x00015430003f0101ULL, 0x000000100000003aULL,
0x000154a0003f0101ULL, 0x000000180000003aULL, 0x00053803003f0101ULL, 0x0000fd3000141c04ULL,
0x00010ed00000ff80ULL, 0x000154e000010f70ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x0000000000000334ULL, 0x0000001200000002ULL, 0x0000000000000284ULL, 0x0000001200000002ULL,
0x00000000000001d4ULL, 0x0000001200000002ULL, 0x000000000000010cULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x0000000000000311ULL, 0x0000001200000002ULL,
0x0000000000000261ULL, 0x0000001200000002ULL, 0x00000000000001b1ULL, 0x0000001200000002ULL,
0x00000000000000e9ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x0000000000167806ULL, 0x000fe200038e0000ULL, 0x00005800ff097624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000001600067300ULL, 0x000ee200000e0000ULL, 0x0000000809097824ULL, 0x000fe400078e00ffULL,
0x0000000000027919ULL, 0x000ea20000002200ULL, 0x00000100ff177424ULL, 0x000fc600078e00ffULL,
0x0000000000147919ULL, 0x000f220000002600ULL, 0x0000001600167309ULL, 0x000f660000000000ULL,
0x0000000000137919ULL, 0x000ee80000002700ULL, 0x0000000000077919ULL, 0x000ee20000000000ULL,
0x00000005ff007819ULL, 0x002fcc0000011603ULL, 0x00001fff00007589ULL, 0x000fe200000e0000ULL,
0x000000010d027824ULL, 0x004fc600078e0202ULL, 0x00001fff0d0d7589ULL, 0x000e6200000e0000ULL,
0x0000008002037824ULL, 0x000fc600078e0203ULL, 0x0000000000027919ULL, 0x000ea20000000000ULL,
0x0000000814087824ULL, 0x010fe200078e00ffULL, 0x000000ff0300720cULL, 0x040fe40003f45270ULL,
0x0000000f0300780cULL, 0x000fe20003f64070ULL, 0x00000013090a7224ULL, 0x008fe200078e0208ULL,
0x000000030300780cULL, 0x040fe40003f24070ULL, 0x0000007f0300780cULL, 0x000fe40003f84070ULL,
0x000000070600720cULL, 0x000fca0003f02070ULL, 0x3fffff80ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff05a424ULL, 0x000fe400078e00ffULL, 0x000000040d087824ULL, 0x002fe400078e0200ULL,
0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL, 0x00f60004ff00a388ULL, 0x0003e20000000a00ULL,
0x000000010300780cULL, 0x000fe20003f44070ULL, 0x00000002080b7824ULL, 0x000fe200078e00ffULL,
0x00000004ff0e7819ULL, 0x004fe20000011602ULL, 0x7fffffc0ff07b424ULL, 0x000fc400078e00ffULL,
0x3fffff60ff089424ULL, 0x000fe200078e00ffULL, 0x000000080b0c7817ULL, 0x040fe20007800000ULL,
0x000000010b0f7824ULL, 0x000fe200078e020eULL, 0x00f608060300b388ULL, 0x0005e20000008a00ULL,
0x7fffff60ff099424ULL, 0x000fe400078e00ffULL, 0x000000010a047824ULL, 0x002fe200078e020fULL,
0x000000070f117812ULL, 0x000fe200078ec0ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a0bULL,
0x00f6880803009388ULL, 0x000fe20000008a00ULL, 0xff317217ff12c424ULL, 0x000fc400078e00ffULL,
0x3fffffc0ff0aa424ULL, 0x000fe200078e00ffULL, 0x0000000c0e00720cULL, 0x000fe20003f66070ULL,
0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL, 0x00f400120300c388ULL, 0x0003e20000004800ULL,
0x3fffff80ff069424ULL, 0x004fe400078e00ffULL, 0x7fffff80ff079424ULL, 0x000fe400078e00ffULL,
0x0000001002107824ULL, 0x000fe400078e00ffULL, 0x00005c0004047625ULL, 0x000fe200078e0017ULL,
0x00f6a80603009388ULL, 0x0005e40000008a00ULL, 0x000000f010157812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x020fe200078e0a16ULL, 0x00f6c80a0300a388ULL, 0x0007e20000008a00ULL,
0x0000000f11127812ULL, 0x002fe200078e7802ULL, 0x00000004ff087424ULL, 0x000fc400078e00ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001504047210ULL, 0x000fe20007f9e0ffULL,
0x000000100f127824ULL, 0x000fe400078e0212ULL, 0x0000600013067625ULL, 0x004fc800078e0008ULL,
0x000000ffff057224ULL, 0x000fe400020e0605ULL, 0x0000001012097824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0007e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f6040cffff038cULL, 0x0007e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000606037981ULL, 0x008ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000004ff047e24ULL, 0x002fe2000f8e00ffULL,
0x000000ff03057810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff057819ULL, 0x000fce0000011605ULL,
0x0000fa4000008947ULL, 0x000fea0003800000ULL, 0x0000580014077a10ULL, 0x000fe20007ffe0ffULL,
0x0000000213067824ULL, 0x000fe200078e00ffULL, 0x00000003ff177819ULL, 0x000fe20000011602ULL,
0x0000001000097824ULL, 0x000fe200078e00ffULL, 0x0000000104087810ULL, 0x000fe20007ffe0ffULL,
0x0000580006067a24ULL, 0x000fe200078e0207ULL, 0x0000000417187810ULL, 0x000fe20007ffe0ffULL,
0x00000003ff137424ULL, 0x000fe200078e00ffULL, 0x0000001009077812ULL, 0x000fe400078ec0ffULL,
0x00000001ff097819ULL, 0x000fc40000011600ULL, 0x000000050800720cULL, 0x000fe20003f06070ULL,
0x00000001070c7824ULL, 0x000fe400078e0217ULL, 0x0000000800087824ULL, 0x000fe400078e00ffULL,
0x00000008040b7824ULL, 0x000fe200078e0209ULL, 0x000000020c0a7212ULL, 0x040fe200078e3cffULL,
0x000000080c0d7824ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee20aULL, 0x00000001070f7824ULL, 0x000fe200078e0218ULL,
0x00000008171a7810ULL, 0x000fe20007ffe0ffULL, 0x000000200b0a7824ULL, 0x000fe200078e00ffULL,
0x0000000c171c7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f117824ULL, 0x040fe200078e00ffULL,
0x000000020f0e7212ULL, 0x000fe200078e3cffULL, 0x0000000107127824ULL, 0x000fe200078e021aULL,
0x0000000a030b7217ULL, 0x000fe20007800000ULL, 0x0000000107157824ULL, 0x000fe200078e021cULL,
0xfffffff811117812ULL, 0x000fe200078ee20eULL, 0x00f68c1308ff738cULL, 0x0003e20000000000ULL,
0x0000000212147212ULL, 0x080fe200078e3cffULL, 0x000000010b0e7824ULL, 0x100fe200078e0a0aULL,
0x0000000215167212ULL, 0x000fe200078e3cffULL, 0x00006200060b7a24ULL, 0x000fe200078e020aULL,
0x00000000090473c2ULL, 0x0004e200000e0000ULL, 0x00002000090a7824ULL, 0x000fe200078e00ffULL,
0x0000007010217812ULL, 0x000fe200078ec0ffULL, 0x0000000812197824ULL, 0x000fc400078e00ffULL,
0x000000010b137824ULL, 0x042fe200078e0212ULL, 0x0000b0000a127810ULL, 0x000fe20007ffe0ffULL,
0x000000010b1e7824ULL, 0x000fe400078e0215ULL, 0x0000000815157824ULL, 0x000fe400078e00ffULL,
0x000000010b0c7824ULL, 0x000fe400078e020cULL, 0x00000080ff207424ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee216ULL, 0x000000010b0f7824ULL, 0x000fe200078e020fULL,
0xfffffff8190b7812ULL, 0x000fe200078ee214ULL, 0x000000100d197824ULL, 0x000fe200078e0212ULL,
0x000000200e167807ULL, 0x000fe20000000000ULL, 0x00005e000c0c7625ULL, 0x000fc600078e0020ULL,
0x0000000716167217ULL, 0x000fe20007800000ULL, 0x00000010111b7824ULL, 0x100fe200078e0212ULL,
0x000000210c147210ULL, 0x000fe20007f1e0ffULL, 0x000000100b1d7824ULL, 0x100fe400078e0212ULL,
0x00000010151f7824ULL, 0x000fe400078e0212ULL, 0x00005e0013107625ULL, 0x000fc800078e0020ULL,
0x00005e000f0e7625ULL, 0x000fe200078e0020ULL, 0x0000002110107210ULL, 0x000fc60007f3e0ffULL,
0x00005e001e127625ULL, 0x000fc800078e0020ULL, 0x000000ffff157224ULL, 0x000fe200000e060dULL,
0x000000210e0e7210ULL, 0x080fe20007f1e0ffULL, 0x0000000116167824ULL, 0x000fe200078e0a07ULL,
0x0000002112127210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff117224ULL, 0x000fe400008e0611ULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0x000000161700720cULL, 0x080fe20003f06070ULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x000000161800720cULL, 0x080fe40003f26070ULL,
0x000000161a00720cULL, 0x000fc40003f46070ULL, 0x000000161c00720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x00cfec0000008000ULL, 0x0000f6a804047891ULL, 0x000fe2000f8e203fULL,
0x00f6880008ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001000c7812ULL, 0x000fe200078ec0ffULL,
0xff317217ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014197faeULL, 0x0003e2000c101c46ULL,
0x000000050400720cULL, 0x000fe20003f06070ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000000000e1b7faeULL, 0x0003e2000c901c46ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x00000000101d7faeULL, 0x0003e2000d101c46ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000121f7faeULL, 0x0003e2000d901c46ULL,
0x0000f6a809177811ULL, 0x000fc600078e18ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff1e7f8cULL, 0x002e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00002000170e7f8cULL, 0x0004e2000c80043fULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00000020171d7810ULL, 0x000fe20007ffe0ffULL, 0x0000b5a000000947ULL, 0x000fea0003800000ULL,
0x000000ffff157224ULL, 0x00cfe400078e000fULL, 0xff317217ff0b7424ULL, 0x000fc400078e00ffULL,
0x000000ffff5d7224ULL, 0x000fe400078e00ffULL, 0x000000ffff3b7224ULL, 0x000fe400078e00ffULL,
0x00000100040e7824ULL, 0x000fca00078e00ffULL, 0x000000030e00720cULL, 0x000fda0003f06070ULL,
0x0000b4f000000947ULL, 0x002fea0003800000ULL, 0x000004001d0e7984ULL, 0x000ea40000000800ULL,
0x800000000eff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x002fe200078e005dULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x00002400170e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff097424ULL, 0x000fc800078e00ffULL,
0x00000009000e7305ULL, 0x0002a4000021f000ULL, 0x3fa0000009097823ULL, 0x002fe200000100ffULL,
0x0000000e0000735dULL, 0x004fe40003800000ULL, 0x00002400170e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fc40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000003ff1a7819ULL, 0x000fe20000011602ULL, 0x0000010004207824ULL, 0x040fe200078e00ffULL,
0x00000001040e7810ULL, 0x000fe20007ffe0ffULL, 0x000010005d0f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011600ULL, 0x0000000107137824ULL, 0x000fe200078e021aULL,
0x000000050e00720cULL, 0x000fe20003f06070ULL, 0x0000001002277824ULL, 0x000fe200078e00ffULL,
0x000000041a1c7810ULL, 0x040fe20007ffe0ffULL, 0x00000020090e7824ULL, 0x000fe200078e0220ULL,
0x0000000213107212ULL, 0x040fe200078e3cffULL, 0x0000000813217824ULL, 0x000fe200078e00ffULL,
0x000000081a267810ULL, 0x000fe20007ffe0ffULL, 0x0000000107157824ULL, 0x000fe200078e021cULL,
0x000000400e0e7810ULL, 0x000fe20007ffe0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0xfffffff821217812ULL, 0x000fe200078ee210ULL, 0x0000000107197824ULL, 0x000fe200078e0226ULL,
0x000010000f107812ULL, 0x000fe200078e0cffULL, 0x0000000815147824ULL, 0x000fe200078e00ffULL,
0x0000000e030f7217ULL, 0x000fe20007800000ULL, 0x00000008192b7824ULL, 0x000fe200078e00ffULL,
0x0000000c1a287810ULL, 0x000fc40007ffe0ffULL, 0x0000000215117212ULL, 0x080fe200078e3cffULL,
0x000000010f0f7824ULL, 0x100fe200078e0a0eULL, 0x0000000219127212ULL, 0x080fe200078e3cffULL,
0x00006200060e7a24ULL, 0x000fe200078e020eULL, 0xfffffff814237812ULL, 0x000fe200078ee211ULL,
0x00000001071b7824ULL, 0x000fe200078e0228ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee212ULL,
0x0000200009117824ULL, 0x000fe200078e0210ULL, 0x0000007027257812ULL, 0x000fe200078ec0ffULL,
0x0000000113107824ULL, 0x100fe200078e020eULL, 0x000000021b127212ULL, 0x000fe200078e3cffULL,
0x0000000115137824ULL, 0x000fe200078e020eULL, 0x0000b00011247810ULL, 0x000fe20007ffe0ffULL,
0x000000081b157824ULL, 0x000fc400078e00ffULL, 0x0000000119187824ULL, 0x100fe400078e020eULL,
0x000000011b197824ULL, 0x000fe200078e020eULL, 0xfffffff815157812ULL, 0x000fe200078ee212ULL,
0x00000080ff1b7424ULL, 0x000fe200078e00ffULL, 0x000000200f127807ULL, 0x000fe20000000000ULL,
0x0000001023227824ULL, 0x000fe400078e0224ULL, 0x00005e00100e7625ULL, 0x000fe200078e001bULL,
0x0000001207167217ULL, 0x000fc60007800000ULL, 0x00005e0013107625ULL, 0x000fe200078e001bULL,
0x000000250e127210ULL, 0x000fc60007f1e0ffULL, 0x0000000116167824ULL, 0x000fe200078e0a07ULL,
0x0000002510147210ULL, 0x000fe20007f5e0ffULL, 0x0000001021217824ULL, 0x100fe400078e0224ULL,
0x000000102b237824ULL, 0x100fe200078e0224ULL, 0x000000162600720cULL, 0x080fe20003f66070ULL,
0x0000001015247824ULL, 0x000fe200078e0224ULL, 0x000000162800720cULL, 0x080fe20003f86070ULL,
0x000000ffff137224ULL, 0x000fe200000e060fULL, 0x000000161a00720cULL, 0x080fe20003f06070ULL,
0x000000ffff157224ULL, 0x000fe200010e0611ULL, 0x000000161c00720cULL, 0x000fe20003f46070ULL,
0x00005e00180e7625ULL, 0x000fe200078e001bULL, 0xffffffe008167812ULL, 0x000fc600078ec0ffULL,
0x00005e0019107625ULL, 0x000fe200078e001bULL, 0x000000250e0e7210ULL, 0x000fc60007fbe0ffULL,
0x000000085d1b7824ULL, 0x000fe200078e00ffULL, 0x0000002510107210ULL, 0x000fe20007fde0ffULL,
0x0000001009187824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012217faeULL, 0x0003e2000c101c46ULL, 0x000000ffff0f7224ULL, 0x000fe200028e060fULL,
0x000000081b197812ULL, 0x000fe200078e0cffULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0000f6a8181a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000014227faeULL, 0x0003e2000d101c46ULL,
0x0000001018257812ULL, 0x000fe400078ec0ffULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x000000011a1c7824ULL, 0x000fe200078e0219ULL, 0x000000000e237faeULL, 0x0003e2000d901c46ULL,
0x0000000808197812ULL, 0x000fc600078ec0ffULL, 0x0000000010247faeULL, 0x0003e2000e101c46ULL,
0x0000001619257210ULL, 0x000fc60007ffe025ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000001c0403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000011a1b7824ULL, 0x000fe200078e021bULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000001c0e7f8cULL, 0x0022a8000c80043fULL, 0x000004001b127984ULL, 0x0002e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080025107f8cULL, 0x000fe2000c80043fULL, 0x8000000012ff7812ULL, 0x008fc6000784481fULL,
0x00f60c0025137984ULL, 0x000ee40000000800ULL, 0x8000000013ff7812ULL, 0x008fe40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000b000000947ULL, 0x000fea0003800000ULL, 0x0000001008137812ULL, 0x000fe200078ec0ffULL,
0x3e000000ff127424ULL, 0x000fc800078e00ffULL, 0x0000000116137824ULL, 0x000fc800078e0213ULL,
0x000000080c137824ULL, 0x000fe400078e0213ULL, 0x0000001200147305ULL, 0x000724000021f000ULL,
0x3fa0000012127823ULL, 0x008fe200000100ffULL, 0x000000140000735dULL, 0x010fe20003800000ULL,
0x00f60c0013157984ULL, 0x000ee40000000800ULL, 0x8000000015ff7812ULL, 0x008fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000267824ULL, 0x000fe200078e00ffULL,
0x00000001ff287819ULL, 0x000fe40000011602ULL, 0x0000007027277812ULL, 0x000fc400078ec0ffULL,
0xffffff8026267812ULL, 0x000fe400078ec0ffULL, 0x0000000c28287812ULL, 0x000fc800078ec0ffULL,
0x0000002628107210ULL, 0x000fca0007ffe027ULL, 0x00f0000010127984ULL, 0x000ee80000000800ULL,
0x00f2000010167984ULL, 0x0008620000000800ULL, 0x0000000b1200720bULL, 0x008fe20003f1d000ULL,
0x00013e427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x010fc800000e0100ULL,
0x0000ffff10137812ULL, 0x000fe2000780c0ffULL, 0x000003e000007945ULL, 0x000fe20003800000ULL,
0x00000001ffa67424ULL, 0x000fd600078e00ffULL, 0x000003b000008947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x000fe40000011600ULL, 0x0000000b1200720bULL, 0x000fe40003f14000ULL,
0x000000001100720cULL, 0x000fe20003f65270ULL, 0x00013e127f007947ULL, 0x000ff4000b800000ULL,
0x0000000000107806ULL, 0x000fe400000e0100ULL, 0x000000800011b824ULL, 0x000fe200078e0227ULL,
0x000000120b147209ULL, 0x040fe40007810000ULL, 0x0000ffff10107812ULL, 0x000fe200078e3cffULL,
0x000000012811b824ULL, 0x000fe400078e0211ULL, 0x800000140b0b7221ULL, 0x000fe20000010000ULL,
0x0000001013ff7212ULL, 0x000fc4000780c0ffULL, 0x00f400141100b388ULL, 0x0007e20000000800ULL,
0x3fb8aa3b0b0b7820ULL, 0x000fe20000410000ULL, 0x00000002ff107819ULL, 0x000fc60000011602ULL,
0x0000000b00337308ULL, 0x0007220000000800ULL, 0x00013db27f007947ULL, 0x000fea000b800000ULL,
0x00001f10330b7589ULL, 0x01872400000e0000ULL, 0x0000000810107810ULL, 0x008fe20007ffe0ffULL,
0x00013df27f007947ULL, 0x000fea000b800000ULL, 0x00001f1033107589ULL, 0x00072400000e0000ULL,
0x8000001412120221ULL, 0x000fe20000010000ULL, 0x00000001ffa67807ULL, 0x000fe20000000000ULL,
0x0000000b39397220ULL, 0x090fe40000410000ULL, 0x3fb8aa3b12120820ULL, 0x000fe40000410000ULL,
0x0000000b38387220ULL, 0x080fe40000410000ULL, 0x0000001200290308ULL, 0x000f220000000800ULL,
0x0000000b3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000b3c3c7220ULL, 0x080fe40000410000ULL,
0x0000000b41417220ULL, 0x080fe40000410000ULL, 0x0000000b40407220ULL, 0x080fe40000410000ULL,
0x0000000b45457220ULL, 0x080fe40000410000ULL, 0x0000000b44447220ULL, 0x080fe40000410000ULL,
0x0000000b49497220ULL, 0x000fc40000410000ULL, 0x0000000b48487220ULL, 0x080fe40000410000ULL,
0x0000000b4d4d7220ULL, 0x080fe40000410000ULL, 0x0000000b4c4c7220ULL, 0x080fe40000410000ULL,
0x0000000b51517220ULL, 0x080fe40000410000ULL, 0x0000000b50507220ULL, 0x080fe40000410000ULL,
0x0000000b55557220ULL, 0x000fc40000410000ULL, 0x0000000b54547220ULL, 0x000fe40000410000ULL,
0x000000330d0d7220ULL, 0x000fe40000410000ULL, 0x000000103b3b7220ULL, 0x080fe40000410000ULL,
0x000000103a3a7220ULL, 0x080fe40000410000ULL, 0x000000103f3f7220ULL, 0x080fe40000410000ULL,
0x000000103e3e7220ULL, 0x000fc40000410000ULL, 0x0000001043437220ULL, 0x080fe40000410000ULL,
0x0000001042427220ULL, 0x080fe40000410000ULL, 0x0000001047477220ULL, 0x080fe40000410000ULL,
0x0000001046467220ULL, 0x080fe40000410000ULL, 0x000000104b4b7220ULL, 0x080fe40000410000ULL,
0x000000104a4a7220ULL, 0x000fc40000410000ULL, 0x000000104f4f7220ULL, 0x080fe40000410000ULL,
0x000000104e4e7220ULL, 0x080fe40000410000ULL, 0x0000001053537220ULL, 0x080fe40000410000ULL,
0x0000001052527220ULL, 0x080fe40000410000ULL, 0x0000001057577220ULL, 0x080fe40000410000ULL,
0x0000001056567220ULL, 0x000fc40000410000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0014ULL,
0x0000002916160220ULL, 0x012fe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000000d160d7221ULL, 0x002fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x000004001b107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe4000780481fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x000324000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x010fe20003800000ULL, 0x000004001b127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fc4000780481fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000029ff10723eULL, 0x000fe400000010ffULL, 0x00000002ff127819ULL, 0x000fe40000011602ULL,
0x0000541010337816ULL, 0x008fe20000000010ULL, 0x00013a927f007947ULL, 0x000fea000b800000ULL,
0x00001f1233ad7589ULL, 0x0002e400000e0000ULL, 0x00000008122a7810ULL, 0x000fe20007ffe0ffULL,
0x00013ad27f007947ULL, 0x000fea000b800000ULL, 0x00001f2a33a87589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001012347810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x00001ca000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0001490000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001812347810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x00001d0000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x000148a000007944ULL, 0x01cfea0003c00000ULL,
0x00000002005a7824ULL, 0x000fe200078e00ffULL, 0x0000000702117812ULL, 0x000fe200078ec0ffULL,
0x0000020000587824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000000045ad57812ULL, 0x000fc400078ec0ffULL, 0x0000000811dc7812ULL, 0x000fe400078ef802ULL,
0x000000d502d57211ULL, 0x000fe400078fe0ffULL, 0xfffff80058587812ULL, 0x000fe400078ec0ffULL,
0x00000007d5117812ULL, 0x000fca00078e78dcULL, 0x00000008dc2b7824ULL, 0x000fe200078e0211ULL,
0x0000000802117812ULL, 0x000fc600078ec0ffULL, 0x000000102b2b7824ULL, 0x000fe400078e0258ULL,
0x0000000400107824ULL, 0x040fe200078e00ffULL, 0x00000002d5d57810ULL, 0x000fe20007ffe0ffULL,
0x0000100000127824ULL, 0x002fc600078e00ffULL, 0x0000000410137812ULL, 0x000fe400078ec0ffULL,
0xffffe00012127812ULL, 0x000fe400078ec0ffULL, 0x0000000711107812ULL, 0x000fe400078ec802ULL,
0x0000001302137211ULL, 0x000fe200078fe0ffULL, 0x000010005d147824ULL, 0x000fe200078e0212ULL,
0x0000000711117812ULL, 0x000fe400078ef802ULL, 0x0000001310127212ULL, 0x000fc400078e3cffULL,
0x0000b000141f7810ULL, 0x000fe20007ffe0ffULL, 0x000010005d147824ULL, 0x000fe200078e020aULL,
0x0000008011317811ULL, 0x040fe200078e18ffULL, 0x00000008112c7824ULL, 0x000fe200078e0212ULL,
0x0000000213137810ULL, 0x000fe40007ffe0ffULL, 0x0000b00014327810ULL, 0x004fe20007ffe0ffULL,
0x000000102c347824ULL, 0x000fe200078e021fULL, 0x00000013101c7212ULL, 0x000fe200078e3cffULL,
0x00000001122d7824ULL, 0x000fc800078e0231ULL, 0x000000003434783bULL, 0x000e620000004200ULL,
0x000000102d187824ULL, 0x000fe400078e0232ULL, 0x00000008112e7824ULL, 0x000fc800078e021cULL,
0x000000001818783bULL, 0x000ea20000004200ULL, 0x000000102e107824ULL, 0x000fe200078e021fULL,
0x00000018ff127819ULL, 0x002fe20000011434ULL, 0x0000003400787306ULL, 0x000fe20000009400ULL,
0x00000018ff2f7819ULL, 0x000fe40000011435ULL, 0x00000018ff307819ULL, 0x000fe40000011436ULL,
0x00000018ff5b7819ULL, 0x000fe40000011437ULL, 0x00000018ff607819ULL, 0x004fe20000011419ULL,
0x0000001200727306ULL, 0x000fe20000209400ULL, 0x00000018ff617819ULL, 0x000fc4000001141aULL,
0x00000018ff1f7819ULL, 0x000fe40000011418ULL, 0x00000018ff627819ULL, 0x000fc6000001141bULL,
0x0000001200797306ULL, 0x000e700000205400ULL, 0x0000001200147306ULL, 0x000570000020d400ULL,
0x0000002f00d77306ULL, 0x000fe20000209400ULL, 0x000000001010783bULL, 0x004fe20000004200ULL,
0x000000797200720bULL, 0x002fcc0003f5d000ULL, 0x0000002f00d67306ULL, 0x000fee0000205400ULL,
0x0000000114142812ULL, 0x020fe200078efcffULL, 0x0000002f00157306ULL, 0x0003f0000020d400ULL,
0x0000006000a07306ULL, 0x000fe20000209400ULL, 0x000000011c2f7824ULL, 0x002fc800078e0231ULL,
0x000000102f327824ULL, 0x000fc600078e0232ULL, 0x00000060009f7306ULL, 0x000ff00000205400ULL,
0x00000060001c7306ULL, 0x0003f0000020d400ULL, 0x0000003400e97306ULL, 0x000ea20000005400ULL,
0x0000010034607824ULL, 0x002fca00078e00ffULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x0000003400ae7306ULL, 0x000370000000d400ULL, 0x0000003000d47306ULL, 0x000fe20000209400ULL,
0x0001000034347824ULL, 0x002fe200078e00ffULL, 0x000000e97800720bULL, 0x004fc40003f9d000ULL,
0x00000007d5e97812ULL, 0x000fe400078e78dcULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003000cb7306ULL, 0x000e620000205400ULL, 0x00000008dce97824ULL, 0x000fc800078e02e9ULL,
0x00000010e9587824ULL, 0x000fe400078e0258ULL, 0x00000001aeae4812ULL, 0x020fe200078efcffULL,
0x0000003400ed7306ULL, 0x000fe20000209400ULL, 0x000000d6d700720bULL, 0x000fce0003f9d000ULL,
0x0000003400f07306ULL, 0x000eac0000205400ULL, 0x0000000115154812ULL, 0x000fe400078efcffULL,
0x0000003400a77306ULL, 0x000b22000020d400ULL, 0x000000cbd400720bULL, 0x002fce0003f9d000ULL,
0x0000003000917306ULL, 0x0002e2000020d400ULL, 0x0000010037347824ULL, 0x020fe200078e00ffULL,
0x000000f0ed00720bULL, 0x004fc80003fdd000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000005b00cf7306ULL, 0x000fe20000209400ULL, 0x000000003230783bULL, 0x012e6c0000004200ULL,
0x00000001a7a76812ULL, 0x000fe200078efcffULL, 0x0000005b00cc7306ULL, 0x000fe20000205400ULL,
0x0000000191914812ULL, 0x008fc400078efcffULL, 0x000000a71414723eULL, 0x000fca00000010ffULL,
0x0000005b008e7306ULL, 0x000ff0000020d400ULL, 0x00000061007f7306ULL, 0x000ff00000209400ULL,
0x0000006100827306ULL, 0x000ff00000205400ULL, 0x00000061005b7306ULL, 0x0005e2000020d400ULL,
0x00000018ff7d7819ULL, 0x002fc40000011432ULL, 0x00000018ff7e7819ULL, 0x000fe40000011433ULL,
0x00000018ff717819ULL, 0x000fc60000011431ULL, 0x0000003500dd7306ULL, 0x000fe20000009400ULL,
0x0000010035617824ULL, 0x004fca00078e00ffULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000003500da7306ULL, 0x000e700000005400ULL, 0x0000003500a57306ULL, 0x0004f0000000d400ULL,
0x0000003400e57306ULL, 0x000fe20000209400ULL, 0x0001000035357824ULL, 0x004fe200078e00ffULL,
0x000000dadd00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400ea7306ULL, 0x000e6e0000205400ULL, 0x00000001a5a53812ULL, 0x008fe200078efcffULL,
0x00000034009e7306ULL, 0x0004f0000020d400ULL, 0x0000003700de7306ULL, 0x000fe20000009400ULL,
0x00000018ff347819ULL, 0x004fc40000011411ULL, 0x000000eae500720bULL, 0x002fca0003f7d000ULL,
0x0000003700d97306ULL, 0x000ff00000005400ULL, 0x0000003700997306ULL, 0x0003e2000000d400ULL,
0x000000019e9e3812ULL, 0x008fce00078efcffULL, 0x0000006000eb7306ULL, 0x000fe20000209400ULL,
0x0001000037377824ULL, 0x002fca00078e00ffULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000006000ee7306ULL, 0x000e700000205400ULL, 0x0000006000b77306ULL, 0x0004f0000020d400ULL,
0x0000003500e37306ULL, 0x000fe20000209400ULL, 0x0000010036607824ULL, 0x004fe200078e00ffULL,
0x000000eeeb00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x0000003500e67306ULL, 0x000e6e0000205400ULL, 0x00000001b7b75812ULL, 0x008fe200078efcffULL,
0x0000003500a47306ULL, 0x0004f0000020d400ULL, 0x0000003400d27306ULL, 0x000fe20000209400ULL,
0x00000018ff357819ULL, 0x004fc40000011410ULL, 0x000000e6e300720bULL, 0x002fca0003fbd000ULL,
0x0000003400d37306ULL, 0x000ff00000205400ULL, 0x0000003400857306ULL, 0x0003e2000020d400ULL,
0x00000001a4a45812ULL, 0x008fc800078efcffULL, 0x000000a41515723eULL, 0x000fc600000010ffULL,
0x0000003500db7306ULL, 0x000fe20000209400ULL, 0x0000010019347824ULL, 0x002fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003500e07306ULL, 0x000ff00000205400ULL,
0x0000003500837306ULL, 0x0003f0000020d400ULL, 0x0000001800b57306ULL, 0x000fe20000009400ULL,
0x0000010018357824ULL, 0x002fce00078e00ffULL, 0x0000001800b67306ULL, 0x000ff00000005400ULL,
0x00000018005f7306ULL, 0x0003f0000000d400ULL, 0x0000003600a37306ULL, 0x000fe20000009400ULL,
0x0001000018187824ULL, 0x002fca00078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000003600d87306ULL, 0x000e700000005400ULL, 0x00000036009a7306ULL, 0x0004f0000000d400ULL,
0x0000006000e27306ULL, 0x000fe20000209400ULL, 0x0001000036367824ULL, 0x004fe200078e00ffULL,
0x000000d8a300720bULL, 0x002fc80003f5d000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000006000df7306ULL, 0x000e6e0000205400ULL, 0x000000019a9a2812ULL, 0x008fe200078efcffULL,
0x00000060009d7306ULL, 0x0004e2000020d400ULL, 0x000000cccf00720bULL, 0x000fce0003f5d000ULL,
0x0000003700e77306ULL, 0x000fe20000209400ULL, 0x00000018ff607819ULL, 0x004fe40000011435ULL,
0x000000dfe200720bULL, 0x002fc60003fdd000ULL, 0x000000018e8e2812ULL, 0x000fe400078efcffULL,
0x0000003700ec7306ULL, 0x000e700000205400ULL, 0x0000003700977306ULL, 0x000522000020d400ULL,
0x000000019d9d6812ULL, 0x008fce00078efcffULL, 0x0000003400c37306ULL, 0x000fe20000209400ULL,
0x00000018ff377819ULL, 0x004fe40000011413ULL, 0x000000ece700720bULL, 0x002fca0003fdd000ULL,
0x0000003400c47306ULL, 0x000ff00000205400ULL, 0x0000003400357306ULL, 0x0003e2000020d400ULL,
0x0000000197976812ULL, 0x010fe400078efcffULL, 0x000000e0db00720bULL, 0x000fca0003fdd000ULL,
0x0000003700bf7306ULL, 0x000fe20000209400ULL, 0x000001001b347824ULL, 0x002fce00078e00ffULL,
0x0000003700c07306ULL, 0x000fe20000205400ULL, 0x0000000183836812ULL, 0x000fce00078efcffULL,
0x0000003700767306ULL, 0x000ff0000020d400ULL, 0x0000001800b97306ULL, 0x000ff00000209400ULL,
0x0000001800ba7306ULL, 0x000ff00000205400ULL, 0x0000001800377306ULL, 0x0003f0000020d400ULL,
0x0000003600e87306ULL, 0x000fe20000209400ULL, 0x00000018ff187819ULL, 0x002fce0000011434ULL,
0x0000003600e17306ULL, 0x000e700000205400ULL, 0x0000003600987306ULL, 0x0004f0000020d400ULL,
0x0000001900b37306ULL, 0x000fe20000009400ULL, 0x00000018ff367819ULL, 0x004fc40000011412ULL,
0x000000e1e800720bULL, 0x002fca0003fbd000ULL, 0x0000001900b47306ULL, 0x000ff00000005400ULL,
0x0000001900167306ULL, 0x0003e2000000d400ULL, 0x0000000198985812ULL, 0x008fce00078efcffULL,
0x0000001800967306ULL, 0x000fe20000209400ULL, 0x0001000019197824ULL, 0x002fca00078e00ffULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x0000001800937306ULL, 0x000ff00000205400ULL,
0x0000001800347306ULL, 0x0003f0000020d400ULL, 0x0000003600bd7306ULL, 0x000fe20000209400ULL,
0x0000010010187824ULL, 0x002fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe20000011418ULL,
0x0000010011187824ULL, 0x000fe200078e00ffULL, 0x0000003600be7306ULL, 0x000e700000205400ULL,
0x0000003600757306ULL, 0x0004f0000020d400ULL, 0x0000006100e47306ULL, 0x000fe20000209400ULL,
0x000001001a367824ULL, 0x004fe200078e00ffULL, 0x000000bebd00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000006100777306ULL, 0x000e6e0000205400ULL,
0x0000000175756812ULL, 0x008fe200078efcffULL, 0x0000006100b87306ULL, 0x000eb0000020d400ULL,
0x0000001900a17306ULL, 0x000fe20000209400ULL, 0x00000077e400720bULL, 0x002fce0003f1d000ULL,
0x0000001900a27306ULL, 0x000fec0000205400ULL, 0x00000001b8b80812ULL, 0x004fe400078efcffULL,
0x0000001900617306ULL, 0x0003e2000020d400ULL, 0x000000d9de00720bULL, 0x000fce0003f1d000ULL,
0x0000006000c17306ULL, 0x000fe20000209400ULL, 0x00000018ff197819ULL, 0x002fca0000011430ULL,
0x0000000199990812ULL, 0x000fe400078efcffULL, 0x0000006000c27306ULL, 0x000ff00000205400ULL,
0x00000060006a7306ULL, 0x000ff0000020d400ULL, 0x0000007d00677306ULL, 0x000ff00000209400ULL,
0x0000007d00607306ULL, 0x000ff00000205400ULL, 0x0000007d00697306ULL, 0x0003f0000020d400ULL,
0x00000036009b7306ULL, 0x000fe20000209400ULL, 0x00000018ff7d7819ULL, 0x002fce0000011418ULL,
0x00000036009c7306ULL, 0x000ff00000205400ULL, 0x0000003600637306ULL, 0x000ff0000020d400ULL,
0x0000001900367306ULL, 0x000ff00000209400ULL, 0x00000019006f7306ULL, 0x000ff00000205400ULL,
0x00000019006b7306ULL, 0x000ff0000020d400ULL, 0x0000007d00187306ULL, 0x000ff00000209400ULL,
0x0000007d00197306ULL, 0x000e700000205400ULL, 0x0000001a00b27306ULL, 0x000ff00000009400ULL,
0x0000001a00ab7306ULL, 0x000ea20000005400ULL, 0x000000191800720bULL, 0x002fce0003f9d000ULL,
0x0000001a005c7306ULL, 0x0002f0000000d400ULL, 0x0000001b00b17306ULL, 0x000fe20000009400ULL,
0x000100001a1a7824ULL, 0x002fe200078e00ffULL, 0x000000abb200720bULL, 0x004fc80003fdd000ULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x0000001b00ac7306ULL, 0x000fee0000005400ULL,
0x000000015c5c6812ULL, 0x008fe200078efcffULL, 0x0000001b00597306ULL, 0x0003f0000000d400ULL,
0x0000001a00887306ULL, 0x000fe20000209400ULL, 0x000100001b1b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff1b7819ULL, 0x000fe4000001141bULL, 0x0000001a008b7306ULL, 0x000e700000205400ULL,
0x0000001a006e7306ULL, 0x000eb0000020d400ULL, 0x0000001b00867306ULL, 0x000fe20000209400ULL,
0x0000008b8800720bULL, 0x002fce0003fdd000ULL, 0x0000001b00877306ULL, 0x000fec0000205400ULL,
0x000000016e6e6812ULL, 0x004fe400078efcffULL, 0x0000001b00667306ULL, 0x000ff0000020d400ULL,
0x0000007d00907306ULL, 0x000e70000020d400ULL, 0x0000001100c67306ULL, 0x000ff00000009400ULL,
0x0000001100c57306ULL, 0x000ea20000005400ULL, 0x0000000190904812ULL, 0x002fce00078efcffULL,
0x0000001200bb7306ULL, 0x000ff00000009400ULL, 0x0000001200bc7306ULL, 0x000e620000005400ULL,
0x000000c5c600720bULL, 0x004fce0003fbd000ULL, 0x00000070001a7306ULL, 0x000ff00000209400ULL,
0x00000070001b7306ULL, 0x000ea20000205400ULL, 0x000000bcbb00720bULL, 0x002fe40003f9d000ULL,
0x00009910a6bb7816ULL, 0x000fca00000000ffULL, 0x0000001f00af7306ULL, 0x000ff00000209400ULL,
0x0000001f00b07306ULL, 0x000fe20000205400ULL, 0x0000001b1a00720bULL, 0x004fe40003f7d000ULL,
0x009000002b18783bULL, 0x000e6a0000000200ULL, 0x0000001f005e7306ULL, 0x000ff0000020d400ULL,
0x0000006200817306ULL, 0x000ff00000209400ULL, 0x0000006200847306ULL, 0x000ff00000205400ULL,
0x00000062001f7306ULL, 0x000ff0000020d400ULL, 0x0000001000cd7306ULL, 0x000ff00000009400ULL,
0x0000001000ce7306ULL, 0x000eb00000005400ULL, 0x00000010007a7306ULL, 0x000730000000d400ULL,
0x0000007e00657306ULL, 0x000fe20000209400ULL, 0x0001000010107824ULL, 0x008fe200078e00ffULL,
0x000000cecd00720bULL, 0x004fcc0003f1d000ULL, 0x0000007e006c7306ULL, 0x000fee0000205400ULL,
0x000000017a7a0812ULL, 0x010fe200078efcffULL, 0x0000007e00627306ULL, 0x0005f0000020d400ULL,
0x00000011007b7306ULL, 0x000722000000d400ULL, 0x00000100127e7824ULL, 0x004fca00078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe2000001147eULL, 0x00000100137e7824ULL, 0x000fe200078e00ffULL,
0x0000007100687306ULL, 0x000fe20000209400ULL, 0x0001000011117824ULL, 0x008fc600078e00ffULL,
0x00000018ff807819ULL, 0x000fc8000001147eULL, 0x00000071006d7306ULL, 0x000fe20000205400ULL,
0x000000017b7b5812ULL, 0x010fc800078efcffULL, 0x0000007b907b723eULL, 0x000fc600000010ffULL,
0x0000007100647306ULL, 0x0005f0000020d400ULL, 0x0000001200747306ULL, 0x000722000000d400ULL,
0x00000018ff717819ULL, 0x004fce0000011410ULL, 0x00000070008f7306ULL, 0x000562000020d400ULL,
0x0001000012127824ULL, 0x008fca00078e00ffULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x0000007100107306ULL, 0x000fe20000209400ULL, 0x00000018ff707819ULL, 0x004fe40000011411ULL,
0x0000000174744812ULL, 0x010fe400078efcffULL, 0x000000c0bf00720bULL, 0x000fc60003f9d000ULL,
0x0000007100ef7306ULL, 0x000ea20000205400ULL, 0x000000018f8f3812ULL, 0x020fe400078efcffULL,
0x000000d3d200720bULL, 0x000fe40003f7d000ULL, 0x0000007a8f7a723eULL, 0x000fc600000010ffULL,
0x0000007d00c77306ULL, 0x000fe40000209400ULL, 0x0000000176764812ULL, 0x000fe400078efcffULL,
0x000000c4c300720bULL, 0x000fc80003f9d000ULL, 0x0000007d00c87306ULL, 0x000ee20000205400ULL,
0x000000ef1000720bULL, 0x004fe40003f5d000ULL, 0x0000000185853812ULL, 0x000fca00078efcffULL,
0x0000001300aa7306ULL, 0x000fe20000009400ULL, 0x0000000135354812ULL, 0x000fe400078efcffULL,
0x000000bab900720bULL, 0x000fca0003f9d000ULL, 0x0000001300a97306ULL, 0x000fe20000005400ULL,
0x000000c8c700720bULL, 0x008fce0003fbd000ULL, 0x0000001300737306ULL, 0x0005e2000000d400ULL,
0x0000000137374812ULL, 0x000fe400078efcffULL, 0x0000009c9b00720bULL, 0x000fca0003f9d000ULL,
0x0000007000f27306ULL, 0x000fe20000209400ULL, 0x0001000013137824ULL, 0x004fca00078e00ffULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000007000117306ULL, 0x000ea20000205400ULL,
0x0000000163634812ULL, 0x000fce00078efcffULL, 0x0000001200d07306ULL, 0x000ff00000209400ULL,
0x0000001200d17306ULL, 0x000ee20000205400ULL, 0x00000011f200720bULL, 0x004fce0003f1d000ULL,
0x00000012007e7306ULL, 0x000530000020d400ULL, 0x0000007100947306ULL, 0x000f62000020d400ULL,
0x0000010030127824ULL, 0x004fe200078e00ffULL, 0x000000d1d000720bULL, 0x008fc80003f7d000ULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x0000007d00897306ULL, 0x000eae000020d400ULL,
0x000000017e7e3812ULL, 0x010fe200078efcffULL, 0x0000001300d57306ULL, 0x000fe20000209400ULL,
0x0000000194942812ULL, 0x020fc400078efcffULL, 0x000000a9aa00720bULL, 0x000fe40003f5d000ULL,
0x000000b4b300720bULL, 0x000fe40003f7d000ULL, 0x0000007e757e723eULL, 0x000fe200000010ffULL,
0x0000001300d67306ULL, 0x000ee20000205400ULL, 0x0000000189895812ULL, 0x004fce00078efcffULL,
0x0000001300a37306ULL, 0x000522000020d400ULL, 0x0000000173732812ULL, 0x000fe400078efcffULL,
0x000000b6b500720bULL, 0x000fe40003f5d000ULL, 0x0000000116163812ULL, 0x000fe400078efcffULL,
0x000000a2a100720bULL, 0x000fe20003f7d000ULL, 0x0000007000927306ULL, 0x000f62000020d400ULL,
0x0000010031137824ULL, 0x004fe200078e00ffULL, 0x000000d6d500720bULL, 0x008fc80003fbd000ULL,
0x00000018ffcd7819ULL, 0x000fe40000011413ULL, 0x0000008000c97306ULL, 0x000fe20000209400ULL,
0x000000015f5f2812ULL, 0x000fe400078efcffULL, 0x0000009fa000720bULL, 0x000fe40003f5d000ULL,
0x0000000161613812ULL, 0x000fe400078efcffULL, 0x00000001a3a35812ULL, 0x010fe200078efcffULL,
0x0000008000ca7306ULL, 0x000ea20000205400ULL, 0x0000000192920812ULL, 0x020fc400078efcffULL,
0x000000c2c100720bULL, 0x000fe40003fbd000ULL, 0x000000848100720bULL, 0x000fe40003f7d000ULL,
0x000000948384723eULL, 0x000fe200000010ffULL, 0x0000001200cb7306ULL, 0x000fe20000209400ULL,
0x000000011c1c2812ULL, 0x000fe400078efcffULL, 0x000000939600720bULL, 0x000fe40003f5d000ULL,
0x000000928585723eULL, 0x000fc600000010ffULL, 0x0000001200cc7306ULL, 0x000fe20000205400ULL,
0x000000cac900720bULL, 0x004fe40003f1d000ULL, 0x000000016a6a5812ULL, 0x000fe400078efcffULL,
0x000000b0af00720bULL, 0x000fe40003fbd000ULL, 0x000000011f1f3812ULL, 0x000fe200078efcffULL,
0x0000001200c57306ULL, 0x0005e2000020d400ULL, 0x0000000134342812ULL, 0x000fce00078efcffULL,
0x00000080008a7306ULL, 0x000ee2000020d400ULL, 0x009000005810783bULL, 0x004ea20000000200ULL,
0x000000015e5e5812ULL, 0x000fe400078efcffULL, 0x000000827f00720bULL, 0x000fe40003fbd000ULL,
0x000000a3767f723eULL, 0x000fe400000010ffULL, 0x00000030007c7306ULL, 0x000fe20000009400ULL,
0x000000375e5e723eULL, 0x000fe400000010ffULL, 0x000000018a8a0812ULL, 0x008fca00078efcffULL,
0x0000003000957306ULL, 0x000ee20000005400ULL, 0x000000ffbb00720cULL, 0x000fe40003f05270ULL,
0x000000015b5b5812ULL, 0x000fe400078efcffULL, 0x000000cccb00720bULL, 0x000fe40003fbd000ULL,
0x0000006e5b6e723eULL, 0x000fe200000010ffULL, 0x0000003000707306ULL, 0x00096c000000d400ULL,
0x000000ad18188231ULL, 0x002fc400003400ffULL, 0x00000031008c7306ULL, 0x000fe20000009400ULL,
0x0001000030307824ULL, 0x010fe200078e00ffULL, 0x000000ad1a1a8231ULL, 0x080fe200003400ffULL,
0x000000957c00720bULL, 0x008fe20003f9d000ULL, 0x000000a819198231ULL, 0x080fe200003400ffULL,
0x00000001c5c55812ULL, 0x000fe200078efcffULL, 0x000000a81b1b8231ULL, 0x000fe200003400ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x00000031008d7306ULL, 0x000e620000005400ULL,
0x000000ad10108231ULL, 0x084fe200003400ffULL, 0x0000006f3600720bULL, 0x000fe20003fbd000ULL,
0x000000ad12128231ULL, 0x000fc400003400ffULL, 0x000000141850723cULL, 0x040fe20000041850ULL,
0x000000a811118231ULL, 0x080fe400003400ffULL, 0x0000003100717306ULL, 0x0004e2000000d400ULL,
0x000000a813138231ULL, 0x000fe200003400ffULL, 0x0000000170704812ULL, 0x020fe400078efcffULL,
0x000000989114723eULL, 0x000fe200000010ffULL, 0x0000007a1844723cULL, 0x000fe20000041844ULL,
0x000000978e15723eULL, 0x000fe400000010ffULL, 0x0000003000a67306ULL, 0x000fe20000209400ULL,
0x0001000031317824ULL, 0x004fe200078e00ffULL, 0x000000acb100720bULL, 0x000fc40003f1d000ULL,
0x0000008d8c00720bULL, 0x002fe20003f5d000ULL, 0x000000141848723cULL, 0x040fe20000041848ULL,
0x00000018ffad7819ULL, 0x000fe40000011431ULL, 0x0000003000b37306ULL, 0x000e620000205400ULL,
0x000000a5b831723eULL, 0x000fe400000010ffULL, 0x000000016b6b5812ULL, 0x000fe400078efcffULL,
0x000000748914723eULL, 0x000fe200000010ffULL, 0x000000841840723cULL, 0x000fe20000041840ULL,
0x000000738a15723eULL, 0x000fe200000010ffULL, 0x0000003000b27306ULL, 0x000522000020d400ULL,
0x0000000159590812ULL, 0x000fc400078efcffULL, 0x0000000171712812ULL, 0x008fe400078efcffULL,
0x000000878600720bULL, 0x000fe20003f1d000ULL, 0x00000014183c723cULL, 0x040fe2000004183cULL,
0x0000006d6800720bULL, 0x000fe20003f5d000ULL, 0x000000cd00c67306ULL, 0x000fe20000209400ULL,
0x000000aeb730723eULL, 0x004fe400000010ffULL, 0x000000b3a600720bULL, 0x002fe40003f9d000ULL,
0x0000005f6a14723eULL, 0x000fe200000010ffULL, 0x0000007e1838723cULL, 0x000fe20000041838ULL,
0x000000163515723eULL, 0x000fe200000010ffULL, 0x000000cd00a97306ULL, 0x000e620000205400ULL,
0x000000606700720bULL, 0x000fc40003fbd000ULL, 0x0000000166660812ULL, 0x000fe400078efcffULL,
0x0000000164642812ULL, 0x000fe200078efcffULL, 0x000000301854723cULL, 0x000fe20000041854ULL,
0x000000611c5f723eULL, 0x000fe200000010ffULL, 0x00000032007d7306ULL, 0x000fe20000009400ULL,
0x00000001b2b24812ULL, 0x010fe400078efcffULL, 0x000000661f6f723eULL, 0x000fe400000010ffULL,
0x0000010032317824ULL, 0x000fe200078e00ffULL, 0x0000009a9d30723eULL, 0x000fe200000010ffULL,
0x00000100339d7824ULL, 0x000fe200078e00ffULL, 0x0000003200807306ULL, 0x000ea20000005400ULL,
0x000000a9c600720bULL, 0x002fe20003f7d000ULL, 0x0000005e1050723cULL, 0x000fe20000041850ULL,
0x00000018ff9a7819ULL, 0x000fc40000011431ULL, 0x000000999e31723eULL, 0x000fe200000010ffULL,
0x0001000032997824ULL, 0x000fe200078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe2000001149dULL,
0x0000003200727306ULL, 0x000e62000000d400ULL, 0x00010000339e7824ULL, 0x000fe200078e00ffULL,
0x0000000169695812ULL, 0x000fe200078efcffULL, 0x0000006e1048723cULL, 0x000fe20000041848ULL,
0x00000018ff997819ULL, 0x000fe40000011499ULL, 0x00000018ff9e7819ULL, 0x000fe4000001149eULL,
0x000000cd00aa7306ULL, 0x000ee2000020d400ULL, 0x000000807d00720bULL, 0x004fc40003fdd000ULL,
0x00000030184c723cULL, 0x000fe2000004184cULL, 0x00000070c570723eULL, 0x000fe400000010ffULL,
0x000000b26bb2723eULL, 0x000fe400000010ffULL, 0x000000ad00ab7306ULL, 0x000fe60000209400ULL,
0x000000141054723cULL, 0x000fe60000041854ULL, 0x0000000172726812ULL, 0x002fc400078efcffULL,
0x000000ad00a87306ULL, 0x000e620000205400ULL, 0x00000001aaaa3812ULL, 0x008fe400078efcffULL,
0x0000005c6314723eULL, 0x000fe400000010ffULL, 0x000000593415723eULL, 0x000fe400000010ffULL,
0x00000071aa71723eULL, 0x000fe200000010ffULL, 0x0000009a00327306ULL, 0x000fe80000209400ULL,
0x00000014104c723cULL, 0x000fe8000004184cULL, 0x0000009a00317306ULL, 0x000ea20000205400ULL,
0x000000a8ab00720bULL, 0x002fc60003f7d000ULL, 0x000000701044723cULL, 0x000fe80000041844ULL,
0x0000003300787306ULL, 0x000ff00000009400ULL, 0x0000003300797306ULL, 0x000e620000005400ULL,
0x000000313200720bULL, 0x004fce0003f9d000ULL, 0x0000003300777306ULL, 0x000eb0000000d400ULL,
0x000000ad009f7306ULL, 0x000ee2000020d400ULL, 0x000000797800720bULL, 0x002fce0003f1d000ULL,
0x0000009a00337306ULL, 0x000e6c000020d400ULL, 0x0000000177770812ULL, 0x004fe400078efcffULL,
0x0000009d007c7306ULL, 0x000fe20000209400ULL, 0x000000019f9f3812ULL, 0x008fe400078efcffULL,
0x0000006c6500720bULL, 0x000fc40003f7d000ULL, 0x0000009f64b3723eULL, 0x000fc600000010ffULL,
0x0000009d007b7306ULL, 0x000ea20000205400ULL, 0x0000000133334812ULL, 0x002fc600078efcffULL,
0x000000b21040723cULL, 0x000fe20000041840ULL, 0x000000723372723eULL, 0x000fc600000010ffULL,
0x0000009900307306ULL, 0x000fe20000209400ULL, 0x0000000162623812ULL, 0x000fce00078efcffULL,
0x0000009900197306ULL, 0x000e620000205400ULL, 0x0000007b7c00720bULL, 0x004fce0003f5d000ULL,
0x0000009e00167306ULL, 0x000ff00000209400ULL, 0x0000009e001b7306ULL, 0x000ea20000205400ULL,
0x000000193000720bULL, 0x002fce0003f9d000ULL, 0x0000009d00747306ULL, 0x000e70000020d400ULL,
0x0000009900147306ULL, 0x000ee2000020d400ULL, 0x0000001b1600720bULL, 0x004fce0003fdd000ULL,
0x0000009e00157306ULL, 0x000ea2000020d400ULL, 0x0000000174742812ULL, 0x002fc800078efcffULL,
0x000000777473723eULL, 0x000fe400000010ffULL, 0x0000000114144812ULL, 0x008fc800078efcffULL,
0x000000146914723eULL, 0x000fe200000010ffULL, 0x00000072103c723cULL, 0x000fe2000004183cULL,
0x0000000115156812ULL, 0x004fc800078efcffULL, 0x000000156215723eULL, 0x000fce00000010ffULL,
0x000000141038723cULL, 0x000fe20000041838ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200017107f8cULL, 0x0002a2000c80043fULL, 0xfffffff85a597812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004020107810ULL, 0x004fe20007ffe0ffULL,
0x00f6880059ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff157224ULL, 0x000fe200078e0011ULL,
0x000000015d5d7812ULL, 0x000fe200078e0cffULL, 0x000000ffff1f7224ULL, 0x000fe200078e000fULL,
0x000000031000720cULL, 0x000fda0003f06070ULL, 0x000084a000000947ULL, 0x000fea0003800000ULL,
0x000004001d107984ULL, 0x004ea40000000800ULL, 0x8000000010ff7812ULL, 0x004fe40007804815ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000240017107984ULL, 0x000ea40000000800ULL,
0x8000000010ff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff097424ULL, 0x000fc800078e00ffULL,
0x0000000900107305ULL, 0x0004e4000021f000ULL, 0x3fa0000009097823ULL, 0x004fe200000100ffULL,
0x000000100000735dULL, 0x008fe40003800000ULL, 0x0000240017107984ULL, 0x000ea40000000800ULL,
0x8000000010ff7812ULL, 0x004fc40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000402107811ULL, 0x040fe200078fe8ffULL, 0x00000080ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000000702117211ULL, 0x000fe200078fe8ffULL, 0x000000081e5b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011600ULL, 0x0000000107137824ULL, 0x000fe200078e0210ULL,
0x0000000211127212ULL, 0x0c0fe200078e3cffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x0000000104147810ULL, 0x000fe20007ffe0ffULL, 0x0000002009117824ULL, 0x000fe200078e0220ULL,
0x0000000213107212ULL, 0x040fe200078e3cffULL, 0x0000000813677824ULL, 0x000fe200078e00ffULL,
0x000000051400720cULL, 0x000fe20003f06070ULL, 0x000010001e5a7824ULL, 0x000fe200078e00ffULL,
0x0000008011137810ULL, 0x000fc40007ffe0ffULL, 0xfffffff867677812ULL, 0x000fe400078ee210ULL,
0x0000000802107811ULL, 0x000fe200078fe8ffULL, 0x0000620006167a24ULL, 0x100fe200078e0213ULL,
0xfffffff815667812ULL, 0x000fe400078ee212ULL, 0x0000001303147217ULL, 0x000fe20007800000ULL,
0x0000000107117824ULL, 0x000fe200078e0210ULL, 0x00000003ff1f7819ULL, 0x000fe40000011602ULL,
0x0000000c02127811ULL, 0x000fe200078fe8ffULL, 0x0000000114107824ULL, 0x000fe200078e0a13ULL,
0x000000041f1b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000811317824ULL, 0x040fe200078e00ffULL,
0x0000000211147212ULL, 0x000fe200078e3cffULL, 0x0000000107137824ULL, 0x000fe200078e0212ULL,
0x0000001f16127210ULL, 0x000fc40007ffe007ULL, 0x0000001b16197210ULL, 0x100fe20007ffe007ULL,
0x0000000813307824ULL, 0x040fe200078e00ffULL, 0x0000002010187807ULL, 0x000fe20000000000ULL,
0x00005e0012107625ULL, 0x000fe200078e001cULL, 0x0000000213157212ULL, 0x000fe400078e3cffULL,
0x00000018071a7217ULL, 0x000fe20007800000ULL, 0x00005e0019127625ULL, 0x000fe200078e001cULL,
0xfffffff831687812ULL, 0x000fe400078ee214ULL, 0x0000002710147210ULL, 0x080fe20007f1e0ffULL,
0x000000011a1a7824ULL, 0x000fe200078e0a07ULL, 0x0000002712187210ULL, 0x000fc40007f5e0ffULL,
0x0000f6a809647811ULL, 0x000fe400078e20ffULL, 0xfffffff830697812ULL, 0x000fe200078ee215ULL,
0x000000ffff197224ULL, 0x000fe200010e0613ULL, 0x0000001a1b00720cULL, 0x080fe20003f46070ULL,
0x000000ffff157224ULL, 0x000fe200000e0611ULL, 0x000000085b1b7812ULL, 0x000fe400078ec0ffULL,
0x000010005a107812ULL, 0x000fe400078ec0ffULL, 0x000000081f137810ULL, 0x040fe20007ffe0ffULL,
0x0000000164657824ULL, 0x000fe200078e021bULL, 0x0000001a1f00720cULL, 0x000fe20003f06070ULL,
0x0000200009107824ULL, 0x000fe200078e0210ULL, 0x0000000c1f1f7810ULL, 0x000fe20007ffe0ffULL,
0x00000000650473c2ULL, 0x000ea200000e0000ULL, 0x0000001316117210ULL, 0x000fc40007ffe007ULL,
0x0000001f16127210ULL, 0x000fe40007ffe007ULL, 0x0000b00010167810ULL, 0x000fe20007ffe0ffULL,
0x00005e0011107625ULL, 0x000fe200078e001cULL, 0x0000001a1300720cULL, 0x080fe40003f66070ULL,
0x0000001a1f00720cULL, 0x000fe20003f86070ULL, 0x00005e0012127625ULL, 0x000fe200078e001cULL,
0x0000002710107210ULL, 0x080fe40007fbe0ffULL, 0x000000081b1b7812ULL, 0x000fe200078e3cffULL,
0x0000001066667824ULL, 0x100fe200078e0216ULL, 0x0000002712127210ULL, 0x000fe20007fde0ffULL,
0x0000001067677824ULL, 0x000fc400078e0216ULL, 0x0000001068687824ULL, 0x100fe200078e0216ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014667faeULL, 0x0007e2000c101c46ULL,
0x000000ffff117224ULL, 0x000fe400028e0611ULL, 0x0000001069697824ULL, 0x000fe200078e0216ULL,
0x0000000018677faeULL, 0x0007e2000d101c46ULL, 0x000000ffff137224ULL, 0x000fe400030e0613ULL,
0x00000001646a7824ULL, 0x000fe200078e021bULL, 0x0000000010687faeULL, 0x0007e8000d901c46ULL,
0x0000000012697faeULL, 0x0007e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x004fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000065107f8cULL, 0x0084e8000c80043fULL,
0x000004006a157984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6280025127f8cULL, 0x000fe2000c80043fULL,
0x8000000015ff7812ULL, 0x010fc6000784480fULL, 0x00f62c0025197984ULL, 0x000f240000000800ULL,
0x8000000019ff7812ULL, 0x010fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1f7224ULL, 0x008fe200078e0011ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000000808107812ULL, 0x040fe200078ec0ffULL,
0x3e000000ff117424ULL, 0x000fe200078e00ffULL, 0xffffffe008157812ULL, 0x040fe400078ec0ffULL,
0x0000001008147812ULL, 0x000fc800078ec0ffULL, 0x0000001510107210ULL, 0x000fe40007ffe014ULL,
0x0000001100147305ULL, 0x000724000021f000ULL, 0x3fa0000011117823ULL, 0x008fe200000100ffULL,
0x000000140000735dULL, 0x010fe20003800000ULL, 0x00f62c0010157984ULL, 0x000ee40000000800ULL,
0x8000000015ff7812ULL, 0x008fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008027117810ULL, 0x000fca0007ffe026ULL, 0x0000000128117824ULL, 0x000fca00078e0211ULL,
0x00f0000011107984ULL, 0x000ee80000000800ULL, 0x00f2000011127984ULL, 0x0008620000000800ULL,
0x0000000b1000720bULL, 0x008fe20003f1d000ULL, 0x000111327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000117806ULL, 0x010fc800000e0100ULL, 0x0000ffff11137812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ffd27424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000100117811ULL, 0x000fe400078ff0ffULL,
0x0000000b1000720bULL, 0x000fe40003f14000ULL, 0x000000001100720cULL, 0x000fe20003f65270ULL,
0x000111027f007947ULL, 0x000ff4000b800000ULL, 0x0000000000117806ULL, 0x000fe400000e0100ULL,
0x000000100b157209ULL, 0x000fe20007810000ULL, 0x000000800019b824ULL, 0x000fe200078e0227ULL,
0x0000ffff11147812ULL, 0x000fe400078e3cffULL, 0x00000002ff347819ULL, 0x000fe20000011602ULL,
0x000000012816b824ULL, 0x000fe200078e0219ULL, 0x0000001413ff7212ULL, 0x000fe2000780c0ffULL,
0x800000150b0b7221ULL, 0x000fc60000010000ULL, 0x00f400151600b388ULL, 0x0007e20000000800ULL,
0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL, 0x0000000b00337308ULL, 0x000f240000000800ULL,
0x000000330d0d7220ULL, 0x010fe20000410000ULL, 0x000110927f007947ULL, 0x000fea000b800000ULL,
0x00001f34330b7589ULL, 0x00872400000e0000ULL, 0x0000000b54547220ULL, 0x090fe40000410000ULL,
0x0000000b55557220ULL, 0x080fe40000410000ULL, 0x0000000b50507220ULL, 0x080fe40000410000ULL,
0x0000000b51517220ULL, 0x080fe40000410000ULL, 0x0000000b4c4c7220ULL, 0x000fc40000410000ULL,
0x0000000b4d4d7220ULL, 0x080fe40000410000ULL, 0x0000000b48487220ULL, 0x080fe40000410000ULL,
0x0000000b49497220ULL, 0x080fe40000410000ULL, 0x0000000b44447220ULL, 0x080fe40000410000ULL,
0x0000000b45457220ULL, 0x080fe40000410000ULL, 0x0000000b40407220ULL, 0x000fc40000410000ULL,
0x0000000b41417220ULL, 0x080fe40000410000ULL, 0x0000000b3c3c7220ULL, 0x080fe40000410000ULL,
0x0000000b3d3d7220ULL, 0x080fe40000410000ULL, 0x0000000b38387220ULL, 0x080fe40000410000ULL,
0x0000000b39397220ULL, 0x000fe20000410000ULL, 0x00010fd27f007947ULL, 0x000fea000b800000ULL,
0x00001f2a330b7589ULL, 0x0008a400000e0000ULL, 0x8000001510100221ULL, 0x000fe20000010000ULL,
0x00000001ffd27807ULL, 0x000fe20000000000ULL, 0x0000000b56567220ULL, 0x004fc40000410000ULL,
0x3fb8aa3b10100820ULL, 0x000fe40000410000ULL, 0x0000000b57577220ULL, 0x080fe40000410000ULL,
0x0000001000290308ULL, 0x000ea20000000800ULL, 0x0000000b52527220ULL, 0x080fe40000410000ULL,
0x0000000b53537220ULL, 0x080fe40000410000ULL, 0x0000000b4e4e7220ULL, 0x080fe40000410000ULL,
0x0000000b4f4f7220ULL, 0x000fc40000410000ULL, 0x0000000b4a4a7220ULL, 0x080fe40000410000ULL,
0x0000000b4b4b7220ULL, 0x080fe40000410000ULL, 0x0000000b46467220ULL, 0x080fe40000410000ULL,
0x0000000b47477220ULL, 0x080fe40000410000ULL, 0x0000000b42427220ULL, 0x080fe40000410000ULL,
0x0000000b43437220ULL, 0x000fc40000410000ULL, 0x0000000b3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000b3f3f7220ULL, 0x080fe40000410000ULL, 0x0000000b3a3a7220ULL, 0x080fe40000410000ULL,
0x0000000b3b3b7220ULL, 0x000fe40000410000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0015ULL,
0x0000001229120220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000000d120d7221ULL, 0x002fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x000000081e107824ULL, 0x000fe200078e00ffULL,
0xfffffff008117812ULL, 0x000fc800078ec0ffULL, 0x0000000810107812ULL, 0x000fca00078e0cffULL,
0x0000000110127824ULL, 0x000fca00078e0211ULL, 0x00f6ac0012117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x000364000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x020fe40003800000ULL, 0x00f6ac0012117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff347819ULL, 0x008fe40000011602ULL, 0x00000029ff10723eULL, 0x000fe400000010ffULL,
0x00000018340e7810ULL, 0x040fe40007ffe0ffULL, 0x00000010340f7810ULL, 0x000fe40007ffe0ffULL,
0x0000541010337816ULL, 0x010fe20000000010ULL, 0x00010d227f007947ULL, 0x000fea000b800000ULL,
0x00001f3433b97589ULL, 0x0002e400000e0000ULL, 0x00010d627f007947ULL, 0x000fea000b800000ULL,
0x00001f2a33bc7589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff347224ULL, 0x002fe200078e000fULL, 0x00004c7000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0001193000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff347224ULL, 0x002fe200078e000eULL, 0x00004cd000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x000118d000007944ULL, 0x01cfea0003c00000ULL, 0x000010001e117824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00001000000e7824ULL, 0x000fe200078e00ffULL,
0x00009910d2d27816ULL, 0x000fe400000000ffULL, 0x0000100011117812ULL, 0x000fe400078e0cffULL,
0xffffe0000e0e7812ULL, 0x000fc400078ec0ffULL, 0x0000b0000a187810ULL, 0x100fe40007ffe011ULL,
0x0000b0000e0f7810ULL, 0x000fc60007ffe011ULL, 0x000000102d107824ULL, 0x000fe400078e0218ULL,
0x000000102c0e7824ULL, 0x100fe400078e020fULL, 0x000000102e0f7824ULL, 0x000fe200078e020fULL,
0x000000001060783bULL, 0x000f680000004200ULL, 0x000000000e30783bULL, 0x016e680000004200ULL,
0x000000000f34783bULL, 0x000ea20000004200ULL, 0x0000006000bb7306ULL, 0x020fe20000009400ULL,
0x00000018ff117819ULL, 0x002fe20000011430ULL, 0x0000010030767824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fca0000011432ULL, 0x0000001100907306ULL, 0x000fe20000209400ULL,
0x00000018ff167819ULL, 0x004fe40000011434ULL, 0x00000018ff137819ULL, 0x000fe40000011431ULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x00000018ff157819ULL, 0x000fe20000011433ULL,
0x0000001100f17306ULL, 0x000e700000205400ULL, 0x0000001100927306ULL, 0x000530000020d400ULL,
0x0000003000f77306ULL, 0x000fe20000009400ULL, 0x000000102f117824ULL, 0x004fe200078e0218ULL,
0x000000f19000720bULL, 0x002fc80003fbd000ULL, 0x00000000115c783bULL, 0x000e640000004200ULL,
0x0000003000f67306ULL, 0x000eae0000005400ULL, 0x0000000192925812ULL, 0x010fe200078efcffULL,
0x0000003000b67306ULL, 0x000970000000d400ULL, 0x00000016008b7306ULL, 0x000fe20000209400ULL,
0x0001000030307824ULL, 0x010fe200078e00ffULL, 0x000000f6f700720bULL, 0x004fc80003f5d000ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000001600d47306ULL, 0x000fee0000205400ULL,
0x00000001b6b62812ULL, 0x020fe200078efcffULL, 0x00000016008c7306ULL, 0x0005e2000020d400ULL,
0x00000018ff777819ULL, 0x002fce000001145dULL, 0x0000001400997306ULL, 0x000fe20000209400ULL,
0x00000018ff167819ULL, 0x004fe40000011461ULL, 0x00000018ff787819ULL, 0x000fe4000001145eULL,
0x00000018ff6e7819ULL, 0x000fe4000001145cULL, 0x00000018ff797819ULL, 0x000fe2000001145fULL,
0x0000001600a87306ULL, 0x000ff00000209400ULL, 0x0000001600ab7306ULL, 0x000ff00000205400ULL,
0x0000001600187306ULL, 0x000ff0000020d400ULL, 0x0000001400e07306ULL, 0x000ff00000205400ULL,
0x0000001400a07306ULL, 0x0003f0000020d400ULL, 0x00000077001c7306ULL, 0x000fe20000209400ULL,
0x00000018ff147819ULL, 0x002fce0000011436ULL, 0x00000077006d7306ULL, 0x000ff00000205400ULL,
0x0000007700167306ULL, 0x0003f0000020d400ULL, 0x0000003100f47306ULL, 0x000fe20000009400ULL,
0x0000010031777824ULL, 0x002fca00078e00ffULL, 0x00000018ff777819ULL, 0x000fe40000011477ULL,
0x0000003100ad7306ULL, 0x000e700000005400ULL, 0x0000003100b47306ULL, 0x000530000000d400ULL,
0x0000001300827306ULL, 0x000fe20000209400ULL, 0x0001000031317824ULL, 0x004fe200078e00ffULL,
0x000000adf400720bULL, 0x002fcc0003fdd000ULL, 0x0000001300897306ULL, 0x000e6e0000205400ULL,
0x00000001b4b46812ULL, 0x010fe200078efcffULL, 0x0000003000f57306ULL, 0x000ff00000209400ULL,
0x0000003000aa7306ULL, 0x000ea20000205400ULL, 0x000000898200720bULL, 0x002fce0003f5d000ULL,
0x0000001400c07306ULL, 0x000ff00000209400ULL, 0x0000001400bf7306ULL, 0x000fe20000205400ULL,
0x000000aaf500720bULL, 0x004fce0003f9d000ULL, 0x0000001400747306ULL, 0x0003f0000020d400ULL,
0x0000007600b57306ULL, 0x000fe20000209400ULL, 0x00000018ff147819ULL, 0x002fce0000011462ULL,
0x0000007600b27306ULL, 0x000e700000205400ULL, 0x0000007600c77306ULL, 0x000530000020d400ULL,
0x00000014008d7306ULL, 0x000fe20000209400ULL, 0x00000018ff767819ULL, 0x004fe20000011431ULL,
0x0000010032317824ULL, 0x000fe200078e00ffULL, 0x000000b2b500720bULL, 0x002fca0003f1d000ULL,
0x00000014008e7306ULL, 0x000ff00000205400ULL, 0x00000014006f7306ULL, 0x000fe2000020d400ULL,
0x00000001c7c70812ULL, 0x010fce00078efcffULL, 0x00000078001b7306ULL, 0x000ff00000209400ULL,
0x0000007800147306ULL, 0x000ff00000205400ULL, 0x00000078006b7306ULL, 0x0003f0000020d400ULL,
0x0000001300937306ULL, 0x000522000020d400ULL, 0x00000018ff787819ULL, 0x002fce0000011431ULL,
0x0000003000b77306ULL, 0x000362000020d400ULL, 0x00000018ff137819ULL, 0x004fce0000011435ULL,
0x0000007600ef7306ULL, 0x000fe20000209400ULL, 0x0000010033307824ULL, 0x002fe200078e00ffULL,
0x0000000193932812ULL, 0x010fe400078efcffULL, 0x000000e09900720bULL, 0x000fc80003f5d000ULL,
0x0000007600f07306ULL, 0x000e620000205400ULL, 0x00000001b7b74812ULL, 0x020fc800078efcffULL,
0x000000b79292723eULL, 0x000fc600000010ffULL, 0x0000007800ed7306ULL, 0x000fe20000209400ULL,
0x00000001a0a02812ULL, 0x000fce00078efcffULL, 0x0000007800ee7306ULL, 0x000ea20000205400ULL,
0x000000f0ef00720bULL, 0x002fce0003f9d000ULL, 0x0000003200977306ULL, 0x000ff00000009400ULL,
0x0000003200887306ULL, 0x000e620000005400ULL, 0x000000eeed00720bULL, 0x004fce0003fbd000ULL,
0x0000003200a67306ULL, 0x000530000000d400ULL, 0x0000001500e17306ULL, 0x000fe20000209400ULL,
0x0001000032327824ULL, 0x004fe200078e00ffULL, 0x000000889700720bULL, 0x002fcc0003f1d000ULL,
0x0000001500e27306ULL, 0x000fee0000205400ULL, 0x00000001a6a60812ULL, 0x010fe200078efcffULL,
0x00000015009c7306ULL, 0x0003f0000020d400ULL, 0x0000003300837306ULL, 0x000fe20000009400ULL,
0x00000018ff157819ULL, 0x002fce0000011437ULL, 0x0000003300947306ULL, 0x000ff00000005400ULL,
0x0000003300a27306ULL, 0x0003f0000000d400ULL, 0x0000007600ac7306ULL, 0x000522000020d400ULL,
0x0001000033337824ULL, 0x002fce00078e00ffULL, 0x0000001300d67306ULL, 0x000fe20000209400ULL,
0x00000018ff767819ULL, 0x004fe20000011432ULL, 0x0000010034327824ULL, 0x000fcc00078e00ffULL,
0x0000001300d77306ULL, 0x000fe20000205400ULL, 0x00000001acac4812ULL, 0x010fc800078efcffULL,
0x000000ac9393723eULL, 0x000fc600000010ffULL, 0x0000001300847306ULL, 0x0003f0000020d400ULL,
0x0000001500c17306ULL, 0x000fe20000209400ULL, 0x00000018ff137819ULL, 0x002fce0000011460ULL,
0x0000001500ba7306ULL, 0x000ff00000205400ULL, 0x0000001500727306ULL, 0x0003f0000020d400ULL,
0x0000007800af7306ULL, 0x000522000020d400ULL, 0x00000018ff157819ULL, 0x002fce0000011463ULL,
0x0000003500df7306ULL, 0x000fe20000009400ULL, 0x00000018ff787819ULL, 0x004fce0000011433ULL,
0x0000003500dc7306ULL, 0x000e620000005400ULL, 0x00000001afaf5812ULL, 0x010fe400078efcffULL,
0x000000e2e100720bULL, 0x000fca0003fbd000ULL, 0x0000007600e97306ULL, 0x000ff00000209400ULL,
0x0000007600ea7306ULL, 0x000ea20000205400ULL, 0x000000dcdf00720bULL, 0x002fe40003f5d000ULL,
0x000000019c9c5812ULL, 0x000fca00078efcffULL, 0x0000001300b37306ULL, 0x000ff00000209400ULL,
0x0000001300b07306ULL, 0x000fe20000205400ULL, 0x000000eae900720bULL, 0x004fce0003f9d000ULL,
0x0000001300717306ULL, 0x000ff0000020d400ULL, 0x00000015007c7306ULL, 0x000ff00000209400ULL,
0x00000015007f7306ULL, 0x000ff00000205400ULL, 0x00000015001a7306ULL, 0x000ff0000020d400ULL,
0x0000006e00137306ULL, 0x000ff00000209400ULL, 0x0000006e00707306ULL, 0x000ff00000205400ULL,
0x0000006e006c7306ULL, 0x000ff0000020d400ULL, 0x0000003400de7306ULL, 0x000ff00000009400ULL,
0x0000003400857306ULL, 0x000ff00000005400ULL, 0x0000003400987306ULL, 0x0003f0000000d400ULL,
0x0000007900197306ULL, 0x000fe20000209400ULL, 0x0001000034347824ULL, 0x002fce00078e00ffULL,
0x00000079006e7306ULL, 0x000ff00000205400ULL, 0x0000007900157306ULL, 0x0003f0000020d400ULL,
0x0000007700f27306ULL, 0x000fe20000209400ULL, 0x0000010035797824ULL, 0x002fca00078e00ffULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000007700f37306ULL, 0x000e700000205400ULL,
0x0000007700c57306ULL, 0x000530000020d400ULL, 0x0000007800eb7306ULL, 0x000fe20000209400ULL,
0x00000018ff777819ULL, 0x004fc40000011430ULL, 0x000000f3f200720bULL, 0x002fca0003f7d000ULL,
0x0000007800ec7306ULL, 0x000e700000205400ULL, 0x0000007800a17306ULL, 0x000562000020d400ULL,
0x00000001c5c53812ULL, 0x010fe400078efcffULL, 0x000000948300720bULL, 0x000fca0003f7d000ULL,
0x00000035008f7306ULL, 0x0008e2000000d400ULL, 0x0000010036787824ULL, 0x004fe200078e00ffULL,
0x000000eceb00720bULL, 0x002fc80003f1d000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007700307306ULL, 0x000fe20000209400ULL, 0x0001000035357824ULL, 0x010fe200078e00ffULL,
0x00000001a2a23812ULL, 0x000fca00078efcffULL, 0x00000001a1a10812ULL, 0x020fe200078efcffULL,
0x0000007700317306ULL, 0x000e620000205400ULL, 0x000000018f8f2812ULL, 0x008fce00078efcffULL,
0x0000007700a57306ULL, 0x0005f0000020d400ULL, 0x0000007600a77306ULL, 0x000722000020d400ULL,
0x00000018ff777819ULL, 0x004fe40000011432ULL, 0x000000313000720bULL, 0x002fe20003fdd000ULL,
0x000001005d307824ULL, 0x000fc800078e00ffULL, 0x0000007700327306ULL, 0x000fe20000209400ULL,
0x00000018ff767819ULL, 0x008fe40000011434ULL, 0x00000018ffdc7819ULL, 0x000fca0000011430ULL,
0x0000007700337306ULL, 0x000e620000205400ULL, 0x00000001a7a74812ULL, 0x010fe400078efcffULL,
0x00000001a5a56812ULL, 0x000fe400078efcffULL, 0x00000085de00720bULL, 0x000fc60003fdd000ULL,
0x00000077009f7306ULL, 0x0004f0000020d400ULL, 0x0000007900e37306ULL, 0x000fe20000209400ULL,
0x00000018ff777819ULL, 0x004fe40000011435ULL, 0x000000333200720bULL, 0x002fc40003f7d000ULL,
0x0000000198986812ULL, 0x000fe200078efcffULL, 0x009800005830783bULL, 0x000e620000000200ULL,
0x000000d7d600720bULL, 0x000fe20003fdd000ULL, 0x0000007900e47306ULL, 0x000eb00000205400ULL,
0x0000007600347306ULL, 0x000fe20000209400ULL, 0x000000019f9f3812ULL, 0x008fc400078efcffULL,
0x000000d48b00720bULL, 0x000fe40003f7d000ULL, 0x0000000184846812ULL, 0x000fe400078efcffULL,
0x000000bfc000720bULL, 0x000fe20003fdd000ULL, 0x0000007600e57306ULL, 0x000ee20000205400ULL,
0x000000e4e300720bULL, 0x004fe20003f9d000ULL, 0x000100005ebf7824ULL, 0x000fe400078e00ffULL,
0x000100005dc07824ULL, 0x000fc600078e00ffULL, 0x00000018ffbf7819ULL, 0x000fe200000114bfULL,
0x0000007800e77306ULL, 0x000fe20000209400ULL, 0x000000018c8c3812ULL, 0x000fe400078efcffULL,
0x00000018ffc07819ULL, 0x000fe400000114c0ULL, 0x0000000174746812ULL, 0x000fc600078efcffULL,
0x0000007800e87306ULL, 0x000ea20000205400ULL, 0x000000e53400720bULL, 0x008fce0003fbd000ULL,
0x0000003600dd7306ULL, 0x000ff00000009400ULL, 0x00000036008a7306ULL, 0x000ee20000005400ULL,
0x000000e8e700720bULL, 0x004fce0003f5d000ULL, 0x00000036007a7306ULL, 0x0005f0000000d400ULL,
0x0000007900967306ULL, 0x000962000020d400ULL, 0x0001000036367824ULL, 0x004fe200078e00ffULL,
0x0000008add00720bULL, 0x008fc80003f1d000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000007700357306ULL, 0x000fe20000209400ULL, 0x0000010037797824ULL, 0x010fca00078e00ffULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000007700e67306ULL, 0x000ea20000205400ULL,
0x0000000196964812ULL, 0x020fe400078efcffULL, 0x000000017a7a0812ULL, 0x000fe400078efcffULL,
0x000000bac100720bULL, 0x000fe20003f1d000ULL, 0x000001005ec17824ULL, 0x000fe400078e00ffULL,
0x0000007700957306ULL, 0x0007e2000020d400ULL, 0x000100005fba7824ULL, 0x000fc400078e00ffULL,
0x00000018ffc17819ULL, 0x000fc600000114c1ULL, 0x00000018ffba7819ULL, 0x000fe400000114baULL,
0x00000076009b7306ULL, 0x000962000020d400ULL, 0x0000010061777824ULL, 0x008fe200078e00ffULL,
0x000000e63500720bULL, 0x004fe40003f9d000ULL, 0x0000000172720812ULL, 0x000fc800078efcffULL,
0x0000006000b87306ULL, 0x000fe20000005400ULL, 0x0000010060767824ULL, 0x010fca00078e00ffULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x0000006000737306ULL, 0x0005e2000000d400ULL,
0x000000019b9b5812ULL, 0x020fe400078efcffULL, 0x0000000195954812ULL, 0x000fe400078efcffULL,
0x0000009b8c8c723eULL, 0x000fc600000010ffULL, 0x0000007800917306ULL, 0x000722000020d400ULL,
0x0001000060607824ULL, 0x004fce00078e00ffULL, 0x0000003700be7306ULL, 0x000fe20000009400ULL,
0x00000018ff787819ULL, 0x008fce0000011477ULL, 0x0000003700c37306ULL, 0x000ea20000005400ULL,
0x0000000191912812ULL, 0x010fce00078efcffULL, 0x0000003700757306ULL, 0x000730000000d400ULL,
0x0000003600c87306ULL, 0x000fe20000209400ULL, 0x0001000037377824ULL, 0x008fe200078e00ffULL,
0x000000c3be00720bULL, 0x004fe20003f9d000ULL, 0x000001005fc37824ULL, 0x000fc600078e00ffULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000003600cd7306ULL, 0x000ea20000205400ULL,
0x00000018ffc37819ULL, 0x000fcc00000114c3ULL, 0x0000000175754812ULL, 0x010fe200078efcffULL,
0x0000003600877306ULL, 0x000722000020d400ULL, 0x000000b8bb00720bULL, 0x000fce0003f9d000ULL,
0x0000007900c67306ULL, 0x000fe20000209400ULL, 0x00000018ff367819ULL, 0x008fe40000011460ULL,
0x000000cdc800720bULL, 0x004fc60003f5d000ULL, 0x0000000173734812ULL, 0x000fe400078efcffULL,
0x0000007900cb7306ULL, 0x000eb00000205400ULL, 0x0000007800d07306ULL, 0x000fe20000209400ULL,
0x0000000187872812ULL, 0x010fc800078efcffULL, 0x000000877474723eULL, 0x000fc600000010ffULL,
0x0000007800d57306ULL, 0x000ee20000205400ULL, 0x000000cbc600720bULL, 0x004fe20003fbd000ULL,
0x000000ffffcb7224ULL, 0x000fe400078e00d2ULL, 0x000100005cc67824ULL, 0x000fc600078e00ffULL,
0x000000ffcb00720cULL, 0x000fe20003f65270ULL, 0x0000007800777306ULL, 0x000522000020d400ULL,
0x00000018ffc67819ULL, 0x000fce00000114c6ULL, 0x0000006100c27306ULL, 0x000fe20000009400ULL,
0x0000010063787824ULL, 0x004fe200078e00ffULL, 0x000000d5d000720bULL, 0x008fe40003f1d000ULL,
0x000000b93030b231ULL, 0x082fe400003400ffULL, 0x00000018ff807819ULL, 0x000fe20000011478ULL,
0x000000b93232b231ULL, 0x000fe200003400ffULL, 0x0000006100bd7306ULL, 0x000e620000005400ULL,
0x000000bc3131b231ULL, 0x080fe400003400ffULL, 0x000000bc3333b231ULL, 0x000fc800003400ffULL,
0x0000000177770812ULL, 0x010fe200078efcffULL, 0x0000006100127306ULL, 0x0004f0000000d400ULL,
0x0000003600ca7306ULL, 0x000fe20000209400ULL, 0x0001000061617824ULL, 0x004fe200078e00ffULL,
0x000000bdc200720bULL, 0x002fcc0003f5d000ULL, 0x0000003600cf7306ULL, 0x000e6e0000205400ULL,
0x0000000112122812ULL, 0x008fe200078efcffULL, 0x0000003600607306ULL, 0x0004e2000020d400ULL,
0x000000aba800720bULL, 0x000fce0003f5d000ULL, 0x0000003700cc7306ULL, 0x000fe20000209400ULL,
0x0001000062367824ULL, 0x004fe200078e00ffULL, 0x000000cfca00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000003700d17306ULL, 0x000fe20000205400ULL,
0x0000000118182812ULL, 0x000fcc00078efcffULL, 0x0000000160604812ULL, 0x008fe200078efcffULL,
0x00000037007d7306ULL, 0x0003f0000020d400ULL, 0x0000008000a47306ULL, 0x000fe20000209400ULL,
0x00000018ff377819ULL, 0x002fce0000011461ULL, 0x0000008000a97306ULL, 0x000e700000205400ULL,
0x0000008000787306ULL, 0x000eb0000020d400ULL, 0x0000007900867306ULL, 0x000ee2000020d400ULL,
0x000000a9a400720bULL, 0x002fce0003f5d000ULL, 0x0000003700c47306ULL, 0x000fec0000209400ULL,
0x0000000178782812ULL, 0x004fe400078efcffULL, 0x0000003700c97306ULL, 0x000e620000205400ULL,
0x0000000186865812ULL, 0x008fe400078efcffULL, 0x000000d1cc00720bULL, 0x000fc40003fbd000ULL,
0x0000007f7c00720bULL, 0x000fe40003f5d000ULL, 0x00000012777f723eULL, 0x000fe200000010ffULL,
0x0000003700617306ULL, 0x0004f0000020d400ULL, 0x00000036009e7306ULL, 0x000fe20000209400ULL,
0x0001000063377824ULL, 0x004fe200078e00ffULL, 0x000000017d7d5812ULL, 0x000fc400078efcffULL,
0x000000c9c400720bULL, 0x002fe40003f1d000ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000003600a37306ULL, 0x000fe20000205400ULL, 0x000000011a1a2812ULL, 0x000fce00078efcffULL,
0x0000003600807306ULL, 0x0003e2000020d400ULL, 0x0000000161610812ULL, 0x008fc800078efcffULL,
0x000000611861723eULL, 0x000fc600000010ffULL, 0x00000037009a7306ULL, 0x000fe20000209400ULL,
0x000001005c367824ULL, 0x002fca00078e00ffULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x00000037009d7306ULL, 0x000ff00000205400ULL, 0x0000003700817306ULL, 0x000ff0000020d400ULL,
0x0000003600947306ULL, 0x000ff00000209400ULL, 0x0000003600997306ULL, 0x000ff00000205400ULL,
0x0000003600857306ULL, 0x0003f0000020d400ULL, 0x0000007600ce7306ULL, 0x000fe20000209400ULL,
0x009800002b34783bULL, 0x002e6e0000000200ULL, 0x0000007600d37306ULL, 0x000eb00000205400ULL,
0x0000006200d87306ULL, 0x000ff00000009400ULL, 0x0000006200d97306ULL, 0x000ee20000005400ULL,
0x000000d3ce00720bULL, 0x004fce0003fbd000ULL, 0x00000076007e7306ULL, 0x000530000020d400ULL,
0x0000006200797306ULL, 0x000f62000000d400ULL, 0x0000010062767824ULL, 0x004fe200078e00ffULL,
0x000000d9d800720bULL, 0x008fe20003fdd000ULL, 0x000000b93434b231ULL, 0x002fc400003400ffULL,
0x000000b93636b231ULL, 0x000fe200003400ffULL, 0x00000018ff7b7819ULL, 0x000fe20000011476ULL,
0x000000bc3535b231ULL, 0x080fe200003400ffULL, 0x0000005c00b27306ULL, 0x000fe20000009400ULL,
0x000000017e7e5812ULL, 0x010fe200078efcffULL, 0x000000bc3737b231ULL, 0x000fe200003400ffULL,
0x000000b0b300720bULL, 0x000fe40003fbd000ULL, 0x000000737e7e723eULL, 0x000fc600000010ffULL,
0x0000007b00ae7306ULL, 0x000fe20000209400ULL, 0x0000000179796812ULL, 0x020fe200078efcffULL,
0x000000923450723cULL, 0x000fe20000041850ULL, 0x0000008e8d00720bULL, 0x000fe40003fdd000ULL,
0x00000095848d723eULL, 0x000fc600000010ffULL, 0x0000007b00b17306ULL, 0x000e620000205400ULL,
0x0000000171715812ULL, 0x000fe400078efcffULL, 0x000000a7a092723eULL, 0x000fe200000010ffULL,
0x0000008c3440723cULL, 0x040fe20000041840ULL, 0x000000a19c93723eULL, 0x000fe400000010ffULL,
0x000000607160723eULL, 0x000fe200000010ffULL, 0x0000005c00b57306ULL, 0x000ea20000005400ULL,
0x000000016f6f6812ULL, 0x000fe400078efcffULL, 0x000000999400720bULL, 0x000fe20003fdd000ULL,
0x000000923448723cULL, 0x000fe80000041848ULL, 0x0000005e00907306ULL, 0x000fe20000009400ULL,
0x000000b1ae00720bULL, 0x002fc60003fbd000ULL, 0x000000603050723cULL, 0x000fe80000041850ULL,
0x0000005e00977306ULL, 0x000fe20000005400ULL, 0x000000b5b200720bULL, 0x004fe40003f9d000ULL,
0x0000000185856812ULL, 0x000fe400078efcffULL, 0x000000701300720bULL, 0x000fc60003fdd000ULL,
0x0000005e00827306ULL, 0x0003f0000000d400ULL, 0x0000005f00887306ULL, 0x000fe20000009400ULL,
0x000000b6c75e723eULL, 0x002fe400000010ffULL, 0x000000016c6c6812ULL, 0x000fc400078efcffULL,
0x000000141b00720bULL, 0x000fc60003fdd000ULL, 0x0000005f00897306ULL, 0x000ff00000005400ULL,
0x0000005f00837306ULL, 0x0003e4000000d400ULL, 0x000000016b6b6812ULL, 0x000fcc00078efcffULL,
0x0000007b00767306ULL, 0x000ea2000020d400ULL, 0x000000b4c55f723eULL, 0x002fce00000010ffULL,
0x0000006300da7306ULL, 0x000fe20000009400ULL, 0x0000005e3454723cULL, 0x000fee0000041854ULL,
0x0000006300db7306ULL, 0x000e620000005400ULL, 0x000000a6af5e723eULL, 0x000fe400000010ffULL,
0x000000a2a55f723eULL, 0x000fc400000010ffULL, 0x0000000176765812ULL, 0x004fe400078efcffULL,
0x000000a39e00720bULL, 0x000fe20003fbd000ULL, 0x00000063007b7306ULL, 0x000fe2000000d400ULL,
0x000000797676723eULL, 0x000fe200000010ffULL, 0x0000005e344c723cULL, 0x000fec000004184cULL,
0x0000005c00627306ULL, 0x000ea2000000d400ULL, 0x000000989f5e723eULL, 0x000fe200000010ffULL,
0x0000007e3054723cULL, 0x000fe20000041854ULL, 0x0000008f965f723eULL, 0x000fc400000010ffULL,
0x000000dbda00720bULL, 0x002fe40003f7d000ULL, 0x0000000180805812ULL, 0x000fe200078efcffULL,
0x0000005d00aa7306ULL, 0x000fe20000009400ULL, 0x000000979000720bULL, 0x000fe20003fbd000ULL,
0x0000005e3444723cULL, 0x000fe20000041844ULL, 0x000000806f80723eULL, 0x000fca00000010ffULL,
0x0000005d00ad7306ULL, 0x000e620000005400ULL, 0x0000000162624812ULL, 0x004fe400078efcffULL,
0x00000075865f723eULL, 0x000fe400000010ffULL, 0x0000007a915e723eULL, 0x000fe400000010ffULL,
0x0000007d7275723eULL, 0x000fe200000010ffULL, 0x0000005d00637306ULL, 0x000ea2000000d400ULL,
0x000000017b7b3812ULL, 0x000fe400078efcffULL, 0x0000009d9a00720bULL, 0x000fe20003f7d000ULL,
0x0000005e343c723cULL, 0x000fe2000004183cULL, 0x0000000182825812ULL, 0x000fc400078efcffULL,
0x0000007b7877723eULL, 0x000fe200000010ffULL, 0x000000dc008a7306ULL, 0x000fe20000209400ULL,
0x000000adaa00720bULL, 0x002fe40003f1d000ULL, 0x000000628562723eULL, 0x000fe200000010ffULL,
0x000000743438723cULL, 0x000fe80000041838ULL, 0x000000dc008b7306ULL, 0x000e620000205400ULL,
0x0000000181813812ULL, 0x000fc400078efcffULL, 0x000000898800720bULL, 0x000fe20003f7d000ULL,
0x00000076304c723cULL, 0x000fe2000004184cULL, 0x000000811a81723eULL, 0x000fe400000010ffULL,
0x0000000163630812ULL, 0x004fe200078efcffULL, 0x000000c600be7306ULL, 0x000fe20000209400ULL,
0x0000006d1c00720bULL, 0x000fc60003f1d000ULL, 0x000000803048723cULL, 0x000fe80000041848ULL,
0x000000c6005d7306ULL, 0x000ea20000205400ULL, 0x0000008b8a00720bULL, 0x002fe40003f5d000ULL,
0x0000000183833812ULL, 0x000fc600078efcffULL, 0x0000000116160812ULL, 0x000fe400078efcffULL,
0x000000dc005c7306ULL, 0x000e70000020d400ULL, 0x000000c600bb7306ULL, 0x000ee2000020d400ULL,
0x0000005dbe00720bULL, 0x004fce0003f9d000ULL, 0x000000c000b87306ULL, 0x000fe20000209400ULL,
0x000000015c5c2812ULL, 0x002fc800078efcffULL, 0x000000635c63723eULL, 0x000fc600000010ffULL,
0x000000c000b97306ULL, 0x000e620000205400ULL, 0x00000001bbbb4812ULL, 0x008fc600078efcffULL,
0x000000623044723cULL, 0x000fe20000041844ULL, 0x000000bb6c6c723eULL, 0x000fc600000010ffULL,
0x000000c100ac7306ULL, 0x000ff00000209400ULL, 0x000000c100a57306ULL, 0x000ea20000205400ULL,
0x000000b9b800720bULL, 0x002fce0003f5d000ULL, 0x000000c000b37306ULL, 0x000e70000020d400ULL,
0x000000c100a17306ULL, 0x000ee2000020d400ULL, 0x000000a5ac00720bULL, 0x004fce0003f9d000ULL,
0x000000c3008f7306ULL, 0x000fe20000209400ULL, 0x00000001b3b32812ULL, 0x002fe400078efcffULL,
0x0000006e1900720bULL, 0x000fe40003f5d000ULL, 0x000000b3166d723eULL, 0x000fc600000010ffULL,
0x000000c3007c7306ULL, 0x000e620000205400ULL, 0x00000001a1a14812ULL, 0x008fc600078efcffULL,
0x0000006c3040723cULL, 0x000fe20000041840ULL, 0x00000082a182723eULL, 0x000fc600000010ffULL,
0x000000bf005e7306ULL, 0x000fe20000209400ULL, 0x0000000115152812ULL, 0x000fce00078efcffULL,
0x000000bf00137306ULL, 0x000ea20000205400ULL, 0x0000007c8f00720bULL, 0x002fce0003f1d000ULL,
0x000000ba00187306ULL, 0x000ff00000209400ULL, 0x000000ba00357306ULL, 0x000e620000205400ULL,
0x000000135e00720bULL, 0x004fce0003f9d000ULL, 0x000000c3007a7306ULL, 0x000eb0000020d400ULL,
0x000000bf00127306ULL, 0x000ee2000020d400ULL, 0x000000351800720bULL, 0x002fce0003fbd000ULL,
0x000000ba00ba7306ULL, 0x000e62000020d400ULL, 0x000000017a7a0812ULL, 0x004fc800078efcffULL,
0x000000837a83723eULL, 0x000fe400000010ffULL, 0x0000000112124812ULL, 0x008fc800078efcffULL,
0x000000126b12723eULL, 0x000fe200000010ffULL, 0x00000082303c723cULL, 0x000fe2000004183cULL,
0x00000001baba5812ULL, 0x002fc800078efcffULL, 0x000000ba1513723eULL, 0x000fce00000010ffULL,
0x000000123038723cULL, 0x000fe20000041838ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200017127f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008020127810ULL, 0x004fe20007ffe0ffULL,
0x00f6900059ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff157224ULL, 0x000fe200078e0013ULL,
0x000000011e5d7812ULL, 0x000fe400078ec0ffULL, 0x000000031200720cULL, 0x000fda0003f06070ULL,
0x0000569000000947ULL, 0x000fea0003800000ULL, 0x000004001d127984ULL, 0x004ea40000000800ULL,
0x8000000012ff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240017127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x004fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff097424ULL, 0x000fc800078e00ffULL, 0x0000000900127305ULL, 0x0004e4000021f000ULL,
0x3fa0000009097823ULL, 0x004fe200000100ffULL, 0x000000120000735dULL, 0x008fe40003800000ULL,
0x0000240017127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x004fc40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff097819ULL, 0x000fe20000011600ULL,
0x00000080ff377424ULL, 0x000fe200078e00ffULL, 0x00000003ff197819ULL, 0x000fe20000011602ULL,
0x000000006a0473c2ULL, 0x000ea200000e0000ULL, 0x0000000104187810ULL, 0x000fe20007ffe0ffULL,
0x0000002009127824ULL, 0x000fe200078e0220ULL, 0x0000000419337810ULL, 0x000fe40007ffe0ffULL,
0x000000051800720cULL, 0x000fe40003f06070ULL, 0x000000c012127810ULL, 0x000fc40007ffe0ffULL,
0x0000000819357810ULL, 0x000fe40007ffe0ffULL, 0x0000001203137217ULL, 0x000fe20007800000ULL,
0x0000620006147a24ULL, 0x000fe200078e0212ULL, 0x0000000c19317810ULL, 0x000fc60007ffe0ffULL,
0x0000000113157824ULL, 0x000fe200078e0a12ULL, 0x0000001914167210ULL, 0x140fe40007ffe007ULL,
0x0000003114187210ULL, 0x000fc60007ffe007ULL, 0x00005e0016127625ULL, 0x000fe200078e0037ULL,
0x0000002015167807ULL, 0x000fe40000000000ULL, 0x0000003514157210ULL, 0x100fe40007ffe007ULL,
0x00000027121a7210ULL, 0x000fe40007f1e0ffULL, 0x0000003314127210ULL, 0x000fe20007ffe007ULL,
0x00005e0015147625ULL, 0x000fe200078e0037ULL, 0x0000001607167217ULL, 0x000fc60007800000ULL,
0x000000ffff1b7224ULL, 0x000fe200000e0613ULL, 0x0000002714147210ULL, 0x000fe20007fbe0ffULL,
0x00005e0012127625ULL, 0x000fc800078e0037ULL, 0x0000000116167824ULL, 0x000fe200078e0a07ULL,
0x0000002712127210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff157224ULL, 0x000fc600028e0615ULL,
0x000000161900720cULL, 0x080fe20003f46070ULL, 0x00005e0018187625ULL, 0x000fe200078e0037ULL,
0x000000163300720cULL, 0x080fe40003f06070ULL, 0x000000163100720cULL, 0x080fe20003f86070ULL,
0x000000ffff137224ULL, 0x000fe200018e0613ULL, 0x000000163500720cULL, 0x000fe40003f66070ULL,
0x0000002718187210ULL, 0x000fca0007fde0ffULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a217faeULL, 0x0007e8000d101c46ULL,
0x0000000012227faeULL, 0x0007e8000c101c46ULL, 0x0000000014237faeULL, 0x0007e8000d901c46ULL,
0x0000000018247faeULL, 0x0007e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x004fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000006a127f8cULL, 0x0084e8000c80043fULL,
0x0000040065167984ULL, 0x0005220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480025147f8cULL, 0x000fe2000c80043fULL,
0x8000000016ff7812ULL, 0x010fc6000784481fULL, 0x00f64c0025197984ULL, 0x000f240000000800ULL,
0x8000000019ff7812ULL, 0x010fe40007804815ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff167424ULL, 0x000fc800078e00ffULL, 0x0000001600187305ULL, 0x000964000021f000ULL,
0x3fa0000016167823ULL, 0x010fe200000100ffULL, 0x000000180000735dULL, 0x020fe20003800000ULL,
0x00f64c0025197984ULL, 0x000f240000000800ULL, 0x8000000019ff7812ULL, 0x010fc40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010027157810ULL, 0x000fca0007ffe026ULL,
0x0000000128157824ULL, 0x000fca00078e0215ULL, 0x00f0000015167984ULL, 0x000f280000000800ULL,
0x00f2000015187984ULL, 0x0002a20000000800ULL, 0x0000000b1600720bULL, 0x010fe20003f1d000ULL,
0x0000e7e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x002fc800000e0100ULL,
0x0000ffff141b7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ffc37424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000200157811ULL, 0x000fe400078ff0ffULL, 0x0000000b1600720bULL, 0x000fe40003f14000ULL,
0x000000001500720cULL, 0x000fe20003f65270ULL, 0x0000e7b27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000147806ULL, 0x000fe400000e0100ULL, 0x000000160b157209ULL, 0x000fe20007810000ULL,
0x000000800019b824ULL, 0x000fe200078e0227ULL, 0x0000ffff14147812ULL, 0x000fe400078e3cffULL,
0x00000002ff347819ULL, 0x000fe20000011602ULL, 0x00000001281ab824ULL, 0x000fe200078e0219ULL,
0x000000141bff7212ULL, 0x000fe2000780c0ffULL, 0x800000150b0b7221ULL, 0x000fc60000010000ULL,
0x00f400151a00b388ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL,
0x0000000b00337308ULL, 0x000f240000000800ULL, 0x000000330d0d7220ULL, 0x010fe20000410000ULL,
0x0000e7427f007947ULL, 0x000fea000b800000ULL, 0x00001f34330b7589ULL, 0x00232400000e0000ULL,
0x0000000b54547220ULL, 0x090fe40000410000ULL, 0x0000000b55557220ULL, 0x080fe40000410000ULL,
0x0000000b50507220ULL, 0x080fe40000410000ULL, 0x0000000b51517220ULL, 0x080fe40000410000ULL,
0x0000000b4c4c7220ULL, 0x000fc40000410000ULL, 0x0000000b4d4d7220ULL, 0x080fe40000410000ULL,
0x0000000b48487220ULL, 0x080fe40000410000ULL, 0x0000000b49497220ULL, 0x080fe40000410000ULL,
0x0000000b44447220ULL, 0x080fe40000410000ULL, 0x0000000b45457220ULL, 0x080fe40000410000ULL,
0x0000000b40407220ULL, 0x000fc40000410000ULL, 0x0000000b41417220ULL, 0x080fe40000410000ULL,
0x0000000b3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000b3d3d7220ULL, 0x080fe40000410000ULL,
0x0000000b38387220ULL, 0x080fe40000410000ULL, 0x0000000b39397220ULL, 0x000fe20000410000ULL,
0x0000e6827f007947ULL, 0x000fea000b800000ULL, 0x00001f2a330b7589ULL, 0x00086400000e0000ULL,
0x8000001516160221ULL, 0x000fe20000010000ULL, 0x00000001ffc37807ULL, 0x000fe20000000000ULL,
0x0000000b56567220ULL, 0x002fc40000410000ULL, 0x3fb8aa3b16160820ULL, 0x000fe40000410000ULL,
0x0000000b57577220ULL, 0x080fe40000410000ULL, 0x0000001600290308ULL, 0x000e620000000800ULL,
0x0000000b52527220ULL, 0x080fe40000410000ULL, 0x0000000b53537220ULL, 0x080fe40000410000ULL,
0x0000000b4e4e7220ULL, 0x080fe40000410000ULL, 0x0000000b4f4f7220ULL, 0x000fc40000410000ULL,
0x0000000b4a4a7220ULL, 0x080fe40000410000ULL, 0x0000000b4b4b7220ULL, 0x080fe40000410000ULL,
0x0000000b46467220ULL, 0x080fe40000410000ULL, 0x0000000b47477220ULL, 0x080fe40000410000ULL,
0x0000000b42427220ULL, 0x080fe40000410000ULL, 0x0000000b43437220ULL, 0x000fc40000410000ULL,
0x0000000b3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000b3f3f7220ULL, 0x080fe40000410000ULL,
0x0000000b3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000b3b3b7220ULL, 0x000fe40000410000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0015ULL, 0x0000001829180220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000000d180d7221ULL, 0x004fe20000010000ULL, 0x000000f000002947ULL, 0x000fea0003800000ULL,
0x000000085b157812ULL, 0x000fe400078ec0ffULL, 0xfffffff008147812ULL, 0x000fca00078ec0ffULL,
0x0000000114157824ULL, 0x000fca00078e0215ULL, 0x00f6ac0015147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe4000780481fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff147424ULL, 0x000fc800078e00ffULL,
0x0000001400167305ULL, 0x0002a4000021f000ULL, 0x3fa0000014147823ULL, 0x002fe200000100ffULL,
0x000000160000735dULL, 0x004fe40003800000ULL, 0x00f6ac0015167984ULL, 0x000e640000000800ULL,
0x8000000016ff7812ULL, 0x002fc4000780481fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff347819ULL, 0x000fe40000011602ULL, 0x00000029ff14723eULL, 0x000fe400000010ffULL,
0x0000001834157810ULL, 0x040fe40007ffe0ffULL, 0x0000001034167810ULL, 0x000fe40007ffe0ffULL,
0x0000541014337816ULL, 0x010fe20000000014ULL, 0x0000e3e27f007947ULL, 0x000fea000b800000ULL,
0x00001f3433237589ULL, 0x0002a400000e0000ULL, 0x0000e4227f007947ULL, 0x000fea000b800000ULL,
0x00001f2a33147589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff347224ULL, 0x002fe200078e0016ULL, 0x0000781000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000ed9000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff347224ULL, 0x002fe200078e0015ULL, 0x0000787000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000ed3000007944ULL, 0x01cfea0003c00000ULL, 0x000010005a357812ULL, 0x002fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100000347824ULL, 0x000fe400078e00ffULL,
0x0000b0000a167810ULL, 0x000fc60007ffe035ULL, 0xffffe00034347812ULL, 0x000fe400078ec0ffULL,
0x000000102d187824ULL, 0x100fe400078e0216ULL, 0x000000102f307824ULL, 0x000fc800078e0216ULL,
0x000000001818783bULL, 0x000e680000004200ULL, 0x000000003030783bULL, 0x014ea20000004200ULL,
0x00000018ff157819ULL, 0x002fe20000011418ULL, 0x0000001800ad7306ULL, 0x000fe20000009400ULL,
0x00000018ff2d7819ULL, 0x000fe40000011419ULL, 0x00000018ff2f7819ULL, 0x000fe4000001141aULL,
0x00000018ff5f7819ULL, 0x000fc4000001141bULL, 0x00000018ff717819ULL, 0x004fe20000011432ULL,
0x0000001500ac7306ULL, 0x000fe20000209400ULL, 0x00000018ff607819ULL, 0x000fe40000011430ULL,
0x00000018ff737819ULL, 0x000fca0000011433ULL, 0x0000001500ab7306ULL, 0x000ff00000205400ULL,
0x0000001500247306ULL, 0x0003f0000020d400ULL, 0x0000002d00a77306ULL, 0x000fe20000209400ULL,
0x0000b00034157810ULL, 0x002fca0007ffe035ULL, 0x000000102c347824ULL, 0x100fe400078e0215ULL,
0x000000102e2e7824ULL, 0x000fe200078e0215ULL, 0x0000002d00a27306ULL, 0x000fe20000205400ULL,
0x00000018ff157819ULL, 0x000fe40000011431ULL, 0x000000003434783bULL, 0x000e6a0000004200ULL,
0x0000002d005a7306ULL, 0x000ff0000020d400ULL, 0x0000002f00857306ULL, 0x000ff00000209400ULL,
0x0000002f00867306ULL, 0x000ff00000205400ULL, 0x0000002f005c7306ULL, 0x0005f0000020d400ULL,
0x0000005f00807306ULL, 0x000fe20000209400ULL, 0x000000002e2c783bULL, 0x004ea20000004200ULL,
0x00000018ff747819ULL, 0x002fc40000011436ULL, 0x00000018ff757819ULL, 0x000fc80000011437ULL,
0x0000005f00817306ULL, 0x000ff00000205400ULL, 0x0000005f005e7306ULL, 0x000ff0000020d400ULL,
0x00000071006c7306ULL, 0x000ff00000209400ULL, 0x00000071005f7306ULL, 0x000ff00000205400ULL,
0x00000071006b7306ULL, 0x0003f0000020d400ULL, 0x0000007400d27306ULL, 0x000fe20000209400ULL,
0x00000018ff717819ULL, 0x002fce0000011434ULL, 0x0000007100d87306ULL, 0x000ff00000209400ULL,
0x0000007100d97306ULL, 0x000e700000205400ULL, 0x0000007100b07306ULL, 0x000530000020d400ULL,
0x0000007400d37306ULL, 0x000fe20000205400ULL, 0x00000018ff717819ULL, 0x004fc4000001142cULL,
0x000000d9d800720bULL, 0x002fca0003fbd000ULL, 0x0000007100cf7306ULL, 0x000ff00000209400ULL,
0x0000007100c87306ULL, 0x000fe20000205400ULL, 0x00000001b0b05812ULL, 0x010fce00078efcffULL,
0x0000007100877306ULL, 0x0003f0000020d400ULL, 0x00000074009d7306ULL, 0x0005e2000020d400ULL,
0x0000010018717824ULL, 0x002fca00078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011471ULL,
0x0000010019717824ULL, 0x000fe200078e00ffULL, 0x00000060005d7306ULL, 0x000fe20000209400ULL,
0x00000018ff747819ULL, 0x004fce000001142eULL, 0x0000006000707306ULL, 0x000ff00000205400ULL,
0x00000060006d7306ULL, 0x000ff0000020d400ULL, 0x0000007300627306ULL, 0x000ff00000209400ULL,
0x00000073006f7306ULL, 0x000ff00000205400ULL, 0x0000007300607306ULL, 0x0003f0000020d400ULL,
0x0000001800227306ULL, 0x000fe20000005400ULL, 0x00000018ff737819ULL, 0x002fce0000011435ULL,
0x0000001800727306ULL, 0x0003f0000000d400ULL, 0x0000007400c07306ULL, 0x000fe20000209400ULL,
0x0001000018187824ULL, 0x002fca00078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000007400bb7306ULL, 0x000ff00000205400ULL, 0x00000074007c7306ULL, 0x0003f0000020d400ULL,
0x0000001500637306ULL, 0x000fe20000209400ULL, 0x00000018ff747819ULL, 0x002fce0000011471ULL,
0x00000015006e7306ULL, 0x000ff00000205400ULL, 0x0000001500617306ULL, 0x000ff0000020d400ULL,
0x0000007300977306ULL, 0x000ff00000209400ULL, 0x0000007300d67306ULL, 0x000e700000205400ULL,
0x0000007300157306ULL, 0x000530000020d400ULL, 0x0000001900b47306ULL, 0x000fe20000009400ULL,
0x00000018ff737819ULL, 0x004fc4000001142dULL, 0x000000d69700720bULL, 0x002fe20003f1d000ULL,
0x0001000030d67824ULL, 0x000fc800078e00ffULL, 0x0000001900af7306ULL, 0x000fe20000005400ULL,
0x00000018ffd67819ULL, 0x000fce00000114d6ULL, 0x0000001900167306ULL, 0x0003e2000000d400ULL,
0x0000000115150812ULL, 0x010fe400078efcffULL, 0x000000d3d200720bULL, 0x000fca0003f1d000ULL,
0x0000007400bd7306ULL, 0x000fe20000209400ULL, 0x0001000019197824ULL, 0x002fca00078e00ffULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x0000007400be7306ULL, 0x000fe20000205400ULL,
0x000000019d9d0812ULL, 0x000fce00078efcffULL, 0x0000007400717306ULL, 0x0003f0000020d400ULL,
0x0000007500d07306ULL, 0x000fe20000209400ULL, 0x000001001b747824ULL, 0x002fce00078e00ffULL,
0x0000007500cb7306ULL, 0x000ff00000205400ULL, 0x0000007500967306ULL, 0x0003f0000020d400ULL,
0x0000007300cd7306ULL, 0x000fe20000209400ULL, 0x00000018ff757819ULL, 0x002fce000001142fULL,
0x0000007300ca7306ULL, 0x000ff00000205400ULL, 0x0000007300827306ULL, 0x000ff0000020d400ULL,
0x0000007700bf7306ULL, 0x000ff00000209400ULL, 0x0000007700bc7306ULL, 0x000ff00000205400ULL,
0x0000007700797306ULL, 0x0003f0000020d400ULL, 0x0000001a00b37306ULL, 0x000fe20000009400ULL,
0x000001001a777824ULL, 0x002fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011477ULL,
0x0000001a00ae7306ULL, 0x000ff00000005400ULL, 0x0000001a001c7306ULL, 0x0003f0000000d400ULL,
0x0000001800b77306ULL, 0x000fe20000209400ULL, 0x000100001a1a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x0000001800b67306ULL, 0x000ff00000205400ULL,
0x0000001800737306ULL, 0x0003f0000020d400ULL, 0x0000007500c17306ULL, 0x000fe20000209400ULL,
0x00000018ff187819ULL, 0x002fce0000011474ULL, 0x0000007500c27306ULL, 0x000ff00000205400ULL,
0x0000007500767306ULL, 0x000ff0000020d400ULL, 0x0000001900a67306ULL, 0x000ff00000209400ULL,
0x0000001900a97306ULL, 0x000ff00000205400ULL, 0x0000001900757306ULL, 0x0003f0000020d400ULL,
0x0000001800997306ULL, 0x000fe20000209400ULL, 0x0000010030197824ULL, 0x002fca00078e00ffULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x0000001800987306ULL, 0x000ff00000205400ULL,
0x0000001800747306ULL, 0x0003f0000020d400ULL, 0x0000001a008e7306ULL, 0x000fe20000209400ULL,
0x0000010031187824ULL, 0x002fce00078e00ffULL, 0x0000001a008f7306ULL, 0x000ff00000205400ULL,
0x0000001a007b7306ULL, 0x0003f0000020d400ULL, 0x0000003400db7306ULL, 0x000fe20000009400ULL,
0x00000018ff1a7819ULL, 0x002fe20000011418ULL, 0x0000010034187824ULL, 0x000fca00078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000003400e27306ULL, 0x000e700000005400ULL,
0x0000007800a07306ULL, 0x000ff00000209400ULL, 0x0000007800a17306ULL, 0x000fe20000205400ULL,
0x000000e2db00720bULL, 0x002fce0003f5d000ULL, 0x0000007800777306ULL, 0x000ff0000020d400ULL,
0x0000001900837306ULL, 0x000ff00000209400ULL, 0x0000001900847306ULL, 0x000ff00000205400ULL,
0x0000001900787306ULL, 0x0003f0000020d400ULL, 0x0000003500957306ULL, 0x000fe20000009400ULL,
0x0000010035197824ULL, 0x002fca00078e00ffULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000003500e07306ULL, 0x000e700000005400ULL, 0x0000003500b87306ULL, 0x000530000000d400ULL,
0x0000001800e57306ULL, 0x000fe20000209400ULL, 0x0001000035357824ULL, 0x004fe200078e00ffULL,
0x000000e09500720bULL, 0x002fe20003f9d000ULL, 0x000001002fe07824ULL, 0x000fc600078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000001800da7306ULL, 0x000e6e0000205400ULL,
0x00000001b8b84812ULL, 0x010fe200078efcffULL, 0x0000003400b97306ULL, 0x000530000000d400ULL,
0x0000003500de7306ULL, 0x000fe20000209400ULL, 0x0001000034347824ULL, 0x004fe200078e00ffULL,
0x000000dae500720bULL, 0x002fc80003fdd000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500df7306ULL, 0x000e620000205400ULL, 0x00000001b9b92812ULL, 0x010fce00078efcffULL,
0x0000001800c67306ULL, 0x000530000020d400ULL, 0x0000003600d57306ULL, 0x000fe20000009400ULL,
0x0000010036187824ULL, 0x004fe200078e00ffULL, 0x000000dfde00720bULL, 0x002fcc0003f5d000ULL,
0x0000003600c47306ULL, 0x000e620000005400ULL, 0x00000001c6c66812ULL, 0x010fce00078efcffULL,
0x0000003600a47306ULL, 0x000530000000d400ULL, 0x0000003400e17306ULL, 0x000fe20000209400ULL,
0x0001000036367824ULL, 0x004fe200078e00ffULL, 0x000000c4d500720bULL, 0x002fc80003fbd000ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000003400e47306ULL, 0x000e6e0000205400ULL,
0x00000001a4a45812ULL, 0x010fe200078efcffULL, 0x0000003400c57306ULL, 0x000522000020d400ULL,
0x000000cbd000720bULL, 0x000fce0003fbd000ULL, 0x0000001900e67306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x004fe20000011418ULL, 0x0000010037187824ULL, 0x000fe200078e00ffULL,
0x000000e4e100720bULL, 0x002fe40003f7d000ULL, 0x00000018ffe17819ULL, 0x000fe400000114e0ULL,
0x00000018ff887819ULL, 0x000fe20000011418ULL, 0x0000001900e37306ULL, 0x000e620000205400ULL,
0x0000000196965812ULL, 0x000fce00078efcffULL, 0x0000001b00b17306ULL, 0x000fe20000009400ULL,
0x00000001c5c53812ULL, 0x010fce00078efcffULL, 0x0000001b00b27306ULL, 0x000fe20000005400ULL,
0x000000e3e600720bULL, 0x002fce0003fdd000ULL, 0x0000001b001f7306ULL, 0x0003f0000000d400ULL,
0x0000001900c77306ULL, 0x000ea2000020d400ULL, 0x000100001b1b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff1b7819ULL, 0x000fe4000001141bULL, 0x0000003500ba7306ULL, 0x000330000020d400ULL,
0x0000003600197306ULL, 0x000fe20000209400ULL, 0x000001002d357824ULL, 0x002fe200078e00ffULL,
0x00000001c7c76812ULL, 0x004fc800078efcffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003600187306ULL, 0x000e620000205400ULL, 0x00000001baba2812ULL, 0x010fc800078efcffULL,
0x000000ba1515723eULL, 0x000fc600000010ffULL, 0x0000001b00897306ULL, 0x000ff00000209400ULL,
0x0000001b008a7306ULL, 0x000fe20000205400ULL, 0x000000181900720bULL, 0x002fce0003f5d000ULL,
0x0000001b007d7306ULL, 0x000ff0000020d400ULL, 0x0000001a007e7306ULL, 0x000ff00000209400ULL,
0x0000001a007f7306ULL, 0x000ff00000205400ULL, 0x0000001a007a7306ULL, 0x000ff0000020d400ULL,
0x0000003400dc7306ULL, 0x000ff00000209400ULL, 0x0000003400dd7306ULL, 0x000e700000205400ULL,
0x0000003400b57306ULL, 0x000530000020d400ULL, 0x00000088001a7306ULL, 0x000fe20000209400ULL,
0x000001002c347824ULL, 0x004fe200078e00ffULL, 0x000000dddc00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000088001b7306ULL, 0x000e6e0000205400ULL,
0x00000001b5b53812ULL, 0x010fe200078efcffULL, 0x0000003700d47306ULL, 0x000ff00000009400ULL,
0x0000003700d77306ULL, 0x000ea20000005400ULL, 0x0000001b1a00720bULL, 0x002fc40003fdd000ULL,
0x00a000005818783bULL, 0x000e6a0000000200ULL, 0x0000003600aa7306ULL, 0x000f30000020d400ULL,
0x0000003500eb7306ULL, 0x000fe20000209400ULL, 0x000000d7d400720bULL, 0x004fce0003f9d000ULL,
0x0000003500ec7306ULL, 0x000ea20000205400ULL, 0x00000001aaaa2812ULL, 0x010fce00078efcffULL,
0x00000037009f7306ULL, 0x000970000000d400ULL, 0x0000002c00ce7306ULL, 0x000fe20000009400ULL,
0x0001000037377824ULL, 0x010fe200078e00ffULL, 0x000000eceb00720bULL, 0x004fc80003f5d000ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000002c00d17306ULL, 0x000ea20000005400ULL,
0x000000019f9f4812ULL, 0x020fce00078efcffULL, 0x0000002c00927306ULL, 0x000970000000d400ULL,
0x0000003400e97306ULL, 0x000fe20000209400ULL, 0x000100002c2c7824ULL, 0x010fe200078e00ffULL,
0x000000d1ce00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff367819ULL, 0x000fe4000001142cULL,
0x0000003400ea7306ULL, 0x000fee0000205400ULL, 0x0000000192924812ULL, 0x020fe200078efcffULL,
0x0000003400a37306ULL, 0x0005f0000020d400ULL, 0x0000008800a87306ULL, 0x000f22000020d400ULL,
0x000001002e347824ULL, 0x004fca00078e00ffULL, 0x00000018fff27819ULL, 0x000fe40000011434ULL,
0x0000003700e77306ULL, 0x000ff00000209400ULL, 0x0000003700e87306ULL, 0x000ea20000205400ULL,
0x00000001a8a86812ULL, 0x010fc400078efcffULL, 0x000000eae900720bULL, 0x000fca0003fdd000ULL,
0x00000035009c7306ULL, 0x000f30000020d400ULL, 0x00000036002c7306ULL, 0x000fe20000209400ULL,
0x000000e8e700720bULL, 0x004fe40003f7d000ULL, 0x00000001a3a36812ULL, 0x000fc400078efcffULL,
0x000000cacd00720bULL, 0x000fe40003fdd000ULL, 0x00009910c3ca7816ULL, 0x000fe200000000ffULL,
0x0000003600ed7306ULL, 0x000ea20000205400ULL, 0x000000019c9c2812ULL, 0x010fce00078efcffULL,
0x000000f200ef7306ULL, 0x000fe40000209400ULL, 0x0000000182826812ULL, 0x000fe400078efcffULL,
0x000000bbc000720bULL, 0x000fe20003fdd000ULL, 0x0001000032c07824ULL, 0x000fc600078e00ffULL,
0x000000f200f07306ULL, 0x000f220000205400ULL, 0x000000ed2c00720bULL, 0x004fe40003fbd000ULL,
0x00000018ffc07819ULL, 0x000fca00000114c0ULL, 0x0000002d00cc7306ULL, 0x000fe20000009400ULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x000000aeb300720bULL, 0x000fca0003fdd000ULL,
0x0000002d00c97306ULL, 0x000ea20000005400ULL, 0x000000f0ef00720bULL, 0x010fce0003f5d000ULL,
0x0000002d008b7306ULL, 0x000962000000d400ULL, 0x000000011c1c6812ULL, 0x000fe400078efcffULL,
0x000000868500720bULL, 0x000fca0003fdd000ULL, 0x0000002e00da7306ULL, 0x000fe20000009400ULL,
0x000100002d2d7824ULL, 0x010fe200078e00ffULL, 0x000000c9cc00720bULL, 0x004fc80003f1d000ULL,
0x00000018fff17819ULL, 0x000fe4000001142dULL, 0x0000002e00db7306ULL, 0x000ea20000005400ULL,
0x000000015c5c6812ULL, 0x000fe400078efcffULL, 0x000000848300720bULL, 0x000fc80003fdd000ULL,
0x000000018b8b0812ULL, 0x020fe200078efcffULL, 0x0000002e00957306ULL, 0x000970000000d400ULL,
0x0000003700a57306ULL, 0x000ee2000020d400ULL, 0x000100002e2e7824ULL, 0x010fe200078e00ffULL,
0x000000dbda00720bULL, 0x004fc40003f1d000ULL, 0x0000000178786812ULL, 0x000fe400078efcffULL,
0x00000018ffd27819ULL, 0x000fe4000001142eULL, 0x00000036009e7306ULL, 0x000ea2000020d400ULL,
0x000000705d00720bULL, 0x000fcc0003fdd000ULL, 0x0000000195950812ULL, 0x020fe200078efcffULL,
0x000000f200947306ULL, 0x000f22000020d400ULL, 0x00000001a5a53812ULL, 0x008fe400078efcffULL,
0x000000c8cf00720bULL, 0x000fe40003f7d000ULL, 0x000000c2c100720bULL, 0x000fe20003f1d000ULL,
0x0001000031c17824ULL, 0x000fe200078e00ffULL, 0x000000016d6d6812ULL, 0x000fe200078efcffULL,
0x000000f1002d7306ULL, 0x000fe20000209400ULL, 0x000000019e9e5812ULL, 0x004fe200078efcffULL,
0x0000010032c27824ULL, 0x000fe200078e00ffULL, 0x00000018ffc17819ULL, 0x000fc400000114c1ULL,
0x0000005f6c00720bULL, 0x000fe40003fdd000ULL, 0x00000018ffc27819ULL, 0x000fe200000114c2ULL,
0x000000f100ee7306ULL, 0x000ea20000205400ULL, 0x0000000194942812ULL, 0x010fe400078efcffULL,
0x0000000187873812ULL, 0x000fe400078efcffULL, 0x000000ffca00720cULL, 0x000fe40003f65270ULL,
0x0000000176760812ULL, 0x000fe200078efcffULL, 0x000000e100e07306ULL, 0x000fe20000209400ULL,
0x000000bebd00720bULL, 0x000fc40003f1d000ULL, 0x000000959494723eULL, 0x000fe400000010ffULL,
0x000000016b6b6812ULL, 0x000fc600078efcffULL, 0x000000e100dd7306ULL, 0x000ee20000205400ULL,
0x000000ee2d00720bULL, 0x004fe20003f9d000ULL, 0x000000231818b231ULL, 0x082fe400003400ffULL,
0x000000231a1ab231ULL, 0x000fe400003400ffULL, 0x000000141919b231ULL, 0x080fe200003400ffULL,
0x0000000171710812ULL, 0x000fe200078efcffULL, 0x000000d200d37306ULL, 0x000fe20000209400ULL,
0x000000141b1bb231ULL, 0x000fe200003400ffULL, 0x000000a9a600720bULL, 0x000fcc0003f1d000ULL,
0x000000d200ce7306ULL, 0x000e620000205400ULL, 0x000000dde000720bULL, 0x008fcc0003fbd000ULL,
0x0000000175750812ULL, 0x000fe200078efcffULL, 0x0000002f00d87306ULL, 0x000ff00000009400ULL,
0x0000002f00d97306ULL, 0x000fe20000005400ULL, 0x000000ced300720bULL, 0x002fce0003f5d000ULL,
0x0000002f00977306ULL, 0x0003f0000000d400ULL, 0x000000f100937306ULL, 0x000ea2000020d400ULL,
0x000100002f2f7824ULL, 0x002fca00078e00ffULL, 0x00000018ffc97819ULL, 0x000fe4000001142fULL,
0x000000e100c47306ULL, 0x000e62000020d400ULL, 0x00a000002b2c783bULL, 0x000eee0000000200ULL,
0x000000d200c37306ULL, 0x000f22000020d400ULL, 0x0000000193934812ULL, 0x004fc400078efcffULL,
0x000000d9d800720bULL, 0x000fe40003f9d000ULL, 0x000000938293723eULL, 0x000fc600000010ffULL,
0x000000c900c87306ULL, 0x000fe20000209400ULL, 0x00000001c4c45812ULL, 0x002fce00078efcffULL,
0x000000c900cb7306ULL, 0x000e620000205400ULL, 0x00000001c3c32812ULL, 0x010fe400078efcffULL,
0x000000afb400720bULL, 0x000fe40003f5d000ULL, 0x0000000197974812ULL, 0x000fe400078efcffULL,
0x00000022ad00720bULL, 0x000fe20003f9d000ULL, 0x000000c900bb7306ULL, 0x000ea2000020d400ULL,
0x000000b9c622723eULL, 0x000fe400000010ffULL, 0x00000097c495723eULL, 0x000fc400000010ffULL,
0x000000c37cba723eULL, 0x000fe400000010ffULL, 0x000000cbc800720bULL, 0x002fe20003fbd000ULL,
0x00000030009a7306ULL, 0x000fe20000009400ULL, 0x0000000116162812ULL, 0x000fe200078efcffULL,
0x000000232c2cb231ULL, 0x088fe200003400ffULL, 0x000000a2a700720bULL, 0x000fe20003f5d000ULL,
0x000000232e2eb231ULL, 0x000fe200003400ffULL, 0x0000000172724812ULL, 0x000fe200078efcffULL,
0x000000142d2db231ULL, 0x080fe200003400ffULL, 0x000000b6b700720bULL, 0x000fe20003f9d000ULL,
0x00000030009b7306ULL, 0x000e620000005400ULL, 0x000000142f2fb231ULL, 0x000fe200003400ffULL,
0x000000b8c723723eULL, 0x000fe200000010ffULL, 0x0000010033c87824ULL, 0x000fe200078e00ffULL,
0x00000001bbbb5812ULL, 0x004fc400078efcffULL, 0x000000bcbf00720bULL, 0x000fe40003fbd000ULL,
0x000000015a5a2812ULL, 0x000fe200078efcffULL, 0x0000003000217306ULL, 0x000ea2000000d400ULL,
0x000000989900720bULL, 0x000fe20003f5d000ULL, 0x000000222c54723cULL, 0x040fe20000041854ULL,
0x000000b2b100720bULL, 0x000fe40003f7d000ULL, 0x0000000173734812ULL, 0x000fe400078efcffULL,
0x0000009b9a00720bULL, 0x002fe20003f9d000ULL, 0x0000003100917306ULL, 0x000fe20000009400ULL,
0x000000c5b014723eULL, 0x000fe200000010ffULL, 0x000000942c3c723cULL, 0x000fe2000004183cULL,
0x0000000179795812ULL, 0x000fc400078efcffULL, 0x000000abac00720bULL, 0x000fe40003fbd000ULL,
0x0000000174742812ULL, 0x000fe200078efcffULL, 0x0000003100907306ULL, 0x000e620000005400ULL,
0x000000818000720bULL, 0x000fe20003f5d000ULL, 0x000000142c50723cULL, 0x000fe20000041850ULL,
0x000000a4b522723eULL, 0x000fe400000010ffULL, 0x0000009fa823723eULL, 0x000fe400000010ffULL,
0x000000011f1f3812ULL, 0x000fe200078efcffULL, 0x0000003100357306ULL, 0x000fe2000000d400ULL,
0x000000aa9d14723eULL, 0x000fc400000010ffULL, 0x0000000124245812ULL, 0x000fe200078efcffULL,
0x000000222c4c723cULL, 0x040fe2000004184cULL, 0x000000a1a000720bULL, 0x000fe40003fbd000ULL,
0x000000a59615723eULL, 0x000fe200000010ffULL, 0x000000d600307306ULL, 0x000fe20000209400ULL,
0x0000008a8900720bULL, 0x000fe40003f7d000ULL, 0x00000092a322723eULL, 0x000fe400000010ffULL,
0x0000008b9c23723eULL, 0x000fe200000010ffULL, 0x000000142c48723cULL, 0x000fe20000041848ULL,
0x000000015e5e2812ULL, 0x000fe200078efcffULL, 0x000000d600317306ULL, 0x000ee20000205400ULL,
0x0000000121214812ULL, 0x004fc400078efcffULL, 0x0000000177775812ULL, 0x000fe400078efcffULL,
0x000000909100720bULL, 0x002fe20003f1d000ULL, 0x000000222c44723cULL, 0x000fe20000041844ULL,
0x0000008f8e00720bULL, 0x000fe20003fbd000ULL, 0x0000003300377306ULL, 0x000fe20000009400ULL,
0x0000007f7e00720bULL, 0x000fe40003f5d000ULL, 0x000000727914723eULL, 0x000fe400000010ffULL,
0x000000167115723eULL, 0x000fc400000010ffULL, 0x0000009e8792723eULL, 0x000fe200000010ffULL,
0x0000003300887306ULL, 0x000e620000005400ULL, 0x000000313000720bULL, 0x008fe40003f9d000ULL,
0x000000bb76bb723eULL, 0x000fe200000010ffULL, 0x000000141854723cULL, 0x000fe20000041854ULL,
0x000000732422723eULL, 0x000fe400000010ffULL, 0x00000018ffc87819ULL, 0x000fe200000114c8ULL,
0x00000032008c7306ULL, 0x000fe20000009400ULL, 0x000000017d7d3812ULL, 0x000fc400078efcffULL,
0x0000001f7415723eULL, 0x000fe200000010ffULL, 0x000000922c40723cULL, 0x040fe20000041840ULL,
0x000000017b7b5812ULL, 0x000fe400078efcffULL, 0x000000017a7a2812ULL, 0x000fe200078efcffULL,
0x00000032008d7306ULL, 0x000ea20000005400ULL, 0x000000883700720bULL, 0x002fe40003f7d000ULL,
0x0000000135350812ULL, 0x000fe200078efcffULL, 0x000000ba2c38723cULL, 0x000fe20000041838ULL,
0x0000006e6300720bULL, 0x000fc40003f1d000ULL, 0x000000357a79723eULL, 0x000fe200000010ffULL,
0x0000003200347306ULL, 0x000e62000000d400ULL, 0x000000755a23723eULL, 0x000fe400000010ffULL,
0x0000001c7714723eULL, 0x000fe400000010ffULL, 0x0000007b5c5c723eULL, 0x000fe400000010ffULL,
0x0000007d5e5d723eULL, 0x000fe200000010ffULL, 0x000000d600327306ULL, 0x000ee2000020d400ULL,
0x0000008d8c00720bULL, 0x004fe20003fbd000ULL, 0x000000221850723cULL, 0x000fe20000041850ULL,
0x0000000161610812ULL, 0x000fc400078efcffULL, 0x000000217878723eULL, 0x000fc600000010ffULL,
0x000000c100ad7306ULL, 0x000fe40000209400ULL, 0x00000014184c723cULL, 0x040fe8000004184cULL,
0x0000000134345812ULL, 0x002fe400078efcffULL, 0x000000c100ae7306ULL, 0x000e620000205400ULL,
0x0000000132324812ULL, 0x008fe200078efcffULL, 0x0000005c1848723cULL, 0x000fe60000041848ULL,
0x000000326d32723eULL, 0x000fc600000010ffULL, 0x000000c200a67306ULL, 0x000fe40000209400ULL,
0x000000781844723cULL, 0x000fec0000041844ULL, 0x000000c2009b7306ULL, 0x000ea20000205400ULL,
0x000000aead00720bULL, 0x002fce0003f5d000ULL, 0x0000003300367306ULL, 0x0002f0000000d400ULL,
0x000000c100ac7306ULL, 0x000f22000020d400ULL, 0x0001000033337824ULL, 0x002fe200078e00ffULL,
0x0000009ba600720bULL, 0x004fc80003f9d000ULL, 0x00000018ff247819ULL, 0x000fe40000011433ULL,
0x000000c200917306ULL, 0x000e62000020d400ULL, 0x0000000136363812ULL, 0x008fce00078efcffULL,
0x000000c8008b7306ULL, 0x000fe20000209400ULL, 0x00000001acac2812ULL, 0x010fe400078efcffULL,
0x0000006f6200720bULL, 0x000fe40003f5d000ULL, 0x000000ac6133723eULL, 0x000fc600000010ffULL,
0x000000c800807306ULL, 0x000ea20000205400ULL, 0x0000000191914812ULL, 0x002fc600078efcffULL,
0x000000321840723cULL, 0x000fe20000041840ULL, 0x000000349134723eULL, 0x000fc600000010ffULL,
0x000000c000377306ULL, 0x000fe20000209400ULL, 0x0000000160602812ULL, 0x000fce00078efcffULL,
0x000000c000167306ULL, 0x000e620000205400ULL, 0x000000808b00720bULL, 0x004fce0003f1d000ULL,
0x00000024002c7306ULL, 0x000ff00000209400ULL, 0x00000024001f7306ULL, 0x000ea20000205400ULL,
0x000000163700720bULL, 0x002fce0003f9d000ULL, 0x000000c800817306ULL, 0x000e70000020d400ULL,
0x000000c000c07306ULL, 0x000ee2000020d400ULL, 0x0000001f2c00720bULL, 0x004fce0003fbd000ULL,
0x0000002400c17306ULL, 0x000ea2000020d400ULL, 0x0000000181810812ULL, 0x002fc800078efcffULL,
0x000000368135723eULL, 0x000fe400000010ffULL, 0x00000001c0c04812ULL, 0x008fc800078efcffULL,
0x000000c06bc0723eULL, 0x000fe200000010ffULL, 0x00000034183c723cULL, 0x000fe2000004183cULL,
0x00000001c1c15812ULL, 0x004fc800078efcffULL, 0x000000c160c1723eULL, 0x000fce00000010ffULL,
0x000000c01838723cULL, 0x000fe20000041838ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200017147f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c020207810ULL, 0x000fe20007ffe0ffULL,
0x00f6980059ff7f8cULL, 0x0007e2000c80043fULL, 0x000000011e5d7812ULL, 0x000fe200078e0cffULL,
0x000000ffff1f7224ULL, 0x000fe200078e0013ULL, 0x000000032000720cULL, 0x000fda0003f06070ULL,
0x00002b1000000947ULL, 0x000fea0003800000ULL, 0x000004001d147984ULL, 0x00cea40000000800ULL,
0x8000000014ff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240017147984ULL, 0x000ea40000000800ULL, 0x8000000014ff7812ULL, 0x004fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff097424ULL, 0x000fc800078e00ffULL, 0x0000000900147305ULL, 0x0004e4000021f000ULL,
0x3fa0000009097823ULL, 0x004fe200000100ffULL, 0x000000140000735dULL, 0x008fe40003800000ULL,
0x0000240017147984ULL, 0x000ea40000000800ULL, 0x8000000014ff7812ULL, 0x004fc40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff097819ULL, 0x000fe20000011600ULL,
0x00000080ff317424ULL, 0x000fe200078e00ffULL, 0x0000030004147a10ULL, 0x000fe20007ffe0ffULL,
0x00000000650473c2ULL, 0x0004e200000e0000ULL, 0x00000003ff1f7819ULL, 0x000fe40000011602ULL,
0x0000000114187810ULL, 0x040fe20007ffe0ffULL, 0x0000000814167824ULL, 0x000fe200078e0209ULL,
0x000000041f237810ULL, 0x040fe40007ffe0ffULL, 0x000000051800720cULL, 0x000fe20003f06070ULL,
0x0000002016167824ULL, 0x000fe200078e00ffULL, 0x000000081f2d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000c1f2f7810ULL, 0x000fe20007ffe0ffULL, 0x00006200061c7a24ULL, 0x100fe200078e0216ULL,
0x0000001603197217ULL, 0x000fe40007800000ULL, 0x000000085b5b7812ULL, 0x000fe400078ec0ffULL,
0x0000001f1c157210ULL, 0x140fe20007ffe007ULL, 0x0000000119197824ULL, 0x000fe200078e0a16ULL,
0x000000231c187210ULL, 0x000fe20007ffe007ULL, 0x0000000164647824ULL, 0x000fe400078e025bULL,
0x00005e0015147625ULL, 0x000fca00078e0031ULL, 0x00000027141a7210ULL, 0x000fe40007f5e0ffULL,
0x0000002019147807ULL, 0x000fe20000000000ULL, 0x00005e0018187625ULL, 0x000fc600078e0031ULL,
0x0000001407147217ULL, 0x000fe20007800000ULL, 0x000000ffff1b7224ULL, 0x000fe200010e0615ULL,
0x0000002718207210ULL, 0x000fe40007f1e0ffULL, 0x0000002f1c187210ULL, 0x100fe20007ffe007ULL,
0x0000000114167824ULL, 0x100fe200078e0a07ULL, 0x0000002d1c147210ULL, 0x000fe20007ffe007ULL,
0x000000ffff217224ULL, 0x000fe400000e0619ULL, 0x00005e0018187625ULL, 0x000fe200078e0031ULL,
0x000000161f00720cULL, 0x000fc40003f06070ULL, 0x000000162300720cULL, 0x080fe20003f46070ULL,
0x00005e0014147625ULL, 0x000fe200078e0031ULL, 0x000000162d00720cULL, 0x080fe40003f66070ULL,
0x000000162f00720cULL, 0x000fe40003f86070ULL, 0x0000002714147210ULL, 0x080fe40007fbe0ffULL,
0x0000002718187210ULL, 0x000fc60007fde0ffULL, 0x000000ffff157224ULL, 0x000fe200028e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a667faeULL, 0x0009e2000c101c46ULL,
0x000000ffff197224ULL, 0x000fc600030e0619ULL, 0x0000000020677faeULL, 0x0009e8000d101c46ULL,
0x0000000014687faeULL, 0x0009e8000d901c46ULL, 0x0000000018697faeULL, 0x0009e8000e101c46ULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x008fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000064147f8cULL, 0x0104e8000c80043fULL, 0x000004006a1b7984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6680025187f8cULL, 0x000fe2000c80043fULL, 0x800000001bff7812ULL, 0x010fc60007844813ULL,
0x00f66c00251f7984ULL, 0x000f240000000800ULL, 0x800000001fff7812ULL, 0x010fe40007804819ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1f7224ULL, 0x008fe200078e0015ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff147424ULL, 0x000fc800078e00ffULL, 0x0000001400157305ULL, 0x000724000021f000ULL,
0x3fa0000014147823ULL, 0x008fe200000100ffULL, 0x000000150000735dULL, 0x010fe40003800000ULL,
0x00f66c0025157984ULL, 0x000ee40000000800ULL, 0x8000000015ff7812ULL, 0x008fc40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018027157810ULL, 0x000fca0007ffe026ULL,
0x0000000128157824ULL, 0x000fca00078e0215ULL, 0x00f0000015167984ULL, 0x000ee80000000800ULL,
0x00f2000015187984ULL, 0x0008620000000800ULL, 0x0000000b1600720bULL, 0x008fe20003f1d000ULL,
0x0000be827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x010fc800000e0100ULL,
0x0000ffff141b7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff967424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000300157811ULL, 0x000fe400078ff0ffULL, 0x0000000b1600720bULL, 0x000fe40003f14000ULL,
0x000000001500720cULL, 0x000fe20003f65270ULL, 0x0000be527f007947ULL, 0x000ff4000b800000ULL,
0x0000000000147806ULL, 0x000fe400000e0100ULL, 0x000000160b157209ULL, 0x000fe20007810000ULL,
0x000000800027b824ULL, 0x000fe200078e0227ULL, 0x0000ffff14147812ULL, 0x000fe400078e3cffULL,
0x00000002ff347819ULL, 0x000fe20000011602ULL, 0x000000012828b824ULL, 0x000fe200078e0227ULL,
0x000000141bff7212ULL, 0x000fe2000780c0ffULL, 0x800000150b0b7221ULL, 0x000fc60000010000ULL,
0x00f400152800b388ULL, 0x0007e20000000800ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL,
0x0000000b00337308ULL, 0x000f240000000800ULL, 0x000000330d0d7220ULL, 0x010fe20000410000ULL,
0x0000bde27f007947ULL, 0x000fea000b800000ULL, 0x00001f34330b7589ULL, 0x00872400000e0000ULL,
0x0000000b54547220ULL, 0x090fe40000410000ULL, 0x0000000b55557220ULL, 0x080fe40000410000ULL,
0x0000000b50507220ULL, 0x080fe40000410000ULL, 0x0000000b51517220ULL, 0x080fe40000410000ULL,
0x0000000b4c4c7220ULL, 0x000fc40000410000ULL, 0x0000000b4d4d7220ULL, 0x080fe40000410000ULL,
0x0000000b48487220ULL, 0x080fe40000410000ULL, 0x0000000b49497220ULL, 0x080fe40000410000ULL,
0x0000000b44447220ULL, 0x080fe40000410000ULL, 0x0000000b45457220ULL, 0x080fe40000410000ULL,
0x0000000b40407220ULL, 0x000fc40000410000ULL, 0x0000000b41417220ULL, 0x080fe40000410000ULL,
0x0000000b3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000b3d3d7220ULL, 0x080fe40000410000ULL,
0x0000000b38387220ULL, 0x080fe40000410000ULL, 0x0000000b39397220ULL, 0x000fe20000410000ULL,
0x0000bd227f007947ULL, 0x000fea000b800000ULL, 0x00001f2a330b7589ULL, 0x0008a400000e0000ULL,
0x8000001516160221ULL, 0x000fe20000010000ULL, 0x00000001ff967807ULL, 0x000fe20000000000ULL,
0x0000000b56567220ULL, 0x004fc40000410000ULL, 0x3fb8aa3b16160820ULL, 0x000fe40000410000ULL,
0x0000000b57577220ULL, 0x080fe40000410000ULL, 0x0000001600290308ULL, 0x000ea20000000800ULL,
0x0000000b52527220ULL, 0x080fe40000410000ULL, 0x0000000b53537220ULL, 0x080fe40000410000ULL,
0x0000000b4e4e7220ULL, 0x080fe40000410000ULL, 0x0000000b4f4f7220ULL, 0x000fc40000410000ULL,
0x0000000b4a4a7220ULL, 0x080fe40000410000ULL, 0x0000000b4b4b7220ULL, 0x080fe40000410000ULL,
0x0000000b46467220ULL, 0x080fe40000410000ULL, 0x0000000b47477220ULL, 0x080fe40000410000ULL,
0x0000000b42427220ULL, 0x080fe40000410000ULL, 0x0000000b43437220ULL, 0x000fc40000410000ULL,
0x0000000b3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000b3f3f7220ULL, 0x080fe40000410000ULL,
0x0000000b3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000b3b3b7220ULL, 0x000fe40000410000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0015ULL, 0x0000001829180220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000000d180d7221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x000000081e147824ULL, 0x000fe200078e00ffULL, 0xfffffff008157812ULL, 0x000fc800078ec0ffULL,
0x0000000814147812ULL, 0x000fca00078e0cffULL, 0x0000000114167824ULL, 0x000fca00078e0215ULL,
0x00f6ac0016157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff147424ULL, 0x000fc800078e00ffULL, 0x0000001400157305ULL, 0x000364000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x000000150000735dULL, 0x020fe40003800000ULL,
0x00f6ac0016157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff347819ULL, 0x008fe40000011602ULL,
0x00000029ff14723eULL, 0x000fe400000010ffULL, 0x0000001834127810ULL, 0x040fe40007ffe0ffULL,
0x0000001034137810ULL, 0x000fe40007ffe0ffULL, 0x0000541014337816ULL, 0x010fe20000000014ULL,
0x0000ba727f007947ULL, 0x000fea000b800000ULL, 0x00001f3433957589ULL, 0x0002e400000e0000ULL,
0x0000bab27f007947ULL, 0x000fea000b800000ULL, 0x00001f2a33147589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff347224ULL, 0x002fe200078e0013ULL,
0x0000a3e000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000c1c000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff347224ULL, 0x002fe200078e0012ULL,
0x0000a44000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000c16000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000e18783bULL, 0x000f620000004200ULL,
0x0000991096967816ULL, 0x000fc600000000ffULL, 0x000000000f24783bULL, 0x000fe80000004200ULL,
0x00000000102c783bULL, 0x000f280000004200ULL, 0x000000001120783bULL, 0x000ee20000004200ULL,
0x00000018ff2a7819ULL, 0x030fe20000011419ULL, 0x0000001800bf7306ULL, 0x000fe20000009400ULL,
0x00000018ff167819ULL, 0x000fe20000011418ULL, 0x00000100186d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fc4000001141aULL, 0x00000018ff327819ULL, 0x004fe4000001141bULL,
0x00000018ff377819ULL, 0x000fe2000001142dULL, 0x0000002a00b87306ULL, 0x000fe20000209400ULL,
0x00000018ff337819ULL, 0x002fe40000011426ULL, 0x00000018ff737819ULL, 0x008fe40000011421ULL,
0x00000018ff347819ULL, 0x000fe4000001142cULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000002a00bd7306ULL, 0x000fe20000205400ULL, 0x00000018ff5b7819ULL, 0x000fc4000001142fULL,
0x00000018ff757819ULL, 0x000fe40000011422ULL, 0x00000018ff787819ULL, 0x000fc60000011423ULL,
0x0000002a00157306ULL, 0x0003f0000020d400ULL, 0x0000001800ba7306ULL, 0x000ea20000005400ULL,
0x00000018ff2a7819ULL, 0x002fce0000011425ULL, 0x00000018009a7306ULL, 0x0002f0000000d400ULL,
0x0000002a00ae7306ULL, 0x000fe20000209400ULL, 0x0001000018187824ULL, 0x002fe200078e00ffULL,
0x000000babf00720bULL, 0x004fcc0003f1d000ULL, 0x0000002a00b57306ULL, 0x000fee0000205400ULL,
0x000000019a9a0812ULL, 0x008fe200078efcffULL, 0x0000002a006e7306ULL, 0x000ff0000020d400ULL,
0x00000037008d7306ULL, 0x000ff00000209400ULL, 0x00000037008a7306ULL, 0x000ff00000205400ULL,
0x00000037002a7306ULL, 0x000ff0000020d400ULL, 0x00000073005d7306ULL, 0x000ff00000209400ULL,
0x0000007300627306ULL, 0x000ff00000205400ULL, 0x0000007300377306ULL, 0x0003f0000020d400ULL,
0x0000001600be7306ULL, 0x000fe20000209400ULL, 0x00000018ff737819ULL, 0x002fce0000011418ULL,
0x0000007300c57306ULL, 0x000ff00000209400ULL, 0x0000007300187306ULL, 0x000e700000205400ULL,
0x0000001600c17306ULL, 0x000eb00000205400ULL, 0x0000001600947306ULL, 0x000722000020d400ULL,
0x00000018c500720bULL, 0x002fce0003f5d000ULL, 0x0000003000b27306ULL, 0x000fe20000209400ULL,
0x00000018ff167819ULL, 0x008fe40000011424ULL, 0x000000c1be00720bULL, 0x004fca0003fbd000ULL,
0x0000003000b97306ULL, 0x000ff00000205400ULL, 0x0000003000827306ULL, 0x000fe2000020d400ULL,
0x0000000194945812ULL, 0x010fce00078efcffULL, 0x0000003200bb7306ULL, 0x000ff00000209400ULL,
0x0000003200b47306ULL, 0x000ff00000205400ULL, 0x00000032007b7306ULL, 0x0003f0000020d400ULL,
0x0000003300a67306ULL, 0x000fe20000209400ULL, 0x00000018ff327819ULL, 0x002fce0000011427ULL,
0x0000003300a77306ULL, 0x000ff00000205400ULL, 0x00000033006b7306ULL, 0x0003f0000020d400ULL,
0x0000003400997306ULL, 0x000fe20000209400ULL, 0x00000018ff337819ULL, 0x002fce000001142eULL,
0x0000003400927306ULL, 0x000ff00000205400ULL, 0x0000003400307306ULL, 0x0003f0000020d400ULL,
0x00000073009b7306ULL, 0x0004e2000020d400ULL, 0x00000018ff347819ULL, 0x002fce0000011420ULL,
0x0000006d00c07306ULL, 0x000fe20000209400ULL, 0x000001001b737824ULL, 0x004fca00078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000006d00c37306ULL, 0x000e620000205400ULL,
0x000000019b9b2812ULL, 0x008fe400078efcffULL, 0x000000bdb800720bULL, 0x000fca0003f5d000ULL,
0x0000001600b17306ULL, 0x000ff00000209400ULL, 0x0000001600ac7306ULL, 0x000fe20000205400ULL,
0x000000c3c000720bULL, 0x002fe40003f9d000ULL, 0x0000000115152812ULL, 0x000fc400078efcffULL,
0x000000b9b200720bULL, 0x000fc60003f5d000ULL, 0x0000001600767306ULL, 0x000ff0000020d400ULL,
0x0000003200a47306ULL, 0x000fe40000209400ULL, 0x0000000182822812ULL, 0x000fcc00078efcffULL,
0x0000003200a57306ULL, 0x000ff00000205400ULL, 0x0000003200667306ULL, 0x000ff0000020d400ULL,
0x0000003300747306ULL, 0x000ff00000209400ULL, 0x0000003300777306ULL, 0x000ff00000205400ULL,
0x0000003300167306ULL, 0x000ff0000020d400ULL, 0x0000005b006f7306ULL, 0x000ff00000209400ULL,
0x0000005b00707306ULL, 0x000ff00000205400ULL, 0x0000005b005c7306ULL, 0x000ff0000020d400ULL,
0x0000003400327306ULL, 0x000ff00000209400ULL, 0x0000003400637306ULL, 0x000ff00000205400ULL,
0x0000003400607306ULL, 0x000ff0000020d400ULL, 0x00000075005e7306ULL, 0x000ff00000209400ULL,
0x0000007500337306ULL, 0x000ff00000205400ULL, 0x00000075005f7306ULL, 0x0003f0000020d400ULL,
0x00000019009d7306ULL, 0x000fe20000009400ULL, 0x0000010019757824ULL, 0x002fca00078e00ffULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x0000001900bc7306ULL, 0x000e700000005400ULL,
0x0000001900987306ULL, 0x0004f0000000d400ULL, 0x00000078005b7306ULL, 0x000fe20000209400ULL,
0x0001000019197824ULL, 0x004fe200078e00ffULL, 0x000000bc9d00720bULL, 0x002fcc0003f7d000ULL,
0x0000007800647306ULL, 0x000fee0000205400ULL, 0x0000000198983812ULL, 0x008fe200078efcffULL,
0x0000007800347306ULL, 0x0003f0000020d400ULL, 0x0000006d00ad7306ULL, 0x0004e2000020d400ULL,
0x000001001a787824ULL, 0x002fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000001a00b67306ULL, 0x000fe20000009400ULL, 0x00000018ff6d7819ULL, 0x004fce0000011419ULL,
0x0000006d00197306ULL, 0x000fe20000209400ULL, 0x00000001adad4812ULL, 0x008fce00078efcffULL,
0x0000006d00c47306ULL, 0x000e700000205400ULL, 0x0000007800c67306ULL, 0x000ff00000209400ULL,
0x0000007800c97306ULL, 0x000ea20000205400ULL, 0x000000c41900720bULL, 0x002fe20003f9d000ULL,
0x0000010020197824ULL, 0x000fca00078e00ffULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000001a00937306ULL, 0x000e700000005400ULL, 0x0000001a00887306ULL, 0x000722000000d400ULL,
0x000000c9c600720bULL, 0x004fce0003fbd000ULL, 0x0000006d008e7306ULL, 0x000562000020d400ULL,
0x000100001a1a7824ULL, 0x008fe200078e00ffULL, 0x00000093b600720bULL, 0x002fcc0003f1d000ULL,
0x0000007800917306ULL, 0x0002e2000020d400ULL, 0x00000018ff6d7819ULL, 0x004fcc000001141aULL,
0x0000000188880812ULL, 0x010fe200078efcffULL, 0x0000002500107306ULL, 0x000fe20000009400ULL,
0x0000010024787824ULL, 0x002fe200078e00ffULL, 0x000000018e8e4812ULL, 0x020fc800078efcffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000002500137306ULL, 0x000e620000005400ULL,
0x0000000191915812ULL, 0x008fe400078efcffULL, 0x000000b4bb00720bULL, 0x000fe40003fbd000ULL,
0x0000008e1515723eULL, 0x000fc600000010ffULL, 0x0000007500c77306ULL, 0x000ff00000209400ULL,
0x0000007500c27306ULL, 0x000ea20000205400ULL, 0x000000131000720bULL, 0x002fe40003f5d000ULL,
0x000000017b7b5812ULL, 0x000fca00078efcffULL, 0x0000006d001a7306ULL, 0x000ff00000209400ULL,
0x0000006d00cd7306ULL, 0x000e620000205400ULL, 0x000000c2c700720bULL, 0x004fce0003fdd000ULL,
0x0000002400b37306ULL, 0x000ff00000009400ULL, 0x0000002400aa7306ULL, 0x000fe20000005400ULL,
0x000000cd1a00720bULL, 0x002fce0003f9d000ULL, 0x00000024007e7306ULL, 0x0003f0000000d400ULL,
0x0000007300cb7306ULL, 0x000fe20000209400ULL, 0x0001000024247824ULL, 0x002fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000007300c87306ULL, 0x000ff00000205400ULL,
0x00000073008b7306ULL, 0x0003f0000020d400ULL, 0x0000006d00897306ULL, 0x0004e2000020d400ULL,
0x0000010025737824ULL, 0x002fca00078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x0000002500727306ULL, 0x000322000000d400ULL, 0x00000100266d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x0000007500ab7306ULL, 0x000ea2000020d400ULL,
0x0001000025257824ULL, 0x002fe200078e00ffULL, 0x0000000189894812ULL, 0x008fc800078efcffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000007300d27306ULL, 0x000fe20000209400ULL,
0x0000000172722812ULL, 0x010fce00078efcffULL, 0x0000007300d57306ULL, 0x000e620000205400ULL,
0x00000001abab6812ULL, 0x004fe400078efcffULL, 0x000000c8cb00720bULL, 0x000fca0003fdd000ULL,
0x0000002400d47306ULL, 0x000ff00000209400ULL, 0x0000002400d77306ULL, 0x000ea20000205400ULL,
0x000000d5d200720bULL, 0x002fe40003f9d000ULL, 0x000000018b8b6812ULL, 0x000fc400078efcffULL,
0x000000aab300720bULL, 0x000fc60003fdd000ULL, 0x0000006d00de7306ULL, 0x000ff00000209400ULL,
0x0000006d00e17306ULL, 0x000e620000205400ULL, 0x000000d7d400720bULL, 0x004fe40003fbd000ULL,
0x000000017e7e6812ULL, 0x000fc400078efcffULL, 0x000000b5ae00720bULL, 0x000fc60003fdd000ULL,
0x0000002500da7306ULL, 0x000ff00000209400ULL, 0x0000002500dd7306ULL, 0x000fe20000205400ULL,
0x000000e1de00720bULL, 0x002fe40003f5d000ULL, 0x000000016e6e6812ULL, 0x000fc400078efcffULL,
0x000000a7a600720bULL, 0x000fe20003fdd000ULL, 0x0001000023a67824ULL, 0x000fe400078e00ffULL,
0x0000002500797306ULL, 0x0003e6000020d400ULL, 0x00000018ffa67819ULL, 0x000fca00000114a6ULL,
0x0000001b00b77306ULL, 0x000fe20000009400ULL, 0x000001002c257824ULL, 0x002fe200078e00ffULL,
0x000000016b6b6812ULL, 0x000fcc00078efcffULL, 0x0000001b00b07306ULL, 0x000e700000005400ULL,
0x0000001b00867306ULL, 0x0004f0000000d400ULL, 0x0000002600117306ULL, 0x000fe20000009400ULL,
0x000100001b1b7824ULL, 0x004fe200078e00ffULL, 0x000000b0b700720bULL, 0x002fc80003f7d000ULL,
0x00000018ff757819ULL, 0x000fe4000001141bULL, 0x0000002600127306ULL, 0x000fee0000005400ULL,
0x0000000186863812ULL, 0x008fe200078efcffULL, 0x0000002600717306ULL, 0x0003e6000000d400ULL,
0x000000868b8b723eULL, 0x000fca00000010ffULL, 0x00000073007f7306ULL, 0x0004e2000020d400ULL,
0x0001000026267824ULL, 0x002fce00078e00ffULL, 0x0000006d007a7306ULL, 0x000322000020d400ULL,
0x0000010027737824ULL, 0x004fca00078e00ffULL, 0x00000018ff877819ULL, 0x000fe40000011473ULL,
0x0000002400817306ULL, 0x000562000020d400ULL, 0x00000018ff6d7819ULL, 0x002fe20000011425ULL,
0x000001002d257824ULL, 0x000fe200078e00ffULL, 0x000000017f7f4812ULL, 0x008fe400078efcffULL,
0x000000ddda00720bULL, 0x000fe40003f9d000ULL, 0x000000727f7f723eULL, 0x000fe200000010ffULL,
0x0000002700a97306ULL, 0x000fe20000009400ULL, 0x00000018ff247819ULL, 0x004fc40000011426ULL,
0x000000017a7a2812ULL, 0x010fca00078efcffULL, 0x0000002700a27306ULL, 0x000e620000005400ULL,
0x0000000181815812ULL, 0x020fe400078efcffULL, 0x0000000179794812ULL, 0x000fca00078efcffULL,
0x00000027006a7306ULL, 0x0004f0000000d400ULL, 0x0000002d00a17306ULL, 0x000fe20000009400ULL,
0x0001000027277824ULL, 0x004fe200078e00ffULL, 0x000000a2a900720bULL, 0x002fe20003f9d000ULL,
0x0000010022a27824ULL, 0x000fc600078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000002d009e7306ULL, 0x000fe20000005400ULL, 0x00000018ffa27819ULL, 0x000fcc00000114a2ULL,
0x000000016a6a4812ULL, 0x008fe200078efcffULL, 0x0000002d00317306ULL, 0x0003f0000000d400ULL,
0x00000075001b7306ULL, 0x000fe20000209400ULL, 0x000100002d2d7824ULL, 0x002fca00078e00ffULL,
0x00000018ffe27819ULL, 0x000fe2000001142dULL, 0x000001002e2d7824ULL, 0x000fe200078e00ffULL,
0x0000007500ca7306ULL, 0x000e680000205400ULL, 0x00000018ffe47819ULL, 0x000fc8000001142dULL,
0x0000008700d17306ULL, 0x000ff00000209400ULL, 0x0000008700ce7306ULL, 0x000ea20000205400ULL,
0x000000ca1b00720bULL, 0x002fce0003f1d000ULL, 0x0000002400d37306ULL, 0x000ff00000209400ULL,
0x0000002400d07306ULL, 0x000e620000205400ULL, 0x000000ced100720bULL, 0x004fce0003fbd000ULL,
0x0000002e00a37306ULL, 0x000ff00000009400ULL, 0x0000002e009c7306ULL, 0x000ea20000005400ULL,
0x000000d0d300720bULL, 0x002fce0003f5d000ULL, 0x0000002e00287306ULL, 0x0002f0000000d400ULL,
0x0000002700d67306ULL, 0x000fe20000209400ULL, 0x000100002e2e7824ULL, 0x002fe200078e00ffULL,
0x0000009ca300720bULL, 0x004fcc0003fdd000ULL, 0x0000002700d97306ULL, 0x000fee0000205400ULL,
0x0000000128286812ULL, 0x008fe200078efcffULL, 0x0000002700737306ULL, 0x000fe2000020d400ULL,
0x000000777400720bULL, 0x000fe40003fdd000ULL, 0x000000796e77723eULL, 0x000fca00000010ffULL,
0x000000e200a87306ULL, 0x000fec0000209400ULL, 0x0000000116166812ULL, 0x000fe400078efcffULL,
0x000000e200af7306ULL, 0x000ff00000205400ULL, 0x000000e200277306ULL, 0x0003f0000020d400ULL,
0x0000007800cc7306ULL, 0x000fe20000209400ULL, 0x00000018ffe27819ULL, 0x002fe2000001142eULL,
0x000100002f2e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff187819ULL, 0x000fe2000001142eULL,
0x0000007800cf7306ULL, 0x000e700000205400ULL, 0x0000007500807306ULL, 0x000eb0000020d400ULL,
0x0000007800837306ULL, 0x000ee2000020d400ULL, 0x000000cfcc00720bULL, 0x002fce0003f7d000ULL,
0x0000008700757306ULL, 0x000322000020d400ULL, 0x0000000180800812ULL, 0x004fe400078efcffULL,
0x000000121100720bULL, 0x000fe40003f1d000ULL, 0x00a800005810783bULL, 0x0005660000000200ULL,
0x0000002400787306ULL, 0x000f22000020d400ULL, 0x00000018ff877819ULL, 0x002fe40000011425ULL,
0x0000000183833812ULL, 0x008fc400078efcffULL, 0x000000acb100720bULL, 0x000fe20003f7d000ULL,
0x0001000021587824ULL, 0x004fe200078e00ffULL, 0x0000007e837e723eULL, 0x000fe200000010ffULL,
0x00000018002e7306ULL, 0x000fe20000209400ULL, 0x0000000175755812ULL, 0x010fe400078efcffULL,
0x000000d9d600720bULL, 0x000fe40003fbd000ULL, 0x0000000171710812ULL, 0x000fe400078efcffULL,
0x000000a5a400720bULL, 0x000fe20003f1d000ULL, 0x00000018009d7306ULL, 0x000fe20000205400ULL,
0x0000000178782812ULL, 0x000fe200078efcffULL, 0x0001000022a47824ULL, 0x000fe200078e00ffULL,
0x0000009ea100720bULL, 0x000fe20003f5d000ULL, 0x0000010023a57824ULL, 0x000fe200078e00ffULL,
0x0000000176763812ULL, 0x000fc400078efcffULL, 0x000000ff9600720cULL, 0x000fe20003f65270ULL,
0x0000001800937306ULL, 0x0003e2000020d400ULL, 0x0000000173735812ULL, 0x000fe400078efcffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x0000000166660812ULL, 0x000fe400078efcffULL,
0x000000817676723eULL, 0x000fe200000010ffULL, 0x0000001900b07306ULL, 0x000fe20000209400ULL,
0x0000010021187824ULL, 0x002fe200078e00ffULL, 0x0000000131312812ULL, 0x000fc400078efcffULL,
0x0000008a8d00720bULL, 0x000fe20003f5d000ULL, 0x000000141111b231ULL, 0x0a0fe200003400ffULL,
0x00000018ffb47819ULL, 0x000fe20000011418ULL, 0x000000141313b231ULL, 0x000fe200003400ffULL,
0x0000001900b77306ULL, 0x000e620000205400ULL, 0x000000951010b231ULL, 0x080fe200003400ffULL,
0x00000088918a723eULL, 0x000fe200000010ffULL, 0x000000951212b231ULL, 0x000fe200003400ffULL,
0x000000717a74723eULL, 0x000fe400000010ffULL, 0x0000006a7575723eULL, 0x000fc400000010ffULL,
0x0000001900aa7306ULL, 0x0004e2000020d400ULL, 0x000000012a2a2812ULL, 0x000fe400078efcffULL,
0x000000786b72723eULL, 0x000fe400000010ffULL, 0x000000736673723eULL, 0x000fe400000010ffULL,
0x00000018ffa57819ULL, 0x000fe200000114a5ULL, 0x0000002c000f7306ULL, 0x000fe20000009400ULL,
0x00a800002b18783bULL, 0x004ea20000000200ULL, 0x000000b7b000720bULL, 0x002fc40003fdd000ULL,
0x00000018ffa47819ULL, 0x000fc800000114a4ULL, 0x0000002c000e7306ULL, 0x000e6e0000005400ULL,
0x00000001aaaa6812ULL, 0x008fe200078efcffULL, 0x0000006d00db7306ULL, 0x000fe20000209400ULL,
0x000000633200720bULL, 0x000fce0003fdd000ULL, 0x0000006d00d87306ULL, 0x000ee20000205400ULL,
0x0000000e0f00720bULL, 0x002fe40003f9d000ULL, 0x0000009aad0e723eULL, 0x000fe400000010ffULL,
0x00000098ab0f723eULL, 0x000fe400000010ffULL, 0x0000000160606812ULL, 0x000fe200078efcffULL,
0x0000002c00677306ULL, 0x000322000000d400ULL, 0x000000335e00720bULL, 0x000fce0003fdd000ULL,
0x0000006d00267306ULL, 0x000b22000020d400ULL, 0x000100002c2c7824ULL, 0x002fe200078e00ffULL,
0x000000d8db00720bULL, 0x008fe20003fbd000ULL, 0x000000951818b231ULL, 0x084fe400003400ffULL,
0x000000951a1ab231ULL, 0x000fe200003400ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x000000141919b231ULL, 0x080fe200003400ffULL, 0x0000008700dc7306ULL, 0x000fe20000209400ULL,
0x000001002f6d7824ULL, 0x020fe200078e00ffULL, 0x0000000167674812ULL, 0x010fe200078efcffULL,
0x000000141b1bb231ULL, 0x000fe200003400ffULL, 0x0000009b9414723eULL, 0x000fc400000010ffULL,
0x00000018ffe57819ULL, 0x000fe4000001146dULL, 0x0000008700df7306ULL, 0x000e620000205400ULL,
0x0000000126265812ULL, 0x000fe200078efcffULL, 0x0000000e1854723cULL, 0x000fe20000041854ULL,
0x000000929900720bULL, 0x000fe40003fbd000ULL, 0x000000015f5f6812ULL, 0x000fc600078efcffULL,
0x0000002c00e37306ULL, 0x000fe20000209400ULL, 0x00000089820e723eULL, 0x000fe200000010ffULL,
0x000000141850723cULL, 0x000fe20000041850ULL, 0x000000807b0f723eULL, 0x000fca00000010ffULL,
0x0000002c00e07306ULL, 0x000ea20000205400ULL, 0x000000dfdc00720bULL, 0x002fe20003f1d000ULL,
0x0000000e1848723cULL, 0x000fe20000041848ULL, 0x0000000130305812ULL, 0x000fca00078efcffULL,
0x000000e5008c7306ULL, 0x000fe20000209400ULL, 0x00000067260e723eULL, 0x000fe200000010ffULL,
0x0000008a184c723cULL, 0x040fec000004184cULL, 0x000000e5008f7306ULL, 0x000e620000205400ULL,
0x000000e0e300720bULL, 0x004fe20003f9d000ULL, 0x0000007e1844723cULL, 0x040fec0000041844ULL,
0x0000008700247306ULL, 0x000ea4000020d400ULL, 0x000000761840723cULL, 0x040fec0000041840ULL,
0x0000002c00257306ULL, 0x000ee2000020d400ULL, 0x0000008f8c00720bULL, 0x002fe20003f5d000ULL,
0x00000074183c723cULL, 0x040fec000004183cULL, 0x000000e5006d7306ULL, 0x000e62000020d400ULL,
0x0000000124240812ULL, 0x004fe200078efcffULL, 0x000000721838723cULL, 0x000fe20000041838ULL,
0x000000afa800720bULL, 0x000fc40003f1d000ULL, 0x00000031240f723eULL, 0x000fc600000010ffULL,
0x0000002000847306ULL, 0x000fe20000009400ULL, 0x0000000125254812ULL, 0x008fc600078efcffULL,
0x0000000e1054723cULL, 0x000fe20000041854ULL, 0x000000253026723eULL, 0x000fc600000010ffULL,
0x0000002000857306ULL, 0x000ea20000005400ULL, 0x000000016d6d2812ULL, 0x002fe400078efcffULL,
0x000000706f00720bULL, 0x000fe40003f5d000ULL, 0x0000000127270812ULL, 0x000fc600078efcffULL,
0x000000e400907306ULL, 0x000fe20000209400ULL, 0x000000272a27723eULL, 0x000fce00000010ffULL,
0x000000e400977306ULL, 0x000e620000205400ULL, 0x000000858400720bULL, 0x004fe20003f9d000ULL,
0x000000261050723cULL, 0x000fe20000041850ULL, 0x000000015c5c2812ULL, 0x000fca00078efcffULL,
0x0000002000617306ULL, 0x0004f0000000d400ULL, 0x000000e4002d7306ULL, 0x000f22000020d400ULL,
0x0001000020207824ULL, 0x004fe200078e00ffULL, 0x000000979000720bULL, 0x002fc80003fbd000ULL,
0x00000018ff967819ULL, 0x000fe40000011420ULL, 0x0000002f009f7306ULL, 0x000fe20000009400ULL,
0x0000000161614812ULL, 0x008fc800078efcffULL, 0x00000061aaaa723eULL, 0x000fc600000010ffULL,
0x0000002f00a07306ULL, 0x000e620000005400ULL, 0x000000012d2d5812ULL, 0x010fce00078efcffULL,
0x00000021007c7306ULL, 0x000ff00000009400ULL, 0x00000021007d7306ULL, 0x000ea20000005400ULL,
0x000000a09f00720bULL, 0x002fce0003f7d000ULL, 0x000000e2002c7306ULL, 0x000ff00000209400ULL,
0x000000e200877306ULL, 0x000e620000205400ULL, 0x0000007d7c00720bULL, 0x004fce0003f1d000ULL,
0x000000b400b27306ULL, 0x000ff00000209400ULL, 0x000000b400b37306ULL, 0x000ea20000205400ULL,
0x000000872c00720bULL, 0x002fce0003fbd000ULL, 0x0000009600207306ULL, 0x000ff00000209400ULL,
0x00000096002b7306ULL, 0x000e620000205400ULL, 0x000000b3b200720bULL, 0x004fce0003f5d000ULL,
0x0000002f001c7306ULL, 0x000eb0000000d400ULL, 0x00000021005a7306ULL, 0x000ee2000000d400ULL,
0x0000002b2000720bULL, 0x002fce0003f9d000ULL, 0x0000002200697306ULL, 0x000fe20000009400ULL,
0x000000011c1c3812ULL, 0x004fe400078efcffULL, 0x0000009d2e00720bULL, 0x000fe40003f7d000ULL,
0x0000001c6d6d723eULL, 0x000fc600000010ffULL, 0x00000022006c7306ULL, 0x000fe20000005400ULL,
0x000000015a5a0812ULL, 0x008fe400078efcffULL, 0x000000625d00720bULL, 0x000fca0003f1d000ULL,
0x0000002200367306ULL, 0x000fe2000000d400ULL, 0x0000000193933812ULL, 0x000fc800078efcffULL,
0x000000935c93723eULL, 0x000fc600000010ffULL, 0x0000002300657306ULL, 0x000fe20000009400ULL,
0x0000000137370812ULL, 0x000fce00078efcffULL, 0x0000002300687306ULL, 0x000e700000005400ULL,
0x0000002300357306ULL, 0x000eb0000000d400ULL, 0x000000e2002f7306ULL, 0x000ee2000020d400ULL,
0x000000686500720bULL, 0x002fce0003f7d000ULL, 0x000000b400b17306ULL, 0x000e6c000020d400ULL,
0x0000000135353812ULL, 0x004fe400078efcffULL, 0x0000009600217306ULL, 0x000ea2000020d400ULL,
0x000000012f2f5812ULL, 0x008fe400078efcffULL, 0x0000006c6900720bULL, 0x000fc40003fbd000ULL,
0x000000282d6c723eULL, 0x000fe400000010ffULL, 0x0000002f1692723eULL, 0x000fe200000010ffULL,
0x0000005800227306ULL, 0x000fe20000209400ULL, 0x00000001b1b12812ULL, 0x002fc600078efcffULL,
0x0000006c104c723cULL, 0x000fe2000004184cULL, 0x0000005ab1ab723eULL, 0x000fc600000010ffULL,
0x0000005800237306ULL, 0x000e620000205400ULL, 0x0000000121214812ULL, 0x004fe400078efcffULL,
0x0000000136365812ULL, 0x000fe200078efcffULL, 0x000000921048723cULL, 0x000fe20000041848ULL,
0x000000216060723eULL, 0x000fc600000010ffULL, 0x000000a2008e7306ULL, 0x000fe80000209400ULL,
0x000000aa1044723cULL, 0x000fe80000041844ULL, 0x000000a200157306ULL, 0x000ea20000205400ULL,
0x000000232200720bULL, 0x002fce0003f5d000ULL, 0x0000005800967306ULL, 0x000e70000020d400ULL,
0x000000a2007b7306ULL, 0x000ee2000020d400ULL, 0x000000158e00720bULL, 0x004fce0003f9d000ULL,
0x000000a5002c7306ULL, 0x000fe20000209400ULL, 0x0000000196962812ULL, 0x002fe400078efcffULL,
0x000000645b00720bULL, 0x000fe40003f5d000ULL, 0x000000963761723eULL, 0x000fc600000010ffULL,
0x000000a5006f7306ULL, 0x000e620000205400ULL, 0x000000017b7b4812ULL, 0x008fc600078efcffULL,
0x000000601040723cULL, 0x000fe20000041840ULL, 0x000000367b36723eULL, 0x000fc600000010ffULL,
0x000000a400147306ULL, 0x000fe20000209400ULL, 0x0000000134342812ULL, 0x000fce00078efcffULL,
0x000000a400197306ULL, 0x000ea20000205400ULL, 0x0000006f2c00720bULL, 0x002fce0003f1d000ULL,
0x000000a6000e7306ULL, 0x000ff00000209400ULL, 0x000000a6000f7306ULL, 0x000e620000205400ULL,
0x000000191400720bULL, 0x004fce0003f9d000ULL, 0x000000a5002e7306ULL, 0x000eb0000020d400ULL,
0x000000a400a47306ULL, 0x000ee2000020d400ULL, 0x0000000f0e00720bULL, 0x002fce0003fbd000ULL,
0x000000a600a57306ULL, 0x000e62000020d400ULL, 0x000000012e2e0812ULL, 0x004fc800078efcffULL,
0x000000352e37723eULL, 0x000fe400000010ffULL, 0x00000001a4a44812ULL, 0x008fc800078efcffULL,
0x000000a45fa4723eULL, 0x000fe200000010ffULL, 0x00000036103c723cULL, 0x000fe2000004183cULL,
0x00000001a5a55812ULL, 0x002fc800078efcffULL, 0x000000a534a5723eULL, 0x000fce00000010ffULL,
0x000000a41038723cULL, 0x000fe20000041838ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x00002000170e7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a00059ff7f8cULL, 0x0007e2000c80043fULL,
0x000000011e5d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff157224ULL, 0x004fe400078e000fULL,
0x0000030004047a10ULL, 0x00cfc80007ffe0ffULL, 0x000000050400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff4aa000007947ULL, 0x000fea000383ffffULL,
0x00000000000479c3ULL, 0x004ea40000002500ULL, 0x0000000405007c0cULL, 0x004fda000bf03070ULL,
0x0000039000000947ULL, 0x000fea0003800000ULL, 0x018000000d027810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e000dULL, 0x0000c33000087802ULL, 0x000fe40000000f00ULL,
0x0000a0b000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff047224ULL, 0x008fe200078e0002ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000d00047308ULL, 0x000ea40000001000ULL,
0xbf80000004027423ULL, 0x004fc8000000000dULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000304047223ULL, 0x000fe40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006700ff037624ULL, 0x000fe400078e00ffULL, 0x00006600ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000ea8000c1e9900ULL, 0x0000000000057919ULL, 0x000f280000000000ULL,
0x0000000000087919ULL, 0x000f620000000000ULL, 0x00000002ff077819ULL, 0x010fe40000011605ULL,
0x0000000808057811ULL, 0x020fe200078ff0ffULL, 0x0000000403067220ULL, 0x004fca0000410000ULL,
0x00001f0706047589ULL, 0x000ea800000e0000ULL, 0x00001f0506057589ULL, 0x000f2200000e0000ULL,
0x0000005404547220ULL, 0x044fe40000410000ULL, 0x0000005504557220ULL, 0x040fe40000410000ULL,
0x0000005004507220ULL, 0x040fe40000410000ULL, 0x0000005104517220ULL, 0x000fc40000410000ULL,
0x0000004c044c7220ULL, 0x040fe40000410000ULL, 0x0000004d044d7220ULL, 0x040fe40000410000ULL,
0x0000004804487220ULL, 0x040fe40000410000ULL, 0x0000004904497220ULL, 0x040fe40000410000ULL,
0x0000004404447220ULL, 0x040fe40000410000ULL, 0x0000004504457220ULL, 0x000fc40000410000ULL,
0x0000004004407220ULL, 0x040fe40000410000ULL, 0x0000004104417220ULL, 0x040fe40000410000ULL,
0x0000003c043c7220ULL, 0x040fe40000410000ULL, 0x0000003d043d7220ULL, 0x040fe40000410000ULL,
0x0000003804387220ULL, 0x040fe40000410000ULL, 0x0000003904397220ULL, 0x000fc40000410000ULL,
0x0000005605567220ULL, 0x050fe40000410000ULL, 0x0000005705577220ULL, 0x040fe40000410000ULL,
0x0000005205527220ULL, 0x040fe40000410000ULL, 0x0000005305537220ULL, 0x040fe40000410000ULL,
0x0000004e054e7220ULL, 0x040fe40000410000ULL, 0x0000004f054f7220ULL, 0x000fc40000410000ULL,
0x0000004a054a7220ULL, 0x040fe40000410000ULL, 0x0000004b054b7220ULL, 0x040fe40000410000ULL,
0x0000004605467220ULL, 0x040fe40000410000ULL, 0x0000004705477220ULL, 0x040fe40000410000ULL,
0x0000004205427220ULL, 0x040fe40000410000ULL, 0x0000004305437220ULL, 0x000fc40000410000ULL,
0x0000003e053e7220ULL, 0x040fe40000410000ULL, 0x0000003f053f7220ULL, 0x040fe40000410000ULL,
0x0000003a053a7220ULL, 0x040fe40000410000ULL, 0x0000003b053b7220ULL, 0x000fe40000410000ULL,
0x0000000000027919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000202037812ULL, 0x004fc400078ec0ffULL, 0x00000002ff137819ULL, 0x000fe40000011602ULL,
0x00000001ff047819ULL, 0x000fe40000011603ULL, 0x0000000403087811ULL, 0x040fe400078ff8ffULL,
0x00000008021b7811ULL, 0x000fe400078ff0ffULL, 0x0000000203057811ULL, 0x040fe400078ff8ffULL,
0x0000000603107811ULL, 0x000fc400078ff8ffULL, 0x0000000704037812ULL, 0x100fe400078e7813ULL,
0x00000007080e7812ULL, 0x048fe400078e7813ULL, 0x0000000708087812ULL, 0x000fe200078e781bULL,
0x0000000813077824ULL, 0x000fe200078e0203ULL, 0x0000000705067812ULL, 0x000fe200078e7813ULL,
0x000010000c037824ULL, 0x000fe200078e00ffULL, 0x0000000704047812ULL, 0x000fe200078e781bULL,
0x000000081b197824ULL, 0x000fe200078e0208ULL, 0x0000000710127812ULL, 0x000fe200078e7813ULL,
0x0000000802087824ULL, 0x000fe200078e00ffULL, 0x0000000705057812ULL, 0x100fe200078e781bULL,
0x000000081b157824ULL, 0x000fe200078e0204ULL, 0x0000000710107812ULL, 0x000fe200078e781bULL,
0x00000008130f7824ULL, 0x040fe200078e0206ULL, 0x0000000808087812ULL, 0x000fe200078ec0ffULL,
0x0000000813117824ULL, 0x000fe200078e020eULL, 0x000000505106723eULL, 0x000fe200000010ffULL,
0x000000081b177824ULL, 0x002fe200078e0205ULL, 0x000000545505723eULL, 0x000fe200000010ffULL,
0x0000080009047824ULL, 0x000fc400078e0203ULL, 0x0000000813137824ULL, 0x000fe200078e0212ULL,
0x00005410051c7816ULL, 0x000fe20000000006ULL, 0x000000081b1b7824ULL, 0x000fe200078e0210ULL,
0x00007632051d7816ULL, 0x000fe20000000006ULL, 0x0000001007077824ULL, 0x100fe200078e0204ULL,
0x000000444505723eULL, 0x000fe200000010ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0204ULL,
0x000000404106723eULL, 0x000fe200000010ffULL, 0x0000001011117824ULL, 0x100fe400078e0204ULL,
0x0000001015157824ULL, 0x000fc400078e0204ULL, 0x0000001017177824ULL, 0x100fe400078e0204ULL,
0x0000001013137824ULL, 0x100fe400078e0204ULL, 0x0000001019197824ULL, 0x100fe400078e0204ULL,
0x000000101b1b7824ULL, 0x000fe400078e0204ULL, 0x00000001070e7824ULL, 0x000fe200078e0208ULL,
0x0000004c4d07723eULL, 0x000fe200000010ffULL, 0x00000001080f7824ULL, 0x000fc400078e020fULL,
0x0000000108117824ULL, 0x040fe200078e0211ULL, 0x0000001c0e007388ULL, 0x0003e20000000a00ULL,
0x0000000108157824ULL, 0x040fe400078e0215ULL, 0x0000000108177824ULL, 0x040fe400078e0217ULL,
0x0000000108137824ULL, 0x040fe400078e0213ULL, 0x0000000108197824ULL, 0x040fe400078e0219ULL,
0x00000001081b7824ULL, 0x000fe200078e021bULL, 0x000000484908723eULL, 0x000fe200000010ffULL,
0x0000002009107824ULL, 0x000fe200078e0202ULL, 0x00005410050e7816ULL, 0x002fc40000000006ULL,
0x00005410071c7816ULL, 0x140fe40000000008ULL, 0x00007632071d7816ULL, 0x000fe40000000008ULL,
0x0000003c3d07723eULL, 0x000fe400000010ffULL, 0x000000383908723eULL, 0x000fe200000010ffULL,
0x0000001c0f007388ULL, 0x0003e40000000a00ULL, 0x00007632050f7816ULL, 0x002fe40000000006ULL,
0x000000565705723eULL, 0x000fc400000010ffULL, 0x000000525306723eULL, 0x000fe200000010ffULL,
0x0000000e11007388ULL, 0x0003e40000000a00ULL, 0x00005410070e7816ULL, 0x142fe20000000008ULL,
0x0000001010117824ULL, 0x000fe200078e0203ULL, 0x00007632070f7816ULL, 0x000fe40000000008ULL,
0x0000004e4f07723eULL, 0x000fe400000010ffULL, 0x0000004a4b08723eULL, 0x000fe200000010ffULL,
0x0000000e13007388ULL, 0x0003e40000000a00ULL, 0x00005410050e7816ULL, 0x002fc40000000006ULL,
0x00007632050f7816ULL, 0x000fe40000000006ULL, 0x000000464705723eULL, 0x000fe400000010ffULL,
0x000000424306723eULL, 0x000fe200000010ffULL, 0x0000000e15007388ULL, 0x0003e40000000a00ULL,
0x00005410070e7816ULL, 0x142fe40000000008ULL, 0x00007632070f7816ULL, 0x000fe40000000008ULL,
0x0000003e3f07723eULL, 0x000fc400000010ffULL, 0x0000003a3b08723eULL, 0x000fe200000010ffULL,
0x0000000e17007388ULL, 0x0003e40000000a00ULL, 0x00005410050e7816ULL, 0x142fe40000000006ULL,
0x00007632050f7816ULL, 0x000fe40000000006ULL, 0x000000ff00067306ULL, 0x000fe60000205400ULL,
0x0000000e19007388ULL, 0x0003ea0000000a00ULL, 0x000000ff00057306ULL, 0x000fe2000020d400ULL,
0x00005410070e7816ULL, 0x002fc40000000008ULL, 0x00007632070f7816ULL, 0x000fca0000000008ULL,
0x000000ff00077306ULL, 0x000e620000209400ULL, 0x0000000e1b007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000060700720bULL, 0x002fda0003f1d000ULL,
0x0000000105050812ULL, 0x000fe200078efcffULL, 0x0000000011147984ULL, 0x000e660000000c00ULL,
0x000000050506723eULL, 0x000fe200000010ffULL, 0x00080000111c7984ULL, 0x000ea80000000c00ULL,
0x0004000011207984ULL, 0x000ee80000000c00ULL, 0x000c000011247984ULL, 0x000f220000000c00ULL,
0x3f803f8006157831ULL, 0x002fc40000200015ULL, 0x3f803f8006177831ULL, 0x040fe40000200017ULL,
0x3f803f8015157831ULL, 0x004fe2000020001dULL, 0x00000300ff1d7624ULL, 0x000fe200078e00ffULL,
0x3f803f8006167831ULL, 0x040fe40000200016ULL, 0x3f803f8006147831ULL, 0x040fe40000200014ULL,
0x000000011d00780cULL, 0x000fe20003f05270ULL, 0x3f803f8006237831ULL, 0x048fe40000200023ULL,
0x3f803f8006227831ULL, 0x000fc40000200022ULL, 0x3f803f8006217831ULL, 0x040fe40000200021ULL,
0x3f803f8006207831ULL, 0x000fe40000200020ULL, 0x3f803f8017177831ULL, 0x000fe4000020001fULL,
0x3f803f8016167831ULL, 0x000fe4000020001eULL, 0x3f803f8014147831ULL, 0x000fe4000020001cULL,
0x3f803f8023237831ULL, 0x010fc40000200027ULL, 0x3f803f8022227831ULL, 0x000fe20000200026ULL,
0x0000001411007388ULL, 0x0003e20000000c00ULL, 0x3f803f8021217831ULL, 0x000fe40000200025ULL,
0x3f803f8020207831ULL, 0x000fca0000200024ULL, 0x0004002011007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00002f6000008947ULL, 0x000fea0003800000ULL,
0x0000000000167919ULL, 0x002e620000002700ULL, 0x000058001d067a24ULL, 0x000fe200078e02ffULL,
0x0000000109ff7812ULL, 0x000fe2000780f800ULL, 0x00000800ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000000077919ULL, 0x000e620000002600ULL, 0x0000640006127a24ULL, 0x000fe200078e02ffULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000004000c087824ULL, 0x000fe200078e00ffULL,
0x0000000011187984ULL, 0x0004e20000000c00ULL, 0x000000ff0200720cULL, 0x000fe20000725670ULL,
0x0000580016167a24ULL, 0x002fe200078e0207ULL, 0x000007ff12077811ULL, 0x000fc600078e40ffULL,
0x0000030016067a24ULL, 0x000fca00078e02ffULL, 0x0000000406137c10ULL, 0x000fc8000fffe0ffULL,
0x00000013070e7211ULL, 0x000fca00078fa8ffULL, 0x00006a000e0e7625ULL, 0x000fca00078e000fULL,
0x000000080e147210ULL, 0x000fe40007f5e0ffULL, 0x01ffffff120e7812ULL, 0x000fc600078ec0ffULL,
0x000000ffff157224ULL, 0x000fc800010e060fULL, 0x0000001010147825ULL, 0x000fe200078e0014ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x0000001002107824ULL, 0x00cfe200078e00ffULL,
0x00000001ff117819ULL, 0x000fe20000011602ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000000113127824ULL, 0x000fe200078e020eULL, 0x0000007010177812ULL, 0x000fe400078ec0ffULL,
0x0000000c111c7812ULL, 0x000fe200078ec0ffULL, 0x00006a0013107625ULL, 0x000fc800078e000fULL,
0x00006a0012127625ULL, 0x000fe200078e000fULL, 0x000000101c107210ULL, 0x000fc80007a1e017ULL,
0x000000121c127210ULL, 0x000fe40007c7e017ULL, 0x00000011ff117210ULL, 0x000fe400007e44ffULL,
0x00000013ff137210ULL, 0x000fc60001fe84ffULL, 0x0000000b10007986ULL, 0x0003e8000c101906ULL,
0x0000000d12007986ULL, 0x0003e4000c101906ULL, 0x0000000000007941ULL, 0x00cfea0003800000ULL,
0x0000001814007986ULL, 0x0005e2000c101d06ULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff117424ULL, 0x002fe200078e00ffULL, 0xffffffff1d0b7810ULL, 0x000fc60007ffe0ffULL,
0x0000680016107625ULL, 0x000fe200078e0011ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000b101079a8ULL, 0x000ee400099ee1c6ULL,
0x0000000b1000720cULL, 0x008fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0d7807ULL, 0x000fca0000000000ULL, 0x0000000dff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff0b7984ULL, 0x002e640000000000ULL, 0x000000ff0b00720cULL, 0x002fda0003f05270ULL,
0x00002bb000008947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff107819ULL, 0x000fe20000011602ULL,
0x00000010020b7824ULL, 0x000fe200078e00ffULL, 0x0000000106127810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000c10157812ULL, 0x004fe400078ec0ffULL,
0x000000700b0f7812ULL, 0x000fe200078ec0ffULL, 0x00006a0006107625ULL, 0x000fc800078e000dULL,
0x00006a0012127625ULL, 0x000fe200078e000dULL, 0x0000001015107210ULL, 0x000fc8000791e00fULL,
0x0000001215127210ULL, 0x000fe40007b5e00fULL, 0x00000011ff117210ULL, 0x000fe400007e24ffULL,
0x00000013ff137210ULL, 0x000fc600017e64ffULL, 0x00000006100b7981ULL, 0x000368000c1e1900ULL,
0x0000000612147981ULL, 0x000362000c1e1900ULL, 0x000000021d00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000206107810ULL, 0x002fca0007ffe0ffULL,
0x00006a0010107625ULL, 0x000fca00078e000dULL, 0x0000001015107210ULL, 0x000fc8000791e00fULL,
0x00000011ff117210ULL, 0x000fca00007e24ffULL, 0x0000000610167981ULL, 0x000362000c1e1900ULL,
0x000000041d00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000306107810ULL, 0x002fca0007ffe0ffULL, 0x00006a0010107625ULL, 0x000fca00078e000dULL,
0x0000001015107210ULL, 0x000fc8000791e00fULL, 0x00000011ff117210ULL, 0x000fca00007e24ffULL,
0x0000000610187981ULL, 0x000362000c1e1900ULL, 0x000000041d00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000406107810ULL, 0x002fca0007ffe0ffULL,
0x00006a0010107625ULL, 0x000fca00078e000dULL, 0x0000001015107210ULL, 0x000fc8000791e00fULL,
0x00000011ff117210ULL, 0x000fca00007e24ffULL, 0x00000006101a7981ULL, 0x000362000c1e1900ULL,
0x000000061d00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000506107810ULL, 0x002fca0007ffe0ffULL, 0x00006a0010107625ULL, 0x000fca00078e000dULL,
0x0000001015107210ULL, 0x000fc8000791e00fULL, 0x00000011ff117210ULL, 0x000fca00007e24ffULL,
0x00000006101c7981ULL, 0x000362000c1e1900ULL, 0x000000061d00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081d00780cULL, 0x002fe40003f06070ULL,
0x0000000606107810ULL, 0x000fca0007ffe0ffULL, 0x00006a0010107625ULL, 0x000fca00078e000dULL,
0x0000001015107210ULL, 0x000fe40007a3e00fULL, 0x0000000706120810ULL, 0x000fe40007ffe0ffULL,
0x00000011ff117210ULL, 0x000fc60000fe44ffULL, 0x00006a0012120625ULL, 0x000fe400078e000dULL,
0x00000006101e7981ULL, 0x000366000c1e1900ULL, 0x0000001215120210ULL, 0x000fc80007c7e00fULL,
0x00000013ff130210ULL, 0x000fca0001fe84ffULL, 0x0000000612200981ULL, 0x000368000c1e1900ULL,
0x000000071d0d7810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0d7819ULL, 0x000fc8000001160dULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff127224ULL, 0x000fe400078e00ffULL, 0x000000ffff227224ULL, 0x020fe400078e000bULL,
0x00000008120f7824ULL, 0x040fe200078e00ffULL, 0x0000000112127810ULL, 0x000fc80007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x0000000d1200720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080f117810ULL, 0x040fe40007ffe0ffULL,
0x000000010f107810ULL, 0x000fe40007ffe0ffULL, 0x0000030011007a0cULL, 0x000fe40003f26070ULL,
0x0000030010007a0cULL, 0x000fe40003f46070ULL, 0x000000220b0b7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000106107824ULL, 0x000fe200078e0211ULL,
0x00000001ff157819ULL, 0x004fe20000011602ULL, 0x00000080ff117424ULL, 0x000fe400078e00ffULL,
0x0000001002137824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006a0010107625ULL, 0x000fc600078e0011ULL, 0x0000007013137812ULL, 0x000fc800078ec0ffULL,
0x0000001015107210ULL, 0x000fc80007b3e013ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000610227981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090f117810ULL, 0x042fe40007ffe0ffULL, 0x000000020f107810ULL, 0x000fe40007ffe0ffULL,
0x0000030011007a0cULL, 0x000fe40003f26070ULL, 0x0000030010007a0cULL, 0x000fe40003f46070ULL,
0x000000140b0b7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000106107824ULL, 0x000fe200078e0211ULL, 0x00000001ff147819ULL, 0x004fe20000011602ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x0000001002137824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006a0010107625ULL, 0x000fc600078e0011ULL,
0x0000007013137812ULL, 0x000fc800078ec0ffULL, 0x0000001014107210ULL, 0x000fc80007b3e013ULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x0000000610147981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0f117810ULL, 0x042fe40007ffe0ffULL,
0x000000030f107810ULL, 0x000fe40007ffe0ffULL, 0x0000030011007a0cULL, 0x000fe40003f26070ULL,
0x0000030010007a0cULL, 0x000fe40003f46070ULL, 0x000000160b0b7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000106107824ULL, 0x000fe200078e0211ULL,
0x00000001ff157819ULL, 0x004fe20000011602ULL, 0x00000080ff117424ULL, 0x000fe400078e00ffULL,
0x0000001002137824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006a0010107625ULL, 0x000fc600078e0011ULL, 0x0000007013137812ULL, 0x000fc800078ec0ffULL,
0x0000001015107210ULL, 0x000fc80007b3e013ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000610167981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0f117810ULL, 0x042fe40007ffe0ffULL, 0x000000040f107810ULL, 0x000fe40007ffe0ffULL,
0x0000030011007a0cULL, 0x000fe40003f26070ULL, 0x0000030010007a0cULL, 0x000fe40003f46070ULL,
0x000000180b0b7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000106107824ULL, 0x000fe200078e0211ULL, 0x00000001ff157819ULL, 0x004fe20000011602ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x0000001002137824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006a0010107625ULL, 0x000fc600078e0011ULL,
0x0000007013137812ULL, 0x000fc800078ec0ffULL, 0x0000001015107210ULL, 0x000fc80007b3e013ULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x0000000610187981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0f117810ULL, 0x042fe40007ffe0ffULL,
0x000000050f107810ULL, 0x000fe40007ffe0ffULL, 0x0000030011007a0cULL, 0x000fe40003f26070ULL,
0x0000030010007a0cULL, 0x000fe40003f46070ULL, 0x0000001a0b0b7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000106107824ULL, 0x000fe200078e0211ULL,
0x00000001ff157819ULL, 0x004fe20000011602ULL, 0x00000080ff117424ULL, 0x000fe400078e00ffULL,
0x0000001002137824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006a0010107625ULL, 0x000fc600078e0011ULL, 0x0000007013137812ULL, 0x000fc800078ec0ffULL,
0x0000001015107210ULL, 0x000fc80007b3e013ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x00000006101a7981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0f117810ULL, 0x042fe40007ffe0ffULL, 0x000000060f107810ULL, 0x000fe40007ffe0ffULL,
0x0000030011007a0cULL, 0x000fe40003f26070ULL, 0x0000030010007a0cULL, 0x000fe40003f46070ULL,
0x0000001c0b0b7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000106107824ULL, 0x000fe200078e0211ULL, 0x00000001ff157819ULL, 0x004fe20000011602ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x0000001002137824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006a0010107625ULL, 0x000fc600078e0011ULL,
0x0000007013137812ULL, 0x000fc800078ec0ffULL, 0x0000001015107210ULL, 0x000fc80007b3e013ULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x00000006101c7981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0f117810ULL, 0x042fe40007ffe0ffULL,
0x000000070f107810ULL, 0x000fe40007ffe0ffULL, 0x0000030011007a0cULL, 0x000fe40003f26070ULL,
0x0000030010007a0cULL, 0x000fe40003f46070ULL, 0x0000001e0b0b7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000106107824ULL, 0x000fe200078e0211ULL,
0x00000001ff157819ULL, 0x004fe20000011602ULL, 0x00000080ff117424ULL, 0x000fe400078e00ffULL,
0x0000001002137824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006a0010107625ULL, 0x000fc600078e0011ULL, 0x0000007013137812ULL, 0x000fc800078ec0ffULL,
0x0000001015107210ULL, 0x000fc80007b3e013ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x00000006101e7981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0f0f7810ULL, 0x000fe40007ffe0ffULL, 0x000000200b0b7209ULL, 0x000fe40007810000ULL,
0x000003000f007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000106107824ULL, 0x002fe200078e020fULL, 0x00000001ff137819ULL, 0x000fe20000011602ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x00000010020f7824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006a0010107625ULL, 0x000fc600078e0011ULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000001013107210ULL, 0x000fc80007a3e00fULL,
0x00000011ff117210ULL, 0x000fca0000fe44ffULL, 0x0000000610207981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000ee40000000000ULL,
0x00000010020d7824ULL, 0x008fe200078e00ffULL, 0x00000001ff0f7819ULL, 0x000fc80000011602ULL,
0x000000700d0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0f107812ULL, 0x002fca00078ec0ffULL,
0x0000000110107824ULL, 0x000fca00078e020dULL, 0x0000000b10007388ULL, 0x0203e40000000800ULL,
0x000000070200780cULL, 0x040fe20003f04070ULL, 0x00000010020b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011602ULL, 0x0000000109167824ULL, 0x000fe200078e0206ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000800ff117424ULL, 0x000fe200078e00ffULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000010a347824ULL, 0x000fe200078e0203ULL,
0x0000000c0d127812ULL, 0x000fe200078ec0ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000001607107211ULL, 0x000fe200078fa8ffULL, 0x0000110000007945ULL, 0x000fe20003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011600ULL, 0x00000001122b7824ULL, 0x000fe200078e020bULL,
0x0000002002137810ULL, 0x000fe20007ffe0ffULL, 0x00006a0010107625ULL, 0x000fe200078e0011ULL,
0x000000010d0b7812ULL, 0x000fe200078ec0ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000209128824ULL, 0x140fe200078e020cULL,
0x0000000810107210ULL, 0x000fe20007f3e0ffULL, 0x0000000209148824ULL, 0x004fe200078e020cULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000020000007824ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000212158824ULL, 0x100fe200078e020bULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000002141b8824ULL, 0x000fe200078e020bULL,
0x00000800000b7812ULL, 0x000fe200078ec0ffULL, 0x000000010e0a8824ULL, 0x000fe200078e0216ULL,
0x000000002b2b7984ULL, 0x000e620000000800ULL, 0x00000080ff0f8424ULL, 0x000fc400078e00ffULL,
0x00000080ff178424ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000030009007a0cULL, 0x000fe20003f26070ULL, 0x00000001340d7824ULL, 0x000fe400078e020bULL,
0x00006a000a0a8625ULL, 0x000fc800078e000fULL, 0x00006a0016168625ULL, 0x000fc800078e0017ULL,
0x0000000815198824ULL, 0x100fe400078e0202ULL, 0x000000081b1b8824ULL, 0x000fe400078e0202ULL,
0x0000001013127825ULL, 0x000fe200078e0010ULL, 0x0000458019198811ULL, 0x000fe400078e20ffULL,
0x000041801b218811ULL, 0x000fe200078e20ffULL, 0x00000010020f7824ULL, 0x040fe200078e020dULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000001002107825ULL, 0x000fc800078e0010ULL,
0x0000001002148825ULL, 0x040fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000100f7faeULL, 0x0005e2000b901c46ULL, 0x00000000000a7805ULL, 0x000fe4000001ff00ULL,
0x0000001002168825ULL, 0x000fe200078e0016ULL, 0x00380000120f7faeULL, 0x0007e6000b901c46ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x0000000014198faeULL, 0x0009e2000b901c46ULL,
0x000000ffff0d7224ULL, 0x000fc400078e00ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x0000000016218faeULL, 0x000be2000b901c46ULL, 0x0000000000107805ULL, 0x004fe2000001ff00ULL,
0x000000ffff357224ULL, 0x000fe400078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff0f7224ULL, 0x008fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x010fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x020fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000d6000001947ULL, 0x000fea0003800000ULL, 0x000000ffff007224ULL, 0x002fe400078e00ffULL,
0x000000ffff367224ULL, 0x000fca00078e0009ULL, 0x0000000236377810ULL, 0x000fe20007ffe0ffULL,
0x0000029000017945ULL, 0x000fe60003800000ULL, 0x0000030037007a0cULL, 0x000fda0003f06070ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x000000070200780cULL, 0x000fe20003f24070ULL,
0x0000000106327824ULL, 0x100fe200078e0237ULL, 0x00000001ff2c7819ULL, 0x000fe20000011637ULL,
0x00000800ff387424ULL, 0x000fe200078e00ffULL, 0x00000020023d7810ULL, 0x000fe20007ffe0ffULL,
0x00000400372e7824ULL, 0x000fe200078e00ffULL, 0x00000032072d7211ULL, 0x000fe400078fa8ffULL,
0x000000012c307812ULL, 0x000fc600078ec0ffULL, 0x00006a002d2c7625ULL, 0x000fc800078e0038ULL,
0x0000000209319824ULL, 0x000fe200078e020cULL, 0x000000082c2c7210ULL, 0x000fe20007f1e0ffULL,
0x000000010e2f9824ULL, 0x000fe400078e0232ULL, 0x00000002313f9824ULL, 0x000fe200078e0230ULL,
0x000008002e317812ULL, 0x000fe200078ec0ffULL, 0x00000080ff389424ULL, 0x000fe400078e00ffULL,
0x00000002093b9824ULL, 0x000fe400078e020cULL, 0x00006a002f2e9625ULL, 0x000fc800078e0038ULL,
0x000000023b3b9824ULL, 0x000fe400078e0230ULL, 0x00000080ff339424ULL, 0x000fe400078e00ffULL,
0x0000000134317824ULL, 0x000fe400078e0231ULL, 0x000000ffff2d7224ULL, 0x000fe400000e062dULL,
0x00006a0032329625ULL, 0x000fc800078e0033ULL, 0x0000001002397824ULL, 0x040fe400078e0231ULL,
0x000000083b3b9824ULL, 0x000fe400078e0202ULL, 0x0000001002309825ULL, 0x000fc600078e002eULL,
0x000045803b3b9811ULL, 0x000fe200078e20ffULL, 0x000000083f3f9824ULL, 0x000fe400078e0202ULL,
0x000000103d2e7825ULL, 0x000fc600078e002cULL, 0x000041803f3d9811ULL, 0x000fe200078e20ffULL,
0x00000010022c7825ULL, 0x000fc800078e002cULL, 0x0000001002329825ULL, 0x000fe200078e0032ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800002c397faeULL, 0x0003e8000b901c46ULL,
0x003800002e397faeULL, 0x0003e8000b901c46ULL, 0x00000000303b9faeULL, 0x0003e8000b901c46ULL,
0x00000000323d9faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff2f7224ULL, 0x002fe200078e0036ULL,
0x00000001ff2e7819ULL, 0x000fe20000011602ULL, 0x0000000209317824ULL, 0x000fe200078e020cULL,
0x00000002ff397819ULL, 0x000fe20000011602ULL, 0x000000402f2c7824ULL, 0x000fe200078e00ffULL,
0x0000000c2e2e7812ULL, 0x000fe200078ec0ffULL, 0x00000010022d7824ULL, 0x000fe200078e00ffULL,
0x0000000739407812ULL, 0x040fe200078ec0ffULL, 0x0000000839337824ULL, 0x000fe200078e00ffULL,
0x000000802c2c7812ULL, 0x000fc400078ec0ffULL, 0x000000702d2d7812ULL, 0x000fe400078ec0ffULL,
0x00000039ff3e7212ULL, 0x000fe200078e33ffULL, 0x00000100312c7824ULL, 0x000fe200078e002cULL,
0x00000008393b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000839317824ULL, 0x000fe200078e00ffULL,
0xfffffff8333e7812ULL, 0x000fe400078ee23eULL, 0x0000002c2e2e7210ULL, 0x000fe20007ffe02dULL,
0x00000008392d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8312c7812ULL, 0x000fe200078ee240ULL,
0x000000083b317824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180002e3c7984ULL, 0x000e620000000800ULL, 0x000000012d307812ULL, 0x100fe200078ef640ULL,
0x000000083b427824ULL, 0x000fe200078e00ffULL, 0x000000022d327812ULL, 0x140fe200078ef640ULL,
0x004580002e4e7984ULL, 0x0002a20000000800ULL, 0x000000032d367812ULL, 0x140fe400078ef640ULL,
0x000000042d387812ULL, 0x140fe400078ef640ULL, 0x000000052d3a7812ULL, 0x000fe400078ef640ULL,
0x0000003bff4c7212ULL, 0x000fc800078e33ffULL, 0xfffffff8314c7812ULL, 0x000fe400078ee24cULL,
0x000000073b317812ULL, 0x000fe200078ec0ffULL, 0x0000003c2b2e7221ULL, 0x002fe20000010100ULL,
0x000000062d3c7812ULL, 0x000fe200078ef640ULL, 0x000004002f2d7824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b2e337820ULL, 0x000fe40000410000ULL, 0x00000004022e7824ULL, 0x000fe200078e00ffULL,
0x000008002d2d7812ULL, 0x000fe200078ec0ffULL, 0x000000083b407824ULL, 0x000fc400078e00ffULL,
0x0000003300337308ULL, 0x000ea20000000800ULL, 0x00000180342d7810ULL, 0x000fe40007ffe02dULL,
0x0000000c2e2f7812ULL, 0x000fe400078ec0ffULL, 0xfffffff8422e7812ULL, 0x000fe200078ee231ULL,
0x000000102c2c7824ULL, 0x000fe200078e022dULL, 0x0000000140427812ULL, 0x000fe200078ef631ULL,
0x000000103e3e7824ULL, 0x000fe200078e022dULL, 0x0000000240447812ULL, 0x000fe200078ef631ULL,
0x000000012c2c7824ULL, 0x000fe200078e022fULL, 0x0000000340467812ULL, 0x140fe200078ef631ULL,
0x000000012f3e7824ULL, 0x040fe200078e023eULL, 0x0000000440487812ULL, 0x000fe200078ef631ULL,
0x0000001030307824ULL, 0x000fe200078e022dULL, 0x00000005404a7812ULL, 0x000fe200078ef631ULL,
0x0000001032327824ULL, 0x000fe200078e022dULL, 0x0000000640407812ULL, 0x000fe200078ef631ULL,
0x000000003e3e7984ULL, 0x000fe20000000800ULL, 0x000000012f307824ULL, 0x000fc400078e0230ULL,
0x000000012f327824ULL, 0x000fe200078e0232ULL, 0x000000002c317984ULL, 0x000e620000000800ULL,
0x0000001036367824ULL, 0x100fe400078e022dULL, 0x0000004e334e7220ULL, 0x004fe20000410000ULL,
0x0000000030307984ULL, 0x000fe20000000800ULL, 0x000000012f367824ULL, 0x000fe400078e0236ULL,
0x0000001038387824ULL, 0x100fe200078e022dULL, 0x0000000032327984ULL, 0x000fe20000000800ULL,
0x000000103a3a7824ULL, 0x000fc400078e022dULL, 0x000000012f387824ULL, 0x040fe200078e0238ULL,
0x00001f394e2c7589ULL, 0x000ea200000e0000ULL, 0x000000012f3a7824ULL, 0x000fe400078e023aULL,
0x000000103c3c7824ULL, 0x100fe200078e022dULL, 0x0000000036367984ULL, 0x000ee20000000800ULL,
0x000000102e2e7824ULL, 0x100fe400078e022dULL, 0x0000001042427824ULL, 0x100fe200078e022dULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x0000001044447824ULL, 0x000fc400078e022dULL,
0x0000001046467824ULL, 0x100fe200078e022dULL, 0x000000003a3a7984ULL, 0x000f620000000800ULL,
0x0000001048487824ULL, 0x100fe400078e022dULL, 0x000000104a4a7824ULL, 0x100fe400078e022dULL,
0x0000001040407824ULL, 0x100fe400078e022dULL, 0x000000104c4c7824ULL, 0x000fe400078e022dULL,
0x000000012f3c7824ULL, 0x040fe200078e023cULL, 0x00001f3b4e2d7589ULL, 0x000fe200000e0000ULL,
0x000000012f2e7824ULL, 0x000fc400078e022eULL, 0x000000012f427824ULL, 0x040fe400078e0242ULL,
0x000000012f447824ULL, 0x040fe200078e0244ULL, 0x000000003c3c7984ULL, 0x000f220000000800ULL,
0x000000012f467824ULL, 0x040fe400078e0246ULL, 0x000000012f487824ULL, 0x040fe200078e0248ULL,
0x000000002e2e7984ULL, 0x000f620000000800ULL, 0x000000012f4a7824ULL, 0x040fe400078e024aULL,
0x000000012f407824ULL, 0x040fe200078e0240ULL, 0x0000000042427984ULL, 0x000f620000000800ULL,
0x000000012f4c7824ULL, 0x000fe200078e024cULL, 0x00005410ff2f7816ULL, 0x002fe20000000031ULL,
0x000000354e357221ULL, 0x000fe20000010000ULL, 0x0000000044447984ULL, 0x000e620000000800ULL,
0x00007610ff317816ULL, 0x000fc40000000031ULL, 0x0000002c2f2a7223ULL, 0x084fe2000001002aULL,
0x00005410ff2f7816ULL, 0x100fe2000000003eULL, 0x0000000046467984ULL, 0x000ea20000000800ULL,
0x00007610ff3e7816ULL, 0x000fe2000000003eULL, 0x0000002c31297223ULL, 0x080fe40000010029ULL,
0x0000002c2f1c7223ULL, 0x080fe2000001001cULL, 0x00005410ff2f7816ULL, 0x100fe20000000030ULL,
0x0000000048487984ULL, 0x000e620000000800ULL, 0x00007610ff307816ULL, 0x000fe20000000030ULL,
0x0000002c3e1b7223ULL, 0x000fc4000001001bULL, 0x0000002c2f287223ULL, 0x080fe20000010028ULL,
0x00005410ff2f7816ULL, 0x100fe20000000032ULL, 0x000000004a4a7984ULL, 0x000e620000000800ULL,
0x00007610ff327816ULL, 0x000fe20000000032ULL, 0x0000002c30277223ULL, 0x080fe40000010027ULL,
0x0000002c2f267223ULL, 0x080fe20000010026ULL, 0x00005410ff2f7816ULL, 0x108fe20000000036ULL,
0x0000000040407984ULL, 0x000ee20000000800ULL, 0x00007610ff367816ULL, 0x000fe20000000036ULL,
0x0000002c32257223ULL, 0x000fc40000010025ULL, 0x0000002c2f247223ULL, 0x080fe20000010024ULL,
0x00005410ff2f7816ULL, 0x110fe20000000038ULL, 0x0000002c36237223ULL, 0x080fe20000010023ULL,
0x00007610ff387816ULL, 0x000fe20000000038ULL, 0x000000004c4c7984ULL, 0x000f220000000800ULL,
0x000000ffff367224ULL, 0x000fe400078e0037ULL, 0x0000002c2f227223ULL, 0x080fe20000010022ULL,
0x00005410ff2f7816ULL, 0x120fe2000000003aULL, 0x0000002c38217223ULL, 0x000fe20000010021ULL,
0x00007610ff3a7816ULL, 0x000fc4000000003aULL, 0x0000030036007a0cULL, 0x000fe20003f06070ULL,
0x0000002c2f207223ULL, 0x080fe20000010020ULL, 0x00005410ff2f7816ULL, 0x100fe2000000003cULL,
0x0000002c3a1f7223ULL, 0x000fe2000001001fULL, 0x00007610ff3c7816ULL, 0x000fc6000000003cULL,
0x0000002c2f1e7223ULL, 0x080fe4000001001eULL, 0x0000002c3c1d7223ULL, 0x000fe2000001001dULL,
0x00005410ff2c7816ULL, 0x100fe4000000002eULL, 0x00007610ff2e7816ULL, 0x000fc6000000002eULL,
0x0000002d2c1a7223ULL, 0x080fe2000001001aULL, 0x00005410ff2c7816ULL, 0x100fe20000000042ULL,
0x0000002d2e197223ULL, 0x000fe20000010019ULL, 0x00007610ff427816ULL, 0x000fc60000000042ULL,
0x0000002d2c187223ULL, 0x080fe20000010018ULL, 0x00005410ff2c7816ULL, 0x102fe20000000044ULL,
0x0000002d42177223ULL, 0x000fe20000010017ULL, 0x00007610ff447816ULL, 0x000fc60000000044ULL,
0x0000002d2c167223ULL, 0x080fe20000010016ULL, 0x00005410ff2c7816ULL, 0x104fe20000000046ULL,
0x0000002d44157223ULL, 0x000fe20000010015ULL, 0x00007610ff467816ULL, 0x000fc60000000046ULL,
0x0000002d2c147223ULL, 0x080fe20000010014ULL, 0x00005410ff2c7816ULL, 0x100fe20000000048ULL,
0x0000002d46137223ULL, 0x000fe20000010013ULL, 0x00007610ff487816ULL, 0x000fc60000000048ULL,
0x0000002d2c127223ULL, 0x080fe20000010012ULL, 0x00005410ff2c7816ULL, 0x100fe2000000004aULL,
0x0000002d48117223ULL, 0x000fe20000010011ULL, 0x00007610ff4a7816ULL, 0x000fc6000000004aULL,
0x0000002d2c107223ULL, 0x080fe20000010010ULL, 0x00005410ff2c7816ULL, 0x108fe20000000040ULL,
0x0000002d4a0f7223ULL, 0x000fe2000001000fULL, 0x00007610ff407816ULL, 0x000fc60000000040ULL,
0x0000002d2c0d7223ULL, 0x080fe2000001000dULL, 0x00005410ff2c7816ULL, 0x110fe2000000004cULL,
0x0000002d400b7223ULL, 0x000fe2000001000bULL, 0x00007610ff4c7816ULL, 0x000fc6000000004cULL,
0x0000002d2c0a7223ULL, 0x080fe4000001000aULL, 0x0000002d4c007223ULL, 0x000fe20000010000ULL,
0xfffff2c000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x000000ff0c00720cULL, 0x000fe20003f05270ULL,
0x0000001002067824ULL, 0x002fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c02077812ULL, 0x000fca00078ec0ffULL,
0x0000000107087824ULL, 0x000fe200078e0206ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e640000000000ULL, 0x0000001002067824ULL, 0x002fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011602ULL, 0x0000007006027812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fc600078ec0ffULL, 0x0000008009027824ULL, 0x000fc800078e0202ULL,
0x0000000107027824ULL, 0x000fca00078e0202ULL, 0x0049803502007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800008027984ULL, 0x002e680000000800ULL, 0x004a000008077984ULL, 0x000ea20000000800ULL,
0x00000002ff027221ULL, 0x002fc80000010000ULL, 0x0000000702027221ULL, 0x004fca0000010000ULL,
0x0180000002067810ULL, 0x000fc80007ffe0ffULL, 0x7f80000006067812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0600780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e0002ULL,
0x0000f24000087802ULL, 0x000fe40000000f00ULL, 0x000071a000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x008fe200078e0002ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000200077308ULL, 0x000e640000001000ULL, 0xbf80000002067423ULL, 0x002fc80000000007ULL,
0x800000ff06067221ULL, 0x000fc80000010100ULL, 0x0000000607067223ULL, 0x000fe40000000007ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e680000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000008023f7811ULL, 0x002fe400078ff0ffULL,
0x00000002ff317819ULL, 0x000fe40000011602ULL, 0x0000003fff417212ULL, 0x000fe200078e33ffULL,
0x00001f3f06087589ULL, 0x000e6200000e0000ULL, 0x00000031ff0e7212ULL, 0x000fe200078e33ffULL,
0x0000000831437824ULL, 0x000fc400078e00ffULL, 0x00001f3106077589ULL, 0x0002a200000e0000ULL,
0x000000083f2c7824ULL, 0x000fe400078e00ffULL, 0xfffffff843437812ULL, 0x000fc600078ee20eULL,
0xfffffff82c417812ULL, 0x000fca00078ee241ULL, 0x0000001041417824ULL, 0x000fe400078e0204ULL,
0x0000000b08067220ULL, 0x042fe40000410000ULL, 0x0000001a081a7220ULL, 0x040fe40000410000ULL,
0x0000001908197220ULL, 0x040fe40000410000ULL, 0x0000001808187220ULL, 0x040fe40000410000ULL,
0x0000001708177220ULL, 0x040fe20000410000ULL, 0x0000001a1919723eULL, 0x000fe200000010ffULL,
0x0000001608167220ULL, 0x000fc40000410000ULL, 0x0000001508157220ULL, 0x040fe20000410000ULL,
0x000000181717723eULL, 0x000fe200000010ffULL, 0x0000001408147220ULL, 0x040fe20000410000ULL,
0x000000073f187812ULL, 0x000fe200078ec0ffULL, 0x0000001308137220ULL, 0x040fe20000410000ULL,
0x000000161515723eULL, 0x000fe200000010ffULL, 0x0000001208127220ULL, 0x040fe40000410000ULL,
0x0000001108117220ULL, 0x040fe20000410000ULL, 0x000000141313723eULL, 0x000fe200000010ffULL,
0x0000001008107220ULL, 0x000fc40000410000ULL, 0x0000000f080f7220ULL, 0x040fe20000410000ULL,
0x000000121111723eULL, 0x000fe200000010ffULL, 0x0000000d080d7220ULL, 0x040fe40000410000ULL,
0x0000000a080a7220ULL, 0x040fe20000410000ULL, 0x000000100f0f723eULL, 0x000fe200000010ffULL,
0x00000000080b7220ULL, 0x000fe20000410000ULL, 0x0000000731007812ULL, 0x040fe200078ec0ffULL,
0x0000000831087824ULL, 0x000fe200078e00ffULL, 0x0000000d0606723eULL, 0x000fe200000010ffULL,
0x0000002a072a7220ULL, 0x004fe20000410000ULL, 0x0000000a0b0a723eULL, 0x000fe200000010ffULL,
0x0000002907297220ULL, 0x040fe20000410000ULL, 0xfffffff8080b7812ULL, 0x000fe200078ee231ULL,
0x0000002807287220ULL, 0x040fe20000410000ULL, 0x0000000100087812ULL, 0x040fe200078e3cffULL,
0x0000002707277220ULL, 0x040fe20000410000ULL, 0x00000002000e7812ULL, 0x040fe200078e3cffULL,
0x0000002607267220ULL, 0x040fe20000410000ULL, 0x0000000300107812ULL, 0x040fe200078e3cffULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x0000000400127812ULL, 0x040fe200078e3cffULL,
0x0000002407247220ULL, 0x040fe20000410000ULL, 0x0000000500147812ULL, 0x040fe200078e3cffULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000000600007812ULL, 0x000fe200078e3cffULL,
0x0000002207227220ULL, 0x000fe20000410000ULL, 0x0000002a2929723eULL, 0x000fe200000010ffULL,
0x0000002107217220ULL, 0x000fe20000410000ULL, 0x000000282727723eULL, 0x000fe200000010ffULL,
0x0000002007207220ULL, 0x000fe20000410000ULL, 0x000000262525723eULL, 0x000fe200000010ffULL,
0x0000001f071f7220ULL, 0x000fe20000410000ULL, 0x000000222121723eULL, 0x000fe200000010ffULL,
0x0000001e071e7220ULL, 0x000fe20000410000ULL, 0x000000242323723eULL, 0x000fe200000010ffULL,
0x0000001d071d7220ULL, 0x000fe20000410000ULL, 0x000000201f1f723eULL, 0x000fe200000010ffULL,
0x0000001c071c7220ULL, 0x000fc40000410000ULL, 0x0000001b07077220ULL, 0x000fe20000410000ULL,
0x0000001e1d1d723eULL, 0x000fe200000010ffULL, 0x00000008310d7824ULL, 0x040fe200078e0208ULL,
0x0000000218087812ULL, 0x040fe200078e3cffULL, 0x00000008311b7824ULL, 0x040fe200078e020eULL,
0x00000003180e7812ULL, 0x040fe200078e3cffULL, 0x00000008312b7824ULL, 0x040fe200078e0210ULL,
0x0000000418107812ULL, 0x040fe200078e3cffULL, 0x00000008312d7824ULL, 0x040fe200078e0212ULL,
0x0000000518127812ULL, 0x040fe200078e3cffULL, 0x00000008312f7824ULL, 0x040fe200078e0214ULL,
0x0000000618147812ULL, 0x040fe200078e3cffULL, 0x0000000831317824ULL, 0x000fe200078e0200ULL,
0x0000000118007812ULL, 0x000fe200078e3cffULL, 0x000000083f1a7824ULL, 0x000fe200078e00ffULL,
0x0000001c0707723eULL, 0x000fe200000010ffULL, 0x0000000402167824ULL, 0x000fc400078e00ffULL,
0x000000083f357824ULL, 0x040fe200078e0200ULL, 0xfffffff81a337812ULL, 0x000fe200078ee23fULL,
0x000000083f377824ULL, 0x040fe200078e0208ULL, 0x0000000c16227812ULL, 0x000fe200078ec0ffULL,
0x000000083f397824ULL, 0x040fe400078e020eULL, 0x000000083f3b7824ULL, 0x040fe400078e0210ULL,
0x000000083f3d7824ULL, 0x040fe400078e0212ULL, 0x000000083f3f7824ULL, 0x000fc400078e0214ULL,
0x000000100b0b7824ULL, 0x100fe400078e0204ULL, 0x0000001043087824ULL, 0x100fe400078e0204ULL,
0x000000100d0d7824ULL, 0x100fe400078e0204ULL, 0x000000101b1b7824ULL, 0x100fe400078e0204ULL,
0x000000102b2b7824ULL, 0x100fe400078e0204ULL, 0x0000001033337824ULL, 0x000fc400078e0204ULL,
0x0000000122007824ULL, 0x000fe400078e020bULL, 0x000000102d2d7824ULL, 0x100fe400078e0204ULL,
0x000000102f2f7824ULL, 0x100fe200078e0204ULL, 0x0000002900007388ULL, 0x0003e20000000800ULL,
0x0000001031317824ULL, 0x100fe400078e0204ULL, 0x0000001035357824ULL, 0x100fe400078e0204ULL,
0x0000001037377824ULL, 0x000fc400078e0204ULL, 0x0000001039397824ULL, 0x100fe400078e0204ULL,
0x000000103b3b7824ULL, 0x100fe400078e0204ULL, 0x000000103d3d7824ULL, 0x100fe400078e0204ULL,
0x000000103f3f7824ULL, 0x000fe400078e0204ULL, 0x0000000122167824ULL, 0x040fe400078e0208ULL,
0x0000000122047824ULL, 0x000fc400078e020dULL, 0x0000000122087824ULL, 0x040fe400078e021bULL,
0x00000001220e7824ULL, 0x040fe200078e022bULL, 0x0000002704007388ULL, 0x000fe20000000800ULL,
0x0000000122107824ULL, 0x040fe400078e022dULL, 0x0000000122127824ULL, 0x040fe200078e022fULL,
0x0000002508007388ULL, 0x000fe20000000800ULL, 0x0000000122147824ULL, 0x040fe400078e0231ULL,
0x0000000122187824ULL, 0x040fe200078e0233ULL, 0x000000230e007388ULL, 0x000fe20000000800ULL,
0x00000001221a7824ULL, 0x000fc400078e0235ULL, 0x0000000122007824ULL, 0x042fe200078e0237ULL,
0x0000002110007388ULL, 0x000fe20000000800ULL, 0x00000001221c7824ULL, 0x040fe400078e0239ULL,
0x00000001221e7824ULL, 0x040fe200078e023bULL, 0x0000001f12007388ULL, 0x0003e20000000800ULL,
0x0000000122207824ULL, 0x040fe400078e023dULL, 0x00000001223f7824ULL, 0x040fe200078e023fULL,
0x0000001d14007388ULL, 0x000fe20000000800ULL, 0x0000000122417824ULL, 0x000fc400078e0241ULL,
0x0000002009227824ULL, 0x000fe200078e0202ULL, 0x0000000716007388ULL, 0x000fe20000000800ULL,
0x000000050512723eULL, 0x002fe400000010ffULL, 0x0000001022227824ULL, 0x000fe200078e0203ULL,
0x0000001918007388ULL, 0x000fe80000000800ULL, 0x000000171a007388ULL, 0x000fe80000000800ULL,
0x0000001500007388ULL, 0x000fe80000000800ULL, 0x000000131c007388ULL, 0x000fe80000000800ULL,
0x000000111e007388ULL, 0x000fe80000000800ULL, 0x0000000f20007388ULL, 0x000fe80000000800ULL,
0x000000063f007388ULL, 0x000fe80000000800ULL, 0x0000000a41007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000022247984ULL, 0x000e680000000c00ULL,
0x0004000022287984ULL, 0x000ea80000000c00ULL, 0x0008000022187984ULL, 0x000ee80000000c00ULL,
0x000c000022147984ULL, 0x000f220000000c00ULL, 0x3f803f8012277831ULL, 0x002fc40000200027ULL,
0x3f803f8012267831ULL, 0x040fe40000200026ULL, 0x3f803f8012257831ULL, 0x040fe40000200025ULL,
0x3f803f8012247831ULL, 0x040fe40000200024ULL, 0x3f803f80122b7831ULL, 0x044fe4000020002bULL,
0x3f803f80122a7831ULL, 0x040fe4000020002aULL, 0x3f803f8012297831ULL, 0x000fc40000200029ULL,
0x3f803f8012287831ULL, 0x000fe40000200028ULL, 0x3f803f8027277831ULL, 0x008fe4000020001bULL,
0x3f803f8026267831ULL, 0x000fe4000020001aULL, 0x3f803f8025257831ULL, 0x000fe40000200019ULL,
0x3f803f8024247831ULL, 0x000fe40000200018ULL, 0x3f803f802b2b7831ULL, 0x010fc40000200017ULL,
0x3f803f802a2a7831ULL, 0x000fe20000200016ULL, 0x0000002422007388ULL, 0x0003e20000000c00ULL,
0x3f803f8029297831ULL, 0x000fe40000200015ULL, 0x3f803f8028287831ULL, 0x000fca0000200014ULL,
0x0004002822007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff0900720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000020020f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000077919ULL, 0x000ee20000002600ULL,
0x00000003ff0d7819ULL, 0x100fe20000011602ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x00000003ff047819ULL, 0x100fe2000001160fULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x000000070d057812ULL, 0x100fe200078e4802ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000704067812ULL, 0x000fe400078e480fULL, 0x0ffffff805007812ULL, 0x000fc400078ef802ULL,
0x0ffffff806067812ULL, 0x000fc600078ef80fULL, 0x0000001000007824ULL, 0x100fe400078e0203ULL,
0x0000001006067824ULL, 0x000fc600078e0203ULL, 0x0000000000087984ULL, 0x000a680000000c00ULL,
0x0000000006107984ULL, 0x0022a20000000c00ULL, 0x00000008070e7824ULL, 0x048fe400078e00ffULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x010fe4000f8e023fULL,
0xfffffff80e037812ULL, 0x000fe200078ee20dULL, 0x000000080c0d7824ULL, 0x040fe200078e00ffULL,
0xfffffff807047812ULL, 0x000fe200078ee204ULL, 0x000000080c0c7824ULL, 0x000fe200078e00ffULL,
0x0000000403037c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000404077c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005a0003047a11ULL, 0x000fe200078040ffULL,
0x000000ffff007224ULL, 0x020fe200008e06ffULL, 0x00005a0007067a11ULL, 0x002fe400078240ffULL,
0x00005b0003057a11ULL, 0x000fe400000f440eULL, 0xfffffff80d037812ULL, 0x000fe400078ee202ULL,
0x00005b0007077a11ULL, 0x000fe400008f4400ULL, 0xfffffff80c0d7812ULL, 0x000fe200078ee20fULL,
0x0000001003027825ULL, 0x000fc800078e0004ULL, 0x000000100d047825ULL, 0x000fe200078e0006ULL,
0x0000000802007986ULL, 0x000fe8000c101d06ULL, 0x0000001004007986ULL, 0x004fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff067624ULL, 0x000fe400078e00ffULL,
0x00006700ff077624ULL, 0x000fca00078e00ffULL, 0x0000000606387981ULL, 0x000362000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000104067810ULL, 0x002fe20007ffe0ffULL,
0x0000000213137824ULL, 0x000fe200078e00ffULL, 0x00f60000ff087f8cULL, 0x000e62000c80043fULL,
0x0000004000077824ULL, 0x000fe200078e00ffULL, 0x000000050600720cULL, 0x000fe20003f06070ULL,
0x0000580013067a24ULL, 0x000fe400078e0214ULL, 0x0000010004177824ULL, 0x000fc800078e0207ULL,
0x0000620006237a24ULL, 0x000fcc00078e0217ULL, 0x000005a000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1c7819ULL, 0x000fe20000011602ULL, 0x00000080ff257424ULL, 0x000fe200078e00ffULL,
0x0000003010217812ULL, 0x000fe400078ec0ffULL, 0x000000081c147810ULL, 0x040fe20007ffe0ffULL,
0x000000011c0a7824ULL, 0x140fe200078e0223ULL, 0x000000181c207810ULL, 0x040fe40007ffe0ffULL,
0x000000101c1e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001140c7824ULL, 0x000fe200078e0223ULL,
0x000000201c187810ULL, 0x000fe20007ffe0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0025ULL,
0x00000017030e7217ULL, 0x000fc40007800000ULL, 0x00000003ff197819ULL, 0x100fe20000011602ULL,
0x00005e000c0c7625ULL, 0x000fe200078e0025ULL, 0x000000210a127210ULL, 0x080fe40007f1e0ffULL,
0x0000000319197812ULL, 0x000fe200078e4802ULL, 0x0000000120107824ULL, 0x100fe200078e0223ULL,
0x000000210c0c7210ULL, 0x000fe20007f3e0ffULL, 0x000000011e0f7824ULL, 0x000fe200078e0223ULL,
0x00001000001b7811ULL, 0x000fe200078e68ffULL, 0x00005e0010107625ULL, 0x000fe200078e0025ULL,
0x000000281c1a7810ULL, 0x000fc40007ffe0ffULL, 0x0ffffffc19027812ULL, 0x000fe200078ef802ULL,
0x00000001230a7824ULL, 0x000fe400078e0218ULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x0000002110107210ULL, 0x000fe20007f3e0ffULL, 0x000000010e177824ULL, 0x000fe400078e0a17ULL,
0x00005e000f0e7625ULL, 0x000fc600078e0025ULL, 0x000000171e00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff137224ULL, 0x000fe200000e060bULL, 0x000000210e0e7210ULL, 0x000fe20007f1e0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0025ULL, 0x000000172000720cULL, 0x080fe40003f86070ULL,
0x000000171800720cULL, 0x080fe20003f66070ULL, 0x0000000414167824ULL, 0x040fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x000000171400720cULL, 0x000fe20003f26070ULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0x000000210a147210ULL, 0x000fe20007f5e0ffULL,
0x00000010021d7824ULL, 0x000fe200078e021bULL, 0xfffffffc160a7812ULL, 0x000fe200078ee219ULL,
0x000000041e1e7824ULL, 0x000fe200078e00ffULL, 0x000000171c00720cULL, 0x0c0fe20003f06070ULL,
0x000000ffff157224ULL, 0x000fe200010e060bULL, 0x000000301c027810ULL, 0x000fe20007ffe0ffULL,
0x000000100a1f7824ULL, 0x000fe200078e021bULL, 0x000000381c1c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001230a7824ULL, 0x000fe200078e021aULL, 0x000000171a00720cULL, 0x000fe20003f46070ULL,
0x0000000418187824ULL, 0x000fc400078e00ffULL, 0x00005e000a0a7625ULL, 0x000fc600078e0025ULL,
0xfffffffc18187812ULL, 0x000fe200078ee219ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121d7faeULL, 0x0005e2000c101c46ULL, 0x000000210a167210ULL, 0x000fe20007fde0ffULL,
0x00000001230a7824ULL, 0x000fe200078e0202ULL, 0x000000171c00720cULL, 0x080fe20003f06070ULL,
0x000000000c1f7faeULL, 0x0007e2000c901c46ULL, 0x000000170200720cULL, 0x000fe20003f26070ULL,
0x000000ffff177224ULL, 0x000fe400030e060bULL, 0x00005e000a0a7625ULL, 0x000fc800078e0025ULL,
0x0000000420127824ULL, 0x004fe200078e00ffULL, 0x000000210a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000041a1a7824ULL, 0x000fe400078e00ffULL, 0x00000001230c7824ULL, 0x008fe200078e021cULL,
0xfffffffc12127812ULL, 0x100fe200078ee219ULL, 0x0000000402207824ULL, 0x000fe200078e00ffULL,
0xfffffffc1e027812ULL, 0x100fe200078ee219ULL, 0x000000041c227824ULL, 0x000fe200078e00ffULL,
0xfffffffc1a1a7812ULL, 0x100fe200078ee219ULL, 0x00005e000c0c7625ULL, 0x000fe200078e0025ULL,
0xfffffffc201c7812ULL, 0x000fc400078ee219ULL, 0xfffffffc221e7812ULL, 0x000fe200078ee219ULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x000000210c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001002137824ULL, 0x100fe400078e021bULL, 0x0000001012197824ULL, 0x100fe400078e021bULL,
0x00000010181d7824ULL, 0x100fe200078e021bULL, 0x000000000e137faeULL, 0x0005e2000e901c46ULL,
0x000000101a1f7824ULL, 0x100fe400078e021bULL, 0x000000101c217824ULL, 0x100fe200078e021bULL,
0x0000000010197faeULL, 0x0005e2000e101c46ULL, 0x000000101e1b7824ULL, 0x000fc400078e021bULL,
0x000000ffff0d7224ULL, 0x000fe200030e060dULL, 0x00000000141d7faeULL, 0x0005e8000d901c46ULL,
0x00000000161f7faeULL, 0x0005e8000d101c46ULL, 0x000000000a217faeULL, 0x0005e8000c901c46ULL,
0x000000000c1b7faeULL, 0x0005e2000c101c46ULL, 0x000004e000007947ULL, 0x000fea0003800000ULL,
0x00000003ff0d7819ULL, 0x000fe20000011602ULL, 0x00000080ff297424ULL, 0x000fe200078e00ffULL,
0x00000010020b7811ULL, 0x000fc400078ff0ffULL, 0x00000023020a7211ULL, 0x040fe400078ff0ffULL,
0x000000030d197812ULL, 0x000fe200078e4802ULL, 0x00000001230d7824ULL, 0x000fe200078e020bULL,
0x0000000802127811ULL, 0x040fe200078ff0ffULL, 0x000000040b207824ULL, 0x000fe200078e00ffULL,
0x0000003802147811ULL, 0x000fe200078ff0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0029ULL,
0x0000002802117811ULL, 0x000fe400078ff0ffULL, 0x00000030102b7812ULL, 0x000fe200078ec0ffULL,
0x0000000412167824ULL, 0x000fe200078e00ffULL, 0x00000018020e7811ULL, 0x040fe200078ff0ffULL,
0x00000001231e7824ULL, 0x000fe200078e0214ULL, 0x0000003002137811ULL, 0x000fe200078ff0ffULL,
0x0000000414287824ULL, 0x000fe200078e00ffULL, 0x0000002b0a147210ULL, 0x000fe20007f1e0ffULL,
0x0000000411247824ULL, 0x000fe200078e00ffULL, 0x0000002002107811ULL, 0x000fe200078ff0ffULL,
0x00000001120c7824ULL, 0x000fe200078e0223ULL, 0x0ffffffc19187812ULL, 0x000fe200078ef802ULL,
0x00000001230f7824ULL, 0x000fe200078e020eULL, 0xfffffffc16027812ULL, 0x100fe200078ee219ULL,
0x0000000413267824ULL, 0x000fe200078e00ffULL, 0xfffffffc24167812ULL, 0x000fe200078ee219ULL,
0x000000ffff157224ULL, 0x000fe200000e060bULL, 0x0000100000277811ULL, 0x000fe200078e68ffULL,
0x000000040e0e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc26177812ULL, 0x000fe200078ee219ULL,
0x0000000410227824ULL, 0x000fc400078e00ffULL, 0x00005e000c0a7625ULL, 0x000fc800078e0029ULL,
0x00005e000d0c7625ULL, 0x000fc800078e0029ULL, 0x0000000123127824ULL, 0x040fe200078e0210ULL,
0xfffffffc20107812ULL, 0x000fe200078ee219ULL, 0x00000001231a7824ULL, 0x040fe200078e0211ULL,
0xfffffffc0e117812ULL, 0x000fe200078ee219ULL, 0x00000001231c7824ULL, 0x000fe200078e0213ULL,
0xfffffffc22137812ULL, 0x000fe200078ee219ULL, 0x0000001016237824ULL, 0x000fe200078e0227ULL,
0x0000002b0a167210ULL, 0x000fe20007f1e0ffULL, 0x00005e000f0e7625ULL, 0x000fe200078e0029ULL,
0xfffffffc28197812ULL, 0x000fc600078ee219ULL, 0x00000010182d7824ULL, 0x100fe200078e0227ULL,
0x0000002b0c187210ULL, 0x000fe20007f3e0ffULL, 0x0000001017257824ULL, 0x100fe400078e0227ULL,
0x00000010021b7824ULL, 0x100fe200078e0227ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000142d7faeULL, 0x0005e2000b901c46ULL, 0x00000010101d7824ULL, 0x100fe400078e0227ULL,
0x00000010111f7824ULL, 0x100fe400078e0227ULL, 0x0000001013217824ULL, 0x000fc400078e0227ULL,
0x000000ffff177224ULL, 0x000fe200000e060bULL, 0x0000002b0e0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000001019277824ULL, 0x000fe400078e0227ULL, 0x000000ffff197224ULL, 0x000fe200008e060dULL,
0x00000000161b7faeULL, 0x0005e2000b901c46ULL, 0x00005e00120a7625ULL, 0x000fc600078e0029ULL,
0x00000000181d7faeULL, 0x0005e2000b901c46ULL, 0x00005e001a0c7625ULL, 0x000fc800078e0029ULL,
0x00005e001c107625ULL, 0x000fe200078e0029ULL, 0x0000002b0c0c7210ULL, 0x000fc60007f3e0ffULL,
0x00005e001e127625ULL, 0x000fe200078e0029ULL, 0x0000002b10107210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0x0000002b0a0a7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x0000002b12127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x000000000e1f7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff0b7224ULL, 0x000fe400000e060bULL, 0x000000ffff137224ULL, 0x000fc600018e0613ULL,
0x000000000a217faeULL, 0x0005e8000b901c46ULL, 0x000000000c237faeULL, 0x0005e8000b901c46ULL,
0x0000000010257faeULL, 0x0005e8000b901c46ULL, 0x0000000012277faeULL, 0x0005e4000b901c46ULL,
0x00f60400ff0b7984ULL, 0x004ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x800000000bff7812ULL, 0x006fc60007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff027424ULL, 0x000fc800078e00ffULL, 0x00000002000a7305ULL, 0x0002a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x0000000a0000735dULL, 0x004fe20003800000ULL,
0x00f60400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000097919ULL, 0x000e640000000000ULL,
0x0000002000027824ULL, 0x002fc800078e0209ULL, 0x00000010020a7824ULL, 0x000fe200078e00ffULL,
0x00000003ff087819ULL, 0x000fc80000011602ULL, 0x1ffffffe08097812ULL, 0x000fe400078ec0ffULL,
0x000000f00a0a7812ULL, 0x000fe400078ec0ffULL, 0x00000001090b7812ULL, 0x040fe400078efcffULL,
0x0000000709097812ULL, 0x100fe400078e7802ULL, 0x000000070b0b7812ULL, 0x000fc600078e7802ULL,
0x0000000109097824ULL, 0x000fe400078e020aULL, 0x000000010a0b7824ULL, 0x000fc600078e020bULL,
0x0000000009107984ULL, 0x000e68000000cc00ULL, 0x000000000b0c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fc400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000001409007388ULL, 0x0003e8000000cc00ULL, 0x000000100b007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff087f8cULL, 0x002fe8000c80043fULL,
0x00f60400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x00000002000a7305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x0000000a0000735dULL, 0x004fe20003800000ULL, 0x00f60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000050400720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x3db504f338387820ULL, 0x020fe20000410000ULL,
0x0000f68800397811ULL, 0x040fe200078e18ffULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0xffffffff053b7810ULL, 0x000fe40007ffe0ffULL, 0x0000f608003a7811ULL, 0x000fe400078e28ffULL,
0x00000100043c7824ULL, 0x000fe200078e0207ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000003c0300720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x000000ffff3f7224ULL, 0x000fe200078e003dULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fc4000001ff00ULL,
0x000000013e287810ULL, 0x000fe20007ffe0ffULL, 0x00000a9000007945ULL, 0x000fe20003800000ULL,
0x000000ffff407224ULL, 0x000fe200078e003eULL, 0x000000013f3d7812ULL, 0x000fc400078e0cffULL,
0x00000001ff297819ULL, 0x100fe20000011628ULL, 0x000000ffff3e7224ULL, 0x000fe200078e0028ULL,
0x000000022800780cULL, 0x000fc60003f06070ULL, 0x00000300292a7a24ULL, 0x000fe200078e0204ULL,
0x0000000128297812ULL, 0x000fc600078ec0ffULL, 0x000001002a2b7824ULL, 0x040fe200078e0207ULL,
0x000000012a2c7810ULL, 0x000fc60007ffe0ffULL, 0x0000620006317a24ULL, 0x000fe200078e022bULL,
0x000000052c00720cULL, 0x000fda0003f26070ULL, 0x0000054000009947ULL, 0x000fea0003800000ULL,
0x0000000429357824ULL, 0x000fe200078e00ffULL, 0x00000003ff297819ULL, 0x102fe20000011602ULL,
0x0000000200347824ULL, 0x000fe200078e023dULL, 0x0000002b03287217ULL, 0x000fe20007800000ULL,
0x00000080ff337424ULL, 0x000fe200078e00ffULL, 0x00000002ff2e7819ULL, 0x100fe40000011602ULL,
0x0000000329377812ULL, 0x100fe200078e4802ULL, 0x00000001282c7824ULL, 0x000fe200078e0a2bULL,
0x000000082e297810ULL, 0x040fe20007ffe0ffULL, 0x000000012e287824ULL, 0x000fe200078e0231ULL,
0xfffffffc35357812ULL, 0x000fc400078ee202ULL, 0x0000002c2e00720cULL, 0x080fe20003f26070ULL,
0x00000001292a7824ULL, 0x040fe200078e0231ULL, 0x0000002c2900720cULL, 0x040fe20003f46070ULL,
0x0000000429307824ULL, 0x000fe200078e00ffULL, 0x0000100034347811ULL, 0x000fe200078e60ffULL,
0x00005e0028287625ULL, 0x080fe200078e0033ULL, 0x0ffffffc372d7812ULL, 0x000fe400078ef802ULL,
0xfffffffc302f7812ULL, 0x000fe200078ee237ULL, 0x00005e002a2a7625ULL, 0x000fe200078e0033ULL,
0x000000102e307810ULL, 0x000fc40007ffe0ffULL, 0x000000182e327810ULL, 0x040fe20007ffe0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e0234ULL, 0x000000202e367810ULL, 0x040fe20007ffe0ffULL,
0x0000001035287825ULL, 0x000fe200078e0028ULL, 0x000000282e417810ULL, 0x040fe40007ffe0ffULL,
0x000000302e427810ULL, 0x040fe20007ffe0ffULL, 0x000000102f2f7824ULL, 0x000fe200078e0234ULL,
0x000000382e437810ULL, 0x000fe20007ffe0ffULL, 0x00000010352a7825ULL, 0x000fe200078e002aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282d7faeULL, 0x0003e2000c901c46ULL,
0x0000002c3000720cULL, 0x000fc40003f26070ULL, 0x0000002c3600720cULL, 0x080fe20003f66070ULL,
0x000000002a2f7faeULL, 0x0005e2000d101c46ULL, 0x0000002c3200720cULL, 0x080fe20003f46070ULL,
0x0000000430447824ULL, 0x000fe200078e00ffULL, 0x0000002c4100720cULL, 0x0c0fe20003f86070ULL,
0x0000000432467824ULL, 0x000fe200078e00ffULL, 0x0000002c4200720cULL, 0x080fe20003fa6070ULL,
0x00000001412e7824ULL, 0x100fe200078e0231ULL, 0x0000002c4300720cULL, 0x000fe20003fc6070ULL,
0x0000000130287824ULL, 0x102fe400078e0231ULL, 0x00000001362c7824ULL, 0x000fc400078e0231ULL,
0x00000001322a7824ULL, 0x104fe400078e0231ULL, 0x0000000142307824ULL, 0x100fe400078e0231ULL,
0x0000000143327824ULL, 0x000fe400078e0231ULL, 0x0000000436367824ULL, 0x000fe400078e00ffULL,
0x00005e0028287625ULL, 0x000fc600078e0033ULL, 0xfffffffc36457812ULL, 0x000fe200078ee237ULL,
0x00005e002a2a7625ULL, 0x000fc800078e0033ULL, 0x00005e002c2c7625ULL, 0x000fc800078e0033ULL,
0x00005e002e2e7625ULL, 0x000fc800078e0033ULL, 0x00005e0030307625ULL, 0x000fc800078e0033ULL,
0x0000000441487824ULL, 0x000fe200078e00ffULL, 0xfffffffc44417812ULL, 0x000fe200078ee237ULL,
0x00005e0032327625ULL, 0x000fc600078e0033ULL, 0xfffffffc48477812ULL, 0x100fe200078ee237ULL,
0x0000000442427824ULL, 0x000fe400078e00ffULL, 0x00000004434a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc46437812ULL, 0x000fe200078ee237ULL, 0x0000001035287825ULL, 0x040fe200078e0028ULL,
0xfffffffc42497812ULL, 0x100fe400078ee237ULL, 0xfffffffc4a4b7812ULL, 0x000fe200078ee237ULL,
0x00000010352a7825ULL, 0x000fc800078e002aULL, 0x00000010352c7825ULL, 0x000fc800078e002cULL,
0x00000010352e7825ULL, 0x000fc800078e002eULL, 0x0000001035307825ULL, 0x000fc800078e0030ULL,
0x0000001035327825ULL, 0x000fc800078e0032ULL, 0x0000001041357824ULL, 0x100fe400078e0234ULL,
0x0000001043377824ULL, 0x100fe400078e0234ULL, 0x0000001045417824ULL, 0x100fe200078e0234ULL,
0x0000000028357faeULL, 0x0003e2000c901c46ULL, 0x0000001047437824ULL, 0x100fe400078e0234ULL,
0x0000001049457824ULL, 0x100fe200078e0234ULL, 0x000000002a377faeULL, 0x0003e2000d101c46ULL,
0x000000104b477824ULL, 0x000fc600078e0234ULL, 0x000000002c417faeULL, 0x0003e8000d901c46ULL,
0x000000002e437faeULL, 0x0003e8000e101c46ULL, 0x0000000030457faeULL, 0x0003e8000e901c46ULL,
0x0000000032477faeULL, 0x0003e2000f101c46ULL, 0x0000048000007947ULL, 0x000fea0003800000ULL,
0x00000002002a7824ULL, 0x000fe200078e023dULL, 0x00000008022c7811ULL, 0x042fe200078ff0ffULL,
0x0000000429417824ULL, 0x000fe200078e00ffULL, 0x00000010022e7811ULL, 0x040fe200078ff0ffULL,
0x00000080ff377424ULL, 0x000fe200078e00ffULL, 0x0000001802307811ULL, 0x000fe200078ff0ffULL,
0x000000042c447824ULL, 0x000fe200078e00ffULL, 0x0000002002327811ULL, 0x000fe200078ff0ffULL,
0x000000042e467824ULL, 0x000fe200078e00ffULL, 0x0000002802347811ULL, 0x000fe200078ff0ffULL,
0x0000000430487824ULL, 0x000fe200078e00ffULL, 0x0000003002367811ULL, 0x000fe200078ff0ffULL,
0x00000004324a7824ULL, 0x000fe200078e00ffULL, 0x0000003802427811ULL, 0x000fe200078ff0ffULL,
0x00000004344c7824ULL, 0x000fe200078e00ffULL, 0x000010002a4d7811ULL, 0x000fe200078e60ffULL,
0x000000012c2a7824ULL, 0x100fe200078e0231ULL, 0x00000003ff297819ULL, 0x100fe20000011602ULL,
0x000000012e2c7824ULL, 0x100fe200078e0231ULL, 0x0000003102287211ULL, 0x000fe200078ff0ffULL,
0x00000001302e7824ULL, 0x100fe200078e0231ULL, 0x00000003292b7812ULL, 0x100fe200078e4802ULL,
0x0000000132307824ULL, 0x000fe200078e0231ULL, 0xfffffffc41417812ULL, 0x000fe200078ee202ULL,
0x00000004364e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc44447812ULL, 0x100fe200078ee22bULL,
0x0000000442507824ULL, 0x000fe200078e00ffULL, 0xfffffffc46467812ULL, 0x000fe200078ee22bULL,
0x0000000134327824ULL, 0x000fe200078e0231ULL, 0xfffffffc48487812ULL, 0x000fe200078ee22bULL,
0x0000000136347824ULL, 0x000fe200078e0231ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee22bULL,
0x0000000142367824ULL, 0x000fe200078e0231ULL, 0xfffffffc4c4c7812ULL, 0x100fe200078ee22bULL,
0x00005e0028287625ULL, 0x000fe200078e0037ULL, 0xfffffffc4e4e7812ULL, 0x000fc400078ee22bULL,
0xfffffffc50507812ULL, 0x000fe200078ee22bULL, 0x00005e002c2c7625ULL, 0x000fe200078e0037ULL,
0x0ffffffc2b427812ULL, 0x000fc600078ef802ULL, 0x00005e002a2a7625ULL, 0x000fc800078e0037ULL,
0x00005e002e2e7625ULL, 0x000fc800078e0037ULL, 0x00005e0030307625ULL, 0x000fc800078e0037ULL,
0x00005e0032327625ULL, 0x000fc800078e0037ULL, 0x00005e0034347625ULL, 0x000fc800078e0037ULL,
0x00005e0036367625ULL, 0x000fc800078e0037ULL, 0x0000001041287825ULL, 0x000fc800078e0028ULL,
0x00000010412a7825ULL, 0x000fc800078e002aULL, 0x00000010412c7825ULL, 0x000fc800078e002cULL,
0x00000010412e7825ULL, 0x000fc800078e002eULL, 0x0000001041307825ULL, 0x000fc800078e0030ULL,
0x0000001041327825ULL, 0x000fc800078e0032ULL, 0x0000001041347825ULL, 0x000fc800078e0034ULL,
0x0000001041367825ULL, 0x000fc800078e0036ULL, 0x00000010424f7824ULL, 0x100fe400078e024dULL,
0x0000001044417824ULL, 0x100fe400078e024dULL, 0x0000001046437824ULL, 0x100fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000284f7faeULL, 0x0003e2000b901c46ULL,
0x0000001048457824ULL, 0x100fe400078e024dULL, 0x000000104a477824ULL, 0x100fe200078e024dULL,
0x000000002a417faeULL, 0x0003e2000b901c46ULL, 0x000000104c497824ULL, 0x000fc400078e024dULL,
0x000000104e4b7824ULL, 0x100fe200078e024dULL, 0x000000002c437faeULL, 0x0003e2000b901c46ULL,
0x00000010504d7824ULL, 0x000fc600078e024dULL, 0x000000002e457faeULL, 0x0003e8000b901c46ULL,
0x0000000030477faeULL, 0x0003e8000b901c46ULL, 0x0000000032497faeULL, 0x0003e8000b901c46ULL,
0x00000000344b7faeULL, 0x0003e8000b901c46ULL, 0x00000000364d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000840477824ULL, 0x002fc400078e00ffULL, 0x000000ffff467224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff802297812ULL, 0x000fe200078ec0ffULL,
0x00000002002d7824ULL, 0x000fe200078e023fULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000146427810ULL, 0x000fe40007ffe0ffULL, 0x0000000729297812ULL, 0x000fe400078ef802ULL,
0x000010002d2d7811ULL, 0x000fe400078e60ffULL, 0x00000001ff287819ULL, 0x000fc80000011629ULL,
0x00000003282b7812ULL, 0x000fc800078ec0ffULL, 0x000000462b287212ULL, 0x040fe400078e3cffULL,
0x000000422b2a7212ULL, 0x000fc600078e3cffULL, 0x0000000429287824ULL, 0x040fe400078e0228ULL,
0x00000004292a7824ULL, 0x000fe200078e022aULL, 0x0000002002297810ULL, 0x000fe20007ffe0ffULL,
0x0000001028287824ULL, 0x100fe400078e022dULL, 0x000000102a2a7824ULL, 0x000fe200078e022dULL,
0xfffffff829297812ULL, 0x000fe400078ec0ffULL, 0x000000002834783bULL, 0x000e640000000200ULL,
0x00000007292c7812ULL, 0x000fc400078ef802ULL, 0x000000002a30783bULL, 0x0004e20000000200ULL,
0x00000018ff287819ULL, 0x002fe20000011434ULL, 0x0001000034517824ULL, 0x000fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x004fe20000011435ULL, 0x00000034009a7306ULL, 0x000fe20000009400ULL,
0x00000018ff2e7819ULL, 0x000fe20000011436ULL, 0x0001000035547824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000018ff407819ULL, 0x000fe40000011437ULL,
0x00000018ff417819ULL, 0x008fe20000011430ULL, 0x00000028009f7306ULL, 0x000fe20000209400ULL,
0x00000018ff447819ULL, 0x000fc40000011432ULL, 0x00000018ff437819ULL, 0x000fe40000011431ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff457819ULL, 0x000fe20000011433ULL,
0x0000002800987306ULL, 0x000e700000205400ULL, 0x0000002800787306ULL, 0x0004f0000020d400ULL,
0x0000002a00a47306ULL, 0x000fe20000209400ULL, 0x00000001ff287819ULL, 0x004fc4000001162cULL,
0x000000989f00720bULL, 0x002fe40003fdd000ULL, 0x0000000328297812ULL, 0x000fc600078ec0ffULL,
0x0000002a00a77306ULL, 0x000fe20000205400ULL, 0x00000046292b7212ULL, 0x040fe400078e3cffULL,
0x00000042292f7212ULL, 0x000fe400078e3cffULL, 0x0000000246467810ULL, 0x000fe20007ffe0ffULL,
0x000000042c287824ULL, 0x040fe400078e022bULL, 0x0000002a00737306ULL, 0x0003e2000020d400ULL,
0x000000042c2c7824ULL, 0x000fe200078e022fULL, 0x0000000178786812ULL, 0x008fe200078efcffULL,
0x0000001028287824ULL, 0x000fc400078e022dULL, 0x000000102c2c7824ULL, 0x000fc600078e022dULL,
0x00000034009d7306ULL, 0x000ea20000005400ULL, 0x000000002828783bULL, 0x002e6e0000000200ULL,
0x0000003400767306ULL, 0x000730000000d400ULL, 0x00000051006b7306ULL, 0x000fe20000209400ULL,
0x0000010034347824ULL, 0x008fe200078e00ffULL, 0x0000009d9a00720bULL, 0x004fc80003f5d000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000005100b27306ULL, 0x000eae0000205400ULL,
0x0000000176762812ULL, 0x010fe200078efcffULL, 0x0000003500a07306ULL, 0x000ff00000009400ULL,
0x0000003500a17306ULL, 0x000ee20000005400ULL, 0x000000b26b00720bULL, 0x004fe20003f9d000ULL,
0x0001000028837824ULL, 0x002fc400078e00ffULL, 0x000100002bdc7824ULL, 0x000fc600078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011483ULL, 0x0000003500727306ULL, 0x0002a2000000d400ULL,
0x00000018ffdc7819ULL, 0x000fce00000114dcULL, 0x0000002e00a57306ULL, 0x000fe20000209400ULL,
0x0000010035357824ULL, 0x002fe200078e00ffULL, 0x000000a1a000720bULL, 0x008fc80003fbd000ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000002e00a27306ULL, 0x000e6e0000205400ULL,
0x0000000172725812ULL, 0x004fe200078efcffULL, 0x0000002e006e7306ULL, 0x0004f0000020d400ULL,
0x0000003400b67306ULL, 0x000fe20000209400ULL, 0x000000002c2c783bULL, 0x004ea20000000200ULL,
0x000000a2a500720bULL, 0x002fcc0003fbd000ULL, 0x0000003400b77306ULL, 0x000e6e0000205400ULL,
0x000000016e6e5812ULL, 0x008fe200078efcffULL, 0x00000034009b7306ULL, 0x000730000020d400ULL,
0x0000003500c27306ULL, 0x000fe20000209400ULL, 0x0001000037347824ULL, 0x008fe200078e00ffULL,
0x000000b7b600720bULL, 0x002fc80003f7d000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500c37306ULL, 0x000fee0000205400ULL, 0x000000019b9b3812ULL, 0x010fe200078efcffULL,
0x00000035008c7306ULL, 0x0003e2000020d400ULL, 0x00000018ff867819ULL, 0x004fc4000001142dULL,
0x000000a7a400720bULL, 0x000fe40003f7d000ULL, 0x00000018ff897819ULL, 0x000fe4000001142eULL,
0x00000018ff5a7819ULL, 0x000fe2000001142cULL, 0x0000003700997306ULL, 0x000fe20000009400ULL,
0x00000018ff357819ULL, 0x002fe40000011428ULL, 0x00000018ff8b7819ULL, 0x000fca000001142fULL,
0x00000037008e7306ULL, 0x000e620000005400ULL, 0x0000000173733812ULL, 0x000fce00078efcffULL,
0x00000037006d7306ULL, 0x0005f0000000d400ULL, 0x0000005100957306ULL, 0x000722000020d400ULL,
0x0000010037377824ULL, 0x004fe200078e00ffULL, 0x0000008e9900720bULL, 0x002fc80003f7d000ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x00000036009c7306ULL, 0x000fe20000009400ULL,
0x0001000036517824ULL, 0x008fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000003600a37306ULL, 0x000e620000005400ULL, 0x0000000195954812ULL, 0x010fe400078efcffULL,
0x000000c3c200720bULL, 0x000fe40003f9d000ULL, 0x000000016d6d3812ULL, 0x000fc600078efcffULL,
0x0000003600717306ULL, 0x0004f0000000d400ULL, 0x0000003500cd7306ULL, 0x000fe20000209400ULL,
0x0000010036367824ULL, 0x004fe200078e00ffULL, 0x000000018c8c4812ULL, 0x000fc400078efcffULL,
0x000000a39c00720bULL, 0x002fe40003f5d000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003500cc7306ULL, 0x000ff00000205400ULL, 0x0000003500857306ULL, 0x0003e2000020d400ULL,
0x0000000171712812ULL, 0x008fce00078efcffULL, 0x0000003000807306ULL, 0x000fe20000009400ULL,
0x0001000030357824ULL, 0x002fce00078e00ffULL, 0x00000030007d7306ULL, 0x000ff00000005400ULL,
0x00000030004f7306ULL, 0x0003f0000000d400ULL, 0x0000003400c87306ULL, 0x000fe20000209400ULL,
0x0000010030307824ULL, 0x002fce00078e00ffULL, 0x0000003400c97306ULL, 0x000e700000205400ULL,
0x0000003400947306ULL, 0x0004f0000020d400ULL, 0x0000003700ce7306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x004fc4000001142aULL, 0x000000c9c800720bULL, 0x002fca0003f9d000ULL,
0x0000003700cf7306ULL, 0x000ff00000205400ULL, 0x00000037008d7306ULL, 0x0003e2000020d400ULL,
0x0000000194944812ULL, 0x008fce00078efcffULL, 0x0000003400bb7306ULL, 0x000fe20000209400ULL,
0x00000018ff377819ULL, 0x002fce000001142bULL, 0x0000003400ba7306ULL, 0x000ff00000205400ULL,
0x0000003400637306ULL, 0x0003f0000020d400ULL, 0x0000003600c77306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x002fe20000011430ULL, 0x0001000031307824ULL, 0x000fcc00078e00ffULL,
0x0000003600c67306ULL, 0x000ff00000205400ULL, 0x0000003600917306ULL, 0x0003f0000020d400ULL,
0x0000003700c07306ULL, 0x000fe20000209400ULL, 0x00000018ff367819ULL, 0x002fce0000011429ULL,
0x0000003700c17306ULL, 0x000ff00000205400ULL, 0x00000037005d7306ULL, 0x0003f0000020d400ULL,
0x00000032007b7306ULL, 0x000fe20000009400ULL, 0x0001000032377824ULL, 0x002fce00078e00ffULL,
0x00000032007e7306ULL, 0x000ff00000005400ULL, 0x00000032004c7306ULL, 0x0003f0000000d400ULL,
0x0000005100c47306ULL, 0x000fe20000209400ULL, 0x0000010032327824ULL, 0x002fce00078e00ffULL,
0x0000005100c57306ULL, 0x000e700000205400ULL, 0x0000003600cb7306ULL, 0x000ff00000209400ULL,
0x0000003600ca7306ULL, 0x000fe20000205400ULL, 0x000000c5c400720bULL, 0x002fce0003fdd000ULL,
0x00000036006a7306ULL, 0x0003f0000020d400ULL, 0x00000031007c7306ULL, 0x000fe20000009400ULL,
0x00000018ff367819ULL, 0x002fce0000011430ULL, 0x0000003100777306ULL, 0x000ff00000005400ULL,
0x00000031004d7306ULL, 0x0003f0000000d400ULL, 0x0000003600b57306ULL, 0x000fe20000209400ULL,
0x0000010031317824ULL, 0x002fce00078e00ffULL, 0x0000003600b47306ULL, 0x000ff00000205400ULL,
0x0000003600307306ULL, 0x0003f0000020d400ULL, 0x0000005400b87306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x002fe20000011432ULL, 0x0001000033327824ULL, 0x000fcc00078e00ffULL,
0x0000005400b97306ULL, 0x000e700000205400ULL, 0x0000005400937306ULL, 0x0005f0000020d400ULL,
0x00000051009e7306ULL, 0x000722000020d400ULL, 0x00000018ff547819ULL, 0x004fc40000011431ULL,
0x000000b9b800720bULL, 0x002fca0003f3d000ULL, 0x0000005400b07306ULL, 0x000fe20000209400ULL,
0x00000018ff517819ULL, 0x008fce0000011435ULL, 0x0000005400b37306ULL, 0x000fe20000205400ULL,
0x000000019e9e6812ULL, 0x010fe400078efcffULL, 0x000000cfce00720bULL, 0x000fe40003fdd000ULL,
0x0000000193931812ULL, 0x000fe400078efcffULL, 0x000000c6c700720bULL, 0x000fe20003f3d000ULL,
0x0000005400317306ULL, 0x0003e2000020d400ULL, 0x000000719e9e723eULL, 0x000fce00000010ffULL,
0x0000008300d07306ULL, 0x000fe20000209400ULL, 0x00000018ff547819ULL, 0x002fe40000011432ULL,
0x000000018d8d6812ULL, 0x000fe400078efcffULL, 0x0000000191911812ULL, 0x000fc600078efcffULL,
0x0000008300d17306ULL, 0x000e700000205400ULL, 0x0000005100be7306ULL, 0x000ff00000209400ULL,
0x0000005100bf7306ULL, 0x000fe20000205400ULL, 0x000000d1d000720bULL, 0x002fce0003f9d000ULL,
0x00000051005c7306ULL, 0x000ff0000020d400ULL, 0x0000003600907306ULL, 0x000ff00000209400ULL,
0x0000003600977306ULL, 0x000ff00000205400ULL, 0x0000003600517306ULL, 0x000ff0000020d400ULL,
0x0000005400847306ULL, 0x000ff00000209400ULL, 0x0000005400817306ULL, 0x000ff00000205400ULL,
0x0000005400327306ULL, 0x000ff0000020d400ULL, 0x0000002800b17306ULL, 0x000ff00000009400ULL,
0x0000002800ae7306ULL, 0x000e700000005400ULL, 0x0000002800697306ULL, 0x0004f0000000d400ULL,
0x0000008600367306ULL, 0x000fe20000209400ULL, 0x0000010028287824ULL, 0x004fe200078e00ffULL,
0x000000aeb100720bULL, 0x002fc80003f3d000ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000008600557306ULL, 0x000fee0000205400ULL, 0x0000000169691812ULL, 0x008fe200078efcffULL,
0x0000008600547306ULL, 0x0003e2000020d400ULL, 0x000000cacb00720bULL, 0x000fce0003f3d000ULL,
0x0000008300927306ULL, 0x0004e2000020d400ULL, 0x0001000029867824ULL, 0x002fca00078e00ffULL,
0x00000018ff867819ULL, 0x000fe40000011486ULL, 0x0000003300797306ULL, 0x000fe20000009400ULL,
0x000100002a837824ULL, 0x004fe200078e00ffULL, 0x000000016a6a1812ULL, 0x000fcc00078efcffULL,
0x00000033007a7306ULL, 0x000fe20000005400ULL, 0x0000000192924812ULL, 0x008fc800078efcffULL,
0x000000699292723eULL, 0x000fc600000010ffULL, 0x00000033004b7306ULL, 0x0003f0000000d400ULL,
0x0000002800d27306ULL, 0x000fe20000209400ULL, 0x0000010033337824ULL, 0x002fca00078e00ffULL,
0x00000018ff577819ULL, 0x000fe40000011433ULL, 0x0000002800d37306ULL, 0x000e700000205400ULL,
0x0000008600d47306ULL, 0x000ff00000209400ULL, 0x0000008600d57306ULL, 0x000ea20000205400ULL,
0x000000d3d200720bULL, 0x002fce0003fdd000ULL, 0x0000002900ac7306ULL, 0x000ff00000009400ULL,
0x0000002900af7306ULL, 0x000e620000005400ULL, 0x000000d5d400720bULL, 0x004fce0003f9d000ULL,
0x0000002900647306ULL, 0x0004f0000000d400ULL, 0x0000002a00ad7306ULL, 0x000fe20000009400ULL,
0x0000010029297824ULL, 0x004fe200078e00ffULL, 0x000000afac00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002a00aa7306ULL, 0x000e6e0000005400ULL,
0x0000000164645812ULL, 0x008fe200078efcffULL, 0x0000002a005e7306ULL, 0x0004e2000000d400ULL,
0x000000babb00720bULL, 0x000fce0003fbd000ULL, 0x0000003400bc7306ULL, 0x000fe20000209400ULL,
0x000001002a2a7824ULL, 0x004fe200078e00ffULL, 0x000000aaad00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000003400bd7306ULL, 0x000e620000205400ULL,
0x0000000163635812ULL, 0x000fe400078efcffULL, 0x000000bfbe00720bULL, 0x000fc80003fbd000ULL,
0x000000015e5e3812ULL, 0x008fe200078efcffULL, 0x0000003400357306ULL, 0x0004e2000020d400ULL,
0x0000007d8000720bULL, 0x000fce0003f7d000ULL, 0x0000005700677306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x004fe40000011437ULL, 0x000000015c5c5812ULL, 0x000fe400078efcffULL,
0x000000bdbc00720bULL, 0x002fe40003fbd000ULL, 0x000000014f4f3812ULL, 0x000fe200078efcffULL,
0x0000003400a87306ULL, 0x000fe20000209400ULL, 0x000000b4b500720bULL, 0x000fe40003f7d000ULL,
0x0000004f5c5c723eULL, 0x000fca00000010ffULL, 0x0000003400ab7306ULL, 0x000fe40000205400ULL,
0x0000000135355812ULL, 0x008fc800078efcffULL, 0x0000000130303812ULL, 0x000fe400078efcffULL,
0x0000003400377306ULL, 0x000ff0000020d400ULL, 0x0000005700687306ULL, 0x000ff00000205400ULL,
0x0000005700347306ULL, 0x000ff0000020d400ULL, 0x0000008900567306ULL, 0x000ff00000209400ULL,
0x0000008900577306ULL, 0x000ff00000205400ULL, 0x0000008900587306ULL, 0x000ff0000020d400ULL,
0x0000002800967306ULL, 0x0002b0000020d400ULL, 0x0000008600897306ULL, 0x000ee2000020d400ULL,
0x00000018ff287819ULL, 0x002fce0000011483ULL, 0x0000002900d67306ULL, 0x000fe20000209400ULL,
0x0000000196966812ULL, 0x004fce00078efcffULL, 0x0000002900d77306ULL, 0x000e620000205400ULL,
0x0000000189894812ULL, 0x008fc800078efcffULL, 0x000000648964723eULL, 0x000fc600000010ffULL,
0x0000002a00da7306ULL, 0x000ff00000209400ULL, 0x0000002a00db7306ULL, 0x000ea20000205400ULL,
0x000000d7d600720bULL, 0x002fce0003fdd000ULL, 0x0000002b008a7306ULL, 0x000ff00000009400ULL,
0x0000002b008f7306ULL, 0x000e620000005400ULL, 0x000000dbda00720bULL, 0x004fce0003f9d000ULL,
0x0000002b00527306ULL, 0x0004f0000000d400ULL, 0x0000004000a67306ULL, 0x000fe20000209400ULL,
0x000001002b2b7824ULL, 0x004fe200078e00ffULL, 0x0000008f8a00720bULL, 0x002fc80003f3d000ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000004000a97306ULL, 0x000e6e0000205400ULL,
0x0000000152521812ULL, 0x008fe200078efcffULL, 0x0000005a00607306ULL, 0x000fe20000209400ULL,
0x0000007e7b00720bULL, 0x000fe20003f3d000ULL, 0x000100002f7b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000005a005f7306ULL, 0x000fe20000205400ULL,
0x000000a9a600720bULL, 0x002fca0003f5d000ULL, 0x000000014c4c1812ULL, 0x000fe400078efcffULL,
0x0000005a00337306ULL, 0x000fe2000020d400ULL, 0x000000818400720bULL, 0x000fce0003f3d000ULL,
0x0000008b00597306ULL, 0x000fec0000209400ULL, 0x0000000132321812ULL, 0x000fe400078efcffULL,
0x0000008b005a7306ULL, 0x000ff00000205400ULL, 0x0000008b005b7306ULL, 0x000ff0000020d400ULL,
0x00000029008b7306ULL, 0x000e70000020d400ULL, 0x0000002a00867306ULL, 0x0004f0000020d400ULL,
0x000000dc00dd7306ULL, 0x000fe20000209400ULL, 0x000000018b8b6812ULL, 0x002fe200078efcffULL,
0x000100002d2a7824ULL, 0x004fca00078e00ffULL, 0x00000018ffa47819ULL, 0x000fe2000001142aULL,
0x000000dc00de7306ULL, 0x000e620000205400ULL, 0x0000000186864812ULL, 0x008fe400078efcffULL,
0x000000c1c000720bULL, 0x000fe40003f9d000ULL, 0x000000866363723eULL, 0x000fc600000010ffULL,
0x0000002800d87306ULL, 0x000ff00000209400ULL, 0x0000002800d97306ULL, 0x000fe20000205400ULL,
0x000000dedd00720bULL, 0x002fe40003fdd000ULL, 0x000000015d5d4812ULL, 0x000fca00078efcffULL,
0x0000002800837306ULL, 0x0003f0000020d400ULL, 0x0000002b009f7306ULL, 0x000fe20000209400ULL,
0x000100002c287824ULL, 0x002fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011428ULL,
0x0000002b00b27306ULL, 0x000fe20000205400ULL, 0x0000004702287211ULL, 0x000fe400078fe0ffULL,
0x0000000447477810ULL, 0x000fca0007ffe0ffULL, 0x0000002b00987306ULL, 0x0003f0000020d400ULL,
0x00000040006c7306ULL, 0x000ea2000020d400ULL, 0x00000007022b7812ULL, 0x002fc800078ec0ffULL,
0x000000082ba57812ULL, 0x000fc600078ef802ULL, 0x00000029009a7306ULL, 0x000ff00000209400ULL,
0x00000029009d7306ULL, 0x000fe20000205400ULL, 0x000000016c6c2812ULL, 0x004fe400078efcffULL,
0x000000cccd00720bULL, 0x000fc40003f5d000ULL, 0x0000008d6c8d723eULL, 0x000fc600000010ffULL,
0x0000002900997306ULL, 0x0003f0000020d400ULL, 0x000000dc006b7306ULL, 0x000ea2000020d400ULL,
0x0000000728297812ULL, 0x042fe400078e78a5ULL, 0x0000000228287810ULL, 0x000fc40007ffe0ffULL,
0x0000000185852812ULL, 0x000fe200078efcffULL, 0x00000010a5297824ULL, 0x000fe200078e0229ULL,
0x000000d9d800720bULL, 0x000fe20003f5d000ULL, 0x0000004100877306ULL, 0x000fe40000209400ULL,
0x0000001029297824ULL, 0x000fcc00078e00ffULL, 0x0000004100887306ULL, 0x000e620000205400ULL,
0x000000016b6b6812ULL, 0x004fe400078efcffULL, 0x000000777c00720bULL, 0x000fe20003fdd000ULL,
0x000001002f7c7824ULL, 0x000fe200078e00ffULL, 0x0000000183832812ULL, 0x000fe400078efcffULL,
0x000000b29f00720bULL, 0x000fe20003f5d000ULL, 0x0000002c00657306ULL, 0x000fe20000009400ULL,
0x000000916e9f723eULL, 0x000fe400000010ffULL, 0x000000526b52723eULL, 0x000fc400000010ffULL,
0x00000018ff7c7819ULL, 0x000fc6000001147cULL, 0x0000002c00667306ULL, 0x000ea20000005400ULL,
0x000000888700720bULL, 0x002fe40003f9d000ULL, 0x000000014d4d6812ULL, 0x000fe400078efcffULL,
0x000000aba800720bULL, 0x000fe40003fdd000ULL, 0x0000000198982812ULL, 0x000fe200078efcffULL,
0x0000002c004a7306ULL, 0x0003e2000000d400ULL, 0x0000007a7900720bULL, 0x000fe20003f5d000ULL,
0x000001002e7a7824ULL, 0x000fe200078e00ffULL, 0x0000004d3030723eULL, 0x000fc800000010ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x0000004100487306ULL, 0x000ee2000020d400ULL,
0x000001002c2c7824ULL, 0x002fe200078e00ffULL, 0x0000000137376812ULL, 0x000fe400078efcffULL,
0x000000666500720bULL, 0x004fe40003fdd000ULL, 0x00000018ffa37819ULL, 0x000fe4000001142cULL,
0x00000007282c7812ULL, 0x000fe200078e78a5ULL, 0x0000004400757306ULL, 0x000fe20000209400ULL,
0x000000002928783bULL, 0x000e620000000200ULL, 0x0000008b6a65723eULL, 0x000fc400000010ffULL,
0x00000010a5a27824ULL, 0x000fe200078e022cULL, 0x00000076952c723eULL, 0x000fe400000010ffULL,
0x0000000148484812ULL, 0x008fe200078efcffULL, 0x0000004400747306ULL, 0x000ea20000205400ULL,
0x000000b3b000720bULL, 0x000fe40003f9d000ULL, 0x000000014a4a6812ULL, 0x000fe400078efcffULL,
0x000000014b4b2812ULL, 0x000fe400078efcffULL, 0x0000009d9a00720bULL, 0x000fe20003f5d000ULL,
0x0000004300827306ULL, 0x000fe20000209400ULL, 0x0000004c374c723eULL, 0x000fca00000010ffULL,
0x0000000131314812ULL, 0x000fe400078efcffULL, 0x00000043007f7306ULL, 0x000ee20000205400ULL,
0x000000747500720bULL, 0x004fc60003f7d000ULL, 0x0000000199992812ULL, 0x000fc800078efcffULL,
0x0000004400407306ULL, 0x000eb0000020d400ULL, 0x0000004300427306ULL, 0x000f22000020d400ULL,
0x0000007f8200720bULL, 0x008fe20003fbd000ULL, 0x0000009e2808723cULL, 0x042fec0000041808ULL,
0x0000004500707306ULL, 0x000fe20000209400ULL, 0x0000000140403812ULL, 0x004fe200078efcffULL,
0x00000064281c723cULL, 0x000fe2000004181cULL, 0x000000686700720bULL, 0x000fca0003f7d000ULL,
0x00000045006f7306ULL, 0x000e620000205400ULL, 0x0000000142425812ULL, 0x010fe400078efcffULL,
0x000000979000720bULL, 0x000fe40003fbd000ULL, 0x000000314231723eULL, 0x000fc600000010ffULL,
0x0000002d00627306ULL, 0x000fe20000009400ULL, 0x0000000134343812ULL, 0x000fe400078efcffULL,
0x0000005f6000720bULL, 0x000fca0003f7d000ULL, 0x0000002d00617306ULL, 0x000ea20000005400ULL,
0x0000006f7000720bULL, 0x002fe40003f9d000ULL, 0x0000000151515812ULL, 0x000fc800078efcffULL,
0x00000051404d723eULL, 0x000fe200000010ffULL, 0x0000002d00497306ULL, 0x0003e2000000d400ULL,
0x0000000133333812ULL, 0x000fe400078efcffULL, 0x000000553600720bULL, 0x000fe40003f7d000ULL,
0x0000004b3240723eULL, 0x000fe400000010ffULL, 0x0000004a9932723eULL, 0x000fe200000010ffULL,
0x0000004500417306ULL, 0x000ee2000020d400ULL, 0x000001002d2d7824ULL, 0x002fe200078e00ffULL,
0x000000616200720bULL, 0x004fc40003fbd000ULL, 0x0000005e8362723eULL, 0x000fe400000010ffULL,
0x00000018ff777819ULL, 0x000fe4000001142dULL, 0x000000a3009c7306ULL, 0x000fe20000209400ULL,
0x0000009b782d723eULL, 0x000fe200000010ffULL, 0x000100002e787824ULL, 0x000fe200078e00ffULL,
0x000000622818723cULL, 0x000fe20000041818ULL, 0x0000000154543812ULL, 0x000fc600078efcffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x000000a300a17306ULL, 0x000e620000205400ULL,
0x0000000141414812ULL, 0x008fe400078efcffULL, 0x0000002c2810723cULL, 0x000fe20000041810ULL,
0x0000000149495812ULL, 0x000fe400078efcffULL, 0x000000575600720bULL, 0x000fe40003fbd000ULL,
0x000000a400a07306ULL, 0x000fe20000209400ULL, 0x000000344141723eULL, 0x000fc400000010ffULL,
0x0000008c732d723eULL, 0x000fe400000010ffULL, 0x0000006d948c723eULL, 0x000fe400000010ffULL,
0x00000072932c723eULL, 0x000fe200000010ffULL, 0x000000a4008f7306ULL, 0x000ea20000205400ULL,
0x000000a19c00720bULL, 0x002fe40003f9d000ULL, 0x000000968593723eULL, 0x000fe200000010ffULL,
0x0000008c2824723cULL, 0x000fe20000041824ULL, 0x0000000158585812ULL, 0x000fc600078efcffULL,
0x0000002e00537306ULL, 0x000fe80000009400ULL, 0x0000002c280c723cULL, 0x040fe8000004180cULL,
0x0000002e00507306ULL, 0x000e620000005400ULL, 0x0000008fa000720bULL, 0x004fe40003fdd000ULL,
0x00000010a22c7824ULL, 0x000fe200078e00ffULL, 0x000000922820723cULL, 0x000fe80000041820ULL,
0x000000a3008e7306ULL, 0x000eb0000020d400ULL, 0x000000a400807306ULL, 0x000ee2000020d400ULL,
0x000000505300720bULL, 0x002fc40003f3d000ULL, 0x000000985d53723eULL, 0x000fe400000010ffULL,
0x00000035485d723eULL, 0x000fc600000010ffULL, 0x0000007700797306ULL, 0x000fe20000209400ULL,
0x000000018e8e4812ULL, 0x004fe200078efcffULL, 0x000000522814723cULL, 0x000fe60000041814ULL,
0x0000008e3333723eULL, 0x000fc600000010ffULL, 0x0000007700767306ULL, 0x000e620000205400ULL,
0x0000000180806812ULL, 0x008fc800078efcffULL, 0x000000498080723eULL, 0x000fc600000010ffULL,
0x00000078006e7306ULL, 0x000ff00000209400ULL, 0x00000078006d7306ULL, 0x000ea20000205400ULL,
0x000000767900720bULL, 0x002fce0003f9d000ULL, 0x0000002e00437306ULL, 0x000e70000000d400ULL,
0x0000007c00287306ULL, 0x000fe20000209400ULL, 0x0000006d6e00720bULL, 0x004fce0003fdd000ULL,
0x0000007c002b7306ULL, 0x000ea20000205400ULL, 0x0000000143431812ULL, 0x002fce00078efcffULL,
0x0000002f00457306ULL, 0x000ff00000009400ULL, 0x0000002f004e7306ULL, 0x000e620000005400ULL,
0x0000002b2800720bULL, 0x004fce0003f3d000ULL, 0x0000002f00447306ULL, 0x0004f0000000d400ULL,
0x0000007700737306ULL, 0x000f22000020d400ULL, 0x000000002c2c783bULL, 0x004ea20000000200ULL,
0x0000004e4500720bULL, 0x002fcc0003f5d000ULL, 0x00000078006c7306ULL, 0x000e6e000020d400ULL,
0x0000000144442812ULL, 0x008fe200078efcffULL, 0x0000007a00667306ULL, 0x000fe20000209400ULL,
0x0000000173734812ULL, 0x010fe400078efcffULL, 0x0000005a5900720bULL, 0x000fc40003f9d000ULL,
0x000000735481723eULL, 0x000fc600000010ffULL, 0x0000007a00617306ULL, 0x000ee20000205400ULL,
0x000000016c6c6812ULL, 0x002fc800078efcffULL, 0x000000436c6c723eULL, 0x000fc600000010ffULL,
0x0000007b00507306ULL, 0x000fe20000209400ULL, 0x000000015b5b4812ULL, 0x000fce00078efcffULL,
0x0000007b00297306ULL, 0x000e620000205400ULL, 0x000000616600720bULL, 0x008fe20003f7d000ULL,
0x0000005c2c10723cULL, 0x044fec0000041810ULL, 0x0000007c007c7306ULL, 0x000ea4000020d400ULL,
0x000000302c0c723cULL, 0x040fec000004180cULL, 0x0000007a00657306ULL, 0x000ee2000020d400ULL,
0x000000295000720bULL, 0x002fe20003fdd000ULL, 0x0000004c2c08723cULL, 0x040fec0000041808ULL,
0x0000007b007b7306ULL, 0x000e62000020d400ULL, 0x000000017c7c1812ULL, 0x004fe200078efcffULL,
0x000000402c24723cULL, 0x000fe20000041824ULL, 0x000000044600780cULL, 0x000fc40003f25270ULL,
0x0000007c5b45723eULL, 0x000fe400000010ffULL, 0x0000000165653812ULL, 0x008fc600078efcffULL,
0x000000322c20723cULL, 0x000fe20000041820ULL, 0x00000065586d723eULL, 0x000fe400000010ffULL,
0x000000017b7b6812ULL, 0x002fca00078efcffULL, 0x000000802c1c723cULL, 0x000fe2000004181cULL,
0x000000447b44723eULL, 0x000fce00000010ffULL, 0x0000006c2c18723cULL, 0x040ff00000041818ULL,
0x000000442c14723cULL, 0x000fe20000041814ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe12000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff3f7224ULL, 0x000fe200078e003dULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd5f000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000039287f8cULL, 0x000fe2000c80043fULL,
0x0000002038207220ULL, 0x000fc40000410000ULL, 0x00000012382a7220ULL, 0x040fe20000410000ULL,
0x00000400392b7984ULL, 0x000e620000000800ULL, 0x00000013382c7220ULL, 0x040fe40000410000ULL,
0x0000002138217220ULL, 0x040fe40000410000ULL, 0x0000001038107220ULL, 0x040fe40000410000ULL,
0x0000001138117220ULL, 0x040fe40000410000ULL, 0x0000000e382d7220ULL, 0x000fc40000410000ULL,
0x0000000f382e7220ULL, 0x040fe40000410000ULL, 0x0000000838127220ULL, 0x040fe40000410000ULL,
0x0000000938137220ULL, 0x040fe40000410000ULL, 0x0000002438247220ULL, 0x040fe40000410000ULL,
0x0000002538257220ULL, 0x040fe40000410000ULL, 0x00000022382f7220ULL, 0x000fc40000410000ULL,
0x0000000c380c7220ULL, 0x040fe40000410000ULL, 0x0000000d380d7220ULL, 0x040fe40000410000ULL,
0x0000000a380a7220ULL, 0x040fe40000410000ULL, 0x0000000b380b7220ULL, 0x040fe40000410000ULL,
0x0000002338307220ULL, 0x040fe40000410000ULL, 0x0000001c381c7220ULL, 0x000fc40000410000ULL,
0x0000001d381d7220ULL, 0x040fe40000410000ULL, 0x0000001e38317220ULL, 0x040fe40000410000ULL,
0x0000001f38327220ULL, 0x040fe20000410000ULL, 0x800000002bff7812ULL, 0x002fe20007804829ULL,
0x0000001838087220ULL, 0x040fe40000410000ULL, 0x0000001938097220ULL, 0x040fe40000410000ULL,
0x0000001a38337220ULL, 0x000fc40000410000ULL, 0x0000001b38347220ULL, 0x040fe40000410000ULL,
0x0000001638357220ULL, 0x040fe40000410000ULL, 0x0000001738367220ULL, 0x040fe40000410000ULL,
0x000000ffff167224ULL, 0x000fe400078e0020ULL, 0x00000014381e7220ULL, 0x040fe40000410000ULL,
0x00000015381f7220ULL, 0x000fc40000410000ULL, 0x000000ffff177224ULL, 0x000fe400078e0021ULL,
0x000000ffff207224ULL, 0x000fe400078e002aULL, 0x000000ffff0f7224ULL, 0x000fe400078e0010ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0011ULL, 0x000000ffff147224ULL, 0x000fe400078e0024ULL,
0x000000ffff157224ULL, 0x000fc400078e0025ULL, 0x000000ffff217224ULL, 0x000fe400078e002cULL,
0x000000ffff227224ULL, 0x000fe400078e002dULL, 0x000000ffff237224ULL, 0x000fe400078e002eULL,
0x000000ffff2a7224ULL, 0x000fe400078e002fULL, 0x0000002638267220ULL, 0x040fe40000410000ULL,
0x0000002738277220ULL, 0x000fc40000410000ULL, 0x000000ffff107224ULL, 0x000fe400078e000cULL,
0x000000ffff117224ULL, 0x000fe400078e000dULL, 0x000000ffff187224ULL, 0x000fe400078e001cULL,
0x000000ffff197224ULL, 0x000fe400078e001dULL, 0x000000ffff1a7224ULL, 0x000fe400078e0008ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0009ULL, 0x000000ffff247224ULL, 0x000fe400078e000aULL,
0x000000ffff257224ULL, 0x000fe400078e000bULL, 0x000000ffff2b7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0031ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0032ULL,
0x000000ffff2e7224ULL, 0x000fc400078e0033ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0034ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe400078e0035ULL, 0x000000ffff317224ULL, 0x000fe200078e0036ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800097305ULL, 0x0002a4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x000000090000735dULL, 0x004fe40003800000ULL, 0x0000040039097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004021d7824ULL, 0x000fe200078e00ffULL, 0x0000003b0400720cULL, 0x000fc80003f05270ULL,
0xfffffff01d097812ULL, 0x000fca00078ec0ffULL, 0x00000080001c7824ULL, 0x000fca00078e0209ULL,
0x00f400001c087984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x00000002020c7824ULL, 0x000fe400078e00ffULL, 0x00000001033c7824ULL, 0x000fc600078e0a3cULL,
0x000000060c0d7812ULL, 0x000fc800078ec0ffULL, 0x000000010d297812ULL, 0x040fe400078efcffULL,
0x000000080d337812ULL, 0x000fe400078efcffULL, 0x0000003c2900720cULL, 0x080fe40003f26070ULL,
0x000000100d297812ULL, 0x000fe400078efcffULL, 0x0000003c3300720cULL, 0x080fe40003f06070ULL,
0x0000003c2900720cULL, 0x000fc40003fc6070ULL, 0x000000110d337812ULL, 0x040fe400078efcffULL,
0x000000180d297812ULL, 0x040fe400078efcffULL, 0x0000003c0d00720cULL, 0x080fe40003f46070ULL,
0x0000003c3300720cULL, 0x080fe40003fa6070ULL, 0x0000003c2900720cULL, 0x000fe40003f66070ULL,
0x000000090d357812ULL, 0x000fc400078efcffULL, 0x000000190d337812ULL, 0x040fe400078efcffULL,
0x000000200d297812ULL, 0x000fe400078efcffULL, 0xff7fffff20207808ULL, 0x000fe40005000000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL, 0xff7fffff21217808ULL, 0x000fe40004800000ULL,
0xff7fffff0e0e7808ULL, 0x000fc40004800000ULL, 0x0000003c3500720cULL, 0x080fe40003f86070ULL,
0x0000003c3300720cULL, 0x080fe40003f46070ULL, 0x0000003c2900720cULL, 0x000fe40003f26070ULL,
0x000000210d337812ULL, 0x040fe400078efcffULL, 0x000000280d297812ULL, 0x000fe400078efcffULL,
0xff7fffff22227808ULL, 0x000fc40004000000ULL, 0xff7fffff10107808ULL, 0x000fe40004000000ULL,
0xff7fffff23237808ULL, 0x000fe40006000000ULL, 0xff7fffff11117808ULL, 0x000fe40006000000ULL,
0x0000003c3300720cULL, 0x080fe40003f06070ULL, 0x0000003c2900720cULL, 0x000fe40003f86070ULL,
0x000000290d337812ULL, 0x000fc400078efcffULL, 0x000000300d297812ULL, 0x000fe400078efcffULL,
0xff7fffff24247808ULL, 0x000fe40007000000ULL, 0xff7fffff12127808ULL, 0x000fe40007000000ULL,
0xff7fffff25257808ULL, 0x000fe40006800000ULL, 0xff7fffff13137808ULL, 0x000fe40006800000ULL,
0x0000003c3300720cULL, 0x000fc40003fc6070ULL, 0x0000003c2900720cULL, 0x000fe40003fa6070ULL,
0x000000310d337812ULL, 0x040fe400078efcffULL, 0x000000380d297812ULL, 0x040fe400078efcffULL,
0x000000390d0d7812ULL, 0x000fe400078efcffULL, 0xff7fffff26267808ULL, 0x000fe40005800000ULL,
0xff7fffff14147808ULL, 0x000fc40005800000ULL, 0xff7fffff27277808ULL, 0x000fe40005000000ULL,
0xff7fffff15157808ULL, 0x000fe40005000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL,
0xff7fffff16167808ULL, 0x000fe40004800000ULL, 0x0000003c3300720cULL, 0x080fe40003f66070ULL,
0x0000003c2900720cULL, 0x000fc40003f46070ULL, 0x0000003c0d00720cULL, 0x000fe40003f26070ULL,
0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL, 0xff7fffff17177808ULL, 0x000fe40004000000ULL,
0xff7fffff2c2c7808ULL, 0x000fe40006000000ULL, 0xff7fffff18187808ULL, 0x000fe40006000000ULL,
0xff7fffff2d2d7808ULL, 0x000fc40007000000ULL, 0xff7fffff19197808ULL, 0x000fe40007000000ULL,
0xff7fffff2e2e7808ULL, 0x000fe40006800000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40005800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL,
0xff7fffff30307808ULL, 0x000fc40005000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL,
0xff7fffff31317808ULL, 0x000fe40004800000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL,
0x0000000f080d7209ULL, 0x004fe40007810000ULL, 0x0000002009087209ULL, 0x000fe40007810000ULL,
0x0000000e0d0d7209ULL, 0x000fe40007810000ULL, 0x0000002108097209ULL, 0x000fc40007810000ULL,
0x000000100d087209ULL, 0x000fe40007810000ULL, 0x00000022090c7209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x000000230c0d7209ULL, 0x000fe40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x000000240d0c7209ULL, 0x000fc40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x000000250c0d7209ULL, 0x000fe40007810000ULL,
0x0000001409087209ULL, 0x000fe40007810000ULL, 0x000000260d0c7209ULL, 0x000fe40007810000ULL,
0x0000001508097209ULL, 0x000fe40007810000ULL, 0x000000270c0d7209ULL, 0x000fc40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x0000002a0d0c7209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x0000002b0c0d7209ULL, 0x000fe40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x0000002c0d0c7209ULL, 0x000fc40007810000ULL,
0x0000001908097209ULL, 0x000fe40007810000ULL, 0x0000002d0c0d7209ULL, 0x000fe40007810000ULL,
0x0000001a09087209ULL, 0x000fe40007810000ULL, 0x0000002e0d0c7209ULL, 0x000fe40007810000ULL,
0x0000001b08097209ULL, 0x000fe40007810000ULL, 0x0000002f0c0d7209ULL, 0x000fc40007810000ULL,
0x0000001e09087209ULL, 0x000fe40007810000ULL, 0x000000300d0c7209ULL, 0x000fe40007810000ULL,
0x0000001f08097209ULL, 0x000fe40007810000ULL, 0x000000310c337209ULL, 0x000fe20007810000ULL,
0x000018627f007947ULL, 0x000fea000b800000ULL, 0x0c401f0009087f89ULL, 0x0004e400000e0000ULL,
0x0000000809347209ULL, 0x008fe20007810000ULL, 0x000018b27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0033087f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a097f89ULL, 0x004ea800000e0000ULL,
0x0c401f000b287f89ULL, 0x000f2200000e0000ULL, 0x00000008330c7209ULL, 0x008fc60007810000ULL,
0x0c201f0034087f89ULL, 0x000ee200000e0000ULL, 0x000000090a0d7209ULL, 0x004fc60007810000ULL,
0x0c201f000c097f89ULL, 0x000ea200000e0000ULL, 0x000000280b287209ULL, 0x010fc60007810000ULL,
0x0c201f000d327f89ULL, 0x002e6800000e0000ULL, 0x0c201f0028297f89ULL, 0x00092200000e0000ULL,
0x0000000834087209ULL, 0x008fe40007810000ULL, 0x000000090c097209ULL, 0x004fe40007810000ULL,
0x000000320d0a7209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b080b7820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fc40000000000ULL, 0x00000004ff337e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe2000001080bULL,
0x0000000000057886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL, 0x0000000f000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b11117823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b12127823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b13137823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001080bULL,
0x0000000e000d7308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b15157823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b16167823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b17177823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001080bULL, 0x0000001000107308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b19197823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080bULL,
0x0000001100117308ULL, 0x000f620000000800ULL, 0x3fb8aa3b1f0b7823ULL, 0x000fe2000001080bULL,
0x0000000c0d0c723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b091f7820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001081fULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b21217823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b22227823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b23237823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001081fULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x00000010110e723eULL, 0x020fe200000010ffULL,
0x3fb8aa3b25257823ULL, 0x000fc4000001081fULL, 0x3fb8aa3b26267823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b27277823ULL, 0x100fe4000001081fULL, 0x0000002100217308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081fULL,
0x00000022000f7308ULL, 0x000be20000000800ULL, 0x3fb8aa3b2e2e7823ULL, 0x000fc4000001081fULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b30307823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b311f7823ULL, 0x000fe2000001081fULL, 0x0000002300327308ULL, 0x0023220000000800ULL,
0x3f8000003322783eULL, 0x020fe400000010ffULL, 0x00000020210d723eULL, 0x008fca00000010ffULL,
0x0000001300137308ULL, 0x000ee20000000800ULL, 0x000000ffff237224ULL, 0x002fe200078e0022ULL,
0x0000000f320f723eULL, 0x010fcc00000010ffULL, 0x0000001400147308ULL, 0x000fe20000000800ULL,
0x000000220c34723cULL, 0x000fe200000418ffULL, 0x000000121310723eULL, 0x008fcc00000010ffULL,
0x0000001500157308ULL, 0x000e700000000800ULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000002500257308ULL, 0x000ee20000000800ULL, 0x000000141512723eULL, 0x002fce00000010ffULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x000000242511723eULL, 0x008fce00000010ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000262713723eULL, 0x002fce00000010ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000221034723cULL, 0x000fee0000041834ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000001900197308ULL, 0x000ee20000000800ULL, 0x000000161714723eULL, 0x002fce00000010ffULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002b002b7308ULL, 0x000e620000000800ULL,
0x000000181916723eULL, 0x008fe200000010ffULL, 0x0000000fff197424ULL, 0x000fe200078e00ffULL,
0xfffffffc02187812ULL, 0x000fc800078ec0ffULL, 0x0000001819247219ULL, 0x000fe200000006ffULL,
0x0000002c002c7308ULL, 0x000fe60000000800ULL, 0x00000000242173a1ULL, 0x000ee200000e8000ULL,
0x00000000240473c4ULL, 0x000f280000004000ULL, 0x0000002d002d7308ULL, 0x000f620000000800ULL,
0x0000002a2b15723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x0000002c2d17723eULL, 0x020fce00000010ffULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000524ff7c12ULL, 0x008fe2000f804021ULL, 0x000000221434723cULL, 0x000fec0000041834ULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000000b000b7308ULL, 0x000ee20000000800ULL,
0x0000001a1b18723eULL, 0x002fce00000010ffULL, 0x0000002e002e7308ULL, 0x000ff00000000800ULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x0000001e0b1a723eULL, 0x008fe400000010ffULL,
0x00000028290b7209ULL, 0x004fca0007810000ULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000ea20000000800ULL, 0x0000002e2f19723eULL, 0x002fe400000010ffULL,
0x000000301f1b723eULL, 0x004fce00000010ffULL, 0x00000022182c723cULL, 0x000fe20000041834ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x000014a204008947ULL, 0x010fde000b800000ULL,
0x001c1fff2c207589ULL, 0x0002a400000e0000ULL, 0x00000000241f73a1ULL, 0x000ee200000e8000ULL,
0x00000000240473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x0000000524ff7c12ULL, 0x008fda000f80401fULL, 0x000014c204008947ULL, 0x010fea000b800000ULL,
0x001c1fff2e217589ULL, 0x00072800000e0000ULL, 0x001c1fff01227589ULL, 0x00066800000e0000ULL,
0x001c1fff23237589ULL, 0x0006a400000e0000ULL, 0x00000002ff1e7819ULL, 0x000fe40000011602ULL,
0x0000000c1d3f7812ULL, 0x000fc400078ec0ffULL, 0x000000071e1f7812ULL, 0x040fe200078ec0ffULL,
0x000000081e287824ULL, 0x040fe200078e00ffULL, 0x0000001eff267212ULL, 0x000fe200078e33ffULL,
0x000000081e247824ULL, 0x00afe200078e00ffULL, 0x0000000302ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081e337824ULL, 0x040fe200078e00ffULL, 0x000000081e1e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff828257812ULL, 0x100fe400078ee21fULL, 0x0000000124277812ULL, 0x100fe200078ef61fULL,
0x000000081e4b7824ULL, 0x000fe200078e00ffULL, 0x0000000224297812ULL, 0x100fe200078ef61fULL,
0x000000081e287824ULL, 0x000fe200078e00ffULL, 0x00000003242b7812ULL, 0x000fc400078ef61fULL,
0x00000004242d7812ULL, 0x140fe400078ef61fULL, 0x00000005242f7812ULL, 0x140fe400078ef61fULL,
0x0000000624317812ULL, 0x000fe200078ef61fULL, 0x000000081e247824ULL, 0x040fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe400078ee226ULL, 0x0000001eff267212ULL, 0x000fe400078e33ffULL,
0x000000071e1f7812ULL, 0x000fc400078ec0ffULL, 0x00009000001e7811ULL, 0x000fe400078e58ffULL,
0xfffffff828357812ULL, 0x100fe400078ee21fULL, 0x0000000124377812ULL, 0x140fe200078ef61fULL,
0x00000010251d7824ULL, 0x100fe200078e021eULL, 0x0000000224417812ULL, 0x140fe200078ef61fULL,
0x000000102d287824ULL, 0x100fe200078e021eULL, 0x0000000324437812ULL, 0x040fe200078ef61fULL,
0x000000013f1d7824ULL, 0x000fe200078e021dULL, 0x0000000424457812ULL, 0x140fe200078ef61fULL,
0x000000102f2a7824ULL, 0x100fe200078e021eULL, 0x0000000524477812ULL, 0x140fe200078ef61fULL,
0x00000010312c7824ULL, 0x100fe200078e021eULL, 0x0000000624497812ULL, 0x000fe200078ef61fULL,
0x00000010271f7824ULL, 0x000fe200078e021eULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee226ULL,
0x0000001029247824ULL, 0x100fe200078e021eULL, 0x0000000c1d007388ULL, 0x0003e20000000800ULL,
0x000000102b267824ULL, 0x000fc400078e021eULL, 0x000000013f1f7824ULL, 0x040fe400078e021fULL,
0x000000013f257824ULL, 0x000fe400078e0224ULL, 0x00000010332e7824ULL, 0x000fe200078e021eULL,
0x0000000e1f007388ULL, 0x0007e20000000800ULL, 0x000000013f277824ULL, 0x000fe400078e0226ULL,
0x0000001035307824ULL, 0x000fe200078e021eULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x000000013f297824ULL, 0x000fc400078e0228ULL, 0x0000001037317824ULL, 0x000fe200078e021eULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x000000013f2b7824ULL, 0x000fe400078e022aULL,
0x0000001041327824ULL, 0x000fe200078e021eULL, 0x0000001429007388ULL, 0x0007e20000000800ULL,
0x000000013f2d7824ULL, 0x000fe400078e022cULL, 0x0000001043337824ULL, 0x000fe200078e021eULL,
0x000000162b007388ULL, 0x0007e20000000800ULL, 0x000000013f2f7824ULL, 0x000fc400078e022eULL,
0x0000001045347824ULL, 0x100fe200078e021eULL, 0x000000182d007388ULL, 0x0007e20000000800ULL,
0x0000001047357824ULL, 0x100fe400078e021eULL, 0x0000001049367824ULL, 0x100fe200078e021eULL,
0x0000001a2f007388ULL, 0x0007e20000000800ULL, 0x000000104b377824ULL, 0x000fe400078e021eULL,
0x000000013f307824ULL, 0x040fe400078e0230ULL, 0x000000013f1e7824ULL, 0x000fc400078e0231ULL,
0x000000013f327824ULL, 0x040fe200078e0232ULL, 0x0000000d30007388ULL, 0x0007e20000000800ULL,
0x000000013f0c7824ULL, 0x042fe400078e0233ULL, 0x000000013f347824ULL, 0x040fe200078e0234ULL,
0x0000000f1e007388ULL, 0x0007e20000000800ULL, 0x000000013f247824ULL, 0x040fe400078e0235ULL,
0x000000013f367824ULL, 0x040fe200078e0236ULL, 0x0000001132007388ULL, 0x0007e20000000800ULL,
0x000000013f267824ULL, 0x000fc600078e0237ULL, 0x000000130c007388ULL, 0x0007e80000000800ULL,
0x0000001534007388ULL, 0x0007e80000000800ULL, 0x0000001724007388ULL, 0x0007e80000000800ULL,
0x0000001936007388ULL, 0x0007e80000000800ULL, 0x0000001b26007388ULL, 0x0007e80000000800ULL,
0x00f000081c008388ULL, 0x0007e80000000c00ULL, 0x00f200201c008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000003aff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008003aff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010003aff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030004047a10ULL, 0x000fe20007ffe0ffULL,
0x000018003aff7f8cULL, 0x0003e6000c80043fULL, 0x000000050400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffba6000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff147807ULL, 0x010fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00015530001a7802ULL, 0x000fe40000000f00ULL,
0x000010b000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0019ULL,
0xfffec17000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00015590001a7802ULL, 0x000fe40000000f00ULL,
0x0000105000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0019ULL,
0xfffec1a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e0010ULL,
0x0001560000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000fa000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0032ULL, 0xfffec1f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x002fe200078e0010ULL, 0x0001567000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x00000f3000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0032ULL,
0xfffec1b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e0012ULL,
0x000156e000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x00000ec000007944ULL, 0x004fea0003c00000ULL,
0x000000ffffad7224ULL, 0x004fe200078e0032ULL, 0xfffec51000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x002fe200078e002aULL, 0x0001575000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000e5000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffffa87224ULL, 0x004fe200078e0032ULL,
0xfffec4d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x010fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x000157b0001a7802ULL, 0x000fc40000000f00ULL,
0x00000e3000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff117224ULL, 0x000fe200078e0019ULL,
0xfffeee8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00015810001a7802ULL, 0x000fc40000000f00ULL,
0x00000dd000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff117224ULL, 0x000fe200078e0019ULL,
0xfffeeeb000007947ULL, 0x000fea000383ffffULL, 0x0000001fff357424ULL, 0x008fe200078e00ffULL,
0x0001587000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000d3000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e0032ULL,
0xfffeef2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x00afe200078e002aULL,
0x000158e000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x00000cc000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0032ULL, 0xfffeefd000007947ULL, 0x000fea000383ffffULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x0001594000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x00000c6000007944ULL, 0x004fea0003c00000ULL,
0x000000ffffb97224ULL, 0x004fe200078e0032ULL, 0xfffef29000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x002fe200078e002aULL, 0x000159b000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x00000bf000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffffbc7224ULL, 0x004fe200078e0032ULL,
0xfffef24000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x002fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00015a10001a7802ULL, 0x000fc40000000f00ULL,
0x00000bd000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0019ULL,
0xffff17d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00015a70001a7802ULL, 0x000fc40000000f00ULL,
0x00000b7000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0019ULL,
0xffff180000007947ULL, 0x000fea000383ffffULL, 0x0000001fff357424ULL, 0x002fe200078e00ffULL,
0x00015ad000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000ad000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e0032ULL,
0xffff187000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x002fe200078e002aULL,
0x00015b4000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x00000a6000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0032ULL, 0xffff192000007947ULL, 0x000fea000383ffffULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x00015ba000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x00000a0000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff237224ULL, 0x004fe200078e0032ULL, 0xffff1bd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x002fe200078e002aULL, 0x00015c1000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000099000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0032ULL,
0xffff1b8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x010fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00015c70001a7802ULL, 0x000fc40000000f00ULL,
0x0000097000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0019ULL,
0xffff413000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20004000000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00015cd0001a7802ULL, 0x000fc40000000f00ULL,
0x0000091000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0019ULL,
0xffff416000007947ULL, 0x000fea000383ffffULL, 0x0000001fff357424ULL, 0x008fe200078e00ffULL,
0x00015d3000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000087000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e0032ULL,
0xffff41d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x00afe200078e002aULL,
0x00015da000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x0000080000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0032ULL, 0xffff428000007947ULL, 0x000fea000383ffffULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x00015e0000307802ULL, 0x000fe20000000f00ULL,
0xffffffffff367424ULL, 0x000fe400078e00ffULL, 0x000007a000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff957224ULL, 0x004fe200078e0032ULL, 0xffff454000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x002fe200078e002aULL, 0x00015e7000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fe400078e00ffULL,
0x0000073000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0032ULL,
0xffff44f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff297224ULL, 0x000fe200078e0009ULL,
0x00015ef0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x000fc400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x0000067000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0029ULL,
0xffffe73000007947ULL, 0x000fea000383ffffULL, 0x000000ffff297224ULL, 0x000fe200078e0033ULL,
0x00015f70000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x002fe400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x000005f000007944ULL, 0x004fea0003c00000ULL, 0x0000002933367209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e000aULL, 0x00015fe0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x002fc400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fe400078e00ffULL, 0x0000058000007944ULL, 0x000fea0003c00000ULL,
0x000000290a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e000bULL,
0x00016050000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x002fe400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x0000051000007944ULL, 0x000fea0003c00000ULL, 0x000000290b287209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e0034ULL, 0x000160c0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fc400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fe400078e00ffULL, 0x000004a000007944ULL, 0x000fea0003c00000ULL,
0x0000002934087209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e0036ULL,
0x00016130000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fe400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x0000002936097209ULL, 0x004fe20007810000ULL,
0x000000ffff297224ULL, 0x000fe200078e000aULL, 0x000161a0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x002fc400078e00ffULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fe400078e00ffULL, 0x000003c000007944ULL, 0x000fea0003c00000ULL,
0x000000290a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e0028ULL,
0x00016210000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff327424ULL, 0x002fe400078e00ffULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x0000035000007944ULL, 0x000fea0003c00000ULL, 0xffffe51000007947ULL, 0x000fea000383ffffULL,
0x000000ffff337224ULL, 0x000fe200078e002cULL, 0x0001628000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff347224ULL, 0x000fc400078e00ffULL, 0x00001c1fff357424ULL, 0x000fe400078e00ffULL,
0x000000ffff367224ULL, 0x000fe400078e0024ULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff207224ULL, 0x004fe200078e0032ULL, 0xffffeaf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff337224ULL, 0x002fe200078e002eULL, 0x0001630000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff347224ULL, 0x000fe400078e00ffULL, 0x00001c1fff357424ULL, 0x000fe400078e00ffULL,
0x000000ffff367224ULL, 0x000fe400078e0024ULL, 0x000002a000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff347224ULL, 0x002fe200078e00ffULL, 0x0001636000307802ULL, 0x000fe20000000f00ULL,
0x00001c1fff357424ULL, 0x000fc400078e00ffULL, 0x000000ffff367224ULL, 0x000fe400078e0024ULL,
0x000000ffff217224ULL, 0x004fe400078e0032ULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff367224ULL, 0x002fe200078e0024ULL, 0x000163c000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff347224ULL, 0x000fe400078e00ffULL, 0x00001c1fff357424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x004fe400078e0032ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff237224ULL, 0x004fe200078e0032ULL, 0xffffea3000007947ULL, 0x000fea000383ffffULL,
0x0180000006027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000000600028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff077807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000207ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000006067812ULL, 0x002fe400078ec0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000207ff7212ULL, 0x000fda000780c0ffULL,
0x0080000006020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0006ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000600027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x006fe400078e0008ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffe9aa006007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003c00007348ULL, 0x000fe80003800000ULL,
0x0c00003229297389ULL, 0x0002a200000e0035ULL, 0xfffe9a600c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff317424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0000003433327389ULL, 0x0002a200000e0035ULL, 0xfffe9a2030007950ULL, 0x000fea0003c3ffffULL,
0x000000011400780cULL, 0x000fe20003f05070ULL, 0x0000001900007348ULL, 0x000fe80003800000ULL,
0x00000000ff157424ULL, 0x000fd000078e00ffULL, 0x0000000000147806ULL, 0x000fc800040e0100ULL,
0x0000001914197212ULL, 0x000fe200078ec0ffULL, 0x000000ffff147224ULL, 0x000fc800078e001aULL,
0xfffe99b014007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000358ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000938ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x0000000000000884ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000124cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001270ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001280ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000012a0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001330ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001338ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001348ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001500ULL, 0x0000000000016700ULL, 0xfa00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017c00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000017c10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017c10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000018090ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001330ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000168d0ULL, 0x00000000000168d0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000018090ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin_len = 98672;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
