/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_16_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000011ef0ULL, 0x0000000000011a70ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000010920ULL, 0x0000000000000260ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000010b80ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001092000000000ULL, 0x0000480400000000ULL, 0x0400288080810c00ULL, 0x00000000000041f4ULL,
0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8016288080840828ULL, 0x0000000310288082ULL,
0x8084920000000000ULL, 0x0000000022002880ULL, 0x00000034ffffffffULL, 0x0000006800000000ULL,
0x0001092000000000ULL, 0x0000026000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808084ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL,
0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL,
0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x00008c2000183104ULL, 0x0000fb5000009260ULL, 0x0000fb700000fb60ULL,
0x00c429040000fb80ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500001605000025ULL, 0x0500002505000016ULL, 0x0500002505000025ULL,
0x0500003405000034ULL, 0x0500003405000034ULL, 0x0500003405000034ULL, 0x0500003405000034ULL,
0x0500003405000034ULL, 0x00c4280405000034ULL, 0x000000c0000000a0ULL, 0x00001e9000001dc0ULL,
0x00001f2000001ee0ULL, 0x0000248000002440ULL, 0x000048e000004820ULL, 0x0000498000004960ULL,
0x00004d2000004cf0ULL, 0x00006c6000006c40ULL, 0x00006fe000006fd0ULL, 0x0000926000008c20ULL,
0x000097f0000097c0ULL, 0x00009e9000009e60ULL, 0x0000f4600000f450ULL, 0x0000f4800000f470ULL,
0x0000f4d00000f4b0ULL, 0x0000f5000000f4f0ULL, 0x0000fb600000fb40ULL, 0x0000fbb00000fb70ULL,
0x0000fbd00000fbc0ULL, 0x000104c000010430ULL, 0x0001058000010520ULL, 0x00010650000105f0ULL,
0x00010710000106b0ULL, 0x00010840000107a0ULL, 0x02703904000108e0ULL, 0x000000ff00000170ULL,
0x000401000001b600ULL, 0x0000000200000260ULL, 0x003f01000001b608ULL, 0x00000002000002d0ULL,
0x003f01000001b610ULL, 0x00000002000004b0ULL, 0x003f01000001b648ULL, 0x00000000000005c0ULL,
0x003f01000001b668ULL, 0x000000ff000008b0ULL, 0x000401070001b600ULL, 0x000000ff00000a80ULL,
0x000401010001b610ULL, 0x000000ff000011a0ULL, 0x000d010700000000ULL, 0x000000ff000011d0ULL,
0x0007010100000020ULL, 0x000000ff00001480ULL, 0x0007010600000020ULL, 0x000000ff000017d0ULL,
0x0007010a00000020ULL, 0x0000000a00001c20ULL, 0x000d010700000000ULL, 0x0000002400001c60ULL,
0x000d010600000000ULL, 0x000000ff00001cb0ULL, 0x000d010affffffc0ULL, 0x0000002400002190ULL,
0x000d010a00000000ULL, 0x000000ff00004150ULL, 0x0007010100000020ULL, 0x000000ff00004170ULL,
0x001501010001b610ULL, 0x000000ff00004200ULL, 0x0007010600000020ULL, 0x000000ff00004280ULL,
0x0007010a00000020ULL, 0x000000ff00004730ULL, 0x0004010700000000ULL, 0x0000000a00004760ULL,
0x000d010600000000ULL, 0x000000ff00004790ULL, 0x000d010affffffe0ULL, 0x0000000a00004bd0ULL,
0x000d010a00000000ULL, 0x000000ff00006260ULL, 0x0007010100000020ULL, 0x000000ff000062a0ULL,
0x001501010001b630ULL, 0x000000ff0000c0a0ULL, 0x0005010a0001b600ULL, 0x000000ff0000c2a0ULL,
0x000501010001b600ULL, 0x000000ff0000c2c0ULL, 0x0005010a0001b600ULL, 0x000000ff0000ec10ULL,
0x0007010a0001b610ULL, 0x000000ff0000fef0ULL, 0x000701010001b608ULL, 0x000000270000ff40ULL,
0x003f010a00000020ULL, 0x0000000b0000ffc0ULL, 0x003f010affffffc0ULL, 0x0000000b00010050ULL,
0x003f010a00000000ULL, 0x00000017000100e0ULL, 0x003f010a00000020ULL, 0x0000000500010160ULL,
0x003f010affffffe0ULL, 0x00000005000101f0ULL, 0x003f010a00000000ULL, 0x0000000400010260ULL,
0x003f010a0001b600ULL, 0x00000007000102f0ULL, 0x003f010a0001b600ULL, 0x0000000f00010370ULL,
0x003f010a0001b610ULL, 0x00141c0400053803ULL, 0x0000a9200000a4c0ULL, 0x0000c3600000c2e0ULL,
0x000c05040000ff10ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0050190300000000ULL,
0x0000000f00080a04ULL, 0x0004360400500210ULL, 0x0000000000000008ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x0000000000000000ULL, 0x00000000000000ccULL, 0x0000000e00000002ULL, 0x0000000000010920ULL,
0x0000000000000044ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000a5ULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000057919ULL, 0x000eae0000002100ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x0000000000087919ULL, 0x000f220000002300ULL, 0x0000000000037919ULL, 0x000f2a0000002200ULL,
0x00000000000779c3ULL, 0x000f620000002600ULL, 0x00000000005d7919ULL, 0x000f620000002700ULL,
0x00000004ff617e24ULL, 0x008fe2000f8e00ffULL, 0x00000005ff027819ULL, 0x004fcc0000011605ULL,
0x00001fff02027589ULL, 0x000ea200000e0000ULL, 0x0000000108007824ULL, 0x010fc600078e0203ULL,
0x00001fff08087589ULL, 0x000ee200000e0000ULL, 0x0000008000007824ULL, 0x000fca00078e0205ULL,
0x000000ff0000720cULL, 0x040fe40003f05270ULL, 0x000000030000780cULL, 0x000fe40003f44070ULL,
0x00000000021272caULL, 0x004fd200000e0000ULL, 0x0000000000240947ULL, 0x022fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01b60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000030000137ab9ULL, 0x000fe20000000800ULL, 0x000001a000007945ULL, 0x000fe80003800000ULL,
0x0000000000602947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7fff000000057882ULL, 0x000fc60000000000ULL,
0x0000000400027c11ULL, 0x000fe2000f8e20ffULL, 0x001fffc000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000f240000000000ULL, 0x01b60804063f75b2ULL, 0x0043300008000100ULL,
0xfffffffd00e81947ULL, 0x010fea000393ffffULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x001fff8000047882ULL, 0x002fe20000000000ULL,
0x7ffe000000057882ULL, 0x000fd60000000000ULL, 0x00000000020612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000f240000000000ULL, 0x01b61004063f75b2ULL, 0x0043300008000100ULL,
0xfffffffd00e81947ULL, 0x010fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000007f0000780cULL, 0x040fe20003f04070ULL, 0x00008c00ff067b82ULL, 0x000f220000000a00ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x000000010000780cULL, 0x000fe40003f84070ULL,
0x000000ff0800720cULL, 0x008fd00003f65270ULL, 0x0000000000038919ULL, 0x000ee20000008800ULL,
0x0000040000028802ULL, 0x000fc80000000f00ULL, 0x0000065403058816ULL, 0x008fe20000000002ULL,
0xff317217ff038424ULL, 0x000fc800078e00ffULL, 0x0000000400028824ULL, 0x000fca00078e0205ULL,
0x01b4000302008388ULL, 0x0007e20000000800ULL, 0x0000000000382947ULL, 0x010fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000400027c11ULL, 0x008fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fca0000000000ULL,
0x00000000020612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x01b64804063f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x002e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000400007c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x00cfca0000000000ULL, 0x00000000000612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x01b66804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00008400ff0e7b82ULL, 0x000f220000000800ULL, 0x00008200000e7ab9ULL, 0x000fe20000000a00ULL,
0x000000045d067825ULL, 0x000fcc00078e0006ULL, 0x0000000000007b1dULL, 0x004fec0000010000ULL,
0x0000000000983947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x000ea20000000000ULL,
0x00008800ff047b82ULL, 0x000f620000000a00ULL, 0x0000000212067899ULL, 0x002fe2000800063fULL,
0x000000100e007824ULL, 0x010fe200078e00ffULL, 0x0000000407047899ULL, 0x000fca000800063fULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000000400007e24ULL, 0x000fe2000f8e025dULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000060f097c11ULL, 0x004fe2000f8fe0ffULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x00000007090a7812ULL, 0x040fe200078ec0ffULL,
0x00000002090b7836ULL, 0x000fe40000000000ULL, 0x0000000100037824ULL, 0x048fe200078e0209ULL,
0x0000000f0a0a7812ULL, 0x000fe200078e780fULL, 0x00000001000d7824ULL, 0x000fe200078e020bULL,
0x000000070b0c7812ULL, 0x000fe200078ec0ffULL, 0x000000100f007824ULL, 0x000fe400078e00ffULL,
0x0000010003027825ULL, 0x020fe200078e0004ULL, 0x0000000f0c0c7812ULL, 0x000fc600078e780fULL,
0x000001000d047825ULL, 0x000fe200078e0004ULL, 0x000000f0000d7812ULL, 0x000fc600078ec0ffULL,
0x00000010090a7824ULL, 0x000fe200078e020aULL, 0x0000000d02027210ULL, 0x000fe20007f1e0ffULL,
0x000000100b0c7824ULL, 0x000fe200078e020cULL, 0x0000000d04047210ULL, 0x000fe40007f3e0ffULL,
0x000000040a097c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x000000040c0b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff057224ULL, 0x000fc600008e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000b901c4eULL,
0x00000000040b7faeULL, 0x0003e2000b901c4eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0001b60004047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x0000000e065f7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x000000ff5f5e7836ULL, 0x004fca0000000000ULL,
0x00000008ff5e7819ULL, 0x000fce000001165eULL, 0x0000009c00fc8947ULL, 0x000fea0003800000ULL,
0x00000000004d7919ULL, 0x000ea20000000000ULL, 0x00000000000579c3ULL, 0x002e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x00000005120b7899ULL, 0x000fe2000800063fULL,
0x0000000161037836ULL, 0x008fe20000000000ULL, 0x0000000112147892ULL, 0x000fe2000f8ec03fULL,
0x00000002ff027424ULL, 0x000fe200078e00ffULL, 0x000000200b0c7892ULL, 0x000fe2000f8ec03fULL,
0x000000025d5d7824ULL, 0x000fe200078e00ffULL, 0x0000005e0300720cULL, 0x000fe20003f06070ULL,
0x000000070e007c36ULL, 0x010fc80008000000ULL, 0x0000000e5d5d7224ULL, 0x000fe200078e0200ULL,
0x00000654050a7896ULL, 0x002fe40008000004ULL, 0x000000013f057899ULL, 0x000fe40008011612ULL,
0x0000000a12047291ULL, 0x000fe4000f8e203fULL, 0x0000000a05067291ULL, 0x000fe2000f8e703fULL,
0x00000003ff057819ULL, 0x004fe4000001164dULL, 0x0000000561047c11ULL, 0x000fe2000f8e10ffULL,
0x0001300006077890ULL, 0x000fc4000fffe03fULL, 0x0000000405097836ULL, 0x040fe20000000000ULL,
0x01b61002ffff79a7ULL, 0x0003e20008500004ULL, 0x0000000c05067c36ULL, 0x000fe20008000000ULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x0000000c09087c36ULL, 0x000fe40008000000ULL,
0x00000008050d7836ULL, 0x000fe20000000000ULL, 0x0000004d06007212ULL, 0x080fe200078e3cffULL,
0x0000000808077824ULL, 0x040fe200078e00ffULL, 0x0000004d08027212ULL, 0x002fe200078e3cffULL,
0x0000000806037824ULL, 0x000fc400078e00ffULL, 0x0000000c0d0a7c36ULL, 0x000fe20008000000ULL,
0xfffffff807147812ULL, 0x000fe200078ee202ULL, 0x0000001005157836ULL, 0x000fe20000000000ULL,
0xfffffff803127812ULL, 0x000fe200078ee200ULL, 0x000000080a077824ULL, 0x040fe200078e00ffULL,
0x0000004d0a007212ULL, 0x080fe200078e3cffULL, 0x0000000c150e7c36ULL, 0x000fe40008000000ULL,
0x0000000c05117836ULL, 0x000fe20000000000ULL, 0xfffffff807167812ULL, 0x000fe200078ee200ULL,
0x000000080e107824ULL, 0x040fe200078e00ffULL, 0x0000004d0e037212ULL, 0x000fe200078e3cffULL,
0x0000000c110c7c36ULL, 0x000fc40008000000ULL, 0x0000004004007824ULL, 0x000fe200078e00ffULL,
0xfffffff810197812ULL, 0x000fe200078ee203ULL, 0x000000080c0b7824ULL, 0x040fe200078e00ffULL,
0x0000004d0c027212ULL, 0x000fe200078e3cffULL, 0x00000014051b7836ULL, 0x000fe20000000000ULL,
0x000000005f037248ULL, 0x000fe20007fe0000ULL, 0x00000018051f7836ULL, 0x040fe20000000000ULL,
0xfffffff80b187812ULL, 0x000fe200078ee202ULL, 0x0000001c05237836ULL, 0x000fe20000000000ULL,
0x0000000719197c11ULL, 0x000fe2000f8e20ffULL, 0x0000000103047824ULL, 0x000fc400078e0a00ULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0x000000045d007c24ULL, 0x000fe2000f8e0200ULL,
0x0001b6480a047890ULL, 0x000fe2000fffe03fULL, 0x0000004004047807ULL, 0x000fe20000000000ULL,
0x0000000c1b107c36ULL, 0x000fe40008000000ULL, 0x0000000c1f1a7c36ULL, 0x000fe20008000000ULL,
0x0000000c04047c48ULL, 0x000fe2000ffe0000ULL, 0x0000000c231c7c36ULL, 0x000fe20008000000ULL,
0x00000004050d7291ULL, 0x000fe2000f8e203fULL, 0x0000000100077824ULL, 0x000fe200078e0206ULL,
0x0000004d10067212ULL, 0x040fe200078e3cffULL, 0x0000000810277824ULL, 0x000fc400078e00ffULL,
0x00000001000b7824ULL, 0x000fe200078e0208ULL, 0x0000004d1a087212ULL, 0x080fe200078e3cffULL,
0x00000001000f7824ULL, 0x000fe200078e020aULL, 0x0000004d1c0a7212ULL, 0x000fe200078e3cffULL,
0x0000000100137824ULL, 0x040fe400078e020cULL, 0x0000000100177824ULL, 0x040fe400078e020eULL,
0x00000001001d7824ULL, 0x040fe400078e0210ULL, 0x0000000100217824ULL, 0x000fc400078e021aULL,
0x0000000100257824ULL, 0x000fe400078e021cULL, 0x8000000c04007c36ULL, 0x000fe40008000000ULL,
0x000000081a297824ULL, 0x000fe200078e00ffULL, 0xfffffff8271a7812ULL, 0x000fe200078ee206ULL,
0x000000104d277824ULL, 0x000fe200078e00ffULL, 0x000000000500720cULL, 0x080fe20003f86070ULL,
0x0000008007047825ULL, 0x102fe200078e0002ULL, 0x000000000900720cULL, 0x000fe40003fa6070ULL,
0x0000007027277812ULL, 0x000fe200078ec0ffULL, 0x000000081c2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8291c7812ULL, 0x000fe200078ee208ULL, 0x000000800b067825ULL, 0x000fe200078e0002ULL,
0x00000027040c7210ULL, 0x000fc40007f7e0ffULL, 0xfffffff82b1e7812ULL, 0x000fe200078ee20aULL,
0x00000080130a7825ULL, 0x100fe200078e0002ULL, 0x00000027060e7210ULL, 0x000fe40007fde0ffULL,
0x000000000d00720cULL, 0x080fe20003f06070ULL, 0x000000800f087825ULL, 0x000fe200078e0002ULL,
0x000000001100720cULL, 0x080fe40003f26070ULL, 0x0000000712137c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e0607ULL, 0x000000270a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e0605ULL, 0x0000002708107210ULL, 0x000fe20007f7e0ffULL,
0x0000008017047825ULL, 0x000fe200078e0002ULL, 0x000000001500720cULL, 0x000fc40003f46070ULL,
0x0000000714157c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x0000002704047210ULL, 0x000fe20007fde0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c137faeULL, 0x0003e2000e101c4eULL,
0x0000008021087825ULL, 0x100fe200078e0002ULL, 0x000000001b00720cULL, 0x080fe40003f66070ULL,
0x000000000e157faeULL, 0x0005e2000e901c4eULL, 0x000000801d067825ULL, 0x000fe200078e0002ULL,
0x000000001f00720cULL, 0x000fc40003fa6070ULL, 0x0000000716177c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x0000002708087210ULL, 0x000fe20007fde0ffULL,
0x0000008025027825ULL, 0x000fe200078e0002ULL, 0x0000002706067210ULL, 0x000fe20007f9e0ffULL,
0x0000000010177faeULL, 0x000fe2000c101c4eULL, 0x00000007180d7c11ULL, 0x002fe2000f8e20ffULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x000000002300720cULL, 0x000fe20003fc6070ULL,
0x000000ffff077224ULL, 0x000fe200020e0607ULL, 0x0000002702027210ULL, 0x000fe20007f9e0ffULL,
0x000000000a0d7faeULL, 0x000fe2000c901c4eULL, 0x000000071a0f7c11ULL, 0x004fe2000f8e20ffULL,
0x00000001ff007424ULL, 0x000fe200078e00ffULL, 0x000000071c137c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff037224ULL, 0x000fe200020e0603ULL, 0x000000071e157c11ULL, 0x000fe2000f8e20ffULL,
0x0000000004197faeULL, 0x0007e2000d101c4eULL, 0x0000005e6100720cULL, 0x000fe20003f06070ULL,
0x0000000405077291ULL, 0x000fc4000f8e183fULL, 0x00000000060f7faeULL, 0x0007e8000d901c4eULL,
0x0000000008137faeULL, 0x0007e8000e901c4eULL, 0x0000000002157faeULL, 0x0007e2000f101c4eULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a4dULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00002000ffff79a7ULL, 0x0003e20008500007ULL,
0xff317217ff5c7424ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff5b7224ULL, 0x000fe200078e00ffULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fc4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x008fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fc4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000005400b80947ULL, 0x002fec0003800000ULL, 0xff317217ff5c7424ULL, 0x000fe200078e00ffULL,
0x00007610ff5a7816ULL, 0x000fe2000000005aULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x00007610ff597816ULL, 0x000fe20000000059ULL, 0x0000000214107891ULL, 0x000fe2000f8e103fULL,
0x00007610ff587816ULL, 0x000fe20000000058ULL, 0x0000000205117890ULL, 0x000fe2000fffe03fULL,
0x0000003f00047c82ULL, 0x000fd60008000000ULL, 0xffffffc00b087892ULL, 0x000fcc000f8ec03fULL,
0x0000000861047c11ULL, 0x000fc8000f8e40ffULL, 0x0000005f0400720cULL, 0x000fda0003f06070ULL,
0x0000005400740947ULL, 0x000fea0003800000ULL, 0x0000ffff5a007812ULL, 0x000fe200078ec0ffULL,
0x0000000161037836ULL, 0x000fe20000000000ULL, 0x00000003ff4c7819ULL, 0x000fe2000001164dULL,
0x00008a00ff6c7b82ULL, 0x000e620000000a00ULL, 0x0000888000247816ULL, 0x000fe200000000ffULL,
0x0000008004047836ULL, 0x000fe20000000000ULL, 0x0000005e0300720cULL, 0x000fe20003f06070ULL,
0x000000044c487836ULL, 0x000fe20000000000ULL, 0x00008e0000177ab9ULL, 0x000fe20000000800ULL,
0x8000000024247824ULL, 0x000fe400078e00ffULL, 0x000000084c457836ULL, 0x000fc40000000000ULL,
0x00002024ff0075a7ULL, 0x000ea20008020047ULL, 0x0000000c48477c36ULL, 0x000fe40008000000ULL,
0x0000000c45447c36ULL, 0x000fe40008000000ULL, 0x0000000c4c427836ULL, 0x040fe20000000000ULL,
0x0000004d47467212ULL, 0x0c0fe200078e3cffULL, 0x0000000c4c4b7c36ULL, 0x000fe20008000000ULL,
0x0000004d44437212ULL, 0x080fe200078e3cffULL, 0x000000104c0f7836ULL, 0x000fe40000000000ULL,
0x0000000847037824ULL, 0x000fe200078e00ffULL, 0x0000004d4b497212ULL, 0x000fe200078e3cffULL,
0x0000000844067824ULL, 0x000fc400078e00ffULL, 0x0000000c42417c36ULL, 0x000fe20008000000ULL,
0xfffffff803467812ULL, 0x000fe200078ee246ULL, 0x000000084b027824ULL, 0x000fe200078e00ffULL,
0xfffffff806437812ULL, 0x000fe200078ee243ULL, 0x0000000c0f0e7c36ULL, 0x000fe20008000000ULL,
0x0000004d41407212ULL, 0x0c0fe200078e3cffULL, 0x000000144c007836ULL, 0x000fe20000000000ULL,
0xfffffff802497812ULL, 0x000fe200078ee249ULL, 0x0000000841037824ULL, 0x000fe200078e00ffULL,
0x0000004d0e0d7212ULL, 0x040fe200078e3cffULL, 0x000000080e067824ULL, 0x000fc400078e00ffULL,
0x0000000c00027c36ULL, 0x000fe20008000000ULL, 0xfffffff803407812ULL, 0x000fe200078ee240ULL,
0x000000175d0c7c24ULL, 0x000fe2000f8e0204ULL, 0xfffffff8060d7812ULL, 0x000fe200078ee20dULL,
0x0000000802067824ULL, 0x040fe200078e00ffULL, 0x000000045f037248ULL, 0x000fe20007fe0000ULL,
0x000000104d4a7824ULL, 0x000fe200078e00ffULL, 0x0000004d02057212ULL, 0x000fe200078e3cffULL,
0x000000014b0b7824ULL, 0x000fe400078e020cULL, 0x0000000103267824ULL, 0x000fe200078e0a04ULL,
0xfffffff806037812ULL, 0x000fe200078ee205ULL, 0x0000001c4c057836ULL, 0x000fe20000000000ULL,
0x000000704a4a7812ULL, 0x000fe200078ec0ffULL, 0x000000184c047836ULL, 0x000fc40000000000ULL,
0x0000000c05077c36ULL, 0x000fe40008000000ULL, 0x0000000c04067c36ULL, 0x000fe40008000000ULL,
0x0000000807107824ULL, 0x040fe200078e00ffULL, 0x0000004d07097212ULL, 0x080fe200078e3cffULL,
0x000000800b0a7825ULL, 0x002fe200078e006cULL, 0x0000004d06087212ULL, 0x040fe400078e3cffULL,
0xfffffff810097812ULL, 0x000fe200078ee209ULL, 0x0000000806137824ULL, 0x000fe200078e00ffULL,
0x0000004a0a127210ULL, 0x000fe20007f5e0ffULL, 0x0000000147117824ULL, 0x000fc400078e020cULL,
0x0000000144177824ULL, 0x100fe200078e020cULL, 0xfffffff813087812ULL, 0x000fe200078ee208ULL,
0x0000000141157824ULL, 0x000fe400078e020cULL, 0x0000008011107825ULL, 0x000fc800078e006cULL,
0x0000008017167825ULL, 0x000fc800078e006cULL, 0x0000008015147825ULL, 0x000fe200078e006cULL,
0x0000000000081947ULL, 0x004fec0003800000ULL, 0x00002024ff0075a7ULL, 0x000e640008020147ULL,
0x000000e400cc9947ULL, 0x002fea0003800000ULL, 0x0000004026267807ULL, 0x000fe20000000000ULL,
0x000000ffff137224ULL, 0x000fe200010e060bULL, 0x0000004a160a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000d04087899ULL, 0x000fe2000800063fULL, 0x0000000c26267c48ULL, 0x000fe2000ffe0000ULL,
0x0000000106277824ULL, 0x100fe200078e020cULL, 0x0000004a10107210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e0617ULL, 0x0000200008087892ULL, 0x000fe2000f8e0c3fULL,
0x8000000c263b7c36ULL, 0x000fe20008000000ULL, 0x0000004a14147210ULL, 0x000fe20007f5e0ffULL,
0x000000010e177824ULL, 0x000fe200078e020cULL, 0x0001300006087890ULL, 0x000fe2000fffe008ULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x0000003b4c00720cULL, 0x080fe20003f06070ULL,
0x0000008017167825ULL, 0x000fe200078e006cULL, 0x0000003b4800720cULL, 0x080fe20003f26070ULL,
0x0000000304097899ULL, 0x000fe2000800063fULL, 0x00000008494f7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000102257824ULL, 0x000fe200078e020cULL, 0x0000000846517c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff157224ULL, 0x000fe200010e0615ULL, 0x0000004a16167210ULL, 0x000fe20007f5e0ffULL,
0x0000008027267825ULL, 0x100fe200078e006cULL, 0x0000003b0400720cULL, 0x080fe20003f86070ULL,
0x0000000809157892ULL, 0x000fe2000f8e0c3fULL, 0x0000003b0500720cULL, 0x080fe20003fa6070ULL,
0x0000008025247825ULL, 0x000fe200078e006cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000124f7faeULL, 0x0003e2000c101c4eULL, 0x0000003b4500720cULL, 0x080fe20003f06070ULL,
0x000000150d167290ULL, 0x000fe2000fffe03fULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x0000004a26267210ULL, 0x000fe20007f5e0ffULL, 0x0000000107397824ULL, 0x000fe200078e020cULL,
0x0000004a24247210ULL, 0x000fe20007f7e0ffULL, 0x0000000010517faeULL, 0x0005e2000c901c4eULL,
0x0000003b4200720cULL, 0x080fe20003f26070ULL, 0x000000ffff277224ULL, 0x000fe200010e0627ULL,
0x0000003b0f00720cULL, 0x080fe20003f46070ULL, 0x000000ffff257224ULL, 0x000fe200018e0625ULL,
0x0000003b0000720cULL, 0x000fe20003f66070ULL, 0x0000008039387825ULL, 0x000fe200078e006cULL,
0x0000000843557c11ULL, 0x000fc4000f8e20ffULL, 0x0000000840137c11ULL, 0x002fe4000f8e20ffULL,
0x0000004a38387210ULL, 0x000fe20007fde0ffULL, 0x000000000a557faeULL, 0x0003e2000c101c4eULL,
0x0000ffff590c7812ULL, 0x000fe400078ec0ffULL, 0x000000080d117c11ULL, 0x004fe2000f8e20ffULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x00000008033b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000014137faeULL, 0x0005e2000c901c4eULL, 0x00000008084f7c11ULL, 0x000fc4000f8e20ffULL,
0x000088800c0c7816ULL, 0x000fe200000000ffULL, 0x0000000016117faeULL, 0x000fe2000d101c4eULL,
0x0000ffff58107812ULL, 0x000fe200078ec0ffULL, 0x00000015ff0a7e24ULL, 0x002fe2000f8e00ffULL,
0x00000008090b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000243b7faeULL, 0x0003e2000d901c4eULL,
0x00008880104e7816ULL, 0x000fc600000000ffULL, 0x00000000264f7faeULL, 0x0007e2000e101c4eULL,
0x000000ffff137224ULL, 0x004fe400078e000cULL, 0x800000004e107824ULL, 0x000fe200078e00ffULL,
0x00000000380b7faeULL, 0x0007e2000e901c4eULL, 0x8000000013137824ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000009ff247e24ULL, 0x002fe2000f8e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a56ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000013240075a7ULL, 0x000262000800004dULL, 0x00000001ff577819ULL, 0x000fe2000001164dULL,
0x0000000a05087291ULL, 0x000fc6000f8e383fULL, 0x0000000c57577812ULL, 0x000fc800078ec0ffULL,
0x0000000857567c10ULL, 0x000fe2000fffe04aULL, 0xffffc010ff0075a7ULL, 0x000ea4000802014dULL,
0x000000e000b49947ULL, 0x006fea0003800000ULL, 0x01b00000560b7984ULL, 0x008e620000000800ULL,
0x00000004ff647819ULL, 0x000fe2000001164dULL, 0x00000014ff117e24ULL, 0x000fe2000f8e00ffULL,
0x000000084d107812ULL, 0x000fe200078ec0ffULL, 0x01b2000056567984ULL, 0x000ea20000000800ULL,
0x0000000604067291ULL, 0x000fe2000f8e683fULL, 0x00000004116a7824ULL, 0x000fe200078e0264ULL,
0x0000000710677812ULL, 0x000fe200078ec84dULL, 0x000000090d097290ULL, 0x000fe2000fffe03fULL,
0x00000007106b7812ULL, 0x000fe200078ef84dULL, 0x0001300006067890ULL, 0x000fe2000fffe03fULL,
0x0000006a676a7212ULL, 0x000fca00078e3cffULL, 0x000000086b517824ULL, 0x000fca00078e026aULL,
0x0000000651147c11ULL, 0x000fe4000f8e20ffULL, 0x0000005c0b00720bULL, 0x002fda0003f3d000ULL,
0x00000000000c7806ULL, 0x000fc800008e0100ULL, 0x0000ffff0c157812ULL, 0x000fe2000782c0ffULL,
0x00000001ff0c7424ULL, 0x000fd800078e00ffULL, 0x0000000000e09947ULL, 0x004fea0003800000ULL,
0x0000005c0b00720bULL, 0x000fe20003f34000ULL, 0x000000120500728cULL, 0x000fe2000bf05270ULL,
0x0000000b5c167209ULL, 0x000fe40007810000ULL, 0x00000002ff117819ULL, 0x000fc6000001164dULL,
0x800000165c0c7221ULL, 0x100fe20000010000ULL, 0x000000000000781cULL, 0x000fe20003f4f008ULL,
0x0000000811127836ULL, 0x000fe40000000000ULL, 0x3fb8aa3b0c107820ULL, 0x000fe20000410000ULL,
0x0000000a12088291ULL, 0x000fe2000f8e383fULL, 0x00000000000c7806ULL, 0x000fe200008e0100ULL,
0x000000ffff5c7224ULL, 0x000fc600078e0016ULL, 0x0000ffff0c0c7812ULL, 0x000fe200078e3cffULL,
0x0000001000107308ULL, 0x000e660000000800ULL, 0x0000000c15ff7212ULL, 0x000fe2000782c0ffULL,
0x00001f1210127589ULL, 0x002e5800000e0000ULL, 0x800000160b0c1221ULL, 0x000fe20000010000ULL,
0x00000008570bac10ULL, 0x000fe2000fffe04aULL, 0x000000105b5b7220ULL, 0x000fe20000410000ULL,
0x00001f1110117589ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b0c0c1820ULL, 0x000fc60000410000ULL,
0x01b400160b00a388ULL, 0x0007e20000000800ULL, 0x0000000c00531308ULL, 0x0009640000000800ULL,
0x00000001ff0c7807ULL, 0x010fe20000800000ULL, 0x0000001223237220ULL, 0x082fe20000410000ULL,
0x0000001222227220ULL, 0x080fe20000410000ULL, 0x000000121f1f7220ULL, 0x080fe20000410000ULL,
0x000000121e1e7220ULL, 0x080fe20000410000ULL, 0x000000121b1b7220ULL, 0x080fe20000410000ULL,
0x000000121a1a7220ULL, 0x080fe20000410000ULL, 0x0000001233337220ULL, 0x080fe20000410000ULL,
0x0000001232327220ULL, 0x080fe20000410000ULL, 0x0000001237377220ULL, 0x080fe20000410000ULL,
0x0000001236367220ULL, 0x080fe20000410000ULL, 0x000000123f3f7220ULL, 0x080fe20000410000ULL,
0x000000123e3e7220ULL, 0x080fe20000410000ULL, 0x000000122f2f7220ULL, 0x080fe20000410000ULL,
0x000000122e2e7220ULL, 0x080fe20000410000ULL, 0x000000122b2b7220ULL, 0x080fe20000410000ULL,
0x000000122a2a7220ULL, 0x000fe20000410000ULL, 0x0000001121217220ULL, 0x084fe20000410000ULL,
0x0000001120207220ULL, 0x080fe20000410000ULL, 0x000000111d1d7220ULL, 0x080fe20000410000ULL,
0x000000111c1c7220ULL, 0x080fe20000410000ULL, 0x0000001119197220ULL, 0x080fe20000410000ULL,
0x0000001118187220ULL, 0x080fe20000410000ULL, 0x0000001131317220ULL, 0x080fe20000410000ULL,
0x0000001130307220ULL, 0x080fe20000410000ULL, 0x0000001135357220ULL, 0x080fe20000410000ULL,
0x0000001134347220ULL, 0x080fe20000410000ULL, 0x000000113d3d7220ULL, 0x080fe20000410000ULL,
0x000000113c3c7220ULL, 0x080fe20000410000ULL, 0x000000112d2d7220ULL, 0x080fe20000410000ULL,
0x000000112c2c7220ULL, 0x080fe20000410000ULL, 0x0000001129297220ULL, 0x080fe20000410000ULL,
0x0000001128287220ULL, 0x000fe20000410000ULL, 0x0000005356561220ULL, 0x028fce0000410000ULL,
0x0000000000080947ULL, 0x000fea0003800000ULL, 0x00000013240075a7ULL, 0x000e64000800014dULL,
0x000000dc009c8947ULL, 0x002fea0003800000ULL, 0x000000001414783bULL, 0x000e620000004200ULL,
0x000000074d247812ULL, 0x000fe200078ec0ffULL, 0x0000000a05057291ULL, 0x000fe2000f8e583fULL,
0x000000806b607811ULL, 0x000fe200078e18ffULL, 0x0000001064107c36ULL, 0x000fe20008000000ULL,
0x0000000824657812ULL, 0x000fe200078ef84dULL, 0x0000000400087c82ULL, 0x000fe20008000000ULL,
0x00000053ff62723eULL, 0x000fe200000010ffULL, 0x000000016a4f7824ULL, 0x000fe200078e0260ULL,
0x0000000764527812ULL, 0x000fe200078e7865ULL, 0x0000000264647836ULL, 0x000fe20000000000ULL,
0x000099100c6f7816ULL, 0x000fe200000000ffULL, 0x000000010800788cULL, 0x000fe2000bf05270ULL,
0x000000064f387c11ULL, 0x000fe2000f8e20ffULL, 0x0000000865527824ULL, 0x000fe200078e0252ULL,
0x0000541062687816ULL, 0x000fe20000000062ULL, 0x0000000104047892ULL, 0x000fe2000f8e0c3fULL,
0x0000001067677212ULL, 0x000fe200078e3cffULL, 0x0000005b565b7221ULL, 0x000fe20000010000ULL,
0x0000000552247c11ULL, 0x000fe2000f8e20ffULL, 0x000000003838783bULL, 0x000fe20000004200ULL,
0x000000ff6f00720cULL, 0x000fe20003f05270ULL, 0x000000086b507824ULL, 0x000fe200078e0267ULL,
0x0000000764647812ULL, 0x000fe200078e7865ULL, 0x0000000167607824ULL, 0x000fe200078e0260ULL,
0x011000002424783bULL, 0x000fe20000000200ULL, 0x000000000000781cULL, 0x000fc40003f6f008ULL,
0x0000000650107c11ULL, 0x000fe2000f8e20ffULL, 0x0000000865647824ULL, 0x000fe200078e0264ULL,
0x000000ff5aff7812ULL, 0x000fc8000784c0ffULL, 0x000000001010783bULL, 0x000ea20000004200ULL,
0x00000100140b7824ULL, 0x042fe200078e00ffULL, 0x0000888014547816ULL, 0x000fe200000000ffULL,
0x0000010015637824ULL, 0x040fe200078e00ffULL, 0x0000888015557816ULL, 0x000fe400000000ffULL,
0x00000018ff757819ULL, 0x000fe4000001140bULL, 0x00000002ff0b7819ULL, 0x000fe2000001164dULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x00000018ff667819ULL, 0x000fc40000011463ULL,
0x00000018ff737819ULL, 0x000fe20000011414ULL, 0x000000080b0c7836ULL, 0x000fe20000000000ULL,
0x00001f0b68637589ULL, 0x000e6200000e0000ULL, 0x00000018ff6e7819ULL, 0x000fe20000011415ULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x0000007500757306ULL, 0x000ee20000202400ULL,
0x00001f0c68627589ULL, 0x000f2200000e0000ULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011416ULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000005500557306ULL, 0x000fe20000202400ULL,
0x00000018ff697819ULL, 0x000fe40000011417ULL, 0x0000541054547816ULL, 0x008fca0000000075ULL,
0x0000006600747306ULL, 0x0007620000202400ULL, 0x00000018ff707819ULL, 0x004fe40000011411ULL,
0x00000018ff717819ULL, 0x000fe20000011410ULL, 0x0000006324248232ULL, 0x082fe20000200000ULL,
0x00000018ff6f7819ULL, 0x000fe20000011412ULL, 0x0000006326268232ULL, 0x000fe40000200000ULL,
0x0000007300737306ULL, 0x000fe20000202400ULL, 0x0000006225258232ULL, 0x090fe20000200000ULL,
0x00000018ff667819ULL, 0x008fe20000011413ULL, 0x0000006227278232ULL, 0x000fe20000200000ULL,
0x0000541055557816ULL, 0x020fc80000000074ULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x00000018ff747819ULL, 0x000fe40000011438ULL, 0x000000542428723cULL, 0x000fea0000041828ULL,
0x0000007400687306ULL, 0x0003e40000202400ULL, 0x0000010016547824ULL, 0x000fc400078e00ffULL,
0x0000010017557824ULL, 0x000fc800078e00ffULL, 0x0000001400147306ULL, 0x000ea20000202400ULL,
0x0000888016747816ULL, 0x042fe200000000ffULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe40000011454ULL, 0x0000888017547816ULL, 0x040fe200000000ffULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011455ULL,
0x0000001500157306ULL, 0x000e620000202400ULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x00000018ff767819ULL, 0x000fc40000011417ULL, 0x0000000660177c11ULL, 0x000fe4000f8e20ffULL,
0x0000541014147816ULL, 0x004fe20000000073ULL, 0x0000005400547306ULL, 0x000fe20000202400ULL,
0x0000888011737816ULL, 0x000fe400000000ffULL, 0x0000541015157816ULL, 0x002fca000000006eULL,
0x0000007700777306ULL, 0x000e620000202400ULL, 0x00000018ff6e7819ULL, 0x000fe20000011439ULL,
0x00000014242c723cULL, 0x000fec000004182cULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x0000541054157816ULL, 0x002fce0000000077ULL, 0x0000001600557306ULL, 0x000e620000202400ULL,
0x00000018ff777819ULL, 0x000fce000001143bULL, 0x0000006900697306ULL, 0x000fe20000202400ULL,
0x0000541055547816ULL, 0x002fce0000000072ULL, 0x0000007600767306ULL, 0x000e620000202400ULL,
0x0000010010557824ULL, 0x000fca00078e00ffULL, 0x00000018ff727819ULL, 0x000fe40000011455ULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x0000541076557816ULL, 0x002fce0000000069ULL,
0x0000007500757306ULL, 0x000e620000202400ULL, 0x000000542434723cULL, 0x000fee0000041834ULL,
0x0000007200697306ULL, 0x000fe20000202400ULL, 0x0000010011557824ULL, 0x040fe200078e00ffULL,
0x0000541074147816ULL, 0x002fe20000000075ULL, 0x000000ffff547224ULL, 0x000fe200078e0073ULL,
0x0000888010747816ULL, 0x000fe200000000ffULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fc40000011455ULL, 0x0000005400757306ULL, 0x000fe20000202400ULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x00000014243c723cULL, 0x000fe2000004183cULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x000000001714783bULL, 0x000e620000004200ULL,
0x00000018ff737819ULL, 0x000fe4000001143aULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000007400747306ULL, 0x000eb00000202400ULL, 0x0000005500767306ULL, 0x000ee20000202400ULL,
0x0000541074547816ULL, 0x004fce0000000069ULL, 0x0000007000707306ULL, 0x000fe20000202400ULL,
0x0000888013747816ULL, 0x000fe400000000ffULL, 0x0000541075557816ULL, 0x008fca0000000076ULL,
0x0000001100117306ULL, 0x000ea40000202400ULL, 0x000000542430723cULL, 0x000fec0000041830ULL,
0x0000007100717306ULL, 0x000fe20000202400ULL, 0x00000018ff697819ULL, 0x002fe20000011414ULL,
0x0000010012557824ULL, 0x040fe200078e00ffULL, 0x0000888012547816ULL, 0x040fe200000000ffULL,
0x0001000012127824ULL, 0x000fc800078e00ffULL, 0x0000001000107306ULL, 0x000e620000202400ULL,
0x0000541011117816ULL, 0x004fe40000000070ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff707819ULL, 0x000fe40000011412ULL, 0x0000000564127c11ULL, 0x000fe2000f8e20ffULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x0000541010107816ULL, 0x002fce0000000071ULL,
0x0000005500557306ULL, 0x000e620000202400ULL, 0x0000010013717824ULL, 0x040fe400078e00ffULL,
0x0001000013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011471ULL,
0x000000102418723cULL, 0x000fe20000041818ULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x00000018ff717819ULL, 0x000fca0000011415ULL, 0x0000541054107816ULL, 0x002fe40000000055ULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x00000018ff547819ULL, 0x000fce0000011413ULL,
0x0000007400747306ULL, 0x000ff00000202400ULL, 0x0000007500757306ULL, 0x000e700000202400ULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x0000541074117816ULL, 0x002fce0000000075ULL,
0x0000005400557306ULL, 0x0002a20000202400ULL, 0x0000888038747816ULL, 0x000fe200000000ffULL,
0x00000010241c723cULL, 0x000fe2000004181cULL, 0x011000001210783bULL, 0x000eea0000000200ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x0000541070547816ULL, 0x002fe2000000006fULL,
0x0000010038707824ULL, 0x000fc400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011470ULL, 0x00000074006f7306ULL, 0x0003e20000202400ULL,
0x0000541055557816ULL, 0x004fe40000000066ULL, 0x0000888039667816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fc60000011438ULL, 0x0000007000707306ULL, 0x000ea20000202400ULL,
0x000000542420723cULL, 0x000fe20000041820ULL, 0x000001006b747811ULL, 0x002fcc00078e18ffULL,
0x000000ffff247224ULL, 0x000fe200078e0066ULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x0000010039257824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011416ULL,
0x000000016a667824ULL, 0x000fe200078e0274ULL, 0x00000018ff557819ULL, 0x000fe40000011417ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000002400267306ULL, 0x0005e20000202400ULL,
0x0000000666277c11ULL, 0x000fe2000f8e20ffULL, 0x0000006310108232ULL, 0x008fc40000200000ULL,
0x0000006312128232ULL, 0x000fe20000200000ULL, 0x000054106f247816ULL, 0x004fe20000000070ULL,
0x00010000396f7824ULL, 0x000fe400078e00ffULL, 0x0000006211118232ULL, 0x080fe20000200000ULL,
0x0000003800397306ULL, 0x000e620000202400ULL, 0x0000006213138232ULL, 0x000fe20000200000ULL,
0x000088803a707816ULL, 0x000fe400000000ffULL, 0x00000018ff6f7819ULL, 0x000fc8000001146fULL,
0x0000007700727306ULL, 0x0005e20000202400ULL, 0x0000541039387816ULL, 0x002fce0000000068ULL,
0x0000006f006f7306ULL, 0x000e620000202400ULL, 0x000001003a397824ULL, 0x000fe200078e00ffULL,
0x0000888016777816ULL, 0x004fe200000000ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff757819ULL, 0x000fe40000011439ULL, 0x0000007000687306ULL, 0x000fe20000202400ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x000054106f397816ULL, 0x002fca000000006eULL,
0x0000007500757306ULL, 0x000fe20000202400ULL, 0x000088803b6e7816ULL, 0x040fe200000000ffULL,
0x00000038102c723cULL, 0x000fec000004182cULL, 0x0000003a003a7306ULL, 0x000fe20000202400ULL,
0x000001003b397824ULL, 0x000fe400078e00ffULL, 0x000000ffff387224ULL, 0x000fca00078e006eULL,
0x0000002500257306ULL, 0x000e620000202400ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fcc0000011439ULL, 0x0000003800767306ULL, 0x0005e20000202400ULL,
0x0000541026257816ULL, 0x002fce0000000025ULL, 0x0000003900397306ULL, 0x000e620000202400ULL,
0x0000541068387816ULL, 0x004fe20000000075ULL, 0x000000241028723cULL, 0x000fe20000041828ULL,
0x000000002724783bULL, 0x000eaa0000004200ULL, 0x0000006900697306ULL, 0x000fe20000202400ULL,
0x0000541076397816ULL, 0x002fce0000000039ULL, 0x0000007100717306ULL, 0x000fe20000202400ULL,
0x0000888015767816ULL, 0x000fe200000000ffULL, 0x00000038103c723cULL, 0x000fec000004183cULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x0000010014387824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fc4000001143bULL, 0x00008880143b7816ULL, 0x040fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000005500557306ULL, 0x000fe40000202400ULL, 0x00000018ff147819ULL, 0x000fcc0000011414ULL,
0x0000003800687306ULL, 0x0003e20000202400ULL, 0x00000018ff707819ULL, 0x004fe40000011424ULL,
0x00000018ff6f7819ULL, 0x000fca0000011425ULL, 0x0000003900397306ULL, 0x000ea20000202400ULL,
0x000054103a387816ULL, 0x002fe20000000073ULL, 0x0000010015737824ULL, 0x040fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe20000011426ULL, 0x0001000015157824ULL, 0x000fc600078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011473ULL, 0x0000003b003b7306ULL, 0x000e620000202400ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000541039397816ULL, 0x004fca0000000072ULL,
0x00000076003a7306ULL, 0x000fe40000202400ULL, 0x000000381034723cULL, 0x000fec0000041834ULL,
0x0000007300757306ULL, 0x000ea20000202400ULL, 0x0000010016387824ULL, 0x040fe400078e00ffULL,
0x0001000016167824ULL, 0x000fca00078e00ffULL, 0x0000001400727306ULL, 0x0002e20000202400ULL,
0x00000018ff787819ULL, 0x000fe40000011438ULL, 0x00000018ff167819ULL, 0x000fca0000011416ULL,
0x0000001500767306ULL, 0x0005220000202400ULL, 0x000054103b147816ULL, 0x002fe20000000068ULL,
0x0000000167687824ULL, 0x000fca00078e0274ULL, 0x0000000668397c11ULL, 0x000fe2000f8e20ffULL,
0x0000007700737306ULL, 0x000fe20000202400ULL, 0x000054103a157816ULL, 0x004fc80000000075ULL,
0x000000003938783bULL, 0x000e660000004200ULL, 0x000000141030723cULL, 0x000fe20000041830ULL,
0x0000007800787306ULL, 0x000fec0000202400ULL, 0x0000541072147816ULL, 0x008fe20000000069ULL,
0x0000010017697824ULL, 0x040fe200078e00ffULL, 0x0000888017157816ULL, 0x000fe200000000ffULL,
0x0000007000707306ULL, 0x000fe60000202400ULL, 0x00000018ff697819ULL, 0x000fca0000011469ULL,
0x0000001500727306ULL, 0x0009f00000202400ULL, 0x0000006900757306ULL, 0x000ea20000202400ULL,
0x0000541076157816ULL, 0x010fe20000000071ULL, 0x0001000017717824ULL, 0x000fca00078e00ffULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x000000141018723cULL, 0x000fe20000041818ULL,
0x0000001600177306ULL, 0x000eec0000202400ULL, 0x000000044d147811ULL, 0x000fe400078fe0ffULL,
0x0000007100747306ULL, 0x000f220000202400ULL, 0x0000541072157816ULL, 0x004fc40000000075ULL,
0x0000000714767812ULL, 0x000fe400078e7865ULL, 0x0000541073147816ULL, 0x000fe40000000078ULL,
0x0000541017547816ULL, 0x008fe20000000054ULL, 0x0000000865697824ULL, 0x000fe200078e0276ULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x00000018ff737819ULL, 0x000fe40000011427ULL,
0x00000014101c723cULL, 0x000fe2000004181cULL, 0x0000000569757c11ULL, 0x000fc4000f8e20ffULL,
0x0000541074557816ULL, 0x010fe40000000055ULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x011000007514783bULL, 0x0004e20000000200ULL, 0x00000018ff727819ULL, 0x002fe40000011438ULL,
0x00000018ff717819ULL, 0x000fe2000001143aULL, 0x000000541020723cULL, 0x000fe60000041820ULL,
0x0000007300737306ULL, 0x000fe80000202400ULL, 0x0000888024107816ULL, 0x040fe200000000ffULL,
0x0000010024117824ULL, 0x040fe200078e00ffULL, 0x000001806b557811ULL, 0x000fe200078e18ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x0000888025127816ULL, 0x040fe200000000ffULL,
0x00010000256b7824ULL, 0x040fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000010025137824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000001000107306ULL, 0x000fe20000202400ULL, 0x00000018ff747819ULL, 0x000fe2000001146bULL,
0x000000016a6a7824ULL, 0x000fe200078e0255ULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0000000167677824ULL, 0x000fe200078e0255ULL, 0x00008880266b7816ULL, 0x000fc400000000ffULL,
0x000000066a757c11ULL, 0x004fe2000f8e20ffULL, 0x0000002400257306ULL, 0x000e620000202400ULL,
0x00000018ff547819ULL, 0x000fce0000011439ULL, 0x0000007400747306ULL, 0x000ea20000202400ULL,
0x0000006314148232ULL, 0x088fe40000200000ULL, 0x0000006316168232ULL, 0x000fe20000200000ULL,
0x0000541025247816ULL, 0x002fc80000000070ULL, 0x0000001100117306ULL, 0x000e620000202400ULL,
0x0000010026257824ULL, 0x040fe400078e00ffULL, 0x0000006215158232ULL, 0x080fe40000200000ULL,
0x0001000026267824ULL, 0x000fe400078e00ffULL, 0x0000006217178232ULL, 0x000fe20000200000ULL,
0x00000018ff707819ULL, 0x000fe20000011425ULL, 0x0000001200127306ULL, 0x000fe20000202400ULL,
0x0000541074257816ULL, 0x004fc4000000006fULL, 0x00008880276f7816ULL, 0x000fe400000000ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000541010107816ULL, 0x002fe20000000011ULL,
0x0000001300137306ULL, 0x000e620000202400ULL, 0x00000024142c723cULL, 0x000fe2000004182cULL,
0x00000018ff747819ULL, 0x000fcc000001143bULL, 0x0000010027257824ULL, 0x000fe200078e00ffULL,
0x0000006b006b7306ULL, 0x000fe20000202400ULL, 0x000000ffff247224ULL, 0x000fc600078e006fULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000541012117816ULL, 0x002fe40000000013ULL,
0x0000007000707306ULL, 0x000e6a0000202400ULL, 0x000000101428723cULL, 0x000fe20000041828ULL,
0x000000007510783bULL, 0x0004e40000004200ULL, 0x0000002500767306ULL, 0x000ff00000202400ULL,
0x0000002400757306ULL, 0x0042b00000202400ULL, 0x0000007200727306ULL, 0x000fe20000202400ULL,
0x000054106b247816ULL, 0x002fe20000000070ULL, 0x0001000027707824ULL, 0x000fe200078e00ffULL,
0x0000541075257816ULL, 0x004fca0000000076ULL, 0x0000002600277306ULL, 0x0002a20000202400ULL,
0x00000018ff707819ULL, 0x000fe20000011470ULL, 0x00000024143c723cULL, 0x000fec000004183cULL,
0x0000007000767306ULL, 0x000f220000202400ULL, 0x0000010039267824ULL, 0x002fe400078e00ffULL,
0x0000010038257824ULL, 0x040fe200078e00ffULL, 0x0000888038247816ULL, 0x040fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fc40000011426ULL,
0x0000005400547306ULL, 0x000fe20000202400ULL, 0x00000018ff757819ULL, 0x000fe40000011425ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000888039257816ULL, 0x000fe400000000ffULL,
0x00000018ff6b7819ULL, 0x008fe20000011411ULL, 0x0000002600707306ULL, 0x0005e20000202400ULL,
0x00000018ff6f7819ULL, 0x000fe40000011410ULL, 0x0000888012797816ULL, 0x000fc400000000ffULL,
0x00000018ff557819ULL, 0x000fc60000011412ULL, 0x0000002400247306ULL, 0x000fe20000202400ULL,
0x0000541027267816ULL, 0x004fe2000000006eULL, 0x00010000396e7824ULL, 0x000fe200078e00ffULL,
0x0000541076277816ULL, 0x010fe40000000073ULL, 0x000088803b767816ULL, 0x000fe400000000ffULL,
0x00000018ff737819ULL, 0x000fe2000001146eULL, 0x0000007500757306ULL, 0x000e620000202400ULL,
0x000088803a6e7816ULL, 0x000fe200000000ffULL, 0x000000261434723cULL, 0x000fec0000041834ULL,
0x0000003800397306ULL, 0x0004e20000202400ULL, 0x0000000667267c11ULL, 0x000fc4000f8e20ffULL,
0x0000541024247816ULL, 0x002fca0000000075ULL, 0x0000007300737306ULL, 0x000e620000202400ULL,
0x000001003a387824ULL, 0x004fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000006e006e7306ULL, 0x000ff00000202400ULL, 0x0000003800757306ULL, 0x0007f00000202400ULL,
0x0000007600767306ULL, 0x000fe20000202400ULL, 0x0000541039387816ULL, 0x008fe20000000072ULL,
0x000001003b397824ULL, 0x040fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011413ULL,
0x000100003b3b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011439ULL,
0x0000002500257306ULL, 0x000ea20000202400ULL, 0x0000541073397816ULL, 0x002fce0000000054ULL,
0x0000007700737306ULL, 0x000e620000202400ULL, 0x000000381418723cULL, 0x000fe20000041818ULL,
0x0000541025257816ULL, 0x004fcc0000000070ULL, 0x0000007100717306ULL, 0x000fe20000202400ULL,
0x000054106e387816ULL, 0x000fe20000000075ULL, 0x000000241430723cULL, 0x000fe20000041830ULL,
0x0000541076397816ULL, 0x002fca0000000073ULL, 0x0000007400747306ULL, 0x000fe20000202400ULL,
0x000000002624783bULL, 0x000e620000004200ULL, 0x0000888013767816ULL, 0x000fe200000000ffULL,
0x00000038141c723cULL, 0x000fea000004181cULL, 0x0000006f006f7306ULL, 0x000fe40000202400ULL,
0x000100003a387824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fc4000001143bULL,
0x00008880103b7816ULL, 0x000fc600000000ffULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x00000018ff387819ULL, 0x000fce0000011438ULL, 0x0000003800387306ULL, 0x000eb00000202400ULL,
0x0000003900397306ULL, 0x000ee20000202400ULL, 0x0000541038387816ULL, 0x004fe20000000071ULL,
0x0000010010717824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x002fca0000011427ULL,
0x0000003b003b7306ULL, 0x000fe20000202400ULL, 0x0001000010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011424ULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000541039397816ULL, 0x008fe40000000074ULL, 0x00000073003a7306ULL, 0x0003e20000202400ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000888024757816ULL, 0x000fc400000000ffULL,
0x000000381414723cULL, 0x000fe20000041820ULL, 0x00000018ff6e7819ULL, 0x000fe40000011425ULL,
0x0000007100747306ULL, 0x0004e20000202400ULL, 0x0000888011737816ULL, 0x042fe400000000ffULL,
0x00000018ff547819ULL, 0x000fe20000011426ULL, 0x0000010011217824ULL, 0x000fe200078e00ffULL,
0x000000064d207811ULL, 0x000fe200078fe0ffULL, 0x000000ffff387224ULL, 0x000fe400078e0073ULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x0000000720207812ULL, 0x000fe200078e7865ULL,
0x00000010007c7306ULL, 0x0007e20000202400ULL, 0x00000018ff397819ULL, 0x000fe20000011421ULL,
0x0000010012717824ULL, 0x004fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000000865657824ULL, 0x000fc400078e0220ULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x0000003800387306ULL, 0x000fe20000202400ULL,
0x0000000565207c11ULL, 0x000fe2000f8e20ffULL, 0x000000013f057899ULL, 0x000fe20008011612ULL,
0x000054103b107816ULL, 0x008fe40000000074ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0000000a05157291ULL, 0x000fe2000f8e203fULL, 0x011000002020783bULL, 0x000e620000000200ULL,
0x0000003900397306ULL, 0x000ea20000202400ULL, 0x0000000a05067291ULL, 0x000fce000f8e703fULL,
0x00000011007a7306ULL, 0x0007300000202400ULL, 0x0000007900797306ULL, 0x000fe20000202400ULL,
0x0000010013117824ULL, 0x048fe400078e00ffULL, 0x0001000013137824ULL, 0x000fc600078e00ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000007100787306ULL, 0x000ee20000202400ULL,
0x00000018ff137819ULL, 0x000fce0000011413ULL, 0x0000001100777306ULL, 0x0005e20000202400ULL,
0x0000006320208232ULL, 0x002fce0000200000ULL, 0x0000007600767306ULL, 0x000e620000202400ULL,
0x0000006322228232ULL, 0x000fe20000200000ULL, 0x0000541038117816ULL, 0x004fe20000000039ULL,
0x0000006221218232ULL, 0x080fe20000200000ULL, 0x0000888025387816ULL, 0x000fe200000000ffULL,
0x0000006223238232ULL, 0x000fe20000200000ULL, 0x0000888026637816ULL, 0x000fe400000000ffULL,
0x0000005500557306ULL, 0x000fe20000202400ULL, 0x000000ff59ff7812ULL, 0x000fc6000780c0ffULL,
0x000000102028723cULL, 0x000fe20000041828ULL, 0x00000001ff59b807ULL, 0x000fc60000000000ULL,
0x0000007200727306ULL, 0x000fe60000202400ULL, 0x0000010024107824ULL, 0x040fe400078e00ffULL,
0x0000010025117824ULL, 0x000fe400078e00ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000001200747306ULL, 0x0005620000202400ULL,
0x00000018ff117819ULL, 0x000fc40000011411ULL, 0x00000018ff247819ULL, 0x000fca0000011424ULL,
0x0000001000627306ULL, 0x0003e20000202400ULL, 0x0001000025127824ULL, 0x004fca00078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011412ULL, 0x0000001100737306ULL, 0x0009e20000202400ULL,
0x000054107c107816ULL, 0x002fe4000000006fULL, 0x0000888027127816ULL, 0x000fca00000000ffULL,
0x0000001300717306ULL, 0x0002a20000202400ULL, 0x000054107a117816ULL, 0x010fce000000006bULL,
0x00000010202c723cULL, 0x000fe2000004182cULL, 0x0000002400257306ULL, 0x000fec0000202400ULL,
0x0000010026107824ULL, 0x040fe400078e00ffULL, 0x0000010027117824ULL, 0x040fe200078e00ffULL,
0x0000007500757306ULL, 0x000f220000202400ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fc40000011411ULL, 0x00000018ff137819ULL, 0x002fe40000011426ULL,
0x0000001000247306ULL, 0x0007e20000202400ULL, 0x00000018ff277819ULL, 0x000fce0000011427ULL,
0x00000011003b7306ULL, 0x0003e20000202400ULL, 0x0000541079107816ULL, 0x008fce0000000078ULL,
0x0000003800387306ULL, 0x000ee20000202400ULL, 0x0000541076117816ULL, 0x002fce0000000077ULL,
0x00000010203c723cULL, 0x000fe2000004183cULL, 0x0000007000707306ULL, 0x000e6c0000202400ULL,
0x0000541074107816ULL, 0x120fe40000000055ULL, 0x0000541071117816ULL, 0x004fe20000000072ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x000076105a557816ULL, 0x000fca0000000055ULL,
0x000000102034723cULL, 0x000fe40000041834ULL, 0x0000003900397306ULL, 0x000eaa0000202400ULL,
0x0000541075107816ULL, 0x010fe40000000062ULL, 0x0000541038117816ULL, 0x008fe20000000073ULL,
0x0000006300637306ULL, 0x000eec0000202400ULL, 0x000000102030723cULL, 0x000fe40000041830ULL,
0x0000001200127306ULL, 0x000f2a0000202400ULL, 0x0000541025107816ULL, 0x002fc40000000070ULL,
0x0000541039117816ULL, 0x004fe2000000006eULL, 0x0000005400547306ULL, 0x000fec0000202400ULL,
0x000000102018723cULL, 0x000fe40000041818ULL, 0x0000001300137306ULL, 0x000e6a0000202400ULL,
0x0000541063107816ULL, 0x008fc40000000024ULL, 0x0000541012117816ULL, 0x010fe2000000003bULL,
0x0000002700277306ULL, 0x000eac0000202400ULL, 0x00000010201c723cULL, 0x000fee000004181cULL,
0x0000541013107816ULL, 0x002fe20000000054ULL, 0x00000001ff547424ULL, 0x000fe200078e00ffULL,
0x0000541027117816ULL, 0x004fc6000000003aULL, 0x00002054ffff79a7ULL, 0x0003e80008500007ULL,
0x000000102020723cULL, 0x000fe20000041814ULL, 0x01b61054ffff79a7ULL, 0x0003ec0008500015ULL,
0x0000000561107c11ULL, 0x000fc8000f8e10ffULL, 0x0000008010107811ULL, 0x000fc800078e30ffULL,
0x0000005f1000720cULL, 0x000fe40003f26070ULL, 0x00000001ff107807ULL, 0x000fc80001000000ULL,
0x00007610105a7816ULL, 0x000fce000000005aULL, 0x0000002400f01947ULL, 0x002fea0003800000ULL,
0x8000000010147824ULL, 0x000fe400078e00ffULL, 0x0000001361107c36ULL, 0x000fe40008000000ULL,
0x00002014ff0075a7ULL, 0x000e640008020047ULL, 0x0000000110117836ULL, 0x040fe20000000000ULL,
0x0000000510127c11ULL, 0x000fc8000f8e10ffULL, 0x0000005e1100720cULL, 0x000fe20003f06070ULL,
0x0000004012127824ULL, 0x000fc800078e00ffULL, 0x000000175d137c24ULL, 0x000fe2000f8e0212ULL,
0x000000125f157248ULL, 0x000fe20007fe0000ULL, 0x0000000000081947ULL, 0x002fec0003800000ULL,
0x00002014ff0075a7ULL, 0x000e640008020147ULL, 0x000000bc00849947ULL, 0x002fea0003800000ULL,
0x000000014b4b7824ULL, 0x100fe200078e0213ULL, 0x0000000d08047899ULL, 0x000fe2000800063fULL,
0x0000000106397824ULL, 0x100fe400078e0213ULL, 0x00000001073b7824ULL, 0x000fe200078e0213ULL,
0x0000200004047892ULL, 0x000fe2000f8ec03fULL, 0x000000804b067825ULL, 0x000fc600078e006cULL,
0x0001300006097890ULL, 0x000fe2000fffe004ULL, 0x0000000115387824ULL, 0x000fe200078e0a12ULL,
0x0000004a06067210ULL, 0x000fe20007f3e0ffULL, 0x0000000144257824ULL, 0x100fe200078e0213ULL,
0x0000000308047899ULL, 0x000fe2000800063fULL, 0x0000000102117824ULL, 0x000fe200078e0213ULL,
0x0000004038387807ULL, 0x000fe20000000000ULL, 0x0000008025247825ULL, 0x000fe200078e006cULL,
0x0000000949497c11ULL, 0x000fe2000f8e20ffULL, 0x0000000804047892ULL, 0x000fe2000f8ec03fULL,
0x0000000c38387c48ULL, 0x000fe2000ffe0000ULL, 0x0000000147277824ULL, 0x100fe200078e0213ULL,
0x0000000943437c11ULL, 0x000fe2000f8e20ffULL, 0x0000000141177824ULL, 0x100fe200078e0213ULL,
0x000000090d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000010e157824ULL, 0x000fe200078e0213ULL,
0x0001b64815047890ULL, 0x000fe2000fffe004ULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000004a24247210ULL, 0x000fe20007f3e0ffULL, 0x0000008011127825ULL, 0x000fe200078e006cULL,
0x0000000903037c11ULL, 0x000fc4000f8e20ffULL, 0x0000000909097c11ULL, 0x000fe2000f8e20ffULL,
0x0000008027267825ULL, 0x000fc800078e006cULL, 0x0000008017167825ULL, 0x000fe200078e006cULL,
0x0000004a26267210ULL, 0x000fc60007f5e0ffULL, 0x0000008015147825ULL, 0x000fe200078e006cULL,
0x0000004a16167210ULL, 0x000fc60007f7e0ffULL, 0x0000008039107825ULL, 0x000fe200078e006cULL,
0x0000004a14147210ULL, 0x000fc60007f1e0ffULL, 0x000000803b6c7825ULL, 0x000fc800078e006cULL,
0x000000ffff257224ULL, 0x000fe200008e0625ULL, 0x0000004a12127210ULL, 0x000fe20007f3e0ffULL,
0x8000000c383b7c36ULL, 0x000fe40008000000ULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x0000004a10107210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0x0000003b4c00720cULL, 0x080fe20003f86070ULL, 0x000000ffff277224ULL, 0x000fe200010e0627ULL,
0x0000003b4800720cULL, 0x080fe20003fa6070ULL, 0x000000ffff177224ULL, 0x000fe200018e0617ULL,
0x0000004a6c387210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000003b4500720cULL, 0x080fe20003f66070ULL, 0x800000004e027824ULL, 0x000fe200078e00ffULL,
0x0000003b4200720cULL, 0x080fe20003f46070ULL, 0x000000ffff397224ULL, 0x000fe200008e066dULL,
0x0000003b0f00720cULL, 0x000fc40003f26070ULL, 0x00000009460f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006497faeULL, 0x0003e2000e101c4eULL,
0x0000003b0000720cULL, 0x080fe40003f06070ULL, 0x0000003b0400720cULL, 0x080fe20003f86070ULL,
0x00000000260f7faeULL, 0x000fe2000e901c4eULL, 0x0000003b0500720cULL, 0x000fe40003fa6070ULL,
0x0000000940057c11ULL, 0x000fe2000f8e20ffULL, 0x0000000024437faeULL, 0x000fe2000d901c4eULL,
0x0000ffff59007812ULL, 0x000fc400078ec0ffULL, 0x0000000908077c11ULL, 0x002fe2000f8e20ffULL,
0x0000000016057faeULL, 0x000fe2000d101c4eULL, 0x0000888000007816ULL, 0x000fc600000000ffULL,
0x00000000140d7faeULL, 0x0003e8000c901c4eULL, 0x0000000012037faeULL, 0x0005e8000c101c4eULL,
0x0000000010077faeULL, 0x0005e8000e101c4eULL, 0x0000000038097faeULL, 0x0005e2000e901c4eULL,
0x80000000000d7824ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fc40000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000d0a0075a7ULL, 0x000262000800004dULL, 0x0000000a11047291ULL, 0x000fcc000f8e383fULL,
0x0000000457047c10ULL, 0x000fe2000fffe04aULL, 0xffffe002ff0075a7ULL, 0x000ee4000802014dULL,
0x000000b800649947ULL, 0x00afea0003800000ULL, 0x01b0000004037984ULL, 0x004e620000000800ULL,
0x0000000108047892ULL, 0x000fe2000f8e0c3fULL, 0x00000001ff087424ULL, 0x000fc600078e00ffULL,
0x0000000604047291ULL, 0x000fc8000f8e683fULL, 0x0001300004047890ULL, 0x000fcc000fffe03fULL,
0x0000000451517c11ULL, 0x000fe4000f8e20ffULL, 0x0000005c0300720bULL, 0x002fda0003f3d000ULL,
0x0000000000007806ULL, 0x000fc800008e0100ULL, 0x0000ffff00077812ULL, 0x000fe4000782c0ffULL,
0x01b2000004007984ULL, 0x0002b60000000800ULL, 0x0000000000d89947ULL, 0x002fea0003800000ULL,
0x0000005c0300720bULL, 0x000fe20003f34000ULL, 0x000000121100728cULL, 0x000fe2000bf05270ULL,
0x000000035c047209ULL, 0x000fca0007810000ULL, 0x800000045c027221ULL, 0x100fe20000010000ULL,
0x000000000000781cULL, 0x000fe20003f4f008ULL, 0x000000ffff5c7224ULL, 0x000fe400078e0004ULL,
0x3fb8aa3b02057820ULL, 0x000fe20000410000ULL, 0x0000000a12098291ULL, 0x000fe2000f8e383fULL,
0x0000000000027806ULL, 0x000fe400008e0100ULL, 0x0000000500067308ULL, 0x000e640000000800ULL,
0x0000ffff02087812ULL, 0x000fc800078e3cffULL, 0x0000000807ff7212ULL, 0x000fe4000782c0ffULL,
0x000000095757ac10ULL, 0x000fe4000fffe04aULL, 0x00000001ff087807ULL, 0x000fc60000800000ULL,
0x01b400045700a388ULL, 0x000fe20000000800ULL, 0x000000065b5b7220ULL, 0x002fc60000410000ULL,
0x00001f0b06027589ULL, 0x000e6400000e0000ULL, 0x8000000403071221ULL, 0x000fe40000010000ULL,
0x00001f0c06037589ULL, 0x000ee400000e0000ULL, 0x3fb8aa3b07071820ULL, 0x000fc80000410000ULL,
0x0000000700531308ULL, 0x000f220000000800ULL, 0x0000000228287220ULL, 0x082fe20000410000ULL,
0x0000000229297220ULL, 0x080fe20000410000ULL, 0x000000022c2c7220ULL, 0x080fe20000410000ULL,
0x000000022d2d7220ULL, 0x080fe20000410000ULL, 0x000000023c3c7220ULL, 0x080fe20000410000ULL,
0x000000023d3d7220ULL, 0x080fe20000410000ULL, 0x0000000234347220ULL, 0x080fe20000410000ULL,
0x0000000235357220ULL, 0x080fe20000410000ULL, 0x0000000230307220ULL, 0x080fe20000410000ULL,
0x0000000231317220ULL, 0x080fe20000410000ULL, 0x0000000218187220ULL, 0x080fe20000410000ULL,
0x0000000219197220ULL, 0x080fe20000410000ULL, 0x000000021c1c7220ULL, 0x080fe20000410000ULL,
0x000000021d1d7220ULL, 0x080fe20000410000ULL, 0x0000000220207220ULL, 0x080fe20000410000ULL,
0x0000000221217220ULL, 0x000fe20000410000ULL, 0x000000032a2a7220ULL, 0x088fe20000410000ULL,
0x000000032b2b7220ULL, 0x080fe20000410000ULL, 0x000000032e2e7220ULL, 0x080fe20000410000ULL,
0x000000032f2f7220ULL, 0x080fe20000410000ULL, 0x000000033e3e7220ULL, 0x080fe20000410000ULL,
0x000000033f3f7220ULL, 0x080fe20000410000ULL, 0x0000000336367220ULL, 0x080fe20000410000ULL,
0x0000000337377220ULL, 0x080fe20000410000ULL, 0x0000000332327220ULL, 0x080fe20000410000ULL,
0x0000000333337220ULL, 0x080fe20000410000ULL, 0x000000031a1a7220ULL, 0x080fe20000410000ULL,
0x000000031b1b7220ULL, 0x080fe20000410000ULL, 0x000000031e1e7220ULL, 0x080fe20000410000ULL,
0x000000031f1f7220ULL, 0x080fe20000410000ULL, 0x0000000322227220ULL, 0x080fe20000410000ULL,
0x0000000323237220ULL, 0x000fe20000410000ULL, 0x0000000053001220ULL, 0x014fce0000410000ULL,
0x0000000000080947ULL, 0x000fea0003800000ULL, 0x0000000d0a0075a7ULL, 0x000e64000800014dULL,
0x000000b400748947ULL, 0x002fea0003800000ULL, 0x000000005104783bULL, 0x000e620000004200ULL,
0x0000000a11097291ULL, 0x000fe2000f8e583fULL, 0x000000044f147c11ULL, 0x000fe2000f8e20ffULL,
0x0000005b005b7221ULL, 0x004fe20000010000ULL, 0x00000053ff4f723eULL, 0x000fe400000010ffULL,
0x0000000450107c11ULL, 0x000fe4000f8e20ffULL, 0x0000000952487c11ULL, 0x000fe2000f8e20ffULL,
0x000000001414783bULL, 0x000fe20000004200ULL, 0x000054104f777816ULL, 0x000fc4000000004fULL,
0x0000991008527816ULL, 0x000fe200000000ffULL, 0x000000001010783bULL, 0x000fe20000004200ULL,
0x0000000460247c11ULL, 0x000fe4000f8e20ffULL, 0x000000ff5200720cULL, 0x000fe20003f05270ULL,
0x011000004848783bULL, 0x000fe20000000200ULL, 0x0000000466387c11ULL, 0x000fe4000f8e20ffULL,
0x0000000468407c11ULL, 0x000fe2000f8e20ffULL, 0x00001f0b774f7589ULL, 0x000ea200000e0000ULL,
0x000000046a447c11ULL, 0x000fc4000f8e20ffULL, 0x000000ff59ff7812ULL, 0x000fe2000782c0ffULL,
0x00001f0c77567589ULL, 0x00072800000e0000ULL, 0x000000002424783bULL, 0x000f680000004200ULL,
0x000000003838783bULL, 0x000f680000004200ULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x0000888005517816ULL, 0x042fe200000000ffULL, 0x00000100040a7824ULL, 0x040fe200078e00ffULL,
0x0000888004097816ULL, 0x040fe200000000ffULL, 0x000000004444783bULL, 0x000e620000004200ULL,
0x00000018ff507819ULL, 0x000fe20000011404ULL, 0x000000ffff087224ULL, 0x000fe200078e0051ULL,
0x00000018ff0a7819ULL, 0x000fe2000001140aULL, 0x0000010005517824ULL, 0x040fe200078e00ffULL,
0x0000000900097306ULL, 0x000fe20000202400ULL, 0x0001000004047824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe20000011405ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fc40000011451ULL, 0x00000018ff047819ULL, 0x000fe40000011404ULL,
0x0000000a000a7306ULL, 0x000fe20000202400ULL, 0x00000018ff777819ULL, 0x008fe20000011405ULL,
0x0000004f48488232ULL, 0x084fe20000200000ULL, 0x00008880060c7816ULL, 0x000fe200000000ffULL,
0x0000004f4a4a8232ULL, 0x000fe20000200000ULL, 0x00000018ff767819ULL, 0x000fe20000011406ULL,
0x0000005649498232ULL, 0x090fe20000200000ULL, 0x00000018ff757819ULL, 0x000fe20000011407ULL,
0x0000000800087306ULL, 0x000fe20000202400ULL, 0x000000564b4b8232ULL, 0x000fe20000200000ULL,
0x00000018ff747819ULL, 0x000fc40000011410ULL, 0x00000018ff737819ULL, 0x000fe40000011411ULL,
0x00000018ff727819ULL, 0x000fe40000011412ULL, 0x0000005200577306ULL, 0x000ea20000202400ULL,
0x00000018ff0d7819ULL, 0x000fe40000011413ULL, 0x00000018ff717819ULL, 0x000fe40000011414ULL,
0x00000018ff6f7819ULL, 0x000fe40000011416ULL, 0x00000018ff707819ULL, 0x000fe20000011415ULL,
0x0000000400517306ULL, 0x0007e20000202400ULL, 0x00000018ff0f7819ULL, 0x020fc40000011424ULL,
0x00000018ff6e7819ULL, 0x000fe40000011417ULL, 0x00000018ff0e7819ULL, 0x000fe40000011425ULL,
0x0000541008057816ULL, 0x004fe20000000057ULL, 0x0000005000507306ULL, 0x000ea20000202400ULL,
0x0000541009047816ULL, 0x008fe4000000000aULL, 0x0000000467097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000108047892ULL, 0x000fe2000f80c03fULL, 0x00008880257c7816ULL, 0x000fc400000000ffULL,
0x00000018ff6d7819ULL, 0x000fe20000011427ULL, 0x000000044828723cULL, 0x000fe20000041828ULL,
0x0000004e004e7306ULL, 0x000fe20000202400ULL, 0x00000018ff6a7819ULL, 0x000fe20000011439ULL,
0x000000000908783bULL, 0x000ee20000004200ULL, 0x00000018ff637819ULL, 0x000fe40000011440ULL,
0x00000018ff667819ULL, 0x000fe2000001143bULL, 0x0000010006047824ULL, 0x040fe200078e00ffULL,
0x0000888007057816ULL, 0x000fe200000000ffULL, 0x0000007700577306ULL, 0x000f220000202400ULL,
0x0001000006067824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fc40000011426ULL,
0x00000018ff047819ULL, 0x000fe40000011404ULL, 0x00000018ff6b7819ULL, 0x000fe40000011438ULL,
0x0000000400677306ULL, 0x0005e20000202400ULL, 0x00000018ff627819ULL, 0x000fe40000011441ULL,
0x00000018ff687819ULL, 0x000fe4000001143aULL, 0x00000018ff607819ULL, 0x000fe40000011442ULL,
0x00000018ff5a7819ULL, 0x000fe20000011443ULL, 0x0000000500777306ULL, 0x0009e20000202400ULL,
0x0000541051047816ULL, 0x004fe20000000050ULL, 0x0000010007507824ULL, 0x040fe200078e00ffULL,
0x00000018ff027819ULL, 0x002fe20000011445ULL, 0x0001000007077824ULL, 0x000fe200078e00ffULL,
0x00000018ff037819ULL, 0x000fc40000011444ULL, 0x00000018ff787819ULL, 0x000fe20000011450ULL,
0x0000000c000c7306ULL, 0x000e620000202400ULL, 0x0000541057057816ULL, 0x010fe4000000004eULL,
0x00000018ff4c7819ULL, 0x000fe40000011446ULL, 0x00000018ff527819ULL, 0x000fe40000011447ULL,
0x000000000000781cULL, 0x000fe20003f4f008ULL, 0x00000078004e7306ULL, 0x000ea20000202400ULL,
0x00000004482c723cULL, 0x000fe2000004182cULL, 0x00000018ff517819ULL, 0x008fc40000011408ULL,
0x00000018ff507819ULL, 0x000fe40000011409ULL, 0x00000018ff577819ULL, 0x000fe4000001140bULL,
0x000054100c047816ULL, 0x002fe20000000067ULL, 0x0000007600767306ULL, 0x000fe20000202400ULL,
0x00000018ff0c7819ULL, 0x000fe40000011407ULL, 0x0000888011677816ULL, 0x000fe400000000ffULL,
0x00000001ff59a807ULL, 0x000fc40000800000ULL, 0x0000541077057816ULL, 0x004fe2000000004eULL,
0x0000007500757306ULL, 0x000fe20000202400ULL, 0x00000018ff4e7819ULL, 0x000fca000001140aULL,
0x00000004483c723cULL, 0x000fe4000004183cULL, 0x0000000c000c7306ULL, 0x000fea0000202400ULL,
0x00000018ff047819ULL, 0x000fe40000011406ULL, 0x0000888010067816ULL, 0x040fe200000000ffULL,
0x0000007400747306ULL, 0x000ff00000202400ULL, 0x0000000400057306ULL, 0x000e700000202400ULL,
0x0000000600067306ULL, 0x000fe20000202400ULL, 0x0000541005047816ULL, 0x002fe20000000076ULL,
0x0000010010057824ULL, 0x000fcc00078e00ffULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff077819ULL, 0x000fe40000011405ULL,
0x000054100c057816ULL, 0x000fe40000000075ULL, 0x0000888013757816ULL, 0x000fe400000000ffULL,
0x0000007200727306ULL, 0x000fe60000202400ULL, 0x000000044834723cULL, 0x000fea0000041834ULL,
0x0000000700077306ULL, 0x000e640000202400ULL, 0x0000010011047824ULL, 0x000fc400078e00ffULL,
0x000000ffff057224ULL, 0x000fe200078e0067ULL, 0x00000018ff677819ULL, 0x000fe20000011410ULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff047819ULL, 0x000fe20000011404ULL,
0x0000007500757306ULL, 0x000fe60000202400ULL, 0x00000018ff787819ULL, 0x000fe40000011411ULL,
0x0000888012117816ULL, 0x000fc600000000ffULL, 0x0000000500057306ULL, 0x000ff00000202400ULL,
0x00000004000c7306ULL, 0x0002b00000202400ULL, 0x0000006700677306ULL, 0x000fe20000202400ULL,
0x0000541006047816ULL, 0x002fe20000000007ULL, 0x0000010012067824ULL, 0x000fc400078e00ffULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x0000541005057816ULL, 0x004fc6000000000cULL,
0x0000007800787306ULL, 0x000e620000202400ULL, 0x00000018ff077819ULL, 0x000fe40000011412ULL,
0x00000018ff067819ULL, 0x000fe40000011406ULL, 0x00008880140c7816ULL, 0x000fe200000000ffULL,
0x000000044830723cULL, 0x000fe40000041830ULL, 0x0000001100117306ULL, 0x000fea0000202400ULL,
0x0000010013047824ULL, 0x000fc400078e00ffULL, 0x0000010014057824ULL, 0x040fe200078e00ffULL,
0x0000000600107306ULL, 0x0004e20000202400ULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff047819ULL, 0x000fe20000011404ULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fe40000011405ULL, 0x0000541078057816ULL, 0x002fe40000000073ULL,
0x0000000400767306ULL, 0x0003220000202400ULL, 0x00000018ff067819ULL, 0x004fc40000011413ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000888017137816ULL, 0x000fe400000000ffULL,
0x0000888026787816ULL, 0x000fe200000000ffULL, 0x0000000d000d7306ULL, 0x000fe20000202400ULL,
0x0000541067047816ULL, 0x002fe40000000074ULL, 0x0000888015747816ULL, 0x000fca00000000ffULL,
0x000000044818723cULL, 0x000fe20000041818ULL, 0x0000000700077306ULL, 0x000fec0000202400ULL,
0x0000010015047824ULL, 0x040fe400078e00ffULL, 0x0000010016057824ULL, 0x000fe200078e00ffULL,
0x0000000600067306ULL, 0x000e620000202400ULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff047819ULL, 0x000fc80000011404ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000000400777306ULL, 0x0007f00000202400ULL, 0x0000001200737306ULL, 0x0005e20000202400ULL,
0x0000541011047816ULL, 0x008fc40000000010ULL, 0x00000018ff117819ULL, 0x000fe40000011405ULL,
0x0000541075057816ULL, 0x010fc60000000076ULL, 0x0000001400797306ULL, 0x000fe20000202400ULL,
0x0000888016127816ULL, 0x044fe200000000ffULL, 0x0001000016167824ULL, 0x000fe400078e00ffULL,
0x00000004481c723cULL, 0x000fe6000004181cULL, 0x00000018ff107819ULL, 0x000fe20000011416ULL,
0x0000000c000c7306ULL, 0x000ea60000202400ULL, 0x0000010017047824ULL, 0x000fc400078e00ffULL,
0x0000010024057824ULL, 0x000fe400078e00ffULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff047819ULL, 0x000fe20000011404ULL, 0x0000007400747306ULL, 0x000ee20000202400ULL,
0x00000018ff167819ULL, 0x000fe40000011405ULL, 0x0000541006057816ULL, 0x002fe4000000000dULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x000054100c0c7816ULL, 0x004fe20000000073ULL,
0x0000000400147306ULL, 0x0003e20000202400ULL, 0x0000888027737816ULL, 0x000fce00000000ffULL,
0x0000001500677306ULL, 0x0005e20000202400ULL, 0x0000541007047816ULL, 0x002fce0000000072ULL,
0x000000044820723cULL, 0x000fe20000041820ULL, 0x0000888024157816ULL, 0x044fe200000000ffULL,
0x0000007100717306ULL, 0x000e6a0000202400ULL, 0x0000010025047824ULL, 0x000fe200078e00ffULL,
0x000088803b487816ULL, 0x000fe200000000ffULL, 0x0001000024057824ULL, 0x000fe200078e00ffULL,
0x0000007000707306ULL, 0x000ea20000202400ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff0d7819ULL, 0x000fc40000011404ULL, 0x0000000964047c11ULL, 0x000fe4000f8e20ffULL,
0x00000018ff7a7819ULL, 0x000fe40000011405ULL, 0x0000000d00247306ULL, 0x0009e20000202400ULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x011000000404783bULL, 0x000f620000000200ULL,
0x0000888039647816ULL, 0x000fca00000000ffULL, 0x0000001200127306ULL, 0x000fe20000202400ULL,
0x00000100260d7824ULL, 0x050fe400078e00ffULL, 0x0001000026267824ULL, 0x000fc600078e00ffULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x0000001100117306ULL, 0x000f220000202400ULL,
0x00000018ff267819ULL, 0x000fce0000011426ULL, 0x0000000d00757306ULL, 0x0007f00000202400ULL,
0x0000001300137306ULL, 0x000e620000202400ULL, 0x00005410740d7816ULL, 0x008fe40000000077ULL,
0x0000888038777816ULL, 0x000fca00000000ffULL, 0x0000006f006f7306ULL, 0x000fe20000202400ULL,
0x0000004f04048232ULL, 0x0a0fe40000200000ULL, 0x0000004f06068232ULL, 0x000fe40000200000ULL,
0x0000005605058232ULL, 0x080fe40000200000ULL, 0x0000005607078232ULL, 0x000fe20000200000ULL,
0x0000006e006e7306ULL, 0x000fec0000202400ULL, 0x0000000c0428723cULL, 0x000fe40000041828ULL,
0x0000001000107306ULL, 0x000eea0000202400ULL, 0x00000100380c7824ULL, 0x000fc400078e00ffULL,
0x00000100390d7824ULL, 0x040fe200078e00ffULL, 0x0000001700177306ULL, 0x000f620000202400ULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x000fc8000001140dULL,
0x0000000c00727306ULL, 0x0003f00000202400ULL, 0x00000025007d7306ULL, 0x0005e20000202400ULL,
0x00005410790c7816ULL, 0x002fce0000000071ULL, 0x0000000d00797306ULL, 0x0003e20000202400ULL,
0x0000010027257824ULL, 0x044fe400078e00ffULL, 0x0001000027277824ULL, 0x000fc600078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000001500157306ULL, 0x000fe20000202400ULL, 0x00005410670d7816ULL, 0x002fe40000000070ULL,
0x000088803a677816ULL, 0x000fca00000000ffULL, 0x0000000c042c723cULL, 0x000fe2000004182cULL,
0x0000002700747306ULL, 0x0003ec0000202400ULL, 0x000001003a0c7824ULL, 0x040fe400078e00ffULL,
0x000001003b0d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff277819ULL, 0x002fe20000011439ULL,
0x0000001600167306ULL, 0x000e620000202400ULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x000100003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000000c004a7306ULL, 0x0009f00000202400ULL, 0x0000000d004b7306ULL, 0x0005e20000202400ULL,
0x00005410120c7816ULL, 0x010fc40000000011ULL, 0x00000018ff117819ULL, 0x000fe4000001143aULL,
0x00008880453a7816ULL, 0x000fc600000000ffULL, 0x0000007c007c7306ULL, 0x000f220000202400ULL,
0x00005410130d7816ULL, 0x004fe40000000014ULL, 0x0000888040137816ULL, 0x000fe400000000ffULL,
0x0000888041147816ULL, 0x000fc600000000ffULL, 0x0000000c043c723cULL, 0x000fe2000004183cULL,
0x0000002500767306ULL, 0x000fec0000202400ULL, 0x00000100400c7824ULL, 0x040fe400078e00ffULL,
0x00000100410d7824ULL, 0x040fe200078e00ffULL, 0x0000000f000f7306ULL, 0x000fe20000202400ULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x000fc8000001140dULL,
0x0000000c00127306ULL, 0x0007e20000202400ULL, 0x00000018ff417819ULL, 0x000fce0000011441ULL,
0x0000000d00397306ULL, 0x000be20000202400ULL, 0x00005410100c7816ULL, 0x008fe4000000006fULL,
0x00000018ff107819ULL, 0x000fca0000011440ULL, 0x0000000e000e7306ULL, 0x000fe20000202400ULL,
0x00005410170d7816ULL, 0x020fe4000000006eULL, 0x0000888043177816ULL, 0x000fca00000000ffULL,
0x0000000c0434723cULL, 0x000fe20000041834ULL, 0x0000007a007a7306ULL, 0x000eac0000202400ULL,
0x00000100420c7824ULL, 0x000fe400078e00ffULL, 0x00000100430d7824ULL, 0x040fe200078e00ffULL,
0x0000007800787306ULL, 0x000ee20000202400ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fc4000001140cULL, 0x00000018ff0d7819ULL, 0x000fe4000001140dULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000000c00257306ULL, 0x0003f00000202400ULL,
0x0000000d00407306ULL, 0x0009e20000202400ULL, 0x00005410150c7816ULL, 0x002fce0000000016ULL,
0x0000007300737306ULL, 0x000e620000202400ULL, 0x000054107c0d7816ULL, 0x010fe40000000024ULL,
0x0000888044247816ULL, 0x000fca00000000ffULL, 0x0000000c0430723cULL, 0x000fe20000041830ULL,
0x0000003b00717306ULL, 0x000fec0000202400ULL, 0x00000100440c7824ULL, 0x040fe400078e00ffULL,
0x00000100450d7824ULL, 0x040fe200078e00ffULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x0001000045457824ULL, 0x000fe200078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x000fc8000001140dULL,
0x0000000c00157306ULL, 0x0005e20000202400ULL, 0x00000018ff167819ULL, 0x000fce0000011444ULL,
0x0000000d003b7306ULL, 0x0009e20000202400ULL, 0x000054107a0c7816ULL, 0x004fce000000000fULL,
0x0000006d006d7306ULL, 0x000ea20000202400ULL, 0x000054107d0d7816ULL, 0x010fe4000000000eULL,
0x00000009690e7c11ULL, 0x000fca000f8e20ffULL, 0x0000000c0418723cULL, 0x000fe20000041818ULL,
0x00000026007b7306ULL, 0x00096c0000202400ULL, 0x00005410780c7816ULL, 0x008fe40000000075ULL,
0x00005410730d7816ULL, 0x002fe20000000076ULL, 0x0000007700777306ULL, 0x000e620000202400ULL,
0x00000018ff267819ULL, 0x010fc40000011438ULL, 0x0000888042387816ULL, 0x040fe200000000ffULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00005410746d7816ULL, 0x004fe2000000006dULL,
0x0000000c041c723cULL, 0x000fe2000004181cULL, 0x011000000e0c783bULL, 0x000ea20000000200ULL,
0x0000006400647306ULL, 0x000ee20000202400ULL, 0x000054107b6c7816ULL, 0x020fce000000006cULL,
0x0000006b006b7306ULL, 0x000fe20000202400ULL, 0x0000006c0404723cULL, 0x000fee0000041820ULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x0000010008227824ULL, 0x000fe200078e00ffULL,
0x0000541077207816ULL, 0x002fc40000000072ULL, 0x0000541064217816ULL, 0x008fe40000000079ULL,
0x00000018ff697819ULL, 0x000fe40000011422ULL, 0x0000002600267306ULL, 0x000e620000202400ULL,
0x0000000965227c11ULL, 0x000fe4000f8e20ffULL, 0x0000888009647816ULL, 0x000fca00000000ffULL,
0x0000002700277306ULL, 0x000ee20000202400ULL, 0x0000004f0c0c8232ULL, 0x004fce0000200000ULL,
0x0000004100497306ULL, 0x0005e20000202400ULL, 0x0000004f0e0e8232ULL, 0x000fe20000200000ULL,
0x0000541026267816ULL, 0x002fe2000000006bULL, 0x000000560d0d8232ULL, 0x080fe40000200000ULL,
0x000000560f0f8232ULL, 0x000fe20000200000ULL, 0x0000541027277816ULL, 0x008fe4000000006aULL,
0x0000006800687306ULL, 0x000fe20000202400ULL, 0x00000018ff417819ULL, 0x004fe20000011442ULL,
0x00000100096a7824ULL, 0x040fe200078e00ffULL, 0x0000888046427816ULL, 0x040fe200000000ffULL,
0x000000200c28723cULL, 0x000fe20000041828ULL, 0x011000002220783bULL, 0x000e620000000200ULL,
0x0001000009097824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x0000001100117306ULL, 0x000ea20000202400ULL, 0x000000ffff737224ULL, 0x000fe200078e0042ULL,
0x000000260c2c723cULL, 0x000fe2000004182cULL, 0x0000010046427824ULL, 0x040fe200078e00ffULL,
0x00000018ff097819ULL, 0x000fe20000011409ULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x00002054ffff79a7ULL, 0x0007e40008500007ULL, 0x0000001300137306ULL, 0x000f220000202400ULL,
0x00000018ff447819ULL, 0x000fc40000011442ULL, 0x0000888047427816ULL, 0x000fe200000000ffULL,
0x01b63054ffff79a7ULL, 0x0007e20008500015ULL, 0x0000541011687816ULL, 0x004fc60000000068ULL,
0x0000006300637306ULL, 0x000fe20000202400ULL, 0x0000541013127816ULL, 0x010fce0000000012ULL,
0x0000006200627306ULL, 0x000eb00000202400ULL, 0x0000001400147306ULL, 0x000f220000202400ULL,
0x0000004f20208232ULL, 0x002fe20000200000ULL, 0x0000541049117816ULL, 0x004fcc0000000062ULL,
0x0000001000107306ULL, 0x000e620000202400ULL, 0x0000004f22228232ULL, 0x000fe40000200000ULL,
0x0000005621218232ULL, 0x080fe40000200000ULL, 0x0000005623238232ULL, 0x000fe20000200000ULL,
0x000000ff55ff7812ULL, 0x000fe4000780c0ffULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x0000541014137816ULL, 0x010fe40000000039ULL, 0x0000541010107816ULL, 0x002fca0000000063ULL,
0x0000006000607306ULL, 0x000fe20000202400ULL, 0x000000120c30723cULL, 0x000fec0000041830ULL,
0x000000100c18723cULL, 0x000fe20000041818ULL, 0x0000005a005a7306ULL, 0x000fe20000202400ULL,
0x000088800a127816ULL, 0x000fca00000000ffULL, 0x000001000a117824ULL, 0x040fe400078e00ffULL,
0x0000006700677306ULL, 0x000e620000202400ULL, 0x000100000a0a7824ULL, 0x000fe400078e00ffULL,
0x00000018ff117819ULL, 0x000fc60000011411ULL, 0x00000018ff0a7819ULL, 0x000fe4000001140aULL,
0x0000004800487306ULL, 0x000ea20000202400ULL, 0x0000541067267816ULL, 0x002fce000000004aULL,
0x0000003800387306ULL, 0x000e620000202400ULL, 0x0000541048277816ULL, 0x004fce000000004bULL,
0x0000001700177306ULL, 0x000ea20000202400ULL, 0x000000260c3c723cULL, 0x000fe2000004183cULL,
0x0000541038387816ULL, 0x002fcc0000000025ULL, 0x0000004100417306ULL, 0x000e620000202400ULL,
0x0000541017397816ULL, 0x004fce0000000040ULL, 0x00000043006f7306ULL, 0x0005220000202400ULL,
0x000000380c1c723cULL, 0x000fe2000004181cULL, 0x00005410416e7816ULL, 0x002fcc0000000060ULL,
0x0000000200027306ULL, 0x000fe20000202400ULL, 0x00000018ff437819ULL, 0x004fe20000011445ULL,
0x0000010047457824ULL, 0x040fe400078e00ffULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x000054106f6f7816ULL, 0x010fc6000000005aULL, 0x0000004300437306ULL, 0x000e620000202400ULL,
0x00000018ff757819ULL, 0x000fe40000011445ULL, 0x00000018ff457819ULL, 0x000fe40000011446ULL,
0x0000888008467816ULL, 0x040fe200000000ffULL, 0x0000006e0c04723cULL, 0x000fe20000041804ULL,
0x0001000008087824ULL, 0x000fe200078e00ffULL, 0x0000006900657306ULL, 0x0005e20000202400ULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x00000001ff5a7807ULL, 0x000fc40004000000ULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x0000541043177816ULL, 0x002fe20000000002ULL,
0x000100000b027824ULL, 0x000fe200078e00ffULL, 0x0000541071697816ULL, 0x004fe20000000066ULL,
0x0000001200107306ULL, 0x0003ec0000202400ULL, 0x000000680c34723cULL, 0x000fe40000041834ULL,
0x0000000300037306ULL, 0x000fe20000202400ULL, 0x000088800b127816ULL, 0x002fc800000000ffULL,
0x000001000b0d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe40000011402ULL,
0x0000001600167306ULL, 0x000e640000202400ULL, 0x00000018ff0d7819ULL, 0x000fcc000001140dULL,
0x0000001100117306ULL, 0x000ea20000202400ULL, 0x0000541016167816ULL, 0x002fce0000000003ULL,
0x0000004c004c7306ULL, 0x000fe20000202400ULL, 0x00000016202c723cULL, 0x000fe2000004182cULL,
0x0000541010107816ULL, 0x004fcc0000000011ULL, 0x0000005200527306ULL, 0x000ff00000202400ULL,
0x0000005100517306ULL, 0x000ff00000202400ULL, 0x0000005000507306ULL, 0x000ff00000202400ULL,
0x0000002400247306ULL, 0x000e700000202400ULL, 0x0000003a003a7306ULL, 0x000ea20000202400ULL,
0x0000541024247816ULL, 0x002fce0000000015ULL, 0x0000007300737306ULL, 0x000fe20000202400ULL,
0x000054103a257816ULL, 0x004fce000000003bULL, 0x0000004400447306ULL, 0x000e620000202400ULL,
0x000000242028723cULL, 0x000fee0000041828ULL, 0x0000004200427306ULL, 0x000fe20000202400ULL,
0x0000541073747816ULL, 0x002fce0000000044ULL, 0x0000007500757306ULL, 0x000e700000202400ULL,
0x0000004500457306ULL, 0x000ea20000202400ULL, 0x0000541042757816ULL, 0x002fce0000000075ULL,
0x0000004700477306ULL, 0x000e620000202400ULL, 0x00000074203c723cULL, 0x000fe2000004183cULL,
0x0000541045027816ULL, 0x004fcc000000004cULL, 0x0000004600467306ULL, 0x000ea20000202400ULL,
0x0000541047037816ULL, 0x002fce0000000052ULL, 0x0000006400647306ULL, 0x000fe20000202400ULL,
0x000000022034723cULL, 0x000fe20000041834ULL, 0x0000541046267816ULL, 0x004fcc0000000065ULL,
0x0000006a00277306ULL, 0x000e700000202400ULL, 0x0000000800087306ULL, 0x000ea20000202400ULL,
0x0000541064277816ULL, 0x002fce0000000027ULL, 0x0000000900097306ULL, 0x000e620000202400ULL,
0x000000262030723cULL, 0x000fe20000041830ULL, 0x0000541008087816ULL, 0x004fcc0000000051ULL,
0x00000012000c7306ULL, 0x000fe20000202400ULL, 0x0000541009097816ULL, 0x002fce0000000050ULL,
0x0000000d000d7306ULL, 0x000e620000202400ULL, 0x000000082018723cULL, 0x000fee0000041818ULL,
0x0000004e004e7306ULL, 0x000fe20000202400ULL, 0x000054100c117816ULL, 0x002fce000000000dULL,
0x0000005700577306ULL, 0x000fe20000202400ULL, 0x00000010201c723cULL, 0x000fee000004181cULL,
0x0000000a000b7306ULL, 0x000e700000202400ULL, 0x0000000e000e7306ULL, 0x000ea20000202400ULL,
0x000054100b4e7816ULL, 0x002fc4000000004eULL, 0x000054100e4f7816ULL, 0x004fce0000000057ULL,
0x0000004e2020723cULL, 0x008fde0000041804ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000001361617c36ULL, 0x000fe20008000000ULL, 0x000000ff58ff7812ULL, 0x000fc8000780c0ffULL,
0x0000005e6100720cULL, 0x000fe40003f26070ULL, 0x00000001ff587807ULL, 0x000fd60000000000ULL,
0xffffffa800689947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x0001b0000a047890ULL, 0x000fe2000fffe03fULL, 0x00000000001579c3ULL, 0x000ea20000002500ULL,
0x0000000105067899ULL, 0x000fce000800063fULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000412077291ULL, 0x000fe4000f8e383fULL, 0x0000000206067892ULL, 0x000fc8000f8e0c3fULL,
0x00000007ff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000000106067892ULL, 0x000fc8000f8ef812ULL,
0x0000000406067291ULL, 0x000fcc000f8e383fULL, 0x00000006ff0b7e24ULL, 0x000fe2000f8e00ffULL,
0x000000155e007c0cULL, 0x004fe2000bf03070ULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x100fe40000011600ULL, 0x00000002ff0d7819ULL, 0x000fe40000011600ULL,
0x0000007002087812ULL, 0x000fe400078ec0ffULL, 0x0000000c03097812ULL, 0x000fe400078ec0ffULL,
0x0000020008027810ULL, 0x000fc40007ffe005ULL, 0x0000000709037c10ULL, 0x140fe4000fffe008ULL,
0x0000000609047c10ULL, 0x040fe2000fffe008ULL, 0x0000000109027824ULL, 0x000fe400078e0202ULL,
0x0000005c03007388ULL, 0x000fe80000000800ULL, 0x0000005b02007388ULL, 0x0003e20000000800ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000020008027810ULL, 0x002fca0007ffe00bULL,
0x0000000109027824ULL, 0x000fe200078e0202ULL, 0x0000000800097811ULL, 0x000fe200078ff0ffULL,
0x0000000004047984ULL, 0x000e680000000800ULL, 0x0000000002027984ULL, 0x000ea20000000800ULL,
0x0000005c04057209ULL, 0x002fca0007810000ULL, 0x0000005c05067221ULL, 0x000fe20000010100ULL,
0x8000000504047221ULL, 0x000fc60000010000ULL, 0x3fb8aa3b06067820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b04047820ULL, 0x000fc80000410000ULL, 0x0000000400037308ULL, 0x000eb00000000800ULL,
0x0000000600067308ULL, 0x000e620000000800ULL, 0x0000000302037220ULL, 0x004fe20000410000ULL,
0x00001f0d06077589ULL, 0x002e6600000e0000ULL, 0x0000005b065b7223ULL, 0x000fe20000010003ULL,
0x00001f0906087589ULL, 0x000ea200000e0000ULL, 0x0000002807287220ULL, 0x042fe20000410000ULL,
0x0000002907297220ULL, 0x040fe20000410000ULL, 0x0000002c072c7220ULL, 0x040fe20000410000ULL,
0x0000002d072d7220ULL, 0x040fe20000410000ULL, 0x0000003c073c7220ULL, 0x040fe20000410000ULL,
0x0000003d073d7220ULL, 0x040fe20000410000ULL, 0x0000003407347220ULL, 0x040fe20000410000ULL,
0x0000003507357220ULL, 0x040fe20000410000ULL, 0x0000003007307220ULL, 0x040fe20000410000ULL,
0x0000003107317220ULL, 0x040fe20000410000ULL, 0x0000001807187220ULL, 0x040fe20000410000ULL,
0x0000001907197220ULL, 0x040fe20000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000001d071d7220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000002107217220ULL, 0x000fe20000410000ULL, 0x0000002a082a7220ULL, 0x044fe20000410000ULL,
0x0000002b082b7220ULL, 0x040fe20000410000ULL, 0x0000002e082e7220ULL, 0x040fe20000410000ULL,
0x0000002f082f7220ULL, 0x040fe20000410000ULL, 0x0000003e083e7220ULL, 0x040fe20000410000ULL,
0x0000003f083f7220ULL, 0x040fe20000410000ULL, 0x0000003608367220ULL, 0x040fe20000410000ULL,
0x0000003708377220ULL, 0x040fe20000410000ULL, 0x0000003208327220ULL, 0x040fe20000410000ULL,
0x0000003308337220ULL, 0x040fe20000410000ULL, 0x0000001a081a7220ULL, 0x040fe20000410000ULL,
0x0000001b081b7220ULL, 0x040fe20000410000ULL, 0x0000001e081e7220ULL, 0x040fe20000410000ULL,
0x0000001f081f7220ULL, 0x040fe20000410000ULL, 0x0000002208227220ULL, 0x040fe20000410000ULL,
0x0000002308237220ULL, 0x000fe20000410000ULL, 0x0000000000dc0947ULL, 0x000fec0003800000ULL,
0x018000005b007836ULL, 0x000fe20000000000ULL, 0x000000d000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe200078e005bULL,
0x00006f0000047802ULL, 0x000fce0000000f00ULL, 0x0000009800887944ULL, 0x000fea0003c00000ULL,
0x000000ffff047224ULL, 0x008fe200078e0000ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000005b00047308ULL, 0x000e640000001000ULL, 0xbf8000005b007423ULL, 0x002fc80000000004ULL,
0x800000ff00037221ULL, 0x000fc80000010100ULL, 0x0000000304047223ULL, 0x000fce0000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009200ff027b82ULL, 0x000e640000000a00ULL,
0x0000000e02037981ULL, 0x002ea2000c1e9900ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x00000002ff0d7819ULL, 0x002fe40000011600ULL, 0x0000000800097811ULL, 0x000fe200078ff0ffULL,
0x0000000403047220ULL, 0x004fca0000410000ULL, 0x00001f0d04067589ULL, 0x000e6800000e0000ULL,
0x00001f0904077589ULL, 0x000ea200000e0000ULL, 0x0000000628287220ULL, 0x082fe20000410000ULL,
0x0000000629297220ULL, 0x080fe20000410000ULL, 0x000000062c2c7220ULL, 0x080fe20000410000ULL,
0x000000062d2d7220ULL, 0x080fe20000410000ULL, 0x000000063c3c7220ULL, 0x080fe20000410000ULL,
0x000000063d3d7220ULL, 0x080fe20000410000ULL, 0x0000000634347220ULL, 0x080fe20000410000ULL,
0x0000000635357220ULL, 0x080fe20000410000ULL, 0x0000000630307220ULL, 0x080fe20000410000ULL,
0x0000000631317220ULL, 0x080fe20000410000ULL, 0x0000000618187220ULL, 0x080fe20000410000ULL,
0x0000000619197220ULL, 0x080fe20000410000ULL, 0x000000061c1c7220ULL, 0x080fe20000410000ULL,
0x000000061d1d7220ULL, 0x080fe20000410000ULL, 0x0000000620207220ULL, 0x080fe20000410000ULL,
0x0000000621217220ULL, 0x000fe20000410000ULL, 0x000000072a2a7220ULL, 0x084fe20000410000ULL,
0x000000072b2b7220ULL, 0x080fe20000410000ULL, 0x000000072e2e7220ULL, 0x080fe20000410000ULL,
0x000000072f2f7220ULL, 0x080fe20000410000ULL, 0x000000073e3e7220ULL, 0x080fe20000410000ULL,
0x000000073f3f7220ULL, 0x080fe20000410000ULL, 0x0000000736367220ULL, 0x080fe20000410000ULL,
0x0000000737377220ULL, 0x080fe20000410000ULL, 0x0000000732327220ULL, 0x080fe20000410000ULL,
0x0000000733337220ULL, 0x080fe20000410000ULL, 0x000000071a1a7220ULL, 0x080fe20000410000ULL,
0x000000071b1b7220ULL, 0x080fe20000410000ULL, 0x000000071e1e7220ULL, 0x080fe20000410000ULL,
0x000000071f1f7220ULL, 0x080fe20000410000ULL, 0x0000000722227220ULL, 0x080fe20000410000ULL,
0x0000000723237220ULL, 0x000fce0000410000ULL, 0x0000000200027812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000a14047291ULL, 0x000fe2000f8e603fULL,
0x000000282928723eULL, 0x000fe200000010ffULL, 0x000000011300788cULL, 0x000fe2000bf05270ULL,
0x0000000202067811ULL, 0x040fe200078ff8ffULL, 0x0000000405167291ULL, 0x000fe2000f8e583fULL,
0x00000001ff047819ULL, 0x000fe40000011602ULL, 0x0000000402087811ULL, 0x040fe400078ff8ffULL,
0x00000006020c7811ULL, 0x000fc400078ff8ffULL, 0x0000000706037812ULL, 0x000fe400078e780dULL,
0x0000000704027812ULL, 0x000fe400078e780dULL, 0x00000007080a7812ULL, 0x000fe200078e780dULL,
0x000000080d077824ULL, 0x040fe200078e0203ULL, 0x0000000704047812ULL, 0x000fe200078e7809ULL,
0x000000080d027824ULL, 0x000fe200078e0202ULL, 0x000000070c0b7812ULL, 0x000fe200078e780dULL,
0x0000000800037824ULL, 0x000fe200078e00ffULL, 0x00000007060e7812ULL, 0x000fe200078e7809ULL,
0x0000000809067824ULL, 0x000fe200078e0204ULL, 0x0000000708087812ULL, 0x000fe200078e7809ULL,
0x000000080d0a7824ULL, 0x040fe200078e020aULL, 0x000000070c107812ULL, 0x000fe200078e7809ULL,
0x000000080d0b7824ULL, 0x000fe200078e020bULL, 0x0000000803037812ULL, 0x000fe200078ec0ffULL,
0x00000008090e7824ULL, 0x040fe200078e020eULL, 0x0000001602027c11ULL, 0x000fe2000f8e20ffULL,
0x00000008090c7824ULL, 0x000fe200078e0208ULL, 0x0000002c2d14723eULL, 0x000fe200000010ffULL,
0x0000000809107824ULL, 0x000fe200078e0210ULL, 0x0000001606087c11ULL, 0x000fe2000f8e20ffULL,
0x0000000102027824ULL, 0x000fe200078e0203ULL, 0x0000001607047c11ULL, 0x000fe2000f8e20ffULL,
0x00000005ff097e24ULL, 0x000fe2000f8e00ffULL, 0x000000160a0a7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000103087824ULL, 0x000fe200078e0208ULL, 0x000000160b067c11ULL, 0x000fe2000f8e20ffULL,
0x0000000103047824ULL, 0x040fe200078e0204ULL, 0x000000160e0e7c11ULL, 0x000fe2000f8e20ffULL,
0x00000001030a7824ULL, 0x040fe200078e020aULL, 0x000000160c0c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000103067824ULL, 0x040fe200078e0206ULL, 0x0000001610107c11ULL, 0x000fe2000f8e20ffULL,
0x0000000103077824ULL, 0x040fe200078e020eULL, 0x0000541028127816ULL, 0x040fe20000000014ULL,
0x00000001030c7824ULL, 0x040fe200078e020cULL, 0x0000763228137816ULL, 0x000fe20000000014ULL,
0x0000000103107824ULL, 0x000fe200078e0210ULL, 0x0000003c3d3c723eULL, 0x000fe200000010ffULL,
0x0000002009097824ULL, 0x000fe200078e0200ULL, 0x000000343534723eULL, 0x000fe200000010ffULL,
0x0000001202007388ULL, 0x0003e20000000a00ULL, 0x000000303130723eULL, 0x000fc400000010ffULL,
0x000076323c037816ULL, 0x140fe40000000034ULL, 0x000000181918723eULL, 0x000fe400000010ffULL,
0x0000001c1d1c723eULL, 0x000fe400000010ffULL, 0x00000020210e723eULL, 0x000fe400000010ffULL,
0x0000002a2b2a723eULL, 0x000fe400000010ffULL, 0x000054103c027816ULL, 0x002fc40000000034ULL,
0x0000002e2f15723eULL, 0x000fe400000010ffULL, 0x0000003e3f3e723eULL, 0x000fe200000010ffULL,
0x0000000204007388ULL, 0x0003e20000000a00ULL, 0x000000363736723eULL, 0x000fe400000010ffULL,
0x000054102a147816ULL, 0x140fe40000000015ULL, 0x000076322a157816ULL, 0x000fe40000000015ULL,
0x000076323e0b7816ULL, 0x000fc40000000036ULL, 0x000000323332723eULL, 0x000fe400000010ffULL,
0x0000001a1b19723eULL, 0x000fe400000010ffULL, 0x0000541030027816ULL, 0x142fe40000000018ULL,
0x0000763230037816ULL, 0x000fe40000000018ULL, 0x0000001e1f1e723eULL, 0x000fe400000010ffULL,
0x00000022230f723eULL, 0x000fe200000010ffULL, 0x000000020a007388ULL, 0x0003e20000000a00ULL,
0x000000000000781cULL, 0x000fc40003f0f008ULL, 0x000054101c027816ULL, 0x142fe4000000000eULL,
0x000076321c037816ULL, 0x000fe4000000000eULL, 0x000054103e0a7816ULL, 0x000fe40000000036ULL,
0x000054101e0e7816ULL, 0x140fe2000000000fULL, 0x0000000206007388ULL, 0x0003e20000000a00ULL,
0x000076321e0f7816ULL, 0x000fc6000000000fULL, 0x0000001408007388ULL, 0x000fe80000000a00ULL,
0x0000000a07007388ULL, 0x0005e20000000a00ULL, 0x0000541032067816ULL, 0x142fe20000000019ULL,
0x000000ff00027306ULL, 0x000e620000202400ULL, 0x0000000409037c11ULL, 0x000fe4000f8e20ffULL,
0x0000763232077816ULL, 0x004fca0000000019ULL, 0x000000060c007388ULL, 0x000fe80000000a00ULL,
0x0000000e10007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000003147984ULL, 0x000e680000000c00ULL, 0x00040000031c7984ULL, 0x000ea80000000c00ULL,
0x0008000003187984ULL, 0x000ee80000000c00ULL, 0x000c000003207984ULL, 0x000f220000000c00ULL,
0x0000001702177230ULL, 0x002fc40000200800ULL, 0x0000001602167230ULL, 0x040fe40000200800ULL,
0x0000001502157230ULL, 0x040fe40000200800ULL, 0x0000001402147230ULL, 0x040fe40000200800ULL,
0x0000001f021f7230ULL, 0x044fe40000200800ULL, 0x0000001e021e7230ULL, 0x040fe40000200800ULL,
0x0000001d021d7230ULL, 0x000fc40000200800ULL, 0x0000001c02027230ULL, 0x000fe40000200800ULL,
0x0000001b17177230ULL, 0x008fe40000200000ULL, 0x0000001a16167230ULL, 0x000fe40000200000ULL,
0x0000001915157230ULL, 0x000fe40000200000ULL, 0x0000001814147230ULL, 0x000fe40000200000ULL,
0x000000231f1f7230ULL, 0x010fc40000200000ULL, 0x000000221e1e7230ULL, 0x000fe20000200000ULL,
0x0000001403007388ULL, 0x0003e20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000200000ULL,
0x00000020021c7230ULL, 0x000fca0000200000ULL, 0x0004001c03007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000002800ec8947ULL, 0x000fea0003800000ULL,
0x00000000030c7984ULL, 0x0004a20000000c00ULL, 0x00000000000c79c3ULL, 0x000fe20000002700ULL,
0x00000001053f7892ULL, 0x000fe4000f80f812ULL, 0x0004000003107984ULL, 0x0004a20000000c00ULL,
0x0000840000087ab9ULL, 0x000fe40000000800ULL, 0x00000008130772a4ULL, 0x000fe2000f8e023fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x00000000000679c3ULL, 0x000ee40000002600ULL,
0x000000080c0c72a4ULL, 0x008fc6000f8e0206ULL, 0x0000900000087ab9ULL, 0x000fe20000000800ULL,
0x000000130c0672a4ULL, 0x000fe4000f8e023fULL, 0x00000008070772a4ULL, 0x000fe4000f8e023fULL,
0x00000015060a7290ULL, 0x000fe4000fffe03fULL, 0x01ffffff07177892ULL, 0x000fe2000f8ec03fULL,
0x0000000000380947ULL, 0x006ff60003800000ULL, 0x000000170a0b7290ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x0000960000087ab9ULL, 0x000fe20000000a00ULL,
0x00000001ff037819ULL, 0x000fe20000011600ULL, 0x000000800a1078a5ULL, 0x000fe4000f8e0008ULL,
0x000000800b0878a5ULL, 0x000fe2000f8e0008ULL, 0x0000007002067812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000001003027c10ULL, 0x140fe4000fa3e006ULL,
0x0000000803067c10ULL, 0x000fe4000fc7e006ULL, 0x00000011ff037c10ULL, 0x000fe40008fe44ffULL,
0x00000009ff077c10ULL, 0x000fc60009fe84ffULL, 0x0000000502007986ULL, 0x0003e8000c10190eULL,
0x0000005b06007986ULL, 0x0003e4000c10190eULL, 0x00000fff07077891ULL, 0x000fe2000f8e403fULL,
0x000000ff0000720cULL, 0x000fe20000705670ULL, 0x0000000b12087899ULL, 0x000fe2000800063fULL,
0x0000004009077836ULL, 0x002fe20000000000ULL, 0x0000000a070a7291ULL, 0x000fe2000f8fa03fULL,
0x0000024000007945ULL, 0x000fe20003800000ULL, 0x0000960000107ab9ULL, 0x000fe20000000a00ULL,
0x0000080008087892ULL, 0x000fe4000f8ee23fULL, 0x000010000a0a78a5ULL, 0x000fc8000f8e0010ULL,
0x000000080a097290ULL, 0x000fc8000ff1e03fULL, 0x0000000b3f0a7290ULL, 0x000fe400087fe43fULL,
0x00000009ff027e24ULL, 0x000fc8000f8e00ffULL, 0x0000000aff037e24ULL, 0x000fe4000f8e00ffULL,
0x0000001009047825ULL, 0x000fc800078e0002ULL, 0x0000001007027825ULL, 0x000fe200078e0002ULL,
0x0000000c04007986ULL, 0x0003e8000c101d0eULL, 0x0000001002007986ULL, 0x0003e2000c101d0eULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000000580947ULL, 0x000fea0003800000ULL,
0x00009400000a7ab9ULL, 0x000fe20000000a00ULL, 0xffffffff130d7890ULL, 0x000fe4000fffe03fULL,
0x000000040c0a78a5ULL, 0x000fc8000f8e000aULL, 0x0000000dff057e24ULL, 0x002fe4000f8e00ffULL,
0x0000000aff027e24ULL, 0x000fe4000f8e00ffULL, 0x0000000bff037e24ULL, 0x000fe2000f8e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x0003ec0000008000ULL, 0x0000000000007992ULL, 0x002fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000005020279a8ULL, 0x000ea800099ee1ceULL, 0x00000000ff00798fULL, 0x004fe20002000000ULL,
0x00000000000a79c3ULL, 0x000e620000008800ULL, 0x0000040000097882ULL, 0x000fc40000000000ULL,
0x000006540a097896ULL, 0x002fe20008000009ULL, 0x0000000d02007c0cULL, 0x000fc8000bf05270ULL,
0x00000001ff047807ULL, 0x000fca0000000000ULL, 0x00000004ff007988ULL, 0x0003e80008000009ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000a79c3ULL, 0x000eb00000008800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000040000097882ULL, 0x000fc40000000000ULL,
0x000006540a097896ULL, 0x004fd20008000009ULL, 0x00000009ff027984ULL, 0x002e640008000000ULL,
0x000000ff0200720cULL, 0x002fda0003f05270ULL, 0x0000002400b48947ULL, 0x000fea0003800000ULL,
0x00000012ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000c00480947ULL, 0x000fea0003800000ULL,
0x00000013ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000000f08947ULL, 0x000fea0003800000ULL,
0x00000001060a7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe20000011600ULL, 0x00000080060c78a5ULL, 0x000fe4000f8e0010ULL,
0x000000800a0a78a5ULL, 0x000fe2000f8e0010ULL, 0x0000007002087812ULL, 0x000fe400078ec0ffULL,
0x0000000c03117812ULL, 0x000fc800078ec0ffULL, 0x0000000c11027c10ULL, 0x140fe4000f91e008ULL,
0x0000000a11047c10ULL, 0x000fe4000fb5e008ULL, 0x0000000dff037c10ULL, 0x000fe400087e24ffULL,
0x0000000bff057c10ULL, 0x000fc600097e64ffULL, 0x0000000e02067981ULL, 0x000368000c1e1900ULL,
0x0000000e04077981ULL, 0x000362000c1e1900ULL, 0x000000021300788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x00000002060a7890ULL, 0x000fc8000fffe03fULL, 0x000000800a0a78a5ULL, 0x000fcc000f8e0010ULL,
0x0000000a11027c10ULL, 0x000fc8000f91e008ULL, 0x0000000bff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e02097981ULL, 0x000362000c1e1900ULL, 0x000000041300788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000908947ULL, 0x002fea0003800000ULL,
0x00000003060a7890ULL, 0x000fc8000fffe03fULL, 0x000000800a0a78a5ULL, 0x000fcc000f8e0010ULL,
0x0000000a11027c10ULL, 0x000fc8000f91e008ULL, 0x0000000bff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020b7981ULL, 0x000362000c1e1900ULL, 0x000000041300788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000708947ULL, 0x002fea0003800000ULL,
0x00000004060a7890ULL, 0x000fc8000fffe03fULL, 0x000000800a0a78a5ULL, 0x000fcc000f8e0010ULL,
0x0000000a11027c10ULL, 0x000fc8000f91e008ULL, 0x0000000bff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020d7981ULL, 0x000362000c1e1900ULL, 0x000000061300788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000508947ULL, 0x002fea0003800000ULL,
0x00000005060a7890ULL, 0x000fc8000fffe03fULL, 0x000000800a0a78a5ULL, 0x000fcc000f8e0010ULL,
0x0000000a11027c10ULL, 0x000fc8000f91e008ULL, 0x0000000bff037c10ULL, 0x000fca00087e24ffULL,
0x0000000e020f7981ULL, 0x000362000c1e1900ULL, 0x000000061300788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000308947ULL, 0x002fea0003800000ULL,
0x000000081300788cULL, 0x000fe4000bf06070ULL, 0x00000006060a7890ULL, 0x000fc8000fffe03fULL,
0x000000000000781cULL, 0x000fe20003f8f008ULL, 0x000000800a0a78a5ULL, 0x000fc8000f8e0010ULL,
0x00000007060c0890ULL, 0x000fe4000fffe03fULL, 0x0000000a11027c10ULL, 0x000fe4000f91e008ULL,
0x000000800c0c08a5ULL, 0x000fe4000f8e0010ULL, 0x0000000bff037c10ULL, 0x000fc800087e24ffULL,
0x0000000c11044c10ULL, 0x000fe4000fb5e008ULL, 0x0000000e02117981ULL, 0x000364000c1e1900ULL,
0x0000000dff054c10ULL, 0x000fca00097e64ffULL, 0x0000000e04134981ULL, 0x000368000c1e1900ULL,
0x00000007130a7890ULL, 0x000fc8000fffe03fULL, 0x000000033f0c7899ULL, 0x000fcc000801160aULL,
0x0000000cff007c0cULL, 0x000fda000bf05270ULL, 0x0000000800248947ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x002fe200078e00ffULL, 0x00000006000d7c82ULL, 0x000fe20008000000ULL,
0x000000ffff057224ULL, 0x020fe200078e0006ULL, 0x0000960000187ab9ULL, 0x000fe20000000a00ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x0000001304007c0cULL, 0x000fe2000bf26070ULL,
0x0000000108087836ULL, 0x000fca0000000000ULL, 0x0000000c08007c0cULL, 0x000fce000bf06070ULL,
0x0000000400f41947ULL, 0x022fec0003800000ULL, 0x0000000804027836ULL, 0x000fe20000000000ULL,
0x0000000506067209ULL, 0x000fe20007810000ULL, 0x0000000104037836ULL, 0x000fc60000000000ULL,
0x0000001302007c0cULL, 0x000fe4000bf26070ULL, 0x0000001303007c0cULL, 0x000fd6000bf46070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000080d0a7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000a03027c10ULL, 0x000fc8000fb3e002ULL,
0x0000000bff037c10ULL, 0x000fca0008fe64ffULL, 0x0000000e02057981ULL, 0x000368000c1e1900ULL,
0x0000000400b42947ULL, 0x000fea0003800000ULL, 0x0000000904027836ULL, 0x002fe20000000000ULL,
0x0000000706067209ULL, 0x000fe20007810000ULL, 0x0000000204037836ULL, 0x000fc60000000000ULL,
0x0000001302007c0cULL, 0x000fe4000bf26070ULL, 0x0000001303007c0cULL, 0x000fd6000bf46070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000090d0a7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000a03027c10ULL, 0x000fc8000fb3e002ULL,
0x0000000bff037c10ULL, 0x000fca0008fe64ffULL, 0x0000000e02077981ULL, 0x000368000c1e1900ULL,
0x0000000400742947ULL, 0x000fea0003800000ULL, 0x0000000a04027836ULL, 0x002fe20000000000ULL,
0x0000000906067209ULL, 0x000fe20007810000ULL, 0x0000000304037836ULL, 0x000fc60000000000ULL,
0x0000001302007c0cULL, 0x000fe4000bf26070ULL, 0x0000001303007c0cULL, 0x000fd6000bf46070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000000a0d0a7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000a03027c10ULL, 0x000fc8000fb3e002ULL,
0x0000000bff037c10ULL, 0x000fca0008fe64ffULL, 0x0000000e02097981ULL, 0x000368000c1e1900ULL,
0x0000000400342947ULL, 0x000fea0003800000ULL, 0x0000000b04027836ULL, 0x002fe20000000000ULL,
0x0000000b06067209ULL, 0x000fe20007810000ULL, 0x0000000404037836ULL, 0x000fc60000000000ULL,
0x0000001302007c0cULL, 0x000fe4000bf26070ULL, 0x0000001303007c0cULL, 0x000fd6000bf46070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000000b0d0a7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000a03027c10ULL, 0x000fc8000fb3e002ULL,
0x0000000bff037c10ULL, 0x000fca0008fe64ffULL, 0x0000000e020b7981ULL, 0x000368000c1e1900ULL,
0x0000000000f42947ULL, 0x000fea0003800000ULL, 0x0000000c04027836ULL, 0x002fe20000000000ULL,
0x0000000d06067209ULL, 0x000fe20007810000ULL, 0x0000000504037836ULL, 0x000fc60000000000ULL,
0x0000001302007c0cULL, 0x000fe4000bf26070ULL, 0x0000001303007c0cULL, 0x000fd6000bf46070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000000c0d0a7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000a03027c10ULL, 0x000fc8000fb3e002ULL,
0x0000000bff037c10ULL, 0x000fca0008fe64ffULL, 0x0000000e020d7981ULL, 0x000368000c1e1900ULL,
0x0000000000b42947ULL, 0x000fea0003800000ULL, 0x0000000d04027836ULL, 0x002fe20000000000ULL,
0x0000000f06067209ULL, 0x000fe20007810000ULL, 0x0000000604037836ULL, 0x000fc60000000000ULL,
0x0000001302007c0cULL, 0x000fe4000bf26070ULL, 0x0000001303007c0cULL, 0x000fd6000bf46070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000000d0d0a7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000a03027c10ULL, 0x000fc8000fb3e002ULL,
0x0000000bff037c10ULL, 0x000fca0008fe64ffULL, 0x0000000e020f7981ULL, 0x000368000c1e1900ULL,
0x0000000000742947ULL, 0x000fea0003800000ULL, 0x0000000e04027836ULL, 0x002fe20000000000ULL,
0x0000001106067209ULL, 0x000fe20007810000ULL, 0x0000000704037836ULL, 0x000fc60000000000ULL,
0x0000001302007c0cULL, 0x000fe4000bf26070ULL, 0x0000001303007c0cULL, 0x000fd6000bf46070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000000e0d0a7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000a03027c10ULL, 0x000fc8000fb3e002ULL,
0x0000000bff037c10ULL, 0x000fca0008fe64ffULL, 0x0000000e02117981ULL, 0x000368000c1e1900ULL,
0x0000000000342947ULL, 0x000fea0003800000ULL, 0x0000000f04027836ULL, 0x002fe20000000000ULL,
0x0000001306067209ULL, 0x000fc80007810000ULL, 0x0000001302007c0cULL, 0x000fda000bf26070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x0000000f0d0a7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800a0a78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000a03027c10ULL, 0x000fc8000fa3e002ULL,
0x0000000bff037c10ULL, 0x000fca0008fe44ffULL, 0x0000000e02137981ULL, 0x000368000c1e1900ULL,
0x000000080d0d7890ULL, 0x000fe2000fffe03fULL, 0x0000000804047836ULL, 0x000fe20000000000ULL,
0xfffffff400f08947ULL, 0x000ff4000383ffffULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x0000001000027824ULL, 0x006fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000903037c10ULL, 0x000fca000fffe002ULL, 0x0000000603007388ULL, 0x0203e40000000800ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x00000006051a7290ULL, 0x000fe2000fffe03fULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000023f0a7899ULL, 0x000fe20008011612ULL,
0x0000001000027824ULL, 0x040fe200078e00ffULL, 0x0000000905197291ULL, 0x000fe2000f8e683fULL,
0x00000001ff037819ULL, 0x002fe20000011600ULL, 0x0000001a07187291ULL, 0x000fe2000f8fa03fULL,
0x0000002000077836ULL, 0x000fe20000000000ULL, 0x00009600000c7ab9ULL, 0x000fe20000000a00ULL,
0x000000010a0b7892ULL, 0x000fe2000f8ec03fULL, 0x0000007002027812ULL, 0x000fe200078ec0ffULL,
0x00000019140a7291ULL, 0x000fe2000f8e603fULL, 0x0000000c03037812ULL, 0x000fe200078ec0ffULL,
0x00001000181878a5ULL, 0x000fe2000f8e000cULL, 0x0000004000097836ULL, 0x040fe20000000000ULL,
0x00000000003f7886ULL, 0x000fe20000020000ULL, 0x00000060000b7836ULL, 0x040fe20000000000ULL,
0x00000008181f7290ULL, 0x000fe2000ff1e03fULL, 0x0000000903147c10ULL, 0x000fe2000fffe002ULL,
0x00000009121b7899ULL, 0x000fe2000800063fULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x000000193f1e7290ULL, 0x000fe200087fe43fULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000008001b1b7892ULL, 0x000fe2000f8ec03fULL, 0x0000001fff047e24ULL, 0x000fe2000f8e00ffULL,
0x0000001a171c9290ULL, 0x000fe2000fffe03fULL, 0x0000000014147984ULL, 0x000e620000000800ULL,
0x00000009051d9291ULL, 0x000fe2000f8e483fULL, 0x0000001eff057e24ULL, 0x000fe2000f8e00ffULL,
0x000000801a1898a5ULL, 0x000fe2000f8e000cULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000009051a9291ULL, 0x000fe2000f8e483fULL, 0x0000001007067825ULL, 0x100fe200078e0004ULL,
0x0000001b0a1b7290ULL, 0x000fe2000fffe03fULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x000000801c0c98a5ULL, 0x000fe2000f8e000cULL, 0x0000001009087825ULL, 0x100fe200078e0004ULL,
0x0000001d141d9291ULL, 0x000fe2000f8e403fULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000001a141a9291ULL, 0x000fe2000f8e403fULL, 0x000000100b0a7825ULL, 0x100fe200078e0004ULL,
0x0000001d0b1d9291ULL, 0x000fe2000f8e383fULL, 0x0000001b00117c11ULL, 0x040fe2000f8e20ffULL,
0x0000001a0b1a9291ULL, 0x000fe2000f8e383fULL, 0x0000001000047825ULL, 0x000fe200078e0004ULL,
0x000000130500728cULL, 0x000fe2000bf06070ULL, 0x00000000002e7805ULL, 0x000fc4000001ff00ULL,
0x0000001d00138c11ULL, 0x040fe2000f8e20ffULL, 0x0000000cff0c7e24ULL, 0x000fe2000f8e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000004117faeULL, 0x000fe2000b901c4eULL,
0x0000000dff0d7e24ULL, 0x000fe2000f8e00ffULL, 0x0000001a00158c11ULL, 0x040fe2000f8e20ffULL,
0x00000018ff0e7e24ULL, 0x000fe2000f8e00ffULL, 0x0038000006117faeULL, 0x000fe2000b901c4eULL,
0x00000019ff0f7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000010000c8825ULL, 0x000fe200078e000cULL, 0x0058000008117faeULL, 0x000fe2000b901c4eULL,
0x00000000001e7805ULL, 0x000fc4000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000010000e8825ULL, 0x000fe200078e000eULL, 0x007800000a117faeULL, 0x000fe2000b901c4eULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x045800000c138faeULL, 0x000fe2000b901c4eULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x041800000e158faeULL, 0x0005e2000b901c4eULL,
0x000000000000781cULL, 0x000fe40003f0f008ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff157224ULL, 0x004fd200078e00ffULL,
0x0000000800f40947ULL, 0x002fea0003800000ULL, 0x00000003ff047819ULL, 0x100fe20000011600ULL,
0x00000009050b7291ULL, 0x000fe2000f8e483fULL, 0xfffffff8ff057812ULL, 0x000fe200078ee200ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x0000000304047812ULL, 0x000fe200078ec0ffULL,
0x0000000b140b7291ULL, 0x000fe2000f8e403fULL, 0x00000002ff387819ULL, 0x000fe20000011600ULL,
0x0000000805077836ULL, 0x040fe20000000000ULL, 0x0000000404067812ULL, 0x000fe200078efcffULL,
0x0000000805377824ULL, 0x000fe200078e00ffULL, 0x0000000704367812ULL, 0x000fe200078e7805ULL,
0x00000008383c7836ULL, 0x000fe20000000000ULL, 0x0000000704087812ULL, 0x000fe200078e7807ULL,
0x0000000bff3b7e24ULL, 0x000fe2000f8e00ffULL, 0x00000007063a7812ULL, 0x000fe200078e7807ULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x0000000706047812ULL, 0x000fe200078e7805ULL,
0x00000005000b7c82ULL, 0x000fe20008000000ULL, 0x0000003736367212ULL, 0x080fe200078efcffULL,
0x00009600001e7ab9ULL, 0x000fe20000000a00ULL, 0x0000003704377212ULL, 0x000fc400078efcffULL,
0x0000000708397212ULL, 0x080fe400078efcffULL, 0x000000073a3a7212ULL, 0x000fce00078efcffULL,
0x000000020b1a7890ULL, 0x000fc8000fffe03fULL, 0x000000131a00728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000cc0947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x0000001a061d7290ULL, 0x000fe2000fffe03fULL,
0x0000002000097836ULL, 0x040fe20000000000ULL, 0x0000000a1a0d7899ULL, 0x000fe2000800063fULL,
0x00000040000b7836ULL, 0x040fe20000000000ULL, 0x0000001d07187291ULL, 0x000fe2000f8fa03fULL,
0x00000060003d7836ULL, 0x000fe20000000000ULL, 0x000000013f0c7899ULL, 0x000fe4000801161aULL,
0x00001000181878a5ULL, 0x000fe4000f8e001eULL, 0x000008000d0d7892ULL, 0x000fc4000f8ec03fULL,
0x00000000003f7886ULL, 0x000fe20000020000ULL, 0x0000000818237290ULL, 0x000fe4000ff1e03fULL,
0x000000010c207892ULL, 0x000fe4000f8ec03fULL, 0x0000000905219291ULL, 0x000fe4000f8e483fULL,
0x0000000d0a1b7290ULL, 0x000fe2000fffe03fULL, 0x00000023ff047e24ULL, 0x000fe2000f8e00ffULL,
0x0000002114219291ULL, 0x000fe2000f8e403fULL, 0x00000020ff107e24ULL, 0x000fe2000f8e00ffULL,
0x0000000905229291ULL, 0x000fc4000f8e483fULL, 0x0000001d171c9290ULL, 0x000fe2000fffe03fULL,
0x0000001b00117c11ULL, 0x000fe2000f8e20ffULL, 0x000000801d0c98a5ULL, 0x000fe2000f8e001eULL,
0x00000021ff3b8e24ULL, 0x000fe2000f8e00ffULL, 0x000000193f1d7290ULL, 0x000fe400087fe43fULL,
0x0000002214229291ULL, 0x000fe2000f8e403fULL, 0x0000008010138824ULL, 0x000fe200078e023bULL,
0x000000801c1898a5ULL, 0x000fe2000f8e001eULL, 0x0000000cff0e7e24ULL, 0x000fe4000f8e00ffULL,
0x0000001dff057e24ULL, 0x000fc4000f8e00ffULL, 0x00000022ff3b8e24ULL, 0x000fe4000f8e00ffULL,
0x0000001000067825ULL, 0x000fc800078e0004ULL, 0x0000001009087825ULL, 0x100fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000006117faeULL, 0x0003e6000b901c4eULL,
0x000000100b0a7825ULL, 0x000fe200078e0004ULL, 0x0038000008117faeULL, 0x0003e6000b901c4eULL,
0x00000018ff0c7e24ULL, 0x000fe2000f8e00ffULL, 0x005800000a117faeULL, 0x0003e2000b901c4eULL,
0x00000019ff0d7e24ULL, 0x000fc4000f8e00ffULL, 0x000000103d047825ULL, 0x000fc800078e0004ULL,
0x0000000dff0f7e24ULL, 0x000fe2000f8e00ffULL, 0x0078000004117faeULL, 0x0003e2000b901c4eULL,
0x00000080103d8824ULL, 0x000fe400078e023bULL, 0x00000010000c8825ULL, 0x000fc800078e000cULL,
0x0000001000138824ULL, 0x040fe400078e0213ULL, 0x00000010000e8825ULL, 0x000fc600078e000eULL,
0x045800000c138faeULL, 0x0003e2000b901c4eULL, 0x00000010003d8824ULL, 0x000fca00078e023dULL,
0x041800000e3d8faeULL, 0x0003e4000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000b000c7c82ULL, 0x000fe40008000000ULL, 0x000000060c0b7899ULL, 0x000fc8000800063fULL,
0x000000800b0b7892ULL, 0x000fcc000f8ec03fULL, 0x0000000b02047c10ULL, 0x002fe2000fffe03bULL,
0x0000000a0c0b7899ULL, 0x000fc8000800063fULL, 0x00000001033d7824ULL, 0x000fe200078e0204ULL,
0x000008000b0b7892ULL, 0x000fc8000f8ec03fULL, 0x000001800a0b7890ULL, 0x000fe2000fffe00bULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180003d0d7984ULL, 0x000e620000000800ULL,
0x0000000b36047c11ULL, 0x000fe4000f8e20ffULL, 0x0000000b37087c11ULL, 0x000fe2000f8e20ffULL,
0x004580003d3f7984ULL, 0x000fe20000000800ULL, 0x0000000b390c7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000b3a107c11ULL, 0x000fe2000f8e20ffULL, 0x000000000404783bULL, 0x000ea20000000200ULL,
0x0000001a000b7c82ULL, 0x000fe40008000000ULL, 0x000000130b00728cULL, 0x000fe2000bf06070ULL,
0x000000000808783bULL, 0x000eea0000000200ULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000d14117221ULL, 0x002fc40000010100ULL, 0x000000000c0c783bULL, 0x000e640000000200ULL,
0x3fb8aa3b11427820ULL, 0x000fe40000410000ULL, 0x000000001010783bULL, 0x000f220000000200ULL,
0x00010000043d7824ULL, 0x044fe200078e00ffULL, 0x0000763204047816ULL, 0x000fe40000000004ULL,
0x0000004200427308ULL, 0x000ea20000000800ULL, 0x0000763207417816ULL, 0x000fe20000000041ULL,
0x0001000005407824ULL, 0x040fe200078e00ffULL, 0x00007632053e7816ULL, 0x000fe2000000003eULL,
0x0001000004047824ULL, 0x000fe200078e00ffULL, 0x0000763209437816ULL, 0x008fe20000000043ULL,
0x000100000b467824ULL, 0x040fe200078e00ffULL, 0x000076320b457816ULL, 0x000fe20000000045ULL,
0x000100003e057824ULL, 0x000fe200078e00ffULL, 0x000076320a447816ULL, 0x000fe20000000044ULL,
0x0001000007077824ULL, 0x000fc400078e00ffULL, 0x0001000009097824ULL, 0x000fe400078e00ffULL,
0x000100000a0a7824ULL, 0x000fe400078e00ffULL, 0x0000003f424f7220ULL, 0x004fe20000410000ULL,
0x0000763208427816ULL, 0x040fe20000000042ULL, 0x0001000008087824ULL, 0x000fe200078e00ffULL,
0x00007632063f7816ULL, 0x040fe2000000003fULL, 0x000000344f347221ULL, 0x000fe20000010000ULL,
0x00001f384f4e7589ULL, 0x000ea200000e0000ULL, 0x0001000006067824ULL, 0x000fc400078e00ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00001f3c4f4f7589ULL, 0x000ee200000e0000ULL,
0x0001000045457824ULL, 0x000fe200078e00ffULL, 0x000076320d477816ULL, 0x042fe20000000047ULL,
0x000100000d487824ULL, 0x000fe200078e00ffULL, 0x000076320e0d7816ULL, 0x040fe2000000000dULL,
0x000100000e497824ULL, 0x000fe200078e00ffULL, 0x000076320f0e7816ULL, 0x040fe2000000000eULL,
0x000100000f4a7824ULL, 0x000fe200078e00ffULL, 0x00007632100f7816ULL, 0x050fe2000000000fULL,
0x00010000104b7824ULL, 0x000fe200078e00ffULL, 0x00007632124c7816ULL, 0x040fe2000000004cULL,
0x00010000124d7824ULL, 0x000fe200078e00ffULL, 0x000076320c0b7816ULL, 0x040fe2000000000bULL,
0x000100000c0c7824ULL, 0x000fc400078e00ffULL, 0x0000004e042d7223ULL, 0x084fe2000001002dULL,
0x0001000041047824ULL, 0x000fe400078e00ffULL, 0x0000004e052a7223ULL, 0x080fe2000001002aULL,
0x0000763211107816ULL, 0x000fe20000000010ULL, 0x0001000042057824ULL, 0x000fe400078e00ffULL,
0x0000004e04237223ULL, 0x080fe20000010023ULL, 0x0001000043047824ULL, 0x000fe200078e00ffULL,
0x0000763213127816ULL, 0x000fe20000000012ULL, 0x0000004e05207223ULL, 0x000fe20000010020ULL,
0x0001000011117824ULL, 0x000fc400078e00ffULL, 0x0000004e041d7223ULL, 0x080fe2000001001dULL,
0x0001000047047824ULL, 0x000fe400078e00ffULL, 0x0000004e3d2e7223ULL, 0x080fe2000001002eULL,
0x0001000013137824ULL, 0x000fe400078e00ffULL, 0x0000004e402b7223ULL, 0x080fe2000001002bULL,
0x0000004f04297223ULL, 0x008fe20000010029ULL, 0x0001000044057824ULL, 0x000fe400078e00ffULL,
0x0000004e06277223ULL, 0x000fe20000010027ULL, 0x000100000b0b7824ULL, 0x000fc400078e00ffULL,
0x0000004e3f267223ULL, 0x080fe20000010026ULL, 0x000100000d0d7824ULL, 0x000fe400078e00ffULL,
0x0000004e07247223ULL, 0x080fe20000010024ULL, 0x000100000e0e7824ULL, 0x000fe400078e00ffULL,
0x0000004e08217223ULL, 0x080fe20000010021ULL, 0x000100000f047824ULL, 0x000fe400078e00ffULL,
0x0000004e091e7223ULL, 0x000fe2000001001eULL, 0x0001000010107824ULL, 0x000fc400078e00ffULL,
0x0000004e0a1b7223ULL, 0x080fe2000001001bULL, 0x000100004c4c7824ULL, 0x000fe400078e00ffULL,
0x0000004e051a7223ULL, 0x080fe2000001001aULL, 0x0001000012127824ULL, 0x000fe400078e00ffULL,
0x0000004e46177223ULL, 0x080fe20000010017ULL, 0x0000004e45167223ULL, 0x000fe20000010016ULL,
0x0000004f0c157223ULL, 0x080fe20000010015ULL, 0x0000004f0b2c7223ULL, 0x080fe2000001002cULL,
0x0000004f48337223ULL, 0x080fe20000010033ULL, 0x0000004f49287223ULL, 0x080fe20000010028ULL,
0x0000004f0d327223ULL, 0x080fe20000010032ULL, 0x0000004f4a257223ULL, 0x080fe20000010025ULL,
0x0000004f0e317223ULL, 0x080fe20000010031ULL, 0x0000004f4b227223ULL, 0x080fe20000010022ULL,
0x0000004f041f7223ULL, 0x080fe2000001001fULL, 0x0000004f11307223ULL, 0x080fe20000010030ULL,
0x0000004f102f7223ULL, 0x080fe2000001002fULL, 0x0000004f4d1c7223ULL, 0x080fe2000001001cULL,
0x0000004f4c197223ULL, 0x080fe20000010019ULL, 0x0000004f13187223ULL, 0x080fe20000010018ULL,
0x0000004f12357223ULL, 0x000fe20000010035ULL, 0xfffffff400688947ULL, 0x000fec000383ffffULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x00000014ff007c0cULL, 0x000fe2000bf05270ULL,
0x00004980090a7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002007812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000a03007c10ULL, 0x000fe2000fffe000ULL,
0x0000000000200947ULL, 0x000fec0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000000905097291ULL, 0x000fe2000f8e383fULL, 0x0000001002037824ULL, 0x002fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011602ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ec0ffULL, 0x0000000902037c10ULL, 0x000fca000fffe003ULL,
0x0049803403007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000027984ULL, 0x000ea80000000800ULL, 0x0000800000037984ULL, 0x002e620000000800ULL,
0x00000002ff027221ULL, 0x004fc80000010000ULL, 0x0000000302027221ULL, 0x002fc80000010000ULL,
0x0180000002037836ULL, 0x000fca0000000000ULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00009db000047802ULL, 0x000fce0000000f00ULL,
0x0000006800dc7944ULL, 0x000fea0003c00000ULL, 0x000000ffff037224ULL, 0x008fe200078e0000ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000200037308ULL, 0x000e640000001000ULL,
0xbf80000002007423ULL, 0x002fc80000000003ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003037223ULL, 0x000fce0000000003ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x00000002ff027819ULL, 0x102fe40000011600ULL, 0x00000008000c7811ULL, 0x000fe400078ff0ffULL,
0x00000003ff0d7819ULL, 0x000fe20000011600ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0203027589ULL, 0x000e6200000e0000ULL, 0xfffffff8ff127812ULL, 0x000fc400078ee200ULL,
0x000000030d0f7812ULL, 0x000fe200078ec0ffULL, 0x00001f0c030c7589ULL, 0x0004e400000e0000ULL,
0x0000000812147836ULL, 0x000fe20000000000ULL, 0x000000040f137812ULL, 0x000fe200078efcffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000070f117812ULL, 0x000fe200078e7812ULL,
0x0000002102087220ULL, 0x042fe20000410000ULL, 0x0000002002037220ULL, 0x044fe20000410000ULL,
0x0000002e02047220ULL, 0x040fe20000410000ULL, 0x0000002d022d7220ULL, 0x000fe20000410000ULL,
0x000000150c157220ULL, 0x048fe20000410000ULL, 0x0000002c0c2c7220ULL, 0x040fe20000410000ULL,
0x000000330c337220ULL, 0x040fe20000410000ULL, 0x000000290c0e7220ULL, 0x040fe20000410000ULL,
0x000000280c287220ULL, 0x040fe20000410000ULL, 0x000000320c0d7220ULL, 0x040fe20000410000ULL,
0x000000250c257220ULL, 0x040fe20000410000ULL, 0x000000310c107220ULL, 0x040fe20000410000ULL,
0x000000220c227220ULL, 0x040fe20000410000ULL, 0x0000001f0c1f7220ULL, 0x040fe20000410000ULL,
0x000000300c307220ULL, 0x040fe20000410000ULL, 0x0000002f0c2f7220ULL, 0x040fe20000410000ULL,
0x0000001c0c1c7220ULL, 0x040fe20000410000ULL, 0x000000190c197220ULL, 0x040fe20000410000ULL,
0x000000180c187220ULL, 0x040fe20000410000ULL, 0x000000350c357220ULL, 0x000fe20000410000ULL,
0x0000002b02057220ULL, 0x040fe20000410000ULL, 0x0000002a022a7220ULL, 0x040fe20000410000ULL,
0x0000002702067220ULL, 0x040fe20000410000ULL, 0x0000002602077220ULL, 0x040fe20000410000ULL,
0x0000002402247220ULL, 0x040fe20000410000ULL, 0x0000002302237220ULL, 0x040fe20000410000ULL,
0x0000001e02097220ULL, 0x040fe20000410000ULL, 0x0000001d020a7220ULL, 0x040fe20000410000ULL,
0x0000001b021b7220ULL, 0x040fe20000410000ULL, 0x0000001a021a7220ULL, 0x040fe20000410000ULL,
0x00000017020b7220ULL, 0x000fe20000410000ULL, 0x00000008120c7824ULL, 0x000fc400078e00ffULL,
0x0000001602027220ULL, 0x000fe20000410000ULL, 0x000000070f177812ULL, 0x000fe200078e7814ULL,
0x0000000814167824ULL, 0x000fe200078e00ffULL, 0x00000007130f7812ULL, 0x000fe400078e7812ULL,
0x00000007131d7812ULL, 0x000fe400078e7814ULL, 0x000000080308723eULL, 0x000fe200000010ffULL,
0x00000005ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000c11117212ULL, 0x080fe400078efcffULL,
0x0000000c0f127212ULL, 0x000fc400078efcffULL, 0x0000001617137212ULL, 0x080fe400078efcffULL,
0x000000161d1d7212ULL, 0x000fe400078efcffULL, 0x000000060706723eULL, 0x000fe400000010ffULL,
0x0000000b020b723eULL, 0x000fe400000010ffULL, 0x00000018350f723eULL, 0x000fe200000010ffULL,
0x0000002003187824ULL, 0x000fe200078e0200ULL, 0x000000042d04723eULL, 0x000fc400000010ffULL,
0x000000052a05723eULL, 0x000fe400000010ffULL, 0x000000242307723eULL, 0x000fe400000010ffULL,
0x000000090a09723eULL, 0x000fe400000010ffULL, 0x0000001611027c11ULL, 0x000fe4000f8e20ffULL,
0x0000001b1a0a723eULL, 0x000fe400000010ffULL, 0x000000152c14723eULL, 0x000fe200000010ffULL,
0x0000000402007844ULL, 0x000fe20000000200ULL, 0x000000251017723eULL, 0x000fc400000010ffULL,
0x0000001612037c11ULL, 0x000fe4000f8e20ffULL, 0x000000330e15723eULL, 0x000fe200000010ffULL,
0x000000ff00127306ULL, 0x000e620000202400ULL, 0x000000280d16723eULL, 0x000fe200000010ffULL,
0x0000000803007844ULL, 0x000fe20000000200ULL, 0x0000001613107c11ULL, 0x000fe4000f8e20ffULL,
0x000000221f0c723eULL, 0x000fe400000010ffULL, 0x000000302f0d723eULL, 0x000fe200000010ffULL,
0x0000001410007844ULL, 0x000fe20000000200ULL, 0x0000001c190e723eULL, 0x000fc400000010ffULL,
0x000000161d117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000418137c11ULL, 0x000fc6000f8e20ffULL,
0x0000000c11007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000013187984ULL, 0x000e680000000c00ULL, 0x0004000013207984ULL, 0x000ea80000000c00ULL,
0x00080000131c7984ULL, 0x000ee80000000c00ULL, 0x000c000013247984ULL, 0x000f220000000c00ULL,
0x0000001b121b7230ULL, 0x002fc40000200800ULL, 0x0000001a121a7230ULL, 0x040fe40000200800ULL,
0x0000001912197230ULL, 0x040fe40000200800ULL, 0x0000001812187230ULL, 0x040fe40000200800ULL,
0x0000002312237230ULL, 0x044fe40000200800ULL, 0x0000002212227230ULL, 0x040fe40000200800ULL,
0x0000002112217230ULL, 0x000fc40000200800ULL, 0x0000002012207230ULL, 0x000fe40000200800ULL,
0x0000001f1b1b7230ULL, 0x008fe40000200000ULL, 0x0000001e1a1a7230ULL, 0x000fe40000200000ULL,
0x0000001d19197230ULL, 0x000fe40000200000ULL, 0x0000001c18187230ULL, 0x000fe40000200000ULL,
0x0000002723237230ULL, 0x010fc40000200000ULL, 0x0000002622227230ULL, 0x000fe20000200000ULL,
0x0000001813007388ULL, 0x0003e20000000c00ULL, 0x0000002521217230ULL, 0x000fe40000200000ULL,
0x0000002420207230ULL, 0x000fca0000200000ULL, 0x0004002013007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000005ff007c0cULL, 0x000fda000bf05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000177919ULL, 0x002e620000002600ULL,
0x00000003ff037819ULL, 0x000fe20000011600ULL, 0x00000014ff187e24ULL, 0x000fe2000f8e00ffULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x00000020001d7836ULL, 0x000fe20000000000ULL,
0x0000840000067ab9ULL, 0x000fe20000000800ULL, 0x00000008181b7824ULL, 0x000fe200078e00ffULL,
0x0000000406067899ULL, 0x000fe2000800063fULL, 0x00000040001f7836ULL, 0x040fe40000000000ULL,
0x0000006000217836ULL, 0x000fe20000000000ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL,
0x0000000818167824ULL, 0x040fe200078e00ffULL, 0x00000003ff147819ULL, 0x000fe2000001161fULL,
0x00000008181a7824ULL, 0x040fe200078e00ffULL, 0x00000003ff157819ULL, 0x000fe20000011621ULL,
0x00000008181e7824ULL, 0x000fe200078e00ffULL, 0x0000000714057812ULL, 0x000fc400078e481fULL,
0x0000000715067812ULL, 0x000fe400078e4821ULL, 0x0ffffff805057812ULL, 0x000fe400078ef81fULL,
0x0ffffff806067812ULL, 0x000fe400078ef821ULL, 0x00000004050c7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000406107c11ULL, 0x000fe2000f8e20ffULL, 0x00000005060572a4ULL, 0x004fe2000f8e023fULL,
0xfffffff81a1f7812ULL, 0x000fc400078ee21fULL, 0x000000000c0c7984ULL, 0x000fe20000000c00ULL,
0x0000001017027824ULL, 0x042fe200078e00ffULL, 0x0000860000067ab9ULL, 0x000fe20000000a00ULL,
0x0000001017197824ULL, 0x040fe200078e00ffULL, 0x0000000010107984ULL, 0x000fe20000000c00ULL,
0x00000010171c7824ULL, 0x000fe200078e00ffULL, 0xfffffff002027812ULL, 0x000fe400078ee203ULL,
0x0000000703037812ULL, 0x000fe400078e4800ULL, 0xfffffff019147812ULL, 0x000fc400078ee214ULL,
0x0ffffff803037812ULL, 0x000fe400078ef800ULL, 0x00000003ff007819ULL, 0x000fe4000001161dULL,
0x0000000403037c11ULL, 0x000fe4000f8e20ffULL, 0x0000000700047812ULL, 0x000fe400078e481dULL,
0xfffffff019007812ULL, 0x000fe400078ee200ULL, 0x0ffffff804047812ULL, 0x000fc400078ef81dULL,
0xfffffff8161d7812ULL, 0x000fe400078ee21dULL, 0x0000000404087c11ULL, 0x000fe4000f8e20ffULL,
0x0000000003047984ULL, 0x0002a20000000c00ULL, 0x0000000502167c10ULL, 0x000fe4000ff1e0ffULL,
0xfffffff01c157812ULL, 0x000fe200078ee215ULL, 0x0000000008087984ULL, 0x000ee20000000c00ULL,
0x0000000514177c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff81e217812ULL, 0x000fe200078ee221ULL,
0x000000ffff037224ULL, 0x002fe200000e06ffULL, 0x0000000616027c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff1a7224ULL, 0x000fc600008e06ffULL, 0x0000000716037c11ULL, 0x000fe400080f4403ULL,
0x00000005001c7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000515007c10ULL, 0x000fe2000ff5e0ffULL,
0x000000101b027825ULL, 0x000fe200078e0002ULL, 0x0000000617167c11ULL, 0x000fc6000f8240ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x000000061c147c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x0000000600187c11ULL, 0x000fe4000f8440ffULL,
0x000000071c157c11ULL, 0x000fe400080f4415ULL, 0x0000000717177c11ULL, 0x000fe400088f441aULL,
0x0000000700197c11ULL, 0x000fe200090f4419ULL, 0x000000101d147825ULL, 0x000fc800078e0014ULL,
0x000000101f167825ULL, 0x000fc800078e0016ULL, 0x0000001021187825ULL, 0x000fe200078e0018ULL,
0x0000000402007986ULL, 0x004fe8000c101d0eULL, 0x0000000814007986ULL, 0x008fe8000c101d0eULL,
0x0000000c16007986ULL, 0x000fe8000c101d0eULL, 0x0000001018007986ULL, 0x000fe2000c101d0eULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00009200ff027b82ULL, 0x008ea20000000a00ULL,
0x0000000161057836ULL, 0x000fe20000000000ULL, 0x0000000612067899ULL, 0x002fe2000800063fULL,
0x000000025d5d7824ULL, 0x000fe200078e00ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x0000000e02037981ULL, 0x004362000c1e9900ULL, 0x0000005e0500720cULL, 0x000fe20003f06070ULL,
0x000000075d007e24ULL, 0x010fe2000f8e020eULL, 0x0000000661077c11ULL, 0x000fca000f8e40ffULL,
0x0000000400067c24ULL, 0x000fcc000f8e0207ULL, 0x0000000800fc8947ULL, 0x002fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x00008a00ff047b82ULL, 0x000ea20000000a00ULL,
0x000000075f0c7248ULL, 0x000fe20007fe0000ULL, 0x0000040000047882ULL, 0x000fc80000000000ULL,
0x000000010c0c7824ULL, 0x000fe400078e0a07ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x00000003ff297819ULL, 0x002fe20000011602ULL, 0x0000001002077824ULL, 0x040fe200078e00ffULL,
0x0ffffff8020e7812ULL, 0x000fe200078ec0ffULL, 0x0000065405057896ULL, 0x008fe20008000004ULL,
0x00000002290d7212ULL, 0x0c0fe200078e3cffULL, 0x0000000129097824ULL, 0x000fe200078e0206ULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x0000000829117836ULL, 0x040fe20000000000ULL,
0x000000070e137812ULL, 0x000fe200078ef80dULL, 0x00000004290f7836ULL, 0x000fe20000000000ULL,
0x0000000512047291ULL, 0x000fe2000f8e703fULL, 0x0000008009087825ULL, 0x004fe200078e0004ULL,
0x00000002110b7212ULL, 0x000fc400078e3cffULL, 0x000000020f0a7212ULL, 0x000fe200078e3cffULL,
0x00000008111e7824ULL, 0x000fe200078e00ffULL, 0x0000000708147210ULL, 0x000fe20007f1e0ffULL,
0x000000080f157824ULL, 0x040fe200078e00ffULL, 0x0000000c0f00720cULL, 0x080fe20003f86070ULL,
0x00000001110d7824ULL, 0x100fe200078e0206ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee20bULL,
0x000000010f0b7824ULL, 0x000fe200078e0206ULL, 0xfffffff815127812ULL, 0x000fe200078ee20aULL,
0x000000ffff157224ULL, 0x000fe200000e0609ULL, 0x0000000c1100720cULL, 0x080fe20003f06070ULL,
0x000000800b087825ULL, 0x000fe200078e0004ULL, 0x0000000c2900720cULL, 0x000fe20003fa6070ULL,
0x0000100004047890ULL, 0x000fc4000fffe03fULL, 0x0000000c291d7836ULL, 0x040fe20000000000ULL,
0x0000000708167210ULL, 0x000fe20007f3e0ffULL, 0x00000010291f7836ULL, 0x040fe40000000000ULL,
0x0000001429217836ULL, 0x000fe40000000000ULL, 0x000000800d0a7825ULL, 0x000fc800078e0004ULL,
0x000000011d0d7824ULL, 0x100fe200078e0206ULL, 0x000000070a187210ULL, 0x000fe20007f5e0ffULL,
0x000000011f0f7824ULL, 0x100fe400078e0206ULL, 0x0000000121117824ULL, 0x000fe400078e0206ULL,
0x000000ffff177224ULL, 0x000fe400008e0609ULL, 0x000000800d087825ULL, 0x000fe200078e0004ULL,
0x000000021d0d7212ULL, 0x000fc600078e3cffULL, 0x000000800f0e7825ULL, 0x000fe200078e0004ULL,
0x00000007081a7210ULL, 0x000fc60007f3e0ffULL, 0x0000008011107825ULL, 0x000fc800078e0004ULL,
0x000000ffff197224ULL, 0x000fe200010e060bULL, 0x000000070e0a7210ULL, 0x000fe20007f5e0ffULL,
0x0000001829277836ULL, 0x000fe20000000000ULL, 0x0000000710087210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e0609ULL, 0x0000000c1d00720cULL, 0x080fe20003f26070ULL,
0x000000ffff0b7224ULL, 0x000fe200010e060fULL, 0x0000000c1f00720cULL, 0x000fe20003f46070ULL,
0x000000ffff097224ULL, 0x000fe200018e0611ULL, 0x0000000221117212ULL, 0x080fe200078e3cffULL,
0x00000001270f7824ULL, 0x000fe200078e0206ULL, 0x000000021f107212ULL, 0x000fe200078e3cffULL,
0x0000000821227824ULL, 0x040fe200078e00ffULL, 0x0000000c2100720cULL, 0x000fe20003f66070ULL,
0x000000081d207824ULL, 0x000fe200078e00ffULL, 0x0000000227237212ULL, 0x000fe200078e3cffULL,
0x0000001c291d7836ULL, 0x000fe20000000000ULL, 0xfffffff822227812ULL, 0x000fe200078ee211ULL,
0x000000800f0e7825ULL, 0x000fe200078e0004ULL, 0xfffffff820207812ULL, 0x000fc400078ee20dULL,
0x00000004130d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0x000000070e0e7210ULL, 0x000fe20007fde0ffULL, 0x000000011d117824ULL, 0x000fe400078e0206ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e2000e901c4eULL,
0xfffffff81f217812ULL, 0x000fe200078ee210ULL, 0x0000008011107825ULL, 0x000fe200078e0004ULL,
0x00000004121f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000421217c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff0f7224ULL, 0x000fe200030e060fULL, 0x00000007101c7210ULL, 0x000fe20007fde0ffULL,
0x0000002029257836ULL, 0x000fe20000000000ULL, 0x000000021d107212ULL, 0x040fe200078e3cffULL,
0x00000000161f7faeULL, 0x0005e2000e101c4eULL, 0x0000000c1d00720cULL, 0x0c0fe20003f86070ULL,
0x000000081d0d7824ULL, 0x002fe200078e00ffULL, 0x0000000420157c11ULL, 0x000fe2000f8e20ffULL,
0x0000000106137824ULL, 0x000fe200078e0225ULL, 0x0000000c2700720cULL, 0x000fe20003fa6070ULL,
0x000000ffff1d7224ULL, 0x000fe200030e0611ULL, 0xfffffff80d147812ULL, 0x000fe200078ee210ULL,
0x0000008013127825ULL, 0x000fe200078e0004ULL, 0x000000041e0d7c11ULL, 0x000fc6000f8e20ffULL,
0x0000002429177836ULL, 0x004fe20000000000ULL, 0x0000000712127210ULL, 0x000fe20007fde0ffULL,
0x00000000180d7faeULL, 0x0003e2000c101c4eULL, 0x0000000827247824ULL, 0x000fe200078e00ffULL,
0x0000000c2500720cULL, 0x040fe20003f06070ULL, 0x0000000106117824ULL, 0x000fe200078e0217ULL,
0x000000001a157faeULL, 0x0005e2000c901c4eULL, 0x0000000225167212ULL, 0x040fe200078e3cffULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0x0000000c1700720cULL, 0x000fe20003f26070ULL,
0x0000008011107825ULL, 0x000fe200078e0004ULL, 0x00000002171e7212ULL, 0x040fe200078e3cffULL,
0x000000000a217faeULL, 0x0007e2000d101c4eULL, 0xfffffff824237812ULL, 0x000fe200078ee223ULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0x00000004220d7c11ULL, 0x002fe2000f8e20ffULL,
0x000000ffff137224ULL, 0x000fe200030e0613ULL, 0x0000000710107210ULL, 0x000fe20007fde0ffULL,
0x00000028291b7836ULL, 0x044fe20000000000ULL, 0xfffffff825167812ULL, 0x000fe200078ee216ULL,
0x00000000080d7faeULL, 0x0003e2000d901c4eULL, 0xfffffff8171e7812ULL, 0x000fe200078ee21eULL,
0x0000002c291f7836ULL, 0x000fe20000000000ULL, 0x0000000423237c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x0000000414157c11ULL, 0x000fe2000f8e20ffULL,
0x00000001060b7824ULL, 0x008fe200078e021fULL, 0x0000000416177c11ULL, 0x000fe2000f8e20ffULL,
0x000000000e237faeULL, 0x0005e2000e901c4eULL, 0x000000041e197c11ULL, 0x000fe2000f8e20ffULL,
0x0000003029217836ULL, 0x000fe20000000000ULL, 0x0000000c1b00720cULL, 0x080fe20003fa6070ULL,
0x0000000106097824ULL, 0x002fe200078e021bULL, 0x000000001c157faeULL, 0x000fe2000e101c4eULL,
0x0000003429257836ULL, 0x000fe20000000000ULL, 0x0000000c1f00720cULL, 0x080fe20003f86070ULL,
0x0000008009087825ULL, 0x000fe200078e0004ULL, 0x0000000012177faeULL, 0x0003e2000c101c4eULL,
0x0000000c2100720cULL, 0x000fc40003f66070ULL, 0x0000003829277836ULL, 0x040fe20000000000ULL,
0x00000007080e7210ULL, 0x004fe20007fde0ffULL, 0x0000003c29237836ULL, 0x000fe20000000000ULL,
0x0000000010197faeULL, 0x0005e2000c901c4eULL, 0x000000800b0a7825ULL, 0x000fe200078e0004ULL,
0x0000000c2500720cULL, 0x080fe40003f46070ULL, 0x0000000c2700720cULL, 0x080fe20003f26070ULL,
0x000000ffff0f7224ULL, 0x000fe200030e0609ULL, 0x0000000c2300720cULL, 0x000fe20003f06070ULL,
0x000000081b127824ULL, 0x042fe200078e00ffULL, 0x000000021b0d7212ULL, 0x080fe200078e3cffULL,
0x000000081f137824ULL, 0x040fe200078e00ffULL, 0x000000070a0c7210ULL, 0x000fe20007fde0ffULL,
0x0000000106157824ULL, 0x040fe200078e0227ULL, 0x000000021f0a7212ULL, 0x080fe200078e3cffULL,
0x0000000106117824ULL, 0x004fe200078e0221ULL, 0xfffffff812127812ULL, 0x000fe200078ee20dULL,
0x000000ffff0d7224ULL, 0x000fe200030e060bULL, 0xfffffff813137812ULL, 0x000fe200078ee20aULL,
0x0000008011087825ULL, 0x000fe200078e0004ULL, 0x0000000221147212ULL, 0x000fc400078e3cffULL,
0x0000000413137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000106117824ULL, 0x000fe200078e0225ULL,
0x0000000708107210ULL, 0x000fe20007fde0ffULL, 0x0000000825167824ULL, 0x000fe400078e00ffULL,
0x00000080110a7825ULL, 0x000fc800078e0004ULL, 0x000000ffff117224ULL, 0x000fe200030e0609ULL,
0x000000070a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000008015087825ULL, 0x000fe200078e0004ULL,
0x0000000225157212ULL, 0x000fc600078e3cffULL, 0x0000000106177824ULL, 0x000fe200078e0223ULL,
0xfffffff816067812ULL, 0x000fe200078ee215ULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x0000000708087210ULL, 0x000fe20007fde0ffULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0x0000000227157212ULL, 0x080fe200078e3cffULL, 0x0000008017047825ULL, 0x000fe200078e0004ULL,
0x0000000223177212ULL, 0x000fe400078e3cffULL, 0xfffffff821147812ULL, 0x000fe200078ee214ULL,
0x0000000827167824ULL, 0x000fc400078e00ffULL, 0x0000000823187824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x0000000704047210ULL, 0x000fe40007fde0ffULL,
0xfffffff816167812ULL, 0x000fe400078ee215ULL, 0x0000000412077c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0xfffffff818127812ULL, 0x000fe400078ee217ULL,
0x0000000414157c11ULL, 0x000fe2000f8e20ffULL, 0x000000000e077faeULL, 0x0003e2000e901c4eULL,
0x0000000406177c11ULL, 0x000fc4000f8e20ffULL, 0x0000000416197c11ULL, 0x000fe2000f8e20ffULL,
0x000000000c137faeULL, 0x0003e2000e101c4eULL, 0x00000004121b7c11ULL, 0x000fc6000f8e20ffULL,
0x0000000010157faeULL, 0x0003e8000d901c4eULL, 0x000000000a177faeULL, 0x0003e8000d101c4eULL,
0x0000000008197faeULL, 0x0003e8000c901c4eULL, 0x00000000041b7faeULL, 0x0003e2000c101c4eULL,
0x0000000800b07947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x00000000000479c3ULL, 0x000ea20000008800ULL, 0x0000040000057882ULL, 0x000fe40000000000ULL,
0x0000065404057896ULL, 0x004fc80008000005ULL, 0x0000000512047291ULL, 0x000fe2000f8e703fULL,
0x00000003ff057819ULL, 0x002fe20000011602ULL, 0x0000001002187824ULL, 0x040fe200078e00ffULL,
0x0ffffff802047812ULL, 0x000fe200078ec0ffULL, 0x0000100004047890ULL, 0x000fe2000fffe03fULL,
0x00000002050b7212ULL, 0x0c0fe200078e3cffULL, 0x0000000405197836ULL, 0x040fe40000000000ULL,
0x00000010051f7836ULL, 0x000fe20000000000ULL, 0x00000007040b7812ULL, 0x000fe200078ef80bULL,
0x0000000819077824ULL, 0x040fe200078e00ffULL, 0x0000000219167212ULL, 0x080fe200078e3cffULL,
0x0000001405217836ULL, 0x000fe20000000000ULL, 0x000000021f137212ULL, 0x080fe200078e3cffULL,
0x0000000c051d7836ULL, 0x000fe20000000000ULL, 0xfffffff807167812ULL, 0x000fe200078ee216ULL,
0x000000081f087824ULL, 0x000fe200078e00ffULL, 0x0000000221127212ULL, 0x0c0fe200078e3cffULL,
0x0000000821097824ULL, 0x000fe200078e00ffULL, 0x000000021d147212ULL, 0x0c0fe200078e3cffULL,
0x000000081d077824ULL, 0x000fe200078e00ffULL, 0xfffffff808137812ULL, 0x000fe200078ee213ULL,
0x0000002005277836ULL, 0x040fe20000000000ULL, 0xfffffff809127812ULL, 0x000fe200078ee212ULL,
0x0000002405297836ULL, 0x040fe20000000000ULL, 0xfffffff807147812ULL, 0x000fe200078ee214ULL,
0x0000001c05257836ULL, 0x000fe20000000000ULL, 0x00000002270f7212ULL, 0x0c0fe200078e3cffULL,
0x0000000827087824ULL, 0x000fe200078e00ffULL, 0x00000002290e7212ULL, 0x0c0fe200078e3cffULL,
0x0000000829097824ULL, 0x000fe200078e00ffULL, 0x0000000225107212ULL, 0x0c0fe200078e3cffULL,
0x0000000825077824ULL, 0x000fe200078e00ffULL, 0xfffffff8080f7812ULL, 0x000fe200078ee20fULL,
0x0000002c052d7836ULL, 0x040fe20000000000ULL, 0xfffffff8090e7812ULL, 0x000fe200078ee20eULL,
0x00000030052f7836ULL, 0x000fe20000000000ULL, 0xfffffff807107812ULL, 0x000fe200078ee210ULL,
0x000000082d097824ULL, 0x040fe200078e00ffULL, 0x000000022d0c7212ULL, 0x080fe200078e3cffULL,
0x000000082f087824ULL, 0x040fe200078e00ffULL, 0x000000022f077212ULL, 0x080fe200078e3cffULL,
0x00000008051b7836ULL, 0x040fe20000000000ULL, 0xfffffff8090c7812ULL, 0x000fe200078ee20cULL,
0x0000003405317836ULL, 0x000fe20000000000ULL, 0xfffffff808077812ULL, 0x000fe200078ee207ULL,
0x000000081b047824ULL, 0x040fe200078e00ffULL, 0x00008a00ff087b82ULL, 0x000e620000000a00ULL,
0x000000021b157212ULL, 0x080fe200078e3cffULL, 0x0000001805237836ULL, 0x000fe20000000000ULL,
0x00000002310a7212ULL, 0x0c0fe200078e3cffULL, 0x0000000831177824ULL, 0x000fe200078e00ffULL,
0xfffffff804157812ULL, 0x000fe200078ee215ULL, 0x0000000823047824ULL, 0x040fe200078e00ffULL,
0x0000000223117212ULL, 0x080fe200078e3cffULL, 0x00000028052b7836ULL, 0x040fe20000000000ULL,
0xfffffff8170a7812ULL, 0x000fe200078ee20aULL, 0x0000000105177824ULL, 0x140fe200078e0206ULL,
0xfffffff804117812ULL, 0x000fe200078ee211ULL, 0x0000003805337836ULL, 0x000fe20000000000ULL,
0x000000022b0d7212ULL, 0x0c0fe200078e3cffULL, 0x000000082b047824ULL, 0x000fe200078e00ffULL,
0x000000040b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000003c05057836ULL, 0x000fe20000000000ULL,
0x0000000415157c11ULL, 0x000fe2000f8e20ffULL, 0x0000000119197824ULL, 0x100fe200078e0206ULL,
0xfffffff8040d7812ULL, 0x000fe200078ee20dULL, 0x000000011b1b7824ULL, 0x100fe200078e0206ULL,
0x00000002051a7212ULL, 0x000fe200078e3cffULL, 0x000000011d1d7824ULL, 0x100fe200078e0206ULL,
0x0000000413137c11ULL, 0x000fe2000f8e20ffULL, 0x000000011f1f7824ULL, 0x100fe200078e0206ULL,
0x0000000411117c11ULL, 0x000fe2000f8e20ffULL, 0x0000000121217824ULL, 0x100fe200078e0206ULL,
0x000000040f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000123237824ULL, 0x100fe200078e0206ULL,
0x000000040d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000125257824ULL, 0x000fe200078e0206ULL,
0x0000000407077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000106277824ULL, 0x000fc400078e0227ULL,
0x0000000106297824ULL, 0x040fe400078e0229ULL, 0x00000001062b7824ULL, 0x040fe400078e022bULL,
0x00000001062d7824ULL, 0x040fe400078e022dULL, 0x00000001062f7824ULL, 0x040fe400078e022fULL,
0x0000000106317824ULL, 0x040fe400078e0231ULL, 0x0000000106357824ULL, 0x000fc400078e0233ULL,
0x0000000106377824ULL, 0x000fe200078e0205ULL, 0x0000000233067212ULL, 0x000fe200078e3cffULL,
0x0000000805397824ULL, 0x000fe400078e00ffULL, 0x0000008017047825ULL, 0x102fe200078e0008ULL,
0x0000007018177812ULL, 0x000fe400078ec0ffULL, 0xfffffff839367812ULL, 0x000fe200078ee21aULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x0000001704047210ULL, 0x000fe20007f1e0ffULL,
0x0000008019187825ULL, 0x000fc600078e0008ULL, 0xfffffff833067812ULL, 0x000fe200078ee206ULL,
0x000000801b1a7825ULL, 0x000fc800078e0008ULL, 0x000000801d1c7825ULL, 0x000fc800078e0008ULL,
0x0000008035327825ULL, 0x000fc800078e0008ULL, 0x000000801f1e7825ULL, 0x000fc800078e0008ULL,
0x0000008021207825ULL, 0x000fc800078e0008ULL, 0x0000008023227825ULL, 0x000fc800078e0008ULL,
0x0000008025247825ULL, 0x000fc800078e0008ULL, 0x0000008027267825ULL, 0x000fc800078e0008ULL,
0x0000008029287825ULL, 0x000fc800078e0008ULL, 0x000000802b2a7825ULL, 0x000fc800078e0008ULL,
0x000000802d2c7825ULL, 0x000fc800078e0008ULL, 0x000000802f2e7825ULL, 0x000fc800078e0008ULL,
0x0000008031307825ULL, 0x000fc800078e0008ULL, 0x0000008037347825ULL, 0x000fe200078e0008ULL,
0x0000001718087210ULL, 0x000fe40007f3e0ffULL, 0x000000171a187210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x000000171c1a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0619ULL, 0x000000171e1c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e061bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e2000b901c4eULL, 0x000000ffff1b7224ULL, 0x000fe200000e061dULL,
0x00000017201e7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e061fULL,
0x0000001722207210ULL, 0x000fc40007f5e0ffULL, 0x0000001724227210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e0621ULL, 0x0000001726247210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff217224ULL, 0x000fe200010e0623ULL, 0x0000000412377c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff237224ULL, 0x000fe200008e0625ULL, 0x0000001728267210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff257224ULL, 0x000fe200000e0627ULL, 0x000000172a287210ULL, 0x000fe40007f1e0ffULL,
0x0000000410057c11ULL, 0x002fe2000f8e20ffULL, 0x000000ffff277224ULL, 0x000fe200008e0629ULL,
0x000000172c2a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff297224ULL, 0x000fe200000e062bULL,
0x000000172e2c7210ULL, 0x000fc40007f1e0ffULL, 0x000000040c0b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2b7224ULL, 0x000fe200008e062dULL, 0x00000017302e7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e062fULL, 0x0000001732307210ULL, 0x000fe40007f1e0ffULL,
0x0000001734327210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200008e0631ULL,
0x0000000416177c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff317224ULL, 0x000fe400000e0633ULL,
0x000000ffff337224ULL, 0x000fe200010e0635ULL, 0x0000000414357c11ULL, 0x000fe2000f8e20ffULL,
0x0000000008177faeULL, 0x0003e8000b901c4eULL, 0x0000000018157faeULL, 0x000fe8000b901c4eULL,
0x000000001a357faeULL, 0x000fe8000b901c4eULL, 0x000000001c137faeULL, 0x0007e2000b901c4eULL,
0x000000040e097c11ULL, 0x002fc6000f8e20ffULL, 0x000000001e377faeULL, 0x000fe8000b901c4eULL,
0x0000000020117faeULL, 0x0003e8000b901c4eULL, 0x0000000022057faeULL, 0x0009e2000b901c4eULL,
0x0000000436137c11ULL, 0x008fc6000f8e20ffULL, 0x00000000240f7faeULL, 0x0005e2000b901c4eULL,
0x000000040a117c11ULL, 0x002fc6000f8e20ffULL, 0x0000000026097faeULL, 0x0005e2000b901c4eULL,
0x0000000406057c11ULL, 0x010fc6000f8e20ffULL, 0x00000000280d7faeULL, 0x0005e8000b901c4eULL,
0x000000002a0b7faeULL, 0x0005e8000b901c4eULL, 0x000000002c077faeULL, 0x0005e8000b901c4eULL,
0x000000002e117faeULL, 0x0005e8000b901c4eULL, 0x0000000030057faeULL, 0x0005e8000b901c4eULL,
0x0000000032137faeULL, 0x0005e4000b901c4eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01b600ffff0075a7ULL, 0x000ee20008000145ULL, 0x000000031200788cULL, 0x000fe2000bf04070ULL,
0x00000001ff157424ULL, 0x006fe400078e00ffULL, 0x80000000ff147424ULL, 0x000fc600078e00ffULL,
0x000000000000781cULL, 0x000fe20003f2f008ULL, 0x0000004000548947ULL, 0x008fd80003800000ULL,
0x0000000000641947ULL, 0x000fea0003800000ULL, 0x00000012ff057e24ULL, 0x000fc8000f8e00ffULL,
0x0000002005047824ULL, 0x000fc800078e0202ULL, 0x0000001004067824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fc80000011604ULL, 0x1ffffffe05057812ULL, 0x000fe400078ec0ffULL,
0x000000f006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105077812ULL, 0x000fe400078efcffULL,
0x0000000705057812ULL, 0x000fe400078e7804ULL, 0x0000000707077812ULL, 0x000fc600078e7804ULL,
0x0000000105057824ULL, 0x000fe400078e0206ULL, 0x0000000106077824ULL, 0x000fc600078e0207ULL,
0x0000000505057c11ULL, 0x000fe4000f8e20ffULL, 0x0000000507077c11ULL, 0x000fc6000f8e20ffULL,
0x00000000050c7984ULL, 0x000e680000000c00ULL, 0x0000000007087984ULL, 0x000ea20000000c00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fc400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001005007388ULL, 0x0003e80000000c00ULL, 0x0000000c07007388ULL, 0x0003e40000000c00ULL,
0x01b60015ffff79a7ULL, 0x0005e20008500005ULL, 0x0000005e6100720cULL, 0x000fe20003f26070ULL,
0x01b60014ff0075a7ULL, 0x000ee40008000145ULL, 0x0000003c00f88947ULL, 0x00cff40003800000ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x3db504f303037820ULL, 0x020fe20000410000ULL,
0xffffffff5e047836ULL, 0x000fe20000000000ULL, 0x00007610ff057816ULL, 0x002fe20000000005ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x0000000512077291ULL, 0x000fd8000f8e203fULL,
0x0000000661067c11ULL, 0x000fc8000f8e40ffULL, 0x000000065f00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000001361077c36ULL, 0x000fe20008000000ULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x000000010a087812ULL, 0x000fe400078e0cffULL,
0x0000000107097836ULL, 0x040fe20000000000ULL, 0x00000006070b7c11ULL, 0x000fc8000f8e40ffULL,
0x0000005e0900720cULL, 0x000fe20003f06070ULL, 0x0000000400107c24ULL, 0x000fd8000f8e020bULL,
0x0000000800f48947ULL, 0x000fea0003800000ULL, 0x00008a00ff0c7b82ULL, 0x000e620000000a00ULL,
0x00000003ff097819ULL, 0x000fe20000011602ULL, 0x00000010020e7824ULL, 0x000fe200078e00ffULL,
0x0000000b5f1e7248ULL, 0x000fe20007fe0000ULL, 0x0000000512047291ULL, 0x000fe4000f8e703fULL,
0x0000000109137824ULL, 0x040fe200078e0210ULL, 0x000000700e0e7812ULL, 0x000fe200078ec0ffULL,
0x0000001009217836ULL, 0x040fe40000000000ULL, 0x00000004090f7836ULL, 0x000fc40000000000ULL,
0x0000000821197824ULL, 0x040fe200078e00ffULL, 0x0000000221147212ULL, 0x080fe200078e3cffULL,
0x000000011e1e7824ULL, 0x000fe200078e0a0bULL, 0x000000020f117212ULL, 0x000fe200078e3cffULL,
0x0000000809157836ULL, 0x040fe20000000000ULL, 0xfffffff8192a7812ULL, 0x000fe200078ee214ULL,
0x00000014091f7836ULL, 0x000fe20000000000ULL, 0x0000001e0f00720cULL, 0x000fe20003f86070ULL,
0x0000000815267824ULL, 0x040fe200078e00ffULL, 0x00000002150b7212ULL, 0x000fe200078e3cffULL,
0x000000080f227824ULL, 0x000fe200078e00ffULL, 0x0000001e1500720cULL, 0x000fe20003f46070ULL,
0x0000008013127825ULL, 0x002fe200078e000cULL, 0xfffffff826267812ULL, 0x000fc400078ee20bULL,
0xfffffff822227812ULL, 0x000fe200078ee211ULL, 0x0000000115157824ULL, 0x100fe200078e0210ULL,
0x0000000e12187210ULL, 0x000fe20007f1e0ffULL, 0x000000011f0b7824ULL, 0x000fe400078e0210ULL,
0x0000008015147825ULL, 0x000fc800078e000cULL, 0x000000ffff197224ULL, 0x000fe200000e0613ULL,
0x0000000e141a7210ULL, 0x000fe20007fbe0ffULL, 0x000000010f137824ULL, 0x000fe200078e0210ULL,
0x0000001e2100720cULL, 0x000fe20003f06070ULL, 0x0000000c09177836ULL, 0x040fe20000000000ULL,
0x00000002090f7212ULL, 0x000fe200078e3cffULL, 0x0000008013127825ULL, 0x000fc600078e000cULL,
0x0000000217117212ULL, 0x040fe200078e3cffULL, 0x0000000817287824ULL, 0x000fe200078e00ffULL,
0x0000000e12247210ULL, 0x000fe20007f3e0ffULL, 0x0000000121217824ULL, 0x000fe200078e0210ULL,
0x0000001e1700720cULL, 0x000fe20003f66070ULL, 0x000000ffff1b7224ULL, 0x000fe200028e0615ULL,
0xfffffff828287812ULL, 0x000fe200078ee211ULL, 0x000000ffff257224ULL, 0x000fe200008e0613ULL,
0x000000070f117812ULL, 0x000fe200078ec0ffULL, 0x000000800b127825ULL, 0x000fc800078e000cULL,
0x00000004ff0b7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000e12127210ULL, 0x000fe20007fbe0ffULL,
0x0000008021207825ULL, 0x000fc800078e000cULL, 0x0000000117177824ULL, 0x000fe200078e0210ULL,
0x0000000e20147210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200028e0613ULL,
0x0000001e0900720cULL, 0x000fe20003fa6070ULL, 0x00002000080f7824ULL, 0x000fe200078e020bULL,
0x0ffffff811207812ULL, 0x000fe200078ef802ULL, 0x0000008017167825ULL, 0x000fc800078e000cULL,
0x000010000f0f7836ULL, 0x000fe20000000000ULL, 0x0000000e161c7210ULL, 0x000fe20007fde0ffULL,
0x0000001809277836ULL, 0x000fe40000000000ULL, 0x0000001020117824ULL, 0x000fe400078e020fULL,
0x000000ffff157224ULL, 0x000fe200008e0621ULL, 0x0000001e1f00720cULL, 0x000fe20003f26070ULL,
0x0000001c092b7836ULL, 0x000fe20000000000ULL, 0x000000021f217212ULL, 0x040fe200078e3cffULL,
0x000000081f2c7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018117faeULL, 0x0003e2000e901c4eULL, 0x000000ffff1d7224ULL, 0x000fe200030e0617ULL,
0x0000001e2700720cULL, 0x040fe20003fa6070ULL, 0x00000010221f7824ULL, 0x000fe200078e020fULL,
0x0000000227297212ULL, 0x0c0fe200078e3cffULL, 0x0000000127177824ULL, 0x040fe200078e0210ULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee221ULL, 0x00000008272e7824ULL, 0x000fe200078e00ffULL,
0x000000022b277212ULL, 0x000fe200078e3cffULL, 0x0000008017167825ULL, 0x000fe200078e000cULL,
0x00000000241f7faeULL, 0x0005e2000e101c4eULL, 0x0000001e2b00720cULL, 0x000fc40003f86070ULL,
0x000000082b187824ULL, 0x042fe200078e00ffULL, 0x0000000e16167210ULL, 0x000fe20007fde0ffULL,
0x000000012b217824ULL, 0x000fe400078e0210ULL, 0x0000001026117824ULL, 0x000fe400078e020fULL,
0x00000020092d7836ULL, 0x000fe40000000000ULL, 0x0000008021207825ULL, 0x000fe200078e000cULL,
0xfffffff82e247812ULL, 0x004fe200078ee229ULL, 0x000000001a117faeULL, 0x0003e2000d101c4eULL,
0xfffffff8182e7812ULL, 0x000fe200078ee227ULL, 0x0000002409277836ULL, 0x000fe20000000000ULL,
0x000000022d257212ULL, 0x040fe200078e3cffULL, 0x000000012d237824ULL, 0x000fc400078e0210ULL,
0x0000000127197824ULL, 0x040fe200078e0210ULL, 0x0000001e2700720cULL, 0x040fe20003f46070ULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0000000227267212ULL, 0x040fe200078e3cffULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0x0000000e20207210ULL, 0x000fe20007fde0ffULL,
0x00000010281f7824ULL, 0x000fe400078e020fULL, 0x0000008023227825ULL, 0x000fe200078e000cULL,
0xfffffff827267812ULL, 0x000fe400078ee226ULL, 0x000000001c1f7faeULL, 0x0005e2000d901c4eULL,
0x000000102a117824ULL, 0x102fe200078e020fULL, 0x0000001e2d00720cULL, 0x000fe20003f66070ULL,
0x000000102c1b7824ULL, 0x000fc400078e020fULL, 0x0000002809277836ULL, 0x000fe20000000000ULL,
0x0000000014117faeULL, 0x000fe2000c101c4eULL, 0x000000ffff217224ULL, 0x000fe200030e0621ULL,
0x0000000e22227210ULL, 0x000fe20007fde0ffULL, 0x000000082d287824ULL, 0x000fe200078e00ffULL,
0x00000000121b7faeULL, 0x0003e2000c901c4eULL, 0x0000008019187825ULL, 0x000fc600078e000cULL,
0xfffffff8281a7812ULL, 0x000fe200078ee225ULL, 0x000000ffff237224ULL, 0x000fe200030e0623ULL,
0x0000000e18187210ULL, 0x000fe20007fde0ffULL, 0x00000010241d7824ULL, 0x104fe400078e020fULL,
0x000000102e1f7824ULL, 0x100fe400078e020fULL, 0x000000101a257824ULL, 0x000fe200078e020fULL,
0x0000000227127212ULL, 0x042fe200078e3cffULL, 0x0000000827137824ULL, 0x000fe200078e00ffULL,
0x00000000161d7faeULL, 0x0003e2000e901c4eULL, 0x0000002c09297836ULL, 0x000fc40000000000ULL,
0x00000030092b7836ULL, 0x000fe20000000000ULL, 0xfffffff8131c7812ULL, 0x000fe200078ee212ULL,
0x0000000127137824ULL, 0x000fe200078e0210ULL, 0x00000000201f7faeULL, 0x0005e2000e101c4eULL,
0x00000034092d7836ULL, 0x000fe20000000000ULL, 0x0000001e2900720cULL, 0x080fe20003fa6070ULL,
0x00000038092f7836ULL, 0x040fe20000000000ULL, 0x0000000022257faeULL, 0x000fe2000d901c4eULL,
0x0000003c09317836ULL, 0x000fe20000000000ULL, 0x0000001e2b00720cULL, 0x080fe20003f86070ULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x0000001e2700720cULL, 0x080fe20003fc6070ULL,
0x0000001026117824ULL, 0x000fe200078e020fULL, 0x0000001e2d00720cULL, 0x080fe20003f66070ULL,
0x0000008013127825ULL, 0x000fe200078e000cULL, 0x0000001e2f00720cULL, 0x000fc40003f26070ULL,
0x0000001e3100720cULL, 0x000fe20003f06070ULL, 0x0000000129157824ULL, 0x040fe200078e0210ULL,
0x0000000018117faeULL, 0x0007e2000d101c4eULL, 0x00000008291e7824ULL, 0x040fe200078e00ffULL,
0x0000000229177212ULL, 0x082fe200078e3cffULL, 0x0000008015147825ULL, 0x000fe200078e000cULL,
0x0000000e12167210ULL, 0x000fe40007f5e0ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee217ULL,
0x000000012b1b7824ULL, 0x040fe200078e0210ULL, 0x000000022b1a7212ULL, 0x080fe200078e3cffULL,
0x000000ffff177224ULL, 0x000fe200010e0613ULL, 0x000000022f1f7212ULL, 0x084fe200078e3cffULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0x0000000e14187210ULL, 0x008fe20007f5e0ffULL,
0x000000801b127825ULL, 0x000fe200078e000cULL, 0x000000022d147212ULL, 0x000fc400078e3cffULL,
0xfffffff82b207812ULL, 0x000fe200078ee21aULL, 0x000000082d1b7824ULL, 0x040fe400078e00ffULL,
0x000000012d117824ULL, 0x100fe400078e0210ULL, 0x000000ffff197224ULL, 0x000fe200010e0615ULL,
0x0000000e121a7210ULL, 0x000fe20007f5e0ffULL, 0x000000012f1d7824ULL, 0x000fe200078e0210ULL,
0xfffffff81b227812ULL, 0x000fe200078ee214ULL, 0x0000008011147825ULL, 0x000fc800078e000cULL,
0x000000ffff1b7224ULL, 0x000fe200010e0613ULL, 0x0000000e14147210ULL, 0x000fe20007f5e0ffULL,
0x000000801d127825ULL, 0x000fe200078e000cULL, 0x00000002311d7212ULL, 0x000fc600078e3cffULL,
0x0000000131117824ULL, 0x000fe400078e0210ULL, 0x000000082f247824ULL, 0x000fe400078e00ffULL,
0x000000ffff157224ULL, 0x000fe200010e0615ULL, 0x0000000e12107210ULL, 0x000fe20007f5e0ffULL,
0x0000000831267824ULL, 0x000fe200078e00ffULL, 0xfffffff824127812ULL, 0x000fe200078ee21fULL,
0x00000080110c7825ULL, 0x000fc600078e000cULL, 0xfffffff826247812ULL, 0x000fe200078ee21dULL,
0x000000ffff117224ULL, 0x000fe200010e0613ULL, 0x0000000e0c0e7210ULL, 0x000fe20007f5e0ffULL,
0x000000101c137824ULL, 0x100fe400078e020fULL, 0x000000101e1d7824ULL, 0x100fe400078e020fULL,
0x00000010201f7824ULL, 0x100fe200078e020fULL, 0x0000000016137faeULL, 0x0003e2000f101c4eULL,
0x0000001022217824ULL, 0x100fe400078e020fULL, 0x0000001012237824ULL, 0x100fe200078e020fULL,
0x00000000181d7faeULL, 0x0003e2000e901c4eULL, 0x0000001024257824ULL, 0x000fc400078e020fULL,
0x000000ffff0f7224ULL, 0x000fe200010e060dULL, 0x000000001a1f7faeULL, 0x0003e8000e101c4eULL,
0x0000000014217faeULL, 0x0003e8000d901c4eULL, 0x0000000010237faeULL, 0x0003e8000c901c4eULL,
0x000000000e257faeULL, 0x0003e2000c101c4eULL, 0x0000000800a87947ULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fe20000011602ULL, 0x0000000512047291ULL, 0x000fe2000f8e703fULL,
0x0000001002137824ULL, 0x000fe400078e00ffULL, 0x00000002090e7212ULL, 0x0c0fe200078e3cffULL,
0x0000000809157836ULL, 0x040fe40000000000ULL, 0x0000000c09177836ULL, 0x000fe20000000000ULL,
0x0000007013137812ULL, 0x000fe200078ec0ffULL, 0x00000008150f7824ULL, 0x040fe200078e00ffULL,
0x00000002150c7212ULL, 0x080fe200078e3cffULL, 0x0000001409217836ULL, 0x000fe20000000000ULL,
0x00000002170d7212ULL, 0x0c0fe200078e3cffULL, 0x0000000817167824ULL, 0x000fe200078e00ffULL,
0xfffffff80f147812ULL, 0x000fe200078ee20cULL, 0x0000001809237836ULL, 0x000fe20000000000ULL,
0x00000002210c7212ULL, 0x0c0fe200078e3cffULL, 0x00000008210f7824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee20dULL, 0x00000008231c7824ULL, 0x040fe200078e00ffULL,
0x00000002230d7212ULL, 0x080fe200078e3cffULL, 0x0000002009277836ULL, 0x040fe20000000000ULL,
0xfffffff80f1a7812ULL, 0x000fe200078ee20cULL, 0x0000002409297836ULL, 0x040fe20000000000ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20dULL, 0x0000000409117836ULL, 0x000fe20000000000ULL,
0x00000002270c7212ULL, 0x0c0fe200078e3cffULL, 0x00000008270f7824ULL, 0x000fe200078e00ffULL,
0x00000002290d7212ULL, 0x0c0fe200078e3cffULL, 0x0000000829227824ULL, 0x000fe200078e00ffULL,
0x00000002110b7212ULL, 0x0c0fe200078e3cffULL, 0x0000000811127824ULL, 0x000fe200078e00ffULL,
0xfffffff80f207812ULL, 0x000fe200078ee20cULL, 0x0000002c092d7836ULL, 0x040fe20000000000ULL,
0xfffffff822227812ULL, 0x000fe200078ee20dULL, 0x00000030092f7836ULL, 0x040fe20000000000ULL,
0xfffffff812127812ULL, 0x000fe200078ee20bULL, 0x00000010091f7836ULL, 0x000fe20000000000ULL,
0x000000022d0c7212ULL, 0x0c0fe200078e3cffULL, 0x000000082d0f7824ULL, 0x000fe200078e00ffULL,
0x000000022f0d7212ULL, 0x0c0fe200078e3cffULL, 0x000000082f287824ULL, 0x000fe200078e00ffULL,
0x000000021f0b7212ULL, 0x0c0fe200078e3cffULL, 0x000000081f187824ULL, 0x000fe200078e00ffULL,
0xfffffff80f267812ULL, 0x000fe200078ee20cULL, 0x0000003809337836ULL, 0x040fe20000000000ULL,
0xfffffff828287812ULL, 0x000fe200078ee20dULL, 0x0000003c09357836ULL, 0x040fe20000000000ULL,
0xfffffff818187812ULL, 0x000fe200078ee20bULL, 0x0000001c09257836ULL, 0x000fe20000000000ULL,
0x00000002330c7212ULL, 0x0c0fe200078e3cffULL, 0x00000008330f7824ULL, 0x000fe200078e00ffULL,
0x00000002350d7212ULL, 0x080fe200078e3cffULL, 0x00000008251e7824ULL, 0x040fe200078e00ffULL,
0x00000002250b7212ULL, 0x080fe200078e3cffULL, 0x00000008352e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f2c7812ULL, 0x000fe200078ee20cULL, 0x00000028092b7836ULL, 0x040fe20000000000ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20bULL, 0x0000003409317836ULL, 0x000fe20000000000ULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee20dULL, 0x000000082b247824ULL, 0x040fe200078e00ffULL,
0x000000022b0b7212ULL, 0x080fe200078e3cffULL, 0x00008a00ff0c7b82ULL, 0x000e620000000a00ULL,
0x00000008312a7824ULL, 0x000fe200078e00ffULL, 0x000000070e0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000111197824ULL, 0x100fe200078e0210ULL, 0xfffffff824247812ULL, 0x000fe200078ee20bULL,
0x00000001171d7824ULL, 0x100fe200078e0210ULL, 0x00000002310b7212ULL, 0x000fe200078e3cffULL,
0x00000001151b7824ULL, 0x100fe200078e0210ULL, 0x0ffffff80f0e7812ULL, 0x000fe200078ef802ULL,
0x000000011f1f7824ULL, 0x000fe200078e0210ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee20bULL,
0x00000004ff0b7e24ULL, 0x000fc4000f8e00ffULL, 0x0000000121217824ULL, 0x100fe400078e0210ULL,
0x0000200008117824ULL, 0x000fe400078e020bULL, 0x0000000123237824ULL, 0x100fe400078e0210ULL,
0x0000100011177836ULL, 0x000fe40000000000ULL, 0x0000000125257824ULL, 0x100fe400078e0210ULL,
0x0000000127277824ULL, 0x000fc400078e0210ULL, 0x0000000129297824ULL, 0x100fe400078e0210ULL,
0x000000012b2b7824ULL, 0x100fe400078e0210ULL, 0x000000012d2d7824ULL, 0x100fe400078e0210ULL,
0x000000012f2f7824ULL, 0x100fe400078e0210ULL, 0x0000000131317824ULL, 0x100fe400078e0210ULL,
0x0000000133337824ULL, 0x000fc400078e0210ULL, 0x0000000135497824ULL, 0x100fe400078e0210ULL,
0x0000000109157824ULL, 0x000fe400078e0210ULL, 0x00000010120f7824ULL, 0x100fe400078e0217ULL,
0x000000100e0e7824ULL, 0x100fe400078e0217ULL, 0x0000001014107824ULL, 0x100fe400078e0217ULL,
0x0000001016117824ULL, 0x000fc400078e0217ULL, 0x0000001018127824ULL, 0x100fe400078e0217ULL,
0x000000101a357824ULL, 0x100fe400078e0217ULL, 0x000000101c377824ULL, 0x100fe400078e0217ULL,
0x000000101e397824ULL, 0x100fe400078e0217ULL, 0x00000010203b7824ULL, 0x100fe400078e0217ULL,
0x00000010223d7824ULL, 0x000fc400078e0217ULL, 0x00000010243f7824ULL, 0x100fe400078e0217ULL,
0x0000001026417824ULL, 0x100fe400078e0217ULL, 0x0000001028437824ULL, 0x100fe400078e0217ULL,
0x000000102a457824ULL, 0x100fe400078e0217ULL, 0x000000102c477824ULL, 0x100fe400078e0217ULL,
0x000000102e4b7824ULL, 0x000fc400078e0217ULL, 0x0000008019167825ULL, 0x002fc800078e000cULL,
0x000000801b187825ULL, 0x000fc800078e000cULL, 0x000000801d1a7825ULL, 0x000fc800078e000cULL,
0x000000801f1c7825ULL, 0x000fc800078e000cULL, 0x00000080211e7825ULL, 0x000fc800078e000cULL,
0x0000008023207825ULL, 0x000fc800078e000cULL, 0x0000008025227825ULL, 0x000fc800078e000cULL,
0x0000008027247825ULL, 0x000fc800078e000cULL, 0x0000008029267825ULL, 0x000fc800078e000cULL,
0x000000802b287825ULL, 0x000fc800078e000cULL, 0x0000008015147825ULL, 0x000fc800078e000cULL,
0x000000802d2a7825ULL, 0x000fc800078e000cULL, 0x000000802f2c7825ULL, 0x000fc800078e000cULL,
0x00000080312e7825ULL, 0x000fc800078e000cULL, 0x0000008033307825ULL, 0x000fc800078e000cULL,
0x0000008049327825ULL, 0x000fe200078e000cULL, 0x00000013140c7210ULL, 0x000fe40007f1e0ffULL,
0x0000001316147210ULL, 0x000fe40007f3e0ffULL, 0x0000001318167210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e0615ULL, 0x000000131a187210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe200008e0617ULL, 0x000000131c1a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0619ULL, 0x000000131e1c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200018e061bULL, 0x00000013201e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200000e061dULL, 0x0000001322207210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e061fULL, 0x0000001324227210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e0621ULL, 0x0000001326247210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff217224ULL, 0x000fe200018e0623ULL, 0x0000001328267210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0e7faeULL, 0x0003e2000b901c4eULL,
0x000000132a287210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff237224ULL, 0x000fe200000e0625ULL,
0x000000132c2a7210ULL, 0x000fe20007f1e0ffULL, 0x00000000140f7faeULL, 0x0003e2000b901c4eULL,
0x000000ffff257224ULL, 0x000fe200008e0627ULL, 0x000000132e2c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff277224ULL, 0x000fe200010e0629ULL, 0x0000000016107faeULL, 0x0003e2000b901c4eULL,
0x000000ffff297224ULL, 0x000fe200018e062bULL, 0x00000013302e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200000e062dULL, 0x0000000018117faeULL, 0x0003e2000b901c4eULL,
0x0000001332307210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2d7224ULL, 0x000fc400008e062fULL,
0x000000001a127faeULL, 0x0003e2000b901c4eULL, 0x000000ffff2f7224ULL, 0x000fe400010e0631ULL,
0x000000ffff317224ULL, 0x000fe200018e0633ULL, 0x000000001c357faeULL, 0x0003e8000b901c4eULL,
0x000000001e377faeULL, 0x0003e8000b901c4eULL, 0x0000000020397faeULL, 0x0003e8000b901c4eULL,
0x00000000223b7faeULL, 0x0003e8000b901c4eULL, 0x00000000243d7faeULL, 0x0003e8000b901c4eULL,
0x00000000263f7faeULL, 0x0003e8000b901c4eULL, 0x0000000028417faeULL, 0x0003e8000b901c4eULL,
0x000000002a437faeULL, 0x0003e8000b901c4eULL, 0x000000002c457faeULL, 0x0003e8000b901c4eULL,
0x000000002e477faeULL, 0x0003e8000b901c4eULL, 0x00000000304b7faeULL, 0x0003e4000b901c4eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000020020d7836ULL, 0x042fe20000000000ULL,
0xfffffff8023b7812ULL, 0x000fe200078ec0ffULL, 0x000020000a3c7824ULL, 0x000fe200078e020bULL,
0x0000000702397812ULL, 0x000fe200078ec0ffULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000004ff0b7819ULL, 0x000fc40000011602ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fc4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fc4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000010003c3c7836ULL, 0x000fe20000000000ULL, 0x000000073b3b7812ULL, 0x000fe200078ef802ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000008393a7812ULL, 0x000fe400078ef802ULL,
0x000000070d0a7812ULL, 0x000fce00078ef802ULL, 0x00000007380c7812ULL, 0x000fe200078e783bULL,
0x0000000238797824ULL, 0x000fe200078e020bULL, 0x0000000738117812ULL, 0x000fc600078e780aULL,
0x000000083b0d7824ULL, 0x000fe400078e020cULL, 0x000000080a117824ULL, 0x000fe400078e0211ULL,
0x000000100d0d7824ULL, 0x100fe400078e023cULL, 0x0000001011117824ULL, 0x000fc800078e023cULL,
0x000000000d0c783bULL, 0x000e680000000200ULL, 0x000000001110783bULL, 0x000ea20000000200ULL,
0x00000018ff587819ULL, 0x002fe2000001140cULL, 0x000100000c187824ULL, 0x040fe200078e00ffULL,
0x000088800c727816ULL, 0x040fe200000000ffULL, 0x000001000c0c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001140dULL, 0x000100000d197824ULL, 0x040fe200078e00ffULL,
0x000088800d707816ULL, 0x040fe200000000ffULL, 0x000001000d0d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x0000005800587306ULL, 0x000fe20000202400ULL,
0x00000018ff537819ULL, 0x000fc4000001140eULL, 0x000088800e527816ULL, 0x000fe400000000ffULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x00000018ff637819ULL, 0x000fe2000001140fULL,
0x0000000c00757306ULL, 0x0002e20000202400ULL, 0x000088800f6c7816ULL, 0x000fe400000000ffULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x00000018ff197819ULL, 0x000fc40000011419ULL,
0x00000018ff5c7819ULL, 0x004fe20000011411ULL, 0x0000000d00717306ULL, 0x0005e20000202400ULL,
0x000100000e0c7824ULL, 0x042fe200078e00ffULL, 0x0000888011647816ULL, 0x000fe200000000ffULL,
0x000001000e0e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe40000011410ULL,
0x00000018ff0c7819ULL, 0x000fe4000001140cULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x000100000f0d7824ULL, 0x044fe200078e00ffULL, 0x0000001800777306ULL, 0x000fe20000202400ULL,
0x000001000f0f7824ULL, 0x000fe200078e00ffULL, 0x0000888010687816ULL, 0x000fc400000000ffULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x00000018ff0f7819ULL, 0x000fe4000001140fULL,
0x0000000e006e7306ULL, 0x0003e20000202400ULL, 0x00000018ff477819ULL, 0x000fe40000011412ULL,
0x00000018ff3d7819ULL, 0x000fe40000011413ULL, 0x00008880125d7816ULL, 0x000fe400000000ffULL,
0x0000888013567816ULL, 0x000fe200000000ffULL, 0x0000000f006a7306ULL, 0x0005e20000202400ULL,
0x00000001380e7836ULL, 0x002fc40000000000ULL, 0x0000000238387836ULL, 0x000fc60000000000ULL,
0x000000070e187812ULL, 0x000fe400078e783bULL, 0x0000001900737306ULL, 0x0003e20000202400ULL,
0x000000070e3f7812ULL, 0x000fe400078e780aULL, 0x000000083b0f7824ULL, 0x004fe200078e0218ULL,
0x000000083800780cULL, 0x000fe40003f05270ULL, 0x000000080a3f7824ULL, 0x000fe400078e023fULL,
0x000000100f0f7824ULL, 0x100fe200078e023cULL, 0x0000000c006f7306ULL, 0x0005e20000202400ULL,
0x000000103f0e7824ULL, 0x000fc600078e023cULL, 0x000000000f18783bULL, 0x002e680000000200ULL,
0x0000000d006d7306ULL, 0x0009e20000202400ULL, 0x00010000100c7824ULL, 0x044fe400078e00ffULL,
0x0000010010107824ULL, 0x000fc600078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe4000001140cULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x00010000110d7824ULL, 0x050fe200078e00ffULL,
0x0000000c006b7306ULL, 0x0005e20000202400ULL, 0x0000010011117824ULL, 0x000fc600078e00ffULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000001000697306ULL, 0x0009e20000202400ULL, 0x00010000120c7824ULL, 0x044fe400078e00ffULL,
0x0000010012127824ULL, 0x000fc600078e00ffULL, 0x00000018ff627819ULL, 0x000fe4000001140cULL,
0x0000001100657306ULL, 0x0003e20000202400ULL, 0x0001000013107824ULL, 0x050fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0000010013137824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000000d00677306ULL, 0x0005e20000202400ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0001000019117824ULL, 0x002fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe40000011418ULL, 0x0000888018407816ULL, 0x000fe400000000ffULL,
0x00000018ff4f7819ULL, 0x000fe20000011411ULL, 0x00000010005b7306ULL, 0x0003e20000202400ULL,
0x000000000e0c783bULL, 0x004ea20000000200ULL, 0x0000000779117812ULL, 0x000fe200078e783aULL,
0x0000000279797836ULL, 0x000fe20000000000ULL, 0x00000018ff467819ULL, 0x000fc40000011419ULL,
0x0000888019487816ULL, 0x000fe200000000ffULL, 0x000000103a117824ULL, 0x000fe200078e0211ULL,
0x0000001200607306ULL, 0x000fe20000202400ULL, 0x0001000018107824ULL, 0x042fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe2000001141aULL, 0x0000010018187824ULL, 0x000fe200078e00ffULL,
0x0000000511117c11ULL, 0x000fe2000f8e20ffULL, 0x0000010019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000001300547306ULL, 0x000fe20000202400ULL,
0x00000018ff187819ULL, 0x000fc40000011418ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x000088801a4a7816ULL, 0x000fe400000000ffULL, 0x0000000779797812ULL, 0x000fe200078e783aULL,
0x0000001000497306ULL, 0x0003e20000202400ULL, 0x00000018ff447819ULL, 0x000fe4000001141bULL,
0x000088801b4e7816ULL, 0x000fe200000000ffULL, 0x000000103a797824ULL, 0x000fc800078e0279ULL,
0x00000018004b7306ULL, 0x0009e20000202400ULL, 0x000000001110783bULL, 0x002e6e0000000200ULL,
0x0000007200727306ULL, 0x000f620000202400ULL, 0x000100001a187824ULL, 0x050fe200078e00ffULL,
0x00000018ff437819ULL, 0x004fe2000001140cULL, 0x000001001a1a7824ULL, 0x000fe200078e00ffULL,
0x000088800c507816ULL, 0x000fc400000000ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000019004d7306ULL, 0x0005e20000202400ULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x00000018ff427819ULL, 0x000fe4000001140dULL, 0x00000018ff417819ULL, 0x000fe4000001140eULL,
0x00000018ff3f7819ULL, 0x000fe2000001140fULL, 0x0000001800517306ULL, 0x0009e20000202400ULL,
0x000100001b197824ULL, 0x004fc400078e00ffULL, 0x000001001b1b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x0000005a005a7306ULL, 0x000fe20000202400ULL,
0x000100000c187824ULL, 0x050fe200078e00ffULL, 0x00000018ff1b7819ULL, 0x000fe2000001141bULL,
0x000001000c0c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x00000018ff0c7819ULL, 0x000fce000001140cULL,
0x0000001900577306ULL, 0x0007f00000202400ULL, 0x0000001800597306ULL, 0x000be20000202400ULL,
0x0000541075197816ULL, 0x008fce0000000058ULL, 0x0000005300537306ULL, 0x000ea20000202400ULL,
0x0000541072187816ULL, 0x020fce0000000077ULL, 0x0000005200527306ULL, 0x000ee20000202400ULL,
0x000000181034723cULL, 0x002fe20000041834ULL, 0x000054106e537816ULL, 0x004fcc0000000053ULL,
0x0000006300637306ULL, 0x000e620000202400ULL, 0x0000541070187816ULL, 0x000fe40000000073ULL,
0x0000541071197816ULL, 0x000fe4000000005aULL, 0x0000541052527816ULL, 0x008fc6000000006fULL,
0x0000006c006c7306ULL, 0x000ea40000202400ULL, 0x000000181030723cULL, 0x000fec0000041830ULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x000100000d197824ULL, 0x000fe200078e00ffULL,
0x00000052102c723cULL, 0x000fe2000004182cULL, 0x0000000579187c11ULL, 0x000fca000f8e20ffULL,
0x0000006800687306ULL, 0x000ee20000202400ULL, 0x000001000d527824ULL, 0x000fce00078e00ffULL,
0x0000000c00587306ULL, 0x0009f00000202400ULL, 0x0000001a004c7306ULL, 0x000be20000202400ULL,
0x00000018ff0c7819ULL, 0x010fce0000011419ULL, 0x0000000c00537306ULL, 0x0005e20000202400ULL,
0x000088800d1a7816ULL, 0x020fe400000000ffULL, 0x000054106a0d7816ULL, 0x002fe40000000063ULL,
0x00000018ff637819ULL, 0x000fe20000011452ULL, 0x000000ffff5a7224ULL, 0x000fe200078e001aULL,
0x000088800e527816ULL, 0x000fe200000000ffULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x000054106c0c7816ULL, 0x004fce000000006dULL, 0x0000006400647306ULL, 0x000e620000202400ULL,
0x0000000c1028723cULL, 0x000fee0000041828ULL, 0x00005410680c7816ULL, 0x008fe2000000006bULL,
0x0000004700477306ULL, 0x000fe20000202400ULL, 0x00005410690d7816ULL, 0x000fe20000000066ULL,
0x000100000e667824ULL, 0x000fc400078e00ffULL, 0x000001000e0e7824ULL, 0x000fc800078e00ffULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x0000000c1024723cULL, 0x000fe20000041824ULL,
0x00000018ff0e7819ULL, 0x000fcc000001140eULL, 0x0000006200627306ULL, 0x000ea20000202400ULL,
0x00005410640c7816ULL, 0x002fe40000000067ULL, 0x00005410650d7816ULL, 0x000fe4000000005cULL,
0x00000018ff657819ULL, 0x000fc60000011466ULL, 0x0000001b00557306ULL, 0x0003e40000202400ULL,
0x0000000c1020723cULL, 0x000fec0000041820ULL, 0x0000003d003d7306ULL, 0x000ee20000202400ULL,
0x000000001818783bULL, 0x002e620000000200ULL, 0x000054105d0c7816ULL, 0x004fc40000000062ULL,
0x00005410600d7816ULL, 0x000fe40000000047ULL, 0x000088800f477816ULL, 0x000fe400000000ffULL,
0x0000005600567306ULL, 0x000ea60000202400ULL, 0x0000000c101c723cULL, 0x000fea000004181cULL,
0x0000003e003e7306ULL, 0x000fe40000202400ULL, 0x00005410540d7816ULL, 0x008fe2000000003dULL,
0x000000ffff3d7224ULL, 0x000fe200078e0047ULL, 0x00005410560c7816ULL, 0x004fc8000000005bULL,
0x0000004000407306ULL, 0x000ea60000202400ULL, 0x0000000c1014723cULL, 0x000fea0000041814ULL,
0x0000004800487306ULL, 0x000fe40000202400ULL, 0x000100000f0d7824ULL, 0x000fc400078e00ffULL,
0x000001000f0f7824ULL, 0x000fe200078e00ffULL, 0x00005410400c7816ULL, 0x004fc60000000049ULL,
0x0000004f004f7306ULL, 0x000ea20000202400ULL, 0x00000018ff117819ULL, 0x000fe4000001140dULL,
0x000054104b0d7816ULL, 0x000fe4000000003eULL, 0x00000018ff0f7819ULL, 0x000fc6000001140fULL,
0x0000004a004a7306ULL, 0x000ee40000202400ULL, 0x0000000c1834723cULL, 0x002fe20000041834ULL,
0x0000541048487816ULL, 0x004fca000000004fULL, 0x0000003d00107306ULL, 0x000fe20000202400ULL,
0x000054104a4a7816ULL, 0x008fce0000000051ULL, 0x0000001100117306ULL, 0x000e700000202400ULL,
0x0000004600467306ULL, 0x000ea20000202400ULL, 0x0000541010107816ULL, 0x002fce0000000011ULL,
0x0000004500457306ULL, 0x000e620000202400ULL, 0x000054104d497816ULL, 0x004fce0000000046ULL,
0x0000004400447306ULL, 0x000ea20000202400ULL, 0x000000481830723cULL, 0x000fe20000041830ULL,
0x000054104c4b7816ULL, 0x002fcc0000000045ULL, 0x0000004300437306ULL, 0x000e620000202400ULL,
0x0000004a182c723cULL, 0x000fe2000004182cULL, 0x00005410554f7816ULL, 0x004fcc0000000044ULL,
0x0000004200427306ULL, 0x000fe20000202400ULL, 0x0000541058517816ULL, 0x002fce0000000043ULL,
0x0000004100417306ULL, 0x000ff00000202400ULL, 0x0000003f003f7306ULL, 0x000ff00000202400ULL,
0x0000004e004e7306ULL, 0x000e700000202400ULL, 0x0000005000507306ULL, 0x000ea20000202400ULL,
0x000054104e4e7816ULL, 0x002fce0000000057ULL, 0x0000005a005a7306ULL, 0x000e620000202400ULL,
0x0000004e1828723cULL, 0x000fe20000041828ULL, 0x0000541050507816ULL, 0x004fcc0000000059ULL,
0x0000006300637306ULL, 0x000ea20000202400ULL, 0x000000501824723cULL, 0x000fe20000041824ULL,
0x000054105a5a7816ULL, 0x002fcc0000000053ULL, 0x0000005200527306ULL, 0x000fe20000202400ULL,
0x00005410635b7816ULL, 0x004fce0000000042ULL, 0x0000006500657306ULL, 0x000e620000202400ULL,
0x0000005a1820723cULL, 0x000fee0000041820ULL, 0x0000000e000e7306ULL, 0x000ea20000202400ULL,
0x0000541052407816ULL, 0x002fce0000000065ULL, 0x0000000f000c7306ULL, 0x000e620000202400ULL,
0x000054100e417816ULL, 0x004fce0000000041ULL, 0x00000040181c723cULL, 0x000fe2000004181cULL,
0x000054100c117816ULL, 0x002fce000000003fULL, 0x000000101814723cULL, 0x000fe20000041814ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff0003c0947ULL, 0x000fde000383ffffULL,
0x0000ffff050a7812ULL, 0x000fe200078ec0ffULL, 0x00000004020b7824ULL, 0x000fe200078e00ffULL,
0x0000000512087291ULL, 0x000fe2000f8e383fULL, 0x0000000334117220ULL, 0x080fe20000410000ULL,
0x000088800a0c7816ULL, 0x000fe200000000ffULL, 0x0000000335357220ULL, 0x080fe20000410000ULL,
0x0000000336367220ULL, 0x080fe20000410000ULL, 0x0000000337377220ULL, 0x080fe20000410000ULL,
0x0000000330307220ULL, 0x080fe20000410000ULL, 0x800000000c0c7824ULL, 0x000fe400078e00ffULL,
0x0000000331317220ULL, 0x080fe20000410000ULL, 0x0000000332327220ULL, 0x080fe20000410000ULL,
0x0000000333337220ULL, 0x080fe20000410000ULL, 0x01b6100cff0075a7ULL, 0x000e620008000147ULL,
0x000000032c2c7220ULL, 0x080fe20000410000ULL, 0x000000032d2d7220ULL, 0x080fe20000410000ULL,
0x000000032e2e7220ULL, 0x080fe20000410000ULL, 0x000000032f2f7220ULL, 0x080fe20000410000ULL,
0x0000000328287220ULL, 0x080fe20000410000ULL, 0x0000000329297220ULL, 0x080fe20000410000ULL,
0x000000032a2a7220ULL, 0x080fe20000410000ULL, 0x000000032b2b7220ULL, 0x080fe20000410000ULL,
0x0000000324247220ULL, 0x080fe20000410000ULL, 0x0000000325257220ULL, 0x080fe20000410000ULL,
0x0000000326267220ULL, 0x080fe20000410000ULL, 0x0000000327277220ULL, 0x080fe20000410000ULL,
0x0000000320207220ULL, 0x080fe20000410000ULL, 0x0000000321217220ULL, 0x080fe20000410000ULL,
0x0000000322227220ULL, 0x080fe20000410000ULL, 0x0000000323237220ULL, 0x080fe20000410000ULL,
0x000000031c1c7220ULL, 0x080fe20000410000ULL, 0x000000031d1d7220ULL, 0x080fe20000410000ULL,
0x000000031e1e7220ULL, 0x080fe20000410000ULL, 0x000000031f1f7220ULL, 0x080fe20000410000ULL,
0x0000000314147220ULL, 0x080fe20000410000ULL, 0x0000000315157220ULL, 0x080fe20000410000ULL,
0x0000000316167220ULL, 0x080fe20000410000ULL, 0xfffffff00b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000317177220ULL, 0x000fe20000410000ULL, 0x0000001400648947ULL, 0x002fec0003800000ULL,
0x01b400080b0c7984ULL, 0x0002a20008000c00ULL, 0x000000046100720cULL, 0x000fda0003f05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x00000002020a7824ULL, 0x000fe400078e00ffULL,
0x000000015f067824ULL, 0x000fc600078e0a06ULL, 0x000000060a137812ULL, 0x000fc800078ec0ffULL,
0x0000000113197812ULL, 0x040fe400078efcffULL, 0x00000008131b7812ULL, 0x000fe400078efcffULL,
0x000000061900720cULL, 0x080fe40003f26070ULL, 0x0000001013197812ULL, 0x000fe400078efcffULL,
0x000000061b00720cULL, 0x080fe40003f06070ULL, 0x000000061900720cULL, 0x000fc40003fc6070ULL,
0x00000011131b7812ULL, 0x040fe400078efcffULL, 0x0000001813197812ULL, 0x040fe400078efcffULL,
0x000000061300720cULL, 0x080fe40003f46070ULL, 0x000000061b00720cULL, 0x080fe40003fa6070ULL,
0x000000061900720cULL, 0x000fe40003f66070ULL, 0x00000009133b7812ULL, 0x000fc400078efcffULL,
0x00000019131b7812ULL, 0x040fe400078efcffULL, 0x0000002013197812ULL, 0x000fe400078efcffULL,
0xff7fffff36367808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40005000000ULL,
0xff7fffff37377808ULL, 0x000fe40004800000ULL, 0xff7fffff35357808ULL, 0x000fc40004800000ULL,
0x000000063b00720cULL, 0x080fe40003f86070ULL, 0x000000061b00720cULL, 0x080fe40003f46070ULL,
0x000000061900720cULL, 0x000fe40003f26070ULL, 0x00000021131b7812ULL, 0x040fe400078efcffULL,
0x0000002813197812ULL, 0x000fe400078efcffULL, 0xff7fffff32327808ULL, 0x000fc40004000000ULL,
0xff7fffff30307808ULL, 0x000fe40004000000ULL, 0xff7fffff33337808ULL, 0x000fe40006000000ULL,
0xff7fffff31317808ULL, 0x000fe40006000000ULL, 0x000000061b00720cULL, 0x080fe40003f06070ULL,
0x000000061900720cULL, 0x000fe40003f86070ULL, 0x00000029131b7812ULL, 0x000fc400078efcffULL,
0x0000003013197812ULL, 0x000fe400078efcffULL, 0xff7fffff2e2e7808ULL, 0x000fe40007000000ULL,
0xff7fffff2c2c7808ULL, 0x000fe40007000000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40006800000ULL,
0xff7fffff2d2d7808ULL, 0x000fe40006800000ULL, 0x000000061b00720cULL, 0x000fc40003fc6070ULL,
0x000000061900720cULL, 0x000fe40003fa6070ULL, 0x00000031131b7812ULL, 0x040fe400078efcffULL,
0x0000003813197812ULL, 0x040fe400078efcffULL, 0x0000003913137812ULL, 0x000fe400078efcffULL,
0xff7fffff2a2a7808ULL, 0x000fe40005800000ULL, 0xff7fffff28287808ULL, 0x000fc40005800000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40005000000ULL, 0xff7fffff29297808ULL, 0x000fe40005000000ULL,
0xff7fffff26267808ULL, 0x000fe40004800000ULL, 0xff7fffff24247808ULL, 0x000fe40004800000ULL,
0x000000061b00720cULL, 0x080fe40003f66070ULL, 0x000000061900720cULL, 0x000fc40003f46070ULL,
0x000000061300720cULL, 0x000fe40003f26070ULL, 0xff7fffff27277808ULL, 0x000fe40004000000ULL,
0xff7fffff25257808ULL, 0x000fe40004000000ULL, 0xff7fffff22227808ULL, 0x000fe40006000000ULL,
0xff7fffff20207808ULL, 0x000fe40006000000ULL, 0xff7fffff23237808ULL, 0x000fc40007000000ULL,
0xff7fffff21217808ULL, 0x000fe40007000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40006800000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40006800000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40005800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40005800000ULL, 0xff7fffff16167808ULL, 0x000fc40005000000ULL,
0xff7fffff14147808ULL, 0x000fe40005000000ULL, 0xff7fffff17177808ULL, 0x000fe40004800000ULL,
0xff7fffff15157808ULL, 0x000fce0004800000ULL, 0x000000110c0c7209ULL, 0x004fe20007810000ULL,
0xffffffff00047882ULL, 0x000fe20000000000ULL, 0x000000360d067209ULL, 0x000fe40007810000ULL,
0x000000350c0d7209ULL, 0x000fe40007810000ULL, 0x0000003706137209ULL, 0x000fe40007810000ULL,
0x000000300d067209ULL, 0x000fe40007810000ULL, 0x00000032130a7209ULL, 0x000fc40007810000ULL,
0x00000031060d7209ULL, 0x000fe40007810000ULL, 0x000000330a137209ULL, 0x000fe40007810000ULL,
0x0000002c0d067209ULL, 0x000fe40007810000ULL, 0x0000002e130a7209ULL, 0x000fe40007810000ULL,
0x0000002d060d7209ULL, 0x000fe40007810000ULL, 0x0000002f0a137209ULL, 0x000fc40007810000ULL,
0x000000280d067209ULL, 0x000fe40007810000ULL, 0x0000002a130a7209ULL, 0x000fe40007810000ULL,
0x00000029060d7209ULL, 0x000fe40007810000ULL, 0x0000002b0a137209ULL, 0x000fe40007810000ULL,
0x000000240d067209ULL, 0x000fe40007810000ULL, 0x00000026130a7209ULL, 0x000fc40007810000ULL,
0x00000025060d7209ULL, 0x000fe40007810000ULL, 0x000000270a137209ULL, 0x000fe40007810000ULL,
0x000000200d067209ULL, 0x000fe40007810000ULL, 0x00000022130a7209ULL, 0x000fe40007810000ULL,
0x00000021060d7209ULL, 0x000fe40007810000ULL, 0x000000230a137209ULL, 0x000fc40007810000ULL,
0x0000001c0d067209ULL, 0x000fe40007810000ULL, 0x0000001e130a7209ULL, 0x000fe40007810000ULL,
0x0000001d060d7209ULL, 0x000fe40007810000ULL, 0x0000001f0a137209ULL, 0x000fe40007810000ULL,
0x000000ff05ff7812ULL, 0x000fe4000780c0ffULL, 0x000000140d067209ULL, 0x000fc40007810000ULL,
0x00000016130a7209ULL, 0x000fe40007810000ULL, 0x00000001ff057807ULL, 0x000fe40000000000ULL,
0x00000015060c7209ULL, 0x000fe40007810000ULL, 0x000000170a0a7209ULL, 0x000fe20007810000ULL,
0x0000000e04e07947ULL, 0x000fec000b800000ULL, 0x0c401f000c0d7f89ULL, 0x000e6800000e0000ULL,
0x0c401f000a137f89ULL, 0x000ea800000e0000ULL, 0x0c401f000e197f89ULL, 0x000ee800000e0000ULL,
0x0c401f000f067f89ULL, 0x000f2200000e0000ULL, 0x0000000d0c107209ULL, 0x002fc40007810000ULL,
0x000000130a137209ULL, 0x004fc60007810000ULL, 0x0c201f00100d7f89ULL, 0x000e6200000e0000ULL,
0x000000190e197209ULL, 0x008fc60007810000ULL, 0x0c201f0013127f89ULL, 0x000ea200000e0000ULL,
0x000000060f067209ULL, 0x010fc60007810000ULL, 0x0c201f0019187f89ULL, 0x000ee800000e0000ULL,
0x0c201f00063b7f89ULL, 0x00092200000e0000ULL, 0x0000000d100c7209ULL, 0x002fe40007810000ULL,
0x00000012130d7209ULL, 0x004fe40007810000ULL, 0x00000018190e7209ULL, 0x008fce0007810000ULL,
0x3fb8aa3b0c0a7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b0d347820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe40000000000ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b11117823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b30307823ULL, 0x000fe2000001080aULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b33337823ULL, 0x000fe20000010834ULL,
0x0000002c00187308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001080aULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001080aULL,
0x0000001100107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001080aULL,
0x3fb8aa3b150a7823ULL, 0x000fe2000001080aULL, 0x3fb8aa3b2a1b7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010834ULL,
0x00000028001a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b17177823ULL, 0x000fc80000010834ULL, 0x0000001c002c7308ULL, 0x000ff00000000800ULL,
0x0000003500357308ULL, 0x000e700000000800ULL, 0x0000003000127308ULL, 0x000fe20000000800ULL,
0x000000103510723eULL, 0x002fce00000010ffULL, 0x0000003100317308ULL, 0x000e700000000800ULL,
0x0000003600117308ULL, 0x000fe20000000800ULL, 0x000000123112723eULL, 0x002fce00000010ffULL,
0x00000037001c7308ULL, 0x000e700000000800ULL, 0x0000003200137308ULL, 0x000fe20000000800ULL,
0x000000111c11723eULL, 0x002fce00000010ffULL, 0x0000003300287308ULL, 0x000e620000000800ULL,
0x3fb8aa3b2b1c7823ULL, 0x000fce0000010834ULL, 0x0000001400307308ULL, 0x0005e20000000800ULL,
0x000000132813723eULL, 0x002fce00000010ffULL, 0x00000029000f7308ULL, 0x000e620000000800ULL,
0x00000004ff147e24ULL, 0x004fca000f8e00ffULL, 0x3f8000001414783eULL, 0x000fe400000010ffULL,
0x0000000a003f7308ULL, 0x000fe60000000800ULL, 0x000000ffff157224ULL, 0x000fe200078e0014ULL,
0x0000001a0f1a723eULL, 0x002fc800000010ffULL, 0x0000002d002d7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b1f0f7823ULL, 0x000fe20000010834ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x000000141028723cULL, 0x000fe200000418ffULL, 0x0000002e00197308ULL, 0x000fe20000000800ULL,
0x000000182d18723eULL, 0x002fce00000010ffULL, 0x0000002f000a7308ULL, 0x000e700000000800ULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x000000190a19723eULL, 0x002fce00000010ffULL,
0x0000001c001c7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1e0a7823ULL, 0x000fce0000010834ULL,
0x0000001d003d7308ULL, 0x000fe20000000800ULL, 0x0000001b1c1b723eULL, 0x002fce00000010ffULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x000000141828723cULL, 0x000fee0000041828ULL,
0x0000002500257308ULL, 0x000e700000000800ULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x00000024251c723eULL, 0x002fce00000010ffULL, 0x0000002100217308ULL, 0x000e620000000800ULL,
0x0000000fff257424ULL, 0x000fce00078e00ffULL, 0x00000026001d7308ULL, 0x000fe20000000800ULL,
0x00000020211e723eULL, 0x002fce00000010ffULL, 0x00000027002e7308ULL, 0x000e620000000800ULL,
0x0000002c3d20723eULL, 0x000fce00000010ffULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x0000001d2e1d723eULL, 0x002fce00000010ffULL, 0x0000002300237308ULL, 0x000e700000000800ULL,
0x0000000a000a7308ULL, 0x000fe20000000800ULL, 0x00000022231f723eULL, 0x002fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x000000303f22723eULL, 0x000fe200000010ffULL,
0x000000141c28723cULL, 0x000fec0000041828ULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x0000000a0f21723eULL, 0x002fce00000010ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0xfffffffc020a7812ULL, 0x000fe400078ec0ffULL, 0x0000003b060f7209ULL, 0x010fe40007810000ULL,
0x0000000a25257219ULL, 0x000fe400000006ffULL, 0x000000161723723eULL, 0x002fce00000010ffULL,
0x000000142028723cULL, 0x000fde0000041828ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x001c1fff28147589ULL, 0x00026200000e0000ULL, 0x0000000000167806ULL, 0x000fe200038e0100ULL,
0x00000000250a73a1ULL, 0x000eb000000e8000ULL, 0x00000000250473c4ULL, 0x000ee20000004000ULL,
0x0000000000097886ULL, 0x000fc400038e0100ULL, 0x0000000925ff7c12ULL, 0x004fda000f80400aULL,
0x0000000a04e88947ULL, 0x00afea000b800000ULL, 0x001c1fff2a157589ULL, 0x0002a800000e0000ULL,
0x001c1fff16167589ULL, 0x000ee800000e0000ULL, 0x001c1fff00177589ULL, 0x00032400000e0000ULL,
0xfffffff8ff397812ULL, 0x000fe200078ee239ULL, 0x0000000512047291ULL, 0x000fe2000f8e583fULL,
0x0000000309257812ULL, 0x002fe200078ec0ffULL, 0x000000ffff287224ULL, 0x000fe200078e0010ULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x00000008390a7836ULL, 0x000fe20000000000ULL,
0x0000000425277812ULL, 0x000fe200078efcffULL, 0x0000000839067824ULL, 0x000fe200078e00ffULL,
0x0000000725097812ULL, 0x000fe200078e7839ULL, 0x00000004ff267e24ULL, 0x000fe2000f8e00ffULL,
0x0000000727397812ULL, 0x000fe200078e7839ULL, 0x000000080a247824ULL, 0x000fe200078e00ffULL,
0x0000000725257812ULL, 0x000fe200078e780aULL, 0x000000ffff297224ULL, 0x000fe200078e0012ULL,
0x0000000727277812ULL, 0x000fe200078e780aULL, 0x00011000260a7836ULL, 0x000fe20000000000ULL,
0x0000000609097212ULL, 0x080fe200078efcffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0018ULL,
0x0000000639397212ULL, 0x000fe200078efcffULL, 0x000000ffff2b7224ULL, 0x000fe200078e001aULL,
0x0000002425257212ULL, 0x080fe200078efcffULL, 0x0000001009097824ULL, 0x000fe200078e020aULL,
0x0000002427277212ULL, 0x000fe200078efcffULL, 0x000000ffff107224ULL, 0x000fc400078e0011ULL,
0x0000001039397824ULL, 0x000fe200078e020aULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000002809007844ULL, 0x0003e20000000200ULL, 0x000000ffff2c7224ULL, 0x000fe400078e001cULL,
0x000000ffff2d7224ULL, 0x000fe400078e001eULL, 0x000000ffff2e7224ULL, 0x000fc400078e0020ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0022ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x0000001025257824ULL, 0x100fe200078e020aULL, 0x0000002c39007844ULL, 0x0003e20000000200ULL,
0x000000ffff127224ULL, 0x000fe400078e0019ULL, 0x000000ffff137224ULL, 0x000fe400078e001bULL,
0x0000001027277824ULL, 0x000fc400078e020aULL, 0x000000ffff187224ULL, 0x000fe200078e001dULL,
0x0000001025007844ULL, 0x0003e20000000200ULL, 0x000000ffff197224ULL, 0x000fe400078e001fULL,
0x000000ffff1a7224ULL, 0x000fe400078e0021ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0023ULL,
0x00000001ff067424ULL, 0x000fe400078e00ffULL, 0x000000ffff617224ULL, 0x000fe200078e0007ULL,
0x0000001827007844ULL, 0x0003e20000000200ULL, 0x000000ffff0a7224ULL, 0x000fc600078e0008ULL,
0x01b0000c0b008988ULL, 0x0003e80008000c08ULL, 0x01b200140b008988ULL, 0x01c3e20008000c08ULL,
0x0000005e0700720cULL, 0x000fe20003f06070ULL, 0x01b60806ffff79a7ULL, 0x0003d80008500007ULL,
0xffffffc4000c8947ULL, 0x002fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff257224ULL, 0x000fce00078e0024ULL, 0x00000007ff277e24ULL, 0x000fc8000f8e00ffULL,
0x00002025270075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00002025270095a7ULL, 0x000e64000802007fULL,
0xfffffffc00e89947ULL, 0x002fea000383ffffULL, 0xffffff1800147947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x008fce00078e0010ULL, 0x0000000dff0b7e24ULL, 0x000fc8000f8e00ffULL,
0xffffc0110b0075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0xffffc0110b0095a7ULL, 0x000e64000802007fULL,
0xfffffffc00e89947ULL, 0x002fea000383ffffULL, 0xffffff1c002c7947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x100fe400078e0013ULL, 0x000000ffff117224ULL, 0x000fce00078e0013ULL,
0x00000009ff0b7e24ULL, 0x000fc8000f8e00ffULL, 0x000000110b0075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x000000110b0085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffff2000407947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x100fe400078e0014ULL,
0x000000ffff117224ULL, 0x000fce00078e0014ULL, 0x00000007ff177e24ULL, 0x000fc8000f8e00ffULL,
0x00002011170075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x00002011170095a7ULL, 0x000e64000802007fULL,
0xfffffffc00e89947ULL, 0x002fea000383ffffULL, 0xffffff4000587947ULL, 0x000fea000383ffffULL,
0x000000ffff037224ULL, 0x004fce00078e0002ULL, 0x0000000dff057e24ULL, 0x000fc8000f8e00ffULL,
0xffffe003050075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0xffffe003050095a7ULL, 0x000e64000802007fULL,
0xfffffffc00e89947ULL, 0x002fea000383ffffULL, 0xffffff44007c7947ULL, 0x000fea000383ffffULL,
0x000000ffff027224ULL, 0x100fe400078e000dULL, 0x000000ffff037224ULL, 0x000fce00078e000dULL,
0x00000016ff057e24ULL, 0x000fc8000f8e00ffULL, 0x00000003050075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00000003050085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffff4800687947ULL, 0x004fea000383ffffULL, 0x00000005ff047e24ULL, 0x000fc8000f8e00ffULL,
0x01b600ff040075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01b600ff040085a7ULL, 0x000e64000800007fULL,
0xfffffffc00e88947ULL, 0x002fea000383ffffULL, 0xffffffbc00907947ULL, 0x020fea000383ffffULL,
0x00000005ff077e24ULL, 0x002fe4000f8e00ffULL, 0x80000000ff047424ULL, 0x000fe400078e00ffULL,
0x80000000ff057424ULL, 0x000fc800078e00ffULL, 0x01b60005070075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01b60005070085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e08947ULL, 0x002fea000383ffffULL,
0xffffffbc00e47947ULL, 0x020fea000383ffffULL, 0x000000ffff0d7224ULL, 0x000fce00078e000cULL,
0x00000007ff0f7e24ULL, 0x000fc8000f8e00ffULL, 0x01b6100d0f0075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01b6100d0f0085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffffe8007c7947ULL, 0x000fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1b7224ULL, 0x000fe400078e000cULL, 0x00000002ff1a7424ULL, 0x000fe400078e00ffULL,
0x0000001fff3d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fce00078e00ffULL,
0x0000000034087348ULL, 0x000fea0003c00000ULL, 0x0c00001a1b3b7389ULL, 0x0006e4000000003dULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff1b7224ULL, 0x002fe400078e000aULL, 0x00000002ff1a7424ULL, 0x000fe400078e00ffULL,
0x0000001fff3d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x004fce00078e003bULL, 0x0000000034087348ULL, 0x000fea0003c00000ULL,
0x0c00001a1b3b7389ULL, 0x000264000000003dULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000000d0c107209ULL, 0x000fe20007810000ULL, 0x000000ffff1b7224ULL, 0x000fe400078e000eULL,
0x000000ffff137224ULL, 0x000fce00078e003bULL, 0x0000000034087348ULL, 0x000fea0003c00000ULL,
0x0c00001a1b3b7389ULL, 0x000264000000003dULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x000000130a137209ULL, 0x000fe20007810000ULL, 0x000000ffff1b7224ULL, 0x000fe400078e000fULL,
0x000000ffff197224ULL, 0x000fce00078e003bULL, 0x0000000034087348ULL, 0x000fea0003c00000ULL,
0x0c00001a1b3b7389ULL, 0x000264000000003dULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x000000190e197209ULL, 0x000fe20007810000ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0010ULL,
0x00000001ff1a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff067224ULL, 0x000fce00078e003bULL,
0x0000000034087348ULL, 0x000fea0003c00000ULL, 0x0c00001a1b3b7389ULL, 0x000264000000003dULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000060f067209ULL, 0x000fe20007810000ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0013ULL, 0x000000ffff0d7224ULL, 0x000fce00078e003bULL,
0x0000000034087348ULL, 0x000fea0003c00000ULL, 0x0c00001a1b3b7389ULL, 0x000264000000003dULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000000d100c7209ULL, 0x000fe20007810000ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0019ULL, 0x000000ffff127224ULL, 0x000fce00078e003bULL,
0x0000000034087348ULL, 0x000fea0003c00000ULL, 0x0c00001a1b3b7389ULL, 0x000264000000003dULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x00000012130d7209ULL, 0x000fe20007810000ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0006ULL, 0x000000ffff187224ULL, 0x000fce00078e003bULL,
0x0000000034087348ULL, 0x000fea0003c00000ULL, 0x0c00001a1b3b7389ULL, 0x000264000000003dULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x00000018190e7209ULL, 0x000fe20007810000ULL,
0xffffffec007c7947ULL, 0x000fec000383ffffULL, 0x0000007000007945ULL, 0x000fe20003800000ULL,
0x000000ffff177224ULL, 0x000fe400078e00ffULL, 0x00001c1fff277424ULL, 0x000fe400078e00ffULL,
0x000000ffff347224ULL, 0x000fce00078e0025ULL, 0x0000000034087348ULL, 0x000fea0003c00000ULL,
0x000000172a177389ULL, 0x0006e40000000027ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff157224ULL, 0x004fe400078e0017ULL, 0x000000ffff2a7224ULL, 0x002fe400078e0016ULL,
0x000000ffff177224ULL, 0x000fe400078e00ffULL, 0x00001c1fff277424ULL, 0x000fe400078e00ffULL,
0x000000ffff347224ULL, 0x000fce00078e0025ULL, 0x0000000034087348ULL, 0x000fea0003c00000ULL,
0x000000172a177389ULL, 0x0006e40000000027ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x004fe400078e0017ULL, 0x000000ffff2a7224ULL, 0x002fe400078e0000ULL,
0x000000ffff177224ULL, 0x000fe400078e00ffULL, 0x00001c1fff277424ULL, 0x000fe400078e00ffULL,
0x000000ffff347224ULL, 0x000fce00078e0025ULL, 0x0000000034087348ULL, 0x000fea0003c00000ULL,
0x000000172a177389ULL, 0x0006e40000000027ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff000b07947ULL, 0x006fea000383ffffULL,
0x0180000002007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000200008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff02ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000002027812ULL, 0x002fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000200007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x006fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffef402587950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001b680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL, 0x0000000e00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000f8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000630ULL, 0x0000000000000048ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000678ULL, 0x00000000000004fcULL, 0x0000000d00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000b74ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000b98ULL, 0x0000000000000000ULL, 0x0000000d00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000b98ULL, 0x0000000000000030ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000bc8ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000c10ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000c18ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000c80ULL, 0x0000000000010b80ULL, 0x0000000e00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000011800ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000011810ULL, 0x0000000000000400ULL, 0x0000000d00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000011810ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000011810ULL, 0x0000000000000260ULL, 0x0000000d00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000011ef0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000011ef0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000000c10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000000c80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000010b80ULL,
0x0000000000010b80ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000011800ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL, 0x0000000000000414ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000011810ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000260ULL, 0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_16_m_16_sm_90_cubin_len = 73792;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
