/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000017210ULL, 0x0000000000016d90ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000015930ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x0000000000015aa0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000015ae0ULL, 0x0000000000000120ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000015c00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001593000000000ULL, 0x0000040400000000ULL, 0x810c000000940400ULL, 0x0055a80400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001593000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080a90828808081ULL, 0x8808288080aa0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808088920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL,
0x00015aa000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0xaa08288080a90828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080aa920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000016000000000ULL,
0x00015ae000000000ULL, 0x0000012000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x00081204000000f1ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000007c00043704ULL, 0x0000000d00080a04ULL,
0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL,
0x0021f00000400006ULL, 0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL,
0x0011f00000300004ULL, 0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0018310400ff1b03ULL, 0x00014c20000149e0ULL, 0x00014da000014c30ULL,
0x00014dc000014db0ULL, 0xffffffff00e82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500001dffffffffULL, 0x0500001d0500001dULL, 0xffffffff0500001dULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00e82804ffffffffULL, 0x0000023000000090ULL,
0x000016d000001620ULL, 0x0000178000001750ULL, 0x00002d1000002cb0ULL, 0x0000451000004470ULL,
0x000045c000004590ULL, 0x000058a000005860ULL, 0x00006fb000006f10ULL, 0x0000706000007030ULL,
0x0000844000008430ULL, 0x00009a40000099a0ULL, 0x00009af000009ac0ULL, 0x0000ada00000ad50ULL,
0x0000c1000000c0f0ULL, 0x0000ebf00000ebd0ULL, 0x0000f1000000f0d0ULL, 0x0001467000014640ULL,
0x0001469000014680ULL, 0x000146d0000146b0ULL, 0x00014700000146f0ULL, 0x00014df000014d90ULL,
0x00014e1000014e00ULL, 0x000154b000015440ULL, 0x0001557000015510ULL, 0x00015610000155c0ULL,
0x000156b000015660ULL, 0x0001575000015700ULL, 0x00015840000157c0ULL, 0x00015900000158a0ULL,
0x0000015003e03904ULL, 0x0000f600000000ffULL, 0x00000190003f0100ULL, 0x0000f6080000000fULL,
0x000001c0003f0130ULL, 0x0000f6100000000fULL, 0x000001f0003f0130ULL, 0x0000f6480000000fULL,
0x00000220003f0120ULL, 0x0000f6680000000fULL, 0x00000460003f0120ULL, 0x0000f600000000ffULL,
0x000006f0003f0107ULL, 0x0000f61400000037ULL, 0x00000a40003f0102ULL, 0x0000f61000000037ULL,
0x00000b80003f0101ULL, 0x00000000000000ffULL, 0x00000c1000040107ULL, 0x000000200000003eULL,
0x00000d60003f0101ULL, 0x000000240000003eULL, 0x00000e00003f0106ULL, 0x000000240000003eULL,
0x00000e90003f0106ULL, 0x000000240000003eULL, 0x000013b0003f0106ULL, 0x0000000000000049ULL,
0x0000142000060107ULL, 0x000000040000002dULL, 0x0000144000060106ULL, 0x0000f60c00000042ULL,
0x00001540003f0106ULL, 0x0000f60c00000042ULL, 0x000019f0003f0106ULL, 0x000000040000002dULL,
0x00001a9000060106ULL, 0x000000040000002dULL, 0x00003b0000060106ULL, 0x000000200000003eULL,
0x00003b80003f0101ULL, 0x0000000000000000ULL, 0x00003c30003f0101ULL, 0x000000240000003eULL,
0x00003c80003f0106ULL, 0x000000240000003eULL, 0x00003d10003f0106ULL, 0x000000240000003eULL,
0x00004230003f0106ULL, 0x00000000000000ffULL, 0x000042a000050107ULL, 0x000000040000005aULL,
0x000042c0003f0106ULL, 0x0000f61c00000042ULL, 0x000043d0003f0106ULL, 0x0000f61c00000042ULL,
0x00004890003f0106ULL, 0x0000f64c00000025ULL, 0x00004920003f0106ULL, 0x0000f64c00000025ULL,
0x000067a0003f0106ULL, 0x000000200000003eULL, 0x00006820003f0101ULL, 0x0000000000000000ULL,
0x000068c0003f0101ULL, 0x000000240000003eULL, 0x00006920003f0106ULL, 0x000000240000003eULL,
0x000069b0003f0106ULL, 0x000000240000003eULL, 0x00006cc0003f0106ULL, 0x0000000000000049ULL,
0x00006d3000060107ULL, 0x0000f64c00000000ULL, 0x00006d50003f0106ULL, 0x0000f62c00000042ULL,
0x00006e70003f0106ULL, 0x0000f62c00000042ULL, 0x00007340003f0106ULL, 0x0000f64c00000026ULL,
0x000073f0003f0106ULL, 0x0000f64c00000026ULL, 0x00009290003f0106ULL, 0x000000200000003eULL,
0x00009310003f0101ULL, 0x0000000000000000ULL, 0x000093b0003f0101ULL, 0x000000240000003eULL,
0x00009400003f0106ULL, 0x000000240000003eULL, 0x00009490003f0106ULL, 0x000000240000003eULL,
0x00009790003f0106ULL, 0x00000000000000ffULL, 0x0000980000050107ULL, 0x000000040000005aULL,
0x00009820003f0106ULL, 0x0000f63c00000042ULL, 0x00009900003f0106ULL, 0x0000f63c00000042ULL,
0x00009dc0003f0106ULL, 0x0000f64c00000025ULL, 0x00009e50003f0106ULL, 0x0000f64c00000025ULL,
0x0000bc30003f0106ULL, 0x000000200000003eULL, 0x0000bc90003f0101ULL, 0x0000f64000000042ULL,
0x00010ad0003f0101ULL, 0x0000f604000000ffULL, 0x00010b60003f0106ULL, 0x0000f604000000ffULL,
0x00010d80003f0106ULL, 0x0000f600000000ffULL, 0x00010d90003f0101ULL, 0x0000f604000000ffULL,
0x00010e10003f0106ULL, 0x0000f604000000ffULL, 0x00013a50003f0106ULL, 0x0000f6140000003aULL,
0x00013f20003f0106ULL, 0x0000f6140000003aULL, 0x00015390003f0106ULL, 0x0000f6080000003aULL,
0x00053803003f0101ULL, 0x0000fb0000141c04ULL, 0x00010e600000ff50ULL, 0x000153f000010f00ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001ccULL, 0x0000001100000002ULL,
0x000000000000014cULL, 0x0000001100000002ULL, 0x00000000000000ccULL, 0x0000001100000002ULL,
0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001a2ULL, 0x0000001100000002ULL,
0x0000000000000122ULL, 0x0000001100000002ULL, 0x00000000000000a8ULL, 0x0000001100000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000e7919ULL, 0x000e620000002300ULL,
0x00000004ff117424ULL, 0x000fe200078e00ffULL, 0x0000460000087ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x0000000000097919ULL, 0x000ea80000002100ULL,
0x0000000000387919ULL, 0x000ee80000002700ULL, 0x0000000000107919ULL, 0x000f220000002600ULL,
0x000000010e007824ULL, 0x002fc600078e0203ULL, 0x00001fff0e0e7589ULL, 0x000e6200000e0000ULL,
0x00000080000f7824ULL, 0x104fe200078e0209ULL, 0x00000005ff007819ULL, 0x000fe20000011609ULL,
0x0000600038087625ULL, 0x008fc600078e0011ULL, 0x000000ff0f00720cULL, 0x040fe40003f05270ULL,
0x000000030f00780cULL, 0x040fe40003f44070ULL, 0x0000007f0f00780cULL, 0x040fe40003f24070ULL,
0x000000010f00780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL, 0x00f60002ff008388ULL, 0x0005e20000000a00ULL,
0x000000ff0e00720cULL, 0x002fe20003f05270ULL, 0x3fffff80ff0aa424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0ba424ULL, 0x000fe200078e00ffULL, 0x00f608040f00a388ULL, 0x0005e2000000ca00ULL,
0x3fffffc0ff06a424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0x00f6100a0f00a388ULL, 0x0005e2000000ca00ULL, 0xff317217ff129424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL, 0x00f648060f00a388ULL, 0x0005e20000008a00ULL,
0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL, 0x00f400120f009388ULL, 0x0005e80000004800ULL,
0x00f6680c0f00b388ULL, 0x0005e80000008a00ULL, 0x00001fff00027589ULL, 0x00046800000e0000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000027000000947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x014ea20000000000ULL, 0x0000000402047824ULL, 0x002fc400078e00ffULL,
0x00005800ff007624ULL, 0x000fe400078e00ffULL, 0x0000001010037824ULL, 0x000fe400078e00ffULL,
0x0000001000007824ULL, 0x000fe400078e00ffULL, 0x00000100ff077424ULL, 0x000fe400078e00ffULL,
0x0000003800007224ULL, 0x000fe200078e0203ULL, 0x000000040f0b7211ULL, 0x044fe200078fe0ffULL,
0x000000100f037824ULL, 0x000fc600078e00ffULL, 0x000000020b0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100047824ULL, 0x040fe200078e020bULL, 0x000000f003117812ULL, 0x000fe400078ec0ffULL,
0x000000070d037812ULL, 0x000fe200078ec0ffULL, 0x0000000100067824ULL, 0x000fe200078e020dULL,
0x000000070b007812ULL, 0x000fe200078ec0ffULL, 0x00005c0004047625ULL, 0x080fe200078e0007ULL,
0x0000000f030a7812ULL, 0x100fe400078e780fULL, 0x0000000f00007812ULL, 0x000fe200078e780fULL,
0x00005c0006067625ULL, 0x000fe200078e0007ULL, 0x0000001104047210ULL, 0x000fc60007f1e0ffULL,
0x000000100b007824ULL, 0x000fe200078e0200ULL, 0x0000001106067210ULL, 0x000fe20007f3e0ffULL,
0x000000100d0a7824ULL, 0x000fe400078e020aULL, 0x000000ffff057224ULL, 0x000fe400000e0605ULL,
0x0000001000037824ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400008e0607ULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e8000b901c48ULL, 0x00000000060b7faeULL, 0x0003e8000b901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000808037981ULL, 0x016ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000e620000002500ULL, 0x000000ff0e00720cULL, 0x000fe20003f05270ULL,
0x00000004ff347e24ULL, 0x002fe2000f8e00ffULL, 0x000000ff03357810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff357819ULL, 0x000fce0000011635ULL, 0x0000fa2000008947ULL, 0x000fea0003800000ULL,
0x0000000000367919ULL, 0x000e620000000000ULL, 0x0000001002377824ULL, 0x000fe200078e00ffULL,
0x0000580010057a10ULL, 0x000fe20007ffe0ffULL, 0x0000000238387824ULL, 0x000fe200078e00ffULL,
0x0000000134007810ULL, 0x000fe20007ffe0ffULL, 0x00000003ff147424ULL, 0x000fe200078e00ffULL,
0x00000001ff487819ULL, 0x000fe20000011602ULL, 0x0000580038387a24ULL, 0x000fe200078e0205ULL,
0x0000001037397812ULL, 0x000fe400078ec0ffULL, 0x000000350000720cULL, 0x000fe20003f06070ULL,
0x0000000834007824ULL, 0x000fe200078e0248ULL, 0x00000003ff0c7819ULL, 0x002fc80000011636ULL,
0x000000040c0e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000139077824ULL, 0x000fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000807057824ULL, 0x040fe200078e00ffULL,
0x0000003607047212ULL, 0x080fe200078e3cffULL, 0x0000000139097824ULL, 0x000fe200078e020eULL,
0x000000080c107810ULL, 0x000fe20007ffe0ffULL, 0x0000002000007824ULL, 0x000fe200078e00ffULL,
0xfffffff805087812ULL, 0x000fe200078ee204ULL, 0x00000008090b7824ULL, 0x040fe200078e00ffULL,
0x0000003609067212ULL, 0x000fe200078e3cffULL, 0x00f6141437ff738cULL, 0x0003e20000000000ULL,
0x0000000003057217ULL, 0x000fe20007800000ULL, 0x00002000483a7824ULL, 0x000fe200078e00ffULL,
0x0000000c0c127810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff167424ULL, 0x000fe200078e00ffULL,
0xfffffff80b0a7812ULL, 0x000fe200078ee206ULL, 0x0000000105067824ULL, 0x100fe200078e0a00ULL,
0x00000000480473c2ULL, 0x0004e200000e0000ULL, 0x0000620038007a24ULL, 0x000fc400078e0200ULL,
0x0000000139057824ULL, 0x040fe400078e0210ULL, 0x00000001390d7824ULL, 0x000fe400078e0212ULL,
0x0000000100047824ULL, 0x000fe200078e0207ULL, 0x0000b0003a077810ULL, 0x000fe20007ffe0ffULL,
0x0000000100097824ULL, 0x040fe400078e0209ULL, 0x00000001000b7824ULL, 0x040fe400078e0205ULL,
0x0000000100137824ULL, 0x000fe200078e020dULL, 0x0000003605007212ULL, 0x0c0fe200078e3cffULL,
0x00000008050f7824ULL, 0x000fe200078e00ffULL, 0x000000360d057212ULL, 0x040fe200078e3cffULL,
0x000000080d147824ULL, 0x002fc400078e00ffULL, 0x0000001036177824ULL, 0x000fe200078e00ffULL,
0xfffffff80f007812ULL, 0x000fe200078ee200ULL, 0x00000010080d7824ULL, 0x000fe200078e0207ULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x00005e0004047625ULL, 0x000fe200078e0016ULL,
0x0000007017177812ULL, 0x000fc600078ec0ffULL, 0x0000001000117824ULL, 0x100fe200078e0207ULL,
0x0000002006007807ULL, 0x000fe20000000000ULL, 0x000000100a0f7824ULL, 0x100fe200078e0207ULL,
0x0000001704047210ULL, 0x000fe20007f1e0ffULL, 0x0000001014157824ULL, 0x000fe200078e0207ULL,
0x0000003900007217ULL, 0x000fe20007800000ULL, 0x00005e0009067625ULL, 0x000fc800078e0016ULL,
0x00005e000b087625ULL, 0x000fc800078e0016ULL, 0x00005e00130a7625ULL, 0x000fe200078e0016ULL,
0x0000001708087210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000001706067210ULL, 0x080fe20007f1e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a39ULL,
0x000000170a0a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe400008e0609ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x000000000c00720cULL, 0x080fe20003f06070ULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x000000000e00720cULL, 0x080fe40003f26070ULL,
0x000000001000720cULL, 0x000fc40003f46070ULL, 0x000000001200720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x00cfec0000008000ULL, 0x0000f64804047891ULL, 0x000fe2000f8e203fULL,
0x00f6100037ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001023b7812ULL, 0x000fe200078ec0ffULL,
0xff317217ff3c7424ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e2000c101c48ULL,
0x000000353400720cULL, 0x000fe20003f06070ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000060f7faeULL, 0x0003e2000c901c48ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000008117faeULL, 0x0003e2000d101c48ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000f648483e7811ULL, 0x000fe200078e18ffULL, 0x000000000a157faeULL, 0x0005e8000d901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x000000ffff157224ULL, 0x004fc600078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x002fec0000008000ULL, 0x000020003eff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000b0a000000947ULL, 0x000fea0003800000ULL,
0xff317217ff3c7424ULL, 0x002fe200078e00ffULL, 0x00007610ff647816ULL, 0x000fe20000000064ULL,
0x000000ffff637224ULL, 0x000fe200078e00ffULL, 0x00007610ff657816ULL, 0x000fe20000000065ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x00007610ff3f7816ULL, 0x000fc4000000003fULL,
0xffffffc037257812ULL, 0x000fca00078ec0ffULL, 0x0000010034007824ULL, 0x000fca00078e0225ULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x0000afa000000947ULL, 0x002fea0003800000ULL,
0x000024003e257984ULL, 0x000e620000000800ULL, 0x0000ffff64007812ULL, 0x000fe200078ec0ffULL,
0x000000ffff407224ULL, 0x000fc600078e0063ULL, 0x0000888000247816ULL, 0x000fca00000000ffULL,
0x8000000024007824ULL, 0x000fca00078e00ffULL, 0x8000000025ff7812ULL, 0x002fe20007804800ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000761065627816ULL, 0x000fe40000000062ULL,
0x00007610648e7816ULL, 0x000fe2000000008eULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x000024003e257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000024257824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x004fe40003800000ULL, 0x000024003e247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000003ff2e7819ULL, 0x000fe20000011636ULL,
0x0000010034477824ULL, 0x000fe200078e00ffULL, 0x00000001ff487819ULL, 0x000fe20000011602ULL,
0x0000001036457824ULL, 0x000fe200078e00ffULL, 0x000000042e307810ULL, 0x040fe20007ffe0ffULL,
0x0000000139277824ULL, 0x000fe200078e022eULL, 0x000000082e327810ULL, 0x000fe20007ffe0ffULL,
0x0000002048007824ULL, 0x000fe200078e0247ULL, 0x0000000134247810ULL, 0x000fe20007ffe0ffULL,
0x00000008274a7824ULL, 0x040fe200078e00ffULL, 0x0000003627257212ULL, 0x000fe200078e3cffULL,
0x0000000139297824ULL, 0x000fe200078e0230ULL, 0x0000004000007810ULL, 0x000fe20007ffe0ffULL,
0x00000000480673c2ULL, 0x000e6200000e0000ULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee225ULL,
0x00000008292b7824ULL, 0x000fe200078e00ffULL, 0x0000000003257217ULL, 0x000fc40007800000ULL,
0x0000003629267212ULL, 0x080fe400078e3cffULL, 0x0000000c2e337810ULL, 0x000fe20007ffe0ffULL,
0x0000000125257824ULL, 0x000fe200078e0a00ULL, 0xfffffff82b2a7812ULL, 0x000fe200078ee226ULL,
0x0000100063267824ULL, 0x000fe200078e00ffULL, 0x000000352400720cULL, 0x000fe20003f06070ULL,
0x0000620038007a24ULL, 0x000fe400078e0200ULL, 0x00000001392b7824ULL, 0x000fe400078e0232ULL,
0x0000000127247824ULL, 0x000fe200078e0200ULL, 0x0000100026277812ULL, 0x000fe200078e0cffULL,
0x000000082b4c7824ULL, 0x040fe200078e00ffULL, 0x000000362b2d7212ULL, 0x000fe200078e3cffULL,
0x00000001392f7824ULL, 0x000fc400078e0233ULL, 0x0000200048277824ULL, 0x000fe200078e0227ULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee22dULL, 0x000000082f427824ULL, 0x040fe200078e00ffULL,
0x000000362f317212ULL, 0x040fe200078e3cffULL, 0x000000012f2c7824ULL, 0x100fe200078e0200ULL,
0x0000b00027277810ULL, 0x000fe20007ffe0ffULL, 0x00000008632d7824ULL, 0x000fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fe200078ee231ULL, 0x00000080ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000007045317812ULL, 0x000fe200078ec0ffULL, 0x0000000129287824ULL, 0x100fe200078e0200ULL,
0x000000082d497812ULL, 0x000fe200078e0cffULL, 0x000000012b297824ULL, 0x000fe200078e0200ULL,
0x0000002025007807ULL, 0x000fe20000000000ULL, 0x00005e0024247625ULL, 0x000fe200078e002fULL,
0x00000000490473c2ULL, 0x000ea200000e0000ULL, 0x0000f64806067891ULL, 0x002fe2000f8e203fULL,
0x0000000039007217ULL, 0x000fe20007800000ULL, 0x000000102a4b7824ULL, 0x100fe200078e0227ULL,
0x00000031242a7210ULL, 0x000fe20007f1e0ffULL, 0x000000104a4a7824ULL, 0x000fc400078e0227ULL,
0x0000000100007824ULL, 0x000fe400078e0a39ULL, 0x000000ffff2b7224ULL, 0x000fe400000e0625ULL,
0x00005e0028247625ULL, 0x000fe200078e002fULL, 0x000000002e00720cULL, 0x080fe40003f06070ULL,
0x000000003000720cULL, 0x080fe20003f26070ULL, 0x000000104c4c7824ULL, 0x100fe200078e0227ULL,
0x0000003124247210ULL, 0x000fe20007f7e0ffULL, 0x00000010424d7824ULL, 0x000fe200078e0227ULL,
0x000000003200720cULL, 0x000fe20003f46070ULL, 0x00005e0029267625ULL, 0x000fc800078e002fULL,
0x00005e002c287625ULL, 0x000fe200078e002fULL, 0x0000003126267210ULL, 0x080fe20007f9e0ffULL,
0x0000000406047290ULL, 0x004fe2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a4a7faeULL, 0x0003e2000c101c48ULL, 0x000000ffff257224ULL, 0x000fe200018e0625ULL,
0x000000003300720cULL, 0x000fe20003f66070ULL, 0x000000ffff277224ULL, 0x000fe200020e0627ULL,
0x0000003128287210ULL, 0x000fe20007fbe0ffULL, 0x0000000402427824ULL, 0x000fe200078e00ffULL,
0x00000000244b7faeULL, 0x0003e6000c901c48ULL, 0x000000ffff297224ULL, 0x000fe200028e0629ULL,
0x00000000264c7faeULL, 0x0003e2000d101c48ULL, 0xfffffff042427812ULL, 0x000fc800078ec0ffULL,
0x00000000284d7faeULL, 0x0003e8000d901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000004062d257984ULL, 0x0022a20008000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f60c0042277984ULL, 0x000ee20000000800ULL, 0x0000ffff65007812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3f247812ULL, 0x000fe400078ec0ffULL, 0x00008880002a7816ULL, 0x000fe400000000ffULL,
0x0000888024437816ULL, 0x000fc600000000ffULL, 0x800000002a007824ULL, 0x000fe400078e00ffULL,
0x8000000043247824ULL, 0x000fc600078e00ffULL, 0x8000000025ff7812ULL, 0x004fe40007804800ULL,
0x8000000027ff7812ULL, 0x008fe20007824824ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x8000000043257824ULL, 0x000fe400078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x00f60c0042247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000002002447824ULL, 0x000fe200078e00ffULL, 0x00000001ff467819ULL, 0x000fe20000011636ULL,
0x00000001ffcf7424ULL, 0x000fe200078e00ffULL, 0x0000007045457812ULL, 0x000fe400078ec0ffULL,
0xffffff8044447812ULL, 0x000fe400078ec0ffULL, 0x0000000c46467812ULL, 0x000fc800078ec0ffULL,
0x0000004446007210ULL, 0x000fca0007ffe045ULL, 0x00f0000000257984ULL, 0x000ea80000000800ULL,
0x00f2000000247984ULL, 0x0007220000000800ULL, 0x0000003c2500720bULL, 0x004fda0003f3d000ULL,
0x0000000000267806ULL, 0x000fc800008e0100ULL, 0x0000ffff262b7812ULL, 0x000fda000782c0ffULL,
0x0000038000009947ULL, 0x000fea0003800000ULL, 0x0000003c2500720bULL, 0x018fe40003f34000ULL,
0x000000253c2c7209ULL, 0x040fe40007810000ULL, 0x00000002ff277819ULL, 0x000fe40000011602ULL,
0x00000002ff287819ULL, 0x000fe20000011636ULL, 0x8000002c3c007221ULL, 0x100fe20000010000ULL,
0x000000ffff3c7224ULL, 0x000fe400078e002cULL, 0x0000000828297810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b00267820ULL, 0x000fc40000410000ULL, 0x0000000000007806ULL, 0x000fe400008e0100ULL,
0x000000022700720cULL, 0x000fe40003f25270ULL, 0x0000ffff00007812ULL, 0x000fe200078e3cffULL,
0x0000002600267308ULL, 0x000ea60000000800ULL, 0x000000002bff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ffcf7807ULL, 0x000fc60001000000ULL, 0x0000008002279824ULL, 0x000fc800078e0245ULL,
0x0000000146279824ULL, 0x000fe200078e0227ULL, 0x00001f2926297589ULL, 0x004ea200000e0000ULL,
0x8000002c25252221ULL, 0x000fe20000010000ULL, 0x000000263d3d7220ULL, 0x000fe40000410000ULL,
0x00001f2826287589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b25252820ULL, 0x000fc60000410000ULL,
0x00f4002c27009388ULL, 0x0009e20000000800ULL, 0x0000002500412308ULL, 0x000f620000000800ULL,
0x0000002923237220ULL, 0x084fe20000410000ULL, 0x0000002922227220ULL, 0x080fe20000410000ULL,
0x000000291f1f7220ULL, 0x080fe20000410000ULL, 0x000000291e1e7220ULL, 0x080fe20000410000ULL,
0x000000291b1b7220ULL, 0x080fe20000410000ULL, 0x000000291a1a7220ULL, 0x080fe20000410000ULL,
0x0000002917177220ULL, 0x080fe20000410000ULL, 0x0000002916167220ULL, 0x080fe20000410000ULL,
0x0000002913137220ULL, 0x080fe20000410000ULL, 0x0000002912127220ULL, 0x080fe20000410000ULL,
0x000000290f0f7220ULL, 0x080fe20000410000ULL, 0x000000290e0e7220ULL, 0x080fe20000410000ULL,
0x000000290b0b7220ULL, 0x080fe20000410000ULL, 0x000000290a0a7220ULL, 0x080fe20000410000ULL,
0x0000002907077220ULL, 0x080fe20000410000ULL, 0x0000002906067220ULL, 0x000fe20000410000ULL,
0x0000002821217220ULL, 0x088fe20000410000ULL, 0x0000002820207220ULL, 0x080fe20000410000ULL,
0x000000281d1d7220ULL, 0x080fe20000410000ULL, 0x000000281c1c7220ULL, 0x080fe20000410000ULL,
0x0000002819197220ULL, 0x080fe20000410000ULL, 0x0000002818187220ULL, 0x080fe20000410000ULL,
0x0000002815157220ULL, 0x080fe20000410000ULL, 0x0000002814147220ULL, 0x080fe20000410000ULL,
0x0000002811117220ULL, 0x080fe20000410000ULL, 0x0000002810107220ULL, 0x080fe20000410000ULL,
0x000000280d0d7220ULL, 0x080fe20000410000ULL, 0x000000280c0c7220ULL, 0x080fe20000410000ULL,
0x0000002809097220ULL, 0x080fe20000410000ULL, 0x0000002808087220ULL, 0x080fe20000410000ULL,
0x0000002805057220ULL, 0x080fe20000410000ULL, 0x0000002804047220ULL, 0x000fe20000410000ULL,
0x0000004124242220ULL, 0x020fc80000410000ULL, 0x0000003d243d7221ULL, 0x018fe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x000004062d007984ULL, 0x000ea20008000800ULL,
0x800000002a257824ULL, 0x000fca00078e00ffULL, 0x8000000000ff7812ULL, 0x004fe20007804825ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000002a257824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000004062d247984ULL, 0x000ea40008000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000402277824ULL, 0x000fe200078e00ffULL,
0x0000000836257812ULL, 0x000fe200078ec0ffULL, 0x0000100002007824ULL, 0x000fe200078e00ffULL,
0x0000000736d17812ULL, 0x000fe200078ec0ffULL, 0x0000000202d07824ULL, 0x040fe200078e00ffULL,
0x0000000427277812ULL, 0x000fe200078ec0ffULL, 0x0000020002df7824ULL, 0x000fe200078e00ffULL,
0xffffe00000247812ULL, 0x000fe400078ec0ffULL, 0x0000000725007812ULL, 0x000fe400078ec836ULL,
0x0000002736277211ULL, 0x000fe200078fe0ffULL, 0x0000100063267824ULL, 0x000fe200078e0224ULL,
0x0000000725257812ULL, 0x000fc400078ef836ULL, 0x0000002700247212ULL, 0x000fe400078e3cffULL,
0x0000b000262d7810ULL, 0x002fe20007ffe0ffULL, 0x0000100063267824ULL, 0x000fe200078e023aULL,
0x0000008025517811ULL, 0x040fe200078e18ffULL, 0x00000008254e7824ULL, 0x000fe200078e0224ULL,
0x0000000227277810ULL, 0x000fe40007ffe0ffULL, 0x0000b000262e7810ULL, 0x000fe20007ffe0ffULL,
0x000000104e287824ULL, 0x000fe200078e022dULL, 0x00000027002c7212ULL, 0x000fe200078e3cffULL,
0x00000001244f7824ULL, 0x000fe200078e0251ULL, 0x00000004d0dd7812ULL, 0x000fc400078ec0ffULL,
0x00009910cfde7816ULL, 0x000fe200000000ffULL, 0x000000002828783bULL, 0x000e620000004200ULL,
0x000000104f307824ULL, 0x000fe200078e022eULL, 0x000000dd36d07211ULL, 0x000fe200078fe0ffULL,
0x0000000825507824ULL, 0x000fe200078e022cULL, 0x00000008d1dd7812ULL, 0x000fe200078ef836ULL,
0x000000012c517824ULL, 0x000fe200078e0251ULL, 0x000000ffde00720cULL, 0x000fe20003f45270ULL,
0x000000003030783bULL, 0x000fe20000004200ULL, 0x0000001050247824ULL, 0x000fe200078e022dULL,
0x00000002d0e07810ULL, 0x040fe20007ffe0ffULL, 0x00000010512e7824ULL, 0x000fe200078e022eULL,
0x00000007d0de7812ULL, 0x000fc400078e78ddULL, 0x00000007e0e07812ULL, 0x000fe200078e78ddULL,
0x000000002424783bULL, 0x000ea20000004200ULL, 0xfffff800dfdf7812ULL, 0x000fe200078ec0ffULL,
0x00000008ddde7824ULL, 0x040fe400078e02deULL, 0x00000008dde07824ULL, 0x000fe200078e02e0ULL,
0x000000002e2c783bULL, 0x000ee20000004200ULL, 0x0000010028d37824ULL, 0x042fe200078e00ffULL,
0x00000029009f7306ULL, 0x000fe20000009400ULL, 0x0001000028d47824ULL, 0x000fe200078e00ffULL,
0x00000018ffbb7819ULL, 0x000fe20000011428ULL, 0x0000010029bf7824ULL, 0x040fe200078e00ffULL,
0x00000018ffd37819ULL, 0x000fe200000114d3ULL, 0x0001000029c57824ULL, 0x000fe200078e00ffULL,
0x00000018ffd47819ULL, 0x000fe200000114d4ULL, 0x000001002abd7824ULL, 0x040fe200078e00ffULL,
0x000000d300d97306ULL, 0x000fe20000209400ULL, 0x00000018ffbf7819ULL, 0x000fe200000114bfULL,
0x000001002bc07824ULL, 0x040fe200078e00ffULL, 0x00000018ffc57819ULL, 0x000fe200000114c5ULL,
0x000100002ac47824ULL, 0x000fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe20000011429ULL,
0x000100002bc37824ULL, 0x000fe200078e00ffULL, 0x00000018ffbd7819ULL, 0x000fe200000114bdULL,
0x000000d300da7306ULL, 0x000e620000205400ULL, 0x00000018ffc07819ULL, 0x000fe200000114c0ULL,
0x0000010024ce7824ULL, 0x004fe200078e00ffULL, 0x00000018ffc47819ULL, 0x000fe200000114c4ULL,
0x0000010025d17824ULL, 0x000fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe2000001142aULL,
0x00000100308a7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa97819ULL, 0x000fe2000001142bULL,
0x000000d400db7306ULL, 0x000fe20000209400ULL, 0x00000018ffc37819ULL, 0x000fe200000114c3ULL,
0x00000100318c7824ULL, 0x000fe200078e00ffULL, 0x00000018ffce7819ULL, 0x000fe200000114ceULL,
0x0000010032787824ULL, 0x000fe200078e00ffULL, 0x00000018ffd07819ULL, 0x000fe200000114d1ULL,
0x0001000030937824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fe20000011427ULL,
0x000000d400dc7306ULL, 0x000ea20000205400ULL, 0x000000dad900720bULL, 0x002fe20003f3d000ULL,
0x00010000318d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe20000011426ULL,
0x00010000326f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe20000011430ULL,
0x0000010033747824ULL, 0x040fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011431ULL,
0x000000bf00d77306ULL, 0x000fe20000209400ULL, 0x00000018ff8a7819ULL, 0x000fe2000001148aULL,
0x00010000336d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fc4000001148cULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff937819ULL, 0x000fe20000011493ULL,
0x000000bf00d87306ULL, 0x000e620000205400ULL, 0x000000dcdb00720bULL, 0x004fe40003f1d000ULL,
0x00000018ff8d7819ULL, 0x000fe4000001148dULL, 0x00000018ff677819ULL, 0x000fe40000011432ULL,
0x00000018ff6f7819ULL, 0x000fe2000001146fULL, 0x00000029009e7306ULL, 0x000ea20000005400ULL,
0x00000018ff5d7819ULL, 0x000fc40000011433ULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000018ff6d7819ULL, 0x000fc6000001146dULL, 0x0000002a00b57306ULL, 0x000fe20000009400ULL,
0x000000d8d700720bULL, 0x002fce0003fdd000ULL, 0x0000002a00b07306ULL, 0x000e620000005400ULL,
0x0000009e9f00720bULL, 0x004fe40003fbd000ULL, 0x000000d3009f7245ULL, 0x000fe4000020d400ULL,
0x000000d4009e7245ULL, 0x000fe4000020d400ULL, 0x000000019f9f1812ULL, 0x000fe200078efcffULL,
0x000000bb00c67306ULL, 0x000fe20000209400ULL, 0x000000019e9e0812ULL, 0x000fce00078efcffULL,
0x000000bb00c77306ULL, 0x0005220000205400ULL, 0x000000b0b500720bULL, 0x002fe40003f3d000ULL,
0x000000bf00b07245ULL, 0x000fe2000020d400ULL, 0x0000010027bf7824ULL, 0x000fc600078e00ffULL,
0x00000001b0b06812ULL, 0x000fe200078efcffULL, 0x000000c500d57306ULL, 0x000fe20000209400ULL,
0x000000bb00bb7245ULL, 0x004fe4000020d400ULL, 0x00000018ffbf7819ULL, 0x000fca00000114bfULL,
0x000000c500d67306ULL, 0x0002a20000205400ULL, 0x000000c7c600720bULL, 0x010fce0003f9d000ULL,
0x0000002800537306ULL, 0x000fe20000009400ULL, 0x000000c500c57245ULL, 0x002fca000020d400ULL,
0x00000001bbbb4812ULL, 0x000fe400078efcffULL, 0x0000002800527306ULL, 0x000e620000005400ULL,
0x000000d6d500720bULL, 0x004fce0003f1d000ULL, 0x000000b800ba7306ULL, 0x000fec0000209400ULL,
0x00000001c5c50812ULL, 0x000fe400078efcffULL, 0x000000b800b97306ULL, 0x0005220000205400ULL,
0x000000525300720bULL, 0x002fe20003f7d000ULL, 0x00000010de527824ULL, 0x000fc400078e02dfULL,
0x00000010e0537824ULL, 0x000fc800078e02dfULL, 0x00000029007f7306ULL, 0x000e62000000d400ULL,
0x000000b800b87245ULL, 0x004fce000020d400ULL, 0x000000bd00c17306ULL, 0x000fe20000209400ULL,
0x000000b9ba00720bULL, 0x010fe20003fdd000ULL, 0x0001000026ba7824ULL, 0x000fca00078e00ffULL,
0x00000018ffba7819ULL, 0x000fe200000114baULL, 0x000000bd00c27306ULL, 0x000ea20000205400ULL,
0x000000017f7f5812ULL, 0x002fca00078efcffULL, 0x00000001b8b86812ULL, 0x000fe400078efcffULL,
0x0000003000ac7306ULL, 0x000ff00000009400ULL, 0x0000003000ad7306ULL, 0x000e620000005400ULL,
0x000000c2c100720bULL, 0x004fe20003fbd000ULL, 0x0001000027c17824ULL, 0x000fca00078e00ffULL,
0x00000018ffc17819ULL, 0x000fe200000114c1ULL, 0x000000c000c97306ULL, 0x000ff00000209400ULL,
0x000000c000cc7306ULL, 0x000ea20000205400ULL, 0x000000adac00720bULL, 0x002fe20003f9d000ULL,
0x0000010026ad7824ULL, 0x000fe200078e00ffULL, 0x000000bd00ac7245ULL, 0x000fc8000020d400ULL,
0x00000001acac5812ULL, 0x000fe200078efcffULL, 0x0000002800847306ULL, 0x000330000000d400ULL,
0x0000002b00b47306ULL, 0x000fe20000009400ULL, 0x000000ccc900720bULL, 0x004fc40003f1d000ULL,
0x00000018ff287819ULL, 0x002fca0000011425ULL, 0x0000002b00b17306ULL, 0x000e620000005400ULL,
0x0000000184843812ULL, 0x010fc800078efcffULL, 0x000000849f84723eULL, 0x000fc600000010ffULL,
0x000000c400c87306ULL, 0x000ff00000209400ULL, 0x000000c400cb7306ULL, 0x0005220000205400ULL,
0x000000b1b400720bULL, 0x002fe20003f7d000ULL, 0x0001000025b17824ULL, 0x000fca00078e00ffULL,
0x00000018ffb47819ULL, 0x000fe200000114b1ULL, 0x000000ae00b27306ULL, 0x000fe20000209400ULL,
0x000000c400c47245ULL, 0x004fe4000020d400ULL, 0x000000ae00b17245ULL, 0x000fca000020d400ULL,
0x000000ae00b77306ULL, 0x000e620000205400ULL, 0x000000cbc800720bULL, 0x010fce0003fdd000ULL,
0x0000002a00777306ULL, 0x00052c000000d400ULL, 0x00000001c4c46812ULL, 0x000fe400078efcffULL,
0x000000a900b67306ULL, 0x000fe20000209400ULL, 0x00000018ff2a7819ULL, 0x004fe40000011424ULL,
0x000000b7b200720bULL, 0x002fca0003fbd000ULL, 0x000000a900b37306ULL, 0x000e620000205400ULL,
0x0000000177771812ULL, 0x010fce00078efcffULL, 0x0000002400aa7306ULL, 0x000fe20000009400ULL,
0x00000001b1b15812ULL, 0x000fc800078efcffULL, 0x000000c4b1c2723eULL, 0x000fc600000010ffULL,
0x0000002400af7306ULL, 0x000ea20000005400ULL, 0x000000b3b600720bULL, 0x002fe20003f3d000ULL,
0x000100002db67824ULL, 0x008fca00078e00ffULL, 0x00000018ffb67819ULL, 0x000fe200000114b6ULL,
0x0000002400607306ULL, 0x0002f0000000d400ULL, 0x000000c300ca7306ULL, 0x000fe20000209400ULL,
0x0001000024247824ULL, 0x002fe200078e00ffULL, 0x000000afaa00720bULL, 0x004fc40003fdd000ULL,
0x000000a900aa7245ULL, 0x000fe4000020d400ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x000000c300cd7306ULL, 0x0003e20000205400ULL, 0x00000001aaaa1812ULL, 0x000fe400078efcffULL,
0x000000ce00a97245ULL, 0x000fe4000020d400ULL, 0x0000002a00af7245ULL, 0x000fe4000020d400ULL,
0x0000000160606812ULL, 0x008fe200078efcffULL, 0x0000002b00767306ULL, 0x000ea2000000d400ULL,
0x000000c300c37245ULL, 0x002fce000020d400ULL, 0x000000ce00cf7306ULL, 0x000ff00000209400ULL,
0x000000ce00d27306ULL, 0x000e620000205400ULL, 0x0000000176763812ULL, 0x004fce00078efcffULL,
0x000000d000d17306ULL, 0x000ff00000209400ULL, 0x000000d000da7306ULL, 0x000ea20000205400ULL,
0x000000d2cf00720bULL, 0x002fce0003f7d000ULL, 0x0000002500a87306ULL, 0x000fec0000009400ULL,
0x00000001a9a93812ULL, 0x000fe400078efcffULL, 0x0000002500ab7306ULL, 0x000fe20000005400ULL,
0x000000dad100720bULL, 0x004fce0003fbd000ULL, 0x0000002500667306ULL, 0x000ff0000000d400ULL,
0x0000002700a27306ULL, 0x000ff00000009400ULL, 0x0000002700a37306ULL, 0x000ff00000005400ULL,
0x00000027005c7306ULL, 0x0003f0000000d400ULL, 0x0000002400c67306ULL, 0x000fe20000209400ULL,
0x00000018ff277819ULL, 0x002fc400000114adULL, 0x000000c000ad7245ULL, 0x000fc8000020d400ULL,
0x00000001adad0812ULL, 0x000fe200078efcffULL, 0x0000002400257306ULL, 0x000e620000205400ULL,
0x000000cdca00720bULL, 0x000fce0003f1d000ULL, 0x0000002600a77306ULL, 0x000fec0000009400ULL,
0x00000001c3c30812ULL, 0x000fe400078efcffULL, 0x0000002600a67306ULL, 0x000ea20000005400ULL,
0x00000025c600720bULL, 0x002fe40003f3d000ULL, 0x000000aba800720bULL, 0x000fc40003f1d000ULL,
0x000000d000ab7245ULL, 0x000fe4000020d400ULL, 0x000000c3aac3723eULL, 0x000fe200000010ffULL,
0x0000002a00be7306ULL, 0x000fe20000209400ULL, 0x00000001abab5812ULL, 0x000fe400078efcffULL,
0x00000060a9aa723eULL, 0x000fca00000010ffULL, 0x0000002a002b7306ULL, 0x000e620000205400ULL,
0x000000a6a700720bULL, 0x004fe40003fdd000ULL, 0x0000002400a67245ULL, 0x000fe4000020d400ULL,
0x0000000166660812ULL, 0x000fe400078efcffULL, 0x00000001a6a61812ULL, 0x000fe200078efcffULL,
0x00000026005e7306ULL, 0x000ea2000000d400ULL, 0x000000b400a77245ULL, 0x000fe4000020d400ULL,
0x00000066abab723eULL, 0x000fca00000010ffULL, 0x000000b400b57306ULL, 0x000fe20000209400ULL,
0x0000002bbe00720bULL, 0x002fce0003f7d000ULL, 0x000000b400267306ULL, 0x0002e20000205400ULL,
0x000000015e5e6812ULL, 0x004fca00078efcffULL, 0x00000001afaf3812ULL, 0x000fe400078efcffULL,
0x0000002700b97306ULL, 0x000fe20000209400ULL, 0x00000002ffb47819ULL, 0x002fe40000011636ULL,
0x000000a6afa6723eULL, 0x000fca00000010ffULL, 0x0000002700b27306ULL, 0x000e620000205400ULL,
0x00000026b500720bULL, 0x008fe40003fbd000ULL, 0x0000009100b57245ULL, 0x000fca000020d400ULL,
0x0000002800bc7306ULL, 0x000fec0000209400ULL, 0x00000001a7a75812ULL, 0x000fe400078efcffULL,
0x0000002800297306ULL, 0x000ea20000205400ULL, 0x000000b2b900720bULL, 0x002fe20003f3d000ULL,
0x000001002cb27824ULL, 0x000fc400078e00ffULL, 0x000001002eb97824ULL, 0x000fc800078e00ffULL,
0x0000003100a57306ULL, 0x000fe20000009400ULL, 0x00000018ffb97819ULL, 0x000fce00000114b9ULL,
0x0000003100a47306ULL, 0x000e620000005400ULL, 0x00000029bc00720bULL, 0x004fce0003f1d000ULL,
0x000000bf00ae7306ULL, 0x000ff00000209400ULL, 0x000000bf00b37306ULL, 0x000ea20000205400ULL,
0x000000a4a500720bULL, 0x002fe40003f7d000ULL, 0x0000002700a57245ULL, 0x000fc4000020d400ULL,
0x0000002800a47245ULL, 0x000fe4000020d400ULL, 0x00000001a5a51812ULL, 0x000fe200078efcffULL,
0x000000ba00257306ULL, 0x000fe20000209400ULL, 0x000000a3a200720bULL, 0x000fe20003f3d000ULL,
0x009000005228783bULL, 0x000fe20000000200ULL, 0x00000001a4a40812ULL, 0x000fe400078efcffULL,
0x000000ba00a27245ULL, 0x000fe4000020d400ULL, 0x000000a7a4a7723eULL, 0x000fe200000010ffULL,
0x000000ba00247306ULL, 0x0002e20000205400ULL, 0x000000b3ae00720bULL, 0x004fc40003fbd000ULL,
0x0000009000b37245ULL, 0x000fc6000020d400ULL, 0x000000015c5c1812ULL, 0x000fe400078efcffULL,
0x0000003200a17306ULL, 0x000fe20000009400ULL, 0x000001002fba7824ULL, 0x002fca00078e00ffULL,
0x00000018ffba7819ULL, 0x000fe400000114baULL, 0x0000003200a07306ULL, 0x000e620000005400ULL,
0x000000242500720bULL, 0x008fe40003fdd000ULL, 0x009000005324783bULL, 0x000fea0000000200ULL,
0x00000090009d7306ULL, 0x000fec0000209400ULL, 0x00000001a2a26812ULL, 0x000fc400078efcffULL,
0x00000090009c7306ULL, 0x000ea20000205400ULL, 0x000000a0a100720bULL, 0x002fe40003f1d000ULL,
0x000000bf00a17245ULL, 0x000fe4000020d400ULL, 0x00000018ffa07819ULL, 0x000fe4000001142eULL,
0x00000001a1a15812ULL, 0x000fe200078efcffULL, 0x0000003300897306ULL, 0x000ff00000009400ULL,
0x0000003300547306ULL, 0x000e620000005400ULL, 0x0000009c9d00720bULL, 0x004fc40003fbd000ULL,
0x00000041ff9d723eULL, 0x000fc800000010ffULL, 0x000054109d9d7816ULL, 0x000fe2000000009dULL,
0x000000c100a87306ULL, 0x000fe80000209400ULL, 0x00001fb49db77589ULL, 0x0004e400000e0000ULL,
0x00000001b3b35812ULL, 0x000fe400078efcffULL, 0x000000548900720bULL, 0x002fe20003f3d000ULL,
0x000000c100a37306ULL, 0x000e620000205400ULL, 0x00000008b4547810ULL, 0x000fe20007ffe0ffULL,
0x000001002db47824ULL, 0x004fc800078e00ffULL, 0x00001f549dae7589ULL, 0x00052400000e0000ULL,
0x0000007d00807306ULL, 0x000ff00000209400ULL, 0x0000007d00857306ULL, 0x000f620000205400ULL,
0x000000a3a800720bULL, 0x002fe20003fbd000ULL, 0x000100002f9d7824ULL, 0x004fe200078e00ffULL,
0x000000b72828a231ULL, 0x088fe200003400ffULL, 0x000000c100a87245ULL, 0x000fe2000020d400ULL,
0x000000b72a2aa231ULL, 0x080fe200003400ffULL, 0x000100002ea37824ULL, 0x000fe200078e00ffULL,
0x000000b72424a231ULL, 0x080fe200003400ffULL, 0x00000091008f7306ULL, 0x000fe20000209400ULL,
0x000000b72626a231ULL, 0x000fe200003400ffULL, 0x00000018ff9d7819ULL, 0x000fc4000001149dULL,
0x00000018ffa37819ULL, 0x000fe200000114a3ULL, 0x000000ae2929a231ULL, 0x090fe200003400ffULL,
0x00000001a8a85812ULL, 0x000fe400078efcffULL, 0x0000009100887306ULL, 0x0002a20000205400ULL,
0x000000ae2b2ba231ULL, 0x080fe400003400ffULL, 0x000000ae2525a231ULL, 0x080fe400003400ffULL,
0x000000ae2727a231ULL, 0x000fe200003400ffULL, 0x000000858000720bULL, 0x020fc40003f5d000ULL,
0x00000030005b7306ULL, 0x000722000000d400ULL, 0x0000008c00917245ULL, 0x002fe2000020d400ULL,
0x000000c22810723cULL, 0x040fe20000041810ULL, 0x00000018ff807819ULL, 0x000fe400000114b4ULL,
0x0000007fb085723eULL, 0x000fe400000010ffULL, 0x000000a2b3b4723eULL, 0x000fe200000010ffULL,
0x0000007500827306ULL, 0x000fe20000209400ULL, 0x000000888f00720bULL, 0x004fe20003fdd000ULL,
0x000000aa2814723cULL, 0x000fe20000041814ULL, 0x00000018ff887819ULL, 0x000fc4000001142fULL,
0x00000018ff307819ULL, 0x008fc6000001142cULL, 0x0000007500837306ULL, 0x000e620000205400ULL,
0x000000015b5b4812ULL, 0x010fe200078efcffULL, 0x000000842804723cULL, 0x040fe80000041804ULL,
0x00000001b5b56812ULL, 0x000fe400078efcffULL, 0x0000008a008b7306ULL, 0x000fe40000209400ULL,
0x000000a8b5b5723eULL, 0x000fe200000010ffULL, 0x000000a62818723cULL, 0x000fea0000041818ULL,
0x0000008a00947306ULL, 0x0004e20000205400ULL, 0x000000838200720bULL, 0x002fc40003f9d000ULL,
0x0000007d00827245ULL, 0x000fe2000020d400ULL, 0x000000b42820723cULL, 0x000fe20000041820ULL,
0x0000008d00837245ULL, 0x000fe4000020d400ULL, 0x0000000182822812ULL, 0x000fe200078efcffULL,
0x0000008c00927306ULL, 0x000fe20000209400ULL, 0x0000008a008a7245ULL, 0x004fce000020d400ULL,
0x0000008c00977306ULL, 0x000e620000205400ULL, 0x000000948b00720bULL, 0x008fe40003fbd000ULL,
0x00000018ff8b7819ULL, 0x000fca00000114b2ULL, 0x0000007800957306ULL, 0x000fec0000209400ULL,
0x000000018a8a5812ULL, 0x000fe400078efcffULL, 0x0000007800967306ULL, 0x000ea20000205400ULL,
0x000000979200720bULL, 0x002fe40003fdd000ULL, 0x0000005b8a8a723eULL, 0x000fca00000010ffULL,
0x0000003100007306ULL, 0x0002ec000000d400ULL, 0x0000000191916812ULL, 0x000fe400078efcffULL,
0x0000009300987306ULL, 0x000fe20000209400ULL, 0x000000969500720bULL, 0x004fe40003f5d000ULL,
0x00000018ff317819ULL, 0x002fca000001142dULL, 0x0000009300997306ULL, 0x0002a20000205400ULL,
0x0000000100003812ULL, 0x008fce00078efcffULL, 0x0000008d009a7306ULL, 0x000fe20000209400ULL,
0x0000009300937245ULL, 0x002fce000020d400ULL, 0x0000008d009b7306ULL, 0x000e620000205400ULL,
0x000000999800720bULL, 0x004fce0003fbd000ULL, 0x0000006700877306ULL, 0x000fec0000209400ULL,
0x0000000193935812ULL, 0x000fe400078efcffULL, 0x0000006700867306ULL, 0x000ea20000205400ULL,
0x0000009b9a00720bULL, 0x002fe40003f7d000ULL, 0x000000938282723eULL, 0x000fca00000010ffULL,
0x0000006f00797306ULL, 0x000fec0000209400ULL, 0x0000000183833812ULL, 0x000fe400078efcffULL,
0x0000006f007a7306ULL, 0x0002e20000205400ULL, 0x000000868700720bULL, 0x004fce0003fdd000ULL,
0x0000002f00617306ULL, 0x000fe20000009400ULL, 0x0000006f006f7245ULL, 0x002fce000020d400ULL,
0x0000002f006a7306ULL, 0x000ff00000005400ULL, 0x0000002f00557306ULL, 0x0003f0000000d400ULL,
0x0000005d007e7306ULL, 0x000fe20000209400ULL, 0x00000076ad2f723eULL, 0x002fc400000010ffULL,
0x0000007500767245ULL, 0x000fe4000020d400ULL, 0x0000007800757245ULL, 0x000fe4000020d400ULL,
0x0000000176764812ULL, 0x000fe200078efcffULL, 0x0000005d007b7306ULL, 0x000e620000205400ULL,
0x0000000175752812ULL, 0x000fe400078efcffULL, 0x0000007a7900720bULL, 0x008fe40003f5d000ULL,
0x000000837683723eULL, 0x000fc600000010ffULL, 0x0000002c00727306ULL, 0x000ff00000009400ULL,
0x0000002c00717306ULL, 0x000ea20000005400ULL, 0x0000007b7e00720bULL, 0x002fe40003fbd000ULL,
0x000000016f6f2812ULL, 0x000fca00078efcffULL, 0x00000074007c7306ULL, 0x000ff00000209400ULL,
0x0000007400817306ULL, 0x000e620000205400ULL, 0x000000717200720bULL, 0x004fce0003f9d000ULL,
0x00000032005a7306ULL, 0x000eb0000000d400ULL, 0x0000002d00697306ULL, 0x000fe20000009400ULL,
0x000000817c00720bULL, 0x002fce0003f7d000ULL, 0x0000002d006c7306ULL, 0x000e620000005400ULL,
0x000000015a5a0812ULL, 0x004fc800078efcffULL, 0x0000005a755a723eULL, 0x000fc600000010ffULL,
0x0000006d00737306ULL, 0x000ff00000209400ULL, 0x0000006d00707306ULL, 0x0004e20000205400ULL,
0x0000006c6900720bULL, 0x002fce0003f1d000ULL, 0x0000008b00927306ULL, 0x000fe20000209400ULL,
0x0000006d006d7245ULL, 0x004fce000020d400ULL, 0x0000008b00977306ULL, 0x000fe20000205400ULL,
0x000000707300720bULL, 0x008fce0003f5d000ULL, 0x0000002c00597306ULL, 0x0002ac000000d400ULL,
0x000000016d6d2812ULL, 0x000fe400078efcffULL, 0x0000002e006e7306ULL, 0x000fe20000009400ULL,
0x000100002c2c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001142cULL,
0x0000002e006b7306ULL, 0x000fe20000005400ULL, 0x0000009ebb2c723eULL, 0x000fe400000010ffULL,
0x0000000159594812ULL, 0x004fca00078efcffULL, 0x0000002e00567306ULL, 0x0003f0000000d400ULL,
0x0000002d00577306ULL, 0x0005e2000000d400ULL, 0x00000077ac2e723eULL, 0x002fce00000010ffULL,
0x0000003300587306ULL, 0x000e62000000d400ULL, 0x000000c5b82d723eULL, 0x004fe200000010ffULL,
0x0000002e280c723cULL, 0x040fec000004180cULL, 0x00000030005f7306ULL, 0x000fe20000209400ULL,
0x00000067002e7245ULL, 0x000fe2000020d400ULL, 0x0000002c2808723cULL, 0x000fe20000041808ULL,
0x00000074002f7245ULL, 0x000fc4000020d400ULL, 0x000000012e2e6812ULL, 0x000fe400078efcffULL,
0x000000979200720bULL, 0x000fe20003fdd000ULL, 0x0000003000687306ULL, 0x000ea20000205400ULL,
0x0000005ea52c723eULL, 0x000fe400000010ffULL, 0x0000005ca12d723eULL, 0x000fe400000010ffULL,
0x0000005d005c7245ULL, 0x000fe4000020d400ULL, 0x0000000158581812ULL, 0x002fe200078efcffULL,
0x0000003100327306ULL, 0x000fe20000209400ULL, 0x0000006a6100720bULL, 0x000fe20003f3d000ULL,
0x0000002c281c723cULL, 0x000fe2000004181cULL, 0x000000012f2f3812ULL, 0x000fc400078efcffULL,
0x000000015c5c5812ULL, 0x000fe400078efcffULL, 0x0000000157570812ULL, 0x000fe200078efcffULL,
0x0000003100337306ULL, 0x0002e20000205400ULL, 0x0000008b002c7245ULL, 0x000fe2000020d400ULL,
0x000000822408723cULL, 0x040fe20000041808ULL, 0x00000000918b723eULL, 0x000fe400000010ffULL,
0x000000012c2c6812ULL, 0x000fe400078efcffULL, 0x0000006b6e00720bULL, 0x000fe20003f7d000ULL,
0x00000080008c7306ULL, 0x000fe20000209400ULL, 0x000000685f00720bULL, 0x004fe20003f5d000ULL,
0x0000008a2404723cULL, 0x000fe20000041804ULL, 0x0000003000307245ULL, 0x000fc4000020d400ULL,
0x0000003100317245ULL, 0x002fe4000020d400ULL, 0x0000009d00a17245ULL, 0x000fe2000020d400ULL,
0x0000008000877306ULL, 0x0002a20000205400ULL, 0x000000333200720bULL, 0x008fe40003fbd000ULL,
0x0000000155551812ULL, 0x000fe400078efcffULL, 0x0000000156563812ULL, 0x000fe400078efcffULL,
0x0000000130302812ULL, 0x000fe200078efcffULL, 0x0000007d007b7306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fc4000020d400ULL, 0x000000582f5b723eULL, 0x000fe200000010ffULL,
0x0000010034587824ULL, 0x000fe200078e00ffULL, 0x0000006f2e2e723eULL, 0x000fe400000010ffULL,
0x0000000131315812ULL, 0x000fe200078efcffULL, 0x0000007d007c7306ULL, 0x0002e20000205400ULL,
0x000000878c00720bULL, 0x004fe20003fdd000ULL, 0x0000005a240c723cULL, 0x000fe2000004180cULL,
0x0000006d5c2f723eULL, 0x000fe400000010ffULL, 0x000000592c2c723eULL, 0x000fc600000010ffULL,
0x000000b600717306ULL, 0x000fe20000209400ULL, 0x0000007d007d7245ULL, 0x002fe2000020d400ULL,
0x0000002e2410723cULL, 0x000fe80000041810ULL, 0x0000000180806812ULL, 0x000fe400078efcffULL,
0x000000b600727306ULL, 0x0002a20000205400ULL, 0x0000007c7b00720bULL, 0x008fce0003f9d000ULL,
0x000000a0009c7306ULL, 0x000fe20000209400ULL, 0x000000b600b67245ULL, 0x002fca000020d400ULL,
0x000000017d7d4812ULL, 0x000fe400078efcffULL, 0x000000a000897306ULL, 0x0002e20000205400ULL,
0x000000727100720bULL, 0x004fe40003f1d000ULL, 0x0000007d3030723eULL, 0x000fca00000010ffULL,
0x00000088008f7306ULL, 0x000fe20000209400ULL, 0x000000a000a07245ULL, 0x002fca000020d400ULL,
0x00000001b6b60812ULL, 0x000fe400078efcffULL, 0x0000008800907306ULL, 0x0002a20000205400ULL,
0x000000899c00720bULL, 0x008fe40003fdd000ULL, 0x000000b63131723eULL, 0x000fca00000010ffULL,
0x000000b900607306ULL, 0x000fe20000209400ULL, 0x0000008800887245ULL, 0x002fe2000020d400ULL,
0x000000302418723cULL, 0x000fe80000041818ULL, 0x00000001a0a06812ULL, 0x000fe400078efcffULL,
0x000000b900617306ULL, 0x0002e20000205400ULL, 0x000000908f00720bULL, 0x004fce0003f9d000ULL,
0x000000ba005e7306ULL, 0x000fe20000209400ULL, 0x000000b900b97245ULL, 0x002fca000020d400ULL,
0x0000000188884812ULL, 0x000fe400078efcffULL, 0x000000ba005d7306ULL, 0x0002a20000205400ULL,
0x000000616000720bULL, 0x008fce0003f5d000ULL, 0x000000a3002d7306ULL, 0x000fe20000209400ULL,
0x000000ba00ba7245ULL, 0x002fca000020d400ULL, 0x00000001b9b92812ULL, 0x000fe400078efcffULL,
0x000000a300007306ULL, 0x0002e20000205400ULL, 0x0000005d5e00720bULL, 0x004fe40003f1d000ULL,
0x00000056b956723eULL, 0x000fca00000010ffULL, 0x0000009d00287306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fca000020d400ULL, 0x00000001baba0812ULL, 0x000fe400078efcffULL,
0x0000009d00297306ULL, 0x000e620000205400ULL, 0x000000002d00720bULL, 0x008fe40003fbd000ULL,
0x00000057802d723eULL, 0x000fe400000010ffULL, 0x00000055ba57723eULL, 0x000fca00000010ffULL,
0x0000002c2414723cULL, 0x040fe80000041814ULL, 0x00000001a3a35812ULL, 0x000fe400078efcffULL,
0x000000292800720bULL, 0x002fe40003f7d000ULL, 0x000000a3a0a0723eULL, 0x000fe200000010ffULL,
0x00000056241c723cULL, 0x000fe2000004181cULL, 0x00000002ff297819ULL, 0x000fc80000011602ULL,
0x0000f61029007811ULL, 0x000fca00078e20ffULL, 0x00000001a1a13812ULL, 0x000fc800078efcffULL,
0x000000a188a1723eULL, 0x000fce00000010ffULL, 0x000000a02420723cULL, 0x000fe20000041820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020003eff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004029247824ULL, 0x000fe200078e0258ULL, 0x000000ff65ff7812ULL, 0x000fe2000782c0ffULL,
0x0000000000ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff64ff7812ULL, 0x000fe4000784c0ffULL,
0x0000004024247810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff2d7807ULL, 0x000fe40000800000ULL,
0x000000032400720cULL, 0x000fc40003f26070ULL, 0x000000016300780cULL, 0x040fe40003f05270ULL,
0x00000001ff597807ULL, 0x000fe40001000000ULL, 0x0000000163637812ULL, 0x000fe400078e0cffULL,
0x000000652d657207ULL, 0x000fe40004000000ULL, 0x0000761059647816ULL, 0x000fc60000000064ULL,
0x000080d000001947ULL, 0x000fea0003800000ULL, 0x000024003e257984ULL, 0x004ea20000000800ULL,
0x8000000059007824ULL, 0x000fca00078e00ffULL, 0x8000000025ff7812ULL, 0x004fe20007824800ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x000024003e257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x004fe40007824800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x8000000059257824ULL, 0x000fe400078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000024003e247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000134007810ULL, 0x000fe20007ffe0ffULL,
0x0000000840617824ULL, 0x000fe200078e00ffULL, 0x0000003936257211ULL, 0x000fe200078fe8ffULL,
0x00000080ff557424ULL, 0x000fe200078e00ffULL, 0x000000350000720cULL, 0x000fe20003f26070ULL,
0x0000100040607824ULL, 0x000fe200078e00ffULL, 0x0000000436007811ULL, 0x000fe200078fe8ffULL,
0x00000008255b7824ULL, 0x040fe200078e00ffULL, 0x00000001ff487819ULL, 0x000fe40000011602ULL,
0x0000003625247212ULL, 0x000fe200078e3cffULL, 0x0000000139257824ULL, 0x000fe200078e0200ULL,
0x0000000861267812ULL, 0x000fe200078ec0ffULL, 0x0000002048277824ULL, 0x000fe200078e0247ULL,
0xfffffff85b5b7812ULL, 0x000fc400078ee224ULL, 0x0000003625007212ULL, 0x040fe200078e3cffULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0x0000008027277810ULL, 0x000fe20007ffe0ffULL,
0x00000000260773c2ULL, 0x0004e200000e0000ULL, 0x00000003ff2f7819ULL, 0x000fe40000011636ULL,
0xfffffff8255c7812ULL, 0x000fe200078ee200ULL, 0x00006200382c7a24ULL, 0x000fe200078e0227ULL,
0x0000000836007811ULL, 0x040fe400078fe8ffULL, 0x0000000c36247811ULL, 0x000fc400078fe8ffULL,
0x0000002703267217ULL, 0x004fe20007800000ULL, 0x0000000139257824ULL, 0x000fe200078e0200ULL,
0x000000042f337810ULL, 0x000fe40007ffe0ffULL, 0x0000f648482b7811ULL, 0x000fe200078e20ffULL,
0x0000000126297824ULL, 0x000fe200078e0a27ULL, 0x00000008615a7812ULL, 0x000fe200078e0cffULL,
0x0000000139277824ULL, 0x000fe200078e0224ULL, 0x0000002f2c247210ULL, 0x140fe20007ffe039ULL,
0x00000008255d7824ULL, 0x000fe200078e00ffULL, 0x000000332c267210ULL, 0x000fe20007ffe039ULL,
0x000000012b5a7824ULL, 0x000fe200078e025aULL, 0x0000003625287212ULL, 0x080fe200078e3cffULL,
0x000000002b0573c2ULL, 0x0004e200000e0000ULL, 0x00005e0024247625ULL, 0x000fe200078e0055ULL,
0x0000003627007212ULL, 0x000fc400078e3cffULL, 0xfffffff85d5d7812ULL, 0x000fe400078ee228ULL,
0x00000020292e7807ULL, 0x000fe20000800000ULL, 0x00000008272b7824ULL, 0x004fe200078e00ffULL,
0x0000004524287210ULL, 0x000fe20007f3e0ffULL, 0x00005e0026267625ULL, 0x000fe200078e0055ULL,
0x0000002e392e7217ULL, 0x000fe40007800000ULL, 0xfffffff82b007812ULL, 0x000fe200078ee200ULL,
0x000000ffff297224ULL, 0x000fe200008e0625ULL, 0x00000045262a7210ULL, 0x000fe20007f5e0ffULL,
0x000000012e2e7824ULL, 0x000fe200078e0a39ULL, 0x0000100060257812ULL, 0x000fc400078ec0ffULL,
0x0000000c2f317810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff2b7224ULL, 0x000fe200010e0627ULL,
0x000000082f277810ULL, 0x000fe20007ffe0ffULL, 0x0000200048257824ULL, 0x000fe200078e0225ULL,
0x000000312c267210ULL, 0x140fe20007ffe039ULL, 0x0000000705057290ULL, 0x008fe2000fffe03fULL,
0x000000272c247210ULL, 0x000fe40007ffe039ULL, 0x0000b000255e7810ULL, 0x000fe40007ffe0ffULL,
0x0000002e2f00720cULL, 0x080fe20003f26070ULL, 0x00005e0024247625ULL, 0x000fe200078e0055ULL,
0x0000002e2700720cULL, 0x000fc40003f66070ULL, 0x0000002e3300720cULL, 0x080fe20003f46070ULL,
0x00005e0026267625ULL, 0x000fe200078e0055ULL, 0x0000002e3100720cULL, 0x000fe40003f86070ULL,
0x0000004524247210ULL, 0x080fe20007fbe0ffULL, 0x000000105b5b7824ULL, 0x100fe200078e025eULL,
0x0000004526267210ULL, 0x000fe20007fde0ffULL, 0x000000105c5c7824ULL, 0x100fe400078e025eULL,
0x000000105d5d7824ULL, 0x000fe200078e025eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000285b7faeULL, 0x0005e2000c901c48ULL, 0x000000ffff257224ULL, 0x000fc400028e0625ULL,
0x00000010005e7824ULL, 0x000fe200078e025eULL, 0x000000002a5c7faeULL, 0x0005e2000d101c48ULL,
0x000000ffff277224ULL, 0x000fc600030e0627ULL, 0x00000000245d7faeULL, 0x0005e8000d901c48ULL,
0x00000000265e7faeULL, 0x0005e8000e101c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000004005a257984ULL, 0x0044e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f61c0042247984ULL, 0x000f220000000800ULL, 0x000000622d627207ULL, 0x000fe20004000000ULL,
0x8000000043277824ULL, 0x000fc600078e00ffULL, 0x0000ffff62007812ULL, 0x000fc800078ec0ffULL,
0x0000888000287816ULL, 0x000fca00000000ffULL, 0x8000000028007824ULL, 0x000fca00078e00ffULL,
0x8000000025ff7812ULL, 0x008fe40007804800ULL, 0x8000000024ff7812ULL, 0x010fe20007824827ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000b000001947ULL, 0x000fea0003800000ULL,
0x0000000402427824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x8000000043257824ULL, 0x000fe200078e00ffULL, 0xfffffff042427812ULL, 0x000fe400078ec0ffULL,
0x0000000000247305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000240000735dULL, 0x010fe40003800000ULL, 0x00f61c0042247984ULL, 0x000ee40000000800ULL,
0x8000000024ff7812ULL, 0x008fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000008045257810ULL, 0x000fe20007ffe044ULL,
0x00000001ffa47424ULL, 0x000fc800078e00ffULL, 0x0000000146257824ULL, 0x000fca00078e0225ULL,
0x00f0000025277984ULL, 0x000ee80000000800ULL, 0x00f2000025007984ULL, 0x0008620000000800ULL,
0x0000003c2700720bULL, 0x008fda0003f3d000ULL, 0x0000000000247806ULL, 0x000fc800008e0100ULL,
0x0000ffff24297812ULL, 0x000fda000782c0ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x0000003c2700720bULL, 0x012fe40003f34000ULL, 0x000000273c2b7209ULL, 0x000fe40007810000ULL,
0x0000000102257811ULL, 0x000fe400078ff0ffULL, 0x00000002ff2d7819ULL, 0x000fe20000011636ULL,
0x8000002b3c247221ULL, 0x100fe20000010000ULL, 0x000000ffff3c7224ULL, 0x000fc600078e002bULL,
0x3fb8aa3b24267820ULL, 0x000fe40000410000ULL, 0x0000000000247806ULL, 0x000fe400008e0100ULL,
0x000000022500720cULL, 0x000fe40003f25270ULL, 0x0000ffff242a7812ULL, 0x000fe200078e3cffULL,
0x0000002600267308ULL, 0x000e660000000800ULL, 0x0000002a29ff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ffa47807ULL, 0x000fc60001000000ULL, 0x0000008002259824ULL, 0x000fc800078e0245ULL,
0x00000001462a9824ULL, 0x000fe200078e0225ULL, 0x00001f2d26247589ULL, 0x002e6200000e0000ULL,
0x8000002b27272221ULL, 0x000fe20000010000ULL, 0x000000263d3d7220ULL, 0x000fe40000410000ULL,
0x00001f5426257589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b27272820ULL, 0x000fc60000410000ULL,
0x00f4002b2a009388ULL, 0x0009e20000000800ULL, 0x0000002700412308ULL, 0x000f620000000800ULL,
0x0000002404047220ULL, 0x082fe20000410000ULL, 0x0000002405057220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x000000240c0c7220ULL, 0x080fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002420207220ULL, 0x080fe20000410000ULL, 0x0000002421217220ULL, 0x000fe20000410000ULL,
0x0000002506067220ULL, 0x088fe20000410000ULL, 0x0000002507077220ULL, 0x080fe20000410000ULL,
0x000000250a0a7220ULL, 0x080fe20000410000ULL, 0x000000250b0b7220ULL, 0x080fe20000410000ULL,
0x000000250e0e7220ULL, 0x080fe20000410000ULL, 0x000000250f0f7220ULL, 0x080fe20000410000ULL,
0x0000002512127220ULL, 0x080fe20000410000ULL, 0x0000002513137220ULL, 0x080fe20000410000ULL,
0x0000002516167220ULL, 0x080fe20000410000ULL, 0x0000002517177220ULL, 0x080fe20000410000ULL,
0x000000251a1a7220ULL, 0x080fe20000410000ULL, 0x000000251b1b7220ULL, 0x080fe20000410000ULL,
0x000000251e1e7220ULL, 0x080fe20000410000ULL, 0x000000251f1f7220ULL, 0x080fe20000410000ULL,
0x0000002522227220ULL, 0x080fe20000410000ULL, 0x0000002523237220ULL, 0x000fe20000410000ULL,
0x0000000041002220ULL, 0x020fc80000410000ULL, 0x0000003d003d7221ULL, 0x012fe20000010000ULL,
0x0000013000000947ULL, 0x000fea0003800000ULL, 0x0000000840007824ULL, 0x000fe400078e00ffULL,
0x0000000802247824ULL, 0x000fc400078e00ffULL, 0x8000000028277824ULL, 0x000fe200078e00ffULL,
0x0000000800007812ULL, 0x000fe400078e0cffULL, 0xfffffff024257812ULL, 0x000fca00078ec0ffULL,
0x0000000100257824ULL, 0x000fca00078e0225ULL, 0x00f64c0025007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000028277824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x00f64c0025247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00001000402d7824ULL, 0x000fe400078e00ffULL, 0x0000100002007824ULL, 0x000fc600078e00ffULL,
0x000010002d2d7812ULL, 0x000fe400078e0cffULL, 0xffffe00000007812ULL, 0x000fc800078ec0ffULL,
0x0000b00000557810ULL, 0x100fe40007ffe02dULL, 0x0000b0003a007810ULL, 0x000fc60007ffe02dULL,
0x000000104e5f7824ULL, 0x100fe400078e0255ULL, 0x0000001050557824ULL, 0x000fe400078e0255ULL,
0x000000104f567824ULL, 0x100fe200078e0200ULL, 0x000000005f24783bULL, 0x000e620000004200ULL,
0x0000001051577824ULL, 0x000fc600078e0200ULL, 0x000000005528783bULL, 0x000ee80000004200ULL,
0x00000000562c783bULL, 0x000f280000004200ULL, 0x000000005730783bULL, 0x000f620000004200ULL,
0x0000010024dc7824ULL, 0x042fe200078e00ffULL, 0x0000002400ee7306ULL, 0x000fe20000009400ULL,
0x0001000024e57824ULL, 0x000fe200078e00ffULL, 0x00000018ffde7819ULL, 0x000fe20000011424ULL,
0x0000010025e17824ULL, 0x040fe200078e00ffULL, 0x00000018ffdc7819ULL, 0x000fe200000114dcULL,
0x0001000025d27824ULL, 0x000fe200078e00ffULL, 0x00000018ffe57819ULL, 0x000fe200000114e5ULL,
0x0001000027c47824ULL, 0x000fe200078e00ffULL, 0x000000dc00c57306ULL, 0x000fe20000209400ULL,
0x00000018ffe17819ULL, 0x000fe200000114e1ULL, 0x0000010029c77824ULL, 0x048fe200078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe20000011425ULL, 0x0001000029d77824ULL, 0x000fe200078e00ffULL,
0x00000018ffd27819ULL, 0x000fe200000114d2ULL, 0x000001002aa07824ULL, 0x040fe200078e00ffULL,
0x00000018ffba7819ULL, 0x000fe20000011426ULL, 0x000000dc00ce7306ULL, 0x0002e20000205400ULL,
0x00000018ffaf7819ULL, 0x000fe20000011427ULL, 0x000100002aa27824ULL, 0x000fe200078e00ffULL,
0x00000018ffc47819ULL, 0x000fe200000114c4ULL, 0x000001002ba17824ULL, 0x040fe200078e00ffULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x000100002bab7824ULL, 0x000fe200078e00ffULL,
0x00000018ffb67819ULL, 0x000fe20000011428ULL, 0x0000002400a77306ULL, 0x000ea20000005400ULL,
0x000000dc00dc7245ULL, 0x002fe2000020d400ULL, 0x000100002ce97824ULL, 0x010fe200078e00ffULL,
0x00000018ffd77819ULL, 0x000fc400000114d7ULL, 0x00000018ff8d7819ULL, 0x000fe40000011429ULL,
0x00000018ff987819ULL, 0x000fe2000001142aULL, 0x000000e500ea7306ULL, 0x000fe20000209400ULL,
0x000000cec500720bULL, 0x008fe20003fdd000ULL, 0x0000010030c57824ULL, 0x020fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fe200000114a0ULL, 0x0000010031ce7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9f7819ULL, 0x000fe4000001142bULL, 0x00000018ffa27819ULL, 0x000fe200000114a2ULL,
0x000000e500cd7306ULL, 0x000e620000205400ULL, 0x000000a7ee00720bULL, 0x004fc40003f9d000ULL,
0x00000018ff897819ULL, 0x000fe4000001142cULL, 0x00000018ff7b7819ULL, 0x000fe4000001142eULL,
0x00000001dcdc6812ULL, 0x000fe200078efcffULL, 0x000000e100d57306ULL, 0x000fe20000209400ULL,
0x00000018ffa17819ULL, 0x000fe400000114a1ULL, 0x00000018ff847819ULL, 0x000fe4000001142dULL,
0x00000018ffab7819ULL, 0x000fc400000114abULL, 0x00000018ff767819ULL, 0x000fe2000001142fULL,
0x000000e100ec7306ULL, 0x000ea20000205400ULL, 0x000000cdea00720bULL, 0x002fe40003f5d000ULL,
0x00000018ffc57819ULL, 0x000fe400000114c5ULL, 0x00000018ff6d7819ULL, 0x000fe40000011430ULL,
0x00000018ff6b7819ULL, 0x000fe20000011431ULL, 0x0000002600dd7306ULL, 0x000fe20000009400ULL,
0x00000018ffce7819ULL, 0x000fc400000114ceULL, 0x00000018ff657819ULL, 0x000fe40000011432ULL,
0x00000018ff647819ULL, 0x000fc60000011433ULL, 0x0000002600e07306ULL, 0x000e620000005400ULL,
0x000000ecd500720bULL, 0x004fce0003fbd000ULL, 0x0000002500e87306ULL, 0x000ff00000009400ULL,
0x0000002500db7306ULL, 0x000ea20000005400ULL, 0x000000e0dd00720bULL, 0x002fe40003fdd000ULL,
0x000000e500dd7245ULL, 0x000fc8000020d400ULL, 0x00000001dddd2812ULL, 0x000fe200078efcffULL,
0x00000025008a7306ULL, 0x0003f0000000d400ULL, 0x00000024008b7306ULL, 0x000722000000d400ULL,
0x0000010026257824ULL, 0x002fe200078e00ffULL, 0x000000dbe800720bULL, 0x004fe20003f7d000ULL,
0x000100002de87824ULL, 0x000fc600078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x000000de00c27306ULL, 0x000fe20000209400ULL, 0x0000010027247824ULL, 0x008fe200078e00ffULL,
0x00000018ffe87819ULL, 0x000fc800000114e8ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x000000de00bf7306ULL, 0x0002a20000205400ULL, 0x000000018b8b4812ULL, 0x010fe400078efcffULL,
0x000000018a8a3812ULL, 0x000fca00078efcffULL, 0x000000be00df7306ULL, 0x000fe20000209400ULL,
0x000000de00de7245ULL, 0x002fce000020d400ULL, 0x000000be00e27306ULL, 0x000e620000205400ULL,
0x000000bfc200720bULL, 0x004fce0003f1d000ULL, 0x000000d200e67306ULL, 0x000fec0000209400ULL,
0x00000001dede0812ULL, 0x000fe400078efcffULL, 0x000000d200e77306ULL, 0x0004e20000205400ULL,
0x000000e2df00720bULL, 0x002fe40003f5d000ULL, 0x000000e100df7245ULL, 0x000fc4000020d400ULL,
0x00000018ffe17819ULL, 0x000fe400000114e9ULL, 0x00000001dfdf5812ULL, 0x000fe200078efcffULL,
0x0000002500e37306ULL, 0x000fe20000209400ULL, 0x000000d200d27245ULL, 0x004fe4000020d400ULL,
0x000000dddede723eULL, 0x000fca00000010ffULL, 0x0000002500e47306ULL, 0x000e620000205400ULL,
0x000000e7e600720bULL, 0x008fce0003f9d000ULL, 0x0000002600817306ULL, 0x0004ec000000d400ULL,
0x00000001d2d24812ULL, 0x000fe400078efcffULL, 0x0000002400c17306ULL, 0x000fe20000209400ULL,
0x0001000026267824ULL, 0x004fe200078e00ffULL, 0x000000e4e300720bULL, 0x002fc80003fbd000ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000002400cc7306ULL, 0x000e620000205400ULL,
0x0000000181816812ULL, 0x008fce00078efcffULL, 0x0000002700c07306ULL, 0x000ff00000009400ULL,
0x0000002700b37306ULL, 0x000ea20000005400ULL, 0x000000ccc100720bULL, 0x002fe40003f7d000ULL,
0x000000be00c17245ULL, 0x000fc8000020d400ULL, 0x00000001c1c12812ULL, 0x000fe200078efcffULL,
0x0000002800bd7306ULL, 0x000ff00000009400ULL, 0x0000002800b07306ULL, 0x000e620000005400ULL,
0x000000b3c000720bULL, 0x004fce0003f1d000ULL, 0x0000002700807306ULL, 0x0004f0000000d400ULL,
0x0000002600c37306ULL, 0x000fe20000209400ULL, 0x0000010028277824ULL, 0x004fe200078e00ffULL,
0x000000b0bd00720bULL, 0x002fc40003f9d000ULL, 0x0000002500b07245ULL, 0x000fe4000020d400ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000002600d07306ULL, 0x000e620000205400ULL,
0x00000001b0b05812ULL, 0x000fe400078efcffULL, 0x0000000180800812ULL, 0x008fe400078efcffULL,
0x00000081b0b0723eULL, 0x000fc600000010ffULL, 0x000000ba00bc7306ULL, 0x000ff00000209400ULL,
0x000000ba00b17306ULL, 0x0004e20000205400ULL, 0x000000d0c300720bULL, 0x002fce0003f5d000ULL,
0x000000af00a97306ULL, 0x000fe20000209400ULL, 0x000000ba00ba7245ULL, 0x004fce000020d400ULL,
0x000000af00b47306ULL, 0x000e620000205400ULL, 0x000000b1bc00720bULL, 0x008fe40003fbd000ULL,
0x0000002400b17245ULL, 0x000fc8000020d400ULL, 0x00000001b1b13812ULL, 0x000fe200078efcffULL,
0x0000002700c97306ULL, 0x000fe60000209400ULL, 0x00000080b1b1723eULL, 0x000fc600000010ffULL,
0x00000001baba5812ULL, 0x000fe400078efcffULL, 0x0000002700c67306ULL, 0x000ea20000205400ULL,
0x000000b4a900720bULL, 0x002fe40003fdd000ULL, 0x0000002600a97245ULL, 0x000fc8000020d400ULL,
0x00000001a9a92812ULL, 0x000fe200078efcffULL, 0x00000028007c7306ULL, 0x0002e6000000d400ULL,
0x000000a9baba723eULL, 0x000fca00000010ffULL, 0x0000002900a87306ULL, 0x000fe20000009400ULL,
0x0001000028287824ULL, 0x002fe200078e00ffULL, 0x000000c6c900720bULL, 0x004fc80003f1d000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002900b57306ULL, 0x000e620000005400ULL,
0x000000017c7c4812ULL, 0x008fce00078efcffULL, 0x000000c400ca7306ULL, 0x000ff00000209400ULL,
0x000000c400cb7306ULL, 0x0004e20000205400ULL, 0x000000b5a800720bULL, 0x002fe40003f5d000ULL,
0x000000af00b57245ULL, 0x000fc4000020d400ULL, 0x0000002700af7245ULL, 0x000fe4000020d400ULL,
0x00000001b5b56812ULL, 0x000fe200078efcffULL, 0x000000c700c87306ULL, 0x000fe20000209400ULL,
0x00000001afaf0812ULL, 0x000fe200078efcffULL, 0x009800005324783bULL, 0x000fe20000000200ULL,
0x000000c400c47245ULL, 0x004fe4000020d400ULL, 0x000000c700a87245ULL, 0x000fe4000020d400ULL,
0x0000007caf7c723eULL, 0x000fe200000010ffULL, 0x000000c700d17306ULL, 0x000e620000205400ULL,
0x000000cbca00720bULL, 0x008fce0003f7d000ULL, 0x000000b600b87306ULL, 0x000fec0000209400ULL,
0x00000001c4c43812ULL, 0x000fe400078efcffULL, 0x000000b600bb7306ULL, 0x0004e20000205400ULL,
0x000000d1c800720bULL, 0x002fce0003fbd000ULL, 0x0000002800cf7306ULL, 0x000fe20000209400ULL,
0x000000b600b67245ULL, 0x004fca000020d400ULL, 0x00000001a8a85812ULL, 0x000fe400078efcffULL,
0x0000002800da7306ULL, 0x000e620000205400ULL, 0x000000bbb800720bULL, 0x008fe40003fdd000ULL,
0x00000002ffb87819ULL, 0x000fca0000011636ULL, 0x00000029007f7306ULL, 0x000eac000000d400ULL,
0x00000001b6b66812ULL, 0x000fe400078efcffULL, 0x0000002a00a57306ULL, 0x000fe20000009400ULL,
0x000000dacf00720bULL, 0x002fce0003f1d000ULL, 0x0000002a00b27306ULL, 0x000e620000005400ULL,
0x000000017f7f2812ULL, 0x004fce00078efcffULL, 0x0000002a00787306ULL, 0x0004f0000000d400ULL,
0x0000002b00b97306ULL, 0x000fe20000009400ULL, 0x00009910a42a7816ULL, 0x004fe400000000ffULL,
0x000000b2a500720bULL, 0x002fc40003f7d000ULL, 0x000000ff2a00720cULL, 0x000fe20003f25270ULL,
0x000001002c2a7824ULL, 0x000fe200078e00ffULL, 0x0000002800a57245ULL, 0x000fe2000020d400ULL,
0x0000002b00ae7306ULL, 0x000e660000005400ULL, 0x00000018ffbf7819ULL, 0x000fe2000001142aULL,
0x000001002e2a7824ULL, 0x000fe200078e00ffULL, 0x00000001a5a50812ULL, 0x000fc600078efcffULL,
0x000000d700d47306ULL, 0x000fe20000209400ULL, 0x00000018ffb47819ULL, 0x000fe4000001142aULL,
0x0000000178783812ULL, 0x008fe400078efcffULL, 0x000000a5b6b6723eULL, 0x000fc600000010ffULL,
0x000000d700297306ULL, 0x0004e20000205400ULL, 0x000000aeb900720bULL, 0x002fce0003fbd000ULL,
0x000000a000d87306ULL, 0x000fe20000209400ULL, 0x000000d700d77245ULL, 0x004fce000020d400ULL,
0x000000a000d37306ULL, 0x000e620000205400ULL, 0x00000029d400720bULL, 0x008fce0003f9d000ULL,
0x0000008d00b77306ULL, 0x000fec0000209400ULL, 0x00000001d7d74812ULL, 0x000fe400078efcffULL,
0x0000008d00ac7306ULL, 0x000ea20000205400ULL, 0x000000d3d800720bULL, 0x002fce0003fdd000ULL,
0x0000002c00ad7306ULL, 0x000ff00000009400ULL, 0x0000002c00aa7306ULL, 0x000e620000005400ULL,
0x000000acb700720bULL, 0x004fce0003f1d000ULL, 0x0000002b00757306ULL, 0x0004f0000000d400ULL,
0x0000002d00977306ULL, 0x000fe20000009400ULL, 0x000001002f2b7824ULL, 0x004fe200078e00ffULL,
0x000000aaad00720bULL, 0x002fc40003f5d000ULL, 0x0000008d00aa7245ULL, 0x000fe4000020d400ULL,
0x00000018ffb27819ULL, 0x000fe4000001142bULL, 0x0000002d009e7306ULL, 0x000e620000005400ULL,
0x009800005228783bULL, 0x000fe20000000200ULL, 0x000000a0008d7245ULL, 0x000fe4000020d400ULL,
0x0000000175755812ULL, 0x008fe400078efcffULL, 0x000000018d8d6812ULL, 0x000fc400078efcffULL,
0x0000002e00997306ULL, 0x000fe20000009400ULL, 0x00000001aaaa0812ULL, 0x000fe400078efcffULL,
0x000000788d78723eULL, 0x000fca00000010ffULL, 0x0000002e00907306ULL, 0x000fe20000005400ULL,
0x0000009e9700720bULL, 0x002fce0003fbd000ULL, 0x0000002e006f7306ULL, 0x0003f0000000d400ULL,
0x000000a200a37306ULL, 0x000fe20000209400ULL, 0x000100002e2e7824ULL, 0x002fca00078e00ffULL,
0x00000018ffac7819ULL, 0x000fe4000001142eULL, 0x000000a200a67306ULL, 0x0002a20000205400ULL,
0x00000041ff2e723eULL, 0x000fc800000010ffULL, 0x000054102eb97816ULL, 0x000fc6000000002eULL,
0x0000002c00737306ULL, 0x000722000000d400ULL, 0x000000a200a27245ULL, 0x002fe2000020d400ULL,
0x00001f54b92e7589ULL, 0x000e6c00000e0000ULL, 0x00000089008c7306ULL, 0x000fe20000209400ULL,
0x000000a6a300720bULL, 0x004fe20003fdd000ULL, 0x000001002d2c7824ULL, 0x008fe200078e00ffULL,
0x00001fb8b9a37589ULL, 0x000ea800000e0000ULL, 0x00000018ffd57819ULL, 0x000fe2000001142cULL,
0x00000089008f7306ULL, 0x000ee20000205400ULL, 0x0000000173732812ULL, 0x010fe200078efcffULL,
0x00000100332c7824ULL, 0x000fc800078e00ffULL, 0x00000001a2a26812ULL, 0x000fe400078efcffULL,
0x000000a100d67306ULL, 0x000fe20000209400ULL, 0x000000909900720bULL, 0x000fe20003fdd000ULL,
0x0000002e29299231ULL, 0x082fe200003400ffULL, 0x000000bf00907245ULL, 0x000fe2000020d400ULL,
0x0000002e2b2b9231ULL, 0x080fe400003400ffULL, 0x0000002e25259231ULL, 0x080fe400003400ffULL,
0x000000a100d97306ULL, 0x000e620000205400ULL, 0x0000008f8c00720bULL, 0x008fe20003f5d000ULL,
0x0000002e27279231ULL, 0x000fe200003400ffULL, 0x00000089008c7245ULL, 0x000fe2000020d400ULL,
0x000000a328289231ULL, 0x084fe200003400ffULL, 0x0000008bdc2e723eULL, 0x000fe200000010ffULL,
0x000000a32a2a9231ULL, 0x080fe200003400ffULL, 0x000000016f6f6812ULL, 0x000fe200078efcffULL,
0x0000002d00007306ULL, 0x0004e2000000d400ULL, 0x000000a324249231ULL, 0x000fc400003400ffULL,
0x000000a326269231ULL, 0x000fe400003400ffULL, 0x000000b0280c723cULL, 0x000fe2000004180cULL,
0x000000018c8c2812ULL, 0x000fe400078efcffULL, 0x00000084009b7306ULL, 0x000fe20000209400ULL,
0x000000d9d600720bULL, 0x002fe20003f9d000ULL, 0x00000100322d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x0000008400967306ULL, 0x000e620000205400ULL,
0x0000000100005812ULL, 0x008fce00078efcffULL, 0x0000009800957306ULL, 0x000ff00000209400ULL,
0x00000098009a7306ULL, 0x000ea20000205400ULL, 0x000000969b00720bULL, 0x002fce0003fbd000ULL,
0x0000003100857306ULL, 0x000ff00000009400ULL, 0x0000003100867306ULL, 0x000e620000005400ULL,
0x0000009a9500720bULL, 0x004fe40003f1d000ULL, 0x000000a1009a7245ULL, 0x000fc4000020d400ULL,
0x0000009800957245ULL, 0x000fe4000020d400ULL, 0x000000019a9a4812ULL, 0x000fe200078efcffULL,
0x000000ab00a47306ULL, 0x000fec0000209400ULL, 0x0000000195950812ULL, 0x000fe400078efcffULL,
0x000000ab00a77306ULL, 0x0004e20000205400ULL, 0x000000868500720bULL, 0x002fc40003f5d000ULL,
0x0000008400857245ULL, 0x000fe4000020d400ULL, 0x000000a295a2723eULL, 0x000fe400000010ffULL,
0x0000000185855812ULL, 0x000fe200078efcffULL, 0x0000009f00927306ULL, 0x000fe20000209400ULL,
0x000000ab00ab7245ULL, 0x004fce000020d400ULL, 0x0000009f00917306ULL, 0x000e620000205400ULL,
0x000000a7a400720bULL, 0x008fce0003f9d000ULL, 0x000000b200ae7306ULL, 0x000fec0000209400ULL,
0x00000001abab4812ULL, 0x000fe400078efcffULL, 0x000000b200b77306ULL, 0x000ea20000205400ULL,
0x000000919200720bULL, 0x002fe40003f7d000ULL, 0x0000009f00927245ULL, 0x000fca000020d400ULL,
0x0000002f009c7306ULL, 0x000fec0000009400ULL, 0x0000000192923812ULL, 0x000fe400078efcffULL,
0x0000002f00937306ULL, 0x000e620000005400ULL, 0x000000b7ae00720bULL, 0x004fe40003fbd000ULL,
0x000000d7aab7723eULL, 0x000fc400000010ffULL, 0x000000ab92a3723eULL, 0x000fc600000010ffULL,
0x0000002f006a7306ULL, 0x0004e4000000d400ULL, 0x000000b62818723cULL, 0x040fec0000041818ULL,
0x000000bf00c27306ULL, 0x000fe20000209400ULL, 0x000100002f2f7824ULL, 0x004fe200078e00ffULL,
0x000000939c00720bULL, 0x002fe20003f1d000ULL, 0x000000a22820723cULL, 0x000fe60000041820ULL,
0x00000018ff917819ULL, 0x000fc4000001142fULL, 0x000000bf00cd7306ULL, 0x000e620000205400ULL,
0x0000008adf2f723eULL, 0x000fe400000010ffULL, 0x000000d2c1df723eULL, 0x000fc800000010ffULL,
0x000000016a6a0812ULL, 0x008fe200078efcffULL, 0x0000007b007e7306ULL, 0x000fe20000209400ULL,
0x0000002e2804723cULL, 0x040fee0000041804ULL, 0x0000007b007d7306ULL, 0x0004e20000205400ULL,
0x000000b2002f7245ULL, 0x000fe2000020d400ULL, 0x000000de2808723cULL, 0x000fe20000041808ULL,
0x000000cdc200720bULL, 0x002fc40003f9d000ULL, 0x000000012f2f5812ULL, 0x000fc600078efcffULL,
0x000000d500db7306ULL, 0x000fe20000209400ULL, 0x0000007b007b7245ULL, 0x004fce000020d400ULL,
0x000000d500e07306ULL, 0x0002a20000205400ULL, 0x0000007d7e00720bULL, 0x008fe40003fbd000ULL,
0x0000000190904812ULL, 0x000fe400078efcffULL, 0x0000007fa87d723eULL, 0x000fe400000010ffULL,
0x000000739090723eULL, 0x000fe200000010ffULL, 0x000000e100b37306ULL, 0x000fe20000209400ULL,
0x000000d500d57245ULL, 0x002fc6000020d400ULL, 0x0000007c2814723cULL, 0x000fe40000041814ULL,
0x000000017b7b5812ULL, 0x000fe400078efcffULL, 0x000000e100be7306ULL, 0x0002e20000205400ULL,
0x000000e0db00720bULL, 0x004fce0003f7d000ULL, 0x00000030009d7306ULL, 0x000fe20000009400ULL,
0x000000e100e17245ULL, 0x002fca000020d400ULL, 0x00000001d5d53812ULL, 0x000fe400078efcffULL,
0x0000003000947306ULL, 0x000e620000005400ULL, 0x000000beb300720bULL, 0x008fce0003f3d000ULL,
0x000000ac00ad7306ULL, 0x000fec0000209400ULL, 0x00000001e1e11812ULL, 0x000fe400078efcffULL,
0x000000ac00a67306ULL, 0x0004e20000205400ULL, 0x000000949d00720bULL, 0x002fe40003f9d000ULL,
0x000000e18c8c723eULL, 0x000fca00000010ffULL, 0x00000076007a7306ULL, 0x000fe20000209400ULL,
0x000000ac00ac7245ULL, 0x004fce000020d400ULL, 0x0000007600797306ULL, 0x0002a20000205400ULL,
0x000000a6ad00720bULL, 0x008fe40003fdd000ULL, 0x0000009100ad7245ULL, 0x000fca000020d400ULL,
0x000000e800bc7306ULL, 0x000fe20000209400ULL, 0x0000007600767245ULL, 0x002fca000020d400ULL,
0x00000001acac6812ULL, 0x000fe400078efcffULL, 0x000000e800bd7306ULL, 0x0002e20000205400ULL,
0x000000797a00720bULL, 0x004fe40003f1d000ULL, 0x000000759a79723eULL, 0x000fe400000010ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001142cULL, 0x000000ac7bac723eULL, 0x000fe200000010ffULL,
0x000000c500987306ULL, 0x000fe20000209400ULL, 0x000000e800e87245ULL, 0x002fe2000020d400ULL,
0x00000078281c723cULL, 0x000fe8000004181cULL, 0x0000000176760812ULL, 0x000fc400078efcffULL,
0x000000c500997306ULL, 0x0002a20000205400ULL, 0x000000bdbc00720bULL, 0x008fce0003f7d000ULL,
0x000000b400c07306ULL, 0x000fe20000209400ULL, 0x000000c500c57245ULL, 0x002fca000020d400ULL,
0x00000001e8e83812ULL, 0x000fe400078efcffULL, 0x000000b400bb7306ULL, 0x0002e20000205400ULL,
0x000000999800720bULL, 0x004fe40003fbd000ULL, 0x000000e8858d723eULL, 0x000fca00000010ffULL,
0x00000030006e7306ULL, 0x000522000000d400ULL, 0x000000b400b47245ULL, 0x002fe2000020d400ULL,
0x0000008c2408723cULL, 0x000fe80000041808ULL, 0x00000001c5c55812ULL, 0x000fe400078efcffULL,
0x0000009100a07306ULL, 0x000fe20000209400ULL, 0x0001000030307824ULL, 0x004fe200078e00ffULL,
0x000000bbc000720bULL, 0x008fc40003f3d000ULL, 0x000000c4b5bb723eULL, 0x000fe400000010ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000009100977306ULL, 0x0002a20000205400ULL,
0x0000006a2fb5723eULL, 0x000fe400000010ffULL, 0x000000ba2810723cULL, 0x000fe20000041810ULL,
0x000000016e6e4812ULL, 0x010fc600078efcffULL, 0x00000001b4b41812ULL, 0x000fe200078efcffULL,
0x0000003200887306ULL, 0x000fe20000009400ULL, 0x00000000d591723eULL, 0x002fe400000010ffULL,
0x000000ce00297245ULL, 0x000fe4000020d400ULL, 0x0000006b00007245ULL, 0x000fe4000020d400ULL,
0x0000006fb4b4723eULL, 0x000fe200000010ffULL, 0x0000003200877306ULL, 0x000e620000005400ULL,
0x00000097a000720bULL, 0x004fe20003fdd000ULL, 0x000000902404723cULL, 0x000fe20000041804ULL,
0x0000006ec56e723eULL, 0x000fca00000010ffULL, 0x0000006b00727306ULL, 0x000fe40000209400ULL,
0x000000b4240c723cULL, 0x000fe8000004180cULL, 0x00000001adad6812ULL, 0x000fe400078efcffULL,
0x0000006b00717306ULL, 0x000ea20000205400ULL, 0x000000878800720bULL, 0x002fe40003f7d000ULL,
0x000000ad76ad723eULL, 0x000fca00000010ffULL, 0x000000ce00937306ULL, 0x000fe40000209400ULL,
0x000000ac2410723cULL, 0x000fec0000041810ULL, 0x000000ce00947306ULL, 0x000e620000205400ULL,
0x000000717200720bULL, 0x004fce0003f1d000ULL, 0x0000003000897306ULL, 0x000fec0000209400ULL,
0x0000000100000812ULL, 0x000fe400078efcffULL, 0x00000030002e7306ULL, 0x0004e20000205400ULL,
0x000000949300720bULL, 0x002fce0003fbd000ULL, 0x0000003100687306ULL, 0x000322000000d400ULL,
0x0000003000307245ULL, 0x004fca000020d400ULL, 0x0000000129295812ULL, 0x000fe400078efcffULL,
0x0000003200677306ULL, 0x000562000000d400ULL, 0x0001000031317824ULL, 0x002fe200078e00ffULL,
0x0000002e8900720bULL, 0x008fc80003f9d000ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003300837306ULL, 0x000fe20000009400ULL, 0x0001000032327824ULL, 0x004fe200078e00ffULL,
0x0000000168682812ULL, 0x010fc800078efcffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000003300827306ULL, 0x000e620000005400ULL, 0x0000000130304812ULL, 0x000fe400078efcffULL,
0x0000000167673812ULL, 0x020fe400078efcffULL, 0x00000068296f723eULL, 0x000fe400000010ffULL,
0x0000007a00297245ULL, 0x000fe2000020d400ULL, 0x0000003300667306ULL, 0x0004e8000000d400ULL,
0x0000006e2414723cULL, 0x000fe80000041814ULL, 0x0000006d00747306ULL, 0x000fe20000209400ULL,
0x0001000033337824ULL, 0x004fe200078e00ffULL, 0x000000828300720bULL, 0x002fc80003f3d000ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000006d00777306ULL, 0x0002ae0000205400ULL,
0x0000000166661812ULL, 0x008fe200078efcffULL, 0x0000003100817306ULL, 0x000fe20000209400ULL,
0x0000006d006d7245ULL, 0x002fce000020d400ULL, 0x0000003100807306ULL, 0x0002e20000205400ULL,
0x000000777400720bULL, 0x004fce0003fdd000ULL, 0x00000065006c7306ULL, 0x000fe20000209400ULL,
0x0000003100317245ULL, 0x002fca000020d400ULL, 0x000000016d6d6812ULL, 0x000fe400078efcffULL,
0x0000006500637306ULL, 0x0002a20000205400ULL, 0x000000808100720bULL, 0x008fe40003f5d000ULL,
0x000000306d30723eULL, 0x000fca00000010ffULL, 0x0000006400697306ULL, 0x000fe20000209400ULL,
0x0000006500657245ULL, 0x002fca000020d400ULL, 0x0000000131312812ULL, 0x000fe400078efcffULL,
0x0000006400707306ULL, 0x0002e20000205400ULL, 0x000000636c00720bULL, 0x004fe40003fbd000ULL,
0x000000310031723eULL, 0x000fe400000010ffULL, 0x0000002d00007245ULL, 0x000fc6000020d400ULL,
0x00000032002c7306ULL, 0x000fe20000209400ULL, 0x0000006400647245ULL, 0x002fe2000020d400ULL,
0x000000302418723cULL, 0x000fe80000041818ULL, 0x0000000165655812ULL, 0x000fe400078efcffULL,
0x00000032002b7306ULL, 0x0002a20000205400ULL, 0x000000706900720bULL, 0x008fce0003f9d000ULL,
0x0000003300287306ULL, 0x000fe20000209400ULL, 0x0000003200327245ULL, 0x002fca000020d400ULL,
0x0000000164644812ULL, 0x000fe400078efcffULL, 0x00000033002f7306ULL, 0x0002e20000205400ULL,
0x0000002b2c00720bULL, 0x004fce0003f1d000ULL, 0x0000002d007e7306ULL, 0x000fe20000209400ULL,
0x0000003300337245ULL, 0x002fca000020d400ULL, 0x0000000132320812ULL, 0x000fe400078efcffULL,
0x0000002d007f7306ULL, 0x000e620000205400ULL, 0x0000002f2800720bULL, 0x008fe40003f7d000ULL,
0x000000326532723eULL, 0x000fca00000010ffULL, 0x0000007a007c7306ULL, 0x000fec0000209400ULL,
0x0000000133333812ULL, 0x000fe400078efcffULL, 0x0000007a00757306ULL, 0x000ea20000205400ULL,
0x0000007f7e00720bULL, 0x002fe40003fdd000ULL, 0x000000336433723eULL, 0x000fce00000010ffULL,
0x000000322420723cULL, 0x000fe80000041820ULL, 0x0000000100006812ULL, 0x000fe400078efcffULL,
0x000000757c00720bULL, 0x004fe40003f5d000ULL, 0x000000670028723eULL, 0x000fd600000010ffULL,
0x0000000129292812ULL, 0x000fc800078efcffULL, 0x000000662929723eULL, 0x000fce00000010ffULL,
0x00000028241c723cULL, 0x000fee000004181cULL, 0x00000002ff297819ULL, 0x000fc80000011602ULL,
0x0000f62029007811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000020003eff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000434247824ULL, 0x000fe200078e0229ULL, 0x000000ff62ff7812ULL, 0x000fe2000784c0ffULL,
0x0000000000ff7f8cULL, 0x0005e2000c80043fULL, 0x0000000140ff7812ULL, 0x000fe4000782c0ffULL,
0x0000008024247811ULL, 0x000fe400078e30ffULL, 0x00000001ff677807ULL, 0x000fe40001000000ULL,
0x000000032400720cULL, 0x000fc40003f46070ULL, 0x000000ff8eff7812ULL, 0x000fe4000780c0ffULL,
0x0000006267657207ULL, 0x000fe40004800000ULL, 0x00000001ff647807ULL, 0x000fe40004000000ULL,
0x0000000140637812ULL, 0x000fca00078ec0ffULL, 0x0000544000002947ULL, 0x000fea0003800000ULL,
0x000024003e257984ULL, 0x004ea20000000800ULL, 0x00000001ff247807ULL, 0x000fca0004000000ULL,
0x8000000024007824ULL, 0x000fca00078e00ffULL, 0x8000000025ff7812ULL, 0x004fe20007824800ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x000024003e257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x004fe40007824800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000024257824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000024003e247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x00000001ff487819ULL, 0x000fe20000011602ULL,
0x00000080ff337424ULL, 0x000fe200078e00ffULL, 0x0000000134247810ULL, 0x000fe40007ffe0ffULL,
0x00000003ff297819ULL, 0x000fe20000011636ULL, 0x0000002048007824ULL, 0x000fe200078e0247ULL,
0x000000352400720cULL, 0x000fe40003f26070ULL, 0x0000000429317810ULL, 0x000fe40007ffe0ffULL,
0x000000c000007810ULL, 0x000fc40007ffe0ffULL, 0x00000008292f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000003257217ULL, 0x000fe20007800000ULL, 0x0000620038287a24ULL, 0x000fe200078e0200ULL,
0x0000000c292d7810ULL, 0x000fc60007ffe0ffULL, 0x0000000125257824ULL, 0x000fe200078e0a00ULL,
0x0000002928247210ULL, 0x140fe40007ffe039ULL, 0x0000003128267210ULL, 0x000fe40007ffe039ULL,
0x0000002025007807ULL, 0x000fe20000800000ULL, 0x00005e0024247625ULL, 0x000fc600078e0033ULL,
0x0000000039007217ULL, 0x000fe20007800000ULL, 0x00005e0026267625ULL, 0x000fe200078e0033ULL,
0x00000045242a7210ULL, 0x000fe40007f3e0ffULL, 0x0000002f28247210ULL, 0x100fe20007ffe039ULL,
0x0000000100007824ULL, 0x100fe200078e0a39ULL, 0x0000002d28287210ULL, 0x000fe20007ffe039ULL,
0x000000ffff2b7224ULL, 0x000fe200008e0625ULL, 0x0000004526267210ULL, 0x000fe20007f7e0ffULL,
0x00005e0024247625ULL, 0x000fe200078e0033ULL, 0x000000002900720cULL, 0x000fc40003f46070ULL,
0x000000003100720cULL, 0x080fe20003f26070ULL, 0x00005e0028287625ULL, 0x000fe200078e0033ULL,
0x000000002d00720cULL, 0x080fe40003f86070ULL, 0x0000004524247210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff277224ULL, 0x000fe200018e0627ULL, 0x000000002f00720cULL, 0x000fe40003f66070ULL,
0x0000004528287210ULL, 0x000fe20007fde0ffULL, 0x000000ffff257224ULL, 0x000fe200028e0625ULL,
0x00000008612d7812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a4a7faeULL, 0x0005e4000d101c48ULL, 0x000000ffff297224ULL, 0x000fc400030e0629ULL,
0x00000000264b7faeULL, 0x0005e2000c901c48ULL, 0x0000001048007824ULL, 0x000fc600078e022dULL,
0x00000000244c7faeULL, 0x0005e8000d901c48ULL, 0x00000000284d7faeULL, 0x0005e8000e101c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f64c0000257984ULL, 0x0044e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f62c0042247984ULL, 0x000f220000000800ULL,
0x0000000140ff7812ULL, 0x000fe2000782c0ffULL, 0x8000000043277824ULL, 0x000fc600078e00ffULL,
0x0000006267477207ULL, 0x000fc80004800000ULL, 0x0000ffff47007812ULL, 0x004fc800078ec0ffULL,
0x0000888000007816ULL, 0x000fca00000000ffULL, 0x8000000000007824ULL, 0x000fca00078e00ffULL,
0x8000000025ff7812ULL, 0x008fe40007844800ULL, 0x8000000024ff7812ULL, 0x010fe20007864827ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000b000003947ULL, 0x000fea0003800000ULL,
0x0000000402427824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x8000000043257824ULL, 0x000fe200078e00ffULL, 0xfffffff042427812ULL, 0x000fe400078ec0ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x00f62c0042247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007864825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000b947ULL, 0x000fea000383ffffULL, 0x0000010045257810ULL, 0x000fe20007ffe044ULL,
0x00000001ffb27424ULL, 0x000fc800078e00ffULL, 0x0000000146257824ULL, 0x000fca00078e0225ULL,
0x00f0000025277984ULL, 0x000ea80000000800ULL, 0x00f2000025007984ULL, 0x0007220000000800ULL,
0x0000003c2700720bULL, 0x004fda0003f7d000ULL, 0x0000000000247806ULL, 0x000fc800018e0100ULL,
0x0000ffff24287812ULL, 0x000fda000786c0ffULL, 0x000003700000b947ULL, 0x000fea0003800000ULL,
0x0000003c2700720bULL, 0x018fe40003f74000ULL, 0x000000273c2a7209ULL, 0x000fe40007810000ULL,
0x0000000202257811ULL, 0x000fe400078ff0ffULL, 0x00000002ff2b7819ULL, 0x000fe20000011636ULL,
0x8000002a3c247221ULL, 0x100fe20000010000ULL, 0x000000ffff3c7224ULL, 0x000fc600078e002aULL,
0x3fb8aa3b24267820ULL, 0x000fe40000410000ULL, 0x0000000000247806ULL, 0x000fe400018e0100ULL,
0x000000022500720cULL, 0x000fe40003f65270ULL, 0x0000ffff24297812ULL, 0x000fe200078e3cffULL,
0x0000002600267308ULL, 0x000ea60000000800ULL, 0x0000002928ff7212ULL, 0x000fc8000788c0ffULL,
0x00000001ffb27807ULL, 0x000fc60002000000ULL, 0x000000800225b824ULL, 0x000fc800078e0245ULL,
0x000000014629b824ULL, 0x000fe200078e0225ULL, 0x00001f2b26247589ULL, 0x004ea200000e0000ULL,
0x8000002a27274221ULL, 0x000fe20000010000ULL, 0x000000263d3d7220ULL, 0x000fe40000410000ULL,
0x00001f5426257589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b27274820ULL, 0x000fc60000410000ULL,
0x00f4002a2900b388ULL, 0x0009e20000000800ULL, 0x0000002700414308ULL, 0x000f620000000800ULL,
0x0000002404047220ULL, 0x084fe20000410000ULL, 0x0000002405057220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x000000240c0c7220ULL, 0x080fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002420207220ULL, 0x080fe20000410000ULL, 0x0000002421217220ULL, 0x000fe20000410000ULL,
0x0000002506067220ULL, 0x088fe20000410000ULL, 0x0000002507077220ULL, 0x080fe20000410000ULL,
0x000000250a0a7220ULL, 0x080fe20000410000ULL, 0x000000250b0b7220ULL, 0x080fe20000410000ULL,
0x000000250e0e7220ULL, 0x080fe20000410000ULL, 0x000000250f0f7220ULL, 0x080fe20000410000ULL,
0x0000002512127220ULL, 0x080fe20000410000ULL, 0x0000002513137220ULL, 0x080fe20000410000ULL,
0x0000002516167220ULL, 0x080fe20000410000ULL, 0x0000002517177220ULL, 0x080fe20000410000ULL,
0x000000251a1a7220ULL, 0x080fe20000410000ULL, 0x000000251b1b7220ULL, 0x080fe20000410000ULL,
0x000000251e1e7220ULL, 0x080fe20000410000ULL, 0x000000251f1f7220ULL, 0x080fe20000410000ULL,
0x0000002522227220ULL, 0x080fe20000410000ULL, 0x0000002523237220ULL, 0x000fe20000410000ULL,
0x0000000041004220ULL, 0x020fc80000410000ULL, 0x0000003d003d7221ULL, 0x018fe20000010000ULL,
0x0000016000002947ULL, 0x000fea0003800000ULL, 0x0000000802007824ULL, 0x000fe200078e00ffULL,
0x0000000861267812ULL, 0x000fc400078ec0ffULL, 0x0000000140ff7812ULL, 0x000fe4000784c0ffULL,
0xfffffff000257812ULL, 0x000fe400078ec0ffULL, 0x0000006267007207ULL, 0x000fc60005000000ULL,
0x0000000126267824ULL, 0x000fe200078e0225ULL, 0x0000ffff00007812ULL, 0x000fc800078ec0ffULL,
0x00f64c0026257984ULL, 0x000ea20000000800ULL, 0x0000888000247816ULL, 0x000fca00000000ffULL,
0x8000000024007824ULL, 0x000fca00078e00ffULL, 0x8000000025ff7812ULL, 0x004fe20007844800ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000024257824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x00f64c0026247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007844825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000100060317812ULL, 0x000fe200078ec0ffULL,
0x0000100002297824ULL, 0x000fc600078e00ffULL, 0x0000b0003a007810ULL, 0x000fca0007ffe031ULL,
0x000000104f247824ULL, 0x100fe400078e0200ULL, 0x0000001051287824ULL, 0x000fe200078e0200ULL,
0xffffe00029007812ULL, 0x000fc600078ec0ffULL, 0x000000002424783bULL, 0x000ea20000004200ULL,
0x0000b00000317810ULL, 0x000fc60007ffe031ULL, 0x000000002828783bULL, 0x000ee40000004200ULL,
0x000000104e2c7824ULL, 0x100fe400078e0231ULL, 0x0000001050317824ULL, 0x000fc800078e0231ULL,
0x000000002c2c783bULL, 0x000f280000004200ULL, 0x000000003130783bULL, 0x000f620000004200ULL,
0x00000024008c7306ULL, 0x004fe20000009400ULL, 0x00000018ff877819ULL, 0x000fe20000011424ULL,
0x00000100249a7824ULL, 0x040fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe20000011425ULL,
0x0001000024967824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011426ULL,
0x00000100258f7824ULL, 0x040fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011427ULL,
0x0000002400917306ULL, 0x000fe20000005400ULL, 0x00010000258b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x008fe20000011428ULL, 0x0000010026817824ULL, 0x000fe200078e00ffULL,
0x00000018ffcd7819ULL, 0x010fe2000001142cULL, 0x000001002fc57824ULL, 0x000fe200078e00ffULL,
0x00000018ffbf7819ULL, 0x000fe2000001142dULL, 0x000100002ec67824ULL, 0x000fe200078e00ffULL,
0x0000002400697306ULL, 0x0005e2000000d400ULL, 0x00000018ffba7819ULL, 0x000fe2000001142eULL,
0x0000010027797824ULL, 0x000fe200078e00ffULL, 0x00000018ffc57819ULL, 0x000fc400000114c5ULL,
0x00000018ffb57819ULL, 0x000fe4000001142fULL, 0x00000018ffc67819ULL, 0x000fe200000114c6ULL,
0x0000002c00c17306ULL, 0x000fe20000009400ULL, 0x000001002c247824ULL, 0x004fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x020fe40000011431ULL, 0x00000018ffaf7819ULL, 0x000fe40000011430ULL,
0x00000018ffc47819ULL, 0x000fe40000011424ULL, 0x0000002c00c27306ULL, 0x000ea20000005400ULL,
0x00000018ffa37819ULL, 0x000fc40000011432ULL, 0x00000018ff9f7819ULL, 0x000fe40000011433ULL,
0x00000018ff667819ULL, 0x000fe40000011429ULL, 0x00000018ff4c7819ULL, 0x000fe2000001142aULL,
0x0000002c00867306ULL, 0x000722000000d400ULL, 0x00000018ff4b7819ULL, 0x000fe4000001142bULL,
0x00000018ff8f7819ULL, 0x000fe4000001148fULL, 0x00000018ff9a7819ULL, 0x000fc4000001149aULL,
0x00000018ff967819ULL, 0x000fe20000011496ULL, 0x000000c400247306ULL, 0x000fe20000209400ULL,
0x000100002c2c7824ULL, 0x008fe200078e00ffULL, 0x000000c2c100720bULL, 0x004fe40003f9d000ULL,
0x00000018ff8b7819ULL, 0x000fe4000001148bULL, 0x00000018ffca7819ULL, 0x000fe2000001142cULL,
0x000100002f2c7824ULL, 0x000fe200078e00ffULL, 0x000000c400c97306ULL, 0x000ea20000205400ULL,
0x00000018ff797819ULL, 0x000fc40000011479ULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000000186864812ULL, 0x010fe200078efcffULL,
0x0000002500997306ULL, 0x000ff00000009400ULL, 0x0000002500a07306ULL, 0x000fe20000005400ULL,
0x000000c92400720bULL, 0x004fce0003f5d000ULL, 0x00000025006a7306ULL, 0x0005f0000000d400ULL,
0x0000002d00d07306ULL, 0x000fe20000009400ULL, 0x000001002d257824ULL, 0x004fca00078e00ffULL,
0x00000018ffd27819ULL, 0x000fe20000011425ULL, 0x000001002e257824ULL, 0x000fe200078e00ffULL,
0x0000002d00d17306ULL, 0x000ea40000005400ULL, 0x000000d200c17245ULL, 0x000fe4000020d400ULL,
0x00000018ffda7819ULL, 0x000fe20000011425ULL, 0x0000010030257824ULL, 0x000fc600078e00ffULL,
0x000000cd00ce7306ULL, 0x000fe40000209400ULL, 0x00000018ff257819ULL, 0x000fcc0000011425ULL,
0x000000cd00cf7306ULL, 0x000ee20000205400ULL, 0x000000d1d000720bULL, 0x004fce0003fbd000ULL,
0x000000ca00cb7306ULL, 0x000ff00000209400ULL, 0x000000ca00cc7306ULL, 0x000ea20000205400ULL,
0x000000cfce00720bULL, 0x008fe20003fdd000ULL, 0x0001000033ce7824ULL, 0x000fca00078e00ffULL,
0x00000018ffce7819ULL, 0x000fe200000114ceULL, 0x0000002d00827306ULL, 0x000730000000d400ULL,
0x000000bf00d87306ULL, 0x000fe20000209400ULL, 0x000100002d2d7824ULL, 0x008fe200078e00ffULL,
0x000000cccb00720bULL, 0x004fc80003f7d000ULL, 0x00000018ffd57819ULL, 0x000fe2000001142dULL,
0x00000100312d7824ULL, 0x000fe200078e00ffULL, 0x000000bf00d97306ULL, 0x0004e20000205400ULL,
0x0000000182825812ULL, 0x010fc600078efcffULL, 0x00000018ff247819ULL, 0x000fe4000001142dULL,
0x000000c4002d7245ULL, 0x000fe2000020d400ULL, 0x0001000030c47824ULL, 0x000fe200078e00ffULL,
0x000000d200d37306ULL, 0x000fe20000209400ULL, 0x000000bf00bf7245ULL, 0x004fe4000020d400ULL,
0x000000012d2d2812ULL, 0x000fe400078efcffULL, 0x00000018ffc47819ULL, 0x000fc600000114c4ULL,
0x000000d200d47306ULL, 0x000ea20000205400ULL, 0x000000d9d800720bULL, 0x008fce0003f9d000ULL,
0x0000002e00c07306ULL, 0x000fec0000009400ULL, 0x00000001bfbf4812ULL, 0x000fe400078efcffULL,
0x0000002e00c37306ULL, 0x000ee20000005400ULL, 0x000000d4d300720bULL, 0x004fce0003f5d000ULL,
0x000000d500d67306ULL, 0x000fec0000209400ULL, 0x00000001c1c12812ULL, 0x000fe400078efcffULL,
0x000000d500d77306ULL, 0x000fe20000205400ULL, 0x000000c3c000720bULL, 0x008fce0003fbd000ULL,
0x000000da00db7306ULL, 0x000ff00000209400ULL, 0x000000da00dc7306ULL, 0x000ff00000205400ULL,
0x000000c500df7306ULL, 0x000ff00000209400ULL, 0x000000c500e07306ULL, 0x000eb00000205400ULL,
0x0000002e007c7306ULL, 0x000730000000d400ULL, 0x0000002f00bd7306ULL, 0x000fe20000009400ULL,
0x000000ca002e7245ULL, 0x008fc4000020d400ULL, 0x000000e0df00720bULL, 0x004fe40003f9d000ULL,
0x000000012e2e3812ULL, 0x000fe400078efcffULL, 0x000000d7d600720bULL, 0x000fe20003f7d000ULL,
0x0000002f00be7306ULL, 0x000fe20000005400ULL, 0x000000017c7c5812ULL, 0x010fce00078efcffULL,
0x0000002f007a7306ULL, 0x0005f0000000d400ULL, 0x000000ba00bb7306ULL, 0x000fe20000209400ULL,
0x000000cd002f7245ULL, 0x004fe2000020d400ULL, 0x0000010033cd7824ULL, 0x000fc600078e00ffULL,
0x000000012f2f6812ULL, 0x000fe400078efcffULL, 0x000000dcdb00720bULL, 0x000fe20003fdd000ULL,
0x000000ba00bc7306ULL, 0x000ea20000205400ULL, 0x00000018ffcd7819ULL, 0x000fe400000114cdULL,
0x0000002e2f2e723eULL, 0x000fca00000010ffULL, 0x000000c600dd7306ULL, 0x000ff00000209400ULL,
0x000000c600de7306ULL, 0x000ee20000205400ULL, 0x000000bcbb00720bULL, 0x004fce0003fbd000ULL,
0x0000003100b47306ULL, 0x000ff00000009400ULL, 0x0000003100b37306ULL, 0x000ff00000005400ULL,
0x0000003100757306ULL, 0x0005f0000000d400ULL, 0x0000003000b67306ULL, 0x000fe20000009400ULL,
0x0001000031317824ULL, 0x004fca00078e00ffULL, 0x00000018ffc07819ULL, 0x000fe40000011431ULL,
0x0000003000b77306ULL, 0x000fe20000005400ULL, 0x000000da00317245ULL, 0x000fc8000020d400ULL,
0x0000000131316812ULL, 0x000fe400078efcffULL, 0x000000dedd00720bULL, 0x008fe20003fdd000ULL,
0x0000003000767306ULL, 0x0005f0000000d400ULL, 0x000000b500b87306ULL, 0x000fe20000209400ULL,
0x00009910b2307816ULL, 0x004fe200000000ffULL, 0x0000010032b27824ULL, 0x000fc600078e00ffULL,
0x000000ff3000720cULL, 0x000fe40003f45270ULL, 0x000000d500307245ULL, 0x000fe2000020d400ULL,
0x000000b500b97306ULL, 0x000ea20000205400ULL, 0x00000018ffcc7819ULL, 0x000fe400000114b2ULL,
0x0000000130303812ULL, 0x000fe400078efcffULL, 0x000000bebd00720bULL, 0x000fe40003f7d000ULL,
0x000000c500bd7245ULL, 0x000fe2000020d400ULL, 0x0000002500e17306ULL, 0x000fe20000209400ULL,
0x000000c600b27245ULL, 0x000fc4000020d400ULL, 0x00000001bdbd4812ULL, 0x000fe400078efcffULL,
0x00000001b2b26812ULL, 0x000fe400078efcffULL, 0x00000030bf2f723eULL, 0x000fe200000010ffULL,
0x0000002500e27306ULL, 0x000ee20000205400ULL, 0x000000b9b800720bULL, 0x004fe40003f9d000ULL,
0x000000ba00b97245ULL, 0x000fe2000020d400ULL, 0x0001000029ba7824ULL, 0x000fe200078e00ffULL,
0x000000017a7a3812ULL, 0x000fc400078efcffULL, 0x00000001b9b95812ULL, 0x000fe200078efcffULL,
0x0000002400c27306ULL, 0x000fe20000209400ULL, 0x000000b7b600720bULL, 0x000fe40003fbd000ULL,
0x000000b500b77245ULL, 0x000fe4000020d400ULL, 0x0000002500b57245ULL, 0x000fe4000020d400ULL,
0x00000001b7b74812ULL, 0x000fe200078efcffULL, 0x0000002400cb7306ULL, 0x000ea20000205400ULL,
0x000000e2e100720bULL, 0x008fc40003fdd000ULL, 0x0000002400b87245ULL, 0x000fe4000020d400ULL,
0x0000002c00b67245ULL, 0x000fe4000020d400ULL, 0x0000000176765812ULL, 0x000fe200078efcffULL,
0x0000002c00c77306ULL, 0x000fe20000209400ULL, 0x0000007900307245ULL, 0x000fe4000020d400ULL,
0x00000018ffba7819ULL, 0x000fc600000114baULL, 0x00000001b5b56812ULL, 0x000fe400078efcffULL,
0x0000002c00c87306ULL, 0x000ee20000205400ULL, 0x000000cbc200720bULL, 0x004fe20003f9d000ULL,
0x0000010029cb7824ULL, 0x000fe200078e00ffULL, 0x00000076b576723eULL, 0x000fca00000010ffULL,
0x000000c400c97306ULL, 0x000fec0000209400ULL, 0x00000001b8b84812ULL, 0x000fe400078efcffULL,
0x000000c400ca7306ULL, 0x000ea20000205400ULL, 0x000000c8c700720bULL, 0x008fe20003f7d000ULL,
0x0001000026c77824ULL, 0x000fc400078e00ffULL, 0x0001000027c87824ULL, 0x000fc800078e00ffULL,
0x000000c000c37306ULL, 0x000fe20000209400ULL, 0x00000018ffc87819ULL, 0x000fca00000114c8ULL,
0x00000001b6b63812ULL, 0x000fe400078efcffULL, 0x000000c000be7306ULL, 0x000ee20000205400ULL,
0x000000cac900720bULL, 0x004fe20003fdd000ULL, 0x0000010028c97824ULL, 0x000fe200078e00ffULL,
0x000000b3b400720bULL, 0x000fe20003f7d000ULL, 0x0001000028ca7824ULL, 0x000fe400078e00ffULL,
0x000001002ab47824ULL, 0x000fe200078e00ffULL, 0x00000018ffc97819ULL, 0x000fe200000114c9ULL,
0x000000af00b17306ULL, 0x000fe20000209400ULL, 0x000001002bb37824ULL, 0x000fe200078e00ffULL,
0x00000018ffca7819ULL, 0x000fc400000114caULL, 0x00000018ffb47819ULL, 0x000fe400000114b4ULL,
0x00000018ffb37819ULL, 0x000fe400000114b3ULL, 0x000000af00b07306ULL, 0x0005220000205400ULL,
0x000000bec300720bULL, 0x008fe40003f9d000ULL, 0x0000000175753812ULL, 0x000fca00078efcffULL,
0x0000003200ac7306ULL, 0x000fe20000009400ULL, 0x000000af00af7245ULL, 0x004fce000020d400ULL,
0x0000003200ab7306ULL, 0x000ea20000005400ULL, 0x000000b0b100720bULL, 0x010fe40003fbd000ULL,
0x000000c400b07245ULL, 0x000fc8000020d400ULL, 0x00000001b0b06812ULL, 0x000fe200078efcffULL,
0x0000003300a97306ULL, 0x000fec0000009400ULL, 0x00000001afaf5812ULL, 0x000fe400078efcffULL,
0x0000003300a87306ULL, 0x000ee20000005400ULL, 0x000000abac00720bULL, 0x004fc40003fdd000ULL,
0x000000c000ab7245ULL, 0x000fe4000020d400ULL, 0x00000018ffac7819ULL, 0x000fe400000114c7ULL,
0x00000001abab4812ULL, 0x000fe200078efcffULL, 0x000000cc00bb7306ULL, 0x000fe20000209400ULL,
0x000000b0afb0723eULL, 0x000fce00000010ffULL, 0x000000cc00bc7306ULL, 0x000ea20000205400ULL,
0x000000a8a900720bULL, 0x008fe40003f9d000ULL, 0x000000cc00a87245ULL, 0x000fe4000020d400ULL,
0x00000041ffa9723eULL, 0x000fc600000010ffULL, 0x00000032006f7306ULL, 0x000730000000d400ULL,
0x000000aa00ae7306ULL, 0x000fe20000209400ULL, 0x0001000032327824ULL, 0x008fe200078e00ffULL,
0x000000bcbb00720bULL, 0x004fc80003fbd000ULL, 0x00000018ffc27819ULL, 0x000fe20000011432ULL,
0x000100002b327824ULL, 0x000fe200078e00ffULL, 0x000000aa00ad7306ULL, 0x0004e20000205400ULL,
0x000000016f6f6812ULL, 0x010fc600078efcffULL, 0x00000018ff327819ULL, 0x000fc60000011432ULL,
0x00000001a8a85812ULL, 0x000fe200078efcffULL, 0x00000033006e7306ULL, 0x000962000000d400ULL,
0x000000aa00aa7245ULL, 0x004fe4000020d400ULL, 0x0000006fa8a8723eULL, 0x000fca00000010ffULL,
0x0000009f00a47306ULL, 0x000fe20000209400ULL, 0x000100002a337824ULL, 0x010fe200078e00ffULL,
0x000000adae00720bULL, 0x008fe40003f7d000ULL, 0x00000002ffad7819ULL, 0x000fe40000011636ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000009f00a57306ULL, 0x0004e20000205400ULL,
0x000000016e6e4812ULL, 0x020fcc00078efcffULL, 0x00000001aaaa3812ULL, 0x000fe200078efcffULL,
0x000000c2002c7306ULL, 0x000fe20000209400ULL, 0x0000009f009f7245ULL, 0x004fce000020d400ULL,
0x000000c200b17306ULL, 0x000ea20000205400ULL, 0x000000a5a400720bULL, 0x008fce0003f9d000ULL,
0x000000cd00c57306ULL, 0x000fec0000209400ULL, 0x000000019f9f4812ULL, 0x000fe400078efcffULL,
0x000000cd00c67306ULL, 0x000ee20000205400ULL, 0x000000b12c00720bULL, 0x004fe40003fbd000ULL,
0x00005410a9b17816ULL, 0x000fc400000000a9ULL, 0x000000cd00a97245ULL, 0x000fc6000020d400ULL,
0x00000026008d7306ULL, 0x000fe20000009400ULL, 0x00001f54b12c7589ULL, 0x000fe800000e0000ULL,
0x00001fadb1ad7589ULL, 0x0005e600000e0000ULL, 0x00000026008a7306ULL, 0x000fe20000005400ULL,
0x000000c6c500720bULL, 0x008fe40003f7d000ULL, 0x000000abaab1723eULL, 0x004fca00000010ffULL,
0x0000002600007306ULL, 0x000fec000000d400ULL, 0x00000001a9a93812ULL, 0x000fe400078efcffULL,
0x0000002700887306ULL, 0x000fe40000009400ULL, 0x0000006ea9a9723eULL, 0x000fcc00000010ffULL,
0x0000002700837306ULL, 0x000ff00000005400ULL, 0x0000002700637306ULL, 0x0005f0000000d400ULL,
0x0000002800807306ULL, 0x000fe20000009400ULL, 0x00a000005324783bULL, 0x004eae0000000200ULL,
0x00000028007d7306ULL, 0x000ff00000005400ULL, 0x0000002800607306ULL, 0x000ff0000000d400ULL,
0x00000029007e7306ULL, 0x000ff00000009400ULL, 0x00000029007b7306ULL, 0x000ff00000005400ULL,
0x0000002900687306ULL, 0x000fe2000000d400ULL, 0x0000002c2525a231ULL, 0x004fc400003400ffULL,
0x0000002c2727a231ULL, 0x000fe400003400ffULL, 0x000000ad2424a231ULL, 0x080fe400003400ffULL,
0x000000ad2626a231ULL, 0x000fe200003400ffULL, 0x0000002a00707306ULL, 0x000ff00000009400ULL,
0x0000002a006d7306ULL, 0x000ff00000005400ULL, 0x0000002a004d7306ULL, 0x000ff0000000d400ULL,
0x0000002b006b7306ULL, 0x000ff00000009400ULL, 0x0000002b006c7306ULL, 0x000ff00000005400ULL,
0x0000002b00657306ULL, 0x0005f0000000d400ULL, 0x000000a300a67306ULL, 0x000fe20000209400ULL,
0x00a000005228783bULL, 0x004eae0000000200ULL, 0x000000a300a77306ULL, 0x0007300000205400ULL,
0x0000008f009d7306ULL, 0x000fe20000209400ULL, 0x000000a300a37245ULL, 0x008fce000020d400ULL,
0x0000008f00a27306ULL, 0x0007620000205400ULL, 0x000000a7a600720bULL, 0x010fe40003fdd000ULL,
0x000000c200a67245ULL, 0x000fc8000020d400ULL, 0x00000001a6a65812ULL, 0x000fe200078efcffULL,
0x000000ce00ae7306ULL, 0x000fe20000209400ULL, 0x000000918c00720bULL, 0x000fe40003fbd000ULL,
0x0000008f008f7245ULL, 0x008fe4000020d400ULL, 0x000000ce008c7245ULL, 0x000fe4000020d400ULL,
0x00000001a3a36812ULL, 0x000fe200078efcffULL, 0x000000ce00bb7306ULL, 0x000ee20000205400ULL,
0x000000a29d00720bULL, 0x020fe20003f9d000ULL, 0x0000002c2929a231ULL, 0x084fe200003400ffULL,
0x000000a09900720bULL, 0x000fe20003fdd000ULL, 0x0000002c2b2ba231ULL, 0x000fe200003400ffULL,
0x000000862d2c723eULL, 0x000fe200000010ffULL, 0x000000ad2828a231ULL, 0x080fe200003400ffULL,
0x0000000169695812ULL, 0x000fe200078efcffULL, 0x0000007f00907306ULL, 0x000fe20000209400ULL,
0x0000008a8d00720bULL, 0x000fe20003fbd000ULL, 0x000000ad2a2aa231ULL, 0x000fe200003400ffULL,
0x00000082c12d723eULL, 0x000fc400000010ffULL, 0x0000007f00827245ULL, 0x000fe4000020d400ULL,
0x000000018f8f4812ULL, 0x000fe200078efcffULL, 0x0000007f00897306ULL, 0x000ea20000205400ULL,
0x000000bbae00720bULL, 0x008fe20003f7d000ULL, 0x0000002c2804723cULL, 0x040fe20000041804ULL,
0x000000016a6a6812ULL, 0x000fe400078efcffULL, 0x00000018ff917819ULL, 0x000fe400000114cbULL,
0x0000000100005812ULL, 0x000fe200078efcffULL, 0x0000009a009b7306ULL, 0x000fe20000209400ULL,
0x0000007c312c723eULL, 0x000fe200000010ffULL, 0x0000002e2808723cULL, 0x000fe20000041808ULL,
0x0000007abd2d723eULL, 0x000fc400000010ffULL, 0x000000c800ad7245ULL, 0x000fe4000020d400ULL,
0x000000018c8c3812ULL, 0x000fe200078efcffULL, 0x0000009a009c7306ULL, 0x0007220000205400ULL,
0x000000899000720bULL, 0x004fe20003f9d000ULL, 0x0000002c280c723cULL, 0x040fe2000004180cULL,
0x000000b2b92e723eULL, 0x000fe400000010ffULL, 0x000000b6b72f723eULL, 0x000fe400000010ffULL,
0x0000008c9f9f723eULL, 0x000fe200000010ffULL, 0x00000096009e7306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x008fe2000020d400ULL, 0x000000b02818723cULL, 0x000fe20000041818ULL,
0x00000074002d7245ULL, 0x000fc4000020d400ULL, 0x00000071002c7245ULL, 0x000fe4000020d400ULL,
0x0000000182824812ULL, 0x000fe200078efcffULL, 0x0000009600a17306ULL, 0x0004e20000205400ULL,
0x0000009c9b00720bULL, 0x010fe20003f7d000ULL, 0x0000002e2810723cULL, 0x000fe20000041810ULL,
0x000000ba00cb7245ULL, 0x000fca000020d400ULL, 0x0000008b00947306ULL, 0x000fe20000209400ULL,
0x0000009600967245ULL, 0x004fe2000020d400ULL, 0x000000a8281c723cULL, 0x000fe8000004181cULL,
0x000000019a9a3812ULL, 0x000fe400078efcffULL, 0x0000008b00937306ULL, 0x000ea20000205400ULL,
0x000000a19e00720bULL, 0x008fe40003f5d000ULL, 0x000000a6a39e723eULL, 0x000fc400000010ffULL,
0x000000699a9a723eULL, 0x000fc600000010ffULL, 0x0000007900847306ULL, 0x000fe40000209400ULL,
0x0000009e2820723cULL, 0x000fe80000041820ULL, 0x0000000196962812ULL, 0x000fe400078efcffULL,
0x0000007900857306ULL, 0x000ee20000205400ULL, 0x000000939400720bULL, 0x004fe40003fdd000ULL,
0x000000838800720bULL, 0x000fca0003f5d000ULL, 0x0000007400787306ULL, 0x000ff00000209400ULL,
0x0000007400777306ULL, 0x000ea20000205400ULL, 0x000000858400720bULL, 0x008fe40003f9d000ULL,
0x0000000163632812ULL, 0x000fca00078efcffULL, 0x0000008700977306ULL, 0x000fec0000209400ULL,
0x0000000130304812ULL, 0x000fe400078efcffULL, 0x0000008700987306ULL, 0x0007220000205400ULL,
0x000000777800720bULL, 0x004fe40003fbd000ULL, 0x00000075b877723eULL, 0x000fca00000010ffULL,
0x000000ac00bc7306ULL, 0x000fe20000209400ULL, 0x0000008700877245ULL, 0x008fe2000020d400ULL,
0x000000762814723cULL, 0x000fe80000041814ULL, 0x000000012d2d5812ULL, 0x000fe400078efcffULL,
0x000000ac00a77306ULL, 0x0004e20000205400ULL, 0x000000989700720bULL, 0x010fe40003f7d000ULL,
0x0000008b00977245ULL, 0x000fc4000020d400ULL, 0x000000633029723eULL, 0x000fe400000010ffULL,
0x0000000197976812ULL, 0x000fe200078efcffULL, 0x000000c9009b7306ULL, 0x000fe20000209400ULL,
0x0000007d8000720bULL, 0x000fe40003fdd000ULL, 0x000000ac00ac7245ULL, 0x004fe4000020d400ULL,
0x0000004a002b7245ULL, 0x000fe4000020d400ULL, 0x0000000187873812ULL, 0x000fe200078efcffULL,
0x000000c9009c7306ULL, 0x0005220000205400ULL, 0x000000a7bc00720bULL, 0x008fc40003f9d000ULL,
0x000000968796723eULL, 0x000fe400000010ffULL, 0x000000978297723eULL, 0x000fe400000010ffULL,
0x0000000160606812ULL, 0x000fe200078efcffULL, 0x0000007100727306ULL, 0x000fe20000209400ULL,
0x000000c900c97245ULL, 0x004fc6000020d400ULL, 0x000000962408723cULL, 0x000fe40000041808ULL,
0x00000001acac4812ULL, 0x000fe400078efcffULL, 0x0000007100737306ULL, 0x000ea20000205400ULL,
0x0000009c9b00720bULL, 0x010fe40003fbd000ULL, 0x0000006a8f9b723eULL, 0x000fe400000010ffULL,
0x000000ac2dac723eULL, 0x000fc600000010ffULL, 0x0000008100957306ULL, 0x000fe40000209400ULL,
0x0000009a2404723cULL, 0x000fe80000041804ULL, 0x00000001c9c95812ULL, 0x000fe400078efcffULL,
0x0000008100927306ULL, 0x0007220000205400ULL, 0x000000737200720bULL, 0x004fe40003f9d000ULL,
0x00000060c960723eULL, 0x000fca00000010ffULL, 0x000000c800a47306ULL, 0x000fe20000209400ULL,
0x0000008100817245ULL, 0x008fca000020d400ULL, 0x000000012c2c4812ULL, 0x000fe400078efcffULL,
0x000000c800997306ULL, 0x000ea20000205400ULL, 0x000000929500720bULL, 0x010fe40003f7d000ULL,
0x0000006c6b00720bULL, 0x000fca0003f9d000ULL, 0x00000091008a7306ULL, 0x000fec0000209400ULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x0000009100837306ULL, 0x0007220000205400ULL,
0x00000099a400720bULL, 0x004fe40003f5d000ULL, 0x0000007b7e00720bULL, 0x000fc40003f7d000ULL,
0x000000008128723eULL, 0x000fe400000010ffULL, 0x000000b300007245ULL, 0x000fe2000020d400ULL,
0x000000ca007f7306ULL, 0x000fe20000209400ULL, 0x0000009100917245ULL, 0x008fe4000020d400ULL,
0x0000000165654812ULL, 0x000fe200078efcffULL, 0x00000028240c723cULL, 0x000fe4000004180cULL,
0x00000001adad2812ULL, 0x000fe400078efcffULL, 0x000000ca00807306ULL, 0x0004e20000205400ULL,
0x000000838a00720bULL, 0x010fc40003fbd000ULL, 0x0000006d7000720bULL, 0x000fe40003f5d000ULL,
0x0000000168683812ULL, 0x000fe400078efcffULL, 0x000000ad2cad723eULL, 0x000fe200000010ffULL,
0x0000004a00497306ULL, 0x000fe20000209400ULL, 0x000000ca00ca7245ULL, 0x004fca000020d400ULL,
0x0000000191915812ULL, 0x000fe200078efcffULL, 0x000000ac2410723cULL, 0x000fe20000041810ULL,
0x0000004a004e7306ULL, 0x000ea20000205400ULL, 0x000000807f00720bULL, 0x008fe40003fdd000ULL,
0x000000014d4d2812ULL, 0x000fca00078efcffULL, 0x0000006600647306ULL, 0x000fec0000209400ULL,
0x00000001caca6812ULL, 0x000fe400078efcffULL, 0x00000066004f7306ULL, 0x0007220000205400ULL,
0x0000004e4900720bULL, 0x004fce0003fbd000ULL, 0x000000ba00317306ULL, 0x000fe20000209400ULL,
0x0000006600667245ULL, 0x008fca000020d400ULL, 0x000000012b2b5812ULL, 0x000fe400078efcffULL,
0x000000ba00787306ULL, 0x000ea20000205400ULL, 0x0000004f6400720bULL, 0x010fe40003fdd000ULL,
0x000000ca2bca723eULL, 0x000fca00000010ffULL, 0x000000b4002e7306ULL, 0x000fec0000209400ULL,
0x0000000166666812ULL, 0x000fe400078efcffULL, 0x000000b4002f7306ULL, 0x0007220000205400ULL,
0x000000783100720bULL, 0x004fce0003f7d000ULL, 0x000000b3006d7306ULL, 0x000fe20000209400ULL,
0x000000b400b47245ULL, 0x008fca000020d400ULL, 0x00000001cbcb3812ULL, 0x000fe400078efcffULL,
0x000000b3006c7306ULL, 0x000ea20000205400ULL, 0x0000002f2e00720bULL, 0x010fe40003fbd000ULL,
0x000000cb66cb723eULL, 0x000fca00000010ffULL, 0x0000004c00617306ULL, 0x000fe40000209400ULL,
0x000000ca2418723cULL, 0x000fe80000041818ULL, 0x00000001b4b45812ULL, 0x000fe400078efcffULL,
0x0000004c00627306ULL, 0x0007220000205400ULL, 0x0000006c6d00720bULL, 0x004fe40003fdd000ULL,
0x0000004db464723eULL, 0x000fc400000010ffULL, 0x00000032004d7245ULL, 0x000fc6000020d400ULL,
0x0000004b00507306ULL, 0x000fe20000209400ULL, 0x0000004c004c7245ULL, 0x008fca000020d400ULL,
0x0000000100006812ULL, 0x000fe400078efcffULL, 0x0000004b00517306ULL, 0x000ea20000205400ULL,
0x000000626100720bULL, 0x010fe40003f7d000ULL, 0x000000650065723eULL, 0x000fe400000010ffULL,
0x0000004b00007245ULL, 0x000fe4000020d400ULL, 0x000000689161723eULL, 0x000fe200000010ffULL,
0x00000033002a7306ULL, 0x000fe40000209400ULL, 0x00000064241c723cULL, 0x000fe8000004181cULL,
0x000000014c4c3812ULL, 0x000fc400078efcffULL, 0x0000003300317306ULL, 0x0007220000205400ULL,
0x000000515000720bULL, 0x004fe20003fbd000ULL, 0x000000602414723cULL, 0x000fec0000041814ULL,
0x0000003200307306ULL, 0x000fe20000209400ULL, 0x0000003300337245ULL, 0x008fca000020d400ULL,
0x0000000100005812ULL, 0x000fe400078efcffULL, 0x0000003200297306ULL, 0x000ea20000205400ULL,
0x000000312a00720bULL, 0x010fda0003f5d000ULL, 0x0000000133332812ULL, 0x000fe400078efcffULL,
0x000000293000720bULL, 0x004fe40003fdd000ULL, 0x000000334c4c723eULL, 0x000fe400000010ffULL,
0x00000002ff297819ULL, 0x000fd20000011602ULL, 0x000000014d4d6812ULL, 0x000fc800078efcffULL,
0x0000004d004d723eULL, 0x000fe400000010ffULL, 0x0000f63029007811ULL, 0x000fca00078e20ffULL,
0x0000004c2420723cULL, 0x000fe20000041820ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003eff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004029247824ULL, 0x000fe200078e0258ULL,
0x000000ff47ff7812ULL, 0x000fe2000784c0ffULL, 0x0000000000ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ff8eff7812ULL, 0x000fe4000786c0ffULL, 0x000000c024247810ULL, 0x000fe40007ffe0ffULL,
0x00000001ff307807ULL, 0x000fe40001000000ULL, 0x000000032400720cULL, 0x000fc40003f46070ULL,
0x0000000140637812ULL, 0x000fe400078ec0ffULL, 0x00000001ff647807ULL, 0x000fe40001800000ULL,
0x0000003067657207ULL, 0x000fe40004800000ULL, 0x0000000163637812ULL, 0x000fca00078e3cffULL,
0x0000295000002947ULL, 0x000fea0003800000ULL, 0x000024003e007984ULL, 0x008ee20000000800ULL,
0x8000000059257824ULL, 0x000fca00078e00ffULL, 0x8000000000ff7812ULL, 0x008fe20007844825ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000002947ULL, 0x000fea0003800000ULL,
0x000024003e007984ULL, 0x000ee40000000800ULL, 0x8000000000ff7812ULL, 0x008fe40007844825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000059597824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000240000735dULL, 0x010fe40003800000ULL, 0x000024003e247984ULL, 0x000ee40000000800ULL,
0x8000000024ff7812ULL, 0x008fc40007844859ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x00000001ff487819ULL, 0x000fe20000011602ULL,
0x00000080ff477424ULL, 0x000fe200078e00ffULL, 0x0000030034257a10ULL, 0x000fe40007ffe0ffULL,
0x00000003ff2d7819ULL, 0x000fe40000011636ULL, 0x0000000125247810ULL, 0x040fe20007ffe0ffULL,
0x0000000825007824ULL, 0x000fe200078e0248ULL, 0x000000042d2f7810ULL, 0x040fe40007ffe0ffULL,
0x000000352400720cULL, 0x000fe20003f46070ULL, 0x0000002000007824ULL, 0x000fe200078e00ffULL,
0x000000082d317810ULL, 0x000fc40007ffe0ffULL, 0x0000000c2d337810ULL, 0x000fe20007ffe0ffULL,
0x00006200382c7a24ULL, 0x000fe200078e0200ULL, 0x0000000003257217ULL, 0x000fc80007800000ULL,
0x0000002d2c247210ULL, 0x140fe20007ffe039ULL, 0x0000000125257824ULL, 0x000fe200078e0a00ULL,
0x0000002f2c267210ULL, 0x140fe40007ffe039ULL, 0x000000312c287210ULL, 0x000fe40007ffe039ULL,
0x0000002025007807ULL, 0x000fe20001000000ULL, 0x00005e0024247625ULL, 0x000fc600078e0047ULL,
0x0000000039007217ULL, 0x000fe20007800000ULL, 0x00005e0026267625ULL, 0x000fe200078e0047ULL,
0x00000045242a7210ULL, 0x000fe40007f5e0ffULL, 0x000000332c247210ULL, 0x000fe20007ffe039ULL,
0x00005e0028287625ULL, 0x000fe200078e0047ULL, 0x0000004526267210ULL, 0x000fc60007f9e0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a39ULL, 0x0000004528287210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2b7224ULL, 0x000fe400010e0625ULL, 0x00005e0024247625ULL, 0x000fe200078e0047ULL,
0x000000002d00720cULL, 0x080fe40003f46070ULL, 0x000000002f00720cULL, 0x080fe20003f66070ULL,
0x000000ffff277224ULL, 0x000fe200020e0627ULL, 0x000000003100720cULL, 0x080fe20003f86070ULL,
0x000000ffff297224ULL, 0x000fe200028e0629ULL, 0x000000003300720cULL, 0x000fc40003fa6070ULL,
0x0000004524247210ULL, 0x000fca0007fde0ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a5b7faeULL, 0x0007e8000d101c48ULL,
0x00000000265c7faeULL, 0x0007e8000d901c48ULL, 0x00000000285d7faeULL, 0x0007e8000e101c48ULL,
0x00000000245e7faeULL, 0x0007e8000e901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000004005a257984ULL, 0x0087220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f63c0042247984ULL, 0x000f620000000800ULL, 0x0000003067677207ULL, 0x000fe20004800000ULL,
0x8000000043277824ULL, 0x000fc600078e00ffULL, 0x0000ffff67287812ULL, 0x000fca00078ec0ffULL,
0x8000000028007824ULL, 0x000fca00078e00ffULL, 0x8000000025ff7812ULL, 0x010fe40007844800ULL,
0x8000000024ff7812ULL, 0x020fe20007864827ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000003947ULL, 0x000fea0003800000ULL, 0x8000000043437824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x000964000021f000ULL,
0x3fa0000000007823ULL, 0x010fe200000100ffULL, 0x000000240000735dULL, 0x020fe40003800000ULL,
0x00f63c0042247984ULL, 0x000f240000000800ULL, 0x8000000024ff7812ULL, 0x010fc40007864843ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000b947ULL, 0x000fea000383ffffULL,
0x0000018045257810ULL, 0x000fe20007ffe044ULL, 0x00000001ff6a7424ULL, 0x000fc800078e00ffULL,
0x0000000146257824ULL, 0x000fca00078e0225ULL, 0x00f0000025277984ULL, 0x000f280000000800ULL,
0x00f2000025007984ULL, 0x0002a20000000800ULL, 0x0000003c2700720bULL, 0x010fda0003f7d000ULL,
0x0000000000247806ULL, 0x000fc800018e0100ULL, 0x0000ffff24297812ULL, 0x000fda000786c0ffULL,
0x000003700000b947ULL, 0x000fea0003800000ULL, 0x0000003c2700720bULL, 0x006fe40003f74000ULL,
0x000000273c2b7209ULL, 0x000fe40007810000ULL, 0x0000000302257811ULL, 0x000fe400078ff0ffULL,
0x00000002ff2d7819ULL, 0x000fe20000011636ULL, 0x8000002b3c247221ULL, 0x100fe20000010000ULL,
0x000000ffff3c7224ULL, 0x000fc600078e002bULL, 0x3fb8aa3b24267820ULL, 0x000fe40000410000ULL,
0x0000000000247806ULL, 0x000fe400018e0100ULL, 0x000000022500720cULL, 0x000fe40003f65270ULL,
0x0000ffff242a7812ULL, 0x000fe200078e3cffULL, 0x0000002600267308ULL, 0x000e660000000800ULL,
0x0000002a29ff7212ULL, 0x000fc8000788c0ffULL, 0x00000001ff6a7807ULL, 0x000fc60002000000ULL,
0x000000800245b824ULL, 0x000fc800078e0245ULL, 0x000000014646b824ULL, 0x000fe200078e0245ULL,
0x00001f2d26247589ULL, 0x002e6200000e0000ULL, 0x8000002b27274221ULL, 0x000fe20000010000ULL,
0x000000263d3d7220ULL, 0x000fe40000410000ULL, 0x00001f5426257589ULL, 0x000ea200000e0000ULL,
0x3fb8aa3b27274820ULL, 0x000fc60000410000ULL, 0x00f4002b4600b388ULL, 0x0009e20000000800ULL,
0x0000002700414308ULL, 0x000f620000000800ULL, 0x0000002404047220ULL, 0x082fe20000410000ULL,
0x0000002405057220ULL, 0x080fe20000410000ULL, 0x0000002408087220ULL, 0x080fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002420207220ULL, 0x080fe20000410000ULL,
0x0000002421217220ULL, 0x000fe20000410000ULL, 0x0000002506067220ULL, 0x084fe20000410000ULL,
0x0000002507077220ULL, 0x080fe20000410000ULL, 0x000000250a0a7220ULL, 0x080fe20000410000ULL,
0x000000250b0b7220ULL, 0x080fe20000410000ULL, 0x000000250e0e7220ULL, 0x080fe20000410000ULL,
0x000000250f0f7220ULL, 0x080fe20000410000ULL, 0x0000002512127220ULL, 0x080fe20000410000ULL,
0x0000002513137220ULL, 0x080fe20000410000ULL, 0x0000002516167220ULL, 0x080fe20000410000ULL,
0x0000002517177220ULL, 0x080fe20000410000ULL, 0x000000251a1a7220ULL, 0x080fe20000410000ULL,
0x000000251b1b7220ULL, 0x080fe20000410000ULL, 0x000000251e1e7220ULL, 0x080fe20000410000ULL,
0x000000251f1f7220ULL, 0x080fe20000410000ULL, 0x0000002522227220ULL, 0x080fe20000410000ULL,
0x0000002523237220ULL, 0x000fe20000410000ULL, 0x0000000041004220ULL, 0x020fc80000410000ULL,
0x0000003d003d7221ULL, 0x016fe20000010000ULL, 0x0000013000002947ULL, 0x000fea0003800000ULL,
0x0000000840007824ULL, 0x000fe400078e00ffULL, 0x0000000802247824ULL, 0x000fc400078e00ffULL,
0x8000000028277824ULL, 0x000fe200078e00ffULL, 0x0000000800007812ULL, 0x000fe400078e0cffULL,
0xfffffff024257812ULL, 0x000fca00078ec0ffULL, 0x0000000100257824ULL, 0x000fca00078e0225ULL,
0x00f64c0025007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007844827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000028277824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x004fe40003800000ULL, 0x00f64c0025247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fc40007844827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000005f5c783bULL, 0x000e680000004200ULL,
0x000000005524783bULL, 0x000ea80000004200ULL, 0x000000005628783bULL, 0x000f280000004200ULL,
0x00000000572c783bULL, 0x000f620000004200ULL, 0x000001005c937824ULL, 0x002fe200078e00ffULL,
0x0000005c009f7306ULL, 0x000fe20000009400ULL, 0x00000018ffb47819ULL, 0x000fe2000001145cULL,
0x000100005dca7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa17819ULL, 0x000fe2000001145dULL,
0x000001005eb37824ULL, 0x040fe200078e00ffULL, 0x00000018ffb87819ULL, 0x000fe20000011493ULL,
0x000001005faa7824ULL, 0x040fe200078e00ffULL, 0x00000018ffca7819ULL, 0x000fe200000114caULL,
0x0000005c00ac7306ULL, 0x000e620000005400ULL, 0x00000018ffb37819ULL, 0x000fe200000114b3ULL,
0x000100005eb07824ULL, 0x000fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x000100005fb17824ULL, 0x000fe200078e00ffULL, 0x00000018ff987819ULL, 0x000fe2000001145eULL,
0x0000010024a97824ULL, 0x044fe200078e00ffULL, 0x00000018ffb07819ULL, 0x000fe200000114b0ULL,
0x0000005c00737306ULL, 0x0004e2000000d400ULL, 0x00000018ffb17819ULL, 0x000fe200000114b1ULL,
0x0000010025a87824ULL, 0x000fe200078e00ffULL, 0x00000018ffa97819ULL, 0x000fe200000114a9ULL,
0x0001000024ae7824ULL, 0x000fe200078e00ffULL, 0x00000018ff967819ULL, 0x000fe2000001145fULL,
0x0001000027937824ULL, 0x000fe200078e00ffULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x000000b800a77306ULL, 0x000fe20000209400ULL, 0x000100005c5c7824ULL, 0x004fe200078e00ffULL,
0x000000ac9f00720bULL, 0x002fe20003fdd000ULL, 0x0000010028a37824ULL, 0x010fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe200000114aeULL, 0x000100002ab57824ULL, 0x000fe200078e00ffULL,
0x00000018ffcb7819ULL, 0x000fe2000001145cULL, 0x000001005d5c7824ULL, 0x000fe200078e00ffULL,
0x000000b800be7306ULL, 0x0002a20000205400ULL, 0x00000018ff8a7819ULL, 0x000fe20000011424ULL,
0x000100002ba67824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe20000011425ULL,
0x000001002cac7824ULL, 0x020fe200078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe2000001145cULL,
0x00000100275c7824ULL, 0x000fe200078e00ffULL, 0x0000000173736812ULL, 0x008fe200078efcffULL,
0x000000cb00ab7306ULL, 0x000fe20000209400ULL, 0x000000b800b87245ULL, 0x002fe2000020d400ULL,
0x000001002dad7824ULL, 0x040fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe20000011426ULL,
0x000100002d9f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fc40000011427ULL,
0x00000018ff827819ULL, 0x000fe20000011428ULL, 0x000000cb00cc7306ULL, 0x000e620000205400ULL,
0x000000bea700720bULL, 0x004fe20003f7d000ULL, 0x000100002ca77824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011429ULL, 0x00000018ff647819ULL, 0x000fe4000001142aULL,
0x00000018ff617819ULL, 0x000fe2000001142bULL, 0x000000b400c57306ULL, 0x000fe20000209400ULL,
0x00000018ff5c7819ULL, 0x000fc4000001145cULL, 0x00000018ff937819ULL, 0x000fe40000011493ULL,
0x00000018ffa37819ULL, 0x000fe400000114a3ULL, 0x00000001b8b83812ULL, 0x000fe200078efcffULL,
0x000000b400ce7306ULL, 0x0004e20000205400ULL, 0x000000ccab00720bULL, 0x002fe40003fbd000ULL,
0x00000018ffa67819ULL, 0x000fe400000114a6ULL, 0x00000018ffac7819ULL, 0x000fc400000114acULL,
0x00000018ff497819ULL, 0x000fe2000001142dULL, 0x0000005d00c87306ULL, 0x000fe20000009400ULL,
0x000000b400b47245ULL, 0x004fe4000020d400ULL, 0x00000018ffad7819ULL, 0x000fe400000114adULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x00000018ff457819ULL, 0x000fe2000001142cULL,
0x0000005d00c37306ULL, 0x000e620000005400ULL, 0x000000cec500720bULL, 0x008fc40003f5d000ULL,
0x00000018ff4c7819ULL, 0x000fe4000001142eULL, 0x00000018ff9f7819ULL, 0x000fe4000001149fULL,
0x00000018ff4f7819ULL, 0x000fe2000001142fULL, 0x000000cd00cf7306ULL, 0x000fec0000209400ULL,
0x00000001b4b42812ULL, 0x000fc400078efcffULL, 0x000000cd00d07306ULL, 0x000ea20000205400ULL,
0x000000c3c800720bULL, 0x002fe40003f9d000ULL, 0x000000cb00c37245ULL, 0x000fc8000020d400ULL,
0x00000001c3c35812ULL, 0x000fe200078efcffULL, 0x000000a100b67306ULL, 0x000fe60000209400ULL,
0x000000c3b4b4723eULL, 0x000fca00000010ffULL, 0x000000a100af7306ULL, 0x0002e20000205400ULL,
0x000000d0cf00720bULL, 0x004fce0003f7d000ULL, 0x000000ca00d17306ULL, 0x000fe20000209400ULL,
0x000000a100a17245ULL, 0x002fce000020d400ULL, 0x000000ca00d27306ULL, 0x000e620000205400ULL,
0x000000afb600720bULL, 0x008fe40003fdd000ULL, 0x000000cd00af7245ULL, 0x000fc8000020d400ULL,
0x00000001afaf3812ULL, 0x000fe200078efcffULL, 0x0000005d00727306ULL, 0x0004ec000000d400ULL,
0x00000001a1a16812ULL, 0x000fe400078efcffULL, 0x000000b300d37306ULL, 0x000fe20000209400ULL,
0x000000d2d100720bULL, 0x002fe20003fbd000ULL, 0x00000100265d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x000000b300d47306ULL, 0x000e620000205400ULL,
0x0000000172724812ULL, 0x008fc800078efcffULL, 0x00000072afaf723eULL, 0x000fc600000010ffULL,
0x0000005e00a57306ULL, 0x000ff00000009400ULL, 0x0000005e00a47306ULL, 0x000ea20000005400ULL,
0x000000d4d300720bULL, 0x002fce0003f5d000ULL, 0x000000aa00c77306ULL, 0x000ff00000209400ULL,
0x000000aa00d87306ULL, 0x0002e20000205400ULL, 0x000000a4a500720bULL, 0x004fe40003f7d000ULL,
0x000000ca00a47245ULL, 0x000fc8000020d400ULL, 0x00000001a4a45812ULL, 0x000fe200078efcffULL,
0x000000b000c97306ULL, 0x000fe20000209400ULL, 0x000000aa00aa7245ULL, 0x002fce000020d400ULL,
0x000000b000d67306ULL, 0x0002a20000205400ULL, 0x000000d8c700720bULL, 0x008fce0003f9d000ULL,
0x0000005f00a07306ULL, 0x000fe20000009400ULL, 0x000000b000b07245ULL, 0x002fca000020d400ULL,
0x00000001aaaa4812ULL, 0x000fe400078efcffULL, 0x0000005f009d7306ULL, 0x000e620000005400ULL,
0x000000d6c900720bULL, 0x004fce0003fdd000ULL, 0x00000098009e7306ULL, 0x000fec0000209400ULL,
0x00000001b0b06812ULL, 0x000fe400078efcffULL, 0x00000098009b7306ULL, 0x000ea20000205400ULL,
0x0000009da000720bULL, 0x002fe40003fbd000ULL, 0x000000b300a07245ULL, 0x000fc8000020d400ULL,
0x00000001a0a02812ULL, 0x000fe200078efcffULL, 0x000000b100c17306ULL, 0x000ff00000209400ULL,
0x000000b100c67306ULL, 0x0002e20000205400ULL, 0x0000009b9e00720bULL, 0x004fce0003f5d000ULL,
0x0000005f006b7306ULL, 0x000ea2000000d400ULL, 0x000000b100b17245ULL, 0x002fce000020d400ULL,
0x000000a900bc7306ULL, 0x000fe20000209400ULL, 0x000000c6c100720bULL, 0x008fce0003f9d000ULL,
0x000000a900b77306ULL, 0x0002e20000205400ULL, 0x000000016b6b5812ULL, 0x004fc800078efcffULL,
0x0000006baa6b723eULL, 0x000fe400000010ffULL, 0x00000001b1b14812ULL, 0x000fe200078efcffULL,
0x00000096009a7306ULL, 0x000fe20000209400ULL, 0x000000a900a97245ULL, 0x002fce000020d400ULL,
0x0000009600977306ULL, 0x0002a20000205400ULL, 0x000000b7bc00720bULL, 0x008fce0003fdd000ULL,
0x000000a800b97306ULL, 0x000fe20000209400ULL, 0x0000009600967245ULL, 0x002fca000020d400ULL,
0x00000001a9a96812ULL, 0x000fe400078efcffULL, 0x000000a800c07306ULL, 0x0002e20000205400ULL,
0x000000979a00720bULL, 0x004fe40003fbd000ULL, 0x0000009800977245ULL, 0x000fc8000020d400ULL,
0x0000000197972812ULL, 0x000fe200078efcffULL, 0x0000002500917306ULL, 0x000fe20000009400ULL,
0x000000a800a87245ULL, 0x002fe4000020d400ULL, 0x000000b097b0723eULL, 0x000fc600000010ffULL,
0x0000000196965812ULL, 0x000fe400078efcffULL, 0x0000002500927306ULL, 0x000e620000005400ULL,
0x000000c0b900720bULL, 0x008fe40003f5d000ULL, 0x000000b196b1723eULL, 0x000fca00000010ffULL,
0x000000ae00bb7306ULL, 0x000fec0000209400ULL, 0x00000001a8a82812ULL, 0x000fe400078efcffULL,
0x000000ae00c47306ULL, 0x000ea20000205400ULL, 0x000000929100720bULL, 0x002fce0003f9d000ULL,
0x0000008a008f7306ULL, 0x000ff00000209400ULL, 0x0000008a00907306ULL, 0x000e620000205400ULL,
0x000000c4bb00720bULL, 0x004fce0003fdd000ULL, 0x0000002500657306ULL, 0x000eb0000000d400ULL,
0x00000026008e7306ULL, 0x000fe20000009400ULL, 0x000000908f00720bULL, 0x002fce0003fbd000ULL,
0x00000026008b7306ULL, 0x000e620000005400ULL, 0x0000000165654812ULL, 0x004fce00078efcffULL,
0x00000027008c7306ULL, 0x000ff00000009400ULL, 0x00000027008d7306ULL, 0x000ea20000005400ULL,
0x0000008b8e00720bULL, 0x002fe40003f5d000ULL, 0x000000ae008b7245ULL, 0x000fc4000020d400ULL,
0x00000073b8ae723eULL, 0x000fe400000010ffULL, 0x000000018b8b6812ULL, 0x000fe200078efcffULL,
0x00000024009c7306ULL, 0x000ff00000009400ULL, 0x0000002400997306ULL, 0x000fe20000005400ULL,
0x0000008d8c00720bULL, 0x004fc40003f9d000ULL, 0x0000008a008c7245ULL, 0x000fe4000020d400ULL,
0x00000041ff8d723eULL, 0x000fe400000010ffULL, 0x000000018c8c5812ULL, 0x000fe200078efcffULL,
0x0000002400667306ULL, 0x0003e6000000d400ULL, 0x0000008b8c8c723eULL, 0x000fca00000010ffULL,
0x0000008700887306ULL, 0x000fe20000209400ULL, 0x0001000025247824ULL, 0x002fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000008700897306ULL, 0x000e640000205400ULL,
0x00000024008a7245ULL, 0x000fcc000020d400ULL, 0x0000005d00257306ULL, 0x000ff00000209400ULL,
0x0000005d00b27306ULL, 0x0004e20000205400ULL, 0x000000898800720bULL, 0x002fe40003fdd000ULL,
0x00000002ff897819ULL, 0x000fc40000011636ULL, 0x00000018ff887819ULL, 0x000fe400000114b5ULL,
0x000000a4a1b5723eULL, 0x000fe200000010ffULL, 0x0000005e006d7306ULL, 0x000322000000d400ULL,
0x0000005d005d7245ULL, 0x004fce000020d400ULL, 0x00000026005a7306ULL, 0x000562000000d400ULL,
0x00010000265e7824ULL, 0x002fe200078e00ffULL, 0x000000b22500720bULL, 0x008fc80003fbd000ULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000002700597306ULL, 0x0002e2000000d400ULL,
0x0000010029267824ULL, 0x004fe200078e00ffULL, 0x000000016d6d3812ULL, 0x010fe400078efcffULL,
0x000000999c00720bULL, 0x000fe40003f7d000ULL, 0x00000018ffc57819ULL, 0x000fe40000011426ULL,
0x0000002800757306ULL, 0x000fe20000009400ULL, 0x000001002a277824ULL, 0x002fe200078e00ffULL,
0x000000015d5d5812ULL, 0x000fc400078efcffULL, 0x000000015a5a2812ULL, 0x020fe400078efcffULL,
0x00000018ff9a7819ULL, 0x000fe40000011427ULL, 0x0000002800787306ULL, 0x000fe20000005400ULL,
0x0000000166663812ULL, 0x000fe400078efcffULL, 0x0000000159594812ULL, 0x008fe400078efcffULL,
0x0000005a5d5a723eULL, 0x000fc600000010ffULL, 0x0000002800567306ULL, 0x0003f0000000d400ULL,
0x00000029007b7306ULL, 0x000fe20000009400ULL, 0x0001000028287824ULL, 0x002fca00078e00ffULL,
0x00000018ffb67819ULL, 0x000fe40000011428ULL, 0x0000002900747306ULL, 0x000ff00000005400ULL,
0x0000002900557306ULL, 0x0003f0000000d400ULL, 0x0000002a00767306ULL, 0x000fe20000009400ULL,
0x0001000029297824ULL, 0x002fca00078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe40000011429ULL,
0x0000002a00797306ULL, 0x000fe40000005400ULL, 0x0000009b00b77245ULL, 0x000fcc000020d400ULL,
0x0000002a00007306ULL, 0x0003f0000000d400ULL, 0x0000007c007d7306ULL, 0x000fe20000209400ULL,
0x000001002b2a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001142aULL,
0x0000007c007e7306ULL, 0x000e700000205400ULL, 0x0000002b007a7306ULL, 0x000ff00000009400ULL,
0x0000002b00777306ULL, 0x000ff00000005400ULL, 0x0000002b00317306ULL, 0x0005f0000000d400ULL,
0x0000002400c27306ULL, 0x000fe20000209400ULL, 0x00a800005328783bULL, 0x0045ee0000000200ULL,
0x0000002400bd7306ULL, 0x0007220000205400ULL, 0x000054108d537816ULL, 0x004fc4000000008dULL,
0x00000087008d7245ULL, 0x000fc6000020d400ULL, 0x00001f8953897589ULL, 0x000fe200000e0000ULL,
0x000000018d8d6812ULL, 0x000fe200078efcffULL, 0x0000005e005f7306ULL, 0x000fe20000209400ULL,
0x0000007e7d00720bULL, 0x002fe20003fdd000ULL, 0x00a800005224783bULL, 0x008e680000000200ULL,
0x00001f5453547589ULL, 0x000ea400000e0000ULL, 0x0000005e00947306ULL, 0x0007620000205400ULL,
0x000000bdc200720bULL, 0x010fce0003f7d000ULL, 0x0000007f00807306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x008fca000020d400ULL, 0x000000018a8a3812ULL, 0x000fe400078efcffULL,
0x0000007f00817306ULL, 0x000ee20000205400ULL, 0x000000945f00720bULL, 0x020fe40003fbd000ULL,
0x000099106a5f7816ULL, 0x000fe400000000ffULL, 0x0000006da06a723eULL, 0x000fe400000010ffULL,
0x000000ff5f00720cULL, 0x000fe20003f85270ULL, 0x0000005c00ba7306ULL, 0x000fe20000209400ULL,
0x0000007c005f7245ULL, 0x000fc4000020d400ULL, 0x0000008a8d8d723eULL, 0x000fe400000010ffULL,
0x000000015f5f6812ULL, 0x000fe400078efcffULL, 0x000000747b00720bULL, 0x000fe20003fdd000ULL,
0x0000005c00bf7306ULL, 0x0009620000205400ULL, 0x000000818000720bULL, 0x008fe40003f5d000ULL,
0x0000007f00747245ULL, 0x000fe2000020d400ULL, 0x000000892424c231ULL, 0x082fe200003400ffULL,
0x000000015e5e5812ULL, 0x000fe200078efcffULL, 0x000000892626c231ULL, 0x080fe200003400ffULL,
0x000000787500720bULL, 0x000fe20003fbd000ULL, 0x000000c500c87306ULL, 0x000fe20000209400ULL,
0x0000005c005c7245ULL, 0x010fe2000020d400ULL, 0x000000892828c231ULL, 0x080fe200003400ffULL,
0x000000c500787245ULL, 0x000fe2000020d400ULL, 0x000000892a2ac231ULL, 0x000fe200003400ffULL,
0x0000000155556812ULL, 0x000fe200078efcffULL, 0x000000542525c231ULL, 0x084fe200003400ffULL,
0x0000000174742812ULL, 0x000fe200078efcffULL, 0x000000c500cb7306ULL, 0x000e620000205400ULL,
0x000000bfba00720bULL, 0x020fe20003f7d000ULL, 0x000000542727c231ULL, 0x080fe200003400ffULL,
0x0000008200757245ULL, 0x000fe2000020d400ULL, 0x000000542929c231ULL, 0x080fe200003400ffULL,
0x0000000156565812ULL, 0x000fe200078efcffULL, 0x000000542b2bc231ULL, 0x000fe200003400ffULL,
0x000000797600720bULL, 0x000fe20003fbd000ULL, 0x000000b600a57306ULL, 0x000fe20000209400ULL,
0x000000a600897245ULL, 0x000fe2000020d400ULL, 0x0000006a240c723cULL, 0x000fe2000004180cULL,
0x0000005e5f5e723eULL, 0x000fc600000010ffULL, 0x000000015c5c3812ULL, 0x000fe400078efcffULL,
0x000000b600ca7306ULL, 0x0004e20000205400ULL, 0x000000cbc800720bULL, 0x002fe20003f5d000ULL,
0x000000ae2404723cULL, 0x000fe40000041804ULL, 0x0000000100005812ULL, 0x000fc800078efcffULL,
0x0000009300957306ULL, 0x000fe20000209400ULL, 0x000000b600b67245ULL, 0x004fe2000020d400ULL,
0x000000b42408723cULL, 0x040fe80000041808ULL, 0x0000000178782812ULL, 0x000fe400078efcffULL,
0x0000009300a27306ULL, 0x0002a20000205400ULL, 0x000000caa500720bULL, 0x008fe20003f9d000ULL,
0x000000b02410723cULL, 0x000fe20000041810ULL, 0x000000557855723eULL, 0x000fca00000010ffULL,
0x0000007000857306ULL, 0x000fe20000209400ULL, 0x0000009300937245ULL, 0x002fe2000020d400ULL,
0x0000008c2418723cULL, 0x000fe80000041818ULL, 0x00000001b6b64812ULL, 0x000fe400078efcffULL,
0x0000007000867306ULL, 0x0002e20000205400ULL, 0x000000a29500720bULL, 0x004fe40003f7d000ULL,
0x000000777a00720bULL, 0x000fca0003f9d000ULL, 0x000000a300ab7306ULL, 0x000fe20000209400ULL,
0x0000007000707245ULL, 0x002fca000020d400ULL, 0x0000000193933812ULL, 0x000fe400078efcffULL,
0x000000a300be7306ULL, 0x0002a20000205400ULL, 0x000000868500720bULL, 0x008fe40003f5d000ULL,
0x0000000131314812ULL, 0x000fe400078efcffULL, 0x00000093745f723eULL, 0x000fc600000010ffULL,
0x0000008e008f7306ULL, 0x000fe20000209400ULL, 0x000000a300a37245ULL, 0x002fc6000020d400ULL,
0x0000005e2420723cULL, 0x000fe40000041820ULL, 0x0000000170702812ULL, 0x000fe400078efcffULL,
0x0000008e00927306ULL, 0x0002e20000205400ULL, 0x000000beab00720bULL, 0x004fce0003f7d000ULL,
0x0000006400697306ULL, 0x000fe20000209400ULL, 0x0000008e008e7245ULL, 0x002fca000020d400ULL,
0x00000001a3a33812ULL, 0x000fe400078efcffULL, 0x0000006400687306ULL, 0x000e620000205400ULL,
0x000000928f00720bULL, 0x008fce0003f5d000ULL, 0x0000009b00997306ULL, 0x000fec0000209400ULL,
0x000000018e8e2812ULL, 0x000fe400078efcffULL, 0x0000009b00987306ULL, 0x000ea20000205400ULL,
0x000000686900720bULL, 0x002fce0003fbd000ULL, 0x000000a600537306ULL, 0x000ff00000209400ULL,
0x000000a6007c7306ULL, 0x000e620000205400ULL, 0x000000989900720bULL, 0x004fce0003fdd000ULL,
0x0000008200837306ULL, 0x000fec0000209400ULL, 0x00000001b7b76812ULL, 0x000fe400078efcffULL,
0x0000008200847306ULL, 0x000ea20000205400ULL, 0x0000007c5300720bULL, 0x002fe40003f9d000ULL,
0x00000065a853723eULL, 0x000fc400000010ffULL, 0x000000b770b7723eULL, 0x000fc600000010ffULL,
0x0000008800877306ULL, 0x000fec0000209400ULL, 0x0000000189894812ULL, 0x000fe400078efcffULL,
0x0000008800527306ULL, 0x0002e20000205400ULL, 0x000000848300720bULL, 0x004fce0003f7d000ULL,
0x0000002c00717306ULL, 0x000fe20000009400ULL, 0x0000008800887245ULL, 0x002fca000020d400ULL,
0x0000000175753812ULL, 0x000fe400078efcffULL, 0x0000002c006e7306ULL, 0x000e620000005400ULL,
0x000000528700720bULL, 0x008fe40003f5d000ULL, 0x00000066a952723eULL, 0x000fe400000010ffULL,
0x000000b675b6723eULL, 0x000fc600000010ffULL, 0x000000ac007b7306ULL, 0x000fe40000209400ULL,
0x000000522414723cULL, 0x000fe80000041814ULL, 0x0000000188882812ULL, 0x000fe400078efcffULL,
0x000000ac00547306ULL, 0x000ea20000205400ULL, 0x0000006e7100720bULL, 0x002fe20003fdd000ULL,
0x000000b62808723cULL, 0x000fe20000041808ULL, 0x000000ac00537245ULL, 0x000fc4000020d400ULL,
0x0000009a00717245ULL, 0x000fc6000020d400ULL, 0x0000002d006f7306ULL, 0x000ff00000009400ULL,
0x0000002d006c7306ULL, 0x000ff00000005400ULL, 0x0000002d00337306ULL, 0x0003f0000000d400ULL,
0x0000009a00917306ULL, 0x000fe20000209400ULL, 0x000001002e2d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff657819ULL, 0x000fe4000001142dULL, 0x0000009a00907306ULL, 0x000e620000205400ULL,
0x00000064002d7245ULL, 0x000fc8000020d400ULL, 0x000000012d2d5812ULL, 0x000fe400078efcffULL,
0x000000547b00720bULL, 0x004fe20003fbd000ULL, 0x0000006100627306ULL, 0x000fe20000209400ULL,
0x000000882d88723eULL, 0x000fe400000010ffULL, 0x00000056a354723eULL, 0x000fca00000010ffULL,
0x0000006100637306ULL, 0x000ea20000205400ULL, 0x000000909100720bULL, 0x002fe20003f7d000ULL,
0x000000542804723cULL, 0x000fe40000041804ULL, 0x0000000153535812ULL, 0x000fc800078efcffULL,
0x0000002c00327306ULL, 0x0002ec000000d400ULL, 0x0000000171713812ULL, 0x000fe400078efcffULL,
0x000000ad00767306ULL, 0x000fe20000209400ULL, 0x000000636200720bULL, 0x004fe20003f5d000ULL,
0x000001002f2c7824ULL, 0x002fe200078e00ffULL, 0x0000006c6f00720bULL, 0x000fca0003f7d000ULL,
0x000000ad00777306ULL, 0x000e620000205400ULL, 0x0000000132326812ULL, 0x008fc800078efcffULL,
0x000000325332723eULL, 0x000fc600000010ffULL, 0x000000a700727306ULL, 0x000fe20000209400ULL,
0x0000000133333812ULL, 0x000fce00078efcffULL, 0x000000a700737306ULL, 0x0004e20000205400ULL,
0x000000777600720bULL, 0x002fce0003fbd000ULL, 0x0000002e00607306ULL, 0x000fe20000009400ULL,
0x000000a700a77245ULL, 0x004fce000020d400ULL, 0x0000002e005b7306ULL, 0x000e620000005400ULL,
0x000000737200720bULL, 0x008fce0003fdd000ULL, 0x0000002f00577306ULL, 0x000fec0000009400ULL,
0x00000001a7a76812ULL, 0x000fe400078efcffULL, 0x0000002f00587306ULL, 0x000ea20000005400ULL,
0x0000005b6000720bULL, 0x002fe40003f9d000ULL, 0x000000595c5b723eULL, 0x000fc400000010ffULL,
0x00000018ff597819ULL, 0x000fe4000001142cULL, 0x00000061002c7245ULL, 0x000fe2000020d400ULL,
0x0000004500467306ULL, 0x000fe20000209400ULL, 0x00000059002d7245ULL, 0x000fe2000020d400ULL,
0x0000005a241c723cULL, 0x000fe2000004181cULL, 0x000000012c2c2812ULL, 0x000fc800078efcffULL,
0x000000892c89723eULL, 0x000fe200000010ffULL, 0x0000004500477306ULL, 0x000fe20000205400ULL,
0x000000585700720bULL, 0x004fe40003f5d000ULL, 0x000000007124723eULL, 0x000fe400000010ffULL,
0x0000004500007245ULL, 0x000fe2000020d400ULL, 0x000000882810723cULL, 0x000fe20000041810ULL,
0x0000004900267245ULL, 0x000fe2000020d400ULL, 0x00000049004a7306ULL, 0x000fe20000209400ULL,
0x000000318e25723eULL, 0x000fc400000010ffULL, 0x00000065002c7245ULL, 0x000fca000020d400ULL,
0x00000049004b7306ULL, 0x000e620000205400ULL, 0x00000024280c723cULL, 0x000fee000004180cULL,
0x0000002e00437306ULL, 0x0004f0000000d400ULL, 0x0000009f006c7306ULL, 0x000fe20000209400ULL,
0x000100002e2e7824ULL, 0x004fe200078e00ffULL, 0x0000004b4a00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff527819ULL, 0x000fe4000001142eULL, 0x000000ad002e7245ULL, 0x000fe2000020d400ULL,
0x0000009f00697306ULL, 0x0002a20000205400ULL, 0x0000000143434812ULL, 0x008fe400078efcffULL,
0x000000012e2e5812ULL, 0x000fe400078efcffULL, 0x000000474600720bULL, 0x000fe40003fbd000ULL,
0x0000000126266812ULL, 0x000fe200078efcffULL, 0x0000006500647306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x002fc4000020d400ULL, 0x000000332e33723eULL, 0x000fca00000010ffULL,
0x0000006500637306ULL, 0x000e620000205400ULL, 0x000000696c00720bULL, 0x004fe20003f7d000ULL,
0x000000322814723cULL, 0x000fe20000041814ULL, 0x0000000100005812ULL, 0x000fc800078efcffULL,
0x000000a70024723eULL, 0x000fe200000010ffULL, 0x00000059005c7306ULL, 0x000fe20000209400ULL,
0x0000004f00007245ULL, 0x000fca000020d400ULL, 0x000000019f9f3812ULL, 0x000fe400078efcffULL,
0x0000005900577306ULL, 0x000ea20000205400ULL, 0x000000636400720bULL, 0x002fe40003fbd000ULL,
0x0000009f2625723eULL, 0x000fca00000010ffULL, 0x0000002f00447306ULL, 0x0002e4000000d400ULL,
0x000000242818723cULL, 0x000fe80000041818ULL, 0x000000012c2c5812ULL, 0x000fe400078efcffULL,
0x0000004c004d7306ULL, 0x000fe20000209400ULL, 0x000100002f2f7824ULL, 0x002fe200078e00ffULL,
0x000000575c00720bULL, 0x004fc40003fdd000ULL, 0x0000004c00257245ULL, 0x000fe4000020d400ULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x0000004c004e7306ULL, 0x000e620000205400ULL,
0x0000000144442812ULL, 0x008fe400078efcffULL, 0x0000002f00537245ULL, 0x000fe4000020d400ULL,
0x000000432c2c723eULL, 0x000fe400000010ffULL, 0x000000012d2d6812ULL, 0x000fe200078efcffULL,
0x0000004f00507306ULL, 0x000fe60000209400ULL, 0x000000442d2d723eULL, 0x000fca00000010ffULL,
0x0000004f00517306ULL, 0x000ea20000205400ULL, 0x0000004e4d00720bULL, 0x002fe20003f7d000ULL,
0x0000002c281c723cULL, 0x000fec000004181cULL, 0x0000005200277306ULL, 0x000fec0000209400ULL,
0x0000000125253812ULL, 0x000fc400078efcffULL, 0x0000005200467306ULL, 0x0002e20000205400ULL,
0x000000515000720bULL, 0x004fce0003fbd000ULL, 0x0000002f00317306ULL, 0x000fe20000209400ULL,
0x0000005200527245ULL, 0x002fca000020d400ULL, 0x0000000100005812ULL, 0x000fe400078efcffULL,
0x0000002f004a7306ULL, 0x000e620000205400ULL, 0x000000462700720bULL, 0x008fda0003f9d000ULL,
0x0000000152524812ULL, 0x000fe400078efcffULL, 0x0000004a3100720bULL, 0x002fe40003fdd000ULL,
0x000000522552723eULL, 0x000fd600000010ffULL, 0x0000000153536812ULL, 0x000fc800078efcffULL,
0x000000530053723eULL, 0x000fce00000010ffULL, 0x000000522820723cULL, 0x000fe20000041820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003eff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6400042ff7f8cULL, 0x0005e2000c80043fULL,
0x0000991067007816ULL, 0x000fe400000000ffULL, 0x00000001ff647807ULL, 0x000fe40004000000ULL,
0x000000ff0000720cULL, 0x000fe40003f45270ULL, 0x0000000140637812ULL, 0x000fe400078ec0ffULL,
0x00000001ff309807ULL, 0x000fc80001000000ULL, 0x0000761030657816ULL, 0x000fe40000000065ULL,
0x0000030034347a10ULL, 0x00cfe40007ffe0ffULL, 0x000000ff3fff7812ULL, 0x000fe4000780c0ffULL,
0x000000353400720cULL, 0x000fe40003f26070ULL, 0x00000001ff3f7807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff4fc000007947ULL, 0x000fea000383ffffULL,
0x00000000000479c3ULL, 0x002e620000002500ULL, 0x000000ffff317224ULL, 0x000fe400078e0023ULL,
0x000000ffff327224ULL, 0x000fe400078e0022ULL, 0x000000ffff2d7224ULL, 0x000fe400078e001fULL,
0x000000ffff2b7224ULL, 0x000fe400078e001cULL, 0x000000ffff307224ULL, 0x000fe400078e0021ULL,
0x000000ffff2f7224ULL, 0x000fc400078e0020ULL, 0x000000ffff2e7224ULL, 0x000fe400078e001eULL,
0x000000ffff2c7224ULL, 0x000fe400078e001dULL, 0x000000ffff297224ULL, 0x000fe400078e001bULL,
0x000000ffff2a7224ULL, 0x000fe400078e001aULL, 0x000000ffff287224ULL, 0x000fe400078e0019ULL,
0x000000ffff277224ULL, 0x000fe200078e0018ULL, 0x0000000435007c0cULL, 0x002fe2000bf03070ULL,
0x000000ffff267224ULL, 0x000fc400078e0016ULL, 0x000000ffff237224ULL, 0x000fe400078e0014ULL,
0x000000ffff227224ULL, 0x000fe400078e0012ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0010ULL,
0x000000ffff1c7224ULL, 0x000fe400078e000eULL, 0x000000ffff257224ULL, 0x000fe400078e0017ULL,
0x000000ffff247224ULL, 0x000fc400078e0015ULL, 0x000000ffff217224ULL, 0x000fe400078e0013ULL,
0x000000ffff207224ULL, 0x000fe400078e0011ULL, 0x000000ffff1e7224ULL, 0x000fe400078e000fULL,
0x000000ffff187224ULL, 0x000fe400078e000dULL, 0x000000ffff1d7224ULL, 0x000fe400078e000cULL,
0x000000ffff1a7224ULL, 0x000fc400078e000bULL, 0x000000ffff167224ULL, 0x000fe400078e000aULL,
0x000000ffff147224ULL, 0x000fe400078e0009ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0008ULL,
0x000000ffff127224ULL, 0x000fe400078e0007ULL, 0x000000ffff107224ULL, 0x000fe400078e0006ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0005ULL, 0x000000ffff197224ULL, 0x000fe200078e0004ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x018000003d007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000c00000067802ULL, 0x000fe40000000f00ULL, 0x0000993000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003d00007308ULL, 0x000e640000001000ULL, 0xbf80000000037423ULL, 0x002fc8000000003dULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff057624ULL, 0x000fe400078e00ffULL,
0x00006600ff047624ULL, 0x000fca00078e00ffULL, 0x0000000804057981ULL, 0x000ea8000c1e9900ULL,
0x0000000000037919ULL, 0x000ee80000000000ULL, 0x0000000000087919ULL, 0x000f220000000000ULL,
0x00000002ff077819ULL, 0x008fe40000011603ULL, 0x0000000808037811ULL, 0x010fe200078ff0ffULL,
0x0000000005067220ULL, 0x004fca0000410000ULL, 0x00001f0706007589ULL, 0x000ea800000e0000ULL,
0x00001f0306037589ULL, 0x000ee200000e0000ULL, 0x0000001900197220ULL, 0x044fe20000410000ULL,
0x0000000e000e7220ULL, 0x040fe20000410000ULL, 0x0000001b001b7220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001f001f7220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002300237220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002700277220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002b002b7220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002f002f7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x000fe20000410000ULL, 0x0000001003107220ULL, 0x048fe20000410000ULL,
0x0000001203127220ULL, 0x040fe20000410000ULL, 0x0000001603167220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000001c031c7220ULL, 0x040fe20000410000ULL,
0x0000001e031e7220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002103217220ULL, 0x040fe20000410000ULL, 0x0000002603267220ULL, 0x040fe20000410000ULL,
0x0000002503257220ULL, 0x040fe20000410000ULL, 0x0000002a032a7220ULL, 0x040fe20000410000ULL,
0x0000002903297220ULL, 0x040fe20000410000ULL, 0x0000002e032e7220ULL, 0x040fe20000410000ULL,
0x0000002d032d7220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000003103317220ULL, 0x000fc40000410000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000203007812ULL, 0x004fc400078ec0ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011603ULL, 0x0000000200067811ULL, 0x040fe400078ff8ffULL,
0x0000000400087811ULL, 0x000fe400078ff8ffULL, 0x0000000803177811ULL, 0x000fe400078ff0ffULL,
0x00000001ff047819ULL, 0x000fe40000011600ULL, 0x0000000706057812ULL, 0x000fc400078e780fULL,
0x00000007080a7812ULL, 0x040fe400078e780fULL, 0x0000000708087812ULL, 0x000fe200078e7817ULL,
0x000000080f097824ULL, 0x000fe200078e0205ULL, 0x00000006000b7811ULL, 0x000fe200078ff8ffULL,
0x000010003b057824ULL, 0x000fe200078e00ffULL, 0x0000000704007812ULL, 0x140fe200078e780fULL,
0x0000000817157824ULL, 0x000fe200078e0208ULL, 0x000000070b0c7812ULL, 0x000fe200078e780fULL,
0x0000000803087824ULL, 0x000fe200078e00ffULL, 0x0000000704047812ULL, 0x100fe200078e7817ULL,
0x000000080f077824ULL, 0x000fe200078e0200ULL, 0x0000000706067812ULL, 0x000fe200078e7817ULL,
0x0000080048007824ULL, 0x000fe200078e0205ULL, 0x000000070b0b7812ULL, 0x000fe200078e7817ULL,
0x000000080f0d7824ULL, 0x000fe200078e020aULL, 0x0000000808087812ULL, 0x000fe200078ec0ffULL,
0x0000000817117824ULL, 0x040fe200078e0204ULL, 0x000000190e04723eULL, 0x000fe200000010ffULL,
0x0000000817137824ULL, 0x000fe200078e0206ULL, 0x0000001b1406723eULL, 0x000fe200000010ffULL,
0x000000080f0f7824ULL, 0x000fc400078e020cULL, 0x0000000817177824ULL, 0x000fe200078e020bULL,
0x0000763204197816ULL, 0x000fe20000000006ULL, 0x0000001007077824ULL, 0x100fe400078e0200ULL,
0x00000010090b7824ULL, 0x100fe400078e0200ULL, 0x000000100d0d7824ULL, 0x100fe400078e0200ULL,
0x0000001011117824ULL, 0x100fe400078e0200ULL, 0x0000001013137824ULL, 0x000fc400078e0200ULL,
0x000000100f0f7824ULL, 0x100fe400078e0200ULL, 0x0000001015157824ULL, 0x100fe400078e0200ULL,
0x0000001017177824ULL, 0x000fe400078e0200ULL, 0x0000000107097824ULL, 0x000fe200078e0208ULL,
0x0000001d1807723eULL, 0x000fe200000010ffULL, 0x00000001080b7824ULL, 0x000fe200078e020bULL,
0x0000541004187816ULL, 0x000fe20000000006ULL, 0x00000001080d7824ULL, 0x000fe200078e020dULL,
0x000000232404723eULL, 0x000fe200000010ffULL, 0x0000000108117824ULL, 0x000fe200078e0211ULL,
0x000000272806723eULL, 0x000fe200000010ffULL, 0x0000000108137824ULL, 0x040fe200078e0213ULL,
0x0000001809007388ULL, 0x0005e20000000a00ULL, 0x00000001080f7824ULL, 0x000fe200078e020fULL,
0x00005410040a7816ULL, 0x000fe20000000006ULL, 0x0000000108157824ULL, 0x000fc400078e0215ULL,
0x0000000108177824ULL, 0x000fe200078e0217ULL, 0x0000001f2008723eULL, 0x000fe200000010ffULL,
0x00000020480e7824ULL, 0x000fc600078e0203ULL, 0x0000541007187816ULL, 0x144fe20000000008ULL,
0x000000100e097824ULL, 0x000fe200078e0205ULL, 0x0000763207197816ULL, 0x000fe40000000008ULL,
0x0000002b2c07723eULL, 0x000fe400000010ffULL, 0x0000002f3008723eULL, 0x000fe200000010ffULL,
0x000000180b007388ULL, 0x0005e40000000a00ULL, 0x00007632040b7816ULL, 0x004fe40000000006ULL,
0x000000101204723eULL, 0x000fc400000010ffULL, 0x000000161a06723eULL, 0x000fe200000010ffULL,
0x0000000a0d007388ULL, 0x0005e40000000a00ULL, 0x00005410070a7816ULL, 0x144fe40000000008ULL,
0x00007632070b7816ULL, 0x000fe40000000008ULL, 0x0000001c1e07723eULL, 0x000fe400000010ffULL,
0x000000222108723eULL, 0x000fe200000010ffULL, 0x0000000a0f007388ULL, 0x0005e40000000a00ULL,
0x00005410040a7816ULL, 0x004fc40000000006ULL, 0x00007632040b7816ULL, 0x000fe40000000006ULL,
0x000000262504723eULL, 0x000fe400000010ffULL, 0x0000002a2906723eULL, 0x000fe200000010ffULL,
0x0000000a11007388ULL, 0x0005e40000000a00ULL, 0x00005410070a7816ULL, 0x144fe40000000008ULL,
0x00007632070b7816ULL, 0x000fe40000000008ULL, 0x0000002e2d07723eULL, 0x000fc400000010ffULL,
0x000000323108723eULL, 0x000fe200000010ffULL, 0x0000000a13007388ULL, 0x0005e40000000a00ULL,
0x00005410040a7816ULL, 0x144fe40000000006ULL, 0x00007632040b7816ULL, 0x000fe40000000006ULL,
0x000000ff00047306ULL, 0x000fe60000205400ULL, 0x0000000a15007388ULL, 0x0005e40000000a00ULL,
0x00005410070a7816ULL, 0x004fc40000000008ULL, 0x00007632070b7816ULL, 0x000fe40000000008ULL,
0x000000ff00077306ULL, 0x000ea60000209400ULL, 0x0000000a17007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000040700720bULL, 0x004fc40003f1d000ULL,
0x000000ff00047245ULL, 0x000fd6000020d400ULL, 0x0000000104040812ULL, 0x000fe200078efcffULL,
0x00040000091c7984ULL, 0x000ea60000000c00ULL, 0x000000040408723eULL, 0x000fe200000010ffULL,
0x000c000009207984ULL, 0x000ee80000000c00ULL, 0x0000000009107984ULL, 0x000f280000000c00ULL,
0x0008000009187984ULL, 0x000f620000000c00ULL, 0x3f803f80081c7831ULL, 0x004fc4000020001cULL,
0x3f803f80081f7831ULL, 0x000fe4000020001fULL, 0x3f803f801c1c7831ULL, 0x008fe20000200020ULL,
0x00000300ff207624ULL, 0x000fe200078e00ffULL, 0x3f803f80081e7831ULL, 0x040fe4000020001eULL,
0x3f803f8008137831ULL, 0x050fe40000200013ULL, 0x000000012000780cULL, 0x000fe20003f05270ULL,
0x3f803f8008127831ULL, 0x040fe40000200012ULL, 0x3f803f8008117831ULL, 0x000fc40000200011ULL,
0x3f803f8008107831ULL, 0x040fe40000200010ULL, 0x3f803f80081d7831ULL, 0x000fe4000020001dULL,
0x3f803f8013137831ULL, 0x020fe4000020001bULL, 0x3f803f8012127831ULL, 0x000fe4000020001aULL,
0x3f803f8011117831ULL, 0x000fe40000200019ULL, 0x3f803f8010107831ULL, 0x000fc40000200018ULL,
0x3f803f801f1f7831ULL, 0x000fe40000200023ULL, 0x3f803f801e1e7831ULL, 0x000fe20000200022ULL,
0x0000001009007388ULL, 0x0005e20000000c00ULL, 0x3f803f801d1d7831ULL, 0x000fca0000200021ULL,
0x0004001c09007388ULL, 0x0005e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000306000008947ULL, 0x000fea0003800000ULL, 0x0000000000127919ULL, 0x004ea20000002700ULL,
0x0000580020067a24ULL, 0x000fe200078e02ffULL, 0x0000000148ff7812ULL, 0x000fe2000780f802ULL,
0x00001000ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000000077919ULL, 0x000ea20000002600ULL,
0x00006400060c7a24ULL, 0x000fe200078e02ffULL, 0x000000400e117810ULL, 0x000fe20007ffe0ffULL,
0x000008003b087824ULL, 0x000fe200078e00ffULL, 0x0000000009147984ULL, 0x000ee40000000c00ULL,
0x00000fff0c067811ULL, 0x000fc400078e40ffULL, 0x0004000009187984ULL, 0x0008640000000c00ULL,
0x01ffffff0c097812ULL, 0x010fe200078ec0ffULL, 0x0000580012127a24ULL, 0x004fc800078e0207ULL,
0x0000030012077a24ULL, 0x000fca00078e02ffULL, 0x00000004070d7c10ULL, 0x000fc8000fffe0ffULL,
0x0000000d060a7211ULL, 0x000fca00078fa0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000bULL,
0x000000080a0a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x000000ff0300720cULL, 0x000fc60000725670ULL, 0x000000100e0e7825ULL, 0x000fc800078e000aULL,
0x0000001011107825ULL, 0x000fe200078e000aULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010030a7824ULL, 0x00afe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x00000080ff137424ULL, 0x000fe400078e00ffULL, 0x000000010d0c7824ULL, 0x000fe200078e0209ULL,
0x000000700a1d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b1c7812ULL, 0x000fe200078ec0ffULL,
0x00006a000d0a7625ULL, 0x000fc800078e0013ULL, 0x00006a000c0c7625ULL, 0x000fe200078e0013ULL,
0x0000000a1c0a7210ULL, 0x000fc80007a1e01dULL, 0x0000000c1c0c7210ULL, 0x000fe40007c7e01dULL,
0x0000000bff0b7210ULL, 0x000fe400007e44ffULL, 0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL,
0x0000003c0a007986ULL, 0x0003e8000c101908ULL, 0x0000003d0c007986ULL, 0x0003e4000c101908ULL,
0x000000140e007986ULL, 0x00a3e2000c101d08ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x0000001810007986ULL, 0x0003e8000c101d08ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0b7424ULL, 0x000fe200078e00ffULL,
0xffffffff200d7810ULL, 0x000fc60007ffe0ffULL, 0x00006800120a7625ULL, 0x000fe200078e000bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000d0a0a79a8ULL, 0x000ea400099ee1c8ULL, 0x0000000d0a00720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0c7807ULL, 0x000fca0000000000ULL,
0x0000000cff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff0a7984ULL, 0x000ee40000000000ULL,
0x000000ff0a00720cULL, 0x008fda0003f05270ULL, 0x00002c9000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000010030a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x00000080ff197424ULL, 0x002fe200078e00ffULL, 0x00000001070c7810ULL, 0x004fe40007ffe0ffULL,
0x000000700a1b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b107812ULL, 0x000fe200078ec0ffULL,
0x00006a00070a7625ULL, 0x000fc800078e0019ULL, 0x00006a000c0c7625ULL, 0x000fe200078e0019ULL,
0x0000000a100a7210ULL, 0x000fc8000791e01bULL, 0x0000000c100c7210ULL, 0x000fe40007b5e01bULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x000000080a0e7981ULL, 0x000368000c1e1900ULL, 0x000000080c0f7981ULL, 0x000362000c1e1900ULL,
0x000000022000780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002070a7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a100a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000080a117981ULL, 0x000362000c1e1900ULL, 0x000000042000780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003070a7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a100a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000080a137981ULL, 0x000362000c1e1900ULL,
0x000000042000780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004070a7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a100a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000080a157981ULL, 0x000362000c1e1900ULL, 0x000000062000780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005070a7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a100a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000080a177981ULL, 0x000362000c1e1900ULL,
0x000000062000780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000082000780cULL, 0x002fe40003f06070ULL, 0x00000006070a7810ULL, 0x000fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a100a7210ULL, 0x000fe40007a3e01bULL,
0x00000007070c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006a000c0c0625ULL, 0x000fe400078e0019ULL, 0x000000080a197981ULL, 0x000366000c1e1900ULL,
0x0000000c100c0210ULL, 0x000fc80007c7e01bULL, 0x0000000dff0d0210ULL, 0x000fcc0001fe84ffULL,
0x000000080c0d0981ULL, 0x000366000c1e1900ULL, 0x00000007200a7810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0c7819ULL, 0x004fc8000001160aULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x020fe400078e000eULL, 0x000000081b107824ULL, 0x040fe200078e00ffULL,
0x000000011b1b7810ULL, 0x000fc80007ffe0ffULL, 0x0000030010007a0cULL, 0x000fe40003f26070ULL,
0x0000000c1b00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x00000008100a7810ULL, 0x040fe40007ffe0ffULL, 0x00000001100b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001d0e0e7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x00000070121d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a140a7210ULL, 0x000fc80007b3e01dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000080a1d7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x00000009100a7810ULL, 0x042fe40007ffe0ffULL,
0x00000002100b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000f0e0e7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000080a0f7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a100a7810ULL, 0x042fe40007ffe0ffULL, 0x00000003100b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x000000110e0e7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000080a117981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b100a7810ULL, 0x042fe40007ffe0ffULL,
0x00000004100b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x000000130e0e7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff147819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007012137812ULL, 0x000fc800078ec0ffULL,
0x0000000a140a7210ULL, 0x000fc80007b3e013ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000080a137981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c100a7810ULL, 0x042fe40007ffe0ffULL, 0x00000005100b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x000000150e0e7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007012157812ULL, 0x000fc800078ec0ffULL, 0x0000000a140a7210ULL, 0x000fc80007b3e015ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000080a157981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d100a7810ULL, 0x042fe40007ffe0ffULL,
0x00000006100b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x000000170e0e7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff147819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007012177812ULL, 0x000fc800078ec0ffULL,
0x0000000a140a7210ULL, 0x000fc80007b3e017ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000080a177981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e100a7810ULL, 0x042fe40007ffe0ffULL, 0x00000007100b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x000000190e0e7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007012197812ULL, 0x000fc800078ec0ffULL, 0x0000000a140a7210ULL, 0x000fc80007b3e019ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000080a197981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f100a7810ULL, 0x002fe40007ffe0ffULL,
0x0000000d0e0e7209ULL, 0x000fe40007810000ULL, 0x000003000a007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030d7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007a3e00dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000080a0d7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x00000010030a7824ULL, 0x006fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011603ULL, 0x000000700a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL, 0x000000010b0b7824ULL, 0x000fca00078e020aULL,
0x0000000e0b007388ULL, 0x0203e40000000800ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000000148147824ULL, 0x002fe200078e0207ULL, 0x00000001ff0c7819ULL, 0x004fe20000011603ULL,
0x00000010030b7824ULL, 0x000fe200078e00ffULL, 0x00000002ff0d7819ULL, 0x000fe20000011602ULL,
0x00001000ff117424ULL, 0x000fe200078e00ffULL, 0x00000014060a7211ULL, 0x000fe200078fa0ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000700b0e7812ULL, 0x000fe200078ec0ffULL,
0x0000020002027824ULL, 0x000fe200078e00ffULL, 0x0000000c0c0f7812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fe200078e0011ULL, 0x000000010d0c7812ULL, 0x000fe200078ec0ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000004003117810ULL, 0x000fe20007ffe0ffULL,
0x00000002480d8824ULL, 0x100fe200078e023bULL, 0x000000080a0a7210ULL, 0x000fe20007f3e0ffULL,
0x000000010f297824ULL, 0x000fe200078e020eULL, 0x0000006003137810ULL, 0x000fe20007ffe0ffULL,
0x00000002480f8824ULL, 0x000fe200078e023bULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000020d168824ULL, 0x100fe200078e020cULL, 0x00000800020d7812ULL, 0x000fe200078ec0ffULL,
0x000000020f188824ULL, 0x000fe200078e020cULL, 0x00000020030f7810ULL, 0x000fe20007ffe0ffULL,
0x000000013a3a7824ULL, 0x000fe200078e0205ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000030048007a0cULL, 0x000fe20003f26070ULL,
0x000000013a027824ULL, 0x000fe200078e020dULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000109128824ULL, 0x000fe200078e0214ULL, 0x0000000029297984ULL, 0x000e620000000800ULL,
0x00000080ff158424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000100f0c7825ULL, 0x000fc800078e000aULL, 0x00000080ff198424ULL, 0x000fe400078e00ffULL,
0x00000010110e7825ULL, 0x000fc800078e000aULL, 0x0000001013107825ULL, 0x000fc800078e000aULL,
0x00006a0012128625ULL, 0x000fc800078e0015ULL, 0x00006a0014148625ULL, 0x000fc800078e0019ULL,
0x0000000816168824ULL, 0x000fe400078e0203ULL, 0x0000001003177824ULL, 0x040fe400078e0202ULL,
0x00000010030a7825ULL, 0x000fe200078e000aULL, 0x00004580161d8811ULL, 0x000fc600078e20ffULL,
0x0000000818188824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a177faeULL, 0x0005e2000b901c48ULL, 0x0000001003128825ULL, 0x000fc600078e0012ULL,
0x00004180181f8811ULL, 0x000fe200078e20ffULL, 0x0000001003148825ULL, 0x000fe200078e0014ULL,
0x003800000c177faeULL, 0x0007e2000b901c48ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x000000ffff027224ULL, 0x000fe200078e00ffULL, 0x005800000e177faeULL, 0x0009e2000b901c48ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x004fe2000001ff00ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x0078000010177faeULL, 0x0005e8000b901c48ULL,
0x00000000121d8faeULL, 0x000be2000b901c48ULL, 0x00000000000c7805ULL, 0x008fc6000001ff00ULL,
0x00000000141f8faeULL, 0x0007e2000b901c48ULL, 0x00000000000e7805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000107805ULL, 0x004fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x020fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x008fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000e0000001947ULL, 0x000fea0003800000ULL,
0x00000df000007945ULL, 0x002fe20003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e00ffULL,
0x000000ffff2c7224ULL, 0x000fca00078e0048ULL, 0x000000022c387810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff417224ULL, 0x000fe200078e002cULL, 0x00000002ff5a7819ULL, 0x002fe20000011603ULL,
0x00000002482c7824ULL, 0x000fe200078e023bULL, 0x0000030038007a0cULL, 0x000fe20003f06070ULL,
0x00000040412b7824ULL, 0x000fe200078e00ffULL, 0x000000075a2d7812ULL, 0x040fe200078ec0ffULL,
0x000000085a3c7824ULL, 0x040fe200078e00ffULL, 0x0000005aff4c7212ULL, 0x000fe200078e33ffULL,
0x000000085a2a7824ULL, 0x040fe200078e00ffULL, 0x000000802b2b7812ULL, 0x000fe200078ec0ffULL,
0x000000085a2f7824ULL, 0x008fe200078e00ffULL, 0x0000039000017945ULL, 0x000fe20003800000ULL,
0xfffffff83c3c7812ULL, 0x100fe200078ee22dULL, 0x0000001003437824ULL, 0x000fe200078e00ffULL,
0x000000012a3e7812ULL, 0x000fe200078ef62dULL, 0x000001002c3f7824ULL, 0x000fe200078e002bULL,
0x000000022a407812ULL, 0x000fc400078ef62dULL, 0x000000032a427812ULL, 0x140fe400078ef62dULL,
0x000000042a447812ULL, 0x140fe400078ef62dULL, 0x000000052a467812ULL, 0x140fe400078ef62dULL,
0x000000062a4a7812ULL, 0x000fe400078ef62dULL, 0xfffffff82f4c7812ULL, 0x000fe400078ee24cULL,
0x000000085a5c7810ULL, 0x000fe20007ffe0ffULL, 0x000002c000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x000fe20003f24070ULL, 0x0000000107347824ULL, 0x100fe200078e0238ULL,
0x00000001ff2c7819ULL, 0x000fe20000011638ULL, 0x00001000ff2b7424ULL, 0x000fe200078e00ffULL,
0x00000020032f7810ULL, 0x000fc40007ffe0ffULL, 0x00000034062a7211ULL, 0x000fe400078fa0ffULL,
0x000000012c2d7812ULL, 0x000fe200078ec0ffULL, 0x00000400382c7824ULL, 0x000fe200078e00ffULL,
0x0000004003317810ULL, 0x040fe20007ffe0ffULL, 0x00006a002a2a7625ULL, 0x000fe200078e002bULL,
0x0000006003397810ULL, 0x000fc60007ffe0ffULL, 0x00000002484e9824ULL, 0x100fe200078e023bULL,
0x000000082a2a7210ULL, 0x000fe20007f1e0ffULL, 0x00000002482e9824ULL, 0x000fe400078e023bULL,
0x000000024e4e9824ULL, 0x100fe400078e022dULL, 0x000000022e509824ULL, 0x000fe200078e022dULL,
0x000008002c2d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2b7224ULL, 0x000fe400000e062bULL,
0x0000000109329824ULL, 0x000fc400078e0234ULL, 0x000000013a2c7824ULL, 0x000fe400078e022dULL,
0x00000080ff339424ULL, 0x000fe400078e00ffULL, 0x00000080ff359424ULL, 0x000fe400078e00ffULL,
0x0000001003377824ULL, 0x040fe400078e022cULL, 0x00000010032c7825ULL, 0x000fc800078e002aULL,
0x000000102f2e7825ULL, 0x100fe200078e002aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800002c377faeULL, 0x0003e6000b901c48ULL, 0x0000001031307825ULL, 0x100fe200078e002aULL,
0x003800002e377faeULL, 0x0003e6000b901c48ULL, 0x00006a0032329625ULL, 0x000fe200078e0033ULL,
0x0058000030377faeULL, 0x0003e6000b901c48ULL, 0x00000010392a7825ULL, 0x000fc800078e002aULL,
0x00006a0034349625ULL, 0x000fe200078e0035ULL, 0x007800002a377faeULL, 0x0003e6000b901c48ULL,
0x000000084e399824ULL, 0x100fe400078e0203ULL, 0x00000008503d9824ULL, 0x000fe400078e0203ULL,
0x0000001003329825ULL, 0x000fe200078e0032ULL, 0x0000458039399811ULL, 0x000fe400078e20ffULL,
0x000041803d3d9811ULL, 0x000fe200078e20ffULL, 0x0000001003349825ULL, 0x000fc400078e0034ULL,
0x0000000032399faeULL, 0x0003e8000b901c48ULL, 0x00000000343d9faeULL, 0x0003e4000b901c48ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000001ff2c7819ULL, 0x002fe20000011603ULL, 0x000000085c307824ULL, 0x040fe200078e00ffULL,
0x0000007043527812ULL, 0x000fe200078ec0ffULL, 0x000000085c2e7824ULL, 0x000fe200078e00ffULL,
0x0000000c2c2d7812ULL, 0x000fe200078ec0ffULL, 0x00000400412a7824ULL, 0x000fe200078e00ffULL,
0x000000075c2b7812ULL, 0x000fc400078ec0ffULL, 0x0000003f2d3f7210ULL, 0x000fe20007ffe052ULL,
0x000000085c2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8302c7812ULL, 0x100fe400078ee22bULL,
0x000000012e307812ULL, 0x140fe400078ef62bULL, 0x000000022e327812ULL, 0x140fe400078ef62bULL,
0x000000032e347812ULL, 0x140fe400078ef62bULL, 0x000000042e4e7812ULL, 0x000fc400078ef62bULL,
0x000000052e507812ULL, 0x140fe400078ef62bULL, 0x000000062e2e7812ULL, 0x000fe200078ef62bULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180003f547984ULL, 0x000e620000000800ULL,
0x000008002a2b7812ULL, 0x000fe200078ec0ffULL, 0x00000004032a7824ULL, 0x000fe200078e00ffULL,
0x0000005cff527212ULL, 0x000fe200078e33ffULL, 0x004580003f3f7984ULL, 0x000ea20000000800ULL,
0x000001803a2b7810ULL, 0x000fe40007ffe02bULL, 0xfffffff82d527812ULL, 0x000fe400078ee252ULL,
0x0000000c2a2d7812ULL, 0x000fe200078ec0ffULL, 0x000000103c3c7824ULL, 0x000fc400078e022bULL,
0x000000103e3e7824ULL, 0x100fe400078e022bULL, 0x0000001040407824ULL, 0x100fe400078e022bULL,
0x0000001042427824ULL, 0x100fe400078e022bULL, 0x0000001044447824ULL, 0x100fe400078e022bULL,
0x0000001046467824ULL, 0x100fe400078e022bULL, 0x000000104a4a7824ULL, 0x000fc400078e022bULL,
0x0000001034347824ULL, 0x100fe400078e022bULL, 0x000000104e4e7824ULL, 0x100fe400078e022bULL,
0x0000001050507824ULL, 0x100fe400078e022bULL, 0x000000104c4c7824ULL, 0x100fe400078e022bULL,
0x0000001030307824ULL, 0x100fe400078e022bULL, 0x0000001032327824ULL, 0x000fc400078e022bULL,
0x000000102e2e7824ULL, 0x100fe400078e022bULL, 0x0000001052527824ULL, 0x100fe400078e022bULL,
0x000000102c2c7824ULL, 0x000fe200078e022bULL, 0x0000005429547221ULL, 0x002fe20000010100ULL,
0x000000013c3c7824ULL, 0x000fe400078e022dULL, 0x000000012d3e7824ULL, 0x040fe200078e023eULL,
0x3fb8aa3b54547820ULL, 0x000fe20000410000ULL, 0x000000012d407824ULL, 0x000fc400078e0240ULL,
0x000000012d427824ULL, 0x040fe200078e0242ULL, 0x000000003c3c7984ULL, 0x000e620000000800ULL,
0x000000012d447824ULL, 0x040fe200078e0244ULL, 0x0000005400547308ULL, 0x000ea20000000800ULL,
0x000000012d467824ULL, 0x040fe200078e0246ULL, 0x000000003e3e7984ULL, 0x000ee20000000800ULL,
0x000000012d4a7824ULL, 0x040fe400078e024aULL, 0x000000012d4c7824ULL, 0x040fe200078e024cULL,
0x0000000040407984ULL, 0x000f220000000800ULL, 0x000000012d347824ULL, 0x000fc400078e0234ULL,
0x000000012d4e7824ULL, 0x040fe200078e024eULL, 0x0000000042427984ULL, 0x000f620000000800ULL,
0x000000012d507824ULL, 0x040fe400078e0250ULL, 0x000000012d307824ULL, 0x040fe200078e0230ULL,
0x0000000044447984ULL, 0x000f620000000800ULL, 0x000000012d327824ULL, 0x040fe200078e0232ULL,
0x0000003f542f7220ULL, 0x004fe20000410000ULL, 0x000000012d2e7824ULL, 0x040fe200078e022eULL,
0x0000000046467984ULL, 0x000ea20000000800ULL, 0x000000012d527824ULL, 0x000fe200078e0252ULL,
0x000000362f367221ULL, 0x000fe20000010000ULL, 0x000000012d2c7824ULL, 0x000fe200078e022cULL,
0x000000004a4a7984ULL, 0x000ea80000000800ULL, 0x000000004c4c7984ULL, 0x000ea80000000800ULL,
0x0000000034347984ULL, 0x000ea80000000800ULL, 0x000000004e4e7984ULL, 0x000ea80000000800ULL,
0x0000000050507984ULL, 0x000ea20000000800ULL, 0x00005410ff337816ULL, 0x002fc4000000003cULL,
0x00007610ff3c7816ULL, 0x000fe2000000003cULL, 0x000000002c2a7984ULL, 0x0002a20000000800ULL,
0x00005410ff357816ULL, 0x108fe4000000003eULL, 0x00007610ff3e7816ULL, 0x000fe2000000003eULL,
0x0000000030307984ULL, 0x000ee20000000800ULL, 0x00005410ff377816ULL, 0x110fe40000000040ULL,
0x00007610ff407816ULL, 0x000fe20000000040ULL, 0x0000000032327984ULL, 0x000f220000000800ULL,
0x000000ffff2c7224ULL, 0x002fe200078e0038ULL, 0x00005410ff397816ULL, 0x020fc40000000042ULL,
0x000000002e2e7984ULL, 0x000e620000000800ULL, 0x00005410ff3d7816ULL, 0x000fe40000000044ULL,
0x000003002c007a0cULL, 0x000fe20003f06070ULL, 0x0000000052527984ULL, 0x000f620000000800ULL,
0x00005410ff3f7816ULL, 0x004fe40000000046ULL, 0x00007610ff427816ULL, 0x000fe40000000042ULL,
0x00005410ff417816ULL, 0x000fe4000000004aULL, 0x00007610ff447816ULL, 0x000fc40000000044ULL,
0x00005410ff437816ULL, 0x000fe4000000004cULL, 0x00007610ff467816ULL, 0x000fe40000000046ULL,
0x00005410ff4b7816ULL, 0x000fe40000000034ULL, 0x00007610ff4a7816ULL, 0x000fe4000000004aULL,
0x00005410ff4d7816ULL, 0x000fe4000000004eULL, 0x00007610ff4c7816ULL, 0x000fc4000000004cULL,
0x00005410ff4f7816ULL, 0x000fe40000000050ULL, 0x00007610ff347816ULL, 0x000fe40000000034ULL,
0x00005410ff457816ULL, 0x100fe4000000002aULL, 0x00007610ff387816ULL, 0x000fe4000000002aULL,
0x00005410ff477816ULL, 0x108fe40000000030ULL, 0x00007610ff547816ULL, 0x000fc40000000030ULL,
0x00005410ff497816ULL, 0x110fe40000000032ULL, 0x00007610ff567816ULL, 0x000fe40000000032ULL,
0x00007610ff4e7816ULL, 0x000fe4000000004eULL, 0x00007610ff507816ULL, 0x000fe40000000050ULL,
0x00005410ff517816ULL, 0x102fe4000000002eULL, 0x00007610ff587816ULL, 0x000fc4000000002eULL,
0x00005410ff537816ULL, 0x120fe40000000052ULL, 0x00007610ff557816ULL, 0x000fe20000000052ULL,
0x000068327f007947ULL, 0x000fea000b800000ULL, 0x00001f5a2f2d7589ULL, 0x0002a400000e0000ULL,
0x000068827f007947ULL, 0x000fea000b800000ULL, 0x00001f5c2f2b7589ULL, 0x00072400000e0000ULL,
0x0000002d33287223ULL, 0x084fe20000010028ULL, 0x0000002d3c277223ULL, 0x080fe20000010027ULL,
0x0000002d35267223ULL, 0x080fe20000010026ULL, 0x0000002d3e257223ULL, 0x080fe20000010025ULL,
0x0000002d37247223ULL, 0x080fe20000010024ULL, 0x0000002d40237223ULL, 0x080fe20000010023ULL,
0x0000002d39227223ULL, 0x080fe20000010022ULL, 0x0000002d42217223ULL, 0x080fe20000010021ULL,
0x0000002d3d207223ULL, 0x080fe20000010020ULL, 0x0000002d441f7223ULL, 0x080fe2000001001fULL,
0x0000002d3f1e7223ULL, 0x080fe2000001001eULL, 0x0000002d461d7223ULL, 0x080fe2000001001dULL,
0x0000002d411c7223ULL, 0x080fe2000001001cULL, 0x0000002d4a1b7223ULL, 0x080fe2000001001bULL,
0x0000002d431a7223ULL, 0x080fe2000001001aULL, 0x0000002d4c197223ULL, 0x000fe20000010019ULL,
0x0000002b45187223ULL, 0x090fe20000010018ULL, 0x0000002b38177223ULL, 0x080fe20000010017ULL,
0x0000002b47167223ULL, 0x080fe20000010016ULL, 0x0000002b54157223ULL, 0x080fe20000010015ULL,
0x0000002b49147223ULL, 0x080fe20000010014ULL, 0x0000002b56137223ULL, 0x080fe20000010013ULL,
0x0000002b4b127223ULL, 0x080fe20000010012ULL, 0x0000002b34117223ULL, 0x080fe20000010011ULL,
0x0000002b4d107223ULL, 0x080fe20000010010ULL, 0x0000002b4e0f7223ULL, 0x080fe2000001000fULL,
0x0000002b4f0e7223ULL, 0x080fe2000001000eULL, 0x0000002b500d7223ULL, 0x080fe2000001000dULL,
0x0000002b510c7223ULL, 0x080fe2000001000cULL, 0x0000002b580b7223ULL, 0x080fe2000001000bULL,
0x0000002b530a7223ULL, 0x080fe2000001000aULL, 0x0000002b55027223ULL, 0x000fe20000010002ULL,
0xfffff24000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x000000ff3b00720cULL, 0x000fe20003f05270ULL,
0x0000001003067824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fca00078ec0ffULL,
0x0000000103087824ULL, 0x000fe200078e0206ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000001003067824ULL, 0x002fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006037812ULL, 0x000fe400078ec0ffULL,
0x0000000c07067812ULL, 0x000fc600078ec0ffULL, 0x0000008048037824ULL, 0x000fc800078e0203ULL,
0x0000000106037824ULL, 0x000fca00078e0203ULL, 0x0049803603007388ULL, 0x0003e40000000800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800008037984ULL, 0x002e680000000800ULL,
0x004a000008067984ULL, 0x000ea20000000800ULL, 0x00000003ff037221ULL, 0x002fc80000010000ULL,
0x0000000603037221ULL, 0x004fca0000010000ULL, 0x0180000003067810ULL, 0x000fc80007ffe0ffULL,
0x7f80000006067812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0600780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e0003ULL, 0x0000f01000067802ULL, 0x000fe40000000f00ULL,
0x0000692000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff067224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000300067308ULL, 0x000e640000001000ULL,
0xbf80000003077423ULL, 0x002fc80000000006ULL, 0x800000ff07077221ULL, 0x000fc80000010100ULL,
0x0000000706067223ULL, 0x000fe40000000006ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000803437811ULL, 0x004fe400078ff0ffULL, 0x00000002ff337819ULL, 0x000fe40000011603ULL,
0x00000043ff457212ULL, 0x000fe200078e33ffULL, 0x00001f4306097589ULL, 0x000ea200000e0000ULL,
0x0000000843087824ULL, 0x000fc400078e00ffULL, 0x0000000833477824ULL, 0x000fe200078e00ffULL,
0x00001f3306077589ULL, 0x00096400000e0000ULL, 0xfffffff808457812ULL, 0x000fca00078ee245ULL,
0x0000001045457824ULL, 0x000fe200078e0200ULL, 0x00000033ff067212ULL, 0x010fc800078e33ffULL,
0xfffffff847477812ULL, 0x000fe200078ee206ULL, 0x0000000833067824ULL, 0x000fe200078e00ffULL,
0x0000001809187220ULL, 0x044fe20000410000ULL, 0x0000001709177220ULL, 0x040fe20000410000ULL,
0x0000001609167220ULL, 0x040fe20000410000ULL, 0x0000001509157220ULL, 0x040fe20000410000ULL,
0x0000001409147220ULL, 0x040fe20000410000ULL, 0x0000001309137220ULL, 0x040fe20000410000ULL,
0x0000001209127220ULL, 0x040fe20000410000ULL, 0x0000001109117220ULL, 0x040fe20000410000ULL,
0x0000001009107220ULL, 0x040fe20000410000ULL, 0x0000000f090f7220ULL, 0x040fe20000410000ULL,
0x0000000e090e7220ULL, 0x040fe20000410000ULL, 0x0000000d090d7220ULL, 0x040fe20000410000ULL,
0x0000000c090c7220ULL, 0x040fe20000410000ULL, 0x0000000b090b7220ULL, 0x040fe20000410000ULL,
0x0000000a090a7220ULL, 0x040fe20000410000ULL, 0x0000000209097220ULL, 0x000fe20000410000ULL,
0x0000000733027812ULL, 0x000fe200078ec0ffULL, 0x0000002807287220ULL, 0x060fe20000410000ULL,
0x0000002707277220ULL, 0x040fe20000410000ULL, 0x0000002607267220ULL, 0x040fe20000410000ULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000002207227220ULL, 0x040fe20000410000ULL,
0x0000002107217220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000001f071f7220ULL, 0x040fe20000410000ULL, 0x0000001e071e7220ULL, 0x040fe20000410000ULL,
0x0000001d071d7220ULL, 0x040fe20000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000001b071b7220ULL, 0x040fe20000410000ULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x0000001907077220ULL, 0x000fe20000410000ULL, 0x0000000e0d0d723eULL, 0x000fc400000010ffULL,
0x0000000c0b0b723eULL, 0x000fe400000010ffULL, 0x0000000a0909723eULL, 0x000fe400000010ffULL,
0xfffffff806197812ULL, 0x000fe400078ee233ULL, 0x0000000102067812ULL, 0x040fe400078e3cffULL,
0x0000000202087812ULL, 0x040fe200078e3cffULL, 0x0000001019197824ULL, 0x000fe200078e0200ULL,
0x00000003020a7812ULL, 0x040fe200078e3cffULL, 0x0000000833297824ULL, 0x040fe200078e0206ULL,
0x00000004020c7812ULL, 0x040fe200078e3cffULL, 0x00000008332b7824ULL, 0x040fe200078e0208ULL,
0x00000005020e7812ULL, 0x040fe200078e3cffULL, 0x00000008332d7824ULL, 0x040fe200078e020aULL,
0x0000000602027812ULL, 0x000fe200078e3cffULL, 0x00000008332f7824ULL, 0x008fe200078e020cULL,
0x000000121111723eULL, 0x000fe200000010ffULL, 0x0000000833317824ULL, 0x000fe200078e020eULL,
0x0000000743127812ULL, 0x000fe200078ec0ffULL, 0x0000000833337824ULL, 0x000fe200078e0202ULL,
0x000000141313723eULL, 0x000fe200000010ffULL, 0x0000000843147824ULL, 0x000fe200078e00ffULL,
0x000000100f0f723eULL, 0x000fe200000010ffULL, 0x0000000403107824ULL, 0x000fe200078e00ffULL,
0x0000000112027812ULL, 0x040fe200078e3cffULL, 0x0000001029297824ULL, 0x100fe200078e0200ULL,
0x0000000212067812ULL, 0x040fe200078e3cffULL, 0x000000102b2b7824ULL, 0x000fe200078e0200ULL,
0x0000000312087812ULL, 0x040fe200078e3cffULL, 0x0000000843377824ULL, 0x040fe200078e0202ULL,
0x00000004120a7812ULL, 0x040fe200078e3cffULL, 0x0000000843397824ULL, 0x040fe200078e0206ULL,
0x00000005120c7812ULL, 0x040fe200078e3cffULL, 0x00000008433d7824ULL, 0x042fe200078e0208ULL,
0x00000006120e7812ULL, 0x000fe200078e3cffULL, 0x00000008433f7824ULL, 0x000fe200078e020aULL,
0x0000001c1b1b723eULL, 0x000fe200000010ffULL, 0x0000000843417824ULL, 0x040fe200078e020cULL,
0xfffffff814357812ULL, 0x000fe200078ee243ULL, 0x0000000843437824ULL, 0x000fe200078e020eULL,
0x0000000c101c7812ULL, 0x000fe200078ec0ffULL, 0x0000001047067824ULL, 0x100fe200078e0200ULL,
0x000000282727723eULL, 0x000fe200000010ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0200ULL,
0x000000262525723eULL, 0x000fe200000010ffULL, 0x0000001035357824ULL, 0x100fe200078e0200ULL,
0x000000242323723eULL, 0x000fe200000010ffULL, 0x000000011c027824ULL, 0x000fe200078e0219ULL,
0x000000222121723eULL, 0x000fe200000010ffULL, 0x000000102f2f7824ULL, 0x100fe200078e0200ULL,
0x000000201f1f723eULL, 0x000fe200000010ffULL, 0x0000001031317824ULL, 0x100fe200078e0200ULL,
0x0000001e1d1d723eULL, 0x000fe200000010ffULL, 0x0000001033337824ULL, 0x100fe200078e0200ULL,
0x0000002702007388ULL, 0x0003e20000000800ULL, 0x0000001037377824ULL, 0x100fe200078e0200ULL,
0x0000001a0707723eULL, 0x000fe200000010ffULL, 0x0000001039397824ULL, 0x100fe200078e0200ULL,
0x000000181717723eULL, 0x000fe200000010ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0200ULL,
0x000000161515723eULL, 0x000fe200000010ffULL, 0x000000103f3f7824ULL, 0x000fc400078e0200ULL,
0x0000001041417824ULL, 0x100fe400078e0200ULL, 0x0000001043437824ULL, 0x000fe400078e0200ULL,
0x000000011c107824ULL, 0x040fe400078e0206ULL, 0x000000011c007824ULL, 0x040fe400078e0229ULL,
0x000000011c067824ULL, 0x040fe400078e022bULL, 0x000000011c087824ULL, 0x040fe200078e022dULL,
0x0000002500007388ULL, 0x0005e20000000800ULL, 0x000000011c0a7824ULL, 0x000fc400078e022fULL,
0x000000011c0c7824ULL, 0x040fe200078e0231ULL, 0x0000002306007388ULL, 0x000fe20000000800ULL,
0x000000011c0e7824ULL, 0x040fe400078e0233ULL, 0x000000011c127824ULL, 0x040fe200078e0235ULL,
0x0000002108007388ULL, 0x000fe20000000800ULL, 0x000000011c147824ULL, 0x040fe400078e0237ULL,
0x000000011c027824ULL, 0x042fe200078e0239ULL, 0x0000001f0a007388ULL, 0x000fe20000000800ULL,
0x000000011c167824ULL, 0x000fc400078e023dULL, 0x000000011c187824ULL, 0x040fe200078e023fULL,
0x0000001d0c007388ULL, 0x000fe20000000800ULL, 0x000000011c1e7824ULL, 0x040fe400078e0245ULL,
0x000000011c1a7824ULL, 0x040fe200078e0241ULL, 0x0000001b0e007388ULL, 0x000fe20000000800ULL,
0x000000011c1c7824ULL, 0x000fe400078e0243ULL, 0x0000002048207824ULL, 0x000fe200078e0203ULL,
0x0000000710007388ULL, 0x0003e60000000800ULL, 0x0000001020007824ULL, 0x004fe200078e0205ULL,
0x0000001712007388ULL, 0x000fe80000000800ULL, 0x0000001514007388ULL, 0x000fe20000000800ULL,
0x000000040410723eULL, 0x002fc600000010ffULL, 0x0000001302007388ULL, 0x000fe80000000800ULL,
0x0000001116007388ULL, 0x000fe80000000800ULL, 0x0000000f18007388ULL, 0x000fe80000000800ULL,
0x0000000d1a007388ULL, 0x000fe80000000800ULL, 0x0000000b1c007388ULL, 0x000fe80000000800ULL,
0x000000091e007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000207984ULL, 0x000e680000000c00ULL, 0x0004000000287984ULL, 0x000ea80000000c00ULL,
0x0008000000247984ULL, 0x000ee80000000c00ULL, 0x000c0000002c7984ULL, 0x000f220000000c00ULL,
0x3f803f8010237831ULL, 0x002fc40000200023ULL, 0x3f803f8010227831ULL, 0x040fe40000200022ULL,
0x3f803f8010217831ULL, 0x040fe40000200021ULL, 0x3f803f8010207831ULL, 0x040fe40000200020ULL,
0x3f803f80102b7831ULL, 0x044fe4000020002bULL, 0x3f803f80102a7831ULL, 0x040fe4000020002aULL,
0x3f803f8010297831ULL, 0x000fc40000200029ULL, 0x3f803f8010287831ULL, 0x000fe40000200028ULL,
0x3f803f8023237831ULL, 0x008fe40000200027ULL, 0x3f803f8022227831ULL, 0x000fe40000200026ULL,
0x3f803f8021217831ULL, 0x000fe40000200025ULL, 0x3f803f8020207831ULL, 0x000fe40000200024ULL,
0x3f803f802b2b7831ULL, 0x010fc4000020002fULL, 0x3f803f802a2a7831ULL, 0x000fe2000020002eULL,
0x0000002000007388ULL, 0x0003e20000000c00ULL, 0x3f803f8029297831ULL, 0x000fe4000020002dULL,
0x3f803f8028287831ULL, 0x000fca000020002cULL, 0x0004002800007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff4800720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000147919ULL, 0x002e620000002600ULL,
0x0000002003157810ULL, 0x040fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000ee20000002700ULL,
0x0000004003177810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x00000003ff007819ULL, 0x000fe20000011603ULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x0000006003217810ULL, 0x000fe20007ffe0ffULL, 0x000000083b167824ULL, 0x040fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fe20000011615ULL, 0x000000083b207824ULL, 0x040fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fe20000011617ULL, 0x000000083b227824ULL, 0x000fe200078e00ffULL,
0x00000003ff097819ULL, 0x004fc40000011621ULL, 0x0000000704067812ULL, 0x000fe400078e4815ULL,
0x0000000707087812ULL, 0x000fe400078e4817ULL, 0x00000007090a7812ULL, 0x000fe400078e4821ULL,
0x0ffffff806067812ULL, 0x000fe400078ef815ULL, 0x0ffffff808087812ULL, 0x000fe200078ef817ULL,
0x00000010140b7824ULL, 0x002fe200078e00ffULL, 0x0ffffff80a0a7812ULL, 0x000fe200078ef821ULL,
0x0000001006067824ULL, 0x100fe200078e0205ULL, 0x00000004050472a4ULL, 0x008fe2000f8e023fULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0xfffffff00b027812ULL, 0x000fe200078ee200ULL,
0x000000100a0a7824ULL, 0x000fe200078e0205ULL, 0x0000000700007812ULL, 0x100fe200078e4803ULL,
0x0000000006107984ULL, 0x000fe20000000c00ULL, 0xfffffff8160b7812ULL, 0x100fe200078ee203ULL,
0x0000001014167824ULL, 0x000fe200078e00ffULL, 0x0ffffff800007812ULL, 0x000fe200078ef803ULL,
0x0000000008187984ULL, 0x000fe20000000c00ULL, 0x0000000402037c10ULL, 0x000fc4000ff1e0ffULL,
0xfffffff016077812ULL, 0x000fe200078ee207ULL, 0x0000001000007824ULL, 0x000fe200078e0205ULL,
0x000000000a1c7984ULL, 0x0003e20000000c00ULL, 0x0000001014057824ULL, 0x040fe200078e00ffULL,
0x0000000407077c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001014147824ULL, 0x000fe200078e00ffULL,
0x00000000000c7984ULL, 0x0004e20000000c00ULL, 0x000000083b167824ULL, 0x000fe200078e00ffULL,
0xfffffff005047812ULL, 0x000fe400078ee204ULL, 0xfffffff014097812ULL, 0x000fe200078ee209ULL,
0x000000ffff0a7224ULL, 0x002fe200008e06ffULL, 0x00005a0007067a11ULL, 0x000fe200078240ffULL,
0x000000ffff007224ULL, 0x004fe200000e06ffULL, 0x00005a0003027a11ULL, 0x000fc400078040ffULL,
0x0000000409097c10ULL, 0x000fe4000ff5e0ffULL, 0x00005b0003037a11ULL, 0x000fe400000f4400ULL,
0x0000000404057c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff007224ULL, 0x000fe200010e06ffULL,
0x00005a0009087a11ULL, 0x000fe200078440ffULL, 0x000000100b027825ULL, 0x000fe200078e0002ULL,
0xfffffff820157812ULL, 0x000fe400078ee215ULL, 0xfffffff822177812ULL, 0x000fe200078ee217ULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x00005a0005047a11ULL, 0x000fc400078040ffULL,
0x00005b0007077a11ULL, 0x000fe400008f440aULL, 0x00005b0005057a11ULL, 0x000fe400000f4414ULL,
0xfffffff816217812ULL, 0x000fe200078ee221ULL, 0x0000001017067825ULL, 0x000fe200078e0006ULL,
0x00005b0009097a11ULL, 0x000fc600010f4400ULL, 0x0000001015047825ULL, 0x000fc800078e0004ULL,
0x0000001021087825ULL, 0x000fe200078e0008ULL, 0x0000000c02007986ULL, 0x008fe8000c101d08ULL,
0x0000001004007986ULL, 0x000fe8000c101d08ULL, 0x0000001806007986ULL, 0x000fe8000c101d08ULL,
0x0000001c08007986ULL, 0x000fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff047624ULL, 0x000fe400078e00ffULL, 0x00006700ff057624ULL, 0x000fca00078e00ffULL,
0x00000008043c7981ULL, 0x000362000c1e9900ULL, 0x0000000134007810ULL, 0x000fe20007ffe0ffULL,
0x0000000238077824ULL, 0x000fe400078e00ffULL, 0x0000004002377824ULL, 0x000fe200078e00ffULL,
0x000000350000720cULL, 0x000fe20003f06070ULL, 0x0000580007367a24ULL, 0x000fe400078e0210ULL,
0x0000010034097824ULL, 0x000fc800078e0237ULL, 0x0000620036187a24ULL, 0x000fcc00078e0209ULL,
0x000005c000008947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x002e620000000000ULL,
0x00000080ff217424ULL, 0x000fe200078e00ffULL, 0x0000000903007217ULL, 0x000fe40007800000ULL,
0x0000100002147811ULL, 0x000fc600078e68ffULL, 0x0000000100007824ULL, 0x000fe200078e0a09ULL,
0x00000002ff1d7819ULL, 0x102fe2000001160fULL, 0x000000100f1f7824ULL, 0x000fe200078e00ffULL,
0x00000003ff127819ULL, 0x000fe4000001160fULL, 0x000000081d117810ULL, 0x040fe20007ffe0ffULL,
0x000000011d047824ULL, 0x140fe200078e0218ULL, 0x000000181d257810ULL, 0x040fe40007ffe0ffULL,
0x000000101d237810ULL, 0x000fe20007ffe0ffULL, 0x0000000111067824ULL, 0x000fe200078e0218ULL,
0x000000301f1f7812ULL, 0x000fe200078ec0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0x000000201d177810ULL, 0x000fc40007ffe0ffULL, 0x0000000312127812ULL, 0x100fe200078e480fULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0x0000001f040c7210ULL, 0x080fe40007f1e0ffULL,
0x000000281d197810ULL, 0x000fe20007ffe0ffULL, 0x00000001250a7824ULL, 0x100fe200078e0218ULL,
0x0000001f06067210ULL, 0x000fe20007f3e0ffULL, 0x0000000123087824ULL, 0x000fe200078e0218ULL,
0x0ffffffc120f7812ULL, 0x000fe200078ef80fULL, 0x00005e000a0a7625ULL, 0x000fe200078e0021ULL,
0x000000301d1b7810ULL, 0x000fc40007ffe0ffULL, 0x000000002300720cULL, 0x080fe20003fa6070ULL,
0x0000000118047824ULL, 0x000fe200078e0217ULL, 0x000000001700720cULL, 0x080fe20003f66070ULL,
0x00005e0008087625ULL, 0x000fe200078e0021ULL, 0x000000002500720cULL, 0x000fc60003f86070ULL,
0x000000ffff0d7224ULL, 0x000fe200000e0605ULL, 0x0000001f08087210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x0000001f0a0a7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0004047625ULL, 0x000fc800078e0021ULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000001f040e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000118047824ULL, 0x000fe200078e0219ULL,
0x000000001100720cULL, 0x080fe20003f26070ULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x000000001d00720cULL, 0x080fe20003f06070ULL, 0x0000000411117824ULL, 0x000fe200078e00ffULL,
0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL, 0x000000100f137824ULL, 0x000fe400078e0214ULL,
0x000000ffff0f7224ULL, 0x000fe200010e0605ULL, 0xfffffffc11117812ULL, 0x000fe200078ee212ULL,
0x00005e0004047625ULL, 0x000fe200078e0021ULL, 0x000000001900720cULL, 0x000fc60003f46070ULL,
0x0000001011157824ULL, 0x000fe200078e0214ULL, 0x0000001f04107210ULL, 0x000fe20007fde0ffULL,
0x0000000118047824ULL, 0x000fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c137faeULL, 0x0003e2000c101c48ULL, 0x000000001d00720cULL, 0x080fe40003f06070ULL,
0x000000ffff117224ULL, 0x000fe200030e0605ULL, 0x0000000006157faeULL, 0x0005e2000c901c48ULL,
0x00005e0004047625ULL, 0x000fe200078e0021ULL, 0x000000001b00720cULL, 0x000fc80003f26070ULL,
0x0000001f04047210ULL, 0x000fe20007fde0ffULL, 0x00000004230d7824ULL, 0x002fe400078e00ffULL,
0x0000000425137824ULL, 0x000fe400078e00ffULL, 0x0000000118067824ULL, 0x004fe200078e021dULL,
0xfffffffc0d0d7812ULL, 0x100fe200078ee212ULL, 0x0000000417157824ULL, 0x000fe200078e00ffULL,
0xfffffffc13137812ULL, 0x100fe200078ee212ULL, 0x0000000419177824ULL, 0x000fe400078e00ffULL,
0x000000041b197824ULL, 0x000fe200078e00ffULL, 0xfffffffc15157812ULL, 0x100fe200078ee212ULL,
0x000000041d1b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc17177812ULL, 0x100fe200078ee212ULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0xfffffffc19197812ULL, 0x000fc400078ee212ULL,
0xfffffffc1b1b7812ULL, 0x000fe200078ee212ULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x0000001f06067210ULL, 0x000fe20007fde0ffULL, 0x000000100d0d7824ULL, 0x100fe400078e0214ULL,
0x0000001013137824ULL, 0x100fe400078e0214ULL, 0x0000001015157824ULL, 0x100fe200078e0214ULL,
0x00000000080d7faeULL, 0x0003e2000e901c48ULL, 0x0000001017177824ULL, 0x100fe400078e0214ULL,
0x0000001019197824ULL, 0x100fe200078e0214ULL, 0x000000000a137faeULL, 0x0003e2000e101c48ULL,
0x000000101b1b7824ULL, 0x000fc400078e0214ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x000000000e157faeULL, 0x0003e8000d901c48ULL, 0x0000000010177faeULL, 0x0003e8000d101c48ULL,
0x0000000004197faeULL, 0x0003e8000c901c48ULL, 0x00000000061b7faeULL, 0x0003e2000c101c48ULL,
0x0000050000007947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x002e620000000000ULL,
0x00000080ff237424ULL, 0x000fe200078e00ffULL, 0x0000100002217811ULL, 0x000fe200078e68ffULL,
0x000000100f067824ULL, 0x042fe200078e00ffULL, 0x000000100f057811ULL, 0x000fc400078ff0ffULL,
0x000000180f047211ULL, 0x000fe400078ff0ffULL, 0x00000003ff007819ULL, 0x000fe2000001160fULL,
0x0000000405137824ULL, 0x000fe200078e00ffULL, 0x000000080f0d7811ULL, 0x040fe400078ff0ffULL,
0x0000003006257812ULL, 0x000fe200078ec0ffULL, 0x0000000118067824ULL, 0x000fe200078e0205ULL,
0x000000200f097811ULL, 0x040fe200078ff0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0023ULL,
0x000000180f077811ULL, 0x000fc400078ff0ffULL, 0x00000003001a7812ULL, 0x000fe200078e480fULL,
0x000000010d007824ULL, 0x000fe200078e0218ULL, 0x000000280f0a7811ULL, 0x000fe200078ff0ffULL,
0x000000040d117824ULL, 0x000fe200078e00ffULL, 0x000000300f0b7811ULL, 0x000fe200078ff0ffULL,
0x00000001180d7824ULL, 0x000fe200078e0209ULL, 0x00000025040e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0x000000380f0c7811ULL, 0x000fe200078ff0ffULL,
0x0000000118087824ULL, 0x000fe200078e0207ULL, 0x0ffffffc1a127812ULL, 0x000fe200078ef80fULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0xfffffffc09107812ULL, 0x000fe200078ee21aULL,
0x0000000118147824ULL, 0x000fc400078e020aULL, 0x000000040a157824ULL, 0x000fe200078e00ffULL,
0xfffffffc110a7812ULL, 0x100fe200078ee21aULL, 0x0000000118167824ULL, 0x040fe400078e020bULL,
0x000000ffff0f7224ULL, 0x000fe200000e0605ULL, 0xfffffffc15117812ULL, 0x000fe200078ee21aULL,
0x0000000118187824ULL, 0x000fe400078e020cULL, 0x000000040c197824ULL, 0x000fe200078e00ffULL,
0xfffffffc070c7812ULL, 0x000fe200078ee21aULL, 0x00005e0000047625ULL, 0x000fc800078e0023ULL,
0x000000040b177824ULL, 0x000fe200078e00ffULL, 0xfffffffc130b7812ULL, 0x000fe200078ee21aULL,
0x00005e0006067625ULL, 0x000fc600078e0023ULL, 0xfffffffc17137812ULL, 0x100fe200078ee21aULL,
0x00000010101b7824ULL, 0x000fe200078e0221ULL, 0x0000002504107210ULL, 0x000fe20007f1e0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0023ULL, 0xfffffffc191a7812ULL, 0x000fc600078ee21aULL,
0x0000001012277824ULL, 0x100fe200078e0221ULL, 0x0000002506127210ULL, 0x080fe20007f3e0ffULL,
0x00000010111d7824ULL, 0x000fe400078e0221ULL, 0x000000ffff117224ULL, 0x000fe200000e0605ULL,
0x0000002508087210ULL, 0x000fe20007f1e0ffULL, 0x00000010131f7824ULL, 0x000fe200078e0221ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e277faeULL, 0x0003e2000b901c48ULL,
0x000000ffff137224ULL, 0x000fe400008e0607ULL, 0x00005e000d047625ULL, 0x000fc800078e0023ULL,
0x000000100a157824ULL, 0x100fe400078e0221ULL, 0x000000100b177824ULL, 0x100fe400078e0221ULL,
0x00005e0014067625ULL, 0x000fe200078e0023ULL, 0x0000000010157faeULL, 0x0003e6000b901c48ULL,
0x000000100c197824ULL, 0x000fe200078e0221ULL, 0x0000002506067210ULL, 0x000fe20007f3e0ffULL,
0x00005e00160a7625ULL, 0x080fe200078e0023ULL, 0x0000000012177faeULL, 0x0003e6000b901c48ULL,
0x00005e00180c7625ULL, 0x000fe200078e0023ULL, 0x000000250a0a7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x0000002504047210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x000000250c0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000000008197faeULL, 0x0003e2000b901c48ULL,
0x000000ffff057224ULL, 0x000fe400000e0605ULL, 0x000000101a217824ULL, 0x000fe400078e0221ULL,
0x000000ffff0d7224ULL, 0x000fe200018e060dULL, 0x00000000041b7faeULL, 0x0003e8000b901c48ULL,
0x00000000061d7faeULL, 0x0003e8000b901c48ULL, 0x000000000a1f7faeULL, 0x0003e8000b901c48ULL,
0x000000000c217faeULL, 0x0003e4000b901c48ULL, 0x00f60400ff007984ULL, 0x000ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000000ff7812ULL, 0x004fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x00f60400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000030200780cULL, 0x000fda0003f04070ULL, 0x0000017000000947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x002e640000000000ULL, 0x0000002002007824ULL, 0x002fc800078e0205ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7800ULL,
0x0000000707077812ULL, 0x000fc600078e7800ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001005007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ffff7f8cULL, 0x000fe8000c80043fULL, 0x00f60400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x00f60400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000353400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000003d7919ULL, 0x000ea20000000000ULL,
0x3db504f33c3c7820ULL, 0x020fe20000410000ULL, 0x00000010023a7824ULL, 0x000fe200078e00ffULL,
0xffffffff353b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x00007610ff387816ULL, 0x000fe40000000038ULL, 0x00000100343e7824ULL, 0x000fe200078e0237ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003e0300720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x008fea0003800000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e0039ULL,
0x0000000000147805ULL, 0x002fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fc4000001ff00ULL, 0x0000000100247810ULL, 0x000fe20007ffe0ffULL,
0x00000a9000007945ULL, 0x000fe20003800000ULL, 0x000000ffff407224ULL, 0x000fe200078e0000ULL,
0x000000013f397812ULL, 0x000fc400078e0cffULL, 0x00000001ff257819ULL, 0x100fe20000011624ULL,
0x000000ffff007224ULL, 0x000fe200078e0024ULL, 0x000000022400780cULL, 0x000fc60003f06070ULL,
0x0000030025267a24ULL, 0x000fe200078e0234ULL, 0x0000000124257812ULL, 0x000fc600078ec0ffULL,
0x0000010026277824ULL, 0x040fe200078e0237ULL, 0x0000000126287810ULL, 0x000fc60007ffe0ffULL,
0x0000620036327a24ULL, 0x000fe200078e0227ULL, 0x000000352800720cULL, 0x000fda0003f26070ULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x0000002703247217ULL, 0x000fe20007800000ULL,
0x00000004252a7824ULL, 0x000fe200078e00ffULL, 0x00000002ff2d7819ULL, 0x004fe2000001163dULL,
0x0000000202307824ULL, 0x000fe200078e0239ULL, 0x00000003ff267819ULL, 0x000fe2000001163dULL,
0x0000000124287824ULL, 0x000fe200078e0a27ULL, 0x000000082d257810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000000326427812ULL, 0x100fe200078e483dULL,
0x000000012d247824ULL, 0x140fe200078e0232ULL, 0x000000282d00720cULL, 0x080fe20003f26070ULL,
0x0000000125267824ULL, 0x040fe200078e0232ULL, 0x000000282500720cULL, 0x040fe20003f46070ULL,
0x00000004252b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc2a317812ULL, 0x000fe200078ee23dULL,
0x00005e0024247625ULL, 0x000fe200078e002fULL, 0x0000100030307811ULL, 0x000fc400078e60ffULL,
0x0ffffffc42297812ULL, 0x000fe200078ef83dULL, 0x00005e0026267625ULL, 0x000fe200078e002fULL,
0xfffffffc2b2b7812ULL, 0x000fe400078ee242ULL, 0x000000102d337810ULL, 0x000fe20007ffe0ffULL,
0x0000001029297824ULL, 0x000fe200078e0230ULL, 0x000000182d417810ULL, 0x000fe20007ffe0ffULL,
0x0000001031247825ULL, 0x000fe200078e0024ULL, 0x000000202d437810ULL, 0x040fe40007ffe0ffULL,
0x000000282d457810ULL, 0x000fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0230ULL,
0x000000302d477810ULL, 0x000fe20007ffe0ffULL, 0x0000001031267825ULL, 0x000fe200078e0026ULL,
0x000000382d2d7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024297faeULL, 0x0003e2000c901c48ULL, 0x000000283300720cULL, 0x080fe20003f26070ULL,
0x00000001452a7824ULL, 0x100fe200078e0232ULL, 0x000000284300720cULL, 0x080fe20003f66070ULL,
0x00000000262b7faeULL, 0x0005e2000d101c48ULL, 0x000000284100720cULL, 0x080fe20003f46070ULL,
0x00000001472c7824ULL, 0x100fe200078e0232ULL, 0x000000284500720cULL, 0x080fe20003f86070ULL,
0x000000012d2e7824ULL, 0x100fe200078e0232ULL, 0x000000284700720cULL, 0x080fe20003fa6070ULL,
0x000000042d497824ULL, 0x040fe200078e00ffULL, 0x000000282d00720cULL, 0x000fe20003fc6070ULL,
0x0000000133247824ULL, 0x002fc400078e0232ULL, 0x0000000143287824ULL, 0x000fe200078e0232ULL,
0xfffffffc49497812ULL, 0x000fe200078ee242ULL, 0x0000000141267824ULL, 0x004fe400078e0232ULL,
0x0000000433337824ULL, 0x000fe400078e00ffULL, 0x0000000441417824ULL, 0x000fe400078e00ffULL,
0x0000000443437824ULL, 0x000fe200078e00ffULL, 0xfffffffc33337812ULL, 0x100fe200078ee242ULL,
0x00005e0024247625ULL, 0x000fe200078e002fULL, 0xfffffffc41417812ULL, 0x000fc400078ee242ULL,
0xfffffffc43437812ULL, 0x000fe200078ee242ULL, 0x00005e0026267625ULL, 0x000fc800078e002fULL,
0x00005e0028287625ULL, 0x000fc800078e002fULL, 0x00005e002a2a7625ULL, 0x000fc800078e002fULL,
0x00005e002c2c7625ULL, 0x000fc800078e002fULL, 0x0000000445457824ULL, 0x000fe400078e00ffULL,
0x00005e002e2e7625ULL, 0x000fc600078e002fULL, 0xfffffffc45457812ULL, 0x000fe200078ee242ULL,
0x0000000447477824ULL, 0x000fe400078e00ffULL, 0x0000001031247825ULL, 0x000fc600078e0024ULL,
0xfffffffc47477812ULL, 0x000fe200078ee242ULL, 0x0000001031267825ULL, 0x000fc800078e0026ULL,
0x0000001031287825ULL, 0x000fc800078e0028ULL, 0x00000010312a7825ULL, 0x000fc800078e002aULL,
0x00000010312c7825ULL, 0x000fc800078e002cULL, 0x00000010312e7825ULL, 0x000fc800078e002eULL,
0x0000001033317824ULL, 0x100fe400078e0230ULL, 0x0000001041337824ULL, 0x100fe400078e0230ULL,
0x0000001043417824ULL, 0x100fe200078e0230ULL, 0x0000000024317faeULL, 0x0003e2000c901c48ULL,
0x0000001045437824ULL, 0x100fe400078e0230ULL, 0x0000001047457824ULL, 0x100fe200078e0230ULL,
0x0000000026337faeULL, 0x0003e2000d101c48ULL, 0x0000001049477824ULL, 0x000fc600078e0230ULL,
0x0000000028417faeULL, 0x0003e8000d901c48ULL, 0x000000002a437faeULL, 0x0003e8000e101c48ULL,
0x000000002c457faeULL, 0x0003e8000e901c48ULL, 0x000000002e477faeULL, 0x0003e2000f101c48ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x0000000425287824ULL, 0x000fe200078e00ffULL,
0x00000003ff267819ULL, 0x004fe2000001163dULL, 0x0000000202257824ULL, 0x000fe200078e0239ULL,
0x000000083d277811ULL, 0x040fe200078ff0ffULL, 0x00000080ff337424ULL, 0x000fe200078e00ffULL,
0x000000103d297811ULL, 0x000fc400078ff0ffULL, 0x000000183d2b7811ULL, 0x040fe400078ff0ffULL,
0x000000203d2d7811ULL, 0x040fe400078ff0ffULL, 0x000000283d2f7811ULL, 0x000fe200078ff0ffULL,
0x000000012b2a7824ULL, 0x100fe200078e0232ULL, 0x000000303d317811ULL, 0x000fe200078ff0ffULL,
0x000000012d2c7824ULL, 0x100fe200078e0232ULL, 0x000000383d437811ULL, 0x000fe200078ff0ffULL,
0x000000012f2e7824ULL, 0x100fe200078e0232ULL, 0xfffffffc28417812ULL, 0x100fe200078ee23dULL,
0x0000000129287824ULL, 0x100fe200078e0232ULL, 0x0000000326427812ULL, 0x000fe200078e483dULL,
0x0000000127267824ULL, 0x100fe200078e0232ULL, 0x000000323d247211ULL, 0x000fe200078ff0ffULL,
0x0000000131307824ULL, 0x000fe200078e0232ULL, 0x00001000254d7811ULL, 0x000fe200078e60ffULL,
0x0000000427277824ULL, 0x000fc400078e00ffULL, 0x0000000429297824ULL, 0x000fe400078e00ffULL,
0x000000042b2b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc27447812ULL, 0x100fe200078ee242ULL,
0x000000042d2d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc29467812ULL, 0x100fe200078ee242ULL,
0x000000042f2f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc2b487812ULL, 0x100fe200078ee242ULL,
0x0000000431317824ULL, 0x000fe200078e00ffULL, 0xfffffffc2d4a7812ULL, 0x000fe200078ee242ULL,
0x0000000143327824ULL, 0x000fe200078e0232ULL, 0xfffffffc2f4c7812ULL, 0x100fe200078ee242ULL,
0x0000000443437824ULL, 0x000fe200078e00ffULL, 0xfffffffc314e7812ULL, 0x000fe200078ee242ULL,
0x00005e0024247625ULL, 0x000fc600078e0033ULL, 0xfffffffc43507812ULL, 0x000fe200078ee242ULL,
0x00005e0026267625ULL, 0x000fe200078e0033ULL, 0x0ffffffc42427812ULL, 0x000fc600078ef83dULL,
0x00005e0028287625ULL, 0x000fc800078e0033ULL, 0x00005e002a2a7625ULL, 0x000fc800078e0033ULL,
0x00005e002c2c7625ULL, 0x000fc800078e0033ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0033ULL,
0x00005e0030307625ULL, 0x000fc800078e0033ULL, 0x00005e0032327625ULL, 0x000fc800078e0033ULL,
0x0000001041247825ULL, 0x000fc800078e0024ULL, 0x0000001041267825ULL, 0x000fc800078e0026ULL,
0x0000001041287825ULL, 0x000fc800078e0028ULL, 0x00000010412a7825ULL, 0x000fc800078e002aULL,
0x00000010412c7825ULL, 0x000fc800078e002cULL, 0x00000010412e7825ULL, 0x000fc800078e002eULL,
0x0000001041307825ULL, 0x000fc800078e0030ULL, 0x0000001041327825ULL, 0x000fc800078e0032ULL,
0x00000010424f7824ULL, 0x100fe400078e024dULL, 0x0000001044417824ULL, 0x100fe400078e024dULL,
0x0000001046437824ULL, 0x100fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000244f7faeULL, 0x0003e2000b901c48ULL, 0x0000001048457824ULL, 0x100fe400078e024dULL,
0x000000104a477824ULL, 0x100fe200078e024dULL, 0x0000000026417faeULL, 0x0003e2000b901c48ULL,
0x000000104c497824ULL, 0x000fc400078e024dULL, 0x000000104e4b7824ULL, 0x100fe200078e024dULL,
0x0000000028437faeULL, 0x0003e2000b901c48ULL, 0x00000010504d7824ULL, 0x000fc600078e024dULL,
0x000000002a457faeULL, 0x0003e8000b901c48ULL, 0x000000002c477faeULL, 0x0003e8000b901c48ULL,
0x000000002e497faeULL, 0x0003e8000b901c48ULL, 0x00000000304b7faeULL, 0x0003e8000b901c48ULL,
0x00000000324d7faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000840427824ULL, 0x000fc400078e00ffULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff83d247812ULL, 0x002fe200078ec0ffULL, 0x0000000202287824ULL, 0x000fe200078e023fULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000001402a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000724247812ULL, 0x000fe400078ef83dULL, 0x0000100028287811ULL, 0x000fe400078e60ffULL,
0x00000001ff257819ULL, 0x000fc40000011624ULL, 0x000000073dcc7812ULL, 0x000fe400078ec0ffULL,
0x0000000325257812ULL, 0x000fe400078ec0ffULL, 0x00000008cccc7812ULL, 0x000fe400078ef83dULL,
0x0000004025277212ULL, 0x040fe400078e3cffULL, 0x0000002a25257212ULL, 0x000fc600078e3cffULL,
0x0000000424277824ULL, 0x040fe400078e0227ULL, 0x0000000424257824ULL, 0x000fe200078e0225ULL,
0x000000203d247810ULL, 0x000fe20007ffe0ffULL, 0x0000001027277824ULL, 0x100fe400078e0228ULL,
0x0000001025257824ULL, 0x000fe200078e0228ULL, 0xfffffff824247812ULL, 0x000fe400078ec0ffULL,
0x000000002730783bULL, 0x000e640000000200ULL, 0x0000000724297812ULL, 0x000fc400078ef83dULL,
0x00000000252c783bULL, 0x0004e40000000200ULL, 0x00000001ff247819ULL, 0x000fc80000011629ULL,
0x00000003242b7812ULL, 0x000fc800078ec0ffULL, 0x000000402b247212ULL, 0x040fe400078e3cffULL,
0x0000002a2b2a7212ULL, 0x000fe400078e3cffULL, 0x0000000240407810ULL, 0x000fe20007ffe0ffULL,
0x0000000429257824ULL, 0x044fe400078e0224ULL, 0x0000000429297824ULL, 0x000fe400078e022aULL,
0x0000001025257824ULL, 0x100fe400078e0228ULL, 0x0000001029297824ULL, 0x000fc800078e0228ULL,
0x000000002524783bULL, 0x000ea80000000200ULL, 0x000000002928783bULL, 0x000f220000000200ULL,
0x0000003000717306ULL, 0x002fe20000009400ULL, 0x00000018ffad7819ULL, 0x000fe20000011430ULL,
0x00010000305c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe20000011431ULL,
0x000100002c777824ULL, 0x048fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe20000011433ULL,
0x000100002d7a7824ULL, 0x040fe200078e00ffULL, 0x00000018ffa77819ULL, 0x000fe2000001145cULL,
0x0000003000a67306ULL, 0x000e620000005400ULL, 0x00000018ff947819ULL, 0x000fe20000011432ULL,
0x000001002c7c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x000001002e697824ULL, 0x040fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe2000001142cULL,
0x000001002d7f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x00000030005b7306ULL, 0x000762000000d400ULL, 0x00000018ff607819ULL, 0x000fe2000001142dULL,
0x000100002e727824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fc4000001147cULL,
0x00000018ff567819ULL, 0x000fe4000001142eULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x000000a700a87306ULL, 0x000fe20000209400ULL, 0x0000010030307824ULL, 0x008fe200078e00ffULL,
0x000000a67100720bULL, 0x002fe40003f9d000ULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0001000024c47824ULL, 0x004fe200078e00ffULL, 0x00000018ffaa7819ULL, 0x000fe20000011430ULL,
0x0001000031307824ULL, 0x000fe200078e00ffULL, 0x000000a700a97306ULL, 0x000e620000205400ULL,
0x00000018ff9d7819ULL, 0x000fc40000011424ULL, 0x00000018ff917819ULL, 0x000fe40000011425ULL,
0x00000018ffb07819ULL, 0x000fe20000011430ULL, 0x0001000032307824ULL, 0x000fe200078e00ffULL,
0x000000015b5b4812ULL, 0x020fe200078efcffULL, 0x0000003100a27306ULL, 0x000fe20000009400ULL,
0x00000018ffc47819ULL, 0x000fe400000114c4ULL, 0x00000018ffb87819ULL, 0x000fe20000011430ULL,
0x0001000033307824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fc40000011426ULL,
0x00000018ff837819ULL, 0x000fe20000011427ULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x000000a9a800720bULL, 0x002fe20003f5d000ULL, 0x0000010025a87824ULL, 0x000fe200078e00ffULL,
0x00000018ffbe7819ULL, 0x000fe20000011430ULL, 0x0001000026a97824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x000000b000b27306ULL, 0x000e620000205400ULL, 0x00000018ffa97819ULL, 0x000fc400000114a9ULL,
0x000000a800cb7245ULL, 0x000fe4000020d400ULL, 0x00000018ff4c7819ULL, 0x000fc6000001142fULL,
0x0000003100a37306ULL, 0x000eb00000005400ULL, 0x0000003200a07306ULL, 0x000fe20000009400ULL,
0x000000b2b100720bULL, 0x002fce0003fbd000ULL, 0x0000003200a17306ULL, 0x000e620000005400ULL,
0x000000a3a200720bULL, 0x004fe40003f3d000ULL, 0x000000a700a27245ULL, 0x000fe4000020d400ULL,
0x000000aa00a37245ULL, 0x000fe4000020d400ULL, 0x00000001a2a22812ULL, 0x000fe200078efcffULL,
0x000000b800b97306ULL, 0x000fe60000209400ULL, 0x0000005ba2a2723eULL, 0x000fca00000010ffULL,
0x000000b800ba7306ULL, 0x0004e20000205400ULL, 0x000000a1a000720bULL, 0x002fe40003f5d000ULL,
0x000000b000a17245ULL, 0x000fe4000020d400ULL, 0x000000ad00a07245ULL, 0x000fe4000020d400ULL,
0x00000001a1a15812ULL, 0x000fe200078efcffULL, 0x000000aa00ab7306ULL, 0x000fe20000209400ULL,
0x000000b800b87245ULL, 0x004fce000020d400ULL, 0x000000aa00ac7306ULL, 0x000e620000205400ULL,
0x000000bab900720bULL, 0x008fce0003fbd000ULL, 0x00000031005a7306ULL, 0x0004ec000000d400ULL,
0x00000001b8b85812ULL, 0x000fe400078efcffULL, 0x0000009f00b67306ULL, 0x000fe20000209400ULL,
0x0000010031317824ULL, 0x004fe200078e00ffULL, 0x000000acab00720bULL, 0x002fc80003f7d000ULL,
0x00000018ffb37819ULL, 0x000fe40000011431ULL, 0x0000009f00b77306ULL, 0x000e620000205400ULL,
0x000000015a5a1812ULL, 0x008fc800078efcffULL, 0x0000005aa15a723eULL, 0x000fe400000010ffULL,
0x00000001a3a33812ULL, 0x000fe200078efcffULL, 0x000000be00bf7306ULL, 0x000ff00000209400ULL,
0x000000be00c07306ULL, 0x0004e20000205400ULL, 0x000000b7b600720bULL, 0x002fce0003f9d000ULL,
0x000000ad00ae7306ULL, 0x000fe20000209400ULL, 0x000000be00be7245ULL, 0x004fce000020d400ULL,
0x000000ad00af7306ULL, 0x000e620000205400ULL, 0x000000c0bf00720bULL, 0x008fce0003fbd000ULL,
0x00000024008d7306ULL, 0x000fec0000009400ULL, 0x00000001bebe5812ULL, 0x000fe400078efcffULL,
0x0000002400907306ULL, 0x000ea20000005400ULL, 0x000000afae00720bULL, 0x002fce0003fdd000ULL,
0x0000002400527306ULL, 0x0003ec000000d400ULL, 0x00000001a0a06812ULL, 0x000fe400078efcffULL,
0x0000003200577306ULL, 0x000762000000d400ULL, 0x0000010024247824ULL, 0x002fe200078e00ffULL,
0x000000908d00720bULL, 0x004fc40003fbd000ULL, 0x000000c4008d7245ULL, 0x000fe4000020d400ULL,
0x00000018ffc77819ULL, 0x000fe20000011424ULL, 0x0001000025247824ULL, 0x000fe200078e00ffULL,
0x0000008400967306ULL, 0x000fe20000209400ULL, 0x0000010032327824ULL, 0x008fe200078e00ffULL,
0x0000009100907245ULL, 0x000fe4000020d400ULL, 0x00000018ffca7819ULL, 0x000fe40000011424ULL,
0x00000018ffbb7819ULL, 0x000fe20000011432ULL, 0x000001002f327824ULL, 0x000fe200078e00ffULL,
0x0000008400937306ULL, 0x0002a20000205400ULL, 0x0000000157572812ULL, 0x020fc400078efcffULL,
0x0000000152525812ULL, 0x000fe400078efcffULL, 0x000000bb00b97245ULL, 0x000fe4000020d400ULL,
0x000000423d247211ULL, 0x000fe200078fe0ffULL, 0x0000002c00957306ULL, 0x000fe20000009400ULL,
0x0000008400847245ULL, 0x002fe4000020d400ULL, 0x0000000224717810ULL, 0x040fe40007ffe0ffULL,
0x0000000724247812ULL, 0x000fc400078e78ccULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000002c009a7306ULL, 0x000e620000005400ULL, 0x000000939600720bULL, 0x004fe20003f5d000ULL,
0x00000010cc247824ULL, 0x000fe200078e0224ULL, 0x0000000771717812ULL, 0x000fe400078e78ccULL,
0x00000057b8b8723eULL, 0x000fe200000010ffULL, 0x0000001024247824ULL, 0x000fe200078e00ffULL,
0x000000a3a0a3723eULL, 0x000fe200000010ffULL, 0x000000b300b47306ULL, 0x000fe20000209400ULL,
0x00000010cc717824ULL, 0x000fe200078e0271ULL, 0x0000000442427810ULL, 0x000fc80007ffe0ffULL,
0x0000000184842812ULL, 0x000fe400078efcffULL, 0x000000b300b57306ULL, 0x000ea20000205400ULL,
0x0000009a9500720bULL, 0x002fe40003f3d000ULL, 0x0000009f009a7245ULL, 0x000fe2000020d400ULL,
0x00000100279f7824ULL, 0x000fc600078e00ffULL, 0x000000019a9a4812ULL, 0x000fe200078efcffULL,
0x0000009400997306ULL, 0x000fe20000209400ULL, 0x00000018ff9f7819ULL, 0x000fce000001149fULL,
0x00000094009c7306ULL, 0x0002e20000205400ULL, 0x000000b5b400720bULL, 0x004fce0003f7d000ULL,
0x00000033009e7306ULL, 0x000fe20000009400ULL, 0x0000009400947245ULL, 0x002fce000020d400ULL,
0x00000033009b7306ULL, 0x000e620000005400ULL, 0x0000009c9900720bULL, 0x008fe20003f9d000ULL,
0x0001000027997824ULL, 0x000fca00078e00ffULL, 0x00000018ff997819ULL, 0x000fe20000011499ULL,
0x00000025008b7306ULL, 0x000fec0000009400ULL, 0x0000000194944812ULL, 0x000fe400078efcffULL,
0x0000002500887306ULL, 0x000fe20000005400ULL, 0x0000009b9e00720bULL, 0x002fc40003fdd000ULL,
0x000000b3009b7245ULL, 0x000fc8000020d400ULL, 0x000000019b9b3812ULL, 0x000fe200078efcffULL,
0x00000025004d7306ULL, 0x000fe6000000d400ULL, 0x0000009b9a5b723eULL, 0x000fca00000010ffULL,
0x000000ca00a67306ULL, 0x000ff00000209400ULL, 0x000000ca00257306ULL, 0x0002b00000205400ULL,
0x000000bb00bc7306ULL, 0x000fe20000209400ULL, 0x000000ca00ca7245ULL, 0x002fce000020d400ULL,
0x000000bb00bd7306ULL, 0x000e620000205400ULL, 0x00000025a600720bULL, 0x004fce0003f5d000ULL,
0x0000003300537306ULL, 0x0004ec000000d400ULL, 0x00000001caca2812ULL, 0x000fe400078efcffULL,
0x000000c400c57306ULL, 0x000fe20000209400ULL, 0x0000010033337824ULL, 0x004fe200078e00ffULL,
0x000000bdbc00720bULL, 0x002fc80003f7d000ULL, 0x00000018ffc17819ULL, 0x000fe20000011433ULL,
0x000100002f337824ULL, 0x000fe200078e00ffULL, 0x000000c400c67306ULL, 0x000e620000205400ULL,
0x0000000153536812ULL, 0x008fe400078efcffULL, 0x000000c100bf7245ULL, 0x000fe4000020d400ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x00000001b9b93812ULL, 0x000fe200078efcffULL,
0x000000a800a77306ULL, 0x000fe20000209400ULL, 0x00000053bebe723eULL, 0x000fc400000010ffULL,
0x000000b994b9723eULL, 0x000fca00000010ffULL, 0x000000a800aa7306ULL, 0x000ea20000205400ULL,
0x000000c6c500720bULL, 0x002fce0003f9d000ULL, 0x0000009d00a57306ULL, 0x000fec0000209400ULL,
0x000000018d8d4812ULL, 0x000fe400078efcffULL, 0x0000009d00a47306ULL, 0x000e620000205400ULL,
0x000000aaa700720bULL, 0x004fe40003fbd000ULL, 0x000000888b00720bULL, 0x000fc40003f9d000ULL,
0x0000009d00887245ULL, 0x000fe4000020d400ULL, 0x000000528d52723eULL, 0x000fe200000010ffULL,
0x000000a9009e7306ULL, 0x000fec0000209400ULL, 0x00000001cbcb5812ULL, 0x000fe400078efcffULL,
0x000000a900957306ULL, 0x000ea20000205400ULL, 0x000000a4a500720bULL, 0x002fc40003fdd000ULL,
0x000000014d4d4812ULL, 0x000fc800078efcffULL, 0x0000004dcaca723eULL, 0x000fe200000010ffULL,
0x000000c100c27306ULL, 0x000fec0000209400ULL, 0x0000000188886812ULL, 0x000fe400078efcffULL,
0x000000c100c37306ULL, 0x000e620000205400ULL, 0x000000959e00720bULL, 0x004fce0003f5d000ULL,
0x0000008e00927306ULL, 0x000ff00000209400ULL, 0x0000008e008f7306ULL, 0x0004e20000205400ULL,
0x000000c3c200720bULL, 0x002fce0003f7d000ULL, 0x0000002700757306ULL, 0x000fe20000009400ULL,
0x0000008e008e7245ULL, 0x004fca000020d400ULL, 0x00000001bfbf3812ULL, 0x000fe400078efcffULL,
0x0000002700767306ULL, 0x000e620000005400ULL, 0x0000008f9200720bULL, 0x008fe40003fbd000ULL,
0x000000a900927245ULL, 0x000fe4000020d400ULL, 0x000000bf84bf723eULL, 0x000fe400000010ffULL,
0x0000000192922812ULL, 0x000fe200078efcffULL, 0x0000009100977306ULL, 0x000fec0000209400ULL,
0x000000018e8e5812ULL, 0x000fc400078efcffULL, 0x0000009100987306ULL, 0x000ea20000205400ULL,
0x000000767500720bULL, 0x002fe40003f5d000ULL, 0x0000007700767245ULL, 0x000fca000020d400ULL,
0x000000c700c87306ULL, 0x000ff00000209400ULL, 0x000000c700c97306ULL, 0x0002e20000205400ULL,
0x000000989700720bULL, 0x004fce0003fdd000ULL, 0x00000026007d7306ULL, 0x000fe20000009400ULL,
0x000000c700c77245ULL, 0x002fca000020d400ULL, 0x0000000190906812ULL, 0x000fe400078efcffULL,
0x00000026007e7306ULL, 0x000e620000005400ULL, 0x000000c9c800720bULL, 0x008fe40003f7d000ULL,
0x000000cb90cb723eULL, 0x000fca00000010ffULL, 0x00000026004b7306ULL, 0x0004ec000000d400ULL,
0x00000001c7c73812ULL, 0x000fe400078efcffULL, 0x00000027004a7306ULL, 0x000f62000000d400ULL,
0x0000010026267824ULL, 0x004fe200078e00ffULL, 0x0000007e7d00720bULL, 0x002fc40003f7d000ULL,
0x000000c78853723eULL, 0x000fe400000010ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000007700877306ULL, 0x000fe20000209400ULL, 0x00000018ff7d7819ULL, 0x010fcc000001142aULL,
0x000000014b4b3812ULL, 0x008fe200078efcffULL, 0x00000077008a7306ULL, 0x0002a20000205400ULL,
0x000000014a4a2812ULL, 0x020fe400078efcffULL, 0x0000004b9292723eULL, 0x000fca00000010ffULL,
0x0000009900937306ULL, 0x000fe20000209400ULL, 0x0000007c00777245ULL, 0x002fce000020d400ULL,
0x00000099009c7306ULL, 0x0002e20000205400ULL, 0x0000008a8700720bULL, 0x004fce0003f5d000ULL,
0x0000002600277306ULL, 0x000fe20000209400ULL, 0x0000009900997245ULL, 0x002fca000020d400ULL,
0x0000000176762812ULL, 0x000fe400078efcffULL, 0x0000002600967306ULL, 0x000e620000205400ULL,
0x0000009c9300720bULL, 0x008fe40003fdd000ULL, 0x0000002600937245ULL, 0x000fca000020d400ULL,
0x0000006200637306ULL, 0x000fec0000209400ULL, 0x0000000199996812ULL, 0x000fe400078efcffULL,
0x0000006200667306ULL, 0x0004e20000205400ULL, 0x000000962700720bULL, 0x002fe40003f9d000ULL,
0x0000004a994a723eULL, 0x000fca00000010ffULL, 0x0000008300897306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x004fca000020d400ULL, 0x0000000193934812ULL, 0x000fe400078efcffULL,
0x00000083008c7306ULL, 0x000e620000205400ULL, 0x000000666300720bULL, 0x008fe40003f5d000ULL,
0x000000938e93723eULL, 0x000fca00000010ffULL, 0x0000009f00257306ULL, 0x000fec0000209400ULL,
0x0000000162622812ULL, 0x000fe400078efcffULL, 0x0000009f00987306ULL, 0x0004e20000205400ULL,
0x0000008c8900720bULL, 0x002fce0003fdd000ULL, 0x0000002c00457306ULL, 0x000322000000d400ULL,
0x0000009f009f7245ULL, 0x004fce000020d400ULL, 0x0000007a007b7306ULL, 0x000fe20000209400ULL,
0x000000982500720bULL, 0x008fe40003f7d000ULL, 0x000000002424783bULL, 0x000ea20000000200ULL,
0x00000018ff2c7819ULL, 0x002fc80000011428ULL, 0x0000007a00807306ULL, 0x000e620000205400ULL,
0x0000000145451812ULL, 0x010fc800078efcffULL, 0x000000457676723eULL, 0x000fe400000010ffULL,
0x000000019f9f3812ULL, 0x000fe200078efcffULL, 0x0000002d006f7306ULL, 0x000ff00000009400ULL,
0x0000002d00707306ULL, 0x000ee20000005400ULL, 0x000000807b00720bULL, 0x002fe20003f3d000ULL,
0x00010000297b7824ULL, 0x000fc400078e00ffULL, 0x000001002a807824ULL, 0x000fc600078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000002f005e7306ULL, 0x000fe20000009400ULL,
0x00000018ff807819ULL, 0x000fce0000011480ULL, 0x0000002f005f7306ULL, 0x000e620000005400ULL,
0x000000706f00720bULL, 0x008fe40003f9d000ULL, 0x0000008300707245ULL, 0x000fe2000020d400ULL,
0x0000005a241c723cULL, 0x044fe2000004181cULL, 0x00000018ff6f7819ULL, 0x000fe4000001142bULL,
0x0000000170706812ULL, 0x000fe200078efcffULL, 0x0000006000647306ULL, 0x000fe60000209400ULL,
0x0000009f704b723eULL, 0x000fe200000010ffULL, 0x000000a22414723cULL, 0x000fe80000041814ULL,
0x0000006000617306ULL, 0x0004e20000205400ULL, 0x0000005f5e00720bULL, 0x002fc40003fdd000ULL,
0x0000007a005f7245ULL, 0x000fe2000020d400ULL, 0x000000b82420723cULL, 0x000fe60000041820ULL,
0x000000015f5f1812ULL, 0x000fe200078efcffULL, 0x0000007c00867306ULL, 0x000fe20000209400ULL,
0x0000006000607245ULL, 0x004fc6000020d400ULL, 0x000000be2418723cULL, 0x000fe80000041818ULL,
0x0000007c00857306ULL, 0x0002a20000205400ULL, 0x000000616400720bULL, 0x008fc60003f5d000ULL,
0x000000522410723cULL, 0x000fe80000041810ULL, 0x0000005600687306ULL, 0x000fe20000209400ULL,
0x000100002a7c7824ULL, 0x002fc600078e00ffULL, 0x000000ca240c723cULL, 0x040fe4000004180cULL,
0x0000000160602812ULL, 0x000fe400078efcffULL, 0x0000005600657306ULL, 0x0002e20000205400ULL,
0x000000858600720bULL, 0x004fe20003f7d000ULL, 0x0001000028857824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x000000922408723cULL, 0x000fe60000041808ULL,
0x00000018ff857819ULL, 0x000fe20000011485ULL, 0x0000006900737306ULL, 0x000fe20000209400ULL,
0x0000005600567245ULL, 0x002fc6000020d400ULL, 0x0000004a2404723cULL, 0x000fe40000041804ULL,
0x0000000177773812ULL, 0x000fe400078efcffULL, 0x0000006900747306ULL, 0x000e620000205400ULL,
0x000000656800720bULL, 0x008fe40003f3d000ULL, 0x0000007c00257245ULL, 0x000fe4000020d400ULL,
0x000000776277723eULL, 0x000fc600000010ffULL, 0x0000007f00817306ULL, 0x000fec0000209400ULL,
0x0000000156561812ULL, 0x000fe400078efcffULL, 0x0000007f00827306ULL, 0x0004e20000205400ULL,
0x000000747300720bULL, 0x002fe40003f5d000ULL, 0x0000006900737245ULL, 0x000fca000020d400ULL,
0x0000002e006e7306ULL, 0x000fe20000009400ULL, 0x0000007f007f7245ULL, 0x004fca000020d400ULL,
0x0000000173732812ULL, 0x000fe400078efcffULL, 0x0000002e006d7306ULL, 0x000e620000005400ULL,
0x000000828100720bULL, 0x008fe20003f7d000ULL, 0x000100002b817824ULL, 0x040fe200078e00ffULL,
0x000000735673723eULL, 0x000fe200000010ffULL, 0x000001002b827824ULL, 0x000fc600078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x00000032005c7306ULL, 0x000fe20000209400ULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x0000008100267245ULL, 0x000fc6000020d400ULL,
0x000000017f7f3812ULL, 0x000fe400078efcffULL, 0x00000032005d7306ULL, 0x000ea20000205400ULL,
0x0000006d6e00720bULL, 0x002fe40003fbd000ULL, 0x0000007f6045723eULL, 0x000fca00000010ffULL,
0x0000002900557306ULL, 0x000ff00000009400ULL, 0x0000002900547306ULL, 0x000e620000005400ULL,
0x0000005d5c00720bULL, 0x004fce0003f3d000ULL, 0x0000007200787306ULL, 0x000ff00000209400ULL,
0x0000007200797306ULL, 0x0004e20000205400ULL, 0x000000545500720bULL, 0x002fe40003f5d000ULL,
0x0000003200557245ULL, 0x000fc4000020d400ULL, 0x0000003300547245ULL, 0x000fe4000020d400ULL,
0x0000000155551812ULL, 0x000fe200078efcffULL, 0x0000002d00447306ULL, 0x000322000000d400ULL,
0x0000007200727245ULL, 0x004fe4000020d400ULL, 0x0000008500327245ULL, 0x000fca000020d400ULL,
0x0000002e00437306ULL, 0x000ea2000000d400ULL, 0x000000797800720bULL, 0x008fe40003f7d000ULL,
0x00000018ff2d7819ULL, 0x002fca0000011429ULL, 0x0000004c00677306ULL, 0x000fe20000209400ULL,
0x0000000144444812ULL, 0x010fc800078efcffULL, 0x000000445f44723eULL, 0x000fe400000010ffULL,
0x0000000172723812ULL, 0x000fe200078efcffULL, 0x0000004c006a7306ULL, 0x0002e20000205400ULL,
0x0000000143435812ULL, 0x004fc800078efcffULL, 0x000000437272723eULL, 0x000fc600000010ffULL,
0x00000033006b7306ULL, 0x000fe20000209400ULL, 0x0000004c004c7245ULL, 0x002fce000020d400ULL,
0x00000033006c7306ULL, 0x000e620000205400ULL, 0x0000006a6700720bULL, 0x008fce0003f9d000ULL,
0x00000085005e7306ULL, 0x000fec0000209400ULL, 0x000000014c4c4812ULL, 0x000fe400078efcffULL,
0x0000008500637306ULL, 0x000ea20000205400ULL, 0x0000006c6b00720bULL, 0x002fe40003fbd000ULL,
0x000000554c55723eULL, 0x000fca00000010ffULL, 0x0000002800597306ULL, 0x000fec0000009400ULL,
0x0000000154545812ULL, 0x000fe400078efcffULL, 0x0000002800587306ULL, 0x000e620000005400ULL,
0x000000635e00720bULL, 0x004fce0003f3d000ULL, 0x0000002800497306ULL, 0x0004ec000000d400ULL,
0x0000000132321812ULL, 0x000fe400078efcffULL, 0x0000002a004f7306ULL, 0x000fe20000009400ULL,
0x0000010028287824ULL, 0x004fe200078e00ffULL, 0x000000585900720bULL, 0x002fc80003f7d000ULL,
0x00000018ff667819ULL, 0x000fe20000011428ULL, 0x0000001071287824ULL, 0x000fe200078e00ffULL,
0x0000002a004e7306ULL, 0x000e640000005400ULL, 0x0000006600337245ULL, 0x000fca000020d400ULL,
0x0000000149493812ULL, 0x008fe200078efcffULL, 0x00000066007a7306ULL, 0x000fe60000209400ULL,
0x000000493232723eULL, 0x000fca00000010ffULL, 0x0000006600617306ULL, 0x000ea20000205400ULL,
0x0000004e4f00720bULL, 0x002fce0003fbd000ULL, 0x0000002c00307306ULL, 0x000ff00000209400ULL,
0x0000002c00317306ULL, 0x0002e20000205400ULL, 0x000000617a00720bULL, 0x004fce0003f9d000ULL,
0x0000002900487306ULL, 0x000522000000d400ULL, 0x0000002c002c7245ULL, 0x002fca000020d400ULL,
0x0000000133334812ULL, 0x000fe400078efcffULL, 0x0000002f00417306ULL, 0x000e62000000d400ULL,
0x0000010029297824ULL, 0x004fe200078e00ffULL, 0x000000313000720bULL, 0x008fc80003f3d000ULL,
0x00000018ff5a7819ULL, 0x000fe40000011429ULL, 0x0000002b00517306ULL, 0x000fe20000009400ULL,
0x0000000148482812ULL, 0x010fcc00078efcffULL, 0x000000012c2c1812ULL, 0x000fe200078efcffULL,
0x0000002b00507306ULL, 0x000ea20000005400ULL, 0x0000000141416812ULL, 0x002fe400078efcffULL,
0x000000332c33723eULL, 0x000fe400000010ffULL, 0x0000006f002c7245ULL, 0x000fe4000020d400ULL,
0x000000415454723eULL, 0x000fe200000010ffULL, 0x0000002d002e7306ULL, 0x000ff00000209400ULL,
0x0000002d002f7306ULL, 0x0002e20000205400ULL, 0x000000505100720bULL, 0x004fce0003fdd000ULL,
0x0000005a00587306ULL, 0x000fe20000209400ULL, 0x0000002d002d7245ULL, 0x002fce000020d400ULL,
0x0000005a00597306ULL, 0x0002a20000205400ULL, 0x0000002f2e00720bULL, 0x008fce0003f9d000ULL,
0x0000007b00647306ULL, 0x000fe20000209400ULL, 0x0000005a005a7245ULL, 0x002fca000020d400ULL,
0x000000012d2d4812ULL, 0x000fe400078efcffULL, 0x0000007b00577306ULL, 0x0002e20000205400ULL,
0x000000595800720bULL, 0x004fce0003f3d000ULL, 0x0000007c005b7306ULL, 0x000fe20000209400ULL,
0x0000007b007b7245ULL, 0x002fca000020d400ULL, 0x000000015a5a1812ULL, 0x000fe400078efcffULL,
0x0000007c004e7306ULL, 0x000e620000205400ULL, 0x000000576400720bULL, 0x008fe40003f7d000ULL,
0x0000005a2d49723eULL, 0x000fca00000010ffULL, 0x0000006f006d7306ULL, 0x000fec0000209400ULL,
0x000000017b7b3812ULL, 0x000fe400078efcffULL, 0x0000006f006e7306ULL, 0x000ea20000205400ULL,
0x0000004e5b00720bULL, 0x002fe40003f5d000ULL, 0x000000487b48723eULL, 0x000fca00000010ffULL,
0x0000002a00467306ULL, 0x000e6c000000d400ULL, 0x0000000125252812ULL, 0x000fe400078efcffULL,
0x0000002b00477306ULL, 0x000722000000d400ULL, 0x0000006e6d00720bULL, 0x004fce0003f3d000ULL,
0x0000007d007e7306ULL, 0x000fe20000209400ULL, 0x000000002828783bULL, 0x008ea20000000200ULL,
0x0000000146465812ULL, 0x002fc800078efcffULL, 0x000000012c2c1812ULL, 0x000fe400078efcffULL,
0x0000007d00757306ULL, 0x0002e20000205400ULL, 0x000000044000780cULL, 0x000fe40003f25270ULL,
0x0000000147476812ULL, 0x010fca00078efcffULL, 0x00000080004d7306ULL, 0x000fe20000209400ULL,
0x0000007d007d7245ULL, 0x002fce000020d400ULL, 0x0000008000507306ULL, 0x0003220000205400ULL,
0x000000757e00720bULL, 0x008fce0003f7d000ULL, 0x0000008100307306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fca000020d400ULL, 0x000000017d7d3812ULL, 0x000fe400078efcffULL,
0x0000008100277306ULL, 0x000e620000205400ULL, 0x000000504d00720bULL, 0x010fe20003f9d000ULL,
0x000000762814723cULL, 0x044fec0000041814ULL, 0x0000008200247306ULL, 0x000fe40000209400ULL,
0x00000044281c723cULL, 0x000fe8000004181cULL, 0x0000000180804812ULL, 0x000fc400078efcffULL,
0x00000082002f7306ULL, 0x000ea20000205400ULL, 0x000000273000720bULL, 0x002fe20003f5d000ULL,
0x000000722820723cULL, 0x000fe20000041820ULL, 0x0000008200277245ULL, 0x000fce000020d400ULL,
0x000000542818723cULL, 0x040fe80000041818ULL, 0x0000000126262812ULL, 0x000fe400078efcffULL,
0x0000002f2400720bULL, 0x004fe40003fbd000ULL, 0x000000462524723eULL, 0x000fe200000010ffULL,
0x000000322810723cULL, 0x000fe20000041810ULL, 0x000000807d25723eULL, 0x000fc400000010ffULL,
0x000000472626723eULL, 0x000fca00000010ffULL, 0x00000048280c723cULL, 0x000fe4000004180cULL,
0x0000000127275812ULL, 0x000fc800078efcffULL, 0x000000272c27723eULL, 0x000fe400000010ffULL,
0x000000242808723cULL, 0x040ff00000041808ULL, 0x000000262804723cULL, 0x000fe20000041804ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe12000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e0039ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd5f000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00f614003a257984ULL, 0x000e620000000800ULL,
0x0000ffff38007812ULL, 0x000fe200078ec0ffULL, 0x0000001d3c1d7220ULL, 0x040fe20000410000ULL,
0x0000001e3c1e7220ULL, 0x040fe20000410000ULL, 0x000000143c147220ULL, 0x000fe20000410000ULL,
0x00008880002f7816ULL, 0x000fe200000000ffULL, 0x000000153c157220ULL, 0x040fe20000410000ULL,
0x0000001f3c1f7220ULL, 0x040fe20000410000ULL, 0x0000001a3c277220ULL, 0x040fe20000410000ULL,
0x0000001b3c287220ULL, 0x040fe20000410000ULL, 0x000000163c247220ULL, 0x040fe20000410000ULL,
0x000000173c267220ULL, 0x040fe20000410000ULL, 0x000000203c207220ULL, 0x040fe20000410000ULL,
0x000000213c217220ULL, 0x040fe20000410000ULL, 0x000000223c227220ULL, 0x040fe20000410000ULL,
0x0000000c3c1a7220ULL, 0x040fe20000410000ULL, 0x0000000d3c1b7220ULL, 0x040fe20000410000ULL,
0x800000002f007824ULL, 0x000fe200078e00ffULL, 0x000000233c237220ULL, 0x040fe20000410000ULL,
0x000000183c187220ULL, 0x040fe20000410000ULL, 0x000000193c197220ULL, 0x040fe20000410000ULL,
0x000000103c167220ULL, 0x040fe20000410000ULL, 0x000000113c177220ULL, 0x040fe20000410000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e001dULL, 0x0000001c3c1c7220ULL, 0x040fe20000410000ULL,
0x000000123c297220ULL, 0x040fe20000410000ULL, 0x000000133c2a7220ULL, 0x040fe20000410000ULL,
0x0000000e3c2b7220ULL, 0x040fe20000410000ULL, 0x0000000f3c2c7220ULL, 0x040fe20000410000ULL,
0x000000083c087220ULL, 0x040fe20000410000ULL, 0x000000093c097220ULL, 0x040fe20000410000ULL,
0x0000000a3c2d7220ULL, 0x040fe20000410000ULL, 0x0000000b3c2e7220ULL, 0x040fe20000410000ULL,
0x000000043c047220ULL, 0x040fe20000410000ULL, 0x000000053c057220ULL, 0x040fe20000410000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e001eULL, 0x000000063c067220ULL, 0x040fe20000410000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0014ULL, 0x000000073c077220ULL, 0x000fe20000410000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0015ULL, 0x8000000025ff7812ULL, 0x002fe20007804800ULL,
0x000000ffff1e7224ULL, 0x000fc400078e001fULL, 0x000000ffff0e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0021ULL, 0x000000ffff147224ULL, 0x000fe400078e001aULL,
0x000000ffff157224ULL, 0x000fe400078e001bULL, 0x000000ffff1f7224ULL, 0x000fe400078e0022ULL,
0x000000ffff107224ULL, 0x000fc400078e0018ULL, 0x000000ffff117224ULL, 0x000fe400078e0019ULL,
0x000000ffff127224ULL, 0x000fe400078e0016ULL, 0x000000ffff137224ULL, 0x000fe400078e0017ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0024ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0026ULL,
0x000000ffff207224ULL, 0x000fc400078e0023ULL, 0x000000ffff217224ULL, 0x000fe400078e0027ULL,
0x000000ffff227224ULL, 0x000fe400078e0028ULL, 0x000000ffff0c7224ULL, 0x000fe400078e001cULL,
0x000000ffff167224ULL, 0x000fe400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e0009ULL,
0x000000ffff187224ULL, 0x000fc400078e0004ULL, 0x000000ffff197224ULL, 0x000fe400078e0005ULL,
0x000000ffff237224ULL, 0x000fe400078e0029ULL, 0x000000ffff247224ULL, 0x000fe400078e002aULL,
0x000000ffff257224ULL, 0x000fe400078e002bULL, 0x000000ffff267224ULL, 0x000fe400078e002cULL,
0x000000ffff277224ULL, 0x000fc400078e002dULL, 0x000000ffff287224ULL, 0x000fe200078e002eULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe400078e0006ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0007ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000002f2f7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x00f614003a047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fc4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000043d1c7824ULL, 0x000fe200078e00ffULL,
0x0000003b3400720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff01c057812ULL, 0x000fca00078ec0ffULL, 0x0000008002007824ULL, 0x000fca00078e0205ULL,
0x00f4000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000023d087824ULL, 0x000fe400078e00ffULL, 0x00000001033e7824ULL, 0x000fc600078e0a3eULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x00000001092b7812ULL, 0x040fe400078efcffULL,
0x00000008092d7812ULL, 0x000fe400078efcffULL, 0x0000003e2b00720cULL, 0x080fe40003f26070ULL,
0x00000010092b7812ULL, 0x000fe400078efcffULL, 0x0000003e2d00720cULL, 0x080fe40003f06070ULL,
0x0000003e2b00720cULL, 0x000fc40003fc6070ULL, 0x00000011092d7812ULL, 0x040fe400078efcffULL,
0x00000018092b7812ULL, 0x040fe400078efcffULL, 0x0000003e0900720cULL, 0x080fe40003f46070ULL,
0x0000003e2d00720cULL, 0x080fe40003fa6070ULL, 0x0000003e2b00720cULL, 0x000fe40003f66070ULL,
0x00000009092f7812ULL, 0x000fc400078efcffULL, 0x00000019092d7812ULL, 0x040fe400078efcffULL,
0x00000020092b7812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x0000003e2f00720cULL, 0x080fe40003f86070ULL,
0x0000003e2d00720cULL, 0x080fe40003f46070ULL, 0x0000003e2b00720cULL, 0x000fe40003f26070ULL,
0x00000021092d7812ULL, 0x040fe400078efcffULL, 0x00000028092b7812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x0000003e2d00720cULL, 0x080fe40003f06070ULL, 0x0000003e2b00720cULL, 0x000fe40003f86070ULL,
0x00000029092d7812ULL, 0x000fc400078efcffULL, 0x00000030092b7812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x0000003e2d00720cULL, 0x000fc40003fc6070ULL, 0x0000003e2b00720cULL, 0x000fe40003fa6070ULL,
0x00000031092d7812ULL, 0x040fe400078efcffULL, 0x00000038092b7812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x0000003e2d00720cULL, 0x080fe40003f66070ULL,
0x0000003e2b00720cULL, 0x000fc40003f46070ULL, 0x0000003e0900720cULL, 0x000fe40003f26070ULL,
0xff7fffff24247808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff25257808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff26267808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff27277808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff28287808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff29297808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000b04097209ULL, 0x004fe20007810000ULL,
0x0000001fff317424ULL, 0x000fe200078e00ffULL, 0x0000001a05047209ULL, 0x000fe20007810000ULL,
0xffffffffff327424ULL, 0x000fe200078e00ffULL, 0x0000000a09097209ULL, 0x000fe40007810000ULL,
0x0000001b04047209ULL, 0x000fc40007810000ULL, 0x0000000c09087209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x0000000d08097209ULL, 0x000fe40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x0000000e09087209ULL, 0x000fe40007810000ULL,
0x0000001f04057209ULL, 0x000fc40007810000ULL, 0x0000000f08097209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x0000001009087209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x0000001108097209ULL, 0x000fe40007810000ULL,
0x0000002205047209ULL, 0x000fc40007810000ULL, 0x0000001209087209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fe40007810000ULL, 0x0000001308097209ULL, 0x000fe40007810000ULL,
0x0000002405047209ULL, 0x000fe40007810000ULL, 0x0000001409087209ULL, 0x000fe40007810000ULL,
0x0000002504057209ULL, 0x000fc40007810000ULL, 0x0000001508097209ULL, 0x000fe40007810000ULL,
0x0000002605047209ULL, 0x000fe40007810000ULL, 0x0000001609087209ULL, 0x000fe40007810000ULL,
0x0000002704057209ULL, 0x000fe40007810000ULL, 0x0000001708097209ULL, 0x000fe40007810000ULL,
0x0000002805047209ULL, 0x000fc40007810000ULL, 0x0000001809087209ULL, 0x000fe40007810000ULL,
0x0000002904057209ULL, 0x000fe40007810000ULL, 0x00000019082d7209ULL, 0x000fe40007810000ULL,
0x0000002a052f7209ULL, 0x000fe20007810000ULL, 0x00000ea27f007947ULL, 0x000fea000b800000ULL,
0x0c401f002d047f89ULL, 0x0004e400000e0000ULL, 0x000000042d2d7209ULL, 0x00cfe20007810000ULL,
0x00000ed27f007947ULL, 0x000fea000b800000ULL, 0x0c401f002f047f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006057f89ULL, 0x000ee800000e0000ULL, 0x0c401f00072c7f89ULL, 0x000f2200000e0000ULL,
0x000000042f087209ULL, 0x004fc60007810000ULL, 0x0c201f002d047f89ULL, 0x000ea200000e0000ULL,
0x0000000506097209ULL, 0x008fc60007810000ULL, 0x0c201f0008057f89ULL, 0x000ee200000e0000ULL,
0x0000002c072c7209ULL, 0x010fc60007810000ULL, 0x0c201f00092e7f89ULL, 0x002e6800000e0000ULL,
0x0c201f002c2b7f89ULL, 0x00092200000e0000ULL, 0x000000042d047209ULL, 0x004fe40007810000ULL,
0x0000000508057209ULL, 0x008fe40007810000ULL, 0x0000002e09067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fc40000000000ULL,
0x00000004ff2e7e24ULL, 0x002fe2000f8e00ffULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x3f8000002e2e783eULL, 0x000fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL, 0x000000ffff2f7224ULL, 0x000fe200078e002eULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010819ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2a197823ULL, 0x000fe20000010819ULL,
0x0000000000057886ULL, 0x000fc400038e0100ULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x000000080908723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000ff00000000800ULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000000c0d0a723eULL, 0x008fce00000010ffULL,
0x0000001d000b7308ULL, 0x0007f00000000800ULL, 0x0000001e001e7308ULL, 0x000f620000000800ULL,
0x0000001a1b09723eULL, 0x002fe200000010ffULL, 0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b1e0b723eULL, 0x020fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x0000002e0830723cULL, 0x000fee00000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ee20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x008fce00000010ffULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ee20000000800ULL,
0x0000001f200d723eULL, 0x002fce00000010ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000021220f723eULL, 0x008fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000002e0c30723cULL, 0x000fee0000041830ULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002400247308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fe400000010ffULL, 0xfffffffc3d147812ULL, 0x000fc800078ec0ffULL,
0x000000141d1d7219ULL, 0x000fe200000006ffULL, 0x0000002500257308ULL, 0x000fe60000000800ULL,
0x000000001d1e73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0473c4ULL, 0x000f680000004000ULL,
0x0000002600267308ULL, 0x000f220000000800ULL, 0x000000232411723eULL, 0x002fce00000010ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000252613723eULL, 0x010fce00000010ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000051dff7c12ULL, 0x008fe2000f80401eULL,
0x0000002e1030723cULL, 0x000fec0000041830ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000000700077308ULL, 0x000ee20000000800ULL, 0x000000161714723eULL, 0x002fce00000010ffULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x000000180716723eULL, 0x008fe400000010ffULL, 0x0000002c2b077209ULL, 0x004fca0007810000ULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x00000019001a7308ULL, 0x000ea20000000800ULL,
0x000000272815723eULL, 0x002fe400000010ffULL, 0x000000291a17723eULL, 0x004fce00000010ffULL,
0x0000002e1420723cULL, 0x000fe20000041830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x000009e204008947ULL, 0x020fde000b800000ULL, 0x001c1fff20187589ULL, 0x0002a400000e0000ULL,
0x000000001d1a73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x000000051dff7c12ULL, 0x008fda000f80401aULL,
0x00000a0204008947ULL, 0x010fea000b800000ULL, 0x001c1fff22197589ULL, 0x00072800000e0000ULL,
0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL, 0x001c1fff001b7589ULL, 0x0006a400000e0000ULL,
0x00000002ff1d7819ULL, 0x00afe4000001163dULL, 0x0000000c1c337812ULL, 0x000fc400078ec0ffULL,
0x000000071d1e7812ULL, 0x040fe200078ec0ffULL, 0x000000081d237824ULL, 0x040fe200078e00ffULL,
0x0000001dff217212ULL, 0x000fe200078e33ffULL, 0x000000081d1f7824ULL, 0x000fe200078e00ffULL,
0x000000033dff7812ULL, 0x000fe2000780c0ffULL, 0x000000081d2e7824ULL, 0x040fe200078e00ffULL,
0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823207812ULL, 0x100fe400078ee21eULL,
0x000000011f227812ULL, 0x100fe200078ef61eULL, 0x000000081d487824ULL, 0x000fe200078e00ffULL,
0x000000021f247812ULL, 0x100fe200078ef61eULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0x000000031f267812ULL, 0x000fc400078ef61eULL, 0x000000041f287812ULL, 0x140fe400078ef61eULL,
0x000000051f2a7812ULL, 0x140fe400078ef61eULL, 0x000000061f2c7812ULL, 0x000fe200078ef61eULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe400078ee221ULL,
0x0000001dff217212ULL, 0x000fe400078e33ffULL, 0x000000071d1e7812ULL, 0x000fc400078ec0ffULL,
0x00009000021d7811ULL, 0x000fe400078e58ffULL, 0xfffffff823307812ULL, 0x100fe400078ee21eULL,
0x000000011f327812ULL, 0x140fe200078ef61eULL, 0x00000010201c7824ULL, 0x000fe200078e021dULL,
0xfffffff848487812ULL, 0x000fe200078ee221ULL, 0x0000001024207824ULL, 0x100fe200078e021dULL,
0x000000021f3e7812ULL, 0x140fe200078ef61eULL, 0x0000001028247824ULL, 0x100fe200078e021dULL,
0x000000031f407812ULL, 0x140fe200078ef61eULL, 0x000000102c287824ULL, 0x100fe200078e021dULL,
0x000000041f427812ULL, 0x140fe200078ef61eULL, 0x00000010322c7824ULL, 0x100fe200078e021dULL,
0x000000051f447812ULL, 0x140fe200078ef61eULL, 0x000000103e2d7824ULL, 0x100fe200078e021dULL,
0x000000061f467812ULL, 0x000fe200078ef61eULL, 0x00000010221e7824ULL, 0x000fc400078e021dULL,
0x0000001026227824ULL, 0x100fe400078e021dULL, 0x000000102a267824ULL, 0x100fe400078e021dULL,
0x00000001331f7824ULL, 0x000fe400078e021cULL, 0x000000102e2a7824ULL, 0x100fe400078e021dULL,
0x00000010301c7824ULL, 0x100fe200078e021dULL, 0x000000081f007388ULL, 0x0003e20000000800ULL,
0x00000010402e7824ULL, 0x000fc400078e021dULL, 0x00000010422f7824ULL, 0x100fe400078e021dULL,
0x0000001044307824ULL, 0x100fe400078e021dULL, 0x0000001046317824ULL, 0x100fe400078e021dULL,
0x0000001048327824ULL, 0x000fe400078e021dULL, 0x00000001331d7824ULL, 0x040fe400078e021eULL,
0x0000000133217824ULL, 0x000fc400078e0220ULL, 0x0000000133237824ULL, 0x040fe200078e0222ULL,
0x0000000a1d007388ULL, 0x0007e20000000800ULL, 0x0000000133257824ULL, 0x040fe400078e0224ULL,
0x0000000133277824ULL, 0x040fe200078e0226ULL, 0x0000000c21007388ULL, 0x0007e20000000800ULL,
0x0000000133297824ULL, 0x040fe400078e0228ULL, 0x00000001332b7824ULL, 0x040fe200078e022aULL,
0x0000000e23007388ULL, 0x0007e20000000800ULL, 0x00000001331c7824ULL, 0x000fc400078e021cULL,
0x00000001332c7824ULL, 0x040fe200078e022cULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x00000001331e7824ULL, 0x040fe400078e022dULL, 0x00000001332e7824ULL, 0x040fe200078e022eULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x0000000133087824ULL, 0x042fe400078e022fULL,
0x0000000133307824ULL, 0x040fe200078e0230ULL, 0x0000001429007388ULL, 0x0007e20000000800ULL,
0x0000000133207824ULL, 0x000fc400078e0231ULL, 0x0000000133327824ULL, 0x000fe200078e0232ULL,
0x000000162b007388ULL, 0x0007e80000000800ULL, 0x000000091c007388ULL, 0x0007e80000000800ULL,
0x0000000b2c007388ULL, 0x0007e80000000800ULL, 0x0000000d1e007388ULL, 0x0007e80000000800ULL,
0x0000000f2e007388ULL, 0x0007e80000000800ULL, 0x0000001108007388ULL, 0x0007e80000000800ULL,
0x0000001330007388ULL, 0x0007e80000000800ULL, 0x0000001520007388ULL, 0x0007e80000000800ULL,
0x0000001732007388ULL, 0x0007e80000000800ULL, 0x00f0000400008388ULL, 0x0007e80000000c00ULL,
0x00f2001800008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030034347a10ULL, 0x000fe20007ffe0ffULL, 0x00f608003aff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff38ff7812ULL, 0x000fc4000780c0ffULL, 0x000000353400720cULL, 0x000fe40003f26070ULL,
0x00000001ff387807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffbae000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e005aULL, 0x00015450002a7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x0000069000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2d7224ULL, 0x004fe200078e002eULL,
0xffff977000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x002fe200078e005cULL,
0x000154c0002a7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x0000062000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff2b7224ULL, 0x004fe200078e002eULL, 0xffff972000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x000fe200078e002dULL, 0x0001552000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x000fc400078e00ffULL, 0x0000058000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002bULL, 0xfffff11000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x000fe200078e002fULL, 0x0001558000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000052000007944ULL, 0x000fea0003c00000ULL,
0x0000002b2f307209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0006ULL,
0x000155d000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x002fc400078e00ffULL,
0x000004d000007944ULL, 0x000fea0003c00000ULL, 0x0000002b06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0007ULL, 0x0001562000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000048000007944ULL, 0x000fea0003c00000ULL,
0x0000002b072c7209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e002dULL,
0x0001567000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x0000002b2d047209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0030ULL, 0x000156c000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x002fc400078e00ffULL, 0x000003e000007944ULL, 0x000fea0003c00000ULL,
0x0000002b30057209ULL, 0x004fe20007810000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0006ULL,
0x0001571000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000002b06067209ULL, 0x004fe20007810000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e002cULL, 0x0001576000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x002fc400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0xffffefd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2f7224ULL, 0x000fe200078e0020ULL,
0x000157d0002a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff307224ULL, 0x000fc400078e00ffULL,
0x00001c1fff317424ULL, 0x000fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fe400078e001dULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e002eULL,
0xfffff5b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2f7224ULL, 0x002fe200078e0022ULL,
0x00015850002a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff307224ULL, 0x000fe400078e00ffULL,
0x00001c1fff317424ULL, 0x000fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fe400078e001dULL,
0x0000029000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff307224ULL, 0x002fe200078e00ffULL,
0x000158b0002a7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff317424ULL, 0x000fc400078e00ffULL,
0x000000ffff327224ULL, 0x000fe400078e001dULL, 0x000000ffff197224ULL, 0x004fe400078e002eULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff327224ULL, 0x002fe200078e001dULL,
0x00015910002a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff307224ULL, 0x000fe400078e00ffULL,
0x00001c1fff317424ULL, 0x000fe400078e00ffULL, 0x000000ffff1a7224ULL, 0x004fe400078e002eULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e002eULL,
0xfffff4f000007947ULL, 0x000fea000383ffffULL, 0x018000003d037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000003d00038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff087807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000308ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff3dff7812ULL, 0x040fe4000780c0ffULL,
0x800000003d077812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000308ff7212ULL, 0x000fda000780c0ffULL, 0x0080000007030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0007ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003d00037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffea56006007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003200007348ULL, 0x000fe80003800000ULL,
0x0c00002e2b2b7389ULL, 0x0002a200000e0031ULL, 0xfffea52008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2b7424ULL, 0x000fe200078e00ffULL, 0x0000003200007348ULL, 0x000fe80003800000ULL,
0x000000302f2e7389ULL, 0x0002a200000e0031ULL, 0xfffea4e02a007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000778ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007f0ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e9cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ec0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ed0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ef0ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f60ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f68ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000f78ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000015c00ULL, 0xf100001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016d80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000016d90ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016d90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000017210ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f60ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000015e20ULL, 0x0000000000015e20ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016d80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000017210ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_16_m_16_sm_89_cubin_len = 94960;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
