/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000017c10ULL, 0x0000000000017790ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000016550ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x00000000000166c0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000016700ULL, 0x0000000000000100ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000016800ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001655000000000ULL, 0x0000040400000000ULL, 0x810c000000100400ULL, 0x0059340408288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001655000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080a00828808081ULL, 0x8808288080ae0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808088920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL,
0x000166c000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0xae08288080a00828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080ae920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000016000000000ULL,
0x0001670000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x00081204000000ffULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000800000011ULL, 0x0000001100081104ULL,
0x0008120400000008ULL, 0x0000000800000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005001600000000dULL, 0x000c170400501903ULL, 0x0048000700000000ULL, 0x000c17040021f000ULL,
0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL,
0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0001527000183104ULL, 0x000157a000015790ULL,
0x000158b0000158a0ULL, 0x00c02904000158c0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002505000025ULL, 0x0500002505000025ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000c000c02804ULL, 0x00001ca0000000f0ULL,
0x00001df000001d50ULL, 0x00004e7000001e20ULL, 0x00006cd000004eb0ULL, 0x00006e2000006d90ULL,
0x00009a8000006e60ULL, 0x0000b21000009ab0ULL, 0x0000b5d00000b240ULL, 0x0000e0900000b5e0ULL,
0x0000e5900000e0b0ULL, 0x000151200000e5c0ULL, 0x0001516000015150ULL, 0x0001519000015170ULL,
0x000151d0000151b0ULL, 0x00015890000151e0ULL, 0x00015900000158f0ULL, 0x00015f6000015910ULL,
0x0001605000015fe0ULL, 0x00016140000160d0ULL, 0x00016220000161b0ULL, 0x0001630000016290ULL,
0x000163e000016370ULL, 0x000164c000016460ULL, 0x0280390400016520ULL, 0x000000ff00000170ULL,
0x003f01000001b600ULL, 0x0000000f000001b0ULL, 0x003f01300001b608ULL, 0x0000000f000001e0ULL,
0x003f01300001b610ULL, 0x0000000f00000210ULL, 0x003f01200001b648ULL, 0x0000000f00000240ULL,
0x003f01200001b668ULL, 0x000000ff00000470ULL, 0x003f01070001b600ULL, 0x00000000000006d0ULL,
0x003f010200000004ULL, 0x0000000000000b10ULL, 0x003f010100000000ULL, 0x000000ff00000e20ULL,
0x0004010700000000ULL, 0x0000000000000ea0ULL, 0x003f010100000020ULL, 0x00000004000010d0ULL,
0x003f01060001b66cULL, 0x0000000400001150ULL, 0x003f01060001b66cULL, 0x00000004000011e0ULL,
0x003f01060001b66cULL, 0x0000002600001a20ULL, 0x0004010700000000ULL, 0x0000002800001a90ULL,
0x0004010600000004ULL, 0x0000000500001ab0ULL, 0x003f01060001b60cULL, 0x0000000500001bc0ULL,
0x003f010600000004ULL, 0x0000002800002090ULL, 0x0004010600000004ULL, 0x0000002800002130ULL,
0x0004010600000004ULL, 0x0000000800005fa0ULL, 0x003f010100000000ULL, 0x0000000700006020ULL,
0x003f010100000000ULL, 0x00000004000060d0ULL, 0x003f01060001b66cULL, 0x0000000400006120ULL,
0x003f01060001b66cULL, 0x00000008000061b0ULL, 0x003f010600000004ULL, 0x000000ff00006a30ULL,
0x0004010700000000ULL, 0x0000002a00006aa0ULL, 0x003f010600000004ULL, 0x0000003d00006ac0ULL,
0x003f01060001b62cULL, 0x0000000200006be0ULL, 0x003f010600000004ULL, 0x0000000000007150ULL,
0x003f01060001b64cULL, 0x0000002a00007200ULL, 0x003f010600000004ULL, 0x000000020000aea0ULL,
0x003f010100000000ULL, 0x000000040000af20ULL, 0x003f010100000000ULL, 0x000000ff00010ae0ULL,
0x003f01060001b604ULL, 0x000000ff00010b70ULL, 0x003f01060001b604ULL, 0x000000ff00010d90ULL,
0x003f01010001b600ULL, 0x000000ff00010da0ULL, 0x003f01060001b604ULL, 0x000000ff00010e20ULL,
0x003f01060001b604ULL, 0x0000001300014590ULL, 0x003f01060001b614ULL, 0x0000001300014a20ULL,
0x003f01060001b614ULL, 0x0000001300015e90ULL, 0x003f01010001b608ULL, 0x00141c0400053803ULL,
0x0000f4100000efc0ULL, 0x00010f1000010e70ULL, 0x0000040100015f00ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000001ccULL, 0x0000001100000002ULL, 0x000000000000014cULL, 0x0000001100000002ULL,
0x00000000000000ccULL, 0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL,
0x00000000000001a2ULL, 0x0000001100000002ULL, 0x0000000000000122ULL, 0x0000001100000002ULL,
0x00000000000000a8ULL, 0x0000001100000002ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x00000004ff117424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe20000000a00ULL,
0xfffffff801017810ULL, 0x000fe20007ffe0ffULL, 0x0000000000037919ULL, 0x000e680000002200ULL,
0x0000000000077919ULL, 0x000ea80000002100ULL, 0x0000000000147919ULL, 0x000ee80000002700ULL,
0x0000000000157919ULL, 0x000f220000002600ULL, 0x0000000106007824ULL, 0x002fc800078e0203ULL,
0x00000080000f7824ULL, 0x104fe200078e0207ULL, 0x00000005ff0e7819ULL, 0x000fe20000011607ULL,
0x00001fff06007589ULL, 0x00066600000e0000ULL, 0x000000ff0f00720cULL, 0x040fe40003f05270ULL,
0x000000030f00780cULL, 0x040fe20003f44070ULL, 0x00001fff0e0e7589ULL, 0x000ea200000e0000ULL,
0x0000007f0f00780cULL, 0x040fe20003f24070ULL, 0x0000600014067625ULL, 0x008fe200078e0011ULL,
0x000000010f00780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL, 0x01b60002ff008388ULL, 0x0007e20000000a00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x3fffffc0ff08a424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL, 0x01b608040f00a388ULL, 0x0007e2000000ca00ULL,
0x3fffffc0ff0aa424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL,
0x01b610080f00a388ULL, 0x0007e2000000ca00ULL, 0xff317217ff109424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL, 0x01b6480a0f00a388ULL, 0x0007e20000008a00ULL,
0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL, 0x01b400100f009388ULL, 0x0007e80000004800ULL,
0x01b6680c0f00b388ULL, 0x0007e80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000027000000947ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x01ce620000000000ULL,
0x000000040e047824ULL, 0x000fc400078e00ffULL, 0x00005800ff027624ULL, 0x000fe400078e00ffULL,
0x0000001015037824ULL, 0x000fe400078e00ffULL, 0x0000001002027824ULL, 0x000fe400078e00ffULL,
0x00000100ff0c7424ULL, 0x000fe400078e00ffULL, 0x0000001402027224ULL, 0x000fe200078e0203ULL,
0x000000040d097211ULL, 0x042fe200078fe0ffULL, 0x000000100d047824ULL, 0x000fc600078e00ffULL,
0x00000002090b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000102037824ULL, 0x040fe200078e0209ULL,
0x0000000709087812ULL, 0x000fe400078ec0ffULL, 0x000000070b0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000102057824ULL, 0x000fe200078e020bULL, 0x000000f0040f7812ULL, 0x000fe200078ec0ffULL,
0x00005c0003027625ULL, 0x080fe200078e000cULL, 0x0000000f08087812ULL, 0x100fe400078e780dULL,
0x0000000f0a0a7812ULL, 0x000fe200078e780dULL, 0x00005c0005047625ULL, 0x000fe200078e000cULL,
0x0000000f02027210ULL, 0x000fc60007f1e0ffULL, 0x0000001009087824ULL, 0x000fe200078e0208ULL,
0x0000000f04047210ULL, 0x000fe20007f3e0ffULL, 0x000000100b0a7824ULL, 0x000fe400078e020aULL,
0x000000ffff037224ULL, 0x000fe400000e0603ULL, 0x0000001008097824ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400008e0605ULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000b901c46ULL,
0x00000000040b7faeULL, 0x0003e8000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006060f7981ULL, 0x01cea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x00000004ff107e24ULL, 0x008fe2000f8e00ffULL,
0x000000ff0f117810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff117819ULL, 0x000fce0000011611ULL,
0x0000eed000008947ULL, 0x000fea0003800000ULL, 0x0000000000127919ULL, 0x000ea20000000000ULL,
0x000000200efc7824ULL, 0x000fe200078e00ffULL, 0x0000580015037a10ULL, 0x002fe20007ffe0ffULL,
0x0000000214007824ULL, 0x000fe200078e00ffULL, 0x0000000110027810ULL, 0x000fe20007ffe0ffULL,
0x00000001ff157424ULL, 0x000fe200078e00ffULL, 0x00000020fc137812ULL, 0x000fe200078ec0ffULL,
0x0000580000167a24ULL, 0x000fe200078e0203ULL, 0x000000110200720cULL, 0x000fe40003f06070ULL,
0x0001b6100e007811ULL, 0x000fc400078e20ffULL, 0x00000003ff187819ULL, 0x004fc80000011612ULL,
0x00000004181a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000113057824ULL, 0x000fc800078e0218ULL,
0x0000000113077824ULL, 0x000fe200078e021aULL, 0x0000001205027212ULL, 0x0c0fe200078e3cffULL,
0x0000000805097824ULL, 0x000fe400078e00ffULL, 0x0000000807087824ULL, 0x040fe200078e00ffULL,
0x0000001207037212ULL, 0x000fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000008181c7810ULL, 0x000fe20007ffe0ffULL, 0x0000041500ff738cULL, 0x0003e20000000000ULL,
0x00000001ff2d7819ULL, 0x000fe2000001160eULL, 0x00000010122f7824ULL, 0x000fe200078e00ffULL,
0xfffffff809047812ULL, 0x000fe200078ee202ULL, 0x0000000113097824ULL, 0x000fe200078e021cULL,
0x0000000c181e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000410027824ULL, 0x000fe200078e022dULL,
0xfffffff808087812ULL, 0x000fe200078ee203ULL, 0x00000008090a7824ULL, 0x040fe200078e00ffULL,
0x0000001209037212ULL, 0x080fe200078e3cffULL, 0x00000001130b7824ULL, 0x000fe200078e021eULL,
0x0000001018207810ULL, 0x000fe20007ffe0ffULL, 0x0000004002027824ULL, 0x000fe200078e00ffULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee203ULL, 0x000000080b157824ULL, 0x042fe200078e00ffULL,
0x000000120b067212ULL, 0x000fe200078e3cffULL, 0x00000001130d7824ULL, 0x000fe200078e0220ULL,
0x000000020f037217ULL, 0x000fe20007800000ULL, 0x000040002d1d7824ULL, 0x000fe200078e00ffULL,
0x0000001418227810ULL, 0x040fe20007ffe0ffULL, 0x000000080d177824ULL, 0x000fe200078e00ffULL,
0x0000001818247810ULL, 0x000fc40007ffe0ffULL, 0x0000001c18287810ULL, 0x000fe20007ffe0ffULL,
0x0000041d01007387ULL, 0x0003e20000100800ULL, 0xfffffff8150c7812ULL, 0x000fe200078ee206ULL,
0x0000000103067824ULL, 0x100fe200078e0a02ULL, 0x000000120d147212ULL, 0x000fe200078e3cffULL,
0x0000620016027a24ULL, 0x000fe200078e0202ULL, 0x000000702f2f7812ULL, 0x000fe200078ec0ffULL,
0x0000000113157824ULL, 0x000fe200078e0222ULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x0000000113197824ULL, 0x040fe400078e0224ULL, 0x00000001131b7824ULL, 0x000fc400078e0228ULL,
0x0000000102037824ULL, 0x040fe200078e0205ULL, 0x0000001215057212ULL, 0x0c0fe200078e3cffULL,
0x0000000815167824ULL, 0x000fe400078e00ffULL, 0x0000000102177824ULL, 0x040fe200078e020dULL,
0x00000012190d7212ULL, 0x0c0fe200078e3cffULL, 0x00000008192a7824ULL, 0x000fe400078e00ffULL,
0x0000000102237824ULL, 0x000fe200078e0215ULL, 0x000000121b157212ULL, 0x040fe200078e3cffULL,
0x000000081b2c7824ULL, 0x000fc400078e00ffULL, 0x0000000102077824ULL, 0x040fe400078e0207ULL,
0x0000000102097824ULL, 0x040fe400078e0209ULL, 0x00000001020b7824ULL, 0x040fe400078e020bULL,
0x0000000102267824ULL, 0x040fe400078e0219ULL, 0x0000000102297824ULL, 0x000fe200078e021bULL,
0xfffffff816027812ULL, 0x000fe400078ee205ULL, 0xfffffff82a167812ULL, 0x000fc400078ee20dULL,
0x000130001d057810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82c2a7812ULL, 0x000fe200078ee215ULL,
0x00000080ff2c7424ULL, 0x000fe400078e00ffULL, 0x0000001002257824ULL, 0x100fe400078e0205ULL,
0x0000001004197824ULL, 0x100fe400078e0205ULL, 0x00000010081b7824ULL, 0x100fe400078e0205ULL,
0x000000100a1d7824ULL, 0x002fc400078e0205ULL, 0x000000100c1f7824ULL, 0x100fe400078e0205ULL,
0x0000001014217824ULL, 0x100fe400078e0205ULL, 0x0000001016277824ULL, 0x100fe400078e0205ULL,
0x000000102a2b7824ULL, 0x000fe400078e0205ULL, 0x00005e0003027625ULL, 0x000fe200078e002cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00005e0007047625ULL, 0x080fe200078e002cULL,
0x0000004006147807ULL, 0x000fe20000000000ULL, 0x0000000000ff7f8cULL, 0x0003e2000c80043fULL,
0x0000002f020a7210ULL, 0x080fe20007f1e0ffULL, 0x00005e0009067625ULL, 0x080fe200078e002cULL,
0x0000002f040c7210ULL, 0x000fe20007f3e0ffULL, 0x000000002d0473c2ULL, 0x000ea200000e0000ULL,
0x0000001314027217ULL, 0x000fe20007800000ULL, 0x00005e000b087625ULL, 0x000fe200078e002cULL,
0x000000010ec67812ULL, 0x000fc600078ec0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e0605ULL,
0x0000002f08167210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0603ULL,
0x0000002f06147210ULL, 0x000fe20007f1e0ffULL, 0x0000000102007824ULL, 0x002fe400078e0a13ULL,
0x00005e0023047625ULL, 0x000fc600078e002cULL, 0x000000001800720cULL, 0x000fe20003f86070ULL,
0x00005e0017027625ULL, 0x000fe200078e002cULL, 0x000000001a00720cULL, 0x080fe40003fa6070ULL,
0x000000001c00720cULL, 0x000fe20003f66070ULL, 0x000000ffff177224ULL, 0x000fe200008e0609ULL,
0x0000002f04047210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e0607ULL,
0x0000002f02027210ULL, 0x000fe20007f1e0ffULL, 0x00005e0029087625ULL, 0x000fe200078e002cULL,
0x000000001e00720cULL, 0x000fe20003f46070ULL, 0x0001b64804047891ULL, 0x004fc4000f8e203fULL,
0x00005e0026067625ULL, 0x000fe200078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a197faeULL, 0x0003e2000e101c46ULL, 0x000000002400720cULL, 0x080fe40003f86070ULL,
0x000000ffff057224ULL, 0x000fe200008e0605ULL, 0x0000002f08087210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000002f06067210ULL, 0x000fe20007f1e0ffULL,
0x000000000c1b7faeULL, 0x0005e2000e901c46ULL, 0x000000002800720cULL, 0x080fe20003fa6070ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000002000720cULL, 0x080fe20003f26070ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x000000002200720cULL, 0x000fe20003f06070ULL,
0x00000000141d7faeULL, 0x0005e2000d901c46ULL, 0x0001b6482d007811ULL, 0x000fc600078e18ffULL,
0x00000000161f7faeULL, 0x0005ec000d101c46ULL, 0x0000000002217faeULL, 0x0005e8000c901c46ULL,
0x0000000004257faeULL, 0x0005e2000c101c46ULL, 0x000000111000720cULL, 0x000fc60003f06070ULL,
0x0000000006277faeULL, 0x0005e8000e101c46ULL, 0x00000000082b7faeULL, 0x0005e8000e901c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200000ff7f8cULL, 0x0003e2000c80043fULL, 0xff317217ff147424ULL, 0x004fe200078e00ffULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000a00000000947ULL, 0x000fea0003800000ULL,
0xff317217ff147424ULL, 0x002fe200078e00ffULL, 0x00007610ff027816ULL, 0x000fe20000000002ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x00007610ff037816ULL, 0x000fe20000000003ULL,
0x000000ffff337224ULL, 0x000fe200078e00ffULL, 0x00007610ff1e7816ULL, 0x000fc4000000001eULL,
0xffffffc0fc057812ULL, 0x000fca00078ec0ffULL, 0x0000010010087824ULL, 0x002fca00078e0205ULL,
0x0000000f0800720cULL, 0x000fda0003f06070ULL, 0x00009f0000000947ULL, 0x000fea0003800000ULL,
0x000000040e297824ULL, 0x000fe200078e00ffULL, 0x0000ffff02057812ULL, 0x000fe200078ec0ffULL,
0x000000ffff167224ULL, 0x000fc600078e0000ULL, 0xfffffff829047812ULL, 0x000fe400078ec0ffULL,
0x0000888005077816ULL, 0x000fc600000000ffULL, 0x01b66c0004067984ULL, 0x000e640000000800ULL,
0x8000000007057824ULL, 0x000fca00078e00ffULL, 0x8000000006ff7812ULL, 0x002fe20007804805ULL,
0x0000000000007918ULL, 0x000fec0000000000ULL, 0x0000761002067816ULL, 0x000fe40000000006ULL,
0x0000761003e57816ULL, 0x000fc600000000e5ULL, 0x0000000601007387ULL, 0x0003e20000100600ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x01b66c0004067984ULL, 0x002e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000007077824ULL, 0x000fe400078e00ffULL,
0x3e000000ff057424ULL, 0x000fc800078e00ffULL, 0x0000000500067305ULL, 0x0002a4000021f000ULL,
0x3fa0000005057823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe40003800000ULL,
0x01b66c0004067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fc40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000003ff1a7819ULL, 0x000fe20000011612ULL, 0x00000000001d7919ULL, 0x000ea20000002600ULL,
0x0000000110067810ULL, 0x002fe20007ffe0ffULL, 0x00000080ff277424ULL, 0x000fe200078e00ffULL,
0x000000041a1c7810ULL, 0x040fe20007ffe0ffULL, 0x00000000000d7919ULL, 0x000e620000002700ULL,
0x0000000113097824ULL, 0x040fe200078e021aULL, 0x000000081a267810ULL, 0x040fe40007ffe0ffULL,
0x00000001130a7824ULL, 0x000fe200078e021cULL, 0x0000000c1a287810ULL, 0x000fe20007ffe0ffULL,
0x00000008090c7824ULL, 0x040fe200078e00ffULL, 0x0000001209057212ULL, 0x080fe200078e3cffULL,
0x00000001130b7824ULL, 0x040fe200078e0226ULL, 0x000000110600720cULL, 0x000fe20003f06070ULL,
0x000000080a257824ULL, 0x000fe200078e00ffULL, 0x000000101a2a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000113197824ULL, 0x000fe200078e0228ULL, 0x000000120a067212ULL, 0x000fc400078e3cffULL,
0xfffffff80c237812ULL, 0x000fe200078ee205ULL, 0x000000080b0c7824ULL, 0x040fe200078e00ffULL,
0x000000120b057212ULL, 0x080fe200078e3cffULL, 0x00000008192f7824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee206ULL, 0x00000001131b7824ULL, 0x000fe200078e022aULL,
0x000000141a2c7810ULL, 0x000fe40007ffe0ffULL, 0x0000001219067212ULL, 0x080fe200078e3cffULL,
0x000000020d0d7824ULL, 0x002fe200078e00ffULL, 0xfffffff80c2d7812ULL, 0x000fe200078ee205ULL,
0x000000081b0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee206ULL,
0x0000000113207824ULL, 0x000fe200078e022cULL, 0x000000121b057212ULL, 0x000fc400078e3cffULL,
0x0000008008067810ULL, 0x000fe20007ffe0ffULL, 0x0000000820187824ULL, 0x000fe200078e00ffULL,
0x000058001d1d7a10ULL, 0x004fe20007ffe0ffULL, 0x0000001012087824ULL, 0x000fe200078e00ffULL,
0x000000181a2e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80c357812ULL, 0x000fe200078ee205ULL,
0x000058000d0d7a24ULL, 0x000fe200078e021dULL, 0x0000001220077212ULL, 0x000fe200078e3cffULL,
0x0000000113227824ULL, 0x000fe200078e022eULL, 0x000000060f057217ULL, 0x000fc40007800000ULL,
0xfffffff818377812ULL, 0x000fe200078ee207ULL, 0x0000000822397824ULL, 0x040fe200078e00ffULL,
0x00000012220c7212ULL, 0x000fe200078e3cffULL, 0x0000000105077824ULL, 0x100fe200078e0a06ULL,
0x0000001c1a347810ULL, 0x000fe20007ffe0ffULL, 0x000062000d057a24ULL, 0x000fe200078e0206ULL,
0xfffffff839397812ULL, 0x000fe400078ee20cULL, 0x00000070082b7812ULL, 0x000fe200078ec0ffULL,
0x0000000109067824ULL, 0x000fe200078e0205ULL, 0x0000004007087807ULL, 0x000fe20000000000ULL,
0x00000001130c7824ULL, 0x000fe200078e0234ULL, 0x00000001ff947819ULL, 0x000fe2000001160eULL,
0x00005e0006067625ULL, 0x000fc800078e0027ULL, 0x000000010a097824ULL, 0x100fe200078e0205ULL,
0x00000008130a7217ULL, 0x000fe20007800000ULL, 0x000000010b0b7824ULL, 0x100fe400078e0205ULL,
0x0000000119197824ULL, 0x100fe400078e0205ULL, 0x000000011b1b7824ULL, 0x100fe400078e0205ULL,
0x0000000120207824ULL, 0x100fe400078e0205ULL, 0x0000000122227824ULL, 0x000fc400078e0205ULL,
0x000000010c247824ULL, 0x040fe200078e0205ULL, 0x000000120c057212ULL, 0x040fe200078e3cffULL,
0x000000080c187824ULL, 0x000fe200078e00ffULL, 0x0000002b060c7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0009087625ULL, 0x000fc600078e0027ULL, 0xfffffff8183b7812ULL, 0x000fe200078ee205ULL,
0x000000010a1f7824ULL, 0x000fe400078e0a13ULL, 0x000000ffff0d7224ULL, 0x000fe200000e0607ULL,
0x0000002b08187210ULL, 0x000fe20007f1e0ffULL, 0x00005e000b067625ULL, 0x000fe200078e0027ULL,
0x0000001f1a00720cULL, 0x080fe40003f86070ULL, 0x0000001f1c00720cULL, 0x000fe20003fa6070ULL,
0x0000200000057824ULL, 0x000fe200078e00ffULL, 0x0000002b061a7210ULL, 0x000fe20007f3e0ffULL,
0x00005e00190a7625ULL, 0x000fc600078e0027ULL, 0x0000200005057812ULL, 0x000fe200078e0cffULL,
0x000000ffff197224ULL, 0x000fe200000e0609ULL, 0x0000001f2600720cULL, 0x000fe20003f06070ULL,
0x00005e001b087625ULL, 0x000fe200078e0027ULL, 0x0000002b0a0a7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e0607ULL, 0x0000001f2800720cULL, 0x000fe20003f26070ULL,
0x0000400094487824ULL, 0x000fe200078e0205ULL, 0x0000002b081c7210ULL, 0x000fe20007f7e0ffULL,
0x0000000800287824ULL, 0x000fe400078e00ffULL, 0x0000001094057824ULL, 0x000fe200078e00ffULL,
0x0001300048487810ULL, 0x000fe20007ffe0ffULL, 0x00005e0020067625ULL, 0x000fe200078e0027ULL,
0x0000000828267812ULL, 0x000fe200078e0cffULL, 0x00000000050473c2ULL, 0x000e6400000e0000ULL,
0x0000001023237824ULL, 0x100fe200078e0248ULL, 0x0000002b06207210ULL, 0x000fe20007fde0ffULL,
0x0000001025257824ULL, 0x000fc400078e0248ULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c237faeULL, 0x0005e2000e101c46ULL,
0x00000000260573c2ULL, 0x000ee200000e0000ULL, 0x000000ffff217224ULL, 0x000fe200030e0607ULL,
0x0000001f2a00720cULL, 0x000fe20003f46070ULL, 0x00005e0022067625ULL, 0x000fe200078e0027ULL,
0x0000000018257faeULL, 0x0009e2000e901c46ULL, 0x0000001f2e00720cULL, 0x000fe40003fa6070ULL,
0x000000ffff1d7224ULL, 0x000fe200018e0609ULL, 0x0000002b06067210ULL, 0x000fe20007f9e0ffULL,
0x00005e0024087625ULL, 0x000fe200078e0027ULL, 0x0000001f2c00720cULL, 0x000fc60003f66070ULL,
0x000000ffff077224ULL, 0x000fe200020e0607ULL, 0x0000001f3400720cULL, 0x000fe20003f86070ULL,
0x000000102d277824ULL, 0x100fe200078e0248ULL, 0x0001b64804047890ULL, 0x002fe2000fffe03fULL,
0x0000002b08087210ULL, 0x000fe20007fde0ffULL, 0x000000102f1f7824ULL, 0x100fe400078e0248ULL,
0x00000010350d7824ULL, 0x104fe200078e0248ULL, 0x000000001a277faeULL, 0x0003e2000c101c46ULL,
0x0000001037197824ULL, 0x110fe200078e0248ULL, 0x0000000504057290ULL, 0x008fe2000fffe03fULL,
0x0000001039237824ULL, 0x000fe200078e0248ULL, 0x000000000a1f7faeULL, 0x0003e2000c901c46ULL,
0x000000ffff097224ULL, 0x000fc400030e0609ULL, 0x000000103b257824ULL, 0x000fe200078e0248ULL,
0x000000001c0d7faeULL, 0x0003e8000d101c46ULL, 0x0000000020197faeULL, 0x0003e8000d901c46ULL,
0x0000000006237faeULL, 0x0003e8000e901c46ULL, 0x0000000008257faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000040428087984ULL, 0x0022a20008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01b60c00050a7984ULL, 0x000ee20000000800ULL,
0x0000ffff03067812ULL, 0x000fc400078ec0ffULL, 0x0000ffff1e077812ULL, 0x000fe400078ec0ffULL,
0x00008880060b7816ULL, 0x000fe400000000ffULL, 0x0000888007067816ULL, 0x000fc600000000ffULL,
0x800000000b077824ULL, 0x000fe400078e00ffULL, 0x8000000006097824ULL, 0x000fc600078e00ffULL,
0x8000000008ff7812ULL, 0x004fe40007804807ULL, 0x800000000aff7812ULL, 0x008fe20007824809ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x8000000006077824ULL, 0x000fe200078e00ffULL, 0x0001b60894057811ULL, 0x000fe200078e20ffULL,
0x3e000000ff067424ULL, 0x000fc800078e00ffULL, 0x0000000600087305ULL, 0x0004e4000021f000ULL,
0x3fa0000006067823ULL, 0x004fe200000100ffULL, 0x000000080000735dULL, 0x008fe40003800000ULL,
0x0000040005087984ULL, 0x000ea40000000800ULL, 0x8000000008ff7812ULL, 0x004fc40007824807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000010120d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe20000011612ULL,
0x00000001ff687424ULL, 0x000fc600078e00ffULL, 0x000000700d077812ULL, 0x000fe400078ec0ffULL,
0x0000000c05067812ULL, 0x000fc600078ec0ffULL, 0x0000008094057824ULL, 0x000fc800078e0207ULL,
0x0000000105057824ULL, 0x000fca00078e0206ULL, 0x01b0000005077984ULL, 0x000ea80000000800ULL,
0x01b2000005067984ULL, 0x0007220000000800ULL, 0x000000140700720bULL, 0x004fda0003f3d000ULL,
0x0000000000087806ULL, 0x000fc800008e0100ULL, 0x0000ffff080c7812ULL, 0x000fda000782c0ffULL,
0x000003a000009947ULL, 0x000fea0003800000ULL, 0x000000140700720bULL, 0x018fe40003f54000ULL,
0x0000000714187209ULL, 0x000fe40007810000ULL, 0x0000000e9400720cULL, 0x000fe40003f25270ULL,
0x00000002ff097819ULL, 0x000fe20000011612ULL, 0x8000001814057221ULL, 0x100fe40000010000ULL,
0x000000ffff147224ULL, 0x000fe200078e0018ULL, 0x00000008090a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b05087820ULL, 0x000fc40000410000ULL, 0x0000000000057806ULL, 0x000fc800010e0100ULL,
0x0000ffff05057812ULL, 0x000fe200078e3cffULL, 0x0000000800087308ULL, 0x000ea60000000800ULL,
0x000000050cff7212ULL, 0x000fe4000784c0ffULL, 0x000000700d059812ULL, 0x000fe400078ec0ffULL,
0x00000001ff0c9819ULL, 0x000fe40000011612ULL, 0x00000001ff687807ULL, 0x000fe20001000000ULL,
0x000000800e059824ULL, 0x000fe200078e0205ULL, 0x0000000c0c0c9812ULL, 0x000fca00078ec0ffULL,
0x000000010c059824ULL, 0x000fe200078e0205ULL, 0x00001f0a080a7589ULL, 0x004ea200000e0000ULL,
0x8000001807072221ULL, 0x000fe40000010000ULL, 0x0000000815157220ULL, 0x000fe20000410000ULL,
0x00001f0908097589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b07072820ULL, 0x000fc60000410000ULL,
0x01b4001805009388ULL, 0x0009e20000000800ULL, 0x0000000700172308ULL, 0x000f620000000800ULL,
0x0000000a33337220ULL, 0x084fe40000410000ULL, 0x0000000a32327220ULL, 0x080fe40000410000ULL,
0x0000000a63637220ULL, 0x080fe40000410000ULL, 0x0000000a62627220ULL, 0x080fe40000410000ULL,
0x0000000a67677220ULL, 0x000fc40000410000ULL, 0x0000000a66667220ULL, 0x080fe40000410000ULL,
0x0000000a5f5f7220ULL, 0x080fe40000410000ULL, 0x0000000a5e5e7220ULL, 0x080fe40000410000ULL,
0x0000000a5b5b7220ULL, 0x080fe40000410000ULL, 0x0000000a5a5a7220ULL, 0x080fe40000410000ULL,
0x0000000a57577220ULL, 0x000fc40000410000ULL, 0x0000000a56567220ULL, 0x080fe40000410000ULL,
0x0000000a53537220ULL, 0x080fe40000410000ULL, 0x0000000a52527220ULL, 0x080fe40000410000ULL,
0x0000000a4f4f7220ULL, 0x080fe40000410000ULL, 0x0000000a4e4e7220ULL, 0x000fe40000410000ULL,
0x0000000931317220ULL, 0x008fc40000410000ULL, 0x0000000930307220ULL, 0x080fe40000410000ULL,
0x0000000961617220ULL, 0x080fe40000410000ULL, 0x0000000960607220ULL, 0x080fe40000410000ULL,
0x0000000965657220ULL, 0x080fe40000410000ULL, 0x0000000964647220ULL, 0x080fe40000410000ULL,
0x000000095d5d7220ULL, 0x000fc40000410000ULL, 0x000000095c5c7220ULL, 0x080fe40000410000ULL,
0x0000000959597220ULL, 0x080fe40000410000ULL, 0x0000000958587220ULL, 0x080fe40000410000ULL,
0x0000000955557220ULL, 0x080fe40000410000ULL, 0x0000000954547220ULL, 0x080fe40000410000ULL,
0x0000000951517220ULL, 0x000fc40000410000ULL, 0x0000000950507220ULL, 0x080fe40000410000ULL,
0x000000094d4d7220ULL, 0x080fe40000410000ULL, 0x000000094c4c7220ULL, 0x000fe40000410000ULL,
0x0000001706062220ULL, 0x020fc80000410000ULL, 0x0000001506157221ULL, 0x018fe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x0000040428057984ULL, 0x000ea20008000800ULL,
0x800000000b067824ULL, 0x000fca00078e00ffULL, 0x8000000005ff7812ULL, 0x004fe20007804806ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000000b0b7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff057424ULL, 0x000fc800078e00ffULL,
0x0000000500067305ULL, 0x0004e4000021f000ULL, 0x3fa0000005057823ULL, 0x004fe200000100ffULL,
0x000000060000735dULL, 0x008fe40003800000ULL, 0x0000040428067984ULL, 0x000ea40008000800ULL,
0x8000000006ff7812ULL, 0x004fc4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000040001077983ULL, 0x000ea20000100800ULL,
0x0000000429057812ULL, 0x000fe400078ec0ffULL, 0x0000000812067812ULL, 0x040fe400078ec0ffULL,
0x0000000512187211ULL, 0x000fe400078fe0ffULL, 0x0000000706497812ULL, 0x140fe400078ec812ULL,
0x00000007060d7812ULL, 0x000fe400078ef812ULL, 0x00000018494a7212ULL, 0x000fc400078e3cffULL,
0x000001000d767811ULL, 0x040fe400078e18ffULL, 0x000000800d6f7811ULL, 0x040fe200078e18ffULL,
0x000000080d057824ULL, 0x000fe200078e024aULL, 0x00000001ff2d7819ULL, 0x000fe2000001160eULL,
0x000000014a097824ULL, 0x000fe200078e0276ULL, 0x0000000218187810ULL, 0x000fc60007ffe0ffULL,
0x000000022da57824ULL, 0x000fe200078e0200ULL, 0x0000001849497212ULL, 0x000fc800078e3cffULL,
0x00013000a5a57811ULL, 0x000fe200078e68ffULL, 0x0000200000d07824ULL, 0x004fe400078e0207ULL,
0x000000014a077824ULL, 0x100fe400078e026fULL, 0x00000001496f7824ULL, 0x000fe200078e026fULL,
0x00013000d0d07810ULL, 0x000fca0007ffe0ffULL, 0x0000001005057824ULL, 0x100fe400078e02d0ULL,
0x0000001009097824ULL, 0x100fe400078e02d0ULL, 0x0000001007077824ULL, 0x000fe200078e02d0ULL,
0x000000000534783bULL, 0x000ea80000004200ULL, 0x000000000928783bULL, 0x002e680000004200ULL,
0x000000000724783bULL, 0x0007220000004200ULL, 0x00000018ff067819ULL, 0x004fe20000011435ULL,
0x0000003400d17306ULL, 0x000fe20000009400ULL, 0x00000018ff057819ULL, 0x000fc40000011434ULL,
0x00000018ff197819ULL, 0x002fe4000001142aULL, 0x00000018ff077819ULL, 0x008fe40000011436ULL,
0x00000018ff097819ULL, 0x010fe20000011424ULL, 0x00000006004b7306ULL, 0x000fe20000209400ULL,
0x00000018ff1a7819ULL, 0x000fe4000001142bULL, 0x00000018ff0a7819ULL, 0x000fe40000011425ULL,
0x00000018ff087819ULL, 0x000fc60000011437ULL, 0x0000000600a07306ULL, 0x000ff00000205400ULL,
0x0000000600457306ULL, 0x0003f0000020d400ULL, 0x00000005006e7306ULL, 0x000fe20000209400ULL,
0x000001800d067811ULL, 0x042fe200078e18ffULL, 0x000000080d0d7824ULL, 0x000fc800078e0249ULL,
0x000000100d0d7824ULL, 0x000fe400078e02d0ULL, 0x0000000500847306ULL, 0x000e700000205400ULL,
0x0000000500447306ULL, 0x0004f0000020d400ULL, 0x00000019003b7306ULL, 0x000fe20000209400ULL,
0x000000014a057824ULL, 0x104fe200078e0206ULL, 0x000000846e00720bULL, 0x002fe20003f7d000ULL,
0x0000000149067824ULL, 0x000fc400078e0206ULL, 0x0000001005207824ULL, 0x000fc600078e02a5ULL,
0x00000019003a7306ULL, 0x000fe60000205400ULL, 0x000000002020783bULL, 0x000e680000004200ULL,
0x0000000144443812ULL, 0x008fe200078efcffULL, 0x0000001900797306ULL, 0x0005e2000020d400ULL,
0x000000a04b00720bULL, 0x000fce0003f7d000ULL, 0x0000000900937306ULL, 0x000fe20000209400ULL,
0x0000010034197824ULL, 0x004fca00078e00ffULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000000900927306ULL, 0x000fe20000205400ULL, 0x0000000145453812ULL, 0x000fce00078efcffULL,
0x0000000900ba7306ULL, 0x0005f0000020d400ULL, 0x00000007000c7306ULL, 0x000fe20000209400ULL,
0x00000018ff097819ULL, 0x004fe40000011428ULL, 0x00000018ff1b7819ULL, 0x002fc40000011420ULL,
0x00000018ff3e7819ULL, 0x000fe40000011422ULL, 0x00000018ff3f7819ULL, 0x000fe20000011423ULL,
0x0000000700d77306ULL, 0x000fe20000205400ULL, 0x00000018ff2c7819ULL, 0x000fce0000011421ULL,
0x0000000700e07306ULL, 0x0003f0000020d400ULL, 0x0000001a00397306ULL, 0x000fe20000209400ULL,
0x00000018ff077819ULL, 0x002fce0000011426ULL, 0x0000001a00387306ULL, 0x000ff00000205400ULL,
0x0000001a00727306ULL, 0x0003f0000020d400ULL, 0x00000009009d7306ULL, 0x000fe20000209400ULL,
0x00000100351a7824ULL, 0x002fce00078e00ffULL, 0x00000009009e7306ULL, 0x000ff00000205400ULL,
0x0000000900867306ULL, 0x000ff0000020d400ULL, 0x0000000700a97306ULL, 0x000ff00000209400ULL,
0x0000000700aa7306ULL, 0x000ff00000205400ULL, 0x0000000700b07306ULL, 0x000ff0000020d400ULL,
0x0000003e00f57306ULL, 0x000ff00000209400ULL, 0x0000003e00d27306ULL, 0x000ff00000205400ULL,
0x0000003e00097306ULL, 0x0003f0000020d400ULL, 0x0000001b00b97306ULL, 0x000fe20000209400ULL,
0x00000018ff3e7819ULL, 0x002fce000001141aULL, 0x0000001b00b87306ULL, 0x000ff00000205400ULL,
0x0000001b00077306ULL, 0x000ff0000020d400ULL, 0x0000001900717306ULL, 0x000ff00000209400ULL,
0x0000001900787306ULL, 0x000e700000205400ULL, 0x0000001900827306ULL, 0x0004f0000020d400ULL,
0x0000003400ee7306ULL, 0x000f220000005400ULL, 0x000000000d18783bULL, 0x004ea20000004200ULL,
0x000000787100720bULL, 0x002fcc0003f1d000ULL, 0x00000034006c7306ULL, 0x00036e000000d400ULL,
0x0000000182820812ULL, 0x008fe200078efcffULL, 0x0000000a001c7306ULL, 0x000fe20000209400ULL,
0x0001000034347824ULL, 0x002fe200078e00ffULL, 0x000000eed100720bULL, 0x010fc80003f3d000ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000000a001d7306ULL, 0x000fee0000205400ULL,
0x000000016c6c1812ULL, 0x020fe200078efcffULL, 0x0000003400c47306ULL, 0x000ff00000209400ULL,
0x0000003400c57306ULL, 0x000e700000205400ULL, 0x0000003400477306ULL, 0x000730000020d400ULL,
0x0000000a00b67306ULL, 0x000be2000020d400ULL, 0x0000010036347824ULL, 0x008fe200078e00ffULL,
0x000000c5c400720bULL, 0x002fc80003f1d000ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003f00f77306ULL, 0x000fe20000209400ULL, 0x00000018ff0a7819ULL, 0x020fcc0000011429ULL,
0x0000000147470812ULL, 0x010fe200078efcffULL, 0x0000000a006b7306ULL, 0x000fe60000209400ULL,
0x000000474444723eULL, 0x000fca00000010ffULL, 0x0000000a00437306ULL, 0x000ff00000205400ULL,
0x0000000a007c7306ULL, 0x000ff0000020d400ULL, 0x0000003f00f67306ULL, 0x000ff00000205400ULL,
0x0000003f000a7306ULL, 0x000ff0000020d400ULL, 0x0000003500cf7306ULL, 0x000ff00000009400ULL,
0x00000035007e7306ULL, 0x000e700000005400ULL, 0x00000035006a7306ULL, 0x000730000000d400ULL,
0x00000034008f7306ULL, 0x000fe20000209400ULL, 0x0001000035357824ULL, 0x008fe200078e00ffULL,
0x0000007ecf00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400d67306ULL, 0x000fee0000205400ULL, 0x000000016a6a4812ULL, 0x010fe200078efcffULL,
0x00000034003f7306ULL, 0x0005f0000020d400ULL, 0x0000000800427306ULL, 0x000fe20000209400ULL,
0x00000018ff347819ULL, 0x004fce0000011418ULL, 0x0000000800d47306ULL, 0x000ff00000205400ULL,
0x0000000800c87306ULL, 0x0003f0000020d400ULL, 0x0000003e00697306ULL, 0x000fe20000209400ULL,
0x00000018ff087819ULL, 0x002fce0000011427ULL, 0x0000003e00917306ULL, 0x000e700000205400ULL,
0x0000003e00877306ULL, 0x0004f0000020d400ULL, 0x0000003600c37306ULL, 0x000fe20000009400ULL,
0x00000100373e7824ULL, 0x004fe200078e00ffULL, 0x000000916900720bULL, 0x002fc80003f3d000ULL,
0x00000018ff407819ULL, 0x000fe4000001143eULL, 0x0000003600ce7306ULL, 0x000e6e0000005400ULL,
0x0000000187871812ULL, 0x008fe200078efcffULL, 0x00000036003c7306ULL, 0x0004f0000000d400ULL,
0x00000037006d7306ULL, 0x000fe20000009400ULL, 0x0001000036367824ULL, 0x004fe200078e00ffULL,
0x000000cec300720bULL, 0x002fc80003fbd000ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003700777306ULL, 0x000e6e0000005400ULL, 0x000000013c3c5812ULL, 0x008fe200078efcffULL,
0x00000037003d7306ULL, 0x0004e2000000d400ULL, 0x000000d70c00720bULL, 0x000fce0003fbd000ULL,
0x00000034008b7306ULL, 0x000fe20000209400ULL, 0x0001000037377824ULL, 0x004fe200078e00ffULL,
0x000000776d00720bULL, 0x002fc80003f5d000ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000003400cc7306ULL, 0x000fe20000205400ULL, 0x00000001e0e05812ULL, 0x000fcc00078efcffULL,
0x000000013d3d2812ULL, 0x008fe200078efcffULL, 0x0000003400417306ULL, 0x0003e2000020d400ULL,
0x000000d44200720bULL, 0x000fce0003f5d000ULL, 0x00000008001f7306ULL, 0x000fe20000209400ULL,
0x0000010024347824ULL, 0x002fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000000800a87306ULL, 0x000fe20000205400ULL, 0x00000001c8c82812ULL, 0x000fce00078efcffULL,
0x0000000800ae7306ULL, 0x000ff0000020d400ULL, 0x0000002c00c77306ULL, 0x000ff00000209400ULL,
0x0000002c00bc7306ULL, 0x000ff00000205400ULL, 0x0000002c00087306ULL, 0x000ff0000020d400ULL,
0x00000035002c7306ULL, 0x000ff00000209400ULL, 0x0000003500977306ULL, 0x000e700000205400ULL,
0x0000003500467306ULL, 0x0004f0000020d400ULL, 0x0000004000907306ULL, 0x000fe20000209400ULL,
0x00000018ff357819ULL, 0x004fc40000011419ULL, 0x000000972c00720bULL, 0x002fca0003f3d000ULL,
0x0000004000ec7306ULL, 0x000e700000205400ULL, 0x00000040003e7306ULL, 0x000ea2000020d400ULL,
0x0000000146461812ULL, 0x008fe400078efcffULL, 0x000000d68f00720bULL, 0x000fc40003f3d000ULL,
0x000000464545723eULL, 0x000fc600000010ffULL, 0x0000003600d87306ULL, 0x000ff00000209400ULL,
0x0000003600eb7306ULL, 0x000ee20000205400ULL, 0x000000013f3f1812ULL, 0x000fe400078efcffULL,
0x000000ec9000720bULL, 0x002fc40003f3d000ULL, 0x0000003c3f3c723eULL, 0x000fc600000010ffULL,
0x0000003600df7306ULL, 0x000330000020d400ULL, 0x0000003700d97306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x002fe4000001141aULL, 0x000000013e3e1812ULL, 0x004fc400078efcffULL,
0x000000ebd800720bULL, 0x008fe40003f3d000ULL, 0x0000003d3e3d723eULL, 0x000fe200000010ffULL,
0x0000003700de7306ULL, 0x000e700000205400ULL, 0x0000003700c97306ULL, 0x0004e4000020d400ULL,
0x00000001dfdf1812ULL, 0x010fcc00078efcffULL, 0x0000003500987306ULL, 0x000fe20000209400ULL,
0x00000018ff377819ULL, 0x004fe4000001141bULL, 0x000000ded900720bULL, 0x002fca0003f3d000ULL,
0x0000003500ca7306ULL, 0x000ff00000205400ULL, 0x0000003500407306ULL, 0x0003e2000020d400ULL,
0x00000001c9c91812ULL, 0x008fce00078efcffULL, 0x0000003400757306ULL, 0x000fe20000209400ULL,
0x0000010025357824ULL, 0x002fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011435ULL,
0x00000034007a7306ULL, 0x000ff00000205400ULL, 0x0000003400c07306ULL, 0x0003f0000020d400ULL,
0x0000003600cb7306ULL, 0x000fe20000209400ULL, 0x000000106f347824ULL, 0x002fc400078e02d0ULL,
0x00000100276f7824ULL, 0x000fca00078e00ffULL, 0x0000003600cd7306ULL, 0x000fe20000205400ULL,
0x00000018ff6f7819ULL, 0x000fce000001146fULL, 0x0000003600c17306ULL, 0x000ff0000020d400ULL,
0x00000037000d7306ULL, 0x000ff00000209400ULL, 0x00000037007b7306ULL, 0x000ff00000205400ULL,
0x0000003700a77306ULL, 0x0003f0000020d400ULL, 0x0000002400837306ULL, 0x000fe20000009400ULL,
0x000000003434783bULL, 0x002e6e0000004200ULL, 0x0000002400737306ULL, 0x000eb00000005400ULL,
0x0000002400bf7306ULL, 0x000730000000d400ULL, 0x0000002500bd7306ULL, 0x000fe20000009400ULL,
0x0001000024247824ULL, 0x008fe200078e00ffULL, 0x000000738300720bULL, 0x004fc80003fdd000ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000002500a17306ULL, 0x000eae0000005400ULL,
0x00000001bfbf6812ULL, 0x010fe200078efcffULL, 0x0000002400f27306ULL, 0x000fe20000209400ULL,
0x000000929300720bULL, 0x000fce0003fdd000ULL, 0x0000002400f37306ULL, 0x000fe20000205400ULL,
0x000000a1bd00720bULL, 0x004fca0003f1d000ULL, 0x00000001baba6812ULL, 0x000fe400078efcffULL,
0x0000002400bb7306ULL, 0x0005e2000020d400ULL, 0x0000001d1c00720bULL, 0x000fe20003fdd000ULL,
0x00010000221d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x0000002500af7306ULL, 0x000722000000d400ULL, 0x0000010026247824ULL, 0x004fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000026002e7306ULL, 0x000fe20000009400ULL,
0x0001000025257824ULL, 0x008fe200078e00ffULL, 0x00000001b6b66812ULL, 0x000fc800078efcffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000002400e17306ULL, 0x000fe20000209400ULL,
0x00000001afaf0812ULL, 0x010fce00078efcffULL, 0x0000002400e27306ULL, 0x000ff00000205400ULL,
0x0000002400b57306ULL, 0x0003f0000020d400ULL, 0x0000002600967306ULL, 0x000ea20000005400ULL,
0x00000018ff247819ULL, 0x002fce0000011434ULL, 0x0000002600b27306ULL, 0x0002f0000000d400ULL,
0x0000002400ab7306ULL, 0x000fe20000209400ULL, 0x0001000026267824ULL, 0x002fe200078e00ffULL,
0x000000962e00720bULL, 0x004fc80003f9d000ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000002400ac7306ULL, 0x000fee0000205400ULL, 0x00000001b2b24812ULL, 0x008fe200078efcffULL,
0x00000024009f7306ULL, 0x0003e2000020d400ULL, 0x000000a81f00720bULL, 0x000fce0003f9d000ULL,
0x0000002800747306ULL, 0x000fe20000009400ULL, 0x0000010028247824ULL, 0x002fca00078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000002800a67306ULL, 0x000fe20000005400ULL,
0x00000001aeae4812ULL, 0x000fce00078efcffULL, 0x00000028008d7306ULL, 0x0003f0000000d400ULL,
0x0000002500e37306ULL, 0x000fe20000209400ULL, 0x0001000028287824ULL, 0x002fce00078e00ffULL,
0x0000002500e47306ULL, 0x000ff00000205400ULL, 0x0000002500b77306ULL, 0x0003f0000020d400ULL,
0x0000002600ad7306ULL, 0x000fe20000209400ULL, 0x00000018ff257819ULL, 0x002fce0000011435ULL,
0x0000002500a37306ULL, 0x000ff00000209400ULL, 0x0000002500d57306ULL, 0x000ff00000205400ULL,
0x00000025009c7306ULL, 0x0003f0000020d400ULL, 0x0000002600ed7306ULL, 0x000fe20000205400ULL,
0x00000018ff257819ULL, 0x002fce0000011428ULL, 0x0000002600b17306ULL, 0x0003f0000020d400ULL,
0x0000002500dd7306ULL, 0x000fe20000209400ULL, 0x00000018ff267819ULL, 0x002fce0000011436ULL,
0x0000002500e67306ULL, 0x000ff00000205400ULL, 0x0000002500857306ULL, 0x0003f0000020d400ULL,
0x0000002600a27306ULL, 0x000fe20000209400ULL, 0x000001002a257824ULL, 0x002fce00078e00ffULL,
0x0000002600a47306ULL, 0x000ff00000205400ULL, 0x00000026008c7306ULL, 0x0003f0000020d400ULL,
0x0000002400e77306ULL, 0x000fe20000209400ULL, 0x0000010029267824ULL, 0x002fca00078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000002400e87306ULL, 0x000ff00000205400ULL,
0x00000024008e7306ULL, 0x0003f0000020d400ULL, 0x0000002900287306ULL, 0x000fe20000009400ULL,
0x0001000029247824ULL, 0x002fca00078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000002900f47306ULL, 0x000ff00000005400ULL, 0x0000002900887306ULL, 0x0003f0000000d400ULL,
0x00000027000b7306ULL, 0x000fe20000009400ULL, 0x00000018ff297819ULL, 0x002fe20000011425ULL,
0x000001002b257824ULL, 0x000fca00078e00ffULL, 0x00000018fff87819ULL, 0x000fe20000011425ULL,
0x00000027002f7306ULL, 0x000e620000005400ULL, 0x0000000149257824ULL, 0x000fc800078e0276ULL,
0x0000001025257824ULL, 0x000fc600078e02d0ULL, 0x0000002700b37306ULL, 0x0004f0000000d400ULL,
0x0000006f00da7306ULL, 0x000fe20000209400ULL, 0x0001000027277824ULL, 0x004fe200078e00ffULL,
0x0000002f0b00720bULL, 0x002fe20003f7d000ULL, 0x00000100210b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000006f00db7306ULL, 0x000e6e0000205400ULL,
0x00000001b3b33812ULL, 0x008fe200078efcffULL, 0x0000002700e97306ULL, 0x000fe20000209400ULL,
0x0000009e9d00720bULL, 0x000fce0003f7d000ULL, 0x0000002700ea7306ULL, 0x000fe20000205400ULL,
0x000000dbda00720bULL, 0x002fca0003fdd000ULL, 0x0000000186863812ULL, 0x000fe400078efcffULL,
0x0000002700957306ULL, 0x0003f0000020d400ULL, 0x0000006f00b47306ULL, 0x000ea2000020d400ULL,
0x00000018ff277819ULL, 0x002fce0000011437ULL, 0x00000027009a7306ULL, 0x000ff00000209400ULL,
0x0000002700d37306ULL, 0x000fe20000205400ULL, 0x00000001b4b46812ULL, 0x004fe400078efcffULL,
0x000000edad00720bULL, 0x000fca0003fdd000ULL, 0x00000027008a7306ULL, 0x000ff0000020d400ULL,
0x0000002600817306ULL, 0x000fe20000209400ULL, 0x00000001b1b16812ULL, 0x000fe400078efcffULL,
0x000000eae900720bULL, 0x000fca0003fdd000ULL, 0x0000002600dc7306ULL, 0x000ff00000205400ULL,
0x0000002600897306ULL, 0x000fe2000020d400ULL, 0x0000000195956812ULL, 0x000fe400078efcffULL,
0x000000acab00720bULL, 0x000fc40003fdd000ULL, 0x00000095ae95723eULL, 0x000fc600000010ffULL,
0x00000024006f7306ULL, 0x000ff00000209400ULL, 0x0000002400c27306ULL, 0x000fe20000205400ULL,
0x000000019f9f6812ULL, 0x000fce00078efcffULL, 0x00000024007d7306ULL, 0x0003f0000020d400ULL,
0x0000002900807306ULL, 0x000fe20000209400ULL, 0x000000002524783bULL, 0x002e6e0000004200ULL,
0x00000029009b7306ULL, 0x000eb00000205400ULL, 0x00000029007f7306ULL, 0x000730000020d400ULL,
0x0000002a00ee7306ULL, 0x000fe20000009400ULL, 0x000100002a297824ULL, 0x008fe200078e00ffULL,
0x0000009b8000720bULL, 0x004fc80003f7d000ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002a00ef7306ULL, 0x000eae0000005400ULL, 0x000000017f7f3812ULL, 0x010fe200078efcffULL,
0x00000029006d7306ULL, 0x000ff00000209400ULL, 0x0000002900717306ULL, 0x000fe20000205400ULL,
0x000000efee00720bULL, 0x004fce0003f1d000ULL, 0x0000002900787306ULL, 0x0003f0000020d400ULL,
0x0000002a007e7306ULL, 0x0004e2000000d400ULL, 0x00000018ff297819ULL, 0x002fce0000011425ULL,
0x0000002900c47306ULL, 0x000fe20000209400ULL, 0x000100002b2a7824ULL, 0x004fca00078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000002900c57306ULL, 0x000fe20000205400ULL,
0x000000017e7e0812ULL, 0x008fe400078efcffULL, 0x000000716d00720bULL, 0x000fe40003f1d000ULL,
0x0000007e7f7e723eULL, 0x000fc600000010ffULL, 0x0000002900697306ULL, 0x0003f0000020d400ULL,
0x0000002b00c37306ULL, 0x000fe20000009400ULL, 0x0000010020297824ULL, 0x002fe200078e00ffULL,
0x0000000178780812ULL, 0x000fc800078efcffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002b00d07306ULL, 0x000ff00000005400ULL, 0x0000002b00777306ULL, 0x0003f0000000d400ULL,
0x0000002a00ce7306ULL, 0x000fe20000209400ULL, 0x00000018ff2b7819ULL, 0x002fce0000011424ULL,
0x0000002a00cf7306ULL, 0x000ff00000205400ULL, 0x0000002a00737306ULL, 0x0003f0000020d400ULL,
0x0000002900977306ULL, 0x000fe20000209400ULL, 0x00000018ff2a7819ULL, 0x002fce0000011426ULL,
0x0000002900967306ULL, 0x000ff00000205400ULL, 0x00000029002e7306ULL, 0x0003f0000020d400ULL,
0x0000002000d17306ULL, 0x000fe20000009400ULL, 0x0001000020297824ULL, 0x002fce00078e00ffULL,
0x0000002000d67306ULL, 0x000ff00000005400ULL, 0x00000020002f7306ULL, 0x0003f0000000d400ULL,
0x0000002b00837306ULL, 0x000fe20000209400ULL, 0x0000010018207824ULL, 0x002fca00078e00ffULL,
0x00000018ffd77819ULL, 0x000fe40000011420ULL, 0x0000002b00847306ULL, 0x000ff00000205400ULL,
0x0000002b006e7306ULL, 0x0003f0000020d400ULL, 0x0000002a00917306ULL, 0x000fe20000209400ULL,
0x00000018ff2b7819ULL, 0x002fce0000011427ULL, 0x0000002a00bd7306ULL, 0x000ff00000205400ULL,
0x0000002a004b7306ULL, 0x0003f0000020d400ULL, 0x0000002b00a17306ULL, 0x000fe20000209400ULL,
0x00000018ff2a7819ULL, 0x002fce000001140bULL, 0x0000002b00a07306ULL, 0x000ff00000205400ULL,
0x0000002b002c7306ULL, 0x0003f0000020d400ULL, 0x0000002a008f7306ULL, 0x000fe20000209400ULL,
0x00000018ff2b7819ULL, 0x002fce0000011429ULL, 0x0000002a00907306ULL, 0x000ff00000205400ULL,
0x0000002a000b7306ULL, 0x0003f0000020d400ULL, 0x000000d700207306ULL, 0x000fe20000209400ULL,
0x00000100192a7824ULL, 0x002fca00078e00ffULL, 0x00000018ffeb7819ULL, 0x000fe4000001142aULL,
0x000000d700297306ULL, 0x000e700000205400ULL, 0x000000eb002a7306ULL, 0x000ff00000209400ULL,
0x000000eb00d97306ULL, 0x000ea20000205400ULL, 0x000000292000720bULL, 0x002fce0003fbd000ULL,
0x0000002b00fb7306ULL, 0x000ff00000209400ULL, 0x0000002b00fa7306ULL, 0x000fe20000205400ULL,
0x000000d92a00720bULL, 0x004fe20003f3d000ULL, 0x00010000182a7824ULL, 0x000fcc00078e00ffULL,
0x0000002b000c7306ULL, 0x000ff0000020d400ULL, 0x00000018002b7306ULL, 0x000ff00000009400ULL,
0x0000001800d47306ULL, 0x000e700000005400ULL, 0x000000d700d87306ULL, 0x000eb0000020d400ULL,
0x0000001900207306ULL, 0x000fe20000009400ULL, 0x000000d42b00720bULL, 0x002fc40003f5d000ULL,
0x00000018ffd47819ULL, 0x000fca000001142aULL, 0x0000001900297306ULL, 0x000e620000005400ULL,
0x00000001d8d85812ULL, 0x004fce00078efcffULL, 0x000000eb00427306ULL, 0x0004e2000020d400ULL,
0x000000292000720bULL, 0x002fce0003fbd000ULL, 0x000000d4002a7306ULL, 0x000fe20000209400ULL,
0x0001000019207824ULL, 0x000fca00078e00ffULL, 0x00000018ffeb7819ULL, 0x004fe40000011420ULL,
0x000000d400297306ULL, 0x000e620000205400ULL, 0x0000000142421812ULL, 0x008fce00078efcffULL,
0x0000001800d97306ULL, 0x000eb0000000d400ULL, 0x000000d400d77306ULL, 0x000ee2000020d400ULL,
0x000000292a00720bULL, 0x002fe20003f3d000ULL, 0x000001001b297824ULL, 0x000fcc00078e00ffULL,
0x000000eb00187306ULL, 0x000fe20000209400ULL, 0x00000001d9d92812ULL, 0x004fe400078efcffULL,
0x000000cc8b00720bULL, 0x000fca0003f5d000ULL, 0x000000eb002b7306ULL, 0x000e620000205400ULL,
0x00000001d7d71812ULL, 0x008fce00078efcffULL, 0x0000001900de7306ULL, 0x0004e2000000d400ULL,
0x0000000141412812ULL, 0x000fe400078efcffULL, 0x0000002b1800720bULL, 0x002fe20003f3d000ULL,
0x000001001a197824ULL, 0x004fc800078e00ffULL, 0x0000001a00187306ULL, 0x000fe20000009400ULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000001dede5812ULL, 0x008fca00078efcffULL,
0x0000001900207306ULL, 0x000fe20000209400ULL, 0x000000ca9800720bULL, 0x000fe40003fbd000ULL,
0x00000018ffca7819ULL, 0x000fca0000011429ULL, 0x0000001900f97306ULL, 0x000e6c0000205400ULL,
0x0000000140405812ULL, 0x000fe400078efcffULL, 0x0000001a002b7306ULL, 0x000eb00000005400ULL,
0x000000eb008b7306ULL, 0x000ee2000020d400ULL, 0x000000f92000720bULL, 0x002fce0003f5d000ULL,
0x000000ca00297306ULL, 0x000fe20000209400ULL, 0x0000002b1800720bULL, 0x004fe20003fbd000ULL,
0x000100001a187824ULL, 0x000fcc00078e00ffULL, 0x000000ca002a7306ULL, 0x000e620000205400ULL,
0x000000018b8b1812ULL, 0x008fce00078efcffULL, 0x0000001900987306ULL, 0x000eb0000020d400ULL,
0x0000001a00d47306ULL, 0x000722000000d400ULL, 0x0000002a2900720bULL, 0x002fe40003f3d000ULL,
0x00000018ff297819ULL, 0x000fca0000011418ULL, 0x0000001b00207306ULL, 0x000fe20000009400ULL,
0x0000000198982812ULL, 0x004fe200078efcffULL, 0x000100001b1a7824ULL, 0x008fe200078e00ffULL,
0x000000cdcb00720bULL, 0x000fca0003f5d000ULL, 0x0000001b002b7306ULL, 0x000e620000005400ULL,
0x00000001d4d45812ULL, 0x010fce00078efcffULL, 0x0000001b00cd7306ULL, 0x000ea2000000d400ULL,
0x00000001c1c12812ULL, 0x000fe400078efcffULL, 0x0000007a7500720bULL, 0x000fca0003f5d000ULL,
0x0000002900187306ULL, 0x000fe20000209400ULL, 0x0000002b2000720bULL, 0x002fe40003fbd000ULL,
0x00000018ff207819ULL, 0x000fca000001141aULL, 0x0000002900197306ULL, 0x000e620000205400ULL,
0x00000001c0c02812ULL, 0x000fe400078efcffULL, 0x000000f42800720bULL, 0x000fe20003f5d000ULL,
0x0000001006287824ULL, 0x000fe400078e02a5ULL, 0x00000001cdcd5812ULL, 0x004fe400078efcffULL,
0x000000ca00cc7306ULL, 0x000eb0000020d400ULL, 0x0000002900ca7306ULL, 0x000722000020d400ULL,
0x000000191800720bULL, 0x002fe20003fbd000ULL, 0x0001000021187824ULL, 0x000fe200078e00ffULL,
0x0000000188882812ULL, 0x000fc800078efcffULL, 0x00000018ff1b7819ULL, 0x000fe20000011418ULL,
0x00000020001a7306ULL, 0x000fe20000209400ULL, 0x000000002828783bULL, 0x008e620000004200ULL,
0x00000001cccc1812ULL, 0x004fe400078efcffULL, 0x0000007b0d00720bULL, 0x000fc80003f3d000ULL,
0x0000002000197306ULL, 0x000ea20000205400ULL, 0x00000001caca5812ULL, 0x010fce00078efcffULL,
0x0000002000cb7306ULL, 0x000722000020d400ULL, 0x00000001a7a71812ULL, 0x000fe400078efcffULL,
0x000000a67400720bULL, 0x000fe40003f3d000ULL, 0x000000191a00720bULL, 0x004fc60003fbd000ULL,
0x0000007000f17306ULL, 0x000fe20000209400ULL, 0x00000100231a7824ULL, 0x000fe400078e00ffULL,
0x0000010022197824ULL, 0x000fc600078e00ffULL, 0x00000018ff207819ULL, 0x008fe4000001141aULL,
0x0000007000f07306ULL, 0x000ea20000205400ULL, 0x000000018d8d1812ULL, 0x000fe400078efcffULL,
0x000000c26f00720bULL, 0x000fe40003f3d000ULL, 0x00000001cbcb5812ULL, 0x010fe400078efcffULL,
0x000000f3f200720bULL, 0x000fe20003fbd000ULL, 0x0000007000be7306ULL, 0x000ee2000020d400ULL,
0x00000018ffa87819ULL, 0x002fc4000001142aULL, 0x00000018ffee7819ULL, 0x000fe40000011429ULL,
0x00000002ffc27819ULL, 0x000fc60000011612ULL, 0x0000002000757306ULL, 0x000fe20000209400ULL,
0x000000017d7d1812ULL, 0x000fe400078efcffULL, 0x0000003a3b00720bULL, 0x000fe40003f3d000ULL,
0x00000001bbbb5812ULL, 0x000fe400078efcffULL, 0x000000f0f100720bULL, 0x004fe20003fbd000ULL,
0x0000002000747306ULL, 0x000ff00000205400ULL, 0x00000020001a7306ULL, 0x0003e2000020d400ULL,
0x0000000179791812ULL, 0x000fc600078efcffULL, 0x00000001bebe5812ULL, 0x008fe400078efcffULL,
0x000000e4e300720bULL, 0x000fe40003fbd000ULL, 0x0000002300a67306ULL, 0x000fe20000009400ULL,
0x0001000023207824ULL, 0x002fe200078e00ffULL, 0x000000787978723eULL, 0x000fcc00000010ffULL,
0x0000002300a57306ULL, 0x000fe60000005400ULL, 0x00000001b7b75812ULL, 0x000fe400078efcffULL,
0x000000e2e100720bULL, 0x000fc60003fbd000ULL, 0x00000023001c7306ULL, 0x0003f0000000d400ULL,
0x000000f800707306ULL, 0x000fe20000209400ULL, 0x00000018ff237819ULL, 0x002fe40000011428ULL,
0x00000001b5b55812ULL, 0x000fc400078efcffULL, 0x000000aaa900720bULL, 0x000fc60003fbd000ULL,
0x000000f800997306ULL, 0x000e700000205400ULL, 0x000000f800767306ULL, 0x000ea4000020d400ULL,
0x00000001b0b05812ULL, 0x000fcc00078efcffULL, 0x0000001b00f97306ULL, 0x000fe20000209400ULL,
0x000000997000720bULL, 0x002fce0003f7d000ULL, 0x0000001b00f87306ULL, 0x000fec0000205400ULL,
0x0000000176763812ULL, 0x004fe400078efcffULL, 0x0000001b00187306ULL, 0x000ff0000020d400ULL,
0x0000002200937306ULL, 0x000ff00000009400ULL, 0x0000002200927306ULL, 0x000ff00000005400ULL,
0x00000022001b7306ULL, 0x000ff0000000d400ULL, 0x0000001d00f17306ULL, 0x000ff00000209400ULL,
0x0000001d00f07306ULL, 0x000ff00000205400ULL, 0x0000001d00227306ULL, 0x000ff0000020d400ULL,
0x0000002300e47306ULL, 0x000ff00000209400ULL, 0x0000002300e37306ULL, 0x000ff00000205400ULL,
0x00000023001d7306ULL, 0x0003f0000020d400ULL, 0x0000002100eb7306ULL, 0x000fe20000009400ULL,
0x0000010034237824ULL, 0x002fca00078e00ffULL, 0x00000018ffa97819ULL, 0x000fe40000011423ULL,
0x0000002100ec7306ULL, 0x000e700000005400ULL, 0x00000021000d7306ULL, 0x0004f0000000d400ULL,
0x000000a900237306ULL, 0x000fe20000209400ULL, 0x00000018ff217819ULL, 0x004fc40000011419ULL,
0x000000eceb00720bULL, 0x002fca0003f5d000ULL, 0x00000021007b7306ULL, 0x000ff00000209400ULL,
0x00000021007a7306ULL, 0x000fe20000205400ULL, 0x000000010d0d2812ULL, 0x008fe400078efcffULL,
0x000000d2f500720bULL, 0x000fca0003f5d000ULL, 0x0000002100197306ULL, 0x0003f0000020d400ULL,
0x000000a9009e7306ULL, 0x000ea20000205400ULL, 0x00000018ff217819ULL, 0x002fe40000011420ULL,
0x0000000109092812ULL, 0x000fca00078efcffULL, 0x0000002100f27306ULL, 0x000ff00000209400ULL,
0x0000002100ef7306ULL, 0x000fe20000205400ULL, 0x0000009e2300720bULL, 0x004fce0003fbd000ULL,
0x0000002100207306ULL, 0x000ff0000020d400ULL, 0x000000a800db7306ULL, 0x000ff00000209400ULL,
0x000000a800da7306ULL, 0x000ff00000205400ULL, 0x000000a800217306ULL, 0x0003f0000020d400ULL,
0x000000a900ad7306ULL, 0x000ea2000020d400ULL, 0x0000010035a87824ULL, 0x002fca00078e00ffULL,
0x00000018ffe97819ULL, 0x000fe400000114a8ULL, 0x00000034009d7306ULL, 0x000ff00000009400ULL,
0x000000e900a87306ULL, 0x000fe20000209400ULL, 0x00000001adad5812ULL, 0x004fce00078efcffULL,
0x000000e900237306ULL, 0x000e700000205400ULL, 0x00000034009e7306ULL, 0x000eb00000005400ULL,
0x0000003400ab7306ULL, 0x000ee2000000d400ULL, 0x00000023a800720bULL, 0x002fe20003f9d000ULL,
0x0001000034237824ULL, 0x000fe200078e00ffULL, 0x0000009e9d00720bULL, 0x004fca0003fbd000ULL,
0x0000003500a87306ULL, 0x000ff00000009400ULL, 0x00000035009d7306ULL, 0x000e620000005400ULL,
0x00000001abab5812ULL, 0x008fce00078efcffULL, 0x000000e900aa7306ULL, 0x0004e2000020d400ULL,
0x0000009da800720bULL, 0x002fe20003fbd000ULL, 0x00010000359d7824ULL, 0x000fe200078e00ffULL,
0x00000018ffe97819ULL, 0x004fca0000011423ULL, 0x0000003500ac7306ULL, 0x000e62000000d400ULL,
0x00000018ffea7819ULL, 0x000fe4000001149dULL, 0x00000001aaaa4812ULL, 0x008fca00078efcffULL,
0x000000e900237306ULL, 0x000ff00000209400ULL, 0x000000e900347306ULL, 0x000ea20000205400ULL,
0x00000001acac5812ULL, 0x002fe400078efcffULL, 0x000000d5a300720bULL, 0x000fca0003fbd000ULL,
0x000000e900a97306ULL, 0x000e70000020d400ULL, 0x000000ea009d7306ULL, 0x000fe20000209400ULL,
0x000000342300720bULL, 0x004fe20003f9d000ULL, 0x0000010036237824ULL, 0x000fe200078e00ffULL,
0x000000019c9c5812ULL, 0x000fc800078efcffULL, 0x00000018ffed7819ULL, 0x000fe20000011423ULL,
0x000000ea009e7306ULL, 0x000eac0000205400ULL, 0x00000001a9a94812ULL, 0x002fe400078efcffULL,
0x000000ea00a87306ULL, 0x0002e2000020d400ULL, 0x000000a4a200720bULL, 0x000fce0003f9d000ULL,
0x000000ed00237306ULL, 0x000fe20000209400ULL, 0x0000009e9d00720bULL, 0x004fe20003fdd000ULL,
0x00000100379d7824ULL, 0x000fc800078e00ffULL, 0x000000018c8c4812ULL, 0x000fe400078efcffULL,
0x000000ed00347306ULL, 0x000ea20000205400ULL, 0x00000018ffea7819ULL, 0x002fe4000001149dULL,
0x000000e8e700720bULL, 0x000fc60003f9d000ULL, 0x00000001a8a86812ULL, 0x008fe400078efcffULL,
0x0000003600357306ULL, 0x000ff00000009400ULL, 0x0000003600a27306ULL, 0x000e620000005400ULL,
0x000000342300720bULL, 0x004fe20003fdd000ULL, 0x0001000036347824ULL, 0x000fe200078e00ffULL,
0x000000018e8e4812ULL, 0x000fc400078efcffULL, 0x000000d0c300720bULL, 0x000fe40003f9d000ULL,
0x00000018ffe97819ULL, 0x000fe20000011434ULL, 0x000000ed00a37306ULL, 0x000ea2000020d400ULL,
0x0000008d8e8e723eULL, 0x000fce00000010ffULL, 0x000000ea009e7306ULL, 0x000fe20000209400ULL,
0x000000a23500720bULL, 0x002fe40003fbd000ULL, 0x0000000177774812ULL, 0x000fe400078efcffULL,
0x000000cfce00720bULL, 0x000fe40003f9d000ULL, 0x00000077767f723eULL, 0x000fe200000010ffULL,
0x000000ea00d57306ULL, 0x000e620000205400ULL, 0x00000001a3a36812ULL, 0x004fce00078efcffULL,
0x0000003600a47306ULL, 0x000ea4000000d400ULL, 0x0000000173734812ULL, 0x000fcc00078efcffULL,
0x0000003700237306ULL, 0x000fe20000009400ULL, 0x000000d59e00720bULL, 0x002fce0003fdd000ULL,
0x0000003700a27306ULL, 0x000e620000005400ULL, 0x00000001a4a45812ULL, 0x004fce00078efcffULL,
0x000000ea009d7306ULL, 0x000eb0000020d400ULL, 0x000000e900347306ULL, 0x000fe20000209400ULL,
0x000000a22300720bULL, 0x002fe20003fbd000ULL, 0x0001000037237824ULL, 0x000fca00078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011423ULL, 0x000000e900357306ULL, 0x000e620000205400ULL,
0x000000019d9d6812ULL, 0x004fce00078efcffULL, 0x0000003700a27306ULL, 0x0004f0000000d400ULL,
0x000000e9009e7306ULL, 0x000f22000020d400ULL, 0x000000353400720bULL, 0x002fe20003fdd000ULL,
0x0000010025357824ULL, 0x000fe200078e00ffULL, 0x00000018ff377819ULL, 0x004fc8000001142bULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003600237306ULL, 0x000fe20000209400ULL,
0x00000001a2a25812ULL, 0x008fe400078efcffULL, 0x000000d39a00720bULL, 0x000fca0003fbd000ULL,
0x0000003600347306ULL, 0x000e620000205400ULL, 0x000000019e9e6812ULL, 0x010fc800078efcffULL,
0x0000009e8c8c723eULL, 0x000fc600000010ffULL, 0x00000036009a7306ULL, 0x000ea2000020d400ULL,
0x000000018a8a5812ULL, 0x000fe400078efcffULL, 0x000000dc8100720bULL, 0x000fe40003fbd000ULL,
0x000000342300720bULL, 0x002fc60003fdd000ULL, 0x0000003500e77306ULL, 0x000fe20000209400ULL,
0x0000010024347824ULL, 0x000fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000035006f7306ULL, 0x000fe2000020d400ULL, 0x0000000189895812ULL, 0x000fe400078efcffULL,
0x000000d6d100720bULL, 0x000fe40003fbd000ULL, 0x000000019a9a6812ULL, 0x004fe400078efcffULL,
0x000000e6dd00720bULL, 0x000fe20003fdd000ULL, 0x000000ee00e27306ULL, 0x000fe20000209400ULL,
0x0000009a8a8d723eULL, 0x000fce00000010ffULL, 0x0000003500e67306ULL, 0x0003e20000205400ULL,
0x000000012f2f5812ULL, 0x000fe400078efcffULL, 0x000000bcc700720bULL, 0x000fe40003fbd000ULL,
0x0000000185856812ULL, 0x000fe400078efcffULL, 0x000000436b00720bULL, 0x000fe20003fdd000ULL,
0x000000ee00e17306ULL, 0x000fe20000205400ULL, 0x0000000712357812ULL, 0x002fc800078ec0ffULL,
0x0000000835d67812ULL, 0x100fe400078ef812ULL, 0x00000004ff357819ULL, 0x000fe20000011612ULL,
0x000000ee001f7306ULL, 0x000fe2000020d400ULL, 0x0000000108085812ULL, 0x000fe400078efcffULL,
0x0000000735357812ULL, 0x000fe400078e78d6ULL, 0x000000017c7c6812ULL, 0x000fe400078efcffULL,
0x000000383900720bULL, 0x000fe20003fdd000ULL, 0x00000008d6357824ULL, 0x000fe200078e0235ULL,
0x0000003400e97306ULL, 0x000fe60000209400ULL, 0x0000001035437824ULL, 0x000fc400078e00ffULL,
0x0000010026357824ULL, 0x000fe400078e00ffULL, 0x0000080094387824ULL, 0x000fe200078e0243ULL,
0x0000003400ea7306ULL, 0x000e640000205400ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000000172726812ULL, 0x000fe200078efcffULL, 0x011000003838783bULL, 0x000fe20000000200ULL,
0x000000848300720bULL, 0x000fe40003fdd000ULL, 0x0000003400817306ULL, 0x0004e2000020d400ULL,
0x000000737279723eULL, 0x000fce00000010ffULL, 0x0000002400ed7306ULL, 0x000fe20000009400ULL,
0x0001000024347824ULL, 0x004fe200078e00ffULL, 0x000000eae900720bULL, 0x002fe40003f3d000ULL,
0x000000016e6e6812ULL, 0x000fe400078efcffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000002400ee7306ULL, 0x000e6e0000005400ULL, 0x0000000181811812ULL, 0x008fe200078efcffULL,
0x0000002400807306ULL, 0x0004e2000000d400ULL, 0x000000e6e700720bULL, 0x000fce0003f3d000ULL,
0x0000002500e87306ULL, 0x000fe20000009400ULL, 0x0001000025247824ULL, 0x004fe200078e00ffULL,
0x000000eeed00720bULL, 0x002fc80003f1d000ULL, 0x000000016f6f1812ULL, 0x000fe400078efcffULL,
0x0000002500eb7306ULL, 0x000e6e0000005400ULL, 0x0000000180800812ULL, 0x008fe200078efcffULL,
0x0000002500707306ULL, 0x0004e6000000d400ULL, 0x000000808180723eULL, 0x000fca00000010ffULL,
0x0000003700d57306ULL, 0x000fe20000209400ULL, 0x00000018ff257819ULL, 0x004fe40000011424ULL,
0x00000017ff24723eULL, 0x000fe400000010ffULL, 0x000000ebe800720bULL, 0x002fc60003f9d000ULL,
0x0000003700d37306ULL, 0x000ff00000205400ULL, 0x0000003700237306ULL, 0x000fe4000020d400ULL,
0x0000000170704812ULL, 0x008fc800078efcffULL, 0x000000706f81723eULL, 0x000fe400000010ffULL,
0x0000003400367306ULL, 0x000ff00000209400ULL, 0x0000003400377306ULL, 0x000e700000205400ULL,
0x0000003400717306ULL, 0x0004f0000020d400ULL, 0x0000002500dc7306ULL, 0x000fe20000209400ULL,
0x00000008c2347810ULL, 0x004fc40007ffe0ffULL, 0x000000373600720bULL, 0x002fca0003f3d000ULL,
0x0000002500dd7306ULL, 0x000e700000205400ULL, 0x00000025006b7306ULL, 0x000522000020d400ULL,
0x0000000171711812ULL, 0x008fe400078efcffULL, 0x000000c5c400720bULL, 0x000fc40003f3d000ULL,
0x000000716e6e723eULL, 0x000fc600000010ffULL, 0x0000003500d07306ULL, 0x000fe20000209400ULL,
0x0000541024257816ULL, 0x004fe40000000024ULL, 0x0000991068247816ULL, 0x000fe400000000ffULL,
0x000000dddc00720bULL, 0x002fe20003f9d000ULL, 0x00001fc2259b7589ULL, 0x000e6200000e0000ULL,
0x000000ff2400720cULL, 0x000fe20003f65270ULL, 0x0000003500d17306ULL, 0x000ea20000205400ULL,
0x0000010027247824ULL, 0x000fe200078e00ffULL, 0x00001f3425997589ULL, 0x00076200000e0000ULL,
0x0000000169691812ULL, 0x000fc400078efcffULL, 0x000000bd9100720bULL, 0x000fe40003f3d000ULL,
0x00000018ffec7819ULL, 0x000fe20000011424ULL, 0x00000035006d7306ULL, 0x000f62000020d400ULL,
0x0000006c8224723eULL, 0x000fe400000010ffULL, 0x000000016b6b4812ULL, 0x010fe400078efcffULL,
0x0000006a8725723eULL, 0x008fe400000010ffULL, 0x0000006b696f723eULL, 0x000fe200000010ffULL,
0x0000002600347306ULL, 0x000fe20000009400ULL, 0x000000d1d000720bULL, 0x004fc40003fdd000ULL,
0x000000014b4b1812ULL, 0x000fe400078efcffULL, 0x000000a0a100720bULL, 0x000fe20003f3d000ULL,
0x0000009b3838b231ULL, 0x082fe200003400ffULL, 0x000001002ba07824ULL, 0x000fe200078e00ffULL,
0x0000002600357306ULL, 0x000e620000005400ULL, 0x0000009b3a3ab231ULL, 0x000fe400003400ffULL,
0x000000993939b231ULL, 0x0a0fe200003400ffULL, 0x00000018ffa07819ULL, 0x000fe200000114a0ULL,
0x000000993b3bb231ULL, 0x000fe200003400ffULL, 0x000000016d6d6812ULL, 0x000fc400078efcffULL,
0x0000002700ce7306ULL, 0x000fe40000009400ULL, 0x000000012c2c1812ULL, 0x000fe400078efcffULL,
0x000000443844723cULL, 0x040fe20000041850ULL, 0x000000908f00720bULL, 0x000fe40003f3d000ULL,
0x00000088898f723eULL, 0x000fe200000010ffULL, 0x0000002700cf7306ULL, 0x000ea20000005400ULL,
0x000000353400720bULL, 0x002fe40003f1d000ULL, 0x000000dfe034723eULL, 0x000fe200000010ffULL,
0x0000003c383c723cULL, 0x000fe20000041854ULL, 0x000000c9c835723eULL, 0x000fc400000010ffULL,
0x0000008b4051723eULL, 0x000fe200000010ffULL, 0x00000027006a7306ULL, 0x0002e2000000d400ULL,
0x000000d49840723eULL, 0x000fe400000010ffULL, 0x000000010b0b1812ULL, 0x000fe200078efcffULL,
0x000000343858723cULL, 0x000fe20000041858ULL, 0x000000f8f900720bULL, 0x000fc60003f3d000ULL,
0x00000026006c7306ULL, 0x000962000000d400ULL, 0x000000cfce00720bULL, 0x004fe40003f9d000ULL,
0x0001000027347824ULL, 0x000fe200078e00ffULL, 0x0000000212277811ULL, 0x002fe200078fe0ffULL,
0x00000024384c723cULL, 0x000fe6000004184cULL, 0x0000000727357812ULL, 0x000fe200078e78d6ULL,
0x0001000026267824ULL, 0x010fe200078e00ffULL, 0x000000de4227723eULL, 0x000fe200000010ffULL,
0x000000ec00c27306ULL, 0x000fe20000209400ULL, 0x00000018ff527819ULL, 0x000fe20000011434ULL,
0x00000008d6357824ULL, 0x000fe200078e0235ULL, 0x00000018ff507819ULL, 0x000fc40000011426ULL,
0x000000d9d826723eULL, 0x000fe200000010ffULL, 0x0000001035427824ULL, 0x000fe200078e00ffULL,
0x000000016a6a4812ULL, 0x008fe200078efcffULL, 0x0000005200d97306ULL, 0x000fe20000209400ULL,
0x0000000118181812ULL, 0x000fe200078efcffULL, 0x0000080094347824ULL, 0x000fe200078e0242ULL,
0x000000747500720bULL, 0x000fe20003f3d000ULL, 0x00000026385c723cULL, 0x000fe2000004185cULL,
0x000000016c6c0812ULL, 0x020fc600078efcffULL, 0x011000003434783bULL, 0x000e620000000200ULL,
0x0000005200d87306ULL, 0x000ea20000205400ULL, 0x0000006c6d6c723eULL, 0x000fe400000010ffULL,
0x0000000412277811ULL, 0x000fc800078fe0ffULL, 0x0000000727277812ULL, 0x000fe200078e78d6ULL,
0x0000005000c87306ULL, 0x000fe20000209400ULL, 0x000000011a1a1812ULL, 0x000fe400078efcffULL,
0x000000eff200720bULL, 0x000fca0003f3d000ULL, 0x0000005000c97306ULL, 0x000ee20000205400ULL,
0x000000d8d900720bULL, 0x004fce0003f9d000ULL, 0x0000005000567306ULL, 0x0005e2000020d400ULL,
0x0000000120201812ULL, 0x000fce00078efcffULL, 0x0000005200577306ULL, 0x000962000020d400ULL,
0x000000d74150723eULL, 0x004fe400000010ffULL, 0x0000000612417811ULL, 0x000fe400078fe0ffULL,
0x000000c9c800720bULL, 0x008fe20003f1d000ULL, 0x0000009b3434b231ULL, 0x082fe400003400ffULL,
0x000000503864723cULL, 0x000fe20000041864ULL, 0x0000009b3636b231ULL, 0x000fe200003400ffULL,
0x0000010028527824ULL, 0x010fe200078e00ffULL, 0x000000993535b231ULL, 0x080fe200003400ffULL,
0x000000ec00c37306ULL, 0x000e620000205400ULL, 0x000000993737b231ULL, 0x000fc400003400ffULL,
0x0000000741517812ULL, 0x000fe400078e78d6ULL, 0x000000cdcc41723eULL, 0x000fe200000010ffULL,
0x00000008d6cc7824ULL, 0x040fe200078e0227ULL, 0x000000cac150723eULL, 0x000fe200000010ffULL,
0x00000008d6d67824ULL, 0x000fe200078e0251ULL, 0x000000cba751723eULL, 0x000fe200000010ffULL,
0x000000ec00687306ULL, 0x000ea2000020d400ULL, 0x00000018ffc17819ULL, 0x000fe20000011452ULL,
0x000000403860723cULL, 0x000fe20000041860ULL, 0x0000000157574812ULL, 0x020fc400078efcffULL,
0x000000969700720bULL, 0x000fe40003f9d000ULL, 0x000000c3c200720bULL, 0x002fe20003fdd000ULL,
0x0000002800827306ULL, 0x000fe20000009400ULL, 0x000000bfc040723eULL, 0x000fe200000010ffULL,
0x000000503850723cULL, 0x000fe20000041830ULL, 0x000000afbe41723eULL, 0x000fe400000010ffULL,
0x0000000156560812ULL, 0x000fe400078efcffULL, 0x000000572c57723eULL, 0x000fe200000010ffULL,
0x0000002800877306ULL, 0x000e620000005400ULL, 0x0000010029307824ULL, 0x000fe200078e00ffULL,
0x00000040344c723cULL, 0x000fe2000004184cULL, 0x000000bbba32723eULL, 0x000fc400000010ffULL,
0x000000b7b633723eULL, 0x000fe400000010ffULL, 0x00000018ffb67819ULL, 0x000fe20000011430ULL,
0x0000002800257306ULL, 0x0007e2000000d400ULL, 0x00000010cc417824ULL, 0x000fe200078e00ffULL,
0x000000b2b530723eULL, 0x000fe200000010ffULL, 0x00000010d6407824ULL, 0x000fe200078e00ffULL,
0x000000b3b431723eULL, 0x000fe200000010ffULL, 0x0000080094387824ULL, 0x000fe200078e0241ULL,
0x000000323444723cULL, 0x040fe20000041844ULL, 0x000000012e2e4812ULL, 0x000fe200078efcffULL,
0x000000c100a77306ULL, 0x000fe20000209400ULL, 0x000000fafb00720bULL, 0x000fe20003f9d000ULL,
0x0001000028287824ULL, 0x008fe200078e00ffULL, 0x011000003838783bULL, 0x000ee20000000200ULL,
0x0000000168686812ULL, 0x004fe200078efcffULL, 0x0000080094327824ULL, 0x000fe200078e0240ULL,
0x00000030343c723cULL, 0x000fe2000004183cULL, 0x000000b1b094723eULL, 0x000fe200000010ffULL,
0x000000c100af7306ULL, 0x000ea20000205400ULL, 0x00000018ffb07819ULL, 0x000fc40000011428ULL,
0x011000003230783bULL, 0x000f220000000200ULL, 0x000000a4a328723eULL, 0x000fe400000010ffULL,
0x000000010c0c4812ULL, 0x000fe200078efcffULL, 0x000000943458723cULL, 0x040fe20000041858ULL,
0x0000007a7b00720bULL, 0x000fe20003f9d000ULL, 0x0000002900837306ULL, 0x000fe20000009400ULL,
0x000000929300720bULL, 0x000fe40003fdd000ULL, 0x000000abad92723eULL, 0x000fe400000010ffULL,
0x000000a89c95723eULL, 0x000fe200000010ffULL, 0x00010000299c7824ULL, 0x000fe200078e00ffULL,
0x000000acaa93723eULL, 0x000fe200000010ffULL, 0x0000002900847306ULL, 0x000fe20000005400ULL,
0x000000a99f94723eULL, 0x000fe200000010ffULL, 0x0000008c3450723cULL, 0x000fe20000041850ULL,
0x000001002a9f7824ULL, 0x000fe200078e00ffULL, 0x0000000119194812ULL, 0x000fc400078efcffULL,
0x000000f0f100720bULL, 0x000fe40003f9d000ULL, 0x0000002900247306ULL, 0x000be2000000d400ULL,
0x00000018ff9c7819ULL, 0x000fe2000001149cULL, 0x00000092345c723cULL, 0x040fe2000004185cULL,
0x00000018ff9f7819ULL, 0x000fe4000001149fULL, 0x000000878200720bULL, 0x002fe40003fbd000ULL,
0x0000006a686d723eULL, 0x000fe200000010ffULL, 0x000000c100917306ULL, 0x000e62000020d400ULL,
0x000000a29d29723eULL, 0x020fe200000010ffULL, 0x0000009b3838b231ULL, 0x088fe200003400ffULL,
0x000000943464723cULL, 0x040fe20000041864ULL, 0x0000009b3a3ab231ULL, 0x000fe200003400ffULL,
0x0000000122224812ULL, 0x000fe200078efcffULL, 0x000000993939b231ULL, 0x080fe200003400ffULL,
0x000000afa700720bULL, 0x004fe20003f9d000ULL, 0x000000993b3bb231ULL, 0x000fe200003400ffULL,
0x000000b600b27306ULL, 0x000fe20000209400ULL, 0x0000009b3030b231ULL, 0x090fe200003400ffULL,
0x000000283460723cULL, 0x000fe20000041860ULL, 0x0000009b3232b231ULL, 0x000fe200003400ffULL,
0x000100002a937824ULL, 0x000fe200078e00ffULL, 0x000000993131b231ULL, 0x080fe200003400ffULL,
0x0000002f2e2e723eULL, 0x000fe200000010ffULL, 0x000000993333b231ULL, 0x000fe200003400ffULL,
0x000000b600b37306ULL, 0x000ea20000205400ULL, 0x000000858628723eULL, 0x000fe200000010ffULL,
0x000000783858723cULL, 0x000fe20000041858ULL, 0x0000007d7c29723eULL, 0x000fc400000010ffULL,
0x000000b8b900720bULL, 0x000fe40003f7d000ULL, 0x0000000191914812ULL, 0x002fe200078efcffULL,
0x000000b000aa7306ULL, 0x000fe20000209400ULL, 0x000000564b56723eULL, 0x000fe200000010ffULL,
0x000000283844723cULL, 0x040fe20000041844ULL, 0x0000000d0b2f723eULL, 0x000fe400000010ffULL,
0x00000018080d723eULL, 0x000fe400000010ffULL, 0x00000018ff937819ULL, 0x000fe20000011493ULL,
0x000000b000927306ULL, 0x000e620000205400ULL, 0x000000b3b200720bULL, 0x004fe20003f3d000ULL,
0x0000008e384c723cULL, 0x000fe2000004184cULL, 0x0000000107073812ULL, 0x000fc400078efcffULL,
0x000000f6f700720bULL, 0x000fe40003f7d000ULL, 0x0000000c070c723eULL, 0x000fe200000010ffULL,
0x0000002a00547306ULL, 0x000fe20000009400ULL, 0x000000a5a600720bULL, 0x000fe20003f1d000ULL,
0x0000007e383c723cULL, 0x040fe2000004183cULL, 0x000000011b1b6812ULL, 0x000fe400078efcffULL,
0x0000000125255812ULL, 0x000fe400078efcffULL, 0x000000848300720bULL, 0x000fe20003fdd000ULL,
0x0000002a00557306ULL, 0x000ea20000005400ULL, 0x00000092aa00720bULL, 0x002fe20003f9d000ULL,
0x00000080385c723cULL, 0x000fe2000004185cULL, 0x000000010a0a3812ULL, 0x000fc400078efcffULL,
0x000000e3e400720bULL, 0x000fe40003f7d000ULL, 0x000000e1e200720bULL, 0x000fe20003fbd000ULL,
0x0000002a00267306ULL, 0x000e62000000d400ULL, 0x000000220908723eULL, 0x000fe200000010ffULL,
0x0000006e3864723cULL, 0x040fe20000041864ULL, 0x000000200a09723eULL, 0x000fe400000010ffULL,
0x000000011c1c0812ULL, 0x000fe400078efcffULL, 0x0000000124246812ULL, 0x000fe200078efcffULL,
0x000000b600ae7306ULL, 0x000ee2000020d400ULL, 0x000000555400720bULL, 0x004fe20003f1d000ULL,
0x0000006c3860723cULL, 0x000fe20000041860ULL, 0x000000011d1d3812ULL, 0x000fc400078efcffULL,
0x000000011f1f5812ULL, 0x000fe400078efcffULL, 0x000000dadb00720bULL, 0x000fe20003fdd000ULL,
0x000000b0002a7306ULL, 0x000ea2000020d400ULL, 0x000000d3d500720bULL, 0x000fe20003f7d000ULL,
0x000000563838723cULL, 0x000fe20000041850ULL, 0x0000001b1954723eULL, 0x000fe400000010ffULL,
0x0000001c1a55723eULL, 0x000fe400000010ffULL, 0x0000000126260812ULL, 0x002fe200078efcffULL,
0x0000009c00907306ULL, 0x000fe20000209400ULL, 0x00000001aeae1812ULL, 0x008fe200078efcffULL,
0x0000000c3050723cULL, 0x000fe20000041844ULL, 0x00000025910a723eULL, 0x000fc400000010ffULL,
0x0000000121216812ULL, 0x000fe400078efcffULL, 0x0000000123233812ULL, 0x000fe200078efcffULL,
0x0000009c00897306ULL, 0x000e620000205400ULL, 0x000000012a2a4812ULL, 0x004fe200078efcffULL,
0x000000083058723cULL, 0x000fe20000041858ULL, 0x00000024ae0b723eULL, 0x000fe400000010ffULL,
0x0000002a1d2a723eULL, 0x000fc600000010ffULL, 0x0000009f00357306ULL, 0x000fe40000209400ULL,
0x0000002e304c723cULL, 0x040fec000004184cULL, 0x0000009f00287306ULL, 0x000ea20000205400ULL,
0x000000899000720bULL, 0x002fe20003f3d000ULL, 0x000000543054723cULL, 0x040fec000004183cULL,
0x0000002b008b7306ULL, 0x000fe40000009400ULL, 0x0000000a305c723cULL, 0x000fec000004185cULL,
0x0000002b00987306ULL, 0x000e620000005400ULL, 0x000000283500720bULL, 0x004fce0003f9d000ULL,
0x0000002b00277306ULL, 0x0004f0000000d400ULL, 0x0000009c00347306ULL, 0x000f22000020d400ULL,
0x000100002b2b7824ULL, 0x004fe200078e00ffULL, 0x000000988b00720bULL, 0x002fc80003f5d000ULL,
0x00000018ff077819ULL, 0x000fe4000001142bULL, 0x0000009f00297306ULL, 0x000e6e000020d400ULL,
0x0000000127272812ULL, 0x008fe200078efcffULL, 0x000000a000367306ULL, 0x000fe20000209400ULL,
0x0000000134341812ULL, 0x010fc800078efcffULL, 0x000000341f2b723eULL, 0x000fc600000010ffULL,
0x000000a000697306ULL, 0x000ea20000205400ULL, 0x0000000129294812ULL, 0x002fc600078efcffULL,
0x0000002a3064723cULL, 0x000fe20000041864ULL, 0x000000262926723eULL, 0x000fc600000010ffULL,
0x00000093002c7306ULL, 0x000ff00000209400ULL, 0x0000009300377306ULL, 0x000e620000205400ULL,
0x000000693600720bULL, 0x004fce0003f3d000ULL, 0x0000000700187306ULL, 0x000ff00000209400ULL,
0x00000007000d7306ULL, 0x000ea20000205400ULL, 0x000000372c00720bULL, 0x002fce0003fbd000ULL,
0x000000a000687306ULL, 0x000e70000020d400ULL, 0x00000093000c7306ULL, 0x000ee2000020d400ULL,
0x0000000d1800720bULL, 0x004fce0003f9d000ULL, 0x0000000700087306ULL, 0x000522000020d400ULL,
0x0000000168681812ULL, 0x002fc800078efcffULL, 0x000000276827723eULL, 0x000fe400000010ffULL,
0x000000010c0c5812ULL, 0x008fe400078efcffULL, 0x0001b6102d077811ULL, 0x004fe400078e20ffULL,
0x0000000c210c723eULL, 0x000fe200000010ffULL, 0x000000263060723cULL, 0x000fe20000041860ULL,
0x0000000108084812ULL, 0x010fc800078efcffULL, 0x00000008230d723eULL, 0x000fe400000010ffULL,
0x0001b6682d087811ULL, 0x000fca00078e18ffULL, 0x0000000c3030723cULL, 0x000fe20000041838ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000008ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000410097824ULL, 0x000fe200078e022dULL, 0x000000ff03ff7812ULL, 0x000fe2000780c0ffULL,
0x0000000007ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff02ff7812ULL, 0x000fe4000784c0ffULL,
0x0000008009027811ULL, 0x000fe400078e30ffULL, 0x00000001ff1d7807ULL, 0x000fe40000000000ULL,
0x0000000f0200720cULL, 0x000fc40003f06070ULL, 0x000000010000780cULL, 0x040fe40003f25270ULL,
0x00000001ff097807ULL, 0x000fe40001000000ULL, 0x000000031d037207ULL, 0x000fe40004800000ULL,
0x0000000100007812ULL, 0x000fe400078e0cffULL, 0x0000761009027816ULL, 0x000fc60000000002ULL,
0x00004eb000000947ULL, 0x000fea0003800000ULL, 0x01b66c0004077984ULL, 0x004ea20000000800ULL,
0x8000000009007824ULL, 0x000fca00078e00ffULL, 0x8000000007ff7812ULL, 0x004fe20007804800ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x01b66c0004077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x004fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000009097824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000020000735dULL, 0x008fe40003800000ULL, 0x0000040008027984ULL, 0x000ea40000000800ULL,
0x8000000002ff7812ULL, 0x004fc40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000030010027a10ULL, 0x000fe20007ffe0ffULL,
0x00000000000c7919ULL, 0x000ea20000002600ULL, 0x00000003ff2c7819ULL, 0x000fe20000011612ULL,
0x00000010123e7824ULL, 0x000fe200078e00ffULL, 0x0000000102007810ULL, 0x000fe20007ffe0ffULL,
0x00000000000a7919ULL, 0x000ee20000002700ULL, 0x00000001ff397819ULL, 0x000fe2000001160eULL,
0x0000000113197824ULL, 0x000fe200078e022cULL, 0x000000110000720cULL, 0x000fe20003f06070ULL,
0x0000000816007824ULL, 0x000fe200078e00ffULL, 0x000000082c2e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000819257824ULL, 0x040fe200078e00ffULL, 0x0000001219047212ULL, 0x000fe200078e3cffULL,
0x00000010393d7824ULL, 0x000fe200078e00ffULL, 0x0000000800007812ULL, 0x000fe200078ec0ffULL,
0x0000000113097824ULL, 0x000fe200078e022eULL, 0xfffffff825257812ULL, 0x000fe200078ee204ULL,
0x00000080ff457424ULL, 0x000fe200078e00ffULL, 0x000000102c3b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000809297824ULL, 0x000fe200078e00ffULL, 0x0000000800047812ULL, 0x000fe200078e3cffULL,
0x00000000000573c2ULL, 0x00096200000e0000ULL, 0x0001b6483d0d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001130b7824ULL, 0x000fe200078e023bULL, 0x000000142c347810ULL, 0x000fc40007ffe0ffULL,
0x000000042c3c7810ULL, 0x040fe20007ffe0ffULL, 0x000000010d2a7824ULL, 0x000fe200078e0204ULL,
0x0000001209047212ULL, 0x080fe200078e3cffULL, 0x0000000113217824ULL, 0x000fe200078e0234ULL,
0x000000120b007212ULL, 0x0d0fe200078e3cffULL, 0x000000080b2d7824ULL, 0x000fe200078e00ffULL,
0x0000000c2c367810ULL, 0x000fe20007ffe0ffULL, 0x0000000113237824ULL, 0x000fe200078e023cULL,
0xfffffff829297812ULL, 0x000fe200078ee204ULL, 0x00000008212f7824ULL, 0x040fe200078e00ffULL,
0x0000001221047212ULL, 0x080fe200078e3cffULL, 0x0000000823087824ULL, 0x002fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee200ULL, 0x0000200016007824ULL, 0x000fe200078e00ffULL,
0x0000001223077212ULL, 0x080fe200078e3cffULL, 0x00000001131f7824ULL, 0x000fe200078e0236ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee204ULL, 0x0000000402047824ULL, 0x000fe200078e0239ULL,
0xfffffff808277812ULL, 0x000fe200078ee207ULL, 0x000000081f087824ULL, 0x040fe200078e00ffULL,
0x0000200000027812ULL, 0x000fe200078ec0ffULL, 0x0000004004007824ULL, 0x000fe200078e00ffULL,
0x000000121f077212ULL, 0x000fe200078e3cffULL, 0x000000020a0a7824ULL, 0x008fe200078e00ffULL,
0x000000182c387810ULL, 0x000fe20007ffe0ffULL, 0x000000000d0473c2ULL, 0x00036200000e0000ULL,
0x000058000c0c7a10ULL, 0x004fe20007ffe0ffULL, 0x0000400039027824ULL, 0x000fe200078e0202ULL,
0x0000001c2c3a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001131b7824ULL, 0x000fe200078e0238ULL,
0xfffffff8082b7812ULL, 0x000fe200078ee207ULL, 0x000058000a0a7a24ULL, 0x000fe200078e020cULL,
0x000000000f077217ULL, 0x000fe20007800000ULL, 0x00000001130d7824ULL, 0x002fe200078e023aULL,
0x000000121b087212ULL, 0x0c0fe200078e3cffULL, 0x000000081b357824ULL, 0x000fe200078e00ffULL,
0x000000703e3f7812ULL, 0x000fe200078ec0ffULL, 0x0000000107077824ULL, 0x100fe200078e0a00ULL,
0x000000120d047212ULL, 0x000fe200078e3cffULL, 0x000062000a007a24ULL, 0x000fe200078e0200ULL,
0xfffffff835357812ULL, 0x000fe200078ee208ULL, 0x000000080d377824ULL, 0x000fe200078e00ffULL,
0x0001300002027810ULL, 0x000fe20007ffe0ffULL, 0x00000001230a7824ULL, 0x000fc400078e0200ULL,
0x0000000119087824ULL, 0x000fe200078e0200ULL, 0xfffffff837377812ULL, 0x000fe200078ee204ULL,
0x000000010b047824ULL, 0x100fe400078e0200ULL, 0x00000001090c7824ULL, 0x000fe200078e0200ULL,
0x0000000504047290ULL, 0x020fe2000fffe03fULL, 0x00005e000a0a7625ULL, 0x000fc800078e0045ULL,
0x00005e0008087625ULL, 0x000fe200078e0045ULL, 0x0000003f0a207210ULL, 0x000fc60007f3e0ffULL,
0x000000011f187824ULL, 0x100fe400078e0200ULL, 0x00000001211c7824ULL, 0x100fe400078e0200ULL,
0x000000011b267824ULL, 0x100fe400078e0200ULL, 0x000000010d287824ULL, 0x000fe200078e0200ULL,
0x0000004007007807ULL, 0x000fe20000000000ULL, 0x00005e0018187625ULL, 0x000fe200078e0045ULL,
0x0000003f081a7210ULL, 0x000fe40007f1e0ffULL, 0x0000000013007217ULL, 0x000fe20007800000ULL,
0x00005e000c0c7625ULL, 0x000fc800078e0045ULL, 0x000000ffff217224ULL, 0x000fe200008e060bULL,
0x0000003f18247210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200000e0609ULL,
0x0000003f0c227210ULL, 0x000fe20007f1e0ffULL, 0x0000000100007824ULL, 0x000fe400078e0a13ULL,
0x00005e001c0a7625ULL, 0x000fc600078e0045ULL, 0x000000002c00720cULL, 0x080fe20003f86070ULL,
0x00005e0004087625ULL, 0x000fe200078e0045ULL, 0x000000003c00720cULL, 0x080fe40003fa6070ULL,
0x000000002e00720cULL, 0x080fe20003f66070ULL, 0x00000010251f7824ULL, 0x000fe200078e0202ULL,
0x000000003600720cULL, 0x000fe20003f46070ULL, 0x000000ffff257224ULL, 0x000fe200008e0619ULL,
0x0000003f0a0a7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff237224ULL, 0x000fe200000e060dULL,
0x0000003f08087210ULL, 0x000fe20007f1e0ffULL, 0x00005e0028187625ULL, 0x000fc400078e0045ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a1f7faeULL, 0x0003e2000e101c46ULL,
0x000000003800720cULL, 0x000fe20003f86070ULL, 0x00005e00260c7625ULL, 0x000fc800078e0045ULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000003f18187210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x0000003f0c0c7210ULL, 0x000fe20007f1e0ffULL,
0x0000001027277824ULL, 0x100fe400078e0202ULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x000000003b00720cULL, 0x080fe20003f26070ULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x000000003400720cULL, 0x080fe20003f06070ULL, 0x0000000020277faeULL, 0x0003e2000e901c46ULL,
0x000000003a00720cULL, 0x000fe20003fa6070ULL, 0x0000001029297824ULL, 0x000fc400078e0202ULL,
0x000000102b2b7824ULL, 0x100fe400078e0202ULL, 0x000000102d2d7824ULL, 0x100fe200078e0202ULL,
0x0000000022297faeULL, 0x0003e2000d901c46ULL, 0x000000102f2f7824ULL, 0x100fe400078e0202ULL,
0x0000001035357824ULL, 0x100fe200078e0202ULL, 0x00000000242b7faeULL, 0x0003e2000d101c46ULL,
0x0000001037377824ULL, 0x000fc600078e0202ULL, 0x00000000082d7faeULL, 0x0003e8000c901c46ULL,
0x000000000a2f7faeULL, 0x0003e8000c101c46ULL, 0x000000000c357faeULL, 0x0003e8000e101c46ULL,
0x0000000018377faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000004002a077984ULL, 0x0004e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01b62c003d097984ULL, 0x002e620000000800ULL, 0x0000ffff03037812ULL, 0x000fc400078ec0ffULL,
0x0000ffff1e007812ULL, 0x000fe400078ec0ffULL, 0x0000888003027816ULL, 0x000fe400000000ffULL,
0x0000888000037816ULL, 0x000fc600000000ffULL, 0x000000ffff007224ULL, 0x000fe400078e0002ULL,
0x8000000003027824ULL, 0x000fe400078e00ffULL, 0x8000000000007824ULL, 0x000fca00078e00ffULL,
0x8000000007ff7812ULL, 0x008fe40007804800ULL, 0x8000000009ff7812ULL, 0x002fe20007824802ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0001b62839027811ULL, 0x000fe200078e20ffULL, 0x8000000003037824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x008fe40003800000ULL,
0x0000040002047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fc40007824803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000400e007824ULL, 0x000fe200078e00ffULL, 0x000000703e077812ULL, 0x000fe200078ec0ffULL,
0x00000001ff687424ULL, 0x000fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fe40000011612ULL,
0xffffff8000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c02037812ULL, 0x000fe400078ec0ffULL,
0x0000010007007810ULL, 0x000fca0007ffe000ULL, 0x0000000103007824ULL, 0x000fca00078e0200ULL,
0x01b0000000037984ULL, 0x000e680000000800ULL, 0x01b2000000027984ULL, 0x0007220000000800ULL,
0x000000140300720bULL, 0x002fda0003f3d000ULL, 0x0000000000047806ULL, 0x000fc800008e0100ULL,
0x0000ffff04087812ULL, 0x000fda000782c0ffULL, 0x000003b000009947ULL, 0x000fea0003800000ULL,
0x000000140300720bULL, 0x018fe40003f54000ULL, 0x0000000314097209ULL, 0x000fe40007810000ULL,
0x000000020e077811ULL, 0x000fe400078ff8ffULL, 0x00000002ff0d7819ULL, 0x000fe20000011612ULL,
0x8000000914007221ULL, 0x100fe20000010000ULL, 0x0000000e0700720cULL, 0x000fe20003f25270ULL,
0x000000ffff147224ULL, 0x000fe200078e0009ULL, 0x000000080d197810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b00047820ULL, 0x000fc40000410000ULL, 0x0000000000007806ULL, 0x000fe400010e0100ULL,
0x00000004000a7308ULL, 0x000e640000000800ULL, 0x0000ffff00077812ULL, 0x000fc800078e3cffULL,
0x0000000708ff7212ULL, 0x000fe4000784c0ffULL, 0x000000703e0b9812ULL, 0x000fe400078ec0ffULL,
0x00000001ff079819ULL, 0x000fe40000011612ULL, 0x00000001ff687807ULL, 0x000fe20001000000ULL,
0x000000800e089824ULL, 0x000fe200078e020bULL, 0x0000000c07079812ULL, 0x000fe200078ec0ffULL,
0x00001f0d0a007589ULL, 0x002e6200000e0000ULL, 0x0000000a15157220ULL, 0x000fc60000410000ULL,
0x8000000903042221ULL, 0x000fe40000010000ULL, 0x0000000107089824ULL, 0x000fe200078e0208ULL,
0x00001f190a037589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b04042820ULL, 0x000fc60000410000ULL,
0x01b4000908009388ULL, 0x0009e20000000800ULL, 0x0000000400172308ULL, 0x000f620000000800ULL,
0x000000004c4c7220ULL, 0x082fe40000410000ULL, 0x000000004d4d7220ULL, 0x080fe40000410000ULL,
0x0000000050507220ULL, 0x080fe40000410000ULL, 0x0000000051517220ULL, 0x080fe40000410000ULL,
0x0000000054547220ULL, 0x000fc40000410000ULL, 0x0000000055557220ULL, 0x080fe40000410000ULL,
0x0000000058587220ULL, 0x080fe40000410000ULL, 0x0000000059597220ULL, 0x080fe40000410000ULL,
0x000000005c5c7220ULL, 0x080fe40000410000ULL, 0x000000005d5d7220ULL, 0x080fe40000410000ULL,
0x0000000064647220ULL, 0x000fc40000410000ULL, 0x0000000065657220ULL, 0x080fe40000410000ULL,
0x0000000060607220ULL, 0x080fe40000410000ULL, 0x0000000061617220ULL, 0x080fe40000410000ULL,
0x0000000030307220ULL, 0x080fe40000410000ULL, 0x0000000031317220ULL, 0x000fe40000410000ULL,
0x000000034e4e7220ULL, 0x008fc40000410000ULL, 0x000000034f4f7220ULL, 0x080fe40000410000ULL,
0x0000000352527220ULL, 0x080fe40000410000ULL, 0x0000000353537220ULL, 0x080fe40000410000ULL,
0x0000000356567220ULL, 0x080fe40000410000ULL, 0x0000000357577220ULL, 0x080fe40000410000ULL,
0x000000035a5a7220ULL, 0x000fc40000410000ULL, 0x000000035b5b7220ULL, 0x080fe40000410000ULL,
0x000000035e5e7220ULL, 0x080fe40000410000ULL, 0x000000035f5f7220ULL, 0x080fe40000410000ULL,
0x0000000366667220ULL, 0x080fe40000410000ULL, 0x0000000367677220ULL, 0x080fe40000410000ULL,
0x0000000362627220ULL, 0x000fc40000410000ULL, 0x0000000363637220ULL, 0x080fe40000410000ULL,
0x0000000332327220ULL, 0x080fe40000410000ULL, 0x0000000333337220ULL, 0x000fe40000410000ULL,
0x0000000217022220ULL, 0x020fc80000410000ULL, 0x0000001502157221ULL, 0x018fe20000010000ULL,
0x0000017000000947ULL, 0x000fea0003800000ULL, 0x0000000816007824ULL, 0x040fe200078e00ffULL,
0x000000011600780cULL, 0x000fe20003f05270ULL, 0x000000080e027824ULL, 0x000fc600078e00ffULL,
0x0000000800007812ULL, 0x000fe400078e0cffULL, 0xfffffff002037812ULL, 0x000fe400078ec0ffULL,
0x000000e51d027207ULL, 0x000fc60004000000ULL, 0x0000000100007824ULL, 0x000fe200078e0203ULL,
0x0000ffff02027812ULL, 0x000fc800078ec0ffULL, 0x01b64c0000037984ULL, 0x000e620000000800ULL,
0x0000888002047816ULL, 0x000fca00000000ffULL, 0x8000000004027824ULL, 0x000fca00078e00ffULL,
0x8000000003ff7812ULL, 0x002fe20007804802ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000004037824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x008fe40003800000ULL,
0x000004002a027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007804803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000001005247824ULL, 0x100fe200078e0248ULL, 0x0000000812287812ULL, 0x000fe200078ec0ffULL,
0x0000001006447824ULL, 0x000fe200078e0248ULL, 0x0000991068687816ULL, 0x000fe400000000ffULL,
0x00000007287a7812ULL, 0x000fe200078ef812ULL, 0x000000002424783bULL, 0x000e680000004200ULL,
0x000000004444783bULL, 0x000fe20000004200ULL, 0x000000087a297824ULL, 0x000fc800078e024aULL,
0x0000001029347824ULL, 0x000fcc00078e0248ULL, 0x000000003434783bULL, 0x000ee20000004200ULL,
0x00000018ff007819ULL, 0x002fe20000011424ULL, 0x0000002700767306ULL, 0x000fe20000009400ULL,
0x00000018ff047819ULL, 0x000fe40000011426ULL, 0x00000018ff077819ULL, 0x000fe40000011427ULL,
0x00000018ff027819ULL, 0x000fc60000011425ULL, 0x0000000000ab7306ULL, 0x000fe20000209400ULL,
0x00000018ff3a7819ULL, 0x008fce0000011436ULL, 0x0000000000aa7306ULL, 0x000fe20000205400ULL,
0x00000018ff3b7819ULL, 0x000fce0000011437ULL, 0x00000000000a7306ULL, 0x0003f0000020d400ULL,
0x00000027009e7306ULL, 0x000fe20000005400ULL, 0x00000018ff007819ULL, 0x002fce0000011444ULL,
0x0000000000e67306ULL, 0x000ff00000209400ULL, 0x0000000000e47306ULL, 0x000ff00000205400ULL,
0x0000000000207306ULL, 0x0003f0000020d400ULL, 0x0000002700037306ULL, 0x000fe2000000d400ULL,
0x0000010024007824ULL, 0x002fca00078e00ffULL, 0x00000018ff007819ULL, 0x000fe40000011400ULL,
0x0000000400d27306ULL, 0x000ff00000209400ULL, 0x0000000000b07306ULL, 0x000ff00000209400ULL,
0x0000000000af7306ULL, 0x000ff00000205400ULL, 0x00000000000c7306ULL, 0x0003f0000020d400ULL,
0x0000000400d17306ULL, 0x000fe20000205400ULL, 0x0000010026007824ULL, 0x002fca00078e00ffULL,
0x00000018ff1b7819ULL, 0x000fe20000011400ULL, 0x0000010027007824ULL, 0x040fe200078e00ffULL,
0x0000000400237306ULL, 0x0003e2000020d400ULL, 0x0001000027277824ULL, 0x000fc600078e00ffULL,
0x00000018ff227819ULL, 0x000fe40000011400ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000001b00897306ULL, 0x000fe20000209400ULL, 0x00000018ff047819ULL, 0x002fce0000011446ULL,
0x0000000400db7306ULL, 0x000ff00000209400ULL, 0x0000000400d77306ULL, 0x000ff00000205400ULL,
0x00000004001f7306ULL, 0x000ff0000020d400ULL, 0x0000001b00887306ULL, 0x000ff00000205400ULL,
0x0000001b00047306ULL, 0x000ff0000020d400ULL, 0x0000002700f17306ULL, 0x000ff00000209400ULL,
0x0000002700f07306ULL, 0x000ff00000205400ULL, 0x00000027001b7306ULL, 0x0003f0000020d400ULL,
0x0000000200ca7306ULL, 0x000fe20000209400ULL, 0x000000087a277824ULL, 0x002fc800078e0249ULL,
0x00000010272c7824ULL, 0x000fc600078e0248ULL, 0x0000000200c77306ULL, 0x000fe60000205400ULL,
0x000000002c2c783bULL, 0x000e6a0000004200ULL, 0x0000000200067306ULL, 0x0007f0000020d400ULL,
0x00000024003e7306ULL, 0x000fe20000009400ULL, 0x00000018ff027819ULL, 0x008fce0000011445ULL,
0x00000024003f7306ULL, 0x000ef00000005400ULL, 0x00000024000d7306ULL, 0x000970000000d400ULL,
0x0000000200e37306ULL, 0x000fe20000209400ULL, 0x0001000024247824ULL, 0x010fe200078e00ffULL,
0x0000003f3e00720bULL, 0x008fc80003f3d000ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000000200e27306ULL, 0x000fee0000205400ULL, 0x000000010d0d1812ULL, 0x020fe200078efcffULL,
0x0000000200197306ULL, 0x0007e2000020d400ULL, 0x000000aaab00720bULL, 0x000fce0003f3d000ULL,
0x00000025003c7306ULL, 0x000fe20000009400ULL, 0x0000010025027824ULL, 0x008fca00078e00ffULL,
0x00000018ff027819ULL, 0x000fe40000011402ULL, 0x00000025003d7306ULL, 0x000ee20000005400ULL,
0x000000010a0a1812ULL, 0x000fce00078efcffULL, 0x0000002500097306ULL, 0x000970000000d400ULL,
0x0000000700d47306ULL, 0x000fe20000209400ULL, 0x0001000025257824ULL, 0x010fe200078e00ffULL,
0x0000003d3c00720bULL, 0x008fc80003f1d000ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000000700d37306ULL, 0x000fee0000205400ULL, 0x0000000109090812ULL, 0x020fe200078efcffULL,
0x00000007001c7306ULL, 0x0007e2000020d400ULL, 0x000000c7ca00720bULL, 0x000fce0003f1d000ULL,
0x0000002400e97306ULL, 0x000fe20000209400ULL, 0x00000018ff077819ULL, 0x008fca0000011447ULL,
0x0000000106060812ULL, 0x000fe400078efcffULL, 0x0000002400e77306ULL, 0x000ff00000205400ULL,
0x00000024000b7306ULL, 0x0007f0000020d400ULL, 0x00000026006d7306ULL, 0x000fe20000009400ULL,
0x0000010044247824ULL, 0x008fce00078e00ffULL, 0x00000026006e7306ULL, 0x000ff00000005400ULL,
0x0000002600057306ULL, 0x0007f0000000d400ULL, 0x0000000700d67306ULL, 0x000fe20000209400ULL,
0x0001000026267824ULL, 0x008fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000000700d57306ULL, 0x000ff00000205400ULL, 0x0000000700187306ULL, 0x000ff0000020d400ULL,
0x0000002500eb7306ULL, 0x000ff00000209400ULL, 0x0000002500ea7306ULL, 0x000ef00000205400ULL,
0x0000002500077306ULL, 0x000970000020d400ULL, 0x0000004500a87306ULL, 0x000fe20000009400ULL,
0x00000018ff257819ULL, 0x010fe20000011424ULL, 0x0000010045247824ULL, 0x000fe200078e00ffULL,
0x000000eaeb00720bULL, 0x008fca0003f3d000ULL, 0x0000004500a67306ULL, 0x000ff00000005400ULL,
0x00000045001a7306ULL, 0x0007e2000000d400ULL, 0x0000000107071812ULL, 0x020fe400078efcffULL,
0x000000888900720bULL, 0x000fca0003f3d000ULL, 0x0000002600ef7306ULL, 0x000fe20000209400ULL,
0x0001000045457824ULL, 0x008fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011445ULL,
0x0000002600ec7306ULL, 0x000fe20000205400ULL, 0x0000000104041812ULL, 0x000fce00078efcffULL,
0x0000002600007306ULL, 0x0007f0000020d400ULL, 0x0000000200a97306ULL, 0x000fe20000209400ULL,
0x00000018ff267819ULL, 0x008fce0000011424ULL, 0x0000000200a77306ULL, 0x000ff00000205400ULL,
0x0000000200087306ULL, 0x000ff0000020d400ULL, 0x00000022008b7306ULL, 0x000ff00000209400ULL,
0x00000022008a7306ULL, 0x000ef00000205400ULL, 0x0000002200027306ULL, 0x000f30000020d400ULL,
0x00000025002b7306ULL, 0x000fe20000209400ULL, 0x0000008a8b00720bULL, 0x008fce0003f1d000ULL,
0x00000025002a7306ULL, 0x004fec0000205400ULL, 0x0000000102020812ULL, 0x010fe400078efcffULL,
0x0000002500227306ULL, 0x0005f0000020d400ULL, 0x0000002600c17306ULL, 0x000fe20000209400ULL,
0x0000010046257824ULL, 0x004fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011425ULL,
0x0000002600c07306ULL, 0x000ff00000205400ULL, 0x0000002600247306ULL, 0x000ff0000020d400ULL,
0x0000003800f37306ULL, 0x000ff00000209400ULL, 0x0000003800f27306ULL, 0x000ff00000205400ULL,
0x0000003800267306ULL, 0x0005f0000020d400ULL, 0x0000004400867306ULL, 0x000fe20000009400ULL,
0x00000018ff387819ULL, 0x004fce0000011434ULL, 0x0000003800837306ULL, 0x000ff00000209400ULL,
0x0000003800807306ULL, 0x000eb00000205400ULL, 0x00000038009d7306ULL, 0x0002f0000020d400ULL,
0x0000004400907306ULL, 0x000fe20000005400ULL, 0x00000018ff387819ULL, 0x002fc4000001142cULL,
0x000000808300720bULL, 0x004fca0003f7d000ULL, 0x0000004400217306ULL, 0x0003f0000000d400ULL,
0x0000003900277306ULL, 0x000fe20000209400ULL, 0x0001000044447824ULL, 0x002fe200078e00ffULL,
0x000000019d9d3812ULL, 0x008fc800078efcffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000003900257306ULL, 0x000ff00000205400ULL, 0x0000003900287306ULL, 0x0003f0000020d400ULL,
0x0000003800a17306ULL, 0x000fe20000209400ULL, 0x00000018ff397819ULL, 0x002fce0000011435ULL,
0x00000038009a7306ULL, 0x000ff00000205400ULL, 0x0000003800967306ULL, 0x0003f0000020d400ULL,
0x00000034008d7306ULL, 0x000fe20000009400ULL, 0x0000010034387824ULL, 0x002fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000034008e7306ULL, 0x000e700000005400ULL,
0x0000003400457306ULL, 0x0004f0000000d400ULL, 0x0000003900737306ULL, 0x000fe20000209400ULL,
0x0001000034347824ULL, 0x004fe200078e00ffULL, 0x0000008e8d00720bULL, 0x002fcc0003f9d000ULL,
0x0000003900747306ULL, 0x000fee0000205400ULL, 0x0000000145454812ULL, 0x008fe200078efcffULL,
0x00000039009c7306ULL, 0x0003f0000020d400ULL, 0x0000004400f87306ULL, 0x000fe20000209400ULL,
0x00000018ff397819ULL, 0x002fce000001142dULL, 0x0000003900987306ULL, 0x000ff00000209400ULL,
0x0000003900997306ULL, 0x000ff00000205400ULL, 0x0000003900977306ULL, 0x0003f0000020d400ULL,
0x0000004400f57306ULL, 0x000fe20000205400ULL, 0x00000018ff397819ULL, 0x002fe20000011434ULL,
0x0000010035347824ULL, 0x000fcc00078e00ffULL, 0x0000004400297306ULL, 0x000ff0000020d400ULL,
0x00000035008c7306ULL, 0x000ff00000009400ULL, 0x0000003500a57306ULL, 0x000e700000005400ULL,
0x0000003500447306ULL, 0x0004f0000000d400ULL, 0x0000003800847306ULL, 0x000fe20000209400ULL,
0x0001000035357824ULL, 0x004fe200078e00ffULL, 0x000000a58c00720bULL, 0x002fc80003f5d000ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003800857306ULL, 0x000e6e0000205400ULL,
0x0000000144442812ULL, 0x008fe200078efcffULL, 0x00000038006a7306ULL, 0x0004e2000020d400ULL,
0x000000747300720bULL, 0x000fce0003f5d000ULL, 0x0000003500f77306ULL, 0x000fe20000209400ULL,
0x0000010036387824ULL, 0x004fe200078e00ffULL, 0x000000858400720bULL, 0x002fc80003fdd000ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000035007f7306ULL, 0x000e620000205400ULL,
0x000000019c9c2812ULL, 0x000fcc00078efcffULL, 0x000000016a6a6812ULL, 0x008fe200078efcffULL,
0x00000035009f7306ULL, 0x0004f0000020d400ULL, 0x0000003800ee7306ULL, 0x000fe20000209400ULL,
0x000001002c357824ULL, 0x004fe200078e00ffULL, 0x0000007ff700720bULL, 0x002fc80003f7d000ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003800f67306ULL, 0x000e6e0000205400ULL,
0x000000019f9f3812ULL, 0x008fe200078efcffULL, 0x0000003800e17306ULL, 0x0004f0000020d400ULL,
0x0000002d00707306ULL, 0x000fe20000009400ULL, 0x000001002d387824ULL, 0x004fe200078e00ffULL,
0x000000f6ee00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000002d00757306ULL, 0x000e6e0000005400ULL, 0x00000001e1e13812ULL, 0x008fe200078efcffULL,
0x0000002d00b27306ULL, 0x0004f0000000d400ULL, 0x0000003600827306ULL, 0x000fe20000009400ULL,
0x000100002d2d7824ULL, 0x004fe200078e00ffULL, 0x000000757000720bULL, 0x002fcc0003f7d000ULL,
0x00000036009b7306ULL, 0x000e6e0000005400ULL, 0x00000001b2b23812ULL, 0x008fe200078efcffULL,
0x0000003600df7306ULL, 0x0004f0000000d400ULL, 0x0000003500cd7306ULL, 0x000fe20000209400ULL,
0x0001000036367824ULL, 0x004fe200078e00ffULL, 0x0000009b8200720bULL, 0x002fc80003fbd000ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000003500ce7306ULL, 0x000fee0000205400ULL,
0x00000001dfdf5812ULL, 0x008fe200078efcffULL, 0x0000003500da7306ULL, 0x0003f0000020d400ULL,
0x00000039007e7306ULL, 0x000fe20000209400ULL, 0x00000018ff357819ULL, 0x002fe2000001142dULL,
0x000001002e2d7824ULL, 0x000fcc00078e00ffULL, 0x0000003900817306ULL, 0x000e700000205400ULL,
0x0000003900e87306ULL, 0x0004f0000020d400ULL, 0x00000037007c7306ULL, 0x000fe20000009400ULL,
0x0000010037397824ULL, 0x004fe200078e00ffULL, 0x000000817e00720bULL, 0x002fc80003fdd000ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000037007d7306ULL, 0x000e6e0000005400ULL,
0x00000001e8e86812ULL, 0x008fe200078efcffULL, 0x0000003700777306ULL, 0x0004f0000000d400ULL,
0x0000003600de7306ULL, 0x000fe20000209400ULL, 0x0001000037377824ULL, 0x004fe200078e00ffULL,
0x0000007d7c00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000003600ed7306ULL, 0x000e6e0000205400ULL, 0x0000000177776812ULL, 0x008fe200078efcffULL,
0x0000003600dd7306ULL, 0x0004f0000020d400ULL, 0x0000003a006f7306ULL, 0x000fe20000209400ULL,
0x00000018ff367819ULL, 0x004fc4000001142dULL, 0x000000807a2d7811ULL, 0x000fe400078e18ffULL,
0x000000edde00720bULL, 0x002fc60003fbd000ULL, 0x0000003a00cb7306ULL, 0x000ff00000205400ULL,
0x0000003a00ae7306ULL, 0x0003e4000020d400ULL, 0x00000001dddd5812ULL, 0x008fcc00078efcffULL,
0x0000003700cc7306ULL, 0x000fe20000209400ULL, 0x00000018ff3a7819ULL, 0x002fce000001142eULL,
0x0000003700f47306ULL, 0x000e700000205400ULL, 0x0000003700dc7306ULL, 0x0004f0000020d400ULL,
0x0000003b006b7306ULL, 0x000fe20000209400ULL, 0x000000014a377824ULL, 0x104fe200078e022dULL,
0x000000f4cc00720bULL, 0x002fe20003fbd000ULL, 0x00000001492d7824ULL, 0x000fc800078e022dULL,
0x000000102d2d7824ULL, 0x000fe200078e0248ULL, 0x0000003b006c7306ULL, 0x000e680000205400ULL,
0x000000002d3c783bULL, 0x0005260000004200ULL, 0x00000001dcdc5812ULL, 0x008fe200078efcffULL,
0x0000003b00787306ULL, 0x000762000020d400ULL, 0x000001007a2d7811ULL, 0x004fce00078e18ffULL,
0x0000003a00957306ULL, 0x000fe20000209400ULL, 0x00000018ff3b7819ULL, 0x008fe4000001142fULL,
0x0000006c6b00720bULL, 0x002fca0003fdd000ULL, 0x0000003a00947306ULL, 0x000ff00000205400ULL,
0x0000003a00bd7306ULL, 0x0003e2000020d400ULL, 0x0000000178786812ULL, 0x020fce00078efcffULL,
0x0000003800cf7306ULL, 0x000fe20000209400ULL, 0x00000018ff3a7819ULL, 0x002fe40000011434ULL,
0x00000018fff77819ULL, 0x010fca000001143fULL, 0x0000003800697306ULL, 0x000e700000205400ULL,
0x0000003800d97306ULL, 0x0004f0000020d400ULL, 0x0000003b00917306ULL, 0x000fe20000209400ULL,
0x0000001037387824ULL, 0x004fe200078e0248ULL, 0x00000069cf00720bULL, 0x002fcc0003fdd000ULL,
0x0000003b008f7306ULL, 0x000fee0000205400ULL, 0x00000001d9d96812ULL, 0x008fe200078efcffULL,
0x0000003b00bb7306ULL, 0x000ff0000020d400ULL, 0x0000003a00347306ULL, 0x000ff00000209400ULL,
0x0000003a007b7306ULL, 0x000e700000205400ULL, 0x0000003a00b77306ULL, 0x000eb0000020d400ULL,
0x00000039004b7306ULL, 0x000fe20000209400ULL, 0x0000007b3400720bULL, 0x002fce0003f9d000ULL,
0x0000003900717306ULL, 0x000e6c0000205400ULL, 0x00000001b7b74812ULL, 0x004fe400078efcffULL,
0x0000003900e07306ULL, 0x0004f0000020d400ULL, 0x0000003500be7306ULL, 0x000fe20000209400ULL,
0x000000003838783bULL, 0x004ea20000004200ULL, 0x000000714b00720bULL, 0x002fcc0003f5d000ULL,
0x0000003500bf7306ULL, 0x000e6e0000205400ULL, 0x00000001e0e02812ULL, 0x008fe200078efcffULL,
0x0000003500877306ULL, 0x000722000020d400ULL, 0x000000cb6f00720bULL, 0x000fce0003f5d000ULL,
0x0000002c00727306ULL, 0x000fe20000009400ULL, 0x000100002e357824ULL, 0x008fe200078e00ffULL,
0x000000bfbe00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000002c00797306ULL, 0x000e620000005400ULL, 0x00000001aeae2812ULL, 0x000fe400078efcffULL,
0x000000cecd00720bULL, 0x000fc80003f5d000ULL, 0x0000000187873812ULL, 0x010fe200078efcffULL,
0x0000002c00d87306ULL, 0x000730000000d400ULL, 0x0000003500ad7306ULL, 0x000fe20000209400ULL,
0x000100002c2c7824ULL, 0x008fe200078e00ffULL, 0x000000797200720bULL, 0x002fc40003f9d000ULL,
0x00000001dada2812ULL, 0x000fe400078efcffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000003500b67306ULL, 0x000fee0000205400ULL, 0x00000001d8d84812ULL, 0x010fe200078efcffULL,
0x0000003500c37306ULL, 0x0003e2000020d400ULL, 0x0000009aa100720bULL, 0x000fe20003f9d000ULL,
0x00000100389a7824ULL, 0x004fcc00078e00ffULL, 0x0000002c00b87306ULL, 0x000fe20000209400ULL,
0x00000018ff357819ULL, 0x002fca000001143aULL, 0x0000000196964812ULL, 0x000fe400078efcffULL,
0x0000002c00ba7306ULL, 0x000e620000205400ULL, 0x000000949500720bULL, 0x000fe20003f9d000ULL,
0x0000010039947824ULL, 0x000fcc00078e00ffULL, 0x0000002c00bc7306ULL, 0x0004ec000020d400ULL,
0x00000001bdbd4812ULL, 0x000fe400078efcffULL, 0x0000003600b47306ULL, 0x000fe20000209400ULL,
0x000001002f2c7824ULL, 0x004fe200078e00ffULL, 0x000000bab800720bULL, 0x002fe20003fdd000ULL,
0x0001000038b87824ULL, 0x000fc600078e00ffULL, 0x00000018ff377819ULL, 0x000fe4000001142cULL,
0x0000003600b97306ULL, 0x000e620000205400ULL, 0x00000018ffbf7819ULL, 0x000fcc00000114b8ULL,
0x00000001bcbc6812ULL, 0x008fe200078efcffULL, 0x0000003600b37306ULL, 0x0004e2000020d400ULL,
0x000000999800720bULL, 0x000fe20003fdd000ULL, 0x000001003a997824ULL, 0x000fe200078e00ffULL,
0x000000bc9696723eULL, 0x000fca00000010ffULL, 0x0000003500857306ULL, 0x000fe20000209400ULL,
0x000100002f367824ULL, 0x004fe200078e00ffULL, 0x000000b9b400720bULL, 0x002fc80003f7d000ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x00000035008c7306ULL, 0x000fe20000205400ULL,
0x0000000197976812ULL, 0x000fe400078efcffULL, 0x0000008f9100720bULL, 0x000fe20003fdd000ULL,
0x00010000398f7824ULL, 0x000fe200078e00ffULL, 0x000000879797723eULL, 0x000fe400000010ffULL,
0x00000001b3b33812ULL, 0x008fe200078efcffULL, 0x0000003500a07306ULL, 0x0003f0000020d400ULL,
0x0000003700a47306ULL, 0x000fe20000209400ULL, 0x000000014a357824ULL, 0x002fe200078e022dULL,
0x00000018ff4a7819ULL, 0x000fe2000001143dULL, 0x00000001492d7824ULL, 0x000fe200078e022dULL,
0x00000001bbbb6812ULL, 0x000fe200078efcffULL, 0x0000001035357824ULL, 0x000fc400078e0248ULL,
0x000000102d487824ULL, 0x000fe200078e0248ULL, 0x0000003700ac7306ULL, 0x000e700000205400ULL,
0x0000003700b17306ULL, 0x000eb0000020d400ULL, 0x0000003600a27306ULL, 0x000fe20000209400ULL,
0x000000aca400720bULL, 0x002fc40003f7d000ULL, 0x00000018ffa47819ULL, 0x000fca0000011499ULL,
0x0000003600a37306ULL, 0x000fec0000205400ULL, 0x00000001b1b13812ULL, 0x004fe400078efcffULL,
0x0000003600c27306ULL, 0x0003e2000020d400ULL, 0x000000b6ad00720bULL, 0x000fce0003f7d000ULL,
0x0000004a007a7306ULL, 0x000fe20000209400ULL, 0x000000003534783bULL, 0x002e6a0000004200ULL,
0x00000001c3c33812ULL, 0x000fe400078efcffULL, 0x0000004a007b7306ULL, 0x000ff00000205400ULL,
0x0000004a00847306ULL, 0x0005f0000020d400ULL, 0x0000002f00c87306ULL, 0x000fe20000009400ULL,
0x000000004848783bULL, 0x004eae0000004200ULL, 0x0000002f00c97306ULL, 0x000ef00000005400ULL,
0x0000002e002c7306ULL, 0x000fe20000009400ULL, 0x00000018fff67819ULL, 0x002fc40000011435ULL,
0x00000018ffee7819ULL, 0x000fe40000011434ULL, 0x00000018fff97819ULL, 0x000fc60000011437ULL,
0x000000f600737306ULL, 0x000fe20000209400ULL, 0x000000c9c800720bULL, 0x008fce0003f5d000ULL,
0x000000f600757306ULL, 0x000ff00000205400ULL, 0x000000f600707306ULL, 0x0003e2000020d400ULL,
0x00000018fff47819ULL, 0x004fe20000011448ULL, 0x000100004b897824ULL, 0x000fca00078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011489ULL, 0x000000f400cc7306ULL, 0x000fe20000209400ULL,
0x00000018fff67819ULL, 0x002fce0000011449ULL, 0x000000f600ce7306ULL, 0x000ff00000209400ULL,
0x000000f600cd7306ULL, 0x000ff00000205400ULL, 0x000000f600697306ULL, 0x0003f0000020d400ULL,
0x000000f400cb7306ULL, 0x000fe20000205400ULL, 0x00000018fff67819ULL, 0x002fce000001149aULL,
0x000000f4006b7306ULL, 0x000ff0000020d400ULL, 0x000000f6009a7306ULL, 0x000ff00000209400ULL,
0x000000f600f47306ULL, 0x000e700000205400ULL, 0x0000002e00d07306ULL, 0x000eb00000005400ULL,
0x0000002e00c57306ULL, 0x000722000000d400ULL, 0x000000f49a00720bULL, 0x002fce0003f9d000ULL,
0x0000003800a17306ULL, 0x000fe20000009400ULL, 0x00000018ff2e7819ULL, 0x008fe40000011438ULL,
0x000000d02c00720bULL, 0x004fca0003fbd000ULL, 0x0000003800c97306ULL, 0x000e700000005400ULL,
0x0000003800ba7306ULL, 0x000ea2000000d400ULL, 0x00000001c5c55812ULL, 0x010fce00078efcffULL,
0x000000f600be7306ULL, 0x000722000020d400ULL, 0x000000c9a100720bULL, 0x002fe20003fbd000ULL,
0x000001003ba17824ULL, 0x000fca00078e00ffULL, 0x00000018ffad7819ULL, 0x000fe200000114a1ULL,
0x000000bf00387306ULL, 0x000fe20000209400ULL, 0x00000018fff67819ULL, 0x008fca0000011494ULL,
0x00000001baba5812ULL, 0x004fe400078efcffULL, 0x000000bf00c87306ULL, 0x000e620000205400ULL,
0x00000001bebe4812ULL, 0x010fce00078efcffULL, 0x0000003900957306ULL, 0x000ff00000009400ULL,
0x0000003900987306ULL, 0x000ea20000005400ULL, 0x000000c83800720bULL, 0x002fe20003f9d000ULL,
0x000001003c387824ULL, 0x000fcc00078e00ffULL, 0x000000bf00b87306ULL, 0x000e70000020d400ULL,
0x000000f600947306ULL, 0x000fe20000209400ULL, 0x000000989500720bULL, 0x004fe20003f7d000ULL,
0x000100003a987824ULL, 0x000fca00078e00ffULL, 0x00000018ff987819ULL, 0x000fe20000011498ULL,
0x000000f600917306ULL, 0x000ea20000205400ULL, 0x00000001b8b84812ULL, 0x002fce00078efcffULL,
0x0000003900b97306ULL, 0x000e70000000d400ULL, 0x000000f600bf7306ULL, 0x000ee2000020d400ULL,
0x000000919400720bULL, 0x004fe20003f9d000ULL, 0x000001003d917824ULL, 0x000fca00078e00ffULL,
0x00000018ff917819ULL, 0x000fe20000011491ULL, 0x000000a400997306ULL, 0x000fe20000209400ULL,
0x00000001b9b93812ULL, 0x002fce00078efcffULL, 0x000000a400f67306ULL, 0x000e620000205400ULL,
0x00000001bfbf4812ULL, 0x008fce00078efcffULL, 0x0000002f00c47306ULL, 0x0004f0000000d400ULL,
0x0000002e00927306ULL, 0x000fe20000209400ULL, 0x00000018ff2f7819ULL, 0x004fe40000011439ULL,
0x000000f69900720bULL, 0x002fca0003f7d000ULL, 0x0000002e00937306ULL, 0x000e620000205400ULL,
0x00000001c4c42812ULL, 0x008fe400078efcffULL, 0x000000a3a200720bULL, 0x000fca0003f5d000ULL,
0x0000002e00b57306ULL, 0x0004f0000020d400ULL, 0x0000002f008d7306ULL, 0x000fe20000209400ULL,
0x00000018ff2e7819ULL, 0x004fe4000001143bULL, 0x000000939200720bULL, 0x002fc40003fbd000ULL,
0x00000001c2c22812ULL, 0x000fc600078efcffULL, 0x0000002f008e7306ULL, 0x000e700000205400ULL,
0x0000002f00a57306ULL, 0x000522000020d400ULL, 0x00000001b5b55812ULL, 0x008fce00078efcffULL,
0x0000002e00807306ULL, 0x000fe20000209400ULL, 0x00000018ff2f7819ULL, 0x004fe4000001143cULL,
0x0000008e8d00720bULL, 0x002fca0003f9d000ULL, 0x0000002e00827306ULL, 0x000ff00000205400ULL,
0x0000002e009b7306ULL, 0x0003e2000020d400ULL, 0x00000001a5a54812ULL, 0x010fce00078efcffULL,
0x000000f700727306ULL, 0x000fe20000209400ULL, 0x00000018ff2e7819ULL, 0x002fce000001143eULL,
0x000000f700797306ULL, 0x000ff00000205400ULL, 0x000000f700747306ULL, 0x0003f0000020d400ULL,
0x000000a400ac7306ULL, 0x000ea2000020d400ULL, 0x00000018fff77819ULL, 0x002fce0000011436ULL,
0x000000ad00b67306ULL, 0x000ff00000209400ULL, 0x000000ad00c97306ULL, 0x000e620000205400ULL,
0x00000001acac3812ULL, 0x004fce00078efcffULL, 0x0000002f007e7306ULL, 0x000ff00000209400ULL,
0x0000002f00817306ULL, 0x000fe20000205400ULL, 0x000000c9b600720bULL, 0x002fce0003f7d000ULL,
0x0000002f00837306ULL, 0x000ff0000020d400ULL, 0x0000002e007d7306ULL, 0x000ff00000209400ULL,
0x0000002e007f7306ULL, 0x000ff00000205400ULL, 0x0000002e007c7306ULL, 0x000ff0000020d400ULL,
0x000000ee002e7306ULL, 0x000ff00000209400ULL, 0x000000ee002f7306ULL, 0x000ff00000205400ULL,
0x000000ee00717306ULL, 0x000ff0000020d400ULL, 0x000000f700ed7306ULL, 0x000ff00000209400ULL,
0x000000f700ee7306ULL, 0x000ff00000205400ULL, 0x000000f7006f7306ULL, 0x0003f0000020d400ULL,
0x000000ad00a17306ULL, 0x000ea2000020d400ULL, 0x00000018fff77819ULL, 0x002fce000001144aULL,
0x000000f700d07306ULL, 0x000ff00000209400ULL, 0x000000f700cf7306ULL, 0x000fe20000205400ULL,
0x00000001a1a13812ULL, 0x004fce00078efcffULL, 0x000000f7002c7306ULL, 0x0003f0000020d400ULL,
0x0000003a00a27306ULL, 0x000fe20000009400ULL, 0x00000018fff77819ULL, 0x002fce000001148fULL,
0x000000f700397306ULL, 0x000ff00000209400ULL, 0x000000f7008f7306ULL, 0x000e700000205400ULL,
0x0000003a00a37306ULL, 0x000eb00000005400ULL, 0x0000003a00ad7306ULL, 0x000ee2000000d400ULL,
0x0000008f3900720bULL, 0x002fe20003fbd000ULL, 0x000001003e8f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x0000009800f47306ULL, 0x000fe20000209400ULL,
0x000000a3a200720bULL, 0x004fce0003f5d000ULL, 0x00000098003a7306ULL, 0x000e6c0000205400ULL,
0x00000001adad2812ULL, 0x008fe400078efcffULL, 0x0000003d008d7306ULL, 0x000fe20000009400ULL,
0x0000008c8500720bULL, 0x000fce0003f5d000ULL, 0x0000003d00f67306ULL, 0x000ea20000005400ULL,
0x0000003af400720bULL, 0x002fe20003f7d000ULL, 0x000001003f3a7824ULL, 0x000fc800078e00ffULL,
0x00000001a0a02812ULL, 0x000fe400078efcffULL, 0x0000003b00957306ULL, 0x000ff00000009400ULL,
0x0000003b009a7306ULL, 0x000e620000005400ULL, 0x000000f68d00720bULL, 0x004fe20003f9d000ULL,
0x000100003d8d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe2000001148dULL,
0x0000009800a47306ULL, 0x000eb0000020d400ULL, 0x000000f700b47306ULL, 0x000ee2000020d400ULL,
0x0000009a9500720bULL, 0x002fe20003fdd000ULL, 0x000100003b957824ULL, 0x000fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fc80000011438ULL, 0x00000018ff957819ULL, 0x000fe20000011495ULL,
0x0000003c00397306ULL, 0x000fe20000009400ULL, 0x00000001a4a43812ULL, 0x004fe400078efcffULL,
0x000000828000720bULL, 0x000fe20003f7d000ULL, 0x000100003f807824ULL, 0x000fc800078e00ffULL,
0x0000003c00927306ULL, 0x000e620000005400ULL, 0x00000001b4b45812ULL, 0x008fce00078efcffULL,
0x0000009a00387306ULL, 0x000fe20000209400ULL, 0x000000019b9b3812ULL, 0x000fce00078efcffULL,
0x0000009a00937306ULL, 0x000ea20000205400ULL, 0x000000923900720bULL, 0x002fe20003fbd000ULL,
0x000100003c397824ULL, 0x000fca00078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe20000011439ULL,
0x0000009a00987306ULL, 0x000e70000020d400ULL, 0x0000003d009a7306ULL, 0x000ee2000000d400ULL,
0x000000933800720bULL, 0x004fe20003f5d000ULL, 0x000100003e387824ULL, 0x000fcc00078e00ffULL,
0x0000008d003d7306ULL, 0x000fec0000209400ULL, 0x0000000198982812ULL, 0x002fe400078efcffULL,
0x0000008d00f67306ULL, 0x000e620000205400ULL, 0x000000019a9a4812ULL, 0x008fce00078efcffULL,
0x0000009100c87306ULL, 0x000ff00000209400ULL, 0x0000009100947306ULL, 0x000ea20000205400ULL,
0x000000f63d00720bULL, 0x002fe20003f9d000ULL, 0x00010000343d7824ULL, 0x000fca00078e00ffULL,
0x00000018fff67819ULL, 0x000fe2000001143dULL, 0x0000003b00a37306ULL, 0x000e70000000d400ULL,
0x00000095003b7306ULL, 0x000fe20000209400ULL, 0x00000094c800720bULL, 0x004fc40003f7d000ULL,
0x00000018ffc87819ULL, 0x000fca0000011480ULL, 0x0000009500f77306ULL, 0x000ea20000205400ULL,
0x00000001a3a36812ULL, 0x002fce00078efcffULL, 0x0000008d00927306ULL, 0x000e70000020d400ULL,
0x0000009500a27306ULL, 0x000ee2000020d400ULL, 0x000000f73b00720bULL, 0x004fe40003fdd000ULL,
0x00000018fff77819ULL, 0x000fca000001143aULL, 0x0000008f00b67306ULL, 0x000fe20000209400ULL,
0x0000000192924812ULL, 0x002fce00078efcffULL, 0x0000008f00c97306ULL, 0x000e620000205400ULL,
0x00000001a2a26812ULL, 0x008fce00078efcffULL, 0x0000009100957306ULL, 0x000eb0000020d400ULL,
0x0000003c00997306ULL, 0x000ee2000000d400ULL, 0x000000c9b600720bULL, 0x002fce0003f9d000ULL,
0x0000008e00397306ULL, 0x000fe20000209400ULL, 0x0000000195953812ULL, 0x004fce00078efcffULL,
0x0000008e003c7306ULL, 0x000e620000205400ULL, 0x0000000199995812ULL, 0x008fe400078efcffULL,
0x000000817e00720bULL, 0x000fe40003fbd000ULL, 0x000000999898723eULL, 0x000fe400000010ffULL,
0x0000009a9599723eULL, 0x000fe200000010ffULL, 0x0000003e00857306ULL, 0x000ff00000009400ULL,
0x0000003e00f47306ULL, 0x000ea20000005400ULL, 0x0000003c3900720bULL, 0x002fe20003f7d000ULL,
0x00000100343c7824ULL, 0x000fe200078e00ffULL, 0x0000000183835812ULL, 0x000fc400078efcffULL,
0x0000007f7d00720bULL, 0x000fc60003fbd000ULL, 0x0000008f008c7306ULL, 0x000e70000020d400ULL,
0x000000f7003a7306ULL, 0x000fe20000209400ULL, 0x000000f48500720bULL, 0x004fe40003fdd000ULL,
0x000000017c7c5812ULL, 0x000fca00078efcffULL, 0x000000f7003b7306ULL, 0x000ea20000205400ULL,
0x000000018c8c4812ULL, 0x002fce00078efcffULL, 0x0000008e00917306ULL, 0x000e70000020d400ULL,
0x0000003f00827306ULL, 0x000fe20000009400ULL, 0x0000003b3a00720bULL, 0x004fce0003f9d000ULL,
0x0000003f00f47306ULL, 0x000ea20000005400ULL, 0x0000000191913812ULL, 0x002fe400078efcffULL,
0x0000007b7a00720bULL, 0x000fe20003f7d000ULL, 0x00000100357a7824ULL, 0x000fc800078e00ffULL,
0x000000f7008d7306ULL, 0x0002e2000020d400ULL, 0x00000018ff7a7819ULL, 0x000fce000001147aULL,
0x0000003f008f7306ULL, 0x000f22000000d400ULL, 0x00000018fff77819ULL, 0x002fe40000011438ULL,
0x000000f48200720bULL, 0x004fe40003f5d000ULL, 0x00000018fff47819ULL, 0x000fe4000001143cULL,
0x0000000184843812ULL, 0x000fe200078efcffULL, 0x000000c8003f7306ULL, 0x000fe20000209400ULL,
0x000000018d8d4812ULL, 0x008fe400078efcffULL, 0x000000797200720bULL, 0x000fe20003f7d000ULL,
0x0001000035727824ULL, 0x000fc800078e00ffULL, 0x000000c800937306ULL, 0x000e620000205400ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x000000018f8f2812ULL, 0x010fc800078efcffULL,
0x0000008f8d8d723eULL, 0x000fe200000010ffULL, 0x0000003e008e7306ULL, 0x000ea2000000d400ULL,
0x0000000174743812ULL, 0x000fe400078efcffULL, 0x0000006e6d00720bULL, 0x000fe40003f7d000ULL,
0x00000017ff6d723eULL, 0x000fc600000010ffULL, 0x000000f700387306ULL, 0x000fe20000209400ULL,
0x000000933f00720bULL, 0x002fe40003f9d000ULL, 0x000054106d6e7816ULL, 0x000fca000000006dULL,
0x000000f7003e7306ULL, 0x000e620000205400ULL, 0x000000018e8e6812ULL, 0x004fe400078efcffULL,
0x0000000105053812ULL, 0x000fe400078efcffULL, 0x000000ecef00720bULL, 0x000fe40003f7d000ULL,
0x0000008e8c8c723eULL, 0x000fe200000010ffULL, 0x0000003400947306ULL, 0x000fe20000009400ULL,
0x000000050404723eULL, 0x000fce00000010ffULL, 0x0000003400397306ULL, 0x000fe20000005400ULL,
0x0000003e3800720bULL, 0x002fe20003fdd000ULL, 0x0000010036387824ULL, 0x000fe200078e00ffULL,
0x0000000100003812ULL, 0x000fca00078efcffULL, 0x0000003400817306ULL, 0x000ff0000000d400ULL,
0x000000c800807306ULL, 0x000e70000020d400ULL, 0x000000f6003d7306ULL, 0x000ff00000209400ULL,
0x000000f600347306ULL, 0x000ea20000205400ULL, 0x0000000180804812ULL, 0x002fc400078efcffULL,
0x0000002f2e00720bULL, 0x000fca0003f9d000ULL, 0x000000f700857306ULL, 0x000e70000020d400ULL,
0x000000f4003c7306ULL, 0x000fe20000209400ULL, 0x000000343d00720bULL, 0x004fe20003fbd000ULL,
0x0001000036347824ULL, 0x000fe200078e00ffULL, 0x0000000171714812ULL, 0x000fc800078efcffULL,
0x00000018ff3f7819ULL, 0x000fe20000011434ULL, 0x000000f400c87306ULL, 0x000ea20000205400ULL,
0x0000000185856812ULL, 0x002fe200078efcffULL, 0x000004000e347824ULL, 0x000fe200078e00ffULL,
0x000000399400720bULL, 0x000fc80003fdd000ULL, 0xfffff80034347812ULL, 0x000fe200078ec0ffULL,
0x00000035007b7306ULL, 0x000fe60000009400ULL, 0x0001200034347810ULL, 0x000fca0007ffe043ULL,
0x0000003500c97306ULL, 0x000fe20000005400ULL, 0x000000c83c00720bULL, 0x004fe40003f5d000ULL,
0x0000000181816812ULL, 0x000fe400078efcffULL, 0x000000757300720bULL, 0x000fe40003fdd000ULL,
0x00000002ffc87819ULL, 0x000fe20000011612ULL, 0x00000035007d7306ULL, 0x000ff0000000d400ULL,
0x0000007200357306ULL, 0x000fe40000209400ULL, 0x0000000170706812ULL, 0x000fcc00078efcffULL,
0x00000072003a7306ULL, 0x000e700000205400ULL, 0x000000f400827306ULL, 0x000eb0000020d400ULL,
0x000000f6007e7306ULL, 0x000722000020d400ULL, 0x0000003a3500720bULL, 0x002fe20003f9d000ULL,
0x0001000037357824ULL, 0x000fca00078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011435ULL,
0x0000007a00b67306ULL, 0x000fe20000209400ULL, 0x0000000182822812ULL, 0x004fe400078efcffULL,
0x00000018fff67819ULL, 0x008fe20000011438ULL, 0x0000010037387824ULL, 0x000fe200078e00ffULL,
0x000000c97b00720bULL, 0x000fe40003f5d000ULL, 0x00000008c8c97810ULL, 0x000fe20007ffe0ffULL,
0x0000007a00f47306ULL, 0x000e620000205400ULL, 0x000000017e7e5812ULL, 0x010fe200078efcffULL,
0x00001fc86ec87589ULL, 0x000fe200000e0000ULL, 0x00000018ff3c7819ULL, 0x000fc40000011438ULL,
0x0000007e717e723eULL, 0x000fe200000010ffULL, 0x00001fc96ec97589ULL, 0x000fe400000e0000ULL,
0x00000036002e7306ULL, 0x000fe40000009400ULL, 0x000000017d7d2812ULL, 0x000fe400078efcffULL,
0x000000ff6800720cULL, 0x000fe40003f45270ULL, 0x000000f4b600720bULL, 0x002fe40003fbd000ULL,
0x00000036002f7306ULL, 0x000ff00000005400ULL, 0x00000036007b7306ULL, 0x000ff0000000d400ULL,
0x00000037003d7306ULL, 0x000ff00000009400ULL, 0x0000003700b67306ULL, 0x000e700000005400ULL,
0x0000003700737306ULL, 0x0004f0000000d400ULL, 0x0000007a007f7306ULL, 0x000f22000020d400ULL,
0x000000003434783bULL, 0x004ea20000000200ULL, 0x000000b63d00720bULL, 0x002fc40003fdd000ULL,
0x000000b2d93d723eULL, 0x000fc800000010ffULL, 0x000000f6003b7306ULL, 0x000fee0000209400ULL,
0x0000000173736812ULL, 0x008fe200078efcffULL, 0x000000f6003e7306ULL, 0x000e620000205400ULL,
0x000000017f7f5812ULL, 0x010fe400078efcffULL, 0x0000009e7600720bULL, 0x000fc40003fdd000ULL,
0x0000007d7f7d723eULL, 0x000fc600000010ffULL, 0x0000007200797306ULL, 0x000ef0000020d400ULL,
0x0000003c00387306ULL, 0x000fe20000209400ULL, 0x0000003e3b00720bULL, 0x002fe40003fbd000ULL,
0x0000000103036812ULL, 0x000fc800078efcffULL, 0x000000030205723eULL, 0x000fe200000010ffULL,
0x0000003c00397306ULL, 0x000fe20000205400ULL, 0x0000000179794812ULL, 0x008fe200078efcffULL,
0x000000c83434a231ULL, 0x084fe200003400ffULL, 0x0000002f2e00720bULL, 0x000fe20003f9d000ULL,
0x000000c83636a231ULL, 0x000fe200003400ffULL, 0x00000079707f723eULL, 0x000fe200000010ffULL,
0x000000c93535a231ULL, 0x080fe400003400ffULL, 0x0000003c00727306ULL, 0x000fe2000020d400ULL,
0x000000c93737a231ULL, 0x000fce00003400ffULL, 0x000000f6007a7306ULL, 0x000e62000020d400ULL,
0x000000017b7b4812ULL, 0x000fe200078efcffULL, 0x000000963464723cULL, 0x000fec0000041864ULL,
0x0000003f003c7306ULL, 0x000fe20000209400ULL, 0x000000c5b396723eULL, 0x000fe400000010ffULL,
0x000000c4b197723eULL, 0x000fe200000010ffULL, 0x0001000048b17824ULL, 0x000fc800078e00ffULL,
0x0000003f003e7306ULL, 0x000ea20000205400ULL, 0x000000017a7a5812ULL, 0x002fe200078efcffULL,
0x000000963460723cULL, 0x040fe20000041860ULL, 0x000000393800720bULL, 0x000fe40003fbd000ULL,
0x000000456a38723eULL, 0x000fe200000010ffULL, 0x00000100476a7824ULL, 0x000fe200078e00ffULL,
0x00000044b739723eULL, 0x000fe200000010ffULL, 0x0000003f00757306ULL, 0x0002e2000020d400ULL,
0x000000c3bd96723eULL, 0x000fe400000010ffULL, 0x000000c2bb97723eULL, 0x000fe200000010ffULL,
0x0001000049bb7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x00000038344c723cULL, 0x000fe2000004184cULL, 0x0000007b7a7a723eULL, 0x000fe200000010ffULL,
0x00000043003a7306ULL, 0x000fe20000209400ULL, 0x0000003e3c00720bULL, 0x004fe20003f9d000ULL,
0x00000100483f7824ULL, 0x002fe200078e00ffULL, 0x0000000172725812ULL, 0x000fc400078efcffULL,
0x000000e89d38723eULL, 0x000fe200000010ffULL, 0x000000963430723cULL, 0x040fe20000041830ULL,
0x0000009f9c39723eULL, 0x000fe200000010ffULL, 0x00000043003b7306ULL, 0x000e620000205400ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x000000eeed00720bULL, 0x000fe40003fbd000ULL,
0x000000d8da3c723eULL, 0x000fe200000010ffULL, 0x000000383450723cULL, 0x000fe20000041850ULL,
0x0000000175754812ULL, 0x008fe200078efcffULL, 0x00000043006d7306ULL, 0x0004e2000020d400ULL,
0x00000018ffc27819ULL, 0x000fc400000114bbULL, 0x00000018ffd87819ULL, 0x000fe400000114b1ULL,
0x000000dfe138723eULL, 0x000fe200000010ffULL, 0x0000003c345c723cULL, 0x040fe2000004185cULL,
0x00000077e039723eULL, 0x000fe200000010ffULL, 0x000000f9002d7306ULL, 0x000fe20000209400ULL,
0x0000003b3a00720bULL, 0x002fe20003f9d000ULL, 0x0000010049437824ULL, 0x004fe200078e00ffULL,
0x000000016f6f5812ULL, 0x000fe400078efcffULL, 0x000000908600720bULL, 0x000fe20003fbd000ULL,
0x000000383454723cULL, 0x000fe20000041854ULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x000000f900de7306ULL, 0x000e620000205400ULL, 0x00000073727b723eULL, 0x000fc800000010ffULL,
0x000000ddae38723eULL, 0x000fe400000010ffULL, 0x000000dc7839723eULL, 0x000fe200000010ffULL,
0x0000003f00937306ULL, 0x000fe20000209400ULL, 0x000000016d6d4812ULL, 0x008fe400078efcffULL,
0x0000000121215812ULL, 0x000fe400078efcffULL, 0x000000e2e300720bULL, 0x000fe20003fbd000ULL,
0x000000383458723cULL, 0x000fe20000041858ULL, 0x000000de2d00720bULL, 0x002fe20003f9d000ULL,
0x0000003f00947306ULL, 0x000e620000205400ULL, 0x00000001ff2d7819ULL, 0x000fc8000001160eULL,
0x000000babe34723eULL, 0x000fe200000010ffULL, 0x000001004a367824ULL, 0x000fe200078e00ffULL,
0x000000b9bf35723eULL, 0x000fe200000010ffULL, 0x000008002d387824ULL, 0x040fe200078e0242ULL,
0x00000049009f7306ULL, 0x000fe20000009400ULL, 0x000008002d3e7824ULL, 0x040fe200078e0241ULL,
0x00000018ffaa7819ULL, 0x000fe20000011436ULL, 0x000008002d407824ULL, 0x000fe200078e0240ULL,
0x000000b8b536723eULL, 0x000fe200000010ffULL, 0x012000003838783bULL, 0x000ea20000000200ULL,
0x000000b4a537723eULL, 0x000fc400000010ffULL, 0x00000049009e7306ULL, 0x000ee20000005400ULL,
0x000000949300720bULL, 0x002fe40003fdd000ULL, 0x0000000119195812ULL, 0x000fca00078efcffULL,
0x0000003f006e7306ULL, 0x000330000020d400ULL, 0x0000004900777306ULL, 0x000f62000000d400ULL,
0x0000009e9f00720bULL, 0x008fe20003f1d000ULL, 0x012000003e3c783bULL, 0x002e6c0000000200ULL,
0x0000004300ae7306ULL, 0x000fe20000209400ULL, 0x000000016e6e6812ULL, 0x010fc400078efcffULL,
0x000000cbcc00720bULL, 0x000fca0003fdd000ULL, 0x0000004300bc7306ULL, 0x000ee20000205400ULL,
0x0000000177770812ULL, 0x020fe400078efcffULL, 0x000000cdce00720bULL, 0x000fe20003f1d000ULL,
0x000000c83838a231ULL, 0x084fe400003400ffULL, 0x000000c83a3aa231ULL, 0x000fe400003400ffULL,
0x000000f9006c7306ULL, 0x000ea2000020d400ULL, 0x000000c93939a231ULL, 0x080fe200003400ffULL,
0x000000016b6b6812ULL, 0x000fe200078efcffULL, 0x000000c93b3ba231ULL, 0x000fca00003400ffULL,
0x00000048009d7306ULL, 0x000fe20000009400ULL, 0x000000bcae00720bULL, 0x008fe20003f7d000ULL,
0x00000034384c723cULL, 0x000fe2000004184cULL, 0x0000000169690812ULL, 0x000fca00078efcffULL,
0x00000048009c7306ULL, 0x000ee20000005400ULL, 0x000000adac34723eULL, 0x000fe200000010ffULL,
0x000000363850723cULL, 0x040fe20000041850ULL, 0x000000a3a135723eULL, 0x000fe200000010ffULL,
0x000001004ba17824ULL, 0x000fe200078e00ffULL, 0x000000016c6c4812ULL, 0x004fe200078efcffULL,
0x000000c83c3ca231ULL, 0x082fe200003400ffULL, 0x000000afb000720bULL, 0x000fe20003f9d000ULL,
0x0000004300877306ULL, 0x0002a2000020d400ULL, 0x00000018ffb07819ULL, 0x000fe2000001144bULL,
0x000000343854723cULL, 0x040fe20000041854ULL, 0x00000018ffa17819ULL, 0x000fe200000114a1ULL,
0x000000c83e3ea231ULL, 0x000fe200003400ffULL, 0x000000a4a036723eULL, 0x000fe200000010ffULL,
0x000000c93d3da231ULL, 0x080fe200003400ffULL, 0x000000a29b37723eULL, 0x000fe200000010ffULL,
0x0000004a00867306ULL, 0x000fe20000009400ULL, 0x012000004040783bULL, 0x002e620000000200ULL,
0x0000009c9d00720bULL, 0x008fe20003f3d000ULL, 0x00000098385c723cULL, 0x000fe2000004185cULL,
0x000000918334723eULL, 0x000fe200000010ffULL, 0x000000c93f3fa231ULL, 0x000fe200003400ffULL,
0x000000928435723eULL, 0x000fc400000010ffULL, 0x0000004a00907306ULL, 0x000ee20000005400ULL,
0x0000000187873812ULL, 0x004fe400078efcffULL, 0x000000363858723cULL, 0x040fe20000041858ULL,
0x000000010c0c4812ULL, 0x000fe400078efcffULL, 0x000000a6a800720bULL, 0x000fe40003f9d000ULL,
0x0000004b00b27306ULL, 0x000fe20000009400ULL, 0x0000000d0c0c723eULL, 0x000fe400000010ffULL,
0x000000343864723cULL, 0x000fe20000041864ULL, 0x000000778777723eULL, 0x000fc800000010ffULL,
0x0000004b00b37306ULL, 0x000ea20000005400ULL, 0x000000908600720bULL, 0x008fe40003fdd000ULL,
0x000000857c34723eULL, 0x000fe200000010ffULL, 0x0000008c3860723cULL, 0x040fe20000041860ULL,
0x000000807435723eULL, 0x000fe400000010ffULL, 0x00000081827c723eULL, 0x000fe200000010ffULL,
0x000000c200bd7306ULL, 0x000fe20000209400ULL, 0x000000011a1a4812ULL, 0x000fe400078efcffULL,
0x000000d7db00720bULL, 0x000fe20003f9d000ULL, 0x000000343830723cULL, 0x000fe80000041830ULL,
0x000000c200bb7306ULL, 0x000ee20000205400ULL, 0x000000b3b200720bULL, 0x004fe20003f1d000ULL,
0x000000c84040a231ULL, 0x082fe200003400ffULL, 0x000000756f34723eULL, 0x000fe200000010ffULL,
0x000000c84242a231ULL, 0x000fe200003400ffULL, 0x0000006d6c35723eULL, 0x000fe200000010ffULL,
0x000000c94141a231ULL, 0x080fe200003400ffULL, 0x0000007c3c4c723cULL, 0x000fe2000004184cULL,
0x0000004800767306ULL, 0x000e62000000d400ULL, 0x000000c94343a231ULL, 0x000fe200003400ffULL,
0x000000e7e900720bULL, 0x000fc40003f5d000ULL, 0x000000011f1f4812ULL, 0x000fc600078efcffULL,
0x000000343c58723cULL, 0x000fe20000041858ULL, 0x000000d800c57306ULL, 0x000fe20000209400ULL,
0x000000bbbd00720bULL, 0x008fcc0003f7d000ULL, 0x000000010b0b2812ULL, 0x000fe200078efcffULL,
0x000000d800c47306ULL, 0x000ea20000205400ULL, 0x0000000176761812ULL, 0x002fe200078efcffULL,
0x0000007e3c50723cULL, 0x040fe20000041850ULL, 0x000000a7a900720bULL, 0x000fe40003f5d000ULL,
0x0000000b0a0a723eULL, 0x000fe400000010ffULL, 0x00000007060b723eULL, 0x000fe200000010ffULL,
0x0000004a00787306ULL, 0x0002e2000000d400ULL, 0x000000766e76723eULL, 0x000fe200000010ffULL,
0x0000007a3c54723cULL, 0x040fec0000041854ULL, 0x0000004b00487306ULL, 0x000f22000000d400ULL,
0x000000c4c500720bULL, 0x004fe20003f3d000ULL, 0x000100004a4a7824ULL, 0x002fe200078e00ffULL,
0x0000000108082812ULL, 0x000fe200078efcffULL, 0x000000763c5c723cULL, 0x000fe6000004185cULL,
0x00000018ff4a7819ULL, 0x000fe2000001144aULL, 0x000000c200967306ULL, 0x000e62000020d400ULL,
0x0000000178786812ULL, 0x008fc400078efcffULL, 0x000000cfd000720bULL, 0x000fe20003fdd000ULL,
0x0000000a4050723cULL, 0x000fe20000041850ULL, 0x00000009080d723eULL, 0x000fc600000010ffULL,
0x000000b000b17306ULL, 0x000fe20000209400ULL, 0x0000000148480812ULL, 0x010fc600078efcffULL,
0x0000000c404c723cULL, 0x040fe8000004184cULL, 0x000000b000497306ULL, 0x000ea20000205400ULL,
0x0000000196963812ULL, 0x002fe400078efcffULL, 0x000000012c2c6812ULL, 0x000fe200078efcffULL,
0x000000044054723cULL, 0x000fe20000041854ULL, 0x000000f0f100720bULL, 0x000fe40003fdd000ULL,
0x000000966935723eULL, 0x000fe200000010ffULL, 0x000000a100887306ULL, 0x000fe60000209400ULL,
0x0001b6302d047811ULL, 0x000fca00078e20ffULL, 0x000000a1004b7306ULL, 0x000e620000205400ULL,
0x00000049b100720bULL, 0x004fe40003f1d000ULL, 0x000000011b1b6812ULL, 0x000fe400078efcffULL,
0x000000c0c100720bULL, 0x000fc60003fdd000ULL, 0x000000d800af7306ULL, 0x000eb0000020d400ULL,
0x000000aa00977306ULL, 0x000fe20000209400ULL, 0x0000004b8800720bULL, 0x002fe40003f7d000ULL,
0x0000000124246812ULL, 0x000fc400078efcffULL, 0x000000f2f300720bULL, 0x000fc60003fdd000ULL,
0x000000aa00a57306ULL, 0x000e620000205400ULL, 0x00000001afaf1812ULL, 0x004fc800078efcffULL,
0x000000af6b34723eULL, 0x000fc600000010ffULL, 0x000000a100837306ULL, 0x000ea4000020d400ULL,
0x0000000126266812ULL, 0x000fe400078efcffULL, 0x000000343c64723cULL, 0x000fe80000041864ULL,
0x000000b000b07306ULL, 0x000ee2000020d400ULL, 0x000000a59700720bULL, 0x002fce0003f3d000ULL,
0x0000008900387306ULL, 0x000fe20000209400ULL, 0x0000000183833812ULL, 0x004fc800078efcffULL,
0x000000488379723eULL, 0x000fc600000010ffULL, 0x00000089003b7306ULL, 0x000e620000205400ULL,
0x00000001b0b00812ULL, 0x008fe400078efcffULL, 0x0000002a2b00720bULL, 0x000fca0003f1d000ULL,
0x000000aa00a07306ULL, 0x000eb0000020d400ULL, 0x0000004a00367306ULL, 0x000fe20000209400ULL,
0x0000003b3800720bULL, 0x002fe40003f7d000ULL, 0x0000000122220812ULL, 0x000fc400078efcffULL,
0x000000f5f800720bULL, 0x000fe40003f1d000ULL, 0x000000212222723eULL, 0x000fe200000010ffULL,
0x0000004a00377306ULL, 0x000e620000205400ULL, 0x00000001a0a01812ULL, 0x004fe400078efcffULL,
0x000000261921723eULL, 0x000fe400000010ffULL, 0x00000078a078723eULL, 0x000fc600000010ffULL,
0x0000008900897306ULL, 0x000ea4000020d400ULL, 0x0000000129290812ULL, 0x000fe400078efcffULL,
0x000000252700720bULL, 0x000fe20003f1d000ULL, 0x000000783c60723cULL, 0x000fe60000041860ULL,
0x0000004a00397306ULL, 0x000ee2000020d400ULL, 0x000000373600720bULL, 0x002fe40003f3d000ULL,
0x0000000189893812ULL, 0x004fca00078efcffULL, 0x0000004600b67306ULL, 0x000fe20000009400ULL,
0x000000d3d400720bULL, 0x000fe40003f7d000ULL, 0x00000089b02b723eULL, 0x000fe400000010ffULL,
0x0000000128280812ULL, 0x000fe400078efcffULL, 0x0000000139391812ULL, 0x008fe200078efcffULL,
0x0000004600b77306ULL, 0x000e620000005400ULL, 0x000000d1d200720bULL, 0x000fe40003f3d000ULL,
0x000000392c2a723eULL, 0x000fc600000010ffULL, 0x000000011c1c3812ULL, 0x000fe400078efcffULL,
0x0000004600447306ULL, 0x0004e2000000d400ULL, 0x000000e4e600720bULL, 0x000fe20003f7d000ULL,
0x0000002a3c30723cULL, 0x000fe20000041830ULL, 0x0000001b1c03723eULL, 0x000fc600000010ffULL,
0x0000000123231812ULL, 0x000fe400078efcffULL, 0x00000047002e7306ULL, 0x000fe20000009400ULL,
0x0001000046467824ULL, 0x004fe200078e00ffULL, 0x000000b7b600720bULL, 0x002fe40003f5d000ULL,
0x000000002302723eULL, 0x000fe400000010ffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x0000004700687306ULL, 0x000e620000005400ULL, 0x0000000120203812ULL, 0x000fc400078efcffULL,
0x000000d5d600720bULL, 0x000fe20003f7d000ULL, 0x000000024058723cULL, 0x040fe20000041858ULL,
0x000000292020723eULL, 0x000fe400000010ffULL, 0x0000000144442812ULL, 0x008fe200078efcffULL,
0x00000047002f7306ULL, 0x0004e2000000d400ULL, 0x0000001a2423723eULL, 0x000fe400000010ffULL,
0x000000442828723eULL, 0x000fe200000010ffULL, 0x000000204064723cULL, 0x000fe20000041864ULL,
0x0001b6682d027811ULL, 0x000fc600078e18ffULL, 0x0000006a00457306ULL, 0x000fe20000209400ULL,
0x0001000047477824ULL, 0x004fe200078e00ffULL, 0x000000682e00720bULL, 0x002fe40003f3d000ULL,
0x0000000118183812ULL, 0x000fe200078efcffULL, 0x00000022405c723cULL, 0x000fe2000004185cULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000006a00367306ULL, 0x000e6e0000205400ULL,
0x000000012f2f1812ULL, 0x008fe200078efcffULL, 0x00000046002c7306ULL, 0x000fe20000209400ULL,
0x0000000116007812ULL, 0x000fce000782c0ffULL, 0x0000004600097306ULL, 0x000ea20000205400ULL,
0x000000364500720bULL, 0x002fce0003fdd000ULL, 0x0000004700067306ULL, 0x000ff00000209400ULL,
0x0000004700077306ULL, 0x000e620000205400ULL, 0x000000092c00720bULL, 0x004fce0003fbd000ULL,
0x0000006a00347306ULL, 0x000eb0000020d400ULL, 0x0000004600467306ULL, 0x000ee2000020d400ULL,
0x000000070600720bULL, 0x002fce0003f1d000ULL, 0x0000004700477306ULL, 0x000e62000020d400ULL,
0x0000000134346812ULL, 0x004fc800078efcffULL, 0x0000002f3429723eULL, 0x000fe400000010ffULL,
0x0000000146465812ULL, 0x008fc800078efcffULL, 0x000000461f46723eULL, 0x000fe200000010ffULL,
0x000000284060723cULL, 0x000fe20000041860ULL, 0x0000000147470812ULL, 0x002fc800078efcffULL,
0x000000471847723eULL, 0x000fce00000010ffULL, 0x000000464030723cULL, 0x000fe20000041830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000002ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000001fa7983ULL, 0x000ea20000300800ULL, 0x000000011600780cULL, 0x000fc60003f05270ULL,
0x0000000004ff7f8cULL, 0x0007e2000c80043fULL, 0x000000e51d037207ULL, 0x000fc80004000000ULL,
0x000000ff03ff7812ULL, 0x000fc8000784c0ffULL, 0x00000001ff039807ULL, 0x000fe40001000000ULL,
0x000000fffaff7812ULL, 0x004fc8000780c0ffULL, 0x00000001ff027807ULL, 0x002fe40004000000ULL,
0x0000030010107a10ULL, 0x00cfe40007ffe0ffULL, 0x000000ff1eff7812ULL, 0x000fe4000780c0ffULL,
0x000000111000720cULL, 0x000fe40003f26070ULL, 0x00000001ff1e7807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff606000007947ULL, 0x000fea000383ffffULL,
0x0000000000077919ULL, 0x002e620000000000ULL, 0x000000022d007824ULL, 0x000fe200078e00ffULL,
0x00000000000479c3ULL, 0x000ea40000002500ULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000000200037812ULL, 0x000fe200078e0cffULL, 0x000000800e007824ULL, 0x000fc600078e00ffULL,
0x0000000103037812ULL, 0x000fe200078ef80eULL, 0x0000001007027824ULL, 0x002fe200078e00ffULL,
0x00000001ff047819ULL, 0x100fe40000011607ULL, 0x00000002ff0f7819ULL, 0x000fe40000011607ULL,
0x00000070020b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c040d7812ULL, 0x000fe200078ec0ffULL,
0x0000008003047824ULL, 0x000fe200078e00ffULL, 0x0001b0000b027810ULL, 0x000fc40007ffe000ULL,
0x0001b2000b007810ULL, 0x040fe40007ffe000ULL, 0x0001b0000b057810ULL, 0x000fe20007ffe004ULL,
0x000000010d037824ULL, 0x000fe200078e0202ULL, 0x0001b2000b047810ULL, 0x000fe20007ffe004ULL,
0x000000010d027824ULL, 0x000fe200078e0200ULL, 0x0000000411007c0cULL, 0x004fe2000bf03070ULL,
0x000000010d057824ULL, 0x040fe200078e0205ULL, 0x0000001403007388ULL, 0x000fe20000000800ULL,
0x000000010d047824ULL, 0x000fc600078e0204ULL, 0x0000001502007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000005057984ULL, 0x000e680000000800ULL,
0x0000000004047984ULL, 0x000ea20000000800ULL, 0x0000001405097209ULL, 0x002fca0007810000ULL,
0x0000001409007221ULL, 0x000fe40000010100ULL, 0x8000000905057221ULL, 0x000fe40000010000ULL,
0x3fb8aa3b00067820ULL, 0x000fe40000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x3fb8aa3b05057820ULL, 0x000fc60000410000ULL, 0x0000000600067308ULL, 0x000ef00000000800ULL,
0x0000000500057308ULL, 0x000ea20000000800ULL, 0x00001f0f06037589ULL, 0x008ee200000e0000ULL,
0x0000000800077811ULL, 0x002fe200078ff0ffULL, 0x0000000504047220ULL, 0x004fc80000410000ULL,
0x00001f0706027589ULL, 0x000e6200000e0000ULL, 0x0000001506257223ULL, 0x000fe40000010004ULL,
0x0000004c034c7220ULL, 0x048fe40000410000ULL, 0x0000004d034d7220ULL, 0x040fe40000410000ULL,
0x0000005003507220ULL, 0x040fe40000410000ULL, 0x0000005103517220ULL, 0x040fe40000410000ULL,
0x0000005403547220ULL, 0x000fc40000410000ULL, 0x0000005503557220ULL, 0x040fe40000410000ULL,
0x0000005803587220ULL, 0x040fe40000410000ULL, 0x0000005903597220ULL, 0x040fe40000410000ULL,
0x0000005c035c7220ULL, 0x040fe40000410000ULL, 0x0000005d035d7220ULL, 0x040fe40000410000ULL,
0x0000006403647220ULL, 0x000fc40000410000ULL, 0x0000006503657220ULL, 0x040fe40000410000ULL,
0x0000006003607220ULL, 0x040fe40000410000ULL, 0x0000006103617220ULL, 0x040fe40000410000ULL,
0x0000003003307220ULL, 0x040fe40000410000ULL, 0x0000003103317220ULL, 0x000fe40000410000ULL,
0x0000004e024e7220ULL, 0x002fc40000410000ULL, 0x0000004f024f7220ULL, 0x040fe40000410000ULL,
0x0000005202527220ULL, 0x040fe40000410000ULL, 0x0000005302537220ULL, 0x040fe40000410000ULL,
0x0000005602567220ULL, 0x040fe40000410000ULL, 0x0000005702577220ULL, 0x040fe40000410000ULL,
0x0000005a025a7220ULL, 0x000fc40000410000ULL, 0x0000005b025b7220ULL, 0x040fe40000410000ULL,
0x0000005e025e7220ULL, 0x040fe40000410000ULL, 0x0000005f025f7220ULL, 0x040fe40000410000ULL,
0x0000006602667220ULL, 0x040fe40000410000ULL, 0x0000006702677220ULL, 0x040fe40000410000ULL,
0x0000006202627220ULL, 0x000fc40000410000ULL, 0x0000006302637220ULL, 0x040fe40000410000ULL,
0x0000003202327220ULL, 0x040fe40000410000ULL, 0x0000003302337220ULL, 0x000fe20000410000ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x0180000025007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e0025ULL, 0x0000b4f000067802ULL, 0x000fe40000000f00ULL,
0x0000b06000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002500047308ULL, 0x000e640000001000ULL,
0xbf80000025007423ULL, 0x002fc80000000004ULL, 0x800000ff00037221ULL, 0x000fc80000010100ULL,
0x0000000304047223ULL, 0x000fe40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006700ff037624ULL, 0x000fe400078e00ffULL, 0x00006600ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000ea8000c1e9900ULL, 0x0000000000007919ULL, 0x000ee40000000000ULL,
0x00000002ff057819ULL, 0x00afe40000011600ULL, 0x0000000800077811ULL, 0x000fe200078ff0ffULL,
0x0000000403047220ULL, 0x004fca0000410000ULL, 0x00001f0504057589ULL, 0x000e6800000e0000ULL,
0x00001f0704067589ULL, 0x000ea200000e0000ULL, 0x000000054c4c7220ULL, 0x082fe40000410000ULL,
0x000000054d4d7220ULL, 0x080fe40000410000ULL, 0x0000000550507220ULL, 0x080fe40000410000ULL,
0x0000000551517220ULL, 0x000fc40000410000ULL, 0x0000000554547220ULL, 0x080fe40000410000ULL,
0x0000000555557220ULL, 0x080fe40000410000ULL, 0x0000000558587220ULL, 0x080fe40000410000ULL,
0x0000000559597220ULL, 0x080fe40000410000ULL, 0x000000055c5c7220ULL, 0x080fe40000410000ULL,
0x000000055d5d7220ULL, 0x000fc40000410000ULL, 0x0000000564647220ULL, 0x080fe40000410000ULL,
0x0000000565657220ULL, 0x080fe40000410000ULL, 0x0000000560607220ULL, 0x080fe40000410000ULL,
0x0000000561617220ULL, 0x080fe40000410000ULL, 0x0000000530307220ULL, 0x080fe40000410000ULL,
0x0000000531317220ULL, 0x000fc40000410000ULL, 0x000000064e4e7220ULL, 0x084fe40000410000ULL,
0x000000064f4f7220ULL, 0x080fe40000410000ULL, 0x0000000652527220ULL, 0x080fe40000410000ULL,
0x0000000653537220ULL, 0x080fe40000410000ULL, 0x0000000656567220ULL, 0x080fe40000410000ULL,
0x0000000657577220ULL, 0x000fc40000410000ULL, 0x000000065a5a7220ULL, 0x080fe40000410000ULL,
0x000000065b5b7220ULL, 0x080fe40000410000ULL, 0x000000065e5e7220ULL, 0x080fe40000410000ULL,
0x000000065f5f7220ULL, 0x080fe40000410000ULL, 0x0000000666667220ULL, 0x080fe40000410000ULL,
0x0000000667677220ULL, 0x000fc40000410000ULL, 0x0000000662627220ULL, 0x080fe40000410000ULL,
0x0000000663637220ULL, 0x080fe40000410000ULL, 0x0000000632327220ULL, 0x080fe40000410000ULL,
0x0000000633337220ULL, 0x000fe40000410000ULL, 0x0000000200027812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff0d7819ULL, 0x100fe20000011600ULL,
0x000000202d117824ULL, 0x000fe200078e0200ULL, 0x00000001ff047819ULL, 0x000fc40000011602ULL,
0x0000000202087811ULL, 0x040fe400078ff8ffULL, 0x00000004020c7811ULL, 0x040fe400078ff8ffULL,
0x0000000602127811ULL, 0x000fe400078ff8ffULL, 0x0000000704027812ULL, 0x040fe400078e780dULL,
0x0000000704047812ULL, 0x000fe400078e7807ULL, 0x0000000708037812ULL, 0x100fe200078e780dULL,
0x000000080d067824ULL, 0x040fe200078e0202ULL, 0x000000070c057812ULL, 0x100fe200078e780dULL,
0x00001000c6027824ULL, 0x000fe200078e00ffULL, 0x00000007120b7812ULL, 0x000fe200078e780dULL,
0x000000080d0a7824ULL, 0x000fe200078e0203ULL, 0x0000000708167812ULL, 0x100fe200078e7807ULL,
0x0000000807087824ULL, 0x000fe200078e0204ULL, 0x000000070c0c7812ULL, 0x100fe200078e7807ULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0x0000000712127812ULL, 0x000fe200078e7807ULL,
0x000000080d107824ULL, 0x000fe200078e0205ULL, 0x0000004c4d4c723eULL, 0x000fe200000010ffULL,
0x000000080d147824ULL, 0x000fe200078e020bULL, 0x0000000804057812ULL, 0x000fe200078ec0ffULL,
0x0000000807167824ULL, 0x000fe200078e0216ULL, 0x000000505126723eULL, 0x000fe200000010ffULL,
0x00000008070c7824ULL, 0x000fe200078e020cULL, 0x000000545554723eULL, 0x000fe200000010ffULL,
0x0000000807127824ULL, 0x000fe200078e0212ULL, 0x000054104c047816ULL, 0x000fe20000000026ULL,
0x000008002d037824ULL, 0x000fe200078e0202ULL, 0x00000058592a723eULL, 0x000fc400000010ffULL,
0x0000005c5d5c723eULL, 0x000fe200000010ffULL, 0x0000001006067824ULL, 0x100fe200078e0203ULL,
0x00000064652e723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x100fe200078e0203ULL,
0x000000606160723eULL, 0x000fe200000010ffULL, 0x0000001010107824ULL, 0x100fe200078e0203ULL,
0x000000303130723eULL, 0x000fe200000010ffULL, 0x0000001008087824ULL, 0x100fe200078e0203ULL,
0x0000004e4f4e723eULL, 0x000fe200000010ffULL, 0x0000001014147824ULL, 0x100fe200078e0203ULL,
0x000000525327723eULL, 0x000fe200000010ffULL, 0x0000001016167824ULL, 0x100fe200078e0203ULL,
0x000000565756723eULL, 0x000fe200000010ffULL, 0x000000100c0c7824ULL, 0x100fe200078e0203ULL,
0x0000005a5b2b723eULL, 0x000fe200000010ffULL, 0x0000001012127824ULL, 0x000fe200078e0203ULL,
0x0000005e5f5e723eULL, 0x000fe200000010ffULL, 0x0000000106067824ULL, 0x000fe200078e0205ULL,
0x00000066672f723eULL, 0x000fe200000010ffULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x000000626362723eULL, 0x000fe200000010ffULL, 0x0000000105107824ULL, 0x000fe200078e0210ULL,
0x000000323331723eULL, 0x000fe200000010ffULL, 0x0000000105087824ULL, 0x000fc400078e0208ULL,
0x0000000105147824ULL, 0x040fe400078e0214ULL, 0x0000000105167824ULL, 0x040fe400078e0216ULL,
0x00000001050c7824ULL, 0x040fe400078e020cULL, 0x0000000105127824ULL, 0x000fe200078e0212ULL,
0x000076324c057816ULL, 0x000fe40000000026ULL, 0x000054104e267816ULL, 0x140fe40000000027ULL,
0x000076324e277816ULL, 0x000fe20000000027ULL, 0x0000000406007388ULL, 0x0003e40000000a00ULL,
0x0000541054047816ULL, 0x142fe2000000002aULL, 0x000000ff00067306ULL, 0x000fe20000209400ULL,
0x0000763254057816ULL, 0x000fc4000000002aULL, 0x00005410562a7816ULL, 0x140fe4000000002bULL,
0x00007632562b7816ULL, 0x000fe2000000002bULL, 0x000000040a007388ULL, 0x0003e40000000a00ULL,
0x000054105c047816ULL, 0x142fe4000000002eULL, 0x000076325c057816ULL, 0x000fe4000000002eULL,
0x000054105e2e7816ULL, 0x140fe4000000002fULL, 0x000076325e2f7816ULL, 0x000fe2000000002fULL,
0x0000000410007388ULL, 0x0003e40000000a00ULL, 0x0000541060047816ULL, 0x002fc40000000030ULL,
0x0000763260057816ULL, 0x000fe40000000030ULL, 0x0000541062307816ULL, 0x140fe40000000031ULL,
0x0000763262317816ULL, 0x000fe20000000031ULL, 0x0000000414007388ULL, 0x0003e80000000a00ULL,
0x0000002608007388ULL, 0x0005e80000000a00ULL, 0x0000002a16007388ULL, 0x000fe80000000a00ULL,
0x0000002e0c007388ULL, 0x000fe20000000a00ULL, 0x000000ff00057306ULL, 0x002e660000205400ULL,
0x0000003012007388ULL, 0x000fe20000000a00ULL, 0x0000001011087824ULL, 0x004fc600078e0202ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff00047306ULL, 0x000ea2000020d400ULL,
0x000000050600720bULL, 0x002fda0003f1d000ULL, 0x0000000104040812ULL, 0x004fe200078efcffULL,
0x00040000081c7984ULL, 0x000e660000000c00ULL, 0x00000004040a723eULL, 0x000fe200000010ffULL,
0x000c000008207984ULL, 0x000ea80000000c00ULL, 0x0000000008147984ULL, 0x000ee80000000c00ULL,
0x0008000008187984ULL, 0x000f220000000c00ULL, 0x3f803f800a1c7831ULL, 0x002fc4000020001cULL,
0x3f803f800a1f7831ULL, 0x000fe4000020001fULL, 0x3f803f801c1c7831ULL, 0x004fe20000200020ULL,
0x00000300ff207624ULL, 0x000fe200078e00ffULL, 0x3f803f800a1e7831ULL, 0x040fe4000020001eULL,
0x3f803f800a177831ULL, 0x048fe40000200017ULL, 0x000000012000780cULL, 0x000fe20003f05270ULL,
0x3f803f800a167831ULL, 0x040fe40000200016ULL, 0x3f803f800a157831ULL, 0x000fc40000200015ULL,
0x3f803f800a147831ULL, 0x040fe40000200014ULL, 0x3f803f800a1d7831ULL, 0x000fe4000020001dULL,
0x3f803f8017177831ULL, 0x010fe4000020001bULL, 0x3f803f8016167831ULL, 0x000fe4000020001aULL,
0x3f803f8015157831ULL, 0x000fe40000200019ULL, 0x3f803f8014147831ULL, 0x000fc40000200018ULL,
0x3f803f801f1f7831ULL, 0x000fe40000200023ULL, 0x3f803f801e1e7831ULL, 0x000fe20000200022ULL,
0x0000001408007388ULL, 0x0003e20000000c00ULL, 0x3f803f801d1d7831ULL, 0x000fca0000200021ULL,
0x0004001c08007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000306000008947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x000ea20000002700ULL,
0x0000580020057a24ULL, 0x000fe200078e02ffULL, 0x000000012dff7812ULL, 0x000fe2000780f80eULL,
0x00001000ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000000067919ULL, 0x000ea20000002600ULL,
0x00006400050c7a24ULL, 0x000fe200078e02ffULL, 0x0000004011137810ULL, 0x000fe20007ffe0ffULL,
0x00000800c6077824ULL, 0x000fe200078e00ffULL, 0x0000000008147984ULL, 0x002e640000000c00ULL,
0x00000fff0c057811ULL, 0x000fc400078e40ffULL, 0x0004000008187984ULL, 0x0007240000000c00ULL,
0x01ffffff0c087812ULL, 0x008fe200078ec0ffULL, 0x000058000f0f7a24ULL, 0x004fc800078e0206ULL,
0x000003000f067a24ULL, 0x000fca00078e02ffULL, 0x00000004060d7c10ULL, 0x000fc8000fffe0ffULL,
0x0000000d050a7211ULL, 0x000fca00078fa0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000bULL,
0x000000070a0a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x000000ff0000720cULL, 0x000fc60000725670ULL, 0x0000001011107825ULL, 0x000fc800078e000aULL,
0x0000001013127825ULL, 0x000fe200078e000aULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010000a7824ULL, 0x012fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011600ULL,
0x00000080ff1c7424ULL, 0x000fe400078e00ffULL, 0x000000010d0c7824ULL, 0x000fe200078e0208ULL,
0x000000700a1d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b1e7812ULL, 0x000fe200078ec0ffULL,
0x00006a000d0a7625ULL, 0x000fc800078e001cULL, 0x00006a000c0c7625ULL, 0x000fe200078e001cULL,
0x0000000a1e0a7210ULL, 0x000fc80007a1e01dULL, 0x0000000c1e0c7210ULL, 0x000fe40007c7e01dULL,
0x0000000bff0b7210ULL, 0x000fe400007e44ffULL, 0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL,
0x000000090a007986ULL, 0x0003e8000c101906ULL, 0x000000250c007986ULL, 0x0003e4000c101906ULL,
0x0000001410007986ULL, 0x0123e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x0000001812007986ULL, 0x0003e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0a7424ULL, 0x000fe200078e00ffULL,
0xffffffff20097810ULL, 0x000fc60007ffe0ffULL, 0x000068000f0a7625ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x000000090a0a79a8ULL, 0x000ea400099ee1c6ULL, 0x000000090a00720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0c7807ULL, 0x000fca0000000000ULL,
0x0000000cff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff097984ULL, 0x000ee40000000000ULL,
0x000000ff0900720cULL, 0x008fda0003f05270ULL, 0x00002c9000008947ULL, 0x000fea0003800000ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff0a7819ULL, 0x000fe20000011600ULL, 0x0000001000097824ULL, 0x000fe200078e00ffULL,
0x00000001060c7810ULL, 0x004fe20007ffe0ffULL, 0x00000080ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000c0a137812ULL, 0x002fe400078ec0ffULL, 0x0000007009117812ULL, 0x000fe200078ec0ffULL,
0x00006a00060a7625ULL, 0x000fc800078e000fULL, 0x00006a000c0c7625ULL, 0x000fe200078e000fULL,
0x0000000a130a7210ULL, 0x000fc8000791e011ULL, 0x0000000c130c7210ULL, 0x000fe40007b5e011ULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x000000060a097981ULL, 0x000368000c1e1900ULL, 0x000000060c107981ULL, 0x000362000c1e1900ULL,
0x000000022000780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002060a7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a130a7210ULL, 0x000fc8000791e011ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a127981ULL, 0x000362000c1e1900ULL, 0x000000042000780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003060a7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a130a7210ULL, 0x000fc8000791e011ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a147981ULL, 0x000362000c1e1900ULL,
0x000000042000780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004060a7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a130a7210ULL, 0x000fc8000791e011ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a167981ULL, 0x000362000c1e1900ULL, 0x000000062000780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005060a7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a130a7210ULL, 0x000fc8000791e011ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a187981ULL, 0x000362000c1e1900ULL,
0x000000062000780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000082000780cULL, 0x002fe40003f06070ULL, 0x00000006060a7810ULL, 0x000fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a130a7210ULL, 0x000fe40007a3e011ULL,
0x00000007060c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006a000c0c0625ULL, 0x000fe400078e000fULL, 0x000000060a1a7981ULL, 0x000366000c1e1900ULL,
0x0000000c130c0210ULL, 0x000fc80007c7e011ULL, 0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL,
0x000000060c1c0981ULL, 0x000368000c1e1900ULL, 0x00000007200a7810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0c7819ULL, 0x004fc8000001160aULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x020fe400078e0009ULL, 0x000000080d0f7824ULL, 0x040fe200078e00ffULL,
0x000000010d0d7810ULL, 0x000fc80007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x0000000c0d00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080f0b7810ULL, 0x040fe40007ffe0ffULL, 0x000000010f0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001e09097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff137819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a1e7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090f0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000020f0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001009097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff137819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007010117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a107981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0f0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000030f0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001209097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a127981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0f0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000040f0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001409097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff137819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a147981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0f0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000050f0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001609097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff137819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a167981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0f0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000060f0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001809097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff137819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a187981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0f0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000070f0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001a09097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff137819ULL, 0x000fe20000011600ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a1a7981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0f0f7810ULL, 0x000fe40007ffe0ffULL,
0x0000001c09097209ULL, 0x000fe40007810000ULL, 0x000003000f007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x002fe200078e020fULL,
0x00000001ff117819ULL, 0x000fe20000011600ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010000f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007a3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000060a1c7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x00000010000a7824ULL, 0x006fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011600ULL, 0x000000700a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL, 0x000000010b0a7824ULL, 0x000fca00078e020aULL,
0x000000090a007388ULL, 0x0203e40000000800ULL, 0x000000012d147824ULL, 0x002fe200078e0206ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x00000010000b7824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000001ff0c7819ULL, 0x004fe20000011600ULL,
0x00001000ff0f7424ULL, 0x000fe200078e00ffULL, 0x00000014050a7211ULL, 0x000fe200078fa0ffULL,
0x000020002d197824ULL, 0x000fe200078e0202ULL, 0x000000700b0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000002ff097819ULL, 0x000fe2000001160eULL,
0x00006a000a0a7625ULL, 0x000fe200078e000fULL, 0x0000000c0c107812ULL, 0x000fe200078ec0ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000109097812ULL, 0x000fe200078ec0ffULL,
0x000002000e0e7824ULL, 0x000fe200078e00ffULL, 0x000000070a0a7210ULL, 0x000fe20007f3e0ffULL,
0x00000001102a7824ULL, 0x000fe200078e020dULL, 0x00000020000d7810ULL, 0x000fe20007ffe0ffULL,
0x000000022d0c8824ULL, 0x140fe200078e02c6ULL, 0x000008000e0e7812ULL, 0x000fe200078ec0ffULL,
0x000000022d108824ULL, 0x040fe200078e02c6ULL, 0x00000040000f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108128824ULL, 0x000fe200078e0214ULL, 0x0000006000117810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff138424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000020c1b8824ULL, 0x100fe200078e0209ULL, 0x000000002a2a7984ULL, 0x000e620000000800ULL,
0x00000002101d8824ULL, 0x000fe200078e0209ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x000003002d007a0cULL, 0x000fe20003f26070ULL,
0x00000080ff158424ULL, 0x000fc400078e00ffULL, 0x0000000119097824ULL, 0x000fe400078e020eULL,
0x00006a0012128625ULL, 0x000fc800078e0013ULL, 0x000000100d0c7825ULL, 0x000fc800078e000aULL,
0x000000100f0e7825ULL, 0x000fc800078e000aULL, 0x0000001011107825ULL, 0x000fc800078e000aULL,
0x00006a0014148625ULL, 0x000fc800078e0015ULL, 0x000000081b1b8824ULL, 0x000fe400078e0200ULL,
0x0000001000177824ULL, 0x040fe400078e0209ULL, 0x00000010000a7825ULL, 0x040fe200078e000aULL,
0x000045801b1f8811ULL, 0x000fe400078e20ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000081d1d8824ULL, 0x000fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a177faeULL, 0x0005e2000b901c46ULL, 0x0000001000128825ULL, 0x000fc600078e0012ULL,
0x000041801d218811ULL, 0x000fe200078e20ffULL, 0x0000001000148825ULL, 0x000fe200078e0014ULL,
0x003800000c177faeULL, 0x0007e2000b901c46ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x005800000e177faeULL, 0x0009e2000b901c46ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x004fe2000001ff00ULL,
0x000000ffff2b7224ULL, 0x000fe200078e00ffULL, 0x0078000010177faeULL, 0x0005e8000b901c46ULL,
0x00000000121f8faeULL, 0x000be2000b901c46ULL, 0x00000000000c7805ULL, 0x008fc6000001ff00ULL,
0x0000000014218faeULL, 0x0007e2000b901c46ULL, 0x00000000000e7805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000107805ULL, 0x004fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x020fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x008fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000e0000001947ULL, 0x000fea0003800000ULL,
0x00000df000007945ULL, 0x002fe20003800000ULL, 0x000000ffff097224ULL, 0x000fe400078e00ffULL,
0x000000ffff2c7224ULL, 0x000fca00078e002dULL, 0x000000022c3b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff457224ULL, 0x000fe200078e002cULL, 0x00000002ff5b7819ULL, 0x002fe20000011600ULL,
0x000000022d437824ULL, 0x000fe200078e02c6ULL, 0x000003003b007a0cULL, 0x000fe20003f06070ULL,
0x00000040452e7824ULL, 0x000fe200078e00ffULL, 0x000000075b2f7812ULL, 0x040fe200078ec0ffULL,
0x000000085b3a7824ULL, 0x040fe200078e00ffULL, 0x0000005bff487212ULL, 0x000fe200078e33ffULL,
0x000000085b2c7824ULL, 0x040fe200078e00ffULL, 0x000000802e2e7812ULL, 0x000fe200078ec0ffULL,
0x000000085b317824ULL, 0x000fe200078e00ffULL, 0x0000039000017945ULL, 0x000fe20003800000ULL,
0xfffffff83a3a7812ULL, 0x100fe200078ee22fULL, 0x0000001000497824ULL, 0x000fe200078e00ffULL,
0x000000012c3c7812ULL, 0x140fe200078ef62fULL, 0x0000010043437824ULL, 0x000fe200078e002eULL,
0x000000022c3e7812ULL, 0x000fc400078ef62fULL, 0x000000032c407812ULL, 0x140fe400078ef62fULL,
0x000000042c427812ULL, 0x140fe400078ef62fULL, 0x000000052c447812ULL, 0x140fe400078ef62fULL,
0x000000062c467812ULL, 0x000fe400078ef62fULL, 0xfffffff831487812ULL, 0x000fe400078ee248ULL,
0x000000085b5d7810ULL, 0x008fe20007ffe0ffULL, 0x000002c000000947ULL, 0x000fea0003800000ULL,
0x0000000106387824ULL, 0x100fe200078e023bULL, 0x000000070000780cULL, 0x000fe20003f24070ULL,
0x00001000ff2f7424ULL, 0x000fe200078e00ffULL, 0x00000001ff2c7819ULL, 0x000fc4000001163bULL,
0x00000038052e7211ULL, 0x000fe400078fa0ffULL, 0x000000012c307812ULL, 0x000fe200078ec0ffULL,
0x000004003b2c7824ULL, 0x000fe200078e00ffULL, 0x0000002000337810ULL, 0x000fe20007ffe0ffULL,
0x00006a002e2e7625ULL, 0x000fe200078e002fULL, 0x0000004000357810ULL, 0x000fe40007ffe0ffULL,
0x000008002c2c7812ULL, 0x000fe200078ec0ffULL, 0x000000022d319824ULL, 0x140fe200078e02c6ULL,
0x000000072e2e7210ULL, 0x000fe20007f1e0ffULL, 0x000000022d3f9824ULL, 0x000fe200078e02c6ULL,
0x0000006000417810ULL, 0x000fe20007ffe0ffULL, 0x0000000231479824ULL, 0x000fc400078e0230ULL,
0x0000000119317824ULL, 0x000fe400078e022cULL, 0x000000ffff2f7224ULL, 0x000fe400000e062fULL,
0x0000000108369824ULL, 0x000fe400078e0238ULL, 0x00000080ff379424ULL, 0x000fe400078e00ffULL,
0x000000023f3f9824ULL, 0x000fe400078e0230ULL, 0x00000080ff399424ULL, 0x000fc400078e00ffULL,
0x00000010003d7824ULL, 0x000fe400078e0231ULL, 0x00006a0036369625ULL, 0x000fc800078e0037ULL,
0x0000001000307825ULL, 0x000fc800078e002eULL, 0x0000001033327825ULL, 0x100fe200078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000303d7faeULL, 0x0003e6000b901c46ULL,
0x0000001035347825ULL, 0x100fe200078e002eULL, 0x00380000323d7faeULL, 0x0003e6000b901c46ULL,
0x00006a0038389625ULL, 0x000fe200078e0039ULL, 0x00580000343d7faeULL, 0x0003e6000b901c46ULL,
0x00000010412e7825ULL, 0x000fc800078e002eULL, 0x000000083f3f9824ULL, 0x100fe200078e0200ULL,
0x007800002e3d7faeULL, 0x0003e2000b901c46ULL, 0x0000000847419824ULL, 0x000fe400078e0200ULL,
0x0000001000369825ULL, 0x040fe200078e0036ULL, 0x000045803f3f9811ULL, 0x000fe400078e20ffULL,
0x0000418041419811ULL, 0x000fe200078e20ffULL, 0x0000001000389825ULL, 0x000fe400078e0038ULL,
0x00000000363f9faeULL, 0x0003e8000b901c46ULL, 0x0000000038419faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000001ff307819ULL, 0x002fe20000011600ULL, 0x000000085d337824ULL, 0x000fe200078e00ffULL,
0x00000070494e7812ULL, 0x000fe200078ec0ffULL, 0x00000400452c7824ULL, 0x000fe200078e00ffULL,
0x0000000c30317812ULL, 0x000fe200078ec0ffULL, 0x000000085d2f7824ULL, 0x040fe200078e00ffULL,
0x000000075d2e7812ULL, 0x000fc400078ec0ffULL, 0x0000004331437210ULL, 0x000fe20007ffe04eULL,
0x000000085d4e7824ULL, 0x000fe200078e00ffULL, 0xfffffff833307812ULL, 0x100fe400078ee22eULL,
0x000008002c2c7812ULL, 0x000fe400078ec0ffULL, 0x000000012f327812ULL, 0x140fe400078ef62eULL,
0x000000022f347812ULL, 0x140fe400078ef62eULL, 0x000000032f367812ULL, 0x000fc400078ef62eULL,
0x000000042f387812ULL, 0x140fe400078ef62eULL, 0x000000052f4a7812ULL, 0x000fe200078ef62eULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800043337984ULL, 0x000fe20000000800ULL,
0x000000062f4c7812ULL, 0x000fe200078ef62eULL, 0x00000004002e7824ULL, 0x000fe200078e00ffULL,
0x0000005dff317212ULL, 0x000fe400078e33ffULL, 0x00000180192f7810ULL, 0x000fe40007ffe02cULL,
0xfffffff84e2c7812ULL, 0x000fe400078ee231ULL, 0x0000000c2e317812ULL, 0x000fe200078ec0ffULL,
0x000000103a3a7824ULL, 0x100fe200078e022fULL, 0x00458000432e7984ULL, 0x000fe20000000800ULL,
0x000000103c3c7824ULL, 0x000fc400078e022fULL, 0x000000103e3e7824ULL, 0x100fe400078e022fULL,
0x0000001040407824ULL, 0x100fe400078e022fULL, 0x0000001042427824ULL, 0x000fe400078e022fULL,
0x000000013a3a7824ULL, 0x000fe400078e0231ULL, 0x0000001044447824ULL, 0x000fe400078e022fULL,
0x00000001313c7824ULL, 0x000fc400078e023cULL, 0x0000001046467824ULL, 0x100fe200078e022fULL,
0x000000003a3a7984ULL, 0x000e620000000800ULL, 0x00000001313e7824ULL, 0x000fe400078e023eULL,
0x0000001030307824ULL, 0x100fe200078e022fULL, 0x000000003c3c7984ULL, 0x000ea20000000800ULL,
0x0000001032327824ULL, 0x100fe400078e022fULL, 0x0000001034347824ULL, 0x100fe200078e022fULL,
0x000000003e3e7984ULL, 0x000ee20000000800ULL, 0x0000001036367824ULL, 0x000fc400078e022fULL,
0x0000001038387824ULL, 0x100fe400078e022fULL, 0x000000104a4a7824ULL, 0x100fe400078e022fULL,
0x000000104c4c7824ULL, 0x100fe400078e022fULL, 0x0000001048487824ULL, 0x100fe400078e022fULL,
0x0000000131407824ULL, 0x000fe400078e0240ULL, 0x000000102c2c7824ULL, 0x000fc400078e022fULL,
0x0000000131427824ULL, 0x040fe400078e0242ULL, 0x0000000131447824ULL, 0x040fe200078e0244ULL,
0x0000000040407984ULL, 0x000f220000000800ULL, 0x0000000131467824ULL, 0x040fe400078e0246ULL,
0x0000000131487824ULL, 0x040fe200078e0248ULL, 0x0000000042427984ULL, 0x000f620000000800ULL,
0x0000000131307824ULL, 0x040fe400078e0230ULL, 0x0000000131327824ULL, 0x040fe200078e0232ULL,
0x0000000044447984ULL, 0x000f620000000800ULL, 0x0000000131347824ULL, 0x000fc400078e0234ULL,
0x0000000131367824ULL, 0x040fe200078e0236ULL, 0x0000000046467984ULL, 0x000f620000000800ULL,
0x0000000131387824ULL, 0x040fe200078e0238ULL, 0x00005410ff377816ULL, 0x002fe2000000003aULL,
0x00000001314a7824ULL, 0x040fe200078e024aULL, 0x0000000048487984ULL, 0x000e620000000800ULL,
0x00000001314c7824ULL, 0x040fe200078e024cULL, 0x00007610ff397816ULL, 0x000fe2000000003aULL,
0x0000000131317824ULL, 0x000fe200078e022cULL, 0x0000000036367984ULL, 0x000e620000000800ULL,
0x000000332a337221ULL, 0x000fe20000010100ULL, 0x00005410ff3a7816ULL, 0x104fe2000000003cULL,
0x000000ffff2c7224ULL, 0x000fe200078e003bULL, 0x0000000038387984ULL, 0x000ea20000000800ULL,
0x3fb8aa3b33337820ULL, 0x000fe20000410000ULL, 0x00007610ff3b7816ULL, 0x000fc4000000003cULL,
0x000000004a4a7984ULL, 0x000ea20000000800ULL, 0x00005410ff3c7816ULL, 0x108fe4000000003eULL,
0x0000003300337308ULL, 0x000ee20000000800ULL, 0x000000004c4c7984ULL, 0x000ea20000000800ULL,
0x00007610ff3d7816ULL, 0x000fe4000000003eULL, 0x000003002c007a0cULL, 0x000fe20003f06070ULL,
0x0000000030307984ULL, 0x000ea80000000800ULL, 0x0000000032327984ULL, 0x000ea20000000800ULL,
0x00005410ff3e7816ULL, 0x010fc40000000040ULL, 0x00007610ff3f7816ULL, 0x000fe20000000040ULL,
0x0000000034347984ULL, 0x000f220000000800ULL, 0x00005410ff407816ULL, 0x120fe20000000042ULL,
0x0000002e33527220ULL, 0x008fe40000410000ULL, 0x0000000031317984ULL, 0x000ee20000000800ULL,
0x00007610ff417816ULL, 0x000fe40000000042ULL, 0x00005410ff427816ULL, 0x100fe20000000044ULL,
0x0000002b522b7221ULL, 0x000fe20000010000ULL, 0x00007610ff437816ULL, 0x000fc40000000044ULL,
0x00005410ff447816ULL, 0x100fe40000000046ULL, 0x00007610ff457816ULL, 0x000fe40000000046ULL,
0x00005410ff467816ULL, 0x102fe40000000048ULL, 0x00007610ff477816ULL, 0x000fe40000000048ULL,
0x00005410ff517816ULL, 0x000fe40000000036ULL, 0x00005410ff537816ULL, 0x004fc40000000038ULL,
0x00007610ff367816ULL, 0x000fe40000000036ULL, 0x00005410ff557816ULL, 0x000fe4000000004aULL,
0x00007610ff387816ULL, 0x000fe40000000038ULL, 0x00005410ff577816ULL, 0x000fe4000000004cULL,
0x00007610ff4a7816ULL, 0x000fe4000000004aULL, 0x00005410ff497816ULL, 0x000fc40000000030ULL,
0x00007610ff487816ULL, 0x000fe40000000030ULL, 0x00005410ff4b7816ULL, 0x100fe40000000032ULL,
0x00007610ff4d7816ULL, 0x000fe40000000032ULL, 0x00005410ff4f7816ULL, 0x110fe40000000034ULL,
0x00007610ff4e7816ULL, 0x000fe40000000034ULL, 0x00007610ff4c7816ULL, 0x000fc4000000004cULL,
0x00005410ff597816ULL, 0x108fe40000000031ULL, 0x00007610ff507816ULL, 0x000fe20000000031ULL,
0x00007e827f007947ULL, 0x000fea000b800000ULL, 0x00001f5b52307589ULL, 0x0002a400000e0000ULL,
0x00007ee27f007947ULL, 0x000fea000b800000ULL, 0x00001f5d522e7589ULL, 0x00072400000e0000ULL,
0x0000003037297223ULL, 0x084fe40000010029ULL, 0x0000003039287223ULL, 0x080fe40000010028ULL,
0x000000303a277223ULL, 0x080fe40000010027ULL, 0x000000303b267223ULL, 0x080fe40000010026ULL,
0x000000303c257223ULL, 0x000fc40000010025ULL, 0x000000303d247223ULL, 0x080fe40000010024ULL,
0x000000303e237223ULL, 0x080fe40000010023ULL, 0x000000303f227223ULL, 0x080fe40000010022ULL,
0x0000003040217223ULL, 0x080fe40000010021ULL, 0x0000003041207223ULL, 0x080fe40000010020ULL,
0x00000030421f7223ULL, 0x000fc4000001001fULL, 0x00000030431e7223ULL, 0x080fe4000001001eULL,
0x00000030441d7223ULL, 0x080fe4000001001dULL, 0x00000030451c7223ULL, 0x080fe4000001001cULL,
0x00000030461b7223ULL, 0x080fe4000001001bULL, 0x00000030471a7223ULL, 0x000fe4000001001aULL,
0x0000002e49187223ULL, 0x010fc40000010018ULL, 0x0000002e48177223ULL, 0x080fe40000010017ULL,
0x0000002e4b167223ULL, 0x080fe40000010016ULL, 0x0000002e4d157223ULL, 0x080fe40000010015ULL,
0x0000002e4f147223ULL, 0x080fe40000010014ULL, 0x0000002e4e137223ULL, 0x080fe40000010013ULL,
0x0000002e51127223ULL, 0x000fc40000010012ULL, 0x0000002e36117223ULL, 0x080fe40000010011ULL,
0x0000002e53107223ULL, 0x080fe40000010010ULL, 0x0000002e380f7223ULL, 0x080fe4000001000fULL,
0x0000002e550e7223ULL, 0x080fe4000001000eULL, 0x0000002e4a0d7223ULL, 0x080fe4000001000dULL,
0x0000002e570c7223ULL, 0x000fc4000001000cULL, 0x0000002e4c0b7223ULL, 0x080fe4000001000bULL,
0x0000002e590a7223ULL, 0x080fe4000001000aULL, 0x0000002e50097223ULL, 0x000fe20000010009ULL,
0xfffff24000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x002e620000000000ULL, 0x000000ffc600720cULL, 0x000fe20003f05270ULL,
0x0000001000057824ULL, 0x002fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fc80000011600ULL,
0x0000007005057812ULL, 0x000fe400078ec0ffULL, 0x0000000c00007812ULL, 0x000fca00078ec0ffULL,
0x0000000100077824ULL, 0x000fe200078e0205ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e640000000000ULL, 0x0000001000057824ULL, 0x002fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fc80000011600ULL, 0x0000007005007812ULL, 0x000fe400078ec0ffULL,
0x0000000c06057812ULL, 0x000fc600078ec0ffULL, 0x000000802d007824ULL, 0x000fc800078e0200ULL,
0x0000000100007824ULL, 0x000fca00078e0205ULL, 0x0049802b00007388ULL, 0x0003e40000000800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800007007984ULL, 0x002e680000000800ULL,
0x004a000007057984ULL, 0x000ea20000000800ULL, 0x00000000ff007221ULL, 0x002fc80000010000ULL,
0x0000000500007221ULL, 0x004fca0000010000ULL, 0x0180000000057810ULL, 0x000fc80007ffe0ffULL,
0x7f80000005057812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0500780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e0000ULL, 0x0000e4d000067802ULL, 0x000fe40000000f00ULL,
0x0000808000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff057224ULL, 0x00efe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000057308ULL, 0x000e640000001000ULL,
0xbf80000000067423ULL, 0x002fc80000000005ULL, 0x800000ff06067221ULL, 0x000fc80000010100ULL,
0x0000000605057223ULL, 0x000fe40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e680000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000800307811ULL, 0x002fe400078ff0ffULL, 0x00000002ff2a7819ULL, 0x000fe40000011600ULL,
0x00000030ff327212ULL, 0x000fe200078e33ffULL, 0x00001f3005077589ULL, 0x000e6200000e0000ULL,
0x0000000830197824ULL, 0x000fc400078e00ffULL, 0x000000082a347824ULL, 0x000fe200078e00ffULL,
0x00001f2a05067589ULL, 0x00052400000e0000ULL, 0xfffffff819327812ULL, 0x000fca00078ee232ULL,
0x0000001032327824ULL, 0x000fe200078e0203ULL, 0x0000002aff057212ULL, 0x004fc800078e33ffULL,
0xfffffff834347812ULL, 0x000fe400078ee205ULL, 0x000000072a057812ULL, 0x000fe200078ec0ffULL,
0x0000001807187220ULL, 0x002fc60000410000ULL, 0x0000000205197812ULL, 0x000fe200078e3cffULL,
0x0000001707177220ULL, 0x040fe40000410000ULL, 0x0000001607167220ULL, 0x040fe40000410000ULL,
0x0000001507157220ULL, 0x000fe20000410000ULL, 0x000000181717723eULL, 0x000fe200000010ffULL,
0x0000001407147220ULL, 0x040fe20000410000ULL, 0x0000000730187812ULL, 0x000fe200078ec0ffULL,
0x0000001307137220ULL, 0x000fe20000410000ULL, 0x000000161515723eULL, 0x000fe200000010ffULL,
0x0000001207127220ULL, 0x000fc40000410000ULL, 0x0000001107117220ULL, 0x000fe20000410000ULL,
0x000000141313723eULL, 0x000fe200000010ffULL, 0x0000001007107220ULL, 0x040fe40000410000ULL,
0x0000000f070f7220ULL, 0x000fe20000410000ULL, 0x000000121111723eULL, 0x000fe200000010ffULL,
0x0000000e070e7220ULL, 0x040fe40000410000ULL, 0x0000000d070d7220ULL, 0x000fe20000410000ULL,
0x000000100f0f723eULL, 0x000fe200000010ffULL, 0x0000000c070c7220ULL, 0x000fc40000410000ULL,
0x0000000b070b7220ULL, 0x000fe20000410000ULL, 0x0000000e0d0d723eULL, 0x000fe200000010ffULL,
0x0000000a070a7220ULL, 0x000fe40000410000ULL, 0x0000002906297220ULL, 0x050fe20000410000ULL,
0x0000000c0b0b723eULL, 0x000fe200000010ffULL, 0x0000002806287220ULL, 0x040fe40000410000ULL,
0x0000002706277220ULL, 0x040fe40000410000ULL, 0x0000002606267220ULL, 0x000fe20000410000ULL,
0x000000292828723eULL, 0x000fe200000010ffULL, 0x0000002506257220ULL, 0x000fc40000410000ULL,
0x0000002406247220ULL, 0x000fe20000410000ULL, 0x000000272626723eULL, 0x000fe200000010ffULL,
0x0000002306237220ULL, 0x040fe40000410000ULL, 0x0000002206227220ULL, 0x000fe20000410000ULL,
0x000000252424723eULL, 0x000fe200000010ffULL, 0x0000002106217220ULL, 0x040fe40000410000ULL,
0x0000002006207220ULL, 0x000fe20000410000ULL, 0x000000232222723eULL, 0x000fe200000010ffULL,
0x0000001f061f7220ULL, 0x000fc40000410000ULL, 0x0000001e061e7220ULL, 0x000fe20000410000ULL,
0x000000212020723eULL, 0x000fe200000010ffULL, 0x0000001d061d7220ULL, 0x040fe40000410000ULL,
0x0000001c061c7220ULL, 0x000fe20000410000ULL, 0x0000001f1e1e723eULL, 0x000fe200000010ffULL,
0x0000001b061b7220ULL, 0x000fe20000410000ULL, 0x00000005051f7812ULL, 0x000fe200078e3cffULL,
0x0000000907077220ULL, 0x000fe20000410000ULL, 0x0000001d1c1c723eULL, 0x000fe200000010ffULL,
0x0000001a06067220ULL, 0x000fe20000410000ULL, 0x00000004051d7812ULL, 0x000fe200078e3cffULL,
0x000000082a097824ULL, 0x000fe200078e00ffULL, 0x0000000a0707723eULL, 0x000fe200000010ffULL,
0x0000000830237824ULL, 0x000fe200078e00ffULL, 0x0000001b0606723eULL, 0x000fe200000010ffULL,
0x000000082a0c7824ULL, 0x040fe200078e0219ULL, 0xfffffff809087812ULL, 0x000fe200078ee22aULL,
0x000000082a107824ULL, 0x040fe200078e021dULL, 0x0000000105097812ULL, 0x040fe200078e3cffULL,
0x000000082a127824ULL, 0x000fe200078e021fULL, 0x00000003051b7812ULL, 0x040fe200078e3cffULL,
0x0000000400217824ULL, 0x000fe200078e00ffULL, 0x0000000605057812ULL, 0x000fe200078e3cffULL,
0x000000082a0a7824ULL, 0x000fe200078e0209ULL, 0x0000000218097812ULL, 0x000fe200078e3cffULL,
0x000000082a0e7824ULL, 0x000fe200078e021bULL, 0x0000000318197812ULL, 0x000fe200078e3cffULL,
0x000000082a147824ULL, 0x000fe200078e0205ULL, 0x0000000118057812ULL, 0x000fe200078e3cffULL,
0x00000008301a7824ULL, 0x000fe200078e0209ULL, 0x00000004181b7812ULL, 0x000fe200078e3cffULL,
0x00000008302a7824ULL, 0x000fe200078e0219ULL, 0x00000005181d7812ULL, 0x000fe200078e3cffULL,
0x0000001008087824ULL, 0x000fe200078e0203ULL, 0x00000006181f7812ULL, 0x000fe200078e3cffULL,
0x0000000830187824ULL, 0x040fe200078e0205ULL, 0xfffffff823167812ULL, 0x000fe200078ee230ULL,
0x00000008302c7824ULL, 0x040fe200078e021bULL, 0x0000000c21237812ULL, 0x000fe200078ec0ffULL,
0x00000008302e7824ULL, 0x000fc400078e021dULL, 0x0000000830307824ULL, 0x000fe400078e021fULL,
0x0000001034097824ULL, 0x100fe400078e0203ULL, 0x000000100a0a7824ULL, 0x100fe400078e0203ULL,
0x000000100c0c7824ULL, 0x100fe400078e0203ULL, 0x000000100e0e7824ULL, 0x100fe400078e0203ULL,
0x0000001016167824ULL, 0x000fc400078e0203ULL, 0x0000000123057824ULL, 0x000fe400078e0208ULL,
0x0000001010107824ULL, 0x100fe400078e0203ULL, 0x0000001012127824ULL, 0x100fe200078e0203ULL,
0x0000002805007388ULL, 0x0003e20000000800ULL, 0x0000001014147824ULL, 0x100fe400078e0203ULL,
0x0000001018187824ULL, 0x100fe400078e0203ULL, 0x000000101a1a7824ULL, 0x000fc400078e0203ULL,
0x000000102a2a7824ULL, 0x100fe400078e0203ULL, 0x000000102c2c7824ULL, 0x100fe400078e0203ULL,
0x000000102e2e7824ULL, 0x100fe400078e0203ULL, 0x0000001030307824ULL, 0x000fe400078e0203ULL,
0x0000000123217824ULL, 0x040fe400078e0209ULL, 0x0000000123037824ULL, 0x000fc400078e020aULL,
0x0000000123097824ULL, 0x040fe400078e020cULL, 0x0000000123197824ULL, 0x040fe200078e020eULL,
0x0000002603007388ULL, 0x000fe20000000800ULL, 0x00000001231b7824ULL, 0x040fe200078e0210ULL,
0x00000004040e723eULL, 0x000fe200000010ffULL, 0x00000001231d7824ULL, 0x040fe200078e0212ULL,
0x0000002409007388ULL, 0x000fe20000000800ULL, 0x00000001231f7824ULL, 0x040fe400078e0214ULL,
0x0000000123167824ULL, 0x040fe200078e0216ULL, 0x0000002219007388ULL, 0x000fe20000000800ULL,
0x0000000123187824ULL, 0x000fc400078e0218ULL, 0x00000001231a7824ULL, 0x040fe200078e021aULL,
0x000000201b007388ULL, 0x000fe20000000800ULL, 0x00000001232a7824ULL, 0x040fe400078e022aULL,
0x00000001232c7824ULL, 0x040fe200078e022cULL, 0x0000001e1d007388ULL, 0x000fe20000000800ULL,
0x00000001232e7824ULL, 0x040fe400078e022eULL, 0x0000000123307824ULL, 0x040fe200078e0230ULL,
0x0000001c1f007388ULL, 0x000fe20000000800ULL, 0x0000000123327824ULL, 0x000fc400078e0232ULL,
0x000000202d057824ULL, 0x002fe200078e0200ULL, 0x0000000621007388ULL, 0x000fe60000000800ULL,
0x0000001005057824ULL, 0x000fe200078e0202ULL, 0x0000001716007388ULL, 0x000fe80000000800ULL,
0x0000001518007388ULL, 0x000fe80000000800ULL, 0x000000131a007388ULL, 0x000fe80000000800ULL,
0x000000112a007388ULL, 0x000fe80000000800ULL, 0x0000000f2c007388ULL, 0x000fe80000000800ULL,
0x0000000d2e007388ULL, 0x000fe80000000800ULL, 0x0000000b30007388ULL, 0x000fe80000000800ULL,
0x0000000732007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000051c7984ULL, 0x000e680000000c00ULL, 0x0004000005207984ULL, 0x000ea80000000c00ULL,
0x0008000005147984ULL, 0x000f280000000c00ULL, 0x000c000005187984ULL, 0x000f620000000c00ULL,
0x3f803f800e1f7831ULL, 0x002fc4000020001fULL, 0x3f803f800e1e7831ULL, 0x040fe4000020001eULL,
0x3f803f800e1d7831ULL, 0x040fe4000020001dULL, 0x3f803f800e1c7831ULL, 0x040fe4000020001cULL,
0x3f803f800e237831ULL, 0x044fe40000200023ULL, 0x3f803f800e227831ULL, 0x040fe40000200022ULL,
0x3f803f800e217831ULL, 0x000fc40000200021ULL, 0x3f803f800e207831ULL, 0x000fe40000200020ULL,
0x3f803f801f1f7831ULL, 0x010fe40000200017ULL, 0x3f803f801e1e7831ULL, 0x000fe40000200016ULL,
0x3f803f801d1d7831ULL, 0x000fe40000200015ULL, 0x3f803f801c1c7831ULL, 0x000fe40000200014ULL,
0x3f803f8023237831ULL, 0x020fc4000020001bULL, 0x3f803f8022227831ULL, 0x000fe2000020001aULL,
0x0000001c05007388ULL, 0x0003e20000000c00ULL, 0x3f803f8021217831ULL, 0x000fe40000200019ULL,
0x3f803f8020207831ULL, 0x000fca0000200018ULL, 0x0004002005007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff2d00720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000147919ULL, 0x002e620000002600ULL,
0x0000002000157810ULL, 0x040fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000f220000002700ULL,
0x0000004000177810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x00000003ff037819ULL, 0x000fe20000011600ULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x0000006000217810ULL, 0x000fe20007ffe0ffULL, 0x00000008c6167824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fe40000011615ULL, 0x00000003ff087819ULL, 0x000fc40000011617ULL,
0x00000003ff0a7819ULL, 0x000fe40000011621ULL, 0x0000000705067812ULL, 0x000fe400078e4815ULL,
0x0000000708097812ULL, 0x000fe400078e4817ULL, 0x000000070a0b7812ULL, 0x000fe400078e4821ULL,
0x0ffffff806077812ULL, 0x000fe400078ef815ULL, 0x0ffffff809097812ULL, 0x000fe200078ef817ULL,
0x0000001014047824ULL, 0x002fe200078e00ffULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef821ULL,
0x0000001007077824ULL, 0x100fe200078e0202ULL, 0x00000004050472a4ULL, 0x010fe2000f8e023fULL,
0x0000001009097824ULL, 0x100fe200078e0202ULL, 0xfffffff004047812ULL, 0x000fe200078ee203ULL,
0x000000100b067824ULL, 0x000fe200078e0202ULL, 0x0000000703037812ULL, 0x100fe200078e4800ULL,
0x0000000007107984ULL, 0x0003e20000000c00ULL, 0x00000008c60b7824ULL, 0x000fe200078e00ffULL,
0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001014237824ULL, 0x040fe200078e00ffULL,
0x0ffffff803037812ULL, 0x100fe200078ef800ULL, 0x0000000009187984ULL, 0x000fe20000000c00ULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee200ULL, 0x0000001014007824ULL, 0x000fe200078e00ffULL,
0xfffffff023087812ULL, 0x000fe200078ee208ULL, 0x0000001003037824ULL, 0x000fe200078e0202ULL,
0x00000000061c7984ULL, 0x0009e20000000c00ULL, 0x00000008c6027824ULL, 0x000fe200078e00ffULL,
0xfffffff000057812ULL, 0x000fe200078ee205ULL, 0x0000001014257824ULL, 0x000fe200078e00ffULL,
0x00000000030c7984ULL, 0x0045620000000c00ULL, 0x0000000408007c10ULL, 0x000fe2000ff3e0ffULL,
0x00000008c6c67824ULL, 0x000fe200078e00ffULL, 0xfffffff802157812ULL, 0x000fc400078ee215ULL,
0xfffffff0250a7812ULL, 0x000fe200078ee20aULL, 0x000000ffff077224ULL, 0x002fe200008e06ffULL,
0x00005a0000067a11ULL, 0x010fe200078240ffULL, 0x000000ffff037224ULL, 0x004fe200000e06ffULL,
0x00005a0004027a11ULL, 0x000fe400078040ffULL, 0x000000040a0a7c10ULL, 0x000fe4000ff5e0ffULL,
0x00005b0004037a11ULL, 0x000fe400000f4403ULL, 0x0000000405057c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x00005a000a087a11ULL, 0x000fe200078440ffULL,
0x000000100b027825ULL, 0x000fe200078e0002ULL, 0xfffffff816177812ULL, 0x000fc400078ee217ULL,
0x00005b0000077a11ULL, 0x000fe200008f4407ULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x00005a0005047a11ULL, 0x000fe400078040ffULL, 0xfffffff8c6217812ULL, 0x000fe200078ee221ULL,
0x0000001017067825ULL, 0x000fe200078e0006ULL, 0x00005b0005057a11ULL, 0x000fe400000f4414ULL,
0x00005b000a097a11ULL, 0x000fc600010f4409ULL, 0x0000001015047825ULL, 0x000fc800078e0004ULL,
0x0000001021087825ULL, 0x000fe200078e0008ULL, 0x0000000c02007986ULL, 0x020fe8000c101d06ULL,
0x0000001004007986ULL, 0x000fe8000c101d06ULL, 0x0000001806007986ULL, 0x000fe8000c101d06ULL,
0x0000001c08007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff127624ULL, 0x000fe400078e00ffULL, 0x00006700ff137624ULL, 0x000fca00078e00ffULL,
0x0000000612127981ULL, 0x000562000c1e9900ULL, 0x0000000110027810ULL, 0x002fe20007ffe0ffULL,
0x0000000214007824ULL, 0x000fe400078e00ffULL, 0x000000400e0d7824ULL, 0x000fe200078e00ffULL,
0x000000110200720cULL, 0x000fe20003f06070ULL, 0x0000580000007a24ULL, 0x000fe400078e0215ULL,
0x0000010010057824ULL, 0x000fc800078e020dULL, 0x0000620000287a24ULL, 0x000fcc00078e0205ULL,
0x00000ba000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7919ULL, 0x004e620000000000ULL,
0x000000050f027217ULL, 0x000fe20007800000ULL, 0x00000080ff2b7424ULL, 0x000fc800078e00ffULL,
0x00000001020c7824ULL, 0x000fe200078e0a05ULL, 0x00000003ff297819ULL, 0x002fe2000001162aULL,
0x000000102a057824ULL, 0x000fc600078e00ffULL, 0x0000000429077810ULL, 0x040fe20007ffe0ffULL,
0x0000000129027824ULL, 0x040fe200078e0228ULL, 0x0000000829097810ULL, 0x000fe40007ffe0ffULL,
0x0000002a07037212ULL, 0x0c0fe200078e3cffULL, 0x00000008071c7824ULL, 0x000fe200078e00ffULL,
0x0000002a09047212ULL, 0x040fe200078e3cffULL, 0x00000008090b7824ULL, 0x000fe200078e00ffULL,
0x0000000c29137810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee203ULL,
0x00005e0002027625ULL, 0x000fe200078e002bULL, 0xfffffff80b1e7812ULL, 0x000fc400078ee204ULL,
0x00000070052d7812ULL, 0x000fe200078ec0ffULL, 0x00000008130b7824ULL, 0x000fe200078e00ffULL,
0x0000001029157810ULL, 0x000fe20007ffe0ffULL, 0x0000000113067824ULL, 0x040fe200078e0228ULL,
0x0000002a13047212ULL, 0x080fe400078e3cffULL, 0x0000002d020a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000815057824ULL, 0x000fe200078e00ffULL, 0xfffffff80b207812ULL, 0x000fe200078ee204ULL,
0x0000000107027824ULL, 0x000fe200078e0228ULL, 0x0000002a15047212ULL, 0x000fe200078e3cffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0603ULL, 0x0000000c0700720cULL, 0x000fe20003f86070ULL,
0x00005e0002027625ULL, 0x000fe200078e002bULL, 0xfffffff805227812ULL, 0x000fc400078ee204ULL,
0x00000014291b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109047824ULL, 0x100fe200078e0228ULL,
0x0000002d02147210ULL, 0x000fe20007f3e0ffULL, 0x0000000115077824ULL, 0x040fe200078e0228ULL,
0x0000000c1500720cULL, 0x080fe20003f06070ULL, 0x00005e0004047625ULL, 0x000fe200078e002bULL,
0x00000018291d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c0900720cULL, 0x080fe20003f46070ULL,
0x000000ffff157224ULL, 0x000fe200008e0603ULL, 0x0000002d04167210ULL, 0x000fe20007f3e0ffULL,
0x00005e0006027625ULL, 0x000fe200078e002bULL, 0x0000000c1300720cULL, 0x000fc40003f66070ULL,
0x000010000e137811ULL, 0x000fe200078e70ffULL, 0x000000011b087824ULL, 0x000fe200078e0228ULL,
0x0000001c29277810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0605ULL,
0x0000002d02187210ULL, 0x000fe20007f3e0ffULL, 0x00005e0008087625ULL, 0x080fe200078e002bULL,
0x0000000729057812ULL, 0x000fe400078e482aULL, 0x0000002a1b047212ULL, 0x000fe200078e3cffULL,
0x00005e0007067625ULL, 0x000fe200078e002bULL, 0x0000002d08087210ULL, 0x000fc40007fde0ffULL,
0x0000002029257810ULL, 0x000fe20007ffe0ffULL, 0x000000011d027824ULL, 0x000fe200078e0228ULL,
0x0000002d06067210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff197224ULL, 0x000fe200008e0603ULL,
0x0000000c1b00720cULL, 0x000fe20003f26070ULL, 0x00005e0002027625ULL, 0x000fe200078e002bULL,
0x0000002a1d237212ULL, 0x000fc600078e3cffULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x0000002d021a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x0ffffff805027812ULL, 0x000fe200078ef82aULL, 0x000000081b1b7824ULL, 0x000fe200078e00ffULL,
0x0000000c2900720cULL, 0x000fe20003fa6070ULL, 0x000000101c217824ULL, 0x100fe400078e0213ULL,
0x00000010021f7824ULL, 0x000fe200078e0213ULL, 0xfffffff81b247812ULL, 0x000fe200078ee204ULL,
0x0000000127027824ULL, 0x000fc400078e0228ULL, 0x000000ffff1b7224ULL, 0x000fe400030e0603ULL,
0x00005e0002027625ULL, 0x000fc800078e002bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a1f7faeULL, 0x0003e2000e901c46ULL, 0x0000002d021c7210ULL, 0x000fe20007fde0ffULL,
0x000000081d267824ULL, 0x000fe200078e00ffULL, 0x0000002a27027212ULL, 0x040fe200078e3cffULL,
0x0000000014217faeULL, 0x0005e2000e101c46ULL, 0x0000000c2700720cULL, 0x080fe20003f86070ULL,
0x0000000128047824ULL, 0x000fe200078e0225ULL, 0x0000000c1d00720cULL, 0x000fe20003fa6070ULL,
0x0000000827277824ULL, 0x000fe400078e00ffULL, 0x00005e0004047625ULL, 0x000fe200078e002bULL,
0x0000002a250b7212ULL, 0x002fc600078e3cffULL, 0x000000ffff1d7224ULL, 0x000fe200030e0603ULL,
0x0000002d04047210ULL, 0x000fe20007fde0ffULL, 0x000000101e157824ULL, 0x104fe200078e0213ULL,
0x0000002429217810ULL, 0x000fe20007ffe0ffULL, 0x00000010201f7824ULL, 0x000fe200078e0213ULL,
0xfffffff826147812ULL, 0x000fe200078ee223ULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0xfffffff827267812ULL, 0x000fe200078ee202ULL, 0x0000000128027824ULL, 0x000fe200078e0221ULL,
0x0000000016157faeULL, 0x0003e2000d101c46ULL, 0x0000000825207824ULL, 0x000fe200078e00ffULL,
0x0000000c2100720cULL, 0x040fe20003f46070ULL, 0x00005e0002027625ULL, 0x000fe200078e002bULL,
0x0000002a211e7212ULL, 0x000fe200078e3cffULL, 0x00000000181f7faeULL, 0x0005e2000d901c46ULL,
0x0000000c2500720cULL, 0x000fe20003f66070ULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0x0000002d020a7210ULL, 0x000fc40007fde0ffULL, 0xfffffff820027812ULL, 0x000fe200078ee20bULL,
0x0000001022157824ULL, 0x002fe200078e0213ULL, 0xfffffff8211e7812ULL, 0x000fe200078ee21eULL,
0x000000ffff0b7224ULL, 0x000fe200030e0603ULL, 0x0000002829217810ULL, 0x040fe20007ffe0ffULL,
0x0000001024037824ULL, 0x100fe200078e0213ULL, 0x0000000006157faeULL, 0x0003e2000c101c46ULL,
0x0000001014177824ULL, 0x100fe200078e0213ULL, 0x0000002c29237810ULL, 0x040fe20007ffe0ffULL,
0x0000001026197824ULL, 0x104fe200078e0213ULL, 0x0000000008037faeULL, 0x0005e2000c901c46ULL,
0x00000010021f7824ULL, 0x000fe200078e0213ULL, 0x0000003029257810ULL, 0x000fe20007ffe0ffULL,
0x0000000823167824ULL, 0x000fe200078e00ffULL, 0x0000003829277810ULL, 0x000fe20007ffe0ffULL,
0x000000001a177faeULL, 0x0007e2000e901c46ULL, 0x0000002a21027212ULL, 0x000fc400078e3cffULL,
0x0000003429157810ULL, 0x042fe20007ffe0ffULL, 0x000000001c197faeULL, 0x0003e2000e101c46ULL,
0x0000003c29297810ULL, 0x000fe20007ffe0ffULL, 0x0000000821037824ULL, 0x044fe400078e00ffULL,
0x00000000041f7faeULL, 0x0005e2000d901c46ULL, 0x0000000c2100720cULL, 0x080fe20003fc6070ULL,
0x000000101e097824ULL, 0x000fe200078e0213ULL, 0x0000000c2300720cULL, 0x080fe20003fa6070ULL,
0x0000000128087824ULL, 0x040fe200078e0225ULL, 0x0000000c2500720cULL, 0x080fe20003f86070ULL,
0x00000008151a7824ULL, 0x048fe200078e00ffULL, 0x0000000c1500720cULL, 0x080fe20003f66070ULL,
0x000000000a097faeULL, 0x0007e2000d101c46ULL, 0x0000000c2700720cULL, 0x080fe20003f26070ULL,
0x0000000128197824ULL, 0x042fe200078e0229ULL, 0x0000000c2900720cULL, 0x000fe20003f06070ULL,
0x0000000128047824ULL, 0x044fe200078e0223ULL, 0xfffffff8030c7812ULL, 0x000fe200078ee202ULL,
0x0000000128027824ULL, 0x000fe200078e0221ULL, 0x0000002a23077212ULL, 0x080fe200078e3cffULL,
0x00005e0004047625ULL, 0x000fe200078e002bULL, 0x0000002a25147212ULL, 0x000fc400078e3cffULL,
0xfffffff816167812ULL, 0x000fe200078ee207ULL, 0x00005e0002027625ULL, 0x000fe200078e002bULL,
0x0000002a150b7212ULL, 0x088fe400078e3cffULL, 0x0000002a27177212ULL, 0x000fe200078e3cffULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0x0000002d02067210ULL, 0x000fe20007f5e0ffULL,
0x00000008271c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe400078ee20bULL,
0xfffffff825187812ULL, 0x000fe200078ee214ULL, 0x000000ffff077224ULL, 0x000fe200010e0603ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee217ULL, 0x00005e0008027625ULL, 0x000fe200078e002bULL,
0x0000002d04087210ULL, 0x000fc60007f5e0ffULL, 0x0000000128047824ULL, 0x000fe400078e0215ULL,
0x000000ffff097224ULL, 0x000fe200010e0605ULL, 0x0000002d020a7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0004047625ULL, 0x000fc800078e002bULL, 0x0000000128027824ULL, 0x000fe400078e0227ULL,
0x000000ffff0b7224ULL, 0x000fe200010e0603ULL, 0x0000002d04147210ULL, 0x000fe20007f5e0ffULL,
0x00005e0002027625ULL, 0x000fe200078e002bULL, 0x0000002a29047212ULL, 0x000fc600078e3cffULL,
0x0000000829297824ULL, 0x000fe400078e00ffULL, 0x000000ffff157224ULL, 0x000fe200010e0605ULL,
0x0000002d02027210ULL, 0x000fe20007f5e0ffULL, 0x000000100c177824ULL, 0x000fe200078e0213ULL,
0xfffffff8291e7812ULL, 0x000fe200078ee204ULL, 0x00005e0019047625ULL, 0x000fc600078e002bULL,
0x0000000006177faeULL, 0x0003e2000f101c46ULL, 0x000000ffff037224ULL, 0x000fe200010e0603ULL,
0x0000002d04047210ULL, 0x000fe20007f5e0ffULL, 0x0000001016197824ULL, 0x100fe400078e0213ULL,
0x00000010181b7824ULL, 0x100fe400078e0213ULL, 0x000000101a1d7824ULL, 0x100fe200078e0213ULL,
0x0000000008197faeULL, 0x0003e2000e901c46ULL, 0x000000101c1f7824ULL, 0x100fe400078e0213ULL,
0x000000101e137824ULL, 0x000fe200078e0213ULL, 0x000000000a1b7faeULL, 0x0003e2000e101c46ULL,
0x000000ffff057224ULL, 0x000fc600010e0605ULL, 0x00000000141d7faeULL, 0x0003e8000d901c46ULL,
0x00000000021f7faeULL, 0x0003e8000c901c46ULL, 0x0000000004137faeULL, 0x0003e2000c101c46ULL,
0x00000a7000007947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x004e620000000000ULL,
0x00000080ff297424ULL, 0x000fe200078e00ffULL, 0x000010000e0a7811ULL, 0x000fc400078e70ffULL,
0x00000003ff037819ULL, 0x002fc80000011604ULL, 0x0000000403077810ULL, 0x040fe40007ffe0ffULL,
0x0000000803097810ULL, 0x000fe40007ffe0ffULL, 0x0000000407027212ULL, 0x0c0fe200078e3cffULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0x0000000c03177810ULL, 0x000fe20007ffe0ffULL,
0x0000000809157824ULL, 0x000fe200078e00ffULL, 0x00000014031f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee202ULL, 0x0000000817087824ULL, 0x000fe200078e00ffULL,
0x0000000409027212ULL, 0x080fe200078e3cffULL, 0x000000081f217824ULL, 0x000fe200078e00ffULL,
0x00000010031b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001170c7824ULL, 0x140fe200078e0228ULL,
0x0000000417057212ULL, 0x080fe200078e3cffULL, 0x000000011f167824ULL, 0x000fe200078e0228ULL,
0x0000001803237810ULL, 0x000fe20007ffe0ffULL, 0x000000081b1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee202ULL, 0x000000011b147824ULL, 0x100fe200078e0228ULL,
0x00000020032b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000123187824ULL, 0x000fe200078e0228ULL,
0x000000041f027212ULL, 0x000fc400078e3cffULL, 0xfffffff808197812ULL, 0x000fe200078ee205ULL,
0x0000000823087824ULL, 0x000fe200078e00ffULL, 0x0000001c03277810ULL, 0x000fe20007ffe0ffULL,
0x000000082b3b7824ULL, 0x000fe200078e00ffULL, 0x000000041b067212ULL, 0x080fe200078e3cffULL,
0x00000001281c7824ULL, 0x000fe200078e022bULL, 0x0000000423057212ULL, 0x000fe200078e3cffULL,
0x0000000827397824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee202ULL,
0x00000001271a7824ULL, 0x000fe200078e0228ULL, 0x00000024032d7810ULL, 0x000fc40007ffe0ffULL,
0x0000002c03317810ULL, 0x000fe40007ffe0ffULL, 0x000000042b027212ULL, 0x080fe200078e3cffULL,
0x00000001281e7824ULL, 0x000fe200078e022dULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL,
0x0000000831417824ULL, 0x000fe200078e00ffULL, 0xfffffff808257812ULL, 0x000fe200078ee205ULL,
0x000000082d087824ULL, 0x000fe200078e00ffULL, 0x00000028032f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000128227824ULL, 0x000fe200078e0231ULL, 0x0000000427067212ULL, 0x000fc400078e3cffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee202ULL, 0x000000082f3f7824ULL, 0x000fe200078e00ffULL,
0x000000042d057212ULL, 0x080fe200078e3cffULL, 0x0000000128207824ULL, 0x040fe200078e022fULL,
0x0000003003337810ULL, 0x000fe20007ffe0ffULL, 0x000000100b2d7824ULL, 0x100fe200078e020aULL,
0x0000000431027212ULL, 0x080fe200078e3cffULL, 0x0000001019317824ULL, 0x000fe200078e020aULL,
0xfffffff839397812ULL, 0x000fe200078ee206ULL, 0x0000000128247824ULL, 0x000fe200078e0233ULL,
0x0000003403357810ULL, 0x000fe20007ffe0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e020aULL,
0x000000042f067212ULL, 0x080fe200078e3cffULL, 0x00000010152f7824ULL, 0x000fe200078e020aULL,
0xfffffff8083d7812ULL, 0x000fe200078ee205ULL, 0x0000000833087824ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fe200078ee202ULL, 0x0000001004027824ULL, 0x000fe200078e00ffULL,
0x0000000433057212ULL, 0x080fe200078e3cffULL, 0x0000000835457824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee206ULL, 0x0000000128267824ULL, 0x000fe200078e0235ULL,
0x0000000435067212ULL, 0x000fe200078e3cffULL, 0x000000101d337824ULL, 0x000fe200078e020aULL,
0xfffffff808437812ULL, 0x000fe200078ee205ULL, 0x0000000109087824ULL, 0x100fe200078e0228ULL,
0x0000007002137812ULL, 0x000fe200078ec0ffULL, 0x0000000103027824ULL, 0x040fe200078e0228ULL,
0x0000003c03477810ULL, 0x000fe20007ffe0ffULL, 0x0000001021357824ULL, 0x000fe200078e020aULL,
0x0000000703057812ULL, 0x000fe200078e4804ULL, 0x0000001039397824ULL, 0x000fe200078e020aULL,
0x0000003803377810ULL, 0x000fe20007ffe0ffULL, 0x00005e0002027625ULL, 0x000fe200078e0029ULL,
0xfffffff845457812ULL, 0x000fc400078ee206ULL, 0x0ffffff805057812ULL, 0x000fe200078ef804ULL,
0x0000000107067824ULL, 0x000fe200078e0228ULL, 0x0000000437077212ULL, 0x080fe200078e3cffULL,
0x00000008471b7824ULL, 0x040fe200078e00ffULL, 0x0000000447047212ULL, 0x000fe200078e3cffULL,
0x00000008372c7824ULL, 0x000fe200078e00ffULL, 0x0000001302027210ULL, 0x000fe20007f1e0ffULL,
0x00000010052b7824ULL, 0x000fe200078e020aULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee204ULL,
0x00005e0006047625ULL, 0x000fe200078e0029ULL, 0xfffffff82c177812ULL, 0x000fc600078ee207ULL,
0x00000001282a7824ULL, 0x040fe400078e0237ULL, 0x0000000128287824ULL, 0x000fe400078e0247ULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000001304047210ULL, 0x000fe20007f1e0ffULL,
0x0000001025377824ULL, 0x100fe400078e020aULL, 0x000000103d3d7824ULL, 0x100fe200078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000022b7faeULL, 0x0003e2000b901c46ULL,
0x000000103f3f7824ULL, 0x000fc400078e020aULL, 0x0000001041417824ULL, 0x100fe400078e020aULL,
0x0000001043437824ULL, 0x100fe400078e020aULL, 0x0000001045457824ULL, 0x100fe400078e020aULL,
0x0000001017477824ULL, 0x100fe400078e020aULL, 0x000000101b497824ULL, 0x000fe400078e020aULL,
0x00005e00140a7625ULL, 0x000fc800078e0029ULL, 0x00005e0008067625ULL, 0x000fc800078e0029ULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x000000130a0a7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0016147625ULL, 0x000fe200078e0029ULL, 0x0000001306067210ULL, 0x000fe40007f3e0ffULL,
0x00000000042d7faeULL, 0x0003e2000b901c46ULL, 0x00005e0018167625ULL, 0x000fc800078e0029ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000001316167210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x0000001314147210ULL, 0x000fe20007f3e0ffULL,
0x00005e001a187625ULL, 0x000fc600078e0029ULL, 0x00000000062f7faeULL, 0x0003e2000b901c46ULL,
0x00005e001c1a7625ULL, 0x000fc800078e0029ULL, 0x00005e000c087625ULL, 0x000fc800078e0029ULL,
0x00005e001e1c7625ULL, 0x000fe200078e0029ULL, 0x0000001308087210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200000e0617ULL, 0x000000131a1a7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff157224ULL, 0x000fe200008e0615ULL, 0x0000001318187210ULL, 0x000fe20007f3e0ffULL,
0x00005e00201e7625ULL, 0x000fc800078e0029ULL, 0x00005e0022207625ULL, 0x000fc800078e0029ULL,
0x000000ffff1b7224ULL, 0x000fe200000e061bULL, 0x0000001320207210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff197224ULL, 0x000fe200008e0619ULL, 0x000000131c1c7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x000000131e1e7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0024227625ULL, 0x000fc600078e0029ULL, 0x0000000008317faeULL, 0x0003e2000b901c46ULL,
0x00005e0026247625ULL, 0x000fc600078e0029ULL, 0x000000000a337faeULL, 0x0003e2000b901c46ULL,
0x00005e002a267625ULL, 0x000fc600078e0029ULL, 0x0000000014357faeULL, 0x0003e2000b901c46ULL,
0x00005e0028287625ULL, 0x000fc600078e0029ULL, 0x0000000016377faeULL, 0x0003e2000b901c46ULL,
0x000000ffff217224ULL, 0x000fe200000e0621ULL, 0x0000001322227210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e061dULL, 0x0000001324247210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e061fULL, 0x0000001326267210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff237224ULL, 0x000fe200000e0623ULL, 0x0000001328287210ULL, 0x000fe20007f7e0ffULL,
0x0000000018397faeULL, 0x0003e2000b901c46ULL, 0x000000ffff257224ULL, 0x000fc400008e0625ULL,
0x000000ffff277224ULL, 0x000fe200010e0627ULL, 0x000000001a3b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff297224ULL, 0x000fc600018e0629ULL, 0x000000001c3d7faeULL, 0x0003e8000b901c46ULL,
0x000000001e3f7faeULL, 0x0003e8000b901c46ULL, 0x0000000020417faeULL, 0x0003e8000b901c46ULL,
0x0000000022437faeULL, 0x0003e8000b901c46ULL, 0x0000000024457faeULL, 0x0003e8000b901c46ULL,
0x0000000026477faeULL, 0x0003e8000b901c46ULL, 0x0000000028497faeULL, 0x0003e4000b901c46ULL,
0x01b60400ff027984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000002ff7812ULL, 0x002fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x000000030000735dULL, 0x004fe40003800000ULL, 0x01b60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000030e00780cULL, 0x000fda0003f04070ULL,
0x0000017000000947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x000000200e027824ULL, 0x002fc800078e0203ULL, 0x0000001002047824ULL, 0x000fe200078e00ffULL,
0x00000003ff037819ULL, 0x000fc80000011602ULL, 0x1ffffffe03037812ULL, 0x000fe400078ec0ffULL,
0x000000f004047812ULL, 0x000fe400078ec0ffULL, 0x0000000103057812ULL, 0x040fe400078efcffULL,
0x0000000703037812ULL, 0x100fe400078e7802ULL, 0x0000000705057812ULL, 0x000fc600078e7802ULL,
0x0000000103037824ULL, 0x000fe400078e0204ULL, 0x0000000104057824ULL, 0x000fc600078e0205ULL,
0x0000000003147984ULL, 0x000e68000000cc00ULL, 0x0000000005087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff147224ULL, 0x000fe400078e0015ULL,
0x000000ffff197224ULL, 0x000fe400078e0016ULL, 0x000000ffff157224ULL, 0x000fc400078e0017ULL,
0x000000ffff1a7224ULL, 0x004fe400078e0008ULL, 0x000000ffff1b7224ULL, 0x000fe400078e000aULL,
0x000000ffff167224ULL, 0x000fe400078e0009ULL, 0x000000ffff177224ULL, 0x000fe200078e000bULL,
0x0000001803007388ULL, 0x0003e8000000cc00ULL, 0x0000001405007388ULL, 0x0003e4000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b60000ffff7f8cULL, 0x000fe8000c80043fULL,
0x01b60400ff027984ULL, 0x000ea40000000800ULL, 0x8000000002ff7812ULL, 0x004fc40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff027424ULL, 0x000fc800078e00ffULL, 0x0000000200037305ULL, 0x0022a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x000000030000735dULL, 0x004fe40003800000ULL,
0x01b60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000111000720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000c7919ULL, 0x000ea20000000000ULL, 0x3db504f312127820ULL, 0x020fe20000410000ULL,
0xffffffff113d7810ULL, 0x000fe20007ffe0ffULL, 0x000000100e137824ULL, 0x000fe200078e00ffULL,
0x00007610ff3c7816ULL, 0x000fe2000000003cULL, 0x000000ffff3f7224ULL, 0x000fe400078e00ffULL,
0x00000100103e7824ULL, 0x000fe200078e020dULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000003e0f00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000030010407a10ULL, 0x000fe20007ffe0ffULL, 0x0000168000007945ULL, 0x000fe20003800000ULL,
0x000000013f417812ULL, 0x000fe400078e0cffULL, 0x0000000140027810ULL, 0x040fe20007ffe0ffULL,
0x0000010040037824ULL, 0x002fc600078e020dULL, 0x000000110200720cULL, 0x000fe20003f06070ULL,
0x0000620000207a24ULL, 0x000fd800078e0203ULL, 0x00000ba000008947ULL, 0x000fea0003800000ULL,
0x00000003ff257819ULL, 0x004fe2000001160cULL, 0x00000080ff277424ULL, 0x000fe200078e00ffULL,
0x000000030f027217ULL, 0x000fe20007800000ULL, 0x000000020e1f7824ULL, 0x000fe200078e0241ULL,
0x0000000425057810ULL, 0x040fe40007ffe0ffULL, 0x0000001025157810ULL, 0x000fe20007ffe0ffULL,
0x00000001021e7824ULL, 0x000fe200078e0a03ULL, 0x0000000c05047212ULL, 0x0c0fe200078e3cffULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0x0000000c25097810ULL, 0x000fe20007ffe0ffULL,
0x000000100c037824ULL, 0x000fe200078e00ffULL, 0x0000000c15087212ULL, 0x000fe200078e3cffULL,
0x0000000125027824ULL, 0x000fe200078e0220ULL, 0xfffffff8071c7812ULL, 0x000fe200078ee204ULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0x0000007003297812ULL, 0x000fe200078ec0ffULL,
0x00005e0002027625ULL, 0x000fe200078e0027ULL, 0x0000000825077810ULL, 0x000fc40007ffe0ffULL,
0x0000001e0500720cULL, 0x000fe20003f86070ULL, 0x0000000809177824ULL, 0x000fe200078e00ffULL,
0x0000000c07047212ULL, 0x0c0fe200078e3cffULL, 0x00000008070b7824ULL, 0x000fe200078e00ffULL,
0x00000029020a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000105027824ULL, 0x000fe200078e0220ULL,
0x0000000c09067212ULL, 0x000fe400078e3cffULL, 0xfffffff80b227812ULL, 0x000fe200078ee204ULL,
0x000000ffff0b7224ULL, 0x000fe200000e0603ULL, 0xfffffff819267812ULL, 0x000fe200078ee208ULL,
0x00005e0002027625ULL, 0x000fe200078e0027ULL, 0x00000014251b7810ULL, 0x000fc40007ffe0ffULL,
0x0000001e1500720cULL, 0x080fe20003f06070ULL, 0x0000000107047824ULL, 0x100fe200078e0220ULL,
0x0000002902147210ULL, 0x000fe20007f3e0ffULL, 0x0000000115087824ULL, 0x000fe200078e0220ULL,
0xfffffff817247812ULL, 0x000fe200078ee206ULL, 0x00005e0004047625ULL, 0x000fe200078e0027ULL,
0x0000001e0900720cULL, 0x080fe40003f66070ULL, 0x00000018251d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200008e0603ULL, 0x0000002904167210ULL, 0x000fe20007fbe0ffULL,
0x0000000109067824ULL, 0x000fe200078e0220ULL, 0x0000001e0700720cULL, 0x000fe20003f46070ULL,
0x00005e0008027625ULL, 0x000fe200078e0027ULL, 0x000010001f1f7811ULL, 0x000fc400078e68ffULL,
0x0000001c252b7810ULL, 0x000fe20007ffe0ffULL, 0x000000011b097824ULL, 0x040fe200078e0220ULL,
0x0000000c1b047212ULL, 0x080fe200078e3cffULL, 0x000000ffff177224ULL, 0x000fe200028e0605ULL,
0x0000002902187210ULL, 0x000fe20007fbe0ffULL, 0x00005e0009087625ULL, 0x000fe200078e0027ULL,
0x0000000725057812ULL, 0x040fe400078e480cULL, 0x00000020252d7810ULL, 0x000fe20007ffe0ffULL,
0x000000011d027824ULL, 0x040fe200078e0220ULL, 0x0000002908087210ULL, 0x000fe20007fde0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0027ULL, 0x0000000c1d2a7212ULL, 0x000fc600078e3cffULL,
0x000000ffff197224ULL, 0x000fe200028e0603ULL, 0x0000002906067210ULL, 0x000fe20007f3e0ffULL,
0x00005e0002027625ULL, 0x000fe200078e0027ULL, 0x0000001e2500720cULL, 0x000fc60003fa6070ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x00000029021a7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x0ffffff805027812ULL, 0x000fe200078ef80cULL,
0x000000101c237824ULL, 0x100fe200078e021fULL, 0x0000001e1b00720cULL, 0x0c0fe20003f26070ULL,
0x000000081b1b7824ULL, 0x000fe400078e00ffULL, 0x0000001002217824ULL, 0x000fe400078e021fULL,
0x000000012b027824ULL, 0x000fe200078e0220ULL, 0xfffffff81b287812ULL, 0x000fe200078ee204ULL,
0x000000ffff1b7224ULL, 0x000fe200030e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a217faeULL, 0x0003e2000e901c46ULL, 0x00005e0002027625ULL, 0x000fe200078e0027ULL,
0x0000001e1d00720cULL, 0x000fc40003fa6070ULL, 0x0000000014237faeULL, 0x0005e2000e101c46ULL,
0x0000001e2b00720cULL, 0x000fe20003f86070ULL, 0x000000012d047824ULL, 0x000fe200078e0220ULL,
0x00000029021c7210ULL, 0x000fe20007fde0ffULL, 0x000000081d2f7824ULL, 0x000fe200078e00ffULL,
0x0000000c2b027212ULL, 0x0c0fe200078e3cffULL, 0x000000082b2b7824ULL, 0x000fe400078e00ffULL,
0x00005e0004047625ULL, 0x000fe200078e0027ULL, 0x0000000c2d0b7212ULL, 0x002fe400078e3cffULL,
0xfffffff82f2a7812ULL, 0x000fe200078ee22aULL, 0x000000ffff1d7224ULL, 0x000fe200030e0603ULL,
0x0000002425237810ULL, 0x004fe20007ffe0ffULL, 0x0000001022157824ULL, 0x100fe200078e021fULL,
0xfffffff82b147812ULL, 0x000fe200078ee202ULL, 0x0000001024217824ULL, 0x000fe200078e021fULL,
0x0000002904047210ULL, 0x000fe20007fde0ffULL, 0x0000000123027824ULL, 0x000fe200078e0220ULL,
0x0000000016157faeULL, 0x0003e2000d101c46ULL, 0x000000082d247824ULL, 0x000fe200078e00ffULL,
0x0000001e2300720cULL, 0x040fe20003f46070ULL, 0x00005e0002027625ULL, 0x000fe200078e0027ULL,
0x0000000c23227212ULL, 0x000fe200078e3cffULL, 0x0000000006217faeULL, 0x0005e2000d901c46ULL,
0x0000001e2d00720cULL, 0x000fe20003f66070ULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x00000029020a7210ULL, 0x000fe20007fde0ffULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0xfffffff824027812ULL, 0x000fe200078ee20bULL, 0x0000001026157824ULL, 0x002fe200078e021fULL,
0x0000002c252b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e0603ULL,
0xfffffff823227812ULL, 0x000fe200078ee222ULL, 0x0000001028037824ULL, 0x100fe200078e021fULL,
0x0000002825237810ULL, 0x040fe20007ffe0ffULL, 0x0000000018157faeULL, 0x0003e2000c101c46ULL,
0x0000001002217824ULL, 0x104fe200078e021fULL, 0x00000030252d7810ULL, 0x000fe20007ffe0ffULL,
0x000000102a077824ULL, 0x100fe200078e021fULL, 0x0000000008037faeULL, 0x0005e2000c901c46ULL,
0x0000000c23027212ULL, 0x040fe200078e3cffULL, 0x0000001014177824ULL, 0x000fe200078e021fULL,
0x0000001e2300720cULL, 0x080fe20003fc6070ULL, 0x000000001a077faeULL, 0x0007e2000e901c46ULL,
0x0000001e2b00720cULL, 0x000fc40003fa6070ULL, 0x0000000c2d147212ULL, 0x080fe200078e3cffULL,
0x000000001c177faeULL, 0x0009e2000e101c46ULL, 0x0000003425157810ULL, 0x042fe40007ffe0ffULL,
0x0000003825197810ULL, 0x000fe20007ffe0ffULL, 0x0000000823037824ULL, 0x004fe200078e00ffULL,
0x0000000004217faeULL, 0x0003e2000d901c46ULL, 0x0000001022097824ULL, 0x000fe200078e021fULL,
0x0000003c25257810ULL, 0x000fe20007ffe0ffULL, 0x000000082b1a7824ULL, 0x008fe200078e00ffULL,
0xfffffff803187812ULL, 0x000fe200078ee202ULL, 0x0000000123027824ULL, 0x100fe200078e0220ULL,
0x000000000a097faeULL, 0x0005e2000d101c46ULL, 0x0000000c2b077212ULL, 0x000fe200078e3cffULL,
0x000000012d087824ULL, 0x040fe200078e0220ULL, 0x0000001e2d00720cULL, 0x000fe20003f86070ULL,
0x00005e0002027625ULL, 0x000fe200078e0027ULL, 0xfffffff81a1a7812ULL, 0x000fc400078ee207ULL,
0x0000001e1500720cULL, 0x080fe20003f66070ULL, 0x000000012b047824ULL, 0x002fe200078e0220ULL,
0x0000002902067210ULL, 0x000fe20007f5e0ffULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0x0000001e1900720cULL, 0x080fe20003f26070ULL, 0x00005e0004047625ULL, 0x080fe200078e0027ULL,
0x0000001e2500720cULL, 0x000fe40003f06070ULL, 0x0000000c150b7212ULL, 0x004fe200078e3cffULL,
0x000000ffff077224ULL, 0x000fe200010e0603ULL, 0xfffffff82d1c7812ULL, 0x010fe200078ee214ULL,
0x00005e0008027625ULL, 0x000fe200078e0027ULL, 0x0000002904087210ULL, 0x000fc40007f5e0ffULL,
0x0000000c19177212ULL, 0x000fe200078e3cffULL, 0x0000000115047824ULL, 0x040fe400078e0220ULL,
0x00000008151e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200010e0605ULL,
0x00000029020a7210ULL, 0x000fe20007f5e0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0027ULL,
0xfffffff81e1e7812ULL, 0x000fc600078ee20bULL, 0x0000000119027824ULL, 0x100fe400078e0220ULL,
0x000000ffff0b7224ULL, 0x000fe200010e0603ULL, 0x0000002904147210ULL, 0x000fe20007f5e0ffULL,
0x0000000125167824ULL, 0x040fe200078e0220ULL, 0x0000000c25047212ULL, 0x000fe200078e3cffULL,
0x00005e0002027625ULL, 0x000fc800078e0027ULL, 0x0000000825257824ULL, 0x000fe400078e00ffULL,
0x000000ffff157224ULL, 0x000fe200010e0605ULL, 0x0000002902027210ULL, 0x000fe20007f5e0ffULL,
0x0000000819207824ULL, 0x000fe200078e00ffULL, 0xfffffff825227812ULL, 0x000fe200078ee204ULL,
0x00005e0016047625ULL, 0x000fc600078e0027ULL, 0xfffffff820207812ULL, 0x000fe200078ee217ULL,
0x000000ffff037224ULL, 0x000fe200010e0603ULL, 0x0000002904047210ULL, 0x000fe20007f5e0ffULL,
0x0000001018177824ULL, 0x100fe400078e021fULL, 0x000000101a197824ULL, 0x100fe400078e021fULL,
0x000000101c1b7824ULL, 0x100fe200078e021fULL, 0x0000000006177faeULL, 0x0003e2000f101c46ULL,
0x000000101e1d7824ULL, 0x100fe400078e021fULL, 0x0000001020217824ULL, 0x100fe200078e021fULL,
0x0000000008197faeULL, 0x0003e2000e901c46ULL, 0x00000010221f7824ULL, 0x000fc400078e021fULL,
0x000000ffff057224ULL, 0x000fe200010e0605ULL, 0x000000000a1b7faeULL, 0x0003e8000e101c46ULL,
0x00000000141d7faeULL, 0x0003e8000d901c46ULL, 0x0000000002217faeULL, 0x0003e8000c901c46ULL,
0x00000000041f7faeULL, 0x0003e2000c101c46ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x00000003ff037819ULL, 0x004fe2000001160cULL, 0x00000080ff297424ULL, 0x000fc600078e00ffULL,
0x0000000403077810ULL, 0x040fe40007ffe0ffULL, 0x0000000803097810ULL, 0x000fe40007ffe0ffULL,
0x0000000c07027212ULL, 0x0c0fe200078e3cffULL, 0x00000008070b7824ULL, 0x000fe200078e00ffULL,
0x00000010031b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000809157824ULL, 0x000fe200078e00ffULL,
0x0000000c03177810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee202ULL,
0x000000081b067824ULL, 0x000fe200078e00ffULL, 0x00000014031f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000817197824ULL, 0x000fe200078e00ffULL, 0x0000000c09027212ULL, 0x080fe200078e3cffULL,
0x0000000117087824ULL, 0x100fe200078e0220ULL, 0x0000000c1b057212ULL, 0x080fe200078e3cffULL,
0x000000081f217824ULL, 0x000fe200078e00ffULL, 0x0000001803237810ULL, 0x000fe20007ffe0ffULL,
0x000000011b147824ULL, 0x100fe200078e0220ULL, 0x0000001c03277810ULL, 0x000fe20007ffe0ffULL,
0x000000011f167824ULL, 0x000fe200078e0220ULL, 0x0000000c17047212ULL, 0x080fe200078e3cffULL,
0x0000000823257824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee202ULL,
0x0000000123187824ULL, 0x100fe200078e0220ULL, 0x00000020032d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001271a7824ULL, 0x000fe200078e0220ULL, 0x0000000c1f027212ULL, 0x000fc400078e3cffULL,
0xfffffff8061d7812ULL, 0x000fe200078ee205ULL, 0x0000000827067824ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe200078ee204ULL, 0x000000082d437824ULL, 0x000fe200078e00ffULL,
0x00000024032f7810ULL, 0x000fe20007ffe0ffULL, 0x000000012d1c7824ULL, 0x000fe200078e0220ULL,
0x0000000c23047212ULL, 0x080fe400078e3cffULL, 0x0000000c27057212ULL, 0x000fe200078e3cffULL,
0x000000082f457824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee202ULL,
0x000000012f1e7824ULL, 0x000fe200078e0220ULL, 0x0000002803317810ULL, 0x000fc40007ffe0ffULL,
0x0000002c03337810ULL, 0x000fe40007ffe0ffULL, 0x0000000c2d027212ULL, 0x080fe200078e3cffULL,
0x0000000131227824ULL, 0x000fe200078e0220ULL, 0xfffffff825257812ULL, 0x000fe200078ee204ULL,
0x0000000833497824ULL, 0x000fe200078e00ffULL, 0xfffffff8063b7812ULL, 0x000fe200078ee205ULL,
0x0000000831067824ULL, 0x000fe200078e00ffULL, 0x0000003003357810ULL, 0x000fe20007ffe0ffULL,
0x0000000133247824ULL, 0x000fe200078e0220ULL, 0x0000000c2f047212ULL, 0x000fc400078e3cffULL,
0xfffffff843437812ULL, 0x000fe200078ee202ULL, 0x00000008354b7824ULL, 0x000fe200078e00ffULL,
0x0000000c31057212ULL, 0x080fe200078e3cffULL, 0x0000000135267824ULL, 0x000fe200078e0220ULL,
0x0000000c33027212ULL, 0x080fe400078e3cffULL, 0x0000003403377810ULL, 0x000fe40007ffe0ffULL,
0xfffffff845457812ULL, 0x000fe400078ee204ULL, 0xfffffff806477812ULL, 0x000fe200078ee205ULL,
0x0000000837067824ULL, 0x000fe200078e00ffULL, 0x0000000c35047212ULL, 0x080fe200078e3cffULL,
0x0000000137287824ULL, 0x000fe200078e0220ULL, 0xfffffff849497812ULL, 0x000fe200078ee202ULL,
0x000000100c027824ULL, 0x000fe200078e00ffULL, 0x0000000c37057212ULL, 0x000fc400078e3cffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee204ULL, 0x000000020e047824ULL, 0x000fe200078e0241ULL,
0xfffffff8064d7812ULL, 0x000fe200078ee205ULL, 0x0000000109067824ULL, 0x100fe200078e0220ULL,
0x00000070022b7812ULL, 0x000fe200078ec0ffULL, 0x0000000103027824ULL, 0x040fe200078e0220ULL,
0x0000003803397810ULL, 0x040fe40007ffe0ffULL, 0x0000003c034f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000703057812ULL, 0x000fe200078e480cULL, 0x00000001392a7824ULL, 0x100fe200078e0220ULL,
0x00001000040a7811ULL, 0x000fe200078e68ffULL, 0x0000000107047824ULL, 0x000fe200078e0220ULL,
0x0ffffff805057812ULL, 0x000fe200078ef80cULL, 0x000000014f2c7824ULL, 0x000fe200078e0220ULL,
0x0000000c39077212ULL, 0x080fe200078e3cffULL, 0x00005e0002027625ULL, 0x000fe200078e0029ULL,
0x0000000c4f097212ULL, 0x000fc600078e3cffULL, 0x0000000839207824ULL, 0x000fe200078e00ffULL,
0x0000002b02027210ULL, 0x000fe20007f1e0ffULL, 0x000000084f2e7824ULL, 0x000fe400078e00ffULL,
0x00000010052d7824ULL, 0x000fe200078e020aULL, 0xfffffff820177812ULL, 0x000fe200078ee207ULL,
0x00005e0004047625ULL, 0x000fe200078e0029ULL, 0xfffffff82e1b7812ULL, 0x000fc600078ee209ULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000002b04047210ULL, 0x000fe20007f1e0ffULL,
0x000000100b2f7824ULL, 0x100fe400078e020aULL, 0x0000001015317824ULL, 0x100fe200078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000022d7faeULL, 0x0003e2000b901c46ULL,
0x0000001019337824ULL, 0x100fe400078e020aULL, 0x000000101d357824ULL, 0x100fe400078e020aULL,
0x0000001021377824ULL, 0x000fc400078e020aULL, 0x0000001025397824ULL, 0x100fe400078e020aULL,
0x000000103b3b7824ULL, 0x100fe400078e020aULL, 0x0000001043437824ULL, 0x100fe400078e020aULL,
0x0000001045457824ULL, 0x100fe400078e020aULL, 0x0000001047477824ULL, 0x100fe400078e020aULL,
0x0000001049497824ULL, 0x000fc400078e020aULL, 0x000000104b4b7824ULL, 0x100fe400078e020aULL,
0x000000104d4d7824ULL, 0x100fe400078e020aULL, 0x00000010174f7824ULL, 0x100fe400078e020aULL,
0x000000101b517824ULL, 0x000fe400078e020aULL, 0x00005e00140a7625ULL, 0x000fc800078e0029ULL,
0x00005e0006067625ULL, 0x000fc800078e0029ULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000002b0a0a7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0016147625ULL, 0x000fe200078e0029ULL,
0x0000002b06067210ULL, 0x000fe40007f3e0ffULL, 0x00000000042f7faeULL, 0x0003e2000b901c46ULL,
0x00005e0018167625ULL, 0x000fc800078e0029ULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000002b16167210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000002b14147210ULL, 0x000fe20007f3e0ffULL, 0x00005e001a187625ULL, 0x000fc600078e0029ULL,
0x0000000006317faeULL, 0x0003e2000b901c46ULL, 0x00005e001c1a7625ULL, 0x000fc800078e0029ULL,
0x00005e0008087625ULL, 0x000fc800078e0029ULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x0000002b1a1a7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200008e0615ULL,
0x0000002b18187210ULL, 0x000fe20007f3e0ffULL, 0x00005e0024207625ULL, 0x000fe200078e0029ULL,
0x0000002b08087210ULL, 0x000fc60007f5e0ffULL, 0x00005e001e1c7625ULL, 0x000fc800078e0029ULL,
0x00005e00221e7625ULL, 0x000fc800078e0029ULL, 0x000000ffff1b7224ULL, 0x000fe200000e061bULL,
0x0000002b20207210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x0000002b1c1c7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000002b1e1e7210ULL, 0x000fe20007f5e0ffULL, 0x00005e0026227625ULL, 0x000fc600078e0029ULL,
0x0000000008337faeULL, 0x0003e2000b901c46ULL, 0x00005e0028247625ULL, 0x000fc600078e0029ULL,
0x000000000a357faeULL, 0x0003e2000b901c46ULL, 0x00005e002a267625ULL, 0x000fc600078e0029ULL,
0x0000000014377faeULL, 0x0003e2000b901c46ULL, 0x00005e002c287625ULL, 0x000fc600078e0029ULL,
0x0000000016397faeULL, 0x0003e2000b901c46ULL, 0x000000ffff217224ULL, 0x000fe200000e0621ULL,
0x0000002b22227210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e061dULL,
0x0000002b24247210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e061fULL,
0x0000002b26267210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff237224ULL, 0x000fe200000e0623ULL,
0x0000002b28287210ULL, 0x000fe20007f7e0ffULL, 0x00000000183b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff257224ULL, 0x000fc400008e0625ULL, 0x000000ffff277224ULL, 0x000fe200010e0627ULL,
0x000000001a437faeULL, 0x0003e2000b901c46ULL, 0x000000ffff297224ULL, 0x000fc600018e0629ULL,
0x000000001c457faeULL, 0x0003e8000b901c46ULL, 0x000000001e477faeULL, 0x0003e8000b901c46ULL,
0x0000000020497faeULL, 0x0003e8000b901c46ULL, 0x00000000224b7faeULL, 0x0003e8000b901c46ULL,
0x00000000244d7faeULL, 0x0003e8000b901c46ULL, 0x00000000264f7faeULL, 0x0003e8000b901c46ULL,
0x0000000028517faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000427805ULL, 0x002fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff80c037812ULL, 0x000fe200078ec0ffULL,
0x000000020e317824ULL, 0x000fe200078e023fULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000142307810ULL, 0x000fc40007ffe0ffULL, 0x0000000703037812ULL, 0x000fe400078ef80cULL,
0x0000100031317811ULL, 0x000fe400078e68ffULL, 0x0000000742027812ULL, 0x100fe400078e7803ULL,
0x00000007302c7812ULL, 0x000fe400078e7803ULL, 0x000000200c2d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000803027824ULL, 0x040fe200078e0202ULL, 0x000000070ce17812ULL, 0x000fe200078ec0ffULL,
0x00000008032c7824ULL, 0x000fe200078e022cULL, 0xfffffff82d2d7812ULL, 0x000fe200078ec0ffULL,
0x0000001002027824ULL, 0x100fe200078e0231ULL, 0x00000008e1e17812ULL, 0x100fe200078ef80cULL,
0x000000102c2c7824ULL, 0x000fe200078e0231ULL, 0x000000072d337812ULL, 0x000fc400078ef80cULL,
0x000000000238783bULL, 0x000e640000000200ULL, 0x0000000730307812ULL, 0x000fe400078e7833ULL,
0x000000002c34783bULL, 0x0002a60000000200ULL, 0x0000000833307824ULL, 0x000fc800078e0230ULL,
0x0000001030307824ULL, 0x000fe200078e0231ULL, 0x00000018ff2c7819ULL, 0x002fe20000011438ULL,
0x0000003800a77306ULL, 0x000fe20000009400ULL, 0x00000018ff2e7819ULL, 0x000fe20000011439ULL,
0x0001000038557824ULL, 0x000fe200078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe2000001143aULL,
0x0001000039567824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe2000001143bULL,
0x0001000037577824ULL, 0x004fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000002c00a47306ULL, 0x000fe20000209400ULL, 0x00000018ff567819ULL, 0x000fc40000011456ULL,
0x00000018ff457819ULL, 0x000fe40000011434ULL, 0x00000018ff597819ULL, 0x000fe40000011457ULL,
0x00000018ff4a7819ULL, 0x000fe20000011437ULL, 0x0000002c00757306ULL, 0x000e620000205400ULL,
0x00000018ff477819ULL, 0x000fe40000011435ULL, 0x00000018ff487819ULL, 0x000fca0000011436ULL,
0x0000002c00857306ULL, 0x0004f0000020d400ULL, 0x0000002e00a67306ULL, 0x000fe20000209400ULL,
0x00000007422c7812ULL, 0x004fe400078e7833ULL, 0x00000075a400720bULL, 0x002fc40003f7d000ULL,
0x0000000242427810ULL, 0x000fe20007ffe0ffULL, 0x00000008332c7824ULL, 0x000fe400078e022cULL,
0x0000002e009f7306ULL, 0x000e640000205400ULL, 0x000000102c2c7824ULL, 0x000fe400078e0231ULL,
0x000000003030783bULL, 0x000ea80000000200ULL, 0x0000002e00817306ULL, 0x000f22000020d400ULL,
0x0000000185853812ULL, 0x008fce00078efcffULL, 0x0000002f009d7306ULL, 0x000fe20000209400ULL,
0x0000009fa600720bULL, 0x002fce0003f9d000ULL, 0x0000002f00987306ULL, 0x000fec0000205400ULL,
0x0000000181814812ULL, 0x010fe400078efcffULL, 0x0000002f007b7306ULL, 0x0003f0000020d400ULL,
0x0000003800aa7306ULL, 0x000ee20000005400ULL, 0x000000002c2c783bULL, 0x002e620000000200ULL,
0x00000018ff6b7819ULL, 0x004fc40000011431ULL, 0x00000018ff5f7819ULL, 0x000fc80000011430ULL,
0x0000003800037306ULL, 0x000522000000d400ULL, 0x00000018ff727819ULL, 0x000fe40000011433ULL,
0x00000018ff6f7819ULL, 0x000fca0000011432ULL, 0x0000003900a07306ULL, 0x000fe20000009400ULL,
0x0000010038387824ULL, 0x004fe200078e00ffULL, 0x000000aaa700720bULL, 0x008fc80003fbd000ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003900997306ULL, 0x000eae0000005400ULL,
0x0000000103035812ULL, 0x010fe200078efcffULL, 0x0000003900827306ULL, 0x000730000000d400ULL,
0x0000003800b67306ULL, 0x000fe20000209400ULL, 0x0000010039397824ULL, 0x008fe200078e00ffULL,
0x00000099a000720bULL, 0x004fe20003f3d000ULL, 0x000100002c6a7824ULL, 0x002fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003800b37306ULL, 0x000e620000205400ULL,
0x00000018ff6a7819ULL, 0x000fcc000001146aULL, 0x0000000182821812ULL, 0x010fe200078efcffULL,
0x0000003800a27306ULL, 0x0004e2000020d400ULL, 0x000000989d00720bULL, 0x000fce0003f3d000ULL,
0x0000003b00907306ULL, 0x000fe20000009400ULL, 0x000100003b387824ULL, 0x004fe200078e00ffULL,
0x000000b3b600720bULL, 0x002fc80003f1d000ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003b00977306ULL, 0x000e620000005400ULL, 0x000000017b7b1812ULL, 0x000fcc00078efcffULL,
0x00000001a2a20812ULL, 0x008fe200078efcffULL, 0x0000003b007a7306ULL, 0x0004f0000000d400ULL,
0x0000003900c07306ULL, 0x000fe20000209400ULL, 0x000001003b3b7824ULL, 0x004fe200078e00ffULL,
0x000000979000720bULL, 0x002fc80003f7d000ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000003900bf7306ULL, 0x000fee0000205400ULL, 0x000000017a7a3812ULL, 0x008fe200078efcffULL,
0x00000039009c7306ULL, 0x0003f0000020d400ULL, 0x0000005500b57306ULL, 0x000fe20000209400ULL,
0x00000018ff397819ULL, 0x002fce000001142cULL, 0x0000005500b47306ULL, 0x000e700000205400ULL,
0x00000055009e7306ULL, 0x0004f0000020d400ULL, 0x0000003b00cf7306ULL, 0x000fe20000209400ULL,
0x000100003a557824ULL, 0x004fe200078e00ffULL, 0x000000b4b500720bULL, 0x002fc80003fdd000ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000003b00cc7306ULL, 0x000fee0000205400ULL,
0x000000019e9e6812ULL, 0x008fe200078efcffULL, 0x0000003b00797306ULL, 0x0003e2000020d400ULL,
0x000000bfc000720bULL, 0x000fce0003fdd000ULL, 0x0000003a00967306ULL, 0x000fe20000009400ULL,
0x00000018ff3b7819ULL, 0x002fca000001142fULL, 0x000000019c9c6812ULL, 0x000fe400078efcffULL,
0x0000003a00937306ULL, 0x000e700000005400ULL, 0x0000003a007c7306ULL, 0x0004f0000000d400ULL,
0x0000003900cd7306ULL, 0x000fe20000209400ULL, 0x000001003a3a7824ULL, 0x004fe200078e00ffULL,
0x000000939600720bULL, 0x002fc80003fbd000ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000003900d07306ULL, 0x000fee0000205400ULL, 0x000000017c7c5812ULL, 0x008fe200078efcffULL,
0x0000003900737306ULL, 0x0003f0000020d400ULL, 0x0000003800c97306ULL, 0x000fe20000209400ULL,
0x0001000034397824ULL, 0x002fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003800ca7306ULL, 0x000e700000205400ULL, 0x0000003800a17306ULL, 0x000eb0000020d400ULL,
0x0000003b00be7306ULL, 0x000fe20000209400ULL, 0x000000cac900720bULL, 0x002fce0003f9d000ULL,
0x0000003b00bb7306ULL, 0x000fec0000205400ULL, 0x00000001a1a14812ULL, 0x004fe400078efcffULL,
0x0000003b00387306ULL, 0x0003e4000020d400ULL, 0x0000007aa17a723eULL, 0x000fcc00000010ffULL,
0x0000005600b87306ULL, 0x000fe20000209400ULL, 0x00000100353b7824ULL, 0x002fce00078e00ffULL,
0x0000005600b77306ULL, 0x000e700000205400ULL, 0x0000005600a97306ULL, 0x0004f0000020d400ULL,
0x00000034008a7306ULL, 0x000fe20000009400ULL, 0x00000018ff567819ULL, 0x004fe2000001143bULL,
0x00010000363b7824ULL, 0x000fe200078e00ffULL, 0x000000b7b800720bULL, 0x002fca0003f5d000ULL,
0x0000003400897306ULL, 0x000ff00000005400ULL, 0x00000034004f7306ULL, 0x0003e2000000d400ULL,
0x00000001a9a92812ULL, 0x008fce00078efcffULL, 0x0000003a00c77306ULL, 0x000fe20000209400ULL,
0x0000010034347824ULL, 0x002fce00078e00ffULL, 0x0000003a00c87306ULL, 0x000e700000205400ULL,
0x0000003a00947306ULL, 0x0004f0000020d400ULL, 0x0000005500c57306ULL, 0x000fe20000209400ULL,
0x00000018ff3a7819ULL, 0x004fc4000001142dULL, 0x000000c8c700720bULL, 0x002fca0003f5d000ULL,
0x0000005500c67306ULL, 0x000e700000205400ULL, 0x0000005500a57306ULL, 0x000522000020d400ULL,
0x0000000194942812ULL, 0x008fce00078efcffULL, 0x0000002c00af7306ULL, 0x000fe20000009400ULL,
0x00000018ff557819ULL, 0x004fe4000001142eULL, 0x000000c6c500720bULL, 0x002fca0003f1d000ULL,
0x0000002c00b07306ULL, 0x000e700000005400ULL, 0x0000002c006e7306ULL, 0x0004e2000000d400ULL,
0x00000001a5a50812ULL, 0x010fe400078efcffULL, 0x000000cccf00720bULL, 0x000fca0003f1d000ULL,
0x0000003900bc7306ULL, 0x000fe20000209400ULL, 0x000001002c2c7824ULL, 0x004fe200078e00ffULL,
0x000000b0af00720bULL, 0x002fcc0003fbd000ULL, 0x0000003900bd7306ULL, 0x000fe20000205400ULL,
0x0000000179790812ULL, 0x000fe400078efcffULL, 0x000000d0cd00720bULL, 0x000fc80003f1d000ULL,
0x000000016e6e5812ULL, 0x008fe200078efcffULL, 0x0000003900627306ULL, 0x000ff0000020d400ULL,
0x0000005600b27306ULL, 0x000fe20000209400ULL, 0x0000000173730812ULL, 0x000fce00078efcffULL,
0x0000005600b17306ULL, 0x000ff00000205400ULL, 0x0000005600397306ULL, 0x0003f0000020d400ULL,
0x0000003700877306ULL, 0x000fe20000009400ULL, 0x0000010037567824ULL, 0x002fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011456ULL, 0x0000003700027306ULL, 0x000ff00000005400ULL,
0x00000037004c7306ULL, 0x000ff0000000d400ULL, 0x0000003a00ce7306ULL, 0x000ff00000209400ULL,
0x0000003a00cb7306ULL, 0x000ff00000205400ULL, 0x0000003a00667306ULL, 0x0003f0000020d400ULL,
0x0000005500c37306ULL, 0x000fe20000209400ULL, 0x00000018ff3a7819ULL, 0x002fce0000011434ULL,
0x0000005500c27306ULL, 0x000ff00000205400ULL, 0x0000005500617306ULL, 0x0003f0000020d400ULL,
0x0000005900707306ULL, 0x000fe20000209400ULL, 0x0001000035557824ULL, 0x002fca00078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000005900717306ULL, 0x000ff00000205400ULL,
0x0000005900377306ULL, 0x000ff0000020d400ULL, 0x0000006b00587306ULL, 0x000ff00000209400ULL,
0x0000006b00597306ULL, 0x000ff00000205400ULL, 0x0000006b005a7306ULL, 0x0003f0000020d400ULL,
0x0000003a00c47306ULL, 0x000fe20000209400ULL, 0x00000018ff6b7819ULL, 0x002fce000001142cULL,
0x0000003a00c17306ULL, 0x000ff00000205400ULL, 0x0000003a00347306ULL, 0x0003f0000020d400ULL,
0x0000002e00ac7306ULL, 0x000fe20000009400ULL, 0x00000018ff3a7819ULL, 0x002fe2000001143bULL,
0x00000100363b7824ULL, 0x000fcc00078e00ffULL, 0x0000002e00ad7306ULL, 0x000e700000005400ULL,
0x0000006b002c7306ULL, 0x000ff00000209400ULL, 0x0000006b00d37306ULL, 0x000ea20000205400ULL,
0x000000adac00720bULL, 0x002fce0003f9d000ULL, 0x0000006a00d17306ULL, 0x000ff00000209400ULL,
0x0000006a00d27306ULL, 0x000e620000205400ULL, 0x000000d32c00720bULL, 0x004fe20003f7d000ULL,
0x00010000312c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe2000001142cULL,
0x0000006a00777306ULL, 0x0004f0000020d400ULL, 0x0000003500887306ULL, 0x000fe20000009400ULL,
0x000100002e6a7824ULL, 0x004fe200078e00ffULL, 0x000000d2d100720bULL, 0x002fc80003f5d000ULL,
0x00000018ffd97819ULL, 0x000fe4000001146aULL, 0x00000035008b7306ULL, 0x000fee0000005400ULL,
0x0000000177772812ULL, 0x008fe200078efcffULL, 0x00000035004e7306ULL, 0x000ff0000000d400ULL,
0x0000006b00787306ULL, 0x0002b0000020d400ULL, 0x0000002f008e7306ULL, 0x000fe20000009400ULL,
0x000100002f6b7824ULL, 0x002fca00078e00ffULL, 0x00000018ffdc7819ULL, 0x000fe4000001146bULL,
0x0000002f00917306ULL, 0x000fe20000005400ULL, 0x0000000178783812ULL, 0x004fce00078efcffULL,
0x0000002f00547306ULL, 0x0003f0000000d400ULL, 0x0000005500ba7306ULL, 0x000fe20000209400ULL,
0x000001002f2f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x0000005500b97306ULL, 0x000ff00000205400ULL, 0x0000005500357306ULL, 0x0003f0000020d400ULL,
0x0000003600867306ULL, 0x000fe20000009400ULL, 0x00000018ff557819ULL, 0x002fce000001143bULL,
0x00000055009b7306ULL, 0x000ff00000209400ULL, 0x00000055009a7306ULL, 0x000ff00000205400ULL,
0x00000055003b7306ULL, 0x000ff0000020d400ULL, 0x00000036008d7306ULL, 0x000ff00000005400ULL,
0x00000036004d7306ULL, 0x000ff0000000d400ULL, 0x0000005f00557306ULL, 0x000ff00000209400ULL,
0x0000005f00567306ULL, 0x000ff00000205400ULL, 0x0000005f00577306ULL, 0x000ff0000020d400ULL,
0x0000003a00927306ULL, 0x000ff00000209400ULL, 0x0000003a00957306ULL, 0x000ff00000205400ULL,
0x0000003a00367306ULL, 0x000ff0000020d400ULL, 0x00000072005e7306ULL, 0x000ff00000209400ULL,
0x00000072005f7306ULL, 0x000ff00000205400ULL, 0x0000007200607306ULL, 0x000ff0000020d400ULL,
0x0000002e00637306ULL, 0x0002b0000000d400ULL, 0x0000005c006d7306ULL, 0x000fe20000209400ULL,
0x000001002e2e7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x0000005c006c7306ULL, 0x000fe20000205400ULL, 0x0000000163634812ULL, 0x004fce00078efcffULL,
0x0000005c003a7306ULL, 0x000ff0000020d400ULL, 0x000000d900da7306ULL, 0x000ff00000209400ULL,
0x000000d900db7306ULL, 0x000e700000205400ULL, 0x000000d900727306ULL, 0x000eb0000020d400ULL,
0x0000006f005b7306ULL, 0x000fe20000209400ULL, 0x000000dbda00720bULL, 0x002fce0003f7d000ULL,
0x0000006f005c7306ULL, 0x000fec0000205400ULL, 0x0000000172723812ULL, 0x004fe400078efcffULL,
0x0000006f005d7306ULL, 0x0003e2000020d400ULL, 0x0000008b8800720bULL, 0x000fe20003f7d000ULL,
0x00010000328b7824ULL, 0x000fe200078e00ffULL, 0x000000637272723eULL, 0x000fc800000010ffULL,
0x00000018ff8b7819ULL, 0x000fe2000001148bULL, 0x0000002f00d97306ULL, 0x000fe20000209400ULL,
0x000100002d6f7824ULL, 0x002fca00078e00ffULL, 0x00000018ffd47819ULL, 0x000fe4000001146fULL,
0x0000002f00b47306ULL, 0x000e620000205400ULL, 0x000000014e4e3812ULL, 0x000fe400078efcffULL,
0x000000959200720bULL, 0x000fca0003f7d000ULL, 0x0000002d00ae7306ULL, 0x000ff00000009400ULL,
0x0000002d00ab7306ULL, 0x000ea20000005400ULL, 0x000000b4d900720bULL, 0x002fe40003f9d000ULL,
0x0000000136363812ULL, 0x000fc400078efcffULL, 0x000000717000720bULL, 0x000fc60003f7d000ULL,
0x0000002d00677306ULL, 0x0002f0000000d400ULL, 0x0000004400a37306ULL, 0x000fe20000209400ULL,
0x000001002d2d7824ULL, 0x002fe200078e00ffULL, 0x000000abae00720bULL, 0x004fc40003f3d000ULL,
0x0000000137373812ULL, 0x000fe400078efcffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000004400a87306ULL, 0x000e6e0000205400ULL, 0x0000000167671812ULL, 0x008fe200078efcffULL,
0x0000002d00d77306ULL, 0x000fe20000209400ULL, 0x000000c2c300720bULL, 0x000fce0003f3d000ULL,
0x0000002d00d87306ULL, 0x000ea20000205400ULL, 0x000000a8a300720bULL, 0x002fca0003fdd000ULL,
0x0000000161611812ULL, 0x000fe400078efcffULL, 0x0000002f00757306ULL, 0x000e62000020d400ULL,
0x000000028700720bULL, 0x000fe40003f3d000ULL, 0x000000039e02723eULL, 0x000fe400000010ffULL,
0x000000a28503723eULL, 0x000fc600000010ffULL, 0x0000002d006f7306ULL, 0x000722000020d400ULL,
0x000000d8d700720bULL, 0x004fca0003fbd000ULL, 0x000000014c4c1812ULL, 0x000fe400078efcffULL,
0x000000d400d57306ULL, 0x000fe20000209400ULL, 0x000000430c2d7211ULL, 0x008fe400078fe0ffULL,
0x0000000175754812ULL, 0x002fe400078efcffULL, 0x000000c1c400720bULL, 0x000fe40003f9d000ULL,
0x0000000443437810ULL, 0x000fe20007ffe0ffULL, 0x000000d400d67306ULL, 0x000e620000205400ULL,
0x000000016f6f5812ULL, 0x010fc400078efcffULL, 0x000000918e00720bULL, 0x000fe20003fbd000ULL,
0x00000100338e7824ULL, 0x000fc800078e00ffULL, 0x000000d400767306ULL, 0x000ea2000020d400ULL,
0x00000018ff8e7819ULL, 0x000fe4000001148eULL, 0x0000000134344812ULL, 0x000fe400078efcffULL,
0x000000b1b200720bULL, 0x000fc60003f9d000ULL, 0x0000002e00d47306ULL, 0x000fe20000209400ULL,
0x000000d6d500720bULL, 0x002fe40003f5d000ULL, 0x0000000154545812ULL, 0x000fe400078efcffULL,
0x000000bdbc00720bULL, 0x000fc60003fbd000ULL, 0x0000002e00dd7306ULL, 0x000e640000205400ULL,
0x0000000139394812ULL, 0x000fe400078efcffULL, 0x0000009a9b00720bULL, 0x000fe40003f9d000ULL,
0x0000000176762812ULL, 0x004fe400078efcffULL, 0x0000002e006a7306ULL, 0x0005e2000020d400ULL,
0x000000898a00720bULL, 0x000fe40003f5d000ULL, 0x0000000162625812ULL, 0x000fc400078efcffULL,
0x000000b9ba00720bULL, 0x000fc60003fbd000ULL, 0x0000004400747306ULL, 0x000ee2000020d400ULL,
0x000000022d2e7810ULL, 0x044fe40007ffe0ffULL, 0x000000072d2d7812ULL, 0x100fe400078e78e1ULL,
0x000000072e2e7812ULL, 0x000fe400078e78e1ULL, 0x000000ddd400720bULL, 0x002fe20003f1d000ULL,
0x00000010e12d7824ULL, 0x040fe200078e022dULL, 0x000000dc00de7306ULL, 0x000fe20000209400ULL,
0x00000010e1a77824ULL, 0x000fe200078e022eULL, 0x000000014f4f2812ULL, 0x000fe200078efcffULL,
0x00010000302e7824ULL, 0x000fe200078e00ffULL, 0x000000013b3b4812ULL, 0x000fe200078efcffULL,
0x000000102d2d7824ULL, 0x000fe200078e00ffULL, 0x0000006c6d00720bULL, 0x000fc40003f9d000ULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x000000dc00df7306ULL, 0x000e620000205400ULL,
0x0000000174746812ULL, 0x008fe400078efcffULL, 0x000000cbce00720bULL, 0x000fe40003fdd000ULL,
0x000000016a6a0812ULL, 0x000fe400078efcffULL, 0x0000008d8600720bULL, 0x000fe20003f1d000ULL,
0x0000002e00997306ULL, 0x000fe20000209400ULL, 0x0000000135355812ULL, 0x000fe200078efcffULL,
0x00010000338d7824ULL, 0x000fe200078e00ffULL, 0x000000013a3a4812ULL, 0x000fc400078efcffULL,
0x0000004f6262723eULL, 0x000fe400000010ffULL, 0x00000018ff8d7819ULL, 0x000fe2000001148dULL,
0x0000002e00967306ULL, 0x000ea20000205400ULL, 0x0000000166666812ULL, 0x000fe400078efcffULL,
0x000000dfde00720bULL, 0x002fe40003fdd000ULL, 0x0000006f666f723eULL, 0x000fe400000010ffULL,
0x000000014d4d0812ULL, 0x000fe200078efcffULL, 0x0000002e00907306ULL, 0x0002f0000020d400ULL,
0x000000dc006b7306ULL, 0x000f22000020d400ULL, 0x000000002d2c783bULL, 0x002e620000000200ULL,
0x000000969900720bULL, 0x004fcc0003f7d000ULL, 0x0000004700837306ULL, 0x000fee0000209400ULL,
0x0000000190903812ULL, 0x008fe200078efcffULL, 0x0000004700847306ULL, 0x000ea20000205400ULL,
0x000000016b6b6812ULL, 0x010fe400078efcffULL, 0x000000bbbe00720bULL, 0x000fca0003fdd000ULL,
0x0000003000697306ULL, 0x000ff00000009400ULL, 0x0000003000687306ULL, 0x000fe20000005400ULL,
0x000000848300720bULL, 0x004fe40003f5d000ULL, 0x0000000138386812ULL, 0x000fc800078efcffULL,
0x000000753875723eULL, 0x000fe200000010ffULL, 0x00000030004b7306ULL, 0x0005e2000000d400ULL,
0x000000022c08723cULL, 0x002fe20000041808ULL, 0x0000004e3538723eULL, 0x000fcc00000010ffULL,
0x00000045008c7306ULL, 0x000fe20000209400ULL, 0x0000010030307824ULL, 0x004fe200078e00ffULL,
0x0000007ca502723eULL, 0x000fe400000010ffULL, 0x000000947b03723eULL, 0x000fe400000010ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000045008f7306ULL, 0x000e620000205400ULL,
0x00000079747b723eULL, 0x000fe400000010ffULL, 0x000000022c28723cULL, 0x000fe20000041828ULL,
0x000000546b74723eULL, 0x000fc800000010ffULL, 0x0000004a00807306ULL, 0x000fe40000209400ULL,
0x0000006e7702723eULL, 0x000fe200000010ffULL, 0x0000007a2c24723cULL, 0x040fe20000041824ULL,
0x000000787303723eULL, 0x000fe400000010ffULL, 0x00000067766e723eULL, 0x000fe400000010ffULL,
0x0000004a007d7306ULL, 0x000ea20000205400ULL, 0x0000008f8c00720bULL, 0x002fe40003fdd000ULL,
0x0000006a6173723eULL, 0x000fe200000010ffULL, 0x000000022c20723cULL, 0x040fe80000041820ULL,
0x0000004700467306ULL, 0x000e66000020d400ULL, 0x0000004d3602723eULL, 0x000fe200000010ffULL,
0x0000006e2c1c723cULL, 0x000fe8000004181cULL, 0x0000003000937306ULL, 0x000fe20000209400ULL,
0x0000007d8000720bULL, 0x004fc60003fbd000ULL, 0x000000722c18723cULL, 0x040fe80000041818ULL,
0x0000003000a07306ULL, 0x000ea20000205400ULL, 0x0000000146462812ULL, 0x002fe400078efcffULL,
0x000000686900720bULL, 0x000fe20003f5d000ULL, 0x000000742c14723cULL, 0x000fe20000041814ULL,
0x000000394639723eULL, 0x000fc600000010ffULL, 0x0000009d00977306ULL, 0x000ff00000209400ULL,
0x0000009d008a7306ULL, 0x000e620000205400ULL, 0x000000a09300720bULL, 0x004fe40003f9d000ULL,
0x000000014b4b2812ULL, 0x000fc400078efcffULL, 0x000000595800720bULL, 0x000fc60003f5d000ULL,
0x0000004500497306ULL, 0x000eb0000020d400ULL, 0x0000004a00457306ULL, 0x000ee2000020d400ULL,
0x0000008a9700720bULL, 0x002fe40003f7d000ULL, 0x000000015a5a2812ULL, 0x000fca00078efcffULL,
0x0000003100647306ULL, 0x000fe20000009400ULL, 0x0000000149496812ULL, 0x004fc800078efcffULL,
0x000000344963723eULL, 0x000fc600000010ffULL, 0x0000003100657306ULL, 0x000e620000005400ULL,
0x0000000145455812ULL, 0x008fe400078efcffULL, 0x000000565500720bULL, 0x000fe40003fbd000ULL,
0x0000004b9056723eULL, 0x000fe400000010ffULL, 0x0000003a4545723eULL, 0x000fe200000010ffULL,
0x00000031004a7306ULL, 0x0004f0000000d400ULL, 0x00000048007e7306ULL, 0x000fe20000209400ULL,
0x0000010031317824ULL, 0x004fe200078e00ffULL, 0x000000656400720bULL, 0x002fc40003f1d000ULL,
0x0000000157575812ULL, 0x000fe400078efcffULL, 0x00000018ff867819ULL, 0x000fe40000011431ULL,
0x00000048007f7306ULL, 0x000e620000205400ULL, 0x0000009c8131723eULL, 0x000fe400000010ffULL,
0x0000005c5b00720bULL, 0x000fc80003fbd000ULL, 0x000000014a4a0812ULL, 0x008fe200078efcffULL,
0x0000003300507306ULL, 0x000fe20000009400ULL, 0x0000005f5e00720bULL, 0x000fce0003f1d000ULL,
0x0000003300517306ULL, 0x000ea20000005400ULL, 0x0000007f7e00720bULL, 0x002fe40003fdd000ULL,
0x000000015d5d5812ULL, 0x000fc600078efcffULL, 0x0000000160600812ULL, 0x000fe400078efcffULL,
0x0000003000987306ULL, 0x0002e2000020d400ULL, 0x000000084200780cULL, 0x000fce0003f05270ULL,
0x0000009d00897306ULL, 0x000f22000020d400ULL, 0x00000082a930723eULL, 0x002fe400000010ffULL,
0x000000515000720bULL, 0x004fca0003f3d000ULL, 0x0000008600877306ULL, 0x000fe20000209400ULL,
0x000000302c04723cULL, 0x000fe20000041804ULL, 0x0000000198984812ULL, 0x008fc800078efcffULL,
0x000000985757723eULL, 0x000fe400000010ffULL, 0x0000008600887306ULL, 0x000e620000205400ULL,
0x00000010a7307824ULL, 0x000fe200078e00ffULL, 0x0000000189893812ULL, 0x010fc800078efcffULL,
0x0000004a894a723eULL, 0x000fe400000010ffULL, 0x0000008b007c7306ULL, 0x000ff00000209400ULL,
0x0000008b007d7306ULL, 0x000ea20000205400ULL, 0x000000888700720bULL, 0x002fce0003f9d000ULL,
0x0000003200527306ULL, 0x000ff00000009400ULL, 0x0000003200537306ULL, 0x000fe20000005400ULL,
0x0000007d7c00720bULL, 0x004fce0003f7d000ULL, 0x0000003200477306ULL, 0x0003f0000000d400ULL,
0x0000004800447306ULL, 0x000ea2000020d400ULL, 0x0000010032327824ULL, 0x002fca00078e00ffULL,
0x00000018ff777819ULL, 0x000fe40000011432ULL, 0x0000003300487306ULL, 0x0002f0000000d400ULL,
0x0000008600857306ULL, 0x000f22000020d400ULL, 0x000000003030783bULL, 0x002e620000000200ULL,
0x0000000144446812ULL, 0x004fc400078efcffULL, 0x000000535200720bULL, 0x000fe40003fdd000ULL,
0x0000003b4403723eULL, 0x000fe400000010ffULL, 0x0000008b007e7306ULL, 0x000ea2000020d400ULL,
0x0000000148481812ULL, 0x008fe400078efcffULL, 0x0000004c3744723eULL, 0x000fca00000010ffULL,
0x0000007700687306ULL, 0x000fe20000209400ULL, 0x0000000185854812ULL, 0x010fe400078efcffULL,
0x0000000147476812ULL, 0x000fe400078efcffULL, 0x000000855a4b723eULL, 0x000fc600000010ffULL,
0x0000007700657306ULL, 0x000ee20000205400ULL, 0x000000017e7e3812ULL, 0x004fc800078efcffULL,
0x000000477e5c723eULL, 0x000fc600000010ffULL, 0x0000008d00507306ULL, 0x000ff00000209400ULL,
0x0000008d002d7306ULL, 0x000ea20000205400ULL, 0x000000656800720bULL, 0x008fe20003f9d000ULL,
0x000000623008723cULL, 0x042fec0000041808ULL, 0x0000008e002c7306ULL, 0x000fe40000209400ULL,
0x000000383004723cULL, 0x040fec0000041804ULL, 0x0000008e002f7306ULL, 0x000e620000205400ULL,
0x0000002d5000720bULL, 0x004fe20003f5d000ULL, 0x000000023028723cULL, 0x040fec0000041828ULL,
0x0000007700527306ULL, 0x000ea4000020d400ULL, 0x000000443024723cULL, 0x040fec0000041824ULL,
0x0000008d008d7306ULL, 0x000ee2000020d400ULL, 0x0000002f2c00720bULL, 0x002fe20003f7d000ULL,
0x000000563020723cULL, 0x040fec0000041820ULL, 0x0000008e00497306ULL, 0x000e62000020d400ULL,
0x0000000152524812ULL, 0x004fe200078efcffULL, 0x0000004a301c723cULL, 0x000fe6000004181cULL,
0x000000525d5d723eULL, 0x000fc400000010ffULL, 0x000000018d8d2812ULL, 0x008fc800078efcffULL,
0x000000488d48723eULL, 0x000fe200000010ffULL, 0x0000005c3018723cULL, 0x000fe20000041818ULL,
0x0000000149493812ULL, 0x002fc800078efcffULL, 0x000000496049723eULL, 0x000fce00000010ffULL,
0x000000483014723cULL, 0x000fe20000041814ULL, 0x0000001000008944ULL, 0x000fe20003c00000ULL,
0xffffe16000007947ULL, 0x000fec000383ffffULL, 0x01b6140013037984ULL, 0x000e620000000800ULL,
0x0000ffff3c027812ULL, 0x000fe200078ec0ffULL, 0x0000002412247220ULL, 0x040fe40000410000ULL,
0x0000002512257220ULL, 0x000fe20000410000ULL, 0x00008880023a7816ULL, 0x000fe200000000ffULL,
0x0000000a122c7220ULL, 0x040fe40000410000ULL, 0x0000000b122d7220ULL, 0x040fe40000410000ULL,
0x00000006122e7220ULL, 0x000fc40000410000ULL, 0x00000007122f7220ULL, 0x040fe40000410000ULL,
0x0000002812287220ULL, 0x040fe40000410000ULL, 0x0000002912297220ULL, 0x040fe40000410000ULL,
0x0000002a122a7220ULL, 0x040fe40000410000ULL, 0x0000002b122b7220ULL, 0x040fe40000410000ULL,
0x0000002012207220ULL, 0x000fc40000410000ULL, 0x0000002112217220ULL, 0x000fe40000410000ULL,
0x800000003a027824ULL, 0x000fe400078e00ffULL, 0x0000000812087220ULL, 0x040fe40000410000ULL,
0x0000000912097220ULL, 0x040fe40000410000ULL, 0x0000000412047220ULL, 0x040fe40000410000ULL,
0x0000000512057220ULL, 0x000fc40000410000ULL, 0x0000002612307220ULL, 0x040fe40000410000ULL,
0x0000002712317220ULL, 0x040fe40000410000ULL, 0x0000002212327220ULL, 0x040fe20000410000ULL,
0x8000000003ff7812ULL, 0x002fe20007804802ULL, 0x0000002312337220ULL, 0x040fe40000410000ULL,
0x0000001e12347220ULL, 0x040fe40000410000ULL, 0x0000001f12357220ULL, 0x000fc40000410000ULL,
0x0000001a12367220ULL, 0x040fe40000410000ULL, 0x0000001b12377220ULL, 0x040fe40000410000ULL,
0x0000001412067220ULL, 0x040fe40000410000ULL, 0x0000001512077220ULL, 0x040fe40000410000ULL,
0x00000018121e7220ULL, 0x040fe40000410000ULL, 0x00000019121f7220ULL, 0x000fc40000410000ULL,
0x0000001612387220ULL, 0x040fe40000410000ULL, 0x0000001712397220ULL, 0x000fe40000410000ULL,
0x000000ffff187224ULL, 0x000fe400078e0024ULL, 0x000000ffff197224ULL, 0x000fe400078e0025ULL,
0x000000ffff167224ULL, 0x000fe400078e0028ULL, 0x000000ffff177224ULL, 0x000fc400078e0029ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0020ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0021ULL,
0x000000ffff227224ULL, 0x000fe400078e002cULL, 0x000000ffff237224ULL, 0x000fe400078e002dULL,
0x000000ffff247224ULL, 0x000fe400078e002eULL, 0x000000ffff257224ULL, 0x000fc400078e002fULL,
0x000000ffff267224ULL, 0x000fe400078e002aULL, 0x000000ffff277224ULL, 0x000fe400078e002bULL,
0x0000001c121c7220ULL, 0x040fe40000410000ULL, 0x0000001d121d7220ULL, 0x000fe40000410000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fc400078e0009ULL,
0x000000ffff147224ULL, 0x000fe400078e0004ULL, 0x000000ffff157224ULL, 0x000fe400078e0005ULL,
0x000000ffff207224ULL, 0x000fe400078e0006ULL, 0x000000ffff217224ULL, 0x000fe400078e0007ULL,
0x000000ffff287224ULL, 0x000fe400078e0030ULL, 0x000000ffff297224ULL, 0x000fc400078e0031ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0032ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0033ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0034ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0035ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0036ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0037ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fc400078e0038ULL, 0x000000ffff317224ULL, 0x000fe200078e0039ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000003a3a7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff027424ULL, 0x000fc800078e00ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x000000030000735dULL, 0x004fe40003800000ULL,
0x01b6140013037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc4000780483aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000040c037824ULL, 0x000fe200078e00ffULL,
0x0000003d1000720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff003057812ULL, 0x000fca00078ec0ffULL, 0x000000800e027824ULL, 0x000fca00078e0205ULL,
0x01b4000002047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000020c087824ULL, 0x000fe400078e00ffULL, 0x000000010f3e7824ULL, 0x000fc600078e0a3eULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x0000000109337812ULL, 0x040fe400078efcffULL,
0x0000000809357812ULL, 0x000fe400078efcffULL, 0x0000003e3300720cULL, 0x080fe40003f26070ULL,
0x0000001009337812ULL, 0x000fe400078efcffULL, 0x0000003e3500720cULL, 0x080fe40003f06070ULL,
0x0000003e3300720cULL, 0x000fc40003fc6070ULL, 0x0000001109357812ULL, 0x040fe400078efcffULL,
0x0000001809337812ULL, 0x040fe400078efcffULL, 0x0000003e0900720cULL, 0x080fe40003f46070ULL,
0x0000003e3500720cULL, 0x080fe40003fa6070ULL, 0x0000003e3300720cULL, 0x000fe40003f66070ULL,
0x0000000909377812ULL, 0x000fc400078efcffULL, 0x0000001909357812ULL, 0x040fe400078efcffULL,
0x0000002009337812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x0000003e3700720cULL, 0x080fe40003f86070ULL,
0x0000003e3500720cULL, 0x080fe40003f46070ULL, 0x0000003e3300720cULL, 0x000fe40003f26070ULL,
0x0000002109357812ULL, 0x040fe400078efcffULL, 0x0000002809337812ULL, 0x000fe400078efcffULL,
0xff7fffff24247808ULL, 0x000fc40004000000ULL, 0xff7fffff14147808ULL, 0x000fe40004000000ULL,
0xff7fffff25257808ULL, 0x000fe40006000000ULL, 0xff7fffff15157808ULL, 0x000fe40006000000ULL,
0x0000003e3500720cULL, 0x080fe40003f06070ULL, 0x0000003e3300720cULL, 0x000fe40003f86070ULL,
0x0000002909357812ULL, 0x000fc400078efcffULL, 0x0000003009337812ULL, 0x000fe400078efcffULL,
0xff7fffff26267808ULL, 0x000fe40007000000ULL, 0xff7fffff16167808ULL, 0x000fe40007000000ULL,
0xff7fffff27277808ULL, 0x000fe40006800000ULL, 0xff7fffff17177808ULL, 0x000fe40006800000ULL,
0x0000003e3500720cULL, 0x000fc40003fc6070ULL, 0x0000003e3300720cULL, 0x000fe40003fa6070ULL,
0x0000003109357812ULL, 0x040fe400078efcffULL, 0x0000003809337812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff7fffff28287808ULL, 0x000fe40005800000ULL,
0xff7fffff18187808ULL, 0x000fc40005800000ULL, 0xff7fffff29297808ULL, 0x000fe40005000000ULL,
0xff7fffff19197808ULL, 0x000fe40005000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40004800000ULL, 0x0000003e3500720cULL, 0x080fe40003f66070ULL,
0x0000003e3300720cULL, 0x000fc40003f46070ULL, 0x0000003e0900720cULL, 0x000fe40003f26070ULL,
0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004000000ULL,
0xff7fffff2c2c7808ULL, 0x000fe40006000000ULL, 0xff7fffff1c1c7808ULL, 0x000fe40006000000ULL,
0xff7fffff2d2d7808ULL, 0x000fc40007000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40007000000ULL,
0xff7fffff2e2e7808ULL, 0x000fe40006800000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40006800000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40005800000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40005800000ULL,
0xff7fffff30307808ULL, 0x000fc40005000000ULL, 0xff7fffff20207808ULL, 0x000fe40005000000ULL,
0xff7fffff31317808ULL, 0x000fe40004800000ULL, 0xff7fffff21217808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000b04097209ULL, 0x004fe40007810000ULL,
0x0000002205047209ULL, 0x000fe40007810000ULL, 0x0000000a09097209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fc40007810000ULL, 0x0000001409047209ULL, 0x000fe40007810000ULL,
0x0000002405087209ULL, 0x000fe40007810000ULL, 0x0000001504057209ULL, 0x000fe40007810000ULL,
0x0000002508097209ULL, 0x000fe40007810000ULL, 0x0000001605047209ULL, 0x000fe40007810000ULL,
0x0000002609087209ULL, 0x000fc40007810000ULL, 0x0000001704057209ULL, 0x000fe40007810000ULL,
0x0000002708097209ULL, 0x000fe40007810000ULL, 0x0000001805047209ULL, 0x000fe40007810000ULL,
0x0000002809087209ULL, 0x000fe40007810000ULL, 0x0000001904057209ULL, 0x000fe40007810000ULL,
0x0000002908097209ULL, 0x000fc40007810000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x0000002a09087209ULL, 0x000fe40007810000ULL, 0x0000001b04057209ULL, 0x000fe40007810000ULL,
0x0000002b08097209ULL, 0x000fe40007810000ULL, 0x0000001c05047209ULL, 0x000fe40007810000ULL,
0x0000002c09087209ULL, 0x000fc40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000002d08097209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000002e09087209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fe40007810000ULL,
0x0000002f08097209ULL, 0x000fc40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000003009087209ULL, 0x000fe40007810000ULL, 0x0000002104327209ULL, 0x000fe40007810000ULL,
0x0000003108347209ULL, 0x000fe20007810000ULL, 0x00000ef27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0032047f89ULL, 0x0004e400000e0000ULL, 0x0000000432357209ULL, 0x008fe20007810000ULL,
0x00000f327f007947ULL, 0x000fea000b800000ULL, 0x0c401f0034047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007107f89ULL, 0x000f6200000e0000ULL,
0x0000000434087209ULL, 0x008fc60007810000ULL, 0x0c201f0035047f89ULL, 0x000ee200000e0000ULL,
0x0000000506097209ULL, 0x010fc60007810000ULL, 0x0c201f0008057f89ULL, 0x000f2200000e0000ULL,
0x0000001007107209ULL, 0x020fc60007810000ULL, 0x0c201f0009327f89ULL, 0x006e6800000e0000ULL,
0x0c201f0010337f89ULL, 0x0004a200000e0000ULL, 0x0000000435047209ULL, 0x008fe40007810000ULL,
0x0000000508057209ULL, 0x010fe40007810000ULL, 0x0000003209067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fc40000000000ULL,
0x00000004ff347e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x0000000000057886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b15157823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b16167823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b17177823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x0000000a00097308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b19197823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010807ULL,
0x0000001400147308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1d1d7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010807ULL, 0x0000001500157308ULL, 0x000f220000000800ULL,
0x3fb8aa3b21077823ULL, 0x000fe20000010807ULL, 0x000000080908723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b05217820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010821ULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b23237823ULL, 0x100fe40000010821ULL,
0x3fb8aa3b24247823ULL, 0x100fe40000010821ULL, 0x3fb8aa3b25257823ULL, 0x100fe40000010821ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010821ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x00000014150a723eULL, 0x010fe200000010ffULL, 0x3fb8aa3b27277823ULL, 0x000fc40000010821ULL,
0x3fb8aa3b28287823ULL, 0x100fe40000010821ULL, 0x3fb8aa3b29297823ULL, 0x100fe40000010821ULL,
0x0000002300237308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe40000010821ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe40000010821ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe40000010821ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010821ULL, 0x00000024000b7308ULL, 0x0009e20000000800ULL,
0x3fb8aa3b2e2e7823ULL, 0x000fc40000010821ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe40000010821ULL,
0x3fb8aa3b30307823ULL, 0x100fe40000010821ULL, 0x3fb8aa3b31217823ULL, 0x000fe20000010821ULL,
0x0000002500327308ULL, 0x0023620000000800ULL, 0x3f8000003424783eULL, 0x010fe400000010ffULL,
0x000000222309723eULL, 0x008fca00000010ffULL, 0x0000001700177308ULL, 0x000ee20000000800ULL,
0x000000ffff257224ULL, 0x002fe200078e0024ULL, 0x0000000b320b723eULL, 0x020fcc00000010ffULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x000000240834723cULL, 0x000fe200000418ffULL,
0x000000161714723eULL, 0x008fcc00000010ffULL, 0x0000001900197308ULL, 0x000e700000000800ULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000ee20000000800ULL,
0x000000181916723eULL, 0x002fce00000010ffULL, 0x0000002800287308ULL, 0x000ff00000000800ULL,
0x0000002900297308ULL, 0x000e620000000800ULL, 0x000000262715723eULL, 0x008fce00000010ffULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x000000282917723eULL, 0x002fce00000010ffULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x000000241434723cULL, 0x000fee0000041834ULL,
0x0000001c001c7308ULL, 0x000ff00000000800ULL, 0x0000001d001d7308ULL, 0x000ee20000000800ULL,
0x0000001a1b18723eULL, 0x002fce00000010ffULL, 0x0000002a002a7308ULL, 0x000ff00000000800ULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x0000001c1d1a723eULL, 0x008fe400000010ffULL,
0xfffffffc0c1c7812ULL, 0x000fca00078ec0ffULL, 0x0000002c002c7308ULL, 0x000ff00000000800ULL,
0x0000002d002d7308ULL, 0x000ee20000000800ULL, 0x0000002a2b19723eULL, 0x002fce00000010ffULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x0000002c2d1b723eULL, 0x008fce00000010ffULL,
0x0000001f001f7308ULL, 0x000e620000000800ULL, 0x000000241834723cULL, 0x000fee0000041834ULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x0000000fff257424ULL, 0x000fce00078e00ffULL,
0x0000000700077308ULL, 0x000ee20000000800ULL, 0x0000001c25257219ULL, 0x000fe400000006ffULL,
0x0000001e1f1c723eULL, 0x002fe400000010ffULL, 0x00000000252273a1ULL, 0x000e6200000e8000ULL,
0x00000000250473c4ULL, 0x000f240000004000ULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000f620000000800ULL, 0x00000020071e723eULL, 0x008fe200000010ffULL,
0x000000ffff207224ULL, 0x000fe200078e0024ULL, 0x0000001033077209ULL, 0x004fca0007810000ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x0000000525ff7c12ULL, 0x002fce000f804022ULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x00000030211f723eULL, 0x020fe200000010ffULL,
0x000000ffff217224ULL, 0x000fe200078e0024ULL, 0x0000002e2f1d723eULL, 0x002fce00000010ffULL,
0x000000201c34723cULL, 0x000fe20000041834ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000b0204008947ULL, 0x010fde000b800000ULL, 0x001c1fff34207589ULL, 0x0002a400000e0000ULL,
0x00000000251073a1ULL, 0x000ee200000e8000ULL, 0x00000000250473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x0000000525ff7c12ULL, 0x008fda000f804010ULL,
0x00000b2204008947ULL, 0x010fea000b800000ULL, 0x001c1fff36217589ULL, 0x00072800000e0000ULL,
0x001c1fff22227589ULL, 0x00066800000e0000ULL, 0x001c1fff00237589ULL, 0x0006a400000e0000ULL,
0x00000002ff107819ULL, 0x000fe4000001160cULL, 0x0000000c033b7812ULL, 0x000fc400078ec0ffULL,
0x0000000710247812ULL, 0x040fe200078ec0ffULL, 0x0000000810277824ULL, 0x040fe200078e00ffULL,
0x00000010ff267212ULL, 0x000fe200078e33ffULL, 0x0000000810257824ULL, 0x00afe200078e00ffULL,
0x000000030cff7812ULL, 0x000fe2000780c0ffULL, 0x0000000810337824ULL, 0x040fe200078e00ffULL,
0x0000000810107810ULL, 0x000fe40007ffe0ffULL, 0x0000000127297812ULL, 0x140fe400078ef624ULL,
0x00000002272b7812ULL, 0x140fe200078ef624ULL, 0x00000008104b7824ULL, 0x040fe200078e00ffULL,
0x00000003272d7812ULL, 0x140fe200078ef624ULL, 0x0000000810357824ULL, 0x040fe200078e00ffULL,
0x00000004272f7812ULL, 0x140fe200078ef624ULL, 0x0000000810377824ULL, 0x000fe200078e00ffULL,
0x0000000527317812ULL, 0x000fc400078ef624ULL, 0xfffffff825257812ULL, 0x100fe400078ee224ULL,
0x0000000627277812ULL, 0x000fe400078ef624ULL, 0xfffffff833337812ULL, 0x000fe400078ee226ULL,
0x00000010ff267212ULL, 0x000fe400078e33ffULL, 0x0000000710247812ULL, 0x000fe400078ec0ffULL,
0x000110000e107811ULL, 0x000fc400078e58ffULL, 0xfffffff835357812ULL, 0x100fe400078ee224ULL,
0x0000000137397812ULL, 0x000fe200078ef624ULL, 0x0000001025037824ULL, 0x000fe200078e0210ULL,
0x00000002373f7812ULL, 0x000fe200078ef624ULL, 0x000000102d287824ULL, 0x000fe200078e0210ULL,
0x0000000337437812ULL, 0x000fe200078ef624ULL, 0x000000102f2a7824ULL, 0x000fe200078e0210ULL,
0x0000000437457812ULL, 0x100fe200078ef624ULL, 0x000000013b037824ULL, 0x000fe200078e0203ULL,
0x0000000537477812ULL, 0x000fe200078ef624ULL, 0x00000010312c7824ULL, 0x000fe200078e0210ULL,
0x0000000637497812ULL, 0x000fe200078ef624ULL, 0x0000001029247824ULL, 0x000fe200078e0210ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee226ULL, 0x000000102b267824ULL, 0x100fe200078e0210ULL,
0x0000000803007388ULL, 0x0003e20000000800ULL, 0x00000010272e7824ULL, 0x000fc400078e0210ULL,
0x000000013b257824ULL, 0x040fe400078e0224ULL, 0x000000013b277824ULL, 0x000fe400078e0226ULL,
0x0000001033307824ULL, 0x000fe200078e0210ULL, 0x0000000a25007388ULL, 0x0007e20000000800ULL,
0x000000013b297824ULL, 0x000fe400078e0228ULL, 0x0000001035327824ULL, 0x000fe200078e0210ULL,
0x0000001427007388ULL, 0x0007e20000000800ULL, 0x000000013b2b7824ULL, 0x000fc400078e022aULL,
0x0000001039337824ULL, 0x000fe200078e0210ULL, 0x0000001629007388ULL, 0x0007e20000000800ULL,
0x000000013b2d7824ULL, 0x000fe400078e022cULL, 0x000000103f347824ULL, 0x000fe200078e0210ULL,
0x000000182b007388ULL, 0x0007e20000000800ULL, 0x000000013b2f7824ULL, 0x000fe400078e022eULL,
0x0000001043357824ULL, 0x000fe200078e0210ULL, 0x0000001a2d007388ULL, 0x0007e20000000800ULL,
0x000000013b317824ULL, 0x000fc400078e0230ULL, 0x0000001045367824ULL, 0x100fe200078e0210ULL,
0x0000001c2f007388ULL, 0x0007e20000000800ULL, 0x0000001047377824ULL, 0x100fe400078e0210ULL,
0x0000001049387824ULL, 0x100fe200078e0210ULL, 0x0000001e31007388ULL, 0x0007e20000000800ULL,
0x000000104b397824ULL, 0x000fe400078e0210ULL, 0x000000013b327824ULL, 0x040fe400078e0232ULL,
0x000000013b107824ULL, 0x000fc400078e0233ULL, 0x000000013b347824ULL, 0x040fe200078e0234ULL,
0x0000000932007388ULL, 0x0007e20000000800ULL, 0x000000013b087824ULL, 0x042fe400078e0235ULL,
0x000000013b367824ULL, 0x040fe200078e0236ULL, 0x0000000b10007388ULL, 0x0007e20000000800ULL,
0x000000013b247824ULL, 0x040fe400078e0237ULL, 0x000000013b387824ULL, 0x040fe200078e0238ULL,
0x0000001534007388ULL, 0x0007e20000000800ULL, 0x000000013b267824ULL, 0x000fc600078e0239ULL,
0x0000001708007388ULL, 0x0007e80000000800ULL, 0x0000001936007388ULL, 0x0007e80000000800ULL,
0x0000001b24007388ULL, 0x0007e80000000800ULL, 0x0000001d38007388ULL, 0x0007e80000000800ULL,
0x0000001f26007388ULL, 0x0007e80000000800ULL, 0x01b0000402008388ULL, 0x0007e80000000c00ULL,
0x01b2002002008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000114000720cULL, 0x000fe20003f26070ULL, 0x01b6080013ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff3cff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff107224ULL, 0x008fc400078e0040ULL,
0x000000ffff3f7224ULL, 0x000fe200078e0041ULL, 0x00000001ff3c7807ULL, 0x000fce0000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffafe000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff337224ULL, 0x000fe200078e005bULL,
0x00015f70002e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fe400078e0052ULL,
0x0000001fff347424ULL, 0x000fe400078e00ffULL, 0xffffffffff357424ULL, 0x000fe400078e00ffULL,
0x0000079000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff307224ULL, 0x004fe200078e0031ULL,
0xffff811000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e0052ULL,
0x00015ff0002e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff337224ULL, 0x000fe400078e005dULL,
0x0000001fff347424ULL, 0x000fc400078e00ffULL, 0xffffffffff357424ULL, 0x000fe400078e00ffULL,
0x0000071000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2e7224ULL, 0x004fe200078e0031ULL,
0xffff80b000007947ULL, 0x000fea000383ffffULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x0001606000087802ULL, 0x000fe20000000f00ULL, 0x0000001fff367424ULL, 0x000fe400078e00ffULL,
0xffffffffff377424ULL, 0x000fe400078e00ffULL, 0x0000066000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0033ULL, 0xfffff0b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x006fe200078e0034ULL, 0x000160e000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fe400078e00ffULL, 0x0000001fff367424ULL, 0x000fc400078e00ffULL,
0xffffffffff377424ULL, 0x000fe400078e00ffULL, 0x000005e000007944ULL, 0x000fea0003c00000ULL,
0x0000003334347209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x002fe200078e0006ULL,
0x0001615000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe400078e00ffULL,
0x0000001fff367424ULL, 0x000fe400078e00ffULL, 0xffffffffff377424ULL, 0x000fe400078e00ffULL,
0x0000057000007944ULL, 0x000fea0003c00000ULL, 0x0000003306067209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x002fe200078e0007ULL, 0x000161c000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fc400078e00ffULL, 0x0000001fff367424ULL, 0x000fe400078e00ffULL,
0xffffffffff377424ULL, 0x000fe400078e00ffULL, 0x0000050000007944ULL, 0x000fea0003c00000ULL,
0x0000003307107209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x002fe200078e0035ULL,
0x0001623000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe400078e00ffULL,
0x0000001fff367424ULL, 0x000fe400078e00ffULL, 0xffffffffff377424ULL, 0x000fe400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x0000003335047209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x002fe200078e0034ULL, 0x000162a000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fc400078e00ffULL, 0x0000001fff367424ULL, 0x000fe400078e00ffULL,
0xffffffffff377424ULL, 0x000fe400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x0000003334057209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x002fe200078e0006ULL,
0x0001631000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe400078e00ffULL,
0x0000001fff367424ULL, 0x000fe400078e00ffULL, 0xffffffffff377424ULL, 0x000fe400078e00ffULL,
0x000003b000007944ULL, 0x000fea0003c00000ULL, 0x0000003306067209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x002fe200078e0010ULL, 0x0001638000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fc400078e00ffULL, 0x0000001fff367424ULL, 0x000fe400078e00ffULL,
0xffffffffff377424ULL, 0x000fe400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0xffffee9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x000fe200078e0034ULL,
0x000163f0002e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff337224ULL, 0x000fe400078e00ffULL,
0x00001c1fff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff357224ULL, 0x000fe400078e0025ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e0031ULL,
0xfffff49000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e0036ULL,
0x00016470002e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff337224ULL, 0x000fc400078e00ffULL,
0x00001c1fff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff357224ULL, 0x000fe400078e0025ULL,
0x0000029000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff337224ULL, 0x002fe200078e00ffULL,
0x000164d0002e7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff347424ULL, 0x000fe400078e00ffULL,
0x000000ffff357224ULL, 0x000fe400078e0025ULL, 0x000000ffff217224ULL, 0x004fe400078e0031ULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff357224ULL, 0x002fe200078e0025ULL,
0x00016530002e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff337224ULL, 0x000fc400078e00ffULL,
0x00001c1fff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff227224ULL, 0x004fe400078e0031ULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff237224ULL, 0x004fe200078e0031ULL,
0xfffff3d000007947ULL, 0x000fea000383ffffULL, 0x0180000005007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000000500008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff077807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000007ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000005057812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000007ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000500007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffe994006007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003700007348ULL, 0x000fe80003800000ULL,
0x0c00003332337389ULL, 0x0002a200000e0036ULL, 0xfffe990008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000003500007348ULL, 0x000fe80003800000ULL,
0x0000003332317389ULL, 0x0002a200000e0034ULL, 0xfffe98c02e007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001b680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000778ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007f0ULL, 0x0000000000000500ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000cf0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d10ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000d20ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000d40ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000db0ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000db8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000dc8ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000f80ULL, 0x0000000000016800ULL, 0xff00001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017780ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000017790ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017790ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000017c10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000db0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000169d0ULL, 0x00000000000169d0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017780ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000017c10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_16_m_16_sm_80_cubin_len = 97520;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
