/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000188b0ULL, 0x0000000000018530ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x346a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4532336a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL,
0x2400000000000000ULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000017cULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b00010000020cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b000100000253ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b000100000299ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b000100000383ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000b0001000003d1ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00220000042cULL, 0x0000000000016ec0ULL,
0x0000000000000240ULL, 0x00040003000004a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000017100ULL, 0x000d0003000004d2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00016ec000000000ULL,
0x0001380400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x00016ec000000000ULL, 0x0000024000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000b9ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000a00000000ULL, 0x000c17040021f000ULL,
0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040061f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0xffffffff00dc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000002d000dc2804ULL, 0x000009f000000370ULL, 0x00002dc000002d50ULL, 0x00002fd000002ea0ULL,
0x0000324000003100ULL, 0x000037b0000037a0ULL, 0x000037d0000037c0ULL, 0x0000557000005500ULL,
0x0000579000005660ULL, 0x00005a00000058c0ULL, 0x00005ed000005ec0ULL, 0x00005ef000005ee0ULL,
0x00007d0000007c90ULL, 0x00007f2000007df0ULL, 0x0000819000008050ULL, 0x0000867000008660ULL,
0x0000869000008680ULL, 0x0000a3200000a2b0ULL, 0x0000a5400000a410ULL, 0x0000a7b00000a670ULL,
0x0000acb00000aca0ULL, 0x0000acd00000acc0ULL, 0x0000bf700000bf60ULL, 0x0000bf900000bf80ULL,
0x000156e000015630ULL, 0x00015ad0000159d0ULL, 0x00015f9000015e70ULL, 0x0001634000016240ULL,
0x0000053004303904ULL, 0x0001a600000000ffULL, 0x0000061000040100ULL, 0x0001a60800000008ULL,
0x00000720003f0100ULL, 0x0001a68800000008ULL, 0x00000860003f0100ULL, 0x0001a6a800000000ULL,
0x00000960003f0100ULL, 0x0001a6c800000004ULL, 0x000013d0003f0100ULL, 0x0001a60000000008ULL,
0x000014f0003f0107ULL, 0x0001a68800000002ULL, 0x00001e40003f0101ULL, 0x00000000000000ffULL,
0x00001ec000040107ULL, 0x00000000000000ffULL, 0x00001f4000040101ULL, 0x0000002000000002ULL,
0x00002060003f0101ULL, 0x0001a6c800000038ULL, 0x000021e0003f0109ULL, 0x0001a6c800000038ULL,
0x00002a40003f0109ULL, 0x0001a6b00000003aULL, 0x00002aa0003f0107ULL, 0x0001a6b00000003aULL,
0x00002ab0003f0101ULL, 0x0001a60800000038ULL, 0x00002af0003f0101ULL, 0x0001a60800000073ULL,
0x00002c60003f0109ULL, 0x0001a60800000073ULL, 0x000033d0003f0109ULL, 0x0001a6a80000003aULL,
0x00003560003f0109ULL, 0x0001a6a80000003aULL, 0x00004940003f0109ULL, 0x0001a6c800000034ULL,
0x00004950003f0101ULL, 0x0001a68800000036ULL, 0x00004970003f0101ULL, 0x0000000000000006ULL,
0x00004ae0003f0109ULL, 0x0000000000000006ULL, 0x00005230003f0109ULL, 0x00000000000000ffULL,
0x0000527000050107ULL, 0x00000000000000ffULL, 0x0000528000050101ULL, 0x0001a62800000073ULL,
0x000052e0003f0101ULL, 0x0001a6280000004dULL, 0x00005450003f0109ULL, 0x0001a6280000004dULL,
0x00005bc0003f0109ULL, 0x0001a6b000000037ULL, 0x00005d30003f0109ULL, 0x0001a6b000000037ULL,
0x00007080003f0109ULL, 0x0001a6c800000034ULL, 0x00007090003f0101ULL, 0x0001a69000000036ULL,
0x000070b0003f0101ULL, 0x0000000000000006ULL, 0x00007220003f0109ULL, 0x0000000000000006ULL,
0x000079a0003f0109ULL, 0x00000008000000ffULL, 0x00007a0000040107ULL, 0x0000000800000084ULL,
0x00007a10003f0101ULL, 0x0001a64800000073ULL, 0x00007a80003f0101ULL, 0x0001a6480000004dULL,
0x00007bf0003f0109ULL, 0x0001a6480000004dULL, 0x00008350003f0109ULL, 0x00000000000000ffULL,
0x000084c000050109ULL, 0x00000000000000ffULL, 0x000096e000050109ULL, 0x0001a6c800000034ULL,
0x000096f0003f0101ULL, 0x0001a69800000073ULL, 0x00009720003f0101ULL, 0x0000000000000006ULL,
0x00009890003f0109ULL, 0x0000000000000006ULL, 0x0000a030003f0109ULL, 0x00000000000000ffULL,
0x0000a07000040107ULL, 0x00000000000000ffULL, 0x0000a08000050101ULL, 0x0001a66800000007ULL,
0x0000a0a0003f0101ULL, 0x0001a66800000007ULL, 0x0000a210003f0109ULL, 0x0001a66800000007ULL,
0x0000a960003f0109ULL, 0x0001a6b000000037ULL, 0x0000aad0003f0109ULL, 0x0001a6b000000037ULL,
0x0000bc20003f0109ULL, 0x0000000000000006ULL, 0x0000bc70003f0101ULL, 0x0001a6a000000006ULL,
0x0000df90003f0101ULL, 0x0001a60000000008ULL, 0x0000f7e0003f0101ULL, 0x0001a60000000008ULL,
0x0000f9a0003f0109ULL, 0x0001a60000000008ULL, 0x0000fce0003f0109ULL, 0x0001a60000000008ULL,
0x0000fd00003f0101ULL, 0x0001a60000000008ULL, 0x0000fe70003f0109ULL, 0x0001a60000000008ULL,
0x00012c80003f0109ULL, 0x0001a68800000075ULL, 0x00013050003f0101ULL, 0x0001a68800000075ULL,
0x000131c0003f0109ULL, 0x0001a68800000075ULL, 0x00016e60003f0109ULL, 0x0001a60800000065ULL,
0x00016e70003f0101ULL, 0x0001a61000000065ULL, 0x00016e80003f0101ULL, 0x0001a61800000065ULL,
0x00016e90003f0101ULL, 0x0001a62000000065ULL, 0x00053803003f0101ULL, 0x0000cea000301c04ULL,
0x0000d1900000ced0ULL, 0x0000d5700000d380ULL, 0x0000d9500000d760ULL, 0x0000dd400000db40ULL,
0x0000fea00000def0ULL, 0x000c050400016eb0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0060190300000000ULL, 0x0000001600080a04ULL, 0x0000000000600210ULL, 0x00000000000000bcULL,
0x0000001500000002ULL, 0x0000000000016ec0ULL, 0x0000000000000044ULL, 0x0000001500000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001500000002ULL, 0x0000000000000000ULL,
0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000067919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff0c7b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff042b82ULL, 0x000ea20000000a00ULL,
0x0000000106072836ULL, 0x008fe40000000000ULL, 0x0000000406022825ULL, 0x004fc800078e0004ULL,
0x0000000407042825ULL, 0x000fe400078e0004ULL, 0x0000000602022981ULL, 0x0004e8000c1e1900ULL,
0x0000000604072981ULL, 0x000ae2000c1e1900ULL, 0x0000000c00007306ULL, 0x010f220000209000ULL,
0x0000040000047ab9ULL, 0x000fe20000000800ULL, 0x000000ff0c00720cULL, 0x000fe20003f65070ULL,
0x0000000000107919ULL, 0x000ea20000002300ULL, 0x0000010000057ab9ULL, 0x000fe20000000800ULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x0000000000777919ULL, 0x000ea40000002100ULL,
0x0000000000007308ULL, 0x010f240000001000ULL, 0x0ffffffe00087836ULL, 0x010fcc0000000000ULL,
0x0000000800097305ULL, 0x0008a4000021f000ULL, 0x000000ffff087224ULL, 0x010fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x006fc800078e0a09ULL, 0x0000000c0b0b7224ULL, 0x000fc800078e02ffULL,
0x0000000b09097227ULL, 0x000fe400078e0008ULL, 0x00000000000b7919ULL, 0x000e680000002200ULL,
0x0000000409097c27ULL, 0x000fc8000f8e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a09ULL,
0x000000040c037e24ULL, 0x000fe2000f8e0203ULL, 0x00000000000479c3ULL, 0x000ea80000002600ULL,
0x0000000c0300720cULL, 0x000fda0003f06070ULL, 0x0000000103030824ULL, 0x000fe400078e0a0cULL,
0x0000000109090836ULL, 0x000fc60000000000ULL, 0x0000000c0300720cULL, 0x000fda0003f26070ULL,
0x0000000109091836ULL, 0x000fe20000000000ULL, 0x0000000cff09b212ULL, 0x000fc800078e33ffULL,
0x0000000900007306ULL, 0x000f220000209000ULL, 0x000000ff0900720cULL, 0x000fce0003f65070ULL,
0x0000000000007308ULL, 0x010f640000001000ULL, 0x0ffffffe00047836ULL, 0x020fe40000000000ULL,
0x0000000510007c24ULL, 0x002fe2000f8e020bULL, 0x0000000000057ab9ULL, 0x000fc60000000800ULL,
0x0000000400057305ULL, 0x000322000021f000ULL, 0x00001fff10107589ULL, 0x000f6200000e0000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x0000000509037224ULL, 0x010fc800078e02ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a03ULL, 0x0000000305057227ULL, 0x000fc800078e0004ULL,
0x0000000500047c24ULL, 0x100fe2000f8e0277ULL, 0x00000005ff777819ULL, 0x000fe20000011677ULL,
0x0000000405797c27ULL, 0x004fc6000f8e00ffULL, 0x0000007f0400780cULL, 0x040fe20003fa4070ULL,
0x000000ffff087224ULL, 0x000fe200078e0a79ULL, 0x00001fff77777589ULL, 0x000f6200000e0000ULL,
0x000000030400780cULL, 0x000fe40003f84070ULL, 0x0000000409007e24ULL, 0x000fca000f8e0208ULL,
0x000000090000720cULL, 0x000fc60003f06070ULL, 0x000000000005d919ULL, 0x000e740000008800ULL,
0x0000000100000824ULL, 0x000fc400078e0a09ULL, 0x0000000179790836ULL, 0x000fe20000000000ULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x000000090000720cULL, 0x000fe40003f26070ULL,
0x000004000000d802ULL, 0x000fd60000000f00ULL, 0x0000000179791836ULL, 0x000fe20000000000ULL,
0x00000009ff79b212ULL, 0x000fe400078e33ffULL, 0x0000000f0400780cULL, 0x040fe40003f24070ULL,
0x00000654050bd816ULL, 0x002fe20000000000ULL, 0x000000ffff647224ULL, 0x000fe200078e0a79ULL,
0x000000010400780cULL, 0x000fe20003f64070ULL, 0xff317217ff05d424ULL, 0x000fe400078e00ffULL,
0x0000000409647e24ULL, 0x000fc4000f8e0264ULL, 0x000000040400d824ULL, 0x000fe400078e020bULL,
0x0000000107032824ULL, 0x008fe400078e0a02ULL, 0x00008400ff07ab82ULL, 0x000eb00000000800ULL,
0x00008400ff03ab82ULL, 0x000ee20000000800ULL, 0x0000000000240947ULL, 0x020fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01a60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x00afe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404087c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a60804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x00afea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404087c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a68804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x00afea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01a400050000d388ULL, 0x0003e20000000800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000002064647824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000404007c11ULL, 0x002fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000000912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6a804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x00afea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000040912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6c804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x00afea000393ffffULL, 0x0000000803057c24ULL, 0x00afe2000f8e02ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff007224ULL, 0x000fe200078e0a64ULL, 0x000000640500720cULL, 0x000fe20003f06070ULL,
0x000000070602a224ULL, 0x004fc400078e02ffULL, 0x000000080c157c24ULL, 0x000fe2000f8e02ffULL,
0x00000020050b7446ULL, 0x000fe20003800000ULL, 0x0000000410007824ULL, 0x000fe400078e0277ULL,
0x00000015020a7224ULL, 0x000fe200078e02ffULL, 0x000000ff0b0b7207ULL, 0x000fe20000000000ULL,
0x0000000400007824ULL, 0x000fe400078e00ffULL, 0x0000000879197c24ULL, 0x000fe2000f8e020aULL,
0x000000200b00780cULL, 0x000fda0003f05270ULL, 0x00000004002c8947ULL, 0x000fea0003800000ULL,
0x0000000800087d06ULL, 0x000e620008209000ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00008c0000047ab9ULL, 0x000fca0000000a00ULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08057836ULL, 0x002fe20000000000ULL,
0x00000004ff077819ULL, 0x004fca0000011609ULL, 0x0000000500057305ULL, 0x000e62000021f000ULL,
0x0000000207117836ULL, 0x000fe40000000000ULL, 0x00000001000d7824ULL, 0x040fe400078e0207ULL,
0x0000000100127824ULL, 0x000fc800078e0211ULL, 0x0000000164147824ULL, 0x000fe400078e0212ULL,
0x000000ffff0f7224ULL, 0x002fc800078e0a05ULL, 0x000000080f0f7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000f050f7227ULL, 0x000fc800078e0004ULL, 0x0000000164047824ULL, 0x000fc800078e020dULL,
0x000000040f057227ULL, 0x000fc800078e00ffULL, 0x000000140f0f7227ULL, 0x000fc800078e00ffULL,
0x000000ffff137224ULL, 0x000fe400078e0a05ULL, 0x000000ffff177224ULL, 0x000fe400078e0a0fULL,
0x0000000813087c24ULL, 0x000fe4000f8e0204ULL, 0x00000008170e7c24ULL, 0x000fe4000f8e0214ULL,
0x0000000000177919ULL, 0x000e620000008800ULL, 0x0000000808007c0cULL, 0x000fe4000bf06070ULL,
0x000000080e007c0cULL, 0x000fd6000bf46070ULL, 0x8000000808080c36ULL, 0x000fe40008000000ULL,
0x800000080e0e2c36ULL, 0x000fe40008000000ULL, 0x0000000105050836ULL, 0x000fe20000000000ULL,
0x0000000808007c0cULL, 0x000fe2000bf26070ULL, 0x000000010f0f2836ULL, 0x000fe20000000000ULL,
0x000000080e007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff087c12ULL, 0x000fce000f8e33ffULL, 0x0000000105051836ULL, 0x000fe40000000000ULL,
0x000000010f0f3836ULL, 0x000fc60000000000ULL, 0x00000005080e7207ULL, 0x040fe40004000000ULL,
0x0000000f08137207ULL, 0x000fe40004000000ULL, 0x0000040000087802ULL, 0x000fe20000000f00ULL,
0x000000ffff057224ULL, 0x000fe400078e0a0eULL, 0x000000ffff0f7224ULL, 0x000fe200078e0a13ULL,
0x0000065417087816ULL, 0x002fe20000000008ULL, 0x0000000805047c24ULL, 0x000fe2000f8e0204ULL,
0x000000000b057248ULL, 0x000fe20007fe0000ULL, 0x000000080f147c24ULL, 0x000fc4000f8e0214ULL,
0x00000001190f7824ULL, 0x040fe400078e0204ULL, 0x0000000119147824ULL, 0x000fe400078e0214ULL,
0x0000000105057824ULL, 0x000fe400078e0a00ULL, 0x000000150e047224ULL, 0x000fe400078e020fULL,
0x0000001009007824ULL, 0x000fe200078e00ffULL, 0x000000050700720cULL, 0x000fe20003f06070ULL,
0x00000015130e7224ULL, 0x000fe200078e0214ULL, 0x000000051100720cULL, 0x000fe20003f26070ULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x000000f000077812ULL, 0x000fc600078ec0ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000704047212ULL, 0x000fc600078efcffULL,
0x000000010d117824ULL, 0x140fe200078e0209ULL, 0x000000070e077212ULL, 0x000fe200078efcffULL,
0x000000100d147824ULL, 0x000fe200078e00ffULL, 0x0000000404047c10ULL, 0x000fe2000ff5e0ffULL,
0x00000001120d7824ULL, 0x040fe200078e0209ULL, 0x00000004070e7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001012127824ULL, 0x000fe200078e00ffULL, 0xfffffff014117812ULL, 0x000fe400078ee211ULL,
0x0000000505057c10ULL, 0x000fe400097fe4ffULL, 0xfffffff0120d7812ULL, 0x000fe200078ee20dULL,
0x0000001011117824ULL, 0x000fe200078e0208ULL, 0x000000050f0f7c10ULL, 0x000fc60009ffe4ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004117faeULL, 0x0003e8000c101c46ULL, 0x000000000e0d7faeULL, 0x0003e2000c901c46ULL,
0x0000000400107947ULL, 0x000fea0003800000ULL, 0x0000000800087d06ULL, 0x000e620008209000ULL,
0x0000000000097919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000127919ULL, 0x000ee80000008800ULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08057836ULL, 0x002fe20000000000ULL,
0x0000000009077211ULL, 0x004fca00078fe0ffULL, 0x0000000500057305ULL, 0x000e62000021f000ULL,
0x0000000207117836ULL, 0x000fe40000000000ULL, 0x0000000164007824ULL, 0x040fe400078e0207ULL,
0x0000000164087824ULL, 0x000fe400078e0211ULL, 0x0000001011147824ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a05ULL, 0x000000080d0d7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000d050d7227ULL, 0x000fcc00078e0004ULL, 0x000000000d047227ULL, 0x000fc800078e00ffULL,
0x000000080d0d7227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0a0dULL, 0x0000000805057c24ULL, 0x000fe4000f8e0200ULL,
0x000000080f0e7c24ULL, 0x000fc6000f8e0208ULL, 0x0000000805007c0cULL, 0x000fe4000bf06070ULL,
0x000000080e007c0cULL, 0x000fd6000bf46070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x800000080e0e2c36ULL, 0x000fe40008000000ULL, 0x0000000104040836ULL, 0x000fe20000000000ULL,
0x0000000805007c0cULL, 0x000fe2000bf26070ULL, 0x000000010d0d2836ULL, 0x000fe20000000000ULL,
0x000000080e007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff057c12ULL, 0x000fce000f8e33ffULL, 0x0000000104041836ULL, 0x000fe40000000000ULL,
0x000000010d0d3836ULL, 0x000fc60000000000ULL, 0x0000000405047207ULL, 0x040fe40004000000ULL,
0x0000000d050d7207ULL, 0x000fc60004000000ULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0a0dULL, 0x0000000805007c24ULL, 0x000fe4000f8e0200ULL,
0x000000080f087c24ULL, 0x000fe2000f8e0208ULL, 0x00000400000f7802ULL, 0x000fe20000000f00ULL,
0x0000000119057824ULL, 0x040fe400078e0200ULL, 0x0000000119087824ULL, 0x000fc400078e0208ULL,
0x0000001009007824ULL, 0x000fe400078e00ffULL, 0x0000001504057224ULL, 0x080fe400078e0205ULL,
0x000000150d0e7224ULL, 0x000fe200078e0208ULL, 0x0000065412087816ULL, 0x008fe2000000000fULL,
0x0000010005047825ULL, 0x000fe200078e00ffULL, 0x000000f000137812ULL, 0x000fc600078ec0ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000001304047212ULL, 0x000fc600078efcffULL,
0x00000001070d7824ULL, 0x140fe200078e0209ULL, 0x000000130e0e7212ULL, 0x000fe200078efcffULL,
0x0000001007127824ULL, 0x000fe200078e00ffULL, 0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000111077824ULL, 0x000fe200078e0209ULL, 0x000000040e0e7c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff0120d7812ULL, 0x000fe400078ee20dULL, 0xfffffff014077812ULL, 0x000fe400078ee207ULL,
0x0000000505057c10ULL, 0x000fe200087fe4ffULL, 0x000000100d0d7824ULL, 0x100fe200078e0208ULL,
0x000000050f0f7c10ULL, 0x000fe20008ffe4ffULL, 0x0000001007077824ULL, 0x000fc600078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000b901c46ULL,
0x000000000e077faeULL, 0x0003e4000b901c46ULL, 0x00000000080472caULL, 0x000fe200000e0000ULL,
0x00009200ff627b82ULL, 0x000ea20000000a00ULL, 0x0000000000007918ULL, 0x002fd60000000000ULL,
0x0001a60004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000406627825ULL, 0x004fe200078e0062ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0000000662627981ULL, 0x000ea2000c1e1900ULL,
0x000000ff1000720cULL, 0x000fe20003f05270ULL, 0x000000ff62077836ULL, 0x004fca0000000000ULL,
0x00000008ff607819ULL, 0x000fce0000011607ULL, 0x000000c800a08947ULL, 0x000fea0003800000ULL,
0x0000000877637824ULL, 0x000fe200078e00ffULL, 0x000001ff0700780cULL, 0x000fe20003f04070ULL,
0x00000004ff037424ULL, 0x000fe200078e00ffULL, 0x00000001ff617819ULL, 0x000fe20000011677ULL,
0x0000000108027824ULL, 0x000fe200078e0263ULL, 0x0000940000047ab9ULL, 0x000fe20000000800ULL,
0x0000000177657812ULL, 0x000fe400078ec0ffULL, 0x01a6880302ff79a7ULL, 0x0003e2000850003fULL,
0x00000020615b7824ULL, 0x000fe400078e00ffULL, 0x0000000206037824ULL, 0x002fc800078e00ffULL,
0x0000000c035a7224ULL, 0x000fc800078e020cULL, 0x00000001795a7824ULL, 0x000fc800078e025aULL,
0x000000045a047c24ULL, 0x000fe2000f8e025bULL, 0x0000000400000947ULL, 0x000fec0003800000ULL,
0x0000005b62027248ULL, 0x000fe20007fe0000ULL, 0x0000001065037824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fe20000011609ULL, 0x0000900000047ab9ULL, 0x000fe40000000a00ULL,
0x0000000102027824ULL, 0x000fe400078e0a5bULL, 0x0000000103067824ULL, 0x000fe400078e0205ULL,
0x00000004050c7836ULL, 0x000fe20000000000ULL, 0x0000000302027248ULL, 0x000fe20007fe0000ULL,
0x0000000106077824ULL, 0x000fc400078e0209ULL, 0x00000008060e7824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fe400078e0a03ULL, 0x0000000c050d7836ULL, 0x000fe20000000000ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL, 0x0000000805077836ULL, 0x000fe20000000000ULL,
0x000000020c00720cULL, 0x080fe20003f46070ULL, 0x00000001030c7824ULL, 0x000fe200078e020cULL,
0x000000020500720cULL, 0x080fe20003f66070ULL, 0x0000000104067824ULL, 0x000fe200078e0206ULL,
0x000000020700720cULL, 0x080fe20003f26070ULL, 0x000000010c057824ULL, 0x040fe200078e0209ULL,
0x000000020d00720cULL, 0x000fe20003f06070ULL, 0x000000080c107824ULL, 0x000fc400078e00ffULL,
0x0000000103077824ULL, 0x040fe400078e0207ULL, 0x00000001030f7824ULL, 0x000fe200078e020dULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x0000008006027825ULL, 0x000fc800078e00ffULL,
0x0000000104057824ULL, 0x040fe200078e020cULL, 0x00000070020c7812ULL, 0x000fe200078ef800ULL,
0x0000000104067824ULL, 0x040fe400078e0207ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x000000040c0c7c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000107047824ULL, 0x040fe400078e0209ULL,
0x00000008070d7824ULL, 0x000fe400078e00ffULL, 0x0000200061027824ULL, 0x000fc400078e0208ULL,
0x000000010f077824ULL, 0x040fe200078e0209ULL, 0xfffffff80d127812ULL, 0x000fe200078ee204ULL,
0x000000080f147824ULL, 0x000fe200078e00ffULL, 0x00000005030d7c10ULL, 0x000fe2000a7fe4ffULL,
0x00016000020f7836ULL, 0x000fe40000000000ULL, 0x0000008005027825ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fc600078ee207ULL, 0x0000008006047825ULL, 0x000fe200078e00ffULL,
0x0000007002027812ULL, 0x000fc600078ef800ULL, 0x0000008011067825ULL, 0x000fe200078e00ffULL,
0x0000007004047812ULL, 0x000fe400078ef800ULL, 0x0000000402027c10ULL, 0x000fe2000ff9e0ffULL,
0x000000100e117824ULL, 0x100fe200078e020fULL, 0x0000007006007812ULL, 0x000fe200078ef800ULL,
0x0000001010137824ULL, 0x100fe200078e020fULL, 0x0000000404047c10ULL, 0x000fe2000ffbe0ffULL,
0x0000001012157824ULL, 0x100fe200078e020fULL, 0x0000000400067c10ULL, 0x000fe2000ffde0ffULL,
0x00000010140f7824ULL, 0x000fe200078e020fULL, 0x0000000503037c10ULL, 0x000fe2000a7fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e2000d901c46ULL,
0x0000000505057c10ULL, 0x000fc4000affe4ffULL, 0x0000000507077c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000002137faeULL, 0x0003e8000d101c46ULL, 0x0000000004157faeULL, 0x0003e8000c901c46ULL,
0x00000000060f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x0000001065027824ULL, 0x000fe200078e00ffULL, 0x0000900000047ab9ULL, 0x000fc80000000a00ULL,
0x0000000209027211ULL, 0x000fca00078fe8ffULL, 0x0000000402057836ULL, 0x000fe40000000000ULL,
0x0000000102037824ULL, 0x140fe400078e0209ULL, 0x00000008020e7824ULL, 0x000fe400078e00ffULL,
0x0000000105067824ULL, 0x040fe400078e0209ULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL, 0x0000000104037824ULL, 0x000fc400078e0202ULL,
0x0000000c020c7836ULL, 0x000fe20000000000ULL, 0xfffffff807107812ULL, 0x000fe200078ee206ULL,
0x0000000802067836ULL, 0x000fe40000000000ULL, 0x0000008003027825ULL, 0x000fc800078e00ffULL,
0x0000000104057824ULL, 0x040fe200078e0205ULL, 0x00000070020d7812ULL, 0x000fe200078ef800ULL,
0x0000000104077824ULL, 0x040fe400078e0206ULL, 0x00000001040f7824ULL, 0x000fe400078e020cULL,
0x000000010c027824ULL, 0x140fe400078e0209ULL, 0x000000080c137824ULL, 0x000fe200078e00ffULL,
0x000000040d0c7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000106047824ULL, 0x000fc400078e0209ULL,
0x0000000806117824ULL, 0x000fe200078e00ffULL, 0xfffffff813147812ULL, 0x000fe200078ee202ULL,
0x0000200061067824ULL, 0x000fe200078e0208ULL, 0x00000005030d7c10ULL, 0x000fe200087fe4ffULL,
0x0000008005027825ULL, 0x000fe200078e00ffULL, 0xfffffff811127812ULL, 0x000fc600078ee204ULL,
0x0001600006157836ULL, 0x000fe20000000000ULL, 0x0000007002027812ULL, 0x000fe200078ef800ULL,
0x0000008007047825ULL, 0x000fc600078e00ffULL, 0x0000000402027c10ULL, 0x000fe2000ff1e0ffULL,
0x000000800f067825ULL, 0x000fe200078e00ffULL, 0x0000007004047812ULL, 0x000fe400078ef800ULL,
0x0000000503037c10ULL, 0x000fe200087fe4ffULL, 0x000000100e0f7824ULL, 0x100fe200078e0215ULL,
0x0000007006007812ULL, 0x000fe200078ef800ULL, 0x0000001010117824ULL, 0x100fe200078e0215ULL,
0x0000000404047c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001012137824ULL, 0x100fe200078e0215ULL,
0x0000000400067c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001014157824ULL, 0x000fe200078e0215ULL,
0x0000000505057c10ULL, 0x000fe20008ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e2000b901c46ULL, 0x0000000507077c10ULL, 0x000fc600097fe4ffULL,
0x0000000002117faeULL, 0x0003e8000b901c46ULL, 0x0000000004137faeULL, 0x0003e8000b901c46ULL,
0x0000000006157faeULL, 0x0003e4000b901c46ULL, 0x0001a6a808007836ULL, 0x000fe20000000000ULL,
0x00000000610472caULL, 0x000fe200000e0000ULL, 0x00000001ff037424ULL, 0x002fe200078e00ffULL,
0x000000ff6000720cULL, 0x000fe20003f05270ULL, 0x000000ffff7d7224ULL, 0x000fe200078e00ffULL,
0x00000000000572caULL, 0x000fe400000e0000ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000504047291ULL, 0x000fe2000f8e203fULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000527805ULL, 0x000fc4000001ff00ULL,
0x0000000000507805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x000000ffff497224ULL, 0x000fe400078e00ffULL,
0x0000000861027824ULL, 0x000fe200078e0200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000003ff8079a7ULL, 0x0002a20008500004ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x0000000000467805ULL, 0x000fc4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00002003020279a7ULL, 0x002e62000850003fULL, 0x0000000000567805ULL, 0x000fc4000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000009c00908947ULL, 0x000fec0003800000ULL,
0x00000002ff597819ULL, 0x000fe20000011677ULL, 0x000000ffff397224ULL, 0x002fe200078e0003ULL,
0x0000000161007812ULL, 0x000fe200078ec0ffULL, 0xff317217ff7c7424ULL, 0x000fe200078e00ffULL,
0x0000000863077812ULL, 0x000fe200078ec0ffULL, 0x0000002059057824ULL, 0x000fe400078e0208ULL,
0x000000ffff587224ULL, 0x000fe400078e00ffULL, 0x0000001000007824ULL, 0x000fe400078e0205ULL,
0x000000ffff2f7224ULL, 0x000fc400078e00ffULL, 0x0000000107077824ULL, 0x000fce00078e0200ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000000477067824ULL, 0x000fca00078e00ffULL,
0xfffffff806377812ULL, 0x000fca00078ec0ffULL, 0x0000000108387824ULL, 0x000fc800078e0237ULL,
0x01a6c839380075a7ULL, 0x000e62000800017fULL, 0x0001a6c838067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01a6c839380075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000158357836ULL, 0x000fe20000000000ULL, 0x0000940000057ab9ULL, 0x000fe20000000800ULL,
0x0000010058727824ULL, 0x000fc600078e025bULL, 0x000000603500720cULL, 0x000fe20003f26070ULL,
0x0000004072357836ULL, 0x000fc80000000000ULL, 0x000000055a3a7c24ULL, 0x000fd0000f8e0235ULL,
0x0000000400089947ULL, 0x000fea0003800000ULL, 0x0000003562347248ULL, 0x000fe20007fe0000ULL,
0x0000001065377824ULL, 0x000fe200078e00ffULL, 0x00000003ff367819ULL, 0x000fe20000011609ULL,
0x0000900000087ab9ULL, 0x000fe40000000a00ULL, 0x0000000134347824ULL, 0x000fe400078e0a35ULL,
0x0000000137357824ULL, 0x000fe400078e0236ULL, 0x0000000436397836ULL, 0x000fe20000000000ULL,
0x0000003437347248ULL, 0x000fe20007fe0000ULL, 0x0000000135387824ULL, 0x000fc400078e0209ULL,
0x00000008354f7824ULL, 0x000fe400078e00ffULL, 0x0000000134347824ULL, 0x000fe400078e0a37ULL,
0x00000001373b7824ULL, 0x000fe200078e0239ULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee238ULL,
0x0000000836387836ULL, 0x000fe20000000000ULL, 0x000000343600720cULL, 0x080fe20003f86070ULL,
0x0000000c364c7836ULL, 0x000fe20000000000ULL, 0x000000343900720cULL, 0x080fe20003f66070ULL,
0x000000013b367824ULL, 0x040fe200078e0209ULL, 0x000000343800720cULL, 0x080fe20003f46070ULL,
0x000000083b5d7824ULL, 0x000fe200078e00ffULL, 0x000000344c00720cULL, 0x000fe20003f06070ULL,
0x0000000137397824ULL, 0x000fc400078e0238ULL, 0x00000001374d7824ULL, 0x000fe200078e024cULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee236ULL, 0x0000001009377824ULL, 0x000fe400078e00ffULL,
0x0000000135347824ULL, 0x100fe400078e023aULL, 0x000000013b367824ULL, 0x100fe400078e023aULL,
0x0000000139387824ULL, 0x040fe400078e023aULL, 0x00000001393b7824ULL, 0x000fc400078e0209ULL,
0x00000008394c7824ULL, 0x000fe400078e00ffULL, 0x000000014d3a7824ULL, 0x040fe400078e023aULL,
0x000000014d397824ULL, 0x040fe200078e0209ULL, 0xfffffff84c5f7812ULL, 0x000fe200078ee23bULL,
0x000000084d4e7824ULL, 0x000fe200078e00ffULL, 0x00000070374d7812ULL, 0x000fe200078ec0ffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff84e677812ULL, 0x000fe200078ee239ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004d34347212ULL, 0x000fc600078efcffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000004d36367212ULL, 0x080fe400078efcffULL,
0x0000000834347c10ULL, 0x000fe2000ffbe0ffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000000836367c10ULL, 0x000fe4000ffde0ffULL, 0x0000004d38387212ULL, 0x080fe200078efcffULL,
0x00002000614c7824ULL, 0x000fe200078e0208ULL, 0x0000004d3a3a7212ULL, 0x000fe400078efcffULL,
0x0000000935357c10ULL, 0x000fe2000affe4ffULL, 0x000170004c4c7836ULL, 0x000fe20000000000ULL,
0x0000000937377c10ULL, 0x000fc4000b7fe4ffULL, 0x0000000838387c10ULL, 0x000fe2000ffbe0ffULL,
0x000000104f4d7824ULL, 0x100fe200078e024cULL, 0x000000083a3a7c10ULL, 0x000fe2000ffde0ffULL,
0x000000105d4f7824ULL, 0x100fe200078e024cULL, 0x0000000939397c10ULL, 0x000fe2000affe4ffULL,
0x000000105f5d7824ULL, 0x100fe200078e024cULL, 0x000000093b3b7c10ULL, 0x000fe2000b7fe4ffULL,
0x00000010675f7824ULL, 0x000fe200078e024cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000344d7faeULL, 0x0003e8000e101c46ULL, 0x00000000364f7faeULL, 0x0003e8000d901c46ULL,
0x00000000385d7faeULL, 0x0003e8000d101c46ULL, 0x000000003a5f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000d47947ULL, 0x000fea0003800000ULL, 0x0000001065347824ULL, 0x000fe200078e00ffULL,
0x0000900000087ab9ULL, 0x000fe20000000a00ULL, 0x0000001009367824ULL, 0x000fc600078e00ffULL,
0x0000003409357211ULL, 0x000fe400078fe8ffULL, 0x00000070365d7812ULL, 0x000fc600078ec0ffULL,
0x0000000435377836ULL, 0x000fe40000000000ULL, 0x0000000135347824ULL, 0x140fe400078e0209ULL,
0x00000008354d7824ULL, 0x000fe400078e00ffULL, 0x0000000137387824ULL, 0x040fe400078e0209ULL,
0x00000008374f7824ULL, 0x000fe200078e00ffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee234ULL,
0x0000000835397836ULL, 0x000fc40000000000ULL, 0x0000000c354c7836ULL, 0x000fe20000000000ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee238ULL, 0x0000000135347824ULL, 0x100fe400078e023aULL,
0x0000000137367824ULL, 0x100fe400078e023aULL, 0x0000000139387824ULL, 0x040fe400078e023aULL,
0x00000001393b7824ULL, 0x040fe400078e0209ULL, 0x00000008394e7824ULL, 0x000fc400078e00ffULL,
0x000000014c3a7824ULL, 0x040fe400078e023aULL, 0x000000014c397824ULL, 0x040fe200078e0209ULL,
0xfffffff84e5f7812ULL, 0x000fe200078ee23bULL, 0x000000084c4c7824ULL, 0x000fe400078e00ffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff84c677812ULL, 0x000fe200078ee239ULL,
0x0000200061377824ULL, 0x000fe200078e0208ULL, 0x0000005d34347212ULL, 0x000fe200078efcffULL,
0x0000008038387825ULL, 0x000fc600078e00ffULL, 0x0000000834347c10ULL, 0x000fe2000ff1e0ffULL,
0x00017000374c7836ULL, 0x000fe20000000000ULL, 0x0000005d38387212ULL, 0x080fe200078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000000935357c10ULL, 0x000fe400087fe4ffULL,
0x0000000838387c10ULL, 0x000fe2000ff5e0ffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000005d36367212ULL, 0x080fe400078efcffULL, 0x0000000939397c10ULL, 0x000fe200097fe4ffULL,
0x000000104d4d7824ULL, 0x100fe200078e024cULL, 0x0000005d3a3a7212ULL, 0x000fe200078efcffULL,
0x000000104f4f7824ULL, 0x100fe200078e024cULL, 0x0000000836367c10ULL, 0x000fe2000ff1e0ffULL,
0x000000105f5d7824ULL, 0x100fe200078e024cULL, 0x000000083a3a7c10ULL, 0x000fe2000ff7e0ffULL,
0x00000010675f7824ULL, 0x000fe200078e024cULL, 0x0000000937377c10ULL, 0x000fe200087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000344d7faeULL, 0x0003e2000b901c46ULL,
0x000000093b3b7c10ULL, 0x000fc60009ffe4ffULL, 0x00000000364f7faeULL, 0x0003e8000b901c46ULL,
0x00000000385d7faeULL, 0x0003e8000b901c46ULL, 0x000000003a5f7faeULL, 0x0003e4000b901c46ULL,
0xfffffff063357812ULL, 0x042fe200078ec0ffULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x0000001063347812ULL, 0x000fc600078ec0ffULL, 0x00000001083a7824ULL, 0x000fe200078e0235ULL,
0xffffffe063357812ULL, 0x000fc800078ec0ffULL, 0x000000003a0572caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000834367210ULL, 0x000fca0007ffe035ULL,
0x0000000865387824ULL, 0x000fcc00078e0236ULL, 0x0001a6b005057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01a6b0393a8479a7ULL, 0x0002e4000850003fULL, 0x01a60839383879a7ULL, 0x002e64000850003fULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000000863737812ULL, 0x000fca00078ec0ffULL,
0x0000000136737824ULL, 0x000fc800078e0273ULL, 0x01a60839730075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a60839730075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000001009717824ULL, 0x000fe200078e00ffULL, 0x00000001ff747819ULL, 0x000fe20000011609ULL,
0x0000002077347824ULL, 0x000fe400078e00ffULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x0000007071717812ULL, 0x000fe200078ec0ffULL, 0x000000ffff7a7224ULL, 0x000fe200078e007cULL,
0xffffff8034347812ULL, 0x000fe400078ec0ffULL, 0x0000000c74747812ULL, 0x000fe400078ec0ffULL,
0x0000000871357210ULL, 0x000fca0007ffe034ULL, 0x0000000135357824ULL, 0x000fca00078e0274ULL,
0x01a0000035377984ULL, 0x000e680000000800ULL, 0x01a2000035347984ULL, 0x0009220000000800ULL,
0x0000007c3700720bULL, 0x002fda0003f1d000ULL, 0x0000000000367806ULL, 0x000fc800000e0100ULL,
0x000000ff3600720cULL, 0x000fda0003f05270ULL, 0x00000004008c8947ULL, 0x01cfea0003800000ULL,
0x000000775900720cULL, 0x000fe40003f45270ULL, 0x0000007c3700720bULL, 0x0c0fe40003f14000ULL,
0x0000007c377a7209ULL, 0x000fd20007810000ULL, 0x000000807735a824ULL, 0x000fe400078e0208ULL,
0x0000000000397806ULL, 0x000fc600000e0100ULL, 0x000000357435a210ULL, 0x000fe40007ffe071ULL,
0x000000ff3900720cULL, 0x000fc60003f05270ULL, 0x01a4007a3500a388ULL, 0x0003f40000000800ULL,
0x0000000400508947ULL, 0x002fea0003800000ULL, 0x0000007c7a357221ULL, 0x000fe20000010100ULL,
0x000000ff39ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0039ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b35357820ULL, 0x000fe20000410000ULL, 0x00ff000039ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000039ff7812ULL, 0x000fe2000788c0ffULL, 0x00000035004c7308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff357819ULL, 0x002fcc0000011609ULL,
0x00001f354c357589ULL, 0x004e6400000e0000ULL, 0x0000003554547220ULL, 0x082fe20000410000ULL,
0x0000003555557220ULL, 0x080fe20000410000ULL, 0x000000353c3c7220ULL, 0x080fe20000410000ULL,
0x000000353d3d7220ULL, 0x080fe20000410000ULL, 0x0000003540407220ULL, 0x080fe20000410000ULL,
0x0000003541417220ULL, 0x080fe20000410000ULL, 0x0000003544447220ULL, 0x080fe20000410000ULL,
0x0000003545457220ULL, 0x080fe20000410000ULL, 0x0000003548487220ULL, 0x080fe20000410000ULL,
0x0000003549497220ULL, 0x080fe20000410000ULL, 0x0000003550507220ULL, 0x080fe20000410000ULL,
0x0000003551517220ULL, 0x080fe20000410000ULL, 0x0000003528287220ULL, 0x080fe20000410000ULL,
0x0000003529297220ULL, 0x080fe20000410000ULL, 0x0000003524247220ULL, 0x080fe20000410000ULL,
0x0000003525257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000000809357811ULL, 0x002fcc00078ff0ffULL, 0x00001f354c357589ULL, 0x004e6400000e0000ULL,
0x0000003556567220ULL, 0x082fe20000410000ULL, 0x0000003557577220ULL, 0x080fe20000410000ULL,
0x000000353e3e7220ULL, 0x080fe20000410000ULL, 0x000000353f3f7220ULL, 0x080fe20000410000ULL,
0x0000003542427220ULL, 0x080fe20000410000ULL, 0x0000003543437220ULL, 0x080fe20000410000ULL,
0x0000003546467220ULL, 0x080fe20000410000ULL, 0x0000003547477220ULL, 0x080fe20000410000ULL,
0x000000354a4a7220ULL, 0x080fe20000410000ULL, 0x000000354b4b7220ULL, 0x080fe20000410000ULL,
0x0000003552527220ULL, 0x080fe20000410000ULL, 0x0000003553537220ULL, 0x080fe20000410000ULL,
0x000000352a2a7220ULL, 0x080fe20000410000ULL, 0x000000352b2b7220ULL, 0x080fe20000410000ULL,
0x0000003526267220ULL, 0x080fe20000410000ULL, 0x0000003527277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x0000001009357811ULL, 0x002fcc00078ff0ffULL,
0x00001f354c357589ULL, 0x004e6400000e0000ULL, 0x000000350c0c7220ULL, 0x082fe20000410000ULL,
0x000000350d0d7220ULL, 0x080fe20000410000ULL, 0x0000003510107220ULL, 0x080fe20000410000ULL,
0x0000003511117220ULL, 0x080fe20000410000ULL, 0x0000003514147220ULL, 0x080fe20000410000ULL,
0x0000003515157220ULL, 0x080fe20000410000ULL, 0x0000003518187220ULL, 0x080fe20000410000ULL,
0x0000003519197220ULL, 0x080fe20000410000ULL, 0x000000351c1c7220ULL, 0x080fe20000410000ULL,
0x000000351d1d7220ULL, 0x080fe20000410000ULL, 0x0000003520207220ULL, 0x080fe20000410000ULL,
0x0000003521217220ULL, 0x080fe20000410000ULL, 0x0000003530307220ULL, 0x080fe20000410000ULL,
0x0000003531317220ULL, 0x080fe20000410000ULL, 0x000000352c2c7220ULL, 0x080fe20000410000ULL,
0x000000352d2d7220ULL, 0x000fce0000410000ULL, 0x0000004c7d7d7220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x0000001809357811ULL, 0x002fcc00078ff0ffULL,
0x00001f354c357589ULL, 0x000e6400000e0000ULL, 0x000000350e0e7220ULL, 0x082fe20000410000ULL,
0x000000350f0f7220ULL, 0x080fe20000410000ULL, 0x0000003512127220ULL, 0x080fe20000410000ULL,
0x0000003513137220ULL, 0x080fe20000410000ULL, 0x0000003516167220ULL, 0x080fe20000410000ULL,
0x0000003517177220ULL, 0x080fe20000410000ULL, 0x000000351a1a7220ULL, 0x080fe20000410000ULL,
0x000000351b1b7220ULL, 0x080fe20000410000ULL, 0x000000351e1e7220ULL, 0x080fe20000410000ULL,
0x000000351f1f7220ULL, 0x080fe20000410000ULL, 0x0000003522227220ULL, 0x080fe20000410000ULL,
0x0000003523237220ULL, 0x080fe20000410000ULL, 0x0000003532327220ULL, 0x080fe20000410000ULL,
0x0000003533337220ULL, 0x080fe20000410000ULL, 0x000000352e2e7220ULL, 0x080fe20000410000ULL,
0x000000352f2f7220ULL, 0x000fce0000410000ULL, 0x0000003936ff7212ULL, 0x000fda00078030ffULL,
0x8000007a37370221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b37370820ULL, 0x000fc80000410000ULL, 0x0000003700040308ULL, 0x000ea40000000800ULL,
0x0000000434340220ULL, 0x004fce0000410000ULL, 0x0000007d347d7221ULL, 0x000fe20000010000ULL,
0x0000000000347805ULL, 0x002fe20000015200ULL, 0x01a6a8813a0075a7ULL, 0x000ea2000800017fULL,
0x0001a6a83a397836ULL, 0x000fca0000000000ULL, 0x00000000390572caULL, 0x000fe200000e0000ULL,
0x0000000000600947ULL, 0x006fdc0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a6a8813a0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000000390572caULL, 0x000fde00000e0000ULL, 0x00000004617e7824ULL, 0x000fe200078e00ffULL,
0x00000008096e7812ULL, 0x000fe200078ec0ffULL, 0x0000200061707824ULL, 0x000fe200078e0208ULL,
0x0000991038347816ULL, 0x000fe400000000ffULL, 0x000000047e7e7812ULL, 0x000fe200078ec0ffULL,
0x00016000706f7836ULL, 0x000fe20000000000ULL, 0x000000076e6e7812ULL, 0x000fe400078ef809ULL,
0x00000004ff7c7819ULL, 0x000fe40000011609ULL, 0x0000007e09357211ULL, 0x000fe200078fe0ffULL,
0x000000086e377824ULL, 0x000fe200078e00ffULL, 0x000000ff3400720cULL, 0x000fe20003f05270ULL,
0x0000040077347824ULL, 0x000fe200078e00ffULL, 0x000000106e767812ULL, 0x000fe200078efcffULL,
0x00000004657f7824ULL, 0x000fc400078e027cULL, 0x000000016e787824ULL, 0x000fe200078e0235ULL,
0xfffff000347b7812ULL, 0x000fe200078ec0ffULL, 0x000000016e4c7824ULL, 0x000fe400078e027fULL,
0x0000000135757824ULL, 0x000fe200078e0276ULL, 0xfffffff837787812ULL, 0x000fe200078ee278ULL,
0x0000000876367824ULL, 0x000fe200078e00ffULL, 0xfffffff837347812ULL, 0x000fe400078ee24cULL,
0x00012000087b7810ULL, 0x000fe40007ffe07bULL, 0xfffffff836757812ULL, 0x000fe200078ee275ULL,
0x00000010345c7824ULL, 0x000fc400078e026fULL, 0x0000001078367824ULL, 0x100fe400078e027bULL,
0x0000001075387824ULL, 0x000fe200078e027bULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000001003057836ULL, 0x000fe20000000000ULL, 0x0000541000347816ULL, 0x000fe20000000000ULL,
0x0000000803357836ULL, 0x000fe40000000000ULL, 0x0000001803377836ULL, 0x000fe40000000000ULL,
0x00001f0534057589ULL, 0x0002a800000e0000ULL, 0x00001f3534027589ULL, 0x0002e800000e0000ULL,
0x00001f0334037589ULL, 0x00026800000e0000ULL, 0x00001f3734007589ULL, 0x00026400000e0000ULL,
0x000000003634783bULL, 0x002e680000000200ULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000200000ULL,
0x0000000336367232ULL, 0x000fe40000200000ULL, 0x0000000235357232ULL, 0x088fe40000200000ULL,
0x0000000237377232ULL, 0x000fe40000200000ULL, 0x0000000538387232ULL, 0x084fe40000200000ULL,
0x000000053a3a7232ULL, 0x000fc40000200000ULL, 0x0000000039397232ULL, 0x080fe40000200000ULL,
0x000000003b3b7232ULL, 0x000fce0000200000ULL, 0x000000005c5c783bULL, 0x000f220000004200ULL,
0x000000086e4d7824ULL, 0x000fe400078e00ffULL, 0x000000024c4c7836ULL, 0x000fe40000000000ULL,
0x00000001767f7824ULL, 0x000fc600078e027fULL, 0xfffffff84d4c7812ULL, 0x000fca00078ee24cULL,
0x000000104c4c7824ULL, 0x000fcc00078e026fULL, 0x000000004c4c783bULL, 0x000f620000004200ULL,
0x000001005c667824ULL, 0x050fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe2000001145cULL,
0x000001005d677824ULL, 0x040fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe4000001145dULL,
0x000088805c837816ULL, 0x040fe200000000ffULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x000088805d8f7816ULL, 0x040fe200000000ffULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x0000008c008c7306ULL, 0x000fe20000202400ULL,
0x00000018ff907819ULL, 0x000fc4000001145cULL, 0x00000018ff917819ULL, 0x000fe2000001145dULL,
0x000001005e5d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe4000001145eULL,
0x000088805e5c7816ULL, 0x040fe200000000ffULL, 0x0000006600927306ULL, 0x0009e20000202400ULL,
0x000100005e5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x000001004e6b7824ULL, 0x028fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe4000001144cULL,
0x00000018ff5e7819ULL, 0x000fc4000001145eULL, 0x0000006700947306ULL, 0x0007e20000202400ULL,
0x000001005f667824ULL, 0x050fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe4000001145fULL,
0x000088805f8e7816ULL, 0x040fe200000000ffULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe40000011466ULL, 0x000088804c667816ULL, 0x040fe200000000ffULL,
0x000001004c677824ULL, 0x048fe200078e00ffULL, 0x0000005e008b7306ULL, 0x0007e20000202400ULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fc4000001144dULL,
0x00000018ff897819ULL, 0x000fe40000011467ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000008300837306ULL, 0x000fe20000202400ULL, 0x000001004d5e7824ULL, 0x048fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001144eULL, 0x000088804d677816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fc4000001145eULL,
0x0000009100917306ULL, 0x000ee20000202400ULL, 0x000088804e6a7816ULL, 0x040fe200000000ffULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x00000018ff817819ULL, 0x000fe4000001146bULL, 0x00000018ff6d7819ULL, 0x000fe2000001144fULL,
0x0000004c00877306ULL, 0x0009e20000202400ULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x000088804f6b7816ULL, 0x000fc400000000ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000005e00867306ULL, 0x000be20000202400ULL,
0x000001004f4c7824ULL, 0x010fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000005c005c7306ULL, 0x000fe20000202400ULL, 0x000100004f5e7824ULL, 0x024fe200078e00ffULL,
0x00005410914f7816ULL, 0x008fc8000000008cULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x0000004c00807306ULL, 0x0005f00000202400ULL, 0x0000005d005d7306ULL, 0x000ee20000202400ULL,
0x00005410834c7816ULL, 0x004fce0000000092ULL, 0x0000008d008d7306ULL, 0x000fe20000202400ULL,
0x000054105c5c7816ULL, 0x008fce000000005dULL, 0x0000008a008a7306ULL, 0x000ff00000202400ULL,
0x0000008800887306ULL, 0x000ff00000202400ULL, 0x0000006800687306ULL, 0x000eb00000202400ULL,
0x0000006900697306ULL, 0x000fe20000202400ULL, 0x0000541087687816ULL, 0x004fce0000000068ULL,
0x0000006c006c7306ULL, 0x000ff00000202400ULL, 0x0000006d006d7306ULL, 0x000ff00000202400ULL,
0x0000008f008f7306ULL, 0x000ff00000202400ULL, 0x0000009000907306ULL, 0x000ff00000202400ULL,
0x0000008e008e7306ULL, 0x000ff00000202400ULL, 0x0000009300937306ULL, 0x000eb00000202400ULL,
0x0000005f005f7306ULL, 0x000ee20000202400ULL, 0x000054108e5d7816ULL, 0x004fce0000000093ULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x0000005c3440723cULL, 0x002fe20000041840ULL,
0x000054105f5f7816ULL, 0x008fcc0000000088ULL, 0x0000008900897306ULL, 0x000e620000202400ULL,
0x0000005c3814723cULL, 0x000fee0000041814ULL, 0x0000006700677306ULL, 0x000ea20000202400ULL,
0x0000541066667816ULL, 0x002fce0000000089ULL, 0x0000004d00827306ULL, 0x0002e20000202400ULL,
0x0000541067677816ULL, 0x004fce0000000086ULL, 0x0000006a006a7306ULL, 0x000fe20000202400ULL,
0x000054108f4d7816ULL, 0x002fe20000000094ULL, 0x000000663448723cULL, 0x000fe20000041848ULL,
0x0000541082697816ULL, 0x008fca0000000069ULL, 0x0000008100817306ULL, 0x000e620000202400ULL,
0x0000004c3454723cULL, 0x000fee0000041854ULL, 0x0000006b006b7306ULL, 0x000ea20000202400ULL,
0x000000683450723cULL, 0x000fe20000041850ULL, 0x000054106a6a7816ULL, 0x002fcc0000000081ULL,
0x0000004e00837306ULL, 0x0002e20000202400ULL, 0x0000004c380c723cULL, 0x000fe2000004180cULL,
0x000054106b6b7816ULL, 0x004fcc0000000080ULL, 0x0000005e008c7306ULL, 0x0005220000202400ULL,
0x00005410904e7816ULL, 0x002fe2000000008dULL, 0x00000008764c7824ULL, 0x000fe200078e00ffULL,
0x00000066381c723cULL, 0x000fe2000004181cULL, 0x00005410836c7816ULL, 0x008fe4000000006cULL,
0x000054108b5e7816ULL, 0x004fc6000000008aULL, 0x0000004e343c723cULL, 0x000fe2000004183cULL,
0xfffffff84c4c7812ULL, 0x000fe400078ee27fULL, 0x000054108c6d7816ULL, 0x010fc6000000006dULL,
0x0000005e3444723cULL, 0x000fe20000041844ULL, 0x000000104c5c7824ULL, 0x000fca00078e026fULL,
0x0000006a3428723cULL, 0x000fec0000041828ULL, 0x0000006c3424723cULL, 0x000fec0000041824ULL,
0x0000004e3810723cULL, 0x000fe20000041810ULL, 0x000000027e357812ULL, 0x000fe200078efcffULL,
0x000000086e377824ULL, 0x000fc400078e00ffULL, 0x0000000876367824ULL, 0x000fe400078e00ffULL,
0x000000017c357824ULL, 0x000fe200078e0235ULL, 0x0000005e3818723cULL, 0x000fe60000041818ULL,
0x000000016e347824ULL, 0x100fe400078e0235ULL, 0x0000000176357824ULL, 0x000fe200078e0235ULL,
0x000000683820723cULL, 0x000fe40000041820ULL, 0xfffffff837347812ULL, 0x000fc400078ee234ULL,
0xfffffff836367812ULL, 0x000fe400078ee235ULL, 0x0000006a3830723cULL, 0x000fe20000041830ULL,
0x0000001034347824ULL, 0x100fe400078e027bULL, 0x00000010367b7824ULL, 0x000fc600078e027bULL,
0x0000006c3838723cULL, 0x000fe2000004182cULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x000000007b2c783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x082fe40000200000ULL,
0x0000000336367232ULL, 0x000fe40000200000ULL, 0x0000000235357232ULL, 0x080fe40000200000ULL,
0x0000000237377232ULL, 0x000fe40000200000ULL, 0x000000052c2c7232ULL, 0x088fe40000200000ULL,
0x000000052e2e7232ULL, 0x000fc40000200000ULL, 0x000000002d2d7232ULL, 0x080fe40000200000ULL,
0x000000002f2f7232ULL, 0x000fce0000200000ULL, 0x000000005c5c783bULL, 0x000f220000004200ULL,
0x00000008764c7824ULL, 0x000fe400078e00ffULL, 0x000000027f7f7836ULL, 0x000fca0000000000ULL,
0xfffffff84c4c7812ULL, 0x000fca00078ee27fULL, 0x000000104c4c7824ULL, 0x000fcc00078e026fULL,
0x000000004c4c783bULL, 0x000f620000004200ULL, 0x000001005c667824ULL, 0x050fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe2000001145cULL, 0x000001005d677824ULL, 0x040fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe4000001145dULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000008700877306ULL, 0x000fe20000202400ULL,
0x000088805c7e7816ULL, 0x040fe200000000ffULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x000088805d8c7816ULL, 0x040fe200000000ffULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fc4000001145eULL, 0x00000018ff8a7819ULL, 0x000fe2000001145cULL,
0x00000066008b7306ULL, 0x0009e20000202400ULL, 0x00000018ff8d7819ULL, 0x000fe2000001145dULL,
0x000001005e5d7824ULL, 0x040fe200078e00ffULL, 0x000088805e5c7816ULL, 0x000fe200000000ffULL,
0x000001004c6b7824ULL, 0x024fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe2000001144dULL,
0x000001004d7b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe2000001144cULL,
0x0000006700917306ULL, 0x0005e20000202400ULL, 0x000001005f667824ULL, 0x010fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fc4000001146bULL, 0x00000018ff6c7819ULL, 0x000fe4000001144eULL,
0x00000018ff6a7819ULL, 0x000fe20000011466ULL, 0x000100005e667824ULL, 0x000fe200078e00ffULL,
0x0000007e007e7306ULL, 0x000f220000202400ULL, 0x000088804e8e7816ULL, 0x000fe400000000ffULL,
0x00000018ff897819ULL, 0x000fe4000001145dULL, 0x00000018ff677819ULL, 0x004fe20000011466ULL,
0x000100005f667824ULL, 0x040fe200078e00ffULL, 0x000088805f5d7816ULL, 0x000fe200000000ffULL,
0x0000006a005e7306ULL, 0x0005e20000202400ULL, 0x00000018ff827819ULL, 0x000fc4000001145fULL,
0x00000018ff8f7819ULL, 0x000fe40000011466ULL, 0x000088804c667816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001144fULL,
0x0000008800887306ULL, 0x000fe20000202400ULL, 0x000088804d6a7816ULL, 0x044fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff7b7819ULL, 0x000fc4000001147bULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000008d008d7306ULL, 0x000eb00000202400ULL, 0x0000006b00837306ULL, 0x000bf00000202400ULL,
0x0000004d007c7306ULL, 0x0005e20000202400ULL, 0x000001004e6b7824ULL, 0x028fc400078e00ffULL,
0x000100004e4e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001146bULL,
0x0000004c00817306ULL, 0x0009e20000202400ULL, 0x000001004f4d7824ULL, 0x046fe200078e00ffULL,
0x000088804f6b7816ULL, 0x000fe400000000ffULL, 0x00000018ff4e7819ULL, 0x000fc8000001144eULL,
0x0000005d005d7306ULL, 0x000e620000202400ULL, 0x000054107e4c7816ULL, 0x010fe2000000008bULL,
0x000100004f8b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001144dULL,
0x000054108d4f7816ULL, 0x000fe40000000088ULL, 0x00000018ff8b7819ULL, 0x000fe2000001148bULL,
0x00000067005f7306ULL, 0x000fe20000202400ULL, 0x000054105d5d7816ULL, 0x002fce000000005eULL,
0x0000008600867306ULL, 0x000e700000202400ULL, 0x0000006a00677306ULL, 0x000fe20000202400ULL,
0x000054105f5e7816ULL, 0x002fce0000000086ULL, 0x0000007b00807306ULL, 0x000e700000202400ULL,
0x0000008200827306ULL, 0x000fe20000202400ULL, 0x0000541067677816ULL, 0x002fce0000000080ULL,
0x0000006800687306ULL, 0x000e700000202400ULL, 0x0000006900697306ULL, 0x000ea20000202400ULL,
0x0000541081687816ULL, 0x002fce0000000068ULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x000054107c697816ULL, 0x004fce0000000069ULL, 0x0000006d006d7306ULL, 0x000fe20000202400ULL,
0x000000683450723cULL, 0x000fee0000041850ULL, 0x0000008c008c7306ULL, 0x000e620000202400ULL,
0x000000682c20723cULL, 0x000fee0000041820ULL, 0x0000008a008a7306ULL, 0x000fe20000202400ULL,
0x000054108c4d7816ULL, 0x002fce0000000091ULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x0000004c3454723cULL, 0x000fee0000041854ULL, 0x0000008900897306ULL, 0x000e620000202400ULL,
0x0000004c2c0c723cULL, 0x000fee000004180cULL, 0x0000008f008f7306ULL, 0x000ea20000202400ULL,
0x000054105c5c7816ULL, 0x002fce0000000089ULL, 0x0000006600667306ULL, 0x000e620000202400ULL,
0x0000005c3440723cULL, 0x000fe20000041840ULL, 0x000054108f5f7816ULL, 0x004fcc0000000082ULL,
0x0000008e006a7306ULL, 0x000fe20000202400ULL, 0x0000005c2c14723cULL, 0x000fe20000041814ULL,
0x0000541066667816ULL, 0x002fcc0000000083ULL, 0x0000007f007f7306ULL, 0x000e620000202400ULL,
0x0000005e3444723cULL, 0x000fee0000041844ULL, 0x0000004e007b7306ULL, 0x0004e20000202400ULL,
0x000000663448723cULL, 0x000fe20000041848ULL, 0x000054106a6a7816ULL, 0x002fcc000000007fULL,
0x0000006b006b7306ULL, 0x000fe20000202400ULL, 0x000054108a4e7816ULL, 0x004fe20000000087ULL,
0x0000005e2c18723cULL, 0x000fe20000041818ULL, 0x000054107b6c7816ULL, 0x008fca000000006cULL,
0x0000007e007e7306ULL, 0x000e620000202400ULL, 0x0000004e343c723cULL, 0x000fec000004183cULL,
0x0000004e2c10723cULL, 0x000fe20000041810ULL, 0x0000008b00887306ULL, 0x000eaa0000202400ULL,
0x000000662c1c723cULL, 0x000fe2000004181cULL, 0x000054106b6b7816ULL, 0x002fce000000007eULL,
0x0000006a3428723cULL, 0x000fe20000041828ULL, 0x00005410886d7816ULL, 0x004fca000000006dULL,
0x0000006a2c30723cULL, 0x000fec0000041830ULL, 0x0000006c3424723cULL, 0x000fec0000041824ULL,
0x0000006c2c38723cULL, 0x000fe20000041838ULL, 0x0000000277347824ULL, 0x000fc400078e00ffULL,
0x00000001ff377424ULL, 0x000fc600078e00ffULL, 0xfffffff834357812ULL, 0x000fe200078ec0ffULL,
0x0000000861347824ULL, 0x000fc800078e0208ULL, 0x0000000108367824ULL, 0x000fe400078e0235ULL,
0x01a6c837343479a7ULL, 0x0002a4000850003fULL, 0x01a6883736ff79a7ULL, 0x0003f2000850003fULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x00000035060075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff367224ULL, 0x002fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000080722d7836ULL, 0x000fe20000000000ULL, 0x0000940000087ab9ULL, 0x000fc60000000800ULL,
0x000000085a357c24ULL, 0x000fe2000f8e022dULL, 0x0000000000f89947ULL, 0x000fec0003800000ULL,
0x0000002d622c7248ULL, 0x000fe20007fe0000ULL, 0x00000010652f7824ULL, 0x000fe200078e00ffULL,
0x00000003ff2e7819ULL, 0x000fe20000011609ULL, 0x0000900000087ab9ULL, 0x000fe40000000a00ULL,
0x000000012c2c7824ULL, 0x000fe400078e0a2dULL, 0x000000042e367836ULL, 0x002fe40000000000ULL,
0x000000012f347824ULL, 0x000fe200078e022eULL, 0x0000002c2f2c7248ULL, 0x000fe20007fe0000ULL,
0x000000082e377836ULL, 0x000fc40000000000ULL, 0x00000001342d7824ULL, 0x000fe400078e0209ULL,
0x000000012c2c7824ULL, 0x000fe400078e0a2fULL, 0x00000008344c7824ULL, 0x000fe400078e00ffULL,
0x0000000c2e4d7836ULL, 0x000fe20000000000ULL, 0x0000002c3600720cULL, 0x080fe20003f66070ULL,
0x000000012f367824ULL, 0x040fe200078e0236ULL, 0x0000002c2e00720cULL, 0x080fe20003f86070ULL,
0x000000012f5c7824ULL, 0x000fe200078e0237ULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee22dULL,
0x00000001362e7824ULL, 0x040fe200078e0209ULL, 0x0000002c3700720cULL, 0x080fe20003f46070ULL,
0x00000008364f7824ULL, 0x000fe200078e00ffULL, 0x0000002c4d00720cULL, 0x000fe20003f06070ULL,
0x00000001342d7824ULL, 0x000fc400078e0235ULL, 0x000000012f5e7824ULL, 0x000fe200078e024dULL,
0xfffffff84f4e7812ULL, 0x000fe200078ee22eULL, 0x000000802d2c7825ULL, 0x000fc800078e00ffULL,
0x00000001362e7824ULL, 0x100fe200078e0235ULL, 0x000000712c2c7212ULL, 0x080fe200078efcffULL,
0x000000015c347824ULL, 0x040fe400078e0235ULL, 0x000000015c377824ULL, 0x040fe200078e0209ULL,
0x000000082c2c7c10ULL, 0x000fe2000ffbe0ffULL, 0x000000085c5c7824ULL, 0x000fe400078e00ffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x000000092d2d7c10ULL, 0x000fe4000affe4ffULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee237ULL, 0x000000015e367824ULL, 0x000fe200078e0235ULL,
0x000000712e2e7212ULL, 0x000fe200078efcffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0x000000082e2e7c10ULL, 0x000fe2000ffbe0ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000007134347212ULL, 0x080fe400078efcffULL, 0x000000092f2f7c10ULL, 0x000fe2000affe4ffULL,
0x000000015e4d7824ULL, 0x000fe200078e0209ULL, 0x0000007136367212ULL, 0x000fe200078efcffULL,
0x000000085e5e7824ULL, 0x000fe200078e00ffULL, 0x0000000834347c10ULL, 0x000fe2000ffbe0ffULL,
0x000000104e4f7824ULL, 0x100fe200078e026fULL, 0x0000000836367c10ULL, 0x000fe2000ffde0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e026fULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee24dULL,
0x000000104c4d7824ULL, 0x000fe200078e026fULL, 0x0000000935357c10ULL, 0x000fc4000affe4ffULL,
0x0000000937377c10ULL, 0x000fe2000b7fe4ffULL, 0x000000105e5f7824ULL, 0x000fe200078e026fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c4d7faeULL, 0x0003e8000e101c46ULL,
0x000000002e4f7faeULL, 0x0003e8000d901c46ULL, 0x00000000345d7faeULL, 0x0003e8000d101c46ULL,
0x00000000365f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x00000010652c7824ULL, 0x000fe200078e00ffULL, 0x0000900000087ab9ULL, 0x000fc80000000a00ULL,
0x0000002c092e7211ULL, 0x000fca00078fe8ffULL, 0x000000042e347836ULL, 0x000fe40000000000ULL,
0x000000012e2d7824ULL, 0x040fe400078e0209ULL, 0x000000082e4c7824ULL, 0x040fe400078e00ffULL,
0x0000000c2e5c7836ULL, 0x000fe40000000000ULL, 0x000000082e4e7836ULL, 0x000fe20000000000ULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee22dULL, 0x000000012e2c7824ULL, 0x000fc400078e0235ULL,
0x00000001342f7824ULL, 0x040fe400078e0209ULL, 0x00000008345e7824ULL, 0x040fe400078e00ffULL,
0x0000000134367824ULL, 0x002fe400078e0235ULL, 0x000000015c377824ULL, 0x040fe400078e0209ULL,
0x000000085c687824ULL, 0x000fe400078e00ffULL, 0x000000014e2e7824ULL, 0x000fc400078e0235ULL,
0x000000015c347824ULL, 0x000fe400078e0235ULL, 0x000000014e357824ULL, 0x040fe400078e0209ULL,
0x000000084e667824ULL, 0x000fe200078e00ffULL, 0xfffffff85e4e7812ULL, 0x000fe200078ee22fULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0xfffffff8685e7812ULL, 0x000fe400078ee237ULL,
0xfffffff8665c7812ULL, 0x000fe200078ee235ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000000712c2c7212ULL, 0x000fc600078efcffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000007136367212ULL, 0x080fe400078efcffULL, 0x000000082c2c7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x000000712e2e7212ULL, 0x080fe400078efcffULL,
0x0000000836367c10ULL, 0x000fe2000ff5e0ffULL, 0x000000104c4d7824ULL, 0x100fe200078e026fULL,
0x0000007134347212ULL, 0x000fe200078efcffULL, 0x000000104e4f7824ULL, 0x100fe200078e026fULL,
0x000000092d2d7c10ULL, 0x000fe200087fe4ffULL, 0x000000105c5d7824ULL, 0x100fe200078e026fULL,
0x000000082e2e7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000105e5f7824ULL, 0x000fe200078e026fULL,
0x0000000834347c10ULL, 0x000fe2000ff7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c4d7faeULL, 0x0003e2000b901c46ULL, 0x0000000937377c10ULL, 0x000fc400097fe4ffULL,
0x000000092f2f7c10ULL, 0x000fe400087fe4ffULL, 0x0000000935357c10ULL, 0x000fe20009ffe4ffULL,
0x00000000364f7faeULL, 0x0003e8000b901c46ULL, 0x000000002e5d7faeULL, 0x0003e8000b901c46ULL,
0x00000000345f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff2e7424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000002eff8279a7ULL, 0x0002a40008500005ULL,
0x01a6282e732e79a7ULL, 0x0022e4000850003fULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0xffffffe063357812ULL, 0x040fe400078ec0ffULL, 0x0000001063347812ULL, 0x000fc800078ec0ffULL,
0x0000000834347210ULL, 0x000fca0007ffe035ULL, 0x00000008654d7824ULL, 0x000fc800078e0234ULL,
0x01a6282f4d0075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x000000342c377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6282f4d0075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x00000020772c7824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff7f7224ULL, 0x000fe200078e007aULL,
0xffffff802c2d7812ULL, 0x000fc800078ec0ffULL, 0x00000080082c7810ULL, 0x000fc80007ffe02dULL,
0x0000002c742c7210ULL, 0x000fca0007ffe071ULL, 0x01a000002c2d7984ULL, 0x000ee80000000800ULL,
0x01a200002c2e7984ULL, 0x0009220000000800ULL, 0x0000007a2d00720bULL, 0x008fda0003f1d000ULL,
0x00000000002f7806ULL, 0x000fc800000e0100ULL, 0x000000ff2f00720cULL, 0x000fda0003f05270ULL,
0x0000000400948947ULL, 0x016fea0003800000ULL, 0x00000001592c7836ULL, 0x000fe20000000000ULL,
0x0000007a2d00720bULL, 0x0c0fe40003f14000ULL, 0x0000007a2d7f7209ULL, 0x000fe40007810000ULL,
0x000000772c00720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x00000080772ca824ULL, 0x000fe200078e0208ULL, 0x000000ff3400720cULL, 0x000fc80003f05270ULL,
0x0000002c742ca210ULL, 0x000fca0007ffe071ULL, 0x01a4007f2c00a388ULL, 0x0003e80000000800ULL,
0x0000000400508947ULL, 0x000fea0003800000ULL, 0x0000007a7f2c7221ULL, 0x002fe20000010100ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b2c2c7820ULL, 0x000fe20000410000ULL, 0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000034ff7812ULL, 0x000fe2000788c0ffULL, 0x0000002c00367308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff357819ULL, 0x000fca0000011609ULL,
0x00001f35362c7589ULL, 0x006e6400000e0000ULL, 0x000000542c547220ULL, 0x042fe20000410000ULL,
0x000000552c557220ULL, 0x040fe20000410000ULL, 0x0000003c2c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d2c3d7220ULL, 0x040fe20000410000ULL, 0x000000402c407220ULL, 0x040fe20000410000ULL,
0x000000412c417220ULL, 0x040fe20000410000ULL, 0x000000442c447220ULL, 0x040fe20000410000ULL,
0x000000452c457220ULL, 0x040fe20000410000ULL, 0x000000482c487220ULL, 0x040fe20000410000ULL,
0x000000492c497220ULL, 0x040fe20000410000ULL, 0x000000502c507220ULL, 0x040fe20000410000ULL,
0x000000512c517220ULL, 0x040fe20000410000ULL, 0x000000282c287220ULL, 0x040fe20000410000ULL,
0x000000292c297220ULL, 0x040fe20000410000ULL, 0x000000242c247220ULL, 0x040fe20000410000ULL,
0x000000252c257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000000809357811ULL, 0x000fca00078ff0ffULL, 0x00001f35362c7589ULL, 0x006e6400000e0000ULL,
0x000000562c567220ULL, 0x042fe20000410000ULL, 0x000000572c577220ULL, 0x040fe20000410000ULL,
0x0000003e2c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f2c3f7220ULL, 0x040fe20000410000ULL,
0x000000422c427220ULL, 0x040fe20000410000ULL, 0x000000432c437220ULL, 0x040fe20000410000ULL,
0x000000462c467220ULL, 0x040fe20000410000ULL, 0x000000472c477220ULL, 0x040fe20000410000ULL,
0x0000004a2c4a7220ULL, 0x040fe20000410000ULL, 0x0000004b2c4b7220ULL, 0x040fe20000410000ULL,
0x000000522c527220ULL, 0x040fe20000410000ULL, 0x000000532c537220ULL, 0x040fe20000410000ULL,
0x0000002a2c2a7220ULL, 0x040fe20000410000ULL, 0x0000002b2c2b7220ULL, 0x040fe20000410000ULL,
0x000000262c267220ULL, 0x040fe20000410000ULL, 0x000000272c277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x0000001009357811ULL, 0x000fca00078ff0ffULL,
0x00001f35362c7589ULL, 0x006e6400000e0000ULL, 0x0000000c2c0c7220ULL, 0x042fe20000410000ULL,
0x0000000d2c0d7220ULL, 0x040fe20000410000ULL, 0x000000102c107220ULL, 0x040fe20000410000ULL,
0x000000112c117220ULL, 0x040fe20000410000ULL, 0x000000142c147220ULL, 0x040fe20000410000ULL,
0x000000152c157220ULL, 0x040fe20000410000ULL, 0x000000182c187220ULL, 0x040fe20000410000ULL,
0x000000192c197220ULL, 0x040fe20000410000ULL, 0x0000001c2c1c7220ULL, 0x040fe20000410000ULL,
0x0000001d2c1d7220ULL, 0x040fe20000410000ULL, 0x000000202c207220ULL, 0x040fe20000410000ULL,
0x000000212c217220ULL, 0x040fe20000410000ULL, 0x000000302c307220ULL, 0x040fe20000410000ULL,
0x000000312c317220ULL, 0x040fe20000410000ULL, 0x000000382c387220ULL, 0x040fe20000410000ULL,
0x000000392c397220ULL, 0x000fce0000410000ULL, 0x000000367d7d7220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x0000001809357811ULL, 0x000fca00078ff0ffULL,
0x00001f35362c7589ULL, 0x002e6400000e0000ULL, 0x0000000e2c0e7220ULL, 0x042fe20000410000ULL,
0x0000000f2c0f7220ULL, 0x040fe20000410000ULL, 0x000000122c127220ULL, 0x040fe20000410000ULL,
0x000000132c137220ULL, 0x040fe20000410000ULL, 0x000000162c167220ULL, 0x040fe20000410000ULL,
0x000000172c177220ULL, 0x040fe20000410000ULL, 0x0000001a2c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b2c1b7220ULL, 0x040fe20000410000ULL, 0x0000001e2c1e7220ULL, 0x040fe20000410000ULL,
0x0000001f2c1f7220ULL, 0x040fe20000410000ULL, 0x000000222c227220ULL, 0x040fe20000410000ULL,
0x000000232c237220ULL, 0x040fe20000410000ULL, 0x000000322c327220ULL, 0x040fe20000410000ULL,
0x000000332c337220ULL, 0x040fe20000410000ULL, 0x0000003a2c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b2c3b7220ULL, 0x000fce0000410000ULL, 0x000000342fff7212ULL, 0x000fe200078030ffULL,
0x00000001ff347424ULL, 0x000fd800078e00ffULL, 0x8000007f2d2d0221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2d2d0820ULL, 0x000fc80000410000ULL,
0x0000002d00040308ULL, 0x000ea40000000800ULL, 0x000000042e2e0220ULL, 0x004fce0000410000ULL,
0x0000007d2e7d7221ULL, 0x000fe20000010000ULL, 0x00000000002c7805ULL, 0x002fe40000015200ULL,
0xfffffff0632f7812ULL, 0x000fca00078ec0ffULL, 0x0000000108377824ULL, 0x000fc800078e022fULL,
0x01a6b085370075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fcc0000015200ULL,
0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000352e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6b085370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009910342e7816ULL, 0x000fe200000000ffULL,
0x00000004772c7824ULL, 0x040fe400078e00ffULL, 0x00000400772f7824ULL, 0x040fe200078e00ffULL,
0x000000ff2e00720cULL, 0x000fe20003f05270ULL, 0x00001000772d7824ULL, 0x000fe200078e00ffULL,
0x000000042c2c7812ULL, 0x000fe400078ec0ffULL, 0xfffff0002f2f7812ULL, 0x000fe400078ec0ffULL,
0x0000002c09817211ULL, 0x000fc400078fe0ffULL, 0x00013000087c7810ULL, 0x000fe20007ffe02fULL,
0x000000086e2f7824ULL, 0x040fe200078e00ffULL, 0xffffe0002d2d7812ULL, 0x000fe200078ec0ffULL,
0x000000016e4c7824ULL, 0x000fe400078e0281ULL, 0x0000001078347824ULL, 0x100fe200078e027cULL,
0x00017000084d7810ULL, 0x000fe20007ffe02dULL, 0x00000010752c7824ULL, 0x000fe200078e027cULL,
0xfffffff82f7a7812ULL, 0x000fe200078ee24cULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff2e7819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x000000082e027836ULL, 0x000fe20000000000ULL, 0x00005410002d7816ULL, 0x000fe20000000000ULL,
0x000000102e367836ULL, 0x000fe40000000000ULL, 0x000000182e4e7836ULL, 0x000fe40000000000ULL,
0x00001f022d027589ULL, 0x0002a800000e0000ULL, 0x00001f362d057589ULL, 0x0002e800000e0000ULL,
0x00001f2e2d037589ULL, 0x00026800000e0000ULL, 0x00001f4e2d007589ULL, 0x00026400000e0000ULL,
0x000000003434783bULL, 0x002e620000000200ULL, 0x000000107a5c7824ULL, 0x000fc600078e024dULL,
0x000000002c2c783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000235357232ULL, 0x084fe40000200000ULL, 0x0000000237377232ULL, 0x000fe40000200000ULL,
0x000000052c2c7232ULL, 0x088fe40000200000ULL, 0x000000052e2e7232ULL, 0x000fc40000200000ULL,
0x000000002d2d7232ULL, 0x080fe40000200000ULL, 0x000000002f2f7232ULL, 0x000fce0000200000ULL,
0x000000005c5c783bULL, 0x000f220000004200ULL, 0x000000086e4f7824ULL, 0x000fe400078e00ffULL,
0x000000024c7e7836ULL, 0x000fe40000000000ULL, 0x0000000176817824ULL, 0x000fc600078e0281ULL,
0xfffffff84f7e7812ULL, 0x000fca00078ee27eULL, 0x000000107e4d7824ULL, 0x000fcc00078e024dULL,
0x000000004d4c783bULL, 0x000f620000004200ULL, 0x000001005c667824ULL, 0x050fe200078e00ffULL,
0x000088805d8c7816ULL, 0x040fe200000000ffULL, 0x000001005d677824ULL, 0x040fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001145cULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000008c008c7306ULL, 0x000fe20000202400ULL,
0x00000018ff897819ULL, 0x000fe2000001145dULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x000088805c7b7816ULL, 0x040fe200000000ffULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fc4000001145eULL, 0x00000018ff907819ULL, 0x000fe2000001145dULL,
0x00000066008e7306ULL, 0x0009e20000202400ULL, 0x00000018ff8d7819ULL, 0x000fe2000001145cULL,
0x000001005e5d7824ULL, 0x040fe200078e00ffULL, 0x000088805e5c7816ULL, 0x000fe200000000ffULL,
0x000001004d757824ULL, 0x028fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe2000001144dULL,
0x000001004c6b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe2000001144cULL,
0x0000006700917306ULL, 0x0007620000202400ULL, 0x000001005f667824ULL, 0x010fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fc4000001144eULL, 0x00000018ff6b7819ULL, 0x000fe4000001146bULL,
0x00000018ff6a7819ULL, 0x000fe20000011466ULL, 0x000100005e667824ULL, 0x000fe200078e00ffULL,
0x0000007b007b7306ULL, 0x000fe20000202400ULL, 0x000088804e927816ULL, 0x000fe400000000ffULL,
0x00000018ff8b7819ULL, 0x000fe4000001145dULL, 0x00000018ff677819ULL, 0x008fe20000011466ULL,
0x000100005f667824ULL, 0x040fe200078e00ffULL, 0x000088805f5d7816ULL, 0x000fe200000000ffULL,
0x0000006a005e7306ULL, 0x0007e20000202400ULL, 0x00000018ff867819ULL, 0x000fc4000001145fULL,
0x00000018ff8f7819ULL, 0x000fe40000011466ULL, 0x000088804c667816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001144fULL,
0x0000006b00877306ULL, 0x0009e20000202400ULL, 0x000088804d6a7816ULL, 0x048fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff757819ULL, 0x000fc40000011475ULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000004c00857306ULL, 0x0007e20000202400ULL, 0x000001004e6b7824ULL, 0x050fe400078e00ffULL,
0x000100004e4e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff937819ULL, 0x000fe4000001146bULL,
0x0000004d00807306ULL, 0x000be20000202400ULL, 0x000001004f4c7824ULL, 0x048fe200078e00ffULL,
0x000088804f6b7816ULL, 0x040fe400000000ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000005d005d7306ULL, 0x000ee20000202400ULL,
0x000054108c4d7816ULL, 0x024fe20000000091ULL, 0x000100004f8c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001148cULL, 0x00000067005f7306ULL, 0x000fe20000202400ULL,
0x000054105d5d7816ULL, 0x008fce000000005eULL, 0x0000004c00787306ULL, 0x0005f00000202400ULL,
0x0000008800887306ULL, 0x000ee20000202400ULL, 0x000054107b4c7816ULL, 0x004fce000000008eULL,
0x0000006a00677306ULL, 0x000fe20000202400ULL, 0x0000004c3454723cULL, 0x002fe20000041854ULL,
0x000054105f5e7816ULL, 0x008fcc0000000088ULL, 0x0000007500847306ULL, 0x000e620000202400ULL,
0x0000004c2c0c723cULL, 0x000fee000004180cULL, 0x0000008a008a7306ULL, 0x000fe20000202400ULL,
0x00017000704d7836ULL, 0x000fe20000000000ULL, 0x0000541067677816ULL, 0x002fcc0000000084ULL,
0x0000008900897306ULL, 0x000ff00000202400ULL, 0x0000008600867306ULL, 0x000ff00000202400ULL,
0x0000006800687306ULL, 0x000e700000202400ULL, 0x0000006900697306ULL, 0x000ea20000202400ULL,
0x0000541085687816ULL, 0x002fce0000000068ULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x0000541080697816ULL, 0x004fce0000000069ULL, 0x0000006d006d7306ULL, 0x000fe20000202400ULL,
0x0000000277807824ULL, 0x000fe200078e00ffULL, 0x000000683450723cULL, 0x000fec0000041850ULL,
0x0000008d008d7306ULL, 0x000fe20000202400ULL, 0x000000682c20723cULL, 0x000fee0000041820ULL,
0x0000009000907306ULL, 0x000e700000202400ULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x00005410904f7816ULL, 0x002fce0000000089ULL, 0x0000008b008b7306ULL, 0x000e700000202400ULL,
0x0000008f008f7306ULL, 0x000ea20000202400ULL, 0x000054105c5c7816ULL, 0x002fce000000008bULL,
0x0000006600667306ULL, 0x000e620000202400ULL, 0x0000005c3440723cULL, 0x000fe20000041840ULL,
0x000054108f5f7816ULL, 0x004fcc0000000086ULL, 0x00000092006a7306ULL, 0x000fe20000202400ULL,
0x0000005c2c14723cULL, 0x000fe20000041814ULL, 0x0000541066667816ULL, 0x002fcc0000000087ULL,
0x0000009300757306ULL, 0x000e620000202400ULL, 0x0000005e3444723cULL, 0x000fee0000041844ULL,
0x0000006b006b7306ULL, 0x000ea20000202400ULL, 0x000000663448723cULL, 0x000fe20000041848ULL,
0x000054106a6a7816ULL, 0x002fcc0000000075ULL, 0x0000004e007b7306ULL, 0x0002e20000202400ULL,
0x0000005e2c18723cULL, 0x000fe20000041818ULL, 0x000054106b6b7816ULL, 0x004fcc0000000078ULL,
0x0000008c008c7306ULL, 0x000ea20000202400ULL, 0x000054108d4e7816ULL, 0x002fe2000000008aULL,
0x0000000876787824ULL, 0x000fe200078e00ffULL, 0x000000662c1c723cULL, 0x000fe2000004181cULL,
0x000054107b6c7816ULL, 0x008fca000000006cULL, 0x0000004e343c723cULL, 0x000fe2000004183cULL,
0xfffffff878787812ULL, 0x000fe400078ee281ULL, 0x000054108c6d7816ULL, 0x004fc6000000006dULL,
0x0000006a3428723cULL, 0x000fe20000041828ULL, 0x00000010785c7824ULL, 0x000fca00078e024dULL,
0x0000006c3424723cULL, 0x000fec0000041824ULL, 0x0000004e2c10723cULL, 0x000fe20000041810ULL,
0x0000000480347812ULL, 0x000fe200078ec0ffULL, 0x0000000876367824ULL, 0x000fc600078e00ffULL,
0x0000000234347812ULL, 0x000fe200078efcffULL, 0x0000006a2c30723cULL, 0x000fe60000041830ULL,
0x0000003409357211ULL, 0x000fe200078fe0ffULL, 0x000000086e347824ULL, 0x040fe400078e00ffULL,
0x0000006c2c38723cULL, 0x000fe40000041838ULL, 0x000000016e7b7824ULL, 0x100fe400078e0235ULL,
0x0000000176757824ULL, 0x000fc600078e0235ULL, 0xfffffff8347b7812ULL, 0x000fe400078ee27bULL,
0xfffffff836757812ULL, 0x000fc600078ee275ULL, 0x000000107b347824ULL, 0x100fe400078e027cULL,
0x00000010757c7824ULL, 0x000fc800078e027cULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x000000007c2c783bULL, 0x0004e20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000334347232ULL, 0x082fe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000235357232ULL, 0x080fe40000200000ULL, 0x0000000237377232ULL, 0x000fe40000200000ULL,
0x000000052c2c7232ULL, 0x088fe40000200000ULL, 0x000000052e2e7232ULL, 0x000fc40000200000ULL,
0x000000002d2d7232ULL, 0x080fe40000200000ULL, 0x000000002f2f7232ULL, 0x000fce0000200000ULL,
0x00000008764f7824ULL, 0x000fe200078e00ffULL, 0x000000005c5c783bULL, 0x000f220000004200ULL,
0x00000002817c7836ULL, 0x004fca0000000000ULL, 0xfffffff84f7c7812ULL, 0x000fca00078ee27cULL,
0x000000107c4c7824ULL, 0x000fcc00078e024dULL, 0x000000004c4c783bULL, 0x000ea20000004200ULL,
0x000001005d677824ULL, 0x050fe200078e00ffULL, 0x000088805c867816ULL, 0x040fe200000000ffULL,
0x000001005c667824ULL, 0x040fe200078e00ffULL, 0x000088805d907816ULL, 0x040fe400000000ffULL,
0x00000018ff677819ULL, 0x000fe40000011467ULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000008600867306ULL, 0x000fe20000202400ULL, 0x00000018ff8c7819ULL, 0x000fe2000001145dULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe2000001145cULL,
0x000100005c5c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fc4000001145eULL,
0x00000018ff937819ULL, 0x000fe2000001145dULL, 0x0000006700957306ULL, 0x0009e20000202400ULL,
0x00000018ff697819ULL, 0x004fe2000001144dULL, 0x000001004d6a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe2000001144cULL, 0x000001005e5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001145cULL, 0x000001004e6b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001145fULL, 0x0000006600917306ULL, 0x0005620000202400ULL,
0x000001004c677824ULL, 0x010fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fc4000001145dULL,
0x000088805e5c7816ULL, 0x040fe200000000ffULL, 0x000100005e5e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe40000011467ULL, 0x000088804d677816ULL, 0x000fe200000000ffULL,
0x000001005f667824ULL, 0x004fe200078e00ffULL, 0x0000009000907306ULL, 0x000ea20000202400ULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x000088805f5d7816ULL, 0x040fe200000000ffULL,
0x000100005f5f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fc40000011466ULL,
0x000088804c667816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000008d008d7306ULL, 0x000fe20000202400ULL,
0x00000018ff887819ULL, 0x000fe4000001146aULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff6c7819ULL, 0x000fe4000001144eULL, 0x000088804e6a7816ULL, 0x040fe200000000ffULL,
0x0000004d00847306ULL, 0x0009e20000202400ULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fc4000001146bULL, 0x00000018ff6d7819ULL, 0x000fe4000001144fULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000004c00877306ULL, 0x000be20000202400ULL,
0x000001004f4d7824ULL, 0x050fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x000088804f6b7816ULL, 0x000fe400000000ffULL, 0x00000018ff4e7819ULL, 0x000fc4000001144eULL,
0x0000008c008c7306ULL, 0x000fe20000202400ULL, 0x00005410864c7816ULL, 0x028fe40000000091ULL,
0x00000018ff867819ULL, 0x000fe4000001144dULL, 0x00005410904d7816ULL, 0x004fe20000000095ULL,
0x000100004f907824ULL, 0x000fe400078e00ffULL, 0x0000008b008b7306ULL, 0x000fe60000202400ULL,
0x00000018ff907819ULL, 0x000fe20000011490ULL, 0x0000004c3454723cULL, 0x002fe80000041854ULL,
0x0000008a008a7306ULL, 0x000fe40000202400ULL, 0x0000004c2c0c723cULL, 0x000fec000004180cULL,
0x0000006800687306ULL, 0x000e700000202400ULL, 0x0000006900697306ULL, 0x000ea20000202400ULL,
0x0000541087687816ULL, 0x002fce0000000068ULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x0000541084697816ULL, 0x004fce0000000069ULL, 0x0000006d006d7306ULL, 0x000fe20000202400ULL,
0x000000683450723cULL, 0x000fee0000041850ULL, 0x0000008e008e7306ULL, 0x000fe20000202400ULL,
0x000000682c20723cULL, 0x000fee0000041820ULL, 0x0000009300937306ULL, 0x000e700000202400ULL,
0x0000005c005c7306ULL, 0x000fe20000202400ULL, 0x00005410934f7816ULL, 0x002fce000000008cULL,
0x0000008f008f7306ULL, 0x000e700000202400ULL, 0x0000005d005d7306ULL, 0x000fe20000202400ULL,
0x000054105c5c7816ULL, 0x002fce000000008fULL, 0x0000009200927306ULL, 0x000e700000202400ULL,
0x0000005e005e7306ULL, 0x000ea20000202400ULL, 0x000054105d5d7816ULL, 0x002fce0000000092ULL,
0x0000005f005f7306ULL, 0x000e620000202400ULL, 0x0000005c3440723cULL, 0x000fe20000041840ULL,
0x000054105e5e7816ULL, 0x004fcc000000008bULL, 0x0000006600667306ULL, 0x000fe20000202400ULL,
0x0000005c2c14723cULL, 0x000fe20000041814ULL, 0x000054105f5f7816ULL, 0x002fcc000000008aULL,
0x0000008900897306ULL, 0x000e620000202400ULL, 0x0000005e3444723cULL, 0x000fee0000041844ULL,
0x0000006700677306ULL, 0x000fe20000202400ULL, 0x0000005e2c18723cULL, 0x000fe20000041818ULL,
0x0000541066667816ULL, 0x002fcc0000000089ULL, 0x0000008800887306ULL, 0x000e700000202400ULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x0000541067677816ULL, 0x002fce0000000088ULL,
0x0000008500857306ULL, 0x000e620000202400ULL, 0x000000663448723cULL, 0x000fee0000041848ULL,
0x0000004e00817306ULL, 0x0004e20000202400ULL, 0x000000662c1c723cULL, 0x000fe2000004181cULL,
0x000054106a6a7816ULL, 0x002fcc0000000085ULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x000054108e4e7816ULL, 0x004fe4000000008dULL, 0x00005410816c7816ULL, 0x008fca000000006cULL,
0x0000008600867306ULL, 0x000e620000202400ULL, 0x0000004e343c723cULL, 0x000fec000004183cULL,
0x0000004e2c10723cULL, 0x000fe20000041810ULL, 0x0000009000907306ULL, 0x000ea20000202400ULL,
0x000054106b6b7816ULL, 0x002fce0000000086ULL, 0x0000006a3428723cULL, 0x000fe20000041828ULL,
0x00005410906d7816ULL, 0x004fca000000006dULL, 0x0000006a2c30723cULL, 0x000fec0000041830ULL,
0x0000006c3424723cULL, 0x000fec0000041824ULL, 0x0000006c2c38723cULL, 0x000fe20000041838ULL,
0xfffffff880357812ULL, 0x000fe200078ec0ffULL, 0x0000000861347824ULL, 0x000fc400078e0208ULL,
0x00000001ff377424ULL, 0x000fe400078e00ffULL, 0x0000000108367824ULL, 0x000fe400078e0235ULL,
0x01a6c837343479a7ULL, 0x0002a4000850003fULL, 0x01a6903736ff79a7ULL, 0x0003dc000850003fULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x00000035060075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff367224ULL, 0x002fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000c0722d7836ULL, 0x000fe20000000000ULL, 0x0000940000087ab9ULL, 0x000fc60000000800ULL,
0x000000085a367c24ULL, 0x002fe2000f8e022dULL, 0x0000000000fc9947ULL, 0x000fec0003800000ULL,
0x0000002d622c7248ULL, 0x000fe20007fe0000ULL, 0x00000010652f7824ULL, 0x000fe200078e00ffULL,
0x00000003ff2e7819ULL, 0x000fe20000011609ULL, 0x0000900000087ab9ULL, 0x000fe40000000a00ULL,
0x000000012c2c7824ULL, 0x000fe400078e0a2dULL, 0x000000012f2d7824ULL, 0x000fe400078e022eULL,
0x000000082e377836ULL, 0x000fe20000000000ULL, 0x0000002c2f2c7248ULL, 0x000fe20007fe0000ULL,
0x000000012d347824ULL, 0x000fc400078e0209ULL, 0x000000082d4d7824ULL, 0x000fe400078e00ffULL,
0x000000012c2c7824ULL, 0x000fe400078e0a2fULL, 0x000000042e357836ULL, 0x000fe20000000000ULL,
0xfffffff84d4d7812ULL, 0x000fe400078ee234ULL, 0x0000002c2e00720cULL, 0x080fe20003f86070ULL,
0x0000000c2e2e7836ULL, 0x000fe20000000000ULL, 0x0000002c3700720cULL, 0x080fe20003f46070ULL,
0x000000012f347824ULL, 0x000fe200078e0235ULL, 0x0000002c3500720cULL, 0x080fe20003f66070ULL,
0x000000012f377824ULL, 0x040fe200078e0237ULL, 0x0000002c2e00720cULL, 0x000fe20003f06070ULL,
0x000000012f4c7824ULL, 0x000fc400078e022eULL, 0x00000001342e7824ULL, 0x140fe400078e0209ULL,
0x00000008344f7824ULL, 0x040fe400078e00ffULL, 0x00000001372f7824ULL, 0x040fe400078e0209ULL,
0x00000008374e7824ULL, 0x000fe200078e00ffULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee22eULL,
0x000000012d2c7824ULL, 0x100fe400078e0236ULL, 0x0000000134347824ULL, 0x100fe200078e0236ULL,
0xfffffff84e5d7812ULL, 0x000fe200078ee22fULL, 0x00000001372e7824ULL, 0x000fc400078e0236ULL,
0x000000014c367824ULL, 0x040fe400078e0236ULL, 0x000000014c2f7824ULL, 0x040fe400078e0209ULL,
0x000000084c4c7824ULL, 0x000fe400078e00ffULL, 0x000000802c2c7825ULL, 0x000fc600078e00ffULL,
0xfffffff84c5f7812ULL, 0x000fe200078ee22fULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x000000712c2c7212ULL, 0x000fc600078efcffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000007134347212ULL, 0x080fe400078efcffULL, 0x000000082c2c7c10ULL, 0x000fe2000ffbe0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000000834347c10ULL, 0x000fe4000ffde0ffULL,
0x000000712e2e7212ULL, 0x080fe200078efcffULL, 0x00017000704c7836ULL, 0x000fe20000000000ULL,
0x0000007136367212ULL, 0x000fe400078efcffULL, 0x000000092d2d7c10ULL, 0x000fe2000affe4ffULL,
0x000000104d4d7824ULL, 0x100fe200078e024cULL, 0x0000000935357c10ULL, 0x000fe2000b7fe4ffULL,
0x000000104f4f7824ULL, 0x100fe200078e024cULL, 0x000000082e2e7c10ULL, 0x000fe2000ffbe0ffULL,
0x000000105d5d7824ULL, 0x100fe200078e024cULL, 0x0000000836367c10ULL, 0x000fe2000ffde0ffULL,
0x000000105f5f7824ULL, 0x000fe200078e024cULL, 0x000000092f2f7c10ULL, 0x000fe2000affe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c4d7faeULL, 0x0003e2000e101c46ULL,
0x0000000937377c10ULL, 0x000fc6000b7fe4ffULL, 0x00000000344f7faeULL, 0x0003e8000d901c46ULL,
0x000000002e5d7faeULL, 0x0003e8000d101c46ULL, 0x00000000365f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c87947ULL, 0x000fea0003800000ULL, 0x00000010652c7824ULL, 0x000fe200078e00ffULL,
0x0000900000087ab9ULL, 0x000fc80000000a00ULL, 0x0000002c092d7211ULL, 0x000fca00078fe8ffULL,
0x000000012d2e7824ULL, 0x040fe400078e0209ULL, 0x000000082d4d7824ULL, 0x040fe400078e00ffULL,
0x000000042d2f7836ULL, 0x000fe40000000000ULL, 0x000000082d377836ULL, 0x000fe20000000000ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee22eULL, 0x000000012d2c7824ULL, 0x000fe400078e0236ULL,
0x0000000c2d4c7836ULL, 0x000fc40000000000ULL, 0x000000012f2e7824ULL, 0x140fe400078e0236ULL,
0x000000012f357824ULL, 0x140fe400078e0209ULL, 0x000000082f4e7824ULL, 0x000fe400078e00ffULL,
0x0000000137347824ULL, 0x040fe400078e0236ULL, 0x00000001372f7824ULL, 0x040fe200078e0209ULL,
0xfffffff84e4f7812ULL, 0x000fe200078ee235ULL, 0x00000008375c7824ULL, 0x000fc400078e00ffULL,
0x000000802c2c7825ULL, 0x000fc600078e00ffULL, 0xfffffff85c5d7812ULL, 0x000fe200078ee22fULL,
0x000000014c367824ULL, 0x000fe200078e0236ULL, 0x000000712c2c7212ULL, 0x000fe200078efcffULL,
0x000000014c377824ULL, 0x040fe400078e0209ULL, 0x000000084c4c7824ULL, 0x000fe200078e00ffULL,
0x000000082c2c7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000802e2e7825ULL, 0x000fc600078e00ffULL,
0xfffffff84c5f7812ULL, 0x000fe200078ee237ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x000000712e2e7212ULL, 0x080fe400078efcffULL, 0x000000092d2d7c10ULL, 0x000fe200087fe4ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000007134347212ULL, 0x080fe400078efcffULL,
0x000000082e2e7c10ULL, 0x000fe2000ff1e0ffULL, 0x00017000704c7836ULL, 0x000fe20000000000ULL,
0x0000007136367212ULL, 0x000fc400078efcffULL, 0x0000000834347c10ULL, 0x000fe2000ff5e0ffULL,
0x000000104d4d7824ULL, 0x100fe200078e024cULL, 0x0000000836367c10ULL, 0x000fe2000ff7e0ffULL,
0x000000104f4f7824ULL, 0x100fe200078e024cULL, 0x000000092f2f7c10ULL, 0x000fe200087fe4ffULL,
0x000000105d5d7824ULL, 0x100fe200078e024cULL, 0x0000000935357c10ULL, 0x000fe200097fe4ffULL,
0x000000105f5f7824ULL, 0x000fe200078e024cULL, 0x0000000937377c10ULL, 0x000fe20009ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c4d7faeULL, 0x0003e8000b901c46ULL,
0x000000002e4f7faeULL, 0x0003e8000b901c46ULL, 0x00000000345d7faeULL, 0x0003e8000b901c46ULL,
0x00000000365f7faeULL, 0x0003e4000b901c46ULL, 0x0000000804087890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff0632d7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff2c7424ULL, 0x000fc600078e00ffULL, 0x0001a6a82d847810ULL, 0x000fc60007ffe008ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a48ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000082c848479a7ULL, 0x0002a4000850003fULL, 0x01a6482c732c79a7ULL, 0x0022e4000850003fULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0xffffffe063357812ULL, 0x040fe400078ec0ffULL,
0x0000001063347812ULL, 0x040fe400078ec0ffULL, 0x0000000863367812ULL, 0x000fe400078ec0ffULL,
0x0000000834357210ULL, 0x000fca0007ffe035ULL, 0x00000001354d7824ULL, 0x000fc800078e0236ULL,
0x01a6482d4d0075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x000000342e377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e2fULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6482d4d0075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x00000020772c7824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0xffffff802c2d7812ULL, 0x000fc800078ec0ffULL,
0x00000100082c7810ULL, 0x000fc80007ffe02dULL, 0x0000002c742c7210ULL, 0x000fca0007ffe071ULL,
0x01a000002c2e7984ULL, 0x000ee80000000800ULL, 0x01a200002c2d7984ULL, 0x0009220000000800ULL,
0x0000007f2e00720bULL, 0x008fda0003f1d000ULL, 0x00000000002f7806ULL, 0x000fc800000e0100ULL,
0x000000ff2f00720cULL, 0x000fda0003f05270ULL, 0x00000004009c8947ULL, 0x016fea0003800000ULL,
0x00000002592c7836ULL, 0x000fe20000000000ULL, 0x0000007f2e00720bULL, 0x0c0fe40003f14000ULL,
0x0000007f2e357209ULL, 0x000fe40007810000ULL, 0x000000772c00720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x00000080772ca824ULL, 0x000fe200078e0208ULL,
0x000000ff3400720cULL, 0x000fc80003f05270ULL, 0x0000002c742ca210ULL, 0x000fca0007ffe071ULL,
0x01a400352c00a388ULL, 0x0003e80000000800ULL, 0x0000000400508947ULL, 0x000fea0003800000ULL,
0x800000357f7f7221ULL, 0x000fe20000010000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x040fe2000784c0ffULL, 0x3fb8aa3b7f7f7820ULL, 0x000fe20000410000ULL,
0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000034ff7812ULL, 0x000fe2000788c0ffULL,
0x0000007f00367308ULL, 0x0004ec0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff377819ULL, 0x000fca0000011609ULL, 0x00001f37362c7589ULL, 0x00ae6400000e0000ULL,
0x000000542c547220ULL, 0x042fe20000410000ULL, 0x000000552c557220ULL, 0x040fe20000410000ULL,
0x0000003c2c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2c3d7220ULL, 0x040fe20000410000ULL,
0x000000402c407220ULL, 0x040fe20000410000ULL, 0x000000412c417220ULL, 0x040fe20000410000ULL,
0x000000442c447220ULL, 0x040fe20000410000ULL, 0x000000452c457220ULL, 0x040fe20000410000ULL,
0x000000482c487220ULL, 0x040fe20000410000ULL, 0x000000492c497220ULL, 0x040fe20000410000ULL,
0x000000502c507220ULL, 0x040fe20000410000ULL, 0x000000512c517220ULL, 0x040fe20000410000ULL,
0x000000282c287220ULL, 0x040fe20000410000ULL, 0x000000292c297220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x0000000809377811ULL, 0x000fca00078ff0ffULL,
0x00001f37362c7589ULL, 0x00ae6400000e0000ULL, 0x000000562c567220ULL, 0x042fe20000410000ULL,
0x000000572c577220ULL, 0x040fe20000410000ULL, 0x0000003e2c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2c3f7220ULL, 0x040fe20000410000ULL, 0x000000422c427220ULL, 0x040fe20000410000ULL,
0x000000432c437220ULL, 0x040fe20000410000ULL, 0x000000462c467220ULL, 0x040fe20000410000ULL,
0x000000472c477220ULL, 0x040fe20000410000ULL, 0x0000004a2c4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2c4b7220ULL, 0x040fe20000410000ULL, 0x000000522c527220ULL, 0x040fe20000410000ULL,
0x000000532c537220ULL, 0x040fe20000410000ULL, 0x0000002a2c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2c2b7220ULL, 0x040fe20000410000ULL, 0x000000262c267220ULL, 0x040fe20000410000ULL,
0x000000272c277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x0000001009377811ULL, 0x000fca00078ff0ffULL, 0x00001f37362c7589ULL, 0x00ae6400000e0000ULL,
0x0000000c2c0c7220ULL, 0x042fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x000000102c107220ULL, 0x040fe20000410000ULL, 0x000000112c117220ULL, 0x040fe20000410000ULL,
0x000000142c147220ULL, 0x040fe20000410000ULL, 0x000000152c157220ULL, 0x040fe20000410000ULL,
0x000000182c187220ULL, 0x040fe20000410000ULL, 0x000000192c197220ULL, 0x040fe20000410000ULL,
0x0000001c2c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000202c207220ULL, 0x040fe20000410000ULL, 0x000000212c217220ULL, 0x040fe20000410000ULL,
0x000000302c307220ULL, 0x040fe20000410000ULL, 0x000000312c317220ULL, 0x040fe20000410000ULL,
0x000000382c387220ULL, 0x040fe20000410000ULL, 0x000000392c397220ULL, 0x000fce0000410000ULL,
0x000000367d7d7220ULL, 0x008fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x0000001809377811ULL, 0x000fca00078ff0ffULL, 0x00001f37362c7589ULL, 0x002e6400000e0000ULL,
0x0000000e2c0e7220ULL, 0x042fe20000410000ULL, 0x0000000f2c0f7220ULL, 0x040fe20000410000ULL,
0x000000122c127220ULL, 0x040fe20000410000ULL, 0x000000132c137220ULL, 0x040fe20000410000ULL,
0x000000162c167220ULL, 0x040fe20000410000ULL, 0x000000172c177220ULL, 0x040fe20000410000ULL,
0x0000001a2c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2c1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2c1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2c1f7220ULL, 0x040fe20000410000ULL,
0x000000222c227220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000322c327220ULL, 0x040fe20000410000ULL, 0x000000332c337220ULL, 0x040fe20000410000ULL,
0x0000003a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2c3b7220ULL, 0x000fce0000410000ULL,
0x000000342fff7212ULL, 0x000fe200078030ffULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x000000ffff7f7224ULL, 0x004fd400078e0035ULL, 0x800000352e2e0221ULL, 0x100fe20000010000ULL,
0x000000ffff7f0224ULL, 0x000fe200078e0035ULL, 0x00007610ff340816ULL, 0x000fe40000000034ULL,
0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL, 0x0000002e00040308ULL, 0x000ea40000000800ULL,
0x000000042d2d0220ULL, 0x004fce0000410000ULL, 0x0000007d2d7d7221ULL, 0x000fe20000010000ULL,
0x00000000002c7805ULL, 0x002fe20000015200ULL, 0x00000083ff0075a7ULL, 0x000ea40008000145ULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000083ff0075a7ULL, 0x000e640008000145ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000277737824ULL, 0x040fe200078e00ffULL, 0x00009910342f7816ULL, 0x000fe200000000ffULL,
0x00000400772e7824ULL, 0x000fe400078e00ffULL, 0x000000086e377824ULL, 0x000fe200078e00ffULL,
0x00000004732c7812ULL, 0x000fe200078ec0ffULL, 0x00000008764d7824ULL, 0x000fe200078e00ffULL,
0x000000ff2f00720cULL, 0x000fe20003f05270ULL, 0x000000107a5c7824ULL, 0x000fe200078e026fULL,
0x0000002c092d7211ULL, 0x000fe400078fe0ffULL, 0xfffff0002e357812ULL, 0x000fc600078ec0ffULL,
0x000000016e2c7824ULL, 0x000fe200078e022dULL, 0x0001400008807810ULL, 0x000fe20007ffe035ULL,
0x00000001762e7824ULL, 0x000fc600078e022dULL, 0xfffffff8372d7812ULL, 0x000fe400078ee22cULL,
0xfffffff84d2f7812ULL, 0x000fc600078ee22eULL, 0x000000102d347824ULL, 0x100fe400078e0280ULL,
0x000000102f2f7824ULL, 0x000fe200078e0280ULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000001003057836ULL, 0x000fe20000000000ULL, 0x00005410002c7816ULL, 0x000fe20000000000ULL,
0x00000008032d7836ULL, 0x000fe40000000000ULL, 0x0000001803357836ULL, 0x000fe40000000000ULL,
0x00001f052c057589ULL, 0x0002a800000e0000ULL, 0x00001f2d2c027589ULL, 0x0002e800000e0000ULL,
0x00001f032c037589ULL, 0x00026800000e0000ULL, 0x00001f352c007589ULL, 0x00026400000e0000ULL,
0x000000003434783bULL, 0x002e680000000200ULL, 0x000000002f2c783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000200000ULL,
0x0000000336367232ULL, 0x000fe40000200000ULL, 0x0000000235357232ULL, 0x088fe40000200000ULL,
0x0000000237377232ULL, 0x000fe40000200000ULL, 0x000000052c2c7232ULL, 0x084fe40000200000ULL,
0x000000052e2e7232ULL, 0x000fc40000200000ULL, 0x000000002d2d7232ULL, 0x080fe40000200000ULL,
0x000000002f2f7232ULL, 0x000fce0000200000ULL, 0x000000005c5c783bULL, 0x000f220000004200ULL,
0x000000107e4c7824ULL, 0x000fcc00078e026fULL, 0x000000004c4c783bULL, 0x000f620000004200ULL,
0x00000018ff8d7819ULL, 0x010fe2000001145cULL, 0x000001005c667824ULL, 0x040fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001145dULL, 0x000001005d677824ULL, 0x040fe200078e00ffULL,
0x000088805c827816ULL, 0x040fe200000000ffULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x000088805d917816ULL, 0x040fe200000000ffULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001145eULL, 0x0000008c008c7306ULL, 0x000fe20000202400ULL,
0x00000018ff907819ULL, 0x000fe2000001145cULL, 0x000001004e6b7824ULL, 0x028fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe2000001145dULL, 0x000001005e5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fc40000011467ULL, 0x000088805e5c7816ULL, 0x040fe200000000ffULL,
0x000100005e5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000006700927306ULL, 0x0007e20000202400ULL, 0x00000018ff697819ULL, 0x000fe4000001144dULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x00000018ff687819ULL, 0x000fe4000001144cULL,
0x00000018ff887819ULL, 0x000fe2000001145fULL, 0x00000066008f7306ULL, 0x0009e20000202400ULL,
0x000001004c677824ULL, 0x008fe200078e00ffULL, 0x000088805f8e7816ULL, 0x000fc400000000ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001144eULL, 0x00000018ff897819ULL, 0x000fe40000011467ULL,
0x0000005e008b7306ULL, 0x0007e20000202400ULL, 0x000001005f667824ULL, 0x010fe200078e00ffULL,
0x000088804d677816ULL, 0x000fe200000000ffULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x000088804e6a7816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff957819ULL, 0x000fc40000011466ULL, 0x0000008200827306ULL, 0x000fe20000202400ULL,
0x000001004d5e7824ULL, 0x048fe200078e00ffULL, 0x000088804c667816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x0000009300937306ULL, 0x000ee20000202400ULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff4c7819ULL, 0x000fc4000001144cULL, 0x00000018ff837819ULL, 0x000fe4000001146bULL,
0x00000018ff6d7819ULL, 0x000fe2000001144fULL, 0x0000004d007e7306ULL, 0x0009e20000202400ULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x000088804f6b7816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fc6000001144eULL, 0x0000005e00867306ULL, 0x000be20000202400ULL,
0x000001004f4d7824ULL, 0x010fce00078e00ffULL, 0x0000004c00877306ULL, 0x0009e20000202400ULL,
0x000100004f5e7824ULL, 0x024fe200078e00ffULL, 0x00005410934f7816ULL, 0x008fc8000000008cULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x00005410824c7816ULL, 0x010fe4000000008fULL, 0x00000018ff827819ULL, 0x000fca000001144dULL,
0x0000005d005d7306ULL, 0x000eb00000202400ULL, 0x0000008d008d7306ULL, 0x000fe20000202400ULL,
0x000054105c5c7816ULL, 0x004fce000000005dULL, 0x0000008a008a7306ULL, 0x000ff00000202400ULL,
0x0000008800887306ULL, 0x000ff00000202400ULL, 0x0000006800687306ULL, 0x000eb00000202400ULL,
0x0000006900697306ULL, 0x000ee20000202400ULL, 0x0000541087687816ULL, 0x004fce0000000068ULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x000054107e697816ULL, 0x008fce0000000069ULL,
0x0000006d006d7306ULL, 0x000fe20000202400ULL, 0x000000683450723cULL, 0x002fee0000041850ULL,
0x0000009100917306ULL, 0x000e620000202400ULL, 0x000000682c20723cULL, 0x000fee0000041820ULL,
0x0000009000907306ULL, 0x000fe20000202400ULL, 0x00005410914d7816ULL, 0x002fce0000000092ULL,
0x0000008e008e7306ULL, 0x000fe20000202400ULL, 0x0000004c3454723cULL, 0x000fee0000041854ULL,
0x0000009500957306ULL, 0x000e620000202400ULL, 0x0000004c2c0c723cULL, 0x000fee000004180cULL,
0x0000005f005f7306ULL, 0x000ea20000202400ULL, 0x000054108e5d7816ULL, 0x002fce0000000095ULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x0000005c3440723cULL, 0x000fe20000041840ULL,
0x000054105f5f7816ULL, 0x004fcc0000000088ULL, 0x0000008900897306ULL, 0x000e620000202400ULL,
0x0000005c2c14723cULL, 0x000fee0000041814ULL, 0x0000006700677306ULL, 0x000ea20000202400ULL,
0x00000010785c7824ULL, 0x000fe200078e026fULL, 0x0000541066667816ULL, 0x002fcc0000000089ULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x0000541067677816ULL, 0x004fce0000000086ULL,
0x0000008300837306ULL, 0x000e620000202400ULL, 0x000000663448723cULL, 0x000fee0000041848ULL,
0x0000004e00817306ULL, 0x0004e20000202400ULL, 0x000000662c1c723cULL, 0x000fe2000004181cULL,
0x000054106a6a7816ULL, 0x002fcc0000000083ULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x00005410904e7816ULL, 0x004fe4000000008dULL, 0x00005410816c7816ULL, 0x008fca000000006cULL,
0x0000008200827306ULL, 0x000e620000202400ULL, 0x0000004e343c723cULL, 0x000fec000004183cULL,
0x0000004e2c10723cULL, 0x000fe20000041810ULL, 0x0000005e008c7306ULL, 0x0004e20000202400ULL,
0x000054106b6b7816ULL, 0x002fe40000000082ULL, 0x000054108b5e7816ULL, 0x004fca000000008aULL,
0x0000006a3428723cULL, 0x000fe20000041828ULL, 0x000054108c6d7816ULL, 0x008fca000000006dULL,
0x0000005e3444723cULL, 0x000fec0000041844ULL, 0x0000006c3424723cULL, 0x000fec0000041824ULL,
0x0000005e2c18723cULL, 0x000fe20000041818ULL, 0x000000107b347824ULL, 0x000fc400078e0280ULL,
0x0000001075807824ULL, 0x000fc600078e0280ULL, 0x0000006a2c30723cULL, 0x000fe20000041830ULL,
0x000000003434783bULL, 0x000e6a0000000200ULL, 0x0000006c2c38723cULL, 0x000fe20000041838ULL,
0x00000000802c783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x082fe40000200000ULL,
0x0000000336367232ULL, 0x000fe40000200000ULL, 0x0000000235357232ULL, 0x080fe40000200000ULL,
0x0000000237377232ULL, 0x000fe40000200000ULL, 0x000000052c2c7232ULL, 0x088fe40000200000ULL,
0x000000052e2e7232ULL, 0x000fc40000200000ULL, 0x000000002d2d7232ULL, 0x080fe40000200000ULL,
0x000000002f2f7232ULL, 0x000fce0000200000ULL, 0x000000005c5c783bULL, 0x000f220000004200ULL,
0x000000107c4c7824ULL, 0x000fe200078e026fULL, 0xfffffff873737812ULL, 0x000fca00078ec0ffULL,
0x000000004c4c783bULL, 0x000f620000004200ULL, 0x0000000108737824ULL, 0x000fe400078e0273ULL,
0x000001005c667824ULL, 0x050fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe2000001145cULL,
0x000001005d677824ULL, 0x040fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe4000001145dULL,
0x00000018ff667819ULL, 0x000fe40000011466ULL, 0x000088805c7e7816ULL, 0x040fe200000000ffULL,
0x000100005c5c7824ULL, 0x000fe200078e00ffULL, 0x00000066008f7306ULL, 0x0009e20000202400ULL,
0x000088805d8c7816ULL, 0x040fe200000000ffULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x000001004d7c7824ULL, 0x024fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001145cULL, 0x000001004c6b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fe2000001145dULL, 0x0000006700957306ULL, 0x0005e20000202400ULL,
0x000001005f667824ULL, 0x010fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe2000001145eULL,
0x000001005e5d7824ULL, 0x040fe200078e00ffULL, 0x000088805e5c7816ULL, 0x000fc400000000ffULL,
0x00000018ff6a7819ULL, 0x000fe20000011466ULL, 0x000100005e667824ULL, 0x000fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe2000001144dULL, 0x0000007e007e7306ULL, 0x000f220000202400ULL,
0x00000018ff687819ULL, 0x000fe4000001144cULL, 0x00000018ff677819ULL, 0x004fe20000011466ULL,
0x000100005f667824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe4000001147cULL,
0x00000018ff6b7819ULL, 0x000fe2000001146bULL, 0x0000006a005e7306ULL, 0x0005e20000202400ULL,
0x00000018ff937819ULL, 0x000fc40000011466ULL, 0x000088804c667816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001144eULL,
0x000088804e8e7816ULL, 0x000fe200000000ffULL, 0x0000008c008c7306ULL, 0x000f620000202400ULL,
0x000088804d6a7816ULL, 0x044fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff8b7819ULL, 0x000fc4000001145dULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000004c00877306ULL, 0x0009e20000202400ULL,
0x000088805f5d7816ULL, 0x000fe400000000ffULL, 0x00000018ff827819ULL, 0x000fe4000001145fULL,
0x00000018ff6d7819ULL, 0x000fc6000001144fULL, 0x0000004d007c7306ULL, 0x0005e20000202400ULL,
0x000054107e4c7816ULL, 0x010fce000000008fULL, 0x0000006b00897306ULL, 0x0009e20000202400ULL,
0x000001004f4d7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001144dULL,
0x000054108c4d7816ULL, 0x028fe20000000095ULL, 0x000001004e6b7824ULL, 0x050fe200078e00ffULL,
0x0000005d005d7306ULL, 0x000ea20000202400ULL, 0x000100004f8c7824ULL, 0x040fe400078e00ffULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe2000001146bULL,
0x0000004c3454723cULL, 0x002fe20000041854ULL, 0x000088804f6b7816ULL, 0x000fc400000000ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001148cULL, 0x00000067005f7306ULL, 0x000fe20000202400ULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000004c2c0c723cULL, 0x000fe2000004180cULL,
0x000054105d5d7816ULL, 0x004fca000000005eULL, 0x0000008600867306ULL, 0x000e700000202400ULL,
0x0000006a00677306ULL, 0x000fe20000202400ULL, 0x000054105f5e7816ULL, 0x002fce0000000086ULL,
0x0000008a008a7306ULL, 0x000ff00000202400ULL, 0x0000008800887306ULL, 0x000ff00000202400ULL,
0x0000008200827306ULL, 0x000ff00000202400ULL, 0x0000006800687306ULL, 0x000e700000202400ULL,
0x0000006900697306ULL, 0x000ea20000202400ULL, 0x0000541087687816ULL, 0x002fce0000000068ULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x000054107c697816ULL, 0x004fce0000000069ULL,
0x0000006d006d7306ULL, 0x000fe20000202400ULL, 0x000000683450723cULL, 0x000fee0000041850ULL,
0x0000008d008d7306ULL, 0x000fe20000202400ULL, 0x000000682c20723cULL, 0x000fee0000041820ULL,
0x0000009100917306ULL, 0x000e700000202400ULL, 0x0000005c005c7306ULL, 0x000fe20000202400ULL,
0x00005410914f7816ULL, 0x002fce0000000088ULL, 0x0000008b008b7306ULL, 0x000e700000202400ULL,
0x0000009300937306ULL, 0x000ea20000202400ULL, 0x000054105c5c7816ULL, 0x002fce000000008bULL,
0x0000006600667306ULL, 0x000e620000202400ULL, 0x0000005c3440723cULL, 0x000fe20000041840ULL,
0x00005410935f7816ULL, 0x004fcc0000000082ULL, 0x0000008000807306ULL, 0x000ea20000202400ULL,
0x0000005c2c14723cULL, 0x000fe20000041814ULL, 0x0000541066667816ULL, 0x002fcc0000000089ULL,
0x0000008e006a7306ULL, 0x000fe20000202400ULL, 0x0000005e3444723cULL, 0x000fe20000041844ULL,
0x0000541067677816ULL, 0x004fcc0000000080ULL, 0x0000008300837306ULL, 0x000e620000202400ULL,
0x0000005e2c18723cULL, 0x000fec0000041818ULL, 0x000000663448723cULL, 0x000fe20000041848ULL,
0x0000004e00817306ULL, 0x0004ea0000202400ULL, 0x000000662c1c723cULL, 0x000fe2000004181cULL,
0x000054106a6a7816ULL, 0x002fc40000000083ULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x000054108d4e7816ULL, 0x004fe4000000008aULL, 0x00005410816c7816ULL, 0x008fca000000006cULL,
0x0000007e007e7306ULL, 0x000e620000202400ULL, 0x0000004e343c723cULL, 0x000fec000004183cULL,
0x0000004e2c10723cULL, 0x000fe20000041810ULL, 0x0000008c008c7306ULL, 0x000ea20000202400ULL,
0x000054106b6b7816ULL, 0x002fce000000007eULL, 0x0000006a3428723cULL, 0x000fe20000041828ULL,
0x000054108c6d7816ULL, 0x004fca000000006dULL, 0x0000006a2c30723cULL, 0x000fec0000041830ULL,
0x0000006c3424723cULL, 0x000fec0000041824ULL, 0x0000006c2c38723cULL, 0x000fe20000041838ULL,
0x0000000861347824ULL, 0x000fc400078e0208ULL, 0x00000001ff367424ULL, 0x000fc800078e00ffULL,
0x01a6c836343479a7ULL, 0x0002a2000850003fULL, 0x01a6983673ff79a7ULL, 0x0003de000850003fULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x00000035060075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x002fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fcc0000015200ULL,
0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000001582d7836ULL, 0x000fca0000000000ULL,
0x000000602d00720cULL, 0x000fda0003f06070ULL, 0x0000000400d40947ULL, 0x000fea0003800000ULL,
0x00000002582d7836ULL, 0x000fe20000000000ULL, 0x0000940000087ab9ULL, 0x000fc80000000800ULL,
0x000000602d00720cULL, 0x000fe20003f06070ULL, 0x00000100722d7836ULL, 0x000fc80000000000ULL,
0x000000085a377c24ULL, 0x000fd0000f8e022dULL, 0x0000000000f88947ULL, 0x000fea0003800000ULL,
0x0000002d622c7248ULL, 0x000fe20007fe0000ULL, 0x00000010652f7824ULL, 0x000fe200078e00ffULL,
0x00000003ff2e7819ULL, 0x000fe20000011609ULL, 0x0000900000087ab9ULL, 0x000fe40000000a00ULL,
0x000000012c2c7824ULL, 0x000fe400078e0a2dULL, 0x000000012f347824ULL, 0x000fe400078e022eULL,
0x000000042e357836ULL, 0x000fe20000000000ULL, 0x0000002c2f2c7248ULL, 0x000fe20007fe0000ULL,
0x00000001342d7824ULL, 0x000fc400078e0209ULL, 0x00000008344c7824ULL, 0x000fe400078e00ffULL,
0x000000012c2c7824ULL, 0x000fe400078e0a2fULL, 0x000000012f367824ULL, 0x002fe200078e0235ULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee22dULL, 0x000000082e2d7836ULL, 0x000fe20000000000ULL,
0x0000002c2e00720cULL, 0x080fe20003f86070ULL, 0x0000000c2e2e7836ULL, 0x000fe20000000000ULL,
0x0000002c3500720cULL, 0x080fe20003f66070ULL, 0x000000012f5c7824ULL, 0x000fe200078e022dULL,
0x0000002c2d00720cULL, 0x080fe20003f46070ULL, 0x000000012f667824ULL, 0x000fe200078e022eULL,
0x0000002c2e00720cULL, 0x000fe20003f06070ULL, 0x00000001362c7824ULL, 0x000fc400078e0209ULL,
0x00000008362f7824ULL, 0x000fe400078e00ffULL, 0x00000001342e7824ULL, 0x100fe400078e0237ULL,
0x0000000136347824ULL, 0x000fe200078e0237ULL, 0xfffffff82f4e7812ULL, 0x000fe200078ee22cULL,
0x000000015c2d7824ULL, 0x040fe400078e0209ULL, 0x000000085c5e7824ULL, 0x000fe400078e00ffULL,
0x000000802e2e7825ULL, 0x000fc600078e00ffULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee22dULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x000000712e2e7212ULL, 0x000fc600078efcffULL,
0x000000015c2c7824ULL, 0x100fe200078e0237ULL, 0x0000007134347212ULL, 0x080fe200078efcffULL,
0x0000000166367824ULL, 0x000fe200078e0237ULL, 0x000000082e2e7c10ULL, 0x000fe2000ffbe0ffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000000834347c10ULL, 0x000fe4000ffde0ffULL,
0x000000092f2f7c10ULL, 0x000fe2000affe4ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000000712c2c7212ULL, 0x080fe400078efcffULL, 0x0000000935357c10ULL, 0x000fe2000b7fe4ffULL,
0x00000001664d7824ULL, 0x000fe200078e0209ULL, 0x0000007136367212ULL, 0x000fe200078efcffULL,
0x00000008665c7824ULL, 0x000fe200078e00ffULL, 0x000000082c2c7c10ULL, 0x000fe2000ffbe0ffULL,
0x000000104e4f7824ULL, 0x100fe200078e026fULL, 0x0000000836367c10ULL, 0x000fe2000ffde0ffULL,
0x000000105e5d7824ULL, 0x100fe200078e026fULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee24dULL,
0x000000104c4d7824ULL, 0x000fe200078e026fULL, 0x000000092d2d7c10ULL, 0x000fc4000affe4ffULL,
0x0000000937377c10ULL, 0x000fe2000b7fe4ffULL, 0x000000105c6f7824ULL, 0x000fe200078e026fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e4d7faeULL, 0x0003e8000e101c46ULL,
0x00000000344f7faeULL, 0x0003e8000d901c46ULL, 0x000000002c5d7faeULL, 0x0003e8000d101c46ULL,
0x00000000366f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x00000010652c7824ULL, 0x000fe200078e00ffULL, 0x0000900000087ab9ULL, 0x000fc80000000a00ULL,
0x0000002c092e7211ULL, 0x000fca00078fe8ffULL, 0x000000012e2d7824ULL, 0x040fe400078e0209ULL,
0x000000082e4c7824ULL, 0x040fe400078e00ffULL, 0x000000042e347836ULL, 0x000fe40000000000ULL,
0x000000082e4e7836ULL, 0x000fe20000000000ULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee22dULL,
0x0000000c2e5c7836ULL, 0x000fe40000000000ULL, 0x000000012e2c7824ULL, 0x000fc400078e0237ULL,
0x00000001342e7824ULL, 0x040fe400078e0237ULL, 0x00000001342f7824ULL, 0x040fe400078e0209ULL,
0x00000008345e7824ULL, 0x000fe400078e00ffULL, 0x000000014e367824ULL, 0x102fe400078e0237ULL,
0x000000015c347824ULL, 0x000fe400078e0237ULL, 0x000000802c2c7825ULL, 0x000fc800078e00ffULL,
0x000000015c377824ULL, 0x100fe200078e0209ULL, 0x000000712c2c7212ULL, 0x080fe200078efcffULL,
0x000000085c687824ULL, 0x000fe400078e00ffULL, 0x000000014e357824ULL, 0x040fe200078e0209ULL,
0x000000082c2c7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000084e667824ULL, 0x000fe200078e00ffULL,
0xfffffff85e4e7812ULL, 0x000fe200078ee22fULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0xfffffff8685e7812ULL, 0x000fe400078ee237ULL, 0xfffffff8665c7812ULL, 0x000fe200078ee235ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000000712e2e7212ULL, 0x000fc400078efcffULL,
0x000000092d2d7c10ULL, 0x000fe200087fe4ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000007136367212ULL, 0x080fe400078efcffULL, 0x000000082e2e7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000104c4d7824ULL, 0x100fe200078e026fULL, 0x0000007134347212ULL, 0x000fe200078efcffULL,
0x000000104e4f7824ULL, 0x100fe200078e026fULL, 0x0000000836367c10ULL, 0x000fe2000ff5e0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e026fULL, 0x0000000834347c10ULL, 0x000fe2000ff7e0ffULL,
0x000000105e6f7824ULL, 0x000fe200078e026fULL, 0x000000092f2f7c10ULL, 0x000fe200087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c4d7faeULL, 0x0003e2000b901c46ULL,
0x0000000937377c10ULL, 0x000fc400097fe4ffULL, 0x0000000935357c10ULL, 0x000fe20009ffe4ffULL,
0x000000002e4f7faeULL, 0x0003e8000b901c46ULL, 0x00000000365d7faeULL, 0x0003e8000b901c46ULL,
0x00000000346f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000034ff8079a7ULL, 0x0002a40008500005ULL,
0x01a66834073479a7ULL, 0x0022e4000850003fULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x01a66835070075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a66835070075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x00000080592c7824ULL, 0x000fe400078e0208ULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff7c7224ULL, 0x000fe200078e007fULL,
0x00000180712d7810ULL, 0x000fca0007ffe02cULL, 0x00000001742d7824ULL, 0x000fca00078e022dULL,
0x01a000002d2c7984ULL, 0x000ee80000000800ULL, 0x01a200002d2e7984ULL, 0x0009220000000800ULL,
0x0000007f2c00720bULL, 0x008fda0003f1d000ULL, 0x00000000002f7806ULL, 0x000fc800000e0100ULL,
0x000000ff2f00720cULL, 0x000fda0003f05270ULL, 0x0000000400908947ULL, 0x016fea0003800000ULL,
0x0000000359367836ULL, 0x000fe20000000000ULL, 0x0000007f2c00720bULL, 0x0c0fe40003f14000ULL,
0x0000007f2c7c7209ULL, 0x000fe40007810000ULL, 0x000000773600720cULL, 0x000fd20003f45270ULL,
0x0000000000367806ULL, 0x000fc800000e0100ULL, 0x00000080772da824ULL, 0x000fe200078e0208ULL,
0x000000ff3600720cULL, 0x000fc80003f05270ULL, 0x0000002d742da210ULL, 0x000fca0007ffe071ULL,
0x01a4007c2d00a388ULL, 0x0003e80000000800ULL, 0x0000000400508947ULL, 0x000fea0003800000ULL,
0x0000007f7c2d7221ULL, 0x002fe20000010100ULL, 0x000000ff36ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0036ff7812ULL, 0x040fe2000784c0ffULL, 0x3fb8aa3b2d2d7820ULL, 0x000fe20000410000ULL,
0x00ff000036ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000036ff7812ULL, 0x000fe2000788c0ffULL,
0x0000002d004c7308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff2d7819ULL, 0x002fcc0000011609ULL, 0x00001f2d4c2d7589ULL, 0x004e6400000e0000ULL,
0x000000542d547220ULL, 0x042fe20000410000ULL, 0x000000552d557220ULL, 0x040fe20000410000ULL,
0x0000003c2d3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2d3d7220ULL, 0x040fe20000410000ULL,
0x000000402d407220ULL, 0x040fe20000410000ULL, 0x000000412d417220ULL, 0x040fe20000410000ULL,
0x000000442d447220ULL, 0x040fe20000410000ULL, 0x000000452d457220ULL, 0x040fe20000410000ULL,
0x000000482d487220ULL, 0x040fe20000410000ULL, 0x000000492d497220ULL, 0x040fe20000410000ULL,
0x000000502d507220ULL, 0x040fe20000410000ULL, 0x000000512d517220ULL, 0x040fe20000410000ULL,
0x000000282d287220ULL, 0x040fe20000410000ULL, 0x000000292d297220ULL, 0x040fe20000410000ULL,
0x000000242d247220ULL, 0x040fe20000410000ULL, 0x000000252d257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x00000008092d7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2d4c2d7589ULL, 0x004e6400000e0000ULL, 0x000000562d567220ULL, 0x042fe20000410000ULL,
0x000000572d577220ULL, 0x040fe20000410000ULL, 0x0000003e2d3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2d3f7220ULL, 0x040fe20000410000ULL, 0x000000422d427220ULL, 0x040fe20000410000ULL,
0x000000432d437220ULL, 0x040fe20000410000ULL, 0x000000462d467220ULL, 0x040fe20000410000ULL,
0x000000472d477220ULL, 0x040fe20000410000ULL, 0x0000004a2d4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2d4b7220ULL, 0x040fe20000410000ULL, 0x000000522d527220ULL, 0x040fe20000410000ULL,
0x000000532d537220ULL, 0x040fe20000410000ULL, 0x0000002a2d2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2d2b7220ULL, 0x040fe20000410000ULL, 0x000000262d267220ULL, 0x040fe20000410000ULL,
0x000000272d277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x00000010092d7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2d4c2d7589ULL, 0x004e6400000e0000ULL,
0x0000000c2d0c7220ULL, 0x042fe20000410000ULL, 0x0000000d2d0d7220ULL, 0x040fe20000410000ULL,
0x000000102d107220ULL, 0x040fe20000410000ULL, 0x000000112d117220ULL, 0x040fe20000410000ULL,
0x000000142d147220ULL, 0x040fe20000410000ULL, 0x000000152d157220ULL, 0x040fe20000410000ULL,
0x000000182d187220ULL, 0x040fe20000410000ULL, 0x000000192d197220ULL, 0x040fe20000410000ULL,
0x0000001c2d1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2d1d7220ULL, 0x040fe20000410000ULL,
0x000000202d207220ULL, 0x040fe20000410000ULL, 0x000000212d217220ULL, 0x040fe20000410000ULL,
0x000000302d307220ULL, 0x040fe20000410000ULL, 0x000000312d317220ULL, 0x040fe20000410000ULL,
0x000000382d387220ULL, 0x040fe20000410000ULL, 0x000000392d397220ULL, 0x000fce0000410000ULL,
0x0000004c7d7d7220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x00000018092d7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2d4c2d7589ULL, 0x000e6400000e0000ULL,
0x0000000e2d0e7220ULL, 0x042fe20000410000ULL, 0x0000000f2d0f7220ULL, 0x040fe20000410000ULL,
0x000000122d127220ULL, 0x040fe20000410000ULL, 0x000000132d137220ULL, 0x040fe20000410000ULL,
0x000000162d167220ULL, 0x040fe20000410000ULL, 0x000000172d177220ULL, 0x040fe20000410000ULL,
0x0000001a2d1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2d1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2d1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2d1f7220ULL, 0x040fe20000410000ULL,
0x000000222d227220ULL, 0x040fe20000410000ULL, 0x000000232d237220ULL, 0x040fe20000410000ULL,
0x000000322d327220ULL, 0x040fe20000410000ULL, 0x000000332d337220ULL, 0x040fe20000410000ULL,
0x0000003a2d3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2d3b7220ULL, 0x000fce0000410000ULL,
0x000000362fff7212ULL, 0x000fda00078030ffULL, 0x0000002c7c2c0221ULL, 0x000fe20000010100ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2c2c0820ULL, 0x000fc80000410000ULL,
0x0000002c00040308ULL, 0x000ea40000000800ULL, 0x000000042e2e0220ULL, 0x004fce0000410000ULL,
0x0000007d2e7d7221ULL, 0x000fe20000010000ULL, 0x00000000002c7805ULL, 0x002fe40000015200ULL,
0xfffffff0632f7812ULL, 0x000fca00078ec0ffULL, 0x0000000108377824ULL, 0x000fc800078e022fULL,
0x01a6b085370075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fcc0000015200ULL,
0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000352e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6b085370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000001612d7812ULL, 0x000fe200078ec0ffULL,
0x000000086e2f7824ULL, 0x000fe200078e00ffULL, 0x00000004ff2c7819ULL, 0x000fe20000011609ULL,
0x00017000707f7836ULL, 0x000fe20000000000ULL, 0x00009910342e7816ULL, 0x000fe200000000ffULL,
0x0000000876347824ULL, 0x000fe400078e00ffULL, 0x000000042d2d7824ULL, 0x000fe200078e022cULL,
0x000000ff2e00720cULL, 0x000fe20003f05270ULL, 0x00001000592e7824ULL, 0x000fe400078e0208ULL,
0x000000016e2c7824ULL, 0x000fc400078e022dULL, 0x00000001762d7824ULL, 0x000fe400078e022dULL,
0x000150002e707836ULL, 0x000fe20000000000ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee22cULL,
0x00000004772c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8342d7812ULL, 0x000fe200078ee22dULL,
0x000000107a4c7824ULL, 0x000fe400078e027fULL, 0x000000102f2f7824ULL, 0x100fe200078e0270ULL,
0x000000042c2c7812ULL, 0x000fe200078ec0ffULL, 0x000000102d2d7824ULL, 0x000fc600078e0270ULL,
0x000000022c2c7812ULL, 0x000fe200078efcffULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000001003057836ULL, 0x000fe20000000000ULL, 0x00005410002e7816ULL, 0x000fe20000000000ULL,
0x0000000803357836ULL, 0x000fe40000000000ULL, 0x0000001803377836ULL, 0x000fe40000000000ULL,
0x00001f052e057589ULL, 0x0002a800000e0000ULL, 0x00001f352e027589ULL, 0x0002e800000e0000ULL,
0x00001f032e037589ULL, 0x00026800000e0000ULL, 0x00001f372e007589ULL, 0x00026400000e0000ULL,
0x000000002f5c783bULL, 0x0006a80000000200ULL, 0x000000002d34783bULL, 0x0026620000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000035c5c7232ULL, 0x084fe40000200000ULL,
0x000000035e5e7232ULL, 0x000fe40000200000ULL, 0x000000025d5d7232ULL, 0x088fe40000200000ULL,
0x000000025f5f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x082fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x000000004c4c783bULL, 0x000f220000004200ULL,
0x0000002c09837211ULL, 0x000fe200078fe0ffULL, 0x000000086e2d7824ULL, 0x008fc800078e00ffULL,
0x000000016e6e7824ULL, 0x000fca00078e0283ULL, 0xfffffff82d6e7812ULL, 0x000fca00078ee26eULL,
0x000000106e2c7824ULL, 0x000fcc00078e027fULL, 0x000000002c2c783bULL, 0x000ee20000004200ULL,
0x000001004c697824ULL, 0x050fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe2000001144cULL,
0x000001004d6a7824ULL, 0x040fe200078e00ffULL, 0x000088804c687816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe20000011469ULL,
0x000001004e6b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe2000001144dULL,
0x0000006600667306ULL, 0x000fe20000202400ULL, 0x000088804d697816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fc4000001144cULL,
0x00000018ff7e7819ULL, 0x000fe4000001146aULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000004c00897306ULL, 0x0009e20000202400ULL, 0x00000018ff6c7819ULL, 0x000fe4000001144eULL,
0x000088804e6a7816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe2000001146bULL, 0x000001002e857824ULL, 0x008fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe2000001142cULL, 0x0000004d00827306ULL, 0x0007e20000202400ULL,
0x000001004f4c7824ULL, 0x010fe200078e00ffULL, 0x000088802c6e7816ULL, 0x000fe200000000ffULL,
0x000001002f887824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fc4000001144fULL,
0x00000018ff847819ULL, 0x000fe4000001144cULL, 0x00000018ff4c7819ULL, 0x000fe2000001144eULL,
0x000100004f4d7824ULL, 0x048fe200078e00ffULL, 0x0000006700677306ULL, 0x000ee20000202400ULL,
0x000088804f6b7816ULL, 0x000fe400000000ffULL, 0x00000018ff747819ULL, 0x000fe4000001142eULL,
0x00000018ff4e7819ULL, 0x000fe2000001144dULL, 0x000001002c4d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001142fULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x0000006900697306ULL, 0x000fe20000202400ULL, 0x000088802e727816ULL, 0x040fe200000000ffULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x000088802f867816ULL, 0x040fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe2000001142cULL,
0x000100002d2c7824ULL, 0x040fe200078e00ffULL, 0x000088802d6f7816ULL, 0x000fe200000000ffULL,
0x0000007e007e7306ULL, 0x000f220000202400ULL, 0x00000018ff717819ULL, 0x000fc4000001142dULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x00000018ff857819ULL, 0x000fe20000011485ULL, 0x0000006a006a7306ULL, 0x000fe20000202400ULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x0000541082677816ULL, 0x008fe40000000067ULL,
0x00000018ff2e7819ULL, 0x000fc4000001142eULL, 0x00000018ff827819ULL, 0x000fe2000001142fULL,
0x0000008700877306ULL, 0x000ee20000202400ULL, 0x0000541069697816ULL, 0x010fe4000000007eULL,
0x0000541089667816ULL, 0x000fca0000000066ULL, 0x0000004c004f7306ULL, 0x0009e40000202400ULL,
0x000000663410723cULL, 0x002fe20000041810ULL, 0x000054106a6a7816ULL, 0x008fca0000000087ULL,
0x0000006f006f7306ULL, 0x000fe20000202400ULL, 0x000001002d4c7824ULL, 0x010fe200078e00ffULL,
0x000000665c3c723cULL, 0x004fe8000004183cULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000073002d7306ULL, 0x000ff00000202400ULL, 0x0000004c004c7306ULL, 0x000e700000202400ULL,
0x0000006c006c7306ULL, 0x000ea20000202400ULL, 0x000054106f6f7816ULL, 0x002fce000000004cULL,
0x0000006d006d7306ULL, 0x000fe20000202400ULL, 0x000000107b4c7824ULL, 0x000fe200078e0270ULL,
0x000054104f6c7816ULL, 0x004fcc000000006cULL, 0x0000008000807306ULL, 0x000ff00000202400ULL,
0x0000007100717306ULL, 0x000ff00000202400ULL, 0x0000006800687306ULL, 0x000ff00000202400ULL,
0x0000008b008b7306ULL, 0x000e700000202400ULL, 0x0000006b006b7306ULL, 0x000fe20000202400ULL,
0x0000541068687816ULL, 0x002fce000000008bULL, 0x0000008400847306ULL, 0x000e620000202400ULL,
0x00000068340c723cULL, 0x000fee000004180cULL, 0x0000004e004e7306ULL, 0x000ea20000202400ULL,
0x000000685c54723cULL, 0x000fe20000041854ULL, 0x000054106b6b7816ULL, 0x002fcc0000000084ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x0000006a3414723cULL, 0x000fe20000041814ULL,
0x000054104e6d7816ULL, 0x004fcc000000006dULL, 0x0000004d004d7306ULL, 0x000e620000202400ULL,
0x0000006a5c40723cULL, 0x000fee0000041840ULL, 0x0000002c002c7306ULL, 0x000ea20000202400ULL,
0x0000006c3418723cULL, 0x000fe20000041818ULL, 0x000054106e6e7816ULL, 0x002fcc000000004dULL,
0x0000007200727306ULL, 0x000fe20000202400ULL, 0x0000006c5c44723cULL, 0x000fe20000041844ULL,
0x000000004c4c783bULL, 0x000e620000000200ULL, 0x000054102c717816ULL, 0x004fca0000000071ULL,
0x0000008500857306ULL, 0x000ea20000202400ULL, 0x0000006e341c723cULL, 0x000fec000004181cULL,
0x0000006e5c48723cULL, 0x000fe20000041848ULL, 0x0000008600737306ULL, 0x000fe20000202400ULL,
0x0000541072727816ULL, 0x004fce0000000085ULL, 0x00000088007e7306ULL, 0x000eb00000202400ULL,
0x0000007400747306ULL, 0x000fe20000202400ULL, 0x0000541073737816ULL, 0x004fce000000007eULL,
0x0000007a007a7306ULL, 0x000fe20000202400ULL, 0x000000723430723cULL, 0x000fee0000041830ULL,
0x0000002e00877306ULL, 0x0004e20000202400ULL, 0x000000725c28723cULL, 0x000fee0000041828ULL,
0x0000008200897306ULL, 0x000f220000202400ULL, 0x00000010752e7824ULL, 0x004fe200078e0270ULL,
0x000054102d707816ULL, 0x000fc40000000080ULL, 0x0000541087747816ULL, 0x008fc60000000074ULL,
0x000000002e2c783bULL, 0x000ea40000000200ULL, 0x000000703420723cULL, 0x000fe20000041820ULL,
0x0000541089757816ULL, 0x010fca000000007aULL, 0x000000705c50723cULL, 0x000fec0000041850ULL,
0x000000745c24723cULL, 0x000fec0000041824ULL, 0x000000743434723cULL, 0x000fe20000041838ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000200947ULL, 0x002fde0003800000ULL,
0x000000034c4c7232ULL, 0x080fe40000200000ULL, 0x000000034e4e7232ULL, 0x000fe40000200000ULL,
0x000000024d4d7232ULL, 0x080fe40000200000ULL, 0x000000024f4f7232ULL, 0x000fe40000200000ULL,
0x000000052c2c7232ULL, 0x084fe40000200000ULL, 0x000000052e2e7232ULL, 0x000fc40000200000ULL,
0x000000002d2d7232ULL, 0x080fe40000200000ULL, 0x000000002f2f7232ULL, 0x000fce0000200000ULL,
0x00000010785c7824ULL, 0x000fe400078e027fULL, 0x0000000176837824ULL, 0x000fe400078e0283ULL,
0x0000000158587836ULL, 0x000fe40000000000ULL, 0x000000005c5c783bULL, 0x000e640000004200ULL,
0x000001005c387824ULL, 0x042fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe2000001145cULL,
0x000001005d397824ULL, 0x000fe200078e00ffULL, 0x000088805c6b7816ULL, 0x040fe200000000ffULL,
0x000100005c5c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011438ULL,
0x0000000876387824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001145eULL,
0x000001005e667824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x0000006b006b7306ULL, 0x000fe20000202400ULL, 0xfffffff838387812ULL, 0x000fc400078ee283ULL,
0x00000018ff837819ULL, 0x000fe40000011439ULL, 0x000088805e747816ULL, 0x000fe200000000ffULL,
0x0000001038387824ULL, 0x000fe200078e027fULL, 0x000088805d7e7816ULL, 0x000fe200000000ffULL,
0x0000005c007f7306ULL, 0x0003e20000202400ULL, 0x000100005e5e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001145fULL, 0x000000003838783bULL, 0x000ee20000004200ULL,
0x000088805f757816ULL, 0x000fc400000000ffULL, 0x00000018ff717819ULL, 0x000fe2000001145dULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x000001005f5c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x000100005f5f7824ULL, 0x000fe200078e00ffULL, 0x0000007800787306ULL, 0x000e620000202400ULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x00000018ff737819ULL, 0x000fc6000001145fULL, 0x0000007e007e7306ULL, 0x000ff00000202400ULL,
0x0000008300837306ULL, 0x000f300000202400ULL, 0x0000005c00767306ULL, 0x000fe20000202400ULL,
0x00000018ff677819ULL, 0x008fce000001143aULL, 0x00000066007b7306ULL, 0x0007e20000202400ULL,
0x00000018ff5f7819ULL, 0x000fe20000011438ULL, 0x000001003a807824ULL, 0x000fe200078e00ffULL,
0x00008880386a7816ULL, 0x000fe400000000ffULL, 0x0000888039697816ULL, 0x000fc600000000ffULL,
0x0000005e00727306ULL, 0x000be20000202400ULL, 0x00000018ff667819ULL, 0x008fce0000011439ULL,
0x00000067005c7306ULL, 0x0007e20000202400ULL, 0x00000100385e7824ULL, 0x064fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x0000007000707306ULL, 0x000ea20000202400ULL, 0x0000010039677824ULL, 0x048fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe40000011467ULL, 0x0000007100717306ULL, 0x000fe20000202400ULL,
0x00000018ff397819ULL, 0x000fce0000011439ULL, 0x0000005d007a7306ULL, 0x0007700000202400ULL,
0x0000003800687306ULL, 0x0003e20000202400ULL, 0x00000018ff5d7819ULL, 0x008fce000001143bULL,
0x0000003900677306ULL, 0x0009e20000202400ULL, 0x000054106b387816ULL, 0x002fe20000000078ULL,
0x000001003b787824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fc80000011480ULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000007400747306ULL, 0x000e620000202400ULL,
0x000054107e397816ULL, 0x010fce0000000083ULL, 0x000000384c54723cULL, 0x000fe20000041854ULL,
0x0000007500757306ULL, 0x000eea0000202400ULL, 0x000000382c0c723cULL, 0x000fe6000004180cULL,
0x0000005e006d7306ULL, 0x0009e80000202400ULL, 0x000054107f387816ULL, 0x004fc40000000070ULL,
0x000054107a397816ULL, 0x020fe40000000071ULL, 0x000088803b707816ULL, 0x040fe200000000ffULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x000088803a5e7816ULL, 0x050fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe400078e00ffULL, 0x000000384c3c723cULL, 0x000fe6000004183cULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0000006900697306ULL, 0x000fe40000202400ULL,
0x000000382c10723cULL, 0x000fec0000041810ULL, 0x0000006c006c7306ULL, 0x000fe20000202400ULL,
0x0000541074387816ULL, 0x002fe2000000007bULL, 0x000100003b747824ULL, 0x000fe200078e00ffULL,
0x0000541075397816ULL, 0x008fc80000000076ULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000005f005f7306ULL, 0x000e640000202400ULL, 0x000000384c40723cULL, 0x000fec0000041840ULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x000000382c14723cULL, 0x000fe20000041814ULL,
0x0000541068687816ULL, 0x002fcc000000005fULL, 0x00000078003b7306ULL, 0x000e620000202400ULL,
0x000054106a387816ULL, 0x000fe4000000006dULL, 0x0000541069397816ULL, 0x000fca000000006cULL,
0x0000006f006f7306ULL, 0x000ea40000202400ULL, 0x000000384c48723cULL, 0x000fe20000041848ULL,
0x00005410705f7816ULL, 0x002fca000000003bULL, 0x0000006e006e7306ULL, 0x000fe20000202400ULL,
0x00000001ff3b7424ULL, 0x000fe200078e00ffULL, 0x000000382c1c723cULL, 0x000fe6000004181cULL,
0x0000003b063879a7ULL, 0x0002e2000850003fULL, 0x0000541072727816ULL, 0x004fe4000000006fULL,
0x0000007300737306ULL, 0x000ea20000202400ULL, 0x0000000859067824ULL, 0x002fce00078e0208ULL,
0x0000006600667306ULL, 0x000e620000202400ULL, 0x01a6a03b06ff79a7ULL, 0x0007e2000850003fULL,
0x0000541073737816ULL, 0x004fcc000000006eULL, 0x0000005e005e7306ULL, 0x000fe20000202400ULL,
0x000000722c18723cULL, 0x000fe20000041818ULL, 0x0000541067697816ULL, 0x002fcc0000000066ULL,
0x0000006b006b7306ULL, 0x000e620000202400ULL, 0x000000724c44723cULL, 0x000fee0000041844ULL,
0x0000005d005d7306ULL, 0x000fe20000202400ULL, 0x000000682c20723cULL, 0x000fe20000041820ULL,
0x000054105e5e7816ULL, 0x002fcc000000006bULL, 0x0000003a00717306ULL, 0x000e620000202400ULL,
0x000000684c50723cULL, 0x000fec0000041850ULL, 0x0000005e2c30723cULL, 0x000fe20000041830ULL,
0x0000007400747306ULL, 0x000eaa0000202400ULL, 0x0000005e4c28723cULL, 0x000fe20000041828ULL,
0x00005410715c7816ULL, 0x002fc4000000005cULL, 0x00005410745d7816ULL, 0x004fce000000005dULL,
0x0000005c4c24723cULL, 0x000fec0000041824ULL, 0x0000005c2c2c723cULL, 0x000fe20000041834ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffff6000989947ULL, 0x008fde000383ffffULL,
0x000000ff6000720cULL, 0x000fe20003f05270ULL, 0x000000ffff377224ULL, 0x000fe400078e0041ULL,
0x000000ffff357224ULL, 0x000fe400078e0040ULL, 0x000000ffff097224ULL, 0x000fd000078e003cULL,
0x0000000400648947ULL, 0x000fea0003800000ULL, 0x018000007d007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000be8000047802ULL, 0x000fce0000000f00ULL, 0x000000b000107944ULL, 0x006fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000007d00007308ULL, 0x000ee40000001000ULL,
0xbf80000000027423ULL, 0x00afc8000000007dULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009800ff027b82ULL, 0x000f240000000a00ULL, 0x0000000602037981ULL, 0x010f22000c1e9900ULL,
0x0000000000057919ULL, 0x000f640000000000ULL, 0x0000001805077811ULL, 0x062fe400078ff0ffULL,
0x00000002ff397819ULL, 0x000fe40000011605ULL, 0x00000008053b7811ULL, 0x040fe400078ff0ffULL,
0x0000001005417811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x01cfca0000410000ULL,
0x00001f3900047589ULL, 0x000e6800000e0000ULL, 0x00001f3b00067589ULL, 0x000ea800000e0000ULL,
0x00001f4100057589ULL, 0x000ee800000e0000ULL, 0x00001f0700077589ULL, 0x000f2200000e0000ULL,
0x0000005404547220ULL, 0x042fe20000410000ULL, 0x0000005504557220ULL, 0x040fe20000410000ULL,
0x0000000904097220ULL, 0x040fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000004404447220ULL, 0x040fe20000410000ULL, 0x0000004504457220ULL, 0x040fe20000410000ULL,
0x0000004804487220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000005004507220ULL, 0x040fe20000410000ULL, 0x0000005104517220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000005606567220ULL, 0x044fe20000410000ULL, 0x0000005706577220ULL, 0x040fe20000410000ULL,
0x0000003e063e7220ULL, 0x040fe20000410000ULL, 0x0000003f063f7220ULL, 0x040fe20000410000ULL,
0x0000004206427220ULL, 0x040fe20000410000ULL, 0x0000004306437220ULL, 0x040fe20000410000ULL,
0x0000004606467220ULL, 0x040fe20000410000ULL, 0x0000004706477220ULL, 0x040fe20000410000ULL,
0x0000004a064a7220ULL, 0x040fe20000410000ULL, 0x0000004b064b7220ULL, 0x040fe20000410000ULL,
0x0000005206527220ULL, 0x040fe20000410000ULL, 0x0000005306537220ULL, 0x040fe20000410000ULL,
0x0000002a062a7220ULL, 0x040fe20000410000ULL, 0x0000002b062b7220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002706277220ULL, 0x000fe20000410000ULL,
0x0000000c050c7220ULL, 0x048fe20000410000ULL, 0x0000000d050d7220ULL, 0x040fe20000410000ULL,
0x0000001005107220ULL, 0x040fe20000410000ULL, 0x0000001105117220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000001505157220ULL, 0x040fe20000410000ULL,
0x0000001805187220ULL, 0x040fe20000410000ULL, 0x0000001905197220ULL, 0x040fe20000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000001d051d7220ULL, 0x040fe20000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x0000003005307220ULL, 0x040fe20000410000ULL, 0x0000003105317220ULL, 0x040fe20000410000ULL,
0x0000002c052c7220ULL, 0x040fe20000410000ULL, 0x0000002d052d7220ULL, 0x000fe20000410000ULL,
0x0000000e070e7220ULL, 0x050fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001607167220ULL, 0x040fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x0000200065087824ULL, 0x000fe200078e0208ULL,
0x000000484948723eULL, 0x000fe400000010ffULL, 0x000000505150723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000282928723eULL, 0x000fc400000010ffULL,
0x000000242524723eULL, 0x000fe400000010ffULL, 0x000000565757723eULL, 0x000fe400000010ffULL,
0x0000003e3f3e723eULL, 0x000fe400000010ffULL, 0x000000424342723eULL, 0x000fe400000010ffULL,
0x000000464746723eULL, 0x000fe400000010ffULL, 0x0000541057567816ULL, 0x000fc4000000003eULL,
0x0000763257577816ULL, 0x000fe4000000003eULL, 0x0000004a4b4a723eULL, 0x000fe400000010ffULL,
0x000000525325723eULL, 0x000fe400000010ffULL, 0x0000002a2b2a723eULL, 0x000fe200000010ffULL,
0x000000015b5b7824ULL, 0x008fe200078e0200ULL, 0x0000000800037811ULL, 0x042fe400078ff0ffULL,
0x0000000200027812ULL, 0x040fe200078ec0ffULL, 0x000000105b5b7824ULL, 0x000fe200078e0208ULL,
0x00000002ff077819ULL, 0x000fe20000011600ULL, 0x0000000803417824ULL, 0x000fe200078e00ffULL,
0x0000001000397811ULL, 0x000fc400078ff0ffULL, 0x00000018003b7811ULL, 0x000fe200078ff0ffULL,
0x0000000807347824ULL, 0x000fe200078e00ffULL, 0x0000000302047211ULL, 0x040fe200078ff8ffULL,
0x00000008393a7824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x040fe200078ff8ffULL,
0x0000000807367824ULL, 0x000fe200078e00ffULL, 0x0000003b02067211ULL, 0x040fe200078ff8ffULL,
0x000000083b3b7824ULL, 0x000fe200078e00ffULL, 0x0000003902057211ULL, 0x000fe200078ff8ffULL,
0x0000000807397824ULL, 0x040fe200078e00ffULL, 0xfffffff841387812ULL, 0x000fe200078ee204ULL,
0x0000000203027836ULL, 0x000fe20000000000ULL, 0xfffffff83b3c7812ULL, 0x000fe200078ee206ULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee205ULL,
0x0000000403057836ULL, 0x000fe20000000000ULL, 0xfffffff839067812ULL, 0x000fe200078ee202ULL,
0x0000000807027824ULL, 0x000fe200078e00ffULL, 0x000000262726723eULL, 0x000fe200000010ffULL,
0x0000000603077836ULL, 0x000fe20000000000ULL, 0xfffffff834347812ULL, 0x000fc400078ee205ULL,
0xfffffff802027812ULL, 0x000fe200078ee203ULL, 0x0000100061037824ULL, 0x000fe200078e0208ULL,
0xfffffff836367812ULL, 0x000fe400078ee207ULL, 0x0000000804057812ULL, 0x000fe200078ec0ffULL,
0x0000001002047824ULL, 0x100fe200078e0203ULL, 0x000000545502723eULL, 0x000fe200000010ffULL,
0x0000001038387824ULL, 0x100fe200078e0203ULL, 0x0000000c0d0c723eULL, 0x000fe200000010ffULL,
0x000000103a3a7824ULL, 0x100fe200078e0203ULL, 0x000000141514723eULL, 0x000fe200000010ffULL,
0x000000103c3c7824ULL, 0x100fe200078e0203ULL, 0x000000181918723eULL, 0x000fe200000010ffULL,
0x0000001006067824ULL, 0x100fe200078e0203ULL, 0x0000001c1d1c723eULL, 0x000fe200000010ffULL,
0x0000001034347824ULL, 0x100fe200078e0203ULL, 0x000000202120723eULL, 0x000fe200000010ffULL,
0x0000001036367824ULL, 0x000fe200078e0203ULL, 0x000000093d03723eULL, 0x000fe200000010ffULL,
0x0000000104047824ULL, 0x000fe200078e0205ULL, 0x000000303130723eULL, 0x000fe200000010ffULL,
0x0000000105387824ULL, 0x040fe200078e0238ULL, 0x0000541002407816ULL, 0x140fe20000000003ULL,
0x00000001053a7824ULL, 0x040fe200078e023aULL, 0x0000763202417816ULL, 0x000fe20000000003ULL,
0x00000001053c7824ULL, 0x000fe200078e023cULL, 0x000000353702723eULL, 0x000fe200000010ffULL,
0x0000000105097824ULL, 0x000fe200078e0206ULL, 0x000000444503723eULL, 0x000fe200000010ffULL,
0x0000004004007388ULL, 0x0003e20000000a00ULL, 0x0000000105347824ULL, 0x000fe200078e0234ULL,
0x000000101106723eULL, 0x000fe200000010ffULL, 0x0000000105367824ULL, 0x000fe200078e0236ULL,
0x0000763202057816ULL, 0x000fc40000000003ULL, 0x0000000e0f0e723eULL, 0x000fe400000010ffULL,
0x000000121307723eULL, 0x000fe400000010ffULL, 0x000000161716723eULL, 0x000fe400000010ffULL,
0x0000541002047816ULL, 0x002fe40000000003ULL, 0x0000541048027816ULL, 0x140fe40000000050ULL,
0x0000763248037816ULL, 0x000fe20000000050ULL, 0x0000000409007388ULL, 0x000fe20000000a00ULL,
0x0000001a1b1a723eULL, 0x000fc400000010ffULL, 0x0000001e1f1e723eULL, 0x000fe200000010ffULL,
0x0000000234007388ULL, 0x0003e20000000a00ULL, 0x00000022230f723eULL, 0x000fe400000010ffULL,
0x000000323332723eULL, 0x000fe400000010ffULL, 0x0000002e2f19723eULL, 0x000fe400000010ffULL,
0x000000ff6100720cULL, 0x000fe40003f05270ULL, 0x0000763232297816ULL, 0x000fc40000000019ULL,
0x0000541028027816ULL, 0x142fe40000000024ULL, 0x0000763228037816ULL, 0x000fe40000000024ULL,
0x000054104a247816ULL, 0x140fe40000000025ULL, 0x000076324a257816ULL, 0x000fe20000000025ULL,
0x0000000236007388ULL, 0x0003e20000000a00ULL, 0x0000541032287816ULL, 0x000fc60000000019ULL,
0x0000005638007388ULL, 0x000fe20000000a00ULL, 0x0000541042027816ULL, 0x142fe40000000046ULL,
0x0000763242037816ULL, 0x000fca0000000046ULL, 0x0004000209007388ULL, 0x0003e80000000a00ULL,
0x0004002434007388ULL, 0x000fe20000000a00ULL, 0x000054102a027816ULL, 0x142fe40000000026ULL,
0x000076322a037816ULL, 0x000fca0000000026ULL, 0x0004000236007388ULL, 0x0003e40000000a00ULL,
0x000054100c027816ULL, 0x142fe40000000006ULL, 0x000076320c037816ULL, 0x000fe40000000006ULL,
0x000054100e067816ULL, 0x140fe40000000007ULL, 0x000076320e077816ULL, 0x000fe20000000007ULL,
0x000000023a007388ULL, 0x0003e40000000a00ULL, 0x0000541014027816ULL, 0x002fc40000000018ULL,
0x0000763214037816ULL, 0x000fe40000000018ULL, 0x0000002c2d18723eULL, 0x000fc600000010ffULL,
0x0008000209007388ULL, 0x0003e40000000a00ULL, 0x000054101c027816ULL, 0x142fe40000000020ULL,
0x000076321c037816ULL, 0x000fca0000000020ULL, 0x0008000234007388ULL, 0x0003e40000000a00ULL,
0x0000541030027816ULL, 0x142fe40000000018ULL, 0x0000763230037816ULL, 0x000fca0000000018ULL,
0x0008000236007388ULL, 0x0003e80000000a00ULL, 0x000000063c007388ULL, 0x000fe20000000a00ULL,
0x0000541016027816ULL, 0x142fe4000000001aULL, 0x0000763216037816ULL, 0x000fca000000001aULL,
0x000c000209007388ULL, 0x0003e40000000a00ULL, 0x000054101e027816ULL, 0x142fe4000000000fULL,
0x000076321e037816ULL, 0x000fca000000000fULL, 0x000c000234007388ULL, 0x0003e80000000a00ULL,
0x000c002836007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff00027306ULL, 0x002e620000202400ULL, 0x000000005b047984ULL, 0x000e680000000c00ULL,
0x000400005b107984ULL, 0x000ee80000000c00ULL, 0x000800005b187984ULL, 0x000f280000000c00ULL,
0x000c00005b207984ULL, 0x000f680000000c00ULL, 0x001000005b0c7984ULL, 0x000f280000000c00ULL,
0x001400005b147984ULL, 0x000f680000000c00ULL, 0x001800005b1c7984ULL, 0x000f680000000c00ULL,
0x001c00005b247984ULL, 0x000f620000000c00ULL, 0x0000000702077230ULL, 0x002fc40000200800ULL,
0x0000000602067230ULL, 0x040fe40000200800ULL, 0x0000000502057230ULL, 0x040fe40000200800ULL,
0x0000000402047230ULL, 0x040fe40000200800ULL, 0x0000001302137230ULL, 0x048fe40000200800ULL,
0x0000001202127230ULL, 0x040fe40000200800ULL, 0x0000001102117230ULL, 0x000fc40000200800ULL,
0x0000001002107230ULL, 0x040fe40000200800ULL, 0x0000001b021b7230ULL, 0x050fe40000200800ULL,
0x0000001a021a7230ULL, 0x040fe40000200800ULL, 0x0000001902197230ULL, 0x040fe40000200800ULL,
0x0000001802187230ULL, 0x040fe40000200800ULL, 0x0000002302237230ULL, 0x024fc40000200800ULL,
0x0000002202227230ULL, 0x040fe40000200800ULL, 0x0000002102217230ULL, 0x040fe40000200800ULL,
0x0000002002027230ULL, 0x000fe40000200800ULL, 0x0000000f07077230ULL, 0x000fe40000200000ULL,
0x0000000e06067230ULL, 0x000fe40000200000ULL, 0x0000000d05057230ULL, 0x000fc40000200000ULL,
0x0000000c04047230ULL, 0x000fe40000200000ULL, 0x0000001713137230ULL, 0x000fe40000200000ULL,
0x0000001612127230ULL, 0x000fe20000200000ULL, 0x000000045b007388ULL, 0x0003e20000000c00ULL,
0x0000001511117230ULL, 0x000fe40000200000ULL, 0x0000001410107230ULL, 0x000fe40000200000ULL,
0x0000001f1b1b7230ULL, 0x000fc40000200000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000200000ULL,
0x000400105b007388ULL, 0x0003e20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000200000ULL,
0x0000001c18187230ULL, 0x000fe40000200000ULL, 0x0000002723237230ULL, 0x000fe40000200000ULL,
0x0000002622227230ULL, 0x000fe20000200000ULL, 0x000800185b007388ULL, 0x0003e20000000c00ULL,
0x0000002521217230ULL, 0x000fc40000200000ULL, 0x0000002402207230ULL, 0x000fca0000200000ULL,
0x000c00205b007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fc80000011600ULL,
0x0000000b0900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x0000000164047824ULL, 0x002fe200078e0209ULL,
0x0000000800067d06ULL, 0x000e620008209000ULL, 0x0000850000097ab9ULL, 0x000fe20000000800ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000700127812ULL, 0x000fca00078ec0ffULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe06027836ULL, 0x002fcc0000000000ULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000000805057c24ULL, 0x000fc8000f8e02ffULL,
0x0000000503037227ULL, 0x000fc800078e0002ULL, 0x0000000109027824ULL, 0x000fe400078e0200ULL,
0x0000000403077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf06070ULL,
0x8000000805050c36ULL, 0x000fe40008000000ULL, 0x0000000107070836ULL, 0x000fe20000000000ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05070ULL, 0x0000000805007c0cULL, 0x000fe4000bf26070ULL,
0x0000000702057812ULL, 0x000fe400078ec0ffULL, 0x00000008ff027c12ULL, 0x000fe4000f8e33ffULL,
0x0ffffff805057812ULL, 0x000fca00078ef800ULL, 0x0000001005067824ULL, 0x000fe400078e0208ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x00000000060c7984ULL, 0x0002a40000000c00ULL,
0x0000000702107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000002000067836ULL, 0x002fe40000000000ULL, 0x0000000805057c24ULL, 0x000fe4000f8e0204ULL,
0x0000000865077824ULL, 0x000fe200078e0212ULL, 0x00000003ff097819ULL, 0x000fc40000011606ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4410ULL,
0x0000000b0900720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000164047824ULL, 0x102fe400078e0209ULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x0000000403057227ULL, 0x000fc600078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff809097812ULL, 0x000fe200078ef806ULL,
0x0000000807077c24ULL, 0x000fe2000f8e0204ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e0208ULL, 0x0000000807007c0cULL, 0x000fc8000bf26070ULL,
0x00000000090c7984ULL, 0x0002a40000000c00ULL, 0x0000004000097836ULL, 0x002fce0000000000ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x0000000502107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000000865077824ULL, 0x000fe200078e0206ULL, 0x00000003ff067819ULL, 0x000fe20000011609ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4410ULL, 0x0000000b0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000164047824ULL, 0x102fe400078e0206ULL,
0x0000000109067824ULL, 0x000fe400078e0206ULL, 0x0000000403077227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x8000000805051c36ULL, 0x000fe40008000000ULL, 0x0000000107071836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef809ULL,
0x0000001005067824ULL, 0x000fca00078e0208ULL, 0x00000000060c7984ULL, 0x0002a20000000c00ULL,
0x0000000107072836ULL, 0x000fca0000000000ULL, 0x0000000702107207ULL, 0x000fe20004000000ULL,
0x0000006000067836ULL, 0x002fc80000000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe2000f8e0279ULL, 0x0000000709107812ULL, 0x000fe200078ec0ffULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x00000003ff097819ULL, 0x000fc60000011606ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000865077824ULL, 0x000fc600078e0210ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4412ULL,
0x0000000b0900720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000164047824ULL, 0x102fe400078e0209ULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x0000000403057227ULL, 0x000fc600078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff809097812ULL, 0x000fe200078ef806ULL,
0x0000000807077c24ULL, 0x000fe2000f8e0204ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e0208ULL, 0x0000000807007c0cULL, 0x000fc8000bf26070ULL,
0x00000000090c7984ULL, 0x0002a40000000c00ULL, 0x0000008000097836ULL, 0x002fce0000000000ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x0000000502107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000000865077824ULL, 0x000fe200078e0206ULL, 0x00000003ff067819ULL, 0x000fe20000011609ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4410ULL, 0x0000000b0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000164047824ULL, 0x102fe400078e0206ULL,
0x0000000109067824ULL, 0x000fe400078e0206ULL, 0x0000000403077227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x8000000805051c36ULL, 0x000fe40008000000ULL, 0x0000000107071836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef809ULL,
0x0000001005067824ULL, 0x000fca00078e0208ULL, 0x00000000060c7984ULL, 0x0002a20000000c00ULL,
0x0000000107072836ULL, 0x000fca0000000000ULL, 0x0000000702107207ULL, 0x000fe20004000000ULL,
0x000000a000067836ULL, 0x002fc80000000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe2000f8e0279ULL, 0x0000000709107812ULL, 0x000fe200078ec0ffULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x00000003ff097819ULL, 0x000fc60000011606ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000865077824ULL, 0x000fc600078e0210ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4412ULL,
0x0000000b0900720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000164047824ULL, 0x102fe400078e0209ULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x0000000403057227ULL, 0x000fc600078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff809097812ULL, 0x000fe200078ef806ULL,
0x0000000807077c24ULL, 0x000fe2000f8e0204ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e0208ULL, 0x0000000807007c0cULL, 0x000fc8000bf26070ULL,
0x00000000090c7984ULL, 0x0002a40000000c00ULL, 0x000000c000097836ULL, 0x002fce0000000000ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x0000000502107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000000865077824ULL, 0x000fe200078e0206ULL, 0x00000003ff067819ULL, 0x000fe20000011609ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4410ULL, 0x0000000b0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000164047824ULL, 0x102fe400078e0206ULL,
0x0000000109067824ULL, 0x000fe400078e0206ULL, 0x0000000403077227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a07ULL,
0x000000e000007836ULL, 0x000fe40000000000ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x8000000805051c36ULL, 0x000fe40008000000ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef809ULL, 0x0000001005067824ULL, 0x000fca00078e0208ULL,
0x00000000060c7984ULL, 0x000e620000000c00ULL, 0x0000000107072836ULL, 0x000fca0000000000ULL,
0x0000000702107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe2000f8e0279ULL, 0x0000000709107812ULL, 0x000fe200078ec0ffULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x00000003ff097819ULL, 0x000fc60000011600ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000865077824ULL, 0x000fe400078e0210ULL,
0x0000000164647824ULL, 0x000fe200078e0209ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4412ULL, 0x0000000b0900720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0023ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000006403037227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x002fe400078e0a03ULL, 0x0000000100097824ULL, 0x000fe400078e0209ULL,
0x0000000805047c24ULL, 0x000fc6000f8e0264ULL, 0x0000000709097812ULL, 0x000fe400078ec0ffULL,
0x0000000804007c0cULL, 0x000fe4000bf26070ULL, 0xfffffff809097812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001009097824ULL, 0x000fe400078e0208ULL,
0x0000000865657824ULL, 0x000fc800078e0200ULL, 0x8000000804041c36ULL, 0x000fe40008000000ULL,
0x0000000103031836ULL, 0x000fc60000000000ULL, 0x0000000804007c0cULL, 0x000fe4000bf46070ULL,
0x0000000009047984ULL, 0x000e760000000c00ULL, 0x0000000103032836ULL, 0x000fca0000000000ULL,
0x0000000302027207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a02ULL,
0x0000000902037c24ULL, 0x000fe4000f8e0279ULL, 0x000000080b647c24ULL, 0x000fc8000f8e0264ULL,
0x0000000803037c24ULL, 0x000fca000f8e0264ULL, 0x000000030a037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000403027c11ULL, 0x000fc8000f8040ffULL,
0x0000000503037c11ULL, 0x000fc600080f4408ULL, 0x0000001065027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00009800ff5e7b82ULL, 0x000e620000000a00ULL, 0x000001ff0700780cULL, 0x000fe20003f04070ULL,
0x0000000206067824ULL, 0x000fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x00000001ff057424ULL, 0x000fe200078e00ffULL, 0x0000940000057ab9ULL, 0x000fe20000000800ULL,
0x000000065e5e7981ULL, 0x002322000c1e9900ULL, 0x0000001f04047890ULL, 0x000fe2000fffe03fULL,
0x0000004077767824ULL, 0x000fe400078e00ffULL, 0x01a60005080479a7ULL, 0x0002a2000850003fULL,
0x0000000c06797224ULL, 0x000fe200078e0279ULL, 0x000000053f047899ULL, 0x000fc60008011604ULL,
0x0000000579067c24ULL, 0x000fe2000f8e0276ULL, 0x0000000c00240947ULL, 0x000ff00003800000ULL,
0x00000003ff2c7819ULL, 0x000fe20000011609ULL, 0x0000900000087ab9ULL, 0x000fe20000000a00ULL,
0x0000007662077248ULL, 0x000fc60007fe0000ULL, 0x000000042c0c7836ULL, 0x000fe40000000000ULL,
0x000000082c127836ULL, 0x000fe40000000000ULL, 0x000000010c0a7824ULL, 0x140fe400078e0209ULL,
0x000000080c1f7824ULL, 0x000fe400078e00ffULL, 0x00000001120b7824ULL, 0x040fe400078e0209ULL,
0x00000008120e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20aULL,
0x00000001060a7824ULL, 0x000fc400078e022cULL, 0x0000000107077824ULL, 0x000fe200078e0a76ULL,
0xfffffff80e237812ULL, 0x000fe200078ee20bULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0x000000070c00720cULL, 0x000fe20003fa6070ULL, 0x000000102c107836ULL, 0x000fe20000000000ULL,
0x000000700a147812ULL, 0x000fe200078ef800ULL, 0x00000001060c7824ULL, 0x000fe400078e020cULL,
0x00000001100a7824ULL, 0x040fe200078e0209ULL, 0x0000000814147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000810277824ULL, 0x000fe400078e00ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000090b157c10ULL, 0x000fc400087fe4ffULL, 0xfffffff827277812ULL, 0x000fe200078ee20aULL,
0x0000000c2c187836ULL, 0x000fe20000000000ULL, 0x000000700c167812ULL, 0x000fe200078ef800ULL,
0x00000001060a7824ULL, 0x000fe200078e0212ULL, 0x000000071000720cULL, 0x080fe20003f06070ULL,
0x00000001180e7824ULL, 0x040fe200078e0209ULL, 0x0000000816167c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000818257824ULL, 0x040fe200078e00ffULL, 0x000000071800720cULL, 0x000fe20003f46070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000090d177c10ULL, 0x000fc40008ffe4ffULL,
0xfffffff825257812ULL, 0x000fe200078ee20eULL, 0x00000001060c7824ULL, 0x040fe200078e0218ULL,
0x000000700a187812ULL, 0x000fe200078ef800ULL, 0x00000001060e7824ULL, 0x000fe200078e0210ULL,
0x000000071200720cULL, 0x000fe20003f26070ULL, 0x000000142c1c7836ULL, 0x000fe20000000000ULL,
0x0000000818187c10ULL, 0x000fe2000ff7e0ffULL, 0x000000182c1e7836ULL, 0x000fe40000000000ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000090b197c10ULL, 0x000fc60009ffe4ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c1a7812ULL, 0x000fc600078ef800ULL,
0x0000000106107824ULL, 0x040fe200078e021cULL, 0x000000700e0c7812ULL, 0x000fe200078ef800ULL,
0x0000000106127824ULL, 0x000fe200078e021eULL, 0x000000081a1a7c10ULL, 0x000fe2000ff9e0ffULL,
0x0000001c2c227836ULL, 0x000fe20000000000ULL, 0x000000080c0c7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000090d1b7c10ULL, 0x000fe4000a7fe4ffULL,
0x000000090f0d7c10ULL, 0x000fe20009ffe4ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x00000070100e7812ULL, 0x000fc600078ef800ULL, 0x00004000770a7824ULL, 0x000fe200078e0208ULL,
0x0000007012127812ULL, 0x000fe200078ef800ULL, 0x00000001060b7824ULL, 0x000fe200078e0222ULL,
0x000000080e0e7c10ULL, 0x000fe2000ff7e0ffULL, 0x000020000a207836ULL, 0x000fe20000000000ULL,
0x0000000812127c10ULL, 0x000fe2000ff9e0ffULL, 0x000000012c107824ULL, 0x100fe200078e0209ULL,
0x00000009110f7c10ULL, 0x000fe20009ffe4ffULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000000913137c10ULL, 0x000fe4000a7fe4ffULL, 0x0000000710107812ULL, 0x000fe200078ec0ffULL,
0x000000202c247836ULL, 0x000fe20000000000ULL, 0x000000700a1d7812ULL, 0x000fe200078ef800ULL,
0x000000011c0a7824ULL, 0x000fe200078e0209ULL, 0x000000072c00720cULL, 0x080fe20003f86070ULL,
0x000000081c297824ULL, 0x040fe200078e00ffULL, 0x000000071c00720cULL, 0x000fe20003f66070ULL,
0x000000242c267836ULL, 0x000fe20000000000ULL, 0x0ffffff810217812ULL, 0x000fe200078ef809ULL,
0x0000000106107824ULL, 0x000fe200078e0224ULL, 0x000000081d1c7c10ULL, 0x000fe2000ffde0ffULL,
0x000000081e2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee20aULL,
0x0000001021217824ULL, 0x000fe200078e0220ULL, 0x000000090b1d7c10ULL, 0x000fe2000b7fe4ffULL,
0x00000080100a7825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014217faeULL, 0x0007e2000e101c46ULL, 0x0000000106107824ULL, 0x000fe200078e0226ULL,
0x000000700a117812ULL, 0x000fe200078ef800ULL, 0x000000011e0a7824ULL, 0x040fe200078e0209ULL,
0x000000071e00720cULL, 0x000fe20003f86070ULL, 0x000000282c287836ULL, 0x000fe20000000000ULL,
0x00000008111e7c10ULL, 0x000fe2000ffde0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fc600078ee20aULL, 0x00000008222d7824ULL, 0x040fe200078e00ffULL,
0x0000007010147812ULL, 0x008fe200078ef800ULL, 0x000000101f217824ULL, 0x000fe200078e0220ULL,
0x000000090b1f7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000122107824ULL, 0x000fe200078e0209ULL,
0x0000000814147c10ULL, 0x000fe2000ffde0ffULL, 0x00000001062a7824ULL, 0x000fe200078e0228ULL,
0x0000000016217faeULL, 0x0007e2000e901c46ULL, 0x000000072200720cULL, 0x000fe20003fa6070ULL,
0x0000002c2c227836ULL, 0x000fe20000000000ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee210ULL,
0x0000001023237824ULL, 0x100fe200078e0220ULL, 0x0000000911157c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001025257824ULL, 0x000fc400078e0220ULL, 0x000000802a0a7825ULL, 0x000fe200078e00ffULL,
0x0000000018237faeULL, 0x000fe2000c901c46ULL, 0x000000072400720cULL, 0x0c0fe40003f26070ULL,
0x0000000124167824ULL, 0x048fe200078e0209ULL, 0x000000001a257faeULL, 0x000fe2000d101c46ULL,
0x0000000824177824ULL, 0x000fe200078e00ffULL, 0x000000700a0a7812ULL, 0x000fe200078ef800ULL,
0x0000001027277824ULL, 0x000fe200078e0220ULL, 0x000000072600720cULL, 0x000fe20003f46070ULL,
0x0000000106107824ULL, 0x000fe200078e0222ULL, 0xfffffff817177812ULL, 0x000fe200078ee216ULL,
0x000000302c167836ULL, 0x000fe20000000000ULL, 0x000000000c277faeULL, 0x0007e2000c101c46ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000080a0a7c10ULL, 0x000fc6000ffde0ffULL,
0x0000000126217824ULL, 0x040fe200078e0209ULL, 0x0000007010107812ULL, 0x000fe200078ef800ULL,
0x0000000826267824ULL, 0x000fe200078e00ffULL, 0x000000090b0b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001029297824ULL, 0x100fe200078e0220ULL, 0x0000000810107c10ULL, 0x000fe2000ffde0ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0220ULL, 0xfffffff826217812ULL, 0x000fe200078ee221ULL,
0x00000001060c7824ULL, 0x00cfe200078e0216ULL, 0x000000000e297faeULL, 0x0005e2000d901c46ULL,
0x000000102d2d7824ULL, 0x000fe200078e0220ULL, 0x0000000911117c10ULL, 0x000fe2000b7fe4ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000000122b7faeULL, 0x0007e2000e101c46ULL,
0x000000072200720cULL, 0x000fc40003f86070ULL, 0x0000001017177824ULL, 0x100fe200078e0220ULL,
0x000000001c2d7faeULL, 0x000fe2000e901c46ULL, 0x000000342c187836ULL, 0x002fe20000000000ULL,
0x000000072800720cULL, 0x080fe20003fa6070ULL, 0x0000001021217824ULL, 0x000fe200078e0220ULL,
0x000000001e177faeULL, 0x000fe2000c901c46ULL, 0x00000001060e7824ULL, 0x004fe200078e0218ULL,
0x000000071600720cULL, 0x080fe20003f66070ULL, 0x000000382c1a7836ULL, 0x000fe20000000000ULL,
0x000000700c127812ULL, 0x008fe200078ef800ULL, 0x0000000128137824ULL, 0x140fe200078e0209ULL,
0x0000000014217faeULL, 0x0003e2000d101c46ULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x0000000812127c10ULL, 0x000fe2000ffde0ffULL, 0x0000003c2c247836ULL, 0x000fe20000000000ULL,
0x000000071800720cULL, 0x080fe20003f46070ULL, 0x00000001160c7824ULL, 0x000fe200078e0209ULL,
0x000000071a00720cULL, 0x080fe20003f26070ULL, 0x0000000816197824ULL, 0x000fe200078e00ffULL,
0x000000072400720cULL, 0x000fe20003f06070ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff828157812ULL, 0x002fc600078ee213ULL, 0x0000000122077824ULL, 0x000fe200078e0209ULL,
0x000000090d137c10ULL, 0x000fe2000b7fe4ffULL, 0x00000001060d7824ULL, 0x000fe200078e021aULL,
0xfffffff819197812ULL, 0x000fe200078ee20cULL, 0x0000000822227824ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fe200078ef800ULL, 0x000000800d0c7825ULL, 0x000fc600078e00ffULL,
0x000000080e0e7c10ULL, 0x000fe2000ffde0ffULL, 0x0000000106067824ULL, 0x000fe200078e0224ULL,
0xfffffff822177812ULL, 0x000fe200078ee207ULL, 0x0000000118147824ULL, 0x100fe200078e0209ULL,
0x000000700c0c7812ULL, 0x000fe200078ef800ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000000090f0f7c10ULL, 0x000fe4000b7fe4ffULL, 0x000000080c0c7c10ULL, 0x000fe2000ffde0ffULL,
0x00000008181b7824ULL, 0x000fe200078e00ffULL, 0x0000007006007812ULL, 0x000fe200078ef800ULL,
0x000000011a167824ULL, 0x140fe200078e0209ULL, 0x000000090d0d7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000081a1d7824ULL, 0x000fe200078e00ffULL, 0x0000000800067c10ULL, 0x000fe2000ffde0ffULL,
0x0000000124187824ULL, 0x040fe200078e0209ULL, 0xfffffff81b097812ULL, 0x000fe200078ee214ULL,
0x00000008241f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1b7812ULL, 0x000fe200078ee216ULL,
0x0000001015157824ULL, 0x100fe200078e0220ULL, 0x0000000907077c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001017177824ULL, 0x100fe200078e0220ULL, 0xfffffff81f1d7812ULL, 0x000fe200078ee218ULL,
0x0000001019197824ULL, 0x100fe200078e0220ULL, 0x000000000a157faeULL, 0x0003e2000e901c46ULL,
0x0000001009097824ULL, 0x000fc400078e0220ULL, 0x000000101b1b7824ULL, 0x100fe200078e0220ULL,
0x0000000010177faeULL, 0x0003e2000e101c46ULL, 0x000000101d1d7824ULL, 0x000fc600078e0220ULL,
0x0000000012197faeULL, 0x0003e8000d901c46ULL, 0x000000000e097faeULL, 0x0003e8000d101c46ULL,
0x000000000c1b7faeULL, 0x0003e8000c901c46ULL, 0x00000000061d7faeULL, 0x0003e2000c101c46ULL,
0x0000000800d47947ULL, 0x000fea0003800000ULL, 0x00000004090b7811ULL, 0x040fe200078fe8ffULL,
0x0000900000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000c090d7811ULL, 0x040fe400078fe8ffULL,
0x00000008090c7811ULL, 0x000fe200078fe8ffULL, 0x000000010b077824ULL, 0x100fe200078e0209ULL,
0x0000001409157811ULL, 0x000fe200078fe8ffULL, 0x000000080b0a7824ULL, 0x000fe200078e00ffULL,
0x00000010090e7811ULL, 0x000fe200078fe8ffULL, 0x000000080d177824ULL, 0x000fe200078e00ffULL,
0x0000001c09197811ULL, 0x000fe200078fe8ffULL, 0x000000080c107824ULL, 0x040fe200078e00ffULL,
0xfffffff80a0f7812ULL, 0x000fe200078ee207ULL, 0x000000010d0a7824ULL, 0x100fe200078e0209ULL,
0x00000024091e7811ULL, 0x040fe200078fe8ffULL, 0x000000010c077824ULL, 0x100fe200078e0209ULL,
0x00000020091b7811ULL, 0x000fe200078fe8ffULL, 0x0000000115137824ULL, 0x140fe200078e0209ULL,
0xfffffff817127812ULL, 0x000fe200078ee20aULL, 0x0000000815167824ULL, 0x000fe200078e00ffULL,
0x0000001809177811ULL, 0x040fe200078fe8ffULL, 0x000000010e117824ULL, 0x140fe200078e0209ULL,
0x0000002c09247811ULL, 0x000fe200078fe8ffULL, 0x000000080e147824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee207ULL, 0x00000001190a7824ULL, 0x140fe200078e0209ULL,
0xfffffff816167812ULL, 0x000fe200078ee213ULL, 0x00000008191d7824ULL, 0x000fe200078e00ffULL,
0x0000002809227811ULL, 0x000fe200078fe8ffULL, 0x0000000117077824ULL, 0x140fe200078e0209ULL,
0xfffffff814147812ULL, 0x000fe200078ee211ULL, 0x0000000817187824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1a7812ULL, 0x000fe200078ee20aULL, 0x000000011e137824ULL, 0x140fe200078e0209ULL,
0x0000003009267811ULL, 0x000fe200078fe8ffULL, 0x000000081e207824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee207ULL, 0x000000011b117824ULL, 0x100fe200078e0209ULL,
0x0000003409297811ULL, 0x000fe200078fe8ffULL, 0x000000081b1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8201f7812ULL, 0x000fe200078ee213ULL, 0x00000001240a7824ULL, 0x140fe200078e0209ULL,
0x00000038092b7811ULL, 0x040fe200078fe8ffULL, 0x0000000824257824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee211ULL, 0x0000000122077824ULL, 0x140fe200078e0209ULL,
0x0000003c092d7811ULL, 0x040fe200078fe8ffULL, 0x0000000822207824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x0000000126117824ULL, 0x140fe200078e0209ULL,
0x00000009090a7211ULL, 0x000fe200078fe8ffULL, 0x0000000826287824ULL, 0x000fe200078e00ffULL,
0xfffffff820237812ULL, 0x000fe200078ee207ULL, 0x0000000129137824ULL, 0x000fe200078e0209ULL,
0x0000000609077211ULL, 0x000fe200078fe8ffULL, 0x00000008292c7824ULL, 0x000fe200078e00ffULL,
0x000000070a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000106217824ULL, 0x040fe200078e021eULL,
0xfffffff828277812ULL, 0x000fe200078ee211ULL, 0x0000000106117824ULL, 0x040fe200078e020dULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee213ULL, 0x00000001060b7824ULL, 0x000fc400078e020bULL,
0x00000001060c7824ULL, 0x040fe400078e020cULL, 0x0000000106137824ULL, 0x040fe200078e020eULL,
0x0ffffff80a0e7812ULL, 0x000fe200078ef809ULL, 0x0000000106157824ULL, 0x040fe400078e0215ULL,
0x0000000106177824ULL, 0x040fe400078e0217ULL, 0x00000001061d7824ULL, 0x040fe400078e0219ULL,
0x0000000106207824ULL, 0x000fc400078e021bULL, 0x0000000106227824ULL, 0x040fe400078e0222ULL,
0x0000000106247824ULL, 0x040fe400078e0224ULL, 0x0000000106287824ULL, 0x040fe400078e0226ULL,
0x00000001062a7824ULL, 0x040fe400078e0229ULL, 0x00000001062e7824ULL, 0x000fe400078e022bULL,
0x000000012b0d7824ULL, 0x000fc400078e0209ULL, 0x000000082b1e7824ULL, 0x000fe400078e00ffULL,
0x0000000106307824ULL, 0x000fe400078e022dULL, 0x0000008007067825ULL, 0x000fe200078e00ffULL,
0xfffffff81e197812ULL, 0x000fc600078ee20dULL, 0x00004000770a7824ULL, 0x000fe200078e0208ULL,
0x0000007006067812ULL, 0x000fe200078ef800ULL, 0x000000012d097824ULL, 0x040fe400078e0209ULL,
0x000000082d267824ULL, 0x000fe200078e00ffULL, 0x0000000806067c10ULL, 0x000fe2000ff1e0ffULL,
0x000020000a457836ULL, 0x000fe40000000000ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff8261b7812ULL, 0x000fe400078ee209ULL, 0x0000000907077c10ULL, 0x000fe200087fe4ffULL,
0x000000800b0a7825ULL, 0x000fc800078e00ffULL, 0x000000100e097824ULL, 0x100fe200078e0245ULL,
0x000000700a0a7812ULL, 0x000fe200078ef800ULL, 0x000000100f297824ULL, 0x100fe400078e0245ULL,
0x0000001016317824ULL, 0x100fe200078e0245ULL, 0x000000700c167812ULL, 0x000fe200078ef800ULL,
0x00000080110e7825ULL, 0x000fe200078e00ffULL, 0x000000080a0a7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0007e2000b901c46ULL,
0x0000000816167c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010102b7824ULL, 0x100fe200078e0245ULL,
0x000000090b0b7c10ULL, 0x000fe20008ffe4ffULL, 0x00000010122d7824ULL, 0x000fc400078e0245ULL,
0x0000001018337824ULL, 0x000fe200078e0245ULL, 0x000000700e187812ULL, 0x000fe200078ef800ULL,
0x0000008013107825ULL, 0x000fe200078e00ffULL, 0x000000000a297faeULL, 0x0007e6000b901c46ULL,
0x0000008015127825ULL, 0x000fc800078e00ffULL, 0x00000010142f7824ULL, 0x100fe400078e0245ULL,
0x0000008017147825ULL, 0x000fe200078e00ffULL, 0x000000090d177c10ULL, 0x000fe400087fe4ffULL,
0x0000000818187c10ULL, 0x000fe2000ff1e0ffULL, 0x000000101a357824ULL, 0x100fe200078e0245ULL,
0x00000070101a7812ULL, 0x000fe200078ef800ULL, 0x000000101c377824ULL, 0x100fe200078e0245ULL,
0x00000070121c7812ULL, 0x000fe200078ef800ULL, 0x0000001019437824ULL, 0x100fe200078e0245ULL,
0x00000070141e7812ULL, 0x000fe200078ef800ULL, 0x000000801d0c7825ULL, 0x000fe200078e00ffULL,
0x000000081a1a7c10ULL, 0x000fe2000ff3e0ffULL, 0x00000000162b7faeULL, 0x0007e2000b901c46ULL,
0x000000090f197c10ULL, 0x000fe200087fe4ffULL, 0x000000101f397824ULL, 0x100fe200078e0245ULL,
0x000000081c1c7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010233b7824ULL, 0x100fe200078e0245ULL,
0x000000081e1e7c10ULL, 0x000fe2000ff5e0ffULL, 0x00000010253d7824ULL, 0x100fe200078e0245ULL,
0x00000009131d7c10ULL, 0x000fe200087fe4ffULL, 0x00000010273f7824ULL, 0x100fe200078e0245ULL,
0x00000009151f7c10ULL, 0x000fe200097fe4ffULL, 0x000000102c417824ULL, 0x100fe200078e0245ULL,
0x00000000182d7faeULL, 0x0007e2000b901c46ULL, 0x000000101b457824ULL, 0x000fe200078e0245ULL,
0x00000009111b7c10ULL, 0x000fe20008ffe4ffULL, 0x00000080200e7825ULL, 0x000fe200078e00ffULL,
0x000000700c207812ULL, 0x000fc600078ef800ULL, 0x0000008021107825ULL, 0x000fe200078e00ffULL,
0x0000000820207c10ULL, 0x000fe2000ff1e0ffULL, 0x000000001a2f7faeULL, 0x0007e4000b901c46ULL,
0x0000008022127825ULL, 0x000fe200078e00ffULL, 0x000000700e227812ULL, 0x000fe200078ef800ULL,
0x000000001c317faeULL, 0x0007e2000b901c46ULL, 0x000000090d217c10ULL, 0x000fe200087fe4ffULL,
0x0000008024147825ULL, 0x000fe200078e00ffULL, 0x0000007010247812ULL, 0x000fe200078ef800ULL,
0x000000001e337faeULL, 0x0007e2000b901c46ULL, 0x0000007012267812ULL, 0x000fe200078ef800ULL,
0x00000080280c7825ULL, 0x000fe200078e00ffULL, 0x0000000822227c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000020357faeULL, 0x0007e2000b901c46ULL, 0x0000000824247c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000826267c10ULL, 0x000fe4000ff5e0ffULL, 0x000000090f237c10ULL, 0x000fe20008ffe4ffULL,
0x000000802a0e7825ULL, 0x000fe200078e00ffULL, 0x0000007014147812ULL, 0x000fe400078ef800ULL,
0x0000000911257c10ULL, 0x000fe200087fe4ffULL, 0x000000802e107825ULL, 0x000fe200078e00ffULL,
0x0000000913277c10ULL, 0x000fe200097fe4ffULL, 0x0000000022377faeULL, 0x0007e2000b901c46ULL,
0x0000000814147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008030127825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fe200078ef800ULL, 0x0000000024397faeULL, 0x0007e2000b901c46ULL,
0x000000700e0e7812ULL, 0x000fc400078ef800ULL, 0x0000007010107812ULL, 0x000fe200078ef800ULL,
0x00000000263b7faeULL, 0x0007e2000b901c46ULL, 0x0000000915157c10ULL, 0x000fe400087fe4ffULL,
0x0000007012007812ULL, 0x000fe400078ef800ULL, 0x000000080c0c7c10ULL, 0x000fe2000ff1e0ffULL,
0x00000000143d7faeULL, 0x0007e2000b901c46ULL, 0x000000080e0e7c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000810107c10ULL, 0x000fc4000ff5e0ffULL, 0x0000000800127c10ULL, 0x000fe4000ff7e0ffULL,
0x000000090d0d7c10ULL, 0x000fe400087fe4ffULL, 0x000000090f0f7c10ULL, 0x000fe40008ffe4ffULL,
0x0000000911117c10ULL, 0x000fe200097fe4ffULL, 0x000000000c3f7faeULL, 0x0007e2000b901c46ULL,
0x0000000913137c10ULL, 0x000fc60009ffe4ffULL, 0x000000000e417faeULL, 0x0007e8000b901c46ULL,
0x0000000010437faeULL, 0x0007e8000b901c46ULL, 0x0000000012457faeULL, 0x0007e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x00afce0000015200ULL,
0x01a60005080075a7ULL, 0x004e62000800017fULL, 0x00000001625d7824ULL, 0x000fe400078e0a03ULL,
0x0000000402097c24ULL, 0x000fc6000f8e02ffULL, 0x00000008ff5d7819ULL, 0x000fe2000001165dULL,
0x00008e00ff967b82ULL, 0x000ea40000000a00ULL, 0x0000000409967825ULL, 0x004fe200078e0096ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff027224ULL, 0x000fce00078e00ffULL,
0x000000100200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fce0000015200ULL, 0x0000000a06097210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0a7824ULL, 0x000fe200000e0e07ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001140aULL,
0x0000000900007211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e060aULL,
0x0000000200007819ULL, 0x000fc80000001209ULL, 0x000000000000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000102027836ULL, 0x000fce0000000000ULL,
0x01a60005080075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000007919ULL, 0x000e640000000000ULL, 0x0000002077007824ULL, 0x002fc800078e0200ULL,
0x0000000100047836ULL, 0x000fe20000000000ULL, 0x00000004ff027819ULL, 0x000fc80000011600ULL,
0x0ffffffe02057812ULL, 0x000fe400078ec0ffULL, 0x0000001f00027812ULL, 0x000fc600078ec0ffULL,
0x0000000105077824ULL, 0x000fe400078e0204ULL, 0x0000000100067824ULL, 0x000fe400078e0205ULL,
0x00000010020a7824ULL, 0x040fe200078e00ffULL, 0x0000000f07077812ULL, 0x000fe200078ec0ffULL,
0x00000010020b7824ULL, 0x000fe200078e00ffULL, 0x0000000f06067812ULL, 0x000fe200078ec0ffULL,
0x0000000805057836ULL, 0x000fe20000000000ULL, 0x000001f00a097812ULL, 0x000fe400078ee207ULL,
0x000001f00b077812ULL, 0x000fe200078ee206ULL, 0x0000000104047824ULL, 0x000fc400078e0205ULL,
0x0000001009097824ULL, 0x100fe400078e0208ULL, 0x0000001007077824ULL, 0x000fe200078e0208ULL,
0x0000000f04047812ULL, 0x000fe200078ec0ffULL, 0x0000000100007824ULL, 0x000fe200078e0205ULL,
0x00000000090c7984ULL, 0x000e620000000c00ULL, 0x0000001002057824ULL, 0x000fe200078e00ffULL,
0x000001f00b0b7812ULL, 0x000fe400078ee204ULL, 0x0000000007107984ULL, 0x000ea20000000c00ULL,
0x0000000f00007812ULL, 0x000fc800078ec0ffULL, 0x000001f005057812ULL, 0x000fe200078ee200ULL,
0x000000100b007824ULL, 0x100fe400078e0208ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001005057824ULL, 0x000fe400078e0208ULL, 0x000000ffff167224ULL, 0x002fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff147224ULL, 0x004fc400078e0010ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fe200078e000fULL, 0x0000001407007388ULL, 0x000fe20000000c00ULL,
0x000000ffff187224ULL, 0x000fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fca00078e0013ULL,
0x0000001809007388ULL, 0x000fe80000000c00ULL, 0x00000000000c7984ULL, 0x000e680000000c00ULL,
0x0000000005107984ULL, 0x000ea20000000c00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000eULL,
0x000000ffff1e7224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000001c05007388ULL, 0x0003e80000000c00ULL, 0x0000000c00007388ULL, 0x0003e20000000c00ULL,
0x01a6000b080a79a7ULL, 0x0002a4000850003fULL, 0x0000000000047805ULL, 0x002fce0000015200ULL,
0x01a6000b080075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff027224ULL, 0x000fce00078e00ffULL, 0x000000100200780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011407ULL, 0x0000000900007211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000200007819ULL, 0x000fc80000001207ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000102027836ULL, 0x000fce0000000000ULL, 0x01a6000b080075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff6000720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000097919ULL, 0x000e620000000000ULL,
0x0000010076767836ULL, 0x000fe40000000000ULL, 0x3db504f35e5e7820ULL, 0x010fe20000410000ULL,
0x0000000877757824ULL, 0x140fe200078e0208ULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0xffffffff035c7836ULL, 0x000fe40000000000ULL, 0x0000000903007836ULL, 0x000fe40000000000ULL,
0x0000002077657824ULL, 0x000fc400078e0208ULL, 0x000000ffff637224ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fce00078e00ffULL, 0x0000000263057836ULL, 0x008fe20000000000ULL,
0x0000940000047ab9ULL, 0x000fe20000000800ULL, 0x0000010063027824ULL, 0x000fe200078e0276ULL,
0x000000010b0a7812ULL, 0x000fe400078e0cffULL, 0x000000600500720cULL, 0x000fe20003f06070ULL,
0x0000000479047c24ULL, 0x000fd8000f8e0202ULL, 0x0000000c00308947ULL, 0x000fea0003800000ULL,
0x00000003ff247819ULL, 0x102fe20000011609ULL, 0x0000001009167824ULL, 0x000fe200078e00ffULL,
0x0000000262057248ULL, 0x000fe20007fe0000ULL, 0x0000900000087ab9ULL, 0x000fe40000000a00ULL,
0x00000004240c7836ULL, 0x000fe20000000000ULL, 0x0000007016167812ULL, 0x000fe200078ec0ffULL,
0x00000008240e7836ULL, 0x000fe40000000000ULL, 0x000000010c067824ULL, 0x040fe400078e0209ULL,
0x000000080c217824ULL, 0x000fc400078e00ffULL, 0x0000000105177824ULL, 0x000fe400078e0a02ULL,
0x000000010e077824ULL, 0x040fe200078e0209ULL, 0xfffffff821217812ULL, 0x000fe200078ee206ULL,
0x000000080e107824ULL, 0x000fe200078e00ffULL, 0x000000170c00720cULL, 0x000fe20003fa6070ULL,
0x0000000124067824ULL, 0x100fe400078e0204ULL, 0x000000010c0c7824ULL, 0x000fe200078e0204ULL,
0xfffffff810257812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000016061e7212ULL, 0x000fc600078efcffULL,
0x0000001024127836ULL, 0x000fe20000000000ULL, 0x000000160c067212ULL, 0x000fe200078efcffULL,
0x0000000c24107836ULL, 0x000fe20000000000ULL, 0x000000081e1e7c10ULL, 0x000fe2000ff1e0ffULL,
0x00000001120c7824ULL, 0x140fe200078e0209ULL, 0x0000000806067c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000812297824ULL, 0x000fe200078e00ffULL, 0x00000009071f7c10ULL, 0x000fe200087fe4ffULL,
0x0000000110057824ULL, 0x040fe200078e0209ULL, 0x000000090d077c10ULL, 0x000fe20008ffe4ffULL,
0x0000000810147824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee20cULL,
0x000000010e0c7824ULL, 0x140fe200078e0204ULL, 0x000000170e00720cULL, 0x080fe20003f26070ULL,
0x00000001100e7824ULL, 0x040fe200078e0204ULL, 0x000000171000720cULL, 0x080fe20003f46070ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000171200720cULL, 0x000fc40003f06070ULL,
0xfffffff814277812ULL, 0x000fe200078ee205ULL, 0x0000000112107824ULL, 0x000fe200078e0204ULL,
0x000000160c127212ULL, 0x000fe200078efcffULL, 0x0000001824267836ULL, 0x000fe40000000000ULL,
0x0000001424207836ULL, 0x000fe20000000000ULL, 0x0000000812127c10ULL, 0x000fe2000ff7e0ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x000000090d137c10ULL, 0x000fe20009ffe4ffULL,
0x00000001261a7824ULL, 0x000fe200078e0204ULL, 0x00000016100c7212ULL, 0x000fe200078efcffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0x000000080c0c7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000120147824ULL, 0x000fe200078e0204ULL, 0x000000160e187212ULL, 0x080fe200078efcffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x00000009110d7c10ULL, 0x000fe40009ffe4ffULL,
0x0000000818187c10ULL, 0x000fe2000ff9e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000161a107212ULL, 0x080fe400078efcffULL, 0x000000090f197c10ULL, 0x000fe2000a7fe4ffULL,
0x0000001c242a7836ULL, 0x000fe20000000000ULL, 0x00000016140e7212ULL, 0x000fe200078efcffULL,
0x0000400077057824ULL, 0x000fe200078e0208ULL, 0x0000000810107c10ULL, 0x000fe2000ff7e0ffULL,
0x000000012a147824ULL, 0x000fe200078e0204ULL, 0x000000080e0e7c10ULL, 0x000fe2000ff9e0ffULL,
0x000020000a1a7824ULL, 0x000fe200078e0205ULL, 0x000000091b117c10ULL, 0x000fe20009ffe4ffULL,
0x00000001241b7824ULL, 0x000fe200078e0209ULL, 0x00000009150f7c10ULL, 0x000fe2000a7fe4ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000172400720cULL, 0x000fc40003f86070ULL,
0x000000071b1c7812ULL, 0x000fe200078ec0ffULL, 0x000020001a227836ULL, 0x000fe20000000000ULL,
0x00000016141a7212ULL, 0x000fe200078efcffULL, 0x00000020242c7836ULL, 0x000fe20000000000ULL,
0x000000172000720cULL, 0x0c0fe20003f66070ULL, 0x00000001201b7824ULL, 0x040fe200078e0209ULL,
0x0ffffff81c237812ULL, 0x000fe200078ef809ULL, 0x0000000820207824ULL, 0x000fe200078e00ffULL,
0x000000081a1a7c10ULL, 0x000fe2000ffde0ffULL, 0x000000012c147824ULL, 0x000fe400078e0204ULL,
0x0000001023237824ULL, 0x000fe200078e0222ULL, 0xfffffff8202b7812ULL, 0x000fe200078ee21bULL,
0x00000024242e7836ULL, 0x000fe20000000000ULL, 0x00000009151b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e237faeULL, 0x0003e2000e101c46ULL, 0x000000172600720cULL, 0x000fc40003f86070ULL,
0x000000012e1c7824ULL, 0x000fe200078e0204ULL, 0x0000001614207212ULL, 0x000fe200078efcffULL,
0x0000000126287824ULL, 0x040fe400078e0209ULL, 0x00000008262d7824ULL, 0x000fe200078e00ffULL,
0x0000000820207c10ULL, 0x000fe2000ffde0ffULL, 0x0000002824307836ULL, 0x000fe40000000000ULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fc600078ee228ULL,
0x00000010211f7824ULL, 0x102fe200078e0222ULL, 0x0000000915217c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001025237824ULL, 0x000fe200078e0222ULL, 0x000000161c1c7212ULL, 0x000fe200078efcffULL,
0x0000000130147824ULL, 0x000fe200078e0204ULL, 0x00000000061f7faeULL, 0x0003e2000e901c46ULL,
0x0000002c24287836ULL, 0x000fe20000000000ULL, 0x000000172a00720cULL, 0x0c0fe20003fa6070ULL,
0x000000012a1e7824ULL, 0x040fe200078e0209ULL, 0x0000000012237faeULL, 0x0005e2000c901c46ULL,
0x000000082a2f7824ULL, 0x000fe200078e00ffULL, 0x000000081c1c7c10ULL, 0x000fe2000ffde0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000172c00720cULL, 0x000fc40003f26070ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee21eULL, 0x000000012c1e7824ULL, 0x000fe200078e0209ULL,
0x0000001614147212ULL, 0x000fe200078efcffULL, 0x00000010271f7824ULL, 0x002fe200078e0222ULL,
0x000000091d1d7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000128067824ULL, 0x000fe200078e0204ULL,
0x0000000814147c10ULL, 0x000fe2000ffde0ffULL, 0x0000001029137824ULL, 0x004fe200078e0222ULL,
0x00000000181f7faeULL, 0x0003e2000d101c46ULL, 0x000000082c257824ULL, 0x000fe200078e00ffULL,
0x000000172e00720cULL, 0x000fe20003f46070ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000000000c137faeULL, 0x0005e2000c101c46ULL, 0x0000000915157c10ULL, 0x000fc4000b7fe4ffULL,
0x000000012e267824ULL, 0x040fe200078e0209ULL, 0xfffffff825257812ULL, 0x000fe200078ee21eULL,
0x000000082e277824ULL, 0x000fe200078e00ffULL, 0x0000001606067212ULL, 0x000fe200078efcffULL,
0x000000102f237824ULL, 0x100fe400078e0222ULL, 0x0000003024187836ULL, 0x002fe20000000000ULL,
0xfffffff827277812ULL, 0x000fe200078ee226ULL, 0x000000102b197824ULL, 0x000fe200078e0222ULL,
0x0000000806067c10ULL, 0x000fe2000ffde0ffULL, 0x00000001180c7824ULL, 0x004fc400078e0204ULL,
0x000000102d1f7824ULL, 0x100fe200078e0222ULL, 0x000000000e197faeULL, 0x0003e2000d901c46ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000907077c10ULL, 0x000fe4000b7fe4ffULL,
0x00000000101f7faeULL, 0x0005e2000e101c46ULL, 0x00000034241e7836ULL, 0x000fe20000000000ULL,
0x000000172800720cULL, 0x080fe20003f86070ULL, 0x0000001025257824ULL, 0x100fe200078e0222ULL,
0x000000001a237faeULL, 0x0007e2000e901c46ULL, 0x0000001027277824ULL, 0x000fe200078e0222ULL,
0x000000173000720cULL, 0x080fe20003fa6070ULL, 0x0000003824267836ULL, 0x000fe20000000000ULL,
0x0000000020257faeULL, 0x000fe2000c901c46ULL, 0x0000003c24247836ULL, 0x000fe20000000000ULL,
0x000000171800720cULL, 0x080fe20003f66070ULL, 0x000000011e0e7824ULL, 0x002fe200078e0204ULL,
0x000000160c107212ULL, 0x004fe200078efcffULL, 0x0000000130117824ULL, 0x040fe200078e0209ULL,
0x000000001c277faeULL, 0x0003e2000d101c46ULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0x0000000810107c10ULL, 0x000fe2000ffde0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000171e00720cULL, 0x000fc40003f46070ULL, 0x000000172600720cULL, 0x080fe20003f26070ULL,
0x00000008181b7824ULL, 0x008fe200078e00ffULL, 0x000000172400720cULL, 0x000fe20003f06070ULL,
0x00000001260c7824ULL, 0x040fe200078e0204ULL, 0xfffffff830177812ULL, 0x000fe200078ee211ULL,
0x00000008261f7824ULL, 0x000fe200078e00ffULL, 0x000000090d117c10ULL, 0x000fe2000b7fe4ffULL,
0x00000001280d7824ULL, 0x100fe200078e0209ULL, 0x000000160e127212ULL, 0x000fe200078efcffULL,
0x0000000828287824ULL, 0x000fe400078e00ffULL, 0x00000001180e7824ULL, 0x100fe200078e0209ULL,
0x0000000812127c10ULL, 0x000fe2000ffde0ffULL, 0x000000011e187824ULL, 0x000fe200078e0209ULL,
0xfffffff828197812ULL, 0x000fe200078ee20dULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fc400078ee20eULL, 0x000000090f137c10ULL, 0x000fe2000b7fe4ffULL,
0x00000001240e7824ULL, 0x000fe200078e0204ULL, 0x000000160c0c7212ULL, 0x080fe200078efcffULL,
0x000000081e1d7824ULL, 0x002fe400078e00ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000080c0c7c10ULL, 0x000fe4000ffde0ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee218ULL,
0x0000000126047824ULL, 0x100fe200078e0209ULL, 0x000000160e0e7212ULL, 0x000fe200078efcffULL,
0x00000001241a7824ULL, 0x040fe200078e0209ULL, 0x000000090d0d7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000824217824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee204ULL,
0x0000001017177824ULL, 0x100fe200078e0222ULL, 0x000000080e0e7c10ULL, 0x000fe2000ffde0ffULL,
0x0000001019197824ULL, 0x100fe200078e0222ULL, 0xfffffff821217812ULL, 0x000fe200078ee21aULL,
0x000000101b1b7824ULL, 0x100fe200078e0222ULL, 0x000000090f0f7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0222ULL, 0x0000000014177faeULL, 0x0003e2000e901c46ULL,
0x000000101f1f7824ULL, 0x000fc400078e0222ULL, 0x0000001021217824ULL, 0x000fe200078e0222ULL,
0x0000000006197faeULL, 0x0003e8000e101c46ULL, 0x00000000101b7faeULL, 0x0003e8000d901c46ULL,
0x00000000121d7faeULL, 0x0003e8000d101c46ULL, 0x000000000c1f7faeULL, 0x0003e8000c901c46ULL,
0x000000000e217faeULL, 0x0003e2000c101c46ULL, 0x0000000800e07947ULL, 0x000fea0003800000ULL,
0x00000004090c7811ULL, 0x042fe200078fe8ffULL, 0x0000900000087ab9ULL, 0x000fe20000000a00ULL,
0x00000008090e7811ULL, 0x040fe400078fe8ffULL, 0x0000000c09107811ULL, 0x040fe200078fe8ffULL,
0x000000010c057824ULL, 0x140fe200078e0209ULL, 0x0000001009127811ULL, 0x040fe200078fe8ffULL,
0x000000080c227824ULL, 0x000fe200078e00ffULL, 0x0000001409147811ULL, 0x040fe200078fe8ffULL,
0x000000010e067824ULL, 0x140fe200078e0209ULL, 0x0000001809167811ULL, 0x040fe200078fe8ffULL,
0x000000080e077824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee205ULL,
0x0000000110057824ULL, 0x140fe200078e0209ULL, 0x0000001c09187811ULL, 0x040fe200078fe8ffULL,
0x0000000810267824ULL, 0x000fe200078e00ffULL, 0xfffffff807247812ULL, 0x000fe200078ee206ULL,
0x0000000112067824ULL, 0x140fe200078e0209ULL, 0x00000020091a7811ULL, 0x040fe200078fe8ffULL,
0x00000008120f7824ULL, 0x000fe200078e00ffULL, 0x00000024091b7811ULL, 0x040fe200078fe8ffULL,
0x0000000114077824ULL, 0x140fe200078e0209ULL, 0xfffffff826267812ULL, 0x000fe200078ee205ULL,
0x0000000814327824ULL, 0x000fe200078e00ffULL, 0xfffffff80f287812ULL, 0x000fe200078ee206ULL,
0x00000001160d7824ULL, 0x140fe200078e0209ULL, 0x00000028091c7811ULL, 0x040fe200078fe8ffULL,
0x0000000816347824ULL, 0x000fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe200078ee207ULL,
0x0000000118057824ULL, 0x140fe200078e0209ULL, 0x0000002c091e7811ULL, 0x040fe200078fe8ffULL,
0x0000000818367824ULL, 0x000fe200078e00ffULL, 0x00000030092a7811ULL, 0x040fe200078fe8ffULL,
0x000000011a067824ULL, 0x140fe200078e0209ULL, 0x00000034092c7811ULL, 0x000fe200078fe8ffULL,
0x000000081a0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee20dULL,
0x000000011b077824ULL, 0x140fe200078e0209ULL, 0xfffffff836367812ULL, 0x000fe200078ee205ULL,
0x000000081b3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f387812ULL, 0x000fe200078ee206ULL,
0x000000011c0d7824ULL, 0x140fe200078e0209ULL, 0x00000038092e7811ULL, 0x040fe200078fe8ffULL,
0x000000081c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee207ULL,
0x000000011e057824ULL, 0x140fe200078e0209ULL, 0x0000003c09307811ULL, 0x000fe200078fe8ffULL,
0x000000081e3e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee20dULL,
0x000000012a067824ULL, 0x000fc400078e0209ULL, 0x000000082a0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee205ULL, 0x000000012c077824ULL, 0x140fe400078e0209ULL,
0x000000082c427824ULL, 0x000fe200078e00ffULL, 0xfffffff80f407812ULL, 0x000fe200078ee206ULL,
0x000000012e0d7824ULL, 0x140fe200078e0209ULL, 0x0000000409067211ULL, 0x040fe200078fe8ffULL,
0x000000082e447824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee207ULL,
0x0000000130057824ULL, 0x040fe200078e0209ULL, 0x0000000909077211ULL, 0x000fe200078fe8ffULL,
0x0000000830467824ULL, 0x000fe200078e00ffULL, 0xfffffff844447812ULL, 0x000fe200078ee20dULL,
0x000000010c0c7824ULL, 0x100fe200078e0204ULL, 0x0000000707207812ULL, 0x000fe200078ec0ffULL,
0x000000010e0e7824ULL, 0x100fe200078e0204ULL, 0xfffffff846467812ULL, 0x000fe200078ee205ULL,
0x0000000110107824ULL, 0x100fe200078e0204ULL, 0x0ffffff820207812ULL, 0x000fe200078ef809ULL,
0x0000000112127824ULL, 0x000fc400078e0204ULL, 0x0000000114147824ULL, 0x100fe400078e0204ULL,
0x0000000116167824ULL, 0x100fe400078e0204ULL, 0x0000000118187824ULL, 0x100fe400078e0204ULL,
0x000000011a1a7824ULL, 0x100fe400078e0204ULL, 0x000000011b1b7824ULL, 0x100fe400078e0204ULL,
0x000000011c1c7824ULL, 0x000fc400078e0204ULL, 0x000000011e1e7824ULL, 0x100fe400078e0204ULL,
0x000000012a2a7824ULL, 0x100fe400078e0204ULL, 0x000000012c2c7824ULL, 0x100fe400078e0204ULL,
0x000000012e2e7824ULL, 0x100fe400078e0204ULL, 0x0000000130307824ULL, 0x000fe400078e0204ULL,
0x0000001009047824ULL, 0x000fc400078e00ffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0x00000070044b7812ULL, 0x000fe200078ec0ffULL, 0x0000400077057824ULL, 0x000fe400078e0208ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000004b06067212ULL, 0x000fc600078efcffULL,
0x000020000a047824ULL, 0x000fe200078e0205ULL, 0x0000000806067c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004b0e0e7212ULL, 0x000fe400078efcffULL,
0x0000000907077c10ULL, 0x000fe200087fe4ffULL, 0x0000200004497836ULL, 0x000fe20000000000ULL,
0x000000080e0e7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x000000090f0f7c10ULL, 0x000fe200087fe4ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000004b10107212ULL, 0x000fc600078efcffULL, 0x00000010202b7824ULL, 0x000fe200078e0249ULL,
0x0000004b16207212ULL, 0x080fe200078efcffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000004b0c0c7212ULL, 0x080fe400078efcffULL, 0x0000000820207c10ULL, 0x000fe2000ff5e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000810107c10ULL, 0x000fe2000ff1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000062b7faeULL, 0x0003e2000b901c46ULL,
0x0000004b14147212ULL, 0x000fe200078efcffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x000000080c0c7c10ULL, 0x000fc4000ff3e0ffULL, 0x0000000917217c10ULL, 0x000fe200097fe4ffULL,
0x000000801a167825ULL, 0x000fe200078e00ffULL, 0x0000004b12127212ULL, 0x080fe400078efcffULL,
0x0000000911117c10ULL, 0x000fe200087fe4ffULL, 0x00000010222d7824ULL, 0x000fe200078e0249ULL,
0x0000000814147c10ULL, 0x000fe2000ff1e0ffULL, 0x000000801b1a7825ULL, 0x000fe200078e00ffULL,
0x0000004b18227212ULL, 0x000fe400078efcffULL, 0x000000090d0d7c10ULL, 0x000fe20008ffe4ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000000812127c10ULL, 0x000fc4000ff3e0ffULL,
0x0000000915157c10ULL, 0x000fe200087fe4ffULL, 0x00000010242f7824ULL, 0x100fe200078e0249ULL,
0x0000004b16247212ULL, 0x080fe200078efcffULL, 0x0000001026317824ULL, 0x100fe200078e0249ULL,
0x0000000822227c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001028337824ULL, 0x100fe200078e0249ULL,
0x0000004b1a267212ULL, 0x080fe200078efcffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000000913137c10ULL, 0x000fe20008ffe4ffULL, 0x000000000c2d7faeULL, 0x0003e2000b901c46ULL,
0x0000004b1c287212ULL, 0x080fe200078efcffULL, 0x0000001032357824ULL, 0x100fe200078e0249ULL,
0x0000000824247c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001034377824ULL, 0x100fe200078e0249ULL,
0x0000000919237c10ULL, 0x000fe200087fe4ffULL, 0x000000802c187825ULL, 0x000fe200078e00ffULL,
0x0000000826267c10ULL, 0x000fe2000ff1e0ffULL, 0x000000000e2f7faeULL, 0x0003e2000b901c46ULL,
0x0000000828287c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001036397824ULL, 0x100fe200078e0249ULL,
0x0000000917257c10ULL, 0x000fe20008ffe4ffULL, 0x000000802a167825ULL, 0x000fe200078e00ffULL,
0x0000004b1e1e7212ULL, 0x080fe200078efcffULL, 0x0000000010317faeULL, 0x0003e2000b901c46ULL,
0x000000091b277c10ULL, 0x000fe200087fe4ffULL, 0x000000802e1a7825ULL, 0x000fe200078e00ffULL,
0x000000091d297c10ULL, 0x000fe200097fe4ffULL, 0x0000000012337faeULL, 0x0003e2000b901c46ULL,
0x000000081e1e7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000080301c7825ULL, 0x000fe200078e00ffULL,
0x0000004b16167212ULL, 0x080fe200078efcffULL, 0x0000000014357faeULL, 0x0003e2000b901c46ULL,
0x0000004b18187212ULL, 0x080fe200078efcffULL, 0x00000010383b7824ULL, 0x100fe200078e0249ULL,
0x0000004b1a1a7212ULL, 0x080fe200078efcffULL, 0x000000103a3d7824ULL, 0x100fe200078e0249ULL,
0x000000091f1f7c10ULL, 0x000fe200087fe4ffULL, 0x000000103c3f7824ULL, 0x100fe200078e0249ULL,
0x0000004b1c1c7212ULL, 0x000fe200078efcffULL, 0x000000103e417824ULL, 0x100fe200078e0249ULL,
0x0000000816167c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000020377faeULL, 0x0003e2000b901c46ULL,
0x0000000818187c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001040437824ULL, 0x100fe200078e0249ULL,
0x000000081a1a7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000022397faeULL, 0x0003e2000b901c46ULL,
0x000000081c1c7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001042457824ULL, 0x100fe200078e0249ULL,
0x0000000917177c10ULL, 0x000fe200087fe4ffULL, 0x00000000243b7faeULL, 0x0003e2000b901c46ULL,
0x0000000919197c10ULL, 0x000fe20008ffe4ffULL, 0x0000001044477824ULL, 0x100fe200078e0249ULL,
0x000000091b1b7c10ULL, 0x000fe200097fe4ffULL, 0x00000000263d7faeULL, 0x0003e2000b901c46ULL,
0x0000001046497824ULL, 0x000fe200078e0249ULL, 0x000000091d1d7c10ULL, 0x000fc40009ffe4ffULL,
0x00000000283f7faeULL, 0x0003e8000b901c46ULL, 0x000000001e417faeULL, 0x0003e8000b901c46ULL,
0x0000000016437faeULL, 0x0003e8000b901c46ULL, 0x0000000018457faeULL, 0x0003e8000b901c46ULL,
0x000000001a477faeULL, 0x0003e8000b901c46ULL, 0x000000001c497faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000020090e7836ULL, 0x002fe20000000000ULL,
0x0000000809107812ULL, 0x000fe200078ec0ffULL, 0x000020000b5a7824ULL, 0x000fe200078e0205ULL,
0xfffffff8090c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff747224ULL, 0x000fe200078e00ffULL,
0xfffffff80e0e7812ULL, 0x000fe400078ec0ffULL, 0x0000000000067805ULL, 0x000fe4000001ff00ULL,
0x00000007105b7812ULL, 0x000fc400078ef809ULL, 0x0000000000047805ULL, 0x000fe4000001ff00ULL,
0x00000004ff587819ULL, 0x000fe40000011609ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000709597812ULL, 0x000fe400078ec0ffULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fc4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fc4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000487805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x000020005a5a7836ULL, 0x000fe20000000000ULL, 0x000000070c617812ULL, 0x000fe200078ef809ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000070e5f7812ULL, 0x000fe400078ef809ULL,
0x000000105b0b7812ULL, 0x000fce00078efcffULL, 0x00000001610c7824ULL, 0x140fe400078e0274ULL,
0x00000008610d7824ULL, 0x000fe400078e00ffULL, 0x000000015f107824ULL, 0x040fe400078e0274ULL,
0x000000085f117824ULL, 0x040fe200078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL,
0x000000085f7b7824ULL, 0x000fe400078e00ffULL, 0x0000000274907824ULL, 0x000fe200078e0258ULL,
0xfffffff811117812ULL, 0x000fe200078ee210ULL, 0x000000100d0d7824ULL, 0x000fc400078e025aULL,
0x000000100b9b7824ULL, 0x000fe400078e00ffULL, 0x0000001011117824ULL, 0x000fe400078e025aULL,
0x000000000d0c783bULL, 0x000e680000000200ULL, 0x000000001110783bULL, 0x000ea20000000200ULL,
0x00000018ff507819ULL, 0x002fe2000001140cULL, 0x000100000c517824ULL, 0x040fe200078e00ffULL,
0x000088800c527816ULL, 0x040fe200000000ffULL, 0x000001000c0c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fe2000001140dULL, 0x000100000d547824ULL, 0x040fe200078e00ffULL,
0x000088800d707816ULL, 0x040fe200000000ffULL, 0x000001000d0d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x0000005200527306ULL, 0x000fe20000202400ULL,
0x00000018ff537819ULL, 0x000fc40000011451ULL, 0x00000018ff737819ULL, 0x000fe4000001140eULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x000088800e727816ULL, 0x000fe200000000ffULL,
0x0000000c00517306ULL, 0x0003e20000202400ULL, 0x00000018ff697819ULL, 0x000fe4000001140fULL,
0x000088800f687816ULL, 0x000fe400000000ffULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x00000018ff6b7819ULL, 0x004fe20000011410ULL, 0x0000000d009a7306ULL, 0x0005e20000202400ULL,
0x000100000e0c7824ULL, 0x002fe200078e00ffULL, 0x00008880106a7816ULL, 0x000fe200000000ffULL,
0x000001000e0e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe40000011411ULL,
0x00000018ff0c7819ULL, 0x000fe4000001140cULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x000100000f0d7824ULL, 0x044fe200078e00ffULL, 0x0000005400997306ULL, 0x0003e20000202400ULL,
0x000001000f0f7824ULL, 0x000fe200078e00ffULL, 0x00008880116c7816ULL, 0x000fc400000000ffULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x00000018ff0f7819ULL, 0x000fe4000001140fULL,
0x0000000e00987306ULL, 0x0005e20000202400ULL, 0x0000000861547824ULL, 0x002fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe40000011412ULL, 0x00000018ff677819ULL, 0x000fe40000011413ULL,
0x00008880126e7816ULL, 0x000fc400000000ffULL, 0x0000000d00957306ULL, 0x0003e20000202400ULL,
0x00000001740e7836ULL, 0x004fe20000000000ULL, 0x0000888013667816ULL, 0x000fe200000000ffULL,
0x0000000274747836ULL, 0x000fca0000000000ULL, 0x0000000f008a7306ULL, 0x0005e20000202400ULL,
0x00000001610d7824ULL, 0x102fe200078e020eULL, 0x000000087400780cULL, 0x000fe20003f05270ULL,
0x000000015f0e7824ULL, 0x000fca00078e020eULL, 0x0000000c007f7306ULL, 0x0003e20000202400ULL,
0xfffffff8540f7812ULL, 0x004fe200078ee20dULL, 0x00010000110d7824ULL, 0x040fe200078e00ffULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee20eULL, 0x0000010011117824ULL, 0x000fe400078e00ffULL,
0x000000100f0f7824ULL, 0x000fe200078e025aULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x0000005300537306ULL, 0x000ea20000202400ULL, 0x00010000100c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x000000000f54783bULL, 0x000e620000000200ULL,
0x0000010010107824ULL, 0x000fc400078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe4000001140cULL,
0x0000001100947306ULL, 0x0007e20000202400ULL, 0x00000018ff107819ULL, 0x000fce0000011410ULL,
0x00000010008c7306ULL, 0x0009e20000202400ULL, 0x000000105b117824ULL, 0x008fce00078e00ffULL,
0x0000000c00937306ULL, 0x0007e20000202400ULL, 0x0001000013107824ULL, 0x050fe400078e00ffULL,
0x0000010013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000000d00917306ULL, 0x0009e20000202400ULL, 0x00010000120c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0000010012127824ULL, 0x000fc600078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe4000001140cULL, 0x00000010008f7306ULL, 0x0007e20000202400ULL,
0x000000107b0d7824ULL, 0x010fe200078e025aULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0001000055817824ULL, 0x002fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe40000011454ULL,
0x0000888054887816ULL, 0x000fe200000000ffULL, 0x000000000d0c783bULL, 0x000e620000000200ULL,
0x00000018ff807819ULL, 0x000fe20000011455ULL, 0x000000015b107824ULL, 0x008fe200078e0290ULL,
0x0000888055847816ULL, 0x040fe200000000ffULL, 0x0000010055557824ULL, 0x000fe200078e00ffULL,
0x0000005000507306ULL, 0x000ee20000202400ULL, 0x00000018ff7e7819ULL, 0x000fc40000011456ULL,
0xfffffff011117812ULL, 0x000fe200078ee210ULL, 0x0001000054107824ULL, 0x040fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe20000011455ULL, 0x0000010054547824ULL, 0x000fe200078e00ffULL,
0x0000888056827816ULL, 0x040fe200000000ffULL, 0x0000001011117824ULL, 0x000fe200078e0208ULL,
0x0000001200927306ULL, 0x000fe20000202400ULL, 0x0001000056557824ULL, 0x040fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000010056567824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fc40000011410ULL, 0x00000018ff837819ULL, 0x000fe40000011455ULL,
0x0000005400897306ULL, 0x0009e20000202400ULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x00000018ff7d7819ULL, 0x000fc60000011457ULL,
0x00000013008e7306ULL, 0x000be20000202400ULL, 0x000000010b547824ULL, 0x010fe400078e0290ULL,
0x0000000290907836ULL, 0x000fc60000000000ULL, 0xfffffff09b557812ULL, 0x000fe400078ee254ULL,
0x0000541052547816ULL, 0x004fe20000000053ULL, 0x000000001110783bULL, 0x020ea20000000200ULL,
0x0000006e006e7306ULL, 0x000fe20000202400ULL, 0x0000001055527824ULL, 0x000fe200078e0208ULL,
0x0000541051557816ULL, 0x008fe40000000050ULL, 0x00000018ff7c7819ULL, 0x002fe4000001140cULL,
0x00000018ff7b7819ULL, 0x000fe2000001140dULL, 0x000000005250783bULL, 0x000e620000000200ULL,
0x0000008d008d7306ULL, 0x000ee20000202400ULL, 0x00008880579b7816ULL, 0x000fc400000000ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001140eULL, 0x00000018ff787819ULL, 0x000fc6000001140fULL,
0x0000007100717306ULL, 0x000f220000202400ULL, 0x000054106e6e7816ULL, 0x008fce000000008dULL,
0x0000007300737306ULL, 0x000ee20000202400ULL, 0x000054109a717816ULL, 0x010fce0000000071ULL,
0x0000006900697306ULL, 0x000f220000202400ULL, 0x00010000579a7824ULL, 0x040fe400078e00ffULL,
0x0000010057577824ULL, 0x000fc600078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe2000001149aULL,
0x00000054104c723cULL, 0x004fe2000004184cULL, 0x0000006b006b7306ULL, 0x000ea20000202400ULL,
0x0000541098737816ULL, 0x008fe40000000073ULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x000054108a697816ULL, 0x010fc60000000069ULL, 0x0000006d006d7306ULL, 0x000ee20000202400ULL,
0x00000054502c723cULL, 0x002fe2000004182cULL, 0x000054108c6b7816ULL, 0x004fcc000000006bULL,
0x0000006f006f7306ULL, 0x000e620000202400ULL, 0x00005410946d7816ULL, 0x008fce000000006dULL,
0x0000006700677306ULL, 0x000ea20000202400ULL, 0x00005410926f7816ULL, 0x002fce000000006fULL,
0x0000007000707306ULL, 0x000e620000202400ULL, 0x0000006e1034723cULL, 0x000fe20000041834ULL,
0x000054108e677816ULL, 0x004fcc0000000067ULL, 0x0000007200727306ULL, 0x000ea20000202400ULL,
0x0000006e5014723cULL, 0x000fe20000041814ULL, 0x0000541070707816ULL, 0x002fcc0000000099ULL,
0x0000006800687306ULL, 0x000e620000202400ULL, 0x000000ffff997224ULL, 0x000fe200078e009bULL,
0x000000701048723cULL, 0x000fe20000041848ULL, 0x0000541072727816ULL, 0x004fca000000007fULL,
0x0000006a006a7306ULL, 0x000ea20000202400ULL, 0x000000705028723cULL, 0x000fe20000041828ULL,
0x0000541068687816ULL, 0x002fcc0000000095ULL, 0x0000006c006c7306ULL, 0x000e620000202400ULL,
0x000000721044723cULL, 0x000fe20000041844ULL, 0x000054106a6a7816ULL, 0x004fcc0000000093ULL,
0x0000006600667306ULL, 0x000ea20000202400ULL, 0x000000681040723cULL, 0x000fe20000041840ULL,
0x000054106c6c7816ULL, 0x002fcc0000000091ULL, 0x0000008100877306ULL, 0x000fe20000202400ULL,
0x0000006a103c723cULL, 0x000fe2000004183cULL, 0x0000541066667816ULL, 0x004fcc000000008fULL,
0x0000005600817306ULL, 0x0003e20000202400ULL, 0x0000006c1038723cULL, 0x000fec0000041838ULL,
0x000000661030723cULL, 0x000fe20000041830ULL, 0x00000057008c7306ULL, 0x000fe20000202400ULL,
0x000088800c567816ULL, 0x002fc800000000ffULL, 0x000000725024723cULL, 0x000fe20000041824ULL,
0x000000ffff8d7224ULL, 0x000fe200078e0056ULL, 0x000088800d107816ULL, 0x000fe200000000ffULL,
0x000100000c567824ULL, 0x040fe200078e00ffULL, 0x0000007a007a7306ULL, 0x000fe20000202400ULL,
0x000001000c0c7824ULL, 0x000fe200078e00ffULL, 0x0000006a501c723cULL, 0x000fe2000004181cULL,
0x000000105b117824ULL, 0x040fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x000000ffff707224ULL, 0x000fe200078e0010ULL, 0x00000018ff8f7819ULL, 0x000fe2000001140cULL,
0x000000015b0c7824ULL, 0x100fe200078e0290ULL, 0x000088800e107816ULL, 0x000fe200000000ffULL,
0x000000010b907824ULL, 0x000fe200078e0290ULL, 0x00000056008e7306ULL, 0x0003e20000202400ULL,
0x000000685020723cULL, 0x000fe20000041820ULL, 0xfffffff011117812ULL, 0x000fe200078ee20cULL,
0x000100000d0c7824ULL, 0x000fc400078e00ffULL, 0x000001000d0d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff6a7224ULL, 0x000fe200078e0010ULL, 0x0000006c5018723cULL, 0x000fe20000041818ULL,
0x0000001011117824ULL, 0x000fe200078e0208ULL, 0x00000018ff727819ULL, 0x000fe2000001140dULL,
0x000000100b0d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x000100000e107824ULL, 0x040fe200078e00ffULL, 0x000000001154783bULL, 0x002e620000000200ULL,
0x000001000e0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff00d0d7812ULL, 0x000fe200078ee290ULL,
0x000000665004723cULL, 0x000fe20000041804ULL, 0x00000018ff6b7819ULL, 0x000fe20000011410ULL,
0x0000006a006a7306ULL, 0x000fe20000202400ULL, 0x000088800f6c7816ULL, 0x000fe200000000ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0208ULL, 0x00000018ff0e7819ULL, 0x000fc4000001140eULL,
0x000100000f507824ULL, 0x040fe400078e00ffULL, 0x000000000d10783bULL, 0x0004e20000000200ULL,
0x000001000f517824ULL, 0x000fe200078e00ffULL, 0x0000006b006b7306ULL, 0x000f220000202400ULL,
0x00000018ff507819ULL, 0x000fc60000011450ULL, 0x00000018ff527819ULL, 0x000fc80000011451ULL,
0x0000000e006d7306ULL, 0x000f620000202400ULL, 0x000054106a6a7816ULL, 0x010fce000000006bULL,
0x0000008600867306ULL, 0x000ea20000202400ULL, 0x000054106d6b7816ULL, 0x020fce000000007aULL,
0x0000008000807306ULL, 0x000fe20000202400ULL, 0x0000006a5434723cULL, 0x002fe20000041834ULL,
0x00005410890d7816ULL, 0x004fcc0000000086ULL, 0x0000007e007e7306ULL, 0x000e620000202400ULL,
0x0000006a1014723cULL, 0x008fee0000041814ULL, 0x0000007d007d7306ULL, 0x000ea20000202400ULL,
0x0000541081517816ULL, 0x002fce000000007eULL, 0x0000007c007c7306ULL, 0x000fe20000202400ULL,
0x000054108c537816ULL, 0x004fce000000007dULL, 0x0000007b007b7306ULL, 0x000ff00000202400ULL,
0x0000007800787306ULL, 0x000ff00000202400ULL, 0x0000008800887306ULL, 0x000ff00000202400ULL,
0x0000008b008b7306ULL, 0x000ff00000202400ULL, 0x0000008400847306ULL, 0x000e700000202400ULL,
0x0000008500857306ULL, 0x000ea20000202400ULL, 0x00005410840e7816ULL, 0x002fce0000000087ULL,
0x0000008200827306ULL, 0x000fe20000202400ULL, 0x00005410850f7816ULL, 0x004fce0000000080ULL,
0x0000008300837306ULL, 0x000fe20000202400ULL, 0x0000000e5448723cULL, 0x000fee0000041848ULL,
0x00000099007f7306ULL, 0x000fe20000202400ULL, 0x0000000e1028723cULL, 0x000fee0000041828ULL,
0x0000009a008a7306ULL, 0x000ff00000202400ULL, 0x0000008d008d7306ULL, 0x000e700000202400ULL,
0x0000008f008f7306ULL, 0x000ea20000202400ULL, 0x000054108d667816ULL, 0x002fce000000008eULL,
0x0000007000707306ULL, 0x000fe20000202400ULL, 0x000054108f677816ULL, 0x004fce000000007cULL,
0x0000000c00717306ULL, 0x0002a20000202400ULL, 0x00000066543c723cULL, 0x000fee000004183cULL,
0x0000007200727306ULL, 0x000ee20000202400ULL, 0x00005410880c7816ULL, 0x002fe2000000008bULL,
0x00000066101c723cULL, 0x000fe2000004181cULL, 0x0000541070687816ULL, 0x004fca0000000071ULL,
0x0000006c006c7306ULL, 0x000fe20000202400ULL, 0x0000000c544c723cULL, 0x000fe2000004184cULL,
0x0000541072697816ULL, 0x008fcc000000007bULL, 0x00000050006f7306ULL, 0x0002a20000202400ULL,
0x0000000c102c723cULL, 0x000fec000004182cULL, 0x000000685438723cULL, 0x000fe20000041838ULL,
0x0000005200737306ULL, 0x0007220000202400ULL, 0x0000541082507816ULL, 0x002fc80000000083ULL,
0x000000681018723cULL, 0x000fe20000041818ULL, 0x000054106c6c7816ULL, 0x004fe4000000006fULL,
0x000054107f527816ULL, 0x008fc6000000008aULL, 0x000000505444723cULL, 0x000fe20000041844ULL,
0x00005410736d7816ULL, 0x010fca0000000078ULL, 0x000000525440723cULL, 0x000fec0000041840ULL,
0x0000006c5430723cULL, 0x000fec0000041830ULL, 0x000000501024723cULL, 0x000fec0000041824ULL,
0x000000521020723cULL, 0x000fec0000041820ULL, 0x0000006c1004723cULL, 0x000fe20000041804ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffffec00b40947ULL, 0x000fde000383ffffULL,
0x00000001ff127424ULL, 0x000fe400078e00ffULL, 0x0000005e4c0b7220ULL, 0x080fe20000410000ULL,
0x0000005e4d4d7220ULL, 0x080fe20000410000ULL, 0x0000005e4e4e7220ULL, 0x080fe20000410000ULL,
0x0000005e4f4f7220ULL, 0x080fe20000410000ULL, 0x0000005e48487220ULL, 0x080fe20000410000ULL,
0x01a68812751279a7ULL, 0x000e62000850003fULL, 0x0000005e49497220ULL, 0x080fe20000410000ULL,
0x0000005e4a4a7220ULL, 0x080fe20000410000ULL, 0x0000005e4b4b7220ULL, 0x080fe20000410000ULL,
0x0000005e44447220ULL, 0x080fe20000410000ULL, 0x0000005e45457220ULL, 0x080fe20000410000ULL,
0x0000005e46467220ULL, 0x080fe20000410000ULL, 0x0000005e47477220ULL, 0x080fe20000410000ULL,
0x0000005e40407220ULL, 0x080fe20000410000ULL, 0x0000005e41417220ULL, 0x080fe20000410000ULL,
0x0000005e42427220ULL, 0x080fe20000410000ULL, 0x0000005e43437220ULL, 0x080fe20000410000ULL,
0x0000005e3c3c7220ULL, 0x080fe20000410000ULL, 0x0000005e3d3d7220ULL, 0x080fe20000410000ULL,
0x0000005e3e3e7220ULL, 0x080fe20000410000ULL, 0x0000005e3f3f7220ULL, 0x080fe20000410000ULL,
0x0000005e38387220ULL, 0x080fe20000410000ULL, 0x0000005e39397220ULL, 0x080fe20000410000ULL,
0x0000005e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000005e3b3b7220ULL, 0x080fe20000410000ULL,
0x0000005e34347220ULL, 0x080fe20000410000ULL, 0x0000005e35357220ULL, 0x080fe20000410000ULL,
0x0000005e36367220ULL, 0x080fe20000410000ULL, 0x0000005e37377220ULL, 0x080fe20000410000ULL,
0x0000005e30307220ULL, 0x080fe20000410000ULL, 0x0000005e31317220ULL, 0x080fe20000410000ULL,
0x0000005e32327220ULL, 0x080fe20000410000ULL, 0x0000005e33337220ULL, 0x080fe20000410000ULL,
0x0000005e2c0d7220ULL, 0x080fe20000410000ULL, 0x0000005e2d2d7220ULL, 0x080fe20000410000ULL,
0x0000005e2e2e7220ULL, 0x080fe20000410000ULL, 0x0000005e2f2f7220ULL, 0x080fe20000410000ULL,
0x0000005e28287220ULL, 0x080fe20000410000ULL, 0x0000005e29297220ULL, 0x080fe20000410000ULL,
0x0000005e2a2a7220ULL, 0x080fe20000410000ULL, 0x0000005e2b2b7220ULL, 0x080fe20000410000ULL,
0x0000005e24247220ULL, 0x080fe20000410000ULL, 0x0000005e25257220ULL, 0x080fe20000410000ULL,
0x0000005e26267220ULL, 0x080fe20000410000ULL, 0x0000005e27277220ULL, 0x080fe20000410000ULL,
0x0000005e20207220ULL, 0x080fe20000410000ULL, 0x0000005e21217220ULL, 0x080fe20000410000ULL,
0x0000005e22227220ULL, 0x080fe20000410000ULL, 0x0000005e23237220ULL, 0x080fe20000410000ULL,
0x0000005e1c1c7220ULL, 0x080fe20000410000ULL, 0x0000005e1d1d7220ULL, 0x080fe20000410000ULL,
0x0000005e1e1e7220ULL, 0x080fe20000410000ULL, 0x0000005e1f1f7220ULL, 0x080fe20000410000ULL,
0x0000005e18187220ULL, 0x080fe20000410000ULL, 0x0000005e19197220ULL, 0x080fe20000410000ULL,
0x0000005e1a1a7220ULL, 0x080fe20000410000ULL, 0x0000005e1b1b7220ULL, 0x080fe20000410000ULL,
0x0000005e14147220ULL, 0x080fe20000410000ULL, 0x0000005e15157220ULL, 0x080fe20000410000ULL,
0x0000005e16167220ULL, 0x080fe20000410000ULL, 0x0000005e17177220ULL, 0x080fe20000410000ULL,
0x0000005e040c7220ULL, 0x080fe20000410000ULL, 0x0000005e050e7220ULL, 0x080fe20000410000ULL,
0x0000005e060f7220ULL, 0x080fe20000410000ULL, 0x0000005e07107220ULL, 0x000fe20000410000ULL,
0x0000000000067805ULL, 0x000fe20000015200ULL, 0x01a68813750075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff2c7224ULL, 0x000fce00078e00ffULL,
0x000000102c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000406117210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e07ULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000001104047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000012c2c7836ULL, 0x000fce0000000000ULL,
0x01a68813750075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000409047824ULL, 0x000fe200078e00ffULL, 0x0000005d6300720cULL, 0x000fe20003f06070ULL,
0x0000008077117824ULL, 0x000fc600078e0208ULL, 0xfffffff004047812ULL, 0x000fca00078ec0ffULL,
0x0000000111117824ULL, 0x000fca00078e0204ULL, 0x01a4000011047984ULL, 0x0002a20000000c00ULL,
0x0000002000648947ULL, 0x000fea0003800000ULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x00000064092c7211ULL, 0x040fe200078ff0ffULL, 0x0000000400507d06ULL, 0x000ee20008209000ULL,
0xffffff0002ab7836ULL, 0x000fe40000000000ULL, 0x0000000209aa7824ULL, 0x000fc600078e00ffULL,
0x000000ab62027248ULL, 0x000fe40007fe0000ULL, 0x00000006aaaa7812ULL, 0x000fc600078ec0ffULL,
0x0000000102ab7824ULL, 0x000fe400078e0aabULL, 0x0000000100027824ULL, 0x000fe200078e02aaULL,
0x0000005000507308ULL, 0x008ee20000001000ULL, 0x000000ffff817224ULL, 0x000fe400078e0aabULL,
0x00000001aaa97824ULL, 0x000fca00078e0203ULL, 0x00000081a99a7246ULL, 0x000fe2000380005cULL,
0x0ffffffe50127836ULL, 0x008fe40000000000ULL, 0x000000102c507836ULL, 0x000fe40000000000ULL,
0x0000001200137305ULL, 0x000724000021f000ULL, 0x000000ffff127224ULL, 0x008fe400078e00ffULL,
0x000000ffff517224ULL, 0x010fc800078e0a13ULL, 0x0000000451517c24ULL, 0x000fc8000f8e02ffULL,
0x0000005113557227ULL, 0x000fc800078e0012ULL, 0x000000082c137836ULL, 0x000fe40000000000ULL,
0x0000002c55127227ULL, 0x000fc800078e00ffULL, 0x00000013554c7227ULL, 0x000fc800078e00ffULL,
0x000000ffff547224ULL, 0x000fe400078e0a4cULL, 0x000000ffff537224ULL, 0x000fe400078e0a12ULL,
0x000000182c517836ULL, 0x000fe40000000000ULL, 0x0000000454137c24ULL, 0x000fe4000f8e0213ULL,
0x00000004532c7c24ULL, 0x000fe4000f8e022cULL, 0x0000005055527227ULL, 0x000fe200078e00ffULL,
0x0000000413007c0cULL, 0x000fc4000bf06070ULL, 0x000000042c007c0cULL, 0x000fe2000bfa6070ULL,
0x0000005155547227ULL, 0x000fc800078e00ffULL, 0x000000ffff557224ULL, 0x000fe400078e0a52ULL,
0x000000ffff567224ULL, 0x000fe400078e0a54ULL, 0x0000000455507c24ULL, 0x000fe2000f8e0250ULL,
0x00000004ff557c12ULL, 0x000fe2000f8e33ffULL, 0x0000000456517c24ULL, 0x000fe4000f8e0251ULL,
0x8000000413130c36ULL, 0x000fe20008000000ULL, 0x0000000450007c0cULL, 0x000fe2000bf46070ULL,
0x800000042c2c5c36ULL, 0x000fe20008000000ULL, 0x0000000451007c0cULL, 0x000fe2000bf66070ULL,
0x000000014c4c0836ULL, 0x000fe20000000000ULL, 0x0000000413007c0cULL, 0x000fe2000bfc6070ULL,
0x0000000112125836ULL, 0x000fe20000000000ULL, 0x000000042c007c0cULL, 0x000fc4000bf86070ULL,
0x000000ab0200720cULL, 0x000fe40003fa6070ULL, 0x0000008102027246ULL, 0x000fc6000380005cULL,
0x8000000450502c36ULL, 0x000fe20008000000ULL, 0x00000004ff027819ULL, 0x000fe20000011602ULL,
0x8000000451513c36ULL, 0x000fe40008000000ULL, 0x000000014c4c6836ULL, 0x000fe20000000000ULL,
0x0000000450007c0cULL, 0x000fe2000bf26070ULL, 0x0000000112124836ULL, 0x000fe20000000000ULL,
0x00000004ff007c0cULL, 0x000fe2000bfc5070ULL, 0x0000000152522836ULL, 0x000fe20000000000ULL,
0x0000000451007c0cULL, 0x000fe2000bf06070ULL, 0x0000000154543836ULL, 0x000fe20000000000ULL,
0x0000001255137207ULL, 0x000fc40007000000ULL, 0x0000004c55517207ULL, 0x000fe40007000000ULL,
0x000000135c137248ULL, 0x000fe40003fe0000ULL, 0x000000aba900720cULL, 0x000fe20003f86070ULL,
0x0000000152521836ULL, 0x000fe20000000000ULL, 0x000000515c517248ULL, 0x000fe20003fe0000ULL,
0x00000005136f7c24ULL, 0x000fe2000f8e02ffULL, 0x000000ff9a9a7207ULL, 0x000fe20002000000ULL,
0x0000000154540836ULL, 0x000fe20000000000ULL, 0x000000ff02027207ULL, 0x000fe20002800000ULL,
0x0000000551617c24ULL, 0x000fe2000f8e02ffULL, 0x0000005255537207ULL, 0x000fc40007000000ULL,
0x0000006f9a137211ULL, 0x000fe200078fe0ffULL, 0x000000016f517824ULL, 0x000fe200078e0202ULL,
0x000000535c537248ULL, 0x000fe20003fe0000ULL, 0x00000001025b7824ULL, 0x000fe200078e0261ULL,
0x0000005455557207ULL, 0x000fe20007000000ULL, 0x0000000251507825ULL, 0x000fc600078e0096ULL,
0x000000555c557248ULL, 0x000fe20003fe0000ULL, 0x0000000213127825ULL, 0x000fe200078e0096ULL,
0x0000000650a87981ULL, 0x000726000c1e9500ULL, 0x00000005536d7c24ULL, 0x000fe2000f8e02ffULL,
0x0000000612a77981ULL, 0x000b22000c1e9500ULL, 0x00000005555f7c24ULL, 0x000fe2000f8e02ffULL,
0x000000619a577211ULL, 0x000fe200078fe0ffULL, 0x0000000102557824ULL, 0x000fe200078e026dULL,
0x0000006d9a537211ULL, 0x000fe200078fe0ffULL, 0x000000025b5a7825ULL, 0x000fe200078e0096ULL,
0x00000010aa837812ULL, 0x000fc600078efcffULL, 0x0000000257567825ULL, 0x100fe200078e0096ULL,
0x000000065a957981ULL, 0x000f26000c1e9500ULL, 0x0000000255547825ULL, 0x100fe200078e0096ULL,
0x0000000656927981ULL, 0x000f26000c1e9500ULL, 0x0000000253527825ULL, 0x000fc800078e0096ULL,
0x0000000102697824ULL, 0x000fe200078e025fULL, 0x0000000652937981ULL, 0x000f22000c1e9500ULL,
0x00000001002c7824ULL, 0x000fc600078e0283ULL, 0x0000000654027981ULL, 0x000b22000c1e9500ULL,
0x0000005f9a677211ULL, 0x000fe200078fe0ffULL, 0x0000000183857824ULL, 0x000fe200078e0203ULL,
0x000000812c4c7246ULL, 0x000fe2000380005cULL, 0x0000000269507825ULL, 0x108fe200078e0096ULL,
0x000000ab2c00720cULL, 0x080fe40003f26070ULL, 0x000000ab8500720cULL, 0x000fe20003f06070ULL,
0x0000000267127825ULL, 0x022fe200078e0096ULL, 0x00000004ff4c7819ULL, 0x000fe2000001164cULL,
0x0000000650507981ULL, 0x000ee2000c1e9500ULL, 0x0000008185987246ULL, 0x000fc4000380005cULL,
0x000000ff4c4c7207ULL, 0x000fe20000800000ULL, 0x0000000612917981ULL, 0x0002e2000c1e9500ULL,
0x000000ff98987207ULL, 0x000fc60000000000ULL, 0x000000016f557824ULL, 0x004fe200078e024cULL,
0x0000006f98537211ULL, 0x000fe200078fe0ffULL, 0x000000014c677824ULL, 0x000fe200078e0261ULL,
0x00000061985b7211ULL, 0x000fe400078fe0ffULL, 0x00000020aa717812ULL, 0x000fe200078efcffULL,
0x0000000255547825ULL, 0x000fc800078e0096ULL, 0x0000000253527825ULL, 0x100fe200078e0096ULL,
0x00000006548b7981ULL, 0x000566000c1e9500ULL, 0x0000000267667825ULL, 0x100fe200078e0096ULL,
0x0000000652887981ULL, 0x000566000c1e9500ULL, 0x000000025b5a7825ULL, 0x000fe200078e0096ULL,
0x0000000666897981ULL, 0x000f66000c1e9500ULL, 0x00000001002c7824ULL, 0x000fe200078e0271ULL,
0x000000065a867981ULL, 0x000f62000c1e9500ULL, 0x000000014c137824ULL, 0x002fe200078e026dULL,
0x0000006d98577211ULL, 0x000fe200078fe0ffULL, 0x000000014c697824ULL, 0x000fe200078e025fULL,
0x0000005f98517211ULL, 0x000fe200078fe0ffULL, 0x0000000171737824ULL, 0x000fe200078e0203ULL,
0x000000812c4c7246ULL, 0x000fe2000380005cULL, 0x0000000213127825ULL, 0x000fe200078e0096ULL,
0x000000ab2c00720cULL, 0x000fc40003f26070ULL, 0x00000004ff2c7819ULL, 0x000fe2000001164cULL,
0x0000000257567825ULL, 0x100fe200078e0096ULL, 0x000000ab7300720cULL, 0x000fe20003f06070ULL,
0x0000000612127981ULL, 0x000f62000c1e9500ULL, 0x00000081734c7246ULL, 0x000fe2000380005cULL,
0x0000000269547825ULL, 0x004fc800078e0096ULL, 0x0000000251527825ULL, 0x000fe200078e0096ULL,
0x000000ff2c2c7207ULL, 0x000fe20000800000ULL, 0x0000000656877981ULL, 0x000ea2000c1e9500ULL,
0x000000ff4c4c7207ULL, 0x000fc60000000000ULL, 0x0000000654517981ULL, 0x0002a2000c1e9500ULL,
0x000000614c6b7211ULL, 0x000fc600078fe0ffULL, 0x0000000652847981ULL, 0x0002a4000c1e9500ULL,
0x000000026b6a7825ULL, 0x000fe200078e0096ULL, 0x0000006f4c557211ULL, 0x002fc600078fe0ffULL,
0x000000016f577824ULL, 0x000fe200078e022cULL, 0x000000066a747981ULL, 0x000ea2000c1e9500ULL,
0x000000012c537824ULL, 0x000fc800078e0261ULL, 0x0000000253527825ULL, 0x000fe200078e0096ULL,
0x0000006d4c677211ULL, 0x000fc800078fe0ffULL, 0x00000006527d7981ULL, 0x0002a2000c1e9500ULL,
0x0000000257567825ULL, 0x000fe200078e0096ULL, 0x0000005f4c137211ULL, 0x000fc600078fe0ffULL,
0x0000000255547825ULL, 0x000fe200078e0096ULL, 0x00000006567f7981ULL, 0x0002a6000c1e9500ULL,
0x000000012c697824ULL, 0x000fe200078e026dULL, 0x00000030aa537812ULL, 0x002fe200078efcffULL,
0x000000012c5b7824ULL, 0x000fe200078e025fULL, 0x0000000654787981ULL, 0x0002a2000c1e9500ULL,
0x0000000269687825ULL, 0x000fc800078e0096ULL, 0x0000000267667825ULL, 0x000fc800078e0096ULL,
0x000000025b567825ULL, 0x100fe200078e0096ULL, 0x0000000666727981ULL, 0x000ea6000c1e9500ULL,
0x0000000213547825ULL, 0x002fe200078e0096ULL, 0x0000000656527981ULL, 0x000ea6000c1e9500ULL,
0x00000001002c7824ULL, 0x000fe200078e0253ULL, 0x0000000668137981ULL, 0x000ea2000c1e9500ULL,
0x00000001535b7824ULL, 0x000fc600078e0203ULL, 0x00000006547b7981ULL, 0x0002a2000c1e9500ULL,
0x000000812c587246ULL, 0x000fe4000380005cULL, 0x000000ab2c00720cULL, 0x080fe40003f26070ULL,
0x00000004ff587819ULL, 0x000fe40000011658ULL, 0x000000ab5b00720cULL, 0x000fe40003f06070ULL,
0x000000815b947246ULL, 0x000fe4000380005cULL, 0x000000ff58587207ULL, 0x000fc40000800000ULL,
0x000000ff94947207ULL, 0x000fc60000000000ULL, 0x000000016f6b7824ULL, 0x000fe200078e0258ULL,
0x0000006f94557211ULL, 0x002fe200078fe0ffULL, 0x00000001586f7824ULL, 0x000fe200078e026dULL,
0x0000006d946d7211ULL, 0x000fe200078fe0ffULL, 0x000000026b6a7825ULL, 0x000fc800078e0096ULL,
0x0000000255547825ULL, 0x100fe200078e0096ULL, 0x0000006194817211ULL, 0x000fe200078fe0ffULL,
0x000000066a6a7981ULL, 0x000ea4000c1e9500ULL, 0x000000026f6e7825ULL, 0x100fe400078e0096ULL,
0x0000000654697981ULL, 0x0002a4000c1e9500ULL, 0x000000026d6c7825ULL, 0x000fe400078e0096ULL,
0x000000066e2c7981ULL, 0x000ea4000c1e9500ULL, 0x00000001588d7824ULL, 0x000fc400078e0261ULL,
0x000000066c617981ULL, 0x000ea2000c1e9500ULL, 0x0000000281807825ULL, 0x000fc800078e0096ULL,
0x000000028d8c7825ULL, 0x000fe200078e0096ULL, 0x0000000680677981ULL, 0x000ea2000c1e9500ULL,
0x0000005f94577211ULL, 0x000fc600078fe0ffULL, 0x000000068c687981ULL, 0x0002a4000c1e9500ULL,
0x0000000158557824ULL, 0x002fe400078e025fULL, 0x0000000257567825ULL, 0x000fc800078e0096ULL,
0x0000000255547825ULL, 0x000fe200078e0096ULL, 0x00000006565f7981ULL, 0x0002a8000c1e9500ULL,
0x0000000654667981ULL, 0x0002a2000c1e9500ULL, 0xfffffff09a9a7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff997424ULL, 0x000fc800078e00ffULL, 0x00000001ab9a7824ULL, 0x000fc800078e029aULL,
0x00000001a9a67824ULL, 0x000fe200078e0a9aULL, 0x00000001aa907812ULL, 0x000fc800078efcffULL,
0x000000a699a67219ULL, 0x000fe200000006ffULL, 0x00000001908f7824ULL, 0x100fe200078e0203ULL,
0xfffffff04ca27812ULL, 0x000fe400078ec0ffULL, 0xfffffff0944c7812ULL, 0x000fe200078ec0ffULL,
0x000000018f947824ULL, 0x000fe200078e0a9aULL, 0x00000008aa8c7812ULL, 0x040fe400078efcffULL,
0x00000009aa8a7812ULL, 0x000fe400078efcffULL, 0x0000009499947219ULL, 0x000fe200000006ffULL,
0x000000018c8e7824ULL, 0x000fc400078e0203ULL, 0x000000018a8d7824ULL, 0x100fe200078e0203ULL,
0xfffffff0989e7812ULL, 0x000fe200078ec0ffULL, 0x000000018e987824ULL, 0x100fe400078e0a9aULL,
0x000000018d9a7824ULL, 0x000fe200078e0a9aULL, 0x00000011aa827812ULL, 0x000fe400078efcffULL,
0x0000009899987219ULL, 0x040fe400000006ffULL, 0x0000009a999a7219ULL, 0x000fe200000006ffULL,
0x0000000182817824ULL, 0x000fc400078e0203ULL, 0x00000001ab9e7824ULL, 0x000fe200078e029eULL,
0x00000018aa7c7812ULL, 0x000fc600078efcffULL, 0x0000000185b67824ULL, 0x100fe400078e0a9eULL,
0x00000001819c7824ULL, 0x000fe200078e0a9eULL, 0x00000019aa7a7812ULL, 0x000fe400078efcffULL,
0x000000b6999b7219ULL, 0x040fe400000006ffULL, 0x0000009c999c7219ULL, 0x000fe400000006ffULL,
0x00005410a7a77816ULL, 0x010fc800000000a8ULL, 0x000000a7a6ff7212ULL, 0x000fc800078ac0ffULL,
0x000000aba900720cULL, 0x000fc80002fa1470ULL, 0x000000abaa00720cULL, 0x000fe40002fa1070ULL,
0x0000541092957816ULL, 0x000fe40000000095ULL, 0xff8000000b0b7808ULL, 0x000fe40002800000ULL,
0x000000a794ff7212ULL, 0x000fe4000782c0ffULL, 0x00000095a6ff7212ULL, 0x080fe4000784c0ffULL,
0x0000009594ff7212ULL, 0x000fc400078ac0ffULL, 0x0000541093937816ULL, 0x000fc80000000002ULL,
0x00000093a6ff7212ULL, 0x000fe4000788c0ffULL, 0x000000aba900720cULL, 0x0c0fe40001741470ULL,
0x000000aba900720cULL, 0x080fe40002781470ULL, 0x000000ab8f00720cULL, 0x0c0fe40000f21470ULL,
0x000000ab8f00720cULL, 0x080fe40002fa1470ULL, 0x000000abaa00720cULL, 0x000fc40001741070ULL,
0x000000abaa00720cULL, 0x080fe40002781070ULL, 0x000000ab9000720cULL, 0x0c0fe40000f21070ULL,
0x000000ab9000720cULL, 0x000fe40002fa1070ULL, 0x0000541091917816ULL, 0x008fe40000000050ULL,
0xff8000004e4e7808ULL, 0x000fe40001000000ULL, 0xff8000000d0d7808ULL, 0x000fc40002000000ULL,
0xff8000004d4d7808ULL, 0x000fe40000800000ULL, 0xff8000004f4f7808ULL, 0x000fe40002800000ULL,
0x000000a798ff7212ULL, 0x000fe4000786c0ffULL, 0x00000091a6ff7212ULL, 0x000fe4000780c0ffULL,
0x0000009394ff7212ULL, 0x040fe4000784c0ffULL, 0x0000009194ff7212ULL, 0x000fc4000788c0ffULL,
0x000000959aff7212ULL, 0x000fe4000782c0ffULL, 0x0000009398ff7212ULL, 0x000fe400078ac0ffULL,
0x000000aba900720cULL, 0x080fe40000701470ULL, 0x000000ab8f00720cULL, 0x0c0fe40001741470ULL,
0x000000ab8f00720cULL, 0x080fe40002781470ULL, 0x000000ab8e00720cULL, 0x000fc40001f61470ULL,
0x000000ab8e00720cULL, 0x080fe40002fa1470ULL, 0x000000ab8d00720cULL, 0x080fe40000f21470ULL,
0x000000abaa00720cULL, 0x080fe40000701070ULL, 0x000000ab9000720cULL, 0x0c0fe40001741070ULL,
0x000000ab9000720cULL, 0x080fe40002781070ULL, 0x000000ab8c00720cULL, 0x000fc40001f61070ULL,
0x000000ab8c00720cULL, 0x080fe40002fa1070ULL, 0x000000ab8a00720cULL, 0x000fe40000f21070ULL,
0x0000541088887816ULL, 0x020fe4000000008bULL, 0x0000541086867816ULL, 0x000fe20000000089ULL,
0x000000017c807824ULL, 0x100fe200078e0203ULL, 0xff8000002e2e7808ULL, 0x000fe20000000000ULL,
0x000000017a7e7824ULL, 0x000fe200078e0203ULL, 0xff8000002d2d7808ULL, 0x000fc40001000000ULL,
0xff8000002f2f7808ULL, 0x000fe40002000000ULL, 0xff80000048487808ULL, 0x000fe40001800000ULL,
0xff80000028287808ULL, 0x000fe40002800000ULL, 0xff8000004b4b7808ULL, 0x000fe40000800000ULL,
0x0000009598ff7212ULL, 0x000fe4000780c0ffULL, 0x000000939aff7212ULL, 0x000fc4000784c0ffULL,
0x0000009198ff7212ULL, 0x080fe4000788c0ffULL, 0x000000919aff7212ULL, 0x000fe4000786c0ffULL,
0x000000889cff7212ULL, 0x000fe400078ac0ffULL, 0x000000869bff7212ULL, 0x000fe2000782c0ffULL,
0x0000000180b47824ULL, 0x100fe200078e0a9eULL, 0x000000ab8e00720cULL, 0x080fe20000701470ULL,
0x000000017e9e7824ULL, 0x000fe200078e0a9eULL, 0x000000ab8e00720cULL, 0x000fc40002781470ULL,
0x000000ab8d00720cULL, 0x0c0fe40001741470ULL, 0x000000ab8d00720cULL, 0x080fe40001f61470ULL,
0x000000ab8500720cULL, 0x080fe40000f21470ULL, 0x000000ab8100720cULL, 0x080fe40002fa1470ULL,
0x000000ab8c00720cULL, 0x0c0fe40000701070ULL, 0x000000ab8c00720cULL, 0x000fc40002781070ULL,
0x000000ab8a00720cULL, 0x0c0fe40001741070ULL, 0x000000ab8a00720cULL, 0x080fe40001f61070ULL,
0x000000ab8300720cULL, 0x080fe40000f21070ULL, 0x000000ab8200720cULL, 0x000fe40002fa1070ULL,
0x000000b4999d7219ULL, 0x040fe400000006ffULL, 0x0000009e999e7219ULL, 0x000fc400000006ffULL,
0x0000541087127816ULL, 0x004fe40000000012ULL, 0x0000541084517816ULL, 0x000fe20000000051ULL,
0x00000001aba27824ULL, 0x000fe200078e02a2ULL, 0xff8000004a4a7808ULL, 0x000fe40000000000ULL,
0xff8000002a2a7808ULL, 0x000fe40002000000ULL, 0xff80000029297808ULL, 0x000fe40001000000ULL,
0xff8000002b2b7808ULL, 0x000fc40001800000ULL, 0xff80000046467808ULL, 0x000fe40000800000ULL,
0xff80000045457808ULL, 0x000fe40002800000ULL, 0x000000889bff7212ULL, 0x080fe4000780c0ffULL,
0x000000889dff7212ULL, 0x000fe4000788c0ffULL, 0x000000129bff7212ULL, 0x040fe4000784c0ffULL,
0x000000519bff7212ULL, 0x000fc4000786c0ffULL, 0x000000129cff7212ULL, 0x000fe4000782c0ffULL,
0x000000869eff7212ULL, 0x000fe200078ac0ffULL, 0x0000000173b27824ULL, 0x000fe200078e0aa2ULL,
0x000000ab8500720cULL, 0x0c0fe40000701470ULL, 0x000000ab8500720cULL, 0x0c0fe40001741470ULL,
0x000000ab8500720cULL, 0x080fe40001f61470ULL, 0x000000ab8100720cULL, 0x000fc40000f21470ULL,
0x000000ab8000720cULL, 0x080fe40002781470ULL, 0x000000ab7e00720cULL, 0x080fe40002fa1470ULL,
0x00000021aa707812ULL, 0x000fe400078efcffULL, 0x000000ab8300720cULL, 0x0c0fe40000701070ULL,
0x000000ab8300720cULL, 0x0c0fe40001741070ULL, 0x000000ab8300720cULL, 0x000fc40001f61070ULL,
0x000000ab8200720cULL, 0x080fe40000f21070ULL, 0x000000ab7c00720cULL, 0x080fe40002781070ULL,
0x000000ab7a00720cULL, 0x000fe40002fa1070ULL, 0x000000b2999f7219ULL, 0x000fe400000006ffULL,
0x0000541074747816ULL, 0x000fe2000000007dULL, 0x00000001706f7824ULL, 0x000fe200078e0203ULL,
0xff80000044447808ULL, 0x000fc40000000000ULL, 0xff80000024247808ULL, 0x000fe40001000000ULL,
0xff80000026267808ULL, 0x000fe40001800000ULL, 0xff80000025257808ULL, 0x000fe40000800000ULL,
0xff80000040407808ULL, 0x000fe40002000000ULL, 0xff80000043437808ULL, 0x000fe40002800000ULL,
0x000000869cff7212ULL, 0x000fc4000780c0ffULL, 0x000000519cff7212ULL, 0x080fe4000784c0ffULL,
0x000000869dff7212ULL, 0x000fe4000786c0ffULL, 0x000000129eff7212ULL, 0x040fe4000782c0ffULL,
0x000000519eff7212ULL, 0x000fe4000788c0ffULL, 0x000000749fff7212ULL, 0x000fe200078ac0ffULL,
0x000000016fa07824ULL, 0x000fe200078e0aa2ULL, 0x000000ab8100720cULL, 0x000fc40000701470ULL,
0x000000ab8100720cULL, 0x080fe40001741470ULL, 0x000000ab8000720cULL, 0x080fe40001f61470ULL,
0x000000ab7e00720cULL, 0x0c0fe40000f21470ULL, 0x000000ab7e00720cULL, 0x080fe40002781470ULL,
0x000000ab7300720cULL, 0x000fe40002fa1470ULL, 0x00000028aa6e7812ULL, 0x000fc400078efcffULL,
0x00000029aa6c7812ULL, 0x000fe400078efcffULL, 0x000000ab8200720cULL, 0x0c0fe40000701070ULL,
0x000000ab8200720cULL, 0x080fe40001741070ULL, 0x000000ab7c00720cULL, 0x080fe40001f61070ULL,
0x000000ab7a00720cULL, 0x0c0fe40000f21070ULL, 0x000000ab7a00720cULL, 0x000fc40002781070ULL,
0x000000ab7100720cULL, 0x000fe40002fa1070ULL, 0x000000a099a07219ULL, 0x000fe400000006ffULL,
0x0000541078787816ULL, 0x000fe4000000007fULL, 0x0000541072137816ULL, 0x000fe40000000013ULL,
0x000054107b527816ULL, 0x000fe20000000052ULL, 0x000000016e6d7824ULL, 0x100fe200078e0203ULL,
0xff80000047477808ULL, 0x000fe20000000000ULL, 0x000000016c6b7824ULL, 0x000fe200078e0203ULL,
0xff80000027277808ULL, 0x000fc40001000000ULL, 0xff80000042427808ULL, 0x000fe40001800000ULL,
0xff80000021217808ULL, 0x000fe40000800000ULL, 0xff80000023237808ULL, 0x000fe40002000000ULL,
0xff8000003e3e7808ULL, 0x000fe40002800000ULL, 0x000000a79aff7212ULL, 0x000fe400078cc0ffULL,
0x000000129dff7212ULL, 0x000fc4000780c0ffULL, 0x000000519dff7212ULL, 0x000fe4000784c0ffULL,
0x000000789fff7212ULL, 0x040fe4000786c0ffULL, 0x000000139fff7212ULL, 0x0c0fe4000782c0ffULL,
0x000000529fff7212ULL, 0x000fe4000788c0ffULL, 0x00000013a0ff7212ULL, 0x000fe200078ac0ffULL,
0x000000016db07824ULL, 0x100fe200078e0aa2ULL, 0x000000ab8d00720cULL, 0x080fe200037c1470ULL,
0x000000016ba27824ULL, 0x000fe200078e0aa2ULL, 0x000000ab8000720cULL, 0x000fc40000701470ULL,
0x000000ab8000720cULL, 0x080fe40001741470ULL, 0x000000ab7300720cULL, 0x0c0fe40001f61470ULL,
0x000000ab7300720cULL, 0x0c0fe40000f21470ULL, 0x000000ab7300720cULL, 0x080fe40002781470ULL,
0x000000ab6f00720cULL, 0x080fe40002fa1470ULL, 0x000000ab8a00720cULL, 0x000fc400037c1070ULL,
0x000000ab7c00720cULL, 0x0c0fe40000701070ULL, 0x000000ab7c00720cULL, 0x080fe40001741070ULL,
0x000000ab7100720cULL, 0x0c0fe40001f61070ULL, 0x000000ab7100720cULL, 0x0c0fe40000f21070ULL,
0x000000ab7100720cULL, 0x080fe40002781070ULL, 0x000000ab7000720cULL, 0x000fc40002fa1070ULL,
0x000000b099a17219ULL, 0x040fe400000006ffULL, 0x000000a299a27219ULL, 0x000fe200000006ffULL,
0x00000001ab4c7824ULL, 0x000fe200078e024cULL, 0xff80000049497808ULL, 0x000fe40003000000ULL,
0xff80000020207808ULL, 0x000fe40000000000ULL, 0xff80000022227808ULL, 0x000fe40001000000ULL,
0xff8000003c3c7808ULL, 0x000fc40001800000ULL, 0xff8000001c1c7808ULL, 0x000fe40000800000ULL,
0xff8000001e1e7808ULL, 0x000fe40002000000ULL, 0xff8000001d1d7808ULL, 0x000fe40002800000ULL,
0x000000889eff7212ULL, 0x000fe400078cc0ffULL, 0x00000078a0ff7212ULL, 0x080fe4000780c0ffULL,
0x00000078a1ff7212ULL, 0x000fc4000784c0ffULL, 0x00000074a0ff7212ULL, 0x040fe4000786c0ffULL,
0x00000052a0ff7212ULL, 0x000fe4000782c0ffULL, 0x00000074a1ff7212ULL, 0x000fe4000788c0ffULL,
0x00000013a2ff7212ULL, 0x000fe200078ac0ffULL, 0x000000015bae7824ULL, 0x000fe200078e0a4cULL,
0x000000ab7e00720cULL, 0x080fe400037c1470ULL, 0x000000ab6f00720cULL, 0x000fc40000701470ULL,
0x000000ab6f00720cULL, 0x0c0fe40001f61470ULL, 0x000000ab6f00720cULL, 0x080fe40000f21470ULL,
0x000000ab6d00720cULL, 0x0c0fe40001741470ULL, 0x000000ab6d00720cULL, 0x080fe40002781470ULL,
0x000000ab6b00720cULL, 0x000fe40002fa1470ULL, 0x00000031aa587812ULL, 0x000fc400078efcffULL,
0x00000038aa567812ULL, 0x042fe400078efcffULL, 0x00000039aa547812ULL, 0x000fe400078efcffULL,
0x000000ab7a00720cULL, 0x080fe400037c1070ULL, 0x000000ab7000720cULL, 0x0c0fe40000701070ULL,
0x000000ab7000720cULL, 0x0c0fe40001f61070ULL, 0x000000ab7000720cULL, 0x000fc40000f21070ULL,
0x000000ab6e00720cULL, 0x0c0fe40001741070ULL, 0x000000ab6e00720cULL, 0x080fe40002781070ULL,
0x000000ab6c00720cULL, 0x000fe40002fa1070ULL, 0x000000ae99a37219ULL, 0x000fe400000006ffULL,
0x0000541069697816ULL, 0x000fe4000000006aULL, 0x00005410612c7816ULL, 0x000fe2000000002cULL,
0x00000001585a7824ULL, 0x100fe200078e0203ULL, 0xff80000041417808ULL, 0x000fe20003000000ULL,
0x0000000156577824ULL, 0x100fe200078e0203ULL, 0xff8000003d3d7808ULL, 0x000fe20000000000ULL,
0x0000000154557824ULL, 0x000fe200078e0203ULL, 0xff8000003f3f7808ULL, 0x000fc40001800000ULL,
0xff8000001f1f7808ULL, 0x000fe40000800000ULL, 0xff80000038387808ULL, 0x000fe40001000000ULL,
0xff8000003a3a7808ULL, 0x000fe40002000000ULL, 0xff80000019197808ULL, 0x000fe40002800000ULL,
0x00000078a2ff7212ULL, 0x040fe400078cc0ffULL, 0x00000074a2ff7212ULL, 0x000fc4000780c0ffULL,
0x00000013a1ff7212ULL, 0x040fe4000786c0ffULL, 0x00000052a1ff7212ULL, 0x080fe4000782c0ffULL,
0x00000052a2ff7212ULL, 0x000fe4000784c0ffULL, 0x00000069a3ff7212ULL, 0x040fe4000788c0ffULL,
0x0000002ca3ff7212ULL, 0x000fe200078ac0ffULL, 0x000000015aa47824ULL, 0x100fe200078e0a4cULL,
0x000000ab6d00720cULL, 0x080fe20001f61470ULL, 0x0000000157ac7824ULL, 0x100fe200078e0a4cULL,
0x000000ab6d00720cULL, 0x080fe20000f21470ULL, 0x00000001554c7824ULL, 0x000fe200078e0a4cULL,
0x000000ab6b00720cULL, 0x000fc400037c1470ULL, 0x000000ab6b00720cULL, 0x0c0fe40000701470ULL,
0x000000ab6b00720cULL, 0x080fe40001741470ULL, 0x000000ab5b00720cULL, 0x0c0fe40002781470ULL,
0x000000ab5b00720cULL, 0x080fe40002fa1470ULL, 0x000000ab6e00720cULL, 0x0c0fe40001f61070ULL,
0x000000ab6e00720cULL, 0x000fc40000f21070ULL, 0x000000ab6c00720cULL, 0x0c0fe400037c1070ULL,
0x000000ab6c00720cULL, 0x0c0fe40000701070ULL, 0x000000ab6c00720cULL, 0x080fe40001741070ULL,
0x000000ab5300720cULL, 0x0c0fe40002781070ULL, 0x000000ab5300720cULL, 0x000fe40002fa1070ULL,
0x000000a499a47219ULL, 0x000fc400000006ffULL, 0x000000ac99a57219ULL, 0x040fe400000006ffULL,
0x0000004c994c7219ULL, 0x000fe400000006ffULL, 0x0000541067677816ULL, 0x000fe40000000068ULL,
0xff80000018187808ULL, 0x000fe40001800000ULL, 0xff8000001a1a7808ULL, 0x000fe40000800000ULL,
0xff80000039397808ULL, 0x000fc40003000000ULL, 0xff8000003b3b7808ULL, 0x000fe40000000000ULL,
0xff8000001b1b7808ULL, 0x000fe40001000000ULL, 0xff80000034347808ULL, 0x000fe40002000000ULL,
0xff80000014147808ULL, 0x000fe40002800000ULL, 0x00000069a4ff7212ULL, 0x080fe4000786c0ffULL,
0x00000069a5ff7212ULL, 0x000fc4000782c0ffULL, 0x000000694cff7212ULL, 0x000fe400078cc0ffULL,
0x00000067a3ff7212ULL, 0x080fe4000780c0ffULL, 0x00000067a4ff7212ULL, 0x0c0fe4000784c0ffULL,
0x00000067a5ff7212ULL, 0x000fe4000788c0ffULL, 0x0000002ca4ff7212ULL, 0x000fe400078ac0ffULL,
0x000000ab5b00720cULL, 0x000fc40000701470ULL, 0x000000ab5a00720cULL, 0x0c0fe40001f61470ULL,
0x000000ab5a00720cULL, 0x0c0fe40001741470ULL, 0x000000ab5a00720cULL, 0x080fe40002fa1470ULL,
0x000000ab5700720cULL, 0x080fe40000f21470ULL, 0x000000ab5500720cULL, 0x080fe400037c1470ULL,
0x000000ab5700720cULL, 0x000fc40002781470ULL, 0x000000ab5300720cULL, 0x080fe40000701070ULL,
0x000000ab5800720cULL, 0x0c0fe40001f61070ULL, 0x000000ab5800720cULL, 0x0c0fe40001741070ULL,
0x000000ab5800720cULL, 0x080fe40002fa1070ULL, 0x000000ab5600720cULL, 0x080fe40000f21070ULL,
0x000000ab5400720cULL, 0x000fc400037c1070ULL, 0x000000ab5600720cULL, 0x000fe40002781070ULL,
0x000054105f5f7816ULL, 0x000fe40000000066ULL, 0xff80000036367808ULL, 0x000fe40000000000ULL,
0xff80000035357808ULL, 0x000fe40001800000ULL, 0xff80000037377808ULL, 0x000fe40001000000ULL,
0xff80000015157808ULL, 0x000fc40002800000ULL, 0xff80000030307808ULL, 0x000fe40000800000ULL,
0xff80000031317808ULL, 0x000fe40003000000ULL, 0xff80000032327808ULL, 0x000fe40002000000ULL,
0x000000674cff7212ULL, 0x040fe4000780c0ffULL, 0x0000002ca5ff7212ULL, 0x080fe4000786c0ffULL,
0x0000002c4cff7212ULL, 0x000fc4000784c0ffULL, 0x0000005fa3ff7212ULL, 0x080fe400078ac0ffULL,
0x0000005fa4ff7212ULL, 0x080fe4000782c0ffULL, 0x0000005fa5ff7212ULL, 0x080fe400078cc0ffULL,
0x0000005f4cff7212ULL, 0x000fe4000788c0ffULL, 0x000000ab5b00720cULL, 0x080fe40002fa1470ULL,
0x000000ab5a00720cULL, 0x000fc40000f21470ULL, 0x000000ab5700720cULL, 0x0c0fe40001f61470ULL,
0x000000ab5700720cULL, 0x080fe400037c1470ULL, 0x000000ab5500720cULL, 0x0c0fe40000701470ULL,
0x000000ab5500720cULL, 0x0c0fe40001741470ULL, 0x000000ab5500720cULL, 0x080fe40002781470ULL,
0x000000ab5300720cULL, 0x000fc40002fa1070ULL, 0x000000ab5800720cULL, 0x080fe40000f21070ULL,
0x000000ab5400720cULL, 0x080fe40000701070ULL, 0x000000ab5600720cULL, 0x0c0fe40001f61070ULL,
0x000000ab5600720cULL, 0x080fe400037c1070ULL, 0x000000ab5400720cULL, 0x0c0fe40001741070ULL,
0x000000ab5400720cULL, 0x000fc40002781070ULL, 0xff80000033337808ULL, 0x000fe40000000000ULL,
0xff8000000c0c7808ULL, 0x000fe40001800000ULL, 0xff8000000e0e7808ULL, 0x000fe40001000000ULL,
0xff80000016167808ULL, 0x000fe40002800000ULL, 0xff80000017177808ULL, 0x000fe40000800000ULL,
0xff8000000f0f7808ULL, 0x000fc40003000000ULL, 0xff80000010107808ULL, 0x000fce0002000000ULL,
0x0000000b0400720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0xfffffff8ff597812ULL, 0x000fe200078ee259ULL, 0x0000000163637836ULL, 0x000fe20000000000ULL,
0x000000040b047208ULL, 0x000fc80004000000ULL, 0x0000004d0400720bULL, 0x000fc80003f1e000ULL,
0x000000044d137208ULL, 0x000fc80004000000ULL, 0x000000481300720bULL, 0x000fc80003f1e000ULL,
0x0000001348027208ULL, 0x000fc80004000000ULL, 0x000000490200720bULL, 0x000fc80003f1e000ULL,
0x0000000249137208ULL, 0x000fc80004000000ULL, 0x000000441300720bULL, 0x000fc80003f1e000ULL,
0x0000001344027208ULL, 0x000fc80004000000ULL, 0x000000450200720bULL, 0x000fc80003f1e000ULL,
0x0000000245137208ULL, 0x000fc80004000000ULL, 0x000000401300720bULL, 0x000fc80003f1e000ULL,
0x0000001340027208ULL, 0x000fc80004000000ULL, 0x000000410200720bULL, 0x000fc80003f1e000ULL,
0x0000000241137208ULL, 0x000fc80004000000ULL, 0x0000003c1300720bULL, 0x000fc80003f1e000ULL,
0x000000133c027208ULL, 0x000fc80004000000ULL, 0x0000003d0200720bULL, 0x000fc80003f1e000ULL,
0x000000023d137208ULL, 0x000fc80004000000ULL, 0x000000381300720bULL, 0x000fc80003f1e000ULL,
0x0000001338027208ULL, 0x000fc80004000000ULL, 0x000000390200720bULL, 0x000fc80003f1e000ULL,
0x0000000239137208ULL, 0x000fc80004000000ULL, 0x000000341300720bULL, 0x000fc80003f1e000ULL,
0x0000001334027208ULL, 0x000fc80004000000ULL, 0x000000350200720bULL, 0x000fc80003f1e000ULL,
0x0000000235137208ULL, 0x000fc80004000000ULL, 0x000000301300720bULL, 0x000fc80003f1e000ULL,
0x0000001330027208ULL, 0x000fe40004000000ULL, 0x0000004e0500720bULL, 0x000fe40003f1e000ULL,
0x000000310200720bULL, 0x000fc80003f3e000ULL, 0x0000000231047208ULL, 0x000fe40004800000ULL,
0x000000054e027208ULL, 0x000fc60004000000ULL, 0x0c401f0004137f89ULL, 0x000ea200000e0000ULL,
0x0000004f0200720bULL, 0x000fc80003f1e000ULL, 0x000000024f057208ULL, 0x000fc80004000000ULL,
0x0000004a0500720bULL, 0x000fc80003f1e000ULL, 0x000000054a027208ULL, 0x000fc80004000000ULL,
0x0000004b0200720bULL, 0x000fc80003f1e000ULL, 0x000000024b057208ULL, 0x000fe40004000000ULL,
0x000000130400720bULL, 0x004fe40003f3e000ULL, 0x000000460500720bULL, 0x000fe40003f1e000ULL,
0x0000000413137208ULL, 0x000fe40004800000ULL, 0x0000000546027208ULL, 0x000fc60004000000ULL,
0x0c201f0013047f89ULL, 0x000ea200000e0000ULL, 0x000000470200720bULL, 0x000fc80003f1e000ULL,
0x0000000247057208ULL, 0x000fc80004000000ULL, 0x000000420500720bULL, 0x000fc80003f1e000ULL,
0x0000000542027208ULL, 0x000fc80004000000ULL, 0x000000430200720bULL, 0x000fc80003f1e000ULL,
0x0000000243057208ULL, 0x000fe40004000000ULL, 0x000000041300720bULL, 0x004fe40003f3e000ULL,
0x0000003e0500720bULL, 0x000fe40003f1e000ULL, 0x0000001304047208ULL, 0x000fe40004800000ULL,
0x000000053e027208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b044c7820ULL, 0x000fe20000410000ULL,
0x0000003f0200720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b0b127823ULL, 0x100fe2000001084cULL,
0x000000023f057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b482c7823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b4d137823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b34507823ULL, 0x100fe2000001084cULL,
0x0000003a0500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b30347823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b49497823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b44447823ULL, 0x100fe2000001084cULL,
0x000000053a027208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b45457823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b40407823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b41417823ULL, 0x100fe2000001084cULL,
0x0000003b0200720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe2000001084cULL, 0x3fb8aa3b38387823ULL, 0x100fe2000001084cULL,
0x000000023b057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b39397823ULL, 0x100fe2000001084cULL,
0x3fb8aa3b31317823ULL, 0x000fe2000001084cULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x000000360500720bULL, 0x000fc80003f1e000ULL, 0x0000000536027208ULL, 0x000fc60004000000ULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x000000370200720bULL, 0x000fc80003f1e000ULL,
0x0000000237057208ULL, 0x000fc60004000000ULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0x000000320500720bULL, 0x000fc80003f1e000ULL, 0x0000000532027208ULL, 0x000fc60004000000ULL,
0x0000004900497308ULL, 0x000fe20000000800ULL, 0x000000330200720bULL, 0x000fc80003f1e000ULL,
0x00000002330b7208ULL, 0x000fe40004000000ULL, 0x0000000d0600720bULL, 0x000fe20003f1e000ULL,
0x0000004000407308ULL, 0x000fe40000000800ULL, 0x0c401f000b487f89ULL, 0x000ee200000e0000ULL,
0x000000060d067208ULL, 0x000fc80004000000ULL, 0x0000002d0600720bULL, 0x000fe20003f1e000ULL,
0x0000004100417308ULL, 0x000fe60000000800ULL, 0x000000062d057208ULL, 0x000fc80004000000ULL,
0x000000280500720bULL, 0x000fe20003f1e000ULL, 0x0000004400447308ULL, 0x000fe60000000800ULL,
0x0000000528027208ULL, 0x000fc80004000000ULL, 0x000000290200720bULL, 0x000fe20003f1e000ULL,
0x0000004500457308ULL, 0x000fe20000000800ULL, 0x000000480b00720bULL, 0x008fe40003f3e000ULL,
0x0000000229057208ULL, 0x000fe40004000000ULL, 0x0000000b48487208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b350b7823ULL, 0x000fe2000001084cULL, 0x000000240500720bULL, 0x000fe20003f1e000ULL,
0x0000003c003c7308ULL, 0x000fe40000000800ULL, 0x0c201f00484d7f89ULL, 0x000ee200000e0000ULL,
0x0000000524027208ULL, 0x000fc80004000000ULL, 0x000000250200720bULL, 0x000fe20003f1e000ULL,
0x0000003d003d7308ULL, 0x000fe60000000800ULL, 0x0000000225057208ULL, 0x000fc80004000000ULL,
0x000000200500720bULL, 0x000fe20003f1e000ULL, 0x0000005000027308ULL, 0x0009e60000000800ULL,
0x0000000520067208ULL, 0x000fc80004000000ULL, 0x000000210600720bULL, 0x000fe20003f1e000ULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0x0000004d4800720bULL, 0x008fe40003f3e000ULL,
0x0000000621357208ULL, 0x000fe40004000000ULL, 0x000000484d057208ULL, 0x000fe40004800000ULL,
0x0000001c3500720bULL, 0x000fe20003f1e000ULL, 0x0000003900397308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b05507820ULL, 0x010fe20000410000ULL, 0x000000351c067208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b4f4d7823ULL, 0x100fe20000010850ULL, 0x0000001d0600720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b4e487823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010850ULL, 0x000000061d357208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010850ULL, 0x000000183500720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b43437823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010850ULL, 0x0000003518067208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3b3b7823ULL, 0x000fe20000010850ULL, 0x0000004800487308ULL, 0x000fe40000000800ULL,
0x000000190600720bULL, 0x000fc80003f1e000ULL, 0x0000000619357208ULL, 0x000fe40004000000ULL,
0x0000002e0700720bULL, 0x000fe20003f1e000ULL, 0x0000004d004d7308ULL, 0x000ee20000000800ULL,
0x000000143500720bULL, 0x000fe40003f3e000ULL, 0x000000072e067208ULL, 0x000fe40004000000ULL,
0x0000003514307208ULL, 0x000fe40004800000ULL, 0x0000002f0600720bULL, 0x000fe20003f1e000ULL,
0x0000004a004a7308ULL, 0x000fe20000000800ULL, 0x000000153000720bULL, 0x000fc40003f3e000ULL,
0x000000062f077208ULL, 0x000fe40004000000ULL, 0x0000003015357208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b3e307823ULL, 0x100fe20000010850ULL, 0x0000002a0700720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b333e7823ULL, 0x000fe20000010850ULL, 0x0000000c3500720bULL, 0x000fe20003f3e000ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x000000072a067208ULL, 0x000fe40004000000ULL,
0x000000350c357208ULL, 0x000fc40004800000ULL, 0x0000002b0600720bULL, 0x000fe40003f1e000ULL,
0x0000000e3500720bULL, 0x000fe20003f3e000ULL, 0x0000004600467308ULL, 0x000fe20000000800ULL,
0x000000062b077208ULL, 0x000fe40004000000ULL, 0x000000350e357208ULL, 0x000fe40004800000ULL,
0x000000260700720bULL, 0x000fc60003f1e000ULL, 0x0c401f00354c7f89ULL, 0x000f2200000e0000ULL,
0x0000000726067208ULL, 0x000fe20004000000ULL, 0x0000004700477308ULL, 0x000f660000000800ULL,
0x000000270600720bULL, 0x000fc80003f1e000ULL, 0x0000000627077208ULL, 0x000fe20004000000ULL,
0x0000004200427308ULL, 0x000fe60000000800ULL, 0x000000220700720bULL, 0x000fc80003f1e000ULL,
0x0000000722067208ULL, 0x000fe20004000000ULL, 0x0000004300437308ULL, 0x000fe60000000800ULL,
0x000000230600720bULL, 0x000fe40003f1e000ULL, 0x0000004c3500720bULL, 0x010fe40003f3e000ULL,
0x0000000623077208ULL, 0x000fe20004000000ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x000000354c4c7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b36357823ULL, 0x100fe20000010850ULL,
0x0000001e0700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b37367823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b32377823ULL, 0x000fe20000010850ULL, 0x0c201f004c4f7f89ULL, 0x000f2200000e0000ULL,
0x000000071e067208ULL, 0x000fe20004000000ULL, 0x0000003f003f7308ULL, 0x000fe60000000800ULL,
0x0000001f0600720bULL, 0x000fc80003f1e000ULL, 0x000000061f077208ULL, 0x000fe20004000000ULL,
0x0000003a003a7308ULL, 0x000fe60000000800ULL, 0x0000001a0700720bULL, 0x000fc80003f1e000ULL,
0x000000071a067208ULL, 0x000fe20004000000ULL, 0x0000003b003b7308ULL, 0x000fe60000000800ULL,
0x0000001b0600720bULL, 0x000fe40003f1e000ULL, 0x0000004f4c00720bULL, 0x010fe40003f3e000ULL,
0x000000061b077208ULL, 0x000fe20004000000ULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x0000004c4f067208ULL, 0x000fc40004800000ULL, 0x000000160700720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b06517820ULL, 0x000fe20000410000ULL, 0x0000000716327208ULL, 0x000fe20004000000ULL,
0x0000003100317308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b28337823ULL, 0x100fe20000010851ULL,
0x000000173200720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b1c527823ULL, 0x100fe20000010851ULL,
0x3fb8aa3b0c4e7823ULL, 0x100fe20000010851ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010851ULL,
0x0000003217327208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010851ULL,
0x3fb8aa3b144c7823ULL, 0x100fe20000010851ULL, 0x0000000d00567308ULL, 0x0009e20000000800ULL,
0x0000000f3200720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010851ULL,
0x3fb8aa3b20507823ULL, 0x100fe20000010851ULL, 0x3fb8aa3b21537823ULL, 0x100fe20000010851ULL,
0x000000320f077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b25327823ULL, 0x100fe20000010851ULL,
0x3fb8aa3b1d557823ULL, 0x100fe20000010851ULL, 0x0000003300577308ULL, 0x0007e20000000800ULL,
0x000000100700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b240d7823ULL, 0x110fe20000010851ULL,
0x3fb8aa3b19547823ULL, 0x100fe20000010851ULL, 0x3fb8aa3b154f7823ULL, 0x000fe20000010851ULL,
0x0000000710077208ULL, 0x000fc40004000000ULL, 0x000000121324723eULL, 0x004fe200000010ffULL,
0x0000002900587308ULL, 0x000be20000000800ULL, 0x3fb8aa3b18337823ULL, 0x10afe20000010851ULL,
0x0c401f0007287f89ULL, 0x000e6200000e0000ULL, 0x3fb8aa3b0e517823ULL, 0x000fe20000010851ULL,
0x00000004ff127e24ULL, 0x000fe2000f8e00ffULL, 0x000000484d25723eULL, 0x000fe200000010ffULL,
0x00000008594d7836ULL, 0x000fe40000000000ULL, 0x0000002d002d7308ULL, 0x000ea20000000800ULL,
0x3f8000001212783eULL, 0x000fc400000010ffULL, 0x000000464729723eULL, 0x020fca00000010ffULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x000000562d20723eULL, 0x004fce00000010ffULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x0000001059567836ULL, 0x000fe20000000000ULL,
0x000000280700720bULL, 0x002fc80003f1e000ULL, 0x0000000728077208ULL, 0x000fe40004000000ULL,
0x000000444528723eULL, 0x000fe200000010ffULL, 0x0000005000507308ULL, 0x000fe40000000800ULL,
0x0c201f00071c7f89ULL, 0x000e6c00000e0000ULL, 0x0000005300537308ULL, 0x000ff00000000800ULL,
0x0000005200527308ULL, 0x000ff00000000800ULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x0000001c0700720bULL, 0x002fc80003f1e000ULL, 0x000000071c077208ULL, 0x000fc60004000000ULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x0000000309ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b070c7820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2a147823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001080cULL, 0x0000002e00217308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b27137823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b26187823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b221c7823ULL, 0x100fe2000001080cULL, 0x0000002c4926723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080cULL, 0x0000004a4b27723eULL, 0x000fe200000010ffULL,
0x0000000856497824ULL, 0x000fe200078e00ffULL, 0x0000002f000e7308ULL, 0x000e620000000800ULL,
0x000000575822723eULL, 0x000fe200000010ffULL, 0x0000001859577836ULL, 0x000fe20000000000ULL,
0x00000003ff587819ULL, 0x000fe20000011609ULL, 0x3fb8aa3b1a1a7823ULL, 0x000fe2000001080cULL,
0x00000040412a723eULL, 0x000fe200000010ffULL, 0x000000084d417824ULL, 0x000fc400078e00ffULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001080cULL, 0x0000001400147308ULL, 0x000fe20000000800ULL,
0x00000008574b7824ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b0f4a7823ULL, 0x100fe2000001080cULL,
0x000000084d4d7824ULL, 0x000fe400078e00ffULL, 0x0000000857577824ULL, 0x000fe200078e00ffULL,
0x000000210e21723eULL, 0x002fe200000010ffULL, 0x0000002b00157308ULL, 0x0002a20000000800ULL,
0x3fb8aa3b230e7823ULL, 0x000fce000001080cULL, 0x0000001300197308ULL, 0x0007e20000000800ULL,
0x00000042432b723eULL, 0x002fe200000010ffULL, 0x0000000859437824ULL, 0x040fe400078e00ffULL,
0x0000000859597824ULL, 0x000fe200078e00ffULL, 0x000000141523723eULL, 0x004fe200000010ffULL,
0x000000ffff157224ULL, 0x000fe200078e0012ULL, 0x0000000409147810ULL, 0x000fe20007ffe058ULL,
0x000000ffff137224ULL, 0x108fe200078e0012ULL, 0x0000000e00457308ULL, 0x0003e40000000800ULL,
0x0000000714407812ULL, 0x000fe200078ec0ffULL, 0x000000ffff147224ULL, 0x000fc600078e0012ULL,
0x00000012242c723cULL, 0x000fe200000418ffULL, 0xfffffff843437812ULL, 0x000fe200078ee240ULL,
0x0000001c00447308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b1f0e7823ULL, 0x102fe2000001080cULL,
0xfffffff841417812ULL, 0x000fe400078ee240ULL, 0xfffffff849427812ULL, 0x000fe200078ee240ULL,
0x3fb8aa3b17497823ULL, 0x100fe2000001080cULL, 0xfffffff84b407812ULL, 0x000fe200078ee240ULL,
0x3fb8aa3b104b7823ULL, 0x000fe2000001080cULL, 0x0000001e00467308ULL, 0x0003e20000000800ULL,
0x0000003a3b17723eULL, 0x000fe200000010ffULL, 0x000000ffff3a7224ULL, 0x000fc400078e0012ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0012ULL, 0x00000044450f723eULL, 0x004fc600000010ffULL,
0x0000001800187308ULL, 0x000ea20000000800ULL, 0x00000014201c723cULL, 0x002fec00000418ffULL,
0x00000012282c723cULL, 0x000fe2000004182cULL, 0x0000000e00477308ULL, 0x0002e20000000800ULL,
0x0000003c3d14723eULL, 0x000fc800000010ffULL, 0x000000ffff3c7224ULL, 0x100fe200078e0012ULL,
0x000000303f15723eULL, 0x000fe200000010ffULL, 0x000000ffff3d7224ULL, 0x000fe200078e0012ULL,
0x0000000358307812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b16137823ULL, 0x000fe2000001080cULL,
0x0000000d320c723eULL, 0x000fe200000010ffULL, 0x0000005400547308ULL, 0x000f220000000800ULL,
0x00000050530e723eULL, 0x002fe200000010ffULL, 0x0000000130307824ULL, 0x000fe200078e0209ULL,
0x00000018190d723eULL, 0x004fe400000010ffULL, 0x000000383916723eULL, 0x000fe200000010ffULL,
0x000000ffff387224ULL, 0x100fe200078e0012ULL, 0x000000525518723eULL, 0x000fe200000010ffULL,
0x0000001a00487308ULL, 0x0009e20000000800ULL, 0x000000ffff397224ULL, 0x000fe200078e0012ULL,
0x0000003c0c1c723cULL, 0x000fe2000004181cULL, 0x000000464719723eULL, 0x008fc400000010ffULL,
0x0000000730307812ULL, 0x000fe400078ec0ffULL, 0x000000343132723eULL, 0x000fe200000010ffULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x00000033541a723eULL, 0x010fe200000010ffULL,
0x00000038142c723cULL, 0x000fe2000004182cULL, 0x0000000856337824ULL, 0x000fe200078e00ffULL,
0xfffffff84d3c7812ULL, 0x000fc800078ee230ULL, 0x000000ffff3d7224ULL, 0x000fe200078e0016ULL,
0xfffffff857467812ULL, 0x000fe200078ee230ULL, 0x000000ffff3f7224ULL, 0x000fe200078e0032ULL,
0x0000003500357308ULL, 0x000fe20000000800ULL, 0xfffffff859387812ULL, 0x000fe200078ee230ULL,
0x000000ffff397224ULL, 0x000fe200078e0026ULL, 0xfffffff833447812ULL, 0x000fe200078ee230ULL,
0x000000ffff267224ULL, 0x000fe400078e0029ULL, 0x000000ffff297224ULL, 0x000fe200078e0022ULL,
0x000000481b1b723eULL, 0x002fe200000010ffULL, 0x0000003600367308ULL, 0x000e620000000800ULL,
0x000000ffff227224ULL, 0x000fc600078e000dULL, 0x000000ffff0d7224ULL, 0x000fe400078e001bULL,
0x0000003a181c723cULL, 0x000fe4000004181cULL, 0x0000000b000b7308ULL, 0x000ea20000000800ULL,
0x000000353631723eULL, 0x002fce00000010ffULL, 0x0000003700377308ULL, 0x000fe20000000800ULL,
0x000000ffff167224ULL, 0x000fe200078e0031ULL, 0x000000020b30723eULL, 0x004fcc00000010ffULL,
0x0000003e003e7308ULL, 0x000e620000000800ULL, 0x0000100077027824ULL, 0x000fc800078e0208ULL,
0x00012000020b7836ULL, 0x000fc60000000000ULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x0000001038027824ULL, 0x000fe400078e020bULL, 0x000000ffff387224ULL, 0x000fe400078e0024ULL,
0x000000ffff247224ULL, 0x000fe200078e0025ULL, 0x000000373e33723eULL, 0x002fe400000010ffULL,
0x0000004900107308ULL, 0x000e620000000800ULL, 0x0000001043437824ULL, 0x000fe400078e020bULL,
0x000000ffff3e7224ULL, 0x000fc400078e0030ULL, 0x000000ffff257224ULL, 0x000fe200078e0027ULL,
0x0000003a302c723cULL, 0x000fe2000004182cULL, 0x000000ffff277224ULL, 0x000fe200078e002bULL,
0x0000004c004c7308ULL, 0x000fe20000000800ULL, 0x0000001041417824ULL, 0x100fe400078e020bULL,
0x0000001044447824ULL, 0x000fe400078e020bULL, 0x000000ffff3a7224ULL, 0x000fe200078e0028ULL,
0x000000131035723eULL, 0x002fe400000010ffULL, 0x0000004f004f7308ULL, 0x000e620000000800ULL,
0x000000ffff137224ULL, 0x000fc400078e0012ULL, 0x000000103c107824ULL, 0x000fe400078e020bULL,
0x000000ffff3b7224ULL, 0x000fe400078e002aULL, 0x000000ffff3c7224ULL, 0x000fe200078e0014ULL,
0x0000004e004e7308ULL, 0x000fe20000000800ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0x0000003802007844ULL, 0x0005e20000000200ULL, 0x000000ffff157224ULL, 0x000fe400078e0017ULL,
0x000000ffff177224ULL, 0x000fe200078e0033ULL, 0x0000003c43007844ULL, 0x0007e20000000200ULL,
0x0000004c4f34723eULL, 0x002fe200000010ffULL, 0x0000005100517308ULL, 0x000e620000000800ULL,
0x000000ffff287224ULL, 0x000fe200078e0020ULL, 0x0000002410007844ULL, 0x0007e20000000200ULL,
0x000000ffff2a7224ULL, 0x000fc400078e000cULL, 0x000000ffff2b7224ULL, 0x000fe200078e000eULL,
0x0000001441007844ULL, 0x0007e20000000200ULL, 0x000000ffff207224ULL, 0x000fe200078e0021ULL,
0x0000004a004a7308ULL, 0x000fe20000000800ULL, 0x0000001042427824ULL, 0x000fe200078e020bULL,
0x0000002844007844ULL, 0x0007e20000000200ULL, 0x000000ffff307224ULL, 0x000fe400078e0018ULL,
0x000000ffff317224ULL, 0x000fe200078e001aULL, 0x0000004e5136723eULL, 0x002fe400000010ffULL,
0x0000004b004b7308ULL, 0x000e620000000800ULL, 0x000000ffff327224ULL, 0x000fc400078e0034ULL,
0x000000ffff217224ULL, 0x000fe400078e0023ULL, 0x000000ffff337224ULL, 0x000fe400078e0036ULL,
0x0000001046467824ULL, 0x000fe400078e020bULL, 0x000000ffff237224ULL, 0x000fe200078e000fULL,
0x0000003042007844ULL, 0x0007e20000000200ULL, 0x0000001040407824ULL, 0x000fe400078e020bULL,
0x000000ffff0c7224ULL, 0x000fe200078e0019ULL, 0x0000002046007844ULL, 0x0007e20000000200ULL,
0x0000004a4b37723eULL, 0x002fe200000010ffULL, 0x000000ffff0e7224ULL, 0x000fc400078e0035ULL,
0x000000ffff2d7224ULL, 0x000fe400078e002eULL, 0x000000ffff0f7224ULL, 0x000fe400078e0037ULL,
0x00000012341c723cULL, 0x000fe2000004181cULL, 0x00000001ff027424ULL, 0x004fe400078e00ffULL,
0x0000000c40007844ULL, 0x0007e20000000200ULL, 0x000000ffff0b7224ULL, 0x000fc600078e000aULL,
0x01a0000411008388ULL, 0x0007de0000000c00ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000ffff2e7224ULL, 0x000fe400078e001cULL, 0x000000ffff2f7224ULL, 0x000fca00078e001eULL,
0x01a2002c11008388ULL, 0x0007e20000000c00ULL, 0x000000606300720cULL, 0x000fe20003f06070ULL,
0x01a6080265ff79a7ULL, 0x0007e2000850003fULL, 0x01a6100265ff79a7ULL, 0x0007e2000850003fULL,
0x01a6180265ff79a7ULL, 0x0007e2000850003fULL, 0x01a6200265ff79a7ULL, 0x0007f2000850003fULL,
0xffffff9000288947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x018000007d007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000007d00008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff7dff7812ULL, 0x040fe4000780c0ffULL, 0x800000007d027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000007d00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffe8c02f07950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004ebULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000668ULL, 0x0000000000000228ULL, 0x0000001500000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000890ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000970ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c4ULL, 0x0000000000000710ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010d8ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010d8ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001120ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000017100ULL, 0x0000001500000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018280ULL, 0x0000000000000040ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000182c0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000182c0ULL, 0x0000000000000270ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x00000000000188b0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000188b0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000001120ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000017100ULL,
0x0000000000017100ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000018280ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000182c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000270ULL, 0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_90_cubin_len = 100864;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
