/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001e240ULL, 0x000000000001dec0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL,
0x326d735f61647563ULL, 0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL,
0x746e695f5f240068ULL, 0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL,
0x66625f636e79736cULL, 0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL,
0x5f30376d735f6164ULL, 0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL,
0x5f5f245f335f6c61ULL, 0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL,
0x2e616c65722e0074ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL,
0x766e2e0066754265ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL,
0x65642e006d617261ULL, 0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL,
0x616c65722e00656dULL, 0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL,
0x00000000006e6f69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000037fULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000003cdULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b002200000413ULL,
0x000000000001c2f0ULL, 0x0000000000000180ULL, 0x000b002200000446ULL, 0x000000000001c470ULL,
0x0000000000000040ULL, 0x000b002200000471ULL, 0x000000000001c4b0ULL, 0x0000000000000050ULL,
0x000b00220000049bULL, 0x000000000001c500ULL, 0x0000000000000100ULL, 0x000a000300000509ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000529ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000559ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001c600ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001c2f000000000ULL, 0x0000040400000000ULL, 0x810c000001880400ULL, 0x006f280400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001c2f000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808508288080ULL, 0x8087082880808608ULL, 0x0828808088082880ULL, 0x80809f082880809dULL,
0xbe08288080a50828ULL, 0x288080ea08288080ULL, 0x80f008288080ef08ULL, 0x08288080f1082880ULL,
0x80828016288080d2ULL, 0x0000000000031028ULL, 0x288080d292000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x000000f000000000ULL, 0x0001c47000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808508288080ULL, 0x8087082880808608ULL, 0x0828808088082880ULL, 0x80809f082880809dULL,
0xbe08288080a60828ULL, 0x288080ea08288080ULL, 0x80f008288080ef08ULL, 0x08288080f1082880ULL,
0x80828016288080a5ULL, 0x0000000000031028ULL, 0x288080a592000000ULL, 0x0000000000002200ULL,
0x0000002cffffffffULL, 0x000001b000000000ULL, 0x0001c4b000000000ULL, 0x0000005000000000ULL,
0x0000040400000000ULL, 0x80ea288080a50900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808508288080ULL, 0x8087082880808608ULL,
0x0828808088082880ULL, 0x80809f082880809dULL, 0xbe08288080a50828ULL, 0x288080ea08288080ULL,
0x80f008288080ef08ULL, 0x08288080f1082880ULL, 0x80828016288080a6ULL, 0x0000000000031028ULL,
0x288080a692000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000028000000000ULL,
0x0001c50000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL,
0x00082304000000f3ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL,
0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0060016000000016ULL, 0x000c170400601903ULL, 0x0058000a00000000ULL,
0x000c17040021f000ULL, 0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL,
0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040061f000ULL, 0x0028000600000000ULL,
0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000eb000043104ULL, 0xffffffff019c2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000002f0019c2804ULL, 0x000005a000000360ULL,
0x00002b3000002a80ULL, 0x00002db000002c40ULL, 0x0000308000002f20ULL, 0x0000354000003500ULL,
0x0000358000003550ULL, 0x00006660000065c0ULL, 0x000068e000006770ULL, 0x00006bb000006a50ULL,
0x0000704000007000ULL, 0x0000708000007050ULL, 0x0000a08000009fe0ULL, 0x0000a3000000a190ULL,
0x0000a5d00000a470ULL, 0x0000aa700000aa30ULL, 0x0000aab00000aa80ULL, 0x0000d9d00000d930ULL,
0x0000dc500000dae0ULL, 0x0000df200000ddc0ULL, 0x0000e3c00000e380ULL, 0x0000e4000000e3d0ULL,
0x000107f0000107e0ULL, 0x0001081000010800ULL, 0x0001a1800001a140ULL, 0x0001a1a00001a190ULL,
0x0001a2100001a1f0ULL, 0x0001a2400001a230ULL, 0x0001b6c00001b670ULL, 0x0001b7300001b700ULL,
0x0001b7900001b760ULL, 0x0001b8100001b7d0ULL, 0x0001b8900001b850ULL, 0x0001b9300001b8e0ULL,
0x0001b9a00001b970ULL, 0x0001ba000001b9d0ULL, 0x0001ba800001ba40ULL, 0x0001bb000001bac0ULL,
0x0001bba00001bb50ULL, 0x0001bc100001bbe0ULL, 0x0001bc700001bc40ULL, 0x0001bcf00001bcb0ULL,
0x0001bd700001bd30ULL, 0x0001be100001bdc0ULL, 0x0001be800001be50ULL, 0x0001bee00001beb0ULL,
0x0001bf600001bf20ULL, 0x0001bfe00001bfa0ULL, 0x0001c0900001c030ULL, 0x0001c1500001c0f0ULL,
0x0001c2100001c1b0ULL, 0x0001c2d00001c270ULL, 0x0000041004403904ULL, 0x00012600000000ffULL,
0x00000440003f0100ULL, 0x000126080000000fULL, 0x000004c0003f0120ULL, 0x000126880000000fULL,
0x00000520003f0120ULL, 0x000126a80000000fULL, 0x00000530003f0120ULL, 0x000126c80000000fULL,
0x00000ed0003f0120ULL, 0x00012600000000ffULL, 0x00001020003f0107ULL, 0x0001268c00000014ULL,
0x000010b0003f0102ULL, 0x0001268800000014ULL, 0x000019e0003f0101ULL, 0x00000000000000ffULL,
0x00001a6000040107ULL, 0x00000000000000ffULL, 0x00001ac000040101ULL, 0x0000002000000002ULL,
0x00001c30003f0101ULL, 0x000126cc00000008ULL, 0x00001e00003f0105ULL, 0x000126cc00000008ULL,
0x00002620003f0105ULL, 0x000126b00000001fULL, 0x000026e0003f0107ULL, 0x000126b00000001fULL,
0x00002740003f0101ULL, 0x000126080000001cULL, 0x00002780003f0101ULL, 0x0001260c00000020ULL,
0x00002960003f0105ULL, 0x0001260c00000020ULL, 0x00003230003f0105ULL, 0x000126ac0000001fULL,
0x00003420003f0105ULL, 0x000126ac0000001fULL, 0x000057e0003f0105ULL, 0x000000000000006aULL,
0x00005840003f0101ULL, 0x000126880000001fULL, 0x00005870003f0101ULL, 0x000000040000000dULL,
0x00005a30003f0105ULL, 0x000000040000000dULL, 0x00006180003f0105ULL, 0x0000000000000008ULL,
0x00006260003f0107ULL, 0x0000000000000008ULL, 0x000062c0003f0101ULL, 0x0001262800000020ULL,
0x00006320003f0101ULL, 0x0001262c00000021ULL, 0x000064f0003f0105ULL, 0x0001262c00000021ULL,
0x00006d70003f0105ULL, 0x000126b40000006aULL, 0x00006f40003f0105ULL, 0x000126b40000006aULL,
0x00009260003f0105ULL, 0x000000000000006aULL, 0x000092c0003f0101ULL, 0x0001269000000026ULL,
0x000092f0003f0101ULL, 0x000000040000000dULL, 0x000094b0003f0105ULL, 0x000000040000000dULL,
0x00009c30003f0105ULL, 0x00000008000000ffULL, 0x00009cc000040107ULL, 0x000126b000000068ULL,
0x00009d20003f0101ULL, 0x0001264800000020ULL, 0x00009d40003f0101ULL, 0x0001264c00000020ULL,
0x00009f10003f0105ULL, 0x0001264c00000020ULL, 0x0000a790003f0105ULL, 0x0000000400000008ULL,
0x0000a960003f0105ULL, 0x0000000400000008ULL, 0x0000cb80003f0105ULL, 0x000000000000006aULL,
0x0000cbe0003f0101ULL, 0x0001269800000023ULL, 0x0000cc10003f0101ULL, 0x000000040000000dULL,
0x0000cdd0003f0105ULL, 0x000000040000000dULL, 0x0000d570003f0105ULL, 0x00000000000000ffULL,
0x0000d62000040107ULL, 0x0000000000000008ULL, 0x0000d680003f0101ULL, 0x000126680000000cULL,
0x0000d6b0003f0101ULL, 0x0001266c0000000cULL, 0x0000d880003f0105ULL, 0x0001266c0000000cULL,
0x0000e0e0003f0105ULL, 0x000126b400000020ULL, 0x0000e2b0003f0105ULL, 0x000126b400000020ULL,
0x00010530003f0105ULL, 0x000000000000000dULL, 0x000105b0003f0101ULL, 0x0000000000000008ULL,
0x00012830003f0101ULL, 0x00012600000000ffULL, 0x00013410003f0101ULL, 0x00012604000000ffULL,
0x00013620003f0105ULL, 0x00012604000000ffULL, 0x000139a0003f0105ULL, 0x00012600000000ffULL,
0x000139d0003f0101ULL, 0x00012604000000ffULL, 0x00013b90003f0105ULL, 0x00012604000000ffULL,
0x00017380003f0105ULL, 0x000000000000005eULL, 0x000174a0003f0101ULL, 0x000000040000005eULL,
0x00017670003f0105ULL, 0x000000040000005eULL, 0x0001b4d0003f0105ULL, 0x0000000000000065ULL,
0x0001b530003f0101ULL, 0x0000000800000065ULL, 0x0001b590003f0101ULL, 0x0000001000000065ULL,
0x0001b600003f0101ULL, 0x0000001800000065ULL, 0x00053803003f0101ULL, 0x0001176000301c04ULL,
0x00011a2000011790ULL, 0x00011e0000011c10ULL, 0x000121e000011ff0ULL, 0x000125d0000123d0ULL,
0x00013bf000012780ULL, 0x000004010001b640ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000032cULL,
0x0000001900000002ULL, 0x000000000000025cULL, 0x0000001900000002ULL, 0x000000000000019cULL,
0x0000001900000002ULL, 0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL,
0x0000001900000002ULL, 0x0000000000000303ULL, 0x0000001900000002ULL, 0x0000000000000233ULL,
0x0000001900000002ULL, 0x0000000000000173ULL, 0x0000001900000002ULL, 0x00000000000000a8ULL,
0x0000001900000002ULL, 0x0000000000012700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000e7919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff030424ULL, 0x000fe200078e00ffULL,
0x000000010e040810ULL, 0x002fca0007ffe0ffULL, 0x00005c0004040625ULL, 0x000fc800078e0003ULL,
0x00005c000e020625ULL, 0x000fe200078e0003ULL, 0x00000006045f0981ULL, 0x0002aa000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff107624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000087919ULL, 0x000e620000002600ULL, 0x00005a00ff117624ULL, 0x000fc600078e00ffULL,
0x00000000000d7919ULL, 0x000e620000002300ULL, 0x0000590011117a24ULL, 0x000fc600078e02ffULL,
0x00000000001a7919ULL, 0x000e620000002100ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00067810ULL, 0x010fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x000864000021f000ULL,
0x000000ffff067224ULL, 0x010fe400078e00ffULL, 0x000000ffff097224ULL, 0x002fc800078e0a07ULL,
0x0000590009097a24ULL, 0x000fc800078e02ffULL, 0x0000000907077227ULL, 0x000fe400078e0006ULL,
0x0000000000067919ULL, 0x000e680000002200ULL, 0x0000040007097a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x008fc800078e0a09ULL, 0x0000040003007624ULL, 0x000fca00078e0210ULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x8000590000001a10ULL, 0x000fe40007ffe0ffULL,
0x0000000109091810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f46070ULL,
0x0000000109092810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff09ba12ULL, 0x000fc800078e33ffULL,
0x0000000900007306ULL, 0x000ee20000209000ULL, 0x000000ff0900720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x008ee40000001000ULL, 0x0ffffffe00047810ULL, 0x008fcc0007ffe0ffULL,
0x0000000400057305ULL, 0x000724000021f000ULL, 0x000000ffff047224ULL, 0x008fe400078e00ffULL,
0x0000000509037224ULL, 0x010fc800078e02ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a03ULL,
0x0000000305057227ULL, 0x000fc800078e0004ULL, 0x000001000d037a24ULL, 0x002fe400078e0206ULL,
0x00000008051b7227ULL, 0x000fe200078e00ffULL, 0x00001fff0d0d7589ULL, 0x000fe600000e0000ULL,
0x000000ffff007224ULL, 0x000fe400078e0a1bULL, 0x00000000030f7a24ULL, 0x100fe200078e021aULL,
0x00000005ff1a7819ULL, 0x000fe2000001161aULL, 0x0000000009007224ULL, 0x000fc600078e0208ULL,
0x000000ff0f00720cULL, 0x040fe40003f65270ULL, 0x000000090000720cULL, 0x000fe20003fa6070ULL,
0x00001fff1a1a7589ULL, 0x000e6200000e0000ULL, 0x0000000f0f00780cULL, 0x040fe40003f24070ULL,
0x0000007f0f00780cULL, 0x000fce0003f44070ULL, 0x3fffff80ff04b424ULL, 0x000fe400078e00ffULL,
0x0000000100005824ULL, 0x000fe200078e0a09ULL, 0x000000011b1b5810ULL, 0x000fe20007ffe0ffULL,
0x7fffff80ff05b424ULL, 0x000fe200078e00ffULL, 0x000000030f00780cULL, 0x040fe20003fa4070ULL,
0x3fffffc0ff069424ULL, 0x000fe200078e00ffULL, 0x000000090000720cULL, 0x000fe20003fc6070ULL,
0x7fffffc0ff079424ULL, 0x000fe200078e00ffULL, 0x01260004ff00b388ULL, 0x0007e20000000a00ULL,
0x000000010f00780cULL, 0x000fe20003f64070ULL, 0xff317217ff0ca424ULL, 0x000fc400078e00ffULL,
0x012608060f009388ULL, 0x000fe80000008a00ULL, 0x0124000c0f00a388ULL, 0x000fe20000004800ULL,
0x3fffff60ff04d424ULL, 0x008fe400078e00ffULL, 0x000000011b1b6810ULL, 0x000fe20007ffe0ffULL,
0x7fffff60ff05d424ULL, 0x000fe200078e00ffULL, 0x00000009ff1bc212ULL, 0x000fe200078e33ffULL,
0x3fffffc0ff0ab424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff0bb424ULL, 0x000fe200078e00ffULL,
0x012688040f00d388ULL, 0x000fe20000008a00ULL, 0x000000ffff197224ULL, 0x000fc800078e0a1bULL,
0x0000001909197224ULL, 0x000fe400078e0208ULL, 0x3fffff80ff08d424ULL, 0x000fe400078e00ffULL,
0x0000002019197824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff09d424ULL, 0x000fca00078e00ffULL,
0x0126a8080f00d388ULL, 0x000fe80000008a00ULL, 0x0126c80a0f00b388ULL, 0x000fe20000008a00ULL,
0x000000015f5f0824ULL, 0x004fe400078e0a02ULL, 0x00005800ff5f8624ULL, 0x000fe400078e00ffULL,
0x000058000e028a24ULL, 0x000fe400078e02ffULL, 0x00005a005f007a24ULL, 0x000fc400078e02ffULL,
0x0000001102747224ULL, 0x000fe400078e02ffULL, 0x0000000100037824ULL, 0x040fe200078e0a19ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000190000720cULL, 0x000fe20003f26070ULL,
0x000000040d007824ULL, 0x002fe200078e021aULL, 0x0000002003037817ULL, 0x000fe20003800000ULL,
0x00005a001b137a24ULL, 0x000fc400078e0274ULL, 0x0000000400007824ULL, 0x000fe200078e00ffULL,
0x000000ff03187207ULL, 0x000fc80000800000ULL, 0x000000201800780cULL, 0x000fda0003f05270ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a0000037b06ULL, 0x000e620000209000ULL,
0x0000000000177919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fcc00078e00ffULL,
0x0000000300037308ULL, 0x002e620000001000ULL, 0x00000004ff077819ULL, 0x004fc80000011617ULL,
0x0000000207097810ULL, 0x000fe20007ffe0ffULL, 0x0000000100087824ULL, 0x000fe200078e0207ULL,
0x0ffffffe03057810ULL, 0x002fc60007ffe0ffULL, 0x00000001000a7824ULL, 0x000fc600078e0209ULL,
0x0000000500057305ULL, 0x000e62000021f000ULL, 0x00000001190c7824ULL, 0x000fe400078e020aULL,
0x000000ffff0b7224ULL, 0x002fc800078e0a05ULL, 0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b05037227ULL, 0x000fc800078e0004ULL, 0x0000000119047824ULL, 0x000fe400078e0208ULL,
0x0000000c030b7227ULL, 0x000fc800078e00ffULL, 0x0000000403057227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a05ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a0bULL,
0x00005a0003037a24ULL, 0x000fe400078e0204ULL, 0x00005a000f067a24ULL, 0x000fc600078e020cULL,
0x00005a0003007a0cULL, 0x000fe40003f06070ULL, 0x00005a0006007a0cULL, 0x000fd60003f46070ULL,
0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0006062a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f26070ULL, 0x00005a0006007a0cULL, 0x000fe40003f66070ULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x000000010b0b2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff067a12ULL, 0x000fe400078e33ffULL,
0x0000000018037217ULL, 0x000fe40007800000ULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x000000010b0b3810ULL, 0x000fe20007ffe0ffULL, 0x0000000103007824ULL, 0x000fe200078e0a00ULL,
0x0000000506057207ULL, 0x040fe20004000000ULL, 0x0000001017037824ULL, 0x000fe200078e00ffULL,
0x0000000b06067207ULL, 0x000fc40004000000ULL, 0x000000000700720cULL, 0x080fe20003f06070ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0a05ULL, 0x000000000900720cULL, 0x000fe20003f26070ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0a06ULL, 0x000000f003097812ULL, 0x000fe200078ec0ffULL,
0x00005a000b047a24ULL, 0x000fe400078e0204ULL, 0x00005a000f0c7a24ULL, 0x000fe400078e020cULL,
0x0000000113047824ULL, 0x040fe400078e0204ULL, 0x00000001130b7824ULL, 0x000fc400078e020cULL,
0x0000001105047224ULL, 0x080fe400078e0204ULL, 0x0000001106067224ULL, 0x000fe400078e020bULL,
0x0000010004047825ULL, 0x000fc800078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000904047212ULL, 0x000fc600078efcffULL, 0x0000000108007824ULL, 0x100fe200078e0217ULL,
0x0000000906067212ULL, 0x000fe200078efcffULL, 0x00000010080b7824ULL, 0x000fe200078e00ffULL,
0x0000600004047a10ULL, 0x000fe20007f5e0ffULL, 0x000000010a087824ULL, 0x000fe200078e0217ULL,
0x0000600006067a10ULL, 0x000fe20007f7e0ffULL, 0x000000100a097824ULL, 0x000fe200078e00ffULL,
0xfffffff00b007812ULL, 0x000fe400078ee200ULL, 0x0000610005057a10ULL, 0x000fe400017fe4ffULL,
0xfffffff009087812ULL, 0x000fe200078ee208ULL, 0x0000001000097824ULL, 0x000fe200078e00ffULL,
0x0000610007077a10ULL, 0x000fc60001ffe4ffULL, 0x00000010080b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000c101c46ULL,
0x00000000060b7faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a0000037b06ULL, 0x000e620000209000ULL, 0x0000000000177919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fcc00078e00ffULL, 0x0000000300037308ULL, 0x002e620000001000ULL,
0x0000000017007211ULL, 0x004fc800078fe0ffULL, 0x00000002000a7810ULL, 0x040fe20007ffe0ffULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x0ffffffe03057810ULL, 0x002fe20007ffe0ffULL,
0x0000000119037824ULL, 0x040fe400078e0200ULL, 0x0000000119067824ULL, 0x000fc600078e020aULL,
0x0000000500057305ULL, 0x000e64000021f000ULL, 0x000000ffff077224ULL, 0x002fc800078e0a05ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x0000000705077227ULL, 0x000fcc00078e0004ULL,
0x0000000307047227ULL, 0x000fc800078e00ffULL, 0x0000000607077227ULL, 0x000fc800078e00ffULL,
0x000000ffff087224ULL, 0x000fe400078e0a04ULL, 0x000000ffff097224ULL, 0x000fe400078e0a07ULL,
0x00005a0008057a24ULL, 0x000fe400078e0203ULL, 0x00005a0009087a24ULL, 0x000fc600078e0206ULL,
0x00005a0005007a0cULL, 0x000fe40003f06070ULL, 0x00005a0008007a0cULL, 0x000fd60003f46070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x00005a0008007a0cULL, 0x000fe40003f66070ULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x0000000107072810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff057a12ULL, 0x000fc600078e33ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x0000000107073810ULL, 0x000fe40007ffe0ffULL,
0x0000000405047207ULL, 0x040fe40004000000ULL, 0x0000000705077207ULL, 0x000fc60004000000ULL,
0x000000ffff087224ULL, 0x000fe400078e0a04ULL, 0x000000ffff057224ULL, 0x000fe400078e0a07ULL,
0x00005a0008037a24ULL, 0x000fe400078e0203ULL, 0x00005a0005067a24ULL, 0x000fe400078e0206ULL,
0x0000000113057824ULL, 0x040fe400078e0203ULL, 0x0000000113067824ULL, 0x000fc400078e0206ULL,
0x0000001017037824ULL, 0x000fe400078e00ffULL, 0x0000001104057224ULL, 0x080fe400078e0205ULL,
0x0000001107067224ULL, 0x000fe200078e0206ULL, 0x000000f003097812ULL, 0x000fe200078ec0ffULL,
0x0000010005047825ULL, 0x000fc800078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000904047212ULL, 0x000fc600078efcffULL, 0x0000000100087824ULL, 0x100fe200078e0217ULL,
0x0000000906067212ULL, 0x000fe200078efcffULL, 0x000000010a007824ULL, 0x000fe200078e0217ULL,
0x0000600004047a10ULL, 0x000fe20007f1e0ffULL, 0x000000100a097824ULL, 0x000fe200078e00ffULL,
0xfffffff00b087812ULL, 0x000fe400078ee208ULL, 0x0000600006067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff009007812ULL, 0x000fe200078ee200ULL, 0x0000001008097824ULL, 0x000fe200078e00ffULL,
0x0000610005057a10ULL, 0x000fc400007fe4ffULL, 0x0000610007077a10ULL, 0x000fe20000ffe4ffULL,
0x00000010000b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e8000b901c46ULL, 0x00000000060b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x0000000000007806ULL, 0x000fe200038e0000ULL,
0x00000004ff2b7424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000047300ULL, 0x000e7000000e0000ULL, 0x0000000000067309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x000066000e047625ULL, 0x000fc800078e002bULL,
0x000000ffff067224ULL, 0x004fd000078e0a06ULL, 0x01260406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01260000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604167981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0d00720cULL, 0x000fe40003f05270ULL,
0x000000ff16007810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff157819ULL, 0x000fce0000011600ULL,
0x000117a000008947ULL, 0x000fea0003800000ULL, 0x000000081a147824ULL, 0x000fe400078e00ffULL,
0x00000003ff057424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01268c0514ff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x000000020e027824ULL, 0x000fe200078e00ffULL,
0x00000001ff137819ULL, 0x000fe2000001161aULL, 0x0126880014ff7f8cULL, 0x0007e2000c80043fULL,
0x000000011a117812ULL, 0x000fe200078ec0ffULL, 0x0000590002027624ULL, 0x000fe400078e0210ULL,
0x0000002013757824ULL, 0x000fc400078e00ffULL, 0x000000011b127824ULL, 0x000fc800078e0202ULL,
0x0000680012007a24ULL, 0x000fe200078e0275ULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x0000007516027217ULL, 0x008fe20007800000ULL, 0x0000001011057824ULL, 0x004fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc60000011617ULL, 0x0000000102027824ULL, 0x000fe200078e0a75ULL,
0x0000000404087810ULL, 0x040fe20007ffe0ffULL, 0x0000000105067824ULL, 0x002fe200078e0204ULL,
0x0000000c04097810ULL, 0x000fe40007ffe0ffULL, 0x0000000502027217ULL, 0x000fe20007800000ULL,
0x0000000106077824ULL, 0x040fe400078e0217ULL, 0x00000008060c7824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fc400078e0a05ULL, 0x00000001050a7824ULL, 0x040fe200078e0209ULL,
0xfffffff80c0c7812ULL, 0x000fe400078ee207ULL, 0x0000000804077810ULL, 0x000fe20007ffe0ffULL,
0x00000001000f7824ULL, 0x000fe200078e020aULL, 0x000000020400720cULL, 0x080fe20003f66070ULL,
0x0000000100047824ULL, 0x000fe200078e0206ULL, 0x000000020800720cULL, 0x080fe20003f46070ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x000000020700720cULL, 0x080fe20003f26070ULL,
0x0000000105077824ULL, 0x000fe200078e0207ULL, 0x000000020900720cULL, 0x000fe20003f06070ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x0000000100027824ULL, 0x000fe200078e0208ULL,
0x00000070040b7812ULL, 0x000fe200078ef803ULL, 0x0000000108067824ULL, 0x040fe400078e0217ULL,
0x00000008080d7824ULL, 0x000fe400078e00ffULL, 0x0000000100087824ULL, 0x000fe400078e0207ULL,
0x0000000107097824ULL, 0x100fe200078e0217ULL, 0xfffffff80d007812ULL, 0x000fe200078ee206ULL,
0x00000008070e7824ULL, 0x000fe200078e00ffULL, 0x0000e000130d7811ULL, 0x000fe200078e68ffULL,
0x000000010a047824ULL, 0x000fc400078e0217ULL, 0x000000080a077824ULL, 0x000fe200078e00ffULL,
0x000064000b0a7a10ULL, 0x000fe20007f9e0ffULL, 0x00000010001d7824ULL, 0x000fe200078e020dULL,
0xfffffff80e0e7812ULL, 0x000fe400078ee209ULL, 0xfffffff807107812ULL, 0x000fe200078ee204ULL,
0x0000008008067825ULL, 0x000fe200078e00ffULL, 0x00006500050b7a10ULL, 0x000fc600027fe4ffULL,
0x0000008002047825ULL, 0x000fc800078e00ffULL, 0x000000800f087825ULL, 0x000fe200078e00ffULL,
0x0000007004027812ULL, 0x100fe400078ef803ULL, 0x0000007006047812ULL, 0x000fe200078ef803ULL,
0x000000100c0f7824ULL, 0x000fe200078e020dULL, 0x0000007008037812ULL, 0x000fe200078ef803ULL,
0x000000100e1f7824ULL, 0x100fe200078e020dULL, 0x0000640002027a10ULL, 0x000fe20007f9e0ffULL,
0x00000010100d7824ULL, 0x000fe200078e020dULL, 0x0000640004047a10ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0f7faeULL, 0x0003e2000d901c46ULL,
0x0000640003067a10ULL, 0x000fc40007fde0ffULL, 0x0000650005037a10ULL, 0x000fe400027fe4ffULL,
0x0000650007057a10ULL, 0x000fe40002ffe4ffULL, 0x0000650009077a10ULL, 0x000fe200037fe4ffULL,
0x00000000021d7faeULL, 0x0003e8000d101c46ULL, 0x00000000041f7faeULL, 0x0003e8000c901c46ULL,
0x00000000060d7faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001011027824ULL, 0x008fe200078e00ffULL, 0x0000e000131f7811ULL, 0x000fc800078e68ffULL,
0x0000000217027211ULL, 0x000fc800078fe8ffULL, 0x0000000402067810ULL, 0x042fe20007ffe0ffULL,
0x0000000102057824ULL, 0x044fe200078e0217ULL, 0x0000000c020a7810ULL, 0x040fe20007ffe0ffULL,
0x00000008020c7824ULL, 0x040fe200078e00ffULL, 0x0000000802087810ULL, 0x000fe20007ffe0ffULL,
0x0000000100047824ULL, 0x040fe400078e0202ULL, 0x0000000100027824ULL, 0x000fe200078e0206ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL, 0x0000008004047825ULL, 0x000fc800078e00ffULL,
0x0000000106077824ULL, 0x000fe200078e0217ULL, 0x00000070040b7812ULL, 0x000fe200078ef803ULL,
0x00000008060e7824ULL, 0x000fe400078e00ffULL, 0x00000001000d7824ULL, 0x000fe400078e020aULL,
0x000000010a047824ULL, 0x040fe400078e0217ULL, 0x000000080a0f7824ULL, 0x000fe200078e00ffULL,
0x000064000b0a7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000100067824ULL, 0x000fe200078e0208ULL,
0xfffffff80e007812ULL, 0x000fe200078ee207ULL, 0x0000000108097824ULL, 0x040fe200078e0217ULL,
0xfffffff80f107812ULL, 0x000fe200078ee204ULL, 0x0000000808087824ULL, 0x000fe200078e00ffULL,
0x00006500050b7a10ULL, 0x000fe200007fe4ffULL, 0x0000008002047825ULL, 0x000fc600078e00ffULL,
0xfffffff8080e7812ULL, 0x000fe200078ee209ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000007004027812ULL, 0x000fc600078ef803ULL, 0x000000800d087825ULL, 0x000fe200078e00ffULL,
0x0000007006047812ULL, 0x000fe400078ef803ULL, 0x0000640002027a10ULL, 0x000fe20007f1e0ffULL,
0x000000100c0d7824ULL, 0x000fe200078e021fULL, 0x0000007008037812ULL, 0x000fe200078ef803ULL,
0x00000010000f7824ULL, 0x100fe200078e021fULL, 0x0000640004047a10ULL, 0x000fe20007f3e0ffULL,
0x000000100e1d7824ULL, 0x100fe200078e021fULL, 0x0000640003067a10ULL, 0x000fe20007f5e0ffULL,
0x00000010101f7824ULL, 0x000fe200078e021fULL, 0x0000650005037a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000b901c46ULL,
0x0000650007057a10ULL, 0x000fc40000ffe4ffULL, 0x0000650009077a10ULL, 0x000fe200017fe4ffULL,
0x00000000020f7faeULL, 0x0003e8000b901c46ULL, 0x00000000041d7faeULL, 0x0003e8000b901c46ULL,
0x00000000061f7faeULL, 0x0003e4000b901c46ULL, 0x00000000130473c2ULL, 0x000ea200000e0000ULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x000126a813027811ULL, 0x002fe200078e18ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x000126a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x000000ffff557224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff207f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200002027f8cULL, 0x000ea2000c80043fULL, 0x000000ffff547224ULL, 0x000fe200078e00ffULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000ea8000008947ULL, 0x000fea0003800000ULL, 0x00000010130e7824ULL, 0x000fe200078e00ffULL,
0x00000002ff107819ULL, 0x000fe2000001161aULL, 0x000000ffff007224ULL, 0x004fc400078e0003ULL,
0xff317217ff237424ULL, 0x000fe200078e00ffULL, 0x000000100e0e7812ULL, 0x000fe200078ee2ffULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fc400078e00ffULL,
0x000000ffff0c7224ULL, 0x00afca00078e00ffULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x000000041a087824ULL, 0x000fca00078e00ffULL, 0xfffffff808087812ULL, 0x000fc800078ec0ffULL,
0x000126c8080d7810ULL, 0x000fe20007ffe0ffULL, 0x0126cc00080b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe40007804800ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a021d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e03ULL,
0x003d09001d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000001d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0126cc00080b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010f007810ULL, 0x040fe20007ffe0ffULL, 0x000001000f0c7824ULL, 0x000fc600078e0275ULL,
0x000000150000720cULL, 0x000fe40003f46070ULL, 0x000000400c037810ULL, 0x000fca0007ffe0ffULL,
0x0000680012087a24ULL, 0x000fcc00078e0203ULL, 0x000004000000a947ULL, 0x000fea0003800000ULL,
0x00000003ff0a7819ULL, 0x000fe20000011617ULL, 0x00000010110b7824ULL, 0x000fe200078e00ffULL,
0x0000000316007217ULL, 0x000fe40007800000ULL, 0x000000080a1d7810ULL, 0x040fe20007ffe0ffULL,
0x000000010b027824ULL, 0x040fe200078e020aULL, 0x0000000c0a207810ULL, 0x002fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe400078e0a03ULL, 0x00000001021c7824ULL, 0x040fe400078e0217ULL,
0x0000000802277824ULL, 0x000fe200078e00ffULL, 0x000000000b007217ULL, 0x000fe20007800000ULL,
0x0000001017037824ULL, 0x000fc400078e00ffULL, 0x0000000102027824ULL, 0x000fe200078e0208ULL,
0xfffffff827277812ULL, 0x000fe200078ee21cULL, 0x0000000100007824ULL, 0x000fe200078e0a0bULL,
0x000000040a1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b1f7824ULL, 0x000fe200078e021dULL,
0x0000007003257812ULL, 0x000fe200078ec0ffULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0x000000000a00720cULL, 0x080fe40003fa6070ULL, 0x000000001c00720cULL, 0x080fe20003f86070ULL,
0x000000010b1e7824ULL, 0x040fe200078e021cULL, 0x00000025021c7212ULL, 0x000fe200078efcffULL,
0x000000010b227824ULL, 0x000fe200078e0220ULL, 0x000000001d00720cULL, 0x080fe20003f66070ULL,
0x000000011e0a7824ULL, 0x000fe200078e0208ULL, 0x000000002000720cULL, 0x000fe20003f06070ULL,
0x000000011e007824ULL, 0x000fe200078e0217ULL, 0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0x00006500031d7a10ULL, 0x000fe200037fe4ffULL,
0x000000081e697824ULL, 0x000fe200078e00ffULL, 0x000000250a1e7212ULL, 0x080fe200078efcffULL,
0x000000011f027824ULL, 0x100fe400078e0208ULL, 0x00000001220a7824ULL, 0x000fe200078e0208ULL,
0x000064001e1e7a10ULL, 0x000fe20007fde0ffULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0xfffffff869697812ULL, 0x000fe400078ee200ULL, 0x0000f00013007811ULL, 0x000fe200078e68ffULL,
0x000000011f207824ULL, 0x040fe200078e0217ULL, 0x0000002502027212ULL, 0x000fe200078efcffULL,
0x000000081f6b7824ULL, 0x000fe200078e00ffULL, 0x000065000b1f7a10ULL, 0x000fe200037fe4ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000640002027a10ULL, 0x000fc40007fde0ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee220ULL, 0x0000000122087824ULL, 0x000fe200078e0217ULL,
0x000000250a0a7212ULL, 0x000fe200078efcffULL, 0x00000008226d7824ULL, 0x000fe200078e00ffULL,
0x0000650003037a10ULL, 0x000fe200037fe4ffULL, 0x0000001027257824ULL, 0x100fe200078e0200ULL,
0x000064000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x0000001069277824ULL, 0x000fe200078e0200ULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee208ULL, 0x000000106b697824ULL, 0x100fe200078e0200ULL,
0x000065000b0b7a10ULL, 0x000fe200037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c257faeULL, 0x0003e4000e901c46ULL, 0x000000106d6b7824ULL, 0x000fc400078e0200ULL,
0x000000001e277faeULL, 0x0003e8000e101c46ULL, 0x0000000002697faeULL, 0x0003e8000d901c46ULL,
0x000000000a6b7faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001011007824ULL, 0x000fe400078e00ffULL, 0x0000001017027824ULL, 0x000fc600078e00ffULL,
0x0000000017007211ULL, 0x000fe400078fe8ffULL, 0x0000007002697812ULL, 0x000fe400078ec0ffULL,
0x0000000c001f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000100037824ULL, 0x040fe200078e0217ULL,
0x00000008001d7810ULL, 0x040fe20007ffe0ffULL, 0x00000008000a7824ULL, 0x040fe400078e00ffULL,
0x0000000100027824ULL, 0x000fe400078e0208ULL, 0x000000081f6d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a257812ULL, 0x000fe200078ee203ULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0x00000004000a7810ULL, 0x000fc60007ffe0ffULL, 0x000000011f1c7824ULL, 0x040fe200078e0208ULL,
0x00000069021e7212ULL, 0x000fe200078efcffULL, 0x000000011f027824ULL, 0x100fe400078e0217ULL,
0x000000010a0b7824ULL, 0x000fe200078e0217ULL, 0x000064001e1e7a10ULL, 0x000fe20007f1e0ffULL,
0x000000080a207824ULL, 0x042fe200078e00ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee202ULL,
0x000000010a007824ULL, 0x100fe200078e0208ULL, 0x00006500031f7a10ULL, 0x000fe200007fe4ffULL,
0x000000011d0a7824ULL, 0x000fe200078e0208ULL, 0xfffffff820277812ULL, 0x000fe200078ee20bULL,
0x0000008000027825ULL, 0x000fc800078e00ffULL, 0x000000011d087824ULL, 0x040fe200078e0217ULL,
0x0000006902027212ULL, 0x080fe200078efcffULL, 0x000000081d6b7824ULL, 0x000fe400078e00ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000640002027a10ULL, 0x000fe40007f1e0ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee208ULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000690a0a7212ULL, 0x000fe400078efcffULL, 0x0000f00013087811ULL, 0x000fc400078e68ffULL,
0x000000691c1c7212ULL, 0x000fe400078efcffULL, 0x000064000a0a7a10ULL, 0x000fe20007f7e0ffULL,
0x0000001025257824ULL, 0x100fe200078e0208ULL, 0x000064001c1c7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001027277824ULL, 0x100fe200078e0208ULL, 0x0000650003037a10ULL, 0x000fe200007fe4ffULL,
0x000000106b697824ULL, 0x100fe200078e0208ULL, 0x000065000b0b7a10ULL, 0x000fe20001ffe4ffULL,
0x000000106d6b7824ULL, 0x000fe200078e0208ULL, 0x000065001d1d7a10ULL, 0x000fe200027fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e257faeULL, 0x0003e8000b901c46ULL,
0x0000000002277faeULL, 0x0003e8000b901c46ULL, 0x000000000a697faeULL, 0x0003e8000b901c46ULL,
0x000000001c6b7faeULL, 0x0003e4000b901c46ULL, 0xfffffff0141f7812ULL, 0x042fe400078ec0ffULL,
0xffffffe014007812ULL, 0x000fc400078ec0ffULL, 0x000000001f0573c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000001014037812ULL, 0x000fca00078ec0ffULL,
0x0000000100007824ULL, 0x000fc800078e0203ULL, 0x00000008111c7824ULL, 0x000fe200078e0200ULL,
0x000126b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126b0001f687f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x012608001c1c7f8cULL, 0x000ee4000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x00000008140b7812ULL, 0x000fca00078ec0ffULL, 0x0000000100207824ULL, 0x000fca00078e020bULL,
0x01260c00200b7984ULL, 0x000f240000000800ULL, 0x800000000bff7812ULL, 0x018fe4000780481dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a02257210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e03ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140bULL, 0x0000002500007211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000200007819ULL, 0x000fc8000000120bULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01260c00200b7984ULL, 0x000ee40000000800ULL, 0x800000000bff7812ULL, 0x008fe4000780481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010170b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011617ULL,
0x000000201a007824ULL, 0x000fe400078e00ffULL, 0xffffffffff767424ULL, 0x000fe200078e00ffULL,
0x000000700b0b7812ULL, 0x000fc400078ec0ffULL, 0xffffff8000007812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000000a007210ULL, 0x000fca0007ffe00bULL,
0x0120000000027984ULL, 0x000ee80000000800ULL, 0x0122000000037984ULL, 0x0002a20000000800ULL,
0x000000230200720bULL, 0x008fe20003f1d000ULL, 0x00018bd27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x002fc800000e0100ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff227424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x000fc400078e0023ULL, 0x0000001fff787424ULL, 0x000fe400078e00ffULL,
0xffffffffff777424ULL, 0x000fca00078e00ffULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x0000001a1000720cULL, 0x000fe40003f05270ULL, 0x000000230200720bULL, 0x000fe20003f74000ULL,
0x00018b727f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x000fc400018e0100ULL,
0x000000801a258824ULL, 0x000fe200078e020bULL, 0x00000023021e7209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a258824ULL, 0x000fca00078e0225ULL,
0x0124001e25008388ULL, 0x0003e20000000800ULL, 0x000000ff1d00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x000000231e087221ULL, 0x002fe20000010100ULL,
0x000000ff1dff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x0000000800277308ULL, 0x000e640000000800ULL,
0x0000002724247220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x00018ab27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x000000264c4c7220ULL, 0x080fe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001dff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x000189727f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x00066400000e0000ULL,
0x0000002666667220ULL, 0x086fe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x000000264e4e7220ULL, 0x080fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00001dff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x000188327f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002628287220ULL, 0x080fe20000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000001dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x000187027f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x000000262e2e7220ULL, 0x080fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x000000262a2a7220ULL, 0x080fe20000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000001d00ff7212ULL, 0x000fda00078030ffULL, 0x8000001e02020221ULL, 0x000fe20000010000ULL,
0x00007610ff220816ULL, 0x000fc60000000022ULL, 0x3fb8aa3b02020820ULL, 0x000fc80000410000ULL,
0x0000000200090308ULL, 0x000e640000000800ULL, 0x0000000903030220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002403247221ULL, 0x004fc40000010000ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x0126ac001f007984ULL, 0x000e620000000800ULL,
0x000126a81f087810ULL, 0x000fe40007ffe0ffULL, 0x8000000000ff7812ULL, 0x002fe20007804821ULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c02237210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e03ULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001141dULL, 0x0000002300007211ULL, 0x000fca00078110ffULL,
0x000000ffff1d7224ULL, 0x000fca00000e061dULL, 0x0000000200007819ULL, 0x000fc8000000121dULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0126ac001f007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991022007816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff027819ULL, 0x000fe40000011617ULL,
0x0000541000277816ULL, 0x008fe20000000000ULL, 0x000182b27f007947ULL, 0x000fea000b800000ULL,
0x00001f0227077589ULL, 0x0002a400000e0000ULL, 0x0000000802267810ULL, 0x000fe20007ffe0ffULL,
0x000182d27f007947ULL, 0x000fea000b800000ULL, 0x0000001002007810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0027057589ULL, 0x0006a400000e0000ULL,
0x0000001802267810ULL, 0x008fe20007ffe0ffULL, 0x000183027f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000413227824ULL, 0x000fe200078e00ffULL, 0x0000000817007812ULL, 0x000fe200078ec0ffULL,
0x000004001a1d7824ULL, 0x000fe200078e00ffULL, 0x00000004ff267819ULL, 0x108fe20000011617ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000422227812ULL, 0x000fe200078ec0ffULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x0000000700037812ULL, 0x000fe200078ef817ULL,
0x00000004111f7824ULL, 0x000fe200078e0226ULL, 0x0000002217007211ULL, 0x000fc400078fe0ffULL,
0x0000001003027812ULL, 0x042fe200078efcffULL, 0x0000000803217824ULL, 0x040fe400078e00ffULL,
0x00000001031c7824ULL, 0x000fe400078e0200ULL, 0x0000000100007824ULL, 0x000fe400078e0202ULL,
0x0000000802237824ULL, 0x000fe200078e00ffULL, 0xfffffff8211c7812ULL, 0x000fe200078ee21cULL,
0x00000008036a7824ULL, 0x000fe200078e00ffULL, 0xfffff0001d217812ULL, 0x000fc400078ec0ffULL,
0xfffffff8231d7812ULL, 0x000fe200078ee200ULL, 0x0000000103237824ULL, 0x000fe200078e021fULL,
0x0000a00021217810ULL, 0x000fe40007ffe0ffULL, 0x0000e00013007811ULL, 0x000fe400078e68ffULL,
0xfffffff86a257812ULL, 0x000fe200078ee223ULL, 0x000000101c707824ULL, 0x100fe200078e0221ULL,
0x0000000223237810ULL, 0x000fe20007ffe0ffULL, 0x000000101d6c7824ULL, 0x000fe400078e0221ULL,
0x0000001025257824ULL, 0x000fc400078e0200ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000006c6c783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000770707231ULL, 0x086fe400003400ffULL, 0x0000000772727231ULL, 0x000fe400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fc400003400ffULL,
0x000000056c6c7231ULL, 0x088fe400003400ffULL, 0x000000056e6e7231ULL, 0x000fe400003400ffULL,
0x000000046d6d7231ULL, 0x080fe400003400ffULL, 0x000000046f6f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000002580783bULL, 0x000f220000004200ULL,
0xfffffff86a237812ULL, 0x000fe200078ee223ULL, 0x00000001021f7824ULL, 0x000fe200078e021fULL,
0x0000105000007945ULL, 0x000fe60003800000ULL, 0x0000001023237824ULL, 0x000fca00078e0200ULL,
0x00000000237c783bULL, 0x000ee20000004200ULL, 0x00000100807b7824ULL, 0x010fe200078e00ffULL,
0x00000080006a7306ULL, 0x000fe20000009400ULL, 0x0000010081917824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011480ULL, 0x0000010083a67824ULL, 0x040fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000010082a37824ULL, 0x000fe200078e00ffULL,
0x00000018ff997819ULL, 0x000fe20000011491ULL, 0x0001000083af7824ULL, 0x000fe200078e00ffULL,
0x0000007b008f7306ULL, 0x000fe20000209400ULL, 0x00000018ff9e7819ULL, 0x000fe20000011481ULL,
0x000001007cb77824ULL, 0x008fe200078e00ffULL, 0x00000018ffac7819ULL, 0x000fc400000114a6ULL,
0x00000018ffa37819ULL, 0x000fe400000114a3ULL, 0x00000018ffa77819ULL, 0x000fe20000011482ULL,
0x0000007b00907306ULL, 0x0007220000205400ULL, 0x00000018ffaf7819ULL, 0x000fe400000114afULL,
0x00000018ffb77819ULL, 0x000fe400000114b7ULL, 0x00000018ffb27819ULL, 0x000fe40000011483ULL,
0x00000018ffb97819ULL, 0x000fe2000001147cULL, 0x00000080006b7306ULL, 0x000ea20000005400ULL,
0x0000007b007b7245ULL, 0x008fc4000020d400ULL, 0x00000018ff8c7819ULL, 0x000fe4000001147dULL,
0x00000018ff277819ULL, 0x000fe4000001147eULL, 0x00000018ff797819ULL, 0x000fe2000001147fULL,
0x00000080007a7306ULL, 0x000662000000d400ULL, 0x000000908f00720bULL, 0x010fce0003fdd000ULL,
0x00000099009a7306ULL, 0x000fe20000209400ULL, 0x0001000080807824ULL, 0x008fe200078e00ffULL,
0x0000006b6a00720bULL, 0x004fe20003fbd000ULL, 0x000001007d6a7824ULL, 0x000fe200078e00ffULL,
0x00000099006b7245ULL, 0x000fe4000020d400ULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x00000099009b7306ULL, 0x000ea20000205400ULL, 0x000000017b7b6812ULL, 0x000fcc00078efcffULL,
0x000000017a7a5812ULL, 0x002fe200078efcffULL, 0x0000008100967306ULL, 0x000ff00000009400ULL,
0x0000008100977306ULL, 0x000e620000005400ULL, 0x0000009b9a00720bULL, 0x004fc40003f7d000ULL,
0x00000018ff9a7819ULL, 0x000fca000001146aULL, 0x0000008100987306ULL, 0x0004ec000000d400ULL,
0x000000016b6b3812ULL, 0x000fe400078efcffULL, 0x0000008000917306ULL, 0x000fe20000209400ULL,
0x0001000081817824ULL, 0x004fe200078e00ffULL, 0x000000979600720bULL, 0x002fc80003f9d000ULL,
0x00000018ff817819ULL, 0x000fe40000011481ULL, 0x0000008000927306ULL, 0x0002ae0000205400ULL,
0x0000000198984812ULL, 0x008fe200078efcffULL, 0x00000081009c7306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fc4000020d400ULL, 0x000000986b6b723eULL, 0x000fca00000010ffULL,
0x00000081009d7306ULL, 0x0002e20000205400ULL, 0x000000929100720bULL, 0x004fe20003fdd000ULL,
0x000100007d927824ULL, 0x000fcc00078e00ffULL, 0x0000009300947306ULL, 0x000fe20000209400ULL,
0x0000008100817245ULL, 0x002fca000020d400ULL, 0x0000000180806812ULL, 0x000fe400078efcffULL,
0x0000009300957306ULL, 0x0002a20000205400ULL, 0x0000009d9c00720bULL, 0x008fce0003f7d000ULL,
0x0000008200a17306ULL, 0x000fe20000009400ULL, 0x0000009300937245ULL, 0x002fca000020d400ULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x0000008200a27306ULL, 0x000e620000005400ULL,
0x000000959400720bULL, 0x004fe40003fbd000ULL, 0x00000018ff947819ULL, 0x000fe40000011492ULL,
0x000000b900927245ULL, 0x000fc6000020d400ULL, 0x0000009e009f7306ULL, 0x000fec0000209400ULL,
0x0000000193935812ULL, 0x000fe400078efcffULL, 0x0000009e00a07306ULL, 0x0004e20000205400ULL,
0x000000a2a100720bULL, 0x002fce0003fdd000ULL, 0x000000ac00ad7306ULL, 0x000fe20000209400ULL,
0x0000009e009e7245ULL, 0x004fce000020d400ULL, 0x000000ac00ae7306ULL, 0x0002a20000205400ULL,
0x000000a09f00720bULL, 0x008fce0003f9d000ULL, 0x00000082008e7306ULL, 0x000722000000d400ULL,
0x000000ac00ac7245ULL, 0x002fca000020d400ULL, 0x000000019e9e4812ULL, 0x000fe400078efcffULL,
0x000000a300a47306ULL, 0x000fe20000209400ULL, 0x0001000082827824ULL, 0x008fe200078e00ffULL,
0x000000aead00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff827819ULL, 0x000fe40000011482ULL,
0x000000a300a57306ULL, 0x0002a20000205400ULL, 0x000000018e8e6812ULL, 0x010fcc00078efcffULL,
0x00000001acac3812ULL, 0x000fe200078efcffULL, 0x000000a700a87306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x002fce000020d400ULL, 0x000000a700a97306ULL, 0x0002e20000205400ULL,
0x000000a5a400720bULL, 0x004fce0003fbd000ULL, 0x0000008300aa7306ULL, 0x000fe20000009400ULL,
0x000000a700a77245ULL, 0x002fca000020d400ULL, 0x00000001a3a35812ULL, 0x000fe400078efcffULL,
0x0000008300ab7306ULL, 0x000e620000005400ULL, 0x000000a9a800720bULL, 0x008fce0003fdd000ULL,
0x000000af00b07306ULL, 0x000fec0000209400ULL, 0x00000001a7a76812ULL, 0x000fe400078efcffULL,
0x000000af00b17306ULL, 0x0004e20000205400ULL, 0x000000abaa00720bULL, 0x002fce0003f9d000ULL,
0x00000083008d7306ULL, 0x000e62000000d400ULL, 0x000000af00af7245ULL, 0x004fce000020d400ULL,
0x0000008200a67306ULL, 0x000fe20000209400ULL, 0x000000b1b000720bULL, 0x008fce0003f7d000ULL,
0x0000008200837306ULL, 0x0004e20000205400ULL, 0x000000018d8d4812ULL, 0x002fca00078efcffULL,
0x00000001afaf3812ULL, 0x000fe400078efcffULL, 0x000000b700b87306ULL, 0x000fe20000209400ULL,
0x0000008200827245ULL, 0x004fce000020d400ULL, 0x000000b7008f7306ULL, 0x000e620000205400ULL,
0x00000083a600720bULL, 0x008fe20003fbd000ULL, 0x000001007e837824ULL, 0x000fca00078e00ffULL,
0x00000018ff977819ULL, 0x000fe20000011483ULL, 0x000000b200b37306ULL, 0x000fe20000209400ULL,
0x000001007f837824ULL, 0x000fca00078e00ffULL, 0x0000000182825812ULL, 0x000fe400078efcffULL,
0x000000b200b47306ULL, 0x0004e20000205400ULL, 0x0000008fb800720bULL, 0x002fe40003fdd000ULL,
0x00000018ff9b7819ULL, 0x000fe40000011483ULL, 0x0000009a008f7245ULL, 0x000fc6000020d400ULL,
0x0000007c00b57306ULL, 0x000fe20000009400ULL, 0x000000b200b27245ULL, 0x004fce000020d400ULL,
0x0000007c00b67306ULL, 0x000e620000005400ULL, 0x000000b4b300720bULL, 0x008fce0003f9d000ULL,
0x0000007c00877306ULL, 0x0004ec000000d400ULL, 0x00000001b2b24812ULL, 0x000fe400078efcffULL,
0x0000009a00907306ULL, 0x000fe20000209400ULL, 0x000100007c7c7824ULL, 0x004fe200078e00ffULL,
0x000000b6b500720bULL, 0x002fc80003fbd000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000009a00917306ULL, 0x000e640000205400ULL, 0x0000007c00837245ULL, 0x000fca000020d400ULL,
0x0000000187875812ULL, 0x008fe200078efcffULL, 0x0000007d00bc7306ULL, 0x000ff00000009400ULL,
0x0000007d00bd7306ULL, 0x000ea20000005400ULL, 0x000000919000720bULL, 0x002fc40003f7d000ULL,
0x000000b700907245ULL, 0x000fc8000020d400ULL, 0x0000000190906812ULL, 0x000fe200078efcffULL,
0x0000007d00867306ULL, 0x000e6c000000d400ULL, 0x000000018f8f3812ULL, 0x000fe400078efcffULL,
0x0000007c006a7306ULL, 0x000fe20000209400ULL, 0x000000bdbc00720bULL, 0x004fce0003f9d000ULL,
0x0000007c007d7306ULL, 0x0004ec0000205400ULL, 0x0000000186864812ULL, 0x002fe400078efcffULL,
0x000000b900ba7306ULL, 0x000fe20000209400ULL, 0x0000008ea37c723eULL, 0x004fce00000010ffULL,
0x000000b900bb7306ULL, 0x000e620000205400ULL, 0x0000007d6a00720bULL, 0x008fe40003fdd000ULL,
0x0000007a7b6a723eULL, 0x000fe400000010ffULL, 0x00000080937a723eULL, 0x000fe400000010ffULL,
0x0000009400937245ULL, 0x000fe2000020d400ULL, 0x0000009400957306ULL, 0x000fe20000209400ULL,
0x0000008dac7d723eULL, 0x000fe200000010ffULL, 0x0000006a7064723cULL, 0x000f620000041864ULL,
0x000000819e7b723eULL, 0x000fc400000010ffULL, 0x000000868f81723eULL, 0x000fe400000010ffULL,
0x0000000183836812ULL, 0x000fe200078efcffULL, 0x0000009400967306ULL, 0x000ea20000205400ULL,
0x000000bbba00720bULL, 0x002fe20003fbd000ULL, 0x0000006a6c44723cULL, 0x000b620000041844ULL,
0x0000009b00867245ULL, 0x000fe4000020d400ULL, 0x000000879080723eULL, 0x000fc600000010ffULL,
0x0000008c00be7306ULL, 0x000fe20000209400ULL, 0x00000008026a7824ULL, 0x020fe200078e00ffULL,
0x0000007a7060723cULL, 0x040f680000041860ULL, 0x0000000192925812ULL, 0x000fe400078efcffULL,
0x0000008c00bf7306ULL, 0x0002e20000205400ULL, 0x000000969500720bULL, 0x004fe20003fdd000ULL,
0x0000007c705c723cULL, 0x000f62000004185cULL, 0x000000839292723eULL, 0x000fca00000010ffULL,
0x0000007e00c07306ULL, 0x000fe20000009400ULL, 0x0000008c008c7245ULL, 0x002fe2000020d400ULL,
0x000000807054723cULL, 0x000f680000041854ULL, 0x0000000193936812ULL, 0x000fe400078efcffULL,
0x0000007e00c17306ULL, 0x000e620000005400ULL, 0x000000bfbe00720bULL, 0x008fe20003f9d000ULL,
0x0000007a6c40723cULL, 0x040f6c0000041840ULL, 0x0000009700997306ULL, 0x000fe40000209400ULL,
0x0000007c6c3c723cULL, 0x000f68000004183cULL, 0x000000018c8c4812ULL, 0x000fc400078efcffULL,
0x00000097009c7306ULL, 0x000ea20000205400ULL, 0x000000c1c000720bULL, 0x002fe20003f7d000ULL,
0x000000806c34723cULL, 0x000f620000041834ULL, 0x000000938c93723eULL, 0x000fca00000010ffULL,
0x0000007f008b7306ULL, 0x000fe40000009400ULL, 0x000000927050723cULL, 0x080f6c0000041850ULL,
0x0000007f008a7306ULL, 0x000e620000005400ULL, 0x0000009c9900720bULL, 0x004fe20003fbd000ULL,
0x000000926c30723cULL, 0x000f6c0000041830ULL, 0x0000009b009d7306ULL, 0x000ff00000209400ULL,
0x0000009b00a07306ULL, 0x000ea20000205400ULL, 0x0000008a8b00720bULL, 0x002fce0003fdd000ULL,
0x0000007e00237306ULL, 0x0002f0000000d400ULL, 0x0000007f00257306ULL, 0x0008e2000000d400ULL,
0x000100007e7e7824ULL, 0x002fe200078e00ffULL, 0x000000a09d00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff917819ULL, 0x000fe4000001147eULL, 0x0000002700887306ULL, 0x000fe20000209400ULL,
0x000100007f7f7824ULL, 0x010fe200078e00ffULL, 0x00000082a77e723eULL, 0x000fe400000010ffULL,
0x0000009700827245ULL, 0x000fe4000020d400ULL, 0x00000018ff967819ULL, 0x000fe4000001147fULL,
0x0000002700897306ULL, 0x000e620000205400ULL, 0x0000000182825812ULL, 0x000fc400078efcffULL,
0x0000000123233812ULL, 0x008fe400078efcffULL, 0x0000000186864812ULL, 0x000fe400078efcffULL,
0x0000000125256812ULL, 0x000fe200078efcffULL, 0x0000007900857306ULL, 0x000fe20000209400ULL,
0x000000238282723eULL, 0x000fe400000010ffULL, 0x0000000222237812ULL, 0x000fe400078efcffULL,
0x000000258683723eULL, 0x000fe200000010ffULL, 0x0000000803257824ULL, 0x040fe200078e00ffULL,
0x0000007900867245ULL, 0x000fe2000020d400ULL, 0x0000007900847306ULL, 0x000ea20000205400ULL,
0x000000898800720bULL, 0x002fe20003fbd000ULL, 0x0000000126237824ULL, 0x000fe200078e0223ULL,
0x000000afb27f723eULL, 0x000fe200000010ffULL, 0x0000000802267824ULL, 0x000fe200078e00ffULL,
0x00000082704c723cULL, 0x000f62000004184cULL, 0x0000000103227824ULL, 0x000fc400078e0223ULL,
0x00000091009a7306ULL, 0x000fe20000209400ULL, 0x0000000102237824ULL, 0x000fe400078e0223ULL,
0xfffffff825227812ULL, 0x000fe400078ee222ULL, 0x0000007e7058723cULL, 0x080f620000041858ULL,
0xfffffff826267812ULL, 0x000fe400078ee223ULL, 0x0000009100957306ULL, 0x0002e20000205400ULL,
0x000000848500720bULL, 0x004fe20003f7d000ULL, 0x0000001022227824ULL, 0x100fe200078e0221ULL,
0x0000002700847245ULL, 0x000fe2000020d400ULL, 0x0000001026267824ULL, 0x000fe200078e0221ULL,
0x0000009600857245ULL, 0x000fe2000020d400ULL, 0x0000007e6c38723cULL, 0x000f620000041838ULL,
0x0000000184845812ULL, 0x000fe200078efcffULL, 0x00000096008d7306ULL, 0x000fe20000209400ULL,
0x0000009100917245ULL, 0x002fc4000020d400ULL, 0xfffffff86a217812ULL, 0x000fe400078ee21fULL,
0x000000021f1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000826c2c723cULL, 0x000f62000004182cULL,
0x0000000186863812ULL, 0x000fe200078efcffULL, 0x00000096008a7306ULL, 0x000e620000205400ULL,
0x000000959a00720bULL, 0x008fe20003f9d000ULL, 0x0000001021217824ULL, 0x000fd800078e0200ULL,
0x0000000191914812ULL, 0x000fe400078efcffULL, 0x0000008a8d00720bULL, 0x002fe40003fdd000ULL,
0x000000918484723eULL, 0x000fd600000010ffULL, 0x0000000185856812ULL, 0x000fc800078efcffULL,
0x000000858685723eULL, 0x000fce00000010ffULL, 0x000000847048723cULL, 0x080b640000041848ULL,
0x000000002270783bULL, 0x0202ac0000000200ULL, 0x000000846c28723cULL, 0x000b640000041828ULL,
0x00000000266c783bULL, 0x0202e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000770707231ULL, 0x084fe400003400ffULL,
0x0000000772727231ULL, 0x000fc400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fe400003400ffULL, 0x000000056c6c7231ULL, 0x088fe400003400ffULL,
0x000000056e6e7231ULL, 0x000fe400003400ffULL, 0x000000046d6d7231ULL, 0x080fe400003400ffULL,
0x000000046f6f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000002180783bULL, 0x000f220000004200ULL, 0xfffffff86a1f7812ULL, 0x000fca00078ee21fULL,
0x000000101f1f7824ULL, 0x000fca00078e0200ULL, 0x000000001f7c783bULL, 0x000e620000004200ULL,
0x0000010080277824ULL, 0x010fe200078e00ffULL, 0x0000008000227306ULL, 0x002fe20000009400ULL,
0x00000018ff8f7819ULL, 0x000fe20000011480ULL, 0x00000100818d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe20000011481ULL, 0x00000100829f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x0000010083a27824ULL, 0x040fe200078e00ffULL,
0x00000018ff957819ULL, 0x000fe2000001148dULL, 0x0000008000237306ULL, 0x000e620000005400ULL,
0x00000018ff9f7819ULL, 0x000fe2000001149fULL, 0x0001000083ab7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa87819ULL, 0x000fe200000114a2ULL, 0x000001007dbb7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe20000011482ULL, 0x000001007cb37824ULL, 0x000fe200078e00ffULL,
0x00000018ffab7819ULL, 0x000fe200000114abULL, 0x00000027008b7306ULL, 0x000fe20000209400ULL,
0x00000018ffae7819ULL, 0x000fc40000011483ULL, 0x00000018ffbb7819ULL, 0x000fe400000114bbULL,
0x00000018ffb67819ULL, 0x000fe4000001147cULL, 0x00000018ff6a7819ULL, 0x000fe2000001147eULL,
0x00000027008c7306ULL, 0x0008e20000205400ULL, 0x000000232200720bULL, 0x002fe40003f9d000ULL,
0x0000009500237245ULL, 0x000fe4000020d400ULL, 0x00000018ff257819ULL, 0x000fc4000001147fULL,
0x00000018ffb37819ULL, 0x000fe200000114b3ULL, 0x0000008000267306ULL, 0x0002a2000000d400ULL,
0x0000002700277245ULL, 0x010fe4000020d400ULL, 0x00000018ff867819ULL, 0x000fca000001147dULL,
0x0000008100927306ULL, 0x000fe20000009400ULL, 0x0001000080807824ULL, 0x002fe200078e00ffULL,
0x0000008c8b00720bULL, 0x008fe20003fdd000ULL, 0x000100007d8c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x0000008100937306ULL, 0x000e620000005400ULL,
0x0000000126264812ULL, 0x004fcc00078efcffULL, 0x0000000127276812ULL, 0x000fe200078efcffULL,
0x0000008f00907306ULL, 0x000ff00000209400ULL, 0x0000008f00917306ULL, 0x0004e20000205400ULL,
0x000000939200720bULL, 0x002fe20003f1d000ULL, 0x000001007e927824ULL, 0x000fc400078e00ffULL,
0x000100007e937824ULL, 0x000fc600078e00ffULL, 0x00000018ff927819ULL, 0x000fe20000011492ULL,
0x00000080008d7306ULL, 0x000fe20000209400ULL, 0x0000008f008f7245ULL, 0x004fce000020d400ULL,
0x00000080008e7306ULL, 0x0002a20000205400ULL, 0x000000919000720bULL, 0x008fce0003fbd000ULL,
0x0000008100947306ULL, 0x000722000000d400ULL, 0x0000008000807245ULL, 0x002fca000020d400ULL,
0x000000018f8f5812ULL, 0x000fe400078efcffULL, 0x0000009a009b7306ULL, 0x000fe20000209400ULL,
0x0000008e8d00720bULL, 0x004fe20003fdd000ULL, 0x0001000081817824ULL, 0x008fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe4000001148cULL, 0x000000bb008c7245ULL, 0x000fe4000020d400ULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000009a009c7306ULL, 0x0002a20000205400ULL,
0x0000000194940812ULL, 0x010fca00078efcffULL, 0x0000000180806812ULL, 0x000fe400078efcffULL,
0x0000009500967306ULL, 0x000fe20000209400ULL, 0x0000009a009a7245ULL, 0x002fce000020d400ULL,
0x0000009500977306ULL, 0x000e620000205400ULL, 0x0000009c9b00720bULL, 0x004fce0003f1d000ULL,
0x0000009f00a07306ULL, 0x000fec0000209400ULL, 0x000000019a9a0812ULL, 0x000fe400078efcffULL,
0x0000009f00a17306ULL, 0x0004e20000205400ULL, 0x000000979600720bULL, 0x002fe20003f7d000ULL,
0x000001007f967824ULL, 0x000fc400078e00ffULL, 0x000100007f977824ULL, 0x000fc600078e00ffULL,
0x00000018ff967819ULL, 0x000fe20000011496ULL, 0x000000a800a97306ULL, 0x000fe20000209400ULL,
0x0000009f009f7245ULL, 0x004fe4000020d400ULL, 0x00000018ff977819ULL, 0x000fc60000011497ULL,
0x0000000123233812ULL, 0x000fe400078efcffULL, 0x000000a800aa7306ULL, 0x0002a20000205400ULL,
0x000000a1a000720bULL, 0x008fe40003fdd000ULL, 0x000000942323723eULL, 0x000fca00000010ffULL,
0x00000082009d7306ULL, 0x000fe20000009400ULL, 0x000000a800a87245ULL, 0x002fca000020d400ULL,
0x000000019f9f6812ULL, 0x000fe400078efcffULL, 0x00000082009e7306ULL, 0x000e620000005400ULL,
0x000000aaa900720bULL, 0x004fce0003fbd000ULL, 0x0000008200887306ULL, 0x0004ec000000d400ULL,
0x00000001a8a85812ULL, 0x000fe400078efcffULL, 0x0000008300a67306ULL, 0x000fe20000009400ULL,
0x0001000082827824ULL, 0x004fe200078e00ffULL, 0x0000009e9d00720bULL, 0x002fc80003f9d000ULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x0000008300a77306ULL, 0x000fee0000005400ULL,
0x0000000188884812ULL, 0x008fe200078efcffULL, 0x0000008300877306ULL, 0x000ff0000000d400ULL,
0x000000a300a47306ULL, 0x000ff00000209400ULL, 0x000000a300a57306ULL, 0x0002b00000205400ULL,
0x0000008100987306ULL, 0x000fe20000209400ULL, 0x000000a300a37245ULL, 0x002fce000020d400ULL,
0x0000008100997306ULL, 0x0002e20000205400ULL, 0x000000a5a400720bULL, 0x004fce0003fdd000ULL,
0x0000008200a27306ULL, 0x000fe20000209400ULL, 0x0000008100817245ULL, 0x002fca000020d400ULL,
0x00000001a3a36812ULL, 0x000fe400078efcffULL, 0x0000008200837306ULL, 0x000e620000205400ULL,
0x000000999800720bULL, 0x008fce0003f7d000ULL, 0x000000ab00ac7306ULL, 0x000fec0000209400ULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x000000ab00ad7306ULL, 0x000ea20000205400ULL,
0x00000083a200720bULL, 0x002fe40003f1d000ULL, 0x000000a7a600720bULL, 0x000fca0003f7d000ULL,
0x0000007c00b17306ULL, 0x000ff00000009400ULL, 0x0000007c00b27306ULL, 0x000fe20000005400ULL,
0x000000adac00720bULL, 0x004fe40003fbd000ULL, 0x0000000187873812ULL, 0x000fca00078efcffULL,
0x0000007d00b97306ULL, 0x000ff00000009400ULL, 0x0000007d00ba7306ULL, 0x000ff00000005400ULL,
0x000000bb00bc7306ULL, 0x000ff00000209400ULL, 0x000000bb008b7306ULL, 0x000e700000205400ULL,
0x0000007c00797306ULL, 0x0004f0000000d400ULL, 0x0000007e00bd7306ULL, 0x000fe20000009400ULL,
0x000100007c7c7824ULL, 0x004fe200078e00ffULL, 0x0000008bbc00720bULL, 0x002fc40003fdd000ULL,
0x00000018ff8b7819ULL, 0x000fe40000011493ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007e00be7306ULL, 0x000fee0000005400ULL, 0x000000018c8c6812ULL, 0x000fe200078efcffULL,
0x0000007e001f7306ULL, 0x0003f0000000d400ULL, 0x0000007f00bf7306ULL, 0x000fe20000009400ULL,
0x00000082007e7245ULL, 0x002fc4000020d400ULL, 0x000000b300827245ULL, 0x000fe4000020d400ULL,
0x000000017e7e0812ULL, 0x000fe400078efcffULL, 0x000000b2b100720bULL, 0x000fe20003f1d000ULL,
0x0000007f00c07306ULL, 0x000fe20000005400ULL, 0x0000007ea37e723eULL, 0x000fce00000010ffULL,
0x0000007f00217306ULL, 0x0003e8000000d400ULL, 0x0000000179790812ULL, 0x008fc800078efcffULL,
0x0000007d006b7306ULL, 0x000ea2000000d400ULL, 0x000000ab007f7245ULL, 0x002fc8000020d400ULL,
0x000000017f7f5812ULL, 0x000fe400078efcffULL, 0x000000bab900720bULL, 0x000fe20003fbd000ULL,
0x000000ae00af7306ULL, 0x000ff00000209400ULL, 0x000000ae00b07306ULL, 0x0002e80000205400ULL,
0x000000016b6b5812ULL, 0x004fc800078efcffULL, 0x000000b600b77306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x002fce000020d400ULL, 0x000000b600b87306ULL, 0x000e620000205400ULL,
0x000000b0af00720bULL, 0x008fce0003f9d000ULL, 0x000000b300b47306ULL, 0x000fec0000209400ULL,
0x00000001aeae4812ULL, 0x000fe400078efcffULL, 0x000000b300b57306ULL, 0x000ea20000205400ULL,
0x000000b8b700720bULL, 0x002fe40003f1d000ULL, 0x000000bebd00720bULL, 0x000fc40003f9d000ULL,
0x0000007fae7f723eULL, 0x000fc600000010ffULL, 0x0000007c00227306ULL, 0x000fe80000209400ULL,
0x0000007e7058723cULL, 0x080f680000041858ULL, 0x0000007c007d7306ULL, 0x000e620000205400ULL,
0x000000b5b400720bULL, 0x004fe40003f7d000ULL, 0x000000011f1f4812ULL, 0x000fe200078efcffULL,
0x0000007e6c38723cULL, 0x000f680000041838ULL, 0x0000008d008e7306ULL, 0x000fec0000209400ULL,
0x0000000182823812ULL, 0x000fc400078efcffULL, 0x0000008d00917306ULL, 0x0004e20000205400ULL,
0x0000007d2200720bULL, 0x002fe40003fdd000ULL, 0x000000262722723eULL, 0x000fe400000010ffULL,
0x000000808f26723eULL, 0x000fe400000010ffULL, 0x000000819a27723eULL, 0x000fe200000010ffULL,
0x00000086008a7306ULL, 0x000fe20000209400ULL, 0x0000007c00807245ULL, 0x000fe2000020d400ULL,
0x000000227064723cULL, 0x000f620000041864ULL, 0x000000b600817245ULL, 0x000fc4000020d400ULL,
0x0000008d008d7245ULL, 0x004fe4000020d400ULL, 0x0000000180806812ULL, 0x000fe200078efcffULL,
0x0000008600897306ULL, 0x0002a20000205400ULL, 0x000000918e00720bULL, 0x008fe20003fbd000ULL,
0x000000267060723cULL, 0x000f620000041860ULL, 0x0000000181810812ULL, 0x000fe400078efcffULL,
0x000000c0bf00720bULL, 0x000fe40003f7d000ULL, 0x000000889f7c723eULL, 0x000fe200000010ffULL,
0x0000009200837306ULL, 0x000fe20000209400ULL, 0x0000008600867245ULL, 0x002fe2000020d400ULL,
0x000000226c44723cULL, 0x000f620000041844ULL, 0x000000808180723eULL, 0x000fc400000010ffULL,
0x00000087a87d723eULL, 0x000fe400000010ffULL, 0x000000018d8d5812ULL, 0x000fe200078efcffULL,
0x0000009200907306ULL, 0x0002e20000205400ULL, 0x000000898a00720bULL, 0x004fe20003fdd000ULL,
0x000000266c40723cULL, 0x000f620000041840ULL, 0x0000000121213812ULL, 0x000fe400078efcffULL,
0x000000798282723eULL, 0x000fc600000010ffULL, 0x0000009600957306ULL, 0x000fe20000209400ULL,
0x0000009200927245ULL, 0x002fe2000020d400ULL, 0x0000007c705c723cULL, 0x080f68000004185cULL,
0x0000000186866812ULL, 0x000fe400078efcffULL, 0x0000009600987306ULL, 0x0002a20000205400ULL,
0x000000908300720bULL, 0x008fe20003f1d000ULL, 0x0000007c6c3c723cULL, 0x000f62000004183cULL,
0x0000006b8c83723eULL, 0x000fc400000010ffULL, 0x0000008d8681723eULL, 0x000fe400000010ffULL,
0x00000097006b7245ULL, 0x000fe2000020d400ULL, 0x0000008b00937306ULL, 0x000fe20000209400ULL,
0x0000009600967245ULL, 0x002fe2000020d400ULL, 0x000000827054723cULL, 0x040f680000041854ULL,
0x0000000192920812ULL, 0x000fe400078efcffULL, 0x0000008b008e7306ULL, 0x0002e20000205400ULL,
0x000000989500720bULL, 0x004fe20003fbd000ULL, 0x000000807050723cULL, 0x000f620000041850ULL,
0x0000001f9292723eULL, 0x000fe200000010ffULL, 0x000000021a1f7824ULL, 0x000fc800078e00ffULL,
0x0000006a007a7306ULL, 0x000fe20000209400ULL, 0x0000008b008b7245ULL, 0x002fe2000020d400ULL,
0x000000826c34723cULL, 0x000f620000041834ULL, 0xfffffff81f1f7812ULL, 0x000fc600078ec0ffULL,
0x0000000196965812ULL, 0x000fe400078efcffULL, 0x0000006a00857306ULL, 0x0002a20000205400ULL,
0x0000008e9300720bULL, 0x008fe20003f9d000ULL, 0x000000806c30723cULL, 0x000f620000041830ULL,
0x000000219693723eULL, 0x000fca00000010ffULL, 0x0000002500847306ULL, 0x000fe20000209400ULL,
0x0000006a006a7245ULL, 0x002fe2000020d400ULL, 0x00000092704c723cULL, 0x080f68000004184cULL,
0x000000018b8b4812ULL, 0x000fe400078efcffULL, 0x00000025007b7306ULL, 0x000e620000205400ULL,
0x000000857a00720bULL, 0x004fe20003fdd000ULL, 0x000000926c2c723cULL, 0x000f62000004182cULL,
0x00000025007a7245ULL, 0x000fca000020d400ULL, 0x0000009700897306ULL, 0x000fec0000209400ULL,
0x000000016a6a6812ULL, 0x000fe400078efcffULL, 0x0000009700887306ULL, 0x000ea20000205400ULL,
0x0000007b8400720bULL, 0x002fe40003f1d000ULL, 0x0000008b6a6a723eULL, 0x000fd600000010ffULL,
0x000000017a7a0812ULL, 0x000fe400078efcffULL, 0x000000888900720bULL, 0x004fda0003fbd000ULL,
0x000000016b6b5812ULL, 0x000fc800078efcffULL, 0x0000006b7a6b723eULL, 0x000fce00000010ffULL,
0x0000006a7048723cULL, 0x080f700000041848ULL, 0x0000006a6c28723cULL, 0x000b6e0000041828ULL,
0x000126c8136a7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006a6a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x012688001fff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff217224ULL, 0x000fc600078e00ffULL,
0x0000000000227805ULL, 0x000fc80000015200ULL, 0x000004000d1f7984ULL, 0x004ea40000000800ULL,
0x800000001fff7812ULL, 0x006fc4000780486bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002622267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e23ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1f7819ULL, 0x000fc80000011427ULL,
0x000000261f1f7211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x000000021f1f7819ULL, 0x000fc80000001226ULL, 0x0000001f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000121217810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000d1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000800c217810ULL, 0x000fca0007ffe0ffULL, 0x0000680012257a24ULL, 0x000fe200078e0221ULL,
0x000003d00000a947ULL, 0x000fea0003800000ULL, 0x00000021161f7217ULL, 0x000fe20007800000ULL,
0x00000010116e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff277819ULL, 0x000fc60000011617ULL,
0x000000011f1f7824ULL, 0x000fe200078e0a21ULL, 0x00000004276b7810ULL, 0x040fe20007ffe0ffULL,
0x000000016e227824ULL, 0x040fe200078e0227ULL, 0x00000008276d7810ULL, 0x040fe40007ffe0ffULL,
0x0000001f6e1f7217ULL, 0x000fe20007800000ULL, 0x0000000122217824ULL, 0x040fe200078e0217ULL,
0x0000000c276f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000822267824ULL, 0x000fe400078e00ffULL,
0x000000016e707824ULL, 0x000fc400078e026bULL, 0x0000000122227824ULL, 0x000fe200078e0225ULL,
0xfffffff826217812ULL, 0x000fe200078ee221ULL, 0x000000011f1f7824ULL, 0x000fe400078e0a6eULL,
0x0000000170267824ULL, 0x000fe400078e0225ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000001f2700720cULL, 0x080fe40003f06070ULL, 0x0000001f6b00720cULL, 0x000fe20003f86070ULL,
0x000000016e727824ULL, 0x000fe200078e026dULL, 0x0000000b226c7212ULL, 0x000fe200078efcffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000001f6d00720cULL, 0x000fc40003f66070ULL,
0x000064006c6c7a10ULL, 0x000fe20007fbe0ffULL, 0x00000001726a7824ULL, 0x000fe200078e0225ULL,
0x0000000b26267212ULL, 0x000fe200078efcffULL, 0x000000016e6e7824ULL, 0x000fe200078e026fULL,
0x00006500236d7a10ULL, 0x000fe20002ffe4ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000640026267a10ULL, 0x000fe40007fde0ffULL, 0x0000001f6f00720cULL, 0x000fe20003fa6070ULL,
0x000000016e227824ULL, 0x000fe200078e0225ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x0000000170257824ULL, 0x000fe200078e0217ULL, 0x0000650027277a10ULL, 0x000fe200037fe4ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x000064006a6a7a10ULL, 0x000fc60007fde0ffULL,
0x0000000870707824ULL, 0x000fe200078e00ffULL, 0x0000000b22227212ULL, 0x000fe200078efcffULL,
0x00000001721f7824ULL, 0x040fe200078e0217ULL, 0x000065006b6b7a10ULL, 0x000fe200037fe4ffULL,
0x0000000872727824ULL, 0x000fe200078e00ffULL, 0xfffffff870257812ULL, 0x000fe200078ee225ULL,
0x000000016e6f7824ULL, 0x000fe200078e0217ULL, 0x0000640022227a10ULL, 0x000fe20007fde0ffULL,
0x000000086e6e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8721f7812ULL, 0x000fe200078ee21fULL,
0x0000001021217824ULL, 0x100fe200078e0200ULL, 0x0000650023237a10ULL, 0x000fe200037fe4ffULL,
0x0000001025257824ULL, 0x100fe200078e0200ULL, 0xfffffff86e6f7812ULL, 0x000fe200078ee26fULL,
0x000000101f1f7824ULL, 0x100fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c217faeULL, 0x0003e6000c101c46ULL, 0x000000106f6f7824ULL, 0x000fe200078e0200ULL,
0x0000000026257faeULL, 0x0003e8000e101c46ULL, 0x000000006a1f7faeULL, 0x0003e8000d901c46ULL,
0x00000000226f7faeULL, 0x0003e2000e901c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001011227824ULL, 0x000fca00078e00ffULL, 0x0000002217267211ULL, 0x000fc800078fe8ffULL,
0x00000004266a7810ULL, 0x040fe20007ffe0ffULL, 0x00000001261f7824ULL, 0x140fe200078e0217ULL,
0x00000008266c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000826227824ULL, 0x000fe400078e00ffULL,
0x000000016a217824ULL, 0x040fe400078e0217ULL, 0x000000086a6e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8221f7812ULL, 0x000fe200078ee21fULL, 0x000000016c237824ULL, 0x040fe400078e0217ULL,
0x000000086c707824ULL, 0x000fe200078e00ffULL, 0xfffffff86e217812ULL, 0x000fe200078ee221ULL,
0x0000000126227824ULL, 0x140fe200078e0225ULL, 0x0000000c266e7810ULL, 0x000fe20007ffe0ffULL,
0x000000016a267824ULL, 0x000fe200078e0225ULL, 0xfffffff8706f7812ULL, 0x000fe200078ee223ULL,
0x0000008022227825ULL, 0x000fc800078e00ffULL, 0x000000016c6a7824ULL, 0x100fe200078e0225ULL,
0x0000000b22227212ULL, 0x000fe200078efcffULL, 0x000000016e6c7824ULL, 0x000fe400078e0225ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000640022227a10ULL, 0x000fc60007f1e0ffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b26267212ULL, 0x080fe400078efcffULL,
0x0000650023237a10ULL, 0x000fe200007fe4ffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000000b6a6a7212ULL, 0x080fe400078efcffULL, 0x0000640026267a10ULL, 0x000fe20007f7e0ffULL,
0x000000016e257824ULL, 0x000fe200078e0217ULL, 0x0000000b6c6c7212ULL, 0x000fe200078efcffULL,
0x000000086e6e7824ULL, 0x000fe200078e00ffULL, 0x000064006a6a7a10ULL, 0x000fe20007f1e0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0200ULL, 0x000064006c6c7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001021217824ULL, 0x100fe200078e0200ULL, 0xfffffff86e257812ULL, 0x000fe200078ee225ULL,
0x000000106f6f7824ULL, 0x100fe200078e0200ULL, 0x0000650027277a10ULL, 0x000fe20001ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000221f7faeULL, 0x0003e2000b901c46ULL,
0x000065006b6b7a10ULL, 0x000fe200007fe4ffULL, 0x0000001025257824ULL, 0x000fe200078e0200ULL,
0x000065006d6d7a10ULL, 0x000fe200027fe4ffULL, 0x0000000026217faeULL, 0x0003e8000b901c46ULL,
0x000000006a6f7faeULL, 0x0003e8000b901c46ULL, 0x000000006c257faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000080503c2ULL, 0x000e640000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x002fe20008000a05ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000086c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01262800206a7f8cULL, 0x000664000c80043fULL, 0x0000000000227805ULL, 0x000fc40000015200ULL,
0xffffffe0141f7812ULL, 0x040fe400078ec0ffULL, 0x0000001014267812ULL, 0x000fca00078ec0ffULL,
0x000000011f267824ULL, 0x000fc800078e0226ULL, 0x0000000811217824ULL, 0x000fca00078e0226ULL,
0x01262c00211f7984ULL, 0x000f240000000800ULL, 0x800000001fff7812ULL, 0x012fe4000780486bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002622267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e23ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1f7819ULL, 0x000fc80000011427ULL,
0x000000261f1f7211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x000000021f1f7819ULL, 0x000fc80000001226ULL, 0x0000001f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01262c00211f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201a1f7824ULL, 0x000fca00078e00ffULL, 0xffffff801f227812ULL, 0x000fc800078ec0ffULL,
0x000000800b1f7810ULL, 0x000fca0007ffe022ULL, 0x000000010a1f7824ULL, 0x000fca00078e021fULL,
0x012000001f217984ULL, 0x000e680000000800ULL, 0x012200001f227984ULL, 0x0006a20000000800ULL,
0x0000001e2100720bULL, 0x002fe20003f1d000ULL, 0x000153027f007947ULL, 0x000fd8000b800000ULL,
0x00000000001f7806ULL, 0x008fc800000e0100ULL, 0x000000ff1f00720cULL, 0x000fe20003f05270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fd200078e001eULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x0000000110237810ULL, 0x000fe40007ffe0ffULL, 0x0000001e2100720bULL, 0x000fe40003f74000ULL,
0x0000001a2300720cULL, 0x000fe20003f05270ULL, 0x000152b27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000707806ULL, 0x000fc400018e0100ULL, 0x000000801a258824ULL, 0x000fe200078e020bULL,
0x0000001e21237209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a268824ULL, 0x000fca00078e0225ULL, 0x0124002326008388ULL, 0x0003e20000000800ULL,
0x000000ff7000720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000001e231e7221ULL, 0x002fe20000010100ULL, 0x000000ff70ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL,
0x0000001e00277308ULL, 0x000e640000000800ULL, 0x0000002724247220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x000151f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x000000264c4c7220ULL, 0x080fe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0070ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x000150b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x00066400000e0000ULL, 0x0000002666667220ULL, 0x086fe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x000000264e4e7220ULL, 0x080fe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000070ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x00014f727f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x000000262c2c7220ULL, 0x080fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002628287220ULL, 0x080fe20000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000070ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x00014e427f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x000000262e2e7220ULL, 0x080fe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x000000262a2a7220ULL, 0x080fe20000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x000000701fff7212ULL, 0x000fda00078030ffULL,
0x8000002321210221ULL, 0x000fe20000010000ULL, 0x00007610ff6e0816ULL, 0x000fc6000000006eULL,
0x3fb8aa3b21210820ULL, 0x000fc80000410000ULL, 0x0000002100090308ULL, 0x000e640000000800ULL,
0x0000000922220220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002422247221ULL, 0x004fc20000010000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0xfffffff0146a7812ULL, 0x000fca00078ec0ffULL, 0x0126b4006a217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x008fcc0000015200ULL,
0x000000261e227210ULL, 0x000fca0007f1e1ffULL, 0x0000000127267824ULL, 0x000fe200000e0e1fULL,
0x003d09002200780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402200780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff217819ULL, 0x000fc80000011426ULL, 0x0000002221217211ULL, 0x000fca00078110ffULL,
0x000000ffff227224ULL, 0x000fca00000e0626ULL, 0x0000000221217819ULL, 0x000fc80000001222ULL,
0x000000210000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126b4006a217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099106e1e7816ULL, 0x000fc800000000ffULL,
0x000000ff1e00720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff1e7819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x008fe20000000004ULL, 0x00014a227f007947ULL, 0x000fea000b800000ULL,
0x00001f1e27077589ULL, 0x0002a400000e0000ULL, 0x000000081e267810ULL, 0x000fe20007ffe0ffULL,
0x00014a427f007947ULL, 0x000fea000b800000ULL, 0x000000101e047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x000000181e267810ULL, 0x008fe20007ffe0ffULL, 0x00014a727f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x000000041a1e7824ULL, 0x042fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000004001a217824ULL, 0x040fe200078e00ffULL,
0x000001b000007945ULL, 0x000fe20003800000ULL, 0x000010001a1f7824ULL, 0x000fe200078e00ffULL,
0x000000041e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000803267824ULL, 0x008fe200078e00ffULL,
0xfffff00021217812ULL, 0x000fe200078ec0ffULL, 0x0000000803277824ULL, 0x000fe200078e00ffULL,
0x0000001e171e7211ULL, 0x000fc400078fe0ffULL, 0x0000b00021217810ULL, 0x000fe40007ffe0ffULL,
0xffffe0001f227812ULL, 0x000fe200078ec0ffULL, 0x00000001031f7824ULL, 0x000fe400078e021eULL,
0x000000101c707824ULL, 0x100fe200078e0221ULL, 0x0000f00022257810ULL, 0x000fe20007ffe0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0221ULL, 0xfffffff8261c7812ULL, 0x000fe400078ee21fULL,
0x000000021f227810ULL, 0x000fe20007ffe0ffULL, 0x000000007070783bULL, 0x000e640000000200ULL,
0x000000101c807824ULL, 0x000fc400078e0225ULL, 0x000000001d68783bULL, 0x0006a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000770707231ULL, 0x086fe400003400ffULL,
0x0000000772727231ULL, 0x000fe400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fe400003400ffULL, 0x0000000568687231ULL, 0x080fe400003400ffULL,
0x000000056a6a7231ULL, 0x000fc400003400ffULL, 0x0000000469697231ULL, 0x080fe400003400ffULL,
0x000000046b6b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000008080783bULL, 0x000f220000004200ULL, 0xfffffff827227812ULL, 0x000fe200078ee222ULL,
0x0000108000007945ULL, 0x000fe80003800000ULL, 0x00000010227c7824ULL, 0x000fcc00078e0225ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000100806f7824ULL, 0x010fe200078e00ffULL,
0x0000008000267306ULL, 0x000fe20000009400ULL, 0x00000100818f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fe20000011480ULL, 0x0000010083a47824ULL, 0x040fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001146fULL, 0x0000010082a17824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe2000001148fULL, 0x0001000083ad7824ULL, 0x000fe200078e00ffULL,
0x0000006f008d7306ULL, 0x000fe20000209400ULL, 0x00000018ff9c7819ULL, 0x000fc40000011481ULL,
0x00000018ffaa7819ULL, 0x000fe200000114a4ULL, 0x000001007cb57824ULL, 0x008fe200078e00ffULL,
0x00000018ffa57819ULL, 0x000fe40000011482ULL, 0x00000018ffa17819ULL, 0x000fe200000114a1ULL,
0x0000006f008e7306ULL, 0x0007220000205400ULL, 0x00000018ffad7819ULL, 0x000fe400000114adULL,
0x00000018ffb07819ULL, 0x000fe40000011483ULL, 0x00000018ffb57819ULL, 0x000fc400000114b5ULL,
0x00000018ffb77819ULL, 0x000fe2000001147cULL, 0x0000008000277306ULL, 0x000ea20000005400ULL,
0x0000006f006f7245ULL, 0x008fe4000020d400ULL, 0x00000018ff8a7819ULL, 0x000fe4000001147dULL,
0x00000018ff797819ULL, 0x000fe4000001147eULL, 0x00000018ff257819ULL, 0x000fe2000001147fULL,
0x00000080006e7306ULL, 0x000662000000d400ULL, 0x0000008e8d00720bULL, 0x010fce0003fdd000ULL,
0x0000009700987306ULL, 0x000fe20000209400ULL, 0x0001000080807824ULL, 0x008fe200078e00ffULL,
0x000000272600720bULL, 0x004fe20003fbd000ULL, 0x000001007d267824ULL, 0x000fe200078e00ffULL,
0x0000009700277245ULL, 0x000fe4000020d400ULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x0000009700997306ULL, 0x000ea20000205400ULL, 0x000000016f6f6812ULL, 0x000fcc00078efcffULL,
0x000000016e6e5812ULL, 0x002fe200078efcffULL, 0x0000008100947306ULL, 0x000ff00000009400ULL,
0x0000008100957306ULL, 0x000e620000005400ULL, 0x000000999800720bULL, 0x004fc40003f7d000ULL,
0x00000018ff987819ULL, 0x000fca0000011426ULL, 0x0000008100967306ULL, 0x0004ec000000d400ULL,
0x0000000127273812ULL, 0x000fe400078efcffULL, 0x00000080008f7306ULL, 0x000fe20000209400ULL,
0x0001000081817824ULL, 0x004fe200078e00ffULL, 0x000000959400720bULL, 0x002fc80003f9d000ULL,
0x00000018ff817819ULL, 0x000fe40000011481ULL, 0x0000008000907306ULL, 0x0002ae0000205400ULL,
0x0000000196964812ULL, 0x008fe200078efcffULL, 0x00000081009a7306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fc4000020d400ULL, 0x000000962727723eULL, 0x000fca00000010ffULL,
0x00000081009b7306ULL, 0x0002e20000205400ULL, 0x000000908f00720bULL, 0x004fe20003fdd000ULL,
0x000100007d907824ULL, 0x000fcc00078e00ffULL, 0x00000082009f7306ULL, 0x000fe20000009400ULL,
0x0000008100817245ULL, 0x002fca000020d400ULL, 0x0000000180806812ULL, 0x000fe400078efcffULL,
0x0000008200a07306ULL, 0x000e620000005400ULL, 0x0000009b9a00720bULL, 0x008fce0003f7d000ULL,
0x0000009c009d7306ULL, 0x000fec0000209400ULL, 0x0000000181813812ULL, 0x000fe400078efcffULL,
0x0000009c009e7306ULL, 0x0004e20000205400ULL, 0x000000a09f00720bULL, 0x002fce0003fdd000ULL,
0x0000009100927306ULL, 0x000fe20000209400ULL, 0x0000009c009c7245ULL, 0x004fce000020d400ULL,
0x0000009100937306ULL, 0x0002a20000205400ULL, 0x0000009e9d00720bULL, 0x008fce0003f9d000ULL,
0x000000aa00ab7306ULL, 0x000fe20000209400ULL, 0x0000009100917245ULL, 0x002fca000020d400ULL,
0x000000019c9c4812ULL, 0x000fe400078efcffULL, 0x000000aa00ac7306ULL, 0x0002e20000205400ULL,
0x000000939200720bULL, 0x004fe40003fbd000ULL, 0x00000018ff927819ULL, 0x000fe40000011490ULL,
0x000000b700907245ULL, 0x000fc6000020d400ULL, 0x00000082008c7306ULL, 0x000522000000d400ULL,
0x000000aa00aa7245ULL, 0x002fca000020d400ULL, 0x0000000191915812ULL, 0x000fe400078efcffULL,
0x0000008300a87306ULL, 0x000fe20000009400ULL, 0x000000acab00720bULL, 0x008fe20003f7d000ULL,
0x0001000082827824ULL, 0x004fca00078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011482ULL,
0x0000008300a97306ULL, 0x000e620000005400ULL, 0x000000018c8c6812ULL, 0x010fca00078efcffULL,
0x00000001aaaa3812ULL, 0x000fe400078efcffULL, 0x000000a500a67306ULL, 0x000ff00000209400ULL,
0x000000a500a77306ULL, 0x0004e20000205400ULL, 0x000000a9a800720bULL, 0x002fce0003f9d000ULL,
0x000000a100a27306ULL, 0x000fe20000209400ULL, 0x000000a500a57245ULL, 0x004fce000020d400ULL,
0x000000a100a37306ULL, 0x0002a20000205400ULL, 0x000000a7a600720bULL, 0x008fce0003fdd000ULL,
0x000000ad00ae7306ULL, 0x000fe20000209400ULL, 0x000000a100a17245ULL, 0x002fca000020d400ULL,
0x00000001a5a56812ULL, 0x000fe400078efcffULL, 0x000000ad00af7306ULL, 0x0002e20000205400ULL,
0x000000a3a200720bULL, 0x004fce0003fbd000ULL, 0x00000083008b7306ULL, 0x000ea2000000d400ULL,
0x000000ad00ad7245ULL, 0x002fca000020d400ULL, 0x00000001a1a15812ULL, 0x000fe400078efcffULL,
0x000000b000b17306ULL, 0x000fe20000209400ULL, 0x000000afae00720bULL, 0x008fce0003f7d000ULL,
0x000000b000b27306ULL, 0x0002e20000205400ULL, 0x000000018b8b4812ULL, 0x004fca00078efcffULL,
0x00000001adad3812ULL, 0x000fe400078efcffULL, 0x000000b500b67306ULL, 0x000fe20000209400ULL,
0x000000b000b07245ULL, 0x002fce000020d400ULL, 0x000000b5008d7306ULL, 0x000e620000205400ULL,
0x000000b2b100720bULL, 0x008fce0003f9d000ULL, 0x0000007c00b37306ULL, 0x000fec0000009400ULL,
0x00000001b0b04812ULL, 0x000fe400078efcffULL, 0x0000007c00b47306ULL, 0x000fe20000005400ULL,
0x0000008db600720bULL, 0x002fe40003fdd000ULL, 0x00000098008d7245ULL, 0x000fca000020d400ULL,
0x0000007c00877306ULL, 0x0003f0000000d400ULL, 0x0000008200a47306ULL, 0x000fe20000209400ULL,
0x000100007c7c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000008200837306ULL, 0x0002b00000205400ULL, 0x00000098008e7306ULL, 0x000fe20000209400ULL,
0x0000008200827245ULL, 0x002fce000020d400ULL, 0x00000098008f7306ULL, 0x000e620000205400ULL,
0x00000083a400720bULL, 0x004fe20003fbd000ULL, 0x000001007e837824ULL, 0x000fca00078e00ffULL,
0x00000018ff957819ULL, 0x000fe20000011483ULL, 0x0000007d00ba7306ULL, 0x000fe20000009400ULL,
0x000001007f837824ULL, 0x000fca00078e00ffULL, 0x0000000182825812ULL, 0x000fe400078efcffULL,
0x0000007d00bb7306ULL, 0x000ea20000005400ULL, 0x0000008f8e00720bULL, 0x002fe40003f7d000ULL,
0x000000b5008e7245ULL, 0x000fe4000020d400ULL, 0x000000b4b300720bULL, 0x000fe40003fbd000ULL,
0x000000018e8e6812ULL, 0x000fe200078efcffULL, 0x0000007d00847306ULL, 0x000e62000000d400ULL,
0x00000018ff997819ULL, 0x000fc40000011483ULL, 0x0000007c00837245ULL, 0x000fc6000020d400ULL,
0x000000018d8d3812ULL, 0x000fe400078efcffULL, 0x0000007c00267306ULL, 0x000fe20000209400ULL,
0x000000bbba00720bULL, 0x004fe40003f9d000ULL, 0x0000000187875812ULL, 0x000fca00078efcffULL,
0x0000007c007d7306ULL, 0x0004ec0000205400ULL, 0x0000000184844812ULL, 0x002fe400078efcffULL,
0x0000008a00bc7306ULL, 0x000fe20000209400ULL, 0x0000008ca17c723eULL, 0x004fce00000010ffULL,
0x0000008a00bd7306ULL, 0x0002a20000205400ULL, 0x0000007d2600720bULL, 0x008fe40003fdd000ULL,
0x0000006e6f26723eULL, 0x000fe400000010ffULL, 0x00000080916e723eULL, 0x000fe400000010ffULL,
0x0000009200917245ULL, 0x000fe2000020d400ULL, 0x0000009200937306ULL, 0x000fe20000209400ULL,
0x0000008a008a7245ULL, 0x002fe2000020d400ULL, 0x000000267064723cULL, 0x000f620000041864ULL,
0x0000008baa7d723eULL, 0x000fc400000010ffULL, 0x000000819c6f723eULL, 0x000fe400000010ffULL,
0x0000000183836812ULL, 0x000fe200078efcffULL, 0x0000009200947306ULL, 0x000e620000205400ULL,
0x000000bdbc00720bULL, 0x004fe20003f9d000ULL, 0x000000266844723cULL, 0x000b620000041844ULL,
0x000000848d81723eULL, 0x000fe400000010ffULL, 0x0000009900847245ULL, 0x000fe4000020d400ULL,
0x000000878e80723eULL, 0x000fe200000010ffULL, 0x000000b700b87306ULL, 0x000fe20000209400ULL,
0x0000000102277824ULL, 0x020fe200078e021eULL, 0x0000006e7060723cULL, 0x000f680000041860ULL,
0x000000018a8a4812ULL, 0x000fc400078efcffULL, 0x000000b700b97306ULL, 0x000ea20000205400ULL,
0x000000949300720bULL, 0x002fe20003fdd000ULL, 0x0000006e6840723cULL, 0x000b6c0000041840ULL,
0x0000007f00897306ULL, 0x000fe20000009400ULL, 0x00000008036e7824ULL, 0x020fe200078e00ffULL,
0x0000007c705c723cULL, 0x000f68000004185cULL, 0x0000000191916812ULL, 0x000fc400078efcffULL,
0x0000007f00887306ULL, 0x000e620000005400ULL, 0x000000b9b800720bULL, 0x004fe20003fbd000ULL,
0x000000807054723cULL, 0x000f620000041854ULL, 0x000000918a91723eULL, 0x000fca00000010ffULL,
0x00000099009b7306ULL, 0x000fe40000209400ULL, 0x0000007c683c723cULL, 0x040b68000004183cULL,
0x0000000190905812ULL, 0x000fe400078efcffULL, 0x00000099009e7306ULL, 0x000ea20000205400ULL,
0x000000888900720bULL, 0x002fe20003fdd000ULL, 0x000000806834723cULL, 0x000f620000041834ULL,
0x000000839090723eULL, 0x000fca00000010ffULL, 0x0000007e00be7306ULL, 0x000fe40000009400ULL,
0x000000907050723cULL, 0x080f6c0000041850ULL, 0x0000007e00bf7306ULL, 0x000e620000005400ULL,
0x0000009e9b00720bULL, 0x004fe20003f9d000ULL, 0x000000906830723cULL, 0x000f6c0000041830ULL,
0x0000009500977306ULL, 0x000fec0000209400ULL, 0x0000000184844812ULL, 0x000fc400078efcffULL,
0x00000095009a7306ULL, 0x000ea20000205400ULL, 0x000000bfbe00720bULL, 0x002fce0003f7d000ULL,
0x0000007e001d7306ULL, 0x0003f0000000d400ULL, 0x0000007f001f7306ULL, 0x000722000000d400ULL,
0x000100007e7e7824ULL, 0x002fe200078e00ffULL, 0x0000009a9700720bULL, 0x004fc80003fbd000ULL,
0x00000018ff8f7819ULL, 0x000fe4000001147eULL, 0x0000007900857306ULL, 0x000fe20000209400ULL,
0x000100007f7f7824ULL, 0x008fe200078e00ffULL, 0x00000082a57e723eULL, 0x000fe400000010ffULL,
0x0000009500827245ULL, 0x000fe4000020d400ULL, 0x00000018ff947819ULL, 0x000fe4000001147fULL,
0x0000007900867306ULL, 0x000e620000205400ULL, 0x000000011f1f6812ULL, 0x010fc400078efcffULL,
0x0000000182825812ULL, 0x000fe400078efcffULL, 0x0000001f8483723eULL, 0x000fe200000010ffULL,
0x00000008021f7824ULL, 0x000fe200078e00ffULL, 0x0000002500847245ULL, 0x000fe2000020d400ULL,
0x00000025007b7306ULL, 0x000fe20000209400ULL, 0x000000011d1d3812ULL, 0x000fe400078efcffULL,
0x000000adb07f723eULL, 0x000fe400000010ffULL, 0x0000001d8282723eULL, 0x000fc600000010ffULL,
0x00000025007a7306ULL, 0x0004e20000205400ULL, 0x000000868500720bULL, 0x002fe20003fbd000ULL,
0x0000007e7058723cULL, 0x040f6c0000041858ULL, 0x0000008f00987306ULL, 0x000fe20000209400ULL,
0x000000021a257824ULL, 0x004fe200078e00ffULL, 0x00000082704c723cULL, 0x000f68000004184cULL,
0x00000004251d7812ULL, 0x000fc400078ec0ffULL, 0x0000008f00937306ULL, 0x0002a20000205400ULL,
0x0000007a7b00720bULL, 0x008fe20003f7d000ULL, 0x0000007e6838723cULL, 0x040f620000041838ULL,
0x000000021d267812ULL, 0x000fe400078efcffULL, 0x00000079007a7245ULL, 0x000fe4000020d400ULL,
0x00000094007b7245ULL, 0x000fe2000020d400ULL, 0x00000094008b7306ULL, 0x000fe20000209400ULL,
0x0000008f008f7245ULL, 0x002fe2000020d400ULL, 0x00000082682c723cULL, 0x000f62000004182cULL,
0x0000002617267211ULL, 0x000fc400078fe0ffULL, 0x000000017a7a5812ULL, 0x000fe400078efcffULL,
0x0000000184843812ULL, 0x000fe200078efcffULL, 0x0000009400887306ULL, 0x000e620000205400ULL,
0x000000939800720bULL, 0x004fe20003f9d000ULL, 0x00000001031d7824ULL, 0x100fe400078e0226ULL,
0x0000000102267824ULL, 0x000fc600078e0226ULL, 0xfffffff86e1d7812ULL, 0x000fe200078ee21dULL,
0x00000008026e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1e7812ULL, 0x000fe400078ee226ULL,
0x0000100000267810ULL, 0x000fe40007ffe0ffULL, 0xfffffff86e1f7812ULL, 0x000fe400078ee227ULL,
0x000000018f8f4812ULL, 0x000fe400078efcffULL, 0x000000888b00720bULL, 0x002fe20003fdd000ULL,
0x000000101f7c7824ULL, 0x020fe200078e0226ULL, 0x0000008f7a7a723eULL, 0x000fc400000010ffULL,
0x0000000227277810ULL, 0x000fd20007ffe0ffULL, 0x000000017b7b6812ULL, 0x000fc800078efcffULL,
0x0000007b847b723eULL, 0x000fce00000010ffULL, 0x0000007a7048723cULL, 0x080b6e0000041848ULL,
0x000000101d707824ULL, 0x120fe200078e0221ULL, 0x0000007a6828723cULL, 0x000b620000041828ULL,
0x000000101e217824ULL, 0x000fc800078e0221ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000002168783bULL, 0x0204e20000000200ULL, 0x0000008000000947ULL, 0x000fd20003800000ULL,
0x0000000770707231ULL, 0x082fe400003400ffULL, 0x0000000772727231ULL, 0x000fe400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fc400003400ffULL,
0x0000000568687231ULL, 0x088fe400003400ffULL, 0x000000056a6a7231ULL, 0x000fe400003400ffULL,
0x0000000469697231ULL, 0x080fe400003400ffULL, 0x000000046b6b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007c7c783bULL, 0x000f220000004200ULL,
0xfffffff86e217812ULL, 0x004fca00078ee227ULL, 0x0000001021807824ULL, 0x000fcc00078e0226ULL,
0x000000008080783bULL, 0x000ea20000004200ULL, 0x000001007c6f7824ULL, 0x010fe200078e00ffULL,
0x0000007c00267306ULL, 0x000fe20000009400ULL, 0x00000018ff937819ULL, 0x000fe2000001147cULL,
0x000001007d927824ULL, 0x040fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe2000001147dULL,
0x000100007d9c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001146fULL,
0x000001007ea47824ULL, 0x000fe200078e00ffULL, 0x00000018ff997819ULL, 0x000fe20000011492ULL,
0x0000007c00277306ULL, 0x000f220000005400ULL, 0x000001007fa77824ULL, 0x000fe200078e00ffULL,
0x00000018ffa97819ULL, 0x000fe2000001147eULL, 0x0000010081c07824ULL, 0x004fe200078e00ffULL,
0x00000018ffa47819ULL, 0x000fe200000114a4ULL, 0x0000010080b87824ULL, 0x000fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe200000114a7ULL, 0x0001000083c77824ULL, 0x000fe200078e00ffULL,
0x0000006f00907306ULL, 0x000fe20000209400ULL, 0x00000018ffb37819ULL, 0x000fc4000001147fULL,
0x00000018ffc07819ULL, 0x000fe400000114c0ULL, 0x00000018ff9c7819ULL, 0x000fe4000001149cULL,
0x00000018ffbb7819ULL, 0x000fe20000011480ULL, 0x0000006f00917306ULL, 0x0004e20000205400ULL,
0x000000272600720bULL, 0x010fe40003f9d000ULL, 0x00000018ff8b7819ULL, 0x000fe40000011481ULL,
0x00000018ff847819ULL, 0x000fc40000011482ULL, 0x00000018ff7b7819ULL, 0x000fe20000011483ULL,
0x0000007c006e7306ULL, 0x000862000000d400ULL, 0x0000006f006f7245ULL, 0x004fe4000020d400ULL,
0x0000009900277245ULL, 0x000fe4000020d400ULL, 0x00000018ffb87819ULL, 0x000fe400000114b8ULL,
0x00000018ffc77819ULL, 0x000fe200000114c7ULL, 0x0000007d00967306ULL, 0x000fe20000009400ULL,
0x000100007c7c7824ULL, 0x010fe200078e00ffULL, 0x000000919000720bULL, 0x008fc80003fdd000ULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007d00977306ULL, 0x000ea20000005400ULL,
0x000000016e6e4812ULL, 0x002fcc00078efcffULL, 0x000000016f6f6812ULL, 0x000fe200078efcffULL,
0x0000007d00987306ULL, 0x000e70000000d400ULL, 0x0000007c00927306ULL, 0x000fe20000209400ULL,
0x000000979600720bULL, 0x004fe20003f1d000ULL, 0x0001000082977824ULL, 0x000fca00078e00ffULL,
0x00000018ff977819ULL, 0x000fe20000011497ULL, 0x0000007c007d7306ULL, 0x0004ec0000205400ULL,
0x0000000198980812ULL, 0x002fe400078efcffULL, 0x0000009300947306ULL, 0x000fe20000209400ULL,
0x0000007c007c7245ULL, 0x004fce000020d400ULL, 0x0000009300957306ULL, 0x0002a20000205400ULL,
0x0000007d9200720bULL, 0x008fe40003fdd000ULL, 0x000000ae007d7245ULL, 0x000fca000020d400ULL,
0x000000a400a57306ULL, 0x000fe20000209400ULL, 0x0000009300937245ULL, 0x002fca000020d400ULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x000000a400a67306ULL, 0x0002e20000205400ULL,
0x000000959400720bULL, 0x004fce0003fbd000ULL, 0x0000009f00a07306ULL, 0x000fe20000209400ULL,
0x000000a400a47245ULL, 0x002fca000020d400ULL, 0x0000000193935812ULL, 0x000fe400078efcffULL,
0x0000009f00a17306ULL, 0x0002a20000205400ULL, 0x000000a6a500720bULL, 0x008fce0003fdd000ULL,
0x000000ae00af7306ULL, 0x000fe20000209400ULL, 0x0000009f009f7245ULL, 0x002fca000020d400ULL,
0x00000001a4a46812ULL, 0x000fe400078efcffULL, 0x000000ae00b07306ULL, 0x000e620000205400ULL,
0x000000a1a000720bULL, 0x004fce0003f1d000ULL, 0x0000007e00a27306ULL, 0x000fec0000009400ULL,
0x000000019f9f0812ULL, 0x000fe400078efcffULL, 0x0000007e00a37306ULL, 0x000ea20000005400ULL,
0x000000b0af00720bULL, 0x002fce0003fbd000ULL, 0x0000007e008d7306ULL, 0x0002ec000000d400ULL,
0x000000017d7d5812ULL, 0x000fe400078efcffULL, 0x0000007f00ac7306ULL, 0x000fe20000009400ULL,
0x000100007e7e7824ULL, 0x002fe200078e00ffULL, 0x000000a3a200720bULL, 0x004fc80003f9d000ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000007f00ad7306ULL, 0x000fee0000005400ULL,
0x000000018d8d4812ULL, 0x008fe200078efcffULL, 0x0000007f008c7306ULL, 0x0003f0000000d400ULL,
0x000000a900aa7306ULL, 0x000fe20000209400ULL, 0x000100007f7f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x000000a900ab7306ULL, 0x0002b00000205400ULL,
0x00000099009a7306ULL, 0x000fe20000209400ULL, 0x000000a900a97245ULL, 0x002fce000020d400ULL,
0x00000099009b7306ULL, 0x000e620000205400ULL, 0x000000abaa00720bULL, 0x004fce0003fdd000ULL,
0x0000007e00a77306ULL, 0x000fec0000209400ULL, 0x00000001a9a96812ULL, 0x000fe400078efcffULL,
0x0000007e00a87306ULL, 0x0004e20000205400ULL, 0x0000009b9a00720bULL, 0x002fe20003f7d000ULL,
0x00000100839a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe2000001149aULL,
0x0000007f00b17306ULL, 0x000fe20000209400ULL, 0x0000007e007e7245ULL, 0x004fca000020d400ULL,
0x0000000127273812ULL, 0x000fe400078efcffULL, 0x0000007f00b27306ULL, 0x0002a20000205400ULL,
0x000000a8a700720bULL, 0x008fe40003f1d000ULL, 0x000000982727723eULL, 0x000fca00000010ffULL,
0x000000c000c17306ULL, 0x000fe20000209400ULL, 0x0000007f007f7245ULL, 0x002fca000020d400ULL,
0x000000017e7e0812ULL, 0x000fe400078efcffULL, 0x000000c000c27306ULL, 0x0002e20000205400ULL,
0x000000b2b100720bULL, 0x004fe40003fbd000ULL, 0x0000007ea97e723eULL, 0x000fca00000010ffULL,
0x0000008000b67306ULL, 0x000fe20000009400ULL, 0x000000c000c07245ULL, 0x002fca000020d400ULL,
0x000000017f7f5812ULL, 0x000fe400078efcffULL, 0x0000008000b77306ULL, 0x000e620000005400ULL,
0x000000c2c100720bULL, 0x008fce0003fdd000ULL, 0x0000008100be7306ULL, 0x000fec0000009400ULL,
0x00000001c0c06812ULL, 0x000fe400078efcffULL, 0x0000008100bf7306ULL, 0x000ea20000005400ULL,
0x000000b7b600720bULL, 0x002fce0003f1d000ULL, 0x0000009c009d7306ULL, 0x000ff00000209400ULL,
0x0000009c009e7306ULL, 0x0002e20000205400ULL, 0x000000bfbe00720bULL, 0x004fce0003fbd000ULL,
0x0000008000887306ULL, 0x000522000000d400ULL, 0x0000009c009c7245ULL, 0x002fce000020d400ULL,
0x0000008100857306ULL, 0x000322000000d400ULL, 0x0001000080807824ULL, 0x004fe200078e00ffULL,
0x0000009e9d00720bULL, 0x008fc80003f7d000ULL, 0x00000018ff907819ULL, 0x000fe20000011480ULL,
0x0000010082807824ULL, 0x000fe200078e00ffULL, 0x0000008200c37306ULL, 0x000fe20000009400ULL,
0x0001000081817824ULL, 0x002fe200078e00ffULL, 0x0000000188880812ULL, 0x010fe400078efcffULL,
0x00000018ff947819ULL, 0x000fe40000011480ULL, 0x000000b300807245ULL, 0x000fe4000020d400ULL,
0x0000008200c47306ULL, 0x000fe20000005400ULL, 0x000000019c9c3812ULL, 0x000fc400078efcffULL,
0x0000000185855812ULL, 0x000fe400078efcffULL, 0x000000adac00720bULL, 0x000fc60003f7d000ULL,
0x00000082007a7306ULL, 0x0003f0000000d400ULL, 0x0000008300c57306ULL, 0x000fe20000009400ULL,
0x00000018ff827819ULL, 0x002fe40000011481ULL, 0x000000018c8c3812ULL, 0x000fc400078efcffULL,
0x000000b800817245ULL, 0x000fe4000020d400ULL, 0x0000008c7d7d723eULL, 0x000fe200000010ffULL,
0x0000008300c67306ULL, 0x000ff00000005400ULL, 0x0000008300797306ULL, 0x000ff0000000d400ULL,
0x0000009000267306ULL, 0x000ff00000209400ULL, 0x0000009000837306ULL, 0x0002b00000205400ULL,
0x000000b300b47306ULL, 0x000fe20000209400ULL, 0x0000009000907245ULL, 0x002fce000020d400ULL,
0x000000b300b57306ULL, 0x000e620000205400ULL, 0x000000832600720bULL, 0x004fe40003fdd000ULL,
0x0000006e6f26723eULL, 0x000fe400000010ffULL, 0x0000007c936e723eULL, 0x000fe400000010ffULL,
0x0000008da47c723eULL, 0x000fe200000010ffULL, 0x000000bb00bc7306ULL, 0x000fe20000209400ULL,
0x0000009400837245ULL, 0x000fe2000020d400ULL, 0x000000267064723cULL, 0x000f620000041864ULL,
0x0000009c9f6f723eULL, 0x000fc600000010ffULL, 0x0000000190906812ULL, 0x000fe400078efcffULL,
0x000000bb00bd7306ULL, 0x0004e20000205400ULL, 0x000000b5b400720bULL, 0x002fe20003f9d000ULL,
0x0000006e7060723cULL, 0x040f6c0000041860ULL, 0x0000008200917306ULL, 0x000fe20000209400ULL,
0x000000bb00bb7245ULL, 0x004fe2000020d400ULL, 0x0000007c705c723cULL, 0x000f68000004185cULL,
0x0000000180804812ULL, 0x000fc400078efcffULL, 0x0000008200927306ULL, 0x000e620000205400ULL,
0x000000bdbc00720bULL, 0x008fe20003f1d000ULL, 0x000000266844723cULL, 0x000b620000041844ULL,
0x000000c4c300720bULL, 0x000fe40003f9d000ULL, 0x0000007f807f723eULL, 0x000fc600000010ffULL,
0x0000008b008f7306ULL, 0x000fe20000209400ULL, 0xfffffff825267812ULL, 0x020fe200078ec0ffULL,
0x0000006e6840723cULL, 0x000f680000041840ULL, 0x00000001bbbb0812ULL, 0x000fe400078efcffULL,
0x0000008b008e7306ULL, 0x000ea20000205400ULL, 0x000000929100720bULL, 0x002fe20003fbd000ULL,
0x0000007e7058723cULL, 0x000f620000041858ULL, 0x0000008200917245ULL, 0x000fc4000020d400ULL,
0x0000008b00827245ULL, 0x000fe4000020d400ULL, 0x000000017a7a4812ULL, 0x000fe200078efcffULL,
0x000000b800b97306ULL, 0x000fe20000209400ULL, 0x00000090bb90723eULL, 0x000fe200000010ffULL,
0x0000007c683c723cULL, 0x040f68000004183cULL, 0x0000000191915812ULL, 0x000fe400078efcffULL,
0x000000b800ba7306ULL, 0x000e620000205400ULL, 0x0000008e8f00720bULL, 0x004fe20003fdd000ULL,
0x0000007e6838723cULL, 0x000f6c0000041838ULL, 0x0000009400957306ULL, 0x000fec0000209400ULL,
0x0000000182826812ULL, 0x000fc400078efcffULL, 0x0000009400967306ULL, 0x000ea20000205400ULL,
0x000000bab900720bULL, 0x002fe40003f7d000ULL, 0x000000918291723eULL, 0x000fca00000010ffULL,
0x0000009a009b7306ULL, 0x000fe40000209400ULL, 0x000000907050723cULL, 0x080f680000041850ULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x0000009a009e7306ULL, 0x0002e20000205400ULL,
0x000000969500720bULL, 0x004fe20003f1d000ULL, 0x000000906830723cULL, 0x000f620000041830ULL,
0x000000c6c500720bULL, 0x000fc40003f7d000ULL, 0x000000888188723eULL, 0x000fc600000010ffULL,
0x0000008400867306ULL, 0x000fe20000209400ULL, 0x0000009a009a7245ULL, 0x002fca000020d400ULL,
0x0000000183830812ULL, 0x000fe400078efcffULL, 0x0000008400897306ULL, 0x0002a20000205400ULL,
0x0000009e9b00720bULL, 0x008fe40003fbd000ULL, 0x0000007a8380723eULL, 0x000fe400000010ffULL,
0x0000007b007a7245ULL, 0x000fe4000020d400ULL, 0x0000000179793812ULL, 0x000fe200078efcffULL,
0x0000007b008a7306ULL, 0x000fe20000209400ULL, 0x0000008400847245ULL, 0x002fca000020d400ULL,
0x000000019a9a5812ULL, 0x000fe400078efcffULL, 0x0000007b00877306ULL, 0x000e620000205400ULL,
0x000000898600720bULL, 0x004fe40003fdd000ULL, 0x00000085c089723eULL, 0x000fe400000010ffULL,
0x000000c700857245ULL, 0x000fe4000020d400ULL, 0x000000799a81723eULL, 0x000fe200000010ffULL,
0x0000009700997306ULL, 0x000fe40000209400ULL, 0x000000887054723cULL, 0x000f680000041854ULL,
0x0000000184846812ULL, 0x000fc400078efcffULL, 0x0000009700927306ULL, 0x0004e20000205400ULL,
0x000000878a00720bULL, 0x002fe20003f1d000ULL, 0x00000080704c723cULL, 0x000f6c000004184cULL,
0x000000c7008e7306ULL, 0x000fe20000209400ULL, 0x0000009700977245ULL, 0x004fe2000020d400ULL,
0x000000886834723cULL, 0x000f680000041834ULL, 0x000000017a7a0812ULL, 0x000fc400078efcffULL,
0x000000c7008d7306ULL, 0x000e620000205400ULL, 0x000000929900720bULL, 0x008fe20003f9d000ULL,
0x00000080682c723cULL, 0x000f58000004182cULL, 0x0000000197974812ULL, 0x000fe400078efcffULL,
0x0000008d8e00720bULL, 0x002fe40003fbd000ULL, 0x000000978484723eULL, 0x000fd600000010ffULL,
0x0000000185855812ULL, 0x000fc800078efcffULL, 0x000000857a85723eULL, 0x000fce00000010ffULL,
0x000000847048723cULL, 0x080f700000041848ULL, 0x000000846828723cULL, 0x000b6e0000041828ULL,
0x000126c8136a7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006a6a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126900026ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff257224ULL, 0x000fc600078e00ffULL,
0x0000000000267805ULL, 0x004fc80000015200ULL, 0x000004000d697984ULL, 0x000ea40000000800ULL,
0x8000000069ff7812ULL, 0x006fc4000780486bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000687805ULL, 0x000fcc0000015200ULL, 0x00000068266f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000169697824ULL, 0x000fe200000e0e27ULL, 0x003d09006f00780cULL, 0x000fc80003f06070ULL,
0x000000ff6900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406f00780cULL, 0x000fc80003f06070ULL, 0x000000ff6900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff687819ULL, 0x000fc80000011469ULL,
0x0000006f68687211ULL, 0x000fca00078110ffULL, 0x000000ffff697224ULL, 0x000fca00000e0669ULL,
0x0000000268687819ULL, 0x000fc80000001269ULL, 0x000000680000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000d697984ULL, 0x000e640000000800ULL,
0x8000000069ff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c00c277810ULL, 0x000fca0007ffe0ffULL, 0x00006800126f7a24ULL, 0x000fe200078e0227ULL,
0x000003e00000a947ULL, 0x000fea0003800000ULL, 0x0000002716257217ULL, 0x000fe20007800000ULL,
0x00000010116e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff687819ULL, 0x000fe40000011617ULL,
0x0000100000797810ULL, 0x000fe20007ffe0ffULL, 0x0000000125257824ULL, 0x000fe200078e0a27ULL,
0x0000000468697810ULL, 0x000fe20007ffe0ffULL, 0x000000016e267824ULL, 0x000fe200078e0268ULL,
0x00000008686b7810ULL, 0x000fe40007ffe0ffULL, 0x000000256e257217ULL, 0x000fe20007800000ULL,
0x0000000126277824ULL, 0x000fc400078e0217ULL, 0x0000000826707824ULL, 0x040fe400078e00ffULL,
0x0000000125257824ULL, 0x000fe400078e0a6eULL, 0x0000000126267824ULL, 0x000fe200078e026fULL,
0xfffffff870707812ULL, 0x000fe200078ee227ULL, 0x000000016e727824ULL, 0x000fe200078e0269ULL,
0x000000256900720cULL, 0x080fe20003f86070ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000c68697810ULL, 0x040fe40007ffe0ffULL, 0x000000256800720cULL, 0x080fe20003fa6070ULL,
0x0000000172687824ULL, 0x000fe200078e026fULL, 0x000000256900720cULL, 0x000fe20003f06070ULL,
0x000000016e7c7824ULL, 0x000fe200078e0269ULL, 0x0000000b266a7212ULL, 0x000fe200078efcffULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0x000000256b00720cULL, 0x000fc40003f66070ULL,
0x000064006a6a7a10ULL, 0x000fe20007fde0ffULL, 0x000000016e7a7824ULL, 0x000fe200078e026bULL,
0x0000000b686e7212ULL, 0x000fe200078efcffULL, 0x0000000172257824ULL, 0x000fe200078e0217ULL,
0x00006500276b7a10ULL, 0x000fe200037fe4ffULL, 0x000000017a267824ULL, 0x000fe200078e026fULL,
0x000064006e6e7a10ULL, 0x000fe20007fde0ffULL, 0x0000000872727824ULL, 0x000fe400078e00ffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff872727812ULL, 0x000fe200078ee225ULL,
0x000000017c687824ULL, 0x000fe200078e026fULL, 0x00006500696f7a10ULL, 0x000fe200037fe4ffULL,
0x000000017a717824ULL, 0x000fe200078e0217ULL, 0x0000000b26267212ULL, 0x000fe200078efcffULL,
0x0000008068687825ULL, 0x000fc600078e00ffULL, 0x0000640026267a10ULL, 0x000fe20007fde0ffULL,
0x000000087a7a7824ULL, 0x000fe200078e00ffULL, 0x0000000b68687212ULL, 0x000fe200078efcffULL,
0x000000017c257824ULL, 0x040fe200078e0217ULL, 0x0000650027277a10ULL, 0x000fe200037fe4ffULL,
0x000000087c7c7824ULL, 0x000fe200078e00ffULL, 0xfffffff87a7a7812ULL, 0x000fe200078ee271ULL,
0x0000001072717824ULL, 0x000fe200078e0279ULL, 0x0000640068687a10ULL, 0x000fe40007fde0ffULL,
0xfffffff87c7c7812ULL, 0x000fe200078ee225ULL, 0x0000001070257824ULL, 0x100fe200078e0279ULL,
0x0000650069697a10ULL, 0x000fe200037fe4ffULL, 0x000000107a737824ULL, 0x000fc400078e0279ULL,
0x000000107c797824ULL, 0x000fe200078e0279ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a257faeULL, 0x0003e8000e901c46ULL, 0x000000006e717faeULL, 0x0003e8000e101c46ULL,
0x0000000026737faeULL, 0x0003e8000d901c46ULL, 0x0000000068797faeULL, 0x0003e2000c101c46ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001011267824ULL, 0x000fe200078e00ffULL,
0x0000100000797810ULL, 0x000fc80007ffe0ffULL, 0x0000002617687211ULL, 0x000fc800078fe8ffULL,
0x00000004686a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000168267824ULL, 0x040fe200078e026fULL,
0x0000000868727810ULL, 0x040fe20007ffe0ffULL, 0x0000000168257824ULL, 0x040fe200078e0217ULL,
0x0000000c687a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000868707824ULL, 0x000fe400078e00ffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff870707812ULL, 0x000fe200078ee225ULL,
0x000000016a257824ULL, 0x000fe200078e026fULL, 0x0000000b266e7212ULL, 0x000fe200078efcffULL,
0x000000016a697824ULL, 0x040fe400078e0217ULL, 0x000000086a7c7824ULL, 0x000fe200078e00ffULL,
0x000064006e6e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000172687824ULL, 0x100fe400078e026fULL,
0x000000017a6a7824ULL, 0x040fe400078e026fULL, 0x000000017a267824ULL, 0x000fc400078e0217ULL,
0x000000087a6f7824ULL, 0x000fe400078e00ffULL, 0x00000001726b7824ULL, 0x040fe400078e0217ULL,
0x00000008727e7824ULL, 0x000fe200078e00ffULL, 0xfffffff87c727812ULL, 0x000fe200078ee269ULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0xfffffff86f7c7812ULL, 0x000fe400078ee226ULL,
0x00006500276f7a10ULL, 0x000fe200007fe4ffULL, 0x0000008025267825ULL, 0x000fe200078e00ffULL,
0xfffffff87e7a7812ULL, 0x000fc400078ee26bULL, 0x0000000b68687212ULL, 0x080fe200078efcffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b26267212ULL, 0x080fe400078efcffULL,
0x0000640068687a10ULL, 0x000fe20007f7e0ffULL, 0x0000001070257824ULL, 0x100fe200078e0279ULL,
0x0000000b6a6a7212ULL, 0x000fe200078efcffULL, 0x0000001072717824ULL, 0x100fe200078e0279ULL,
0x0000640026267a10ULL, 0x000fe20007f1e0ffULL, 0x000000107a737824ULL, 0x100fe200078e0279ULL,
0x000064006a6a7a10ULL, 0x000fe20007f9e0ffULL, 0x000000107c797824ULL, 0x000fe200078e0279ULL,
0x0000650027277a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e257faeULL, 0x0003e2000b901c46ULL, 0x0000650069697a10ULL, 0x000fc40001ffe4ffULL,
0x000065006b6b7a10ULL, 0x000fe200027fe4ffULL, 0x0000000026717faeULL, 0x0003e8000b901c46ULL,
0x0000000068737faeULL, 0x0003e8000b901c46ULL, 0x000000006a797faeULL, 0x0003e4000b901c46ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0xfffffff014687812ULL, 0x000fce00078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126b00068687f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01264800206e7f8cULL, 0x0004e4000c80043fULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x01264c0020257984ULL, 0x000f240000000800ULL, 0x8000000025ff7812ULL, 0x018fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006a7805ULL, 0x000fcc0000015200ULL, 0x0000006a266a7210ULL, 0x000fca0007f1e1ffULL,
0x000000016b6b7824ULL, 0x000fe200000e0e27ULL, 0x003d09006a00780cULL, 0x000fc80003f06070ULL,
0x000000ff6b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406a00780cULL, 0x000fc80003f06070ULL, 0x000000ff6b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001146bULL,
0x0000006a25257211ULL, 0x000fca00078110ffULL, 0x000000ffff6a7224ULL, 0x000fca00000e066bULL,
0x0000000225257819ULL, 0x000fc8000000126aULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01264c0020257984ULL, 0x000ee40000000800ULL,
0x8000000025ff7812ULL, 0x008fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201a207824ULL, 0x004fca00078e00ffULL, 0xffffff8020207812ULL, 0x000fc800078ec0ffULL,
0x000001000b257810ULL, 0x000fca0007ffe020ULL, 0x000000010a257824ULL, 0x000fca00078e0225ULL,
0x01200000256e7984ULL, 0x000ea80000000800ULL, 0x01220000256f7984ULL, 0x0006620000000800ULL,
0x000000236e00720bULL, 0x004fe20003f1d000ULL, 0x00011b527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000707806ULL, 0x008fc800000e0100ULL, 0x000000ff7000720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff257424ULL, 0x000fe400078e00ffULL,
0x000000ffff207224ULL, 0x000fd200078e0023ULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x0000000210257810ULL, 0x000fe40007ffe0ffULL, 0x000000236e00720bULL, 0x000fe40003f74000ULL,
0x0000001a2500720cULL, 0x000fe20003f05270ULL, 0x00011b027f007947ULL, 0x000fd4000b800000ULL,
0x0000000000717806ULL, 0x000fc400018e0100ULL, 0x000000801a258824ULL, 0x000fe200078e020bULL,
0x000000236e207209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a258824ULL, 0x000fca00078e0225ULL, 0x0124002025008388ULL, 0x0005e20000000800ULL,
0x000000ff7100720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000002320237221ULL, 0x004fe20000010100ULL, 0x000000ff71ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b23237820ULL, 0x000fc80000410000ULL,
0x0000002300277308ULL, 0x000ea40000000800ULL, 0x0000002724247220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x00011a427f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x000000264c4c7220ULL, 0x080fe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0071ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x000119027f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002666667220ULL, 0x08cfe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x000000264e4e7220ULL, 0x080fe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000071ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x000117c27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x000000262c2c7220ULL, 0x080fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002628287220ULL, 0x080fe20000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000071ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x000116927f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x000000262e2e7220ULL, 0x080fe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x000000262a2a7220ULL, 0x080fe20000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000007170ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff257424ULL, 0x000fd800078e00ffULL, 0x800000206e6e0221ULL, 0x000fe20000010000ULL,
0x00007610ff250816ULL, 0x000fc60000000025ULL, 0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL,
0x0000006e00090308ULL, 0x000ea40000000800ULL, 0x000000096f6f0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000246f247221ULL, 0x002fc20000010000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000040008237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006a7805ULL, 0x000fcc0000015200ULL,
0x0000006a266a7210ULL, 0x000fca0007f1e1ffULL, 0x000000016b6b7824ULL, 0x000fe200000e0e27ULL,
0x003d09006a00780cULL, 0x000fc80003f06070ULL, 0x000000ff6b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406a00780cULL, 0x000fc80003f06070ULL,
0x000000ff6b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc8000001146bULL, 0x0000006a23237211ULL, 0x000fca00078110ffULL,
0x000000ffff6a7224ULL, 0x000fca00000e066bULL, 0x0000000223237819ULL, 0x000fc8000000126aULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040008237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991025237816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff2300720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff04723eULL, 0x000fe400000010ffULL,
0x00000002ff6c7819ULL, 0x000fe40000011617ULL, 0x0000541004277816ULL, 0x000fe20000000004ULL,
0x000112627f007947ULL, 0x000fea000b800000ULL, 0x00001f6c27077589ULL, 0x0002a400000e0000ULL,
0x000000086c267810ULL, 0x000fe20007ffe0ffULL, 0x000112827f007947ULL, 0x000fea000b800000ULL,
0x000000106c047810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0427057589ULL, 0x0006a400000e0000ULL, 0x000000186c267810ULL, 0x008fe20007ffe0ffULL,
0x000112b27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000021a237824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000004001a277824ULL, 0x00afe200078e00ffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x00000008036b7824ULL, 0x000fe200078e00ffULL,
0x0000000423267812ULL, 0x000fe200078ec0ffULL, 0x00000008026c7824ULL, 0x000fe200078e00ffULL,
0xfffff000276a7812ULL, 0x000fe200078ec0ffULL, 0x000000101c7c7824ULL, 0x000fe200078e0200ULL,
0x0000002617257211ULL, 0x000fca00078fe0ffULL, 0x0000000103267824ULL, 0x100fe400078e0225ULL,
0x0000000102277824ULL, 0x000fe200078e0225ULL, 0x0000c0006a257810ULL, 0x000fe40007ffe0ffULL,
0xfffffff86b267812ULL, 0x000fe400078ee226ULL, 0xfffffff86c6a7812ULL, 0x000fc600078ee227ULL,
0x0000001026267824ULL, 0x100fe400078e0225ULL, 0x000000106a6a7824ULL, 0x000fc600078e0225ULL,
0x000000002670783bULL, 0x0002e80000000200ULL, 0x000000006a6c783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000770707231ULL, 0x08cfe400003400ffULL,
0x0000000772727231ULL, 0x000fe400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fc400003400ffULL, 0x000000056c6c7231ULL, 0x080fe400003400ffULL,
0x000000056e6e7231ULL, 0x000fe400003400ffULL, 0x000000046d6d7231ULL, 0x080fe400003400ffULL,
0x000000046f6f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000f220000004200ULL, 0x0000001022807824ULL, 0x000fe200078e0200ULL,
0x00000f8000007945ULL, 0x000fea0003800000ULL, 0x000000008080783bULL, 0x000e620000004200ULL,
0x000001007c6b7824ULL, 0x010fe200078e00ffULL, 0x0000007c00267306ULL, 0x002fe20000009400ULL,
0x000001007d927824ULL, 0x040fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe2000001147cULL,
0x000100007d9c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001146bULL,
0x000001007ea47824ULL, 0x000fe200078e00ffULL, 0x00000018ff997819ULL, 0x000fe20000011492ULL,
0x000001007fab7824ULL, 0x000fe200078e00ffULL, 0x0000006b00907306ULL, 0x000fe20000209400ULL,
0x00000018ff9f7819ULL, 0x000fe2000001147dULL, 0x0000010080b07824ULL, 0x000fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe2000001149cULL, 0x0000010081b37824ULL, 0x000fe200078e00ffULL,
0x00000018ffa47819ULL, 0x000fc400000114a4ULL, 0x00000018ffab7819ULL, 0x000fe200000114abULL,
0x0000006b00917306ULL, 0x0003220000205400ULL, 0x00000018ffb07819ULL, 0x000fe400000114b0ULL,
0x00000018ffba7819ULL, 0x000fe400000114b3ULL, 0x00000018ffb57819ULL, 0x000fe40000011480ULL,
0x00000018ffbf7819ULL, 0x000fe20000011481ULL, 0x0000007c00277306ULL, 0x000ee20000005400ULL,
0x0000006b006b7245ULL, 0x002fc4000020d400ULL, 0x00000018ff897819ULL, 0x000fe4000001147eULL,
0x00000018ff797819ULL, 0x000fe40000011482ULL, 0x00000018ff887819ULL, 0x000fe2000001147fULL,
0x0000007c006a7306ULL, 0x0002a2000000d400ULL, 0x000000919000720bULL, 0x010fe40003fbd000ULL,
0x000000ab00907245ULL, 0x000fe4000020d400ULL, 0x000000ba00917245ULL, 0x000fc4000020d400ULL,
0x00000018ff227819ULL, 0x000fe20000011483ULL, 0x0000007d00967306ULL, 0x000fe20000009400ULL,
0x000100007c7c7824ULL, 0x002fe200078e00ffULL, 0x000000272600720bULL, 0x008fe20003fdd000ULL,
0x0000010082267824ULL, 0x000fe200078e00ffULL, 0x0000009900277245ULL, 0x000fe4000020d400ULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007d00977306ULL, 0x000e620000005400ULL,
0x000000016b6b5812ULL, 0x000fcc00078efcffULL, 0x000000016a6a6812ULL, 0x004fe200078efcffULL,
0x00000099009a7306ULL, 0x000ff00000209400ULL, 0x00000099009b7306ULL, 0x000ea20000205400ULL,
0x000000979600720bULL, 0x002fc40003f9d000ULL, 0x00000018ff967819ULL, 0x000fe20000011426ULL,
0x0000010083267824ULL, 0x000fc800078e00ffULL, 0x0000007d00987306ULL, 0x000e70000000d400ULL,
0x0000007c00927306ULL, 0x000fe20000209400ULL, 0x0000009b9a00720bULL, 0x004fe40003f7d000ULL,
0x00000018ff9a7819ULL, 0x000fe20000011426ULL, 0x000100007f267824ULL, 0x000fc800078e00ffULL,
0x0000007c007d7306ULL, 0x0004e20000205400ULL, 0x0000000198984812ULL, 0x002fca00078efcffULL,
0x0000000127273812ULL, 0x000fe400078efcffULL, 0x0000009f00a07306ULL, 0x000fe20000209400ULL,
0x0000007c007c7245ULL, 0x004fe4000020d400ULL, 0x000000982727723eULL, 0x000fca00000010ffULL,
0x0000009f00a17306ULL, 0x0002a20000205400ULL, 0x0000007d9200720bULL, 0x008fe40003fbd000ULL,
0x000000a4007d7245ULL, 0x000fe4000020d400ULL, 0x000000b500927245ULL, 0x000fc6000020d400ULL,
0x0000009c009d7306ULL, 0x000fe20000209400ULL, 0x0000009f009f7245ULL, 0x002fca000020d400ULL,
0x000000017c7c5812ULL, 0x000fe400078efcffULL, 0x0000009c009e7306ULL, 0x0002e20000205400ULL,
0x000000a1a000720bULL, 0x004fce0003f9d000ULL, 0x0000009300947306ULL, 0x000fe20000209400ULL,
0x0000009c009c7245ULL, 0x002fca000020d400ULL, 0x000000019f9f4812ULL, 0x000fe400078efcffULL,
0x0000009300957306ULL, 0x0002a20000205400ULL, 0x0000009e9d00720bULL, 0x008fe20003f7d000ULL,
0x00010000839d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe2000001149dULL,
0x000000a400a57306ULL, 0x000fe20000209400ULL, 0x0000009300937245ULL, 0x002fca000020d400ULL,
0x000000019c9c3812ULL, 0x000fe400078efcffULL, 0x000000a400a67306ULL, 0x000e620000205400ULL,
0x000000959400720bULL, 0x004fce0003fdd000ULL, 0x0000007f00a97306ULL, 0x000fec0000009400ULL,
0x0000000193936812ULL, 0x000fe400078efcffULL, 0x0000007f00aa7306ULL, 0x000ea20000005400ULL,
0x000000a6a500720bULL, 0x002fce0003fbd000ULL, 0x000000ab00ac7306ULL, 0x000fec0000209400ULL,
0x000000017d7d5812ULL, 0x000fe400078efcffULL, 0x000000ab00ad7306ULL, 0x000e620000205400ULL,
0x000000aaa900720bULL, 0x004fce0003f9d000ULL, 0x0000007e00a27306ULL, 0x000ff00000009400ULL,
0x0000007e00a37306ULL, 0x000ea20000005400ULL, 0x000000adac00720bULL, 0x002fce0003f7d000ULL,
0x000000b000b17306ULL, 0x000fec0000209400ULL, 0x0000000190903812ULL, 0x000fe400078efcffULL,
0x000000b000b27306ULL, 0x0002e20000205400ULL, 0x000000a3a200720bULL, 0x004fce0003fdd000ULL,
0x0000008000ae7306ULL, 0x000fe20000009400ULL, 0x000000b000b07245ULL, 0x002fce000020d400ULL,
0x0000008000af7306ULL, 0x000fe20000005400ULL, 0x000000b2b100720bULL, 0x008fce0003fbd000ULL,
0x00000080008d7306ULL, 0x0003ec000000d400ULL, 0x00000001b0b05812ULL, 0x000fe400078efcffULL,
0x0000007f007b7306ULL, 0x000ea2000000d400ULL, 0x0001000080807824ULL, 0x002fca00078e00ffULL,
0x00000018ffb37819ULL, 0x000fe20000011480ULL, 0x0001000081807824ULL, 0x000fe200078e00ffULL,
0x0000008100b87306ULL, 0x000fe80000009400ULL, 0x00000018ffbd7819ULL, 0x000fc80000011480ULL,
0x0000008100b97306ULL, 0x000e620000005400ULL, 0x000000017b7b4812ULL, 0x004fc800078efcffULL,
0x0000007b907b723eULL, 0x000fc600000010ffULL, 0x000000ba00bb7306ULL, 0x000ff00000209400ULL,
0x000000ba00bc7306ULL, 0x000ea20000205400ULL, 0x000000b9b800720bULL, 0x002fce0003f9d000ULL,
0x0000007e007a7306ULL, 0x0002f0000000d400ULL, 0x00000081008c7306ULL, 0x000f22000000d400ULL,
0x000000bcbb00720bULL, 0x004fe20003f7d000ULL, 0x000100007e7e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x000000b300b47306ULL, 0x000fe20000209400ULL,
0x000000017a7a6812ULL, 0x008fe400078efcffULL, 0x000000afae00720bULL, 0x000fe40003fdd000ULL,
0x0000007a7d7a723eULL, 0x000fe400000010ffULL, 0x0000000191913812ULL, 0x000fe200078efcffULL,
0x000000b300817306ULL, 0x0002a20000205400ULL, 0x000000018c8c4812ULL, 0x010fc600078efcffULL,
0x0000007a705c723cULL, 0x000f62000004185cULL, 0x0000008c917d723eULL, 0x000fc600000010ffULL,
0x000000bf00c07306ULL, 0x000fe20000209400ULL, 0x000000018d8d6812ULL, 0x000fe400078efcffULL,
0x000000b300b37245ULL, 0x002fe2000020d400ULL, 0x0000007a6c3c723cULL, 0x000f68000004183cULL,
0x000000bf00c17306ULL, 0x000e620000205400ULL, 0x00000081b400720bULL, 0x004fe40003fbd000ULL,
0x00000018ff817819ULL, 0x000fc40000011426ULL, 0x0000006a6b26723eULL, 0x000fe400000010ffULL,
0x0000007c936a723eULL, 0x000fe200000010ffULL, 0x000000bd00be7306ULL, 0x000fe20000209400ULL,
0x0000009a00937245ULL, 0x000fe4000020d400ULL, 0x0000009c9f6b723eULL, 0x000fe200000010ffULL,
0x000000267064723cULL, 0x000f620000041864ULL, 0x0000008db07c723eULL, 0x000fe400000010ffULL,
0x00000001b3b35812ULL, 0x000fe200078efcffULL, 0x000000bd00977306ULL, 0x0004e20000205400ULL,
0x000000c1c000720bULL, 0x002fc60003f9d000ULL, 0x0000006a7060723cULL, 0x000f680000041860ULL,
0x000000b500b67306ULL, 0x000fe20000209400ULL, 0x000000bd00bd7245ULL, 0x004fc6000020d400ULL,
0x0000007c7054723cULL, 0x000f680000041854ULL, 0x000000b500b77306ULL, 0x000e620000205400ULL,
0x00000097be00720bULL, 0x008fc60003f7d000ULL, 0x000000266c44723cULL, 0x040f680000041844ULL,
0x0000009600997306ULL, 0x000fe80000209400ULL, 0x0000006a6c40723cULL, 0x000f640000041840ULL,
0x00000001bdbd3812ULL, 0x000fc400078efcffULL, 0x0000009600947306ULL, 0x0004e20000205400ULL,
0x000000b7b600720bULL, 0x002fc60003fdd000ULL, 0x0000007c6c34723cULL, 0x000b680000041834ULL,
0x0000008300c47306ULL, 0x000fe20000009400ULL, 0x0000009600967245ULL, 0x004fe4000020d400ULL,
0x000000101f7c7824ULL, 0x020fc600078e0200ULL, 0x0000000192926812ULL, 0x000fe400078efcffULL,
0x0000008300c57306ULL, 0x000e620000005400ULL, 0x000000949900720bULL, 0x008fe40003fbd000ULL,
0x000000bf00947245ULL, 0x000fc8000020d400ULL, 0x0000000194944812ULL, 0x000fe200078efcffULL,
0x0000009a009b7306ULL, 0x000fec0000209400ULL, 0x0000000196965812ULL, 0x000fe400078efcffULL,
0x0000009a009e7306ULL, 0x000ea20000205400ULL, 0x000000c5c400720bULL, 0x002fce0003f7d000ULL,
0x0000008200c27306ULL, 0x000ff00000009400ULL, 0x0000008200c37306ULL, 0x000e620000005400ULL,
0x0000009e9b00720bULL, 0x004fce0003f9d000ULL, 0x0000008200877306ULL, 0x0004ec000000d400ULL,
0x0000000193934812ULL, 0x000fe400078efcffULL, 0x0000008300847306ULL, 0x000f22000000d400ULL,
0x0001000082827824ULL, 0x004fe200078e00ffULL, 0x000000c3c200720bULL, 0x002fc80003fdd000ULL,
0x00000018ff957819ULL, 0x000fe40000011482ULL, 0x00000088008f7306ULL, 0x000fee0000209400ULL,
0x0000000187876812ULL, 0x008fe200078efcffULL, 0x00000088008e7306ULL, 0x0002a20000205400ULL,
0x0000000184843812ULL, 0x010fc400078efcffULL, 0x000000879696723eULL, 0x000fca00000010ffULL,
0x0000008100827306ULL, 0x000fe20000209400ULL, 0x0000008800887245ULL, 0x002fce000020d400ULL,
0x0000008100837306ULL, 0x0002e20000205400ULL, 0x0000008e8f00720bULL, 0x004fce0003f9d000ULL,
0x0000008900a77306ULL, 0x000fe20000209400ULL, 0x0000008100817245ULL, 0x002fca000020d400ULL,
0x0000000188884812ULL, 0x000fe400078efcffULL, 0x0000008900a87306ULL, 0x0002a20000205400ULL,
0x000000838200720bULL, 0x008fe40003f7d000ULL, 0x0000007900827245ULL, 0x000fca000020d400ULL,
0x0000007e007f7306ULL, 0x000fe20000209400ULL, 0x0000008900897245ULL, 0x002fca000020d400ULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x0000007e00807306ULL, 0x000e620000205400ULL,
0x000000a8a700720bULL, 0x004fe40003fbd000ULL, 0x000000818881723eULL, 0x000fca00000010ffULL,
0x00000079008b7306ULL, 0x000fec0000209400ULL, 0x0000000189895812ULL, 0x000fe400078efcffULL,
0x00000079008a7306ULL, 0x000ea20000205400ULL, 0x000000807f00720bULL, 0x002fe40003fdd000ULL,
0x0000007e00807245ULL, 0x000fc4000020d400ULL, 0x000000b3927e723eULL, 0x000fe400000010ffULL,
0x000000bd947f723eULL, 0x000fe200000010ffULL, 0x0000002200867306ULL, 0x000fec0000209400ULL,
0x0000000180806812ULL, 0x000fe200078efcffULL, 0x0000007e7050723cULL, 0x000f620000041850ULL,
0x0000002200857306ULL, 0x0002e20000205400ULL, 0x0000008a8b00720bULL, 0x004fc40003fdd000ULL,
0x000000808980723eULL, 0x000fc800000010ffULL, 0x0000007e6c30723cULL, 0x000f620000041830ULL,
0x0000009500977306ULL, 0x000fe20000209400ULL, 0x0000002200227245ULL, 0x002fca000020d400ULL,
0x0000000182826812ULL, 0x000fe200078efcffULL, 0x000000807058723cULL, 0x000f620000041858ULL,
0x0000009500987306ULL, 0x0002a20000205400ULL, 0x000000858600720bULL, 0x008fcc0003fbd000ULL,
0x000000806c38723cULL, 0x000f620000041838ULL, 0x0000009d008e7306ULL, 0x000fe20000209400ULL,
0x0000009500957245ULL, 0x002fca000020d400ULL, 0x0000000122225812ULL, 0x000fe400078efcffULL,
0x0000009d00837306ULL, 0x000e620000205400ULL, 0x000000989700720bULL, 0x004fe40003f7d000ULL,
0x000000849397723eULL, 0x000fce00000010ffULL, 0x00000096704c723cULL, 0x080f68000004184cULL,
0x0000000195953812ULL, 0x000fe400078efcffULL, 0x000000838e00720bULL, 0x002fe40003f9d000ULL,
0x0000009d00837245ULL, 0x000fe2000020d400ULL, 0x000000966c2c723cULL, 0x000f62000004182cULL,
0x000000958282723eULL, 0x000fd200000010ffULL, 0x0000000183834812ULL, 0x000fc800078efcffULL,
0x000000832283723eULL, 0x000fce00000010ffULL, 0x000000827048723cULL, 0x080b6e0000041848ULL,
0x000000101d707824ULL, 0x120fe200078e0225ULL, 0x000000826c6c723cULL, 0x000b620000041828ULL,
0x000000101e257824ULL, 0x000fc800078e0225ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000002528783bULL, 0x0204e20000000200ULL, 0x0000008000000947ULL, 0x000fd20003800000ULL,
0x0000000770707231ULL, 0x082fe400003400ffULL, 0x0000000772727231ULL, 0x000fe400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fc400003400ffULL,
0x0000000528287231ULL, 0x088fe400003400ffULL, 0x000000052a2a7231ULL, 0x000fe400003400ffULL,
0x0000000429297231ULL, 0x080fe400003400ffULL, 0x000000042b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007c7c783bULL, 0x000f220000004200ULL,
0x0000001021807824ULL, 0x000fe200078e0200ULL, 0xfffffff823237812ULL, 0x000fca00078ec0ffULL,
0x000000008080783bULL, 0x000ea20000004200ULL, 0x000001007d8d7824ULL, 0x010fe200078e00ffULL,
0x0000007c00267306ULL, 0x000fe20000009400ULL, 0x00000018ff8f7819ULL, 0x000fe2000001147cULL,
0x000001007c6b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe2000001147dULL,
0x000001007e9f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe2000001148dULL,
0x000001007fa27824ULL, 0x040fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001146bULL,
0x0000007c00277306ULL, 0x000f220000005400ULL, 0x00000018ff9f7819ULL, 0x000fe2000001149fULL,
0x0000010080b37824ULL, 0x004fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe2000001147eULL,
0x000100007fab7824ULL, 0x000fe200078e00ffULL, 0x00000018ffae7819ULL, 0x000fe2000001147fULL,
0x0000010081bb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa87819ULL, 0x000fe200000114a2ULL,
0x0000009500967306ULL, 0x000fe20000209400ULL, 0x00000018ffb67819ULL, 0x000fc40000011480ULL,
0x00000018ffab7819ULL, 0x000fe400000114abULL, 0x00000018ffbb7819ULL, 0x000fe400000114bbULL,
0x00000018ff877819ULL, 0x000fe20000011481ULL, 0x0000009500977306ULL, 0x000ea20000205400ULL,
0x000000272600720bULL, 0x010fe40003fbd000ULL, 0x0000009500277245ULL, 0x000fe4000020d400ULL,
0x00000018ffb37819ULL, 0x000fc400000114b3ULL, 0x00000018ff227819ULL, 0x000fe20000011482ULL,
0x0000007c006a7306ULL, 0x0008e2000000d400ULL, 0x00000018ff217819ULL, 0x000fce0000011483ULL,
0x0000007d00927306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x010fe200078e00ffULL,
0x000000979600720bULL, 0x004fe20003f1d000ULL, 0x0000010083967824ULL, 0x040fe400078e00ffULL,
0x0001000083977824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007d00937306ULL, 0x000ea20000005400ULL, 0x000000016a6a5812ULL, 0x008fe400078efcffULL,
0x00000018ff967819ULL, 0x000fc40000011496ULL, 0x00000018ff977819ULL, 0x000fe40000011497ULL,
0x0000000127270812ULL, 0x000fe200078efcffULL, 0x0000007d00947306ULL, 0x000730000000d400ULL,
0x0000007c008d7306ULL, 0x000fe20000209400ULL, 0x000100007d7d7824ULL, 0x008fe200078e00ffULL,
0x000000939200720bULL, 0x004fe20003f9d000ULL, 0x0000010082927824ULL, 0x000fc400078e00ffULL,
0x0001000082937824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000007c008e7306ULL, 0x0004e20000205400ULL, 0x00000018ff927819ULL, 0x000fcc0000011492ULL,
0x0000000194944812ULL, 0x010fe200078efcffULL, 0x0000007d00987306ULL, 0x000fe20000209400ULL,
0x0000007c007c7245ULL, 0x004fe4000020d400ULL, 0x000000942727723eULL, 0x000fca00000010ffULL,
0x0000007d00997306ULL, 0x0005220000205400ULL, 0x0000008e8d00720bULL, 0x008fce0003fdd000ULL,
0x0000007f00a67306ULL, 0x000fe20000009400ULL, 0x0000007d007d7245ULL, 0x004fca000020d400ULL,
0x000000017c7c6812ULL, 0x000fe400078efcffULL, 0x0000007f00a77306ULL, 0x000ea20000005400ULL,
0x000000999800720bULL, 0x010fce0003f1d000ULL, 0x0000008f00907306ULL, 0x000fec0000209400ULL,
0x000000017d7d0812ULL, 0x000fe400078efcffULL, 0x0000008f00917306ULL, 0x0007220000205400ULL,
0x000000a7a600720bULL, 0x004fce0003f1d000ULL, 0x0000009f00a07306ULL, 0x000fe20000209400ULL,
0x0000008f008f7245ULL, 0x008fce000020d400ULL, 0x0000009f00a17306ULL, 0x0004e20000205400ULL,
0x000000919000720bULL, 0x010fe40003fbd000ULL, 0x00000018ff907819ULL, 0x000fca0000011493ULL,
0x0000006b008b7306ULL, 0x000fe20000209400ULL, 0x0000009f009f7245ULL, 0x004fca000020d400ULL,
0x000000018f8f5812ULL, 0x000fe400078efcffULL, 0x0000006b008c7306ULL, 0x0005220000205400ULL,
0x000000a1a000720bULL, 0x008fce0003fdd000ULL, 0x0000007f00897306ULL, 0x000ee2000000d400ULL,
0x0000006b006b7245ULL, 0x004fca000020d400ULL, 0x000000019f9f6812ULL, 0x000fe400078efcffULL,
0x0000009a009b7306ULL, 0x000fe20000209400ULL, 0x0000008c8b00720bULL, 0x010fe20003f7d000ULL,
0x00010000818c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe2000001148cULL,
0x0000009a009c7306ULL, 0x0005220000205400ULL, 0x0000000189890812ULL, 0x008fca00078efcffULL,
0x000000016b6b3812ULL, 0x000fe400078efcffULL, 0x000000a300a47306ULL, 0x000fe20000209400ULL,
0x0000009a009a7245ULL, 0x004fce000020d400ULL, 0x000000a300a57306ULL, 0x0004e20000205400ULL,
0x0000009c9b00720bULL, 0x010fce0003f9d000ULL, 0x000000ae00af7306ULL, 0x000fe20000209400ULL,
0x000000a300a37245ULL, 0x004fca000020d400ULL, 0x000000019a9a4812ULL, 0x000fe400078efcffULL,
0x000000ae00b07306ULL, 0x0005220000205400ULL, 0x000000a5a400720bULL, 0x008fce0003fdd000ULL,
0x000000a800a97306ULL, 0x000fe20000209400ULL, 0x000000ae00ae7245ULL, 0x004fca000020d400ULL,
0x00000001a3a36812ULL, 0x000fe400078efcffULL, 0x000000a800aa7306ULL, 0x0004e20000205400ULL,
0x000000b0af00720bULL, 0x010fce0003f1d000ULL, 0x0000007e009d7306ULL, 0x000fe20000009400ULL,
0x000000a800a87245ULL, 0x004fca000020d400ULL, 0x00000001aeae0812ULL, 0x000fe400078efcffULL,
0x0000007e009e7306ULL, 0x000ea20000005400ULL, 0x000000aaa900720bULL, 0x008fce0003fbd000ULL,
0x0000007e008a7306ULL, 0x00072c000000d400ULL, 0x00000001a8a85812ULL, 0x000fe400078efcffULL,
0x0000008000b17306ULL, 0x000fe20000009400ULL, 0x000100007e7e7824ULL, 0x008fe200078e00ffULL,
0x0000009e9d00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000008000b27306ULL, 0x000eae0000005400ULL, 0x000000018a8a3812ULL, 0x010fe200078efcffULL,
0x0000008000887306ULL, 0x000730000000d400ULL, 0x0000008100b97306ULL, 0x000fe20000009400ULL,
0x0001000080807824ULL, 0x008fe200078e00ffULL, 0x000000b2b100720bULL, 0x004fc80003f7d000ULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x0000008100ba7306ULL, 0x000fee0000005400ULL,
0x0000000188883812ULL, 0x010fe200078efcffULL, 0x0000008100867306ULL, 0x000ff0000000d400ULL,
0x0000007e00a27306ULL, 0x000ff00000209400ULL, 0x0000007e007f7306ULL, 0x0004f00000205400ULL,
0x000000ab00ac7306ULL, 0x000fe20000209400ULL, 0x0000007e007e7245ULL, 0x004fce000020d400ULL,
0x000000ab00ad7306ULL, 0x000ea20000205400ULL, 0x0000007fa200720bULL, 0x008fe40003f9d000ULL,
0x000000ab007f7245ULL, 0x000fca000020d400ULL, 0x000000bb00bc7306ULL, 0x000fec0000209400ULL,
0x000000017e7e4812ULL, 0x000fe400078efcffULL, 0x000000bb008b7306ULL, 0x0007220000205400ULL,
0x000000adac00720bULL, 0x004fe40003fbd000ULL, 0x0000007ea37e723eULL, 0x000fca00000010ffULL,
0x0000008000267306ULL, 0x000fe20000209400ULL, 0x000000bb00bb7245ULL, 0x008fca000020d400ULL,
0x000000017f7f5812ULL, 0x000fe400078efcffULL, 0x0000008000817306ULL, 0x0004e20000205400ULL,
0x0000008bbc00720bULL, 0x010fe40003fdd000ULL, 0x000000bab900720bULL, 0x000fe40003fbd000ULL,
0x0000007fae7f723eULL, 0x000fc600000010ffULL, 0x0000008200bf7306ULL, 0x000fe20000009400ULL,
0x0000008000807245ULL, 0x004fc6000020d400ULL, 0x0000007e2838723cULL, 0x080f640000041838ULL,
0x00000001bbbb6812ULL, 0x000fe400078efcffULL, 0x0000008200c07306ULL, 0x000fe20000005400ULL,
0x000000812600720bULL, 0x008fe40003f1d000ULL, 0x0000006a6b26723eULL, 0x000fe200000010ffULL,
0x0000007e7058723cULL, 0x002f620000041858ULL, 0x000000b600817245ULL, 0x000fe4000020d400ULL,
0x0000007c8f6a723eULL, 0x000fe200000010ffULL, 0x0000008200797306ULL, 0x000fe2000000d400ULL,
0x0000008a9f7c723eULL, 0x000fc400000010ffULL, 0x0000000186865812ULL, 0x000fe200078efcffULL,
0x000000262844723cULL, 0x040f620000041844ULL, 0x0000007d9a6b723eULL, 0x000fe400000010ffULL,
0x0000000180800812ULL, 0x000fe200078efcffULL, 0x0000008300c17306ULL, 0x000fe20000009400ULL,
0x00000089a87d723eULL, 0x000fe400000010ffULL, 0x00000086bb89723eULL, 0x000fe200000010ffULL,
0x0000006a2840723cULL, 0x040f680000041840ULL, 0x0000008300c27306ULL, 0x000e680000005400ULL,
0x0000007c283c723cULL, 0x000f68000004183cULL, 0x0000008300257306ULL, 0x000ea8000000d400ULL,
0x000000267064723cULL, 0x000f680000041864ULL, 0x000000b600b77306ULL, 0x000fe20000209400ULL,
0x000000c2c100720bULL, 0x002fc60003f7d000ULL, 0x0000007c705c723cULL, 0x040f68000004185cULL,
0x000000b600b87306ULL, 0x000e680000205400ULL, 0x0000006a7060723cULL, 0x000b640000041860ULL,
0x0000000125253812ULL, 0x004fc400078efcffULL, 0x000000b300b47306ULL, 0x000fe60000209400ULL,
0x000126c8136a7811ULL, 0x020fca00078e18ffULL, 0x000000b300b57306ULL, 0x0004e20000205400ULL,
0x000000b8b700720bULL, 0x002fce0003fdd000ULL, 0x0000008c00827306ULL, 0x000fe20000209400ULL,
0x000000b300b37245ULL, 0x004fca000020d400ULL, 0x0000000181816812ULL, 0x000fe400078efcffULL,
0x0000008c00837306ULL, 0x0002a20000205400ULL, 0x000000b5b400720bULL, 0x008fce0003f9d000ULL,
0x0000008700bd7306ULL, 0x000fe20000209400ULL, 0x0000008c008c7245ULL, 0x002fca000020d400ULL,
0x00000001b3b34812ULL, 0x000fe400078efcffULL, 0x0000008700be7306ULL, 0x0002e20000205400ULL,
0x000000838200720bULL, 0x004fe40003f1d000ULL, 0x000000c0bf00720bULL, 0x000fe40003f9d000ULL,
0x00000088b388723eULL, 0x000fc600000010ffULL, 0x00000092008d7306ULL, 0x000fe20000209400ULL,
0x0000008700877245ULL, 0x002fc6000020d400ULL, 0x000000882834723cULL, 0x080b640000041834ULL,
0x000000018c8c0812ULL, 0x000fe400078efcffULL, 0x00000092008e7306ULL, 0x0002a20000205400ULL,
0x000000bebd00720bULL, 0x008fe40003fbd000ULL, 0x0000000179794812ULL, 0x000fe200078efcffULL,
0x000000887054723cULL, 0x000b680000041854ULL, 0x0000009600917306ULL, 0x000fe20000209400ULL,
0x0000009200927245ULL, 0x002fca000020d400ULL, 0x0000000187875812ULL, 0x000fe400078efcffULL,
0x0000009600987306ULL, 0x0002e20000205400ULL, 0x0000008e8d00720bULL, 0x004fce0003fdd000ULL,
0x00000022007a7306ULL, 0x000fe20000209400ULL, 0x0000009600967245ULL, 0x002fca000020d400ULL,
0x0000000192926812ULL, 0x000fe400078efcffULL, 0x00000022007b7306ULL, 0x000e620000205400ULL,
0x000000989100720bULL, 0x008fe40003f1d000ULL, 0x0000009700917245ULL, 0x000fe4000020d400ULL,
0x000000799292723eULL, 0x000fc600000010ffULL, 0x0000002100847306ULL, 0x000fec0000209400ULL,
0x0000000196960812ULL, 0x000fe400078efcffULL, 0x0000002100857306ULL, 0x000ea20000205400ULL,
0x0000007b7a00720bULL, 0x002fe40003fbd000ULL, 0x000000259693723eULL, 0x000fc400000010ffULL,
0x0000002200257245ULL, 0x000fe4000020d400ULL, 0x0000002100227245ULL, 0x000fe2000020d400ULL,
0x00000090008b7306ULL, 0x000fe20000209400ULL, 0x00000080817a723eULL, 0x000fe200000010ffULL,
0x00000092282c723cULL, 0x000b62000004182cULL, 0x0000008c877b723eULL, 0x000fc600000010ffULL,
0x0000000125255812ULL, 0x000fe400078efcffULL, 0x0000009000827306ULL, 0x0002e20000205400ULL,
0x000000858400720bULL, 0x004fe20003fdd000ULL, 0x0000007a2830723cULL, 0x080b6c0000041830ULL,
0x0000009700837306ULL, 0x000fe20000209400ULL, 0x0000009000907245ULL, 0x002fe2000020d400ULL,
0x0000007a7050723cULL, 0x000b680000041850ULL, 0x0000000122226812ULL, 0x000fc400078efcffULL,
0x00000097008a7306ULL, 0x000e620000205400ULL, 0x000000828b00720bULL, 0x008fe20003f9d000ULL,
0x00000092704c723cULL, 0x000b58000004184cULL, 0x0000000190904812ULL, 0x000fe400078efcffULL,
0x0000008a8300720bULL, 0x002fe40003f1d000ULL, 0x000000902590723eULL, 0x000fd600000010ffULL,
0x0000000191910812ULL, 0x000fc800078efcffULL, 0x000000912291723eULL, 0x000fce00000010ffULL,
0x000000907048723cULL, 0x080b700000041848ULL, 0x000000902828723cULL, 0x000b62000004186cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000006a6a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126980023ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff217224ULL, 0x000fc600078e00ffULL,
0x0000000000227805ULL, 0x004fc80000015200ULL, 0x000004000d257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fc4000780486bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002622267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e23ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011427ULL,
0x0000002625257211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000225257819ULL, 0x000fc80000001226ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000121217810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000d257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010f227810ULL, 0x000fc80007ffe0ffULL, 0x000000152200720cULL, 0x000fda0003f06070ULL,
0x0000072000000947ULL, 0x000fea0003800000ULL, 0x000000020f227810ULL, 0x000fe40007ffe0ffULL,
0x000001000c217810ULL, 0x000fe40007ffe0ffULL, 0x000000152200720cULL, 0x000fc60003f06070ULL,
0x0000680012257a24ULL, 0x000fd400078e0221ULL, 0x000003d000008947ULL, 0x000fea0003800000ULL,
0x00000021160c7217ULL, 0x000fe20007800000ULL, 0x00000010116b7824ULL, 0x000fe200078e00ffULL,
0x00000003ff277819ULL, 0x000fc60000011617ULL, 0x000000010c0c7824ULL, 0x000fe200078e0a21ULL,
0x00000004276d7810ULL, 0x020fe20007ffe0ffULL, 0x000000016b227824ULL, 0x000fe200078e0227ULL,
0x00000008276f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c6b0c7217ULL, 0x000fe20007800000ULL,
0x0000000122217824ULL, 0x040fe200078e0217ULL, 0x0000000c27717810ULL, 0x000fe20007ffe0ffULL,
0x0000000822267824ULL, 0x000fe400078e00ffULL, 0x000000016b6e7824ULL, 0x000fc400078e026dULL,
0x0000000122227824ULL, 0x000fe200078e0225ULL, 0xfffffff826217812ULL, 0x000fe200078ee221ULL,
0x000000010c0c7824ULL, 0x000fe400078e0a6bULL, 0x000000016e267824ULL, 0x000fe400078e0225ULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000000c2700720cULL, 0x080fe40003f06070ULL,
0x0000000c6d00720cULL, 0x080fe20003f86070ULL, 0x000000016b707824ULL, 0x000fe200078e026fULL,
0x0000000b226c7212ULL, 0x000fe200078efcffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000c6f00720cULL, 0x000fc40003f66070ULL, 0x000064006c6c7a10ULL, 0x000fe20007fbe0ffULL,
0x00000001706a7824ULL, 0x000fe200078e0225ULL, 0x0000000b26267212ULL, 0x080fe200078efcffULL,
0x000000016b727824ULL, 0x000fe200078e0271ULL, 0x00006500236d7a10ULL, 0x000fe20002ffe4ffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000640026267a10ULL, 0x000fe40007fde0ffULL,
0x0000000c7100720cULL, 0x000fe20003fa6070ULL, 0x0000000172227824ULL, 0x000fe200078e0225ULL,
0x0000000b6a6a7212ULL, 0x000fe200078efcffULL, 0x000000016e257824ULL, 0x040fe200078e0217ULL,
0x0000650027277a10ULL, 0x000fe200037fe4ffULL, 0x000000086e6e7824ULL, 0x000fe200078e00ffULL,
0x000064006a6a7a10ULL, 0x000fe20007fde0ffULL, 0x0000008022227825ULL, 0x000fc600078e00ffULL,
0xfffffff86e257812ULL, 0x000fe200078ee225ULL, 0x00000001700c7824ULL, 0x100fe200078e0217ULL,
0x0000000b22227212ULL, 0x000fe200078efcffULL, 0x00000008706f7824ULL, 0x000fe200078e00ffULL,
0x000065006b6b7a10ULL, 0x000fe200037fe4ffULL, 0x00000001726e7824ULL, 0x000fe200078e0217ULL,
0x0000640022227a10ULL, 0x000fe20007fde0ffULL, 0x0000000872717824ULL, 0x000fe200078e00ffULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee20cULL, 0x0000001021217824ULL, 0x100fe200078e0200ULL,
0x0000650023237a10ULL, 0x000fe200037fe4ffULL, 0x0000001025257824ULL, 0x000fe200078e0200ULL,
0xfffffff871717812ULL, 0x000fe200078ee26eULL, 0x000000106f6f7824ULL, 0x100fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006c217faeULL, 0x0003e6000c101c46ULL,
0x0000001071717824ULL, 0x000fe200078e0200ULL, 0x0000000026257faeULL, 0x0003e8000e101c46ULL,
0x000000006a6f7faeULL, 0x0003e8000d901c46ULL, 0x0000000022717faeULL, 0x0003e2000e901c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x00000010110c7824ULL, 0x000fca00078e00ffULL,
0x0000000c170c7211ULL, 0x000fc800078fe8ffULL, 0x000000040c267810ULL, 0x040fe20007ffe0ffULL,
0x000000010c217824ULL, 0x140fe200078e0217ULL, 0x000000080c6a7810ULL, 0x040fe20007ffe0ffULL,
0x000000080c6c7824ULL, 0x020fe400078e00ffULL, 0x0000000126227824ULL, 0x040fe400078e0217ULL,
0x00000008266f7824ULL, 0x000fe200078e00ffULL, 0xfffffff86c217812ULL, 0x000fe200078ee221ULL,
0x000000016a237824ULL, 0x040fe400078e0217ULL, 0x000000086a6e7824ULL, 0x000fe200078e00ffULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee222ULL, 0x000000010c227824ULL, 0x140fe200078e0225ULL,
0x0000000c0c0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000126267824ULL, 0x000fe200078e0225ULL,
0xfffffff86e717812ULL, 0x000fe200078ee223ULL, 0x0000008022227825ULL, 0x000fc800078e00ffULL,
0x000000016a6a7824ULL, 0x100fe200078e0225ULL, 0x0000000b22227212ULL, 0x000fe200078efcffULL,
0x000000010c6c7824ULL, 0x000fe400078e0225ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000640022227a10ULL, 0x000fc60007f1e0ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000650023237a10ULL, 0x000fe200007fe4ffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000000b6a6a7212ULL, 0x080fe400078efcffULL,
0x0000640026267a10ULL, 0x000fe20007f7e0ffULL, 0x000000010c257824ULL, 0x000fe200078e0217ULL,
0x0000000b6c6c7212ULL, 0x000fe200078efcffULL, 0x000000080c0c7824ULL, 0x000fe200078e00ffULL,
0x000064006a6a7a10ULL, 0x000fe20007f1e0ffULL, 0x0000001021217824ULL, 0x100fe200078e0200ULL,
0x000064006c6c7a10ULL, 0x000fe20007f9e0ffULL, 0x000000106f6f7824ULL, 0x100fe200078e0200ULL,
0xfffffff80c257812ULL, 0x000fe200078ee225ULL, 0x0000001071717824ULL, 0x100fe200078e0200ULL,
0x0000650027277a10ULL, 0x000fe20001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022217faeULL, 0x0003e2000b901c46ULL, 0x000065006b6b7a10ULL, 0x000fe200007fe4ffULL,
0x0000001025257824ULL, 0x000fe200078e0200ULL, 0x000065006d6d7a10ULL, 0x000fe200027fe4ffULL,
0x00000000266f7faeULL, 0x0003e8000b901c46ULL, 0x000000006a717faeULL, 0x0003e8000b901c46ULL,
0x000000006c257faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000814217812ULL, 0x000fe200078ec0ffULL, 0x00000020100c7824ULL, 0x000fc400078e020eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x00000001210c7824ULL, 0x000fe200078e020cULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000008227f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x012668000c6a7f8cULL, 0x000662000c80043fULL, 0x000000ffff217224ULL, 0x004fc600078e0023ULL,
0x0000000000227805ULL, 0x000fc80000015200ULL, 0x01266c000c257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fe4000780486bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6c7224ULL, 0x020fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002622257210ULL, 0x000fca0007f1e1ffULL, 0x0000000127267824ULL, 0x000fe200000e0e23ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011426ULL, 0x0000002508087211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0626ULL, 0x0000000208087819ULL, 0x000fc80000001225ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016c6c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01266c000c257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018010087811ULL, 0x000fc800078e38ffULL,
0x000000080a087210ULL, 0x000fca0007ffe00bULL, 0x01200000086d7984ULL, 0x000e680000000800ULL,
0x01220000080c7984ULL, 0x0084e20000000800ULL, 0x000000206d00720bULL, 0x002fe20003f1d000ULL,
0x0000e4727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x004fc800000e0100ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x00000001ff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fd200078e0020ULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x0000000310237810ULL, 0x000fe40007ffe0ffULL,
0x000000206d00720bULL, 0x000fe40003f74000ULL, 0x0000001a2300720cULL, 0x000fe20003f05270ULL,
0x0000e4227f007947ULL, 0x000fd4000b800000ULL, 0x00000000006f7806ULL, 0x000fc400018e0100ULL,
0x000000801a0b8824ULL, 0x000fe200078e020bULL, 0x000000206d237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a0a8824ULL, 0x000fca00078e020bULL,
0x012400230a008388ULL, 0x0003e20000000800ULL, 0x000000ff6f00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x00000020230a7221ULL, 0x002fe20000010100ULL,
0x000000ff6fff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL, 0x0000000a00277308ULL, 0x000e640000000800ULL,
0x0000002724247220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x0000e3627f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002a400000e0000ULL, 0x0000002664647220ULL, 0x084fe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x000000264c4c7220ULL, 0x080fe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff006fff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x0000e2227f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x00046400000e0000ULL,
0x0000002666667220ULL, 0x086fe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x000000264e4e7220ULL, 0x080fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00006fff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x0000e0e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x00046400000e0000ULL, 0x0000002644447220ULL, 0x086fe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002628287220ULL, 0x080fe20000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000006fff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x0000dfb27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x00046400000e0000ULL, 0x0000002646467220ULL, 0x086fe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x000000262e2e7220ULL, 0x080fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x000000262a2a7220ULL, 0x080fe20000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006f08ff7212ULL, 0x000fda00078030ffULL, 0x0000006d236d0221ULL, 0x000fe20000010100ULL,
0x00007610ff220816ULL, 0x000fc60000000022ULL, 0x3fb8aa3b6d6d0820ULL, 0x000fc80000410000ULL,
0x0000006d00090308ULL, 0x000e640000000800ULL, 0x000000090c0c0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000240c247221ULL, 0x008fc20000010000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0xfffffff014207812ULL, 0x000fca00078ec0ffULL,
0x0126b40020257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x000000260a257210ULL, 0x000fca0007f1e1ffULL,
0x0000000127267824ULL, 0x000fe200000e0e0bULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011426ULL,
0x0000002508087211ULL, 0x000fca00078110ffULL, 0x000000ffff257224ULL, 0x000fca00000e0626ULL,
0x0000000208087819ULL, 0x000fc80000001225ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b40020257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991022087816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0800720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff087819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x000fe20000000004ULL, 0x0000db827f007947ULL, 0x000fea000b800000ULL,
0x00001f0827077589ULL, 0x0002a400000e0000ULL, 0x0000000808267810ULL, 0x000fe20007ffe0ffULL,
0x0000dba27f007947ULL, 0x000fea000b800000ULL, 0x0000001008047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x0000001808267810ULL, 0x008fe20007ffe0ffULL, 0x0000dbd27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000113087812ULL, 0x002fe200078ec0ffULL, 0x0000000803257824ULL, 0x000fe200078e00ffULL,
0x00000004ff0b7819ULL, 0x000fe20000011617ULL, 0x0000000802277824ULL, 0x008fe200078e00ffULL,
0x0000100000007810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000001b000007945ULL, 0x000fe20003800000ULL, 0x0000000408087824ULL, 0x000fc400078e020bULL,
0x000000041a0b7824ULL, 0x000fe400078e00ffULL, 0x00000001030a7824ULL, 0x100fe400078e0208ULL,
0x0000000102087824ULL, 0x000fe200078e0208ULL, 0x000000040b0c7812ULL, 0x000fe200078ec0ffULL,
0x000000101c787824ULL, 0x000fe200078e0200ULL, 0xfffffff8250b7812ULL, 0x000fe400078ee20aULL,
0xfffffff827257812ULL, 0x000fe400078ee208ULL, 0x0000d000100a7811ULL, 0x000fc400078e60ffULL,
0x000000020c0c7812ULL, 0x000fc600078efcffULL, 0x000000100b0b7824ULL, 0x100fe200078e020aULL,
0x0000000c17087211ULL, 0x000fe200078fe0ffULL, 0x0000001025257824ULL, 0x000fe400078e020aULL,
0x00000008030c7824ULL, 0x040fe200078e00ffULL, 0x000000000b6c783bULL, 0x0002e20000000200ULL,
0x0000000103037824ULL, 0x000fc600078e0208ULL, 0x000000002568783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x000000076c6c7231ULL, 0x08cfe400003400ffULL,
0x000000076e6e7231ULL, 0x000fe400003400ffULL, 0x000000066d6d7231ULL, 0x080fe400003400ffULL,
0x000000066f6f7231ULL, 0x000fe400003400ffULL, 0x0000000568687231ULL, 0x080fe400003400ffULL,
0x000000056a6a7231ULL, 0x000fc400003400ffULL, 0x0000000469697231ULL, 0x080fe400003400ffULL,
0x000000046b6b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0xfffffff80c037812ULL, 0x000fe200078ee203ULL,
0x000000101e1e7824ULL, 0x000fe200078e020aULL, 0x00000fa000007945ULL, 0x000fe20003800000ULL,
0x0000000102087824ULL, 0x000fe400078e0208ULL, 0x0000001003037824ULL, 0x000fca00078e0200ULL,
0x000000000370783bULL, 0x000e620000004200ULL, 0x0000010078807824ULL, 0x010fe200078e00ffULL,
0x0000007800267306ULL, 0x000fe20000009400ULL, 0x0000010079837824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe20000011478ULL, 0x000001007a967824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x000001007b997824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe40000011483ULL, 0x0000008000817306ULL, 0x000fe20000209400ULL,
0x00000018ff907819ULL, 0x000fe20000011479ULL, 0x0000010070ab7824ULL, 0x002fe200078e00ffULL,
0x00000018ffad7819ULL, 0x000fc40000011470ULL, 0x00000018ff9b7819ULL, 0x000fe4000001147aULL,
0x00000018ff967819ULL, 0x000fe20000011496ULL, 0x0000008000827306ULL, 0x000e620000205400ULL,
0x00000018ffa17819ULL, 0x000fe40000011499ULL, 0x00000018ffab7819ULL, 0x000fe400000114abULL,
0x00000018ffa67819ULL, 0x000fe4000001147bULL, 0x00000018ffb27819ULL, 0x000fe20000011471ULL,
0x0000007800277306ULL, 0x000f220000005400ULL, 0x00000018ff0c7819ULL, 0x000fc40000011472ULL,
0x00000018ff1c7819ULL, 0x000fca0000011473ULL, 0x00000078007f7306ULL, 0x0006a2000000d400ULL,
0x000000828100720bULL, 0x002fce0003fdd000ULL, 0x0000008b008c7306ULL, 0x000fe20000209400ULL,
0x0001000078787824ULL, 0x008fe200078e00ffULL, 0x000000272600720bULL, 0x010fe20003fbd000ULL,
0x0000010071267824ULL, 0x000fe200078e00ffULL, 0x0000008b00277245ULL, 0x000fe4000020d400ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000008b008d7306ULL, 0x000e6e0000205400ULL,
0x000000017f7f5812ULL, 0x004fe200078efcffULL, 0x0000007800837306ULL, 0x000ff00000209400ULL,
0x0000007800847306ULL, 0x000ea20000205400ULL, 0x0000008d8c00720bULL, 0x002fc40003f7d000ULL,
0x00000018ff8c7819ULL, 0x000fe40000011426ULL, 0x0000008000267245ULL, 0x000fc6000020d400ULL,
0x0000007900887306ULL, 0x000fe20000009400ULL, 0x0000000126266812ULL, 0x000fc800078efcffULL,
0x0000007f2626723eULL, 0x000fe400000010ffULL, 0x0000000127273812ULL, 0x000fe200078efcffULL,
0x0000007900897306ULL, 0x000e620000005400ULL, 0x000000848300720bULL, 0x004fe40003fdd000ULL,
0x000000b2007f7245ULL, 0x000fca000020d400ULL, 0x00000079008a7306ULL, 0x0004f0000000d400ULL,
0x0000007a00937306ULL, 0x000fe20000009400ULL, 0x0001000079797824ULL, 0x004fe200078e00ffULL,
0x000000898800720bULL, 0x002fc80003f9d000ULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x0000007a00947306ULL, 0x000fee0000005400ULL, 0x000000018a8a4812ULL, 0x008fe200078efcffULL,
0x0000008500867306ULL, 0x000fe60000209400ULL, 0x0000008a2727723eULL, 0x000fca00000010ffULL,
0x0000008500877306ULL, 0x0002a40000205400ULL, 0x000000266c64723cULL, 0x080f6c0000041864ULL,
0x0000009000917306ULL, 0x000fe20000209400ULL, 0x0000008500857245ULL, 0x002fe2000020d400ULL,
0x000000266844723cULL, 0x000f6c0000041844ULL, 0x0000009000927306ULL, 0x0002e20000205400ULL,
0x000000878600720bULL, 0x004fce0003fbd000ULL, 0x0000007000a97306ULL, 0x000fe20000009400ULL,
0x0000009000907245ULL, 0x002fca000020d400ULL, 0x0000000185855812ULL, 0x000fe400078efcffULL,
0x0000007000aa7306ULL, 0x000fe20000005400ULL, 0x000000929100720bULL, 0x008fce0003f9d000ULL,
0x00000070007c7306ULL, 0x0003ec000000d400ULL, 0x0000000190904812ULL, 0x000fe400078efcffULL,
0x00000079008e7306ULL, 0x000fe20000209400ULL, 0x0001000070707824ULL, 0x002fca00078e00ffULL,
0x00000018ff807819ULL, 0x000fe40000011470ULL, 0x00000079008f7306ULL, 0x0002a20000205400ULL,
0x0000007800707245ULL, 0x000fe2000020d400ULL, 0x0001000071787824ULL, 0x000fc600078e00ffULL,
0x0000000170706812ULL, 0x000fe400078efcffULL, 0x000000949300720bULL, 0x000fe20003fdd000ULL,
0x0000007a00957306ULL, 0x000722000000d400ULL, 0x0000007900797245ULL, 0x002fe4000020d400ULL,
0x00000018ff847819ULL, 0x000fe20000011478ULL, 0x0000010072787824ULL, 0x000fe200078e00ffULL,
0x000000708570723eULL, 0x000fc600000010ffULL, 0x0000009b009c7306ULL, 0x000fe20000209400ULL,
0x000100007a7a7824ULL, 0x008fe200078e00ffULL, 0x0000008f8e00720bULL, 0x004fe40003f7d000ULL,
0x00000018ff897819ULL, 0x000fe40000011478ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x0000009b009d7306ULL, 0x0002a20000205400ULL, 0x0000000195956812ULL, 0x010fe400078efcffULL,
0x0000007a00787245ULL, 0x000fc8000020d400ULL, 0x0000000179793812ULL, 0x000fe200078efcffULL,
0x0000007b009e7306ULL, 0x000fe20000009400ULL, 0x0000009b009b7245ULL, 0x002fce000020d400ULL,
0x0000007b009f7306ULL, 0x000e620000005400ULL, 0x0000009d9c00720bULL, 0x004fce0003fdd000ULL,
0x0000009600977306ULL, 0x000fec0000209400ULL, 0x000000019b9b6812ULL, 0x000fe400078efcffULL,
0x0000009600987306ULL, 0x0004e20000205400ULL, 0x0000009f9e00720bULL, 0x002fce0003f9d000ULL,
0x000000a100a27306ULL, 0x000fe20000209400ULL, 0x0000009600967245ULL, 0x004fce000020d400ULL,
0x000000a100a37306ULL, 0x0002a20000205400ULL, 0x000000989700720bULL, 0x008fce0003fbd000ULL,
0x0000007b00a07306ULL, 0x000722000000d400ULL, 0x000000a100a17245ULL, 0x002fca000020d400ULL,
0x0000000196965812ULL, 0x000fe400078efcffULL, 0x000000ab00ac7306ULL, 0x000fe20000209400ULL,
0x000100007b7b7824ULL, 0x008fe200078e00ffULL, 0x000000a3a200720bULL, 0x004fc80003f7d000ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x000000ab00817306ULL, 0x0002a20000205400ULL,
0x00000001a0a04812ULL, 0x010fcc00078efcffULL, 0x00000001a1a13812ULL, 0x000fe200078efcffULL,
0x000000a600a77306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x002fce000020d400ULL,
0x000000a600a87306ULL, 0x0002e20000205400ULL, 0x00000081ac00720bULL, 0x004fe20003fdd000ULL,
0x0000010073817824ULL, 0x000fcc00078e00ffULL, 0x0000007a00997306ULL, 0x000fe20000209400ULL,
0x000000a600a67245ULL, 0x002fca000020d400ULL, 0x00000001abab6812ULL, 0x000fe400078efcffULL,
0x0000007a009a7306ULL, 0x000e620000205400ULL, 0x000000a8a700720bULL, 0x008fce0003f9d000ULL,
0x0000007b00a47306ULL, 0x000fec0000209400ULL, 0x00000001a6a64812ULL, 0x000fe400078efcffULL,
0x0000007b00a57306ULL, 0x0004e20000205400ULL, 0x0000009a9900720bULL, 0x002fce0003fbd000ULL,
0x0000007100b07306ULL, 0x000fe20000009400ULL, 0x0000007b007b7245ULL, 0x004fca000020d400ULL,
0x0000000178785812ULL, 0x000fe400078efcffULL, 0x0000007100b17306ULL, 0x000e620000005400ULL,
0x000000a5a400720bULL, 0x008fe40003f7d000ULL, 0x000000aaa900720bULL, 0x000fe40003fbd000ULL,
0x000000789b78723eULL, 0x000fc600000010ffULL, 0x0000007100227306ULL, 0x000eac000000d400ULL,
0x000000017b7b3812ULL, 0x000fe400078efcffULL, 0x0000008000827306ULL, 0x000fe20000209400ULL,
0x000000b1b000720bULL, 0x002fe40003f9d000ULL, 0x000000017c7c5812ULL, 0x000fc800078efcffULL,
0x0000007cab7c723eULL, 0x000fe200000010ffULL, 0x0000008000717306ULL, 0x0002ec0000205400ULL,
0x0000000122224812ULL, 0x004fe400078efcffULL, 0x0000008c00887306ULL, 0x000fe20000209400ULL,
0x0000008000807245ULL, 0x002fce000020d400ULL, 0x0000008c00837306ULL, 0x000e620000205400ULL,
0x000000718200720bULL, 0x008fe40003fdd000ULL, 0x000000799071723eULL, 0x000fe400000010ffULL,
0x0000007ba679723eULL, 0x000fc600000010ffULL, 0x0000008400867306ULL, 0x000fe40000209400ULL,
0x000000706c60723cULL, 0x040f680000041860ULL, 0x0000000180806812ULL, 0x000fe400078efcffULL,
0x0000008400877306ULL, 0x0004e20000205400ULL, 0x000000838800720bULL, 0x002fe20003f7d000ULL,
0x000000786c58723cULL, 0x000f620000041858ULL, 0x00000018ff887819ULL, 0x000fc40000011481ULL,
0x0000008c00817245ULL, 0x000fc6000020d400ULL, 0x000000ad00ae7306ULL, 0x000fe20000209400ULL,
0x0000008400847245ULL, 0x004fe2000020d400ULL, 0x000000706840723cULL, 0x040f680000041840ULL,
0x0000000181813812ULL, 0x000fe400078efcffULL, 0x000000ad00af7306ULL, 0x0002a20000205400ULL,
0x000000878600720bULL, 0x008fe20003fdd000ULL, 0x000000786838723cULL, 0x000f6c0000041838ULL,
0x000000b200b37306ULL, 0x000fe20000209400ULL, 0x000000ad00ad7245ULL, 0x002fca000020d400ULL,
0x0000000184846812ULL, 0x000fe400078efcffULL, 0x000000b200b47306ULL, 0x000e620000205400ULL,
0x000000afae00720bULL, 0x004fce0003fbd000ULL, 0x00000073007e7306ULL, 0x000fec0000009400ULL,
0x00000001adad5812ULL, 0x000fe400078efcffULL, 0x00000073007d7306ULL, 0x000ea20000005400ULL,
0x000000b4b300720bULL, 0x002fe40003f9d000ULL, 0x00000080ad80723eULL, 0x000fca00000010ffULL,
0x0000007200b57306ULL, 0x000fec0000009400ULL, 0x000000017f7f4812ULL, 0x000fe400078efcffULL,
0x0000007200b67306ULL, 0x000e620000005400ULL, 0x0000007d7e00720bULL, 0x004fe40003fdd000ULL,
0x00000022817d723eULL, 0x000fc400000010ffULL, 0x000000847f81723eULL, 0x000fc600000010ffULL,
0x00000089007a7306ULL, 0x000fe40000209400ULL, 0x0000007c6c54723cULL, 0x040f6c0000041854ULL,
0x00000089008b7306ULL, 0x000ea20000205400ULL, 0x000000b6b500720bULL, 0x002fe20003f7d000ULL,
0x000000806c50723cULL, 0x000f6c0000041850ULL, 0x00000088008d7306ULL, 0x000fe40000209400ULL,
0x0000007c6834723cULL, 0x040f6c0000041834ULL, 0x00000088008c7306ULL, 0x0002e20000205400ULL,
0x0000008b7a00720bULL, 0x004fe20003fbd000ULL, 0x000000806830723cULL, 0x000f620000041830ULL,
0x00000089007a7245ULL, 0x000fca000020d400ULL, 0x0000007200037306ULL, 0x000522000000d400ULL,
0x0000008800887245ULL, 0x002fca000020d400ULL, 0x000000017a7a5812ULL, 0x000fe400078efcffULL,
0x00000073000b7306ULL, 0x000322000000d400ULL, 0x0001000072727824ULL, 0x004fe200078e00ffULL,
0x0000008c8d00720bULL, 0x008fc80003f9d000ULL, 0x00000018ff827819ULL, 0x000fe40000011472ULL,
0x0000000c00767306ULL, 0x000fe20000209400ULL, 0x0001000073737824ULL, 0x002fe200078e00ffULL,
0x0000000103033812ULL, 0x010fe400078efcffULL, 0x000000959672723eULL, 0x000fe400000010ffULL,
0x00000018ff857819ULL, 0x000fe40000011473ULL, 0x0000000c00777306ULL, 0x000e620000205400ULL,
0x0000000188884812ULL, 0x000fc400078efcffULL, 0x000000010b0b6812ULL, 0x000fe400078efcffULL,
0x000000037a7a723eULL, 0x000fe400000010ffULL, 0x0000000c00037245ULL, 0x000fe2000020d400ULL,
0x0000001c00257306ULL, 0x000fe20000209400ULL, 0x000000a0a173723eULL, 0x000fe400000010ffULL,
0x0000000b887b723eULL, 0x000fe200000010ffULL, 0x00000008020b7824ULL, 0x000fc800078e00ffULL,
0x0000001c00207306ULL, 0x0004e20000205400ULL, 0x000000777600720bULL, 0x002fe20003fbd000ULL,
0x000000726c5c723cULL, 0x040f6c000004185cULL, 0x0000008200837306ULL, 0x000fe20000209400ULL,
0x0000001c001c7245ULL, 0x004fe2000020d400ULL, 0x0000007a6c4c723cULL, 0x000f68000004184cULL,
0x0000000103035812ULL, 0x000fc400078efcffULL, 0x0000008200867306ULL, 0x0002a20000205400ULL,
0x000000202500720bULL, 0x008fe20003f7d000ULL, 0x00000072683c723cULL, 0x040f6c000004183cULL,
0x0000008500877306ULL, 0x000fe20000209400ULL, 0x0000008200827245ULL, 0x002fe2000020d400ULL,
0x0000007a682c723cULL, 0x000f68000004182cULL, 0x000000011c1c3812ULL, 0x000fc400078efcffULL,
0x00000085007e7306ULL, 0x000e620000205400ULL, 0x000000868300720bULL, 0x004fe40003f9d000ULL,
0x0000008500837245ULL, 0x000fd6000020d400ULL, 0x0000000182824812ULL, 0x000fe400078efcffULL,
0x0000007e8700720bULL, 0x002fe40003fdd000ULL, 0x000000820382723eULL, 0x000fe200000010ffULL,
0x000000101d037824ULL, 0x000fd400078e020aULL, 0x0000000183836812ULL, 0x000fc800078efcffULL,
0x000000831c83723eULL, 0x000fce00000010ffULL, 0x000000826c48723cULL, 0x080b6e0000041848ULL,
0x000000101f6c7824ULL, 0x020fe200078e0200ULL, 0x000000826828723cULL, 0x000b620000041828ULL,
0x000000001e1c783bULL, 0x000e680000000200ULL, 0x000000000368783bULL, 0x0204e20000000200ULL,
0x0000008000000947ULL, 0x000fda0003800000ULL, 0x0000000768687231ULL, 0x088fe400003400ffULL,
0x000000076a6a7231ULL, 0x000fc400003400ffULL, 0x0000000669697231ULL, 0x080fe400003400ffULL,
0x000000066b6b7231ULL, 0x000fe400003400ffULL, 0x000000051c1c7231ULL, 0x082fe400003400ffULL,
0x000000051e1e7231ULL, 0x000fe400003400ffULL, 0x000000041d1d7231ULL, 0x080fe400003400ffULL,
0x000000041f1f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000006c6c783bULL, 0x000f220000004200ULL, 0xfffffff80b037812ULL, 0x004fca00078ee208ULL,
0x0000001003037824ULL, 0x000fca00078e0200ULL, 0x000000000370783bULL, 0x000ea20000004200ULL,
0x000001006c277824ULL, 0x010fe200078e00ffULL, 0x0000006c000a7306ULL, 0x000fe20000009400ULL,
0x000001006d7a7824ULL, 0x040fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe2000001146cULL,
0x000100006d847824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x000001006f967824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe2000001147aULL,
0x000001006e8d7824ULL, 0x000fe200078e00ffULL, 0x0000002700787306ULL, 0x000fe20000209400ULL,
0x00000018ff877819ULL, 0x000fe2000001146dULL, 0x00000100709e7824ULL, 0x004fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe20000011484ULL, 0x0000010071a17824ULL, 0x000fe200078e00ffULL,
0x00000018ff967819ULL, 0x000fc40000011496ULL, 0x00000018ff9e7819ULL, 0x000fe2000001149eULL,
0x0000002700797306ULL, 0x0005220000205400ULL, 0x00000018ffa87819ULL, 0x000fe400000114a1ULL,
0x00000018ffa37819ULL, 0x000fe40000011470ULL, 0x00000018ff907819ULL, 0x000fe4000001146eULL,
0x00000018ffae7819ULL, 0x000fe20000011471ULL, 0x0000006c000b7306ULL, 0x000ee20000005400ULL,
0x0000002700277245ULL, 0x004fc4000020d400ULL, 0x00000018ff8d7819ULL, 0x000fe4000001148dULL,
0x00000018ff997819ULL, 0x000fe4000001146fULL, 0x00000018ff007819ULL, 0x000fe20000011473ULL,
0x0000006c00267306ULL, 0x000462000000d400ULL, 0x000000797800720bULL, 0x010fe40003fbd000ULL,
0x000000a800797245ULL, 0x000fe4000020d400ULL, 0x00000018ff087819ULL, 0x000fc60000011472ULL,
0x0000008100827306ULL, 0x000fe20000209400ULL, 0x000100006c6c7824ULL, 0x004fe200078e00ffULL,
0x0000000b0a00720bULL, 0x008fe20003f1d000ULL, 0x00000100730a7824ULL, 0x000fe200078e00ffULL,
0x00000081000b7245ULL, 0x000fe4000020d400ULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000008100837306ULL, 0x000ea20000205400ULL, 0x0000000127275812ULL, 0x000fcc00078efcffULL,
0x0000000126260812ULL, 0x002fe200078efcffULL, 0x0000006d007e7306ULL, 0x000ff00000009400ULL,
0x0000006d007f7306ULL, 0x000e620000005400ULL, 0x000000838200720bULL, 0x004fe20003f7d000ULL,
0x0001000073837824ULL, 0x000fca00078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011483ULL,
0x0000006d00807306ULL, 0x000eac000000d400ULL, 0x000000010b0b3812ULL, 0x000fe400078efcffULL,
0x0000006c007a7306ULL, 0x000fe20000209400ULL, 0x0000007f7e00720bULL, 0x002fe20003fdd000ULL,
0x00010000727f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000006c006d7306ULL, 0x0002ec0000205400ULL, 0x0000000180806812ULL, 0x004fe400078efcffULL,
0x0000007b007c7306ULL, 0x000fe20000209400ULL, 0x0000006c006c7245ULL, 0x002fc4000020d400ULL,
0x000000800b0b723eULL, 0x000fca00000010ffULL, 0x0000007b007d7306ULL, 0x0002a20000205400ULL,
0x0000006d7a00720bULL, 0x008fce0003fbd000ULL, 0x0000008700887306ULL, 0x000fe20000209400ULL,
0x0000007b007b7245ULL, 0x002fca000020d400ULL, 0x000000016c6c5812ULL, 0x000fe400078efcffULL,
0x0000008700897306ULL, 0x0002e20000205400ULL, 0x0000007d7c00720bULL, 0x004fe40003f9d000ULL,
0x00000018ff7c7819ULL, 0x000fca000001140aULL, 0x0000008400857306ULL, 0x000fe20000209400ULL,
0x0000008700877245ULL, 0x002fca000020d400ULL, 0x000000017b7b4812ULL, 0x000fe400078efcffULL,
0x0000008400867306ULL, 0x0002a20000205400ULL, 0x000000898800720bULL, 0x008fce0003f1d000ULL,
0x0000006e008a7306ULL, 0x000fe20000009400ULL, 0x0000008400847245ULL, 0x002fca000020d400ULL,
0x0000000187870812ULL, 0x000fe400078efcffULL, 0x0000006e008b7306ULL, 0x000e620000005400ULL,
0x000000868500720bULL, 0x004fce0003f7d000ULL, 0x0000009600977306ULL, 0x000fec0000209400ULL,
0x0000000184843812ULL, 0x000fe400078efcffULL, 0x0000009600987306ULL, 0x0004e20000205400ULL,
0x0000008b8a00720bULL, 0x002fce0003fbd000ULL, 0x0000006f00937306ULL, 0x000fe20000009400ULL,
0x0000009600967245ULL, 0x004fce000020d400ULL, 0x0000006f00947306ULL, 0x000e620000005400ULL,
0x000000989700720bULL, 0x008fce0003f9d000ULL, 0x0000009e009f7306ULL, 0x000fec0000209400ULL,
0x0000000196964812ULL, 0x000fe400078efcffULL, 0x0000009e00a07306ULL, 0x000ea20000205400ULL,
0x000000949300720bULL, 0x002fce0003f7d000ULL, 0x00000070009c7306ULL, 0x000ff00000009400ULL,
0x00000070009d7306ULL, 0x000fe20000005400ULL, 0x000000a09f00720bULL, 0x004fce0003f1d000ULL,
0x0000007000207306ULL, 0x0003f0000000d400ULL, 0x0000006e008c7306ULL, 0x0004e2000000d400ULL,
0x0001000070707824ULL, 0x002fca00078e00ffULL, 0x00000018ffa17819ULL, 0x000fe20000011470ULL,
0x0001000071707824ULL, 0x000fe200078e00ffULL, 0x000000a800a97306ULL, 0x000fe20000209400ULL,
0x000100006e6e7824ULL, 0x004fc600078e00ffULL, 0x00000018ffab7819ULL, 0x000fe20000011470ULL,
0x0000010072707824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x000000a800aa7306ULL, 0x000e620000205400ULL, 0x000000018c8c5812ULL, 0x008fe400078efcffULL,
0x00000018ff787819ULL, 0x000fca0000011470ULL, 0x0000007100a67306ULL, 0x000ff00000009400ULL,
0x0000007100a77306ULL, 0x000ea20000005400ULL, 0x000000aaa900720bULL, 0x002fce0003fbd000ULL,
0x0000006f00957306ULL, 0x0002ec000000d400ULL, 0x0000000179795812ULL, 0x000fe400078efcffULL,
0x00000071000c7306ULL, 0x000f22000000d400ULL, 0x000100006f6f7824ULL, 0x002fe200078e00ffULL,
0x000000a7a600720bULL, 0x004fc80003f9d000ULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x000000a300a47306ULL, 0x000fe20000209400ULL, 0x0000000195953812ULL, 0x008fce00078efcffULL,
0x000000a300a57306ULL, 0x000fe20000205400ULL, 0x000000010c0c4812ULL, 0x010fce00078efcffULL,
0x000000a100a27306ULL, 0x000ff00000209400ULL, 0x000000a100717306ULL, 0x0002b00000205400ULL,
0x000000ab00ac7306ULL, 0x000fe20000209400ULL, 0x000000a100a17245ULL, 0x002fce000020d400ULL,
0x000000ab00ad7306ULL, 0x0002e20000205400ULL, 0x00000071a200720bULL, 0x004fce0003f7d000ULL,
0x0000008d008e7306ULL, 0x000fe20000209400ULL, 0x000000ab00ab7245ULL, 0x002fca000020d400ULL,
0x00000001a1a13812ULL, 0x000fe400078efcffULL, 0x0000008d008f7306ULL, 0x0002a20000205400ULL,
0x000000adac00720bULL, 0x008fce0003fbd000ULL, 0x0000006e000a7306ULL, 0x000fe20000209400ULL,
0x0000008d008d7245ULL, 0x002fca000020d400ULL, 0x00000001abab5812ULL, 0x000fe400078efcffULL,
0x0000006e006d7306ULL, 0x000e620000205400ULL, 0x0000008f8e00720bULL, 0x004fce0003fdd000ULL,
0x0000007300b37306ULL, 0x000fec0000009400ULL, 0x000000018d8d6812ULL, 0x000fe400078efcffULL,
0x0000007300b47306ULL, 0x000ea20000005400ULL, 0x0000006d0a00720bULL, 0x002fe40003f9d000ULL,
0x0000006e006d7245ULL, 0x000fc4000020d400ULL, 0x0000009d9c00720bULL, 0x000fe40003fdd000ULL,
0x00000026270a723eULL, 0x000fe200000010ffULL, 0x0000007300027306ULL, 0x0002e2000000d400ULL,
0x0000006c7b26723eULL, 0x000fe400000010ffULL, 0x00000090006c7245ULL, 0x000fe4000020d400ULL,
0x000000848727723eULL, 0x000fe200000010ffULL, 0x0000000a6864723cULL, 0x000b620000041864ULL,
0x000000016d6d4812ULL, 0x000fe200078efcffULL, 0x0000009000917306ULL, 0x000fe20000209400ULL,
0x0000009e00737245ULL, 0x002fc4000020d400ULL, 0x0000000120206812ULL, 0x000fe400078efcffULL,
0x0000000173730812ULL, 0x000fe200078efcffULL, 0x000000266860723cULL, 0x000b620000041860ULL,
0x000000a5a400720bULL, 0x000fe20003f1d000ULL, 0x0000009000927306ULL, 0x000fe20000205400ULL,
0x000000b4b300720bULL, 0x004fe40003f7d000ULL, 0x0000008c8d6e723eULL, 0x000fc600000010ffULL,
0x0000000a1c44723cULL, 0x040b640000041844ULL, 0x0000006f00707306ULL, 0x000fec0000209400ULL,
0x0000000102023812ULL, 0x008fe200078efcffULL, 0x000000261c40723cULL, 0x000b620000041840ULL,
0x0000006f00717306ULL, 0x000e700000205400ULL, 0x00000099009a7306ULL, 0x000ff00000209400ULL,
0x00000099009b7306ULL, 0x0004e20000205400ULL, 0x000000717000720bULL, 0x002fc40003fbd000ULL,
0x0000006f00707245ULL, 0x000fe4000020d400ULL, 0x0000000c7971723eULL, 0x000fe400000010ffULL,
0x00000095966f723eULL, 0x000fe200000010ffULL, 0x0000007200b17306ULL, 0x000fe20000009400ULL,
0x0000009900997245ULL, 0x004fca000020d400ULL, 0x0000000170705812ULL, 0x000fe200078efcffULL,
0x0000006e685c723cULL, 0x000b62000004185cULL, 0x0000007200b27306ULL, 0x000e620000005400ULL,
0x0000009b9a00720bULL, 0x008fcc0003f9d000ULL, 0x0000006e1c3c723cULL, 0x000b62000004183cULL,
0x0000007200037306ULL, 0x0004ec000000d400ULL, 0x0000000199994812ULL, 0x000fe400078efcffULL,
0x000000ae00af7306ULL, 0x000fe20000209400ULL, 0x000000a300727245ULL, 0x004fc4000020d400ULL,
0x000000b2b100720bULL, 0x002fe40003fdd000ULL, 0x0000000172720812ULL, 0x000fe400078efcffULL,
0x000000929100720bULL, 0x000fe20003f1d000ULL, 0x000000ae00b07306ULL, 0x0002a20000205400ULL,
0x000000a17272723eULL, 0x000fce00000010ffULL, 0x00000078007e7306ULL, 0x000fe20000209400ULL,
0x000000ae00ae7245ULL, 0x002fe4000020d400ULL, 0x0000000103036812ULL, 0x008fe400078efcffULL,
0x000000016c6c0812ULL, 0x000fc600078efcffULL, 0x00000078007d7306ULL, 0x0002e20000205400ULL,
0x000000b0af00720bULL, 0x004fe40003f1d000ULL, 0x0000006d6c6c723eULL, 0x000fe400000010ffULL,
0x00000070996d723eULL, 0x000fe400000010ffULL, 0x000000207370723eULL, 0x000fe200000010ffULL,
0x0000007c00817306ULL, 0x000fe20000209400ULL, 0x0000007800787245ULL, 0x002fc6000020d400ULL,
0x0000006c6858723cULL, 0x040b640000041858ULL, 0x00000001aeae0812ULL, 0x000fe400078efcffULL,
0x0000007c00827306ULL, 0x000e620000205400ULL, 0x0000007d7e00720bULL, 0x008fe40003fbd000ULL,
0x000000abae73723eULL, 0x000fe200000010ffULL, 0x000000706854723cULL, 0x040b680000041854ULL,
0x0000000800257306ULL, 0x000fe80000209400ULL, 0x000000726850723cULL, 0x000b640000041850ULL,
0x0000000178785812ULL, 0x000fc400078efcffULL, 0x0000000800767306ULL, 0x0004e20000205400ULL,
0x000000828100720bULL, 0x002fe40003f9d000ULL, 0x000000037878723eULL, 0x000fe200000010ffULL,
0x000000701c34723cULL, 0x000b620000041834ULL, 0x0000008300037245ULL, 0x000fc6000020d400ULL,
0x0000000000777306ULL, 0x000fe20000209400ULL, 0x0000000800087245ULL, 0x004fc6000020d400ULL,
0x000000721c30723cULL, 0x040b680000041830ULL, 0x0000000000227306ULL, 0x0002a20000205400ULL,
0x000000762500720bULL, 0x008fe40003f1d000ULL, 0x0000007c00257245ULL, 0x000fe2000020d400ULL,
0x0000006c1c38723cULL, 0x000b660000041838ULL, 0x0000000125254812ULL, 0x000fe200078efcffULL,
0x0000007f007a7306ULL, 0x000fe20000209400ULL, 0x0000000000007245ULL, 0x002fc4000020d400ULL,
0x000000022579723eULL, 0x000fc600000010ffULL, 0x0000000108080812ULL, 0x000fe400078efcffULL,
0x0000007f007b7306ULL, 0x0002e20000205400ULL, 0x000000227700720bULL, 0x004fe20003fbd000ULL,
0x00000078684c723cULL, 0x080b6c000004184cULL, 0x00000083007d7306ULL, 0x000fe20000209400ULL,
0x0000007f007f7245ULL, 0x002fe2000020d400ULL, 0x000000781c2c723cULL, 0x000b68000004182cULL,
0x0000000100005812ULL, 0x000fc400078efcffULL, 0x00000083007e7306ULL, 0x000e620000205400ULL,
0x0000007b7a00720bULL, 0x008fda0003fdd000ULL, 0x000000017f7f6812ULL, 0x000fe400078efcffULL,
0x0000007e7d00720bULL, 0x002fe40003f9d000ULL, 0x0000007f0802723eULL, 0x000fd600000010ffULL,
0x0000000103034812ULL, 0x000fc800078efcffULL, 0x000000030003723eULL, 0x000fce00000010ffULL,
0x000000026848723cULL, 0x080b700000041848ULL, 0x000000021c28723cULL, 0x000b620000041828ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x000000000d027f8cULL, 0x0202a2000c80043fULL,
0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL, 0x000126a010087811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000008ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff007224ULL, 0x004fe200078e0003ULL, 0x0000001000002944ULL, 0x000fe20003c00000ULL,
0xffff15f000007947ULL, 0x000fea000383ffffULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x000000ffff237224ULL, 0x000fe400078e002bULL, 0x000000ffff687224ULL, 0x000fe400078e002aULL,
0x000000ffff217224ULL, 0x002fe400078e002fULL, 0x000000ffff207224ULL, 0x000fc400078e002eULL,
0x000000ffff1f7224ULL, 0x000fe400078e0033ULL, 0x000000ffff147224ULL, 0x000fe400078e0032ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0180000024007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x000106e000047802ULL, 0x000fc40000000f00ULL, 0x0000bc1000007944ULL, 0x00cfea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002400037308ULL, 0x004e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000024ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000087919ULL, 0x008ee80000000000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x0000001808057811ULL, 0x048fe400078ff0ffULL,
0x0000000808097811ULL, 0x000fc400078ff0ffULL, 0x00000002ff077819ULL, 0x002fe40000011604ULL,
0x00000010080b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003067220ULL, 0x014fca0000410000ULL,
0x00001f0706007589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea800000e0000ULL,
0x00001f0906047589ULL, 0x000ee800000e0000ULL, 0x00001f0b06027589ULL, 0x000f2200000e0000ULL,
0x0000006400647220ULL, 0x042fe20000410000ULL, 0x0000006500657220ULL, 0x040fe20000410000ULL,
0x0000006000607220ULL, 0x040fe20000410000ULL, 0x0000006100617220ULL, 0x040fe20000410000ULL,
0x0000005c005c7220ULL, 0x040fe20000410000ULL, 0x0000005d005d7220ULL, 0x040fe20000410000ULL,
0x0000005800587220ULL, 0x040fe20000410000ULL, 0x0000005900597220ULL, 0x040fe20000410000ULL,
0x0000005400547220ULL, 0x040fe20000410000ULL, 0x0000005500557220ULL, 0x040fe20000410000ULL,
0x0000005000507220ULL, 0x040fe20000410000ULL, 0x0000005100517220ULL, 0x040fe20000410000ULL,
0x0000004c004c7220ULL, 0x040fe20000410000ULL, 0x0000004d004d7220ULL, 0x040fe20000410000ULL,
0x0000004800487220ULL, 0x040fe20000410000ULL, 0x0000004900497220ULL, 0x000fe20000410000ULL,
0x0000004605467220ULL, 0x044fe20000410000ULL, 0x0000004705477220ULL, 0x040fe20000410000ULL,
0x0000004205427220ULL, 0x040fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000003e053e7220ULL, 0x040fe20000410000ULL, 0x0000003f053f7220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x0000006805687220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x000fe20000410000ULL,
0x0000000466667220ULL, 0x088fe20000410000ULL, 0x0000000467677220ULL, 0x080fe20000410000ULL,
0x0000000462627220ULL, 0x080fe20000410000ULL, 0x0000000463637220ULL, 0x080fe20000410000ULL,
0x000000045e5e7220ULL, 0x080fe20000410000ULL, 0x000000045f5f7220ULL, 0x080fe20000410000ULL,
0x000000045a5a7220ULL, 0x080fe20000410000ULL, 0x000000045b5b7220ULL, 0x080fe20000410000ULL,
0x0000000456567220ULL, 0x080fe20000410000ULL, 0x0000000457577220ULL, 0x080fe20000410000ULL,
0x0000000452527220ULL, 0x080fe20000410000ULL, 0x0000000453537220ULL, 0x080fe20000410000ULL,
0x000000044e4e7220ULL, 0x080fe20000410000ULL, 0x000000044f4f7220ULL, 0x080fe20000410000ULL,
0x000000044a4a7220ULL, 0x080fe20000410000ULL, 0x000000044b4b7220ULL, 0x000fe20000410000ULL,
0x0000000244447220ULL, 0x090fe20000410000ULL, 0x0000000245457220ULL, 0x080fe20000410000ULL,
0x0000000240407220ULL, 0x080fe20000410000ULL, 0x0000000241417220ULL, 0x080fe20000410000ULL,
0x000000023c3c7220ULL, 0x080fe20000410000ULL, 0x000000023d3d7220ULL, 0x080fe20000410000ULL,
0x0000000238387220ULL, 0x080fe20000410000ULL, 0x0000000239397220ULL, 0x080fe20000410000ULL,
0x0000000234347220ULL, 0x080fe20000410000ULL, 0x0000000235357220ULL, 0x080fe20000410000ULL,
0x0000000230307220ULL, 0x080fe20000410000ULL, 0x0000000231317220ULL, 0x080fe20000410000ULL,
0x000000022c2c7220ULL, 0x080fe20000410000ULL, 0x000000022d2d7220ULL, 0x080fe20000410000ULL,
0x0000000228287220ULL, 0x080fe20000410000ULL, 0x0000000229297220ULL, 0x000fc20000410000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x000000666766723eULL, 0x000fc400000010ffULL,
0x000000626333723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000005e5f5e723eULL, 0x000fe400000010ffULL, 0x0000005a5b2f723eULL, 0x000fe400000010ffULL,
0x000000565756723eULL, 0x000fc400000010ffULL, 0x00000052532b723eULL, 0x000fe400000010ffULL,
0x0000004e4f4e723eULL, 0x000fe400000010ffULL, 0x0000004a4b27723eULL, 0x000fe400000010ffULL,
0x0000541066327816ULL, 0x000fe40000000033ULL, 0x0000000800037811ULL, 0x046fe200078ff0ffULL,
0x0000000175757824ULL, 0x000fe200078e0200ULL, 0x0000000200027812ULL, 0x000fc400078ec0ffULL,
0x00000002ff077819ULL, 0x000fe20000011600ULL, 0x00000008030d7824ULL, 0x000fe200078e00ffULL,
0x0000001000097811ULL, 0x040fe400078ff0ffULL, 0x00000018000b7811ULL, 0x000fe200078ff0ffULL,
0x00000008070c7824ULL, 0x000fe200078e00ffULL, 0x0000000302047211ULL, 0x040fe200078ff8ffULL,
0x0000000809107824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x040fe400078ff8ffULL,
0x0000000b02067211ULL, 0x040fe200078ff8ffULL, 0x000000080b0b7824ULL, 0x000fe200078e00ffULL,
0x0000000902057211ULL, 0x000fe200078ff8ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x0000000203027810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80d0e7812ULL, 0x000fe200078ee204ULL,
0x0000000807047824ULL, 0x000fe200078e00ffULL, 0xfffffff80b127812ULL, 0x000fe400078ee206ULL,
0xfffffff809087812ULL, 0x008fe200078ee202ULL, 0x0000200011027824ULL, 0x000fe200078e00ffULL,
0x0000000403067810ULL, 0x040fe40007ffe0ffULL, 0x0000000603077810ULL, 0x000fe20007ffe0ffULL,
0x0000001075757824ULL, 0x100fe200078e0202ULL, 0xfffffff810107812ULL, 0x000fe200078ee205ULL,
0x0000000800057824ULL, 0x000fe200078e00ffULL, 0xfffffff804047812ULL, 0x000fe200078ee203ULL,
0x0000100013037824ULL, 0x000fe200078e0202ULL, 0xfffffff8090a7812ULL, 0x000fc400078ee206ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x000000100e0f7824ULL, 0x100fe200078e0203ULL,
0x0000000805067812ULL, 0x000fe200078ec0ffULL, 0x0000001004057824ULL, 0x100fe200078e0203ULL,
0x000000606104723eULL, 0x000fe200000010ffULL, 0x0000001010157824ULL, 0x000fe200078e0203ULL,
0x0000763266337816ULL, 0x000fe20000000033ULL, 0x0000001012177824ULL, 0x100fe200078e0203ULL,
0x000000444544723eULL, 0x000fe200000010ffULL, 0x0000001008097824ULL, 0x100fe200078e0203ULL,
0x000000484908723eULL, 0x000fe200000010ffULL, 0x000000100a0b7824ULL, 0x100fe200078e0203ULL,
0x000000404122723eULL, 0x000fe200000010ffULL, 0x000000100c0d7824ULL, 0x000fe200078e0203ULL,
0x000000646503723eULL, 0x000fe200000010ffULL, 0x0000000105077824ULL, 0x000fe200078e0206ULL,
0x000000545505723eULL, 0x000fe200000010ffULL, 0x00000001060f7824ULL, 0x040fe200078e020fULL,
0x00005410031c7816ULL, 0x140fe20000000004ULL, 0x0000000106157824ULL, 0x040fe200078e0215ULL,
0x00007632031d7816ULL, 0x000fe20000000004ULL, 0x0000000106177824ULL, 0x040fe200078e0217ULL,
0x0000005c5d03723eULL, 0x000fe200000010ffULL, 0x0000000106097824ULL, 0x040fe200078e0209ULL,
0x000000585904723eULL, 0x000fe200000010ffULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x0000001c07007388ULL, 0x0003e20000000a00ULL, 0x00000001060d7824ULL, 0x000fe200078e020dULL,
0x000000505106723eULL, 0x000fc400000010ffULL, 0x000054105e2e7816ULL, 0x140fe4000000002fULL,
0x0000003c3d3c723eULL, 0x000fe400000010ffULL, 0x00000038391e723eULL, 0x000fe400000010ffULL,
0x000076325e2f7816ULL, 0x000fe4000000002fULL, 0x0000004c4d07723eULL, 0x002fe400000010ffULL,
0x00005410031c7816ULL, 0x000fc40000000004ULL, 0x00007632031d7816ULL, 0x000fe40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x0000001c09007388ULL, 0x000fe20000000a00ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000040b007388ULL, 0x000fe20000000a00ULL,
0x00005410562a7816ULL, 0x000fc4000000002bULL, 0x00007632562b7816ULL, 0x000fe2000000002bULL,
0x000000060d007388ULL, 0x0003e20000000a00ULL, 0x000054104e267816ULL, 0x140fe40000000027ULL,
0x000076324e277816ULL, 0x000fe20000000027ULL, 0x000000320f007388ULL, 0x0005e20000000a00ULL,
0x000054103c0e7816ULL, 0x000fe4000000001eULL, 0x000000343534723eULL, 0x000fe200000010ffULL,
0x0004002e09007388ULL, 0x000fe20000000a00ULL, 0x00000030311a723eULL, 0x000fc400000010ffULL,
0x0000002c2d2c723eULL, 0x000fe200000010ffULL, 0x0004002a0b007388ULL, 0x000fe20000000a00ULL,
0x0000541044067816ULL, 0x142fe40000000022ULL, 0x0000763244077816ULL, 0x000fe20000000022ULL,
0x000400260d007388ULL, 0x000fe20000000a00ULL, 0x000076323c0f7816ULL, 0x004fe4000000001eULL,
0x000000282916723eULL, 0x000fe200000010ffULL, 0x0000000615007388ULL, 0x0003e20000000a00ULL,
0x000000464703723eULL, 0x000fc400000010ffULL, 0x000000424304723eULL, 0x000fe200000010ffULL,
0x0008000e09007388ULL, 0x0005e20000000a00ULL, 0x0000003e3f05723eULL, 0x000fe400000010ffULL,
0x0000003a3b06723eULL, 0x002fe400000010ffULL, 0x00005410340e7816ULL, 0x144fe4000000001aULL,
0x00007632340f7816ULL, 0x000fca000000001aULL, 0x0008000e0b007388ULL, 0x0003e40000000a00ULL,
0x000054102c0e7816ULL, 0x142fe40000000016ULL, 0x000076322c0f7816ULL, 0x000fca0000000016ULL,
0x0008000e0d007388ULL, 0x0003e40000000a00ULL, 0x00005410030e7816ULL, 0x142fe40000000004ULL,
0x00007632030f7816ULL, 0x000fe40000000004ULL, 0x000000363703723eULL, 0x000fe400000010ffULL,
0x000000141f04723eULL, 0x000fe200000010ffULL, 0x0000000e17007388ULL, 0x0003e60000000a00ULL,
0x0000541003087816ULL, 0x000fc40000000004ULL, 0x00005410050e7816ULL, 0x142fe40000000006ULL,
0x00007632050f7816ULL, 0x000fe40000000006ULL, 0x000000202105723eULL, 0x000fe400000010ffULL,
0x000000682306723eULL, 0x000fe200000010ffULL, 0x000c000e09007388ULL, 0x0003e40000000a00ULL,
0x0000763203097816ULL, 0x002fe40000000004ULL, 0x000000ff00037306ULL, 0x000fe20000205400ULL,
0x00005410050e7816ULL, 0x000fc40000000006ULL, 0x00007632050f7816ULL, 0x000fe20000000006ULL,
0x000c00080b007388ULL, 0x000fe80000000a00ULL, 0x000000ff00047306ULL, 0x000e620000209400ULL,
0x000c000e0d007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000075147984ULL, 0x000ea80000000c00ULL, 0x0004000075087984ULL, 0x000ee20000000c00ULL,
0x000000030400720bULL, 0x002fc40003f1d000ULL, 0x000000ff00037245ULL, 0x000fe2000020d400ULL,
0x0008000075247984ULL, 0x000e680000000c00ULL, 0x000c000075287984ULL, 0x000f280000000c00ULL,
0x00100000751c7984ULL, 0x000e640000000c00ULL, 0x0000000103030812ULL, 0x000fc400078efcffULL,
0x0014000075207984ULL, 0x000f220000000c00ULL, 0x000000ff1300720cULL, 0x000fe40003f05270ULL,
0x000000030312723eULL, 0x000fe200000010ffULL, 0x0018000075047984ULL, 0x000f280000000c00ULL,
0x001c0000750c7984ULL, 0x000f220000000c00ULL, 0x3f803f8012177831ULL, 0x044fe40000200017ULL,
0x3f803f8012167831ULL, 0x000fc40000200016ULL, 0x3f803f8012157831ULL, 0x040fe40000200015ULL,
0x3f803f8012147831ULL, 0x040fe40000200014ULL, 0x3f803f80120b7831ULL, 0x048fe4000020000bULL,
0x3f803f80120a7831ULL, 0x040fe4000020000aULL, 0x3f803f8012097831ULL, 0x040fe40000200009ULL,
0x3f803f8012087831ULL, 0x000fc40000200008ULL, 0x3f803f8012277831ULL, 0x042fe40000200027ULL,
0x3f803f8012267831ULL, 0x040fe40000200026ULL, 0x3f803f8012257831ULL, 0x040fe40000200025ULL,
0x3f803f8012247831ULL, 0x040fe40000200024ULL, 0x3f803f80122b7831ULL, 0x050fe4000020002bULL,
0x3f803f80122a7831ULL, 0x000fc4000020002aULL, 0x3f803f8012297831ULL, 0x040fe40000200029ULL,
0x3f803f8012287831ULL, 0x000fe40000200028ULL, 0x3f803f8017177831ULL, 0x000fe4000020001fULL,
0x3f803f8016167831ULL, 0x000fe4000020001eULL, 0x3f803f8015157831ULL, 0x000fe4000020001dULL,
0x3f803f8014147831ULL, 0x000fc4000020001cULL, 0x3f803f800b0b7831ULL, 0x000fe40000200023ULL,
0x3f803f800a0a7831ULL, 0x000fe20000200022ULL, 0x0000001475007388ULL, 0x000fe20000000c00ULL,
0x3f803f8009097831ULL, 0x000fe40000200021ULL, 0x3f803f8008087831ULL, 0x000fe40000200020ULL,
0x3f803f8027277831ULL, 0x000fe40000200007ULL, 0x3f803f8026267831ULL, 0x000fe20000200006ULL,
0x0004000875007388ULL, 0x000fe20000000c00ULL, 0x3f803f8025257831ULL, 0x000fc40000200005ULL,
0x3f803f8024247831ULL, 0x000fe40000200004ULL, 0x3f803f802b2b7831ULL, 0x000fe4000020000fULL,
0x3f803f802a2a7831ULL, 0x000fe2000020000eULL, 0x0008002475007388ULL, 0x000fe20000000c00ULL,
0x3f803f8029297831ULL, 0x000fe4000020000dULL, 0x3f803f8028287831ULL, 0x000fca000020000cULL,
0x000c002875007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fc80000011600ULL,
0x000000180900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000067b06ULL, 0x000e620000209000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00005a00ff0f7a12ULL, 0x000fe400078e33ffULL, 0x00000007000e7812ULL, 0x000fc800078ec0ffULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe06087810ULL, 0x002fcc0007ffe0ffULL,
0x0000000800057305ULL, 0x000e64000021f000ULL, 0x000000ffff037224ULL, 0x002fc800078e0a05ULL,
0x00005a0003037a24ULL, 0x000fc800078e02ffULL, 0x0000000305107227ULL, 0x000fc800078e0004ULL,
0x0000000119037824ULL, 0x000fc800078e0209ULL, 0x0000000310077227ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x000fc800078e0a07ULL, 0x00005a0004057a24ULL, 0x000fe400078e0203ULL,
0x0000000109047824ULL, 0x000fc600078e0200ULL, 0x00005a0005007a0cULL, 0x000fda0003f06070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x0000000704057812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x0ffffff805057812ULL, 0x000fca00078ef800ULL,
0x0000001005067824ULL, 0x000fe400078e0202ULL, 0x0000000107071810ULL, 0x000fc60007ffe0ffULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x000000070f047207ULL, 0x000fe40004000000ULL,
0x0000002000077810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe200078e021bULL, 0x00000003ff067819ULL, 0x002fe20000011607ULL,
0x00005a000c037a24ULL, 0x000fc800078e0203ULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x0000000374037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440cULL,
0x0000000811037824ULL, 0x000fe200078e020eULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x00000040000d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107067824ULL, 0x000fe400078e0206ULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef807ULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc6000001160dULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x00000007070c7812ULL, 0x000fc600078ec0ffULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x0000000374037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440eULL, 0x0000000811037824ULL, 0x000fe200078e020cULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x0000006000077810ULL, 0x000fe20007ffe0ffULL,
0x000000010d067824ULL, 0x000fe400078e0206ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef80dULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f047207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc60000011607ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe400078e021bULL, 0x00005a000c037a24ULL, 0x000fe200078e0203ULL,
0x000000070d0c7812ULL, 0x000fc600078ec0ffULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x0000000374037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440eULL,
0x0000000811037824ULL, 0x000fe200078e020cULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x00000080000d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107067824ULL, 0x000fe400078e0206ULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef807ULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc6000001160dULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x00000007070c7812ULL, 0x000fc600078ec0ffULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x0000000374037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440eULL, 0x0000000811037824ULL, 0x000fe200078e020cULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x000000a000077810ULL, 0x000fe20007ffe0ffULL,
0x000000010d067824ULL, 0x000fe400078e0206ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef80dULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f047207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc60000011607ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe400078e021bULL, 0x00005a000c037a24ULL, 0x000fe200078e0203ULL,
0x000000070d0c7812ULL, 0x000fc600078ec0ffULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x0000000374037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440eULL,
0x0000000811037824ULL, 0x000fe200078e020cULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x000000c0000d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107067824ULL, 0x000fe400078e0206ULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef807ULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc6000001160dULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x00000007070c7812ULL, 0x000fc600078ec0ffULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x0000000374037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440eULL, 0x0000000811037824ULL, 0x000fe200078e020cULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x000000e000077810ULL, 0x000fe20007ffe0ffULL,
0x000000010d067824ULL, 0x040fe200078e0206ULL, 0x000000070d007812ULL, 0x000fe200078ec0ffULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef80dULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc60000011607ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe400078e0203ULL, 0x0000000119197824ULL, 0x000fe400078e0206ULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x0000000374037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440cULL, 0x0000000811037824ULL, 0x000fe200078e0200ULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000001910007227ULL, 0x000fc800078e00ffULL, 0x000000ffff047224ULL, 0x002fe400078e0a00ULL,
0x0000000107067824ULL, 0x000fe400078e0206ULL, 0x00005a0004037a24ULL, 0x000fc600078e0219ULL,
0x0000000706067812ULL, 0x000fe400078ec0ffULL, 0x00005a0003007a0cULL, 0x000fda0003f26070ULL,
0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL, 0x0000000100001810ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f46070ULL, 0xfffffff806037812ULL, 0x000fca00078ef807ULL,
0x0000001003047824ULL, 0x000fca00078e0202ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000100002810ULL, 0x000fc80007ffe0ffULL, 0x000000000f007207ULL, 0x000fca0004000000ULL,
0x000000ffff027224ULL, 0x000fe400078e0a00ULL, 0x0000590000007a24ULL, 0x000fe400078e021bULL,
0x00005a0002197a24ULL, 0x000fc800078e0219ULL, 0x00005a0000197a24ULL, 0x000fe200078e0219ULL,
0x0000000707007812ULL, 0x000fc800078ec0ffULL, 0x0000001974197210ULL, 0x000fe20007f1e0ffULL,
0x0000000811117824ULL, 0x000fc800078e0200ULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005e0019027a11ULL, 0x000fc800078040ffULL, 0x00005f0019037a11ULL, 0x000fca00000f4406ULL,
0x0000001011027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006c00ff067624ULL, 0x002fe400078e00ffULL,
0x00006d00ff077624ULL, 0x000fca00078e00ffULL, 0x0000000606067981ULL, 0x000322000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x0000001fff077424ULL, 0x002fe200078e00ffULL, 0x01260000ff047f8cULL, 0x000e62000c80043fULL,
0x000000020e0e7824ULL, 0x000fe400078e00ffULL, 0x000000401a617824ULL, 0x000fe200078e00ffULL,
0x0000580007077a10ULL, 0x000fe20007ffe0ffULL, 0x000059000e007a24ULL, 0x000fc600078e021bULL,
0x00000005ff077819ULL, 0x000fe20000011607ULL, 0x0000680000147a24ULL, 0x000fe400078e0261ULL,
0x0000060000000947ULL, 0x000fea0003800000ULL, 0x00000002ff257819ULL, 0x000fe40000011617ULL,
0x0000001717127211ULL, 0x000fe400078fe8ffULL, 0x0000000825137810ULL, 0x040fe20007ffe0ffULL,
0x0000000114087824ULL, 0x000fe200078e0225ULL, 0x0000001825297810ULL, 0x040fe40007ffe0ffULL,
0x0000001025277810ULL, 0x040fe20007ffe0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x00000020251f7810ULL, 0x000fc40007ffe0ffULL, 0x00000003121e7812ULL, 0x000fe200078ec0ffULL,
0x00000001140a7824ULL, 0x000fe200078e0213ULL, 0x0000003008107812ULL, 0x000fe200078ef803ULL,
0x00000001140e7824ULL, 0x000fe200078e0229ULL, 0x0000006116087217ULL, 0x000fe20007800000ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000640010107a10ULL, 0x000fe40007f1e0ffULL,
0x0000002825217810ULL, 0x000fe20007ffe0ffULL, 0x00000001140c7824ULL, 0x040fe200078e0227ULL,
0x0000650009117a10ULL, 0x000fe200007fe4ffULL, 0x0000000114097824ULL, 0x000fe200078e021fULL,
0x000000300a0a7812ULL, 0x000fe200078ef803ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000020001a207811ULL, 0x000fc400078e68ffULL, 0x000064000a0a7a10ULL, 0x000fe20007f3e0ffULL,
0x0000000108187824ULL, 0x000fe200078e0a61ULL, 0x000000300e0e7812ULL, 0x100fe200078ef803ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000065000b0b7a10ULL, 0x000fe40000ffe4ffULL,
0x000064000e0e7a10ULL, 0x000fe20007f3e0ffULL, 0x0000008009087825ULL, 0x000fe200078e00ffULL,
0x000000300c0c7812ULL, 0x100fe400078ef803ULL, 0x000065000f0f7a10ULL, 0x000fe20000ffe4ffULL,
0x00000004131b7824ULL, 0x000fe200078e00ffULL, 0x0000003008127812ULL, 0x000fe200078ef803ULL,
0x0000000114087824ULL, 0x000fe200078e0221ULL, 0x000064000c0c7a10ULL, 0x000fc40007f1e0ffULL,
0x0000640012127a10ULL, 0x000fe40007f5e0ffULL, 0x000000181300720cULL, 0x080fe40003f26070ULL,
0x000065000d0d7a10ULL, 0x000fe400007fe4ffULL, 0x0000650009137a10ULL, 0x000fe200017fe4ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000000182500720cULL, 0x000fe40003f06070ULL,
0x0ffffffc1e177812ULL, 0x000fc400078ef817ULL, 0xfffffffc1b1b7812ULL, 0x000fe400078ee21eULL,
0x0000003025237810ULL, 0x000fe20007ffe0ffULL, 0x0000001017177824ULL, 0x100fe200078e0220ULL,
0x00000030081c7812ULL, 0x000fe200078ef803ULL, 0x000000101b1b7824ULL, 0x000fe200078e0220ULL,
0x0000003825257810ULL, 0x000fe20007ffe0ffULL, 0x0000000114087824ULL, 0x000fe200078e0223ULL,
0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0005e2000c101c46ULL, 0x000000182700720cULL, 0x000fc40003fa6070ULL,
0x00006500091d7a10ULL, 0x000fe200037fe4ffULL, 0x000000000a1b7faeULL, 0x0007e2000c901c46ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000000181f00720cULL, 0x080fe40003f66070ULL,
0x000000182900720cULL, 0x080fe40003f86070ULL, 0x0000003008087812ULL, 0x000fe200078ef803ULL,
0x0000000427117824ULL, 0x004fe200078e00ffULL, 0x000000182100720cULL, 0x080fe20003f46070ULL,
0x0000000429177824ULL, 0x000fe200078e00ffULL, 0x000000182300720cULL, 0x000fe20003f26070ULL,
0x00000001140a7824ULL, 0x008fe200078e0225ULL, 0xfffffffc11117812ULL, 0x100fe200078ee21eULL,
0x000000041f1b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc17177812ULL, 0x000fe200078ee21eULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000640008087a10ULL, 0x000fc40007fde0ffULL,
0x000000182500720cULL, 0x000fe20003f06070ULL, 0x00000004211f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1b1b7812ULL, 0x100fe200078ee21eULL, 0x0000000423217824ULL, 0x000fe200078e00ffULL,
0x000000300a037812ULL, 0x000fe200078ef803ULL, 0x0000000425237824ULL, 0x000fe200078e00ffULL,
0xfffffffc1f1f7812ULL, 0x000fe200078ee21eULL, 0x0000001011117824ULL, 0x000fe200078e0220ULL,
0xfffffffc21217812ULL, 0x000fe200078ee21eULL, 0x0000001017177824ULL, 0x000fe200078e0220ULL,
0xfffffffc23237812ULL, 0x000fe200078ee21eULL, 0x000000101b1b7824ULL, 0x100fe200078e0220ULL,
0x0000650009097a10ULL, 0x000fe200037fe4ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0220ULL,
0x00006400030a7a10ULL, 0x000fe20007fde0ffULL, 0x0000001021217824ULL, 0x100fe200078e0220ULL,
0x000000000c117faeULL, 0x0005e2000e901c46ULL, 0x0000001023237824ULL, 0x000fe200078e0220ULL,
0x000065000b0b7a10ULL, 0x000fc400037fe4ffULL, 0x000000000e177faeULL, 0x0005e8000e101c46ULL,
0x00000000121b7faeULL, 0x0005e8000d901c46ULL, 0x000000001c1f7faeULL, 0x0005e8000d101c46ULL,
0x0000000008217faeULL, 0x0005e8000c901c46ULL, 0x000000000a237faeULL, 0x0005e2000c101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x00000028170b7811ULL, 0x040fe400078ff0ffULL,
0x0000002017097811ULL, 0x000fc400078ff0ffULL, 0x00000030170d7811ULL, 0x040fe200078ff0ffULL,
0x0000000114207824ULL, 0x040fe200078e020bULL, 0x00000017170a7211ULL, 0x000fe200078fe8ffULL,
0x00000004091d7824ULL, 0x000fe200078e00ffULL, 0x0000000817117811ULL, 0x000fe200078ff0ffULL,
0x000000040b0b7824ULL, 0x000fe200078e00ffULL, 0x0000001017137811ULL, 0x040fe200078ff0ffULL,
0x0000000114227824ULL, 0x040fe200078e020dULL, 0x00000018171b7811ULL, 0x000fe200078ff0ffULL,
0x000000040d0d7824ULL, 0x000fe200078e00ffULL, 0x00000038170f7811ULL, 0x040fe200078ff0ffULL,
0x00000001140c7824ULL, 0x000fe200078e0213ULL, 0x0000001417087211ULL, 0x000fe200078ff0ffULL,
0x0000000413137824ULL, 0x000fe200078e00ffULL, 0x000000030a1e7812ULL, 0x000fe200078ec0ffULL,
0x00000001140a7824ULL, 0x000fe200078e0211ULL, 0x000020001a297811ULL, 0x000fe200078e68ffULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b1c7812ULL, 0x100fe200078ee21eULL,
0x00000001140e7824ULL, 0x000fe200078e021bULL, 0x0ffffffc1e177812ULL, 0x000fe200078ef817ULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc11107812ULL, 0x100fe200078ee21eULL,
0x0000000114187824ULL, 0x040fe200078e0209ULL, 0xfffffffc13117812ULL, 0x100fe200078ee21eULL,
0x0000000114247824ULL, 0x000fe200078e020fULL, 0xfffffffc1d147812ULL, 0x100fe200078ee21eULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0d1d7812ULL, 0x100fe200078ee21eULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0xfffffffc1b137812ULL, 0x000fc400078ee21eULL,
0xfffffffc0f1e7812ULL, 0x000fe200078ee21eULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000003008127812ULL, 0x000fc600078ef803ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fc60007f1e0ffULL, 0x000000101c257824ULL, 0x000fe200078e0229ULL,
0x000000300a1c7812ULL, 0x000fe200078ef803ULL, 0x00000010172d7824ULL, 0x000fe200078e0229ULL,
0x000000300c1f7812ULL, 0x000fe200078ef803ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000064001c1c7a10ULL, 0x000fc60007f3e0ffULL, 0x0000001010177824ULL, 0x000fe200078e0229ULL,
0x000000300e0e7812ULL, 0x000fe200078ef803ULL, 0x00000010111b7824ULL, 0x100fe400078e0229ULL,
0x0000001013217824ULL, 0x100fe200078e0229ULL, 0x0000650009137a10ULL, 0x000fe200007fe4ffULL,
0x0000001014237824ULL, 0x100fe200078e0229ULL, 0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x000000101d277824ULL, 0x100fe200078e0229ULL, 0x000065000b1d7a10ULL, 0x000fe20000ffe4ffULL,
0x000000101e297824ULL, 0x000fe200078e0229ULL, 0x000064001f1e7a10ULL, 0x000fe20007f5e0ffULL,
0x0000008018087825ULL, 0x000fe200078e00ffULL, 0x000065000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000122d7faeULL, 0x0005e2000b901c46ULL,
0x000065000d1f7a10ULL, 0x000fe200017fe4ffULL, 0x00000080200a7825ULL, 0x000fe200078e00ffULL,
0x0000003008087812ULL, 0x100fe200078ef803ULL, 0x000000001c177faeULL, 0x0005e4000b901c46ULL,
0x00000080220c7825ULL, 0x000fe200078e00ffULL, 0x000000300a0a7812ULL, 0x100fe200078ef803ULL,
0x000000001e1b7faeULL, 0x0005e2000b901c46ULL, 0x0000640008087a10ULL, 0x000fe20007f1e0ffULL,
0x0000008024107825ULL, 0x000fe200078e00ffULL, 0x000000300c0c7812ULL, 0x000fe200078ef803ULL,
0x000000000e217faeULL, 0x0005e2000b901c46ULL, 0x000064000a0a7a10ULL, 0x000fc40007f3e0ffULL,
0x0000003010037812ULL, 0x000fe400078ef803ULL, 0x000064000c0c7a10ULL, 0x000fe40007f5e0ffULL,
0x0000640003107a10ULL, 0x000fe40007f7e0ffULL, 0x0000650009097a10ULL, 0x000fe400007fe4ffULL,
0x000065000b0b7a10ULL, 0x000fe40000ffe4ffULL, 0x000065000d0d7a10ULL, 0x000fe200017fe4ffULL,
0x0000000008237faeULL, 0x0005e2000b901c46ULL, 0x0000650011117a10ULL, 0x000fc60001ffe4ffULL,
0x000000000a257faeULL, 0x0005e8000b901c46ULL, 0x000000000c277faeULL, 0x0005e8000b901c46ULL,
0x0000000010297faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x004fc40000015200ULL, 0x01260400ff037984ULL, 0x000ea20000000800ULL,
0x0000000702027224ULL, 0x000fe400078e02ffULL, 0x0000000116147824ULL, 0x000fc400078e0a5fULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x8000000003ff7812ULL, 0x006fe20007804805ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620002027625ULL, 0x000fe200078e002bULL, 0x00000008ff147819ULL, 0x000fe20000011614ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000000d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x000000201a047824ULL, 0x002fca00078e0205ULL, 0x00000004ff057819ULL, 0x000fe40000011604ULL,
0x0000000104087810ULL, 0x040fe40007ffe0ffULL, 0x0ffffffe05097812ULL, 0x000fe400078ec0ffULL,
0x0000001f04057812ULL, 0x000fc600078ec0ffULL, 0x00000001090b7824ULL, 0x040fe400078e0208ULL,
0x00000001040a7824ULL, 0x000fe200078e0209ULL, 0x0000000809097810ULL, 0x000fe20007ffe0ffULL,
0x00000010050c7824ULL, 0x000fe200078e00ffULL, 0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x00000010050d7824ULL, 0x000fe200078e00ffULL, 0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000108087824ULL, 0x000fe200078e0209ULL, 0x000001f00c0b7812ULL, 0x000fe200078ee20bULL,
0x0000000104047824ULL, 0x000fe200078e0209ULL, 0x000001f00d0a7812ULL, 0x000fe200078ee20aULL,
0x0000001005097824ULL, 0x040fe200078e00ffULL, 0x0000000f08087812ULL, 0x000fe200078ec0ffULL,
0x000000000b0c7984ULL, 0x000e62000000cc00ULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x0000000f04047812ULL, 0x000fc400078ec0ffULL, 0x000000000a107984ULL, 0x000ea4000000cc00ULL,
0x000001f005087812ULL, 0x000fe400078ee208ULL, 0x000001f009047812ULL, 0x000fe200078ee204ULL,
0x000000ffff1e7224ULL, 0x002fe400078e000cULL, 0x000000ffff1f7224ULL, 0x000fe400078e000eULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fc400078e0012ULL,
0x000000ffff227224ULL, 0x000fe400078e000dULL, 0x000000ffff237224ULL, 0x000fe200078e000fULL,
0x0000001c0a007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff207224ULL, 0x000fe400078e0011ULL,
0x000000ffff217224ULL, 0x000fca00078e0013ULL, 0x000000200b007388ULL, 0x000fe8000000cc00ULL,
0x00000000080c7984ULL, 0x000e68000000cc00ULL, 0x0000000004107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff277224ULL, 0x002fe400078e000eULL, 0x000000ffff267224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff247224ULL, 0x004fe400078e0010ULL,
0x000000ffff257224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000002404007388ULL, 0x0003e8000000cc00ULL,
0x0000000c08007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01260000ff0a7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0c7224ULL, 0x002fc600078e00ffULL,
0x0000000000047805ULL, 0x000fc80000015200ULL, 0x01260400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x006fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008040d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e05ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000000d08087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000187919ULL, 0x000e620000000000ULL, 0x0000000207177824ULL, 0x000fe200078e00ffULL,
0x3db504f3061b7820ULL, 0x010fe20000410000ULL, 0x000126881a5e7811ULL, 0x040fe200078e18ffULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0xffffffff5f607810ULL, 0x040fe40007ffe0ffULL,
0x000000095f647810ULL, 0x000fe40007ffe0ffULL, 0x000126081a657811ULL, 0x000fc400078e28ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff697224ULL, 0x000fe200078e0067ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000000ffff687224ULL, 0x000fe200078e00ffULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x00cfc4000001ff00ULL, 0x000000016800780cULL, 0x000fe20003f25270ULL,
0x00000bc000007945ULL, 0x000fe20003800000ULL, 0x00000001662c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff777224ULL, 0x000fe200078e0068ULL, 0x00000001682d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000169677812ULL, 0x000fe400078e0cffULL, 0x000000022d00780cULL, 0x000fe20003f06070ULL,
0x000000ffff687224ULL, 0x000fc800078e002dULL, 0x000000ffff2c1224ULL, 0x000fc800078e0266ULL,
0x000001002c577824ULL, 0x060fe200078e0261ULL, 0x000000012c2e7810ULL, 0x000fe40007ffe0ffULL,
0x000000ff2d2c7207ULL, 0x000fe20000800000ULL, 0x00006800006d7a24ULL, 0x000fe200078e0257ULL,
0x000000152e00720cULL, 0x000fda0003f46070ULL, 0x000005d00000a947ULL, 0x000fea0003800000ULL,
0x00000010182d7824ULL, 0x002fe200078e00ffULL, 0x00000002ff5c7819ULL, 0x000fe20000011618ULL,
0x000000021a5b7824ULL, 0x000fe200078e0267ULL, 0x0000005716547217ULL, 0x000fe40007800000ULL,
0x000000302d2d7812ULL, 0x000fe200078ec0ffULL, 0x000000015c2f7824ULL, 0x040fe200078e026dULL,
0x000000185c6a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001545a7824ULL, 0x000fe200078e0a57ULL,
0x000000085c587810ULL, 0x000fe20007ffe0ffULL, 0x000000402c2c7824ULL, 0x000fe200078e022dULL,
0x000000105c597810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff2d7224ULL, 0x000fe200078e00ffULL,
0x000000205c6c7810ULL, 0x000fe20007ffe0ffULL, 0x000000016a557824ULL, 0x040fe200078e026dULL,
0x000020005b5b7811ULL, 0x000fe200078e60ffULL, 0x000000802f2e7825ULL, 0x000fe200078e002cULL,
0x0000005a6a00720cULL, 0x000fc60003fa6070ULL, 0x0000000158517824ULL, 0x000fe200078e026dULL,
0x000064002e567a10ULL, 0x000fe20007f3e0ffULL, 0x000000016d537824ULL, 0x000fe200078e0259ULL,
0x00000018182e7211ULL, 0x000fe200078fe8ffULL, 0x0000008055547825ULL, 0x100fe200078e002cULL,
0x000065002f577a10ULL, 0x000fe40000ffe4ffULL, 0x000000032e6f7812ULL, 0x000fe200078ec0ffULL,
0x0000008051507825ULL, 0x000fe200078e002cULL, 0x0000640054547a10ULL, 0x000fe40007f3e0ffULL,
0x0ffffffc6f627812ULL, 0x000fe200078ef818ULL, 0x0000000459707824ULL, 0x000fe200078e00ffULL,
0x0000640050507a10ULL, 0x000fe20007f5e0ffULL, 0x0000008053527825ULL, 0x000fe200078e002cULL,
0x0000650055557a10ULL, 0x000fc40000ffe4ffULL, 0x0000005a5c00720cULL, 0x080fe20003f26070ULL,
0x000000016c2f7824ULL, 0x000fe200078e026dULL, 0x0000640052527a10ULL, 0x000fe20007f7e0ffULL,
0x00000010625d7824ULL, 0x000fe200078e025bULL, 0xfffffffc70627812ULL, 0x000fe200078ee26fULL,
0x000000802f2e7825ULL, 0x000fe200078e002cULL, 0x0000650051517a10ULL, 0x000fe400017fe4ffULL,
0x0000650053537a10ULL, 0x000fe20001ffe4ffULL, 0x00000004586e7824ULL, 0x040fe200078e00ffULL,
0x0000005a5800720cULL, 0x080fe20003f46070ULL, 0x00000010626b7824ULL, 0x000fe200078e025bULL,
0x0000005a5900720cULL, 0x000fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000565d7faeULL, 0x0003e2000c901c46ULL, 0x000064002e587a10ULL, 0x000fc40007f9e0ffULL,
0x000000285c627810ULL, 0x000fe40007ffe0ffULL, 0xfffffffc6e2e7812ULL, 0x000fe400078ee26fULL,
0x000065002f597a10ULL, 0x000fe200027fe4ffULL, 0x00000001622f7824ULL, 0x000fe200078e026dULL,
0x000000305c6e7810ULL, 0x000fe20007ffe0ffULL, 0x000000102e637824ULL, 0x000fe200078e025bULL,
0x000000385c5c7810ULL, 0x000fe20007ffe0ffULL, 0x000000802f2e7825ULL, 0x000fe200078e002cULL,
0x0000005a6c00720cULL, 0x000fc40003f86070ULL, 0x0000000050637faeULL, 0x0005e2000d101c46ULL,
0x000000016e577824ULL, 0x102fe200078e026dULL, 0x000064002e2e7a10ULL, 0x000fe20007fde0ffULL,
0x000000015c5d7824ULL, 0x000fe200078e026dULL, 0x00000000526b7faeULL, 0x0003e2000d901c46ULL,
0x0000005a6200720cULL, 0x080fe20003f66070ULL, 0x000000046c567824ULL, 0x000fe200078e00ffULL,
0x0000005a6e00720cULL, 0x0c0fe20003f46070ULL, 0x000000046e6e7824ULL, 0x000fe200078e00ffULL,
0x0000005a5c00720cULL, 0x000fe20003f26070ULL, 0x00000004625a7824ULL, 0x000fe200078e00ffULL,
0x000065002f2f7a10ULL, 0x000fe200037fe4ffULL, 0x0000008057507825ULL, 0x004fe200078e002cULL,
0xfffffffc56567812ULL, 0x000fc400078ee26fULL, 0xfffffffc5a5a7812ULL, 0x100fe200078ee26fULL,
0x000000046a527824ULL, 0x002fe200078e00ffULL, 0x0000640050507a10ULL, 0x000fe20007fde0ffULL,
0x000000045c627824ULL, 0x000fe200078e00ffULL, 0xfffffffc6e5c7812ULL, 0x000fe200078ee26fULL,
0x000000805d2c7825ULL, 0x000fe200078e002cULL, 0xfffffffc52527812ULL, 0x100fe400078ee26fULL,
0xfffffffc62627812ULL, 0x000fe200078ee26fULL, 0x0000001056577824ULL, 0x100fe200078e025bULL,
0x0000650051517a10ULL, 0x000fe200037fe4ffULL, 0x0000001052537824ULL, 0x100fe200078e025bULL,
0x000064002c2c7a10ULL, 0x000fe20007fde0ffULL, 0x000000105a5d7824ULL, 0x000fc400078e025bULL,
0x000000105c637824ULL, 0x100fe200078e025bULL, 0x000065002d2d7a10ULL, 0x000fe200037fe4ffULL,
0x00000010625b7824ULL, 0x000fe200078e025bULL, 0x0000000054537faeULL, 0x0003e8000e901c46ULL,
0x0000000058577faeULL, 0x0003e8000e101c46ULL, 0x000000002e5d7faeULL, 0x0003e8000d901c46ULL,
0x0000000050637faeULL, 0x0003e8000d101c46ULL, 0x000000002c5b7faeULL, 0x0003e2000c901c46ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x00000010182d7824ULL, 0x042fe200078e00ffULL,
0x0000001018507811ULL, 0x000fe200078ff0ffULL, 0x000000021a2f7824ULL, 0x000fe200078e0267ULL,
0x0000001818527811ULL, 0x000fe200078ff0ffULL, 0x000000ffff5b7224ULL, 0x000fe200078e00ffULL,
0x000000302d2d7812ULL, 0x000fe200078ec0ffULL, 0x0000000150517824ULL, 0x100fe200078e026dULL,
0x0000002018547811ULL, 0x000fe200078ff0ffULL, 0x0000000152537824ULL, 0x000fe200078e026dULL,
0x0000002818567811ULL, 0x000fe200078ff0ffULL, 0x000000402c5a7824ULL, 0x000fe200078e022dULL,
0x00000018182e7211ULL, 0x000fe200078fe8ffULL, 0x0000000154557824ULL, 0x100fe200078e026dULL,
0x00000008182c7811ULL, 0x000fe200078ff0ffULL, 0x0000000156577824ULL, 0x000fe200078e026dULL,
0x0000003018587811ULL, 0x000fe200078ff0ffULL, 0x0000000450507824ULL, 0x000fe200078e00ffULL,
0x0000003818627811ULL, 0x000fe200078ff0ffULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x000000032e2d7812ULL, 0x000fe200078ec0ffULL, 0x000000042c2e7824ULL, 0x000fe200078e00ffULL,
0x000020002f757811ULL, 0x000fe200078e60ffULL, 0x0000000454547824ULL, 0x000fe200078e00ffULL,
0xfffffffc50507812ULL, 0x100fe200078ee22dULL, 0x0000000456567824ULL, 0x000fe200078e00ffULL,
0xfffffffc2e2e7812ULL, 0x100fe200078ee22dULL, 0x00000004585c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc52527812ULL, 0x100fe200078ee22dULL, 0x00000004626a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc54547812ULL, 0x000fe200078ee22dULL, 0x000000012c2f7824ULL, 0x000fe200078e026dULL,
0xfffffffc56567812ULL, 0x000fe200078ee22dULL, 0x000000102e5d7824ULL, 0x000fe200078e0275ULL,
0xfffffffc5c5c7812ULL, 0x000fe200078ee22dULL, 0x0000001050637824ULL, 0x000fe200078e0275ULL,
0xfffffffc6a6a7812ULL, 0x000fe200078ee22dULL, 0x000000802f2e7825ULL, 0x000fe200078e005aULL,
0x0ffffffc2d2c7812ULL, 0x000fc400078ef818ULL, 0x0000006d182d7211ULL, 0x000fe200078ff0ffULL,
0x00000010526b7824ULL, 0x100fe200078e0275ULL, 0x000064002e2e7a10ULL, 0x000fe20007f5e0ffULL,
0x000000102c797824ULL, 0x000fe400078e0275ULL, 0x000000802d2c7825ULL, 0x000fe200078e005aULL,
0x000065002f2f7a10ULL, 0x000fc600017fe4ffULL, 0x0000008051507825ULL, 0x000fe200078e005aULL,
0x000064002c2c7a10ULL, 0x000fc60007f3e0ffULL, 0x0000000158597824ULL, 0x100fe200078e026dULL,
0x0000640050507a10ULL, 0x000fe20007f7e0ffULL, 0x0000000162737824ULL, 0x000fe200078e026dULL,
0x000065002d2d7a10ULL, 0x000fe20000ffe4ffULL, 0x0000008053527825ULL, 0x000fe200078e005aULL,
0x0000650051517a10ULL, 0x000fc60001ffe4ffULL, 0x00000010546d7824ULL, 0x100fe200078e0275ULL,
0x0000640052527a10ULL, 0x000fe20007f9e0ffULL, 0x00000010566f7824ULL, 0x000fe200078e0275ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c797faeULL, 0x0003e2000b901c46ULL,
0x0000008055547825ULL, 0x100fe200078e005aULL, 0x0000650053537a10ULL, 0x000fe400027fe4ffULL,
0x000000002e5d7faeULL, 0x0003e2000b901c46ULL, 0x0000008057567825ULL, 0x100fe200078e005aULL,
0x0000640054547a10ULL, 0x000fe40007f3e0ffULL, 0x0000000050637faeULL, 0x0003e2000b901c46ULL,
0x0000008059587825ULL, 0x000fe200078e005aULL, 0x0000640056567a10ULL, 0x000fc40007f5e0ffULL,
0x0000650055557a10ULL, 0x000fe20000ffe4ffULL, 0x00000080735a7825ULL, 0x000fe200078e005aULL,
0x0000640058587a10ULL, 0x000fe20007f7e0ffULL, 0x00000000526b7faeULL, 0x0003e2000b901c46ULL,
0x0000650057577a10ULL, 0x000fe200017fe4ffULL, 0x000000105c717824ULL, 0x100fe200078e0275ULL,
0x000064005a5a7a10ULL, 0x000fe20007f9e0ffULL, 0x000000106a757824ULL, 0x000fe200078e0275ULL,
0x0000650059597a10ULL, 0x000fe20001ffe4ffULL, 0x00000000546d7faeULL, 0x0003e2000b901c46ULL,
0x000065005b5b7a10ULL, 0x000fc600027fe4ffULL, 0x00000000566f7faeULL, 0x0003e8000b901c46ULL,
0x0000000058717faeULL, 0x0003e8000b901c46ULL, 0x000000005a757faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008776b7824ULL, 0x002fe400078e00ffULL, 0x000000ffffc67224ULL, 0x000fc400078e00ffULL,
0x00000010ff6c7424ULL, 0x000fe200078e00ffULL, 0x000000126b6d7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff6a7224ULL, 0x000fe200078e00ffULL, 0x000000026b6b7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff8182d7812ULL, 0x000fe200078ec0ffULL,
0x000000021a517824ULL, 0x020fe200078e0269ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000016a527810ULL, 0x000fe40007ffe0ffULL, 0x000000072d2d7812ULL, 0x000fe400078ef818ULL,
0x0000200051517811ULL, 0x000fc400078e60ffULL, 0x00000001ff2f7819ULL, 0x000fe2000001162dULL,
0x000000042d537824ULL, 0x000fc800078e00ffULL, 0x000000012f2c7824ULL, 0x040fe400078e026aULL,
0x000000012f2f7824ULL, 0x000fc600078e0252ULL, 0xfffffffc532c7812ULL, 0x000fe400078ee22cULL,
0x0000002018537810ULL, 0x000fc60007ffe0ffULL, 0x000000102c547824ULL, 0x000fe200078e0251ULL,
0xfffffff853537812ULL, 0x000fe200078ec0ffULL, 0x000000042d2c7824ULL, 0x000fc600078e00ffULL,
0x0000000753537812ULL, 0x000fe200078ef818ULL, 0x000000005454783bULL, 0x000e620000000200ULL,
0xfffffffc2c2c7812ULL, 0x000fe400078ee22fULL, 0x00000001ff5d7819ULL, 0x000fe20000011653ULL,
0x0000000453597824ULL, 0x000fe400078e00ffULL, 0x000000102c2c7824ULL, 0x000fe400078e0251ULL,
0x000000015d507824ULL, 0x040fe200078e026aULL, 0x000000026a6a7810ULL, 0x000fe20007ffe0ffULL,
0x000000015d527824ULL, 0x000fc400078e0252ULL, 0x000000002c2c783bULL, 0x000ea20000000200ULL,
0xfffffffc59507812ULL, 0x000fe200078ee250ULL, 0x0000000453537824ULL, 0x000fc800078e00ffULL,
0x0000001050507824ULL, 0x000fe200078e0251ULL, 0xfffffffc53527812ULL, 0x000fc800078ee252ULL,
0x000000005058783bULL, 0x000ee20000000200ULL, 0x0000001052527824ULL, 0x000fcc00078e0251ULL,
0x000000005250783bULL, 0x000f220000000200ULL, 0x0001000054d97824ULL, 0x042fe200078e00ffULL,
0x00000054008a7306ULL, 0x000fe20000009400ULL, 0x0001000055ec7824ULL, 0x040fe200078e00ffULL,
0x00000018ffdb7819ULL, 0x000fe20000011454ULL, 0x0000010055e97824ULL, 0x000fe200078e00ffULL,
0x00000018ffd97819ULL, 0x000fe200000114d9ULL, 0x0001000057d27824ULL, 0x040fe200078e00ffULL,
0x00000018ffec7819ULL, 0x000fe200000114ecULL, 0x0000010057d37824ULL, 0x000fe200078e00ffULL,
0x000000d900e17306ULL, 0x000fe20000209400ULL, 0x00000018ffca7819ULL, 0x000fe20000011457ULL,
0x0000010054d87824ULL, 0x000fe200078e00ffULL, 0x00000018ffe97819ULL, 0x000fe200000114e9ULL,
0x000100002cae7824ULL, 0x044fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe2000001142cULL,
0x000001002ca07824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe2000001142dULL,
0x000000d900f07306ULL, 0x0002a20000205400ULL, 0x000100002d9e7824ULL, 0x040fe200078e00ffULL,
0x00000018ffe07819ULL, 0x000fe20000011455ULL, 0x000001002d987824ULL, 0x000fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe2000001142eULL, 0x000100002e957824ULL, 0x040fe200078e00ffULL,
0x00000018ffd87819ULL, 0x000fe200000114d8ULL, 0x000001002e917824ULL, 0x000fe200078e00ffULL,
0x0000005400897306ULL, 0x000f220000005400ULL, 0x000000d900d97245ULL, 0x002fe2000020d400ULL,
0x0000010056e27824ULL, 0x000fe200078e00ffULL, 0x00000018ffd17819ULL, 0x000fc40000011456ULL,
0x00000018ffc57819ULL, 0x008fe40000011458ULL, 0x00000018ffe27819ULL, 0x000fe200000114e2ULL,
0x000000ec00d77306ULL, 0x000fe20000209400ULL, 0x000000f0e100720bULL, 0x004fe40003fbd000ULL,
0x00000018ffd27819ULL, 0x000fe400000114d2ULL, 0x00000018ffd37819ULL, 0x000fe400000114d3ULL,
0x00000018ffbb7819ULL, 0x000fe20000011459ULL, 0x000000ec00de7306ULL, 0x000e620000205400ULL,
0x000000898a00720bULL, 0x010fc40003f7d000ULL, 0x00000018ff717819ULL, 0x000fe4000001142fULL,
0x00000018ffb37819ULL, 0x000fe4000001145aULL, 0x00000001d9d95812ULL, 0x000fe200078efcffULL,
0x0000005500d47306ULL, 0x000fe20000009400ULL, 0x00000018ffad7819ULL, 0x000fe4000001145bULL,
0x00000018ffae7819ULL, 0x000fe400000114aeULL, 0x00000018ffa07819ULL, 0x000fc400000114a0ULL,
0x00000018ff917819ULL, 0x000fe20000011491ULL, 0x00000055008b7306ULL, 0x000ea20000005400ULL,
0x000000ded700720bULL, 0x002fe20003fbd000ULL, 0x0001000058d77824ULL, 0x000fe200078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe4000001149eULL, 0x00000018ff957819ULL, 0x000fe40000011495ULL,
0x00000018ffd77819ULL, 0x000fe200000114d7ULL, 0x000000db00927306ULL, 0x000fe20000209400ULL,
0x00000018ff817819ULL, 0x000fc40000011450ULL, 0x00000018ff987819ULL, 0x000fe40000011498ULL,
0x00000018ff847819ULL, 0x000fe40000011451ULL, 0x00000018ff877819ULL, 0x000fe20000011452ULL,
0x000000db009f7306ULL, 0x0002e20000205400ULL, 0x0000008bd400720bULL, 0x004fe40003f9d000ULL,
0x00000018ff8a7819ULL, 0x000fca0000011453ULL, 0x0000005700df7306ULL, 0x000fe20000009400ULL,
0x000000db00db7245ULL, 0x002fce000020d400ULL, 0x0000005700ea7306ULL, 0x000fe20000005400ULL,
0x0000009f9200720bULL, 0x008fce0003fdd000ULL, 0x0000005700b57306ULL, 0x0003ec000000d400ULL,
0x00000001dbdb6812ULL, 0x000fe400078efcffULL, 0x0000005400c87306ULL, 0x0004e2000000d400ULL,
0x0000000818577812ULL, 0x002fce00078ec0ffULL, 0x0000002c00e47306ULL, 0x000fe20000009400ULL,
0x0001000056547824ULL, 0x004fca00078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000002c00e77306ULL, 0x000fe20000005400ULL, 0x00000001c8c83812ULL, 0x008fce00078efcffULL,
0x0000002c007e7306ULL, 0x0003f0000000d400ULL, 0x0000002d00c47306ULL, 0x000fe20000009400ULL,
0x00000057182c7211ULL, 0x002fce00078fe0ffULL, 0x0000002d00c97306ULL, 0x000ff00000005400ULL,
0x0000002d007d7306ULL, 0x0003f0000000d400ULL, 0x000000e900b67306ULL, 0x000fe20000209400ULL,
0x00000007182d7812ULL, 0x002fca00078ec0ffULL, 0x000000012d2c7824ULL, 0x000fe400078e022cULL,
0x000000e900dd7306ULL, 0x000e620000205400ULL, 0x00000008772d7824ULL, 0x100fe400078e02c6ULL,
0x0000006d2c9f7210ULL, 0x040fe40007ffe0c6ULL, 0x000000012c2d7824ULL, 0x000fc600078e022dULL,
0x0000002e00b07306ULL, 0x000ff00000009400ULL, 0x0000002e00af7306ULL, 0x000fe20000005400ULL,
0x000000ddb600720bULL, 0x002fe20003f7d000ULL, 0x000001002fb67824ULL, 0x000fca00078e00ffULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x0000002e007a7306ULL, 0x0003f0000000d400ULL,
0x0000005400eb7306ULL, 0x000fe20000209400ULL, 0x00000007572e7812ULL, 0x002fe200078ef818ULL,
0x0000000877577824ULL, 0x000fc800078e026cULL, 0x000000102ed47824ULL, 0x000fe400078e00ffULL,
0x0000005400ee7306ULL, 0x000fe60000205400ULL, 0xfffffff0d42d7812ULL, 0x000fe200078ee22dULL,
0x0000010058d47824ULL, 0x000fc800078e00ffULL, 0x000000e000c77306ULL, 0x000fe20000209400ULL,
0x00000018ffd47819ULL, 0x000fce00000114d4ULL, 0x000000e000e87306ULL, 0x0002b00000205400ULL,
0x000000d800dc7306ULL, 0x000fe20000209400ULL, 0x000000e000e07245ULL, 0x002fce000020d400ULL,
0x000000d800a37306ULL, 0x0002e20000205400ULL, 0x000000e8c700720bULL, 0x004fe40003fdd000ULL,
0x000000e900c77245ULL, 0x000fc8000020d400ULL, 0x00000001c7c73812ULL, 0x000fe200078efcffULL,
0x0000005800cb7306ULL, 0x000fe20000009400ULL, 0x000000c9c400720bULL, 0x000fe40003f7d000ULL,
0x0000005400c97245ULL, 0x000fe4000020d400ULL, 0x000000d800d87245ULL, 0x002fe4000020d400ULL,
0x00000001e0e06812ULL, 0x000fe200078efcffULL, 0x0000005800cc7306ULL, 0x000e620000005400ULL,
0x000000a3dc00720bULL, 0x008fc40003f5d000ULL, 0x0000006b2ca37210ULL, 0x040fe20007ffe0c6ULL,
0x000000012c2c7824ULL, 0x000fe200078e0257ULL, 0x000000102ec67812ULL, 0x040fe200078efcffULL,
0x000000102e2e7824ULL, 0x000fe200078e00ffULL, 0x000000017d7d3812ULL, 0x000fe200078efcffULL,
0x0000005800627306ULL, 0x0005e4000000d400ULL, 0x00000010c6577824ULL, 0x000fe200078e00ffULL,
0xfffffff02ea37812ULL, 0x000fe200078ee2a3ULL, 0x00000010c6c67824ULL, 0x000fe400078e00ffULL,
0x00000001d8d82812ULL, 0x000fc400078efcffULL, 0x000000d100e57306ULL, 0x000fe20000209400ULL,
0x000000ec00587245ULL, 0x004fe4000020d400ULL, 0x000000eadf00720bULL, 0x000fe40003f5d000ULL,
0x0000000158585812ULL, 0x000fe400078efcffULL, 0x000000eeeb00720bULL, 0x000fe20003fbd000ULL,
0x000000d100e67306ULL, 0x0004e20000205400ULL, 0xfffffff0572c7812ULL, 0x000fe200078ee22cULL,
0x000000102d577824ULL, 0x000fe200078e00ffULL, 0xfffffff0c69f7812ULL, 0x000fe200078ee29fULL,
0x0001000059c67824ULL, 0x000fc400078e00ffULL, 0x000000102c2c7824ULL, 0x000fe400078e00ffULL,
0x00000056008d7306ULL, 0x000fe20000009400ULL, 0x000000d100d17245ULL, 0x004fe4000020d400ULL,
0x00000001b5b52812ULL, 0x000fe400078efcffULL, 0x00000001c9c95812ULL, 0x000fe400078efcffULL,
0x000000cccb00720bULL, 0x002fe20003f5d000ULL, 0x00000056008c7306ULL, 0x000e620000005400ULL,
0x000000e6e500720bULL, 0x008fc40003fbd000ULL, 0x00000018ffc67819ULL, 0x000fca00000114c6ULL,
0x0000005500bf7306ULL, 0x000ea8000000d400ULL, 0x0000000162622812ULL, 0x000fe400078efcffULL,
0x00000001d1d15812ULL, 0x000fe400078efcffULL, 0x0000005600bc7306ULL, 0x000ee2000000d400ULL,
0x0000008c8d00720bULL, 0x002fe20003f3d000ULL, 0x000100002f8d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001148dULL, 0x000000ca00cd7306ULL, 0x000fe20000209400ULL,
0x00000001bfbf4812ULL, 0x004fe400078efcffULL, 0x000000e7e400720bULL, 0x000fe40003f9d000ULL,
0x000000bf5858723eULL, 0x000fe400000010ffULL, 0x000000c600bf7245ULL, 0x000fe2000020d400ULL,
0x000000ca00ce7306ULL, 0x0002a20000205400ULL, 0x00000001bcbc1812ULL, 0x008fce00078efcffULL,
0x000000e200557306ULL, 0x000fe20000209400ULL, 0x000000ca00ca7245ULL, 0x002fe4000020d400ULL,
0x000000017e7e4812ULL, 0x000fca00078efcffULL, 0x000000e200567306ULL, 0x0002e20000205400ULL,
0x000000cecd00720bULL, 0x004fce0003fbd000ULL, 0x000000d200da7306ULL, 0x000fe20000209400ULL,
0x000000e200e27245ULL, 0x002fca000020d400ULL, 0x00000001caca5812ULL, 0x000fe400078efcffULL,
0x000000d200e37306ULL, 0x0002a20000205400ULL, 0x000000565500720bULL, 0x008fe40003fdd000ULL,
0x000000005754783bULL, 0x000eea0000000200ULL, 0x000000d300d57306ULL, 0x000fe20000209400ULL,
0x000000d200d27245ULL, 0x002fca000020d400ULL, 0x00000001e2e26812ULL, 0x000fe400078efcffULL,
0x000000d300d67306ULL, 0x0003220000205400ULL, 0x000000e3da00720bULL, 0x004fce0003f3d000ULL,
0x000000c500cf7306ULL, 0x000fe20000209400ULL, 0x000000d300d37245ULL, 0x002fca000020d400ULL,
0x00000001d2d21812ULL, 0x000fe400078efcffULL, 0x000000c500d07306ULL, 0x0002a20000205400ULL,
0x000000d6d500720bULL, 0x010fe20003fdd000ULL, 0x000001005bd67824ULL, 0x000fca00078e00ffULL,
0x00000018ffd67819ULL, 0x000fe200000114d6ULL, 0x0000005900c07306ULL, 0x000fe20000009400ULL,
0x000000c500c57245ULL, 0x002fca000020d400ULL, 0x00000001d3d36812ULL, 0x000fe400078efcffULL,
0x0000005900c17306ULL, 0x000e620000005400ULL, 0x000000d0cf00720bULL, 0x004fce0003fbd000ULL,
0x0000005900ac7306ULL, 0x00052c000000d400ULL, 0x00000001c5c55812ULL, 0x000fe400078efcffULL,
0x0000002f00ab7306ULL, 0x000fe20000009400ULL, 0x0000010059597824ULL, 0x004fe200078e00ffULL,
0x000000c1c000720bULL, 0x002fc80003f5d000ULL, 0x00000018ffc47819ULL, 0x000fe20000011459ULL,
0x000100005a597824ULL, 0x000fe200078e00ffULL, 0x0000002f00aa7306ULL, 0x000fe80000005400ULL,
0x00000018ffda7819ULL, 0x000fe20000011459ULL, 0x000100005b597824ULL, 0x000fe400078e00ffULL,
0x00000001acac2812ULL, 0x010fe200078efcffULL, 0x0000002f007c7306ULL, 0x0003f0000000d400ULL,
0x000000c400e47306ULL, 0x000fe20000209400ULL, 0x000000002c2c783bULL, 0x002e6e0000000200ULL,
0x000000c400e57306ULL, 0x0005300000205400ULL, 0x000000da00d57306ULL, 0x000fe20000209400ULL,
0x000000c400c47245ULL, 0x004fce000020d400ULL, 0x000000da00ce7306ULL, 0x0004620000205400ULL,
0x000000e5e400720bULL, 0x010fce0003fbd000ULL, 0x000000d700de7306ULL, 0x000fe20000209400ULL,
0x000000da00da7245ULL, 0x004fca000020d400ULL, 0x00000001c4c45812ULL, 0x000fe400078efcffULL,
0x000000d700e17306ULL, 0x0005220000205400ULL, 0x000000ced500720bULL, 0x002fce0003f5d000ULL,
0x0000005b00b97306ULL, 0x000fe20000009400ULL, 0x000000d700d77245ULL, 0x004fca000020d400ULL,
0x00000001dada2812ULL, 0x000fe400078efcffULL, 0x0000005b00ba7306ULL, 0x000e620000005400ULL,
0x000000e1de00720bULL, 0x010fce0003f3d000ULL, 0x0000005a00c27306ULL, 0x000fec0000009400ULL,
0x00000001d7d71812ULL, 0x000fe400078efcffULL, 0x0000005a00c37306ULL, 0x000fe20000005400ULL,
0x000000bab900720bULL, 0x002fe40003fbd000ULL, 0x00000062d762723eULL, 0x000fca00000010ffULL,
0x0000005a00a77306ULL, 0x0003f0000000d400ULL, 0x000000b300b77306ULL, 0x000fe20000209400ULL,
0x000001005a5a7824ULL, 0x002fca00078e00ffULL, 0x00000018ffcb7819ULL, 0x000fe4000001145aULL,
0x000000b300b87306ULL, 0x000e620000205400ULL, 0x000000c8d95a723eULL, 0x000fe400000010ffULL,
0x00000018ffc87819ULL, 0x000fe40000011459ULL, 0x000000c7e059723eULL, 0x000fc600000010ffULL,
0x000000c600df7306ULL, 0x000fe80000209400ULL, 0x000000585438723cULL, 0x088fe80000041838ULL,
0x000000c600e87306ULL, 0x0004e20000205400ULL, 0x000000b8b700720bULL, 0x002fe40003f5d000ULL,
0x000000b300b87245ULL, 0x000fe2000020d400ULL, 0x000000582c3c723cULL, 0x000be2000004183cULL,
0x000000c800b37245ULL, 0x000fc6000020d400ULL, 0x0000005b005c7306ULL, 0x000322000000d400ULL,
0xfffffff46cc67810ULL, 0x004fe40007ffe0ffULL, 0x000000b5d258723eULL, 0x020fe400000010ffULL,
0x000000d3ca59723eULL, 0x000fe400000010ffULL, 0x00000001b8b82812ULL, 0x000fe200078efcffULL,
0x000000d400dc7306ULL, 0x000fe20000209400ULL, 0x000000d8db5b723eULL, 0x002fe400000010ffULL,
0x000000e8df00720bULL, 0x008fe20003f3d000ULL, 0x000000585448723cULL, 0x000fe80000041848ULL,
0x000000d400dd7306ULL, 0x0002a20000205400ULL, 0x000000015c5c5812ULL, 0x010fc600078efcffULL,
0x0000005a5430723cULL, 0x080fe80000041830ULL, 0x000000d600b97306ULL, 0x000fe20000205400ULL,
0x00000001bfbf1812ULL, 0x000fe400078efcffULL, 0x000000d400d47245ULL, 0x002fe2000020d400ULL,
0x0000005a2c34723cULL, 0x000be80000041834ULL, 0x000000bb00bd7306ULL, 0x000fe20000209400ULL,
0x000000dddc00720bULL, 0x004fc40003fdd000ULL, 0x000000bcc95a723eULL, 0x020fe200000010ffULL,
0x000000582c4c723cULL, 0x000b62000004184cULL, 0x000000e2d15b723eULL, 0x000fc600000010ffULL,
0x000000d600bc7306ULL, 0x0002a60000209400ULL, 0x000000acbf58723eULL, 0x020fe200000010ffULL,
0x0000005a5440723cULL, 0x080fe40000041840ULL, 0x00000001d4d46812ULL, 0x000fe400078efcffULL,
0x000000bb00be7306ULL, 0x0007220000205400ULL, 0x000000d600d67245ULL, 0x002fe4000020d400ULL,
0x000000c3c200720bULL, 0x000fe20003fdd000ULL, 0x0000005a2c44723cULL, 0x000be80000041844ULL,
0x000000ae00b17306ULL, 0x000fe20000209400ULL, 0x000000b9bc00720bULL, 0x004fc40003f5d000ULL,
0x000000bb00bb7245ULL, 0x008fca000020d400ULL, 0x000000ae00b47306ULL, 0x0002a20000205400ULL,
0x000000bebd00720bULL, 0x010fe40003f3d000ULL, 0x00000001a7a76812ULL, 0x000fc600078efcffULL,
0x00000001d6d62812ULL, 0x000fe400078efcffULL, 0x000000cb00cc7306ULL, 0x000fe20000209400ULL,
0x000000aaab00720bULL, 0x000fe40003f5d000ULL, 0x000000ae00ab7245ULL, 0x000fe2000020d400ULL,
0x0001000052ae7824ULL, 0x002fe200078e00ffULL, 0x000000a7da5a723eULL, 0x020fe200000010ffULL,
0x0000010053a77824ULL, 0x000fe200078e00ffULL, 0x00000001bbbb1812ULL, 0x000fe200078efcffULL,
0x000000cb00cd7306ULL, 0x0002e20000205400ULL, 0x000000b4b100720bULL, 0x004fe20003fbd000ULL,
0x0001000053b47824ULL, 0x000fe200078e00ffULL, 0x000000c4bb59723eULL, 0x000fc400000010ffULL,
0x00000018ffae7819ULL, 0x000fe400000114aeULL, 0x000000017c7c2812ULL, 0x000fe200078efcffULL,
0x000000a000a87306ULL, 0x000fe20000209400ULL, 0x000000cb00cb7245ULL, 0x002fe2000020d400ULL,
0x000000582c0c723cULL, 0x080fe2000004180cULL, 0x00000018ffb47819ULL, 0x000fe400000114b4ULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x00000001abab5812ULL, 0x000fe200078efcffULL,
0x000000a000a97306ULL, 0x0002a20000205400ULL, 0x000000cdcc00720bULL, 0x008fe20003f3d000ULL,
0x000000585420723cULL, 0x000fe20000041820ULL, 0x0000007eab7e723eULL, 0x000fca00000010ffULL,
0x000000c800c07306ULL, 0x000fe20000209400ULL, 0x000000a000a07245ULL, 0x002fca000020d400ULL,
0x00000001cbcb1812ULL, 0x000fe400078efcffULL, 0x000000c800c17306ULL, 0x000e620000205400ULL,
0x000000a9a800720bULL, 0x004fe20003fbd000ULL, 0x0001000051a87824ULL, 0x000fe200078e00ffULL,
0x000000afb000720bULL, 0x000fe20003f3d000ULL, 0x0001000050b07824ULL, 0x000fe200078e00ffULL,
0x000000cbb85b723eULL, 0x000fe400000010ffULL, 0x00000018ffa87819ULL, 0x000fe200000114a8ULL,
0x0000008e009c7306ULL, 0x000fe20000209400ULL, 0x00000018ffb07819ULL, 0x000fc600000114b0ULL,
0x0000005a2c08723cULL, 0x080fe40000041808ULL, 0x00000001a0a05812ULL, 0x000fe400078efcffULL,
0x0000008e009d7306ULL, 0x0004e20000205400ULL, 0x000000c1c000720bULL, 0x002fe40003fdd000ULL,
0x000000017a7a1812ULL, 0x000fe200078efcffULL, 0x0000005a541c723cULL, 0x000fe8000004181cULL,
0x000000ad00637306ULL, 0x000fe20000209400ULL, 0x0000008e008e7245ULL, 0x004fca000020d400ULL,
0x00000001b3b36812ULL, 0x000fe400078efcffULL, 0x000000ad00b27306ULL, 0x0002a20000205400ULL,
0x0000009d9c00720bULL, 0x008fe40003fbd000ULL, 0x0000005cb35c723eULL, 0x000fe200000010ffULL,
0x0000010052b37824ULL, 0x000fc800078e00ffULL, 0x0000008d00927306ULL, 0x000fe20000209400ULL,
0x000000ad00ad7245ULL, 0x002fe4000020d400ULL, 0x00000018ffb37819ULL, 0x000fc600000114b3ULL,
0x000000018e8e5812ULL, 0x000fe400078efcffULL, 0x0000008d00b57306ULL, 0x0002e20000205400ULL,
0x000000b26300720bULL, 0x004fe40003fdd000ULL, 0x000000d4c563723eULL, 0x000fca00000010ffULL,
0x0000009100967306ULL, 0x000fe20000209400ULL, 0x0000008d008d7245ULL, 0x002fe2000020d400ULL,
0x000000622c10723cULL, 0x080f680000041810ULL, 0x00000001adad6812ULL, 0x000fe400078efcffULL,
0x0000009100977306ULL, 0x0002a20000205400ULL, 0x000000b59200720bULL, 0x008fe20003f3d000ULL,
0x000000625428723cULL, 0x000f6c0000041828ULL, 0x0000009e00a47306ULL, 0x000fe20000209400ULL,
0x0000009100917245ULL, 0x002fca000020d400ULL, 0x000000018d8d1812ULL, 0x000fe400078efcffULL,
0x0000009e00a57306ULL, 0x0002e20000205400ULL, 0x000000979600720bULL, 0x004fe40003fbd000ULL,
0x0000007c8d7c723eULL, 0x000fca00000010ffULL, 0x0000009b00a67306ULL, 0x000fe20000209400ULL,
0x0000009e009e7245ULL, 0x002fca000020d400ULL, 0x0000000191915812ULL, 0x000fe400078efcffULL,
0x0000009b005d7306ULL, 0x0002a20000205400ULL, 0x000000a5a400720bULL, 0x008fce0003f9d000ULL,
0x0000007100757306ULL, 0x000fe20000209400ULL, 0x0000009b009b7245ULL, 0x002fca000020d400ULL,
0x000000019e9e4812ULL, 0x000fe400078efcffULL, 0x0000007100747306ULL, 0x000e620000205400ULL,
0x0000005da600720bULL, 0x004fe40003fdd000ULL, 0x000000d6ad5d723eULL, 0x000fe200000010ffULL,
0x0000010051ad7824ULL, 0x000fe200078e00ffULL, 0x0000007d9e9e723eULL, 0x000fe400000010ffULL,
0x000000b6007d7245ULL, 0x000fe2000020d400ULL, 0x000000b600af7306ULL, 0x000fe20000209400ULL,
0x00000018ffad7819ULL, 0x000fe200000114adULL, 0x0000005c2c04723cULL, 0x000be80000041804ULL,
0x000000019b9b6812ULL, 0x000fc400078efcffULL, 0x000000b600b27306ULL, 0x000ea20000205400ULL,
0x000000747500720bULL, 0x002fe20003f3d000ULL, 0x0000005c5424723cULL, 0x000b640000041824ULL,
0x00000071002c7245ULL, 0x020fe4000020d400ULL, 0x000000a8002d7245ULL, 0x000fe4000020d400ULL,
0x000000ad00717245ULL, 0x000fe2000020d400ULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x000000109f547824ULL, 0x000fe200078e00ffULL, 0x00000098009f7245ULL, 0x000fc6000020d400ULL,
0x000000012c2c1812ULL, 0x000fe400078efcffULL, 0x000000005454783bULL, 0x000e620000000200ULL,
0x000000b000aa7306ULL, 0x0007220000205400ULL, 0x000000b2af00720bULL, 0x004fe40003fbd000ULL,
0x000000b300af7245ULL, 0x000fca000020d400ULL, 0x00000050008f7306ULL, 0x000fe20000009400ULL,
0x000000b000b07245ULL, 0x008fca000020d400ULL, 0x000000017d7d5812ULL, 0x000fe400078efcffULL,
0x0000005000907306ULL, 0x000fe20000005400ULL, 0x000000aab100720bULL, 0x010fe40003f5d000ULL,
0x0000007d2c7d723eULL, 0x000fe400000010ffULL, 0x00000081002c7245ULL, 0x000fc6000020d400ULL,
0x0000005000797306ULL, 0x0005ec000000d400ULL, 0x00000001b0b02812ULL, 0x000fe400078efcffULL,
0x0000009500997306ULL, 0x000fe20000209400ULL, 0x0000010050507824ULL, 0x004fca00078e00ffULL,
0x00000018ffa67819ULL, 0x000fe20000011450ULL, 0x00000010a3507824ULL, 0x000fe200078e00ffULL,
0x00000095009a7306ULL, 0x0004e20000205400ULL, 0x0000007c544c723cULL, 0x002b62000004184cULL,
0x000000a600b17245ULL, 0x000fcc000020d400ULL, 0x0000008100827306ULL, 0x000fe20000209400ULL,
0x0000009500957245ULL, 0x004fce000020d400ULL, 0x0000008100837306ULL, 0x000e620000205400ULL,
0x0000009a9900720bULL, 0x008fce0003f9d000ULL, 0x000000a600a97306ULL, 0x000fec0000209400ULL,
0x0000000195954812ULL, 0x000fe400078efcffULL, 0x000000a600ac7306ULL, 0x000ea20000205400ULL,
0x000000838200720bULL, 0x002fe40003f3d000ULL, 0x0000007a957a723eULL, 0x000fca00000010ffULL,
0x000000a800a47306ULL, 0x000fec0000209400ULL, 0x000000012c2c1812ULL, 0x000fe400078efcffULL,
0x000000a8009d7306ULL, 0x000e620000205400ULL, 0x000000aca900720bULL, 0x004fce0003fbd000ULL,
0x0000006e00937306ULL, 0x000fec0000209400ULL, 0x00000001b1b15812ULL, 0x000fe400078efcffULL,
0x0000006e00947306ULL, 0x0004e20000205400ULL, 0x0000009da400720bULL, 0x002fe40003f5d000ULL,
0x000000b12cb1723eULL, 0x000fc400000010ffULL, 0x00000087002c7245ULL, 0x000fc6000020d400ULL,
0x0000009800a17306ULL, 0x000fe20000209400ULL, 0x0000006e006e7245ULL, 0x004fca000020d400ULL,
0x000000012d2d2812ULL, 0x000fe400078efcffULL, 0x0000009800a27306ULL, 0x000e620000205400ULL,
0x000000949300720bULL, 0x008fce0003f7d000ULL, 0x00000051007f7306ULL, 0x000fec0000009400ULL,
0x000000016e6e3812ULL, 0x000fe400078efcffULL, 0x0000005100807306ULL, 0x000ea20000005400ULL,
0x000000a2a100720bULL, 0x002fce0003fdd000ULL, 0x0000008400857306ULL, 0x000fec0000209400ULL,
0x000000019f9f6812ULL, 0x000fe400078efcffULL, 0x0000008400867306ULL, 0x0002e20000205400ULL,
0x000000807f00720bULL, 0x004fe40003f9d000ULL, 0x000000908f00720bULL, 0x000fc40003fdd000ULL,
0x000000a09b7f723eULL, 0x000fe400000010ffULL, 0x0000009f8e9f723eULL, 0x000fe200000010ffULL,
0x000000ad00627306ULL, 0x000fe20000209400ULL, 0x0000008400847245ULL, 0x002fc6000020d400ULL,
0x0000007e5434723cULL, 0x040b680000041834ULL, 0x000000ad00597306ULL, 0x000e620000205400ULL,
0x000000868500720bULL, 0x008fe40003f3d000ULL, 0x0000000179796812ULL, 0x000fe200078efcffULL,
0x0000009e543c723cULL, 0x040b66000004183cULL, 0x00000079b0b0723eULL, 0x000fe200000010ffULL,
0x000000ae00587306ULL, 0x000fec0000209400ULL, 0x0000000184841812ULL, 0x000fe200078efcffULL,
0x000000b05410723cULL, 0x000b620000041810ULL, 0x000000ae002f7306ULL, 0x0004e20000205400ULL,
0x000000596200720bULL, 0x002fce0003fbd000ULL, 0x00000052006f7306ULL, 0x000fe20000009400ULL,
0x000000ae00ae7245ULL, 0x004fca000020d400ULL, 0x0000000171715812ULL, 0x000fe400078efcffULL,
0x0000005200767306ULL, 0x000e620000005400ULL, 0x0000002f5800720bULL, 0x008fe40003f5d000ULL,
0x000000718471723eULL, 0x000fca00000010ffULL, 0x0000005100707306ULL, 0x000eac000000d400ULL,
0x00000001aeae2812ULL, 0x000fe400078efcffULL, 0x0000008700887306ULL, 0x000fe20000209400ULL,
0x000000766f00720bULL, 0x002fce0003f7d000ULL, 0x0000008700897306ULL, 0x000e620000205400ULL,
0x0000000170704812ULL, 0x004fc800078efcffULL, 0x000000702d70723eULL, 0x000fe400000010ffULL,
0x000000b4002d7245ULL, 0x000fe2000020d400ULL, 0x000000b3002e7306ULL, 0x000fe80000209400ULL,
0x00000070540c723cULL, 0x000b68000004180cULL, 0x000000b3005b7306ULL, 0x000ea20000205400ULL,
0x000000898800720bULL, 0x002fce0003f9d000ULL, 0x0000005200737306ULL, 0x000e6c000000d400ULL,
0x000000012c2c4812ULL, 0x000fe400078efcffULL, 0x0000005300787306ULL, 0x000fe20000009400ULL,
0x0000005b2e00720bULL, 0x004fce0003f3d000ULL, 0x00000053007b7306ULL, 0x000ea20000005400ULL,
0x0000000173733812ULL, 0x002fc800078efcffULL, 0x00000073aeae723eULL, 0x000fe400000010ffULL,
0x00000001afaf1812ULL, 0x000fe200078efcffULL, 0x0000005300727306ULL, 0x0002e2000000d400ULL,
0x000000a700737245ULL, 0x000fe4000020d400ULL, 0x000000af2caf723eULL, 0x000fe400000010ffULL,
0x000000046c2c7810ULL, 0x000fc60007ffe0ffULL, 0x0000008a008b7306ULL, 0x000fe20000209400ULL,
0x000000005050783bULL, 0x002e620000000200ULL, 0x0000007b7800720bULL, 0x004fe20003fdd000ULL,
0x000000ae5408723cULL, 0x040b620000041808ULL, 0x000000182c00780cULL, 0x000fe20003f25270ULL,
0x000000ffff6c7224ULL, 0x000fe200078e002cULL, 0x000000916e7b723eULL, 0x000fe400000010ffULL,
0x0000008a008c7306ULL, 0x00052a0000205400ULL, 0x0000007a5444723cULL, 0x000b640000041844ULL,
0x0000000172726812ULL, 0x008fe200078efcffULL, 0x000000b4005a7306ULL, 0x000fe20000209400ULL,
0x0000008a008a7245ULL, 0x004fce000020d400ULL, 0x000000b4005d7306ULL, 0x000ea20000205400ULL,
0x0000008c8b00720bULL, 0x010fce0003fbd000ULL, 0x000000a700597306ULL, 0x000fec0000209400ULL,
0x000000018a8a5812ULL, 0x000fe400078efcffULL, 0x000000a700587306ULL, 0x000ee20000205400ULL,
0x0000005d5a00720bULL, 0x004fe20003f5d000ULL, 0x0000007e5030723cULL, 0x042b700000041830ULL,
0x0000009e5038723cULL, 0x000b680000041838ULL, 0x000000012d2d2812ULL, 0x000fc400078efcffULL,
0x000000585900720bULL, 0x008fe40003f7d000ULL, 0x000000722d72723eULL, 0x000fe200000010ffULL,
0x0000007c5048723cULL, 0x040b700000041848ULL, 0x0000007a5040723cULL, 0x000b640000041840ULL,
0x0000000173733812ULL, 0x000fc800078efcffULL, 0x000000738a73723eULL, 0x000fe400000010ffULL,
0x000000b05028723cULL, 0x040b700000041828ULL, 0x000000705020723cULL, 0x040b700000041820ULL,
0x000000ae501c723cULL, 0x040b70000004181cULL, 0x000000725024723cULL, 0x080b700000041824ULL,
0x000000725404723cULL, 0x000b620000041804ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffdee000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff697224ULL, 0x000fe200078e0067ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd24000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000001b432e7220ULL, 0x0a0fe20000410000ULL, 0x0000001b422d7220ULL, 0x080fe20000410000ULL,
0x0000001b21217220ULL, 0x080fe20000410000ULL, 0x0000001b24437220ULL, 0x080fe20000410000ULL,
0x0000001b31317220ULL, 0x080fe20000410000ULL, 0x0000001b38387220ULL, 0x080fe20000410000ULL,
0x0000001b39397220ULL, 0x080fe20000410000ULL, 0x0000001b3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001b40407220ULL, 0x080fe20000410000ULL, 0x0000001b41417220ULL, 0x080fe20000410000ULL,
0x0000001b48487220ULL, 0x080fe20000410000ULL, 0x0000001b28517220ULL, 0x080fe20000410000ULL,
0x0000001b23237220ULL, 0x080fe20000410000ULL, 0x0000001b25427220ULL, 0x080fe20000410000ULL,
0x0000001b34247220ULL, 0x080fe20000410000ULL, 0x0000001b32327220ULL, 0x080fe20000410000ULL,
0x0000001b33337220ULL, 0x080fe20000410000ULL, 0x0000001b3a2c7220ULL, 0x080fe20000410000ULL,
0x0000001b4a2f7220ULL, 0x080fe20000410000ULL, 0x0000001b29297220ULL, 0x080fe20000410000ULL,
0x0000001b2a2a7220ULL, 0x080fe20000410000ULL, 0x0000001b2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001b26267220ULL, 0x080fe20000410000ULL, 0x0000001b27277220ULL, 0x080fe20000410000ULL,
0x0000001b35257220ULL, 0x080fe20000410000ULL, 0x0000001b3c287220ULL, 0x080fe20000410000ULL,
0x0000001b30307220ULL, 0x080fe20000410000ULL, 0x0000001b4b527220ULL, 0x080fe20000410000ULL,
0x0000001b20207220ULL, 0x080fe20000410000ULL, 0x0000001b22227220ULL, 0x080fe20000410000ULL,
0x0000001b1c1c7220ULL, 0x080fe20000410000ULL, 0x0000001b1d1d7220ULL, 0x080fe20000410000ULL,
0x0000001b1e1e7220ULL, 0x080fe20000410000ULL, 0x0000001b1f1f7220ULL, 0x080fe20000410000ULL,
0x0000001b3d537220ULL, 0x080fe20000410000ULL, 0x0000001b44547220ULL, 0x080fe20000410000ULL,
0x0000001b45557220ULL, 0x080fe20000410000ULL, 0x0000001b465c7220ULL, 0x080fe20000410000ULL,
0x0000001b4c567220ULL, 0x080fe20000410000ULL, 0x0000001b4d577220ULL, 0x080fe20000410000ULL,
0x0000001b10107220ULL, 0x080fe20000410000ULL, 0x0000001b11117220ULL, 0x080fe20000410000ULL,
0x0000001b0c0c7220ULL, 0x080fe20000410000ULL, 0x0000001b0d0d7220ULL, 0x080fe20000410000ULL,
0x0000001b08087220ULL, 0x080fe20000410000ULL, 0x0000001b09097220ULL, 0x080fe20000410000ULL,
0x0000001b04047220ULL, 0x080fe20000410000ULL, 0x0000001b49507220ULL, 0x080fe20000410000ULL,
0x0000001b36587220ULL, 0x080fe20000410000ULL, 0x0000001b3f5b7220ULL, 0x080fe20000410000ULL,
0x0000001b4e627220ULL, 0x080fe20000410000ULL, 0x000000ffff467224ULL, 0x000fe200078e0021ULL,
0x0000001b37597220ULL, 0x080fe20000410000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e0031ULL,
0x0000001b3e5a7220ULL, 0x080fe20000410000ULL, 0x000000ffff4d7224ULL, 0x000fe200078e0038ULL,
0x0000001b475d7220ULL, 0x080fe20000410000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e0039ULL,
0x0000001b4f637220ULL, 0x080fe20000410000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e0040ULL,
0x0000001b12127220ULL, 0x080fe20000410000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e0041ULL,
0x0000001b13687220ULL, 0x080fe20000410000ULL, 0x000000ffff497224ULL, 0x000fe200078e0048ULL,
0x0000001b0e0e7220ULL, 0x080fe20000410000ULL, 0x000000ffff367224ULL, 0x000fe200078e003bULL,
0x0000001b0f0f7220ULL, 0x080fe20000410000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e0023ULL,
0x0000001b0a697220ULL, 0x080fe20000410000ULL, 0x000000ffff217224ULL, 0x000fe200078e0024ULL,
0x0000001b0b6a7220ULL, 0x080fe20000410000ULL, 0x000000ffff487224ULL, 0x000fe200078e0029ULL,
0x0000001b05057220ULL, 0x080fe20000410000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e0032ULL,
0x0000001b06067220ULL, 0x080fe20000410000ULL, 0x000000ffff387224ULL, 0x000fe200078e0033ULL,
0x0000001b07077220ULL, 0x000fe20000410000ULL, 0x000000ffff377224ULL, 0x000fc400078e002cULL,
0x000000ffff357224ULL, 0x000fe400078e002dULL, 0x000000ffff417224ULL, 0x000fe400078e002eULL,
0x000000ffff397224ULL, 0x000fe400078e002fULL, 0x000000ffff3b7224ULL, 0x000fe400078e002aULL,
0x000000ffff407224ULL, 0x000fe400078e002bULL, 0x000000ffff347224ULL, 0x000fc400078e0026ULL,
0x000000ffff317224ULL, 0x000fe400078e0027ULL, 0x000000ffff237224ULL, 0x000fe400078e0025ULL,
0x000000ffff247224ULL, 0x000fe400078e0028ULL, 0x000000ffff4f7224ULL, 0x000fe400078e0030ULL,
0x000000ffff477224ULL, 0x000fe400078e0020ULL, 0x000000ffff457224ULL, 0x000fc400078e001cULL,
0x000000ffff447224ULL, 0x000fe400078e001dULL, 0x000000ffff3c7224ULL, 0x000fe400078e0052ULL,
0x000000ffff3d7224ULL, 0x000fe400078e0022ULL, 0x000000ffff3e7224ULL, 0x000fe400078e001eULL,
0x000000ffff337224ULL, 0x000fe400078e001fULL, 0x000000ffff257224ULL, 0x000fc400078e0053ULL,
0x000000ffff267224ULL, 0x000fe400078e0054ULL, 0x000000ffff277224ULL, 0x000fe400078e0055ULL,
0x000000ffff287224ULL, 0x000fe400078e0056ULL, 0x000000ffff297224ULL, 0x000fe400078e0057ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0010ULL, 0x000000ffff2b7224ULL, 0x000fc400078e0011ULL,
0x000000ffff2c7224ULL, 0x000fe400078e000cULL, 0x000000ffff2d7224ULL, 0x000fe400078e000dULL,
0x000000ffff327224ULL, 0x000fe400078e0008ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000005e087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc400078e000eULL,
0x000000ffff0b7224ULL, 0x000fe400078e000fULL, 0x000000ffff307224ULL, 0x000fe400078e0005ULL,
0x000000ffff227224ULL, 0x000fe400078e0058ULL, 0x000000ffff207224ULL, 0x000fe400078e0059ULL,
0x000000ffff1e7224ULL, 0x000fe400078e005aULL, 0x000000ffff1f7224ULL, 0x000fc400078e005bULL,
0x000000ffff1d7224ULL, 0x000fe400078e005cULL, 0x000000ffff1c7224ULL, 0x000fe400078e005dULL,
0x000000ffff137224ULL, 0x000fe400078e0062ULL, 0x000000ffff117224ULL, 0x000fe400078e0063ULL,
0x000000ffff107224ULL, 0x000fe400078e0068ULL, 0x000000ffff0c7224ULL, 0x000fc400078e0069ULL,
0x000000ffff0d7224ULL, 0x000fe400078e006aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0006ULL,
0x000000ffff0f7224ULL, 0x000fc400078e0007ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x000004005e077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff527224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000105200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604537210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09005300780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c405300780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000005306067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000152527810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004005e077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000418097824ULL, 0x000fe200078e00ffULL, 0x000000146600720cULL, 0x000fc80003f06070ULL,
0xfffffff009057812ULL, 0x000fca00078ec0ffULL, 0x000000801a087824ULL, 0x000fca00078e0205ULL,
0x0124000008047984ULL, 0x0002a20000000c00ULL, 0x000021f000008947ULL, 0x000fea0003800000ULL,
0x00005a0000557b06ULL, 0x000ee20000209000ULL, 0x000000ffff527224ULL, 0x000fe200078e00ffULL,
0x0000001918547211ULL, 0x000fe400078ff0ffULL, 0x00005a00ff637a12ULL, 0x000fc800078e33ffULL,
0x0000005500557308ULL, 0x008ee40000001000ULL, 0x0ffffffe55577810ULL, 0x008fcc0007ffe0ffULL,
0x0000005700537305ULL, 0x000ee4000021f000ULL, 0x000000ffff597224ULL, 0x008fc800078e0a53ULL,
0x00005a0059597a24ULL, 0x000fc800078e02ffULL, 0x00000059535c7227ULL, 0x000fe200078e0052ULL,
0x0000000854527810ULL, 0x040fe40007ffe0ffULL, 0x0000001054537810ULL, 0x040fe40007ffe0ffULL,
0x0000001854597810ULL, 0x000fe20007ffe0ffULL, 0x000000525c587227ULL, 0x000fc800078e00ffULL,
0x000000545c567227ULL, 0x000fc800078e00ffULL, 0x000000ffff577224ULL, 0x000fe400078e0a58ULL,
0x000000ffff557224ULL, 0x000fe400078e0a56ULL, 0x000000535c5a7227ULL, 0x000fc800078e00ffULL,
0x00005a0057577a24ULL, 0x000fe400078e0252ULL, 0x00005a0055557a24ULL, 0x000fe400078e0254ULL,
0x000000ffff527224ULL, 0x000fe200078e0a5aULL, 0x00005a0057007a0cULL, 0x000fe20003fa6070ULL,
0x000000595c5c7227ULL, 0x000fe200078e00ffULL, 0x00005a0055007a0cULL, 0x000fc60003f06070ULL,
0x00005a0052547a24ULL, 0x000fe400078e0253ULL, 0x0000010066537824ULL, 0x000fe400078e0261ULL,
0x000000ffff627224ULL, 0x000fe200078e0a5cULL, 0x00005a0054007a0cULL, 0x000fe40003f26070ULL,
0x0000005316527217ULL, 0x000fe20007800000ULL, 0x00005a00625b7a24ULL, 0x000fe200078e0259ULL,
0x80005a0057575a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0055550a10ULL, 0x000fe20007ffe0ffULL,
0x0000000152527824ULL, 0x000fe200078e0a53ULL, 0x00005a005b007a0cULL, 0x000fe20003f66070ULL,
0x0000000218537824ULL, 0x000fe200078e00ffULL, 0x00005a0057007a0cULL, 0x000fc40003fc6070ULL,
0x00005a0055007a0cULL, 0x000fe40003f46070ULL, 0x0000000653537812ULL, 0x000fe400078ec0ffULL,
0x80005a0054541a10ULL, 0x000fe40007ffe0ffULL, 0x0000000158585810ULL, 0x000fe20007ffe0ffULL,
0x0000000164597824ULL, 0x000fe200078e0253ULL, 0x0000000156560810ULL, 0x000fe20007ffe0ffULL,
0x0000000153557824ULL, 0x000fe200078e025fULL, 0x00005a0054007a0cULL, 0x000fc40003f86070ULL,
0x000000525900720cULL, 0x000fe20003f06070ULL, 0x0000000155577824ULL, 0x100fe200078e0a52ULL,
0x80005a005b5b3a10ULL, 0x000fe20007ffe0ffULL, 0x0000000159597824ULL, 0x000fe200078e0a52ULL,
0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL, 0x0000000158586810ULL, 0x000fe40007ffe0ffULL,
0x0000000156562810ULL, 0x000fe40007ffe0ffULL, 0x0000005760687217ULL, 0x000fc40003800000ULL,
0x00005a005b007a0cULL, 0x000fe40003f46070ULL, 0x0000005663577207ULL, 0x040fe40006800000ULL,
0x0000005960597217ULL, 0x040fe40003800000ULL, 0x00000058635b7207ULL, 0x000fe40006800000ULL,
0x0000005760547217ULL, 0x000fe40003800000ULL, 0x00000004ff597819ULL, 0x000fc40000011659ULL,
0x000000015a5a1810ULL, 0x000fe20007ffe0ffULL, 0x0000005417857224ULL, 0x000fe200078e02ffULL,
0x0000005b60567217ULL, 0x000fe40003800000ULL, 0x000000525500720cULL, 0x000fe40003fc6070ULL,
0x000000015c5c3810ULL, 0x000fe20007ffe0ffULL, 0x0000005617897224ULL, 0x000fe200078e02ffULL,
0x000000ff59627207ULL, 0x000fe40000000000ULL, 0x000000015a5a4810ULL, 0x000fc40007ffe0ffULL,
0x000000ff68687207ULL, 0x000fe20003000000ULL, 0x00000001625d7824ULL, 0x000fe200078e0289ULL,
0x000000015c5c2810ULL, 0x000fe20007ffe0ffULL, 0x00000001855b7824ULL, 0x000fe200078e0262ULL,
0x0000005a63577207ULL, 0x000fe40006800000ULL, 0x0000008568597211ULL, 0x000fe200078fe0ffULL,
0x000000025b5a7825ULL, 0x100fe200078e0002ULL, 0x0000005c63637207ULL, 0x000fe40006800000ULL,
0x0000005760567217ULL, 0x040fe20003800000ULL, 0x000000025d5c7825ULL, 0x000fe200078e0002ULL,
0x000000065a547981ULL, 0x000722000c1e9500ULL, 0x00000063606a7217ULL, 0x000fc40003800000ULL,
0x0000000259587825ULL, 0x000fc800078e0002ULL, 0x00000056178b7224ULL, 0x000fe200078e02ffULL,
0x0000000658577981ULL, 0x000328000c1e9500ULL, 0x000000065c567981ULL, 0x000522000c1e9500ULL,
0x00000089686b7211ULL, 0x000fe200078fe0ffULL, 0x00000001626f7824ULL, 0x000fe200078e028bULL,
0x0000008b686d7211ULL, 0x000fe400078fe0ffULL, 0x00000010535d7812ULL, 0x004fe200078efcffULL,
0x0000006a178d7224ULL, 0x000fc800078e02ffULL, 0x0000000164777824ULL, 0x000fe400078e025dULL,
0x000000026b6a7825ULL, 0x000fc800078e0002ULL, 0x000000026f6e7825ULL, 0x100fe200078e0002ULL,
0x000000066a597981ULL, 0x0022a6000c1e9500ULL, 0x000000026d6c7825ULL, 0x000fe200078e0002ULL,
0x000000066e587981ULL, 0x0002a6000c1e9500ULL, 0x0000000177757824ULL, 0x000fe200078e0a52ULL,
0x000000066c5b7981ULL, 0x0086a2000c1e9500ULL, 0x000000015d637824ULL, 0x000fe200078e025fULL,
0x0000008d68717211ULL, 0x000fc400078fe0ffULL, 0x00000075605c7217ULL, 0x000fe20003800000ULL,
0x0000000163757824ULL, 0x000fe200078e0a52ULL, 0x000000527700720cULL, 0x080fe20003f26070ULL,
0x0000000162737824ULL, 0x000fe200078e028dULL, 0x00000004ff5c7819ULL, 0x000fe2000001165cULL,
0x0000000271707825ULL, 0x100fe200078e0002ULL, 0x000000526300720cULL, 0x000fe40003f06070ULL,
0x0000007560757217ULL, 0x000fe20003800000ULL, 0x0000000273727825ULL, 0x000fe200078e0002ULL,
0x000000ff5c6e7207ULL, 0x002fe20000800000ULL, 0x0000000670697981ULL, 0x0002a2000c1e9500ULL,
0x000000ff757a7207ULL, 0x000fc40000000000ULL, 0x0000002053797812ULL, 0x000fe200078efcffULL,
0x00000006725a7981ULL, 0x0002a2000c1e9500ULL, 0x000000857a6b7211ULL, 0x040fe200078fe0ffULL,
0x00000001856d7824ULL, 0x008fe200078e026eULL, 0x000000897a6f7211ULL, 0x000fe200078fe0ffULL,
0x000000016e717824ULL, 0x002fe400078e0289ULL, 0x0000000164817824ULL, 0x000fe400078e0279ULL,
0x0000000271707825ULL, 0x000fc800078e0002ULL, 0x000000026d6c7825ULL, 0x100fe200078e0002ULL,
0x0000000670627981ULL, 0x0002e6000c1e9500ULL, 0x000000026b6a7825ULL, 0x000fe200078e0002ULL,
0x000000066c5c7981ULL, 0x0002e6000c1e9500ULL, 0x000000016e757824ULL, 0x040fe400078e028bULL,
0x000000016e7f7824ULL, 0x000fe200078e028dULL, 0x000000066a6b7981ULL, 0x0002e2000c1e9500ULL,
0x000000026f6e7825ULL, 0x000fe200078e0002ULL, 0x0000008d7a7d7211ULL, 0x000fc600078fe0ffULL,
0x0000000181717824ULL, 0x102fe200078e0a52ULL, 0x000000066e6d7981ULL, 0x0002e2000c1e9500ULL,
0x00000001797b7824ULL, 0x000fe200078e025fULL, 0x0000008b7a737211ULL, 0x000fe400078fe0ffULL,
0x0000007160707217ULL, 0x000fe20003800000ULL, 0x000000017b717824ULL, 0x000fe400078e0a52ULL,
0x000000027d7c7825ULL, 0x000fe200078e0002ULL, 0x000000528100720cULL, 0x000fc60003f26070ULL,
0x0000000273727825ULL, 0x000fe200078e0002ULL, 0x000000527b00720cULL, 0x000fe20003f06070ULL,
0x000000067c7d7981ULL, 0x0002e2000c1e9500ULL, 0x00000004ff707819ULL, 0x000fe20000011670ULL,
0x0000000275747825ULL, 0x100fe200078e0002ULL, 0x0000007160717217ULL, 0x000fe20003800000ULL,
0x0000000672777981ULL, 0x0002e4000c1e9500ULL, 0x000000027f7e7825ULL, 0x000fe400078e0002ULL,
0x00000006746a7981ULL, 0x0002e4000c1e9500ULL, 0x000000ff717c7207ULL, 0x002fc40000000000ULL,
0x000000067e6c7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff70727207ULL, 0x000fe40000800000ULL,
0x000000897c737211ULL, 0x000fc600078fe0ffULL, 0x0000000172817824ULL, 0x000fe200078e0289ULL,
0x000000857c6f7211ULL, 0x000fe200078fe0ffULL, 0x0000000185717824ULL, 0x000fe400078e0272ULL,
0x0000000172757824ULL, 0x040fe400078e028bULL, 0x00000001728f7824ULL, 0x000fe400078e028dULL,
0x0000000281807825ULL, 0x000fc800078e0002ULL, 0x0000000273727825ULL, 0x100fe200078e0002ULL,
0x0000000680787981ULL, 0x0002e2000c1e9500ULL, 0x0000008d7c877211ULL, 0x040fe400078fe0ffULL,
0x000000026f6e7825ULL, 0x100fe200078e0002ULL, 0x0000000672cf7981ULL, 0x0002e2000c1e9500ULL,
0x0000003053b57812ULL, 0x000fe400078efcffULL, 0x0000000271707825ULL, 0x100fe200078e0002ULL,
0x0000008b7c7f7211ULL, 0x002fe200078fe0ffULL, 0x000000066e837981ULL, 0x0002e4000c1e9500ULL,
0x0000000275747825ULL, 0x000fc400078e0002ULL, 0x0000000670767981ULL, 0x0002e4000c1e9500ULL,
0x000000027f7e7825ULL, 0x100fe400078e0002ULL, 0x00000006748c7981ULL, 0x0002e4000c1e9500ULL,
0x00000002876e7825ULL, 0x002fe400078e0002ULL, 0x000000067ed37981ULL, 0x0002e4000c1e9500ULL,
0x0000000164877824ULL, 0x000fc400078e02b5ULL, 0x000000028f707825ULL, 0x000fe200078e0002ULL,
0x000000066ed77981ULL, 0x0002e6000c1e9500ULL, 0x0000000187817824ULL, 0x000fe200078e0a52ULL,
0x0000000670907981ULL, 0x0002e2000c1e9500ULL, 0x00000001b5b77824ULL, 0x000fc600078e025fULL,
0x0000008160807217ULL, 0x040fe20003800000ULL, 0x00000001b7817824ULL, 0x000fe200078e0a52ULL,
0x000000528700720cULL, 0x080fe40003f26070ULL, 0x00000052b700720cULL, 0x000fe40003f06070ULL,
0x00000004ff807819ULL, 0x000fe40000011680ULL, 0x0000008160817217ULL, 0x000fe40003800000ULL,
0x000000ff80847207ULL, 0x000fc40000800000ULL, 0x000000ff81827207ULL, 0x000fc60000000000ULL,
0x00000001857f7824ULL, 0x002fe200078e0284ULL, 0x0000008582817211ULL, 0x000fe200078fe0ffULL,
0x0000000184737824ULL, 0x000fe200078e028bULL, 0x0000008b82757211ULL, 0x000fe200078fe0ffULL,
0x000000027f7e7825ULL, 0x000fc800078e0002ULL, 0x0000000281807825ULL, 0x100fe200078e0002ULL,
0x000000067e867981ULL, 0x0002e6000c1e9500ULL, 0x0000000273727825ULL, 0x100fe200078e0002ULL,
0x0000000680b97981ULL, 0x0002e6000c1e9500ULL, 0x0000000275747825ULL, 0x000fe200078e0002ULL,
0x00000006728e7981ULL, 0x0002e2000c1e9500ULL, 0x0000008982717211ULL, 0x000fc600078fe0ffULL,
0x0000000674d57981ULL, 0x0002e2000c1e9500ULL, 0x00000001846f7824ULL, 0x000fe400078e0289ULL,
0x0000000271707825ULL, 0x000fc800078e0002ULL, 0x000000026f6e7825ULL, 0x000fe200078e0002ULL,
0x0000000670d17981ULL, 0x0002e4000c1e9500ULL, 0x0000008d827f7211ULL, 0x002fe400078fe0ffULL,
0x000000066e8a7981ULL, 0x0002e2000c1e9500ULL, 0x0000000184817824ULL, 0x000fe400078e028dULL,
0x000000027f7e7825ULL, 0x000fc800078e0002ULL, 0x0000000281807825ULL, 0x000fe200078e0002ULL,
0x000000067ed97981ULL, 0x0002e8000c1e9500ULL, 0x0000000680927981ULL, 0x0002e4000c1e9500ULL,
0xfffffff0686f7812ULL, 0x002fe200078ec0ffULL, 0x00000001ffcd7424ULL, 0x000fc800078e00ffULL,
0x0000000152687824ULL, 0x000fe200078e026fULL, 0xfffffff07a6f7812ULL, 0x000fc600078ec0ffULL,
0x00000001556e7824ULL, 0x000fe200078e0a68ULL, 0x0000000153857812ULL, 0x000fe200078efcffULL,
0x0000000152747824ULL, 0x000fc600078e026fULL, 0x0000006ecd6f7219ULL, 0x000fe200000006ffULL,
0x0000000185717824ULL, 0x000fe200078e025fULL, 0xfffffff07c737812ULL, 0x000fc600078ec0ffULL,
0x0000000171707824ULL, 0x100fe200078e0a68ULL, 0x0000000853877812ULL, 0x040fe200078efcffULL,
0x00000001527a7824ULL, 0x000fe200078e0273ULL, 0x0000000953897812ULL, 0x000fe400078efcffULL,
0x00000070cd737219ULL, 0x000fe200000006ffULL, 0x0000000187757824ULL, 0x100fe400078e025fULL,
0x0000000189817824ULL, 0x000fe200078e025fULL, 0xfffffff0827f7812ULL, 0x000fe200078ec0ffULL,
0x0000000175727824ULL, 0x000fc400078e0a68ULL, 0x0000000181687824ULL, 0x000fe200078e0a68ULL,
0x00000011538f7812ULL, 0x000fe200078efcffULL, 0x0000000152807824ULL, 0x000fe200078e027fULL,
0x00000072cd7f7219ULL, 0x040fe400000006ffULL, 0x00000068cd8b7219ULL, 0x000fe200000006ffULL,
0x000000018f917824ULL, 0x000fe400078e025fULL, 0x0000000163687824ULL, 0x100fe400078e0a74ULL,
0x00000001916e7824ULL, 0x000fe200078e0a74ULL, 0x0000541057547816ULL, 0x010fc80000000054ULL,
0x000000546fff7212ULL, 0x000fc800078ac0ffULL, 0x000000525500720cULL, 0x000fc80002fa1470ULL,
0x000000525300720cULL, 0x000fe40002fa1070ULL, 0x0000005473ff7212ULL, 0x000fe4000782c0ffULL,
0xff8000004f4f7808ULL, 0x000fe40002800000ULL, 0x000000527100720cULL, 0x000fe40000f21470ULL,
0x0000541059567816ULL, 0x004fc80000000056ULL, 0x000000566fff7212ULL, 0x080fe4000784c0ffULL,
0x000054105b587816ULL, 0x000fe40000000058ULL, 0x0000005673ff7212ULL, 0x000fe400078ac0ffULL,
0x000000586fff7212ULL, 0x000fe4000788c0ffULL, 0x000000525500720cULL, 0x0c0fe40001741470ULL,
0x000000525500720cULL, 0x000fc40002781470ULL, 0x000000527100720cULL, 0x080fe40002fa1470ULL,
0x000000525300720cULL, 0x0c0fe40001741070ULL, 0x000000525300720cULL, 0x080fe40002781070ULL,
0x000000528500720cULL, 0x0c0fe40000f21070ULL, 0x000000528500720cULL, 0x000fe40002fa1070ULL,
0x00005410695a7816ULL, 0x000fc4000000005aULL, 0xff8000003a3a7808ULL, 0x000fe40001000000ULL,
0xff80000021217808ULL, 0x000fe40002000000ULL, 0xff8000004e4e7808ULL, 0x000fe40000800000ULL,
0xff80000038387808ULL, 0x000fe40002800000ULL, 0x000000547fff7212ULL, 0x000fe4000786c0ffULL,
0x0000005a6fff7212ULL, 0x000fc4000780c0ffULL, 0x0000005873ff7212ULL, 0x040fe4000784c0ffULL,
0x0000005a73ff7212ULL, 0x000fe4000788c0ffULL, 0x000000568bff7212ULL, 0x000fe4000782c0ffULL,
0x000000587fff7212ULL, 0x000fe400078ac0ffULL, 0x000000525500720cULL, 0x080fe40000701470ULL,
0x000000527100720cULL, 0x000fc40001741470ULL, 0x000000527100720cULL, 0x080fe40002781470ULL,
0x000000527500720cULL, 0x0c0fe40001f61470ULL, 0x000000527500720cULL, 0x080fe40002fa1470ULL,
0x000000528100720cULL, 0x000fe40000f21470ULL, 0x0000001853957812ULL, 0x040fe400078efcffULL,
0x00000019539b7812ULL, 0x000fc400078efcffULL, 0x000000525300720cULL, 0x080fe40000701070ULL,
0x000000528500720cULL, 0x0c0fe40001741070ULL, 0x000000528500720cULL, 0x080fe40002781070ULL,
0x000000528700720cULL, 0x0c0fe40001f61070ULL, 0x000000528700720cULL, 0x080fe40002fa1070ULL,
0x000000528900720cULL, 0x000fc40000f21070ULL, 0x00000068cd8d7219ULL, 0x040fe400000006ffULL,
0x0000006ecd937219ULL, 0x000fe400000006ffULL, 0x000054106b5c7816ULL, 0x008fe4000000005cULL,
0x000054106d627816ULL, 0x000fe20000000062ULL, 0x0000000195977824ULL, 0x100fe200078e025fULL,
0xff80000022227808ULL, 0x000fe20000000000ULL, 0x000000019b9d7824ULL, 0x000fe200078e025fULL,
0xff80000023237808ULL, 0x000fc40001000000ULL, 0xff80000020207808ULL, 0x000fe40002000000ULL,
0xff8000004d4d7808ULL, 0x000fe40001800000ULL, 0xff80000024247808ULL, 0x000fe40002800000ULL,
0xff80000036367808ULL, 0x000fe40000800000ULL, 0x000000567fff7212ULL, 0x000fe4000780c0ffULL,
0x000000588bff7212ULL, 0x000fc4000784c0ffULL, 0x0000005a7fff7212ULL, 0x080fe4000788c0ffULL,
0x0000005a8bff7212ULL, 0x000fe4000786c0ffULL, 0x0000005c93ff7212ULL, 0x000fe400078ac0ffULL,
0x000000628dff7212ULL, 0x000fe2000782c0ffULL, 0x0000000197707824ULL, 0x100fe200078e0a74ULL,
0x000000527500720cULL, 0x080fe20000701470ULL, 0x000000019d747824ULL, 0x000fe200078e0a74ULL,
0x000000527500720cULL, 0x000fc40002781470ULL, 0x000000528100720cULL, 0x0c0fe40001741470ULL,
0x000000528100720cULL, 0x080fe40001f61470ULL, 0x000000526300720cULL, 0x080fe40000f21470ULL,
0x000000529100720cULL, 0x080fe40002fa1470ULL, 0x000000528700720cULL, 0x0c0fe40000701070ULL,
0x000000528700720cULL, 0x000fc40002781070ULL, 0x000000528900720cULL, 0x0c0fe40001741070ULL,
0x000000528900720cULL, 0x080fe40001f61070ULL, 0x000000525d00720cULL, 0x080fe40000f21070ULL,
0x000000528f00720cULL, 0x000fe40002fa1070ULL, 0x00000070cd997219ULL, 0x040fe400000006ffULL,
0x00000074cd9f7219ULL, 0x000fc400000006ffULL, 0x00005410776a7816ULL, 0x000fe4000000006aULL,
0x000054107d6c7816ULL, 0x000fe4000000006cULL, 0xff80000037377808ULL, 0x000fe40000000000ULL,
0xff8000001e1e7808ULL, 0x000fe40002000000ULL, 0xff80000025257808ULL, 0x000fe40001000000ULL,
0xff8000001f1f7808ULL, 0x000fc40001800000ULL, 0xff80000035357808ULL, 0x000fe40000800000ULL,
0xff8000004a4a7808ULL, 0x000fe40002800000ULL, 0x0000005c8dff7212ULL, 0x080fe4000780c0ffULL,
0x0000005c99ff7212ULL, 0x000fe4000788c0ffULL, 0x0000006a8dff7212ULL, 0x040fe4000784c0ffULL,
0x0000006c8dff7212ULL, 0x000fc4000786c0ffULL, 0x0000006a93ff7212ULL, 0x000fe4000782c0ffULL,
0x000000629fff7212ULL, 0x000fe200078ac0ffULL, 0x000000017b727824ULL, 0x000fe200078e0a7aULL,
0x000000526300720cULL, 0x0c0fe40000701470ULL, 0x000000526300720cULL, 0x0c0fe40001741470ULL,
0x000000526300720cULL, 0x080fe40001f61470ULL, 0x000000529100720cULL, 0x000fc40000f21470ULL,
0x000000529700720cULL, 0x080fe40002781470ULL, 0x000000529d00720cULL, 0x080fe40002fa1470ULL,
0x0000002153a37812ULL, 0x000fe400078efcffULL, 0x000000525d00720cULL, 0x0c0fe40000701070ULL,
0x000000525d00720cULL, 0x0c0fe40001741070ULL, 0x000000525d00720cULL, 0x000fc40001f61070ULL,
0x000000528f00720cULL, 0x080fe40000f21070ULL, 0x000000529500720cULL, 0x080fe40002781070ULL,
0x000000529b00720cULL, 0x000fe40002fa1070ULL, 0x00000072cda17219ULL, 0x000fe400000006ffULL,
0x00005410cf787816ULL, 0x000fe20000000078ULL, 0x00000001a3a57824ULL, 0x000fe200078e025fULL,
0xff8000004b4b7808ULL, 0x000fc40000000000ULL, 0xff80000026267808ULL, 0x000fe40001000000ULL,
0xff8000001d1d7808ULL, 0x000fe40001800000ULL, 0xff80000027277808ULL, 0x000fe40000800000ULL,
0xff80000049497808ULL, 0x000fe40002000000ULL, 0xff8000003c3c7808ULL, 0x000fe40002800000ULL,
0x0000006293ff7212ULL, 0x000fc4000780c0ffULL, 0x0000006c93ff7212ULL, 0x000fe4000784c0ffULL,
0x0000006299ff7212ULL, 0x000fe4000786c0ffULL, 0x0000006a9fff7212ULL, 0x040fe4000782c0ffULL,
0x0000006c9fff7212ULL, 0x000fe4000788c0ffULL, 0x00000078a1ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a57c7824ULL, 0x000fe200078e0a7aULL, 0x000000529100720cULL, 0x000fc40000701470ULL,
0x000000529100720cULL, 0x080fe40001741470ULL, 0x000000529700720cULL, 0x080fe40001f61470ULL,
0x000000529d00720cULL, 0x0c0fe40000f21470ULL, 0x000000529d00720cULL, 0x080fe40002781470ULL,
0x000000527b00720cULL, 0x000fe40002fa1470ULL, 0x0000002853a97812ULL, 0x000fc400078efcffULL,
0x0000002953af7812ULL, 0x000fe400078efcffULL, 0x000000528f00720cULL, 0x0c0fe40000701070ULL,
0x000000528f00720cULL, 0x080fe40001741070ULL, 0x000000529500720cULL, 0x080fe40001f61070ULL,
0x000000529b00720cULL, 0x0c0fe40000f21070ULL, 0x000000529b00720cULL, 0x000fc40002781070ULL,
0x000000527900720cULL, 0x000fe40002fa1070ULL, 0x0000007ccda77219ULL, 0x000fe400000006ffULL,
0x0000541083767816ULL, 0x000fe40000000076ULL, 0x00005410d38c7816ULL, 0x000fe4000000008cULL,
0x00005410d7907816ULL, 0x000fe20000000090ULL, 0x00000001a9ab7824ULL, 0x100fe200078e025fULL,
0xff80000041417808ULL, 0x000fe20000000000ULL, 0x00000001afb17824ULL, 0x000fe200078e025fULL,
0xff8000001c1c7808ULL, 0x000fc40001000000ULL, 0xff80000039397808ULL, 0x000fe40001800000ULL,
0xff80000029297808ULL, 0x000fe40000800000ULL, 0xff80000011117808ULL, 0x000fe40002000000ULL,
0xff8000003b3b7808ULL, 0x000fe40002800000ULL, 0x000000548bff7212ULL, 0x000fe400078cc0ffULL,
0x0000006a99ff7212ULL, 0x000fc4000780c0ffULL, 0x0000006c99ff7212ULL, 0x000fe4000784c0ffULL,
0x00000076a1ff7212ULL, 0x040fe4000786c0ffULL, 0x0000008ca1ff7212ULL, 0x040fe4000782c0ffULL,
0x00000090a1ff7212ULL, 0x000fe4000788c0ffULL, 0x0000008ca7ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001ab7e7824ULL, 0x100fe200078e0a7aULL, 0x000000528100720cULL, 0x080fe200037c1470ULL,
0x00000001b17a7824ULL, 0x000fe200078e0a7aULL, 0x000000529700720cULL, 0x000fc40000701470ULL,
0x000000529700720cULL, 0x080fe40001741470ULL, 0x000000527b00720cULL, 0x0c0fe40001f61470ULL,
0x000000527b00720cULL, 0x0c0fe40000f21470ULL, 0x000000527b00720cULL, 0x080fe40002781470ULL,
0x00000052a500720cULL, 0x080fe40002fa1470ULL, 0x000000528900720cULL, 0x000fc400037c1070ULL,
0x000000529500720cULL, 0x0c0fe40000701070ULL, 0x000000529500720cULL, 0x080fe40001741070ULL,
0x000000527900720cULL, 0x0c0fe40001f61070ULL, 0x000000527900720cULL, 0x0c0fe40000f21070ULL,
0x000000527900720cULL, 0x080fe40002781070ULL, 0x00000052a300720cULL, 0x000fc40002fa1070ULL,
0x0000007ecdad7219ULL, 0x040fe400000006ffULL, 0x0000007acdb37219ULL, 0x000fe400000006ffULL,
0xff8000004c4c7808ULL, 0x000fe40003000000ULL, 0xff80000028287808ULL, 0x000fe40000000000ULL,
0xff80000013137808ULL, 0x000fe40001000000ULL, 0xff80000051517808ULL, 0x000fc40001800000ULL,
0xff8000002a2a7808ULL, 0x000fe40000800000ULL, 0xff80000012127808ULL, 0x000fe40002000000ULL,
0xff8000002b2b7808ULL, 0x000fe40002800000ULL, 0x0000005c9fff7212ULL, 0x000fe400078cc0ffULL,
0x00000076a7ff7212ULL, 0x080fe4000780c0ffULL, 0x00000076adff7212ULL, 0x000fc4000784c0ffULL,
0x00000078a7ff7212ULL, 0x040fe4000786c0ffULL, 0x00000090a7ff7212ULL, 0x000fe4000782c0ffULL,
0x00000078adff7212ULL, 0x000fe4000788c0ffULL, 0x0000008cb3ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b7827824ULL, 0x000fe200078e0a80ULL, 0x000000529d00720cULL, 0x080fe400037c1470ULL,
0x00000052a500720cULL, 0x000fc40000701470ULL, 0x00000052a500720cULL, 0x0c0fe40001f61470ULL,
0x00000052a500720cULL, 0x080fe40000f21470ULL, 0x00000052ab00720cULL, 0x0c0fe40001741470ULL,
0x00000052ab00720cULL, 0x080fe40002781470ULL, 0x00000052b100720cULL, 0x000fe40002fa1470ULL,
0x0000003153bd7812ULL, 0x000fc400078efcffULL, 0x0000003853c37812ULL, 0x040fe400078efcffULL,
0x0000003953c97812ULL, 0x000fe400078efcffULL, 0x000000529b00720cULL, 0x080fe400037c1070ULL,
0x00000052a300720cULL, 0x0c0fe40000701070ULL, 0x00000052a300720cULL, 0x0c0fe40001f61070ULL,
0x00000052a300720cULL, 0x000fc40000f21070ULL, 0x00000052a900720cULL, 0x0c0fe40001741070ULL,
0x00000052a900720cULL, 0x080fe40002781070ULL, 0x00000052af00720cULL, 0x000fe40002fa1070ULL,
0x00000082cdbb7219ULL, 0x000fe400000006ffULL, 0x00005410b9867816ULL, 0x000fe40000000086ULL,
0x00005410d58e7816ULL, 0x000fe2000000008eULL, 0x00000001bdbf7824ULL, 0x100fe200078e025fULL,
0xff80000050507808ULL, 0x000fe20003000000ULL, 0x00000001c3c57824ULL, 0x100fe200078e025fULL,
0xff80000048487808ULL, 0x000fe20000000000ULL, 0x00000001c9cb7824ULL, 0x000fe200078e025fULL,
0xff80000040407808ULL, 0x000fc40001800000ULL, 0xff80000010107808ULL, 0x000fe40000800000ULL,
0xff80000047477808ULL, 0x000fe40001000000ULL, 0xff8000003d3d7808ULL, 0x000fe40002000000ULL,
0xff8000002d2d7808ULL, 0x000fe40002800000ULL, 0x00000076b3ff7212ULL, 0x040fe400078cc0ffULL,
0x00000078b3ff7212ULL, 0x000fc4000780c0ffULL, 0x0000008cadff7212ULL, 0x040fe4000786c0ffULL,
0x00000090adff7212ULL, 0x080fe4000782c0ffULL, 0x00000090b3ff7212ULL, 0x000fe4000784c0ffULL,
0x00000086bbff7212ULL, 0x040fe4000788c0ffULL, 0x0000008ebbff7212ULL, 0x000fe200078ac0ffULL,
0x00000001bf847824ULL, 0x100fe200078e0a80ULL, 0x00000052ab00720cULL, 0x080fe20001f61470ULL,
0x00000001c5887824ULL, 0x100fe200078e0a80ULL, 0x00000052ab00720cULL, 0x080fe20000f21470ULL,
0x00000001cb807824ULL, 0x000fe200078e0a80ULL, 0x00000052b100720cULL, 0x000fc400037c1470ULL,
0x00000052b100720cULL, 0x0c0fe40000701470ULL, 0x00000052b100720cULL, 0x080fe40001741470ULL,
0x00000052b700720cULL, 0x0c0fe40002781470ULL, 0x00000052b700720cULL, 0x000fe40002fa1470ULL,
0x00000084cdc17219ULL, 0x040fe400000006ffULL, 0x00000088cdc77219ULL, 0x000fc400000006ffULL,
0x00000052a900720cULL, 0x0c0fe40001f61070ULL, 0x00000052a900720cULL, 0x080fe40000f21070ULL,
0x00000052af00720cULL, 0x0c0fe400037c1070ULL, 0x00000052af00720cULL, 0x0c0fe40000701070ULL,
0x00000052af00720cULL, 0x080fe40001741070ULL, 0x00000052b500720cULL, 0x000fc40002781070ULL,
0x00000052b500720cULL, 0x000fe40002fa1070ULL, 0x00000080cdcd7219ULL, 0x000fe400000006ffULL,
0x00005410d18a7816ULL, 0x000fe4000000008aULL, 0xff8000002c2c7808ULL, 0x000fe40001800000ULL,
0xff8000000a0a7808ULL, 0x000fe40000800000ULL, 0xff80000046467808ULL, 0x000fc40003000000ULL,
0xff8000003f3f7808ULL, 0x000fe40000000000ULL, 0xff8000000b0b7808ULL, 0x000fe40001000000ULL,
0xff80000045457808ULL, 0x000fe40002000000ULL, 0xff80000032327808ULL, 0x000fe40002800000ULL,
0x00000086c1ff7212ULL, 0x080fe4000786c0ffULL, 0x00000086c7ff7212ULL, 0x000fc4000782c0ffULL,
0x00000086cdff7212ULL, 0x000fe400078cc0ffULL, 0x0000008abbff7212ULL, 0x080fe4000780c0ffULL,
0x0000008ac1ff7212ULL, 0x080fe4000784c0ffULL, 0x0000008ac7ff7212ULL, 0x000fe4000788c0ffULL,
0x0000008ec1ff7212ULL, 0x000fe400078ac0ffULL, 0x00000052b700720cULL, 0x000fc40000701470ULL,
0x00000052bf00720cULL, 0x0c0fe40001f61470ULL, 0x00000052bf00720cULL, 0x0c0fe40001741470ULL,
0x00000052bf00720cULL, 0x080fe40002fa1470ULL, 0x00000052c500720cULL, 0x080fe40000f21470ULL,
0x00000052cb00720cULL, 0x080fe400037c1470ULL, 0x00000052c500720cULL, 0x000fc40002781470ULL,
0x00000052b500720cULL, 0x080fe40000701070ULL, 0x00000052bd00720cULL, 0x0c0fe40001f61070ULL,
0x00000052bd00720cULL, 0x0c0fe40001741070ULL, 0x00000052bd00720cULL, 0x080fe40002fa1070ULL,
0x00000052c300720cULL, 0x080fe40000f21070ULL, 0x00000052c900720cULL, 0x000fc400037c1070ULL,
0x00000052c300720cULL, 0x000fe40002781070ULL, 0x00005410d9927816ULL, 0x000fe40000000092ULL,
0xff8000003e3e7808ULL, 0x000fe40000000000ULL, 0xff80000044447808ULL, 0x000fe40001800000ULL,
0xff80000033337808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fc40002800000ULL,
0xff80000043437808ULL, 0x000fe40000800000ULL, 0xff80000042427808ULL, 0x000fe40003000000ULL,
0xff80000034347808ULL, 0x000fe40002000000ULL, 0x0000008acdff7212ULL, 0x000fe4000780c0ffULL,
0x0000008ec7ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008ecdff7212ULL, 0x000fc4000784c0ffULL,
0x00000092bbff7212ULL, 0x080fe400078ac0ffULL, 0x00000092c1ff7212ULL, 0x080fe4000782c0ffULL,
0x00000092c7ff7212ULL, 0x080fe400078cc0ffULL, 0x00000092cdff7212ULL, 0x000fe4000788c0ffULL,
0x00000052b700720cULL, 0x080fe40002fa1470ULL, 0x00000052bf00720cULL, 0x000fc40000f21470ULL,
0x00000052c500720cULL, 0x0c0fe40001f61470ULL, 0x00000052c500720cULL, 0x080fe400037c1470ULL,
0x00000052cb00720cULL, 0x0c0fe40000701470ULL, 0x00000052cb00720cULL, 0x0c0fe40001741470ULL,
0x00000052cb00720cULL, 0x080fe40002781470ULL, 0x00000052b500720cULL, 0x000fc40002fa1070ULL,
0x00000052bd00720cULL, 0x080fe40000f21070ULL, 0x00000052c900720cULL, 0x080fe40000701070ULL,
0x00000052c300720cULL, 0x0c0fe40001f61070ULL, 0x00000052c300720cULL, 0x080fe400037c1070ULL,
0x00000052c900720cULL, 0x0c0fe40001741070ULL, 0x00000052c900720cULL, 0x000fc40002781070ULL,
0xff80000031317808ULL, 0x000fe40000000000ULL, 0xff8000002f2f7808ULL, 0x000fe40001800000ULL,
0xff80000030307808ULL, 0x000fe40001000000ULL, 0xff8000000c0c7808ULL, 0x000fe40002800000ULL,
0xff8000000d0d7808ULL, 0x000fe40000800000ULL, 0xff8000000e0e7808ULL, 0x000fc40003000000ULL,
0xff8000000f0f7808ULL, 0x000fc40002000000ULL, 0x0000004f0400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff5a7424ULL, 0x000fe200078e00ffULL, 0x0000003a0500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff5b7424ULL, 0x000fe200078e00ffULL, 0x000000210600720bULL, 0x000fe40003f5e000ULL,
0x000000220700720bULL, 0x000fe40003f7e000ULL, 0x000000044f537208ULL, 0x000fe40004000000ULL,
0x000000053a057208ULL, 0x000fc40004800000ULL, 0x0000000621067208ULL, 0x000fe40005000000ULL,
0x0000000722077208ULL, 0x000fe40005800000ULL, 0x0000004e5300720bULL, 0x000fe40003f1e000ULL,
0x000000380500720bULL, 0x000fe40003f3e000ULL, 0x000000230600720bULL, 0x000fe40003f5e000ULL,
0x000000200700720bULL, 0x000fc40003f7e000ULL, 0x000000534e047208ULL, 0x000fe40004000000ULL,
0x0000000538527208ULL, 0x000fe40004800000ULL, 0x0000000623057208ULL, 0x000fe40005000000ULL,
0x0000000720077208ULL, 0x000fe40005800000ULL, 0x0000004d0400720bULL, 0x000fe40003f1e000ULL,
0x000000375200720bULL, 0x000fc40003f3e000ULL, 0x000000240500720bULL, 0x000fe40003f5e000ULL,
0x0000001e0700720bULL, 0x000fe40003f7e000ULL, 0x000000044d537208ULL, 0x000fe40004000000ULL,
0x0000005237557208ULL, 0x000fe40004800000ULL, 0x0000000524047208ULL, 0x000fe40005000000ULL,
0x000000071e067208ULL, 0x000fc40005800000ULL, 0x0000004c5300720bULL, 0x000fe40003f1e000ULL,
0x000000365500720bULL, 0x000fe40003f3e000ULL, 0x000000250400720bULL, 0x000fe40003f5e000ULL,
0x0000001f0600720bULL, 0x000fe40003f7e000ULL, 0x000000534c527208ULL, 0x000fe40004000000ULL,
0x0000005536547208ULL, 0x000fc40004800000ULL, 0x0000000425057208ULL, 0x000fe40005000000ULL,
0x000000061f067208ULL, 0x000fe40005800000ULL, 0x0000004b5200720bULL, 0x000fe40003f1e000ULL,
0x000000355400720bULL, 0x000fe40003f3e000ULL, 0x000000260500720bULL, 0x000fe40003f5e000ULL,
0x0000001d0600720bULL, 0x000fc40003f7e000ULL, 0x000000524b077208ULL, 0x000fe40004000000ULL,
0x0000005435547208ULL, 0x000fe40004800000ULL, 0x0000000526047208ULL, 0x000fe40005000000ULL,
0x000000061d057208ULL, 0x000fe40005800000ULL, 0x0000004a0700720bULL, 0x000fe40003f1e000ULL,
0x000000415400720bULL, 0x000fc40003f3e000ULL, 0x000000270400720bULL, 0x000fe40003f5e000ULL,
0x0000001c0500720bULL, 0x000fe40003f7e000ULL, 0x000000074a067208ULL, 0x000fe40004000000ULL,
0x0000005441547208ULL, 0x000fe40004800000ULL, 0x0000000427077208ULL, 0x000fe40005000000ULL,
0x000000051c047208ULL, 0x000fc40005800000ULL, 0x000000490600720bULL, 0x000fe40003f1e000ULL,
0x000000395400720bULL, 0x000fe40003f3e000ULL, 0x000000280700720bULL, 0x000fe40003f5e000ULL,
0x000000130400720bULL, 0x000fe40003f7e000ULL, 0x0000000649057208ULL, 0x000fe40004000000ULL,
0x0000005439537208ULL, 0x000fc40004800000ULL, 0x0000000728067208ULL, 0x000fe40005000000ULL,
0x0000000413047208ULL, 0x000fe40005800000ULL, 0x000000500500720bULL, 0x000fe40003f1e000ULL,
0x0000003c5300720bULL, 0x000fe40003f3e000ULL, 0x000000290600720bULL, 0x000fe40003f5e000ULL,
0x000000110400720bULL, 0x000fc40003f7e000ULL, 0x0000000550527208ULL, 0x000fe40004000000ULL,
0x000000533c547208ULL, 0x000fe40004800000ULL, 0x0000000629057208ULL, 0x000fe40005000000ULL,
0x0000000411077208ULL, 0x000fe40005800000ULL, 0x0000003b5400720bULL, 0x000fe40003f3e000ULL,
0x000000515200720bULL, 0x000fc40003f1e000ULL, 0x0000002a0500720bULL, 0x000fe40003f5e000ULL,
0x000000120700720bULL, 0x000fe40003f7e000ULL, 0x000000543b557208ULL, 0x000fe40004800000ULL,
0x0000005251537208ULL, 0x000fe40004000000ULL, 0x000000052a047208ULL, 0x000fe40005000000ULL,
0x0000000712077208ULL, 0x000fc40005800000ULL, 0x000000405500720bULL, 0x000fe40003f3e000ULL,
0x000000485300720bULL, 0x000fe40003f1e000ULL, 0x0000002b0400720bULL, 0x000fe40003f5e000ULL,
0x000000100700720bULL, 0x000fe40003f7e000ULL, 0x0000005540527208ULL, 0x000fe40004800000ULL,
0x0000005348067208ULL, 0x000fc40004000000ULL, 0x000000042b057208ULL, 0x000fe40005000000ULL,
0x0000000710077208ULL, 0x000fe40005800000ULL, 0x0000003d5200720bULL, 0x000fe40003f3e000ULL,
0x000000470600720bULL, 0x000fe40003f1e000ULL, 0x0000002c0500720bULL, 0x000fe40003f5e000ULL,
0x0000000a0700720bULL, 0x000fc40003f7e000ULL, 0x000000523d527208ULL, 0x000fe40004800000ULL,
0x0000000647537208ULL, 0x000fe40004000000ULL, 0x000000052c047208ULL, 0x000fe40005000000ULL,
0x000000070a067208ULL, 0x000fe40005800000ULL, 0x0000003f5200720bULL, 0x000fe40003f3e000ULL,
0x000000465300720bULL, 0x000fc40003f1e000ULL, 0x0000002d0400720bULL, 0x000fe40003f5e000ULL,
0x0000000b0600720bULL, 0x000fe40003f7e000ULL, 0x000000523f057208ULL, 0x000fe40004800000ULL,
0x0000005346547208ULL, 0x000fe40004000000ULL, 0x000000042d077208ULL, 0x000fe40005000000ULL,
0x000000060b537208ULL, 0x000fc40005800000ULL, 0x0000003e0500720bULL, 0x000fe40003f3e000ULL,
0x000000320700720bULL, 0x000fe40003f5e000ULL, 0x000000455400720bULL, 0x000fe40003f1e000ULL,
0x0000000c5300720bULL, 0x000fe40003f7e000ULL, 0x000000053e047208ULL, 0x000fe40004800000ULL,
0x0000000732077208ULL, 0x000fc40005000000ULL, 0x0000005445557208ULL, 0x000fe40004000000ULL,
0x000000530c067208ULL, 0x000fe40005800000ULL, 0x000000330400720bULL, 0x000fe40003f3e000ULL,
0x0000002e0700720bULL, 0x000fe40003f5e000ULL, 0x000000445500720bULL, 0x000fe40003f1e000ULL,
0x0000000d0600720bULL, 0x000fc40003f7e000ULL, 0x0000000433057208ULL, 0x000fe40004800000ULL,
0x000000072e047208ULL, 0x000fe40005000000ULL, 0x0000005544527208ULL, 0x000fe40004000000ULL,
0x000000060d077208ULL, 0x000fe40005800000ULL, 0x000000340500720bULL, 0x000fe40003f3e000ULL,
0x0000002f0400720bULL, 0x000fc40003f5e000ULL, 0x000000435200720bULL, 0x000fe40003f1e000ULL,
0x0000000e0700720bULL, 0x000fe40003f7e000ULL, 0x0000000534067208ULL, 0x000fe40004800000ULL,
0x000000042f057208ULL, 0x000fe40005000000ULL, 0x0000005243537208ULL, 0x000fe40004000000ULL,
0x000000070e047208ULL, 0x000fc40005800000ULL, 0x000000425300720bULL, 0x000fe40003f1e000ULL,
0x000000310600720bULL, 0x000fe40003f3e000ULL, 0x000000300500720bULL, 0x000fe40003f5e000ULL,
0x0000000f0400720bULL, 0x000fe40003f7e000ULL, 0x0000005342077208ULL, 0x000fe40004000000ULL,
0x0000000631547208ULL, 0x000fc40004800000ULL, 0x0000000530587208ULL, 0x000fe40005000000ULL,
0x000000040f577208ULL, 0x000fe20005800000ULL, 0x00001ed27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x0000000704597208ULL, 0x000fe20004000000ULL, 0x00001ee27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0054047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0058057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0057067f89ULL, 0x000e6200000e0000ULL, 0x000000045400720bULL, 0x008fc40003f1e000ULL,
0x000000055800720bULL, 0x010fe40003f3e000ULL, 0x0000005404077208ULL, 0x006fe40004000000ULL,
0x0000005805527208ULL, 0x000fe20004800000ULL, 0x0c201f0059047f89ULL, 0x000e6200000e0000ULL,
0x000000065700720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007567f89ULL, 0x000ea200000e0000ULL,
0x0000005706547208ULL, 0x000fc60004000000ULL, 0x0c201f0052537f89ULL, 0x000ee800000e0000ULL,
0x0c201f0054557f89ULL, 0x0002e400000e0000ULL, 0x000000045900720bULL, 0x002fe40003f1e000ULL,
0x000000560700720bULL, 0x004fe40003f3e000ULL, 0x0000005904047208ULL, 0x000fc40004000000ULL,
0x000000535200720bULL, 0x008fe40003f5e000ULL, 0x0000000756057208ULL, 0x000fe40004800000ULL,
0x0000005253067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x000000555400720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x00000002ff6d7819ULL, 0x000fe20000011618ULL, 0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b49527823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010807ULL, 0x0000005000537308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b51497823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b43437823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b42427823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b05507820ULL, 0x002fe20000410000ULL, 0x3fb8aa3b06077820ULL, 0x000fe20000410000ULL,
0x0000004f004f7308ULL, 0x000fe20000000800ULL, 0x000000086d6e7824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b30307823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010850ULL,
0x0000005455077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010850ULL, 0x0000003500357308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b07557820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010855ULL, 0x0000004100587308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b31317823ULL, 0x000fe20000010850ULL,
0x000000086d707824ULL, 0x040fe200078e00ffULL, 0x0000004e004e7308ULL, 0x000fe20000000800ULL,
0x000000086d727824ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b10107823ULL, 0x000fe20000010855ULL, 0x0000004d004d7308ULL, 0x000fe20000000800ULL,
0x0000000c09097812ULL, 0x000fc400078ec0ffULL, 0x0000000318ff7812ULL, 0x000fca000780c0ffULL,
0x0000004c004c7308ULL, 0x000ff00000000800ULL, 0x0000003a003a7308ULL, 0x000ff00000000800ULL,
0x0000003800517308ULL, 0x000e700000000800ULL, 0x0000003700567308ULL, 0x0005f00000000800ULL,
0x0000003600577308ULL, 0x0007220000000800ULL, 0x3fb8aa3b34377823ULL, 0x104fe20000010850ULL,
0x00000004ff347e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe80003800000ULL,
0x3f8000003434783eULL, 0x000fe200000010ffULL, 0x0000003f00387308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b3e367823ULL, 0x008fce0000010850ULL, 0x00000021003f7308ULL, 0x0005f00000000800ULL,
0x0000003300417308ULL, 0x000fe20000000800ULL, 0x000000016d217810ULL, 0x004fc80007ffe0ffULL,
0xfffffff86e6e7812ULL, 0x000fe400078ee221ULL, 0x000000026d217810ULL, 0x000fe20007ffe0ffULL,
0x00000025005a7308ULL, 0x0005e60000000800ULL, 0xfffffff870707812ULL, 0x000fe400078ee221ULL,
0x0000003a5121723eULL, 0x002fc600000010ffULL, 0x00000028005b7308ULL, 0x000fe20000000800ULL,
0x000000086d257824ULL, 0x004fce00078e00ffULL, 0x0000002900627308ULL, 0x000ff00000000800ULL,
0x0000002a005d7308ULL, 0x000ff00000000800ULL, 0x0000002300507308ULL, 0x0003f00000000800ULL,
0x0000002400337308ULL, 0x000ea20000000800ULL, 0x000000036d237810ULL, 0x002fc80007ffe0ffULL,
0xfffffff872727812ULL, 0x000fe400078ee223ULL, 0x000000565723723eULL, 0x010fe200000010ffULL,
0x0000002200287308ULL, 0x0003e20000000800ULL, 0x000000086d567810ULL, 0x000fce0007ffe0ffULL,
0x0000002000297308ULL, 0x0007e20000000800ULL, 0x000000046d227810ULL, 0x002fc80007ffe0ffULL,
0xfffffff825747812ULL, 0x000fe400078ee222ULL, 0x000000355825723eULL, 0x000fe200000010ffULL,
0x0000001e002a7308ULL, 0x0005e20000000800ULL, 0x0000004f4e20723eULL, 0x008fe200000010ffULL,
0x000000ffff357224ULL, 0x000fe200078e0034ULL, 0x0000004d4c22723eULL, 0x000fe200000010ffULL,
0x000000086d4c7824ULL, 0x040fe200078e00ffULL, 0x000000106d587810ULL, 0x000fc60007ffe0ffULL,
0x0000001f001f7308ULL, 0x000e620000000800ULL, 0x000000335a1e723eULL, 0x004fe400000010ffULL,
0xfffffff84c4c7812ULL, 0x000fca00078ee26dULL, 0x0000003900397308ULL, 0x000ff00000000800ULL,
0x0000003c003c7308ULL, 0x000fe20000000800ULL, 0x0000002a1f1f723eULL, 0x002fe400000010ffULL,
0xffffffff6d2a7810ULL, 0x000fca0007ffe0ffULL, 0x0000003000547308ULL, 0x0003f00000000800ULL,
0x0000002c00637308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1c307823ULL, 0x002fe20000010855ULL,
0x0000003f501c723eULL, 0x000fe200000010ffULL, 0x000000086d507824ULL, 0x000fca00078e00ffULL,
0x0000002d006a7308ULL, 0x000ff00000000800ULL, 0x0000002e006c7308ULL, 0x000ff00000000800ULL,
0x0000002f006b7308ULL, 0x0003f00000000800ULL, 0x0000004b004b7308ULL, 0x000fe20000000800ULL,
0x00000034202c723cULL, 0x002b6e00000418ffULL, 0x0000004a004a7308ULL, 0x000e620000000800ULL,
0x000000086d357824ULL, 0x020fce00078e00ffULL, 0x0000002b00687308ULL, 0x0005f00000000800ULL,
0x0000005200527308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1d2b7823ULL, 0x004fe20000010855ULL,
0x00000028291d723eULL, 0x000fc400000010ffULL, 0x0000004b4a24723eULL, 0x002fe200000010ffULL,
0x000000ffff4a7224ULL, 0x100fe200078e0034ULL, 0x000000066d297810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff4b7224ULL, 0x000fe200078e0034ULL, 0x00000031003e7308ULL, 0x0003e20000000800ULL,
0x000000056d287810ULL, 0x000fe40007ffe0ffULL, 0xfffffff850507812ULL, 0x000fe400078ee229ULL,
0xfffffff8354e7812ULL, 0x000fc600078ee228ULL, 0x00000030003a7308ULL, 0x0005e20000000800ULL,
0x000000ffff317224ULL, 0x002fce00078e0034ULL, 0x00000027005c7308ULL, 0x0003e20000000800ULL,
0x000000ffff307224ULL, 0x004fce00078e0034ULL, 0x0000002b002b7308ULL, 0x000ea20000000800ULL,
0x000000393c27723eULL, 0x002fe200000010ffULL, 0x000000086d397824ULL, 0x040fe200078e00ffULL,
0x000000186d6d7810ULL, 0x000fca0007ffe0ffULL, 0x0000003200697308ULL, 0x0003f00000000800ULL,
0x0000001300137308ULL, 0x000fe20000000800ULL, 0x000000301c30723cULL, 0x002f6200000418ffULL,
0x0000002b3a29723eULL, 0x004fcc00000010ffULL, 0x00000011003c7308ULL, 0x0002b00000000800ULL,
0x0000002600597308ULL, 0x0007220000000800ULL, 0x0000000856117824ULL, 0x002fca00078e00ffULL,
0xfffffff811567812ULL, 0x000fe400078ee256ULL, 0x000000133c2b723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b0c3c7823ULL, 0x000fe20000010855ULL, 0x000000525326723eULL, 0x008fe200000010ffULL,
0x000000ffff0c7224ULL, 0x000fe200078e0034ULL, 0xfffffff839527812ULL, 0x000fe200078ee22aULL,
0x0000003d003d7308ULL, 0x000e620000000800ULL, 0x0000005b622a723eULL, 0x000fe200000010ffULL,
0x0000000858137824ULL, 0x000fe200078e00ffULL, 0x000000595c28723eULL, 0x010fe200000010ffULL,
0x0000004a242c723cULL, 0x000b62000004182cULL, 0x000000ffff397224ULL, 0x000fc400078e0034ULL,
0xfffffff813587812ULL, 0x000fe200078ee258ULL, 0x0000004900497308ULL, 0x000fe60000000800ULL,
0x3fb8aa3b0d4a7823ULL, 0x120fe20000010855ULL, 0x000000ffff0d7224ULL, 0x100fe200078e0034ULL,
0x3fb8aa3b0e4b7823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b0f557823ULL, 0x000fe40000010855ULL,
0x0000004800487308ULL, 0x000ea20000000800ULL, 0x0000003d380f723eULL, 0x002fe200000010ffULL,
0x000000ffff387224ULL, 0x000fe200078e0034ULL, 0x0000000c2830723cULL, 0x000b6a0000041830ULL,
0x0000004700477308ULL, 0x000ff00000000800ULL, 0x0000004600467308ULL, 0x000e620000000800ULL,
0x00000049480c723eULL, 0x024fce00000010ffULL, 0x0000003b003b7308ULL, 0x000ff00000000800ULL,
0x0000004000407308ULL, 0x000ea20000000800ULL, 0x00000047460e723eULL, 0x002fce00000010ffULL,
0x0000001200357308ULL, 0x0003f00000000800ULL, 0x00000010003a7308ULL, 0x0007220000000800ULL,
0x0000003b400d723eULL, 0x004fe200000010ffULL, 0x000000086d407824ULL, 0x000fe200078e00ffULL,
0x000000636a12723eULL, 0x002fc800000010ffULL, 0xfffffff840407812ULL, 0x000fe200078ee26dULL,
0x0000000a000a7308ULL, 0x000fe20000000800ULL, 0x0000005d6810723eULL, 0x008fce00000010ffULL,
0x0000000b000b7308ULL, 0x000e620000000800ULL, 0x000000353a11723eULL, 0x010fe200000010ffULL,
0x000000ffff357224ULL, 0x000fe200078e0034ULL, 0x000000380c38723cULL, 0x000b6a000004182cULL,
0x0000003600367308ULL, 0x000ea20000000800ULL, 0x0000000a0b13723eULL, 0x002fce00000010ffULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x0000a0001a0b7811ULL, 0x000fe200078e60ffULL,
0x000000341030723cULL, 0x000be80000041830ULL, 0x000000104c4c7824ULL, 0x100fe400078e020bULL,
0x0000004500457308ULL, 0x000fe20000000800ULL, 0x000000106e6e7824ULL, 0x100fe200078e020bULL,
0x00000036412d723eULL, 0x024fe200000010ffULL, 0x0000001070707824ULL, 0x000fc400078e020bULL,
0x0000001072727824ULL, 0x100fe400078e020bULL, 0x0000001074747824ULL, 0x000fe200078e020bULL,
0x0000004400447308ULL, 0x000ea20000000800ULL, 0x000000373e2f723eULL, 0x002fe200000010ffULL,
0x000000ffff367224ULL, 0x100fe200078e0034ULL, 0x0000006b543e723eULL, 0x000fe200000010ffULL,
0x000000014c357824ULL, 0x000fe400078e0209ULL, 0x000000ffff377224ULL, 0x000fe400078e0034ULL,
0x0000004300437308ULL, 0x000fe20000000800ULL, 0x000000104e4e7824ULL, 0x000fe200078e020bULL,
0x0000002035007388ULL, 0x0003e20000000800ULL, 0x00000001096e7824ULL, 0x000fc400078e026eULL,
0x0000001050507824ULL, 0x100fe400078e020bULL, 0x0000000109707824ULL, 0x040fe200078e0270ULL,
0x0000004200427308ULL, 0x000ee20000000800ULL, 0x00000045442c723eULL, 0x004fe200000010ffULL,
0x0000001052527824ULL, 0x100fe200078e020bULL, 0x000000226e007388ULL, 0x0003e20000000800ULL,
0x0000000109727824ULL, 0x040fe400078e0272ULL, 0x0000001056567824ULL, 0x000fe200078e020bULL,
0x0000002470007388ULL, 0x0003e20000000800ULL, 0x0000003c003f7308ULL, 0x0005e20000000800ULL,
0x0000000109747824ULL, 0x000fc400078e0274ULL, 0x00000001094e7824ULL, 0x040fe200078e024eULL,
0x0000002672007388ULL, 0x0003e20000000800ULL, 0x0000000109507824ULL, 0x040fe400078e0250ULL,
0x0000000109527824ULL, 0x040fe200078e0252ULL, 0x0000004a004a7308ULL, 0x000f220000000800ULL,
0x00000043422e723eULL, 0x008fe200000010ffULL, 0x0000000109567824ULL, 0x000fe200078e0256ULL,
0x000000696c3c723eULL, 0x004fe200000010ffULL, 0x0000000c74007388ULL, 0x0003e20000000800ULL,
0x0000001058587824ULL, 0x000fc400078e020bULL, 0x0000001040407824ULL, 0x000fe200078e020bULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x000000362c38723cULL, 0x000f620000041838ULL,
0x0000000e4e007388ULL, 0x0003e20000000800ULL, 0x00000001090b7824ULL, 0x040fe400078e0258ULL,
0x0000000109407824ULL, 0x000fe200078e0240ULL, 0x0000002c50007388ULL, 0x0003e40000000800ULL,
0x00000055000a7308ULL, 0x000ea20000000800ULL, 0x0000003f4a3d723eULL, 0x010fe200000010ffULL,
0x0000002e52007388ULL, 0x0003e80000000800ULL, 0x0000002156007388ULL, 0x0003e80000000800ULL,
0x000400236e007388ULL, 0x0003e80000000800ULL, 0x0004002570007388ULL, 0x0003e20000000800ULL,
0x0000004b0a3f723eULL, 0x004fc400000010ffULL, 0x000000ffff397224ULL, 0x020fe200078e003aULL,
0x0004002772007388ULL, 0x0003e80000000800ULL, 0x0004000d74007388ULL, 0x0003e20000000800ULL,
0x000000363c30723cULL, 0x000f660000041830ULL, 0x0004000f4e007388ULL, 0x0003e80000000800ULL,
0x0004002d50007388ULL, 0x0003e80000000800ULL, 0x0004002f52007388ULL, 0x0003e80000000800ULL,
0x0000001c0b007388ULL, 0x0003e80000000800ULL, 0x0008001e6e007388ULL, 0x0003e80000000800ULL,
0x0008002870007388ULL, 0x0003e20000000800ULL, 0x000000ffff3a7224ULL, 0x020fc400078e0030ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0032ULL, 0x0008002a72007388ULL, 0x0003e80000000800ULL,
0x0008001074007388ULL, 0x0003e80000000800ULL, 0x000800124e007388ULL, 0x0003e80000000800ULL,
0x0008003c50007388ULL, 0x0003e80000000800ULL, 0x0008003e52007388ULL, 0x0003e80000000800ULL,
0x0000001d40007388ULL, 0x0003e80000000800ULL, 0x000c001f6e007388ULL, 0x0003e80000000800ULL,
0x000c002970007388ULL, 0x0003e80000000800ULL, 0x000c002b72007388ULL, 0x0003e80000000800ULL,
0x000c001174007388ULL, 0x0003e80000000800ULL, 0x000c00134e007388ULL, 0x0003e80000000800ULL,
0x000c003d50007388ULL, 0x0003e80000000800ULL, 0x000c003f52007388ULL, 0x0003e80000000800ULL,
0x0120000408008388ULL, 0x0003e80000000c00ULL, 0x0122003808008388ULL, 0x0003e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000065ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080065ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100065ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000166667810ULL, 0x000fe20007ffe0ffULL,
0x0000180065ff7f8cULL, 0x0003e6000c80043fULL, 0x000000156600720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff864000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff257807ULL, 0x002fe40004000000ULL,
0x0001b68000267802ULL, 0x000fc40000000f00ULL, 0x00000e8000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0025ULL, 0xfffe73f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005800000ULL, 0x0001b6d000267802ULL, 0x000fc40000000f00ULL,
0x00000e3000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0025ULL,
0xfffe745000007947ULL, 0x000fea000383ffffULL, 0x0001b71000257802ULL, 0x000fc40000000f00ULL,
0x00000da000007944ULL, 0x004fea0003c00000ULL, 0xfffe753000007947ULL, 0x000fea000383ffffULL,
0x0001b74000257802ULL, 0x000fc40000000f00ULL, 0x00000d7000007944ULL, 0x006fea0003c00000ULL,
0xfffe767000007947ULL, 0x000fea000383ffffULL, 0x0001b77000257802ULL, 0x000fc40000000f00ULL,
0x00000d4000007944ULL, 0x00efea0003c00000ULL, 0xfffe77b000007947ULL, 0x000fea000383ffffULL,
0x0001b7a000257802ULL, 0x000fc40000000f00ULL, 0x00000d1000007944ULL, 0x00efea0003c00000ULL,
0xfffe78e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x0001b7e000257802ULL, 0x000fc40000000f00ULL, 0x00000cd000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xfffe7d1000007947ULL, 0x000fea000383ffffULL,
0x0001b82000257802ULL, 0x000fc40000000f00ULL, 0x00000c9000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x0000001002267810ULL, 0x000fe40007ffe0ffULL,
0x0001b86000257802ULL, 0x000fc40000000f00ULL, 0x00000c5000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xfffe7ce000007947ULL, 0x000fea000383ffffULL,
0x0001b8a000257802ULL, 0x000fc40000000f00ULL, 0x00000c1000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xfffe7cd000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x0001b8f000267802ULL, 0x000fc40000000f00ULL,
0x00000c1000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0025ULL,
0xfffeacc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005800000ULL,
0x0001b94000267802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff707224ULL, 0x000fe200078e0025ULL, 0xfffead1000007947ULL, 0x000fea000383ffffULL,
0x0001b98000257802ULL, 0x000fc40000000f00ULL, 0x00000b3000007944ULL, 0x004fea0003c00000ULL,
0xfffeadf000007947ULL, 0x000fea000383ffffULL, 0x0001b9b000257802ULL, 0x000fc40000000f00ULL,
0x00000b0000007944ULL, 0x006fea0003c00000ULL, 0xfffeaf3000007947ULL, 0x000fea000383ffffULL,
0x0001b9e000257802ULL, 0x000fc40000000f00ULL, 0x00000ad000007944ULL, 0x00efea0003c00000ULL,
0xfffeb07000007947ULL, 0x000fea000383ffffULL, 0x0001ba1000257802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x00efea0003c00000ULL, 0xfffeb1a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001eULL, 0x0001ba5000257802ULL, 0x000fc40000000f00ULL,
0x00000a6000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xfffeb5a000007947ULL, 0x000fea000383ffffULL, 0x0001ba9000257802ULL, 0x000fc40000000f00ULL,
0x00000a2000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x000000101e267810ULL, 0x000fc40007ffe0ffULL, 0x0001bad000257802ULL, 0x000fc40000000f00ULL,
0x000009e000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xfffeb57000007947ULL, 0x000fea000383ffffULL, 0x0001bb1000257802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xfffeb56000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x0001bb6000267802ULL, 0x000fc40000000f00ULL, 0x000009a000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff707224ULL, 0x000fe200078e0025ULL, 0xfffee47000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005800000ULL, 0x0001bbb000267802ULL, 0x000fc40000000f00ULL,
0x0000095000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff717224ULL, 0x000fe200078e0025ULL,
0xfffee4c000007947ULL, 0x000fea000383ffffULL, 0x0001bbf000257802ULL, 0x000fc40000000f00ULL,
0x000008c000007944ULL, 0x002fea0003c00000ULL, 0xfffee5a000007947ULL, 0x000fea000383ffffULL,
0x0001bc2000257802ULL, 0x000fc40000000f00ULL, 0x0000089000007944ULL, 0x002fea0003c00000ULL,
0xfffee6e000007947ULL, 0x000fea000383ffffULL, 0x0001bc5000257802ULL, 0x000fc40000000f00ULL,
0x0000086000007944ULL, 0x002fea0003c00000ULL, 0xfffee82000007947ULL, 0x000fea000383ffffULL,
0x0001bc8000257802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x002fea0003c00000ULL,
0xfffee95000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e006cULL,
0x0001bcc000257802ULL, 0x000fc40000000f00ULL, 0x000007f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xfffeed6000007947ULL, 0x000fea000383ffffULL,
0x0001bd0000257802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x000000106c267810ULL, 0x000fc40007ffe0ffULL,
0x0001bd4000257802ULL, 0x000fc40000000f00ULL, 0x0000077000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xfffeed3000007947ULL, 0x000fea000383ffffULL,
0x0001bd8000257802ULL, 0x000fc40000000f00ULL, 0x0000073000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xfffeed2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x004fe40004000000ULL, 0x0001bdd000267802ULL, 0x000fc40000000f00ULL,
0x0000073000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0025ULL,
0xffff1b5000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005800000ULL,
0x0001be2000267802ULL, 0x000fc40000000f00ULL, 0x000006e000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff6f7224ULL, 0x000fe200078e0025ULL, 0xffff1ba000007947ULL, 0x000fea000383ffffULL,
0x0001be6000257802ULL, 0x000fc40000000f00ULL, 0x0000065000007944ULL, 0x008fea0003c00000ULL,
0xffff1c8000007947ULL, 0x000fea000383ffffULL, 0x0001be9000257802ULL, 0x000fc40000000f00ULL,
0x0000062000007944ULL, 0x00afea0003c00000ULL, 0xffff1dc000007947ULL, 0x000fea000383ffffULL,
0x0001bec000257802ULL, 0x000fc40000000f00ULL, 0x000005f000007944ULL, 0x00afea0003c00000ULL,
0xffff1f0000007947ULL, 0x000fea000383ffffULL, 0x0001bef000257802ULL, 0x000fc40000000f00ULL,
0x000005c000007944ULL, 0x00afea0003c00000ULL, 0xffff203000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0008ULL, 0x0001bf3000257802ULL, 0x000fc40000000f00ULL,
0x0000058000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xffff244000007947ULL, 0x000fea000383ffffULL, 0x0001bf7000257802ULL, 0x000fc40000000f00ULL,
0x0000054000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x0000001008267810ULL, 0x000fc40007ffe0ffULL, 0x0001bfb000257802ULL, 0x000fc40000000f00ULL,
0x0000050000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xffff241000007947ULL, 0x000fea000383ffffULL, 0x0001bff000257802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xffff240000007947ULL, 0x000fea000383ffffULL, 0x00000002ff567424ULL, 0x000fe200078e00ffULL,
0x0001c04000527802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0055ULL, 0xffffe0f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x006fe200078e0054ULL, 0x0001c0a000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff567424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x000000555400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0058ULL,
0x0001c10000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff567424ULL, 0x000fe200078e00ffULL,
0x0000005455067208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000555800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0057ULL,
0x0001c16000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff567424ULL, 0x000fe200078e00ffULL,
0x0000005855587208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000555700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0059ULL,
0x0001c1c000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff567424ULL, 0x000fe200078e00ffULL,
0x0000005755547208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000555900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0006ULL,
0x0001c22000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff567424ULL, 0x000fe200078e00ffULL,
0x0000005955047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000550600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0058ULL,
0x0001c28000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff567424ULL, 0x000fe200078e00ffULL,
0x0000000655057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000555800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0054ULL,
0x0001c2e000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff567424ULL, 0x000fe200078e00ffULL,
0x0000005855067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffdfc000007947ULL, 0x000fea000383ffffULL, 0x0180000024007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000002400008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff24ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000024027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002400007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe3b9002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff537424ULL, 0x000fe200078e00ffULL,
0x0000005b00007348ULL, 0x000fe80003800000ULL, 0x0c00005607557389ULL, 0x0002a200000e005aULL,
0xfffe3b5052007950ULL, 0x000fea0003c3ffffULL, 0x000000ffff6a7224ULL, 0x000fe200078e0025ULL,
0x0000007700007348ULL, 0x000fe80003800000ULL, 0x00000000ff6b7424ULL, 0x000fe200078e00ffULL,
0x0000002627267389ULL, 0x0002a600000e0078ULL, 0xfffe3b006a007950ULL, 0x000fea0003c3ffffULL,
0x000000012500780cULL, 0x000fe20003f65070ULL, 0x00000000ff277424ULL, 0x000fe200078e00ffULL,
0x0000007600007348ULL, 0x000ff60003800000ULL, 0x0000000000257806ULL, 0x000fc800058e0100ULL,
0x0000007625257212ULL, 0x000fe200078ec0ffULL, 0xfffe3aa026007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000568ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000340ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c78ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d38ULL,
0x00000000000008b0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001688ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000168cULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x000000000001c600ULL, 0xf300001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001de80ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001dec0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001e240ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001688ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001c7f8ULL,
0x000000000001c7f8ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001de80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001e240ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_86_cubin_len = 123680;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
