/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001fe40ULL, 0x000000000001fac0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL,
0x326d735f61647563ULL, 0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL,
0x746e695f5f240068ULL, 0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL,
0x66625f636e79736cULL, 0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL,
0x5f30376d735f6164ULL, 0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL,
0x5f5f245f335f6c61ULL, 0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL,
0x2e616c65722e0074ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL,
0x766e2e0066754265ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL,
0x65642e006d617261ULL, 0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL,
0x616c65722e00656dULL, 0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL,
0x00000000006e6f69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000037fULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000003cdULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b002200000413ULL,
0x000000000001df00ULL, 0x0000000000000180ULL, 0x000b002200000446ULL, 0x000000000001e080ULL,
0x0000000000000040ULL, 0x000b002200000471ULL, 0x000000000001e0c0ULL, 0x0000000000000050ULL,
0x000b00220000049bULL, 0x000000000001e110ULL, 0x00000000000000f0ULL, 0x000a000300000509ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000529ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000559ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001e200ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001df0000000000ULL, 0x0000040400000000ULL, 0x810c000001880400ULL, 0x0076280400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001df0000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808508288080ULL, 0x8087082880808608ULL, 0x0828808088082880ULL, 0x80809f082880809dULL,
0xea08288080a50828ULL, 0x288080f008288080ULL, 0x80f208288080f108ULL, 0x16288080d8082880ULL,
0x0000031028808280ULL, 0xd892000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x000000f000000000ULL, 0x0001e08000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808508288080ULL,
0x8087082880808608ULL, 0x0828808088082880ULL, 0x80809f082880809dULL, 0xea08288080a60828ULL,
0x288080f008288080ULL, 0x80f208288080f108ULL, 0x16288080a5082880ULL, 0x0000031028808280ULL,
0xa592000000000000ULL, 0x0000002200288080ULL, 0x0000002cffffffffULL, 0x000001a800000000ULL,
0x0001e0c000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL, 0x80ea288080a50900ULL,
0x0000000000002880ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808508288080ULL, 0x8087082880808608ULL, 0x0828808088082880ULL, 0x80809f082880809dULL,
0xea08288080a50828ULL, 0x288080f008288080ULL, 0x80f208288080f108ULL, 0x16288080a6082880ULL,
0x0000031028808280ULL, 0xa692000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x0000027000000000ULL, 0x0001e11000000000ULL, 0x000000f000000000ULL, 0x0000000000000000ULL,
0x0000001900082f04ULL, 0x00082304000000fcULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL,
0x0000000000000019ULL, 0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0060016000000016ULL, 0x000c170400601903ULL,
0x0058000a00000000ULL, 0x000c17040021f000ULL, 0x0050000900000000ULL, 0x000c17040021f000ULL,
0x0048000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040061f000ULL,
0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000eb000043104ULL, 0xffffffff019c2904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000002f0019c2804ULL,
0x000005f000000360ULL, 0x00002b0000002a70ULL, 0x00002d8000002c10ULL, 0x0000305000002ef0ULL,
0x00003510000034d0ULL, 0x0000355000003520ULL, 0x00006640000065a0ULL, 0x000068c000006750ULL,
0x00006b9000006a30ULL, 0x0000702000006fe0ULL, 0x0000706000007030ULL, 0x0000a07000009fd0ULL,
0x0000a2f00000a180ULL, 0x0000a5c00000a460ULL, 0x0000aa600000aa20ULL, 0x0000aaa00000aa70ULL,
0x0000d9c00000d920ULL, 0x0000dc400000dad0ULL, 0x0000df100000ddb0ULL, 0x0000e3b00000e370ULL,
0x0000e3f00000e3c0ULL, 0x000107e0000107d0ULL, 0x00010800000107f0ULL, 0x0001b7e00001b7a0ULL,
0x0001b8000001b7f0ULL, 0x0001b8800001b860ULL, 0x0001b8a00001b890ULL, 0x0001cd700001cd10ULL,
0x0001ce200001cdd0ULL, 0x0001cec00001ce70ULL, 0x0001cf800001cf20ULL, 0x0001d0400001cfe0ULL,
0x0001d1000001d0a0ULL, 0x0001d1b00001d160ULL, 0x0001d2500001d200ULL, 0x0001d3100001d2b0ULL,
0x0001d3d00001d370ULL, 0x0001d4900001d430ULL, 0x0001d5400001d4f0ULL, 0x0001d5e00001d590ULL,
0x0001d6a00001d640ULL, 0x0001d7600001d700ULL, 0x0001d8200001d7c0ULL, 0x0001d8d00001d880ULL,
0x0001d9700001d920ULL, 0x0001da300001d9d0ULL, 0x0001daf00001da90ULL, 0x0001dbd00001db60ULL,
0x0001dcd00001dc50ULL, 0x0001ddd00001dd50ULL, 0x0001ded00001de50ULL, 0x0000041004403904ULL,
0x0001a600000000ffULL, 0x00000440003f0100ULL, 0x0001a6080000000fULL, 0x000004b0003f0120ULL,
0x0001a6880000000fULL, 0x00000590003f0120ULL, 0x0001a6a80000000fULL, 0x000005c0003f0120ULL,
0x0001a6c80000000fULL, 0x00000ed0003f0120ULL, 0x0001a600000000ffULL, 0x00001020003f0107ULL,
0x0001a68c00000014ULL, 0x000010b0003f0102ULL, 0x0001a68800000014ULL, 0x000019e0003f0101ULL,
0x00000000000000ffULL, 0x00001a6000040107ULL, 0x00000000000000ffULL, 0x00001ac000040101ULL,
0x0000002000000002ULL, 0x00001c30003f0101ULL, 0x0001a6cc00000008ULL, 0x00001e00003f0105ULL,
0x0001a6cc00000008ULL, 0x00002620003f0105ULL, 0x0001a6b00000001fULL, 0x000026e0003f0107ULL,
0x0001a6b00000001fULL, 0x00002740003f0101ULL, 0x0001a6080000001cULL, 0x00002780003f0101ULL,
0x0001a60c00000020ULL, 0x00002960003f0105ULL, 0x0001a60c00000020ULL, 0x00003200003f0105ULL,
0x0001a6ac0000001fULL, 0x000033f0003f0105ULL, 0x0001a6ac0000001fULL, 0x000057c0003f0105ULL,
0x000000000000006aULL, 0x00005820003f0101ULL, 0x0001a6880000001fULL, 0x00005850003f0101ULL,
0x000000040000000dULL, 0x00005a10003f0105ULL, 0x000000040000000dULL, 0x00006160003f0105ULL,
0x0000000000000008ULL, 0x00006240003f0107ULL, 0x0000000000000008ULL, 0x000062a0003f0101ULL,
0x0001a62800000020ULL, 0x00006300003f0101ULL, 0x0001a62c00000021ULL, 0x000064d0003f0105ULL,
0x0001a62c00000021ULL, 0x00006d50003f0105ULL, 0x0001a6b40000006aULL, 0x00006f20003f0105ULL,
0x0001a6b40000006aULL, 0x00009250003f0105ULL, 0x000000000000006aULL, 0x000092b0003f0101ULL,
0x0001a69000000026ULL, 0x000092e0003f0101ULL, 0x000000040000000dULL, 0x000094a0003f0105ULL,
0x000000040000000dULL, 0x00009c20003f0105ULL, 0x00000008000000ffULL, 0x00009cb000040107ULL,
0x0001a6b000000068ULL, 0x00009d10003f0101ULL, 0x0001a64800000020ULL, 0x00009d30003f0101ULL,
0x0001a64c00000020ULL, 0x00009f00003f0105ULL, 0x0001a64c00000020ULL, 0x0000a780003f0105ULL,
0x0000000400000008ULL, 0x0000a950003f0105ULL, 0x0000000400000008ULL, 0x0000cb70003f0105ULL,
0x000000000000006aULL, 0x0000cbd0003f0101ULL, 0x0001a69800000023ULL, 0x0000cc00003f0101ULL,
0x000000040000000dULL, 0x0000cdc0003f0105ULL, 0x000000040000000dULL, 0x0000d560003f0105ULL,
0x00000000000000ffULL, 0x0000d61000040107ULL, 0x0000000000000008ULL, 0x0000d670003f0101ULL,
0x0001a6680000000cULL, 0x0000d6a0003f0101ULL, 0x0001a66c0000000cULL, 0x0000d870003f0105ULL,
0x0001a66c0000000cULL, 0x0000e0d0003f0105ULL, 0x0001a6b400000020ULL, 0x0000e2a0003f0105ULL,
0x0001a6b400000020ULL, 0x00010520003f0105ULL, 0x000000000000000dULL, 0x000105a0003f0101ULL,
0x0000000000000008ULL, 0x00012820003f0101ULL, 0x0001a600000000ffULL, 0x00014060003f0101ULL,
0x0001a604000000ffULL, 0x00014270003f0105ULL, 0x0001a604000000ffULL, 0x000145f0003f0105ULL,
0x0001a600000000ffULL, 0x00014620003f0101ULL, 0x0001a604000000ffULL, 0x000147e0003f0105ULL,
0x0001a604000000ffULL, 0x00018a20003f0105ULL, 0x0000000000000007ULL, 0x00018b20003f0101ULL,
0x0000000400000007ULL, 0x00018cf0003f0105ULL, 0x0000000400000007ULL, 0x0001cb50003f0105ULL,
0x00000000000000bbULL, 0x0001cbb0003f0101ULL, 0x00000008000000bbULL, 0x0001cc10003f0101ULL,
0x00000010000000bbULL, 0x0001cc80003f0101ULL, 0x00000018000000bbULL, 0x00053803003f0101ULL,
0x0001175000301c04ULL, 0x00011a1000011780ULL, 0x00011df000011c00ULL, 0x000121d000011fe0ULL,
0x000125c0000123c0ULL, 0x0001484000012770ULL, 0x000004010001ccd0ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000314ULL, 0x0000001900000002ULL, 0x000000000000024cULL, 0x0000001900000002ULL,
0x0000000000000194ULL, 0x0000001900000002ULL, 0x00000000000000ccULL, 0x0000001900000002ULL,
0x0000000000000044ULL, 0x0000001900000002ULL, 0x00000000000002eeULL, 0x0000001900000002ULL,
0x0000000000000226ULL, 0x0000001900000002ULL, 0x000000000000016eULL, 0x0000001900000002ULL,
0x00000000000000a8ULL, 0x0000001900000002ULL, 0x000000000001a700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000117919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff020424ULL, 0x000fe200078e00ffULL,
0x0000000111040810ULL, 0x002fca0007ffe0ffULL, 0x00005c0004040625ULL, 0x000fc800078e0002ULL,
0x00005c0011020625ULL, 0x000fe200078e0002ULL, 0x0000000604090981ULL, 0x0002aa000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff107624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000087919ULL, 0x000e620000002600ULL, 0x00005a00ff137624ULL, 0x000fc600078e00ffULL,
0x00000000000d7919ULL, 0x000e620000002300ULL, 0x0000590013137a24ULL, 0x000fc600078e02ffULL,
0x00000000001a7919ULL, 0x000e620000002100ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00067810ULL, 0x010fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x000864000021f000ULL,
0x000000ffff067224ULL, 0x010fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x002fc800078e0a07ULL,
0x000059000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b07077227ULL, 0x000fe400078e0006ULL,
0x0000000000067919ULL, 0x000e680000002200ULL, 0x00000400070b7a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x008fc800078e0a0bULL, 0x0000040003007624ULL, 0x000fca00078e0210ULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x8000590000001a10ULL, 0x000fe40007ffe0ffULL,
0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f46070ULL,
0x000000010b0b2810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff0bba12ULL, 0x000fc800078e33ffULL,
0x0000000b00007306ULL, 0x000ee20000209000ULL, 0x000000ff0b00720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x008ee40000001000ULL, 0x0ffffffe00047810ULL, 0x008fcc0007ffe0ffULL,
0x0000000400057305ULL, 0x000724000021f000ULL, 0x000000ffff047224ULL, 0x008fe400078e00ffULL,
0x000000050b037224ULL, 0x010fc800078e02ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a03ULL,
0x0000000305057227ULL, 0x000fc800078e0004ULL, 0x000001000d037a24ULL, 0x002fe400078e0206ULL,
0x00000008051b7227ULL, 0x000fe200078e00ffULL, 0x00001fff0d0d7589ULL, 0x000fe600000e0000ULL,
0x000000ffff007224ULL, 0x000fe400078e0a1bULL, 0x00000000030f7a24ULL, 0x100fe200078e021aULL,
0x00000005ff1a7819ULL, 0x000fe2000001161aULL, 0x000000000b007224ULL, 0x000fc600078e0208ULL,
0x000000ff0f00720cULL, 0x040fe40003f65270ULL, 0x0000000b0000720cULL, 0x000fe20003fa6070ULL,
0x00001fff1a1a7589ULL, 0x000e6200000e0000ULL, 0x0000000f0f00780cULL, 0x040fe40003f24070ULL,
0x0000007f0f00780cULL, 0x000fce0003f44070ULL, 0x3fffff80ff04b424ULL, 0x000fe400078e00ffULL,
0x0000000100005824ULL, 0x000fe200078e0a0bULL, 0x000000011b1b5810ULL, 0x000fe20007ffe0ffULL,
0x7fffff80ff05b424ULL, 0x000fe200078e00ffULL, 0x000000030f00780cULL, 0x040fe20003fa4070ULL,
0x3fffffc0ff069424ULL, 0x000fe200078e00ffULL, 0x0000000b0000720cULL, 0x000fe20003fc6070ULL,
0x7fffffc0ff079424ULL, 0x000fe200078e00ffULL, 0x01a60004ff00b388ULL, 0x0007e20000000a00ULL,
0x000000010f00780cULL, 0x000fe20003f64070ULL, 0xff317217ff0ca424ULL, 0x000fc400078e00ffULL,
0x01a608060f009388ULL, 0x0009e80000008a00ULL, 0x01a4000c0f00a388ULL, 0x000fe20000004800ULL,
0x3fffff60ff04d424ULL, 0x008fe400078e00ffULL, 0x000000011b1b6810ULL, 0x000fe20007ffe0ffULL,
0x7fffff60ff05d424ULL, 0x000fe200078e00ffULL, 0x0000000bff1bc212ULL, 0x000fe200078e33ffULL,
0x3fffffc0ff0ab424ULL, 0x000fc600078e00ffULL, 0x01a688040f00d388ULL, 0x000fe20000008a00ULL,
0x000000ffff197224ULL, 0x000fc800078e0a1bULL, 0x000000190b197224ULL, 0x000fe400078e0208ULL,
0x3fffff80ff08d424ULL, 0x000fe400078e00ffULL, 0x0000002019197824ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff0bb424ULL, 0x000fe400078e00ffULL, 0x0000000109000824ULL, 0x004fe400078e0a02ULL,
0x00005800ff008624ULL, 0x000fc400078e00ffULL, 0x0000580011028a24ULL, 0x000fe400078e02ffULL,
0x00005a0000067a24ULL, 0x010fe400078e02ffULL, 0x7fffff80ff09d424ULL, 0x000fe400078e00ffULL,
0x0000000106037824ULL, 0x040fe200078e0a19ULL, 0x000000190600720cULL, 0x000fe20003f26070ULL,
0x0000001302747224ULL, 0x000fe200078e02ffULL, 0x01a6a8080f00d388ULL, 0x000fe40000008a00ULL,
0x0000002003037817ULL, 0x000fe20003800000ULL, 0x00005a001b147a24ULL, 0x000fe200078e0274ULL,
0x01a6c80a0f00b388ULL, 0x000fe40000008a00ULL, 0x000000ff03187207ULL, 0x000fe20000800000ULL,
0x000000040d037824ULL, 0x002fe200078e021aULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000201800780cULL, 0x000fe20003f05270ULL, 0x0000000403037824ULL, 0x000fd800078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a0000077b06ULL, 0x000e620000209000ULL,
0x0000000000177919ULL, 0x000eae0000000000ULL, 0x0000000700077308ULL, 0x002e620000001000ULL,
0x00000004ff067819ULL, 0x004fc80000011617ULL, 0x00000002060b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103087824ULL, 0x000fe200078e0206ULL, 0x0ffffffe07047810ULL, 0x002fc60007ffe0ffULL,
0x00000001030c7824ULL, 0x000fe200078e020bULL, 0x0000000400057305ULL, 0x0002a6000021f000ULL,
0x00000001190f7824ULL, 0x000fe400078e020cULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000ffff097224ULL, 0x004fc800078e0a05ULL, 0x00005a0009097a24ULL, 0x000fc800078e02ffULL,
0x00000009050a7227ULL, 0x000fc800078e0004ULL, 0x0000000119057824ULL, 0x000fc800078e0208ULL,
0x000000050a047227ULL, 0x000fc800078e00ffULL, 0x0000000f0a0a7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0e7224ULL, 0x000fe400078e0a04ULL, 0x000000ffff127224ULL, 0x000fe400078e0a0aULL,
0x00005a000e077a24ULL, 0x000fe400078e0205ULL, 0x00005a0012097a24ULL, 0x000fc600078e020fULL,
0x00005a0007007a0cULL, 0x000fe40003f06070ULL, 0x00005a0009007a0cULL, 0x000fd60003f46070ULL,
0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0007007a0cULL, 0x000fe40003f26070ULL, 0x00005a0009007a0cULL, 0x000fe40003f66070ULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x000000010a0a2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff077a12ULL, 0x000fc600078e33ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x000000010a0a3810ULL, 0x000fe40007ffe0ffULL,
0x0000000407097207ULL, 0x040fe40004000000ULL, 0x0000000a07077207ULL, 0x000fe40004000000ULL,
0x0000000318047217ULL, 0x000fe20007800000ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0a09ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0a07ULL, 0x00005a000a057a24ULL, 0x000fe400078e0205ULL,
0x00005a000e0f7a24ULL, 0x000fe400078e020fULL, 0x00000001140a7824ULL, 0x040fe400078e0205ULL,
0x00000001140e7824ULL, 0x000fe400078e020fULL, 0x0000000104047824ULL, 0x000fe400078e0a03ULL,
0x0000001309057224ULL, 0x000fc400078e020aULL, 0x0000001017037824ULL, 0x000fe200078e00ffULL,
0x000000040600720cULL, 0x080fe20003f06070ULL, 0x0000001307077224ULL, 0x000fe200078e020eULL,
0x000000040b00720cULL, 0x000fe20003f26070ULL, 0x0000010005047825ULL, 0x000fe200078e00ffULL,
0x000000f003097812ULL, 0x000fc600078ec0ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x0000000904047212ULL, 0x000fc600078efcffULL, 0x00000001080a7824ULL, 0x100fe200078e0217ULL,
0x0000000906067212ULL, 0x000fe200078efcffULL, 0x00000010080b7824ULL, 0x000fe200078e00ffULL,
0x0000600004047a10ULL, 0x000fe20007f5e0ffULL, 0x000000010c087824ULL, 0x000fe200078e0217ULL,
0x0000600006067a10ULL, 0x000fe20007f7e0ffULL, 0x000000100c097824ULL, 0x000fe200078e00ffULL,
0xfffffff00b0a7812ULL, 0x000fe400078ee20aULL, 0x0000610005057a10ULL, 0x000fe400017fe4ffULL,
0xfffffff009087812ULL, 0x000fe200078ee208ULL, 0x000000100a097824ULL, 0x000fe200078e00ffULL,
0x0000610007077a10ULL, 0x000fc60001ffe4ffULL, 0x00000010080b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000c101c46ULL,
0x00000000060b7faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a0000067b06ULL, 0x000e620000209000ULL, 0x0000000000177919ULL, 0x000eae0000000000ULL,
0x0000000600067308ULL, 0x002e620000001000ULL, 0x0000000317087211ULL, 0x004fc800078fe0ffULL,
0x00000002080a7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe06057810ULL, 0x002fc60007ffe0ffULL,
0x0000000119067824ULL, 0x000fc600078e020aULL, 0x0000000500057305ULL, 0x000e64000021f000ULL,
0x000000ffff047224ULL, 0x002fc800078e0a05ULL, 0x00005a0004037a24ULL, 0x000fe400078e02ffULL,
0x000000ffff047224ULL, 0x000fc800078e00ffULL, 0x0000000305077227ULL, 0x000fc800078e0004ULL,
0x0000000119037824ULL, 0x000fc800078e0208ULL, 0x0000000307047227ULL, 0x000fc800078e00ffULL,
0x0000000607077227ULL, 0x000fc800078e00ffULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x000000ffff097224ULL, 0x000fe400078e0a07ULL, 0x00005a000c057a24ULL, 0x000fe400078e0203ULL,
0x00005a0009097a24ULL, 0x000fc600078e0206ULL, 0x00005a0005007a0cULL, 0x000fe40003f06070ULL,
0x00005a0009007a0cULL, 0x000fd60003f46070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x00005a0009007a0cULL, 0x000fe20003f66070ULL, 0x0000000108097824ULL, 0x000fe200078e0217ULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x0000000107072810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff057a12ULL, 0x000fc600078e33ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x0000000107073810ULL, 0x000fe40007ffe0ffULL,
0x0000000405047207ULL, 0x040fe40004000000ULL, 0x0000000705077207ULL, 0x000fc60004000000ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x000000ffff057224ULL, 0x000fe400078e0a07ULL,
0x00005a000c037a24ULL, 0x000fe400078e0203ULL, 0x00005a0005067a24ULL, 0x000fe400078e0206ULL,
0x0000000114057824ULL, 0x040fe400078e0203ULL, 0x0000000114067824ULL, 0x000fc400078e0206ULL,
0x0000001017037824ULL, 0x000fe400078e00ffULL, 0x0000001304057224ULL, 0x080fe400078e0205ULL,
0x0000001307067224ULL, 0x000fe200078e0206ULL, 0x000000f0030b7812ULL, 0x000fe200078ec0ffULL,
0x0000010005047825ULL, 0x000fc800078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000b04047212ULL, 0x000fc600078efcffULL, 0x00000010080c7824ULL, 0x000fe200078e00ffULL,
0x0000000b06067212ULL, 0x000fe200078efcffULL, 0x000000010a087824ULL, 0x000fe200078e0217ULL,
0x0000600004047a10ULL, 0x000fe20007f1e0ffULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff00c097812ULL, 0x000fe400078ee209ULL, 0x0000600006067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00b087812ULL, 0x000fe200078ee208ULL, 0x0000001009097824ULL, 0x000fe200078e00ffULL,
0x0000610005057a10ULL, 0x000fc400007fe4ffULL, 0x0000610007077a10ULL, 0x000fe20000ffe4ffULL,
0x00000010080b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e8000b901c46ULL, 0x00000000060b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x0000000000067806ULL, 0x000fe200038e0000ULL,
0x00000004ff827424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000600047300ULL, 0x000e7000000e0000ULL, 0x0000000600077309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x0000660011047625ULL, 0x000fc800078e0082ULL,
0x000000ffff077224ULL, 0x004fd000078e0a07ULL, 0x01a60407ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01a60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604167981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0d00720cULL, 0x000fe40003f05270ULL,
0x000000ff16087810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff157819ULL, 0x000fce0000011608ULL,
0x0001179000008947ULL, 0x000fea0003800000ULL, 0x000000081a147824ULL, 0x000fe400078e00ffULL,
0x00000003ff057424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a68c0514ff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0800780cULL, 0x000fe20003f04070ULL, 0x0000000211007824ULL, 0x000fe200078e00ffULL,
0x00000001ff137819ULL, 0x000fe2000001161aULL, 0x01a6880014ff7f8cULL, 0x0007e2000c80043fULL,
0x000000011a117812ULL, 0x000fe200078ec0ffULL, 0x0000590000007624ULL, 0x000fe400078e0210ULL,
0x0000002013757824ULL, 0x000fc400078e00ffULL, 0x000000011b127824ULL, 0x000fc800078e0200ULL,
0x0000680012007a24ULL, 0x000fe200078e0275ULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x0000007516027217ULL, 0x008fe20007800000ULL, 0x0000001011057824ULL, 0x004fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc60000011617ULL, 0x0000000102027824ULL, 0x000fe200078e0a75ULL,
0x0000000404087810ULL, 0x040fe20007ffe0ffULL, 0x0000000105067824ULL, 0x000fe200078e0204ULL,
0x0000000c04097810ULL, 0x000fe40007ffe0ffULL, 0x0000000502027217ULL, 0x000fe20007800000ULL,
0x0000000106077824ULL, 0x042fe400078e0217ULL, 0x00000008060c7824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fc400078e0a05ULL, 0x00000001050a7824ULL, 0x040fe200078e0209ULL,
0xfffffff80c0c7812ULL, 0x000fe400078ee207ULL, 0x0000000804077810ULL, 0x000fe20007ffe0ffULL,
0x00000001000f7824ULL, 0x000fe200078e020aULL, 0x000000020400720cULL, 0x080fe20003f66070ULL,
0x0000000100047824ULL, 0x000fe200078e0206ULL, 0x000000020800720cULL, 0x080fe20003f46070ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x000000020700720cULL, 0x080fe20003f26070ULL,
0x0000000105077824ULL, 0x000fe200078e0207ULL, 0x000000020900720cULL, 0x000fe20003f06070ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x0000000100027824ULL, 0x000fe200078e0208ULL,
0x00000070040b7812ULL, 0x000fe200078ef803ULL, 0x0000000108067824ULL, 0x040fe400078e0217ULL,
0x00000008080d7824ULL, 0x000fe400078e00ffULL, 0x0000000100087824ULL, 0x000fe400078e0207ULL,
0x0000000107097824ULL, 0x100fe200078e0217ULL, 0xfffffff80d007812ULL, 0x000fe200078ee206ULL,
0x00000008070e7824ULL, 0x000fe200078e00ffULL, 0x00016000130d7811ULL, 0x000fe200078e68ffULL,
0x000000010a047824ULL, 0x000fc400078e0217ULL, 0x000000080a077824ULL, 0x000fe200078e00ffULL,
0x000064000b0a7a10ULL, 0x000fe20007f9e0ffULL, 0x00000010001d7824ULL, 0x000fe200078e020dULL,
0xfffffff80e0e7812ULL, 0x000fe400078ee209ULL, 0xfffffff807107812ULL, 0x000fe200078ee204ULL,
0x0000008008067825ULL, 0x000fe200078e00ffULL, 0x00006500050b7a10ULL, 0x000fc600027fe4ffULL,
0x0000008002047825ULL, 0x000fc800078e00ffULL, 0x000000800f087825ULL, 0x000fe200078e00ffULL,
0x0000007004027812ULL, 0x100fe400078ef803ULL, 0x0000007006047812ULL, 0x000fe200078ef803ULL,
0x000000100c0f7824ULL, 0x000fe200078e020dULL, 0x0000007008037812ULL, 0x000fe200078ef803ULL,
0x000000100e1f7824ULL, 0x100fe200078e020dULL, 0x0000640002027a10ULL, 0x000fe20007f9e0ffULL,
0x00000010100d7824ULL, 0x000fe200078e020dULL, 0x0000640004047a10ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0f7faeULL, 0x0003e2000d901c46ULL,
0x0000640003067a10ULL, 0x000fc40007fde0ffULL, 0x0000650005037a10ULL, 0x000fe400027fe4ffULL,
0x0000650007057a10ULL, 0x000fe40002ffe4ffULL, 0x0000650009077a10ULL, 0x000fe200037fe4ffULL,
0x00000000021d7faeULL, 0x0003e8000d101c46ULL, 0x00000000041f7faeULL, 0x0003e8000c901c46ULL,
0x00000000060d7faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001011027824ULL, 0x008fe200078e00ffULL, 0x00016000131f7811ULL, 0x000fc800078e68ffULL,
0x0000000217027211ULL, 0x000fc800078fe8ffULL, 0x0000000402067810ULL, 0x040fe20007ffe0ffULL,
0x0000000102057824ULL, 0x044fe200078e0217ULL, 0x0000000c020a7810ULL, 0x040fe20007ffe0ffULL,
0x00000008020c7824ULL, 0x040fe200078e00ffULL, 0x0000000802087810ULL, 0x000fe20007ffe0ffULL,
0x0000000100047824ULL, 0x040fe400078e0202ULL, 0x0000000100027824ULL, 0x000fe200078e0206ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL, 0x0000008004047825ULL, 0x000fc800078e00ffULL,
0x0000000106077824ULL, 0x002fe200078e0217ULL, 0x00000070040b7812ULL, 0x000fe200078ef803ULL,
0x00000008060e7824ULL, 0x000fe400078e00ffULL, 0x00000001000d7824ULL, 0x000fe400078e020aULL,
0x000000010a047824ULL, 0x040fe400078e0217ULL, 0x000000080a0f7824ULL, 0x000fe200078e00ffULL,
0x000064000b0a7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000100067824ULL, 0x000fe200078e0208ULL,
0xfffffff80e007812ULL, 0x000fe200078ee207ULL, 0x0000000108097824ULL, 0x040fe200078e0217ULL,
0xfffffff80f107812ULL, 0x000fe200078ee204ULL, 0x0000000808087824ULL, 0x000fe200078e00ffULL,
0x00006500050b7a10ULL, 0x000fe200007fe4ffULL, 0x0000008002047825ULL, 0x000fc600078e00ffULL,
0xfffffff8080e7812ULL, 0x000fe200078ee209ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000007004027812ULL, 0x000fc600078ef803ULL, 0x000000800d087825ULL, 0x000fe200078e00ffULL,
0x0000007006047812ULL, 0x000fe400078ef803ULL, 0x0000640002027a10ULL, 0x000fe20007f1e0ffULL,
0x000000100c0d7824ULL, 0x000fe200078e021fULL, 0x0000007008037812ULL, 0x000fe200078ef803ULL,
0x00000010000f7824ULL, 0x100fe200078e021fULL, 0x0000640004047a10ULL, 0x000fe20007f3e0ffULL,
0x000000100e1d7824ULL, 0x100fe200078e021fULL, 0x0000640003067a10ULL, 0x000fe20007f5e0ffULL,
0x00000010101f7824ULL, 0x000fe200078e021fULL, 0x0000650005037a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000b901c46ULL,
0x0000650007057a10ULL, 0x000fc40000ffe4ffULL, 0x0000650009077a10ULL, 0x000fe200017fe4ffULL,
0x00000000020f7faeULL, 0x0003e8000b901c46ULL, 0x00000000041d7faeULL, 0x0003e8000b901c46ULL,
0x00000000061f7faeULL, 0x0003e4000b901c46ULL, 0x00000000130473c2ULL, 0x000ea200000e0000ULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x0001a6a813027811ULL, 0x002fe200078e18ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0001a6a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x000000ffff557224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff207f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200002027f8cULL, 0x000ea2000c80043fULL, 0x000000ffff547224ULL, 0x000fe200078e00ffULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000ea7000008947ULL, 0x000fea0003800000ULL, 0x00000010130e7824ULL, 0x000fe200078e00ffULL,
0x00000002ff107819ULL, 0x000fe2000001161aULL, 0x000000ffff007224ULL, 0x004fc400078e0003ULL,
0xff317217ff237424ULL, 0x000fe200078e00ffULL, 0x000000100e0e7812ULL, 0x000fe200078ee2ffULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fc400078e00ffULL,
0x000000ffff0c7224ULL, 0x02afca00078e00ffULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x000000041a087824ULL, 0x000fca00078e00ffULL, 0xfffffff808087812ULL, 0x000fc800078ec0ffULL,
0x0001a6c8080d7810ULL, 0x000fe20007ffe0ffULL, 0x01a6cc00080b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe40007804800ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a021d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e03ULL,
0x003d09001d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000001d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01a6cc00080b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010f007810ULL, 0x040fe20007ffe0ffULL, 0x000001000f0c7824ULL, 0x000fc600078e0275ULL,
0x000000150000720cULL, 0x000fe40003f46070ULL, 0x000000400c037810ULL, 0x000fca0007ffe0ffULL,
0x0000680012087a24ULL, 0x000fcc00078e0203ULL, 0x000004000000a947ULL, 0x000fea0003800000ULL,
0x00000003ff0a7819ULL, 0x000fe20000011617ULL, 0x00000010110b7824ULL, 0x000fe200078e00ffULL,
0x0000000316007217ULL, 0x000fe40007800000ULL, 0x000000080a1d7810ULL, 0x040fe20007ffe0ffULL,
0x000000010b027824ULL, 0x040fe200078e020aULL, 0x0000000c0a207810ULL, 0x002fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe400078e0a03ULL, 0x00000001021c7824ULL, 0x040fe400078e0217ULL,
0x0000000802277824ULL, 0x000fe200078e00ffULL, 0x000000000b007217ULL, 0x000fe20007800000ULL,
0x0000001017037824ULL, 0x000fc400078e00ffULL, 0x0000000102027824ULL, 0x000fe200078e0208ULL,
0xfffffff827277812ULL, 0x000fe200078ee21cULL, 0x0000000100007824ULL, 0x000fe200078e0a0bULL,
0x000000040a1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b1f7824ULL, 0x000fe200078e021dULL,
0x0000007003257812ULL, 0x000fe200078ec0ffULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0x000000000a00720cULL, 0x080fe40003fa6070ULL, 0x000000001c00720cULL, 0x080fe20003f86070ULL,
0x000000010b1e7824ULL, 0x040fe200078e021cULL, 0x00000025021c7212ULL, 0x000fe200078efcffULL,
0x000000010b227824ULL, 0x000fe200078e0220ULL, 0x000000001d00720cULL, 0x080fe20003f66070ULL,
0x000000011e0a7824ULL, 0x000fe200078e0208ULL, 0x000000002000720cULL, 0x000fe20003f06070ULL,
0x000000011e007824ULL, 0x000fe200078e0217ULL, 0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0x00006500031d7a10ULL, 0x000fe200037fe4ffULL,
0x000000081e697824ULL, 0x000fe200078e00ffULL, 0x000000250a1e7212ULL, 0x080fe200078efcffULL,
0x000000011f027824ULL, 0x100fe400078e0208ULL, 0x00000001220a7824ULL, 0x000fe200078e0208ULL,
0x000064001e1e7a10ULL, 0x000fe20007fde0ffULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0xfffffff869697812ULL, 0x000fe400078ee200ULL, 0x0001700013007811ULL, 0x000fe200078e68ffULL,
0x000000011f207824ULL, 0x040fe200078e0217ULL, 0x0000002502027212ULL, 0x000fe200078efcffULL,
0x000000081f6b7824ULL, 0x000fe200078e00ffULL, 0x000065000b1f7a10ULL, 0x000fe200037fe4ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000640002027a10ULL, 0x000fc40007fde0ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee220ULL, 0x0000000122087824ULL, 0x000fe200078e0217ULL,
0x000000250a0a7212ULL, 0x000fe200078efcffULL, 0x00000008226d7824ULL, 0x000fe200078e00ffULL,
0x0000650003037a10ULL, 0x000fe200037fe4ffULL, 0x0000001027257824ULL, 0x100fe200078e0200ULL,
0x000064000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x0000001069277824ULL, 0x000fe200078e0200ULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee208ULL, 0x000000106b697824ULL, 0x100fe200078e0200ULL,
0x000065000b0b7a10ULL, 0x000fe200037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c257faeULL, 0x0003e4000e901c46ULL, 0x000000106d6b7824ULL, 0x000fc400078e0200ULL,
0x000000001e277faeULL, 0x0003e8000e101c46ULL, 0x0000000002697faeULL, 0x0003e8000d901c46ULL,
0x000000000a6b7faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001011007824ULL, 0x000fe400078e00ffULL, 0x0000001017027824ULL, 0x000fc600078e00ffULL,
0x0000000017007211ULL, 0x000fe400078fe8ffULL, 0x0000007002697812ULL, 0x000fe400078ec0ffULL,
0x0000000c001f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000100037824ULL, 0x040fe200078e0217ULL,
0x00000008001d7810ULL, 0x040fe20007ffe0ffULL, 0x00000008000a7824ULL, 0x040fe400078e00ffULL,
0x0000000100027824ULL, 0x000fe400078e0208ULL, 0x000000081f6d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a257812ULL, 0x000fe200078ee203ULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0x00000004000a7810ULL, 0x000fc60007ffe0ffULL, 0x000000011f1c7824ULL, 0x040fe200078e0208ULL,
0x00000069021e7212ULL, 0x000fe200078efcffULL, 0x000000011f027824ULL, 0x100fe400078e0217ULL,
0x000000010a0b7824ULL, 0x000fe200078e0217ULL, 0x000064001e1e7a10ULL, 0x000fe20007f1e0ffULL,
0x000000080a207824ULL, 0x042fe200078e00ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee202ULL,
0x000000010a007824ULL, 0x100fe200078e0208ULL, 0x00006500031f7a10ULL, 0x000fe200007fe4ffULL,
0x000000011d0a7824ULL, 0x000fe200078e0208ULL, 0xfffffff820277812ULL, 0x000fe200078ee20bULL,
0x0000008000027825ULL, 0x000fc800078e00ffULL, 0x000000011d087824ULL, 0x040fe200078e0217ULL,
0x0000006902027212ULL, 0x080fe200078efcffULL, 0x000000081d6b7824ULL, 0x000fe400078e00ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000640002027a10ULL, 0x000fe40007f1e0ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee208ULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000690a0a7212ULL, 0x000fe400078efcffULL, 0x0001700013087811ULL, 0x000fc400078e68ffULL,
0x000000691c1c7212ULL, 0x000fe400078efcffULL, 0x000064000a0a7a10ULL, 0x000fe20007f7e0ffULL,
0x0000001025257824ULL, 0x100fe200078e0208ULL, 0x000064001c1c7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001027277824ULL, 0x100fe200078e0208ULL, 0x0000650003037a10ULL, 0x000fe200007fe4ffULL,
0x000000106b697824ULL, 0x100fe200078e0208ULL, 0x000065000b0b7a10ULL, 0x000fe20001ffe4ffULL,
0x000000106d6b7824ULL, 0x000fe200078e0208ULL, 0x000065001d1d7a10ULL, 0x000fe200027fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e257faeULL, 0x0003e8000b901c46ULL,
0x0000000002277faeULL, 0x0003e8000b901c46ULL, 0x000000000a697faeULL, 0x0003e8000b901c46ULL,
0x000000001c6b7faeULL, 0x0003e4000b901c46ULL, 0xfffffff0141f7812ULL, 0x042fe400078ec0ffULL,
0xffffffe014007812ULL, 0x000fc400078ec0ffULL, 0x000000001f0573c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000001014037812ULL, 0x000fca00078ec0ffULL,
0x0000000100007824ULL, 0x000fc800078e0203ULL, 0x00000008111c7824ULL, 0x000fe200078e0200ULL,
0x0001a6b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6b0001f687f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a608001c1c7f8cULL, 0x000ee4000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x00000008140b7812ULL, 0x000fca00078ec0ffULL, 0x0000000100207824ULL, 0x000fca00078e020bULL,
0x01a60c00200b7984ULL, 0x000f240000000800ULL, 0x800000000bff7812ULL, 0x018fe4000780481dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a02257210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e03ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140bULL, 0x0000002500007211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000200007819ULL, 0x000fc8000000120bULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01a60c00200b7984ULL, 0x000ee40000000800ULL, 0x800000000bff7812ULL, 0x008fe4000780481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010170b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011617ULL,
0x000000201a007824ULL, 0x000fc600078e00ffULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0xffffff8000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL,
0x000000000a007210ULL, 0x000fca0007ffe00bULL, 0x01a0000000027984ULL, 0x000ee80000000800ULL,
0x01a2000000037984ULL, 0x0002a20000000800ULL, 0x000000230200720bULL, 0x008fe20003f1d000ULL,
0x0001a2727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x002fc800000e0100ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x00000001ff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x000fd200078e0023ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x0000001a1000720cULL, 0x000fe40003f05270ULL,
0x000000230200720bULL, 0x000fe20003f74000ULL, 0x0001a2427f007947ULL, 0x000fd8000b800000ULL,
0x00000000001d7806ULL, 0x000fc400018e0100ULL, 0x000000801a258824ULL, 0x000fe200078e020bULL,
0x00000023021e7209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a258824ULL, 0x000fca00078e0225ULL, 0x01a4001e25008388ULL, 0x0003e20000000800ULL,
0x000000ff1d00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x000000231e087221ULL, 0x002fe20000010100ULL, 0x000000ff1dff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL,
0x0000000800277308ULL, 0x000e640000000800ULL, 0x0000002724247220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x0001a1927f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe40000410000ULL, 0x0000002665657220ULL, 0x080fe40000410000ULL,
0x0000002660607220ULL, 0x080fe40000410000ULL, 0x0000002661617220ULL, 0x080fe40000410000ULL,
0x000000265c5c7220ULL, 0x080fe40000410000ULL, 0x000000265d5d7220ULL, 0x000fc40000410000ULL,
0x0000002658587220ULL, 0x080fe40000410000ULL, 0x0000002659597220ULL, 0x080fe40000410000ULL,
0x0000002654547220ULL, 0x080fe40000410000ULL, 0x0000002655557220ULL, 0x080fe40000410000ULL,
0x0000002650507220ULL, 0x080fe40000410000ULL, 0x0000002651517220ULL, 0x000fc40000410000ULL,
0x000000264c4c7220ULL, 0x080fe40000410000ULL, 0x000000264d4d7220ULL, 0x080fe40000410000ULL,
0x0000002648487220ULL, 0x080fe40000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001dff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x0001a0727f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x00066400000e0000ULL, 0x0000002666667220ULL, 0x086fe40000410000ULL,
0x0000002667677220ULL, 0x080fe40000410000ULL, 0x0000002662627220ULL, 0x080fe40000410000ULL,
0x0000002663637220ULL, 0x080fe40000410000ULL, 0x000000265e5e7220ULL, 0x080fe40000410000ULL,
0x000000265f5f7220ULL, 0x000fc40000410000ULL, 0x000000265a5a7220ULL, 0x080fe40000410000ULL,
0x000000265b5b7220ULL, 0x080fe40000410000ULL, 0x0000002656567220ULL, 0x080fe40000410000ULL,
0x0000002657577220ULL, 0x080fe40000410000ULL, 0x0000002652527220ULL, 0x080fe40000410000ULL,
0x0000002653537220ULL, 0x000fc40000410000ULL, 0x000000264e4e7220ULL, 0x080fe40000410000ULL,
0x000000264f4f7220ULL, 0x080fe40000410000ULL, 0x000000264a4a7220ULL, 0x080fe40000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00001dff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x00019f527f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe40000410000ULL, 0x0000002645457220ULL, 0x080fe40000410000ULL,
0x0000002640407220ULL, 0x080fe40000410000ULL, 0x0000002641417220ULL, 0x080fe40000410000ULL,
0x000000263c3c7220ULL, 0x080fe40000410000ULL, 0x000000263d3d7220ULL, 0x000fc40000410000ULL,
0x0000002638387220ULL, 0x080fe40000410000ULL, 0x0000002639397220ULL, 0x080fe40000410000ULL,
0x0000002634347220ULL, 0x080fe40000410000ULL, 0x0000002635357220ULL, 0x080fe40000410000ULL,
0x0000002630307220ULL, 0x080fe40000410000ULL, 0x0000002631317220ULL, 0x000fc40000410000ULL,
0x000000262c2c7220ULL, 0x080fe40000410000ULL, 0x000000262d2d7220ULL, 0x080fe40000410000ULL,
0x0000002628287220ULL, 0x080fe40000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000001dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x00019e427f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe40000410000ULL, 0x0000002647477220ULL, 0x080fe40000410000ULL,
0x0000002642427220ULL, 0x080fe40000410000ULL, 0x0000002643437220ULL, 0x080fe40000410000ULL,
0x000000263e3e7220ULL, 0x080fe40000410000ULL, 0x000000263f3f7220ULL, 0x000fc40000410000ULL,
0x000000263a3a7220ULL, 0x080fe40000410000ULL, 0x000000263b3b7220ULL, 0x080fe40000410000ULL,
0x0000002636367220ULL, 0x080fe40000410000ULL, 0x0000002637377220ULL, 0x080fe40000410000ULL,
0x0000002632327220ULL, 0x080fe40000410000ULL, 0x0000002633337220ULL, 0x000fc40000410000ULL,
0x000000262e2e7220ULL, 0x080fe40000410000ULL, 0x000000262f2f7220ULL, 0x080fe40000410000ULL,
0x000000262a2a7220ULL, 0x080fe40000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000001d00ff7212ULL, 0x000fda00078030ffULL,
0x8000001e02020221ULL, 0x000fe20000010000ULL, 0x00007610ff220816ULL, 0x000fc60000000022ULL,
0x3fb8aa3b02020820ULL, 0x000fc80000410000ULL, 0x0000000200090308ULL, 0x000e640000000800ULL,
0x0000000903030220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002403247221ULL, 0x004fc40000010000ULL, 0x0000000000027805ULL, 0x000fca0000015200ULL,
0x01a6ac001f007984ULL, 0x000e620000000800ULL, 0x0001a6a81f087810ULL, 0x000fe40007ffe0ffULL,
0x8000000000ff7812ULL, 0x002fe20007804821ULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c02237210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e03ULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001141dULL,
0x0000002300007211ULL, 0x000fca00078110ffULL, 0x000000ffff1d7224ULL, 0x000fca00000e061dULL,
0x0000000200007819ULL, 0x000fc8000000121dULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6ac001f007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991022007816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff027819ULL, 0x000fe40000011617ULL, 0x0000541000277816ULL, 0x008fe20000000000ULL,
0x00019a127f007947ULL, 0x000fea000b800000ULL, 0x00001f0227077589ULL, 0x0002a400000e0000ULL,
0x0000000802267810ULL, 0x000fe20007ffe0ffULL, 0x00019a527f007947ULL, 0x000fea000b800000ULL,
0x0000001002007810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0027057589ULL, 0x0006a400000e0000ULL, 0x0000001802267810ULL, 0x008fe20007ffe0ffULL,
0x00019ac27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000413227824ULL, 0x000fe200078e00ffULL,
0x0000000817007812ULL, 0x000fe200078ec0ffULL, 0x000004001a1d7824ULL, 0x000fe200078e00ffULL,
0x00000004ff267819ULL, 0x108fe20000011617ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000422227812ULL, 0x000fe200078ec0ffULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x0000000700037812ULL, 0x000fe200078ef817ULL, 0x00000004111f7824ULL, 0x000fe200078e0226ULL,
0x0000002217007211ULL, 0x000fc400078fe0ffULL, 0x0000001003027812ULL, 0x042fe200078efcffULL,
0x0000000803217824ULL, 0x040fe400078e00ffULL, 0x00000001031c7824ULL, 0x000fe400078e0200ULL,
0x0000000100007824ULL, 0x000fe400078e0202ULL, 0x0000000802237824ULL, 0x000fe200078e00ffULL,
0xfffffff8211c7812ULL, 0x000fe200078ee21cULL, 0x00000008036a7824ULL, 0x000fe200078e00ffULL,
0xfffff0001d217812ULL, 0x000fc400078ec0ffULL, 0xfffffff8231d7812ULL, 0x000fe200078ee200ULL,
0x0000000103237824ULL, 0x000fe200078e021fULL, 0x0001200021217810ULL, 0x000fe40007ffe0ffULL,
0x0001600013007811ULL, 0x000fe400078e68ffULL, 0xfffffff86a257812ULL, 0x000fe200078ee223ULL,
0x000000101c707824ULL, 0x100fe200078e0221ULL, 0x0000000223237810ULL, 0x000fe20007ffe0ffULL,
0x000000101d6c7824ULL, 0x000fe400078e0221ULL, 0x0000001025257824ULL, 0x000fc400078e0200ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000006c6c783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000770707231ULL, 0x086fe400003400ffULL,
0x0000000772727231ULL, 0x000fe400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fc400003400ffULL, 0x000000056c6c7231ULL, 0x088fe400003400ffULL,
0x000000056e6e7231ULL, 0x000fe400003400ffULL, 0x000000046d6d7231ULL, 0x080fe400003400ffULL,
0x000000046f6f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff86a237812ULL, 0x000fe200078ee223ULL, 0x00000000257c783bULL, 0x000f220000004200ULL,
0x00000001021f7824ULL, 0x000fe200078e021fULL, 0x0000105000007945ULL, 0x000fe40003800000ULL,
0x0000001023237824ULL, 0x000fca00078e0200ULL, 0x000000002378783bULL, 0x000ee20000004200ULL,
0x000001007c917824ULL, 0x010fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe2000001147eULL,
0x000001007d947824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe2000001147cULL,
0x0000007c006a7306ULL, 0x000fe20000009400ULL, 0x00000018ff917819ULL, 0x000fe20000011491ULL,
0x000001007ea77824ULL, 0x000fe200078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe20000011494ULL,
0x000001007fab7824ULL, 0x000fe200078e00ffULL, 0x00000018ff927819ULL, 0x008fe20000011479ULL,
0x0000010078b97824ULL, 0x000fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe2000001147fULL,
0x0000008100ac7306ULL, 0x000fe20000209400ULL, 0x00000018ffa07819ULL, 0x000fe2000001147bULL,
0x0000010079bc7824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fc4000001147dULL,
0x00000018ff977819ULL, 0x000fe4000001147aULL, 0x00000018ffa77819ULL, 0x000fe200000114a7ULL,
0x0000008100ad7306ULL, 0x000fe20000205400ULL, 0x00000018ffb07819ULL, 0x000fe400000114abULL,
0x00000018ffb97819ULL, 0x000fe400000114b9ULL, 0x00000018ffc27819ULL, 0x000fc600000114bcULL,
0x00000081008d7306ULL, 0x000ff0000020d400ULL, 0x0000009200c67306ULL, 0x000ff00000209400ULL,
0x0000009200c77306ULL, 0x000ff00000205400ULL, 0x0000009200817306ULL, 0x000ff0000020d400ULL,
0x0000009100927306ULL, 0x000ff00000209400ULL, 0x0000009100937306ULL, 0x000ef00000205400ULL,
0x0000002500967306ULL, 0x000ff00000209400ULL, 0x0000002500997306ULL, 0x000fe20000205400ULL,
0x000000939200720bULL, 0x008fce0003fbd000ULL, 0x0000002500987306ULL, 0x0007f0000020d400ULL,
0x0000007c006b7306ULL, 0x000f220000005400ULL, 0x00000018ff257819ULL, 0x008fce0000011478ULL,
0x0000007c00767306ULL, 0x0006b0000000d400ULL, 0x0000009d009e7306ULL, 0x000fe20000209400ULL,
0x000100007c7c7824ULL, 0x008fe200078e00ffULL, 0x0000006b6a00720bULL, 0x010fe20003fdd000ULL,
0x000001007a6a7824ULL, 0x000fc400078e00ffULL, 0x000001007b6b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000009d009f7306ULL, 0x000ee20000205400ULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x00000018ff6b7819ULL, 0x000fc8000001146bULL,
0x0000000176766812ULL, 0x004fe200078efcffULL, 0x0000008600b57306ULL, 0x000fe20000209400ULL,
0x000000999600720bULL, 0x000fce0003fdd000ULL, 0x0000008600b87306ULL, 0x000fe20000205400ULL,
0x0000009f9e00720bULL, 0x008fca0003f7d000ULL, 0x0000000198986812ULL, 0x000fe400078efcffULL,
0x0000008600857306ULL, 0x000ff0000020d400ULL, 0x0000002500be7306ULL, 0x000ff00000209400ULL,
0x0000002500bf7306ULL, 0x000ff00000205400ULL, 0x0000002500837306ULL, 0x000ff0000020d400ULL,
0x0000007d009a7306ULL, 0x000ff00000009400ULL, 0x0000007d009b7306ULL, 0x000eb00000005400ULL,
0x000000a000877306ULL, 0x000ff00000209400ULL, 0x000000a000867306ULL, 0x000fe20000205400ULL,
0x0000009b9a00720bULL, 0x004fce0003f9d000ULL, 0x000000a000257306ULL, 0x0005f0000020d400ULL,
0x0000008000a37306ULL, 0x000fe20000209400ULL, 0x000100007da07824ULL, 0x004fca00078e00ffULL,
0x00000018ffa07819ULL, 0x000fe400000114a0ULL, 0x0000008000a67306ULL, 0x000ff00000205400ULL,
0x0000008000777306ULL, 0x000ff0000020d400ULL, 0x0000009700887306ULL, 0x000ff00000209400ULL,
0x0000009700897306ULL, 0x000ff00000205400ULL, 0x0000009700807306ULL, 0x000ff0000020d400ULL,
0x0000009100957306ULL, 0x000eb0000020d400ULL, 0x0000007c00947306ULL, 0x000ff00000209400ULL,
0x0000007c00977306ULL, 0x000ee20000205400ULL, 0x0000000195955812ULL, 0x004fce00078efcffULL,
0x0000009d00a17306ULL, 0x000eb0000020d400ULL, 0x000000a000917306ULL, 0x000fe20000209400ULL,
0x000000979400720bULL, 0x008fce0003fbd000ULL, 0x000000a000a27306ULL, 0x000ee20000205400ULL,
0x00000001a1a13812ULL, 0x004fce00078efcffULL, 0x0000007d009c7306ULL, 0x000eb0000000d400ULL,
0x0000007c007d7306ULL, 0x000f22000020d400ULL, 0x000000a29100720bULL, 0x008fce0003f7d000ULL,
0x000000a7009d7306ULL, 0x000fe20000209400ULL, 0x000000019c9c4812ULL, 0x004fe400078efcffULL,
0x000000a6a300720bULL, 0x000fca0003f9d000ULL, 0x000000a700aa7306ULL, 0x000ea20000205400ULL,
0x000000017d7d5812ULL, 0x010fce00078efcffULL, 0x000000a000a47306ULL, 0x000ee2000020d400ULL,
0x0000000177774812ULL, 0x000fce00078efcffULL, 0x0000007e00a57306ULL, 0x000fe20000009400ULL,
0x000000aa9d00720bULL, 0x004fce0003fbd000ULL, 0x0000007e00a87306ULL, 0x000ea20000005400ULL,
0x00000001a4a43812ULL, 0x008fc800078efcffULL, 0x000000a47777723eULL, 0x000fc600000010ffULL,
0x0000007e00907306ULL, 0x000730000000d400ULL, 0x000000b000b17306ULL, 0x000fe20000209400ULL,
0x000100007e7e7824ULL, 0x008fe200078e00ffULL, 0x000000a8a500720bULL, 0x004fc80003fdd000ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x000000b000b27306ULL, 0x000eae0000205400ULL,
0x0000000190906812ULL, 0x010fe200078efcffULL, 0x0000007f00ae7306ULL, 0x000fe20000009400ULL,
0x000000adac00720bULL, 0x000fce0003fdd000ULL, 0x0000007f00af7306ULL, 0x000ee20000005400ULL,
0x000000b2b100720bULL, 0x004fca0003f7d000ULL, 0x000000018d8d6812ULL, 0x000fe400078efcffULL,
0x0000007f008c7306ULL, 0x000530000000d400ULL, 0x000000a700a97306ULL, 0x000e62000020d400ULL,
0x000100007f7f7824ULL, 0x004fe200078e00ffULL, 0x000000afae00720bULL, 0x008fc80003f9d000ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000007e007c7306ULL, 0x000fee0000209400ULL,
0x000000018c8c4812ULL, 0x010fe200078efcffULL, 0x0000007e00ab7306ULL, 0x000ea20000205400ULL,
0x00000001a9a95812ULL, 0x002fc400078efcffULL, 0x000000b8b500720bULL, 0x000fca0003f9d000ULL,
0x000000b000b37306ULL, 0x000e70000020d400ULL, 0x0000007f00a77306ULL, 0x000fe20000209400ULL,
0x000000ab7c00720bULL, 0x004fe40003fbd000ULL, 0x0000000185854812ULL, 0x000fca00078efcffULL,
0x0000007f00b47306ULL, 0x000ea20000205400ULL, 0x00000001b3b33812ULL, 0x002fce00078efcffULL,
0x0000007e00a07306ULL, 0x000e70000020d400ULL, 0x000000b900b07306ULL, 0x000fe20000209400ULL,
0x000000b4a700720bULL, 0x004fce0003f7d000ULL, 0x000000b900bb7306ULL, 0x000ea20000205400ULL,
0x00000001a0a05812ULL, 0x002fce00078efcffULL, 0x0000007f00b67306ULL, 0x000e70000020d400ULL,
0x0000007800b77306ULL, 0x000fe20000009400ULL, 0x000000bbb000720bULL, 0x004fce0003fbd000ULL,
0x0000007800ba7306ULL, 0x000ea20000005400ULL, 0x00000001b6b63812ULL, 0x002fce00078efcffULL,
0x0000007800847306ULL, 0x0002f0000000d400ULL, 0x000000c200c37306ULL, 0x000fe20000209400ULL,
0x0001000078787824ULL, 0x002fe200078e00ffULL, 0x000000bab700720bULL, 0x004fc80003fdd000ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x000000c200c47306ULL, 0x000e6e0000205400ULL,
0x0000000184846812ULL, 0x008fe200078efcffULL, 0x0000007900c07306ULL, 0x000fe20000009400ULL,
0x000000bfbe00720bULL, 0x000fce0003fdd000ULL, 0x0000007900c17306ULL, 0x000ea20000005400ULL,
0x000000c4c300720bULL, 0x002fca0003f7d000ULL, 0x0000000183836812ULL, 0x000fe400078efcffULL,
0x0000007900827306ULL, 0x0002f0000000d400ULL, 0x000000b900bd7306ULL, 0x000f22000020d400ULL,
0x0001000079797824ULL, 0x002fe200078e00ffULL, 0x000000c1c000720bULL, 0x004fc80003f9d000ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000078007e7306ULL, 0x000fee0000209400ULL,
0x0000000182824812ULL, 0x008fe200078efcffULL, 0x00000078007f7306ULL, 0x000e620000205400ULL,
0x00000001bdbd5812ULL, 0x010fc800078efcffULL, 0x00000084bd84723eULL, 0x000fc600000010ffULL,
0x000000c200c57306ULL, 0x000eb0000020d400ULL, 0x0000007900927306ULL, 0x000fe20000209400ULL,
0x0000007f7e00720bULL, 0x002fce0003fbd000ULL, 0x0000007900937306ULL, 0x000e620000205400ULL,
0x00000001c5c53812ULL, 0x004fe400078efcffULL, 0x000000c7c600720bULL, 0x000fca0003f7d000ULL,
0x0000007800bc7306ULL, 0x000eb0000020d400ULL, 0x0000007900947306ULL, 0x000ee2000020d400ULL,
0x000000939200720bULL, 0x002fe40003f9d000ULL, 0x0000000181813812ULL, 0x000fca00078efcffULL,
0x0000006a00787306ULL, 0x000fe20000209400ULL, 0x00000001bcbc5812ULL, 0x004fc800078efcffULL,
0x000000bc83bc723eULL, 0x000fc600000010ffULL, 0x0000006a00797306ULL, 0x000e620000205400ULL,
0x0000000194944812ULL, 0x008fc800078efcffULL, 0x0000009481bd723eULL, 0x000fc600000010ffULL,
0x0000007a008e7306ULL, 0x000fe80000009400ULL, 0x000000bc7050723cULL, 0x080f680000041850ULL,
0x0000007a008f7306ULL, 0x000ea20000005400ULL, 0x000000797800720bULL, 0x002fe40003fbd000ULL,
0x0000008cb379723eULL, 0x000fe200000010ffULL, 0x000000bc6c30723cULL, 0x000f620000041830ULL,
0x00000090a978723eULL, 0x000fc600000010ffULL, 0x0000007b008a7306ULL, 0x000fe80000009400ULL,
0x00000078705c723cULL, 0x000f68000004185cULL, 0x0000007b008b7306ULL, 0x000e620000005400ULL,
0x0000008f8e00720bULL, 0x004fc60003fdd000ULL, 0x000000786c3c723cULL, 0x000f68000004183cULL,
0x0000007b00237306ULL, 0x0004f0000000d400ULL, 0x0000006b00917306ULL, 0x000fe20000209400ULL,
0x000100007b7b7824ULL, 0x004fe200078e00ffULL, 0x0000008b8a00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff927819ULL, 0x000fe4000001147bULL, 0x0000006b009a7306ULL, 0x000e620000205400ULL,
0x000000b6857b723eULL, 0x000fe400000010ffULL, 0x00000082c585723eULL, 0x000fc800000010ffULL,
0x0000000123233812ULL, 0x008fe200078efcffULL, 0x0000007a00277306ULL, 0x0004e4000000d400ULL,
0x000000847054723cULL, 0x080f6c0000041854ULL, 0x0000009200937306ULL, 0x000fe20000209400ULL,
0x000100007a7a7824ULL, 0x004fe200078e00ffULL, 0x0000009a9100720bULL, 0x002fe20003f9d000ULL,
0x000000846c34723cULL, 0x000f660000041834ULL, 0x00000018ff7c7819ULL, 0x000fc4000001147aULL,
0x00000092008c7306ULL, 0x000e620000205400ULL, 0x0000000127276812ULL, 0x008fe400078efcffULL,
0x000000868700720bULL, 0x000fe40003fdd000ULL, 0x000000a08d7a723eULL, 0x000fc600000010ffULL,
0x0000006b009e7306ULL, 0x0004e8000020d400ULL, 0x0000007a7058723cULL, 0x080f680000041858ULL,
0x0000006a00967306ULL, 0x0008e2000020d400ULL, 0x0000008c9300720bULL, 0x002fe40003f7d000ULL,
0x0000000125256812ULL, 0x000fe200078efcffULL, 0x0000007a6c38723cULL, 0x000f620000041838ULL,
0x0000009ca16b723eULL, 0x004fc600000010ffULL, 0x0000007c007e7306ULL, 0x000fe20000209400ULL,
0x00000076956a723eULL, 0x010fe400000010ffULL, 0x000000019e9e4812ULL, 0x008fe400078efcffULL,
0x0000007d9876723eULL, 0x000fe400000010ffULL, 0x000000239e97723eULL, 0x000fe200000010ffULL,
0x0000007c007f7306ULL, 0x000e620000205400ULL, 0x0000000196965812ULL, 0x000fe200078efcffULL,
0x0000006a7064723cULL, 0x000f620000041864ULL, 0x000000898800720bULL, 0x000fc40003fbd000ULL,
0x0000000222237812ULL, 0x000fe400078efcffULL, 0x000000279696723eULL, 0x000fe200000010ffULL,
0x0000009200927306ULL, 0x000ea4000020d400ULL, 0x0000000126237824ULL, 0x000fe200078e0223ULL,
0x0000006a6c44723cULL, 0x000b620000041844ULL, 0x0000000802267824ULL, 0x000fe400078e00ffULL,
0x0000000103227824ULL, 0x100fe400078e0223ULL, 0x0000007c007d7306ULL, 0x000ee2000020d400ULL,
0x0000007f7e00720bULL, 0x002fe20003f9d000ULL, 0x0000000102237824ULL, 0x000fe200078e0223ULL,
0x0000000180805812ULL, 0x000fe200078efcffULL, 0x00000008026a7824ULL, 0x020fe200078e00ffULL,
0x000000767060723cULL, 0x000f640000041860ULL, 0xfffffff826267812ULL, 0x000fc400078ee223ULL,
0x0000000192923812ULL, 0x004fc600078efcffULL, 0x0000001026267824ULL, 0x000fe200078e0221ULL,
0x000000922581723eULL, 0x000fe200000010ffULL, 0x0000000803257824ULL, 0x000fe200078e00ffULL,
0x00000096704c723cULL, 0x000f62000004184cULL, 0x000000017d7d4812ULL, 0x008fc600078efcffULL,
0xfffffff825227812ULL, 0x000fe400078ee222ULL, 0x0000007d8080723eULL, 0x000fe400000010ffULL,
0x000000766c40723cULL, 0x000f620000041840ULL, 0x0000001022227824ULL, 0x000fe200078e0221ULL,
0xfffffff86a217812ULL, 0x000fe400078ee21fULL, 0x000000021f1f7810ULL, 0x000fc60007ffe0ffULL,
0x0000001021217824ULL, 0x000fe200078e0200ULL, 0x000000807048723cULL, 0x000b640000041848ULL,
0x000000002270783bULL, 0x0202ac0000000200ULL, 0x000000966c2c723cULL, 0x040f70000004182cULL,
0x000000806c28723cULL, 0x000b640000041828ULL, 0x00000000266c783bULL, 0x0202e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000770707231ULL, 0x084fe400003400ffULL, 0x0000000772727231ULL, 0x000fc400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fe400003400ffULL,
0x000000056c6c7231ULL, 0x088fe400003400ffULL, 0x000000056e6e7231ULL, 0x000fe400003400ffULL,
0x000000046d6d7231ULL, 0x080fe400003400ffULL, 0x000000046f6f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff86a1f7812ULL, 0x000fe200078ee21fULL,
0x000000002178783bULL, 0x000f280000004200ULL, 0x000000101f1f7824ULL, 0x000fca00078e0200ULL,
0x000000001f7c783bULL, 0x000e640000004200ULL, 0x0000007800227306ULL, 0x012fe20000009400ULL,
0x00000018ff217819ULL, 0x000fe20000011478ULL, 0x00000100788b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011479ULL, 0x00000100798e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe2000001147bULL, 0x000001007aa17824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001147aULL, 0x0000007800237306ULL, 0x000e620000005400ULL,
0x00000018ff917819ULL, 0x000fe2000001147eULL, 0x000001007ba57824ULL, 0x000fe200078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe2000001147fULL, 0x000001007cb37824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe2000001148eULL, 0x000001007db67824ULL, 0x000fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001147dULL, 0x00000078008a7306ULL, 0x0008e2000000d400ULL,
0x00000018ff8b7819ULL, 0x000fc4000001148bULL, 0x00000018ffa17819ULL, 0x000fe400000114a1ULL,
0x00000018ffaa7819ULL, 0x000fe400000114a5ULL, 0x00000018ffb37819ULL, 0x000fe200000114b3ULL,
0x0000002100907306ULL, 0x000fe20000209400ULL, 0x0001000078787824ULL, 0x010fe200078e00ffULL,
0x000000232200720bULL, 0x002fe20003f7d000ULL, 0x000001007e227824ULL, 0x000fe200078e00ffULL,
0x00000018ffbc7819ULL, 0x000fe200000114b6ULL, 0x000001007f237824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fc40000011478ULL, 0x0000002100937306ULL, 0x000fe20000205400ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x00000018ff237819ULL, 0x000fc80000011423ULL,
0x000000018a8a3812ULL, 0x008fe200078efcffULL, 0x0000002100927306ULL, 0x0003f0000020d400ULL,
0x00000026009d7306ULL, 0x000fe20000209400ULL, 0x00000018ff217819ULL, 0x002fce000001147cULL,
0x0000002600a07306ULL, 0x000ff00000205400ULL, 0x0000002600897306ULL, 0x000ff0000020d400ULL,
0x0000009100817306ULL, 0x000ff00000209400ULL, 0x0000009100847306ULL, 0x000ff00000205400ULL,
0x0000009100267306ULL, 0x000ff0000020d400ULL, 0x0000008200af7306ULL, 0x000ff00000209400ULL,
0x0000008200b27306ULL, 0x000ff00000205400ULL, 0x0000008200777306ULL, 0x000ff0000020d400ULL,
0x0000002100b87306ULL, 0x000ff00000209400ULL, 0x0000002100b97306ULL, 0x000ff00000205400ULL,
0x00000021006b7306ULL, 0x000ff0000020d400ULL, 0x00000078008e7306ULL, 0x000ff00000209400ULL,
0x0000007800917306ULL, 0x000e700000205400ULL, 0x0000009a00857306ULL, 0x000ff00000209400ULL,
0x0000009a00827306ULL, 0x000fe20000205400ULL, 0x000000918e00720bULL, 0x002fce0003fdd000ULL,
0x0000009a00217306ULL, 0x0003f0000020d400ULL, 0x0000006a00a67306ULL, 0x000fe20000209400ULL,
0x00010000799a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe4000001149aULL,
0x0000006a00a77306ULL, 0x000ff00000205400ULL, 0x0000006a00877306ULL, 0x000ff0000020d400ULL,
0x0000008c00bf7306ULL, 0x000ff00000209400ULL, 0x0000008c00c47306ULL, 0x000ff00000205400ULL,
0x0000008c006a7306ULL, 0x000ff0000020d400ULL, 0x0000007900947306ULL, 0x000ff00000009400ULL,
0x0000007900957306ULL, 0x000e700000005400ULL, 0x0000008b008c7306ULL, 0x000ff00000209400ULL,
0x0000008b008d7306ULL, 0x000ee20000205400ULL, 0x000000959400720bULL, 0x002fce0003f9d000ULL,
0x0000008b008f7306ULL, 0x000e70000020d400ULL, 0x0000009a008b7306ULL, 0x000fe20000209400ULL,
0x0000008d8c00720bULL, 0x008fce0003f1d000ULL, 0x0000009a009c7306ULL, 0x000eec0000205400ULL,
0x000000018f8f0812ULL, 0x002fe400078efcffULL, 0x0000007900967306ULL, 0x000e62000000d400ULL,
0x000000939000720bULL, 0x000fce0003f1d000ULL, 0x0000009700987306ULL, 0x000fe20000209400ULL,
0x0000009c8b00720bULL, 0x008fca0003f7d000ULL, 0x0000000192920812ULL, 0x000fe400078efcffULL,
0x0000009700997306ULL, 0x000ee20000205400ULL, 0x0000000196964812ULL, 0x002fe400078efcffULL,
0x000000a09d00720bULL, 0x000fca0003f9d000ULL, 0x00000097009b7306ULL, 0x000e70000020d400ULL,
0x0000007800797306ULL, 0x000f22000020d400ULL, 0x000000999800720bULL, 0x008fe40003fbd000ULL,
0x0000000189894812ULL, 0x000fca00078efcffULL, 0x000000a100977306ULL, 0x000fec0000209400ULL,
0x000000019b9b5812ULL, 0x002fe400078efcffULL, 0x000000a100a47306ULL, 0x000e620000205400ULL,
0x0000000179796812ULL, 0x010fce00078efcffULL, 0x0000009a009e7306ULL, 0x000ef0000020d400ULL,
0x0000007b00a87306ULL, 0x000fe20000009400ULL, 0x000000a49700720bULL, 0x002fce0003fdd000ULL,
0x0000007b00a97306ULL, 0x000e620000005400ULL, 0x000000019e9e3812ULL, 0x008fce00078efcffULL,
0x000000a100a37306ULL, 0x000ef0000020d400ULL, 0x0000007a009f7306ULL, 0x000fe20000009400ULL,
0x000000a9a800720bULL, 0x002fce0003f7d000ULL, 0x0000007a00a27306ULL, 0x000e620000005400ULL,
0x00000001a3a36812ULL, 0x008fe400078efcffULL, 0x000000a7a600720bULL, 0x000fca0003fdd000ULL,
0x0000007a00887306ULL, 0x0007f0000000d400ULL, 0x0000007b00867306ULL, 0x0008a2000000d400ULL,
0x000100007a7a7824ULL, 0x008fe200078e00ffULL, 0x000000a29f00720bULL, 0x002fc40003fbd000ULL,
0x0000000187876812ULL, 0x000fe400078efcffULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x000000aa00ab7306ULL, 0x000fe20000209400ULL, 0x000100007b7b7824ULL, 0x010fca00078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x000000aa00ac7306ULL, 0x000e620000205400ULL,
0x0000000186863812ULL, 0x004fe400078efcffULL, 0x0000000188885812ULL, 0x000fca00078efcffULL,
0x000000aa00ad7306ULL, 0x000eb0000020d400ULL, 0x0000007a00787306ULL, 0x000fe20000209400ULL,
0x000000acab00720bULL, 0x002fce0003f1d000ULL, 0x0000007a00a57306ULL, 0x000e6c0000205400ULL,
0x00000001adad0812ULL, 0x004fe400078efcffULL, 0x000000b300aa7306ULL, 0x000fe20000209400ULL,
0x000000b2af00720bULL, 0x000fce0003f1d000ULL, 0x000000b300b57306ULL, 0x000ea20000205400ULL,
0x000000a57800720bULL, 0x002fe40003f9d000ULL, 0x000000799278723eULL, 0x000fe400000010ffULL,
0x0000009e8979723eULL, 0x000fe400000010ffULL, 0x0000000177770812ULL, 0x000fe200078efcffULL,
0x0000007b00a17306ULL, 0x000fe80000209400ULL, 0x000000787060723cULL, 0x000b680000041860ULL,
0x0000007b00ae7306ULL, 0x000e620000205400ULL, 0x000000b5aa00720bULL, 0x004fc60003f7d000ULL,
0x000000786c40723cULL, 0x000b680000041840ULL, 0x000000bc00bd7306ULL, 0x000ff00000209400ULL,
0x000000bc00be7306ULL, 0x000ea20000205400ULL, 0x000000aea100720bULL, 0x002fce0003fbd000ULL,
0x0000007c00b17306ULL, 0x000ff00000009400ULL, 0x0000007c00b47306ULL, 0x000fe20000005400ULL,
0x000000bebd00720bULL, 0x004fce0003fdd000ULL, 0x0000007c00767306ULL, 0x0003f0000000d400ULL,
0x0000007d00ba7306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007d00bb7306ULL, 0x000ff00000005400ULL,
0x0000007d00277306ULL, 0x0003f0000000d400ULL, 0x0000007a009a7306ULL, 0x000ea2000020d400ULL,
0x000100007d7d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x0000007b00b07306ULL, 0x000e70000020d400ULL, 0x000000b300b77306ULL, 0x000ee2000020d400ULL,
0x000000019a9a4812ULL, 0x004fc400078efcffULL, 0x000000b4b100720bULL, 0x000fe40003f9d000ULL,
0x0000009a879a723eULL, 0x000fc600000010ffULL, 0x0000007c007a7306ULL, 0x000fe20000209400ULL,
0x00000001b0b05812ULL, 0x002fe400078efcffULL, 0x000000bbba00720bULL, 0x000fca0003fbd000ULL,
0x0000007c007b7306ULL, 0x000e620000205400ULL, 0x00000001b7b73812ULL, 0x008fe400078efcffULL,
0x0000000176764812ULL, 0x000fe400078efcffULL, 0x000000b9b800720bULL, 0x000fe40003f9d000ULL,
0x00000076b776723eULL, 0x000fe200000010ffULL, 0x000000bc00c07306ULL, 0x000ea2000020d400ULL,
0x0000000127275812ULL, 0x000fe400078efcffULL, 0x000000c4bf00720bULL, 0x000fca0003fbd000ULL,
0x0000007d00b37306ULL, 0x000fe20000209400ULL, 0x0000007b7a00720bULL, 0x002fe40003f7d000ULL,
0x000000016b6b4812ULL, 0x000fe400078efcffULL, 0x00000088a37a723eULL, 0x000fe400000010ffULL,
0x00000086ad7b723eULL, 0x000fe200000010ffULL, 0x0000007d00c27306ULL, 0x000e620000205400ULL,
0x00000001c0c06812ULL, 0x004fe400078efcffULL, 0x000000016a6a5812ULL, 0x000fc400078efcffULL,
0x000000848100720bULL, 0x000fe20003fbd000ULL, 0x0000007a705c723cULL, 0x080b64000004185cULL,
0x0000007c00b67306ULL, 0x000eac000020d400ULL, 0x0000007a6c3c723cULL, 0x000b64000004183cULL,
0x00000022007c7306ULL, 0x000fe20000209400ULL, 0x000000c2b300720bULL, 0x002fc40003fdd000ULL,
0x0000000126265812ULL, 0x000fca00078efcffULL, 0x00000022008b7306ULL, 0x000e620000205400ULL,
0x00000001b6b63812ULL, 0x004fc800078efcffULL, 0x000000b66bb6723eULL, 0x000fc600000010ffULL,
0x0000007d008d7306ULL, 0x000eb0000020d400ULL, 0x0000007e00c17306ULL, 0x000fe20000009400ULL,
0x0000008b7c00720bULL, 0x002fce0003f7d000ULL, 0x0000007e00c67306ULL, 0x000e620000005400ULL,
0x000000018d8d6812ULL, 0x004fc800078efcffULL, 0x0000008d6ab7723eULL, 0x000fe400000010ffULL,
0x0001a6c8136a7811ULL, 0x000fe200078e18ffULL, 0x00000023008e7306ULL, 0x000fe80000209400ULL,
0x000000b67050723cULL, 0x000b680000041850ULL, 0x0000002300917306ULL, 0x000ea20000205400ULL,
0x000000c6c100720bULL, 0x002fc60003f1d000ULL, 0x000000b66c30723cULL, 0x000b680000041830ULL,
0x0000007e00257306ULL, 0x0002f0000000d400ULL, 0x0000007f00807306ULL, 0x000fe20000009400ULL,
0x000100007e7e7824ULL, 0x002fe200078e00ffULL, 0x000000918e00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000007f00837306ULL, 0x000e620000005400ULL,
0x0000000125250812ULL, 0x008fce00078efcffULL, 0x0000007f001f7306ULL, 0x0004f0000000d400ULL,
0x00000022008c7306ULL, 0x0008e2000020d400ULL, 0x000100007f7f7824ULL, 0x004fe200078e00ffULL,
0x000000838000720bULL, 0x002fcc0003f9d000ULL, 0x0000002300907306ULL, 0x0002a2000020d400ULL,
0x0000008a8f22723eULL, 0x010fe400000010ffULL, 0x00000018ff8f7819ULL, 0x000fc8000001147fULL,
0x000000011f1f4812ULL, 0x008fe200078efcffULL, 0x0000007e007d7306ULL, 0x000fe20000209400ULL,
0x000000018c8c3812ULL, 0x000fe400078efcffULL, 0x000000828500720bULL, 0x000fe40003f7d000ULL,
0x000000969b23723eULL, 0x002fe400000010ffULL, 0x000000b0779b723eULL, 0x000fe200000010ffULL,
0x0000007e008a7306ULL, 0x000e620000205400ULL, 0x0000000190906812ULL, 0x004fc400078efcffULL,
0x00000027c077723eULL, 0x000fe200000010ffULL, 0x000000227064723cULL, 0x040b620000041864ULL,
0x000000258c8c723eULL, 0x000fe400000010ffULL, 0x0000001f908d723eULL, 0x000fe200000010ffULL,
0x0000008f00897306ULL, 0x000fe20000209400ULL, 0x0000000121213812ULL, 0x000fe200078efcffULL,
0x000000021a1f7824ULL, 0x000fe400078e00ffULL, 0x0000009a7058723cULL, 0x000b660000041858ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ec0ffULL, 0x0000008f007c7306ULL, 0x000ea20000205400ULL,
0x0000008a7d00720bULL, 0x002fc60003f1d000ULL, 0x000000767054723cULL, 0x040b680000041854ULL,
0x0000007e007f7306ULL, 0x000e68000020d400ULL, 0x0000008c704c723cULL, 0x000b68000004184cULL,
0x0000008f00807306ULL, 0x000ee2000020d400ULL, 0x0000007c8900720bULL, 0x004fc60003fdd000ULL,
0x000000226c44723cULL, 0x000b620000041844ULL, 0x000000017f7f0812ULL, 0x002fc800078efcffULL,
0x0000007f2626723eULL, 0x000fc600000010ffULL, 0x0000009a6c38723cULL, 0x000b640000041838ULL,
0x0000000180806812ULL, 0x008fc800078efcffULL, 0x000000802127723eULL, 0x000fe400000010ffULL,
0x000000766c34723cULL, 0x000b700000041834ULL, 0x000000267048723cULL, 0x000b700000041848ULL,
0x0000008c6c2c723cULL, 0x040b70000004182cULL, 0x000000266c28723cULL, 0x000b620000041828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000000006a6a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a688001fff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff217224ULL, 0x000fc600078e00ffULL,
0x0000000000227805ULL, 0x020fc80000015200ULL, 0x000004000d1f7984ULL, 0x004ea40000000800ULL,
0x800000001fff7812ULL, 0x006fc4000780486bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002622267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e23ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1f7819ULL, 0x000fc80000011427ULL,
0x000000261f1f7211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x000000021f1f7819ULL, 0x000fc80000001226ULL, 0x0000001f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000121217810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000d1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000800c217810ULL, 0x000fca0007ffe0ffULL, 0x0000680012257a24ULL, 0x000fe200078e0221ULL,
0x000003d00000a947ULL, 0x000fea0003800000ULL, 0x00000021161f7217ULL, 0x000fe20007800000ULL,
0x00000010116e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff277819ULL, 0x000fc60000011617ULL,
0x000000011f1f7824ULL, 0x000fe200078e0a21ULL, 0x00000004276b7810ULL, 0x040fe20007ffe0ffULL,
0x000000016e227824ULL, 0x040fe200078e0227ULL, 0x00000008276d7810ULL, 0x040fe40007ffe0ffULL,
0x0000001f6e1f7217ULL, 0x000fe20007800000ULL, 0x0000000122217824ULL, 0x040fe200078e0217ULL,
0x0000000c276f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000822267824ULL, 0x000fe400078e00ffULL,
0x000000016e707824ULL, 0x000fc400078e026bULL, 0x0000000122227824ULL, 0x000fe200078e0225ULL,
0xfffffff826217812ULL, 0x000fe200078ee221ULL, 0x000000011f1f7824ULL, 0x000fe400078e0a6eULL,
0x0000000170267824ULL, 0x000fe400078e0225ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000001f2700720cULL, 0x080fe40003f06070ULL, 0x0000001f6b00720cULL, 0x000fe20003f86070ULL,
0x000000016e727824ULL, 0x000fe200078e026dULL, 0x0000000b226c7212ULL, 0x000fe200078efcffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000001f6d00720cULL, 0x000fc40003f66070ULL,
0x000064006c6c7a10ULL, 0x000fe20007fbe0ffULL, 0x00000001726a7824ULL, 0x000fe200078e0225ULL,
0x0000000b26267212ULL, 0x000fe200078efcffULL, 0x000000016e6e7824ULL, 0x000fe200078e026fULL,
0x00006500236d7a10ULL, 0x000fe20002ffe4ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000640026267a10ULL, 0x000fe40007fde0ffULL, 0x0000001f6f00720cULL, 0x000fe20003fa6070ULL,
0x000000016e227824ULL, 0x000fe200078e0225ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x0000000170257824ULL, 0x000fe200078e0217ULL, 0x0000650027277a10ULL, 0x000fe200037fe4ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x000064006a6a7a10ULL, 0x000fc60007fde0ffULL,
0x0000000870707824ULL, 0x000fe200078e00ffULL, 0x0000000b22227212ULL, 0x000fe200078efcffULL,
0x00000001721f7824ULL, 0x040fe200078e0217ULL, 0x000065006b6b7a10ULL, 0x000fe200037fe4ffULL,
0x0000000872727824ULL, 0x000fe200078e00ffULL, 0xfffffff870257812ULL, 0x000fe200078ee225ULL,
0x000000016e6f7824ULL, 0x000fe200078e0217ULL, 0x0000640022227a10ULL, 0x000fe20007fde0ffULL,
0x000000086e6e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8721f7812ULL, 0x000fe200078ee21fULL,
0x0000001021217824ULL, 0x100fe200078e0200ULL, 0x0000650023237a10ULL, 0x000fe200037fe4ffULL,
0x0000001025257824ULL, 0x100fe200078e0200ULL, 0xfffffff86e6f7812ULL, 0x000fe200078ee26fULL,
0x000000101f1f7824ULL, 0x100fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c217faeULL, 0x0003e6000c101c46ULL, 0x000000106f6f7824ULL, 0x000fe200078e0200ULL,
0x0000000026257faeULL, 0x0003e8000e101c46ULL, 0x000000006a1f7faeULL, 0x0003e8000d901c46ULL,
0x00000000226f7faeULL, 0x0003e2000e901c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001011227824ULL, 0x000fca00078e00ffULL, 0x0000002217267211ULL, 0x000fc800078fe8ffULL,
0x00000004266a7810ULL, 0x040fe20007ffe0ffULL, 0x00000001261f7824ULL, 0x140fe200078e0217ULL,
0x00000008266c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000826227824ULL, 0x000fe400078e00ffULL,
0x000000016a217824ULL, 0x040fe400078e0217ULL, 0x000000086a6e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8221f7812ULL, 0x000fe200078ee21fULL, 0x000000016c237824ULL, 0x040fe400078e0217ULL,
0x000000086c707824ULL, 0x000fe200078e00ffULL, 0xfffffff86e217812ULL, 0x000fe200078ee221ULL,
0x0000000126227824ULL, 0x140fe200078e0225ULL, 0x0000000c266e7810ULL, 0x000fe20007ffe0ffULL,
0x000000016a267824ULL, 0x000fe200078e0225ULL, 0xfffffff8706f7812ULL, 0x000fe200078ee223ULL,
0x0000008022227825ULL, 0x000fc800078e00ffULL, 0x000000016c6a7824ULL, 0x100fe200078e0225ULL,
0x0000000b22227212ULL, 0x000fe200078efcffULL, 0x000000016e6c7824ULL, 0x000fe400078e0225ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000640022227a10ULL, 0x000fc60007f1e0ffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b26267212ULL, 0x080fe400078efcffULL,
0x0000650023237a10ULL, 0x000fe200007fe4ffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000000b6a6a7212ULL, 0x080fe400078efcffULL, 0x0000640026267a10ULL, 0x000fe20007f7e0ffULL,
0x000000016e257824ULL, 0x000fe200078e0217ULL, 0x0000000b6c6c7212ULL, 0x000fe200078efcffULL,
0x000000086e6e7824ULL, 0x000fe200078e00ffULL, 0x000064006a6a7a10ULL, 0x000fe20007f1e0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0200ULL, 0x000064006c6c7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001021217824ULL, 0x100fe200078e0200ULL, 0xfffffff86e257812ULL, 0x000fe200078ee225ULL,
0x000000106f6f7824ULL, 0x100fe200078e0200ULL, 0x0000650027277a10ULL, 0x000fe20001ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000221f7faeULL, 0x0003e2000b901c46ULL,
0x000065006b6b7a10ULL, 0x000fe200007fe4ffULL, 0x0000001025257824ULL, 0x000fe200078e0200ULL,
0x000065006d6d7a10ULL, 0x000fe200027fe4ffULL, 0x0000000026217faeULL, 0x0003e8000b901c46ULL,
0x000000006a6f7faeULL, 0x0003e8000b901c46ULL, 0x000000006c257faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000080503c2ULL, 0x000e640000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x002fe20008000a05ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000086c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a62800206a7f8cULL, 0x000664000c80043fULL, 0x0000000000227805ULL, 0x000fc40000015200ULL,
0xffffffe0141f7812ULL, 0x040fe400078ec0ffULL, 0x0000001014267812ULL, 0x000fca00078ec0ffULL,
0x000000011f267824ULL, 0x000fc800078e0226ULL, 0x0000000811217824ULL, 0x000fca00078e0226ULL,
0x01a62c00211f7984ULL, 0x000f240000000800ULL, 0x800000001fff7812ULL, 0x012fe4000780486bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002622267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e23ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1f7819ULL, 0x000fc80000011427ULL,
0x000000261f1f7211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x000000021f1f7819ULL, 0x000fc80000001226ULL, 0x0000001f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a62c00211f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201a1f7824ULL, 0x000fca00078e00ffULL, 0xffffff801f227812ULL, 0x000fc800078ec0ffULL,
0x000000800b1f7810ULL, 0x000fca0007ffe022ULL, 0x000000010a1f7824ULL, 0x000fca00078e021fULL,
0x01a000001f217984ULL, 0x000e680000000800ULL, 0x01a200001f227984ULL, 0x0006a20000000800ULL,
0x0000001e2100720bULL, 0x002fe20003f1d000ULL, 0x00016ad27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001f7806ULL, 0x008fc800000e0100ULL, 0x000000ff1f00720cULL, 0x000fe20003f05270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fd200078e001eULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x0000000110237810ULL, 0x000fe40007ffe0ffULL, 0x0000001e2100720bULL, 0x000fe40003f74000ULL,
0x0000001a2300720cULL, 0x000fe20003f05270ULL, 0x00016a927f007947ULL, 0x000fd4000b800000ULL,
0x0000000000707806ULL, 0x000fc400018e0100ULL, 0x000000801a258824ULL, 0x000fe200078e020bULL,
0x0000001e21237209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a268824ULL, 0x000fca00078e0225ULL, 0x01a4002326008388ULL, 0x0003e20000000800ULL,
0x000000ff7000720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000001e231e7221ULL, 0x002fe20000010100ULL, 0x000000ff70ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL,
0x0000001e00277308ULL, 0x000e640000000800ULL, 0x0000002724247220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x000169e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe40000410000ULL, 0x0000002665657220ULL, 0x080fe40000410000ULL,
0x0000002660607220ULL, 0x080fe40000410000ULL, 0x0000002661617220ULL, 0x080fe40000410000ULL,
0x000000265c5c7220ULL, 0x080fe40000410000ULL, 0x000000265d5d7220ULL, 0x000fc40000410000ULL,
0x0000002658587220ULL, 0x080fe40000410000ULL, 0x0000002659597220ULL, 0x080fe40000410000ULL,
0x0000002654547220ULL, 0x080fe40000410000ULL, 0x0000002655557220ULL, 0x080fe40000410000ULL,
0x0000002650507220ULL, 0x080fe40000410000ULL, 0x0000002651517220ULL, 0x000fc40000410000ULL,
0x000000264c4c7220ULL, 0x080fe40000410000ULL, 0x000000264d4d7220ULL, 0x080fe40000410000ULL,
0x0000002648487220ULL, 0x080fe40000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0070ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x000168c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x00066400000e0000ULL, 0x0000002666667220ULL, 0x086fe40000410000ULL,
0x0000002667677220ULL, 0x080fe40000410000ULL, 0x0000002662627220ULL, 0x080fe40000410000ULL,
0x0000002663637220ULL, 0x080fe40000410000ULL, 0x000000265e5e7220ULL, 0x080fe40000410000ULL,
0x000000265f5f7220ULL, 0x000fc40000410000ULL, 0x000000265a5a7220ULL, 0x080fe40000410000ULL,
0x000000265b5b7220ULL, 0x080fe40000410000ULL, 0x0000002656567220ULL, 0x080fe40000410000ULL,
0x0000002657577220ULL, 0x080fe40000410000ULL, 0x0000002652527220ULL, 0x080fe40000410000ULL,
0x0000002653537220ULL, 0x000fc40000410000ULL, 0x000000264e4e7220ULL, 0x080fe40000410000ULL,
0x000000264f4f7220ULL, 0x080fe40000410000ULL, 0x000000264a4a7220ULL, 0x080fe40000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000070ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x000167a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe40000410000ULL, 0x0000002645457220ULL, 0x080fe40000410000ULL,
0x0000002640407220ULL, 0x080fe40000410000ULL, 0x0000002641417220ULL, 0x080fe40000410000ULL,
0x000000263c3c7220ULL, 0x080fe40000410000ULL, 0x000000263d3d7220ULL, 0x000fc40000410000ULL,
0x0000002638387220ULL, 0x080fe40000410000ULL, 0x0000002639397220ULL, 0x080fe40000410000ULL,
0x0000002634347220ULL, 0x080fe40000410000ULL, 0x0000002635357220ULL, 0x080fe40000410000ULL,
0x0000002630307220ULL, 0x080fe40000410000ULL, 0x0000002631317220ULL, 0x000fc40000410000ULL,
0x000000262c2c7220ULL, 0x080fe40000410000ULL, 0x000000262d2d7220ULL, 0x080fe40000410000ULL,
0x0000002628287220ULL, 0x080fe40000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000070ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x000166927f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe40000410000ULL, 0x0000002647477220ULL, 0x080fe40000410000ULL,
0x0000002642427220ULL, 0x080fe40000410000ULL, 0x0000002643437220ULL, 0x080fe40000410000ULL,
0x000000263e3e7220ULL, 0x080fe40000410000ULL, 0x000000263f3f7220ULL, 0x000fc40000410000ULL,
0x000000263a3a7220ULL, 0x080fe40000410000ULL, 0x000000263b3b7220ULL, 0x080fe40000410000ULL,
0x0000002636367220ULL, 0x080fe40000410000ULL, 0x0000002637377220ULL, 0x080fe40000410000ULL,
0x0000002632327220ULL, 0x080fe40000410000ULL, 0x0000002633337220ULL, 0x000fc40000410000ULL,
0x000000262e2e7220ULL, 0x080fe40000410000ULL, 0x000000262f2f7220ULL, 0x080fe40000410000ULL,
0x000000262a2a7220ULL, 0x080fe40000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x000000701fff7212ULL, 0x000fda00078030ffULL,
0x8000002321210221ULL, 0x000fe20000010000ULL, 0x00007610ff6e0816ULL, 0x000fc6000000006eULL,
0x3fb8aa3b21210820ULL, 0x000fc80000410000ULL, 0x0000002100090308ULL, 0x000e640000000800ULL,
0x0000000922220220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002422247221ULL, 0x004fc40000010000ULL, 0x00000000001e7805ULL, 0x000fca0000015200ULL,
0xfffffff0146a7812ULL, 0x000fca00078ec0ffULL, 0x01a6b4006a217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x008fcc0000015200ULL,
0x000000261e227210ULL, 0x000fca0007f1e1ffULL, 0x0000000127267824ULL, 0x000fe200000e0e1fULL,
0x003d09002200780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402200780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff217819ULL, 0x000fc80000011426ULL, 0x0000002221217211ULL, 0x000fca00078110ffULL,
0x000000ffff227224ULL, 0x000fca00000e0626ULL, 0x0000000221217819ULL, 0x000fc80000001222ULL,
0x000000210000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6b4006a217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099106e1e7816ULL, 0x000fc800000000ffULL,
0x000000ff1e00720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff1e7819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x008fe20000000004ULL, 0x000162927f007947ULL, 0x000fea000b800000ULL,
0x00001f1e27077589ULL, 0x0002a400000e0000ULL, 0x000000081e267810ULL, 0x000fe20007ffe0ffULL,
0x000162d27f007947ULL, 0x000fea000b800000ULL, 0x000000101e047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x000000181e267810ULL, 0x008fe20007ffe0ffULL, 0x000163427f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x000000041a1e7824ULL, 0x042fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000004001a217824ULL, 0x040fe200078e00ffULL,
0x000001b000007945ULL, 0x000fe20003800000ULL, 0x000010001a1f7824ULL, 0x000fe200078e00ffULL,
0x000000041e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000803267824ULL, 0x008fe200078e00ffULL,
0xfffff00021217812ULL, 0x000fe200078ec0ffULL, 0x0000000803277824ULL, 0x000fe200078e00ffULL,
0x0000001e171e7211ULL, 0x000fc400078fe0ffULL, 0x0001300021217810ULL, 0x000fe40007ffe0ffULL,
0xffffe0001f227812ULL, 0x000fe200078ec0ffULL, 0x00000001031f7824ULL, 0x000fe400078e021eULL,
0x000000101c707824ULL, 0x100fe200078e0221ULL, 0x0001700022257810ULL, 0x000fe20007ffe0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0221ULL, 0xfffffff8261c7812ULL, 0x000fe400078ee21fULL,
0x000000021f227810ULL, 0x000fe20007ffe0ffULL, 0x000000007070783bULL, 0x000e640000000200ULL,
0x000000101c7c7824ULL, 0x000fc400078e0225ULL, 0x000000001d68783bULL, 0x0006a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000770707231ULL, 0x086fe400003400ffULL,
0x0000000772727231ULL, 0x000fe400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fe400003400ffULL, 0x0000000568687231ULL, 0x080fe400003400ffULL,
0x000000056a6a7231ULL, 0x000fc400003400ffULL, 0x0000000469697231ULL, 0x080fe400003400ffULL,
0x000000046b6b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff827227812ULL, 0x000fe200078ee222ULL, 0x000000007c7c783bULL, 0x000f220000004200ULL,
0x0000109000007945ULL, 0x000fe60003800000ULL, 0x0000001022787824ULL, 0x000fcc00078e0225ULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x000001007c8f7824ULL, 0x010fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001147eULL, 0x000001007d927824ULL, 0x000fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe2000001147cULL, 0x0000007c00267306ULL, 0x000fe20000009400ULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x000001007ea57824ULL, 0x000fe200078e00ffULL,
0x00000018ff9b7819ULL, 0x000fe20000011492ULL, 0x000001007fa97824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe2000001147fULL, 0x0000010078b77824ULL, 0x008fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe20000011479ULL, 0x0000006f00aa7306ULL, 0x000fe20000209400ULL,
0x00000018ff9e7819ULL, 0x000fe2000001147bULL, 0x0000010079ba7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fc4000001147dULL, 0x00000018ff957819ULL, 0x000fe4000001147aULL,
0x00000018ffa57819ULL, 0x000fe200000114a5ULL, 0x0000006f00ab7306ULL, 0x000fe20000205400ULL,
0x00000018ffae7819ULL, 0x000fe400000114a9ULL, 0x00000018ffb77819ULL, 0x000fe400000114b7ULL,
0x00000018ffc07819ULL, 0x000fc600000114baULL, 0x0000006f008b7306ULL, 0x000ff0000020d400ULL,
0x0000009000c47306ULL, 0x000ff00000209400ULL, 0x0000009000c57306ULL, 0x000ff00000205400ULL,
0x00000090006f7306ULL, 0x000ff0000020d400ULL, 0x0000008f00907306ULL, 0x000ff00000209400ULL,
0x0000008f00917306ULL, 0x000ef00000205400ULL, 0x0000001f00947306ULL, 0x000ff00000209400ULL,
0x0000001f00977306ULL, 0x000fe20000205400ULL, 0x000000919000720bULL, 0x008fce0003fbd000ULL,
0x0000001f00967306ULL, 0x0007f0000020d400ULL, 0x0000007c00277306ULL, 0x000f220000005400ULL,
0x00000018ff1f7819ULL, 0x008fce0000011478ULL, 0x0000007c00767306ULL, 0x0006b0000000d400ULL,
0x0000007d00987306ULL, 0x000fe20000009400ULL, 0x000100007c7c7824ULL, 0x008fe200078e00ffULL,
0x000000272600720bULL, 0x010fe20003fdd000ULL, 0x000001007a267824ULL, 0x000fc400078e00ffULL,
0x000001007b277824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007d00997306ULL, 0x000ee20000005400ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff277819ULL, 0x000fc80000011427ULL, 0x0000000176766812ULL, 0x004fe200078efcffULL,
0x0000009b009c7306ULL, 0x000fe20000209400ULL, 0x000000979400720bULL, 0x000fce0003fdd000ULL,
0x0000009b009d7306ULL, 0x000ea20000205400ULL, 0x000000999800720bULL, 0x008fca0003f9d000ULL,
0x0000000196966812ULL, 0x000fe400078efcffULL, 0x0000008600b37306ULL, 0x000ff00000209400ULL,
0x0000008600b67306ULL, 0x000fe20000205400ULL, 0x0000009d9c00720bULL, 0x004fce0003f7d000ULL,
0x0000008600837306ULL, 0x000ff0000020d400ULL, 0x0000001f00bc7306ULL, 0x000ff00000209400ULL,
0x0000001f00bd7306ULL, 0x000ff00000205400ULL, 0x0000001f00817306ULL, 0x000ff0000020d400ULL,
0x0000009e00897306ULL, 0x000ff00000209400ULL, 0x0000009e00867306ULL, 0x000ff00000205400ULL,
0x0000009e001f7306ULL, 0x0005f0000020d400ULL, 0x0000006e00a17306ULL, 0x000fe20000209400ULL,
0x000100007d9e7824ULL, 0x004fca00078e00ffULL, 0x00000018ff9e7819ULL, 0x000fe4000001149eULL,
0x0000006e00a47306ULL, 0x000ff00000205400ULL, 0x0000006e00777306ULL, 0x000ff0000020d400ULL,
0x0000009500857306ULL, 0x000ff00000209400ULL, 0x0000009500887306ULL, 0x000ff00000205400ULL,
0x00000095006e7306ULL, 0x000ff0000020d400ULL, 0x0000008f00937306ULL, 0x000eb0000020d400ULL,
0x0000007c00927306ULL, 0x000ff00000209400ULL, 0x0000007c00957306ULL, 0x000ee20000205400ULL,
0x0000000193935812ULL, 0x004fce00078efcffULL, 0x0000007d009a7306ULL, 0x000eb0000000d400ULL,
0x0000009b009f7306ULL, 0x000f22000020d400ULL, 0x000000959200720bULL, 0x008fce0003fbd000ULL,
0x0000009e008f7306ULL, 0x000fe20000209400ULL, 0x000000019a9a4812ULL, 0x004fe400078efcffULL,
0x000000a4a100720bULL, 0x000fca0003f9d000ULL, 0x0000009e00a07306ULL, 0x000ea20000205400ULL,
0x000000019f9f3812ULL, 0x010fce00078efcffULL, 0x0000007c007d7306ULL, 0x000ee2000020d400ULL,
0x0000000177774812ULL, 0x000fce00078efcffULL, 0x000000a5009b7306ULL, 0x000fe20000209400ULL,
0x000000a08f00720bULL, 0x004fce0003f7d000ULL, 0x000000a500a87306ULL, 0x000ea20000205400ULL,
0x000000017d7d5812ULL, 0x008fce00078efcffULL, 0x0000009e00a27306ULL, 0x000ef0000020d400ULL,
0x0000007e00a37306ULL, 0x000fe20000009400ULL, 0x000000a89b00720bULL, 0x004fce0003fbd000ULL,
0x0000007e00a67306ULL, 0x000ea20000005400ULL, 0x00000001a2a23812ULL, 0x008fc800078efcffULL,
0x000000a27777723eULL, 0x000fc600000010ffULL, 0x0000007e008e7306ULL, 0x000730000000d400ULL,
0x0000007f00ac7306ULL, 0x000fe20000009400ULL, 0x000100007e7e7824ULL, 0x008fe200078e00ffULL,
0x000000a6a300720bULL, 0x004fc80003fdd000ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007f00ad7306ULL, 0x000eae0000005400ULL, 0x000000018e8e6812ULL, 0x010fe200078efcffULL,
0x000000ae00af7306ULL, 0x000fe20000209400ULL, 0x000000abaa00720bULL, 0x000fce0003fdd000ULL,
0x000000ae00b07306ULL, 0x000ee20000205400ULL, 0x000000adac00720bULL, 0x004fca0003f9d000ULL,
0x000000018b8b6812ULL, 0x000fe400078efcffULL, 0x0000007f008a7306ULL, 0x000530000000d400ULL,
0x000000a500a77306ULL, 0x000e62000020d400ULL, 0x000100007f7f7824ULL, 0x004fe200078e00ffULL,
0x000000b0af00720bULL, 0x008fc80003f7d000ULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000007e007c7306ULL, 0x000fe20000209400ULL, 0x000000018a8a4812ULL, 0x010fe400078efcffULL,
0x000000b6b300720bULL, 0x000fca0003f9d000ULL, 0x0000007e00a97306ULL, 0x000ea20000205400ULL,
0x00000001a7a75812ULL, 0x002fce00078efcffULL, 0x000000ae00b17306ULL, 0x000e62000020d400ULL,
0x0000000183834812ULL, 0x000fce00078efcffULL, 0x0000007f00a57306ULL, 0x000fe20000209400ULL,
0x000000a97c00720bULL, 0x004fce0003fbd000ULL, 0x0000007f00b27306ULL, 0x000ea20000205400ULL,
0x00000001b1b13812ULL, 0x002fce00078efcffULL, 0x0000007e009e7306ULL, 0x000e70000020d400ULL,
0x000000b700ae7306ULL, 0x000fe20000209400ULL, 0x000000b2a500720bULL, 0x004fce0003f7d000ULL,
0x000000b700b97306ULL, 0x000ea20000205400ULL, 0x000000019e9e5812ULL, 0x002fce00078efcffULL,
0x0000007f00b47306ULL, 0x000e70000020d400ULL, 0x0000007800b57306ULL, 0x000fe20000009400ULL,
0x000000b9ae00720bULL, 0x004fce0003fbd000ULL, 0x0000007800b87306ULL, 0x000ea20000005400ULL,
0x00000001b4b43812ULL, 0x002fce00078efcffULL, 0x0000007800827306ULL, 0x0002f0000000d400ULL,
0x0000007900be7306ULL, 0x000fe20000009400ULL, 0x0001000078787824ULL, 0x002fe200078e00ffULL,
0x000000b8b500720bULL, 0x004fc80003fdd000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007900bf7306ULL, 0x000e6e0000005400ULL, 0x0000000182826812ULL, 0x008fe200078efcffULL,
0x000000c000c17306ULL, 0x000fe20000209400ULL, 0x000000bdbc00720bULL, 0x000fce0003fdd000ULL,
0x000000c000c27306ULL, 0x000ea20000205400ULL, 0x000000bfbe00720bULL, 0x002fca0003f9d000ULL,
0x0000000181816812ULL, 0x000fe400078efcffULL, 0x0000007900807306ULL, 0x0002f0000000d400ULL,
0x000000b700bb7306ULL, 0x000f22000020d400ULL, 0x0001000079797824ULL, 0x002fe200078e00ffULL,
0x000000c2c100720bULL, 0x004fc80003f7d000ULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x00000078007e7306ULL, 0x000fe20000209400ULL, 0x0000000180804812ULL, 0x008fce00078efcffULL,
0x00000078007f7306ULL, 0x000e620000205400ULL, 0x00000001bbbb5812ULL, 0x010fc800078efcffULL,
0x00000082bb82723eULL, 0x000fc600000010ffULL, 0x000000c000c37306ULL, 0x000eb0000020d400ULL,
0x0000007900907306ULL, 0x000fe20000209400ULL, 0x0000007f7e00720bULL, 0x002fce0003fbd000ULL,
0x0000007900917306ULL, 0x000e620000205400ULL, 0x00000001c3c33812ULL, 0x004fe400078efcffULL,
0x000000c5c400720bULL, 0x000fca0003f7d000ULL, 0x0000007800ba7306ULL, 0x000eb0000020d400ULL,
0x0000007900927306ULL, 0x000ee2000020d400ULL, 0x000000919000720bULL, 0x002fe40003f9d000ULL,
0x000000016f6f3812ULL, 0x000fca00078efcffULL, 0x0000002600787306ULL, 0x000fe20000209400ULL,
0x00000001baba5812ULL, 0x004fc800078efcffULL, 0x000000ba81ba723eULL, 0x000fc600000010ffULL,
0x0000002600797306ULL, 0x000e620000205400ULL, 0x0000000192924812ULL, 0x008fc800078efcffULL,
0x000000926fbb723eULL, 0x000fc600000010ffULL, 0x0000007a008c7306ULL, 0x000fe80000009400ULL,
0x000000ba7050723cULL, 0x080f680000041850ULL, 0x0000007a008d7306ULL, 0x000ea20000005400ULL,
0x000000797800720bULL, 0x002fe40003fbd000ULL, 0x0000008ab179723eULL, 0x000fe200000010ffULL,
0x000000ba6830723cULL, 0x000f620000041830ULL, 0x0000008ea778723eULL, 0x000fc600000010ffULL,
0x0000007b00847306ULL, 0x000fe80000009400ULL, 0x00000078705c723cULL, 0x000f68000004185cULL,
0x0000007b00877306ULL, 0x000e620000005400ULL, 0x0000008d8c00720bULL, 0x004fc60003fdd000ULL,
0x00000078683c723cULL, 0x000f68000004183cULL, 0x00000027008f7306ULL, 0x000ff00000209400ULL,
0x0000002700987306ULL, 0x000ea20000205400ULL, 0x000000878400720bULL, 0x002fce0003f7d000ULL,
0x0000007a00257306ULL, 0x0002f0000000d400ULL, 0x0000007b001d7306ULL, 0x0008e2000000d400ULL,
0x000100007a7a7824ULL, 0x002fe200078e00ffULL, 0x000000988f00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff7c7819ULL, 0x000fe4000001147aULL, 0x0000002600947306ULL, 0x0002a2000020d400ULL,
0x000100007b7b7824ULL, 0x010fe200078e00ffULL, 0x0000000125256812ULL, 0x008fe400078efcffULL,
0x000000868900720bULL, 0x000fe40003fdd000ULL, 0x00000018ff907819ULL, 0x000fe4000001147bULL,
0x00000027009c7306ULL, 0x000722000020d400ULL, 0x000000769326723eULL, 0x002fc400000010ffULL,
0x0000007d9676723eULL, 0x000fe400000010ffULL, 0x000000011d1d3812ULL, 0x000fe400078efcffULL,
0x000000b4837b723eULL, 0x000fe200000010ffULL, 0x0000007c007e7306ULL, 0x000fe20000209400ULL,
0x0000000194945812ULL, 0x004fe200078efcffULL, 0x000000767060723cULL, 0x080f620000041860ULL,
0x000000888500720bULL, 0x000fe40003fbd000ULL, 0x000000259494723eULL, 0x000fe200000010ffULL,
0x000000021a257824ULL, 0x000fe200078e00ffULL, 0x0000009a9f27723eULL, 0x008fe200000010ffULL,
0x0000007c007f7306ULL, 0x000e620000205400ULL, 0x000000019c9c4812ULL, 0x010fe200078efcffULL,
0x000000766840723cULL, 0x000f620000041840ULL, 0x000000011f1f6812ULL, 0x000fc400078efcffULL,
0x0000001d9c95723eULL, 0x000fe400000010ffULL, 0x00000004251d7812ULL, 0x000fe200078ec0ffULL,
0x0000009000917306ULL, 0x000fe20000209400ULL, 0x000000016e6e5812ULL, 0x000fe200078efcffULL,
0x000000267064723cULL, 0x000f620000041864ULL, 0x0000009e8b7a723eULL, 0x000fe400000010ffULL,
0x00000080c383723eULL, 0x000fc600000010ffULL, 0x00000090008a7306ULL, 0x000ea20000205400ULL,
0x0000007f7e00720bULL, 0x002fe20003f9d000ULL, 0x000000266844723cULL, 0x000b6c0000041844ULL,
0x0000007c007d7306ULL, 0x000e62000020d400ULL, 0x000000021d267812ULL, 0x020fe200078efcffULL,
0x0000007a7058723cULL, 0x000f620000041858ULL, 0x0000000102277824ULL, 0x000fc400078e021eULL,
0x0000002617267211ULL, 0x000fc600078fe0ffULL, 0x0000009000907306ULL, 0x000ee2000020d400ULL,
0x0000008a9100720bULL, 0x004fe20003f7d000ULL, 0x000000827054723cULL, 0x000f620000041854ULL,
0x00000001031d7824ULL, 0x100fe400078e0226ULL, 0x0000000102267824ULL, 0x000fe200078e0226ULL,
0x000000017d7d4812ULL, 0x002fc800078efcffULL, 0x00000094704c723cULL, 0x000f62000004184cULL,
0x0000007d6e6e723eULL, 0x000fc600000010ffULL, 0x0000000190903812ULL, 0x008fc800078efcffULL,
0x0000007a6838723cULL, 0x000f620000041838ULL, 0x000000901f6f723eULL, 0x000fe200000010ffULL,
0x00000008021f7824ULL, 0x000fca00078e00ffULL, 0xfffffff81f1e7812ULL, 0x000fe200078ee226ULL,
0x0000006e7048723cULL, 0x000b620000041848ULL, 0x0000100000267810ULL, 0x000fcc0007ffe0ffULL,
0x0000000803707824ULL, 0x020fe200078e00ffULL, 0x000000826834723cULL, 0x000f680000041834ULL,
0xfffffff8701d7812ULL, 0x000fe200078ee21dULL, 0x0000000802707824ULL, 0x000fc600078e00ffULL,
0x00000094682c723cULL, 0x040f64000004182cULL, 0xfffffff8701f7812ULL, 0x000fe200078ee227ULL,
0x000000101d707824ULL, 0x100fe200078e0221ULL, 0x0000000227277810ULL, 0x000fe20007ffe0ffULL,
0x000000101e217824ULL, 0x000fe400078e0221ULL, 0x000000101f787824ULL, 0x000fe200078e0226ULL,
0x0000006e6828723cULL, 0x000b620000041828ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000002168783bULL, 0x0204e40000000200ULL, 0x00000008026e7824ULL, 0x000fe200078e00ffULL,
0x0000008000000947ULL, 0x000fd60003800000ULL, 0x0000000770707231ULL, 0x082fe400003400ffULL,
0x0000000772727231ULL, 0x000fc400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fe400003400ffULL, 0x0000000568687231ULL, 0x088fe400003400ffULL,
0x000000056a6a7231ULL, 0x000fe400003400ffULL, 0x0000000469697231ULL, 0x080fe400003400ffULL,
0x000000046b6b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xfffffff86e217812ULL, 0x004fe200078ee227ULL, 0x000000007878783bULL, 0x000ea80000004200ULL,
0x00000010217c7824ULL, 0x000fcc00078e0226ULL, 0x000000007c7c783bULL, 0x000f220000004200ULL,
0x0000007800267306ULL, 0x004fe20000009400ULL, 0x00000018ff777819ULL, 0x000fe20000011478ULL,
0x0000010078937824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011479ULL,
0x0000010079967824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fe2000001147bULL,
0x000001007aa77824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe2000001147aULL,
0x0000007800277306ULL, 0x000ea20000005400ULL, 0x00000018ff9e7819ULL, 0x000fe20000011496ULL,
0x000001007bab7824ULL, 0x000fe200078e00ffULL, 0x00000018ff997819ULL, 0x010fe2000001147eULL,
0x000001007cbb7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa27819ULL, 0x000fe2000001147fULL,
0x000001007dbd7824ULL, 0x000fe200078e00ffULL, 0x00000018ff947819ULL, 0x000fe2000001147dULL,
0x0000007800927306ULL, 0x0008e2000000d400ULL, 0x00000018ff937819ULL, 0x000fc40000011493ULL,
0x00000018ffa77819ULL, 0x000fe400000114a7ULL, 0x00000018ffb17819ULL, 0x000fe400000114abULL,
0x00000018ffbb7819ULL, 0x000fe200000114bbULL, 0x00000079009a7306ULL, 0x000fe20000009400ULL,
0x0001000078787824ULL, 0x010fe200078e00ffULL, 0x000000272600720bULL, 0x004fe20003f7d000ULL,
0x000001007e267824ULL, 0x000fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fe200000114bdULL,
0x000001007f277824ULL, 0x000fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fc40000011478ULL,
0x00000079009d7306ULL, 0x000ea20000005400ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff277819ULL, 0x000fc80000011427ULL, 0x0000000192923812ULL, 0x008fe200078efcffULL,
0x0000007700987306ULL, 0x000ff00000209400ULL, 0x00000077009b7306ULL, 0x000fe20000205400ULL,
0x0000009d9a00720bULL, 0x004fce0003f9d000ULL, 0x00000077006e7306ULL, 0x0005f0000020d400ULL,
0x0000008100a37306ULL, 0x000fe20000209400ULL, 0x00000018ff777819ULL, 0x004fce000001147cULL,
0x0000008100a87306ULL, 0x000ff00000205400ULL, 0x00000081006f7306ULL, 0x000ff0000020d400ULL,
0x0000009900887306ULL, 0x000ff00000209400ULL, 0x00000099008b7306ULL, 0x000ff00000205400ULL,
0x0000009900817306ULL, 0x000ff0000020d400ULL, 0x0000007800967306ULL, 0x000ff00000209400ULL,
0x0000007800997306ULL, 0x000eb00000205400ULL, 0x0000008900b77306ULL, 0x000ff00000209400ULL,
0x0000008900b87306ULL, 0x000fe20000205400ULL, 0x000000999600720bULL, 0x004fce0003fdd000ULL,
0x0000008900867306ULL, 0x000ff0000020d400ULL, 0x0000007700bf7306ULL, 0x000ff00000209400ULL,
0x0000007700c07306ULL, 0x000ff00000205400ULL, 0x0000007700847306ULL, 0x000ff0000020d400ULL,
0x000000a2008c7306ULL, 0x000ff00000209400ULL, 0x000000a200897306ULL, 0x000ff00000205400ULL,
0x000000a200777306ULL, 0x0005f0000020d400ULL, 0x00000079009c7306ULL, 0x000ee2000000d400ULL,
0x0001000079a27824ULL, 0x004fca00078e00ffULL, 0x00000018ffa27819ULL, 0x000fe400000114a2ULL,
0x0000008200ad7306ULL, 0x000ff00000209400ULL, 0x0000008200ae7306ULL, 0x000fe20000205400ULL,
0x000000019c9c4812ULL, 0x008fc400078efcffULL, 0x000000a8a300720bULL, 0x000fca0003f9d000ULL,
0x00000082008e7306ULL, 0x000ff0000020d400ULL, 0x0000009e009f7306ULL, 0x000fe20000209400ULL,
0x000000016f6f4812ULL, 0x000fce00078efcffULL, 0x0000009e00a07306ULL, 0x000eb00000205400ULL,
0x0000009400907306ULL, 0x000ff00000209400ULL, 0x0000009400917306ULL, 0x000fe20000205400ULL,
0x000000a09f00720bULL, 0x004fce0003fbd000ULL, 0x0000009400827306ULL, 0x000ff0000020d400ULL,
0x0000009300947306ULL, 0x000ff00000209400ULL, 0x0000009300957306ULL, 0x000eb00000205400ULL,
0x0000009300977306ULL, 0x000ef0000020d400ULL, 0x0000009e00a17306ULL, 0x000f22000020d400ULL,
0x000000959400720bULL, 0x004fce0003f1d000ULL, 0x0000007800797306ULL, 0x000eac000020d400ULL,
0x0000000197970812ULL, 0x008fe400078efcffULL, 0x000000a200937306ULL, 0x000fe20000209400ULL,
0x00000001a1a15812ULL, 0x010fe400078efcffULL, 0x0000009b9800720bULL, 0x000fca0003f1d000ULL,
0x000000a200a47306ULL, 0x000ee20000205400ULL, 0x0000000179796812ULL, 0x004fce00078efcffULL,
0x000000a7009e7306ULL, 0x000fe20000209400ULL, 0x000000016e6e0812ULL, 0x000fc800078efcffULL,
0x000000796e6e723eULL, 0x000fc600000010ffULL, 0x000000a700a97306ULL, 0x000ea20000205400ULL,
0x000000a49300720bULL, 0x008fce0003f7d000ULL, 0x0000007a00a57306ULL, 0x000ff00000009400ULL,
0x0000007a00aa7306ULL, 0x000ee20000005400ULL, 0x000000a99e00720bULL, 0x004fce0003fdd000ULL,
0x0000007a008f7306ULL, 0x0005f0000000d400ULL, 0x000000a200a67306ULL, 0x000862000020d400ULL,
0x000100007a7a7824ULL, 0x004fe200078e00ffULL, 0x000000aaa500720bULL, 0x008fc80003fbd000ULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x000000a700ac7306ULL, 0x000ea2000020d400ULL,
0x000100007ba27824ULL, 0x010fca00078e00ffULL, 0x00000018ffa27819ULL, 0x000fe400000114a2ULL,
0x0000007a00787306ULL, 0x000fe20000209400ULL, 0x00000001a6a63812ULL, 0x002fe400078efcffULL,
0x000000018f8f5812ULL, 0x000fe400078efcffULL, 0x000000a66f6f723eULL, 0x000fc600000010ffULL,
0x0000007a00ab7306ULL, 0x000e620000205400ULL, 0x00000001acac6812ULL, 0x004fe400078efcffULL,
0x000000aead00720bULL, 0x000fe20003fdd000ULL, 0x0000006e7060723cULL, 0x080f680000041860ULL,
0x0000007b00af7306ULL, 0x000fe80000009400ULL, 0x0000006e6840723cULL, 0x000f680000041840ULL,
0x0000007b00b07306ULL, 0x000ea20000005400ULL, 0x000000ab7800720bULL, 0x002fe20003f9d000ULL,
0x000100007f787824ULL, 0x000fe200078e00ffULL, 0x000000018e8e6812ULL, 0x000fca00078efcffULL,
0x0000007b008d7306ULL, 0x000e70000000d400ULL, 0x0000007a007b7306ULL, 0x000ee2000020d400ULL,
0x000000b0af00720bULL, 0x004fce0003f7d000ULL, 0x0000007c00b97306ULL, 0x000fec0000009400ULL,
0x000000018d8d3812ULL, 0x002fe400078efcffULL, 0x0000007c00ba7306ULL, 0x000e620000005400ULL,
0x000000017b7b4812ULL, 0x008fc800078efcffULL, 0x0000007b8e8e723eULL, 0x000fc600000010ffULL,
0x000000a200a77306ULL, 0x000ff00000209400ULL, 0x000000a200b67306ULL, 0x000ea20000205400ULL,
0x000000bab900720bULL, 0x002fce0003f9d000ULL, 0x000000b100b27306ULL, 0x000ff00000209400ULL,
0x000000b100b37306ULL, 0x000e620000205400ULL, 0x000000b6a700720bULL, 0x004fce0003fbd000ULL,
0x000000b100b47306ULL, 0x000eb0000020d400ULL, 0x000000bb00b17306ULL, 0x000fe20000209400ULL,
0x000000b3b200720bULL, 0x002fce0003f1d000ULL, 0x000000bb00bc7306ULL, 0x000e6c0000205400ULL,
0x00000001b4b40812ULL, 0x004fe400078efcffULL, 0x000000c300c47306ULL, 0x000fe20000209400ULL,
0x000000b8b700720bULL, 0x000fe40003f1d000ULL, 0x0000008db479723eULL, 0x000fca00000010ffULL,
0x000000c300c57306ULL, 0x000ea20000205400ULL, 0x000000bcb100720bULL, 0x002fca0003f7d000ULL,
0x0000000186860812ULL, 0x000fe400078efcffULL, 0x0000007c00857306ULL, 0x0002f0000000d400ULL,
0x000000a200b57306ULL, 0x0008e2000020d400ULL, 0x000100007c7c7824ULL, 0x002fe200078e00ffULL,
0x000000c5c400720bULL, 0x004fc80003fdd000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007d00c17306ULL, 0x000fe20000009400ULL, 0x000100007da27824ULL, 0x010fe200078e00ffULL,
0x0000000185854812ULL, 0x008fe400078efcffULL, 0x000000c0bf00720bULL, 0x000fe40003f9d000ULL,
0x00000018ffa27819ULL, 0x000fe400000114a2ULL, 0x0000007d00c27306ULL, 0x000e620000005400ULL,
0x00000001b5b55812ULL, 0x000fce00078efcffULL, 0x000000bb00be7306ULL, 0x000ea2000020d400ULL,
0x0000000184844812ULL, 0x000fce00078efcffULL, 0x000000c300c67306ULL, 0x000ee2000020d400ULL,
0x000000c2c100720bULL, 0x002fce0003fbd000ULL, 0x0000007c007a7306ULL, 0x000fe20000209400ULL,
0x00000001bebe3812ULL, 0x004fc800078efcffULL, 0x00000085bebe723eULL, 0x000fc600000010ffULL,
0x0000007c00bd7306ULL, 0x000e620000205400ULL, 0x00000001c6c66812ULL, 0x008fce00078efcffULL,
0x000000a200bb7306ULL, 0x000ff00000209400ULL, 0x000000a200c87306ULL, 0x000ea20000205400ULL,
0x000000bd7a00720bULL, 0x002fce0003f7d000ULL, 0x0000007d00837306ULL, 0x000e70000000d400ULL,
0x0000007f00877306ULL, 0x000fe20000009400ULL, 0x000000c8bb00720bULL, 0x004fce0003fdd000ULL,
0x0000007f008a7306ULL, 0x000ea20000005400ULL, 0x0000000183835812ULL, 0x002fe400078efcffULL,
0x000000919000720bULL, 0x000fe40003fbd000ULL, 0x00000083c6bf723eULL, 0x000fc600000010ffULL,
0x0000007c007d7306ULL, 0x000e68000020d400ULL, 0x000000be7054723cULL, 0x080f680000041854ULL,
0x000000a200957306ULL, 0x000ee2000020d400ULL, 0x0000008a8700720bULL, 0x004fe40003f9d000ULL,
0x0000000182825812ULL, 0x000fe200078efcffULL, 0x000000be6834723cULL, 0x000f620000041834ULL,
0x0000008b8800720bULL, 0x000fc60003fbd000ULL, 0x0000007e00c77306ULL, 0x000fe20000009400ULL,
0x000000017d7d3812ULL, 0x002fc800078efcffULL, 0x0000007d8484723eULL, 0x000fc600000010ffULL,
0x0000007e00ca7306ULL, 0x000e620000005400ULL, 0x0000000195956812ULL, 0x008fe400078efcffULL,
0x0000000181815812ULL, 0x000fe400078efcffULL, 0x000000958285723eULL, 0x000fc600000010ffULL,
0x00000026007c7306ULL, 0x000fe80000209400ULL, 0x000000847050723cULL, 0x000f680000041850ULL,
0x0000002600937306ULL, 0x000ea20000205400ULL, 0x000000cac700720bULL, 0x002fc60003f1d000ULL,
0x000000846830723cULL, 0x000f680000041830ULL, 0x0000002700947306ULL, 0x000ff00000209400ULL,
0x00000027009b7306ULL, 0x000e620000205400ULL, 0x000000937c00720bULL, 0x004fce0003f7d000ULL,
0x0000007e00807306ULL, 0x0004f0000000d400ULL, 0x0000002600997306ULL, 0x0008e2000020d400ULL,
0x000100007e7e7824ULL, 0x004fe200078e00ffULL, 0x0000009b9400720bULL, 0x002fc80003fdd000ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000007f00767306ULL, 0x000e62000000d400ULL,
0x000000929726723eULL, 0x010fe400000010ffULL, 0x00000018ff927819ULL, 0x000fe40000011478ULL,
0x0000000180800812ULL, 0x008fe400078efcffULL, 0x0000008fac78723eULL, 0x000fe200000010ffULL,
0x00000027009d7306ULL, 0x0004e2000020d400ULL, 0x0000000199993812ULL, 0x000fc400078efcffULL,
0x000000898c00720bULL, 0x000fe40003f7d000ULL, 0x000000b5868f723eULL, 0x000fe200000010ffULL,
0x00000078705c723cULL, 0x000f64000004185cULL, 0x0000007e007f7306ULL, 0x000fe20000209400ULL,
0x0000000176764812ULL, 0x002fe400078efcffULL, 0x0000009ca127723eULL, 0x004fc600000010ffULL,
0x0000008e7058723cULL, 0x040f640000041858ULL, 0x0000007e007a7306ULL, 0x000e620000205400ULL,
0x000000019d9d6812ULL, 0x008fe400078efcffULL, 0x0000000177773812ULL, 0x000fe400078efcffULL,
0x000000769d7b723eULL, 0x000fe200000010ffULL, 0x000000267064723cULL, 0x080f640000041864ULL,
0x0000009200907306ULL, 0x000fec0000209400ULL, 0x000000266844723cULL, 0x000b640000041844ULL,
0x0000009200877306ULL, 0x000ea20000205400ULL, 0x0000007a7f00720bULL, 0x002fc40003f1d000ULL,
0x00000080997a723eULL, 0x000fe400000010ffULL, 0xfffffff825267812ULL, 0x020fe200078ec0ffULL,
0x00000078683c723cULL, 0x000f64000004183cULL, 0x0000007e007e7306ULL, 0x000e6c000020d400ULL,
0x0000007a704c723cULL, 0x000f64000004184cULL, 0x0000009200927306ULL, 0x000ee2000020d400ULL,
0x000000879000720bULL, 0x004fca0003fdd000ULL, 0x0000008e6838723cULL, 0x000f620000041838ULL,
0x000000017e7e0812ULL, 0x002fc800078efcffULL, 0x0000007e8176723eULL, 0x000fc600000010ffULL,
0x0000007a682c723cULL, 0x000f62000004182cULL, 0x0000000192926812ULL, 0x008fc800078efcffULL,
0x000000927777723eULL, 0x000fce00000010ffULL, 0x000000767048723cULL, 0x080f700000041848ULL,
0x000000766828723cULL, 0x000b6e0000041828ULL, 0x0001a6c8136a7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006a6a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6900026ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff257224ULL, 0x000fc600078e00ffULL, 0x0000000000267805ULL, 0x004fc80000015200ULL,
0x000004000d697984ULL, 0x000ea40000000800ULL, 0x8000000069ff7812ULL, 0x006fc4000780486bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000687805ULL, 0x000fcc0000015200ULL,
0x00000068266f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000169697824ULL, 0x000fe200000e0e27ULL,
0x003d09006f00780cULL, 0x000fc80003f06070ULL, 0x000000ff6900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406f00780cULL, 0x000fc80003f06070ULL,
0x000000ff6900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff687819ULL, 0x000fc80000011469ULL, 0x0000006f68687211ULL, 0x000fca00078110ffULL,
0x000000ffff697224ULL, 0x000fca00000e0669ULL, 0x0000000268687819ULL, 0x000fc80000001269ULL,
0x000000680000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d697984ULL, 0x000e640000000800ULL, 0x8000000069ff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c00c277810ULL, 0x000fca0007ffe0ffULL,
0x00006800126f7a24ULL, 0x000fe200078e0227ULL, 0x000003e00000a947ULL, 0x000fea0003800000ULL,
0x0000002716257217ULL, 0x000fe20007800000ULL, 0x00000010116e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff687819ULL, 0x000fe40000011617ULL, 0x0000100000777810ULL, 0x000fe20007ffe0ffULL,
0x0000000125257824ULL, 0x000fe200078e0a27ULL, 0x0000000468697810ULL, 0x000fe20007ffe0ffULL,
0x000000016e267824ULL, 0x000fe200078e0268ULL, 0x00000008686b7810ULL, 0x000fe40007ffe0ffULL,
0x000000256e257217ULL, 0x000fe20007800000ULL, 0x0000000126277824ULL, 0x000fc400078e0217ULL,
0x0000000826707824ULL, 0x040fe400078e00ffULL, 0x0000000125257824ULL, 0x000fe400078e0a6eULL,
0x0000000126267824ULL, 0x000fe200078e026fULL, 0xfffffff870707812ULL, 0x000fe200078ee227ULL,
0x000000016e727824ULL, 0x000fe200078e0269ULL, 0x000000256900720cULL, 0x080fe20003f86070ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000c68697810ULL, 0x040fe40007ffe0ffULL,
0x000000256800720cULL, 0x080fe20003fa6070ULL, 0x0000000172687824ULL, 0x000fe200078e026fULL,
0x000000256900720cULL, 0x000fe20003f06070ULL, 0x000000016e787824ULL, 0x000fe200078e0269ULL,
0x0000000b266a7212ULL, 0x000fe200078efcffULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0x000000256b00720cULL, 0x000fc40003f66070ULL, 0x000064006a6a7a10ULL, 0x000fe20007fde0ffULL,
0x000000016e767824ULL, 0x000fe200078e026bULL, 0x0000000b686e7212ULL, 0x000fe200078efcffULL,
0x0000000172257824ULL, 0x000fe200078e0217ULL, 0x00006500276b7a10ULL, 0x000fe200037fe4ffULL,
0x0000000176267824ULL, 0x000fe200078e026fULL, 0x000064006e6e7a10ULL, 0x000fe20007fde0ffULL,
0x0000000872727824ULL, 0x000fe400078e00ffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff872727812ULL, 0x000fe200078ee225ULL, 0x0000000178687824ULL, 0x000fe200078e026fULL,
0x00006500696f7a10ULL, 0x000fe200037fe4ffULL, 0x0000000176717824ULL, 0x000fe200078e0217ULL,
0x0000000b26267212ULL, 0x000fe200078efcffULL, 0x0000008068687825ULL, 0x000fc600078e00ffULL,
0x0000640026267a10ULL, 0x000fe20007fde0ffULL, 0x0000000876767824ULL, 0x000fe200078e00ffULL,
0x0000000b68687212ULL, 0x000fe200078efcffULL, 0x0000000178257824ULL, 0x040fe200078e0217ULL,
0x0000650027277a10ULL, 0x000fe200037fe4ffULL, 0x0000000878787824ULL, 0x000fe200078e00ffULL,
0xfffffff876767812ULL, 0x000fe200078ee271ULL, 0x0000001072717824ULL, 0x000fe200078e0277ULL,
0x0000640068687a10ULL, 0x000fe40007fde0ffULL, 0xfffffff878787812ULL, 0x000fe200078ee225ULL,
0x0000001070257824ULL, 0x100fe200078e0277ULL, 0x0000650069697a10ULL, 0x000fe200037fe4ffULL,
0x0000001076737824ULL, 0x000fc400078e0277ULL, 0x0000001078777824ULL, 0x000fe200078e0277ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a257faeULL, 0x0003e8000e901c46ULL,
0x000000006e717faeULL, 0x0003e8000e101c46ULL, 0x0000000026737faeULL, 0x0003e8000d901c46ULL,
0x0000000068777faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001011267824ULL, 0x000fe200078e00ffULL, 0x0000100000777810ULL, 0x000fc80007ffe0ffULL,
0x0000002617687211ULL, 0x000fc800078fe8ffULL, 0x00000004686a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000168267824ULL, 0x040fe200078e026fULL, 0x0000000868727810ULL, 0x040fe20007ffe0ffULL,
0x0000000168257824ULL, 0x040fe200078e0217ULL, 0x0000000c68767810ULL, 0x040fe20007ffe0ffULL,
0x0000000868707824ULL, 0x000fe400078e00ffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff870707812ULL, 0x000fe200078ee225ULL, 0x000000016a257824ULL, 0x000fe200078e026fULL,
0x0000000b266e7212ULL, 0x000fe200078efcffULL, 0x000000016a697824ULL, 0x040fe400078e0217ULL,
0x000000086a787824ULL, 0x000fe200078e00ffULL, 0x000064006e6e7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000172687824ULL, 0x100fe400078e026fULL, 0x00000001766a7824ULL, 0x040fe400078e026fULL,
0x0000000176267824ULL, 0x000fc400078e0217ULL, 0x00000008766f7824ULL, 0x000fe400078e00ffULL,
0x00000001726b7824ULL, 0x040fe400078e0217ULL, 0x00000008727a7824ULL, 0x000fe200078e00ffULL,
0xfffffff878727812ULL, 0x000fe200078ee269ULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0xfffffff86f787812ULL, 0x000fe400078ee226ULL, 0x00006500276f7a10ULL, 0x000fe200007fe4ffULL,
0x0000008025267825ULL, 0x000fe200078e00ffULL, 0xfffffff87a767812ULL, 0x000fc400078ee26bULL,
0x0000000b68687212ULL, 0x080fe200078efcffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000640068687a10ULL, 0x000fe20007f7e0ffULL,
0x0000001070257824ULL, 0x100fe200078e0277ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x0000001072717824ULL, 0x100fe200078e0277ULL, 0x0000640026267a10ULL, 0x000fe20007f1e0ffULL,
0x0000001076737824ULL, 0x100fe200078e0277ULL, 0x000064006a6a7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001078777824ULL, 0x000fe200078e0277ULL, 0x0000650027277a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006e257faeULL, 0x0003e2000b901c46ULL,
0x0000650069697a10ULL, 0x000fc40001ffe4ffULL, 0x000065006b6b7a10ULL, 0x000fe200027fe4ffULL,
0x0000000026717faeULL, 0x0003e8000b901c46ULL, 0x0000000068737faeULL, 0x0003e8000b901c46ULL,
0x000000006a777faeULL, 0x0003e4000b901c46ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff014687812ULL, 0x000fce00078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6b00068687f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a64800206e7f8cULL, 0x0004e4000c80043fULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0x01a64c0020257984ULL, 0x000f240000000800ULL,
0x8000000025ff7812ULL, 0x018fe4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006a7805ULL, 0x000fcc0000015200ULL,
0x0000006a266a7210ULL, 0x000fca0007f1e1ffULL, 0x000000016b6b7824ULL, 0x000fe200000e0e27ULL,
0x003d09006a00780cULL, 0x000fc80003f06070ULL, 0x000000ff6b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406a00780cULL, 0x000fc80003f06070ULL,
0x000000ff6b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001146bULL, 0x0000006a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff6a7224ULL, 0x000fca00000e066bULL, 0x0000000225257819ULL, 0x000fc8000000126aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a64c0020257984ULL, 0x000ee40000000800ULL, 0x8000000025ff7812ULL, 0x008fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000201a207824ULL, 0x004fca00078e00ffULL,
0xffffff8020207812ULL, 0x000fc800078ec0ffULL, 0x000001000b257810ULL, 0x000fca0007ffe020ULL,
0x000000010a257824ULL, 0x000fca00078e0225ULL, 0x01a00000256e7984ULL, 0x000ea80000000800ULL,
0x01a2000025707984ULL, 0x0006620000000800ULL, 0x000000236e00720bULL, 0x004fe20003f1d000ULL,
0x000134327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000717806ULL, 0x008fc800000e0100ULL,
0x000000ff7100720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff257424ULL, 0x000fe400078e00ffULL, 0x000000ffff207224ULL, 0x000fd200078e0023ULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000000210257810ULL, 0x000fe40007ffe0ffULL,
0x000000236e00720bULL, 0x000fe40003f74000ULL, 0x0000001a2500720cULL, 0x000fe20003f05270ULL,
0x000133f27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000727806ULL, 0x000fc400018e0100ULL,
0x000000801a258824ULL, 0x000fe200078e020bULL, 0x000000236e207209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a258824ULL, 0x000fca00078e0225ULL,
0x01a4002025008388ULL, 0x0005e20000000800ULL, 0x000000ff7200720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000002320237221ULL, 0x004fe20000010100ULL,
0x000000ff72ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b23237820ULL, 0x000fc80000410000ULL, 0x0000002300277308ULL, 0x000ea40000000800ULL,
0x0000002724247220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x000133427f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe40000410000ULL,
0x0000002665657220ULL, 0x080fe40000410000ULL, 0x0000002660607220ULL, 0x080fe40000410000ULL,
0x0000002661617220ULL, 0x080fe40000410000ULL, 0x000000265c5c7220ULL, 0x080fe40000410000ULL,
0x000000265d5d7220ULL, 0x000fc40000410000ULL, 0x0000002658587220ULL, 0x080fe40000410000ULL,
0x0000002659597220ULL, 0x080fe40000410000ULL, 0x0000002654547220ULL, 0x080fe40000410000ULL,
0x0000002655557220ULL, 0x080fe40000410000ULL, 0x0000002650507220ULL, 0x080fe40000410000ULL,
0x0000002651517220ULL, 0x000fc40000410000ULL, 0x000000264c4c7220ULL, 0x080fe40000410000ULL,
0x000000264d4d7220ULL, 0x080fe40000410000ULL, 0x0000002648487220ULL, 0x080fe40000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0072ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x000132227f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002666667220ULL, 0x08cfe40000410000ULL, 0x0000002667677220ULL, 0x080fe40000410000ULL,
0x0000002662627220ULL, 0x080fe40000410000ULL, 0x0000002663637220ULL, 0x080fe40000410000ULL,
0x000000265e5e7220ULL, 0x080fe40000410000ULL, 0x000000265f5f7220ULL, 0x000fc40000410000ULL,
0x000000265a5a7220ULL, 0x080fe40000410000ULL, 0x000000265b5b7220ULL, 0x080fe40000410000ULL,
0x0000002656567220ULL, 0x080fe40000410000ULL, 0x0000002657577220ULL, 0x080fe40000410000ULL,
0x0000002652527220ULL, 0x080fe40000410000ULL, 0x0000002653537220ULL, 0x000fc40000410000ULL,
0x000000264e4e7220ULL, 0x080fe40000410000ULL, 0x000000264f4f7220ULL, 0x080fe40000410000ULL,
0x000000264a4a7220ULL, 0x080fe40000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000072ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x000131027f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe40000410000ULL,
0x0000002645457220ULL, 0x080fe40000410000ULL, 0x0000002640407220ULL, 0x080fe40000410000ULL,
0x0000002641417220ULL, 0x080fe40000410000ULL, 0x000000263c3c7220ULL, 0x080fe40000410000ULL,
0x000000263d3d7220ULL, 0x000fc40000410000ULL, 0x0000002638387220ULL, 0x080fe40000410000ULL,
0x0000002639397220ULL, 0x080fe40000410000ULL, 0x0000002634347220ULL, 0x080fe40000410000ULL,
0x0000002635357220ULL, 0x080fe40000410000ULL, 0x0000002630307220ULL, 0x080fe40000410000ULL,
0x0000002631317220ULL, 0x000fc40000410000ULL, 0x000000262c2c7220ULL, 0x080fe40000410000ULL,
0x000000262d2d7220ULL, 0x080fe40000410000ULL, 0x0000002628287220ULL, 0x080fe40000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000072ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x00012ff27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe40000410000ULL,
0x0000002647477220ULL, 0x080fe40000410000ULL, 0x0000002642427220ULL, 0x080fe40000410000ULL,
0x0000002643437220ULL, 0x080fe40000410000ULL, 0x000000263e3e7220ULL, 0x080fe40000410000ULL,
0x000000263f3f7220ULL, 0x000fc40000410000ULL, 0x000000263a3a7220ULL, 0x080fe40000410000ULL,
0x000000263b3b7220ULL, 0x080fe40000410000ULL, 0x0000002636367220ULL, 0x080fe40000410000ULL,
0x0000002637377220ULL, 0x080fe40000410000ULL, 0x0000002632327220ULL, 0x080fe40000410000ULL,
0x0000002633337220ULL, 0x000fc40000410000ULL, 0x000000262e2e7220ULL, 0x080fe40000410000ULL,
0x000000262f2f7220ULL, 0x080fe40000410000ULL, 0x000000262a2a7220ULL, 0x080fe40000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000007271ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff257424ULL, 0x000fd800078e00ffULL,
0x800000206e6e0221ULL, 0x000fe20000010000ULL, 0x00007610ff250816ULL, 0x000fc60000000025ULL,
0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL, 0x0000006e00090308ULL, 0x000ea40000000800ULL,
0x0000000970700220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002470247221ULL, 0x002fc40000010000ULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x0000040008237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006a7805ULL, 0x000fcc0000015200ULL, 0x0000006a266a7210ULL, 0x000fca0007f1e1ffULL,
0x000000016b6b7824ULL, 0x000fe200000e0e27ULL, 0x003d09006a00780cULL, 0x000fc80003f06070ULL,
0x000000ff6b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406a00780cULL, 0x000fc80003f06070ULL, 0x000000ff6b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc8000001146bULL,
0x0000006a23237211ULL, 0x000fca00078110ffULL, 0x000000ffff6a7224ULL, 0x000fca00000e066bULL,
0x0000000223237819ULL, 0x000fc8000000126aULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040008237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991025237816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff2300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff6c7819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x000fe20000000004ULL, 0x00012be27f007947ULL, 0x000fea000b800000ULL,
0x00001f6c27077589ULL, 0x0002a400000e0000ULL, 0x000000086c267810ULL, 0x000fe20007ffe0ffULL,
0x00012c227f007947ULL, 0x000fea000b800000ULL, 0x000000106c047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x000000186c267810ULL, 0x008fe20007ffe0ffULL, 0x00012c927f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000021a237824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000004001a277824ULL, 0x00afe200078e00ffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x00000008036b7824ULL, 0x000fe200078e00ffULL, 0x0000000423267812ULL, 0x000fe200078ec0ffULL,
0x00000008026c7824ULL, 0x000fe200078e00ffULL, 0xfffff000276a7812ULL, 0x000fe200078ec0ffULL,
0x000000101c787824ULL, 0x000fe200078e0200ULL, 0x0000002617257211ULL, 0x000fca00078fe0ffULL,
0x0000000103267824ULL, 0x100fe400078e0225ULL, 0x0000000102277824ULL, 0x000fe200078e0225ULL,
0x000140006a257810ULL, 0x000fe40007ffe0ffULL, 0xfffffff86b267812ULL, 0x000fe400078ee226ULL,
0xfffffff86c6a7812ULL, 0x000fc600078ee227ULL, 0x0000001026267824ULL, 0x100fe400078e0225ULL,
0x000000106a6a7824ULL, 0x000fc600078e0225ULL, 0x000000002670783bULL, 0x0002e80000000200ULL,
0x000000006a6c783bULL, 0x0002a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000770707231ULL, 0x08cfe400003400ffULL, 0x0000000772727231ULL, 0x000fe400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fc400003400ffULL,
0x000000056c6c7231ULL, 0x080fe400003400ffULL, 0x000000056e6e7231ULL, 0x000fe400003400ffULL,
0x000000046d6d7231ULL, 0x080fe400003400ffULL, 0x000000046f6f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010227c7824ULL, 0x000fe200078e0200ULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x00000f8000007945ULL, 0x000fe80003800000ULL,
0x000000007c7c783bULL, 0x000e620000004200ULL, 0x0000010078917824ULL, 0x010fe200078e00ffULL,
0x00000018ff227819ULL, 0x000fe20000011478ULL, 0x0000010079947824ULL, 0x040fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011479ULL, 0x00000079009a7306ULL, 0x000fe20000009400ULL,
0x00000018ff877819ULL, 0x002fe2000001147cULL, 0x0001000079a07824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe2000001147eULL, 0x000001007aa77824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe2000001147fULL, 0x000001007bad7824ULL, 0x000fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fe20000011491ULL, 0x0000002200967306ULL, 0x000fe20000209400ULL,
0x00000018ff8c7819ULL, 0x000fe2000001147dULL, 0x000001007db47824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe2000001147aULL, 0x000001007fc97824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fc4000001147bULL, 0x00000018ffa07819ULL, 0x000fe200000114a0ULL,
0x0000002200997306ULL, 0x000fe20000205400ULL, 0x00000018ffa77819ULL, 0x000fe400000114a7ULL,
0x00000018ffad7819ULL, 0x000fe400000114adULL, 0x00000018ffbb7819ULL, 0x000fe400000114b4ULL,
0x00000018ffc97819ULL, 0x000fe200000114c9ULL, 0x0000002200987306ULL, 0x000ff0000020d400ULL,
0x0000008700b77306ULL, 0x000ff00000209400ULL, 0x0000008700b87306ULL, 0x000ff00000205400ULL,
0x0000008700857306ULL, 0x000ff0000020d400ULL, 0x0000007600a37306ULL, 0x000ff00000209400ULL,
0x0000007600a67306ULL, 0x000ff00000205400ULL, 0x00000076006b7306ULL, 0x000ff0000020d400ULL,
0x0000009d00887306ULL, 0x000ff00000209400ULL, 0x0000009d00877306ULL, 0x000ff00000205400ULL,
0x0000009d00227306ULL, 0x0003f0000020d400ULL, 0x00000079009b7306ULL, 0x000f220000005400ULL,
0x00000018ff9d7819ULL, 0x002fce0000011494ULL, 0x0000009200867306ULL, 0x000ff00000209400ULL,
0x0000009200897306ULL, 0x000fe20000205400ULL, 0x0000009b9a00720bULL, 0x010fce0003f9d000ULL,
0x0000009200767306ULL, 0x000ff0000020d400ULL, 0x0000009100927306ULL, 0x000ff00000209400ULL,
0x0000009100937306ULL, 0x000e700000205400ULL, 0x0000007800267306ULL, 0x000ff00000009400ULL,
0x0000007800277306ULL, 0x000f220000005400ULL, 0x000000939200720bULL, 0x002fce0003fbd000ULL,
0x0000009d009e7306ULL, 0x000ff00000209400ULL, 0x0000009d009f7306ULL, 0x000e620000205400ULL,
0x000000272600720bULL, 0x010fce0003fdd000ULL, 0x00000078006a7306ULL, 0x0008f0000000d400ULL,
0x00000079009c7306ULL, 0x000ea2000000d400ULL, 0x0001000078787824ULL, 0x010fe200078e00ffULL,
0x0000009f9e00720bULL, 0x002fc80003f7d000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000008c00c17306ULL, 0x000fe20000209400ULL, 0x000000016a6a6812ULL, 0x008fe400078efcffULL,
0x000000999600720bULL, 0x000fe20003fdd000ULL, 0x000100007f967824ULL, 0x000fc800078e00ffULL,
0x0000008c00c27306ULL, 0x000fe20000205400ULL, 0x000000019c9c4812ULL, 0x004fe400078efcffULL,
0x000000a6a300720bULL, 0x000fe40003f9d000ULL, 0x00000018ff967819ULL, 0x000fc60000011496ULL,
0x0000008c00837306ULL, 0x000fe2000020d400ULL, 0x0000000198986812ULL, 0x000fce00078efcffULL,
0x00000080008f7306ULL, 0x000fe20000209400ULL, 0x000000016b6b4812ULL, 0x000fce00078efcffULL,
0x0000008000907306ULL, 0x000ff00000205400ULL, 0x0000008000817306ULL, 0x000ff0000020d400ULL,
0x00000097008c7306ULL, 0x000ff00000209400ULL, 0x00000097008d7306ULL, 0x000ff00000205400ULL,
0x0000009700807306ULL, 0x000ff0000020d400ULL, 0x0000009100957306ULL, 0x000e70000020d400ULL,
0x0000007800947306ULL, 0x000ff00000209400ULL, 0x0000007800977306ULL, 0x000ea20000205400ULL,
0x0000000195955812ULL, 0x002fc800078efcffULL, 0x0000006a9526723eULL, 0x000fc600000010ffULL,
0x0000009d00a17306ULL, 0x000e70000020d400ULL, 0x000000a000917306ULL, 0x000fe20000209400ULL,
0x000000979400720bULL, 0x004fce0003fbd000ULL, 0x000000a000a27306ULL, 0x000ea20000205400ULL,
0x00000001a1a13812ULL, 0x002fc800078efcffULL, 0x0000009ca127723eULL, 0x000fc600000010ffULL,
0x0000007b00ab7306ULL, 0x000fe80000009400ULL, 0x000000267064723cULL, 0x000f680000041864ULL,
0x0000007b00ac7306ULL, 0x000e620000005400ULL, 0x000000a29100720bULL, 0x004fc60003f7d000ULL,
0x000000266c44723cULL, 0x000f680000041844ULL, 0x0000007800797306ULL, 0x0004f0000020d400ULL,
0x000000a7009d7306ULL, 0x000fe20000209400ULL, 0x000001007c787824ULL, 0x004fe200078e00ffULL,
0x000000acab00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x000000a700aa7306ULL, 0x000e620000205400ULL, 0x0000000179795812ULL, 0x008fc800078efcffULL,
0x00000079986a723eULL, 0x000fc600000010ffULL, 0x000000a000a47306ULL, 0x000eb0000020d400ULL,
0x0000007a00a57306ULL, 0x000fe20000009400ULL, 0x000000aa9d00720bULL, 0x002fce0003fbd000ULL,
0x0000007a00a87306ULL, 0x000e620000005400ULL, 0x00000001a4a43812ULL, 0x004fc800078efcffULL,
0x000000a46b6b723eULL, 0x000fc600000010ffULL, 0x000000ad00ae7306ULL, 0x000fe80000209400ULL,
0x0000006a7060723cULL, 0x000f680000041860ULL, 0x000000ad00af7306ULL, 0x000ea20000205400ULL,
0x000000a8a500720bULL, 0x002fc60003fdd000ULL, 0x0000006a6c40723cULL, 0x000f680000041840ULL,
0x0000007b008b7306ULL, 0x0002f0000000d400ULL, 0x0000007d00b97306ULL, 0x000fe20000009400ULL,
0x000000afae00720bULL, 0x004fe20003f7d000ULL, 0x000100007b7b7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000007d00ba7306ULL, 0x000e620000005400ULL,
0x000000018b8b4812ULL, 0x008fce00078efcffULL, 0x000000a700a97306ULL, 0x000eb0000020d400ULL,
0x0000007800a07306ULL, 0x000fe20000209400ULL, 0x000000bab900720bULL, 0x002fce0003f9d000ULL,
0x0000007800b37306ULL, 0x000e620000205400ULL, 0x00000001a9a95812ULL, 0x004fce00078efcffULL,
0x0000007a008e7306ULL, 0x0004f0000000d400ULL, 0x000000ad00b07306ULL, 0x000f22000020d400ULL,
0x000000b3a000720bULL, 0x002fe20003fbd000ULL, 0x000100007a7a7824ULL, 0x004fca00078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x0000007c00b17306ULL, 0x000fe20000009400ULL,
0x000000018e8e6812ULL, 0x008fce00078efcffULL, 0x0000007c00b27306ULL, 0x000e620000005400ULL,
0x00000001b0b03812ULL, 0x010fc800078efcffULL, 0x0000008bb079723eULL, 0x000fc600000010ffULL,
0x000000bb00bc7306ULL, 0x000ff00000209400ULL, 0x000000bb00bd7306ULL, 0x000ea20000205400ULL,
0x000000b2b100720bULL, 0x002fce0003fdd000ULL, 0x0000007c008a7306ULL, 0x0002f0000000d400ULL,
0x0000007d00847306ULL, 0x0008e2000000d400ULL, 0x000100007c7c7824ULL, 0x002fe200078e00ffULL,
0x000000bdbc00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007800b57306ULL, 0x0002a2000020d400ULL, 0x000100007d7d7824ULL, 0x010fe200078e00ffULL,
0x000000018a8a6812ULL, 0x008fe400078efcffULL, 0x000000b8b700720bULL, 0x000fe40003fdd000ULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x0000007c00a77306ULL, 0x000fe20000209400ULL,
0x000001007e787824ULL, 0x002fe200078e00ffULL, 0x0000000184844812ULL, 0x000fc400078efcffULL,
0x000000c2c100720bULL, 0x000fe40003f9d000ULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007c00b47306ULL, 0x000e620000205400ULL, 0x00000001b5b55812ULL, 0x004fe400078efcffULL,
0x0000000185856812ULL, 0x000fe400078efcffULL, 0x0000008ab58a723eULL, 0x000fc600000010ffULL,
0x000000bb00bf7306ULL, 0x000ea2000020d400ULL, 0x0000000183834812ULL, 0x000fce00078efcffULL,
0x0000007d00ad7306ULL, 0x000fe20000209400ULL, 0x000000b4a700720bULL, 0x002fce0003fbd000ULL,
0x0000007d00be7306ULL, 0x000e620000205400ULL, 0x00000001bfbf3812ULL, 0x004fc800078efcffULL,
0x00000084bf8b723eULL, 0x000fc600000010ffULL, 0x0000007c00b67306ULL, 0x000ea8000020d400ULL,
0x0000008a7054723cULL, 0x000f680000041854ULL, 0x000000c900ca7306ULL, 0x000fe20000209400ULL,
0x000000bead00720bULL, 0x002fc60003f7d000ULL, 0x0000008a6c34723cULL, 0x000f680000041834ULL,
0x000000c9009b7306ULL, 0x000e620000205400ULL, 0x00000001b6b65812ULL, 0x004fc800078efcffULL,
0x000000b685b6723eULL, 0x000fc600000010ffULL, 0x0000007800bb7306ULL, 0x000ff00000209400ULL,
0x0000007800c67306ULL, 0x000ea20000205400ULL, 0x0000009bca00720bULL, 0x002fce0003f9d000ULL,
0x0000007d00c07306ULL, 0x000e70000020d400ULL, 0x0000007e00c37306ULL, 0x000fe20000009400ULL,
0x000000c6bb00720bULL, 0x004fce0003fbd000ULL, 0x0000007e00c47306ULL, 0x000ea20000005400ULL,
0x00000001c0c03812ULL, 0x002fc800078efcffULL, 0x000000c083b7723eULL, 0x000fc600000010ffULL,
0x0000007f00c77306ULL, 0x000fe80000009400ULL, 0x000000b67050723cULL, 0x000f680000041850ULL,
0x0000007f00c87306ULL, 0x000e620000005400ULL, 0x000000c4c300720bULL, 0x004fc60003fdd000ULL,
0x000000b66c30723cULL, 0x000f680000041830ULL, 0x0000007800c57306ULL, 0x000eb0000020d400ULL,
0x000000c900947306ULL, 0x000ee2000020d400ULL, 0x000000c8c700720bULL, 0x002fce0003f7d000ULL,
0x0000007a00787306ULL, 0x000fe20000209400ULL, 0x00000001c5c55812ULL, 0x004fce00078efcffULL,
0x0000007a007d7306ULL, 0x000e620000205400ULL, 0x0000000194944812ULL, 0x008fce00078efcffULL,
0x0000007a007c7306ULL, 0x000eb0000020d400ULL, 0x0000007b00917306ULL, 0x000fe20000209400ULL,
0x0000007d7800720bULL, 0x002fe40003fbd000ULL, 0x0000008ea978723eULL, 0x000fca00000010ffULL,
0x0000007b007a7306ULL, 0x000e640000205400ULL, 0x00000078705c723cULL, 0x080f68000004185cULL,
0x000000017c7c5812ULL, 0x004fe400078efcffULL, 0x0000007e00827306ULL, 0x0004e2000000d400ULL,
0x000000898600720bULL, 0x000fe20003fbd000ULL, 0x000000786c3c723cULL, 0x000b6c000004183cULL,
0x0000007f00777306ULL, 0x000f22000000d400ULL, 0x000100007e7e7824ULL, 0x004fe200078e00ffULL,
0x0000007a9100720bULL, 0x002fe20003f9d000ULL, 0x000000101f787824ULL, 0x020fc600078e0200ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000007b00937306ULL, 0x000e62000020d400ULL,
0x0000000182826812ULL, 0x008fe400078efcffULL, 0x000000908f00720bULL, 0x000fe40003fdd000ULL,
0x0000000176765812ULL, 0x000fe400078efcffULL, 0x00000082c582723eULL, 0x000fe200000010ffULL,
0x0000007e007f7306ULL, 0x000fe20000209400ULL, 0x0000000177773812ULL, 0x010fc400078efcffULL,
0x0000008d8c00720bULL, 0x000fe40003f7d000ULL, 0x000000779483723eULL, 0x000fc600000010ffULL,
0x0000007e00927306ULL, 0x000ea20000205400ULL, 0x0000000193934812ULL, 0x002fe400078efcffULL,
0x0000000181816812ULL, 0x000fe200078efcffULL, 0x00000082704c723cULL, 0x000f62000004184cULL,
0x000000878800720bULL, 0x000fe40003fdd000ULL, 0x0000007c817c723eULL, 0x000fe200000010ffULL,
0x00000096007d7306ULL, 0x000fe20000209400ULL, 0x0000000180803812ULL, 0x000fc600078efcffULL,
0x000000826c2c723cULL, 0x000f68000004182cULL, 0x00000096007a7306ULL, 0x000e620000205400ULL,
0x000000927f00720bULL, 0x004fe40003f9d000ULL, 0x0000000122226812ULL, 0x000fca00078efcffULL,
0x0000007e007b7306ULL, 0x000eb0000020d400ULL, 0x00000096007f7306ULL, 0x000ee2000020d400ULL,
0x0000007a7d00720bULL, 0x002fe40003f7d000ULL, 0x00000093807d723eULL, 0x000fc400000010ffULL,
0x000000017b7b4812ULL, 0x004fca00078efcffULL, 0x0000007c7058723cULL, 0x000f620000041858ULL,
0x0000007b7676723eULL, 0x000fc600000010ffULL, 0x000000017f7f3812ULL, 0x008fc800078efcffULL,
0x0000007c6c38723cULL, 0x000f620000041838ULL, 0x0000007f2277723eULL, 0x000fce00000010ffULL,
0x000000767048723cULL, 0x080b6e0000041848ULL, 0x000000101d707824ULL, 0x120fe200078e0225ULL,
0x000000766c6c723cULL, 0x000b620000041828ULL, 0x000000101e257824ULL, 0x000fc800078e0225ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000002528783bULL, 0x0204e20000000200ULL,
0x0000008000000947ULL, 0x000fd20003800000ULL, 0x0000000770707231ULL, 0x082fe400003400ffULL,
0x0000000772727231ULL, 0x000fe400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fc400003400ffULL, 0x0000000528287231ULL, 0x088fe400003400ffULL,
0x000000052a2a7231ULL, 0x000fe400003400ffULL, 0x0000000429297231ULL, 0x080fe400003400ffULL,
0x000000042b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010217c7824ULL, 0x000fe200078e0200ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0xfffffff823237812ULL, 0x000fc800078ec0ffULL, 0x000000007c7c783bULL, 0x000ea20000004200ULL,
0x00000100788f7824ULL, 0x010fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011478ULL,
0x0000007800267306ULL, 0x000fe20000009400ULL, 0x00000018ff827819ULL, 0x000fe2000001147aULL,
0x0000010079927824ULL, 0x000fe200078e00ffULL, 0x00000018ff907819ULL, 0x004fe2000001147dULL,
0x000001007aa57824ULL, 0x000fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe2000001148fULL,
0x000001007ba97824ULL, 0x000fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe2000001147bULL,
0x0000002100947306ULL, 0x000fe20000209400ULL, 0x00000018ff9e7819ULL, 0x000fe2000001147fULL,
0x000001007cb57824ULL, 0x000fe200078e00ffULL, 0x00000018ff9b7819ULL, 0x000fe20000011492ULL,
0x000001007db87824ULL, 0x000fe200078e00ffULL, 0x00000018ffa57819ULL, 0x000fc400000114a5ULL,
0x00000018ff257819ULL, 0x000fe20000011479ULL, 0x0000002100977306ULL, 0x000fe20000205400ULL,
0x00000018ff957819ULL, 0x000fe4000001147eULL, 0x00000018ffae7819ULL, 0x000fe400000114a9ULL,
0x00000018ffb57819ULL, 0x000fe400000114b5ULL, 0x00000018ffbe7819ULL, 0x000fe200000114b8ULL,
0x0000002100967306ULL, 0x0005f0000020d400ULL, 0x0000008200aa7306ULL, 0x000fe20000209400ULL,
0x00000018ff217819ULL, 0x004fce000001147cULL, 0x0000008200ab7306ULL, 0x000ff00000205400ULL,
0x0000008200777306ULL, 0x000ff0000020d400ULL, 0x0000009000c17306ULL, 0x000ff00000209400ULL,
0x0000009000c67306ULL, 0x000ff00000205400ULL, 0x0000009000827306ULL, 0x000ff0000020d400ULL,
0x0000007800277306ULL, 0x000eb00000005400ULL, 0x0000007900987306ULL, 0x000ff00000009400ULL,
0x0000007900997306ULL, 0x000f220000005400ULL, 0x000000272600720bULL, 0x004fe20003f7d000ULL,
0x000001007e267824ULL, 0x000fc400078e00ffULL, 0x000001007f277824ULL, 0x000fc600078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000008f00907306ULL, 0x000fe20000209400ULL,
0x00000018ff277819ULL, 0x000fce0000011427ULL, 0x0000008f00917306ULL, 0x000ea20000205400ULL,
0x000000999800720bULL, 0x010fce0003fdd000ULL, 0x00000086008a7306ULL, 0x000ff00000209400ULL,
0x00000086008b7306ULL, 0x000fe20000205400ULL, 0x000000919000720bULL, 0x004fce0003f9d000ULL,
0x0000008600227306ULL, 0x000ff0000020d400ULL, 0x0000002100ba7306ULL, 0x000ff00000209400ULL,
0x0000002100bb7306ULL, 0x000ff00000205400ULL, 0x0000002100837306ULL, 0x000ff0000020d400ULL,
0x0000009e00877306ULL, 0x000ff00000209400ULL, 0x0000009e00867306ULL, 0x000ff00000205400ULL,
0x0000009e00217306ULL, 0x0005f0000020d400ULL, 0x00000078006a7306ULL, 0x0008e2000000d400ULL,
0x00010000799e7824ULL, 0x004fca00078e00ffULL, 0x00000018ff9e7819ULL, 0x000fe4000001149eULL,
0x00000079009a7306ULL, 0x000ea2000000d400ULL, 0x0001000078787824ULL, 0x010fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000008f00937306ULL, 0x000f22000020d400ULL,
0x000000016a6a3812ULL, 0x008fce00078efcffULL, 0x0000009b009c7306ULL, 0x000fe20000209400ULL,
0x000000019a9a6812ULL, 0x004fce00078efcffULL, 0x0000009b009d7306ULL, 0x000ea20000205400ULL,
0x0000000193934812ULL, 0x010fe400078efcffULL, 0x000000979400720bULL, 0x000fe20003f9d000ULL,
0x000100007f947824ULL, 0x000fc800078e00ffULL, 0x0000009b009f7306ULL, 0x000ee2000020d400ULL,
0x00000018ff947819ULL, 0x000fce0000011494ULL, 0x0000009e008f7306ULL, 0x000fe20000209400ULL,
0x0000009d9c00720bULL, 0x004fe40003f1d000ULL, 0x0000000196964812ULL, 0x000fca00078efcffULL,
0x0000009e00a07306ULL, 0x000eac0000205400ULL, 0x000000019f9f0812ULL, 0x008fe400078efcffULL,
0x000000a5009b7306ULL, 0x000ff00000209400ULL, 0x000000a500a87306ULL, 0x000ee20000205400ULL,
0x000000a08f00720bULL, 0x004fce0003f7d000ULL, 0x0000002500a17306ULL, 0x000ff00000209400ULL,
0x0000002500a47306ULL, 0x000ea20000205400ULL, 0x000000a89b00720bULL, 0x008fce0003fdd000ULL,
0x00000025006b7306ULL, 0x000ef0000020d400ULL, 0x0000009500857306ULL, 0x000fe20000209400ULL,
0x000000a4a100720bULL, 0x004fce0003f1d000ULL, 0x0000009500887306ULL, 0x000fec0000205400ULL,
0x000000016b6b0812ULL, 0x008fe400078efcffULL, 0x0000009500257306ULL, 0x000ff0000020d400ULL,
0x0000009e00a27306ULL, 0x000eb0000020d400ULL, 0x000000a500a77306ULL, 0x000ef0000020d400ULL,
0x0000007b00ac7306ULL, 0x000fe20000009400ULL, 0x00000001a2a23812ULL, 0x004fc800078efcffULL,
0x000000a26b6b723eULL, 0x000fc600000010ffULL, 0x0000007b00ad7306ULL, 0x000ea20000005400ULL,
0x00000001a7a76812ULL, 0x008fe400078efcffULL, 0x000000abaa00720bULL, 0x000fca0003fdd000ULL,
0x0000007800927306ULL, 0x000ff00000209400ULL, 0x0000007800957306ULL, 0x000ee20000205400ULL,
0x000000adac00720bULL, 0x004fe40003f7d000ULL, 0x0000000177776812ULL, 0x000fca00078efcffULL,
0x000000ae00af7306ULL, 0x000ff00000209400ULL, 0x000000ae00b07306ULL, 0x000ea20000205400ULL,
0x000000959200720bULL, 0x008fce0003fbd000ULL, 0x0000007a00a37306ULL, 0x000ff00000009400ULL,
0x0000007a00a67306ULL, 0x000fe20000005400ULL, 0x000000b0af00720bULL, 0x004fce0003f9d000ULL,
0x0000007a008c7306ULL, 0x0005f0000000d400ULL, 0x0000007800797306ULL, 0x000722000020d400ULL,
0x000100007a7a7824ULL, 0x004fce00078e00ffULL, 0x0000007b00897306ULL, 0x000462000000d400ULL,
0x00000018ff787819ULL, 0x008fce000001147aULL, 0x000000ae00b27306ULL, 0x000ee2000020d400ULL,
0x000100007b7b7824ULL, 0x004fe200078e00ffULL, 0x0000000179795812ULL, 0x010fe400078efcffULL,
0x000000a6a300720bULL, 0x000fe40003fbd000ULL, 0x00000018ffa57819ULL, 0x000fe4000001147bULL,
0x00000078009e7306ULL, 0x000fe20000209400ULL, 0x0000000189893812ULL, 0x002fce00078efcffULL,
0x0000007800a97306ULL, 0x000e620000205400ULL, 0x00000001b2b24812ULL, 0x008fe400078efcffULL,
0x000000018c8c5812ULL, 0x000fca00078efcffULL, 0x0000007c00b37306ULL, 0x000ff00000009400ULL,
0x0000007c00b67306ULL, 0x000ea20000005400ULL, 0x000000a99e00720bULL, 0x002fce0003f1d000ULL,
0x0000007d00bc7306ULL, 0x000ff00000009400ULL, 0x0000007d00bd7306ULL, 0x000e620000005400ULL,
0x000000b6b300720bULL, 0x004fce0003f7d000ULL, 0x000000b500ae7306ULL, 0x000ff00000209400ULL,
0x000000b500b77306ULL, 0x000ea20000205400ULL, 0x000000bdbc00720bULL, 0x002fce0003fdd000ULL,
0x0000007c00847306ULL, 0x0002f0000000d400ULL, 0x0000007d00817306ULL, 0x0008e2000000d400ULL,
0x000100007c7c7824ULL, 0x002fe200078e00ffULL, 0x000000b7ae00720bULL, 0x004fc80003f9d000ULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x00000078007a7306ULL, 0x000e62000020d400ULL,
0x000100007d7d7824ULL, 0x010fe200078e00ffULL, 0x0000000184843812ULL, 0x008fe400078efcffULL,
0x000000bbba00720bULL, 0x000fe40003f7d000ULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x000000a500b17306ULL, 0x000fe20000209400ULL, 0x0000000181816812ULL, 0x000fce00078efcffULL,
0x000000a500b47306ULL, 0x000ea20000205400ULL, 0x000000017a7a0812ULL, 0x002fe400078efcffULL,
0x0000000183833812ULL, 0x000fe400078efcffULL, 0x0000007a777a723eULL, 0x000fc600000010ffULL,
0x000000a5007b7306ULL, 0x000e70000020d400ULL, 0x000000b500b97306ULL, 0x000ee2000020d400ULL,
0x000000b4b100720bULL, 0x004fce0003fbd000ULL, 0x000000be00bf7306ULL, 0x000fec0000209400ULL,
0x000000017b7b5812ULL, 0x002fe400078efcffULL, 0x000000be00c07306ULL, 0x000e620000205400ULL,
0x00000001b9b94812ULL, 0x008fce00078efcffULL, 0x0000007c00787306ULL, 0x000ff00000209400ULL,
0x0000007c00a57306ULL, 0x000ea20000205400ULL, 0x000000c0bf00720bULL, 0x002fce0003f1d000ULL,
0x0000007d00b57306ULL, 0x000ff00000209400ULL, 0x0000007d00c47306ULL, 0x000e620000205400ULL,
0x000000a57800720bULL, 0x004fe40003f9d000ULL, 0x0000008ca778723eULL, 0x000fca00000010ffULL,
0x000000be00c27306ULL, 0x000eb0000020d400ULL, 0x0000007c00b87306ULL, 0x000ee2000020d400ULL,
0x000000c4b500720bULL, 0x002fce0003fdd000ULL, 0x0000007d00917306ULL, 0x000e62000020d400ULL,
0x00000001c2c20812ULL, 0x004fe400078efcffULL, 0x000000c6c100720bULL, 0x000fca0003f1d000ULL,
0x0000007e00c37306ULL, 0x000fe20000009400ULL, 0x00000001b8b84812ULL, 0x008fc800078efcffULL,
0x000000b883b8723eULL, 0x000fc600000010ffULL, 0x0000007e00c87306ULL, 0x000ea20000005400ULL,
0x0000000191916812ULL, 0x002fe400078efcffULL, 0x0000000182820812ULL, 0x000fe400078efcffULL,
0x0000008b8a00720bULL, 0x000fc60003f1d000ULL, 0x0000007f008d7306ULL, 0x000ff00000009400ULL,
0x0000007f008e7306ULL, 0x000e620000005400ULL, 0x000000c8c300720bULL, 0x004fe40003fbd000ULL,
0x0000000122220812ULL, 0x000fc800078efcffULL, 0x0000007b227b723eULL, 0x000fe200000010ffULL,
0x00000026007c7306ULL, 0x000fec0000209400ULL, 0x0000007a2838723cULL, 0x000f640000041838ULL,
0x0000002600957306ULL, 0x000ea20000205400ULL, 0x0000008e8d00720bULL, 0x002fca0003f7d000ULL,
0x0000007a7058723cULL, 0x000f640000041858ULL, 0x00000027007d7306ULL, 0x000ff00000209400ULL,
0x0000002700927306ULL, 0x000e620000205400ULL, 0x000000957c00720bULL, 0x004fc40003f9d000ULL,
0x00000084b97c723eULL, 0x000fe400000010ffULL, 0x0000009182b9723eULL, 0x000fc600000010ffULL,
0x0000007e00807306ULL, 0x0004e8000000d400ULL, 0x000000b82830723cULL, 0x000f680000041830ULL,
0x00000026008f7306ULL, 0x0008e2000020d400ULL, 0x000100007e7e7824ULL, 0x004fe200078e00ffULL,
0x000000927d00720bULL, 0x002fc40003fdd000ULL, 0x00000081c27d723eULL, 0x000fe200000010ffULL,
0x000000b87050723cULL, 0x000f620000041850ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007f00767306ULL, 0x000e62000000d400ULL, 0x0000006a9326723eULL, 0x010fe400000010ffULL,
0x0000000180805812ULL, 0x008fe400078efcffULL, 0x000000868700720bULL, 0x000fe20003fbd000ULL,
0x0000007c2834723cULL, 0x000f620000041834ULL, 0x00000079966a723eULL, 0x000fe200000010ffULL,
0x0000002700977306ULL, 0x0004e2000020d400ULL, 0x000000018f8f4812ULL, 0x000fc400078efcffULL,
0x000000888500720bULL, 0x000fe40003f9d000ULL, 0x00000089b279723eULL, 0x000fe200000010ffULL,
0x0000006a2840723cULL, 0x040f620000041840ULL, 0x000000808f80723eULL, 0x000fe200000010ffULL,
0x0000007e007f7306ULL, 0x000fe20000209400ULL, 0x0000000176763812ULL, 0x002fe400078efcffULL,
0x0000000121215812ULL, 0x000fe400078efcffULL, 0x0000009a9f27723eULL, 0x004fe200000010ffULL,
0x00000078283c723cULL, 0x000f64000004183cULL, 0x0000007e00907306ULL, 0x000e620000205400ULL,
0x0000000197976812ULL, 0x008fc400078efcffULL, 0x0000000125254812ULL, 0x000fe400078efcffULL,
0x000000769781723eULL, 0x000fe200000010ffULL, 0x000000262844723cULL, 0x040f640000041844ULL,
0x0000009400937306ULL, 0x000fec0000209400ULL, 0x00000080282c723cULL, 0x000f64000004182cULL,
0x00000094008c7306ULL, 0x000ea20000205400ULL, 0x000000907f00720bULL, 0x002fca0003fdd000ULL,
0x000000267064723cULL, 0x040f640000041864ULL, 0x0000007e007e7306ULL, 0x000e6c000020d400ULL,
0x00000078705c723cULL, 0x000f64000004185cULL, 0x0000009400947306ULL, 0x000ee2000020d400ULL,
0x0000008c9300720bULL, 0x004fca0003f7d000ULL, 0x0000007c7054723cULL, 0x000f620000041854ULL,
0x000000017e7e6812ULL, 0x002fc800078efcffULL, 0x0000007e257e723eULL, 0x000fc600000010ffULL,
0x00000080704c723cULL, 0x000f62000004184cULL, 0x0000000194943812ULL, 0x008fc800078efcffULL,
0x00000094217f723eULL, 0x000fc600000010ffULL, 0x0000006a7060723cULL, 0x040b6e0000041860ULL,
0x0001a6c8136a7811ULL, 0x020fe200078e18ffULL, 0x0000007e7048723cULL, 0x080b700000041848ULL,
0x0000007e2828723cULL, 0x000b62000004186cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000006a6a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6980023ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff217224ULL, 0x000fc600078e00ffULL, 0x0000000000227805ULL, 0x004fc80000015200ULL,
0x000004000d257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc4000780486bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002622267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e23ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011427ULL, 0x0000002625257211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x0000000225257819ULL, 0x000fc80000001226ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000121217810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010f227810ULL, 0x000fc80007ffe0ffULL,
0x000000152200720cULL, 0x000fda0003f06070ULL, 0x0000072000000947ULL, 0x000fea0003800000ULL,
0x000000020f227810ULL, 0x000fe40007ffe0ffULL, 0x000001000c217810ULL, 0x000fe40007ffe0ffULL,
0x000000152200720cULL, 0x000fc60003f06070ULL, 0x0000680012257a24ULL, 0x000fd400078e0221ULL,
0x000003d000008947ULL, 0x000fea0003800000ULL, 0x00000021160c7217ULL, 0x000fe20007800000ULL,
0x00000010116b7824ULL, 0x000fe200078e00ffULL, 0x00000003ff277819ULL, 0x000fc60000011617ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a21ULL, 0x00000004276d7810ULL, 0x020fe20007ffe0ffULL,
0x000000016b227824ULL, 0x000fe200078e0227ULL, 0x00000008276f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c6b0c7217ULL, 0x000fe20007800000ULL, 0x0000000122217824ULL, 0x040fe200078e0217ULL,
0x0000000c27717810ULL, 0x000fe20007ffe0ffULL, 0x0000000822267824ULL, 0x000fe400078e00ffULL,
0x000000016b6e7824ULL, 0x000fc400078e026dULL, 0x0000000122227824ULL, 0x000fe200078e0225ULL,
0xfffffff826217812ULL, 0x000fe200078ee221ULL, 0x000000010c0c7824ULL, 0x000fe400078e0a6bULL,
0x000000016e267824ULL, 0x000fe400078e0225ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000000c2700720cULL, 0x080fe40003f06070ULL, 0x0000000c6d00720cULL, 0x080fe20003f86070ULL,
0x000000016b707824ULL, 0x000fe200078e026fULL, 0x0000000b226c7212ULL, 0x000fe200078efcffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000c6f00720cULL, 0x000fc40003f66070ULL,
0x000064006c6c7a10ULL, 0x000fe20007fbe0ffULL, 0x00000001706a7824ULL, 0x000fe200078e0225ULL,
0x0000000b26267212ULL, 0x080fe200078efcffULL, 0x000000016b727824ULL, 0x000fe200078e0271ULL,
0x00006500236d7a10ULL, 0x000fe20002ffe4ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000640026267a10ULL, 0x000fe40007fde0ffULL, 0x0000000c7100720cULL, 0x000fe20003fa6070ULL,
0x0000000172227824ULL, 0x000fe200078e0225ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x000000016e257824ULL, 0x040fe200078e0217ULL, 0x0000650027277a10ULL, 0x000fe200037fe4ffULL,
0x000000086e6e7824ULL, 0x000fe200078e00ffULL, 0x000064006a6a7a10ULL, 0x000fe20007fde0ffULL,
0x0000008022227825ULL, 0x000fc600078e00ffULL, 0xfffffff86e257812ULL, 0x000fe200078ee225ULL,
0x00000001700c7824ULL, 0x100fe200078e0217ULL, 0x0000000b22227212ULL, 0x000fe200078efcffULL,
0x00000008706f7824ULL, 0x000fe200078e00ffULL, 0x000065006b6b7a10ULL, 0x000fe200037fe4ffULL,
0x00000001726e7824ULL, 0x000fe200078e0217ULL, 0x0000640022227a10ULL, 0x000fe20007fde0ffULL,
0x0000000872717824ULL, 0x000fe200078e00ffULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee20cULL,
0x0000001021217824ULL, 0x100fe200078e0200ULL, 0x0000650023237a10ULL, 0x000fe200037fe4ffULL,
0x0000001025257824ULL, 0x000fe200078e0200ULL, 0xfffffff871717812ULL, 0x000fe200078ee26eULL,
0x000000106f6f7824ULL, 0x100fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c217faeULL, 0x0003e6000c101c46ULL, 0x0000001071717824ULL, 0x000fe200078e0200ULL,
0x0000000026257faeULL, 0x0003e8000e101c46ULL, 0x000000006a6f7faeULL, 0x0003e8000d901c46ULL,
0x0000000022717faeULL, 0x0003e2000e901c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x00000010110c7824ULL, 0x000fca00078e00ffULL, 0x0000000c170c7211ULL, 0x000fc800078fe8ffULL,
0x000000040c267810ULL, 0x040fe20007ffe0ffULL, 0x000000010c217824ULL, 0x140fe200078e0217ULL,
0x000000080c6a7810ULL, 0x040fe20007ffe0ffULL, 0x000000080c6c7824ULL, 0x020fe400078e00ffULL,
0x0000000126227824ULL, 0x040fe400078e0217ULL, 0x00000008266f7824ULL, 0x000fe200078e00ffULL,
0xfffffff86c217812ULL, 0x000fe200078ee221ULL, 0x000000016a237824ULL, 0x040fe400078e0217ULL,
0x000000086a6e7824ULL, 0x000fe200078e00ffULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee222ULL,
0x000000010c227824ULL, 0x140fe200078e0225ULL, 0x0000000c0c0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000126267824ULL, 0x000fe200078e0225ULL, 0xfffffff86e717812ULL, 0x000fe200078ee223ULL,
0x0000008022227825ULL, 0x000fc800078e00ffULL, 0x000000016a6a7824ULL, 0x100fe200078e0225ULL,
0x0000000b22227212ULL, 0x000fe200078efcffULL, 0x000000010c6c7824ULL, 0x000fe400078e0225ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000640022227a10ULL, 0x000fc60007f1e0ffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b26267212ULL, 0x080fe400078efcffULL,
0x0000650023237a10ULL, 0x000fe200007fe4ffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000000b6a6a7212ULL, 0x080fe400078efcffULL, 0x0000640026267a10ULL, 0x000fe20007f7e0ffULL,
0x000000010c257824ULL, 0x000fe200078e0217ULL, 0x0000000b6c6c7212ULL, 0x000fe200078efcffULL,
0x000000080c0c7824ULL, 0x000fe200078e00ffULL, 0x000064006a6a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000001021217824ULL, 0x100fe200078e0200ULL, 0x000064006c6c7a10ULL, 0x000fe20007f9e0ffULL,
0x000000106f6f7824ULL, 0x100fe200078e0200ULL, 0xfffffff80c257812ULL, 0x000fe200078ee225ULL,
0x0000001071717824ULL, 0x100fe200078e0200ULL, 0x0000650027277a10ULL, 0x000fe20001ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022217faeULL, 0x0003e2000b901c46ULL,
0x000065006b6b7a10ULL, 0x000fe200007fe4ffULL, 0x0000001025257824ULL, 0x000fe200078e0200ULL,
0x000065006d6d7a10ULL, 0x000fe200027fe4ffULL, 0x00000000266f7faeULL, 0x0003e8000b901c46ULL,
0x000000006a717faeULL, 0x0003e8000b901c46ULL, 0x000000006c257faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000814217812ULL, 0x000fe200078ec0ffULL,
0x00000020100c7824ULL, 0x000fc400078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x00000001210c7824ULL, 0x000fe200078e020cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000008227f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a668000c6a7f8cULL, 0x000662000c80043fULL,
0x000000ffff217224ULL, 0x004fc600078e0023ULL, 0x0000000000227805ULL, 0x000fc80000015200ULL,
0x01a66c000c257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fe4000780486bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6c7224ULL, 0x020fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002622257210ULL, 0x000fca0007f1e1ffULL,
0x0000000127267824ULL, 0x000fe200000e0e23ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011426ULL,
0x0000002508087211ULL, 0x000fca00078110ffULL, 0x000000ffff257224ULL, 0x000fca00000e0626ULL,
0x0000000208087819ULL, 0x000fc80000001225ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016c6c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a66c000c257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018010087811ULL, 0x000fc800078e38ffULL, 0x000000080a087210ULL, 0x000fca0007ffe00bULL,
0x01a00000086d7984ULL, 0x000e680000000800ULL, 0x01a20000080c7984ULL, 0x0084e20000000800ULL,
0x000000206d00720bULL, 0x002fe20003f1d000ULL, 0x0000fe727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000087806ULL, 0x004fc800000e0100ULL, 0x000000ff0800720cULL, 0x000fe20003f05270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x00000001ff227424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fd200078e0020ULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x0000000310237810ULL, 0x000fe40007ffe0ffULL, 0x000000206d00720bULL, 0x000fe40003f74000ULL,
0x0000001a2300720cULL, 0x000fe20003f05270ULL, 0x0000fe327f007947ULL, 0x000fd4000b800000ULL,
0x0000000000717806ULL, 0x000fc400018e0100ULL, 0x000000801a0b8824ULL, 0x000fe200078e020bULL,
0x000000206d237209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a0a8824ULL, 0x000fca00078e020bULL, 0x01a400230a008388ULL, 0x0003e20000000800ULL,
0x000000ff7100720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x00000020230a7221ULL, 0x002fe20000010100ULL, 0x000000ff71ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL,
0x0000000a00277308ULL, 0x000e640000000800ULL, 0x0000002724247220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x0000fd827f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002a400000e0000ULL,
0x0000002664647220ULL, 0x084fe40000410000ULL, 0x0000002665657220ULL, 0x080fe40000410000ULL,
0x0000002660607220ULL, 0x080fe40000410000ULL, 0x0000002661617220ULL, 0x080fe40000410000ULL,
0x000000265c5c7220ULL, 0x080fe40000410000ULL, 0x000000265d5d7220ULL, 0x000fc40000410000ULL,
0x0000002658587220ULL, 0x080fe40000410000ULL, 0x0000002659597220ULL, 0x080fe40000410000ULL,
0x0000002654547220ULL, 0x080fe40000410000ULL, 0x0000002655557220ULL, 0x080fe40000410000ULL,
0x0000002650507220ULL, 0x080fe40000410000ULL, 0x0000002651517220ULL, 0x000fc40000410000ULL,
0x000000264c4c7220ULL, 0x080fe40000410000ULL, 0x000000264d4d7220ULL, 0x080fe40000410000ULL,
0x0000002648487220ULL, 0x080fe40000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0071ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x0000fc627f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x00046400000e0000ULL, 0x0000002666667220ULL, 0x086fe40000410000ULL,
0x0000002667677220ULL, 0x080fe40000410000ULL, 0x0000002662627220ULL, 0x080fe40000410000ULL,
0x0000002663637220ULL, 0x080fe40000410000ULL, 0x000000265e5e7220ULL, 0x080fe40000410000ULL,
0x000000265f5f7220ULL, 0x000fc40000410000ULL, 0x000000265a5a7220ULL, 0x080fe40000410000ULL,
0x000000265b5b7220ULL, 0x080fe40000410000ULL, 0x0000002656567220ULL, 0x080fe40000410000ULL,
0x0000002657577220ULL, 0x080fe40000410000ULL, 0x0000002652527220ULL, 0x080fe40000410000ULL,
0x0000002653537220ULL, 0x000fc40000410000ULL, 0x000000264e4e7220ULL, 0x080fe40000410000ULL,
0x000000264f4f7220ULL, 0x080fe40000410000ULL, 0x000000264a4a7220ULL, 0x080fe40000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000071ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x0000fb427f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x00046400000e0000ULL,
0x0000002644447220ULL, 0x086fe40000410000ULL, 0x0000002645457220ULL, 0x080fe40000410000ULL,
0x0000002640407220ULL, 0x080fe40000410000ULL, 0x0000002641417220ULL, 0x080fe40000410000ULL,
0x000000263c3c7220ULL, 0x080fe40000410000ULL, 0x000000263d3d7220ULL, 0x000fc40000410000ULL,
0x0000002638387220ULL, 0x080fe40000410000ULL, 0x0000002639397220ULL, 0x080fe40000410000ULL,
0x0000002634347220ULL, 0x080fe40000410000ULL, 0x0000002635357220ULL, 0x080fe40000410000ULL,
0x0000002630307220ULL, 0x080fe40000410000ULL, 0x0000002631317220ULL, 0x000fc40000410000ULL,
0x000000262c2c7220ULL, 0x080fe40000410000ULL, 0x000000262d2d7220ULL, 0x080fe40000410000ULL,
0x0000002628287220ULL, 0x080fe40000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000071ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x0000fa327f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x00046400000e0000ULL,
0x0000002646467220ULL, 0x086fe40000410000ULL, 0x0000002647477220ULL, 0x080fe40000410000ULL,
0x0000002642427220ULL, 0x080fe40000410000ULL, 0x0000002643437220ULL, 0x080fe40000410000ULL,
0x000000263e3e7220ULL, 0x080fe40000410000ULL, 0x000000263f3f7220ULL, 0x000fc40000410000ULL,
0x000000263a3a7220ULL, 0x080fe40000410000ULL, 0x000000263b3b7220ULL, 0x080fe40000410000ULL,
0x0000002636367220ULL, 0x080fe40000410000ULL, 0x0000002637377220ULL, 0x080fe40000410000ULL,
0x0000002632327220ULL, 0x080fe40000410000ULL, 0x0000002633337220ULL, 0x000fc40000410000ULL,
0x000000262e2e7220ULL, 0x080fe40000410000ULL, 0x000000262f2f7220ULL, 0x080fe40000410000ULL,
0x000000262a2a7220ULL, 0x080fe40000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000007108ff7212ULL, 0x000fda00078030ffULL,
0x0000006d236d0221ULL, 0x000fe20000010100ULL, 0x00007610ff220816ULL, 0x000fc60000000022ULL,
0x3fb8aa3b6d6d0820ULL, 0x000fc80000410000ULL, 0x0000006d00090308ULL, 0x000e640000000800ULL,
0x000000090c0c0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000240c247221ULL, 0x008fc40000010000ULL, 0x00000000000a7805ULL, 0x000fca0000015200ULL,
0xfffffff014207812ULL, 0x000fca00078ec0ffULL, 0x01a6b40020257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x000000260a257210ULL, 0x000fca0007f1e1ffULL, 0x0000000127267824ULL, 0x000fe200000e0e0bULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011426ULL, 0x0000002508087211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0626ULL, 0x0000000208087819ULL, 0x000fc80000001225ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6b40020257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991022087816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff04723eULL, 0x000fe400000010ffULL,
0x00000002ff087819ULL, 0x000fe40000011617ULL, 0x0000541004277816ULL, 0x000fe20000000004ULL,
0x0000f6227f007947ULL, 0x000fea000b800000ULL, 0x00001f0827077589ULL, 0x0002a400000e0000ULL,
0x0000000808267810ULL, 0x000fe20007ffe0ffULL, 0x0000f6627f007947ULL, 0x000fea000b800000ULL,
0x0000001008047810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0427057589ULL, 0x0006a400000e0000ULL, 0x0000001808267810ULL, 0x008fe20007ffe0ffULL,
0x0000f6d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000113087812ULL, 0x002fe200078ec0ffULL,
0x0000000803257824ULL, 0x000fe200078e00ffULL, 0x00000004ff0b7819ULL, 0x000fe20000011617ULL,
0x0000000802277824ULL, 0x008fe200078e00ffULL, 0x0000100000007810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000001b000007945ULL, 0x000fe20003800000ULL,
0x0000000408087824ULL, 0x000fc400078e020bULL, 0x000000041a0b7824ULL, 0x000fe400078e00ffULL,
0x00000001030a7824ULL, 0x100fe400078e0208ULL, 0x0000000102087824ULL, 0x000fe200078e0208ULL,
0x000000040b0c7812ULL, 0x000fe200078ec0ffULL, 0x000000101c787824ULL, 0x000fe200078e0200ULL,
0xfffffff8250b7812ULL, 0x000fe400078ee20aULL, 0xfffffff827257812ULL, 0x000fe400078ee208ULL,
0x00015000100a7811ULL, 0x000fc400078e60ffULL, 0x000000020c0c7812ULL, 0x000fc600078efcffULL,
0x000000100b0b7824ULL, 0x100fe200078e020aULL, 0x0000000c17087211ULL, 0x000fe200078fe0ffULL,
0x0000001025257824ULL, 0x000fe400078e020aULL, 0x00000008030c7824ULL, 0x040fe200078e00ffULL,
0x000000000b6c783bULL, 0x0002e20000000200ULL, 0x0000000103037824ULL, 0x000fc600078e0208ULL,
0x000000002568783bULL, 0x0002a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x000000076c6c7231ULL, 0x08cfe400003400ffULL, 0x000000076e6e7231ULL, 0x000fe400003400ffULL,
0x000000066d6d7231ULL, 0x080fe400003400ffULL, 0x000000066f6f7231ULL, 0x000fe400003400ffULL,
0x0000000568687231ULL, 0x080fe400003400ffULL, 0x000000056a6a7231ULL, 0x000fc400003400ffULL,
0x0000000469697231ULL, 0x080fe400003400ffULL, 0x000000046b6b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff80c037812ULL, 0x000fe200078ee203ULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x000000101e1e7824ULL, 0x000fe200078e020aULL,
0x00000fa000007945ULL, 0x000fe20003800000ULL, 0x0000000102087824ULL, 0x000fe400078e0208ULL,
0x0000001003037824ULL, 0x000fca00078e0200ULL, 0x000000000370783bULL, 0x000e620000004200ULL,
0x0000010078887824ULL, 0x010fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fe2000001147aULL,
0x00000100798b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0b7819ULL, 0x002fe20000011478ULL,
0x0000007800267306ULL, 0x000fe20000009400ULL, 0x00000018ff887819ULL, 0x000fe20000011488ULL,
0x000001007aa07824ULL, 0x000fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe2000001148bULL,
0x000001007ba47824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147bULL,
0x0000010070b27824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fe20000011471ULL,
0x0000002200a37306ULL, 0x000fe20000209400ULL, 0x00000018ff977819ULL, 0x000fe20000011473ULL,
0x0000010071b67824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc40000011479ULL,
0x00000018ff8e7819ULL, 0x000fe40000011472ULL, 0x00000018ffa07819ULL, 0x000fe200000114a0ULL,
0x0000002200a67306ULL, 0x000fe20000205400ULL, 0x00000018ffa77819ULL, 0x000fe400000114a4ULL,
0x00000018ffb27819ULL, 0x000fe400000114b2ULL, 0x00000018ffb97819ULL, 0x000fc600000114b6ULL,
0x0000002200837306ULL, 0x000ff0000020d400ULL, 0x0000008900be7306ULL, 0x000ff00000209400ULL,
0x0000008900bf7306ULL, 0x000ff00000205400ULL, 0x0000008900227306ULL, 0x000ff0000020d400ULL,
0x0000008800897306ULL, 0x000ff00000209400ULL, 0x00000088008a7306ULL, 0x000e700000205400ULL,
0x0000000b008d7306ULL, 0x000ff00000209400ULL, 0x0000000b00907306ULL, 0x000fe20000205400ULL,
0x0000008a8900720bULL, 0x002fce0003fbd000ULL, 0x0000000b00927306ULL, 0x0003f0000020d400ULL,
0x0000007800277306ULL, 0x000f220000005400ULL, 0x00000018ff0b7819ULL, 0x002fce0000011470ULL,
0x0000007800877306ULL, 0x0002f0000000d400ULL, 0x00000079008f7306ULL, 0x000fe20000009400ULL,
0x0001000078787824ULL, 0x002fe200078e00ffULL, 0x000000272600720bULL, 0x010fe20003fdd000ULL,
0x0000010072267824ULL, 0x000fc400078e00ffULL, 0x0000010073277824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000007900947306ULL, 0x000e620000005400ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff277819ULL, 0x000fc80000011427ULL,
0x0000000187876812ULL, 0x008fe200078efcffULL, 0x0000009300957306ULL, 0x000fe20000209400ULL,
0x000000908d00720bULL, 0x000fce0003fdd000ULL, 0x0000009300967306ULL, 0x000ee20000205400ULL,
0x000000948f00720bULL, 0x002fca0003f9d000ULL, 0x0000000192926812ULL, 0x000fe400078efcffULL,
0x0000007e00ae7306ULL, 0x000ff00000209400ULL, 0x0000007e00af7306ULL, 0x000fe20000205400ULL,
0x000000969500720bULL, 0x008fce0003f7d000ULL, 0x0000007e00777306ULL, 0x000ff0000020d400ULL,
0x0000000b00b57306ULL, 0x000ff00000209400ULL, 0x0000000b00b87306ULL, 0x000ff00000205400ULL,
0x0000000b00257306ULL, 0x000ff0000020d400ULL, 0x0000009700817306ULL, 0x000ff00000209400ULL,
0x00000097007e7306ULL, 0x000ff00000205400ULL, 0x00000097000b7306ULL, 0x0003f0000020d400ULL,
0x0000001c009b7306ULL, 0x000fe20000209400ULL, 0x0001000079977824ULL, 0x002fca00078e00ffULL,
0x00000018ff977819ULL, 0x000fe40000011497ULL, 0x0000001c009c7306ULL, 0x000ff00000205400ULL,
0x0000001c009d7306ULL, 0x000ff0000020d400ULL, 0x0000008e007d7306ULL, 0x000ff00000209400ULL,
0x0000008e00807306ULL, 0x000ff00000205400ULL, 0x0000008e001c7306ULL, 0x000ff0000020d400ULL,
0x00000088008c7306ULL, 0x000e70000020d400ULL, 0x00000078008b7306ULL, 0x000ff00000209400ULL,
0x00000078008e7306ULL, 0x000ee20000205400ULL, 0x000000018c8c5812ULL, 0x002fce00078efcffULL,
0x0000007900917306ULL, 0x000e70000000d400ULL, 0x0000009300987306ULL, 0x000f22000020d400ULL,
0x0000008e8b00720bULL, 0x008fce0003fbd000ULL, 0x0000009700887306ULL, 0x000fe20000209400ULL,
0x0000000191914812ULL, 0x002fe400078efcffULL, 0x0000009c9b00720bULL, 0x000fca0003f9d000ULL,
0x0000009700997306ULL, 0x000e620000205400ULL, 0x0000000198983812ULL, 0x010fce00078efcffULL,
0x0000007800797306ULL, 0x000ee2000020d400ULL, 0x000000019d9d4812ULL, 0x000fce00078efcffULL,
0x000000a000937306ULL, 0x000fe20000209400ULL, 0x000000998800720bULL, 0x002fce0003f7d000ULL,
0x000000a000a27306ULL, 0x000e620000205400ULL, 0x0000000179795812ULL, 0x008fce00078efcffULL,
0x00000097009a7306ULL, 0x000ef0000020d400ULL, 0x0000007a009e7306ULL, 0x000fe20000009400ULL,
0x000000a29300720bULL, 0x002fce0003fbd000ULL, 0x0000007a009f7306ULL, 0x000e620000005400ULL,
0x000000019a9a3812ULL, 0x008fce00078efcffULL, 0x0000007a00867306ULL, 0x000730000000d400ULL,
0x0000007b00a57306ULL, 0x000fe20000009400ULL, 0x000100007a7a7824ULL, 0x008fe200078e00ffULL,
0x0000009f9e00720bULL, 0x002fc80003fdd000ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x0000007b00a87306ULL, 0x000e6e0000005400ULL, 0x0000000186866812ULL, 0x010fe200078efcffULL,
0x000000a700a97306ULL, 0x000fe20000209400ULL, 0x000000a6a300720bULL, 0x000fce0003fdd000ULL,
0x000000a700aa7306ULL, 0x000ee20000205400ULL, 0x000000a8a500720bULL, 0x002fca0003f9d000ULL,
0x0000000183836812ULL, 0x000fe400078efcffULL, 0x0000007b00827306ULL, 0x000330000000d400ULL,
0x000000a000a17306ULL, 0x000ea2000020d400ULL, 0x000100007b7b7824ULL, 0x002fe200078e00ffULL,
0x000000aaa900720bULL, 0x008fc80003f7d000ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x0000007a00787306ULL, 0x000fe20000209400ULL, 0x0000000182824812ULL, 0x010fe400078efcffULL,
0x000000afae00720bULL, 0x000fca0003f9d000ULL, 0x0000007a00977306ULL, 0x000e620000205400ULL,
0x00000001a1a15812ULL, 0x004fce00078efcffULL, 0x000000a700ab7306ULL, 0x000ea2000020d400ULL,
0x0000000177774812ULL, 0x000fce00078efcffULL, 0x0000007b00a07306ULL, 0x000fe20000209400ULL,
0x000000977800720bULL, 0x002fce0003fbd000ULL, 0x0000007b00ad7306ULL, 0x000e620000205400ULL,
0x00000001abab3812ULL, 0x004fce00078efcffULL, 0x0000007a00a47306ULL, 0x000eb0000020d400ULL,
0x000000b200a77306ULL, 0x000fe20000209400ULL, 0x000000ada000720bULL, 0x002fce0003f7d000ULL,
0x000000b200b47306ULL, 0x000e620000205400ULL, 0x00000001a4a45812ULL, 0x004fc800078efcffULL,
0x000000a483a4723eULL, 0x000fc600000010ffULL, 0x0000007b00ac7306ULL, 0x000eb0000020d400ULL,
0x0000007000b07306ULL, 0x000fe20000009400ULL, 0x000000b4a700720bULL, 0x002fce0003fbd000ULL,
0x0000007000b17306ULL, 0x000e620000005400ULL, 0x00000001acac3812ULL, 0x004fc800078efcffULL,
0x000000ac77a5723eULL, 0x000fc600000010ffULL, 0x0000007000767306ULL, 0x0004e8000000d400ULL,
0x000000a46c58723cULL, 0x000f680000041858ULL, 0x0000007100b77306ULL, 0x000fe20000009400ULL,
0x0001000070707824ULL, 0x004fe200078e00ffULL, 0x000000b1b000720bULL, 0x002fc40003fdd000ULL,
0x000000a46838723cULL, 0x000f640000041838ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000007100ba7306ULL, 0x000e6e0000005400ULL, 0x0000000176766812ULL, 0x008fe200078efcffULL,
0x000000b900bb7306ULL, 0x000fe20000209400ULL, 0x000000b8b500720bULL, 0x000fce0003fdd000ULL,
0x000000b900bc7306ULL, 0x000ea20000205400ULL, 0x000000bab700720bULL, 0x002fca0003f9d000ULL,
0x0000000125256812ULL, 0x000fe400078efcffULL, 0x0000007100207306ULL, 0x0002f0000000d400ULL,
0x000000b200b37306ULL, 0x000f22000020d400ULL, 0x0001000071717824ULL, 0x002fe200078e00ffULL,
0x000000bcbb00720bULL, 0x004fc80003f7d000ULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x00000070007a7306ULL, 0x000fe20000209400ULL, 0x0000000120204812ULL, 0x008fce00078efcffULL,
0x00000070007b7306ULL, 0x000e620000205400ULL, 0x00000001b3b35812ULL, 0x010fc800078efcffULL,
0x00000076b376723eULL, 0x000fc600000010ffULL, 0x000000b900bd7306ULL, 0x000eb0000020d400ULL,
0x0000007100897306ULL, 0x000fe20000209400ULL, 0x0000007b7a00720bULL, 0x002fce0003fbd000ULL,
0x00000071008a7306ULL, 0x000e620000205400ULL, 0x00000001bdbd3812ULL, 0x004fe400078efcffULL,
0x000000bfbe00720bULL, 0x000fe40003f7d000ULL, 0x00000020bd77723eULL, 0x000fc600000010ffULL,
0x0000007000b67306ULL, 0x0004e8000020d400ULL, 0x000000766c54723cULL, 0x080f680000041854ULL,
0x0000002600887306ULL, 0x000fe20000209400ULL, 0x0000008a8900720bULL, 0x002fe40003f9d000ULL,
0x000000799270723eULL, 0x004fe200000010ffULL, 0x000000766834723cULL, 0x000f620000041834ULL,
0x0000000122223812ULL, 0x000fc600078efcffULL, 0x00000026008d7306ULL, 0x000e620000205400ULL,
0x00000001b6b65812ULL, 0x008fc800078efcffULL, 0x000000b625b6723eULL, 0x000fc600000010ffULL,
0x00000071008b7306ULL, 0x0004f0000020d400ULL, 0x0000007200847306ULL, 0x000fe20000009400ULL,
0x0000008d8800720bULL, 0x002fe40003fbd000ULL, 0x0000009a9d71723eULL, 0x004fca00000010ffULL,
0x0000007200857306ULL, 0x000e620000005400ULL, 0x000000018b8b4812ULL, 0x008fe200078efcffULL,
0x000000706c60723cULL, 0x000f660000041860ULL, 0x0000008b22b7723eULL, 0x000fc600000010ffULL,
0x00000073007c7306ULL, 0x000fe40000009400ULL, 0x000000706840723cULL, 0x000f6c0000041840ULL,
0x00000073007f7306ULL, 0x000ea20000005400ULL, 0x000000858400720bULL, 0x002fe20003fdd000ULL,
0x000000b66c50723cULL, 0x080f6c0000041850ULL, 0x00000027008e7306ULL, 0x000fe40000209400ULL,
0x000000b66830723cULL, 0x000f6c0000041830ULL, 0x0000002700937306ULL, 0x000e620000205400ULL,
0x0000007f7c00720bULL, 0x004fce0003f7d000ULL, 0x00000072000c7306ULL, 0x0004f0000000d400ULL,
0x0000007300037306ULL, 0x0008e2000000d400ULL, 0x0001000072727824ULL, 0x004fe200078e00ffULL,
0x000000938e00720bULL, 0x002fc80003f9d000ULL, 0x00000018ff787819ULL, 0x000fe40000011472ULL,
0x00000026008f7306ULL, 0x0002a2000020d400ULL, 0x0001000073737824ULL, 0x010fe200078e00ffULL,
0x000000010c0c6812ULL, 0x008fe400078efcffULL, 0x0000007e8100720bULL, 0x000fe40003fdd000ULL,
0x00000086a172723eULL, 0x000fe400000010ffULL, 0x0000002700907306ULL, 0x000722000020d400ULL,
0x000000878c26723eULL, 0x002fc400000010ffULL, 0x00000018ff877819ULL, 0x000fe40000011473ULL,
0x00000082ab73723eULL, 0x000fe400000010ffULL, 0x0000000103033812ULL, 0x000fe200078efcffULL,
0x00000078007a7306ULL, 0x000fe20000209400ULL, 0x000000018f8f5812ULL, 0x004fe400078efcffULL,
0x000000807d00720bULL, 0x000fe20003fbd000ULL, 0x000000726c5c723cULL, 0x000f62000004185cULL,
0x000000010b0b6812ULL, 0x000fc400078efcffULL, 0x000000919827723eULL, 0x008fe200000010ffULL,
0x00000078007b7306ULL, 0x000e620000205400ULL, 0x0000000190904812ULL, 0x010fc600078efcffULL,
0x00000072683c723cULL, 0x000f68000004183cULL, 0x0000008700797306ULL, 0x000fe20000209400ULL,
0x000000011c1c5812ULL, 0x000fc600078efcffULL, 0x000000266c64723cULL, 0x000f680000041864ULL,
0x0000008700827306ULL, 0x000ea20000205400ULL, 0x0000007b7a00720bULL, 0x002fc60003f9d000ULL,
0x000000266844723cULL, 0x000f680000041844ULL, 0x00000078007d7306ULL, 0x0002f0000020d400ULL,
0x0000008700207306ULL, 0x000f22000020d400ULL, 0x000000827900720bULL, 0x004fc40003f7d000ULL,
0x0000000c8f78723eULL, 0x002fe400000010ffULL, 0x000000039079723eULL, 0x000fe200000010ffULL,
0x000000101d037824ULL, 0x000fe200078e020aULL, 0x000000017d7d4812ULL, 0x008fc800078efcffULL,
0x0000007d1c7a723eULL, 0x000fe200000010ffULL, 0x000000786c4c723cULL, 0x000f64000004184cULL,
0x0000000120203812ULL, 0x010fc800078efcffULL, 0x000000200b7b723eULL, 0x000fe400000010ffULL,
0x00000078682c723cULL, 0x000f62000004182cULL, 0x00000008020b7824ULL, 0x000fce00078e00ffULL,
0x0000007a6c48723cULL, 0x080b6e0000041848ULL, 0x000000101f6c7824ULL, 0x020fe200078e0200ULL,
0x0000007a6828723cULL, 0x000b620000041828ULL, 0x000000001e1c783bULL, 0x000e680000000200ULL,
0x000000000368783bULL, 0x0204e20000000200ULL, 0x0000008000000947ULL, 0x000fda0003800000ULL,
0x0000000768687231ULL, 0x088fe400003400ffULL, 0x000000076a6a7231ULL, 0x000fc400003400ffULL,
0x0000000669697231ULL, 0x080fe400003400ffULL, 0x000000066b6b7231ULL, 0x000fe400003400ffULL,
0x000000051c1c7231ULL, 0x082fe400003400ffULL, 0x000000051e1e7231ULL, 0x000fe400003400ffULL,
0x000000041d1d7231ULL, 0x080fe400003400ffULL, 0x000000041f1f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff80b037812ULL, 0x004fe200078ee208ULL,
0x000000006c6c783bULL, 0x000ea80000004200ULL, 0x0000001003037824ULL, 0x000fca00078e0200ULL,
0x000000000370783bULL, 0x000f220000004200ULL, 0x00000018ff797819ULL, 0x004fe2000001146eULL,
0x000001006d7c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff027819ULL, 0x000fe2000001146cULL,
0x0000006c00267306ULL, 0x000fe20000009400ULL, 0x00000018ff087819ULL, 0x000fe2000001146dULL,
0x000100006d887824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001146fULL,
0x000001006f997824ULL, 0x000fe200078e00ffULL, 0x00000018ff227819ULL, 0x010fe20000011470ULL,
0x000001006e927824ULL, 0x000fc400078e00ffULL, 0x0000007900937306ULL, 0x000fe20000209400ULL,
0x00000018ff7a7819ULL, 0x000fe20000011471ULL, 0x0000010070a17824ULL, 0x000fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe20000011472ULL, 0x0000010071a77824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe20000011473ULL, 0x0000010072b57824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe20000011488ULL, 0x0000007900987306ULL, 0x000fe20000205400ULL,
0x00000018ff997819ULL, 0x000fe20000011499ULL, 0x0000010073ba7824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fc40000011492ULL, 0x00000018ffa17819ULL, 0x000fe400000114a1ULL,
0x00000018ffaa7819ULL, 0x000fe200000114a7ULL, 0x00000079009a7306ULL, 0x0005e2000020d400ULL,
0x00000018ffb57819ULL, 0x000fe400000114b5ULL, 0x00000018ffba7819ULL, 0x000fca00000114baULL,
0x00000002007e7306ULL, 0x000fe20000209400ULL, 0x000001006c797824ULL, 0x004fca00078e00ffULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000000200817306ULL, 0x000ff00000205400ULL,
0x0000000200807306ULL, 0x000ff0000020d400ULL, 0x00000008008c7306ULL, 0x000ff00000209400ULL,
0x00000008008d7306ULL, 0x000ff00000205400ULL, 0x00000008008e7306ULL, 0x000ff0000020d400ULL,
0x0000002200a67306ULL, 0x000ff00000209400ULL, 0x0000002200a97306ULL, 0x000ff00000205400ULL,
0x00000022000c7306ULL, 0x000ff0000020d400ULL, 0x0000007a00b17306ULL, 0x000ff00000209400ULL,
0x0000007a00b27306ULL, 0x000ff00000205400ULL, 0x0000007a000a7306ULL, 0x000ff0000020d400ULL,
0x0000007b00257306ULL, 0x000ff00000209400ULL, 0x0000007b00767306ULL, 0x000ff00000205400ULL,
0x0000007b00087306ULL, 0x000ff0000020d400ULL, 0x0000008500777306ULL, 0x000ff00000209400ULL,
0x0000008500227306ULL, 0x000ff00000205400ULL, 0x0000008500027306ULL, 0x0005f0000020d400ULL,
0x00000079007a7306ULL, 0x000fe20000209400ULL, 0x00000018ff857819ULL, 0x004fce000001147cULL,
0x00000079007b7306ULL, 0x000eb00000205400ULL, 0x0000006c00277306ULL, 0x000f300000005400ULL,
0x0000008500867306ULL, 0x000fe20000209400ULL, 0x0000007b7a00720bULL, 0x004fce0003f1d000ULL,
0x0000008500877306ULL, 0x000ea20000205400ULL, 0x000000272600720bULL, 0x010fce0003f9d000ULL,
0x00000079007d7306ULL, 0x000f30000020d400ULL, 0x0000006d00827306ULL, 0x000fe20000009400ULL,
0x000000878600720bULL, 0x004fce0003f7d000ULL, 0x0000006d00837306ULL, 0x000ea20000005400ULL,
0x000000017d7d0812ULL, 0x010fe400078efcffULL, 0x000000817e00720bULL, 0x000fca0003f1d000ULL,
0x0000006c00787306ULL, 0x0008f0000000d400ULL, 0x0000008500897306ULL, 0x000e62000020d400ULL,
0x000100006c6c7824ULL, 0x010fe200078e00ffULL, 0x000000838200720bULL, 0x004fc40003fdd000ULL,
0x0000000180800812ULL, 0x000fe400078efcffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000008800797306ULL, 0x000fe20000209400ULL, 0x0000000178784812ULL, 0x008fce00078efcffULL,
0x00000088008a7306ULL, 0x000ea20000205400ULL, 0x0000000189893812ULL, 0x002fe400078efcffULL,
0x0000008d8c00720bULL, 0x000fca0003f7d000ULL, 0x0000006d00847306ULL, 0x000e70000000d400ULL,
0x0000007f009d7306ULL, 0x000fe20000209400ULL, 0x0000008a7900720bULL, 0x004fe40003f9d000ULL,
0x000000018e8e3812ULL, 0x000fca00078efcffULL, 0x0000007f00a07306ULL, 0x000fe20000205400ULL,
0x0000000184846812ULL, 0x002fce00078efcffULL, 0x0000007f00a27306ULL, 0x000ff0000020d400ULL,
0x0000006c007c7306ULL, 0x000ff00000209400ULL, 0x0000006c007f7306ULL, 0x000e700000205400ULL,
0x0000006c006d7306ULL, 0x000eb0000020d400ULL, 0x00000099006c7306ULL, 0x000fe20000209400ULL,
0x0000007f7c00720bULL, 0x002fce0003fbd000ULL, 0x00000099009b7306ULL, 0x000e6c0000205400ULL,
0x000000016d6d5812ULL, 0x004fe400078efcffULL, 0x0000009200857306ULL, 0x000ff00000209400ULL,
0x0000009200947306ULL, 0x000ea20000205400ULL, 0x0000009b6c00720bULL, 0x002fce0003f1d000ULL,
0x00000088008b7306ULL, 0x000e70000020d400ULL, 0x0000006f00957306ULL, 0x000fe20000009400ULL,
0x000000948500720bULL, 0x004fce0003fdd000ULL, 0x0000006f009c7306ULL, 0x000ea20000005400ULL,
0x000000018b8b4812ULL, 0x002fce00078efcffULL, 0x000000a100887306ULL, 0x000ff00000209400ULL,
0x000000a100a37306ULL, 0x000e620000205400ULL, 0x0000009c9500720bULL, 0x004fce0003f9d000ULL,
0x00000070009f7306ULL, 0x000ff00000009400ULL, 0x0000007000a47306ULL, 0x000fe20000005400ULL,
0x000000a38800720bULL, 0x002fce0003f7d000ULL, 0x0000007000207306ULL, 0x0003f0000000d400ULL,
0x00000099009e7306ULL, 0x000ea2000020d400ULL, 0x0001000070707824ULL, 0x002fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000007100a87306ULL, 0x000ff00000009400ULL,
0x0000007100ab7306ULL, 0x000e620000005400ULL, 0x000000019e9e0812ULL, 0x004fce00078efcffULL,
0x0000009200967306ULL, 0x000eb0000020d400ULL, 0x0000006f00977306ULL, 0x000ee2000000d400ULL,
0x000000aba800720bULL, 0x002fce0003f1d000ULL, 0x000000a100a57306ULL, 0x000e62000020d400ULL,
0x0000000196966812ULL, 0x004fe400078efcffULL, 0x000000a49f00720bULL, 0x000fca0003fdd000ULL,
0x0000006e008f7306ULL, 0x000fe20000009400ULL, 0x0000000197974812ULL, 0x008fc800078efcffULL,
0x000000979e97723eULL, 0x000fc600000010ffULL, 0x0000006e00907306ULL, 0x000ea20000005400ULL,
0x00000001a5a53812ULL, 0x002fe400078efcffULL, 0x000000a9a600720bULL, 0x000fe40003f7d000ULL,
0x0000000120206812ULL, 0x000fc600078efcffULL, 0x0000006e00917306ULL, 0x0002f0000000d400ULL,
0x0000007000927306ULL, 0x000fe20000209400ULL, 0x000100006e6e7824ULL, 0x002fe200078e00ffULL,
0x000000908f00720bULL, 0x004fc40003fbd000ULL, 0x000000010c0c3812ULL, 0x000fe400078efcffULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x0000007000997306ULL, 0x000e620000205400ULL,
0x000000a09d00720bULL, 0x000fcc0003f7d000ULL, 0x0000000191915812ULL, 0x008fe200078efcffULL,
0x00000071000b7306ULL, 0x0004e6000000d400ULL, 0x000000919696723eULL, 0x000fc600000010ffULL,
0x00000001a2a23812ULL, 0x000fe400078efcffULL, 0x0000006e00267306ULL, 0x000fe20000209400ULL,
0x0001000071717824ULL, 0x004fe200078e00ffULL, 0x000000999200720bULL, 0x002fe20003f9d000ULL,
0x00000096685c723cULL, 0x000b66000004185cULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x0000006e00277306ULL, 0x000e620000205400ULL, 0x000000010b0b0812ULL, 0x008fc400078efcffULL,
0x000000961c3c723cULL, 0x000b6a000004183cULL, 0x0000007100a17306ULL, 0x000ff00000209400ULL,
0x0000007100b07306ULL, 0x000ea20000205400ULL, 0x000000272600720bULL, 0x002fc40003f1d000ULL,
0x000000787d26723eULL, 0x000fe400000010ffULL, 0x000000848927723eULL, 0x000fc600000010ffULL,
0x0000007000a77306ULL, 0x0002e8000020d400ULL, 0x000000266864723cULL, 0x000b680000041864ULL,
0x000000aa00ac7306ULL, 0x000fe20000209400ULL, 0x000100006f707824ULL, 0x002fe200078e00ffULL,
0x000000b0a100720bULL, 0x004fc40003fdd000ULL, 0x000000261c44723cULL, 0x000b640000041844ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x000000aa00ad7306ULL, 0x000e620000205400ULL,
0x00000001a7a74812ULL, 0x008fe400078efcffULL, 0x000000989300720bULL, 0x000fca0003f9d000ULL,
0x0000006e006f7306ULL, 0x0004f0000020d400ULL, 0x0000007100af7306ULL, 0x000f22000020d400ULL,
0x000000adac00720bULL, 0x002fe20003fbd000ULL, 0x00010000736e7824ULL, 0x004fe200078e00ffULL,
0x000000019a9a4812ULL, 0x000fc800078efcffULL, 0x00000018ff787819ULL, 0x000fe2000001146eULL,
0x00000070006c7306ULL, 0x000fe20000209400ULL, 0x000000016f6f0812ULL, 0x008fe400078efcffULL,
0x000000b2b100720bULL, 0x000fe40003f1d000ULL, 0x0000006f9a9a723eULL, 0x000fe400000010ffULL,
0x00000020a56e723eULL, 0x000fe200000010ffULL, 0x0000007000717306ULL, 0x000e620000205400ULL,
0x00000001afaf6812ULL, 0x010fce00078efcffULL, 0x000000aa00ae7306ULL, 0x000ea2000020d400ULL,
0x000000010a0a0812ULL, 0x000fe400078efcffULL, 0x000000762500720bULL, 0x000fca0003f1d000ULL,
0x0000007200b37306ULL, 0x000fe20000009400ULL, 0x000000716c00720bULL, 0x002fe40003fdd000ULL,
0x0000006d806c723eULL, 0x000fe400000010ffULL, 0x0000008b8e6d723eULL, 0x000fc600000010ffULL,
0x0000007200b47306ULL, 0x000e620000005400ULL, 0x00000001aeae5812ULL, 0x004fe400078efcffULL,
0x0000000108080812ULL, 0x000fe200078efcffULL, 0x0000006c6860723cULL, 0x000b620000041860ULL,
0x0000000bae6f723eULL, 0x000fc600000010ffULL, 0x000000b500aa7306ULL, 0x000fe80000209400ULL,
0x0000006e6854723cULL, 0x000b680000041854ULL, 0x000000b500b77306ULL, 0x000ea20000205400ULL,
0x000000b4b300720bULL, 0x002fc60003fbd000ULL, 0x0000006c1c40723cULL, 0x040b680000041840ULL,
0x000000ba00bb7306ULL, 0x000fe80000209400ULL, 0x0000006e1c34723cULL, 0x000b680000041834ULL,
0x000000ba00bc7306ULL, 0x000e620000205400ULL, 0x000000b7aa00720bULL, 0x004fce0003f9d000ULL,
0x0000007200037306ULL, 0x0004f0000000d400ULL, 0x0000007300b87306ULL, 0x000fe20000009400ULL,
0x0001000072727824ULL, 0x004fe200078e00ffULL, 0x000000bcbb00720bULL, 0x002fc80003f7d000ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000007300b97306ULL, 0x000fe20000005400ULL,
0x0000000103035812ULL, 0x008fce00078efcffULL, 0x0000007300007306ULL, 0x000ff0000000d400ULL,
0x000000b500b67306ULL, 0x000e70000020d400ULL, 0x000000ba007b7306ULL, 0x000eb0000020d400ULL,
0x00000070009b7306ULL, 0x000ee2000020d400ULL, 0x00000001b6b64812ULL, 0x002fc400078efcffULL,
0x000000227700720bULL, 0x000fe40003f9d000ULL, 0x00000003b6b6723eULL, 0x000fc600000010ffULL,
0x0000007200737306ULL, 0x000fe20000209400ULL, 0x000000017b7b3812ULL, 0x004fce00078efcffULL,
0x0000007200707306ULL, 0x000e620000205400ULL, 0x000000019b9b6812ULL, 0x008fe400078efcffULL,
0x000000b9b800720bULL, 0x000fe40003fdd000ULL, 0x0000000102024812ULL, 0x000fe400078efcffULL,
0x0000009ba29b723eULL, 0x000fe200000010ffULL, 0x0000007800717306ULL, 0x000fec0000209400ULL,
0x0000009a6858723cULL, 0x000b640000041858ULL, 0x00000078007a7306ULL, 0x000ea20000205400ULL,
0x000000707300720bULL, 0x002fc40003fbd000ULL, 0x0000000100006812ULL, 0x000fe400078efcffULL,
0x000000a70c70723eULL, 0x000fe200000010ffULL, 0x0000009a1c38723cULL, 0x000b620000041838ULL,
0x000000007bb7723eULL, 0x000fe200000010ffULL, 0x0000007200257306ULL, 0x000e6c000020d400ULL,
0x000000b6684c723cULL, 0x000b64000004184cULL, 0x00000078000b7306ULL, 0x000ee2000020d400ULL,
0x0000007a7100720bULL, 0x004fc40003f7d000ULL, 0x000000af0a71723eULL, 0x000fc600000010ffULL,
0x000000b61c2c723cULL, 0x000b62000004182cULL, 0x0000000125255812ULL, 0x002fc800078efcffULL,
0x00000025080a723eULL, 0x000fc600000010ffULL, 0x000000706850723cULL, 0x000b620000041850ULL,
0x000000010b0b3812ULL, 0x008fc800078efcffULL, 0x0000000b020b723eULL, 0x000fc600000010ffULL,
0x000000701c30723cULL, 0x000b700000041830ULL, 0x0000000a6848723cULL, 0x080b700000041848ULL,
0x0000000a1c28723cULL, 0x000b620000041828ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x000000000d027f8cULL, 0x0002a2000c80043fULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0001a6a010087811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000008ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x004fe200078e0003ULL,
0x0000001000002944ULL, 0x000fe20003c00000ULL, 0xffff160000007947ULL, 0x000fea000383ffffULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x000000ffff237224ULL, 0x020fe400078e002bULL,
0x000000ffff687224ULL, 0x000fe400078e002aULL, 0x000000ffff217224ULL, 0x002fe400078e002fULL,
0x000000ffff207224ULL, 0x000fc400078e002eULL, 0x000000ffff1f7224ULL, 0x000fe400078e0033ULL,
0x000000ffff147224ULL, 0x000fe400078e0032ULL, 0x000005b000008947ULL, 0x000fea0003800000ULL,
0x0180000024007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x000106d000047802ULL, 0x000fc40000000f00ULL,
0x0000d83000007944ULL, 0x00cfea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002400037308ULL, 0x004e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000024ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006d00ff037624ULL, 0x000fe400078e00ffULL,
0x00006c00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000f28000c1e9900ULL,
0x0000000000087919ULL, 0x008ee80000000000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x0000001808057811ULL, 0x048fe400078ff0ffULL, 0x0000000808097811ULL, 0x000fc400078ff0ffULL,
0x00000002ff077819ULL, 0x002fe40000011604ULL, 0x00000010080b7811ULL, 0x000fe200078ff0ffULL,
0x0000000003067220ULL, 0x014fca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0506057589ULL, 0x000ea800000e0000ULL, 0x00001f0906047589ULL, 0x000ee800000e0000ULL,
0x00001f0b06027589ULL, 0x000f2200000e0000ULL, 0x0000006400647220ULL, 0x002fc40000410000ULL,
0x0000006500657220ULL, 0x040fe40000410000ULL, 0x0000006000607220ULL, 0x040fe40000410000ULL,
0x0000006100617220ULL, 0x040fe40000410000ULL, 0x0000005c005c7220ULL, 0x040fe40000410000ULL,
0x0000005d005d7220ULL, 0x040fe40000410000ULL, 0x0000005800587220ULL, 0x000fc40000410000ULL,
0x0000005900597220ULL, 0x040fe40000410000ULL, 0x0000005400547220ULL, 0x040fe40000410000ULL,
0x0000005500557220ULL, 0x040fe40000410000ULL, 0x0000005000507220ULL, 0x040fe40000410000ULL,
0x0000005100517220ULL, 0x040fe40000410000ULL, 0x0000004c004c7220ULL, 0x000fc40000410000ULL,
0x0000004d004d7220ULL, 0x040fe40000410000ULL, 0x0000004800487220ULL, 0x040fe40000410000ULL,
0x0000004900497220ULL, 0x000fe40000410000ULL, 0x0000004605467220ULL, 0x044fe40000410000ULL,
0x0000004705477220ULL, 0x040fe40000410000ULL, 0x0000004205427220ULL, 0x000fc40000410000ULL,
0x0000004305437220ULL, 0x040fe40000410000ULL, 0x0000003e053e7220ULL, 0x040fe40000410000ULL,
0x0000003f053f7220ULL, 0x040fe40000410000ULL, 0x0000003a053a7220ULL, 0x040fe40000410000ULL,
0x0000003b053b7220ULL, 0x040fe40000410000ULL, 0x0000003605367220ULL, 0x000fc40000410000ULL,
0x0000003705377220ULL, 0x040fe40000410000ULL, 0x0000001405147220ULL, 0x040fe40000410000ULL,
0x0000001f051f7220ULL, 0x040fe40000410000ULL, 0x0000002005207220ULL, 0x040fe40000410000ULL,
0x0000002105217220ULL, 0x040fe40000410000ULL, 0x0000006805687220ULL, 0x000fc40000410000ULL,
0x0000002305237220ULL, 0x000fe40000410000ULL, 0x0000000466667220ULL, 0x088fe40000410000ULL,
0x0000000467677220ULL, 0x080fe40000410000ULL, 0x0000000462627220ULL, 0x080fe40000410000ULL,
0x0000000463637220ULL, 0x080fe40000410000ULL, 0x000000045e5e7220ULL, 0x000fc40000410000ULL,
0x000000045f5f7220ULL, 0x080fe40000410000ULL, 0x000000045a5a7220ULL, 0x080fe40000410000ULL,
0x000000045b5b7220ULL, 0x080fe40000410000ULL, 0x0000000456567220ULL, 0x080fe40000410000ULL,
0x0000000457577220ULL, 0x080fe40000410000ULL, 0x0000000452527220ULL, 0x000fc40000410000ULL,
0x0000000453537220ULL, 0x080fe40000410000ULL, 0x000000044e4e7220ULL, 0x080fe40000410000ULL,
0x000000044f4f7220ULL, 0x080fe40000410000ULL, 0x000000044a4a7220ULL, 0x080fe40000410000ULL,
0x000000044b4b7220ULL, 0x000fe40000410000ULL, 0x0000000244447220ULL, 0x010fc40000410000ULL,
0x0000000245457220ULL, 0x080fe40000410000ULL, 0x0000000240407220ULL, 0x080fe40000410000ULL,
0x0000000241417220ULL, 0x080fe40000410000ULL, 0x000000023c3c7220ULL, 0x080fe40000410000ULL,
0x000000023d3d7220ULL, 0x080fe40000410000ULL, 0x0000000238387220ULL, 0x000fc40000410000ULL,
0x0000000239397220ULL, 0x080fe40000410000ULL, 0x0000000234347220ULL, 0x080fe40000410000ULL,
0x0000000235357220ULL, 0x080fe40000410000ULL, 0x0000000230307220ULL, 0x080fe40000410000ULL,
0x0000000231317220ULL, 0x080fe40000410000ULL, 0x000000022c2c7220ULL, 0x000fc40000410000ULL,
0x000000022d2d7220ULL, 0x080fe40000410000ULL, 0x0000000228287220ULL, 0x080fe40000410000ULL,
0x0000000229297220ULL, 0x000fc40000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000666766723eULL, 0x000fe400000010ffULL, 0x000000626333723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000005e5f5e723eULL, 0x000fc400000010ffULL,
0x0000005a5b2f723eULL, 0x000fe400000010ffULL, 0x000000565756723eULL, 0x000fe400000010ffULL,
0x00000052532b723eULL, 0x000fe400000010ffULL, 0x0000004e4f4e723eULL, 0x000fe400000010ffULL,
0x0000004a4b27723eULL, 0x000fe400000010ffULL, 0x0000541066327816ULL, 0x000fc40000000033ULL,
0x0000000800037811ULL, 0x046fe200078ff0ffULL, 0x0000000175757824ULL, 0x100fe200078e0200ULL,
0x0000000200027812ULL, 0x040fe400078ec0ffULL, 0x00000002ff077819ULL, 0x000fe20000011600ULL,
0x00000008030d7824ULL, 0x000fe200078e00ffULL, 0x0000001000097811ULL, 0x040fe400078ff0ffULL,
0x00000018000b7811ULL, 0x000fe200078ff0ffULL, 0x00000008070c7824ULL, 0x000fe200078e00ffULL,
0x0000000302047211ULL, 0x040fe200078ff8ffULL, 0x0000000809107824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fc400078ff8ffULL, 0x0000000b02067211ULL, 0x040fe200078ff8ffULL,
0x000000080b0b7824ULL, 0x000fe200078e00ffULL, 0x0000000902057211ULL, 0x000fe200078ff8ffULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0x0000000203027810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80d0e7812ULL, 0x000fe200078ee204ULL, 0x0000000807047824ULL, 0x000fe200078e00ffULL,
0xfffffff80b127812ULL, 0x000fe400078ee206ULL, 0xfffffff809087812ULL, 0x008fe200078ee202ULL,
0x0000200011027824ULL, 0x000fe200078e00ffULL, 0x0000000403067810ULL, 0x000fc40007ffe0ffULL,
0x0000000603077810ULL, 0x000fe20007ffe0ffULL, 0x0000001075757824ULL, 0x100fe200078e0202ULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x0000000800057824ULL, 0x000fe200078e00ffULL,
0xfffffff804047812ULL, 0x000fe200078ee203ULL, 0x0000100013037824ULL, 0x000fe200078e0202ULL,
0xfffffff8090a7812ULL, 0x000fe400078ee206ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x000000100e0f7824ULL, 0x100fe200078e0203ULL, 0x0000000805067812ULL, 0x000fe200078ec0ffULL,
0x0000001004057824ULL, 0x100fe200078e0203ULL, 0x000000606104723eULL, 0x000fe200000010ffULL,
0x0000001010157824ULL, 0x000fe200078e0203ULL, 0x0000763266337816ULL, 0x000fe20000000033ULL,
0x0000001012177824ULL, 0x100fe200078e0203ULL, 0x000000444544723eULL, 0x000fe200000010ffULL,
0x0000001008097824ULL, 0x100fe200078e0203ULL, 0x000000484908723eULL, 0x000fe200000010ffULL,
0x000000100a0b7824ULL, 0x100fe200078e0203ULL, 0x000000404122723eULL, 0x000fe200000010ffULL,
0x000000100c0d7824ULL, 0x000fe200078e0203ULL, 0x000000646503723eULL, 0x000fe200000010ffULL,
0x0000000105077824ULL, 0x000fe200078e0206ULL, 0x000000545505723eULL, 0x000fe200000010ffULL,
0x00000001060f7824ULL, 0x040fe200078e020fULL, 0x00005410031c7816ULL, 0x140fe20000000004ULL,
0x0000000106157824ULL, 0x040fe200078e0215ULL, 0x00007632031d7816ULL, 0x000fe20000000004ULL,
0x0000000106177824ULL, 0x040fe200078e0217ULL, 0x0000005c5d03723eULL, 0x000fe200000010ffULL,
0x0000000106097824ULL, 0x040fe200078e0209ULL, 0x000000585904723eULL, 0x000fe200000010ffULL,
0x00000001060b7824ULL, 0x040fe200078e020bULL, 0x0000001c07007388ULL, 0x0003e20000000a00ULL,
0x00000001060d7824ULL, 0x000fe200078e020dULL, 0x000000505106723eULL, 0x000fc400000010ffULL,
0x000054105e2e7816ULL, 0x140fe4000000002fULL, 0x0000003c3d3c723eULL, 0x000fe400000010ffULL,
0x00000038391e723eULL, 0x000fe400000010ffULL, 0x000076325e2f7816ULL, 0x000fe4000000002fULL,
0x0000004c4d07723eULL, 0x002fe400000010ffULL, 0x00005410031c7816ULL, 0x000fc40000000004ULL,
0x00007632031d7816ULL, 0x000fe40000000004ULL, 0x0000541005047816ULL, 0x140fe40000000006ULL,
0x0000763205057816ULL, 0x000fe20000000006ULL, 0x0000001c09007388ULL, 0x000fe20000000a00ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x000000040b007388ULL, 0x000fe20000000a00ULL, 0x00005410562a7816ULL, 0x000fc4000000002bULL,
0x00007632562b7816ULL, 0x000fe2000000002bULL, 0x000000060d007388ULL, 0x0003e20000000a00ULL,
0x000054104e267816ULL, 0x140fe40000000027ULL, 0x000076324e277816ULL, 0x000fe20000000027ULL,
0x000000320f007388ULL, 0x0005e20000000a00ULL, 0x000054103c0e7816ULL, 0x000fe4000000001eULL,
0x000000343534723eULL, 0x000fe200000010ffULL, 0x0004002e09007388ULL, 0x000fe20000000a00ULL,
0x00000030311a723eULL, 0x000fc400000010ffULL, 0x0000002c2d2c723eULL, 0x000fe200000010ffULL,
0x0004002a0b007388ULL, 0x000fe20000000a00ULL, 0x0000541044067816ULL, 0x142fe40000000022ULL,
0x0000763244077816ULL, 0x000fe20000000022ULL, 0x000400260d007388ULL, 0x000fe20000000a00ULL,
0x000076323c0f7816ULL, 0x004fe4000000001eULL, 0x000000282916723eULL, 0x000fe200000010ffULL,
0x0000000615007388ULL, 0x0003e20000000a00ULL, 0x000000464703723eULL, 0x000fc400000010ffULL,
0x000000424304723eULL, 0x000fe200000010ffULL, 0x0008000e09007388ULL, 0x0005e20000000a00ULL,
0x0000003e3f05723eULL, 0x000fe400000010ffULL, 0x0000003a3b06723eULL, 0x002fe400000010ffULL,
0x00005410340e7816ULL, 0x144fe4000000001aULL, 0x00007632340f7816ULL, 0x000fca000000001aULL,
0x0008000e0b007388ULL, 0x0003e40000000a00ULL, 0x000054102c0e7816ULL, 0x142fe40000000016ULL,
0x000076322c0f7816ULL, 0x000fca0000000016ULL, 0x0008000e0d007388ULL, 0x0003e40000000a00ULL,
0x00005410030e7816ULL, 0x142fe40000000004ULL, 0x00007632030f7816ULL, 0x000fe40000000004ULL,
0x000000363703723eULL, 0x000fe400000010ffULL, 0x000000141f04723eULL, 0x000fe200000010ffULL,
0x0000000e17007388ULL, 0x0003e60000000a00ULL, 0x0000541003087816ULL, 0x000fc40000000004ULL,
0x00005410050e7816ULL, 0x142fe40000000006ULL, 0x00007632050f7816ULL, 0x000fe40000000006ULL,
0x000000202105723eULL, 0x000fe400000010ffULL, 0x000000682306723eULL, 0x000fe200000010ffULL,
0x000c000e09007388ULL, 0x0003e40000000a00ULL, 0x0000763203097816ULL, 0x002fe40000000004ULL,
0x00005410050e7816ULL, 0x140fe20000000006ULL, 0x000000ff00037306ULL, 0x000fe20000205400ULL,
0x00007632050f7816ULL, 0x000fe20000000006ULL, 0x000c00080b007388ULL, 0x000fe80000000a00ULL,
0x000c000e0d007388ULL, 0x000fe40000000a00ULL, 0x000000ff00047306ULL, 0x000e640000209400ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000075147984ULL, 0x000ea20000000c00ULL,
0x000000ff00057306ULL, 0x000ee6000020d400ULL, 0x0004000075087984ULL, 0x000f280000000c00ULL,
0x0008000075247984ULL, 0x000f220000000c00ULL, 0x000000030400720bULL, 0x002fc60003f1d000ULL,
0x000c0000750c7984ULL, 0x000e680000000c00ULL, 0x00100000751c7984ULL, 0x000e680000000c00ULL,
0x0014000075207984ULL, 0x000e640000000c00ULL, 0x0000000105050812ULL, 0x008fc400078efcffULL,
0x0018000075287984ULL, 0x000ee20000000c00ULL, 0x000000ff1300720cULL, 0x000fe40003f05270ULL,
0x000000050505723eULL, 0x000fe200000010ffULL, 0x001c0000752c7984ULL, 0x000ee80000000c00ULL,
0x3f803f8005177831ULL, 0x044fe40000200017ULL, 0x3f803f8005167831ULL, 0x000fc40000200016ULL,
0x3f803f8005157831ULL, 0x040fe40000200015ULL, 0x3f803f8005147831ULL, 0x040fe40000200014ULL,
0x3f803f80050b7831ULL, 0x050fe4000020000bULL, 0x3f803f80050a7831ULL, 0x040fe4000020000aULL,
0x3f803f8005097831ULL, 0x040fe40000200009ULL, 0x3f803f8005087831ULL, 0x000fc40000200008ULL,
0x3f803f8005277831ULL, 0x040fe40000200027ULL, 0x3f803f8005267831ULL, 0x040fe40000200026ULL,
0x3f803f8005257831ULL, 0x040fe40000200025ULL, 0x3f803f8005247831ULL, 0x040fe40000200024ULL,
0x3f803f80050f7831ULL, 0x042fe4000020000fULL, 0x3f803f80050e7831ULL, 0x000fc4000020000eULL,
0x3f803f80050d7831ULL, 0x040fe4000020000dULL, 0x3f803f80050c7831ULL, 0x000fe4000020000cULL,
0x3f803f8017177831ULL, 0x000fe4000020001fULL, 0x3f803f8016167831ULL, 0x000fe4000020001eULL,
0x3f803f8015157831ULL, 0x000fe4000020001dULL, 0x3f803f8014147831ULL, 0x000fc4000020001cULL,
0x3f803f800b0b7831ULL, 0x000fe40000200023ULL, 0x3f803f800a0a7831ULL, 0x000fe20000200022ULL,
0x0000001475007388ULL, 0x000fe20000000c00ULL, 0x3f803f8009097831ULL, 0x000fe40000200021ULL,
0x3f803f8008087831ULL, 0x000fe40000200020ULL, 0x3f803f8027277831ULL, 0x008fe4000020002bULL,
0x3f803f8026267831ULL, 0x000fe2000020002aULL, 0x0004000875007388ULL, 0x000fe20000000c00ULL,
0x3f803f8025257831ULL, 0x000fc40000200029ULL, 0x3f803f8024247831ULL, 0x000fe40000200028ULL,
0x3f803f800f0f7831ULL, 0x000fe4000020002fULL, 0x3f803f800e0e7831ULL, 0x000fe2000020002eULL,
0x0008002475007388ULL, 0x000fe20000000c00ULL, 0x3f803f800d0d7831ULL, 0x000fe4000020002dULL,
0x3f803f800c0c7831ULL, 0x000fca000020002cULL, 0x000c000c75007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fc80000011600ULL, 0x000000180900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00005a00ff0f7a12ULL, 0x000fe400078e33ffULL,
0x00000007000e7812ULL, 0x000fc800078ec0ffULL, 0x0000000600067308ULL, 0x002e640000001000ULL,
0x0ffffffe06087810ULL, 0x002fcc0007ffe0ffULL, 0x0000000800057305ULL, 0x000e64000021f000ULL,
0x000000ffff037224ULL, 0x002fc800078e0a05ULL, 0x00005a0003037a24ULL, 0x000fc800078e02ffULL,
0x0000000305107227ULL, 0x000fc800078e0004ULL, 0x0000000119037824ULL, 0x000fc800078e0209ULL,
0x0000000310077227ULL, 0x000fc800078e00ffULL, 0x000000ffff047224ULL, 0x000fc800078e0a07ULL,
0x00005a0004057a24ULL, 0x000fe400078e0203ULL, 0x0000000109047824ULL, 0x000fc600078e0200ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x0000000704057812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x0ffffff805057812ULL, 0x000fca00078ef800ULL, 0x0000001005067824ULL, 0x000fe400078e0202ULL,
0x0000000107071810ULL, 0x000fc60007ffe0ffULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x000000070f047207ULL, 0x000fe40004000000ULL, 0x0000002000077810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe200078e021bULL,
0x00000003ff067819ULL, 0x002fe20000011607ULL, 0x00005a000c037a24ULL, 0x000fc800078e0203ULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x0000000374037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440cULL, 0x0000000811037824ULL, 0x000fe200078e020eULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x00000040000d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107067824ULL, 0x000fe400078e0206ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef807ULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f047207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc6000001160dULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe400078e021bULL, 0x00005a000c037a24ULL, 0x000fe200078e0203ULL,
0x00000007070c7812ULL, 0x000fc600078ec0ffULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x0000000374037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440eULL,
0x0000000811037824ULL, 0x000fe200078e020cULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x0000006000077810ULL, 0x000fe20007ffe0ffULL, 0x000000010d067824ULL, 0x000fe400078e0206ULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef80dULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc60000011607ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x000000070d0c7812ULL, 0x000fc600078ec0ffULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x0000000374037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440eULL, 0x0000000811037824ULL, 0x000fe200078e020cULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x00000080000d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107067824ULL, 0x000fe400078e0206ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef807ULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f047207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc6000001160dULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe400078e021bULL, 0x00005a000c037a24ULL, 0x000fe200078e0203ULL,
0x00000007070c7812ULL, 0x000fc600078ec0ffULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x0000000374037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440eULL,
0x0000000811037824ULL, 0x000fe200078e020cULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x000000a000077810ULL, 0x000fe20007ffe0ffULL, 0x000000010d067824ULL, 0x000fe400078e0206ULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef80dULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc60000011607ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x000000070d0c7812ULL, 0x000fc600078ec0ffULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x0000000374037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440eULL, 0x0000000811037824ULL, 0x000fe200078e020cULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x000000c0000d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107067824ULL, 0x000fe400078e0206ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef807ULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f047207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc6000001160dULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe400078e021bULL, 0x00005a000c037a24ULL, 0x000fe200078e0203ULL,
0x00000007070c7812ULL, 0x000fc600078ec0ffULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x0000000374037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440eULL,
0x0000000811037824ULL, 0x000fe200078e020cULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x000000e000077810ULL, 0x000fe20007ffe0ffULL, 0x000000010d067824ULL, 0x040fe200078e0206ULL,
0x000000070d007812ULL, 0x000fe200078ec0ffULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef80dULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f047207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc60000011607ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe400078e021bULL, 0x00005a000c037a24ULL, 0x000fe400078e0203ULL,
0x0000000119197824ULL, 0x000fe400078e0206ULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x0000000374037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440cULL,
0x0000000811037824ULL, 0x000fe200078e0200ULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000001910007227ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x002fe400078e0a00ULL, 0x0000000107067824ULL, 0x000fe400078e0206ULL,
0x00005a0004037a24ULL, 0x000fc600078e0219ULL, 0x0000000706067812ULL, 0x000fe400078ec0ffULL,
0x00005a0003007a0cULL, 0x000fda0003f26070ULL, 0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL,
0x0000000100001810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fe40003f46070ULL,
0xfffffff806037812ULL, 0x000fca00078ef807ULL, 0x0000001003047824ULL, 0x000fca00078e0202ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000100002810ULL, 0x000fc80007ffe0ffULL,
0x000000000f007207ULL, 0x000fca0004000000ULL, 0x000000ffff027224ULL, 0x000fe400078e0a00ULL,
0x0000590000007a24ULL, 0x000fe400078e021bULL, 0x00005a0002197a24ULL, 0x000fc800078e0219ULL,
0x00005a0000197a24ULL, 0x000fe200078e0219ULL, 0x0000000707007812ULL, 0x000fc800078ec0ffULL,
0x0000001974197210ULL, 0x000fe20007f1e0ffULL, 0x0000000811117824ULL, 0x000fc800078e0200ULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005e0019027a11ULL, 0x000fc800078040ffULL,
0x00005f0019037a11ULL, 0x000fca00000f4406ULL, 0x0000001011027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006c00ff067624ULL, 0x000fe400078e00ffULL, 0x00006d00ff077624ULL, 0x002fca00078e00ffULL,
0x0000000606067981ULL, 0x000322000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0800780cULL, 0x000fe20003f04070ULL, 0x0000001fff097424ULL, 0x000fe200078e00ffULL,
0x01a60000ff047f8cULL, 0x000ea2000c80043fULL, 0x00000002110a7824ULL, 0x000fe400078e00ffULL,
0x000000401a077824ULL, 0x002fe200078e00ffULL, 0x0000580009097a10ULL, 0x000fe20007ffe0ffULL,
0x000059000a1b7a24ULL, 0x000fc600078e021bULL, 0x00000005ff097819ULL, 0x000fe20000011609ULL,
0x000068001b087a24ULL, 0x000fe400078e0207ULL, 0x00000c7000000947ULL, 0x000fea0003800000ULL,
0x00000003ff3f7819ULL, 0x000fe40000011617ULL, 0x00000007160a7217ULL, 0x000fe40007800000ULL,
0x000000043f0f7810ULL, 0x040fe40007ffe0ffULL, 0x000000083f117810ULL, 0x040fe20007ffe0ffULL,
0x000000010a147824ULL, 0x000fe200078e0a07ULL, 0x0000000c3f137810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0b7824ULL, 0x000fe200078e0217ULL, 0x000000143f257810ULL, 0x000fe20007ffe0ffULL,
0x000000080f0e7824ULL, 0x040fe200078e00ffULL, 0x000000140f00720cULL, 0x000fe20003fa6070ULL,
0x00000001080a7824ULL, 0x000fe200078e023fULL, 0x000000183f337810ULL, 0x000fe20007ffe0ffULL,
0x00000001110d7824ULL, 0x040fe200078e0217ULL, 0xfffffff80e277812ULL, 0x000fe200078ee20bULL,
0x0000000811107824ULL, 0x000fe200078e00ffULL, 0x0000001c3f357810ULL, 0x040fe20007ffe0ffULL,
0x00000001080c7824ULL, 0x000fe200078e020fULL, 0x000000103f0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff8102b7812ULL, 0x000fc400078ee20dULL,
0x000000141300720cULL, 0x080fe20003f46070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a1c7812ULL, 0x000fe400078ef803ULL, 0x000000203f377810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0a7824ULL, 0x040fe200078e0217ULL, 0x000000700c1e7812ULL, 0x000fe200078ef803ULL,
0x000000080f2f7824ULL, 0x000fe200078e00ffULL, 0x000064001c1c7a10ULL, 0x000fe20007f1e0ffULL,
0x00000001080c7824ULL, 0x000fe200078e0213ULL, 0x000064001e1e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000000108107824ULL, 0x040fe200078e0225ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee20aULL,
0x00000001080a7824ULL, 0x040fe200078e0211ULL, 0x000065000b1d7a10ULL, 0x000fe200007fe4ffULL,
0x0000000108127824ULL, 0x000fe200078e0233ULL, 0x000065000d1f7a10ULL, 0x000fe20000ffe4ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000141100720cULL, 0x000fc40003f26070ULL,
0x000000140f00720cULL, 0x000fe20003f06070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a207812ULL, 0x000fe400078ef803ULL, 0x000020001a187811ULL, 0x000fe200078e70ffULL,
0x00000001130e7824ULL, 0x040fe200078e0217ULL, 0x000000700c227812ULL, 0x000fe200078ef803ULL,
0x00000008132d7824ULL, 0x000fe200078e00ffULL, 0x0000640020207a10ULL, 0x000fe20007f7e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000640022227a10ULL, 0x000fc40007f9e0ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20eULL, 0x00000001080f7824ULL, 0x000fe200078e020fULL,
0x0000007010107812ULL, 0x000fe200078ef803ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000065000b217a10ULL, 0x000fe40001ffe4ffULL, 0x000065000d237a10ULL, 0x000fe200027fe4ffULL,
0x00000001080a7824ULL, 0x000fe200078e0235ULL, 0x0000007012127812ULL, 0x000fe200078ef803ULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x0000640010107a10ULL, 0x000fc40007f9e0ffULL,
0x0000640012127a10ULL, 0x000fe20007fde0ffULL, 0x000000013f0c7824ULL, 0x000fe200078e0217ULL,
0x000000700e0e7812ULL, 0x100fe200078ef803ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000650011117a10ULL, 0x000fe400027fe4ffULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000825317824ULL, 0x040fe200078e00ffULL, 0x000000700a247812ULL, 0x000fe200078ef803ULL,
0x00000001250a7824ULL, 0x100fe200078e0217ULL, 0x000064000e0e7a10ULL, 0x000fe20007f7e0ffULL,
0x000000102b2b7824ULL, 0x100fe200078e0218ULL, 0x000000143f00720cULL, 0x000fe20003f86070ULL,
0x000000102d2d7824ULL, 0x100fe200078e0218ULL, 0x0000650013137a10ULL, 0x000fe200037fe4ffULL,
0x000000102f2f7824ULL, 0x000fe200078e0218ULL, 0x0ffffff80c297812ULL, 0x000fe200078ef817ULL,
0x00000001080c7824ULL, 0x000fe200078e0237ULL, 0x0000640024247a10ULL, 0x000fc40007fde0ffULL,
0x000065000f0f7a10ULL, 0x000fe20001ffe4ffULL, 0x0000001029297824ULL, 0x000fe200078e0218ULL,
0x000000142500720cULL, 0x080fe40003f66070ULL, 0xfffffff831317812ULL, 0x000fe400078ee20aULL,
0x000065000b257a10ULL, 0x000fe200037fe4ffULL, 0x000000800c0a7825ULL, 0x000fe200078e00ffULL,
0x000000243f397810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c297faeULL, 0x0003e2000e101c46ULL, 0x000000283f3b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001031317824ULL, 0x000fe200078e0218ULL, 0x000000700a267812ULL, 0x000fe200078ef803ULL,
0x00000001080c7824ULL, 0x000fe200078e0239ULL, 0x000000143300720cULL, 0x040fe20003f86070ULL,
0x00000001330a7824ULL, 0x040fe200078e0217ULL, 0x0000640026267a10ULL, 0x000fe20007fde0ffULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x0000002c3f3d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108287824ULL, 0x000fc400078e023bULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fc600078ee20aULL, 0x0000001027297824ULL, 0x102fe200078e0218ULL,
0x000065000b277a10ULL, 0x000fe200037fe4ffULL, 0x00000080280a7825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fe400078ef803ULL, 0x000000001e297faeULL, 0x0003e2000e901c46ULL,
0x00000001351d7824ULL, 0x040fe200078e0217ULL, 0x000000700a1c7812ULL, 0x000fe200078ef803ULL,
0x00000008350a7824ULL, 0x040fe200078e00ffULL, 0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL,
0x00000000202b7faeULL, 0x0007e2000c901c46ULL, 0x000000143500720cULL, 0x080fe20003fa6070ULL,
0x0000000837287824ULL, 0x000fe200078e00ffULL, 0x000065000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x00000000222d7faeULL, 0x0005e2000d101c46ULL, 0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL,
0x0000001033337824ULL, 0x100fe200078e0218ULL, 0xfffffff80a357812ULL, 0x000fe200078ee21dULL,
0x00000001080a7824ULL, 0x000fe200078e023dULL, 0x000065000b1d7a10ULL, 0x000fe200037fe4ffULL,
0x00000001371f7824ULL, 0x002fe200078e0217ULL, 0x000000143900720cULL, 0x080fe20003f46070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000303f297810ULL, 0x000fe20007ffe0ffULL,
0x000000000e2f7faeULL, 0x0003e2000c101c46ULL, 0x000000143700720cULL, 0x000fe20003f26070ULL,
0x0000001035357824ULL, 0x100fe200078e0218ULL, 0x000000700a1e7812ULL, 0x000fe200078ef803ULL,
0x00000001390a7824ULL, 0x040fe200078e0217ULL, 0xfffffff828217812ULL, 0x008fe200078ee21fULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0x000064001e1e7a10ULL, 0x000fe20007fde0ffULL,
0x0000000010317faeULL, 0x0007e2000d901c46ULL, 0x000000343f2b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001021217824ULL, 0x000fe200078e0218ULL, 0xfffffff839237812ULL, 0x004fe200078ee20aULL,
0x00000001080a7824ULL, 0x000fe200078e0229ULL, 0x000065000b1f7a10ULL, 0x000fe200037fe4ffULL,
0x0000000012337faeULL, 0x0005e2000e101c46ULL, 0x000000013b0f7824ULL, 0x002fe200078e0217ULL,
0x000000383f2d7810ULL, 0x040fe20007ffe0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000000024357faeULL, 0x0003e2000e901c46ULL, 0x0000003c3f2f7810ULL, 0x000fc40007ffe0ffULL,
0x0000001023237824ULL, 0x000fe200078e0218ULL, 0x000000700a0e7812ULL, 0x000fe200078ef803ULL,
0x0000000108107824ULL, 0x008fe200078e022bULL, 0x0000000026217faeULL, 0x0007e2000c901c46ULL,
0x000000013d0a7824ULL, 0x000fe200078e0217ULL, 0x000064000e0e7a10ULL, 0x000fe20007fde0ffULL,
0x000000083b127824ULL, 0x044fe200078e00ffULL, 0x000000000c237faeULL, 0x0005e2000d101c46ULL,
0x000000143b00720cULL, 0x080fe20003fa6070ULL, 0x000000082d257824ULL, 0x002fe200078e00ffULL,
0x000000142b00720cULL, 0x000fc40003f46070ULL, 0xfffffff812137812ULL, 0x000fe200078ee20fULL,
0x0000000829127824ULL, 0x000fe200078e00ffULL, 0x000065000b0f7a10ULL, 0x000fe200037fe4ffULL,
0x000000083d217824ULL, 0x048fe200078e00ffULL, 0x000000143d00720cULL, 0x080fe20003f86070ULL,
0x00000001290b7824ULL, 0x040fe200078e0217ULL, 0x000000142900720cULL, 0x080fe20003f66070ULL,
0x00000080100c7825ULL, 0x004fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe400078ee20aULL,
0xfffffff812237812ULL, 0x000fe200078ee20bULL, 0x000000012b127824ULL, 0x000fe200078e0217ULL,
0x000000700c107812ULL, 0x000fe200078ef803ULL, 0x00000001080c7824ULL, 0x000fe200078e022dULL,
0x000000142d00720cULL, 0x080fe20003f26070ULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x0000640010107a10ULL, 0x000fe20007fde0ffULL, 0x000000800c0a7825ULL, 0x000fe200078e00ffULL,
0x000000142f00720cULL, 0x000fc40003f06070ULL, 0x000065000d117a10ULL, 0x000fe200037fe4ffULL,
0x00000001080c7824ULL, 0x000fe200078e022fULL, 0x000000700a0a7812ULL, 0x000fe200078ef803ULL,
0x000000012d087824ULL, 0x100fe400078e0217ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000064000a0a7a10ULL, 0x000fe40007fde0ffULL, 0xfffffff825257812ULL, 0x000fe200078ee208ULL,
0x000000012f147824ULL, 0x040fe200078e0217ULL, 0x000000700c037812ULL, 0x000fe200078ef803ULL,
0x000000082f277824ULL, 0x000fe200078e00ffULL, 0xfffffff82b177812ULL, 0x000fe200078ee212ULL,
0x0000001013137824ULL, 0x100fe200078e0218ULL, 0x000065000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x0000001021217824ULL, 0x000fe200078e0218ULL, 0xfffffff827277812ULL, 0x000fe200078ee214ULL,
0x0000001023237824ULL, 0x100fe200078e0218ULL, 0x00006400030c7a10ULL, 0x000fe20007fde0ffULL,
0x0000001017177824ULL, 0x100fe200078e0218ULL, 0x000000001c137faeULL, 0x0003e2000e901c46ULL,
0x0000001025257824ULL, 0x100fe200078e0218ULL, 0x000065000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x0000001027277824ULL, 0x000fe200078e0218ULL, 0x000000001e217faeULL, 0x0003e8000e101c46ULL,
0x000000000e237faeULL, 0x0003e8000d901c46ULL, 0x0000000010177faeULL, 0x0003e8000d101c46ULL,
0x000000000a257faeULL, 0x0003e8000c901c46ULL, 0x000000000c277faeULL, 0x0003e2000c101c46ULL,
0x00000b3000007947ULL, 0x000fea0003800000ULL, 0x00000004170d7811ULL, 0x040fe400078fe8ffULL,
0x00000008170e7811ULL, 0x000fc400078fe8ffULL, 0x0000000c170f7811ULL, 0x000fe200078fe8ffULL,
0x000000010d0a7824ULL, 0x100fe200078e0217ULL, 0x0000001017147811ULL, 0x000fe200078fe8ffULL,
0x000000080d117824ULL, 0x000fe200078e00ffULL, 0x00000014171c7811ULL, 0x040fe200078fe8ffULL,
0x000000010e0b7824ULL, 0x140fe200078e0217ULL, 0x0000001c17207811ULL, 0x000fe200078fe8ffULL,
0x000000080e127824ULL, 0x000fe200078e00ffULL, 0xfffffff811107812ULL, 0x000fe200078ee20aULL,
0x000000010f0c7824ULL, 0x000fe200078e0217ULL, 0x00000018171e7811ULL, 0x000fe200078fe8ffULL,
0x000000080f137824ULL, 0x000fe200078e00ffULL, 0xfffffff812117812ULL, 0x000fe200078ee20bULL,
0x00000001140a7824ULL, 0x140fe200078e0217ULL, 0x0000002017247811ULL, 0x040fe200078fe8ffULL,
0x00000008141d7824ULL, 0x000fe200078e00ffULL, 0x0000002417267811ULL, 0x000fe200078fe8ffULL,
0x000000011c0b7824ULL, 0x140fe200078e0217ULL, 0xfffffff813137812ULL, 0x000fe200078ee20cULL,
0x000000081c227824ULL, 0x000fe200078e00ffULL, 0x0000002c172e7811ULL, 0x000fe200078fe8ffULL,
0x0000000120127824ULL, 0x040fe200078e0217ULL, 0xfffffff81d187812ULL, 0x000fe200078ee20aULL,
0x0000000820237824ULL, 0x000fe200078e00ffULL, 0xfffffff8221d7812ULL, 0x000fe200078ee20bULL,
0x000000011e0c7824ULL, 0x140fe200078e0217ULL, 0x0000002817297811ULL, 0x000fe200078fe8ffULL,
0x000000081e1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee212ULL,
0x00000001240a7824ULL, 0x140fe200078e0217ULL, 0x0000003017307811ULL, 0x000fe200078fe8ffULL,
0x0000000824257824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20cULL,
0x00000001260b7824ULL, 0x140fe200078e0217ULL, 0x0000003417317811ULL, 0x000fe200078fe8ffULL,
0x0000000826287824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee20aULL,
0x000000012e127824ULL, 0x040fe200078e0217ULL, 0x00000008170a7211ULL, 0x000fe200078fe8ffULL,
0x000000082e2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee20bULL,
0x00000001290c7824ULL, 0x000fe200078e0217ULL, 0x00000017170b7211ULL, 0x000fe200078fe8ffULL,
0x00000008292d7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee212ULL,
0x0000000108127824ULL, 0x040fe200078e020fULL, 0x0000003817337811ULL, 0x040fe200078fe8ffULL,
0x0000000108217824ULL, 0x040fe200078e021cULL, 0x0000003c17357811ULL, 0x000fe200078fe8ffULL,
0x0000000108227824ULL, 0x000fe200078e021eULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee20cULL,
0x00000001300f7824ULL, 0x040fe200078e0217ULL, 0x000000070b0c7812ULL, 0x000fe200078ec0ffULL,
0x00000008301e7824ULL, 0x000fe200078e00ffULL, 0x000020001a4f7811ULL, 0x000fe200078e70ffULL,
0x0000000108347824ULL, 0x000fc400078e0231ULL, 0x00000001311c7824ULL, 0x040fe200078e0217ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20fULL, 0x0000000831317824ULL, 0x000fe400078e00ffULL,
0x00000001080d7824ULL, 0x000fe400078e020dULL, 0x000000800a0a7825ULL, 0x000fc800078e00ffULL,
0x00000001080e7824ULL, 0x040fe400078e020eULL, 0x0000000108147824ULL, 0x040fe400078e0214ULL,
0x0000000108277824ULL, 0x040fe200078e0220ULL, 0xfffffff831207812ULL, 0x000fe200078ee21cULL,
0x00000001082a7824ULL, 0x000fe200078e0224ULL, 0x000000700a1c7812ULL, 0x000fe200078ef803ULL,
0x00000001082b7824ULL, 0x040fe400078e0226ULL, 0x00000001082c7824ULL, 0x000fe200078e0229ULL,
0x000064001c1c7a10ULL, 0x000fe20007f1e0ffULL, 0x00000001082e7824ULL, 0x000fc400078e022eULL,
0x0000000108327824ULL, 0x040fe400078e0230ULL, 0x0000000108367824ULL, 0x040fe400078e0233ULL,
0x0000000108387824ULL, 0x000fe200078e0235ULL, 0x0ffffff80c087812ULL, 0x000fe200078ef817ULL,
0x000000800d0c7825ULL, 0x000fc800078e00ffULL, 0x000000101e497824ULL, 0x000fe200078e024fULL,
0x000000700c1e7812ULL, 0x000fe200078ef803ULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x000064001e1e7a10ULL, 0x000fe20007f3e0ffULL, 0x0000000133247824ULL, 0x040fe400078e0217ULL,
0x0000000833337824ULL, 0x000fe400078e00ffULL, 0x000000101d3b7824ULL, 0x100fe200078e024fULL,
0x000065000b1d7a10ULL, 0x000fe200007fe4ffULL, 0x00000010204b7824ULL, 0x000fe200078e024fULL,
0x000000700e207812ULL, 0x000fe200078ef803ULL, 0x0000000135177824ULL, 0x000fe200078e0217ULL,
0xfffffff833247812ULL, 0x000fe200078ee224ULL, 0x0000000835267824ULL, 0x000fe200078e00ffULL,
0x0000640020207a10ULL, 0x000fe20007f1e0ffULL, 0x00000080120a7825ULL, 0x000fc600078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee217ULL, 0x000000101f3d7824ULL, 0x100fe200078e024fULL,
0x000065000d1f7a10ULL, 0x000fe20000ffe4ffULL, 0x00000010233f7824ULL, 0x000fe200078e024fULL,
0x000000700a237812ULL, 0x000fe200078ef803ULL, 0x00000080140c7825ULL, 0x000fc800078e00ffULL,
0x0000001010337824ULL, 0x100fe400078e024fULL, 0x0000001011357824ULL, 0x000fe400078e024fULL,
0x0000008021107825ULL, 0x000fe200078e00ffULL, 0x000065000f217a10ULL, 0x000fc600007fe4ffULL,
0x0000001013377824ULL, 0x100fe400078e024fULL, 0x00000010244d7824ULL, 0x000fe200078e024fULL,
0x000000700c247812ULL, 0x000fe200078ef803ULL, 0x0000008022127825ULL, 0x000fe200078e00ffULL,
0x0000640023227a10ULL, 0x000fe40007f1e0ffULL, 0x0000640024247a10ULL, 0x000fe20007f3e0ffULL,
0x0000001008177824ULL, 0x100fe200078e024fULL, 0x000065000b237a10ULL, 0x000fe200007fe4ffULL,
0x0000001018397824ULL, 0x000fc400078e024fULL, 0x0000001025417824ULL, 0x100fe200078e024fULL,
0x000065000d257a10ULL, 0x000fe20000ffe4ffULL, 0x0000001028437824ULL, 0x000fe200078e024fULL,
0x0000007012287812ULL, 0x000fe200078ef803ULL, 0x000000102d457824ULL, 0x100fe200078e024fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c177faeULL, 0x0003e2000b901c46ULL,
0x000000102f477824ULL, 0x100fe200078e024fULL, 0x0000640028287a10ULL, 0x000fe20007f5e0ffULL,
0x00000010264f7824ULL, 0x000fe200078e024fULL, 0x0000007010267812ULL, 0x100fe200078ef803ULL,
0x00000080270a7825ULL, 0x000fe200078e00ffULL, 0x0000650013297a10ULL, 0x000fe200017fe4ffULL,
0x000000001e337faeULL, 0x0003e2000b901c46ULL, 0x0000640026267a10ULL, 0x000fe20007f1e0ffULL,
0x000000802a0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a2a7812ULL, 0x100fe200078ef803ULL,
0x0000000020357faeULL, 0x0003e2000b901c46ULL, 0x0000650011277a10ULL, 0x000fe200007fe4ffULL,
0x000000802b0e7825ULL, 0x000fe200078e00ffULL, 0x000064002a2a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000022377faeULL, 0x0003e4000b901c46ULL, 0x000000802c107825ULL, 0x000fe200078e00ffULL,
0x000000700c2c7812ULL, 0x100fe200078ef803ULL, 0x0000000024397faeULL, 0x0003e2000b901c46ULL,
0x000065000b2b7a10ULL, 0x000fe200007fe4ffULL, 0x000000802e127825ULL, 0x000fe200078e00ffULL,
0x000000700e2e7812ULL, 0x100fe200078ef803ULL, 0x00000000263b7faeULL, 0x0003e2000b901c46ULL,
0x0000007010307812ULL, 0x000fe200078ef803ULL, 0x00000080320a7825ULL, 0x000fe200078e00ffULL,
0x000064002c2c7a10ULL, 0x000fe20007f3e0ffULL, 0x00000000283d7faeULL, 0x0003e2000b901c46ULL,
0x000064002e2e7a10ULL, 0x000fc40007f1e0ffULL, 0x0000640030307a10ULL, 0x000fe20007f5e0ffULL,
0x000000002a3f7faeULL, 0x0003e2000b901c46ULL, 0x000065000d2d7a10ULL, 0x000fe20000ffe4ffULL,
0x00000080340c7825ULL, 0x000fe200078e00ffULL, 0x0000007012127812ULL, 0x100fe400078ef803ULL,
0x000065000f2f7a10ULL, 0x000fe200007fe4ffULL, 0x00000080360e7825ULL, 0x000fe200078e00ffULL,
0x0000650011317a10ULL, 0x000fe200017fe4ffULL, 0x000000002c417faeULL, 0x0003e2000b901c46ULL,
0x0000640012127a10ULL, 0x000fe20007f1e0ffULL, 0x0000008038107825ULL, 0x000fe200078e00ffULL,
0x000000700a0a7812ULL, 0x100fe200078ef803ULL, 0x000000002e437faeULL, 0x0003e2000b901c46ULL,
0x000000700c0c7812ULL, 0x000fc400078ef803ULL, 0x000000700e0e7812ULL, 0x100fe200078ef803ULL,
0x0000000030457faeULL, 0x0003e2000b901c46ULL, 0x0000650013137a10ULL, 0x000fe400007fe4ffULL,
0x0000007010037812ULL, 0x000fe400078ef803ULL, 0x000064000a0a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000012477faeULL, 0x0003e2000b901c46ULL, 0x000064000c0c7a10ULL, 0x000fe40007f3e0ffULL,
0x000064000e0e7a10ULL, 0x000fc40007f5e0ffULL, 0x0000640003107a10ULL, 0x000fe40007f7e0ffULL,
0x000065000b0b7a10ULL, 0x000fe400007fe4ffULL, 0x000065000d0d7a10ULL, 0x000fe40000ffe4ffULL,
0x000065000f0f7a10ULL, 0x000fe200017fe4ffULL, 0x000000000a497faeULL, 0x0003e2000b901c46ULL,
0x0000650011117a10ULL, 0x000fc60001ffe4ffULL, 0x000000000c4b7faeULL, 0x0003e8000b901c46ULL,
0x000000000e4d7faeULL, 0x0003e8000b901c46ULL, 0x00000000104f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000a7805ULL, 0x002fc40000015200ULL,
0x01a60400ff037984ULL, 0x000e620000000800ULL, 0x0000000902837224ULL, 0x000fe400078e02ffULL,
0x0000000116027824ULL, 0x000fc400078e0a00ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x8000000003ff7812ULL, 0x006fe20007804805ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000620083827625ULL, 0x000fe200078e0082ULL,
0x00000008ff027819ULL, 0x000fe20000011602ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a087210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0c7824ULL, 0x000fe200000e0e0bULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140cULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e060cULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x000000201a037824ULL, 0x002fca00078e0203ULL,
0x00000004ff047819ULL, 0x000fe40000011603ULL, 0x0000000103057810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe04087812ULL, 0x000fe400078ec0ffULL, 0x0000001f03047812ULL, 0x000fc600078ec0ffULL,
0x00000001080b7824ULL, 0x040fe400078e0205ULL, 0x00000001030a7824ULL, 0x000fe200078e0208ULL,
0x0000000808087810ULL, 0x000fe20007ffe0ffULL, 0x00000010040c7824ULL, 0x040fe200078e00ffULL,
0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL, 0x00000010040d7824ULL, 0x000fe200078e00ffULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000105057824ULL, 0x100fe200078e0208ULL,
0x000001f00c0b7812ULL, 0x000fe200078ee20bULL, 0x0000000103037824ULL, 0x000fe200078e0208ULL,
0x000001f00d0a7812ULL, 0x000fe200078ee20aULL, 0x0000001004087824ULL, 0x040fe200078e00ffULL,
0x0000000f05057812ULL, 0x000fe200078ec0ffULL, 0x000000000b0c7984ULL, 0x000e62000000cc00ULL,
0x0000001004047824ULL, 0x000fe200078e00ffULL, 0x0000000f03037812ULL, 0x000fc400078ec0ffULL,
0x000000000a107984ULL, 0x000ea4000000cc00ULL, 0x000001f004057812ULL, 0x000fe400078ee205ULL,
0x000001f008037812ULL, 0x000fe200078ee203ULL, 0x000000ffff1e7224ULL, 0x002fe400078e000cULL,
0x000000ffff1f7224ULL, 0x000fe400078e000eULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0012ULL, 0x000000ffff227224ULL, 0x000fe400078e000dULL,
0x000000ffff237224ULL, 0x000fe200078e000fULL, 0x0000001c0a007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff207224ULL, 0x000fe400078e0011ULL, 0x000000ffff217224ULL, 0x000fca00078e0013ULL,
0x000000200b007388ULL, 0x000fe8000000cc00ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000003107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff277224ULL, 0x002fe400078e000eULL,
0x000000ffff267224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff247224ULL, 0x004fe400078e0010ULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000002403007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a60000ff0c7f8cULL, 0x002e62000c80043fULL,
0x000000ffff0e7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x000fc80000015200ULL,
0x01a60400ff037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x006fc4000780480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a04087210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0a7824ULL, 0x000fe200000e0e05ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140aULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e060aULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x0000010007047810ULL, 0x000fe20007ffe0ffULL, 0x0000000209057824ULL, 0x000fe200078e00ffULL,
0x0001a6881a077811ULL, 0x000fe200078e18ffULL, 0x3db504f306067820ULL, 0x010fe20000410000ULL,
0xffffffff00087810ULL, 0x040fe20007ffe0ffULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000900097810ULL, 0x000fe40007ffe0ffULL, 0x0001a6081abb7811ULL, 0x000fc600078e28ffULL,
0x000000020a0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000010b0d7812ULL, 0x000fc400078e0cffULL, 0x000000150c00720cULL, 0x000fe20003f06070ULL,
0x000001000a0c7824ULL, 0x000fc800078e0204ULL, 0x000068001b0e7a24ULL, 0x000fd000078e020cULL,
0x00000ca000008947ULL, 0x008fea0003800000ULL, 0x00000003ff187819ULL, 0x102fe20000011603ULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c160f7217ULL, 0x000fe40007800000ULL,
0x0000000418127810ULL, 0x040fe40007ffe0ffULL, 0x0000000818147810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0f7824ULL, 0x000fe200078e0a0cULL, 0x0000007011337812ULL, 0x000fe200078ec0ffULL,
0x0000000112107824ULL, 0x100fe200078e0203ULL, 0x00000010181e7810ULL, 0x000fe20007ffe0ffULL,
0x00000008122d7824ULL, 0x040fe200078e00ffULL, 0x0000000f1200720cULL, 0x000fe20003fa6070ULL,
0x0000000114137824ULL, 0x000fe200078e0203ULL, 0x00000014182c7810ULL, 0x000fe20007ffe0ffULL,
0x00000008141c7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee210ULL,
0x0000000118107824ULL, 0x140fe200078e020eULL, 0x00000018182e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000112127824ULL, 0x000fe200078e020eULL, 0xfffffff81c2f7812ULL, 0x000fe200078ee213ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000c181c7810ULL, 0x000fc40007ffe0ffULL,
0x0000001c18327810ULL, 0x000fe20007ffe0ffULL, 0x000000081e357824ULL, 0x000fe200078e00ffULL,
0x0000003310227212ULL, 0x000fe200078efcffULL, 0x000000011e107824ULL, 0x100fe200078e0203ULL,
0x0000000f1c00720cULL, 0x000fe20003f46070ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000640022227a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff835357812ULL, 0x000fe200078ee210ULL,
0x0000000114107824ULL, 0x000fe200078e020eULL, 0x0000003312247212ULL, 0x000fe200078efcffULL,
0x000000011c177824ULL, 0x000fe200078e0203ULL, 0x0000650011237a10ULL, 0x000fe200007fe4ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000640024247a10ULL, 0x000fc40007f3e0ffULL,
0x0000000f1e00720cULL, 0x000fe20003f06070ULL, 0x000000081c207824ULL, 0x000fe200078e00ffULL,
0x0000003310267212ULL, 0x080fe200078efcffULL, 0x000000011c127824ULL, 0x100fe200078e020eULL,
0x0000650013257a10ULL, 0x000fe20000ffe4ffULL, 0x000000011e1c7824ULL, 0x000fe200078e020eULL,
0xfffffff820317812ULL, 0x000fe200078ee217ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000640026267a10ULL, 0x000fe40007f7e0ffULL, 0x0000002018347810ULL, 0x000fe20007ffe0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000003312287212ULL, 0x000fc400078efcffULL,
0x0000650011277a10ULL, 0x000fe20001ffe4ffULL, 0x000000012c1e7824ULL, 0x100fe200078e020eULL,
0x000000331c1c7212ULL, 0x080fe200078efcffULL, 0x000000012e207824ULL, 0x100fe200078e020eULL,
0x0000640028287a10ULL, 0x000fe20007f9e0ffULL, 0x0000000132107824ULL, 0x000fe200078e020eULL,
0x000064001c1c7a10ULL, 0x000fe20007f7e0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000650013297a10ULL, 0x000fe400027fe4ffULL, 0x000065001d1d7a10ULL, 0x000fe20001ffe4ffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x000000331e1e7212ULL, 0x000fc400078efcffULL,
0x0000000f1400720cULL, 0x000fe20003f26070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000003320207212ULL, 0x080fe400078efcffULL, 0x000064001e1e7a10ULL, 0x000fe20007f7e0ffULL,
0x0000000118127824ULL, 0x000fe200078e0203ULL, 0x00000033102a7212ULL, 0x000fe200078efcffULL,
0x000000021a147824ULL, 0x000fe200078e020dULL, 0x0000640020207a10ULL, 0x000fe20007f9e0ffULL,
0x0000000134107824ULL, 0x000fe200078e020eULL, 0x000064002a2a7a10ULL, 0x000fe20007fde0ffULL,
0x000000012c137824ULL, 0x100fe200078e0203ULL, 0x000065001f1f7a10ULL, 0x000fe20001ffe4ffULL,
0x000000012e307824ULL, 0x040fe200078e0203ULL, 0x0000650021217a10ULL, 0x000fe200027fe4ffULL,
0x000000082e397824ULL, 0x000fe200078e00ffULL, 0x0000000712127812ULL, 0x000fc400078ec0ffULL,
0x0000000f1800720cULL, 0x080fe40003f86070ULL, 0x0000000f2c00720cULL, 0x040fe20003f66070ULL,
0x000000082c2c7824ULL, 0x000fe200078e00ffULL, 0x00006500112b7a10ULL, 0x000fe200037fe4ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000002418367810ULL, 0x000fe40007ffe0ffULL,
0x0000200014147811ULL, 0x000fe400078e68ffULL, 0x0ffffff812177812ULL, 0x000fe200078ef803ULL,
0x0000000136127824ULL, 0x000fe200078e020eULL, 0xfffffff82c377812ULL, 0x000fe200078ee213ULL,
0x000000102f2f7824ULL, 0x100fe200078e0214ULL, 0x0000002818387810ULL, 0x000fe20007ffe0ffULL,
0x0000001017177824ULL, 0x000fe200078e0214ULL, 0x00000033102c7212ULL, 0x000fe200078efcffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fc400078ee230ULL,
0x000064002c2c7a10ULL, 0x000fe20007fde0ffULL, 0x0000000138107824ULL, 0x000fe200078e020eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022177faeULL, 0x0003e2000e101c46ULL,
0x0000003312127212ULL, 0x000fe400078efcffULL, 0x0000000f2e00720cULL, 0x000fe40003f86070ULL,
0x0000002c182e7810ULL, 0x040fe40007ffe0ffULL, 0x0000003c18307810ULL, 0x000fe20007ffe0ffULL,
0x000000102d177824ULL, 0x002fe200078e0214ULL, 0x00006500112d7a10ULL, 0x000fe200037fe4ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000640012127a10ULL, 0x000fc40007fde0ffULL,
0x0000000024177faeULL, 0x0003e2000e901c46ULL, 0x0000000f3200720cULL, 0x040fe20003fa6070ULL,
0x0000000132237824ULL, 0x000fe200078e0203ULL, 0x0000003310227212ULL, 0x000fe200078efcffULL,
0x0000000832327824ULL, 0x000fe200078e00ffULL, 0x0000650013137a10ULL, 0x000fe200037fe4ffULL,
0x000000012e107824ULL, 0x000fe200078e020eULL, 0x0000640022227a10ULL, 0x000fe20007fde0ffULL,
0x00000000262f7faeULL, 0x0005e2000c901c46ULL, 0xfffffff8323b7812ULL, 0x000fe400078ee223ULL,
0x0000650011237a10ULL, 0x000fe200037fe4ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000f3400720cULL, 0x000fc60003f26070ULL, 0x0000000134257824ULL, 0x102fe200078e0203ULL,
0x0000003310247212ULL, 0x000fe200078efcffULL, 0x0000000834347824ULL, 0x000fe400078e00ffULL,
0x0000001031177824ULL, 0x100fe200078e0214ULL, 0x0000640024247a10ULL, 0x000fe20007fde0ffULL,
0x0000000136107824ULL, 0x000fe200078e0203ULL, 0x0000003018267810ULL, 0x004fe20007ffe0ffULL,
0x0000000836317824ULL, 0x000fe200078e00ffULL, 0xfffffff8342f7812ULL, 0x000fe200078ee225ULL,
0x0000001035277824ULL, 0x100fe200078e0214ULL, 0x0000650011257a10ULL, 0x000fe200037fe4ffULL,
0x0000001037117824ULL, 0x000fe200078e0214ULL, 0xfffffff831317812ULL, 0x000fe200078ee210ULL,
0x0000000028177faeULL, 0x0003e2000d101c46ULL, 0x0000000126107824ULL, 0x000fe200078e020eULL,
0x0000000f3600720cULL, 0x080fe20003f46070ULL, 0x000000102f2f7824ULL, 0x100fe200078e0214ULL,
0x000000001c277faeULL, 0x0005e2000c101c46ULL, 0x0000001031317824ULL, 0x000fe200078e0214ULL,
0x0000000f3000720cULL, 0x000fc40003f06070ULL, 0x000000001e117faeULL, 0x0007e2000d901c46ULL,
0x0000000f2600720cULL, 0x080fe20003f66070ULL, 0x0000001039177824ULL, 0x102fe200078e0214ULL,
0x0000003418287810ULL, 0x000fe20007ffe0ffULL, 0x000000103b297824ULL, 0x000fe400078e0214ULL,
0x00000008381d7824ULL, 0x004fe200078e00ffULL, 0x0000000020177faeULL, 0x0003e2000e101c46ULL,
0x0000000f2e00720cULL, 0x080fe20003f86070ULL, 0x0000000828277824ULL, 0x000fe200078e00ffULL,
0x00000038181e7810ULL, 0x008fe20007ffe0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000002a297faeULL, 0x0005e2000e901c46ULL, 0x0000000f3800720cULL, 0x000fc40003fa6070ULL,
0x0000000138187824ULL, 0x100fe200078e0203ULL, 0x00000033101c7212ULL, 0x000fe200078efcffULL,
0x000000002c2f7faeULL, 0x0007e2000c901c46ULL, 0x000000011e107824ULL, 0x140fe200078e020eULL,
0x0000000f1e00720cULL, 0x080fe20003f26070ULL, 0x0000000128177824ULL, 0x002fe200078e020eULL,
0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL, 0x0000000012317faeULL, 0x0003e2000d101c46ULL,
0x0000000f2800720cULL, 0x000fe20003f46070ULL, 0x000000012e0f7824ULL, 0x040fe400078e0203ULL,
0x000000082e2e7824ULL, 0x000fc400078e00ffULL, 0x00000001300e7824ULL, 0x000fe400078e020eULL,
0x000000011e207824ULL, 0x000fe200078e0203ULL, 0xfffffff82e1f7812ULL, 0x000fe200078ee20fULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000008017127825ULL, 0x002fe200078e00ffULL,
0xfffffff81d177812ULL, 0x000fe400078ee218ULL, 0x00006500111d7a10ULL, 0x000fe200037fe4ffULL,
0x0000000126117824ULL, 0x100fe200078e0203ULL, 0x0000003312127212ULL, 0x080fe200078efcffULL,
0x0000000826267824ULL, 0x000fe200078e00ffULL, 0x000000330e0e7212ULL, 0x000fe200078efcffULL,
0x0000000128187824ULL, 0x000fe200078e0203ULL, 0x0000640012127a10ULL, 0x000fe20007fde0ffULL,
0x000000081e297824ULL, 0x004fe200078e00ffULL, 0xfffffff826217812ULL, 0x000fe200078ee211ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000650013137a10ULL, 0x000fc400037fe4ffULL,
0xfffffff827277812ULL, 0x000fe200078ee218ULL, 0x00000001301e7824ULL, 0x000fe200078e0203ULL,
0x0000003310107212ULL, 0x000fe200078efcffULL, 0x00000008302b7824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee220ULL, 0x0000001017177824ULL, 0x100fe200078e0214ULL,
0x0000640010107a10ULL, 0x000fe20007fde0ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0214ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee21eULL, 0x0000001021217824ULL, 0x100fe200078e0214ULL,
0x0000650011117a10ULL, 0x000fe200037fe4ffULL, 0x0000001027277824ULL, 0x100fe200078e0214ULL,
0x000064000e0e7a10ULL, 0x000fe20007fde0ffULL, 0x0000001029297824ULL, 0x100fe200078e0214ULL,
0x0000000022177faeULL, 0x0007e2000e901c46ULL, 0x000000102b2b7824ULL, 0x000fe200078e0214ULL,
0x000065000f0f7a10ULL, 0x000fc400037fe4ffULL, 0x00000000241f7faeULL, 0x0007e8000e101c46ULL,
0x000000001c217faeULL, 0x0007e8000d901c46ULL, 0x0000000012277faeULL, 0x0007e8000d101c46ULL,
0x0000000010297faeULL, 0x0007e8000c901c46ULL, 0x000000000e2b7faeULL, 0x0007e2000c101c46ULL,
0x00000b6000007947ULL, 0x000fea0003800000ULL, 0x0000000403107811ULL, 0x042fe400078fe8ffULL,
0x0000000803127811ULL, 0x000fc400078fe8ffULL, 0x00000014031c7811ULL, 0x040fe200078fe8ffULL,
0x00000001100f7824ULL, 0x140fe200078e0203ULL, 0x0000001c032b7811ULL, 0x040fe200078fe8ffULL,
0x0000000810147824ULL, 0x000fe200078e00ffULL, 0x00000018031e7811ULL, 0x040fe200078fe8ffULL,
0x0000000112117824ULL, 0x040fe200078e0203ULL, 0x00000020032e7811ULL, 0x040fe200078fe8ffULL,
0x0000000812187824ULL, 0x000fe200078e00ffULL, 0xfffffff814377812ULL, 0x000fe200078ee20fULL,
0x000000011c137824ULL, 0x040fe200078e0203ULL, 0x0000000c03147811ULL, 0x040fe200078fe8ffULL,
0x000000081c247824ULL, 0x000fe200078e00ffULL, 0xfffffff818397812ULL, 0x000fe200078ee211ULL,
0x000000011e177824ULL, 0x100fe200078e0203ULL, 0x0000001003187811ULL, 0x040fe200078fe8ffULL,
0x00000001140f7824ULL, 0x140fe200078e0203ULL, 0x00000024032f7811ULL, 0x040fe200078fe8ffULL,
0x0000000814207824ULL, 0x000fe200078e00ffULL, 0x0000002c03317811ULL, 0x040fe200078fe8ffULL,
0x0000000118117824ULL, 0x040fe200078e0203ULL, 0x0000002803307811ULL, 0x000fe200078fe8ffULL,
0x0000000818227824ULL, 0x000fe200078e00ffULL, 0xfffffff8203b7812ULL, 0x000fe200078ee20fULL,
0x000000012b0f7824ULL, 0x000fe200078e0203ULL, 0x0000003003367811ULL, 0x000fe200078fe8ffULL,
0x000000082b207824ULL, 0x000fe200078e00ffULL, 0xfffffff8223d7812ULL, 0x000fe200078ee211ULL,
0x000000081e267824ULL, 0x000fe200078e00ffULL, 0xfffffff8243f7812ULL, 0x000fe200078ee213ULL,
0x000000012e117824ULL, 0x000fe200078e0203ULL, 0xfffffff820437812ULL, 0x000fe200078ee20fULL,
0x000000082e227824ULL, 0x000fe200078e00ffULL, 0xfffffff826417812ULL, 0x000fe200078ee217ULL,
0x000000012f137824ULL, 0x000fe200078e0203ULL, 0x0000003403387811ULL, 0x000fe200078fe8ffULL,
0x000000082f247824ULL, 0x000fe200078e00ffULL, 0xfffffff822457812ULL, 0x000fe200078ee211ULL,
0x00000001310f7824ULL, 0x000fe200078e0203ULL, 0x00000038033a7811ULL, 0x000fe200078fe8ffULL,
0x0000000831207824ULL, 0x000fe200078e00ffULL, 0xfffffff824477812ULL, 0x000fe200078ee213ULL,
0x0000000130177824ULL, 0x040fe200078e0203ULL, 0x0000003c031d7811ULL, 0x040fe200078fe8ffULL,
0x0000000830267824ULL, 0x000fe200078e00ffULL, 0xfffffff8204b7812ULL, 0x000fe200078ee20fULL,
0x0000000136117824ULL, 0x040fe200078e0203ULL, 0x0000000e030f7211ULL, 0x000fe200078fe8ffULL,
0x0000000836227824ULL, 0x000fe200078e00ffULL, 0xfffffff826497812ULL, 0x000fe200078ee217ULL,
0x0000000138137824ULL, 0x000fc400078e0203ULL, 0x0000000838247824ULL, 0x000fe200078e00ffULL,
0xfffffff8224d7812ULL, 0x000fe200078ee211ULL, 0x000000013a177824ULL, 0x040fe400078e0203ULL,
0x000000083a267824ULL, 0x000fe200078e00ffULL, 0xfffffff8244f7812ULL, 0x000fe200078ee213ULL,
0x0000001003117824ULL, 0x040fe200078e00ffULL, 0x0000000303137211ULL, 0x000fe200078fe8ffULL,
0x0000000110107824ULL, 0x100fe200078e020eULL, 0xfffffff826517812ULL, 0x000fe200078ee217ULL,
0x0000000112127824ULL, 0x100fe200078e020eULL, 0x0000007011557812ULL, 0x000fe200078ec0ffULL,
0x0000000114147824ULL, 0x100fe200078e020eULL, 0x0000000713227812ULL, 0x000fe200078ec0ffULL,
0x0000000118187824ULL, 0x000fc400078e020eULL, 0x000000011c1c7824ULL, 0x100fe400078e020eULL,
0x000000011e1e7824ULL, 0x100fe400078e020eULL, 0x000000012b2b7824ULL, 0x100fe400078e020eULL,
0x000000012e2e7824ULL, 0x100fe400078e020eULL, 0x000000012f2f7824ULL, 0x100fe400078e020eULL,
0x0000000130307824ULL, 0x000fc400078e020eULL, 0x0000000131317824ULL, 0x100fe400078e020eULL,
0x0000000136367824ULL, 0x100fe400078e020eULL, 0x0000000138387824ULL, 0x100fe400078e020eULL,
0x000000013a3a7824ULL, 0x100fe400078e020eULL, 0x000000011d3c7824ULL, 0x040fe400078e020eULL,
0x000000011d1f7824ULL, 0x000fc400078e0203ULL, 0x000000081d207824ULL, 0x000fe400078e00ffULL,
0x000000800f0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff8201f7812ULL, 0x000fe200078ee21fULL,
0x000000021a177824ULL, 0x000fe200078e020dULL, 0x000000550e207212ULL, 0x000fe200078efcffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x0000200017247811ULL, 0x000fe200078e68ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0ffffff822177812ULL, 0x000fe400078ef803ULL,
0x0000640020207a10ULL, 0x000fe20007f1e0ffULL, 0x0000001037377824ULL, 0x100fe200078e0224ULL,
0x0000005510227212ULL, 0x000fe200078efcffULL, 0x0000001017177824ULL, 0x100fe200078e0224ULL,
0x000065000f217a10ULL, 0x000fe200007fe4ffULL, 0x0000001039397824ULL, 0x100fe200078e0224ULL,
0x0000640022227a10ULL, 0x000fe20007f3e0ffULL, 0x000000103b3b7824ULL, 0x000fc400078e0224ULL,
0x000000103d3d7824ULL, 0x100fe200078e0224ULL, 0x0000650011237a10ULL, 0x000fe20000ffe4ffULL,
0x000000103f3f7824ULL, 0x100fe200078e0224ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020177faeULL, 0x0003e2000b901c46ULL, 0x0000001041417824ULL, 0x100fe400078e0224ULL,
0x0000001043437824ULL, 0x100fe200078e0224ULL, 0x0000000022377faeULL, 0x0003e2000b901c46ULL,
0x0000001045457824ULL, 0x100fe400078e0224ULL, 0x0000001047477824ULL, 0x000fc400078e0224ULL,
0x0000001049497824ULL, 0x100fe400078e0224ULL, 0x000000104b4b7824ULL, 0x100fe400078e0224ULL,
0x000000104d4d7824ULL, 0x100fe400078e0224ULL, 0x000000104f4f7824ULL, 0x100fe400078e0224ULL,
0x0000001051517824ULL, 0x100fe400078e0224ULL, 0x000000101f537824ULL, 0x000fe200078e0224ULL,
0x0000005512247212ULL, 0x000fe200078efcffULL, 0x00000080140e7825ULL, 0x000fc600078e00ffULL,
0x0000640024247a10ULL, 0x000fe20007f1e0ffULL, 0x0000008018107825ULL, 0x000fe200078e00ffULL,
0x000000550e267212ULL, 0x080fe400078efcffULL, 0x0000650013257a10ULL, 0x000fe200007fe4ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000005510287212ULL, 0x080fe400078efcffULL,
0x0000640026267a10ULL, 0x000fe20007f1e0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x000000551c2a7212ULL, 0x000fe200078efcffULL, 0x0000000024397faeULL, 0x0003e2000b901c46ULL,
0x0000640028287a10ULL, 0x000fe20007f3e0ffULL, 0x000000802f127825ULL, 0x000fe200078e00ffULL,
0x000065000f277a10ULL, 0x000fc400007fe4ffULL, 0x000064002a2a7a10ULL, 0x000fe20007f1e0ffULL,
0x000000802b0e7825ULL, 0x000fe200078e00ffULL, 0x000000551e2c7212ULL, 0x080fe200078efcffULL,
0x00000000263b7faeULL, 0x0003e2000b901c46ULL, 0x0000650011297a10ULL, 0x000fe20000ffe4ffULL,
0x000000802e107825ULL, 0x000fe200078e00ffULL, 0x000065001d2b7a10ULL, 0x000fe400007fe4ffULL,
0x000000550e2e7212ULL, 0x080fe200078efcffULL, 0x00000080301c7825ULL, 0x000fe200078e00ffULL,
0x000064002c2c7a10ULL, 0x000fe20007f5e0ffULL, 0x00000000283d7faeULL, 0x0003e2000b901c46ULL,
0x0000005510307212ULL, 0x000fc400078efcffULL, 0x000064002e2e7a10ULL, 0x000fe20007f1e0ffULL,
0x000000002a3f7faeULL, 0x0003e2000b901c46ULL, 0x0000005512327212ULL, 0x080fe400078efcffULL,
0x000065001f2d7a10ULL, 0x000fe200017fe4ffULL, 0x00000080311e7825ULL, 0x000fe200078e00ffULL,
0x000000551c347212ULL, 0x000fe400078efcffULL, 0x0000640030307a10ULL, 0x000fe20007f3e0ffULL,
0x000000002c417faeULL, 0x0003e2000b901c46ULL, 0x000065000f2f7a10ULL, 0x000fe200007fe4ffULL,
0x00000080360e7825ULL, 0x000fe200078e00ffULL, 0x0000640032327a10ULL, 0x000fc40007f1e0ffULL,
0x0000640034347a10ULL, 0x000fe20007f5e0ffULL, 0x000000002e437faeULL, 0x0003e2000b901c46ULL,
0x0000650011317a10ULL, 0x000fe20000ffe4ffULL, 0x0000008038107825ULL, 0x000fe200078e00ffULL,
0x000000551e1e7212ULL, 0x080fe400078efcffULL, 0x0000650013337a10ULL, 0x000fe200007fe4ffULL,
0x000000803a127825ULL, 0x000fe200078e00ffULL, 0x000065001d357a10ULL, 0x000fe200017fe4ffULL,
0x0000000030457faeULL, 0x0003e2000b901c46ULL, 0x000064001e1e7a10ULL, 0x000fe20007f1e0ffULL,
0x000000803c1c7825ULL, 0x000fe200078e00ffULL, 0x000000550e0e7212ULL, 0x080fe200078efcffULL,
0x0000000032477faeULL, 0x0003e2000b901c46ULL, 0x0000005510107212ULL, 0x000fc400078efcffULL,
0x0000005512127212ULL, 0x080fe200078efcffULL, 0x0000000034497faeULL, 0x0003e2000b901c46ULL,
0x000065001f1f7a10ULL, 0x000fe400007fe4ffULL, 0x000000551c1c7212ULL, 0x000fe400078efcffULL,
0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x000000001e4b7faeULL, 0x0003e2000b901c46ULL,
0x0000640010107a10ULL, 0x000fe40007f3e0ffULL, 0x0000640012127a10ULL, 0x000fc40007f5e0ffULL,
0x000064001c1c7a10ULL, 0x000fe40007f7e0ffULL, 0x000065000f0f7a10ULL, 0x000fe400007fe4ffULL,
0x0000650011117a10ULL, 0x000fe40000ffe4ffULL, 0x0000650013137a10ULL, 0x000fe200017fe4ffULL,
0x000000000e4d7faeULL, 0x0003e2000b901c46ULL, 0x000065001d1d7a10ULL, 0x000fc60001ffe4ffULL,
0x00000000104f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012517faeULL, 0x0003e8000b901c46ULL,
0x000000001c537faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff0e7224ULL, 0x00afe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000006e7805ULL, 0x000fe2000001ff00ULL,
0x00000000006c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff803107812ULL, 0x000fe200078ec0ffULL, 0x000000021a717824ULL, 0x020fe200078e020bULL,
0x000000010e727810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000007100f7812ULL, 0x000fc400078ef803ULL, 0x0000200071717811ULL, 0x000fc600078e68ffULL,
0x000000010f107824ULL, 0x040fe400078e020eULL, 0x000000080f117824ULL, 0x040fe400078e00ffULL,
0x000000080f127824ULL, 0x040fe400078e00ffULL, 0x000000010f0f7824ULL, 0x000fe200078e0272ULL,
0xfffffff811107812ULL, 0x000fc800078ee210ULL, 0xfffffff812127812ULL, 0x000fe200078ee20fULL,
0x0000001010107824ULL, 0x000fc800078e0271ULL, 0x0000001012127824ULL, 0x000fe200078e0271ULL,
0x000000001028783bULL, 0x000e680000000200ULL, 0x000000001230783bULL, 0x0004e40000000200ULL,
0x0000002003127810ULL, 0x004fc80007ffe0ffULL, 0xfffffff812127812ULL, 0x000fc800078ec0ffULL,
0x0000000712737812ULL, 0x000fca00078ef803ULL, 0x0000000173127824ULL, 0x040fe400078e020eULL,
0x00000008731d7824ULL, 0x040fe400078e00ffULL, 0x0000000173727824ULL, 0x040fe400078e0272ULL,
0x0000000873737824ULL, 0x000fe200078e00ffULL, 0xfffffff81d127812ULL, 0x000fc800078ee212ULL,
0xfffffff873727812ULL, 0x000fe200078ee272ULL, 0x00000010122c7824ULL, 0x000fe200078e0271ULL,
0x00000018ff137819ULL, 0x002fe20000011428ULL, 0x0000002800f97306ULL, 0x000fe20000009400ULL,
0x00000018ff147819ULL, 0x000fc60000011429ULL, 0x000000002c2c783bULL, 0x000e620000000200ULL,
0x00000018ff1f7819ULL, 0x008fe20000011431ULL, 0x0001000033767824ULL, 0x000fe200078e00ffULL,
0x00000018ff177819ULL, 0x000fe4000001142aULL, 0x00000018ff187819ULL, 0x000fe2000001142bULL,
0x0000001300937306ULL, 0x000fe20000209400ULL, 0x00000018ff707819ULL, 0x000fe40000011432ULL,
0x00000018ff1d7819ULL, 0x000fe40000011430ULL, 0x00000018ff747819ULL, 0x000fc60000011433ULL,
0x0000001300cc7306ULL, 0x000eb00000205400ULL, 0x0000001300697306ULL, 0x000ef0000020d400ULL,
0x0000001f008a7306ULL, 0x000fe20000209400ULL, 0x000000cc9300720bULL, 0x004fce0003f3d000ULL,
0x0000001f008b7306ULL, 0x000fec0000205400ULL, 0x0000000169691812ULL, 0x008fe400078efcffULL,
0x0000001f00137306ULL, 0x0005f0000020d400ULL, 0x0000002800e27306ULL, 0x000ee20000005400ULL,
0x00010000281f7824ULL, 0x004fca00078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000002800687306ULL, 0x000530000000d400ULL, 0x0000001f00927306ULL, 0x000fe20000209400ULL,
0x0000010028287824ULL, 0x004fe200078e00ffULL, 0x000000e2f900720bULL, 0x008fc80003f1d000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000001f00f57306ULL, 0x000eae0000205400ULL,
0x0000000168680812ULL, 0x010fe200078efcffULL, 0x0000002800cd7306ULL, 0x000ff00000209400ULL,
0x0000002800d27306ULL, 0x000ee20000205400ULL, 0x000000f59200720bULL, 0x004fce0003f9d000ULL,
0x0000002800a27306ULL, 0x000530000020d400ULL, 0x0000001f009f7306ULL, 0x000322000020d400ULL,
0x000100002b287824ULL, 0x004fe200078e00ffULL, 0x000000d2cd00720bULL, 0x008fc80003f5d000ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000001400c27306ULL, 0x000fe20000209400ULL,
0x000100002a1f7824ULL, 0x002fca00078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000001400d17306ULL, 0x000e620000205400ULL, 0x00000001a2a22812ULL, 0x010fe400078efcffULL,
0x000000019f9f4812ULL, 0x000fe400078efcffULL, 0x000000a26969723eULL, 0x000fe400000010ffULL,
0x000000689f68723eULL, 0x000fe200000010ffULL, 0x00000014006b7306ULL, 0x000eb0000020d400ULL,
0x0000001700c37306ULL, 0x000fe20000209400ULL, 0x000000d1c200720bULL, 0x002fce0003f9d000ULL,
0x0000001700c47306ULL, 0x000e6c0000205400ULL, 0x000000016b6b4812ULL, 0x004fe400078efcffULL,
0x0000001700b17306ULL, 0x000eb0000020d400ULL, 0x0000001800ed7306ULL, 0x000fe20000209400ULL,
0x000000c4c300720bULL, 0x002fce0003f1d000ULL, 0x0000001800967306ULL, 0x000fec0000205400ULL,
0x00000001b1b10812ULL, 0x004fe400078efcffULL, 0x0000001800b47306ULL, 0x000ff0000020d400ULL,
0x0000007000147306ULL, 0x000ff00000209400ULL, 0x0000007000177306ULL, 0x000ff00000205400ULL,
0x0000007000187306ULL, 0x0003f0000020d400ULL, 0x0000002800eb7306ULL, 0x000fe20000209400ULL,
0x0001000029707824ULL, 0x002fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000002800ec7306ULL, 0x000ff00000205400ULL, 0x0000002800d57306ULL, 0x0003f0000020d400ULL,
0x0000002900f27306ULL, 0x000fe20000009400ULL, 0x00000018ff287819ULL, 0x002fce000001142eULL,
0x0000002900bf7306ULL, 0x000e700000005400ULL, 0x00000029006a7306ULL, 0x0004f0000000d400ULL,
0x0000002a00907306ULL, 0x000fe20000009400ULL, 0x0000010029297824ULL, 0x004fe200078e00ffULL,
0x000000bff200720bULL, 0x002fc80003f7d000ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002a00f77306ULL, 0x000e6e0000005400ULL, 0x000000016a6a3812ULL, 0x008fe200078efcffULL,
0x0000002a00da7306ULL, 0x0004e2000000d400ULL, 0x00000096ed00720bULL, 0x000fce0003f7d000ULL,
0x0000002b00917306ULL, 0x000fe20000009400ULL, 0x000001002a2a7824ULL, 0x004fe200078e00ffULL,
0x000000f79000720bULL, 0x002fc80003fdd000ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000002b00f07306ULL, 0x000e620000005400ULL, 0x00000001b4b43812ULL, 0x000fcc00078efcffULL,
0x00000001dada6812ULL, 0x008fe200078efcffULL, 0x0000002b00ce7306ULL, 0x0004e2000000d400ULL,
0x000000eceb00720bULL, 0x000fce0003fdd000ULL, 0x0000001f00947306ULL, 0x000fe20000209400ULL,
0x000001002b2b7824ULL, 0x004fe200078e00ffULL, 0x000000f09100720bULL, 0x002fc80003fbd000ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000001f00957306ULL, 0x000fe20000205400ULL,
0x00000001d5d56812ULL, 0x000fcc00078efcffULL, 0x00000001cece5812ULL, 0x008fe200078efcffULL,
0x0000001f00dd7306ULL, 0x0003f0000020d400ULL, 0x0000002800c97306ULL, 0x000fe20000209400ULL,
0x00000018ff1f7819ULL, 0x002fce000001142cULL, 0x0000002800bc7306ULL, 0x000ff00000205400ULL,
0x00000028009c7306ULL, 0x0003f0000020d400ULL, 0x0000001f00df7306ULL, 0x000fe20000209400ULL,
0x0001000031287824ULL, 0x002fce00078e00ffULL, 0x0000001f00e07306ULL, 0x000e700000205400ULL,
0x0000001f00a17306ULL, 0x0004f0000020d400ULL, 0x0000001d00af7306ULL, 0x000fe20000209400ULL,
0x00010000301f7824ULL, 0x004fe200078e00ffULL, 0x000000e0df00720bULL, 0x002fcc0003fbd000ULL,
0x0000001d00b07306ULL, 0x000fee0000205400ULL, 0x00000001a1a15812ULL, 0x008fe200078efcffULL,
0x0000001d00127306ULL, 0x000ff0000020d400ULL, 0x00000074001c7306ULL, 0x000ff00000209400ULL,
0x00000074001d7306ULL, 0x000ff00000205400ULL, 0x00000074001e7306ULL, 0x0003f0000020d400ULL,
0x0000002900c07306ULL, 0x000fe20000209400ULL, 0x00000018ff747819ULL, 0x002fe20000011428ULL,
0x0000001072287824ULL, 0x000fcc00078e0271ULL, 0x0000002900f37306ULL, 0x000e700000205400ULL,
0x0000002900e67306ULL, 0x0004f0000020d400ULL, 0x0000002a00ee7306ULL, 0x000fe20000209400ULL,
0x00000018ff297819ULL, 0x004fc4000001142dULL, 0x000000f3c000720bULL, 0x002fca0003f3d000ULL,
0x0000002a00ef7306ULL, 0x000ff00000205400ULL, 0x0000002a00dc7306ULL, 0x0003e2000020d400ULL,
0x00000001e6e61812ULL, 0x008fc800078efcffULL, 0x000000e66b6b723eULL, 0x000fc600000010ffULL,
0x0000002b00e97306ULL, 0x000fe20000209400ULL, 0x00000018ff2a7819ULL, 0x002fce000001142fULL,
0x0000002b00ea7306ULL, 0x000ff00000205400ULL, 0x0000002b00d37306ULL, 0x0003f0000020d400ULL,
0x0000002900d47306ULL, 0x000fe20000209400ULL, 0x00000018ff2b7819ULL, 0x002fce000001141fULL,
0x0000002900b77306ULL, 0x000ff00000205400ULL, 0x00000029009b7306ULL, 0x000ff0000020d400ULL,
0x0000002a00cb7306ULL, 0x000ff00000209400ULL, 0x0000002a00ca7306ULL, 0x000ff00000205400ULL,
0x0000002a009d7306ULL, 0x000ff0000020d400ULL, 0x0000002b00b97306ULL, 0x000ff00000209400ULL,
0x0000002b00ba7306ULL, 0x000ff00000205400ULL, 0x0000002b008d7306ULL, 0x0003f0000020d400ULL,
0x0000003000b67306ULL, 0x000fe20000009400ULL, 0x000000002828783bULL, 0x002e6e0000000200ULL,
0x0000003000b57306ULL, 0x000ff00000005400ULL, 0x00000030008c7306ULL, 0x0005f0000000d400ULL,
0x0000007000be7306ULL, 0x000fe20000209400ULL, 0x0000010030307824ULL, 0x004fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000007000f17306ULL, 0x000eb00000205400ULL,
0x0000003000b37306ULL, 0x000fe20000209400ULL, 0x0001000028a27824ULL, 0x002fca00078e00ffULL,
0x00000018ffeb7819ULL, 0x000fe400000114a2ULL, 0x0000003000b27306ULL, 0x000fe20000205400ULL,
0x000000f1be00720bULL, 0x004fce0003f5d000ULL, 0x00000030001f7306ULL, 0x0003f0000020d400ULL,
0x0000003100ab7306ULL, 0x000fe20000009400ULL, 0x0001000032307824ULL, 0x002fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003100a97306ULL, 0x000ff00000005400ULL,
0x00000031000f7306ULL, 0x0003f0000000d400ULL, 0x0000007000a37306ULL, 0x000ea2000020d400ULL,
0x0000010031317824ULL, 0x002fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000030008e7306ULL, 0x000ff00000209400ULL, 0x00000030008f7306ULL, 0x000fe20000205400ULL,
0x00000001a3a32812ULL, 0x004fc400078efcffULL, 0x000000959400720bULL, 0x000fe40003f5d000ULL,
0x0000006aa36a723eULL, 0x000fc600000010ffULL, 0x0000003000727306ULL, 0x0003f0000020d400ULL,
0x0000002c009e7306ULL, 0x000fe20000009400ULL, 0x00000018ff307819ULL, 0x002fe40000011428ULL,
0x00000001dddd2812ULL, 0x000fc400078efcffULL, 0x000000efee00720bULL, 0x000fc60003f5d000ULL,
0x00000030007b7306ULL, 0x000ff00000209400ULL, 0x00000030007c7306ULL, 0x000fe40000205400ULL,
0x00000001dcdc2812ULL, 0x000fc400078efcffULL, 0x000000eae900720bULL, 0x000fc80003f5d000ULL,
0x0000003000787306ULL, 0x0003f0000020d400ULL, 0x0000002c00977306ULL, 0x000ea20000005400ULL,
0x000100002c307824ULL, 0x002fe200078e00ffULL, 0x00000001d3d32812ULL, 0x000fc800078efcffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000002c00a07306ULL, 0x0002f0000000d400ULL,
0x0000003100a77306ULL, 0x000fe20000209400ULL, 0x000001002c2c7824ULL, 0x002fe200078e00ffULL,
0x000000979e00720bULL, 0x004fc80003f3d000ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000003100a87306ULL, 0x000fee0000205400ULL, 0x00000001a0a01812ULL, 0x008fe200078efcffULL,
0x0000003100717306ULL, 0x0003e2000020d400ULL, 0x000000b7d400720bULL, 0x000fce0003f3d000ULL,
0x0000002c00e47306ULL, 0x000fe20000209400ULL, 0x00000018ff317819ULL, 0x002fca0000011476ULL,
0x000000019b9b1812ULL, 0x000fe400078efcffULL, 0x0000003100767306ULL, 0x000ff00000209400ULL,
0x0000003100777306ULL, 0x000ff00000205400ULL, 0x0000003100887306ULL, 0x0003f0000020d400ULL,
0x0000002c00e57306ULL, 0x000ea20000205400ULL, 0x00000018ff317819ULL, 0x002fce000001142aULL,
0x0000003100857306ULL, 0x000ff00000209400ULL, 0x0000003100867306ULL, 0x000fe20000205400ULL,
0x000000e5e400720bULL, 0x004fce0003f5d000ULL, 0x00000031007f7306ULL, 0x0003f0000020d400ULL,
0x0000002c00c87306ULL, 0x0004e2000020d400ULL, 0x000100002d317824ULL, 0x002fca00078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000002d00997306ULL, 0x000fe20000009400ULL,
0x000001002e2c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000002d00987306ULL, 0x000e620000005400ULL, 0x00000001c8c82812ULL, 0x008fc800078efcffULL,
0x000000c8a1a1723eULL, 0x000fc600000010ffULL, 0x0000002d009a7306ULL, 0x0004f0000000d400ULL,
0x0000003000e77306ULL, 0x000fe20000209400ULL, 0x000001002d2d7824ULL, 0x004fe200078e00ffULL,
0x000000989900720bULL, 0x002fc80003f9d000ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000003000e87306ULL, 0x000e6e0000205400ULL, 0x000000019a9a4812ULL, 0x008fe200078efcffULL,
0x0000003000bd7306ULL, 0x0004e2000020d400ULL, 0x000000cacb00720bULL, 0x000fce0003f9d000ULL,
0x0000002c00cf7306ULL, 0x000fe20000209400ULL, 0x000100002e307824ULL, 0x004fe200078e00ffULL,
0x000000e8e700720bULL, 0x002fc80003fdd000ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000002c00d07306ULL, 0x000fe20000205400ULL, 0x000000019d9d4812ULL, 0x000fcc00078efcffULL,
0x00000001bdbd6812ULL, 0x008fe200078efcffULL, 0x0000002c00c17306ULL, 0x0003e6000020d400ULL,
0x000000a0bda0723eULL, 0x000fca00000010ffULL, 0x0000002e00e37306ULL, 0x000fe20000009400ULL,
0x000100002f2c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000002e00a67306ULL, 0x000e700000005400ULL, 0x0000002d00d67306ULL, 0x000ff00000209400ULL,
0x0000002d00d77306ULL, 0x000ea20000205400ULL, 0x000000a6e300720bULL, 0x002fce0003f1d000ULL,
0x0000002d00c67306ULL, 0x0002f0000020d400ULL, 0x0000002e00b87306ULL, 0x0008e2000000d400ULL,
0x00000004ff2d7819ULL, 0x002fe40000011603ULL, 0x000000d7d600720bULL, 0x004fc60003f5d000ULL,
0x000000020ec47824ULL, 0x040fe200078e022dULL, 0x000000020e0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000002c00cc7306ULL, 0x000fe20000209400ULL, 0x00000008032e7812ULL, 0x010fc800078ec0ffULL,
0x000000072ec37812ULL, 0x000fc600078ef803ULL, 0x0000002c00cd7306ULL, 0x000e620000205400ULL,
0x00000010c3be7812ULL, 0x040fe200078efcffULL, 0x00000010c32d7824ULL, 0x000fe200078e00ffULL,
0x00000001c6c62812ULL, 0x008fe400078efcffULL, 0x000000d0cf00720bULL, 0x000fe20003f5d000ULL,
0x00000010be2e7824ULL, 0x000fe200078e00ffULL, 0x00000001b8b80812ULL, 0x000fe200078efcffULL,
0x0000002c00c27306ULL, 0x0004e2000020d400ULL, 0x000000bab900720bULL, 0x000fe40003f1d000ULL,
0x000000c69b9b723eULL, 0x000fca00000010ffULL, 0x0000003200ad7306ULL, 0x000fe20000009400ULL,
0x00000001c32c7824ULL, 0x004fe200078e02c4ULL, 0x000000cdcc00720bULL, 0x002fe40003f3d000ULL,
0x00000001c1c12812ULL, 0x000fe400078efcffULL, 0xfffffff02d2c7812ULL, 0x000fe200078ee22cULL,
0x00000001be2d7824ULL, 0x000fe200078e02c4ULL, 0x0000003200ac7306ULL, 0x000e620000005400ULL,
0x000000b2b300720bULL, 0x000fe40003f5d000ULL, 0x000000018d8d0812ULL, 0x000fc400078efcffULL,
0xfffffff02e2d7812ULL, 0x000fe400078ee22dULL, 0x00000001c2c21812ULL, 0x008fe200078efcffULL,
0x0000003200107306ULL, 0x0004e2000000d400ULL, 0x000000b5b600720bULL, 0x000fe20003f3d000ULL,
0x000000102d2d7824ULL, 0x000fe200078e00ffULL, 0x00000002c4c47810ULL, 0x000fc60007ffe0ffULL,
0x000000011f1f2812ULL, 0x000fe400078efcffULL, 0x0000003300aa7306ULL, 0x000fe20000009400ULL,
0x0000010032327824ULL, 0x004fe200078e00ffULL, 0x0000008b8a00720bULL, 0x000fe40003f5d000ULL,
0x000000acad00720bULL, 0x002fe40003f9d000ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000003300ae7306ULL, 0x000fe20000005400ULL, 0x000000018c8c1812ULL, 0x000fc400078efcffULL,
0x000000a8a700720bULL, 0x000fe40003f3d000ULL, 0x0000008c8d8c723eULL, 0x000fe400000010ffULL,
0x0000000113132812ULL, 0x000fe200078efcffULL, 0x0000003300117306ULL, 0x0003e2000000d400ULL,
0x0000000110104812ULL, 0x008fce00078efcffULL, 0x0000007400a47306ULL, 0x000fe20000209400ULL,
0x0000010033337824ULL, 0x002fe200078e00ffULL, 0x0000000171711812ULL, 0x000fe400078efcffULL,
0x0000001d1c00720bULL, 0x000fe40003f3d000ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000007400a57306ULL, 0x000e620000205400ULL, 0x000000711371723eULL, 0x000fce00000010ffULL,
0x0000007400707306ULL, 0x000ea2000020d400ULL, 0x000000011e1e1812ULL, 0x000fce00078efcffULL,
0x0000003200737306ULL, 0x000fe20000209400ULL, 0x000000a5a400720bULL, 0x002fce0003f1d000ULL,
0x0000003200747306ULL, 0x000fec0000205400ULL, 0x0000000170700812ULL, 0x004fe400078efcffULL,
0x0000003200757306ULL, 0x0003e2000020d400ULL, 0x000000171400720bULL, 0x000fce0003f1d000ULL,
0x0000003300897306ULL, 0x000fe20000209400ULL, 0x00000018ff327819ULL, 0x002fca0000011429ULL,
0x0000000118180812ULL, 0x000fe400078efcffULL, 0x00000033007d7306ULL, 0x000ff00000205400ULL,
0x00000033007a7306ULL, 0x0003f0000020d400ULL, 0x0000003000d87306ULL, 0x000fe20000209400ULL,
0x00000018ff337819ULL, 0x002fce000001142bULL, 0x0000003000d97306ULL, 0x000e700000205400ULL,
0x0000003000c57306ULL, 0x0004f0000020d400ULL, 0x0000002f00e17306ULL, 0x000fe20000009400ULL,
0x000000102c307824ULL, 0x004fe200078e00ffULL, 0x000000d9d800720bULL, 0x002fcc0003fbd000ULL,
0x0000002f00e27306ULL, 0x000e6e0000005400ULL, 0x00000001c5c55812ULL, 0x008fe200078efcffULL,
0x0000002f00bf7306ULL, 0x0004f0000000d400ULL, 0x0000003100db7306ULL, 0x000fe20000209400ULL,
0x000001002f2f7824ULL, 0x004fe200078e00ffULL, 0x000000e2e100720bULL, 0x002fc80003f7d000ULL,
0x00000018fff07819ULL, 0x000fe4000001142fULL, 0x0000003100de7306ULL, 0x000e620000205400ULL,
0x000000002d2c783bULL, 0x000eac0000000200ULL, 0x00000001bfbf3812ULL, 0x008fe200078efcffULL,
0x0000003200797306ULL, 0x000fe20000209400ULL, 0x000000a9ab00720bULL, 0x000fce0003f7d000ULL,
0x0000003200877306ULL, 0x000fe20000205400ULL, 0x000000dedb00720bULL, 0x002fca0003fdd000ULL,
0x000000010f0f3812ULL, 0x000fe400078efcffULL, 0x0000003200807306ULL, 0x000fe2000020d400ULL,
0x000000747300720bULL, 0x000fe40003f7d000ULL, 0x0000000f7070723eULL, 0x000fca00000010ffULL,
0x0000003300817306ULL, 0x000fec0000209400ULL, 0x0000000175753812ULL, 0x000fe400078efcffULL,
0x0000003300847306ULL, 0x000fe20000205400ULL, 0x000000682c60723cULL, 0x004f620000041860ULL,
0x0000007d8900720bULL, 0x000fc40003f7d000ULL, 0x000000751873723eULL, 0x000fc800000010ffULL,
0x00000033007e7306ULL, 0x000fe2000020d400ULL, 0x0000006a2c58723cULL, 0x040f6c0000041858ULL,
0x000000017a7a3812ULL, 0x000fe200078efcffULL, 0x0000003100c77306ULL, 0x0002a2000020d400ULL,
0x000000a02c38723cULL, 0x000fe40000041838ULL, 0x0000007a1e89723eULL, 0x000fca00000010ffULL,
0x000000f000d17306ULL, 0x000fe20000209400ULL, 0x000000003030783bULL, 0x002e6e0000000200ULL,
0x000000f000d27306ULL, 0x000ee20000205400ULL, 0x00000001c7c76812ULL, 0x004fe400078efcffULL,
0x000000bcc900720bULL, 0x000fc40003fdd000ULL, 0x0000009ac79a723eULL, 0x000fc600000010ffULL,
0x000000f000c07306ULL, 0x000ea8000020d400ULL, 0x0000009a2c34723cULL, 0x000fe20000041834ULL,
0x000000d2d100720bULL, 0x008fc60003fbd000ULL, 0x0000002800907306ULL, 0x000fe20000009400ULL,
0x000000019c9c6812ULL, 0x000fe400078efcffULL, 0x000000b0af00720bULL, 0x000fca0003fdd000ULL,
0x0000002800917306ULL, 0x000ee40000005400ULL, 0x00000001c0c05812ULL, 0x004fe400078efcffULL,
0x000000aeaa00720bULL, 0x000fc80003fbd000ULL, 0x0000002800927306ULL, 0x000522000000d400ULL,
0x000000683064723cULL, 0x042be20000041864ULL, 0x000000c09d9d723eULL, 0x000fe400000010ffULL,
0x0000000112126812ULL, 0x000fe400078efcffULL, 0x0000008f8e00720bULL, 0x000fe40003fdd000ULL,
0x000000dadd68723eULL, 0x020fe200000010ffULL, 0x0000010028287824ULL, 0x004fe200078e00ffULL,
0x000000dcb169723eULL, 0x000fe200000010ffULL, 0x0000006a305c723cULL, 0x000be2000004185cULL,
0x0000002900937306ULL, 0x000fe20000009400ULL, 0x0000000111115812ULL, 0x000fc400078efcffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x000000919000720bULL, 0x008fe40003f5d000ULL,
0x000000683054723cULL, 0x000fe20000041854ULL, 0x0000002900947306ULL, 0x000e620000005400ULL,
0x000000d3b46b723eULL, 0x020fe400000010ffULL, 0x000000ced56a723eULL, 0x000fe400000010ffULL,
0x0000000172726812ULL, 0x000fc400078efcffULL, 0x000000682c50723cULL, 0x000b620000041850ULL,
0x0000002900957306ULL, 0x0005e2000000d400ULL, 0x000000777600720bULL, 0x000fe40003fdd000ULL,
0x0000007c7b00720bULL, 0x000fe40003fbd000ULL, 0x0000001f128d723eULL, 0x000fe200000010ffULL,
0x0001000029687824ULL, 0x060fe200078e00ffULL, 0x0000006a304c723cULL, 0x000fe2000004184cULL,
0x0000010029697824ULL, 0x000fe200078e00ffULL, 0x0000002800b17306ULL, 0x000fe20000209400ULL,
0x000000c19c29723eULL, 0x004fc400000010ffULL, 0x000000bfc29c723eULL, 0x000fe400000010ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x000000a03044723cULL, 0x040fe20000041844ULL,
0x000000107272723eULL, 0x000fe200000010ffULL, 0x0000002800b77306ULL, 0x000ea20000205400ULL,
0x0000000188886812ULL, 0x000fe400078efcffULL, 0x0000000192922812ULL, 0x010fe400078efcffULL,
0x0000000178785812ULL, 0x000fe200078efcffULL, 0x0000009a3040723cULL, 0x000be20000041840ULL,
0x000000949300720bULL, 0x002fe20003f9d000ULL, 0x0000002800b47306ULL, 0x0002e2000020d400ULL,
0x000000118888723eULL, 0x000fc800000010ffULL, 0x000100002b9a7824ULL, 0x020fe200078e00ffULL,
0x0000009c306c723cULL, 0x000fe4000004186cULL, 0x000000eb00a27306ULL, 0x000fe20000209400ULL,
0x000000b8c528723eULL, 0x002fe400000010ffULL, 0x00000018ffc57819ULL, 0x000fe20000011469ULL,
0x00000010be697824ULL, 0x000fe200078e00ffULL, 0x000000b7b100720bULL, 0x004fe20003f7d000ULL,
0x0000006a2c48723cULL, 0x000b620000041848ULL, 0x00000018ff9a7819ULL, 0x000fe2000001149aULL,
0x000000eb00a37306ULL, 0x000e620000205400ULL, 0x0000000195954812ULL, 0x000fc400078efcffULL,
0x000000848100720bULL, 0x000fe40003f9d000ULL, 0x00000010c36a7824ULL, 0x060fe200078e00ffULL,
0x00000028303c723cULL, 0x080b62000004183cULL, 0x00000001c3c37824ULL, 0x100fe200078e02c4ULL,
0x0000006800bc7306ULL, 0x000fe20000209400ULL, 0x00000001bec47824ULL, 0x000fe200078e02c4ULL,
0x00000001b4b43812ULL, 0x008fe400078efcffULL, 0xfffffff06ac37812ULL, 0x000fe200078ee2c3ULL,
0x000100002a317824ULL, 0x020fe200078e00ffULL, 0xfffffff069c47812ULL, 0x000fe200078ee2c4ULL,
0x000000282c20723cULL, 0x000b620000041820ULL, 0x0000006800bd7306ULL, 0x000ea20000205400ULL,
0x000000a3a200720bULL, 0x002fc40003fdd000ULL, 0x00000018ffb57819ULL, 0x000fe20000011431ULL,
0x00000010c4307824ULL, 0x000fe200078e00ffULL, 0x000000877900720bULL, 0x000fe40003f7d000ULL,
0x0000009c2c24723cULL, 0x000f620000041824ULL, 0x000000c500c17306ULL, 0x000fe20000209400ULL,
0x000000017e7e4812ULL, 0x000fe200078efcffULL, 0x000000003030783bULL, 0x000e620000000200ULL,
0x000000b47893723eULL, 0x000fca00000010ffULL, 0x000000c500be7306ULL, 0x000ee20000205400ULL,
0x000000bdbc00720bULL, 0x004fe40003f3d000ULL, 0x0000000180803812ULL, 0x000fca00078efcffULL,
0x000000b500a07306ULL, 0x000ff00000209400ULL, 0x000000b5009b7306ULL, 0x000ea20000205400ULL,
0x000000bec100720bULL, 0x008fce0003f5d000ULL, 0x0000002a00967306ULL, 0x000ff00000009400ULL,
0x0000002a00977306ULL, 0x000ee20000005400ULL, 0x0000009ba000720bULL, 0x004fe20003fbd000ULL,
0x0000008c3060723cULL, 0x042b6c0000041860ULL, 0x0000002a00987306ULL, 0x0002a4000000d400ULL,
0x000000703058723cULL, 0x040b6c0000041858ULL, 0x0000002b00997306ULL, 0x000fe20000009400ULL,
0x000001002a2a7824ULL, 0x002fe200078e00ffULL, 0x000000979600720bULL, 0x008fe20003f1d000ULL,
0x000000723050723cULL, 0x000b660000041850ULL, 0x00000018ff2a7819ULL, 0x000fc4000001142aULL,
0x0000002b009e7306ULL, 0x000fe60000005400ULL, 0x000000883048723cULL, 0x000b680000041848ULL,
0x0000000198980812ULL, 0x004fe200078efcffULL, 0x0000002b009f7306ULL, 0x0003e2000000d400ULL,
0x000000080e00780cULL, 0x000fce0003f05270ULL, 0x0000006800b87306ULL, 0x0004e2000020d400ULL,
0x000001002b2b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x000000eb00a67306ULL, 0x000e62000020d400ULL, 0x00000010c3687824ULL, 0x004fcc00078e00ffULL,
0x000000006868783bULL, 0x000ea20000000200ULL, 0x000000c500bf7306ULL, 0x000f22000020d400ULL,
0x00000001b8b81812ULL, 0x008fe400078efcffULL, 0x000000868500720bULL, 0x000fe40003f3d000ULL,
0x00000095b8b8723eULL, 0x000fc600000010ffULL, 0x000000b500297306ULL, 0x020ee2000020d400ULL,
0x00000001a6a66812ULL, 0x002fe400078efcffULL, 0x0000009e9900720bULL, 0x000fe40003fdd000ULL,
0x00000092a692723eULL, 0x000fc600000010ffULL, 0x0000002a00127306ULL, 0x000fe20000209400ULL,
0x00000001bfbf2812ULL, 0x010fe400078efcffULL, 0x000000017f7f1812ULL, 0x000fe200078efcffULL,
0x000000923038723cULL, 0x000b620000041838ULL, 0x000000bf80b9723eULL, 0x000fc600000010ffULL,
0x0000002a00177306ULL, 0x000e620000205400ULL, 0x0000000129295812ULL, 0x008fe400078efcffULL,
0x000000019f9f6812ULL, 0x000fe200078efcffULL, 0x000000b83034723cULL, 0x000b620000041834ULL,
0x000000982998723eULL, 0x000fc600000010ffULL, 0x0000009a000f7306ULL, 0x000fe80000209400ULL,
0x0000008c6864723cULL, 0x004b680000041864ULL, 0x0000009a00107306ULL, 0x000ea20000205400ULL,
0x000000171200720bULL, 0x002fc60003f5d000ULL, 0x00000070685c723cULL, 0x040b68000004185cULL,
0x0000002b00137306ULL, 0x000fe80000209400ULL, 0x000000726854723cULL, 0x000b680000041854ULL,
0x0000002b00187306ULL, 0x000e620000205400ULL, 0x000000100f00720bULL, 0x004fc60003f7d000ULL,
0x00000088684c723cULL, 0x040b68000004184cULL, 0x0000002a00147306ULL, 0x000ea8000020d400ULL,
0x000000926844723cULL, 0x000b680000041844ULL, 0x0000009a009a7306ULL, 0x000ee2000020d400ULL,
0x000000181300720bULL, 0x002fc60003fbd000ULL, 0x000000b86840723cULL, 0x000b680000041840ULL,
0x0000002b009b7306ULL, 0x000e62000020d400ULL, 0x0000000114142812ULL, 0x004fc800078efcffULL,
0x000000147f99723eULL, 0x000fe400000010ffULL, 0x000000019a9a3812ULL, 0x008fc800078efcffULL,
0x0000009f9a9a723eULL, 0x000fe200000010ffULL, 0x00000098683c723cULL, 0x000b62000004183cULL,
0x000000019b9b5812ULL, 0x002fc800078efcffULL, 0x0000009b7e9b723eULL, 0x000fc600000010ffULL,
0x000000983020723cULL, 0x000b700000041820ULL, 0x0000009a686c723cULL, 0x080b70000004186cULL,
0x0000009a3024723cULL, 0x000b620000041824ULL, 0x0000001000008944ULL, 0x000fe20003c00000ULL,
0xffffdf5000007947ULL, 0x000fcc000383ffffULL, 0x0000000654547220ULL, 0x0a0fe40000410000ULL,
0x000000064d4d7220ULL, 0x000fc40000410000ULL, 0x0000000646467220ULL, 0x080fe40000410000ULL,
0x0000000640407220ULL, 0x080fe40000410000ULL, 0x000000063c3c7220ULL, 0x080fe40000410000ULL,
0x000000063d3d7220ULL, 0x080fe40000410000ULL, 0x0000000664647220ULL, 0x080fe40000410000ULL,
0x0000000665657220ULL, 0x000fc40000410000ULL, 0x0000000666667220ULL, 0x080fe40000410000ULL,
0x0000000667677220ULL, 0x080fe40000410000ULL, 0x000000065c5c7220ULL, 0x080fe40000410000ULL,
0x000000065d5d7220ULL, 0x080fe40000410000ULL, 0x000000065e5e7220ULL, 0x080fe40000410000ULL,
0x000000065f5f7220ULL, 0x000fc40000410000ULL, 0x00000006550b7220ULL, 0x080fe40000410000ULL,
0x00000006560e7220ULL, 0x080fe40000410000ULL, 0x00000006570f7220ULL, 0x080fe40000410000ULL,
0x000000064e107220ULL, 0x080fe40000410000ULL, 0x000000064f117220ULL, 0x080fe40000410000ULL,
0x0000000647127220ULL, 0x000fc40000410000ULL, 0x0000000642137220ULL, 0x080fe40000410000ULL,
0x000000063f147220ULL, 0x080fe40000410000ULL, 0x000000066c6c7220ULL, 0x080fe40000410000ULL,
0x000000066d6d7220ULL, 0x080fe40000410000ULL, 0x000000066e6e7220ULL, 0x080fe40000410000ULL,
0x000000066f6f7220ULL, 0x000fc40000410000ULL, 0x00000006502c7220ULL, 0x080fe40000410000ULL,
0x000000064c577220ULL, 0x080fe40000410000ULL, 0x000000ffff507224ULL, 0x000fe400078e0054ULL,
0x0000000644567220ULL, 0x080fe40000410000ULL, 0x00000006454e7220ULL, 0x080fe40000410000ULL,
0x00000006414c7220ULL, 0x000fc40000410000ULL, 0x0000000660297220ULL, 0x080fe40000410000ULL,
0x0000000661287220ULL, 0x080fe40000410000ULL, 0x000000064a1c7220ULL, 0x080fe40000410000ULL,
0x000000064b1f7220ULL, 0x080fe40000410000ULL, 0x000000ffff547224ULL, 0x000fe400078e004dULL,
0x0000000643457220ULL, 0x000fc40000410000ULL, 0x000000063e447220ULL, 0x080fe40000410000ULL,
0x00000006512d7220ULL, 0x080fe40000410000ULL, 0x0000000652177220ULL, 0x080fe40000410000ULL,
0x0000000653187220ULL, 0x080fe40000410000ULL, 0x00000006482e7220ULL, 0x080fe40000410000ULL,
0x00000006492f7220ULL, 0x000fc40000410000ULL, 0x0000000638307220ULL, 0x080fe40000410000ULL,
0x0000000639317220ULL, 0x080fe40000410000ULL, 0x000000063a1d7220ULL, 0x080fe40000410000ULL,
0x000000063b1e7220ULL, 0x080fe40000410000ULL, 0x0000000634327220ULL, 0x080fe40000410000ULL,
0x0000000635337220ULL, 0x000fc40000410000ULL, 0x0000000636607220ULL, 0x080fe40000410000ULL,
0x0000000637617220ULL, 0x000fe40000410000ULL, 0x000000ffff4d7224ULL, 0x000fe400078e0040ULL,
0x000000ffff4b7224ULL, 0x000fe400078e003cULL, 0x000000ffff4a7224ULL, 0x000fe400078e003dULL,
0x000000ffff417224ULL, 0x000fc400078e0046ULL, 0x0000000662627220ULL, 0x080fe40000410000ULL,
0x0000000663637220ULL, 0x080fe40000410000ULL, 0x00000006582a7220ULL, 0x080fe40000410000ULL,
0x00000006592b7220ULL, 0x080fe40000410000ULL, 0x000000065a5a7220ULL, 0x080fe40000410000ULL,
0x000000065b5b7220ULL, 0x000fc40000410000ULL, 0x0000000620387220ULL, 0x080fe40000410000ULL,
0x0000000621347220ULL, 0x080fe40000410000ULL, 0x0000000622687220ULL, 0x080fe40000410000ULL,
0x0000000623697220ULL, 0x080fe40000410000ULL, 0x0000000624357220ULL, 0x080fe40000410000ULL,
0x0000000625367220ULL, 0x000fc40000410000ULL, 0x00000006266a7220ULL, 0x080fe40000410000ULL,
0x00000006276b7220ULL, 0x000fe40000410000ULL, 0x000000ffff557224ULL, 0x000fe400078e0064ULL,
0x000000ffff537224ULL, 0x000fe400078e0065ULL, 0x000000ffff527224ULL, 0x000fe400078e005cULL,
0x000000ffff517224ULL, 0x000fc400078e005dULL, 0x000000ffff4f7224ULL, 0x000fe400078e000bULL,
0x000000ffff497224ULL, 0x000fe400078e006cULL, 0x000000ffff487224ULL, 0x000fe400078e006dULL,
0x000000ffff3e7224ULL, 0x000fe400078e0066ULL, 0x000000ffff3d7224ULL, 0x000fe400078e0067ULL,
0x000000ffff3c7224ULL, 0x000fc400078e005eULL, 0x000000ffff3b7224ULL, 0x000fe400078e005fULL,
0x000000ffff3f7224ULL, 0x000fe400078e000eULL, 0x000000ffff477224ULL, 0x000fe400078e000fULL,
0x000000ffff407224ULL, 0x000fe400078e0010ULL, 0x000000ffff427224ULL, 0x000fe400078e0011ULL,
0x000000ffff467224ULL, 0x000fc400078e0012ULL, 0x000000ffff437224ULL, 0x000fe400078e0013ULL,
0x000000ffff397224ULL, 0x000fe400078e0014ULL, 0x000000ffff3a7224ULL, 0x000fe400078e006eULL,
0x000000ffff377224ULL, 0x000fe200078e006fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000007587f8cULL, 0x0002a2000c80043fULL, 0x000000ffff237224ULL, 0x000fe400078e0017ULL,
0x000000ffff227224ULL, 0x000fc400078e0018ULL, 0x000000ffff217224ULL, 0x000fe400078e001cULL,
0x000000ffff207224ULL, 0x000fe400078e001dULL, 0x000000ffff267224ULL, 0x000fe400078e0062ULL,
0x000000ffff277224ULL, 0x000fe400078e0063ULL, 0x000000ffff247224ULL, 0x000fe400078e005aULL,
0x000000ffff257224ULL, 0x000fc400078e005bULL, 0x000000ffff0f7224ULL, 0x000fe400078e0060ULL,
0x000000ffff147224ULL, 0x000fe400078e0061ULL, 0x000000ffff177224ULL, 0x000fe400078e0068ULL,
0x000000ffff187224ULL, 0x000fe400078e0069ULL, 0x000000ffff1c7224ULL, 0x000fe400078e006aULL,
0x000000ffff1d7224ULL, 0x000fc400078e006bULL, 0x0000000000107805ULL, 0x006fca0000015200ULL,
0x00000400070b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc40007804859ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff5a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000105a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x00000012100e7210ULL, 0x000fca0007f1e1ffULL,
0x0000000113127824ULL, 0x000fe200000e0e11ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011412ULL,
0x0000000e0b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e0612ULL,
0x000000020b0b7819ULL, 0x000fc8000000120eULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000015a5a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400070b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004030e7824ULL, 0x000fe200078e00ffULL, 0x000000020a00720cULL, 0x000fc80003f06070ULL,
0xfffffff00e0b7812ULL, 0x000fca00078ec0ffULL, 0x000000801a0b7824ULL, 0x000fca00078e020bULL,
0x01a400000b107984ULL, 0x0002a20000000c00ULL, 0x000021f000008947ULL, 0x000fea0003800000ULL,
0x00005a00005b7b06ULL, 0x000ee20000209000ULL, 0x000000ffff587224ULL, 0x000fe200078e00ffULL,
0x00000019035a7211ULL, 0x000fe400078ff0ffULL, 0x00005a00ff677a12ULL, 0x000fe400078e33ffULL,
0x000000105a5e7810ULL, 0x000fe40007ffe0ffULL, 0x0000005b005b7308ULL, 0x008ee40000001000ULL,
0x0ffffffe5b5d7810ULL, 0x008fcc0007ffe0ffULL, 0x0000005d00597305ULL, 0x000ee4000021f000ULL,
0x000000ffff5f7224ULL, 0x008fc800078e0a59ULL, 0x00005a005f5f7a24ULL, 0x000fc800078e02ffULL,
0x0000005f595f7227ULL, 0x000fe200078e0058ULL, 0x000000085a597810ULL, 0x000fca0007ffe0ffULL,
0x0000005a5f587227ULL, 0x000fc800078e00ffULL, 0x000000595f5c7227ULL, 0x000fc800078e00ffULL,
0x000000ffff5b7224ULL, 0x000fe400078e0a58ULL, 0x000000ffff627224ULL, 0x000fe400078e0a5cULL,
0x0000005e5f607227ULL, 0x000fc800078e00ffULL, 0x00005a005b5b7a24ULL, 0x000fe200078e025aULL,
0x000000185a5a7810ULL, 0x000fe20007ffe0ffULL, 0x00005a00625d7a24ULL, 0x000fe400078e0259ULL,
0x000000ffff597224ULL, 0x000fe200078e0a60ULL, 0x00005a005b007a0cULL, 0x000fe20003f06070ULL,
0x0000005a5f657227ULL, 0x000fe200078e00ffULL, 0x00005a005d007a0cULL, 0x000fc60003fa6070ULL,
0x00005a00595e7a24ULL, 0x000fe200078e025eULL, 0xffffff000c597810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5f7224ULL, 0x000fc600078e0a65ULL, 0x00000059160c7217ULL, 0x000fe20007800000ULL,
0x00005a005f5a7a24ULL, 0x000fe200078e025aULL, 0x00005a005e007a0cULL, 0x000fe40003f26070ULL,
0x80005a005b5b0a10ULL, 0x000fe20007ffe0ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a59ULL,
0x00005a005a007a0cULL, 0x000fe20003f66070ULL, 0x0000000203597824ULL, 0x000fe200078e00ffULL,
0x00005a005b007a0cULL, 0x000fe40003f46070ULL, 0x80005a005d5d5a10ULL, 0x000fc40007ffe0ffULL,
0x0000000659597812ULL, 0x000fe400078ec0ffULL, 0x00005a005d007a0cULL, 0x000fe40003fc6070ULL,
0x0000000158580810ULL, 0x000fe20007ffe0ffULL, 0x00000001595b7824ULL, 0x000fe200078e0200ULL,
0x80005a005e5e1a10ULL, 0x000fe20007ffe0ffULL, 0x00000001095f7824ULL, 0x000fe200078e0259ULL,
0x000000015c5c5810ULL, 0x000fe20007ffe0ffULL, 0x000000015b5d7824ULL, 0x000fe200078e0a0cULL,
0x00005a00ff007a0cULL, 0x000fc40003fa5070ULL, 0x0000000158582810ULL, 0x000fe40007ffe0ffULL,
0x00005a005e007a0cULL, 0x000fe40003f86070ULL, 0x0000000c5f00720cULL, 0x040fe20003f06070ULL,
0x000000015f5f7824ULL, 0x000fe200078e0a0cULL, 0x80005a005a5a3a10ULL, 0x000fe40007ffe0ffULL,
0x0000005d08647217ULL, 0x000fe40003800000ULL, 0x00000058675d7207ULL, 0x000fc40006800000ULL,
0x00005a005a007a0cULL, 0x000fe40003f46070ULL, 0x0000005f085f7217ULL, 0x000fe40003800000ULL,
0x000000015c5c6810ULL, 0x000fe40007ffe0ffULL, 0x0000005d08587217ULL, 0x000fe40003800000ULL,
0x0000000c5b00720cULL, 0x000fe40003fc6070ULL, 0x0000000160601810ULL, 0x000fe20007ffe0ffULL,
0x0000005805857224ULL, 0x000fe200078e02ffULL, 0x00000004ff5f7819ULL, 0x000fc4000001165fULL,
0x0000005c67617207ULL, 0x000fe40006800000ULL, 0x000000ff64647207ULL, 0x000fe40003000000ULL,
0x0000000160604810ULL, 0x000fe40007ffe0ffULL, 0x000000ff5f627207ULL, 0x000fe40000000000ULL,
0x0000000165653810ULL, 0x000fe40007ffe0ffULL, 0x00000061085a7217ULL, 0x000fe20003800000ULL,
0x00000001855f7824ULL, 0x000fe200078e0262ULL, 0x0000006067637207ULL, 0x000fc40006800000ULL,
0x00000085645d7211ULL, 0x000fe200078fe0ffULL, 0x0000005a05897224ULL, 0x000fe200078e02ffULL,
0x0000000165652810ULL, 0x000fe20007ffe0ffULL, 0x000000025f5e7825ULL, 0x100fe200078e0082ULL,
0x00000063085a7217ULL, 0x040fe40003800000ULL, 0x0000006567657207ULL, 0x000fe20006800000ULL,
0x000000025d5c7825ULL, 0x000fe200078e0082ULL, 0x0000001059637812ULL, 0x000fe200078efcffULL,
0x000000065e587981ULL, 0x000722000c1e9500ULL, 0x0000006508667217ULL, 0x000fe20003800000ULL,
0x0000005a058b7224ULL, 0x000fc400078e02ffULL, 0x000000065c5d7981ULL, 0x000322000c1e9500ULL,
0x0000000162617824ULL, 0x000fe200078e0289ULL, 0x0000008964697211ULL, 0x040fe200078fe0ffULL,
0x00000066058d7224ULL, 0x000fe200078e02ffULL, 0x0000008b646b7211ULL, 0x000fe200078fe0ffULL,
0x00000001626d7824ULL, 0x000fe400078e028bULL, 0x0000000109737824ULL, 0x000fe400078e0263ULL,
0x0000000261607825ULL, 0x000fe200078e0082ULL, 0x0000008d64677211ULL, 0x000fc600078fe0ffULL,
0x0000000269687825ULL, 0x100fe200078e0082ULL, 0x00000006605a7981ULL, 0x000526000c1e9500ULL,
0x000000026d6c7825ULL, 0x100fe200078e0082ULL, 0x00000006685f7981ULL, 0x008726000c1e9500ULL,
0x000000026b6a7825ULL, 0x000fe200078e0082ULL, 0x000000066c5c7981ULL, 0x002326000c1e9500ULL,
0x0000000173717824ULL, 0x000fe200078e0a0cULL, 0x000000066a617981ULL, 0x004522000c1e9500ULL,
0x0000000163657824ULL, 0x000fc400078e0200ULL, 0x0000000267667825ULL, 0x000fe200078e0082ULL,
0x0000007108607217ULL, 0x000fc60003800000ULL, 0x0000000165717824ULL, 0x000fe200078e0a0cULL,
0x0000000c7300720cULL, 0x080fe20003f26070ULL, 0x00000001626f7824ULL, 0x000fe200078e028dULL,
0x00000004ff607819ULL, 0x000fe20000011660ULL, 0x0000000666677981ULL, 0x000322000c1e9500ULL,
0x0000000c6500720cULL, 0x000fe20003f06070ULL, 0x000000026f6e7825ULL, 0x000fe200078e0082ULL,
0x0000007108717217ULL, 0x000fc80003800000ULL, 0x000000ff71767207ULL, 0x000fe20000000000ULL,
0x000000066e5e7981ULL, 0x000522000c1e9500ULL, 0x000000ff60667207ULL, 0x002fe40000800000ULL,
0x0000002059777812ULL, 0x000fe400078efcffULL, 0x0000008576697211ULL, 0x008fe200078fe0ffULL,
0x00000001856b7824ULL, 0x004fe400078e0266ULL, 0x00000001666f7824ULL, 0x000fe200078e0289ULL,
0x00000089766d7211ULL, 0x000fe200078fe0ffULL, 0x00000001097f7824ULL, 0x000fc400078e0277ULL,
0x000000026f6e7825ULL, 0x000fc800078e0082ULL, 0x000000026b6a7825ULL, 0x100fe200078e0082ULL,
0x000000066e627981ULL, 0x0002a6000c1e9500ULL, 0x0000000269687825ULL, 0x100fe200078e0082ULL,
0x000000066a607981ULL, 0x0006a6000c1e9500ULL, 0x000000026d6c7825ULL, 0x000fe200078e0082ULL,
0x0000008b76717211ULL, 0x000fe200078fe0ffULL, 0x0000000668697981ULL, 0x0006a4000c1e9500ULL,
0x000000017f6f7824ULL, 0x002fc400078e0a0cULL, 0x0000000177797824ULL, 0x000fe200078e0200ULL,
0x000000066c6b7981ULL, 0x0082e2000c1e9500ULL, 0x0000008d767b7211ULL, 0x000fe400078fe0ffULL,
0x0000006f086a7217ULL, 0x000fe20003800000ULL, 0x00000001796f7824ULL, 0x000fe400078e0a0cULL,
0x0000000166737824ULL, 0x040fe400078e028bULL, 0x00000001667d7824ULL, 0x000fe400078e028dULL,
0x0000000271707825ULL, 0x000fe200078e0082ULL, 0x0000000c7f00720cULL, 0x000fc40003f26070ULL,
0x0000000c7900720cULL, 0x000fe20003f06070ULL, 0x000000027b7a7825ULL, 0x000fe200078e0082ULL,
0x00000004ff6a7819ULL, 0x000fe2000001166aULL, 0x0000000670757981ULL, 0x0002a2000c1e9500ULL,
0x0000006f086f7217ULL, 0x000fe20003800000ULL, 0x0000000273727825ULL, 0x100fe400078e0082ULL,
0x000000067a7b7981ULL, 0x0002a4000c1e9500ULL, 0x000000027d7c7825ULL, 0x000fe200078e0082ULL,
0x000000ff6f787207ULL, 0x000fe20000000000ULL, 0x0000000672667981ULL, 0x0002e4000c1e9500ULL,
0x000000ff6a707207ULL, 0x002fc40000800000ULL, 0x000000067c687981ULL, 0x0002e2000c1e9500ULL,
0x0000008978717211ULL, 0x000fe400078fe0ffULL, 0x00000001707f7824ULL, 0x000fe200078e0289ULL,
0x00000085786d7211ULL, 0x000fe200078fe0ffULL, 0x00000001856f7824ULL, 0x000fe400078e0270ULL,
0x0000000170737824ULL, 0x040fe400078e028bULL, 0x00000001708f7824ULL, 0x000fe400078e028dULL,
0x000000027f7e7825ULL, 0x000fc800078e0082ULL, 0x0000000271707825ULL, 0x100fe200078e0082ULL,
0x000000067e747981ULL, 0x0002e2000c1e9500ULL, 0x0000008d78877211ULL, 0x040fe400078fe0ffULL,
0x000000026d6c7825ULL, 0x100fe200078e0082ULL, 0x0000000670d17981ULL, 0x0002e2000c1e9500ULL,
0x0000003059b57812ULL, 0x000fe400078efcffULL, 0x000000026f6e7825ULL, 0x100fe200078e0082ULL,
0x0000008b787d7211ULL, 0x002fe200078fe0ffULL, 0x000000066c817981ULL, 0x0002e4000c1e9500ULL,
0x0000000273727825ULL, 0x000fc400078e0082ULL, 0x000000066e6a7981ULL, 0x0002e4000c1e9500ULL,
0x000000027d7c7825ULL, 0x100fe400078e0082ULL, 0x00000006728a7981ULL, 0x0002e4000c1e9500ULL,
0x00000002876c7825ULL, 0x002fe400078e0082ULL, 0x000000067cd57981ULL, 0x0002e4000c1e9500ULL,
0x0000000109877824ULL, 0x000fc400078e02b5ULL, 0x000000028f6e7825ULL, 0x000fe200078e0082ULL,
0x000000066cd97981ULL, 0x0002e6000c1e9500ULL, 0x00000001877f7824ULL, 0x000fe200078e0a0cULL,
0x000000066e8e7981ULL, 0x0002e2000c1e9500ULL, 0x00000001b5b77824ULL, 0x000fc600078e0200ULL,
0x0000007f087a7217ULL, 0x040fe20003800000ULL, 0x00000001b77f7824ULL, 0x000fe200078e0a0cULL,
0x0000000c8700720cULL, 0x080fe40003f26070ULL, 0x00000004ff7a7819ULL, 0x000fe4000001167aULL,
0x0000000cb700720cULL, 0x000fe40003f06070ULL, 0x0000007f087f7217ULL, 0x000fe40003800000ULL,
0x000000ff7a807207ULL, 0x000fc40000800000ULL, 0x000000ff7f7a7207ULL, 0x000fc60000000000ULL,
0x00000001857d7824ULL, 0x002fe200078e0280ULL, 0x000000857a7f7211ULL, 0x000fe200078fe0ffULL,
0x0000000180717824ULL, 0x000fe200078e028bULL, 0x0000008b7a737211ULL, 0x000fe200078fe0ffULL,
0x000000027d7c7825ULL, 0x000fc800078e0082ULL, 0x000000027f7e7825ULL, 0x100fe200078e0082ULL,
0x000000067c847981ULL, 0x0002e6000c1e9500ULL, 0x0000000271707825ULL, 0x100fe200078e0082ULL,
0x000000067eb97981ULL, 0x0002e6000c1e9500ULL, 0x0000000273727825ULL, 0x000fe200078e0082ULL,
0x00000006708c7981ULL, 0x0002e2000c1e9500ULL, 0x000000897a6f7211ULL, 0x000fc600078fe0ffULL,
0x0000000672d77981ULL, 0x0002e2000c1e9500ULL, 0x00000001806d7824ULL, 0x000fe400078e0289ULL,
0x000000026f6e7825ULL, 0x000fc800078e0082ULL, 0x000000026d6c7825ULL, 0x000fe200078e0082ULL,
0x000000066ed37981ULL, 0x0002e4000c1e9500ULL, 0x0000008d7a7d7211ULL, 0x002fe400078fe0ffULL,
0x000000066c887981ULL, 0x0002e2000c1e9500ULL, 0x00000001807f7824ULL, 0x000fe400078e028dULL,
0x000000027d7c7825ULL, 0x000fc800078e0082ULL, 0x000000027f7e7825ULL, 0x000fe200078e0082ULL,
0x000000067cdb7981ULL, 0x0002e8000c1e9500ULL, 0x000000067e907981ULL, 0x0002e4000c1e9500ULL,
0xfffffff0646d7812ULL, 0x002fe200078ec0ffULL, 0x00000001ffcf7424ULL, 0x000fc800078e00ffULL,
0x000000010c647824ULL, 0x000fe200078e026dULL, 0xfffffff0766d7812ULL, 0x000fc600078ec0ffULL,
0x000000015b6c7824ULL, 0x000fe200078e0a64ULL, 0x0000000159857812ULL, 0x000fe200078efcffULL,
0x000000010c727824ULL, 0x000fc600078e026dULL, 0x0000006ccf6d7219ULL, 0x000fe200000006ffULL,
0x00000001856f7824ULL, 0x000fe200078e0200ULL, 0xfffffff078717812ULL, 0x000fc600078ec0ffULL,
0x000000016f6e7824ULL, 0x000fe200078e0a64ULL, 0x0000000859877812ULL, 0x040fe200078efcffULL,
0x000000010c767824ULL, 0x000fe200078e0271ULL, 0x0000000959897812ULL, 0x000fe400078efcffULL,
0x0000006ecf717219ULL, 0x000fe200000006ffULL, 0x0000000187737824ULL, 0x100fe400078e0200ULL,
0x00000001897f7824ULL, 0x000fe200078e0200ULL, 0xfffffff07a7d7812ULL, 0x000fe200078ec0ffULL,
0x0000000173707824ULL, 0x000fc400078e0a64ULL, 0x000000017f647824ULL, 0x000fe200078e0a64ULL,
0x00000011598f7812ULL, 0x000fe200078efcffULL, 0x000000010c7c7824ULL, 0x000fe200078e027dULL,
0x00000070cf7d7219ULL, 0x040fe400000006ffULL, 0x00000064cf8b7219ULL, 0x000fe200000006ffULL,
0x000000018f917824ULL, 0x000fe400078e0200ULL, 0x0000000165647824ULL, 0x100fe400078e0a72ULL,
0x00000001916c7824ULL, 0x000fe200078e0a72ULL, 0x0000001859957812ULL, 0x000fc400078efcffULL,
0x00000019599b7812ULL, 0x000fe400078efcffULL, 0x000054105d587816ULL, 0x010fc80000000058ULL,
0x000000586dff7212ULL, 0x000fc800078ac0ffULL, 0x0000000c5b00720cULL, 0x000fc80002fa1470ULL,
0x0000000c5900720cULL, 0x000fe40002fa1070ULL, 0x0000005871ff7212ULL, 0x000fe4000782c0ffULL,
0x000054105f5a7816ULL, 0x000fe4000000005aULL, 0xff80000055557808ULL, 0x000fe40002800000ULL,
0x0000005a6dff7212ULL, 0x000fe4000784c0ffULL, 0x00005410615c7816ULL, 0x000fc4000000005cULL,
0x0000005a71ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005c6dff7212ULL, 0x000fe4000788c0ffULL,
0x0000000c5b00720cULL, 0x0c0fe40001741470ULL, 0x0000000c5b00720cULL, 0x080fe40002781470ULL,
0x0000000c6f00720cULL, 0x0c0fe40000f21470ULL, 0x0000000c6f00720cULL, 0x000fc40002fa1470ULL,
0x0000000c5900720cULL, 0x0c0fe40001741070ULL, 0x0000000c5900720cULL, 0x080fe40002781070ULL,
0x0000000c8500720cULL, 0x0c0fe40000f21070ULL, 0x0000000c8500720cULL, 0x000fe40002fa1070ULL,
0x00005410675e7816ULL, 0x000fe4000000005eULL, 0xff8000003e3e7808ULL, 0x000fc40001000000ULL,
0xff80000029297808ULL, 0x000fe40002000000ULL, 0xff80000053537808ULL, 0x000fe40000800000ULL,
0xff8000003d3d7808ULL, 0x000fe40002800000ULL, 0x000000587dff7212ULL, 0x000fe4000786c0ffULL,
0x0000005e6dff7212ULL, 0x000fe4000780c0ffULL, 0x0000005c71ff7212ULL, 0x000fc4000784c0ffULL,
0x0000005e71ff7212ULL, 0x000fe4000788c0ffULL, 0x0000005a8bff7212ULL, 0x000fe4000782c0ffULL,
0x0000005c7dff7212ULL, 0x000fe400078ac0ffULL, 0x0000000c5b00720cULL, 0x080fe40000701470ULL,
0x0000000c6f00720cULL, 0x0c0fe40001741470ULL, 0x0000000c6f00720cULL, 0x000fc40002781470ULL,
0x0000000c7300720cULL, 0x0c0fe40001f61470ULL, 0x0000000c7300720cULL, 0x080fe40002fa1470ULL,
0x0000000c7f00720cULL, 0x080fe40000f21470ULL, 0x0000000c5900720cULL, 0x080fe40000701070ULL,
0x0000000c8500720cULL, 0x0c0fe40001741070ULL, 0x0000000c8500720cULL, 0x000fc40002781070ULL,
0x0000000c8700720cULL, 0x0c0fe40001f61070ULL, 0x0000000c8700720cULL, 0x080fe40002fa1070ULL,
0x0000000c8900720cULL, 0x000fe40000f21070ULL, 0x00000064cf8d7219ULL, 0x040fe400000006ffULL,
0x0000006ccf937219ULL, 0x000fe400000006ffULL, 0x0000541069607816ULL, 0x004fc40000000060ULL,
0x000054106b627816ULL, 0x008fe20000000062ULL, 0x0000000195977824ULL, 0x100fe200078e0200ULL,
0xff80000026267808ULL, 0x000fe20000000000ULL, 0x000000019b9d7824ULL, 0x000fe200078e0200ULL,
0xff80000028287808ULL, 0x000fe40001000000ULL, 0xff80000027277808ULL, 0x000fe40002000000ULL,
0xff80000052527808ULL, 0x000fe40001800000ULL, 0xff8000002a2a7808ULL, 0x000fc40002800000ULL,
0xff8000003b3b7808ULL, 0x000fe40000800000ULL, 0x0000005a7dff7212ULL, 0x000fe4000780c0ffULL,
0x0000005c8bff7212ULL, 0x000fe4000784c0ffULL, 0x0000005e7dff7212ULL, 0x080fe4000788c0ffULL,
0x0000005e8bff7212ULL, 0x000fe4000786c0ffULL, 0x0000006093ff7212ULL, 0x000fc400078ac0ffULL,
0x000000628dff7212ULL, 0x000fe2000782c0ffULL, 0x00000001976e7824ULL, 0x100fe200078e0a72ULL,
0x0000000c7300720cULL, 0x080fe20000701470ULL, 0x000000019d727824ULL, 0x000fe200078e0a72ULL,
0x0000000c7300720cULL, 0x080fe40002781470ULL, 0x0000000c7f00720cULL, 0x0c0fe40001741470ULL,
0x0000000c7f00720cULL, 0x080fe40001f61470ULL, 0x0000000c6500720cULL, 0x000fc40000f21470ULL,
0x0000000c9100720cULL, 0x080fe40002fa1470ULL, 0x0000000c8700720cULL, 0x0c0fe40000701070ULL,
0x0000000c8700720cULL, 0x080fe40002781070ULL, 0x0000000c8900720cULL, 0x0c0fe40001741070ULL,
0x0000000c8900720cULL, 0x080fe40001f61070ULL, 0x0000000c6300720cULL, 0x000fc40000f21070ULL,
0x0000000c8f00720cULL, 0x000fe40002fa1070ULL, 0x0000006ecf997219ULL, 0x040fe400000006ffULL,
0x00000072cf9f7219ULL, 0x000fe400000006ffULL, 0x0000541075667816ULL, 0x000fe40000000066ULL,
0x000054107b687816ULL, 0x000fe40000000068ULL, 0xff8000003c3c7808ULL, 0x000fc40000000000ULL,
0xff80000024247808ULL, 0x000fe40002000000ULL, 0xff8000002b2b7808ULL, 0x000fe40001000000ULL,
0xff80000025257808ULL, 0x000fe40001800000ULL, 0xff8000003f3f7808ULL, 0x000fe40000800000ULL,
0xff8000004f4f7808ULL, 0x000fe40002800000ULL, 0x000000608dff7212ULL, 0x000fc4000780c0ffULL,
0x0000006099ff7212ULL, 0x000fe4000788c0ffULL, 0x000000668dff7212ULL, 0x040fe4000784c0ffULL,
0x000000688dff7212ULL, 0x000fe4000786c0ffULL, 0x0000006693ff7212ULL, 0x000fe4000782c0ffULL,
0x000000629fff7212ULL, 0x000fe200078ac0ffULL, 0x0000000179707824ULL, 0x000fe200078e0a76ULL,
0x0000000c6500720cULL, 0x000fc40000701470ULL, 0x0000000c6500720cULL, 0x0c0fe40001741470ULL,
0x0000000c6500720cULL, 0x080fe40001f61470ULL, 0x0000000c9100720cULL, 0x080fe40000f21470ULL,
0x0000000c9700720cULL, 0x080fe40002781470ULL, 0x0000000c9d00720cULL, 0x000fe40002fa1470ULL,
0x0000002159a37812ULL, 0x000fc400078efcffULL, 0x0000000c6300720cULL, 0x0c0fe40000701070ULL,
0x0000000c6300720cULL, 0x0c0fe40001741070ULL, 0x0000000c6300720cULL, 0x080fe40001f61070ULL,
0x0000000c8f00720cULL, 0x080fe40000f21070ULL, 0x0000000c9500720cULL, 0x080fe40002781070ULL,
0x0000000c9b00720cULL, 0x000fc40002fa1070ULL, 0x00000070cfa17219ULL, 0x000fe400000006ffULL,
0x00005410d1747816ULL, 0x000fe20000000074ULL, 0x00000001a3a57824ULL, 0x000fe200078e0200ULL,
0xff80000050507808ULL, 0x000fe40000000000ULL, 0xff8000002c2c7808ULL, 0x000fe40001000000ULL,
0xff80000023237808ULL, 0x000fe40001800000ULL, 0xff8000002d2d7808ULL, 0x000fc40000800000ULL,
0xff80000057577808ULL, 0x000fe40002000000ULL, 0xff80000042427808ULL, 0x000fe40002800000ULL,
0x0000006293ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006893ff7212ULL, 0x000fe4000784c0ffULL,
0x0000006299ff7212ULL, 0x000fe4000786c0ffULL, 0x000000669fff7212ULL, 0x000fc4000782c0ffULL,
0x000000689fff7212ULL, 0x000fe4000788c0ffULL, 0x00000074a1ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a5787824ULL, 0x000fe200078e0a76ULL, 0x0000000c9100720cULL, 0x0c0fe40000701470ULL,
0x0000000c9100720cULL, 0x080fe40001741470ULL, 0x0000000c9700720cULL, 0x080fe40001f61470ULL,
0x0000000c9d00720cULL, 0x000fc40000f21470ULL, 0x0000000c9d00720cULL, 0x080fe40002781470ULL,
0x0000000c7900720cULL, 0x080fe40002fa1470ULL, 0x0000002859a97812ULL, 0x040fe400078efcffULL,
0x0000002959af7812ULL, 0x000fe400078efcffULL, 0x0000000c8f00720cULL, 0x0c0fe40000701070ULL,
0x0000000c8f00720cULL, 0x000fc40001741070ULL, 0x0000000c9500720cULL, 0x080fe40001f61070ULL,
0x0000000c9b00720cULL, 0x0c0fe40000f21070ULL, 0x0000000c9b00720cULL, 0x080fe40002781070ULL,
0x0000000c7700720cULL, 0x000fe40002fa1070ULL, 0x00000078cfa77219ULL, 0x000fe400000006ffULL,
0x00005410816a7816ULL, 0x000fc4000000006aULL, 0x00005410d58a7816ULL, 0x000fe4000000008aULL,
0x00005410d98e7816ULL, 0x000fe2000000008eULL, 0x00000001a9ab7824ULL, 0x100fe200078e0200ULL,
0xff80000047477808ULL, 0x000fe20000000000ULL, 0x00000001afb17824ULL, 0x000fe200078e0200ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff80000040407808ULL, 0x000fe40001800000ULL,
0xff8000002f2f7808ULL, 0x000fc40000800000ULL, 0xff8000001f1f7808ULL, 0x000fe40002000000ULL,
0xff80000041417808ULL, 0x000fe40002800000ULL, 0x000000588bff7212ULL, 0x000fe400078cc0ffULL,
0x0000006699ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006899ff7212ULL, 0x000fe4000784c0ffULL,
0x0000006aa1ff7212ULL, 0x000fc4000786c0ffULL, 0x0000008aa1ff7212ULL, 0x040fe4000782c0ffULL,
0x0000008ea1ff7212ULL, 0x000fe4000788c0ffULL, 0x0000008aa7ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001ab7a7824ULL, 0x100fe200078e0a76ULL, 0x0000000c7f00720cULL, 0x080fe200037c1470ULL,
0x00000001b1767824ULL, 0x000fe200078e0a76ULL, 0x0000000c9700720cULL, 0x0c0fe40000701470ULL,
0x0000000c9700720cULL, 0x000fc40001741470ULL, 0x0000000c7900720cULL, 0x0c0fe40001f61470ULL,
0x0000000c7900720cULL, 0x0c0fe40000f21470ULL, 0x0000000c7900720cULL, 0x080fe40002781470ULL,
0x0000000ca500720cULL, 0x080fe40002fa1470ULL, 0x0000000c8900720cULL, 0x080fe400037c1070ULL,
0x0000000c9500720cULL, 0x000fc40000701070ULL, 0x0000000c9500720cULL, 0x080fe40001741070ULL,
0x0000000c7700720cULL, 0x0c0fe40001f61070ULL, 0x0000000c7700720cULL, 0x0c0fe40000f21070ULL,
0x0000000c7700720cULL, 0x080fe40002781070ULL, 0x0000000ca300720cULL, 0x000fe40002fa1070ULL,
0x0000007acfad7219ULL, 0x000fc400000006ffULL, 0x00000076cfb37219ULL, 0x000fe400000006ffULL,
0xff80000051517808ULL, 0x000fe40003000000ULL, 0xff8000002e2e7808ULL, 0x000fe40000000000ULL,
0xff80000021217808ULL, 0x000fe40001000000ULL, 0xff80000056567808ULL, 0x000fe40001800000ULL,
0xff80000030307808ULL, 0x000fc40000800000ULL, 0xff80000020207808ULL, 0x000fe40002000000ULL,
0xff80000031317808ULL, 0x000fe40002800000ULL, 0x000000609fff7212ULL, 0x000fe400078cc0ffULL,
0x0000006aa7ff7212ULL, 0x080fe4000780c0ffULL, 0x0000006aadff7212ULL, 0x000fe4000784c0ffULL,
0x00000074a7ff7212ULL, 0x000fc4000786c0ffULL, 0x0000008ea7ff7212ULL, 0x000fe4000782c0ffULL,
0x00000074adff7212ULL, 0x000fe4000788c0ffULL, 0x0000008ab3ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b77e7824ULL, 0x000fe200078e0a7cULL, 0x0000000c9d00720cULL, 0x080fe400037c1470ULL,
0x0000000ca500720cULL, 0x0c0fe40000701470ULL, 0x0000000ca500720cULL, 0x000fc40001f61470ULL,
0x0000000ca500720cULL, 0x080fe40000f21470ULL, 0x0000000cab00720cULL, 0x0c0fe40001741470ULL,
0x0000000cab00720cULL, 0x080fe40002781470ULL, 0x0000000cb100720cULL, 0x000fe40002fa1470ULL,
0x0000003159bf7812ULL, 0x040fe400078efcffULL, 0x0000003859c57812ULL, 0x000fc400078efcffULL,
0x0000003959cb7812ULL, 0x000fe400078efcffULL, 0x0000000c9b00720cULL, 0x080fe400037c1070ULL,
0x0000000ca300720cULL, 0x0c0fe40000701070ULL, 0x0000000ca300720cULL, 0x0c0fe40001f61070ULL,
0x0000000ca300720cULL, 0x080fe40000f21070ULL, 0x0000000ca900720cULL, 0x000fc40001741070ULL,
0x0000000ca900720cULL, 0x080fe40002781070ULL, 0x0000000caf00720cULL, 0x000fe40002fa1070ULL,
0x0000007ecfbd7219ULL, 0x000fe400000006ffULL, 0x00005410b9847816ULL, 0x000fe40000000084ULL,
0x00005410d78c7816ULL, 0x000fe2000000008cULL, 0x00000001bfc17824ULL, 0x100fe200078e0200ULL,
0xff80000054547808ULL, 0x000fe20003000000ULL, 0x00000001c5c77824ULL, 0x100fe200078e0200ULL,
0xff8000004e4e7808ULL, 0x000fe20000000000ULL, 0x00000001cbcd7824ULL, 0x000fe200078e0200ULL,
0xff80000046467808ULL, 0x000fc40001800000ULL, 0xff8000001e1e7808ULL, 0x000fe40000800000ULL,
0xff8000004d4d7808ULL, 0x000fe40001000000ULL, 0xff80000043437808ULL, 0x000fe40002000000ULL,
0xff80000033337808ULL, 0x000fe40002800000ULL, 0x0000006ab3ff7212ULL, 0x040fe400078cc0ffULL,
0x00000074b3ff7212ULL, 0x000fc4000780c0ffULL, 0x0000008aadff7212ULL, 0x040fe4000786c0ffULL,
0x0000008eadff7212ULL, 0x080fe4000782c0ffULL, 0x0000008eb3ff7212ULL, 0x000fe4000784c0ffULL,
0x00000084bdff7212ULL, 0x040fe4000788c0ffULL, 0x0000008cbdff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c1807824ULL, 0x100fe200078e0a7cULL, 0x0000000cab00720cULL, 0x080fe20001f61470ULL,
0x00000001c7867824ULL, 0x100fe200078e0a7cULL, 0x0000000cab00720cULL, 0x080fe20000f21470ULL,
0x00000001cd7c7824ULL, 0x000fe200078e0a7cULL, 0x0000000cb100720cULL, 0x000fc400037c1470ULL,
0x0000000cb100720cULL, 0x0c0fe40000701470ULL, 0x0000000cb100720cULL, 0x080fe40001741470ULL,
0x0000000cb700720cULL, 0x0c0fe40002781470ULL, 0x0000000cb700720cULL, 0x000fe40002fa1470ULL,
0x00000080cfc37219ULL, 0x040fe400000006ffULL, 0x00000086cfc97219ULL, 0x000fc400000006ffULL,
0x0000000ca900720cULL, 0x0c0fe40001f61070ULL, 0x0000000ca900720cULL, 0x080fe40000f21070ULL,
0x0000000caf00720cULL, 0x0c0fe400037c1070ULL, 0x0000000caf00720cULL, 0x0c0fe40000701070ULL,
0x0000000caf00720cULL, 0x080fe40001741070ULL, 0x0000000cb500720cULL, 0x000fc40002781070ULL,
0x0000000cb500720cULL, 0x000fe40002fa1070ULL, 0x0000007ccfcf7219ULL, 0x000fe400000006ffULL,
0x00005410d3887816ULL, 0x000fe40000000088ULL, 0xff80000032327808ULL, 0x000fe40001800000ULL,
0xff8000000f0f7808ULL, 0x000fe40000800000ULL, 0xff8000004c4c7808ULL, 0x000fc40003000000ULL,
0xff80000045457808ULL, 0x000fe40000000000ULL, 0xff80000014147808ULL, 0x000fe40001000000ULL,
0xff8000004b4b7808ULL, 0x000fe40002000000ULL, 0xff80000038387808ULL, 0x000fe40002800000ULL,
0x00000084c3ff7212ULL, 0x080fe4000786c0ffULL, 0x00000084c9ff7212ULL, 0x000fc4000782c0ffULL,
0x00000084cfff7212ULL, 0x000fe400078cc0ffULL, 0x00000088bdff7212ULL, 0x080fe4000780c0ffULL,
0x00000088c3ff7212ULL, 0x080fe4000784c0ffULL, 0x00000088c9ff7212ULL, 0x000fe4000788c0ffULL,
0x0000008cc3ff7212ULL, 0x000fe400078ac0ffULL, 0x0000000cb700720cULL, 0x000fc40000701470ULL,
0x0000000cc100720cULL, 0x0c0fe40001f61470ULL, 0x0000000cc100720cULL, 0x0c0fe40001741470ULL,
0x0000000cc100720cULL, 0x080fe40002fa1470ULL, 0x0000000cc700720cULL, 0x080fe40000f21470ULL,
0x0000000ccd00720cULL, 0x080fe400037c1470ULL, 0x0000000cc700720cULL, 0x000fc40002781470ULL,
0x0000000cb500720cULL, 0x080fe40000701070ULL, 0x0000000cbf00720cULL, 0x0c0fe40001f61070ULL,
0x0000000cbf00720cULL, 0x0c0fe40001741070ULL, 0x0000000cbf00720cULL, 0x080fe40002fa1070ULL,
0x0000000cc500720cULL, 0x080fe40000f21070ULL, 0x0000000ccb00720cULL, 0x000fc400037c1070ULL,
0x0000000cc500720cULL, 0x000fe40002781070ULL, 0x00005410db907816ULL, 0x000fe40000000090ULL,
0xff80000044447808ULL, 0x000fe40000000000ULL, 0xff8000004a4a7808ULL, 0x000fe40001800000ULL,
0xff80000039397808ULL, 0x000fe40001000000ULL, 0xff80000034347808ULL, 0x000fc40002800000ULL,
0xff80000049497808ULL, 0x000fe40000800000ULL, 0xff80000048487808ULL, 0x000fe40003000000ULL,
0xff8000003a3a7808ULL, 0x000fe40002000000ULL, 0x00000088cfff7212ULL, 0x000fe4000780c0ffULL,
0x0000008cc9ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008ccfff7212ULL, 0x000fc4000784c0ffULL,
0x00000090bdff7212ULL, 0x080fe400078ac0ffULL, 0x00000090c3ff7212ULL, 0x080fe4000782c0ffULL,
0x00000090c9ff7212ULL, 0x080fe400078cc0ffULL, 0x00000090cfff7212ULL, 0x000fe4000788c0ffULL,
0x0000000cb700720cULL, 0x080fe40002fa1470ULL, 0x0000000cc100720cULL, 0x000fc40000f21470ULL,
0x0000000cc700720cULL, 0x0c0fe40001f61470ULL, 0x0000000cc700720cULL, 0x080fe400037c1470ULL,
0x0000000ccd00720cULL, 0x0c0fe40000701470ULL, 0x0000000ccd00720cULL, 0x0c0fe40001741470ULL,
0x0000000ccd00720cULL, 0x080fe40002781470ULL, 0x0000000cb500720cULL, 0x000fc40002fa1070ULL,
0x0000000cbf00720cULL, 0x080fe40000f21070ULL, 0x0000000ccb00720cULL, 0x080fe40000701070ULL,
0x0000000cc500720cULL, 0x0c0fe40001f61070ULL, 0x0000000cc500720cULL, 0x080fe400037c1070ULL,
0x0000000ccb00720cULL, 0x0c0fe40001741070ULL, 0x0000000ccb00720cULL, 0x000fc40002781070ULL,
0xff80000037377808ULL, 0x000fe40000000000ULL, 0xff80000035357808ULL, 0x000fe40001800000ULL,
0xff80000036367808ULL, 0x000fe40001000000ULL, 0xff80000017177808ULL, 0x000fe40002800000ULL,
0xff80000018187808ULL, 0x000fe40000800000ULL, 0xff8000001c1c7808ULL, 0x000fc40003000000ULL,
0xff8000001d1d7808ULL, 0x000fc40002000000ULL, 0x000000551000720bULL, 0x004fe40003f1e000ULL,
0x0000003e1100720bULL, 0x000fe40003f3e000ULL, 0x000000291200720bULL, 0x000fe40003f5e000ULL,
0x000000261300720bULL, 0x000fe40003f7e000ULL, 0x0000001055107208ULL, 0x000fe40004000000ULL,
0x000000113e0c7208ULL, 0x000fc40004800000ULL, 0x0000001229117208ULL, 0x000fe40005000000ULL,
0x0000001326127208ULL, 0x000fe40005800000ULL, 0x000000531000720bULL, 0x000fe40003f1e000ULL,
0x0000003d0c00720bULL, 0x000fe40003f3e000ULL, 0x000000281100720bULL, 0x000fe40003f5e000ULL,
0x000000271200720bULL, 0x000fc40003f7e000ULL, 0x0000001053137208ULL, 0x000fe40004000000ULL,
0x0000000c3d597208ULL, 0x000fe40004800000ULL, 0x0000001128117208ULL, 0x000fe40005000000ULL,
0x00000012275b7208ULL, 0x000fe40005800000ULL, 0x000000521300720bULL, 0x000fe40003f1e000ULL,
0x0000003c5900720bULL, 0x000fc40003f3e000ULL, 0x0000002a1100720bULL, 0x000fe40003f5e000ULL,
0x000000245b00720bULL, 0x000fe40003f7e000ULL, 0x00000013520c7208ULL, 0x000fe40004000000ULL,
0x000000593c107208ULL, 0x000fe40004800000ULL, 0x000000112a127208ULL, 0x000fe40005000000ULL,
0x0000005b24587208ULL, 0x000fc40005800000ULL, 0x000000510c00720bULL, 0x000fe40003f1e000ULL,
0x0000003b1000720bULL, 0x000fe40003f3e000ULL, 0x0000002b1200720bULL, 0x000fe40003f5e000ULL,
0x000000255800720bULL, 0x000fe40003f7e000ULL, 0x0000000c51117208ULL, 0x000fe40004000000ULL,
0x000000103b107208ULL, 0x000fc40004800000ULL, 0x000000122b137208ULL, 0x000fe40005000000ULL,
0x0000005825587208ULL, 0x000fe40005800000ULL, 0x000000501100720bULL, 0x000fe40003f1e000ULL,
0x0000003f1000720bULL, 0x000fe40003f3e000ULL, 0x0000002c1300720bULL, 0x000fe40003f5e000ULL,
0x000000235800720bULL, 0x000fc40003f7e000ULL, 0x00000011500c7208ULL, 0x000fe40004000000ULL,
0x000000103f107208ULL, 0x000fe40004800000ULL, 0x000000132c127208ULL, 0x000fe40005000000ULL,
0x0000005823117208ULL, 0x000fe40005800000ULL, 0x0000004f0c00720bULL, 0x000fe40003f1e000ULL,
0x000000471000720bULL, 0x000fc40003f3e000ULL, 0x0000002d1200720bULL, 0x000fe40003f5e000ULL,
0x000000221100720bULL, 0x000fe40003f7e000ULL, 0x0000000c4f0c7208ULL, 0x000fe40004000000ULL,
0x0000001047137208ULL, 0x000fe40004800000ULL, 0x000000122d597208ULL, 0x000fe40005000000ULL,
0x0000001122107208ULL, 0x000fc40005800000ULL, 0x000000570c00720bULL, 0x000fe40003f1e000ULL,
0x000000401300720bULL, 0x000fe40003f3e000ULL, 0x0000002e5900720bULL, 0x000fe40003f5e000ULL,
0x000000211000720bULL, 0x000fe40003f7e000ULL, 0x0000000c57117208ULL, 0x000fe40004000000ULL,
0x0000001340137208ULL, 0x000fc40004800000ULL, 0x000000592e0c7208ULL, 0x000fe40005000000ULL,
0x0000001021107208ULL, 0x000fe40005800000ULL, 0x000000541100720bULL, 0x000fe40003f1e000ULL,
0x000000421300720bULL, 0x000fe40003f3e000ULL, 0x0000002f0c00720bULL, 0x000fe40003f5e000ULL,
0x0000001f1000720bULL, 0x000fc40003f7e000ULL, 0x0000001154117208ULL, 0x000fe40004000000ULL,
0x0000001342127208ULL, 0x000fe40004800000ULL, 0x0000000c2f137208ULL, 0x000fe40005000000ULL,
0x000000101f597208ULL, 0x000fe40005800000ULL, 0x000000561100720bULL, 0x000fe40003f1e000ULL,
0x000000411200720bULL, 0x000fc40003f3e000ULL, 0x000000301300720bULL, 0x000fe40003f5e000ULL,
0x000000205900720bULL, 0x000fe40003f7e000ULL, 0x0000001156117208ULL, 0x000fe40004000000ULL,
0x00000012415b7208ULL, 0x000fe40004800000ULL, 0x00000013300c7208ULL, 0x000fe40005000000ULL,
0x0000005920597208ULL, 0x000fc40005800000ULL, 0x0000004e1100720bULL, 0x000fe40003f1e000ULL,
0x000000465b00720bULL, 0x000fe40003f3e000ULL, 0x000000310c00720bULL, 0x000fe40003f5e000ULL,
0x0000001e5900720bULL, 0x000fe40003f7e000ULL, 0x000000114e107208ULL, 0x000fe40004000000ULL,
0x0000005b46127208ULL, 0x000fc40004800000ULL, 0x0000000c31117208ULL, 0x000fe40005000000ULL,
0x000000591e0c7208ULL, 0x000fe40005800000ULL, 0x0000004d1000720bULL, 0x000fe40003f1e000ULL,
0x000000431200720bULL, 0x000fe40003f3e000ULL, 0x000000321100720bULL, 0x000fe40003f5e000ULL,
0x0000000f0c00720bULL, 0x000fc40003f7e000ULL, 0x000000104d137208ULL, 0x000fe40004000000ULL,
0x0000001243127208ULL, 0x000fe40004800000ULL, 0x0000001132107208ULL, 0x000fe40005000000ULL,
0x0000000c0f117208ULL, 0x000fe40005800000ULL, 0x0000004c1300720bULL, 0x000fe40003f1e000ULL,
0x000000451200720bULL, 0x000fc40003f3e000ULL, 0x000000331000720bULL, 0x000fe40003f5e000ULL,
0x000000141100720bULL, 0x000fe40003f7e000ULL, 0x000000134c0c7208ULL, 0x000fe40004000000ULL,
0x0000001245137208ULL, 0x000fe40004800000ULL, 0x0000001033597208ULL, 0x000fe40005000000ULL,
0x0000001114107208ULL, 0x000fc40005800000ULL, 0x0000004b0c00720bULL, 0x000fe40003f1e000ULL,
0x000000441300720bULL, 0x000fe40003f3e000ULL, 0x000000385900720bULL, 0x000fe40003f5e000ULL,
0x000000171000720bULL, 0x000fe40003f7e000ULL, 0x0000000c4b117208ULL, 0x000fe40004000000ULL,
0x00000013440c7208ULL, 0x000fc40004800000ULL, 0x0000005938597208ULL, 0x000fe40005000000ULL,
0x0000001017137208ULL, 0x000fe40005800000ULL, 0x0000004a1100720bULL, 0x000fe40003f1e000ULL,
0x000000390c00720bULL, 0x000fe40003f3e000ULL, 0x000000345900720bULL, 0x000fe40003f5e000ULL,
0x000000181300720bULL, 0x000fc40003f7e000ULL, 0x000000114a107208ULL, 0x000fe40004000000ULL,
0x0000000c39117208ULL, 0x000fe40004800000ULL, 0x00000059340c7208ULL, 0x000fe40005000000ULL,
0x0000001318137208ULL, 0x000fe40005800000ULL, 0x000000491000720bULL, 0x000fe40003f1e000ULL,
0x0000003a1100720bULL, 0x000fc40003f3e000ULL, 0x000000350c00720bULL, 0x000fe40003f5e000ULL,
0x0000001c1300720bULL, 0x000fe40003f7e000ULL, 0x0000001049597208ULL, 0x000fe40004000000ULL,
0x000000113a107208ULL, 0x000fe40004800000ULL, 0x0000000c35117208ULL, 0x000fe40005000000ULL,
0x000000131c0c7208ULL, 0x000fc40005800000ULL, 0x000000485900720bULL, 0x000fe40003f1e000ULL,
0x000000371000720bULL, 0x000fe40003f3e000ULL, 0x000000361100720bULL, 0x000fe40003f5e000ULL,
0x0000001d0c00720bULL, 0x000fe40003f7e000ULL, 0x0000005948137208ULL, 0x000fe40004000000ULL,
0x00000010375b7208ULL, 0x000fc40004800000ULL, 0x00000011365d7208ULL, 0x000fe40005000000ULL,
0x0000000c1d5e7208ULL, 0x000fe20005800000ULL, 0x000023827f007947ULL, 0x000fea000b800000ULL,
0x0c401f00130c7f89ULL, 0x0004e400000e0000ULL, 0x0000000c1300720bULL, 0x00cfc80003f1e000ULL,
0x000000130c5f7208ULL, 0x000fe20004000000ULL, 0x000023a27f007947ULL, 0x000fea000b800000ULL,
0x0c401f005b0c7f89ULL, 0x000ea800000e0000ULL, 0x0c401f005d107f89ULL, 0x000ee800000e0000ULL,
0x0c401f005e117f89ULL, 0x000f2200000e0000ULL, 0x0000000c5b00720bULL, 0x004fc40003f1e000ULL,
0x000000105d00720bULL, 0x008fe40003f3e000ULL, 0x0000005b0c0c7208ULL, 0x000fe40004000000ULL,
0x0000005d10137208ULL, 0x002fe40004800000ULL, 0x000000115e00720bULL, 0x010fe20003f1e000ULL,
0x0c201f005f107f89ULL, 0x000e6600000e0000ULL, 0x0000005e115a7208ULL, 0x000fe20004000000ULL,
0x0c201f000c597f89ULL, 0x000ea800000e0000ULL, 0x0c201f0013127f89ULL, 0x000ee800000e0000ULL,
0x0c201f005a5b7f89ULL, 0x0002e400000e0000ULL, 0x000000105f00720bULL, 0x002fc40003f1e000ULL,
0x000000590c00720bULL, 0x004fe40003f3e000ULL, 0x0000005f10107208ULL, 0x000fe40004000000ULL,
0x000000121300720bULL, 0x008fe40003f5e000ULL, 0x0000000c59117208ULL, 0x000fe40004800000ULL,
0x0000001312127208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b10137820ULL, 0x002fe20000410000ULL,
0x0000005b5a00720bULL, 0x000fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x00000002ff6a7819ULL, 0x000fe20000011603ULL, 0x3fb8aa3b4f0c7823ULL, 0x100fe20000010813ULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b55557823ULL, 0x000fc40000010813ULL,
0x0000000c00597308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b53537823ULL, 0x100fe40000010813ULL,
0x3fb8aa3b52527823ULL, 0x100fe40000010813ULL, 0x3fb8aa3b51517823ULL, 0x100fe40000010813ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010813ULL, 0x0000005300587308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4b0c7823ULL, 0x102fe40000010813ULL, 0x3fb8aa3b57577823ULL, 0x000fc40000010813ULL,
0x3fb8aa3b54547823ULL, 0x100fe40000010813ULL, 0x3fb8aa3b564f7823ULL, 0x100fe20000010813ULL,
0x0000005500557308ULL, 0x000e620000000800ULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe40000010813ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe40000010813ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe40000010813ULL,
0x3fb8aa3b4a4b7823ULL, 0x100fe20000010813ULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b49497823ULL, 0x000fc40000010813ULL, 0x3fb8aa3b48487823ULL, 0x000fe40000010813ULL,
0x3fb8aa3b12137820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b114a7820ULL, 0x000fe20000410000ULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b29297823ULL, 0x100fe40000010813ULL,
0x3fb8aa3b28287823ULL, 0x100fe40000010813ULL, 0x3fb8aa3b2a2a7823ULL, 0x000fc40000010813ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010813ULL, 0x0000005700577308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe40000010813ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe40000010813ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe40000010813ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010813ULL,
0x0000002b005f7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b30307823ULL, 0x000fc40000010813ULL,
0x3fb8aa3b31317823ULL, 0x100fe40000010813ULL, 0x3fb8aa3b32327823ULL, 0x100fe40000010813ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010813ULL, 0x0000002f00637308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b38387823ULL, 0x100fe40000010813ULL, 0x3fb8aa3b34347823ULL, 0x100fe40000010813ULL,
0x3fb8aa3b35357823ULL, 0x000fc40000010813ULL, 0x3fb8aa3b36367823ULL, 0x000fe20000010813ULL,
0x0000005a5b137208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b42427823ULL, 0x100fe2000001084aULL,
0x0000003400697308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe2000001084aULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b135a7820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe4000001084aULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe2000001084aULL,
0x00000042005d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3b3b7823ULL, 0x000fc4000001084aULL,
0x3fb8aa3b45457823ULL, 0x000fe4000001084aULL, 0x3fb8aa3b252b7823ULL, 0x104fe4000001085aULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001085aULL, 0x0000002900427308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b27277823ULL, 0x000fe4000001085aULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe4000001084aULL,
0x3fb8aa3b47477823ULL, 0x000fc4000001084aULL, 0x3fb8aa3b40407823ULL, 0x000fe2000001084aULL,
0x0000003b00537308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b24297823ULL, 0x004fe2000001085aULL,
0x000000036a247810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b41417823ULL, 0x100fe4000001084aULL,
0x3fb8aa3b46467823ULL, 0x100fe4000001084aULL, 0x3fb8aa3b43437823ULL, 0x100fe2000001084aULL,
0x0000003e003e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b443b7823ULL, 0x008fc4000001084aULL,
0x3fb8aa3b39397823ULL, 0x100fe4000001084aULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe4000001084aULL,
0x3fb8aa3b37377823ULL, 0x000fe2000001084aULL, 0x0000003d003d7308ULL, 0x000ea20000000800ULL,
0x000000086a6f7824ULL, 0x040fe400078e00ffULL, 0x000000086a717824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b23237823ULL, 0x000fe2000001085aULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee224ULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001085aULL, 0x0000003c003c7308ULL, 0x000fe20000000800ULL,
0x000000555824723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b21217823ULL, 0x000fc4000001085aULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe4000001085aULL, 0x000000086a6b7824ULL, 0x040fe400078e00ffULL,
0x00000045005c7308ULL, 0x000fe20000000800ULL, 0x0000003e3d25723eULL, 0x004fe200000010ffULL,
0x000000086a6d7824ULL, 0x040fe400078e00ffULL, 0x000000086a557824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b203d7823ULL, 0x000fc4000001085aULL, 0x0000002d00617308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe4000001085aULL, 0x3fb8aa3b14147823ULL, 0x100fe4000001085aULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe4000001085aULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001085aULL,
0x0000003000627308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b18187823ULL, 0x000fce000001085aULL,
0x00000029002f7308ULL, 0x000ff00000000800ULL, 0x0000002b00347308ULL, 0x000e700000000800ULL,
0x0000002800457308ULL, 0x0005f00000000800ULL, 0x0000002a004a7308ULL, 0x000fe20000000800ULL,
0x0000002f342f723eULL, 0x002fc400000010ffULL, 0x000000016a287810ULL, 0x004fc80007ffe0ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee228ULL, 0x00000026002d7308ULL, 0x0003e20000000800ULL,
0x000000026a287810ULL, 0x000fc80007ffe0ffULL, 0xfffffff86d6d7812ULL, 0x000fc600078ee228ULL,
0x0000002700307308ULL, 0x0004e20000000800ULL, 0x000000046a267810ULL, 0x002fc80007ffe0ffULL,
0xfffffff871717812ULL, 0x000fe400078ee226ULL, 0x000000525126723eULL, 0x000fe200000010ffULL,
0x0000003800667308ULL, 0x0003e20000000800ULL, 0x0000003c5327723eULL, 0x004fe200000010ffULL,
0x000000086a537824ULL, 0x000fcc00078e00ffULL, 0x0000003900447308ULL, 0x0005e20000000800ULL,
0x00000004ff387e24ULL, 0x002fe2000f8e00ffULL, 0x0000002d302d723eULL, 0x008fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x3f8000003838783eULL, 0x000fe400000010ffULL,
0x0000002c005e7308ULL, 0x0002e60000000800ULL, 0x000000ffff397224ULL, 0x004fc400078e0038ULL,
0x000000ffff347224ULL, 0x000fc600078e0038ULL, 0x0000002e00607308ULL, 0x0005e20000000800ULL,
0x00000042452c723eULL, 0x002fe200000010ffULL, 0x000000086a427824ULL, 0x040fe400078e00ffULL,
0x000000086a457824ULL, 0x000fc800078e00ffULL, 0x0000003500687308ULL, 0x0003e20000000800ULL,
0x0000004a5f2e723eULL, 0x004fe200000010ffULL, 0x000000ffff5f7224ULL, 0x100fe200078e0038ULL,
0x0000005e6120723eULL, 0x008fe200000010ffULL, 0x000000ffff5e7224ULL, 0x000fe200078e0038ULL,
0xfffffff845457812ULL, 0x000fc600078ee26aULL, 0x0000004700567308ULL, 0x000fe20000000800ULL,
0x000000ffff357224ULL, 0x002fce00078e0038ULL, 0x0000003100657308ULL, 0x000ff00000000800ULL,
0x0000003200647308ULL, 0x000ff00000000800ULL, 0x0000003300677308ULL, 0x0003f00000000800ULL,
0x0000005400547308ULL, 0x000ea20000000800ULL, 0x000000382430723cULL, 0x002b6e00000418ffULL,
0x0000003f003f7308ULL, 0x000e700000000800ULL, 0x0000003700477308ULL, 0x000fe20000000800ULL,
0x00000057542a723eULL, 0x004fe200000010ffULL, 0x000000ffff577224ULL, 0x000fcc00078e0038ULL,
0x00000036005b7308ULL, 0x0005e20000000800ULL, 0x0000003f5629723eULL, 0x002fe200000010ffULL,
0x000000ffff567224ULL, 0x000fe200078e0038ULL, 0x000000056a3f7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff842517812ULL, 0x000fe200078ee23fULL, 0x0000005000507308ULL, 0x000e620000000800ULL,
0x000000342c34723cULL, 0x004f6200000418ffULL, 0x000000ffff427224ULL, 0x000fcc00078e0038ULL,
0x0000004000407308ULL, 0x000eb00000000800ULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x000000505928723eULL, 0x002fe400000010ffULL, 0x000000106a597810ULL, 0x000fca0007ffe0ffULL,
0x00000022003c7308ULL, 0x0002e20000000800ULL, 0x000000405d2b723eULL, 0x004fe400000010ffULL,
0x000000066a407810ULL, 0x000fc80007ffe0ffULL, 0xfffffff853537812ULL, 0x000fe200078ee240ULL,
0x0000002100397308ULL, 0x0207e20000000800ULL, 0xffffffff6a227810ULL, 0x002fe20007ffe0ffULL,
0x000000562830723cULL, 0x000b660000041830ULL, 0xfffffff855557812ULL, 0x000fe400078ee222ULL,
0x000000606322723eULL, 0x000fe200000010ffULL, 0x0000001f003e7308ULL, 0x000e620000000800ULL,
0x000000233c21723eULL, 0x008fc400000010ffULL, 0x000000086a577810ULL, 0x060fe40007ffe0ffULL,
0x000000186a6a7810ULL, 0x000fc60007ffe0ffULL, 0x0000004300437308ULL, 0x000ea20000000800ULL,
0x00000008573c7824ULL, 0x000fca00078e00ffULL, 0xfffffff83c577812ULL, 0x000fe400078ee257ULL,
0x000000393e23723eULL, 0x002fe200000010ffULL, 0x0000004f004f7308ULL, 0x000fe20000000800ULL,
0x00000008593e7824ULL, 0x000fe200078e00ffULL, 0x00000062653c723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b1c397823ULL, 0x100fe4000001085aULL, 0x3fb8aa3b1d5a7823ULL, 0x000fe2000001085aULL,
0x0000005e2034723cULL, 0x000f620000041834ULL, 0x000000435c1f723eULL, 0x004fe200000010ffULL,
0x0000004e004e7308ULL, 0x000e620000000800ULL, 0xfffffff83e597812ULL, 0x000fe200078ee259ULL,
0x000000ffff437224ULL, 0x000fe200078e0038ULL, 0x00000064673e723eULL, 0x000fca00000010ffULL,
0x0000004d004d7308ULL, 0x000ff00000000800ULL, 0x0000004c004c7308ULL, 0x000fe20000000800ULL,
0x0000004f4e1c723eULL, 0x002fe200000010ffULL, 0x000000ffff4e7224ULL, 0x000fc400078e0038ULL,
0x000000ffff4f7224ULL, 0x000fc800078e0038ULL, 0x0000004100417308ULL, 0x000ff00000000800ULL,
0x0000004600467308ULL, 0x000e700000000800ULL, 0x0000003d003d7308ULL, 0x000ff00000000800ULL,
0x0000001e00407308ULL, 0x0004e20000000800ULL, 0x00000041461d723eULL, 0x002fc400000010ffULL,
0x000000685b46723eULL, 0x000fca00000010ffULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x0000004d4c1e723eULL, 0x004fe200000010ffULL, 0x000000086a4d7824ULL, 0x000fca00078e00ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee26aULL, 0x0000001400147308ULL, 0x000e620000000800ULL,
0x0000003d403d723eULL, 0x008fe400000010ffULL, 0x000000421c40723cULL, 0x000b6a0000041830ULL,
0x0000000c000c7308ULL, 0x000ff00000000800ULL, 0x0000004b004b7308ULL, 0x000ea20000000800ULL,
0x0000000f143f723eULL, 0x002fce00000010ffULL, 0x0000003b003b7308ULL, 0x000e620000000800ULL,
0x0000004e3c34723cULL, 0x020fee0000041834ULL, 0x0000003a003a7308ULL, 0x000ee20000000800ULL,
0x0000000c4b30723eULL, 0x004fe400000010ffULL, 0x000120001a0c7811ULL, 0x000fca00078e60ffULL,
0x0000004900497308ULL, 0x000fe20000000800ULL, 0x0000001045457824ULL, 0x100fe200078e020cULL,
0x0000003b4431723eULL, 0x002fe200000010ffULL, 0x000000106b6b7824ULL, 0x100fe200078e020cULL,
0x000000666944723eULL, 0x000fe200000010ffULL, 0x000000106d6d7824ULL, 0x100fe400078e020cULL,
0x000000106f6f7824ULL, 0x100fe200078e020cULL, 0x0000004800487308ULL, 0x000e620000000800ULL,
0x0000003a4733723eULL, 0x008fe200000010ffULL, 0x0000001071717824ULL, 0x000fc400078e020cULL,
0x000000ffff3a7224ULL, 0x000fe400078e0038ULL, 0x00000001450f7824ULL, 0x000fe400078e020eULL,
0x0000003900397308ULL, 0x000fe20000000800ULL, 0x000000ffff3b7224ULL, 0x000fe400078e0038ULL,
0x0000001051517824ULL, 0x100fe200078e020cULL, 0x000000240f007388ULL, 0x0005e20000000800ULL,
0x000000010e6b7824ULL, 0x000fe400078e026bULL, 0x0000001053537824ULL, 0x100fe200078e020cULL,
0x0000005a005a7308ULL, 0x000ee20000000800ULL, 0x000000494832723eULL, 0x002fe200000010ffULL,
0x000000010e6d7824ULL, 0x000fe200078e026dULL, 0x000000266b007388ULL, 0x0005e20000000800ULL,
0x0000001055557824ULL, 0x000fc400078e020cULL, 0x000000010e6f7824ULL, 0x040fe200078e026fULL,
0x000000286d007388ULL, 0x0005e20000000800ULL, 0x0000001700177308ULL, 0x000fe20000000800ULL,
0x0000001057577824ULL, 0x000fe200078e020cULL, 0x0000003a3040723cULL, 0x000f620000041840ULL,
0x000000010e717824ULL, 0x040fe200078e0271ULL, 0x0000002a6f007388ULL, 0x0005e20000000800ULL,
0x000000010e517824ULL, 0x040fe400078e0251ULL, 0x000000010e537824ULL, 0x000fe200078e0253ULL,
0x0000001800187308ULL, 0x000e620000000800ULL, 0x000000395a47723eULL, 0x008fe200000010ffULL,
0x000000ffff397224ULL, 0x000fe200078e0038ULL, 0x0000001c71007388ULL, 0x0005e20000000800ULL,
0x0000001059597824ULL, 0x000fc400078e020cULL, 0x000000104d4d7824ULL, 0x000fe200078e020cULL,
0x0000001e51007388ULL, 0x0005e20000000800ULL, 0x000000010e557824ULL, 0x040fe400078e0255ULL,
0x000000010e0c7824ULL, 0x040fe200078e0257ULL, 0x0000003053007388ULL, 0x0005e20000000800ULL,
0x000000010e597824ULL, 0x040fe400078e0259ULL, 0x000000010e0e7824ULL, 0x000fe200078e024dULL,
0x0000003255007388ULL, 0x0005e20000000800ULL, 0x000000171845723eULL, 0x002fc400000010ffULL,
0x000000ffff417224ULL, 0x020fe200078e0042ULL, 0x000000250c007388ULL, 0x0005e80000000800ULL,
0x000000384434723cULL, 0x000f620000041834ULL, 0x000400276b007388ULL, 0x0005e80000000800ULL,
0x000400296d007388ULL, 0x0005e80000000800ULL, 0x0004002b6f007388ULL, 0x0005e80000000800ULL,
0x0004001d71007388ULL, 0x0005e80000000800ULL, 0x0004001f51007388ULL, 0x0005e80000000800ULL,
0x0004003153007388ULL, 0x0005e60000000800ULL, 0x000000ffff427224ULL, 0x020fe200078e0034ULL,
0x0004003355007388ULL, 0x0005e20000000800ULL, 0x000000ffff437224ULL, 0x000fc600078e0036ULL,
0x0000002c59007388ULL, 0x0005e80000000800ULL, 0x0008002e6b007388ULL, 0x0005e80000000800ULL,
0x000800206d007388ULL, 0x0005e80000000800ULL, 0x000800226f007388ULL, 0x0005e80000000800ULL,
0x0008003c71007388ULL, 0x0005e80000000800ULL, 0x0008003e51007388ULL, 0x0005e80000000800ULL,
0x0008004453007388ULL, 0x0005e80000000800ULL, 0x0008004655007388ULL, 0x0005e80000000800ULL,
0x0000002d0e007388ULL, 0x0005e80000000800ULL, 0x000c002f6b007388ULL, 0x0005e80000000800ULL,
0x000c00216d007388ULL, 0x0005e80000000800ULL, 0x000c00236f007388ULL, 0x0005e80000000800ULL,
0x000c003d71007388ULL, 0x0005e80000000800ULL, 0x000c003f51007388ULL, 0x0005e80000000800ULL,
0x000c004553007388ULL, 0x0005e80000000800ULL, 0x000c004755007388ULL, 0x0005e80000000800ULL,
0x01a000100b008388ULL, 0x0005e80000000c00ULL, 0x01a200400b008388ULL, 0x0005e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000bbff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000800bbff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00001000bbff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000010a0a7810ULL, 0x000fe20007ffe0ffULL,
0x00001800bbff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff0b7224ULL, 0x004fc400078e000dULL,
0x000000150a00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff7c1000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff257807ULL, 0x002fe20004000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001cd2000267802ULL, 0x000fc40000000f00ULL, 0x000013f000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0025ULL, 0xfffe5d4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe20005800000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001cd8000267802ULL, 0x000fc40000000f00ULL, 0x0000139000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0025ULL, 0xfffe5d7000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001cde000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000012e000007944ULL, 0x004fea0003c00000ULL,
0xfffe5e3000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001ce3000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000129000007944ULL, 0x006fea0003c00000ULL, 0xfffe5f5000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001ce8000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000124000007944ULL, 0x00efea0003c00000ULL,
0xfffe607000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001ced000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000011f000007944ULL, 0x00efea0003c00000ULL, 0xfffe618000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x0001cf3000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000119000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xfffe659000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001cf9000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000113000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x0000001002267810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001cff000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000010d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xfffe652000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001d05000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000107000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xfffe64f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001d0b000267802ULL, 0x000fc40000000f00ULL,
0x0000106000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0025ULL,
0xfffe94e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe20005800000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001d11000267802ULL, 0x000fc40000000f00ULL,
0x0000100000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff707224ULL, 0x000fe200078e0025ULL,
0xfffe952000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001d17000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000f5000007944ULL, 0x004fea0003c00000ULL, 0xfffe95e000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001d1c000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000f0000007944ULL, 0x006fea0003c00000ULL,
0xfffe970000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001d21000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000eb000007944ULL, 0x00efea0003c00000ULL, 0xfffe982000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001d26000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000e6000007944ULL, 0x00efea0003c00000ULL,
0xfffe993000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001eULL,
0x0001d2c000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000e0000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xfffe9d1000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001d32000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000da000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x000000101e267810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001d38000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000d4000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xfffe9ca000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001d3e000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000ce000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xfffe9c7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe20004000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001d44000267802ULL, 0x000fc40000000f00ULL, 0x00000cd000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff717224ULL, 0x000fe200078e0025ULL, 0xfffecb8000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe20005800000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001d4a000267802ULL, 0x000fc40000000f00ULL, 0x00000c7000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff727224ULL, 0x000fe200078e0025ULL, 0xfffecbc000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001d50000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000bc000007944ULL, 0x002fea0003c00000ULL,
0xfffecc8000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001d55000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000b7000007944ULL, 0x002fea0003c00000ULL, 0xfffecda000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001d5a000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000b2000007944ULL, 0x002fea0003c00000ULL,
0xfffecec000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001d5f000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000ad000007944ULL, 0x002fea0003c00000ULL, 0xfffecfd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006cULL, 0x0001d65000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000a7000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xfffed3c000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001d6b000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000a1000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x000000106c267810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001d71000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000009b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xfffed35000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001d77000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000095000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xfffed32000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x004fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001d7d000267802ULL, 0x000fc40000000f00ULL,
0x0000094000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0025ULL,
0xffff014000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe20005800000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001d83000267802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff717224ULL, 0x000fe200078e0025ULL,
0xffff018000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001d89000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000083000007944ULL, 0x008fea0003c00000ULL, 0xffff024000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001d8e000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000007e000007944ULL, 0x00afea0003c00000ULL,
0xffff036000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001d93000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000079000007944ULL, 0x00afea0003c00000ULL, 0xffff048000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001d98000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000074000007944ULL, 0x00afea0003c00000ULL,
0xffff059000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0008ULL,
0x0001d9e000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000006e000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xffff098000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001da4000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000068000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x0000001008267810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001daa000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000062000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xffff091000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001db0000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xffff08e000007947ULL, 0x000fea000383ffffULL,
0x00000002ff5c7424ULL, 0x000fe200078e00ffULL, 0x0001db7000587802ULL, 0x000fe20000000f00ULL,
0x0000001fff0c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff617424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x002fea0003c00000ULL, 0xffffdc3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff137224ULL, 0x002fe200078e005bULL, 0x0001dbe000587802ULL, 0x000fe20000000f00ULL,
0x00000002ff5c7424ULL, 0x000fe400078e00ffULL, 0x0000001fff0c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff617424ULL, 0x000fc400078e00ffULL, 0x000004a000007944ULL, 0x000fea0003c00000ULL,
0x0000000c5b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff137224ULL, 0x002fe200078e005dULL,
0x0001dc6000587802ULL, 0x000fe20000000f00ULL, 0x00000002ff5c7424ULL, 0x000fe200078e00ffULL,
0x0000005b0c117208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff617424ULL, 0x000fc400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x0000000c5d00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff137224ULL, 0x002fe200078e005eULL,
0x0001dce000587802ULL, 0x000fe20000000f00ULL, 0x00000002ff5c7424ULL, 0x000fe200078e00ffULL,
0x0000005d0c5b7208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff617424ULL, 0x000fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x0000000c5e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff137224ULL, 0x002fe200078e005fULL,
0x0001dd6000587802ULL, 0x000fe20000000f00ULL, 0x00000001ff5c7424ULL, 0x000fe200078e00ffULL,
0x0000005e0c5a7208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff617424ULL, 0x000fc400078e00ffULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x0000000c5f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff137224ULL, 0x002fe200078e0011ULL,
0x0001dde000587802ULL, 0x000fe20000000f00ULL, 0x00000001ff5c7424ULL, 0x000fe200078e00ffULL,
0x0000005f0c107208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff617424ULL, 0x000fc400078e00ffULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x0000000c1100720bULL, 0x004fe20003f1e000ULL, 0x000000ffff137224ULL, 0x002fe200078e005bULL,
0x0001de6000587802ULL, 0x000fe20000000f00ULL, 0x00000001ff5c7424ULL, 0x000fe200078e00ffULL,
0x000000110c117208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff617424ULL, 0x000fc400078e00ffULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x0000000c5b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff137224ULL, 0x002fe200078e005aULL,
0x0001dee000587802ULL, 0x000fe20000000f00ULL, 0x00000001ff5c7424ULL, 0x000fe200078e00ffULL,
0x0000005b0c127208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff617424ULL, 0x000fc400078e00ffULL, 0x000001a000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff5b7224ULL, 0x004fe200078e000cULL, 0xffffda1000007947ULL, 0x000fea000383ffffULL,
0x0180000024007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002400008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff24ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000024027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002400007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe1f8002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff597424ULL, 0x000fe200078e00ffULL, 0x0000006100007348ULL, 0x000fe80003800000ULL,
0x0c00005c130c7389ULL, 0x0002a200000e000cULL, 0xfffe1f4058007950ULL, 0x000fea0003c3ffffULL,
0x0000006a00007348ULL, 0x000fe80003800000ULL, 0x0000002627267389ULL, 0x0002a200000e006fULL,
0x00000000ff6b7424ULL, 0x000fc400078e00ffULL, 0x000000ffff6a7224ULL, 0x002fc800078e0025ULL,
0xfffe1ef06a007950ULL, 0x000fea0003c3ffffULL, 0x000000012500780cULL, 0x000fe20003f65070ULL,
0x0000002700007348ULL, 0x000fd80003800000ULL, 0x0000000000257806ULL, 0x000fc800058e0100ULL,
0x0000002725257212ULL, 0x000fe200078ec0ffULL, 0x00000000ff277424ULL, 0x000fc800078e00ffULL,
0xfffe1e9026007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000568ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000328ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c60ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d20ULL,
0x00000000000008b0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015d0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001670ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001674ULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x000000000001e200ULL, 0xfc00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001fa80ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001fac0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001fe40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001670ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001e410ULL,
0x000000000001e410ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001fa80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001fe40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_80_cubin_len = 130848;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
