/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000196d0ULL, 0x0000000000019350ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x00000000000177d0ULL, 0x0000000000000180ULL, 0x000b0022000004daULL, 0x0000000000017950ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x0000000000017990ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x00000000000179e0ULL, 0x0000000000000120ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000017b00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000177d000000000ULL, 0x0000040400000000ULL, 0x810c000001880400ULL, 0x005c600400288080ULL,
0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9008288080820828ULL,
0x2880809108288080ULL, 0x80a808288080a608ULL, 0x08288080a9082880ULL, 0x80808408288080bdULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x000177d000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8080288080820900ULL, 0x0900000010042880ULL, 0x2880808228808084ULL, 0x0000006cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8e08288080820828ULL, 0x2880809008288080ULL, 0x80a6082880809108ULL,
0x08288080a8082880ULL, 0x8080bd08288080a9ULL, 0x80162880808c0828ULL, 0x0000000310288082ULL,
0x808c920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000012000000000ULL,
0x0001795000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x9008288080820828ULL, 0x2880809108288080ULL, 0x80a808288080a608ULL,
0x08288080a9082880ULL, 0x80828016288080bdULL, 0x0000000000031028ULL, 0x288080bd92000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x000001c000000000ULL, 0x0001799000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8090288080bd0900ULL, 0x0000000000002880ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9008288080820828ULL, 0x288080a608288080ULL,
0x80a908288080a808ULL, 0x08288080bd082880ULL, 0x8082801628808091ULL, 0x0000000000031028ULL,
0x2880809192000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL, 0x0000026800000000ULL,
0x000179e000000000ULL, 0x0000012000000000ULL, 0x0000080400000000ULL, 0x8090288080910900ULL,
0x0000000000002880ULL, 0x0000001b00082f04ULL, 0x0008230400000080ULL, 0x0000000000000017ULL,
0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL,
0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL, 0x0008110400000000ULL,
0x000000000000001bULL, 0x0000007b00043704ULL, 0x0000001800080a04ULL, 0x0060190300600160ULL,
0x00000000000c1704ULL, 0x0021f0000058000aULL, 0x00000000000c1704ULL, 0x0021f00000500009ULL,
0x00000000000c1704ULL, 0x0011f00000480008ULL, 0x00000000000c1704ULL, 0x0061f00000300007ULL,
0x00000000000c1704ULL, 0x0021f00000280006ULL, 0x00000000000c1704ULL, 0x0021f00000200005ULL,
0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL, 0x0021f00000100003ULL,
0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL, 0x0011f00000040001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400801b03ULL, 0x0134290400000b70ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL, 0x000003b000000300ULL,
0x00002630000005a0ULL, 0x00002800000026e0ULL, 0x00002dc000002960ULL, 0x00002e4000002df0ULL,
0x00005be000002e90ULL, 0x00005da000005c80ULL, 0x0000637000005f00ULL, 0x000063f0000063a0ULL,
0x0000915000006440ULL, 0x00009320000091f0ULL, 0x0000990000009480ULL, 0x0000998000009930ULL,
0x0000c620000099d0ULL, 0x0000c7e00000c6c0ULL, 0x0000cdf00000c940ULL, 0x0000ce700000ce20ULL,
0x0000efa00000cec0ULL, 0x000160700000efb0ULL, 0x000160c0000160b0ULL, 0x000160e0000160d0ULL,
0x0001616000016140ULL, 0x00016e1000016180ULL, 0x00016ea000016e50ULL, 0x00016f3000016ee0ULL,
0x00016fd000016f80ULL, 0x0001706000017010ULL, 0x000170f0000170a0ULL, 0x0001719000017140ULL,
0x00017220000171d0ULL, 0x000172b000017260ULL, 0x0001735000017300ULL, 0x000173e000017390ULL,
0x0001747000017420ULL, 0x00017510000174c0ULL, 0x000175d000017570ULL, 0x0001769000017630ULL,
0x00017750000176f0ULL, 0x04403904000177b0ULL, 0x000000ff00000410ULL, 0x003f01000000f600ULL,
0x0000001300000450ULL, 0x003f01200000f608ULL, 0x00000013000004e0ULL, 0x003f01200000f688ULL,
0x0000001300000510ULL, 0x003f01200000f6a8ULL, 0x0000001300000530ULL, 0x003f01200000f6c8ULL,
0x000000ff00000b90ULL, 0x003f01070000f600ULL, 0x0000000300000ce0ULL, 0x003f01020000f68cULL,
0x0000000300000d70ULL, 0x003f01010000f688ULL, 0x000000ff000015a0ULL, 0x0004010700000000ULL,
0x000000ff00001620ULL, 0x0004010100000000ULL, 0x0000000400001680ULL, 0x003f010100000020ULL,
0x0000000b000017d0ULL, 0x003f01050000f6ccULL, 0x0000000b000019b0ULL, 0x003f01050000f6ccULL,
0x00000012000021f0ULL, 0x003f01070000f6b0ULL, 0x0000001200002290ULL, 0x003f01010000f6b0ULL,
0x00000010000022f0ULL, 0x003f01010000f608ULL, 0x0000000600002330ULL, 0x003f01050000f60cULL,
0x0000000600002510ULL, 0x003f01050000f60cULL, 0x0000002200002b20ULL, 0x003f01050000f6acULL,
0x0000002200002cf0ULL, 0x003f01050000f6acULL, 0x0000003400004e50ULL, 0x003f010100000000ULL,
0x0000000e00004eb0ULL, 0x003f01010000f688ULL, 0x0000000500004ee0ULL, 0x003f010500000004ULL,
0x00000005000050a0ULL, 0x003f010500000004ULL, 0x000000ff000057f0ULL, 0x0004010700000000ULL,
0x000000ff000058c0ULL, 0x0004010100000000ULL, 0x0000000e00005920ULL, 0x003f01010000f628ULL,
0x0000000600005940ULL, 0x003f01050000f62cULL, 0x0000000600005b10ULL, 0x003f01050000f62cULL,
0x0000003a000060d0ULL, 0x003f01050000f6b4ULL, 0x0000003a000062a0ULL, 0x003f01050000f6b4ULL,
0x00000010000083b0ULL, 0x003f010100000000ULL, 0x0000005a00008410ULL, 0x003f01010000f690ULL,
0x0000000500008440ULL, 0x003f010500000004ULL, 0x0000000500008600ULL, 0x003f010500000004ULL,
0x000000ff00008d60ULL, 0x0004010700000008ULL, 0x0000003800008df0ULL, 0x003f01010000f6b0ULL,
0x0000000600008e50ULL, 0x003f01010000f648ULL, 0x0000000600008eb0ULL, 0x003f01050000f64cULL,
0x0000000600009080ULL, 0x003f01050000f64cULL, 0x0000003d00009660ULL, 0x003f01050000f6acULL,
0x0000003d00009830ULL, 0x003f01050000f6acULL, 0x000000050000b850ULL, 0x003f010100000000ULL,
0x0000000a0000b8b0ULL, 0x003f010100000000ULL, 0x000000050000b8e0ULL, 0x003f010500000004ULL,
0x000000050000baa0ULL, 0x003f010500000004ULL, 0x000000ff0000c240ULL, 0x0004010700000000ULL,
0x000000ff0000c310ULL, 0x0004010100000000ULL, 0x000000130000c370ULL, 0x003f01010000f668ULL,
0x000000130000c3a0ULL, 0x003f01050000f66cULL, 0x000000130000c570ULL, 0x003f01050000f66cULL,
0x000000340000cb10ULL, 0x003f01050000f6b4ULL, 0x000000340000cd10ULL, 0x003f01050000f6b4ULL,
0x000000050000ed70ULL, 0x003f010100000000ULL, 0x0000000b0000edf0ULL, 0x003f010100000000ULL,
0x000000ff00010170ULL, 0x003f01010000f600ULL, 0x000000ff00010d50ULL, 0x003f01050000f604ULL,
0x000000ff00010f60ULL, 0x003f01050000f604ULL, 0x000000ff00011190ULL, 0x003f01010000f600ULL,
0x000000ff000111c0ULL, 0x003f01050000f604ULL, 0x000000ff00011380ULL, 0x003f01050000f604ULL,
0x0000007900014430ULL, 0x003f010100000000ULL, 0x00000079000144d0ULL, 0x003f010500000004ULL,
0x00000079000146a0ULL, 0x003f010500000004ULL, 0x0000007c00016c70ULL, 0x003f010100000000ULL,
0x0000007c00016cd0ULL, 0x003f010100000008ULL, 0x0000007c00016d30ULL, 0x003f010100000010ULL,
0x0000007c00016da0ULL, 0x003f010100000018ULL, 0x00201c0400053803ULL, 0x0000f8900000f860ULL,
0x0000fd100000fb20ULL, 0x000100c00000ff10ULL, 0x00016de0000113e0ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x00000000000002ecULL, 0x0000001b00000002ULL, 0x0000000000000244ULL,
0x0000001b00000002ULL, 0x00000000000001acULL, 0x0000001b00000002ULL, 0x00000000000000f4ULL,
0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL, 0x00000000000002c3ULL,
0x0000001b00000002ULL, 0x000000000000021bULL, 0x0000001b00000002ULL, 0x0000000000000185ULL,
0x0000001b00000002ULL, 0x00000000000000d0ULL, 0x0000001b00000002ULL, 0x000000000000f700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000097919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff020424ULL, 0x000fe200078e00ffULL,
0x0000000109040810ULL, 0x002fca0007ffe0ffULL, 0x00005c0004040625ULL, 0x000fc800078e0002ULL,
0x00005c0009020625ULL, 0x000fe400078e0002ULL, 0x0000000604040981ULL, 0x0002a8000c1e1900ULL,
0x0000000602030981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff007a0cULL, 0x000fe40003f65070ULL, 0x0000000000087919ULL, 0x000ee20000002600ULL,
0x00005900ff057624ULL, 0x002fc600078e00ffULL, 0x0000000000117919ULL, 0x000e680000002300ULL,
0x00000000000f7919ULL, 0x000e620000002100ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00067810ULL, 0x010fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x000864000021f000ULL,
0x000000ffff067224ULL, 0x010fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x002fc800078e0a07ULL,
0x000059000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b07077227ULL, 0x000fcc00078e0006ULL,
0x00000400070d7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff027224ULL, 0x008fc800078e0a0dULL,
0x0000040002007624ULL, 0x000fca00078e0205ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d1810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x000000010d0d2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0dba12ULL, 0x000fc800078e33ffULL, 0x0000000d00007306ULL, 0x000e620000209000ULL,
0x000000ff0d00720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00067810ULL, 0x002fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x0002e4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000070d027224ULL, 0x008fc800078e02ffULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a02ULL, 0x0000000000027919ULL, 0x000e640000002200ULL,
0x0000000b07077227ULL, 0x000fcc00078e0006ULL, 0x0000000807787227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a78ULL, 0x000000000d007224ULL, 0x000fca00078e0208ULL,
0x0000000d0000720cULL, 0x000fe20003fa6070ULL, 0x0000010011027a24ULL, 0x002fe400078e0202ULL,
0x00001fff11117589ULL, 0x000fe400000e0000ULL, 0x0000000002137a24ULL, 0x000fca00078e020fULL,
0x000000ff1300720cULL, 0x000fc60003f65270ULL, 0x0000000100005824ULL, 0x000fe200078e0a0dULL,
0x0000000178785810ULL, 0x000fe40007ffe0ffULL, 0x0000000f1300780cULL, 0x040fe40003f24070ULL,
0x0000000d0000720cULL, 0x000fe40003fc6070ULL, 0x00000005ff007819ULL, 0x000fe4000001160fULL,
0x0000007f1300780cULL, 0x040fe40003f44070ULL, 0x000000031300780cULL, 0x000fe20003fa4070ULL,
0x3fffff80ff06b424ULL, 0x000fe200078e00ffULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0x7fffff80ff07b424ULL, 0x000fc400078e00ffULL, 0x3fffffc0ff0a9424ULL, 0x000fe400078e00ffULL,
0x0000000178786810ULL, 0x000fe20007ffe0ffULL, 0x7fffffc0ff0b9424ULL, 0x000fe200078e00ffULL,
0x0000000dff78c212ULL, 0x000fe200078e33ffULL, 0x00f60006ff00b388ULL, 0x0007e20000000a00ULL,
0x000000011300780cULL, 0x000fe20003f64070ULL, 0xff317217ff10a424ULL, 0x000fe400078e00ffULL,
0x000000ffff7b7224ULL, 0x000fe200078e0a78ULL, 0x00f6080a13009388ULL, 0x000fe20000008a00ULL,
0x3fffff80ff0cd424ULL, 0x000fc400078e00ffULL, 0x0000007b0d7b7224ULL, 0x000fe200078e0208ULL,
0x00f400101300a388ULL, 0x0009e20000004800ULL, 0x3fffff60ff06d424ULL, 0x008fe400078e00ffULL,
0x000000107b7b7824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff07d424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0dd424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff0eb424ULL, 0x000fe200078e00ffULL,
0x00f688061300d388ULL, 0x000fe20000008a00ULL, 0x00005a00ff107624ULL, 0x010fc400078e00ffULL,
0x7fffffc0ff0fb424ULL, 0x000fe200078e00ffULL, 0x00f6a80c1300d388ULL, 0x000fe20000008a00ULL,
0x0000590010107a24ULL, 0x000fc600078e02ffULL, 0x00f6c80e1300b388ULL, 0x000fe20000008a00ULL,
0x00000001046a0824ULL, 0x004fe400078e0a03ULL, 0x00005800ff6a8624ULL, 0x000fe400078e00ffULL,
0x0000580009038a24ULL, 0x000fe400078e02ffULL, 0x00005a006a027a24ULL, 0x000fe400078e02ffULL,
0x00000010037c7224ULL, 0x000fe400078e02ffULL, 0x0000000102047824ULL, 0x040fe200078e0a7bULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000007b0200720cULL, 0x000fe20003f26070ULL,
0x0000000411027824ULL, 0x002fe200078e0200ULL, 0x0000001004047817ULL, 0x000fe20003800000ULL,
0x00005a00780f7a24ULL, 0x000fc400078e027cULL, 0x0000000202087824ULL, 0x000fe200078e00ffULL,
0x000000ff04797207ULL, 0x000fc80000800000ULL, 0x000000107900780cULL, 0x000fda0003f05270ULL,
0x000002c000008947ULL, 0x000fea0003800000ULL, 0x00005a0000047b06ULL, 0x000e620000209000ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x00005a00ff007a0cULL, 0x000fcc0003f45070ULL,
0x0000000400047308ULL, 0x002e620000001000ULL, 0x00000004ff0b7819ULL, 0x004fca0000011602ULL,
0x00000001080a7824ULL, 0x000fe200078e020bULL, 0x0ffffffe04067810ULL, 0x002fc60007ffe0ffULL,
0x000000017b047824ULL, 0x000fe200078e020aULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x004fc800078e0a07ULL,
0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL, 0x0000000d07077227ULL, 0x000fcc00078e0006ULL,
0x00000004070c7227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a0cULL,
0x00005a0007067a24ULL, 0x000fca00078e0204ULL, 0x00005a0006007a0cULL, 0x000fda0003f06070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x000000010c0c0810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fda0003f26070ULL, 0x000000010c0c1810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff0caa12ULL, 0x000fca00078e33ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a0cULL,
0x00005a0007047a24ULL, 0x000fe200078e0204ULL, 0x0000000879077217ULL, 0x000fc60007800000ULL,
0x000000010f0d7824ULL, 0x000fe400078e0204ULL, 0x0000001002047824ULL, 0x000fe400078e00ffULL,
0x000000100c067224ULL, 0x000fe400078e020dULL, 0x0000000107087824ULL, 0x000fe200078e0a08ULL,
0x000000f0040d7812ULL, 0x000fe200078ec0ffULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0x000000080b00720cULL, 0x000fe20003f06070ULL, 0x000000010a087824ULL, 0x000fe200078e0202ULL,
0x0000000d060d7212ULL, 0x000fe200078efcffULL, 0x000000100a0b7824ULL, 0x000fc600078e00ffULL,
0x000060000d067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00b087812ULL, 0x000fe400078ee208ULL,
0x0000610007077a10ULL, 0x000fc60000ffe4ffULL, 0x00000010080b7824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e2000c101c46ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00005a00000a7b06ULL, 0x000e620000209000ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000a000a7308ULL, 0x002e620000001000ULL,
0x0000000802087211ULL, 0x004fca00078fe0ffULL, 0x000000017b047824ULL, 0x000fe200078e0208ULL,
0x0ffffffe0a0b7810ULL, 0x002fe20007ffe0ffULL, 0x00000001080a7824ULL, 0x000fc600078e0202ULL,
0x0000000b00077305ULL, 0x000e64000021f000ULL, 0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL,
0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL, 0x0000000d070d7227ULL, 0x000fcc00078e0006ULL,
0x000000040d067227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007077a24ULL, 0x000fca00078e0204ULL, 0x00005a0007007a0cULL, 0x000fda0003f06070ULL,
0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106060810ULL, 0x000fe40007ffe0ffULL,
0x00005a0007007a0cULL, 0x000fda0003f26070ULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff06aa12ULL, 0x000fca00078e33ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fc800078e0204ULL, 0x000000010f077824ULL, 0x000fe400078e0204ULL,
0x0000001002047824ULL, 0x000fe400078e00ffULL, 0x0000001006077224ULL, 0x000fc600078e0207ULL,
0x000000f0040b7812ULL, 0x000fe200078ec0ffULL, 0x0000010007067825ULL, 0x000fca00078e00ffULL,
0x0000000b06067212ULL, 0x000fe200078efcffULL, 0x00000010080b7824ULL, 0x000fc600078e00ffULL,
0x0000600006067a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff00b0a7812ULL, 0x000fe400078ee20aULL,
0x0000610007077a10ULL, 0x000fc600007fe4ffULL, 0x000000100a0b7824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000077919ULL, 0x002e620000000000ULL, 0x0000000000087806ULL, 0x000fe200038e0000ULL,
0x00000004ff427424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000800067300ULL, 0x000e7000000e0000ULL, 0x00000008000a7309ULL, 0x000ea20000000000ULL,
0x000000070600720cULL, 0x002fe20003f02070ULL, 0x0000660009067625ULL, 0x000fc800078e0042ULL,
0x000000ffff0a7224ULL, 0x004fd000078e0a0aULL, 0x00f6040affff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000606687981ULL, 0x000ea2000c1e1900ULL, 0x000000ff1100720cULL, 0x000fe40003f05270ULL,
0x000000ff68087810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff697819ULL, 0x000fce0000011608ULL,
0x0000f42000008947ULL, 0x000fea0003800000ULL, 0x0000000800037824ULL, 0x000fe400078e00ffULL,
0x00000003ff067424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f68c0603ff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0800780cULL, 0x000fe20003f04070ULL, 0x0000000209067824ULL, 0x004fe200078e00ffULL,
0x00000001ff6e7819ULL, 0x000fe20000011600ULL, 0x00f6880003ff7f8cULL, 0x0005e2000c80043fULL,
0x0000000100727812ULL, 0x000fe200078ec0ffULL, 0x0000590006737624ULL, 0x000fe400078e0205ULL,
0x000000206e7d7824ULL, 0x000fc400078e00ffULL, 0x0000000178737824ULL, 0x000fc800078e0273ULL,
0x0000680073057a24ULL, 0x000fe200078e027dULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x0000007d68067217ULL, 0x004fe20007800000ULL, 0x0000001072077824ULL, 0x000fe200078e00ffULL,
0x00000003ff087819ULL, 0x000fc60000011602ULL, 0x0000000106067824ULL, 0x000fe200078e0a7dULL,
0x00000004080b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107097824ULL, 0x000fc600078e0208ULL,
0x0000000706067217ULL, 0x000fe20007800000ULL, 0x00000001090a7824ULL, 0x042fe400078e0202ULL,
0x00000008090d7824ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x000fe400078e0a07ULL,
0x0000000105097824ULL, 0x000fe200078e0209ULL, 0xfffffff80d0e7812ULL, 0x000fe400078ee20aULL,
0x00000008080a7810ULL, 0x000fc40007ffe0ffULL, 0x000000060800720cULL, 0x0c0fe40003f66070ULL,
0x0000000c08087810ULL, 0x000fe40007ffe0ffULL, 0x000000060b00720cULL, 0x080fe20003f46070ULL,
0x00000001070b7824ULL, 0x040fe200078e020bULL, 0x000000060a00720cULL, 0x080fe20003f26070ULL,
0x00000001070a7824ULL, 0x040fe200078e020aULL, 0x000000060800720cULL, 0x000fe20003f06070ULL,
0x00000001070c7824ULL, 0x000fe400078e0208ULL, 0x0000008009067825ULL, 0x000fc800078e00ffULL,
0x0000000105087824ULL, 0x000fe200078e020bULL, 0x00000070060d7812ULL, 0x000fe200078ef804ULL,
0x000000010b097824ULL, 0x040fe400078e0202ULL, 0x000000080b107824ULL, 0x000fe400078e00ffULL,
0x00000001050b7824ULL, 0x040fe400078e020aULL, 0x00000001050f7824ULL, 0x000fe200078e020cULL,
0xfffffff810107812ULL, 0x000fe200078ee209ULL, 0x000000010a057824ULL, 0x000fc400078e0202ULL,
0x000000080a127824ULL, 0x000fe400078e00ffULL, 0x000000010c067824ULL, 0x040fe400078e0202ULL,
0x000000080c117824ULL, 0x000fe200078e00ffULL, 0x000064000d0c7a10ULL, 0x000fe40007f9e0ffULL,
0xfffffff812127812ULL, 0x000fe400078ee205ULL, 0xfffffff811147812ULL, 0x000fe400078ee206ULL,
0x00006500070d7a10ULL, 0x000fe200027fe4ffULL, 0x0000008008067825ULL, 0x000fe200078e00ffULL,
0x0000b0006e057811ULL, 0x000fc600078e68ffULL, 0x000000800b087825ULL, 0x000fc800078e00ffULL,
0x000000800f0a7825ULL, 0x000fc800078e00ffULL, 0x000000100e0f7824ULL, 0x100fe200078e0205ULL,
0x00000070060e7812ULL, 0x100fe200078ef804ULL, 0x0000001010117824ULL, 0x100fe200078e0205ULL,
0x0000007008067812ULL, 0x100fe200078ef804ULL, 0x0000001012137824ULL, 0x100fe200078e0205ULL,
0x000000700a087812ULL, 0x000fe200078ef804ULL, 0x0000001014157824ULL, 0x000fe200078e0205ULL,
0x000064000e047a10ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e2000d901c46ULL, 0x0000640006067a10ULL, 0x000fe40007fbe0ffULL,
0x0000640008087a10ULL, 0x000fc40007fde0ffULL, 0x0000650007057a10ULL, 0x000fe400027fe4ffULL,
0x0000650009077a10ULL, 0x000fe40002ffe4ffULL, 0x000065000b097a10ULL, 0x000fe200037fe4ffULL,
0x0000000004117faeULL, 0x0003e8000d101c46ULL, 0x0000000006137faeULL, 0x0003e8000c901c46ULL,
0x0000000008157faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001072077824ULL, 0x004fe200078e00ffULL, 0x0000b0006e157811ULL, 0x000fc800078e68ffULL,
0x0000000702067211ULL, 0x000fc800078fe8ffULL, 0x0000000406097810ULL, 0x040fe20007ffe0ffULL,
0x0000000106087824ULL, 0x040fe200078e0202ULL, 0x0000000c060c7810ULL, 0x040fe20007ffe0ffULL,
0x00000008060b7824ULL, 0x040fe400078e00ffULL, 0x0000000105077824ULL, 0x000fe400078e0206ULL,
0x00000001090a7824ULL, 0x002fe200078e0202ULL, 0xfffffff80b0e7812ULL, 0x000fe200078ee208ULL,
0x0000000105087824ULL, 0x000fe200078e0209ULL, 0x00000008060b7810ULL, 0x000fe20007ffe0ffULL,
0x0000008007067825ULL, 0x000fc800078e00ffULL, 0x0000000809117824ULL, 0x000fe400078e00ffULL,
0x0000000105097824ULL, 0x040fe400078e020bULL, 0x00000001050f7824ULL, 0x000fe200078e020cULL,
0x0000007006057812ULL, 0x000fe200078ef804ULL, 0x000000010b0d7824ULL, 0x140fe400078e0202ULL,
0x000000080b107824ULL, 0x000fe400078e00ffULL, 0x000000010c067824ULL, 0x000fc400078e0202ULL,
0x000000080c0b7824ULL, 0x000fe200078e00ffULL, 0x00006400050c7a10ULL, 0x000fe40007f1e0ffULL,
0xfffffff810107812ULL, 0x000fe400078ee20dULL, 0xfffffff811057812ULL, 0x000fe400078ee20aULL,
0xfffffff80b127812ULL, 0x000fe200078ee206ULL, 0x000000800f0a7825ULL, 0x000fe200078e00ffULL,
0x00006500070d7a10ULL, 0x000fc600007fe4ffULL, 0x0000008008067825ULL, 0x000fc800078e00ffULL,
0x0000008009087825ULL, 0x000fc800078e00ffULL, 0x0000001005117824ULL, 0x100fe200078e0215ULL,
0x0000007006057812ULL, 0x100fe200078ef804ULL, 0x000000100e0f7824ULL, 0x100fe200078e0215ULL,
0x0000007008067812ULL, 0x100fe200078ef804ULL, 0x0000001010137824ULL, 0x100fe200078e0215ULL,
0x000000700a087812ULL, 0x000fe200078ef804ULL, 0x0000001012157824ULL, 0x000fe200078e0215ULL,
0x0000640005047a10ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e2000b901c46ULL, 0x0000640006067a10ULL, 0x000fe40007f3e0ffULL,
0x0000640008087a10ULL, 0x000fc40007f5e0ffULL, 0x0000650007057a10ULL, 0x000fe400007fe4ffULL,
0x0000650009077a10ULL, 0x000fe40000ffe4ffULL, 0x000065000b097a10ULL, 0x000fe200017fe4ffULL,
0x0000000004117faeULL, 0x0003e8000b901c46ULL, 0x0000000006137faeULL, 0x0003e8000b901c46ULL,
0x0000000008157faeULL, 0x0003e4000b901c46ULL, 0x000000006e0473c2ULL, 0x000ea200000e0000ULL,
0x000000ff6900720cULL, 0x000fe20003f05270ULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x0000f6a86e047811ULL, 0x002fe200078e18ffULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff0a7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200004047f8cULL, 0x000ea2000c80043fULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000d70000008947ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e000bULL,
0x00000002ff757819ULL, 0x000fe20000011600ULL, 0x000000ffff067224ULL, 0x004fc400078e0005ULL,
0xff317217ff307424ULL, 0x000fe400078e00ffULL, 0x000000ffff047224ULL, 0x000fe400078e00ffULL,
0x000000ffff377224ULL, 0x000fc400078e00ffULL, 0x000000ffff107224ULL, 0x02afca00078e00ffULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x0000000400057824ULL, 0x000fca00078e00ffULL,
0xfffffff8050b7812ULL, 0x000fca00078ec0ffULL, 0x00f6cc000b057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804806ULL, 0x0000f6c80b057810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c117210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000110e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc000b0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804806ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000104067810ULL, 0x040fe20007ffe0ffULL,
0x0000010004567824ULL, 0x000fc600078e027dULL, 0x000000690600720cULL, 0x000fe40003f26070ULL,
0x00000040560b7810ULL, 0x000fca0007ffe0ffULL, 0x0000680073127a24ULL, 0x000fcc00078e020bULL,
0x0000040000009947ULL, 0x000fea0003800000ULL, 0x0000000b68067217ULL, 0x000fe20007800000ULL,
0x00000010720d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff0c7819ULL, 0x000fc60000011602ULL,
0x0000000106067824ULL, 0x000fe200078e0a0bULL, 0x000000040c0e7810ULL, 0x000fe20007ffe0ffULL,
0x000000010d0f7824ULL, 0x000fc600078e020cULL, 0x000000060d067217ULL, 0x000fe20007800000ULL,
0x000000010f0b7824ULL, 0x040fe400078e0202ULL, 0x000000080f107824ULL, 0x000fe400078e00ffULL,
0x0000000106067824ULL, 0x000fe400078e0a0dULL, 0x000000010d117824ULL, 0x000fe200078e020eULL,
0xfffffff810217812ULL, 0x000fe200078ee20bULL, 0x00000010020b7824ULL, 0x000fe200078e00ffULL,
0x000000060e00720cULL, 0x000fe20003f66070ULL, 0x0000000811237824ULL, 0x000fe200078e00ffULL,
0x000000080c0e7810ULL, 0x000fc40007ffe0ffULL, 0x000000060c00720cULL, 0x0c0fe40003f86070ULL,
0x0000000c0c107810ULL, 0x000fe20007ffe0ffULL, 0x00000001110c7824ULL, 0x000fe200078e0202ULL,
0x000000060e00720cULL, 0x080fe20003f46070ULL, 0x000000010d137824ULL, 0x040fe200078e020eULL,
0x000000061000720cULL, 0x000fe20003f06070ULL, 0x000000010d337824ULL, 0x000fe200078e0210ULL,
0xfffffff823237812ULL, 0x000fe200078ee20cULL, 0x000000010f0c7824ULL, 0x100fe200078e0212ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x00000001110e7824ULL, 0x000fc400078e0212ULL,
0x0000000113107824ULL, 0x040fe400078e0212ULL, 0x0000000113067824ULL, 0x100fe400078e0202ULL,
0x0000000133117824ULL, 0x040fe400078e0202ULL, 0x0000000833207824ULL, 0x000fe400078e00ffULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff8203d7812ULL, 0x000fe200078ee211ULL,
0x0000000813137824ULL, 0x000fe200078e00ffULL, 0x0000000b0c0c7212ULL, 0x000fe200078efcffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0x000064000c0c7a10ULL, 0x000fe20007fbe0ffULL,
0x0000000133127824ULL, 0x000fe200078e0212ULL, 0xfffffff813337812ULL, 0x000fe200078ee206ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000b0e0e7212ULL, 0x080fe400078efcffULL,
0x0000c0006e067811ULL, 0x000fe200078e68ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000064000e0e7a10ULL, 0x000fe40007fde0ffULL, 0x0000000b10107212ULL, 0x000fc400078efcffULL,
0x0000000b12127212ULL, 0x000fe200078efcffULL, 0x00000010210b7824ULL, 0x100fe200078e0206ULL,
0x000065000d0d7a10ULL, 0x000fe20002ffe4ffULL, 0x0000001023217824ULL, 0x100fe200078e0206ULL,
0x000065000f0f7a10ULL, 0x000fe200037fe4ffULL, 0x0000001033237824ULL, 0x100fe200078e0206ULL,
0x0000640010107a10ULL, 0x000fe20007fbe0ffULL, 0x000000103d337824ULL, 0x000fe200078e0206ULL,
0x0000640012127a10ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e2000e101c46ULL, 0x0000650011117a10ULL, 0x000fc40002ffe4ffULL,
0x0000650013137a10ULL, 0x000fe200037fe4ffULL, 0x000000000e217faeULL, 0x0003e8000d901c46ULL,
0x0000000010237faeULL, 0x0003e8000d101c46ULL, 0x0000000012337faeULL, 0x0003e2000c101c46ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x00000010720b7824ULL, 0x000fe200078e00ffULL,
0x0000c0006e337811ULL, 0x000fe200078e68ffULL, 0x0000001002067824ULL, 0x000fc600078e00ffULL,
0x0000000b020b7211ULL, 0x000fe400078fe8ffULL, 0x0000007006237812ULL, 0x000fe400078ec0ffULL,
0x000000040b0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000010b0d7824ULL, 0x040fe200078e0202ULL,
0x000000080b117810ULL, 0x040fe20007ffe0ffULL, 0x000000080b0e7824ULL, 0x040fe200078e00ffULL,
0x0000000c0b137810ULL, 0x040fe20007ffe0ffULL, 0x000000010b0c7824ULL, 0x000fe400078e0212ULL,
0x000000010f0b7824ULL, 0x040fe200078e0202ULL, 0xfffffff80e067812ULL, 0x000fe200078ee20dULL,
0x000000010f0e7824ULL, 0x000fc400078e0212ULL, 0x000000080f207824ULL, 0x000fe400078e00ffULL,
0x0000000111107824ULL, 0x040fe400078e0212ULL, 0x00000001110f7824ULL, 0x040fe200078e0202ULL,
0xfffffff820207812ULL, 0x000fe200078ee20bULL, 0x0000000811227824ULL, 0x000fe400078e00ffULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee20fULL,
0x0000000113117824ULL, 0x040fe200078e0202ULL, 0x000000230c0c7212ULL, 0x080fe200078efcffULL,
0x0000000813327824ULL, 0x040fe400078e00ffULL, 0x0000000113127824ULL, 0x000fe200078e0212ULL,
0x000064000c0c7a10ULL, 0x000fe20007f1e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff832327812ULL, 0x000fe400078ee211ULL, 0x000065000d0d7a10ULL, 0x000fe200007fe4ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000230e0e7212ULL, 0x000fc600078efcffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000002310107212ULL, 0x080fe400078efcffULL,
0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x00000010060b7824ULL, 0x100fe200078e0233ULL,
0x0000002312127212ULL, 0x000fe200078efcffULL, 0x0000001020217824ULL, 0x100fe200078e0233ULL,
0x0000640010107a10ULL, 0x000fe20007f5e0ffULL, 0x0000001022237824ULL, 0x100fe200078e0233ULL,
0x0000640012127a10ULL, 0x000fe20007f7e0ffULL, 0x0000001032337824ULL, 0x000fe200078e0233ULL,
0x000065000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e2000b901c46ULL, 0x0000650011117a10ULL, 0x000fc400017fe4ffULL,
0x0000650013137a10ULL, 0x000fe20001ffe4ffULL, 0x000000000e217faeULL, 0x0003e8000b901c46ULL,
0x0000000010237faeULL, 0x0003e8000b901c46ULL, 0x0000000012337faeULL, 0x0003e4000b901c46ULL,
0xfffffff003127812ULL, 0x042fe400078ec0ffULL, 0xffffffe003067812ULL, 0x000fc400078ec0ffULL,
0x00000000120573c2ULL, 0x000e6200000e0000ULL, 0x00000010030b7812ULL, 0x000fca00078ec0ffULL,
0x00000001060b7824ULL, 0x000fe400078e020bULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000872107824ULL, 0x000fe200078e020bULL, 0x0000f6b005057890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6b00012127f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6080010107f8cULL, 0x000ea4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x0000000803067812ULL, 0x000fca00078ec0ffULL,
0x000000010b067824ULL, 0x000fca00078e0206ULL, 0x00f60c00060b7984ULL, 0x000ee40000000800ULL,
0x800000000bff7812ULL, 0x00cfe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000102000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c0e7210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc8000001140fULL,
0x0000000e0b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e060fULL,
0x000000020b0b7819ULL, 0x000fc8000000120eULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000120207810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f60c00060b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001002607824ULL, 0x000fe200078e00ffULL,
0x00000001ff657819ULL, 0x000fe20000011602ULL, 0x00000020000b7824ULL, 0x000fe400078e00ffULL,
0xffffffffff747424ULL, 0x000fe200078e00ffULL, 0x0000007060607812ULL, 0x000fc400078ec0ffULL,
0xffffff800b0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c65657812ULL, 0x000fc800078ec0ffULL,
0x0000000b650b7210ULL, 0x000fca0007ffe060ULL, 0x00f000000b0d7984ULL, 0x000ea80000000800ULL,
0x00f200000b0e7984ULL, 0x0006620000000800ULL, 0x000000300d00720bULL, 0x004fe20003f1d000ULL,
0x000147c27f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff3c207812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff0c7224ULL, 0x000fc400078e0030ULL,
0x0000001fff777424ULL, 0x000fe400078e00ffULL, 0xffffffffff767424ULL, 0x000fca00078e00ffULL,
0x0000043000008947ULL, 0x000fea0003800000ULL, 0x000000007500720cULL, 0x000fe40003f05270ULL,
0x000000300d00720bULL, 0x000fe20003f54000ULL, 0x000147527f007947ULL, 0x000fd8000b800000ULL,
0x00000000000f7806ULL, 0x000fc400010e0100ULL, 0x0000008000108824ULL, 0x000fe200078e0260ULL,
0x000000300d0c7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x0000000165118824ULL, 0x000fe200078e0210ULL, 0x000099100f107816ULL, 0x000fc800000000ffULL,
0x00f4000c11008388ULL, 0x0005e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x000000300c107221ULL, 0x004fe20000010100ULL,
0x000000ff0fff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000217308ULL, 0x000ea40000000800ULL,
0x0000002131317220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe20000011602ULL, 0x000146827f007947ULL, 0x000fea000b800000ULL,
0x00001f10213c7589ULL, 0x0004e400000e0000ULL, 0x0000003c38387220ULL, 0x08cfe20000410000ULL,
0x0000003c39397220ULL, 0x080fe20000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000003c18187220ULL, 0x080fe20000410000ULL,
0x0000003c19197220ULL, 0x080fe20000410000ULL, 0x0000003c14147220ULL, 0x080fe20000410000ULL,
0x0000003c15157220ULL, 0x080fe20000410000ULL, 0x0000003c24247220ULL, 0x080fe20000410000ULL,
0x0000003c25257220ULL, 0x080fe20000410000ULL, 0x0000003c28287220ULL, 0x080fe20000410000ULL,
0x0000003c29297220ULL, 0x080fe20000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000003c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000003c34347220ULL, 0x080fe20000410000ULL,
0x0000003c35357220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000fff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802107811ULL, 0x000fe200078ff0ffULL, 0x000145627f007947ULL, 0x000fea000b800000ULL,
0x00001f10213c7589ULL, 0x0004e400000e0000ULL, 0x0000003c3a3a7220ULL, 0x08cfe20000410000ULL,
0x0000003c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000003c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003c16167220ULL, 0x080fe20000410000ULL,
0x0000003c17177220ULL, 0x080fe20000410000ULL, 0x0000003c26267220ULL, 0x080fe20000410000ULL,
0x0000003c27277220ULL, 0x080fe20000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000003c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000003c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000003c36367220ULL, 0x080fe20000410000ULL,
0x0000003c37377220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff20ff7812ULL, 0x000fda000780600fULL, 0x8000000c0d0d0221ULL, 0x000fe20000010000ULL,
0x00007610ff0b0816ULL, 0x000fc6000000000bULL, 0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL,
0x0000000d00070308ULL, 0x000ea40000000800ULL, 0x000000070e0e0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000310e0d7221ULL, 0x002fc40000010000ULL,
0x00000000000e7805ULL, 0x000fca0000015200ULL, 0xfffffff003227812ULL, 0x000fca00078ec0ffULL,
0x00f6ac0022117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff207224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100e217210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0fULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011411ULL,
0x0000002110107211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x0000000210107819ULL, 0x000fc80000001211ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000120207810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0022117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe4000780480aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100b0a7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000010ffULL, 0x00000002ff0a7819ULL, 0x000fe40000011602ULL,
0x00005410080b7816ULL, 0x000fe20000000008ULL, 0x000141427f007947ULL, 0x000fea000b800000ULL,
0x00001f0a0b087589ULL, 0x0002a400000e0000ULL, 0x000000080a107810ULL, 0x000fe20007ffe0ffULL,
0x000141727f007947ULL, 0x000fea000b800000ULL, 0x00001f100b097589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100a107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200078e000bULL, 0x00002e50003d7802ULL, 0x000fc40000000f00ULL,
0x00014b4000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180a107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200078e000bULL,
0x00002ea0003d7802ULL, 0x000fc40000000f00ULL, 0x00014af000007944ULL, 0x006fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000007020e7812ULL, 0x000fe200078ec0ffULL,
0x00000200000b7824ULL, 0x00afe200078e00ffULL, 0x00000004ff117819ULL, 0x100fe20000011602ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000080e5d7812ULL, 0x000fc600078ef802ULL,
0x000000046e0a7824ULL, 0x000fe400078e0211ULL, 0x000000085d107824ULL, 0x040fe400078e00ffULL,
0x000000015d497824ULL, 0x000fe200078e020aULL, 0xfffff8000b0a7812ULL, 0x000fe400078ec0ffULL,
0x00000008020b7812ULL, 0x000fe400078ec0ffULL, 0xfffffff8100f7812ULL, 0x000fca00078ee249ULL,
0x000000100f307824ULL, 0x000fc400078e020aULL, 0x0000000e0b0f7212ULL, 0x040fe200078efcffULL,
0x00000004725e7824ULL, 0x000fe200078e0211ULL, 0x0000b0006e647811ULL, 0x000fe400078e68ffULL,
0x000000100b0b7812ULL, 0x000fe200078efe0eULL, 0x000000010f317824ULL, 0x000fe200078e025eULL,
0x0000000249497810ULL, 0x000fe20007ffe0ffULL, 0x000000080f107824ULL, 0x040fe400078e00ffULL,
0x000000080f327824ULL, 0x000fe400078e00ffULL, 0x000000015e5e7824ULL, 0x000fe200078e020bULL,
0xfffffff810117812ULL, 0x000fe200078ee231ULL, 0x000000080b217824ULL, 0x000fe200078e00ffULL,
0x0000000231317810ULL, 0x000fc60007ffe0ffULL, 0x0000001011117824ULL, 0x000fe200078e0264ULL,
0xfffffff832317812ULL, 0x000fe400078ee231ULL, 0xfffffff821217812ULL, 0x000fe400078ee25eULL,
0x00000000113c783bULL, 0x004e620000004200ULL, 0x0000001031407824ULL, 0x100fe400078e0264ULL,
0x0000001021217824ULL, 0x000fe200078e0264ULL, 0x009000003030783bULL, 0x000ea80000000200ULL,
0x000000004040783bULL, 0x000fe80000004200ULL, 0x000000002120783bULL, 0x000ee20000004200ULL,
0x000001003c617824ULL, 0x002fe200078e00ffULL, 0x0000003c00547306ULL, 0x000fe20000009400ULL,
0x000001003d587824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe2000001143cULL,
0x0000000830308231ULL, 0x084fe200003400ffULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000000832328231ULL, 0x000fe200003400ffULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0000000931318231ULL, 0x080fe200003400ffULL, 0x0000003c00517306ULL, 0x000e620000005400ULL,
0x00000018ff597819ULL, 0x000fe2000001143dULL, 0x0000000933338231ULL, 0x000fcc00003400ffULL,
0x0000003d00527306ULL, 0x000ff00000009400ULL, 0x0000003d00537306ULL, 0x000ea20000005400ULL,
0x000000515400720bULL, 0x002fce0003f5d000ULL, 0x00000061005f7306ULL, 0x000ff00000209400ULL,
0x00000061006a7306ULL, 0x0003220000205400ULL, 0x000000535200720bULL, 0x004fce0003f9d000ULL,
0x00000058006b7306ULL, 0x000fe20000209400ULL, 0x0000006100617245ULL, 0x002fce000020d400ULL,
0x00000058006c7306ULL, 0x0002a20000205400ULL, 0x0000006a5f00720bULL, 0x010fce0003f7d000ULL,
0x0000003c004e7306ULL, 0x0008e2000000d400ULL, 0x0000005800587245ULL, 0x002fca000020d400ULL,
0x0000000161613812ULL, 0x000fe400078efcffULL, 0x0000003d004f7306ULL, 0x000262000000d400ULL,
0x000100003c3c7824ULL, 0x010fe200078e00ffULL, 0x0000006c6b00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000000014e4e2812ULL, 0x008fe200078efcffULL,
0x000100003d3d7824ULL, 0x002fe200078e00ffULL, 0x0000003c006a7306ULL, 0x000fe40000209400ULL,
0x0000004e614e723eULL, 0x000fe400000010ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x000000014f4f4812ULL, 0x000fc400078efcffULL, 0x0000003c006b7306ULL, 0x0002a20000205400ULL,
0x0000000158585812ULL, 0x000fc800078efcffULL, 0x0000004f584f723eULL, 0x000fc600000010ffULL,
0x0000005500627306ULL, 0x000fe20000209400ULL, 0x0000003c003c7245ULL, 0x002fc6000020d400ULL,
0x0000004e3038723cULL, 0x000be80000041838ULL, 0x0000005500637306ULL, 0x0002e20000205400ULL,
0x0000006b6a00720bULL, 0x004fe40003f9d000ULL, 0x000001003e4e7824ULL, 0x020fe400078e00ffULL,
0x000001003f4f7824ULL, 0x000fc600078e00ffULL, 0x0000005900667306ULL, 0x000fe20000209400ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000005500557245ULL, 0x002fe4000020d400ULL, 0x000000013c3c4812ULL, 0x000fe200078efcffULL,
0x0000005900677306ULL, 0x000e620000205400ULL, 0x000000636200720bULL, 0x008fe40003fdd000ULL,
0x0000005900627245ULL, 0x000fca000020d400ULL, 0x0000003d006b7306ULL, 0x000fec0000209400ULL,
0x0000000155556812ULL, 0x000fe400078efcffULL, 0x0000003d006c7306ULL, 0x0004e20000205400ULL,
0x000000676600720bULL, 0x002fe40003fbd000ULL, 0x0000003c553c723eULL, 0x000fc400000010ffULL,
0x00000018ff557819ULL, 0x000fc6000001143eULL, 0x0000003e00577306ULL, 0x000fe20000009400ULL,
0x0000003d003d7245ULL, 0x004fca000020d400ULL, 0x0000000162625812ULL, 0x000fe400078efcffULL,
0x0000003e005a7306ULL, 0x000e620000005400ULL, 0x0000006c6b00720bULL, 0x008fce0003f9d000ULL,
0x0000003f005b7306ULL, 0x000fec0000009400ULL, 0x000000013d3d4812ULL, 0x000fe400078efcffULL,
0x0000003f005c7306ULL, 0x000ea20000005400ULL, 0x0000005a5700720bULL, 0x002fe40003f5d000ULL,
0x0000003d623d723eULL, 0x000fca00000010ffULL, 0x0000004e006a7306ULL, 0x000fe40000209400ULL,
0x0000003c301c723cULL, 0x000b6c000004181cULL, 0x0000004e00637306ULL, 0x000e620000205400ULL,
0x0000005c5b00720bULL, 0x004fe40003f7d000ULL, 0x0000004e003c7245ULL, 0x020fc4000020d400ULL,
0x0000004f003d7245ULL, 0x000fc6000020d400ULL, 0x0000004f00667306ULL, 0x000ff00000209400ULL,
0x0000004f00677306ULL, 0x0004e20000205400ULL, 0x000000636a00720bULL, 0x002fce0003fdd000ULL,
0x0000003e004d7306ULL, 0x000e62000000d400ULL, 0x00000018ff4f7819ULL, 0x004fca0000011421ULL,
0x000000013c3c6812ULL, 0x000fe400078efcffULL, 0x0000003f00507306ULL, 0x000ea2000000d400ULL,
0x000000676600720bULL, 0x008fe40003f9d000ULL, 0x00000018ff667819ULL, 0x000fe4000001143fULL,
0x000000014d4d2812ULL, 0x002fc600078efcffULL, 0x0000005500627306ULL, 0x000fe20000209400ULL,
0x0000004d3c3c723eULL, 0x000fca00000010ffULL, 0x000000013d3d4812ULL, 0x000fe400078efcffULL,
0x0000000150503812ULL, 0x004fe200078efcffULL, 0x0000005500637306ULL, 0x000e620000205400ULL,
0x00000018ff4d7819ULL, 0x000fe40000011420ULL, 0x000000503d3d723eULL, 0x000fca00000010ffULL,
0x0000004100527306ULL, 0x000fe40000009400ULL, 0x0000003c3018723cULL, 0x000b6c0000041818ULL,
0x0000004100537306ULL, 0x000ea20000005400ULL, 0x000100003e3d7824ULL, 0x020fe200078e00ffULL,
0x000000636200720bULL, 0x002fe20003fdd000ULL, 0x000100003f3c7824ULL, 0x000fc400078e00ffULL,
0x0000010040637824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000004000517306ULL, 0x000fe20000009400ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff637819ULL, 0x000fca0000011463ULL, 0x0000003d003e7306ULL, 0x000fe20000209400ULL,
0x000000535200720bULL, 0x004fce0003f7d000ULL, 0x0000003d003f7306ULL, 0x0002b00000205400ULL,
0x0000004000547306ULL, 0x000ee20000005400ULL, 0x0000003d003d7245ULL, 0x002fce000020d400ULL,
0x0000006600677306ULL, 0x000fe20000209400ULL, 0x0000003f3e00720bULL, 0x004fe20003fbd000ULL,
0x00000100413f7824ULL, 0x000fe200078e00ffULL, 0x00000055003e7245ULL, 0x000fc8000020d400ULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x00000066006a7306ULL, 0x0002a20000205400ULL,
0x000000545100720bULL, 0x008fe40003f9d000ULL, 0x000000013e3e6812ULL, 0x000fc600078efcffULL,
0x000000013d3d5812ULL, 0x000fe400078efcffULL, 0x0000003c00527306ULL, 0x000fe20000209400ULL,
0x0000006600667245ULL, 0x002fce000020d400ULL, 0x0000003c00537306ULL, 0x000e620000205400ULL,
0x0000006a6700720bULL, 0x004fe20003f5d000ULL, 0x00000100426a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000006300547306ULL, 0x000fec0000209400ULL,
0x0000000166662812ULL, 0x000fe400078efcffULL, 0x0000006300677306ULL, 0x000ea20000205400ULL,
0x000000535200720bULL, 0x002fc40003fbd000ULL, 0x00000018ff537819ULL, 0x000fca0000011422ULL,
0x0000003f00627306ULL, 0x000ff00000209400ULL, 0x0000003f006b7306ULL, 0x000e620000205400ULL,
0x000000675400720bULL, 0x004fe40003fdd000ULL, 0x0000003c00677245ULL, 0x000fc4000020d400ULL,
0x0000003d3e3c723eULL, 0x000fe400000010ffULL, 0x0000000167675812ULL, 0x000fe200078efcffULL,
0x00000040005f7306ULL, 0x0004e6000000d400ULL, 0x00000067663d723eULL, 0x000fe400000010ffULL,
0x0000006300667245ULL, 0x000fe4000020d400ULL, 0x00000018ff637819ULL, 0x000fe20000011441ULL,
0x0000004100617306ULL, 0x000922000000d400ULL, 0x0000006b6200720bULL, 0x002fe20003fbd000ULL,
0x0000003c3014723cULL, 0x000b620000041814ULL, 0x0000000166666812ULL, 0x000fc400078efcffULL,
0x00000018ff627819ULL, 0x000fe20000011440ULL, 0x0001000040407824ULL, 0x004fe200078e00ffULL,
0x000000015f5f4812ULL, 0x008fe400078efcffULL, 0x00000062003e7306ULL, 0x000fe20000209400ULL,
0x0001000041417824ULL, 0x010fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000005f663c723eULL, 0x020fe400000010ffULL, 0x0000003f00667245ULL, 0x000fc4000020d400ULL,
0x0000000161613812ULL, 0x000fe200078efcffULL, 0x0000006200677306ULL, 0x000e620000205400ULL,
0x0000000166665812ULL, 0x000fe400078efcffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000061663d723eULL, 0x000fe400000010ffULL, 0x00000018ff5f7819ULL, 0x000fe20000011423ULL,
0x0000004000617306ULL, 0x000fe80000209400ULL, 0x0000003c3024723cULL, 0x000b680000041824ULL,
0x00000040003c7306ULL, 0x0204e20000205400ULL, 0x000000673e00720bULL, 0x002fc40003f7d000ULL,
0x0000006200677245ULL, 0x000fe4000020d400ULL, 0x0000006300627245ULL, 0x000fc6000020d400ULL,
0x00000063003f7306ULL, 0x000fe20000209400ULL, 0x0000004000407245ULL, 0x004fca000020d400ULL,
0x0000000167673812ULL, 0x000fe400078efcffULL, 0x0000006300667306ULL, 0x000e620000205400ULL,
0x0000003c6100720bULL, 0x008fce0003f5d000ULL, 0x00000041003d7306ULL, 0x000fec0000209400ULL,
0x0000000140402812ULL, 0x000fe400078efcffULL, 0x00000041003e7306ULL, 0x0004e20000205400ULL,
0x000000663f00720bULL, 0x002fe20003fbd000ULL, 0x000000080b667824ULL, 0x000fe200078e00ffULL,
0x000000025e3f7810ULL, 0x000fc40007ffe0ffULL, 0x000000406740723eULL, 0x000fe200000010ffULL,
0x0000010043677824ULL, 0x000fe200078e00ffULL, 0xfffffff8663f7812ULL, 0x000fe200078ee23fULL,
0x00000043005b7306ULL, 0x000fe20000009400ULL, 0x00000018ff667819ULL, 0x000fe40000011442ULL,
0x0000004100417245ULL, 0x004fe2000020d400ULL, 0x000000103f3f7824ULL, 0x000fe200078e0264ULL,
0x00000018ff677819ULL, 0x000fe40000011467ULL, 0x0000000162625812ULL, 0x000fe200078efcffULL,
0x00000043005c7306ULL, 0x000e620000005400ULL, 0x0000003e3d00720bULL, 0x008fc40003f9d000ULL,
0x000000003f3c783bULL, 0x000eaa0000004200ULL, 0x00000066006b7306ULL, 0x000fec0000209400ULL,
0x0000000141414812ULL, 0x000fc400078efcffULL, 0x00000066006c7306ULL, 0x000ee20000205400ULL,
0x0000005c5b00720bULL, 0x002fe40003f5d000ULL, 0x000000416241723eULL, 0x000fe400000010ffULL,
0x00000018ff5c7819ULL, 0x000fc60000011443ULL, 0x0000004200587306ULL, 0x000fe40000009400ULL,
0x000000403028723cULL, 0x000b6c0000041828ULL, 0x0000004200577306ULL, 0x000e620000005400ULL,
0x0000006c6b00720bULL, 0x008fe20003f7d000ULL, 0x00010000426b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001146bULL, 0x0000006a006d7306ULL, 0x000ff00000209400ULL,
0x0000006a006f7306ULL, 0x000ee20000205400ULL, 0x000000575800720bULL, 0x002fce0003fdd000ULL,
0x0000006700707306ULL, 0x000ff00000209400ULL, 0x0000006700717306ULL, 0x000e620000205400ULL,
0x0000006f6d00720bULL, 0x008fce0003f9d000ULL, 0x00000042005a7306ULL, 0x000ef0000000d400ULL,
0x0000004300597306ULL, 0x0008a2000000d400ULL, 0x000000717000720bULL, 0x002fce0003fbd000ULL,
0x0000005c00407306ULL, 0x020fe20000209400ULL, 0x0001000043437824ULL, 0x010fe200078e00ffULL,
0x000000015a5a6812ULL, 0x008fc800078efcffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000005c00417306ULL, 0x000e620000205400ULL, 0x0000000159592812ULL, 0x004fce00078efcffULL,
0x0000006b00427306ULL, 0x000ff00000209400ULL, 0x0000006b006d7306ULL, 0x000ea20000205400ULL,
0x000000414000720bULL, 0x002fe40003fdd000ULL, 0x0000006a00417245ULL, 0x000fc4000020d400ULL,
0x00000067006a7245ULL, 0x000fe4000020d400ULL, 0x0000000141414812ULL, 0x000fe200078efcffULL,
0x00000043006c7306ULL, 0x000fe20000209400ULL, 0x000000016a6a5812ULL, 0x000fe400078efcffULL,
0x0000005a4140723eULL, 0x000fe400000010ffULL, 0x000000596a41723eULL, 0x000fe200000010ffULL,
0x00010000226a7824ULL, 0x000fe200078e00ffULL, 0x0000005c00677245ULL, 0x000fe2000020d400ULL,
0x00000043006f7306ULL, 0x000e620000205400ULL, 0x0000006d4200720bULL, 0x004fc40003f5d000ULL,
0x00000043005c7245ULL, 0x000fe2000020d400ULL, 0x00000040302c723cULL, 0x000b62000004182cULL,
0x0000000167676812ULL, 0x000fe400078efcffULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x0000002000467306ULL, 0x000fe60000009400ULL, 0x0000006600417245ULL, 0x020fe4000020d400ULL,
0x0000006b00407245ULL, 0x000fc4000020d400ULL, 0x0000000141413812ULL, 0x000fe200078efcffULL,
0x0000002000447306ULL, 0x000ea20000005400ULL, 0x0000006f6c00720bULL, 0x002fe20003f9d000ULL,
0x00000100216f7824ULL, 0x000fe200078e00ffULL, 0x0000000140402812ULL, 0x000fc800078efcffULL,
0x000000404140723eULL, 0x000fe200000010ffULL, 0x00000021004c7306ULL, 0x000fe20000009400ULL,
0x00000018ff6f7819ULL, 0x000fca000001146fULL, 0x000000015c5c4812ULL, 0x000fe400078efcffULL,
0x0000002100487306ULL, 0x000e620000005400ULL, 0x000000444600720bULL, 0x004fe40003f7d000ULL,
0x0000005c6741723eULL, 0x000fe200000010ffULL, 0x0001000020677824ULL, 0x000fc800078e00ffULL,
0x0000002200477306ULL, 0x000fe20000009400ULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x000000403034723cULL, 0x000b6c0000041834ULL, 0x0000002200457306ULL, 0x000ea20000005400ULL,
0x0000010020317824ULL, 0x020fe200078e00ffULL, 0x000000484c00720bULL, 0x002fe20003fdd000ULL,
0x0001000021417824ULL, 0x000fc400078e00ffULL, 0x00000100234c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0000002100117306ULL, 0x000e62000000d400ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x000000454700720bULL, 0x004fca0003f9d000ULL, 0x0000003100327306ULL, 0x000ff00000209400ULL,
0x00000031006b7306ULL, 0x000ea20000205400ULL, 0x0000000111116812ULL, 0x002fce00078efcffULL,
0x00000041006d7306ULL, 0x000ff00000209400ULL, 0x0000004100467306ULL, 0x000e620000205400ULL,
0x0000006b3200720bULL, 0x004fe20003fbd000ULL, 0x000000085d327824ULL, 0x000fca00078e00ffULL,
0xfffffff832497812ULL, 0x000fe200078ee249ULL, 0x0000002000107306ULL, 0x0004e8000000d400ULL,
0x0000001049447824ULL, 0x000fc800078e020aULL, 0x0000004d004e7306ULL, 0x000fe20000209400ULL,
0x0000010022207824ULL, 0x004fe200078e00ffULL, 0x000000466d00720bULL, 0x002fe20003fdd000ULL,
0x000001003c6d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe4000001143dULL,
0x00000018ff5d7819ULL, 0x000fe40000011420ULL, 0x0000004d00507306ULL, 0x0002a20000205400ULL,
0x0000003100207245ULL, 0x000fe4000020d400ULL, 0x0000000110103812ULL, 0x008fc400078efcffULL,
0x0000000120205812ULL, 0x000fe400078efcffULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000006700307306ULL, 0x000fe20000209400ULL, 0x0000004d004d7245ULL, 0x002fe4000020d400ULL,
0x000000102020723eULL, 0x000fca00000010ffULL, 0x0000006700337306ULL, 0x000e620000205400ULL,
0x000000504e00720bULL, 0x004fe40003f7d000ULL, 0x0000004100507245ULL, 0x000fe4000020d400ULL,
0x00000018ff417819ULL, 0x000fe4000001143eULL, 0x0000000150506812ULL, 0x000fe200078efcffULL,
0x0000005d00487306ULL, 0x000fec0000209400ULL, 0x000000014d4d3812ULL, 0x000fc400078efcffULL,
0x0000005d00457306ULL, 0x0004e20000205400ULL, 0x000000333000720bULL, 0x002fe40003fbd000ULL,
0x009000004430783bULL, 0x000e6a0000000200ULL, 0x0000006f006c7306ULL, 0x000fe20000209400ULL,
0x0000005d005d7245ULL, 0x004fce000020d400ULL, 0x0000006f00217306ULL, 0x000fe20000205400ULL,
0x000000454800720bULL, 0x008fe40003fdd000ULL, 0x00000018ff457819ULL, 0x000fca000001143fULL,
0x0000004c00477306ULL, 0x000fec0000209400ULL, 0x000000015d5d6812ULL, 0x000fe400078efcffULL,
0x0000004c00497306ULL, 0x000eb00000205400ULL, 0x00000022000e7306ULL, 0x000722000000d400ULL,
0x0000000830308231ULL, 0x002fc400003400ffULL, 0x0000000832328231ULL, 0x000fe400003400ffULL,
0x0000000931318231ULL, 0x000fc600003400ffULL, 0x0000003d00587306ULL, 0x000fe20000009400ULL,
0x0000006700227245ULL, 0x008fe2000020d400ULL, 0x0001000023677824ULL, 0x000fe200078e00ffULL,
0x000000494700720bULL, 0x004fe20003fdd000ULL, 0x0000000933338231ULL, 0x000fe200003400ffULL,
0x0000000122225812ULL, 0x000fe400078efcffULL, 0x000000216c00720bULL, 0x000fe20003fbd000ULL,
0x0000003d005b7306ULL, 0x000e620000005400ULL, 0x000000010e0e4812ULL, 0x010fe400078efcffULL,
0x00000018ff677819ULL, 0x000fc40000011467ULL, 0x0000006f00217245ULL, 0x000fe4000020d400ULL,
0x000000224d10723eULL, 0x000fe200000010ffULL, 0x0000004f00517306ULL, 0x000fe20000209400ULL,
0x0000000e5d0e723eULL, 0x000fc600000010ffULL, 0x0000000121215812ULL, 0x000fc800078efcffULL,
0x0000004f00527306ULL, 0x000ea20000205400ULL, 0x0000005b5800720bULL, 0x002fe40003f9d000ULL,
0x0000004c005b7245ULL, 0x000fe4000020d400ULL, 0x0000005300587245ULL, 0x000fe4000020d400ULL,
0x000000015b5b6812ULL, 0x000fe200078efcffULL, 0x0000006a006b7306ULL, 0x000fe20000209400ULL,
0x000000112121723eULL, 0x000fce00000010ffULL, 0x0000006a006c7306ULL, 0x000e620000205400ULL,
0x000000525100720bULL, 0x004fce0003f7d000ULL, 0x00000023004a7306ULL, 0x000ff00000009400ULL,
0x00000023004b7306ULL, 0x000ea20000005400ULL, 0x0000006c6b00720bULL, 0x002fce0003fdd000ULL,
0x0000005300547306ULL, 0x000ff00000209400ULL, 0x0000005300557306ULL, 0x000e620000205400ULL,
0x0000004b4a00720bULL, 0x004fe40003f5d000ULL, 0x00000018ff4a7819ULL, 0x000fca000001143cULL,
0x0000003c00627306ULL, 0x000ff00000009400ULL, 0x0000003c00637306ULL, 0x000ea20000005400ULL,
0x000000555400720bULL, 0x002fe40003fbd000ULL, 0x0000004f00547245ULL, 0x000fc4000020d400ULL,
0x0000006a00557245ULL, 0x000fe4000020d400ULL, 0x0000000154543812ULL, 0x000fe200078efcffULL,
0x0000006700517306ULL, 0x000fe20000209400ULL, 0x0000000155556812ULL, 0x000fe400078efcffULL,
0x00000067004f7245ULL, 0x000fe4000020d400ULL, 0x000000505411723eULL, 0x000fe400000010ffULL,
0x0000000158585812ULL, 0x000fe200078efcffULL, 0x0000006700527306ULL, 0x000e620000205400ULL,
0x000000636200720bULL, 0x004fe20003f7d000ULL, 0x000001003d637824ULL, 0x000fc400078e00ffULL,
0x00000010301c723cULL, 0x000b66000004181cULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x00000023000f7306ULL, 0x000ea6000000d400ULL, 0x000000555810723eULL, 0x020fca00000010ffULL,
0x0000003e00597306ULL, 0x000fe20000009400ULL, 0x000000525100720bULL, 0x002fe40003fdd000ULL,
0x0000006d00517245ULL, 0x000fca000020d400ULL, 0x0000003e005a7306ULL, 0x000e620000005400ULL,
0x000000010f0f2812ULL, 0x004fc800078efcffULL, 0x0000000f5b0f723eULL, 0x000fe400000010ffULL,
0x000000014f4f6812ULL, 0x000fe200078efcffULL, 0x0000005f005e7306ULL, 0x000fe80000209400ULL,
0x0000000e3018723cULL, 0x000b680000041818ULL, 0x0000005f00617306ULL, 0x0004e20000205400ULL,
0x0000005a5900720bULL, 0x002fe20003f5d000ULL, 0x000100003c5a7824ULL, 0x000fc400078e00ffULL,
0x000100003d597824ULL, 0x000fc600078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000006d004c7306ULL, 0x000fe20000209400ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000005f005f7245ULL, 0x004fca000020d400ULL, 0x0000006d006c7306ULL, 0x000e620000205400ULL,
0x000000615e00720bULL, 0x008fce0003f1d000ULL, 0x0000003f00667306ULL, 0x000fec0000009400ULL,
0x000000015f5f0812ULL, 0x000fe400078efcffULL, 0x0000003f005c7306ULL, 0x000ea20000005400ULL,
0x0000006c4c00720bULL, 0x002fe20003fdd000ULL, 0x000001003e4c7824ULL, 0x000fe200078e00ffULL,
0x0000004f5f11723eULL, 0x000fc800000010ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000003c00577306ULL, 0x000e64000000d400ULL, 0x000000103014723cULL, 0x000f680000041814ULL,
0x0000000151516812ULL, 0x000fe400078efcffULL, 0x0000006300627306ULL, 0x000fe20000209400ULL,
0x0000005c6600720bULL, 0x004fce0003fbd000ULL, 0x00000063003c7306ULL, 0x000ea20000205400ULL,
0x0000000157573812ULL, 0x002fc800078efcffULL, 0x00000057510e723eULL, 0x020fc600000010ffULL,
0x0000004a00237306ULL, 0x000ff00000209400ULL, 0x0000004a004e7306ULL, 0x000e620000205400ULL,
0x0000003c6200720bULL, 0x004fe20003f1d000ULL, 0x000100003e3c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x00000046005e7306ULL, 0x000ff00000209400ULL,
0x0000004600617306ULL, 0x0004e20000205400ULL, 0x0000004e2300720bULL, 0x002fc40003fdd000ULL,
0x000000203020723cULL, 0x000b6a0000041838ULL, 0x0000003d00427306ULL, 0x000322000000d400ULL,
0x0000004600467245ULL, 0x004fe4000020d400ULL, 0x0000004a003b7245ULL, 0x020fc8000020d400ULL,
0x000000013b3b6812ULL, 0x000fe200078efcffULL, 0x0000005a006a7306ULL, 0x000fe20000209400ULL,
0x000001003f3d7824ULL, 0x042fe200078e00ffULL, 0x000000615e00720bULL, 0x008fe20003f7d000ULL,
0x000100003f5e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000005a006b7306ULL, 0x0003e20000205400ULL, 0x00000018ff387819ULL, 0x000fe4000001145eULL,
0x0000000142424812ULL, 0x010fc800078efcffULL, 0x0000000146463812ULL, 0x000fe200078efcffULL,
0x0000005900667306ULL, 0x000fe20000209400ULL, 0x0000005a005a7245ULL, 0x002fce000020d400ULL,
0x0000005900677306ULL, 0x0002b00000205400ULL, 0x0000004c005c7306ULL, 0x000fe20000209400ULL,
0x0000005900597245ULL, 0x002fce000020d400ULL, 0x0000004c00627306ULL, 0x0002e20000205400ULL,
0x000000676600720bULL, 0x004fce0003f9d000ULL, 0x0000003d00527306ULL, 0x000fe20000209400ULL,
0x0000004c004c7245ULL, 0x002fca000020d400ULL, 0x0000000159594812ULL, 0x000fe400078efcffULL,
0x0000003d00537306ULL, 0x0002a20000205400ULL, 0x000000625c00720bULL, 0x008fe40003fdd000ULL,
0x000000594611723eULL, 0x000fca00000010ffULL, 0x0000003e00437306ULL, 0x000722000000d400ULL,
0x0000003d003d7245ULL, 0x002fca000020d400ULL, 0x000000014c4c6812ULL, 0x000fe400078efcffULL,
0x0000003f00407306ULL, 0x000e62000000d400ULL, 0x00000063003e7245ULL, 0x008fe4000020d400ULL,
0x000000535200720bULL, 0x004fe40003f7d000ULL, 0x000000013e3e0812ULL, 0x000fe400078efcffULL,
0x0000006b6a00720bULL, 0x000fe20003f1d000ULL, 0x0000004100487306ULL, 0x000fe20000209400ULL,
0x0000000143432812ULL, 0x010fc400078efcffULL, 0x000000423e0f723eULL, 0x000fca00000010ffULL,
0x00000041004b7306ULL, 0x0004e20000205400ULL, 0x0000000140405812ULL, 0x002fe200078efcffULL,
0x0000000e3024723cULL, 0x000b620000041824ULL, 0x000000013d3d3812ULL, 0x000fe400078efcffULL,
0x000000015a5a0812ULL, 0x000fc600078efcffULL, 0x0000004500477306ULL, 0x000fe20000209400ULL,
0x0000005a3b10723eULL, 0x000fe400000010ffULL, 0x000000403d0f723eULL, 0x020fe400000010ffULL,
0x0000004100417245ULL, 0x004fe4000020d400ULL, 0x00000038003d7245ULL, 0x000fe2000020d400ULL,
0x0000004500497306ULL, 0x000e620000205400ULL, 0x0000004b4800720bULL, 0x008fe20003f1d000ULL,
0x000000103028723cULL, 0x000b620000041828ULL, 0x000000434c0e723eULL, 0x000fca00000010ffULL,
0x0000003c004e7306ULL, 0x000fe20000209400ULL, 0x0000004500107245ULL, 0x020fe2000020d400ULL,
0x0000000e302c723cULL, 0x000b68000004182cULL, 0x0000000141410812ULL, 0x000fe400078efcffULL,
0x0000003c003f7306ULL, 0x0004e20000205400ULL, 0x000000494700720bULL, 0x002fe20003f9d000ULL,
0x00000002000e7824ULL, 0x020fca00078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ec0ffULL,
0x0000003800397306ULL, 0x000fe20000209400ULL, 0x0000003c003c7245ULL, 0x004fca000020d400ULL,
0x0000000110104812ULL, 0x000fe400078efcffULL, 0x00000038003a7306ULL, 0x000e620000205400ULL,
0x0000003f4e00720bULL, 0x008fda0003fdd000ULL, 0x000000013c3c6812ULL, 0x000fe400078efcffULL,
0x0000003a3900720bULL, 0x002fe40003f5d000ULL, 0x0000003c413c723eULL, 0x000fd600000010ffULL,
0x000000013d3d2812ULL, 0x000fc800078efcffULL, 0x0000003d103d723eULL, 0x000fce00000010ffULL,
0x0000003c3030723cULL, 0x000b6e0000041834ULL, 0x0000f6c86e347811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000034347f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f688000eff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff367224ULL, 0x000fc600078e00ffULL, 0x00000000000e7805ULL, 0x004fc80000015200ULL,
0x0000040005117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x006fc40007804835ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000100e377210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e0fULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc80000011411ULL, 0x0000003710107211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0611ULL, 0x0000000210107819ULL, 0x000fc80000001211ULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040005117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000080560f7810ULL, 0x000fca0007ffe0ffULL,
0x0000680073357a24ULL, 0x000fe200078e020fULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x0000000f680e7217ULL, 0x000fe20007800000ULL, 0x0000001072117824ULL, 0x000fe200078e00ffULL,
0x00000003ff107819ULL, 0x000fc60000011602ULL, 0x000000010e0e7824ULL, 0x000fe200078e0a0fULL,
0x0000000410367810ULL, 0x040fe20007ffe0ffULL, 0x00000001110f7824ULL, 0x040fe200078e0210ULL,
0x0000000c10387810ULL, 0x000fe40007ffe0ffULL, 0x0000000e110e7217ULL, 0x000fe20007800000ULL,
0x000000010f347824ULL, 0x040fe400078e0202ULL, 0x000000080f397824ULL, 0x000fe400078e00ffULL,
0x000000010e0e7824ULL, 0x000fc400078e0a11ULL, 0x000000010f0f7824ULL, 0x000fe200078e0235ULL,
0xfffffff839397812ULL, 0x000fe200078ee234ULL, 0x00000001113a7824ULL, 0x040fe200078e0238ULL,
0x0000000e3600720cULL, 0x080fe20003f66070ULL, 0x0000000111367824ULL, 0x000fe200078e0236ULL,
0x0000000810347810ULL, 0x000fe20007ffe0ffULL, 0x000000083a3f7824ULL, 0x000fe200078e00ffULL,
0x0000000e1000720cULL, 0x080fe20003f86070ULL, 0x0000000136107824ULL, 0x000fe200078e0202ULL,
0x0000000e3400720cULL, 0x080fe20003f46070ULL, 0x00000008363b7824ULL, 0x000fe200078e00ffULL,
0x0000000e3800720cULL, 0x000fe20003f06070ULL, 0x000000800f0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL, 0x0000000136107824ULL, 0x000fe200078e0235ULL,
0x000000600e0e7212ULL, 0x000fe200078efcffULL, 0x0000000111377824ULL, 0x000fe400078e0234ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000064000e0e7a10ULL, 0x000fc60007fbe0ffULL,
0x0000000137347824ULL, 0x100fe200078e0235ULL, 0x0000006010107212ULL, 0x080fe200078efcffULL,
0x000000013a367824ULL, 0x000fe200078e0235ULL, 0x000065000f0f7a10ULL, 0x000fe20002ffe4ffULL,
0x0000000137387824ULL, 0x040fe200078e0202ULL, 0x0000640010107a10ULL, 0x000fe20007fbe0ffULL,
0x00000008373d7824ULL, 0x000fe400078e00ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000650011117a10ULL, 0x000fe40002ffe4ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee238ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006034347212ULL, 0x000fc600078efcffULL,
0x000000013a387824ULL, 0x000fe200078e0202ULL, 0x0000006036367212ULL, 0x000fe200078efcffULL,
0x0000001039397824ULL, 0x100fe200078e0264ULL, 0x0000640034347a10ULL, 0x000fe20007fbe0ffULL,
0x000000103b3b7824ULL, 0x000fe200078e0264ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee238ULL,
0x000000103d3d7824ULL, 0x100fe200078e0264ULL, 0x0000640036367a10ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e397faeULL, 0x0003e2000e101c46ULL,
0x0000650035357a10ULL, 0x000fe20002ffe4ffULL, 0x000000103f3f7824ULL, 0x000fe200078e0264ULL,
0x0000650037377a10ULL, 0x000fe200037fe4ffULL, 0x00000000103b7faeULL, 0x0003e8000d901c46ULL,
0x00000000343d7faeULL, 0x0003e8000d101c46ULL, 0x00000000363f7faeULL, 0x0003e2000c101c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x00000010720f7824ULL, 0x000fca00078e00ffULL,
0x0000000f020f7211ULL, 0x000fc800078fe8ffULL, 0x000000040f367810ULL, 0x040fe20007ffe0ffULL,
0x000000010f0e7824ULL, 0x140fe200078e0202ULL, 0x000000080f117810ULL, 0x040fe20007ffe0ffULL,
0x000000080f397824ULL, 0x040fe200078e00ffULL, 0x0000000c0f377810ULL, 0x000fe20007ffe0ffULL,
0x0000000136107824ULL, 0x040fe400078e0202ULL, 0x00000008363b7824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee20eULL, 0x0000000111347824ULL, 0x040fe400078e0202ULL,
0x00000008113d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL,
0x000000010f0e7824ULL, 0x000fc400078e0235ULL, 0x0000000136367824ULL, 0x000fe200078e0235ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee234ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000000111107824ULL, 0x100fe200078e0235ULL, 0x000000600e0e7212ULL, 0x080fe200078efcffULL,
0x0000000137347824ULL, 0x040fe400078e0235ULL, 0x0000000137387824ULL, 0x040fe200078e0202ULL,
0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x00000008373f7824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000065000f0f7a10ULL, 0x000fe400007fe4ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee238ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000006036367212ULL, 0x000fc600078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000006010107212ULL, 0x080fe400078efcffULL, 0x0000640036367a10ULL, 0x000fe20007f5e0ffULL,
0x0000001039397824ULL, 0x100fe200078e0264ULL, 0x0000006034347212ULL, 0x000fe200078efcffULL,
0x000000103b3b7824ULL, 0x100fe200078e0264ULL, 0x0000640010107a10ULL, 0x000fe20007f1e0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e0264ULL, 0x0000640034347a10ULL, 0x000fe20007f7e0ffULL,
0x000000103f3f7824ULL, 0x000fe200078e0264ULL, 0x0000650037377a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e397faeULL, 0x0003e2000b901c46ULL,
0x0000650011117a10ULL, 0x000fc400007fe4ffULL, 0x0000650035357a10ULL, 0x000fe20001ffe4ffULL,
0x00000000363b7faeULL, 0x0003e8000b901c46ULL, 0x00000000103d7faeULL, 0x0003e8000b901c46ULL,
0x00000000343f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000106e0e7824ULL, 0x000fe200078e00ffULL, 0xffffffe0030f7812ULL, 0x000fc400078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000803107812ULL, 0x000fe400078ec0ffULL,
0x000000100e0e7812ULL, 0x000fc800078ec0ffULL, 0x0000000f100e7210ULL, 0x000fe20007ffe00eULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff347f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f628000e367f8cULL, 0x0004e4000c80043fULL, 0x00000000000e7805ULL, 0x004fc40000015200ULL,
0x00f62c0006117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x00cfe40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100e397210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0fULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011411ULL,
0x0000003910107211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x0000000210107819ULL, 0x000fc80000001211ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c0006117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x004fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020000e7824ULL, 0x000fca00078e00ffULL, 0xffffff800e0f7812ULL, 0x000fc800078ec0ffULL,
0x00000080600e7810ULL, 0x000fca0007ffe00fULL, 0x00000001650e7824ULL, 0x000fca00078e020eULL,
0x00f000000e0f7984ULL, 0x000ea80000000800ULL, 0x00f200000e367984ULL, 0x0006620000000800ULL,
0x0000000c0f00720bULL, 0x004fe20003f1d000ULL, 0x000113d27f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff3c3a7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff387424ULL, 0x000fe400078e00ffULL,
0x000000ffff0e7224ULL, 0x000fd200078e000cULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x0000000175117810ULL, 0x000fe40007ffe0ffULL, 0x0000000c0f00720bULL, 0x000fe40003f54000ULL,
0x000000001100720cULL, 0x000fe20003f05270ULL, 0x000113727f007947ULL, 0x000fd4000b800000ULL,
0x0000000000377806ULL, 0x000fc400010e0100ULL, 0x0000008000108824ULL, 0x000fe200078e0260ULL,
0x0000000c0f0e7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x0000000165118824ULL, 0x000fe200078e0210ULL, 0x0000991037107816ULL, 0x000fc800000000ffULL,
0x00f4000e11008388ULL, 0x0005e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000c0e0c7221ULL, 0x004fe20000010100ULL,
0x000000ff37ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fcc0000410000ULL, 0x0000000c000c7308ULL, 0x000ea40000000800ULL,
0x0000000c0d0d7220ULL, 0x004fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe20000011602ULL, 0x000112a27f007947ULL, 0x000fea000b800000ULL,
0x00001f100c3c7589ULL, 0x0004e400000e0000ULL, 0x0000003c20207220ULL, 0x08cfe20000410000ULL,
0x0000003c21217220ULL, 0x080fe20000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000003c18187220ULL, 0x080fe20000410000ULL,
0x0000003c19197220ULL, 0x080fe20000410000ULL, 0x0000003c14147220ULL, 0x080fe20000410000ULL,
0x0000003c15157220ULL, 0x080fe20000410000ULL, 0x0000003c24247220ULL, 0x080fe20000410000ULL,
0x0000003c25257220ULL, 0x080fe20000410000ULL, 0x0000003c28287220ULL, 0x080fe20000410000ULL,
0x0000003c29297220ULL, 0x080fe20000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000003c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000003c30307220ULL, 0x080fe20000410000ULL,
0x0000003c31317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0037ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802107811ULL, 0x000fe200078ff0ffULL, 0x000111827f007947ULL, 0x000fea000b800000ULL,
0x00001f100c3c7589ULL, 0x0004e400000e0000ULL, 0x0000003c22227220ULL, 0x08cfe20000410000ULL,
0x0000003c23237220ULL, 0x080fe20000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000003c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003c16167220ULL, 0x080fe20000410000ULL,
0x0000003c17177220ULL, 0x080fe20000410000ULL, 0x0000003c26267220ULL, 0x080fe20000410000ULL,
0x0000003c27277220ULL, 0x080fe20000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000003c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000003c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000003c32327220ULL, 0x080fe20000410000ULL,
0x0000003c33337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff3aff7812ULL, 0x000fe20007806037ULL, 0x00000001ff387424ULL, 0x000fd800078e00ffULL,
0x8000000e0f0f0221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL, 0x0000000f00070308ULL, 0x000ea40000000800ULL,
0x0000000736360220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000d360d7221ULL, 0x002fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0xfffffff0033a7812ULL, 0x000fca00078ec0ffULL, 0x00f6b4003a0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x00000036100f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137367824ULL, 0x000fe200000e0e11ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc80000011436ULL, 0x0000000f0c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e0636ULL, 0x000000020c0c7819ULL, 0x000fc8000000120fULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000139397810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6b4003a0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910380c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000010ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011602ULL, 0x00005410080c7816ULL, 0x000fe20000000008ULL,
0x00010d527f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0c087589ULL, 0x0002a400000e0000ULL,
0x000000080f107810ULL, 0x000fe20007ffe0ffULL, 0x00010d827f007947ULL, 0x000fea000b800000ULL,
0x00001f100c097589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100f107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200078e000cULL,
0x00006400003d7802ULL, 0x000fc40000000f00ULL, 0x0001159000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180f107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200078e000cULL, 0x00006450003d7802ULL, 0x000fc40000000f00ULL,
0x0001154000007944ULL, 0x006fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002005a7824ULL, 0x000fe200078e00ffULL, 0x00000007020c7812ULL, 0x04afe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008023d7812ULL, 0x000fc400078ec0ffULL,
0x000000045a0f7812ULL, 0x000fe400078ec0ffULL, 0x000000080c4c7812ULL, 0x000fe400078ef802ULL,
0x0000000f020f7211ULL, 0x000fc600078fe0ffULL, 0x000000084c377824ULL, 0x040fe400078e00ffULL,
0x000000014c4c7824ULL, 0x000fca00078e020fULL, 0xfffffff837377812ULL, 0x000fca00078ee24cULL,
0x0000001037377824ULL, 0x000fc600078e020aULL, 0x00000004000f7824ULL, 0x000fe200078e00ffULL,
0x0000000c3d3d7212ULL, 0x000fe200078efcffULL, 0x009800003740783bULL, 0x000e620000000200ULL,
0x0000100064717810ULL, 0x000fe20007ffe0ffULL, 0x000000080b557824ULL, 0x000fe200078e00ffULL,
0x000000040f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000083d107824ULL, 0x000fe200078e00ffULL,
0xfffffff85a5a7812ULL, 0x000fe400078ec0ffULL, 0x0000000f020c7211ULL, 0x000fca00078fe0ffULL,
0x000000013d0f7824ULL, 0x100fe400078e020cULL, 0x000000010b367824ULL, 0x000fc600078e020cULL,
0xfffffff810107812ULL, 0x000fe400078ee20fULL, 0x000000020f0f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff855557812ULL, 0x000fe200078ee236ULL, 0x0000001010617824ULL, 0x000fe200078e0271ULL,
0x0000000236367810ULL, 0x000fc60007ffe0ffULL, 0x0000001055387824ULL, 0x000fe200078e0271ULL,
0x000000006110783bULL, 0x000eea0000004200ULL, 0x000000003838783bULL, 0x000fe20000004200ULL,
0x0000000840408231ULL, 0x086fe400003400ffULL, 0x0000000842428231ULL, 0x000fe400003400ffULL,
0x0000000941418231ULL, 0x000fc400003400ffULL, 0x0000000943438231ULL, 0x000fe200003400ffULL,
0x00000100103c7824ULL, 0x008fe200078e00ffULL, 0x00000010003e7306ULL, 0x000fe20000009400ULL,
0x00000018ff637819ULL, 0x000fc60000011410ULL, 0x00000018ff5d7819ULL, 0x000fe2000001143cULL,
0x00000100113c7824ULL, 0x000fc600078e00ffULL, 0x00000010003f7306ULL, 0x000e640000005400ULL,
0x00000018ff3c7819ULL, 0x000fcc000001143cULL, 0x0000001100627306ULL, 0x000ff00000009400ULL,
0x0000001100677306ULL, 0x000ea20000005400ULL, 0x0000003f3e00720bULL, 0x002fe20003f5d000ULL,
0x000000083d3e7824ULL, 0x000fca00078e00ffULL, 0xfffffff83e0f7812ULL, 0x000fe200078ee20fULL,
0x0000005d00577306ULL, 0x000fe20000209400ULL, 0x0000003c003e7245ULL, 0x000fce000020d400ULL,
0x0000005d005e7306ULL, 0x0002e20000205400ULL, 0x000000676200720bULL, 0x004fce0003f9d000ULL,
0x0000003c006a7306ULL, 0x000fe20000209400ULL, 0x0000005d005d7245ULL, 0x002fce000020d400ULL,
0x0000003c006b7306ULL, 0x0002a20000205400ULL, 0x0000005e5700720bULL, 0x008fe40003f7d000ULL,
0x00000018ff577819ULL, 0x000fc80000011411ULL, 0x00000057007a7245ULL, 0x000fe2000020d400ULL,
0x0000001000527306ULL, 0x000722000000d400ULL, 0x000000100f3c7824ULL, 0x002fca00078e0271ULL,
0x000000015d5d3812ULL, 0x000fe400078efcffULL, 0x0000001100537306ULL, 0x000262000000d400ULL,
0x0000006b6a00720bULL, 0x004fe20003fbd000ULL, 0x0001000010107824ULL, 0x008fca00078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005700627306ULL, 0x000fe20000209400ULL,
0x0000000152522812ULL, 0x010fe200078efcffULL, 0x0001000011117824ULL, 0x002fc600078e00ffULL,
0x000000525d52723eULL, 0x000fe400000010ffULL, 0x000000013e3e5812ULL, 0x000fe200078efcffULL,
0x0000005700677306ULL, 0x000e620000205400ULL, 0x0000000153534812ULL, 0x000fe400078efcffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x000000533e53723eULL, 0x000fe400000010ffULL,
0x00000018ff5d7819ULL, 0x000fe20000011412ULL, 0x00000011006a7306ULL, 0x000fe20000209400ULL,
0x000000003c3c783bULL, 0x000ea60000004200ULL, 0x000000524020723cULL, 0x000b680000041820ULL,
0x0000001100537306ULL, 0x0207220000205400ULL, 0x000000676200720bULL, 0x002fe20003fbd000ULL,
0x0000010013677824ULL, 0x000fca00078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x00000010006b7306ULL, 0x000fe20000209400ULL, 0x0000001100117245ULL, 0x008fca000020d400ULL,
0x000000017a7a5812ULL, 0x000fe400078efcffULL, 0x00000010006c7306ULL, 0x0002e20000205400ULL,
0x000000536a00720bULL, 0x010fe40003f9d000ULL, 0x0000006300537245ULL, 0x000fca000020d400ULL,
0x0000006300667306ULL, 0x000fe20000209400ULL, 0x0000001000107245ULL, 0x002fca000020d400ULL,
0x0000000111114812ULL, 0x000fe400078efcffULL, 0x00000063005e7306ULL, 0x0003220000205400ULL,
0x0000006c6b00720bULL, 0x008fe40003f5d000ULL, 0x000000117a11723eULL, 0x000fca00000010ffULL,
0x0000001200587306ULL, 0x000fe20000009400ULL, 0x0000010012637824ULL, 0x002fca00078e00ffULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x00000012005f7306ULL, 0x000e620000005400ULL,
0x0000005e6600720bULL, 0x010fe40003f7d000ULL, 0x00000018ff5e7819ULL, 0x000fe40000011413ULL,
0x0000000110102812ULL, 0x000fc600078efcffULL, 0x00000063006a7306ULL, 0x000fec0000209400ULL,
0x0000000153533812ULL, 0x000fe400078efcffULL, 0x00000063006b7306ULL, 0x0007220000205400ULL,
0x0000005f5800720bULL, 0x002fe20003fdd000ULL, 0x00010000125f7824ULL, 0x000fe200078e00ffULL,
0x000000105310723eULL, 0x000fc800000010ffULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x00000012005c7306ULL, 0x000e62000000d400ULL, 0x0000006300637245ULL, 0x008fe2000020d400ULL,
0x00000010401c723cULL, 0x000bec000004181cULL, 0x0000005e00667306ULL, 0x000fe20000209400ULL,
0x0000006b6a00720bULL, 0x010fe20003f9d000ULL, 0x00010000136a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000005e00627306ULL, 0x000ee20000205400ULL,
0x000000015c5c6812ULL, 0x002fca00078efcffULL, 0x0000000163634812ULL, 0x000fe400078efcffULL,
0x00000067006c7306ULL, 0x000fe40000209400ULL, 0x0000005c6310723eULL, 0x020fcc00000010ffULL,
0x00000067006d7306ULL, 0x000e620000205400ULL, 0x000000626600720bULL, 0x008fe40003fdd000ULL,
0x0000006700627245ULL, 0x000fca000020d400ULL, 0x0000001300547306ULL, 0x000ff00000009400ULL,
0x0000001300597306ULL, 0x000ee20000005400ULL, 0x0000006d6c00720bULL, 0x002fce0003fbd000ULL,
0x00000013005b7306ULL, 0x000e6c000000d400ULL, 0x0000000162625812ULL, 0x000fe400078efcffULL,
0x0000005d006f7306ULL, 0x000fe20000209400ULL, 0x000000595400720bULL, 0x008fce0003f5d000ULL,
0x0000005d00707306ULL, 0x00072c0000205400ULL, 0x000000015b5b2812ULL, 0x002fe400078efcffULL,
0x0000005f006b7306ULL, 0x000fe20000209400ULL, 0x0000005d005d7245ULL, 0x008fe4000020d400ULL,
0x0000005b6211723eULL, 0x000fc400000010ffULL, 0x0000005e00627245ULL, 0x000fc6000020d400ULL,
0x0000005f006c7306ULL, 0x0004620000205400ULL, 0x000000706f00720bULL, 0x010fe20003f7d000ULL,
0x000000104018723cULL, 0x000b620000041818ULL, 0x0000000162626812ULL, 0x000fca00078efcffULL,
0x0000006a006d7306ULL, 0x000fe20000209400ULL, 0x0000005f00107245ULL, 0x020fe4000020d400ULL,
0x0000006a00117245ULL, 0x000fe4000020d400ULL, 0x00000018ff5f7819ULL, 0x004fe4000001143cULL,
0x000000015d5d3812ULL, 0x000fe200078efcffULL, 0x0000006a00667306ULL, 0x000ea20000205400ULL,
0x0000006c6b00720bULL, 0x002fce0003f5d000ULL, 0x0000003c00527306ULL, 0x000fec0000009400ULL,
0x0000000110102812ULL, 0x000fe400078efcffULL, 0x000000666d00720bULL, 0x004fe20003f9d000ULL,
0x0000003c00577306ULL, 0x000e620000005400ULL, 0x000000105d10723eULL, 0x000fce00000010ffULL,
0x0000005f00677306ULL, 0x000fe80000205400ULL, 0x0000000111114812ULL, 0x000fc800078efcffULL,
0x000000116211723eULL, 0x000fe200000010ffULL, 0x0000003d00587306ULL, 0x000fe20000009400ULL,
0x000000575200720bULL, 0x002fca0003fdd000ULL, 0x000000104014723cULL, 0x000be40000041814ULL,
0x0000005f00627306ULL, 0x000e6a0000209400ULL, 0x000001003c117824ULL, 0x020fe400078e00ffULL,
0x000001003d107824ULL, 0x000fe200078e00ffULL, 0x0000003d00597306ULL, 0x000ea40000005400ULL,
0x00000018ff117819ULL, 0x000fc40000011411ULL, 0x00000018ff107819ULL, 0x000fc80000011410ULL,
0x0000001100637306ULL, 0x000fe20000209400ULL, 0x000000676200720bULL, 0x002fe40003f5d000ULL,
0x00000018ff627819ULL, 0x000fca000001143dULL, 0x00000011006a7306ULL, 0x0002e20000205400ULL,
0x000000595800720bULL, 0x004fe40003fbd000ULL, 0x0000001100587245ULL, 0x000fca000020d400ULL,
0x0000001000667306ULL, 0x000fe20000209400ULL, 0x0000001000117245ULL, 0x002fce000020d400ULL,
0x0000001000577306ULL, 0x000e620000205400ULL, 0x0000006a6300720bULL, 0x008fe20003f7d000ULL,
0x000100003c637824ULL, 0x000fca00078e00ffULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x0000003d00547306ULL, 0x0004ec000000d400ULL, 0x0000000158583812ULL, 0x000fe400078efcffULL,
0x0000003c00537306ULL, 0x000f22000000d400ULL, 0x000100003d3d7824ULL, 0x004fe200078e00ffULL,
0x000000576600720bULL, 0x002fc80003f9d000ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000006300527306ULL, 0x000fe20000209400ULL, 0x0000000154545812ULL, 0x008fcc00078efcffULL,
0x0000000111114812ULL, 0x000fe200078efcffULL, 0x0000006300577306ULL, 0x000e620000205400ULL,
0x0000000153536812ULL, 0x010fe400078efcffULL, 0x000000541111723eULL, 0x000fe400000010ffULL,
0x000000535810723eULL, 0x000fe400000010ffULL, 0x00000018ff547819ULL, 0x000fe20000011439ULL,
0x0000006200597306ULL, 0x000fe80000209400ULL, 0x000000104024723cULL, 0x000be80000041824ULL,
0x00000062006a7306ULL, 0x0004e20000205400ULL, 0x000000575200720bULL, 0x002fc40003fdd000ULL,
0x0000005f00117245ULL, 0x020fe4000020d400ULL, 0x0000006300107245ULL, 0x000fe4000020d400ULL,
0x0000000111112812ULL, 0x000fe200078efcffULL, 0x0000003d003c7306ULL, 0x000fe20000209400ULL,
0x0000006200627245ULL, 0x004fca000020d400ULL, 0x0000000110106812ULL, 0x000fe400078efcffULL,
0x0000003d00677306ULL, 0x0002a20000205400ULL, 0x0000006a5900720bULL, 0x008fe40003f7d000ULL,
0x000000101110723eULL, 0x000fe400000010ffULL, 0x00000018ff597819ULL, 0x000fc60000011438ULL,
0x0000003e00127306ULL, 0x000fe20000009400ULL, 0x0000003d003d7245ULL, 0x002fca000020d400ULL,
0x0000000162623812ULL, 0x000fe400078efcffULL, 0x000000673c00720bULL, 0x004fe20003f9d000ULL,
0x0000003e00137306ULL, 0x000e620000005400ULL, 0x00000018ff3c7819ULL, 0x000fce000001143eULL,
0x0000003f005c7306ULL, 0x000fe80000009400ULL, 0x000000013d3d4812ULL, 0x000fc800078efcffULL,
0x0000003f005e7306ULL, 0x000ea20000005400ULL, 0x0000003d6211723eULL, 0x000fe400000010ffULL,
0x000000131200720bULL, 0x002fe20003fbd000ULL, 0x000001003f127824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fc6000001143fULL, 0x000000104028723cULL, 0x000b620000041828ULL,
0x0000003c005f7306ULL, 0x000fe20000209400ULL, 0x00000018ff127819ULL, 0x000fca0000011412ULL,
0x000001003e107824ULL, 0x020fe200078e00ffULL, 0x0000005e5c00720bULL, 0x004fe20003f7d000ULL,
0x0000003c00667306ULL, 0x000e620000205400ULL, 0x000100003e5e7824ULL, 0x000fe400078e00ffULL,
0x00000018ff107819ULL, 0x000fc60000011410ULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x0000001000637306ULL, 0x000ff00000209400ULL, 0x00000010005c7306ULL, 0x0004e20000205400ULL,
0x000000665f00720bULL, 0x002fe20003f5d000ULL, 0x000100003f5f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000003e005b7306ULL, 0x000e62000000d400ULL,
0x0000001000107245ULL, 0x004fce000020d400ULL, 0x0000001200677306ULL, 0x000fe20000209400ULL,
0x0000005c6300720bULL, 0x008fce0003fdd000ULL, 0x00000012003e7306ULL, 0x0004e20000205400ULL,
0x000000015b5b5812ULL, 0x002fca00078efcffULL, 0x0000000110106812ULL, 0x000fe400078efcffULL,
0x0000003f005d7306ULL, 0x000e62000000d400ULL, 0x0000001200127245ULL, 0x004fe4000020d400ULL,
0x0000005b1010723eULL, 0x000fca00000010ffULL, 0x0000003d00627306ULL, 0x000fe20000209400ULL,
0x0000003e6700720bULL, 0x008fe40003f9d000ULL, 0x00000018ff3e7819ULL, 0x000fca000001143aULL,
0x0000003d00117306ULL, 0x000ea20000205400ULL, 0x000000015d5d3812ULL, 0x002fca00078efcffULL,
0x0000000112124812ULL, 0x000fe400078efcffULL, 0x0000005e00137306ULL, 0x000ff00000209400ULL,
0x0000005e005c7306ULL, 0x000e620000205400ULL, 0x000000116200720bULL, 0x004fe20003fbd000ULL,
0x000000080b117824ULL, 0x000fe200078e00ffULL, 0x0000003d00627245ULL, 0x000fc4000020d400ULL,
0x0000005f003d7245ULL, 0x000fe4000020d400ULL, 0xfffffff811367812ULL, 0x000fe200078ee236ULL,
0x0000005f00637306ULL, 0x000fe20000209400ULL, 0x0000005d1211723eULL, 0x000fc600000010ffULL,
0x0000001036127824ULL, 0x000fe400078e0271ULL, 0x0000000162625812ULL, 0x000fe400078efcffULL,
0x0000005f00667306ULL, 0x0004e20000205400ULL, 0x0000005c1300720bULL, 0x002fe20003f7d000ULL,
0x00000010402c723cULL, 0x000b62000004182cULL, 0x00000018ff5c7819ULL, 0x000fe2000001143bULL,
0x000000001210783bULL, 0x020fe80000004200ULL, 0x00000038004b7306ULL, 0x000fe20000009400ULL,
0x00000100385f7824ULL, 0x004fca00078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x000000666300720bULL, 0x008fe20003f9d000ULL, 0x00000038004d7306ULL, 0x000e620000005400ULL,
0x0000003c00637245ULL, 0x000fe4000020d400ULL, 0x0000005e003c7245ULL, 0x000fe4000020d400ULL,
0x0000000163632812ULL, 0x000fe400078efcffULL, 0x000000013c3c3812ULL, 0x000fe200078efcffULL,
0x0000005f00667306ULL, 0x000fe60000209400ULL, 0x0000003c633c723eULL, 0x000fc400000010ffULL,
0x000000013d3d4812ULL, 0x000fc600078efcffULL, 0x00000039004f7306ULL, 0x000fe20000009400ULL,
0x0000003d623d723eULL, 0x000fe400000010ffULL, 0x0000004d4b00720bULL, 0x002fca0003f5d000ULL,
0x0000003c4040723cULL, 0x000b620000041830ULL, 0x0000003900507306ULL, 0x000e6c0000005400ULL,
0x0000010039307824ULL, 0x020fe400078e00ffULL, 0x0000005f003d7306ULL, 0x0004e60000205400ULL,
0x00000018ff3c7819ULL, 0x000fc40000011430ULL, 0x009800004430783bULL, 0x000f260000000200ULL,
0x0000003c00677306ULL, 0x000fe20000209400ULL, 0x000000504f00720bULL, 0x002fe40003f9d000ULL,
0x0000005f005f7245ULL, 0x004fca000020d400ULL, 0x0000003c006a7306ULL, 0x0002a20000205400ULL,
0x0000003d6600720bULL, 0x008fce0003f7d000ULL, 0x00000038004e7306ULL, 0x000ee2000000d400ULL,
0x0000003c003c7245ULL, 0x002fca000020d400ULL, 0x000000015f5f3812ULL, 0x000fe400078efcffULL,
0x0000003900517306ULL, 0x000e62000000d400ULL, 0x0000006a6700720bULL, 0x004fce0003fbd000ULL,
0x0000003a00457306ULL, 0x000fe20000009400ULL, 0x000000014e4e2812ULL, 0x008fc800078efcffULL,
0x0000004e5f4e723eULL, 0x000fe200000010ffULL, 0x00010000385f7824ULL, 0x000fe200078e00ffULL,
0x000000013c3c5812ULL, 0x000fe200078efcffULL, 0x0000003a00467306ULL, 0x000ea20000005400ULL,
0x0000000151514812ULL, 0x002fe200078efcffULL, 0x0000000830308231ULL, 0x090fe200003400ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000000832328231ULL, 0x000fe200003400ffULL,
0x000000513c4f723eULL, 0x000fe200000010ffULL, 0x0000000931318231ULL, 0x080fe400003400ffULL,
0x0000005900527306ULL, 0x000fe20000209400ULL, 0x0000000933338231ULL, 0x000fce00003400ffULL,
0x0000005900537306ULL, 0x000e620000205400ULL, 0x000000464500720bULL, 0x004fe20003f9d000ULL,
0x0000004e3020723cULL, 0x000b6c0000041820ULL, 0x0000005f00457306ULL, 0x000fe20000209400ULL,
0x00010000394f7824ULL, 0x020fca00078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000005f00467306ULL, 0x000ea20000205400ULL, 0x000000535200720bULL, 0x002fce0003f7d000ULL,
0x0000003b00487306ULL, 0x000ff00000009400ULL, 0x0000003b00497306ULL, 0x000e620000005400ULL,
0x000000464500720bULL, 0x004fe20003fdd000ULL, 0x000100003a467824ULL, 0x000fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x0000003e003f7306ULL, 0x000ff00000209400ULL,
0x0000003e005b7306ULL, 0x000ea20000205400ULL, 0x000000494800720bULL, 0x002fe20003f5d000ULL,
0x000001003a497824ULL, 0x000fc400078e00ffULL, 0x000001003b487824ULL, 0x000fc600078e00ffULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0000004f00677306ULL, 0x000fe20000209400ULL,
0x00000018ff487819ULL, 0x000fce0000011448ULL, 0x0000004f00527306ULL, 0x000e620000205400ULL,
0x0000005b3f00720bULL, 0x004fe40003fbd000ULL, 0x0000005f005b7245ULL, 0x000fe4000020d400ULL,
0x00000059005f7245ULL, 0x000fe4000020d400ULL, 0x000000015b5b6812ULL, 0x000fe200078efcffULL,
0x0000005400587306ULL, 0x000fe20000209400ULL, 0x000000015f5f3812ULL, 0x000fe400078efcffULL,
0x00000018ff3f7819ULL, 0x000fca0000011411ULL, 0x0000005400577306ULL, 0x000ea20000205400ULL,
0x000000526700720bULL, 0x002fe40003fdd000ULL, 0x0000005400677245ULL, 0x000fe4000020d400ULL,
0x00000018ff527819ULL, 0x000fc60000011410ULL, 0x0000005c005d7306ULL, 0x000ff00000209400ULL,
0x0000005c005e7306ULL, 0x0002e20000205400ULL, 0x000000575800720bULL, 0x004fe20003f1d000ULL,
0x000100003b577824ULL, 0x000fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x0000004900537306ULL, 0x000fe20000209400ULL, 0x0000005c005c7245ULL, 0x002fca000020d400ULL,
0x0000000167670812ULL, 0x000fe400078efcffULL, 0x00000049006c7306ULL, 0x000e620000205400ULL,
0x0000005e5d00720bULL, 0x008fe40003f7d000ULL, 0x0000004f005d7245ULL, 0x000fc8000020d400ULL,
0x000000015d5d6812ULL, 0x000fe200078efcffULL, 0x0000001000637306ULL, 0x000fec0000009400ULL,
0x000000015c5c3812ULL, 0x000fe400078efcffULL, 0x0000001000627306ULL, 0x000ea20000005400ULL,
0x0000006c5300720bULL, 0x002fce0003fdd000ULL, 0x0000003a00477306ULL, 0x000e70000000d400ULL,
0x0000004800397306ULL, 0x000fe20000209400ULL, 0x000000626300720bULL, 0x004fe40003f1d000ULL,
0x0000004900627245ULL, 0x000fc4000020d400ULL, 0x0000004800637245ULL, 0x000fe4000020d400ULL,
0x0000000162626812ULL, 0x000fe200078efcffULL, 0x00000048003a7306ULL, 0x000ea20000205400ULL,
0x0000000147474812ULL, 0x002fce00078efcffULL, 0x0000004600457306ULL, 0x000ff00000209400ULL,
0x00000046006b7306ULL, 0x000e620000205400ULL, 0x0000003a3900720bULL, 0x004fe40003fdd000ULL,
0x00000018ff397819ULL, 0x000fc40000011412ULL, 0x00000018ff3a7819ULL, 0x000fc60000011413ULL,
0x00000011004b7306ULL, 0x000fec0000009400ULL, 0x0000000163636812ULL, 0x000fe400078efcffULL,
0x0000001100667306ULL, 0x000ea20000005400ULL, 0x0000006b4500720bULL, 0x002fe20003fdd000ULL,
0x00010000106b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001146bULL,
0x0000003b004a7306ULL, 0x000e70000000d400ULL, 0x00000012004d7306ULL, 0x000fe20000009400ULL,
0x000000664b00720bULL, 0x004fe20003f9d000ULL, 0x00000100104b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x0000001200507306ULL, 0x000ea20000005400ULL,
0x000000014a4a2812ULL, 0x002fce00078efcffULL, 0x0000005700587306ULL, 0x000ff00000209400ULL,
0x00000057006a7306ULL, 0x000e620000205400ULL, 0x000000504d00720bULL, 0x004fe40003f5d000ULL,
0x0000004600507245ULL, 0x000fe2000020d400ULL, 0x0000010011467824ULL, 0x000fc600078e00ffULL,
0x0000000150506812ULL, 0x000fe200078efcffULL, 0x0000001300517306ULL, 0x000fe20000009400ULL,
0x00000018ff467819ULL, 0x000fce0000011446ULL, 0x00000013004e7306ULL, 0x000ea20000005400ULL,
0x0000006a5800720bULL, 0x002fe40003fdd000ULL, 0x0000003e00587245ULL, 0x000fc8000020d400ULL,
0x0000000158585812ULL, 0x000fe200078efcffULL, 0x0000004b004d7306ULL, 0x000ff00000209400ULL,
0x0000004b00547306ULL, 0x000e620000205400ULL, 0x0000004e5100720bULL, 0x004fc40003fbd000ULL,
0x00000057004e7245ULL, 0x000fe4000020d400ULL, 0x0000004b00517245ULL, 0x000fe4000020d400ULL,
0x000000014e4e6812ULL, 0x000fe200078efcffULL, 0x0000005200597306ULL, 0x000ff00000209400ULL,
0x00000052005e7306ULL, 0x0004e20000205400ULL, 0x000000544d00720bULL, 0x002fe20003fdd000ULL,
0x00010000114d7824ULL, 0x000fc400078e00ffULL, 0x0000010012547824ULL, 0x000fc800078e00ffULL,
0x00000046003e7306ULL, 0x000fe20000209400ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000005200527245ULL, 0x004fc6000020d400ULL, 0x0000000151516812ULL, 0x000fe400078efcffULL,
0x00000046006d7306ULL, 0x000e620000205400ULL, 0x0000005e5900720bULL, 0x008fe40003f7d000ULL,
0x00000018ff5e7819ULL, 0x000fca000001144dULL, 0x0000001000447306ULL, 0x000eac000000d400ULL,
0x0000000152523812ULL, 0x000fe400078efcffULL, 0x0000003f003b7306ULL, 0x000fe20000209400ULL,
0x0000006d3e00720bULL, 0x002fce0003fdd000ULL, 0x0000003f00497306ULL, 0x000e620000205400ULL,
0x0000000144440812ULL, 0x004fc800078efcffULL, 0x000000445144723eULL, 0x000fc600000010ffULL,
0x00000011003d7306ULL, 0x000eb0000000d400ULL, 0x0000006b00107306ULL, 0x000fe20000209400ULL,
0x000000493b00720bULL, 0x002fe20003f1d000ULL, 0x00000100133b7824ULL, 0x000fe200078e00ffULL,
0x0000004600497245ULL, 0x000fc8000020d400ULL, 0x0000000149496812ULL, 0x000fe200078efcffULL,
0x0000006b00117306ULL, 0x000e620000205400ULL, 0x000000013d3d4812ULL, 0x004fe400078efcffULL,
0x00000018ff467819ULL, 0x000fe2000001143bULL, 0x00010000123b7824ULL, 0x000fc800078e00ffULL,
0x0000005e004b7306ULL, 0x000fe20000209400ULL, 0x00000018ff3b7819ULL, 0x000fce000001143bULL,
0x0000005e003e7306ULL, 0x0004e20000205400ULL, 0x000000111000720bULL, 0x002fe40003fdd000ULL,
0x000000476210723eULL, 0x000fe400000010ffULL, 0x0000006b00477245ULL, 0x000fe4000020d400ULL,
0x0000004a6311723eULL, 0x000fe200000010ffULL, 0x00000039004f7306ULL, 0x000fe20000209400ULL,
0x0000005e005e7245ULL, 0x004fca000020d400ULL, 0x0000000147476812ULL, 0x000fe200078efcffULL,
0x000000103018723cULL, 0x000b620000041818ULL, 0x0000003900537306ULL, 0x000e620000205400ULL,
0x0000003e4b00720bULL, 0x008fe20003f9d000ULL, 0x00010000133e7824ULL, 0x000fc800078e00ffULL,
0x0000003f00117245ULL, 0x020fe4000020d400ULL, 0x0000005400667306ULL, 0x000fe20000209400ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000054003f7245ULL, 0x000fe4000020d400ULL,
0x0000000111110812ULL, 0x000fe400078efcffULL, 0x000000015e5e4812ULL, 0x000fe200078efcffULL,
0x00000054006a7306ULL, 0x000ea20000205400ULL, 0x000000534f00720bULL, 0x002fc40003fdd000ULL,
0x000000475210723eULL, 0x000fe400000010ffULL, 0x0000005e1111723eULL, 0x000fe400000010ffULL,
0x0000003900397245ULL, 0x000fe2000020d400ULL, 0x00000012003c7306ULL, 0x0002e8000000d400ULL,
0x000000103028723cULL, 0x000b640000041828ULL, 0x0000000139396812ULL, 0x000fc400078efcffULL,
0x0000004600577306ULL, 0x000fe20000209400ULL, 0x0000006a6600720bULL, 0x004fe40003f7d000ULL,
0x0000005b5f12723eULL, 0x002fe400000010ffULL, 0x0000003b00107245ULL, 0x020fe4000020d400ULL,
0x0000003e00117245ULL, 0x000fe2000020d400ULL, 0x0000004600597306ULL, 0x000e620000205400ULL,
0x000000013c3c2812ULL, 0x008fca00078efcffULL, 0x000000013f3f3812ULL, 0x000fe400078efcffULL,
0x0000003a00457306ULL, 0x000fe40000209400ULL, 0x0000003c3f3c723eULL, 0x000fcc00000010ffULL,
0x0000003a00487306ULL, 0x0004e20000205400ULL, 0x000000595700720bULL, 0x002fce0003f1d000ULL,
0x0000003b004b7306ULL, 0x000fe20000209400ULL, 0x0000003a003a7245ULL, 0x004fce000020d400ULL,
0x0000003b004d7306ULL, 0x000e620000205400ULL, 0x000000484500720bULL, 0x008fe40003f9d000ULL,
0x0000003d4945723eULL, 0x000fe400000010ffULL, 0x00000046003d7245ULL, 0x000fc6000020d400ULL,
0x0000003e004a7306ULL, 0x000fe20000209400ULL, 0x000000013d3d0812ULL, 0x000fe200078efcffULL,
0x000000443024723cULL, 0x000f680000041824ULL, 0x000000013a3a4812ULL, 0x000fe400078efcffULL,
0x0000003e004f7306ULL, 0x000ea20000205400ULL, 0x0000004d4b00720bULL, 0x002fce0003f7d000ULL,
0x0000001300387306ULL, 0x0002ec000000d400ULL, 0x0000000110103812ULL, 0x000fe400078efcffULL,
0x0000004f4a00720bULL, 0x004fe40003f5d000ULL, 0x0000005d6713723eULL, 0x002fc400000010ffULL,
0x000000103910723eULL, 0x000fe400000010ffULL, 0x0000000138385812ULL, 0x008fc600078efcffULL,
0x00000012301c723cULL, 0x000b62000004181cULL, 0x000000383d3d723eULL, 0x000fc600000010ffULL,
0x0000000111112812ULL, 0x000fc600078efcffULL, 0x000000505812723eULL, 0x020fe400000010ffULL,
0x0000004e5c13723eULL, 0x000fe200000010ffULL, 0x0000003c302c723cULL, 0x000f62000004182cULL,
0x000000113a11723eULL, 0x000fce00000010ffULL, 0x000000123014723cULL, 0x040f700000041814ULL,
0x000000103030723cULL, 0x000b6e0000041840ULL, 0x0000f6c86e107811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000010107f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f690005aff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff3a7224ULL, 0x000fc600078e00ffULL, 0x0000000000127805ULL, 0x000fc80000015200ULL,
0x0000040005397984ULL, 0x000ee40000000800ULL, 0x8000000039ff7812ULL, 0x00afc40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x00000038123b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e13ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff387819ULL, 0x000fc80000011439ULL, 0x0000003b38387211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x0000000238387819ULL, 0x000fc80000001239ULL,
0x000000380000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040005397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c056117810ULL, 0x000fca0007ffe0ffULL,
0x00006800733b7a24ULL, 0x000fe200078e0211ULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x0000001168107217ULL, 0x000fe20007800000ULL, 0x0000001072137824ULL, 0x000fe200078e00ffULL,
0x00000003ff127819ULL, 0x000fc60000011602ULL, 0x0000000110107824ULL, 0x000fe200078e0a11ULL,
0x0000000412397810ULL, 0x040fe20007ffe0ffULL, 0x0000000113117824ULL, 0x040fe200078e0212ULL,
0x00000008123a7810ULL, 0x000fe40007ffe0ffULL, 0x0000001013107217ULL, 0x000fe20007800000ULL,
0x0000000111387824ULL, 0x040fe400078e0202ULL, 0x00000008113d7824ULL, 0x000fe400078e00ffULL,
0x0000000110107824ULL, 0x000fc400078e0a13ULL, 0x0000000111117824ULL, 0x000fe200078e023bULL,
0xfffffff83d3c7812ULL, 0x000fe200078ee238ULL, 0x0000000113387824ULL, 0x000fe200078e0239ULL,
0x0000000c123d7810ULL, 0x000fe40007ffe0ffULL, 0x000000103900720cULL, 0x080fe20003f66070ULL,
0x0000000838417824ULL, 0x000fe200078e00ffULL, 0x000000101200720cULL, 0x080fe20003f86070ULL,
0x0000000138127824ULL, 0x000fe200078e0202ULL, 0x000000103a00720cULL, 0x080fe20003f46070ULL,
0x0000000113397824ULL, 0x000fe200078e023aULL, 0x000000103d00720cULL, 0x000fe20003f06070ULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0xfffffff8413e7812ULL, 0x000fc600078ee212ULL,
0x0000000138387824ULL, 0x000fe200078e023bULL, 0x0000006010107212ULL, 0x000fe200078efcffULL,
0x00000001133f7824ULL, 0x000fe400078e023dULL, 0x00000001393a7824ULL, 0x040fe200078e023bULL,
0x0000640010107a10ULL, 0x000fe20007fbe0ffULL, 0x0000000139137824ULL, 0x040fe400078e0202ULL,
0x0000000839407824ULL, 0x000fe200078e00ffULL, 0x0000650011117a10ULL, 0x000fe20002ffe4ffULL,
0x0000008038387825ULL, 0x000fc600078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee213ULL,
0x000000013f127824ULL, 0x000fe200078e023bULL, 0x0000006038387212ULL, 0x000fe200078efcffULL,
0x000000803a3a7825ULL, 0x000fc600078e00ffULL, 0x0000640038387a10ULL, 0x000fe20007fbe0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000603a3a7212ULL, 0x080fe400078efcffULL,
0x0000650039397a10ULL, 0x000fe20002ffe4ffULL, 0x000000013f3d7824ULL, 0x040fe200078e0202ULL,
0x0000006012127212ULL, 0x000fe200078efcffULL, 0x000000083f427824ULL, 0x000fe200078e00ffULL,
0x000064003a3a7a10ULL, 0x000fe20007fbe0ffULL, 0x000000103e3f7824ULL, 0x100fe200078e0271ULL,
0x0000640012127a10ULL, 0x000fe20007fde0ffULL, 0x0000001040417824ULL, 0x000fe200078e0271ULL,
0xfffffff842427812ULL, 0x000fe200078ee23dULL, 0x000000103c3d7824ULL, 0x000fe200078e0271ULL,
0x000065003b3b7a10ULL, 0x000fc40002ffe4ffULL, 0x0000650013137a10ULL, 0x000fe200037fe4ffULL,
0x0000001042437824ULL, 0x000fe200078e0271ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000103d7faeULL, 0x0003e8000e101c46ULL, 0x00000000383f7faeULL, 0x0003e8000d901c46ULL,
0x000000003a417faeULL, 0x0003e8000d101c46ULL, 0x0000000012437faeULL, 0x0003e2000c101c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001072117824ULL, 0x000fca00078e00ffULL,
0x0000001102117211ULL, 0x000fc800078fe8ffULL, 0x0000000411387810ULL, 0x040fe20007ffe0ffULL,
0x0000000111107824ULL, 0x140fe200078e0202ULL, 0x00000008113a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000811397824ULL, 0x000fe400078e00ffULL, 0x0000000138127824ULL, 0x040fe400078e0202ULL,
0x00000008383d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8393c7812ULL, 0x000fe200078ee210ULL,
0x000000013a137824ULL, 0x040fe400078e0202ULL, 0x000000083a407824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3e7812ULL, 0x000fe200078ee212ULL, 0x0000000111127824ULL, 0x140fe200078e023bULL,
0x0000000c11117810ULL, 0x000fe20007ffe0ffULL, 0x0000000138387824ULL, 0x000fe200078e023bULL,
0xfffffff840407812ULL, 0x000fe200078ee213ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x000000013a3a7824ULL, 0x100fe200078e023bULL, 0x0000006012127212ULL, 0x000fe200078efcffULL,
0x0000000111107824ULL, 0x000fe400078e023bULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fc60007f1e0ffULL, 0x00000001113d7824ULL, 0x040fe200078e0202ULL,
0x0000006038387212ULL, 0x080fe200078efcffULL, 0x0000000811427824ULL, 0x000fe200078e00ffULL,
0x0000650013137a10ULL, 0x000fe200007fe4ffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000640038387a10ULL, 0x000fe40007f5e0ffULL, 0xfffffff842427812ULL, 0x000fe200078ee23dULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000603a3a7212ULL, 0x080fe400078efcffULL,
0x0000650039397a10ULL, 0x000fe200017fe4ffULL, 0x000000103c3d7824ULL, 0x100fe200078e0271ULL,
0x0000006010107212ULL, 0x000fe200078efcffULL, 0x000000103e3f7824ULL, 0x100fe200078e0271ULL,
0x000064003a3a7a10ULL, 0x000fe20007f1e0ffULL, 0x0000001040417824ULL, 0x100fe200078e0271ULL,
0x0000640010107a10ULL, 0x000fe20007f7e0ffULL, 0x0000001042437824ULL, 0x000fe200078e0271ULL,
0x000065003b3b7a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000123d7faeULL, 0x0003e2000b901c46ULL, 0x0000650011117a10ULL, 0x000fc60001ffe4ffULL,
0x00000000383f7faeULL, 0x0003e8000b901c46ULL, 0x000000003a417faeULL, 0x0003e8000b901c46ULL,
0x0000000010437faeULL, 0x0003e4000b901c46ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff003387812ULL, 0x000fce00078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6b00038387f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480006107f8cULL, 0x0006a4000c80043fULL,
0x0000000000127805ULL, 0x000fc40000015200ULL, 0xffffffe003067812ULL, 0x048fe400078ec0ffULL,
0x00000010033b7812ULL, 0x040fe400078ec0ffULL, 0x00000008033a7812ULL, 0x000fc800078ec0ffULL,
0x000000063a067210ULL, 0x000fca0007ffe03bULL, 0x00f64c00063b7984ULL, 0x000ee40000000800ULL,
0x800000003bff7812ULL, 0x00cfe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a123d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e13ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f64c00063b7984ULL, 0x000ea40000000800ULL, 0x800000003bff7812ULL, 0x004fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000067824ULL, 0x000fca00078e00ffULL,
0xffffff8006117812ULL, 0x000fc800078ec0ffULL, 0x0000010060067810ULL, 0x000fca0007ffe011ULL,
0x0000000165067824ULL, 0x000fca00078e0206ULL, 0x00f0000006137984ULL, 0x000ea80000000800ULL,
0x00f2000006127984ULL, 0x0006620000000800ULL, 0x0000000e1300720bULL, 0x004fe20003f1d000ULL,
0x0000e0227f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff3c3b7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff3c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff067224ULL, 0x000fd200078e000eULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x0000000275117810ULL, 0x000fe40007ffe0ffULL,
0x0000000e1300720bULL, 0x000fe40003f54000ULL, 0x000000001100720cULL, 0x000fe20003f05270ULL,
0x0000dfc27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000067806ULL, 0x000fc400010e0100ULL,
0x00000080003a8824ULL, 0x000fe200078e0260ULL, 0x0000000e13108209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991006117816ULL, 0x000fe200000000ffULL,
0x00000001653d8824ULL, 0x000fca00078e023aULL, 0x00f400103d008388ULL, 0x0005e20000000800ULL,
0x000000ff1100720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000e13117209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff06ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000e11107221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x00000010003a7308ULL, 0x000ea40000000800ULL,
0x0000003a0d0d7220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe20000011602ULL, 0x0000dee27f007947ULL, 0x000fea000b800000ULL,
0x00001f103a3c7589ULL, 0x0004e400000e0000ULL, 0x0000003c20207220ULL, 0x08cfe20000410000ULL,
0x0000003c21217220ULL, 0x080fe20000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000003c18187220ULL, 0x080fe20000410000ULL,
0x0000003c19197220ULL, 0x080fe20000410000ULL, 0x0000003c14147220ULL, 0x080fe20000410000ULL,
0x0000003c15157220ULL, 0x080fe20000410000ULL, 0x0000003c24247220ULL, 0x080fe20000410000ULL,
0x0000003c25257220ULL, 0x080fe20000410000ULL, 0x0000003c28287220ULL, 0x080fe20000410000ULL,
0x0000003c29297220ULL, 0x080fe20000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000003c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000003c30307220ULL, 0x080fe20000410000ULL,
0x0000003c31317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0006ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802107811ULL, 0x000fe200078ff0ffULL, 0x0000ddc27f007947ULL, 0x000fea000b800000ULL,
0x00001f103a3c7589ULL, 0x0004e400000e0000ULL, 0x0000003c22227220ULL, 0x08cfe20000410000ULL,
0x0000003c23237220ULL, 0x080fe20000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000003c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003c16167220ULL, 0x080fe20000410000ULL,
0x0000003c17177220ULL, 0x080fe20000410000ULL, 0x0000003c26267220ULL, 0x080fe20000410000ULL,
0x0000003c27277220ULL, 0x080fe20000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000003c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000003c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000003c32327220ULL, 0x080fe20000410000ULL,
0x0000003c33337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff3bff7812ULL, 0x000fe20007806006ULL, 0x00000001ff3c7424ULL, 0x000fe200078e00ffULL,
0x0000000e13067209ULL, 0x000fd60007810000ULL, 0x8000000613130221ULL, 0x000fe20000010000ULL,
0x00007610ff3c0816ULL, 0x000fc6000000003cULL, 0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL,
0x0000001300070308ULL, 0x000ea40000000800ULL, 0x0000000712120220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000d12127221ULL, 0x002fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0xfffffff0033d7812ULL, 0x000fca00078ec0ffULL,
0x00f6ac003d0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a100e7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3a7824ULL, 0x000fe200000e0e11ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc8000001143aULL,
0x0000000e0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e063aULL,
0x000000020d0d7819ULL, 0x000fc8000000120eULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000113137810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac003d0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099103c0d7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000010ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011602ULL,
0x00005410080d7816ULL, 0x000fe20000000008ULL, 0x0000d9827f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0d087589ULL, 0x0002a400000e0000ULL, 0x000000080e107810ULL, 0x000fe20007ffe0ffULL,
0x0000d9b27f007947ULL, 0x000fea000b800000ULL, 0x00001f100d097589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100e107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200078e000dULL, 0x00009990003d7802ULL, 0x000fc40000000f00ULL,
0x0000e00000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180e107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200078e000dULL,
0x000099e0003d7802ULL, 0x000fc40000000f00ULL, 0x0000dfb000007944ULL, 0x006fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000100f447824ULL, 0x100fe200078e0264ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000001036407824ULL, 0x000fc400078e0264ULL,
0x00a000003734783bULL, 0x000f220000000200ULL, 0x00000010553c7824ULL, 0x004fc600078e0264ULL,
0x000000004444783bULL, 0x000ea80000004200ULL, 0x000000004040783bULL, 0x000ee80000004200ULL,
0x000000003c3c783bULL, 0x000fe20000004200ULL, 0x0000000834348231ULL, 0x090fe400003400ffULL,
0x0000000836368231ULL, 0x000fe200003400ffULL, 0x00000100440e7824ULL, 0x006fe200078e00ffULL,
0x00000044000d7306ULL, 0x008fe20000009400ULL, 0x0000000935358231ULL, 0x000fc400003400ffULL,
0x0000000937378231ULL, 0x000fe200003400ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001140eULL,
0x00000100450e7824ULL, 0x000fc600078e00ffULL, 0x00000044004a7306ULL, 0x000e640000005400ULL,
0x00000018ff5d7819ULL, 0x000fcc000001140eULL, 0x0000004500577306ULL, 0x000ff00000009400ULL,
0x00000045005a7306ULL, 0x000ea20000005400ULL, 0x0000004a0d00720bULL, 0x002fe40003f5d000ULL,
0x0000005d004a7245ULL, 0x000fca000020d400ULL, 0x0000004b000f7306ULL, 0x000ff00000209400ULL,
0x0000004b00587306ULL, 0x0002e20000205400ULL, 0x0000005a5700720bULL, 0x004fce0003f9d000ULL,
0x0000005d006a7306ULL, 0x000fe20000209400ULL, 0x0000004b004b7245ULL, 0x002fce000020d400ULL,
0x0000005d006b7306ULL, 0x000e620000205400ULL, 0x000000580f00720bULL, 0x008fce0003f7d000ULL,
0x0000004400487306ULL, 0x000eac000000d400ULL, 0x000000014b4b3812ULL, 0x000fe400078efcffULL,
0x0000004500497306ULL, 0x000ee2000000d400ULL, 0x0000006b6a00720bULL, 0x002fe40003fbd000ULL,
0x0000000148482812ULL, 0x004fca00078efcffULL, 0x0000004600627306ULL, 0x000fe20000009400ULL,
0x000000484b48723eULL, 0x000fca00000010ffULL, 0x000000014a4a5812ULL, 0x000fe400078efcffULL,
0x0000000149494812ULL, 0x008fe200078efcffULL, 0x0000004600677306ULL, 0x000e660000005400ULL,
0x000000494a49723eULL, 0x000fca00000010ffULL, 0x0000004700667306ULL, 0x000fe40000009400ULL,
0x000000483448723cULL, 0x000b6c0000041824ULL, 0x00000047005f7306ULL, 0x000ea20000005400ULL,
0x0001000044277824ULL, 0x020fe200078e00ffULL, 0x000000676200720bULL, 0x002fe20003f9d000ULL,
0x0001000045267824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fc40000011444ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000004000597306ULL, 0x000fe20000009400ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff257819ULL, 0x000fe20000011445ULL,
0x0000010046457824ULL, 0x000fc800078e00ffULL, 0x00000040005e7306ULL, 0x000e620000005400ULL,
0x0000005f6600720bULL, 0x004fe40003fbd000ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000002600667245ULL, 0x000fc6000020d400ULL, 0x00000027006b7306ULL, 0x000ff00000209400ULL,
0x0000002700627306ULL, 0x0004e20000205400ULL, 0x0000005e5900720bULL, 0x002fce0003f5d000ULL,
0x00000024006a7306ULL, 0x000fe20000209400ULL, 0x0000002700277245ULL, 0x004fce000020d400ULL,
0x00000024006d7306ULL, 0x0002a20000205400ULL, 0x000000626b00720bULL, 0x008fce0003fdd000ULL,
0x00000026005f7306ULL, 0x000fe20000209400ULL, 0x0000002400247245ULL, 0x002fca000020d400ULL,
0x0000000127276812ULL, 0x000fe400078efcffULL, 0x00000026005e7306ULL, 0x000e620000205400ULL,
0x0000006d6a00720bULL, 0x004fe40003f7d000ULL, 0x00000045006a7245ULL, 0x000fca000020d400ULL,
0x0000002500447306ULL, 0x000fec0000209400ULL, 0x0000000124243812ULL, 0x000fe400078efcffULL,
0x0000002500597306ULL, 0x0004e20000205400ULL, 0x0000005e5f00720bULL, 0x002fe40003fdd000ULL,
0x000000272424723eULL, 0x000fca00000010ffULL, 0x0000004500627306ULL, 0x000fe20000209400ULL,
0x0000002500257245ULL, 0x004fca000020d400ULL, 0x0000000166666812ULL, 0x000fe400078efcffULL,
0x0000004500677306ULL, 0x000e620000205400ULL, 0x000000594400720bULL, 0x008fe20003f7d000ULL,
0x0000010047447824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fc80000011446ULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0000004600637306ULL, 0x000eac000000d400ULL,
0x0000000125253812ULL, 0x000fe400078efcffULL, 0x000000676200720bULL, 0x002fe20003fdd000ULL,
0x0000004400267306ULL, 0x000fe20000209400ULL, 0x000000662525723eULL, 0x000fe200000010ffULL,
0x0001000046667824ULL, 0x000fca00078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000004400677306ULL, 0x000e620000205400ULL, 0x0000000163634812ULL, 0x004fc600078efcffULL,
0x000000016a6a6812ULL, 0x000fc800078efcffULL, 0x00000047003a7306ULL, 0x000ea2000000d400ULL,
0x000000672600720bULL, 0x002fce0003fdd000ULL, 0x00000041005b7306ULL, 0x000fe20000009400ULL,
0x000000243424723cULL, 0x000b620000041828ULL, 0x000000013a3a5812ULL, 0x004fcc00078efcffULL,
0x00000041005c7306ULL, 0x000e620000005400ULL, 0x0000000702297812ULL, 0x020fe400078ec0ffULL,
0x000000636a28723eULL, 0x000fe200000010ffULL, 0x00010000476a7824ULL, 0x000fe200078e00ffULL,
0x0000000829297812ULL, 0x000fe400078ef802ULL, 0x00000018ff637819ULL, 0x000fe20000011440ULL,
0x00000066002a7306ULL, 0x000fe20000209400ULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x0000000829467824ULL, 0x000fe200078e00ffULL, 0x000000024c297810ULL, 0x000fc80007ffe0ffULL,
0xfffffff846457812ULL, 0x000fe200078ee229ULL, 0x00000066002b7306ULL, 0x000ea20000205400ULL,
0x0000004400297245ULL, 0x000fe4000020d400ULL, 0x0000005c5b00720bULL, 0x002fe40003f7d000ULL,
0x0000000129296812ULL, 0x000fe400078efcffULL, 0x00000018ff5b7819ULL, 0x000fe20000011447ULL,
0x00000059005f7306ULL, 0x000fe20000209400ULL, 0x0000003a2929723eULL, 0x000fe200000010ffULL,
0x00000010453a7824ULL, 0x000fca00078e00ffULL, 0x0000a0000a0a7810ULL, 0x000fe20007ffe03aULL,
0x0000005900627306ULL, 0x0002e20000205400ULL, 0x0000002b2a00720bULL, 0x004fe40003fbd000ULL,
0x000000283428723cULL, 0x000b62000004182cULL, 0x000000000a44783bULL, 0x0005280000000200ULL,
0x0000006a006b7306ULL, 0x000fe40000209400ULL, 0x00000100402e7824ULL, 0x020fe200078e00ffULL,
0x00000066002c7245ULL, 0x000fc4000020d400ULL, 0x00000059002d7245ULL, 0x000fe2000020d400ULL,
0x0000010041597824ULL, 0x002fe200078e00ffULL, 0x000000012c2c5812ULL, 0x000fe200078efcffULL,
0x0000006a006c7306ULL, 0x0002620000205400ULL, 0x000000625f00720bULL, 0x008fe40003fdd000ULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000006a000a7245ULL, 0x004fe4000020d400ULL,
0x00000018ff667819ULL, 0x000fe20000011441ULL, 0x0000005b005c7306ULL, 0x000fe20000209400ULL,
0x00000018ff6a7819ULL, 0x002fca0000011459ULL, 0x000000012d2d6812ULL, 0x000fe400078efcffULL,
0x0000005b00677306ULL, 0x000e620000205400ULL, 0x0000006c6b00720bULL, 0x000fe40003fbd000ULL,
0x0000002c2d2c723eULL, 0x000fca00000010ffULL, 0x00000043000d7306ULL, 0x000fe20000009400ULL,
0x0000000844448231ULL, 0x010fca00003400ffULL, 0x000000010a0a5812ULL, 0x000fe200078efcffULL,
0x0000000846468231ULL, 0x000fe200003400ffULL, 0x00000043005a7306ULL, 0x000ea20000005400ULL,
0x000000675c00720bULL, 0x002fe20003fdd000ULL, 0x0001000040677824ULL, 0x000fe200078e00ffULL,
0x0000000945458231ULL, 0x080fe400003400ffULL, 0x0000000947478231ULL, 0x000fe400003400ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000002e005f7306ULL, 0x000ff00000209400ULL,
0x0000002e00627306ULL, 0x000e620000205400ULL, 0x0000005a0d00720bULL, 0x004fc40003fbd000ULL,
0x0000005b000d7245ULL, 0x000fc8000020d400ULL, 0x000000010d0d6812ULL, 0x000fe200078efcffULL,
0x00000063002f7306ULL, 0x000fe60000209400ULL, 0x0000000a0d2d723eULL, 0x000fe400000010ffULL,
0x00000008020d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff0a7819ULL, 0x000fe2000001143eULL,
0x00000063005c7306ULL, 0x0004e20000205400ULL, 0x000000625f00720bULL, 0x002fc40003fdd000ULL,
0x000000070d0d7812ULL, 0x000fca00078ef802ULL, 0x0000006a00597306ULL, 0x000fe20000209400ULL,
0x0000006300637245ULL, 0x004fce000020d400ULL, 0x0000006a005a7306ULL, 0x0002a20000205400ULL,
0x0000005c2f00720bULL, 0x008fe40003f1d000ULL, 0x0000002e002f7245ULL, 0x000fc8000020d400ULL,
0x000000012f2f6812ULL, 0x000fe200078efcffULL, 0x00000040000e7306ULL, 0x000722000000d400ULL,
0x0000006a006a7245ULL, 0x002fca000020d400ULL, 0x0000000163630812ULL, 0x000fe400078efcffULL,
0x00000041000f7306ULL, 0x000e62000000d400ULL, 0x0001000041407824ULL, 0x008fe200078e00ffULL,
0x0000005a5900720bULL, 0x004fc80003fdd000ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000066005b7306ULL, 0x000fe20000209400ULL, 0x000000010e0e2812ULL, 0x010fc800078efcffULL,
0x0000000e2f0e723eULL, 0x000fe400000010ffULL, 0x000000016a6a6812ULL, 0x000fe200078efcffULL,
0x0000006600627306ULL, 0x0004e20000205400ULL, 0x000000010f0f3812ULL, 0x002fc800078efcffULL,
0x0000000f6a0f723eULL, 0x000fe200000010ffULL, 0x00010000436a7824ULL, 0x000fe400078e00ffULL,
0x00000067002e7306ULL, 0x000fe20000209400ULL, 0x0000006600667245ULL, 0x004fe4000020d400ULL,
0x00000018ff6a7819ULL, 0x000fca000001146aULL, 0x0000006700417306ULL, 0x000e620000205400ULL,
0x000000625b00720bULL, 0x008fe20003f5d000ULL, 0x0000010042627824ULL, 0x000fca00078e00ffULL,
0x00000018ff627819ULL, 0x000fe20000011462ULL, 0x00000040005c7306ULL, 0x000fec0000209400ULL,
0x0000000166662812ULL, 0x000fe400078efcffULL, 0x00000040005f7306ULL, 0x000ea20000205400ULL,
0x000000412e00720bULL, 0x002fc40003fdd000ULL, 0x0000002c342c723cULL, 0x000b620000041830ULL,
0x00000018ff417819ULL, 0x000fc8000001143dULL, 0x0000006200327306ULL, 0x020fe40000209400ULL,
0x000000010d337824ULL, 0x040fe200078e020cULL, 0x0000006700307245ULL, 0x000fe2000020d400ULL,
0x000000080d0c7824ULL, 0x000fe200078e00ffULL, 0x0000004000317245ULL, 0x000fe4000020d400ULL,
0x0000000130306812ULL, 0x000fe200078efcffULL, 0x0000004200587306ULL, 0x000fe20000009400ULL,
0x0000005f5c00720bULL, 0x004fe40003f7d000ULL, 0xfffffff80c337812ULL, 0x000fc400078ee233ULL,
0x0000000e440c723cULL, 0x000be20000041848ULL, 0x000000306330723eULL, 0x000fe400000010ffULL,
0x00000062004b7306ULL, 0x020e620000205400ULL, 0x0000001033337824ULL, 0x000fe200078e0264ULL,
0x00000018ff637819ULL, 0x000fe40000011442ULL, 0x0000010043497824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe4000001143fULL, 0x0000000131313812ULL, 0x000fe200078efcffULL,
0x00000042005d7306ULL, 0x000ea20000005400ULL, 0x00000018ff497819ULL, 0x000fc40000011449ULL,
0x000000316631723eULL, 0x000fca00000010ffULL, 0x0000004900677306ULL, 0x000fe20000209400ULL,
0x0000004b3200720bULL, 0x002fe20003f1d000ULL, 0x000000304424723cULL, 0x000be40000041824ULL,
0x000000003330783bULL, 0x020e680000004200ULL, 0x0000004900487306ULL, 0x0007220000205400ULL,
0x0000005d5800720bULL, 0x004fe40003f9d000ULL, 0x00000018ff587819ULL, 0x000fca000001143cULL,
0x0000004200577306ULL, 0x000ea2000000d400ULL, 0x0000004900497245ULL, 0x008fce000020d400ULL,
0x00000043005e7306ULL, 0x000ee2000000d400ULL, 0x000000486700720bULL, 0x010fe40003f5d000ULL,
0x0000006200487245ULL, 0x000fe4000020d400ULL, 0x00000018ff627819ULL, 0x000fe40000011443ULL,
0x0000000148480812ULL, 0x000fe200078efcffULL, 0x00000063004b7306ULL, 0x000fe20000209400ULL,
0x0000000157574812ULL, 0x004fc800078efcffULL, 0x000000574848723eULL, 0x000fe200000010ffULL,
0x0001000042577824ULL, 0x000fe200078e00ffULL, 0x0000000149492812ULL, 0x000fe200078efcffULL,
0x0000006200667306ULL, 0x000fe20000209400ULL, 0x000000015e5e5812ULL, 0x008fe400078efcffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000005e4949723eULL, 0x000fc600000010ffULL,
0x00000062006b7306ULL, 0x0004e80000205400ULL, 0x000000484428723cULL, 0x000be80000041828ULL,
0x0000006300677306ULL, 0x000f220000205400ULL, 0x0000006200627245ULL, 0x004fce000020d400ULL,
0x00000057006c7306ULL, 0x000fe20000209400ULL, 0x0000006b6600720bULL, 0x008fe20003f9d000ULL,
0x0000010030667824ULL, 0x002fca00078e00ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000005700427306ULL, 0x000e620000205400ULL, 0x000000674b00720bULL, 0x010fe20003f1d000ULL,
0x0000010031677824ULL, 0x000fc800078e00ffULL, 0x0000000162624812ULL, 0x000fe400078efcffULL,
0x0000006a00437306ULL, 0x000fe20000209400ULL, 0x00000018ff677819ULL, 0x000fce0000011467ULL,
0x0000006a005e7306ULL, 0x000ea20000205400ULL, 0x000000426c00720bULL, 0x002fce0003fbd000ULL,
0x00000030006d7306ULL, 0x000ff00000009400ULL, 0x0000003000487306ULL, 0x020e620000005400ULL,
0x0000005e4300720bULL, 0x004fce0003fdd000ULL, 0x0000006600427306ULL, 0x000ff00000209400ULL,
0x0000006600437306ULL, 0x000ea20000205400ULL, 0x000000486d00720bULL, 0x002fe40003f7d000ULL,
0x00000063006d7245ULL, 0x000fc8000020d400ULL, 0x000000016d6d0812ULL, 0x000fe200078efcffULL,
0x0000003100497306ULL, 0x000ff00000009400ULL, 0x00000031006c7306ULL, 0x000e620000005400ULL,
0x000000434200720bULL, 0x004fc40003f1d000ULL, 0x0000005700427245ULL, 0x000fe4000020d400ULL,
0x0000006a00437245ULL, 0x000fe4000020d400ULL, 0x0000000142425812ULL, 0x000fe200078efcffULL,
0x00000067005e7306ULL, 0x000fe20000209400ULL, 0x0000000143436812ULL, 0x000fe400078efcffULL,
0x000000426d42723eULL, 0x000fe400000010ffULL, 0x000000436243723eULL, 0x000fc600000010ffULL,
0x0000006700637306ULL, 0x000ea20000205400ULL, 0x0000006c4900720bULL, 0x002fe20003f5d000ULL,
0x000001003c497824ULL, 0x000fe400078e00ffULL, 0x00000042442c723cULL, 0x000be6000004182cULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x00000031006a7306ULL, 0x000e66000000d400ULL,
0x0000006700437245ULL, 0x020fc4000020d400ULL, 0x0000006600427245ULL, 0x000fe4000020d400ULL,
0x000000635e00720bULL, 0x004fe20003f9d000ULL, 0x00000030006b7306ULL, 0x000ea2000000d400ULL,
0x0000000142420812ULL, 0x000fe400078efcffULL, 0x000000016a6a2812ULL, 0x002fca00078efcffULL,
0x0000003c004d7306ULL, 0x000fe80000009400ULL, 0x0000000143434812ULL, 0x000fc800078efcffULL,
0x0000006a4343723eULL, 0x000fe200000010ffULL, 0x00010000306a7824ULL, 0x000fe200078e00ffULL,
0x000000016b6b3812ULL, 0x004fe200078efcffULL, 0x0000003c004e7306ULL, 0x000e660000005400ULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x0000006b4242723eULL, 0x000fe400000010ffULL,
0x00000018ff6b7819ULL, 0x000fe20000011430ULL, 0x0000003d004f7306ULL, 0x000fe80000009400ULL,
0x000000423420723cULL, 0x000b680000041820ULL, 0x0000003d00507306ULL, 0x000ea20000005400ULL,
0x0000004e4d00720bULL, 0x002fc40003f5d000ULL, 0x0001000031437824ULL, 0x020fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fc80000011431ULL, 0x0000006a006c7306ULL, 0x000fe20000209400ULL,
0x00000018ff437819ULL, 0x000fce0000011443ULL, 0x0000006a006d7306ULL, 0x0002e20000205400ULL,
0x000000504f00720bULL, 0x004fce0003f9d000ULL, 0x00000043004e7306ULL, 0x000fe20000209400ULL,
0x0000006a006a7245ULL, 0x002fce000020d400ULL, 0x00000043004f7306ULL, 0x000e620000205400ULL,
0x0000006d6c00720bULL, 0x008fce0003fbd000ULL, 0x0000006b00307306ULL, 0x000fec0000209400ULL,
0x000000016a6a5812ULL, 0x000fe400078efcffULL, 0x0000006b006f7306ULL, 0x0004e20000205400ULL,
0x0000004f4e00720bULL, 0x002fe40003fbd000ULL, 0x00000018ff4f7819ULL, 0x000fca0000011432ULL,
0x0000003f00537306ULL, 0x000fe20000009400ULL, 0x0000006b006b7245ULL, 0x004fce000020d400ULL,
0x0000003f00547306ULL, 0x000e620000005400ULL, 0x0000006f3000720bULL, 0x008fe40003fdd000ULL,
0x0000004300307245ULL, 0x000fc8000020d400ULL, 0x0000000130305812ULL, 0x000fe200078efcffULL,
0x00000032005e7306ULL, 0x000fec0000009400ULL, 0x000000016b6b6812ULL, 0x000fe400078efcffULL,
0x0000003200627306ULL, 0x000ea20000005400ULL, 0x000000545300720bULL, 0x002fe20003f1d000ULL,
0x0000010032537824ULL, 0x000fca00078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000003e00517306ULL, 0x000ff00000009400ULL, 0x0000003e00527306ULL, 0x000e620000005400ULL,
0x000000625e00720bULL, 0x004fe20003fbd000ULL, 0x0000010033627824ULL, 0x000fe200078e00ffULL,
0x00000042005e7245ULL, 0x000fc8000020d400ULL, 0x00000018ff627819ULL, 0x000fe20000011462ULL,
0x00000042004d7306ULL, 0x000ff00000209400ULL, 0x0000004200507306ULL, 0x000ea20000205400ULL,
0x000000525100720bULL, 0x002fce0003f7d000ULL, 0x0000005300517306ULL, 0x000ff00000209400ULL,
0x0000005300527306ULL, 0x0002e20000205400ULL, 0x000000504d00720bULL, 0x004fce0003fdd000ULL,
0x0000003200637306ULL, 0x000522000000d400ULL, 0x0000005300537245ULL, 0x002fca000020d400ULL,
0x000000015e5e6812ULL, 0x000fe400078efcffULL, 0x0000006200427306ULL, 0x000fe20000209400ULL,
0x0001000032327824ULL, 0x004fe200078e00ffULL, 0x000000525100720bULL, 0x008fc80003fdd000ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x00000062004d7306ULL, 0x0002a20000205400ULL,
0x0000000163635812ULL, 0x010fcc00078efcffULL, 0x0000000153536812ULL, 0x000fe200078efcffULL,
0x0000003300667306ULL, 0x000fe20000009400ULL, 0x0000006200627245ULL, 0x002fce000020d400ULL,
0x0000003300677306ULL, 0x000e620000005400ULL, 0x0000004d4200720bULL, 0x004fe20003fbd000ULL,
0x00010000334d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fc80000011433ULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000003200517306ULL, 0x000fec0000209400ULL,
0x0000000162625812ULL, 0x000fe400078efcffULL, 0x0000003200527306ULL, 0x000ea20000205400ULL,
0x000000676600720bULL, 0x002fe20003fdd000ULL, 0x000001003d667824ULL, 0x000fca00078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x0000003300317306ULL, 0x0002f0000000d400ULL,
0x0000004f00437306ULL, 0x000fe20000209400ULL, 0x000000525100720bULL, 0x004fe20003fbd000ULL,
0x000100003c337824ULL, 0x002fc400078e00ffULL, 0x000100003d527824ULL, 0x000fc600078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0000004f004e7306ULL, 0x0002a20000205400ULL,
0x0000000131316812ULL, 0x008fe400078efcffULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x000000316231723eULL, 0x000fc600000010ffULL, 0x0000004d00547306ULL, 0x000fe20000209400ULL,
0x0000004f004f7245ULL, 0x002fce000020d400ULL, 0x0000004d00517306ULL, 0x000e620000205400ULL,
0x0000004e4300720bULL, 0x004fe40003fdd000ULL, 0x00000032004e7245ULL, 0x000fc8000020d400ULL,
0x000000014e4e5812ULL, 0x000fe200078efcffULL, 0x0000004200507306ULL, 0x000fec0000209400ULL,
0x000000014f4f6812ULL, 0x000fe400078efcffULL, 0x0000004200437306ULL, 0x000ea20000205400ULL,
0x000000515400720bULL, 0x002fce0003fbd000ULL, 0x00000049004b7306ULL, 0x000ff00000209400ULL,
0x0000004900577306ULL, 0x000e620000205400ULL, 0x000000435000720bULL, 0x004fe40003fdd000ULL,
0x0000004d00437245ULL, 0x000fe2000020d400ULL, 0x000001003e4d7824ULL, 0x000fe200078e00ffULL,
0x0000004900507245ULL, 0x000fc4000020d400ULL, 0x0000000143435812ULL, 0x000fe200078efcffULL,
0x0000003c003b7306ULL, 0x000ea2000000d400ULL, 0x00000018ff4d7819ULL, 0x000fce000001144dULL,
0x00000033003c7306ULL, 0x000fe20000209400ULL, 0x000000574b00720bULL, 0x002fe40003fbd000ULL,
0x00000042004b7245ULL, 0x000fe2000020d400ULL, 0x000001003f427824ULL, 0x000fc600078e00ffULL,
0x000000014b4b6812ULL, 0x000fe200078efcffULL, 0x0000003300517306ULL, 0x000e620000205400ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x000000013b3b2812ULL, 0x004fc600078efcffULL,
0x0000000150505812ULL, 0x000fe400078efcffULL, 0x00000058005d7306ULL, 0x000ff00000209400ULL,
0x00000058005b7306ULL, 0x0004e20000205400ULL, 0x000000513c00720bULL, 0x002fe20003fbd000ULL,
0x000100003e3c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000003d00137306ULL, 0x000e62000000d400ULL, 0x0000005800587245ULL, 0x004fce000020d400ULL,
0x0000006600327306ULL, 0x000fe20000209400ULL, 0x0000005b5d00720bULL, 0x008fce0003fdd000ULL,
0x00000066003d7306ULL, 0x0004e20000205400ULL, 0x0000000113134812ULL, 0x002fca00078efcffULL,
0x0000000158586812ULL, 0x000fe400078efcffULL, 0x0000005200677306ULL, 0x000fe20000209400ULL,
0x0000006600667245ULL, 0x004fce000020d400ULL, 0x00000052006c7306ULL, 0x0002b00000205400ULL,
0x0000003e00117306ULL, 0x0008a2000000d400ULL, 0x0000005200527245ULL, 0x002fce000020d400ULL,
0x0000004100597306ULL, 0x000fe20000209400ULL, 0x00000033003e7245ULL, 0x010fe4000020d400ULL,
0x000000305e33723eULL, 0x000fe400000010ffULL, 0x000000013e3e5812ULL, 0x000fe400078efcffULL,
0x0000003d3200720bULL, 0x008fe20003fbd000ULL, 0x00000041005a7306ULL, 0x0002e20000205400ULL,
0x0000006a6b32723eULL, 0x000fe200000010ffULL, 0x000100003f3d7824ULL, 0x000fe200078e00ffULL,
0x0000006c6700720bULL, 0x004fc40003fdd000ULL, 0x000000635330723eULL, 0x000fe400000010ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000004d00577306ULL, 0x000fe20000209400ULL,
0x00000032341c723cULL, 0x040b62000004181cULL, 0x0000004100417245ULL, 0x002fe4000020d400ULL,
0x0000000166665812ULL, 0x000fe400078efcffULL, 0x0000000111113812ULL, 0x000fe400078efcffULL,
0x0000004d005b7306ULL, 0x000e620000205400ULL, 0x0000004e4f32723eULL, 0x020fe200000010ffULL,
0x000000303418723cULL, 0x000b620000041818ULL, 0x0000005a5900720bULL, 0x008fc40003f5d000ULL,
0x000000434b33723eULL, 0x000fe400000010ffULL, 0x0000000152526812ULL, 0x000fe200078efcffULL,
0x00000040004a7306ULL, 0x000fe20000209400ULL, 0x0000003b5030723eULL, 0x020fe400000010ffULL,
0x000000136631723eULL, 0x000fe200000010ffULL, 0x000000323414723cULL, 0x000f620000041814ULL,
0x0000004200137245ULL, 0x000fe4000020d400ULL, 0x0000003e583e723eULL, 0x000fe200000010ffULL,
0x0000004000487306ULL, 0x0004e20000205400ULL, 0x0000005b5700720bULL, 0x002fc40003f9d000ULL,
0x0000000141412812ULL, 0x000fe200078efcffULL, 0x000000304420723cULL, 0x000b680000041820ULL,
0x0000003f00107306ULL, 0x000e62000000d400ULL, 0x0000004000407245ULL, 0x004fce000020d400ULL,
0x0000000a005f7306ULL, 0x000fe20000209400ULL, 0x000000484a00720bULL, 0x008fe40003fdd000ULL,
0x0000004d00487245ULL, 0x000fc8000020d400ULL, 0x0000000148484812ULL, 0x000fe200078efcffULL,
0x0000000a005c7306ULL, 0x0004e20000205400ULL, 0x0000000110100812ULL, 0x002fe400078efcffULL,
0x000000114830723eULL, 0x020fe400000010ffULL, 0x0000000a00117245ULL, 0x000fe4000020d400ULL,
0x0000000140406812ULL, 0x000fe200078efcffULL, 0x0000004200517306ULL, 0x000fe20000209400ULL,
0x0000f698750a7811ULL, 0x004fce00078e18ffULL, 0x0000004200547306ULL, 0x000e620000205400ULL,
0x0000005c5f00720bULL, 0x008fce0003fbd000ULL, 0x0000003c00497306ULL, 0x000fec0000209400ULL,
0x0000000111115812ULL, 0x000fe400078efcffULL, 0x0000003c003f7306ULL, 0x0004e20000205400ULL,
0x000000545100720bULL, 0x002fce0003f5d000ULL, 0x0000003d00537306ULL, 0x000fe20000209400ULL,
0x0000003c003c7245ULL, 0x004fca000020d400ULL, 0x0000000113132812ULL, 0x000fe400078efcffULL,
0x0000003d004e7306ULL, 0x0002a20000205400ULL, 0x0000003f4900720bULL, 0x008fe40003f9d000ULL,
0x00000052413f723eULL, 0x000fe400000010ffULL, 0x000000101331723eULL, 0x000fe400000010ffULL,
0x0000003d003d7245ULL, 0x002fc6000020d400ULL, 0x0000003e441c723cULL, 0x040b68000004181cULL,
0x000000013c3c4812ULL, 0x000fe400078efcffULL, 0x0000004e5300720bULL, 0x004fe40003f7d000ULL,
0x0000003c113c723eULL, 0x000fe200000010ffULL, 0x000000304418723cULL, 0x000b740000041818ULL,
0x000000013d3d3812ULL, 0x000fc800078efcffULL, 0x0000003d403d723eULL, 0x000fce00000010ffULL,
0x0000003c4414723cULL, 0x000b620000041814ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000005107f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000aff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff137224ULL, 0x000fc600078e00ffULL, 0x0000000000307805ULL, 0x020fc80000015200ULL,
0x0000040005337984ULL, 0x000f240000000800ULL, 0x8000000033ff7812ULL, 0x014fe40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x0000003230357210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x008fc80000011433ULL, 0x000000350a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x000000020a0a7819ULL, 0x000fc80000001233ULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000113137810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040005337984ULL, 0x000ea40000000800ULL, 0x8000000033ff7812ULL, 0x004fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001040a7810ULL, 0x008fc80007ffe0ffULL,
0x000000690a00720cULL, 0x000fda0003f06070ULL, 0x0000072000000947ULL, 0x000fea0003800000ULL,
0x00000002040a7810ULL, 0x000fe40007ffe0ffULL, 0x0000010056117810ULL, 0x000fe40007ffe0ffULL,
0x000000690a00720cULL, 0x000fc60003f06070ULL, 0x0000680073137a24ULL, 0x000fd400078e0211ULL,
0x000003d000008947ULL, 0x000fea0003800000ULL, 0x00000011680a7217ULL, 0x000fe20007800000ULL,
0x0000001072317824ULL, 0x000fe200078e00ffULL, 0x00000003ff107819ULL, 0x000fc60000011602ULL,
0x000000010a0a7824ULL, 0x000fe200078e0a11ULL, 0x0000000410327810ULL, 0x040fe20007ffe0ffULL,
0x0000000131307824ULL, 0x040fe200078e0210ULL, 0x0000000c10337810ULL, 0x000fe40007ffe0ffULL,
0x0000000a310a7217ULL, 0x000fe20007800000ULL, 0x0000000130117824ULL, 0x040fe400078e0202ULL,
0x0000000830347824ULL, 0x000fe400078e00ffULL, 0x000000010a0a7824ULL, 0x000fc400078e0a31ULL,
0x0000000130307824ULL, 0x000fe200078e0213ULL, 0xfffffff834377812ULL, 0x000fe200078ee211ULL,
0x0000000131367824ULL, 0x040fe200078e0233ULL, 0x0000000a3200720cULL, 0x080fe20003f66070ULL,
0x0000000131327824ULL, 0x000fe200078e0232ULL, 0x0000000810117810ULL, 0x000fe20007ffe0ffULL,
0x0000000136347824ULL, 0x000fe200078e0213ULL, 0x0000000a1000720cULL, 0x080fe20003f86070ULL,
0x0000000132107824ULL, 0x040fe200078e0202ULL, 0x0000000a1100720cULL, 0x080fe20003f46070ULL,
0x00000008323b7824ULL, 0x000fe200078e00ffULL, 0x0000000a3300720cULL, 0x000fe20003f06070ULL,
0x0000000131117824ULL, 0x000fc400078e0211ULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fc600078ee210ULL, 0x0000000132107824ULL, 0x100fe200078e0213ULL,
0x0000006030307212ULL, 0x080fe200078efcffULL, 0x0000000111327824ULL, 0x040fe400078e0213ULL,
0x00000001110a7824ULL, 0x040fe200078e0202ULL, 0x0000640030307a10ULL, 0x000fe20007fbe0ffULL,
0x0000000811337824ULL, 0x000fe400078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000650031317a10ULL, 0x000fe40002ffe4ffULL, 0xfffffff833137812ULL, 0x000fe200078ee20aULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x0000006010107212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000640010107a10ULL, 0x000fe40007fbe0ffULL,
0x0000006032327212ULL, 0x080fe200078efcffULL, 0x00000001360a7824ULL, 0x000fe200078e0202ULL,
0x0000006034347212ULL, 0x000fe200078efcffULL, 0x00000008363d7824ULL, 0x000fe200078e00ffULL,
0x0000650011117a10ULL, 0x000fe20002ffe4ffULL, 0x0000001037377824ULL, 0x100fe200078e0264ULL,
0x0000640032327a10ULL, 0x000fe20007fbe0ffULL, 0x000000103b3b7824ULL, 0x000fe200078e0264ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee20aULL, 0x0000001013137824ULL, 0x100fe200078e0264ULL,
0x0000640034347a10ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030377faeULL, 0x0005e2000e101c46ULL, 0x0000650033337a10ULL, 0x000fe20002ffe4ffULL,
0x000000103d3d7824ULL, 0x000fe200078e0264ULL, 0x0000650035357a10ULL, 0x000fe200037fe4ffULL,
0x00000000103b7faeULL, 0x0005e8000d901c46ULL, 0x0000000032137faeULL, 0x0005e8000d101c46ULL,
0x00000000343d7faeULL, 0x0005e2000c101c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001072117824ULL, 0x000fca00078e00ffULL, 0x0000001102117211ULL, 0x000fc800078fe8ffULL,
0x0000000411347810ULL, 0x040fe20007ffe0ffULL, 0x00000001110a7824ULL, 0x140fe200078e0202ULL,
0x0000000811327810ULL, 0x040fe20007ffe0ffULL, 0x0000000811377824ULL, 0x000fe400078e00ffULL,
0x0000000134107824ULL, 0x040fe400078e0202ULL, 0x00000008343b7824ULL, 0x000fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fe200078ee20aULL, 0x0000000132307824ULL, 0x040fe200078e0202ULL,
0x0000000c110a7810ULL, 0x000fe20007ffe0ffULL, 0x00000008323d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL, 0x0000000111107824ULL, 0x000fc400078e0213ULL,
0x0000000134347824ULL, 0x000fe200078e0213ULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee230ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000000132327824ULL, 0x100fe200078e0213ULL,
0x0000006010107212ULL, 0x000fe200078efcffULL, 0x000000010a307824ULL, 0x000fe400078e0213ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000640010107a10ULL, 0x000fc60007f1e0ffULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x0000006034347212ULL, 0x080fe400078efcffULL,
0x0000650011117a10ULL, 0x000fe200007fe4ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x0000006032327212ULL, 0x080fe400078efcffULL, 0x0000640034347a10ULL, 0x000fe20007f5e0ffULL,
0x000000010a137824ULL, 0x000fe200078e0202ULL, 0x0000006030307212ULL, 0x000fe200078efcffULL,
0x000000080a0a7824ULL, 0x000fe200078e00ffULL, 0x0000640032327a10ULL, 0x000fe20007f1e0ffULL,
0x0000001037377824ULL, 0x100fe200078e0264ULL, 0x0000640030307a10ULL, 0x000fe20007f7e0ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0264ULL, 0xfffffff80a137812ULL, 0x000fe200078ee213ULL,
0x000000103d3d7824ULL, 0x100fe200078e0264ULL, 0x0000650035357a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010377faeULL, 0x0005e2000b901c46ULL,
0x0000650033337a10ULL, 0x000fe200007fe4ffULL, 0x0000001013137824ULL, 0x000fe200078e0264ULL,
0x0000650031317a10ULL, 0x000fe20001ffe4ffULL, 0x00000000343b7faeULL, 0x0005e8000b901c46ULL,
0x00000000323d7faeULL, 0x0005e8000b901c46ULL, 0x0000000030137faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x000000106e0a7824ULL, 0x000fe200078e00ffULL,
0x0000000803137812ULL, 0x000fc400078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x000000100a0a7812ULL, 0x000fca00078ee2ffULL, 0x00000020750a7824ULL, 0x000fc800078e020aULL,
0x0000000113137824ULL, 0x000fe200078e020aULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff307f8cULL, 0x000ea2000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6680013107f8cULL, 0x000662000c80043fULL,
0x000000ffff0a7224ULL, 0x004fc600078e0031ULL, 0x0000000000307805ULL, 0x000fc80000015200ULL,
0x00f66c0013337984ULL, 0x000ea40000000800ULL, 0x8000000033ff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230357210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003532327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c0013337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018075107811ULL, 0x000fc800078e38ffULL, 0x0000001065107210ULL, 0x000fca0007ffe060ULL,
0x00f0000010137984ULL, 0x008e680000000800ULL, 0x00f2000010317984ULL, 0x0004e20000000800ULL,
0x000000061300720bULL, 0x002fe20003f1d000ULL, 0x0000ad127f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x004fc800000e0100ULL, 0x0000ffff3c347812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff327424ULL, 0x000fe400078e00ffULL,
0x000000ffff307224ULL, 0x000fd200078e0006ULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x0000000375117810ULL, 0x000fe40007ffe0ffULL, 0x000000061300720bULL, 0x000fe40003f54000ULL,
0x000000001100720cULL, 0x000fe20003f05270ULL, 0x0000acb27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000337806ULL, 0x000fc400010e0100ULL, 0x0000008000608824ULL, 0x000fe200078e0260ULL,
0x0000000613307209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991033107816ULL, 0x000fe200000000ffULL, 0x0000000165658824ULL, 0x000fca00078e0260ULL,
0x00f4003065008388ULL, 0x0003e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000630067221ULL, 0x002fe20000010100ULL,
0x000000ff33ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b06067820ULL, 0x000fc80000410000ULL, 0x0000000600357308ULL, 0x000e640000000800ULL,
0x0000003512127220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe20000011602ULL, 0x0000abe27f007947ULL, 0x000fea000b800000ULL,
0x00001f10353c7589ULL, 0x0002a400000e0000ULL, 0x0000003c20207220ULL, 0x084fe20000410000ULL,
0x0000003c21217220ULL, 0x080fe20000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000003c18187220ULL, 0x080fe20000410000ULL,
0x0000003c19197220ULL, 0x080fe20000410000ULL, 0x0000003c14147220ULL, 0x080fe20000410000ULL,
0x0000003c15157220ULL, 0x080fe20000410000ULL, 0x0000003c0c0c7220ULL, 0x080fe20000410000ULL,
0x0000003c0d0d7220ULL, 0x080fe20000410000ULL, 0x0000003c24247220ULL, 0x080fe20000410000ULL,
0x0000003c25257220ULL, 0x080fe20000410000ULL, 0x0000003c28287220ULL, 0x080fe20000410000ULL,
0x0000003c29297220ULL, 0x080fe20000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000003c2d2d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0033ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802107811ULL, 0x002fe200078ff0ffULL, 0x0000aac27f007947ULL, 0x000fea000b800000ULL,
0x00001f10353c7589ULL, 0x0002a400000e0000ULL, 0x0000003c22227220ULL, 0x084fe20000410000ULL,
0x0000003c23237220ULL, 0x080fe20000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000003c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003c16167220ULL, 0x080fe20000410000ULL,
0x0000003c17177220ULL, 0x080fe20000410000ULL, 0x0000003c0e0e7220ULL, 0x080fe20000410000ULL,
0x0000003c0f0f7220ULL, 0x080fe20000410000ULL, 0x0000003c26267220ULL, 0x080fe20000410000ULL,
0x0000003c27277220ULL, 0x080fe20000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000003c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000003c2f2f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff34ff7812ULL, 0x000fda0007806033ULL, 0x0000001330130221ULL, 0x000fe20000010100ULL,
0x00007610ff320816ULL, 0x000fc60000000032ULL, 0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL,
0x0000001300070308ULL, 0x000e640000000800ULL, 0x0000000731310220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001231317221ULL, 0x008fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0xfffffff003347812ULL, 0x000fe200078ec0ffULL,
0x0000000400067824ULL, 0x000fc800078e00ffULL, 0x00f6b40034137984ULL, 0x000e620000000800ULL,
0x0000000406067812ULL, 0x000fc800078ec0ffULL, 0x0000000206337812ULL, 0x000fe400078efcffULL,
0x8000000013ff7812ULL, 0x002fe20007804839ULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210357210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011413ULL,
0x0000003506067211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000206067819ULL, 0x000fc80000001213ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6b40034137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991032067816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000007ff06723eULL, 0x000fe400000010ffULL,
0x00000002ff137819ULL, 0x000fe40000011602ULL, 0x0000541006067816ULL, 0x000fe20000000006ULL,
0x0000a6527f007947ULL, 0x000fea000b800000ULL, 0x00001f1306087589ULL, 0x0002a400000e0000ULL,
0x0000000813107810ULL, 0x000fe20007ffe0ffULL, 0x0000a6827f007947ULL, 0x000fea000b800000ULL,
0x00001f1006097589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001013107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200078e0006ULL,
0x0000ce80003d7802ULL, 0x000fc40000000f00ULL, 0x0000ab1000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001813107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200078e0006ULL, 0x0000ced0003d7802ULL, 0x000fc40000000f00ULL,
0x0000aac000007944ULL, 0x006fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000702497812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000008025e7812ULL, 0x000fc400078ec0ffULL, 0x0000000849067812ULL, 0x00afe400078ef802ULL,
0x0000000375707810ULL, 0x000fc60007ffe0ffULL, 0x0000000806117824ULL, 0x000fca00078e00ffULL,
0xfffffff811107812ULL, 0x000fca00078ee24cULL, 0x0000008075107824ULL, 0x000fca00078e0210ULL,
0x0000a80010107811ULL, 0x000fc400078e20ffULL, 0x000000006160783bULL, 0x000e620000004200ULL,
0x000000495e497212ULL, 0x000fe200078efcffULL, 0x0000080070707824ULL, 0x000fe200078e023aULL,
0x00001000646f7810ULL, 0x000fc60007ffe0ffULL, 0x00000008495e7824ULL, 0x000fe400078e00ffULL,
0x00000010553c7824ULL, 0x004fcc00078e026fULL, 0x000000003c3c783bULL, 0x000fe20000004200ULL,
0x00000100614b7824ULL, 0x042fe200078e00ffULL, 0x0000006100137306ULL, 0x000fe20000009400ULL,
0x00000100604a7824ULL, 0x040fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011460ULL,
0x00010000604c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x00010000614d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x00000100625a7824ULL, 0x000fe200078e00ffULL, 0x0000006100127306ULL, 0x000e620000005400ULL,
0x00000018ff357819ULL, 0x000fe20000011461ULL, 0x00000100635c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fc4000001144cULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000006200387306ULL, 0x000fe20000009400ULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000003400557245ULL, 0x000fe4000020d400ULL,
0x00000018ff367819ULL, 0x000fe40000011462ULL, 0x00000018ff457819ULL, 0x000fe20000011463ULL,
0x0000006200117306ULL, 0x000ea20000005400ULL, 0x000000121300720bULL, 0x002fce0003f5d000ULL,
0x0000004b00597306ULL, 0x000ff00000209400ULL, 0x0000004b006c7306ULL, 0x000e620000205400ULL,
0x000000113800720bULL, 0x004fe40003f7d000ULL, 0x000000001010783bULL, 0x000eaa0000000200ULL,
0x00000060005f7306ULL, 0x000ff00000009400ULL, 0x00000060006a7306ULL, 0x000ee20000005400ULL,
0x0000006c5900720bULL, 0x002fc40003fbd000ULL, 0x00000033026c7211ULL, 0x000fca00078fe0ffULL,
0x0000006000407306ULL, 0x000e62000000d400ULL, 0x0000000149337824ULL, 0x000fca00078e026cULL,
0xfffffff85e5e7812ULL, 0x000fe400078ee233ULL, 0x0000004a00517306ULL, 0x000fe20000209400ULL,
0x0000006a5f00720bULL, 0x008fe40003fdd000ULL, 0x0000004a00337245ULL, 0x000fe2000020d400ULL,
0x000000105e717824ULL, 0x000fe200078e0271ULL, 0x00000035005e7245ULL, 0x000fc6000020d400ULL,
0x0000004a00607306ULL, 0x0007220000205400ULL, 0x0000000810108231ULL, 0x084fe400003400ffULL,
0x0000000812128231ULL, 0x000fc600003400ffULL, 0x0000000140406812ULL, 0x002fe200078efcffULL,
0x0000000911118231ULL, 0x080fe200003400ffULL, 0x0000006100417306ULL, 0x000e62000000d400ULL,
0x0000004b004a7245ULL, 0x008fe2000020d400ULL, 0x0000000913138231ULL, 0x000fc600003400ffULL,
0x000000014a4a5812ULL, 0x000fc600078efcffULL, 0x00000034003b7306ULL, 0x000fe20000209400ULL,
0x000000605100720bULL, 0x010fce0003f9d000ULL, 0x0000003400567306ULL, 0x0004e20000205400ULL,
0x0000000141412812ULL, 0x002fc800078efcffULL, 0x000000414a41723eULL, 0x000fe400000010ffULL,
0x0000000133334812ULL, 0x000fe200078efcffULL, 0x00000035004e7306ULL, 0x000fe20000209400ULL,
0x0000004c00347245ULL, 0x004fe4000020d400ULL, 0x000000403340723eULL, 0x000fe400000010ffULL,
0x00000018ff4a7819ULL, 0x000fc6000001143cULL, 0x0000003500527306ULL, 0x0002a20000205400ULL,
0x000000563b00720bULL, 0x008fce0003fdd000ULL, 0x0000004c00427306ULL, 0x000fe20000209400ULL,
0x0000004d00357245ULL, 0x002fca000020d400ULL, 0x0000000155556812ULL, 0x000fe400078efcffULL,
0x0000004c00437306ULL, 0x0002e20000205400ULL, 0x000000524e00720bULL, 0x004fe40003fbd000ULL,
0x00000018ff527819ULL, 0x000fca000001143dULL, 0x0000004d00537306ULL, 0x000fe20000209400ULL,
0x00000018ff4c7819ULL, 0x002fca000001143eULL, 0x000000015e5e5812ULL, 0x000fe400078efcffULL,
0x0000004d00547306ULL, 0x0002a20000205400ULL, 0x000000434200720bULL, 0x008fe40003f5d000ULL,
0x000000401040723cULL, 0x000b640000041820ULL, 0x000000007120783bULL, 0x020ee60000004200ULL,
0x0000005a004f7306ULL, 0x000fe20000209400ULL, 0x00000018ff4d7819ULL, 0x002fca000001143fULL,
0x0000000134342812ULL, 0x000fe400078efcffULL, 0x0000005a00577306ULL, 0x000e620000205400ULL,
0x000000545300720bULL, 0x004fe40003f9d000ULL, 0x000000345534723eULL, 0x000fca00000010ffULL,
0x0000006300327306ULL, 0x000fec0000009400ULL, 0x0000000135354812ULL, 0x000fe400078efcffULL,
0x0000006300587306ULL, 0x000ea20000005400ULL, 0x000000574f00720bULL, 0x002fe40003f5d000ULL,
0x000000355e35723eULL, 0x000fca00000010ffULL, 0x0000005c005b7306ULL, 0x000fe40000209400ULL,
0x00000034101c723cULL, 0x000b62000004181cULL, 0x0000010020767824ULL, 0x008fe400078e00ffULL,
0x0000010021747824ULL, 0x000fc600078e00ffULL, 0x0000005c005d7306ULL, 0x000e620000205400ULL,
0x000000583200720bULL, 0x004fe40003f9d000ULL, 0x0000005a00357245ULL, 0x020fe4000020d400ULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x0000000135352812ULL, 0x000fe200078efcffULL,
0x0000006200067306ULL, 0x0004e2000000d400ULL, 0x00000018ff747819ULL, 0x000fce0000011474ULL,
0x0000006300487306ULL, 0x000922000000d400ULL, 0x0001000062627824ULL, 0x004fe200078e00ffULL,
0x0000005d5b00720bULL, 0x002fc80003fbd000ULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x0000000106063812ULL, 0x008fe200078efcffULL, 0x0001000063637824ULL, 0x010fe200078e00ffULL,
0x0000003600467306ULL, 0x000fe40000209400ULL, 0x000000063534723eULL, 0x000fe400000010ffULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x0000005c00357245ULL, 0x000fc4000020d400ULL,
0x0000003600477306ULL, 0x000e620000205400ULL, 0x0000000148484812ULL, 0x000fe400078efcffULL,
0x0000000135355812ULL, 0x000fc800078efcffULL, 0x000000483535723eULL, 0x000fe200000010ffULL,
0x0000004500447306ULL, 0x000fec0000209400ULL, 0x000000341018723cULL, 0x000b640000041818ULL,
0x0000004500377306ULL, 0x000ea20000205400ULL, 0x000000474600720bULL, 0x002fc80003f9d000ULL,
0x000000010b357824ULL, 0x060fe200078e026cULL, 0x0000006200347245ULL, 0x000fe4000020d400ULL,
0x0000006200507306ULL, 0x000ff00000209400ULL, 0x00000062006d7306ULL, 0x000e620000205400ULL,
0x000000374400720bULL, 0x004fe20003fbd000ULL, 0x000000080b447824ULL, 0x000fe200078e00ffULL,
0x00000036000b7245ULL, 0x000fc4000020d400ULL, 0x0000004500367245ULL, 0x000fe4000020d400ULL,
0xfffffff844447812ULL, 0x000fe200078ee235ULL, 0x0000006300647306ULL, 0x000fe20000209400ULL,
0x0000006300357245ULL, 0x000fe4000020d400ULL, 0x000000010b0b4812ULL, 0x000fe200078efcffULL,
0x0000001044447824ULL, 0x000fe400078e026fULL, 0x0000000136365812ULL, 0x000fe400078efcffULL,
0x0000006300657306ULL, 0x000ea20000205400ULL, 0x0000006d5000720bULL, 0x002fe20003f7d000ULL,
0x000001003c6d7824ULL, 0x000fe200078e00ffULL, 0x000000004444783bULL, 0x000fe80000004200ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x0000003c00667306ULL, 0x000fe60000009400ULL,
0x0000006d003a7245ULL, 0x000fc6000020d400ULL, 0x0000000134343812ULL, 0x000fe400078efcffULL,
0x000000656400720bULL, 0x004fe20003fdd000ULL, 0x0000003c00677306ULL, 0x000e620000005400ULL,
0x000000340b34723eULL, 0x000fe200000010ffULL, 0x000001003d657824ULL, 0x000fe400078e00ffULL,
0x000001003e0b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000006d00717306ULL, 0x000fe20000205400ULL, 0x00000018ff0b7819ULL, 0x000fc6000001140bULL,
0x0000000135356812ULL, 0x000fe400078efcffULL, 0x000000676600720bULL, 0x002fe40003f5d000ULL,
0x0000003d006a7306ULL, 0x000fe20000009400ULL, 0x000000353635723eULL, 0x000fce00000010ffULL,
0x0000006d00677306ULL, 0x0002a20000209400ULL, 0x000000341014723cULL, 0x000b640000041814ULL,
0x009000007034783bULL, 0x020eea0000000200ULL, 0x0000003d006b7306ULL, 0x000f220000005400ULL,
0x000100003f6d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x0000006500627306ULL, 0x000fe20000209400ULL, 0x000000716700720bULL, 0x004fce0003fdd000ULL,
0x00000065006c7306ULL, 0x000e620000205400ULL, 0x0000006b6a00720bULL, 0x010fca0003f7d000ULL,
0x000000013a3a6812ULL, 0x000fe400078efcffULL, 0x0000003f003b7306ULL, 0x000ff00000009400ULL,
0x0000003f00597306ULL, 0x000ea20000005400ULL, 0x0000006c6200720bULL, 0x002fe20003fdd000ULL,
0x0000000834348231ULL, 0x008fc400003400ffULL, 0x0000000836368231ULL, 0x000fe400003400ffULL,
0x0000000935358231ULL, 0x080fe400003400ffULL, 0x0000003c00397306ULL, 0x0002e2000000d400ULL,
0x0000000937378231ULL, 0x000fce00003400ffULL, 0x0000003d00387306ULL, 0x000922000000d400ULL,
0x000000593b00720bULL, 0x004fe20003f9d000ULL, 0x000100003c3c7824ULL, 0x002fe200078e00ffULL,
0x00000065003b7245ULL, 0x000fe2000020d400ULL, 0x000100003e597824ULL, 0x000fc600078e00ffULL,
0x000000013b3b6812ULL, 0x000fe200078efcffULL, 0x0000002000577306ULL, 0x000fe20000009400ULL,
0x0000000139392812ULL, 0x008fe200078efcffULL, 0x000100003d3d7824ULL, 0x010fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000000393a3a723eULL, 0x000fe400000010ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000002000587306ULL, 0x000e620000005400ULL,
0x0000000138383812ULL, 0x000fc400078efcffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x000000383b3b723eULL, 0x000fc600000010ffULL, 0x0000007600707306ULL, 0x000fe80000209400ULL,
0x0000003a3438723cULL, 0x000be80000041840ULL, 0x00000076007a7306ULL, 0x000ea20000205400ULL,
0x000000585700720bULL, 0x002fce0003f1d000ULL, 0x0000007400777306ULL, 0x000ff00000209400ULL,
0x0000007400427306ULL, 0x020e620000205400ULL, 0x0000007a7000720bULL, 0x004fce0003f5d000ULL,
0x0000002000327306ULL, 0x000eb0000000d400ULL, 0x00000021005a7306ULL, 0x000fe20000009400ULL,
0x000000427700720bULL, 0x002fe40003fdd000ULL, 0x0000007600427245ULL, 0x000fc4000020d400ULL,
0x0000005200777245ULL, 0x000fe4000020d400ULL, 0x0000000142422812ULL, 0x000fe200078efcffULL,
0x00000021005b7306ULL, 0x000e620000005400ULL, 0x0000000132320812ULL, 0x004fc800078efcffULL,
0x000000324232723eULL, 0x000fc600000010ffULL, 0x0000003c00667306ULL, 0x000ff00000209400ULL,
0x0000003c00647306ULL, 0x0004e20000205400ULL, 0x0000005b5a00720bULL, 0x002fe40003f7d000ULL,
0x00000018ff5a7819ULL, 0x000fca0000011420ULL, 0x0000004a004b7306ULL, 0x000fe20000209400ULL,
0x0000003c003c7245ULL, 0x004fce000020d400ULL, 0x0000004a00517306ULL, 0x000e620000205400ULL,
0x000000646600720bULL, 0x008fe40003f1d000ULL, 0x0000003d00647245ULL, 0x000fca000020d400ULL,
0x0000005200537306ULL, 0x000fec0000209400ULL, 0x000000013c3c0812ULL, 0x000fe400078efcffULL,
0x0000005200547306ULL, 0x000ea20000205400ULL, 0x000000514b00720bULL, 0x002fe40003f5d000ULL,
0x00000074004b7245ULL, 0x000fc4000020d400ULL, 0x0000004d00747245ULL, 0x000fe4000020d400ULL,
0x000000014b4b6812ULL, 0x000fe200078efcffULL, 0x0000002100067306ULL, 0x000e70000000d400ULL,
0x0000004c00557306ULL, 0x000fe20000209400ULL, 0x000000545300720bULL, 0x004fe20003fdd000ULL,
0x0001000020547824ULL, 0x000fca00078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000004c00567306ULL, 0x000ea20000205400ULL, 0x0000000106063812ULL, 0x002fe400078efcffULL,
0x0000005400527245ULL, 0x000fc6000020d400ULL, 0x0000000177776812ULL, 0x000fe400078efcffULL,
0x0000003d006a7306ULL, 0x000ff00000209400ULL, 0x0000003d006b7306ULL, 0x0002e20000205400ULL,
0x000000565500720bULL, 0x004fc40003f7d000ULL, 0x0000004a00557245ULL, 0x000fe2000020d400ULL,
0x00010000214a7824ULL, 0x000fc600078e00ffULL, 0x0000000155552812ULL, 0x000fe200078efcffULL,
0x00000022005c7306ULL, 0x000fe20000009400ULL, 0x00000018ff3d7819ULL, 0x002fe40000011421ULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000006b6a00720bULL, 0x008fc60003f1d000ULL,
0x00000022005d7306ULL, 0x000e700000005400ULL, 0x0000005a00567306ULL, 0x000fe40000209400ULL,
0x0000000164640812ULL, 0x000fcc00078efcffULL, 0x0000005a006b7306ULL, 0x0004e20000205400ULL,
0x0000005d5c00720bULL, 0x002fe40003f5d000ULL, 0x000000647721723eULL, 0x000fe200000010ffULL,
0x0000010022647824ULL, 0x000fc800078e00ffULL, 0x0000005400207306ULL, 0x000fe20000209400ULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x0000005a005a7245ULL, 0x004fca000020d400ULL,
0x00000054005b7306ULL, 0x000e620000205400ULL, 0x0000006b5600720bULL, 0x008fce0003f1d000ULL,
0x0000003d005c7306ULL, 0x000fec0000209400ULL, 0x000000015a5a0812ULL, 0x000fe400078efcffULL,
0x0000003d006b7306ULL, 0x000ea20000205400ULL, 0x0000005b2000720bULL, 0x002fe40003fdd000ULL,
0x0000003c5520723eULL, 0x000fc400000010ffULL, 0x00000018ff557819ULL, 0x000fc60000011422ULL,
0x0000004a00567306ULL, 0x000fe40000209400ULL, 0x00000020341c723cULL, 0x000be8000004181cULL,
0x0000000152526812ULL, 0x000fe400078efcffULL, 0x0000004a005b7306ULL, 0x000e620000205400ULL,
0x0000006b5c00720bULL, 0x004fe40003fdd000ULL, 0x0000003d00217245ULL, 0x020fc4000020d400ULL,
0x0000004a00207245ULL, 0x000fe4000020d400ULL, 0x000000525a52723eULL, 0x000fe200000010ffULL,
0x00000064005c7306ULL, 0x000fec0000209400ULL, 0x0000000121216812ULL, 0x000fe400078efcffULL,
0x00000064006b7306ULL, 0x000ea20000205400ULL, 0x0000005b5600720bULL, 0x002fe20003f1d000ULL,
0x0000010023567824ULL, 0x000fca00078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x00000023005e7306ULL, 0x000fec0000009400ULL, 0x0000000120200812ULL, 0x000fe400078efcffULL,
0x00000023005f7306ULL, 0x000e620000005400ULL, 0x0000006b5c00720bULL, 0x004fc40003fdd000ULL,
0x00000018ff5c7819ULL, 0x000fe40000011423ULL, 0x0000000b006b7245ULL, 0x000fc6000020d400ULL,
0x00000056005b7306ULL, 0x000ff00000209400ULL, 0x00000056004a7306ULL, 0x000ea20000205400ULL,
0x0000005f5e00720bULL, 0x002fe20003f1d000ULL, 0x00010000225e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000002200487306ULL, 0x0002f0000000d400ULL,
0x0000004d004e7306ULL, 0x000fe20000209400ULL, 0x0000006400227245ULL, 0x002fc8000020d400ULL,
0x0000000122226812ULL, 0x000fe400078efcffULL, 0x0000004a5b00720bULL, 0x004fe20003fdd000ULL,
0x0000004d004f7306ULL, 0x0002a20000205400ULL, 0x00010000234a7824ULL, 0x000fe200078e00ffULL,
0x0000000148482812ULL, 0x008fc800078efcffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000005e00647306ULL, 0x000fe20000209400ULL, 0x00000100474d7824ULL, 0x002fce00078e00ffULL,
0x0000005e005b7306ULL, 0x000e620000205400ULL, 0x0000004f4e00720bULL, 0x004fe40003f5d000ULL,
0x00000018ff4e7819ULL, 0x000fca0000011445ULL, 0x0000002300507306ULL, 0x0004ec000000d400ULL,
0x0000000174742812ULL, 0x000fe400078efcffULL, 0x0000005500547306ULL, 0x000fe20000209400ULL,
0x0000005600237245ULL, 0x004fc8000020d400ULL, 0x0000000123236812ULL, 0x000fe400078efcffULL,
0x0000005b6400720bULL, 0x002fe20003fdd000ULL, 0x00000055005f7306ULL, 0x0002a20000205400ULL,
0x0000000150500812ULL, 0x008fe400078efcffULL, 0x00000018ff5b7819ULL, 0x000fca0000011444ULL,
0x0000003e00617306ULL, 0x000fe20000009400ULL, 0x0000005500557245ULL, 0x002fce000020d400ULL,
0x0000003e00607306ULL, 0x000e620000005400ULL, 0x0000005f5400720bULL, 0x004fe40003f1d000ULL,
0x0000005e00547245ULL, 0x000fc8000020d400ULL, 0x0000000154546812ULL, 0x000fe200078efcffULL,
0x0000004a00667306ULL, 0x000fec0000209400ULL, 0x0000000155550812ULL, 0x000fe400078efcffULL,
0x0000004a004f7306ULL, 0x0004e20000205400ULL, 0x000000606100720bULL, 0x002fe20003fbd000ULL,
0x000001003f617824ULL, 0x000fe200078e00ffULL, 0x000000545554723eULL, 0x000fc800000010ffULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000000b00637306ULL, 0x000fe20000209400ULL,
0x0000004a004a7245ULL, 0x004fce000020d400ULL, 0x0000000b00607306ULL, 0x0002a20000205400ULL,
0x0000004f6600720bULL, 0x008fe40003fdd000ULL, 0x0000005c004f7245ULL, 0x000fca000020d400ULL,
0x0000005c003d7306ULL, 0x000fe20000209400ULL, 0x00000018ff0b7819ULL, 0x002fca0000011447ULL,
0x000000014a4a6812ULL, 0x000fe400078efcffULL, 0x0000005c00567306ULL, 0x000e620000205400ULL,
0x000000606300720bULL, 0x004fe20003fdd000ULL, 0x0000010044607824ULL, 0x000fca00078e00ffULL,
0x00000018ff607819ULL, 0x000fe20000011460ULL, 0x0000005900627306ULL, 0x000fec0000209400ULL,
0x000000016b6b6812ULL, 0x000fe400078efcffULL, 0x00000059006c7306ULL, 0x000ea20000205400ULL,
0x000000563d00720bULL, 0x002fc40003f1d000ULL, 0x00000018ff3d7819ULL, 0x000fca0000011446ULL,
0x0000003e00497306ULL, 0x000e6c000000d400ULL, 0x000000014f4f0812ULL, 0x000fe400078efcffULL,
0x0000003f00337306ULL, 0x000ee2000000d400ULL, 0x0000006c6200720bULL, 0x004fe40003fdd000ULL,
0x0000004c006c7245ULL, 0x000fc4000020d400ULL, 0x0000004a4f55723eULL, 0x000fe400000010ffULL,
0x000000016c6c3812ULL, 0x000fe200078efcffULL, 0x0000006d006f7306ULL, 0x000fe20000209400ULL,
0x0000000149495812ULL, 0x002fc800078efcffULL, 0x000000496b4c723eULL, 0x000fe400000010ffULL,
0x00000018ff497819ULL, 0x000fe2000001144dULL, 0x0000006d003f7306ULL, 0x000e620000205400ULL,
0x0000000133334812ULL, 0x008fce00078efcffULL, 0x0000004500707306ULL, 0x000ff00000009400ULL,
0x0000004500577306ULL, 0x000ea20000005400ULL, 0x0000003f6f00720bULL, 0x002fce0003fbd000ULL,
0x0000006100677306ULL, 0x000ff00000209400ULL, 0x00000061003e7306ULL, 0x0002e20000205400ULL,
0x000000577000720bULL, 0x004fe20003f9d000ULL, 0x0001000044577824ULL, 0x000fca00078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x0000004600587306ULL, 0x000fe20000009400ULL,
0x0000006100617245ULL, 0x002fce000020d400ULL, 0x0000004600517306ULL, 0x000fe20000005400ULL,
0x0000003e6700720bULL, 0x008fe20003f1d000ULL, 0x0000010045677824ULL, 0x000fca00078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000004700537306ULL, 0x000fec0000009400ULL,
0x0000000161610812ULL, 0x000fe400078efcffULL, 0x00000047005d7306ULL, 0x000e640000005400ULL,
0x00000033614d723eULL, 0x000fc400000010ffULL, 0x000000064b33723eULL, 0x000fc800000010ffULL,
0x00000060006a7306ULL, 0x000fe20000209400ULL, 0x0000004c3418723cULL, 0x000bee0000041818ULL,
0x00000060006f7306ULL, 0x0005e20000205400ULL, 0x0000005d5300720bULL, 0x002fe20003f7d000ULL,
0x00000032100c723cULL, 0x000be4000004180cULL, 0x00000067004d7245ULL, 0x020fc8000020d400ULL,
0x0000004400657306ULL, 0x000fe20000009400ULL, 0x0000006000607245ULL, 0x004fe4000020d400ULL,
0x0000005b00327245ULL, 0x000fca000020d400ULL, 0x0000004400717306ULL, 0x000e700000005400ULL,
0x0000004400407306ULL, 0x0005f0000000d400ULL, 0x0000004500417306ULL, 0x000722000000d400ULL,
0x0000005900447245ULL, 0x004fc4000020d400ULL, 0x000000716500720bULL, 0x002fe40003f1d000ULL,
0x0000000144446812ULL, 0x000fe400078efcffULL, 0x000000515800720bULL, 0x000fe20003fdd000ULL,
0x0001000045587824ULL, 0x000fe200078e00ffULL, 0x0000006700627306ULL, 0x000fe20000209400ULL,
0x0000006d00457245ULL, 0x008fe2000020d400ULL, 0x0000010046517824ULL, 0x000fe200078e00ffULL,
0x000000446c44723eULL, 0x000fe400000010ffULL, 0x00000018ff587819ULL, 0x000fc40000011458ULL,
0x0000000145455812ULL, 0x000fe200078efcffULL, 0x0000006700707306ULL, 0x000e620000205400ULL,
0x0000006f6a00720bULL, 0x000fe40003fbd000ULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x000000457445723eULL, 0x000fe400000010ffULL, 0x0000000141414812ULL, 0x010fe200078efcffULL,
0x0000005b00647306ULL, 0x000fe20000209400ULL, 0x0000000140400812ULL, 0x000fc600078efcffULL,
0x000000443414723cULL, 0x000be40000041814ULL, 0x0000000160605812ULL, 0x000fe400078efcffULL,
0x0000005b00667306ULL, 0x000ea20000205400ULL, 0x000000706200720bULL, 0x002fe40003f5d000ULL,
0x000000482244723eULL, 0x020fe400000010ffULL, 0x000000502345723eULL, 0x000fe400000010ffULL,
0x000000406040723eULL, 0x000fe200000010ffULL, 0x0000005800537306ULL, 0x000fec0000209400ULL,
0x000000014d4d2812ULL, 0x000fc400078efcffULL, 0x00000058006a7306ULL, 0x0002e20000205400ULL,
0x000000666400720bULL, 0x004fe40003fbd000ULL, 0x000000414d41723eULL, 0x000fca00000010ffULL,
0x0000004e005f7306ULL, 0x000fe20000209400ULL, 0x0000005800587245ULL, 0x002fca000020d400ULL,
0x0000000132325812ULL, 0x000fe400078efcffULL, 0x0000004e005e7306ULL, 0x000e620000205400ULL,
0x0000006a5300720bULL, 0x008fe40003f9d000ULL, 0x000000202153723eULL, 0x000fca00000010ffULL,
0x0000005700637306ULL, 0x000fe40000209400ULL, 0x000000521020723cULL, 0x000f680000041824ULL,
0x0000000158584812ULL, 0x000fe400078efcffULL, 0x0000005700657306ULL, 0x0004e20000205400ULL,
0x0000005e5f00720bULL, 0x002fce0003f1d000ULL, 0x00000051005d7306ULL, 0x000fe20000209400ULL,
0x0000005700577245ULL, 0x004fce000020d400ULL, 0x0000005100627306ULL, 0x000e620000205400ULL,
0x000000656300720bULL, 0x008fce0003f5d000ULL, 0x0000004600437306ULL, 0x0004ec000000d400ULL,
0x0000000157572812ULL, 0x000fe400078efcffULL, 0x00000047003c7306ULL, 0x0008e2000000d400ULL,
0x0001000046467824ULL, 0x004fe200078e00ffULL, 0x000000625d00720bULL, 0x002fc80003fbd000ULL,
0x00000018ff4c7819ULL, 0x000fe40000011446ULL, 0x0000004900597306ULL, 0x000fe20000209400ULL,
0x0001000047477824ULL, 0x010fe200078e00ffULL, 0x0000000143436812ULL, 0x008fc800078efcffULL,
0x00000018ff067819ULL, 0x000fe40000011447ULL, 0x0000004900617306ULL, 0x000e620000205400ULL,
0x000000441044723cULL, 0x000b620000041828ULL, 0x00000006004d7245ULL, 0x000fe4000020d400ULL,
0x000000013c3c3812ULL, 0x000fc800078efcffULL, 0x0000003d00567306ULL, 0x000fe20000209400ULL,
0x0000004e00297245ULL, 0x020fe2000020d400ULL, 0x000000541010723cULL, 0x000b62000004182cULL,
0x00000051002a7245ULL, 0x000fe4000020d400ULL, 0x0000000129290812ULL, 0x000fe400078efcffULL,
0x000000012a2a5812ULL, 0x000fe200078efcffULL, 0x0000003d005c7306ULL, 0x0004e20000205400ULL,
0x000000615900720bULL, 0x002fe40003f1d000ULL, 0x00000049002d7245ULL, 0x020fc4000020d400ULL,
0x000000573228723eULL, 0x000fe400000010ffULL, 0x000000582929723eULL, 0x000fe200000010ffULL,
0x0000000b003e7306ULL, 0x000fe20000209400ULL, 0x0000003d003d7245ULL, 0x004fe4000020d400ULL,
0x000000432a2c723eULL, 0x000fc600000010ffULL, 0x000000012d2d0812ULL, 0x000fe200078efcffULL,
0x000000283428723cULL, 0x000f620000041820ULL, 0x0000000b003f7306ULL, 0x000e620000205400ULL,
0x0000005c5600720bULL, 0x008fe40003f5d000ULL, 0x0000003c2d2d723eULL, 0x000fca00000010ffULL,
0x0000004c005e7306ULL, 0x000fe40000209400ULL, 0x0000002c342c723cULL, 0x000f680000041844ULL,
0x000000013d3d2812ULL, 0x000fe400078efcffULL, 0x0000004c004b7306ULL, 0x0004e20000205400ULL,
0x0000003f3e00720bULL, 0x002fce0003f9d000ULL, 0x0000000600337306ULL, 0x000fe20000209400ULL,
0x0000004c004c7245ULL, 0x004fce000020d400ULL, 0x0000000600247306ULL, 0x000e620000205400ULL,
0x0000004b5e00720bULL, 0x008fda0003fbd000ULL, 0x000000014c4c5812ULL, 0x000fe400078efcffULL,
0x000000243300720bULL, 0x002fe40003fdd000ULL, 0x000000403424723cULL, 0x000b62000004180cULL,
0x0000004c3d4c723eULL, 0x000fcc00000010ffULL, 0x0000000b000c7245ULL, 0x020fc8000020d400ULL,
0x000000010c0c4812ULL, 0x000fe400078efcffULL, 0x000000014d4d6812ULL, 0x000fc800078efcffULL,
0x0000004d0c4d723eULL, 0x000fce00000010ffULL, 0x0000004c3434723cULL, 0x000b620000041810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x00000000050c7f8cULL, 0x0002a2000c80043fULL,
0x0000000104047810ULL, 0x000fe40007ffe0ffULL, 0x0000f6a0750b7811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000bff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff067224ULL, 0x004fe200078e000dULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff296000007947ULL, 0x000fea000383ffffULL, 0x000000ff6900720cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0180000031007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000eec000047802ULL, 0x004fc40000000f00ULL, 0x0000891000007944ULL, 0x02afea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003100007308ULL, 0x000f240000001000ULL,
0xbf80000000027423ULL, 0x010fc80000000031ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000047919ULL, 0x004ea80000000000ULL,
0x0000000000077919ULL, 0x000ee20000000000ULL, 0x00000002ff067819ULL, 0x004fe40000011604ULL,
0x0000000807047811ULL, 0x008fe200078ff0ffULL, 0x0000000003057220ULL, 0x012fca0000410000ULL,
0x00001f0605007589ULL, 0x000e6800000e0000ULL, 0x00001f0405047589ULL, 0x000ea200000e0000ULL,
0x0000003800387220ULL, 0x042fe20000410000ULL, 0x0000003900397220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001900197220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001500157220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000003400347220ULL, 0x060fe20000410000ULL, 0x0000003500357220ULL, 0x000fe20000410000ULL,
0x0000003a043a7220ULL, 0x044fe20000410000ULL, 0x0000003b043b7220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001604167220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000003604367220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x000fc20000410000ULL,
0x0000000000007919ULL, 0x000f220000000000ULL, 0x000000282928723eULL, 0x000fc400000010ffULL,
0x0000002c2d2c723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000343534723eULL, 0x020fe400000010ffULL, 0x0000001a1b1a723eULL, 0x000fe400000010ffULL,
0x00000016170d723eULL, 0x000fc400000010ffULL, 0x000000262726723eULL, 0x000fe400000010ffULL,
0x000076321a0f7816ULL, 0x000fe4000000000dULL, 0x0000002a2b13723eULL, 0x000fe400000010ffULL,
0x0000002e2f2e723eULL, 0x000fe400000010ffULL, 0x00000002ff057819ULL, 0x016fe40000011600ULL,
0x0000000200027812ULL, 0x000fc400078ec0ffULL, 0x0000000800077811ULL, 0x000fe200078ff0ffULL,
0x0000000805097824ULL, 0x040fe200078e00ffULL, 0x0000000502047211ULL, 0x040fe200078ff8ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x000fe200078ff8ffULL,
0x00000008070e7824ULL, 0x000fe200078e00ffULL, 0x0000000204027810ULL, 0x040fe20007ffe0ffULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0x0000000404067810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL, 0x0000100072037824ULL, 0x000fe200078e00ffULL,
0xfffffff809087812ULL, 0x000fc400078ee202ULL, 0xfffffff807027812ULL, 0x000fe200078ee204ULL,
0x000008006e057824ULL, 0x000fe200078e0203ULL, 0x0000000604077810ULL, 0x000fe20007ffe0ffULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x000fe200078ee206ULL,
0x0000001002067824ULL, 0x000fe200078e0205ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x000000100e0e7824ULL, 0x100fe200078e0205ULL, 0x0000000804077812ULL, 0x000fe200078ec0ffULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0x000000383902723eULL, 0x000fe200000010ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0205ULL, 0x0000001c1d04723eULL, 0x000fe200000010ffULL,
0x0000000106067824ULL, 0x000fe200078e0207ULL, 0x000000363717723eULL, 0x000fe200000010ffULL,
0x000000100c0c7824ULL, 0x000fe200078e0205ULL, 0x0000541002107816ULL, 0x040fe20000000004ULL,
0x00000001070e7824ULL, 0x040fe200078e020eULL, 0x0000763202117816ULL, 0x000fe20000000004ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x000000181902723eULL, 0x000fe200000010ffULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x000000141504723eULL, 0x000fe200000010ffULL,
0x0000001006007388ULL, 0x0003e20000000a00ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000242505723eULL, 0x000fc400000010ffULL, 0x0000763202077816ULL, 0x100fe40000000004ULL,
0x0000763226097816ULL, 0x000fe40000000013ULL, 0x0000541002067816ULL, 0x002fe40000000004ULL,
0x0000003a3b02723eULL, 0x000fe400000010ffULL, 0x0000001e1f04723eULL, 0x000fe200000010ffULL,
0x0000000608007388ULL, 0x0003e40000000a00ULL, 0x0000541005067816ULL, 0x002fc40000000028ULL,
0x0000763205077816ULL, 0x000fe40000000028ULL, 0x000000ff00057306ULL, 0x000fe60000209400ULL,
0x000000060a007388ULL, 0x0003e40000000a00ULL, 0x000054102c067816ULL, 0x142fe40000000034ULL,
0x000076322c077816ULL, 0x000fca0000000034ULL, 0x000000060c007388ULL, 0x0003e40000000a00ULL,
0x0000541002067816ULL, 0x142fe40000000004ULL, 0x0000763202077816ULL, 0x000fe20000000004ULL,
0x000000017d027824ULL, 0x000fe200078e0200ULL, 0x000000ff00047306ULL, 0x000e660000205400ULL,
0x000000060e007388ULL, 0x0005e40000000a00ULL, 0x000054101a0e7816ULL, 0x004fe2000000000dULL,
0x0000001002067824ULL, 0x000fe200078e0203ULL, 0x000000040500720bULL, 0x002fc40003f1d000ULL,
0x000000ff00027245ULL, 0x000fe2000020d400ULL, 0x0004000e08007388ULL, 0x0003f40000000a00ULL,
0x0000000102020812ULL, 0x000fc400078efcffULL, 0x0000541026087816ULL, 0x002fe40000000013ULL,
0x000054102e0e7816ULL, 0x140fe40000000017ULL, 0x000076322e0f7816ULL, 0x000fe20000000017ULL,
0x000400080a007388ULL, 0x000fe20000000a00ULL, 0x000000020204723eULL, 0x000fe400000010ffULL,
0x000000ff6e00720cULL, 0x000fe20003f05270ULL, 0x0004000e0c007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000006107984ULL, 0x000e680000000c00ULL,
0x0004000006087984ULL, 0x008ea80000000c00ULL, 0x0008000006147984ULL, 0x000ee80000000c00ULL,
0x000c000006187984ULL, 0x000f220000000c00ULL, 0x3f803f8004137831ULL, 0x002fc40000200013ULL,
0x3f803f8004127831ULL, 0x040fe40000200012ULL, 0x3f803f8004117831ULL, 0x040fe40000200011ULL,
0x3f803f8004107831ULL, 0x040fe40000200010ULL, 0x3f803f80040b7831ULL, 0x044fe4000020000bULL,
0x3f803f80040a7831ULL, 0x040fe4000020000aULL, 0x3f803f8004097831ULL, 0x000fc40000200009ULL,
0x3f803f8004087831ULL, 0x000fe40000200008ULL, 0x3f803f8013137831ULL, 0x008fe40000200017ULL,
0x3f803f8012127831ULL, 0x000fe40000200016ULL, 0x3f803f8011117831ULL, 0x000fe40000200015ULL,
0x3f803f8010107831ULL, 0x000fe40000200014ULL, 0x3f803f800b0b7831ULL, 0x010fc4000020001bULL,
0x3f803f800a0a7831ULL, 0x000fe2000020001aULL, 0x0000001006007388ULL, 0x000fe20000000c00ULL,
0x3f803f8009097831ULL, 0x000fe40000200019ULL, 0x3f803f8008087831ULL, 0x000fca0000200018ULL,
0x0004000806007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff067819ULL, 0x000fc80000011600ULL,
0x000000790600720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000087b06ULL, 0x000e620000209000ULL, 0x000000017b027824ULL, 0x000fe200078e0206ULL,
0x00005a00ff107a12ULL, 0x000fcc00078e33ffULL, 0x0000000800087308ULL, 0x002e640000001000ULL,
0x0ffffffe08047810ULL, 0x002fcc0007ffe0ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000ffff077224ULL, 0x004fc800078e0a05ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x00000007050f7227ULL, 0x000fc800078e0004ULL,
0x0000000106047824ULL, 0x000fe400078e0200ULL, 0x000000020f077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x0000000704057812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x0ffffff805047812ULL, 0x000fca00078ef800ULL, 0x0000001004067824ULL, 0x000fe400078e0203ULL,
0x0000000107071810ULL, 0x000fc60007ffe0ffULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000710077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007057a24ULL, 0x000fe200078e0278ULL, 0x0000000700077812ULL, 0x000fe200078ec0ffULL,
0x00005a000d027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005057a24ULL, 0x000fe200078e0202ULL,
0x0000002000027810ULL, 0x000fe20007ffe0ffULL, 0x0000000872077824ULL, 0x000fc600078e0207ULL,
0x000000057c057210ULL, 0x000fe40007f3e0ffULL, 0x00000003ff067819ULL, 0x002fc60000011602ULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440cULL, 0x000000790600720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000017b047824ULL, 0x102fe200078e0206ULL,
0x00000040000c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000102067824ULL, 0x000fe400078e0206ULL,
0x000000040f077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fca00078e0204ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0000000706057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805067812ULL, 0x000fca00078ef802ULL, 0x0000001006067824ULL, 0x000fe400078e0203ULL,
0x0000000107072810ULL, 0x000fc60007ffe0ffULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000710077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007057a24ULL, 0x000fe200078e0278ULL, 0x0000000702077812ULL, 0x000fe200078ec0ffULL,
0x00005a000d047a24ULL, 0x000fe200078e0204ULL, 0x00000003ff027819ULL, 0x000fc6000001160cULL,
0x00005a0005057a24ULL, 0x000fe400078e0204ULL, 0x0000000872077824ULL, 0x000fc600078e0207ULL,
0x000000057c057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f440eULL,
0x000000790200720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000017b047824ULL, 0x102fe200078e0202ULL, 0x0000006000007810ULL, 0x000fe20007ffe0ffULL,
0x000000010c027824ULL, 0x000fe400078e0202ULL, 0x000000040f067227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a06ULL, 0x00005a0005057a24ULL, 0x000fca00078e0204ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0000000702057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805027812ULL, 0x000fca00078ef80cULL,
0x0000001002027824ULL, 0x000fe400078e0203ULL, 0x0000000106062810ULL, 0x000fc60007ffe0ffULL,
0x0000000002087984ULL, 0x0002a20000000c00ULL, 0x0000000610057207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a05ULL, 0x0000590005057a24ULL, 0x000fe200078e0278ULL,
0x00000003ff027819ULL, 0x002fe20000011600ULL, 0x00005a0007047a24ULL, 0x000fe200078e0204ULL,
0x000000070c077812ULL, 0x000fc600078ec0ffULL, 0x00005a0005057a24ULL, 0x000fe400078e0204ULL,
0x0000000872077824ULL, 0x000fe400078e0207ULL, 0x000000017b7b7824ULL, 0x000fe200078e0202ULL,
0x000000057c057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f4406ULL,
0x000000790200720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000007b0f067227ULL, 0x000fc800078e00ffULL, 0x000000ffff047224ULL, 0x002fe400078e0a06ULL,
0x0000000100027824ULL, 0x000fe400078e0202ULL, 0x00005a0004047a24ULL, 0x000fc600078e027bULL,
0x0000000702057812ULL, 0x000fe400078ec0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f26070ULL,
0xfffffff805027812ULL, 0x000fe400078ef800ULL, 0x0000000700057812ULL, 0x000fca00078ec0ffULL,
0x0000000872057824ULL, 0x000fc800078e0205ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe20003f46070ULL,
0x0000001002047824ULL, 0x000fca00078e0203ULL, 0x0000000004087984ULL, 0x000e6e0000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000610037207ULL, 0x000fca0004000000ULL,
0x000000ffff027224ULL, 0x000fe400078e0a03ULL, 0x0000590003787a24ULL, 0x000fe400078e0278ULL,
0x00005a00027b7a24ULL, 0x000fc800078e027bULL, 0x00005a00787b7a24ULL, 0x000fca00078e027bULL,
0x0000007b7c7b7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005e007b027a11ULL, 0x000fc800078040ffULL, 0x00005f007b037a11ULL, 0x000fca00000f4406ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006c00ff067624ULL, 0x000fe400078e00ffULL,
0x00006d00ff077624ULL, 0x000fca00078e00ffULL, 0x0000000606057981ULL, 0x000522000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0800780cULL, 0x000fe20003f04070ULL,
0x00000002096b7824ULL, 0x000fe200078e00ffULL, 0x00f60000ff067f8cULL, 0x004ea2000c80043fULL,
0x0000001fff097424ULL, 0x000fe400078e00ffULL, 0x00000040007a7824ULL, 0x000fe400078e00ffULL,
0x000059006b6b7a24ULL, 0x000fe200078e0278ULL, 0x0000580009087a10ULL, 0x000fc60007ffe0ffULL,
0x000068006b097a24ULL, 0x000fe200078e027aULL, 0x00000005ff087819ULL, 0x000fe20000011608ULL,
0x0000060000000947ULL, 0x000fea0003800000ULL, 0x00000002ff1c7819ULL, 0x000fe40000011602ULL,
0x0000007a68177217ULL, 0x000fe40007800000ULL, 0x000000081c167810ULL, 0x040fe20007ffe0ffULL,
0x00000001090a7824ULL, 0x002fe200078e021cULL, 0x000000181c207810ULL, 0x040fe20007ffe0ffULL,
0x0000000117177824ULL, 0x000fe200078e0a7aULL, 0x000000101c1e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001090c7824ULL, 0x040fe200078e0216ULL, 0x000000201c187810ULL, 0x040fe20007ffe0ffULL,
0x0000000109107824ULL, 0x000fe200078e0220ULL, 0x000000281c1a7810ULL, 0x000fe20007ffe0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00001000001b7811ULL, 0x000fc400078e68ffULL,
0x000000171e00720cULL, 0x080fe20003fa6070ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000300c147812ULL, 0x100fe400078ef804ULL, 0x000000172000720cULL, 0x000fe20003f86070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000300a127812ULL, 0x000fe400078ef804ULL,
0x0000640014147a10ULL, 0x000fe20007f3e0ffULL, 0x00000001090e7824ULL, 0x000fe200078e021eULL,
0x00000030100c7812ULL, 0x000fe200078ef804ULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x0000000202107211ULL, 0x000fe200078fe8ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fc40007f1e0ffULL, 0x0000000310197812ULL, 0x000fe200078ec0ffULL,
0x0000000416107824ULL, 0x000fe200078e00ffULL, 0x000000300e0a7812ULL, 0x000fe200078ef804ULL,
0x00000001090e7824ULL, 0x000fe200078e0218ULL, 0x000065000d157a10ULL, 0x000fe40000ffe4ffULL,
0x000065000b137a10ULL, 0x000fe400007fe4ffULL, 0x000064000c0c7a10ULL, 0x000fe40007f3e0ffULL,
0x000064000a0a7a10ULL, 0x000fc40007f1e0ffULL, 0xfffffffc10107812ULL, 0x000fe400078ee219ULL,
0x00006500110d7a10ULL, 0x000fe20000ffe4ffULL, 0x0000000109117824ULL, 0x000fe200078e021aULL,
0x000065000f0b7a10ULL, 0x000fe200007fe4ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000171c00720cULL, 0x080fe40003f06070ULL, 0x000000171600720cULL, 0x000fe20003f26070ULL,
0x00000010101f7824ULL, 0x000fe200078e021bULL, 0x0ffffffc19027812ULL, 0x000fe200078ef802ULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0x000000300e0e7812ULL, 0x000fc400078ef804ULL,
0x000000171800720cULL, 0x080fe20003f66070ULL, 0x00000010021d7824ULL, 0x000fe200078e021bULL,
0x000000301c027810ULL, 0x000fe20007ffe0ffULL, 0x0000000418187824ULL, 0x000fe200078e00ffULL,
0x0000003010167812ULL, 0x000fe400078ef804ULL, 0x000064000e0e7a10ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000121d7faeULL, 0x0003e2000c101c46ULL,
0x000000381c1c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109107824ULL, 0x000fe200078e0202ULL,
0x0000640016167a10ULL, 0x000fe20007fde0ffULL, 0x00000000141f7faeULL, 0x0007e2000c901c46ULL,
0x000065000f0f7a10ULL, 0x000fe200017fe4ffULL, 0x000000041c227824ULL, 0x000fe200078e00ffULL,
0x000000171a00720cULL, 0x0c0fe20003f46070ULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0x000000170200720cULL, 0x000fc40003f26070ULL, 0x000000171c00720cULL, 0x000fe20003f06070ULL,
0x0000000109127824ULL, 0x002fe200078e021cULL, 0x0000650011177a10ULL, 0x000fe200037fe4ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0xfffffffc18187812ULL, 0x100fe400078ee219ULL,
0xfffffffc1a1a7812ULL, 0x000fe200078ee219ULL, 0x0000000420147824ULL, 0x008fe200078e00ffULL,
0x0000003010107812ULL, 0x000fe200078ef804ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffffc14147812ULL, 0x100fe200078ee219ULL, 0x0000000402207824ULL, 0x000fe200078e00ffULL,
0xfffffffc1e027812ULL, 0x000fe200078ee219ULL, 0x000000101a1d7824ULL, 0x100fe200078e021bULL,
0x0000640010107a10ULL, 0x000fe20007fde0ffULL, 0x0000001014157824ULL, 0x100fe200078e021bULL,
0x0000003012047812ULL, 0x000fe200078ef804ULL, 0x0000001002097824ULL, 0x000fe200078e021bULL,
0xfffffffc201c7812ULL, 0x100fe400078ee219ULL, 0xfffffffc221e7812ULL, 0x000fe200078ee219ULL,
0x0000001018197824ULL, 0x100fe200078e021bULL, 0x0000650011117a10ULL, 0x000fe200037fe4ffULL,
0x000000101c1f7824ULL, 0x100fe200078e021bULL, 0x0000640004127a10ULL, 0x000fe20007fde0ffULL,
0x000000101e1b7824ULL, 0x000fe200078e021bULL, 0x000000000a097faeULL, 0x0003e4000e901c46ULL,
0x0000650013137a10ULL, 0x000fc400037fe4ffULL, 0x000000000c157faeULL, 0x0003e8000e101c46ULL,
0x000000000e197faeULL, 0x0003e8000d901c46ULL, 0x00000000161d7faeULL, 0x0003e8000d101c46ULL,
0x00000000101f7faeULL, 0x0003e8000c901c46ULL, 0x00000000121b7faeULL, 0x0003e2000c101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x00000010020e7811ULL, 0x040fe400078ff0ffULL,
0x0000001802107811ULL, 0x000fc400078ff0ffULL, 0x0000002802147811ULL, 0x040fe200078ff0ffULL,
0x00000001090f7824ULL, 0x040fe200078e020eULL, 0x0000003802187811ULL, 0x040fe200078ff0ffULL,
0x0000000109117824ULL, 0x040fe200078e0210ULL, 0x00000008021a7811ULL, 0x040fe200078ff0ffULL,
0x00000001091c7824ULL, 0x040fe200078e0214ULL, 0x0000002002127811ULL, 0x040fe200078ff0ffULL,
0x0000000109207824ULL, 0x000fe200078e0218ULL, 0x0000003002167811ULL, 0x000fe200078ff0ffULL,
0x000000041a227824ULL, 0x000fe200078e00ffULL, 0x00000002020b7211ULL, 0x000fe200078fe8ffULL,
0x000000040e0e7824ULL, 0x000fe200078e00ffULL, 0x00000009020a7211ULL, 0x002fe200078ff0ffULL,
0x0000000410107824ULL, 0x000fe200078e00ffULL, 0x000000030b0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000412247824ULL, 0x000fe200078e00ffULL, 0x0000100000257811ULL, 0x000fe200078e68ffULL,
0x0000000414147824ULL, 0x000fe200078e00ffULL, 0xfffffffc10137812ULL, 0x100fe200078ee20dULL,
0x0000000416267824ULL, 0x000fe200078e00ffULL, 0xfffffffc24157812ULL, 0x000fe200078ee20dULL,
0x0000000418187824ULL, 0x000fc400078e00ffULL, 0x00000001090c7824ULL, 0x040fe200078e021aULL,
0xfffffffc26177812ULL, 0x100fe200078ee20dULL, 0x00000001091a7824ULL, 0x040fe200078e0212ULL,
0xfffffffc0e127812ULL, 0x100fe200078ee20dULL, 0x00000001091e7824ULL, 0x000fe200078e0216ULL,
0x0ffffffc0d097812ULL, 0x000fe200078ef802ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffffc22027812ULL, 0x100fe400078ee20dULL, 0xfffffffc14167812ULL, 0x100fe200078ee20dULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0xfffffffc18187812ULL, 0x000fc400078ee20dULL,
0x000000300a147812ULL, 0x100fe200078ef804ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000300e197812ULL, 0x100fe400078ef804ULL, 0x0000640014147a10ULL, 0x000fe20007f1e0ffULL,
0x0000001016217824ULL, 0x100fe200078e0225ULL, 0x000000300c167812ULL, 0x000fe200078ef804ULL,
0x0000001009277824ULL, 0x000fe400078e0225ULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0x0000640016167a10ULL, 0x000fc60007f3e0ffULL, 0x0000001002097824ULL, 0x100fe200078e0225ULL,
0x0000003010107812ULL, 0x100fe200078ef804ULL, 0x00000010121b7824ULL, 0x100fe400078e0225ULL,
0x00000010131d7824ULL, 0x100fe400078e0225ULL, 0x00000010151f7824ULL, 0x100fe200078e0225ULL,
0x000065000b157a10ULL, 0x000fe200007fe4ffULL, 0x0000001017237824ULL, 0x100fe200078e0225ULL,
0x000065000d177a10ULL, 0x000fe20000ffe4ffULL, 0x0000001018257824ULL, 0x000fe200078e0225ULL,
0x0000640019187a10ULL, 0x000fe20007f5e0ffULL, 0x000000801a0a7825ULL, 0x000fe200078e00ffULL,
0x0000640010107a10ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014277faeULL, 0x0003e2000b901c46ULL, 0x000065000f197a10ULL, 0x000fe200017fe4ffULL,
0x000000801c0c7825ULL, 0x000fe200078e00ffULL, 0x000000300a0a7812ULL, 0x100fe200078ef804ULL,
0x0000000016097faeULL, 0x0003e2000b901c46ULL, 0x0000650011117a10ULL, 0x000fe200007fe4ffULL,
0x000000801e0e7825ULL, 0x000fe200078e00ffULL, 0x000000300c0c7812ULL, 0x100fe200078ef804ULL,
0x00000000181b7faeULL, 0x0003e2000b901c46ULL, 0x000064000a0a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000008020127825ULL, 0x000fe200078e00ffULL, 0x000000300e0e7812ULL, 0x000fe200078ef804ULL,
0x00000000101d7faeULL, 0x0003e2000b901c46ULL, 0x000064000c0c7a10ULL, 0x000fc40007f3e0ffULL,
0x0000003012047812ULL, 0x000fe400078ef804ULL, 0x000064000e0e7a10ULL, 0x000fe40007f5e0ffULL,
0x0000640004127a10ULL, 0x000fe40007f7e0ffULL, 0x000065000b0b7a10ULL, 0x000fe400007fe4ffULL,
0x000065000d0d7a10ULL, 0x000fe40000ffe4ffULL, 0x000065000f0f7a10ULL, 0x000fe200017fe4ffULL,
0x000000000a1f7faeULL, 0x0003e2000b901c46ULL, 0x0000650013137a10ULL, 0x000fc60001ffe4ffULL,
0x000000000c217faeULL, 0x0003e8000b901c46ULL, 0x000000000e237faeULL, 0x0003e8000b901c46ULL,
0x0000000012257faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000000000a7805ULL, 0x002fc40000015200ULL, 0x00f60400ff097984ULL, 0x000e620000000800ULL,
0x0000000803437224ULL, 0x000fe400078e02ffULL, 0x0000000168787824ULL, 0x000fc400078e0a6aULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x8000000009ff7812ULL, 0x006fe20007804807ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620043427625ULL, 0x000fe200078e0042ULL, 0x00000008ff787819ULL, 0x000fe20000011678ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000027805ULL, 0x000fcc0000015200ULL,
0x000000020a097210ULL, 0x000fca0007f1e1ffULL, 0x0000000103037824ULL, 0x000fe200000e0e0bULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011403ULL, 0x0000000902027211ULL, 0x000fca00078110ffULL,
0x000000ffff037224ULL, 0x000fca00000e0603ULL, 0x0000000202027819ULL, 0x000fc80000001203ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000104047810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002000027824ULL, 0x002fca00078e0203ULL, 0x00000003ff037819ULL, 0x000fc80000011602ULL,
0x1ffffffe03077812ULL, 0x000fe400078ec0ffULL, 0x0000000f02037812ULL, 0x000fc600078ec0ffULL,
0x0000000102077824ULL, 0x000fe400078e0207ULL, 0x0000001003097824ULL, 0x040fe400078e00ffULL,
0x0000001003047824ULL, 0x000fe200078e00ffULL, 0x0000000f07027812ULL, 0x040fe400078ec0ffULL,
0x0000000107077810ULL, 0x000fe40007ffe0ffULL, 0x000000f009027812ULL, 0x000fe400078ee202ULL,
0x0000000f07077812ULL, 0x000fc600078ec0ffULL, 0x0000000002107984ULL, 0x000e62000000cc00ULL,
0x000000f004077812ULL, 0x000fca00078ee207ULL, 0x00000000070c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fc400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000001402007388ULL, 0x0003e8000000cc00ULL, 0x0000001007007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff0a7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0c7224ULL, 0x000fc600078e00ffULL, 0x0000000000027805ULL, 0x002fc80000015200ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000602097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e03ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011407ULL, 0x0000000904047211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000204047819ULL, 0x000fc80000001207ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff6900720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x3db504f305037820ULL, 0x010fe20000410000ULL, 0x0000000208777824ULL, 0x000fe200078e00ffULL,
0x0000f68800797811ULL, 0x000fe200078e18ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0xffffffff6a6c7810ULL, 0x040fe40007ffe0ffULL, 0x000000096a6d7810ULL, 0x000fe40007ffe0ffULL,
0x0000f608007c7811ULL, 0x000fc400078e28ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e0005ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x00cfc4000001ff00ULL,
0x000000010700780cULL, 0x000fe20003f25270ULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x0000000104057810ULL, 0x000fc40007ffe0ffULL, 0x0000000107097810ULL, 0x000fc80007ffe0ffULL,
0x000000020900780cULL, 0x040fe40003f06070ULL, 0x000000ff090a7207ULL, 0x000fc60000800000ULL,
0x000000ffff051224ULL, 0x000fc800078e0204ULL, 0x0000010005197824ULL, 0x040fe200078e027aULL,
0x0000000105087810ULL, 0x000fe40007ffe0ffULL, 0x0000000106057812ULL, 0x000fe400078e0cffULL,
0x000000690800720cULL, 0x000fe20003f46070ULL, 0x000000ffff087224ULL, 0x000fe400078e0007ULL,
0x000000ffff077224ULL, 0x000fe400078e0009ULL, 0x000068006b097a24ULL, 0x000fd000078e0219ULL,
0x000005d00000a947ULL, 0x020fea0003800000ULL, 0x00000010020b7824ULL, 0x002fe200078e00ffULL,
0x00000002ff367819ULL, 0x000fe20000011602ULL, 0x0000000200357824ULL, 0x000fe200078e0205ULL,
0x0000001968187217ULL, 0x000fe40007800000ULL, 0x000000300b0b7812ULL, 0x000fe200078ec0ffULL,
0x00000001360d7824ULL, 0x040fe200078e0209ULL, 0x0000000836377810ULL, 0x000fe20007ffe0ffULL,
0x0000000118347824ULL, 0x000fe200078e0a19ULL, 0x00000010363c7810ULL, 0x000fe20007ffe0ffULL,
0x000000400a0a7824ULL, 0x000fe200078e020bULL, 0x00000018363e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001370f7824ULL, 0x100fe200078e0209ULL, 0x0000100035357811ULL, 0x000fe200078e60ffULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x0000002036407810ULL, 0x000fe20007ffe0ffULL,
0x000000013c317824ULL, 0x000fe200078e0209ULL, 0x000000343e00720cULL, 0x000fe20003fa6070ULL,
0x000000800f0e7825ULL, 0x000fc800078e000aULL, 0x000000800d0c7825ULL, 0x000fe200078e000aULL,
0x000064000e187a10ULL, 0x000fe40007f5e0ffULL, 0x00000002020e7211ULL, 0x000fe200078fe8ffULL,
0x000000013e337824ULL, 0x000fe200078e0209ULL, 0x000064000c1a7a10ULL, 0x000fe20007f3e0ffULL,
0x0000008031307825ULL, 0x100fe200078e000aULL, 0x000000030e417812ULL, 0x000fe400078ec0ffULL,
0x000065000d1b7a10ULL, 0x000fe20000ffe4ffULL, 0x0000008033327825ULL, 0x000fe200078e000aULL,
0x0000640030307a10ULL, 0x000fc40007f7e0ffULL, 0x000065000f197a10ULL, 0x000fe200017fe4ffULL,
0x0000000437447824ULL, 0x000fe200078e00ffULL, 0x00006400320c7a10ULL, 0x000fe20007f3e0ffULL,
0x000000043c467824ULL, 0x000fe200078e00ffULL, 0x0000650031317a10ULL, 0x000fe20001ffe4ffULL,
0x00000001400f7824ULL, 0x000fe200078e0209ULL, 0x000000343c00720cULL, 0x000fe40003f66070ULL,
0xfffffffc443c7812ULL, 0x000fe200078ee241ULL, 0x000000800f0e7825ULL, 0x000fe200078e000aULL,
0x00006500330d7a10ULL, 0x000fc40000ffe4ffULL, 0x000000343600720cULL, 0x080fe20003f26070ULL,
0x000000103c3d7824ULL, 0x100fe200078e0235ULL, 0x0ffffffc41327812ULL, 0x000fe400078ef802ULL,
0x000000343700720cULL, 0x000fe40003f46070ULL, 0x00000028363c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001032377824ULL, 0x000fe200078e0235ULL, 0xfffffffc46327812ULL, 0x000fe400078ee241ULL,
0x0000003036447810ULL, 0x000fe20007ffe0ffULL, 0x000000013c337824ULL, 0x000fe200078e0209ULL,
0x000064000e0e7a10ULL, 0x000fe20007f9e0ffULL, 0x00000010323f7824ULL, 0x000fe200078e0235ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a377faeULL, 0x0003e2000c901c46ULL,
0x0000008033327825ULL, 0x000fe200078e000aULL, 0x0000003836367810ULL, 0x000fc40007ffe0ffULL,
0x00000000183d7faeULL, 0x0005e2000d101c46ULL, 0x000065000f0f7a10ULL, 0x000fe400027fe4ffULL,
0x000000344000720cULL, 0x080fe20003f86070ULL, 0x00000000303f7faeULL, 0x0007e2000d901c46ULL,
0x000000343c00720cULL, 0x080fe40003f66070ULL, 0x000000344400720cULL, 0x0c0fe20003f46070ULL,
0x00000001441b7824ULL, 0x102fe200078e0209ULL, 0x000000343600720cULL, 0x040fe20003f26070ULL,
0x0000000136097824ULL, 0x000fe200078e0209ULL, 0x0000640032187a10ULL, 0x004fe20007fde0ffULL,
0x000000801b1a7825ULL, 0x000fc600078e000aULL, 0x0000650033197a10ULL, 0x000fe200037fe4ffULL,
0x000000043e307824ULL, 0x008fe200078e00ffULL, 0x000064001a1a7a10ULL, 0x000fe20007fde0ffULL,
0x0000000440327824ULL, 0x000fe400078e00ffULL, 0x000000043c347824ULL, 0x000fe200078e00ffULL,
0xfffffffc30307812ULL, 0x100fe200078ee241ULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0xfffffffc32327812ULL, 0x100fe200078ee241ULL, 0x00000004363c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc34347812ULL, 0x000fe200078ee241ULL, 0x00000080090a7825ULL, 0x000fe200078e000aULL,
0xfffffffc44367812ULL, 0x000fc400078ee241ULL, 0xfffffffc3c3c7812ULL, 0x000fe200078ee241ULL,
0x0000001030097824ULL, 0x100fe200078e0235ULL, 0x000065001b1b7a10ULL, 0x000fe200037fe4ffULL,
0x0000001032317824ULL, 0x100fe200078e0235ULL, 0x000064000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x0000001034337824ULL, 0x100fe200078e0235ULL, 0x000000000c097faeULL, 0x0003e2000e901c46ULL,
0x0000001036377824ULL, 0x100fe200078e0235ULL, 0x000065000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x000000103c357824ULL, 0x000fe200078e0235ULL, 0x000000000e317faeULL, 0x0003e8000e101c46ULL,
0x0000000018337faeULL, 0x0003e8000d901c46ULL, 0x000000001a377faeULL, 0x0003e8000d101c46ULL,
0x000000000a357faeULL, 0x0003e2000c901c46ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x00000010020b7824ULL, 0x042fe200078e00ffULL, 0x00000008020e7811ULL, 0x000fe200078ff0ffULL,
0x00000002000d7824ULL, 0x000fe200078e0205ULL, 0x0000001002187811ULL, 0x000fc400078ff0ffULL,
0x000000300b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000010e0f7824ULL, 0x000fe200078e0209ULL,
0x00000018021a7811ULL, 0x000fe200078ff0ffULL, 0x000000040e0e7824ULL, 0x000fe200078e00ffULL,
0x0000002002307811ULL, 0x000fe200078ff0ffULL, 0x000000400a0a7824ULL, 0x000fe200078e020bULL,
0x0000002802327811ULL, 0x000fe200078ff0ffULL, 0x0000000118197824ULL, 0x100fe200078e0209ULL,
0x0000003002347811ULL, 0x000fe200078ff0ffULL, 0x000000011a1b7824ULL, 0x100fe200078e0209ULL,
0x0000003802367811ULL, 0x000fe200078ff0ffULL, 0x0000000130317824ULL, 0x100fe200078e0209ULL,
0x00000002020c7211ULL, 0x000fe200078fe8ffULL, 0x0000000132337824ULL, 0x000fc400078e0209ULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0x000000030c0b7812ULL, 0x000fe200078ec0ffULL,
0x000000041a1a7824ULL, 0x000fe200078e00ffULL, 0x000010000d0c7811ULL, 0x000fe200078e60ffULL,
0x0000000430307824ULL, 0x000fe200078e00ffULL, 0xfffffffc0e377812ULL, 0x100fe200078ee20bULL,
0x0000000432327824ULL, 0x000fe200078e00ffULL, 0xfffffffc183d7812ULL, 0x100fe200078ee20bULL,
0x00000004343c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1a3f7812ULL, 0x100fe200078ee20bULL,
0x00000004363e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc30417812ULL, 0x000fe200078ee20bULL,
0x0000000134357824ULL, 0x000fe200078e0209ULL, 0xfffffffc32457812ULL, 0x000fe200078ee20bULL,
0x0000000136477824ULL, 0x000fe200078e0209ULL, 0xfffffffc3c497812ULL, 0x000fc400078ee20bULL,
0xfffffffc3e4d7812ULL, 0x000fe400078ee20bULL, 0x0ffffffc0b0b7812ULL, 0x000fe400078ef802ULL,
0x00000009020d7211ULL, 0x000fe200078ff0ffULL, 0x0000001037097824ULL, 0x100fe400078e020cULL,
0x000000103d377824ULL, 0x100fe400078e020cULL, 0x000000100b4b7824ULL, 0x100fe400078e020cULL,
0x000000103f3d7824ULL, 0x000fc400078e020cULL, 0x00000010413f7824ULL, 0x100fe400078e020cULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x0000001045417824ULL, 0x100fe400078e020cULL,
0x0000001049457824ULL, 0x100fe400078e020cULL, 0x000000104d497824ULL, 0x000fe400078e020cULL,
0x000000800d0c7825ULL, 0x000fc800078e000aULL, 0x000000800f0e7825ULL, 0x000fe200078e000aULL,
0x000064000c0c7a10ULL, 0x000fc60007f3e0ffULL, 0x0000008019187825ULL, 0x100fe200078e000aULL,
0x000064000e0e7a10ULL, 0x000fe40007f5e0ffULL, 0x000065000d0d7a10ULL, 0x000fe20000ffe4ffULL,
0x000000801b1a7825ULL, 0x100fe200078e000aULL, 0x0000640018187a10ULL, 0x000fe40007f7e0ffULL,
0x000065000f0f7a10ULL, 0x000fe200017fe4ffULL, 0x0000008031307825ULL, 0x100fe200078e000aULL,
0x000064001a1a7a10ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c4b7faeULL, 0x0003e2000b901c46ULL, 0x0000650019197a10ULL, 0x000fe20001ffe4ffULL,
0x0000008033327825ULL, 0x100fe200078e000aULL, 0x0000640030307a10ULL, 0x000fe20007f3e0ffULL,
0x000000000e097faeULL, 0x0003e2000b901c46ULL, 0x000065001b1b7a10ULL, 0x000fe200027fe4ffULL,
0x0000008035347825ULL, 0x100fe200078e000aULL, 0x0000640032327a10ULL, 0x000fe20007f5e0ffULL,
0x0000000018377faeULL, 0x0003e2000b901c46ULL, 0x0000650031317a10ULL, 0x000fe20000ffe4ffULL,
0x00000080470a7825ULL, 0x000fe200078e000aULL, 0x0000640034347a10ULL, 0x000fe20007f7e0ffULL,
0x000000001a3d7faeULL, 0x0003e2000b901c46ULL, 0x0000650033337a10ULL, 0x000fc400017fe4ffULL,
0x000064000a0a7a10ULL, 0x000fe20007f9e0ffULL, 0x00000000303f7faeULL, 0x0003e2000b901c46ULL,
0x0000650035357a10ULL, 0x000fe40001ffe4ffULL, 0x000065000b0b7a10ULL, 0x000fe200027fe4ffULL,
0x0000000032417faeULL, 0x0003e8000b901c46ULL, 0x0000000034457faeULL, 0x0003e8000b901c46ULL,
0x000000000a497faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff097224ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff8020b7812ULL, 0x000fe200078ec0ffULL,
0x00000002005c7824ULL, 0x000fe200078e0206ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004084e7824ULL, 0x020fe200078e0209ULL, 0x000000070b0b7812ULL, 0x000fc400078ef802ULL,
0x000010005c5c7811ULL, 0x000fe200078e60ffULL, 0x000000024e4e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe2000001160bULL, 0x000000040b0d7824ULL, 0x000fe200078e00ffULL,
0x0000000109597810ULL, 0x000fe20007ffe0ffULL, 0x000000040b0b7824ULL, 0x000fe400078e00ffULL,
0x000000010a0c7824ULL, 0x040fe400078e0209ULL, 0x000000010a0a7824ULL, 0x000fc600078e0259ULL,
0xfffffffc0d0d7812ULL, 0x000fe400078ee20cULL, 0xfffffffc0b0b7812ULL, 0x000fc600078ee20aULL,
0x000000100d0d7824ULL, 0x100fe400078e025cULL, 0x000000100b0b7824ULL, 0x000fc600078e025cULL,
0x000000000d44783bULL, 0x000e680000000200ULL, 0x000000000b30783bULL, 0x0005e40000000200ULL,
0x00000020020b7810ULL, 0x004fc80007ffe0ffULL, 0xfffffff80b0b7812ULL, 0x000fc800078ec0ffULL,
0x000000070b587812ULL, 0x000fc800078ef802ULL, 0x00000001ff6e7819ULL, 0x000fe20000011658ULL,
0x00000004580b7824ULL, 0x000fc800078e00ffULL, 0x000000016e0a7824ULL, 0x000fe200078e0209ULL,
0x0000000209097810ULL, 0x000fc80007ffe0ffULL, 0xfffffffc0b0b7812ULL, 0x000fca00078ee20aULL,
0x000000100b347824ULL, 0x000fe200078e025cULL, 0x0000004500197306ULL, 0x002fe20000009400ULL,
0x00010000446f7824ULL, 0x040fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x000fe20000011444ULL,
0x0000010044547824ULL, 0x000fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011445ULL,
0x00000100455d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001146fULL,
0x000000003434783bULL, 0x000fe20000000200ULL, 0x00000045001a7306ULL, 0x000e620000005400ULL,
0x00000018ff547819ULL, 0x000fc40000011454ULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x0000000f00717245ULL, 0x000fe4000020d400ULL, 0x00000018ff5f7819ULL, 0x000fe20000011446ULL,
0x0000004400187306ULL, 0x000fe20000009400ULL, 0x00000018ff617819ULL, 0x000fce0000011447ULL,
0x00000044001b7306ULL, 0x000ea20000005400ULL, 0x0000001a1900720bULL, 0x002fe40003f5d000ULL,
0x0000000702197812ULL, 0x000fca00078ec0ffULL, 0x00000044000e7306ULL, 0x0002e2000000d400ULL,
0x0000001b1800720bULL, 0x004fce0003f3d000ULL, 0x0000006f00527306ULL, 0x000fe20000209400ULL,
0x0000000819447812ULL, 0x002fe400078ef802ULL, 0x0000004e02197211ULL, 0x000fc600078fe0ffULL,
0x00000010441a7824ULL, 0x040fe400078e00ffULL, 0x0000006f001b7306ULL, 0x000e620000205400ULL,
0x0000000144197824ULL, 0x000fe200078e0219ULL, 0x000000010e0e1812ULL, 0x008fc800078efcffULL,
0xfffffff01a197812ULL, 0x000fe400078ee219ULL, 0x0000005400187306ULL, 0x000fe60000209400ULL,
0x0000001019197824ULL, 0x000fca00078e00ffULL, 0x0000005400577306ULL, 0x000ea20000205400ULL,
0x0000001b5200720bULL, 0x002fce0003f7d000ULL, 0x0000000f00537306ULL, 0x000ff00000209400ULL,
0x0000000f00607306ULL, 0x0002e20000205400ULL, 0x000000571800720bULL, 0x004fe40003f9d000ULL,
0x000000001918783bULL, 0x000eaa0000000200ULL, 0x0000004500557306ULL, 0x000922000000d400ULL,
0x00000054000f7245ULL, 0x002fca000020d400ULL, 0x000000010f0f4812ULL, 0x000fe400078efcffULL,
0x000000605300720bULL, 0x008fe20003fbd000ULL, 0x0001000045607824ULL, 0x000fe200078e00ffULL,
0x0000006f00457245ULL, 0x010fe2000020d400ULL, 0x0000005600727306ULL, 0x000fe60000209400ULL,
0x00000018ff607819ULL, 0x000fe40000011460ULL, 0x0000000145453812ULL, 0x000fc400078efcffULL,
0x0000000155552812ULL, 0x000fe200078efcffULL, 0x00000056004f7306ULL, 0x000e620000205400ULL,
0x0000000e450e723eULL, 0x000fe400000010ffULL, 0x0000000171715812ULL, 0x000fc800078efcffULL,
0x0000000f710f723eULL, 0x000fe200000010ffULL, 0x0000005d006f7306ULL, 0x000ff00000209400ULL,
0x0000005d00767306ULL, 0x000ee20000205400ULL, 0x0000004f7200720bULL, 0x002fe20003fbd000ULL,
0x0000000e1838723cULL, 0x004b6c0000041838ULL, 0x0000006000577306ULL, 0x000fe20000209400ULL,
0x00000060000e7245ULL, 0x020fc4000020d400ULL, 0x0000005d000f7245ULL, 0x000fca000020d400ULL,
0x0000006000747306ULL, 0x0002a20000205400ULL, 0x000000766f00720bULL, 0x008fe20003f9d000ULL,
0x000000016e6f7824ULL, 0x000fe200078e0259ULL, 0x00000056006e7245ULL, 0x000fc8000020d400ULL,
0x000000016e6e5812ULL, 0x000fe200078efcffULL, 0x0000004600417306ULL, 0x000fe20000009400ULL,
0x0000000458607824ULL, 0x002fca00078e00ffULL, 0xfffffffc606f7812ULL, 0x000fe200078ee26fULL,
0x0001000046607824ULL, 0x000fe200078e00ffULL, 0x0000004600707306ULL, 0x000e620000005400ULL,
0x000000745700720bULL, 0x004fe40003f7d000ULL, 0x000000010f0f4812ULL, 0x000fe200078efcffULL,
0x000000106f717824ULL, 0x000fe200078e025cULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x0000000f6e0f723eULL, 0x000fe200000010ffULL, 0x00000100466e7824ULL, 0x000fe200078e00ffULL,
0x00000060005d7306ULL, 0x000fe20000209400ULL, 0x00000018ff577819ULL, 0x000fc60000011430ULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x000000010e0e3812ULL, 0x000fe400078efcffULL,
0x000000704100720bULL, 0x002fe20003f3d000ULL, 0x00000046000d7306ULL, 0x0002a2000000d400ULL,
0x000000550e0e723eULL, 0x000fe400000010ffULL, 0x00000018ff557819ULL, 0x000fca0000011431ULL,
0x0000006000707306ULL, 0x000ee20000205400ULL, 0x0000000e1814723cULL, 0x000be20000041814ULL,
0x0001000047467824ULL, 0x002fca00078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000005f003e7306ULL, 0x000fe20000209400ULL, 0x000000010d0d1812ULL, 0x004fce00078efcffULL,
0x0000005f003f7306ULL, 0x000e620000205400ULL, 0x000000705d00720bULL, 0x008fce0003fbd000ULL,
0x0000006e006f7306ULL, 0x000ff00000209400ULL, 0x0000006e000e7306ULL, 0x020ea20000205400ULL,
0x0000003f3e00720bULL, 0x002fce0003fdd000ULL, 0x00000047003c7306ULL, 0x000ff00000009400ULL,
0x00000047003d7306ULL, 0x000e620000005400ULL, 0x0000000e6f00720bULL, 0x004fe40003f9d000ULL,
0x00000060000e7245ULL, 0x000fc8000020d400ULL, 0x000000010e0e5812ULL, 0x000fe200078efcffULL,
0x0000004700627306ULL, 0x0004e6000000d400ULL, 0x0000000d0e0e723eULL, 0x000fca00000010ffULL,
0x00000046000f7306ULL, 0x000fe20000209400ULL, 0x0000010047477824ULL, 0x004fe200078e00ffULL,
0x0000003d3c00720bULL, 0x002fe40003f5d000ULL, 0x00000000713c783bULL, 0x0002a40000000200ULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000004600707306ULL, 0x000f2e0000205400ULL,
0x0000000162622812ULL, 0x008fe200078efcffULL, 0x00000061005e7306ULL, 0x000ff00000209400ULL,
0x00000061005b7306ULL, 0x000ee20000205400ULL, 0x000000700f00720bULL, 0x010fc40003f3d000ULL,
0x0000005f00707245ULL, 0x000fe4000020d400ULL, 0x0000006e000f7245ULL, 0x000fe4000020d400ULL,
0x0000000170706812ULL, 0x000fe200078efcffULL, 0x00000047006f7306ULL, 0x000fe20000209400ULL,
0x000000010f0f4812ULL, 0x000fe400078efcffULL, 0x00000061006e7245ULL, 0x000fe4000020d400ULL,
0x0000000f700f723eULL, 0x000fc600000010ffULL, 0x0000004700727306ULL, 0x0008620000205400ULL,
0x0000005b5e00720bULL, 0x008fe40003f7d000ULL, 0x00000018ff5b7819ULL, 0x000fe20000011432ULL,
0x0000000e1820723cULL, 0x000be80000041820ULL, 0x0000003400647306ULL, 0x000fe20000009400ULL,
0x0000004700477245ULL, 0x010fe4000020d400ULL, 0x00000046000f7245ULL, 0x020fc4000020d400ULL,
0x00000018ff467819ULL, 0x000fe40000011435ULL, 0x000000010f0f1812ULL, 0x000fe200078efcffULL,
0x0000003400657306ULL, 0x000ee20000005400ULL, 0x000000726f00720bULL, 0x002fe20003f9d000ULL,
0x00010000346f7824ULL, 0x000fe200078e00ffULL, 0x000000016e6e3812ULL, 0x000fe400078efcffULL,
0x000000620f0e723eULL, 0x000fe400000010ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001146fULL,
0x0000003500667306ULL, 0x000fec0000009400ULL, 0x0000000147474812ULL, 0x000fc400078efcffULL,
0x0000003500677306ULL, 0x000e620000005400ULL, 0x000000656400720bULL, 0x008fe40003fdd000ULL,
0x000000476e0f723eULL, 0x000fe400000010ffULL, 0x00000018ff477819ULL, 0x000fc60000011434ULL,
0x0000003400637306ULL, 0x000724000000d400ULL, 0x0000000e1810723cULL, 0x000b6c0000041810ULL,
0x00000047006e7306ULL, 0x000fe20000209400ULL, 0x0000010034347824ULL, 0x008fe200078e00ffULL,
0x000000676600720bULL, 0x002fe20003f3d000ULL, 0x0001000035677824ULL, 0x000fc600078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000047000f7306ULL, 0x020e620000205400ULL,
0x00000018ff677819ULL, 0x000fe40000011467ULL, 0x0000000163636812ULL, 0x010fca00078efcffULL,
0x0000006f00647306ULL, 0x000ff00000209400ULL, 0x0000006f00717306ULL, 0x000ee20000205400ULL,
0x0000000f6e00720bULL, 0x002fe20003f5d000ULL, 0x00000100356e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe2000001146eULL, 0x0000003400727306ULL, 0x000ff00000209400ULL,
0x0000003400737306ULL, 0x000e620000205400ULL, 0x000000716400720bULL, 0x008fce0003f9d000ULL,
0x0000004600707306ULL, 0x000ff00000209400ULL, 0x0000004600657306ULL, 0x000ee20000205400ULL,
0x000000737200720bULL, 0x002fce0003fbd000ULL, 0x0000006700667306ULL, 0x000ff00000209400ULL,
0x00000067000f7306ULL, 0x0003220000205400ULL, 0x000000657000720bULL, 0x008fe40003f7d000ULL,
0x0000004700707245ULL, 0x000fc4000020d400ULL, 0x0000006e00477245ULL, 0x000fe4000020d400ULL,
0x0000000170702812ULL, 0x000fe200078efcffULL, 0x0000006e00717306ULL, 0x000fe20000209400ULL,
0x0000006700677245ULL, 0x002fce000020d400ULL, 0x0000006e00727306ULL, 0x000e620000205400ULL,
0x0000000f6600720bULL, 0x010fe40003fdd000ULL, 0x0000006f00667245ULL, 0x000fc8000020d400ULL,
0x0000000166664812ULL, 0x000fe200078efcffULL, 0x00000035005a7306ULL, 0x00072c000000d400ULL,
0x0000000167676812ULL, 0x000fe400078efcffULL, 0x000000727100720bULL, 0x002fe20003f5d000ULL,
0x0000003600537306ULL, 0x000fe20000009400ULL, 0x0000003400357245ULL, 0x008fc4000020d400ULL,
0x000000636634723eULL, 0x000fe400000010ffULL, 0x0000000135355812ULL, 0x000fe400078efcffULL,
0x000000015a5a1812ULL, 0x010fe200078efcffULL, 0x0000003600527306ULL, 0x000e620000005400ULL,
0x000000357035723eULL, 0x000fe400000010ffULL, 0x0000004600707245ULL, 0x000fe4000020d400ULL,
0x0000000147472812ULL, 0x000fc400078efcffULL, 0x0000000170703812ULL, 0x000fe200078efcffULL,
0x0000003600547306ULL, 0x000722000000d400ULL, 0x0000005a6746723eULL, 0x000fe200000010ffULL,
0x0001000036677824ULL, 0x000fe200078e00ffULL, 0x000000477047723eULL, 0x000fe200000010ffULL,
0x000000341824723cULL, 0x000be60000041824ULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000003700457306ULL, 0x000fe20000009400ULL, 0x000000525300720bULL, 0x002fc40003f3d000ULL,
0x00000018ff357819ULL, 0x020fe20000011433ULL, 0x000000461828723cULL, 0x000b680000041828ULL,
0x00000067006e7306ULL, 0x000fe60000209400ULL, 0x00000018ff477819ULL, 0x020fe20000011436ULL,
0x0000010036367824ULL, 0x008fe400078e00ffULL, 0x0000000154541812ULL, 0x010fc400078efcffULL,
0x00000067006f7306ULL, 0x0002e20000205400ULL, 0x00000018ff367819ULL, 0x000fce0000011436ULL,
0x0000004700527306ULL, 0x000fe20000209400ULL, 0x0000006700677245ULL, 0x002fce000020d400ULL,
0x0000004700717306ULL, 0x000e620000205400ULL, 0x0000006f6e00720bULL, 0x008fe20003f5d000ULL,
0x00010000376e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fc80000011437ULL,
0x00000018ff6e7819ULL, 0x000fe2000001146eULL, 0x0000003600467306ULL, 0x000fec0000209400ULL,
0x0000000167672812ULL, 0x000fe400078efcffULL, 0x0000003600537306ULL, 0x000ee20000205400ULL,
0x000000715200720bULL, 0x002fe20003f9d000ULL, 0x0001000030527824ULL, 0x000fca00078e00ffULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x00000037004f7306ULL, 0x000e620000005400ULL,
0x000000534600720bULL, 0x008fce0003f7d000ULL, 0x00000032004c7306ULL, 0x000fe20000009400ULL,
0x000000546746723eULL, 0x000fe200000010ffULL, 0x0001000032537824ULL, 0x000fe200078e00ffULL,
0x0000004700547245ULL, 0x000fe4000020d400ULL, 0x0000003600477245ULL, 0x000fe2000020d400ULL,
0x0000010030367824ULL, 0x000fe200078e00ffULL, 0x0000000154544812ULL, 0x000fe200078efcffULL,
0x0000003200487306ULL, 0x000ee20000005400ULL, 0x0000004f4500720bULL, 0x002fe20003f3d000ULL,
0x0000010037457824ULL, 0x000fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fc40000011436ULL,
0x0000000147473812ULL, 0x000fe400078efcffULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x0000003000517306ULL, 0x000fe20000009400ULL, 0x000000475447723eULL, 0x000fe200000010ffULL,
0x0000010031547824ULL, 0x000fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fc80000011453ULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000003000507306ULL, 0x000e620000005400ULL,
0x00000046182c723cULL, 0x000b62000004182cULL, 0x000000484c00720bULL, 0x008fcc0003fbd000ULL,
0x0000003000407306ULL, 0x000ee2000000d400ULL, 0x0001000031467824ULL, 0x020fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x0000003100497306ULL, 0x000fe20000009400ULL,
0x000000505100720bULL, 0x002fe40003fdd000ULL, 0x00000046004f7245ULL, 0x000fca000020d400ULL,
0x00000031004a7306ULL, 0x000e6c0000005400ULL, 0x0000000140406812ULL, 0x008fe400078efcffULL,
0x0000006e00307306ULL, 0x000ff00000209400ULL, 0x0000006e00477306ULL, 0x0007220000205400ULL,
0x0000004a4900720bULL, 0x002fce0003f7d000ULL, 0x0000003700417306ULL, 0x000e62000000d400ULL,
0x0000006e006e7245ULL, 0x008fce000020d400ULL, 0x0000004600487306ULL, 0x000fe20000209400ULL,
0x000000473000720bULL, 0x010fce0003f5d000ULL, 0x0000004600377306ULL, 0x000ee20000205400ULL,
0x0000000141411812ULL, 0x002fca00078efcffULL, 0x000000016e6e2812ULL, 0x000fe400078efcffULL,
0x0000004500497306ULL, 0x000ff00000209400ULL, 0x0000004500307306ULL, 0x000e620000205400ULL,
0x000000374800720bULL, 0x008fc40003fdd000ULL, 0x00000018ff377819ULL, 0x004fca000001143eULL,
0x0000006f00737306ULL, 0x000fec0000209400ULL, 0x000000014f4f6812ULL, 0x000fe400078efcffULL,
0x0000006f00707306ULL, 0x0004e20000205400ULL, 0x000000304900720bULL, 0x002fe20003f5d000ULL,
0x0000010032307824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fc8000001143cULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000005400477306ULL, 0x000fe20000209400ULL,
0x0000006f006f7245ULL, 0x004fce000020d400ULL, 0x0000005400727306ULL, 0x0002a20000205400ULL,
0x000000707300720bULL, 0x008fe40003f3d000ULL, 0x0000004500707245ULL, 0x000fe4000020d400ULL,
0x00000018ff457819ULL, 0x000fe4000001143dULL, 0x0000000170702812ULL, 0x000fe200078efcffULL,
0x0000005200677306ULL, 0x000fe20000209400ULL, 0x0000005400547245ULL, 0x002fca000020d400ULL,
0x000000016f6f1812ULL, 0x000fe400078efcffULL, 0x0000005200717306ULL, 0x0002e20000205400ULL,
0x000000724700720bULL, 0x004fe20003fdd000ULL, 0x0001000033727824ULL, 0x000fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011472ULL, 0x0000003600517306ULL, 0x000fe20000209400ULL,
0x0000005200527245ULL, 0x002fca000020d400ULL, 0x0000000154546812ULL, 0x000fe400078efcffULL,
0x0000003600767306ULL, 0x000e620000205400ULL, 0x000000716700720bULL, 0x008fe20003f5d000ULL,
0x0000010033717824ULL, 0x000fca00078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0000005300747306ULL, 0x000fec0000209400ULL, 0x0000000152522812ULL, 0x000fe400078efcffULL,
0x0000005300757306ULL, 0x0004e20000205400ULL, 0x000000765100720bULL, 0x002fc40003f3d000ULL,
0x000000405240723eULL, 0x000fca00000010ffULL, 0x00000033004d7306ULL, 0x000fe20000009400ULL,
0x0000005300537245ULL, 0x004fce000020d400ULL, 0x00000033004b7306ULL, 0x000e620000005400ULL,
0x000000757400720bULL, 0x008fce0003fdd000ULL, 0x0000005700597306ULL, 0x000fec0000209400ULL,
0x0000000153536812ULL, 0x000fe400078efcffULL, 0x0000005700587306ULL, 0x0004e20000205400ULL,
0x0000004b4d00720bULL, 0x002fe40003f9d000ULL, 0x00000036004d7245ULL, 0x000fc4000020d400ULL,
0x00000018ff367819ULL, 0x000fe4000001143fULL, 0x000000014d4d1812ULL, 0x000fe200078efcffULL,
0x00000031000b7306ULL, 0x000e62000000d400ULL, 0x0000005700577245ULL, 0x004fce000020d400ULL,
0x0000005500567306ULL, 0x000fe20000209400ULL, 0x000000585900720bULL, 0x008fce0003f5d000ULL,
0x00000055005c7306ULL, 0x0004e20000205400ULL, 0x000000010b0b3812ULL, 0x002fca00078efcffULL,
0x0000000157572812ULL, 0x000fe400078efcffULL, 0x0000003c00607306ULL, 0x000fe20000009400ULL,
0x0000005500557245ULL, 0x004fce000020d400ULL, 0x0000003c005f7306ULL, 0x000e620000005400ULL,
0x0000005c5600720bULL, 0x008fe40003f3d000ULL, 0x0000003000567245ULL, 0x000fca000020d400ULL,
0x00000032000a7306ULL, 0x000eac000000d400ULL, 0x0000000155551812ULL, 0x000fe400078efcffULL,
0x0000003000317306ULL, 0x000fe20000209400ULL, 0x0000005f6000720bULL, 0x002fe40003f7d000ULL,
0x000000024e5f7810ULL, 0x000fe20007ffe0ffULL, 0x000100003e4e7824ULL, 0x000fc600078e00ffULL,
0x0000005f025f7211ULL, 0x000fe200078fe0ffULL, 0x0000003000327306ULL, 0x000e620000205400ULL,
0x000000010a0a5812ULL, 0x004fe400078efcffULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x00000001445f7824ULL, 0x040fe200078e025fULL, 0x0000000a530a723eULL, 0x000fe200000010ffULL,
0x0000001044447824ULL, 0x000fe400078e00ffULL, 0x00000033000c7306ULL, 0x0004e6000000d400ULL,
0xfffffff0445f7812ULL, 0x000fca00078ee25fULL, 0x0000005b005d7306ULL, 0x000fe20000209400ULL,
0x000100003c337824ULL, 0x004fe200078e00ffULL, 0x000000323100720bULL, 0x002fe20003fdd000ULL,
0x000000105f307824ULL, 0x000fc600078e00ffULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000005b005e7306ULL, 0x000e620000205400ULL, 0x000000010c0c4812ULL, 0x008fe400078efcffULL,
0x0000003300447245ULL, 0x000fc8000020d400ULL, 0x0000000156566812ULL, 0x000fe200078efcffULL,
0x0000003c000d7306ULL, 0x0004f0000000d400ULL, 0x0000003300597306ULL, 0x000fe20000209400ULL,
0x000001003c3c7824ULL, 0x004fe200078e00ffULL, 0x0000005e5d00720bULL, 0x002fe20003f5d000ULL,
0x000100003d5d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000033005c7306ULL, 0x000e620000205400ULL, 0x000000010d0d3812ULL, 0x008fe400078efcffULL,
0x00000018ff5d7819ULL, 0x000fca000001145dULL, 0x0000003c00317306ULL, 0x000ff00000209400ULL,
0x0000003c00327306ULL, 0x000ea20000205400ULL, 0x0000005c5900720bULL, 0x002fe20003fdd000ULL,
0x000001003d597824ULL, 0x000fe200078e00ffULL, 0x0000005b005c7245ULL, 0x000fc8000020d400ULL,
0x000000015c5c2812ULL, 0x000fe200078efcffULL, 0x0000007200587306ULL, 0x000fe20000209400ULL,
0x00000018ff597819ULL, 0x000fca0000011459ULL, 0x0000000144446812ULL, 0x000fe400078efcffULL,
0x00000072005e7306ULL, 0x0002e20000205400ULL, 0x000000323100720bULL, 0x004fe40003f5d000ULL,
0x000000003030783bULL, 0x000ea20000000200ULL, 0x0000000d4444723eULL, 0x000fc800000010ffULL,
0x0000003d00617306ULL, 0x000fe20000009400ULL, 0x0000007200727245ULL, 0x002fce000020d400ULL,
0x0000003d00627306ULL, 0x000e620000005400ULL, 0x0000005e5800720bULL, 0x008fe40003f7d000ULL,
0x0000003c00587245ULL, 0x000fe2000020d400ULL, 0x000100003f3c7824ULL, 0x000fc600078e00ffULL,
0x0000000158582812ULL, 0x000fe200078efcffULL, 0x0000003e00647306ULL, 0x000fe20000009400ULL,
0x00000018ff3c7819ULL, 0x000fca000001143cULL, 0x0000000172723812ULL, 0x000fe400078efcffULL,
0x0000003e00657306ULL, 0x000ee20000005400ULL, 0x000000626100720bULL, 0x002fce0003f3d000ULL,
0x0000007100737306ULL, 0x000ff00000209400ULL, 0x0000007100747306ULL, 0x0003220000205400ULL,
0x000000656400720bULL, 0x008fce0003fbd000ULL, 0x00000035005a7306ULL, 0x000fe20000209400ULL,
0x0000007100717245ULL, 0x002fce000020d400ULL, 0x0000003500507306ULL, 0x000e620000205400ULL,
0x000000747300720bULL, 0x010fce0003f5d000ULL, 0x0000004900677306ULL, 0x000fec0000209400ULL,
0x0000000171712812ULL, 0x000fe400078efcffULL, 0x0000004900517306ULL, 0x0007220000205400ULL,
0x000000505a00720bULL, 0x002fe20003f7d000ULL, 0x000001003f5a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000005d00627306ULL, 0x000fe20000209400ULL,
0x0000004900497245ULL, 0x008fce000020d400ULL, 0x0000005d00647306ULL, 0x0002e20000205400ULL,
0x000000516700720bULL, 0x010fce0003f9d000ULL, 0x00000045004a7306ULL, 0x000fe20000209400ULL,
0x0000005d005d7245ULL, 0x002fca000020d400ULL, 0x0000000149494812ULL, 0x000fe400078efcffULL,
0x00000045004c7306ULL, 0x000e620000205400ULL, 0x000000646200720bULL, 0x008fe40003f5d000ULL,
0x0000003500627245ULL, 0x000fc8000020d400ULL, 0x0000000162623812ULL, 0x000fe200078efcffULL,
0x0000005900607306ULL, 0x000fec0000209400ULL, 0x000000015d5d2812ULL, 0x000fe400078efcffULL,
0x0000005900617306ULL, 0x0007220000205400ULL, 0x0000004c4a00720bULL, 0x002fce0003f7d000ULL,
0x0000003d000e7306ULL, 0x0002a2000000d400ULL, 0x0000005900597245ULL, 0x008fce000020d400ULL,
0x0000004e005e7306ULL, 0x000fe20000209400ULL, 0x000001003e3d7824ULL, 0x002fe200078e00ffULL,
0x000000616000720bULL, 0x010fc80003f9d000ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000004e005f7306ULL, 0x0002e20000205400ULL, 0x000000010e0e1812ULL, 0x004fcc00078efcffULL,
0x0000000159594812ULL, 0x000fe200078efcffULL, 0x0000003e000f7306ULL, 0x000522000000d400ULL,
0x0000004e004e7245ULL, 0x002fce000020d400ULL, 0x0000003f00667306ULL, 0x000fe20000009400ULL,
0x000000416e3e723eULL, 0x004fe400000010ffULL, 0x0000005f5e00720bULL, 0x008fe40003f3d000ULL,
0x0000004d5741723eULL, 0x000fc600000010ffULL, 0x0000003f00637306ULL, 0x000e620000005400ULL,
0x000000010f0f5812ULL, 0x010fc600078efcffULL, 0x000000403038723cULL, 0x000fe80000041838ULL,
0x0000003f00347306ULL, 0x0004e2000000d400ULL, 0x000000014e4e1812ULL, 0x000fc800078efcffULL,
0x0000000f4e4e723eULL, 0x000fc600000010ffULL, 0x0000003c00517306ULL, 0x000fe20000209400ULL,
0x000000706f3f723eULL, 0x004fe400000010ffULL, 0x000000636600720bULL, 0x002fca0003fdd000ULL,
0x0000003e181c723cULL, 0x000b62000004181cULL, 0x0000003700487306ULL, 0x000fec0000209400ULL,
0x0000000c7218723eULL, 0x020fe400000010ffULL, 0x0000003c000c7306ULL, 0x000e620000205400ULL,
0x000000716219723eULL, 0x000fc400000010ffULL, 0x0000000b4f1a723eULL, 0x000fe400000010ffULL,
0x000000565c0b723eULL, 0x000fe400000010ffULL, 0x0000003d004f7245ULL, 0x000fe2000020d400ULL,
0x00000037004b7306ULL, 0x000ea20000205400ULL, 0x000000183010723cULL, 0x000b620000041810ULL,
0x0000000134346812ULL, 0x008fe400078efcffULL, 0x00000054551b723eULL, 0x000fc800000010ffULL,
0x0000003600467306ULL, 0x000fe20000209400ULL, 0x0000004500187245ULL, 0x020fe2000020d400ULL,
0x0000000a3020723cULL, 0x040b620000041820ULL, 0x0000000c5100720bULL, 0x002fe40003f3d000ULL,
0x0000000118183812ULL, 0x000fe400078efcffULL, 0x00000037000c7245ULL, 0x000fe2000020d400ULL,
0x0000003600477306ULL, 0x0002e20000205400ULL, 0x0000000e5d0a723eULL, 0x020fe200000010ffULL,
0x0000001a3014723cULL, 0x000f620000041814ULL, 0x00000059180b723eULL, 0x000fc400000010ffULL,
0x0000004b4800720bULL, 0x004fe40003f5d000ULL, 0x000000584945723eULL, 0x000fe200000010ffULL,
0x0000003d005b7306ULL, 0x000fe20000209400ULL, 0x0000003600367245ULL, 0x002fe2000020d400ULL,
0x0000000a3028723cULL, 0x040b6c0000041828ULL, 0x0000003d00507306ULL, 0x000e620000205400ULL,
0x000000474600720bULL, 0x008fe20003f9d000ULL, 0x000000443024723cULL, 0x000b640000041824ULL,
0x0000003c000b7245ULL, 0x020fc4000020d400ULL, 0x000000010c0c2812ULL, 0x000fe400078efcffULL,
0x000000010b0b1812ULL, 0x000fe200078efcffULL, 0x0000005a00357306ULL, 0x000fe20000209400ULL,
0x000000040900780cULL, 0x000fe40003f25270ULL, 0x000000340b34723eULL, 0x000fe400000010ffULL,
0x0000000136364812ULL, 0x000fc600078efcffULL, 0x0000005a003e7306ULL, 0x000ea20000205400ULL,
0x000000505b00720bULL, 0x002fda0003f7d000ULL, 0x000000014f4f3812ULL, 0x000fe400078efcffULL,
0x0000003e3500720bULL, 0x004fe40003fbd000ULL, 0x0000005a00357245ULL, 0x000fe4000020d400ULL,
0x0000004f0c4f723eULL, 0x000fce00000010ffULL, 0x0000004e302c723cULL, 0x000b64000004182cULL,
0x0000000135355812ULL, 0x000fc800078efcffULL, 0x000000353635723eULL, 0x000fce00000010ffULL,
0x00000034301c723cULL, 0x000b62000004181cULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe0c000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff067224ULL, 0x000fe200078e0005ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd47000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000000339397220ULL, 0x080fe20000410000ULL, 0x0000000314147220ULL, 0x080fe20000410000ULL,
0x0000000315157220ULL, 0x080fe20000410000ULL, 0x0000000320207220ULL, 0x080fe20000410000ULL,
0x0000000321217220ULL, 0x080fe20000410000ULL, 0x0000000310107220ULL, 0x080fe20000410000ULL,
0x0000000325067220ULL, 0x080fe20000410000ULL, 0x0000000328077220ULL, 0x080fe20000410000ULL,
0x0000000329087220ULL, 0x080fe20000410000ULL, 0x000000032c097220ULL, 0x0a0fe20000410000ULL,
0x0000000317307220ULL, 0x080fe20000410000ULL, 0x0000000313327220ULL, 0x080fe20000410000ULL,
0x0000000324317220ULL, 0x080fe20000410000ULL, 0x000000032b197220ULL, 0x080fe20000410000ULL,
0x0000000326137220ULL, 0x080fe20000410000ULL, 0x00000003270a7220ULL, 0x080fe20000410000ULL,
0x000000032a187220ULL, 0x080fe20000410000ULL, 0x000000032d2b7220ULL, 0x080fe20000410000ULL,
0x000000032e0b7220ULL, 0x080fe20000410000ULL, 0x000000032f177220ULL, 0x080fe20000410000ULL,
0x000000031c247220ULL, 0x080fe20000410000ULL, 0x00000003381b7220ULL, 0x080fe20000410000ULL,
0x000000033a3a7220ULL, 0x080fe20000410000ULL, 0x000000033b1a7220ULL, 0x080fe20000410000ULL,
0x0000000316167220ULL, 0x080fe20000410000ULL, 0x0000000322227220ULL, 0x080fe20000410000ULL,
0x0000000323237220ULL, 0x080fe20000410000ULL, 0x0000000311337220ULL, 0x080fe20000410000ULL,
0x0000000312127220ULL, 0x080fe20000410000ULL, 0x000000031d1d7220ULL, 0x080fe20000410000ULL,
0x000000031e1c7220ULL, 0x080fe20000410000ULL, 0x000000031f0c7220ULL, 0x000fe20000410000ULL,
0x000000ffff257224ULL, 0x000fc400078e0039ULL, 0x000000ffff267224ULL, 0x000fe400078e0014ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0015ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0020ULL,
0x000000ffff277224ULL, 0x000fe400078e0021ULL, 0x000000ffff287224ULL, 0x000fe400078e0010ULL,
0x000000ffff297224ULL, 0x000fc400078e0006ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0007ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0008ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000079067f8cULL, 0x0002a2000c80043fULL,
0x000000ffff217224ULL, 0x000fe400078e0023ULL, 0x000000ffff1e7224ULL, 0x000fe400078e001dULL,
0x000000ffff1f7224ULL, 0x000fc400078e0016ULL, 0x000000ffff237224ULL, 0x000fe400078e0012ULL,
0x000000ffff207224ULL, 0x000fe400078e003aULL, 0x000000ffff127224ULL, 0x000fe400078e000aULL,
0x000000ffff167224ULL, 0x000fe400078e000bULL, 0x000000ffff1d7224ULL, 0x000fc400078e000cULL,
0x0000000000087805ULL, 0x002fca0000015200ULL, 0x00000400790b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x006fc40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000000d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400790b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000402157824ULL, 0x000fe200078e00ffULL,
0x000000780400720cULL, 0x000fc80003f06070ULL, 0xfffffff015077812ULL, 0x000fca00078ec0ffULL,
0x0000008000147824ULL, 0x000fca00078e0207ULL, 0x00f4000014087984ULL, 0x0002a20000000c00ULL,
0x000014f000008947ULL, 0x000fea0003800000ULL, 0x00005a00000c7b06ULL, 0x000ee20000209000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fe20003f85070ULL,
0x0000010004357824ULL, 0x000fe400078e027aULL, 0x0000000202367824ULL, 0x000fca00078e00ffULL,
0x0000000636367812ULL, 0x000fca00078ec0ffULL, 0x0000000136347824ULL, 0x000fe200078e026aULL,
0x0000000c000c7308ULL, 0x008ee40000001000ULL, 0x0ffffffe0c0e7810ULL, 0x008fcc0007ffe0ffULL,
0x0000000e00077305ULL, 0x000ee4000021f000ULL, 0x000000ffff0d7224ULL, 0x008fc800078e0a07ULL,
0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL, 0x0000000d07377227ULL, 0x000fe200078e0006ULL,
0x0000007b02067211ULL, 0x000fca00078ff0ffULL, 0x0000000637077227ULL, 0x000fc800078e00ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a07ULL, 0x00005a000d0c7a24ULL, 0x000fe200078e0206ULL,
0x0000000806067810ULL, 0x000fc80007ffe0ffULL, 0x00005a000c007a0cULL, 0x000fe20003f06070ULL,
0x0000000637377227ULL, 0x000fc800078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc800078e0a37ULL,
0x00005a000d0e7a24ULL, 0x000fe200078e0206ULL, 0x0000003568067217ULL, 0x000fc60007800000ULL,
0x80005a000c0c0a10ULL, 0x000fe40007ffe0ffULL, 0x00005a000e007a0cULL, 0x000fe20003f46070ULL,
0x0000000106357824ULL, 0x000fe200078e0a35ULL, 0x00005a000c007a0cULL, 0x000fe20003f26070ULL,
0x000000016d067824ULL, 0x000fe200078e0236ULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff0c7a12ULL, 0x000fe200078e33ffULL, 0x00000001060d7824ULL, 0x040fe200078e0a35ULL,
0x000000350600720cULL, 0x000fc80003f66070ULL, 0x0000000d6c067217ULL, 0x000fe20003800000ULL,
0x00000001340d7824ULL, 0x000fe200078e0a35ULL, 0x80005a000e0e2a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005a000e007a0cULL, 0x000fe40003f06070ULL,
0x000000070c077207ULL, 0x000fe40006000000ULL, 0x00000004ff067819ULL, 0x000fc40000011606ULL,
0x000000076c527217ULL, 0x000fe40003800000ULL, 0x000000ff06077207ULL, 0x000fe40001800000ULL,
0x0000000137372810ULL, 0x000fe20007ffe0ffULL, 0x0000005277527224ULL, 0x000fe200078e02ffULL,
0x000000353400720cULL, 0x000fe40003f26070ULL, 0x0000000d6c0d7217ULL, 0x000fe20003800000ULL,
0x00000001520f7824ULL, 0x000fe200078e0207ULL, 0x0000000137370810ULL, 0x000fc40007ffe0ffULL,
0x000000ff0d497207ULL, 0x000fe20000800000ULL, 0x000000020f0e7825ULL, 0x000fe200078e0042ULL,
0x00000010363a7812ULL, 0x000fe400078efcffULL, 0x000000370c377207ULL, 0x000fe40006000000ULL,
0x0000005249117211ULL, 0x000fe200078fe0ffULL, 0x000000060e4b7981ULL, 0x000722000c1e9500ULL,
0x000000376c547217ULL, 0x000fc60003800000ULL, 0x0000000211107825ULL, 0x000fc800078e0042ULL,
0x000000016d0e7824ULL, 0x008fe200078e023aULL, 0x0000000610507981ULL, 0x000722000c1e9500ULL,
0x0000005477547224ULL, 0x000fe400078e02ffULL, 0x000000010e0f7824ULL, 0x000fe400078e0a35ULL,
0x00000001070d7824ULL, 0x000fe200078e0254ULL, 0x0000005449077211ULL, 0x000fe400078fe0ffULL,
0x0000000f6c107217ULL, 0x008fe40003800000ULL, 0x000000350e00720cULL, 0x000fc40003f26070ULL,
0x00000004ff107819ULL, 0x000fe20000011610ULL, 0x0000000207067825ULL, 0x000fe200078e0042ULL,
0x00000020363c7812ULL, 0x000fe400078efcffULL, 0x000000ff10117207ULL, 0x000fe40000800000ULL,
0x00000006064e7981ULL, 0x0046a2000c1e9500ULL, 0x000000016d447824ULL, 0x000fe400078e023cULL,
0x000000013a387824ULL, 0x000fe400078e026aULL, 0x00000001443d7824ULL, 0x000fc400078e0a35ULL,
0x0000000152077824ULL, 0x008fe400078e0211ULL, 0x00000001380f7824ULL, 0x000fe400078e0a35ULL,
0x0000000207067825ULL, 0x000fe200078e0042ULL, 0x0000003d6c3d7217ULL, 0x000fc60003800000ULL,
0x000000013c407824ULL, 0x000fe200078e026aULL, 0x0000000606397981ULL, 0x0006a2000c1e9500ULL,
0x000000020d0c7825ULL, 0x000fe200078e0042ULL, 0x000000353800720cULL, 0x000fe40003f06070ULL,
0x0000000f6c0f7217ULL, 0x000fe40003800000ULL, 0x000000354400720cULL, 0x000fe20003f26070ULL,
0x000000060c457981ULL, 0x0002a2000c1e9500ULL, 0x00000004ff3d7819ULL, 0x000fe2000001163dULL,
0x0000000140077824ULL, 0x008fe200078e0a35ULL, 0x000000ff0f377207ULL, 0x000fc40000000000ULL,
0x000000354000720cULL, 0x000fe40003f06070ULL, 0x000000076c077217ULL, 0x000fe40003800000ULL,
0x000000ff3d417207ULL, 0x000fe20000800000ULL, 0x00000001110f7824ULL, 0x000fe200078e0254ULL,
0x0000003036447812ULL, 0x000fe400078efcffULL, 0x00000052370d7211ULL, 0x042fe400078fe0ffULL,
0x0000005437117211ULL, 0x000fc400078fe0ffULL, 0x000000ff073d7207ULL, 0x000fe20000000000ULL,
0x0000000152077824ULL, 0x000fe400078e0241ULL, 0x000000016d567824ULL, 0x000fe400078e0244ULL,
0x000000020d0c7825ULL, 0x000fc800078e0042ULL, 0x000000020f0e7825ULL, 0x100fe200078e0042ULL,
0x000000060c3e7981ULL, 0x0002e6000c1e9500ULL, 0x0000000211107825ULL, 0x100fe200078e0042ULL,
0x000000060e3b7981ULL, 0x0002e6000c1e9500ULL, 0x0000000207067825ULL, 0x000fe200078e0042ULL,
0x0000000610467981ULL, 0x0002e6000c1e9500ULL, 0x0000000156477824ULL, 0x000fe200078e0a35ULL,
0x00000006063f7981ULL, 0x0002e2000c1e9500ULL, 0x00000001444a7824ULL, 0x000fe200078e026aULL,
0x000000523d0d7211ULL, 0x002fc400078fe0ffULL, 0x000000476c477217ULL, 0x000fe20003800000ULL,
0x00000001410f7824ULL, 0x000fe200078e0254ULL, 0x000000543d117211ULL, 0x000fe200078fe0ffULL,
0x000000014a077824ULL, 0x000fe200078e0a35ULL, 0x000000355600720cULL, 0x080fe40003f26070ULL,
0x00000004ff477819ULL, 0x000fe20000011647ULL, 0x000000020d0c7825ULL, 0x100fe200078e0042ULL,
0x000000354a00720cULL, 0x000fe40003f06070ULL, 0x000000076c077217ULL, 0x000fe20003800000ULL,
0x000000020f0e7825ULL, 0x100fe200078e0042ULL, 0x000000ff474d7207ULL, 0x000fe20000800000ULL,
0x000000060c487981ULL, 0x0002e4000c1e9500ULL, 0x0000000211107825ULL, 0x000fe200078e0042ULL,
0x000000ff07477207ULL, 0x000fe20000000000ULL, 0x000000060e417981ULL, 0x0002e8000c1e9500ULL,
0x00000006104c7981ULL, 0x0002e2000c1e9500ULL, 0x0000000152077824ULL, 0x000fe200078e024dULL,
0x00000052470d7211ULL, 0x002fc600078fe0ffULL, 0x0000000207067825ULL, 0x000fc800078e0042ULL,
0x000000020d0c7825ULL, 0x000fe400078e0042ULL, 0x0000000606067981ULL, 0x0002e2000c1e9500ULL,
0x00000054470f7211ULL, 0x000fc600078fe0ffULL, 0x000000060c0d7981ULL, 0x0002e2000c1e9500ULL,
0x000000014d117824ULL, 0x000fe400078e0254ULL, 0x000000020f0e7825ULL, 0x000fc800078e0042ULL,
0x0000000211107825ULL, 0x000fe400078e0042ULL, 0x000000060e0e7981ULL, 0x0002e8000c1e9500ULL,
0x0000000610117981ULL, 0x0008e2000c1e9500ULL, 0xfffffff049527812ULL, 0x000fe200078ec0ffULL,
0x00000001ff497424ULL, 0x000fc800078e00ffULL, 0x0000000135077824ULL, 0x002fe200078e0252ULL,
0x0000000836527812ULL, 0x000fc600078efcffULL, 0x00000001345a7824ULL, 0x000fe200078e0a07ULL,
0x0000000936567812ULL, 0x000fe200078efcffULL, 0x0000000152547824ULL, 0x000fc600078e026aULL,
0x0000005a495a7219ULL, 0x040fe200000006ffULL, 0x00000001560c7824ULL, 0x000fe400078e026aULL,
0x00000001545c7824ULL, 0x100fe400078e0a07ULL, 0x000000010c5e7824ULL, 0x000fe200078e0a07ULL,
0x0000001836747812ULL, 0x000fe400078efcffULL, 0x0000005c495c7219ULL, 0x040fe400000006ffULL,
0x0000005e495e7219ULL, 0x000fc400000006ffULL, 0xfffffff037377812ULL, 0x000fe400078ec0ffULL,
0xfffffff047477812ULL, 0x000fe200078ec0ffULL, 0x00000001740f7824ULL, 0x000fc800078e026aULL,
0x0000000135537824ULL, 0x000fe200078e0247ULL, 0x0000001936727812ULL, 0x040fe400078efcffULL,
0x0000001136767812ULL, 0x040fe400078efcffULL, 0x0000002136627812ULL, 0x040fe400078efcffULL,
0x0000002836607812ULL, 0x000fc600078efcffULL, 0x00000001626e7824ULL, 0x100fe400078e026aULL,
0x0000000160667824ULL, 0x000fe400078e026aULL, 0x000000014a5d7824ULL, 0x000fca00078e0a53ULL,
0x0000005d495d7219ULL, 0x000fe400000006ffULL, 0x00005410504b7816ULL, 0x010fe4000000004bULL,
0x0000000136507812ULL, 0x000fe400078efcffULL, 0x0000004b5aff7212ULL, 0x000fc6000780c0ffULL,
0x0000000150587824ULL, 0x000fe200078e026aULL, 0x000000353400720cULL, 0x000fc60000701470ULL,
0x0000000158107824ULL, 0x000fe200078e0a07ULL, 0x000000353600720cULL, 0x000fc800007a1070ULL,
0x0000001049107219ULL, 0x000fe400000006ffULL, 0x0000004b5cff7212ULL, 0x080fe4000786c0ffULL,
0x0000004b10ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004b5eff7212ULL, 0x000fe4000788c0ffULL,
0xff8000001b1b7808ULL, 0x000fe40002800000ULL, 0xfffffff03d4b7812ULL, 0x000fe200078ec0ffULL,
0x00000001353d7824ULL, 0x000fc800078e0237ULL, 0x0000000138477824ULL, 0x100fe400078e0a3dULL,
0x000000010f4f7824ULL, 0x000fe200078e0a3dULL, 0x000054104e457816ULL, 0x004fc80000000045ULL,
0x000000455aff7212ULL, 0x080fe4000784c0ffULL, 0x000000455cff7212ULL, 0x080fe400078cc0ffULL,
0x000000455eff7212ULL, 0x000fe400078ac0ffULL, 0x000000353400720cULL, 0x080fe40001741470ULL,
0x000000355400720cULL, 0x080fe400037c1470ULL, 0x000000350c00720cULL, 0x000fc40002fa1470ULL,
0x000000353600720cULL, 0x080fe40001741070ULL, 0x000000355200720cULL, 0x080fe400037c1070ULL,
0x000000355600720cULL, 0x000fe40002fa1070ULL, 0x0000004749477219ULL, 0x040fe400000006ffULL,
0x0000004f494f7219ULL, 0x000fe400000006ffULL, 0x0000004510ff7212ULL, 0x000fc4000780c0ffULL,
0x000054103e3e7816ULL, 0x008fe40000000039ULL, 0x00000029365e7812ULL, 0x000fe200078efcffULL,
0x0000000172077824ULL, 0x100fe200078e026aULL, 0x00000031365a7812ULL, 0x040fe400078efcffULL,
0x00000038364e7812ULL, 0x000fe400078efcffULL, 0x0000541046467816ULL, 0x000fe4000000003bULL,
0x0000003936107812ULL, 0x000fe200078efcffULL, 0x0000000176457824ULL, 0x000fe200078e026aULL,
0xff80000020207808ULL, 0x000fe20001000000ULL, 0x00000001354b7824ULL, 0x000fe200078e024bULL,
0xff8000001f1f7808ULL, 0x000fc40003000000ULL, 0xff80000030307808ULL, 0x000fe40002800000ULL,
0x0000003e47ff7212ULL, 0x040fe4000784c0ffULL, 0x0000004647ff7212ULL, 0x080fe400078cc0ffULL,
0x000000464fff7212ULL, 0x000fe200078ac0ffULL, 0x000000015e647824ULL, 0x100fe200078e026aULL,
0x000000355800720cULL, 0x080fe20000f21470ULL, 0x000000015a5c7824ULL, 0x100fe200078e026aULL,
0x000000355800720cULL, 0x080fe20000701470ULL, 0x000000014e707824ULL, 0x100fe200078e026aULL,
0x000000355400720cULL, 0x080fe20001f61470ULL, 0x0000000110377824ULL, 0x000fe200078e026aULL,
0x000000350c00720cULL, 0x080fe20002781470ULL, 0x0000000107517824ULL, 0x100fe200078e0a3dULL,
0x000000353800720cULL, 0x0c0fe20001741470ULL, 0x00000001454d7824ULL, 0x000fe200078e0a3dULL,
0x000000353800720cULL, 0x080fe200037c1470ULL, 0x0000000140557824ULL, 0x100fe200078e0a4bULL,
0x000000350f00720cULL, 0x000fe20002fa1470ULL, 0x000000016e577824ULL, 0x000fc400078e0a4bULL,
0x0000000166597824ULL, 0x100fe400078e0a4bULL, 0x00000001645b7824ULL, 0x000fe200078e0a4bULL,
0x000000355000720cULL, 0x080fe20000f21070ULL, 0x000000015c5f7824ULL, 0x100fe200078e0a53ULL,
0x000000355000720cULL, 0x080fe20000701070ULL, 0x00000001703d7824ULL, 0x100fe200078e0a53ULL,
0x000000355200720cULL, 0x000fe20001f61070ULL, 0x00000001374b7824ULL, 0x000fe200078e0a53ULL,
0x0000005149537219ULL, 0x000fe400000006ffULL, 0x000000355600720cULL, 0x000fc40002781070ULL,
0x000000353a00720cULL, 0x0c0fe40001741070ULL, 0x000000353a00720cULL, 0x080fe400037c1070ULL,
0x000000357400720cULL, 0x000fe40002fa1070ULL, 0x0000004d494d7219ULL, 0x040fe400000006ffULL,
0x0000005549517219ULL, 0x000fe400000006ffULL, 0x0000541048487816ULL, 0x000fc4000000003fULL,
0x000054104c4c7816ULL, 0x000fe40000000041ULL, 0xff80000025257808ULL, 0x000fe40000800000ULL,
0xff8000001a1a7808ULL, 0x000fe40000000000ULL, 0xff80000026267808ULL, 0x000fe40001800000ULL,
0xff8000002f2f7808ULL, 0x000fe40002000000ULL, 0xff8000002c2c7808ULL, 0x000fc40001000000ULL,
0xff80000022227808ULL, 0x000fe40003000000ULL, 0xff80000023237808ULL, 0x000fe40002800000ULL,
0x0000003e4dff7212ULL, 0x080fe4000782c0ffULL, 0x0000003e4fff7212ULL, 0x080fe4000780c0ffULL,
0x0000003e53ff7212ULL, 0x000fe4000786c0ffULL, 0x000000464dff7212ULL, 0x000fc4000788c0ffULL,
0x0000004653ff7212ULL, 0x000fe4000784c0ffULL, 0x0000004851ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004c51ff7212ULL, 0x000fe400078ac0ffULL, 0x000000354500720cULL, 0x0c0fe40000f21470ULL,
0x000000354500720cULL, 0x080fe40002781470ULL, 0x000000350f00720cULL, 0x000fc40000701470ULL,
0x000000350700720cULL, 0x0c0fe40001f61470ULL, 0x000000350700720cULL, 0x080fe40001741470ULL,
0x000000354000720cULL, 0x0c0fe400037c1470ULL, 0x000000354000720cULL, 0x080fe40002fa1470ULL,
0x000000357600720cULL, 0x0c0fe40000f21070ULL, 0x000000357600720cULL, 0x000fc40002781070ULL,
0x000000357400720cULL, 0x080fe40000701070ULL, 0x000000357200720cULL, 0x0c0fe40001f61070ULL,
0x000000357200720cULL, 0x080fe40001741070ULL, 0x000000353c00720cULL, 0x0c0fe400037c1070ULL,
0x000000353c00720cULL, 0x000fe40002fa1070ULL, 0x0000005749577219ULL, 0x000fc400000006ffULL,
0x0000005949597219ULL, 0x040fe400000006ffULL, 0x0000005b495b7219ULL, 0x000fe400000006ffULL,
0x000054100d067816ULL, 0x000fe40000000006ULL, 0xff80000027277808ULL, 0x000fe40000800000ULL,
0xff80000021217808ULL, 0x000fe40002000000ULL, 0xff80000028287808ULL, 0x000fc40000000000ULL,
0xff80000033337808ULL, 0x000fe40001800000ULL, 0xff80000032327808ULL, 0x000fe40001000000ULL,
0xff80000031317808ULL, 0x000fe40003000000ULL, 0xff80000013137808ULL, 0x000fe40002800000ULL,
0x0000004857ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004859ff7212ULL, 0x000fc4000788c0ffULL,
0x000000485bff7212ULL, 0x000fe4000780c0ffULL, 0x0000004c57ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004c59ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004c5bff7212ULL, 0x000fe400078cc0ffULL,
0x000000065dff7212ULL, 0x000fe400078ac0ffULL, 0x000000356e00720cULL, 0x000fc40000f21470ULL,
0x000000356e00720cULL, 0x080fe40001f61470ULL, 0x000000356600720cULL, 0x0c0fe40002781470ULL,
0x000000356600720cULL, 0x080fe40001741470ULL, 0x000000356400720cULL, 0x0c0fe40000701470ULL,
0x000000356400720cULL, 0x080fe400037c1470ULL, 0x000000354a00720cULL, 0x000fc40002fa1470ULL,
0x000000356200720cULL, 0x0c0fe40000f21070ULL, 0x000000356200720cULL, 0x080fe40001f61070ULL,
0x000000356000720cULL, 0x0c0fe40002781070ULL, 0x000000356000720cULL, 0x080fe40001741070ULL,
0x000000355e00720cULL, 0x0c0fe40000701070ULL, 0x000000355e00720cULL, 0x000fc400037c1070ULL,
0x000000354400720cULL, 0x000fe40002fa1070ULL, 0x0000005f495f7219ULL, 0x040fe400000006ffULL,
0x0000003d493d7219ULL, 0x040fe400000006ffULL, 0x0000004b494b7219ULL, 0x000fe400000006ffULL,
0x000054100e0e7816ULL, 0x000fe40000000011ULL, 0xff80000029297808ULL, 0x000fc40000800000ULL,
0xff80000012127808ULL, 0x000fe40001800000ULL, 0xff8000002a2a7808ULL, 0x000fe40002000000ULL,
0xff80000018187808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40000000000ULL,
0xff80000019197808ULL, 0x000fe40003000000ULL, 0xff8000002d2d7808ULL, 0x000fc40002800000ULL,
0x000000065fff7212ULL, 0x080fe4000782c0ffULL, 0x000000063dff7212ULL, 0x080fe4000786c0ffULL,
0x000000064bff7212ULL, 0x000fe4000788c0ffULL, 0x0000000e5dff7212ULL, 0x080fe4000784c0ffULL,
0x0000000e5fff7212ULL, 0x080fe4000780c0ffULL, 0x0000000e3dff7212ULL, 0x000fc400078cc0ffULL,
0x0000000e4bff7212ULL, 0x000fe400078ac0ffULL, 0x000000354a00720cULL, 0x080fe40001741470ULL,
0x000000355c00720cULL, 0x0c0fe40000f21470ULL, 0x000000355c00720cULL, 0x080fe40000701470ULL,
0x000000357000720cULL, 0x0c0fe40001f61470ULL, 0x000000357000720cULL, 0x000fc400037c1470ULL,
0x000000353700720cULL, 0x0c0fe40002781470ULL, 0x000000353700720cULL, 0x080fe40002fa1470ULL,
0x000000354400720cULL, 0x080fe40001741070ULL, 0x000000355a00720cULL, 0x0c0fe40000f21070ULL,
0x000000355a00720cULL, 0x080fe40000701070ULL, 0x000000354e00720cULL, 0x000fc40001f61070ULL,
0x000000354e00720cULL, 0x080fe400037c1070ULL, 0x000000351000720cULL, 0x0c0fe40002781070ULL,
0x000000351000720cULL, 0x000fe40002fa1070ULL, 0xff8000002b2b7808ULL, 0x000fe40000800000ULL,
0xff80000024247808ULL, 0x000fe40001800000ULL, 0xff8000001e1e7808ULL, 0x000fc40002000000ULL,
0xff80000016167808ULL, 0x000fe40001000000ULL, 0xff80000017177808ULL, 0x000fe40000000000ULL,
0xff8000001c1c7808ULL, 0x000fe40003000000ULL, 0xff8000001d1d7808ULL, 0x000fc40002800000ULL,
0x0000001b0800720bULL, 0x004fe20003f1e000ULL, 0x0000001fff117424ULL, 0x000fe200078e00ffULL,
0x000000200900720bULL, 0x000fe20003f3e000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x000000081b087208ULL, 0x000fc40004000000ULL, 0x0000000920097208ULL, 0x000fe40004800000ULL,
0x000000250800720bULL, 0x000fe40003f1e000ULL, 0x0000001a0900720bULL, 0x000fe40003f3e000ULL,
0x0000000825077208ULL, 0x000fe40004000000ULL, 0x000000091a067208ULL, 0x000fe40004800000ULL,
0x000000260700720bULL, 0x000fc40003f1e000ULL, 0x0000001f0600720bULL, 0x000fe40003f3e000ULL,
0x0000000726087208ULL, 0x000fe40004000000ULL, 0x000000061f077208ULL, 0x000fe40004800000ULL,
0x0000002f0800720bULL, 0x000fe40003f1e000ULL, 0x000000300700720bULL, 0x000fe40003f3e000ULL,
0x000000082f097208ULL, 0x000fc40004000000ULL, 0x0000000730077208ULL, 0x000fe40004800000ULL,
0x0000002c0900720bULL, 0x000fe40003f1e000ULL, 0x000000220700720bULL, 0x000fe40003f3e000ULL,
0x000000092c067208ULL, 0x000fe40004000000ULL, 0x0000000722087208ULL, 0x000fe40004800000ULL,
0x000000270600720bULL, 0x000fc40003f1e000ULL, 0x000000210800720bULL, 0x000fe40003f3e000ULL,
0x0000000627077208ULL, 0x000fe40004000000ULL, 0x0000000821087208ULL, 0x000fe40004800000ULL,
0x000000280700720bULL, 0x000fe40003f1e000ULL, 0x000000230800720bULL, 0x000fe40003f3e000ULL,
0x0000000728067208ULL, 0x000fc40004000000ULL, 0x0000000823077208ULL, 0x000fe40004800000ULL,
0x000000330600720bULL, 0x000fe40003f1e000ULL, 0x000000320700720bULL, 0x000fe40003f3e000ULL,
0x0000000633067208ULL, 0x000fe40004000000ULL, 0x0000000732087208ULL, 0x000fe40004800000ULL,
0x000000310600720bULL, 0x000fc40003f1e000ULL, 0x000000130800720bULL, 0x000fe40003f3e000ULL,
0x0000000631067208ULL, 0x000fe40004000000ULL, 0x0000000813077208ULL, 0x000fe40004800000ULL,
0x000000290600720bULL, 0x000fe40003f1e000ULL, 0x000000120700720bULL, 0x000fe40003f3e000ULL,
0x0000000629097208ULL, 0x000fc40004000000ULL, 0x0000000712077208ULL, 0x000fe40004800000ULL,
0x0000002a0900720bULL, 0x000fe40003f1e000ULL, 0x000000180700720bULL, 0x000fe40003f3e000ULL,
0x000000092a097208ULL, 0x000fe40004000000ULL, 0x0000000718067208ULL, 0x000fe40004800000ULL,
0x0000002e0900720bULL, 0x000fc40003f1e000ULL, 0x000000190600720bULL, 0x000fe40003f3e000ULL,
0x000000092e087208ULL, 0x000fe40004000000ULL, 0x0000000619077208ULL, 0x000fe40004800000ULL,
0x0000002d0800720bULL, 0x000fe40003f1e000ULL, 0x000000160700720bULL, 0x000fe40003f3e000ULL,
0x000000082d087208ULL, 0x000fc40004000000ULL, 0x0000000716067208ULL, 0x000fe40004800000ULL,
0x0000002b0800720bULL, 0x000fe40003f1e000ULL, 0x000000170600720bULL, 0x000fe40003f3e000ULL,
0x000000082b077208ULL, 0x000fe40004000000ULL, 0x0000000617097208ULL, 0x000fe40004800000ULL,
0x000000240700720bULL, 0x000fc40003f1e000ULL, 0x0000001c0900720bULL, 0x000fe40003f3e000ULL,
0x0000000724077208ULL, 0x000fe40004000000ULL, 0x000000091c067208ULL, 0x000fe40004800000ULL,
0x0000001e0700720bULL, 0x000fe40003f1e000ULL, 0x0000001d0600720bULL, 0x000fe40003f3e000ULL,
0x000000071e0e7208ULL, 0x000fc40004000000ULL, 0x000000061d107208ULL, 0x000fe20004800000ULL,
0x000014827f007947ULL, 0x000fec000b800000ULL, 0x0c401f000e067f89ULL, 0x0004e400000e0000ULL,
0x000000060e00720bULL, 0x008fc80003f1e000ULL, 0x0000000e06347208ULL, 0x000fe20004000000ULL,
0x000014927f007947ULL, 0x000fea000b800000ULL, 0x0c401f0010067f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a077f89ULL, 0x000f2800000e0000ULL, 0x0c401f000b087f89ULL, 0x000e6800000e0000ULL,
0x0c201f0034097f89ULL, 0x000ea200000e0000ULL, 0x000000061000720bULL, 0x008fc40003f1e000ULL,
0x000000070a00720bULL, 0x010fe40003f3e000ULL, 0x00000010060c7208ULL, 0x000fe40004000000ULL,
0x0000000a070d7208ULL, 0x000fe40004800000ULL, 0x000000080b00720bULL, 0x002fe20003f1e000ULL,
0x0c201f000c0f7f89ULL, 0x000e6600000e0000ULL, 0x0000000b08067208ULL, 0x000fe20004000000ULL,
0x0c201f000d0e7f89ULL, 0x004ea200000e0000ULL, 0x000000093400720bULL, 0x000fc60003f1e000ULL,
0x0c201f0006077f89ULL, 0x0006e200000e0000ULL, 0x0000003409087208ULL, 0x000fe40004000000ULL,
0x0000000f0c00720bULL, 0x002fe40003f3e000ULL, 0x0000000e0d00720bULL, 0x004fe40003f5e000ULL,
0x0000000c0f097208ULL, 0x000fe40004800000ULL, 0x0000000d0e0a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b08347820ULL, 0x008fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000302ff7812ULL, 0x000fc4000780c0ffULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010834ULL, 0x00000026000e7308ULL, 0x0023e20000000800ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b280b7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b31287823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010834ULL, 0x0000001b000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2b267823ULL, 0x102fe20000010834ULL, 0x3fb8aa3b092b7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b1e1e7823ULL, 0x000fe20000010834ULL,
0x000000070600720bULL, 0x004fe20003f3e000ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082bULL, 0x0000002500257308ULL, 0x000e620000000800ULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b17177823ULL, 0x000fc4000001082bULL,
0x0000002f002f7308ULL, 0x000eb00000000800ULL, 0x00000020000d7308ULL, 0x0007e20000000800ULL,
0x0000000c250c723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000e620000000800ULL,
0x0000000e2f0e723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b12207823ULL, 0x008fcc000001082bULL,
0x0000001f000f7308ULL, 0x0005f00000000800ULL, 0x0000003000307308ULL, 0x000ee20000000800ULL,
0x0000000d1a0d723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b131f7823ULL, 0x004fcc000001082bULL,
0x0000002700357308ULL, 0x0003e20000000800ULL, 0x0000000f300f723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b24277823ULL, 0x002fe20000010834ULL, 0x00000004ff247e24ULL, 0x000fca000f8e00ffULL,
0x0000000b001b7308ULL, 0x0003e20000000800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3f8000002424783eULL, 0x000fcc00000010ffULL, 0x0000003300367308ULL, 0x0004e20000000800ULL,
0x000000ffff257224ULL, 0x000fe200078e0024ULL, 0x3fb8aa3b2d0b7823ULL, 0x002fe20000010834ULL,
0x3fb8aa3b192d7823ULL, 0x000fe2000001082bULL, 0x000000ffff387224ULL, 0x000fc800078e0024ULL,
0x0000002300237308ULL, 0x000fe20000000800ULL, 0x000000240c10723cULL, 0x000b6200000418ffULL,
0x000000ffff337224ULL, 0x004fcc00078e0024ULL, 0x0000003200327308ULL, 0x000e620000000800ULL,
0x0000001b361a723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b18257823ULL, 0x020fcc000001082bULL,
0x0000002c002c7308ULL, 0x000eb00000000800ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x00000023321b723eULL, 0x002fe200000010ffULL, 0x000000ffff327224ULL, 0x000fcc00078e0024ULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x0000002c3518723eULL, 0x004fce00000010ffULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x000000222119723eULL, 0x002fce00000010ffULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1c217823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b1d2b7823ULL, 0x000fe2000001082bULL, 0x000000321810723cULL, 0x000f6a0000041810ULL,
0x0000002800287308ULL, 0x000ff00000000800ULL, 0x0000002900297308ULL, 0x000ea20000000800ULL,
0x0000001f201d723eULL, 0x002fce00000010ffULL, 0x0000002a002a7308ULL, 0x000ff00000000800ULL,
0x0000002e00317308ULL, 0x0003e20000000800ULL, 0x00000028291c723eULL, 0x004fce00000010ffULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x00000002ff2e7819ULL, 0x002fc80000011602ULL,
0x000000012e237810ULL, 0x040fe20007ffe0ffULL, 0x000000082e307824ULL, 0x040fe200078e00ffULL,
0x000000042e287810ULL, 0x040fe20007ffe0ffULL, 0x0000002d002c7308ULL, 0x0002a20000000800ULL,
0x000000082e297824ULL, 0x040fe200078e00ffULL, 0x000000022e207810ULL, 0x040fe20007ffe0ffULL,
0x000000082e357824ULL, 0x000fc600078e00ffULL, 0xfffffff829297812ULL, 0x000fe400078ee220ULL,
0x0000001e00227308ULL, 0x0007e20000000800ULL, 0xfffffff8302d7812ULL, 0x002fe400078ee223ULL,
0x000000052e207810ULL, 0x000fe40007ffe0ffULL, 0x000000252c1f723eULL, 0x004fc600000010ffULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x0000002a311e723eULL, 0x008fe200000010ffULL,
0x000000082e317824ULL, 0x040fe200078e00ffULL, 0x000000032e257810ULL, 0x040fe20007ffe0ffULL,
0x000000082e2a7824ULL, 0x040fe200078e00ffULL, 0x000000082e2c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff831317812ULL, 0x000fe200078ee228ULL, 0x000000321c10723cULL, 0x020b620000041810ULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0xfffffff82a2f7812ULL, 0x000fe200078ee225ULL,
0x000000082e257824ULL, 0x040fe200078e00ffULL, 0x000000062e2a7810ULL, 0x000fe20007ffe0ffULL,
0x000000082c397824ULL, 0x000fc400078e00ffULL, 0x000000082e337824ULL, 0x020fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee22eULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0xfffffff835357812ULL, 0x000fe400078ee22aULL, 0xfffffff833337812ULL, 0x000fca00078ee220ULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x0000000b2620723eULL, 0x002fe400000010ffULL,
0x0000900000267811ULL, 0x000fe400078e58ffULL, 0x00000006070b7208ULL, 0x000fc60004800000ULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000272222723eULL, 0x004fe200000010ffULL,
0x0000001025257824ULL, 0x100fe400078e0226ULL, 0x000000102d2d7824ULL, 0x100fe400078e0226ULL,
0x0000001029297824ULL, 0x100fe400078e0226ULL, 0x0000002100237308ULL, 0x0005e20000000800ULL,
0x000000102f2f7824ULL, 0x100fe400078e0226ULL, 0x0000001031317824ULL, 0x000fc400078e0226ULL,
0x0000001033337824ULL, 0x100fe400078e0226ULL, 0x0000001035357824ULL, 0x000fe200078e0226ULL,
0x0000002b00287308ULL, 0x0007220000000800ULL, 0xffffffff2e217810ULL, 0x044fe20007ffe0ffULL,
0x000000082e2e7824ULL, 0x000fca00078e00ffULL, 0xfffffff82e377812ULL, 0x000fe400078ee221ULL,
0xfffffff8392b7812ULL, 0x008fe200078ee22cULL, 0x000000ffff397224ULL, 0x000fe200078e0024ULL,
0x000000161721723eULL, 0x002fe200000010ffULL, 0x0000001037377824ULL, 0x100fe200078e0226ULL,
0x0000000c15167812ULL, 0x000fe200078ec0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0226ULL,
0x000000232823723eULL, 0x010fc600000010ffULL, 0x0000000125257824ULL, 0x000fe400078e0216ULL,
0x00000001162d7824ULL, 0x040fe400078e022dULL, 0x0000000116297824ULL, 0x040fe200078e0229ULL,
0x000000382010723cULL, 0x000f620000041810ULL, 0x00000001162f7824ULL, 0x040fe200078e022fULL,
0x0000000c25007388ULL, 0x0003e20000000800ULL, 0x0000000116317824ULL, 0x040fe400078e0231ULL,
0x0000000116337824ULL, 0x040fe200078e0233ULL, 0x0000000e2d007388ULL, 0x0003e20000000800ULL,
0x0000000116357824ULL, 0x000fc400078e0235ULL, 0x0000000116377824ULL, 0x040fe200078e0237ULL,
0x0000001829007388ULL, 0x0003e20000000800ULL, 0x0000000116167824ULL, 0x000fc600078e022bULL,
0x0000001a2f007388ULL, 0x0003e80000000800ULL, 0x0000001c31007388ULL, 0x0003e80000000800ULL,
0x0000001e33007388ULL, 0x0003e40000000800ULL, 0x000000ffff117224ULL, 0x020fc400078e0012ULL,
0x0000002035007388ULL, 0x0003e80000000800ULL, 0x0000002237007388ULL, 0x0003e80000000800ULL,
0x0000000d16007388ULL, 0x0003e80000000800ULL, 0x0004000f2d007388ULL, 0x0003e80000000800ULL,
0x0004001929007388ULL, 0x0003e80000000800ULL, 0x0004001b2f007388ULL, 0x0003e80000000800ULL,
0x0004001d31007388ULL, 0x0003e80000000800ULL, 0x0004001f33007388ULL, 0x0003e80000000800ULL,
0x0004002135007388ULL, 0x0003e80000000800ULL, 0x0004002337007388ULL, 0x0003e80000000800ULL,
0x00f0000814008388ULL, 0x0003e80000000c00ULL, 0x00f2001014008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000007cff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008007cff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010007cff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000104047810ULL, 0x000fe20007ffe0ffULL,
0x000018007cff7f8cULL, 0x0003e6000c80043fULL, 0x000000690400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffa69000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff107807ULL, 0x008fe40004000000ULL,
0x00016e2000117802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x002fea0003c00000ULL,
0xfffeb81000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40005000000ULL,
0x00016e6000117802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e003cULL, 0xfffeb87000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0021ULL, 0x00016eb0003d7802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x002fea0003c00000ULL, 0xfffeb95000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0021ULL, 0x00016ef0003d7802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x002fea0003c00000ULL, 0xfffeba7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000bULL, 0x00016f40003d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e000aULL, 0x00000a5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003cULL, 0xfffebe7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000bULL, 0x00016f90003d7802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xfffebe5000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x008fe40004000000ULL,
0x00016fe000117802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x002fea0003c00000ULL,
0xfffeec0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40005000000ULL,
0x0001702000117802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff377224ULL, 0x000fe200078e003cULL, 0xfffeec5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000cULL, 0x00017070003d7802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x002fea0003c00000ULL, 0xfffeed3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000cULL, 0x000170b0003d7802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x002fea0003c00000ULL, 0xfffeee5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000cULL, 0x00017100003d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e000fULL, 0x0000089000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003cULL, 0xfffef26000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000cULL, 0x00017150003d7802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xfffef24000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x008fe40004000000ULL,
0x000171a000117802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x002fea0003c00000ULL,
0xffff1fb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40005000000ULL,
0x000171e000117802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff067224ULL, 0x000fe200078e003cULL, 0xffff200000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e003aULL, 0x00017230003d7802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x002fea0003c00000ULL, 0xffff20f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e003aULL, 0x00017270003d7802ULL, 0x000fc40000000f00ULL,
0x0000072000007944ULL, 0x002fea0003c00000ULL, 0xffff221000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000dULL, 0x000172c0003d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e000eULL, 0x000006d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003cULL, 0xffff263000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e000dULL, 0x00017310003d7802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xffff261000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x004fe40004000000ULL,
0x0001736000117802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x008fea0003c00000ULL,
0xffff52c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40005000000ULL,
0x000173a000117802ULL, 0x000fc40000000f00ULL, 0x0000064000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff337224ULL, 0x000fe200078e003cULL, 0xffff531000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0035ULL, 0x000173f0003d7802ULL, 0x000fc40000000f00ULL,
0x000005a000007944ULL, 0x008fea0003c00000ULL, 0xffff53f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0035ULL, 0x00017430003d7802ULL, 0x000fc40000000f00ULL,
0x0000056000007944ULL, 0x008fea0003c00000ULL, 0xffff551000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0006ULL, 0x00017480003d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0013ULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e003cULL, 0xffff596000007947ULL, 0x000fea000383ffffULL,
0x000000ffff117224ULL, 0x000fe200078e0006ULL, 0x000174d0003d7802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e003cULL,
0xffff594000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x00017520000c7802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0007ULL, 0xffffeb4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x006fe200078e0010ULL, 0x00017580000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x000175e0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007107208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000bULL,
0x00017640000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000070b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0034ULL,
0x000176a0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000b07067208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000073400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0010ULL,
0x00017700000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000003407087208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00017760000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007097208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0006ULL,
0x000177c0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffea1000007947ULL, 0x000fea000383ffffULL, 0x0180000031007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000003100008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff31ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000031027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003100007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe86b002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0c00000f0e077389ULL, 0x0002a200000e0011ULL,
0xfffe86700c007950ULL, 0x000fea0003c3ffffULL, 0x0000007600007348ULL, 0x000fe80003800000ULL,
0x00000010113c7389ULL, 0x0002a400000e0077ULL, 0x000000ffff107224ULL, 0x002fc400078e003dULL,
0x00000000ff117424ULL, 0x000fc800078e00ffULL, 0xfffe862010007950ULL, 0x000fea0003c3ffffULL,
0x000000011000780cULL, 0x000fe20003f45070ULL, 0x000000ffff107224ULL, 0x000fe200078e0011ULL,
0x0000007400007348ULL, 0x000fe80003800000ULL, 0x00000000ff117424ULL, 0x000fce00078e00ffULL,
0x00000000003c7806ULL, 0x000fc800050e0100ULL, 0x000000743c3c7212ULL, 0x000fe200078ec0ffULL,
0xfffe85b010007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x0000000000000310ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d08ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dc8ULL, 0x00000000000007ccULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001598ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015a8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001638ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000000163cULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000017b00ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019300ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019350ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000196d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001638ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000017cc8ULL, 0x0000000000017cc8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000019300ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000196d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_89_cubin_len = 104368;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
