/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b450ULL, 0x000000000001b0d0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x00000000000194f0ULL, 0x0000000000000180ULL, 0x000b0022000004daULL, 0x0000000000019670ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x00000000000196b0ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x0000000000019700ULL, 0x0000000000000100ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000019800ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000194f000000000ULL, 0x0000040400000000ULL, 0x810c000000100400ULL, 0x0065200410288080ULL,
0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8b08288080820828ULL,
0x2880808c08288080ULL, 0x8091082880809008ULL, 0x0828808093082880ULL, 0x8080960828808094ULL,
0xb808288080ad0828ULL, 0x288080b908288080ULL, 0x8280162880808408ULL, 0x0000000003102880ULL,
0x8080849200000000ULL, 0x0000000000220028ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x000194f000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808084ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880808a08288080ULL, 0x808c082880808b08ULL, 0x0828808090082880ULL,
0x8080940828808091ULL, 0xad08288080960828ULL, 0x288080b808288080ULL, 0x808808288080b908ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080889200ULL, 0x0000001cffffffffULL,
0x0000013800000000ULL, 0x0001967000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808b08288080ULL,
0x8090082880808c08ULL, 0x0828808091082880ULL, 0x8080940828808093ULL, 0xad08288080960828ULL,
0x288080b808288080ULL, 0x828016288080b908ULL, 0x0000000003102880ULL, 0x8080b99200000000ULL,
0x0000000000220028ULL, 0x0000002cffffffffULL, 0x000001e800000000ULL, 0x000196b000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x80b8288080b90900ULL, 0x0000000000002880ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808b08288080ULL,
0x8090082880808c08ULL, 0x0828808091082880ULL, 0x8080960828808094ULL, 0xb908288080ad0828ULL,
0x288080b808288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080b8ULL,
0x0000001cffffffffULL, 0x000002a800000000ULL, 0x0001970000000000ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x0008230400000080ULL, 0x0000000000000017ULL,
0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL,
0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL, 0x0008110400000010ULL,
0x000000100000001bULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0060016000000018ULL,
0x000c170400601903ULL, 0x0058000a00000000ULL, 0x000c17040021f000ULL, 0x0050000900000000ULL,
0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL,
0x000c17040061f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0x00000bb000043104ULL,
0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000030001342804ULL,
0x00000610000003e0ULL, 0x0000270000002670ULL, 0x0000298000002820ULL, 0x00002e1000002de0ULL,
0x00002ef000002e80ULL, 0x00005cf000005c50ULL, 0x00005f7000005e10ULL, 0x00006410000063e0ULL,
0x000064f000006480ULL, 0x000092a000009210ULL, 0x00009530000093d0ULL, 0x000099e0000099b0ULL,
0x00009ac000009a50ULL, 0x0000c7b00000c710ULL, 0x0000ca300000c8d0ULL, 0x0000cf100000cee0ULL,
0x0000cff00000cf80ULL, 0x0000f0e00000f0d0ULL, 0x00017a30000179f0ULL, 0x00017a5000017a40ULL,
0x00017ac000017aa0ULL, 0x00017af000017ae0ULL, 0x00018810000187c0ULL, 0x000188e000018880ULL,
0x000189c000018950ULL, 0x00018a7000018a20ULL, 0x00018b4000018ae0ULL, 0x00018c2000018bb0ULL,
0x00018cd000018c80ULL, 0x00018da000018d40ULL, 0x00018e8000018e10ULL, 0x00018f3000018ee0ULL,
0x0001900000018fa0ULL, 0x000190e000019070ULL, 0x000191d000019150ULL, 0x000192d000019250ULL,
0x000193d000019350ULL, 0x000194d000019450ULL, 0x0000044004403904ULL, 0x00017600000000ffULL,
0x00000480003f0100ULL, 0x0001760800000011ULL, 0x00000520003f0120ULL, 0x0001768800000011ULL,
0x000005d0003f0120ULL, 0x000176a800000011ULL, 0x00000600003f0120ULL, 0x000176c800000011ULL,
0x00000bd0003f0120ULL, 0x00017600000000ffULL, 0x00000d20003f0107ULL, 0x0001768c00000011ULL,
0x00000db0003f0102ULL, 0x0001768800000011ULL, 0x000015e0003f0101ULL, 0x00000000000000ffULL,
0x0000166000040107ULL, 0x00000000000000ffULL, 0x000016c000040101ULL, 0x0000002000000004ULL,
0x00001820003f0101ULL, 0x000176cc00000006ULL, 0x000019f0003f0105ULL, 0x000176cc00000006ULL,
0x00002240003f0105ULL, 0x000176b000000005ULL, 0x000022e0003f0107ULL, 0x000176b000000005ULL,
0x00002340003f0101ULL, 0x000176080000001aULL, 0x00002380003f0101ULL, 0x0001760c0000000eULL,
0x00002560003f0105ULL, 0x0001760c0000000eULL, 0x00002b40003f0105ULL, 0x000176ac0000001bULL,
0x00002d10003f0105ULL, 0x000176ac0000001bULL, 0x00004ec0003f0105ULL, 0x0000000000000038ULL,
0x00004f20003f0101ULL, 0x0001768800000006ULL, 0x00004f50003f0101ULL, 0x0000000400000010ULL,
0x00005110003f0105ULL, 0x0000000400000010ULL, 0x00005860003f0105ULL, 0x00000000000000ffULL,
0x0000593000040107ULL, 0x00000000000000ffULL, 0x0000599000040101ULL, 0x0001762800000006ULL,
0x000059b0003f0101ULL, 0x0001762c0000000eULL, 0x00005b80003f0105ULL, 0x0001762c0000000eULL,
0x00006140003f0105ULL, 0x000176b40000003aULL, 0x00006310003f0105ULL, 0x000176b40000003aULL,
0x00008470003f0105ULL, 0x0000000000000012ULL, 0x000084d0003f0101ULL, 0x000176900000006fULL,
0x00008500003f0101ULL, 0x0000000400000010ULL, 0x000086c0003f0105ULL, 0x0000000400000010ULL,
0x00008e20003f0105ULL, 0x00000008000000ffULL, 0x00008eb000040107ULL, 0x000176b000000040ULL,
0x00008f10003f0101ULL, 0x000176480000000eULL, 0x00008f70003f0101ULL, 0x0001764c0000000eULL,
0x00009140003f0105ULL, 0x0001764c0000000eULL, 0x00009710003f0105ULL, 0x000176ac0000001bULL,
0x000098e0003f0105ULL, 0x000176ac0000001bULL, 0x0000b940003f0105ULL, 0x0000000000000010ULL,
0x0000b9a0003f0101ULL, 0x0000000000000003ULL, 0x0000b9d0003f0101ULL, 0x0000000400000010ULL,
0x0000bb90003f0105ULL, 0x0000000400000010ULL, 0x0000c330003f0105ULL, 0x00000000000000ffULL,
0x0000c40000040107ULL, 0x00000000000000ffULL, 0x0000c46000040101ULL, 0x0001766800000003ULL,
0x0000c490003f0101ULL, 0x0001766c00000003ULL, 0x0000c660003f0105ULL, 0x0001766c00000003ULL,
0x0000cc00003f0105ULL, 0x000176b400000008ULL, 0x0000ce00003f0105ULL, 0x000176b400000008ULL,
0x0000eea0003f0105ULL, 0x0000000000000010ULL, 0x0000ef20003f0101ULL, 0x0000000000000006ULL,
0x00010300003f0101ULL, 0x00017600000000ffULL, 0x00011b30003f0101ULL, 0x00017604000000ffULL,
0x00011d40003f0105ULL, 0x00017604000000ffULL, 0x00011f70003f0105ULL, 0x00017600000000ffULL,
0x00011fa0003f0101ULL, 0x00017604000000ffULL, 0x00012160003f0105ULL, 0x00017604000000ffULL,
0x00015de0003f0105ULL, 0x0000000000000079ULL, 0x00015e70003f0101ULL, 0x0000000400000079ULL,
0x00016040003f0105ULL, 0x0000000400000079ULL, 0x00018600003f0105ULL, 0x000000000000007bULL,
0x00018660003f0101ULL, 0x000000080000007bULL, 0x000186c0003f0101ULL, 0x000000100000007bULL,
0x00018730003f0101ULL, 0x000000180000007bULL, 0x00053803003f0101ULL, 0x0000f9a000201c04ULL,
0x0000fc900000f9e0ULL, 0x000100800000fe80ULL, 0x000121c000010230ULL, 0x0000040100018780ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000033cULL, 0x0000001b00000002ULL, 0x0000000000000284ULL,
0x0000001b00000002ULL, 0x00000000000001d4ULL, 0x0000001b00000002ULL, 0x000000000000010cULL,
0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL, 0x0000000000000317ULL,
0x0000001b00000002ULL, 0x000000000000025cULL, 0x0000001b00000002ULL, 0x00000000000001b1ULL,
0x0000001b00000002ULL, 0x00000000000000e4ULL, 0x0000001b00000002ULL, 0x0000000000017700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000097919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fe20000000a00ULL,
0xfffffff001017810ULL, 0x000fe40007ffe0ffULL, 0x00005d00ff007a0cULL, 0x000fda0003f05300ULL,
0x00000004ff060424ULL, 0x000fe200078e00ffULL, 0x0000000109020810ULL, 0x002fca0007ffe0ffULL,
0x00005c0002020625ULL, 0x000fc800078e0006ULL, 0x00005c0009060625ULL, 0x000fe200078e0006ULL,
0x00000006020d0981ULL, 0x0002aa000c1e1900ULL, 0x0000000606060981ULL, 0x0006a2000c1e1900ULL,
0x0000590000007b06ULL, 0x000f220000209000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00005900ff007a0cULL, 0x000fe20003f65070ULL, 0x0000000000087919ULL, 0x000e620000002600ULL,
0x00005a00ff137624ULL, 0x000fc600078e00ffULL, 0x00000000000a7919ULL, 0x000e620000002200ULL,
0x0000590013137a24ULL, 0x000fc600078e02ffULL, 0x0000000000077919ULL, 0x008ee20000002300ULL,
0x0000000000007308ULL, 0x010f240000001000ULL, 0x0ffffffe00057810ULL, 0x010fcc0007ffe0ffULL,
0x0000000500057305ULL, 0x000f24000021f000ULL, 0x000000ffff0b7224ULL, 0x010fc800078e0a05ULL,
0x000059000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b05047227ULL, 0x000fcc00078e0004ULL,
0x00000400040f7a27ULL, 0x000fc800078e00ffULL, 0x00005900ff047624ULL, 0x000fe400078e00ffULL,
0x000000ffff037224ULL, 0x002fc800078e0a0fULL, 0x0000040003007624ULL, 0x000fca00078e0204ULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x8000590000001a10ULL, 0x000fe40007ffe0ffULL,
0x000000010f0f1810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f46070ULL,
0x000000010f0f2810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff0fba12ULL, 0x000fc800078e33ffULL,
0x0000000f00007306ULL, 0x000e620000209000ULL, 0x000000ff0f00720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000030f057224ULL, 0x010fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a05ULL,
0x0000000503037227ULL, 0x000fe400078e0002ULL, 0x0000000000057919ULL, 0x000e640000002100ULL,
0x0000010007027a24ULL, 0x008fe400078e020aULL, 0x0000000803127227ULL, 0x000fe200078e00ffULL,
0x00001fff07077589ULL, 0x000fe600000e0000ULL, 0x000000ffff007224ULL, 0x000fc800078e0a12ULL,
0x000000000f007224ULL, 0x000fca00078e0208ULL, 0x0000000f0000720cULL, 0x000fe20003fa6070ULL,
0x0000000002117a24ULL, 0x002fca00078e0205ULL, 0x000000ff1100720cULL, 0x000fce0003f65270ULL,
0x0000000100005824ULL, 0x000fe200078e0a0fULL, 0x0000000112125810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1100780cULL, 0x040fe40003f24070ULL, 0x0000000f0000720cULL, 0x000fe40003fc6070ULL,
0x00000005ff007819ULL, 0x000fe40000011605ULL, 0x000000031100780cULL, 0x040fe40003fa4070ULL,
0x0000007f1100780cULL, 0x000fe20003f44070ULL, 0x3fffff80ff02b424ULL, 0x000fe200078e00ffULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x7fffff80ff03b424ULL, 0x000fc400078e00ffULL,
0x3fffffc0ff0a9424ULL, 0x000fe400078e00ffULL, 0x0000000112126810ULL, 0x000fe20007ffe0ffULL,
0x7fffffc0ff0b9424ULL, 0x000fe200078e00ffULL, 0x0000000fff12c212ULL, 0x000fe200078e33ffULL,
0x01760002ff00b388ULL, 0x0007e20000000a00ULL, 0x000000011100780cULL, 0x000fe20003f64070ULL,
0x3fffff80ff0cd424ULL, 0x000fe400078e00ffULL, 0x000000ffff7d7224ULL, 0x000fe200078e0a12ULL,
0x0176080a11009388ULL, 0x000fe20000008a00ULL, 0xff317217ff10a424ULL, 0x000fc400078e00ffULL,
0x0000007d0f7d7224ULL, 0x000fe200078e0208ULL, 0x0000001201007387ULL, 0x000fe20000100800ULL,
0x3fffff60ff02d424ULL, 0x008fe400078e00ffULL, 0x000000107d7d7824ULL, 0x000fe200078e00ffULL,
0x017400101100a388ULL, 0x000fe20000004800ULL, 0x7fffff60ff03d424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0eb424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff0fb424ULL, 0x000fe200078e00ffULL,
0x017688021100d388ULL, 0x0003e40000008a00ULL, 0x0000000407027824ULL, 0x002fc400078e0200ULL,
0x000000010d6a0824ULL, 0x004fe400078e0a06ULL, 0x00005800ff6a8624ULL, 0x000fe400078e00ffULL,
0x0000580009068a24ULL, 0x000fe400078e02ffULL, 0x00005a006a087a24ULL, 0x000fe400078e02ffULL,
0x0000001306157224ULL, 0x000fe400078e02ffULL, 0x0000000108057824ULL, 0x040fe200078e0a7dULL,
0x0000007d0800720cULL, 0x000fe20003f26070ULL, 0x7fffff80ff0dd424ULL, 0x000fc600078e00ffULL,
0x0000001005057817ULL, 0x000fe40003800000ULL, 0x0176a80c1100d388ULL, 0x000fe40000008a00ULL,
0x000000ff05147207ULL, 0x000fe20000800000ULL, 0x0000000202057824ULL, 0x000fe200078e00ffULL,
0x0176c80e1100b388ULL, 0x000fe80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000041401007387ULL, 0x0003e20000100800ULL, 0x000000101400780cULL, 0x000fe20003f05270ULL,
0x00005a00120e7a24ULL, 0x000fc400078e0215ULL, 0x0000081501007387ULL, 0x0003f40000100800ULL,
0x000002c000008947ULL, 0x000fea0003800000ULL, 0x00005a0000037b06ULL, 0x002e620000209000ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x00005a00ff007a0cULL, 0x000fcc0003f45070ULL,
0x0000000300037308ULL, 0x002e620000001000ULL, 0x00000004ff0c7819ULL, 0x004fca0000011602ULL,
0x00000001050d7824ULL, 0x000fe200078e020cULL, 0x0ffffffe030a7810ULL, 0x002fc60007ffe0ffULL,
0x000000017d037824ULL, 0x000fe200078e020dULL, 0x0000000a000b7305ULL, 0x0002a4000021f000ULL,
0x000000ffff0a7224ULL, 0x002fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x004fc800078e0a0bULL,
0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL, 0x0000000f0b087227ULL, 0x000fcc00078e000aULL,
0x00000003080b7227ULL, 0x000fc800078e00ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a0bULL,
0x00005a0008087a24ULL, 0x000fca00078e0203ULL, 0x00005a0008007a0cULL, 0x000fda0003f06070ULL,
0x80005a0008080a10ULL, 0x000fe40007ffe0ffULL, 0x000000010b0b0810ULL, 0x000fe40007ffe0ffULL,
0x00005a0008007a0cULL, 0x000fda0003f26070ULL, 0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff0baa12ULL, 0x000fca00078e33ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a0bULL,
0x00005a0008037a24ULL, 0x000fe200078e0203ULL, 0x0000000514087217ULL, 0x000fc60007800000ULL,
0x000000010e0a7824ULL, 0x000fe400078e0203ULL, 0x0000001002037824ULL, 0x000fe400078e00ffULL,
0x000000130b0a7224ULL, 0x000fe400078e020aULL, 0x0000000108087824ULL, 0x000fe200078e0a05ULL,
0x000000f003057812ULL, 0x000fe200078ec0ffULL, 0x000001000a0a7825ULL, 0x000fc600078e00ffULL,
0x000000080c00720cULL, 0x000fe20003f06070ULL, 0x000000010d087824ULL, 0x040fe200078e0202ULL,
0x000000050a057212ULL, 0x000fe200078efcffULL, 0x000000100d0d7824ULL, 0x000fc600078e00ffULL,
0x00006000050a7a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00d087812ULL, 0x000fe400078ee208ULL,
0x000061000b0b7a10ULL, 0x000fc60000ffe4ffULL, 0x0000001008057824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a057faeULL, 0x0003e2000c101c46ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00005a0000087b06ULL, 0x002e620000209000ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000800087308ULL, 0x002e620000001000ULL,
0x0000000502057211ULL, 0x004fe400078fe0ffULL, 0x0ffffffe080b7810ULL, 0x002fcc0007ffe0ffULL,
0x0000000b000b7305ULL, 0x000e64000021f000ULL, 0x000000ffff037224ULL, 0x002fc800078e0a0bULL,
0x00005a0003037a24ULL, 0x000fc800078e02ffULL, 0x000000030b0a7227ULL, 0x000fc800078e000aULL,
0x000000017d037824ULL, 0x000fc800078e0205ULL, 0x000000030a087227ULL, 0x000fc800078e00ffULL,
0x000000ffff0a7224ULL, 0x000fc800078e0a08ULL, 0x00005a000a0a7a24ULL, 0x000fca00078e0203ULL,
0x00005a000a007a0cULL, 0x000fda0003f06070ULL, 0x80005a000a0a0a10ULL, 0x000fe40007ffe0ffULL,
0x0000000108080810ULL, 0x000fe40007ffe0ffULL, 0x00005a000a007a0cULL, 0x000fda0003f26070ULL,
0x0000000108081810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff08aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff0a7224ULL, 0x000fc800078e0a08ULL, 0x00005a000a037a24ULL, 0x000fc800078e0203ULL,
0x000000010e037824ULL, 0x000fc800078e0203ULL, 0x00000013080a7224ULL, 0x000fe400078e0203ULL,
0x0000001002037824ULL, 0x000fe400078e00ffULL, 0x000001000a0a7825ULL, 0x000fc600078e00ffULL,
0x000000f0030d7812ULL, 0x000fe200078ec0ffULL, 0x0000000105087824ULL, 0x040fe400078e0202ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x0000000d0a0a7212ULL, 0x000fc800078efcffULL,
0xfffffff005087812ULL, 0x000fe400078ee208ULL, 0x000060000a0a7a10ULL, 0x000fc60007f1e0ffULL,
0x0000001008057824ULL, 0x000fe200078e00ffULL, 0x000061000b0b7a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a057faeULL, 0x0003e8000b901c46ULL,
0x00000000000b7919ULL, 0x002e620000000000ULL, 0x0000000000057806ULL, 0x000fe200038e0000ULL,
0x00000004ff667424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000500087300ULL, 0x000e7000000e0000ULL, 0x00000005000a7309ULL, 0x000ea20000000000ULL,
0x0000000b0800720cULL, 0x002fe20003f02070ULL, 0x000000ffff087224ULL, 0x004fc400078e0a0aULL,
0x00006600090a7625ULL, 0x000fd400078e0066ULL, 0x01760408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01760000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000060a777981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0700720cULL, 0x000fe40003f05270ULL,
0x000000ff77087810ULL, 0x006fc80007ffe0ffULL, 0x00000008ff7a7819ULL, 0x000fce0000011608ULL,
0x0000f55000008947ULL, 0x000fea0003800000ULL, 0x0000000800117824ULL, 0x000fe400078e00ffULL,
0x00000003ff067424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01768c0611ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0800780cULL, 0x000fe20003f04070ULL, 0x0000000209097824ULL, 0x000fe200078e00ffULL,
0x00000001ff787819ULL, 0x000fe20000011600ULL, 0x0176880011ff7f8cULL, 0x0005e2000c80043fULL,
0x0000000100797812ULL, 0x000fe200078ec0ffULL, 0x0000590009097624ULL, 0x000fe400078e0204ULL,
0x00000020780a7824ULL, 0x000fc400078e00ffULL, 0x00000001127b7824ULL, 0x000fc800078e0209ULL,
0x000068007b067a24ULL, 0x002fe200078e020aULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x0000000a77047217ULL, 0x004fe20007800000ULL, 0x0000001079057824ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fc60000011602ULL, 0x0000000104047824ULL, 0x000fe200078e0a0aULL,
0x00000004070a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000105097824ULL, 0x000fe200078e0207ULL,
0x0000000c070d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000504047217ULL, 0x000fe20007800000ULL,
0x0000000109087824ULL, 0x040fe400078e0202ULL, 0x00000008090b7824ULL, 0x000fe400078e00ffULL,
0x0000000104047824ULL, 0x000fc400078e0a05ULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0xfffffff80b0c7812ULL, 0x000fe200078ee208ULL, 0x00000001050f7824ULL, 0x000fe200078e020dULL,
0x0000000807087810ULL, 0x040fe40007ffe0ffULL, 0x000000040700720cULL, 0x080fe20003f66070ULL,
0x0000000105077824ULL, 0x040fe200078e020aULL, 0x000000040a00720cULL, 0x080fe20003f46070ULL,
0x00000001050b7824ULL, 0x000fe200078e0208ULL, 0x000000040800720cULL, 0x080fe20003f26070ULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000040d00720cULL, 0x000fe20003f06070ULL,
0x0000008009047825ULL, 0x000fe200078e00ffULL, 0x00013000780d7811ULL, 0x000fc600078e68ffULL,
0x0000000107097824ULL, 0x140fe200078e0202ULL, 0x00000070040a7812ULL, 0x000fe200078ef803ULL,
0x00000008070e7824ULL, 0x000fe400078e00ffULL, 0x0000000106077824ULL, 0x000fe200078e020bULL,
0x000064000a0a7a10ULL, 0x000fe20007f9e0ffULL, 0x0000000106127824ULL, 0x000fe200078e020fULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL, 0x000000010b067824ULL, 0x040fe400078e0202ULL,
0x000000080b0b7824ULL, 0x000fc400078e00ffULL, 0x000000010f047824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b107812ULL, 0x000fe200078ee206ULL,
0x0000008007067825ULL, 0x000fe200078e00ffULL, 0x00006500050b7a10ULL, 0x000fe400027fe4ffULL,
0xfffffff80f147812ULL, 0x000fe200078ee204ULL, 0x0000008008047825ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fc600078ef803ULL, 0x0000008012087825ULL, 0x000fe200078e00ffULL,
0x0000007004047812ULL, 0x000fe400078ef803ULL, 0x0000640006067a10ULL, 0x000fe20007fbe0ffULL,
0x000000100c0f7824ULL, 0x000fe200078e020dULL, 0x0000007008087812ULL, 0x000fe200078ef803ULL,
0x000000100e137824ULL, 0x100fe200078e020dULL, 0x0000640004047a10ULL, 0x000fe20007f9e0ffULL,
0x0000001010037824ULL, 0x100fe200078e020dULL, 0x0000640008087a10ULL, 0x000fe20007fde0ffULL,
0x00000010140d7824ULL, 0x000fe200078e020dULL, 0x0000650005057a10ULL, 0x000fe200027fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0f7faeULL, 0x0003e2000d901c46ULL,
0x0000650007077a10ULL, 0x000fc40002ffe4ffULL, 0x0000650009097a10ULL, 0x000fe200037fe4ffULL,
0x0000000004137faeULL, 0x0003e8000d101c46ULL, 0x0000000006037faeULL, 0x0003e8000c901c46ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001079057824ULL, 0x004fca00078e00ffULL, 0x0000000502057211ULL, 0x000fc800078fe8ffULL,
0x0000000405097810ULL, 0x040fe20007ffe0ffULL, 0x0000000106047824ULL, 0x000fe200078e0205ULL,
0x00000008050b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000105077824ULL, 0x040fe200078e0202ULL,
0x0000000c050d7810ULL, 0x040fe20007ffe0ffULL, 0x00000008050c7824ULL, 0x000fe400078e00ffULL,
0x0000008004047825ULL, 0x000fc600078e00ffULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x0000000106077824ULL, 0x000fe200078e0209ULL, 0x00000070040a7812ULL, 0x000fe200078ef803ULL,
0x0000000109087824ULL, 0x040fe400078e0202ULL, 0x0000000809137824ULL, 0x000fe200078e00ffULL,
0x000064000a0a7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000106097824ULL, 0x040fe400078e020bULL,
0x00000001060f7824ULL, 0x000fe200078e020dULL, 0xfffffff8130e7812ULL, 0x000fe200078ee208ULL,
0x000000010b067824ULL, 0x040fe200078e0202ULL, 0x0001300078137811ULL, 0x000fe200078e68ffULL,
0x000000080b0b7824ULL, 0x000fc400078e00ffULL, 0x000000010d047824ULL, 0x040fe400078e0202ULL,
0x000000080d0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b107812ULL, 0x000fe400078ee206ULL,
0x00006500050b7a10ULL, 0x000fe400007fe4ffULL, 0xfffffff80d127812ULL, 0x000fe200078ee204ULL,
0x0000008007047825ULL, 0x000fc800078e00ffULL, 0x0000008009067825ULL, 0x000fe200078e00ffULL,
0x0000007004047812ULL, 0x000fc600078ef803ULL, 0x000000800f087825ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fe400078ef803ULL, 0x0000640004047a10ULL, 0x000fe20007f1e0ffULL,
0x000000100c0d7824ULL, 0x000fe200078e0213ULL, 0x0000007008087812ULL, 0x000fe200078ef803ULL,
0x000000100e0f7824ULL, 0x100fe200078e0213ULL, 0x0000640006067a10ULL, 0x000fe20007f3e0ffULL,
0x0000001010037824ULL, 0x100fe200078e0213ULL, 0x0000640008087a10ULL, 0x000fe20007f5e0ffULL,
0x0000001012137824ULL, 0x000fe200078e0213ULL, 0x0000650005057a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000b901c46ULL,
0x0000650007077a10ULL, 0x000fc40000ffe4ffULL, 0x0000650009097a10ULL, 0x000fe200017fe4ffULL,
0x00000000040f7faeULL, 0x0003e8000b901c46ULL, 0x0000000006037faeULL, 0x0003e8000b901c46ULL,
0x0000000008137faeULL, 0x0003e4000b901c46ULL, 0x00000000780473c2ULL, 0x000ea200000e0000ULL,
0x000000ff7a00720cULL, 0x000fe20003f05270ULL, 0x000000ffff077224ULL, 0x002fe200078e00ffULL,
0x000176a878047811ULL, 0x000fe200078e18ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000176a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff0a7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200004047f8cULL, 0x000ea2000c80043fULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000d7f000008947ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e000bULL,
0x00000002ff7c7819ULL, 0x000fe20000011600ULL, 0x000000ffff037224ULL, 0x004fc400078e0005ULL,
0xff317217ff127424ULL, 0x000fe400078e00ffULL, 0x000000ffff667224ULL, 0x000fe400078e00ffULL,
0x000000ffff177224ULL, 0x000fc400078e00ffULL, 0x000000ffff0e7224ULL, 0x02afca00078e00ffULL,
0x0000000000047805ULL, 0x000fc40000015200ULL, 0x0000000400067824ULL, 0x000fca00078e00ffULL,
0xfffffff806067812ULL, 0x000fc800078ec0ffULL, 0x000176c806107810ULL, 0x000fe20007ffe0ffULL,
0x0176cc0006087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008040f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e05ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000000f08087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0176cc0006087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000166037810ULL, 0x000fe20007ffe0ffULL,
0x0000002078047824ULL, 0x000fc600078e00ffULL, 0x0000007a0300720cULL, 0x000fe20003f26070ULL,
0x00000100660f7824ULL, 0x000fca00078e0204ULL, 0x000000400f047810ULL, 0x000fca0007ffe0ffULL,
0x000068007b1a7a24ULL, 0x000fe400078e0204ULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x0000000477037217ULL, 0x000fe20007800000ULL, 0x0000001079067824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fe20000011602ULL, 0x0000001002087824ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fe200078e0a04ULL, 0x0000000405137810ULL, 0x000fe20007ffe0ffULL,
0x0000000106097824ULL, 0x000fc600078e0205ULL, 0x0000000306037217ULL, 0x000fe20007800000ULL,
0x0000000109047824ULL, 0x040fe400078e0202ULL, 0x0000000809197824ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fc600078e0a06ULL, 0xfffffff8190e7812ULL, 0x000fe200078ee204ULL,
0x0000000106197824ULL, 0x040fe200078e0213ULL, 0x000000031300720cULL, 0x080fe40003f66070ULL,
0x0000000805137810ULL, 0x000fe20007ffe0ffULL, 0x0000000119047824ULL, 0x000fe200078e0202ULL,
0x000000030500720cULL, 0x080fe20003f86070ULL, 0x00000008193b7824ULL, 0x000fe200078e00ffULL,
0x0000000c05057810ULL, 0x000fe20007ffe0ffULL, 0x00000001061b7824ULL, 0x000fe200078e0213ULL,
0x000000031300720cULL, 0x000fc40003f46070ULL, 0x0000007008137812ULL, 0x000fe200078ec0ffULL,
0x0000000106397824ULL, 0x000fe200078e0205ULL, 0xfffffff83b067812ULL, 0x000fe200078ee204ULL,
0x0000000109047824ULL, 0x100fe200078e021aULL, 0x000000030500720cULL, 0x000fe20003f06070ULL,
0x0000000119087824ULL, 0x000fe400078e021aULL, 0x0000000139197824ULL, 0x040fe400078e0202ULL,
0x00000008393a7824ULL, 0x000fe400078e00ffULL, 0x0000008004047825ULL, 0x000fc600078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee219ULL, 0x000000011b187824ULL, 0x000fe200078e021aULL,
0x0000001304047212ULL, 0x000fe200078efcffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0x0000640004047a10ULL, 0x000fe20007fbe0ffULL, 0x00000001391a7824ULL, 0x000fe200078e021aULL,
0x0000001308087212ULL, 0x000fe200078efcffULL, 0x000000011b037824ULL, 0x000fe200078e0202ULL,
0x0000650005057a10ULL, 0x000fe20002ffe4ffULL, 0x000000081b387824ULL, 0x000fe200078e00ffULL,
0x0000640008087a10ULL, 0x000fe20007fde0ffULL, 0x0000008018187825ULL, 0x000fc600078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee203ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000001318187212ULL, 0x080fe400078efcffULL, 0x0001400078037811ULL, 0x000fe400078e68ffULL,
0x000000131a1a7212ULL, 0x000fe400078efcffULL, 0x0000650009097a10ULL, 0x000fe200037fe4ffULL,
0x000000100e137824ULL, 0x100fe200078e0203ULL, 0x0000640018187a10ULL, 0x000fe20007fbe0ffULL,
0x0000001006397824ULL, 0x100fe200078e0203ULL, 0x000064001a1a7a10ULL, 0x000fe20007fde0ffULL,
0x00000010383b7824ULL, 0x100fe200078e0203ULL, 0x0000650019197a10ULL, 0x000fe20002ffe4ffULL,
0x000000103a037824ULL, 0x000fe200078e0203ULL, 0x000065001b1b7a10ULL, 0x000fe200037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004137faeULL, 0x0003e8000e101c46ULL,
0x0000000008397faeULL, 0x0003e8000d901c46ULL, 0x00000000183b7faeULL, 0x0003e8000d101c46ULL,
0x000000001a037faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001079037824ULL, 0x000fe200078e00ffULL, 0x00014000783b7811ULL, 0x000fe200078e68ffULL,
0x0000001002047824ULL, 0x000fc600078e00ffULL, 0x0000000302037211ULL, 0x000fe400078fe8ffULL,
0x0000007004397812ULL, 0x000fe400078ec0ffULL, 0x0000000403097810ULL, 0x040fe20007ffe0ffULL,
0x0000000103057824ULL, 0x040fe200078e0202ULL, 0x0000000803137810ULL, 0x040fe20007ffe0ffULL,
0x0000000803067824ULL, 0x040fe200078e00ffULL, 0x0000000c03197810ULL, 0x040fe20007ffe0ffULL,
0x0000000103047824ULL, 0x100fe400078e021aULL, 0x0000000109087824ULL, 0x040fe200078e021aULL,
0xfffffff806067812ULL, 0x000fe200078ee205ULL, 0x0000000109037824ULL, 0x000fc400078e0202ULL,
0x00000008090e7824ULL, 0x000fe400078e00ffULL, 0x0000000113097824ULL, 0x040fe400078e0202ULL,
0x0000000813387824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL,
0x0000008004047825ULL, 0x000fc600078e00ffULL, 0xfffffff838387812ULL, 0x000fe200078ee209ULL,
0x0000000113187824ULL, 0x100fe200078e021aULL, 0x0000003904047212ULL, 0x000fe200078efcffULL,
0x00000001191a7824ULL, 0x040fe400078e021aULL, 0x0000000119137824ULL, 0x040fe200078e0202ULL,
0x0000640004047a10ULL, 0x000fe20007f1e0ffULL, 0x00000008193a7824ULL, 0x000fe400078e00ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000650005057a10ULL, 0x000fc400007fe4ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee213ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000003908087212ULL, 0x000fc600078efcffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000003918187212ULL, 0x080fe400078efcffULL, 0x0000640008087a10ULL, 0x000fe20007f1e0ffULL,
0x0000001006037824ULL, 0x100fe200078e023bULL, 0x000000391a1a7212ULL, 0x000fe200078efcffULL,
0x000000100e137824ULL, 0x100fe200078e023bULL, 0x0000640018187a10ULL, 0x000fe20007f5e0ffULL,
0x0000001038397824ULL, 0x100fe200078e023bULL, 0x000064001a1a7a10ULL, 0x000fe20007f7e0ffULL,
0x000000103a3b7824ULL, 0x000fe200078e023bULL, 0x0000650009097a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e2000b901c46ULL,
0x0000650019197a10ULL, 0x000fc400017fe4ffULL, 0x000065001b1b7a10ULL, 0x000fe20001ffe4ffULL,
0x0000000008137faeULL, 0x0003e8000b901c46ULL, 0x0000000018397faeULL, 0x0003e8000b901c46ULL,
0x000000001a3b7faeULL, 0x0003e4000b901c46ULL, 0xfffffff011057812ULL, 0x042fe400078ec0ffULL,
0xffffffe011037812ULL, 0x000fc400078ec0ffULL, 0x00000000050573c2ULL, 0x000e6200000e0000ULL,
0x0000001011047812ULL, 0x000fca00078ec0ffULL, 0x0000000103067824ULL, 0x000fe400078e0204ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008791a7824ULL, 0x000fe200078e0206ULL,
0x000176b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176b00005047f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x017608001a1a7f8cULL, 0x000ea4000c80043fULL, 0x0000000000087805ULL, 0x000fc40000015200ULL,
0x0000000811037812ULL, 0x000fca00078ec0ffULL, 0x00000001060e7824ULL, 0x000fca00078e0203ULL,
0x01760c000e037984ULL, 0x000ee40000000800ULL, 0x8000000003ff7812ULL, 0x00cfe4000780481bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x0000001808067210ULL, 0x000fca0007f1e1ffULL, 0x0000000119187824ULL, 0x000fe200000e0e09ULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff1800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff1800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011418ULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e0618ULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000113137810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01760c000e037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x004fe4000780481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001002607824ULL, 0x000fe200078e00ffULL, 0x00000001ff757819ULL, 0x000fe20000011602ULL,
0x0000002000037824ULL, 0x000fc600078e00ffULL, 0x0000007060607812ULL, 0x000fe400078ec0ffULL,
0xffffff8003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c75757812ULL, 0x000fc800078ec0ffULL,
0x0000000375037210ULL, 0x000fca0007ffe060ULL, 0x0170000003097984ULL, 0x000ea80000000800ULL,
0x0172000003067984ULL, 0x0006620000000800ULL, 0x000000120900720bULL, 0x004fe20003f1d000ULL,
0x000161227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x008fc800000e0100ULL,
0x0000ffff13197812ULL, 0x000fe2000780c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x00000001ff187424ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x000fd200078e0012ULL,
0x0000043000008947ULL, 0x000fea0003800000ULL, 0x000000007c00720cULL, 0x000fe40003f05270ULL,
0x000000120900720bULL, 0x000fe20003f54000ULL, 0x000160e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000087806ULL, 0x000fc400010e0100ULL, 0x00000080001a8824ULL, 0x000fe200078e0260ULL,
0x0000001209037209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991008137816ULL, 0x000fe200000000ffULL, 0x00000001751a8824ULL, 0x000fca00078e021aULL,
0x017400031a008388ULL, 0x0005e20000000800ULL, 0x000000ff1300720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000001203127221ULL, 0x004fe20000010100ULL,
0x000000ff08ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b12127820ULL, 0x000fcc0000410000ULL, 0x0000001200127308ULL, 0x000ea40000000800ULL,
0x0000001207077220ULL, 0x004fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff137819ULL, 0x000fe20000011602ULL, 0x000160227f007947ULL, 0x000fea000b800000ULL,
0x00001f1312137589ULL, 0x0004e400000e0000ULL, 0x0000001334347220ULL, 0x08cfe40000410000ULL,
0x0000001335357220ULL, 0x080fe40000410000ULL, 0x0000001330307220ULL, 0x080fe40000410000ULL,
0x0000001331317220ULL, 0x000fc40000410000ULL, 0x000000132c2c7220ULL, 0x080fe40000410000ULL,
0x000000132d2d7220ULL, 0x080fe40000410000ULL, 0x0000001328287220ULL, 0x080fe40000410000ULL,
0x0000001329297220ULL, 0x080fe40000410000ULL, 0x0000001324247220ULL, 0x080fe40000410000ULL,
0x0000001325257220ULL, 0x000fc40000410000ULL, 0x0000001320207220ULL, 0x080fe40000410000ULL,
0x0000001321217220ULL, 0x080fe40000410000ULL, 0x000000131c1c7220ULL, 0x080fe40000410000ULL,
0x000000131d1d7220ULL, 0x080fe40000410000ULL, 0x0000001314147220ULL, 0x080fe40000410000ULL,
0x0000001315157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0008ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802137811ULL, 0x000fe200078ff0ffULL, 0x00015f227f007947ULL, 0x000fea000b800000ULL,
0x00001f1312137589ULL, 0x0004e400000e0000ULL, 0x0000001336367220ULL, 0x08cfe40000410000ULL,
0x0000001337377220ULL, 0x080fe40000410000ULL, 0x0000001332327220ULL, 0x080fe40000410000ULL,
0x0000001333337220ULL, 0x080fe40000410000ULL, 0x000000132e2e7220ULL, 0x080fe40000410000ULL,
0x000000132f2f7220ULL, 0x000fc40000410000ULL, 0x000000132a2a7220ULL, 0x080fe40000410000ULL,
0x000000132b2b7220ULL, 0x080fe40000410000ULL, 0x0000001326267220ULL, 0x080fe40000410000ULL,
0x0000001327277220ULL, 0x080fe40000410000ULL, 0x0000001322227220ULL, 0x080fe40000410000ULL,
0x0000001323237220ULL, 0x000fc40000410000ULL, 0x000000131e1e7220ULL, 0x080fe40000410000ULL,
0x000000131f1f7220ULL, 0x080fe40000410000ULL, 0x0000001316167220ULL, 0x080fe40000410000ULL,
0x0000001317177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff19ff7812ULL, 0x000fda0007806008ULL, 0x8000000309090221ULL, 0x000fe20000010000ULL,
0x00007610ff180816ULL, 0x000fc60000000018ULL, 0x3fb8aa3b09090820ULL, 0x000fc80000410000ULL,
0x00000009000d0308ULL, 0x000ea40000000800ULL, 0x0000000d06060220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000706077221ULL, 0x002fc40000010000ULL,
0x0000000000087805ULL, 0x000fca0000015200ULL, 0xfffffff0111b7812ULL, 0x000fca00078ec0ffULL,
0x0176ac001b137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001208197210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e09ULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011413ULL,
0x0000001906067211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000206067819ULL, 0x000fc80000001213ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac001b137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780480aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991018067816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0600720cULL, 0x000fda0003f65270ULL, 0x0000016000003947ULL, 0x000fea0003800000ULL,
0x0000000dff06723eULL, 0x000fe400000010ffULL, 0x00000002ff097819ULL, 0x000fe40000011602ULL,
0x0000541006067816ULL, 0x000fe20000000006ULL, 0x00015b227f007947ULL, 0x000fea000b800000ULL,
0x00001f09060c7589ULL, 0x0002a400000e0000ULL, 0x0000000809137810ULL, 0x000fe20007ffe0ffULL,
0x00015b727f007947ULL, 0x000fea000b800000ULL, 0x00001f13060b7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001009137810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff387224ULL, 0x000fe200078e0006ULL, 0x00002e9000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0001682000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001809137810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff387224ULL, 0x000fe200078e0006ULL,
0x00002f0000397802ULL, 0x000fe20000000f00ULL, 0x0000001fff3b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x000167b000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000702067812ULL, 0x00afe200078ec0ffULL,
0x00000200000a7824ULL, 0x000fe200078e00ffULL, 0x00000004ff527819ULL, 0x100fe20000011602ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000806637812ULL, 0x000fe400078ef802ULL,
0xfffff8000a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000478087824ULL, 0x000fe200078e0252ULL,
0x0000000802097812ULL, 0x000fc600078ec0ffULL, 0x00000001634b7824ULL, 0x040fe400078e0208ULL,
0x0000000863087824ULL, 0x000fca00078e00ffULL, 0xfffffff808137812ULL, 0x004fca00078ee24bULL,
0x0000001013387824ULL, 0x000fc400078e020aULL, 0x00000006093d7212ULL, 0x000fe200078efcffULL,
0x0000000479527824ULL, 0x000fe200078e0252ULL, 0x0000001009097812ULL, 0x000fe400078efe06ULL,
0x00013000786e7811ULL, 0x000fe200078e68ffULL, 0x000000013d3c7824ULL, 0x000fe200078e0252ULL,
0x000000024b4b7810ULL, 0x000fe20007ffe0ffULL, 0x000000083d137824ULL, 0x000fe400078e00ffULL,
0x0000000152527824ULL, 0x000fe400078e0209ULL, 0x0000000809197824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fc400078ee23cULL, 0x000000023c3c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff819197812ULL, 0x000fe200078ee252ULL, 0x0000001013137824ULL, 0x000fc800078e026eULL,
0x0000001019197824ULL, 0x000fe200078e026eULL, 0x000000001340783bULL, 0x000e6a0000004200ULL,
0x000000001918783bULL, 0x000ea20000004200ULL, 0x00000018ff137819ULL, 0x002fe20000011442ULL,
0x0000004000577306ULL, 0x000fe20000009400ULL, 0x00000018ff3a7819ULL, 0x000fe40000011443ULL,
0x00000018ff067819ULL, 0x000fc40000011440ULL, 0x00000018ff3f7819ULL, 0x004fe40000011419ULL,
0x00000018ff087819ULL, 0x000fe20000011441ULL, 0x0000001300507306ULL, 0x000fe20000209400ULL,
0x00000018ff4d7819ULL, 0x000fe4000001141aULL, 0x00000018ff4e7819ULL, 0x000fca000001141bULL,
0x00000013003b7306ULL, 0x000ff00000205400ULL, 0x00000013005d7306ULL, 0x000ff0000020d400ULL,
0x0000003f005c7306ULL, 0x000ff00000209400ULL, 0x0000003f00447306ULL, 0x000ff00000205400ULL,
0x0000003f00137306ULL, 0x0003f0000020d400ULL, 0x0000003a00567306ULL, 0x000fe20000209400ULL,
0x000000083d3f7824ULL, 0x002fc400078e00ffULL, 0x00000100413d7824ULL, 0x000fca00078e00ffULL,
0x0000003a004f7306ULL, 0x000fe20000205400ULL, 0x00000018ff687819ULL, 0x000fe4000001143dULL,
0xfffffff83f3d7812ULL, 0x000fca00078ee23cULL, 0x0000003a00597306ULL, 0x0003e2000020d400ULL,
0x000000103d3d7824ULL, 0x000fce00078e026eULL, 0x00000040005e7306ULL, 0x000ea20000005400ULL,
0x00000100403a7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143aULL,
0x0000004000547306ULL, 0x0002f0000000d400ULL, 0x0000003e003a7306ULL, 0x000fe20000209400ULL,
0x0001000040407824ULL, 0x002fe200078e00ffULL, 0x0000005e5700720bULL, 0x004fc80003fbd000ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000003e006b7306ULL, 0x000e6e0000205400ULL,
0x0000000154545812ULL, 0x008fe200078efcffULL, 0x0000003e00657306ULL, 0x0004f0000020d400ULL,
0x0000000600747306ULL, 0x000fe20000209400ULL, 0x000000003d3c783bULL, 0x004ea20000004200ULL,
0x0000006b3a00720bULL, 0x002fcc0003f5d000ULL, 0x0000000600697306ULL, 0x000e6e0000205400ULL,
0x0000000165652812ULL, 0x008fe200078efcffULL, 0x00000008005b7306ULL, 0x000fe60000209400ULL,
0x000000546554723eULL, 0x000fca00000010ffULL, 0x00000008004c7306ULL, 0x000ee20000205400ULL,
0x000000697400720bULL, 0x002fce0003fdd000ULL, 0x0000000800517306ULL, 0x000e70000020d400ULL,
0x0000004d00467306ULL, 0x000fe20000209400ULL, 0x0000004c5b00720bULL, 0x008fe40003f9d000ULL,
0x00000018ff6b7819ULL, 0x004fc4000001143dULL, 0x00000018ff717819ULL, 0x000fc6000001143fULL,
0x0000004d00487306ULL, 0x000fec0000205400ULL, 0x0000000151514812ULL, 0x002fe400078efcffULL,
0x0000004d00087306ULL, 0x000ff0000020d400ULL, 0x00000040004d7306ULL, 0x000ff00000209400ULL,
0x0000004000727306ULL, 0x000e700000205400ULL, 0x0000004100397306ULL, 0x000ff00000009400ULL,
0x00000041005a7306ULL, 0x000ea20000005400ULL, 0x000000724d00720bULL, 0x002fce0003f5d000ULL,
0x00000068005f7306ULL, 0x000ff00000209400ULL, 0x0000006800627306ULL, 0x000e620000205400ULL,
0x0000005a3900720bULL, 0x004fce0003f1d000ULL, 0x0000004100557306ULL, 0x0004f0000000d400ULL,
0x0000000600537306ULL, 0x0008e2000020d400ULL, 0x0001000041417824ULL, 0x004fe200078e00ffULL,
0x000000625f00720bULL, 0x002fe20003fbd000ULL, 0x000001003c5f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000040006a7306ULL, 0x0002a2000020d400ULL,
0x00000018ff067819ULL, 0x010fe40000011418ULL, 0x0000000155550812ULL, 0x008fe400078efcffULL,
0x0000003b5000720bULL, 0x000fc60003f1d000ULL, 0x0000000600127306ULL, 0x000fe20000209400ULL,
0x0000010042407824ULL, 0x002fe200078e00ffULL, 0x0000000153536812ULL, 0x000fc800078efcffULL,
0x00000018ff6d7819ULL, 0x000fe20000011440ULL, 0x0000010043407824ULL, 0x000fe200078e00ffULL,
0x00000006004a7306ULL, 0x000fe20000205400ULL, 0x000000016a6a2812ULL, 0x004fe400078efcffULL,
0x000000015d5d0812ULL, 0x000fe400078efcffULL, 0x00000018ff6f7819ULL, 0x000fc60000011440ULL,
0x0000000600457306ULL, 0x000ff0000020d400ULL, 0x0000004e00477306ULL, 0x000ff00000209400ULL,
0x0000004e00497306ULL, 0x000ff00000205400ULL, 0x0000004e00067306ULL, 0x000ff0000020d400ULL,
0x00000068004e7306ULL, 0x000e70000020d400ULL, 0x0000004100647306ULL, 0x000ff00000209400ULL,
0x0000004100677306ULL, 0x000ea20000205400ULL, 0x000000014e4e5812ULL, 0x002fc800078efcffULL,
0x000000554e55723eULL, 0x000fc600000010ffULL, 0x00000042005e7306ULL, 0x000ff00000009400ULL,
0x0000004200697306ULL, 0x000e620000005400ULL, 0x000000676400720bULL, 0x004fe40003f5d000ULL,
0x00000018ff647819ULL, 0x000fca000001145fULL, 0x0000006d00587306ULL, 0x000ff00000209400ULL,
0x0000006d00617306ULL, 0x000ea20000205400ULL, 0x000000695e00720bULL, 0x002fce0003fbd000ULL,
0x0000006f00407306ULL, 0x000ff00000209400ULL, 0x0000006f00577306ULL, 0x000e620000205400ULL,
0x000000615800720bULL, 0x004fce0003fdd000ULL, 0x0000006d006c7306ULL, 0x000eb0000020d400ULL,
0x00000042006d7306ULL, 0x000ee2000000d400ULL, 0x000000574000720bULL, 0x002fce0003f9d000ULL,
0x00000043005e7306ULL, 0x000fe20000009400ULL, 0x000000016c6c6812ULL, 0x004fce00078efcffULL,
0x00000043003b7306ULL, 0x000e620000005400ULL, 0x000000016d6d5812ULL, 0x008fce00078efcffULL,
0x0000004100707306ULL, 0x0004f0000020d400ULL, 0x0000006b004c7306ULL, 0x000fe20000209400ULL,
0x00000018ff417819ULL, 0x004fe4000001143cULL, 0x0000003b5e00720bULL, 0x002fca0003fbd000ULL,
0x0000006b004d7306ULL, 0x000fe20000205400ULL, 0x0000000170702812ULL, 0x008fe400078efcffULL,
0x0000004f5600720bULL, 0x000fca0003f5d000ULL, 0x0000006b005b7306ULL, 0x000ff0000020d400ULL,
0x0000006400627306ULL, 0x000fe20000209400ULL, 0x0000000159592812ULL, 0x000fce00078efcffULL,
0x00000064006b7306ULL, 0x000e700000205400ULL, 0x0000006f00687306ULL, 0x000eb0000020d400ULL,
0x0000004100397306ULL, 0x000fe20000209400ULL, 0x0000006b6200720bULL, 0x002fc40003fdd000ULL,
0x00000018ff627819ULL, 0x000fca000001143eULL, 0x00000041003a7306ULL, 0x000e620000205400ULL,
0x0000000168684812ULL, 0x004fce00078efcffULL, 0x00000064005f7306ULL, 0x0004f0000020d400ULL,
0x00000041005a7306ULL, 0x0008e2000020d400ULL, 0x000001003d647824ULL, 0x004fe200078e00ffULL,
0x0000003a3900720bULL, 0x002fc40003f9d000ULL, 0x011000003838783bULL, 0x000e640000000200ULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x0000003c00407306ULL, 0x000fe20000009400ULL,
0x0001000042417824ULL, 0x010fe200078e00ffULL, 0x000000015f5f6812ULL, 0x008fc800078efcffULL,
0x00000018ff6f7819ULL, 0x000fe40000011441ULL, 0x0000006400617306ULL, 0x000fe20000209400ULL,
0x000000015a5a4812ULL, 0x000fce00078efcffULL, 0x00000064005e7306ULL, 0x000eb00000205400ULL,
0x0000006f00417306ULL, 0x000ff00000209400ULL, 0x0000006f00427306ULL, 0x000fe20000205400ULL,
0x0000005e6100720bULL, 0x004fe20003fdd000ULL, 0x0000000c3838b231ULL, 0x002fc400003400ffULL,
0x0000000c3a3ab231ULL, 0x000fc800003400ffULL, 0x0000006f00677306ULL, 0x000fe2000020d400ULL,
0x0000000b3939b231ULL, 0x080fe400003400ffULL, 0x0000000b3b3bb231ULL, 0x000fca00003400ffULL,
0x00000043006f7306ULL, 0x0002a4000000d400ULL, 0x000000543834723cULL, 0x000bec0000041834ULL,
0x0000003c004f7306ULL, 0x000ee20000005400ULL, 0x0001000043437824ULL, 0x002fe200078e00ffULL,
0x0000006a5354723eULL, 0x020fc400000010ffULL, 0x000000705155723eULL, 0x000fe200000010ffULL,
0x0000010019517824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe40000011443ULL,
0x0000003c00617306ULL, 0x000322000000d400ULL, 0x000000016f6f5812ULL, 0x004fe400078efcffULL,
0x000000543830723cULL, 0x000b620000041830ULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000004f4000720bULL, 0x008fc40003fbd000ULL, 0x0000006200587306ULL, 0x000fe20000209400ULL,
0x000100003c3c7824ULL, 0x002fe400078e00ffULL, 0x000100003d547824ULL, 0x020fca00078e00ffULL,
0x00000062006b7306ULL, 0x000fe20000205400ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000000161615812ULL, 0x010fe400078efcffULL, 0x0000004d4c00720bULL, 0x000fe20003fbd000ULL,
0x00000100184c7824ULL, 0x000fe400078e00ffULL, 0x0000006200507306ULL, 0x000ff0000020d400ULL,
0x0000006400627306ULL, 0x000e64000020d400ULL, 0x000000015b5b5812ULL, 0x000fcc00078efcffULL,
0x0000007100567306ULL, 0x000ff00000209400ULL, 0x0000007100577306ULL, 0x000fe20000205400ULL,
0x0000000162626812ULL, 0x002fe400078efcffULL, 0x000000424100720bULL, 0x000fca0003fdd000ULL,
0x00000071004f7306ULL, 0x0003f0000020d400ULL, 0x0000006900407306ULL, 0x000fe20000209400ULL,
0x00000018ff717819ULL, 0x002fe4000001144cULL, 0x0000000167676812ULL, 0x000fca00078efcffULL,
0x0000006900437306ULL, 0x000e700000205400ULL, 0x00000069005e7306ULL, 0x000eb0000020d400ULL,
0x00000071004c7306ULL, 0x000fe20000209400ULL, 0x000000434000720bULL, 0x002fe20003fdd000ULL,
0x0001000018437824ULL, 0x000fca00078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011443ULL,
0x00000071004d7306ULL, 0x000fec0000205400ULL, 0x000000015e5e6812ULL, 0x004fe400078efcffULL,
0x0000007100417306ULL, 0x000fe2000020d400ULL, 0x0000006b5800720bULL, 0x000fe20003fdd000ULL,
0x000001003e6b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001146bULL,
0x0000003d00697306ULL, 0x000fec0000009400ULL, 0x0000000150506812ULL, 0x000fe400078efcffULL,
0x0000003d00717306ULL, 0x000e700000005400ULL, 0x0000003d006a7306ULL, 0x0004e2000000d400ULL,
0x000000716900720bULL, 0x002fce0003f1d000ULL, 0x0000001900587306ULL, 0x000fe2000000d400ULL,
0x00000018ff717819ULL, 0x000fe4000001143cULL, 0x0000006d6c3c723eULL, 0x000fe400000010ffULL,
0x0000006f683d723eULL, 0x004fc600000010ffULL, 0x0000007100557306ULL, 0x000fe80000209400ULL,
0x0000003c382c723cULL, 0x000be2000004182cULL, 0x000000016a6a0812ULL, 0x008fc600078efcffULL,
0x0000007100707306ULL, 0x000e660000205400ULL, 0x000000675d3c723eULL, 0x020fe400000010ffULL,
0x0000005e593d723eULL, 0x000fc600000010ffULL, 0x00000054006c7306ULL, 0x000fe80000209400ULL,
0x0000003c3828723cULL, 0x000b680000041828ULL, 0x00000054006f7306ULL, 0x000ea20000205400ULL,
0x000000705500720bULL, 0x002fce0003f5d000ULL, 0x0000007100697306ULL, 0x000e70000020d400ULL,
0x0000006b005d7306ULL, 0x000fe20000209400ULL, 0x0000006f6c00720bULL, 0x004fe20003f1d000ULL,
0x000001003f6f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001146fULL,
0x0000006b005e7306ULL, 0x000ea20000205400ULL, 0x0000000169692812ULL, 0x002fce00078efcffULL,
0x0000003f003d7306ULL, 0x020ff00000009400ULL, 0x0000003f006c7306ULL, 0x000e620000005400ULL,
0x0000005e5d00720bULL, 0x004fce0003f5d000ULL, 0x0000005400687306ULL, 0x000eb0000020d400ULL,
0x0000003e006d7306ULL, 0x000fe20000009400ULL, 0x0000006c3d00720bULL, 0x002fe40003fbd000ULL,
0x0000006a623d723eULL, 0x000fca00000010ffULL, 0x0000003e003c7306ULL, 0x000e620000005400ULL,
0x0000000168680812ULL, 0x004fce00078efcffULL, 0x0000006f00597306ULL, 0x000ff00000209400ULL,
0x0000006f005e7306ULL, 0x000ea20000205400ULL, 0x0000003c6d00720bULL, 0x002fe40003f1d000ULL,
0x000000615f3c723eULL, 0x000fe200000010ffULL, 0x000100003f5f7824ULL, 0x000fc800078e00ffULL,
0x0000001900547306ULL, 0x000fe40000009400ULL, 0x0000003c3824723cULL, 0x000b6c0000041824ULL,
0x0000001900557306ULL, 0x0002e20000005400ULL, 0x0000005e5900720bULL, 0x004fe40003f9d000ULL,
0x000000695a3c723eULL, 0x020fe200000010ffULL, 0x0000000809697824ULL, 0x000fe200078e00ffULL,
0x000000685b3d723eULL, 0x000fe200000010ffULL, 0x000001001a687824ULL, 0x000fc400078e00ffULL,
0x0000006b006b7306ULL, 0x000ea2000020d400ULL, 0x0001000019197824ULL, 0x002fe400078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x0000003c3820723cULL, 0x000b640000041820ULL,
0x00000018ff717819ULL, 0x000fe20000011419ULL, 0x000100003e197824ULL, 0x000fe200078e00ffULL,
0x0000003e006c7306ULL, 0x000e62000000d400ULL, 0x000000555400720bULL, 0x008fc60003fdd000ULL,
0x00000018ff707819ULL, 0x000fc80000011419ULL, 0x0000006f00677306ULL, 0x000ee2000020d400ULL,
0x000000016b6b2812ULL, 0x004fe400078efcffULL, 0x000000575600720bULL, 0x000fe40003f5d000ULL,
0x0000000252567810ULL, 0x000fe40007ffe0ffULL, 0x0000000158586812ULL, 0x000fe200078efcffULL,
0x0000003f003e7306ULL, 0x000522000000d400ULL, 0x000000016c6c0812ULL, 0x002fc800078efcffULL,
0x0000006c6b3c723eULL, 0x020fe400000010ffULL, 0x0000000167674812ULL, 0x008fe200078efcffULL,
0x00000070006d7306ULL, 0x000fe20000209400ULL, 0x00000018ff3f7819ULL, 0x004fe4000001145fULL,
0x000000014f4f2812ULL, 0x000fe400078efcffULL, 0x0000004d4c00720bULL, 0x000fe40003f5d000ULL,
0x000000013e3e5812ULL, 0x010fe200078efcffULL, 0x0000003f00627306ULL, 0x000fe60000209400ULL,
0x0000003e673d723eULL, 0x000fc400000010ffULL, 0xfffffff869677812ULL, 0x000fc600078ee256ULL,
0x0000003f006a7306ULL, 0x000e640000205400ULL, 0x00000010673e7824ULL, 0x000fe200078e026eULL,
0x0000003c381c723cULL, 0x000b62000004181cULL, 0x0000000141412812ULL, 0x000fc800078efcffULL,
0x0000003f00577306ULL, 0x0004f0000020d400ULL, 0x0000007000617306ULL, 0x000f220000205400ULL,
0x000000003e3c783bULL, 0x024ea20000004200ULL, 0x0000006a6200720bULL, 0x002fcc0003f9d000ULL,
0x0000007000197306ULL, 0x000e6e000020d400ULL, 0x0000000157574812ULL, 0x008fe200078efcffULL,
0x0000001a005f7306ULL, 0x000fe20000009400ULL, 0x000000616d00720bULL, 0x010fe40003f1d000ULL,
0x000000574f57723eULL, 0x000fc400000010ffULL, 0x0000004a1200720bULL, 0x000fc60003f9d000ULL,
0x0000001a005b7306ULL, 0x000eec0000005400ULL, 0x0000000119190812ULL, 0x002fe400078efcffULL,
0x00000018004e7306ULL, 0x000fe40000009400ULL, 0x000000195056723eULL, 0x000fe200000010ffULL,
0x000001001b197824ULL, 0x000fe200078e00ffULL, 0x0000000145454812ULL, 0x000fc400078efcffULL,
0x000000445c00720bULL, 0x000fe40003f9d000ULL, 0x0000001800427306ULL, 0x000e620000005400ULL,
0x000001003c127824ULL, 0x004fe200078e00ffULL, 0x000000563814723cULL, 0x000b620000041814ULL,
0x0000005b5f00720bULL, 0x008fe40003fbd000ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018ff5b7819ULL, 0x000fe20000011412ULL, 0x0000001800407306ULL, 0x000ea2000000d400ULL,
0x000100001b387824ULL, 0x020fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143cULL,
0x0000000863127824ULL, 0x000fe200078e00ffULL, 0x0000000113134812ULL, 0x000fc800078efcffULL,
0x0000005100187306ULL, 0x000fe20000209400ULL, 0x000000424e00720bULL, 0x002fe40003f1d000ULL,
0xfffffff8124b7812ULL, 0x000fca00078ee24bULL, 0x0000005100537306ULL, 0x000e620000205400ULL,
0x000000104b127824ULL, 0x000fe400078e020aULL, 0x000001003d4b7824ULL, 0x000fc600078e00ffULL,
0x0000000140400812ULL, 0x004fe400078efcffULL, 0x0000001a005a7306ULL, 0x0004e4000000d400ULL,
0x000000404140723eULL, 0x000fcc00000010ffULL, 0x0000001b00617306ULL, 0x000fe20000009400ULL,
0x000100001a1a7824ULL, 0x004fe200078e00ffULL, 0x000000531800720bULL, 0x002fc80003f1d000ULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x0000001b00507306ULL, 0x000fe20000005400ULL,
0x000000015a5a5812ULL, 0x008fce00078efcffULL, 0x0000001b004f7306ULL, 0x0003f0000000d400ULL,
0x0000007200657306ULL, 0x000fe20000209400ULL, 0x00000018ff1b7819ULL, 0x002fce0000011438ULL,
0x0000007200647306ULL, 0x000e700000205400ULL, 0x0000007200437306ULL, 0x000eb0000020d400ULL,
0x00000071005d7306ULL, 0x000fe20000209400ULL, 0x000000646500720bULL, 0x002fc40003f5d000ULL,
0x00000018ff647819ULL, 0x000fca000001144bULL, 0x00000071005e7306ULL, 0x000e6c0000205400ULL,
0x0000000143432812ULL, 0x004fe400078efcffULL, 0x0000007100597306ULL, 0x000ea2000020d400ULL,
0x000000506100720bULL, 0x000fce0003f5d000ULL, 0x0000006800627306ULL, 0x000fe20000209400ULL,
0x0000005e5d00720bULL, 0x002fca0003fdd000ULL, 0x000000014f4f2812ULL, 0x000fe400078efcffULL,
0x0000006800527306ULL, 0x000e6c0000205400ULL, 0x0000000159596812ULL, 0x004fe400078efcffULL,
0x0000006800677306ULL, 0x000ea4000020d400ULL, 0x000000591359723eULL, 0x000fcc00000010ffULL,
0x0000001900687306ULL, 0x000fe20000209400ULL, 0x000000526200720bULL, 0x002fce0003fdd000ULL,
0x00000019006b7306ULL, 0x000e6c0000205400ULL, 0x0000000167676812ULL, 0x004fe400078efcffULL,
0x0000001900577306ULL, 0x0004f0000020d400ULL, 0x0000001a00707306ULL, 0x000fe20000209400ULL,
0x00000018ff197819ULL, 0x004fc4000001143dULL, 0x0000006b6800720bULL, 0x002fca0003f9d000ULL,
0x0000001a006f7306ULL, 0x000e700000205400ULL, 0x0000001a00697306ULL, 0x000522000020d400ULL,
0x0000000157574812ULL, 0x008fc800078efcffULL, 0x0000004f574f723eULL, 0x000fc600000010ffULL,
0x0000001b00717306ULL, 0x000fe20000209400ULL, 0x00000018ff1a7819ULL, 0x004fe4000001143eULL,
0x0000006f7000720bULL, 0x002fca0003fbd000ULL, 0x0000001b00727306ULL, 0x000e700000205400ULL,
0x0000001b00567306ULL, 0x0004e2000020d400ULL, 0x0000000169695812ULL, 0x010fce00078efcffULL,
0x0000003a006c7306ULL, 0x000fe20000209400ULL, 0x00000018ff1b7819ULL, 0x004fe4000001143fULL,
0x000000727100720bULL, 0x002fca0003f9d000ULL, 0x0000003a006d7306ULL, 0x000ff00000205400ULL,
0x0000003a00387306ULL, 0x000fe2000020d400ULL, 0x0000000156564812ULL, 0x008fce00078efcffULL,
0x00000019006a7306ULL, 0x000ff00000209400ULL, 0x00000019004e7306ULL, 0x000ff00000205400ULL,
0x0000001900397306ULL, 0x000ff0000020d400ULL, 0x0000001a00427306ULL, 0x000ff00000209400ULL,
0x0000001a004d7306ULL, 0x000ff00000205400ULL, 0x0000001a003a7306ULL, 0x000ff0000020d400ULL,
0x0000001b004c7306ULL, 0x000ff00000209400ULL, 0x0000001b004a7306ULL, 0x000ff00000205400ULL,
0x0000001b003b7306ULL, 0x0003f0000020d400ULL, 0x0000005100517306ULL, 0x000ea2000020d400ULL,
0x011000001218783bULL, 0x002e6e0000000200ULL, 0x0000003c00547306ULL, 0x000ff00000009400ULL,
0x0000003c00657306ULL, 0x000ee20000005400ULL, 0x0000000151510812ULL, 0x004fc400078efcffULL,
0x000000484600720bULL, 0x000fe20003f1d000ULL, 0x000100003c467824ULL, 0x000fe200078e00ffULL,
0x000000585141723eULL, 0x000fe200000010ffULL, 0x000100003f517824ULL, 0x000fe200078e00ffULL,
0x000000434558723eULL, 0x000fe200000010ffULL, 0x00000064005f7306ULL, 0x000fe20000209400ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000018ff437819ULL, 0x000fca0000011451ULL,
0x0000006400507306ULL, 0x000ea20000205400ULL, 0x000000655400720bULL, 0x008fe40003fdd000ULL,
0x0000000108080812ULL, 0x000fca00078efcffULL, 0x00000064004b7306ULL, 0x000fe2000020d400ULL,
0x0000000c1818b231ULL, 0x082fe400003400ffULL, 0x0000000c1a1ab231ULL, 0x000fe400003400ffULL,
0x0000000b1919b231ULL, 0x080fe400003400ffULL, 0x0000000b1b1bb231ULL, 0x000fe200003400ffULL,
0x0000003c00447306ULL, 0x000e62000000d400ULL, 0x000000494700720bULL, 0x000fe20003f7d000ULL,
0x000001003e497824ULL, 0x000fe200078e00ffULL, 0x000000505f00720bULL, 0x004fe20003f1d000ULL,
0x000100003d477824ULL, 0x000fc400078e00ffULL, 0x000000581830723cULL, 0x040f620000041830ULL,
0x00000018ff527819ULL, 0x000fe20000011449ULL, 0x0000003d00737306ULL, 0x000fec0000009400ULL,
0x0000000106063812ULL, 0x000fe200078efcffULL, 0x000000401834723cULL, 0x000b620000041834ULL,
0x0000003d00747306ULL, 0x000ea20000005400ULL, 0x0000000144446812ULL, 0x002fc400078efcffULL,
0x000000014b4b0812ULL, 0x000fc600078efcffULL, 0x000000560641723eULL, 0x020fe400000010ffULL,
0x0000005b00557306ULL, 0x000fe20000209400ULL, 0x000000690840723eULL, 0x000fce00000010ffULL,
0x0000005b00637306ULL, 0x000e620000205400ULL, 0x000000747300720bULL, 0x004fe20003f5d000ULL,
0x000000401828723cULL, 0x000f6c0000041828ULL, 0x0000004600617306ULL, 0x000ff00000209400ULL,
0x0000004600647306ULL, 0x000ea20000205400ULL, 0x000000635500720bULL, 0x002fe20003fbd000ULL,
0x000100003e557824ULL, 0x000fca00078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0000003d003c7306ULL, 0x0002f0000000d400ULL, 0x0000003e00497306ULL, 0x000fe20000009400ULL,
0x00000018ff3d7819ULL, 0x002fc40000011447ULL, 0x000000646100720bULL, 0x004fca0003fdd000ULL,
0x0000003e00627306ULL, 0x000e620000005400ULL, 0x000000013c3c2812ULL, 0x008fe400078efcffULL,
0x0000004e6a00720bULL, 0x000fe40003f5d000ULL, 0x0000003c4b45723eULL, 0x000fe400000010ffULL,
0x0000005a674e723eULL, 0x000fe200000010ffULL, 0x0000005b00537306ULL, 0x000eac000020d400ULL,
0x0000004e182c723cULL, 0x000f64000004182cULL, 0x0000004600487306ULL, 0x000ee2000020d400ULL,
0x000000624900720bULL, 0x002fc40003f9d000ULL, 0x0000000139392812ULL, 0x000fca00078efcffULL,
0x0000003d005d7306ULL, 0x000fe20000209400ULL, 0x0000000153535812ULL, 0x004fe400078efcffULL,
0x0000006d6c00720bULL, 0x000fe40003fbd000ULL, 0x000000445344723eULL, 0x000fc600000010ffULL,
0x0000003d005e7306ULL, 0x000e620000205400ULL, 0x0000000148486812ULL, 0x008fc600078efcffULL,
0x000000441824723cULL, 0x000f680000041824ULL, 0x00000052005b7306ULL, 0x000fe20000209400ULL,
0x0000000138385812ULL, 0x000fe400078efcffULL, 0x0000004d4200720bULL, 0x000fe40003fbd000ULL,
0x000000483838723eULL, 0x000fc600000010ffULL, 0x00000052005c7306ULL, 0x000ea20000205400ULL,
0x0000005e5d00720bULL, 0x002fce0003f1d000ULL, 0x0000003d00477306ULL, 0x0002e2000020d400ULL,
0x000000013a3a5812ULL, 0x000fce00078efcffULL, 0x0000005200467306ULL, 0x000f22000020d400ULL,
0x000001003f3d7824ULL, 0x002fe200078e00ffULL, 0x0000005c5b00720bULL, 0x004fc80003fdd000ULL,
0x00000018ff6b7819ULL, 0x000fe4000001143dULL, 0x0000003e00497306ULL, 0x000e62000000d400ULL,
0x0000000147470812ULL, 0x008fe400078efcffULL, 0x0000004a4c00720bULL, 0x000fe40003f1d000ULL,
0x000000473939723eULL, 0x000fc600000010ffULL, 0x0000003f00687306ULL, 0x000fe20000009400ULL,
0x0000000146466812ULL, 0x010fc600078efcffULL, 0x000000381820723cULL, 0x000b680000041820ULL,
0x0000003f00657306ULL, 0x000ea20000005400ULL, 0x0000000149494812ULL, 0x002fe400078efcffULL,
0x000000013b3b0812ULL, 0x000fe400078efcffULL, 0x00000049463c723eULL, 0x000fe400000010ffULL,
0x000176c878387811ULL, 0x020fe200078e18ffULL, 0x0000006b00527306ULL, 0x000ff00000209400ULL,
0x0000006b00547306ULL, 0x000e620000205400ULL, 0x000000656800720bULL, 0x004fce0003f7d000ULL,
0x0000003f003e7306ULL, 0x000eb0000000d400ULL, 0x0000005500507306ULL, 0x000fe20000209400ULL,
0x000000545200720bULL, 0x002fce0003f5d000ULL, 0x00000055003f7306ULL, 0x000e620000205400ULL,
0x000000013e3e3812ULL, 0x004fce00078efcffULL, 0x0000004300137306ULL, 0x000ff00000209400ULL,
0x0000004300587306ULL, 0x000ea20000205400ULL, 0x0000003f5000720bULL, 0x002fce0003fdd000ULL,
0x0000006b003d7306ULL, 0x000e70000020d400ULL, 0x0000005500557306ULL, 0x000ee2000020d400ULL,
0x000000581300720bULL, 0x004fce0003f9d000ULL, 0x0000004300067306ULL, 0x000ea2000020d400ULL,
0x000000013d3d2812ULL, 0x002fc800078efcffULL, 0x0000003e3d3d723eULL, 0x000fe400000010ffULL,
0x0000000155556812ULL, 0x008fc800078efcffULL, 0x000000553a3a723eULL, 0x000fe200000010ffULL,
0x0000003c181c723cULL, 0x000b62000004181cULL, 0x0000000106064812ULL, 0x004fc800078efcffULL,
0x000000063b3b723eULL, 0x000fe200000010ffULL, 0x0000000200067824ULL, 0x000fca00078e00ffULL,
0xfffffff806067812ULL, 0x000fe200078ec0ffULL, 0x0000003a1818723cULL, 0x000b620000041814ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000038387f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176880006ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff087224ULL, 0x000fc600078e00ffULL,
0x0000000000147805ULL, 0x020fc80000015200ULL, 0x0000040010137984ULL, 0x000ee40000000800ULL,
0x8000000013ff7812ULL, 0x00afe40007804839ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614137210ULL, 0x000fca0007f1e1ffULL,
0x0000000117167824ULL, 0x000fe200000e0e15ULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff1600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff1600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x004fc80000011416ULL,
0x0000001306067211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0616ULL,
0x0000000206067819ULL, 0x000fc80000001213ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040010137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000800f087810ULL, 0x000fca0007ffe0ffULL, 0x000068007b137a24ULL, 0x000fe200078e0208ULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x0000000877067217ULL, 0x004fe20007800000ULL,
0x0000001079157824ULL, 0x000fe200078e00ffULL, 0x00000003ff147819ULL, 0x000fc60000011602ULL,
0x0000000106067824ULL, 0x000fe200078e0a08ULL, 0x0000000414177810ULL, 0x040fe20007ffe0ffULL,
0x0000000115087824ULL, 0x040fe200078e0214ULL, 0x0000000814387810ULL, 0x000fe40007ffe0ffULL,
0x0000000615067217ULL, 0x000fe20007800000ULL, 0x0000000108167824ULL, 0x000fe200078e0202ULL,
0x0000000c14397810ULL, 0x000fe20007ffe0ffULL, 0x00000008083d7824ULL, 0x000fe400078e00ffULL,
0x0000000106067824ULL, 0x000fc400078e0a15ULL, 0x00000001153c7824ULL, 0x000fe200078e0239ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee216ULL, 0x0000000115167824ULL, 0x000fe200078e0217ULL,
0x000000061400720cULL, 0x080fe20003f86070ULL, 0x0000000108147824ULL, 0x000fe200078e0213ULL,
0x000000061700720cULL, 0x080fe20003f66070ULL, 0x0000000115177824ULL, 0x000fe200078e0238ULL,
0x000000063800720cULL, 0x080fe20003f46070ULL, 0x0000000116087824ULL, 0x040fe200078e0202ULL,
0x000000063900720cULL, 0x000fe20003f06070ULL, 0x00000008163f7824ULL, 0x000fc400078e00ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee208ULL,
0x0000000116167824ULL, 0x100fe200078e0213ULL, 0x0000006014147212ULL, 0x000fe200078efcffULL,
0x0000000117387824ULL, 0x040fe400078e0213ULL, 0x0000000117067824ULL, 0x040fe200078e0202ULL,
0x0000640014147a10ULL, 0x000fe20007fbe0ffULL, 0x0000000817397824ULL, 0x000fe400078e00ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000650015157a10ULL, 0x000fc60002ffe4ffULL,
0x000000013c3a7824ULL, 0x000fe200078e0213ULL, 0xfffffff839137812ULL, 0x000fe200078ee206ULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000006016167212ULL, 0x000fc600078efcffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000640016167a10ULL, 0x000fe40007fbe0ffULL,
0x0000006038387212ULL, 0x080fe200078efcffULL, 0x000000013c067824ULL, 0x000fe200078e0202ULL,
0x000000603a3a7212ULL, 0x000fe200078efcffULL, 0x000000083c417824ULL, 0x000fe200078e00ffULL,
0x0000650017177a10ULL, 0x000fe20002ffe4ffULL, 0x000000103d3d7824ULL, 0x100fe200078e026eULL,
0x0000640038387a10ULL, 0x000fe20007fbe0ffULL, 0x000000103f3f7824ULL, 0x000fe200078e026eULL,
0xfffffff841417812ULL, 0x000fe200078ee206ULL, 0x0000001013137824ULL, 0x100fe200078e026eULL,
0x000064003a3a7a10ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000e101c46ULL, 0x0000650039397a10ULL, 0x000fe20002ffe4ffULL,
0x0000001041417824ULL, 0x000fe200078e026eULL, 0x000065003b3b7a10ULL, 0x000fe200037fe4ffULL,
0x00000000163f7faeULL, 0x0003e8000d901c46ULL, 0x0000000038137faeULL, 0x0003e8000d101c46ULL,
0x000000003a417faeULL, 0x0003e2000c101c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001079157824ULL, 0x000fca00078e00ffULL, 0x0000001502157211ULL, 0x000fc800078fe8ffULL,
0x0000000815167810ULL, 0x040fe20007ffe0ffULL, 0x0000000115067824ULL, 0x144fe200078e0202ULL,
0x00000004153a7810ULL, 0x040fe20007ffe0ffULL, 0x00000008153d7824ULL, 0x000fe400078e00ffULL,
0x0000000116177824ULL, 0x040fe400078e0202ULL, 0x0000000816387824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee206ULL, 0x0000000115147824ULL, 0x040fe200078e0213ULL,
0x0000000c15067810ULL, 0x000fe20007ffe0ffULL, 0x000000013a087824ULL, 0x000fe200078e0202ULL,
0xfffffff838417812ULL, 0x000fe200078ee217ULL, 0x000000083a3f7824ULL, 0x000fc400078e00ffULL,
0x000000013a3a7824ULL, 0x000fe400078e0213ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fc600078ee208ULL, 0x0000000116167824ULL, 0x100fe200078e0213ULL,
0x0000006014147212ULL, 0x000fe200078efcffULL, 0x0000000106387824ULL, 0x000fe400078e0213ULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000640014147a10ULL, 0x000fc60007f1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x000000603a3a7212ULL, 0x080fe400078efcffULL,
0x0000650015157a10ULL, 0x000fe200007fe4ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000006016167212ULL, 0x080fe400078efcffULL, 0x000064003a3a7a10ULL, 0x000fe20007f5e0ffULL,
0x0000000106087824ULL, 0x000fe200078e0202ULL, 0x0000006038387212ULL, 0x000fe200078efcffULL,
0x0000000806137824ULL, 0x000fe200078e00ffULL, 0x0000640016167a10ULL, 0x000fe20007f1e0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e026eULL, 0x0000640038387a10ULL, 0x000fe20007f7e0ffULL,
0x000000103f3f7824ULL, 0x000fe200078e026eULL, 0xfffffff813137812ULL, 0x000fe200078ee208ULL,
0x0000001041417824ULL, 0x100fe200078e026eULL, 0x000065003b3b7a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143d7faeULL, 0x0003e2000b901c46ULL,
0x0000650017177a10ULL, 0x000fe200007fe4ffULL, 0x0000001013137824ULL, 0x000fe200078e026eULL,
0x0000650039397a10ULL, 0x000fe20001ffe4ffULL, 0x000000003a3f7faeULL, 0x0003e8000b901c46ULL,
0x0000000016417faeULL, 0x0003e8000b901c46ULL, 0x0000000038137faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000001078067824ULL, 0x000fe200078e00ffULL,
0xffffffe011137812ULL, 0x000fc400078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000811087812ULL, 0x000fe400078ec0ffULL, 0x0000001006067812ULL, 0x000fc800078ec0ffULL,
0x0000001308067210ULL, 0x000fe20007ffe006ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff147f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01762800063a7f8cULL, 0x0004e4000c80043fULL,
0x0000000000167805ULL, 0x000fc40000015200ULL, 0x01762c000e137984ULL, 0x000f240000000800ULL,
0x8000000013ff7812ULL, 0x018fe4000780483bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x0000003816137210ULL, 0x000fca0007f1e1ffULL, 0x0000000139387824ULL, 0x000fe200000e0e17ULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff3800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff3800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x004fc80000011438ULL, 0x0000001306067211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0638ULL, 0x0000000206067819ULL, 0x000fc80000001213ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01762c000e137984ULL, 0x000ee40000000800ULL, 0x8000000013ff7812ULL, 0x008fe4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000067824ULL, 0x004fca00078e00ffULL,
0xffffff8006137812ULL, 0x000fc800078ec0ffULL, 0x0000008060067810ULL, 0x000fca0007ffe013ULL,
0x0000000175067824ULL, 0x000fca00078e0206ULL, 0x0170000006167984ULL, 0x000ea80000000800ULL,
0x01720000063c7984ULL, 0x0006620000000800ULL, 0x000000031600720bULL, 0x004fe20003f1d000ULL,
0x00012da27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x008fc800000e0100ULL,
0x0000ffff13177812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff067424ULL, 0x000fe400078e00ffULL, 0x000000ffff087224ULL, 0x000fd200078e0003ULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x000000017c137810ULL, 0x000fe40007ffe0ffULL,
0x000000031600720bULL, 0x000fe40003f54000ULL, 0x000000001300720cULL, 0x000fe20003f05270ULL,
0x00012d527f007947ULL, 0x000fd4000b800000ULL, 0x0000000000067806ULL, 0x000fc400010e0100ULL,
0x0000008000388824ULL, 0x000fe200078e0260ULL, 0x0000000316087209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991006137816ULL, 0x000fe200000000ffULL,
0x0000000175398824ULL, 0x000fca00078e0238ULL, 0x0174000839008388ULL, 0x0005e20000000800ULL,
0x000000ff1300720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000308037221ULL, 0x004fe20000010100ULL, 0x000000ff06ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b03037820ULL, 0x000fc80000410000ULL,
0x00000003003e7308ULL, 0x000ea40000000800ULL, 0x0000003e07077220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x000fe20000011602ULL,
0x00012c927f007947ULL, 0x000fea000b800000ULL, 0x00001f133e137589ULL, 0x0004e400000e0000ULL,
0x0000001334347220ULL, 0x08cfe40000410000ULL, 0x0000001335357220ULL, 0x080fe40000410000ULL,
0x0000001330307220ULL, 0x080fe40000410000ULL, 0x0000001331317220ULL, 0x080fe40000410000ULL,
0x000000132c2c7220ULL, 0x080fe40000410000ULL, 0x000000132d2d7220ULL, 0x000fc40000410000ULL,
0x0000001328287220ULL, 0x080fe40000410000ULL, 0x0000001329297220ULL, 0x080fe40000410000ULL,
0x0000001324247220ULL, 0x080fe40000410000ULL, 0x0000001325257220ULL, 0x080fe40000410000ULL,
0x0000001320207220ULL, 0x080fe40000410000ULL, 0x0000001321217220ULL, 0x000fc40000410000ULL,
0x000000131c1c7220ULL, 0x080fe40000410000ULL, 0x000000131d1d7220ULL, 0x080fe40000410000ULL,
0x0000001318187220ULL, 0x080fe40000410000ULL, 0x0000001319197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0006ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802137811ULL, 0x000fe200078ff0ffULL,
0x00012b927f007947ULL, 0x000fea000b800000ULL, 0x00001f133e137589ULL, 0x0004e400000e0000ULL,
0x0000001336367220ULL, 0x08cfe40000410000ULL, 0x0000001337377220ULL, 0x080fe40000410000ULL,
0x0000001332327220ULL, 0x080fe40000410000ULL, 0x0000001333337220ULL, 0x080fe40000410000ULL,
0x000000132e2e7220ULL, 0x080fe40000410000ULL, 0x000000132f2f7220ULL, 0x000fc40000410000ULL,
0x000000132a2a7220ULL, 0x080fe40000410000ULL, 0x000000132b2b7220ULL, 0x080fe40000410000ULL,
0x0000001326267220ULL, 0x080fe40000410000ULL, 0x0000001327277220ULL, 0x080fe40000410000ULL,
0x0000001322227220ULL, 0x080fe40000410000ULL, 0x0000001323237220ULL, 0x000fc40000410000ULL,
0x000000131e1e7220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x080fe40000410000ULL,
0x000000131a1a7220ULL, 0x080fe40000410000ULL, 0x000000131b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff17ff7812ULL, 0x000fe20007806006ULL,
0x00000001ff067424ULL, 0x000fd800078e00ffULL, 0x8000000816160221ULL, 0x000fe20000010000ULL,
0x00007610ff060816ULL, 0x000fc60000000006ULL, 0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL,
0x00000016000d0308ULL, 0x000ea40000000800ULL, 0x0000000d3c3c0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000073c077221ULL, 0x002fc40000010000ULL,
0x0000000000167805ULL, 0x000fca0000015200ULL, 0xfffffff0113a7812ULL, 0x000fca00078ec0ffULL,
0x0176b4003a037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x0000003816387210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e17ULL, 0x003d09003800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011439ULL,
0x0000003803037211ULL, 0x000fca00078110ffULL, 0x000000ffff387224ULL, 0x000fca00000e0639ULL,
0x0000000203037819ULL, 0x000fc80000001238ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000113137810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176b4003a037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991006037816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x0000000dff03723eULL, 0x000fe400000010ffULL, 0x00000002ff047819ULL, 0x000fe40000011602ULL,
0x0000541003037816ULL, 0x000fe20000000003ULL, 0x000127827f007947ULL, 0x000fea000b800000ULL,
0x00001f04030c7589ULL, 0x0002a400000e0000ULL, 0x0000000804137810ULL, 0x000fe20007ffe0ffULL,
0x000127d27f007947ULL, 0x000fea000b800000ULL, 0x00001f13030b7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001004137810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff387224ULL, 0x000fe200078e0003ULL, 0x0000649000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0001322000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001804137810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff387224ULL, 0x000fe200078e0003ULL,
0x0000650000397802ULL, 0x000fe20000000f00ULL, 0x0000001fff3b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x000131b000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002006f7824ULL, 0x000fe200078e00ffULL,
0x0000000702047812ULL, 0x002fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x000000046f037812ULL, 0x008fe400078ec0ffULL, 0x0000000804067812ULL, 0x000fe400078ef802ULL,
0x0000000302037211ULL, 0x000fc600078fe0ffULL, 0x0000000806057824ULL, 0x040fe400078e00ffULL,
0x0000000106067824ULL, 0x000fe200078e0203ULL, 0x0000000802037812ULL, 0x000fc800078ec0ffULL,
0xfffffff805057812ULL, 0x000fca00078ee206ULL, 0x0000001005057824ULL, 0x000fc400078e020aULL,
0x0000000400137824ULL, 0x004fe200078e00ffULL, 0x0000000403037212ULL, 0x000fe400078efcffULL,
0x000010006e747810ULL, 0x000fe40007ffe0ffULL, 0x0000000413137812ULL, 0x000fe200078ec0ffULL,
0x00000008036b7824ULL, 0x000fe200078e00ffULL, 0xfffffff86f6f7812ULL, 0x000fe400078ec0ffULL,
0x0000001302047211ULL, 0x000fe200078fe0ffULL, 0x0000000809137824ULL, 0x000fc800078e00ffULL,
0x0000000103407824ULL, 0x100fe400078e0204ULL, 0x0000000109167824ULL, 0x000fc600078e0204ULL,
0xfffffff86b6b7812ULL, 0x000fe400078ee240ULL, 0xfffffff813507812ULL, 0x000fe400078ee216ULL,
0x0000000216167810ULL, 0x000fe20007ffe0ffULL, 0x000000106b6b7824ULL, 0x100fe400078e0274ULL,
0x0000001050387824ULL, 0x000fc600078e0274ULL, 0x000000006b3c783bULL, 0x000e680000004200ULL,
0x000000003838783bULL, 0x000ea20000004200ULL, 0x00000018ff417819ULL, 0x002fe2000001143eULL,
0x0000003c005b7306ULL, 0x000fe20000009400ULL, 0x00000018ff137819ULL, 0x000fe4000001143cULL,
0x00000018ff427819ULL, 0x000fe4000001143fULL, 0x00000018ff437819ULL, 0x004fc40000011439ULL,
0x00000018ff177819ULL, 0x000fe2000001143dULL, 0x00000041005d7306ULL, 0x000fe20000209400ULL,
0x00000018ff4f7819ULL, 0x000fce000001143aULL, 0x00000041005c7306ULL, 0x000ff00000205400ULL,
0x0000004100637306ULL, 0x0003f0000020d400ULL, 0x0000001300597306ULL, 0x000fe20000209400ULL,
0x000001003c417824ULL, 0x002fca00078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000001300647306ULL, 0x000e700000205400ULL, 0x0000001300547306ULL, 0x0004f0000020d400ULL,
0x0000004200537306ULL, 0x000fe20000209400ULL, 0x00000018ff137819ULL, 0x004fc40000011438ULL,
0x000000645900720bULL, 0x002fca0003f9d000ULL, 0x00000042006a7306ULL, 0x000ff00000205400ULL,
0x0000004200627306ULL, 0x0003e2000020d400ULL, 0x0000000154544812ULL, 0x008fce00078efcffULL,
0x00000041006c7306ULL, 0x000fe20000209400ULL, 0x00000018ff427819ULL, 0x002fce000001143bULL,
0x0000004100617306ULL, 0x000e700000205400ULL, 0x00000013004d7306ULL, 0x000ff00000209400ULL,
0x00000013004c7306ULL, 0x000fe20000205400ULL, 0x000000616c00720bULL, 0x002fce0003fbd000ULL,
0x0000001300447306ULL, 0x000ff0000020d400ULL, 0x00000042004b7306ULL, 0x000ff00000209400ULL,
0x0000004200467306ULL, 0x000ff00000205400ULL, 0x0000004200137306ULL, 0x0003f0000020d400ULL,
0x0000004300497306ULL, 0x000fe20000209400ULL, 0x000001003d427824ULL, 0x002fca00078e00ffULL,
0x00000018ff697819ULL, 0x000fe40000011442ULL, 0x0000004300477306ULL, 0x000ff00000205400ULL,
0x0000004300457306ULL, 0x000ff0000020d400ULL, 0x0000004100577306ULL, 0x0002b0000020d400ULL,
0x0000006900437306ULL, 0x000fe20000209400ULL, 0x000100003d417824ULL, 0x002fca00078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe40000011441ULL, 0x0000006900587306ULL, 0x000e620000205400ULL,
0x0000000157575812ULL, 0x004fce00078efcffULL, 0x0000003c00687306ULL, 0x000eb00000005400ULL,
0x0000003c004e7306ULL, 0x000722000000d400ULL, 0x000000584300720bULL, 0x002fe20003fbd000ULL,
0x0000000803587824ULL, 0x000fe200078e00ffULL, 0x0000000240037810ULL, 0x000fe20007ffe0ffULL,
0x000001003f437824ULL, 0x000fc600078e00ffULL, 0xfffffff858037812ULL, 0x000fe200078ee203ULL,
0x0000003d005a7306ULL, 0x000fe20000009400ULL, 0x000100003c3c7824ULL, 0x008fe200078e00ffULL,
0x000000685b00720bULL, 0x004fe40003f5d000ULL, 0x0000001003407824ULL, 0x000fe200078e0274ULL,
0x00000018ff687819ULL, 0x000fe40000011443ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000003d00677306ULL, 0x000e6e0000005400ULL, 0x000000014e4e2812ULL, 0x010fe200078efcffULL,
0x0000006d00417306ULL, 0x000fe60000209400ULL, 0x0000004e574e723eULL, 0x000fca00000010ffULL,
0x0000006d00427306ULL, 0x000ea20000205400ULL, 0x000000675a00720bULL, 0x002fce0003f7d000ULL,
0x0000003c00657306ULL, 0x000ff00000209400ULL, 0x0000003c00707306ULL, 0x000e620000205400ULL,
0x000000424100720bULL, 0x004fe40003f5d000ULL, 0x000000004040783bULL, 0x000eaa0000004200ULL,
0x0000003c00567306ULL, 0x000730000020d400ULL, 0x00000017005e7306ULL, 0x000fe20000209400ULL,
0x000001003e3c7824ULL, 0x048fe200078e00ffULL, 0x000000706500720bULL, 0x002fe20003fdd000ULL,
0x000100003e657824ULL, 0x000fc600078e00ffULL, 0x00000018ff647819ULL, 0x000fe4000001143cULL,
0x00000017005f7306ULL, 0x000fee0000205400ULL, 0x0000000156566812ULL, 0x010fe200078efcffULL,
0x0000001700557306ULL, 0x000fe6000020d400ULL, 0x000000565454723eULL, 0x000fca00000010ffULL,
0x0000004f00487306ULL, 0x000fe20000209400ULL, 0x00000018ff577819ULL, 0x004fce0000011443ULL,
0x0000004f004a7306ULL, 0x000ff00000205400ULL, 0x0000004f00177306ULL, 0x000ff0000020d400ULL,
0x0000003d004f7306ULL, 0x000e70000000d400ULL, 0x00000064003c7306ULL, 0x000ff00000209400ULL,
0x00000064003d7306ULL, 0x000ea20000205400ULL, 0x000000014f4f3812ULL, 0x002fce00078efcffULL,
0x0000006400597306ULL, 0x000e70000020d400ULL, 0x0000003f00647306ULL, 0x000fe20000009400ULL,
0x0000003d3c00720bULL, 0x004fce0003f7d000ULL, 0x0000003f00677306ULL, 0x000eac0000005400ULL,
0x0000000159593812ULL, 0x002fe400078efcffULL, 0x0000003e005a7306ULL, 0x000fe20000009400ULL,
0x0000006a5300720bULL, 0x000fce0003f7d000ULL, 0x0000003e005b7306ULL, 0x000e620000005400ULL,
0x000000676400720bULL, 0x004fe20003f9d000ULL, 0x000100003f647824ULL, 0x000fc800078e00ffULL,
0x0000000162623812ULL, 0x000fe400078efcffULL, 0x0000006d00517306ULL, 0x0004f0000020d400ULL,
0x0000006800617306ULL, 0x000fe20000209400ULL, 0x00000018ff6d7819ULL, 0x004fc40000011464ULL,
0x0000005b5a00720bULL, 0x002fca0003fdd000ULL, 0x00000068006c7306ULL, 0x000e620000205400ULL,
0x0000000151512812ULL, 0x008fce00078efcffULL, 0x0000006900527306ULL, 0x0004f0000020d400ULL,
0x0000006800587306ULL, 0x000f22000020d400ULL, 0x0000006c6100720bULL, 0x002fe40003f5d000ULL,
0x00000018ff697819ULL, 0x004fc40000011465ULL, 0x00000018ff617819ULL, 0x000fc60000011441ULL,
0x0000003e005a7306ULL, 0x000e62000000d400ULL, 0x0000000152525812ULL, 0x008fe400078efcffULL,
0x0000005f5e00720bULL, 0x000fe40003fbd000ULL, 0x00000018ff5f7819ULL, 0x000fe40000011440ULL,
0x0000004f524f723eULL, 0x000fe200000010ffULL, 0x0000006d003e7306ULL, 0x000fe20000209400ULL,
0x0000000158582812ULL, 0x010fce00078efcffULL, 0x0000006d00677306ULL, 0x000ea20000205400ULL,
0x0000000155555812ULL, 0x000fe400078efcffULL, 0x0000005c5d00720bULL, 0x000fe40003fbd000ULL,
0x000000015a5a6812ULL, 0x002fe400078efcffULL, 0x000000515555723eULL, 0x000fe200000010ffULL,
0x0000006900707306ULL, 0x000ff00000209400ULL, 0x0000006900657306ULL, 0x000e620000205400ULL,
0x000000673e00720bULL, 0x004fe20003f5d000ULL, 0x00000100403e7824ULL, 0x000fe200078e00ffULL,
0x0000000163635812ULL, 0x000fc800078efcffULL, 0x00000018ff677819ULL, 0x000fe2000001143eULL,
0x0000006900687306ULL, 0x0005f0000020d400ULL, 0x0000003f005b7306ULL, 0x000ee2000000d400ULL,
0x00000018ff697819ULL, 0x004fc40000011442ULL, 0x000000657000720bULL, 0x002fca0003fdd000ULL,
0x0000005f003f7306ULL, 0x000ff00000209400ULL, 0x0000005f00727306ULL, 0x000e620000205400ULL,
0x000000015b5b4812ULL, 0x008fe400078efcffULL, 0x0000000168686812ULL, 0x000fca00078efcffULL,
0x00000061003c7306ULL, 0x000ff00000209400ULL, 0x00000061003d7306ULL, 0x000ea20000205400ULL,
0x000000723f00720bULL, 0x002fce0003f9d000ULL, 0x0000006d00647306ULL, 0x0002f0000020d400ULL,
0x0000005f005e7306ULL, 0x000f22000020d400ULL, 0x0000003d3c00720bULL, 0x004fe20003fdd000ULL,
0x00000100386d7824ULL, 0x002fe200078e00ffULL, 0x01180000053c783bULL, 0x000e680000000200ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x00000061005d7306ULL, 0x000ea2000020d400ULL,
0x0000000164642812ULL, 0x008fce00078efcffULL, 0x00000069005f7306ULL, 0x000fe20000209400ULL,
0x000000015e5e4812ULL, 0x010fce00078efcffULL, 0x00000069006a7306ULL, 0x000ee20000205400ULL,
0x000000015d5d6812ULL, 0x004fce00078efcffULL, 0x0000006700617306ULL, 0x000ff00000209400ULL,
0x00000067006c7306ULL, 0x000ea20000205400ULL, 0x0000006a5f00720bULL, 0x008fe20003fbd000ULL,
0x0000000c3c3c8231ULL, 0x002fc400003400ffULL, 0x0000000c3e3e8231ULL, 0x000fe400003400ffULL,
0x0000000b3d3d8231ULL, 0x080fe400003400ffULL, 0x00000040005c7306ULL, 0x000fe20000009400ULL,
0x0000000b3f3f8231ULL, 0x000fce00003400ffULL, 0x0000004000657306ULL, 0x000e620000005400ULL,
0x0000006c6100720bULL, 0x004fe20003f5d000ULL, 0x000000543c30723cULL, 0x040b6c0000041830ULL,
0x00000067005f7306ULL, 0x000ea2000020d400ULL, 0x0000005a5954723eULL, 0x020fe200000010ffULL,
0x0000004e3c34723cULL, 0x000fe20000041834ULL, 0x0000005b5855723eULL, 0x000fc400000010ffULL,
0x000000655c00720bULL, 0x002fc60003f7d000ULL, 0x0000004000617306ULL, 0x000e62000000d400ULL,
0x0000010041657824ULL, 0x000fe200078e00ffULL, 0x000000543c2c723cULL, 0x000b68000004182cULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000041005c7306ULL, 0x000fe20000009400ULL,
0x000000015f5f2812ULL, 0x004fe200078efcffULL, 0x0000010039557824ULL, 0x020fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011455ULL, 0x0000004100677306ULL, 0x000ea20000005400ULL,
0x0000000161613812ULL, 0x002fe400078efcffULL, 0x000000646255723eULL, 0x000fca00000010ffULL,
0x0000006900537306ULL, 0x000e70000020d400ULL, 0x00000065006a7306ULL, 0x000fe20000209400ULL,
0x000000675c00720bULL, 0x004fe20003f7d000ULL, 0x00010000405c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0000006500697306ULL, 0x000ea20000205400ULL,
0x0000000153535812ULL, 0x002fce00078efcffULL, 0x0000004100677306ULL, 0x000e62000000d400ULL,
0x000000696a00720bULL, 0x004fce0003f5d000ULL, 0x0000006500657306ULL, 0x000ea2000020d400ULL,
0x0000000167673812ULL, 0x002fce00078efcffULL, 0x0000005c00697306ULL, 0x000ff00000209400ULL,
0x0000005c006a7306ULL, 0x000e620000205400ULL, 0x0000000165652812ULL, 0x004fce00078efcffULL,
0x0000005700527306ULL, 0x000ff00000209400ULL, 0x00000057006c7306ULL, 0x000ea20000205400ULL,
0x0000006a6900720bULL, 0x002fe20003f7d000ULL, 0x0001000041697824ULL, 0x000fc400078e00ffULL,
0x00000100426a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x0000003800517306ULL, 0x000fe20000009400ULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x0000006c5200720bULL, 0x004fca0003f5d000ULL, 0x0000003800567306ULL, 0x000fe20000005400ULL,
0x00010000386c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000003800527306ULL, 0x000ff0000000d400ULL, 0x0000005c00387306ULL, 0x000e70000020d400ULL,
0x0000006d004e7306ULL, 0x000ff00000209400ULL, 0x0000006d004f7306ULL, 0x000fe20000205400ULL,
0x0000000138383812ULL, 0x002fce00078efcffULL, 0x0000006d00407306ULL, 0x000ff0000020d400ULL,
0x0000006900417306ULL, 0x000ff00000209400ULL, 0x0000006900587306ULL, 0x000e700000205400ULL,
0x0000006a006d7306ULL, 0x000ff00000209400ULL, 0x0000006a00547306ULL, 0x000ea20000205400ULL,
0x000000584100720bULL, 0x002fce0003f7d000ULL, 0x0000006c005c7306ULL, 0x000ff00000209400ULL,
0x0000006c00597306ULL, 0x000fe20000205400ULL, 0x000000546d00720bULL, 0x004fe40003f9d000ULL,
0x000000686354723eULL, 0x000fe200000010ffULL, 0x0000010043637824ULL, 0x000fc800078e00ffULL,
0x0000006c00417306ULL, 0x000fe2000020d400ULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x000000543c28723cULL, 0x000bec0000041828ULL, 0x0000006900697306ULL, 0x000e62000020d400ULL,
0x000000676555723eULL, 0x020fe200000010ffULL, 0x000001003a677824ULL, 0x000fe200078e00ffULL,
0x000000615f54723eULL, 0x000fc800000010ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x00000042006d7306ULL, 0x000fe40000009400ULL, 0x000000543c24723cULL, 0x000b6c0000041824ULL,
0x00000042006c7306ULL, 0x000ea20000005400ULL, 0x0000000169693812ULL, 0x002fc400078efcffULL,
0x000000385e54723eULL, 0x020fe200000010ffULL, 0x0001000043387824ULL, 0x000fe200078e00ffULL,
0x000000695d55723eULL, 0x000fc600000010ffULL, 0x0000006a00627306ULL, 0x000e68000020d400ULL,
0x000000543c20723cULL, 0x000b680000041820ULL, 0x0000004200647306ULL, 0x000ee2000000d400ULL,
0x0000006c6d00720bULL, 0x004fe20003f7d000ULL, 0x00010000426d7824ULL, 0x000fc400078e00ffULL,
0x0001000039557824ULL, 0x020fc600078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x00000043006a7306ULL, 0x000fe20000009400ULL, 0x0000000162624812ULL, 0x002fce00078efcffULL,
0x0000004300657306ULL, 0x000e620000005400ULL, 0x0000000164643812ULL, 0x008fce00078efcffULL,
0x00000070005a7306ULL, 0x000ff00000209400ULL, 0x00000070005b7306ULL, 0x000fe20000205400ULL,
0x000000656a00720bULL, 0x002fe40003f7d000ULL, 0x00000018ff657819ULL, 0x000fc40000011438ULL,
0x000000646238723eULL, 0x000fe400000010ffULL, 0x00000018ff647819ULL, 0x000fe20000011455ULL,
0x0000007000587306ULL, 0x000ff0000020d400ULL, 0x0000006300687306ULL, 0x000ff00000209400ULL,
0x0000006300707306ULL, 0x000e700000205400ULL, 0x0000006300637306ULL, 0x000eb0000020d400ULL,
0x00000043005e7306ULL, 0x000ee2000000d400ULL, 0x000000706800720bULL, 0x002fe20003fdd000ULL,
0x000100003a687824ULL, 0x000fca00078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011468ULL,
0x0000006d006c7306ULL, 0x000fec0000209400ULL, 0x0000000163636812ULL, 0x004fe400078efcffULL,
0x0000006d005f7306ULL, 0x000e620000205400ULL, 0x000000015e5e3812ULL, 0x008fce00078efcffULL,
0x00000065005d7306ULL, 0x000ff00000209400ULL, 0x0000006500547306ULL, 0x000ea20000205400ULL,
0x0000005f6c00720bULL, 0x002fce0003f9d000ULL, 0x0000005700577306ULL, 0x000e70000020d400ULL,
0x0000006d00617306ULL, 0x000ee2000020d400ULL, 0x000000545d00720bULL, 0x004fce0003f7d000ULL,
0x0000006500627306ULL, 0x000ea2000020d400ULL, 0x0000000157572812ULL, 0x002fe400078efcffULL,
0x0000004f4e00720bULL, 0x000fca0003f5d000ULL, 0x0000003900427306ULL, 0x000fe20000009400ULL,
0x0000000161614812ULL, 0x008fe400078efcffULL, 0x000000595c00720bULL, 0x000fca0003f9d000ULL,
0x00000039005f7306ULL, 0x000e620000005400ULL, 0x0000000162623812ULL, 0x004fe400078efcffULL,
0x000000565100720bULL, 0x000fe20003f7d000ULL, 0x000100003b567824ULL, 0x000fe200078e00ffULL,
0x0000000140402812ULL, 0x000fc600078efcffULL, 0x0000003900437306ULL, 0x0005e2000000d400ULL,
0x0000000141414812ULL, 0x000fe400078efcffULL, 0x0000005b5a00720bULL, 0x000fe40003f9d000ULL,
0x00000018ff567819ULL, 0x000fc60000011456ULL, 0x0000003a00707306ULL, 0x000fe20000009400ULL,
0x0000005e6339723eULL, 0x004fe400000010ffULL, 0x0000000152523812ULL, 0x000fe400078efcffULL,
0x0000004c4d00720bULL, 0x000fe40003f7d000ULL, 0x0000005f4200720bULL, 0x002fe20003fdd000ULL,
0x000000383c1c723cULL, 0x000b62000004181cULL, 0x0000003a00717306ULL, 0x000e620000005400ULL,
0x0000000158584812ULL, 0x000fc400078efcffULL, 0x0000004a4800720bULL, 0x000fe40003f9d000ULL,
0x000000524052723eULL, 0x000fe200000010ffULL, 0x0000000809397824ULL, 0x020fe200078e00ffULL,
0x000000615338723eULL, 0x000fe200000010ffULL, 0x0000006400557306ULL, 0x000fe20000209400ULL,
0x0000000144443812ULL, 0x000fe400078efcffULL, 0xfffffff839167812ULL, 0x000fe400078ee216ULL,
0x000000625739723eULL, 0x000fc400000010ffULL, 0x000000474900720bULL, 0x000fe20003f7d000ULL,
0x0000001016617824ULL, 0x000fe200078e0274ULL, 0x0000003a00627306ULL, 0x000ea2000000d400ULL,
0x000000717000720bULL, 0x002fe40003fbd000ULL, 0x000000383c3c723cULL, 0x000b620000041818ULL,
0x0000000143436812ULL, 0x000fe200078efcffULL, 0x000000006118783bULL, 0x0202e20000004200ULL,
0x0000000117174812ULL, 0x000fe400078efcffULL, 0x0000003b00397306ULL, 0x000fe20000005400ULL,
0x000000414444723eULL, 0x000fe200000010ffULL, 0x000001003b387824ULL, 0x000fe200078e00ffULL,
0x0000000145453812ULL, 0x000fc800078efcffULL, 0x00000018ff697819ULL, 0x000fe20000011438ULL,
0x0000003b00617306ULL, 0x002fe2000000d400ULL, 0x0000000162625812ULL, 0x004fce00078efcffULL,
0x0000003b00387306ULL, 0x000e700000009400ULL, 0x0000006400547306ULL, 0x000ea20000205400ULL,
0x000000393800720bULL, 0x002fce0003f5d000ULL, 0x00000064005d7306ULL, 0x000e62000020d400ULL,
0x00000018ff3a7819ULL, 0x008fe20000011418ULL, 0x0000010018487824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011419ULL, 0x00000100194a7824ULL, 0x000fc800078e00ffULL,
0x0000003a006c7306ULL, 0x000fe20000209400ULL, 0x00000018ff717819ULL, 0x000fe2000001141aULL,
0x000001001b407824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011448ULL,
0x000000545500720bULL, 0x004fe40003fdd000ULL, 0x00000018ff5a7819ULL, 0x000fe2000001144aULL,
0x0000003a006d7306ULL, 0x000fe20000205400ULL, 0x0000000161612812ULL, 0x000fe400078efcffULL,
0x00000018ff5b7819ULL, 0x000fca000001141bULL, 0x0000003a004e7306ULL, 0x0005e4000020d400ULL,
0x000000015d5d6812ULL, 0x002fc800078efcffULL, 0x0000005d4545723eULL, 0x000fe400000010ffULL,
0x00000067005e7306ULL, 0x000fe20000209400ULL, 0x011800001238783bULL, 0x004e6e0000000200ULL,
0x0000006700537306ULL, 0x000eb00000205400ULL, 0x0000006900647306ULL, 0x000ff00000209400ULL,
0x0000006900657306ULL, 0x000ee20000205400ULL, 0x000000535e00720bULL, 0x004fe20003fdd000ULL,
0x0001000018537824ULL, 0x000fca00078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x0000006900577306ULL, 0x000eb0000020d400ULL, 0x0000005600697306ULL, 0x000fe20000209400ULL,
0x0000000c38388231ULL, 0x082fe200003400ffULL, 0x000000656400720bULL, 0x008fe20003f7d000ULL,
0x0000000c3a3a8231ULL, 0x000fc400003400ffULL, 0x0000000b39398231ULL, 0x080fe400003400ffULL,
0x0000000b3b3b8231ULL, 0x000fe200003400ffULL, 0x00000056006a7306ULL, 0x000e620000205400ULL,
0x000000464b00720bULL, 0x000fca0003f1d000ULL, 0x000000443830723cULL, 0x000b620000041830ULL,
0x0000000157573812ULL, 0x004fe200078efcffULL, 0x00000056004f7306ULL, 0x000eac000020d400ULL,
0x0000000113130812ULL, 0x000fe400078efcffULL, 0x00000070005f7306ULL, 0x000fe20000209400ULL,
0x0000006a6900720bULL, 0x002fce0003f5d000ULL, 0x00000070005c7306ULL, 0x000fec0000205400ULL,
0x000000014f4f2812ULL, 0x004fe400078efcffULL, 0x0000007000427306ULL, 0x000ff0000020d400ULL,
0x0000007100567306ULL, 0x000ff00000209400ULL, 0x0000007100597306ULL, 0x000ff00000205400ULL,
0x00000071004c7306ULL, 0x000ff0000020d400ULL, 0x0000004900717306ULL, 0x000ff00000209400ULL,
0x0000004900707306ULL, 0x000e700000205400ULL, 0x0000004900487306ULL, 0x000eb0000020d400ULL,
0x0000001900497306ULL, 0x000fe20000009400ULL, 0x000000707100720bULL, 0x002fce0003f9d000ULL,
0x00000019004a7306ULL, 0x000e6c0000005400ULL, 0x0000000148484812ULL, 0x004fe400078efcffULL,
0x0000006700637306ULL, 0x000eb0000020d400ULL, 0x0000007200677306ULL, 0x000fe20000209400ULL,
0x0000004a4900720bULL, 0x002fe20003fbd000ULL, 0x0001000019497824ULL, 0x000fca00078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011449ULL, 0x0000007200687306ULL, 0x000e620000205400ULL,
0x000001001a497824ULL, 0x000fe200078e00ffULL, 0x0000000163636812ULL, 0x004fc800078efcffULL,
0x00000018ff767819ULL, 0x000fe40000011449ULL, 0x00000018004b7306ULL, 0x000fe20000009400ULL,
0x000000626362723eULL, 0x000fe400000010ffULL, 0x000000615763723eULL, 0x000fca00000010ffULL,
0x0000001800547306ULL, 0x000ea20000005400ULL, 0x000000686700720bULL, 0x002fe20003f7d000ULL,
0x00000062382c723cULL, 0x000f6c000004182cULL, 0x0000007200517306ULL, 0x000e70000020d400ULL,
0x0000005a00557306ULL, 0x000fe20000209400ULL, 0x000000544b00720bULL, 0x004fce0003fdd000ULL,
0x0000005a00727306ULL, 0x000ea20000205400ULL, 0x0000000151513812ULL, 0x002fe400078efcffULL,
0x0000006d6c00720bULL, 0x000fe40003f7d000ULL, 0x00000018ff6c7819ULL, 0x000fc60000011440ULL,
0x0000005300647306ULL, 0x000ff00000209400ULL, 0x0000005300657306ULL, 0x000e620000205400ULL,
0x000000725500720bULL, 0x004fe40003f5d000ULL, 0x000000014e4e3812ULL, 0x000fc400078efcffULL,
0x000000595600720bULL, 0x000fc60003f7d000ULL, 0x0000005b004d7306ULL, 0x000ff00000209400ULL,
0x0000005b00477306ULL, 0x000fe20000205400ULL, 0x000000656400720bULL, 0x002fe20003f1d000ULL,
0x000100001a647824ULL, 0x000fe200078e00ffULL, 0x000000014c4c3812ULL, 0x000fe200078efcffULL,
0x000100001b657824ULL, 0x000fc600078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x0000005b00127306ULL, 0x000fe2000020d400ULL, 0x00000018ff5d7819ULL, 0x000fce0000011465ULL,
0x0000005a00467306ULL, 0x000e70000020d400ULL, 0x00000053004a7306ULL, 0x0004f0000020d400ULL,
0x00000073005b7306ULL, 0x000fe20000209400ULL, 0x000000435853723eULL, 0x004fc400000010ffULL,
0x0000000146462812ULL, 0x002fca00078efcffULL, 0x00000073005e7306ULL, 0x000e620000205400ULL,
0x000000523834723cULL, 0x000b620000041834ULL, 0x000000014a4a0812ULL, 0x008fcc00078efcffULL,
0x0000007600547306ULL, 0x000ff00000209400ULL, 0x00000076005a7306ULL, 0x000ea20000205400ULL,
0x0000005e5b00720bULL, 0x002fce0003f5d000ULL, 0x00000018004b7306ULL, 0x000e70000000d400ULL,
0x0000001900187306ULL, 0x000ee2000000d400ULL, 0x0000005a5400720bULL, 0x004fce0003f1d000ULL,
0x0000001a00677306ULL, 0x000fe20000009400ULL, 0x000000014b4b6812ULL, 0x002fc800078efcffULL,
0x0000004b4844723eULL, 0x020fc600000010ffULL, 0x0000001a00687306ULL, 0x000e620000005400ULL,
0x0000000118185812ULL, 0x008fe400078efcffULL, 0x0000005c5f00720bULL, 0x000fe40003fbd000ULL,
0x000000184645723eULL, 0x000fe400000010ffULL, 0x0000004a4e18723eULL, 0x000fe200000010ffULL,
0x0000007300197306ULL, 0x000ea8000020d400ULL, 0x000000443824723cULL, 0x000b680000041824ULL,
0x0000007600497306ULL, 0x000ee2000020d400ULL, 0x000000686700720bULL, 0x002fc40003f9d000ULL,
0x0000000142425812ULL, 0x000fca00078efcffULL, 0x0000001a00527306ULL, 0x000322000000d400ULL,
0x0000000119192812ULL, 0x004fe400078efcffULL, 0x000000474d00720bULL, 0x000fe40003f5d000ULL,
0x000000194219723eULL, 0x000fc600000010ffULL, 0x0000001b00697306ULL, 0x000fe20000009400ULL,
0x0000000149490812ULL, 0x008fe400078efcffULL, 0x00000051171a723eULL, 0x002fe200000010ffULL,
0x000000183820723cULL, 0x000b680000041820ULL, 0x0000001b006a7306ULL, 0x000e620000005400ULL,
0x0000000152524812ULL, 0x010fe400078efcffULL, 0x0000000112122812ULL, 0x000fc400078efcffULL,
0x000000524942723eULL, 0x000fc600000010ffULL, 0x0000006c00587306ULL, 0x000ff00000209400ULL,
0x0000006c00557306ULL, 0x000ea20000205400ULL, 0x0000006a6900720bULL, 0x002fce0003fdd000ULL,
0x0000006400537306ULL, 0x000ff00000209400ULL, 0x0000006400417306ULL, 0x000e620000205400ULL,
0x000000555800720bULL, 0x004fce0003fbd000ULL, 0x0000005d005b7306ULL, 0x000ff00000209400ULL,
0x0000005d00547306ULL, 0x000ea20000205400ULL, 0x000000415300720bULL, 0x002fce0003f1d000ULL,
0x0000001b00437306ULL, 0x0002f0000000d400ULL, 0x0000006c00407306ULL, 0x000f22000020d400ULL,
0x0000004f131b723eULL, 0x002fe400000010ffULL, 0x000000545b00720bULL, 0x004fca0003f9d000ULL,
0x0000006400137306ULL, 0x000e62000020d400ULL, 0x0000000143436812ULL, 0x008fe200078efcffULL,
0x0000001a3828723cULL, 0x000b6c0000041828ULL, 0x0000005d004d7306ULL, 0x000ea2000020d400ULL,
0x0000000140405812ULL, 0x010fc800078efcffULL, 0x000000434043723eULL, 0x000fe400000010ffULL,
0x0000000113130812ULL, 0x002fc800078efcffULL, 0x000000134c4c723eULL, 0x000fe200000010ffULL,
0x00000042381c723cULL, 0x000b62000004181cULL, 0x000000014d4d4812ULL, 0x004fc800078efcffULL,
0x0000004d124d723eULL, 0x000fe400000010ffULL, 0x000176c878127811ULL, 0x000fca00078e18ffULL,
0x0000004c383c723cULL, 0x000b62000004183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000012127f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x017690006fff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff177224ULL, 0x000fc600078e00ffULL, 0x0000000000187805ULL, 0x020fc80000015200ULL,
0x00000400101b7984ULL, 0x000ee40000000800ULL, 0x800000001bff7812ULL, 0x00afe40007804813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fcc0000015200ULL,
0x0000001a18397210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e19ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1a7819ULL, 0x000fc8000001141bULL, 0x000000391a1a7211ULL, 0x000fca00078110ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e061bULL, 0x000000021a1a7819ULL, 0x000fc8000000121bULL,
0x0000001a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000117177810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400101b7984ULL, 0x000e640000000800ULL, 0x800000001bff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c00f187810ULL, 0x000fca0007ffe0ffULL,
0x000068007b387a24ULL, 0x000fe200078e0218ULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x0000001877127217ULL, 0x000fe20007800000ULL, 0x0000001079177824ULL, 0x000fe200078e00ffULL,
0x00000003ff137819ULL, 0x000fc60000011602ULL, 0x0000000112127824ULL, 0x000fe200078e0a18ULL,
0x00000004131a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000117197824ULL, 0x000fe200078e0213ULL,
0x0000000813397810ULL, 0x000fe40007ffe0ffULL, 0x0000001217127217ULL, 0x000fe20007800000ULL,
0x0000000119187824ULL, 0x040fe400078e0202ULL, 0x00000008193b7824ULL, 0x000fe400078e00ffULL,
0x0000000112127824ULL, 0x000fc400078e0a17ULL, 0x00000001171b7824ULL, 0x000fe200078e021aULL,
0xfffffff83b3b7812ULL, 0x000fe400078ee218ULL, 0x000000121a00720cULL, 0x080fe20003f66070ULL,
0x000000011b187824ULL, 0x000fe200078e0202ULL, 0x000000121300720cULL, 0x080fe20003f86070ULL,
0x000000081b417824ULL, 0x000fe200078e00ffULL, 0x0000000c131a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000119137824ULL, 0x000fe200078e0238ULL, 0x000000123900720cULL, 0x080fe20003f46070ULL,
0x0000000117397824ULL, 0x000fe200078e0239ULL, 0x000000121a00720cULL, 0x000fe20003f06070ULL,
0x0000008013127825ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fc600078ee218ULL,
0x000000011b187824ULL, 0x000fe200078e0238ULL, 0x0000006012127212ULL, 0x000fe200078efcffULL,
0x0000000117457824ULL, 0x000fe400078e021aULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fc60007fbe0ffULL, 0x00000001391a7824ULL, 0x100fe200078e0238ULL,
0x0000006018187212ULL, 0x080fe200078efcffULL, 0x0000000145387824ULL, 0x000fe200078e0238ULL,
0x0000650013137a10ULL, 0x000fe20002ffe4ffULL, 0x0000000139177824ULL, 0x040fe200078e0202ULL,
0x0000640018187a10ULL, 0x000fe20007fbe0ffULL, 0x00000008393a7824ULL, 0x000fe400078e00ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000650019197a10ULL, 0x000fe40002ffe4ffULL,
0xfffffff83a437812ULL, 0x000fe200078ee217ULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x000000601a1a7212ULL, 0x000fc600078efcffULL, 0x0000000145177824ULL, 0x040fe200078e0202ULL,
0x0000006038387212ULL, 0x000fe200078efcffULL, 0x00000008453a7824ULL, 0x000fe200078e00ffULL,
0x000064001a1a7a10ULL, 0x000fe40007fbe0ffULL, 0x0000640038387a10ULL, 0x000fe40007fde0ffULL,
0xfffffff83a457812ULL, 0x000fe200078ee217ULL, 0x000000103b177824ULL, 0x100fe200078e0274ULL,
0x000065001b1b7a10ULL, 0x000fe20002ffe4ffULL, 0x00000010413b7824ULL, 0x100fe200078e0274ULL,
0x0000650039397a10ULL, 0x000fe200037fe4ffULL, 0x0000001043417824ULL, 0x100fe200078e0274ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012177faeULL, 0x0003e2000e101c46ULL,
0x0000001045437824ULL, 0x000fc600078e0274ULL, 0x00000000183b7faeULL, 0x0003e8000d901c46ULL,
0x000000001a417faeULL, 0x0003e8000d101c46ULL, 0x0000000038437faeULL, 0x0003e2000c101c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001079137824ULL, 0x000fca00078e00ffULL,
0x0000001302137211ULL, 0x000fc800078fe8ffULL, 0x00000008131b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000113127824ULL, 0x140fe200078e0202ULL, 0x0000000413197810ULL, 0x040fe20007ffe0ffULL,
0x0000000813177824ULL, 0x040fe200078e00ffULL, 0x0000000c13397810ULL, 0x000fe20007ffe0ffULL,
0x000000011b1a7824ULL, 0x040fe400078e0202ULL, 0x000000081b437824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee212ULL, 0x0000000113127824ULL, 0x000fe400078e0238ULL,
0x0000000119187824ULL, 0x000fe200078e0202ULL, 0xfffffff843437812ULL, 0x000fe200078ee21aULL,
0x0000000819417824ULL, 0x000fc400078e00ffULL, 0x00000001193a7824ULL, 0x000fe400078e0238ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fc600078ee218ULL,
0x000000011b1a7824ULL, 0x100fe200078e0238ULL, 0x0000006012187212ULL, 0x000fe200078efcffULL,
0x0000000139387824ULL, 0x000fe400078e0238ULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000640018187a10ULL, 0x000fc60007f1e0ffULL, 0x0000000139197824ULL, 0x040fe200078e0202ULL,
0x000000603a127212ULL, 0x080fe200078efcffULL, 0x0000000839407824ULL, 0x000fe400078e00ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000640012127a10ULL, 0x000fe40007f5e0ffULL,
0xfffffff840457812ULL, 0x000fe200078ee219ULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x000000601a1a7212ULL, 0x080fe400078efcffULL, 0x0000650013197a10ULL, 0x000fe200007fe4ffULL,
0x0000001017177824ULL, 0x000fe200078e0274ULL, 0x0000006038387212ULL, 0x000fc400078efcffULL,
0x000064001a1a7a10ULL, 0x000fe40007f1e0ffULL, 0x0000640038387a10ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018177faeULL, 0x0003e2000b901c46ULL,
0x000065003b137a10ULL, 0x000fe200017fe4ffULL, 0x00000010413b7824ULL, 0x100fe200078e0274ULL,
0x000065001b1b7a10ULL, 0x000fe200007fe4ffULL, 0x0000001043417824ULL, 0x100fe200078e0274ULL,
0x0000650039397a10ULL, 0x000fe20001ffe4ffULL, 0x0000001045437824ULL, 0x000fe200078e0274ULL,
0x00000000123b7faeULL, 0x0003e8000b901c46ULL, 0x000000001a417faeULL, 0x0003e8000b901c46ULL,
0x0000000038437faeULL, 0x0003e4000b901c46ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff011407812ULL, 0x000fce00078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176b00040407f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x017648000e127f8cULL, 0x0006a4000c80043fULL,
0x0000000000187805ULL, 0x000fc40000015200ULL, 0xffffffe0110e7812ULL, 0x048fe400078ec0ffULL,
0x0000001011177812ULL, 0x040fe400078ec0ffULL, 0x00000008111a7812ULL, 0x000fc800078ec0ffULL,
0x0000000e1a0e7210ULL, 0x000fca0007ffe017ULL, 0x01764c000e177984ULL, 0x000ee40000000800ULL,
0x8000000017ff7812ULL, 0x00cfe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fcc0000015200ULL,
0x0000001a181a7210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e19ULL,
0x003d09001a00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401a00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff177819ULL, 0x000fc8000001141bULL, 0x0000001a17177211ULL, 0x000fca00078110ffULL,
0x000000ffff1a7224ULL, 0x000fca00000e061bULL, 0x0000000217177819ULL, 0x000fc8000000121aULL,
0x000000170000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01764c000e177984ULL, 0x000ea40000000800ULL, 0x8000000017ff7812ULL, 0x004fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020000e7824ULL, 0x000fca00078e00ffULL,
0xffffff800e137812ULL, 0x000fc800078ec0ffULL, 0x00000100600e7810ULL, 0x000fca0007ffe013ULL,
0x00000001750e7824ULL, 0x000fca00078e020eULL, 0x017000000e177984ULL, 0x000ea80000000800ULL,
0x017200000e127984ULL, 0x0006620000000800ULL, 0x000000081700720bULL, 0x004fe20003f1d000ULL,
0x0000fa427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x008fc800000e0100ULL,
0x0000ffff13197812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0e7424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000027c137810ULL, 0x000fe40007ffe0ffULL, 0x000000081700720bULL, 0x000fe40003f54000ULL,
0x000000001300720cULL, 0x000fe20003f05270ULL, 0x0000fa027f007947ULL, 0x000fd4000b800000ULL,
0x00000000000e7806ULL, 0x000fc400010e0100ULL, 0x0000008000188824ULL, 0x000fe200078e0260ULL,
0x0000000817138209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x00000001751a8824ULL, 0x000fe200078e0218ULL, 0x000099100e187816ULL, 0x000fc800000000ffULL,
0x017400131a008388ULL, 0x0005e20000000800ULL, 0x000000ff1800720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000817137209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0eff7812ULL, 0x000fc6000780c0ffULL,
0x0000000813137221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL,
0x0000001300187308ULL, 0x000ea40000000800ULL, 0x0000001807077220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x000fe20000011602ULL,
0x0000f9327f007947ULL, 0x000fea000b800000ULL, 0x00001f1318137589ULL, 0x0004e400000e0000ULL,
0x0000001334347220ULL, 0x08cfe40000410000ULL, 0x0000001335357220ULL, 0x080fe40000410000ULL,
0x0000001330307220ULL, 0x080fe40000410000ULL, 0x0000001331317220ULL, 0x000fc40000410000ULL,
0x000000132c2c7220ULL, 0x080fe40000410000ULL, 0x000000132d2d7220ULL, 0x080fe40000410000ULL,
0x0000001328287220ULL, 0x080fe40000410000ULL, 0x0000001329297220ULL, 0x080fe40000410000ULL,
0x0000001324247220ULL, 0x080fe40000410000ULL, 0x0000001325257220ULL, 0x000fc40000410000ULL,
0x0000001320207220ULL, 0x080fe40000410000ULL, 0x0000001321217220ULL, 0x080fe40000410000ULL,
0x000000131c1c7220ULL, 0x080fe40000410000ULL, 0x000000131d1d7220ULL, 0x080fe40000410000ULL,
0x000000133c3c7220ULL, 0x080fe40000410000ULL, 0x000000133d3d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000eff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802137811ULL, 0x000fe200078ff0ffULL,
0x0000f8327f007947ULL, 0x000fea000b800000ULL, 0x00001f1318137589ULL, 0x0004e400000e0000ULL,
0x0000001336367220ULL, 0x08cfe40000410000ULL, 0x0000001337377220ULL, 0x080fe40000410000ULL,
0x0000001332327220ULL, 0x080fe40000410000ULL, 0x0000001333337220ULL, 0x080fe40000410000ULL,
0x000000132e2e7220ULL, 0x080fe40000410000ULL, 0x000000132f2f7220ULL, 0x000fc40000410000ULL,
0x000000132a2a7220ULL, 0x080fe40000410000ULL, 0x000000132b2b7220ULL, 0x080fe40000410000ULL,
0x0000001326267220ULL, 0x080fe40000410000ULL, 0x0000001327277220ULL, 0x080fe40000410000ULL,
0x0000001322227220ULL, 0x080fe40000410000ULL, 0x0000001323237220ULL, 0x000fc40000410000ULL,
0x000000131e1e7220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x080fe40000410000ULL,
0x000000133e3e7220ULL, 0x080fe40000410000ULL, 0x000000133f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff19ff7812ULL, 0x000fe2000780600eULL,
0x00000001ff0e7424ULL, 0x000fe200078e00ffULL, 0x0000000817087209ULL, 0x000fd60007810000ULL,
0x8000000817170221ULL, 0x000fe20000010000ULL, 0x00007610ff0e0816ULL, 0x000fc6000000000eULL,
0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL, 0x00000017000d0308ULL, 0x000ea40000000800ULL,
0x0000000d12120220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000712077221ULL, 0x002fc40000010000ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0xfffffff0111b7812ULL, 0x000fca00078ec0ffULL, 0x0176ac001b177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x0000001812187210ULL, 0x000fca0007f1e1ffULL, 0x0000000119197824ULL, 0x000fe200000e0e13ULL,
0x003d09001800780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401800780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff177819ULL, 0x000fc80000011419ULL, 0x0000001817177211ULL, 0x000fca00078110ffULL,
0x000000ffff187224ULL, 0x000fca00000e0619ULL, 0x0000000217177819ULL, 0x000fc80000001218ULL,
0x000000170000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac001b177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100e0e7816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x0000000dff0b723eULL, 0x000fe400000010ffULL,
0x00000002ff157819ULL, 0x000fe40000011602ULL, 0x000054100b0e7816ULL, 0x000fe2000000000bULL,
0x0000f4127f007947ULL, 0x000fea000b800000ULL, 0x00001f150e0c7589ULL, 0x0002a400000e0000ULL,
0x0000000815137810ULL, 0x000fe20007ffe0ffULL, 0x0000f4627f007947ULL, 0x000fea000b800000ULL,
0x00001f130e0b7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001015137810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff387224ULL, 0x000fe200078e000eULL,
0x00009a6000397802ULL, 0x000fe20000000f00ULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000fc5000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001815137810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff387224ULL, 0x000fe200078e000eULL, 0x00009ad000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000fbe000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001003187824ULL, 0x100fe200078e026eULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001050387824ULL, 0x000fc800078e026eULL, 0x000000001818783bULL, 0x000f280000004200ULL,
0x000000003838783bULL, 0x000ee20000004200ULL, 0x00000018ff037819ULL, 0x010fe20000011418ULL,
0x00000018004e7306ULL, 0x000fe20000009400ULL, 0x00000018ff137819ULL, 0x00cfe40000011419ULL,
0x00000018ff437819ULL, 0x000fe40000011439ULL, 0x00000018ff177819ULL, 0x000fc4000001141bULL,
0x00000018ff427819ULL, 0x000fe20000011438ULL, 0x00000003004c7306ULL, 0x000fe20000209400ULL,
0x00000018ff157819ULL, 0x002fce000001141aULL, 0x00000003004f7306ULL, 0x000ff00000205400ULL,
0x0000000300677306ULL, 0x0003f0000020d400ULL, 0x0000001300467306ULL, 0x000fe20000209400ULL,
0x0000000802037812ULL, 0x002fc800078ec0ffULL, 0x0000000703037812ULL, 0x000fc600078ef802ULL,
0x00000013004d7306ULL, 0x000fe40000205400ULL, 0x0000000103047824ULL, 0x040fe400078e0204ULL,
0x0000000803037824ULL, 0x000fc800078e00ffULL, 0x0000001300657306ULL, 0x0003e2000020d400ULL,
0xfffffff803037812ULL, 0x000fca00078ee204ULL, 0x0000001003487824ULL, 0x000fe400078e026eULL,
0x00000043005f7306ULL, 0x000fe20000209400ULL, 0x0000010018137824ULL, 0x002fc600078e00ffULL,
0x000000004848783bULL, 0x000e640000004200ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x00000043005d7306ULL, 0x000ff00000205400ULL, 0x0000001300537306ULL, 0x000ff00000209400ULL,
0x0000001300547306ULL, 0x000eb00000205400ULL, 0x0000004300037306ULL, 0x0003f0000020d400ULL,
0x0000001700457306ULL, 0x000fe20000209400ULL, 0x000000545300720bULL, 0x004fe20003fdd000ULL,
0x0000010048437824ULL, 0x042fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011448ULL,
0x0001000048537824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fc60000011449ULL,
0x0000001700127306ULL, 0x000fe20000205400ULL, 0x00000018ff6a7819ULL, 0x000fce0000011443ULL,
0x0000001700617306ULL, 0x0003f0000020d400ULL, 0x00000042000e7306ULL, 0x000fe20000209400ULL,
0x0000010019177824ULL, 0x002fce00078e00ffULL, 0x00000042005b7306ULL, 0x000ff00000205400ULL,
0x0000004200047306ULL, 0x0003f0000020d400ULL, 0x0000006a005a7306ULL, 0x000fe20000209400ULL,
0x00000018ff427819ULL, 0x002fce0000011417ULL, 0x0000006a00437306ULL, 0x000e700000205400ULL,
0x0000001500477306ULL, 0x000ff00000209400ULL, 0x0000001500447306ULL, 0x000fe20000205400ULL,
0x000000435a00720bULL, 0x002fe20003f7d000ULL, 0x0000010049437824ULL, 0x000fcc00078e00ffULL,
0x0000001500627306ULL, 0x000ff0000020d400ULL, 0x0000004800597306ULL, 0x000ff00000009400ULL,
0x0000004800687306ULL, 0x000e700000005400ULL, 0x0000001300157306ULL, 0x000eb0000020d400ULL,
0x0000004200697306ULL, 0x000fe20000209400ULL, 0x000000685900720bULL, 0x002fc40003f9d000ULL,
0x00000018ff687819ULL, 0x000fca0000011443ULL, 0x00000042005e7306ULL, 0x000e620000205400ULL,
0x0000000115156812ULL, 0x004fce00078efcffULL, 0x0000004200177306ULL, 0x000eb0000020d400ULL,
0x0000005600557306ULL, 0x000fe20000209400ULL, 0x0000005e6900720bULL, 0x002fce0003fdd000ULL,
0x0000005600647306ULL, 0x000fec0000205400ULL, 0x0000000117176812ULL, 0x004fe400078efcffULL,
0x0000005600527306ULL, 0x000fe2000020d400ULL, 0x000000444700720bULL, 0x000fce0003fdd000ULL,
0x0000006c00137306ULL, 0x000fec0000209400ULL, 0x0000000162626812ULL, 0x000fe400078efcffULL,
0x0000006c00427306ULL, 0x000ff00000205400ULL, 0x0000006c00517306ULL, 0x0003f0000020d400ULL,
0x0000004900567306ULL, 0x000fe20000009400ULL, 0x00000018ff6c7819ULL, 0x002fce0000011453ULL,
0x00000049006f7306ULL, 0x000e700000005400ULL, 0x0000001800637306ULL, 0x000ff00000005400ULL,
0x0000001800147306ULL, 0x0005e2000000d400ULL, 0x0000006f5600720bULL, 0x002fe20003fbd000ULL,
0x0001000049567824ULL, 0x000fcc00078e00ffULL, 0x0000006c00547306ULL, 0x000fe20000209400ULL,
0x0001000018187824ULL, 0x004fca00078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011418ULL,
0x0000006c00717306ULL, 0x000e700000205400ULL, 0x0000006a00587306ULL, 0x0004f0000020d400ULL,
0x00000057006d7306ULL, 0x000fe20000209400ULL, 0x000000715400720bULL, 0x002fc40003f5d000ULL,
0x00000018ff6a7819ULL, 0x004fca0000011456ULL, 0x00000057005c7306ULL, 0x000fe20000205400ULL,
0x0000000158583812ULL, 0x008fe400078efcffULL, 0x000000645500720bULL, 0x000fca0003f7d000ULL,
0x0000005700187306ULL, 0x000ff0000020d400ULL, 0x0000004800577306ULL, 0x000e62000000d400ULL,
0x0000000152523812ULL, 0x000fce00078efcffULL, 0x0000006c00537306ULL, 0x000eb0000020d400ULL,
0x0000006800437306ULL, 0x000fe20000209400ULL, 0x0000000157574812ULL, 0x002fe400078efcffULL,
0x000000421300720bULL, 0x000fe20003f9d000ULL, 0x000001004b137824ULL, 0x000fe200078e00ffULL,
0x000000575858723eULL, 0x000fc600000010ffULL, 0x0000006800487306ULL, 0x000e620000205400ULL,
0x0000000153532812ULL, 0x004fce00078efcffULL, 0x0000004900597306ULL, 0x0004e2000000d400ULL,
0x0000000151514812ULL, 0x000fce00078efcffULL, 0x0000006a00567306ULL, 0x000fe20000209400ULL,
0x000001004a497824ULL, 0x004fe200078e00ffULL, 0x000000484300720bULL, 0x002fe40003f5d000ULL,
0x00000018ff487819ULL, 0x000fe4000001144aULL, 0x00000018ff6c7819ULL, 0x000fe40000011449ULL,
0x0000006a006f7306ULL, 0x000e620000205400ULL, 0x0000000159595812ULL, 0x008fce00078efcffULL,
0x00000068005a7306ULL, 0x000eb0000020d400ULL, 0x0000006c00497306ULL, 0x000fe20000209400ULL,
0x0000006f5600720bULL, 0x002fce0003f7d000ULL, 0x0000006c00647306ULL, 0x000e620000205400ULL,
0x000000015a5a2812ULL, 0x004fc800078efcffULL, 0x000000595a59723eULL, 0x000fc600000010ffULL,
0x0000006a00547306ULL, 0x0004f0000020d400ULL, 0x0000004a00687306ULL, 0x000fe20000009400ULL,
0x00000018ff6a7819ULL, 0x004fe40000011413ULL, 0x000000644900720bULL, 0x002fe20003f5d000ULL,
0x000100004a647824ULL, 0x000fc800078e00ffULL, 0x0000006a00427306ULL, 0x000fe20000209400ULL,
0x00000018ff707819ULL, 0x000fe40000011464ULL, 0x0000000154543812ULL, 0x008fca00078efcffULL,
0x0000006a00437306ULL, 0x000e700000205400ULL, 0x0000004a00717306ULL, 0x000eb00000005400ULL,
0x0000006a00137306ULL, 0x000ee2000020d400ULL, 0x000000434200720bULL, 0x002fce0003f7d000ULL,
0x0000004a00567306ULL, 0x000e62000000d400ULL, 0x000000716800720bULL, 0x004fce0003fbd000ULL,
0x00000048006a7306ULL, 0x000fe20000209400ULL, 0x0000000113133812ULL, 0x008fe400078efcffULL,
0x000000634e00720bULL, 0x000fca0003f7d000ULL, 0x0000004800437306ULL, 0x000ea20000205400ULL,
0x0000000156565812ULL, 0x002fce00078efcffULL, 0x00000070004a7306ULL, 0x000fe20000209400ULL,
0x0000000114143812ULL, 0x000fe400078efcffULL, 0x0000005c6d00720bULL, 0x000fe40003f7d000ULL,
0x000000141514723eULL, 0x000fc600000010ffULL, 0x00000070006f7306ULL, 0x000e620000205400ULL,
0x000000436a00720bULL, 0x004fce0003fbd000ULL, 0x0000006c00557306ULL, 0x000ea2000020d400ULL,
0x0000000118183812ULL, 0x000fce00078efcffULL, 0x0000004b00497306ULL, 0x000fe20000009400ULL,
0x0000006f4a00720bULL, 0x002fce0003f9d000ULL, 0x0000004b00687306ULL, 0x000e620000005400ULL,
0x0000000155552812ULL, 0x004fc800078efcffULL, 0x000000565556723eULL, 0x000fc600000010ffULL,
0x0000007000427306ULL, 0x000eb0000020d400ULL, 0x0000004b00437306ULL, 0x000ee2000000d400ULL,
0x000000684900720bULL, 0x002fe20003f5d000ULL, 0x0001000019497824ULL, 0x000fca00078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011449ULL, 0x0000001900647306ULL, 0x000fe20000009400ULL,
0x0000000142424812ULL, 0x004fe400078efcffULL, 0x0000004f4c00720bULL, 0x000fe20003f9d000ULL,
0x000001001a4c7824ULL, 0x000fc800078e00ffULL, 0x00000019006f7306ULL, 0x000e620000005400ULL,
0x0000000143432812ULL, 0x008fc800078efcffULL, 0x000000431357723eULL, 0x000fc600000010ffULL,
0x00000019006c7306ULL, 0x000ea2000000d400ULL, 0x0000000167674812ULL, 0x000fc800078efcffULL,
0x000000186718723eULL, 0x000fe400000010ffULL, 0x0000006f6400720bULL, 0x002fe20003f5d000ULL,
0x0000006800497306ULL, 0x000ff00000209400ULL, 0x00000068004a7306ULL, 0x000e680000205400ULL,
0x000000016c6c2812ULL, 0x004fc400078efcffULL, 0x000000124500720bULL, 0x000fe20003f5d000ULL,
0x000001001b127824ULL, 0x000fe200078e00ffULL, 0x0000006800197306ULL, 0x0005e2000020d400ULL,
0x0000006c1715723eULL, 0x000fc600000010ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011412ULL,
0x00000018ff127819ULL, 0x000fe4000001143aULL, 0x0000004800487306ULL, 0x000ee2000020d400ULL,
0x00000018ff687819ULL, 0x004fe2000001144cULL, 0x00000010164c7824ULL, 0x000fe200078e026eULL,
0x0000004a4900720bULL, 0x002fe40003f7d000ULL, 0x0000000161612812ULL, 0x000fc600078efcffULL,
0x00000068005e7306ULL, 0x000ff00000209400ULL, 0x0000006800697306ULL, 0x000e620000205400ULL,
0x0000000148485812ULL, 0x008fe400078efcffULL, 0x0000004d4600720bULL, 0x000fc40003fbd000ULL,
0x000000004c4c783bULL, 0x000ea20000004200ULL, 0x0000000119193812ULL, 0x000fe400078efcffULL,
0x00000068006a7306ULL, 0x000ee2000020d400ULL, 0x000000424842723eULL, 0x000fce00000010ffULL,
0x0000001a00637306ULL, 0x000fe20000009400ULL, 0x000000695e00720bULL, 0x002fe40003f9d000ULL,
0x0000000165655812ULL, 0x000fc800078efcffULL, 0x000000196519723eULL, 0x000fe200000010ffULL,
0x0000001a00467306ULL, 0x000e6c0000005400ULL, 0x000000016a6a4812ULL, 0x008fe400078efcffULL,
0x0000001b00167306ULL, 0x000ff00000009400ULL, 0x0000001b00457306ULL, 0x000ee20000005400ULL,
0x000000466300720bULL, 0x002fe20003f7d000ULL, 0x000100001a637824ULL, 0x000fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x004fe2000001144cULL, 0x000100004c707824ULL, 0x000fc600078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x0000005c00447306ULL, 0x000fe20000209400ULL,
0x00000018ff717819ULL, 0x000fe4000001144fULL, 0x00000018ff707819ULL, 0x000fca0000011470ULL,
0x0000005c00477306ULL, 0x000e620000205400ULL, 0x000000451600720bULL, 0x008fce0003fbd000ULL,
0x0000001a00647306ULL, 0x000ea2000000d400ULL, 0x000000474400720bULL, 0x002fce0003f9d000ULL,
0x0000001b00687306ULL, 0x0002e2000000d400ULL, 0x012000000544783bULL, 0x0008e20000000200ULL,
0x0000000164643812ULL, 0x004fcc00078efcffULL, 0x00000063001a7306ULL, 0x000fe20000209400ULL,
0x000100001b1b7824ULL, 0x002fe200078e00ffULL, 0x00000018ff057819ULL, 0x010fe4000001143bULL,
0x0000005b0e00720bULL, 0x000fe40003f7d000ULL, 0x00000018ff6c7819ULL, 0x000fe4000001141bULL,
0x00000063006f7306ULL, 0x000e620000205400ULL, 0x0000000168685812ULL, 0x008fce00078efcffULL,
0x0000005c00697306ULL, 0x000ea2000020d400ULL, 0x0000000104043812ULL, 0x000fe400078efcffULL,
0x0000005d5f00720bULL, 0x000fca0003f7d000ULL, 0x0000005e00167306ULL, 0x000fe20000209400ULL,
0x0000006f1a00720bULL, 0x002fe20003fbd000ULL, 0x000001004e6f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001146fULL, 0x0000005e006d7306ULL, 0x000e620000205400ULL,
0x0000000c44448231ULL, 0x080fe200003400ffULL, 0x0000000169694812ULL, 0x004fe200078efcffULL,
0x0000000c46468231ULL, 0x000fe200003400ffULL, 0x0000000103033812ULL, 0x000fe200078efcffULL,
0x0000000b45458231ULL, 0x080fe400003400ffULL, 0x0000000b47478231ULL, 0x000fe200003400ffULL,
0x00000005005c7306ULL, 0x000fec0000209400ULL, 0x000000584434723cULL, 0x000fe40000041834ULL,
0x00000005005b7306ULL, 0x000fe20000205400ULL, 0x0000006d1600720bULL, 0x002fca0003f9d000ULL,
0x000000144414723cULL, 0x000b640000041824ULL, 0x00000005000e7306ULL, 0x000fea000020d400ULL,
0x000001004c247824ULL, 0x020fc600078e00ffULL, 0x0000006300637306ULL, 0x000e64000020d400ULL,
0x00000018ff247819ULL, 0x000fcc0000011424ULL, 0x0000006c00057306ULL, 0x000ff00000209400ULL,
0x0000006c001a7306ULL, 0x000ea20000205400ULL, 0x0000000163635812ULL, 0x002fce00078efcffULL,
0x0000002400257306ULL, 0x000fe20000209400ULL, 0x0000001a0500720bULL, 0x004fce0003fbd000ULL,
0x0000002400267306ULL, 0x000e620000205400ULL, 0x0000000702057812ULL, 0x000fe200078ec0ffULL,
0x000000184418723cULL, 0x000b660000041820ULL, 0x0000000805057812ULL, 0x000fc600078ef802ULL,
0x0000006c00677306ULL, 0x0004e2000020d400ULL, 0x000000686921723eULL, 0x020fe200000010ffULL,
0x0000000805207824ULL, 0x000fe200078e00ffULL, 0x0000000206057810ULL, 0x000fc80007ffe0ffULL,
0xfffffff820057812ULL, 0x000fe200078ee205ULL, 0x0000004c00227306ULL, 0x000fe20000009400ULL,
0x000000262500720bULL, 0x002fe20003fdd000ULL, 0x000100004d6c7824ULL, 0x004fe200078e00ffULL,
0x000000646a20723eULL, 0x000fe200000010ffULL, 0x0000001005057824ULL, 0x000fe400078e00ffULL,
0x000001004d6a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x0000004c00237306ULL, 0x000e620000005400ULL, 0x000120000a257810ULL, 0x000fe20007ffe005ULL,
0x00000020441c723cULL, 0x000b62000004181cULL, 0x0000000167675812ULL, 0x008fc400078efcffULL,
0x00000018ff6a7819ULL, 0x000fc6000001146aULL, 0x00000024000a7306ULL, 0x0004e2000020d400ULL,
0x000000232200720bULL, 0x002fe20003fbd000ULL, 0x000000002524783bULL, 0x004e620000000200ULL,
0x00000018ff227819ULL, 0x000fca000001144dULL, 0x0000004c00697306ULL, 0x000ea2000000d400ULL,
0x000000010a0a6812ULL, 0x008fce00078efcffULL, 0x0000002200237306ULL, 0x000ff00000209400ULL,
0x0000002200647306ULL, 0x000ee20000205400ULL, 0x0000000169695812ULL, 0x004fce00078efcffULL,
0x00000070004c7306ULL, 0x000ff00000209400ULL, 0x00000070006d7306ULL, 0x000ea20000205400ULL,
0x000000642300720bULL, 0x008fe20003f5d000ULL, 0x0000000c24248231ULL, 0x002fcc00003400ffULL,
0x0000004d00207306ULL, 0x020fe20000009400ULL, 0x0000000c26268231ULL, 0x000fe400003400ffULL,
0x0000000b25258231ULL, 0x080fe400003400ffULL, 0x0000000b27278231ULL, 0x000fc600003400ffULL,
0x0000004d00217306ULL, 0x000e620000005400ULL, 0x0000006d4c00720bULL, 0x004fce0003fbd000ULL,
0x0000006a00657306ULL, 0x000ff00000209400ULL, 0x0000006a00687306ULL, 0x000ea20000205400ULL,
0x000000212000720bULL, 0x002fe20003fdd000ULL, 0x000001004f207824ULL, 0x000fe200078e00ffULL,
0x000000676121723eULL, 0x000fca00000010ffULL, 0x0000002200647306ULL, 0x000e70000020d400ULL,
0x0000004d006d7306ULL, 0x000722000000d400ULL, 0x000000686500720bULL, 0x004fce0003f1d000ULL,
0x0000006f00227306ULL, 0x000fe20000209400ULL, 0x00000018ff4d7819ULL, 0x008fe40000011420ULL,
0x000000636220723eULL, 0x000fe400000010ffULL, 0x00000018ff637819ULL, 0x000fe4000001144eULL,
0x0000000164642812ULL, 0x002fe200078efcffULL, 0x0000006f00237306ULL, 0x000e620000205400ULL,
0x000000016d6d6812ULL, 0x010fce00078efcffULL, 0x0000007000657306ULL, 0x000eb0000020d400ULL,
0x0000004d00627306ULL, 0x000fe20000209400ULL, 0x000000232200720bULL, 0x002fe40003fdd000ULL,
0x000000204420723cULL, 0x000b6a000004183cULL, 0x0000004d00617306ULL, 0x000e620000205400ULL,
0x0000000165655812ULL, 0x004fe200078efcffULL, 0x00000100383e7824ULL, 0x020fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000006a006a7306ULL, 0x000eb0000020d400ULL,
0x0000006c004c7306ULL, 0x000fe20000209400ULL, 0x000000616200720bULL, 0x002fce0003fbd000ULL,
0x0000006c00687306ULL, 0x000e620000205400ULL, 0x000000016a6a0812ULL, 0x004fce00078efcffULL,
0x0000003e00617306ULL, 0x000ff00000209400ULL, 0x0000003e00707306ULL, 0x000ea20000205400ULL,
0x000000684c00720bULL, 0x002fce0003f1d000ULL, 0x0000006c006c7306ULL, 0x000e70000020d400ULL,
0x00000063003f7306ULL, 0x000fe20000209400ULL, 0x000000706100720bULL, 0x004fce0003f5d000ULL,
0x0000006300627306ULL, 0x000ea20000205400ULL, 0x000000016c6c0812ULL, 0x002fce00078efcffULL,
0x0000006f004c7306ULL, 0x000e70000020d400ULL, 0x0000007100617306ULL, 0x000fe20000209400ULL,
0x000000623f00720bULL, 0x004fce0003f1d000ULL, 0x0000007100707306ULL, 0x000ea20000205400ULL,
0x000000014c4c6812ULL, 0x002fce00078efcffULL, 0x0000005e005e7306ULL, 0x000e70000020d400ULL,
0x0000004d004d7306ULL, 0x000ee2000020d400ULL, 0x000000706100720bULL, 0x004fe20003fdd000ULL,
0x000100004e707824ULL, 0x000fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x0000004e003c7306ULL, 0x000fe20000009400ULL, 0x000000015e5e4812ULL, 0x002fce00078efcffULL,
0x0000004e003d7306ULL, 0x000e620000005400ULL, 0x000000014d4d5812ULL, 0x008fce00078efcffULL,
0x0000004f003f7306ULL, 0x000ff00000009400ULL, 0x0000004f00627306ULL, 0x000ea20000005400ULL,
0x0000003d3c00720bULL, 0x002fce0003f9d000ULL, 0x0000007100617306ULL, 0x0002e2000020d400ULL,
0x000000623f00720bULL, 0x004fce0003fbd000ULL, 0x00000038003c7306ULL, 0x000fe20000009400ULL,
0x0001000038717824ULL, 0x002fca00078e00ffULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x00000038003d7306ULL, 0x000fe20000005400ULL, 0x0000000161616812ULL, 0x008fce00078efcffULL,
0x0000004e00687306ULL, 0x000e70000000d400ULL, 0x00000038003f7306ULL, 0x000ff0000000d400ULL,
0x0000004f00677306ULL, 0x000ea2000000d400ULL, 0x0000000168684812ULL, 0x002fc400078efcffULL,
0x0000003d3c00720bULL, 0x000fe40003f9d000ULL, 0x000000690a3c723eULL, 0x000fe400000010ffULL,
0x0000006d6a3d723eULL, 0x000fe200000010ffULL, 0x00000070006f7306ULL, 0x000fe20000209400ULL,
0x00000018ff6d7819ULL, 0x000fe2000001144bULL, 0x000100004b4b7824ULL, 0x000fc800078e00ffULL,
0x0000003c2414723cULL, 0x000be20000041814ULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000007000387306ULL, 0x000e620000205400ULL, 0x0000000167675812ULL, 0x004fe400078efcffULL,
0x000000013f3f4812ULL, 0x000fe400078efcffULL, 0x000000655e3c723eULL, 0x020fe200000010ffULL,
0x0000010039657824ULL, 0x000fe200078e00ffULL, 0x0000006c643d723eULL, 0x000fe200000010ffULL,
0x0000006300637306ULL, 0x000ea6000020d400ULL, 0x00000018ff657819ULL, 0x000fc60000011465ULL,
0x0000003c2418723cULL, 0x000be20000041818ULL, 0x000000386f00720bULL, 0x002fe20003fbd000ULL,
0x000100004f6f7824ULL, 0x000fe200078e00ffULL, 0x00000070006a7306ULL, 0x000e68000020d400ULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000000163630812ULL, 0x004fe400078efcffULL,
0x0000006f00697306ULL, 0x000ff00000209400ULL, 0x0000006f005e7306ULL, 0x000ea20000205400ULL,
0x000000016a6a5812ULL, 0x002fce00078efcffULL, 0x0000003900387306ULL, 0x000ff00000009400ULL,
0x00000039004f7306ULL, 0x000e620000005400ULL, 0x0000005e6900720bULL, 0x004fe20003f1d000ULL,
0x00010000395e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x00000039003c7306ULL, 0x0204e2000000d400ULL, 0x0000004f3800720bULL, 0x002fce0003fbd000ULL,
0x0000006f006f7306ULL, 0x000e62000020d400ULL, 0x000000684c38723eULL, 0x000fe400000010ffULL,
0x000000674d39723eULL, 0x004fca00000010ffULL, 0x0000006d004f7306ULL, 0x000fe40000209400ULL,
0x00000038241c723cULL, 0x000be2000004181cULL, 0x000000013c3c5812ULL, 0x008fca00078efcffULL,
0x0000006d004c7306ULL, 0x000ea20000205400ULL, 0x000001003a387824ULL, 0x020fe200078e00ffULL,
0x000000016f6f0812ULL, 0x002fcc00078efcffULL, 0x0000004b00707306ULL, 0x000ff00000209400ULL,
0x0000004b00397306ULL, 0x000e620000205400ULL, 0x0000004c4f00720bULL, 0x004fce0003f1d000ULL,
0x00000071004e7306ULL, 0x000ff00000209400ULL, 0x0000007100627306ULL, 0x000fe20000205400ULL,
0x000000397000720bULL, 0x002fe40003fdd000ULL, 0x0000006f6139723eULL, 0x000fca00000010ffULL,
0x00000071000a7306ULL, 0x0003f0000020d400ULL, 0x0000004b004f7306ULL, 0x000ea2000020d400ULL,
0x00000018ff717819ULL, 0x002fe20000011438ULL, 0x000001003b387824ULL, 0x000fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011438ULL, 0x0000006d00617306ULL, 0x000e62000020d400ULL,
0x0000006a6338723eULL, 0x000fce00000010ffULL, 0x0000006500647306ULL, 0x000fe20000209400ULL,
0x000000382420723cULL, 0x000be20000041820ULL, 0x000000014f4f6812ULL, 0x004fe400078efcffULL,
0x000000624e00720bULL, 0x000fe20003fdd000ULL, 0x000100003a627824ULL, 0x000fc600078e00ffULL,
0x00000065006c7306ULL, 0x000ea20000205400ULL, 0x0000000161610812ULL, 0x002fe400078efcffULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000004f6143723eULL, 0x000fc600000010ffULL,
0x0000003b00397306ULL, 0x020fe20000009400ULL, 0x000000010a0a6812ULL, 0x000fce00078efcffULL,
0x0000003b005a7306ULL, 0x000e620000005400ULL, 0x0000006c6400720bULL, 0x004fce0003f1d000ULL,
0x0000003e003e7306ULL, 0x000eb0000020d400ULL, 0x0000003a004e7306ULL, 0x000fe20000009400ULL,
0x0000005a3900720bULL, 0x002fe20003f9d000ULL, 0x000100003b397824ULL, 0x000fcc00078e00ffULL,
0x0000003a00387306ULL, 0x000e620000005400ULL, 0x000000013e3e2812ULL, 0x004fc800078efcffULL,
0x0000003f3e3e723eULL, 0x000fc600000010ffULL, 0x00000065003d7306ULL, 0x000eb0000020d400ULL,
0x0000007100687306ULL, 0x000fe20000209400ULL, 0x000000384e00720bULL, 0x002fe40003f5d000ULL,
0x000000535238723eULL, 0x000fc400000010ffULL, 0x00000018ff527819ULL, 0x000fe40000011439ULL,
0x000000545139723eULL, 0x000fe200000010ffULL, 0x0000007100697306ULL, 0x000e620000205400ULL,
0x000000013d3d0812ULL, 0x004fc800078efcffULL, 0x0000003c3d3f723eULL, 0x000fc600000010ffULL,
0x0000005e00657306ULL, 0x000ff00000209400ULL, 0x0000005e00677306ULL, 0x000ea20000205400ULL,
0x000000696800720bULL, 0x002fce0003f1d000ULL, 0x0000005e004c7306ULL, 0x000e70000020d400ULL,
0x00000071004d7306ULL, 0x000ee2000020d400ULL, 0x000000676500720bULL, 0x004fce0003fdd000ULL,
0x0000001200497306ULL, 0x000fec0000209400ULL, 0x000000014c4c6812ULL, 0x002fe400078efcffULL,
0x00000012004a7306ULL, 0x000e620000205400ULL, 0x000000014d4d0812ULL, 0x008fe400078efcffULL,
0x0000005b5c00720bULL, 0x000fca0003fdd000ULL, 0x00000070005e7306ULL, 0x000ff00000209400ULL,
0x0000007000637306ULL, 0x000ea20000205400ULL, 0x0000004a4900720bULL, 0x002fe40003fbd000ULL,
0x000000010e0e6812ULL, 0x000fca00078efcffULL, 0x0000003a00587306ULL, 0x000e70000000d400ULL,
0x0000006200597306ULL, 0x000fe20000209400ULL, 0x000000635e00720bULL, 0x004fce0003f7d000ULL,
0x00000062005a7306ULL, 0x000ea20000205400ULL, 0x0000000158582812ULL, 0x002fc800078efcffULL,
0x000000584d4a723eULL, 0x000fc600000010ffULL, 0x0000005200517306ULL, 0x000ff00000209400ULL,
0x0000005200547306ULL, 0x000e620000205400ULL, 0x0000005a5900720bULL, 0x004fce0003f1d000ULL,
0x0000001200127306ULL, 0x000eb0000020d400ULL, 0x00000070004b7306ULL, 0x000ee2000020d400ULL,
0x000000545100720bULL, 0x002fce0003f5d000ULL, 0x0000003b004e7306ULL, 0x000322000000d400ULL,
0x0000000112125812ULL, 0x004fce00078efcffULL, 0x0000006200137306ULL, 0x000ea2000020d400ULL,
0x000000384438723cULL, 0x002f620000041830ULL, 0x000000014b4b3812ULL, 0x008fcc00078efcffULL,
0x00000052003d7306ULL, 0x000e62000020d400ULL, 0x000000564430723cULL, 0x000b62000004182cULL,
0x000000014e4e4812ULL, 0x010fc800078efcffULL, 0x0000004e4b4b723eULL, 0x000fe400000010ffULL,
0x0000000113130812ULL, 0x004fe200078efcffULL, 0x000000424444723cULL, 0x000f640000041828ULL,
0x0000000a042c723eULL, 0x020fe400000010ffULL, 0x0000004c032d723eULL, 0x000fe400000010ffULL,
0x000000131212723eULL, 0x000fe400000010ffULL, 0x000000013d3d2812ULL, 0x002fe200078efcffULL,
0x0000003e2428723cULL, 0x000b620000041834ULL, 0x000176987c037811ULL, 0x000fc400078e18ffULL,
0x0000003d0e13723eULL, 0x000fca00000010ffULL, 0x0000002c242c723cULL, 0x040b700000041838ULL,
0x0000004a2430723cULL, 0x040b700000041830ULL, 0x000000122424723cULL, 0x000b620000041844ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000010367f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000003ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff047224ULL, 0x000fc600078e00ffULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x0000040010037984ULL, 0x008ee40000000800ULL,
0x8000000003ff7812ULL, 0x00cfc40007804837ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x00000034120a7210ULL, 0x000fca0007f1e1ffULL,
0x0000000135347824ULL, 0x000fe200000e0e13ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011434ULL,
0x0000000a03037211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e0634ULL,
0x0000000203037819ULL, 0x000fc8000000120aULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000104047810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040010037984ULL, 0x000ea40000000800ULL,
0x8000000003ff7812ULL, 0x004fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000166037810ULL, 0x000fc80007ffe0ffULL, 0x0000007a0300720cULL, 0x000fda0003f06070ULL,
0x0000072000000947ULL, 0x000fea0003800000ULL, 0x0000000266037810ULL, 0x000fe40007ffe0ffULL,
0x000001000f047810ULL, 0x000fe40007ffe0ffULL, 0x0000007a0300720cULL, 0x000fc60003f06070ULL,
0x000068007b0a7a24ULL, 0x000fd400078e0204ULL, 0x000003d000008947ULL, 0x000fea0003800000ULL,
0x0000000477037217ULL, 0x000fe20007800000ULL, 0x0000001079127824ULL, 0x000fe200078e00ffULL,
0x00000003ff0e7819ULL, 0x000fc60000011602ULL, 0x0000000103037824ULL, 0x000fe200078e0a04ULL,
0x000000040e137810ULL, 0x000fe20007ffe0ffULL, 0x00000001120f7824ULL, 0x000fe200078e020eULL,
0x000000080e347810ULL, 0x000fe40007ffe0ffULL, 0x0000000312037217ULL, 0x000fe20007800000ULL,
0x000000010f047824ULL, 0x040fe200078e0202ULL, 0x0000000c0e367810ULL, 0x000fe20007ffe0ffULL,
0x000000080f397824ULL, 0x000fe400078e00ffULL, 0x0000000103037824ULL, 0x000fc400078e0a12ULL,
0x0000000112357824ULL, 0x040fe200078e0234ULL, 0xfffffff839397812ULL, 0x000fe200078ee204ULL,
0x00000001123d7824ULL, 0x040fe200078e0236ULL, 0x000000031300720cULL, 0x080fe20003f66070ULL,
0x0000000112137824ULL, 0x000fe200078e0213ULL, 0x000000030e00720cULL, 0x080fe20003f86070ULL,
0x000000010f0e7824ULL, 0x000fe200078e020aULL, 0x000000033400720cULL, 0x080fe20003f46070ULL,
0x0000000113047824ULL, 0x040fe200078e0202ULL, 0x000000033600720cULL, 0x000fe20003f06070ULL,
0x00000008130f7824ULL, 0x000fc400078e00ffULL, 0x0000000113127824ULL, 0x100fe400078e020aULL,
0x0000000135347824ULL, 0x000fe200078e020aULL, 0xfffffff80f037812ULL, 0x000fe200078ee204ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000600e0e7212ULL, 0x000fc600078efcffULL, 0x0000000135047824ULL, 0x040fe200078e0202ULL,
0x000064000e0e7a10ULL, 0x000fe20007fbe0ffULL, 0x00000008353b7824ULL, 0x000fe200078e00ffULL,
0x0000006012127212ULL, 0x080fe200078efcffULL, 0x000000013d367824ULL, 0x000fe200078e020aULL,
0x000065000f0f7a10ULL, 0x000fe20002ffe4ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe400078ee204ULL, 0x0000640012127a10ULL, 0x000fe20007fbe0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006034347212ULL, 0x000fc400078efcffULL,
0x0000650013137a10ULL, 0x000fe20002ffe4ffULL, 0x000000013d047824ULL, 0x040fe200078e0202ULL,
0x0000006036367212ULL, 0x000fe200078efcffULL, 0x000000083d3d7824ULL, 0x000fe200078e00ffULL,
0x0000640034347a10ULL, 0x000fe20007fbe0ffULL, 0x0000001039397824ULL, 0x100fe200078e026eULL,
0x0000640036367a10ULL, 0x000fe20007fde0ffULL, 0x0000001003037824ULL, 0x000fe200078e026eULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee204ULL, 0x000000103b3b7824ULL, 0x100fe200078e026eULL,
0x0000650035357a10ULL, 0x000fe20002ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e397faeULL, 0x0005e2000e101c46ULL, 0x0000650037377a10ULL, 0x000fe200037fe4ffULL,
0x000000103d3d7824ULL, 0x000fc400078e026eULL, 0x0000000012037faeULL, 0x0005e8000d901c46ULL,
0x00000000343b7faeULL, 0x0005e8000d101c46ULL, 0x00000000363d7faeULL, 0x0005e2000c101c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001079037824ULL, 0x000fca00078e00ffULL,
0x0000000302037211ULL, 0x000fc800078fe8ffULL, 0x00000004030f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000103047824ULL, 0x140fe200078e0202ULL, 0x0000000803137810ULL, 0x040fe20007ffe0ffULL,
0x0000000803397824ULL, 0x000fe400078e00ffULL, 0x000000010f0e7824ULL, 0x040fe400078e0202ULL,
0x000000080f3b7824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee204ULL,
0x0000000113127824ULL, 0x040fe400078e0202ULL, 0x00000008133d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee20eULL, 0x00000001030e7824ULL, 0x140fe200078e020aULL,
0x0000000c03037810ULL, 0x000fe20007ffe0ffULL, 0x000000010f367824ULL, 0x000fe200078e020aULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee212ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000000113127824ULL, 0x100fe200078e020aULL, 0x000000600e0e7212ULL, 0x000fe200078efcffULL,
0x0000000103347824ULL, 0x000fe400078e020aULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000064000e0e7a10ULL, 0x000fc60007f1e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000006036367212ULL, 0x080fe400078efcffULL, 0x000065000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000006012127212ULL, 0x080fe400078efcffULL,
0x0000640036367a10ULL, 0x000fe20007f5e0ffULL, 0x0000000103047824ULL, 0x040fe200078e0202ULL,
0x0000006034347212ULL, 0x000fe200078efcffULL, 0x0000000803037824ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fe20007f1e0ffULL, 0x0000001039397824ULL, 0x100fe200078e026eULL,
0x0000640034347a10ULL, 0x000fe20007f7e0ffULL, 0x000000103b3b7824ULL, 0x000fe200078e026eULL,
0xfffffff803037812ULL, 0x000fe200078ee204ULL, 0x000000103d3d7824ULL, 0x100fe200078e026eULL,
0x0000650037377a10ULL, 0x000fe200017fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e397faeULL, 0x0005e2000b901c46ULL, 0x0000650013137a10ULL, 0x000fe200007fe4ffULL,
0x0000001003037824ULL, 0x000fe200078e026eULL, 0x0000650035357a10ULL, 0x000fe20001ffe4ffULL,
0x00000000363b7faeULL, 0x0005e8000b901c46ULL, 0x00000000123d7faeULL, 0x0005e8000b901c46ULL,
0x0000000034037faeULL, 0x0005e4000b901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000001078037824ULL, 0x004fe200078e00ffULL, 0x0000000811047812ULL, 0x000fc400078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x0000001003037812ULL, 0x000fca00078ee2ffULL,
0x000000207c037824ULL, 0x000fc800078e0203ULL, 0x0000000104037824ULL, 0x000fe200078e0203ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff0e7f8cULL, 0x000ea2000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176680003347f8cULL, 0x000662000c80043fULL, 0x000000ffff0a7224ULL, 0x004fc600078e000fULL,
0x00000000000e7805ULL, 0x000fc80000015200ULL, 0x01766c0003137984ULL, 0x000ea40000000800ULL,
0x8000000013ff7812ULL, 0x006fe40007804835ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x000000120e377210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e0fULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011413ULL, 0x0000003704047211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000204047819ULL, 0x000fc80000001213ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01766c0003137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001807c037811ULL, 0x008fc800078e38ffULL,
0x0000000375037210ULL, 0x000fca0007ffe060ULL, 0x01700000030f7984ULL, 0x000e680000000800ULL,
0x0172000003047984ULL, 0x0004e20000000800ULL, 0x000000080f00720bULL, 0x002fe20003f1d000ULL,
0x0000c7a27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x004fc800000e0100ULL,
0x0000ffff13357812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff037424ULL, 0x000fe400078e00ffULL, 0x000000ffff127224ULL, 0x000fd200078e0008ULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x000000037c137810ULL, 0x000fe40007ffe0ffULL,
0x000000080f00720bULL, 0x000fe40003f54000ULL, 0x000000001300720cULL, 0x000fe20003f05270ULL,
0x0000c7527f007947ULL, 0x000fd4000b800000ULL, 0x00000000000e7806ULL, 0x000fc400010e0100ULL,
0x0000008000608824ULL, 0x000fe200078e0260ULL, 0x000000080f127209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x000099100e137816ULL, 0x000fe200000000ffULL,
0x0000000175758824ULL, 0x000fca00078e0260ULL, 0x0174001275008388ULL, 0x0003e20000000800ULL,
0x000000ff1300720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000812087221ULL, 0x002fe20000010100ULL, 0x000000ff0eff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b08087820ULL, 0x000fcc0000410000ULL,
0x0000000800087308ULL, 0x000e640000000800ULL, 0x0000000807077220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x000fe20000011602ULL,
0x0000c6927f007947ULL, 0x000fea000b800000ULL, 0x00001f1308137589ULL, 0x0002a400000e0000ULL,
0x0000001328287220ULL, 0x084fe40000410000ULL, 0x0000001329297220ULL, 0x080fe40000410000ULL,
0x000000132c2c7220ULL, 0x080fe40000410000ULL, 0x000000132d2d7220ULL, 0x000fc40000410000ULL,
0x0000001330307220ULL, 0x080fe40000410000ULL, 0x0000001331317220ULL, 0x080fe40000410000ULL,
0x0000001324247220ULL, 0x080fe40000410000ULL, 0x0000001325257220ULL, 0x080fe40000410000ULL,
0x0000001314147220ULL, 0x080fe40000410000ULL, 0x0000001315157220ULL, 0x000fc40000410000ULL,
0x0000001318187220ULL, 0x080fe40000410000ULL, 0x0000001319197220ULL, 0x080fe40000410000ULL,
0x000000131c1c7220ULL, 0x080fe40000410000ULL, 0x000000131d1d7220ULL, 0x080fe40000410000ULL,
0x0000001320207220ULL, 0x080fe40000410000ULL, 0x0000001321217220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000eff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802137811ULL, 0x000fe200078ff0ffULL,
0x0000c5927f007947ULL, 0x000fea000b800000ULL, 0x00001f1308137589ULL, 0x00046400000e0000ULL,
0x000000132a2a7220ULL, 0x086fe40000410000ULL, 0x000000132b2b7220ULL, 0x080fe40000410000ULL,
0x000000132e2e7220ULL, 0x080fe40000410000ULL, 0x000000132f2f7220ULL, 0x080fe40000410000ULL,
0x0000001332327220ULL, 0x080fe40000410000ULL, 0x0000001333337220ULL, 0x000fc40000410000ULL,
0x0000001326267220ULL, 0x080fe40000410000ULL, 0x0000001327277220ULL, 0x080fe40000410000ULL,
0x0000001316167220ULL, 0x080fe40000410000ULL, 0x0000001317177220ULL, 0x080fe40000410000ULL,
0x000000131a1a7220ULL, 0x080fe40000410000ULL, 0x000000131b1b7220ULL, 0x000fc40000410000ULL,
0x000000131e1e7220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x080fe40000410000ULL,
0x0000001322227220ULL, 0x080fe40000410000ULL, 0x0000001323237220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff35ff7812ULL, 0x000fda000780600eULL,
0x0000000f120f0221ULL, 0x000fe20000010100ULL, 0x00007610ff030816ULL, 0x000fc60000000003ULL,
0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL, 0x0000000f000d0308ULL, 0x000e640000000800ULL,
0x0000000d04040220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000704077221ULL, 0x008fc40000010000ULL, 0x00000000000e7805ULL, 0x000fca0000015200ULL,
0xfffffff011087812ULL, 0x000fe200078ec0ffULL, 0x0000000400047824ULL, 0x000fc800078e00ffULL,
0x0176b40008137984ULL, 0x000e620000000800ULL, 0x0000000404047812ULL, 0x000fc800078ec0ffULL,
0x00000002043e7812ULL, 0x000fe400078efcffULL, 0x8000000013ff7812ULL, 0x002fe20007804841ULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x000000340e137210ULL, 0x000fca0007f1e1ffULL, 0x0000000135347824ULL, 0x000fe200000e0e0fULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff3400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff3400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011434ULL, 0x0000001304047211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0634ULL, 0x0000000204047819ULL, 0x000fc80000001213ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0176b40008137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991003037816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f65270ULL, 0x0000016000003947ULL, 0x000fea0003800000ULL,
0x0000000dff03723eULL, 0x000fe400000010ffULL, 0x00000002ff047819ULL, 0x000fe40000011602ULL,
0x0000541003037816ULL, 0x000fe20000000003ULL, 0x0000c1427f007947ULL, 0x000fea000b800000ULL,
0x00001f04030c7589ULL, 0x0002a400000e0000ULL, 0x0000000804137810ULL, 0x000fe20007ffe0ffULL,
0x0000c1927f007947ULL, 0x000fea000b800000ULL, 0x00001f13030b7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001004137810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff387224ULL, 0x000fe200078e0003ULL, 0x0000cf9000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000c72000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001804137810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff387224ULL, 0x000fe200078e0003ULL,
0x0000d00000397802ULL, 0x000fe20000000f00ULL, 0x0000001fff3b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000c6b000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000702137812ULL, 0x00cfe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000037c3d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000813037812ULL, 0x002fca00078ef802ULL, 0x0000000803037824ULL, 0x000fca00078e00ffULL,
0xfffffff803037812ULL, 0x000fe400078ee206ULL, 0x0000000802067812ULL, 0x000fc600078ec0ffULL,
0x000000807c3c7824ULL, 0x000fca00078e0203ULL, 0x000128003c3c7811ULL, 0x000fc400078e20ffULL,
0x000000006b38783bULL, 0x000e620000004200ULL, 0x000010006e6e7810ULL, 0x000fe40007ffe0ffULL,
0x0000001306137212ULL, 0x000fe200078efcffULL, 0x0000010038347824ULL, 0x002fe200078e00ffULL,
0x0000003800557306ULL, 0x000fe20000009400ULL, 0x00000018ff037819ULL, 0x000fe40000011438ULL,
0x00000018ff357819ULL, 0x000fe40000011439ULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff367819ULL, 0x000fe2000001143aULL, 0x0000003800657306ULL, 0x000e620000005400ULL,
0x00000018ff377819ULL, 0x000fce000001143bULL, 0x0000003400617306ULL, 0x000ff00000209400ULL,
0x0000003400627306ULL, 0x000ea20000205400ULL, 0x000000655500720bULL, 0x002fce0003fbd000ULL,
0x00000038006f7306ULL, 0x0002f0000000d400ULL, 0x0000003400737306ULL, 0x000922000020d400ULL,
0x0001000038387824ULL, 0x002fe200078e00ffULL, 0x000000626100720bULL, 0x004fc80003f5d000ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000000300407306ULL, 0x000fe20000209400ULL,
0x000000016f6f5812ULL, 0x008fe200078efcffULL, 0x0000001050347824ULL, 0x010fcc00078e026eULL,
0x0000000300467306ULL, 0x000e620000205400ULL, 0x0000000173732812ULL, 0x000fce00078efcffULL,
0x0000003800447306ULL, 0x000ff00000209400ULL, 0x0000003800457306ULL, 0x000ea20000205400ULL,
0x000000464000720bULL, 0x002fe40003f5d000ULL, 0x0000003e02407211ULL, 0x000fca00078fe0ffULL,
0x00000035000f7306ULL, 0x000fe20000209400ULL, 0x00000001133e7824ULL, 0x100fe400078e0240ULL,
0x0000000109407824ULL, 0x040fe400078e0240ULL, 0x0000000809097824ULL, 0x000fc600078e00ffULL,
0x00000035003f7306ULL, 0x000fe20000205400ULL, 0x000000454400720bULL, 0x004fe20003fbd000ULL,
0x0000000813457824ULL, 0x000fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fc800078ee240ULL,
0xfffffff845457812ULL, 0x000fe200078ee23eULL, 0x00000035006c7306ULL, 0x0003e2000020d400ULL,
0x0000001009097824ULL, 0x000fc600078e026eULL, 0x0000001045457824ULL, 0x000fc800078e0274ULL,
0x0000003b00477306ULL, 0x000fe20000009400ULL, 0x0000010039357824ULL, 0x002fca00078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011435ULL, 0x0000003b004f7306ULL, 0x000e700000005400ULL,
0x00000003006d7306ULL, 0x000eb0000020d400ULL, 0x0000003600087306ULL, 0x000fe20000209400ULL,
0x0000004f4700720bULL, 0x002fc40003f1d000ULL, 0x000000004544783bULL, 0x000e6a0000004200ULL,
0x00000036000e7306ULL, 0x000fe20000205400ULL, 0x000000016d6d2812ULL, 0x004fe400078efcffULL,
0x0000003f0f00720bULL, 0x000fca0003f5d000ULL, 0x00000036005f7306ULL, 0x000ff0000020d400ULL,
0x0000003700047306ULL, 0x000fe20000209400ULL, 0x000000016c6c2812ULL, 0x000fce00078efcffULL,
0x0000003700037306ULL, 0x000eb00000205400ULL, 0x0000003700637306ULL, 0x0007e2000020d400ULL,
0x00000018ff687819ULL, 0x002fe40000011445ULL, 0x00000018ff747819ULL, 0x000fca0000011446ULL,
0x0000003800717306ULL, 0x000322000020d400ULL, 0x000000003434783bULL, 0x008ee20000004200ULL,
0x000000030400720bULL, 0x004fcc0003f5d000ULL, 0x00000041005b7306ULL, 0x000fe20000209400ULL,
0x000001003a387824ULL, 0x002fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000004100607306ULL, 0x000e620000205400ULL, 0x0000000171715812ULL, 0x010fe400078efcffULL,
0x0000000163632812ULL, 0x000fca00078efcffULL, 0x00000039005c7306ULL, 0x000ff00000009400ULL,
0x00000039005a7306ULL, 0x000ea20000005400ULL, 0x000000605b00720bULL, 0x002fce0003fbd000ULL,
0x0000003900547306ULL, 0x0003e2000000d400ULL, 0x00000018ff657819ULL, 0x008fe20000011436ULL,
0x00000100343e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fca0000011435ULL,
0x0000004100707306ULL, 0x000722000020d400ULL, 0x0001000039397824ULL, 0x002fe200078e00ffULL,
0x0000005a5c00720bULL, 0x004fe40003fdd000ULL, 0x00000018ff5a7819ULL, 0x000fe40000011437ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003a00587306ULL, 0x000fe20000009400ULL,
0x000001003b417824ULL, 0x008fca00078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000039004d7306ULL, 0x000fe20000209400ULL, 0x0000000170705812ULL, 0x010fe400078efcffULL,
0x0000000154546812ULL, 0x000fca00078efcffULL, 0x00000039005e7306ULL, 0x000e700000205400ULL,
0x0000003a00597306ULL, 0x000eb00000005400ULL, 0x0000003800487306ULL, 0x000fe20000209400ULL,
0x0000005e4d00720bULL, 0x002fc40003fbd000ULL, 0x00000018ff4d7819ULL, 0x000fca0000011444ULL,
0x00000038004a7306ULL, 0x000e620000205400ULL, 0x000000595800720bULL, 0x004fce0003f9d000ULL,
0x0000003a00527306ULL, 0x0004f0000000d400ULL, 0x0000003b00537306ULL, 0x0008e2000000d400ULL,
0x000100003a3a7824ULL, 0x004fe200078e00ffULL, 0x0000004a4800720bULL, 0x002fc80003fdd000ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000003900727306ULL, 0x000e62000020d400ULL,
0x000100003b3b7824ULL, 0x010fe200078e00ffULL, 0x0000000152524812ULL, 0x008fc800078efcffULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x00000038006b7306ULL, 0x0004e2000020d400ULL,
0x0000000153530812ULL, 0x000fce00078efcffULL, 0x0000004100497306ULL, 0x000fe20000209400ULL,
0x0000000172725812ULL, 0x002fe400078efcffULL, 0x0000000e0800720bULL, 0x000fe20003fbd000ULL,
0x0000010044087824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x004fe20000011434ULL,
0x00000100450e7824ULL, 0x000fe400078e00ffULL, 0x00000041004b7306ULL, 0x000e620000205400ULL,
0x000000016b6b6812ULL, 0x008fce00078efcffULL, 0x0000003a004c7306ULL, 0x000fe20000209400ULL,
0x000000015f5f5812ULL, 0x000fce00078efcffULL, 0x0000003a004e7306ULL, 0x000ea20000205400ULL,
0x0000004b4900720bULL, 0x002fce0003fdd000ULL, 0x0000003a00697306ULL, 0x000e70000020d400ULL,
0x0000003b00517306ULL, 0x000fe20000209400ULL, 0x0000004e4c00720bULL, 0x004fce0003f9d000ULL,
0x0000003b005d7306ULL, 0x000fec0000205400ULL, 0x0000000169694812ULL, 0x002fe400078efcffULL,
0x0000003b00647306ULL, 0x000ff0000020d400ULL, 0x00000065003a7306ULL, 0x000ff00000209400ULL,
0x00000065003b7306ULL, 0x000ff00000205400ULL, 0x0000006500507306ULL, 0x0003f0000020d400ULL,
0x0000006700577306ULL, 0x000fe20000209400ULL, 0x00000018ff657819ULL, 0x002fe2000001143eULL,
0x00010000343e7824ULL, 0x000fcc00078e00ffULL, 0x0000006700437306ULL, 0x000ff00000205400ULL,
0x0000006700557306ULL, 0x0003f0000020d400ULL, 0x00000041006a7306ULL, 0x000ea2000020d400ULL,
0x00000018ff677819ULL, 0x002fce000001143eULL, 0x0000006700597306ULL, 0x000ff00000209400ULL,
0x0000006700587306ULL, 0x000fe20000205400ULL, 0x000000016a6a6812ULL, 0x004fe400078efcffULL,
0x0000005d5100720bULL, 0x000fc40003fdd000ULL, 0x00000018ff5d7819ULL, 0x000fc6000001140eULL,
0x00000067005b7306ULL, 0x0003f0000020d400ULL, 0x0000003400067306ULL, 0x000fe20000009400ULL,
0x00000018ff677819ULL, 0x002fe40000011408ULL, 0x0000000164646812ULL, 0x000fca00078efcffULL,
0x00000067004b7306ULL, 0x000ff00000209400ULL, 0x00000067004c7306ULL, 0x000e700000205400ULL,
0x0000003400137306ULL, 0x000ea20000005400ULL, 0x0000004c4b00720bULL, 0x002fce0003fbd000ULL,
0x0000004500517306ULL, 0x000fe20000009400ULL, 0x00010000444b7824ULL, 0x000fe200078e00ffULL,
0x000000130600720bULL, 0x004fcc0003f1d000ULL, 0x00000045004c7306ULL, 0x000e700000005400ULL,
0x0000003800417306ULL, 0x000ff00000209400ULL, 0x0000003800427306ULL, 0x000fe20000205400ULL,
0x0000004c5100720bULL, 0x002fe20003f5d000ULL, 0x0001000045517824ULL, 0x000fcc00078e00ffULL,
0x0000003800567306ULL, 0x000ff0000020d400ULL, 0x0000005a00387306ULL, 0x000ff00000209400ULL,
0x0000005a00397306ULL, 0x000ff00000205400ULL, 0x0000005a004f7306ULL, 0x000ff0000020d400ULL,
0x00000065005a7306ULL, 0x000ff00000209400ULL, 0x00000065005c7306ULL, 0x000ff00000205400ULL,
0x0000006500627306ULL, 0x000ff0000020d400ULL, 0x0000004d005e7306ULL, 0x000ff00000209400ULL,
0x0000004d00657306ULL, 0x000e700000205400ULL, 0x0000004400067306ULL, 0x000ff00000009400ULL,
0x0000004400137306ULL, 0x000ea20000005400ULL, 0x000000655e00720bULL, 0x002fc40003f9d000ULL,
0x00000018ff657819ULL, 0x000fca0000011451ULL, 0x0000006700087306ULL, 0x000e70000020d400ULL,
0x0000005d004e7306ULL, 0x000fe20000209400ULL, 0x000000130600720bULL, 0x004fce0003fdd000ULL,
0x0000005d00497306ULL, 0x000ea20000205400ULL, 0x0000000108085812ULL, 0x002fce00078efcffULL,
0x0000005d000e7306ULL, 0x0002f0000020d400ULL, 0x0000006800487306ULL, 0x000fe20000209400ULL,
0x00000018ff5d7819ULL, 0x002fe4000001144bULL, 0x000000494e00720bULL, 0x004fca0003fbd000ULL,
0x00000068004a7306ULL, 0x000ff00000205400ULL, 0x0000006800047306ULL, 0x000fe2000020d400ULL,
0x000000010e0e5812ULL, 0x008fce00078efcffULL, 0x0000004500137306ULL, 0x0002b0000000d400ULL,
0x0000006500517306ULL, 0x000fe20000209400ULL, 0x0000010047457824ULL, 0x002fce00078e00ffULL,
0x0000006500687306ULL, 0x000e620000205400ULL, 0x0000000113132812ULL, 0x004fce00078efcffULL,
0x0000005d004b7306ULL, 0x000ff00000209400ULL, 0x0000005d005e7306ULL, 0x000ea20000205400ULL,
0x000000685100720bULL, 0x002fe40003f5d000ULL, 0x00000018ff687819ULL, 0x000fca0000011445ULL,
0x0000004400067306ULL, 0x0002f0000000d400ULL, 0x0000005d004c7306ULL, 0x000f22000020d400ULL,
0x0000010046447824ULL, 0x002fe200078e00ffULL, 0x0000005e4b00720bULL, 0x004fc80003fbd000ULL,
0x00000018ff677819ULL, 0x000fe40000011444ULL, 0x0000004d000f7306ULL, 0x000e62000020d400ULL,
0x0000000106066812ULL, 0x008fe400078efcffULL, 0x0000004a4800720bULL, 0x000fca0003fdd000ULL,
0x0000006700447306ULL, 0x000fe20000209400ULL, 0x000000014c4c5812ULL, 0x010fce00078efcffULL,
0x00000067005d7306ULL, 0x000ea20000205400ULL, 0x000000010f0f4812ULL, 0x002fe400078efcffULL,
0x0000000104046812ULL, 0x000fca00078efcffULL, 0x00000046004e7306ULL, 0x000ff00000009400ULL,
0x0000004600517306ULL, 0x000e620000005400ULL, 0x0000005d4400720bULL, 0x004fce0003fbd000ULL,
0x0000006500497306ULL, 0x0004f0000020d400ULL, 0x00000067004a7306ULL, 0x000f22000020d400ULL,
0x000000514e00720bULL, 0x002fe20003f9d000ULL, 0x00010000464e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff657819ULL, 0x004fe2000001144eULL, 0x0000006800457306ULL, 0x000fe20000209400ULL,
0x0000000149492812ULL, 0x008fe400078efcffULL, 0x000000424100720bULL, 0x000fe20003f5d000ULL,
0x0001000047417824ULL, 0x000fc800078e00ffULL, 0x00000068005e7306ULL, 0x000e620000205400ULL,
0x000000014a4a5812ULL, 0x010fce00078efcffULL, 0x0000003400617306ULL, 0x0004e2000000d400ULL,
0x0000000156562812ULL, 0x000fce00078efcffULL, 0x00000046004b7306ULL, 0x000f22000000d400ULL,
0x0000010035347824ULL, 0x004fe200078e00ffULL, 0x0000005e4500720bULL, 0x002fe40003fbd000ULL,
0x00000018ff457819ULL, 0x000fe40000011441ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000004700447306ULL, 0x000fe20000009400ULL, 0x0000000161610812ULL, 0x008fe400078efcffULL,
0x0000003b3a00720bULL, 0x000fca0003f1d000ULL, 0x00000047005d7306ULL, 0x000e620000005400ULL,
0x000000014b4b4812ULL, 0x010fc800078efcffULL, 0x0000004b4a4a723eULL, 0x000fc600000010ffULL,
0x0000006800487306ULL, 0x000ea2000020d400ULL, 0x0000000150500812ULL, 0x000fce00078efcffULL,
0x0000006500517306ULL, 0x000fe20000209400ULL, 0x0000005d4400720bULL, 0x002fce0003f9d000ULL,
0x0000006500427306ULL, 0x000e620000205400ULL, 0x0000000148485812ULL, 0x004fce00078efcffULL,
0x00000034003e7306ULL, 0x000ff00000209400ULL, 0x00000034003f7306ULL, 0x000ea20000205400ULL,
0x000000425100720bULL, 0x002fce0003fbd000ULL, 0x0000003400607306ULL, 0x000e70000020d400ULL,
0x0000007400347306ULL, 0x000fe20000209400ULL, 0x0000003f3e00720bULL, 0x004fce0003f5d000ULL,
0x00000074004d7306ULL, 0x000eac0000205400ULL, 0x0000000160602812ULL, 0x002fe400078efcffULL,
0x00000065004e7306ULL, 0x000e70000020d400ULL, 0x0000004500447306ULL, 0x000fe20000209400ULL,
0x0000004d3400720bULL, 0x004fce0003fdd000ULL, 0x00000045005d7306ULL, 0x000ea20000205400ULL,
0x000000014e4e5812ULL, 0x002fce00078efcffULL, 0x0000007400037306ULL, 0x000e70000020d400ULL,
0x00000047004d7306ULL, 0x000722000000d400ULL, 0x0000005d4400720bULL, 0x004fce0003fbd000ULL,
0x0000003500347306ULL, 0x000fe20000009400ULL, 0x0000000103036812ULL, 0x002fe400078efcffULL,
0x0000005c5a00720bULL, 0x000fe40003fdd000ULL, 0x00000018ff477819ULL, 0x008fc60000011447ULL,
0x0000003500677306ULL, 0x000e620000005400ULL, 0x000000014d4d4812ULL, 0x010fc800078efcffULL,
0x0000004d484b723eULL, 0x000fc600000010ffULL, 0x0000004500517306ULL, 0x000ea2000020d400ULL,
0x0000000162626812ULL, 0x000fe400078efcffULL, 0x000000585900720bULL, 0x000fe40003fdd000ULL,
0x000000673400720bULL, 0x002fe20003f9d000ULL, 0x0001000035347824ULL, 0x000fe400078e00ffULL,
0x0000003500657306ULL, 0x000e66000000d400ULL, 0x00000018ff467819ULL, 0x000fe20000011434ULL,
0x0000010036347824ULL, 0x000fe200078e00ffULL, 0x0000000151515812ULL, 0x004fc400078efcffULL,
0x000000435700720bULL, 0x000fe20003fbd000ULL, 0x0000010037437824ULL, 0x000fe200078e00ffULL,
0x0000004600417306ULL, 0x000fe20000209400ULL, 0x000000015b5b6812ULL, 0x000fe200078efcffULL,
0x0001000036577824ULL, 0x000fe200078e00ffULL, 0x000000393800720bULL, 0x000fe20003fdd000ULL,
0x000008003d387824ULL, 0x000fe200078e0205ULL, 0x00000018ff5c7819ULL, 0x000fe20000011434ULL,
0x000000003c3c783bULL, 0x000ea20000000200ULL, 0x0000000165654812ULL, 0x002fe200078efcffULL,
0x0000004600427306ULL, 0x000e620000205400ULL, 0x00000018ff6e7819ULL, 0x000fe20000011457ULL,
0x011000003838783bULL, 0x000ee20000000200ULL, 0x0000000155555812ULL, 0x000fca00078efcffULL,
0x00000046005e7306ULL, 0x000862000020d400ULL, 0x000000014f4f6812ULL, 0x000fce00078efcffULL,
0x0000003600587306ULL, 0x000fe20000005400ULL, 0x00000018ff467819ULL, 0x010fe40000011443ULL,
0x000000424100720bULL, 0x002fca0003f5d000ULL, 0x0000003600437306ULL, 0x000e700000009400ULL,
0x0000005c00347306ULL, 0x000fe20000209400ULL, 0x000000015e5e2812ULL, 0x000fe200078efcffULL,
0x0000000c3c3cb231ULL, 0x004fe200003400ffULL, 0x000000584300720bULL, 0x002fca0003f9d000ULL,
0x0000005c00357306ULL, 0x000e620000205400ULL, 0x000000000940783bULL, 0x000ea20000004200ULL,
0x0000000c3e3eb231ULL, 0x080fe400003400ffULL, 0x0000000b3d3db231ULL, 0x080fe400003400ffULL,
0x0000000b3f3fb231ULL, 0x000fe400003400ffULL, 0x0000004600447306ULL, 0x000fe20000209400ULL,
0x0000000c3838b231ULL, 0x088fe400003400ffULL, 0x0000000c3a3ab231ULL, 0x000fc400003400ffULL,
0x0000000b3939b231ULL, 0x080fe200003400ffULL, 0x0000004a3c1c723cULL, 0x000fe2000004181cULL,
0x0000000b3b3bb231ULL, 0x000fe200003400ffULL, 0x0000004600457306ULL, 0x000ee20000205400ULL,
0x000000353400720bULL, 0x002fe40003f5d000ULL, 0x0000006f7334723eULL, 0x000fe400000010ffULL,
0x000000547035723eULL, 0x000fc600000010ffULL, 0x0000004600597306ULL, 0x000e68000020d400ULL,
0x000000343c28723cULL, 0x000b680000041828ULL, 0x0000003700057306ULL, 0x000fe20000009400ULL,
0x000000454400720bULL, 0x008fe40003fbd000ULL, 0x000000716d34723eULL, 0x020fc400000010ffULL,
0x000000526b44723eULL, 0x000fe400000010ffULL, 0x000000726c35723eULL, 0x000fe200000010ffULL,
0x0000003700467306ULL, 0x000ee20000005400ULL, 0x00000018ff457819ULL, 0x004fe40000011442ULL,
0x00000018ff547819ULL, 0x000fc60000011440ULL, 0x000000343c2c723cULL, 0x000be2000004182cULL,
0x0000000159595812ULL, 0x002fe200078efcffULL, 0x00000037005d7306ULL, 0x0002b0000000d400ULL,
0x0000004500747306ULL, 0x000fe20000209400ULL, 0x0001000037377824ULL, 0x002fe200078e00ffULL,
0x000000460500720bULL, 0x008fc40003f7d000ULL, 0x00000018ff467819ULL, 0x000fe40000011441ULL,
0x00000018ff097819ULL, 0x000fe40000011437ULL, 0x00000045006d7306ULL, 0x000fee0000205400ULL,
0x000000015d5d3812ULL, 0x004fe200078efcffULL, 0x0000004500527306ULL, 0x0003e6000020d400ULL,
0x0000005d595d723eULL, 0x000fca00000010ffULL, 0x0000005c005a7306ULL, 0x000ea2000020d400ULL,
0x000000536a45723eULL, 0x002fe400000010ffULL, 0x00000018ff537819ULL, 0x000fca0000011443ULL,
0x00000036005c7306ULL, 0x000e70000000d400ULL, 0x0000006e00767306ULL, 0x000fe20000209400ULL,
0x000000015a5a2812ULL, 0x004fce00078efcffULL, 0x0000006e00757306ULL, 0x000ea20000205400ULL,
0x000000015c5c4812ULL, 0x002fc800078efcffULL, 0x0000005c5a5c723eULL, 0x000fe200000010ffULL,
0x00000100435a7824ULL, 0x000fe400078e00ffULL, 0x0000006e00587306ULL, 0x000e66000020d400ULL,
0x00000018ff5a7819ULL, 0x000fca000001145aULL, 0x0000000900377306ULL, 0x000fe20000209400ULL,
0x000000757600720bULL, 0x004fce0003f5d000ULL, 0x0000000900367306ULL, 0x000eac0000205400ULL,
0x0000000158582812ULL, 0x002fe400078efcffULL, 0x0000000900577306ULL, 0x000e70000020d400ULL,
0x0000004700687306ULL, 0x000fe20000209400ULL, 0x000000363700720bULL, 0x004fce0003f9d000ULL,
0x0000004700677306ULL, 0x000eac0000205400ULL, 0x0000000157574812ULL, 0x002fe400078efcffULL,
0x0000004700057306ULL, 0x000e70000020d400ULL, 0x00000046006f7306ULL, 0x000fe20000209400ULL,
0x000000676800720bULL, 0x004fce0003f5d000ULL, 0x00000046006e7306ULL, 0x000fec0000205400ULL,
0x0000000105052812ULL, 0x002fe400078efcffULL, 0x0000004600097306ULL, 0x0003e4000020d400ULL,
0x000000510505723eULL, 0x000fcc00000010ffULL, 0x0000004100347306ULL, 0x020fe20000009400ULL,
0x000000443c44723cULL, 0x002bee0000041830ULL, 0x0000010040307824ULL, 0x020fe200078e00ffULL,
0x000000646331723eULL, 0x000fe200000010ffULL, 0x0000004000327306ULL, 0x000fe60000009400ULL,
0x00000018ff357819ULL, 0x000fc40000011430ULL, 0x000000695f30723eULL, 0x000fc600000010ffULL,
0x00000035006a7306ULL, 0x000fe80000209400ULL, 0x000000303c24723cULL, 0x000b680000041824ULL,
0x0000004100317306ULL, 0x020e660000005400ULL, 0x0000010041307824ULL, 0x000fca00078e00ffULL,
0x0000003500697306ULL, 0x000eb00000205400ULL, 0x00000035005f7306ULL, 0x0007e2000020d400ULL,
0x000000313400720bULL, 0x002fe40003f7d000ULL, 0x000000616234723eULL, 0x000fca00000010ffULL,
0x0000004000337306ULL, 0x000e620000005400ULL, 0x00000018ff357819ULL, 0x008fe20000011430ULL,
0x0001000040307824ULL, 0x000fe200078e00ffULL, 0x000000696a00720bULL, 0x004fc80003f1d000ULL,
0x00000018ff317819ULL, 0x000fe20000011430ULL, 0x00000035006b7306ULL, 0x000fe20000209400ULL,
0x0001000041307824ULL, 0x000fce00078e00ffULL, 0x00000035006c7306ULL, 0x000ea20000205400ULL,
0x000000333200720bULL, 0x002fe40003fbd000ULL, 0x000000015f5f0812ULL, 0x000fca00078efcffULL,
0x0000003500637306ULL, 0x0003f0000020d400ULL, 0x0000004000647306ULL, 0x000ee2000000d400ULL,
0x000000656035723eULL, 0x002fe400000010ffULL, 0x00000018ff607819ULL, 0x000fc40000011430ULL,
0x0000005b5630723eULL, 0x000fe400000010ffULL, 0x0000006c6b00720bULL, 0x004fe20003f5d000ULL,
0x000000343834723cULL, 0x000be20000041828ULL, 0x0000003100767306ULL, 0x000fec0000209400ULL,
0x0000010042287824ULL, 0x020fe200078e00ffULL, 0x0000000164645812ULL, 0x008fe200078efcffULL,
0x0000004200297306ULL, 0x000fe60000005400ULL, 0x00000018ff2b7819ULL, 0x000fc40000011428ULL,
0x0000000163632812ULL, 0x000fc600078efcffULL, 0x0000004200287306ULL, 0x000e700000009400ULL,
0x0000002b00617306ULL, 0x000ff00000209400ULL, 0x0000002b005b7306ULL, 0x000fe20000205400ULL,
0x000000292800720bULL, 0x002fc40003f9d000ULL, 0x000000585028723eULL, 0x000fe400000010ffULL,
0x000000574f29723eULL, 0x000fe200000010ffULL, 0x00010000434f7824ULL, 0x000fe400078e00ffULL,
0x0000002b00567306ULL, 0x000fe6000020d400ULL, 0x00000018ff4f7819ULL, 0x000fca000001144fULL,
0x0000003100757306ULL, 0x000e700000205400ULL, 0x00000043002a7306ULL, 0x000ff00000009400ULL,
0x00000043002b7306ULL, 0x000ea20000005400ULL, 0x000000757600720bULL, 0x002fce0003fbd000ULL,
0x0000004100407306ULL, 0x000e70000000d400ULL, 0x0000003100417306ULL, 0x000722000020d400ULL,
0x0000002b2a00720bULL, 0x004fe40003fdd000ULL, 0x000000283828723cULL, 0x000bea0000041824ULL,
0x0000005400737306ULL, 0x000fe20000209400ULL, 0x0000005e5531723eULL, 0x008fc400000010ffULL,
0x000000130e25723eULL, 0x020fe400000010ffULL, 0x0000004c0f0e723eULL, 0x000fe400000010ffULL,
0x00000049040f723eULL, 0x000fe200000010ffULL, 0x0000005400707306ULL, 0x000ea20000205400ULL,
0x000000303830723cULL, 0x000fe2000004182cULL, 0x000000060824723eULL, 0x000fe400000010ffULL,
0x0000000140403812ULL, 0x002fe400078efcffULL, 0x0000000141415812ULL, 0x010fc400078efcffULL,
0x0000006000657306ULL, 0x000fe20000209400ULL, 0x0000005c382c723cULL, 0x000be20000041844ULL,
0x0000006e6f00720bULL, 0x000fe40003f7d000ULL, 0x0000005b6100720bULL, 0x000fe40003fbd000ULL,
0x0000004e0304723eULL, 0x000fe400000010ffULL, 0x0000006000627306ULL, 0x000e620000205400ULL,
0x0001000042477824ULL, 0x020fe200078e00ffULL, 0x0000000e3c18723cULL, 0x000fe20000041818ULL,
0x000000707300720bULL, 0x004fc60003f1d000ULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000005400547306ULL, 0x000ea2000020d400ULL, 0x0000000109093812ULL, 0x000fe200078efcffULL,
0x000000243c14723cULL, 0x000b620000041814ULL, 0x0000000156565812ULL, 0x000fca00078efcffULL,
0x0000006000607306ULL, 0x000ee2000020d400ULL, 0x000000626500720bULL, 0x002fe20003f5d000ULL,
0x000000043c3c723cULL, 0x000b640000041820ULL, 0x000000645f24723eULL, 0x020fe400000010ffULL,
0x000000406325723eULL, 0x000fe400000010ffULL, 0x0000004200457306ULL, 0x000e62000000d400ULL,
0x0000000154540812ULL, 0x004fe400078efcffULL, 0x0000006d7400720bULL, 0x000fca0003f1d000ULL,
0x0000005300727306ULL, 0x000fe20000209400ULL, 0x0000000160602812ULL, 0x008fe200078efcffULL,
0x000000243824723cULL, 0x000b660000041814ULL, 0x000000600909723eULL, 0x000fc600000010ffULL,
0x0000005300717306ULL, 0x000ea20000205400ULL, 0x0000000145454812ULL, 0x002fe400078efcffULL,
0x0000000152520812ULL, 0x000fe400078efcffULL, 0x000000455656723eULL, 0x000fc600000010ffULL,
0x0000005a00557306ULL, 0x000ff00000209400ULL, 0x0000005a00597306ULL, 0x000e620000205400ULL,
0x000000717200720bULL, 0x004fce0003f5d000ULL, 0x0000004700467306ULL, 0x000ff00000209400ULL,
0x0000004700067306ULL, 0x000ea20000205400ULL, 0x000000595500720bULL, 0x002fce0003f7d000ULL,
0x0000004f00087306ULL, 0x000ff00000209400ULL, 0x0000004f000f7306ULL, 0x000e620000205400ULL,
0x000000064600720bULL, 0x004fce0003fbd000ULL, 0x0000005300537306ULL, 0x000eb0000020d400ULL,
0x0000005a00447306ULL, 0x000ee2000020d400ULL, 0x0000000f0800720bULL, 0x002fe40003f9d000ULL,
0x000000415408723eULL, 0x000fca00000010ffULL, 0x0000004300427306ULL, 0x000e62000000d400ULL,
0x0000000153532812ULL, 0x004fe200078efcffULL, 0x000000083820723cULL, 0x000b6c0000041818ULL,
0x0000004700477306ULL, 0x000ea2000020d400ULL, 0x0000000144443812ULL, 0x008fce00078efcffULL,
0x0000004f00047306ULL, 0x000ee2000020d400ULL, 0x0000000142426812ULL, 0x002fc800078efcffULL,
0x000000424457723eULL, 0x000fe400000010ffULL, 0x0000000147475812ULL, 0x004fc800078efcffULL,
0x000000475252723eULL, 0x000fe200000010ffULL, 0x00000056381c723cULL, 0x000b62000004181cULL,
0x0000000104044812ULL, 0x008fc800078efcffULL, 0x000000045353723eULL, 0x000fce00000010ffULL,
0x000000523814723cULL, 0x000b62000004183cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000010047f8cULL, 0x0002a2000c80043fULL, 0x0000000166667810ULL, 0x000fe40007ffe0ffULL,
0x000176a07c067811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000006ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff037224ULL, 0x004fe200078e0005ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff287000007947ULL, 0x000fea000383ffffULL,
0x000000ff7a00720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000007007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000eff000047802ULL, 0x004fc40000000f00ULL,
0x0000a50000007944ULL, 0x02afea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x000f240000001000ULL, 0xbf80000000027423ULL, 0x010fc80000000007ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006d00ff037624ULL, 0x000fe400078e00ffULL,
0x00006c00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000f28000c1e9900ULL,
0x0000000000047919ULL, 0x004ea80000000000ULL, 0x0000000000077919ULL, 0x002e620000000000ULL,
0x00000002ff067819ULL, 0x00cfe40000011604ULL, 0x0000000807047811ULL, 0x002fe200078ff0ffULL,
0x0000000003057220ULL, 0x010fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000003400347220ULL, 0x042fe40000410000ULL,
0x0000003500357220ULL, 0x040fe40000410000ULL, 0x0000003000307220ULL, 0x040fe40000410000ULL,
0x0000003100317220ULL, 0x000fc40000410000ULL, 0x0000002c002c7220ULL, 0x040fe40000410000ULL,
0x0000002d002d7220ULL, 0x040fe40000410000ULL, 0x0000002800287220ULL, 0x040fe40000410000ULL,
0x0000002900297220ULL, 0x040fe40000410000ULL, 0x0000002400247220ULL, 0x060fe40000410000ULL,
0x0000002500257220ULL, 0x000fc40000410000ULL, 0x0000002000207220ULL, 0x040fe40000410000ULL,
0x0000002100217220ULL, 0x040fe40000410000ULL, 0x0000001c001c7220ULL, 0x040fe40000410000ULL,
0x0000001d001d7220ULL, 0x040fe40000410000ULL, 0x0000001400147220ULL, 0x040fe40000410000ULL,
0x0000001500157220ULL, 0x000fc40000410000ULL, 0x0000003604367220ULL, 0x044fe40000410000ULL,
0x0000003704377220ULL, 0x040fe40000410000ULL, 0x0000003204327220ULL, 0x040fe40000410000ULL,
0x0000003304337220ULL, 0x040fe40000410000ULL, 0x0000002e042e7220ULL, 0x040fe40000410000ULL,
0x0000002f042f7220ULL, 0x000fc40000410000ULL, 0x0000002a042a7220ULL, 0x040fe40000410000ULL,
0x0000002b042b7220ULL, 0x040fe40000410000ULL, 0x0000002604267220ULL, 0x040fe40000410000ULL,
0x0000002704277220ULL, 0x040fe40000410000ULL, 0x0000002204227220ULL, 0x040fe40000410000ULL,
0x0000002304237220ULL, 0x000fc40000410000ULL, 0x0000001e041e7220ULL, 0x040fe40000410000ULL,
0x0000001f041f7220ULL, 0x040fe40000410000ULL, 0x0000001604167220ULL, 0x040fe40000410000ULL,
0x0000001704177220ULL, 0x000fc40000410000ULL, 0x0000000000007919ULL, 0x000f220000000000ULL,
0x000000202120723eULL, 0x020fe200000010ffULL, 0x00000020780b7824ULL, 0x002fe200078e00ffULL,
0x0000001c1d1c723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000002e2f2e723eULL, 0x000fc400000010ffULL, 0x0000002a2b2a723eULL, 0x000fe400000010ffULL,
0x000000262726723eULL, 0x000fe400000010ffULL, 0x000000222313723eULL, 0x000fe400000010ffULL,
0x0000001e1f1e723eULL, 0x000fe400000010ffULL, 0x00000016170f723eULL, 0x000fe400000010ffULL,
0x00000002ff057819ULL, 0x014fc40000011600ULL, 0x0000000200027812ULL, 0x040fe400078ec0ffULL,
0x0000000800077811ULL, 0x000fe200078ff0ffULL, 0x0000000805097824ULL, 0x040fe200078e00ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fe200078ff8ffULL, 0x00000008070e7824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x040fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x0000000404067810ULL, 0x008fc40007ffe0ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL,
0x0000100079037824ULL, 0x000fe200078e00ffULL, 0xfffffff809087812ULL, 0x000fe400078ee202ULL,
0xfffffff807027812ULL, 0x000fe200078ee204ULL, 0x0000080078057824ULL, 0x000fe200078e0203ULL,
0x0000000604077810ULL, 0x000fe20007ffe0ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff8090a7812ULL, 0x000fe200078ee206ULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x000000100e0e7824ULL, 0x100fe200078e0205ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x0000001008087824ULL, 0x100fe200078e0205ULL,
0x000000343502723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0205ULL,
0x000000303104723eULL, 0x000fe200000010ffULL, 0x0000000106067824ULL, 0x000fc400078e0207ULL,
0x000000100c0c7824ULL, 0x000fe200078e0205ULL, 0x0000541002107816ULL, 0x040fe20000000004ULL,
0x0000000107097824ULL, 0x040fe200078e020eULL, 0x0000763202117816ULL, 0x000fe20000000004ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x0000002c2d02723eULL, 0x000fe200000010ffULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x000000282904723eULL, 0x000fe200000010ffULL,
0x0000001006007388ULL, 0x0003e20000000a00ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000242505723eULL, 0x000fc400000010ffULL, 0x0000763202077816ULL, 0x140fe40000000004ULL,
0x00000014150e723eULL, 0x000fe400000010ffULL, 0x0000541002067816ULL, 0x002fe40000000004ULL,
0x000000363702723eULL, 0x000fe400000010ffULL, 0x000000323304723eULL, 0x000fe200000010ffULL,
0x0000000608007388ULL, 0x0003e20000000a00ULL, 0x000054102e107816ULL, 0x000fc4000000002aULL,
0x000076322e117816ULL, 0x000fe4000000002aULL, 0x0000541005067816ULL, 0x142fe40000000020ULL,
0x0000763205077816ULL, 0x000fe40000000020ULL, 0x000000ff00057306ULL, 0x000fe60000209400ULL,
0x000000060a007388ULL, 0x0003e40000000a00ULL, 0x000054101c067816ULL, 0x002fc4000000000eULL,
0x000076321c077816ULL, 0x000fe4000000000eULL, 0x000054101e0e7816ULL, 0x140fe4000000000fULL,
0x000076321e0f7816ULL, 0x000fe2000000000fULL, 0x000000060c007388ULL, 0x0003e40000000a00ULL,
0x0000541002067816ULL, 0x142fe40000000004ULL, 0x0000763202077816ULL, 0x000fe20000000004ULL,
0x000000010b027824ULL, 0x000fe200078e0200ULL, 0x000000ff00047306ULL, 0x000e660000205400ULL,
0x0000000609007388ULL, 0x0005e80000000a00ULL, 0x0004001008007388ULL, 0x0007e20000000a00ULL,
0x0000763226097816ULL, 0x004fe20000000013ULL, 0x0000001002067824ULL, 0x000fe200078e0203ULL,
0x000000040500720bULL, 0x002fe20003f1d000ULL, 0x000000ff00027306ULL, 0x000e62000020d400ULL,
0x0000541026087816ULL, 0x008fca0000000013ULL, 0x000400080a007388ULL, 0x000fe80000000a00ULL,
0x0004000e0c007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000006107984ULL, 0x000ea20000000c00ULL, 0x0000000102020812ULL, 0x002fc400078efcffULL,
0x000000ff7800720cULL, 0x000fe20003f05270ULL, 0x0004000006087984ULL, 0x000e620000000c00ULL,
0x000000020204723eULL, 0x000fc600000010ffULL, 0x0008000006147984ULL, 0x000ee80000000c00ULL,
0x000c000006187984ULL, 0x000f220000000c00ULL, 0x3f803f8004137831ULL, 0x044fe40000200013ULL,
0x3f803f8004127831ULL, 0x040fe40000200012ULL, 0x3f803f8004117831ULL, 0x040fe40000200011ULL,
0x3f803f8004107831ULL, 0x000fc40000200010ULL, 0x3f803f80040b7831ULL, 0x042fe4000020000bULL,
0x3f803f80040a7831ULL, 0x040fe4000020000aULL, 0x3f803f8004097831ULL, 0x040fe40000200009ULL,
0x3f803f8004087831ULL, 0x000fe40000200008ULL, 0x3f803f8013137831ULL, 0x008fe40000200017ULL,
0x3f803f8012127831ULL, 0x000fc40000200016ULL, 0x3f803f8011117831ULL, 0x000fe40000200015ULL,
0x3f803f8010107831ULL, 0x000fe40000200014ULL, 0x3f803f800b0b7831ULL, 0x010fe4000020001bULL,
0x3f803f800a0a7831ULL, 0x000fe2000020001aULL, 0x0000001006007388ULL, 0x000fe20000000c00ULL,
0x3f803f8009097831ULL, 0x000fe40000200019ULL, 0x3f803f8008087831ULL, 0x000fca0000200018ULL,
0x0004000806007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000400011f7983ULL, 0x000ea20000100800ULL,
0x00000003ff067819ULL, 0x000fc80000011600ULL, 0x0000001f0600720cULL, 0x004fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000011d7983ULL, 0x000ea80000100800ULL,
0x00000800011c7983ULL, 0x000ee20000100800ULL, 0x00005a0000087b06ULL, 0x000e620000209000ULL,
0x000000017d027824ULL, 0x000fe200078e0206ULL, 0x00005a00ff107a12ULL, 0x000fe400078e33ffULL,
0x00000007000e7812ULL, 0x000fc800078ec0ffULL, 0x0000000800087308ULL, 0x002e640000001000ULL,
0x0ffffffe08047810ULL, 0x002fcc0007ffe0ffULL, 0x0000000400057305ULL, 0x000324000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000ffff077224ULL, 0x010fc800078e0a05ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x00000007050d7227ULL, 0x000fc800078e0004ULL,
0x0000000106047824ULL, 0x000fe400078e0200ULL, 0x000000020d077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x0000000704057812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x0ffffff805047812ULL, 0x000fca00078ef800ULL, 0x0000001004067824ULL, 0x000fe400078e0203ULL,
0x0000000107071810ULL, 0x000fc60007ffe0ffULL, 0x0000000006087984ULL, 0x0003220000000c00ULL,
0x0000000710077207ULL, 0x000fca0004000000ULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x00005a0005027a24ULL, 0x000fe400078e0202ULL, 0x0000590007077a24ULL, 0x004fc800078e021dULL,
0x00005a0007027a24ULL, 0x000fe400078e0202ULL, 0x0000000879077824ULL, 0x000fc600078e020eULL,
0x000000021c057210ULL, 0x008fe40007f3e0ffULL, 0x0000002000027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x040fe400078240ffULL,
0x00000003ff067819ULL, 0x002fe40000011602ULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x0000001f0600720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0103ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000017d047824ULL, 0x102fe200078e0206ULL, 0x00000040000c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000102067824ULL, 0x000fe400078e0206ULL, 0x000000040d077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x00005a0005057a24ULL, 0x000fca00078e0204ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0000000706057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805067812ULL, 0x000fe400078ef802ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001006067824ULL, 0x000fe400078e0203ULL,
0x0000000107072810ULL, 0x000fc60007ffe0ffULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000710077207ULL, 0x000fca0004000000ULL, 0x000000ffff057224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe200078e021dULL, 0x00000003ff067819ULL, 0x002fe2000001160cULL,
0x00005a0005047a24ULL, 0x000fc800078e0204ULL, 0x00005a0007047a24ULL, 0x000fe400078e0204ULL,
0x0000000879077824ULL, 0x000fc600078e0202ULL, 0x000000041c057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440eULL, 0x0000001f0600720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000017d027824ULL, 0x100fe200078e0206ULL,
0x0000006000007810ULL, 0x000fe20007ffe0ffULL, 0x000000010c067824ULL, 0x000fe400078e0206ULL,
0x000000020d077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x002fc800078e0a07ULL,
0x00005a0005047a24ULL, 0x000fe200078e0202ULL, 0x0000000706057812ULL, 0x000fc800078ec0ffULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff805047812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fca00078e0203ULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000107072810ULL, 0x000fc80007ffe0ffULL, 0x0000000710077207ULL, 0x000fca0004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e021dULL,
0x00005a0005027a24ULL, 0x000fc800078e0202ULL, 0x00005a0007027a24ULL, 0x000fe400078e0202ULL,
0x0000000879077824ULL, 0x000fc600078e020cULL, 0x000000021c027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00005e0002047a11ULL, 0x000fc800078240ffULL,
0x00005f0002057a11ULL, 0x000fe400008f4405ULL, 0x00000003ff027819ULL, 0x000fc60000011600ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000001f0200720cULL, 0x000fc60003f26070ULL,
0x000000017d7d7824ULL, 0x000fe200078e0202ULL, 0x0000000804007986ULL, 0x0023f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000007d0d087227ULL, 0x002fc800078e00ffULL,
0x000000ffff047224ULL, 0x000fe400078e0a08ULL, 0x0000000100027824ULL, 0x000fe400078e0202ULL,
0x00005a0004047a24ULL, 0x000fc600078e027dULL, 0x0000000702057812ULL, 0x000fe400078ec0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f26070ULL, 0xfffffff805027812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fca00078ec0ffULL, 0x0000000879797824ULL, 0x000fc800078e0200ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000108081810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe20003f46070ULL, 0x0000001002047824ULL, 0x000fcc00078e0203ULL,
0x0000000004047984ULL, 0x000e6c0000000c00ULL, 0x0000000108082810ULL, 0x000fc80007ffe0ffULL,
0x0000000810087207ULL, 0x000fca0004000000ULL, 0x000000ffff027224ULL, 0x000fe400078e0a08ULL,
0x0000590008087a24ULL, 0x000fe400078e021dULL, 0x00005a00027d7a24ULL, 0x000fc800078e027dULL,
0x00005a00087d7a24ULL, 0x000fca00078e027dULL, 0x0000007d1c7d7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005e007d027a11ULL, 0x000fc800078040ffULL,
0x00005f007d037a11ULL, 0x000fca00000f4408ULL, 0x0000001079027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006c00ff047624ULL, 0x000fe400078e00ffULL, 0x00006d00ff057624ULL, 0x000fca00078e00ffULL,
0x0000000604077981ULL, 0x000322000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000010a7983ULL, 0x000ea20000300800ULL, 0x000001ff0800780cULL, 0x000fe20003f04070ULL,
0x0000000209737824ULL, 0x000fe400078e00ffULL, 0x0000001fff097424ULL, 0x000fe200078e00ffULL,
0x01760000ff047f8cULL, 0x002e62000c80043fULL, 0x0000004000787824ULL, 0x000fc600078e00ffULL,
0x0000580009097a10ULL, 0x000fc80007ffe0ffULL, 0x00000005ff097819ULL, 0x000fe20000011609ULL,
0x0000590073737a24ULL, 0x004fc800078e020aULL, 0x00006800730b7a24ULL, 0x000fe200078e0278ULL,
0x00000c7000000947ULL, 0x000fea0003800000ULL, 0x00000003ff1f7819ULL, 0x002fe40000011602ULL,
0x00000078770d7217ULL, 0x000fe40007800000ULL, 0x000000081f137810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0c7824ULL, 0x000fe200078e021fULL, 0x000000041f0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010d087824ULL, 0x000fe200078e0a78ULL, 0x000000101f117810ULL, 0x000fe20007ffe0ffULL,
0x00000001130d7824ULL, 0x100fe200078e0202ULL, 0x0000000c1f177810ULL, 0x000fe20007ffe0ffULL,
0x0000000813107824ULL, 0x000fe200078e00ffULL, 0x000000080f00720cULL, 0x080fe20003fa6070ULL,
0x000000010b0e7824ULL, 0x000fe200078e020fULL, 0x000000181f2f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0a7824ULL, 0x040fe200078e0202ULL, 0xfffffff810277812ULL, 0x000fe200078ee20dULL,
0x000000080f257824ULL, 0x000fe200078e00ffULL, 0x000000141f217810ULL, 0x000fe20007ffe0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000081700720cULL, 0x000fc40003f46070ULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000700e147812ULL, 0x100fe400078ef803ULL, 0x0000001c1f317810ULL, 0x000fe20007ffe0ffULL,
0x00000008112b7824ULL, 0x040fe200078e00ffULL, 0x000000700c1a7812ULL, 0x000fe200078ef803ULL,
0x00000001110c7824ULL, 0x000fe200078e0202ULL, 0x0000640014147a10ULL, 0x000fe20007f3e0ffULL,
0x000000010b0e7824ULL, 0x040fe200078e0217ULL, 0x000064001a1a7a10ULL, 0x000fe20007f1e0ffULL,
0x000000010b1c7824ULL, 0x000fe200078e022fULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee20cULL,
0x000000010b0c7824ULL, 0x000fe200078e0213ULL, 0x000065000f157a10ULL, 0x000fe20000ffe4ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000065000d1b7a10ULL, 0x000fc400007fe4ffULL,
0x000000081300720cULL, 0x080fe20003f26070ULL, 0x000000010b127824ULL, 0x000fe200078e0221ULL,
0x000000700e187812ULL, 0x100fe200078ef803ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000081100720cULL, 0x000fe40003f06070ULL, 0x0000640018187a10ULL, 0x000fe20007f9e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000700c167812ULL, 0x100fe400078ef803ULL,
0x000065000f197a10ULL, 0x000fe200027fe4ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000701c0c7812ULL, 0x000fc400078ef803ULL, 0x0000640016167a10ULL, 0x000fe20007f7e0ffULL,
0x000000011f1c7824ULL, 0x100fe200078e0202ULL, 0x00000070120e7812ULL, 0x000fe200078ef803ULL,
0x00000001170a7824ULL, 0x040fe200078e0202ULL, 0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL,
0x0000000817297824ULL, 0x000fe200078e00ffULL, 0x000064000e0e7a10ULL, 0x000fe20007f9e0ffULL,
0x000000010b117824ULL, 0x000fe200078e0211ULL, 0x000065000d177a10ULL, 0x000fe20001ffe4ffULL,
0x000000010b127824ULL, 0x000fe200078e0231ULL, 0x000065001d0d7a10ULL, 0x000fe200037fe4ffULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0x00006500130f7a10ULL, 0x000fc400027fe4ffULL,
0x000000071c1d7812ULL, 0x000fe200078ec0ffULL, 0x00000001211c7824ULL, 0x000fe200078e0202ULL,
0x000000081f00720cULL, 0x080fe20003f86070ULL, 0x00000008212d7824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20aULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x00001000000a7811ULL, 0x000fe400078e70ffULL, 0x0ffffff81d237812ULL, 0x100fe200078ef802ULL,
0x000000012f1e7824ULL, 0x000fe200078e0202ULL, 0x000000201f337810ULL, 0x000fe20007ffe0ffULL,
0x0000001025257824ULL, 0x100fe200078e020aULL, 0x0000007010107812ULL, 0x000fe200078ef803ULL,
0x0000001023237824ULL, 0x100fe200078e020aULL, 0x000000241f357810ULL, 0x000fe20007ffe0ffULL,
0x000000010b1d7824ULL, 0x000fe200078e0233ULL, 0x0000640010107a10ULL, 0x000fe20007f7e0ffULL,
0x0000001027277824ULL, 0x000fe200078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a237faeULL, 0x0003e2000e101c46ULL, 0x000000082f00720cULL, 0x0c0fe20003f86070ULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee21cULL,
0x000000801d1c7825ULL, 0x000fe200078e00ffULL, 0x0000007012127812ULL, 0x000fe200078ef803ULL,
0x0000000014257faeULL, 0x0005e2000e901c46ULL, 0x000000281f377810ULL, 0x000fe20007ffe0ffULL,
0x000000010b207824ULL, 0x000fe200078e0235ULL, 0x0000650011117a10ULL, 0x000fe20001ffe4ffULL,
0x0000001029297824ULL, 0x000fe200078e020aULL, 0x000000082100720cULL, 0x080fe20003f66070ULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000640012127a10ULL, 0x000fe20007fde0ffULL,
0x0000000016277faeULL, 0x0007e2000c901c46ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee21eULL,
0x00000001311e7824ULL, 0x040fe200078e0202ULL, 0x000000701c1c7812ULL, 0x000fe200078ef803ULL,
0x0000000831237824ULL, 0x042fe200078e00ffULL, 0x000000083100720cULL, 0x080fe20003fa6070ULL,
0x000000010b227824ULL, 0x000fe200078e0237ULL, 0x0000002c1f317810ULL, 0x000fe20007ffe0ffULL,
0x000000102b2b7824ULL, 0x100fe200078e020aULL, 0x0000650013137a10ULL, 0x000fe200037fe4ffULL,
0x00000080221a7825ULL, 0x000fe200078e00ffULL, 0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL,
0x0000000018297faeULL, 0x0003e2000d101c46ULL, 0x0000007020207812ULL, 0x000fe200078ef803ULL,
0x000000010b147824ULL, 0x004fe200078e0231ULL, 0x000000301f257810ULL, 0x000fe20007ffe0ffULL,
0x000000102d2d7824ULL, 0x100fe200078e020aULL, 0x000065001d1d7a10ULL, 0x000fe200037fe4ffULL,
0x000000102f2f7824ULL, 0x000fe200078e020aULL, 0x0000640020207a10ULL, 0x000fe20007fde0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee21eULL,
0x00000000102b7faeULL, 0x0005e2000c101c46ULL, 0x000000701a1a7812ULL, 0x100fe200078ef803ULL,
0x00000001331e7824ULL, 0x140fe200078e0202ULL, 0x000000083300720cULL, 0x0c0fe20003f26070ULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x0000650021217a10ULL, 0x000fe200037fe4ffULL,
0x000000000e2d7faeULL, 0x0003e2000d901c46ULL, 0x000064001a1a7a10ULL, 0x000fe20007fde0ffULL,
0x0000000135227824ULL, 0x040fe200078e0202ULL, 0x000000083500720cULL, 0x000fe20003f46070ULL,
0x000000000c2f7faeULL, 0x0003e2000e101c46ULL, 0x0000007014147812ULL, 0x000fe200078ef803ULL,
0x000000010b107824ULL, 0x004fe200078e0225ULL, 0x000000341f277810ULL, 0x008fe20007ffe0ffULL,
0x0000000835357824ULL, 0x000fe200078e00ffULL, 0xfffffff833177812ULL, 0x000fe200078ee21eULL,
0x0000001023237824ULL, 0x100fe200078e020aULL, 0x000065001b1b7a10ULL, 0x000fe200037fe4ffULL,
0x000000010b0e7824ULL, 0x002fe200078e0227ULL, 0x0000640014147a10ULL, 0x000fe20007fde0ffULL,
0x0000001017177824ULL, 0x000fe200078e020aULL, 0xfffffff835197812ULL, 0x000fe200078ee222ULL,
0x00000080100c7825ULL, 0x000fe200078e00ffULL, 0x0000000012237faeULL, 0x0003e2000e901c46ULL,
0x0000650015157a10ULL, 0x000fc400037fe4ffULL, 0x0000000137117824ULL, 0x000fe200078e0202ULL,
0x000000700c107812ULL, 0x000fe200078ef803ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000381f297810ULL, 0x000fe20007ffe0ffULL, 0x000000001c177faeULL, 0x0005e2000c901c46ULL,
0x0000640010107a10ULL, 0x000fe20007fde0ffULL, 0x0000001019197824ULL, 0x000fe200078e020aULL,
0x0000003c1f1f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001250c7824ULL, 0x100fe200078e0202ULL,
0x000000083700720cULL, 0x0c0fe20003fa6070ULL, 0x0000000837127824ULL, 0x002fe200078e00ffULL,
0x0000000020197faeULL, 0x0003e2000d101c46ULL, 0x000000083100720cULL, 0x080fe20003f86070ULL,
0x0000000129167824ULL, 0x000fe200078e0202ULL, 0x000000082500720cULL, 0x000fc40003f66070ULL,
0xfffffff812177812ULL, 0x004fe200078ee211ULL, 0x00000008251d7824ULL, 0x000fe200078e00ffULL,
0x000065000d117a10ULL, 0x000fe200037fe4ffULL, 0x000000010b0d7824ULL, 0x040fe200078e0229ULL,
0x000000700e127812ULL, 0x000fe200078ef803ULL, 0x000000010b0e7824ULL, 0x000fe200078e021fULL,
0x000000082700720cULL, 0x080fe20003f46070ULL, 0x0000000831197824ULL, 0x002fe200078e00ffULL,
0x000000082900720cULL, 0x0c0fe20003f26070ULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0x000000081f00720cULL, 0x000fe20003f06070ULL, 0x0000000131087824ULL, 0x000fe200078e0202ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee20cULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fc40007fde0ffULL, 0xfffffff819197812ULL, 0x000fe200078ee208ULL,
0x0000000127087824ULL, 0x000fe200078e0202ULL, 0x000065000f137a10ULL, 0x000fe200037fe4ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fc600078ef803ULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL,
0x000000011f027824ULL, 0x040fe200078e0202ULL, 0x000000700e037812ULL, 0x000fe200078ef803ULL,
0x000000081f217824ULL, 0x000fe200078e00ffULL, 0xfffffff8270b7812ULL, 0x000fe200078ee208ULL,
0x0000001017177824ULL, 0x000fe200078e020aULL, 0xfffffff8291f7812ULL, 0x000fe200078ee216ULL,
0x0000001019197824ULL, 0x000fe200078e020aULL, 0xfffffff821217812ULL, 0x000fe200078ee202ULL,
0x000000101d1d7824ULL, 0x100fe200078e020aULL, 0x000065000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x000000100b0b7824ULL, 0x100fe200078e020aULL, 0x0000640003027a10ULL, 0x000fe20007fde0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e020aULL, 0x000000001a177faeULL, 0x0003e2000e901c46ULL,
0x0000001021217824ULL, 0x000fe200078e020aULL, 0x000065000f037a10ULL, 0x000fc400037fe4ffULL,
0x0000000014197faeULL, 0x0003e8000e101c46ULL, 0x00000000101d7faeULL, 0x0003e8000d901c46ULL,
0x00000000120b7faeULL, 0x0003e8000d101c46ULL, 0x000000000c1f7faeULL, 0x0003e8000c901c46ULL,
0x0000000002217faeULL, 0x0003e2000c101c46ULL, 0x00000b3000007947ULL, 0x000fea0003800000ULL,
0x00000004020c7811ULL, 0x042fe400078fe8ffULL, 0x0000000c020f7811ULL, 0x000fc400078fe8ffULL,
0x00000008020e7811ULL, 0x000fe200078fe8ffULL, 0x000000010c087824ULL, 0x100fe200078e0202ULL,
0x0000001002117811ULL, 0x000fe200078fe8ffULL, 0x000000080c1b7824ULL, 0x000fe200078e00ffULL,
0x0000001c02177811ULL, 0x040fe200078fe8ffULL, 0x000000010f0d7824ULL, 0x040fe200078e0202ULL,
0x0000001402137811ULL, 0x000fe200078fe8ffULL, 0x000000080f107824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee208ULL, 0x000000010e0a7824ULL, 0x100fe200078e0202ULL,
0x0000001802157811ULL, 0x000fe200078fe8ffULL, 0x000000080e1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff810217812ULL, 0x000fe200078ee20dULL, 0x0000000111087824ULL, 0x040fe200078e0202ULL,
0x0000002002187811ULL, 0x040fe200078fe8ffULL, 0x0000000811257824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee20aULL, 0x0000000117107824ULL, 0x140fe200078e0202ULL,
0x0000002c021e7811ULL, 0x040fe200078fe8ffULL, 0x00000008172b7824ULL, 0x000fe200078e00ffULL,
0x0000002402197811ULL, 0x040fe200078fe8ffULL, 0x00000001130a7824ULL, 0x000fe200078e0202ULL,
0xfffffff825257812ULL, 0x000fe200078ee208ULL, 0x0000000813277824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee210ULL, 0x00000001150d7824ULL, 0x040fe200078e0202ULL,
0x00000028021a7811ULL, 0x000fe200078fe8ffULL, 0x0000000815127824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee20aULL, 0x0000000118087824ULL, 0x100fe200078e0202ULL,
0x0000003802287811ULL, 0x000fe200078fe8ffULL, 0x00000008182d7824ULL, 0x000fe200078e00ffULL,
0xfffffff812297812ULL, 0x000fe200078ee20dULL, 0x000000011e107824ULL, 0x000fe200078e0202ULL,
0x0000003402267811ULL, 0x000fe200078fe8ffULL, 0x000000081e237824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee208ULL, 0x00000001190a7824ULL, 0x040fe200078e0202ULL,
0x0000000202087211ULL, 0x000fe200078fe8ffULL, 0x00000008191d7824ULL, 0x000fe200078e00ffULL,
0xfffffff823247812ULL, 0x000fe200078ee210ULL, 0x000000011a0d7824ULL, 0x000fe200078e0202ULL,
0x0000003002237811ULL, 0x000fe200078fe8ffULL, 0x000000081a207824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee20aULL, 0x000000010b147824ULL, 0x040fe200078e0213ULL,
0x0000003c022a7811ULL, 0x040fe200078fe8ffULL, 0x000000010b227824ULL, 0x040fe200078e0218ULL,
0x0000000b020a7211ULL, 0x000fe200078fe8ffULL, 0x000000010b187824ULL, 0x040fe200078e0228ULL,
0xfffffff820207812ULL, 0x000fe200078ee20dULL, 0x0000000128137824ULL, 0x000fe200078e0202ULL,
0x00000007080d7812ULL, 0x000fe200078ec0ffULL, 0x000000010b107824ULL, 0x000fc400078e020fULL,
0x000000010b127824ULL, 0x040fe400078e0211ULL, 0x000000010b307824ULL, 0x040fe400078e021aULL,
0x000000010b327824ULL, 0x040fe400078e021eULL, 0x0000000828287824ULL, 0x000fe400078e00ffULL,
0x000000010b0c7824ULL, 0x040fe400078e020cULL, 0x000000010b0e7824ULL, 0x040fe200078e020eULL,
0xfffffff828137812ULL, 0x000fe200078ee213ULL, 0x000000010b167824ULL, 0x040fe200078e0215ULL,
0x0000100000287811ULL, 0x000fe200078e70ffULL, 0x000000010b1c7824ULL, 0x000fc400078e0217ULL,
0x000000010b2e7824ULL, 0x000fe200078e0219ULL, 0x0ffffff80d197812ULL, 0x100fe200078ef802ULL,
0x000000010b1e7824ULL, 0x000fe400078e0223ULL, 0x00000001230f7824ULL, 0x040fe400078e0202ULL,
0x00000008232c7824ULL, 0x000fe400078e00ffULL, 0x000000010b1a7824ULL, 0x000fe400078e0226ULL,
0x0000000126117824ULL, 0x000fc400078e0202ULL, 0x0000000826347824ULL, 0x000fe200078e00ffULL,
0xfffffff82c267812ULL, 0x000fe200078ee20fULL, 0x000000010b087824ULL, 0x000fe400078e022aULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff834117812ULL, 0x000fc600078ee211ULL,
0x000000012a027824ULL, 0x000fe200078e0202ULL, 0x000000700a0a7812ULL, 0x100fe200078ef803ULL,
0x000000082a157824ULL, 0x000fe400078e00ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000064000a0a7a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff815157812ULL, 0x000fe200078ee202ULL,
0x00000010113d7824ULL, 0x000fe200078e0228ULL, 0x000000700e0e7812ULL, 0x000fe200078ef803ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000065000b0b7a10ULL, 0x000fc400007fe4ffULL,
0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000001015417824ULL, 0x100fe200078e0228ULL,
0x0000007010107812ULL, 0x100fe200078ef803ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000065000f0f7a10ULL, 0x000fe400007fe4ffULL, 0x0000640010107a10ULL, 0x000fe20007f1e0ffULL,
0x000000101d027824ULL, 0x000fe200078e0228ULL, 0x0000007014147812ULL, 0x000fe200078ef803ULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000650011117a10ULL, 0x000fc400007fe4ffULL,
0x0000640014147a10ULL, 0x000fe20007f1e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000701c1c7812ULL, 0x100fe400078ef803ULL, 0x0000650015157a10ULL, 0x000fe200007fe4ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000007016167812ULL, 0x100fe400078ef803ULL,
0x000064001c1c7a10ULL, 0x000fe20007f1e0ffULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fc400078ef803ULL, 0x0000640016167a10ULL, 0x000fe20007f5e0ffULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0x000000702e387812ULL, 0x100fe400078ef803ULL,
0x000065001d1d7a10ULL, 0x000fe200007fe4ffULL, 0x00000010133f7824ULL, 0x000fe200078e0228ULL,
0x00000070303a7812ULL, 0x000fe200078ef803ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000064000c0c7a10ULL, 0x000fe40007f3e0ffULL, 0x0000650017177a10ULL, 0x000fe200017fe4ffULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x0000640038387a10ULL, 0x000fc40007f1e0ffULL,
0x0000007012127812ULL, 0x100fe200078ef803ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x000064003a3a7a10ULL, 0x000fe40007f5e0ffULL, 0x000065000d0d7a10ULL, 0x000fe20000ffe4ffULL,
0x0000001019197824ULL, 0x100fe200078e0228ULL, 0x000065002f397a10ULL, 0x000fe200007fe4ffULL,
0x000000801e2e7825ULL, 0x000fe200078e00ffULL, 0x0000640012127a10ULL, 0x000fe40007f3e0ffULL,
0x0000007032327812ULL, 0x100fe200078ef803ULL, 0x000000101b1b7824ULL, 0x100fe200078e0228ULL,
0x00006500313b7a10ULL, 0x000fe200017fe4ffULL, 0x000000801a307825ULL, 0x000fe200078e00ffULL,
0x0000007022227812ULL, 0x100fe200078ef803ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a197faeULL, 0x0003e2000b901c46ULL, 0x0000650013137a10ULL, 0x000fe20000ffe4ffULL,
0x0000008018347825ULL, 0x000fe200078e00ffULL, 0x0000640032327a10ULL, 0x000fe20007f1e0ffULL,
0x000000000c1b7faeULL, 0x0003e2000b901c46ULL, 0x0000640022227a10ULL, 0x000fe20007f3e0ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0228ULL, 0x000000702e2e7812ULL, 0x100fe200078ef803ULL,
0x0000008008367825ULL, 0x000fe200078e00ffULL, 0x0000007030307812ULL, 0x000fc400078ef803ULL,
0x0000007034347812ULL, 0x100fe200078ef803ULL, 0x0000001021217824ULL, 0x100fe200078e0228ULL,
0x0000650033337a10ULL, 0x000fe200007fe4ffULL, 0x0000001025257824ULL, 0x100fe200078e0228ULL,
0x0000007036037812ULL, 0x000fe200078ef803ULL, 0x0000001027277824ULL, 0x100fe200078e0228ULL,
0x000000000e1f7faeULL, 0x0003e2000b901c46ULL, 0x0000001029297824ULL, 0x100fe200078e0228ULL,
0x0000650023237a10ULL, 0x000fe20000ffe4ffULL, 0x000000102b2b7824ULL, 0x100fe200078e0228ULL,
0x000064002e2e7a10ULL, 0x000fe20007f1e0ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0228ULL,
0x0000000010217faeULL, 0x0003e2000b901c46ULL, 0x0000640030307a10ULL, 0x000fe20007f3e0ffULL,
0x0000001020207824ULL, 0x100fe200078e0228ULL, 0x0000640034347a10ULL, 0x000fe20007f5e0ffULL,
0x0000000012257faeULL, 0x0003e2000b901c46ULL, 0x0000001024247824ULL, 0x100fe200078e0228ULL,
0x0000640003367a10ULL, 0x000fe20007f7e0ffULL, 0x0000001026267824ULL, 0x000fe200078e0228ULL,
0x0000000014277faeULL, 0x0003e2000b901c46ULL, 0x000065002f2f7a10ULL, 0x000fc400007fe4ffULL,
0x0000650031317a10ULL, 0x000fe20000ffe4ffULL, 0x0000000016297faeULL, 0x0003e2000b901c46ULL,
0x0000650035357a10ULL, 0x000fe400017fe4ffULL, 0x0000650037377a10ULL, 0x000fe20001ffe4ffULL,
0x000000001c2b7faeULL, 0x0003e8000b901c46ULL, 0x00000000222d7faeULL, 0x0003e8000b901c46ULL,
0x0000000038027faeULL, 0x0003e8000b901c46ULL, 0x000000003a207faeULL, 0x0003e8000b901c46ULL,
0x0000000032247faeULL, 0x0003e8000b901c46ULL, 0x000000002e267faeULL, 0x0003e8000b901c46ULL,
0x00000000303d7faeULL, 0x0003e8000b901c46ULL, 0x00000000343f7faeULL, 0x0003e8000b901c46ULL,
0x0000000036417faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000027805ULL, 0x002fc40000015200ULL, 0x01760400ff0b7984ULL, 0x000e620000000800ULL,
0x0000000906677224ULL, 0x000fc400078e02ffULL, 0x0000000177767824ULL, 0x000fe400078e0a6aULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x800000000bff7812ULL, 0x002fe20007804805ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620067667625ULL, 0x000fe200078e0066ULL, 0x00000008ff767819ULL, 0x000fe20000011676ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a020d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e03ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc8000001140bULL, 0x0000000d06067211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000206067819ULL, 0x000fc8000000120bULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002000027824ULL, 0x002fca00078e0203ULL, 0x00000003ff037819ULL, 0x000fc80000011602ULL,
0x1ffffffe03057812ULL, 0x000fe400078ec0ffULL, 0x0000000f02037812ULL, 0x000fc600078ec0ffULL,
0x0000000102057824ULL, 0x000fe400078e0205ULL, 0x00000010030b7824ULL, 0x040fe400078e00ffULL,
0x0000001003047824ULL, 0x000fe200078e00ffULL, 0x0000000f05027812ULL, 0x040fe400078ec0ffULL,
0x0000000105057810ULL, 0x000fe40007ffe0ffULL, 0x000000f00b027812ULL, 0x000fe400078ee202ULL,
0x0000000f05057812ULL, 0x000fc600078ec0ffULL, 0x0000000002107984ULL, 0x000e62000000cc00ULL,
0x000000f004057812ULL, 0x000fca00078ee205ULL, 0x00000000050c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fc400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000001402007388ULL, 0x0003e8000000cc00ULL, 0x0000001005007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01760000ff0a7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff067224ULL, 0x000fc600078e00ffULL, 0x0000000000027805ULL, 0x002fc80000015200ULL,
0x01760400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x006fc4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x00000004020d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000d04047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff7a00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000010078787810ULL, 0x000fe20007ffe0ffULL, 0x0000000209727824ULL, 0x000fe200078e00ffULL,
0x0001768800797811ULL, 0x000fe200078e18ffULL, 0x3db504f307037820ULL, 0x010fe20000410000ULL,
0xffffffff6a6d7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff6e7224ULL, 0x000fe200078e00ffULL,
0x000000096a707810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff697224ULL, 0x000fe200078e00ffULL,
0x00017608007b7811ULL, 0x000fc400078e28ffULL, 0x000000026e057810ULL, 0x040fe20007ffe0ffULL,
0x000001006e6f7824ULL, 0x000fe200078e0278ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000169717812ULL, 0x000fc400078e0cffULL, 0x0000007a0500720cULL, 0x000fe20003f06070ULL,
0x0000680073057a24ULL, 0x000fd800078e026fULL, 0x00000ca000008947ULL, 0x00cfea0003800000ULL,
0x00000003ff157819ULL, 0x102fe20000011602ULL, 0x00000002001a7824ULL, 0x000fe200078e0271ULL,
0x0000006f77147217ULL, 0x000fe40007800000ULL, 0x0000000415077810ULL, 0x040fe20007ffe0ffULL,
0x0000000115067824ULL, 0x040fe200078e0205ULL, 0x00000008150b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000114147824ULL, 0x000fe200078e0a6fULL, 0x0000000c150d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107047824ULL, 0x100fe200078e0202ULL, 0x00000010150f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000807237824ULL, 0x000fe200078e00ffULL, 0x0000001815297810ULL, 0x000fe20007ffe0ffULL,
0x0000000107087824ULL, 0x040fe200078e0205ULL, 0x000000140700720cULL, 0x080fe20003fa6070ULL,
0x000000010b1f7824ULL, 0x000fe200078e0202ULL, 0xfffffff823237812ULL, 0x000fe200078ee204ULL,
0x0000001002047824ULL, 0x000fe200078e00ffULL, 0x00000014151d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080b0a7824ULL, 0x000fe200078e00ffULL, 0x000000140d00720cULL, 0x000fe20003f46070ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000007004047812ULL, 0x000fc400078ec0ffULL,
0xfffffff80a1f7812ULL, 0x000fe200078ee21fULL, 0x000000010d0a7824ULL, 0x140fe200078e0202ULL,
0x0000000408127212ULL, 0x000fe200078efcffULL, 0x000000080d257824ULL, 0x000fe200078e00ffULL,
0x000010001a1a7811ULL, 0x000fe200078e68ffULL, 0x000000010f1b7824ULL, 0x040fe200078e0202ULL,
0x0000640012127a10ULL, 0x000fe20007f3e0ffULL, 0x000000080f087824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x000000010d0a7824ULL, 0x100fe200078e0205ULL,
0x0000650009137a10ULL, 0x000fe20000ffe4ffULL, 0x0000000129187824ULL, 0x000fe200078e0205ULL,
0xfffffff8081b7812ULL, 0x000fe200078ee21bULL, 0x000000010b087824ULL, 0x040fe200078e0205ULL,
0x000000140b00720cULL, 0x000fe20003f26070ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002815317810ULL, 0x000fc40007ffe0ffULL, 0x0000001c152b7810ULL, 0x040fe20007ffe0ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x000000040a107212ULL, 0x080fe400078efcffULL,
0x00000020152d7810ULL, 0x000fe20007ffe0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000000406067212ULL, 0x080fe400078efcffULL, 0x0000640010107a10ULL, 0x000fe20007f9e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000004080e7212ULL, 0x000fc400078efcffULL,
0x0000640006067a10ULL, 0x000fe20007f1e0ffULL, 0x000000010f0c7824ULL, 0x100fe200078e0205ULL,
0x0000000418087212ULL, 0x000fe200078efcffULL, 0x0000000115187824ULL, 0x000fe200078e0202ULL,
0x000064000e0e7a10ULL, 0x000fe20007f7e0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000065000b117a10ULL, 0x000fe400027fe4ffULL, 0x0000640008087a10ULL, 0x000fe20007f9e0ffULL,
0x000000011d167824ULL, 0x100fe200078e0205ULL, 0x0000650007077a10ULL, 0x000fe200007fe4ffULL,
0x00000001311e7824ULL, 0x000fe200078e0205ULL, 0x000000140f00720cULL, 0x000fe20003f06070ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00006500090f7a10ULL, 0x000fc40001ffe4ffULL,
0x0000650019097a10ULL, 0x000fe200027fe4ffULL, 0x000000011d1c7824ULL, 0x140fe200078e0202ULL,
0x0000000718197812ULL, 0x000fe200078ec0ffULL, 0x000000081d277824ULL, 0x000fe200078e00ffULL,
0x000000141500720cULL, 0x000fe20003f86070ULL, 0x000000012d187824ULL, 0x100fe200078e0205ULL,
0x000000040c0c7212ULL, 0x080fe200078efcffULL, 0x0000000129207824ULL, 0x100fe200078e0202ULL,
0x0ffffff819197812ULL, 0x000fe200078ef802ULL, 0x000000101f1f7824ULL, 0x100fe200078e021aULL,
0x000064000c0c7a10ULL, 0x000fe20007f7e0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e021aULL,
0x00000004160a7212ULL, 0x000fe200078efcffULL, 0x0000001019217824ULL, 0x000fe200078e021aULL,
0x000065000d0d7a10ULL, 0x000fe20001ffe4ffULL, 0x000000012b167824ULL, 0x000fe200078e0205ULL,
0x000064000a0a7a10ULL, 0x000fe20007f7e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006217faeULL, 0x0003e2000e101c46ULL,
0x00000024152f7810ULL, 0x000fc40007ffe0ffULL, 0x00006500170b7a10ULL, 0x000fe20001ffe4ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe400078ee21cULL,
0x000000142900720cULL, 0x000fe20003f86070ULL, 0x000000012f1c7824ULL, 0x000fe200078e0205ULL,
0x0000000416167212ULL, 0x000fe200078efcffULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0x000000141d00720cULL, 0x000fe20003f66070ULL, 0x0000001023217824ULL, 0x002fe200078e021aULL,
0x0000640016167a10ULL, 0x000fe20007fde0ffULL, 0x000000801e067825ULL, 0x000fe200078e00ffULL,
0x0000000418187212ULL, 0x000fc400078efcffULL, 0x0000000012217faeULL, 0x0003e2000e901c46ULL,
0x000000012b1e7824ULL, 0x000fe200078e0202ULL, 0x0000002c15337810ULL, 0x000fe20007ffe0ffULL,
0x000000082b237824ULL, 0x000fe200078e00ffULL, 0x0000650017177a10ULL, 0x000fe200037fe4ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000000e1f7faeULL, 0x0005e2000c901c46ULL,
0x0000640018187a10ULL, 0x000fe40007fde0ffULL, 0xfffffff823237812ULL, 0x000fe200078ee21eULL,
0x000000012d1e7824ULL, 0x000fe200078e0202ULL, 0xfffffff829297812ULL, 0x000fe200078ee220ULL,
0x0000001025217824ULL, 0x102fe200078e021aULL, 0x000000041c1c7212ULL, 0x080fe200078efcffULL,
0x000000082d257824ULL, 0x000fe200078e00ffULL, 0x0000650019197a10ULL, 0x000fe200037fe4ffULL,
0x0000000133127824ULL, 0x000fe200078e0205ULL, 0x0000000010217faeULL, 0x0003e2000d101c46ULL,
0x00000010270f7824ULL, 0x004fe200078e021aULL, 0xfffffff825257812ULL, 0x000fe200078ee21eULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL,
0x000000000c1b7faeULL, 0x0005e2000c101c46ULL, 0x0000000406067212ULL, 0x080fe200078efcffULL,
0x000000012f207824ULL, 0x000fe200078e0202ULL, 0x000065001d1d7a10ULL, 0x000fe200037fe4ffULL,
0x000000000a0f7faeULL, 0x0007e2000d901c46ULL, 0x0000640006067a10ULL, 0x000fe20007fde0ffULL,
0x00000010231f7824ULL, 0x100fe200078e021aULL, 0x0000000412127212ULL, 0x000fe200078efcffULL,
0x0000001025217824ULL, 0x102fe200078e021aULL, 0x0000003015257810ULL, 0x000fe20007ffe0ffULL,
0x0000001029117824ULL, 0x000fe200078e021aULL, 0x0000650007077a10ULL, 0x000fc400037fe4ffULL,
0x00000034151b7810ULL, 0x004fe20007ffe0ffULL, 0x00000001250c7824ULL, 0x140fe200078e0205ULL,
0x0000000008117faeULL, 0x0003e2000e101c46ULL, 0x0000640012127a10ULL, 0x000fe20007fde0ffULL,
0x00000001250d7824ULL, 0x000fe200078e0202ULL, 0x000000142b00720cULL, 0x080fe20003fa6070ULL,
0x000000011b0a7824ULL, 0x008fe200078e0205ULL, 0x0000650013137a10ULL, 0x000fe200037fe4ffULL,
0x000000082f2b7824ULL, 0x000fe200078e00ffULL, 0x0000003815277810ULL, 0x000fe20007ffe0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000142d00720cULL, 0x000fc40003f26070ULL,
0x000000142f00720cULL, 0x000fe20003f46070ULL, 0x000000800c087825ULL, 0x002fe200078e00ffULL,
0x000000040a0e7212ULL, 0x080fe400078efcffULL, 0x0000003c15297810ULL, 0x000fe20007ffe0ffULL,
0x00000001310c7824ULL, 0x040fe200078e0202ULL, 0x0000000408087212ULL, 0x000fe200078efcffULL,
0x0000000831117824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee220ULL,
0x0000000833157824ULL, 0x000fe200078e00ffULL, 0x0000640008087a10ULL, 0x000fe20007fde0ffULL,
0x00000001270a7824ULL, 0x100fe200078e0205ULL, 0xfffffff811117812ULL, 0x000fe200078ee20cULL,
0x00000001330c7824ULL, 0x000fe200078e0202ULL, 0x0000650009097a10ULL, 0x000fe200037fe4ffULL,
0x0000000825107824ULL, 0x000fe200078e00ffULL, 0x000064000e0e7a10ULL, 0x000fe20007fde0ffULL,
0x000000102b237824ULL, 0x000fe200078e021aULL, 0xfffffff815157812ULL, 0x000fe200078ee20cULL,
0x00000001290c7824ULL, 0x000fe200078e0205ULL, 0x000065000b0f7a10ULL, 0x000fe200037fe4ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00000000161f7faeULL, 0x0003e2000e901c46ULL,
0x000000143100720cULL, 0x000fc40003fa6070ULL, 0x000000143300720cULL, 0x000fe20003f86070ULL,
0x0000000018217faeULL, 0x0005e2000c901c46ULL, 0x000000040a0a7212ULL, 0x000fe200078efcffULL,
0x0000000127057824ULL, 0x000fe200078e0202ULL, 0x000000142500720cULL, 0x080fe20003f66070ULL,
0x000000001c237faeULL, 0x0007e2000d101c46ULL, 0x000000141b00720cULL, 0x080fe20003f46070ULL,
0x0000001011117824ULL, 0x000fe200078e021aULL, 0x000000142700720cULL, 0x0c0fe20003f26070ULL,
0x0000000827167824ULL, 0x002fe200078e00ffULL, 0xfffffff810177812ULL, 0x000fe200078ee20dULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000142900720cULL, 0x000fe20003f06070ULL,
0x0000000006117faeULL, 0x0003e2000e901c46ULL, 0x000064000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x000000011b107824ULL, 0x140fe200078e0202ULL, 0x000000040c047212ULL, 0x000fe200078efcffULL,
0x000000081b197824ULL, 0x004fe200078e00ffULL, 0xfffffff816057812ULL, 0x000fe200078ee205ULL,
0x0000000129147824ULL, 0x000fe200078e0202ULL, 0x000065000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x00000008291d7824ULL, 0x008fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee210ULL,
0x0000001015157824ULL, 0x100fe200078e021aULL, 0x0000640004047a10ULL, 0x000fe20007fde0ffULL,
0x0000001017177824ULL, 0x000fe200078e021aULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee214ULL,
0x0000001019197824ULL, 0x100fe200078e021aULL, 0x0000000012157faeULL, 0x0003e2000e101c46ULL,
0x00000010051b7824ULL, 0x100fe200078e021aULL, 0x000065000d057a10ULL, 0x000fe200037fe4ffULL,
0x000000101d1d7824ULL, 0x000fe200078e021aULL, 0x0000000008177faeULL, 0x0003e8000d901c46ULL,
0x000000000e197faeULL, 0x0003e8000d101c46ULL, 0x000000000a1b7faeULL, 0x0003e8000c901c46ULL,
0x00000000041d7faeULL, 0x0003e2000c101c46ULL, 0x00000b6000007947ULL, 0x000fea0003800000ULL,
0x0000000802087811ULL, 0x042fe200078fe8ffULL, 0x0000001002397824ULL, 0x040fe200078e00ffULL,
0x00000014020e7811ULL, 0x000fc400078fe8ffULL, 0x0000000402067811ULL, 0x000fe200078fe8ffULL,
0x0000000108077824ULL, 0x100fe200078e0202ULL, 0x0000001802107811ULL, 0x000fe200078fe8ffULL,
0x00000008080c7824ULL, 0x000fe200078e00ffULL, 0x0000000c020a7811ULL, 0x000fe200078fe8ffULL,
0x000000010e097824ULL, 0x100fe200078e0202ULL, 0x0000002802187811ULL, 0x000fe200078fe8ffULL,
0x000000080e147824ULL, 0x000fe200078e00ffULL, 0xfffffff80c337812ULL, 0x000fe200078ee207ULL,
0x0000000106047824ULL, 0x100fe200078e0202ULL, 0x00000010020c7811ULL, 0x000fe200078fe8ffULL,
0x0000000806357824ULL, 0x000fe200078e00ffULL, 0xfffffff8142d7812ULL, 0x000fe200078ee209ULL,
0x00000001100b7824ULL, 0x100fe200078e0202ULL, 0x0000002002147811ULL, 0x000fe200078fe8ffULL,
0x000000010c077824ULL, 0x040fe200078e0202ULL, 0xfffffff835357812ULL, 0x000fe200078ee204ULL,
0x000000080c127824ULL, 0x000fe200078e00ffULL, 0x0000003002267811ULL, 0x000fe200078fe8ffULL,
0x0000000810167824ULL, 0x000fe200078e00ffULL, 0x0000003402247811ULL, 0x000fe200078fe8ffULL,
0x000000010a047824ULL, 0x100fe200078e0202ULL, 0xfffffff8122f7812ULL, 0x000fe200078ee207ULL,
0x000000080a317824ULL, 0x000fe200078e00ffULL, 0x0000001c02127811ULL, 0x000fe200078fe8ffULL,
0x0000000114077824ULL, 0x000fe200078e0202ULL, 0xfffffff8160b7812ULL, 0x000fe200078ee20bULL,
0x00000008141a7824ULL, 0x000fe200078e00ffULL, 0x0000002402167811ULL, 0x000fe200078fe8ffULL,
0x0000000812297824ULL, 0x040fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee204ULL,
0x0000000112047824ULL, 0x100fe200078e0202ULL, 0xfffffff81a277812ULL, 0x000fe200078ee207ULL,
0x0000000116097824ULL, 0x000fe200078e0202ULL, 0x0000002c021a7811ULL, 0x000fe200078fe8ffULL,
0x00000008161c7824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee204ULL,
0x00000001180d7824ULL, 0x100fe200078e0202ULL, 0x0000003802227811ULL, 0x000fe200078fe8ffULL,
0x00000008181e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c257812ULL, 0x000fe200078ee209ULL,
0x000000011a047824ULL, 0x100fe200078e0202ULL, 0x0000003c02137811ULL, 0x000fe200078fe8ffULL,
0x000000081a217824ULL, 0x000fe200078e00ffULL, 0xfffffff81e0d7812ULL, 0x000fe200078ee20dULL,
0x0000000126077824ULL, 0x040fe200078e0202ULL, 0x0000007039397812ULL, 0x000fe200078ec0ffULL,
0x00000008261c7824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee204ULL,
0x0000000124097824ULL, 0x100fe200078e0202ULL, 0x0000000502047211ULL, 0x000fe200078fe8ffULL,
0x00000008241e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1f7812ULL, 0x000fe200078ee207ULL,
0x0000000122117824ULL, 0x100fe200078e0202ULL, 0x0000000202077211ULL, 0x000fe200078fe8ffULL,
0x0000000822207824ULL, 0x000fe200078e00ffULL, 0xfffffff81e0f7812ULL, 0x000fe200078ee209ULL,
0x0000000113157824ULL, 0x100fe200078e0202ULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x00000008131c7824ULL, 0x000fe200078e00ffULL, 0xfffffff820117812ULL, 0x000fe200078ee211ULL,
0x0000000200097824ULL, 0x000fe200078e0271ULL, 0x0ffffff807377812ULL, 0x000fe200078ef802ULL,
0x0000000106067824ULL, 0x000fe200078e0205ULL, 0xfffffff81c157812ULL, 0x000fe200078ee215ULL,
0x0000000108087824ULL, 0x100fe200078e0205ULL, 0x00001000091c7811ULL, 0x000fe200078e68ffULL,
0x000000010a0a7824ULL, 0x000fc400078e0205ULL, 0x000000010c0c7824ULL, 0x100fe400078e0205ULL,
0x000000010e0e7824ULL, 0x100fe400078e0205ULL, 0x0000000110107824ULL, 0x100fe400078e0205ULL,
0x0000000112127824ULL, 0x100fe400078e0205ULL, 0x0000000114147824ULL, 0x100fe400078e0205ULL,
0x0000000116167824ULL, 0x000fc400078e0205ULL, 0x0000000118187824ULL, 0x100fe400078e0205ULL,
0x000000011a1a7824ULL, 0x100fe400078e0205ULL, 0x0000000126267824ULL, 0x100fe400078e0205ULL,
0x0000000124247824ULL, 0x100fe400078e0205ULL, 0x0000000122227824ULL, 0x100fe400078e0205ULL,
0x0000000113207824ULL, 0x000fc400078e0205ULL, 0x0000008004047825ULL, 0x000fc800078e00ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000003904047212ULL, 0x000fc600078efcffULL,
0x000000100b2b7824ULL, 0x100fe200078e021cULL, 0x0000640004047a10ULL, 0x000fe20007f1e0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003908087212ULL, 0x080fe400078efcffULL,
0x0000650005057a10ULL, 0x000fe200007fe4ffULL, 0x000000100f1e7824ULL, 0x000fe200078e021cULL,
0x0000640008087a10ULL, 0x000fe20007f1e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000390a0a7212ULL, 0x000fe400078efcffULL, 0x0000650009097a10ULL, 0x000fe200007fe4ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000064000a0a7a10ULL, 0x000fc40007f1e0ffULL,
0x000000390e0e7212ULL, 0x080fe200078efcffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000065000b0b7a10ULL, 0x000fe400007fe4ffULL, 0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x000000100d237824ULL, 0x100fe200078e021cULL, 0x0000003912127212ULL, 0x080fe200078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000003906067212ULL, 0x000fe400078efcffULL,
0x000065000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x00000010111d7824ULL, 0x000fe200078e021cULL,
0x0000640012127a10ULL, 0x000fe20007f1e0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000640006067a10ULL, 0x000fc40007f3e0ffULL, 0x0000003916167212ULL, 0x080fe200078efcffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000390c0c7212ULL, 0x080fe400078efcffULL,
0x0000650013137a10ULL, 0x000fe200007fe4ffULL, 0x0000001037377824ULL, 0x100fe200078e021cULL,
0x0000003910107212ULL, 0x000fe200078efcffULL, 0x0000001035357824ULL, 0x100fe200078e021cULL,
0x0000650007077a10ULL, 0x000fe20000ffe4ffULL, 0x0000001033337824ULL, 0x100fe200078e021cULL,
0x0000640016167a10ULL, 0x000fe20007f1e0ffULL, 0x0000001031317824ULL, 0x100fe200078e021cULL,
0x000064000c0c7a10ULL, 0x000fe20007f3e0ffULL, 0x000000102f2f7824ULL, 0x100fe200078e021cULL,
0x0000640010107a10ULL, 0x000fe20007f5e0ffULL, 0x000000102d2d7824ULL, 0x100fe200078e021cULL,
0x0000650017177a10ULL, 0x000fe200007fe4ffULL, 0x0000001029297824ULL, 0x100fe200078e021cULL,
0x000065000d0d7a10ULL, 0x000fe20000ffe4ffULL, 0x0000001027277824ULL, 0x100fe200078e021cULL,
0x0000650011117a10ULL, 0x000fe200017fe4ffULL, 0x0000001025257824ULL, 0x100fe200078e021cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004377faeULL, 0x0003e2000b901c46ULL,
0x0000001021217824ULL, 0x000fc400078e021cULL, 0x000000101f1f7824ULL, 0x100fe200078e021cULL,
0x0000000006357faeULL, 0x0003e2000b901c46ULL, 0x00000010151c7824ULL, 0x000fe400078e021cULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000000008337faeULL, 0x0003e6000b901c46ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000391a1a7212ULL, 0x080fe200078efcffULL,
0x000000000a317faeULL, 0x0003e4000b901c46ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000003914147212ULL, 0x080fe200078efcffULL, 0x000000000c2f7faeULL, 0x0003e2000b901c46ULL,
0x000064001a1a7a10ULL, 0x000fe20007f1e0ffULL, 0x00000080263a7825ULL, 0x000fe200078e00ffULL,
0x0000003918187212ULL, 0x080fe200078efcffULL, 0x000000000e2d7faeULL, 0x0003e2000b901c46ULL,
0x0000640014147a10ULL, 0x000fe20007f3e0ffULL, 0x00000080243c7825ULL, 0x000fe200078e00ffULL,
0x000000393a387212ULL, 0x080fe200078efcffULL, 0x00000000102b7faeULL, 0x0003e2000b901c46ULL,
0x0000640018187a10ULL, 0x000fe20007f5e0ffULL, 0x00000080223e7825ULL, 0x000fe200078e00ffULL,
0x000000393c3a7212ULL, 0x080fe200078efcffULL, 0x0000000012297faeULL, 0x0003e2000b901c46ULL,
0x000065001b1b7a10ULL, 0x000fe200007fe4ffULL, 0x0000008020407825ULL, 0x000fe200078e00ffULL,
0x000000393e3c7212ULL, 0x000fc400078efcffULL, 0x0000650015157a10ULL, 0x000fe40000ffe4ffULL,
0x0000003940397212ULL, 0x000fe400078efcffULL, 0x0000640038387a10ULL, 0x000fe20007f1e0ffULL,
0x0000000014277faeULL, 0x0003e2000b901c46ULL, 0x0000650019197a10ULL, 0x000fe400017fe4ffULL,
0x000064003a3a7a10ULL, 0x000fe20007f3e0ffULL, 0x0000000016257faeULL, 0x0003e2000b901c46ULL,
0x000064003c3c7a10ULL, 0x000fc40007f5e0ffULL, 0x00006400393e7a10ULL, 0x000fe20007f7e0ffULL,
0x0000000018237faeULL, 0x0003e2000b901c46ULL, 0x000065003b397a10ULL, 0x000fe400007fe4ffULL,
0x000065003d3b7a10ULL, 0x000fe20000ffe4ffULL, 0x000000001a217faeULL, 0x0003e2000b901c46ULL,
0x000065003f3d7a10ULL, 0x000fe400017fe4ffULL, 0x00006500413f7a10ULL, 0x000fe20001ffe4ffULL,
0x00000000381f7faeULL, 0x0003e8000b901c46ULL, 0x000000003a1e7faeULL, 0x0003e8000b901c46ULL,
0x000000003c1d7faeULL, 0x0003e8000b901c46ULL, 0x000000003e1c7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff047224ULL, 0x002fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff802057812ULL, 0x000fe200078ec0ffULL,
0x0000000200407824ULL, 0x000fe200078e0269ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000001043f7810ULL, 0x020fc40007ffe0ffULL, 0x0000000705057812ULL, 0x000fe400078ef802ULL,
0x0000100040407811ULL, 0x000fc600078e68ffULL, 0x0000000105067824ULL, 0x040fe400078e0204ULL,
0x0000000805077824ULL, 0x000fca00078e00ffULL, 0xfffffff807077812ULL, 0x000fe200078ee206ULL,
0x0000000805067824ULL, 0x040fe400078e00ffULL, 0x0000000105057824ULL, 0x000fe400078e023fULL,
0x0000001007077824ULL, 0x000fc600078e0240ULL, 0xfffffff806057812ULL, 0x000fe400078ee205ULL,
0x000000000710783bULL, 0x000e660000000200ULL, 0x0000001005147824ULL, 0x000fcc00078e0240ULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x00000018ff097819ULL, 0x002fe20000011413ULL,
0x0000001000567306ULL, 0x000fe20000009400ULL, 0x00000018ff057819ULL, 0x000fe20000011410ULL,
0x00010000135e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff067819ULL, 0x000fe40000011411ULL,
0x00000018ff077819ULL, 0x000fe40000011412ULL, 0x00000018ff7c7819ULL, 0x000fe2000001145eULL,
0x0000000900547306ULL, 0x000fe20000209400ULL, 0x00000018ff0d7819ULL, 0x004fc40000011417ULL,
0x00000018ff0b7819ULL, 0x000fe40000011415ULL, 0x00000018ff0c7819ULL, 0x000fc60000011416ULL,
0x0000000900597306ULL, 0x000ff00000205400ULL, 0x0000000900527306ULL, 0x0003f0000020d400ULL,
0x00000010005b7306ULL, 0x000ea20000005400ULL, 0x0001000010097824ULL, 0x002fca00078e00ffULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x0000001000747306ULL, 0x0002f0000000d400ULL,
0x0000000900517306ULL, 0x000fe20000209400ULL, 0x0000010010107824ULL, 0x002fe200078e00ffULL,
0x0000005b5600720bULL, 0x004fe20003fbd000ULL, 0x0000010013567824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000000900587306ULL, 0x000e6e0000205400ULL,
0x0000000174745812ULL, 0x008fe200078efcffULL, 0x0000000900757306ULL, 0x0004f0000020d400ULL,
0x0000000500507306ULL, 0x000fe20000209400ULL, 0x0000002002097810ULL, 0x004fc40007ffe0ffULL,
0x000000585100720bULL, 0x002fe40003f7d000ULL, 0xfffffff809097812ULL, 0x000fc600078ec0ffULL,
0x0000000500557306ULL, 0x000e700000205400ULL, 0x0000000500417306ULL, 0x000522000020d400ULL,
0x0000000175753812ULL, 0x008fce00078efcffULL, 0x00000010004c7306ULL, 0x000fe20000209400ULL,
0x00000018ff057819ULL, 0x004fe40000011414ULL, 0x000000555000720bULL, 0x002fca0003f9d000ULL,
0x0000001000577306ULL, 0x000e700000205400ULL, 0x0000001000447306ULL, 0x0004e2000020d400ULL,
0x0000000141414812ULL, 0x010fce00078efcffULL, 0x0000000500477306ULL, 0x000fe20000209400ULL,
0x0000000709107812ULL, 0x004fe400078ef802ULL, 0x000000574c00720bULL, 0x002fc60003f1d000ULL,
0x0000000110097824ULL, 0x040fe400078e0204ULL, 0x0000000500427306ULL, 0x000fe20000205400ULL,
0x00000008100e7824ULL, 0x040fe400078e00ffULL, 0x00000001103f7824ULL, 0x040fe400078e023fULL,
0x0000000810107824ULL, 0x000fc600078e00ffULL, 0x0000000500087306ULL, 0x000fe2000020d400ULL,
0x0000000144440812ULL, 0x008fce00078efcffULL, 0x0000000d00617306ULL, 0x000ff00000209400ULL,
0x0000000d005f7306ULL, 0x000ff00000205400ULL, 0x0000000d00057306ULL, 0x0003f0000020d400ULL,
0x00000006004b7306ULL, 0x000fe20000209400ULL, 0x00010000120d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff607819ULL, 0x000fe4000001140dULL, 0x0000000600467306ULL, 0x000e620000205400ULL,
0xfffffff80e0d7812ULL, 0x000fca00078ee209ULL, 0x000000100d0d7824ULL, 0x000fe400078e0240ULL,
0x00000006003d7306ULL, 0x000eb0000020d400ULL, 0x0000000b000a7306ULL, 0x000fe20000209400ULL,
0x000000464b00720bULL, 0x002fce0003f7d000ULL, 0x0000000b00457306ULL, 0x000fec0000205400ULL,
0x000000013d3d3812ULL, 0x004fe400078efcffULL, 0x0000000b00067306ULL, 0x0003f0000020d400ULL,
0x00000007001b7306ULL, 0x000fe20000209400ULL, 0x00010000110b7824ULL, 0x002fce00078e00ffULL,
0x00000007003c7306ULL, 0x000e700000205400ULL, 0x00000007004d7306ULL, 0x000eb0000020d400ULL,
0x0000000c00187306ULL, 0x000fe20000209400ULL, 0x0000003c1b00720bULL, 0x002fce0003fbd000ULL,
0x0000000c00197306ULL, 0x000fec0000205400ULL, 0x000000014d4d5812ULL, 0x004fe400078efcffULL,
0x0000000c00077306ULL, 0x0003f0000020d400ULL, 0x0000001100537306ULL, 0x000fe20000009400ULL,
0x00000018ff0c7819ULL, 0x002fce000001140bULL, 0x0000000c00437306ULL, 0x000ff00000209400ULL,
0x0000000c00487306ULL, 0x000e700000205400ULL, 0x0000000c004a7306ULL, 0x0004f0000020d400ULL,
0x0000001100627306ULL, 0x000f220000005400ULL, 0x000000000d0c783bULL, 0x004ea20000000200ULL,
0x000000484300720bULL, 0x002fcc0003f1d000ULL, 0x00000011003e7306ULL, 0x00032e000000d400ULL,
0x000000014a4a0812ULL, 0x008fe200078efcffULL, 0x00000012004f7306ULL, 0x000fe20000009400ULL,
0x0000010011117824ULL, 0x002fe200078e00ffULL, 0x000000625300720bULL, 0x010fc80003f3d000ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000012005a7306ULL, 0x000e6e0000005400ULL,
0x000000013e3e1812ULL, 0x000fe200078efcffULL, 0x00000012006b7306ULL, 0x000730000000d400ULL,
0x00000011000b7306ULL, 0x000fe20000209400ULL, 0x0000010012127824ULL, 0x008fe200078e00ffULL,
0x0000005a4f00720bULL, 0x002fc40003f5d000ULL, 0x00000018ff4c7819ULL, 0x004fe4000001140fULL,
0x00000018ff657819ULL, 0x000fe40000011412ULL, 0x0000001100687306ULL, 0x000e620000205400ULL,
0x00000018ff537819ULL, 0x000fcc000001140cULL, 0x000000016b6b2812ULL, 0x010fe200078efcffULL,
0x0000001100497306ULL, 0x000eb0000020d400ULL, 0x0000001300117306ULL, 0x000fe20000009400ULL,
0x000000680b00720bULL, 0x002fe20003f1d000ULL, 0x00010000150b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff687819ULL, 0x000fe2000001140bULL, 0x0000001300127306ULL, 0x000e6c0000005400ULL,
0x0000000149490812ULL, 0x004fe400078efcffULL, 0x00000014001b7306ULL, 0x000fe20000009400ULL,
0x000000595400720bULL, 0x000fe20003f1d000ULL, 0x000100000c547824ULL, 0x000fe200078e00ffULL,
0x000000121100720bULL, 0x002fca0003fdd000ULL, 0x0000006000097306ULL, 0x000fe20000209400ULL,
0x00000018ff127819ULL, 0x000fe4000001140eULL, 0x00000018ff117819ULL, 0x000fc6000001140dULL,
0x0000000152520812ULL, 0x000fe400078efcffULL, 0x0000001200517306ULL, 0x000ff00000209400ULL,
0x0000001200587306ULL, 0x000e700000205400ULL, 0x0000001200577306ULL, 0x000eb0000020d400ULL,
0x0000001400127306ULL, 0x000ee20000005400ULL, 0x000000585100720bULL, 0x002fce0003f1d000ULL,
0x00000060001a7306ULL, 0x000e6c0000205400ULL, 0x0000000157570812ULL, 0x004fe400078efcffULL,
0x00000060006c7306ULL, 0x000ea2000020d400ULL, 0x000000121b00720bULL, 0x008fe20003f9d000ULL,
0x00000100141b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff1b7819ULL, 0x000fe2000001141bULL,
0x0000007c005e7306ULL, 0x000fe20000209400ULL, 0x0000001a0900720bULL, 0x002fce0003f3d000ULL,
0x0000007c00607306ULL, 0x000e6c0000205400ULL, 0x000000016c6c1812ULL, 0x004fe400078efcffULL,
0x00000011004f7306ULL, 0x000ff00000209400ULL, 0x0000001100507306ULL, 0x000fe20000205400ULL,
0x000000605e00720bULL, 0x002fce0003f3d000ULL, 0x0000001100557306ULL, 0x0003f0000020d400ULL,
0x0000001400487306ULL, 0x000ea2000000d400ULL, 0x0001000014117824ULL, 0x002fce00078e00ffULL,
0x0000000c00147306ULL, 0x000ff00000009400ULL, 0x0000000c00597306ULL, 0x000e620000005400ULL,
0x0000000148484812ULL, 0x004fce00078efcffULL, 0x00000065005c7306ULL, 0x000ff00000209400ULL,
0x00000065005d7306ULL, 0x000ea20000205400ULL, 0x000000591400720bULL, 0x002fe20003f5d000ULL,
0x000001000c147824ULL, 0x000fcc00078e00ffULL, 0x0000001b003c7306ULL, 0x000ff00000209400ULL,
0x0000001b00437306ULL, 0x000fe20000205400ULL, 0x0000005d5c00720bULL, 0x004fce0003f7d000ULL,
0x0000001b00097306ULL, 0x000ff0000020d400ULL, 0x00000068001a7306ULL, 0x000ff00000209400ULL,
0x00000068001b7306ULL, 0x000e700000205400ULL, 0x00000068000b7306ULL, 0x0005f0000020d400ULL,
0x0000007c00647306ULL, 0x000722000020d400ULL, 0x00000018ff687819ULL, 0x004fc40000011454ULL,
0x0000001b1a00720bULL, 0x002fca0003f9d000ULL, 0x0000006800547306ULL, 0x000fe20000209400ULL,
0x00000018ff7c7819ULL, 0x008fce0000011411ULL, 0x00000068005e7306ULL, 0x000e620000205400ULL,
0x0000000164641812ULL, 0x010fe400078efcffULL, 0x000000010b0b4812ULL, 0x000fca00078efcffULL,
0x0000001300637306ULL, 0x0004f0000000d400ULL, 0x00000065004e7306ULL, 0x000f22000020d400ULL,
0x00000018ff137819ULL, 0x004fe40000011456ULL, 0x0000005e5400720bULL, 0x002fca0003f3d000ULL,
0x0000001300567306ULL, 0x000fe20000209400ULL, 0x0000000163636812ULL, 0x008fce00078efcffULL,
0x00000013005b7306ULL, 0x000e620000205400ULL, 0x000000014e4e3812ULL, 0x010fce00078efcffULL,
0x0000001300627306ULL, 0x000eb0000020d400ULL, 0x0000004c00137306ULL, 0x000fe20000209400ULL,
0x0000005b5600720bULL, 0x002fe20003f7d000ULL, 0x000100000d567824ULL, 0x000fcc00078e00ffULL,
0x0000004c00467306ULL, 0x000fec0000205400ULL, 0x0000000162623812ULL, 0x004fe400078efcffULL,
0x0000004c004b7306ULL, 0x000fe2000020d400ULL, 0x000000504f00720bULL, 0x000fe20003f7d000ULL,
0x000100000e4f7824ULL, 0x000fcc00078e00ffULL, 0x0000007c00117306ULL, 0x000fec0000209400ULL,
0x0000000155553812ULL, 0x000fe400078efcffULL, 0x0000007c00127306ULL, 0x000fe20000205400ULL,
0x000000424700720bULL, 0x000fce0003f7d000ULL, 0x0000007c004c7306ULL, 0x0003ec000020d400ULL,
0x0000000108083812ULL, 0x000fe400078efcffULL, 0x00000053005a7306ULL, 0x000fe20000209400ULL,
0x00000018ff7c7819ULL, 0x002fce0000011414ULL, 0x0000005300657306ULL, 0x000e700000205400ULL,
0x0000006800607306ULL, 0x000eb0000020d400ULL, 0x0000007c00597306ULL, 0x000fe20000209400ULL,
0x000000655a00720bULL, 0x002fc40003fbd000ULL, 0x00000018ff5a7819ULL, 0x000fe20000011456ULL,
0x000001000d567824ULL, 0x000fc800078e00ffULL, 0x0000007c00147306ULL, 0x000e620000205400ULL,
0x0000000160601812ULL, 0x004fce00078efcffULL, 0x0000000c005c7306ULL, 0x000eb0000000d400ULL,
0x0000000d000c7306ULL, 0x000fe20000009400ULL, 0x000000145900720bULL, 0x002fce0003f3d000ULL,
0x0000000d005b7306ULL, 0x000e620000005400ULL, 0x000000015c5c2812ULL, 0x004fce00078efcffULL,
0x0000000d00547306ULL, 0x000eb0000000d400ULL, 0x0000000e000d7306ULL, 0x000fe20000009400ULL,
0x0000005b0c00720bULL, 0x002fce0003fdd000ULL, 0x0000000e00147306ULL, 0x000e6c0000005400ULL,
0x0000000154546812ULL, 0x004fe400078efcffULL, 0x0000007c005d7306ULL, 0x0004f0000020d400ULL,
0x0000005300537306ULL, 0x000f22000020d400ULL, 0x00000018ff7c7819ULL, 0x004fc40000011456ULL,
0x000000140d00720bULL, 0x002fe20003f5d000ULL, 0x000001000e0d7824ULL, 0x000fc800078e00ffULL,
0x0000005a00657306ULL, 0x000fe20000209400ULL, 0x00000018ff587819ULL, 0x000fe4000001140dULL,
0x000000015d5d1812ULL, 0x008fca00078efcffULL, 0x0000005a000c7306ULL, 0x000e620000205400ULL,
0x0000000153535812ULL, 0x010fce00078efcffULL, 0x0000007c005e7306ULL, 0x000ff00000209400ULL,
0x0000007c00687306ULL, 0x000ea20000205400ULL, 0x0000000c6500720bULL, 0x002fe20003f3d000ULL,
0x000100000f0c7824ULL, 0x000fcc00078e00ffULL, 0x0000005a005b7306ULL, 0x000e70000020d400ULL,
0x0000005800147306ULL, 0x000fe20000209400ULL, 0x000000685e00720bULL, 0x004fe40003fbd000ULL,
0x00000018ff5e7819ULL, 0x000fca000001140cULL, 0x00000058000d7306ULL, 0x000ea20000205400ULL,
0x000000015b5b1812ULL, 0x002fc800078efcffULL, 0x000000545b54723eULL, 0x000fc600000010ffULL,
0x0000007c00567306ULL, 0x0002f0000020d400ULL, 0x0000000e005a7306ULL, 0x000f22000000d400ULL,
0x00000018ff7c7819ULL, 0x002fe4000001144fULL, 0x0000000d1400720bULL, 0x004fca0003fdd000ULL,
0x0000000f00517306ULL, 0x000fe20000009400ULL, 0x0000000156565812ULL, 0x008fc800078efcffULL,
0x000000565555723eULL, 0x000fc600000010ffULL, 0x0000000f000e7306ULL, 0x000e620000005400ULL,
0x000000015a5a2812ULL, 0x010fe400078efcffULL, 0x000000461300720bULL, 0x000fca0003f5d000ULL,
0x0000007c004f7306ULL, 0x000ff00000209400ULL, 0x0000007c00507306ULL, 0x000ea20000205400ULL,
0x0000000e5100720bULL, 0x002fe20003fbd000ULL, 0x000001000f0e7824ULL, 0x000fe200078e00ffULL,
0x000000014b4b2812ULL, 0x000fc800078efcffULL, 0x00000018ff687819ULL, 0x000fe2000001140eULL,
0x0000005800587306ULL, 0x000e70000020d400ULL, 0x0000005e000c7306ULL, 0x000fe20000209400ULL,
0x000000504f00720bULL, 0x004fce0003f3d000ULL, 0x0000005e00657306ULL, 0x000ea20000205400ULL,
0x0000000158586812ULL, 0x002fce00078efcffULL, 0x0000005e00507306ULL, 0x000e70000020d400ULL,
0x0000000f00517306ULL, 0x000ee2000000d400ULL, 0x000000650c00720bULL, 0x004fe20003fdd000ULL,
0x00000100150c7824ULL, 0x000fcc00078e00ffULL, 0x00000068000e7306ULL, 0x000fec0000209400ULL,
0x0000000150506812ULL, 0x002fe400078efcffULL, 0x00000068005e7306ULL, 0x000e620000205400ULL,
0x0000000151515812ULL, 0x008fe400078efcffULL, 0x000000121100720bULL, 0x000fc40003fbd000ULL,
0x000000515050723eULL, 0x000fc600000010ffULL, 0x00000015000d7306ULL, 0x000ff00000009400ULL,
0x0000001500147306ULL, 0x000ea20000005400ULL, 0x0000005e0e00720bULL, 0x002fe20003fdd000ULL,
0x00010000160e7824ULL, 0x000fe200078e00ffULL, 0x000000014c4c5812ULL, 0x000fc400078efcffULL,
0x000000433c00720bULL, 0x000fe40003fbd000ULL, 0x0000000702437812ULL, 0x000fe200078ec0ffULL,
0x00000068004f7306ULL, 0x000e70000020d400ULL, 0x00000016000f7306ULL, 0x000fe20000009400ULL,
0x000000140d00720bULL, 0x004fc40003f1d000ULL, 0xfffffff8100d7812ULL, 0x000fe400078ee23fULL,
0x0000000109095812ULL, 0x000fc600078efcffULL, 0x0000001600427306ULL, 0x000ea20000005400ULL,
0x000000014f4f6812ULL, 0x002fe200078efcffULL, 0x000000100d107824ULL, 0x000fe200078e0240ULL,
0x000000191800720bULL, 0x000fe40003fdd000ULL, 0x00000004ff197819ULL, 0x000fe40000011602ULL,
0x00000018ff407819ULL, 0x000fe2000001140eULL, 0x00000016000d7306ULL, 0x0002e2000000d400ULL,
0x000000001010783bULL, 0x000fe20000000200ULL, 0x00000002045e7824ULL, 0x000fe200078e0219ULL,
0x0000004f4b51723eULL, 0x000fc400000010ffULL, 0x0000000204047810ULL, 0x000fe40007ffe0ffULL,
0x000000420f00720bULL, 0x004fe20003f5d000ULL, 0x00000100160f7824ULL, 0x000fe200078e00ffULL,
0x0000000843167812ULL, 0x002fe200078ef802ULL, 0x0000007c00597306ULL, 0x000e62000020d400ULL,
0x0000000107076812ULL, 0x000fe400078efcffULL, 0x00000018ff3c7819ULL, 0x000fe2000001140fULL,
0x0000000116187824ULL, 0x040fe400078e025eULL, 0x0000001016197824ULL, 0x000fc400078e00ffULL,
0x00000040000e7306ULL, 0x000fe40000209400ULL, 0x000000010d0d2812ULL, 0x008fe400078efcffULL,
0xfffffff019187812ULL, 0x000fe400078ee218ULL, 0x0000000159591812ULL, 0x002fc600078efcffULL,
0x0000001018187824ULL, 0x000fe200078e00ffULL, 0x000000450a00720bULL, 0x000fe20003f3d000ULL,
0x0000003c000f7306ULL, 0x000fe20000209400ULL, 0x00000018ff457819ULL, 0x000fc6000001140cULL,
0x000000001818783bULL, 0x000e680000000200ULL, 0x00000015000a7306ULL, 0x000ea8000000d400ULL,
0x0000000106061812ULL, 0x000fc800078efcffULL, 0x0000004500147306ULL, 0x000ff00000209400ULL,
0x00000045003f7306ULL, 0x000ee20000205400ULL, 0x000000010a0a0812ULL, 0x004fc800078efcffULL,
0x0000000a0b0a723eULL, 0x000fc600000010ffULL, 0x0000004000157306ULL, 0x000eb00000205400ULL,
0x0000003c007c7306ULL, 0x000f220000205400ULL, 0x0000003f1400720bULL, 0x008fe40003fbd000ULL,
0x000000747514723eULL, 0x000fe200000010ffULL, 0x000000541828723cULL, 0x002be20000041828ULL,
0x000000150e00720bULL, 0x004fc60003f7d000ULL, 0x00000045000c7306ULL, 0x0002a2000020d400ULL,
0x000000444115723eULL, 0x000fe400000010ffULL, 0x00000018ff0e7819ULL, 0x000fe20000011412ULL,
0x00000050181c723cULL, 0x040fe2000004181cULL, 0x0000005a5954723eULL, 0x020fe400000010ffULL,
0x0000007c0f00720bULL, 0x010fe20003f9d000ULL, 0x0000004000477306ULL, 0x000ee2000020d400ULL,
0x00000018ff457819ULL, 0x002fe40000011410ULL, 0x000000585755723eULL, 0x000fe200000010ffULL,
0x000000141824723cULL, 0x000be20000041824ULL, 0x0000010013587824ULL, 0x000fc600078e00ffULL,
0x0000004500657306ULL, 0x000fe20000209400ULL, 0x000000010c0c5812ULL, 0x004fe400078efcffULL,
0x0001000017147824ULL, 0x020fe200078e00ffULL, 0x000000493d15723eULL, 0x000fe200000010ffULL,
0x000000541820723cULL, 0x000be20000041820ULL, 0x0000000c060b723eULL, 0x000fe400000010ffULL,
0x00000018ff7c7819ULL, 0x000fe20000011414ULL, 0x0000004500687306ULL, 0x000e620000205400ULL,
0x0000003e4a14723eULL, 0x000fc400000010ffULL, 0x0000000147473812ULL, 0x008fe200078efcffULL,
0x0001000013547824ULL, 0x020fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x000000090855723eULL, 0x000fe200000010ffULL, 0x0000007c00747306ULL, 0x000fe20000209400ULL,
0x000000141838723cULL, 0x000b620000041838ULL, 0x00000018ff4f7819ULL, 0x000fe40000011454ULL,
0x0000000d4706723eULL, 0x000fe400000010ffULL, 0x000000484c54723eULL, 0x000fc400000010ffULL,
0x0000007c00757306ULL, 0x000ea20000205400ULL, 0x0001000010157824ULL, 0x020fe200078e00ffULL,
0x000000686500720bULL, 0x002fc80003f1d000ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000001700497306ULL, 0x000ff00000009400ULL, 0x00000017004a7306ULL, 0x000e620000005400ULL,
0x000000757400720bULL, 0x004fce0003fbd000ULL, 0x0000001500147306ULL, 0x000ff00000209400ULL,
0x0000001500757306ULL, 0x000ea20000205400ULL, 0x0000004a4900720bULL, 0x002fe20003f3d000ULL,
0x0000010017497824ULL, 0x000fcc00078e00ffULL, 0x0000001000747306ULL, 0x000ff00000009400ULL,
0x0000001000657306ULL, 0x000e620000005400ULL, 0x000000751400720bULL, 0x004fe40003f5d000ULL,
0x0000006b6c14723eULL, 0x000fe200000010ffULL, 0x00000100106b7824ULL, 0x000fc800078e00ffULL,
0x00000010004a7306ULL, 0x000eb0000000d400ULL, 0x00000017003d7306ULL, 0x000722000000d400ULL,
0x000000657400720bULL, 0x002fce0003f7d000ULL, 0x0000001500107306ULL, 0x000322000020d400ULL,
0x00000018ff177819ULL, 0x008fca0000011449ULL, 0x000000014a4a3812ULL, 0x004fe400078efcffULL,
0x0000001700687306ULL, 0x000fe20000209400ULL, 0x0000004e4d15723eULL, 0x002fe400000010ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001146bULL, 0x000000013d3d1812ULL, 0x010fc600078efcffULL,
0x0000001700657306ULL, 0x000fe20000205400ULL, 0x000000141834723cULL, 0x000b620000041834ULL,
0x0000000110102812ULL, 0x000fcc00078efcffULL, 0x0000001700497306ULL, 0x000fe2000020d400ULL,
0x0001000011147824ULL, 0x020fe200078e00ffULL, 0x000000625215723eULL, 0x000fcc00000010ffULL,
0x0000004d00177306ULL, 0x000ff00000209400ULL, 0x0000004d006b7306ULL, 0x000e700000205400ULL,
0x0000007c003e7306ULL, 0x0004e2000020d400ULL, 0x0000006b1700720bULL, 0x002fce0003fdd000ULL,
0x0000003c00437306ULL, 0x000322000020d400ULL, 0x00000018ff7c7819ULL, 0x004fe40000011414ULL,
0x000000636414723eULL, 0x000fe400000010ffULL, 0x000000013e3e5812ULL, 0x008fc600078efcffULL,
0x0000001200177306ULL, 0x000fe20000009400ULL, 0x00000018ff3c7819ULL, 0x002fe20000011411ULL,
0x000000141830723cULL, 0x000b620000041830ULL, 0x0000003d3e48723eULL, 0x000fe400000010ffULL,
0x0000004a103e723eULL, 0x000fc600000010ffULL, 0x0000001100747306ULL, 0x000fe20000009400ULL,
0x0000005c6014723eULL, 0x020fe400000010ffULL, 0x0000005d5315723eULL, 0x000fe400000010ffULL,
0x0000000143434812ULL, 0x010fc600078efcffULL, 0x0000001200607306ULL, 0x000e620000005400ULL,
0x000000430707723eULL, 0x000fe200000010ffULL, 0x00000014182c723cULL, 0x000b6c000004182cULL,
0x0000001100757306ULL, 0x000ea20000005400ULL, 0x0001000012147824ULL, 0x020fca00078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011414ULL, 0x000000601700720bULL, 0x002fe20003f7d000ULL,
0x0000010012177824ULL, 0x000fe200078e00ffULL, 0x0000000216147810ULL, 0x040fe20007ffe05eULL,
0x0000001200537306ULL, 0x000e66000000d400ULL, 0x00000018ff647819ULL, 0x000fe20000011417ULL,
0x0000001016177824ULL, 0x000fe200078e00ffULL, 0x000000757400720bULL, 0x004fe20003f9d000ULL,
0x0000010011757824ULL, 0x000fc400078e00ffULL, 0x00000015005c7306ULL, 0x000fe20000209400ULL,
0xfffffff017147812ULL, 0x000fe400078ee214ULL, 0x00000018ff757819ULL, 0x000fc60000011475ULL,
0x0000001014147824ULL, 0x000fe400078e00ffULL, 0x00000015005d7306ULL, 0x000fe20000205400ULL,
0x0000000153533812ULL, 0x002fce00078efcffULL, 0x0000001500127306ULL, 0x0003f0000020d400ULL,
0x00000045003f7306ULL, 0x000ea2000020d400ULL, 0x000000001414783bULL, 0x002e6e0000000200ULL,
0x0000007c006c7306ULL, 0x000ff00000209400ULL, 0x0000007c00747306ULL, 0x000ee20000205400ULL,
0x000000013f3f0812ULL, 0x004fc400078efcffULL, 0x0000005f6100720bULL, 0x000fca0003f1d000ULL,
0x00000011004e7306ULL, 0x000eb0000000d400ULL, 0x0000007c00117306ULL, 0x000f22000020d400ULL,
0x000000746c00720bULL, 0x008fe40003f5d000ULL, 0x0000000105050812ULL, 0x000fc400078efcffULL,
0x0000005d5c00720bULL, 0x000fc60003f1d000ULL, 0x0000003c00407306ULL, 0x000fe20000209400ULL,
0x0000000a1438723cULL, 0x002b620000041838ULL, 0x000000014e4e4812ULL, 0x004fcc00078efcffULL,
0x0000003c00467306ULL, 0x000e620000205400ULL, 0x0000000111112812ULL, 0x010fe200078efcffULL,
0x000000061434723cULL, 0x040b620000041834ULL, 0x000000656800720bULL, 0x000fe40003f5d000ULL,
0x0000000112120812ULL, 0x000fe400078efcffULL, 0x0000004e114e723eULL, 0x000fe200000010ffULL,
0x0000007500637306ULL, 0x000fe20000209400ULL, 0x000000531212723eULL, 0x000fe200000010ffULL,
0x000000541424723cULL, 0x000b6c0000041824ULL, 0x0000007500627306ULL, 0x000ea20000205400ULL,
0x000000464000720bULL, 0x002fc40003fbd000ULL, 0x0000000149492812ULL, 0x000fc800078efcffULL,
0x000000490549723eULL, 0x000fe200000010ffULL, 0x0000000e00427306ULL, 0x000fec0000209400ULL,
0x000000481430723cULL, 0x000b640000041830ULL, 0x0000000e00457306ULL, 0x000e620000205400ULL,
0x000000626300720bULL, 0x004fce0003f3d000ULL, 0x0000000e000f7306ULL, 0x0004f0000020d400ULL,
0x0000005800097306ULL, 0x000fe20000209400ULL, 0x00000018ff0e7819ULL, 0x004fe40000011413ULL,
0x000000454200720bULL, 0x002fca0003f5d000ULL, 0x00000058000a7306ULL, 0x020e700000205400ULL,
0x0000003c003c7306ULL, 0x000ea2000020d400ULL, 0x000000010f0f2812ULL, 0x008fce00078efcffULL,
0x0000004d004d7306ULL, 0x000ee2000020d400ULL, 0x0000000a0900720bULL, 0x002fce0003f1d000ULL,
0x0000007500527306ULL, 0x000e62000020d400ULL, 0x000000013c3c5812ULL, 0x004fce00078efcffULL,
0x0000000e00417306ULL, 0x000fe20000209400ULL, 0x000000014d4d6812ULL, 0x008fc800078efcffULL,
0x0000004d3f3f723eULL, 0x000fc600000010ffULL, 0x0000000e00447306ULL, 0x000ea20000205400ULL,
0x0000000152521812ULL, 0x002fc600078efcffULL, 0x0000003e142c723cULL, 0x000b68000004182cULL,
0x00000064005e7306ULL, 0x000ff00000209400ULL, 0x00000064005b7306ULL, 0x000e620000205400ULL,
0x000000444100720bULL, 0x004fce0003f9d000ULL, 0x0000001300607306ULL, 0x000ff00000009400ULL,
0x0000001300597306ULL, 0x000ea20000005400ULL, 0x0000005b5e00720bULL, 0x002fce0003f3d000ULL,
0x0000004f004b7306ULL, 0x000ff00000209400ULL, 0x0000004f00087306ULL, 0x000e620000205400ULL,
0x000000596000720bULL, 0x004fce0003fdd000ULL, 0x0000005800077306ULL, 0x000eb0000020d400ULL,
0x0000000e000e7306ULL, 0x000ee2000020d400ULL, 0x000000084b00720bULL, 0x002fce0003fbd000ULL,
0x0000006400567306ULL, 0x000e62000020d400ULL, 0x0000000107070812ULL, 0x004fe400078efcffULL,
0x000000080400780cULL, 0x000fca0003f05270ULL, 0x0000001300577306ULL, 0x000522000000d400ULL,
0x000000010e0e4812ULL, 0x008fc800078efcffULL, 0x000000070e07723eULL, 0x000fc600000010ffULL,
0x0000004f00067306ULL, 0x0006e2000020d400ULL, 0x0000000156561812ULL, 0x002fc800078efcffULL,
0x000000560f13723eULL, 0x004fe400000010ffULL, 0x0000000157576812ULL, 0x010fe400078efcffULL,
0x000000523c4f723eULL, 0x008fc600000010ffULL, 0x000000121420723cULL, 0x000b620000041820ULL,
0x0000000106065812ULL, 0x000fc800078efcffULL, 0x000000570606723eULL, 0x000fc600000010ffULL,
0x0000004e1428723cULL, 0x040b700000041828ULL, 0x00000006141c723cULL, 0x000b62000004181cULL,
0x0000001000008944ULL, 0x000fe20003c00000ULL, 0xffffe11000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x000000032c2c7220ULL, 0x0a0fe40000410000ULL, 0x0000000325257220ULL, 0x000fc40000410000ULL,
0x0000000329297220ULL, 0x080fe40000410000ULL, 0x0000000339397220ULL, 0x080fe40000410000ULL,
0x0000000334347220ULL, 0x080fe40000410000ULL, 0x0000000335357220ULL, 0x080fe40000410000ULL,
0x0000000321217220ULL, 0x080fe40000410000ULL, 0x000000032f167220ULL, 0x000fc40000410000ULL,
0x0000000326067220ULL, 0x080fe40000410000ULL, 0x0000000327077220ULL, 0x080fe40000410000ULL,
0x0000000323137220ULL, 0x080fe40000410000ULL, 0x000000ffff2f7224ULL, 0x000fe400078e002cULL,
0x00000003241b7220ULL, 0x080fe40000410000ULL, 0x0000000330267220ULL, 0x000fc40000410000ULL,
0x000000032d277220ULL, 0x080fe40000410000ULL, 0x000000032a157220ULL, 0x080fe40000410000ULL,
0x000000032b147220ULL, 0x080fe40000410000ULL, 0x0000000322127220ULL, 0x000fe40000410000ULL,
0x000000ffff237224ULL, 0x000fe400078e0025ULL, 0x000000ffff2c7224ULL, 0x000fc400078e0029ULL,
0x0000000338247220ULL, 0x080fe40000410000ULL, 0x000000033a3a7220ULL, 0x080fe40000410000ULL,
0x000000033b3b7220ULL, 0x080fe40000410000ULL, 0x0000000336367220ULL, 0x080fe40000410000ULL,
0x0000000337377220ULL, 0x080fe40000410000ULL, 0x0000000331317220ULL, 0x000fc40000410000ULL,
0x0000000332327220ULL, 0x080fe40000410000ULL, 0x0000000333307220ULL, 0x080fe40000410000ULL,
0x000000032e177220ULL, 0x080fe40000410000ULL, 0x0000000328287220ULL, 0x080fe40000410000ULL,
0x00000003202b7220ULL, 0x080fe40000410000ULL, 0x000000031c227220ULL, 0x000fc40000410000ULL,
0x000000031d1a7220ULL, 0x080fe40000410000ULL, 0x000000031e187220ULL, 0x080fe40000410000ULL,
0x000000031f197220ULL, 0x000fe40000410000ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0039ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0034ULL, 0x000000ffff257224ULL, 0x000fc400078e0035ULL,
0x000000ffff297224ULL, 0x000fe200078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000079047f8cULL, 0x0002a2000c80043fULL, 0x000000ffff1e7224ULL, 0x000fe400078e0006ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0007ULL, 0x000000ffff1d7224ULL, 0x000fe400078e003aULL,
0x000000ffff2e7224ULL, 0x000fe400078e003bULL, 0x000000ffff207224ULL, 0x000fc400078e0036ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0037ULL, 0x000000ffff217224ULL, 0x000fc400078e0032ULL,
0x0000000000067805ULL, 0x002fca0000015200ULL, 0x0000040079097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x006fe40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040079097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000402117824ULL, 0x000fe200078e00ffULL,
0x000000766e00720cULL, 0x000fc80003f06070ULL, 0xfffffff011057812ULL, 0x000fca00078ec0ffULL,
0x0000008000107824ULL, 0x000fca00078e0205ULL, 0x0174000010047984ULL, 0x0002a20000000c00ULL,
0x000014f000008947ULL, 0x000fea0003800000ULL, 0x00005a00000a7b06ULL, 0x000ee20000209000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fe20003f85070ULL,
0x0000000202347824ULL, 0x000fe200078e00ffULL, 0x00005a00ff367a12ULL, 0x000fc800078e33ffULL,
0x0000000634347812ULL, 0x000fca00078ec0ffULL, 0x0000000134327824ULL, 0x000fe200078e026aULL,
0x0000000a000a7308ULL, 0x008ee40000001000ULL, 0x0ffffffe0a0c7810ULL, 0x008fcc0007ffe0ffULL,
0x0000000c00097305ULL, 0x000ee4000021f000ULL, 0x000000ffff0b7224ULL, 0x008fc800078e0a09ULL,
0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b09357227ULL, 0x000fe200078e0008ULL,
0x0000007d02087211ULL, 0x000fca00078ff0ffULL, 0x0000000835097227ULL, 0x000fc800078e00ffULL,
0x000000ffff0b7224ULL, 0x000fc800078e0a09ULL, 0x00005a000b0a7a24ULL, 0x000fe200078e0208ULL,
0x0000000808087810ULL, 0x000fc80007ffe0ffULL, 0x00005a000a007a0cULL, 0x000fe20003f06070ULL,
0x0000000835357227ULL, 0x000fc800078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc800078e0a35ULL,
0x00005a000b0b7a24ULL, 0x000fe200078e0208ULL, 0xffffff006f087810ULL, 0x000fc60007ffe0ffULL,
0x80005a000a0a0a10ULL, 0x000fe40007ffe0ffULL, 0x00005a000b007a0cULL, 0x000fe40003f46070ULL,
0x00005a000a007a0cULL, 0x000fe40003f26070ULL, 0x0000000877337217ULL, 0x000fe40007800000ULL,
0x0000000109090810ULL, 0x000fc60007ffe0ffULL, 0x0000000133337824ULL, 0x000fe400078e0a08ULL,
0x0000000170087824ULL, 0x000fe400078e0234ULL, 0x80005a000b0b2a10ULL, 0x000fe40007ffe0ffULL,
0x00000001080a7824ULL, 0x040fe200078e0a33ULL, 0x0000000109091810ULL, 0x000fe40007ffe0ffULL,
0x000000330800720cULL, 0x000fe40003f66070ULL, 0x00005a000b007a0cULL, 0x000fc40003f06070ULL,
0x0000000936087207ULL, 0x000fe40006000000ULL, 0x0000000a6d0b7217ULL, 0x040fe20003800000ULL,
0x00000001320a7824ULL, 0x040fe200078e0a33ULL, 0x000000086d097217ULL, 0x040fe40003800000ULL,
0x00000004ff0b7819ULL, 0x000fe4000001160bULL, 0x000000333200720cULL, 0x000fe20003f26070ULL,
0x00000009724c7224ULL, 0x000fe200078e02ffULL, 0x0000000a6d0a7217ULL, 0x000fc40003800000ULL,
0x000000ff0b0b7207ULL, 0x000fe40001800000ULL, 0x000000ff0a477207ULL, 0x000fe40000800000ULL,
0x0000000135352810ULL, 0x000fe20007ffe0ffULL, 0x000000014c0d7824ULL, 0x000fe200078e020bULL,
0x0000004c470f7211ULL, 0x000fe400078fe0ffULL, 0x0000000135350810ULL, 0x000fe20007ffe0ffULL,
0x000000020d0c7825ULL, 0x000fe200078e0066ULL, 0x0000001034377812ULL, 0x000fc400078efcffULL,
0x0000003536087207ULL, 0x000fe20006000000ULL, 0x000000020f0e7825ULL, 0x000fe200078e0066ULL,
0x000000060c497981ULL, 0x000724000c1e9500ULL, 0x000000086d097217ULL, 0x000fe40003800000ULL,
0x000000060e4a7981ULL, 0x000326000c1e9500ULL, 0x00000009724e7224ULL, 0x000fe400078e02ffULL,
0x00000001700c7824ULL, 0x008fe200078e0237ULL, 0x0000002034387812ULL, 0x000fe200078efcffULL,
0x0000000137367824ULL, 0x000fe200078e026aULL, 0x0000004e47097211ULL, 0x000fe200078fe0ffULL,
0x000000010c0e7824ULL, 0x042fe200078e0a33ULL, 0x000000330c00720cULL, 0x000fe20003f26070ULL,
0x00000001703e7824ULL, 0x000fc400078e0238ULL, 0x0000000209087825ULL, 0x000fe200078e0066ULL,
0x0000000e6d0e7217ULL, 0x000fc60003800000ULL, 0x000000010b0b7824ULL, 0x000fe200078e024eULL,
0x00000004ff0e7819ULL, 0x000fe2000001160eULL, 0x000000013e407824ULL, 0x100fe200078e0a33ULL,
0x0000000608487981ULL, 0x0002e2000c1e9500ULL, 0x00000001360c7824ULL, 0x000fe200078e0a33ULL,
0x000000ff0e0d7207ULL, 0x000fe20000800000ULL, 0x000000020b0a7825ULL, 0x000fe200078e0066ULL,
0x000000406d3d7217ULL, 0x000fc60003800000ULL, 0x000000014c097824ULL, 0x002fe200078e020dULL,
0x000000333600720cULL, 0x080fe20003f06070ULL, 0x00000001383c7824ULL, 0x000fe200078e026aULL,
0x0000000c6d0c7217ULL, 0x000fe20003800000ULL, 0x0000000209087825ULL, 0x000fe200078e0066ULL,
0x000000333e00720cULL, 0x000fe20003f26070ULL, 0x000000060a437981ULL, 0x0002e2000c1e9500ULL,
0x00000004ff3d7819ULL, 0x000fe4000001163dULL, 0x000000ff0c357207ULL, 0x000fe20000000000ULL,
0x0000000608397981ULL, 0x0004e2000c1e9500ULL, 0x000000ff3d417207ULL, 0x000fc40000800000ULL,
0x00000030343d7812ULL, 0x000fe200078efcffULL, 0x000000010d0d7824ULL, 0x000fe200078e024eULL,
0x0000004e350f7211ULL, 0x040fe200078fe0ffULL, 0x000000013c087824ULL, 0x004fe200078e0a33ULL,
0x0000004c350b7211ULL, 0x002fe200078fe0ffULL, 0x000000014c097824ULL, 0x000fe200078e0241ULL,
0x000000333c00720cULL, 0x000fe40003f06070ULL, 0x000000086d087217ULL, 0x000fe20003800000ULL,
0x0000000170507824ULL, 0x000fe400078e023dULL, 0x000000020b0a7825ULL, 0x000fe200078e0066ULL,
0x000000ff083e7207ULL, 0x000fc60000000000ULL, 0x000000020d0c7825ULL, 0x100fe200078e0066ULL,
0x000000060a3a7981ULL, 0x0002a6000c1e9500ULL, 0x000000020f0e7825ULL, 0x100fe200078e0066ULL,
0x000000060c3b7981ULL, 0x0002a6000c1e9500ULL, 0x0000000209087825ULL, 0x000fe200078e0066ULL,
0x000000060e407981ULL, 0x0002a6000c1e9500ULL, 0x0000000150467824ULL, 0x000fe200078e0a33ULL,
0x00000006083f7981ULL, 0x0002a2000c1e9500ULL, 0x000000013d447824ULL, 0x000fe200078e026aULL,
0x0000004c3e0b7211ULL, 0x002fc400078fe0ffULL, 0x000000466d457217ULL, 0x000fe20003800000ULL,
0x00000001410d7824ULL, 0x000fe200078e024eULL, 0x0000004e3e0f7211ULL, 0x000fe200078fe0ffULL,
0x0000000144087824ULL, 0x000fe200078e0a33ULL, 0x000000335000720cULL, 0x080fe40003f26070ULL,
0x00000004ff457819ULL, 0x000fe20000011645ULL, 0x000000020b0a7825ULL, 0x100fe200078e0066ULL,
0x000000334400720cULL, 0x000fe40003f06070ULL, 0x000000086d087217ULL, 0x000fe20003800000ULL,
0x000000020d0c7825ULL, 0x100fe200078e0066ULL, 0x000000ff454b7207ULL, 0x000fe20000800000ULL,
0x000000060a427981ULL, 0x0002a4000c1e9500ULL, 0x000000020f0e7825ULL, 0x000fe200078e0066ULL,
0x000000ff08457207ULL, 0x000fe20000000000ULL, 0x000000060c417981ULL, 0x0002a8000c1e9500ULL,
0x000000060e467981ULL, 0x0002a2000c1e9500ULL, 0x000000014c097824ULL, 0x000fe200078e024bULL,
0x0000004c450b7211ULL, 0x002fc600078fe0ffULL, 0x0000000209087825ULL, 0x000fc800078e0066ULL,
0x000000020b0a7825ULL, 0x000fe400078e0066ULL, 0x0000000608087981ULL, 0x0002a2000c1e9500ULL,
0x0000004e450d7211ULL, 0x000fc600078fe0ffULL, 0x000000060a0b7981ULL, 0x0002a2000c1e9500ULL,
0x000000014b0f7824ULL, 0x000fe400078e024eULL, 0x000000020d0c7825ULL, 0x000fc800078e0066ULL,
0x000000020f0e7825ULL, 0x000fe400078e0066ULL, 0x000000060c0c7981ULL, 0x0002a8000c1e9500ULL,
0x000000060e0f7981ULL, 0x0008a2000c1e9500ULL, 0xfffffff0474c7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff477424ULL, 0x000fc800078e00ffULL, 0x0000000133097824ULL, 0x002fc800078e024cULL,
0x0000000132547824ULL, 0x100fe200078e0a09ULL, 0x00000008344c7812ULL, 0x040fe400078efcffULL,
0x0000000934507812ULL, 0x000fe400078efcffULL, 0x0000005447547219ULL, 0x000fe200000006ffULL,
0x000000014c4e7824ULL, 0x100fe400078e026aULL, 0x00000001500a7824ULL, 0x000fe400078e026aULL,
0x000000014e567824ULL, 0x000fc400078e0a09ULL, 0x000000010a587824ULL, 0x000fe200078e0a09ULL,
0x00000018346c7812ULL, 0x000fe400078efcffULL, 0x0000005647567219ULL, 0x040fe400000006ffULL,
0x0000005847587219ULL, 0x000fe400000006ffULL, 0xfffffff035357812ULL, 0x000fca00078ec0ffULL,
0x0000000133357824ULL, 0x000fe200078e0235ULL, 0x0000001934687812ULL, 0x040fe400078efcffULL,
0x0000001134747812ULL, 0x040fe400078efcffULL, 0x00000021345c7812ULL, 0x040fe400078efcffULL,
0x00000028345a7812ULL, 0x000fe200078efcffULL, 0x00000001687c7824ULL, 0x100fe400078e026aULL,
0x00000001740d7824ULL, 0x000fc400078e026aULL, 0x000000015c627824ULL, 0x100fe400078e026aULL,
0x000000015a607824ULL, 0x000fe400078e026aULL, 0x000000017c4d7824ULL, 0x000fe200078e0a35ULL,
0x000054104a497816ULL, 0x010fe40000000049ULL, 0x00000001344a7812ULL, 0x000fe400078efcffULL,
0x0000004954ff7212ULL, 0x000fc6000780c0ffULL, 0x000000014a527824ULL, 0x000fe200078e026aULL,
0x000000333200720cULL, 0x000fc60000701470ULL, 0x00000001520e7824ULL, 0x000fe200078e0a09ULL,
0x000000333400720cULL, 0x000fc800007a1070ULL, 0x0000000e470e7219ULL, 0x000fe400000006ffULL,
0xff8000001b1b7808ULL, 0x000fe20002800000ULL, 0x000000016c097824ULL, 0x000fe200078e026aULL,
0x000000490eff7212ULL, 0x080fe4000782c0ffULL, 0x0000004956ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004958ff7212ULL, 0x000fe4000788c0ffULL, 0xfffffff045497812ULL, 0x000fc400078ec0ffULL,
0x0000541048437816ULL, 0x008fc80000000043ULL, 0x0000004354ff7212ULL, 0x080fe4000784c0ffULL,
0x000000430eff7212ULL, 0x080fe4000780c0ffULL, 0x0000004356ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004358ff7212ULL, 0x000fe400078ac0ffULL, 0xfffffff03e437812ULL, 0x000fe200078ec0ffULL,
0x00000001094b7824ULL, 0x000fe200078e0a35ULL, 0x000000333200720cULL, 0x000fc40001741470ULL,
0x000000334e00720cULL, 0x080fe200037c1470ULL, 0x0000000133457824ULL, 0x000fe200078e0243ULL,
0x000000330a00720cULL, 0x080fe20002fa1470ULL, 0x0000000136437824ULL, 0x000fe200078e0a35ULL,
0x000000333400720cULL, 0x080fe40001741070ULL, 0x000000334c00720cULL, 0x080fe400037c1070ULL,
0x000000335000720cULL, 0x000fe40002fa1070ULL, 0x0000004347437219ULL, 0x000fc400000006ffULL,
0x0000004b474b7219ULL, 0x000fe400000006ffULL, 0x000054103a3a7816ULL, 0x004fe40000000039ULL,
0x0000002934587812ULL, 0x000fe400078efcffULL, 0x0000541040407816ULL, 0x000fe4000000003bULL,
0x0000003134547812ULL, 0x040fe400078efcffULL, 0x0000003834487812ULL, 0x000fc400078efcffULL,
0x00000039340e7812ULL, 0x000fe400078efcffULL, 0xff8000001e1e7808ULL, 0x000fe40001000000ULL,
0xff8000001d1d7808ULL, 0x000fe40003000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0x0000003a43ff7212ULL, 0x040fe4000784c0ffULL, 0x0000004043ff7212ULL, 0x000fc400078cc0ffULL,
0x000000404bff7212ULL, 0x000fe200078ac0ffULL, 0x00000001585e7824ULL, 0x100fe200078e026aULL,
0x000000335200720cULL, 0x080fe20000f21470ULL, 0x0000000154567824ULL, 0x100fe200078e026aULL,
0x000000335200720cULL, 0x080fe20000701470ULL, 0x0000000148647824ULL, 0x100fe200078e026aULL,
0x000000334e00720cULL, 0x080fe20001f61470ULL, 0x000000010e3e7824ULL, 0x000fe200078e026aULL,
0x000000330a00720cULL, 0x080fe20002781470ULL, 0x00000001334f7824ULL, 0x000fe200078e0249ULL,
0x000000333600720cULL, 0x0c0fe20001741470ULL, 0x000000010d497824ULL, 0x000fe200078e0a35ULL,
0x000000333600720cULL, 0x080fe200037c1470ULL, 0x000000013c517824ULL, 0x100fe200078e0a45ULL,
0x000000330900720cULL, 0x000fe20002fa1470ULL, 0x0000000162537824ULL, 0x000fc400078e0a45ULL,
0x0000000160557824ULL, 0x100fe400078e0a45ULL, 0x000000015e577824ULL, 0x000fe200078e0a45ULL,
0x000000334a00720cULL, 0x080fe20000f21070ULL, 0x0000000144597824ULL, 0x100fe200078e0a4fULL,
0x000000334a00720cULL, 0x080fe20000701070ULL, 0x00000001565b7824ULL, 0x100fe200078e0a4fULL,
0x000000334c00720cULL, 0x080fe20001f61070ULL, 0x0000000164357824ULL, 0x100fe200078e0a4fULL,
0x000000335000720cULL, 0x000fe20002781070ULL, 0x000000013e457824ULL, 0x000fe200078e0a4fULL,
0x0000004d474f7219ULL, 0x000fc400000006ffULL, 0x000000333700720cULL, 0x0c0fe40001741070ULL,
0x000000333700720cULL, 0x080fe400037c1070ULL, 0x000000336c00720cULL, 0x000fe40002fa1070ULL,
0x0000004947497219ULL, 0x040fe400000006ffULL, 0x00000051474d7219ULL, 0x000fe400000006ffULL,
0x0000541042427816ULL, 0x000fc4000000003fULL, 0x0000541046467816ULL, 0x000fe40000000041ULL,
0xff80000023237808ULL, 0x000fe40000800000ULL, 0xff8000001c1c7808ULL, 0x000fe40000000000ULL,
0xff80000024247808ULL, 0x000fe40001800000ULL, 0xff8000002d2d7808ULL, 0x000fe40002000000ULL,
0xff8000002a2a7808ULL, 0x000fc40001000000ULL, 0xff80000020207808ULL, 0x000fe40003000000ULL,
0xff80000021217808ULL, 0x000fe40002800000ULL, 0x0000003a49ff7212ULL, 0x080fe4000782c0ffULL,
0x0000003a4bff7212ULL, 0x080fe4000780c0ffULL, 0x0000003a4fff7212ULL, 0x000fe4000786c0ffULL,
0x0000004049ff7212ULL, 0x000fc4000788c0ffULL, 0x000000404fff7212ULL, 0x000fe4000784c0ffULL,
0x000000424dff7212ULL, 0x040fe400078cc0ffULL, 0x000000464dff7212ULL, 0x000fe400078ac0ffULL,
0x000000330d00720cULL, 0x0c0fe40000f21470ULL, 0x000000330d00720cULL, 0x080fe40002781470ULL,
0x000000330900720cULL, 0x000fc40000701470ULL, 0x000000337c00720cULL, 0x0c0fe40001f61470ULL,
0x000000337c00720cULL, 0x080fe40001741470ULL, 0x000000333c00720cULL, 0x0c0fe400037c1470ULL,
0x000000333c00720cULL, 0x080fe40002fa1470ULL, 0x000000337400720cULL, 0x0c0fe40000f21070ULL,
0x000000337400720cULL, 0x000fc40002781070ULL, 0x000000336c00720cULL, 0x080fe40000701070ULL,
0x000000336800720cULL, 0x0c0fe40001f61070ULL, 0x000000336800720cULL, 0x080fe40001741070ULL,
0x000000333800720cULL, 0x0c0fe400037c1070ULL, 0x000000333800720cULL, 0x000fe40002fa1070ULL,
0x0000005347537219ULL, 0x000fc400000006ffULL, 0x0000005547557219ULL, 0x040fe400000006ffULL,
0x0000005747577219ULL, 0x040fe400000006ffULL, 0x0000005947597219ULL, 0x000fe400000006ffULL,
0x000054100b087816ULL, 0x000fe40000000008ULL, 0xff80000025257808ULL, 0x000fe40000800000ULL,
0xff8000001f1f7808ULL, 0x000fc40002000000ULL, 0xff80000026267808ULL, 0x000fe40000000000ULL,
0xff80000031317808ULL, 0x000fe40001800000ULL, 0xff80000030307808ULL, 0x000fe40001000000ULL,
0xff8000002f2f7808ULL, 0x000fe40003000000ULL, 0xff80000017177808ULL, 0x000fe40002800000ULL,
0x0000004253ff7212ULL, 0x000fc4000782c0ffULL, 0x0000004255ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004257ff7212ULL, 0x000fe4000780c0ffULL, 0x0000004653ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004655ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004657ff7212ULL, 0x000fe400078cc0ffULL,
0x0000000859ff7212ULL, 0x000fc400078ac0ffULL, 0x000000336200720cULL, 0x0c0fe40000f21470ULL,
0x000000336200720cULL, 0x080fe40001f61470ULL, 0x000000336000720cULL, 0x0c0fe40002781470ULL,
0x000000336000720cULL, 0x080fe40001741470ULL, 0x000000335e00720cULL, 0x0c0fe40000701470ULL,
0x000000335e00720cULL, 0x000fc400037c1470ULL, 0x000000334400720cULL, 0x080fe40002fa1470ULL,
0x000000335c00720cULL, 0x0c0fe40000f21070ULL, 0x000000335c00720cULL, 0x080fe40001f61070ULL,
0x000000335a00720cULL, 0x0c0fe40002781070ULL, 0x000000335a00720cULL, 0x080fe40001741070ULL,
0x000000335800720cULL, 0x000fc40000701070ULL, 0x000000335800720cULL, 0x080fe400037c1070ULL,
0x000000333d00720cULL, 0x000fe40002fa1070ULL, 0x0000005b475b7219ULL, 0x040fe400000006ffULL,
0x0000003547357219ULL, 0x040fe400000006ffULL, 0x0000004547457219ULL, 0x000fe400000006ffULL,
0x000054100c0c7816ULL, 0x000fc4000000000fULL, 0xff80000027277808ULL, 0x000fe40000800000ULL,
0xff80000016167808ULL, 0x000fe40001800000ULL, 0xff80000028287808ULL, 0x000fe40002000000ULL,
0xff80000015157808ULL, 0x000fe40001000000ULL, 0xff8000002c2c7808ULL, 0x000fe40000000000ULL,
0xff80000014147808ULL, 0x000fc40003000000ULL, 0xff8000002b2b7808ULL, 0x000fe40002800000ULL,
0x000000085bff7212ULL, 0x080fe4000782c0ffULL, 0x0000000835ff7212ULL, 0x080fe4000786c0ffULL,
0x0000000845ff7212ULL, 0x000fe4000788c0ffULL, 0x0000000c59ff7212ULL, 0x080fe4000784c0ffULL,
0x0000000c5bff7212ULL, 0x000fc4000780c0ffULL, 0x0000000c35ff7212ULL, 0x080fe400078cc0ffULL,
0x0000000c45ff7212ULL, 0x000fe400078ac0ffULL, 0x000000334400720cULL, 0x080fe40001741470ULL,
0x000000335600720cULL, 0x0c0fe40000f21470ULL, 0x000000335600720cULL, 0x080fe40000701470ULL,
0x000000336400720cULL, 0x000fc40001f61470ULL, 0x000000336400720cULL, 0x080fe400037c1470ULL,
0x000000333e00720cULL, 0x0c0fe40002781470ULL, 0x000000333e00720cULL, 0x080fe40002fa1470ULL,
0x000000333d00720cULL, 0x080fe40001741070ULL, 0x000000335400720cULL, 0x0c0fe40000f21070ULL,
0x000000335400720cULL, 0x000fc40000701070ULL, 0x000000334800720cULL, 0x0c0fe40001f61070ULL,
0x000000334800720cULL, 0x080fe400037c1070ULL, 0x000000330e00720cULL, 0x0c0fe40002781070ULL,
0x000000330e00720cULL, 0x000fe40002fa1070ULL, 0xff80000029297808ULL, 0x000fe40000800000ULL,
0xff80000022227808ULL, 0x000fc40001800000ULL, 0xff8000001a1a7808ULL, 0x000fe40002000000ULL,
0xff80000012127808ULL, 0x000fe40001000000ULL, 0xff80000013137808ULL, 0x000fe40000000000ULL,
0xff80000018187808ULL, 0x000fe40003000000ULL, 0xff80000019197808ULL, 0x000fc40002800000ULL,
0x0000001b0400720bULL, 0x004fe40003f1e000ULL, 0x0000001e0500720bULL, 0x000fc40003f3e000ULL,
0x000000041b047208ULL, 0x000fe40004000000ULL, 0x000000051e057208ULL, 0x000fe40004800000ULL,
0x000000230400720bULL, 0x000fe40003f1e000ULL, 0x0000001c0500720bULL, 0x000fe40003f3e000ULL,
0x0000000423097208ULL, 0x000fe40004000000ULL, 0x000000051c047208ULL, 0x000fc40004800000ULL,
0x000000240900720bULL, 0x000fe40003f1e000ULL, 0x0000001d0400720bULL, 0x000fe40003f3e000ULL,
0x0000000924087208ULL, 0x000fe40004000000ULL, 0x000000041d057208ULL, 0x000fe40004800000ULL,
0x0000002d0800720bULL, 0x000fe40003f1e000ULL, 0x0000002e0500720bULL, 0x000fc40003f3e000ULL,
0x000000082d097208ULL, 0x000fe40004000000ULL, 0x000000052e057208ULL, 0x000fe40004800000ULL,
0x0000002a0900720bULL, 0x000fe40003f1e000ULL, 0x000000200500720bULL, 0x000fe40003f3e000ULL,
0x000000092a047208ULL, 0x000fe40004000000ULL, 0x0000000520087208ULL, 0x000fc40004800000ULL,
0x000000250400720bULL, 0x000fe40003f1e000ULL, 0x0000001f0800720bULL, 0x000fe40003f3e000ULL,
0x0000000425057208ULL, 0x000fe40004000000ULL, 0x000000081f087208ULL, 0x000fe40004800000ULL,
0x000000260500720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fc40003f3e000ULL,
0x0000000526047208ULL, 0x000fe40004000000ULL, 0x0000000821057208ULL, 0x000fe40004800000ULL,
0x000000310400720bULL, 0x000fe40003f1e000ULL, 0x000000300500720bULL, 0x000fe40003f3e000ULL,
0x0000000431047208ULL, 0x000fe40004000000ULL, 0x0000000530087208ULL, 0x000fc40004800000ULL,
0x0000002f0400720bULL, 0x000fe40003f1e000ULL, 0x000000170800720bULL, 0x000fe40003f3e000ULL,
0x000000042f047208ULL, 0x000fe40004000000ULL, 0x0000000817057208ULL, 0x000fe40004800000ULL,
0x000000270400720bULL, 0x000fe40003f1e000ULL, 0x000000160500720bULL, 0x000fc40003f3e000ULL,
0x0000000427097208ULL, 0x000fe40004000000ULL, 0x0000000516047208ULL, 0x000fe40004800000ULL,
0x000000280900720bULL, 0x000fe40003f1e000ULL, 0x000000150400720bULL, 0x000fe40003f3e000ULL,
0x0000000928097208ULL, 0x000fe40004000000ULL, 0x0000000415057208ULL, 0x000fc40004800000ULL,
0x0000002c0900720bULL, 0x000fe40003f1e000ULL, 0x000000140500720bULL, 0x000fe40003f3e000ULL,
0x000000092c047208ULL, 0x000fe40004000000ULL, 0x0000000514057208ULL, 0x000fe40004800000ULL,
0x0000002b0400720bULL, 0x000fe40003f1e000ULL, 0x000000120500720bULL, 0x000fc40003f3e000ULL,
0x000000042b047208ULL, 0x000fe40004000000ULL, 0x0000000512087208ULL, 0x000fe40004800000ULL,
0x000000290400720bULL, 0x000fe40003f1e000ULL, 0x000000130800720bULL, 0x000fe40003f3e000ULL,
0x0000000429057208ULL, 0x000fe40004000000ULL, 0x0000000813097208ULL, 0x000fc40004800000ULL,
0x000000220500720bULL, 0x000fe40003f1e000ULL, 0x000000180900720bULL, 0x000fe40003f3e000ULL,
0x0000000522057208ULL, 0x000fe40004000000ULL, 0x0000000918047208ULL, 0x000fe40004800000ULL,
0x0000001a0500720bULL, 0x000fe40003f1e000ULL, 0x000000190400720bULL, 0x000fc40003f3e000ULL,
0x000000051a0a7208ULL, 0x000fe40004000000ULL, 0x00000004190c7208ULL, 0x000fe20004800000ULL,
0x000017227f007947ULL, 0x000fec000b800000ULL, 0x0c401f000a047f89ULL, 0x0004e400000e0000ULL,
0x000000040a00720bULL, 0x008fc80003f1e000ULL, 0x0000000a040d7208ULL, 0x000fe20004000000ULL,
0x000017527f007947ULL, 0x000fea000b800000ULL, 0x0c401f000c047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007327f89ULL, 0x000e6200000e0000ULL,
0x000000040c00720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x010fe40003f3e000ULL,
0x0000000c04087208ULL, 0x000fe40004000000ULL, 0x0000000605097208ULL, 0x000fe20004800000ULL,
0x0c201f000d047f89ULL, 0x000ee200000e0000ULL, 0x000000320700720bULL, 0x002fc60003f1e000ULL,
0x0c201f0008057f89ULL, 0x000e6200000e0000ULL, 0x0000000732327208ULL, 0x000fc60004000000ULL,
0x0c201f00090a7f89ULL, 0x004ea800000e0000ULL, 0x0c201f0032337f89ULL, 0x0002a200000e0000ULL,
0x000000040d00720bULL, 0x008fe40003f1e000ULL, 0x000000050800720bULL, 0x002fe40003f3e000ULL,
0x0000000d04047208ULL, 0x000fe40004000000ULL, 0x0000000a0900720bULL, 0x004fc40003f5e000ULL,
0x0000000805057208ULL, 0x000fe40004800000ULL, 0x000000090a067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04347820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x00000004ff0c7e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010834ULL,
0x000000333200720bULL, 0x004fe20003f3e000ULL, 0x3fb8aa3b23237823ULL, 0x100fe40000010834ULL,
0x00000024000a7308ULL, 0x0023e20000000800ULL, 0x3fb8aa3b2d2d7823ULL, 0x000fc40000010834ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe40000010834ULL, 0x3fb8aa3b26077823ULL, 0x100fe40000010834ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010834ULL, 0x0000001b00087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b29247823ULL, 0x102fe40000010834ULL, 0x3fb8aa3b05297820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b25257823ULL, 0x000fc40000010834ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010829ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe40000010829ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe40000010829ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010829ULL, 0x0000002d002d7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b21217823ULL, 0x000fc40000010829ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe40000010834ULL,
0x3fb8aa3b31317823ULL, 0x100fe40000010834ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010829ULL,
0x0000001e00097308ULL, 0x000fe20000000800ULL, 0x000000082308723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b30307823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b27267823ULL, 0x000fe40000010834ULL,
0x3fb8aa3b17177823ULL, 0x000fc40000010829ULL, 0x0000001c001c7308ULL, 0x000e620000000800ULL,
0x0000000a2d0a723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b2f1b7823ULL, 0x100fe40000010834ULL,
0x3fb8aa3b14237823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b28287823ULL, 0x100fe40000010834ULL,
0x0000001d000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1a1a7823ULL, 0x000fe40000010834ULL,
0x3fb8aa3b12127823ULL, 0x000fc40000010829ULL, 0x3fb8aa3b13137823ULL, 0x000fe40000010829ULL,
0x3fb8aa3b22227823ULL, 0x000fe20000010834ULL, 0x0000002e002e7308ULL, 0x000ea20000000800ULL,
0x000000091c09723eULL, 0x002fce00000010ffULL, 0x0000000700357308ULL, 0x0003f00000000800ULL,
0x00000021001e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b077823ULL, 0x002fe20000010834ULL,
0x0000000b2e0b723eULL, 0x004fcc00000010ffULL, 0x00000020002b7308ULL, 0x0003f00000000800ULL,
0x0000002c00277308ULL, 0x000fe20000000800ULL, 0x3f8000000c20783eULL, 0x002fca00000010ffULL,
0x000000ffff217224ULL, 0x100fe400078e0020ULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x000000ffff2e7224ULL, 0x100fe400078e0020ULL, 0x000000ffff2f7224ULL, 0x100fe400078e0020ULL,
0x00000020080c723cULL, 0x000b6200000418ffULL, 0x000000ffff347224ULL, 0x000fe400078e0020ULL,
0x0000002500257308ULL, 0x000e680000000800ULL, 0x3fb8aa3b15217823ULL, 0x020fc80000010829ULL,
0x0000003100367308ULL, 0x000eb00000000800ULL, 0x0000001f002c7308ULL, 0x0007220000000800ULL,
0x0000002a2514723eULL, 0x002fce00000010ffULL, 0x00000030001d7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b161f7823ULL, 0x008fe20000010829ULL, 0x000000353616723eULL, 0x004fcc00000010ffULL,
0x00000017001c7308ULL, 0x0003e20000000800ULL, 0x0000002b2c15723eULL, 0x010fe400000010ffULL,
0x00000002ff2c7819ULL, 0x000fc80000011602ULL, 0x000000012c257810ULL, 0x000fe20007ffe0ffULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x0000001e1d17723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b181e7823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b19297823ULL, 0x000fe40000010829ULL,
0x000000082c2b7824ULL, 0x040fe400078e00ffULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x0000002e140c723cULL, 0x000b62000004180cULL, 0x000000082c317824ULL, 0x000fc400078e00ffULL,
0x000000082c2d7824ULL, 0x000fc800078e00ffULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x000000082c2e7824ULL, 0x020fca00078e00ffULL, 0xfffffff82e257812ULL, 0x000fe200078ee225ULL,
0x000000ffff2e7224ULL, 0x000fe200078e0020ULL, 0x0000001f001f7308ULL, 0x000ea20000000800ULL,
0x0000001b2618723eULL, 0x002fe400000010ffULL, 0x000000042c267810ULL, 0x000fc80007ffe0ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee226ULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x00000023002a7308ULL, 0x0002e20000000800ULL, 0x0000001c1f19723eULL, 0x004fc400000010ffULL,
0x000000022c1c7810ULL, 0x000fca0007ffe0ffULL, 0x0000001a001d7308ULL, 0x0005e20000000800ULL,
0x000000082c237824ULL, 0x002fca00078e00ffULL, 0xfffffff823237812ULL, 0x000fe400078ee21cULL,
0x000000212a1b723eULL, 0x008fe200000010ffULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x00000028271a723eULL, 0x004fe200000010ffULL, 0x000000082c287824ULL, 0x040fe200078e00ffULL,
0x000000082c2a7810ULL, 0x040fe40007ffe0ffULL, 0x000000052c1c7810ULL, 0x040fe40007ffe0ffULL,
0x000000032c217810ULL, 0x000fe20007ffe0ffULL, 0x0000002e180c723cULL, 0x000b62000004180cULL,
0x0000000700077308ULL, 0x000fe20000000800ULL, 0x000000082a357824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fc400078ee21cULL, 0xfffffff828277812ULL, 0x000fe200078ee221ULL,
0x000000082c217824ULL, 0x040fe200078e00ffULL, 0x000000062c287810ULL, 0x040fe20007ffe0ffULL,
0x000000082c2f7824ULL, 0x020fe200078e00ffULL, 0x0000002400247308ULL, 0x000e640000000800ULL,
0xfffffff821217812ULL, 0x000fe400078ee22cULL, 0xfffffff82f2f7812ULL, 0x000fc800078ee228ULL,
0x0000001200127308ULL, 0x000ff00000000800ULL, 0x0000001300137308ULL, 0x000ea20000000800ULL,
0x00000007241c723eULL, 0x002fe400000010ffULL, 0x0000003233077208ULL, 0x000fca0004800000ULL,
0x0000001e001f7308ULL, 0x0003f00000000800ULL, 0x0000002900267308ULL, 0x0007220000000800ULL,
0xffffffff2c1e7810ULL, 0x002fc80007ffe0ffULL, 0xfffffff831317812ULL, 0x000fe400078ee21eULL,
0x000000221d1e723eULL, 0x000fe400000010ffULL, 0xfffffff835297812ULL, 0x008fe200078ee22aULL,
0x000000ffff357224ULL, 0x000fe200078e0020ULL, 0x00000012131d723eULL, 0x004fe400000010ffULL,
0x0001100000227811ULL, 0x000fe400078e58ffULL, 0x0000000c11127812ULL, 0x000fc400078ec0ffULL,
0x0000001f261f723eULL, 0x010fe200000010ffULL, 0x0000001021217824ULL, 0x100fe400078e0222ULL,
0x0000001025257824ULL, 0x100fe400078e0222ULL, 0x0000001023237824ULL, 0x100fe400078e0222ULL,
0x000000341c0c723cULL, 0x000f62000004180cULL, 0x0000001027277824ULL, 0x100fe400078e0222ULL,
0x000000102b2b7824ULL, 0x000fc400078e0222ULL, 0x0000000121217824ULL, 0x000fe400078e0212ULL,
0x000000102d2d7824ULL, 0x100fe400078e0222ULL, 0x0000000112257824ULL, 0x040fe200078e0225ULL,
0x0000000821007388ULL, 0x0003e20000000800ULL, 0x000000102f2f7824ULL, 0x100fe400078e0222ULL,
0x0000000112237824ULL, 0x000fe200078e0223ULL, 0x0000000a25007388ULL, 0x0003e20000000800ULL,
0x0000001031317824ULL, 0x000fc400078e0222ULL, 0x0000000112277824ULL, 0x040fe200078e0227ULL,
0x0000001423007388ULL, 0x0003e20000000800ULL, 0x0000001029297824ULL, 0x000fe400078e0222ULL,
0x00000001122b7824ULL, 0x040fe200078e022bULL, 0x0000001627007388ULL, 0x0003e20000000800ULL,
0x00000001122d7824ULL, 0x040fe400078e022dULL, 0x00000001122f7824ULL, 0x040fe200078e022fULL,
0x000000182b007388ULL, 0x0003e20000000800ULL, 0x0000000112317824ULL, 0x000fc400078e0231ULL,
0x0000000112127824ULL, 0x000fe200078e0229ULL, 0x0000001a2d007388ULL, 0x0003e20000000800ULL,
0x000000ffff0d7224ULL, 0x020fc600078e000eULL, 0x0000001c2f007388ULL, 0x0003e80000000800ULL,
0x0000001e31007388ULL, 0x0003e80000000800ULL, 0x0000000912007388ULL, 0x0003e80000000800ULL,
0x0004000b25007388ULL, 0x0003e80000000800ULL, 0x0004001523007388ULL, 0x0003e80000000800ULL,
0x0004001727007388ULL, 0x0003e80000000800ULL, 0x000400192b007388ULL, 0x0003e80000000800ULL,
0x0004001b2d007388ULL, 0x0003e80000000800ULL, 0x0004001d2f007388ULL, 0x0003e80000000800ULL,
0x0004001f31007388ULL, 0x0003e80000000800ULL, 0x0170000410008388ULL, 0x0003e80000000c00ULL,
0x0172000c10008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000007bff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008007bff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010007bff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000016e6e7810ULL, 0x000fe20007ffe0ffULL, 0x000018007bff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff697224ULL, 0x000fc400078e0071ULL, 0x0000007a6e00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff9af000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff137807ULL, 0x008fe20004000000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x000187d000387802ULL, 0x000fc40000000f00ULL,
0x00000f3000007944ULL, 0x002fea0003c00000ULL, 0xfffe9ea000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x0001882000387802ULL, 0x000fc40000000f00ULL, 0x00000ee000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e0013ULL, 0xfffe9ed000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0012ULL, 0x0001889000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x00000e2000007944ULL, 0x002fea0003c00000ULL, 0xfffe9f9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0012ULL, 0x000188f000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x00000dc000007944ULL, 0x002fea0003c00000ULL, 0xfffea09000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0006ULL, 0x0001896000397802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e0009ULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x00000d5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0013ULL, 0xfffea47000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0006ULL, 0x000189d000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x00000ce000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e0013ULL,
0xfffea43000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x008fe20004000000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x00018a3000387802ULL, 0x000fc40000000f00ULL,
0x00000cd000007944ULL, 0x002fea0003c00000ULL, 0xfffed22000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x00018a8000387802ULL, 0x000fc40000000f00ULL, 0x00000c8000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff067224ULL, 0x000fe200078e0013ULL, 0xfffed26000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e003eULL, 0x00018af000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x00000bc000007944ULL, 0x002fea0003c00000ULL, 0xfffed32000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e003eULL, 0x00018b5000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x00000b6000007944ULL, 0x002fea0003c00000ULL, 0xfffed42000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0003ULL, 0x00018bc000397802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e0004ULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x00000af000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0013ULL, 0xfffed81000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0003ULL, 0x00018c3000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x00000a8000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e0013ULL,
0xfffed7d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x008fe20004000000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x00018c9000387802ULL, 0x000fc40000000f00ULL,
0x00000a7000007944ULL, 0x002fea0003c00000ULL, 0xffff058000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x00018ce000387802ULL, 0x000fc40000000f00ULL, 0x00000a2000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0013ULL, 0xffff05b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0018ULL, 0x00018d5000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000096000007944ULL, 0x002fea0003c00000ULL, 0xffff068000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0018ULL, 0x00018db000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000090000007944ULL, 0x002fea0003c00000ULL, 0xffff078000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e000eULL, 0x00018e2000397802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e0015ULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000089000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0013ULL, 0xffff0b8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e000eULL, 0x00018e9000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000082000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e0013ULL,
0xffff0b4000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x004fe20004000000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x00018ef000387802ULL, 0x000fc40000000f00ULL,
0x0000081000007944ULL, 0x008fea0003c00000ULL, 0xffff382000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x00018f4000387802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0013ULL, 0xffff386000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0008ULL, 0x00018fb000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x0000070000007944ULL, 0x008fea0003c00000ULL, 0xffff392000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0008ULL, 0x0001901000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x00afea0003c00000ULL, 0xffff3a2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0003ULL, 0x0001908000397802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e0004ULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0013ULL, 0xffff3e5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff387224ULL, 0x000fe200078e0003ULL, 0x000190f000397802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e0013ULL,
0xffff3e1000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0b7424ULL, 0x000fe200078e00ffULL,
0x0001916000087802ULL, 0x000fe20000000f00ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0033ULL, 0xffffe88000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0a7224ULL, 0x006fe200078e000cULL, 0x000191e000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x000000330c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0006ULL,
0x0001926000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000c330c7208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x000000330600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0007ULL,
0x000192e000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000633067208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000330700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e000dULL,
0x0001936000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000733327208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000330d00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e000cULL,
0x000193e000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000d33047208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x000000330c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0006ULL,
0x0001946000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000c33057208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000330600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0032ULL,
0x000194e000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000633067208ULL, 0x000fe20004000000ULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe67000007947ULL, 0x000fea000383ffffULL, 0x0180000007007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000700008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000007027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe699002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000000e00007348ULL, 0x000fe80003800000ULL, 0x0c00000b0a337389ULL, 0x0002a200000e0033ULL,
0xfffe695008007950ULL, 0x000fea0003c3ffffULL, 0x0000003a00007348ULL, 0x000fe80003800000ULL,
0x0000001338137389ULL, 0x0002a400000e003bULL, 0x000000ffff387224ULL, 0x002fc400078e0039ULL,
0x00000000ff397424ULL, 0x000fc800078e00ffULL, 0xfffe690038007950ULL, 0x000fea0003c3ffffULL,
0x000000011300780cULL, 0x000fe20003f45070ULL, 0x0000003900007348ULL, 0x000fd80003800000ULL,
0x0000000000137806ULL, 0x000fc800050e0100ULL, 0x0000003913137212ULL, 0x000fe200078ec0ffULL,
0x00000000ff397424ULL, 0x000fc800078e00ffULL, 0xfffe68a038007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x0000000000000350ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d48ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e08ULL, 0x00000000000007d0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015d8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015e8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001678ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000000167cULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000019800ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001b080ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001b0d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001b450ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001678ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000019a08ULL, 0x0000000000019a08ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001b080ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001b450ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_80_cubin_len = 111920;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
