/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000016c90ULL, 0x0000000000016810ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000014fc0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000015130ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000015170ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x00000000000151b0ULL,
0x0000000000000150ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000015300ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00014fc000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x0052ac0400288080ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80809a0828808081ULL,
0x9e082880809d0828ULL, 0x2880809f08288080ULL, 0x80a508288080a408ULL, 0x08288080a8082880ULL,
0x8080af08288080a9ULL, 0xe908288080b30828ULL, 0x288080ee08288080ULL, 0x808608288080f008ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080869200ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x00014fc000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x9a08288080930828ULL, 0x2880809d08288080ULL,
0x809f082880809e08ULL, 0x08288080a4082880ULL, 0x8080a808288080a5ULL, 0xb308288080af0828ULL,
0x288080e908288080ULL, 0x80f008288080ee08ULL, 0x1628808088082880ULL, 0x0000031028808280ULL,
0x8892000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000012000000000ULL,
0x0001513000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000084ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x9308288080880828ULL, 0x2880809a08288080ULL, 0x809e082880809d08ULL,
0x082880809f082880ULL, 0x8080a808288080a5ULL, 0xb308288080af0828ULL, 0x288080e908288080ULL,
0x80f008288080ee08ULL, 0x16288080a4082880ULL, 0x0000031028808280ULL, 0xa492000000000000ULL,
0x0000002200288080ULL, 0x0000001cffffffffULL, 0x000001d800000000ULL, 0x0001517000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x9308288080880828ULL, 0x2880809a08288080ULL, 0x809e082880809d08ULL, 0x082880809f082880ULL,
0x8080a508288080a4ULL, 0xb308288080af0828ULL, 0x288080e908288080ULL, 0x80f008288080ee08ULL,
0x16288080a8082880ULL, 0x0000031028808280ULL, 0xa892000000000000ULL, 0x0000002200288080ULL,
0x0000002cffffffffULL, 0x0000029000000000ULL, 0x000151b000000000ULL, 0x0000015000000000ULL,
0x0000180400000000ULL, 0x80a4288080a80900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL,
0x00081204000000afULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x0000000e00080a04ULL, 0x0058190300580160ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x001c310400ff1b03ULL, 0x0001373000000020ULL, 0x0001398000013970ULL, 0x00013b0000013af0ULL,
0x0160290400013b10ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500001d0500001dULL, 0x0500001d0500001dULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000010001602804ULL, 0x00001ab000000120ULL, 0x00001bf000001b30ULL,
0x00001ff000001c20ULL, 0x0000208000002020ULL, 0x000043f0000020e0ULL, 0x0000455000004480ULL,
0x0000499000004670ULL, 0x00004a10000049b0ULL, 0x00006ac000004a70ULL, 0x00006c2000006b50ULL,
0x0000705000006d40ULL, 0x000070d000007070ULL, 0x0000915000007130ULL, 0x000092b0000091e0ULL,
0x000096f0000093d0ULL, 0x0000977000009710ULL, 0x0000b1b0000097d0ULL, 0x0000d7a00000b1c0ULL,
0x0000e0600000d880ULL, 0x000133900000e090ULL, 0x000133d0000133c0ULL, 0x00013400000133e0ULL,
0x0001344000013420ULL, 0x00013ae000013450ULL, 0x00013b5000013b40ULL, 0x0001427000013b60ULL,
0x00014330000142c0ULL, 0x00014410000143a0ULL, 0x000144d000014480ULL, 0x0001458000014520ULL,
0x00014650000145f0ULL, 0x00014710000146c0ULL, 0x000147c000014760ULL, 0x0001489000014830ULL,
0x0001495000014900ULL, 0x00014a00000149a0ULL, 0x00014ad000014a70ULL, 0x00014ba000014b40ULL,
0x00014c5000014c00ULL, 0x00014cf000014ca0ULL, 0x00014d9000014d40ULL, 0x00014e5000014de0ULL,
0x00014f3000014ed0ULL, 0x04c0390400014f90ULL, 0x000000ff00000220ULL, 0x003f01000000f600ULL,
0x0000000b00000290ULL, 0x003f01200000f608ULL, 0x0000000b000002e0ULL, 0x003f01200000f688ULL,
0x0000000b00000370ULL, 0x003f01200000f6a8ULL, 0x0000000b000003b0ULL, 0x003f01200000f6c8ULL,
0x000000ff00000460ULL, 0x003f01070000f600ULL, 0x0000004000000630ULL, 0x003f01020000f68cULL,
0x0000004000000740ULL, 0x003f01010000f688ULL, 0x000000ff00000d60ULL, 0x0004010700000000ULL,
0x000000ff00000e20ULL, 0x0004010100000000ULL, 0x0000003700000e80ULL, 0x003f010100000020ULL,
0x0000006700000fc0ULL, 0x003f010500000004ULL, 0x0000003700001030ULL, 0x003f010500000024ULL,
0x00000037000010b0ULL, 0x003f010500000024ULL, 0x0000002f000017a0ULL, 0x003f010700000000ULL,
0x0000002f00001870ULL, 0x003f010100000000ULL, 0x0000003100001880ULL, 0x003f010500000004ULL,
0x00000047000018f0ULL, 0x003f01010000f608ULL, 0x0000004700001910ULL, 0x003f01050000f60cULL,
0x00000026000019c0ULL, 0x003f01050000f60cULL, 0x0000003100001ee0ULL, 0x003f010500000004ULL,
0x0000003100001f60ULL, 0x003f010500000004ULL, 0x00000037000039b0ULL, 0x003f010100000020ULL,
0x0000005600003a30ULL, 0x003f01010000f688ULL, 0x0000006700003a80ULL, 0x003f010500000004ULL,
0x0000003700003ad0ULL, 0x003f010500000024ULL, 0x0000003700003b50ULL, 0x003f010500000024ULL,
0x0000006200004120ULL, 0x003f010700000000ULL, 0x00000062000041a0ULL, 0x003f010100000000ULL,
0x00000061000041b0ULL, 0x003f010500000004ULL, 0x0000004700004220ULL, 0x003f01010000f628ULL,
0x0000004700004240ULL, 0x003f01050000f62cULL, 0x0000004700004320ULL, 0x003f01050000f62cULL,
0x0000002400004860ULL, 0x003f01050000f6acULL, 0x00000024000048e0ULL, 0x003f01050000f6acULL,
0x00000037000061d0ULL, 0x003f010100000020ULL, 0x0000005600006240ULL, 0x003f01010000f690ULL,
0x0000006700006280ULL, 0x003f010500000004ULL, 0x00000037000062d0ULL, 0x003f010500000024ULL,
0x0000003700006350ULL, 0x003f010500000024ULL, 0x0000006100006800ULL, 0x003f010700000000ULL,
0x0000006100006880ULL, 0x003f010100000000ULL, 0x0000006200006890ULL, 0x003f010500000004ULL,
0x0000004700006900ULL, 0x003f01010000f648ULL, 0x0000004700006920ULL, 0x003f01050000f64cULL,
0x00000047000069f0ULL, 0x003f01050000f64cULL, 0x0000000000006f20ULL, 0x003f01050000f6acULL,
0x0000006200006fa0ULL, 0x003f010500000004ULL, 0x0000003700008840ULL, 0x003f010100000020ULL,
0x00000056000088b0ULL, 0x003f01010000f698ULL, 0x0000006700008900ULL, 0x003f010500000004ULL,
0x0000003700008950ULL, 0x003f010500000024ULL, 0x00000037000089d0ULL, 0x003f010500000024ULL,
0x0000006200008ed0ULL, 0x003f010700000000ULL, 0x0000006200008f50ULL, 0x003f010100000000ULL,
0x0000006100008f60ULL, 0x003f010500000004ULL, 0x0000004700008fd0ULL, 0x003f01010000f668ULL,
0x0000004700008ff0ULL, 0x003f01050000f66cULL, 0x0000004700009080ULL, 0x003f01050000f66cULL,
0x00000025000095c0ULL, 0x003f01050000f6acULL, 0x0000006100009640ULL, 0x003f010500000004ULL,
0x000000370000ae50ULL, 0x003f010100000020ULL, 0x000000560000aeb0ULL, 0x003f01010000f6a0ULL,
0x000000ff0000edd0ULL, 0x003f01010000f600ULL, 0x000000ff0000fbd0ULL, 0x003f01050000f604ULL,
0x000000ff0000fc70ULL, 0x003f01050000f604ULL, 0x000000ff0000fe80ULL, 0x003f01010000f600ULL,
0x000000ff0000fe90ULL, 0x003f01050000f604ULL, 0x000000ff0000ff20ULL, 0x003f01050000f604ULL,
0x0000003700012870ULL, 0x003f010100000000ULL, 0x00000037000128b0ULL, 0x003f010500000004ULL,
0x0000003700012c90ULL, 0x003f010500000004ULL, 0x00000039000140d0ULL, 0x003f010100000000ULL,
0x0000003900014130ULL, 0x003f010100000008ULL, 0x0000003900014190ULL, 0x003f010100000010ULL,
0x0000003900014200ULL, 0x003f010100000018ULL, 0x00141c0400053803ULL, 0x0000ece00000ea90ULL,
0x000100300000ff80ULL, 0x0000040100014240ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL,
0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000334ULL,
0x0000001200000002ULL, 0x000000000000027cULL, 0x0000001200000002ULL, 0x00000000000001c4ULL,
0x0000001200000002ULL, 0x000000000000010cULL, 0x0000001200000002ULL, 0x0000000000000044ULL,
0x0000001200000002ULL, 0x000000000000030eULL, 0x0000001200000002ULL, 0x0000000000000256ULL,
0x0000001200000002ULL, 0x000000000000019eULL, 0x0000001200000002ULL, 0x00000000000000e9ULL,
0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00000000000e7806ULL, 0x000fe200038e0000ULL, 0x00005800ff2e7624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000000e00047300ULL, 0x000ee200000e0000ULL, 0x000000082e067824ULL, 0x000fe400078e00ffULL,
0x0000000000007919ULL, 0x000ea20000002200ULL, 0x00000100ff177424ULL, 0x000fc600078e00ffULL,
0x00000000003b7919ULL, 0x000f220000002600ULL, 0x0000000e000e7309ULL, 0x000f660000000000ULL,
0x0000000000337919ULL, 0x000ee80000002700ULL, 0x0000000000427919ULL, 0x000f620000000000ULL,
0x00000005ff367819ULL, 0x002fc6000001160bULL, 0x0000000000057919ULL, 0x000e680000000000ULL,
0x00001fff36367589ULL, 0x000fe200000e0000ULL, 0x000000010d007824ULL, 0x004fc600078e0200ULL,
0x00001fff0d0d7589ULL, 0x000ea200000e0000ULL, 0x00000080000b7824ULL, 0x000fe400078e020bULL,
0x000000083b007824ULL, 0x010fc600078e00ffULL, 0x000000ff0b00720cULL, 0x040fe20003f45270ULL,
0x0000003306007224ULL, 0x008fe200078e0200ULL, 0x0000000f0b00780cULL, 0x040fe20003f64070ULL,
0x00000010420a7824ULL, 0x020fe200078e00ffULL, 0x000000030b00780cULL, 0x040fe40003f24070ULL,
0x0000007f0b00780cULL, 0x000fe40003f84070ULL, 0x00000004ff0f7819ULL, 0x000fe40000011642ULL,
0x000000050400720cULL, 0x002fc40003f02070ULL, 0x000000f00a157812ULL, 0x000fe200078ec0ffULL,
0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL,
0x000000040d067824ULL, 0x004fe400078e0236ULL, 0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0x000000010b00780cULL, 0x000fe20003f44070ULL,
0x0000000206087824ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff05b424ULL, 0x000fe400078e00ffULL,
0x0000000108117824ULL, 0x040fe200078e020fULL, 0x0000000808097817ULL, 0x000fe20007800000ULL,
0x3fffff60ff069424ULL, 0x000fe200078e00ffULL, 0x00f608040b00b388ULL, 0x0005e20000008a00ULL,
0x7fffff60ff079424ULL, 0x000fe200078e00ffULL, 0x0000000711137812ULL, 0x000fe200078ec0ffULL,
0x0000000100027824ULL, 0x002fe400078e0211ULL, 0x0000000109007824ULL, 0x000fe200078e0a08ULL,
0x00f688060b009388ULL, 0x000fe20000008a00ULL, 0xff317217ff0cc424ULL, 0x000fc400078e00ffULL,
0x3fffffc0ff08a424ULL, 0x000fe200078e00ffULL, 0x000000000f00720cULL, 0x000fe20003f66070ULL,
0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL, 0x00f4000c0b00c388ULL, 0x0003e20000004800ULL,
0x3fffff80ff049424ULL, 0x004fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x00005c0002027625ULL, 0x000fc600078e0017ULL, 0x00f6a8040b009388ULL, 0x0005e20000008a00ULL,
0x000000ffff007224ULL, 0x000fe200078e0a0eULL, 0x0000000f130c7812ULL, 0x002fe200078e7842ULL,
0x00000004ff0f7424ULL, 0x000fe200078e00ffULL, 0x00f6c8080b00a388ULL, 0x0003e80000008a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001502027210ULL, 0x000fe20007f9e0ffULL,
0x00000010110c7824ULL, 0x000fc400078e020cULL, 0x0000620033047625ULL, 0x004fc800078e000fULL,
0x000000ffff037224ULL, 0x000fe400020e0603ULL, 0x000000100c077824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604347981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000004ff357e24ULL, 0x008fe2000f8e00ffULL,
0x0000003f34037810ULL, 0x006fc40007ffe0ffULL, 0x000000ff34027810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff037819ULL, 0x000fe40000011603ULL, 0x00000008ff027819ULL, 0x000fca0000011602ULL,
0x0000e78000008947ULL, 0x000fea0003800000ULL, 0x00000002ff417819ULL, 0x000fe20000011636ULL,
0x0000000836407824ULL, 0x000fe400078e00ffULL, 0x00000003ff077424ULL, 0x000fe200078e00ffULL,
0x03ffffff41007812ULL, 0x000fca00078ec0ffULL, 0x0000000435097824ULL, 0x000fca00078e0200ULL,
0x000000030900720cULL, 0x000fda0003f06070ULL, 0x0000000233008824ULL, 0x000fe400078e00ffULL,
0x00006400ff058624ULL, 0x000fc800078e00ffULL, 0x0000640000048624ULL, 0x000fe400078e0205ULL,
0xffffffffff007424ULL, 0x000fe400078e00ffULL, 0x0000000109048824ULL, 0x000fe200078e0204ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c0740ff738cULL, 0x0003e20000000000ULL,
0x0000600004048625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000604008981ULL, 0x0004e2000c1e1900ULL, 0x00000003ff087424ULL, 0x000fe200078e00ffULL,
0x0000000309067812ULL, 0x000fe200078ec0ffULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x00000001363d7812ULL, 0x000fe200078ec0ffULL, 0x000003000f3f7a24ULL, 0x000fe200078e0a08ULL,
0x000000030600780cULL, 0x000fc40003f05270ULL, 0x00000001ff487819ULL, 0x000fe20000011636ULL,
0x000000403b3b7824ULL, 0x000fe200078e00ffULL, 0x000000013f467807ULL, 0x000fe20004000000ULL,
0x00f6880040ff7f8cULL, 0x0009e8000c80043fULL, 0x0000000109467824ULL, 0x000fca00078e0246ULL,
0x000000034600720cULL, 0x000fe40003f06070ULL, 0x00000003ff087819ULL, 0x000fd60000011642ULL,
0x0000000233068824ULL, 0x000fe400078e00ffULL, 0x00006400ff078624ULL, 0x002fc800078e00ffULL,
0x0000640006078624ULL, 0x000fe200078e0207ULL, 0x00000004080d7810ULL, 0x000fe20007ffe0ffULL,
0x000000103d067824ULL, 0x000fe400078e00ffULL, 0x0000000107048824ULL, 0x004fc800078e0246ULL,
0x0000600004048625ULL, 0x000fc800078e000fULL, 0x00000001060f7824ULL, 0x000fe200078e020dULL,
0x00000006043e8981ULL, 0x000362000c1e1900ULL, 0x0000000135077810ULL, 0x000fe20007ffe0ffULL,
0x00000020483c7824ULL, 0x000fe200078e00ffULL, 0x00000008080e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000106097824ULL, 0x000fe200078e0208ULL, 0x000000020700720cULL, 0x000fe20003f06070ULL,
0x00002000483a7824ULL, 0x000fe200078e00ffULL, 0x0000000c08127810ULL, 0x000fe20007ffe0ffULL,
0x00000008090c7824ULL, 0x040fe200078e00ffULL, 0x00000042090b7212ULL, 0x080fe200078e3cffULL,
0x000000080f057824ULL, 0x042fe200078e00ffULL, 0x000000420f047212ULL, 0x080fe200078e3cffULL,
0x0000000106117824ULL, 0x040fe200078e020eULL, 0x00000000480473c2ULL, 0x000e6200000e0000ULL,
0x0000000106157824ULL, 0x000fe200078e0212ULL, 0xfffffff805077812ULL, 0x000fe200078ee204ULL,
0x0000010035047824ULL, 0x000fe200078e023cULL, 0x0000004211107212ULL, 0x0c0fe200078e3cffULL,
0x0000000811197824ULL, 0x000fe200078e00ffULL, 0x0000004215147212ULL, 0x000fe200078e3cffULL,
0xff317217ff397424ULL, 0x000fe200078e00ffULL, 0x0000000434057217ULL, 0x000fe20007800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0xfffffff80c0b7812ULL, 0x000fc400078ee20bULL,
0x0000b0003a0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000105057824ULL, 0x100fe200078e0a04ULL,
0x000000203b047812ULL, 0x000fe400078ef804ULL, 0x0000f6a848377811ULL, 0x000fe200078e18ffULL,
0x000000100b0b7824ULL, 0x000fe200078e020cULL, 0x0000002005057807ULL, 0x000fe20000000000ULL,
0x0000000104097824ULL, 0x040fe400078e0209ULL, 0x00000001040f7824ULL, 0x040fe200078e020fULL,
0x0000000605057217ULL, 0x000fe20007800000ULL, 0x0000000104137824ULL, 0x040fe200078e0211ULL,
0x0000f6a804047891ULL, 0x002fe2000f8e203fULL, 0x0000000104177824ULL, 0x000fc400078e0215ULL,
0x0000000815117824ULL, 0x000fe200078e00ffULL, 0xfffffff819157812ULL, 0x000fe200078ee210ULL,
0x0000000105057824ULL, 0x000fc600078e0a06ULL, 0xfffffff811197812ULL, 0x000fe200078ee214ULL,
0x0000001007117824ULL, 0x100fe200078e020cULL, 0x000000050d00720cULL, 0x080fe20003f26070ULL,
0x0000001015157824ULL, 0x100fe200078e020cULL, 0x000000050800720cULL, 0x080fe20003f46070ULL,
0x0000001019197824ULL, 0x000fe200078e020cULL, 0x000000050e00720cULL, 0x000fe20003f06070ULL,
0x0000580000007a24ULL, 0x008fc800078e02ffULL, 0x0000004000007824ULL, 0x000fca00078e00ffULL,
0x0000000900097210ULL, 0x040fe40007f7e0ffULL, 0x0000000f000f7210ULL, 0x040fe40007f9e0ffULL,
0x0000001300137210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff047224ULL, 0x000fe200018e06ffULL,
0x00005e0009107a11ULL, 0x000fc600078638ffULL, 0x000000ffff067224ULL, 0x000fe200028e06ffULL,
0x00005f00090d7a11ULL, 0x000fe200018f3c04ULL, 0x000000ffff047224ULL, 0x000fe200020e06ffULL,
0x00005e000f087a11ULL, 0x040fe400078638ffULL, 0x0000001700007210ULL, 0x000fe40007fbe0ffULL,
0x00005f000f097a11ULL, 0x000fe400018f3c04ULL, 0x00005e00130c7a11ULL, 0x000fe200078838ffULL,
0x000000ffff077224ULL, 0x000fe200028e06ffULL, 0x000000700a0f7812ULL, 0x000fc400078ec0ffULL,
0x00005f0013067a11ULL, 0x000fe400020f3c06ULL, 0x000000100f047210ULL, 0x000fe40007fbe0ffULL,
0x0000000f08087210ULL, 0x000fe40007f9e0ffULL, 0x00005e00000e7a11ULL, 0x000fe400078c38ffULL,
0x000000051200720cULL, 0x000fe20003f66070ULL, 0x000000ffff057224ULL, 0x000fe200028e060dULL,
0x0000000f0c0c7210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe200020e0609ULL,
0x00005f0000007a11ULL, 0x000fe200030f3c07ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000f0e0e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e0606ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e2000d101c46ULL,
0x0000000000067805ULL, 0x000fc4000001ff00ULL, 0x000000ffff0f7224ULL, 0x000fe200020e0600ULL,
0x0000000008117faeULL, 0x0005e8000c901c46ULL, 0x000000000c157faeULL, 0x0007e2000c101c46ULL,
0x000000023500720cULL, 0x000fc60003f06070ULL, 0x000000000e197faeULL, 0x0009e2000d901c46ULL,
0x0000000000047805ULL, 0x002fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000087805ULL, 0x004fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x00000000000c7805ULL, 0x008fe2000001ff00ULL, 0x00000000000e7805ULL, 0x010fc4000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff687f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200037247f8cULL, 0x0004e2000c80043fULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000002037677810ULL, 0x000fe20007ffe0ffULL,
0x00009fe000000947ULL, 0x000fea0003800000ULL, 0x0000000233437824ULL, 0x004fe400078e00ffULL,
0x00006400ff007624ULL, 0x000fc400078e00ffULL, 0xff317217ff397424ULL, 0x000fe400078e00ffULL,
0x0000640043437624ULL, 0x000fe400078e0200ULL, 0x000000ffff6b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x0000010035277824ULL, 0x000fca00078e00ffULL,
0x000000342700720cULL, 0x000fda0003f06070ULL, 0x00009f1000000947ULL, 0x006fea0003800000ULL,
0x0000040067007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6c7224ULL, 0x000fe400078e0046ULL, 0x000000ffff447224ULL, 0x000fe200078e006bULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000240037007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x0000240037247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000346007812ULL, 0x000fe200078ec0ffULL, 0x000058003e267a24ULL, 0x020fe200078e02ffULL,
0x00000003ff317819ULL, 0x000fe20000011642ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x000000030000780cULL, 0x000fc80003f05270ULL, 0x000000013f257807ULL, 0x000fca0004000000ULL,
0x0000000146467824ULL, 0x000fca00078e0225ULL, 0x000000034600720cULL, 0x000fe20003f06070ULL,
0x0000001036007824ULL, 0x000fe200078e00ffULL, 0x0000000431337810ULL, 0x000fe20007ffe0ffULL,
0x0000010035557824ULL, 0x000fe200078e00ffULL, 0x00000001ff487819ULL, 0x000fe40000011636ULL,
0x0000001000287812ULL, 0x000fce00078ec0ffULL, 0x0000000143248824ULL, 0x000fe400078e0246ULL,
0x00000004ff258424ULL, 0x000fe400078e00ffULL, 0x00000001334b7824ULL, 0x000fe400078e0228ULL,
0x0000600024248625ULL, 0x000fc800078e0025ULL, 0x0000002048007824ULL, 0x000fe200078e0255ULL,
0x00000006243e8981ULL, 0x000562000c1e1900ULL, 0x000000424b4c7212ULL, 0x000fe200078e3cffULL,
0x0000000131497824ULL, 0x140fe200078e0228ULL, 0x0000000831477810ULL, 0x000fe20007ffe0ffULL,
0x0000004026267824ULL, 0x000fe200078e00ffULL, 0x0000004000007810ULL, 0x000fe20007ffe0ffULL,
0x0000000849297824ULL, 0x000fe200078e00ffULL, 0x0000000135277810ULL, 0x000fe20007ffe0ffULL,
0x00000001474d7824ULL, 0x100fe200078e0228ULL, 0x0000000c31537810ULL, 0x000fe20007ffe0ffULL,
0x000000084b257824ULL, 0x004fe200078e00ffULL, 0x000000022700720cULL, 0x000fe20003f06070ULL,
0x000000084d277824ULL, 0x000fe200078e00ffULL, 0x00000042494a7212ULL, 0x000fe200078e3cffULL,
0x00000001534f7824ULL, 0x000fe200078e0228ULL, 0xfffffff8254c7812ULL, 0x000fe200078ee24cULL,
0x000010006b247824ULL, 0x000fe200078e00ffULL, 0x0000000034257217ULL, 0x000fe20007800000ULL,
0x0000001042517824ULL, 0x000fe200078e00ffULL, 0x000000424d4e7212ULL, 0x000fe200078e3cffULL,
0x000004d000007945ULL, 0x000fe20003800000ULL, 0xfffffff8294a7812ULL, 0x000fe200078ee24aULL,
0x0000000125257824ULL, 0x100fe200078e0a00ULL, 0x000000203b007812ULL, 0x000fe200078ef800ULL,
0x000000084f297824ULL, 0x000fe200078e00ffULL, 0xfffffff8274e7812ULL, 0x000fc400078ee24eULL,
0x000000424f507212ULL, 0x000fe200078e3cffULL, 0x0000000100277824ULL, 0x040fe200078e0249ULL,
0x0000002025257807ULL, 0x000fe20000000000ULL, 0x00000001002b7824ULL, 0x040fe200078e024dULL,
0xfffffff829507812ULL, 0x000fe200078ee250ULL, 0x0000000100297824ULL, 0x000fe200078e024bULL,
0x00000027262f7210ULL, 0x000fe20007f5e0ffULL, 0x0000000100277824ULL, 0x000fe200078e024fULL,
0x0000002825257217ULL, 0x000fe40007800000ULL, 0x0000002926297210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff007224ULL, 0x000fe200010e06ffULL, 0x00005e002f2d7a11ULL, 0x000fc400078438ffULL,
0x0000002b262b7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200018e06ffULL,
0x00005f002f2f7a11ULL, 0x000fe200010f3c00ULL, 0x0000000125007824ULL, 0x000fe200078e0a28ULL,
0x00005e00292c7a11ULL, 0x040fe400078438ffULL, 0x0000100024257812ULL, 0x000fe200078e0cffULL,
0x000000ffff247224ULL, 0x000fe200020e06ffULL, 0x00005f00292e7a11ULL, 0x000fe400010f3c2eULL,
0x0000002726277210ULL, 0x000fe20007f1e0ffULL, 0x0000200048257824ULL, 0x000fe200078e0225ULL,
0x000000003100720cULL, 0x000fc40003f46070ULL, 0x00005e002b287a11ULL, 0x000fe200078638ffULL,
0x000000ffff267224ULL, 0x000fe200000e06ffULL, 0x0000007051317812ULL, 0x000fe400078ec0ffULL,
0x00005f002b297a11ULL, 0x000fe400018f3c24ULL, 0x000000312d247210ULL, 0x000fe40007f7e0ffULL,
0x00005e00272a7a11ULL, 0x000fe400078038ffULL, 0x0000b000252d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff257224ULL, 0x000fe200018e062fULL, 0x00005f00272b7a11ULL, 0x000fc400000f3c26ULL,
0x000000312c267210ULL, 0x080fe20007fbe0ffULL, 0x000000104a5d7824ULL, 0x100fe200078e022dULL,
0x000000003300720cULL, 0x080fe20003f06070ULL, 0x000000104c5e7824ULL, 0x000fe200078e022dULL,
0x0000003128287210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff277224ULL, 0x000fe200028e062eULL,
0x000000312a2a7210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000245d7faeULL, 0x0005e2000d101c46ULL, 0x000000004700720cULL, 0x080fe20003f46070ULL,
0x000000086b317824ULL, 0x000fe200078e00ffULL, 0x000000005300720cULL, 0x000fe20003fa6070ULL,
0x000000ffff297224ULL, 0x000fe200018e0629ULL, 0xfffffff040007812ULL, 0x000fe200078ec0ffULL,
0x000000104e5f7824ULL, 0x000fe200078e022dULL, 0x00000008312f7812ULL, 0x000fe200078e0cffULL,
0x000000ffff2b7224ULL, 0x000fe200020e062bULL, 0x0000f6a8002c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001050607824ULL, 0x000fe200078e022dULL, 0x00000000265e7faeULL, 0x0007e2000c101c46ULL,
0xffffffe040477812ULL, 0x000fc400078ec0ffULL, 0x000000012c2f7824ULL, 0x000fe200078e022fULL,
0x00000000285f7faeULL, 0x0007e2000d101c46ULL, 0x0000001040007812ULL, 0x040fe400078ec0ffULL,
0x0000000840247812ULL, 0x004fe200078ec0ffULL, 0x000000002a607faeULL, 0x0007e2000e901c46ULL,
0x000000000000781cULL, 0x000fe40003f0f070ULL, 0x0000004724477210ULL, 0x000fe20007ffe000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000002f0403c2ULL, 0x000ea40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000012c317824ULL, 0x000fe200078e0231ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002f5a7f8cULL, 0x000528000c80043fULL,
0x0000040031267984ULL, 0x0084e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6080047247f8cULL, 0x000fe2000c80043fULL,
0x8000000026ff7812ULL, 0x00afc60007844869ULL, 0x00f60c0047277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000a000000947ULL, 0x000fea0003800000ULL,
0x0000002041267824ULL, 0x000fe400078e0200ULL, 0x3e000000ff007424ULL, 0x000fe400078e00ffULL,
0x000000083d267824ULL, 0x000fe400078e0226ULL, 0x0000000000277305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000270000735dULL, 0x008fe40003800000ULL,
0x00f60c0026277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff527819ULL, 0x000fe20000011642ULL,
0xffffffffff537424ULL, 0x000fe200078e00ffULL, 0x0000007051517812ULL, 0x000fe400078ec0ffULL,
0x0000000c52527812ULL, 0x000fc600078ec0ffULL, 0x0000008041257824ULL, 0x000fc800078e0251ULL,
0x0000000125257824ULL, 0x000fca00078e0252ULL, 0x00f0000025007984ULL, 0x000e680000000800ULL,
0x00f2000025267984ULL, 0x0006a20000000800ULL, 0x000000390000720bULL, 0x002fe20003f1d000ULL,
0x000127a27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x008fc800000e0100ULL,
0x0000ffff24297812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff2c7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x000000364100720cULL, 0x000fe40003f65270ULL, 0x000000390000720bULL, 0x000fe20003f14000ULL,
0x000127727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x000000803625b824ULL, 0x000fe200078e0251ULL, 0x00000000392e7209ULL, 0x040fe40007810000ULL,
0x0000ffff24247812ULL, 0x000fe200078e3cffULL, 0x000000015225b824ULL, 0x000fe200078e0225ULL,
0x00000002ff287819ULL, 0x000fe20000011642ULL, 0x8000002e39277221ULL, 0x000fe20000010000ULL,
0x0000002429ff7212ULL, 0x000fc4000780c0ffULL, 0x00f4002e2500b388ULL, 0x0003e20000000800ULL,
0x3fb8aa3b27277820ULL, 0x000fc80000410000ULL, 0x00000027002b7308ULL, 0x0002e20000000800ULL,
0x000127027f007947ULL, 0x000fea000b800000ULL, 0x00001f282b277589ULL, 0x00a2e400000e0000ULL,
0x0000000828287810ULL, 0x002fe20007ffe0ffULL, 0x000127427f007947ULL, 0x000fea000b800000ULL,
0x00001f282b287589ULL, 0x00032400000e0000ULL, 0x8000002e00000221ULL, 0x100fe20000010000ULL,
0x0000002b38387220ULL, 0x000fe20000410000ULL, 0x0000002807077220ULL, 0x090fe20000410000ULL,
0x0000002806067220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL,
0x000000280b0b7220ULL, 0x080fe20000410000ULL, 0x000000280a0a7220ULL, 0x080fe20000410000ULL,
0x000000280f0f7220ULL, 0x080fe20000410000ULL, 0x0000000000450308ULL, 0x000f220000000800ULL,
0x000000280e0e7220ULL, 0x080fe20000410000ULL, 0x0000002813137220ULL, 0x080fe20000410000ULL,
0x0000002812127220ULL, 0x080fe20000410000ULL, 0x0000002817177220ULL, 0x080fe20000410000ULL,
0x0000002816167220ULL, 0x080fe20000410000ULL, 0x000000281b1b7220ULL, 0x080fe20000410000ULL,
0x000000281a1a7220ULL, 0x080fe20000410000ULL, 0x000000281f1f7220ULL, 0x080fe20000410000ULL,
0x000000281e1e7220ULL, 0x080fe20000410000ULL, 0x0000002823237220ULL, 0x080fe20000410000ULL,
0x0000002822227220ULL, 0x000fe20000410000ULL, 0x00000001ff2c7807ULL, 0x000fe20000000000ULL,
0x0000002705057220ULL, 0x088fe20000410000ULL, 0x0000002704047220ULL, 0x080fe20000410000ULL,
0x0000002709097220ULL, 0x080fe20000410000ULL, 0x0000002708087220ULL, 0x080fe20000410000ULL,
0x000000270d0d7220ULL, 0x080fe20000410000ULL, 0x000000270c0c7220ULL, 0x080fe20000410000ULL,
0x0000002711117220ULL, 0x080fe20000410000ULL, 0x0000002710107220ULL, 0x080fe20000410000ULL,
0x0000002715157220ULL, 0x080fe20000410000ULL, 0x0000002714147220ULL, 0x080fe20000410000ULL,
0x0000002719197220ULL, 0x080fe20000410000ULL, 0x0000002718187220ULL, 0x080fe20000410000ULL,
0x000000271d1d7220ULL, 0x080fe20000410000ULL, 0x000000271c1c7220ULL, 0x080fe20000410000ULL,
0x0000002721217220ULL, 0x080fe20000410000ULL, 0x0000002720207220ULL, 0x000fe20000410000ULL,
0x000000ffff397224ULL, 0x000fe200078e002eULL, 0x0000004526260220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000003826387221ULL, 0x004fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0000040031007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x0000040031247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000045ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff267819ULL, 0x000fc40000011642ULL, 0x00005410002b7816ULL, 0x002fe20000000000ULL,
0x000123e27f007947ULL, 0x000fea000b800000ULL, 0x00001f262b617589ULL, 0x0002a400000e0000ULL,
0x0000000826547810ULL, 0x000fe20007ffe0ffULL, 0x000124227f007947ULL, 0x000fea000b800000ULL,
0x00001f542b007589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000010266e7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0000209000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x000130e000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000018266e7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x000020f000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0001308000007944ULL, 0x03cfea0003c00000ULL, 0x0000000236567824ULL, 0x000fe200078e00ffULL,
0x0000000742257812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x0000000456277812ULL, 0x000fc400078ec0ffULL, 0x00000008256a7812ULL, 0x000fe400078ef842ULL,
0x00000027422d7211ULL, 0x000fc800078fe0ffULL, 0x000000072d257812ULL, 0x000fca00078e786aULL,
0x000000086a257824ULL, 0x000fc800078e0225ULL, 0x0000001025667824ULL, 0x000fe200078e00ffULL,
0x0000000842257812ULL, 0x000fc600078ec0ffULL, 0x00000800417a7824ULL, 0x000fe400078e0266ULL,
0x0000000436247824ULL, 0x040fe200078e00ffULL, 0x0000000725287812ULL, 0x140fe200078ec842ULL,
0x0000100036267824ULL, 0x002fe200078e00ffULL, 0x00000007252e7812ULL, 0x000fe200078ef842ULL,
0x000010006b317824ULL, 0x040fe200078e023aULL, 0x0000000424277812ULL, 0x000fe400078ec0ffULL,
0xffffe00026267812ULL, 0x000fe400078ec0ffULL, 0x0000002742277211ULL, 0x000fe400078fe0ffULL,
0x000000802e307811ULL, 0x000fe200078e18ffULL, 0x000010006b267824ULL, 0x000fe200078e0226ULL,
0x00000002272b7810ULL, 0x008fc40007ffe0ffULL, 0x00000027282f7212ULL, 0x040fe400078e3cffULL,
0x0000002b28577212ULL, 0x000fe400078e3cffULL, 0x0000b00026297810ULL, 0x000fe20007ffe0ffULL,
0x000000082e5c7824ULL, 0x040fe200078e022fULL, 0x0000b00031327810ULL, 0x000fe20007ffe0ffULL,
0x000000082e597824ULL, 0x000fe200078e0257ULL, 0x000099102c337816ULL, 0x000fe200000000ffULL,
0x000000012f587824ULL, 0x000fe200078e0230ULL, 0x000000022d317810ULL, 0x000fe20007ffe0ffULL,
0x000000105c247824ULL, 0x100fe200078e0229ULL, 0x000000ff3300720cULL, 0x000fe20003f05270ULL,
0x0000001059297824ULL, 0x000fe200078e0229ULL, 0x0000000731317812ULL, 0x000fe200078e786aULL,
0x00000010582c7824ULL, 0x000fc400078e0232ULL, 0x000000002424783bULL, 0x000e620000004200ULL,
0x0000000157577824ULL, 0x000fe400078e0230ULL, 0x000000086a6a7824ULL, 0x000fe200078e0231ULL,
0x000000002928783bULL, 0x004ea20000004200ULL, 0x0000001057327824ULL, 0x000fc600078e0232ULL,
0x000000002c2c783bULL, 0x000ee80000004200ULL, 0x000000003230783bULL, 0x000f220000004200ULL,
0x00000010ff6d7819ULL, 0x102fe40000011625ULL, 0x000000ff25687812ULL, 0x040fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe40000011625ULL, 0x0000ffff25937812ULL, 0x000fc400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011624ULL, 0x00000010ff8b7819ULL, 0x104fe4000001162bULL,
0x000000ff2b7e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7b7819ULL, 0x000fe4000001162bULL,
0x0000ffff2b257812ULL, 0x000fe400078ec0ffULL, 0x00000018ff2b7819ULL, 0x008fc4000001162cULL,
0x00000010ff647819ULL, 0x000fe40000011624ULL, 0x000000ff266f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6e7819ULL, 0x000fe40000011626ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000018ff707819ULL, 0x000fe40000011627ULL, 0x0000002bff2b723eULL, 0x000fe200020006ffULL,
0x20000062ff887230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fc400020006ffULL,
0x000000ff64647812ULL, 0x000fe200078ec0ffULL, 0x2000002bff627230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000006fff847230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000064ff2b723eULL, 0x000fe200020006ffULL,
0x2000006eff6f7230ULL, 0x000fe20000004100ULL, 0x0000ffff24927812ULL, 0x000fe200078ec0ffULL,
0x20000070ff6e7230ULL, 0x000fe20000004100ULL, 0x0000ffff26967812ULL, 0x000fe200078ec0ffULL,
0x2000002bff9a7230ULL, 0x000fe20000004100ULL, 0x000000ff27717812ULL, 0x000fc400078ec0ffULL,
0x000000ff6d707812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6d7819ULL, 0x000fe40000011692ULL,
0x00000008ff2b7819ULL, 0x000fe40000011696ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x0000002bff2b723eULL, 0x000fe200020006ffULL,
0x20000071ff857230ULL, 0x000fe20000004100ULL, 0x0000ffff27977812ULL, 0x000fe200078ec0ffULL,
0x2000006dff997230ULL, 0x000fe20000004100ULL, 0x0000ffff2ca17812ULL, 0x000fc400078ec0ffULL,
0x00000008ff717819ULL, 0x000fe20000011693ULL, 0x2000002bff937230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe40000011697ULL, 0x00000010ff727819ULL, 0x000fe40000011626ULL,
0x00000008ff2b7819ULL, 0x000fe400000116a1ULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fc400020006ffULL, 0x0000ffff2da27812ULL, 0x000fe200078ec0ffULL,
0x20000070ff9b7230ULL, 0x000fe20000004100ULL, 0x000000ff72727812ULL, 0x000fe200078ec0ffULL,
0x2000006dff927230ULL, 0x000fe20000004100ULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x0000ffff2ea37812ULL, 0x000fe400078ec0ffULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x2000002bff6d7230ULL, 0x000fe20000004100ULL, 0x00000008ff707819ULL, 0x000fc400000116a2ULL,
0x00000010ff7c7819ULL, 0x100fe20000011629ULL, 0x20000072ff977230ULL, 0x000fe20000004100ULL,
0x000000ff29777812ULL, 0x040fe400078ec0ffULL, 0x00000018ff767819ULL, 0x000fe40000011629ULL,
0x0000ffff29907812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x000fe4000001162aULL,
0x000000ff2a797812ULL, 0x000fc400078ec0ffULL, 0x00000018ff787819ULL, 0x000fe4000001162aULL,
0x0000ffff2a897812ULL, 0x000fe400078ec0ffULL, 0x0000ffff2fa47812ULL, 0x000fe400078ec0ffULL,
0x00000018ff297819ULL, 0x010fe40000011630ULL, 0x00000018ff2a7819ULL, 0x000fe40000011631ULL,
0x00000008ff2b7819ULL, 0x000fc400000116a3ULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x20000068ff8d7230ULL, 0x000fe20000004100ULL, 0x00000010ff7d7819ULL, 0x100fe20000011628ULL,
0x20000071ff987230ULL, 0x000fe20000004100ULL, 0x000000ff28757812ULL, 0x000fe200078ec0ffULL,
0x20000070ff717230ULL, 0x000fe20000004100ULL, 0x00000018ff747819ULL, 0x000fc40000011628ULL,
0x0000ffff288f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff2c817812ULL, 0x000fe400078ec0ffULL,
0x000000ff2d837812ULL, 0x000fe400078ec0ffULL, 0x000000ff2f917812ULL, 0x000fe400078ec0ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000079ff79723eULL, 0x000fc400020006ffULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x000000ff32287812ULL, 0x000fe400078ec0ffULL,
0x00000008ff727819ULL, 0x000fe400000116a4ULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x0000002aff2a723eULL, 0x000fc400020006ffULL,
0x00000010ff9e7819ULL, 0x100fe4000001162fULL, 0x00000018ff8a7819ULL, 0x000fe4000001162fULL,
0x00000065ff26723eULL, 0x000fe400020006ffULL, 0x00000081ff65723eULL, 0x000fe200020006ffULL,
0x20000078ff817230ULL, 0x000fe20000004100ULL, 0x00000083ff68723eULL, 0x000fe200020006ffULL,
0x20000079ff837230ULL, 0x000fe20000004100ULL, 0x00000091ff2f723eULL, 0x000fe200020006ffULL,
0x20000077ff917230ULL, 0x000fe20000004100ULL, 0x00000072ff70723eULL, 0x000fe200020006ffULL,
0x2000002bff727230ULL, 0x000fe20000004100ULL, 0x00000028ff79723eULL, 0x000fe200020006ffULL,
0x20000029ff787230ULL, 0x000fe20000004100ULL, 0x00000010ff9c7819ULL, 0x100fe2000001162dULL,
0x2000002aff777230ULL, 0x000fe20000004100ULL, 0x000000ff24637812ULL, 0x000fe200078ec0ffULL,
0x009000007a28783bULL, 0x000e620000000200ULL, 0x00000010ff7f7819ULL, 0x000fe2000001162cULL,
0x20000026ff267230ULL, 0x000fe20000004100ULL, 0x000000ff9c9c7812ULL, 0x000fe200078ec0ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000018ff827819ULL, 0x000fe2000001162dULL,
0x2000002fff2f7230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff9d7819ULL, 0x000fe2000001162eULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x000000ff7f7f7812ULL, 0x000fc400078ec0ffULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x20000063ff8e7230ULL, 0x000fe20000004100ULL,
0x000000ff2e877812ULL, 0x000fe400078ec0ffULL, 0x00000018ff867819ULL, 0x000fe4000001162eULL,
0x0000009cff9c723eULL, 0x000fe400020006ffULL, 0x00000082ff2e723eULL, 0x000fe200020006ffULL,
0x2000007eff827230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fc400020006ffULL,
0x00000018ff807819ULL, 0x000fe20000011632ULL, 0x2000002eff2e7230ULL, 0x000fe20000004100ULL,
0x0000007fff7e723eULL, 0x000fe200020006ffULL, 0x2000007bff7f7230ULL, 0x000fe20000004100ULL,
0x000000ff9d9d7812ULL, 0x000fe200078ec0ffULL, 0x2000009cff7b7230ULL, 0x000fe20000004100ULL,
0x000000ff8b8b7812ULL, 0x000fe200078ec0ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x000000ff33957812ULL, 0x000fe400078ec0ffULL, 0x00000008ff897819ULL, 0x000fc40000011689ULL,
0x00000087ff63723eULL, 0x000fe200020006ffULL, 0x20000074ff877230ULL, 0x000fe20000004100ULL,
0x00000080ff9c723eULL, 0x000fe200020006ffULL, 0x0000006128288231ULL, 0x082fe200003400ffULL,
0x0000009dff74723eULL, 0x000fe200020006ffULL, 0x000000612a2a8231ULL, 0x000fe200003400ffULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x0000000029298231ULL, 0x080fe200003400ffULL,
0x00000095ff9d723eULL, 0x000fe200020006ffULL, 0x000000002b2b8231ULL, 0x000fe200003400ffULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe20000011630ULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x000000ff7d807812ULL, 0x000fe200078ec0ffULL, 0x2000009cff7d7230ULL, 0x000fe20000004100ULL,
0x00000008ff257819ULL, 0x000fe20000011625ULL, 0x2000008bff9c7230ULL, 0x000fe20000004100ULL,
0x000000ff7c957812ULL, 0x000fe200078ec0ffULL, 0x2000009dff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff249d7812ULL, 0x000fe200078ec0ffULL, 0x20000089ff8b7230ULL, 0x000fe20000004100ULL,
0x00000025ff89723eULL, 0x000fc400020006ffULL, 0x00000010ff737819ULL, 0x000fe40000011627ULL,
0x00000010ff247819ULL, 0x000fe2000001168eULL, 0x20000089ff8e7230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe4000001169aULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff7a7819ULL, 0x000fe4000001169bULL, 0x000000ff73737812ULL, 0x000fc400078ec0ffULL,
0x0000105425247816ULL, 0x000fe40000000024ULL, 0x000010547a257816ULL, 0x000fe4000000008dULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000010ff277819ULL, 0x000fe40000011631ULL,
0x00000010ff7a7819ULL, 0x000fe20000011688ULL, 0x000000242820723cULL, 0x000fe20000041820ULL,
0x00000010ff997819ULL, 0x000fe20000011699ULL, 0x20000073ff967230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fc40000011626ULL, 0x00000010ff987819ULL, 0x000fe40000011698ULL,
0x000000ff27257812ULL, 0x000fe400078ec0ffULL, 0x000010547a267816ULL, 0x000fe20000000099ULL,
0x000000106a7a7824ULL, 0x000fe200078e00ffULL, 0x0000105489277816ULL, 0x000fe40000000098ULL,
0x00000025ff8d723eULL, 0x000fe400020006ffULL, 0x00000010ff247819ULL, 0x000fc40000011684ULL,
0x00000010ff977819ULL, 0x000fe20000011697ULL, 0x00000026281c723cULL, 0x000fe2000004181cULL,
0x00000010ff257819ULL, 0x000fe40000011685ULL, 0x00000010ff967819ULL, 0x000fe40000011696ULL,
0x0000105497247816ULL, 0x000fe40000000024ULL, 0x0000105496257816ULL, 0x000fe20000000025ULL,
0x0000080041277824ULL, 0x000fe200078e027aULL, 0x00000010ff267819ULL, 0x000fc4000001166fULL,
0x00000010ff937819ULL, 0x000fe40000011693ULL, 0x000000ff9e9e7812ULL, 0x000fe200078ec0ffULL,
0x000000242818723cULL, 0x000fe20000041818ULL, 0x00000018ff947819ULL, 0x000fe40000011633ULL,
0x00000010ff6a7819ULL, 0x000fe4000001166eULL, 0x00001054266e7816ULL, 0x000fe40000000093ULL,
0x0000009eff73723eULL, 0x000fe200020006ffULL, 0x009000002724783bULL, 0x000e620000000200ULL,
0x0000008aff8a723eULL, 0x000fc400020006ffULL, 0x00000094ff9e723eULL, 0x000fe200020006ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x2000008aff647230ULL, 0x000fe20000004100ULL, 0x00000080ff94723eULL, 0x000fe200020006ffULL,
0x2000009eff807230ULL, 0x000fe20000004100ULL, 0x00000095ff95723eULL, 0x000fe200020006ffULL,
0x20000075ff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe20000011692ULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x0000ffff30697812ULL, 0x000fe200078ec0ffULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x00000008ff8f7819ULL, 0x000fc4000001168fULL,
0x000010546a6f7816ULL, 0x000fe4000000006fULL, 0x00000008ff907819ULL, 0x000fe40000011690ULL,
0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff847819ULL, 0x000fe20000011669ULL,
0x0000006e2814723cULL, 0x000fe20000041814ULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000010ff8a7819ULL, 0x000fc4000001168aULL, 0x00000010ff917819ULL, 0x000fe20000011691ULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000010ff697819ULL, 0x000fe40000011694ULL,
0x00000010ff6a7819ULL, 0x000fe40000011695ULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x0000006124248231ULL, 0x082fe200003400ffULL, 0x00001054696e7816ULL, 0x000fe2000000008aULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x000010546a6f7816ULL, 0x000fe20000000091ULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff309f7812ULL, 0x000fe200078ec0ffULL,
0x0000006126268231ULL, 0x000fe200003400ffULL, 0x00000086ff30723eULL, 0x000fe200020006ffULL,
0x20000076ff867230ULL, 0x000fe20000004100ULL, 0x00000084ff89723eULL, 0x000fe200020006ffULL,
0x0000006e2810723cULL, 0x000fe20000041810ULL, 0x00000010ff847819ULL, 0x000fe2000001168fULL,
0x2000008dff8f7230ULL, 0x000fe20000004100ULL, 0x00000010ff697819ULL, 0x000fe20000011668ULL,
0x0000000025258231ULL, 0x080fe200003400ffULL, 0x00000010ff877819ULL, 0x000fe20000011687ULL,
0x0000000027278231ULL, 0x000fe200003400ffULL, 0x00000010ff867819ULL, 0x000fe20000011686ULL,
0x20000030ff307230ULL, 0x000fe20000004100ULL, 0x00000010ff857819ULL, 0x000fe20000011690ULL,
0x20000089ff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff837819ULL, 0x000fc40000011683ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff8d7819ULL, 0x000fe4000001169cULL, 0x00000010ff6a7819ULL, 0x000fe40000011681ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff687819ULL, 0x000fc4000001167fULL,
0x00000010ff6f7819ULL, 0x000fe4000001168eULL, 0x0000105487847816ULL, 0x000fe40000000084ULL,
0x0000105486857816ULL, 0x000fe40000000085ULL, 0x000010548c8c7816ULL, 0x000fe40000000083ULL,
0x000010548d8d7816ULL, 0x000fe40000000082ULL, 0x000010546a6e7816ULL, 0x000fe2000000008bULL,
0x00000084280c723cULL, 0x000fe2000004180cULL, 0x00001054686f7816ULL, 0x000fc4000000006fULL,
0x000000ff31a07812ULL, 0x040fe400078ec0ffULL, 0x00000010ff2c7819ULL, 0x000fe40000011632ULL,
0x00000010ff2d7819ULL, 0x000fe20000011633ULL, 0x0000008c2808723cULL, 0x000fe20000041808ULL,
0x0000ffff31317812ULL, 0x000fe400078ec0ffULL, 0x0000ffff32327812ULL, 0x000fe400078ec0ffULL,
0x0000ffff33337812ULL, 0x000fc400078ec0ffULL, 0x00000010ff627819ULL, 0x000fe20000011662ULL,
0x0000006e2804723cULL, 0x000fe20000041804ULL, 0x00000010ff2e7819ULL, 0x000fe4000001162eULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000008ff317819ULL, 0x000fe40000011631ULL,
0x00000010ff297819ULL, 0x000fe40000011671ULL, 0x000000ff2c2c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff2d2d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff327819ULL, 0x000fe40000011632ULL,
0x00000008ff337819ULL, 0x000fe40000011633ULL, 0x0000105462287816ULL, 0x000fe4000000006dULL,
0x000010542e297816ULL, 0x000fe40000000029ULL, 0x0000009fff75723eULL, 0x000fc400020006ffULL,
0x000000a0ff76723eULL, 0x000fe400020006ffULL, 0x0000009dff9d723eULL, 0x000fe200020006ffULL,
0x00000028241c723cULL, 0x000fe2000004181cULL, 0x00000031ff31723eULL, 0x000fe200020006ffULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x0000002cff2c723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x0000002dff2d723eULL, 0x000fe200020006ffULL,
0x2000009dff887230ULL, 0x000fe20000004100ULL, 0x00000032ff32723eULL, 0x000fe200020006ffULL,
0x20000031ff317230ULL, 0x000fe20000004100ULL, 0x00000033ff33723eULL, 0x000fe200020006ffULL,
0x2000002cff2c7230ULL, 0x000fe20000004100ULL, 0x00000010ff2b7819ULL, 0x000fe2000001162fULL,
0x2000002dff287230ULL, 0x000fe20000004100ULL, 0x00000010ff007819ULL, 0x000fe20000011673ULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x00000010ff297819ULL, 0x000fe20000011630ULL,
0x20000033ff337230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fc40000011672ULL,
0x00001054002b7816ULL, 0x000fe4000000002bULL, 0x0000105429727816ULL, 0x000fe40000000072ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff6a7819ULL, 0x000fe4000001167bULL, 0x00000010ff637819ULL, 0x000fc40000011663ULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff737819ULL, 0x000fe40000011664ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff887819ULL, 0x000fc40000011688ULL,
0x00000010ff897819ULL, 0x000fe4000001168fULL, 0x00000010ff297819ULL, 0x000fe40000011678ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff007819ULL, 0x000fe40000011677ULL,
0x00000010ff317819ULL, 0x000fe40000011631ULL, 0x00000010ff797819ULL, 0x000fc40000011679ULL,
0x00000010ff2c7819ULL, 0x000fe4000001162cULL, 0x00000010ff2d7819ULL, 0x000fe4000001167cULL,
0x00000010ff287819ULL, 0x000fe40000011628ULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff327819ULL, 0x000fe40000011632ULL, 0x00000010ff807819ULL, 0x000fc40000011680ULL,
0x00000010ff337819ULL, 0x000fe40000011633ULL, 0x000010547e7e7816ULL, 0x000fe40000000065ULL,
0x000010546a7f7816ULL, 0x000fe40000000069ULL, 0x00001054742a7816ULL, 0x000fe40000000063ULL,
0x0000105473737816ULL, 0x000fe40000000070ULL, 0x0000105488887816ULL, 0x000fe20000000075ULL,
0x0000007e2420723cULL, 0x000fe20000041820ULL, 0x0000105489897816ULL, 0x000fc40000000076ULL,
0x00001054298a7816ULL, 0x000fe4000000008aULL, 0x00001054008b7816ULL, 0x000fe40000000031ULL,
0x000010542c2c7816ULL, 0x000fe20000000079ULL, 0x0000002a2418723cULL, 0x000fe20000041818ULL,
0x00001054282d7816ULL, 0x000fe4000000002dULL, 0x000010547d327816ULL, 0x000fe40000000032ULL,
0x0000105480337816ULL, 0x000fc60000000033ULL, 0x000000722414723cULL, 0x040ff00000041814ULL,
0x000000882410723cULL, 0x040ff00000041810ULL, 0x0000008a240c723cULL, 0x040ff0000004180cULL,
0x0000002c2408723cULL, 0x040ff00000041808ULL, 0x000000322404723cULL, 0x000fe20000041804ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200037247f8cULL, 0x0002a2000c80043fULL,
0xfffffff856567812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004055277810ULL, 0x000fe20007ffe0ffULL, 0x00f6880056ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff697224ULL, 0x000fe200078e005bULL, 0x000000016b6b7812ULL, 0x000fc400078e0cffULL,
0x000000342700720cULL, 0x000fda0003f06070ULL, 0x0000745000000947ULL, 0x000fea0003800000ULL,
0x0000040067007984ULL, 0x008ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000240037007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x0000240037247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000036c007812ULL, 0x000fe200078ec0ffULL, 0x000058003e287a24ULL, 0x020fe200078e02ffULL,
0x00000001ff487819ULL, 0x000fe20000011636ULL, 0x00000008446a7824ULL, 0x000fe200078e00ffULL,
0x000000030000780cULL, 0x000fe20003f05270ULL, 0xffffffffff3e7424ULL, 0x000fc600078e00ffULL,
0x000000013f257807ULL, 0x000fca0004000000ULL, 0x000000016c6c7824ULL, 0x000fca00078e0225ULL,
0x000000036c007812ULL, 0x000fc800078ec0ffULL, 0x000000030000780cULL, 0x000fc80003f05270ULL,
0x000000013f6d7807ULL, 0x000fca0004000000ULL, 0x000000016c467824ULL, 0x000fca00078e026dULL,
0x000000034600720cULL, 0x000fe20003f06070ULL, 0x0000002048007824ULL, 0x000fe200078e0255ULL,
0xfffffff040267812ULL, 0x000fe400078ec0ffULL, 0x000000086a627812ULL, 0x000fe400078ec0ffULL,
0x0000008000007810ULL, 0x000fce0007ffe0ffULL, 0x0000006d43248210ULL, 0x000fe20007ffe06cULL,
0x00000004ff258424ULL, 0x000fc800078e00ffULL, 0x0000600024248625ULL, 0x000fe200078e0025ULL,
0x0000f6a826267810ULL, 0x000fe40007ffe0ffULL, 0x0000000862617812ULL, 0x000fe400078e3cffULL,
0x00000006243e8981ULL, 0x000562000c1e1900ULL, 0x0000000135277810ULL, 0x000fe20007ffe0ffULL,
0x0000000126627824ULL, 0x040fe200078e0262ULL, 0x00000003ff2f7819ULL, 0x000fe20000011642ULL,
0x0000000126617824ULL, 0x000fe200078e0261ULL, 0x000000022700720cULL, 0x000fe20003f06070ULL,
0x0000001036267824ULL, 0x000fe200078e00ffULL, 0x00000000620473c2ULL, 0x000ee200000e0000ULL,
0x00000040282b7824ULL, 0x000fe200078e00ffULL, 0x0000000034257217ULL, 0x004fe20007800000ULL,
0x0000100044687824ULL, 0x000fe200078e00ffULL, 0x000000203b247812ULL, 0x000fc400078ef800ULL,
0x0000001026287812ULL, 0x000fe200078ec0ffULL, 0x0000000125257824ULL, 0x000fe400078e0a00ULL,
0x0000000149007824ULL, 0x100fe400078e0224ULL, 0x000000014b267824ULL, 0x100fe200078e0224ULL,
0x0000002025257807ULL, 0x000fe20000000000ULL, 0x000000014d277824ULL, 0x100fe200078e0224ULL,
0x000000002b007210ULL, 0x000fe20007f1e0ffULL, 0x000000014f247824ULL, 0x000fe200078e0224ULL,
0x000000262b267210ULL, 0x000fc40007f5e0ffULL, 0x0000002528257217ULL, 0x000fe20007800000ULL,
0x000000ffff2d7224ULL, 0x000fe200000e06ffULL, 0x00005e0000327a11ULL, 0x000fe400078038ffULL,
0x000000272b297210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff277224ULL, 0x000fe200010e06ffULL,
0x00005e00262e7a11ULL, 0x000fe400078438ffULL, 0x000000242b247210ULL, 0x000fe40007f9e0ffULL,
0x00005f00002d7a11ULL, 0x000fe200000f3c2dULL, 0x0000000125007824ULL, 0x000fe200078e0a28ULL,
0x0000100068257812ULL, 0x000fc400078ec0ffULL, 0x00005f0026307a11ULL, 0x000fe200010f3c27ULL,
0x000000ffff267224ULL, 0x000fe200018e06ffULL, 0x00005e0029287a11ULL, 0x000fe200078038ffULL,
0x000000ffff277224ULL, 0x000fe200020e06ffULL, 0x00005e00242a7a11ULL, 0x000fe200078438ffULL,
0x0000200048257824ULL, 0x000fe200078e0225ULL, 0x000000042f2b7810ULL, 0x040fe40007ffe0ffULL,
0x000000002f00720cULL, 0x000fe40003f86070ULL, 0x00005f0029297a11ULL, 0x000fc400000f3c26ULL,
0x00005f00242c7a11ULL, 0x000fe400010f3c27ULL, 0x000000002b00720cULL, 0x080fe40003f06070ULL,
0x0000005132247210ULL, 0x080fe40007f5e0ffULL, 0x0000b000252b7810ULL, 0x000fe40007ffe0ffULL,
0x000000082f277810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff257224ULL, 0x000fe200010e062dULL,
0x0000000c2f2f7810ULL, 0x000fe20007ffe0ffULL, 0x000000104a2d7824ULL, 0x100fe200078e022bULL,
0x000000512e267210ULL, 0x080fe20007fbe0ffULL, 0x000000104e317824ULL, 0x100fe200078e022bULL,
0x000000002700720cULL, 0x080fe20003f66070ULL, 0x0000001050337824ULL, 0x100fe200078e022bULL,
0x000000002f00720cULL, 0x000fe20003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242d7faeULL, 0x0005e2000e101c46ULL, 0x0000005128287210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff277224ULL, 0x000fe200028e0630ULL, 0x000000512a2a7210ULL, 0x000fe20007fbe0ffULL,
0x000000104c2f7824ULL, 0x000fc400078e022bULL, 0x000000ffff297224ULL, 0x000fe400020e0629ULL,
0x000000ffff2b7224ULL, 0x000fe200028e062cULL, 0x00000000262f7faeULL, 0x0005e8000c101c46ULL,
0x0000000028317faeULL, 0x0005e8000d901c46ULL, 0x000000002a337faeULL, 0x0005e8000d101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x008fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000062247f8cULL, 0x0044e8000c80043fULL, 0x0000040061297984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280047267f8cULL, 0x000fe2000c80043fULL, 0x8000000029ff7812ULL, 0x010fc6000784485bULL,
0x00f62c00472b7984ULL, 0x000f240000000800ULL, 0x800000002bff7812ULL, 0x010fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff697224ULL, 0x008fe200078e0025ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe040477812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff007424ULL, 0x000fe200078e00ffULL,
0x0000001040247812ULL, 0x040fe400078ec0ffULL, 0x0000000840257812ULL, 0x000fc800078ec0ffULL,
0x0000004725477210ULL, 0x000fe40007ffe024ULL, 0x0000000000247305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000240000735dULL, 0x010fe20003800000ULL,
0x00f62c0047257984ULL, 0x000ee40000000800ULL, 0x8000000025ff7812ULL, 0x008fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002036007824ULL, 0x000fca00078e00ffULL,
0xffffff8000007812ULL, 0x000fc800078ec0ffULL, 0x0000008051257810ULL, 0x000fca0007ffe000ULL,
0x0000000152257824ULL, 0x000fca00078e0225ULL, 0x00f0000025007984ULL, 0x000ee80000000800ULL,
0x00f2000025267984ULL, 0x0008620000000800ULL, 0x000000390000720bULL, 0x008fe20003f1d000ULL,
0x000100c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x010fc800000e0100ULL,
0x0000ffff24297812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff2c7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000141257810ULL, 0x000fe40007ffe0ffULL, 0x000000390000720bULL, 0x000fe40003f14000ULL,
0x000000362500720cULL, 0x000fe20003f65270ULL, 0x000100827f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x0000000039287209ULL, 0x040fe20007810000ULL,
0x000000803627b824ULL, 0x000fe200078e0251ULL, 0x0000ffff24247812ULL, 0x000fe400078e3cffULL,
0x00000002ff6e7819ULL, 0x000fe20000011642ULL, 0x000000015227b824ULL, 0x000fe200078e0227ULL,
0x8000002839257221ULL, 0x000fe20000010000ULL, 0x0000002429ff7212ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL, 0x00f400282700b388ULL, 0x0007e60000000800ULL,
0x00000025002b7308ULL, 0x000f240000000800ULL, 0x0000002b38387220ULL, 0x010fe20000410000ULL,
0x000100027f007947ULL, 0x000fea000b800000ULL, 0x00001f6e2b247589ULL, 0x00872400000e0000ULL,
0x0000002420207220ULL, 0x090fe20000410000ULL, 0x0000002421217220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x000000240c0c7220ULL, 0x080fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x0000002404047220ULL, 0x080fe20000410000ULL, 0x0000002405057220ULL, 0x000fe20000410000ULL,
0x0000ff427f007947ULL, 0x000fea000b800000ULL, 0x00001f542b247589ULL, 0x0008a400000e0000ULL,
0x0000000039397209ULL, 0x000fe20007810000ULL, 0x0000002422227220ULL, 0x084fe20000410000ULL,
0x00000001ff2c7807ULL, 0x000fe20000000000ULL, 0x0000002423237220ULL, 0x080fe20000410000ULL,
0x000000241e1e7220ULL, 0x080fe20000410000ULL, 0x8000003900000221ULL, 0x000fe20000010000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL,
0x0000002416167220ULL, 0x080fe20000410000ULL, 0x0000002417177220ULL, 0x080fe20000410000ULL,
0x0000002412127220ULL, 0x080fe20000410000ULL, 0x0000000000450308ULL, 0x000ea20000000800ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x000000240e0e7220ULL, 0x080fe20000410000ULL,
0x000000240f0f7220ULL, 0x080fe20000410000ULL, 0x000000240a0a7220ULL, 0x080fe20000410000ULL,
0x000000240b0b7220ULL, 0x080fe20000410000ULL, 0x0000002406067220ULL, 0x080fe20000410000ULL,
0x0000002407077220ULL, 0x000fe20000410000ULL, 0x0000002645260220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000003826387221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x0000000844007824ULL, 0x000fe200078e00ffULL, 0xfffffff040257812ULL, 0x000fc800078ec0ffULL,
0x0000000800007812ULL, 0x000fca00078e0cffULL, 0x0000000125247824ULL, 0x000fca00078e0200ULL,
0x00f6ac0024257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780485bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000257305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x004fe40003800000ULL,
0x00f6ac0024257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc4000780485bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff6e7819ULL, 0x008fe40000011642ULL,
0x00000045ff00723eULL, 0x000fe400000010ffULL, 0x000000186e267810ULL, 0x040fe40007ffe0ffULL,
0x000000106e277810ULL, 0x000fe40007ffe0ffULL, 0x00005410002b7816ULL, 0x010fe20000000000ULL,
0x0000fc927f007947ULL, 0x000fea000b800000ULL, 0x00001f6e2b6b7589ULL, 0x0002e400000e0000ULL,
0x0000fcd27f007947ULL, 0x000fea000b800000ULL, 0x00001f542b007589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6e7224ULL, 0x002fe200078e0027ULL,
0x00004a2000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0001075000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6e7224ULL, 0x002fe200078e0026ULL,
0x00004a8000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x000106f000007944ULL, 0x03cfea0003c00000ULL,
0x00001000442d7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100036247824ULL, 0x000fe200078e00ffULL, 0x000099102c327816ULL, 0x000fe200000000ffULL,
0x0000020036307824ULL, 0x000fe200078e00ffULL, 0x000010002d2d7812ULL, 0x000fe400078e0cffULL,
0xffffe00024247812ULL, 0x000fc400078ec0ffULL, 0x0000b0003a637810ULL, 0x100fe40007ffe02dULL,
0x0000b00024657810ULL, 0x000fe40007ffe02dULL, 0xfffff80030317812ULL, 0x000fe200078ec0ffULL,
0x00000010585b7824ULL, 0x000fe200078e0263ULL, 0x000000ff3200720cULL, 0x000fe20003f05270ULL,
0x000000105c647824ULL, 0x100fe400078e0265ULL, 0x0000001059657824ULL, 0x000fe200078e0265ULL,
0x000000005b2c783bULL, 0x000f220000004200ULL, 0x0000001057637824ULL, 0x000fc400078e0263ULL,
0x0000000166667824ULL, 0x100fe200078e0231ULL, 0x000000006528783bULL, 0x016e620000004200ULL,
0x000000017a5a7824ULL, 0x000fc600078e0231ULL, 0x000000006424783bULL, 0x000ea80000004200ULL,
0x000000006330783bULL, 0x000f220000004200ULL, 0x000000ff2d9a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7f7819ULL, 0x000fe4000001162dULL, 0x00000010ff977819ULL, 0x002fe40000011629ULL,
0x000000ff29797812ULL, 0x000fc400078ec0ffULL, 0x00000018ff787819ULL, 0x000fe40000011629ULL,
0x0000ffff29967812ULL, 0x000fe400078ec0ffULL, 0x00000010ff957819ULL, 0x100fe4000001162aULL,
0x000000ff2a7a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff297819ULL, 0x000fe4000001162aULL,
0x0000ffff2a937812ULL, 0x000fc400078ec0ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001162bULL,
0x00000018ff6f7819ULL, 0x104fe40000011624ULL, 0x0000002aff2a723eULL, 0x000fe400020006ffULL,
0x00000010ff7c7819ULL, 0x000fe40000011624ULL, 0x0000ffff24a97812ULL, 0x000fe200078ec0ffULL,
0x2000002aff7e7230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fc400020006ffULL,
0x00000010ff947819ULL, 0x000fe4000001162bULL, 0x000000ff2b7b7812ULL, 0x040fe200078ec0ffULL,
0x2000006fff8c7230ULL, 0x000fe20000004100ULL, 0x0000ffff2b917812ULL, 0x000fe400078ec0ffULL,
0x00000018ff2b7819ULL, 0x000fe4000001162cULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x0000009aff9a723eULL, 0x000fc400020006ffULL, 0x00000010ff997819ULL, 0x000fe20000011625ULL,
0x20000029ff807230ULL, 0x000fe20000004100ULL, 0x0000ffff25aa7812ULL, 0x000fe400078ec0ffULL,
0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff2a7819ULL, 0x000fe400000116a9ULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fc400020006ffULL,
0x000000ff27757812ULL, 0x000fe200078ec0ffULL, 0x20000079ff857230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x20000078ff847230ULL, 0x000fe20000004100ULL,
0x0000007fff6f723eULL, 0x000fe200020006ffULL, 0x2000009aff7f7230ULL, 0x000fe20000004100ULL,
0x000000ff2e9c7812ULL, 0x000fe200078ec0ffULL, 0x2000002bff787230ULL, 0x000fe20000004100ULL,
0x000000ff99997812ULL, 0x000fe200078ec0ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000008ff9a7819ULL, 0x000fc400000116aaULL, 0x0000007cff29723eULL, 0x000fe400020006ffULL,
0x0000002aff2a723eULL, 0x000fe400020006ffULL, 0x0000ffff26ab7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff27ac7812ULL, 0x000fe400078ec0ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x0000009cff79723eULL, 0x000fc400020006ffULL, 0x00000018ff707819ULL, 0x000fe20000011625ULL,
0x20000075ff897230ULL, 0x000fe20000004100ULL, 0x000000ff28777812ULL, 0x000fe200078ec0ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000018ff9b7819ULL, 0x000fe4000001162eULL,
0x00000099ff2b723eULL, 0x000fe200020006ffULL, 0x20000029ff997230ULL, 0x000fe20000004100ULL,
0x0000009aff9c723eULL, 0x000fe200020006ffULL, 0x2000002aff9a7230ULL, 0x000fe20000004100ULL,
0x00000010ff987819ULL, 0x000fc40000011628ULL, 0x00000008ff297819ULL, 0x000fe200000116abULL,
0x2000009cff9c7230ULL, 0x000fe20000004100ULL, 0x00000008ff2a7819ULL, 0x000fe400000116acULL,
0x00000018ff747819ULL, 0x000fe40000011627ULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x0000009bff75723eULL, 0x000fe200020006ffULL,
0x2000002bff9b7230ULL, 0x000fe20000004100ULL, 0x00000018ff767819ULL, 0x000fe20000011628ULL,
0x20000070ff8d7230ULL, 0x000fe20000004100ULL, 0x00000018ffa17819ULL, 0x010fe20000011630ULL,
0x20000077ff867230ULL, 0x000fe20000004100ULL, 0x000000ff246e7812ULL, 0x000fe200078ec0ffULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x0000ffff28287812ULL, 0x000fc400078ec0ffULL,
0x000000ff2fa07812ULL, 0x000fe400078ec0ffULL, 0x00000018ff9f7819ULL, 0x000fe4000001162fULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x0000002aff2a723eULL, 0x000fe400020006ffULL,
0x000000ff982b7812ULL, 0x000fe200078ec0ffULL, 0x20000029ff987230ULL, 0x000fe20000004100ULL,
0x00000010ff907819ULL, 0x000fc4000001162dULL, 0x0000ffff2d247812ULL, 0x000fe400078ec0ffULL,
0x00000074ff2d723eULL, 0x000fe400020006ffULL, 0x000000a1ff74723eULL, 0x000fe400020006ffULL,
0x000000a0ff70723eULL, 0x000fe200020006ffULL, 0x2000002dff2d7230ULL, 0x000fe20000004100ULL,
0x0000009fff77723eULL, 0x000fe200020006ffULL, 0x2000002aff9f7230ULL, 0x000fe20000004100ULL,
0x000000ff97a17812ULL, 0x000fe200078ec0ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x0000002bffa0723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000008ff977819ULL, 0x000fe20000011628ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x009800006628783bULL, 0x000e620000000200ULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x200000a0ffa07230ULL, 0x000fe20000004100ULL, 0x000000ff30a27812ULL, 0x000fc400078ec0ffULL,
0x00000097ff97723eULL, 0x000fe200020006ffULL, 0x20000076ff837230ULL, 0x000fe20000004100ULL,
0x00000008ff967819ULL, 0x000fe40000011696ULL, 0x000000ff95957812ULL, 0x000fe400078ec0ffULL,
0x00000018ff727819ULL, 0x000fe40000011626ULL, 0x00000010ff8f7819ULL, 0x000fe4000001162cULL,
0x000000a2ff76723eULL, 0x000fc400020006ffULL, 0x00000018ffa37819ULL, 0x000fe40000011631ULL,
0x000000ff94a27812ULL, 0x000fe200078ec0ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x00000095ff94723eULL, 0x000fe200020006ffULL,
0x20000097ff957230ULL, 0x000fe20000004100ULL, 0x000000ff25717812ULL, 0x000fe400078ec0ffULL,
0x000000ff2c7d7812ULL, 0x040fe200078ec0ffULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x0000ffff2c8b7812ULL, 0x000fc400078ec0ffULL, 0x00000072ff2c723eULL, 0x000fe400020006ffULL,
0x00000008ff977819ULL, 0x000fe40000011693ULL, 0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL,
0x2000002cff2c7230ULL, 0x000fe20000004100ULL, 0x000000a3ff72723eULL, 0x000fe400020006ffULL,
0x000000ff90907812ULL, 0x000fe200078ec0ffULL, 0x0000006b28288231ULL, 0x08afe200003400ffULL,
0x0000006eff8e723eULL, 0x000fe200020006ffULL, 0x0000006b2a2a8231ULL, 0x000fe200003400ffULL,
0x000000a2ffa3723eULL, 0x000fe200020006ffULL, 0x20000096ffa27230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000097ff96723eULL, 0x000fe200020006ffULL, 0x200000a3ff937230ULL, 0x000fe20000004100ULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x20000071ff927230ULL, 0x000fe20000004100ULL,
0x00000090ff97723eULL, 0x000fe200020006ffULL, 0x0000000029298231ULL, 0x080fe200003400ffULL,
0x00000010ff257819ULL, 0x000fe2000001162eULL, 0x2000008fff907230ULL, 0x000fe20000004100ULL,
0x00000010ff997819ULL, 0x000fe20000011699ULL, 0x20000097ff8f7230ULL, 0x000fe20000004100ULL,
0x00000008ff977819ULL, 0x000fe20000011624ULL, 0x000000002b2b8231ULL, 0x000fe200003400ffULL,
0x000000ff25a37812ULL, 0x000fe200078ec0ffULL, 0x20000096ff967230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe2000001168eULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fc40000011692ULL, 0x00000010ff8e7819ULL, 0x000fe4000001169bULL,
0x00000010ff9d7819ULL, 0x000fe40000011626ULL, 0x00000010ff9e7819ULL, 0x000fe40000011627ULL,
0x0000ffff2e877812ULL, 0x000fe400078ec0ffULL, 0x00000010ff887819ULL, 0x000fe4000001162fULL,
0x0000105499247816ULL, 0x000fc40000000024ULL, 0x000010548e257816ULL, 0x000fe40000000025ULL,
0x000000ff26737812ULL, 0x000fe400078ec0ffULL, 0x000000ff9d9d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff9e9e7812ULL, 0x000fe200078ec0ffULL, 0x000000242820723cULL, 0x000fe20000041820ULL,
0x00000097ff97723eULL, 0x000fe400020006ffULL, 0x000000ff88927812ULL, 0x000fc400078ec0ffULL,
0x00000008ff8e7819ULL, 0x000fe20000011687ULL, 0x20000097ff887230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x0000009dff9d723eULL, 0x000fe400020006ffULL,
0x0000009eff9e723eULL, 0x000fe200020006ffULL, 0x20000073ff8a7230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x2000009dff9d7230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x2000009eff9e7230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fc4000001168cULL, 0x00000010ff247819ULL, 0x000fe2000001169aULL,
0x2000008eff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff977819ULL, 0x000fe2000001168dULL,
0x20000092ff8d7230ULL, 0x000fe20000004100ULL, 0x00000010ff9c7819ULL, 0x000fe4000001169cULL,
0x0000ffff2f267812ULL, 0x000fe400078ec0ffULL, 0x00000010ff277819ULL, 0x000fe40000011630ULL,
0x0000105425247816ULL, 0x000fc40000000024ULL, 0x0000105497257816ULL, 0x000fe4000000009cULL,
0x00000008ff8e7819ULL, 0x000fe40000011626ULL, 0x000000ff27927812ULL, 0x000fe400078ec0ffULL,
0x00000010ff267819ULL, 0x000fe2000001168aULL, 0x00000024281c723cULL, 0x000fe2000004181cULL,
0x00000010ff277819ULL, 0x000fe40000011689ULL, 0x00000010ff9d7819ULL, 0x000fc4000001169dULL,
0x00000010ff9e7819ULL, 0x000fe4000001169eULL, 0x000010549d267816ULL, 0x000fe40000000026ULL,
0x000010549e277816ULL, 0x000fe40000000027ULL, 0x00000010ff257819ULL, 0x000fe4000001162cULL,
0x00000010ff247819ULL, 0x000fe4000001162dULL, 0x00000010ff2c7819ULL, 0x000fe20000011698ULL,
0x000000262818723cULL, 0x000fe20000041818ULL, 0x00000010ff2d7819ULL, 0x000fc4000001169fULL,
0x00001054252c7816ULL, 0x000fe4000000002cULL, 0x00001054242d7816ULL, 0x000fe4000000002dULL,
0x009800005a24783bULL, 0x000e620000000200ULL, 0x000000a1ffa1723eULL, 0x000fe400020006ffULL,
0x0000ffff302e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff2f7819ULL, 0x000fe20000011631ULL,
0x200000a1ffa17230ULL, 0x000fe20000004100ULL, 0x00000092ff89723eULL, 0x000fe200020006ffULL,
0x0000002c2814723cULL, 0x000fe20000041814ULL, 0x000000ff2f927812ULL, 0x000fc400078ec0ffULL,
0x00000008ff8a7819ULL, 0x000fe2000001162eULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00000010ff2e7819ULL, 0x000fe40000011686ULL, 0x00000010ff2f7819ULL, 0x000fe400000116a0ULL,
0x00000008ff917819ULL, 0x000fe40000011691ULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x00000010ff867819ULL, 0x000fc400000116a1ULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff847819ULL, 0x000fe20000011684ULL,
0x2000007aff827230ULL, 0x000fe20000004100ULL, 0x00000010ff2c7819ULL, 0x000fe40000011695ULL,
0x00000010ff2d7819ULL, 0x000fe400000116a2ULL, 0x0000007bff7b723eULL, 0x000fc400020006ffULL,
0x000010542f2e7816ULL, 0x000fe4000000002eULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x2000007bff817230ULL, 0x000fe20000004100ULL, 0x00001054862f7816ULL, 0x000fe20000000085ULL,
0x0000000025258231ULL, 0x082fe200003400ffULL, 0x00001054832c7816ULL, 0x000fe2000000002cULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x00001054842d7816ULL, 0x000fe2000000002dULL,
0x0000000027278231ULL, 0x000fe200003400ffULL, 0x00000008ff8b7819ULL, 0x000fe2000001168bULL,
0x0000002e2810723cULL, 0x000fe20000041810ULL, 0x00000010ff937819ULL, 0x000fe20000011693ULL,
0x0000006b24248231ULL, 0x080fe200003400ffULL, 0x00000010ff967819ULL, 0x000fe20000011696ULL,
0x0000006b26268231ULL, 0x000fe200003400ffULL, 0x00000010ff7e7819ULL, 0x000fc4000001167eULL,
0x00000010ff2e7819ULL, 0x000fe20000011682ULL, 0x0000002c280c723cULL, 0x000fe2000004180cULL,
0x00000010ff827819ULL, 0x000fe40000011681ULL, 0x00000010ff2f7819ULL, 0x000fe40000011694ULL,
0x00000010ff817819ULL, 0x000fe40000011680ULL, 0x00000010ff2d7819ULL, 0x000fe40000011691ULL,
0x0000008bff8b723eULL, 0x000fc400020006ffULL, 0x000010542f2e7816ULL, 0x000fe4000000002eULL,
0x00001054932f7816ULL, 0x000fe20000000082ULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x00001054812c7816ULL, 0x000fe40000000096ULL, 0x000010547e2d7816ULL, 0x000fe4000000002dULL,
0x000000ff31a47812ULL, 0x040fe200078ec0ffULL, 0x0000002e2808723cULL, 0x000fe20000041808ULL,
0x0000ffff31317812ULL, 0x000fc400078ec0ffULL, 0x00000010ff307819ULL, 0x100fe40000011632ULL,
0x000000ff32a67812ULL, 0x040fe400078ec0ffULL, 0x00000018ffa57819ULL, 0x000fe20000011632ULL,
0x0000002c2804723cULL, 0x000fe20000041804ULL, 0x0000ffff326e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff327819ULL, 0x000fe40000011633ULL, 0x000000ff33a87812ULL, 0x000fc400078ec0ffULL,
0x00000018ffa77819ULL, 0x000fe40000011633ULL, 0x00000008ff317819ULL, 0x000fe40000011631ULL,
0x0000ffff33337812ULL, 0x000fe400078ec0ffULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff007819ULL, 0x000fe4000001166fULL, 0x00000010ff8b7819ULL, 0x000fc4000001168bULL,
0x00000010ff297819ULL, 0x000fe40000011688ULL, 0x000000a3ffa3723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000031ff31723eULL, 0x000fe200020006ffULL,
0x200000a3ff877230ULL, 0x000fe20000004100ULL, 0x000000ff30307812ULL, 0x000fe200078ec0ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x000000ff32327812ULL, 0x000fe200078ec0ffULL,
0x20000031ff317230ULL, 0x000fe20000004100ULL, 0x00000008ff6e7819ULL, 0x000fc4000001166eULL,
0x00000008ff337819ULL, 0x000fe40000011633ULL, 0x0000105478287816ULL, 0x000fe4000000008bULL,
0x0000105400297816ULL, 0x000fe40000000029ULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x000000a4ff71723eULL, 0x000fe400020006ffULL, 0x000000a6ff7b723eULL, 0x000fe200020006ffULL,
0x00000028241c723cULL, 0x000fe2000004181cULL, 0x000000a8ff73723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x000000a5ff7a723eULL, 0x000fe200020006ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x000000a7ffa7723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000030ff30723eULL, 0x000fe200020006ffULL,
0x200000a7ff7c7230ULL, 0x000fe20000004100ULL, 0x00000032ff32723eULL, 0x000fe200020006ffULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000033ff33723eULL, 0x000fe200020006ffULL,
0x20000030ff307230ULL, 0x000fe20000004100ULL, 0x00000010ff797819ULL, 0x000fe20000011679ULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x00000010ff007819ULL, 0x000fe20000011687ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff297819ULL, 0x000fe20000011674ULL,
0x20000033ff337230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fc4000001168aULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff317819ULL, 0x000fe40000011631ULL,
0x00000010ff2c7819ULL, 0x000fe4000001168dULL, 0x00001054002a7816ULL, 0x000fe40000000079ULL,
0x00001054298a7816ULL, 0x000fe4000000008aULL, 0x00001054728b7816ULL, 0x000fc40000000031ULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff907819ULL, 0x000fe20000011690ULL, 0x0000008a240c723cULL, 0x000fe2000004180cULL,
0x00000010ff807819ULL, 0x000fe4000001168fULL, 0x00000010ff2b7819ULL, 0x000fe40000011670ULL,
0x00000010ff757819ULL, 0x000fc40000011675ULL, 0x00000010ff007819ULL, 0x000fe40000011677ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff8d7819ULL, 0x000fe4000001168eULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff897819ULL, 0x000fc40000011689ULL, 0x00000010ff927819ULL, 0x000fe40000011692ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff307819ULL, 0x000fe40000011630ULL,
0x00000010ff317819ULL, 0x000fe40000011673ULL, 0x00000010ff327819ULL, 0x000fe40000011632ULL,
0x00000010ff297819ULL, 0x000fc4000001167aULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff337819ULL, 0x000fe40000011633ULL,
0x0000105490907816ULL, 0x000fe4000000007dULL, 0x0000105480917816ULL, 0x000fe4000000007fULL,
0x000010542c2b7816ULL, 0x000fc4000000002bULL, 0x00001054758c7816ULL, 0x000fe4000000008cULL,
0x00001054008d7816ULL, 0x000fe2000000008dULL, 0x000000902420723cULL, 0x040fe20000041820ULL,
0x0000105489767816ULL, 0x000fe40000000076ULL, 0x0000105492777816ULL, 0x000fe40000000071ULL,
0x0000105430307816ULL, 0x000fe4000000007bULL, 0x0000105432317816ULL, 0x000fe20000000031ULL,
0x0000002a2418723cULL, 0x000fe20000041818ULL, 0x00001054296e7816ULL, 0x000fc4000000006eULL,
0x000010547c6f7816ULL, 0x000fca0000000033ULL, 0x0000008c2414723cULL, 0x040ff00000041814ULL,
0x000000762410723cULL, 0x040ff00000041810ULL, 0x000000302408723cULL, 0x040ff00000041808ULL,
0x0000006e2404723cULL, 0x000fe20000041804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200037247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008055277810ULL, 0x000fe20007ffe0ffULL,
0x00f6900056ff7f8cULL, 0x0007e2000c80043fULL, 0x00000001446b7812ULL, 0x000fc400078ec0ffULL,
0x000000342700720cULL, 0x000fda0003f06070ULL, 0x00004c5000000947ULL, 0x000fea0003800000ULL,
0x0000040067007984ULL, 0x008ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000240037007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x0000240037247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000016c6d7824ULL, 0x000fe400078e026dULL, 0x000058003e2a7a24ULL, 0x020fe200078e02ffULL,
0x00000001ff487819ULL, 0x000fe20000011636ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x000000036d007812ULL, 0x000fc800078ec0ffULL, 0x000000030000780cULL, 0x000fc80003f05270ULL,
0x000000013f467807ULL, 0x000fca0004000000ULL, 0x000000016d467824ULL, 0x000fe400078e0246ULL,
0x0000002048007824ULL, 0x000fc600078e0255ULL, 0x000000034600720cULL, 0x000fe40003f06070ULL,
0x000000c000007810ULL, 0x000fc80007ffe0ffULL, 0x0000000034277217ULL, 0x000fe40007800000ULL,
0x000000203b267812ULL, 0x000fca00078ef800ULL, 0x0000000143248824ULL, 0x000fe400078e0246ULL,
0x00000004ff258424ULL, 0x000fe200078e00ffULL, 0x0000000135297810ULL, 0x000fe20007ffe0ffULL,
0x0000000127277824ULL, 0x000fe400078e0a00ULL, 0x0000600024248625ULL, 0x000fe200078e0025ULL,
0x000000022900720cULL, 0x000fc60003f46070ULL, 0x000000402a2b7824ULL, 0x000fe200078e00ffULL,
0x00000006243e8981ULL, 0x000562000c1e1900ULL, 0x0000000149007824ULL, 0x000fe200078e0226ULL,
0x0000002027277807ULL, 0x000fe20001000000ULL, 0x0000001036287824ULL, 0x000fe200078e00ffULL,
0x00000003ff2f7819ULL, 0x000fe20000011642ULL, 0x00000000610473c2ULL, 0x000ee200000e0000ULL,
0x000000002b007210ULL, 0x000fe40007f1e0ffULL, 0x0000001028287812ULL, 0x000fe200078ec0ffULL,
0x000000014b247824ULL, 0x104fe200078e0226ULL, 0x000000042f317810ULL, 0x000fe20007ffe0ffULL,
0x000000014d257824ULL, 0x100fe200078e0226ULL, 0x0000002728277217ULL, 0x000fe20007800000ULL,
0x000000014f267824ULL, 0x000fe200078e0226ULL, 0x000000242b297210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e06ffULL, 0x00005e0000307a11ULL, 0x000fc400078038ffULL,
0x000000252b257210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0x000000262b267210ULL, 0x000fe40007f9e0ffULL, 0x00005f00002d7a11ULL, 0x000fe200000f3c2dULL,
0x0000000127007824ULL, 0x000fe200078e0a28ULL, 0x00005e00292c7a11ULL, 0x000fe200078038ffULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x00005e0025287a11ULL, 0x000fe200078438ffULL,
0x000000ffff2b7224ULL, 0x000fe200020e06ffULL, 0x00005e00262a7a11ULL, 0x000fc400078638ffULL,
0x00005f0029277a11ULL, 0x000fe400000f3c2eULL, 0x00005f0025297a11ULL, 0x000fe400010f3c24ULL,
0x00005f00262b7a11ULL, 0x000fe400018f3c2bULL, 0x000000082f257810ULL, 0x040fe40007ffe0ffULL,
0x0000005130247210ULL, 0x000fe40007f9e0ffULL, 0x000000002f00720cULL, 0x000fc40003f66070ULL,
0x0000000c2f2f7810ULL, 0x000fe40007ffe0ffULL, 0x000000512c267210ULL, 0x080fe40007fbe0ffULL,
0x000000003100720cULL, 0x080fe40003f46070ULL, 0x000000002500720cULL, 0x080fe20003f06070ULL,
0x000000ffff257224ULL, 0x000fe200020e062dULL, 0x000000002f00720cULL, 0x000fe20003f86070ULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x0000005128287210ULL, 0x000fc40007fde0ffULL,
0x000000512a2a7210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000245d7faeULL, 0x0005e4000d901c46ULL, 0x000000ffff297224ULL, 0x000fe400030e0629ULL,
0x000000ffff2b7224ULL, 0x000fe200028e062bULL, 0x00000000265e7faeULL, 0x0005e8000d101c46ULL,
0x00000000285f7faeULL, 0x0005e8000c101c46ULL, 0x000000002a607faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x008fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000061307f8cULL, 0x000728000c80043fULL, 0x0000040062007984ULL, 0x0006620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6480047247f8cULL, 0x004fe2000c80043fULL, 0x8000000000ff7812ULL, 0x002fc60007844869ULL,
0x00f64c0047277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0xffffffe040477812ULL, 0x040fe200078ec0ffULL,
0x3e000000ff007424ULL, 0x000fe200078e00ffULL, 0x0000001040267812ULL, 0x040fe400078ec0ffULL,
0x0000000840277812ULL, 0x000fc800078ec0ffULL, 0x0000004727477210ULL, 0x000fe40007ffe026ULL,
0x0000000000267305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000260000735dULL, 0x004fe20003800000ULL, 0x00f64c0047277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002036007824ULL, 0x000fca00078e00ffULL, 0xffffff8000007812ULL, 0x000fc800078ec0ffULL,
0x0000010051257810ULL, 0x000fca0007ffe000ULL, 0x0000000152257824ULL, 0x000fca00078e0225ULL,
0x00f0000025007984ULL, 0x000e680000000800ULL, 0x00f2000025267984ULL, 0x0004e20000000800ULL,
0x000000390000720bULL, 0x002fe20003f1d000ULL, 0x0000dc327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x004fc800000e0100ULL, 0x0000ffff24297812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2c7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000241257810ULL, 0x000fe40007ffe0ffULL,
0x000000390000720bULL, 0x000fe40003f14000ULL, 0x000000362500720cULL, 0x000fe20003f65270ULL,
0x0000dbf27f007947ULL, 0x000ff4000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x0000000039287209ULL, 0x040fe20007810000ULL, 0x000000803627b824ULL, 0x000fe200078e0251ULL,
0x0000ffff24247812ULL, 0x000fe400078e3cffULL, 0x00000002ff6e7819ULL, 0x000fe20000011642ULL,
0x000000015227b824ULL, 0x000fe200078e0227ULL, 0x8000002839257221ULL, 0x000fe20000010000ULL,
0x0000002429ff7212ULL, 0x000fc6000780c0ffULL, 0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL,
0x00f400282700b388ULL, 0x0003e60000000800ULL, 0x00000025002b7308ULL, 0x000ea40000000800ULL,
0x0000002b38387220ULL, 0x004fe20000410000ULL, 0x0000db727f007947ULL, 0x000fea000b800000ULL,
0x00001f6e2b247589ULL, 0x0022a400000e0000ULL, 0x0000002420207220ULL, 0x084fe20000410000ULL,
0x0000002421217220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002408087220ULL, 0x080fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x0000002404047220ULL, 0x080fe20000410000ULL,
0x0000002405057220ULL, 0x000fe20000410000ULL, 0x0000dab27f007947ULL, 0x000fea000b800000ULL,
0x00001f542b247589ULL, 0x00046400000e0000ULL, 0x0000000039397209ULL, 0x000fe20007810000ULL,
0x0000002422227220ULL, 0x082fe20000410000ULL, 0x00000001ff2c7807ULL, 0x000fe20000000000ULL,
0x0000002423237220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x8000003900000221ULL, 0x000fe20000010000ULL, 0x000000241f1f7220ULL, 0x080fe20000410000ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x0000000000450308ULL, 0x000e620000000800ULL, 0x0000002413137220ULL, 0x080fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x000000240f0f7220ULL, 0x080fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x0000002406067220ULL, 0x080fe20000410000ULL, 0x0000002407077220ULL, 0x000fe20000410000ULL,
0x0000002645260220ULL, 0x00afc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0x0000003826387221ULL, 0x008fe20000010000ULL,
0x000000f000002947ULL, 0x000fea0003800000ULL, 0x000000086a007812ULL, 0x000fe400078ec0ffULL,
0xfffffff040257812ULL, 0x000fca00078ec0ffULL, 0x0000000125007824ULL, 0x000fcc00078e0200ULL,
0x00f6ac0000007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x0000040062247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff6e7819ULL, 0x000fe40000011642ULL,
0x00000045ff00723eULL, 0x000fe400000010ffULL, 0x000000186e267810ULL, 0x040fe40007ffe0ffULL,
0x000000106e277810ULL, 0x000fe40007ffe0ffULL, 0x00005410002b7816ULL, 0x004fe20000000000ULL,
0x0000d8127f007947ULL, 0x000fea000b800000ULL, 0x00001f6e2b337589ULL, 0x0002a400000e0000ULL,
0x0000d8527f007947ULL, 0x000fea000b800000ULL, 0x00001f542b007589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6e7224ULL, 0x002fe200078e0027ULL,
0x000070e000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000e09000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6e7224ULL, 0x002fe200078e0026ULL,
0x0000714000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000e03000007944ULL, 0x03cfea0003c00000ULL,
0x0000100036247824ULL, 0x000fe200078e00ffULL, 0x00001000682d7812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000099102c2c7816ULL, 0x000fe400000000ffULL,
0xffffe00024247812ULL, 0x000fe400078ec0ffULL, 0x000000ff2c00720cULL, 0x000fc40003f05270ULL,
0x0000b00024287810ULL, 0x100fe40007ffe02dULL, 0x0000b0003a2d7810ULL, 0x000fc60007ffe02dULL,
0x000000105c247824ULL, 0x100fe400078e0228ULL, 0x0000001059287824ULL, 0x000fe400078e0228ULL,
0x00000010585c7824ULL, 0x100fe400078e022dULL, 0x000000002424783bULL, 0x000ee20000004200ULL,
0x00000010572d7824ULL, 0x000fc600078e022dULL, 0x000000002828783bULL, 0x00ee680000004200ULL,
0x000000005c5c783bULL, 0x000ea80000004200ULL, 0x000000002d2c783bULL, 0x000ee20000004200ULL,
0x00000010ff8f7819ULL, 0x000fe40000011624ULL, 0x000000ff24737812ULL, 0x000fc400078ec0ffULL,
0x00000018ff727819ULL, 0x000fe40000011624ULL, 0x0000ffff247c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff797819ULL, 0x100fe40000011625ULL, 0x000000ff25757812ULL, 0x040fe400078ec0ffULL,
0x00000018ff747819ULL, 0x000fe40000011625ULL, 0x0000ffff258e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff247819ULL, 0x102fe40000011628ULL, 0x000000ff287f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fe40000011628ULL, 0x0000ffff287b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff257819ULL, 0x000fe40000011629ULL, 0x000000ff29807812ULL, 0x000fc400078ec0ffULL,
0x00000018ff287819ULL, 0x000fe40000011629ULL, 0x0000ffff297a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff297819ULL, 0x000fe4000001162aULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000029ff29723eULL, 0x000fe200020006ffULL,
0x20000080ff867230ULL, 0x000fe20000004100ULL, 0x00000010ff8b7819ULL, 0x100fe20000011626ULL,
0x20000028ff847230ULL, 0x000fe20000004100ULL, 0x000000ff26777812ULL, 0x000fe200078ec0ffULL,
0x20000029ff807230ULL, 0x000fe20000004100ULL, 0x00000018ff767819ULL, 0x000fc40000011626ULL,
0x0000ffff26897812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x100fe40000011627ULL,
0x000000ff277d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff787819ULL, 0x000fe40000011627ULL,
0x0000ffff278a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff267819ULL, 0x000fc4000001162aULL,
0x000000ff2a817812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2a707812ULL, 0x000fe400078ec0ffULL,
0x0000ffff5c9b7812ULL, 0x004fe400078ec0ffULL, 0x0000ffff5d9c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff277819ULL, 0x000fe4000001162bULL, 0x000000ff2b827812ULL, 0x000fc400078ec0ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001162bULL, 0x0000ffff2b717812ULL, 0x000fe400078ec0ffULL,
0x00000018ff2b7819ULL, 0x000fe4000001165cULL, 0x00000008ff287819ULL, 0x000fe4000001169bULL,
0x00000008ff297819ULL, 0x000fe4000001169cULL, 0x00000010ff927819ULL, 0x000fc4000001165cULL,
0x000000ff5c327812ULL, 0x000fe400078ec0ffULL, 0x00000010ff957819ULL, 0x100fe4000001165dULL,
0x000000ff5d587812ULL, 0x000fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe4000001165dULL,
0x00000010ff977819ULL, 0x000fe4000001165eULL, 0x000000ff5e5c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001165eULL, 0x0000ffff5e9d7812ULL, 0x000fe400078ec0ffULL,
0x0000002bff2b723eULL, 0x000fe400020006ffULL, 0x00000010ff987819ULL, 0x100fe4000001165fULL,
0x000000ff5f607812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5e7819ULL, 0x000fc4000001165fULL,
0x0000ffff5f9e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff2c687812ULL, 0x008fe400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001162cULL, 0x20000072ff937230ULL, 0x000fe20000004100ULL,
0x00000028ff28723eULL, 0x000fe200020006ffULL, 0x20000074ff967230ULL, 0x000fe20000004100ULL,
0x00000029ff29723eULL, 0x000fc400020006ffULL, 0x00000057ff59723eULL, 0x000fe200020006ffULL,
0x2000002bff577230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000028ff727230ULL, 0x000fe20000004100ULL, 0x0000005fff2b723eULL, 0x000fe200020006ffULL,
0x20000029ff747230ULL, 0x000fe20000004100ULL, 0x00000008ff287819ULL, 0x000fe2000001169dULL,
0x20000068ff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff297819ULL, 0x000fe2000001169eULL,
0x2000002bff687230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x20000073ff917230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000075ff947230ULL, 0x000fe20000004100ULL, 0x00000082ff2b723eULL, 0x000fe200020006ffULL,
0x2000007fff857230ULL, 0x000fe20000004100ULL, 0x0000002aff2a723eULL, 0x000fe200020006ffULL,
0x20000081ff827230ULL, 0x000fe20000004100ULL, 0x00000028ff28723eULL, 0x000fe200020006ffULL,
0x2000002bff817230ULL, 0x000fe20000004100ULL, 0x00000029ff29723eULL, 0x000fe200020006ffULL,
0x2000002aff7f7230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x20000028ff757230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000029ff737230ULL, 0x000fe20000004100ULL, 0x000000ff2f837812ULL, 0x000fe200078ec0ffULL,
0x00a000006628783bULL, 0x000e620000000200ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x20000058ff6f7230ULL, 0x000fe20000004100ULL, 0x000000ff2d6a7812ULL, 0x000fe200078ec0ffULL,
0x20000059ff587230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x2000005cff597230ULL, 0x000fe20000004100ULL, 0x000000ff2e6c7812ULL, 0x000fe200078ec0ffULL,
0x20000060ff5c7230ULL, 0x000fe20000004100ULL, 0x00000018ff6b7819ULL, 0x000fe2000001162eULL,
0x2000007dff907230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fc400020006ffULL,
0x000000ff95957812ULL, 0x000fe400078ec0ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x0000006aff60723eULL, 0x000fe400020006ffULL, 0x0000006cff6a723eULL, 0x000fe400020006ffULL,
0x000000ff92927812ULL, 0x000fe200078ec0ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x0000ffff2c9f7812ULL, 0x000fe200078ec0ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x0000006bff6c723eULL, 0x000fe200020006ffULL, 0x20000083ff6b7230ULL, 0x000fe20000004100ULL,
0x00000095ff7d723eULL, 0x000fe200020006ffULL, 0x2000007eff837230ULL, 0x000fe20000004100ULL,
0x00000078ff78723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x000000ff79957812ULL, 0x000fe200078ec0ffULL, 0x20000078ff887230ULL, 0x000fe20000004100ULL,
0x00000092ff7e723eULL, 0x000fc400020006ffULL, 0x000000ff97977812ULL, 0x000fe400078ec0ffULL,
0x00000008ff927819ULL, 0x000fe2000001169fULL, 0x0000003328288231ULL, 0x082fe200003400ffULL,
0x00000010ff997819ULL, 0x000fe2000001162cULL, 0x000000332a2a8231ULL, 0x000fe200003400ffULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x0000000029298231ULL, 0x080fe200003400ffULL,
0x00000095ff95723eULL, 0x000fe200020006ffULL, 0x000000002b2b8231ULL, 0x000fe200003400ffULL,
0x00000008ff8a7819ULL, 0x000fe2000001168aULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x20000095ff957230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x00000097ff78723eULL, 0x000fe200020006ffULL, 0x20000077ff8d7230ULL, 0x000fe20000004100ULL,
0x00000092ff97723eULL, 0x000fe200020006ffULL, 0x20000076ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff7c7819ULL, 0x000fe2000001167cULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x000000ff98987812ULL, 0x000fc400078ec0ffULL, 0x000000ff99997812ULL, 0x000fe400078ec0ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x0000007cff92723eULL, 0x000fe200020006ffULL,
0x20000097ff7c7230ULL, 0x000fe20000004100ULL, 0x00000098ff76723eULL, 0x000fe200020006ffULL,
0x2000008aff977230ULL, 0x000fe20000004100ULL, 0x00000099ff77723eULL, 0x000fe200020006ffULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000008ff8e7819ULL, 0x000fe2000001168eULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x000000ff24987812ULL, 0x000fe200078ec0ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x000000ff25997812ULL, 0x000fc400078ec0ffULL,
0x00000010ff247819ULL, 0x000fe40000011691ULL, 0x00000010ff257819ULL, 0x000fe40000011694ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff8a7819ULL, 0x000fe40000011695ULL,
0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8c8c7812ULL, 0x000fc400078ec0ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x000010548f247816ULL, 0x000fe40000000024ULL,
0x000010548a257816ULL, 0x000fe20000000025ULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ff7b7819ULL, 0x000fe4000001167bULL, 0x00000008ff7a7819ULL, 0x000fe4000001167aULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x000000242820723cULL, 0x000fe20000041820ULL,
0x0000008cff8c723eULL, 0x000fc400020006ffULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000008ff897819ULL, 0x000fe20000011689ULL,
0x2000007bff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe2000001168eULL,
0x2000007aff8e7230ULL, 0x000fe20000004100ULL, 0x000000ff267a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff277b7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff967819ULL, 0x000fe40000011696ULL, 0x00000010ff247819ULL, 0x000fe40000011692ULL,
0x00000010ff267819ULL, 0x000fe4000001168dULL, 0x00000010ff277819ULL, 0x000fe40000011690ULL,
0x00000010ff8b7819ULL, 0x000fc4000001168bULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000105493247816ULL, 0x000fe40000000024ULL,
0x0000105496257816ULL, 0x000fe20000000025ULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x000010548b267816ULL, 0x000fe40000000026ULL, 0x000010548c277816ULL, 0x000fc40000000027ULL,
0x00000098ff98723eULL, 0x000fe200020006ffULL, 0x00000024281c723cULL, 0x040fe2000004181cULL,
0x00000099ff99723eULL, 0x000fe400020006ffULL, 0x0000007aff8d723eULL, 0x000fe200020006ffULL,
0x20000098ff987230ULL, 0x000fe20000004100ULL, 0x0000007bff8f723eULL, 0x000fe200020006ffULL,
0x20000099ff997230ULL, 0x000fe20000004100ULL, 0x00000010ff877819ULL, 0x000fe20000011687ULL,
0x000000262818723cULL, 0x000fe20000041818ULL, 0x00000010ff887819ULL, 0x000fe20000011688ULL,
0x00a000005a24783bULL, 0x000e620000000200ULL, 0x00000010ff7a7819ULL, 0x000fe20000011689ULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000010ff7b7819ULL, 0x000fe20000011697ULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x00001054877a7816ULL, 0x000fc4000000007aULL,
0x00001054887b7816ULL, 0x000fe4000000007bULL, 0x00000008ff877819ULL, 0x000fe40000011670ULL,
0x00000008ff887819ULL, 0x000fe40000011671ULL, 0x00000010ff707819ULL, 0x000fe20000011685ULL,
0x0000007a2814723cULL, 0x000fe20000041814ULL, 0x00000010ff717819ULL, 0x000fe40000011698ULL,
0x00000010ff867819ULL, 0x000fc40000011686ULL, 0x00000010ff997819ULL, 0x000fe40000011699ULL,
0x0000105471707816ULL, 0x000fe40000000070ULL, 0x0000105499717816ULL, 0x000fe40000000086ULL,
0x00000032ff6e723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x000000702810723cULL, 0x000fe20000041810ULL,
0x00000010ff837819ULL, 0x000fe20000011683ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fe2000001168aULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000010ff817819ULL, 0x000fe20000011681ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fc4000001168fULL, 0x00001054838a7816ULL, 0x000fe2000000008aULL,
0x0000003324248231ULL, 0x082fe200003400ffULL, 0x0000105470837816ULL, 0x000fe20000000081ULL,
0x0000003326268231ULL, 0x000fe200003400ffULL, 0x00000010ff707819ULL, 0x000fe2000001166eULL,
0x0000000025258231ULL, 0x080fe200003400ffULL, 0x00000010ff847819ULL, 0x000fe20000011684ULL,
0x0000000027278231ULL, 0x000fe200003400ffULL, 0x00000010ff8b7819ULL, 0x000fe4000001168eULL,
0x00000010ff827819ULL, 0x000fc40000011682ULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff6e7819ULL, 0x000fe4000001167fULL, 0x00000010ff817819ULL, 0x000fe40000011688ULL,
0x00001054848b7816ULL, 0x000fc4000000008bULL, 0x000010548d827816ULL, 0x000fe40000000082ULL,
0x0000105480807816ULL, 0x000fe40000000087ULL, 0x000010546e817816ULL, 0x000fe20000000081ULL,
0x0000008a280c723cULL, 0x000fe2000004180cULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff727819ULL, 0x000fc40000011672ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x000000822808723cULL, 0x040fe20000041808ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000010ff9a7819ULL, 0x100fe2000001162dULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000018ff697819ULL, 0x000fe2000001162dULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x0000ffff2d2d7812ULL, 0x000fe200078ec0ffULL,
0x000000802804723cULL, 0x000fe20000041804ULL, 0x00000010ff2c7819ULL, 0x000fc4000001162eULL,
0x0000ffff2e327812ULL, 0x000fe400078ec0ffULL, 0x00000010ff2e7819ULL, 0x000fe4000001162fULL,
0x00000010ff297819ULL, 0x000fe40000011674ULL, 0x0000105457287816ULL, 0x000fe40000000072ULL,
0x0000105458297816ULL, 0x000fe40000000029ULL, 0x00000018ff6d7819ULL, 0x000fc4000001162fULL,
0x00000008ff2d7819ULL, 0x000fe4000001162dULL, 0x0000ffff2f2f7812ULL, 0x000fe200078ec0ffULL,
0x00000028241c723cULL, 0x000fe2000004181cULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff2b7819ULL, 0x000fe4000001165cULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff767819ULL, 0x000fc40000011676ULL, 0x00000010ff007819ULL, 0x000fe4000001165dULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff297819ULL, 0x000fe40000011673ULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x000000ff2c2c7812ULL, 0x000fc400078ec0ffULL, 0x0000002dff2d723eULL, 0x000fe200020006ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x000000ff9a9a7812ULL, 0x000fe400078ec0ffULL,
0x00001054782a7816ULL, 0x000fe20000000059ULL, 0x2000002dff2d7230ULL, 0x000fe20000004100ULL,
0x00001054762b7816ULL, 0x000fe4000000002bULL, 0x000000ff2e2e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff327819ULL, 0x000fc40000011632ULL, 0x00000008ff2f7819ULL, 0x000fe2000001162fULL,
0x0000002a2418723cULL, 0x040fe20000041818ULL, 0x0000105400287816ULL, 0x000fe40000000075ULL,
0x000010545e297816ULL, 0x000fe40000000029ULL, 0x0000002cff2c723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x0000009aff9a723eULL, 0x000fe200020006ffULL,
0x2000002cff337230ULL, 0x000fe20000004100ULL, 0x0000002eff2e723eULL, 0x000fe200020006ffULL,
0x000000282414723cULL, 0x000fe20000041814ULL, 0x00000032ff32723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x000fe2000001165fULL,
0x2000009aff797230ULL, 0x000fe20000004100ULL, 0x00000010ff007819ULL, 0x000fe20000011677ULL,
0x2000002eff2e7230ULL, 0x000fe20000004100ULL, 0x0000002fff2f723eULL, 0x000fe200020006ffULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x00001054002a7816ULL, 0x000fc4000000005fULL,
0x00000010ff297819ULL, 0x000fe20000011668ULL, 0x2000002fff2f7230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff007819ULL, 0x000fe40000011669ULL,
0x00000010ff2d7819ULL, 0x000fe4000001162dULL, 0x00000010ff7a7819ULL, 0x000fe4000001167dULL,
0x00000010ff717819ULL, 0x000fc4000001166fULL, 0x00001054297c7816ULL, 0x000fe4000000007cULL,
0x00001054007d7816ULL, 0x000fe4000000002dULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff337819ULL, 0x000fe40000011633ULL, 0x00000010ff6f7819ULL, 0x000fe2000001167eULL,
0x0000007c240c723cULL, 0x000fe2000004180cULL, 0x00000010ff2b7819ULL, 0x000fc40000011660ULL,
0x00000010ff2c7819ULL, 0x000fe40000011679ULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff2e7819ULL, 0x000fe4000001162eULL, 0x00000010ff297819ULL, 0x000fe4000001166cULL,
0x00000010ff327819ULL, 0x000fe40000011632ULL, 0x00000010ff007819ULL, 0x000fc4000001166dULL,
0x00000010ff2f7819ULL, 0x000fe4000001162fULL, 0x00001054336a7816ULL, 0x000fe4000000006aULL,
0x000010546f707816ULL, 0x000fe40000000070ULL, 0x000010547a717816ULL, 0x000fe40000000071ULL,
0x000010542c2b7816ULL, 0x000fe4000000002bULL, 0x000010542e6b7816ULL, 0x000fc4000000006bULL,
0x0000105429327816ULL, 0x000fe20000000032ULL, 0x000000702420723cULL, 0x000fe20000041820ULL,
0x0000105400337816ULL, 0x000fce000000002fULL, 0x0000002a2410723cULL, 0x040ff00000041810ULL,
0x0000006a2408723cULL, 0x040ff00000041808ULL, 0x000000322404723cULL, 0x000fe20000041804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200037247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c055557810ULL, 0x000fe20007ffe0ffULL, 0x00f6980056ff7f8cULL, 0x0007e2000c80043fULL,
0x00000001446b7812ULL, 0x000fe200078e0cffULL, 0x000000ffff697224ULL, 0x010fe200078e0031ULL,
0x000000345500720cULL, 0x000fda0003f06070ULL, 0x000025d000000947ULL, 0x000fea0003800000ULL,
0x0000040067007984ULL, 0x008ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000240037007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x0000240037247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000346007812ULL, 0x000fe200078ec0ffULL, 0x000058003e287a24ULL, 0x020fe200078e02ffULL,
0x0000030035277a10ULL, 0x000fe20007ffe0ffULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x000000030000780cULL, 0x000fc80003f05270ULL, 0x000000013f257807ULL, 0x000fca0004000000ULL,
0x0000000146467824ULL, 0x000fca00078e0225ULL, 0x000000034600720cULL, 0x000fe20003f06070ULL,
0x0000010027007824ULL, 0x040fe200078e023cULL, 0x0000000127277810ULL, 0x000fc80007ffe0ffULL,
0x0000000034297217ULL, 0x000fe40007800000ULL, 0x000000203b267812ULL, 0x000fca00078ef800ULL,
0x0000000143248824ULL, 0x000fe400078e0246ULL, 0x00000004ff258424ULL, 0x000fc800078e00ffULL,
0x0000600024248625ULL, 0x000fc800078e0025ULL, 0x0000000129297824ULL, 0x000fe200078e0a00ULL,
0x00000006243e8981ULL, 0x000562000c1e1900ULL, 0x00000040282c7824ULL, 0x000fe200078e00ffULL,
0x000000022700720cULL, 0x000fe20003f06070ULL, 0x000000014b4b7824ULL, 0x000fe200078e0226ULL,
0x00000003ff327819ULL, 0x000fe20000011642ULL, 0x0000001036007824ULL, 0x000fe200078e00ffULL,
0x0000002029297807ULL, 0x000fe20000000000ULL, 0x0000000149497824ULL, 0x100fe200078e0226ULL,
0x0000004b2c4b7210ULL, 0x000fe20007f5e0ffULL, 0x000000014d4d7824ULL, 0x100fe200078e0226ULL,
0x00000010002a7812ULL, 0x000fe200078ec0ffULL, 0x000000014f267824ULL, 0x000fe200078e0226ULL,
0x000000492c497210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200010e06ffULL,
0x000000292a297217ULL, 0x000fe20007800000ULL, 0x00000000620473c2ULL, 0x000ee200000e0000ULL,
0x000000262c267210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff287224ULL, 0x000fe200000e06ffULL,
0x00005e004b2e7a11ULL, 0x000fe200078438ffULL, 0x0000000129297824ULL, 0x000fe200078e0a2aULL,
0x0000004d2c4d7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff257224ULL, 0x004fe200020e06ffULL,
0x00005f004b277a11ULL, 0x000fc400010f3c00ULL, 0x00005e00262a7a11ULL, 0x040fe200078438ffULL,
0x000000ffff2c7224ULL, 0x000fe200018e06ffULL, 0x00005e0049247a11ULL, 0x040fe400078038ffULL,
0x00005f0026007a11ULL, 0x000fe200010f3c25ULL, 0x0000100044257824ULL, 0x000fe200078e00ffULL,
0x000000512e267210ULL, 0x000fe40007fbe0ffULL, 0x00005f00492d7a11ULL, 0x000fe400000f3c28ULL,
0x00005e004d287a11ULL, 0x000fe200078038ffULL, 0x000000ffff277224ULL, 0x000fe200028e0627ULL,
0x00000004325c7810ULL, 0x000fc40007ffe0ffULL, 0x0000100025257812ULL, 0x000fe400078ec0ffULL,
0x0000005124247210ULL, 0x000fe40007f9e0ffULL, 0x0000000832587810ULL, 0x040fe40007ffe0ffULL,
0x000000293200720cULL, 0x040fe40003f66070ULL, 0x0000000c32327810ULL, 0x000fe40007ffe0ffULL,
0x00005f004d2c7a11ULL, 0x000fc400000f3c2cULL, 0x0000005128287210ULL, 0x000fe40007fbe0ffULL,
0x000000295c00720cULL, 0x080fe40003f46070ULL, 0x0000b0003a2b7810ULL, 0x000fe20007ffe025ULL,
0x000000ffff257224ULL, 0x000fe200020e062dULL, 0x000000295800720cULL, 0x080fe40003f06070ULL,
0x000000293200720cULL, 0x000fe20003f86070ULL, 0x000000ffff297224ULL, 0x000fe200028e062cULL,
0x000000512a2a7210ULL, 0x000fe20007fbe0ffULL, 0x000000104a2d7824ULL, 0x000fc400078e022bULL,
0x000000104c2f7824ULL, 0x100fe400078e022bULL, 0x000000104e337824ULL, 0x100fe200078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242d7faeULL, 0x0005e2000d901c46ULL,
0x0000001050497824ULL, 0x000fe400078e022bULL, 0x000000ffff2b7224ULL, 0x000fe200028e0600ULL,
0x00000000262f7faeULL, 0x0005e8000d101c46ULL, 0x0000000028337faeULL, 0x0005e8000c101c46ULL,
0x000000002a497faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000062687f8cULL, 0x000728000c80043fULL,
0x0000040061277984ULL, 0x0046a20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6680047247f8cULL, 0x000fe2000c80043fULL,
0x8000000027ff7812ULL, 0x004fc60007844831ULL, 0x00f66c0047297984ULL, 0x000ea40000000800ULL,
0x8000000029ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x000464000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000260000735dULL, 0x002fe20003800000ULL,
0x00f66c0047277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002036007824ULL, 0x000fca00078e00ffULL,
0xffffff8000007812ULL, 0x000fc800078ec0ffULL, 0x0000018051257810ULL, 0x000fca0007ffe000ULL,
0x0000000152257824ULL, 0x000fca00078e0225ULL, 0x00f0000025007984ULL, 0x000ea80000000800ULL,
0x00f2000025267984ULL, 0x0002e20000000800ULL, 0x000000390000720bULL, 0x004fe20003f1d000ULL,
0x0000b7e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x002fc800000e0100ULL,
0x0000ffff24297812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff287424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000341257810ULL, 0x000fe40007ffe0ffULL, 0x000000390000720bULL, 0x000fe40003f14000ULL,
0x000000362500720cULL, 0x000fe20003f65270ULL, 0x0000b7a27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x0000000039277209ULL, 0x040fe20007810000ULL,
0x000000803651b824ULL, 0x000fe200078e0251ULL, 0x0000ffff24247812ULL, 0x000fe400078e3cffULL,
0x00000002ff6e7819ULL, 0x000fe20000011642ULL, 0x000000015252b824ULL, 0x000fe200078e0251ULL,
0x8000002739257221ULL, 0x000fe20000010000ULL, 0x0000002429ff7212ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL, 0x00f400275200b388ULL, 0x0003e60000000800ULL,
0x00000025002b7308ULL, 0x000ea40000000800ULL, 0x0000002b38387220ULL, 0x004fe20000410000ULL,
0x0000b7227f007947ULL, 0x000fea000b800000ULL, 0x00001f6e2b247589ULL, 0x0022a400000e0000ULL,
0x0000002420207220ULL, 0x084fe20000410000ULL, 0x0000002421217220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x000000240c0c7220ULL, 0x080fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x0000002404047220ULL, 0x080fe20000410000ULL, 0x0000002405057220ULL, 0x000fe20000410000ULL,
0x0000b6627f007947ULL, 0x000fea000b800000ULL, 0x00001f542b247589ULL, 0x00046400000e0000ULL,
0x8000002700000221ULL, 0x100fe20000010000ULL, 0x00000001ff287807ULL, 0x000fe20000000000ULL,
0x0000002422227220ULL, 0x082fe20000410000ULL, 0x0000002423237220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b00000820ULL, 0x000fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x0000000000450308ULL, 0x000e620000000800ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x0000002416167220ULL, 0x080fe20000410000ULL, 0x0000002417177220ULL, 0x080fe20000410000ULL,
0x0000002412127220ULL, 0x080fe20000410000ULL, 0x0000002413137220ULL, 0x080fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x000000240f0f7220ULL, 0x080fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x0000002406067220ULL, 0x080fe20000410000ULL, 0x0000002407077220ULL, 0x000fe20000410000ULL,
0x000000ffff397224ULL, 0x000fe200078e0027ULL, 0x0000002645260220ULL, 0x00afc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000003826387221ULL, 0x008fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x0000000844007824ULL, 0x000fe200078e00ffULL, 0xfffffff040257812ULL, 0x000fc800078ec0ffULL,
0x0000000800007812ULL, 0x000fca00078e0cffULL, 0x0000000125257824ULL, 0x000fcc00078e0200ULL,
0x00f6ac0025257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x008fe20003800000ULL,
0x0000040061257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff6e7819ULL, 0x000fe40000011642ULL,
0x00000045ff24723eULL, 0x000fe400000010ffULL, 0x000000186e007810ULL, 0x040fe40007ffe0ffULL,
0x000000106e267810ULL, 0x000fe40007ffe0ffULL, 0x00005410242b7816ULL, 0x004fe20000000024ULL,
0x0000b3b27f007947ULL, 0x000fea000b800000ULL, 0x00001f6e2b297589ULL, 0x0002a400000e0000ULL,
0x0000b3f27f007947ULL, 0x000fea000b800000ULL, 0x00001f542b547589ULL, 0x00066400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6e7224ULL, 0x002fe200078e0026ULL,
0x0000978000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000b9f000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6e7224ULL, 0x002fe200078e0000ULL,
0x000097e000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000b99000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006430783bULL, 0x000ee20000004200ULL,
0x0000991028007816ULL, 0x000fc600000000ffULL, 0x000000006524783bULL, 0x000f220000004200ULL,
0x000000ff0000720cULL, 0x000fc60003f05270ULL, 0x000000005b2c783bULL, 0x000ea80000004200ULL,
0x000000006360783bULL, 0x000e620000004200ULL, 0x00000010ff477819ULL, 0x108fe40000011630ULL,
0x000000ff30287812ULL, 0x040fe400078ec0ffULL, 0x00000018ff007819ULL, 0x000fe40000011630ULL,
0x0000ffff30817812ULL, 0x000fc400078ec0ffULL, 0x00000010ff4a7819ULL, 0x100fe40000011631ULL,
0x000000ff312b7812ULL, 0x042fe400078ec0ffULL, 0x00000018ff2a7819ULL, 0x004fe40000011631ULL,
0x0000ffff31827812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6e7819ULL, 0x000fe40000011632ULL,
0x000000ff32317812ULL, 0x000fc400078ec0ffULL, 0x00000018ff307819ULL, 0x000fe40000011632ULL,
0x0000ffff32837812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6f7819ULL, 0x100fe40000011633ULL,
0x000000ff33497812ULL, 0x040fe400078ec0ffULL, 0x00000018ff327819ULL, 0x000fe40000011633ULL,
0x0000ffff33847812ULL, 0x000fc400078ec0ffULL, 0x00000010ff747819ULL, 0x110fe40000011624ULL,
0x000000ff244b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff337819ULL, 0x000fe40000011624ULL,
0x0000ffff24857812ULL, 0x000fe400078ec0ffULL, 0x00000018ff247819ULL, 0x000fe40000011625ULL,
0x000000ff264e7812ULL, 0x000fc400078ec0ffULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x000000ff274f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff757819ULL, 0x000fe20000011625ULL,
0x20000024ff557230ULL, 0x000fe20000004100ULL, 0x000000ff254d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff25867812ULL, 0x000fe400078ec0ffULL, 0x00000018ff257819ULL, 0x000fc40000011626ULL,
0x000000ff47247812ULL, 0x000fe400078ec0ffULL, 0x00000010ff797819ULL, 0x000fe40000011626ULL,
0x0000ffff26877812ULL, 0x000fe400078ec0ffULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000010ff7a7819ULL, 0x100fe20000011627ULL,
0x2000004eff507230ULL, 0x000fe20000004100ULL, 0x00000018ff267819ULL, 0x000fe20000011627ULL,
0x2000004fff527230ULL, 0x000fe20000004100ULL, 0x0000ffff27887812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7d7819ULL, 0x100fe4000001162cULL, 0x000000ff2c517812ULL, 0x040fe400078ec0ffULL,
0x00000018ff277819ULL, 0x000fe4000001162cULL, 0x0000ffff2c897812ULL, 0x000fe400078ec0ffULL,
0x000000ff2d6d7812ULL, 0x000fe400078ec0ffULL, 0x00000025ff25723eULL, 0x000fc400020006ffULL,
0x00000024ff24723eULL, 0x000fe400020006ffULL, 0x00000010ff7e7819ULL, 0x100fe4000001162dULL,
0x00000018ff2c7819ULL, 0x000fe4000001162dULL, 0x0000ffff2d8a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff807819ULL, 0x000fe4000001162eULL, 0x000000ff2e707812ULL, 0x000fc400078ec0ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001162eULL, 0x0000ffff2e647812ULL, 0x000fe400078ec0ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001162fULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x00000051ff4e723eULL, 0x000fe200020006ffULL,
0x20000025ff517230ULL, 0x000fe20000004100ULL, 0x0000006dff4f723eULL, 0x000fe200020006ffULL,
0x20000024ff6d7230ULL, 0x000fe20000004100ULL, 0x00000031ff31723eULL, 0x000fe200020006ffULL,
0x2000004dff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff4a257812ULL, 0x000fe200078ec0ffULL,
0x20000026ff4d7230ULL, 0x000fe20000004100ULL, 0x00000008ff247819ULL, 0x000fe20000011681ULL,
0x20000031ff5f7230ULL, 0x000fe20000004100ULL, 0x00000032ff32723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x0000002eff2e723eULL, 0x000fe200020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000027ff27723eULL, 0x000fe200020006ffULL,
0x20000032ff5b7230ULL, 0x000fe20000004100ULL, 0x00000018ff727819ULL, 0x000fe20000011660ULL,
0x2000002eff317230ULL, 0x000fe20000004100ULL, 0x00000025ff25723eULL, 0x000fe200020006ffULL,
0x20000027ff327230ULL, 0x000fe20000004100ULL, 0x00000008ff267819ULL, 0x000fc40000011682ULL,
0x000000ff6e6e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff6f6f7812ULL, 0x000fe400078ec0ffULL,
0x00000024ff24723eULL, 0x000fe400020006ffULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x00000033ff33723eULL, 0x000fe400020006ffULL, 0x00000072ff2e723eULL, 0x000fe200020006ffULL,
0x2000002bff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff2f717812ULL, 0x000fe200078ec0ffULL,
0x20000033ff537230ULL, 0x000fe20000004100ULL, 0x00000026ff26723eULL, 0x000fe200020006ffULL,
0x2000002eff2e7230ULL, 0x000fe20000004100ULL, 0x0000006eff27723eULL, 0x000fe200020006ffULL,
0x20000024ff6e7230ULL, 0x000fe20000004100ULL, 0x0000006fff72723eULL, 0x000fe200020006ffULL,
0x20000025ff6f7230ULL, 0x000fe20000004100ULL, 0x0000002aff2a723eULL, 0x000fc400020006ffULL,
0x00000008ff247819ULL, 0x000fe40000011683ULL, 0x00000008ff257819ULL, 0x000fe20000011684ULL,
0x2000002aff6a7230ULL, 0x000fe20000004100ULL, 0x000000ff74747812ULL, 0x000fe400078ec0ffULL,
0x00000030ff30723eULL, 0x000fe400020006ffULL, 0x00000070ff33723eULL, 0x000fe200020006ffULL,
0x20000026ff707230ULL, 0x000fe20000004100ULL, 0x00000071ff2b723eULL, 0x000fe200020006ffULL,
0x20000027ff717230ULL, 0x000fe20000004100ULL, 0x0000002dff2d723eULL, 0x000fe200020006ffULL,
0x20000030ff597230ULL, 0x000fe20000004100ULL, 0x000000ff60737812ULL, 0x000fe200078ec0ffULL,
0x20000033ff337230ULL, 0x000fe20000004100ULL, 0x000000ff61777812ULL, 0x000fe200078ec0ffULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x00000018ff767819ULL, 0x000fc40000011661ULL,
0x000000ff75757812ULL, 0x000fe400078ec0ffULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x00000025ff25723eULL, 0x000fe400020006ffULL, 0x00000074ff26723eULL, 0x000fe400020006ffULL,
0x00000008ff277819ULL, 0x000fe20000011685ULL, 0x20000025ff747230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fc4000001162fULL, 0x0000ffff2f577812ULL, 0x000fe200078ec0ffULL,
0x2000002dff2f7230ULL, 0x000fe20000004100ULL, 0x0000002cff2a723eULL, 0x000fe400020006ffULL,
0x00000073ff30723eULL, 0x000fe200020006ffULL, 0x20000072ff737230ULL, 0x000fe20000004100ULL,
0x00000077ff2c723eULL, 0x000fe200020006ffULL, 0x20000024ff727230ULL, 0x000fe20000004100ULL,
0x00000076ff2d723eULL, 0x000fe200020006ffULL, 0x20000030ff307230ULL, 0x000fe20000004100ULL,
0x00000075ff77723eULL, 0x000fe200020006ffULL, 0x20000026ff757230ULL, 0x000fe20000004100ULL,
0x00000027ff76723eULL, 0x000fe200020006ffULL, 0x2000002dff2d7230ULL, 0x000fe20000004100ULL,
0x00a800006624783bULL, 0x0002a20000000200ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x000000ff637f7812ULL, 0x000fe200078ec0ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL,
0x20000049ff5e7230ULL, 0x000fe20000004100ULL, 0x00000028ff6b723eULL, 0x000fe200020006ffULL,
0x2000002aff2a7230ULL, 0x000fe20000004100ULL, 0x00000008ff667819ULL, 0x002fe20000011689ULL,
0x2000002cff2c7230ULL, 0x000fe20000004100ULL, 0x0000007fff49723eULL, 0x000fe200020006ffULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000008ff7f7819ULL, 0x000fc4000001168aULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x000000ff80817812ULL, 0x000fe400078ec0ffULL,
0x0000007fff80723eULL, 0x000fe200020006ffULL, 0x2000007eff7f7230ULL, 0x000fe20000004100ULL,
0x000000ff65837812ULL, 0x000fe200078ec0ffULL, 0x20000066ff7e7230ULL, 0x000fe20000004100ULL,
0x00000008ff827819ULL, 0x000fe20000011664ULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x00000010ff6b7819ULL, 0x000fc4000001166bULL, 0x00000010ff657819ULL, 0x000fe4000001166cULL,
0x00000010ff647819ULL, 0x000fe4000001166dULL, 0x00000010ff667819ULL, 0x000fe4000001166fULL,
0x0000105464647816ULL, 0x000fe4000000006bULL, 0x0000105466657816ULL, 0x000fe40000000065ULL,
0x00000010ff587819ULL, 0x000fe20000011660ULL, 0x0000002924248231ULL, 0x084fe200003400ffULL,
0x00000010ff5f7819ULL, 0x000fe2000001165fULL, 0x0000002926268231ULL, 0x000fe200003400ffULL,
0x000000ff58667812ULL, 0x000fe200078ec0ffULL, 0x0000005425258231ULL, 0x080fe200003400ffULL,
0x00000010ff587819ULL, 0x000fe20000011671ULL, 0x0000005427278231ULL, 0x000fe200003400ffULL,
0x000000ff627b7812ULL, 0x000fc400078ec0ffULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x000000642420723cULL, 0x000fe20000041820ULL,
0x00000010ff597819ULL, 0x000fe20000011659ULL, 0x2000004bff5c7230ULL, 0x000fe20000004100ULL,
0x00000018ff787819ULL, 0x000fe20000011662ULL, 0x2000007bff477230ULL, 0x000fe20000004100ULL,
0x00000018ff7c7819ULL, 0x000fe40000011663ULL, 0x00000008ff657819ULL, 0x000fc40000011657ULL,
0x00000010ff577819ULL, 0x000fe4000001165eULL, 0x00001054585e7816ULL, 0x000fe4000000005fULL,
0x00000010ff647819ULL, 0x000fe40000011673ULL, 0x00000010ff587819ULL, 0x000fe4000001165bULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff737819ULL, 0x000fc40000011674ULL,
0x00000078ff4b723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000105459727816ULL, 0x000fe20000000072ULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x0000105458737816ULL, 0x000fe20000000073ULL, 0x2000007cff4a7230ULL, 0x000fe20000004100ULL,
0x00000008ff787819ULL, 0x000fe20000011686ULL, 0x00a800005a58783bULL, 0x000e620000000200ULL,
0x000000ff7a7b7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff4c7819ULL, 0x000fe20000011661ULL,
0x000000722414723cULL, 0x000fe20000041814ULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x000000ff79797812ULL, 0x000fe200078ec0ffULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000008ff7a7819ULL, 0x000fe20000011687ULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x00000008ff7c7819ULL, 0x000fc40000011688ULL,
0x00001054645f7816ULL, 0x000fe40000000057ULL, 0x000000ff4c577812ULL, 0x000fe400078ec0ffULL,
0x00000000ff68723eULL, 0x000fe400020006ffULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x0000005e2418723cULL, 0x000fe20000041818ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000010ff4c7819ULL, 0x000fe20000011677ULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000010ff537819ULL, 0x000fc40000011653ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x000010544c5d7816ULL, 0x000fe4000000005dULL,
0x00000010ff4c7819ULL, 0x000fe40000011655ULL, 0x00000010ff777819ULL, 0x000fe20000011678ULL,
0x0000002958588231ULL, 0x082fe200003400ffULL, 0x00000010ff527819ULL, 0x000fe20000011652ULL,
0x000000295a5a8231ULL, 0x000fe200003400ffULL, 0x00000010ff7b7819ULL, 0x000fe2000001167bULL,
0x0000005459598231ULL, 0x080fe200003400ffULL, 0x0000105453767816ULL, 0x000fe20000000076ULL,
0x000000545b5b8231ULL, 0x000fe200003400ffULL, 0x00000010ff537819ULL, 0x000fc40000011651ULL,
0x000010544c777816ULL, 0x000fe40000000077ULL, 0x000010547b517816ULL, 0x000fe40000000052ULL,
0x00000010ff6b7819ULL, 0x000fe40000011668ULL, 0x00000010ff6a7819ULL, 0x000fe2000001166aULL,
0x00000076240c723cULL, 0x000fe2000004180cULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff6f7819ULL, 0x000fc40000011670ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff4c7819ULL, 0x000fc4000001164dULL, 0x00000010ff7b7819ULL, 0x000fe4000001167cULL,
0x000010546b6e7816ULL, 0x000fe4000000006eULL, 0x000010546a6f7816ULL, 0x000fe4000000006fULL,
0x00001054755c7816ULL, 0x000fe4000000005cULL, 0x0000105479507816ULL, 0x000fe40000000050ULL,
0x00001054537a7816ULL, 0x000fe2000000007aULL, 0x0000006e241c723cULL, 0x000fe2000004181cULL,
0x000010544c7b7816ULL, 0x000fc4000000007bULL, 0x00000010ff007819ULL, 0x000fe40000011662ULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x0000005c2410723cULL, 0x000fe20000041810ULL, 0x000000ff00007812ULL, 0x000fe200078ec0ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x0000ffff60607812ULL, 0x000fc400078ec0ffULL,
0x0000ffff61617812ULL, 0x000fe200078ec0ffULL, 0x000000502408723cULL, 0x040fe20000041808ULL,
0x00000010ff337819ULL, 0x000fe40000011633ULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000010ff287819ULL, 0x000fe20000011663ULL,
0x0000007a2404723cULL, 0x000fe20000041804ULL, 0x00000008ff607819ULL, 0x000fe20000011660ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000008ff617819ULL, 0x000fe20000011661ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x0000ffff62627812ULL, 0x000fc400078ec0ffULL,
0x00000010ff257819ULL, 0x000fe40000011632ULL, 0x00000000ff24723eULL, 0x000fe400020006ffULL,
0x00001054257e7816ULL, 0x000fe4000000007eULL, 0x00000010ff257819ULL, 0x000fe2000001162bULL,
0x20000024ff277230ULL, 0x000fe20000004100ULL, 0x00000010ff007819ULL, 0x000fe40000011681ULL,
0x00000010ff267819ULL, 0x000fc40000011683ULL, 0x0000ffff63637812ULL, 0x000fe400078ec0ffULL,
0x0000105400247816ULL, 0x000fe40000000033ULL, 0x0000105426257816ULL, 0x000fe40000000025ULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x000000ff7d7d7812ULL, 0x000fe200078ec0ffULL, 0x000000245818723cULL, 0x000fe20000041818ULL,
0x000000ff28287812ULL, 0x000fe200078ec0ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000008ff627819ULL, 0x000fe20000011662ULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000008ff637819ULL, 0x000fc40000011663ULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00000010ff007819ULL, 0x000fe20000011631ULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011665ULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000028ff28723eULL, 0x000fc400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000010ff307819ULL, 0x000fe20000011630ULL,
0x20000028ff287230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe20000011666ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x0000105400837816ULL, 0x000fe40000000065ULL, 0x0000105425307816ULL, 0x000fe20000000030ULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fc4000001162eULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff007819ULL, 0x000fe4000001162dULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff527819ULL, 0x000fe4000001167fULL,
0x0000105425607816ULL, 0x000fe40000000060ULL, 0x0000105400617816ULL, 0x000fc40000000061ULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff7d7819ULL, 0x000fe2000001167dULL, 0x00000060580c723cULL, 0x000fe2000004180cULL,
0x00000010ff2a7819ULL, 0x000fe4000001162aULL, 0x00000010ff7f7819ULL, 0x000fe40000011680ULL,
0x00000010ff2f7819ULL, 0x000fc4000001162fULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff2c7819ULL, 0x000fe4000001162cULL, 0x00000010ff317819ULL, 0x000fe40000011657ULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff007819ULL, 0x000fe40000011627ULL,
0x00000010ff257819ULL, 0x000fc40000011649ULL, 0x00000010ff287819ULL, 0x000fe40000011628ULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x000010547d4e7816ULL, 0x000fc4000000004eULL, 0x00001054524f7816ULL, 0x000fe4000000004fULL,
0x000010542a7f7816ULL, 0x000fe4000000007fULL, 0x000010542f827816ULL, 0x000fe40000000082ULL,
0x0000105431317816ULL, 0x000fe2000000002cULL, 0x0000004e5820723cULL, 0x000fe20000041820ULL,
0x0000105400247816ULL, 0x000fe40000000047ULL, 0x0000105428257816ULL, 0x000fc40000000025ULL,
0x000010544b627816ULL, 0x000fe40000000062ULL, 0x000010544a637816ULL, 0x000fe20000000063ULL,
0x0000007e581c723cULL, 0x040ff0000004181cULL, 0x000000825814723cULL, 0x040ff00000041814ULL,
0x000000305810723cULL, 0x040ff00000041810ULL, 0x000000245808723cULL, 0x040ff00000041808ULL,
0x000000625804723cULL, 0x000fe20000041804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200037247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a00056ff7f8cULL, 0x0007e2000c80043fULL,
0x00000001446b7812ULL, 0x000fc600078ec0ffULL, 0x0000030035357a10ULL, 0x008fc80007ffe0ffULL,
0x000000023500720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff608000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x004ea20000002500ULL,
0x000000ffff2d7224ULL, 0x000fe400078e000eULL, 0x000000ffff0e7224ULL, 0x000fe400078e0017ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0007ULL, 0x000000ffff357224ULL, 0x000fe400078e0006ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0005ULL, 0x000000ffff337224ULL, 0x000fc400078e0004ULL,
0x000000ffff2a7224ULL, 0x000fe400078e000bULL, 0x000000ffff317224ULL, 0x000fe400078e000aULL,
0x000000ffff287224ULL, 0x000fe400078e0009ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0008ULL,
0x000000ffff267224ULL, 0x000fe400078e000fULL, 0x000000ffff247224ULL, 0x008fe200078e000dULL,
0x0000000402007c0cULL, 0x004fe2000bf03070ULL, 0x000000ffff2b7224ULL, 0x000fc400078e000cULL,
0x000000ffff297224ULL, 0x000fe400078e0013ULL, 0x000000ffff277224ULL, 0x000fe400078e0011ULL,
0x000000ffff257224ULL, 0x000fe400078e0016ULL, 0x000000ffff177224ULL, 0x000fc800078e0015ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x0180000038007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000b0c000067802ULL, 0x000fe40000000f00ULL, 0x00009f0000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003800037308ULL, 0x000ea40000001000ULL, 0xbf80000003007423ULL, 0x004fc80000000038ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000047919ULL, 0x000ee80000000000ULL, 0x0000000000077919ULL, 0x000f220000000000ULL,
0x00000002ff067819ULL, 0x008fe40000011604ULL, 0x0000000807047811ULL, 0x010fe200078ff0ffULL,
0x0000000003057220ULL, 0x004fca0000410000ULL, 0x00001f0605007589ULL, 0x000ea800000e0000ULL,
0x00001f0405047589ULL, 0x000ee200000e0000ULL, 0x0000002000207220ULL, 0x044fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001900197220ULL, 0x040fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000001700177220ULL, 0x040fe20000410000ULL, 0x0000001000107220ULL, 0x040fe20000410000ULL,
0x0000002700277220ULL, 0x040fe20000410000ULL, 0x0000002b002b7220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002f002f7220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000003300337220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x000fe20000410000ULL, 0x0000002204227220ULL, 0x048fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000000e040e7220ULL, 0x040fe20000410000ULL, 0x0000001204127220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x000fe20000410000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000203007812ULL, 0x004fc400078ec0ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011603ULL, 0x0000000200047811ULL, 0x040fe400078ff8ffULL,
0x0000000400067811ULL, 0x000fe400078ff8ffULL, 0x0000000803157811ULL, 0x000fe400078ff0ffULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x0000000704057812ULL, 0x000fc400078e780dULL,
0x0000000706087812ULL, 0x040fe400078e780dULL, 0x0000000706067812ULL, 0x000fe200078e7815ULL,
0x000000080d097824ULL, 0x000fe200078e0205ULL, 0x00000006000a7811ULL, 0x000fe200078ff8ffULL,
0x000010003d057824ULL, 0x000fe200078e00ffULL, 0x0000000702007812ULL, 0x100fe200078e780dULL,
0x0000000815137824ULL, 0x000fe200078e0206ULL, 0x000000070a0c7812ULL, 0x000fe200078e780dULL,
0x0000000803067824ULL, 0x000fe200078e00ffULL, 0x0000000702027812ULL, 0x100fe200078e7815ULL,
0x000000080d077824ULL, 0x040fe200078e0200ULL, 0x0000000704047812ULL, 0x000fe200078e7815ULL,
0x0000080048007824ULL, 0x000fe200078e0205ULL, 0x000000070a0a7812ULL, 0x000fe200078e7815ULL,
0x000000080d0b7824ULL, 0x000fe200078e0208ULL, 0x0000000806067812ULL, 0x000fe200078ec0ffULL,
0x00000008150f7824ULL, 0x000fe200078e0202ULL, 0x000000202102723eULL, 0x000fe200000010ffULL,
0x0000000815117824ULL, 0x000fe200078e0204ULL, 0x0000001c1d04723eULL, 0x000fe200000010ffULL,
0x000000080d0d7824ULL, 0x000fc400078e020cULL, 0x0000000815157824ULL, 0x000fe200078e020aULL,
0x0000541002167816ULL, 0x000fe20000000004ULL, 0x0000001007077824ULL, 0x100fe400078e0200ULL,
0x0000001009097824ULL, 0x100fe400078e0200ULL, 0x000000100b0b7824ULL, 0x100fe400078e0200ULL,
0x000000100f0f7824ULL, 0x100fe400078e0200ULL, 0x0000001011117824ULL, 0x000fc400078e0200ULL,
0x000000100d0d7824ULL, 0x100fe400078e0200ULL, 0x0000001013137824ULL, 0x100fe400078e0200ULL,
0x0000001015157824ULL, 0x000fe400078e0200ULL, 0x0000000107087824ULL, 0x000fe200078e0206ULL,
0x000000141707723eULL, 0x000fe200000010ffULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x0000763202177816ULL, 0x000fe20000000004ULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x000000102702723eULL, 0x000fe200000010ffULL, 0x00000001060f7824ULL, 0x000fe200078e020fULL,
0x0000002b2404723eULL, 0x000fe200000010ffULL, 0x0000000106117824ULL, 0x040fe200078e0211ULL,
0x0000001608007388ULL, 0x0005e20000000a00ULL, 0x00000001060d7824ULL, 0x000fc400078e020dULL,
0x0000000106137824ULL, 0x040fe400078e0213ULL, 0x0000000106157824ULL, 0x000fe200078e0215ULL,
0x000000181906723eULL, 0x000fe200000010ffULL, 0x000000013c0a7824ULL, 0x000fc600078e0203ULL,
0x0000541006167816ULL, 0x144fe40000000007ULL, 0x0000763206177816ULL, 0x000fe40000000007ULL,
0x0000541002087816ULL, 0x100fe40000000004ULL, 0x0000002f2806723eULL, 0x000fe200000010ffULL,
0x0000001609007388ULL, 0x0005e20000000a00ULL, 0x000000332c07723eULL, 0x000fe400000010ffULL,
0x0000763202097816ULL, 0x004fc40000000004ULL, 0x000000222302723eULL, 0x000fe400000010ffULL,
0x0000001e1f04723eULL, 0x000fe200000010ffULL, 0x000000080b007388ULL, 0x0005e40000000a00ULL,
0x0000541006087816ULL, 0x004fe20000000007ULL, 0x000000100a0b7824ULL, 0x000fe200078e0205ULL,
0x0000763206097816ULL, 0x000fe40000000007ULL, 0x0000001a1b06723eULL, 0x000fe400000010ffULL,
0x000000250e07723eULL, 0x000fe200000010ffULL, 0x000000080d007388ULL, 0x0005e40000000a00ULL,
0x0000541002087816ULL, 0x004fc40000000004ULL, 0x0000763202097816ULL, 0x000fe40000000004ULL,
0x000000122902723eULL, 0x000fe400000010ffULL, 0x0000002d2604723eULL, 0x000fe200000010ffULL,
0x000000080f007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x144fe40000000007ULL,
0x0000763206097816ULL, 0x000fe40000000007ULL, 0x000000312a06723eULL, 0x000fc400000010ffULL,
0x000000352e07723eULL, 0x000fe200000010ffULL, 0x0000000811007388ULL, 0x0005e40000000a00ULL,
0x0000541002087816ULL, 0x144fe40000000004ULL, 0x0000763202097816ULL, 0x000fe40000000004ULL,
0x000000ff00027306ULL, 0x000fe60000205400ULL, 0x0000000813007388ULL, 0x0005e40000000a00ULL,
0x0000541006087816ULL, 0x004fc40000000007ULL, 0x0000763206097816ULL, 0x000fe40000000007ULL,
0x000000ff00077306ULL, 0x000ea60000209400ULL, 0x0000000815007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000020700720bULL, 0x004fc40003f1d000ULL,
0x000000ff00027245ULL, 0x000fd6000020d400ULL, 0x0000000102020812ULL, 0x000fe200078efcffULL,
0x000400000b1c7984ULL, 0x000ea60000000c00ULL, 0x000000020206723eULL, 0x000fe200000010ffULL,
0x000c00000b107984ULL, 0x000ee80000000c00ULL, 0x000000000b0c7984ULL, 0x000f280000000c00ULL,
0x000800000b187984ULL, 0x000e620000000c00ULL, 0x3f803f80061d7831ULL, 0x004fc4000020001dULL,
0x3f803f80061f7831ULL, 0x040fe4000020001fULL, 0x3f803f801d1d7831ULL, 0x008fe20000200011ULL,
0x00000300ff117624ULL, 0x000fe200078e00ffULL, 0x3f803f80061e7831ULL, 0x040fe4000020001eULL,
0x3f803f80060f7831ULL, 0x050fe4000020000fULL, 0x000000011100780cULL, 0x000fe20003f05270ULL,
0x3f803f80060e7831ULL, 0x040fe4000020000eULL, 0x3f803f80060d7831ULL, 0x000fc4000020000dULL,
0x3f803f80060c7831ULL, 0x040fe4000020000cULL, 0x3f803f80061c7831ULL, 0x000fe4000020001cULL,
0x3f803f800f0f7831ULL, 0x002fe4000020001bULL, 0x3f803f800e0e7831ULL, 0x000fe4000020001aULL,
0x3f803f800d0d7831ULL, 0x000fe40000200019ULL, 0x3f803f800c0c7831ULL, 0x000fc40000200018ULL,
0x3f803f801f1f7831ULL, 0x000fe40000200013ULL, 0x3f803f801e1e7831ULL, 0x000fe20000200012ULL,
0x0000000c0b007388ULL, 0x0003e20000000c00ULL, 0x3f803f801c1c7831ULL, 0x000fca0000200010ULL,
0x0004001c0b007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f3000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x000ea20000002700ULL,
0x0000580011047a24ULL, 0x000fe200078e02ffULL, 0x0000000148ff7812ULL, 0x000fe2000780f836ULL,
0x00000800ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000077919ULL, 0x000ea20000002600ULL,
0x00006600040c7a24ULL, 0x002fe200078e02ffULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000004003d067824ULL, 0x000fe200078e00ffULL, 0x000000000b147984ULL, 0x0002e20000000c00ULL,
0x000000ff0300720cULL, 0x000fc40000725670ULL, 0x000007ff0c047811ULL, 0x000fe200078e40ffULL,
0x0000580010107a24ULL, 0x004fc800078e0207ULL, 0x0000030010077a24ULL, 0x000fca00078e02ffULL,
0x00000004070d7c10ULL, 0x000fc8000fffe0ffULL, 0x0000000d04087211ULL, 0x000fca00078fa8ffULL,
0x00006c0008087625ULL, 0x000fca00078e0009ULL, 0x00000006080e7210ULL, 0x000fe40007f5e0ffULL,
0x01ffffff0c087812ULL, 0x000fc600078ec0ffULL, 0x000000ffff0f7224ULL, 0x000fc800010e0609ULL,
0x000000100a0e7825ULL, 0x000fe200078e000eULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010030a7824ULL, 0x00afe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x000000010d0c7824ULL, 0x000fe200078e0208ULL,
0x000000700a137812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b127812ULL, 0x000fe200078ec0ffULL,
0x00006c000d0a7625ULL, 0x000fc800078e0009ULL, 0x00006c000c0c7625ULL, 0x000fe200078e0009ULL,
0x0000000a120a7210ULL, 0x000fc80007a1e013ULL, 0x0000000c120c7210ULL, 0x000fe40007c7e013ULL,
0x0000000bff0b7210ULL, 0x000fe400007e44ffULL, 0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL,
0x000000390a007986ULL, 0x0003e8000c101906ULL, 0x000000380c007986ULL, 0x0003e4000c101906ULL,
0x0000000000007941ULL, 0x00afea0003800000ULL, 0x000000140e007986ULL, 0x0003e2000c101d06ULL,
0x0000011000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0b7424ULL, 0x000fe200078e00ffULL,
0xffffffff11097810ULL, 0x000fc60007ffe0ffULL, 0x00006a00100a7625ULL, 0x000fe200078e000bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x000000090a0a79a8ULL, 0x000ea400099ee1c6ULL, 0x000000090a00720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0c7807ULL, 0x000fca0000000000ULL,
0x0000000cff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff097984ULL, 0x000ee40000000000ULL,
0x000000ff0900720cULL, 0x008fda0003f05270ULL, 0x00002b8000008947ULL, 0x000fea0003800000ULL,
0x000000ff3600720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff0a7819ULL, 0x000fe20000011603ULL, 0x0000001003097824ULL, 0x000fe200078e00ffULL,
0x00000001070c7810ULL, 0x004fe20007ffe0ffULL, 0x00000080ff0f7424ULL, 0x002fe200078e00ffULL,
0x0000000c0a157812ULL, 0x000fe400078ec0ffULL, 0x0000007009137812ULL, 0x000fe200078ec0ffULL,
0x00006c00070a7625ULL, 0x000fc800078e000fULL, 0x00006c000c0c7625ULL, 0x000fe200078e000fULL,
0x0000000a150a7210ULL, 0x000fc8000791e013ULL, 0x0000000c150c7210ULL, 0x000fe40007b5e013ULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x000000060a097981ULL, 0x000368000c1e1900ULL, 0x000000060c0e7981ULL, 0x000362000c1e1900ULL,
0x000000021100780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002070a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a150a7210ULL, 0x000fc8000791e013ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a107981ULL, 0x000362000c1e1900ULL, 0x000000041100780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003070a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a150a7210ULL, 0x000fc8000791e013ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a127981ULL, 0x000362000c1e1900ULL,
0x000000041100780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004070a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a150a7210ULL, 0x000fc8000791e013ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a147981ULL, 0x000362000c1e1900ULL, 0x000000061100780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005070a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a150a7210ULL, 0x000fc8000791e013ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a167981ULL, 0x000362000c1e1900ULL,
0x000000061100780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081100780cULL, 0x002fe40003f06070ULL, 0x00000006070a7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a150a7210ULL, 0x000fe40007a3e013ULL,
0x00000007070c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006c000c0c0625ULL, 0x000fe400078e000fULL, 0x000000060a187981ULL, 0x000366000c1e1900ULL,
0x0000000c150c0210ULL, 0x000fc80007c7e013ULL, 0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL,
0x000000060c0c0981ULL, 0x000368000c1e1900ULL, 0x00000007110a7810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff0d7819ULL, 0x000fc8000001160aULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1c7224ULL, 0x020fe400078e0009ULL, 0x000000081a0f7824ULL, 0x040fe200078e00ffULL,
0x000000011a1a7810ULL, 0x000fc80007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x0000000d1a00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080f0a7810ULL, 0x040fe40007ffe0ffULL, 0x000000010f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001c09097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a1c7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090f0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000020f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000e09097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff137819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700e117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a0e7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0f0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000030f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001009097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007010117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a107981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0f0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000040f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001209097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a120a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a127981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0f0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000050f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001409097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a147981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0f0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000060f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001609097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff137819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a167981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0f0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000070f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001809097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a187981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0f0a7810ULL, 0x002fe40007ffe0ffULL,
0x0000000c09097209ULL, 0x000fe40007810000ULL, 0x000003000a007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030c7824ULL, 0x004fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700c0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007a3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000060a0c7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ee40000000000ULL, 0x00000010030a7824ULL, 0x00afe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011603ULL, 0x000000700a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL, 0x000000010b0a7824ULL, 0x000fca00078e020aULL,
0x000000090a007388ULL, 0x0203e40000000800ULL, 0x0000001003097824ULL, 0x042fe200078e00ffULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x0000000148137824ULL, 0x000fe200078e0207ULL,
0x00000001ff0b7819ULL, 0x000fe20000011603ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x00000800ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000c0b0c7812ULL, 0x004fe200078ec0ffULL, 0x000000013a3a7824ULL, 0x000fe200078e0205ULL,
0x00000013040a7211ULL, 0x000fe200078fa8ffULL, 0x000010e000007945ULL, 0x000fe20003800000ULL,
0x00000020030f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010c297824ULL, 0x000fe200078e0209ULL,
0x0000000141097812ULL, 0x040fe200078ec0ffULL, 0x0000080041417824ULL, 0x000fe200078e00ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00006c000a0a7625ULL, 0x000fe200078e000dULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000080041417812ULL, 0x000fe200078ec0ffULL, 0x0000000248108824ULL, 0x100fe200078e023dULL,
0x000000060a0a7210ULL, 0x000fe20007f3e0ffULL, 0x00000002480c8824ULL, 0x000fe200078e023dULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000210148824ULL, 0x000fe200078e0209ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000108108824ULL, 0x000fe200078e0213ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000080ff118424ULL, 0x000fe200078e00ffULL,
0x0000000029297984ULL, 0x000e620000000800ULL, 0x000000020c0e8824ULL, 0x000fe200078e0209ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00000080ff128424ULL, 0x000fc400078e00ffULL,
0x000000013a0c7824ULL, 0x000fe400078e0241ULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000030048007a0cULL, 0x000fe20003f26070ULL, 0x00006c0010108625ULL, 0x000fc800078e0011ULL,
0x00006c0013128625ULL, 0x000fc800078e0012ULL, 0x000000080e178824ULL, 0x100fe400078e0203ULL,
0x0000000814148824ULL, 0x000fe400078e0203ULL, 0x0000001003157824ULL, 0x000fe200078e020cULL,
0x0000458017178811ULL, 0x000fe200078e20ffULL, 0x00000010030c7825ULL, 0x000fe200078e000aULL,
0x00004180141f8811ULL, 0x000fc600078e20ffULL, 0x000000100f0e7825ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c157faeULL, 0x0005e2000b901c46ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x0000001003108825ULL, 0x040fe200078e0010ULL,
0x003800000e157faeULL, 0x0007e6000b901c46ULL, 0x0000001003128825ULL, 0x000fe200078e0012ULL,
0x0000000010178faeULL, 0x0009e6000b901c46ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x00000000121f8faeULL, 0x0003e2000b901c46ULL, 0x00000000000c7805ULL, 0x004fe2000001ff00ULL,
0x000000ffff287224ULL, 0x000fc400078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000e7805ULL, 0x008fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x010fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x002fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000d5000001947ULL, 0x000fea0003800000ULL,
0x000000ffff097224ULL, 0x000fe400078e00ffULL, 0x000000ffff337224ULL, 0x000fca00078e0048ULL,
0x0000000233347810ULL, 0x000fe20007ffe0ffULL, 0x0000029000017945ULL, 0x000fe60003800000ULL,
0x0000030034007a0cULL, 0x000fda0003f06070ULL, 0x0000026000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x000fe20003f24070ULL, 0x0000000107317824ULL, 0x100fe200078e0234ULL,
0x00000001ff2a7819ULL, 0x000fe20000011634ULL, 0x00000800ff307424ULL, 0x000fe200078e00ffULL,
0x0000002003377810ULL, 0x000fe20007ffe0ffULL, 0x00000400342c7824ULL, 0x000fe200078e00ffULL,
0x00000031042b7211ULL, 0x000fe400078fa8ffULL, 0x000000012a2e7812ULL, 0x000fc600078ec0ffULL,
0x00006c002b2a7625ULL, 0x000fc800078e0030ULL, 0x00000002482f9824ULL, 0x000fe200078e023dULL,
0x000000062a2a7210ULL, 0x000fe20007f1e0ffULL, 0x00000001082d9824ULL, 0x000fe400078e0231ULL,
0x000000022f369824ULL, 0x100fe200078e022eULL, 0x000008002c2f7812ULL, 0x000fe200078ec0ffULL,
0x0000000248359824ULL, 0x000fe400078e023dULL, 0x00000080ff309424ULL, 0x000fe400078e00ffULL,
0x00000002353e9824ULL, 0x020fc400078e022eULL, 0x00006c002d2c9625ULL, 0x000fc800078e0030ULL,
0x00000080ff389424ULL, 0x000fe400078e00ffULL, 0x000000013a2e7824ULL, 0x000fe400078e022fULL,
0x000000ffff2b7224ULL, 0x000fe400000e062bULL, 0x00006c0031309625ULL, 0x000fc800078e0038ULL,
0x0000001003357824ULL, 0x040fe400078e022eULL, 0x0000000836369824ULL, 0x000fe400078e0203ULL,
0x00000010032e9825ULL, 0x000fc800078e002cULL, 0x000000083e399824ULL, 0x000fe400078e0203ULL,
0x00000010372c7825ULL, 0x100fe200078e002aULL, 0x0000458036379811ULL, 0x000fe400078e20ffULL,
0x0000418039399811ULL, 0x000fe200078e20ffULL, 0x00000010032a7825ULL, 0x000fc800078e002aULL,
0x0000001003309825ULL, 0x000fe200078e0030ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800002a357faeULL, 0x0003e8000b901c46ULL, 0x003800002c357faeULL, 0x0003e8000b901c46ULL,
0x000000002e379faeULL, 0x0003e8000b901c46ULL, 0x0000000030399faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000040332a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff2c7819ULL, 0x000fe20000011603ULL,
0x00000002482d7824ULL, 0x000fe200078e023dULL, 0x00000002ff567819ULL, 0x000fe20000011603ULL,
0x00000010032b7824ULL, 0x000fe200078e00ffULL, 0x000000802a2a7812ULL, 0x000fc400078ec0ffULL,
0x0000000c2c2c7812ULL, 0x000fe200078ec0ffULL, 0x00000008562f7824ULL, 0x040fe200078e00ffULL,
0x000000702b2b7812ULL, 0x000fe200078ec0ffULL, 0x000001002d2a7824ULL, 0x000fe200078e002aULL,
0x0000000756447812ULL, 0x040fe200078ec0ffULL, 0x00000008562d7824ULL, 0x040fe200078e00ffULL,
0x0000000856587810ULL, 0x000fe40007ffe0ffULL, 0x0000002a2c2c7210ULL, 0x000fe20007ffe02bULL,
0x00000008562b7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2a7812ULL, 0x100fe200078ee244ULL,
0x00000008582d7824ULL, 0x040fe200078e00ffULL, 0x00000058ff527212ULL, 0x000fe200078e33ffULL,
0x0000000858467824ULL, 0x000fe200078e00ffULL, 0x000000012b2e7812ULL, 0x000fe200078ef644ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180002c407984ULL, 0x000e620000000800ULL,
0x000000022b307812ULL, 0x140fe400078ef644ULL, 0x000000032b367812ULL, 0x140fe200078ef644ULL,
0x004580002c547984ULL, 0x0002a20000000800ULL, 0x000000042b387812ULL, 0x140fe400078ef644ULL,
0x000000052b3e7812ULL, 0x020fe400078ef644ULL, 0x00000056ff427212ULL, 0x000fe400078e33ffULL,
0xfffffff82d527812ULL, 0x000fc400078ee252ULL, 0xfffffff82f427812ULL, 0x000fe400078ee242ULL,
0x00000007582f7812ULL, 0x000fe200078ec0ffULL, 0x00000040292c7221ULL, 0x002fe20000010100ULL,
0x000000062b407812ULL, 0x000fe200078ef644ULL, 0x00000400332b7824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b2c317820ULL, 0x000fe20000410000ULL, 0x00000004032c7824ULL, 0x000fe400078e00ffULL,
0x000008002b2b7812ULL, 0x000fe200078ec0ffULL, 0x0000000858447824ULL, 0x000fc400078e00ffULL,
0x0000000c2c2d7812ULL, 0x000fe200078ec0ffULL, 0x0000003100317308ULL, 0x000ea20000000800ULL,
0x000001803a2b7810ULL, 0x000fe20007ffe02bULL, 0x000000ffff337224ULL, 0x000fe200078e0034ULL,
0xfffffff8462c7812ULL, 0x100fe400078ee22fULL, 0x0000000144467812ULL, 0x000fe200078ef62fULL,
0x000000102a2a7824ULL, 0x000fe200078e022bULL, 0x00000002444a7812ULL, 0x000fe200078ef62fULL,
0x0000001042427824ULL, 0x000fe200078e022bULL, 0x00000003444c7812ULL, 0x000fe200078ef62fULL,
0x000000012a2a7824ULL, 0x000fe200078e022dULL, 0x00000004444e7812ULL, 0x140fe200078ef62fULL,
0x000000012d427824ULL, 0x040fe200078e0242ULL, 0x0000000544507812ULL, 0x000fe200078ef62fULL,
0x000000102e2e7824ULL, 0x000fe200078e022bULL, 0x0000000644447812ULL, 0x000fe200078ef62fULL,
0x0000001030307824ULL, 0x100fe200078e022bULL, 0x000000002a2f7984ULL, 0x000e620000000800ULL,
0x000000012d2e7824ULL, 0x000fe200078e022eULL, 0x0000005431317220ULL, 0x004fe20000410000ULL,
0x000000012d307824ULL, 0x000fe200078e0230ULL, 0x0000000042427984ULL, 0x000fe20000000800ULL,
0x0000001036367824ULL, 0x100fe200078e022bULL, 0x0000030033007a0cULL, 0x000fe20003f06070ULL,
0x0000001038387824ULL, 0x100fe200078e022bULL, 0x000000002e2e7984ULL, 0x000fe20000000800ULL,
0x000000012d367824ULL, 0x000fe200078e0236ULL, 0x0000003231327221ULL, 0x000fe20000010000ULL,
0x000000012d387824ULL, 0x000fe200078e0238ULL, 0x0000000030307984ULL, 0x000fe20000000800ULL,
0x000000103e3e7824ULL, 0x000fc400078e022bULL, 0x0000001040407824ULL, 0x100fe200078e022bULL,
0x00001f56312a7589ULL, 0x000ea200000e0000ULL, 0x000000012d3e7824ULL, 0x000fe400078e023eULL,
0x000000102c2c7824ULL, 0x100fe200078e022bULL, 0x0000000036367984ULL, 0x000ee20000000800ULL,
0x0000001046467824ULL, 0x100fe400078e022bULL, 0x000000104a4a7824ULL, 0x100fe200078e022bULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x000000104c4c7824ULL, 0x000fc400078e022bULL,
0x000000104e4e7824ULL, 0x100fe200078e022bULL, 0x000000003e3e7984ULL, 0x000ee20000000800ULL,
0x0000001050507824ULL, 0x100fe400078e022bULL, 0x0000001044447824ULL, 0x100fe400078e022bULL,
0x0000001052527824ULL, 0x000fe400078e022bULL, 0x000000012d407824ULL, 0x040fe200078e0240ULL,
0x00001f58312b7589ULL, 0x000fe200000e0000ULL, 0x000000012d2c7824ULL, 0x000fc400078e022cULL,
0x000000012d467824ULL, 0x040fe200078e0246ULL, 0x00007610ff547816ULL, 0x002fe2000000002fULL,
0x000000012d4a7824ULL, 0x040fe200078e024aULL, 0x0000000040407984ULL, 0x000e620000000800ULL,
0x000000012d4c7824ULL, 0x040fe400078e024cULL, 0x000000012d4e7824ULL, 0x040fe200078e024eULL,
0x000000002c2c7984ULL, 0x000e620000000800ULL, 0x000000012d507824ULL, 0x040fe200078e0250ULL,
0x0000002a54277223ULL, 0x004fe20000010027ULL, 0x000000012d447824ULL, 0x040fe200078e0244ULL,
0x0000000046467984ULL, 0x000ea20000000800ULL, 0x000000012d527824ULL, 0x000fe200078e0252ULL,
0x00005410ff2d7816ULL, 0x000fc4000000002fULL, 0x000000004a4a7984ULL, 0x000e660000000800ULL,
0x0000002a2d287223ULL, 0x000fe20000010028ULL, 0x00005410ff2d7816ULL, 0x100fe20000000042ULL,
0x000000004c4c7984ULL, 0x000ea20000000800ULL, 0x00007610ff427816ULL, 0x000fc60000000042ULL,
0x0000002a2d1a7223ULL, 0x080fe2000001001aULL, 0x00005410ff2d7816ULL, 0x100fe2000000002eULL,
0x000000004e4e7984ULL, 0x000ea20000000800ULL, 0x00007610ff2e7816ULL, 0x000fe2000000002eULL,
0x0000002a42197223ULL, 0x080fe40000010019ULL, 0x0000002a2d267223ULL, 0x080fe20000010026ULL,
0x00005410ff2d7816ULL, 0x100fe20000000030ULL, 0x0000000050507984ULL, 0x000ea20000000800ULL,
0x00007610ff307816ULL, 0x000fe20000000030ULL, 0x0000002a2e257223ULL, 0x000fc40000010025ULL,
0x0000002a2d247223ULL, 0x080fe20000010024ULL, 0x00005410ff2d7816ULL, 0x108fe20000000036ULL,
0x0000000044447984ULL, 0x000ee20000000800ULL, 0x00007610ff367816ULL, 0x000fe20000000036ULL,
0x0000002a30237223ULL, 0x080fe40000010023ULL, 0x0000002a2d227223ULL, 0x080fe20000010022ULL,
0x00005410ff2d7816ULL, 0x110fe20000000038ULL, 0x0000000052527984ULL, 0x000f220000000800ULL,
0x00007610ff387816ULL, 0x000fe20000000038ULL, 0x0000002a36217223ULL, 0x000fc40000010021ULL,
0x0000002a2d207223ULL, 0x080fe20000010020ULL, 0x00005410ff2d7816ULL, 0x100fe2000000003eULL,
0x0000002a381f7223ULL, 0x000fe2000001001fULL, 0x00007610ff3e7816ULL, 0x000fc6000000003eULL,
0x0000002a2d1e7223ULL, 0x080fe2000001001eULL, 0x00005410ff2d7816ULL, 0x102fe20000000040ULL,
0x0000002a3e1d7223ULL, 0x000fe2000001001dULL, 0x00007610ff407816ULL, 0x000fc60000000040ULL,
0x0000002a2d1c7223ULL, 0x080fe2000001001cULL, 0x00005410ff2d7816ULL, 0x100fe2000000002cULL,
0x0000002a401b7223ULL, 0x000fe2000001001bULL, 0x00007610ff2c7816ULL, 0x000fc6000000002cULL,
0x0000002b2d187223ULL, 0x080fe20000010018ULL, 0x00005410ff2d7816ULL, 0x104fe20000000046ULL,
0x0000002b2c177223ULL, 0x000fe20000010017ULL, 0x00007610ff467816ULL, 0x000fc60000000046ULL,
0x0000002b2d167223ULL, 0x080fe20000010016ULL, 0x00005410ff2d7816ULL, 0x100fe2000000004aULL,
0x0000002b46157223ULL, 0x000fe20000010015ULL, 0x00007610ff4a7816ULL, 0x000fc6000000004aULL,
0x0000002b2d147223ULL, 0x080fe20000010014ULL, 0x00005410ff2d7816ULL, 0x100fe2000000004cULL,
0x0000002b4a137223ULL, 0x000fe20000010013ULL, 0x00007610ff4c7816ULL, 0x000fc6000000004cULL,
0x0000002b2d127223ULL, 0x080fe20000010012ULL, 0x00005410ff2d7816ULL, 0x100fe2000000004eULL,
0x0000002b4c117223ULL, 0x000fe20000010011ULL, 0x00007610ff4e7816ULL, 0x000fc6000000004eULL,
0x0000002b2d107223ULL, 0x080fe20000010010ULL, 0x00005410ff2d7816ULL, 0x100fe20000000050ULL,
0x0000002b4e0f7223ULL, 0x000fe2000001000fULL, 0x00007610ff507816ULL, 0x000fc60000000050ULL,
0x0000002b2d0e7223ULL, 0x080fe2000001000eULL, 0x00005410ff2d7816ULL, 0x108fe20000000044ULL,
0x0000002b500d7223ULL, 0x000fe2000001000dULL, 0x00007610ff447816ULL, 0x000fc60000000044ULL,
0x0000002b2d0c7223ULL, 0x080fe2000001000cULL, 0x00005410ff2d7816ULL, 0x110fe20000000052ULL,
0x0000002b440b7223ULL, 0x000fe2000001000bULL, 0x00007610ff527816ULL, 0x000fc60000000052ULL,
0x0000002b2d0a7223ULL, 0x080fe4000001000aULL, 0x0000002b52097223ULL, 0x000fe20000010009ULL,
0xfffff2d000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000000ff3d00720cULL, 0x000fe20003f05270ULL,
0x0000001003047824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011603ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fca00078ec0ffULL,
0x0000000103077824ULL, 0x000fe200078e0204ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000001003047824ULL, 0x002fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fc80000011603ULL, 0x0000007004037812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fc600078ec0ffULL, 0x0000008048037824ULL, 0x000fc800078e0203ULL,
0x0000000106037824ULL, 0x000fca00078e0203ULL, 0x0049803203007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800007037984ULL, 0x002e680000000800ULL, 0x004a000007047984ULL, 0x000ea20000000800ULL,
0x00000003ff037221ULL, 0x002fc80000010000ULL, 0x0000000403037221ULL, 0x004fca0000010000ULL,
0x0180000003047810ULL, 0x000fc80007ffe0ffULL, 0x7f80000004047812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0400780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e0003ULL,
0x0000dfa000067802ULL, 0x000fe40000000f00ULL, 0x0000702000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff047224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000300047308ULL, 0x000e640000001000ULL, 0xbf80000003067423ULL, 0x002fc80000000004ULL,
0x800000ff06077221ULL, 0x000fc80000010100ULL, 0x0000000704047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff337819ULL, 0x104fe20000011603ULL,
0x000000013c3c7824ULL, 0x000fe200078e0203ULL, 0x0000000803437811ULL, 0x000fc600078ff0ffULL,
0x00001f3304067589ULL, 0x000ea200000e0000ULL, 0x00000043ff457212ULL, 0x000fe200078e33ffULL,
0x0000000833477824ULL, 0x000fe400078e00ffULL, 0x00001f4304077589ULL, 0x00072200000e0000ULL,
0x000000103c3c7824ULL, 0x000fe200078e0205ULL, 0x00000033ff047212ULL, 0x008fc800078e33ffULL,
0xfffffff847477812ULL, 0x000fe400078ee204ULL, 0x0000000733047812ULL, 0x000fe200078ec0ffULL,
0x0000002806287220ULL, 0x044fe20000410000ULL, 0x0000002706277220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002506257220ULL, 0x040fe20000410000ULL,
0x0000002406247220ULL, 0x040fe20000410000ULL, 0x0000002306237220ULL, 0x040fe20000410000ULL,
0x0000002206227220ULL, 0x040fe20000410000ULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x0000002006207220ULL, 0x040fe20000410000ULL, 0x0000001f061f7220ULL, 0x040fe20000410000ULL,
0x0000001e061e7220ULL, 0x040fe20000410000ULL, 0x0000001d061d7220ULL, 0x040fe20000410000ULL,
0x0000001c061c7220ULL, 0x040fe20000410000ULL, 0x0000001b061b7220ULL, 0x040fe20000410000ULL,
0x0000001a061a7220ULL, 0x040fe20000410000ULL, 0x0000001906197220ULL, 0x000fe20000410000ULL,
0x0000000843067824ULL, 0x000fe200078e00ffULL, 0x0000001807187220ULL, 0x050fe20000410000ULL,
0x0000001707177220ULL, 0x040fe20000410000ULL, 0x0000001607167220ULL, 0x040fe20000410000ULL,
0x0000001507157220ULL, 0x040fe20000410000ULL, 0x0000001407147220ULL, 0x040fe20000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x0000001107117220ULL, 0x040fe20000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x0000000f070f7220ULL, 0x040fe20000410000ULL, 0x0000000e070e7220ULL, 0x040fe20000410000ULL,
0x0000000d070d7220ULL, 0x040fe20000410000ULL, 0x0000000c070c7220ULL, 0x040fe20000410000ULL,
0x0000000b070b7220ULL, 0x040fe20000410000ULL, 0x0000000a070a7220ULL, 0x040fe20000410000ULL,
0xfffffff806457812ULL, 0x000fe200078ee245ULL, 0x0000000907077220ULL, 0x000fe20000410000ULL,
0x0000000833067824ULL, 0x000fe200078e00ffULL, 0x0000000e0d0d723eULL, 0x000fc400000010ffULL,
0x0000000c0b0b723eULL, 0x000fe200000010ffULL, 0x0000001045457824ULL, 0x100fe200078e0200ULL,
0x0000000a0707723eULL, 0x000fe400000010ffULL, 0xfffffff806097812ULL, 0x000fe400078ee233ULL,
0x0000000104067812ULL, 0x040fe400078e3cffULL, 0x0000000204087812ULL, 0x040fe200078e3cffULL,
0x0000001009097824ULL, 0x000fe200078e0200ULL, 0x00000003040a7812ULL, 0x040fe200078e3cffULL,
0x0000000833297824ULL, 0x040fe200078e0206ULL, 0x00000004040c7812ULL, 0x040fe200078e3cffULL,
0x00000008332b7824ULL, 0x040fe200078e0208ULL, 0x00000005040e7812ULL, 0x040fe200078e3cffULL,
0x00000008332d7824ULL, 0x040fe200078e020aULL, 0x0000000604047812ULL, 0x000fe200078e3cffULL,
0x00000008332f7824ULL, 0x000fe200078e020cULL, 0x000000121111723eULL, 0x000fe200000010ffULL,
0x0000000833317824ULL, 0x000fe200078e020eULL, 0x0000000743127812ULL, 0x000fe200078ec0ffULL,
0x0000000833337824ULL, 0x000fe200078e0204ULL, 0x000000141313723eULL, 0x000fe200000010ffULL,
0x0000000843147824ULL, 0x000fe200078e00ffULL, 0x000000100f0f723eULL, 0x000fe200000010ffULL,
0x0000000403107824ULL, 0x000fe200078e00ffULL, 0x0000000112047812ULL, 0x040fe200078e3cffULL,
0x0000001029297824ULL, 0x100fe200078e0200ULL, 0x0000000212067812ULL, 0x040fe200078e3cffULL,
0x000000102b2b7824ULL, 0x000fe200078e0200ULL, 0x0000000312087812ULL, 0x040fe200078e3cffULL,
0x0000000843377824ULL, 0x040fe200078e0204ULL, 0x00000004120a7812ULL, 0x040fe200078e3cffULL,
0x0000000843397824ULL, 0x040fe200078e0206ULL, 0x00000005120c7812ULL, 0x040fe200078e3cffULL,
0x00000008433b7824ULL, 0x040fe200078e0208ULL, 0x00000006120e7812ULL, 0x000fe200078e3cffULL,
0x00000008433f7824ULL, 0x000fe200078e020aULL, 0x0000001c1b1b723eULL, 0x000fe200000010ffULL,
0x0000000843417824ULL, 0x040fe200078e020cULL, 0xfffffff814357812ULL, 0x000fe200078ee243ULL,
0x0000000843437824ULL, 0x000fe200078e020eULL, 0x0000000c101c7812ULL, 0x000fe200078ec0ffULL,
0x0000001047067824ULL, 0x100fe200078e0200ULL, 0x000000282727723eULL, 0x000fe200000010ffULL,
0x000000102d2d7824ULL, 0x100fe200078e0200ULL, 0x000000262525723eULL, 0x000fe200000010ffULL,
0x0000001035357824ULL, 0x100fe200078e0200ULL, 0x000000242323723eULL, 0x000fe200000010ffULL,
0x000000011c047824ULL, 0x000fe200078e0209ULL, 0x000000222121723eULL, 0x000fe200000010ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0200ULL, 0x000000201f1f723eULL, 0x000fe200000010ffULL,
0x0000001031317824ULL, 0x100fe200078e0200ULL, 0x0000001e1d1d723eULL, 0x000fe200000010ffULL,
0x0000001033337824ULL, 0x100fe200078e0200ULL, 0x0000002704007388ULL, 0x0005e20000000800ULL,
0x0000001037377824ULL, 0x100fe200078e0200ULL, 0x0000001a1919723eULL, 0x000fe200000010ffULL,
0x0000001039397824ULL, 0x100fe200078e0200ULL, 0x000000181717723eULL, 0x000fe200000010ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0200ULL, 0x000000161515723eULL, 0x000fe200000010ffULL,
0x000000103f3f7824ULL, 0x000fc400078e0200ULL, 0x0000001041417824ULL, 0x100fe400078e0200ULL,
0x0000001043437824ULL, 0x000fe400078e0200ULL, 0x000000011c107824ULL, 0x040fe400078e0206ULL,
0x000000011c007824ULL, 0x040fe400078e0229ULL, 0x000000011c067824ULL, 0x040fe400078e022bULL,
0x000000011c087824ULL, 0x040fe200078e022dULL, 0x0000002500007388ULL, 0x000fe20000000800ULL,
0x000000011c0a7824ULL, 0x000fc400078e022fULL, 0x000000011c0c7824ULL, 0x040fe200078e0231ULL,
0x0000002306007388ULL, 0x000fe20000000800ULL, 0x000000011c0e7824ULL, 0x040fe400078e0233ULL,
0x000000011c127824ULL, 0x040fe200078e0235ULL, 0x0000002108007388ULL, 0x000fe20000000800ULL,
0x000000011c147824ULL, 0x040fe400078e0237ULL, 0x000000011c047824ULL, 0x044fe200078e0239ULL,
0x0000001f0a007388ULL, 0x000fe20000000800ULL, 0x000000011c167824ULL, 0x000fc400078e023bULL,
0x000000011c187824ULL, 0x040fe200078e023fULL, 0x0000001d0c007388ULL, 0x000fe20000000800ULL,
0x000000011c1e7824ULL, 0x040fe400078e0245ULL, 0x000000011c1a7824ULL, 0x040fe200078e0241ULL,
0x0000001b0e007388ULL, 0x000fe20000000800ULL, 0x000000011c1c7824ULL, 0x000fc600078e0243ULL,
0x0000001910007388ULL, 0x0005e80000000800ULL, 0x0000001712007388ULL, 0x000fe80000000800ULL,
0x0000001514007388ULL, 0x000fe20000000800ULL, 0x000000020210723eULL, 0x004fc600000010ffULL,
0x0000001304007388ULL, 0x000fe80000000800ULL, 0x0000001116007388ULL, 0x000fe80000000800ULL,
0x0000000f18007388ULL, 0x000fe80000000800ULL, 0x0000000d1a007388ULL, 0x000fe80000000800ULL,
0x0000000b1c007388ULL, 0x000fe80000000800ULL, 0x000000071e007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000003c207984ULL, 0x000ea80000000c00ULL,
0x000400003c287984ULL, 0x000ee80000000c00ULL, 0x000800003c247984ULL, 0x000f280000000c00ULL,
0x000c00003c2c7984ULL, 0x000e620000000c00ULL, 0x3f803f8010237831ULL, 0x004fc40000200023ULL,
0x3f803f8010227831ULL, 0x040fe40000200022ULL, 0x3f803f8010217831ULL, 0x040fe40000200021ULL,
0x3f803f8010207831ULL, 0x040fe40000200020ULL, 0x3f803f80102b7831ULL, 0x048fe4000020002bULL,
0x3f803f80102a7831ULL, 0x040fe4000020002aULL, 0x3f803f8010297831ULL, 0x000fc40000200029ULL,
0x3f803f8010287831ULL, 0x000fe40000200028ULL, 0x3f803f8023237831ULL, 0x010fe40000200027ULL,
0x3f803f8022227831ULL, 0x000fe40000200026ULL, 0x3f803f8021217831ULL, 0x000fe40000200025ULL,
0x3f803f8020207831ULL, 0x000fe40000200024ULL, 0x3f803f802b2b7831ULL, 0x002fc4000020002fULL,
0x3f803f802a2a7831ULL, 0x000fe2000020002eULL, 0x000000203c007388ULL, 0x0003e20000000c00ULL,
0x3f803f8029297831ULL, 0x000fe4000020002dULL, 0x3f803f8028287831ULL, 0x000fca000020002cULL,
0x000400283c007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff4800720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002003117810ULL, 0x000fe20007ffe0ffULL, 0x0000000000067919ULL, 0x000ee20000002600ULL,
0x00000003ff107819ULL, 0x000fe20000011603ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x00000003ff047819ULL, 0x000fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000710007812ULL, 0x000fe200078e4803ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000704027812ULL, 0x000fe200078e4811ULL, 0x000000083d127824ULL, 0x000fe200078e00ffULL,
0x0ffffff800007812ULL, 0x000fc400078ef803ULL, 0x0ffffff802027812ULL, 0x100fe400078ef811ULL,
0xfffffff812117812ULL, 0x000fe200078ee211ULL, 0x0000001000007824ULL, 0x100fe400078e0205ULL,
0x0000001002057824ULL, 0x000fc600078e0205ULL, 0x0000000000087984ULL, 0x0022a80000000c00ULL,
0x00000000050c7984ULL, 0x0044a20000000c00ULL, 0x0000000806077824ULL, 0x048fe400078e00ffULL,
0x0000000806137824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x010fe2000f8e023fULL,
0x000000083d007824ULL, 0x002fe200078e00ffULL, 0xfffffff807027812ULL, 0x000fc400078ee210ULL,
0xfffffff813047812ULL, 0x000fe400078ee204ULL, 0x0000000402107c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000404027c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff800037812ULL, 0x000fe200078ee203ULL,
0x000000ffff057224ULL, 0x004fe200000e06ffULL, 0x00005a0010047a11ULL, 0x000fe200078040ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005a0002067a11ULL, 0x000fc400078240ffULL,
0x00005b0010057a11ULL, 0x000fe400000f4405ULL, 0x00005b0002077a11ULL, 0x000fc600008f4407ULL,
0x0000001003027825ULL, 0x000fc800078e0004ULL, 0x0000001011047825ULL, 0x000fe200078e0006ULL,
0x0000000802007986ULL, 0x000fe8000c101d06ULL, 0x0000000c04007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000004352c7824ULL, 0x000fe400078e0236ULL,
0xffffffffff2d7424ULL, 0x000fc600078e00ffULL, 0x000000032c00720cULL, 0x000fda0003f06070ULL,
0x0000000233058824ULL, 0x000fc800078e00ffULL, 0x0000640005068a24ULL, 0x000fc800078e022cULL,
0x0000600006068625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006800ff087624ULL, 0x000fe200078e00ffULL, 0x00000006062d8981ULL, 0x000ea2000c1e1900ULL,
0x00006900ff097624ULL, 0x000fc600078e00ffULL, 0x00f60000ff047f8cULL, 0x000e68000c80043fULL,
0x0000000608317981ULL, 0x000762000c1e9900ULL, 0x00000001350b7810ULL, 0x000fe20007ffe0ffULL,
0x000000402e2e7824ULL, 0x000fe400078e00ffULL, 0x0000004036307824ULL, 0x000fe200078e00ffULL,
0x000000020b00720cULL, 0x000fe20003f06070ULL, 0x000000403b2f7824ULL, 0x000fc400078e00ffULL,
0x0000002e2d1e7224ULL, 0x004fd400078e02ffULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1d7819ULL, 0x00afe20000011642ULL, 0x0000010035077824ULL, 0x000fe200078e0230ULL,
0x00000003ff0f7819ULL, 0x100fe40000011642ULL, 0x000000300a1f7812ULL, 0x000fe200078ec0ffULL,
0x000000403b067824ULL, 0x000fe200078e021dULL, 0x0000000734007217ULL, 0x000fe40007800000ULL,
0x000000030f0f7812ULL, 0x000fe400078e4842ULL, 0x0000001006087810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a07ULL, 0x0000000806077810ULL, 0x000fc40007ffe0ffULL,
0x000000081e087210ULL, 0x040fe40007f5e0ffULL, 0x000000061e147210ULL, 0x040fe40007f1e0ffULL,
0x000000071e177210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff077224ULL, 0x000fe200010e06ffULL,
0x00005e00080e7a11ULL, 0x000fe200078438ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e0014127a11ULL, 0x000fe200078038ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0017157a11ULL, 0x000fc400078238ffULL, 0x00005f0008107a11ULL, 0x000fe400010f3c07ULL,
0x0000001806077810ULL, 0x000fe40007ffe0ffULL, 0x000000001d00720cULL, 0x000fe40003f66070ULL,
0x00005f0014147a11ULL, 0x000fe400000f3c09ULL, 0x00005f0017177a11ULL, 0x000fe400008f3c0cULL,
0x0000002006087810ULL, 0x000fc40007ffe0ffULL, 0x0000002806097810ULL, 0x040fe40007ffe0ffULL,
0x00000030060a7810ULL, 0x040fe40007ffe0ffULL, 0x00000038060b7810ULL, 0x000fe40007ffe0ffULL,
0x0000100036117811ULL, 0x000fe400078e68ffULL, 0x0ffffffc0f427812ULL, 0x000fe400078ef842ULL,
0x000000071e0d7210ULL, 0x000fc40007f3e0ffULL, 0x000000121f067210ULL, 0x000fe20007f1e0ffULL,
0x0000001042137824ULL, 0x000fe200078e0211ULL, 0x000000081e1a7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x00005e000d0c7a11ULL, 0x040fe200078838ffULL,
0x000000ffff077224ULL, 0x000fe200000e0614ULL, 0x0000000a1e147210ULL, 0x000fe40007f1e0ffULL,
0x00005f000d0d7a11ULL, 0x000fe400020f3c08ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006137faeULL, 0x0003e2000d901c46ULL, 0x000000081d197810ULL, 0x000fc40007ffe0ffULL,
0x0000001f15087210ULL, 0x080fe40007f7e0ffULL, 0x0000001f0e0a7210ULL, 0x080fe20007f9e0ffULL,
0x00000004190e7824ULL, 0x000fe200078e00ffULL, 0x000000101d157810ULL, 0x040fe40007ffe0ffULL,
0x000000181d1b7810ULL, 0x000fe40007ffe0ffULL, 0x0000001f0c0c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff137224ULL, 0x002fe200010e06ffULL, 0x0000000b1e127210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200020e0610ULL, 0x000000091e167210ULL, 0x000fe20007fde0ffULL,
0x000000ffff097224ULL, 0x000fe200018e0617ULL, 0x000000001900720cULL, 0x080fe20003f66070ULL,
0x0000000415107824ULL, 0x040fe200078e00ffULL, 0x000000001500720cULL, 0x080fe20003f86070ULL,
0x000000041b1c7824ULL, 0x040fe200078e00ffULL, 0xfffffffc0e067812ULL, 0x000fe200078ee20fULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x000000001b00720cULL, 0x000fc40003fa6070ULL,
0x00005e001a187a11ULL, 0x000fe200078438ffULL, 0x0000001006077824ULL, 0x000fe200078e0211ULL,
0xfffffffc100e7812ULL, 0x100fe400078ee20fULL, 0xfffffffc1c107812ULL, 0x000fe400078ee20fULL,
0x00005f001a1a7a11ULL, 0x000fe200010f3c13ULL, 0x000000100e137824ULL, 0x100fe200078e0211ULL,
0x000000201d177810ULL, 0x040fe20007ffe0ffULL, 0x0000001010157824ULL, 0x000fe200078e0211ULL,
0x000000281d197810ULL, 0x040fe20007ffe0ffULL, 0x0000000008077faeULL, 0x0003e2000d901c46ULL,
0x000000301d1b7810ULL, 0x000fc40007ffe0ffULL, 0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000000a137faeULL, 0x0005e2000e101c46ULL, 0x000000001700720cULL, 0x080fe20003f46070ULL,
0x0000000419067824ULL, 0x040fe200078e00ffULL, 0x000000001900720cULL, 0x080fe20003f66070ULL,
0x000000000c157faeULL, 0x0007e2000e901c46ULL, 0x000000001b00720cULL, 0x080fe40003f86070ULL,
0x000000001d00720cULL, 0x000fe20003fa6070ULL, 0x0000000417007824ULL, 0x000fe200078e00ffULL,
0xfffffffc06067812ULL, 0x000fe200078ee20fULL, 0x000000041b087824ULL, 0x002fc400078e00ffULL,
0x000000041d0a7824ULL, 0x004fe200078e00ffULL, 0xfffffffc00007812ULL, 0x000fe200078ee20fULL,
0x0000001006137824ULL, 0x000fe200078e0211ULL, 0xfffffffc08087812ULL, 0x100fe200078ee20fULL,
0x000000ffff0d7224ULL, 0x008fe200030e06ffULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee20fULL,
0x00000010000f7824ULL, 0x100fe200078e0211ULL, 0x00005e0016007a11ULL, 0x000fe200078c38ffULL,
0x0000001008157824ULL, 0x100fe400078e0211ULL, 0x000000100a117824ULL, 0x000fe200078e0211ULL,
0x00005f00160d7a11ULL, 0x000fe200030f3c0dULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x0000001f18067210ULL, 0x000fe20007fde0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x00005e00140a7a11ULL, 0x000fc400078038ffULL, 0x0000001f00087210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200030e061aULL, 0x00005e00120c7a11ULL, 0x000fe400078c38ffULL,
0x00005f00140b7a11ULL, 0x000fe400000f3c0bULL, 0x00005f0012007a11ULL, 0x000fe200030f3c09ULL,
0x000000ffff097224ULL, 0x000fe200008e060dULL, 0x0000001f0a0a7210ULL, 0x080fe20007f1e0ffULL,
0x00000000060f7faeULL, 0x0003e2000d101c46ULL, 0x0000001f0c0c7210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000000008137faeULL, 0x0003e2000d901c46ULL,
0x000000ffff0d7224ULL, 0x000fc600008e0600ULL, 0x000000000a157faeULL, 0x0003e8000e101c46ULL,
0x000000000c117faeULL, 0x0003e2000e901c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000002f42007211ULL, 0x04afe400078ff0ffULL, 0x00000020420c7811ULL, 0x000fe400078ff0ffULL,
0x000000001e007210ULL, 0x000fe40007f1e0ffULL, 0x0000003042107811ULL, 0x040fe200078ff0ffULL,
0x000000012f0b7824ULL, 0x040fe200078e020cULL, 0x0000001842087811ULL, 0x040fe200078ff0ffULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x00000028420e7811ULL, 0x000fe200078ff0ffULL,
0x000000012f0f7824ULL, 0x040fe200078e0210ULL, 0x00000003ff137819ULL, 0x000fe20000011642ULL,
0x000000012f097824ULL, 0x040fe200078e0208ULL, 0x00005e0000157a11ULL, 0x000fe200078038ffULL,
0x000000012f0d7824ULL, 0x000fe200078e020eULL, 0x0000000842147811ULL, 0x000fe200078ff0ffULL,
0x0000000410107824ULL, 0x000fe200078e00ffULL, 0x0000001042067811ULL, 0x000fe200078ff0ffULL,
0x000000040e0e7824ULL, 0x000fe200078e00ffULL, 0x0000000313177812ULL, 0x000fe200078e4842ULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0x00005f0000227a11ULL, 0x000fe200000f3c07ULL,
0x000000012f007824ULL, 0x040fe200078e0214ULL, 0x0000003842127811ULL, 0x000fe200078ff0ffULL,
0x000000012f077824ULL, 0x040fe200078e0206ULL, 0x0000000b1e167210ULL, 0x000fe20007f3e0ffULL,
0x0000000406067824ULL, 0x000fe200078e00ffULL, 0x000000091e187210ULL, 0x000fe20007f1e0ffULL,
0x000000012f117824ULL, 0x000fe200078e0212ULL, 0x0000100036237811ULL, 0x000fe200078e68ffULL,
0x000000040c0c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc100b7812ULL, 0x100fe200078ee217ULL,
0x0000000412127824ULL, 0x000fe200078e00ffULL, 0xfffffffc0e097812ULL, 0x000fc400078ee217ULL,
0x000000001e207210ULL, 0x040fe20007fde0ffULL, 0x000000100b217824ULL, 0x100fe200078e0223ULL,
0x000000071e1c7210ULL, 0x000fe20007fbe0ffULL, 0x00000010091f7824ULL, 0x000fe200078e0223ULL,
0xfffffffc08077812ULL, 0x000fe200078ee217ULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0x00005e0018097a11ULL, 0x000fe200078038ffULL, 0x0000000414007824ULL, 0x000fe200078e00ffULL,
0x0000000d1e0d7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff137224ULL, 0x000fe200030e06ffULL,
0x0000000f1e0f7210ULL, 0x040fe20007f7e0ffULL, 0x00000010071b7824ULL, 0x000fe200078e0223ULL,
0x000000111e117210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0xfffffffc06067812ULL, 0x000fc400078ee217ULL, 0xfffffffc0c087812ULL, 0x000fe400078ee217ULL,
0x00005e00201e7a11ULL, 0x000fe200078c38ffULL, 0x0000001006197824ULL, 0x000fe200078e0223ULL,
0x00005f0018187a11ULL, 0x000fe200000f3c0bULL, 0x00000010081d7824ULL, 0x000fe200078e0223ULL,
0x000000300a0b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0a7224ULL, 0x000fe200010e06ffULL,
0xfffffffc00007812ULL, 0x000fe200078ee217ULL, 0x000000ffff087224ULL, 0x000fe200018e06ffULL,
0x00005f0020207a11ULL, 0x000fe200030f3c13ULL, 0x000000ffff137224ULL, 0x000fe200028e06ffULL,
0x00005e00160e7a11ULL, 0x000fc400078238ffULL, 0xfffffffc120c7812ULL, 0x000fe400078ee217ULL,
0x00005e001c1a7a11ULL, 0x000fe400078a38ffULL, 0x000000150b067210ULL, 0x000fe40007f1e0ffULL,
0x00005e000f127a11ULL, 0x000fe400078438ffULL, 0x0ffffffc17427812ULL, 0x000fe200078ef842ULL,
0x0000001000177824ULL, 0x000fe200078e0223ULL, 0x00005f0016167a11ULL, 0x000fe200008f3c07ULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x00005e000d107a11ULL, 0x000fe200078238ffULL,
0x000000ffff077224ULL, 0x000fe200000e0622ULL, 0x00005f001c1c7a11ULL, 0x000fe200028f3c13ULL,
0x0000001042257824ULL, 0x100fe200078e0223ULL, 0x00005e0011147a11ULL, 0x000fe200078638ffULL,
0x000000100c237824ULL, 0x000fe200078e0223ULL, 0x00005f000f137a11ULL, 0x000fc400010f3c08ULL,
0x0000001e0b087210ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006257faeULL, 0x0003e2000b901c46ULL, 0x00005f000d157a11ULL, 0x000fe400008f3c0aULL,
0x0000001a0b0a7210ULL, 0x000fe40007f3e0ffULL, 0x00005f0011007a11ULL, 0x000fe400018f3c00ULL,
0x000000090b0c7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0620ULL,
0x0000000e0b0e7210ULL, 0x000fc40007f7e0ffULL, 0x000000100b107210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e0618ULL, 0x000000120b127210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e0616ULL, 0x000000140b147210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e061cULL, 0x0000000008177faeULL, 0x0003e2000b901c46ULL,
0x000000ffff117224ULL, 0x000fe400020e0615ULL, 0x000000ffff137224ULL, 0x000fe200028e0613ULL,
0x000000000a197faeULL, 0x0003e2000b901c46ULL, 0x000000ffff157224ULL, 0x000fc600000e0600ULL,
0x000000000c1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e4000b901c46ULL, 0x00f60400ff077984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000007ff7812ULL, 0x002fc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe20003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002036007824ULL, 0x002fc800078e0205ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7800ULL,
0x0000000707077812ULL, 0x000fc600078e7800ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001005007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff047f8cULL, 0x002fe8000c80043fULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000023500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000327919ULL, 0x000e620000000000ULL,
0x3db504f331317820ULL, 0x020fe20000410000ULL, 0x0000640033337a24ULL, 0x000fe200078e02ffULL,
0x0000f68836377811ULL, 0x000fe200078e18ffULL, 0x000000ffff3b7224ULL, 0x000fe200078e00ffULL,
0xffffffff02387810ULL, 0x000fe40007ffe0ffULL, 0x0000f60836397811ULL, 0x000fe400078e28ffULL,
0x00000100353d7824ULL, 0x000fe200078e0230ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000003d3400720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x03cfea0003800000ULL,
0x000000ffff3f7224ULL, 0x000fe200078e003bULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fc4000001ff00ULL,
0x0000000100247810ULL, 0x000fe20007ffe0ffULL, 0x00000d7000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4c7224ULL, 0x000fe200078e0000ULL, 0x000000013f3b7812ULL, 0x000fe200078e0cffULL,
0x0000002e2d477224ULL, 0x020fe200078e02ffULL, 0x00000001ff267819ULL, 0x100fe20000011624ULL,
0x000000ffff007224ULL, 0x000fe200078e0024ULL, 0x000000022400780cULL, 0x000fc40003f06070ULL,
0x0000000124567812ULL, 0x000fe200078ec0ffULL, 0x0000030026277a24ULL, 0x000fca00078e0235ULL,
0x0000000127257810ULL, 0x000fc80007ffe0ffULL, 0x000000022500720cULL, 0x000fda0003f26070ULL,
0x000006c000009947ULL, 0x000fea0003800000ULL, 0x00000002ff417819ULL, 0x002fe20000011632ULL,
0x0000010027257824ULL, 0x000fe400078e0230ULL, 0x0000000456497824ULL, 0x000fe200078e00ffULL,
0x0000000841447810ULL, 0x000fe20007ffe0ffULL, 0x000000012f247824ULL, 0x000fe200078e0241ULL,
0x00000010414e7810ULL, 0x000fe40007ffe0ffULL, 0x00000025342a7217ULL, 0x000fe20007800000ULL,
0x000000012f267824ULL, 0x000fe200078e0244ULL, 0x0000002447407210ULL, 0x000fe20007f3e0ffULL,
0x000000012f277824ULL, 0x000fe200078e024eULL, 0x0000001841507810ULL, 0x000fe20007ffe0ffULL,
0x000000012a3a7824ULL, 0x000fe200078e0a25ULL, 0x00000026472b7210ULL, 0x000fc40007f5e0ffULL,
0x0000002747297210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff277224ULL, 0x000fe200008e06ffULL,
0x00005e0040247a11ULL, 0x000fe200078238ffULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x00005e002b267a11ULL, 0x000fe200078438ffULL, 0x000000012f2a7824ULL, 0x000fe200078e0250ULL,
0x0000002041517810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0x0000003041537810ULL, 0x000fe40007ffe0ffULL, 0x00005e0029287a11ULL, 0x000fc400078638ffULL,
0x00005f0040257a11ULL, 0x000fe400008f3c27ULL, 0x0000002841527810ULL, 0x040fe40007ffe0ffULL,
0x0000003841547810ULL, 0x000fe40007ffe0ffULL, 0x00005f002b277a11ULL, 0x000fe200010f3c3eULL,
0x000000012f2b7824ULL, 0x000fe200078e0251ULL, 0x0000002a47427210ULL, 0x000fe20007f3e0ffULL,
0x000000012f3e7824ULL, 0x000fe200078e0253ULL, 0x00005f0029297a11ULL, 0x000fe200018f3c3cULL,
0x000000012f3c7824ULL, 0x000fe200078e0252ULL, 0x0000003a4100720cULL, 0x000fe20003f46070ULL,
0x000000012f407824ULL, 0x000fe200078e0254ULL, 0x0000002b47417210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2b7224ULL, 0x000fe200008e06ffULL, 0x00005e00422a7a11ULL, 0x000fc400078238ffULL,
0x0000003e47457210ULL, 0x040fe40007f9e0ffULL, 0x0000003c47437210ULL, 0x040fe20007fde0ffULL,
0x00000002363c7824ULL, 0x000fe200078e023bULL, 0x00000040473e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0x00000003ff477819ULL, 0x100fe20000011632ULL,
0x000000ffff4a7224ULL, 0x000fe200030e06ffULL, 0x00005f00422b7a11ULL, 0x000fe200008f3c2bULL,
0x000000ffff427224ULL, 0x000fe200028e06ffULL, 0x0000003a4400720cULL, 0x040fe20003f26070ULL,
0x0000000444447824ULL, 0x000fe200078e00ffULL, 0x00000003474f7812ULL, 0x000fe200078e4832ULL,
0x000000ffff477224ULL, 0x000fe200018e06ffULL, 0x000010003c3c7811ULL, 0x000fc400078e60ffULL,
0x0ffffffc4f4b7812ULL, 0x100fe400078ef832ULL, 0xfffffffc49497812ULL, 0x000fe400078ee232ULL,
0xfffffffc444d7812ULL, 0x000fe200078ee24fULL, 0x000000104b4b7824ULL, 0x000fe200078e023cULL,
0x00005e0041407a11ULL, 0x000fe200078a38ffULL, 0x0000001049247825ULL, 0x000fe200078e0024ULL,
0x00005e0045447a11ULL, 0x000fe400078838ffULL, 0x00005f0041417a11ULL, 0x000fe200028f3c42ULL,
0x000000104d4d7824ULL, 0x000fe200078e023cULL, 0x00005e0043427a11ULL, 0x000fe200078a38ffULL,
0x0000001049267825ULL, 0x000fe200078e0026ULL, 0x00005e003e467a11ULL, 0x000fe200078638ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000244b7faeULL, 0x0003e2000d101c46ULL,
0x00005f0043437a11ULL, 0x000fc400028f3c4aULL, 0x00005f0045457a11ULL, 0x000fe200020f3c48ULL,
0x00000000264d7faeULL, 0x0005e2000c901c46ULL, 0x00005f003e477a11ULL, 0x000fe400018f3c47ULL,
0x0000003a4e00720cULL, 0x0c0fe20003f26070ULL, 0x000000044e4e7824ULL, 0x000fe200078e00ffULL,
0x0000003a5000720cULL, 0x0c0fe20003f46070ULL, 0x0000000450507824ULL, 0x000fe200078e00ffULL,
0x0000003a5100720cULL, 0x080fe20003f66070ULL, 0x0000000453247824ULL, 0x042fe200078e00ffULL,
0x0000003a5200720cULL, 0x0c0fe20003f86070ULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x0000003a5300720cULL, 0x080fe20003fa6070ULL, 0x0000001049267825ULL, 0x004fe200078e002aULL,
0x0000003a5400720cULL, 0x000fc40003fc6070ULL, 0xfffffffc4e4b7812ULL, 0x100fe200078ee24fULL,
0x00000004513a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc504d7812ULL, 0x100fe200078ee24fULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0xfffffffc52517812ULL, 0x100fe200078ee24fULL,
0x000000104b4b7824ULL, 0x100fe200078e023cULL, 0xfffffffc3a257812ULL, 0x100fe200078ee24fULL,
0x000000104d4d7824ULL, 0x100fe200078e023cULL, 0xfffffffc24537812ULL, 0x100fe200078ee24fULL,
0x0000001051517824ULL, 0x100fe200078e023cULL, 0xfffffffc54557812ULL, 0x000fe200078ee24fULL,
0x00000010254f7824ULL, 0x000fc400078e023cULL, 0x0000001049247825ULL, 0x000fc800078e0028ULL,
0x0000001049287825ULL, 0x040fe200078e0040ULL, 0x00000000244b7faeULL, 0x0003e6000c901c46ULL,
0x00000010492a7825ULL, 0x000fe200078e0042ULL, 0x00000000264d7faeULL, 0x0003e6000d101c46ULL,
0x0000001053537824ULL, 0x000fe200078e023cULL, 0x00000000284f7faeULL, 0x0003e2000d901c46ULL,
0x0000001049407825ULL, 0x000fc600078e0044ULL, 0x000000002a517faeULL, 0x0003e2000e101c46ULL,
0x0000001055557824ULL, 0x000fe400078e023cULL, 0x0000001049427825ULL, 0x000fe200078e0046ULL,
0x0000000040537faeULL, 0x0003e8000e901c46ULL, 0x0000000042557faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x0000000832407811ULL, 0x002fe200078ff0ffULL,
0x0000000456577824ULL, 0x000fe200078e00ffULL, 0x0000002f32247211ULL, 0x000fc400078ff0ffULL,
0x0000002032447811ULL, 0x000fe200078ff0ffULL, 0x000000012f267824ULL, 0x040fe200078e0240ULL,
0x0000004724257210ULL, 0x080fe20007f3e0ffULL, 0x0000000440407824ULL, 0x000fe200078e00ffULL,
0x0000001832427811ULL, 0x000fe200078ff0ffULL, 0x000000012f3e7824ULL, 0x000fe200078e0244ULL,
0x0000004726277210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x00005e0025247a11ULL, 0x000fe200078238ffULL, 0x000000012f3c7824ULL, 0x000fe200078e0242ULL,
0x0000002832467811ULL, 0x000fe200078ff0ffULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x00005e0027267a11ULL, 0x000fc400078438ffULL, 0x00005f0025257a11ULL, 0x000fe200008f3c2aULL,
0x000000012f487824ULL, 0x000fe200078e0246ULL, 0x00000010322a7811ULL, 0x000fe400078ff0ffULL,
0x00005f0027277a11ULL, 0x000fe200010f3c28ULL, 0x0000000236287824ULL, 0x000fe200078e023bULL,
0x00000030324a7811ULL, 0x000fe200078ff0ffULL, 0x000000012f3a7824ULL, 0x040fe200078e022aULL,
0x00000003ff437819ULL, 0x000fe20000011632ULL, 0x000000042a2a7824ULL, 0x000fe200078e00ffULL,
0x0000003832507811ULL, 0x000fe200078ff0ffULL, 0x000000012f4e7824ULL, 0x000fe200078e024aULL,
0x0000000343437812ULL, 0x000fc400078e4832ULL, 0x0000100028557811ULL, 0x000fe200078e60ffULL,
0x0000000442287824ULL, 0x000fe200078e00ffULL, 0x000000473a297210ULL, 0x080fe20007fde0ffULL,
0x000000012f527824ULL, 0x000fe200078e0250ULL, 0x000000473e417210ULL, 0x080fe20007f9e0ffULL,
0x0000000450507824ULL, 0x000fe200078e00ffULL, 0x000000473c2b7210ULL, 0x080fe40007fbe0ffULL,
0x00000047483e7210ULL, 0x080fe20007f3e0ffULL, 0x0000000444487824ULL, 0x000fe200078e00ffULL,
0x000000474e3c7210ULL, 0x000fe20007f5e0ffULL, 0x00000004464e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc40427812ULL, 0x000fc400078ee243ULL, 0xfffffffc2a447812ULL, 0x000fe200078ee243ULL,
0x000000ffff2a7224ULL, 0x000fe200030e06ffULL, 0x0ffffffc43407812ULL, 0x000fe200078ef832ULL,
0x0000001042497824ULL, 0x000fe200078e0255ULL, 0xfffffffc28467812ULL, 0x000fe200078ee243ULL,
0x00000010444b7824ULL, 0x100fe200078e0255ULL, 0x00005e0029287a11ULL, 0x040fe200078c38ffULL,
0x0000001040597824ULL, 0x000fe200078e0255ULL, 0x00000047523a7210ULL, 0x000fe20007f7e0ffULL,
0x000000044a527824ULL, 0x000fe200078e00ffULL, 0xfffffffc48487812ULL, 0x000fe200078ee243ULL,
0x000000ffff407224ULL, 0x000fe200028e06ffULL, 0x00005f0029297a11ULL, 0x000fe200030f3c2aULL,
0x000000ffff457224ULL, 0x000fe200010e06ffULL, 0x00005e002b2a7a11ULL, 0x040fe200078a38ffULL,
0x00000010484f7824ULL, 0x000fe200078e0255ULL, 0xfffffffc4e4a7812ULL, 0x100fe200078ee243ULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0xfffffffc524e7812ULL, 0x000fe200078ee243ULL,
0x00000010464d7824ULL, 0x000fe200078e0255ULL, 0xfffffffc50507812ULL, 0x000fe200078ee243ULL,
0x000000ffff437224ULL, 0x000fe200008e06ffULL, 0x00005f002b2b7a11ULL, 0x000fe200028f3c40ULL,
0x000000ffff477224ULL, 0x000fe200018e06ffULL, 0xfffffffc57577812ULL, 0x000fe200078ee232ULL,
0x000000104a517824ULL, 0x100fe200078e0255ULL, 0x00005e0041407a11ULL, 0x000fe200078838ffULL,
0x000000104e537824ULL, 0x000fe200078e0255ULL, 0x00005e003e427a11ULL, 0x000fe200078238ffULL,
0x0000001057247825ULL, 0x000fe200078e0024ULL, 0x00005e003c447a11ULL, 0x000fc400078438ffULL,
0x00005e003a467a11ULL, 0x000fe200078638ffULL, 0x0000001057267825ULL, 0x000fe200078e0026ULL,
0x00005f0041417a11ULL, 0x000fe200020f3c48ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024597faeULL, 0x0003e2000b901c46ULL, 0x00005f003e437a11ULL, 0x000fe200008f3c43ULL,
0x0000001057287825ULL, 0x040fe200078e0028ULL, 0x00005f003c457a11ULL, 0x000fe200010f3c45ULL,
0x0000000026497faeULL, 0x0003e2000b901c46ULL, 0x00005f003a477a11ULL, 0x000fe200018f3c47ULL,
0x00000010572a7825ULL, 0x040fe400078e002aULL, 0x00000000284b7faeULL, 0x0003e4000b901c46ULL,
0x0000001057407825ULL, 0x000fc400078e0040ULL, 0x000000002a4d7faeULL, 0x0003e4000b901c46ULL,
0x0000001057427825ULL, 0x040fe400078e0042ULL, 0x00000000404f7faeULL, 0x0003e4000b901c46ULL,
0x0000001057447825ULL, 0x000fe400078e0044ULL, 0x0000000042517faeULL, 0x0003e4000b901c46ULL,
0x0000001050557824ULL, 0x000fc400078e0255ULL, 0x0000001057467825ULL, 0x000fe200078e0046ULL,
0x0000000044537faeULL, 0x0003e8000b901c46ULL, 0x0000000046557faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5600720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x00000004ff257424ULL, 0x002fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x00000300252c7a24ULL, 0x000fca00078e022cULL, 0x000000032c00720cULL, 0x000fda0003f26070ULL,
0x0000003000001947ULL, 0x000fea0003800000ULL, 0x0000000233247824ULL, 0x000fc800078e022cULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x00000006242d7981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000084c417824ULL, 0x002fe400078e00ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff832257812ULL, 0x000fe200078ec0ffULL,
0x0000000236437824ULL, 0x000fe200078e023fULL, 0x0000002032297810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000725257812ULL, 0x000fe400078ef832ULL,
0xfffffff829297812ULL, 0x000fc400078ec0ffULL, 0x00000001ff247819ULL, 0x000fe40000011625ULL,
0x0000000729267812ULL, 0x000fe400078ef832ULL, 0x0000000324277812ULL, 0x000fe400078ec0ffULL,
0x00000001ff287819ULL, 0x000fe40000011626ULL, 0x0000003a27247212ULL, 0x000fe400078e3cffULL,
0x0000000328457812ULL, 0x000fc400078ec0ffULL, 0x0000100043437811ULL, 0x000fe200078e60ffULL,
0x0000000425247824ULL, 0x000fe200078e0224ULL, 0x0000003a45297212ULL, 0x000fe400078e3cffULL,
0x000000013a3c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010244c7824ULL, 0x000fe200078e0243ULL,
0x000000023a3a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000426247824ULL, 0x000fc600078e0229ULL,
0x000000043a00780cULL, 0x000fe20003f25270ULL, 0x0000001024287824ULL, 0x000fe200078e0243ULL,
0x0000003c27247212ULL, 0x000fe200078e3cffULL, 0x000000004c4c783bULL, 0x000e620000000200ULL,
0x0000000732277812ULL, 0x000fc600078ec0ffULL, 0x00000004253e7824ULL, 0x000fe200078e0224ULL,
0x0000000827487812ULL, 0x000fe200078ef832ULL, 0x000000002828783bULL, 0x000fe20000000200ULL,
0x0000003c45277212ULL, 0x000fe200078e3cffULL, 0x000000103e3e7824ULL, 0x000fe200078e0243ULL,
0x0000004132247211ULL, 0x000fe400078fe0ffULL, 0x0000000441417810ULL, 0x000fe20007ffe0ffULL,
0x0000000426267824ULL, 0x000fe200078e0227ULL, 0x0000000224257810ULL, 0x040fe20007ffe0ffULL,
0x000000003e44783bULL, 0x000ea20000000200ULL, 0x0000000724247812ULL, 0x100fe200078e7848ULL,
0x0000001026267824ULL, 0x000fe200078e0243ULL, 0x0000000725257812ULL, 0x000fc600078e7848ULL,
0x0000001048507824ULL, 0x040fe400078e0224ULL, 0x0000001048487824ULL, 0x000fe400078e0225ULL,
0x000000002624783bULL, 0x000ee20000000200ULL, 0x00000010ff517819ULL, 0x102fe4000001164cULL,
0x00000018ff3c7819ULL, 0x000fe4000001164cULL, 0x000000ff4c497812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4c727812ULL, 0x000fc400078ec0ffULL, 0x00000010ff527819ULL, 0x100fe4000001164dULL,
0x00000018ff4a7819ULL, 0x000fe4000001164dULL, 0x000000ff4d4b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4d737812ULL, 0x000fe400078ec0ffULL, 0x00000010ff537819ULL, 0x100fe4000001164eULL,
0x00000018ff4c7819ULL, 0x000fc4000001164eULL, 0x000000ff4e4d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e747812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4e7819ULL, 0x100fe4000001164fULL,
0x000000ff44607812ULL, 0x004fe400078ec0ffULL, 0x00000010ff547819ULL, 0x000fe4000001164fULL,
0x000000ff4f557812ULL, 0x000fc400078ec0ffULL, 0x0000ffff4f757812ULL, 0x000fe400078ec0ffULL,
0x00000010ff587819ULL, 0x100fe40000011628ULL, 0x00000018ff4f7819ULL, 0x000fe40000011628ULL,
0x000000ff28567812ULL, 0x040fe400078ec0ffULL, 0x0000ffff28847812ULL, 0x000fe400078ec0ffULL,
0x00000010ff617819ULL, 0x000fc40000011645ULL, 0x00000018ff667819ULL, 0x000fe40000011645ULL,
0x000000ff45677812ULL, 0x040fe400078ec0ffULL, 0x0000ffff45867812ULL, 0x000fe400078ec0ffULL,
0x00000010ff287819ULL, 0x108fe40000011624ULL, 0x00000018ff7b7819ULL, 0x000fe40000011624ULL,
0x000000ff247c7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff24457812ULL, 0x000fe400078ec0ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x00000060ff24723eULL, 0x000fe400020006ffULL,
0x00000049ff49723eULL, 0x000fe200020006ffULL, 0x2000004eff607230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fe20000011644ULL, 0x20000024ff4e7230ULL, 0x000fe20000004100ULL,
0x00000008ff247819ULL, 0x000fe20000011672ULL, 0x20000049ff6c7230ULL, 0x000fe20000004100ULL,
0x00000018ff5f7819ULL, 0x000fc40000011644ULL, 0x0000ffff44857812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6d7819ULL, 0x000fe40000011646ULL, 0x00000010ff447819ULL, 0x100fe40000011625ULL,
0x00000018ff7e7819ULL, 0x000fe40000011625ULL, 0x000000ff257f7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff253e7812ULL, 0x000fc400078ec0ffULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x00000008ff257819ULL, 0x000fe40000011673ULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x0000006dff49723eULL, 0x000fe200020006ffULL, 0x20000024ff6d7230ULL, 0x000fe20000004100ULL,
0x00000018ff707819ULL, 0x000fe20000011647ULL, 0x2000004bff6b7230ULL, 0x000fe20000004100ULL,
0x00000025ff25723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000008ff247819ULL, 0x000fc40000011674ULL, 0x00000070ff4b723eULL, 0x000fe200020006ffULL,
0x20000025ff707230ULL, 0x000fe20000004100ULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x00000008ff257819ULL, 0x000fe20000011675ULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x100fe2000001162aULL, 0x20000024ff727230ULL, 0x000fe20000004100ULL,
0x00000018ff5a7819ULL, 0x000fe4000001162aULL, 0x000000ff2a5b7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff2a627812ULL, 0x000fe400078ec0ffULL, 0x000000ff2b5d7812ULL, 0x000fe400078ec0ffULL,
0x00000025ff25723eULL, 0x000fe400020006ffULL, 0x0000003cff2a723eULL, 0x000fe400020006ffULL,
0x00000008ff247819ULL, 0x000fe20000011685ULL, 0x20000025ff747230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x2000002aff6f7230ULL, 0x000fe20000004100ULL,
0x000000ff61617812ULL, 0x000fc400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe40000011629ULL,
0x00000024ff24723eULL, 0x000fe400020006ffULL, 0x00000008ff257819ULL, 0x000fe40000011686ULL,
0x0000ffff46877812ULL, 0x000fe400078ec0ffULL, 0x00000055ff2a723eULL, 0x000fe400020006ffULL,
0x00000061ff55723eULL, 0x000fe200020006ffULL, 0x2000005dff617230ULL, 0x000fe20000004100ULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x20000024ff5d7230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x2000002aff2a7230ULL, 0x000fe20000004100ULL,
0x00000025ff25723eULL, 0x000fe200020006ffULL, 0x20000057ff7d7230ULL, 0x000fe20000004100ULL,
0x00000008ff247819ULL, 0x000fe20000011687ULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x00000010ff787819ULL, 0x000fe20000011647ULL, 0x20000025ff577230ULL, 0x000fe20000004100ULL,
0x000000ff47717812ULL, 0x000fc400078ec0ffULL, 0x0000ffff47887812ULL, 0x000fe400078ec0ffULL,
0x00000067ff47723eULL, 0x000fe200020006ffULL, 0x2000005bff677230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000024ff5b723eULL, 0x000fe200020006ffULL,
0x0000001050247824ULL, 0x000fe200078e00ffULL, 0x00000008ff257819ULL, 0x000fe20000011688ULL,
0x20000056ff767230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x100fe20000011626ULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000018ff807819ULL, 0x000fe20000011626ULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x000000ff26817812ULL, 0x000fc400078ec0ffULL,
0x0000ffff26407812ULL, 0x000fe400078ec0ffULL, 0x00000010ff427819ULL, 0x100fe40000011627ULL,
0x00000018ff827819ULL, 0x000fe40000011627ULL, 0x000000ff27837812ULL, 0x040fe400078ec0ffULL,
0x0000ffff27437812ULL, 0x000fe400078ec0ffULL, 0x00000025ff56723eULL, 0x000fc400020006ffULL,
0x000000002424783bULL, 0x000e620000000200ULL, 0x000000ff51517812ULL, 0x000fe400078ec0ffULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x000000ff466e7812ULL, 0x000fe400078ec0ffULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x2000004aff6a7230ULL, 0x000fe20000004100ULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x0000006eff4a723eULL, 0x000fe200020006ffULL, 0x20000051ff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff687819ULL, 0x000fe20000011629ULL, 0x2000004fff797230ULL, 0x000fe20000004100ULL,
0x0000ffff29697812ULL, 0x000fe200078ec0ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x0000007bff4f723eULL, 0x000fc400020006ffULL, 0x0000007cff50723eULL, 0x000fe400020006ffULL,
0x000000ff687c7812ULL, 0x000fe200078ec0ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000008ff7b7819ULL, 0x000fe20000011669ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x000000ff52527812ULL, 0x000fe400078ec0ffULL, 0x00000010ff687819ULL, 0x000fe4000001166fULL,
0x00000010ff697819ULL, 0x000fc4000001166eULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x000000ff29597812ULL, 0x000fe400078ec0ffULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x0000105468697816ULL, 0x000fe20000000069ULL, 0x2000004cff657230ULL, 0x000fe20000004100ULL,
0x000000ff63637812ULL, 0x000fc400078ec0ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x000000ff53537812ULL, 0x000fe400078ec0ffULL, 0x000000ff54547812ULL, 0x000fe200078ec0ffULL,
0x2000004dff647230ULL, 0x000fe20000004100ULL, 0x000010546d687816ULL, 0x000fe4000000006cULL,
0x00000018ff5c7819ULL, 0x000fe4000001162bULL, 0x00000059ff59723eULL, 0x000fc400020006ffULL,
0x00000010ff777819ULL, 0x000fe20000011646ULL, 0x00000068240c723cULL, 0x002fe2000004180cULL,
0x00000071ff4c723eULL, 0x000fe200020006ffULL, 0x20000052ff717230ULL, 0x000fe20000004100ULL,
0x00000008ff627819ULL, 0x000fe20000011662ULL, 0x20000059ff7a7230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x20000063ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff297819ULL, 0x000fe2000001162bULL,
0x20000053ff737230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000054ff757230ULL, 0x000fe20000004100ULL, 0x000000ff78787812ULL, 0x000fc400078ec0ffULL,
0x000000ff77777812ULL, 0x000fe400078ec0ffULL, 0x000000ff58597812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000008ff587819ULL, 0x000fe40000011684ULL,
0x0000005fff4d723eULL, 0x000fe200020006ffULL, 0x2000005cff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff6a7819ULL, 0x000fe2000001166aULL, 0x20000062ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x000000ff29637812ULL, 0x000fc400078ec0ffULL, 0x00000078ff54723eULL, 0x000fe400020006ffULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff297819ULL, 0x000fe20000011672ULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x00000077ff5c723eULL, 0x000fe400020006ffULL,
0x00000059ff78723eULL, 0x000fe400020006ffULL, 0x00000058ff77723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x000010546a717816ULL, 0x000fe20000000071ULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fe20000011665ULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fc40000011673ULL,
0x00000063ff6a723eULL, 0x000fe400020006ffULL, 0x0000105429647816ULL, 0x000fe40000000064ULL,
0x00000010ff607819ULL, 0x000fe20000011660ULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fe40000011675ULL, 0x00000010ff2a7819ULL, 0x000fe4000001162aULL,
0x00000010ff297819ULL, 0x000fc40000011674ULL, 0x0000ffff2b2b7812ULL, 0x000fe400078ec0ffULL,
0x0000105462657816ULL, 0x000fe40000000065ULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000105460637816ULL, 0x000fe40000000063ULL, 0x0000105429627816ULL, 0x000fe2000000002aULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000008ff297819ULL, 0x000fe2000001162bULL,
0x000000642404723cULL, 0x000fe20000041804ULL, 0x00000010ff2a7819ULL, 0x000fc40000011679ULL,
0x00000010ff2b7819ULL, 0x000fe40000011678ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff777819ULL, 0x000fe20000011677ULL, 0x000000622420723cULL, 0x000fe20000041820ULL,
0x000010542a2b7816ULL, 0x000fe4000000002bULL, 0x00001054772a7816ULL, 0x000fe40000000076ULL,
0x0000007bff7b723eULL, 0x000fc400020006ffULL, 0x00000029ff60723eULL, 0x000fe200020006ffULL,
0x0000001048297824ULL, 0x000fe200078e00ffULL, 0x000000ff28627812ULL, 0x000fe200078ec0ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff287819ULL, 0x000fe2000001167dULL,
0x0000002a241c723cULL, 0x000fe2000004181cULL, 0x00000010ff637819ULL, 0x000fe2000001167cULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x0000105428637816ULL, 0x000fc40000000063ULL, 0x000000002928783bULL, 0x000e620000000200ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000062ff48723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x000010547b627816ULL, 0x000fe2000000007aULL,
0x20000048ff647230ULL, 0x000fe20000004100ULL, 0x0000105470707816ULL, 0x000fc4000000006bULL,
0x00000066ff46723eULL, 0x000fe200020006ffULL, 0x2000005aff667230ULL, 0x000fe20000004100ULL,
0x00000008ff487819ULL, 0x000fe20000011645ULL, 0x000000622414723cULL, 0x040fe20000041814ULL,
0x00000010ff457819ULL, 0x000fe2000001166aULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x000000ff44627812ULL, 0x000fe200078ec0ffULL, 0x000000702408723cULL, 0x000fe20000041808ULL,
0x00000010ff447819ULL, 0x000fc4000001165fULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x0000105444457816ULL, 0x000fe40000000045ULL,
0x0000105466697816ULL, 0x000fc40000000069ULL, 0x0000105468687816ULL, 0x000fe40000000067ULL,
0x0000105460447816ULL, 0x000fe40000000061ULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff467819ULL, 0x000fe20000011646ULL, 0x000000682418723cULL, 0x000fe20000041818ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000010ff477819ULL, 0x000fc40000011647ULL,
0x00000048ff48723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff3e7819ULL, 0x000fe2000001163eULL, 0x000000442410723cULL, 0x000fe20000041810ULL,
0x00000010ff4a7819ULL, 0x000fe2000001164aULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x000000ff42427812ULL, 0x000fe400078ec0ffULL,
0x00000010ff257819ULL, 0x000fc40000011655ULL, 0x00000010ff247819ULL, 0x000fe40000011657ULL,
0x0000105446257816ULL, 0x000fe40000000025ULL, 0x0000105424247816ULL, 0x000fe40000000047ULL,
0x00000010ff267819ULL, 0x000fe40000011649ULL, 0x00000010ff277819ULL, 0x000fe4000001165cULL,
0x00000010ff4d7819ULL, 0x000fe2000001164dULL, 0x000000242808723cULL, 0x002fe20000041808ULL,
0x00000010ff5e7819ULL, 0x000fc4000001165eULL, 0x0000105426277816ULL, 0x000fe40000000027ULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x000010545b267816ULL, 0x000fe4000000004aULL,
0x00000010ff4c7819ULL, 0x000fe2000001164cULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe40000011656ULL, 0x0000007fff52723eULL, 0x000fe200020006ffULL,
0x000000262804723cULL, 0x000fe20000041804ULL, 0x00000042ff42723eULL, 0x000fc400020006ffULL,
0x000010544d5f7816ULL, 0x000fe2000000005eULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000008ff407819ULL, 0x000fe20000011640ULL, 0x20000042ff447230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe4000001164bULL, 0x00000010ff4d7819ULL, 0x000fe40000011654ULL,
0x00001054254c7816ULL, 0x000fe4000000004cULL, 0x0000007eff51723eULL, 0x000fc400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000010ff507819ULL, 0x000fe20000011650ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe20000011648ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL, 0x00000040ff40723eULL, 0x000fe200020006ffULL,
0x20000081ff587230ULL, 0x000fe20000004100ULL, 0x00001054244d7816ULL, 0x000fc4000000004dULL,
0x00000008ff427819ULL, 0x000fe20000011643ULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe4000001164fULL, 0x00000010ff277819ULL, 0x000fe20000011664ULL,
0x0000004c2820723cULL, 0x000fe20000041820ULL, 0x0000105425267816ULL, 0x000fe40000000050ULL,
0x00000080ff53723eULL, 0x000fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fc400020006ffULL,
0x00000010ff257819ULL, 0x000fe2000001163eULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000082ff5a723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000010ff527819ULL, 0x000fe20000011652ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000042ff3e723eULL, 0x000fe200020006ffULL,
0x20000083ff597230ULL, 0x000fe20000004100ULL, 0x0000105424277816ULL, 0x000fc40000000027ULL,
0x00000010ff247819ULL, 0x000fe20000011651ULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000010ff437819ULL, 0x000fe40000011662ULL, 0x0000105425427816ULL, 0x000fe20000000052ULL,
0x00000026281c723cULL, 0x000fe2000004181cULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff257819ULL, 0x000fe40000011640ULL, 0x0000105424437816ULL, 0x000fc40000000043ULL,
0x00000010ff247819ULL, 0x000fe40000011653ULL, 0x00000010ff277819ULL, 0x000fe4000001163cULL,
0x0000105425267816ULL, 0x000fe20000000058ULL, 0x000000422814723cULL, 0x000fe20000041814ULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff5a7819ULL, 0x000fc4000001165aULL, 0x00000010ff257819ULL, 0x000fe40000011644ULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff3e7819ULL, 0x000fe4000001163eULL,
0x0000105424277816ULL, 0x000fe40000000027ULL, 0x000010545d5e7816ULL, 0x000fe4000000004eULL,
0x000010545a257816ULL, 0x000fc40000000025ULL, 0x000010543e247816ULL, 0x000fe20000000059ULL,
0x000000262818723cULL, 0x040ff00000041818ULL, 0x0000005e280c723cULL, 0x040ff0000004180cULL,
0x000000242810723cULL, 0x000fe20000041810ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe82000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff3f7224ULL, 0x000fe200078e003bULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd95000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000037247f8cULL, 0x000fe2000c80043fULL,
0x0000002131217220ULL, 0x040fe20000410000ULL, 0x0000000e31007220ULL, 0x040fe20000410000ULL,
0x0000000f31267220ULL, 0x040fe20000410000ULL, 0x0000040037277984ULL, 0x000e620000000800ULL,
0x0000002231227220ULL, 0x040fe20000410000ULL, 0x0000001d311d7220ULL, 0x040fe20000410000ULL,
0x00000017312b7220ULL, 0x040fe20000410000ULL, 0x0000000c310c7220ULL, 0x040fe20000410000ULL,
0x0000000d310d7220ULL, 0x040fe20000410000ULL, 0x0000000a31287220ULL, 0x040fe20000410000ULL,
0x0000000b31297220ULL, 0x040fe20000410000ULL, 0x00000004310e7220ULL, 0x040fe20000410000ULL,
0x00000005310f7220ULL, 0x040fe20000410000ULL, 0x0000002031207220ULL, 0x040fe20000410000ULL,
0x0000002331237220ULL, 0x040fe20000410000ULL, 0x00000016312a7220ULL, 0x040fe20000410000ULL,
0x0000001931177220ULL, 0x040fe20000410000ULL, 0x0000000831087220ULL, 0x040fe20000410000ULL,
0x0000000931097220ULL, 0x040fe20000410000ULL, 0x0000000631067220ULL, 0x040fe20000410000ULL,
0x0000000731077220ULL, 0x040fe20000410000ULL, 0x0000001c311c7220ULL, 0x040fe20000410000ULL,
0x0000001e31047220ULL, 0x040fe20000410000ULL, 0x0000001f31057220ULL, 0x040fe20000410000ULL,
0x0000001a313a7220ULL, 0x040fe20000410000ULL, 0x0000001b313c7220ULL, 0x040fe20000410000ULL,
0x0000001131197220ULL, 0x040fe20000410000ULL, 0x0000001831167220ULL, 0x040fe20000410000ULL,
0x00000013313f7220ULL, 0x040fe20000410000ULL, 0x000000ffff117224ULL, 0x000fe200078e0021ULL,
0x0000001031187220ULL, 0x040fe20000410000ULL, 0x000000ffff137224ULL, 0x000fe200078e001dULL,
0x00000012313e7220ULL, 0x040fe20000410000ULL, 0x000000ffff217224ULL, 0x000fe200078e0022ULL,
0x0000001431147220ULL, 0x040fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e000cULL,
0x0000001531157220ULL, 0x000fe20000410000ULL, 0x000000ffff0a7224ULL, 0x000fc400078e000dULL,
0x000000ffff107224ULL, 0x000fe400078e0020ULL, 0x000000ffff1b7224ULL, 0x000fe200078e0026ULL,
0x8000000027ff7812ULL, 0x002fe20007804825ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0028ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0029ULL, 0x000000ffff227224ULL, 0x000fe400078e0023ULL,
0x000000ffff277224ULL, 0x000fc400078e002aULL, 0x000000ffff0c7224ULL, 0x000fe400078e0008ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0009ULL, 0x000000ffff127224ULL, 0x000fe400078e001cULL,
0x000000ffff1a7224ULL, 0x000fe400078e0000ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0006ULL,
0x000000ffff207224ULL, 0x000fc400078e0007ULL, 0x000000ffff237224ULL, 0x000fe400078e0004ULL,
0x000000ffff267224ULL, 0x000fe400078e0005ULL, 0x000000ffff287224ULL, 0x000fe400078e002bULL,
0x000000ffff297224ULL, 0x000fe400078e003aULL, 0x000000ffff2a7224ULL, 0x000fe200078e003cULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2b7224ULL, 0x000fc400078e003eULL, 0x000000ffff3a7224ULL, 0x000fe200078e003fULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x0000040037057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004321c7824ULL, 0x000fe200078e00ffULL, 0x000000383500720cULL, 0x000fc80003f05270ULL,
0xfffffff01c057812ULL, 0x000fca00078ec0ffULL, 0x0000008036007824ULL, 0x000fca00078e0205ULL,
0x00f4000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000232087824ULL, 0x000fe400078e00ffULL, 0x00000001343d7824ULL, 0x000fc600078e0a3dULL,
0x0000000608087812ULL, 0x000fc800078ec0ffULL, 0x0000000108247812ULL, 0x040fe400078efcffULL,
0x00000008083c7812ULL, 0x000fe400078efcffULL, 0x0000003d2400720cULL, 0x080fe40003f26070ULL,
0x0000001008247812ULL, 0x000fe400078efcffULL, 0x0000003d3c00720cULL, 0x080fe40003f06070ULL,
0x0000003d2400720cULL, 0x000fc40003fc6070ULL, 0x00000011083c7812ULL, 0x040fe400078efcffULL,
0x0000001808247812ULL, 0x040fe400078efcffULL, 0x0000003d0800720cULL, 0x080fe40003f46070ULL,
0x0000003d3c00720cULL, 0x080fe40003fa6070ULL, 0x0000003d2400720cULL, 0x000fe40003f66070ULL,
0x00000009083e7812ULL, 0x000fc400078efcffULL, 0x00000019083c7812ULL, 0x040fe400078efcffULL,
0x0000002008247812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x0000003d3e00720cULL, 0x080fe40003f86070ULL,
0x0000003d3c00720cULL, 0x080fe40003f46070ULL, 0x0000003d2400720cULL, 0x000fe40003f26070ULL,
0x00000021083c7812ULL, 0x040fe400078efcffULL, 0x0000002808247812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x0000003d3c00720cULL, 0x080fe40003f06070ULL, 0x0000003d2400720cULL, 0x000fe40003f86070ULL,
0x00000029083c7812ULL, 0x000fc400078efcffULL, 0x0000003008247812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x0000003d3c00720cULL, 0x000fc40003fc6070ULL, 0x0000003d2400720cULL, 0x000fe40003fa6070ULL,
0x00000031083c7812ULL, 0x040fe400078efcffULL, 0x0000003808247812ULL, 0x040fe400078efcffULL,
0x0000003908087812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x0000003d3c00720cULL, 0x080fe40003f66070ULL,
0x0000003d2400720cULL, 0x000fc40003f46070ULL, 0x0000003d0800720cULL, 0x000fe40003f26070ULL,
0xff7fffff26267808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff27277808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff28287808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff29297808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff2b2b7808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff3a3a7808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0x0000000b04097209ULL, 0x004fe20007810000ULL, 0x0000001fff3f7424ULL, 0x000fe200078e00ffULL,
0x0000001a05047209ULL, 0x000fe20007810000ULL, 0xffffffffff407424ULL, 0x000fe200078e00ffULL,
0x0000000a09097209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fc40007810000ULL,
0x0000000c09087209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000000d08097209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000000e09087209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fc40007810000ULL,
0x0000000f08097209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000001009087209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fc40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x0000002304057209ULL, 0x000fe40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x0000002605047209ULL, 0x000fe40007810000ULL,
0x0000001409087209ULL, 0x000fe40007810000ULL, 0x0000002704057209ULL, 0x000fc40007810000ULL,
0x0000001508097209ULL, 0x000fe40007810000ULL, 0x0000002805047209ULL, 0x000fe40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x0000002904057209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x0000002a05047209ULL, 0x000fc40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x0000002b04057209ULL, 0x000fe40007810000ULL,
0x00000019083d7209ULL, 0x000fe40007810000ULL, 0x0000003a053e7209ULL, 0x000fe20007810000ULL,
0x000017e27f007947ULL, 0x000fea000b800000ULL, 0x0c401f003d047f89ULL, 0x0004e400000e0000ULL,
0x000000043d3d7209ULL, 0x00cfe20007810000ULL, 0x000018127f007947ULL, 0x000fea000b800000ULL,
0x0c401f003e047f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006057f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007247f89ULL, 0x000f2200000e0000ULL, 0x000000043e087209ULL, 0x004fc60007810000ULL,
0x0c201f003d047f89ULL, 0x000ea200000e0000ULL, 0x0000000506097209ULL, 0x008fc60007810000ULL,
0x0c201f0008057f89ULL, 0x000ee200000e0000ULL, 0x0000002407247209ULL, 0x010fc60007810000ULL,
0x0c201f00093c7f89ULL, 0x002e6800000e0000ULL, 0x0c201f0024257f89ULL, 0x00092200000e0000ULL,
0x000000043d047209ULL, 0x004fe40007810000ULL, 0x0000000508057209ULL, 0x008fe40007810000ULL,
0x0000003c09067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fc40000000000ULL, 0x00000004ff3c7e24ULL, 0x002fe2000f8e00ffULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x3f8000003c3c783eULL, 0x000fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL,
0x000000ffff3d7224ULL, 0x000fe200078e003cULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010819ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b3a197823ULL, 0x000fe20000010819ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x000000080908723eULL, 0x002fce00000010ffULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x008fce00000010ffULL, 0x0000001d000b7308ULL, 0x0007f00000000800ULL,
0x0000001e001e7308ULL, 0x000f220000000800ULL, 0x0000001a1b09723eULL, 0x002fe200000010ffULL,
0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000b1e0b723eULL, 0x010fce00000010ffULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000003c0840723cULL, 0x000fee00000418ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ee20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000010ffULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x008fce00000010ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x0000001f200d723eULL, 0x002fce00000010ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x00000021220f723eULL, 0x008fce00000010ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x0000003c0c40723cULL, 0x000fee0000041840ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ee20000000800ULL,
0x000000121310723eULL, 0x002fce00000010ffULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x000000141512723eULL, 0x008fe400000010ffULL,
0xfffffffc32147812ULL, 0x000fc800078ec0ffULL, 0x000000141d1d7219ULL, 0x000fe200000006ffULL,
0x0000002700277308ULL, 0x000fe60000000800ULL, 0x000000001d1e73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f280000004000ULL, 0x0000002800287308ULL, 0x000ea20000000800ULL,
0x000000232611723eULL, 0x002fce00000010ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000272813723eULL, 0x004fce00000010ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000051dff7c12ULL, 0x008fe2000f80401eULL, 0x0000003c1040723cULL, 0x000fec0000041840ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000010ffULL, 0x0000002900297308ULL, 0x000ff00000000800ULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x000000180716723eULL, 0x004fe400000010ffULL,
0x0000002425077209ULL, 0x000fca0007810000ULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x00000019001a7308ULL, 0x000ea20000000800ULL, 0x000000292a15723eULL, 0x002fe400000010ffULL,
0x0000002b1a17723eULL, 0x004fce00000010ffULL, 0x0000003c1440723cULL, 0x000fe20000041840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000132204008947ULL, 0x010fde000b800000ULL,
0x001c1fff40187589ULL, 0x0002a400000e0000ULL, 0x000000001d1a73a1ULL, 0x000ee200000e8000ULL,
0x000000001d0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000051dff7c12ULL, 0x008fda000f80401aULL, 0x0000134204008947ULL, 0x010fea000b800000ULL,
0x001c1fff42197589ULL, 0x00072800000e0000ULL, 0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL,
0x001c1fff001b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011632ULL,
0x0000000c1c437812ULL, 0x000fc400078ec0ffULL, 0x000000071d1e7812ULL, 0x040fe200078ec0ffULL,
0x000000081d237824ULL, 0x040fe200078e00ffULL, 0x0000001dff217212ULL, 0x000fe200078e33ffULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0x0000000332ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081d3c7824ULL, 0x040fe200078e00ffULL, 0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823207812ULL, 0x100fe400078ee21eULL, 0x000000011f227812ULL, 0x100fe200078ef61eULL,
0x000000081d4c7824ULL, 0x000fe200078e00ffULL, 0x000000021f247812ULL, 0x100fe200078ef61eULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0x000000031f267812ULL, 0x000fc400078ef61eULL,
0x000000041f287812ULL, 0x140fe400078ef61eULL, 0x000000051f2a7812ULL, 0x140fe400078ef61eULL,
0x000000061f3a7812ULL, 0x000fe200078ef61eULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee221ULL, 0x0000001dff217212ULL, 0x000fe400078e33ffULL,
0x000000071d1e7812ULL, 0x000fc400078ec0ffULL, 0x00009000361d7811ULL, 0x000fe400078e58ffULL,
0xfffffff8233e7812ULL, 0x100fe400078ee21eULL, 0x000000011f407812ULL, 0x140fe200078ef61eULL,
0x00000010201c7824ULL, 0x000fe200078e021dULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee221ULL,
0x0000001024207824ULL, 0x100fe200078e021dULL, 0x000000021f427812ULL, 0x140fe200078ef61eULL,
0x0000001028247824ULL, 0x100fe200078e021dULL, 0x000000031f447812ULL, 0x140fe200078ef61eULL,
0x000000103a287824ULL, 0x100fe200078e021dULL, 0x000000041f467812ULL, 0x140fe200078ef61eULL,
0x00000010403a7824ULL, 0x100fe200078e021dULL, 0x000000051f487812ULL, 0x140fe200078ef61eULL,
0x00000010443d7824ULL, 0x100fe200078e021dULL, 0x000000061f4a7812ULL, 0x000fe200078ef61eULL,
0x00000010221e7824ULL, 0x000fc400078e021dULL, 0x0000001026227824ULL, 0x100fe400078e021dULL,
0x000000102a267824ULL, 0x100fe400078e021dULL, 0x00000001431f7824ULL, 0x000fe400078e021cULL,
0x000000103c2a7824ULL, 0x100fe400078e021dULL, 0x000000103e1c7824ULL, 0x100fe200078e021dULL,
0x000000081f007388ULL, 0x0003e20000000800ULL, 0x00000010423c7824ULL, 0x000fc400078e021dULL,
0x00000010463e7824ULL, 0x100fe400078e021dULL, 0x00000010483f7824ULL, 0x100fe400078e021dULL,
0x000000104a407824ULL, 0x100fe400078e021dULL, 0x000000104c417824ULL, 0x000fe400078e021dULL,
0x00000001431d7824ULL, 0x040fe400078e021eULL, 0x0000000143217824ULL, 0x000fc400078e0220ULL,
0x0000000143237824ULL, 0x040fe200078e0222ULL, 0x0000000a1d007388ULL, 0x0007e20000000800ULL,
0x0000000143257824ULL, 0x040fe400078e0224ULL, 0x0000000143277824ULL, 0x040fe200078e0226ULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x0000000143297824ULL, 0x040fe400078e0228ULL,
0x00000001432b7824ULL, 0x040fe200078e022aULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x00000001431c7824ULL, 0x000fc400078e021cULL, 0x00000001433a7824ULL, 0x040fe200078e023aULL,
0x0000001025007388ULL, 0x0007e20000000800ULL, 0x00000001433c7824ULL, 0x040fe400078e023cULL,
0x0000000143087824ULL, 0x042fe200078e023dULL, 0x0000001227007388ULL, 0x0007e20000000800ULL,
0x00000001433e7824ULL, 0x040fe400078e023eULL, 0x00000001431e7824ULL, 0x040fe200078e023fULL,
0x0000001429007388ULL, 0x0007e20000000800ULL, 0x0000000143407824ULL, 0x000fc400078e0240ULL,
0x0000000143207824ULL, 0x000fe200078e0241ULL, 0x000000162b007388ULL, 0x0007e80000000800ULL,
0x000000091c007388ULL, 0x0007e80000000800ULL, 0x0000000b3a007388ULL, 0x0007e80000000800ULL,
0x0000000d3c007388ULL, 0x0007e80000000800ULL, 0x0000000f08007388ULL, 0x0007e80000000800ULL,
0x000000113e007388ULL, 0x0007e80000000800ULL, 0x000000131e007388ULL, 0x0007e80000000800ULL,
0x0000001540007388ULL, 0x0007e80000000800ULL, 0x0000001720007388ULL, 0x0007e80000000800ULL,
0x00f0000400008388ULL, 0x0007e80000000c00ULL, 0x00f2001800008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000039ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080039ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100039ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030035357a10ULL, 0x000fe20007ffe0ffULL,
0x0000180039ff7f8cULL, 0x0003e6000c80043fULL, 0x000000023500720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffbdc000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff247807ULL, 0x008fe40004000000ULL,
0x0001428000287802ULL, 0x000fe40000000f00ULL, 0x00000f3000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0027ULL, 0xfffed82000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004000000ULL, 0x000142d000287802ULL, 0x000fe40000000f00ULL,
0x00000ee000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0027ULL,
0xfffed85000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6e7224ULL, 0x000fe200078e0028ULL,
0x0001434000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff707424ULL, 0x000fc400078e00ffULL, 0x00000e3000007944ULL, 0x03efea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e002aULL, 0xfffed8a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6e7224ULL, 0x000fe200078e0028ULL, 0x000143b000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff6f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x00000dc000007944ULL, 0x03cfea0003c00000ULL, 0x000000ffff287224ULL, 0x004fe200078e002aULL,
0xfffed86000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6e7224ULL, 0x000fe200078e0026ULL,
0x0001442000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x00000d5000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff617224ULL, 0x004fe200078e002aULL, 0xfffedbc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6e7224ULL, 0x002fe200078e0054ULL, 0x0001449000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff6f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fc400078e00ffULL,
0x00000ce000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e002aULL,
0xfffedb8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x010fe40004000000ULL,
0x000144e000287802ULL, 0x000fc40000000f00ULL, 0x00000cd000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0027ULL, 0xfffeff0000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004000000ULL, 0x0001453000287802ULL, 0x000fc40000000f00ULL,
0x00000c8000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0027ULL,
0xfffeff4000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x008fe200078e00ffULL,
0x0001459000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff707424ULL, 0x000fc400078e00ffULL,
0x00000be000007944ULL, 0x026fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002aULL,
0xfffeffb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6e7224ULL, 0x00afe200078e0054ULL,
0x0001460000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x00000b7000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002aULL, 0xffff006000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x0001466000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x00000b1000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff6b7224ULL, 0x004fe200078e002aULL, 0xffff032000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6e7224ULL, 0x002fe200078e0054ULL, 0x000146d000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff6f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x00000aa000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e002aULL,
0xffff02d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x004fe40004000000ULL,
0x0001472000287802ULL, 0x000fc40000000f00ULL, 0x00000a9000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0027ULL, 0xffff239000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004000000ULL, 0x0001477000287802ULL, 0x000fc40000000f00ULL,
0x00000a4000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0027ULL,
0xffff23d000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x002fe200078e00ffULL,
0x000147d000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff707424ULL, 0x000fc400078e00ffULL,
0x000009a000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002aULL,
0xffff244000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6e7224ULL, 0x002fe200078e0054ULL,
0x0001484000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000093000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002aULL, 0xffff24f000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x000148a000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x000008d000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff337224ULL, 0x004fe200078e002aULL, 0xffff27a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6e7224ULL, 0x002fe200078e0054ULL, 0x0001491000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff6f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0000086000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e002aULL,
0xffff275000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x002fe40004000000ULL,
0x0001496000287802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0027ULL, 0xffff47e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe40004000000ULL, 0x000149b000287802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0027ULL,
0xffff482000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x002fe200078e00ffULL,
0x00014a1000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff707424ULL, 0x000fc400078e00ffULL,
0x0000076000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002aULL,
0xffff489000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6e7224ULL, 0x002fe200078e0054ULL,
0x00014a8000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x000006f000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002aULL, 0xffff494000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x000fe200078e00ffULL, 0x00014ae000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000069000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff297224ULL, 0x004fe200078e002aULL, 0xffff4c0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6e7224ULL, 0x002fe200078e0054ULL, 0x00014b5000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff6f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0000062000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff547224ULL, 0x004fe200078e002aULL,
0xffff4bb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff257224ULL, 0x000fe200078e003dULL,
0x00014bb000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3c7424ULL, 0x000fc400078e00ffULL,
0x0000058000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0025ULL,
0xffffe7d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff257224ULL, 0x000fe200078e003eULL,
0x00014c1000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3c7424ULL, 0x002fc400078e00ffULL,
0x0000052000007944ULL, 0x020fea0003c00000ULL, 0x000000253e3e7209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0006ULL, 0x00014c6000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff3c7424ULL, 0x002fc400078e00ffULL, 0x000004d000007944ULL, 0x000fea0003c00000ULL,
0x0000002506067209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0007ULL,
0x00014cb000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3c7424ULL, 0x002fc400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x0000002507247209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e003dULL, 0x00014d0000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff3c7424ULL, 0x002fc400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x000000253d047209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e003eULL,
0x00014d5000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff3c7424ULL, 0x002fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x000000253e057209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0006ULL, 0x00014da000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff3c7424ULL, 0x002fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000002506067209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0024ULL,
0x00014df000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff3c7424ULL, 0x002fc400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0xffffe69000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x000fe200078e0040ULL, 0x00014e6000247802ULL, 0x000fe20000000f00ULL,
0x000000ffff6e7224ULL, 0x000fc400078e00ffULL, 0x00001c1fff6f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff707224ULL, 0x000fe400078e001dULL, 0x0000031000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e002aULL, 0xffffec7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e0042ULL, 0x00014ee000247802ULL, 0x000fe20000000f00ULL,
0x000000ffff6e7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff6f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff707224ULL, 0x000fe400078e001dULL, 0x0000029000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff6e7224ULL, 0x002fe200078e00ffULL, 0x00014f4000247802ULL, 0x000fe20000000f00ULL,
0x00001c1fff6f7424ULL, 0x000fc400078e00ffULL, 0x000000ffff707224ULL, 0x000fe400078e001dULL,
0x000000ffff197224ULL, 0x004fe400078e002aULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff707224ULL, 0x002fe200078e001dULL, 0x00014fa000247802ULL, 0x000fe20000000f00ULL,
0x000000ffff6e7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff6f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1a7224ULL, 0x004fe400078e002aULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e002aULL, 0xffffebb000007947ULL, 0x000fea000383ffffULL,
0x0180000038037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000003800038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000304ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff38ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000304ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000038047812ULL, 0x000fd600078ec0ffULL,
0x0080000004030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0004ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003800037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffeaed006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000004000007348ULL, 0x000fe80003800000ULL, 0x0c00003c25257389ULL, 0x0002a200000e003fULL,
0xfffeae9008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff257424ULL, 0x000fe200078e00ffULL,
0x0000007000007348ULL, 0x000fe80003800000ULL, 0x0000006e2b2a7389ULL, 0x0002a200000e006fULL,
0xfffeae5024007950ULL, 0x000fea0003c3ffffULL, 0x000000012400780cULL, 0x000fe20003f05070ULL,
0x0000005300007348ULL, 0x000fe80003800000ULL, 0x00000000ff257424ULL, 0x000fd000078e00ffULL,
0x0000000000247806ULL, 0x000fc800040e0100ULL, 0x0000005324277212ULL, 0x000fe200078ec0ffULL,
0x000000ffff247224ULL, 0x000fc800078e0028ULL, 0xfffeade024007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000358ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000938ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x0000000000000880ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001248ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001268ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001278ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001298ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001328ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001330ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001340ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001500ULL, 0x0000000000015300ULL, 0xaf00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016800ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000016810ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016810ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000016c90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001328ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000154d8ULL, 0x00000000000154d8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016800ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000016c90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin_len = 93552;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
