/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000015510ULL, 0x0000000000015090ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000013c30ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x0000000000013da0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000013de0ULL, 0x0000000000000120ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000013f00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00013c3000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x004e640400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080ae0828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080ae92ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x00013c3000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080ae0828808081ULL, 0x8016288080b00828ULL, 0x0000000310288082ULL, 0x80b0920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL, 0x00013da000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080ae0828808081ULL,
0x8016288080b00828ULL, 0x0000000310288082ULL, 0x80b0920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x0000015800000000ULL, 0x00013de000000000ULL, 0x0000012000000000ULL,
0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000aaULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL,
0x0000007c00043704ULL, 0x0000000d00080a04ULL, 0x0058190300580160ULL, 0x00000000000c1704ULL,
0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL,
0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL,
0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0018310400ff1b03ULL,
0x00012fc000012c70ULL, 0x0001309000012fe0ULL, 0x000130b0000130a0ULL, 0xffffffff00e82904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x05000027ffffffffULL,
0x0500002705000027ULL, 0xffffffff05000027ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x00e82804ffffffffULL, 0x000000f0000000c0ULL, 0x00001a0000001970ULL, 0x00001ac000001a90ULL,
0x00002ae000002aa0ULL, 0x00004140000040a0ULL, 0x000041e0000041b0ULL, 0x000050b000005080ULL,
0x000065d000006530ULL, 0x0000667000006640ULL, 0x0000745000007410ULL, 0x00008a0000008970ULL,
0x00008ab000008a70ULL, 0x00009770000090c0ULL, 0x0000a7f00000a7e0ULL, 0x0000d2d00000d2b0ULL,
0x0000d7e00000d7a0ULL, 0x00012910000128e0ULL, 0x0001293000012920ULL, 0x0001297000012950ULL,
0x000129a000012990ULL, 0x000130e000013080ULL, 0x00013100000130f0ULL, 0x000137a000013730ULL,
0x0001386000013800ULL, 0x00013900000138b0ULL, 0x000139a000013950ULL, 0x00013a40000139f0ULL,
0x00013b4000013ac0ULL, 0x00013c0000013ba0ULL, 0x0000017003e03904ULL, 0x0000f600000000ffULL,
0x000001b0003f0100ULL, 0x0000f60800000003ULL, 0x000001e0003f0130ULL, 0x0000f61000000003ULL,
0x00000210003f0130ULL, 0x0000f64800000003ULL, 0x00000240003f0120ULL, 0x0000f66800000003ULL,
0x00000460003f0120ULL, 0x0000f600000000ffULL, 0x00000660003f0107ULL, 0x0000f61400000013ULL,
0x00000790003f0102ULL, 0x0000f61000000013ULL, 0x00000d80003f0101ULL, 0x00000000000000ffULL,
0x00000e0000040107ULL, 0x0000002000000006ULL, 0x00000f80003f0101ULL, 0x0000002400000006ULL,
0x00001030003f0106ULL, 0x0000002400000006ULL, 0x000010c0003f0106ULL, 0x0000002400000006ULL,
0x00001700003f0106ULL, 0x000000000000006bULL, 0x0000177000040107ULL, 0x0000000400000049ULL,
0x0000179000040106ULL, 0x0000f60c00000002ULL, 0x000018a0003f0106ULL, 0x000000040000001cULL,
0x00001d30003f0106ULL, 0x0000000400000049ULL, 0x00001dd000040106ULL, 0x0000000400000049ULL,
0x0000374000040106ULL, 0x0000002000000006ULL, 0x000037c0003f0101ULL, 0x000000000000001cULL,
0x00003870003f0101ULL, 0x0000002400000006ULL, 0x000038c0003f0106ULL, 0x0000002400000006ULL,
0x00003950003f0106ULL, 0x0000002400000006ULL, 0x00003e40003f0106ULL, 0x00000000000000ffULL,
0x00003eb000060107ULL, 0x0000000400000061ULL, 0x00003ed0003f0106ULL, 0x0000f61c00000002ULL,
0x00003fe0003f0106ULL, 0x0000f61c00000002ULL, 0x000044a0003f0106ULL, 0x0000f64c0000001eULL,
0x00004530003f0106ULL, 0x0000f64c0000001eULL, 0x00005d00003f0106ULL, 0x0000002000000006ULL,
0x00005d80003f0101ULL, 0x000000000000001cULL, 0x00005e20003f0101ULL, 0x0000002400000006ULL,
0x00005e80003f0106ULL, 0x0000002400000006ULL, 0x00005f10003f0106ULL, 0x0000002400000006ULL,
0x000062d0003f0106ULL, 0x000000000000006bULL, 0x0000634000040107ULL, 0x00000004000000ffULL,
0x0000636000060106ULL, 0x0000f62c00000002ULL, 0x00006470003f0106ULL, 0x0000f62c00000002ULL,
0x00006910003f0106ULL, 0x0000f64c0000001cULL, 0x000069a0003f0106ULL, 0x00000004000000ffULL,
0x0000814000060106ULL, 0x0000002000000006ULL, 0x000081c0003f0101ULL, 0x000000000000001cULL,
0x00008250003f0101ULL, 0x0000002400000006ULL, 0x000082a0003f0106ULL, 0x0000002400000006ULL,
0x00008330003f0106ULL, 0x0000002400000006ULL, 0x00008740003f0106ULL, 0x00000000000000ffULL,
0x000087b000060107ULL, 0x0000000400000061ULL, 0x000087d0003f0106ULL, 0x0000f63c00000002ULL,
0x000088b0003f0106ULL, 0x0000f63c00000002ULL, 0x00008d70003f0106ULL, 0x0000f64c00000062ULL,
0x00008e00003f0106ULL, 0x0000f64c00000062ULL, 0x0000a500003f0106ULL, 0x0000002000000006ULL,
0x0000a560003f0101ULL, 0x0000f64000000002ULL, 0x0000f350003f0101ULL, 0x0000f604000000ffULL,
0x0000f3e0003f0106ULL, 0x0000f604000000ffULL, 0x0000f600003f0106ULL, 0x0000f600000000ffULL,
0x0000f610003f0101ULL, 0x0000f604000000ffULL, 0x0000f690003f0106ULL, 0x0000f604000000ffULL,
0x00011de0003f0106ULL, 0x0000f61400000038ULL, 0x000121c0003f0106ULL, 0x0000f61400000038ULL,
0x00013680003f0106ULL, 0x0000f60800000038ULL, 0x00053803003f0101ULL, 0x0000e1e000141c04ULL,
0x0000f6e00000e630ULL, 0x000136e00000f7b0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000001bcULL, 0x0000001100000002ULL, 0x0000000000000144ULL, 0x0000001100000002ULL,
0x00000000000000ccULL, 0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL,
0x0000000000000195ULL, 0x0000001100000002ULL, 0x000000000000011dULL, 0x0000001100000002ULL,
0x00000000000000a8ULL, 0x0000001100000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000087919ULL, 0x000e620000002300ULL,
0x00000004ff1d7424ULL, 0x000fe200078e00ffULL, 0x0000460000087ab9ULL, 0x000fe20000000a00ULL,
0x00005800ff1b7624ULL, 0x000fe200078e00ffULL, 0x0000000000037919ULL, 0x000e680000002200ULL,
0x0000000000097919ULL, 0x000ea80000002100ULL, 0x0000000000027919ULL, 0x000ee80000002700ULL,
0x0000000000347919ULL, 0x000f220000002600ULL, 0x0000000108007824ULL, 0x002fc800078e0203ULL,
0x0000008000037824ULL, 0x104fe200078e0209ULL, 0x00000005ff187819ULL, 0x000fe20000011609ULL,
0x00001fff08007589ULL, 0x00066600000e0000ULL, 0x000000ff0300720cULL, 0x040fe40003f05270ULL,
0x000000030300780cULL, 0x040fe20003f44070ULL, 0x00001fff18187589ULL, 0x000ea200000e0000ULL,
0x0000007f0300780cULL, 0x040fe20003f24070ULL, 0x0000620002087625ULL, 0x008fe200078e001dULL,
0x000000010300780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff048424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff058424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff06a424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff07a424ULL, 0x000fe200078e00ffULL, 0x00f60004ff008388ULL, 0x0007e20000000a00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x3fffff80ff0ca424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0da424ULL, 0x000fe200078e00ffULL, 0x00f608060300a388ULL, 0x0007e2000000ca00ULL,
0x3fffffc0ff0aa424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL,
0x00f6100c0300a388ULL, 0x0007e2000000ca00ULL, 0xff317217ff109424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0eb424ULL, 0x000fe200078e00ffULL, 0x00f6480a0300a388ULL, 0x0007e20000008a00ULL,
0x7fffffc0ff0fb424ULL, 0x000fc600078e00ffULL, 0x00f4001003009388ULL, 0x0007e80000004800ULL,
0x00f6680e0300b388ULL, 0x0007e80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x01ce620000000000ULL,
0x0000000418057824ULL, 0x000fc400078e00ffULL, 0x000000101b037824ULL, 0x000fe400078e00ffULL,
0x0000001034047824ULL, 0x000fe400078e00ffULL, 0x00000100ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000000203037224ULL, 0x000fe200078e0204ULL, 0x000000050e0a7211ULL, 0x042fe200078fe0ffULL,
0x000000100e057824ULL, 0x000fc600078e00ffULL, 0x000000020a0c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000103047824ULL, 0x040fe200078e020aULL, 0x000000070a067812ULL, 0x000fe400078ec0ffULL,
0x000000070c0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000103077824ULL, 0x000fe200078e020cULL,
0x000000f0050d7812ULL, 0x000fe200078ec0ffULL, 0x00005c0004047625ULL, 0x080fe200078e000fULL,
0x0000000f06037812ULL, 0x100fe400078e780eULL, 0x0000000f0b0b7812ULL, 0x000fe200078e780eULL,
0x00005c0007067625ULL, 0x000fe200078e000fULL, 0x0000000d04047210ULL, 0x000fc60007f1e0ffULL,
0x000000100a037824ULL, 0x000fe200078e0203ULL, 0x0000000d06067210ULL, 0x000fe20007f3e0ffULL,
0x000000100c0b7824ULL, 0x000fe400078e020bULL, 0x000000ffff057224ULL, 0x000fe400000e0605ULL,
0x0000001003037824ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400008e0607ULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e8000b901c48ULL, 0x00000000060b7faeULL, 0x0003e8000b901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000808167981ULL, 0x014ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000004ff1a7e24ULL, 0x010fe2000f8e00ffULL, 0x0000003f16177810ULL, 0x004fc40007ffe0ffULL,
0x000000ff16157810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff177819ULL, 0x000fe40000011617ULL,
0x00000008ff157819ULL, 0x000fca0000011615ULL, 0x0000e0e000008947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x000fe20000011618ULL, 0x0000001018137824ULL, 0x000fe400078e00ffULL,
0x00000003ff067424ULL, 0x00afe200078e00ffULL, 0x03ffffff14037812ULL, 0x000fca00078ec0ffULL,
0x000000041a087824ULL, 0x000fca00078e0203ULL, 0x000000170800720cULL, 0x000fda0003f06070ULL,
0x0000000202008824ULL, 0x000fe400078e00ffULL, 0x00006400ff038624ULL, 0x000fc800078e00ffULL,
0x0000640000038624ULL, 0x000fe400078e0203ULL, 0xffffffffff007424ULL, 0x000fe400078e00ffULL,
0x0000000108038824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6140613ff738cULL, 0x0003e20000000000ULL, 0x0000600003048625ULL, 0x000fe200078e001dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000804008981ULL, 0x0004e2000c1e1900ULL,
0x00000300ff067624ULL, 0x002fe200078e00ffULL, 0x0000000308037812ULL, 0x000fe200078ec0ffULL,
0xffffffffff107424ULL, 0x000fe200078e00ffULL, 0x00000000000f7919ULL, 0x000e620000000000ULL,
0xfffffffd1d117424ULL, 0x000fe200078e0206ULL, 0x000000030300780cULL, 0x000fc40003f05270ULL,
0x00000001180e7812ULL, 0x000fe400078ec0ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011618ULL,
0x00000040340a7824ULL, 0x000fe200078e00ffULL, 0x0000000111127807ULL, 0x000fe20004000000ULL,
0x000000401b097824ULL, 0x000fe200078e00ffULL, 0x00f6100013ff7f8cULL, 0x0009e6000c80043fULL,
0x0000000108127824ULL, 0x000fca00078e0212ULL, 0x000000171200720cULL, 0x000fe20003f06070ULL,
0x000000100e077824ULL, 0x000fe200078e00ffULL, 0x00000003ff197819ULL, 0x002fd6000001160fULL,
0x0000000202038824ULL, 0x000fe400078e00ffULL, 0x00006400ff068624ULL, 0x000fc800078e00ffULL,
0x0000640003038624ULL, 0x000fe400078e0206ULL, 0x00000001071c7824ULL, 0x000fe400078e0219ULL,
0x0000000103048824ULL, 0x004fe400078e0212ULL, 0x000000081c087824ULL, 0x000fe400078e00ffULL,
0x0000600004048625ULL, 0x000fe200078e001dULL, 0x0000000f1c037212ULL, 0x000fc600078e3cffULL,
0x000000200d0c7824ULL, 0x000fe200078e00ffULL, 0x0000000804108981ULL, 0x000362000c1e1900ULL,
0x00000004191d7810ULL, 0x000fe20007ffe0ffULL, 0x000020000d0b7824ULL, 0x000fe200078e00ffULL,
0x000000011a067810ULL, 0x000fe20007ffe0ffULL, 0x000000000d0473c2ULL, 0x000ea200000e0000ULL,
0x0000000819207810ULL, 0x000fe20007ffe0ffULL, 0x00000001071e7824ULL, 0x000fe200078e021dULL,
0x000000150600720cULL, 0x000fe20003f06070ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000c19247810ULL, 0x000fe20007ffe0ffULL, 0x000000081e1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff808057812ULL, 0x002fe200078ee203ULL, 0x000001001a037824ULL, 0x000fe200078e020cULL,
0x0000000f1e067212ULL, 0x000fe200078e3cffULL, 0x0000000107227824ULL, 0x040fe200078e0220ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000107267824ULL, 0x000fe200078e0224ULL,
0x0000000316047217ULL, 0x000fe20007800000ULL, 0x0000000822217824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL, 0x0000000826257824ULL, 0x000fe200078e00ffULL,
0x0000000f22067212ULL, 0x080fe200078e3cffULL, 0x0000000104047824ULL, 0x100fe200078e0a03ULL,
0x000000200a037812ULL, 0x000fe200078ef803ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0xfffffff821217812ULL, 0x000fe200078ee206ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000002004047807ULL, 0x000fe20000000000ULL, 0x0000f64804047891ULL, 0x004fe2000f8e203fULL,
0x0000b0000b067810ULL, 0x000fe20007ffe0ffULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000f26087212ULL, 0x000fe200078e3cffULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x0000000704047217ULL, 0x000fe20007800000ULL, 0x00000010051b7824ULL, 0x000fe200078e0206ULL,
0xfffffff825257812ULL, 0x000fe200078ee208ULL, 0x000000101f237824ULL, 0x100fe200078e0206ULL,
0x0000003f1e057812ULL, 0x000fe200078ec0ffULL, 0x0000000104087824ULL, 0x000fe200078e0a07ULL,
0x0000003f22077812ULL, 0x000fe200078ec0ffULL, 0x0000001021297824ULL, 0x000fc400078e0206ULL,
0x00000080ff1f7424ULL, 0x000fe200078e00ffULL, 0x000000081900720cULL, 0x080fe20003f46070ULL,
0x000000100f217824ULL, 0x000fe200078e00ffULL, 0x0000003f26197812ULL, 0x000fe200078ec0ffULL,
0x00000010252b7824ULL, 0x000fe200078e0206ULL, 0x000000081d00720cULL, 0x080fe20003f26070ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000007021217812ULL, 0x000fe400078ec0ffULL,
0x000000082000720cULL, 0x000fe20003f06070ULL, 0x0000000009007224ULL, 0x008fe200078e0203ULL,
0x0000003f1c037812ULL, 0x000fc600078ec0ffULL, 0x0000000100067824ULL, 0x040fe400078e0205ULL,
0x0000000100037824ULL, 0x040fe400078e0203ULL, 0x00000001001c7824ULL, 0x000fe400078e0207ULL,
0x00005e0003047625ULL, 0x000fc800078e001fULL, 0x0000000100197824ULL, 0x000fe200078e0219ULL,
0x0000002104047210ULL, 0x000fe20007f7e0ffULL, 0x00005e0006067625ULL, 0x000fc800078e001fULL,
0x00005e001c1c7625ULL, 0x000fe200078e001fULL, 0x0000002106207210ULL, 0x000fe40007f9e0ffULL,
0x0000f6480d067811ULL, 0x000fe200078e18ffULL, 0x00005e00191e7625ULL, 0x000fe200078e001fULL,
0x000000211c1c7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff057224ULL, 0x000fe200018e0605ULL,
0x000000082400720cULL, 0x000fe20003f66070ULL, 0x000000ffff1d7224ULL, 0x000fe200028e061dULL,
0x000000211e1e7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200020e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000041b7faeULL, 0x0009e2000d101c48ULL,
0xff317217ff087424ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1f7224ULL, 0x000fe200030e061fULL, 0x0000000020237faeULL, 0x0009e2000c901c48ULL,
0x000000ffff077224ULL, 0x000fc600078e00ffULL, 0x000000001c297faeULL, 0x0009e2000c101c48ULL,
0x000000151a00720cULL, 0x000fc60003f06070ULL, 0x000000001e2b7faeULL, 0x0009e8000d901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200006ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x010fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000978000000947ULL, 0x000fea0003800000ULL, 0x0000000202057824ULL, 0x002fe200078e00ffULL,
0x00007610ff6f7816ULL, 0x000fe2000000006fULL, 0x00006400ff007624ULL, 0x000fe200078e00ffULL,
0x00007610ff717816ULL, 0x000fe20000000071ULL, 0xff317217ff087424ULL, 0x000fe200078e00ffULL,
0x00007610ff047816ULL, 0x000fe20000000004ULL, 0x000000ffff707224ULL, 0x000fc400078e00ffULL,
0x0000640005057624ULL, 0x000fe400078e0200ULL, 0x000000ffff277224ULL, 0x000fe400078e00ffULL,
0xffffffc013037812ULL, 0x000fca00078ec0ffULL, 0x000001001a037824ULL, 0x000fca00078e0203ULL,
0x000000160300720cULL, 0x000fda0003f06070ULL, 0x0000965000000947ULL, 0x002fea0003800000ULL,
0x0000240006037984ULL, 0x000e620000000800ULL, 0x0000ffff6f027812ULL, 0x000fe200078ec0ffULL,
0x000000ffff6d7224ULL, 0x000fc600078e0012ULL, 0x0000888002197816ULL, 0x000fca00000000ffULL,
0x8000000019027824ULL, 0x000fca00078e00ffULL, 0x8000000003ff7812ULL, 0x002fe20007804802ULL,
0x000000ffff037224ULL, 0x000fe200078e0070ULL, 0x0000000000007918ULL, 0x000ff00000000000ULL,
0x00007610716c7816ULL, 0x000fe4000000006cULL, 0x000076106f557816ULL, 0x000fe20000000055ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00002400060d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804802ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x80000000191c7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff027424ULL, 0x000fc800078e00ffULL, 0x00000002000d7305ULL, 0x0002a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x0000000d0000735dULL, 0x004fe40003800000ULL,
0x00002400060d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc4000780481cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000312027812ULL, 0x000fe200078ec0ffULL, 0x000001001a687824ULL, 0x000fc600078e00ffULL,
0x000000030200780cULL, 0x000fc80003f05270ULL, 0x00000001110d7807ULL, 0x000fca0004000000ULL,
0x0000000112127824ULL, 0x000fe200078e020dULL, 0x00000001ff0d7819ULL, 0x000fc80000011618ULL,
0x000000171200720cULL, 0x000fe20003f06070ULL, 0x000000200d027824ULL, 0x000fca00078e0268ULL,
0x0000004002197810ULL, 0x000fc80007ffe0ffULL, 0x000000200a027812ULL, 0x000fc600078ef819ULL,
0x00000001051c8824ULL, 0x000fe400078e0212ULL, 0x00000004ff1d8424ULL, 0x000fe400078e00ffULL,
0x0000000910217224ULL, 0x020fe200078e0202ULL, 0x00000003ff1f7819ULL, 0x000fe2000001160fULL,
0xffffffffff107424ULL, 0x000fe200078e00ffULL, 0x00000010131b7812ULL, 0x000fe200078ec0ffULL,
0x000060001c1c8625ULL, 0x000fe200078e001dULL, 0x000000011a027810ULL, 0x000fc60007ffe0ffULL,
0x000000011f547824ULL, 0x000fe200078e021bULL, 0x000000081c108981ULL, 0x000362000c1e1900ULL,
0x000000150200720cULL, 0x000fe20003f06070ULL, 0x00000008181e7824ULL, 0x000fe200078e00ffULL,
0x0000001916027217ULL, 0x000fe20007800000ULL, 0x00000080ff237424ULL, 0x000fe200078e00ffULL,
0x0000000f54537212ULL, 0x000fe200078e3cffULL, 0x000000100f487824ULL, 0x000fe200078e00ffULL,
0x000000041f447810ULL, 0x040fe20007ffe0ffULL, 0x0000000102027824ULL, 0x000fe200078e0a19ULL,
0x000000081f4a7810ULL, 0x000fe20007ffe0ffULL, 0x00000008541c7824ULL, 0x042fe200078e00ffULL,
0x0000003f54547812ULL, 0x000fe200078ec0ffULL, 0x0000000144527824ULL, 0x000fe200078e021bULL,
0xfffffff01e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000870497824ULL, 0x000fe200078e00ffULL,
0xfffffff81c537812ULL, 0x000fe200078ee253ULL, 0x00000001211c7824ULL, 0x000fe200078e0254ULL,
0x0000002002027807ULL, 0x000fe20000000000ULL, 0x000000014a507824ULL, 0x000fe200078e021bULL,
0x0000000c1f4c7810ULL, 0x000fe20007ffe0ffULL, 0x00005e001c1c7625ULL, 0x000fe200078e0023ULL,
0x000000001e0473c2ULL, 0x0002a200000e0000ULL, 0x00000070484b7812ULL, 0x000fc400078ec0ffULL,
0x0000001b02027217ULL, 0x000fe20007800000ULL, 0x0000000852207824ULL, 0x040fe200078e00ffULL,
0x0000000f52517212ULL, 0x080fe200078e3cffULL, 0x000000014c467824ULL, 0x100fe200078e021bULL,
0x00000008496b7812ULL, 0x000fe200078e0cffULL, 0x00000008501e7824ULL, 0x042fe200078e00ffULL,
0x0000000f50477212ULL, 0x000fe200078e3cffULL, 0x0000000102027824ULL, 0x000fe200078e0a1bULL,
0x0000003f52527812ULL, 0x000fe200078ec0ffULL, 0x000000006b0573c2ULL, 0x000e6200000e0000ULL,
0x0000004b1c1c7210ULL, 0x000fe20007f1e0ffULL, 0x0000100070197824ULL, 0x000fe200078e00ffULL,
0xfffffff820517812ULL, 0x000fe200078ee251ULL, 0x0000000846207824ULL, 0x000fe200078e00ffULL,
0xfffffff81e477812ULL, 0x000fe200078ee247ULL, 0x00000001211e7824ULL, 0x000fe200078e0252ULL,
0x0000000f46457212ULL, 0x000fe200078e3cffULL, 0x000000ffff1d7224ULL, 0x000fe200000e061dULL,
0x000000021f00720cULL, 0x000fe20003f06070ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0023ULL,
0x0000003f50507812ULL, 0x000fe200078ec0ffULL, 0x0000f64804047890ULL, 0x004fe2000fffe03fULL,
0xfffffff820457812ULL, 0x000fc400078ee245ULL, 0x0000003f46467812ULL, 0x000fe200078ec0ffULL,
0x00000001211b7824ULL, 0x000fe200078e0250ULL, 0x0000100019207812ULL, 0x000fe400078e0cffULL,
0x0000004b1e1e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000121227824ULL, 0x000fe200078e0246ULL,
0x000000024400720cULL, 0x080fe20003f26070ULL, 0x000020000d197824ULL, 0x000fe200078e0220ULL,
0x000000024c00720cULL, 0x000fe20003f66070ULL, 0x00005e001b207625ULL, 0x000fe200078e0023ULL,
0x0000000504057290ULL, 0x002fc4000fffe03fULL, 0x0000b00019447810ULL, 0x000fe20007ffe0ffULL,
0x00005e0022227625ULL, 0x000fe200078e0023ULL, 0x0000004b20207210ULL, 0x000fc60007f9e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e061fULL, 0x000000024a00720cULL, 0x000fe20003f46070ULL,
0x0000001053667824ULL, 0x100fe200078e0244ULL, 0x0000004b22227210ULL, 0x000fe20007fbe0ffULL,
0x0000001051657824ULL, 0x100fe400078e0244ULL, 0x000000ffff217224ULL, 0x000fe200020e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c667faeULL, 0x0003e2000c101c48ULL,
0x0000001047647824ULL, 0x100fe400078e0244ULL, 0x000000ffff237224ULL, 0x000fe200028e0623ULL,
0x000000001e657faeULL, 0x0003e2000c901c48ULL, 0x0000001045637824ULL, 0x000fc400078e0244ULL,
0x0000000418027824ULL, 0x000fe200078e00ffULL, 0x0000000020647faeULL, 0x0003e8000d101c48ULL,
0x0000000022637faeULL, 0x0003e2000d901c48ULL, 0xfffffff002027812ULL, 0x000fc600078ec0ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000404491c7984ULL, 0x0022a20008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f60c00021e7984ULL, 0x000ee20000000800ULL,
0x0000ffff71197812ULL, 0x000fe400078ec0ffULL, 0x0000ffff041b7812ULL, 0x000fe400078ec0ffULL,
0x0000888019227816ULL, 0x000fc400000000ffULL, 0x000088801b1b7816ULL, 0x000fc600000000ffULL,
0x8000000022197824ULL, 0x000fe400078e00ffULL, 0x800000001b1d7824ULL, 0x000fc600078e00ffULL,
0x800000001cff7812ULL, 0x004fe40007804819ULL, 0x800000001eff7812ULL, 0x008fe2000782481dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000f608141c7811ULL, 0x000fe200078e20ffULL, 0x3e000000ff197424ULL, 0x000fe400078e00ffULL,
0x800000001b1e7824ULL, 0x000fe400078e00ffULL, 0x00000019001d7305ULL, 0x0004e4000021f000ULL,
0x3fa0000019197823ULL, 0x004fe200000100ffULL, 0x0000001d0000735dULL, 0x008fe40003800000ULL,
0x000004001c1d7984ULL, 0x000ea40000000800ULL, 0x800000001dff7812ULL, 0x004fc4000782481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000001ff447819ULL, 0x000fe4000001160fULL, 0x0000007048197812ULL, 0x000fe200078ec0ffULL,
0x00000001ff487424ULL, 0x000fe200078e00ffULL, 0x0000000c44447812ULL, 0x000fc600078ec0ffULL,
0x00000080141d7824ULL, 0x000fc800078e0219ULL, 0x000000011d1d7824ULL, 0x000fca00078e0244ULL,
0x00f000001d1f7984ULL, 0x000ea80000000800ULL, 0x00f200001d1c7984ULL, 0x0007220000000800ULL,
0x000000081f00720bULL, 0x004fda0003f3d000ULL, 0x00000000001e7806ULL, 0x000fc800008e0100ULL,
0x0000ffff1e237812ULL, 0x000fda000782c0ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000081f00720bULL, 0x018fe40003f34000ULL, 0x0000001f084a7209ULL, 0x000fe40007810000ULL,
0x00000002ff207819ULL, 0x000fc6000001160fULL, 0x8000004a081d7221ULL, 0x000fe20000010000ULL,
0x0000000820217810ULL, 0x000fc60007ffe0ffULL, 0x3fb8aa3b1d1e7820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fe400008e0100ULL, 0x000000181400720cULL, 0x000fe40003f25270ULL,
0x0000ffff08087812ULL, 0x000fe200078e3cffULL, 0x0000001e001e7308ULL, 0x000ea60000000800ULL,
0x0000000823ff7212ULL, 0x000fe2000784c0ffULL, 0x000000ffff087224ULL, 0x000fc600078e004aULL,
0x00000001ff487807ULL, 0x000fc60001000000ULL, 0x00000080181d9824ULL, 0x000fc800078e0219ULL,
0x00000001441d9824ULL, 0x000fe200078e021dULL, 0x00001f211e217589ULL, 0x004ea200000e0000ULL,
0x8000004a1f1f2221ULL, 0x000fe20000010000ULL, 0x0000001e07077220ULL, 0x000fe40000410000ULL,
0x00001f201e207589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b1f1f2820ULL, 0x000fc60000410000ULL,
0x00f4004a1d009388ULL, 0x0009e20000000800ULL, 0x0000001f00002308ULL, 0x000e620000000800ULL,
0x0000002127277220ULL, 0x084fe20000410000ULL, 0x0000002126267220ULL, 0x080fe20000410000ULL,
0x0000002143437220ULL, 0x080fe20000410000ULL, 0x0000002142427220ULL, 0x080fe20000410000ULL,
0x000000213f3f7220ULL, 0x080fe20000410000ULL, 0x000000213e3e7220ULL, 0x080fe20000410000ULL,
0x000000213b3b7220ULL, 0x080fe20000410000ULL, 0x000000213a3a7220ULL, 0x080fe20000410000ULL,
0x0000002137377220ULL, 0x080fe20000410000ULL, 0x0000002136367220ULL, 0x080fe20000410000ULL,
0x0000002133337220ULL, 0x080fe20000410000ULL, 0x0000002132327220ULL, 0x080fe20000410000ULL,
0x000000212f2f7220ULL, 0x080fe20000410000ULL, 0x000000212e2e7220ULL, 0x080fe20000410000ULL,
0x000000212b2b7220ULL, 0x080fe20000410000ULL, 0x000000212a2a7220ULL, 0x000fe20000410000ULL,
0x0000002025257220ULL, 0x088fe20000410000ULL, 0x0000002024247220ULL, 0x080fe20000410000ULL,
0x0000002041417220ULL, 0x080fe20000410000ULL, 0x0000002040407220ULL, 0x080fe20000410000ULL,
0x000000203d3d7220ULL, 0x080fe20000410000ULL, 0x000000203c3c7220ULL, 0x080fe20000410000ULL,
0x0000002039397220ULL, 0x080fe20000410000ULL, 0x0000002038387220ULL, 0x080fe20000410000ULL,
0x0000002035357220ULL, 0x080fe20000410000ULL, 0x0000002034347220ULL, 0x080fe20000410000ULL,
0x0000002031317220ULL, 0x080fe20000410000ULL, 0x0000002030307220ULL, 0x080fe20000410000ULL,
0x000000202d2d7220ULL, 0x080fe20000410000ULL, 0x000000202c2c7220ULL, 0x080fe20000410000ULL,
0x0000002029297220ULL, 0x080fe20000410000ULL, 0x0000002028287220ULL, 0x000fe20000410000ULL,
0x000000001c1c2220ULL, 0x002fc80000410000ULL, 0x000000071c077221ULL, 0x018fe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000404491c7984ULL, 0x000ea20008000800ULL,
0x80000000221d7824ULL, 0x000fca00078e00ffULL, 0x800000001cff7812ULL, 0x004fe2000780481dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000022227824ULL, 0x000fe400078e00ffULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c001d7305ULL, 0x0004e4000021f000ULL, 0x3fa000001c1c7823ULL, 0x004fe200000100ffULL,
0x0000001d0000735dULL, 0x008fe40003800000ULL, 0x00000404491d7984ULL, 0x000ea40008000800ULL,
0x800000001dff7812ULL, 0x004fc40007804822ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000004181e7824ULL, 0x040fe200078e00ffULL,
0x000000080f1c7812ULL, 0x000fe200078ec0ffULL, 0x00001000181d7824ULL, 0x000fe200078e00ffULL,
0x0000991048567816ULL, 0x000fe200000000ffULL, 0x0000000218497824ULL, 0x002fe200078e00ffULL,
0x000000041e1e7812ULL, 0x000fe200078ec0ffULL, 0x00001000704b7824ULL, 0x000fe200078e020bULL,
0xffffe0001d1d7812ULL, 0x000fe400078ec0ffULL, 0x0000001e0f1e7211ULL, 0x000fe400078fe0ffULL,
0x000000071c217812ULL, 0x000fe200078ec80fULL, 0x00001000701d7824ULL, 0x000fe200078e021dULL,
0x000000021e207810ULL, 0x000fc40007ffe0ffULL, 0x000000071c4a7812ULL, 0x000fe400078ef80fULL,
0x0000001e21597212ULL, 0x040fe400078e3cffULL, 0x00000020214d7212ULL, 0x000fe400078e3cffULL,
0x00000004494c7812ULL, 0x000fe200078ec0ffULL, 0x000000084a6a7824ULL, 0x040fe200078e0259ULL,
0x0000b0001d237810ULL, 0x000fe20007ffe0ffULL, 0x000000084a5a7824ULL, 0x040fe200078e024dULL,
0x000000804a587811ULL, 0x000fc400078e18ffULL, 0x000000070f4a7812ULL, 0x040fe200078ec0ffULL,
0x000000106a1c7824ULL, 0x000fe200078e0223ULL, 0x0000004c0f4c7211ULL, 0x000fe200078fe0ffULL,
0x0000000159597824ULL, 0x100fe200078e0258ULL, 0x0000b0004b4f7810ULL, 0x000fe20007ffe0ffULL,
0x000000014d587824ULL, 0x000fe200078e0258ULL, 0x000000084a577812ULL, 0x000fe200078ef80fULL,
0x000000105a237824ULL, 0x000fe200078e0223ULL, 0x000000024c4e7810ULL, 0x040fe20007ffe0ffULL,
0x0000001059487824ULL, 0x000fe200078e024fULL, 0x000000074c4c7812ULL, 0x000fe200078e7857ULL,
0x00000010584f7824ULL, 0x000fe200078e024fULL, 0x000000074e4e7812ULL, 0x000fe200078e7857ULL,
0x000000001c1c783bULL, 0x000e620000004200ULL, 0x000000ff5600720cULL, 0x000fe20003f05270ULL,
0x0000000857677824ULL, 0x040fe200078e024cULL, 0x00000000ff9f723eULL, 0x000fe200000010ffULL,
0x000000002320783bULL, 0x000ea20000004200ULL, 0x0000000857577824ULL, 0x000fe200078e024eULL,
0x00000002ffa27819ULL, 0x000fe2000001160fULL, 0x0000001067677824ULL, 0x000fe200078e00ffULL,
0x000000004f4c783bULL, 0x000ee20000004200ULL, 0x000054109f9f7816ULL, 0x000fe2000000009fULL,
0x0000001057577824ULL, 0x000fc400078e00ffULL, 0x000000004848783bULL, 0x000f220000004200ULL,
0x000000ff1c5e7812ULL, 0x042fe400078ec0ffULL, 0x00000010ff627819ULL, 0x100fe4000001161cULL,
0x00000018ff927819ULL, 0x000fe4000001161cULL, 0x0000ffff1c977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff697819ULL, 0x000fe4000001161dULL, 0x000000ff1d777812ULL, 0x000fc400078ec0ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001161dULL, 0x0000ffff1d737812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7f7819ULL, 0x104fe40000011623ULL, 0x000000ff238a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff767819ULL, 0x000fe40000011623ULL, 0x0000ffff23817812ULL, 0x000fc400078ec0ffULL,
0x0000005eff9a723eULL, 0x000fe400020006ffULL, 0x00000010ff967819ULL, 0x100fe4000001161eULL,
0x000000ff1e1d7812ULL, 0x040fe200078ec0ffULL, 0x2000009aff9a7230ULL, 0x000fe20000004100ULL,
0x00000018ff797819ULL, 0x000fe4000001161eULL, 0x0000ffff1e8d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff997819ULL, 0x008fc4000001164cULL, 0x000000ff4c5e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff237819ULL, 0x000fe4000001164cULL, 0x0000ffff4c8f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1e7819ULL, 0x100fe4000001161fULL, 0x000000ff1f987812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7b7819ULL, 0x000fc4000001161fULL, 0x0000ffff1f8e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7e7819ULL, 0x110fe40000011648ULL, 0x000000ff48857812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7d7819ULL, 0x000fe40000011648ULL, 0x0000ffff48827812ULL, 0x000fe400078ec0ffULL,
0x000000ff624c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff1f7819ULL, 0x100fe4000001164dULL,
0x000000ff4d5f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff487819ULL, 0x000fe4000001164dULL,
0x0000ffff4d747812ULL, 0x000fe400078ec0ffULL, 0x000000ff694d7812ULL, 0x000fe400078ec0ffULL,
0x0000004cff4c723eULL, 0x000fc400020006ffULL, 0x00000018ff7c7819ULL, 0x000fe40000011622ULL,
0x00000010ff6e7819ULL, 0x000fe2000001164bULL, 0x2000004cff9c7230ULL, 0x000fe20000004100ULL,
0x00000018ff867819ULL, 0x000fe40000011620ULL, 0x0000ffff4a5b7812ULL, 0x000fe400078ec0ffULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fc400020006ffULL,
0x00000010ff847819ULL, 0x000fe20000011649ULL, 0x2000004dff9d7230ULL, 0x000fe20000004100ULL,
0x000000ff7e7e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff887819ULL, 0x000fe40000011621ULL,
0x0000ffff49877812ULL, 0x000fe400078ec0ffULL, 0x00000008ff827819ULL, 0x000fe40000011682ULL,
0x0000007cff7c723eULL, 0x000fc400020006ffULL, 0x000000ff6e6e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8d7819ULL, 0x000fe4000001168dULL, 0x00000086ff4c723eULL, 0x000fe200020006ffULL,
0x20000076ff867230ULL, 0x000fe20000004100ULL, 0x00000008ff5b7819ULL, 0x000fe4000001165bULL,
0x000000ff22897812ULL, 0x000fe200078ec0ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x000000ff84847812ULL, 0x000fc400078ec0ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x00000088ff4d723eULL, 0x000fe400020006ffULL, 0x00000008ff877819ULL, 0x000fe40000011687ULL,
0x00000082ff76723eULL, 0x000fe200020006ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x0000008aff88723eULL, 0x000fe200020006ffULL, 0x2000007cff8a7230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fc400020006ffULL, 0x00000010ff5d7819ULL, 0x000fe20000011620ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x000000ff208c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff205c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4a947812ULL, 0x000fe400078ec0ffULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fc400020006ffULL,
0x00000010ff207819ULL, 0x000fe40000011621ULL, 0x000000ff218b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff21567812ULL, 0x000fe400078ec0ffULL, 0x000000ff49957812ULL, 0x000fe400078ec0ffULL,
0x00000018ff837819ULL, 0x000fe40000011649ULL, 0x00000089ff89723eULL, 0x000fc400020006ffULL,
0x00000084ff7c723eULL, 0x000fe200020006ffULL, 0x2000007eff847230ULL, 0x000fe20000004100ULL,
0x00000010ff787819ULL, 0x100fe2000001164aULL, 0x20000076ff7e7230ULL, 0x000fe20000004100ULL,
0x00000018ff917819ULL, 0x000fe2000001164aULL, 0x2000006eff767230ULL, 0x000fe20000004100ULL,
0x00000010ff757819ULL, 0x100fe2000001164eULL, 0x2000005bff6e7230ULL, 0x000fe20000004100ULL,
0x000000ff4e497812ULL, 0x000fe200078ec0ffULL, 0x2000007cff827230ULL, 0x000fe20000004100ULL,
0x00000018ff217819ULL, 0x000fc4000001164eULL, 0x0000ffff4e617812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8e7819ULL, 0x000fe4000001168eULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000023ff23723eULL, 0x000fe400020006ffULL, 0x000000ff4f4e7812ULL, 0x000fe200078ec0ffULL,
0x20000087ff7c7230ULL, 0x000fe20000004100ULL, 0x00000079ff4a723eULL, 0x000fc400020006ffULL,
0x00000094ff79723eULL, 0x000fe200020006ffULL, 0x2000008dff947230ULL, 0x000fe20000004100ULL,
0x00000095ff95723eULL, 0x000fe200020006ffULL, 0x20000089ff8d7230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000048ff5b723eULL, 0x000fe200020006ffULL, 0x20000023ff487230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fe20000011622ULL, 0x0000080014237824ULL, 0x000fe200078e0267ULL,
0x0000ffff22807812ULL, 0x000fe200078ec0ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x000000ff4b937812ULL, 0x000fc400078ec0ffULL, 0x00000018ff907819ULL, 0x000fe4000001164bULL,
0x0000ffff4b727812ULL, 0x000fe400078ec0ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x0000004eff89723eULL, 0x000fe200020006ffULL,
0x20000091ff627230ULL, 0x000fe20000004100ULL, 0x00000018ff227819ULL, 0x000fc4000001164fULL,
0x0000007bff4b723eULL, 0x000fe400020006ffULL, 0x00000049ff87723eULL, 0x000fe200020006ffULL,
0x2000005bff497230ULL, 0x000fe20000004100ULL, 0x000000ff20207812ULL, 0x000fe200078ec0ffULL,
0x20000089ff5b7230ULL, 0x000fe20000004100ULL, 0x00000083ff7b723eULL, 0x000fe200020006ffULL,
0x20000095ff837230ULL, 0x000fe20000004100ULL, 0x00000021ff89723eULL, 0x000fe200020006ffULL,
0x2000008eff957230ULL, 0x000fe20000004100ULL, 0x00000020ff91723eULL, 0x000fe200020006ffULL,
0x2000008bff8e7230ULL, 0x000fe20000004100ULL, 0x00000022ff8b723eULL, 0x000fe200020006ffULL,
0x20000087ff4e7230ULL, 0x000fe20000004100ULL, 0x00000077ff77723eULL, 0x000fe200020006ffULL,
0x009000002320783bULL, 0x000fe20000000200ULL, 0x00000008ff877819ULL, 0x000fe2000001165cULL,
0x20000089ff5c7230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000077ff9b7230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000093ff77723eULL, 0x000fe200020006ffULL,
0x2000008cff937230ULL, 0x000fe20000004100ULL, 0x00000008ff567819ULL, 0x000fe20000011656ULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x000000ff7a8c7812ULL, 0x000fe200078ec0ffULL,
0x20000087ff7a7230ULL, 0x000fe20000004100ULL, 0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL,
0x20000090ff697230ULL, 0x000fe20000004100ULL, 0x00000056ff87723eULL, 0x000fe200020006ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000008a2567810ULL, 0x000fc40007ffe0ffULL,
0x0000005dff90723eULL, 0x000fe200020006ffULL, 0x2000008bff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff7f8b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff897819ULL, 0x000fe20000011680ULL,
0x00001fa29f7f7589ULL, 0x000e6200000e0000ULL, 0x00000008ff817819ULL, 0x000fe20000011681ULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x0000008bff9e723eULL, 0x000fe200020006ffULL,
0x00001f569f807589ULL, 0x000ea200000e0000ULL, 0x00000081ffa0723eULL, 0x000fe200020006ffULL,
0x20000087ff817230ULL, 0x000fe20000004100ULL, 0x00000089ff8b723eULL, 0x000fe200020006ffULL,
0x2000009eff897230ULL, 0x000fe20000004100ULL, 0x0000001cff9e723eULL, 0x000fe200020006ffULL,
0x200000a0ff877230ULL, 0x000fe20000004100ULL, 0x0000001dffa0723eULL, 0x000fe200020006ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff1c7819ULL, 0x000fe2000001169aULL,
0x2000009eff9e7230ULL, 0x000fe20000004100ULL, 0x00000010ff1d7819ULL, 0x000fe2000001169cULL,
0x200000a0ffa07230ULL, 0x000fe20000004100ULL, 0x00000010ff9b7819ULL, 0x000fc4000001169bULL,
0x00000010ff9a7819ULL, 0x000fe4000001169dULL, 0x00000008ff977819ULL, 0x000fe40000011697ULL,
0x00000008ff737819ULL, 0x000fe20000011673ULL, 0x0000007f20208231ULL, 0x082fe200003400ffULL,
0x000010541d1c7816ULL, 0x000fe2000000001cULL, 0x0000007f22228231ULL, 0x000fe200003400ffULL,
0x000010549a1d7816ULL, 0x000fe2000000009bULL, 0x0000008021218231ULL, 0x084fe200003400ffULL,
0x00000097ff97723eULL, 0x000fe200020006ffULL, 0x0000008023238231ULL, 0x000fe200003400ffULL,
0x000000ff969a7812ULL, 0x000fc400078ec0ffULL, 0x000000ff1e1e7812ULL, 0x000fe200078ec0ffULL,
0x20000097ff977230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000073ff96723eULL, 0x000fe200020006ffULL, 0x0000001c2028723cULL, 0x000fe20000041828ULL,
0x0000001eff1e723eULL, 0x000fe200020006ffULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x000000ff999b7812ULL, 0x000fe200078ec0ffULL, 0x20000096ff967230ULL, 0x000fe20000004100ULL,
0x00000098ff98723eULL, 0x000fc400020006ffULL, 0x0000009aff99723eULL, 0x000fe200020006ffULL,
0x2000001eff9a7230ULL, 0x000fe20000004100ULL, 0x00000010ff1e7819ULL, 0x000fe20000011697ULL,
0x20000098ff987230ULL, 0x000fe20000004100ULL, 0x00000010ff1d7819ULL, 0x000fe20000011692ULL,
0x20000099ff997230ULL, 0x000fe20000004100ULL, 0x00000010ff977819ULL, 0x000fe4000001169eULL,
0x00000010ff967819ULL, 0x000fe40000011696ULL, 0x000000ff1f927812ULL, 0x000fc400078ec0ffULL,
0x000010541d1e7816ULL, 0x000fe4000000001eULL, 0x00001054971f7816ULL, 0x000fe40000000096ULL,
0x00000010ff1c7819ULL, 0x000fe400000116a0ULL, 0x00000010ff997819ULL, 0x000fe40000011699ULL,
0x00000010ff1d7819ULL, 0x000fe20000011698ULL, 0x0000001e202c723cULL, 0x000fe2000004182cULL,
0x00000010ff9a7819ULL, 0x000fc4000001169aULL, 0x00001054991c7816ULL, 0x000fe4000000001cULL,
0x000010549a1d7816ULL, 0x000fe4000000001dULL, 0x00000010ff1f7819ULL, 0x000fe2000001164aULL,
0x00000800141e7824ULL, 0x000fe200078e0257ULL, 0x00000010ff4a7819ULL, 0x000fe40000011694ULL,
0x00000010ff947819ULL, 0x000fe2000001164bULL, 0x0000001c2030723cULL, 0x000fe20000041830ULL,
0x00000010ff4b7819ULL, 0x000fc40000011695ULL, 0x000010541f4a7816ULL, 0x000fe4000000004aULL,
0x009000001e1c783bULL, 0x000e620000000200ULL, 0x00001054944b7816ULL, 0x000fe4000000004bULL,
0x00000008ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff917819ULL, 0x000fe20000011691ULL, 0x0000004a2034723cULL, 0x000fe20000041834ULL,
0x0000008fff94723eULL, 0x000fc400020006ffULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00001054914b7816ULL, 0x000fe4000000008eULL,
0x00000010ff8f7819ULL, 0x000fe4000001164cULL, 0x00000010ff8e7819ULL, 0x000fe4000001164dULL,
0x00000010ff4c7819ULL, 0x000fe2000001167aULL, 0x20000094ff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff4d7819ULL, 0x000fc40000011681ULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00001054904a7816ULL, 0x000fe40000000093ULL, 0x000010548f4c7816ULL, 0x000fe2000000004cULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x000010548e4d7816ULL, 0x000fe4000000004dULL,
0x00000010ff887819ULL, 0x000fe20000011688ULL, 0x0000004a2038723cULL, 0x000fe20000041838ULL,
0x00000010ff897819ULL, 0x000fc40000011689ULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff8b7819ULL, 0x000fe2000001168bULL, 0x0000007f1c1c8231ULL, 0x082fe200003400ffULL,
0x00000010ff4a7819ULL, 0x000fe2000001168dULL, 0x0000004c203c723cULL, 0x000fe2000004183cULL,
0x00000010ff4b7819ULL, 0x000fe2000001168cULL, 0x0000007f1e1e8231ULL, 0x000fe200003400ffULL,
0x00000010ff867819ULL, 0x000fe20000011686ULL, 0x000000801d1d8231ULL, 0x080fe200003400ffULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x000000801f1f8231ULL, 0x000fe200003400ffULL,
0x00000010ff4d7819ULL, 0x000fc40000011687ULL, 0x000010544b4a7816ULL, 0x000fe2000000004aULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00001054894b7816ULL, 0x000fe40000000088ULL,
0x000010548a4c7816ULL, 0x000fe4000000008bULL, 0x00001054864d7816ULL, 0x000fe4000000004dULL,
0x000000ff78787812ULL, 0x000fe200078ec0ffULL, 0x0000004a2040723cULL, 0x000fe20000041840ULL,
0x00000008ff727819ULL, 0x000fc40000011672ULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x0000004c2024723cULL, 0x000fe20000041824ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000008ff747819ULL, 0x000fe20000011674ULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff697819ULL, 0x000fe20000011669ULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff227819ULL, 0x000fc4000001167bULL,
0x00000010ff207819ULL, 0x000fe4000001167eULL, 0x00000010ff217819ULL, 0x000fe4000001167cULL,
0x000010547d207816ULL, 0x000fe40000000020ULL, 0x0000105422217816ULL, 0x000fe40000000021ULL,
0x00000010ff227819ULL, 0x000fe40000011679ULL, 0x00000010ff237819ULL, 0x000fc40000011678ULL,
0x00000010ff727819ULL, 0x000fe20000011672ULL, 0x000000201c2c723cULL, 0x000fe2000004182cULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff217819ULL, 0x000fe40000011662ULL,
0x00000010ff207819ULL, 0x000fc4000001166eULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000009bff73723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x0000105421207816ULL, 0x000fe20000000020ULL, 0x20000092ff817230ULL, 0x000fe20000004100ULL,
0x0000105423227816ULL, 0x000fe20000000022ULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x0000105469217816ULL, 0x000fc40000000072ULL, 0x00001054844a7816ULL, 0x000fe40000000085ULL,
0x00001054824b7816ULL, 0x000fe40000000083ULL, 0x0000105476237816ULL, 0x000fe20000000077ULL,
0x000000201c34723cULL, 0x000fe20000041834ULL, 0x00000010ff607819ULL, 0x000fe4000001164fULL,
0x0000ffff4f4f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff75757812ULL, 0x000fc400078ec0ffULL,
0x000000ff60607812ULL, 0x000fe200078ec0ffULL, 0x0000004a1c28723cULL, 0x040fe20000041828ULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff217819ULL, 0x000fe40000011648ULL, 0x00000010ff207819ULL, 0x000fe2000001167aULL,
0x000000221c30723cULL, 0x000fe20000041830ULL, 0x00000010ff737819ULL, 0x000fc40000011673ULL,
0x00000010ff4a7819ULL, 0x000fe40000011681ULL, 0x00000010ff497819ULL, 0x000fe40000011649ULL,
0x00000010ff227819ULL, 0x000fe4000001165eULL, 0x00000010ff237819ULL, 0x000fe4000001165fULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000075ff75723eULL, 0x000fc400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000105421207816ULL, 0x000fe20000000020ULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x0000105473227816ULL, 0x000fe20000000022ULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x000010544a237816ULL, 0x000fc40000000023ULL,
0x0000105449217816ULL, 0x000fe40000000074ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff607819ULL, 0x000fe20000011660ULL, 0x000000221c38723cULL, 0x000fe20000041838ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff4f7819ULL, 0x000fc4000001164fULL, 0x00000010ff227819ULL, 0x000fe2000001164eULL,
0x000000201c3c723cULL, 0x000fe2000004183cULL, 0x00000010ff237819ULL, 0x000fe4000001165bULL,
0x0000105475227816ULL, 0x000fe40000000022ULL, 0x0000105460237816ULL, 0x000fe40000000023ULL,
0x00000010ff207819ULL, 0x000fe4000001165dULL, 0x000010545c5c7816ULL, 0x000fc40000000061ULL,
0x00001054205d7816ULL, 0x000fe2000000004fULL, 0x000000221c40723cULL, 0x040ff00000041840ULL,
0x0000005c1c24723cULL, 0x000fee0000041824ULL, 0x000001001a5d7824ULL, 0x000fe200078e00ffULL,
0x0000f610141c7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff00000008000ULL,
0x0000200006ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000040141d7824ULL, 0x000fe200078e025dULL, 0x000000ff71ff7812ULL, 0x000fe2000782c0ffULL,
0x000000001cff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff6fff7812ULL, 0x000fc4000784c0ffULL,
0x000000401d1d7810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff4c7807ULL, 0x000fe40000800000ULL,
0x000000161d00720cULL, 0x000fe40003f26070ULL, 0x000000017000780cULL, 0x040fe40003f05270ULL,
0x00000001ff697807ULL, 0x000fe40001000000ULL, 0x0000000170707812ULL, 0x000fc400078e0cffULL,
0x000000714c717207ULL, 0x000fe40004000000ULL, 0x00007610696f7816ULL, 0x000fc6000000006fULL,
0x00006d6000001947ULL, 0x000fea0003800000ULL, 0x0000240006127984ULL, 0x004ea20000000800ULL,
0x80000000690d7824ULL, 0x000fca00078e00ffULL, 0x8000000012ff7812ULL, 0x004fe2000782480dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x0000240006127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x004fe4000782480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0d7424ULL, 0x000fe400078e00ffULL, 0x80000000691d7824ULL, 0x000fe400078e00ffULL,
0x0000000d00127305ULL, 0x0004e4000021f000ULL, 0x3fa000000d0d7823ULL, 0x004fe200000100ffULL,
0x000000120000735dULL, 0x008fe40003800000ULL, 0x0000240006127984ULL, 0x000ea40000000800ULL,
0x8000000012ff7812ULL, 0x004fc4000782481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000036d0d7812ULL, 0x000fc800078ec0ffULL,
0x000000030d00780cULL, 0x000fc80003f25270ULL, 0x0000000111127807ULL, 0x000fca0004800000ULL,
0x000000016d6d7824ULL, 0x000fca00078e0212ULL, 0x000000036d0d7812ULL, 0x000fc800078ec0ffULL,
0x000000030d00780cULL, 0x000fe40003f25270ULL, 0x00000001ff0d7819ULL, 0x000fe40000011618ULL,
0x00000001116e7807ULL, 0x000fc60004800000ULL, 0x000000200d1f7824ULL, 0x000fe400078e0268ULL,
0x000000016d127824ULL, 0x000fc600078e026eULL, 0x000000801f1f7810ULL, 0x000fe40007ffe0ffULL,
0x000000171200720cULL, 0x000fe40003f26070ULL, 0x000000200a1c7812ULL, 0x000fca00078ef81fULL,
0x0000000910217224ULL, 0x020fe400078e021cULL, 0xffffffffff107424ULL, 0x000fc800078e00ffULL,
0x0000006e051d9210ULL, 0x000fe20007ffe06dULL, 0x00000004ff1e9424ULL, 0x000fe200078e00ffULL,
0x000000011a207810ULL, 0x000fc60007ffe0ffULL, 0x000060001d1c9625ULL, 0x000fe200078e001eULL,
0x0000001f161e7217ULL, 0x000fc80007800000ULL, 0x000000081c109981ULL, 0x000562000c1e1900ULL,
0x000000011e1e7824ULL, 0x000fe200078e0a1fULL, 0x000000152000720cULL, 0x000fe20003f26070ULL,
0x00000008185b7824ULL, 0x000fe200078e00ffULL, 0x00000010131f7812ULL, 0x000fe200078ec0ffULL,
0x00000080ff4d7424ULL, 0x000fe200078e00ffULL, 0x000000201e1e7807ULL, 0x000fe20000800000ULL,
0x0000000146227824ULL, 0x100fe200078e0221ULL, 0x0000000103627812ULL, 0x000fe400078ec0ffULL,
0xfffffff05b5b7812ULL, 0x000fe200078ec0ffULL, 0x00000001541c7824ULL, 0x004fe200078e0221ULL,
0x0000001e1f1e7217ULL, 0x000fe20007800000ULL, 0x0000000862207824ULL, 0x000fe200078e00ffULL,
0x0000f6485b4e7810ULL, 0x000fe20007ffe0ffULL, 0x00005e001c1c7625ULL, 0x000fe200078e004dULL,
0x00000003ff497819ULL, 0x000fe2000001160fULL, 0x00000000200773c2ULL, 0x0004e200000e0000ULL,
0x0000000820617812ULL, 0x000fe200078e3cffULL, 0x000000011e487824ULL, 0x000fe200078e0a1fULL,
0x000000191c1c7210ULL, 0x000fe20007f3e0ffULL, 0x00000001521e7824ULL, 0x000fe200078e0221ULL,
0x00000008494b7810ULL, 0x000fe20007ffe0ffULL, 0x000000020d4a7824ULL, 0x000fe200078e0262ULL,
0x0000000449237810ULL, 0x040fe20007ffe0ffULL, 0x000000004e0673c2ULL, 0x000ee200000e0000ULL,
0x00005e001e1e7625ULL, 0x000fe200078e004dULL, 0x000000484900720cULL, 0x000fc40003f46070ULL,
0x0000b0004a4a7811ULL, 0x000fe200078e60ffULL, 0x0000000150207824ULL, 0x004fe200078e0221ULL,
0x000000191e1e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e061dULL,
0x000000482300720cULL, 0x000fe20003f26070ULL, 0x00005e0020207625ULL, 0x000fc800078e004dULL,
0x000000ffff1f7224ULL, 0x000fe200018e061fULL, 0x0000001920207210ULL, 0x000fe20007f9e0ffULL,
0x00005e0022227625ULL, 0x000fe200078e004dULL, 0x000000484b00720cULL, 0x080fe40003f66070ULL,
0x0000000c494b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff217224ULL, 0x000fe200020e0621ULL,
0x0000001922227210ULL, 0x000fe20007fbe0ffULL, 0x0000001053497824ULL, 0x100fe200078e024aULL,
0x000000484b00720cULL, 0x000fe20003f86070ULL, 0x00000010514b7824ULL, 0x100fe200078e024aULL,
0x0000000706067290ULL, 0x008fe2000fffe03fULL, 0x00000010474d7824ULL, 0x000fe200078e024aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c497faeULL, 0x0005e2000d101c48ULL,
0x000000ffff237224ULL, 0x000fc400028e0623ULL, 0x00000010454f7824ULL, 0x000fe200078e024aULL,
0x000000001e4b7faeULL, 0x0005e2000c901c48ULL, 0x000000014e617824ULL, 0x000fc600078e0261ULL,
0x00000000204d7faeULL, 0x0005e8000d901c48ULL, 0x00000000224f7faeULL, 0x0005e8000e101c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a06ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000400611d7984ULL, 0x0044e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f61c00021e7984ULL, 0x000f220000000800ULL,
0x0000006c4c6c7207ULL, 0x000fe20004000000ULL, 0x800000001b1f7824ULL, 0x000fc600078e00ffULL,
0x0000ffff6c1c7812ULL, 0x000fc800078ec0ffULL, 0x000088801c237816ULL, 0x000fca00000000ffULL,
0x80000000231c7824ULL, 0x000fca00078e00ffULL, 0x800000001dff7812ULL, 0x008fe4000780481cULL,
0x800000001eff7812ULL, 0x010fe2000782481fULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000418027824ULL, 0x000fe400078e00ffULL,
0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL, 0x800000001b1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff002027812ULL, 0x000fe400078ec0ffULL, 0x0000001c001d7305ULL, 0x000724000021f000ULL,
0x3fa000001c1c7823ULL, 0x008fe200000100ffULL, 0x0000001d0000735dULL, 0x010fe40003800000ULL,
0x00f61c00021d7984ULL, 0x000ee40000000800ULL, 0x800000001dff7812ULL, 0x008fc4000782481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000020181c7824ULL, 0x000fe400078e00ffULL, 0x00000001ff487424ULL, 0x000fc600078e00ffULL,
0xffffff801c1c7812ULL, 0x000fc800078ec0ffULL, 0x00000080191d7810ULL, 0x000fca0007ffe01cULL,
0x00000001441d7824ULL, 0x000fca00078e021dULL, 0x00f000001d1f7984ULL, 0x000ee80000000800ULL,
0x00f200001d1c7984ULL, 0x0008620000000800ULL, 0x000000081f00720bULL, 0x008fda0003f3d000ULL,
0x00000000001e7806ULL, 0x000fc800008e0100ULL, 0x0000ffff1e227812ULL, 0x000fda000782c0ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000081f00720bULL, 0x012fe40003f34000ULL,
0x0000001f08207209ULL, 0x000fe40007810000ULL, 0x00000002ff487819ULL, 0x000fc6000001160fULL,
0x80000020081d7221ULL, 0x040fe20000010000ULL, 0x0000001f08087209ULL, 0x000fc60007810000ULL,
0x3fb8aa3b1d217820ULL, 0x000fe20000410000ULL, 0x00000001141d7810ULL, 0x000fe40007ffe0ffULL,
0x00000000001e7806ULL, 0x000fe400008e0100ULL, 0x000000181d00720cULL, 0x000fe20003f25270ULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x0000ffff1e497812ULL, 0x000fc800078e3cffULL,
0x0000004922ff7212ULL, 0x000fce000784c0ffULL, 0x0000008018499824ULL, 0x000fc800078e0219ULL,
0x0000000144499824ULL, 0x000fe200078e0249ULL, 0x00001f48211d7589ULL, 0x0022e200000e0000ULL,
0x800000201f222221ULL, 0x000fe20000010000ULL, 0x0000002107077220ULL, 0x000fe40000410000ULL,
0x00001f56211e7589ULL, 0x000f2200000e0000ULL, 0x3fb8aa3b22222820ULL, 0x000fc60000410000ULL,
0x00f4002049009388ULL, 0x0005e20000000800ULL, 0x0000002200002308ULL, 0x000ea20000000800ULL,
0x00000001ff487807ULL, 0x002fe20001000000ULL, 0x0000001d28287220ULL, 0x088fe20000410000ULL,
0x0000001d29297220ULL, 0x080fe20000410000ULL, 0x0000001d2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001d2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001d30307220ULL, 0x080fe20000410000ULL,
0x0000001d31317220ULL, 0x080fe20000410000ULL, 0x0000001d34347220ULL, 0x080fe20000410000ULL,
0x0000001d35357220ULL, 0x080fe20000410000ULL, 0x0000001d38387220ULL, 0x080fe20000410000ULL,
0x0000001d39397220ULL, 0x080fe20000410000ULL, 0x0000001d3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001d3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001d40407220ULL, 0x080fe20000410000ULL,
0x0000001d41417220ULL, 0x080fe20000410000ULL, 0x0000001d24247220ULL, 0x080fe20000410000ULL,
0x0000001d25257220ULL, 0x000fe20000410000ULL, 0x0000001e2a2a7220ULL, 0x090fe20000410000ULL,
0x0000001e2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001e2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001e2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001e32327220ULL, 0x080fe20000410000ULL,
0x0000001e33337220ULL, 0x080fe20000410000ULL, 0x0000001e36367220ULL, 0x080fe20000410000ULL,
0x0000001e37377220ULL, 0x080fe20000410000ULL, 0x0000001e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001e3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001e3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001e3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001e42427220ULL, 0x080fe20000410000ULL,
0x0000001e43437220ULL, 0x080fe20000410000ULL, 0x0000001e26267220ULL, 0x080fe20000410000ULL,
0x0000001e27277220ULL, 0x000fe20000410000ULL, 0x0000001c001c2220ULL, 0x004fc80000410000ULL,
0x000000071c077221ULL, 0x012fe20000010000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000008621c7824ULL, 0x000fe400078e00ffULL, 0x80000000231d7824ULL, 0x000fc600078e00ffULL,
0x000000081c1c7812ULL, 0x000fca00078e3cffULL, 0x000000015b1e7824ULL, 0x000fca00078e021cULL,
0x00f64c001e1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe4000780481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000023207824ULL, 0x000fe400078e00ffULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c001d7305ULL, 0x0002e4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x008fe40003800000ULL, 0x00f64c001e1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc40007804820ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00001000031c7824ULL, 0x000fe200078e00ffULL,
0x00009910484d7816ULL, 0x000fe200000000ffULL, 0x00001000181d7824ULL, 0x040fe400078e00ffULL,
0x00000200184c7824ULL, 0x000fe200078e00ffULL, 0x000010001c4a7812ULL, 0x000fe400078e0cffULL,
0xffffe0001d1d7812ULL, 0x000fe400078ec0ffULL, 0x0000b0000b5c7810ULL, 0x100fe40007ffe04aULL,
0x0000b0001d5f7810ULL, 0x000fc40007ffe04aULL, 0xfffff8004c4c7812ULL, 0x000fe200078ec0ffULL,
0x00000010595e7824ULL, 0x100fe200078e025cULL, 0x000000ff4d00720cULL, 0x000fe20003f05270ULL,
0x000000106a607824ULL, 0x100fe400078e025fULL, 0x000000105a5f7824ULL, 0x000fe200078e025fULL,
0x000000005e48783bULL, 0x000e620000004200ULL, 0x00000010585c7824ULL, 0x000fe400078e025cULL,
0x0000000167677824ULL, 0x100fe200078e024cULL, 0x00000000601c783bULL, 0x000ee20000004200ULL,
0x0000000157577824ULL, 0x000fc600078e024cULL, 0x000000005f20783bULL, 0x000f280000004200ULL,
0x000000005c4c783bULL, 0x000ea20000004200ULL, 0x000000ff4a767812ULL, 0x002fe400078ec0ffULL,
0x00000018ff777819ULL, 0x000fe4000001164aULL, 0x00000010ff977819ULL, 0x008fe4000001161dULL,
0x000000ff1da47812ULL, 0x000fc400078ec0ffULL, 0x00000018ffa27819ULL, 0x000fe4000001161dULL,
0x0000ffff1d997812ULL, 0x000fe400078ec0ffULL, 0x000000ff1f9d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff9e7819ULL, 0x000fe4000001161fULL, 0x00000010ff1d7819ULL, 0x000fe4000001164aULL,
0x0000ffff4a7c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ffa07819ULL, 0x100fe4000001161cULL,
0x000000ff1c927812ULL, 0x040fe400078ec0ffULL, 0x00000018ffa37819ULL, 0x000fe4000001161cULL,
0x0000ffff1c9f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff21957812ULL, 0x010fe400078ec0ffULL,
0x00000010ff7d7819ULL, 0x000fc4000001164bULL, 0x000000ff4b7e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7b7819ULL, 0x000fe4000001164bULL, 0x0000ffff4b9b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff9c7819ULL, 0x104fe4000001164cULL, 0x000000ff4c717812ULL, 0x000fe400078ec0ffULL,
0x00000018ff707819ULL, 0x000fc4000001164cULL, 0x0000ffff4c4a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7f7819ULL, 0x000fe40000011620ULL, 0x00000010ff8f7819ULL, 0x100fe40000011621ULL,
0x00000018ff907819ULL, 0x000fe40000011621ULL, 0x0000ffff21877812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8b7819ULL, 0x000fc40000011649ULL, 0x000000ff498d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff737819ULL, 0x000fe40000011649ULL, 0x0000ffff491c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4b7819ULL, 0x100fe4000001164dULL, 0x000000ff4d4c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff727819ULL, 0x000fc4000001164dULL, 0x0000ffff4d787812ULL, 0x000fe400078ec0ffULL,
0x00000010ff797819ULL, 0x100fe4000001164eULL, 0x000000ff4e4d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff217819ULL, 0x000fe4000001164eULL, 0x0000ffff4e747812ULL, 0x000fe400078ec0ffULL,
0x0000009dff49723eULL, 0x000fc400020006ffULL, 0x000000ff23917812ULL, 0x000fe400078ec0ffULL,
0x0000009eff4e723eULL, 0x000fe200020006ffULL, 0x20000049ff9e7230ULL, 0x000fe20000004100ULL,
0x00000018ff987819ULL, 0x000fe4000001161eULL, 0x00000018ff8a7819ULL, 0x000fe20000011622ULL,
0x2000004eff497230ULL, 0x000fe20000004100ULL, 0x00000095ff95723eULL, 0x000fe400020006ffULL,
0x0000007fff7f723eULL, 0x000fc400020006ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000010ff837819ULL, 0x100fe40000011648ULL, 0x000000ff488c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff847819ULL, 0x000fe40000011648ULL, 0x0000ffff48897812ULL, 0x000fe400078ec0ffULL,
0x00000091ff91723eULL, 0x000fc400020006ffULL, 0x00000098ff48723eULL, 0x000fe200020006ffULL,
0x20000095ff987230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x2000007fff957230ULL, 0x000fe20000004100ULL, 0x0000008dff4e723eULL, 0x000fe200020006ffULL,
0x20000090ff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff887819ULL, 0x000fe20000011622ULL,
0x20000091ff907230ULL, 0x000fe20000004100ULL, 0x000000ff22947812ULL, 0x040fe200078ec0ffULL,
0x2000008aff917230ULL, 0x000fe20000004100ULL, 0x0000ffff22867812ULL, 0x000fe200078ec0ffULL,
0x2000004eff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x100fe20000011623ULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000018ff827819ULL, 0x000fc40000011623ULL,
0x0000ffff23857812ULL, 0x000fe400078ec0ffULL, 0x00000018ff227819ULL, 0x100fe4000001164fULL,
0x00000010ff757819ULL, 0x000fe4000001164fULL, 0x000000ff4f237812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4f6f7812ULL, 0x000fe400078ec0ffULL, 0x00000076ff76723eULL, 0x000fc400020006ffULL,
0x0000007eff4e723eULL, 0x000fe400020006ffULL, 0x0000007bff4f723eULL, 0x000fe200020006ffULL,
0x20000076ff7e7230ULL, 0x000fe20000004100ULL, 0x0000004cff4c723eULL, 0x000fe200020006ffULL,
0x2000004eff7b7230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x2000004fff767230ULL, 0x000fe20000004100ULL, 0x00000021ff21723eULL, 0x000fe400020006ffULL,
0x00000022ff22723eULL, 0x000fe200020006ffULL, 0x2000004dff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff967819ULL, 0x000fe2000001161eULL, 0x20000021ff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff817819ULL, 0x000fc4000001161fULL, 0x0000ffff1f7a7812ULL, 0x000fe400078ec0ffULL,
0x00000072ff4e723eULL, 0x000fe200020006ffULL, 0x2000004cff727230ULL, 0x000fe20000004100ULL,
0x00000008ff9f7819ULL, 0x000fe2000001169fULL, 0x20000022ff4c7230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x000000ffa0a07812ULL, 0x000fe400078ec0ffULL,
0x000000ff96967812ULL, 0x000fe200078ec0ffULL, 0x20000082ff8d7230ULL, 0x000fe20000004100ULL,
0x000000ff1ea17812ULL, 0x000fc400078ec0ffULL, 0x0000ffff1e807812ULL, 0x000fe400078ec0ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x000000ff81217812ULL, 0x000fe400078ec0ffULL,
0x00000008ff227819ULL, 0x000fe2000001167aULL, 0x20000073ff827230ULL, 0x000fe20000004100ULL,
0x00000000ff1e723eULL, 0x000fe400000010ffULL, 0x000000a3ffa3723eULL, 0x000fc400020006ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x000000a4ffa4723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x20000071ff737230ULL, 0x000fe20000004100ULL,
0x0000009fff9f723eULL, 0x000fe400020006ffULL, 0x00000010ff937819ULL, 0x000fe20000011620ULL,
0x20000070ff717230ULL, 0x000fe20000004100ULL, 0x000000ff209a7812ULL, 0x000fe200078ec0ffULL,
0x2000004eff707230ULL, 0x000fe20000004100ULL, 0x000000a0ffa0723eULL, 0x000fc400020006ffULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x0000ffff20207812ULL, 0x000fe400078ec0ffULL,
0x00000092ffa5723eULL, 0x000fe400020006ffULL, 0x00000023ff23723eULL, 0x000fe400020006ffULL,
0x00000008ff807819ULL, 0x000fe20000011680ULL, 0x200000a5ffa57230ULL, 0x000fe20000004100ULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x20000023ff4e7230ULL, 0x000fe20000004100ULL,
0x00000022ff22723eULL, 0x000fc400020006ffULL, 0x000054101e927816ULL, 0x000fe2000000001eULL,
0x200000a3ff1e7230ULL, 0x000fe20000004100ULL, 0x000000a2ff1f723eULL, 0x000fe200020006ffULL,
0x200000a4ffa37230ULL, 0x000fe20000004100ULL, 0x00000008ff997819ULL, 0x000fe20000011699ULL,
0x2000009fffa27230ULL, 0x000fe20000004100ULL, 0x00000080ff7a723eULL, 0x000fe200020006ffULL,
0x200000a0ffa47230ULL, 0x000fe20000004100ULL, 0x000000ff93937812ULL, 0x000fe200078ec0ffULL,
0x20000096ff9f7230ULL, 0x000fe20000004100ULL, 0x00000008ff967819ULL, 0x000fe20000011620ULL,
0x20000021ffa07230ULL, 0x000fe20000004100ULL, 0x00000099ff99723eULL, 0x000fe200020006ffULL,
0x20000022ff807230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x009800006720783bULL, 0x000fe20000000200ULL, 0x000000ff97977812ULL, 0x000fe200078ec0ffULL,
0x20000099ff817230ULL, 0x000fe20000004100ULL, 0x00000008ff877819ULL, 0x000fe20000011687ULL,
0x20000093ff997230ULL, 0x000fe20000004100ULL, 0x000000a1ffa1723eULL, 0x000fe200020006ffULL,
0x2000001fff1f7230ULL, 0x000fe20000004100ULL, 0x00000097ff97723eULL, 0x000fe200020006ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x000000ff88937812ULL, 0x000fe200078ec0ffULL,
0x200000a1ff9d7230ULL, 0x000fe20000004100ULL, 0x00000087ff88723eULL, 0x000fe200020006ffULL,
0x20000097ffa17230ULL, 0x000fe20000004100ULL, 0x00000002ff877819ULL, 0x000fc4000001160fULL,
0x000000ff8f977812ULL, 0x000fe200078ec0ffULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x000000ff8e8f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8e7819ULL, 0x000fe20000011686ULL,
0x00001f8792877589ULL, 0x000e6200000e0000ULL, 0x00000008ffa77819ULL, 0x000fe40000011685ULL,
0x000000ff83a67812ULL, 0x000fe200078ec0ffULL, 0x00001f5692867589ULL, 0x0004e200000e0000ULL,
0x000000ff8b857812ULL, 0x000fc400078ec0ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x000000a7ff83723eULL, 0x000fe400020006ffULL, 0x000000a6ff8b723eULL, 0x000fe400020006ffULL,
0x00000008ff1c7819ULL, 0x000fe4000001161cULL, 0x00000008ff927819ULL, 0x004fe20000011689ULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00000085ff89723eULL, 0x000fc400020006ffULL,
0x000000ff1d1d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ffa67819ULL, 0x000fe200000116a4ULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000092ff85723eULL, 0x000fe200020006ffULL,
0x2000008eff927230ULL, 0x000fe20000004100ULL, 0x00000010ffa57819ULL, 0x000fe200000116a5ULL,
0x20000083ff8e7230ULL, 0x000fe20000004100ULL, 0x00000010ffa37819ULL, 0x000fe200000116a3ULL,
0x0000008720208231ULL, 0x082fe200003400ffULL, 0x00000010ffa47819ULL, 0x000fe200000116a1ULL,
0x0000008722228231ULL, 0x000fe200003400ffULL, 0x0000001cff83723eULL, 0x000fe200020006ffULL,
0x0000008621218231ULL, 0x088fe200003400ffULL, 0x0000001dffa1723eULL, 0x000fe200020006ffULL,
0x0000008623238231ULL, 0x000fe200003400ffULL, 0x00001054a61c7816ULL, 0x000fe200000000a5ULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00001054a41d7816ULL, 0x000fe200000000a3ULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000000ff7da37812ULL, 0x000fe200078ec0ffULL,
0x200000a1ff7d7230ULL, 0x000fe20000004100ULL, 0x00000010ff9f7819ULL, 0x000fc4000001169fULL,
0x00000010ffa07819ULL, 0x000fe200000116a0ULL, 0x0000001c2028723cULL, 0x000fe20000041828ULL,
0x000000a3ffa1723eULL, 0x000fe400020006ffULL, 0x00000008ff9b7819ULL, 0x000fe4000001169bULL,
0x0000009aff9a723eULL, 0x000fe400020006ffULL, 0x00000010ff1d7819ULL, 0x000fe4000001161eULL,
0x00000010ff1c7819ULL, 0x000fe2000001161fULL, 0x2000009aff9a7230ULL, 0x000fe20000004100ULL,
0x00000010ff1e7819ULL, 0x000fc400000116a2ULL, 0x00000010ff1f7819ULL, 0x000fe20000011681ULL,
0x200000a1ff817230ULL, 0x000fe20000004100ULL, 0x000010541d1e7816ULL, 0x000fe4000000001eULL,
0x000010541c1f7816ULL, 0x000fe4000000001fULL, 0x00000010ff1c7819ULL, 0x000fe4000001169dULL,
0x00000010ff1d7819ULL, 0x000fe4000001169eULL, 0x000010549f1c7816ULL, 0x000fe2000000001cULL,
0x0000001e202c723cULL, 0x000fe2000004182cULL, 0x00001054a01d7816ULL, 0x000fc4000000001dULL,
0x000000ff9ca17812ULL, 0x000fe400078ec0ffULL, 0x00000097ff97723eULL, 0x000fe400020006ffULL,
0x00000010ff1f7819ULL, 0x000fe20000011648ULL, 0x0000001c2030723cULL, 0x000fe20000041830ULL,
0x00000010ff1e7819ULL, 0x000fe20000011649ULL, 0x20000097ff977230ULL, 0x000fe20000004100ULL,
0x00000010ff487819ULL, 0x000fe4000001167aULL, 0x00000010ff497819ULL, 0x000fc40000011680ULL,
0x0000009bff9c723eULL, 0x000fe400020006ffULL, 0x000010541f487816ULL, 0x000fe40000000048ULL,
0x000010541e497816ULL, 0x000fe20000000049ULL, 0x2000009cff807230ULL, 0x000fe20000004100ULL,
0x000000a1ff9b723eULL, 0x000fe200020006ffULL, 0x00980000571c783bULL, 0x000e620000000200ULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x000000ff4b9c7812ULL, 0x000fe200078ec0ffULL,
0x2000009bff7a7230ULL, 0x000fe20000004100ULL, 0x00000008ff9b7819ULL, 0x000fe2000001164aULL,
0x20000096ff967230ULL, 0x000fe20000004100ULL, 0x00000010ff4b7819ULL, 0x000fe20000011698ULL,
0x000000482034723cULL, 0x000fe20000041834ULL, 0x00000010ff4a7819ULL, 0x000fc4000001169aULL,
0x00000010ff997819ULL, 0x000fe40000011699ULL, 0x00000010ff987819ULL, 0x000fe40000011697ULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00001054994a7816ULL, 0x000fe4000000004aULL,
0x00001054984b7816ULL, 0x000fe2000000004bULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000010ff957819ULL, 0x000fc40000011695ULL, 0x00000010ff987819ULL, 0x000fe4000001167fULL,
0x00000010ff487819ULL, 0x000fe20000011696ULL, 0x0000004a2038723cULL, 0x000fe20000041838ULL,
0x00000010ff497819ULL, 0x000fe40000011688ULL, 0x00000094ff94723eULL, 0x000fe400020006ffULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x0000105495487816ULL, 0x000fe20000000048ULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x0000105498497816ULL, 0x000fe20000000049ULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x00000010ff4b7819ULL, 0x000fc40000011690ULL,
0x00000010ff907819ULL, 0x000fe2000001168fULL, 0x000000871c1c8231ULL, 0x082fe200003400ffULL,
0x00000010ff4a7819ULL, 0x000fe20000011694ULL, 0x00000048203c723cULL, 0x000fe2000004183cULL,
0x00001054904b7816ULL, 0x000fe2000000004bULL, 0x000000871e1e8231ULL, 0x000fe200003400ffULL,
0x00000010ff937819ULL, 0x000fe20000011693ULL, 0x000000861d1d8231ULL, 0x080fe200003400ffULL,
0x00000010ff917819ULL, 0x000fe20000011691ULL, 0x000000861f1f8231ULL, 0x000fe200003400ffULL,
0x00000010ff927819ULL, 0x000fc40000011692ULL, 0x00000010ff907819ULL, 0x000fe4000001168dULL,
0x00000010ff497819ULL, 0x000fe4000001168eULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00001054934a7816ULL, 0x000fe2000000004aULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x0000105491487816ULL, 0x000fe20000000092ULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x0000105490497816ULL, 0x000fc40000000049ULL,
0x00000008ff7c7819ULL, 0x000fe2000001167cULL, 0x0000004a2040723cULL, 0x040fe20000041840ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff897819ULL, 0x000fe20000011689ULL,
0x000000482024723cULL, 0x000fe20000041824ULL, 0x00000010ff827819ULL, 0x000fc40000011682ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000010ff217819ULL, 0x000fe40000011684ULL, 0x00000010ff207819ULL, 0x000fe20000011685ULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x000010548b4a7816ULL, 0x000fc4000000008cULL, 0x00001054894b7816ULL, 0x000fe2000000008aULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x0000105421207816ULL, 0x000fe40000000020ULL,
0x0000105482217816ULL, 0x000fe40000000083ULL, 0x00000008ff787819ULL, 0x000fe20000011678ULL,
0x0000004a1c28723cULL, 0x000fe20000041828ULL, 0x00000010ff227819ULL, 0x000fe4000001167eULL,
0x00000010ff237819ULL, 0x000fc4000001167bULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff4a7819ULL, 0x000fe20000011681ULL, 0x000000201c2c723cULL, 0x000fe2000004182cULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x0000009cff9c723eULL, 0x000fe400020006ffULL, 0x00000010ff207819ULL, 0x000fc4000001167cULL,
0x00000010ff217819ULL, 0x000fe20000011680ULL, 0x2000009cff887230ULL, 0x000fe20000004100ULL,
0x0000009bff9b723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x000010547d227816ULL, 0x000fe20000000022ULL, 0x2000009bff7f7230ULL, 0x000fe20000004100ULL,
0x000010544a237816ULL, 0x000fe20000000023ULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x0000105477207816ULL, 0x000fc40000000020ULL, 0x0000105476217816ULL, 0x000fe40000000021ULL,
0x000000ff79797812ULL, 0x000fe200078ec0ffULL, 0x000000221c30723cULL, 0x040fe20000041830ULL,
0x000000ff75757812ULL, 0x000fe400078ec0ffULL, 0x00000008ff747819ULL, 0x000fe40000011674ULL,
0x00000008ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff227819ULL, 0x000fe20000011673ULL,
0x000000201c34723cULL, 0x000fe20000041834ULL, 0x00000010ff237819ULL, 0x000fc4000001167aULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff497819ULL, 0x000fe40000011688ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff207819ULL, 0x000fe4000001167fULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff217819ULL, 0x000fc40000011678ULL,
0x00000079ff48723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x0000105423227816ULL, 0x000fe20000000022ULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x0000105449237816ULL, 0x000fc40000000072ULL, 0x0000105471207816ULL, 0x000fe20000000020ULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x0000105470217816ULL, 0x000fe40000000021ULL,
0x00000010ff4e7819ULL, 0x000fe2000001164eULL, 0x000000221c38723cULL, 0x000fe20000041838ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff4d7819ULL, 0x000fe4000001164dULL,
0x00000010ff4c7819ULL, 0x000fc4000001164cULL, 0x00000010ff227819ULL, 0x000fe2000001164fULL,
0x000000201c3c723cULL, 0x000fe2000004183cULL, 0x00000010ff237819ULL, 0x000fc80000011648ULL,
0x0000105423227816ULL, 0x000fe40000000022ULL, 0x00000010ff207819ULL, 0x000fe40000011674ULL,
0x00000010ff217819ULL, 0x000fe4000001166fULL, 0x0000105475237816ULL, 0x000fe4000000004eULL,
0x000010544d207816ULL, 0x000fe40000000020ULL, 0x000010544c217816ULL, 0x000fc60000000021ULL,
0x000000221c40723cULL, 0x040ff00000041840ULL, 0x000000201c24723cULL, 0x000fee0000041824ULL,
0x0000f620141c7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x0000200006ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000041a1d7824ULL, 0x000fe200078e0214ULL, 0x000000ff6cff7812ULL, 0x000fe2000784c0ffULL,
0x000000001cff7f8cULL, 0x0005e2000c80043fULL, 0x0000000103ff7812ULL, 0x000fc4000782c0ffULL,
0x000000801d1d7811ULL, 0x000fe400078e30ffULL, 0x00000001ff737807ULL, 0x000fe40001000000ULL,
0x000000161d00720cULL, 0x000fe40003f46070ULL, 0x000000ff55ff7812ULL, 0x000fe4000780c0ffULL,
0x0000006c73717207ULL, 0x000fe40004800000ULL, 0x00000001ff6f7807ULL, 0x000fc40004000000ULL,
0x0000000103707812ULL, 0x000fca00078ec0ffULL, 0x000047b000002947ULL, 0x000fea0003800000ULL,
0x0000240006127984ULL, 0x004ea20000000800ULL, 0x00000001ff1c7807ULL, 0x000fca0004000000ULL,
0x800000001c0d7824ULL, 0x000fca00078e00ffULL, 0x8000000012ff7812ULL, 0x004fe2000784480dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000002947ULL, 0x000fea0003800000ULL,
0x0000240006127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x004fe4000784480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x800000001c1d7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL,
0x0000000d00127305ULL, 0x0004e4000021f000ULL, 0x3fa000000d0d7823ULL, 0x004fe200000100ffULL,
0x000000120000735dULL, 0x008fe40003800000ULL, 0x0000240006127984ULL, 0x000ea40000000800ULL,
0x8000000012ff7812ULL, 0x004fc4000784481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000016d6d7824ULL, 0x000fca00078e026eULL,
0x000000036d0d7812ULL, 0x000fc800078ec0ffULL, 0x000000030d00780cULL, 0x000fe40003f45270ULL,
0x00000001ff0d7819ULL, 0x000fe40000011618ULL, 0x00000001116e7807ULL, 0x000fc60005000000ULL,
0x000000200d1f7824ULL, 0x000fe400078e0268ULL, 0x000000016d127824ULL, 0x000fc600078e026eULL,
0x000000c01f1f7810ULL, 0x000fe40007ffe0ffULL, 0x000000171200720cULL, 0x000fe40003f46070ULL,
0x000000200a1c7812ULL, 0x000fca00078ef81fULL, 0x0000000910217224ULL, 0x020fe400078e021cULL,
0xffffffffff107424ULL, 0x000fc800078e00ffULL, 0x00000001051da824ULL, 0x000fe400078e0212ULL,
0x00000004ff1ea424ULL, 0x000fe200078e00ffULL, 0x000000011a207810ULL, 0x000fc60007ffe0ffULL,
0x000060001d1ca625ULL, 0x000fe200078e001eULL, 0x0000001f161e7217ULL, 0x000fc80007800000ULL,
0x000000081c10a981ULL, 0x000562000c1e1900ULL, 0x000000011e1e7824ULL, 0x000fe200078e0a1fULL,
0x000000152000720cULL, 0x000fe20003f46070ULL, 0x00000080ff4a7424ULL, 0x000fe200078e00ffULL,
0x0000001013237812ULL, 0x000fe200078ec0ffULL, 0x00000001541f7824ULL, 0x100fe200078e0221ULL,
0x000000201e1e7807ULL, 0x000fe20001000000ULL, 0x0000000152227824ULL, 0x000fe200078e0221ULL,
0x00000003ff497819ULL, 0x000fe4000001160fULL, 0x0000001e23207217ULL, 0x000fe20007800000ULL,
0x00005e001f1e7625ULL, 0x000fe200078e004aULL, 0x00000004494b7810ULL, 0x000fc60007ffe0ffULL,
0x00005e00221c7625ULL, 0x004fe200078e004aULL, 0x000000191e1e7210ULL, 0x000fc60007f5e0ffULL,
0x0000000150227824ULL, 0x100fe200078e0221ULL, 0x000000191c1c7210ULL, 0x000fe20007f7e0ffULL,
0x0000000146217824ULL, 0x000fe400078e0221ULL, 0x0000000120487824ULL, 0x000fe400078e0a23ULL,
0x00005e0022227625ULL, 0x000fc800078e004aULL, 0x00005e0021207625ULL, 0x000fe200078e004aULL,
0x0000001922227210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e061fULL,
0x000000484b00720cULL, 0x080fe20003f46070ULL, 0x000000ffff1d7224ULL, 0x000fe200018e061dULL,
0x0000001920207210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff237224ULL, 0x000fe200020e0623ULL,
0x00000008494b7810ULL, 0x040fe40007ffe0ffULL, 0x000000484900720cULL, 0x0c0fe20003f66070ULL,
0x000000ffff217224ULL, 0x000fe200028e0621ULL, 0x0000000c49497810ULL, 0x000fe40007ffe0ffULL,
0x000000484b00720cULL, 0x000fc40003f86070ULL, 0x000000484900720cULL, 0x000fce0003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e667faeULL, 0x0005e8000d901c48ULL,
0x000000001c657faeULL, 0x0005e8000d101c48ULL, 0x0000000022647faeULL, 0x0005e8000e101c48ULL,
0x0000000020637faeULL, 0x0005e8000e901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000406ff1d7984ULL, 0x004ea20008000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f62c00021e7984ULL, 0x000ee20000000800ULL, 0x0000006c736c7207ULL, 0x000fe20004800000ULL,
0x800000001b1f7824ULL, 0x000fc600078e00ffULL, 0x0000ffff6c1c7812ULL, 0x000fc800078ec0ffULL,
0x000088801c237816ULL, 0x000fca00000000ffULL, 0x80000000231c7824ULL, 0x000fca00078e00ffULL,
0x800000001dff7812ULL, 0x004fe4000784481cULL, 0x800000001eff7812ULL, 0x008fe2000786481fULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000b000003947ULL, 0x000fea0003800000ULL,
0x0000000418027824ULL, 0x000fe400078e00ffULL, 0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL,
0x800000001b1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff002027812ULL, 0x000fe400078ec0ffULL,
0x0000001c001d7305ULL, 0x0004e4000021f000ULL, 0x3fa000001c1c7823ULL, 0x004fe200000100ffULL,
0x0000001d0000735dULL, 0x008fe40003800000ULL, 0x00f62c00021d7984ULL, 0x000ea40000000800ULL,
0x800000001dff7812ULL, 0x004fc4000786481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000b947ULL, 0x000fea000383ffffULL, 0x00000020181c7824ULL, 0x000fe400078e00ffULL,
0x00000001ff487424ULL, 0x000fc600078e00ffULL, 0xffffff801c1c7812ULL, 0x000fc800078ec0ffULL,
0x00000100191d7810ULL, 0x000fca0007ffe01cULL, 0x00000001441d7824ULL, 0x000fca00078e021dULL,
0x00f000001d1f7984ULL, 0x000ea80000000800ULL, 0x00f200001d1c7984ULL, 0x0007220000000800ULL,
0x000000081f00720bULL, 0x004fda0003f7d000ULL, 0x00000000001e7806ULL, 0x000fc800018e0100ULL,
0x0000ffff1e227812ULL, 0x000fda000786c0ffULL, 0x000003700000b947ULL, 0x000fea0003800000ULL,
0x000000081f00720bULL, 0x018fe40003f74000ULL, 0x0000001f08207209ULL, 0x000fe40007810000ULL,
0x00000002ff487819ULL, 0x000fc6000001160fULL, 0x80000020081d7221ULL, 0x040fe20000010000ULL,
0x0000001f08087209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b1d217820ULL, 0x000fe20000410000ULL,
0x00000002141d7810ULL, 0x000fe40007ffe0ffULL, 0x00000000001e7806ULL, 0x000fe400018e0100ULL,
0x000000181d00720cULL, 0x000fe20003f65270ULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0x0000ffff1e497812ULL, 0x000fc800078e3cffULL, 0x0000004922ff7212ULL, 0x000fce000788c0ffULL,
0x000000801849b824ULL, 0x000fc800078e0219ULL, 0x000000014449b824ULL, 0x000fe200078e0249ULL,
0x00001f48211d7589ULL, 0x0044e200000e0000ULL, 0x800000201f224221ULL, 0x000fe20000010000ULL,
0x0000002107077220ULL, 0x000fe40000410000ULL, 0x00001f56211e7589ULL, 0x000f2200000e0000ULL,
0x3fb8aa3b22224820ULL, 0x000fc60000410000ULL, 0x00f400204900b388ULL, 0x0003e20000000800ULL,
0x0000002200004308ULL, 0x000e620000000800ULL, 0x00000001ff487807ULL, 0x004fe20002000000ULL,
0x0000001d28287220ULL, 0x088fe20000410000ULL, 0x0000001d29297220ULL, 0x080fe20000410000ULL,
0x0000001d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001d30307220ULL, 0x080fe20000410000ULL, 0x0000001d31317220ULL, 0x080fe20000410000ULL,
0x0000001d34347220ULL, 0x080fe20000410000ULL, 0x0000001d35357220ULL, 0x080fe20000410000ULL,
0x0000001d38387220ULL, 0x080fe20000410000ULL, 0x0000001d39397220ULL, 0x080fe20000410000ULL,
0x0000001d3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001d3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001d40407220ULL, 0x080fe20000410000ULL, 0x0000001d41417220ULL, 0x080fe20000410000ULL,
0x0000001d24247220ULL, 0x080fe20000410000ULL, 0x0000001d25257220ULL, 0x000fe20000410000ULL,
0x0000001e2a2a7220ULL, 0x090fe20000410000ULL, 0x0000001e2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001e2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001e2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001e32327220ULL, 0x080fe20000410000ULL, 0x0000001e33337220ULL, 0x080fe20000410000ULL,
0x0000001e36367220ULL, 0x080fe20000410000ULL, 0x0000001e37377220ULL, 0x080fe20000410000ULL,
0x0000001e3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001e3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001e3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001e3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001e42427220ULL, 0x080fe20000410000ULL, 0x0000001e43437220ULL, 0x080fe20000410000ULL,
0x0000001e26267220ULL, 0x080fe20000410000ULL, 0x0000001e27277220ULL, 0x000fe20000410000ULL,
0x0000001c001c4220ULL, 0x002fc80000410000ULL, 0x000000071c077221ULL, 0x018fe20000010000ULL,
0x000000f000002947ULL, 0x000fea0003800000ULL, 0x00000008621c7824ULL, 0x000fe400078e025bULL,
0x80000000231d7824ULL, 0x000fc800078e00ffULL, 0x00f64c001c1c7984ULL, 0x000ea40000000800ULL,
0x800000001cff7812ULL, 0x004fe4000784481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x80000000231e7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL, 0x0000001c001d7305ULL, 0x0004e4000021f000ULL,
0x3fa000001c1c7823ULL, 0x004fe200000100ffULL, 0x0000001d0000735dULL, 0x008fe40003800000ULL,
0x00000406ff1d7984ULL, 0x000ea40008000800ULL, 0x800000001dff7812ULL, 0x004fc4000784481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00001000181c7824ULL, 0x000fe200078e00ffULL, 0x00009910484d7816ULL, 0x000fe200000000ffULL,
0x00001000034a7824ULL, 0x000fe200078e00ffULL, 0x00000000ff95723eULL, 0x000fe400000010ffULL,
0xffffe0001c1d7812ULL, 0x000fe400078ec0ffULL, 0x000010004a4a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4d00720cULL, 0x000fe20003f45270ULL, 0x00001000621c7824ULL, 0x000fe200078e021dULL,
0x0000b0000b4c7810ULL, 0x000fc40007ffe04aULL, 0x0000541095957816ULL, 0x000fe40000000095ULL,
0x0000b0001c217810ULL, 0x000fe20007ffe0ffULL, 0x0000001059497824ULL, 0x100fe200078e024cULL,
0x00000002ffa07819ULL, 0x000fe2000001160fULL, 0x00000010584c7824ULL, 0x000fe400078e024cULL,
0x000000106a1c7824ULL, 0x100fe400078e0221ULL, 0x000000105a217824ULL, 0x000fe200078e0221ULL,
0x000000004948783bULL, 0x000ea80000004200ULL, 0x000000004c4c783bULL, 0x000ee80000004200ULL,
0x000000001c1c783bULL, 0x000f280000004200ULL, 0x000000002120783bULL, 0x000e620000004200ULL,
0x000000ff48797812ULL, 0x004fc400078ec0ffULL, 0x00000010ff827819ULL, 0x100fe40000011649ULL,
0x000000ff497c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7a7819ULL, 0x000fe40000011649ULL,
0x0000ffff497b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff667819ULL, 0x008fe4000001164dULL,
0x000000ff4d647812ULL, 0x000fc400078ec0ffULL, 0x00000018ff497819ULL, 0x000fe4000001164dULL,
0x0000ffff4d747812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e4d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8d7819ULL, 0x110fe4000001161fULL, 0x000000ff1f937812ULL, 0x000fe400078ec0ffULL,
0x00000018ff927819ULL, 0x000fc4000001161fULL, 0x0000ffff1f947812ULL, 0x000fe400078ec0ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000010ff8f7819ULL, 0x100fe4000001161dULL,
0x000000ff1d967812ULL, 0x040fe200078ec0ffULL, 0x20000079ff837230ULL, 0x000fe20000004100ULL,
0x00000018ff897819ULL, 0x000fe4000001161dULL, 0x0000ffff1d7f7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8e7819ULL, 0x102fe40000011621ULL, 0x000000ff21867812ULL, 0x040fe400078ec0ffULL,
0x00000018ff877819ULL, 0x000fe40000011621ULL, 0x0000ffff211f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff637819ULL, 0x000fe4000001161cULL, 0x000000ff1c977812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001161cULL, 0x0000ffff1c7e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1d7819ULL, 0x100fe4000001161eULL, 0x000000ff1e8a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8b7819ULL, 0x000fe4000001161eULL, 0x0000ffff1e8c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff727819ULL, 0x100fe4000001164aULL, 0x000000ff4a987812ULL, 0x040fe400078ec0ffULL,
0x00000018ff707819ULL, 0x000fe4000001164aULL, 0x0000ffff4a217812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1c7819ULL, 0x000fe40000011620ULL, 0x000000ff20857812ULL, 0x000fc400078ec0ffULL,
0x00000018ff847819ULL, 0x000fe40000011620ULL, 0x0000ffff201e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff917819ULL, 0x100fe40000011623ULL, 0x000000ff237d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff787819ULL, 0x000fe40000011623ULL, 0x0000ffff23597812ULL, 0x000fc400078ec0ffULL,
0x00000010ff817819ULL, 0x100fe40000011648ULL, 0x00000018ff777819ULL, 0x000fe40000011648ULL,
0x0000ffff48717812ULL, 0x000fe400078ec0ffULL, 0x000000ff4f4a7812ULL, 0x000fe400078ec0ffULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000018ff657819ULL, 0x000fc4000001164bULL,
0x00000010ff237819ULL, 0x100fe4000001164cULL, 0x000000ff4c6f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff487819ULL, 0x000fe4000001164cULL, 0x0000ffff4c207812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001164fULL, 0x00000010ff907819ULL, 0x000fc40000011622ULL,
0x000000ff22887812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe40000011622ULL,
0x0000ffff22587812ULL, 0x000fe400078ec0ffULL, 0x00000098ff79723eULL, 0x000fe400020006ffULL,
0x00000010ff767819ULL, 0x000fe4000001164bULL, 0x000000ff4b997812ULL, 0x040fe200078ec0ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x0000ffff4b227812ULL, 0x000fc400078ec0ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x0000004aff98723eULL, 0x000fe200020006ffULL,
0x2000004dff4a7230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x100fe4000001164eULL,
0x00000018ff4b7819ULL, 0x000fe4000001164eULL, 0x0000ffff4e6b7812ULL, 0x000fe400078ec0ffULL,
0x0000007cff7c723eULL, 0x000fc400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x2000007cff807230ULL, 0x000fe20000004100ULL,
0x0000006fff4e723eULL, 0x000fe200020006ffULL, 0x20000070ff6f7230ULL, 0x000fe20000004100ULL,
0x0000004cff4d723eULL, 0x000fe200020006ffULL, 0x20000065ff707230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x20000077ff7c7230ULL, 0x000fe20000004100ULL,
0x00000097ff97723eULL, 0x000fe200020006ffULL, 0x2000004eff657230ULL, 0x000fe20000004100ULL,
0x0000005aff4c723eULL, 0x000fe200020006ffULL, 0x2000004dff5a7230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fc400020006ffULL, 0x00000008ff717819ULL, 0x000fe40000011671ULL,
0x000000ff72727812ULL, 0x000fe400078ec0ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000008ff217819ULL, 0x000fe40000011621ULL, 0x00000008ff227819ULL, 0x000fe40000011622ULL,
0x000000ff23237812ULL, 0x000fc400078ec0ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000099ff77723eULL, 0x000fe400020006ffULL, 0x0000004bff4e723eULL, 0x000fe200020006ffULL,
0x20000098ff4b7230ULL, 0x000fe20000004100ULL, 0x00000092ff4d723eULL, 0x000fe200020006ffULL,
0x2000008aff927230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x20000097ff987230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000085ff8a7230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000089ff977230ULL, 0x000fe20000004100ULL, 0x00000096ff99723eULL, 0x000fe200020006ffULL,
0x2000004cff967230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x20000087ff897230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x20000068ff877230ULL, 0x000fe20000004100ULL, 0x00000021ff21723eULL, 0x000fe200020006ffULL,
0x20000099ff997230ULL, 0x000fe20000004100ULL, 0x00000022ff22723eULL, 0x000fe200020006ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x000000ff66667812ULL, 0x000fe200078ec0ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000023ff23723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000008ff207819ULL, 0x000fc40000011620ULL,
0x0000008bff4c723eULL, 0x000fe200020006ffULL, 0x20000086ff8b7230ULL, 0x000fe20000004100ULL,
0x00000088ff85723eULL, 0x000fe200020006ffULL, 0x20000084ff887230ULL, 0x000fe20000004100ULL,
0x00000066ff68723eULL, 0x000fe200020006ffULL, 0x2000007dff867230ULL, 0x000fe20000004100ULL,
0x00000020ff9b723eULL, 0x000fe200020006ffULL, 0x20000078ff847230ULL, 0x000fe20000004100ULL,
0x00000008ff7e7819ULL, 0x000fe2000001167eULL, 0x20000071ff7d7230ULL, 0x000fe20000004100ULL,
0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL, 0x20000072ff787230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x20000021ff717230ULL, 0x000fe20000004100ULL,
0x00000008ff7f7819ULL, 0x000fe2000001167fULL, 0x20000022ff727230ULL, 0x000fe20000004100ULL,
0x0000008fff9e723eULL, 0x000fe200020006ffULL, 0x20000023ff667230ULL, 0x000fe20000004100ULL,
0x0000007fff9c723eULL, 0x000fe200020006ffULL, 0x00a000006720783bULL, 0x000fe20000000200ULL,
0x2000007eff8f7230ULL, 0x000fe20000004100ULL, 0x000000ff639a7812ULL, 0x000fe200078ec0ffULL,
0x2000009eff9e7230ULL, 0x000fe20000004100ULL, 0x00001fa0957f7589ULL, 0x000e6200000e0000ULL,
0x00000008ff8c7819ULL, 0x000fe2000001168cULL, 0x2000009cff9c7230ULL, 0x000fe20000004100ULL,
0x0000009aff9a723eULL, 0x000fe200020006ffULL, 0x00001f56957e7589ULL, 0x0004e200000e0000ULL,
0x000000ff1d1d7812ULL, 0x000fe200078ec0ffULL, 0x2000009bff637230ULL, 0x000fe20000004100ULL,
0x00000008ff947819ULL, 0x000fe20000011694ULL, 0x2000009aff9d7230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x0000001dff1d723eULL, 0x000fe200020006ffULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000094ff9f723eULL, 0x000fe200020006ffULL, 0x2000008cff947230ULL, 0x000fe20000004100ULL,
0x000000ff1c8c7812ULL, 0x000fe200078ec0ffULL, 0x2000001dff9a7230ULL, 0x000fe20000004100ULL,
0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL, 0x2000009fff957230ULL, 0x004fe20000004100ULL,
0x00000010ff1c7819ULL, 0x000fe20000011698ULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff1d7819ULL, 0x000fc40000011699ULL, 0x00000010ff9d7819ULL, 0x000fe4000001169dULL,
0x00000010ff9e7819ULL, 0x000fe4000001169eULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x000010549d1c7816ULL, 0x000fe4000000001cULL, 0x000010549e1d7816ULL, 0x000fe2000000001dULL,
0x2000008dff9b7230ULL, 0x000fe20000004100ULL, 0x000000ff8e8e7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff1e7819ULL, 0x000fe2000001161eULL, 0x0000007f2020a231ULL, 0x082fe200003400ffULL,
0x00000008ff1f7819ULL, 0x000fe2000001161fULL, 0x0000007f2222a231ULL, 0x000fe200003400ffULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x0000007e2121a231ULL, 0x088fe200003400ffULL,
0x0000008eff8d723eULL, 0x000fe200020006ffULL, 0x0000007e2323a231ULL, 0x000fe200003400ffULL,
0x0000001eff8e723eULL, 0x000fe200020006ffULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x0000001fff98723eULL, 0x000fe200020006ffULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x00000010ff1e7819ULL, 0x000fe2000001168fULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x0000001c2028723cULL, 0x000fe20000041828ULL, 0x00000010ff1f7819ULL, 0x000fe2000001169cULL,
0x20000098ff8f7230ULL, 0x000fe20000004100ULL, 0x00000010ff937819ULL, 0x000fc40000011693ULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000010ff1d7819ULL, 0x000fe40000011696ULL,
0x00000010ff1c7819ULL, 0x000fe20000011697ULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x000010541d1e7816ULL, 0x000fe4000000001eULL, 0x000010541c1f7816ULL, 0x000fe4000000001fULL,
0x000000ff90967812ULL, 0x000fc400078ec0ffULL, 0x00000010ff1c7819ULL, 0x000fe40000011692ULL,
0x00000010ff1d7819ULL, 0x000fe2000001169aULL, 0x0000001e202c723cULL, 0x000fe2000004182cULL,
0x00000010ff907819ULL, 0x000fe4000001169bULL, 0x000010541d1c7816ULL, 0x000fe4000000001cULL,
0x00001054901d7816ULL, 0x000fe40000000093ULL, 0x00000010ff1f7819ULL, 0x000fc4000001164cULL,
0x00000010ff1e7819ULL, 0x000fe4000001164dULL, 0x00000010ff4c7819ULL, 0x000fe20000011694ULL,
0x0000001c2030723cULL, 0x000fe20000041830ULL, 0x00000010ff4d7819ULL, 0x000fe40000011695ULL,
0x000010541f4c7816ULL, 0x000fe4000000004cULL, 0x000010541e4d7816ULL, 0x000fe4000000004dULL,
0x00a00000571c783bULL, 0x000e620000000200ULL, 0x00000008ff927819ULL, 0x000fc40000011658ULL,
0x00000008ff937819ULL, 0x000fe40000011659ULL, 0x000000ff91917812ULL, 0x000fe200078ec0ffULL,
0x0000004c2034723cULL, 0x000fe20000041834ULL, 0x00000010ff587819ULL, 0x000fe4000001168aULL,
0x00000010ff597819ULL, 0x000fe4000001168cULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff8a7819ULL, 0x000fc4000001168dULL, 0x00000010ff4d7819ULL, 0x000fe40000011688ULL,
0x00000010ff4c7819ULL, 0x000fe4000001168eULL, 0x00000010ff887819ULL, 0x000fe40000011689ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000096ff96723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fc400020006ffULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x20000096ff907230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x0000105459587816ULL, 0x000fe20000000058ULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x000010548a597816ULL, 0x000fe2000000008bULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x000010544d4c7816ULL, 0x000fe4000000004cULL,
0x00001054884d7816ULL, 0x000fc4000000008fULL, 0x00000008ff7b7819ULL, 0x000fe2000001167bULL,
0x000000582038723cULL, 0x040fe20000041838ULL, 0x000000ff76767812ULL, 0x000fe200078ec0ffULL,
0x0000007f1c1ca231ULL, 0x082fe200003400ffULL, 0x00000010ff867819ULL, 0x000fe20000011686ULL,
0x0000007f1e1ea231ULL, 0x000fe200003400ffULL, 0x00000010ff917819ULL, 0x000fe20000011691ULL,
0x0000007e1d1da231ULL, 0x080fe200003400ffULL, 0x00000010ff587819ULL, 0x000fe20000011685ULL,
0x0000004c203c723cULL, 0x000fe2000004183cULL, 0x00000010ff597819ULL, 0x000fe20000011690ULL,
0x0000007e1f1fa231ULL, 0x000fe200003400ffULL, 0x00000010ff877819ULL, 0x000fc40000011687ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff4d7819ULL, 0x000fe40000011693ULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x0000105459587816ULL, 0x000fe20000000058ULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x0000105491597816ULL, 0x000fe20000000086ULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00001054874c7816ULL, 0x000fc40000000092ULL,
0x00001054844d7816ULL, 0x000fe4000000004dULL, 0x00000010ff7a7819ULL, 0x000fe2000001167aULL,
0x000000582040723cULL, 0x040fe20000041840ULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x0000004c2024723cULL, 0x000fe20000041824ULL,
0x00000010ff6a7819ULL, 0x000fc4000001164fULL, 0x0000ffff4f4f7812ULL, 0x000fe200078ec0ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x000000ff81817812ULL, 0x000fe400078ec0ffULL,
0x00000010ff217819ULL, 0x000fe4000001167cULL, 0x00000010ff207819ULL, 0x000fe4000001167dULL,
0x00000010ff227819ULL, 0x000fe40000011679ULL, 0x00000010ff237819ULL, 0x000fc40000011678ULL,
0x0000105421207816ULL, 0x000fe40000000020ULL, 0x0000105423227816ULL, 0x000fe40000000022ULL,
0x000010547a217816ULL, 0x000fe4000000007bULL, 0x0000105476237816ULL, 0x000fe40000000077ULL,
0x000000ff82827812ULL, 0x000fe400078ec0ffULL, 0x00000008ff747819ULL, 0x000fe20000011674ULL,
0x000000201c2c723cULL, 0x000fe2000004182cULL, 0x000000ff75757812ULL, 0x000fc400078ec0ffULL,
0x000000ff6a6a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6b7819ULL, 0x000fe4000001166bULL,
0x00000008ff4f7819ULL, 0x000fe2000001164fULL, 0x000000221c30723cULL, 0x000fe20000041830ULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff207819ULL, 0x000fc40000011671ULL, 0x00000010ff217819ULL, 0x000fe40000011672ULL,
0x00000010ff227819ULL, 0x000fe40000011665ULL, 0x00000010ff237819ULL, 0x000fe40000011666ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff4d7819ULL, 0x000fe40000011668ULL,
0x00000048ff48723eULL, 0x000fc400020006ffULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x000010546f207816ULL, 0x000fe20000000020ULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x0000105470217816ULL, 0x000fe20000000021ULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x0000105423227816ULL, 0x000fc40000000022ULL, 0x000010544d237816ULL, 0x000fe40000000064ULL,
0x00000010ff857819ULL, 0x000fe20000011680ULL, 0x000000201c34723cULL, 0x040fe20000041834ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff807819ULL, 0x000fe40000011681ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff217819ULL, 0x000fe20000011648ULL,
0x000000221c38723cULL, 0x000fe20000041838ULL, 0x00000010ff207819ULL, 0x000fc40000011663ULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff227819ULL, 0x000fe4000001164aULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff237819ULL, 0x000fe4000001164bULL, 0x00000010ff6a7819ULL, 0x000fc4000001166aULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x0000105421207816ULL, 0x000fe40000000020ULL, 0x0000105480587816ULL, 0x000fc40000000083ULL,
0x0000105482597816ULL, 0x000fe40000000085ULL, 0x0000105449217816ULL, 0x000fe40000000074ULL,
0x0000105475227816ULL, 0x000fe40000000022ULL, 0x000010546a237816ULL, 0x000fe20000000023ULL,
0x000000581c28723cULL, 0x000fe20000041828ULL, 0x000010544e4e7816ULL, 0x000fe4000000006bULL,
0x000010545a4f7816ULL, 0x000fca000000004fULL, 0x000000201c3c723cULL, 0x040ff0000004183cULL,
0x000000221c40723cULL, 0x040ff00000041840ULL, 0x0000004e1c24723cULL, 0x000fee0000041824ULL,
0x0000f630141c7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x0000200006ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000040141d7824ULL, 0x000fe200078e025dULL, 0x000000ff6cff7812ULL, 0x000fe2000784c0ffULL,
0x000000001cff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff55ff7812ULL, 0x000fc4000786c0ffULL,
0x000000c01d1d7810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff487807ULL, 0x000fe40001000000ULL,
0x000000161d00720cULL, 0x000fe40003f46070ULL, 0x00000001ff6f7807ULL, 0x000fe40001800000ULL,
0x0000004873717207ULL, 0x000fe40004800000ULL, 0x0000000103707812ULL, 0x000fce00078e0cffULL,
0x0000238000002947ULL, 0x000fea0003800000ULL, 0x0000240006127984ULL, 0x004ea20000000800ULL,
0x80000000691d7824ULL, 0x000fca00078e00ffULL, 0x8000000012ff7812ULL, 0x004fe2000784481dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000002947ULL, 0x000fea0003800000ULL,
0x0000240006127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x004fe4000784481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000069697824ULL, 0x000fe400078e00ffULL, 0x3e000000ff127424ULL, 0x000fc800078e00ffULL,
0x00000012001c7305ULL, 0x0004e4000021f000ULL, 0x3fa0000012127823ULL, 0x004fe200000100ffULL,
0x0000001c0000735dULL, 0x008fe40003800000ULL, 0x00002400061c7984ULL, 0x000ea40000000800ULL,
0x800000001cff7812ULL, 0x004fc40007844869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000016d6d7824ULL, 0x000fe200078e026eULL,
0x000003001a1f7a10ULL, 0x000fc80007ffe0ffULL, 0x000000036d127812ULL, 0x000fe200078ec0ffULL,
0x000001001f217824ULL, 0x000fc600078e020cULL, 0x000000031200780cULL, 0x000fe40003f45270ULL,
0x000000200a1c7812ULL, 0x000fe400078ef821ULL, 0x0000000111127807ULL, 0x000fc60005000000ULL,
0x0000000910237224ULL, 0x020fe400078e021cULL, 0x000000016d127824ULL, 0x000fe200078e0212ULL,
0x0000002116207217ULL, 0x000fe20007800000ULL, 0xffffffffff107424ULL, 0x000fc600078e00ffULL,
0x000000171200720cULL, 0x000fe20003f46070ULL, 0x0000000120207824ULL, 0x000fe400078e0a21ULL,
0x00000080ff4c7424ULL, 0x000fd400078e00ffULL, 0x00000001051da824ULL, 0x000fe400078e0212ULL,
0x00000004ff1ea424ULL, 0x000fc800078e00ffULL, 0x000060001d1ca625ULL, 0x000fe200078e001eULL,
0x000000011f1e7810ULL, 0x000fc60007ffe0ffULL, 0x0000000154547824ULL, 0x100fe200078e0223ULL,
0x000000081c10a981ULL, 0x000562000c1e1900ULL, 0x000000151e00720cULL, 0x000fe20003f46070ULL,
0x00000001521e7824ULL, 0x100fe200078e0223ULL, 0x00000010134a7812ULL, 0x000fe200078ec0ffULL,
0x0000000150217824ULL, 0x100fe200078e0223ULL, 0x0000002020207807ULL, 0x000fe20001000000ULL,
0x0000000146497824ULL, 0x000fe200078e0223ULL, 0x00000003ff4b7819ULL, 0x000fe2000001160fULL,
0x00005e001e1e7625ULL, 0x000fe200078e004cULL, 0x000000204a237217ULL, 0x000fc40007800000ULL,
0x000000044b4d7810ULL, 0x000fe20007ffe0ffULL, 0x00005e00541c7625ULL, 0x004fe200078e004cULL,
0x000000191e1e7210ULL, 0x000fc60007f7e0ffULL, 0x0000000123467824ULL, 0x000fe200078e0a4aULL,
0x000000191c227210ULL, 0x000fe20007f5e0ffULL, 0x00005e0021207625ULL, 0x000fc800078e004cULL,
0x000000ffff237224ULL, 0x000fe200010e061dULL, 0x0000001920207210ULL, 0x080fe20007f9e0ffULL,
0x00005e00491c7625ULL, 0x000fe200078e004cULL, 0x000000464d00720cULL, 0x080fe40003f46070ULL,
0x000000084b4d7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200018e061fULL,
0x000000191c1c7210ULL, 0x000fe20007fbe0ffULL, 0x0000100062497824ULL, 0x000fe200078e020bULL,
0x000000464b00720cULL, 0x0c0fe20003f66070ULL, 0x000000ffff217224ULL, 0x000fe200020e0621ULL,
0x0000000c4b4b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e061dULL,
0x000000464d00720cULL, 0x000fc40003f86070ULL, 0x0000b000494a7810ULL, 0x000fe40007ffe0ffULL,
0x000000464b00720cULL, 0x000fc60003fa6070ULL, 0x0000001053537824ULL, 0x100fe400078e024aULL,
0x0000001051517824ULL, 0x100fe400078e024aULL, 0x0000001047477824ULL, 0x100fe200078e024aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022537faeULL, 0x0005e2000d901c48ULL,
0x0000001045457824ULL, 0x000fc600078e024aULL, 0x000000001e517faeULL, 0x0005e8000d101c48ULL,
0x0000000020477faeULL, 0x0005e8000e101c48ULL, 0x000000001c457faeULL, 0x0005e8000e901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a06ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000040061617984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f63c00021d7984ULL, 0x004ea20000000800ULL,
0x0000004873737207ULL, 0x000fe20004800000ULL, 0x800000001b1e7824ULL, 0x000fc600078e00ffULL,
0x0000ffff731f7812ULL, 0x000fca00078ec0ffULL, 0x800000001f1c7824ULL, 0x000fca00078e00ffULL,
0x8000000061ff7812ULL, 0x008fe4000784481cULL, 0x800000001dff7812ULL, 0x004fe2000786481eULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000003947ULL, 0x000fea0003800000ULL,
0x800000001b1d7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff1b7424ULL, 0x000fc800078e00ffULL,
0x0000001b001c7305ULL, 0x0004e4000021f000ULL, 0x3fa000001b1b7823ULL, 0x004fe200000100ffULL,
0x0000001c0000735dULL, 0x008fe40003800000ULL, 0x00f63c00021c7984ULL, 0x000ea40000000800ULL,
0x800000001cff7812ULL, 0x004fc4000786481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000b947ULL, 0x000fea000383ffffULL, 0x00000020181b7824ULL, 0x000fe400078e00ffULL,
0x00000001ff497424ULL, 0x000fc600078e00ffULL, 0xffffff801b1c7812ULL, 0x000fc800078ec0ffULL,
0x00000180191b7810ULL, 0x000fca0007ffe01cULL, 0x00000001441b7824ULL, 0x000fca00078e021bULL,
0x00f000001b1d7984ULL, 0x000ea80000000800ULL, 0x00f200001b1c7984ULL, 0x0007220000000800ULL,
0x000000081d00720bULL, 0x004fda0003f7d000ULL, 0x00000000001e7806ULL, 0x000fc800018e0100ULL,
0x0000ffff1e207812ULL, 0x000fda000786c0ffULL, 0x000003700000b947ULL, 0x000fea0003800000ULL,
0x000000081d00720bULL, 0x018fe40003f74000ULL, 0x0000001d08227209ULL, 0x000fe40007810000ULL,
0x00000002ff237819ULL, 0x000fc6000001160fULL, 0x80000022081b7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b1b1e7820ULL, 0x000fe20000410000ULL, 0x00000003141b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000000087806ULL, 0x000fe400018e0100ULL, 0x000000181b00720cULL, 0x000fe20003f65270ULL,
0x0000001e001e7308ULL, 0x000ea20000000800ULL, 0x0000ffff08217812ULL, 0x000fc800078e3cffULL,
0x0000002120ff7212ULL, 0x000fc8000788c0ffULL, 0x00000001ff497807ULL, 0x000fc60002000000ULL,
0x000000801819b824ULL, 0x000fe200078e0219ULL, 0x00001f231e087589ULL, 0x004ea600000e0000ULL,
0x00000001441bb824ULL, 0x000fe400078e0219ULL, 0x800000221d1d4221ULL, 0x000fe20000010000ULL,
0x0000001e07077220ULL, 0x000fe20000410000ULL, 0x00001f561e197589ULL, 0x000ee400000e0000ULL,
0x3fb8aa3b1d1d4820ULL, 0x000fc40000410000ULL, 0x00f400221b00b388ULL, 0x0009e40000000800ULL,
0x0000001d00004308ULL, 0x000e620000000800ULL, 0x0000000828287220ULL, 0x084fe20000410000ULL,
0x0000000829297220ULL, 0x080fe20000410000ULL, 0x000000082c2c7220ULL, 0x080fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x0000000830307220ULL, 0x080fe20000410000ULL,
0x0000000831317220ULL, 0x080fe20000410000ULL, 0x0000000834347220ULL, 0x080fe20000410000ULL,
0x0000000835357220ULL, 0x080fe20000410000ULL, 0x0000000838387220ULL, 0x080fe20000410000ULL,
0x0000000839397220ULL, 0x080fe20000410000ULL, 0x000000083c3c7220ULL, 0x080fe20000410000ULL,
0x000000083d3d7220ULL, 0x080fe20000410000ULL, 0x0000000840407220ULL, 0x080fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x0000000824247220ULL, 0x080fe20000410000ULL,
0x0000000825257220ULL, 0x000fe20000410000ULL, 0x000000192a2a7220ULL, 0x088fe20000410000ULL,
0x000000192b2b7220ULL, 0x080fe20000410000ULL, 0x000000192e2e7220ULL, 0x080fe20000410000ULL,
0x000000192f2f7220ULL, 0x080fe20000410000ULL, 0x0000001932327220ULL, 0x080fe20000410000ULL,
0x0000001933337220ULL, 0x080fe20000410000ULL, 0x0000001936367220ULL, 0x080fe20000410000ULL,
0x0000001937377220ULL, 0x080fe20000410000ULL, 0x000000193a3a7220ULL, 0x080fe20000410000ULL,
0x000000193b3b7220ULL, 0x080fe20000410000ULL, 0x000000193e3e7220ULL, 0x080fe20000410000ULL,
0x000000193f3f7220ULL, 0x080fe20000410000ULL, 0x0000001942427220ULL, 0x080fe20000410000ULL,
0x0000001943437220ULL, 0x080fe20000410000ULL, 0x0000001926267220ULL, 0x080fe20000410000ULL,
0x0000001927277220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fe200078e0022ULL,
0x0000001c001c4220ULL, 0x002fc80000410000ULL, 0x000000071c077221ULL, 0x018fe20000010000ULL,
0x0000011000002947ULL, 0x000fea0003800000ULL, 0x0000000862627824ULL, 0x000fe400078e00ffULL,
0x800000001f1c7824ULL, 0x000fc600078e00ffULL, 0x0000000862627812ULL, 0x000fca00078e3cffULL,
0x000000015b627824ULL, 0x000fca00078e0262ULL, 0x00f64c0062197984ULL, 0x000ea40000000800ULL,
0x8000000019ff7812ULL, 0x004fe4000784481cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x800000001f1c7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff197424ULL, 0x000fc800078e00ffULL, 0x00000019001b7305ULL, 0x0004e4000021f000ULL,
0x3fa0000019197823ULL, 0x004fe200000100ffULL, 0x0000001b0000735dULL, 0x008fe40003800000ULL,
0x00f64c00621b7984ULL, 0x000ea40000000800ULL, 0x800000001bff7812ULL, 0x004fc4000784481cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000006060783bULL, 0x000ea20000004200ULL, 0x0000991049497816ULL, 0x000fc600000000ffULL,
0x000000005f1c783bULL, 0x000ee80000004200ULL, 0x000000005e20783bULL, 0x0008680000004200ULL,
0x000000005c44783bULL, 0x000e620000004200ULL, 0x00000000ff5e723eULL, 0x010fe400000010ffULL,
0x00000010ff817819ULL, 0x004fc40000011663ULL, 0x000000ff63837812ULL, 0x040fe400078ec0ffULL,
0x00000018ff827819ULL, 0x000fe40000011663ULL, 0x0000ffff63747812ULL, 0x000fe400078ec0ffULL,
0x00000010ff807819ULL, 0x100fe40000011662ULL, 0x000000ff627a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff797819ULL, 0x000fc40000011662ULL, 0x0000ffff62727812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7d7819ULL, 0x108fe4000001161dULL, 0x000000ff1d877812ULL, 0x040fe400078ec0ffULL,
0x00000018ff867819ULL, 0x000fe4000001161dULL, 0x0000ffff1d6f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6e7819ULL, 0x000fc4000001161eULL, 0x000000ff1e887812ULL, 0x040fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fe4000001161eULL, 0x0000ffff1e657812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5d7819ULL, 0x102fe40000011620ULL, 0x000000ff20627812ULL, 0x000fe400078ec0ffULL,
0x00000018ff557819ULL, 0x000fc40000011620ULL, 0x0000ffff201e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1d7819ULL, 0x100fe40000011623ULL, 0x000000ff23507812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4f7819ULL, 0x000fe40000011623ULL, 0x0000ffff23787812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1b7819ULL, 0x000fc40000011646ULL, 0x000000ff46237812ULL, 0x040fe400078ec0ffULL,
0x00000018ff207819ULL, 0x000fe40000011646ULL, 0x0000ffff464a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff60697812ULL, 0x000fe400078ec0ffULL, 0x000054105e467816ULL, 0x000fe4000000005eULL,
0x00000010ff587819ULL, 0x000fc40000011660ULL, 0x00000018ff687819ULL, 0x000fe40000011660ULL,
0x0000ffff607e7812ULL, 0x000fe400078ec0ffULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x00001f5646607589ULL, 0x0003e200000e0000ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000018ff4c7819ULL, 0x000fe20000011621ULL, 0x20000069ff7c7230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x20000063ff697230ULL, 0x000fe20000004100ULL,
0x00000018ff5a7819ULL, 0x000fc4000001161fULL, 0x00000018ff4d7819ULL, 0x000fe40000011622ULL,
0x00000062ff56723eULL, 0x002fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x000000ff45547812ULL, 0x000fe200078ec0ffULL, 0x20000056ff637230ULL, 0x000fe20000004100ULL,
0x0000004cff56723eULL, 0x000fe200020006ffULL, 0x20000055ff4c7230ULL, 0x000fe20000004100ULL,
0x00000050ff55723eULL, 0x000fe200020006ffULL, 0x2000005aff627230ULL, 0x000fe20000004100ULL,
0x0000004dff50723eULL, 0x000fe200020006ffULL, 0x20000056ff4d7230ULL, 0x000fe20000004100ULL,
0x000000ff44517812ULL, 0x000fc400078ec0ffULL, 0x0000004fff56723eULL, 0x000fe200020006ffULL,
0x20000055ff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x100fe2000001161cULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x000000ff1c857812ULL, 0x040fe400078ec0ffULL,
0x00000018ff847819ULL, 0x000fe4000001161cULL, 0x0000ffff1c767812ULL, 0x000fe400078ec0ffULL,
0x00000018ff537819ULL, 0x000fc40000011645ULL, 0x00000054ff5a723eULL, 0x000fe400020006ffULL,
0x00000010ff5b7819ULL, 0x000fe40000011622ULL, 0x000000ff224e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff221c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff47227812ULL, 0x000fe400078ec0ffULL,
0x00000051ff55723eULL, 0x000fe200020006ffULL, 0x20000056ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff597819ULL, 0x000fc40000011661ULL, 0x00000053ff56723eULL, 0x000fe200020006ffULL,
0x2000005aff537230ULL, 0x000fe20000004100ULL, 0x00000010ff6a7819ULL, 0x000fe4000001161fULL,
0x000000ff1f667812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1f6d7812ULL, 0x000fe400078ec0ffULL,
0x00000022ff5a723eULL, 0x000fe400020006ffULL, 0x00000010ff1f7819ULL, 0x000fc40000011621ULL,
0x000000ff21647812ULL, 0x040fe400078ec0ffULL, 0x0000ffff215c7812ULL, 0x000fe400078ec0ffULL,
0x00000020ff22723eULL, 0x000fe400020006ffULL, 0x00000018ff217819ULL, 0x000fe40000011647ULL,
0x000000ff59207812ULL, 0x000fe200078ec0ffULL, 0x20000022ff597230ULL, 0x000fe20000004100ULL,
0x0000ffff617f7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011661ULL,
0x00000010ff777819ULL, 0x100fe40000011644ULL, 0x00000018ff527819ULL, 0x000fe40000011644ULL,
0x0000ffff44707812ULL, 0x000fe200078ec0ffULL, 0x000000ffff447224ULL, 0x000fe200078e0049ULL,
0x000000ff58587812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7e7819ULL, 0x000fc4000001167eULL,
0x00000021ff21723eULL, 0x000fe400020006ffULL, 0x00000020ff20723eULL, 0x000fe400020006ffULL,
0x00000008ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff717819ULL, 0x000fe40000011645ULL,
0x0000ffff45197812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7f7819ULL, 0x000fc4000001167fULL,
0x000000ff75757812ULL, 0x000fe400078ec0ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000082ff45723eULL, 0x000fe400020006ffULL, 0x000000ff81817812ULL, 0x000fe400078ec0ffULL,
0x000000ff7d7d7812ULL, 0x000fe200078ec0ffULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x0000006bff5f723eULL, 0x000fc400020006ffULL, 0x00000058ff82723eULL, 0x000fe200020006ffULL,
0x2000005aff587230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x20000021ff5a7230ULL, 0x000fe20000004100ULL, 0x00000084ff6b723eULL, 0x000fe200020006ffULL,
0x20000020ff847230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x000000ff4400720cULL, 0x000fe20003f45270ULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fc400020006ffULL,
0x00000079ff44723eULL, 0x000fe200020006ffULL, 0x20000083ff797230ULL, 0x000fe20000004100ULL,
0x00000023ff23723eULL, 0x000fe200020006ffULL, 0x2000007eff837230ULL, 0x000fe20000004100ULL,
0x00000081ff21723eULL, 0x000fe200020006ffULL, 0x20000074ff7e7230ULL, 0x000fe20000004100ULL,
0x0000007dff20723eULL, 0x000fe200020006ffULL, 0x2000007fff817230ULL, 0x000fe20000004100ULL,
0x00000052ff54723eULL, 0x000fe200020006ffULL, 0x20000055ff527230ULL, 0x000fe20000004100ULL,
0x000000ff616c7812ULL, 0x000fe200078ec0ffULL, 0x20000056ff557230ULL, 0x000fe20000004100ULL,
0x00000002ff617819ULL, 0x000fe2000001160fULL, 0x20000075ff747230ULL, 0x000fe20000004100ULL,
0x00000008ff727819ULL, 0x000fe20000011672ULL, 0x20000023ff567230ULL, 0x000fe20000004100ULL,
0x00000008ff6f7819ULL, 0x000fe2000001166fULL, 0x20000021ff7f7230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x20000020ff757230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x00a800006720783bULL, 0x000fe20000000200ULL,
0x00000008ff6d7819ULL, 0x000fe2000001166dULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x00000008ff767819ULL, 0x000fe20000011676ULL, 0x00001f6146617589ULL, 0x0002a200000e0000ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x20000072ff7d7230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x000000ff5d5d7812ULL, 0x000fc400078ec0ffULL, 0x00000076ff72723eULL, 0x000fe200020006ffULL,
0x2000006fff767230ULL, 0x000fe20000004100ULL, 0x000000ff5b5b7812ULL, 0x000fe200078ec0ffULL,
0x20000065ff6f7230ULL, 0x000fe20000004100ULL, 0x00000085ff46723eULL, 0x002fe200020006ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x0000006dff85723eULL, 0x000fe400020006ffULL,
0x00000008ff1e7819ULL, 0x000fe2000001161eULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL, 0x20000085ff657230ULL, 0x000fe20000004100ULL,
0x000000ff6a6a7812ULL, 0x000fc400078ec0ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x000000ff1f1f7812ULL, 0x000fe200078ec0ffULL,
0x2000005dff677230ULL, 0x000fe20000004100ULL, 0x0000005bff85723eULL, 0x000fe200020006ffULL,
0x2000006cff7b7230ULL, 0x000fe20000004100ULL, 0x0000001eff1e723eULL, 0x000fe400020006ffULL,
0x00000068ff5e723eULL, 0x000fe200020006ffULL, 0x20000085ff5d7230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000001eff5b7230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x0000001fff1f723eULL, 0x000fe200020006ffULL, 0x2000006eff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff1d857812ULL, 0x000fe200078ec0ffULL, 0x2000006aff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff1c7819ULL, 0x000fe2000001161cULL, 0x2000001fff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff1e7819ULL, 0x000fe2000001167cULL, 0x000000612020a231ULL, 0x084fe200003400ffULL,
0x00000010ff1d7819ULL, 0x000fe20000011682ULL, 0x000000612222a231ULL, 0x000fe200003400ffULL,
0x00000010ff1f7819ULL, 0x000fe2000001167bULL, 0x000000602121a231ULL, 0x080fe200003400ffULL,
0x0000001cff7b723eULL, 0x000fe200020006ffULL, 0x000000602323a231ULL, 0x000fe200003400ffULL,
0x000010541d1e7816ULL, 0x000fc4000000001eULL, 0x00000010ff1d7819ULL, 0x000fe4000001165eULL,
0x00000010ff1c7819ULL, 0x000fe40000011683ULL, 0x000000ff80807812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7c7819ULL, 0x000fe2000001165fULL, 0x2000007bff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff847819ULL, 0x000fc40000011684ULL,
0x000010541d1c7816ULL, 0x000fe4000000001cULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x000010547c1d7816ULL, 0x000fe20000000081ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00001054841f7816ULL, 0x000fe2000000001fULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000010ff497819ULL, 0x000fc40000011647ULL,
0x0000ffff474b7812ULL, 0x000fe200078ec0ffULL, 0x0000001c202c723cULL, 0x040fe2000004182cULL,
0x00000087ff47723eULL, 0x000fe400020006ffULL, 0x00000008ff7b7819ULL, 0x000fe40000011678ULL,
0x00000010ff797819ULL, 0x000fe20000011679ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff1d7819ULL, 0x000fe20000011644ULL, 0x0000001e2028723cULL, 0x000fe20000041828ULL,
0x00000010ff1c7819ULL, 0x000fc40000011645ULL, 0x00000010ff447819ULL, 0x000fe4000001167dULL,
0x00000010ff457819ULL, 0x000fe4000001167eULL, 0x00000010ff1e7819ULL, 0x000fe4000001167aULL,
0x00000010ff1f7819ULL, 0x000fe40000011680ULL, 0x00000010ff787819ULL, 0x000fe4000001167fULL,
0x00000086ff6c723eULL, 0x000fc400020006ffULL, 0x000010541d447816ULL, 0x000fe40000000044ULL,
0x000010541c457816ULL, 0x000fe20000000045ULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x000010541f1e7816ULL, 0x000fe4000000001eULL, 0x00001054781f7816ULL, 0x000fe40000000079ULL,
0x000000ff71797812ULL, 0x000fe200078ec0ffULL, 0x000000442034723cULL, 0x000fe20000041834ULL,
0x00000008ff717819ULL, 0x000fc40000011670ULL, 0x00000010ff707819ULL, 0x000fe40000011647ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff477819ULL, 0x000fe20000011674ULL,
0x0000001e2030723cULL, 0x000fe20000041830ULL, 0x00000010ff757819ULL, 0x000fe20000011675ULL,
0x00a80000571c783bULL, 0x0002a20000000200ULL, 0x00000071ff74723eULL, 0x000fe400020006ffULL,
0x00000010ff457819ULL, 0x000fc4000001166bULL, 0x00000010ff447819ULL, 0x000fe40000011672ULL,
0x00000010ff717819ULL, 0x000fe2000001166cULL, 0x20000074ff577230ULL, 0x002fe20000004100ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000066ff68723eULL, 0x000fe400020006ffULL, 0x0000105447467816ULL, 0x000fe20000000046ULL,
0x20000088ff667230ULL, 0x000fe20000004100ULL, 0x0000105475477816ULL, 0x000fe20000000070ULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x0000105445447816ULL, 0x000fc40000000044ULL,
0x0000105471457816ULL, 0x000fe40000000076ULL, 0x00000008ff5c7819ULL, 0x000fe2000001165cULL,
0x000000462038723cULL, 0x040fe20000041838ULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff467819ULL, 0x000fe20000011666ULL, 0x00000044203c723cULL, 0x000fe2000004183cULL,
0x00000010ff477819ULL, 0x000fc40000011668ULL, 0x00000010ff667819ULL, 0x000fe40000011669ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff457819ULL, 0x000fe20000011665ULL,
0x000000611c1ca231ULL, 0x084fe200003400ffULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x000000611e1ea231ULL, 0x000fe200003400ffULL, 0x000010546d467816ULL, 0x000fe20000000046ULL,
0x000000601d1da231ULL, 0x080fe200003400ffULL, 0x000010546e477816ULL, 0x000fe20000000047ULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x0000105466447816ULL, 0x000fe2000000006fULL,
0x000000601f1fa231ULL, 0x000fe200003400ffULL, 0x0000105462457816ULL, 0x000fc40000000045ULL,
0x000000ff777c7812ULL, 0x000fe200078ec0ffULL, 0x000000462040723cULL, 0x040fe20000041840ULL,
0x0000007bff77723eULL, 0x000fe400020006ffULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x00000008ff197819ULL, 0x000fe20000011619ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x000000ff1b1b7812ULL, 0x000fe200078ec0ffULL, 0x000000442024723cULL, 0x000fe20000041824ULL,
0x20000079ff6b7230ULL, 0x000fe20000004100ULL, 0x00000019ff19723eULL, 0x000fc400020006ffULL,
0x000000ff49497812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff207819ULL, 0x000fe4000001164dULL, 0x00000010ff4d7819ULL, 0x000fe4000001165cULL,
0x00000008ff4b7819ULL, 0x000fe4000001164bULL, 0x00001054204d7816ULL, 0x000fc4000000004dULL,
0x00000010ff207819ULL, 0x000fe40000011651ULL, 0x00000010ff517819ULL, 0x000fe40000011677ULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x0000001bff21723eULL, 0x000fe200020006ffULL,
0x20000019ff1b7230ULL, 0x000fe20000004100ULL, 0x0000105420517816ULL, 0x000fe20000000051ULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x20000021ff217230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fc400020006ffULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000049ff49723eULL, 0x000fe200020006ffULL, 0x20000085ff5e7230ULL, 0x000fe20000004100ULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x2000007cff787230ULL, 0x000fe20000004100ULL,
0x00000010ff537819ULL, 0x000fe20000011653ULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000010ff207819ULL, 0x000fe2000001166bULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x0000004bff4b723eULL, 0x000fc400020006ffULL, 0x0000105420537816ULL, 0x000fe40000000053ULL,
0x00000010ff547819ULL, 0x000fe20000011654ULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff207819ULL, 0x000fe40000011655ULL,
0x00000010ff1b7819ULL, 0x000fe4000001161bULL, 0x00000010ff667819ULL, 0x000fc40000011664ULL,
0x0000105454547816ULL, 0x000fe40000000057ULL, 0x0000105420557816ULL, 0x000fe4000000001bULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff647819ULL, 0x000fe40000011667ULL,
0x00000010ff657819ULL, 0x000fe2000001166aULL, 0x000000541c3c723cULL, 0x000fe2000004183cULL,
0x00000010ff4c7819ULL, 0x000fc4000001164cULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff507819ULL, 0x000fc40000011650ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff197819ULL, 0x000fe40000011678ULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff217819ULL, 0x000fe40000011621ULL,
0x00000010ff577819ULL, 0x000fc40000011658ULL, 0x00000010ff207819ULL, 0x000fe40000011649ULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x0000105464467816ULL, 0x000fc40000000063ULL, 0x0000105465477816ULL, 0x000fe40000000066ULL,
0x000010544c4c7816ULL, 0x000fe4000000005bULL, 0x000010545d4e7816ULL, 0x000fe4000000004eULL,
0x000010545e4f7816ULL, 0x000fe2000000004fULL, 0x000000461c28723cULL, 0x000fe20000041828ULL,
0x0000105450507816ULL, 0x000fe4000000005fULL, 0x0000105419527816ULL, 0x000fc40000000052ULL,
0x0000105421567816ULL, 0x000fe40000000056ULL, 0x0000105420577816ULL, 0x000fe20000000057ULL,
0x0000004c1c2c723cULL, 0x000fe2000004182cULL, 0x00001054594a7816ULL, 0x000fe4000000004aULL,
0x000010545a4b7816ULL, 0x000fca000000004bULL, 0x0000004e1c30723cULL, 0x040ff00000041830ULL,
0x000000501c34723cULL, 0x040ff00000041834ULL, 0x000000521c38723cULL, 0x040ff00000041838ULL,
0x000000561c40723cULL, 0x040ff00000041840ULL, 0x0000004a1c24723cULL, 0x000fe20000041824ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200006ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6400002ff7f8cULL, 0x0005e2000c80043fULL, 0x0000991073197816ULL, 0x000fc400000000ffULL,
0x00000001ff6f7807ULL, 0x000fe40004000000ULL, 0x000000ff1900720cULL, 0x000fe40003f45270ULL,
0x0000000103707812ULL, 0x000fe400078ec0ffULL, 0x00000001ff489807ULL, 0x000fc80001000000ULL,
0x0000761048717816ULL, 0x000fe40000000071ULL, 0x000003001a1a7a10ULL, 0x004fe40007ffe0ffULL,
0x000000ff04ff7812ULL, 0x000fe4000780c0ffULL, 0x000000151a00720cULL, 0x000fe40003f26070ULL,
0x00000001ff047807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff691000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x002e620000002500ULL,
0x000000ffff167224ULL, 0x000fe400078e002fULL, 0x000000ffff1f7224ULL, 0x000fe200078e002eULL,
0x0000000415007c0cULL, 0x002fda000bf03070ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0180000007007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000a6f0002e7802ULL, 0x000fe40000000f00ULL,
0x0000954000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000700007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000007ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff037624ULL, 0x000fe400078e00ffULL, 0x00006800ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x000ea8000c1e9900ULL, 0x0000000000047919ULL, 0x000ee80000000000ULL,
0x0000000000097919ULL, 0x000f220000000000ULL, 0x00000002ff067819ULL, 0x008fe40000011604ULL,
0x0000000809047811ULL, 0x010fe200078ff0ffULL, 0x0000000003057220ULL, 0x004fca0000410000ULL,
0x00001f0605007589ULL, 0x000ea800000e0000ULL, 0x00001f0405047589ULL, 0x000ee200000e0000ULL,
0x0000002800287220ULL, 0x044fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000003400347220ULL, 0x040fe20000410000ULL, 0x0000003500357220ULL, 0x040fe20000410000ULL,
0x0000003800387220ULL, 0x040fe20000410000ULL, 0x0000003900397220ULL, 0x040fe20000410000ULL,
0x0000003c003c7220ULL, 0x040fe20000410000ULL, 0x0000003d003d7220ULL, 0x040fe20000410000ULL,
0x0000004000407220ULL, 0x040fe20000410000ULL, 0x0000004100417220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x000fe20000410000ULL,
0x0000002a042a7220ULL, 0x048fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000003204327220ULL, 0x040fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000003604367220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000003a043a7220ULL, 0x040fe20000410000ULL, 0x0000003b043b7220ULL, 0x040fe20000410000ULL,
0x0000003e043e7220ULL, 0x040fe20000410000ULL, 0x0000003f043f7220ULL, 0x040fe20000410000ULL,
0x0000004204427220ULL, 0x040fe20000410000ULL, 0x0000004304437220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x000fc40000410000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x000000424343723eULL, 0x000fc400000010ffULL,
0x000000262726723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x0000541043427816ULL, 0x140fe40000000026ULL, 0x0000763243437816ULL, 0x000fe40000000026ULL,
0x0000000203007812ULL, 0x004fe200078ec0ffULL, 0x000000010c217824ULL, 0x100fe200078e0203ULL,
0x00000002ff137819ULL, 0x000fc40000011603ULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x0000000400067811ULL, 0x040fe400078ff8ffULL, 0x00000008031b7811ULL, 0x000fe400078ff0ffULL,
0x0000000200047811ULL, 0x040fe400078ff8ffULL, 0x0000000600107811ULL, 0x020fe400078ff8ffULL,
0x0000000702007812ULL, 0x000fc400078e7813ULL, 0x00000007060a7812ULL, 0x040fe400078e7813ULL,
0x0000000706067812ULL, 0x000fe200078e781bULL, 0x0000000813097824ULL, 0x000fe200078e0200ULL,
0x0000000704057812ULL, 0x000fe200078e7813ULL, 0x000010000e007824ULL, 0x000fe200078e00ffULL,
0x0000000702027812ULL, 0x000fe200078e781bULL, 0x000000081b197824ULL, 0x000fe200078e0206ULL,
0x0000000710127812ULL, 0x000fe200078e7813ULL, 0x0000000803067824ULL, 0x000fe200078e00ffULL,
0x0000000704047812ULL, 0x100fe200078e781bULL, 0x000000081b157824ULL, 0x000fe200078e0202ULL,
0x0000000710107812ULL, 0x000fe200078e781bULL, 0x00000008130f7824ULL, 0x040fe200078e0205ULL,
0x0000000806067812ULL, 0x000fe200078ec0ffULL, 0x0000000813117824ULL, 0x000fe200078e020aULL,
0x0000002c2d05723eULL, 0x000fe200000010ffULL, 0x000000081b177824ULL, 0x000fe200078e0204ULL,
0x000000282904723eULL, 0x000fe200000010ffULL, 0x000008000d027824ULL, 0x000fc400078e0200ULL,
0x0000000813137824ULL, 0x000fe200078e0212ULL, 0x00005410041c7816ULL, 0x140fe20000000005ULL,
0x000000081b1b7824ULL, 0x000fe200078e0210ULL, 0x00007632041d7816ULL, 0x000fe20000000005ULL,
0x0000001009097824ULL, 0x100fe200078e0202ULL, 0x000000383904723eULL, 0x000fe200000010ffULL,
0x000000100f0f7824ULL, 0x100fe200078e0202ULL, 0x0000003c3d05723eULL, 0x000fe200000010ffULL,
0x0000001011117824ULL, 0x100fe400078e0202ULL, 0x0000001015157824ULL, 0x000fc400078e0202ULL,
0x0000001017177824ULL, 0x100fe400078e0202ULL, 0x0000001013137824ULL, 0x100fe400078e0202ULL,
0x0000001019197824ULL, 0x100fe400078e0202ULL, 0x000000101b1b7824ULL, 0x000fe400078e0202ULL,
0x00000001090a7824ULL, 0x000fe200078e0206ULL, 0x000000343509723eULL, 0x000fe200000010ffULL,
0x00000001060f7824ULL, 0x000fc400078e020fULL, 0x0000000106117824ULL, 0x040fe200078e0211ULL,
0x0000001c0a007388ULL, 0x0005e20000000a00ULL, 0x0000000106157824ULL, 0x040fe400078e0215ULL,
0x0000000106177824ULL, 0x040fe400078e0217ULL, 0x0000000106137824ULL, 0x040fe400078e0213ULL,
0x0000000106197824ULL, 0x040fe400078e0219ULL, 0x00000001061b7824ULL, 0x000fe200078e021bULL,
0x000000303106723eULL, 0x000fe200000010ffULL, 0x00000010210a7824ULL, 0x004fc600078e0200ULL,
0x00005410061c7816ULL, 0x140fe40000000009ULL, 0x00007632061d7816ULL, 0x000fe40000000009ULL,
0x000000404106723eULL, 0x000fe400000010ffULL, 0x000000242509723eULL, 0x000fe200000010ffULL,
0x0000001c0f007388ULL, 0x0005e60000000a00ULL, 0x0000541006107816ULL, 0x000fc40000000009ULL,
0x00005410041c7816ULL, 0x144fe40000000005ULL, 0x00007632041d7816ULL, 0x000fe40000000005ULL,
0x0000002a2b04723eULL, 0x000fe400000010ffULL, 0x0000001f1605723eULL, 0x000fe200000010ffULL,
0x0000001c11007388ULL, 0x0005e40000000a00ULL, 0x0000763206117816ULL, 0x004fe40000000009ULL,
0x000000323306723eULL, 0x000fc400000010ffULL, 0x000000363709723eULL, 0x000fe200000010ffULL,
0x0000001013007388ULL, 0x0005e40000000a00ULL, 0x0000541004107816ULL, 0x144fe40000000005ULL,
0x0000763204117816ULL, 0x000fe40000000005ULL, 0x0000003a3b04723eULL, 0x000fe400000010ffULL,
0x0000003e3f05723eULL, 0x000fe200000010ffULL, 0x0000001015007388ULL, 0x0005e60000000a00ULL,
0x0000541004167816ULL, 0x000fc40000000005ULL, 0x0000541006107816ULL, 0x144fe40000000009ULL,
0x0000763206117816ULL, 0x000fca0000000009ULL, 0x0000001017007388ULL, 0x0005e40000000a00ULL,
0x0000763204177816ULL, 0x004fe40000000005ULL, 0x000000ff00047306ULL, 0x000fe60000205400ULL,
0x0000001619007388ULL, 0x000fe80000000a00ULL, 0x000000421b007388ULL, 0x000fe20000000a00ULL,
0x000000ff00057306ULL, 0x000ea60000209400ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000040500720bULL, 0x004fc40003f1d000ULL, 0x000000ff00047245ULL, 0x000fc6000020d400ULL,
0x000400000a247984ULL, 0x000eb00000000c00ULL, 0x0000000104040812ULL, 0x000fe200078efcffULL,
0x000c00000a287984ULL, 0x000ee60000000c00ULL, 0x000000040409723eULL, 0x000fe200000010ffULL,
0x000000000a107984ULL, 0x000f280000000c00ULL, 0x000800000a1c7984ULL, 0x000e620000000c00ULL,
0x3f803f8009247831ULL, 0x004fc40000200024ULL, 0x3f803f8009277831ULL, 0x040fe40000200027ULL,
0x3f803f8024247831ULL, 0x008fe20000200028ULL, 0x00000300ff287624ULL, 0x000fe200078e00ffULL,
0x3f803f8009267831ULL, 0x040fe40000200026ULL, 0x3f803f8009137831ULL, 0x050fe40000200013ULL,
0x000000012800780cULL, 0x000fe20003f05270ULL, 0x3f803f8009127831ULL, 0x040fe40000200012ULL,
0x3f803f8009117831ULL, 0x000fc40000200011ULL, 0x3f803f8009107831ULL, 0x040fe40000200010ULL,
0x3f803f8009257831ULL, 0x000fe40000200025ULL, 0x3f803f8013137831ULL, 0x002fe4000020001fULL,
0x3f803f8012127831ULL, 0x000fe4000020001eULL, 0x3f803f8011117831ULL, 0x000fe4000020001dULL,
0x3f803f8010107831ULL, 0x000fc4000020001cULL, 0x3f803f8027277831ULL, 0x000fe4000020002bULL,
0x3f803f8026267831ULL, 0x000fe2000020002aULL, 0x000000100a007388ULL, 0x0003e20000000c00ULL,
0x3f803f8025257831ULL, 0x000fca0000200029ULL, 0x000400240a007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000305000008947ULL, 0x000fea0003800000ULL,
0x0000000000157919ULL, 0x000ea20000002700ULL, 0x0000580028057a24ULL, 0x000fe200078e02ffULL,
0x000000010dff7812ULL, 0x000fe2000780f818ULL, 0x00001000ff177424ULL, 0x000fe200078e00ffULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x00006600050f7a24ULL, 0x000fe200078e02ffULL,
0x0000004021237810ULL, 0x000fe20007ffe0ffULL, 0x000008000e097824ULL, 0x000fe200078e00ffULL,
0x000000000a107984ULL, 0x002e640000000c00ULL, 0x00000fff0f057811ULL, 0x000fc400078e40ffULL,
0x000400000a1c7984ULL, 0x0007240000000c00ULL, 0x01ffffff0f0a7812ULL, 0x008fe200078ec0ffULL,
0x0000580015157a24ULL, 0x004fc800078e0206ULL, 0x0000030015067a24ULL, 0x000fca00078e02ffULL,
0x0000000406197c10ULL, 0x000fc8000fffe0ffULL, 0x0000001905167211ULL, 0x000fca00078fa0ffULL,
0x00006c0016167625ULL, 0x000fca00078e0017ULL, 0x0000000916167210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e0617ULL, 0x000000ff0300720cULL, 0x000fc60000725670ULL,
0x0000001021207825ULL, 0x000fc800078e0016ULL, 0x0000001023227825ULL, 0x000fe200078e0016ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000001ff167819ULL, 0x012fe20000011603ULL,
0x00000010030f7824ULL, 0x000fe400078e00ffULL, 0x00000080ff1b7424ULL, 0x000fe200078e00ffULL,
0x0000000c16247812ULL, 0x000fe200078ec0ffULL, 0x00000001191a7824ULL, 0x000fe200078e020aULL,
0x000000700f0f7812ULL, 0x000fe200078ec0ffULL, 0x00006c0019167625ULL, 0x000fc800078e001bULL,
0x00006c001a1a7625ULL, 0x000fe200078e001bULL, 0x0000001624167210ULL, 0x000fc80007a1e00fULL,
0x0000001a241a7210ULL, 0x000fe40007c7e00fULL, 0x00000017ff177210ULL, 0x000fe400007e44ffULL,
0x0000001bff1b7210ULL, 0x000fc60001fe84ffULL, 0x0000000816007986ULL, 0x0003e8000c101908ULL,
0x000000071a007986ULL, 0x0003e4000c101908ULL, 0x0000001020007986ULL, 0x0123e2000c101d08ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x0000001c22007986ULL, 0x0003e8000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff107424ULL, 0x002fe200078e00ffULL, 0xffffffff28077810ULL, 0x000fc60007ffe0ffULL,
0x00006a0015107625ULL, 0x000fe200078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000007101079a8ULL, 0x000ea400099ee1c8ULL,
0x000000071000720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff087807ULL, 0x000fca0000000000ULL, 0x00000008ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff077984ULL, 0x000ea40000000000ULL, 0x000000ff0700720cULL, 0x004fda0003f05270ULL,
0x00002c8000008947ULL, 0x000fea0003800000ULL, 0x000000ff1800720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0000000106127810ULL, 0x002fe20007ffe0ffULL,
0x0000001003077824ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fe20000011603ULL,
0x00000080ff0f7424ULL, 0x000fc600078e00ffULL, 0x0000007007157812ULL, 0x000fe200078ec0ffULL,
0x00006c0006107625ULL, 0x000fe200078e000fULL, 0x0000000c08177812ULL, 0x000fc600078ec0ffULL,
0x00006c0012127625ULL, 0x000fe200078e000fULL, 0x0000001017107210ULL, 0x000fc8000791e015ULL,
0x0000001217127210ULL, 0x000fe40007b5e015ULL, 0x00000011ff117210ULL, 0x000fe400007e24ffULL,
0x00000013ff137210ULL, 0x000fc600017e64ffULL, 0x0000000810077981ULL, 0x000368000c1e1900ULL,
0x0000000812087981ULL, 0x000362000c1e1900ULL, 0x000000022800780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000206107810ULL, 0x002fca0007ffe0ffULL,
0x00006c0010107625ULL, 0x000fca00078e000fULL, 0x0000001017107210ULL, 0x000fc8000791e015ULL,
0x00000011ff117210ULL, 0x000fca00007e24ffULL, 0x0000000810167981ULL, 0x000362000c1e1900ULL,
0x000000042800780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000306107810ULL, 0x002fca0007ffe0ffULL, 0x00006c0010107625ULL, 0x000fca00078e000fULL,
0x0000001017107210ULL, 0x000fc8000791e015ULL, 0x00000011ff117210ULL, 0x000fca00007e24ffULL,
0x0000000810187981ULL, 0x000362000c1e1900ULL, 0x000000042800780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000406107810ULL, 0x002fca0007ffe0ffULL,
0x00006c0010107625ULL, 0x000fca00078e000fULL, 0x0000001017107210ULL, 0x000fc8000791e015ULL,
0x00000011ff117210ULL, 0x000fca00007e24ffULL, 0x00000008101a7981ULL, 0x000362000c1e1900ULL,
0x000000062800780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000506107810ULL, 0x002fca0007ffe0ffULL, 0x00006c0010107625ULL, 0x000fca00078e000fULL,
0x0000001017107210ULL, 0x000fc8000791e015ULL, 0x00000011ff117210ULL, 0x000fca00007e24ffULL,
0x00000008101c7981ULL, 0x000362000c1e1900ULL, 0x000000062800780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000082800780cULL, 0x002fe40003f06070ULL,
0x0000000606107810ULL, 0x000fca0007ffe0ffULL, 0x00006c0010107625ULL, 0x000fca00078e000fULL,
0x0000001017107210ULL, 0x000fe40007a3e015ULL, 0x0000000706120810ULL, 0x000fe40007ffe0ffULL,
0x00000011ff117210ULL, 0x000fc60000fe44ffULL, 0x00006c0012120625ULL, 0x000fe400078e000fULL,
0x00000008101e7981ULL, 0x000366000c1e1900ULL, 0x0000001217120210ULL, 0x000fc80007c7e015ULL,
0x00000013ff130210ULL, 0x000fca0001fe84ffULL, 0x0000000812120981ULL, 0x000368000c1e1900ULL,
0x00000007280f7810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0f7819ULL, 0x000fc8000001160fULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff207224ULL, 0x000fe400078e00ffULL, 0x000000ffff227224ULL, 0x020fe400078e0007ULL,
0x0000000820137824ULL, 0x040fe200078e00ffULL, 0x0000000120207810ULL, 0x000fc80007ffe0ffULL,
0x0000030013007a0cULL, 0x000fe40003f26070ULL, 0x0000000f2000720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000813117810ULL, 0x040fe40007ffe0ffULL,
0x0000000113107810ULL, 0x000fe40007ffe0ffULL, 0x0000030011007a0cULL, 0x000fe40003f26070ULL,
0x0000030010007a0cULL, 0x000fe40003f46070ULL, 0x0000002207077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000106107824ULL, 0x000fe200078e0211ULL,
0x00000001ff177819ULL, 0x000fe20000011603ULL, 0x00000080ff117424ULL, 0x000fe400078e00ffULL,
0x0000001003157824ULL, 0x000fe200078e00ffULL, 0x0000000c17177812ULL, 0x000fe200078ec0ffULL,
0x00006c0010107625ULL, 0x000fc600078e0011ULL, 0x0000007015157812ULL, 0x000fc800078ec0ffULL,
0x0000001017107210ULL, 0x000fc80007b3e015ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000810227981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000913117810ULL, 0x042fe40007ffe0ffULL, 0x0000000213107810ULL, 0x000fe40007ffe0ffULL,
0x0000030011007a0cULL, 0x000fe40003f26070ULL, 0x0000030010007a0cULL, 0x000fe40003f46070ULL,
0x0000000807077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000106107824ULL, 0x000fe200078e0211ULL, 0x00000001ff177819ULL, 0x000fe20000011603ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x0000001003087824ULL, 0x000fe200078e00ffULL,
0x0000000c17177812ULL, 0x000fe200078ec0ffULL, 0x00006c0010107625ULL, 0x000fc600078e0011ULL,
0x0000007008157812ULL, 0x000fc800078ec0ffULL, 0x0000001017107210ULL, 0x000fc80007b3e015ULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x0000000810087981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a13117810ULL, 0x042fe40007ffe0ffULL,
0x0000000313107810ULL, 0x000fe40007ffe0ffULL, 0x0000030011007a0cULL, 0x000fe40003f26070ULL,
0x0000030010007a0cULL, 0x000fe40003f46070ULL, 0x0000001607077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000106107824ULL, 0x000fe200078e0211ULL,
0x00000001ff167819ULL, 0x000fe20000011603ULL, 0x00000080ff117424ULL, 0x000fe400078e00ffULL,
0x0000001003157824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006c0010107625ULL, 0x000fc600078e0011ULL, 0x0000007015157812ULL, 0x000fc800078ec0ffULL,
0x0000001016107210ULL, 0x000fc80007b3e015ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000810167981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b13117810ULL, 0x042fe40007ffe0ffULL, 0x0000000413107810ULL, 0x000fe40007ffe0ffULL,
0x0000030011007a0cULL, 0x000fe40003f26070ULL, 0x0000030010007a0cULL, 0x000fe40003f46070ULL,
0x0000001807077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000106107824ULL, 0x000fe200078e0211ULL, 0x00000001ff177819ULL, 0x000fe20000011603ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x0000001003157824ULL, 0x000fe200078e00ffULL,
0x0000000c17177812ULL, 0x000fe200078ec0ffULL, 0x00006c0010107625ULL, 0x000fc600078e0011ULL,
0x0000007015157812ULL, 0x000fc800078ec0ffULL, 0x0000001017107210ULL, 0x000fc80007b3e015ULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x0000000810187981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c13117810ULL, 0x042fe40007ffe0ffULL,
0x0000000513107810ULL, 0x000fe40007ffe0ffULL, 0x0000030011007a0cULL, 0x000fe40003f26070ULL,
0x0000030010007a0cULL, 0x000fe40003f46070ULL, 0x0000001a07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000106107824ULL, 0x000fe200078e0211ULL,
0x00000001ff177819ULL, 0x000fe20000011603ULL, 0x00000080ff117424ULL, 0x000fe400078e00ffULL,
0x0000001003157824ULL, 0x000fe200078e00ffULL, 0x0000000c17177812ULL, 0x000fe200078ec0ffULL,
0x00006c0010107625ULL, 0x000fc600078e0011ULL, 0x0000007015157812ULL, 0x000fc800078ec0ffULL,
0x0000001017107210ULL, 0x000fc80007b3e015ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x00000008101a7981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d13117810ULL, 0x042fe40007ffe0ffULL, 0x0000000613107810ULL, 0x000fe40007ffe0ffULL,
0x0000030011007a0cULL, 0x000fe40003f26070ULL, 0x0000030010007a0cULL, 0x000fe40003f46070ULL,
0x0000001c07077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000106107824ULL, 0x000fe200078e0211ULL, 0x00000001ff177819ULL, 0x000fe20000011603ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x0000001003157824ULL, 0x000fe200078e00ffULL,
0x0000000c17177812ULL, 0x000fe200078ec0ffULL, 0x00006c0010107625ULL, 0x000fc600078e0011ULL,
0x0000007015157812ULL, 0x000fc800078ec0ffULL, 0x0000001017107210ULL, 0x000fc80007b3e015ULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x00000008101c7981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e13117810ULL, 0x042fe40007ffe0ffULL,
0x0000000713107810ULL, 0x000fe40007ffe0ffULL, 0x0000030011007a0cULL, 0x000fe40003f26070ULL,
0x0000030010007a0cULL, 0x000fe40003f46070ULL, 0x0000001e07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000106107824ULL, 0x000fe200078e0211ULL,
0x00000001ff177819ULL, 0x000fe20000011603ULL, 0x00000080ff117424ULL, 0x000fe400078e00ffULL,
0x0000001003157824ULL, 0x000fe200078e00ffULL, 0x0000000c17177812ULL, 0x000fe200078ec0ffULL,
0x00006c0010107625ULL, 0x000fc600078e0011ULL, 0x0000007015157812ULL, 0x000fc800078ec0ffULL,
0x0000001017107210ULL, 0x000fc80007b3e015ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x00000008101e7981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f13137810ULL, 0x000fe40007ffe0ffULL, 0x0000001207077209ULL, 0x000fe40007810000ULL,
0x0000030013007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000106107824ULL, 0x002fe200078e0213ULL, 0x00000001ff157819ULL, 0x000fe20000011603ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x0000001003127824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006c0010107625ULL, 0x000fc600078e0011ULL,
0x0000007012137812ULL, 0x000fc800078ec0ffULL, 0x0000001015107210ULL, 0x000fc80007a3e013ULL,
0x00000011ff117210ULL, 0x000fca0000fe44ffULL, 0x0000000810127981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x0000001003087824ULL, 0x024fe200078e00ffULL, 0x00000001ff0f7819ULL, 0x000fc80000011603ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c0f0f7812ULL, 0x000fca00078ec0ffULL,
0x000000010f087824ULL, 0x000fca00078e0208ULL, 0x0000000708007388ULL, 0x0005e40000000800ULL,
0x000000010d1a7824ULL, 0x000fe200078e0206ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000001003077824ULL, 0x004fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00001000ff117424ULL, 0x002fe200078e00ffULL, 0x0000001a05107211ULL, 0x000fe200078fa0ffULL,
0x000000010b0b7824ULL, 0x000fe200078e0200ULL, 0x00000001ff087819ULL, 0x000fe20000011603ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000070070f7812ULL, 0x000fe200078ec0ffULL,
0x00006c0010107625ULL, 0x000fe200078e0011ULL, 0x0000000114077812ULL, 0x000fe200078ec0ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000c08127812ULL, 0x000fe200078ec0ffULL,
0x0000080014147824ULL, 0x000fe200078e00ffULL, 0x0000000910107210ULL, 0x000fe20007f3e0ffULL,
0x000000020d088824ULL, 0x100fe200078e020eULL, 0x0000002003137810ULL, 0x000fe20007ffe0ffULL,
0x00000001121c7824ULL, 0x000fe200078e020fULL, 0x0000080014147812ULL, 0x000fe200078ec0ffULL,
0x000000020d128824ULL, 0x000fe200078e020eULL, 0x0000004003157810ULL, 0x040fe20007ffe0ffULL,
0x000000010a188824ULL, 0x000fe200078e021aULL, 0x0000006003177810ULL, 0x000fe20007ffe0ffULL,
0x000000010b147824ULL, 0x000fe200078e0214ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000080ff198424ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000208088824ULL, 0x000fe200078e0207ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x000003000d007a0cULL, 0x000fe20003f26070ULL,
0x00000080ff1b8424ULL, 0x000fe200078e00ffULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000002121e8824ULL, 0x000fc400078e0207ULL, 0x00000010030f7824ULL, 0x000fe200078e0214ULL,
0x000000001c077984ULL, 0x0002a20000000800ULL, 0x00006c0018188625ULL, 0x000fc800078e0019ULL,
0x0000001013127825ULL, 0x000fe200078e0010ULL, 0x00000000001c7805ULL, 0x002fc6000001ff00ULL,
0x0000001015147825ULL, 0x000fc800078e0010ULL, 0x0000001017167825ULL, 0x000fc800078e0010ULL,
0x00006c001a1a8625ULL, 0x000fc800078e001bULL, 0x0000000808088824ULL, 0x000fe400078e0203ULL,
0x0000001003107825ULL, 0x000fc600078e0010ULL, 0x00004580081f8811ULL, 0x000fe200078e20ffULL,
0x000000081e1e8824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000100f7faeULL, 0x0003e2000b901c48ULL, 0x0000001003188825ULL, 0x000fc600078e0018ULL,
0x000041801e218811ULL, 0x000fe200078e20ffULL, 0x00000010031a8825ULL, 0x000fe200078e001aULL,
0x00380000120f7faeULL, 0x0007e6000b901c48ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x00580000140f7faeULL, 0x0009e2000b901c48ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x002fe4000001ff00ULL, 0x00780000160f7faeULL, 0x0003e8000b901c48ULL,
0x00000000181f8faeULL, 0x000be2000b901c48ULL, 0x0000000000127805ULL, 0x008fc6000001ff00ULL,
0x000000001a218faeULL, 0x0007e2000b901c48ULL, 0x0000000000147805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000167805ULL, 0x002fe2000001ff00ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x00000000001e7805ULL, 0x020fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x008fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000e0000001947ULL, 0x000fea0003800000ULL,
0x00000df000007945ULL, 0x004fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe400078e00ffULL,
0x000000ffff327224ULL, 0x000fca00078e000dULL, 0x0000000232317810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff477224ULL, 0x000fe200078e0032ULL, 0x00000002ff307819ULL, 0x002fe20000011603ULL,
0x000000020d457824ULL, 0x000fe200078e020eULL, 0x0000030031007a0cULL, 0x000fe20003f06070ULL,
0x0000004047327824ULL, 0x000fe200078e00ffULL, 0x00000007304a7812ULL, 0x040fe200078ec0ffULL,
0x0000000830337824ULL, 0x040fe200078e00ffULL, 0x00000030ff4c7212ULL, 0x000fe200078e33ffULL,
0x00000008302f7824ULL, 0x000fe200078e00ffULL, 0x0000008032327812ULL, 0x000fe200078ec0ffULL,
0x0000000830357824ULL, 0x000fe200078e00ffULL, 0x0000039000017945ULL, 0x000fe20003800000ULL,
0xfffffff8333e7812ULL, 0x100fe200078ee24aULL, 0x0000001003497824ULL, 0x000fe200078e00ffULL,
0x000000012f407812ULL, 0x000fe200078ef64aULL, 0x0000010045457824ULL, 0x000fe200078e0032ULL,
0x000000022f427812ULL, 0x000fc400078ef64aULL, 0x000000032f447812ULL, 0x140fe400078ef64aULL,
0x000000042f467812ULL, 0x140fe400078ef64aULL, 0x000000052f487812ULL, 0x140fe400078ef64aULL,
0x000000062f4a7812ULL, 0x000fe400078ef64aULL, 0xfffffff8354c7812ULL, 0x000fe400078ee24cULL,
0x00000008302f7810ULL, 0x000fe20007ffe0ffULL, 0x000002c000000947ULL, 0x008fea0003800000ULL,
0x00000001063c7824ULL, 0x100fe200078e0231ULL, 0x00000001ff347819ULL, 0x000fe20000011631ULL,
0x00001000ff337424ULL, 0x000fe200078e00ffULL, 0x000000070300780cULL, 0x000fc40003f24070ULL,
0x0000003c05327211ULL, 0x000fe400078fa0ffULL, 0x0000000134357812ULL, 0x000fe200078ec0ffULL,
0x0000040031347824ULL, 0x000fe200078e00ffULL, 0x0000002003377810ULL, 0x040fe20007ffe0ffULL,
0x00006c0032327625ULL, 0x000fe200078e0033ULL, 0x0000004003397810ULL, 0x000fe40007ffe0ffULL,
0x0000080034347812ULL, 0x000fe400078ec0ffULL, 0x0000000932327210ULL, 0x000fe20007f1e0ffULL,
0x000000020d4e9824ULL, 0x100fe200078e020eULL, 0x0000006003417810ULL, 0x000fe20007ffe0ffULL,
0x000000020d369824ULL, 0x000fc400078e020eULL, 0x000000010b347824ULL, 0x000fe400078e0234ULL,
0x000000ffff337224ULL, 0x000fe400000e0633ULL, 0x000000010a3a9824ULL, 0x000fe400078e023cULL,
0x00000080ff3b9424ULL, 0x000fe400078e00ffULL, 0x000000024e4e9824ULL, 0x000fe400078e0235ULL,
0x00000080ff3d9424ULL, 0x000fc400078e00ffULL, 0x0000000236509824ULL, 0x000fe400078e0235ULL,
0x00000010033f7824ULL, 0x040fe400078e0234ULL, 0x0000001003347825ULL, 0x000fc800078e0032ULL,
0x0000001037367825ULL, 0x100fe200078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000343f7faeULL, 0x0003e6000b901c48ULL, 0x0000001039387825ULL, 0x100fe200078e0032ULL,
0x00380000363f7faeULL, 0x0003e6000b901c48ULL, 0x00006c003a3a9625ULL, 0x000fe200078e003bULL,
0x00580000383f7faeULL, 0x0003e6000b901c48ULL, 0x0000001041327825ULL, 0x000fc800078e0032ULL,
0x00006c003c3c9625ULL, 0x000fe200078e003dULL, 0x00780000323f7faeULL, 0x0003e6000b901c48ULL,
0x000000084e419824ULL, 0x100fe400078e0203ULL, 0x0000000850439824ULL, 0x000fe400078e0203ULL,
0x00000010033a9825ULL, 0x000fe200078e003aULL, 0x0000458041419811ULL, 0x000fe400078e20ffULL,
0x0000418043439811ULL, 0x000fe200078e20ffULL, 0x00000010033c9825ULL, 0x000fc400078e003cULL,
0x000000003a419faeULL, 0x0003e8000b901c48ULL, 0x000000003c439faeULL, 0x0003e4000b901c48ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000001ff357819ULL, 0x002fe20000011603ULL, 0x0000040047327824ULL, 0x000fe200078e00ffULL,
0x0000007049547812ULL, 0x000fe200078ec0ffULL, 0x000000082f347824ULL, 0x000fe200078e00ffULL,
0x0000000c35357812ULL, 0x000fe200078ec0ffULL, 0x000000082f367824ULL, 0x040fe200078e00ffULL,
0x000000072f337812ULL, 0x040fe200078ec0ffULL, 0x000000082f567824ULL, 0x000fe200078e00ffULL,
0x0000004535457210ULL, 0x000fc40007ffe054ULL, 0x0000080032327812ULL, 0x000fe400078ec0ffULL,
0x0000002fff357212ULL, 0x000fe400078e33ffULL, 0x0000000134387812ULL, 0x140fe400078ef633ULL,
0x00000002343a7812ULL, 0x140fe400078ef633ULL, 0x00000003343c7812ULL, 0x140fe400078ef633ULL,
0x00000004344e7812ULL, 0x000fc400078ef633ULL, 0x0000000534507812ULL, 0x000fe200078ef633ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800045547984ULL, 0x000e620000000800ULL,
0x0000000634527812ULL, 0x100fe200078ef633ULL, 0x0000000403347824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee233ULL, 0x0045800045457984ULL, 0x000ea20000000800ULL,
0x000001800b337810ULL, 0x000fe40007ffe032ULL, 0xfffffff856327812ULL, 0x000fe400078ee235ULL,
0x0000000c34357812ULL, 0x000fe200078ec0ffULL, 0x000000103e3e7824ULL, 0x000fc400078e0233ULL,
0x0000001040407824ULL, 0x100fe400078e0233ULL, 0x0000001042427824ULL, 0x100fe400078e0233ULL,
0x0000001044447824ULL, 0x100fe400078e0233ULL, 0x0000001046467824ULL, 0x100fe400078e0233ULL,
0x0000001048487824ULL, 0x100fe400078e0233ULL, 0x000000104a4a7824ULL, 0x000fc400078e0233ULL,
0x0000001036367824ULL, 0x100fe400078e0233ULL, 0x0000001038387824ULL, 0x100fe400078e0233ULL,
0x000000103a3a7824ULL, 0x100fe400078e0233ULL, 0x000000103c3c7824ULL, 0x100fe400078e0233ULL,
0x000000104e4e7824ULL, 0x100fe400078e0233ULL, 0x0000001050507824ULL, 0x000fc400078e0233ULL,
0x0000001052527824ULL, 0x100fe400078e0233ULL, 0x000000104c4c7824ULL, 0x100fe400078e0233ULL,
0x0000001032327824ULL, 0x000fe200078e0233ULL, 0x0000005407547221ULL, 0x002fe20000010100ULL,
0x000000013e3e7824ULL, 0x000fe400078e0235ULL, 0x0000000135407824ULL, 0x040fe200078e0240ULL,
0x3fb8aa3b54547820ULL, 0x000fe20000410000ULL, 0x0000000135427824ULL, 0x000fc400078e0242ULL,
0x0000000135447824ULL, 0x040fe200078e0244ULL, 0x000000003e3e7984ULL, 0x000e620000000800ULL,
0x0000000135467824ULL, 0x040fe200078e0246ULL, 0x0000005400547308ULL, 0x000ea20000000800ULL,
0x0000000135487824ULL, 0x040fe200078e0248ULL, 0x0000000042427984ULL, 0x000ee20000000800ULL,
0x00000001354a7824ULL, 0x040fe400078e024aULL, 0x00000001354c7824ULL, 0x040fe200078e024cULL,
0x0000000044447984ULL, 0x000f220000000800ULL, 0x0000000135367824ULL, 0x000fc400078e0236ULL,
0x0000000135387824ULL, 0x040fe200078e0238ULL, 0x0000000048487984ULL, 0x000f620000000800ULL,
0x00000001353a7824ULL, 0x040fe400078e023aULL, 0x00000001353c7824ULL, 0x040fe200078e023cULL,
0x000000004c4c7984ULL, 0x000f620000000800ULL, 0x00000001354e7824ULL, 0x040fe200078e024eULL,
0x00000045543d7220ULL, 0x004fe20000410000ULL, 0x0000000135507824ULL, 0x040fe200078e0250ULL,
0x0000000046467984ULL, 0x000ea20000000800ULL, 0x0000000135527824ULL, 0x000fe200078e0252ULL,
0x0000002e3d2e7221ULL, 0x000fe20000010000ULL, 0x0000000135357824ULL, 0x000fe200078e0232ULL,
0x000000004a4a7984ULL, 0x000ea20000000800ULL, 0x000000ffff327224ULL, 0x000fc600078e0031ULL,
0x0000000050507984ULL, 0x000ea40000000800ULL, 0x0000030032007a0cULL, 0x000fe40003f06070ULL,
0x0000000036367984ULL, 0x000ea80000000800ULL, 0x0000000038387984ULL, 0x000ea80000000800ULL,
0x000000003a3a7984ULL, 0x000ea20000000800ULL, 0x00005410ff347816ULL, 0x002fc4000000003eULL,
0x00007610ff377816ULL, 0x000fe2000000003eULL, 0x000000004e4e7984ULL, 0x000e620000000800ULL,
0x00005410ff3b7816ULL, 0x108fe40000000042ULL, 0x00007610ff427816ULL, 0x000fe20000000042ULL,
0x0000000052527984ULL, 0x000ee20000000800ULL, 0x00005410ff417816ULL, 0x110fe40000000044ULL,
0x00007610ff437816ULL, 0x000fe20000000044ULL, 0x0000000035357984ULL, 0x000f220000000800ULL,
0x00005410ff567816ULL, 0x020fc40000000048ULL, 0x00007610ff457816ULL, 0x000fe20000000048ULL,
0x0000000040407984ULL, 0x000f620000000800ULL, 0x00005410ff477816ULL, 0x100fe4000000004cULL,
0x00007610ff497816ULL, 0x000fe2000000004cULL, 0x000000003c3c7984ULL, 0x000f620000000800ULL,
0x00005410ff447816ULL, 0x104fe40000000046ULL, 0x00007610ff467816ULL, 0x000fe40000000046ULL,
0x00005410ff487816ULL, 0x000fc4000000004aULL, 0x00007610ff4a7816ULL, 0x000fe4000000004aULL,
0x00005410ff557816ULL, 0x100fe40000000050ULL, 0x00007610ff577816ULL, 0x000fe40000000050ULL,
0x00005410ff4b7816ULL, 0x100fe40000000036ULL, 0x00007610ff367816ULL, 0x000fe40000000036ULL,
0x00005410ff4c7816ULL, 0x000fc40000000038ULL, 0x00007610ff4d7816ULL, 0x000fe40000000038ULL,
0x00005410ff4f7816ULL, 0x100fe4000000003aULL, 0x00007610ff3a7816ULL, 0x000fe4000000003aULL,
0x00005410ff537816ULL, 0x102fe4000000004eULL, 0x00007610ff4e7816ULL, 0x000fe4000000004eULL,
0x00005410ff507816ULL, 0x008fc40000000052ULL, 0x00007610ff527816ULL, 0x000fe40000000052ULL,
0x00005410ff587816ULL, 0x110fe40000000035ULL, 0x00007610ff357816ULL, 0x000fe40000000035ULL,
0x00005410ff547816ULL, 0x120fe40000000040ULL, 0x00007610ff397816ULL, 0x000fe40000000040ULL,
0x00005410ff387816ULL, 0x000fc4000000003cULL, 0x00007610ff517816ULL, 0x000fe2000000003cULL,
0x000064427f007947ULL, 0x000fea000b800000ULL, 0x00001f303d337589ULL, 0x0002a400000e0000ULL,
0x000064927f007947ULL, 0x000fea000b800000ULL, 0x00001f2f3d2f7589ULL, 0x00072400000e0000ULL,
0x00000033342d7223ULL, 0x084fe2000001002dULL, 0x00000033372c7223ULL, 0x080fe2000001002cULL,
0x00000033542b7223ULL, 0x080fe2000001002bULL, 0x00000033392a7223ULL, 0x080fe2000001002aULL,
0x000000333b147223ULL, 0x080fe20000010014ULL, 0x0000003342297223ULL, 0x080fe20000010029ULL,
0x00000033411c7223ULL, 0x080fe2000001001cULL, 0x0000003343287223ULL, 0x080fe20000010028ULL,
0x00000033440f7223ULL, 0x080fe2000001000fULL, 0x0000003346277223ULL, 0x080fe20000010027ULL,
0x0000003356177223ULL, 0x080fe20000010017ULL, 0x0000003345267223ULL, 0x080fe20000010026ULL,
0x0000003348117223ULL, 0x080fe20000010011ULL, 0x000000334a257223ULL, 0x080fe20000010025ULL,
0x0000003347107223ULL, 0x080fe20000010010ULL, 0x0000003349247223ULL, 0x000fe20000010024ULL,
0x0000002f4b127223ULL, 0x090fe20000010012ULL, 0x0000002f36237223ULL, 0x080fe20000010023ULL,
0x0000002f4c1b7223ULL, 0x080fe2000001001bULL, 0x0000002f4d227223ULL, 0x080fe20000010022ULL,
0x0000002f4f1a7223ULL, 0x080fe2000001001aULL, 0x0000002f3a217223ULL, 0x080fe20000010021ULL,
0x0000002f38197223ULL, 0x080fe20000010019ULL, 0x0000002f51207223ULL, 0x080fe20000010020ULL,
0x0000002f53187223ULL, 0x080fe20000010018ULL, 0x0000002f4e1f7223ULL, 0x080fe2000001001fULL,
0x0000002f55167223ULL, 0x080fe20000010016ULL, 0x0000002f571e7223ULL, 0x080fe2000001001eULL,
0x0000002f50157223ULL, 0x080fe20000010015ULL, 0x0000002f521d7223ULL, 0x080fe2000001001dULL,
0x0000002f58137223ULL, 0x080fe20000010013ULL, 0x0000002f35087223ULL, 0x000fe20000010008ULL,
0xfffff24000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x004ea20000000000ULL, 0x000000ff0e00720cULL, 0x000fe20003f05270ULL,
0x0000001003057824ULL, 0x004fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011603ULL,
0x0000007005057812ULL, 0x000fe400078ec0ffULL, 0x0000000c03067812ULL, 0x000fca00078ec0ffULL,
0x0000000106077824ULL, 0x000fe200078e0205ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x0000001003057824ULL, 0x004fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011603ULL, 0x0000007005067812ULL, 0x000fe400078ec0ffULL,
0x0000000c030a7812ULL, 0x000fc600078ec0ffULL, 0x000000800d037824ULL, 0x000fc800078e0206ULL,
0x000000010a037824ULL, 0x000fca00078e0203ULL, 0x0049802e03007388ULL, 0x0005e40000000800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800007037984ULL, 0x004ea80000000800ULL,
0x004a000007067984ULL, 0x000f220000000800ULL, 0x00000003ff037221ULL, 0x004fc80000010000ULL,
0x0000000603037221ULL, 0x010fca0000010000ULL, 0x0180000003057810ULL, 0x000fc80007ffe0ffULL,
0x7f80000005057812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0500780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e0003ULL, 0x0000d6f0002e7802ULL, 0x000fe40000000f00ULL,
0x0000654000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff057224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000300067308ULL, 0x000ea40000001000ULL,
0xbf80000003057423ULL, 0x004fc80000000006ULL, 0x800000ff05057221ULL, 0x000fc80000010100ULL,
0x0000000506057223ULL, 0x000fe40000000006ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff2e7819ULL, 0x004fe40000011603ULL, 0x00000008032f7811ULL, 0x000fc600078ff0ffULL,
0x00001f2e05067589ULL, 0x000ea200000e0000ULL, 0x000000082e337824ULL, 0x000fe200078e00ffULL,
0x0000002fff317212ULL, 0x000fe200078e33ffULL, 0x000000082f307824ULL, 0x002fe200078e00ffULL,
0x00001f2f05097589ULL, 0x00032800000e0000ULL, 0xfffffff830317812ULL, 0x000fca00078ee231ULL,
0x0000001031317824ULL, 0x000fe200078e0202ULL, 0x0000000f060f7220ULL, 0x044fe20000410000ULL,
0x00000027060a7220ULL, 0x040fe20000410000ULL, 0x0000002806077220ULL, 0x040fe20000410000ULL,
0x0000002d062d7220ULL, 0x040fe20000410000ULL, 0x0000002c062c7220ULL, 0x040fe20000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000002a062a7220ULL, 0x040fe20000410000ULL,
0x0000001406147220ULL, 0x040fe20000410000ULL, 0x0000002906297220ULL, 0x040fe20000410000ULL,
0x0000001c061c7220ULL, 0x040fe20000410000ULL, 0x0000001706177220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x0000002506287220ULL, 0x040fe20000410000ULL, 0x0000001006107220ULL, 0x040fe20000410000ULL,
0x0000002406057220ULL, 0x002fe20000410000ULL, 0x0000001309137220ULL, 0x050fe20000410000ULL,
0x0000000809087220ULL, 0x040fe20000410000ULL, 0x0000001509157220ULL, 0x040fe20000410000ULL,
0x0000001d09067220ULL, 0x040fe20000410000ULL, 0x0000000f0a0a723eULL, 0x000fe200000010ffULL,
0x0000001809187220ULL, 0x040fe20000410000ULL, 0x000000072e0f7812ULL, 0x000fe200078ec0ffULL,
0x0000001f091f7220ULL, 0x040fe20000410000ULL, 0x0000001209127220ULL, 0x040fe20000410000ULL,
0x0000002309237220ULL, 0x040fe20000410000ULL, 0x0000001a091a7220ULL, 0x040fe20000410000ULL,
0x0000002109217220ULL, 0x040fe20000410000ULL, 0x000000130808723eULL, 0x000fe200000010ffULL,
0x0000001b091b7220ULL, 0x040fe20000410000ULL, 0x000000150606723eULL, 0x000fe200000010ffULL,
0x0000002209227220ULL, 0x000fe20000410000ULL, 0x000000010f137812ULL, 0x000fe200078e3cffULL,
0x0000001909197220ULL, 0x000fe20000410000ULL, 0x000000020f157812ULL, 0x000fe200078e3cffULL,
0x0000002009207220ULL, 0x000fe20000410000ULL, 0x000000181f18723eULL, 0x000fe200000010ffULL,
0x0000001609167220ULL, 0x000fe20000410000ULL, 0x000000030f1d7812ULL, 0x000fe200078e3cffULL,
0x0000001e090b7220ULL, 0x000fe20000410000ULL, 0x000000122312723eULL, 0x000fe200000010ffULL,
0x000000082e097824ULL, 0x000fe200078e00ffULL, 0x0000001a211a723eULL, 0x000fc400000010ffULL,
0x000000040f1f7812ULL, 0x040fe400078e3cffULL, 0x000000050f217812ULL, 0x040fe400078e3cffULL,
0x000000060f237812ULL, 0x000fe200078e3cffULL, 0x000000082e0f7824ULL, 0x040fe200078e0213ULL,
0x0000002eff247212ULL, 0x000fe200078e33ffULL, 0x000000082e137824ULL, 0x000fe200078e0215ULL,
0x000000100505723eULL, 0x000fe200000010ffULL, 0x000000082f107824ULL, 0x040fe200078e00ffULL,
0x0000001b221b723eULL, 0x000fe200000010ffULL, 0x000000082e157824ULL, 0x040fe200078e021dULL,
0x000000072f227812ULL, 0x000fe200078ec0ffULL, 0x000000082e1d7824ULL, 0x040fe200078e021fULL,
0xfffffff833337812ULL, 0x000fe200078ee224ULL, 0x000000082e1f7824ULL, 0x040fe200078e0221ULL,
0x0000001c0707723eULL, 0x000fe200000010ffULL, 0x000000082e217824ULL, 0x000fe200078e0223ULL,
0x000000192019723eULL, 0x000fe200000010ffULL, 0x0000000403247824ULL, 0x000fe200078e00ffULL,
0x000000160b0b723eULL, 0x000fe200000010ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0202ULL,
0xfffffff809097812ULL, 0x000fe200078ee22eULL, 0x0000001013137824ULL, 0x100fe200078e0202ULL,
0xfffffff810237812ULL, 0x000fe200078ee22fULL, 0x0000001015157824ULL, 0x100fe200078e0202ULL,
0x0000000122107812ULL, 0x040fe200078e3cffULL, 0x0000001009097824ULL, 0x100fe200078e0202ULL,
0x0000000222167812ULL, 0x040fe200078e3cffULL, 0x000000101d1d7824ULL, 0x000fe200078e0202ULL,
0x00000003221c7812ULL, 0x040fe200078e3cffULL, 0x000000082f257824ULL, 0x040fe200078e0210ULL,
0x00000004221e7812ULL, 0x040fe200078e3cffULL, 0x000000082f277824ULL, 0x000fe200078e0216ULL,
0x0000000522207812ULL, 0x040fe200078e3cffULL, 0x0000001033107824ULL, 0x100fe200078e0202ULL,
0x0000000622227812ULL, 0x000fe200078e3cffULL, 0x000000101f1f7824ULL, 0x100fe200078e0202ULL,
0x0000000c24247812ULL, 0x000fe200078ec0ffULL, 0x0000001023237824ULL, 0x000fe200078e0202ULL,
0x0000002d2c2c723eULL, 0x000fe200000010ffULL, 0x000000082f2d7824ULL, 0x040fe200078e0220ULL,
0x0000002b2a2a723eULL, 0x000fe200000010ffULL, 0x000000082f2b7824ULL, 0x000fe200078e021eULL,
0x000000142914723eULL, 0x000fe200000010ffULL, 0x000000082f297824ULL, 0x040fe200078e021cULL,
0x000000172617723eULL, 0x000fe200000010ffULL, 0x000000082f2f7824ULL, 0x000fe200078e0222ULL,
0x000000112811723eULL, 0x000fe200000010ffULL, 0x0000000124097824ULL, 0x000fc400078e0209ULL,
0x00000001240f7824ULL, 0x000fe400078e020fULL, 0x0000001021217824ULL, 0x100fe200078e0202ULL,
0x0000002c09007388ULL, 0x0003e20000000800ULL, 0x0000001025257824ULL, 0x100fe400078e0202ULL,
0x0000001027277824ULL, 0x100fe200078e0202ULL, 0x0000002a0f007388ULL, 0x000fe20000000800ULL,
0x0000001029297824ULL, 0x100fe400078e0202ULL, 0x000000102b2b7824ULL, 0x000fc400078e0202ULL,
0x000000102d2d7824ULL, 0x100fe400078e0202ULL, 0x000000102f2f7824ULL, 0x000fe400078e0202ULL,
0x0000000124137824ULL, 0x040fe400078e0213ULL, 0x0000000124027824ULL, 0x040fe400078e0215ULL,
0x00000001241c7824ULL, 0x040fe200078e0210ULL, 0x0000001413007388ULL, 0x000fe20000000800ULL,
0x00000001241d7824ULL, 0x000fc400078e021dULL, 0x0000000124107824ULL, 0x040fe200078e021fULL,
0x0000000702007388ULL, 0x0005e20000000800ULL, 0x0000000124167824ULL, 0x040fe400078e0221ULL,
0x0000000124237824ULL, 0x040fe200078e0223ULL, 0x0000000a1d007388ULL, 0x000fe20000000800ULL,
0x00000001241e7824ULL, 0x040fe400078e0225ULL, 0x0000000124277824ULL, 0x040fe200078e0227ULL,
0x0000001710007388ULL, 0x000fe20000000800ULL, 0x0000000124207824ULL, 0x000fc400078e0229ULL,
0x00000001242b7824ULL, 0x040fe200078e022bULL, 0x0000001116007388ULL, 0x000fe20000000800ULL,
0x0000000124227824ULL, 0x040fe400078e022dULL, 0x00000001242f7824ULL, 0x040fe200078e022fULL,
0x000000051c007388ULL, 0x000fe20000000800ULL, 0x0000000124317824ULL, 0x000fe400078e0231ULL,
0x000000010c097824ULL, 0x002fe200078e0203ULL, 0x0000001223007388ULL, 0x000fe60000000800ULL,
0x0000001009027824ULL, 0x004fe200078e0200ULL, 0x0000001b1e007388ULL, 0x000fe20000000800ULL,
0x000000040409723eULL, 0x000fc600000010ffULL, 0x0000001a27007388ULL, 0x000fe80000000800ULL,
0x0000001920007388ULL, 0x000fe80000000800ULL, 0x000000182b007388ULL, 0x000fe80000000800ULL,
0x0000000b22007388ULL, 0x000fe80000000800ULL, 0x000000062f007388ULL, 0x000fe80000000800ULL,
0x0000000831007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000002107984ULL, 0x000e680000000c00ULL, 0x00040000021c7984ULL, 0x000ea80000000c00ULL,
0x0008000002147984ULL, 0x000f280000000c00ULL, 0x000c000002247984ULL, 0x000f620000000c00ULL,
0x3f803f8009137831ULL, 0x002fc40000200013ULL, 0x3f803f8009127831ULL, 0x040fe40000200012ULL,
0x3f803f8009117831ULL, 0x040fe40000200011ULL, 0x3f803f8009107831ULL, 0x040fe40000200010ULL,
0x3f803f80091f7831ULL, 0x044fe4000020001fULL, 0x3f803f80091e7831ULL, 0x040fe4000020001eULL,
0x3f803f80091d7831ULL, 0x000fc4000020001dULL, 0x3f803f80091c7831ULL, 0x000fe4000020001cULL,
0x3f803f8013137831ULL, 0x010fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fe40000200014ULL,
0x3f803f801f1f7831ULL, 0x020fc40000200027ULL, 0x3f803f801e1e7831ULL, 0x000fe20000200026ULL,
0x0000001002007388ULL, 0x0003e20000000c00ULL, 0x3f803f801d1d7831ULL, 0x000fe40000200025ULL,
0x3f803f801c1c7831ULL, 0x000fca0000200024ULL, 0x0004001c02007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000197919ULL, 0x000ea20000002600ULL,
0x00000020031d7810ULL, 0x042fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0x00000040031f7810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x00000003ff027819ULL, 0x000fe20000011603ULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x0000006003217810ULL, 0x000fe20007ffe0ffULL, 0x000000080e1a7824ULL, 0x040fe200078e00ffULL,
0x00000003ff0d7819ULL, 0x000fe2000001161dULL, 0x000000080e1e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff0f7819ULL, 0x000fc4000001161fULL, 0x00000003ff187819ULL, 0x000fe40000011621ULL,
0x000000070d047812ULL, 0x000fe400078e481dULL, 0x000000070f067812ULL, 0x000fe400078e481fULL,
0x0000000718087812ULL, 0x000fe400078e4821ULL, 0x0ffffff804077812ULL, 0x000fe400078ef81dULL,
0x0ffffff806097812ULL, 0x000fe200078ef81fULL, 0x0000001019057824ULL, 0x004fe200078e00ffULL,
0x0ffffff8080b7812ULL, 0x000fe200078ef821ULL, 0x0000001007087824ULL, 0x100fe200078e0200ULL,
0x00000004050472a4ULL, 0x002fe2000f8e023fULL, 0x0000001009107824ULL, 0x000fe200078e0200ULL,
0xfffffff0050c7812ULL, 0x000fe200078ee202ULL, 0x000000100b147824ULL, 0x000fe200078e0200ULL,
0x0000000702027812ULL, 0x000fe200078e4803ULL, 0x0000000008087984ULL, 0x000fe20000000c00ULL,
0x000000040c0c7c10ULL, 0x000fc4000ff1e0ffULL, 0x0ffffff802057812ULL, 0x000fe200078ef803ULL,
0x0000000010107984ULL, 0x000fe20000000c00ULL, 0x000000080e027824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1f7812ULL, 0x000fe200078ee21fULL, 0x00000010191a7824ULL, 0x000fe200078e00ffULL,
0x0000000014147984ULL, 0x000fe20000000c00ULL, 0x0000001005057824ULL, 0x000fe200078e0200ULL,
0xfffffff8021d7812ULL, 0x000fe200078ee21dULL, 0x000000080e007824ULL, 0x000fe200078e00ffULL,
0xfffffff01a0f7812ULL, 0x000fe400078ee20fULL, 0xfffffff81e217812ULL, 0x000fe200078ee221ULL,
0x0000000005047984ULL, 0x000e620000000c00ULL, 0xfffffff8001b7812ULL, 0x000fe200078ee203ULL,
0x0000001019007824ULL, 0x000fe200078e00ffULL, 0x000000040f0f7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001019197824ULL, 0x000fc400078e00ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a000c027a11ULL, 0x000fe200078040ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0xfffffff0000d7812ULL, 0x000fe400078ee20dULL, 0xfffffff019187812ULL, 0x000fe400078ee218ULL,
0x00005b000c037a11ULL, 0x000fe400000f4403ULL, 0x000000040d0d7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000418007c10ULL, 0x000fe2000ff5e0ffULL, 0x000000101b027825ULL, 0x000fe200078e0002ULL,
0x00005a000f0e7a11ULL, 0x000fc600078240ffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00005a000d0c7a11ULL, 0x040fe200078040ffULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x00005a0000187a11ULL, 0x040fe400078440ffULL, 0x00005b000d0d7a11ULL, 0x000fe400000f441cULL,
0x00005b000f0f7a11ULL, 0x000fe400008f441aULL, 0x00005b0000197a11ULL, 0x000fe200010f4419ULL,
0x000000101d0c7825ULL, 0x000fc800078e000cULL, 0x000000101f0e7825ULL, 0x000fc800078e000eULL,
0x0000001021187825ULL, 0x000fe200078e0018ULL, 0x0000000402007986ULL, 0x002fe8000c101d08ULL,
0x000000080c007986ULL, 0x000fe8000c101d08ULL, 0x000000100e007986ULL, 0x000fe8000c101d08ULL,
0x0000001418007986ULL, 0x000fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006800ff367624ULL, 0x000fe200078e00ffULL, 0x03ffffff18037812ULL, 0x00afe200078ec0ffULL,
0x00006900ff377624ULL, 0x000fc400078e00ffULL, 0xffffffffff197424ULL, 0x000fe400078e00ffULL,
0x000000041a147824ULL, 0x000fe200078e0203ULL, 0x0000000836367981ULL, 0x000368000c1e9900ULL,
0x000000171400720cULL, 0x000fe40003f06070ULL, 0x000000011a007810ULL, 0x000fd60007ffe0ffULL,
0x0000000202038824ULL, 0x000fc800078e00ffULL, 0x0000640003048a24ULL, 0x000fc800078e0214ULL,
0x0000600004048625ULL, 0x000fca00078e001dULL, 0x0000000804198981ULL, 0x000362000c1e1900ULL,
0x000000150000720cULL, 0x000fe20003f06070ULL, 0x000000401b127824ULL, 0x000fe400078e00ffULL,
0x0000004034347824ULL, 0x000fe400078e00ffULL, 0x00000040181b7824ULL, 0x000fd000078e00ffULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x002e620000000000ULL,
0x0000001912127224ULL, 0x020fe200078e0234ULL, 0x0000100018137811ULL, 0x000fe200078e68ffULL,
0x00000080ff227424ULL, 0x000fe200078e00ffULL, 0x00000002ff257819ULL, 0x002fe20000011610ULL,
0x0000001010277824ULL, 0x000fc600078e00ffULL, 0x0000003f25037812ULL, 0x040fe400078ec0ffULL,
0x00000008250f7810ULL, 0x000fe40007ffe0ffULL, 0x0000003027277812ULL, 0x000fe200078ec0ffULL,
0x0000000112047824ULL, 0x000fe200078e0203ULL, 0x0000003f0f077812ULL, 0x000fe200078ec0ffULL,
0x000001001a037824ULL, 0x000fe200078e021bULL, 0x0000001025297810ULL, 0x040fe20007ffe0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0022ULL, 0x00000018252b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000316007217ULL, 0x000fe20007800000ULL, 0x0000000112077824ULL, 0x000fe200078e0207ULL,
0x00000027040a7210ULL, 0x080fe20007f1e0ffULL, 0x000000040f1c7824ULL, 0x000fe200078e00ffULL,
0x0000003f29097812ULL, 0x000fe200078ec0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a03ULL,
0x00000020251f7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0007067625ULL, 0x080fe200078e0022ULL,
0x0000003f2b037812ULL, 0x000fe400078ec0ffULL, 0x0000002825217810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0605ULL, 0x0000003f1f057812ULL, 0x000fe200078ec0ffULL,
0x0000000112097824ULL, 0x000fe200078e0209ULL, 0x00000027060c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000112037824ULL, 0x000fe200078e0203ULL, 0x0000003025237810ULL, 0x000fe20007ffe0ffULL,
0x00005e0009087625ULL, 0x000fe200078e0022ULL, 0x000000002900720cULL, 0x000fc40003fa6070ULL,
0x000000002b00720cULL, 0x000fe20003f86070ULL, 0x0000000112067824ULL, 0x000fe200078e0205ULL,
0x0000002708087210ULL, 0x000fe20007f3e0ffULL, 0x00005e0003047625ULL, 0x000fc800078e0022ULL,
0x000000ffff0d7224ULL, 0x000fe200000e0607ULL, 0x00000003ff077819ULL, 0x100fe20000011610ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x00000027040e7210ULL, 0x000fe20007f5e0ffULL,
0x00000004231e7824ULL, 0x000fe200078e00ffULL, 0x0000000307037812ULL, 0x100fe200078e4810ULL,
0x00005e0006067625ULL, 0x000fe200078e0022ULL, 0x000000002500720cULL, 0x080fe40003f06070ULL,
0x000000000f00720cULL, 0x000fe20003f26070ULL, 0x000000ffff0f7224ULL, 0x000fe200010e0605ULL,
0x0ffffffc03047812ULL, 0x000fc400078ef810ULL, 0x0000003f21057812ULL, 0x000fe400078ec0ffULL,
0x0000002706107210ULL, 0x000fe20007f7e0ffULL, 0x00000010041d7824ULL, 0x000fe200078e0213ULL,
0xfffffffc1c067812ULL, 0x000fe200078ee203ULL, 0x0000000112057824ULL, 0x000fe200078e0205ULL,
0x0000003825257810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a1d7faeULL, 0x0003e2000c101c48ULL,
0x00005e0005047625ULL, 0x000fe200078e0022ULL, 0x000000001f00720cULL, 0x000fc40003f66070ULL,
0x000000002100720cULL, 0x080fe20003f46070ULL, 0x0000001006077824ULL, 0x000fe200078e0213ULL,
0x000000002500720cULL, 0x080fe20003f06070ULL, 0x00000004211c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1e1e7812ULL, 0x000fe200078ee203ULL, 0x0000000425207824ULL, 0x000fe200078e00ffULL,
0x000000000c077faeULL, 0x0005e2000c901c48ULL, 0x000000002300720cULL, 0x000fe20003f26070ULL,
0x0000000429007824ULL, 0x000fe200078e00ffULL, 0x0000003f230b7812ULL, 0x002fe200078ec0ffULL,
0x000000101e217824ULL, 0x000fe200078e0213ULL, 0x00000027040a7210ULL, 0x000fc40007fde0ffULL,
0xfffffffc00007812ULL, 0x000fe200078ee203ULL, 0x0000000112047824ULL, 0x000fe200078e020bULL,
0xfffffffc1c1c7812ULL, 0x000fe200078ee203ULL, 0x000000ffff0b7224ULL, 0x000fe200030e0605ULL,
0xfffffffc20207812ULL, 0x000fe200078ee203ULL, 0x00005e0004047625ULL, 0x000fe200078e0022ULL,
0x0000003f25077812ULL, 0x004fc600078ec0ffULL, 0x000000042b0c7824ULL, 0x000fe200078e00ffULL,
0x0000002704047210ULL, 0x000fe20007fde0ffULL, 0x0000000112077824ULL, 0x000fe400078e0207ULL,
0x000000041f127824ULL, 0x000fe200078e00ffULL, 0xfffffffc0c0c7812ULL, 0x000fe200078ee203ULL,
0x00005e0007067625ULL, 0x000fc600078e0022ULL, 0xfffffffc12127812ULL, 0x000fe200078ee203ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x0000002706067210ULL, 0x000fe20007fde0ffULL,
0x0000001000037824ULL, 0x100fe400078e0213ULL, 0x000000100c0d7824ULL, 0x100fe400078e0213ULL,
0x00000010121d7824ULL, 0x100fe200078e0213ULL, 0x0000000008037faeULL, 0x0003e2000e901c48ULL,
0x000000101c1f7824ULL, 0x100fe400078e0213ULL, 0x0000001020137824ULL, 0x000fe200078e0213ULL,
0x000000000e0d7faeULL, 0x0003e2000e101c48ULL, 0x000000ffff077224ULL, 0x000fc600030e0607ULL,
0x00000000101d7faeULL, 0x0003e8000d901c48ULL, 0x000000000a1f7faeULL, 0x0003e8000d101c48ULL,
0x0000000004217faeULL, 0x0003e8000c901c48ULL, 0x0000000006137faeULL, 0x0003e2000c101c48ULL,
0x000005a000007947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x002e620000000000ULL,
0x0000001912127224ULL, 0x020fe200078e0234ULL, 0x00000002ff037819ULL, 0x002fc40000011600ULL,
0x00000003ff057819ULL, 0x000fe40000011600ULL, 0x0000003f03077812ULL, 0x040fe400078ec0ffULL,
0x0000000803067810ULL, 0x040fe40007ffe0ffULL, 0x0000001003097810ULL, 0x040fe20007ffe0ffULL,
0x0000000112047824ULL, 0x000fe200078e0207ULL, 0x00000018030c7810ULL, 0x040fe40007ffe0ffULL,
0x00000020030d7810ULL, 0x000fc40007ffe0ffULL, 0x0000002803107810ULL, 0x040fe20007ffe0ffULL,
0x000000040c207824ULL, 0x000fe200078e00ffULL, 0x00000030031d7810ULL, 0x000fe20007ffe0ffULL,
0x000000040d247824ULL, 0x000fe200078e00ffULL, 0x00000038031f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000410287824ULL, 0x000fe200078e00ffULL, 0x0000003f06037812ULL, 0x040fe200078ec0ffULL,
0x0000000406067824ULL, 0x000fe200078e00ffULL, 0x0000003f09077812ULL, 0x000fe200078ec0ffULL,
0x000000041d2a7824ULL, 0x000fe200078e00ffULL, 0x0000003f0c0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000112087824ULL, 0x040fe200078e0203ULL, 0x0000003f0d0f7812ULL, 0x000fe200078ec0ffULL,
0x00000001120a7824ULL, 0x000fe200078e0207ULL, 0x0000003f10117812ULL, 0x000fe200078ec0ffULL,
0x00000001120e7824ULL, 0x040fe200078e020bULL, 0x0000003f1d137812ULL, 0x000fe200078ec0ffULL,
0x00000001121c7824ULL, 0x040fe200078e020fULL, 0x0000003f1f217812ULL, 0x000fe200078ec0ffULL,
0x00000001121e7824ULL, 0x040fe200078e0211ULL, 0x0000000305057812ULL, 0x100fe200078e4800ULL,
0x0000000112227824ULL, 0x000fe200078e0213ULL, 0x00001000180b7811ULL, 0x000fe200078e68ffULL,
0x0000000112267824ULL, 0x000fe200078e0221ULL, 0xfffffffc20107812ULL, 0x100fe200078ee205ULL,
0x0000000409127824ULL, 0x000fe200078e00ffULL, 0xfffffffc06067812ULL, 0x100fe200078ee205ULL,
0x000000041f2c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc28207812ULL, 0x100fe200078ee205ULL,
0x00000080ff137424ULL, 0x000fe200078e00ffULL, 0xfffffffc120c7812ULL, 0x100fe200078ee205ULL,
0x0000001000037824ULL, 0x000fe200078e00ffULL, 0xfffffffc24127812ULL, 0x000fe200078ee205ULL,
0x00000010061f7824ULL, 0x000fe200078e020bULL, 0x0ffffffc05007812ULL, 0x000fe200078ef800ULL,
0x00005e0008067625ULL, 0x000fe200078e0013ULL, 0xfffffffc2a247812ULL, 0x000fc400078ee205ULL,
0xfffffffc2c287812ULL, 0x000fe200078ee205ULL, 0x00005e0004047625ULL, 0x000fe200078e0013ULL,
0x0000003003037812ULL, 0x000fc600078ec0ffULL, 0x00000010001d7824ULL, 0x100fe200078e020bULL,
0x0000000304047210ULL, 0x080fe20007f1e0ffULL, 0x000000100c217824ULL, 0x100fe200078e020bULL,
0x0000000306067210ULL, 0x000fe20007f3e0ffULL, 0x0000001010237824ULL, 0x100fe400078e020bULL,
0x0000001012257824ULL, 0x100fe400078e020bULL, 0x0000001020277824ULL, 0x000fe400078e020bULL,
0x00005e000a087625ULL, 0x000fc800078e0013ULL, 0x0000001024297824ULL, 0x100fe200078e020bULL,
0x0000000308087210ULL, 0x000fe20007f5e0ffULL, 0x00000010282b7824ULL, 0x000fe400078e020bULL,
0x00005e000e0a7625ULL, 0x000fc800078e0013ULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x000000030a0a7210ULL, 0x000fe20007f1e0ffULL, 0x00005e001c0c7625ULL, 0x000fc600078e0013ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000041d7faeULL, 0x0003e2000b901c48ULL,
0x00005e001e0e7625ULL, 0x000fc800078e0013ULL, 0x00005e0022107625ULL, 0x000fc800078e0013ULL,
0x00005e0026127625ULL, 0x000fc800078e0013ULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x000000030c0c7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x000000030e0e7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000000310107210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000000312127210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x00000000061f7faeULL, 0x0003e2000b901c48ULL, 0x000000ffff117224ULL, 0x000fc400010e0611ULL,
0x000000ffff137224ULL, 0x000fe200018e0613ULL, 0x0000000008217faeULL, 0x0003e8000b901c48ULL,
0x000000000a237faeULL, 0x0003e8000b901c48ULL, 0x000000000c257faeULL, 0x0003e8000b901c48ULL,
0x000000000e277faeULL, 0x0003e8000b901c48ULL, 0x0000000010297faeULL, 0x0003e8000b901c48ULL,
0x00000000122b7faeULL, 0x0003e4000b901c48ULL, 0x00f60400ff007984ULL, 0x000ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000000ff7812ULL, 0x004fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000037305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000030000735dULL, 0x004fe40003800000ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000031800780cULL, 0x000fda0003f04070ULL, 0x0000017000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x002e640000000000ULL, 0x0000002018007824ULL, 0x002fc800078e0203ULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x00000003ff037819ULL, 0x000fc80000011600ULL,
0x1ffffffe03037812ULL, 0x000fe400078ec0ffULL, 0x000000f004047812ULL, 0x000fe400078ec0ffULL,
0x0000000103057812ULL, 0x040fe400078efcffULL, 0x0000000703037812ULL, 0x100fe400078e7800ULL,
0x0000000705057812ULL, 0x000fc600078e7800ULL, 0x0000000103037824ULL, 0x000fe400078e0204ULL,
0x0000000104057824ULL, 0x000fc600078e0205ULL, 0x00000000030c7984ULL, 0x000e68000000cc00ULL,
0x0000000005087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001003007388ULL, 0x0003e8000000cc00ULL,
0x0000000c05007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ffff7f8cULL, 0x000fe8000c80043fULL, 0x00f60400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000037305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000030000735dULL, 0x004fe40003800000ULL, 0x00f60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000151a00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000357919ULL, 0x000ea20000000000ULL,
0x3db504f336367820ULL, 0x000fe20000410000ULL, 0x0000640002377a24ULL, 0x000fe200078e02ffULL,
0xffffffff15397810ULL, 0x000fe20007ffe0ffULL, 0x0000001018387824ULL, 0x000fe200078e00ffULL,
0x00007610ff3a7816ULL, 0x000fe2000000003aULL, 0x000000ffff3b7224ULL, 0x000fe200078e00ffULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x0000000604047899ULL, 0x000fe4000800063fULL,
0x000001001a3d7824ULL, 0x000fe200078e021bULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000003d1600720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x028fea0003800000ULL,
0x000000ffff3f7224ULL, 0x000fe200078e003bULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x002fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x0000000100037810ULL, 0x000fe20007ffe0ffULL, 0x00000bb000007945ULL, 0x000fe20003800000ULL,
0x000000013f3b7812ULL, 0x000fc400078e0cffULL, 0x00000001ff297819ULL, 0x000fe40000011603ULL,
0x000000020300780cULL, 0x040fe40003f06070ULL, 0x00000001034c7812ULL, 0x000fe200078ec0ffULL,
0x0000030029287a24ULL, 0x000fca00078e021aULL, 0x0000000128027810ULL, 0x000fc80007ffe0ffULL,
0x000000150200720cULL, 0x000fe20003f26070ULL, 0x000000ffff027224ULL, 0x000fe400078e0000ULL,
0x000000ffff007224ULL, 0x000fd400078e0003ULL, 0x000005e000009947ULL, 0x020fea0003800000ULL,
0x0000010028037824ULL, 0x000fe200078e021bULL, 0x00000002ff327819ULL, 0x004fe20000011635ULL,
0x000000044c3e7824ULL, 0x000fe400078e00ffULL, 0x00000004193c7c24ULL, 0x000fe2000f8e0234ULL,
0x0000000316287217ULL, 0x000fe20007800000ULL, 0x0000000218307824ULL, 0x000fe200078e023bULL,
0x00000008322a7810ULL, 0x040fe20007ffe0ffULL, 0x00000080ff427424ULL, 0x000fe200078e00ffULL,
0x0000003f32297812ULL, 0x000fe200078ec0ffULL, 0x0000000128037824ULL, 0x000fe200078e0a03ULL,
0x0000003f2a2b7812ULL, 0x040fe200078ec0ffULL, 0x000000042a337824ULL, 0x000fe200078e00ffULL,
0x00000003ff287819ULL, 0x000fe20000011635ULL, 0x000000013c297824ULL, 0x000fe200078e0229ULL,
0xfffffffc3e457812ULL, 0x000fe200078ee235ULL, 0x000000013c2b7824ULL, 0x000fe200078e022bULL,
0x00000003283e7812ULL, 0x000fe200078e4835ULL, 0x00005e0029287625ULL, 0x000fe200078e0042ULL,
0x000000033200720cULL, 0x000fc40003f26070ULL, 0x000000032a00720cULL, 0x080fe20003f46070ULL,
0x00005e002b2a7625ULL, 0x000fe200078e0042ULL, 0x0000100030307811ULL, 0x000fe400078e60ffULL,
0x0ffffffc3e317812ULL, 0x000fe200078ef835ULL, 0x0000001045287825ULL, 0x000fe200078e0028ULL,
0xfffffffc33337812ULL, 0x000fe400078ee23eULL, 0x0000001032407810ULL, 0x040fe20007ffe0ffULL,
0x0000001031317824ULL, 0x100fe200078e0230ULL, 0x0000001832447810ULL, 0x040fe20007ffe0ffULL,
0x0000001033337824ULL, 0x000fe200078e0230ULL, 0x0000002032467810ULL, 0x040fe20007ffe0ffULL,
0x00000010452a7825ULL, 0x000fe200078e002aULL, 0x0000002832487810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028317faeULL, 0x0003e2000c901c48ULL,
0x00000030324a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000444477824ULL, 0x000fe200078e00ffULL,
0x0000003832327810ULL, 0x000fe20007ffe0ffULL, 0x000000002a337faeULL, 0x0005e2000d101c48ULL,
0x000000034000720cULL, 0x080fe20003f26070ULL, 0x0000000446497824ULL, 0x000fe200078e00ffULL,
0x000000034400720cULL, 0x080fe20003f46070ULL, 0x00000004484b7824ULL, 0x000fe200078e00ffULL,
0x000000034600720cULL, 0x080fe20003f66070ULL, 0x000000044a4d7824ULL, 0x000fe200078e00ffULL,
0x000000034800720cULL, 0x080fe20003f86070ULL, 0x00000004324f7824ULL, 0x000fe200078e00ffULL,
0x000000034a00720cULL, 0x000fc40003fa6070ULL, 0x000000033200720cULL, 0x000fe40003fc6070ULL,
0x0000003f40037812ULL, 0x000fe400078ec0ffULL, 0x0000003f442b7812ULL, 0x004fe400078ec0ffULL,
0x0000003f46317812ULL, 0x002fe200078ec0ffULL, 0x000000013c297824ULL, 0x000fe200078e0203ULL,
0x0000003f48337812ULL, 0x000fe200078ec0ffULL, 0x0000000440037824ULL, 0x000fe200078e00ffULL,
0x0000003f4a417812ULL, 0x000fe200078ec0ffULL, 0x000000013c2b7824ULL, 0x000fe200078e022bULL,
0x0000003f32437812ULL, 0x000fe200078ec0ffULL, 0x000000013c317824ULL, 0x040fe200078e0231ULL,
0xfffffffc03037812ULL, 0x100fe200078ee23eULL, 0x000000013c337824ULL, 0x040fe200078e0233ULL,
0xfffffffc47477812ULL, 0x100fe200078ee23eULL, 0x000000013c417824ULL, 0x000fe200078e0241ULL,
0xfffffffc49497812ULL, 0x100fe200078ee23eULL, 0x00005e0029287625ULL, 0x000fe200078e0042ULL,
0xfffffffc4b4b7812ULL, 0x000fc400078ee23eULL, 0xfffffffc4d4d7812ULL, 0x100fe200078ee23eULL,
0x000000013c437824ULL, 0x000fe200078e0243ULL, 0xfffffffc4f4f7812ULL, 0x000fe200078ee23eULL,
0x0000001003037824ULL, 0x100fe400078e0230ULL, 0x0000001047477824ULL, 0x100fe400078e0230ULL,
0x0000001049497824ULL, 0x100fe400078e0230ULL, 0x000000104b4b7824ULL, 0x100fe400078e0230ULL,
0x000000104d4d7824ULL, 0x000fc400078e0230ULL, 0x000000104f4f7824ULL, 0x000fe400078e0230ULL,
0x00005e002b2a7625ULL, 0x000fc800078e0042ULL, 0x00005e0031307625ULL, 0x000fc800078e0042ULL,
0x00005e0033327625ULL, 0x000fc800078e0042ULL, 0x00005e0041407625ULL, 0x000fc800078e0042ULL,
0x00005e0043427625ULL, 0x000fc800078e0042ULL, 0x0000001045287825ULL, 0x000fc800078e0028ULL,
0x00000010452a7825ULL, 0x040fe200078e002aULL, 0x0000000028037faeULL, 0x0003e6000c901c48ULL,
0x0000001045307825ULL, 0x040fe200078e0030ULL, 0x000000002a477faeULL, 0x0003e6000d101c48ULL,
0x0000001045327825ULL, 0x040fe200078e0032ULL, 0x0000000030497faeULL, 0x0003e6000d901c48ULL,
0x0000001045407825ULL, 0x040fe200078e0040ULL, 0x00000000324b7faeULL, 0x0003e6000e101c48ULL,
0x0000001045427825ULL, 0x000fe200078e0042ULL, 0x00000000404d7faeULL, 0x0003e8000e901c48ULL,
0x00000000424f7faeULL, 0x0003e2000f101c48ULL, 0x0000052000007947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x004fe20000011635ULL, 0x0000000419287c24ULL, 0x000fc4000f8e0234ULL,
0x000000044c2a7824ULL, 0x000fe200078e00ffULL, 0x0000000803317810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff467424ULL, 0x000fe200078e00ffULL, 0x0000001003327810ULL, 0x040fe40007ffe0ffULL,
0x00000018033c7810ULL, 0x040fe40007ffe0ffULL, 0x00000020033e7810ULL, 0x040fe40007ffe0ffULL,
0x0000002803407810ULL, 0x040fe40007ffe0ffULL, 0x0000003003427810ULL, 0x040fe20007ffe0ffULL,
0x000000043e537824ULL, 0x000fe200078e00ffULL, 0x0000003803447810ULL, 0x040fe20007ffe0ffULL,
0x0000000440577824ULL, 0x000fe200078e00ffULL, 0x0000003f03297812ULL, 0x000fe200078ec0ffULL,
0x00000004425b7824ULL, 0x000fe200078e00ffULL, 0x0000003f31037812ULL, 0x040fe200078ec0ffULL,
0x0000000431317824ULL, 0x000fe200078e00ffULL, 0x0000003f322b7812ULL, 0x000fe200078ec0ffULL,
0x0000000128297824ULL, 0x000fe200078e0229ULL, 0x0000003f3c437812ULL, 0x000fe200078ec0ffULL,
0x0000000128337824ULL, 0x000fe200078e0203ULL, 0x0000003f3e477812ULL, 0x000fe200078ec0ffULL,
0x0000000128417824ULL, 0x000fe200078e022bULL, 0x0000003f40497812ULL, 0x000fe200078ec0ffULL,
0x0000000128457824ULL, 0x000fe200078e0243ULL, 0x0000003f424b7812ULL, 0x000fe200078ec0ffULL,
0x0000000128517824ULL, 0x000fe200078e0247ULL, 0x0000003f444d7812ULL, 0x000fe200078ec0ffULL,
0x0000000128557824ULL, 0x000fe200078e0249ULL, 0xfffffffc2a037812ULL, 0x000fe200078ee235ULL,
0x0000000128597824ULL, 0x000fc400078e024bULL, 0x00000001285d7824ULL, 0x000fe200078e024dULL,
0x00000003ff287819ULL, 0x000fe20000011635ULL, 0x00000002182b7824ULL, 0x000fe400078e023bULL,
0x0000000432437824ULL, 0x000fe200078e00ffULL, 0x00000003282a7812ULL, 0x100fe200078e4835ULL,
0x000000043c477824ULL, 0x000fe200078e00ffULL, 0x000010002b307811ULL, 0x000fe200078e60ffULL,
0x00000004445f7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc2a2b7812ULL, 0x000fe200078ef835ULL,
0x00005e0029287625ULL, 0x000fe200078e0046ULL, 0xfffffffc31317812ULL, 0x000fc400078ee22aULL,
0xfffffffc43437812ULL, 0x000fe200078ee22aULL, 0x000000102b497824ULL, 0x000fe200078e0230ULL,
0xfffffffc47477812ULL, 0x000fe200078ee22aULL, 0x00000010314b7824ULL, 0x000fe200078e0230ULL,
0xfffffffc53537812ULL, 0x000fe200078ee22aULL, 0x00000010434d7824ULL, 0x000fe200078e0230ULL,
0xfffffffc57577812ULL, 0x000fe200078ee22aULL, 0x00000010474f7824ULL, 0x000fe200078e0230ULL,
0xfffffffc5b5b7812ULL, 0x000fe200078ee22aULL, 0x0000001053537824ULL, 0x000fe200078e0230ULL,
0xfffffffc5f5f7812ULL, 0x000fe200078ee22aULL, 0x0000001057577824ULL, 0x000fc400078e0230ULL,
0x000000105b5b7824ULL, 0x100fe400078e0230ULL, 0x000000105f5f7824ULL, 0x000fe400078e0230ULL,
0x00005e00332a7625ULL, 0x000fc800078e0046ULL, 0x00005e0041307625ULL, 0x000fc800078e0046ULL,
0x00005e0045327625ULL, 0x000fc800078e0046ULL, 0x00005e0051407625ULL, 0x000fc800078e0046ULL,
0x00005e0055427625ULL, 0x000fc800078e0046ULL, 0x0000001003287825ULL, 0x000fc800078e0028ULL,
0x00005e0059447625ULL, 0x080fe200078e0046ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028497faeULL, 0x0003e6000b901c48ULL, 0x00005e005d467625ULL, 0x000fc800078e0046ULL,
0x00000010032a7825ULL, 0x000fc800078e002aULL, 0x0000001003307825ULL, 0x040fe200078e0030ULL,
0x000000002a4b7faeULL, 0x0003e6000b901c48ULL, 0x0000001003327825ULL, 0x040fe200078e0032ULL,
0x00000000304d7faeULL, 0x0003e6000b901c48ULL, 0x0000001003407825ULL, 0x040fe200078e0040ULL,
0x00000000324f7faeULL, 0x0003e6000b901c48ULL, 0x0000001003427825ULL, 0x040fe200078e0042ULL,
0x0000000040537faeULL, 0x0003e6000b901c48ULL, 0x0000001003447825ULL, 0x040fe200078e0044ULL,
0x0000000042577faeULL, 0x0003e6000b901c48ULL, 0x0000001003467825ULL, 0x000fe200078e0046ULL,
0x00000000445b7faeULL, 0x0003e8000b901c48ULL, 0x00000000465f7faeULL, 0x0003e4000b901c48ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff4c00720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x00000004ff297424ULL, 0x002fe400078e00ffULL, 0xffffffffff197424ULL, 0x000fe400078e00ffULL,
0x0000030029147a24ULL, 0x000fca00078e0214ULL, 0x000000171400720cULL, 0x000fda0003f26070ULL,
0x0000003000001947ULL, 0x000fea0003800000ULL, 0x0000000237287824ULL, 0x000fc800078e0214ULL,
0x0000600028287625ULL, 0x000fca00078e0029ULL, 0x0000000828197981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008023e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff835027812ULL, 0x040fe200078ec0ffULL,
0x0000000218287824ULL, 0x002fe200078e023fULL, 0x00000020352a7810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000702027812ULL, 0x000fe400078ef835ULL,
0xfffffff82a2a7812ULL, 0x000fc400078ec0ffULL, 0x00000001ff037819ULL, 0x000fe40000011602ULL,
0x000000072a2a7812ULL, 0x000fe400078ef835ULL, 0x0000000303037812ULL, 0x000fe400078ec0ffULL,
0x00000001ff2b7819ULL, 0x000fe4000001162aULL, 0x0000003c03297212ULL, 0x000fe400078e3cffULL,
0x000000032b2b7812ULL, 0x000fc400078ec0ffULL, 0x000000013c307810ULL, 0x000fe20007ffe0ffULL,
0x0000000402297824ULL, 0x000fe200078e0229ULL, 0x0000100028287811ULL, 0x000fe400078e60ffULL,
0x0000003c2b317212ULL, 0x000fe400078e3cffULL, 0x0000003003037212ULL, 0x080fe200078e3cffULL,
0x0000001029297824ULL, 0x100fe200078e0228ULL, 0x000000302b2b7212ULL, 0x000fe200078e3cffULL,
0x000000042a317824ULL, 0x000fe200078e0231ULL, 0x0000000735327812ULL, 0x000fe200078ec0ffULL,
0x0000000402037824ULL, 0x000fe200078e0203ULL, 0x000000002944783bULL, 0x000e620000000200ULL,
0x000000042a2b7824ULL, 0x000fe200078e022bULL, 0x00000008325c7812ULL, 0x000fe200078ef835ULL,
0x0000001031407824ULL, 0x100fe200078e0228ULL, 0x0000003e35027211ULL, 0x000fe200078fe0ffULL,
0x0000001003317824ULL, 0x100fe200078e0228ULL, 0x000000023c3c7810ULL, 0x000fe20007ffe0ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0228ULL, 0x0000000202037810ULL, 0x040fe20007ffe0ffULL,
0x000000004040783bULL, 0x000fe20000000200ULL, 0x00000007024d7812ULL, 0x000fc400078e785cULL,
0x0000000703037812ULL, 0x000fe200078e785cULL, 0x000000003130783bULL, 0x000ea20000000200ULL,
0x000000043c00780cULL, 0x000fe20003f25270ULL, 0x000000105c4d7824ULL, 0x000fe200078e024dULL,
0x000000043e3e7810ULL, 0x000fe20007ffe0ffULL, 0x000000002b28783bULL, 0x000ee20000000200ULL,
0x000000105c5c7824ULL, 0x000fe200078e0203ULL, 0x00000010ff7b7819ULL, 0x002fe40000011644ULL,
0x0000ffff447c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff7b7b7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff787819ULL, 0x000fe40000011645ULL,
0x0000ffff46717812ULL, 0x000fe400078ec0ffULL, 0x0000ffff45747812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4c7819ULL, 0x104fe40000011632ULL, 0x00000018ff7f7819ULL, 0x000fc40000011632ULL,
0x000000ff32807812ULL, 0x040fe400078ec0ffULL, 0x0000ffff324e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff327819ULL, 0x108fe40000011628ULL, 0x00000018ff517819ULL, 0x000fe40000011628ULL,
0x000000ff28527812ULL, 0x040fe400078ec0ffULL, 0x0000ffff285b7812ULL, 0x000fc400078ec0ffULL,
0x0000007bff28723eULL, 0x000fe400020006ffULL, 0x0000007cff7b723eULL, 0x000fe400020006ffULL,
0x000000ff78787812ULL, 0x000fe200078ec0ffULL, 0x20000028ff7c7230ULL, 0x000fe20000004100ULL,
0x00000008ff287819ULL, 0x000fe20000011671ULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000008ff747819ULL, 0x000fe40000011674ULL, 0x00000078ff78723eULL, 0x000fc400020006ffULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000010ff5d7819ULL, 0x100fe40000011640ULL,
0x00000018ff667819ULL, 0x000fe40000011640ULL, 0x000000ff40677812ULL, 0x040fe400078ec0ffULL,
0x0000ffff405e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff41627812ULL, 0x000fc400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe40000011642ULL, 0x00000010ff5a7819ULL, 0x100fe40000011629ULL,
0x00000018ff537819ULL, 0x000fe40000011629ULL, 0x000000ff29547812ULL, 0x040fe400078ec0ffULL,
0x0000ffff29407812ULL, 0x000fe400078ec0ffULL, 0x00000074ff29723eULL, 0x000fe200020006ffULL,
0x20000078ff747230ULL, 0x000fe20000004100ULL, 0x00000010ff617819ULL, 0x000fe20000011631ULL,
0x20000028ff787230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fc400020006ffULL,
0x00000010ff737819ULL, 0x000fe40000011646ULL, 0x00000065ff28723eULL, 0x000fe200020006ffULL,
0x20000062ff657230ULL, 0x000fe20000004100ULL, 0x000000ff434b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff707819ULL, 0x000fe20000011647ULL, 0x20000028ff627230ULL, 0x000fe20000004100ULL,
0x000000ff61617812ULL, 0x000fe400078ec0ffULL, 0x000000ff73737812ULL, 0x000fc400078ec0ffULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x0000ffff476f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff027819ULL, 0x100fe40000011641ULL, 0x00000018ff607819ULL, 0x000fe40000011641ULL,
0x0000ffff41037812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6b7819ULL, 0x000fc40000011642ULL,
0x000000ff42637812ULL, 0x040fe400078ec0ffULL, 0x0000ffff426e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff70707812ULL, 0x000fe400078ec0ffULL, 0x00000061ff28723eULL, 0x000fe200020006ffULL,
0x2000004bff617230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x100fe4000001162aULL,
0x00000018ff557819ULL, 0x000fe2000001162aULL, 0x20000028ff4b7230ULL, 0x000fe20000004100ULL,
0x000000ff2a5f7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff2a427812ULL, 0x000fe400078ec0ffULL,
0x00000073ff2a723eULL, 0x000fe200020006ffULL, 0x20000029ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff6f7819ULL, 0x000fe4000001166fULL, 0x00000070ff29723eULL, 0x000fe200020006ffULL,
0x2000002aff717230ULL, 0x000fe20000004100ULL, 0x000000ff4c287812ULL, 0x000fe400078ec0ffULL,
0x0000006fff70723eULL, 0x000fe200020006ffULL, 0x20000029ff6f7230ULL, 0x000fe20000004100ULL,
0x00000028ff29723eULL, 0x000fe200020006ffULL, 0x000000104d287824ULL, 0x000fe200078e00ffULL,
0x00000010ff687819ULL, 0x100fe20000011643ULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000018ff7a7819ULL, 0x000fe20000011643ULL, 0x20000029ff4d7230ULL, 0x000fe20000004100ULL,
0x0000ffff43647812ULL, 0x000fc400078ec0ffULL, 0x00000010ff437819ULL, 0x100fe4000001162bULL,
0x00000018ff767819ULL, 0x000fe4000001162bULL, 0x000000ff2b757812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2b497812ULL, 0x000fe400078ec0ffULL, 0x000000002828783bULL, 0x000e620000000200ULL,
0x0000ffff31797812ULL, 0x000fe400078ec0ffULL, 0x00000018ff487819ULL, 0x000fc40000011644ULL,
0x00000008ff797819ULL, 0x000fe40000011679ULL, 0x000000ff444a7812ULL, 0x000fe400078ec0ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000010ff4f7819ULL, 0x100fe40000011633ULL,
0x00000018ff817819ULL, 0x000fe20000011633ULL, 0x20000079ff4c7230ULL, 0x000fe20000004100ULL,
0x000000ff33827812ULL, 0x000fc400078ec0ffULL, 0x0000ffff33507812ULL, 0x000fe400078ec0ffULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x00000060ff33723eULL, 0x000fe200020006ffULL, 0x20000048ff727230ULL, 0x000fe20000004100ULL,
0x0000007aff60723eULL, 0x000fe200020006ffULL, 0x2000004aff777230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000033ff337230ULL, 0x000fe20000004100ULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000008ff5e7819ULL, 0x000fc4000001165eULL, 0x00000076ff7a723eULL, 0x000fe400020006ffULL,
0x00000075ff79723eULL, 0x000fe400020006ffULL, 0x0000005dff76723eULL, 0x000fe200020006ffULL,
0x2000005fff5d7230ULL, 0x000fe20000004100ULL, 0x0000005eff75723eULL, 0x000fe200020006ffULL,
0x2000007aff5e7230ULL, 0x000fe20000004100ULL, 0x00000018ff447819ULL, 0x000fe20000011645ULL,
0x20000079ff5f7230ULL, 0x000fe20000004100ULL, 0x000000ff45567812ULL, 0x000fe200078ec0ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00000018ff457819ULL, 0x000fe20000011646ULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x000000ff46577812ULL, 0x000fc400078ec0ffULL,
0x000000ff027a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff797819ULL, 0x000fe40000011603ULL,
0x00000018ff467819ULL, 0x000fe40000011647ULL, 0x000000ff47697812ULL, 0x000fe400078ec0ffULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff027819ULL, 0x000fc40000011677ULL,
0x00000010ff037819ULL, 0x000fe4000001167cULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff587819ULL, 0x100fe40000011630ULL, 0x00000018ff477819ULL, 0x000fe40000011630ULL,
0x000000ff306a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff30597812ULL, 0x000fc400078ec0ffULL,
0x00000018ff7d7819ULL, 0x000fe40000011631ULL, 0x000000ff317e7812ULL, 0x000fe400078ec0ffULL,
0x00000044ff30723eULL, 0x000fe400020006ffULL, 0x00000056ff31723eULL, 0x000fe400020006ffULL,
0x0000105472037816ULL, 0x000fe20000000003ULL, 0x20000030ff307230ULL, 0x000fe20000004100ULL,
0x000010547b027816ULL, 0x000fe20000000002ULL, 0x20000031ff317230ULL, 0x000fe20000004100ULL,
0x00000057ff57723eULL, 0x000fc400020006ffULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x00000002282c723cULL, 0x002fe2000004182cULL,
0x20000057ff6d7230ULL, 0x000fe20000004100ULL, 0x00000046ff46723eULL, 0x000fe200020006ffULL,
0x20000045ff6c7230ULL, 0x000fe20000004100ULL, 0x0000006aff57723eULL, 0x000fe200020006ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x20000046ff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff027819ULL, 0x000fe20000011630ULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000010ff307819ULL, 0x000fe20000011631ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff317819ULL, 0x000fc40000011674ULL,
0x00000010ff037819ULL, 0x000fe40000011673ULL, 0x0000105402317816ULL, 0x000fe40000000031ULL,
0x0000105403307816ULL, 0x000fe40000000030ULL, 0x00000010ff027819ULL, 0x000fe4000001166dULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff037819ULL, 0x000fe20000011671ULL,
0x000000302824723cULL, 0x000fe20000041824ULL, 0x00000010ff6d7819ULL, 0x000fc40000011678ULL,
0x000010546c037816ULL, 0x000fe40000000003ULL, 0x000010546d027816ULL, 0x000fe40000000002ULL,
0x00000010ff307819ULL, 0x000fe40000011669ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000010ff6a7819ULL, 0x000fe2000001166aULL, 0x000000022804723cULL, 0x000fe20000041804ULL,
0x00000010ff317819ULL, 0x000fe2000001166fULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000010ff697819ULL, 0x000fc40000011670ULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x000010546a317816ULL, 0x000fe20000000031ULL,
0x20000079ff727230ULL, 0x000fe20000004100ULL, 0x0000105469307816ULL, 0x000fe40000000030ULL,
0x000000ff6b777812ULL, 0x000fe400078ec0ffULL, 0x00000010ff667819ULL, 0x000fc40000011666ULL,
0x00000010ff037819ULL, 0x000fe20000011676ULL, 0x000000302808723cULL, 0x000fe20000041808ULL,
0x00000008ff6b7819ULL, 0x000fe2000001166eULL, 0x2000007aff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff027819ULL, 0x000fe40000011667ULL,
0x0000105466037816ULL, 0x000fe40000000003ULL, 0x00000064ff67723eULL, 0x000fc400020006ffULL,
0x000000ff32667812ULL, 0x000fe200078ec0ffULL, 0x000000105c327824ULL, 0x000fe200078e00ffULL,
0x00000010ff307819ULL, 0x000fe20000011633ULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe40000011665ULL, 0x00000010ff317819ULL, 0x000fe40000011672ULL,
0x00000010ff657819ULL, 0x000fe4000001166eULL, 0x0000105431647816ULL, 0x000fc40000000064ULL,
0x0000105430657816ULL, 0x000fe40000000065ULL, 0x000000003230783bULL, 0x000e620000000200ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000077ff79723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x000000642810723cULL, 0x000fe20000041810ULL,
0x0000006bff77723eULL, 0x000fe200020006ffULL, 0x20000079ff6b7230ULL, 0x000fe20000004100ULL,
0x0000105475027816ULL, 0x000fe20000000002ULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x000000ff58587812ULL, 0x000fe200078ec0ffULL, 0x20000077ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff597819ULL, 0x000fc40000011659ULL, 0x00000010ff627819ULL, 0x000fe20000011662ULL,
0x00000002280c723cULL, 0x000fe2000004180cULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000010ff027819ULL, 0x000fe20000011663ULL, 0x20000047ff567230ULL, 0x000fe20000004100ULL,
0x00000010ff037819ULL, 0x000fe2000001166bULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x0000105462037816ULL, 0x000fe40000000003ULL,
0x0000105473027816ULL, 0x000fe20000000002ULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4e7819ULL, 0x000fe4000001164eULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x00000002281c723cULL, 0x000fe2000004181cULL,
0x00000010ff567819ULL, 0x000fc40000011656ULL, 0x00000010ff597819ULL, 0x000fe20000011659ULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000080ff44723eULL, 0x000fe400020006ffULL,
0x00000010ff027819ULL, 0x000fe40000011657ULL, 0x00000010ff037819ULL, 0x000fe20000011658ULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x000000ff4f4f7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff507819ULL, 0x000fe20000011650ULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x0000105456037816ULL, 0x000fe40000000003ULL,
0x0000105459027816ULL, 0x000fe40000000002ULL, 0x0000007fff45723eULL, 0x000fe400020006ffULL,
0x00000008ff627819ULL, 0x000fe4000001165bULL, 0x000000ff5a637812ULL, 0x000fe200078ec0ffULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000081ff48723eULL, 0x000fe200020006ffULL,
0x00000002302c723cULL, 0x002fe2000004182cULL, 0x00000082ff47723eULL, 0x000fc400020006ffULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000050ff50723eULL, 0x000fe200020006ffULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff607819ULL, 0x000fe20000011660ULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff5a7819ULL, 0x000fe20000011661ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000010ff5b7819ULL, 0x000fe40000011668ULL, 0x00000010ff677819ULL, 0x000fc40000011667ULL,
0x0000007eff4a723eULL, 0x000fe400020006ffULL, 0x00001054605b7816ULL, 0x000fe4000000005bULL,
0x00001054675a7816ULL, 0x000fe2000000005aULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff447819ULL, 0x000fe40000011644ULL, 0x00000010ff037819ULL, 0x000fe4000001164eULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x0000005a2820723cULL, 0x000fe20000041820ULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x00000010ff027819ULL, 0x000fe20000011645ULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff457819ULL, 0x000fe2000001164dULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x0000105403447816ULL, 0x000fe40000000044ULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff037819ULL, 0x000fc4000001164fULL, 0x00000010ff507819ULL, 0x000fe40000011650ULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000010ff4a7819ULL, 0x000fe2000001164aULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fe2000001164cULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000008ff407819ULL, 0x000fc40000011640ULL, 0x000000ff41417812ULL, 0x000fe400078ec0ffULL,
0x0000105402457816ULL, 0x000fe40000000045ULL, 0x0000105448037816ULL, 0x000fe40000000003ULL,
0x0000105450027816ULL, 0x000fe40000000047ULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x000000443004723cULL, 0x000fe20000041804ULL, 0x00000066ff5c723eULL, 0x000fc400020006ffULL,
0x00001054294a7816ULL, 0x000fe2000000004aULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x000000023008723cULL, 0x000fe20000041808ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fe20000011652ULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fe20000011662ULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x00000008ff427819ULL, 0x000fc40000011642ULL, 0x000000ff43437812ULL, 0x000fe400078ec0ffULL,
0x00000008ff497819ULL, 0x000fe40000011649ULL, 0x00001054292a7816ULL, 0x000fe40000000052ULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x2000007dff467230ULL, 0x000fe20000004100ULL,
0x00000010ff027819ULL, 0x000fe20000011653ULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fe20000011663ULL, 0x20000043ff447230ULL, 0x000fe20000004100ULL,
0x00000049ff49723eULL, 0x000fc400020006ffULL, 0x00000010ff287819ULL, 0x000fe40000011651ULL,
0x00000010ff2b7819ULL, 0x000fe2000001165cULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x0000105402297816ULL, 0x000fe40000000029ULL, 0x00000010ff547819ULL, 0x000fe40000011654ULL,
0x00000010ff037819ULL, 0x000fe40000011640ULL, 0x00000010ff027819ULL, 0x000fc40000011655ULL,
0x00000010ff417819ULL, 0x000fe40000011641ULL, 0x00001054282b7816ULL, 0x000fe4000000002bULL,
0x0000105403287816ULL, 0x000fe40000000054ULL, 0x0000105402437816ULL, 0x000fe40000000041ULL,
0x00000010ff467819ULL, 0x000fe20000011646ULL, 0x0000002a300c723cULL, 0x000fe2000004180cULL,
0x00000010ff4b7819ULL, 0x000fc4000001164bULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x000000283010723cULL, 0x000fe20000041810ULL, 0x00000010ff037819ULL, 0x000fe40000011644ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff027819ULL, 0x000fc40000011649ULL,
0x00001054464b7816ULL, 0x000fe4000000004bULL, 0x0000105442427816ULL, 0x000fe4000000005dULL,
0x000010545e037816ULL, 0x000fe40000000003ULL, 0x0000105402027816ULL, 0x000fe2000000005fULL,
0x0000004a3024723cULL, 0x040ff00000041824ULL, 0x00000042301c723cULL, 0x040ff0000004181cULL,
0x000000023020723cULL, 0x000fe20000041820ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe82000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff3f7224ULL, 0x000fe200078e003bULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffdb1000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00f6140038037984ULL, 0x000e620000000800ULL, 0x0000ffff3a007812ULL, 0x000fe200078ec0ffULL,
0x0000002d362d7220ULL, 0x040fe20000410000ULL, 0x0000002436247220ULL, 0x040fe20000410000ULL,
0x00000004362a7220ULL, 0x000fe20000410000ULL, 0x00008880003e7816ULL, 0x000fe200000000ffULL,
0x0000000536297220ULL, 0x040fe20000410000ULL, 0x0000001136117220ULL, 0x040fe20000410000ULL,
0x0000001c361c7220ULL, 0x040fe20000410000ULL, 0x0000001d361d7220ULL, 0x000fe20000410000ULL,
0x800000003e007824ULL, 0x000fe200078e00ffULL, 0x0000002c362c7220ULL, 0x040fe20000410000ULL,
0x0000002e36027220ULL, 0x040fe20000410000ULL, 0x0000002f36307220ULL, 0x040fe20000410000ULL,
0x00000025362b7220ULL, 0x040fe20000410000ULL, 0x0000002636317220ULL, 0x040fe20000410000ULL,
0x0000002736327220ULL, 0x040fe20000410000ULL, 0x0000000636067220ULL, 0x040fe20000410000ULL,
0x0000000736077220ULL, 0x040fe20000410000ULL, 0x0000000b36047220ULL, 0x040fe20000410000ULL,
0x0000001036107220ULL, 0x040fe20000410000ULL, 0x0000001f36057220ULL, 0x040fe20000410000ULL,
0x0000000d36257220ULL, 0x040fe20000410000ULL, 0x0000000836287220ULL, 0x040fe20000410000ULL,
0x0000000c36267220ULL, 0x040fe20000410000ULL, 0x00000012360d7220ULL, 0x040fe20000410000ULL,
0x00000021361f7220ULL, 0x040fe20000410000ULL, 0x0000002236337220ULL, 0x040fe20000410000ULL,
0x00000023363c7220ULL, 0x040fe20000410000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e002dULL,
0x0000000936277220ULL, 0x040fe20000410000ULL, 0x0000000a36087220ULL, 0x040fe20000410000ULL,
0x0000000f360c7220ULL, 0x040fe20000410000ULL, 0x0000001e36127220ULL, 0x040fe20000410000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0024ULL, 0x0000000e360e7220ULL, 0x040fe20000410000ULL,
0x000000ffff237224ULL, 0x000fe200078e0011ULL, 0x0000001336137220ULL, 0x040fe20000410000ULL,
0x000000ffff227224ULL, 0x000fe200078e001cULL, 0x0000002036207220ULL, 0x000fe20000410000ULL,
0x000000ffff217224ULL, 0x000fe200078e001dULL, 0x8000000003ff7812ULL, 0x002fe20007804800ULL,
0x000000ffff2f7224ULL, 0x000fc400078e002cULL, 0x000000ffff247224ULL, 0x000fe400078e0010ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0002ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0030ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0031ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0032ULL,
0x000000ffff0a7224ULL, 0x000fc400078e0006ULL, 0x000000ffff097224ULL, 0x000fe400078e0007ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0004ULL, 0x000000ffff117224ULL, 0x000fe200078e0005ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe400078e0033ULL, 0x000000ffff037224ULL, 0x000fe200078e003cULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000003e057824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x00f6140038027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000435007824ULL, 0x000fe200078e00ffULL,
0x000000391a00720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff000057812ULL, 0x000fca00078ec0ffULL, 0x0000008018027824ULL, 0x000fca00078e0205ULL,
0x00f4000002047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x00000002352c7824ULL, 0x000fe400078e00ffULL, 0x00000001163d7824ULL, 0x000fc600078e0a3dULL,
0x000000062c2c7812ULL, 0x000fc800078ec0ffULL, 0x000000012c307812ULL, 0x040fe400078efcffULL,
0x000000082c327812ULL, 0x000fe400078efcffULL, 0x0000003d3000720cULL, 0x080fe40003f26070ULL,
0x000000102c307812ULL, 0x000fe400078efcffULL, 0x0000003d3200720cULL, 0x080fe40003f06070ULL,
0x0000003d3000720cULL, 0x000fc40003fc6070ULL, 0x000000112c327812ULL, 0x040fe400078efcffULL,
0x000000182c307812ULL, 0x040fe400078efcffULL, 0x0000003d2c00720cULL, 0x080fe40003f46070ULL,
0x0000003d3200720cULL, 0x080fe40003fa6070ULL, 0x0000003d3000720cULL, 0x000fe40003f66070ULL,
0x000000092c3c7812ULL, 0x000fc400078efcffULL, 0x000000192c327812ULL, 0x040fe400078efcffULL,
0x000000202c307812ULL, 0x000fe400078efcffULL, 0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL,
0xff7fffff2e2e7808ULL, 0x000fc40004800000ULL, 0x0000003d3c00720cULL, 0x080fe40003f86070ULL,
0x0000003d3200720cULL, 0x080fe40003f46070ULL, 0x0000003d3000720cULL, 0x000fe40003f26070ULL,
0x000000212c327812ULL, 0x040fe400078efcffULL, 0x000000282c307812ULL, 0x000fe400078efcffULL,
0xff7fffff1c1c7808ULL, 0x000fc40004000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40004000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40006000000ULL, 0xff7fffff2b2b7808ULL, 0x000fe40006000000ULL,
0x0000003d3200720cULL, 0x080fe40003f06070ULL, 0x0000003d3000720cULL, 0x000fe40003f86070ULL,
0x000000292c327812ULL, 0x000fc400078efcffULL, 0x000000302c307812ULL, 0x000fe400078efcffULL,
0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40007000000ULL,
0xff7fffff09097808ULL, 0x000fe40006800000ULL, 0xff7fffff29297808ULL, 0x000fe40006800000ULL,
0x0000003d3200720cULL, 0x000fc40003fc6070ULL, 0x0000003d3000720cULL, 0x000fe40003fa6070ULL,
0x000000312c327812ULL, 0x040fe400078efcffULL, 0x000000382c307812ULL, 0x040fe400078efcffULL,
0x000000392c2c7812ULL, 0x000fe400078efcffULL, 0xff7fffff08087808ULL, 0x000fe40005800000ULL,
0xff7fffff28287808ULL, 0x000fc40005800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL,
0xff7fffff27277808ULL, 0x000fe40005000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40004800000ULL,
0xff7fffff26267808ULL, 0x000fe40004800000ULL, 0x0000003d3200720cULL, 0x080fe40003f66070ULL,
0x0000003d3000720cULL, 0x000fc40003f46070ULL, 0x0000003d2c00720cULL, 0x000fe40003f26070ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL, 0xff7fffff25257808ULL, 0x000fe40004000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL, 0xff7fffff24247808ULL, 0x000fe40006000000ULL,
0xff7fffff13137808ULL, 0x000fc40007000000ULL, 0xff7fffff23237808ULL, 0x000fe40007000000ULL,
0xff7fffff12127808ULL, 0x000fe40006800000ULL, 0xff7fffff22227808ULL, 0x000fe40006800000ULL,
0xff7fffff11117808ULL, 0x000fe40005800000ULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005000000ULL, 0xff7fffff20207808ULL, 0x000fe40005000000ULL,
0xff7fffff03037808ULL, 0x000fe40004800000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002f04317209ULL, 0x004fe20007810000ULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x0000001e052c7209ULL, 0x000fe20007810000ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x0000002e31047209ULL, 0x000fe40007810000ULL,
0x0000001d2c057209ULL, 0x000fc40007810000ULL, 0x0000002d04047209ULL, 0x000fe40007810000ULL,
0x0000001c052c7209ULL, 0x000fe40007810000ULL, 0x0000002b04057209ULL, 0x000fe40007810000ULL,
0x0000000b2c317209ULL, 0x000fe40007810000ULL, 0x0000002a05047209ULL, 0x000fe40007810000ULL,
0x0000000a312c7209ULL, 0x000fc40007810000ULL, 0x0000002904057209ULL, 0x000fe40007810000ULL,
0x000000092c317209ULL, 0x000fe40007810000ULL, 0x0000002805047209ULL, 0x000fe40007810000ULL,
0x00000008312c7209ULL, 0x000fe40007810000ULL, 0x0000002704057209ULL, 0x000fe40007810000ULL,
0x0000000f2c317209ULL, 0x000fc40007810000ULL, 0x0000002605047209ULL, 0x000fe40007810000ULL,
0x0000000e31317209ULL, 0x000fe40007810000ULL, 0x0000002504057209ULL, 0x000fe40007810000ULL,
0x0000000c31047209ULL, 0x000fe40007810000ULL, 0x00000024052c7209ULL, 0x000fe40007810000ULL,
0x0000000d04047209ULL, 0x000fc40007810000ULL, 0x000000232c057209ULL, 0x000fe40007810000ULL,
0x0000001304317209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fe40007810000ULL,
0x00000012312c7209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x000000112c317209ULL, 0x000fc40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x00000010312c7209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fe40007810000ULL,
0x000000032c3d7209ULL, 0x000fe20007810000ULL, 0x00000ef27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x0004e400000e0000ULL, 0x00000004053f7209ULL, 0x008fe20007810000ULL,
0x00000f227f007947ULL, 0x000fea000b800000ULL, 0x0c401f003d047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x004ea800000e0000ULL, 0x0c401f00072c7f89ULL, 0x000f2200000e0000ULL,
0x000000043d307209ULL, 0x008fc60007810000ULL, 0x0c201f003f047f89ULL, 0x000ee200000e0000ULL,
0x0000000506327209ULL, 0x004fc60007810000ULL, 0x0c201f0030057f89ULL, 0x000ea200000e0000ULL,
0x0000002c072c7209ULL, 0x010fc60007810000ULL, 0x0c201f0032337f89ULL, 0x002e6800000e0000ULL,
0x0c201f002c317f89ULL, 0x00092200000e0000ULL, 0x000000043f047209ULL, 0x008fe40007810000ULL,
0x0000000530057209ULL, 0x004fe40007810000ULL, 0x0000003332067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04307820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b053f7820ULL, 0x000fe20000410000ULL,
0x3f80000000057882ULL, 0x000fc40000000000ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001083fULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001083fULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001083fULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe2000001083fULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010830ULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010830ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b21217823ULL, 0x000fe20000010830ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe2000001083fULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001083fULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b12127823ULL, 0x100fe2000001083fULL, 0x3fb8aa3b11117823ULL, 0x100fe2000001083fULL,
0x3fb8aa3b03037823ULL, 0x000fca000001083fULL, 0x0000002b00327308ULL, 0x000ff00000000800ULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000001d001d7308ULL, 0x000ff00000000800ULL,
0x0000001c001c7308ULL, 0x000ff00000000800ULL, 0x0000000b000b7308ULL, 0x000eb00000000800ULL,
0x00000024002b7308ULL, 0x0007f00000000800ULL, 0x0000002200337308ULL, 0x0023e20000000800ULL,
0x00000005ff247e24ULL, 0x008fe2000f8e00ffULL, 0x0000001c0b0b723eULL, 0x004fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000067886ULL, 0x000fc400038e0100ULL,
0x3f8000002424783eULL, 0x000fe400000010ffULL, 0x00000020003d7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b08227823ULL, 0x002fe2000001083fULL, 0x0000002f2e08723eULL, 0x000fcc00000010ffULL,
0x0000001f00307308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0a207823ULL, 0x004fe2000001083fULL,
0x0000002d320a723eULL, 0x000fcc00000010ffULL, 0x0000002500077308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b091f7823ULL, 0x002fe2000001083fULL, 0x0000001e1d09723eULL, 0x000fcc00000010ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x000000ffff257224ULL, 0x004fce00078e0024ULL,
0x0000002900297308ULL, 0x000e700000000800ULL, 0x00000021003e7308ULL, 0x000ff00000000800ULL,
0x0000001f00217308ULL, 0x0005f00000000800ULL, 0x0000002000207308ULL, 0x000ee20000000800ULL,
0x00000024081c723cULL, 0x004fee00000418ffULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0c257823ULL, 0x100fe2000001083fULL, 0x0000002a290c723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b0d297823ULL, 0x000fca000001083fULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x00000020210d723eULL, 0x008fe200000010ffULL, 0x000000ffff207224ULL, 0x100fe400078e0024ULL,
0x000000ffff217224ULL, 0x000fc800078e0024ULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000000f000f7308ULL, 0x000e700000000800ULL, 0x00000023003c7308ULL, 0x0004e20000000800ULL,
0x000000220f0f723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b0e237823ULL, 0x004fe2000001083fULL,
0x00000028270e723eULL, 0x000fca00000010ffULL, 0x00000025002e7308ULL, 0x000fe20000000800ULL,
0x0000000fff277424ULL, 0x000fe200078e00ffULL, 0x0000002b3c22723eULL, 0x008fe200000010ffULL,
0x000000200c1c723cULL, 0x000fea000004181cULL, 0x0000002300237308ULL, 0x000e700000000800ULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000001300287308ULL, 0x000ea20000000800ULL,
0x000000232e21723eULL, 0x002fce00000010ffULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x000000292823723eULL, 0x004fe200000010ffULL, 0x000000ffff287224ULL, 0x000fcc00078e0024ULL,
0x0000001200257308ULL, 0x0005e20000000800ULL, 0x000000ffff297224ULL, 0x000fe200078e0024ULL,
0x000000260720723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b10077823ULL, 0x000fe2000001083fULL,
0xfffffffc35107812ULL, 0x000fc800078ec0ffULL, 0x00000011002a7308ULL, 0x000e620000000800ULL,
0x0000003d3012723eULL, 0x004fe400000010ffULL, 0x0000001027277219ULL, 0x000fe200000006ffULL,
0x00000028201c723cULL, 0x000fe2000004181cULL, 0x000000333e10723eULL, 0x000fe400000010ffULL,
0x00000000272e73a1ULL, 0x000ea200000e8000ULL, 0x0000000700077308ULL, 0x000fe20000000800ULL,
0x00000000270573c4ULL, 0x000eee0000004000ULL, 0x0000000300267308ULL, 0x000f220000000800ULL,
0x000000252a11723eULL, 0x002fe200000010ffULL, 0x000000ffff257224ULL, 0x000fe200078e0024ULL,
0x0000000627ff7c12ULL, 0x004fc4000f80402eULL, 0x000000072613723eULL, 0x010fe400000010ffULL,
0x0000002c31077209ULL, 0x000fca0007810000ULL, 0x000000241028723cULL, 0x000fe8000004181cULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x000009f205008947ULL, 0x008fde000b800000ULL,
0x001c1fff281c7589ULL, 0x0002a400000e0000ULL, 0x00000000271e73a1ULL, 0x000ee200000e8000ULL,
0x00000000270573c4ULL, 0x000f220000004000ULL, 0x0000000000067886ULL, 0x000fe400038e0100ULL,
0x0000000627ff7c12ULL, 0x008fda000f80401eULL, 0x00000a1205008947ULL, 0x010fea000b800000ULL,
0x001c1fff2a1d7589ULL, 0x00072800000e0000ULL, 0x001c1fff1e1e7589ULL, 0x00066800000e0000ULL,
0x001c1fff001f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff037819ULL, 0x000fe40000011635ULL,
0x0000000c00417812ULL, 0x000fc400078ec0ffULL, 0x0000000703247812ULL, 0x040fe200078ec0ffULL,
0x0000000803297824ULL, 0x040fe200078e00ffULL, 0x00000003ff277212ULL, 0x00afe200078e33ffULL,
0x0000000803257824ULL, 0x000fe200078e00ffULL, 0x0000000335ff7812ULL, 0x000fe2000780c0ffULL,
0x00000008033c7824ULL, 0x040fe200078e00ffULL, 0x0000000803037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff829267812ULL, 0x100fe400078ee224ULL, 0x0000000125287812ULL, 0x100fe200078ef624ULL,
0x00000008034c7824ULL, 0x000fe200078e00ffULL, 0x00000002252a7812ULL, 0x100fe200078ef624ULL,
0x0000000803297824ULL, 0x000fe200078e00ffULL, 0x00000003252c7812ULL, 0x000fc400078ef624ULL,
0x00000004252e7812ULL, 0x140fe400078ef624ULL, 0x0000000525307812ULL, 0x140fe400078ef624ULL,
0x0000000625327812ULL, 0x000fe200078ef624ULL, 0x0000000803257824ULL, 0x040fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee227ULL, 0x00000003ff277212ULL, 0x000fe400078e33ffULL,
0x0000000703247812ULL, 0x000fc400078ec0ffULL, 0x0000900018037811ULL, 0x000fe400078e58ffULL,
0xfffffff8293e7812ULL, 0x100fe400078ee224ULL, 0x0000000125407812ULL, 0x140fe200078ef624ULL,
0x0000001026007824ULL, 0x000fe200078e0203ULL, 0xfffffff84c4c7812ULL, 0x000fe200078ee227ULL,
0x000000102a267824ULL, 0x100fe200078e0203ULL, 0x0000000225427812ULL, 0x140fe200078ef624ULL,
0x000000102e2a7824ULL, 0x100fe200078e0203ULL, 0x0000000325447812ULL, 0x140fe200078ef624ULL,
0x00000010322e7824ULL, 0x100fe200078e0203ULL, 0x0000000425467812ULL, 0x140fe200078ef624ULL,
0x0000001040327824ULL, 0x100fe200078e0203ULL, 0x0000000525487812ULL, 0x140fe200078ef624ULL,
0x0000001042337824ULL, 0x100fe200078e0203ULL, 0x00000006254a7812ULL, 0x000fe200078ef624ULL,
0x0000001028247824ULL, 0x000fc400078e0203ULL, 0x000000102c287824ULL, 0x100fe400078e0203ULL,
0x00000010302c7824ULL, 0x100fe400078e0203ULL, 0x0000000141257824ULL, 0x000fe400078e0200ULL,
0x000000103c307824ULL, 0x100fe400078e0203ULL, 0x000000103e007824ULL, 0x100fe200078e0203ULL,
0x0000000825007388ULL, 0x0003e20000000800ULL, 0x00000010443c7824ULL, 0x000fc400078e0203ULL,
0x00000010463d7824ULL, 0x100fe400078e0203ULL, 0x00000010483e7824ULL, 0x100fe400078e0203ULL,
0x000000104a3f7824ULL, 0x100fe400078e0203ULL, 0x000000104c407824ULL, 0x000fe400078e0203ULL,
0x0000000141037824ULL, 0x040fe400078e0224ULL, 0x0000000141277824ULL, 0x000fc400078e0226ULL,
0x0000000141297824ULL, 0x040fe200078e0228ULL, 0x0000000a03007388ULL, 0x0007e20000000800ULL,
0x00000001412b7824ULL, 0x040fe400078e022aULL, 0x00000001412d7824ULL, 0x040fe200078e022cULL,
0x0000000c27007388ULL, 0x0007e20000000800ULL, 0x00000001412f7824ULL, 0x040fe400078e022eULL,
0x0000000141317824ULL, 0x040fe200078e0230ULL, 0x0000000e29007388ULL, 0x0007e20000000800ULL,
0x0000000141007824ULL, 0x000fc400078e0200ULL, 0x0000000141327824ULL, 0x040fe200078e0232ULL,
0x000000202b007388ULL, 0x0007e20000000800ULL, 0x0000000141247824ULL, 0x040fe400078e0233ULL,
0x00000001413c7824ULL, 0x040fe200078e023cULL, 0x000000222d007388ULL, 0x0007e20000000800ULL,
0x0000000141087824ULL, 0x042fe400078e023dULL, 0x00000001413e7824ULL, 0x040fe200078e023eULL,
0x000000102f007388ULL, 0x0007e20000000800ULL, 0x0000000141267824ULL, 0x000fc400078e023fULL,
0x0000000141407824ULL, 0x000fe200078e0240ULL, 0x0000001231007388ULL, 0x0007e80000000800ULL,
0x0000000900007388ULL, 0x0007e80000000800ULL, 0x0000000b32007388ULL, 0x0007e80000000800ULL,
0x0000000d24007388ULL, 0x0007e80000000800ULL, 0x0000000f3c007388ULL, 0x0007e80000000800ULL,
0x0000002108007388ULL, 0x0007e80000000800ULL, 0x000000233e007388ULL, 0x0007e80000000800ULL,
0x0000001126007388ULL, 0x0007e80000000800ULL, 0x0000001340007388ULL, 0x0007e80000000800ULL,
0x00f0000402008388ULL, 0x0007e80000000c00ULL, 0x00f2001c02008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000003001a1a7a10ULL, 0x000fe20007ffe0ffULL,
0x00f6080038ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff3aff7812ULL, 0x000fc4000780c0ffULL,
0x000000151a00720cULL, 0x000fe40003f26070ULL, 0x00000001ff3a7807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffc0a000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e0030ULL,
0x0001374000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fe400078e00ffULL, 0x000006a000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff337224ULL, 0x004fe200078e003cULL, 0xffff9b6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3e7224ULL, 0x002fe200078e002fULL, 0x000137b000307802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe400078e00ffULL,
0x0000063000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2f7224ULL, 0x004fe200078e003cULL,
0xffff9b1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x000fe200078e0005ULL,
0x0001381000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fc400078e00ffULL,
0x0000059000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0032ULL,
0xfffff0c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x000fe200078e003dULL,
0x0001387000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x002fc400078e00ffULL,
0x0000053000007944ULL, 0x024fea0003c00000ULL, 0x000000323d057209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe200078e0006ULL, 0x000138c000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x002fc400078e00ffULL, 0x000004e000007944ULL, 0x000fea0003c00000ULL,
0x00000032063d7209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x000fe200078e0007ULL,
0x0001391000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x002fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x00000032072c7209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe200078e003fULL, 0x0001396000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x002fc400078e00ffULL, 0x0000044000007944ULL, 0x000fea0003c00000ULL,
0x000000323f047209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x000fe200078e0005ULL,
0x000139b000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x002fc400078e00ffULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x0000003205057209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x000fe200078e003dULL, 0x00013a0000307802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x002fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x000000323d067209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x000fe200078e002cULL,
0x00013a5000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x002fc400078e00ffULL,
0x0000035000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff317224ULL, 0x004fe200078e0032ULL,
0xffffef7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3d7224ULL, 0x000fe200078e0028ULL,
0x00013ad000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff3e7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff3f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff407224ULL, 0x000fe400078e0027ULL,
0x0000031000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e003cULL,
0xfffff5a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3d7224ULL, 0x002fe200078e002aULL,
0x00013b5000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff3e7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff3f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff407224ULL, 0x000fe400078e0027ULL,
0x0000029000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff3e7224ULL, 0x002fe200078e00ffULL,
0x00013bb000307802ULL, 0x000fe20000000f00ULL, 0x00001c1fff3f7424ULL, 0x000fc400078e00ffULL,
0x000000ffff407224ULL, 0x000fe400078e0027ULL, 0x000000ffff1d7224ULL, 0x004fe400078e003cULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff407224ULL, 0x002fe200078e0027ULL,
0x00013c1000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff3e7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff3f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x004fe400078e003cULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x004fe200078e003cULL,
0xfffff4e000007947ULL, 0x000fea000383ffffULL, 0x0180000007037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000700038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff067807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000306ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000007057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000306ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff2f7424ULL, 0x000fc800078e00ffULL, 0xfffec2602e007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff317424ULL, 0x000fe200078e00ffULL, 0x0000004100007348ULL, 0x000fe80003800000ULL,
0x0c00003332327389ULL, 0x0002a200000e003cULL, 0xfffec22030007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff317424ULL, 0x000fe200078e00ffULL, 0x0000004000007348ULL, 0x000fe80003800000ULL,
0x0000003e3d3c7389ULL, 0x0002a200000e003fULL, 0xfffec1e030007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001d0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000768ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007e0ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e8cULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000eb0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ec0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ee0ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f50ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f58ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000f68ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000013f00ULL, 0xaa00001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015080ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000015090ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015090ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000015510ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f50ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000014130ULL, 0x0000000000014130ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000015080ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000015510ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_16_m_16_sm_89_cubin_len = 87536;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
