/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b5b8ULL, 0x000000000001b238ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x346a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4532336a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL,
0x2400000000000000ULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000017cULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b00010000020cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b000100000253ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b000100000299ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b000100000383ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000b0001000003d1ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00220000042cULL, 0x0000000000019be0ULL,
0x0000000000000220ULL, 0x00040003000004a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000019e00ULL, 0x000d0003000004d2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00019be000000000ULL,
0x0001380400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x00019be000000000ULL, 0x0000022000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000c2ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0xffffffff00dc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000001b000dc2804ULL, 0x000009f000000360ULL, 0x00002fe000002f70ULL, 0x000031f0000030c0ULL,
0x0000346000003320ULL, 0x000039e0000039d0ULL, 0x00003a00000039f0ULL, 0x000060b000006020ULL,
0x000062c000006190ULL, 0x00006530000063f0ULL, 0x000069f0000069e0ULL, 0x00006a1000006a00ULL,
0x00008fb000008f20ULL, 0x000091c000009090ULL, 0x00009430000092f0ULL, 0x000098f0000098e0ULL,
0x0000991000009900ULL, 0x0000bf500000bee0ULL, 0x0000c1700000c040ULL, 0x0000c3e00000c2a0ULL,
0x0000c8f00000c8e0ULL, 0x0000c9100000c900ULL, 0x0000e3800000e370ULL, 0x0000e3a00000e390ULL,
0x0001843000018380ULL, 0x0001881000018710ULL, 0x00018d1000018c20ULL, 0x0001914000018fe0ULL,
0x0000053004303904ULL, 0x0001a600000000ffULL, 0x0000061000040100ULL, 0x0001a60800000007ULL,
0x00000720003f0100ULL, 0x0001a68800000007ULL, 0x00000860003f0100ULL, 0x0001a6a800000002ULL,
0x00000960003f0100ULL, 0x0001a6c800000004ULL, 0x000013f0003f0100ULL, 0x0001a600000000ffULL,
0x0000157000080107ULL, 0x0001a68800000002ULL, 0x00001fb0003f0101ULL, 0x00000000000000ffULL,
0x0000203000040107ULL, 0x00000000000000ffULL, 0x000020b000040101ULL, 0x0000002000000002ULL,
0x000021b0003f0101ULL, 0x0001a6c80000003fULL, 0x0000234000080109ULL, 0x0001a6c800000041ULL,
0x00002c10003f0109ULL, 0x0001a6b000000040ULL, 0x00002ce000080107ULL, 0x0001a6b000000042ULL,
0x00002cf0003f0101ULL, 0x0001a60800000080ULL, 0x00002d10003f0101ULL, 0x0001a60800000080ULL,
0x00002e80003f0109ULL, 0x0001a60800000080ULL, 0x000035f0003f0109ULL, 0x0001a6a800000042ULL,
0x00003760003f0109ULL, 0x0001a6a800000042ULL, 0x00005330003f0109ULL, 0x0001a6c80000003cULL,
0x00005350003f0101ULL, 0x0001a68800000081ULL, 0x000053c000080101ULL, 0x0000000000000006ULL,
0x00005530003f0109ULL, 0x0000000000000006ULL, 0x00005d30003f0109ULL, 0x0001a6a80000007aULL,
0x00005dd000080107ULL, 0x0001a6a800000088ULL, 0x00005de0003f0101ULL, 0x0001a62800000080ULL,
0x00005e00003f0101ULL, 0x0001a62800000080ULL, 0x00005f70003f0109ULL, 0x0001a62800000080ULL,
0x00006700003f0109ULL, 0x0001a6b000000037ULL, 0x0000688000080109ULL, 0x0001a6b00000003fULL,
0x00008210003f0109ULL, 0x0001a6c80000003cULL, 0x00008230003f0101ULL, 0x0001a6900000003eULL,
0x000082b000080101ULL, 0x0000000000000006ULL, 0x00008420003f0109ULL, 0x0000000000000006ULL,
0x00008c50003f0109ULL, 0x0001a6b000000036ULL, 0x00008cd000080107ULL, 0x0001a6b000000084ULL,
0x00008ce0003f0101ULL, 0x0001a64800000080ULL, 0x00008d00003f0101ULL, 0x0001a64800000080ULL,
0x00008e70003f0109ULL, 0x0001a64800000080ULL, 0x00009600003f0109ULL, 0x0001a6a800000037ULL,
0x0000978000080109ULL, 0x0001a6a80000003fULL, 0x0000b130003f0109ULL, 0x0001a6c800000041ULL,
0x0000b160003f0101ULL, 0x0001a6980000003eULL, 0x0000b1b000080101ULL, 0x0001a6c800000041ULL,
0x0000b340003f0109ULL, 0x0001a6c800000041ULL, 0x0000bc40003f0109ULL, 0x0001a6a80000003cULL,
0x0000bc9000080107ULL, 0x0001a6a80000003dULL, 0x0000bcb0003f0101ULL, 0x0001a66800000037ULL,
0x0000bce0003f0101ULL, 0x0001a66800000037ULL, 0x0000be50003f0109ULL, 0x0001a66800000037ULL,
0x0000c5a0003f0109ULL, 0x0001a6b000000037ULL, 0x0000c72000080109ULL, 0x0001a6b00000003fULL,
0x0000e170003f0109ULL, 0x0000000000000006ULL, 0x0000e1c0003f0101ULL, 0x0001a6a000000006ULL,
0x000103c0003f0101ULL, 0x0001a600000000ffULL, 0x00011cf000080101ULL, 0x0001a600000000ffULL,
0x00011eb000080109ULL, 0x0001a600000000ffULL, 0x000121f000080109ULL, 0x0001a600000000ffULL,
0x0001221000080101ULL, 0x0001a600000000ffULL, 0x0001238000080109ULL, 0x0001a600000000ffULL,
0x0001599000080109ULL, 0x0001a68800000006ULL, 0x00015d90003f0101ULL, 0x0001a68800000006ULL,
0x00015f00003f0109ULL, 0x0001a68800000006ULL, 0x00019b80003f0109ULL, 0x0001a60800000072ULL,
0x00019b90003f0101ULL, 0x0001a61000000072ULL, 0x00019ba0003f0101ULL, 0x0001a61800000072ULL,
0x00019bb0003f0101ULL, 0x0001a62000000072ULL, 0x00053803003f0101ULL, 0x0000f2b000301c04ULL,
0x0000f5a00000f2e0ULL, 0x0000f9800000f790ULL, 0x0000fd600000fb70ULL, 0x000101500000ff50ULL,
0x000123b000010300ULL, 0x000c050400019bd0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0068190300000000ULL, 0x0000001600080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL,
0x0000001500000002ULL, 0x0000000000019be0ULL, 0x0000000000000044ULL, 0x0000001500000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001500000002ULL, 0x0000000000000000ULL,
0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000737919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff007b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff022b82ULL, 0x000ea20000000a00ULL,
0x0000000173052836ULL, 0x008fe40000000000ULL, 0x0000000473082825ULL, 0x004fc800078e0002ULL,
0x0000000405022825ULL, 0x000fe400078e0002ULL, 0x0000000608082981ULL, 0x0004e8000c1e1900ULL,
0x0000000602072981ULL, 0x000ae2000c1e1900ULL, 0x0000000000067306ULL, 0x010f220000209000ULL,
0x00000400ff0a7b82ULL, 0x000f620000000800ULL, 0x000000ff0000720cULL, 0x000fe20003f65070ULL,
0x00000000000e7919ULL, 0x000f620000002300ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x0000000000097919ULL, 0x004ea20000002200ULL,
0x00000000000c7919ULL, 0x000ea20000002100ULL, 0x0000000600067308ULL, 0x010f240000001000ULL,
0x0ffffffe06047836ULL, 0x010fcc0000000000ULL, 0x0000000400057305ULL, 0x000964000021f000ULL,
0x000000ffff047224ULL, 0x010fe200078e00ffULL, 0x00000005ff717819ULL, 0x006fe2000001160cULL,
0x000000ffff0b7224ULL, 0x020fca00078e0a05ULL, 0x00001fff71717589ULL, 0x000e6200000e0000ULL,
0x000000000b0b7224ULL, 0x000fc800078e02ffULL, 0x0000000b05057227ULL, 0x000fcc00078e0004ULL,
0x0000000a05057227ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a05ULL,
0x0000000300037224ULL, 0x000fe400078e020aULL, 0x00000000000a7919ULL, 0x000ea60000002600ULL,
0x000000000300720cULL, 0x000fda0003f06070ULL, 0x0000000103030824ULL, 0x000fe400078e0a00ULL,
0x0000000105050836ULL, 0x000fc60000000000ULL, 0x000000000300720cULL, 0x000fda0003f26070ULL,
0x0000000105051836ULL, 0x000fe20000000000ULL, 0x00000000ff05b212ULL, 0x000fc800078e33ffULL,
0x0000000500047306ULL, 0x000f220000209000ULL, 0x000000ff0500720cULL, 0x000fce0003f65070ULL,
0x0000000400047308ULL, 0x010f240000001000ULL, 0x0ffffffe04027836ULL, 0x010fcc0000000000ULL,
0x0000000200037305ULL, 0x000964000021f000ULL, 0x000000ffff027224ULL, 0x010fe400078e00ffULL,
0x0000000305067224ULL, 0x020fc800078e02ffULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a06ULL,
0x00008400ff06ab82ULL, 0x000e640000000800ULL, 0x0000000b03037227ULL, 0x000fcc00078e0002ULL,
0x0000000a03777227ULL, 0x004fc800078e00ffULL, 0x000000040e037c24ULL, 0x000fe2000f8e0209ULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff027224ULL, 0x000fe200078e0a77ULL,
0x00001fff0e0e7589ULL, 0x000e6200000e0000ULL, 0x0000000403047c24ULL, 0x000fe4000f8e020cULL,
0x0000000205027224ULL, 0x000fc600078e020aULL, 0x0000007f0400780cULL, 0x000fe40003fa4070ULL,
0x000000050200720cULL, 0x000fe40003f06070ULL, 0x000000030400780cULL, 0x000fd20003f84070ULL,
0x000000000009d919ULL, 0x000ea40000008800ULL, 0x0000000102020824ULL, 0x000fe400078e0a05ULL,
0x0000000177770836ULL, 0x000fe20000000000ULL, 0x000000ff0400720cULL, 0x000fe40003f05270ULL,
0x000000050200720cULL, 0x000fe40003f26070ULL, 0x000004000002d802ULL, 0x000fd60000000f00ULL,
0x0000000177771836ULL, 0x000fe20000000000ULL, 0x00000005ff77b212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x040fe40003f24070ULL, 0x000000010400780cULL, 0x000fe20003f64070ULL,
0x000000ffff757224ULL, 0x000fc800078e0a77ULL, 0x0000007505757224ULL, 0x000fe200078e020aULL,
0x000006540909d816ULL, 0x004fe20000000002ULL, 0xff317217ff05d424ULL, 0x000fc800078e00ffULL,
0x000000040402d824ULL, 0x000fe400078e0209ULL, 0x0000000107032824ULL, 0x008fcc00078e0a08ULL,
0x00008400ff03ab82ULL, 0x000ee20000000800ULL, 0x0000000000240947ULL, 0x002fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01a60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404077c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000070812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a60804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404077c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000070812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a68804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01a400050200d388ULL, 0x0003e20000000800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000002075757824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000404027c11ULL, 0x002fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6a804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000040912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6c804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000803027c24ULL, 0x00afe2000f8e02ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0a75ULL, 0x000000750200720cULL, 0x000fe20003f06070ULL,
0x000000067308a224ULL, 0x000fc400078e02ffULL, 0x0000000800117c24ULL, 0x000fe2000f8e02ffULL,
0x00000020020b7446ULL, 0x000fe2000380000bULL, 0x000000040e027824ULL, 0x000fe400078e0271ULL,
0x00000011080a7224ULL, 0x000fe200078e02ffULL, 0x000000ff0b0b7207ULL, 0x000fe20000000000ULL,
0x0000000402027824ULL, 0x000fe400078e00ffULL, 0x0000000877157c24ULL, 0x000fe2000f8e020aULL,
0x000000200b00780cULL, 0x000fda0003f05270ULL, 0x0000000400308947ULL, 0x000fea0003800000ULL,
0x0000000800077d06ULL, 0x000e620008209000ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00008c0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000167919ULL, 0x000ee80000008800ULL, 0x0000000700077308ULL, 0x002e640000001000ULL,
0x0ffffffe07057836ULL, 0x002fe20000000000ULL, 0x00000004ff067819ULL, 0x004fca0000011609ULL,
0x0000000500057305ULL, 0x000e62000021f000ULL, 0x00000002060d7836ULL, 0x000fe40000000000ULL,
0x0000000102107824ULL, 0x040fe400078e0206ULL, 0x0000000102127824ULL, 0x000fc800078e020dULL,
0x0000000175147824ULL, 0x000fe400078e0212ULL, 0x000000ffff0f7224ULL, 0x002fc800078e0a05ULL,
0x000000080f0f7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000f05077227ULL, 0x000fc800078e0004ULL,
0x0000000175047824ULL, 0x000fe400078e0210ULL, 0x00000014070f7227ULL, 0x000fc800078e00ffULL,
0x0000000407057227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x000000ffff137224ULL, 0x000fe400078e0a0fULL, 0x0000000807077c24ULL, 0x000fe4000f8e0204ULL,
0x00000008130c7c24ULL, 0x000fc6000f8e0214ULL, 0x0000000807007c0cULL, 0x000fe4000bf06070ULL,
0x000000080c007c0cULL, 0x000fd6000bf46070ULL, 0x8000000807070c36ULL, 0x000fe40008000000ULL,
0x800000080c0c2c36ULL, 0x000fe40008000000ULL, 0x0000000105050836ULL, 0x000fe20000000000ULL,
0x0000000807007c0cULL, 0x000fe2000bf26070ULL, 0x000000010f0f2836ULL, 0x000fe20000000000ULL,
0x000000080c007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff0c7c12ULL, 0x000fce000f8e33ffULL, 0x0000000105051836ULL, 0x000fe40000000000ULL,
0x000000010f0f3836ULL, 0x000fc60000000000ULL, 0x000000050c077207ULL, 0x040fe40004000000ULL,
0x0000000f0c0c7207ULL, 0x000fe40004000000ULL, 0x000000020b057248ULL, 0x000fe20007fe0000ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0a07ULL, 0x000000ffff137224ULL, 0x000fe400078e0a0cULL,
0x000000080f047c24ULL, 0x000fe2000f8e0204ULL, 0x00000400000f7802ULL, 0x000fe20000000f00ULL,
0x0000000813147c24ULL, 0x000fc4000f8e0214ULL, 0x0000000115047824ULL, 0x040fe200078e0204ULL,
0x0000065416167816ULL, 0x008fe2000000000fULL, 0x00000001150f7824ULL, 0x000fe400078e0214ULL,
0x0000000105057824ULL, 0x000fe200078e0a02ULL, 0x00000000160872caULL, 0x000fe200000e0000ULL,
0x0000001107077224ULL, 0x000fe400078e0204ULL, 0x0000001009047824ULL, 0x000fe200078e00ffULL,
0x000000050600720cULL, 0x000fe20003f06070ULL, 0x000000110c0c7224ULL, 0x000fe200078e020fULL,
0x000000050d00720cULL, 0x000fe20003f26070ULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x000000f004057812ULL, 0x000fc600078ec0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000506067212ULL, 0x000fc600078efcffULL, 0x0000000110027824ULL, 0x100fe200078e0209ULL,
0x000000050c057212ULL, 0x000fe200078efcffULL, 0x0000001010117824ULL, 0x000fe200078e00ffULL,
0x0000000406067c10ULL, 0x000fe2000ff5e0ffULL, 0x00000001120f7824ULL, 0x040fe200078e0209ULL,
0x00000004050c7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001012127824ULL, 0x000fe200078e00ffULL,
0xfffffff011027812ULL, 0x000fe400078ee202ULL, 0x0000000507077c10ULL, 0x000fe400097fe4ffULL,
0xfffffff0120f7812ULL, 0x000fc400078ee20fULL, 0x0000000802057c11ULL, 0x000fe4000f8e20ffULL,
0x000000050d0d7c10ULL, 0x000fe40009ffe4ffULL, 0x000000080f0f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e8000c101c46ULL,
0x000000000c0f7faeULL, 0x0003e2000c901c46ULL, 0x0000000400147947ULL, 0x000fea0003800000ULL,
0x0000000800067d06ULL, 0x000e620008209000ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00008c0000047ab9ULL, 0x000fca0000000a00ULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe060c7836ULL, 0x002fe20000000000ULL,
0x0000000209027211ULL, 0x004fca00078fe0ffULL, 0x0000000c00057305ULL, 0x000e62000021f000ULL,
0x0000000202107836ULL, 0x000fe40000000000ULL, 0x000000ffff077224ULL, 0x002fc800078e0a05ULL,
0x0000000807077c24ULL, 0x000fc8000f8e02ffULL, 0x00000007050d7227ULL, 0x000fc800078e0004ULL,
0x0000000175047824ULL, 0x040fe400078e0202ULL, 0x0000000175077824ULL, 0x000fe400078e0210ULL,
0x000000040d057227ULL, 0x000fc800078e00ffULL, 0x000000070d0c7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a05ULL, 0x000000ffff127224ULL, 0x000fe400078e0a0cULL,
0x000000080d067c24ULL, 0x000fe4000f8e0204ULL, 0x00000008120d7c24ULL, 0x000fe4000f8e0207ULL,
0x0000000000127919ULL, 0x000e620000008800ULL, 0x0000000806007c0cULL, 0x000fe4000bf06070ULL,
0x000000080d007c0cULL, 0x000fd6000bf46070ULL, 0x8000000806060c36ULL, 0x000fe40008000000ULL,
0x800000080d0d2c36ULL, 0x000fe40008000000ULL, 0x0000000105050836ULL, 0x000fe20000000000ULL,
0x0000000806007c0cULL, 0x000fe2000bf26070ULL, 0x000000010c0c2836ULL, 0x000fe20000000000ULL,
0x000000080d007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff067c12ULL, 0x000fce000f8e33ffULL, 0x0000000105051836ULL, 0x000fe40000000000ULL,
0x000000010c0c3836ULL, 0x000fc60000000000ULL, 0x0000000506057207ULL, 0x040fe40004000000ULL,
0x0000000c060c7207ULL, 0x000fc60004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a05ULL,
0x000000ffff067224ULL, 0x000fe400078e0a0cULL, 0x000000080d047c24ULL, 0x000fe2000f8e0204ULL,
0x00000400000d7802ULL, 0x000fe20000000f00ULL, 0x0000000806077c24ULL, 0x000fe4000f8e0207ULL,
0x0000000115067824ULL, 0x040fe200078e0204ULL, 0x00000654120d7816ULL, 0x002fe2000000000dULL,
0x0000000115077824ULL, 0x000fc400078e0207ULL, 0x0000001009047824ULL, 0x000fe200078e00ffULL,
0x000000000d0872caULL, 0x000fe200000e0000ULL, 0x0000001105067224ULL, 0x080fe400078e0206ULL,
0x000000110c0c7224ULL, 0x000fe200078e0207ULL, 0x000000f0040f7812ULL, 0x000fe200078ec0ffULL,
0x0000010006067825ULL, 0x000fc800078e00ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000f06067212ULL, 0x000fc600078efcffULL, 0x0000000102057824ULL, 0x100fe200078e0209ULL,
0x0000000f0c0c7212ULL, 0x000fe200078efcffULL, 0x0000001002127824ULL, 0x000fe200078e00ffULL,
0x0000000406067c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000110027824ULL, 0x040fe200078e0209ULL,
0x000000040c0c7c10ULL, 0x000fe2000ff3e0ffULL, 0x00000010100f7824ULL, 0x000fe200078e00ffULL,
0xfffffff012057812ULL, 0x000fe400078ee205ULL, 0x0000000507077c10ULL, 0x000fe400087fe4ffULL,
0xfffffff00f027812ULL, 0x000fc400078ee202ULL, 0x0000000805057c11ULL, 0x000fe4000f8e20ffULL,
0x000000050d0d7c10ULL, 0x000fe40008ffe4ffULL, 0x00000008020f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e8000b901c46ULL,
0x000000000c0f7faeULL, 0x0003e4000b901c46ULL, 0x0001a60008047890ULL, 0x000fe2000fffe03fULL,
0x00009400ff067b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000473067825ULL, 0x002fe200078e0006ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000606767981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fe20003f05270ULL,
0x0000003f76747836ULL, 0x004fe40000000000ULL, 0x000000ff76057836ULL, 0x000fc60000000000ULL,
0x00000006ff747819ULL, 0x000fe40000011674ULL, 0x00000008ff707819ULL, 0x000fca0000011605ULL,
0x000000ec00988947ULL, 0x000fea0003800000ULL, 0x00000002ff6a7819ULL, 0x000fe20000011671ULL,
0xffffffffff0d7424ULL, 0x000fe400078e00ffULL, 0x00000004ff0f7424ULL, 0x000fe200078e00ffULL,
0x03ffffff6a597812ULL, 0x000fc800078ec0ffULL, 0x000000745900720cULL, 0x000fda0003f06070ULL,
0x00009600ff038b82ULL, 0x000e620000000800ULL, 0x0000000273028824ULL, 0x000fce00078e00ffULL,
0x00009200ff068b82ULL, 0x000ea20000000a00ULL, 0x0000000302028224ULL, 0x002fc800078e0203ULL,
0x0000000159038824ULL, 0x000fe200078e0202ULL, 0x0000000871027c11ULL, 0x000fc6000f8e18ffULL,
0x0000000403068825ULL, 0x004fe200078e0006ULL, 0x01a6880f02ff79a7ULL, 0x0003e8000850003fULL,
0x00000006060d8981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x00000040775a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff6b7819ULL, 0x000fe40000011671ULL,
0x0000000171057812ULL, 0x000fc600078ec0ffULL, 0x000000206b5b7824ULL, 0x000fe200078e00ffULL,
0x00009000ff027b82ULL, 0x002e620000000a00ULL, 0x000000000d0d7224ULL, 0x004fc600078e02ffULL,
0x000000205a007812ULL, 0x000fe200078ef85bULL, 0x000000400d0d7824ULL, 0x000fc800078e00ffULL,
0x000000800d027825ULL, 0x002fe200078e0002ULL, 0x0000000000fc0947ULL, 0x000fec0003800000ULL,
0x0000005b76067248ULL, 0x000fe20007fe0000ULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fc60000011609ULL, 0x0000000106067824ULL, 0x000fe400078e0a5bULL,
0x0000000105087824ULL, 0x000fe400078e0207ULL, 0x00000004070d7836ULL, 0x000fe20000000000ULL,
0x0000000506067248ULL, 0x000fe20007fe0000ULL, 0x00000001080c7824ULL, 0x040fe400078e0209ULL,
0x00000008080f7824ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x000fc400078e0a05ULL,
0x0000000c070e7836ULL, 0x000fe20000000000ULL, 0xfffffff80f127812ULL, 0x000fe200078ee20cULL,
0x00000008070c7836ULL, 0x000fe20000000000ULL, 0x000000060d00720cULL, 0x080fe20003f46070ULL,
0x00000001050d7824ULL, 0x000fe200078e020dULL, 0x000000060700720cULL, 0x080fe20003f66070ULL,
0x0000000100077824ULL, 0x000fe200078e0208ULL, 0x000000060c00720cULL, 0x080fe20003f26070ULL,
0x000000010d087824ULL, 0x040fe200078e0209ULL, 0x000000060e00720cULL, 0x000fe20003f06070ULL,
0x000000080d117824ULL, 0x000fc400078e00ffULL, 0x0000008007067825ULL, 0x000fc600078e00ffULL,
0xfffffff811087812ULL, 0x000fe200078ee208ULL, 0x00000001050f7824ULL, 0x040fe200078e020eULL,
0x0000007006117812ULL, 0x000fe200078ef804ULL, 0x00000001050c7824ULL, 0x000fe400078e020cULL,
0x0000000100137824ULL, 0x040fe200078e020fULL, 0x0000001102107210ULL, 0x000fe20007f9e0ffULL,
0x000000010f067824ULL, 0x040fe400078e0209ULL, 0x000000080f0f7824ULL, 0x000fe400078e00ffULL,
0x00000001000d7824ULL, 0x000fc400078e020dULL, 0x00000001000e7824ULL, 0x000fe200078e020cULL,
0xfffffff80f167812ULL, 0x000fe200078ee206ULL, 0x0000000103117824ULL, 0x000fe200020e0607ULL,
0x000000086b007c11ULL, 0x000fe2000f8e68ffULL, 0x000000010c057824ULL, 0x040fe400078e0209ULL,
0x000000080c147824ULL, 0x000fe400078e00ffULL, 0x000000800d067825ULL, 0x000fc600078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x000000800e0c7825ULL, 0x000fe200078e00ffULL,
0x00000070061d7812ULL, 0x000fc600078ef804ULL, 0x00000080130e7825ULL, 0x000fe200078e00ffULL,
0x000000700c1b7812ULL, 0x000fc600078ef804ULL, 0x0001600000057836ULL, 0x000fe20000000000ULL,
0x000000700e197812ULL, 0x000fe400078ef804ULL, 0x0000001d02047210ULL, 0x000fe20007f9e0ffULL,
0x0000001012137824ULL, 0x100fe200078e0205ULL, 0x0000001b02067210ULL, 0x000fe20007fbe0ffULL,
0x0000001008157824ULL, 0x100fe200078e0205ULL, 0x0000001902027210ULL, 0x000fe20007fde0ffULL,
0x0000001014177824ULL, 0x100fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0003e2000d901c46ULL, 0x0000001016197824ULL, 0x000fc400078e0205ULL,
0x0000000103057824ULL, 0x040fe400020e0607ULL, 0x0000000103077824ULL, 0x040fe400028e060dULL,
0x0000000103037824ULL, 0x000fe200030e060fULL, 0x0000000004157faeULL, 0x0003e8000d101c46ULL,
0x0000000006177faeULL, 0x0003e8000c901c46ULL, 0x0000000002197faeULL, 0x0003e2000c101c46ULL,
0x0000000000c87947ULL, 0x000fea0003800000ULL, 0x0000001005067824ULL, 0x000fca00078e00ffULL,
0x0000000609057211ULL, 0x000fca00078fe8ffULL, 0x00000004050c7836ULL, 0x000fe40000000000ULL,
0x0000000105077824ULL, 0x040fe400078e0209ULL, 0x0000000805087824ULL, 0x000fe400078e00ffULL,
0x0000000100067824ULL, 0x000fe400078e0205ULL, 0x000000010c0d7824ULL, 0x040fe200078e0209ULL,
0xfffffff808087812ULL, 0x000fe200078ee207ULL, 0x000000080c127824ULL, 0x000fc400078e00ffULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee20dULL,
0x00000008050d7836ULL, 0x000fe20000000000ULL, 0x0000007006117812ULL, 0x000fe200078ef804ULL,
0x0000000c050e7836ULL, 0x000fe40000000000ULL, 0x00000001000c7824ULL, 0x040fe200078e020cULL,
0x0000001102107210ULL, 0x000fe20007f1e0ffULL, 0x0000000100057824ULL, 0x040fe400078e020dULL,
0x00000001000f7824ULL, 0x000fe400078e020eULL, 0x000000010d007824ULL, 0x000fc400078e0209ULL,
0x000000080d137824ULL, 0x000fe200078e00ffULL, 0x000000086b0d7c11ULL, 0x000fe2000f8e68ffULL,
0x000000010e067824ULL, 0x040fe400078e0209ULL, 0x000000080e157824ULL, 0x000fe200078e00ffULL,
0xfffffff813007812ULL, 0x000fe200078ee200ULL, 0x0000000103117824ULL, 0x000fe400000e0607ULL,
0x000160000d1d7836ULL, 0x000fe20000000000ULL, 0xfffffff815147812ULL, 0x000fe200078ee206ULL,
0x000000800c067825ULL, 0x000fc800078e00ffULL, 0x00000080050c7825ULL, 0x000fe200078e00ffULL,
0x00000070061b7812ULL, 0x000fc600078ef804ULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c197812ULL, 0x000fc600078ef804ULL, 0x0000001008137824ULL, 0x100fe200078e021dULL,
0x000000700e057812ULL, 0x000fe200078ef804ULL, 0x0000001012157824ULL, 0x100fe200078e021dULL,
0x0000001b02047210ULL, 0x000fe20007f1e0ffULL, 0x0000001000177824ULL, 0x100fe200078e021dULL,
0x0000001902067210ULL, 0x000fe20007f3e0ffULL, 0x0000001014197824ULL, 0x000fe200078e021dULL,
0x0000000502027210ULL, 0x000fe20007f5e0ffULL, 0x0000000103057824ULL, 0x040fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000b901c46ULL,
0x0000000103077824ULL, 0x000fc400008e060dULL, 0x0000000103037824ULL, 0x000fe200010e060fULL,
0x0000000004157faeULL, 0x0003e8000b901c46ULL, 0x0000000006177faeULL, 0x0003e8000b901c46ULL,
0x0000000002197faeULL, 0x0003e4000b901c46ULL, 0x0000000159597836ULL, 0x000fe40000000000ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x000000745900720cULL, 0x000fda0003f06070ULL,
0x00009600ff058b82ULL, 0x002e620000000800ULL, 0x0000000273008824ULL, 0x000fe200078e00ffULL,
0x000000006b0472caULL, 0x000fcc00000e0000ULL, 0x00009200ff028b82ULL, 0x000ea20000000a00ULL,
0x0000000500008224ULL, 0x002fc800078e0205ULL, 0x0000000100058824ULL, 0x000fe400078e0259ULL,
0x00000008ff007e24ULL, 0x000fe4000f8e00ffULL, 0x0000000405028825ULL, 0x004fc800078e0002ULL,
0x0001a6a800007836ULL, 0x000fe20000000000ULL, 0x0000000602818981ULL, 0x000322000c1e1900ULL,
0x000000ff7000720cULL, 0x000fe20003f05270ULL, 0x00000001ff057424ULL, 0x000fe200078e00ffULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x00000000000572caULL, 0x000fe200000e0000ULL,
0x000000ffff827224ULL, 0x000fe200078e00ffULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000000e7805ULL, 0x000fc4000001ff00ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x000000ffff317224ULL, 0x000fe400078e00ffULL, 0x000000086b027824ULL, 0x002fe200078e0200ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000005ff7879a7ULL, 0x0002a20008500004ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x0000000000527805ULL, 0x000fe4000001ff00ULL,
0x0000000000507805ULL, 0x000fe4000001ff00ULL, 0x00000000004e7805ULL, 0x000fe4000001ff00ULL,
0x00000000004c7805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00002005020279a7ULL, 0x0002e2000850003fULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x000000c000448947ULL, 0x000fec0003800000ULL, 0x00009600ff057b82ULL, 0x002e620000000800ULL,
0x0000000273087824ULL, 0x000fe200078e00ffULL, 0x000000016b587812ULL, 0x000fe200078ec0ffULL,
0x000000ffff407224ULL, 0x008fe400078e0003ULL, 0xff317217ff7e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x000000ffff377224ULL, 0x000fe400078e00ffULL,
0x0000000508087224ULL, 0x002fce00078e0205ULL, 0x000000ffff6c7224ULL, 0x000fce00078e0059ULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x0000000471067824ULL, 0x000fca00078e00ffULL,
0xfffffff8063f7812ULL, 0x000fc800078ec0ffULL, 0x01a6c8403f0075a7ULL, 0x000e620008000148ULL,
0x000000083f417c36ULL, 0x000fc80008000000ULL, 0x0001a6c841067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff427224ULL, 0x000fce00078e00ffULL,
0x000000104200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000433e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000142427836ULL, 0x000fce0000000000ULL,
0x01a6c840410075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009000ff3c7b82ULL, 0x000e620000000a00ULL, 0x00000010713e7824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x00000001073f7836ULL, 0x000fe40000000000ULL,
0x0000000481817c24ULL, 0x010fe2000f8e02ffULL, 0xffffffe03e407812ULL, 0x000fe400078ec0ffULL,
0x000000703f00720cULL, 0x000fe20003f26070ULL, 0x0000004081817824ULL, 0x000fe400078e00ffULL,
0x0000010007407824ULL, 0x000fc800078e0240ULL, 0x0000004040417836ULL, 0x000fca0000000000ULL,
0x00000020413f7812ULL, 0x000fe200078ec0ffULL, 0x00000080813c7825ULL, 0x002fc800078e003cULL,
0x000000015a457824ULL, 0x000fe200078e023fULL, 0x0000000400049947ULL, 0x000fec0003800000ULL,
0x000000103e3f7812ULL, 0x000fe200078ec0ffULL, 0x0000001009437824ULL, 0x000fe200078e00ffULL,
0x00000041763e7248ULL, 0x000fe40007fe0000ULL, 0x00000003ff427819ULL, 0x000fe40000011609ULL,
0x0000007043617812ULL, 0x000fe200078ec0ffULL, 0x000000013e3e7824ULL, 0x000fe400078e0a41ULL,
0x0000000142407824ULL, 0x000fe400078e023fULL, 0x0000000842447836ULL, 0x000fe20000000000ULL,
0x0000003f3e3e7248ULL, 0x000fe20007fe0000ULL, 0x0000000140417824ULL, 0x000fc400078e0209ULL,
0x0000000840467824ULL, 0x000fe400078e00ffULL, 0x000000013e3e7824ULL, 0x100fe400078e0a3fULL,
0x0000000c42477836ULL, 0x000fe20000000000ULL, 0xfffffff846467812ULL, 0x000fe200078ee241ULL,
0x0000000442417836ULL, 0x000fe20000000000ULL, 0x0000003e4200720cULL, 0x080fe20003f86070ULL,
0x00000001475c7824ULL, 0x100fe200078e023fULL, 0x0000003e4400720cULL, 0x0c0fe20003f46070ULL,
0x0000000141427824ULL, 0x140fe200078e023fULL, 0x0000003e4100720cULL, 0x080fe20003f66070ULL,
0x0000000144447824ULL, 0x000fe200078e023fULL, 0x0000003e4700720cULL, 0x000fe20003f06070ULL,
0x00000001453e7824ULL, 0x000fc400078e0240ULL, 0x0000000145407824ULL, 0x040fe400078e0242ULL,
0x0000000142437824ULL, 0x140fe400078e0209ULL, 0x00000008425e7824ULL, 0x000fe400078e00ffULL,
0x0000000145427824ULL, 0x040fe400078e0244ULL, 0x0000000145477824ULL, 0x000fe400078e025cULL,
0x0000000144457824ULL, 0x000fc400078e0209ULL, 0x0000000844607824ULL, 0x000fe400078e00ffULL,
0x000000803e3e7825ULL, 0x000fc800078e00ffULL, 0x0000008040407825ULL, 0x000fc800078e00ffULL,
0x000000015c447824ULL, 0x040fe400078e0209ULL, 0x000000085c5d7824ULL, 0x000fe200078e00ffULL,
0xfffffff85e5c7812ULL, 0x000fe400078ee243ULL, 0xfffffff8605e7812ULL, 0x000fe400078ee245ULL,
0x000000613e437212ULL, 0x080fe400078efcffULL, 0x0000006140457212ULL, 0x000fe400078efcffULL,
0x000000433c3e7210ULL, 0x000fe20007fbe0ffULL, 0x0000008042427825ULL, 0x000fe200078e00ffULL,
0xfffffff85d607812ULL, 0x000fc400078ee244ULL, 0x000000453c407210ULL, 0x000fe20007fde0ffULL,
0x0000008047447825ULL, 0x000fe200078e00ffULL, 0x000000086b5d7c11ULL, 0x000fe4000f8e68ffULL,
0x0000006142637212ULL, 0x080fe200078efcffULL, 0x000000013d3f7824ULL, 0x040fe200028e063fULL,
0x0000006144617212ULL, 0x000fe200078efcffULL, 0x000170005d477836ULL, 0x000fe20000000000ULL,
0x000000633c427210ULL, 0x000fe20007fbe0ffULL, 0x000000013d417824ULL, 0x000fe200030e0641ULL,
0x000000613c3c7210ULL, 0x000fe20007fde0ffULL, 0x00000010465d7824ULL, 0x000fc400078e0247ULL,
0x000000105c5f7824ULL, 0x100fe400078e0247ULL, 0x000000105e617824ULL, 0x000fe200078e0247ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e5d7faeULL, 0x0003e2000e101c46ULL,
0x000000013d437824ULL, 0x040fe400028e0643ULL, 0x0000001060477824ULL, 0x000fe200078e0247ULL,
0x00000000405f7faeULL, 0x0003e2000d901c46ULL, 0x000000013d3d7824ULL, 0x000fc600030e0645ULL,
0x0000000042617faeULL, 0x0003e8000d101c46ULL, 0x000000003c477faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x000000103e3e7812ULL, 0x000fe200078ec0ffULL,
0x0000001009427824ULL, 0x000fc600078e00ffULL, 0x0000003e093e7211ULL, 0x000fe400078fe8ffULL,
0x0000007042617812ULL, 0x000fc600078ec0ffULL, 0x000000043e407836ULL, 0x000fe40000000000ULL,
0x000000013e3f7824ULL, 0x140fe400078e0209ULL, 0x000000083e467824ULL, 0x000fe400078e00ffULL,
0x0000000140417824ULL, 0x040fe400078e0209ULL, 0x00000008405c7824ULL, 0x000fe200078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee23fULL, 0x00000001453f7824ULL, 0x000fc400078e023eULL,
0x000000083e427836ULL, 0x000fe20000000000ULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee241ULL,
0x0000000c3e447836ULL, 0x000fe40000000000ULL, 0x000000803f3e7825ULL, 0x000fc800078e00ffULL,
0x0000000145407824ULL, 0x040fe200078e0240ULL, 0x000000613e477212ULL, 0x000fe200078efcffULL,
0x0000000145437824ULL, 0x040fe400078e0242ULL, 0x0000000142417824ULL, 0x140fe200078e0209ULL,
0x000000473c3e7210ULL, 0x000fe20007f1e0ffULL, 0x00000008425e7824ULL, 0x000fe400078e00ffULL,
0x0000000145457824ULL, 0x000fe400078e0244ULL, 0x0000000144427824ULL, 0x040fe200078e0209ULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee241ULL, 0x00000008445d7824ULL, 0x000fe200078e00ffULL,
0x000000086b447c11ULL, 0x000fe2000f8e68ffULL, 0x0000008040407825ULL, 0x000fc600078e00ffULL,
0xfffffff85d607812ULL, 0x000fe200078ee242ULL, 0x0001700044677836ULL, 0x000fe20000000000ULL,
0x0000006140657212ULL, 0x000fe200078efcffULL, 0x0000008043427825ULL, 0x000fc800078e00ffULL,
0x0000008045447825ULL, 0x000fe200078e00ffULL, 0x0000006142637212ULL, 0x000fc600078efcffULL,
0x000000013d3f7824ULL, 0x040fe200000e063fULL, 0x0000006144617212ULL, 0x000fe200078efcffULL,
0x0000001046477824ULL, 0x100fe200078e0267ULL, 0x000000653c407210ULL, 0x000fe20007f1e0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e0267ULL, 0x000000633c427210ULL, 0x000fe20007f5e0ffULL,
0x000000105e5f7824ULL, 0x000fe200078e0267ULL, 0x000000613c3c7210ULL, 0x000fe20007f7e0ffULL,
0x000000013d417824ULL, 0x040fe200000e0641ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e2000b901c46ULL, 0x000000013d437824ULL, 0x000fc400010e0643ULL,
0x0000001060617824ULL, 0x000fe200078e0267ULL, 0x00000000405d7faeULL, 0x0003e2000b901c46ULL,
0x000000013d3d7824ULL, 0x000fc600018e0645ULL, 0x00000000425f7faeULL, 0x0003e8000b901c46ULL,
0x000000003c617faeULL, 0x0003e4000b901c46ULL, 0x00000001593f7836ULL, 0x002fe40000000000ULL,
0xffffffffff7c7424ULL, 0x000fc600078e00ffULL, 0x000000743f00720cULL, 0x000fe20003f06070ULL,
0x00000008717a7824ULL, 0x000fca00078e00ffULL, 0xfffffff07a407812ULL, 0x000fca00078ec0ffULL,
0x0000000840427c36ULL, 0x000fe40008000000ULL, 0x00009200ff3c8b82ULL, 0x000e620000000a00ULL,
0x00000001083f8824ULL, 0x000fe200078e023fULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000420472caULL, 0x000fda00000e0000ULL, 0x0001a6b004047890ULL, 0x000fe2000fffe03fULL,
0x000000043f3c8825ULL, 0x002fd000078e003cULL, 0x00000000ff0079b0ULL, 0x000fe80008000a44ULL,
0x000000063c7c8981ULL, 0x000322000c1e1900ULL, 0xffffffe07a3e7812ULL, 0x040fe200078ec0ffULL,
0x00000001ff417424ULL, 0x000fe200078e00ffULL, 0x000000107a3f7812ULL, 0x000fc800078ec0ffULL,
0x000000083f3e7c10ULL, 0x000fe4000fffe03eULL, 0x000000087a3f7812ULL, 0x000fca00078ec0ffULL,
0x000000013e807824ULL, 0x000fe200078e023fULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x01a6b041428679a7ULL, 0x0002e4000850003fULL, 0x01a60841804079a7ULL, 0x0022a4000850003fULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x01a60841800075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff447224ULL, 0x000fce00078e00ffULL,
0x000000104400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000433e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000144447836ULL, 0x000fce0000000000ULL,
0x01a60841800075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000001009697824ULL, 0x000fe200078e00ffULL, 0x00000001ff6e7819ULL, 0x000fe20000011609ULL,
0x00000020713c7824ULL, 0x000fe400078e00ffULL, 0x00000001ff407424ULL, 0x000fe200078e00ffULL,
0x0000007069697812ULL, 0x000fe200078ec0ffULL, 0x000000ffff837224ULL, 0x000fe200078e007eULL,
0xffffff803c3c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c6e6e7812ULL, 0x000fe400078ec0ffULL,
0x00000008693d7c10ULL, 0x000fca000fffe03cULL, 0x000000013d3d7824ULL, 0x000fca00078e026eULL,
0x01a000003d3f7984ULL, 0x000ea80000000800ULL, 0x01a200003d417984ULL, 0x000b620000000800ULL,
0x0000007e3f00720bULL, 0x004fda0003f1d000ULL, 0x00000000003e7806ULL, 0x000fc800000e0100ULL,
0x000000ff3e00720cULL, 0x000fda0003f05270ULL, 0x00000004008c8947ULL, 0x02afea0003800000ULL,
0x000000716a00720cULL, 0x000fe40003f45270ULL, 0x0000007e3f00720bULL, 0x0c0fe40003f14000ULL,
0x0000007e3f837209ULL, 0x000fd20007810000ULL, 0x00000008713cac11ULL, 0x000fe4000f8e38ffULL,
0x00000000003d7806ULL, 0x000fe400000e0100ULL, 0x0000003c6e3ca210ULL, 0x000fe40007ffe069ULL,
0x000000ff3d00720cULL, 0x000fc60003f05270ULL, 0x01a400833c00a388ULL, 0x0003f40000000800ULL,
0x0000000400508947ULL, 0x002fea0003800000ULL, 0x0000007e833c7221ULL, 0x000fe20000010100ULL,
0x000000ff3dff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003dff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b3c3c7820ULL, 0x000fe20000410000ULL, 0x00ff00003dff7812ULL, 0x040fe4000786c0ffULL,
0xff0000003dff7812ULL, 0x000fe2000788c0ffULL, 0x0000003c00437308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff3c7819ULL, 0x002fcc0000011609ULL,
0x00001f3c433c7589ULL, 0x004e6400000e0000ULL, 0x0000003c54547220ULL, 0x082fe20000410000ULL,
0x0000003c55557220ULL, 0x080fe20000410000ULL, 0x0000003c48487220ULL, 0x080fe20000410000ULL,
0x0000003c49497220ULL, 0x080fe20000410000ULL, 0x0000003c4c4c7220ULL, 0x080fe20000410000ULL,
0x0000003c4d4d7220ULL, 0x080fe20000410000ULL, 0x0000003c50507220ULL, 0x080fe20000410000ULL,
0x0000003c51517220ULL, 0x080fe20000410000ULL, 0x0000003c30307220ULL, 0x080fe20000410000ULL,
0x0000003c31317220ULL, 0x080fe20000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000003c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000003c28287220ULL, 0x080fe20000410000ULL,
0x0000003c29297220ULL, 0x080fe20000410000ULL, 0x0000003c24247220ULL, 0x080fe20000410000ULL,
0x0000003c25257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000008093c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f3c433c7589ULL, 0x004e6400000e0000ULL,
0x0000003c56567220ULL, 0x082fe20000410000ULL, 0x0000003c57577220ULL, 0x080fe20000410000ULL,
0x0000003c4a4a7220ULL, 0x080fe20000410000ULL, 0x0000003c4b4b7220ULL, 0x080fe20000410000ULL,
0x0000003c4e4e7220ULL, 0x080fe20000410000ULL, 0x0000003c4f4f7220ULL, 0x080fe20000410000ULL,
0x0000003c52527220ULL, 0x080fe20000410000ULL, 0x0000003c53537220ULL, 0x080fe20000410000ULL,
0x0000003c32327220ULL, 0x080fe20000410000ULL, 0x0000003c33337220ULL, 0x080fe20000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000003c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000003c26267220ULL, 0x080fe20000410000ULL, 0x0000003c27277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x00000010093c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f3c433c7589ULL, 0x004e6400000e0000ULL, 0x0000003c0c0c7220ULL, 0x082fe20000410000ULL,
0x0000003c0d0d7220ULL, 0x080fe20000410000ULL, 0x0000003c10107220ULL, 0x080fe20000410000ULL,
0x0000003c11117220ULL, 0x080fe20000410000ULL, 0x0000003c14147220ULL, 0x080fe20000410000ULL,
0x0000003c15157220ULL, 0x080fe20000410000ULL, 0x0000003c18187220ULL, 0x080fe20000410000ULL,
0x0000003c19197220ULL, 0x080fe20000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000003c20207220ULL, 0x080fe20000410000ULL,
0x0000003c21217220ULL, 0x080fe20000410000ULL, 0x0000003c38387220ULL, 0x080fe20000410000ULL,
0x0000003c39397220ULL, 0x080fe20000410000ULL, 0x0000003c34347220ULL, 0x080fe20000410000ULL,
0x0000003c35357220ULL, 0x000fce0000410000ULL, 0x0000004382827220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x00000018093c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f3c433c7589ULL, 0x000e6400000e0000ULL, 0x0000003c0e0e7220ULL, 0x082fe20000410000ULL,
0x0000003c0f0f7220ULL, 0x080fe20000410000ULL, 0x0000003c12127220ULL, 0x080fe20000410000ULL,
0x0000003c13137220ULL, 0x080fe20000410000ULL, 0x0000003c16167220ULL, 0x080fe20000410000ULL,
0x0000003c17177220ULL, 0x080fe20000410000ULL, 0x0000003c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000003c22227220ULL, 0x080fe20000410000ULL,
0x0000003c23237220ULL, 0x080fe20000410000ULL, 0x0000003c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000003c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000003c36367220ULL, 0x080fe20000410000ULL,
0x0000003c37377220ULL, 0x000fce0000410000ULL, 0x0000003d3eff7212ULL, 0x000fda00078030ffULL,
0x800000833f3f0221ULL, 0x000fe20000010000ULL, 0x00007610ff400816ULL, 0x000fc60000000040ULL,
0x3fb8aa3b3f3f0820ULL, 0x000fc80000410000ULL, 0x0000003f00040308ULL, 0x000ea40000000800ULL,
0x0000000441410220ULL, 0x004fce0000410000ULL, 0x0000008241827221ULL, 0x000fce0000010000ULL,
0x00000000003c7805ULL, 0x002fce0000015200ULL, 0x01a6a879420075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff437224ULL, 0x000fce00078e00ffULL,
0x000000104300780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0000003e3c417210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004100780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404100780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000413e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000143437836ULL, 0x000fce0000000000ULL,
0x01a6a879420075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000400713c7824ULL, 0x000fe200078e00ffULL, 0x00009910403d7816ULL, 0x000fe200000000ffULL,
0x00000008ff797e24ULL, 0x000fe2000f8e00ffULL, 0x0000000809687812ULL, 0x000fe200078ec0ffULL,
0x0000000271817824ULL, 0x000fe200078e00ffULL, 0xfffff0003c3c7812ULL, 0x000fe200078ec0ffULL,
0x00000008ff3f7e24ULL, 0x000fe2000f8e00ffULL, 0x000000ff3d00720cULL, 0x000fe20003f05270ULL,
0x00001000713d7824ULL, 0x000fe200078e00ffULL, 0x0001200079797810ULL, 0x000fe20007ffe03cULL,
0x00000004713c7824ULL, 0x000fe200078e00ffULL, 0x0000000481727812ULL, 0x000fc400078ec0ffULL,
0x0000000768687812ULL, 0x000fe400078ef809ULL, 0xffffe0003d3e7812ULL, 0x000fe400078ec0ffULL,
0x00000072093d7211ULL, 0x000fe200078fe0ffULL, 0x00000008686d7824ULL, 0x040fe200078e00ffULL,
0x0000001068787812ULL, 0x000fe400078efcffULL, 0x000000043c3c7812ULL, 0x000fe200078ec0ffULL,
0x00000001687f7824ULL, 0x040fe200078e023dULL, 0x000160003f5e7810ULL, 0x000fe20007ffe03eULL,
0x000000013d7e7824ULL, 0x000fe200078e0278ULL, 0x0000003c097d7211ULL, 0x000fe200078fe0ffULL,
0x00000008683c7824ULL, 0x000fc400078e00ffULL, 0x00000008783d7824ULL, 0x000fe400078e00ffULL,
0x00000001685c7824ULL, 0x000fe200078e027dULL, 0xfffffff83c7f7812ULL, 0x000fe400078ee27fULL,
0xfffffff83d7e7812ULL, 0x000fe400078ee27eULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee25cULL,
0x000000107f3e7824ULL, 0x100fe400078e0279ULL, 0x000000107e447824ULL, 0x000fe200078e0279ULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe40000011609ULL,
0x00000004ff00723eULL, 0x000fc600000010ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x00005410003c7816ULL, 0x000fe20000000000ULL, 0x00000008033d7836ULL, 0x000fe40000000000ULL,
0x00000018033f7836ULL, 0x000fe40000000000ULL, 0x00001f053c057589ULL, 0x0002a800000e0000ULL,
0x00001f3d3c027589ULL, 0x0002e800000e0000ULL, 0x00001f033c037589ULL, 0x00026800000e0000ULL,
0x00001f3f3c007589ULL, 0x00026400000e0000ULL, 0x000000003e3c783bULL, 0x002e620000000200ULL,
0x000000106d407824ULL, 0x000fc600078e025eULL, 0x000000004444783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x088fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000544447232ULL, 0x084fe40000200000ULL,
0x0000000546467232ULL, 0x000fc40000200000ULL, 0x0000000045457232ULL, 0x080fe40000200000ULL,
0x0000000047477232ULL, 0x000fce0000200000ULL, 0x0000000868607824ULL, 0x000fe200078e00ffULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0x000000025c7b7836ULL, 0x000fe20000000000ULL,
0x0000000272727812ULL, 0x000fc800078efcffULL, 0xfffffff8607b7812ULL, 0x000fca00078ee27bULL,
0x000000107b5e7824ULL, 0x000fcc00078e025eULL, 0x000000005e5c783bULL, 0x000f640000004200ULL,
0x000000ff40607812ULL, 0x068fe400078ec0ffULL, 0x00000010ff927819ULL, 0x100fe40000011640ULL,
0x00000018ff627819ULL, 0x000fe40000011640ULL, 0x0000ffff40907812ULL, 0x000fe400078ec0ffULL,
0x000000ff41657812ULL, 0x000fc400078ec0ffULL, 0x00000060ff64723eULL, 0x000fe400020006ffULL,
0x000000ff42667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff917819ULL, 0x100fe20000011641ULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000018ff637819ULL, 0x000fe40000011641ULL,
0x00000010ff8c7819ULL, 0x004fe4000001165cULL, 0x000000ff5c967812ULL, 0x000fc400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe4000001165cULL, 0x0000ffff5c847812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001165dULL, 0x00000010ff6f7819ULL, 0x100fe4000001165eULL,
0x000000ff5e607812ULL, 0x000fe400078ec0ffULL, 0x00000018ff617819ULL, 0x000fc4000001165eULL,
0x0000ffff5e857812ULL, 0x000fe400078ec0ffULL, 0x000000ff5f5e7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff41937812ULL, 0x000fe400078ec0ffULL, 0x00000018ff947819ULL, 0x000fe4000001165fULL,
0x00000010ff8f7819ULL, 0x100fe40000011642ULL, 0x00000018ff417819ULL, 0x000fc40000011642ULL,
0x0000ffff428a7812ULL, 0x000fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000010ff887819ULL, 0x000fe4000001165fULL,
0x0000ffff5f737812ULL, 0x000fe400078ec0ffULL, 0x00000066ff42723eULL, 0x000fe200020006ffULL,
0x20000065ff667230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fc400020006ffULL,
0x0000005eff5f723eULL, 0x000fe200020006ffULL, 0x2000005cff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff907819ULL, 0x000fe20000011690ULL, 0x20000042ff657230ULL, 0x000fe20000004100ULL,
0x00000018ff957819ULL, 0x100fe20000011643ULL, 0x20000060ff5c7230ULL, 0x000fe20000004100ULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x2000005fff607230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe40000011643ULL, 0x000000ff92927812ULL, 0x000fe200078ec0ffULL,
0x20000094ff5f7230ULL, 0x000fe20000004100ULL, 0x00000090ff90723eULL, 0x000fc400020006ffULL,
0x00000095ff42723eULL, 0x000fe400020006ffULL, 0x00000008ff957819ULL, 0x000fe40000011693ULL,
0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x000000ff91947812ULL, 0x000fe400078ec0ffULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff438d7812ULL, 0x000fc400078ec0ffULL, 0x00000092ff91723eULL, 0x000fe200020006ffULL,
0x20000090ff927230ULL, 0x000fe20000004100ULL, 0x00000095ff95723eULL, 0x000fe400020006ffULL,
0x0000008fff90723eULL, 0x000fe200020006ffULL, 0x20000091ff917230ULL, 0x000fe20000004100ULL,
0x000000ff43677812ULL, 0x000fe200078ec0ffULL, 0x20000095ff8f7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000094ff93723eULL, 0x000fc400020006ffULL,
0x00000008ff8a7819ULL, 0x000fe4000001168aULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x000fe4000001165dULL,
0x00000008ff947819ULL, 0x000fe2000001168dULL, 0x20000090ff8d7230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x2000008bff907230ULL, 0x000fe20000004100ULL,
0x000000ff8c8c7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff5d897812ULL, 0x040fe400078ec0ffULL,
0x00000067ff43723eULL, 0x000fe200020006ffULL, 0x20000062ff677230ULL, 0x000fe20000004100ULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x000000ff5d977812ULL, 0x000fe400078ec0ffULL, 0x00000094ff94723eULL, 0x000fc400020006ffULL,
0x000000ff8e957812ULL, 0x000fe200078ec0ffULL, 0x2000008aff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ff847819ULL, 0x000fe20000011684ULL, 0x20000094ff8a7230ULL, 0x000fe20000004100ULL,
0x00000040ff5d723eULL, 0x000fe200020006ffULL, 0x20000041ff407230ULL, 0x000fe20000004100ULL,
0x0000008cff8b723eULL, 0x000fe200020006ffULL, 0x20000096ff417230ULL, 0x000fe20000004100ULL,
0x00000008ff897819ULL, 0x000fe20000011689ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000095ff8c723eULL, 0x000fe200020006ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fc400020006ffULL, 0x000000ff6f6f7812ULL, 0x000fe200078ec0ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff957819ULL, 0x000fe40000011667ULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x000000ff88947812ULL, 0x000fe400078ec0ffULL,
0x00000010ff677819ULL, 0x000fe20000011693ULL, 0x20000063ff627230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x20000043ff637230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe20000011685ULL, 0x20000084ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff937819ULL, 0x000fc40000011640ULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x00000010ff407819ULL, 0x000fe4000001168dULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff8d7819ULL, 0x000fe40000011641ULL, 0x00000094ff84723eULL, 0x000fe400020006ffULL,
0x00000010ff427819ULL, 0x000fc40000011642ULL, 0x00000010ff417819ULL, 0x000fe2000001168aULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000088ff94723eULL, 0x000fe200020006ffULL,
0x20000089ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fe2000001168bULL,
0x2000006fff897230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000094ff6f7230ULL, 0x000fe20000004100ULL, 0x00000097ff43723eULL, 0x000fe400020006ffULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x0000105442417816ULL, 0x000fe20000000041ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff917819ULL, 0x000fc40000011691ULL, 0x000010548a427816ULL, 0x000fe4000000008dULL,
0x00000010ff8a7819ULL, 0x000fe4000001165dULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff5d7819ULL, 0x000fe40000011688ULL,
0x00000010ff947819ULL, 0x000fc40000011666ULL, 0x00000010ff8b7819ULL, 0x000fe4000001165cULL,
0x00000010ff887819ULL, 0x000fe40000011689ULL, 0x0000105491667816ULL, 0x000fe40000000064ULL,
0x00000010ff917819ULL, 0x000fe40000011665ULL, 0x000010548a5c7816ULL, 0x000fe40000000085ULL,
0x00000010ff627819ULL, 0x000fc40000011662ULL, 0x00000010ff657819ULL, 0x000fe4000001168fULL,
0x000010545e5d7816ULL, 0x000fe4000000005dULL, 0x00000010ff857819ULL, 0x000fe40000011660ULL,
0x00001054885e7816ULL, 0x000fe4000000008bULL, 0x00000010ff617819ULL, 0x000fe20000011661ULL,
0x0000005c3c2c723cULL, 0x002fe2000004182cULL, 0x00000010ff607819ULL, 0x000fc4000001166fULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff637819ULL, 0x000fe20000011663ULL,
0x0000005c4420723cULL, 0x000fe20000041820ULL, 0x00000010ff907819ULL, 0x000fe40000011690ULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff8c7819ULL, 0x000fe2000001168cULL, 0x00000001785c7824ULL, 0x040fe200078e027dULL,
0x00000010ff847819ULL, 0x000fe20000011684ULL, 0x00000008787d7824ULL, 0x000fe200078e00ffULL,
0x00000010ff887819ULL, 0x000fc4000001165fULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x0000105462657816ULL, 0x000fe40000000065ULL, 0x0000105440627816ULL, 0x000fe40000000091ULL,
0x0000105461607816ULL, 0x000fe40000000060ULL, 0x0000105467677816ULL, 0x000fe40000000094ULL,
0x0000105495647816ULL, 0x000fc40000000092ULL, 0x0000105490637816ULL, 0x000fe40000000063ULL,
0x0000105493407816ULL, 0x000fe2000000008eULL, 0x000000663c54723cULL, 0x000fe20000041854ULL,
0x000010548c437816ULL, 0x000fe40000000043ULL, 0x00001054845f7816ULL, 0x000fe40000000085ULL,
0x0000105488617816ULL, 0x000fe20000000073ULL, 0x000000643c48723cULL, 0x000fe20000041848ULL,
0x000000086b737c11ULL, 0x000fc4000f8e68ffULL, 0xfffffff87d7d7812ULL, 0x000fc600078ee25cULL,
0x000000623c4c723cULL, 0x000fe2000004184cULL, 0x0001600073847836ULL, 0x000fca0000000000ULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x00000066440c723cULL, 0x000fe2000004180cULL, 0x00000072093d7211ULL, 0x000fe200078fe0ffULL,
0x00000008683c7824ULL, 0x000fc400078e00ffULL, 0x00000008783f7824ULL, 0x000fe400078e00ffULL,
0x00000001686f7824ULL, 0x100fe200078e023dULL, 0x000000644410723cULL, 0x000fe20000041810ULL,
0x0000000178727824ULL, 0x000fc600078e023dULL, 0xfffffff83c6f7812ULL, 0x000fe400078ee26fULL,
0xfffffff83f727812ULL, 0x000fe200078ee272ULL, 0x000000624414723cULL, 0x000fe40000041814ULL,
0x000000106f3c7824ULL, 0x100fe400078e0279ULL, 0x0000001072797824ULL, 0x000fe400078e0279ULL,
0x000000404418723cULL, 0x000fe40000041818ULL, 0x000000003c3c783bULL, 0x000e680000000200ULL,
0x00000042441c723cULL, 0x000fe2000004181cULL, 0x000000107d407824ULL, 0x000fca00078e0284ULL,
0x0000005e4438723cULL, 0x000fec0000041838ULL, 0x000000604444723cULL, 0x000fe20000041834ULL,
0x000000007934783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x080fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x088fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x00000008785e7824ULL, 0x000fe200078e00ffULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0x000000025c797836ULL, 0x004fe20000000000ULL,
0xfffffff881817812ULL, 0x000fc800078ec0ffULL, 0xfffffff85e797812ULL, 0x000fca00078ee279ULL,
0x00000010795c7824ULL, 0x000fcc00078e0284ULL, 0x000000005c5c783bULL, 0x000ea20000004200ULL,
0x00000018ff627819ULL, 0x120fe40000011640ULL, 0x00000018ff637819ULL, 0x100fe40000011641ULL,
0x00000010ff917819ULL, 0x000fe40000011640ULL, 0x000000ff40607812ULL, 0x040fe400078ec0ffULL,
0x0000ffff40937812ULL, 0x000fe400078ec0ffULL, 0x00000010ff947819ULL, 0x000fc40000011641ULL,
0x000000ff41647812ULL, 0x040fe400078ec0ffULL, 0x0000ffff41957812ULL, 0x000fe400078ec0ffULL,
0x000000ff43667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff967819ULL, 0x100fe40000011642ULL,
0x000000ff42657812ULL, 0x000fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fc40000011642ULL,
0x0000ffff428e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8d7819ULL, 0x100fe40000011643ULL,
0x00000018ff417819ULL, 0x000fe40000011643ULL, 0x0000ffff43907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8f7819ULL, 0x004fe4000001165cULL, 0x000000ff5c437812ULL, 0x000fc400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe4000001165cULL, 0x0000ffff5c8b7812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000010ff927819ULL, 0x100fe4000001165dULL,
0x000000ff5d987812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fc4000001165dULL,
0x0000ffff5d8c7812ULL, 0x000fe400078ec0ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000066ff5d723eULL, 0x000fe200020006ffULL, 0x20000062ff667230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000063ff627230ULL, 0x000fe20000004100ULL,
0x000000ff5e887812ULL, 0x000fe200078ec0ffULL, 0x2000005dff637230ULL, 0x000fe20000004100ULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x00000060ff61723eULL, 0x000fe400020006ffULL,
0x00000018ff857819ULL, 0x100fe4000001165eULL, 0x00000098ff98723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fe4000001165eULL,
0x0000ffff5e8a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff977819ULL, 0x000fc4000001165fULL,
0x000000ff5f5e7812ULL, 0x040fe400078ec0ffULL, 0x00000042ff5d723eULL, 0x000fe200020006ffULL,
0x20000041ff427230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000043ff417230ULL, 0x000fe20000004100ULL, 0x00000010ff897819ULL, 0x000fe2000001165fULL,
0x20000098ff437230ULL, 0x000fe20000004100ULL, 0x0000ffff5f677812ULL, 0x000fe200078ec0ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fc400020006ffULL,
0x00000085ff5f723eULL, 0x000fe400020006ffULL, 0x00000097ff97723eULL, 0x000fe400020006ffULL,
0x0000005eff98723eULL, 0x000fe200020006ffULL, 0x2000005cff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff91917812ULL, 0x000fe200078ec0ffULL, 0x20000088ff5c7230ULL, 0x000fe20000004100ULL,
0x00000008ff937819ULL, 0x000fe20000011693ULL, 0x2000005fff887230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe200020006ffULL, 0x20000097ff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff977819ULL, 0x000fe20000011695ULL, 0x20000098ff857230ULL, 0x000fe20000004100ULL,
0x00000093ff95723eULL, 0x000fe200020006ffULL, 0x20000091ff937230ULL, 0x000fe20000004100ULL,
0x00000097ff97723eULL, 0x000fc400020006ffULL, 0x000000ff96967812ULL, 0x000fe200078ec0ffULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL,
0x20000097ff917230ULL, 0x000fe20000004100ULL, 0x00000008ff977819ULL, 0x000fe40000011690ULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x00000008ff8e7819ULL, 0x000fe4000001168eULL,
0x0000008dff8d723eULL, 0x000fe200020006ffULL, 0x20000096ff907230ULL, 0x000fe20000004100ULL,
0x00000097ff97723eULL, 0x000fc400020006ffULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x2000008dff967230ULL, 0x000fe20000004100ULL, 0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL,
0x20000097ff8d7230ULL, 0x000fe20000004100ULL, 0x00000008ff8b7819ULL, 0x000fe4000001168bULL,
0x000000ff94947812ULL, 0x000fe400078ec0ffULL, 0x000000ff92987812ULL, 0x000fe200078ec0ffULL,
0x2000008eff927230ULL, 0x000fe20000004100ULL, 0x00000008ff8c7819ULL, 0x000fc4000001168cULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x000000ff89977812ULL, 0x000fe400078ec0ffULL,
0x00000008ff897819ULL, 0x000fe4000001168aULL, 0x0000008fff8e723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x00000094ff94723eULL, 0x000fe200020006ffULL,
0x2000008bff8a7230ULL, 0x000fe20000004100ULL, 0x00000098ff8f723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000097ff98723eULL, 0x000fe200020006ffULL,
0x2000008cff8b7230ULL, 0x000fe20000004100ULL, 0x00000089ff97723eULL, 0x000fe200020006ffULL,
0x20000060ff8c7230ULL, 0x000fe20000004100ULL, 0x00000008ff677819ULL, 0x000fe20000011667ULL,
0x20000098ff897230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000097ff607230ULL, 0x000fe20000004100ULL, 0x00000067ff99723eULL, 0x000fc400020006ffULL,
0x00000010ff977819ULL, 0x000fe20000011666ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x000fe20000011661ULL, 0x20000099ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff667819ULL, 0x000fe40000011693ULL, 0x00000010ff987819ULL, 0x000fe40000011664ULL,
0x00000010ff937819ULL, 0x000fe40000011694ULL, 0x0000105466667816ULL, 0x000fc40000000067ULL,
0x0000105493677816ULL, 0x000fe40000000098ULL, 0x00000010ff937819ULL, 0x000fe40000011665ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff657819ULL, 0x000fe20000011691ULL,
0x000000663c54723cULL, 0x002fe20000041854ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000010ff907819ULL, 0x000fc40000011690ULL, 0x0000105462657816ULL, 0x000fe20000000065ULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x0000105490627816ULL, 0x000fe20000000093ULL,
0x00000066340c723cULL, 0x008fe2000004180cULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff907819ULL, 0x000fe40000011641ULL,
0x00000010ff417819ULL, 0x000fc4000001168dULL, 0x00000010ff8d7819ULL, 0x000fe4000001165cULL,
0x000010545d5c7816ULL, 0x000fe4000000008aULL, 0x00000010ff647819ULL, 0x000fe40000011695ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff917819ULL, 0x000fe40000011643ULL,
0x00000010ff8a7819ULL, 0x000fc40000011685ULL, 0x00000010ff957819ULL, 0x000fe40000011640ULL,
0x00000010ff437819ULL, 0x000fe4000001168eULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff857819ULL, 0x000fe40000011688ULL,
0x00000010ff637819ULL, 0x000fc40000011663ULL, 0x00000010ff967819ULL, 0x000fe40000011696ULL,
0x00000010ff407819ULL, 0x000fe40000011692ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168fULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x00000010ff607819ULL, 0x000fc40000011660ULL, 0x00000010ff887819ULL, 0x000fe4000001165fULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x0000105442417816ULL, 0x000fe40000000041ULL,
0x0000105443427816ULL, 0x000fe40000000090ULL, 0x000010545e5d7816ULL, 0x000fe4000000008bULL,
0x0000105497647816ULL, 0x000fc40000000064ULL, 0x0000105496637816ULL, 0x000fe40000000063ULL,
0x0000105495407816ULL, 0x000fe20000000040ULL, 0x0000005c3c2c723cULL, 0x000fe2000004182cULL,
0x000010548e437816ULL, 0x000fe40000000091ULL, 0x000010548c5e7816ULL, 0x000fe4000000008dULL,
0x00001054895f7816ULL, 0x000fe2000000008aULL, 0x000000643c48723cULL, 0x000fe20000041848ULL,
0x0000105485607816ULL, 0x000fc40000000060ULL, 0x0000105488617816ULL, 0x000fc60000000061ULL,
0x000000623c4c723cULL, 0x000fec000004184cULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000603c24723cULL, 0x000fec0000041824ULL, 0x000000643410723cULL, 0x000fe20000041810ULL,
0x000000086b3c7c11ULL, 0x000fe2000f8e18ffULL, 0x00000001ff3e7424ULL, 0x000fc800078e00ffULL,
0x000000623414723cULL, 0x000fe20000041814ULL, 0x01a6c83e3c3c79a7ULL, 0x00026a000850003fULL,
0x000000403418723cULL, 0x000fe20000041818ULL, 0x01a6883e81ff79a7ULL, 0x0003ea0008500008ULL,
0x00000042341c723cULL, 0x000fec000004181cULL, 0x0000005c3420723cULL, 0x000fec0000041820ULL,
0x0000005e3438723cULL, 0x000fec0000041838ULL, 0x000000603444723cULL, 0x002fde0000041844ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003d060075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x00000036343f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003f36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x0000003d060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009000ff347b82ULL, 0x000e620000000a00ULL,
0x0000001071367824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x000000047c7c7c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe0363c7812ULL, 0x000fe400078ec0ffULL,
0x000000407c3d7824ULL, 0x000fc600078e00ffULL, 0x00000100073c7824ULL, 0x000fc800078e023cULL,
0x000000803c3f7836ULL, 0x000fca0000000000ULL, 0x000000203f377812ULL, 0x000fe200078ec0ffULL,
0x000000803d347825ULL, 0x002fc800078e0034ULL, 0x000000015a427824ULL, 0x000fe200078e0237ULL,
0x0000000000f49947ULL, 0x000fec0003800000ULL, 0x0000001036377812ULL, 0x000fe400078ec0ffULL,
0x0000003f76367248ULL, 0x000fe40007fe0000ULL, 0x00000003ff3c7819ULL, 0x000fc60000011609ULL,
0x0000000136367824ULL, 0x000fe400078e0a3fULL, 0x000000013c3d7824ULL, 0x000fe400078e0237ULL,
0x000000043c3f7836ULL, 0x000fe20000000000ULL, 0x0000003637367248ULL, 0x000fe20007fe0000ULL,
0x000000013d3e7824ULL, 0x040fe400078e0209ULL, 0x000000083d5d7824ULL, 0x000fe400078e00ffULL,
0x0000000136367824ULL, 0x000fc400078e0a37ULL, 0x0000000c3c417836ULL, 0x000fe20000000000ULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee23eULL, 0x000000083c3e7836ULL, 0x000fe20000000000ULL,
0x000000363f00720cULL, 0x0c0fe20003f66070ULL, 0x000000013f3f7824ULL, 0x100fe200078e0237ULL,
0x000000363c00720cULL, 0x080fe20003f86070ULL, 0x000000013d3c7824ULL, 0x100fe200078e0242ULL,
0x000000363e00720cULL, 0x0c0fe20003f46070ULL, 0x000000013e3e7824ULL, 0x000fe200078e0237ULL,
0x000000364100720cULL, 0x000fe20003f06070ULL, 0x000000013f407824ULL, 0x000fc400078e0242ULL,
0x000000013e3d7824ULL, 0x040fe400078e0209ULL, 0x000000083e607824ULL, 0x000fe400078e00ffULL,
0x00000001415c7824ULL, 0x000fe400078e0237ULL, 0x000000013f377824ULL, 0x040fe200078e0209ULL,
0xfffffff860657812ULL, 0x000fe200078ee23dULL, 0x000000083f5e7824ULL, 0x000fe400078e00ffULL,
0x0000008040407825ULL, 0x000fc600078e00ffULL, 0xfffffff85e637812ULL, 0x000fe200078ee237ULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000006940377212ULL, 0x000fc600078efcffULL,
0x000000013e3e7824ULL, 0x100fe200078e0242ULL, 0x000000693c437212ULL, 0x000fe200078efcffULL,
0x000000015c367824ULL, 0x000fe200078e0242ULL, 0x0000003734407210ULL, 0x000fe20007fde0ffULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x00000043343c7210ULL, 0x000fc60007fbe0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000000693e617212ULL, 0x000fc600078efcffULL,
0x000000015c427824ULL, 0x000fe200078e0209ULL, 0x00000069365f7212ULL, 0x000fe200078efcffULL,
0x000000085c677824ULL, 0x000fe400078e00ffULL, 0x00000001353d7824ULL, 0x040fe200028e063dULL,
0x00000061343e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000135417824ULL, 0x000fe200030e0641ULL,
0xfffffff867677812ULL, 0x000fe200078ee242ULL, 0x000000105d437824ULL, 0x100fe200078e0284ULL,
0x0000005f34347210ULL, 0x000fe20007fde0ffULL, 0x00000010635d7824ULL, 0x000fc400078e0284ULL,
0x00000010655f7824ULL, 0x100fe200078e0284ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c437faeULL, 0x0003e2000e101c46ULL, 0x00000001353f7824ULL, 0x000fe400028e063fULL,
0x0000001067617824ULL, 0x000fe200078e0284ULL, 0x00000000405d7faeULL, 0x0003e2000d901c46ULL,
0x0000000135357824ULL, 0x000fc600030e0637ULL, 0x000000003e5f7faeULL, 0x0003e8000d101c46ULL,
0x0000000034617faeULL, 0x0003e2000c101c46ULL, 0x0000000000c07947ULL, 0x000fea0003800000ULL,
0x0000001036367812ULL, 0x000fc800078ec0ffULL, 0x0000003609377211ULL, 0x000fca00078fe8ffULL,
0x00000001373c7824ULL, 0x040fe400078e0209ULL, 0x0000000837437824ULL, 0x040fe400078e00ffULL,
0x0000000137367824ULL, 0x000fe400078e0242ULL, 0x00000004373d7836ULL, 0x000fe20000000000ULL,
0xfffffff843437812ULL, 0x000fe200078ee23cULL, 0x0000000837417836ULL, 0x000fe40000000000ULL,
0x0000000c375c7836ULL, 0x000fc40000000000ULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x000000013d3e7824ULL, 0x100fe400078e0242ULL, 0x0000000141407824ULL, 0x140fe400078e0242ULL,
0x000000015c3c7824ULL, 0x000fe400078e0242ULL, 0x0000000141427824ULL, 0x140fe400078e0209ULL,
0x00000008415f7824ULL, 0x000fe400078e00ffULL, 0x000000013d3f7824ULL, 0x000fc400078e0209ULL,
0x000000083d5e7824ULL, 0x000fe200078e00ffULL, 0x00000069363d7212ULL, 0x080fe200078efcffULL,
0x000000015c417824ULL, 0x040fe200078e0209ULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee242ULL,
0x000000085c5c7824ULL, 0x000fe200078e00ffULL, 0xfffffff85e5d7812ULL, 0x000fe200078ee23fULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x0000003d34367210ULL, 0x000fe40007f1e0ffULL,
0xfffffff85c677812ULL, 0x000fe200078ee241ULL, 0x0000008040407825ULL, 0x000fe200078e00ffULL,
0x000000693e657212ULL, 0x000fc600078efcffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000006940637212ULL, 0x000fc600078efcffULL, 0x0000000135377824ULL, 0x000fe200000e0637ULL,
0x000000693c617212ULL, 0x000fe200078efcffULL, 0x0000001043437824ULL, 0x100fe200078e0284ULL,
0x00000065343e7210ULL, 0x000fe20007f1e0ffULL, 0x000000105d5d7824ULL, 0x100fe200078e0284ULL,
0x0000006334407210ULL, 0x000fe20007f5e0ffULL, 0x000000105f5f7824ULL, 0x000fe200078e0284ULL,
0x0000006134347210ULL, 0x000fe20007f7e0ffULL, 0x00000001353f7824ULL, 0x040fe200000e063fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036437faeULL, 0x0003e2000b901c46ULL,
0x0000000135417824ULL, 0x000fc400010e0641ULL, 0x0000001067617824ULL, 0x000fe200078e0284ULL,
0x000000003e5d7faeULL, 0x0003e2000b901c46ULL, 0x0000000135357824ULL, 0x000fc600018e063dULL,
0x00000000405f7faeULL, 0x0003e8000b901c46ULL, 0x0000000034617faeULL, 0x0003e4000b901c46ULL,
0x0000000259377836ULL, 0x002fe40000000000ULL, 0xffffffffff817424ULL, 0x000fc600078e00ffULL,
0x000000743700720cULL, 0x000fe40003f06070ULL, 0xfffffff07a7a7812ULL, 0x000fca00078ec0ffULL,
0x000000087a887c36ULL, 0x000fe20008000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00009200ff348b82ULL, 0x000e620000000a00ULL, 0x00000000880472caULL, 0x000fe200000e0000ULL,
0x0000000108378824ULL, 0x000fd800078e0237ULL, 0x0001a6a804047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000437348825ULL, 0x002fca00078e0034ULL,
0x0000000634818981ULL, 0x000322000c1e1900ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x01a6a837888879a7ULL, 0x0004e4000850003fULL,
0x01a62837803679a7ULL, 0x004464000850003fULL, 0x0000000000347805ULL, 0x002fce0000015200ULL,
0x01a62837800075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fce0000015200ULL,
0x0000003c343f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e35ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc8000001143dULL, 0x0000003f3c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3d7224ULL, 0x000fca00000e063dULL, 0x000000023c3c7819ULL, 0x000fc8000000123dULL,
0x0000003c0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x01a62837800075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002071347824ULL, 0x000fe400078e00ffULL,
0x00000008ff357e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff3c7424ULL, 0x000fe200078e00ffULL,
0xffffff8034347812ULL, 0x000fc800078ec0ffULL, 0x0000008035347810ULL, 0x000fc80007ffe034ULL,
0x000000346e347210ULL, 0x000fca0007ffe069ULL, 0x01a0000034367984ULL, 0x000e680000000800ULL,
0x01a2000034357984ULL, 0x000b620000000800ULL, 0x000000833600720bULL, 0x002fda0003f1d000ULL,
0x0000000000377806ULL, 0x000fc800000e0100ULL, 0x000000ff3700720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x02cfea0003800000ULL, 0x000000016a347836ULL, 0x000fe20000000000ULL,
0x000000833600720bULL, 0x000fc80003f14000ULL, 0x000000713400720cULL, 0x000fda0003f45270ULL,
0x00000008713cac11ULL, 0x000fe4000f8e38ffULL, 0x000000833634a209ULL, 0x000fe40007810000ULL,
0x0000003c6e3da210ULL, 0x000fe40007ffe069ULL, 0x00000000003c7806ULL, 0x000fc600000e0100ULL,
0x01a400343d00a388ULL, 0x0003e20000000800ULL, 0x000000ff3c00720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x0000008336347209ULL, 0x000fe40007810000ULL,
0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL,
0x0000008334347221ULL, 0x000fe20000010100ULL, 0x00ff00003cff7812ULL, 0x040fe4000786c0ffULL,
0xff0000003cff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x00000034003d7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff347819ULL, 0x002fcc0000011609ULL, 0x00001f343d347589ULL, 0x004e6400000e0000ULL,
0x0000005434547220ULL, 0x042fe20000410000ULL, 0x0000005534557220ULL, 0x040fe20000410000ULL,
0x0000004834487220ULL, 0x040fe20000410000ULL, 0x0000004934497220ULL, 0x040fe20000410000ULL,
0x0000004c344c7220ULL, 0x040fe20000410000ULL, 0x0000004d344d7220ULL, 0x040fe20000410000ULL,
0x0000005034507220ULL, 0x040fe20000410000ULL, 0x0000005134517220ULL, 0x040fe20000410000ULL,
0x0000003034307220ULL, 0x040fe20000410000ULL, 0x0000003134317220ULL, 0x040fe20000410000ULL,
0x0000002c342c7220ULL, 0x040fe20000410000ULL, 0x0000002d342d7220ULL, 0x040fe20000410000ULL,
0x0000002834287220ULL, 0x040fe20000410000ULL, 0x0000002934297220ULL, 0x040fe20000410000ULL,
0x0000002434247220ULL, 0x040fe20000410000ULL, 0x0000002534257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x0000000809347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343d347589ULL, 0x004e6400000e0000ULL, 0x0000005634567220ULL, 0x042fe20000410000ULL,
0x0000005734577220ULL, 0x040fe20000410000ULL, 0x0000004a344a7220ULL, 0x040fe20000410000ULL,
0x0000004b344b7220ULL, 0x040fe20000410000ULL, 0x0000004e344e7220ULL, 0x040fe20000410000ULL,
0x0000004f344f7220ULL, 0x040fe20000410000ULL, 0x0000005234527220ULL, 0x040fe20000410000ULL,
0x0000005334537220ULL, 0x040fe20000410000ULL, 0x0000003234327220ULL, 0x040fe20000410000ULL,
0x0000003334337220ULL, 0x040fe20000410000ULL, 0x0000002e342e7220ULL, 0x040fe20000410000ULL,
0x0000002f342f7220ULL, 0x040fe20000410000ULL, 0x0000002a342a7220ULL, 0x040fe20000410000ULL,
0x0000002b342b7220ULL, 0x040fe20000410000ULL, 0x0000002634267220ULL, 0x040fe20000410000ULL,
0x0000002734277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x0000001009347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343d347589ULL, 0x004e6400000e0000ULL,
0x0000000c340c7220ULL, 0x042fe20000410000ULL, 0x0000000d340d7220ULL, 0x040fe20000410000ULL,
0x0000001034107220ULL, 0x040fe20000410000ULL, 0x0000001134117220ULL, 0x040fe20000410000ULL,
0x0000001434147220ULL, 0x040fe20000410000ULL, 0x0000001534157220ULL, 0x040fe20000410000ULL,
0x0000001834187220ULL, 0x040fe20000410000ULL, 0x0000001934197220ULL, 0x040fe20000410000ULL,
0x0000001c341c7220ULL, 0x040fe20000410000ULL, 0x0000001d341d7220ULL, 0x040fe20000410000ULL,
0x0000002034207220ULL, 0x040fe20000410000ULL, 0x0000002134217220ULL, 0x040fe20000410000ULL,
0x0000003834387220ULL, 0x040fe20000410000ULL, 0x0000003934397220ULL, 0x040fe20000410000ULL,
0x0000004434447220ULL, 0x040fe20000410000ULL, 0x0000004534457220ULL, 0x000fce0000410000ULL,
0x0000003d82827220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x0000001809347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343d347589ULL, 0x000e6400000e0000ULL,
0x0000000e340e7220ULL, 0x042fe20000410000ULL, 0x0000000f340f7220ULL, 0x040fe20000410000ULL,
0x0000001234127220ULL, 0x040fe20000410000ULL, 0x0000001334137220ULL, 0x040fe20000410000ULL,
0x0000001634167220ULL, 0x040fe20000410000ULL, 0x0000001734177220ULL, 0x040fe20000410000ULL,
0x0000001a341a7220ULL, 0x040fe20000410000ULL, 0x0000001b341b7220ULL, 0x040fe20000410000ULL,
0x0000001e341e7220ULL, 0x040fe20000410000ULL, 0x0000001f341f7220ULL, 0x040fe20000410000ULL,
0x0000002234227220ULL, 0x040fe20000410000ULL, 0x0000002334237220ULL, 0x040fe20000410000ULL,
0x0000003a343a7220ULL, 0x040fe20000410000ULL, 0x0000003b343b7220ULL, 0x040fe20000410000ULL,
0x0000004634467220ULL, 0x040fe20000410000ULL, 0x0000004734477220ULL, 0x000fce0000410000ULL,
0x0000003c37ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff3c7424ULL, 0x000fe200078e00ffULL,
0x0000008336837209ULL, 0x000fd60007810000ULL, 0x8000008336360221ULL, 0x000fe20000010000ULL,
0x00007610ff3c0816ULL, 0x000fc6000000003cULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600040308ULL, 0x000ea40000000800ULL, 0x0000000435350220ULL, 0x004fce0000410000ULL,
0x0000008235827221ULL, 0x000fce0000010000ULL, 0x0000000000347805ULL, 0x002fce0000015200ULL,
0x0000000871367824ULL, 0x000fca00078e00ffULL, 0xfffffff036377812ULL, 0x000fc800078ec0ffULL,
0x01a6b087370075a7ULL, 0x000e620008000148ULL, 0x00000008373f7c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a6b0873f0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000099103c347816ULL, 0x000fe200000000ffULL, 0x0000040071357824ULL, 0x040fe400078e00ffULL,
0x0000100071367824ULL, 0x000fe200078e00ffULL, 0x000000ff3400720cULL, 0x000fe20003f05270ULL,
0x00000008ff7c7e24ULL, 0x000fe2000f8e00ffULL, 0xfffff00035357812ULL, 0x000fe200078ec0ffULL,
0x00000008ff377e24ULL, 0x000fe2000f8e00ffULL, 0xffffe00036367812ULL, 0x000fe400078ec0ffULL,
0x000130007c7c7810ULL, 0x000fc40007ffe035ULL, 0x00017000375c7810ULL, 0x000fc60007ffe036ULL,
0x000000107f3c7824ULL, 0x100fe400078e027cULL, 0x000000107e347824ULL, 0x000fe400078e027cULL,
0x000000106d407824ULL, 0x000fe200078e025cULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff367819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000000836027836ULL, 0x000fe20000000000ULL, 0x0000541000357816ULL, 0x000fe20000000000ULL,
0x00000010363e7836ULL, 0x000fe40000000000ULL, 0x0000001836427836ULL, 0x000fe40000000000ULL,
0x00001f0235027589ULL, 0x0002a800000e0000ULL, 0x00001f3e35057589ULL, 0x0002e800000e0000ULL,
0x00001f3635037589ULL, 0x00026800000e0000ULL, 0x00001f4235007589ULL, 0x00026400000e0000ULL,
0x000000003c3c783bULL, 0x002e680000000200ULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x084fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x088fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x000000107b5c7824ULL, 0x000fe200078e025cULL,
0x000000004040783bULL, 0x000f6a0000004200ULL, 0x000000005c5c783bULL, 0x000f640000004200ULL,
0x00000010ff8e7819ULL, 0x028fe40000011640ULL, 0x000000ff40607812ULL, 0x000fc400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011640ULL, 0x0000ffff40907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff967819ULL, 0x000fe40000011642ULL, 0x00000010ff8d7819ULL, 0x104fe4000001165cULL,
0x000000ff5c977812ULL, 0x000fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fc4000001165cULL,
0x0000ffff5c857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff917819ULL, 0x000fe40000011641ULL,
0x00000018ff5c7819ULL, 0x000fe4000001165dULL, 0x00000010ff8c7819ULL, 0x000fe40000011643ULL,
0x000000ff5e7a7812ULL, 0x000fe400078ec0ffULL, 0x00000060ff64723eULL, 0x000fc400020006ffULL,
0x00000018ff617819ULL, 0x100fe4000001165eULL, 0x00000096ff96723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fe4000001165eULL,
0x0000ffff5e867812ULL, 0x000fe400078ec0ffULL, 0x00000018ff957819ULL, 0x000fe4000001165fULL,
0x000000ff41657812ULL, 0x000fc400078ec0ffULL, 0x000000ff5f5e7812ULL, 0x000fe400078ec0ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x000000ff91917812ULL, 0x000fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fe40000011641ULL, 0x0000ffff41947812ULL, 0x000fe400078ec0ffULL,
0x000000ff42667812ULL, 0x000fc400078ec0ffULL, 0x00000010ff927819ULL, 0x000fe4000001165dULL,
0x000000ff5d987812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5d8a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff877819ULL, 0x000fe4000001165fULL, 0x0000ffff5f847812ULL, 0x000fe400078ec0ffULL,
0x0000007aff7a723eULL, 0x000fc400020006ffULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff417819ULL, 0x000fe40000011643ULL, 0x00000040ff5d723eULL, 0x000fe200020006ffULL,
0x20000096ff407230ULL, 0x000fe20000004100ULL, 0x00000061ff5f723eULL, 0x000fe400020006ffULL,
0x00000095ff95723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff937819ULL, 0x000fc40000011642ULL, 0x0000ffff428b7812ULL, 0x000fe400078ec0ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x0000005eff96723eULL, 0x000fe200020006ffULL,
0x2000005cff5e7230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x2000007aff5c7230ULL, 0x000fe20000004100ULL, 0x00000066ff42723eULL, 0x000fe200020006ffULL,
0x2000005fff7a7230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000095ff5f7230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000065ff667230ULL, 0x000fe20000004100ULL, 0x00000097ff97723eULL, 0x000fe200020006ffULL,
0x20000091ff957230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL,
0x20000042ff657230ULL, 0x000fe20000004100ULL, 0x00000008ff857819ULL, 0x000fe20000011685ULL,
0x2000008cff917230ULL, 0x000fe20000004100ULL, 0x000000ff92927812ULL, 0x000fe200078ec0ffULL,
0x20000041ff427230ULL, 0x000fe20000004100ULL, 0x00000008ff907819ULL, 0x000fe20000011690ULL,
0x20000097ff417230ULL, 0x000fe20000004100ULL, 0x0000008dff8c723eULL, 0x000fe200020006ffULL,
0x20000096ff617230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fc400020006ffULL,
0x00000092ff8d723eULL, 0x000fe200020006ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff8a7819ULL, 0x000fe4000001168aULL, 0x000000ff43677812ULL, 0x000fe200078ec0ffULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x000000ff93977812ULL, 0x000fe400078ec0ffULL, 0x000000ff60607812ULL, 0x000fc400078ec0ffULL,
0x000000ff87927812ULL, 0x000fe400078ec0ffULL, 0x00000008ff877819ULL, 0x000fe20000011686ULL,
0x20000085ff867230ULL, 0x000fe20000004100ULL, 0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff947819ULL, 0x000fe40000011694ULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x0000ffff438f7812ULL, 0x000fc400078ec0ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000067ff43723eULL, 0x000fe200020006ffULL, 0x20000062ff677230ULL, 0x000fe20000004100ULL,
0x00000097ff97723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000092ff85723eULL, 0x000fe400020006ffULL, 0x00000087ff92723eULL, 0x000fe200020006ffULL,
0x2000008aff877230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x20000060ff8a7230ULL, 0x000fe20000004100ULL, 0x00000094ff96723eULL, 0x000fe200020006ffULL,
0x20000090ff947230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000092ff607230ULL, 0x000fe20000004100ULL, 0x00000008ff907819ULL, 0x000fe2000001168fULL,
0x20000097ff8f7230ULL, 0x000fe20000004100ULL, 0x00000008ff8b7819ULL, 0x000fe2000001168bULL,
0x2000008eff937230ULL, 0x000fe20000004100ULL, 0x00000010ff977819ULL, 0x000fe20000011667ULL,
0x20000063ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff927819ULL, 0x000fe20000011666ULL,
0x20000096ff8e7230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe20000011695ULL,
0x20000043ff637230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000090ff96723eULL, 0x000fc400020006ffULL,
0x00000008ff847819ULL, 0x000fe20000011684ULL, 0x2000008bff907230ULL, 0x000fe20000004100ULL,
0x0000105467677816ULL, 0x000fe20000000092ULL, 0x20000096ff8b7230ULL, 0x000fe20000004100ULL,
0x00000010ff927819ULL, 0x000fe40000011665ULL, 0x00000098ff43723eULL, 0x000fe400020006ffULL,
0x00000010ff657819ULL, 0x000fe4000001168eULL, 0x00000010ff637819ULL, 0x000fe20000011663ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x000fc40000011691ULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff8f7819ULL, 0x000fe2000001168fULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x000010548e637816ULL, 0x000fe40000000063ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff867819ULL, 0x000fc40000011686ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff937819ULL, 0x000fe40000011693ULL, 0x00000010ff8e7819ULL, 0x000fe40000011641ULL,
0x00000010ff417819ULL, 0x000fe4000001168bULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff877819ULL, 0x000fc40000011687ULL, 0x0000105462657816ULL, 0x000fe40000000065ULL,
0x00000010ff8b7819ULL, 0x000fe4000001165cULL, 0x000010548f627816ULL, 0x000fe40000000092ULL,
0x000010545d5c7816ULL, 0x000fe40000000086ULL, 0x0000105493667816ULL, 0x000fe40000000064ULL,
0x00000010ff427819ULL, 0x000fe20000011642ULL, 0x000000623c4c723cULL, 0x002fe2000004184cULL,
0x00000010ff8f7819ULL, 0x000fc40000011643ULL, 0x00000010ff867819ULL, 0x000fe40000011661ULL,
0x00000010ff937819ULL, 0x000fe20000011640ULL, 0x000000663c54723cULL, 0x000fe20000041854ULL,
0x00000010ff437819ULL, 0x000fe4000001168cULL, 0x000010545e5d7816ULL, 0x000fe40000000087ULL,
0x00000010ff617819ULL, 0x000fe2000001167aULL, 0x00000066340c723cULL, 0x000fe2000004180cULL,
0x00000010ff607819ULL, 0x000fe20000011660ULL, 0x00017000737a7836ULL, 0x000fe20000000000ULL,
0x00000010ff947819ULL, 0x000fc40000011694ULL, 0x00000010ff407819ULL, 0x000fe20000011690ULL,
0x0000005c3c2c723cULL, 0x000fe2000004182cULL, 0x00000010ff8c7819ULL, 0x000fe4000001168dULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff857819ULL, 0x000fe20000011685ULL,
0x000000623414723cULL, 0x000fe20000041814ULL, 0x00000010ff877819ULL, 0x000fe4000001165fULL,
0x00000010ff847819ULL, 0x000fc40000011684ULL, 0x0000105442417816ULL, 0x000fe20000000041ULL,
0x0000005c3420723cULL, 0x000fe20000041820ULL, 0x0000105443427816ULL, 0x000fe4000000008eULL,
0x0000105461607816ULL, 0x000fe40000000060ULL, 0x0000105497647816ULL, 0x000fe40000000094ULL,
0x0000105493407816ULL, 0x000fe40000000040ULL, 0x000010548c437816ULL, 0x000fc4000000008fULL,
0x000010548a5e7816ULL, 0x000fe2000000008bULL, 0x000000643c48723cULL, 0x000fe20000041848ULL,
0x00001054855f7816ULL, 0x000fe40000000086ULL, 0x0000105487617816ULL, 0x000fc60000000084ULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x000000403418723cULL, 0x000fe20000041818ULL, 0x000000106f3c7824ULL, 0x000fca00078e027cULL,
0x000000643410723cULL, 0x000fe20000041810ULL, 0x0000001072407824ULL, 0x000fe200078e027cULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0x000000107d7c7824ULL, 0x000fc600078e027aULL,
0x00000042341c723cULL, 0x000fec000004181cULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000603444723cULL, 0x000fe20000041844ULL, 0x000000004034783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x080fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x088fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x00000010795c7824ULL, 0x000fe200078e027aULL, 0x000000007c40783bULL, 0x004eaa0000004200ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x00000010ff907819ULL, 0x104fe40000011640ULL,
0x000000ff40607812ULL, 0x000fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fc40000011640ULL,
0x0000ffff40927812ULL, 0x000fe400078ec0ffULL, 0x00000010ff937819ULL, 0x100fe40000011641ULL,
0x000000ff41637812ULL, 0x040fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x0000ffff41947812ULL, 0x000fe400078ec0ffULL, 0x00000010ff957819ULL, 0x000fc40000011642ULL,
0x000000ff42667812ULL, 0x040fe400078ec0ffULL, 0x00000018ff417819ULL, 0x000fe40000011642ULL,
0x0000ffff428e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8d7819ULL, 0x100fe40000011643ULL,
0x000000ff43677812ULL, 0x000fe400078ec0ffULL, 0x00000018ff427819ULL, 0x000fc40000011643ULL,
0x0000ffff438f7812ULL, 0x000fe400078ec0ffULL, 0x00000060ff64723eULL, 0x000fe400020006ffULL,
0x00000010ff8c7819ULL, 0x128fe4000001165cULL, 0x000000ff5c657812ULL, 0x040fe200078ec0ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000018ff437819ULL, 0x000fe4000001165cULL,
0x0000ffff5c8a7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff917819ULL, 0x100fe4000001165dULL,
0x000000ff5d977812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d8b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff607819ULL, 0x000fe4000001165eULL,
0x000000ff5e847812ULL, 0x000fc400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe4000001165eULL,
0x0000ffff5e877812ULL, 0x000fe400078ec0ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000010ff867819ULL, 0x100fe4000001165fULL, 0x000000ff5f5e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff967819ULL, 0x000fc4000001165fULL, 0x0000ffff5f857812ULL, 0x000fe400078ec0ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000066ff5d723eULL, 0x000fe400020006ffULL,
0x00000067ff5f723eULL, 0x000fe200020006ffULL, 0x20000062ff677230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000063ff667230ULL, 0x000fe20000004100ULL,
0x00000097ff97723eULL, 0x000fe200020006ffULL, 0x2000005dff627230ULL, 0x000fe20000004100ULL,
0x00000065ff5d723eULL, 0x000fe200020006ffULL, 0x2000005fff637230ULL, 0x000fe20000004100ULL,
0x00000043ff5f723eULL, 0x000fe200020006ffULL, 0x20000041ff657230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x2000005dff417230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x2000005fff5d7230ULL, 0x000fe20000004100ULL,
0x00000061ff5f723eULL, 0x000fe200020006ffULL, 0x20000097ff437230ULL, 0x000fe20000004100ULL,
0x00000096ff96723eULL, 0x000fc400020006ffULL, 0x0000005eff97723eULL, 0x000fe200020006ffULL,
0x2000005cff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff927819ULL, 0x000fe20000011692ULL,
0x20000084ff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff90907812ULL, 0x000fe200078ec0ffULL,
0x2000005fff847230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x20000096ff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff967819ULL, 0x000fe20000011694ULL,
0x20000097ff617230ULL, 0x000fe20000004100ULL, 0x000000ff95977812ULL, 0x000fe200078ec0ffULL,
0x20000092ff957230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff93937812ULL, 0x000fe400078ec0ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x00000097ff97723eULL, 0x000fe400020006ffULL,
0x00000008ff927819ULL, 0x000fe4000001168fULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x20000097ff8f7230ULL, 0x000fe20000004100ULL, 0x00000093ff94723eULL, 0x000fe200020006ffULL,
0x20000090ff937230ULL, 0x000fe20000004100ULL, 0x000000ff8c8c7812ULL, 0x000fe200078ec0ffULL,
0x20000096ff907230ULL, 0x000fe20000004100ULL, 0x00000008ff8e7819ULL, 0x000fe2000001168eULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x00000092ff96723eULL, 0x000fe200020006ffULL,
0x2000008dff927230ULL, 0x000fe20000004100ULL, 0x00000042ff42723eULL, 0x000fc400020006ffULL,
0x0000008cff8d723eULL, 0x000fe200020006ffULL, 0x20000096ff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff8a7819ULL, 0x000fe2000001168aULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x000000ff91977812ULL, 0x000fe200078ec0ffULL, 0x2000008eff917230ULL, 0x000fe20000004100ULL,
0x00000008ff8b7819ULL, 0x000fc4000001168bULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x000000ff86967812ULL, 0x000fe400078ec0ffULL, 0x000000ff60607812ULL, 0x000fe400078ec0ffULL,
0x00000008ff867819ULL, 0x000fe20000011687ULL, 0x2000008aff877230ULL, 0x000fe20000004100ULL,
0x000010548f627816ULL, 0x000fe40000000062ULL, 0x00000097ff8e723eULL, 0x000fc400020006ffULL,
0x00000008ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff8f7819ULL, 0x000fe20000011641ULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000096ff97723eULL, 0x000fe400020006ffULL, 0x00000010ff427819ULL, 0x000fe20000011642ULL,
0x2000008bff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fc4000001168cULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000010ff8c7819ULL, 0x000fe4000001168dULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000060ff8b7230ULL, 0x000fe20000004100ULL,
0x00000086ff96723eULL, 0x000fe200020006ffULL, 0x20000097ff867230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x0000105442417816ULL, 0x000fe20000000041ULL, 0x20000096ff607230ULL, 0x000fe20000004100ULL,
0x000010548c427816ULL, 0x000fe2000000008fULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff977819ULL, 0x000fc40000011666ULL, 0x00000010ff947819ULL, 0x000fe40000011694ULL,
0x00000010ff8c7819ULL, 0x000fe4000001165dULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff967819ULL, 0x000fe40000011667ULL, 0x00000010ff8d7819ULL, 0x000fe4000001165cULL,
0x0000105494677816ULL, 0x000fc40000000097ULL, 0x000010548c5c7816ULL, 0x000fe40000000087ULL,
0x00000010ff947819ULL, 0x000fe40000011665ULL, 0x00000010ff877819ULL, 0x000fe40000011661ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff407819ULL, 0x000fc40000011640ULL, 0x00000010ff657819ULL, 0x000fe40000011690ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff5d7819ULL, 0x000fe4000001168aULL,
0x00000010ff617819ULL, 0x000fe40000011684ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff957819ULL, 0x000fc40000011695ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff917819ULL, 0x000fe40000011691ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff8a7819ULL, 0x000fc4000001168bULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff847819ULL, 0x000fe4000001165fULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x0000105493667816ULL, 0x000fe40000000064ULL, 0x0000105440657816ULL, 0x000fe40000000065ULL,
0x000010545e5d7816ULL, 0x000fc4000000005dULL, 0x0000105461607816ULL, 0x000fe20000000060ULL,
0x000000663c54723cULL, 0x002fe20000041854ULL, 0x0000105496647816ULL, 0x000fe40000000095ULL,
0x0000105492637816ULL, 0x000fe40000000063ULL, 0x0000105494407816ULL, 0x000fe20000000091ULL,
0x0000005c3c2c723cULL, 0x000fe2000004182cULL, 0x000010548e437816ULL, 0x000fe40000000043ULL,
0x000010548a5e7816ULL, 0x000fc4000000008dULL, 0x00001054865f7816ULL, 0x000fe20000000087ULL,
0x000000643c48723cULL, 0x000fe20000041848ULL, 0x0000105484617816ULL, 0x000fca0000000085ULL,
0x000000623c4c723cULL, 0x000fec000004184cULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000603c24723cULL, 0x000fec0000041824ULL, 0x00000066340c723cULL, 0x000fe2000004180cULL,
0x00000002713d7824ULL, 0x000fe200078e00ffULL, 0x000000086b3c7c11ULL, 0x000fe2000f8e18ffULL,
0x00000001ff3f7424ULL, 0x000fc600078e00ffULL, 0xfffffff83d3e7812ULL, 0x000fe200078ec0ffULL,
0x000000643410723cULL, 0x000fe20000041810ULL, 0x01a6c83f3c3c79a7ULL, 0x00026a000850003fULL,
0x000000623414723cULL, 0x000fe20000041814ULL, 0x01a6903f3eff79a7ULL, 0x0003ea0008500008ULL,
0x000000403418723cULL, 0x000fec0000041818ULL, 0x00000042341c723cULL, 0x000fec000004181cULL,
0x0000005c3420723cULL, 0x000fec0000041820ULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000603444723cULL, 0x002fde0000041844ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000003d060075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003f36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x0000003d060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009000ff347b82ULL, 0x000e620000000a00ULL, 0x0000001071367824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x0000000481817c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe0363c7812ULL, 0x000fe400078ec0ffULL, 0x0000004081817824ULL, 0x000fc600078e00ffULL,
0x00000100073c7824ULL, 0x000fc800078e023cULL, 0x000000c03c3d7836ULL, 0x000fca0000000000ULL,
0x000000203d377812ULL, 0x000fe200078ec0ffULL, 0x0000008081347825ULL, 0x002fc800078e0034ULL,
0x000000015a417824ULL, 0x000fe200078e0237ULL, 0x0000000000f49947ULL, 0x000fec0003800000ULL,
0x0000001036377812ULL, 0x000fe400078ec0ffULL, 0x0000003d76367248ULL, 0x000fe40007fe0000ULL,
0x00000003ff3c7819ULL, 0x000fc60000011609ULL, 0x0000000136367824ULL, 0x000fe400078e0a3dULL,
0x000000013c3e7824ULL, 0x000fe400078e0237ULL, 0x000000043c3f7836ULL, 0x000fe20000000000ULL,
0x0000003637367248ULL, 0x000fe20007fe0000ULL, 0x000000013e3d7824ULL, 0x040fe400078e0209ULL,
0x000000083e407824ULL, 0x000fe400078e00ffULL, 0x0000000136367824ULL, 0x000fc400078e0a37ULL,
0x000000083c427836ULL, 0x000fe20000000000ULL, 0xfffffff8405f7812ULL, 0x000fe200078ee23dULL,
0x000000013f407824ULL, 0x040fe200078e0237ULL, 0x000000363f00720cULL, 0x080fe20003f66070ULL,
0x0000000c3c3f7836ULL, 0x000fe20000000000ULL, 0x000000363c00720cULL, 0x080fe20003f86070ULL,
0x000000013e3c7824ULL, 0x000fe200078e0241ULL, 0x000000364200720cULL, 0x080fe20003f46070ULL,
0x00000001403d7824ULL, 0x040fe200078e0209ULL, 0x000000363f00720cULL, 0x000fe20003f06070ULL,
0x00000008403e7824ULL, 0x000fc400078e00ffULL, 0x0000000142427824ULL, 0x100fe400078e0237ULL,
0x000000013f5c7824ULL, 0x000fe200078e0237ULL, 0xfffffff83e617812ULL, 0x000fe200078ee23dULL,
0x000000803c3c7825ULL, 0x000fc800078e00ffULL, 0x00000001403e7824ULL, 0x100fe200078e0241ULL,
0x000000693c377212ULL, 0x000fe200078efcffULL, 0x0000000142407824ULL, 0x040fe400078e0241ULL,
0x0000000142437824ULL, 0x040fe200078e0209ULL, 0x00000037343c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000842427824ULL, 0x000fe400078e00ffULL, 0x000000803e3e7825ULL, 0x000fc600078e00ffULL,
0xfffffff842637812ULL, 0x000fe200078ee243ULL, 0x000000015c367824ULL, 0x000fe200078e0241ULL,
0x000000693e437212ULL, 0x000fe200078efcffULL, 0x0000008040407825ULL, 0x000fc800078e00ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x00000069405d7212ULL, 0x000fc600078efcffULL,
0x00000001353d7824ULL, 0x040fe200028e063dULL, 0x00000043343e7210ULL, 0x000fe20007fbe0ffULL,
0x000000015c427824ULL, 0x000fe200078e0209ULL, 0x0000006936437212ULL, 0x000fe200078efcffULL,
0x000000085c657824ULL, 0x000fe400078e00ffULL, 0x00000001353f7824ULL, 0x000fe200028e063fULL,
0x0000005d34407210ULL, 0x000fe20007fbe0ffULL, 0x000000105f5f7824ULL, 0x100fe200078e027aULL,
0x0000004334347210ULL, 0x000fe20007fde0ffULL, 0x0000001061617824ULL, 0x100fe200078e027aULL,
0xfffffff865437812ULL, 0x000fe200078ee242ULL, 0x0000000135417824ULL, 0x000fe200028e0641ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c5f7faeULL, 0x0003e2000e101c46ULL,
0x0000001063637824ULL, 0x000fc400078e027aULL, 0x0000000135357824ULL, 0x000fe200030e0637ULL,
0x000000003e617faeULL, 0x0003e2000d901c46ULL, 0x0000001043437824ULL, 0x000fc600078e027aULL,
0x0000000040637faeULL, 0x0003e8000d101c46ULL, 0x0000000034437faeULL, 0x0003e2000c101c46ULL,
0x0000000000c07947ULL, 0x000fea0003800000ULL, 0x0000001036367812ULL, 0x000fc800078ec0ffULL,
0x0000003609367211ULL, 0x000fca00078fe8ffULL, 0x00000004363e7836ULL, 0x000fe40000000000ULL,
0x0000000836407836ULL, 0x000fe40000000000ULL, 0x000000013e3c7824ULL, 0x140fe400078e0209ULL,
0x000000083e637824ULL, 0x000fe400078e00ffULL, 0x0000000136377824ULL, 0x140fe400078e0209ULL,
0x0000000836427824ULL, 0x000fe200078e00ffULL, 0xfffffff863637812ULL, 0x000fe200078ee23cULL,
0x00000001403d7824ULL, 0x000fc400078e0209ULL, 0x00000008405c7824ULL, 0x000fe200078e00ffULL,
0xfffffff842617812ULL, 0x000fe200078ee237ULL, 0x00000001363c7824ULL, 0x000fe400078e0241ULL,
0x0000000c36427836ULL, 0x000fe20000000000ULL, 0xfffffff85c657812ULL, 0x000fe200078ee23dULL,
0x000000803c3c7825ULL, 0x000fc800078e00ffULL, 0x000000013e3e7824ULL, 0x100fe200078e0241ULL,
0x000000693c437212ULL, 0x000fe200078efcffULL, 0x0000000140407824ULL, 0x100fe400078e0241ULL,
0x0000000142367824ULL, 0x000fe200078e0241ULL, 0x00000043343c7210ULL, 0x000fe20007f1e0ffULL,
0x000000803e3e7825ULL, 0x000fc800078e00ffULL, 0x0000008040407825ULL, 0x000fe200078e00ffULL,
0x000000693e5f7212ULL, 0x000fc600078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x00000069405d7212ULL, 0x080fe400078efcffULL, 0x0000005f343e7210ULL, 0x000fe20007f5e0ffULL,
0x00000001425c7824ULL, 0x000fe200078e0209ULL, 0x0000006936437212ULL, 0x000fe200078efcffULL,
0x0000000842677824ULL, 0x000fe400078e00ffULL, 0x00000001353d7824ULL, 0x000fe200000e063dULL,
0x0000005d34407210ULL, 0x000fe20007f1e0ffULL, 0x0000001061617824ULL, 0x100fe200078e027aULL,
0xfffffff867677812ULL, 0x000fe200078ee25cULL, 0x00000001353f7824ULL, 0x000fe200010e063fULL,
0x0000004334347210ULL, 0x000fe20007f7e0ffULL, 0x0000001063637824ULL, 0x000fe200078e027aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c617faeULL, 0x0003e2000b901c46ULL,
0x0000000135417824ULL, 0x000fc400000e0641ULL, 0x0000001065657824ULL, 0x100fe200078e027aULL,
0x000000003e637faeULL, 0x0003e2000b901c46ULL, 0x0000000135357824ULL, 0x000fe400018e0637ULL,
0x0000001067677824ULL, 0x000fe200078e027aULL, 0x0000000040657faeULL, 0x0003e8000b901c46ULL,
0x0000000034677faeULL, 0x0003e4000b901c46ULL, 0x0000000359377836ULL, 0x000fe40000000000ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x000000743700720cULL, 0x000fe20003f06070ULL,
0x0000000871367824ULL, 0x000fca00078e00ffULL, 0xfffffff036367812ULL, 0x000fca00078ec0ffULL,
0x0000000836847c36ULL, 0x000fe40008000000ULL, 0x00009200ff348b82ULL, 0x002e620000000a00ULL,
0x0000000108378824ULL, 0x000fe200078e0237ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000840472caULL, 0x000fda00000e0000ULL, 0x0001a6b004047890ULL, 0x000fe2000fffe03fULL,
0x0000000437348825ULL, 0x002fd000078e0034ULL, 0x00000000ff0079b0ULL, 0x000fe80008000a44ULL,
0x0000000634818981ULL, 0x000322000c1e1900ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x01a6b037848479a7ULL, 0x0004e2000850003fULL,
0x01a64837803479a7ULL, 0x002464000850003fULL, 0x0000000000367805ULL, 0x004fce0000015200ULL,
0x01a64835800075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fce0000015200ULL,
0x0000003c363f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e37ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc8000001143dULL, 0x0000003f3c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3d7224ULL, 0x000fca00000e063dULL, 0x000000023c3c7819ULL, 0x000fc8000000123dULL,
0x0000003c0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x01a64835800075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002071347824ULL, 0x000fe400078e00ffULL,
0x00000008ff357e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff3c7424ULL, 0x000fe200078e00ffULL,
0xffffff8034347812ULL, 0x000fc800078ec0ffULL, 0x0000010035347810ULL, 0x000fc80007ffe034ULL,
0x000000346e347210ULL, 0x000fca0007ffe069ULL, 0x01a0000034367984ULL, 0x000e680000000800ULL,
0x01a2000034357984ULL, 0x0004a20000000800ULL, 0x000000833600720bULL, 0x002fda0003f1d000ULL,
0x0000000000377806ULL, 0x000fc800000e0100ULL, 0x000000ff3700720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x00cfea0003800000ULL, 0x000000026a347836ULL, 0x000fe20000000000ULL,
0x000000833600720bULL, 0x000fc80003f14000ULL, 0x000000713400720cULL, 0x000fda0003f45270ULL,
0x00000008713cac11ULL, 0x000fe4000f8e38ffULL, 0x000000833634a209ULL, 0x000fe40007810000ULL,
0x0000003c6e3da210ULL, 0x000fe40007ffe069ULL, 0x00000000003c7806ULL, 0x000fc600000e0100ULL,
0x01a400343d00a388ULL, 0x0003e20000000800ULL, 0x000000ff3c00720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x0000008336347209ULL, 0x000fe40007810000ULL,
0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL,
0x0000008334347221ULL, 0x000fe20000010100ULL, 0x00ff00003cff7812ULL, 0x040fe4000786c0ffULL,
0xff0000003cff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x00000034003d7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff347819ULL, 0x002fcc0000011609ULL, 0x00001f343d347589ULL, 0x004e6400000e0000ULL,
0x0000005434547220ULL, 0x042fe20000410000ULL, 0x0000005534557220ULL, 0x040fe20000410000ULL,
0x0000004834487220ULL, 0x040fe20000410000ULL, 0x0000004934497220ULL, 0x040fe20000410000ULL,
0x0000004c344c7220ULL, 0x040fe20000410000ULL, 0x0000004d344d7220ULL, 0x040fe20000410000ULL,
0x0000005034507220ULL, 0x040fe20000410000ULL, 0x0000005134517220ULL, 0x040fe20000410000ULL,
0x0000003034307220ULL, 0x040fe20000410000ULL, 0x0000003134317220ULL, 0x040fe20000410000ULL,
0x0000002c342c7220ULL, 0x040fe20000410000ULL, 0x0000002d342d7220ULL, 0x040fe20000410000ULL,
0x0000002834287220ULL, 0x040fe20000410000ULL, 0x0000002934297220ULL, 0x040fe20000410000ULL,
0x0000002434247220ULL, 0x040fe20000410000ULL, 0x0000002534257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x0000000809347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343d347589ULL, 0x004e6400000e0000ULL, 0x0000005634567220ULL, 0x042fe20000410000ULL,
0x0000005734577220ULL, 0x040fe20000410000ULL, 0x0000004a344a7220ULL, 0x040fe20000410000ULL,
0x0000004b344b7220ULL, 0x040fe20000410000ULL, 0x0000004e344e7220ULL, 0x040fe20000410000ULL,
0x0000004f344f7220ULL, 0x040fe20000410000ULL, 0x0000005234527220ULL, 0x040fe20000410000ULL,
0x0000005334537220ULL, 0x040fe20000410000ULL, 0x0000003234327220ULL, 0x040fe20000410000ULL,
0x0000003334337220ULL, 0x040fe20000410000ULL, 0x0000002e342e7220ULL, 0x040fe20000410000ULL,
0x0000002f342f7220ULL, 0x040fe20000410000ULL, 0x0000002a342a7220ULL, 0x040fe20000410000ULL,
0x0000002b342b7220ULL, 0x040fe20000410000ULL, 0x0000002634267220ULL, 0x040fe20000410000ULL,
0x0000002734277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x0000001009347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343d347589ULL, 0x004e6400000e0000ULL,
0x0000000c340c7220ULL, 0x042fe20000410000ULL, 0x0000000d340d7220ULL, 0x040fe20000410000ULL,
0x0000001034107220ULL, 0x040fe20000410000ULL, 0x0000001134117220ULL, 0x040fe20000410000ULL,
0x0000001434147220ULL, 0x040fe20000410000ULL, 0x0000001534157220ULL, 0x040fe20000410000ULL,
0x0000001834187220ULL, 0x040fe20000410000ULL, 0x0000001934197220ULL, 0x040fe20000410000ULL,
0x0000001c341c7220ULL, 0x040fe20000410000ULL, 0x0000001d341d7220ULL, 0x040fe20000410000ULL,
0x0000002034207220ULL, 0x040fe20000410000ULL, 0x0000002134217220ULL, 0x040fe20000410000ULL,
0x0000003834387220ULL, 0x040fe20000410000ULL, 0x0000003934397220ULL, 0x040fe20000410000ULL,
0x0000004434447220ULL, 0x040fe20000410000ULL, 0x0000004534457220ULL, 0x000fce0000410000ULL,
0x0000003d82827220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x0000001809347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343d347589ULL, 0x000e6400000e0000ULL,
0x0000000e340e7220ULL, 0x042fe20000410000ULL, 0x0000000f340f7220ULL, 0x040fe20000410000ULL,
0x0000001234127220ULL, 0x040fe20000410000ULL, 0x0000001334137220ULL, 0x040fe20000410000ULL,
0x0000001634167220ULL, 0x040fe20000410000ULL, 0x0000001734177220ULL, 0x040fe20000410000ULL,
0x0000001a341a7220ULL, 0x040fe20000410000ULL, 0x0000001b341b7220ULL, 0x040fe20000410000ULL,
0x0000001e341e7220ULL, 0x040fe20000410000ULL, 0x0000001f341f7220ULL, 0x040fe20000410000ULL,
0x0000002234227220ULL, 0x040fe20000410000ULL, 0x0000002334237220ULL, 0x040fe20000410000ULL,
0x0000003a343a7220ULL, 0x040fe20000410000ULL, 0x0000003b343b7220ULL, 0x040fe20000410000ULL,
0x0000004634467220ULL, 0x040fe20000410000ULL, 0x0000004734477220ULL, 0x000fce0000410000ULL,
0x0000003c37ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff3c7424ULL, 0x000fe200078e00ffULL,
0x0000008336837209ULL, 0x000fd60007810000ULL, 0x8000008336360221ULL, 0x000fe20000010000ULL,
0x00007610ff3c0816ULL, 0x000fc6000000003cULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600040308ULL, 0x000ea40000000800ULL, 0x0000000435350220ULL, 0x004fce0000410000ULL,
0x0000008235827221ULL, 0x000fce0000010000ULL, 0x0000000000347805ULL, 0x002fce0000015200ULL,
0x0000000871367824ULL, 0x000fca00078e00ffULL, 0xfffffff036377812ULL, 0x000fc800078ec0ffULL,
0x01a6a889370075a7ULL, 0x000e620008000148ULL, 0x00000008373f7c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a6a8893f0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000099103c347816ULL, 0x000fe200000000ffULL, 0x0000040071357824ULL, 0x040fe400078e00ffULL,
0x0000100071367824ULL, 0x000fe200078e00ffULL, 0x000000ff3400720cULL, 0x000fe20003f05270ULL,
0x00000008ff807e24ULL, 0x000fe2000f8e00ffULL, 0xfffff00035357812ULL, 0x000fe200078ec0ffULL,
0x00000008ff377e24ULL, 0x000fe2000f8e00ffULL, 0xffffe00036367812ULL, 0x000fe400078ec0ffULL,
0x0001400080807810ULL, 0x000fc40007ffe035ULL, 0x00016000375c7810ULL, 0x000fc60007ffe036ULL,
0x000000107f3c7824ULL, 0x100fe400078e0280ULL, 0x000000107e347824ULL, 0x000fe400078e0280ULL,
0x000000106d417824ULL, 0x000fe200078e025cULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff367819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000000836027836ULL, 0x000fe20000000000ULL, 0x0000541000357816ULL, 0x000fe20000000000ULL,
0x00000010363e7836ULL, 0x000fe40000000000ULL, 0x0000001836407836ULL, 0x000fe40000000000ULL,
0x00001f0235027589ULL, 0x0002a800000e0000ULL, 0x00001f3e35057589ULL, 0x0002e800000e0000ULL,
0x00001f3635037589ULL, 0x00026800000e0000ULL, 0x00001f4035007589ULL, 0x00026400000e0000ULL,
0x000000003c3c783bULL, 0x002e680000000200ULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x084fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x088fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x000000107b5c7824ULL, 0x000fe200078e025cULL,
0x000000004140783bULL, 0x000f6a0000004200ULL, 0x000000005c5c783bULL, 0x000f640000004200ULL,
0x000000ff40607812ULL, 0x028fe400078ec0ffULL, 0x00000010ff927819ULL, 0x000fc40000011641ULL,
0x00000060ff64723eULL, 0x000fe400020006ffULL, 0x00000010ff8b7819ULL, 0x104fe4000001165cULL,
0x000000ff5c957812ULL, 0x040fe200078ec0ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000018ff947819ULL, 0x000fe4000001165cULL, 0x0000ffff5c877812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fc4000001165dULL, 0x000000ff5e617812ULL, 0x040fe400078ec0ffULL,
0x00000010ff7b7819ULL, 0x100fe4000001165eULL, 0x00000018ff607819ULL, 0x000fe4000001165eULL,
0x0000ffff5e7f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5f5e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff937819ULL, 0x000fc4000001165fULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000010ff867819ULL, 0x000fe4000001165fULL,
0x0000ffff5f7e7812ULL, 0x000fe400078ec0ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000005eff5f723eULL, 0x000fe200020006ffULL, 0x2000005cff5e7230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x20000061ff5c7230ULL, 0x000fe20000004100ULL,
0x0000ffff41907812ULL, 0x000fe200078ec0ffULL, 0x20000060ff617230ULL, 0x000fe20000004100ULL,
0x0000ffff40917812ULL, 0x000fe200078ec0ffULL, 0x2000005fff607230ULL, 0x000fe20000004100ULL,
0x000000ff92927812ULL, 0x000fe200078ec0ffULL, 0x20000093ff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x000fc40000011642ULL, 0x00000008ff937819ULL, 0x000fe40000011690ULL,
0x00000008ff917819ULL, 0x000fe40000011691ULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff42897812ULL, 0x000fc400078ec0ffULL, 0x0000ffff438c7812ULL, 0x000fe400078ec0ffULL,
0x00000091ff90723eULL, 0x000fe200020006ffULL, 0x20000092ff917230ULL, 0x000fe20000004100ULL,
0x0000008eff92723eULL, 0x000fe200020006ffULL, 0x20000093ff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ff897819ULL, 0x000fe20000011689ULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000008ff937819ULL, 0x000fe2000001168cULL, 0x20000092ff8c7230ULL, 0x000fe20000004100ULL,
0x00000010ff8f7819ULL, 0x000fc40000011640ULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x0000ffff5d887812ULL, 0x000fe400078ec0ffULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x20000089ff927230ULL, 0x000fe20000004100ULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe20000011640ULL, 0x20000093ff897230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fc40000011643ULL, 0x00000008ff877819ULL, 0x000fe40000011687ULL,
0x000000ff41637812ULL, 0x000fe400078ec0ffULL, 0x00000008ff887819ULL, 0x000fe40000011688ULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x000000ff7b7b7812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x000000ff8a8a7812ULL, 0x000fc400078ec0ffULL, 0x000000ff86937812ULL, 0x000fe200078ec0ffULL,
0x20000062ff677230ULL, 0x000fe20000004100ULL, 0x000000ff43667812ULL, 0x000fe400078ec0ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x000000ff42657812ULL, 0x000fe200078ec0ffULL, 0x20000087ff867230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fc400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000018ff417819ULL, 0x000fe40000011642ULL, 0x00000010ff8d7819ULL, 0x000fe2000001165dULL,
0x20000088ff877230ULL, 0x000fe20000004100ULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x00000018ff427819ULL, 0x000fe40000011643ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x2000007bff887230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fc400020006ffULL,
0x000000ff5d967812ULL, 0x000fe400078ec0ffULL, 0x00000066ff43723eULL, 0x000fe200020006ffULL,
0x20000063ff667230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000093ff7b7230ULL, 0x000fe20000004100ULL, 0x00000094ff5d723eULL, 0x000fe200020006ffULL,
0x20000043ff637230ULL, 0x000fe20000004100ULL, 0x000000ff8b8b7812ULL, 0x000fe200078ec0ffULL,
0x20000065ff627230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff8d947812ULL, 0x000fe200078ec0ffULL,
0x2000008aff8d7230ULL, 0x000fe20000004100ULL, 0x00000095ff95723eULL, 0x000fe200020006ffULL,
0x20000041ff657230ULL, 0x000fe20000004100ULL, 0x00000008ff7f7819ULL, 0x000fc4000001167fULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x20000095ff417230ULL, 0x000fe20000004100ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x0000008bff8a723eULL, 0x000fe400020006ffULL,
0x00000008ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff937819ULL, 0x000fe20000011667ULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fc40000011690ULL,
0x00000094ff8b723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000096ff43723eULL, 0x000fe200020006ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x00000010ff947819ULL, 0x000fe20000011666ULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x0000007fff7f723eULL, 0x000fc400020006ffULL, 0x000010548f667816ULL, 0x000fe20000000064ULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x0000105493647816ULL, 0x000fe40000000090ULL,
0x00000010ff907819ULL, 0x000fe20000011663ULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff637819ULL, 0x000fc4000001168cULL,
0x00000010ff8d7819ULL, 0x000fe4000001168dULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff8c7819ULL, 0x000fe40000011641ULL,
0x00000010ff417819ULL, 0x000fe40000011689ULL, 0x0000105463627816ULL, 0x000fc40000000062ULL,
0x00000010ff897819ULL, 0x000fe4000001165cULL, 0x000010548d637816ULL, 0x000fe40000000090ULL,
0x000010545d5c7816ULL, 0x000fe40000000086ULL, 0x00000010ff8f7819ULL, 0x000fe40000011665ULL,
0x00000010ff427819ULL, 0x000fe20000011642ULL, 0x000000623c4c723cULL, 0x002fe2000004184cULL,
0x00000010ff8d7819ULL, 0x000fc40000011643ULL, 0x00000010ff867819ULL, 0x000fe40000011660ULL,
0x00000010ff407819ULL, 0x000fe20000011640ULL, 0x000000623414723cULL, 0x000fe20000041814ULL,
0x00000010ff657819ULL, 0x000fe4000001168eULL, 0x00000010ff437819ULL, 0x000fe4000001168aULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff877819ULL, 0x000fc40000011687ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff607819ULL, 0x000fe4000001167fULL,
0x00000010ff677819ULL, 0x000fe40000011691ULL, 0x00000010ff927819ULL, 0x000fe40000011692ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168bULL, 0x00000010ff887819ULL, 0x000fc40000011688ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff7f7819ULL, 0x000fe4000001165fULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x0000105442417816ULL, 0x000fe40000000041ULL,
0x0000105440657816ULL, 0x000fe40000000065ULL, 0x0000105443427816ULL, 0x000fc4000000008cULL,
0x000010545e5d7816ULL, 0x000fe40000000087ULL, 0x0000105461607816ULL, 0x000fe20000000060ULL,
0x000000643c48723cULL, 0x000fe20000041848ULL, 0x0000105467677816ULL, 0x000fe40000000094ULL,
0x000010548f407816ULL, 0x000fe40000000092ULL, 0x000010548a437816ULL, 0x000fe2000000008dULL,
0x0000005c3c2c723cULL, 0x000fe2000004182cULL, 0x00001054885e7816ULL, 0x000fc40000000089ULL,
0x000010547b5f7816ULL, 0x000fe40000000086ULL, 0x000010547f617816ULL, 0x000fe2000000007eULL,
0x000000663c54723cULL, 0x000fe20000041854ULL, 0x00016000737e7836ULL, 0x000fca0000000000ULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x00000066340c723cULL, 0x000fe2000004180cULL, 0x000000106f3c7824ULL, 0x000fc400078e0280ULL,
0x0000001072807824ULL, 0x000fc600078e0280ULL, 0x000000643410723cULL, 0x000fe20000041810ULL,
0x000000003c3c783bULL, 0x000e6a0000000200ULL, 0x000000403418723cULL, 0x000fec0000041818ULL,
0x00000042341c723cULL, 0x000fe2000004181cULL, 0x000000107d417824ULL, 0x000fca00078e027eULL,
0x0000005c3420723cULL, 0x000fec0000041820ULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000603444723cULL, 0x000fe20000041844ULL, 0x000000008034783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x080fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x088fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x00000010795c7824ULL, 0x000fe200078e027eULL, 0x000000004140783bULL, 0x000f6a0000004200ULL,
0x000000005c5c783bULL, 0x000f640000004200ULL, 0x000000ff40607812ULL, 0x024fe400078ec0ffULL,
0x00000010ff8f7819ULL, 0x000fc40000011640ULL, 0x00000060ff67723eULL, 0x000fe400020006ffULL,
0x00000010ff897819ULL, 0x108fe4000001165cULL, 0x000000ff5c927812ULL, 0x040fe200078ec0ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000018ff917819ULL, 0x000fe4000001165cULL,
0x0000ffff5c7f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fc4000001165dULL,
0x00000010ff8a7819ULL, 0x000fe4000001165dULL, 0x000000ff5d937812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL, 0x000000ff5e607812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001165eULL, 0x00000018ff907819ULL, 0x000fc4000001165fULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000010ff7d7819ULL, 0x000fe4000001165fULL,
0x000000ff5f617812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5f797812ULL, 0x000fe400078ec0ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x0000005dff5f723eULL, 0x000fe200020006ffULL,
0x2000005cff5d7230ULL, 0x000fe20000004100ULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x20000060ff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x000fe20000011641ULL,
0x2000005fff607230ULL, 0x000fe20000004100ULL, 0x0000ffff418c7812ULL, 0x000fe200078ec0ffULL,
0x20000090ff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff8b7819ULL, 0x000fc40000011642ULL,
0x0000ffff408d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff8e907812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8c7819ULL, 0x000fe4000001168cULL,
0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8e7819ULL, 0x000fc4000001168dULL,
0x0000008fff8d723eULL, 0x000fe400020006ffULL, 0x00000090ff8f723eULL, 0x000fe400020006ffULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x0000ffff42807812ULL, 0x000fe200078ec0ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x0000008bff90723eULL, 0x000fe200020006ffULL, 0x2000008cff8b7230ULL, 0x000fe20000004100ULL,
0x00000008ff807819ULL, 0x000fc40000011680ULL, 0x00000010ff737819ULL, 0x000fe2000001165eULL,
0x20000090ff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff89907812ULL, 0x000fe400078ec0ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x0000ffff5e7b7812ULL, 0x000fe400078ec0ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000091ff5e723eULL, 0x000fc400020006ffULL,
0x000000ff41637812ULL, 0x000fe400078ec0ffULL, 0x00000010ff867819ULL, 0x000fe20000011643ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff8a917812ULL, 0x000fe200078ec0ffULL,
0x20000080ff8a7230ULL, 0x000fe20000004100ULL, 0x00000008ff7f7819ULL, 0x000fe4000001167fULL,
0x00000018ff627819ULL, 0x000fe40000011640ULL, 0x000000ff43667812ULL, 0x000fc400078ec0ffULL,
0x00000008ff807819ULL, 0x000fe20000011687ULL, 0x20000090ff877230ULL, 0x000fe20000004100ULL,
0x000000ff42647812ULL, 0x000fe400078ec0ffULL, 0x000000ff73737812ULL, 0x000fe400078ec0ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x000000ff7d907812ULL, 0x000fc400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x00000018ff657819ULL, 0x000fe40000011643ULL, 0x0000ffff43887812ULL, 0x000fe400078ec0ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000018ff417819ULL, 0x000fe20000011642ULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x2000007fff7d7230ULL, 0x000fe20000004100ULL,
0x00000066ff43723eULL, 0x000fc400020006ffULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x20000062ff667230ULL, 0x000fe20000004100ULL, 0x00000064ff42723eULL, 0x000fe200020006ffULL,
0x20000063ff647230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000043ff637230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x20000080ff7f7230ULL, 0x000fe20000004100ULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x20000042ff627230ULL, 0x000fe20000004100ULL, 0x00000008ff887819ULL, 0x000fe20000011688ULL,
0x20000073ff807230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000086ff897230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x20000090ff737230ULL, 0x000fe20000004100ULL, 0x00000065ff42723eULL, 0x000fe200020006ffULL,
0x20000041ff657230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x20000092ff417230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fe20000011664ULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe2000001168eULL,
0x20000088ff867230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fc400020006ffULL,
0x00000008ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff8e7819ULL, 0x000fe20000011663ULL,
0x20000091ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff637819ULL, 0x000fe4000001168cULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x0000007bff7b723eULL, 0x000fc400020006ffULL, 0x0000105463627816ULL, 0x000fe40000000062ULL,
0x00000008ff917819ULL, 0x000fe20000011679ULL, 0x2000007bff797230ULL, 0x000fe20000004100ULL,
0x0000105489637816ULL, 0x000fe4000000008eULL, 0x00000010ff897819ULL, 0x000fe40000011641ULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff417819ULL, 0x000fe20000011686ULL,
0x000000623c4c723cULL, 0x002fe2000004184cULL, 0x00000040ff40723eULL, 0x000fc400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000010ff867819ULL, 0x000fe20000011687ULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000093ff43723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000091ff7b723eULL, 0x000fe200020006ffULL,
0x000000623414723cULL, 0x000fe20000041814ULL, 0x0000105442417816ULL, 0x000fe20000000041ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x0000105486427816ULL, 0x000fe20000000089ULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff5e7819ULL, 0x000fc4000001165eULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff867819ULL, 0x000fe4000001165dULL,
0x00000010ff877819ULL, 0x000fe4000001165cULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x00000010ff5d7819ULL, 0x000fe4000001167fULL, 0x00000010ff917819ULL, 0x000fc40000011666ULL,
0x00000010ff667819ULL, 0x000fe4000001168dULL, 0x000010545e5c7816ULL, 0x000fe4000000007dULL,
0x00000010ff8d7819ULL, 0x000fe40000011665ULL, 0x00001054805e7816ULL, 0x000fe40000000087ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff407819ULL, 0x000fc40000011640ULL,
0x00000010ff657819ULL, 0x000fe4000001168bULL, 0x00001054865d7816ULL, 0x000fe4000000005dULL,
0x00000010ff7d7819ULL, 0x000fe40000011660ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff807819ULL, 0x000fe20000011673ULL, 0x0000005c3c2c723cULL, 0x000fe2000004182cULL,
0x00000010ff8f7819ULL, 0x000fc4000001168fULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff437819ULL, 0x000fe20000011643ULL, 0x0000005c3420723cULL, 0x000fe20000041820ULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff607819ULL, 0x000fe40000011679ULL,
0x00000010ff867819ULL, 0x000fe4000001165fULL, 0x00000010ff7b7819ULL, 0x000fc4000001167bULL,
0x0000105466667816ULL, 0x000fe40000000067ULL, 0x0000105440657816ULL, 0x000fe40000000065ULL,
0x00001054805f7816ULL, 0x000fe40000000061ULL, 0x000010548f677816ULL, 0x000fe40000000090ULL,
0x0000105491647816ULL, 0x000fe40000000064ULL, 0x000010548d407816ULL, 0x000fe2000000008aULL,
0x0000005e3c28723cULL, 0x000fe20000041828ULL, 0x0000105488437816ULL, 0x000fc40000000043ULL,
0x000010547d607816ULL, 0x000fe40000000060ULL, 0x0000105486617816ULL, 0x000fe2000000007bULL,
0x000000663c54723cULL, 0x000fec0000041854ULL, 0x000000643c48723cULL, 0x000fec0000041848ULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x000000603c24723cULL, 0x000fec0000041824ULL, 0x000000403418723cULL, 0x000fe20000041818ULL,
0x00000002713c7824ULL, 0x000fc400078e00ffULL, 0x00000001ff3f7424ULL, 0x000fc600078e00ffULL,
0xfffffff83c3e7812ULL, 0x000fe200078ec0ffULL, 0x00000066340c723cULL, 0x000fe2000004180cULL,
0x000000086b417c11ULL, 0x000fc8000f8e18ffULL, 0x01a6c83f413c79a7ULL, 0x0002a2000850003fULL,
0x000000643410723cULL, 0x000fec0000041810ULL, 0x00000042341c723cULL, 0x000fe2000004181cULL,
0x01a6983f3eff79a7ULL, 0x0003ea0008500008ULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000603444723cULL, 0x002fde0000041844ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x01a6c83d410075a7ULL, 0x004e62000800017fULL,
0x000000036a3e7836ULL, 0x000fc80000000000ULL, 0x000000ffff367224ULL, 0x000fe200078e003eULL,
0x0000000000600947ULL, 0x002fec0003800000ULL, 0x000000ffff407224ULL, 0x000fce00078e00ffULL,
0x000000104000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003f36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000140407836ULL, 0x000fce0000000000ULL,
0x01a6c83d410075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ffff367224ULL, 0x000fce00078e003eULL, 0x00000001073c7836ULL, 0x000fe40000000000ULL,
0x0000000359597836ULL, 0x000fc60000000000ULL, 0x000000703c00720cULL, 0x000fda0003f06070ULL,
0x0000000800080947ULL, 0x000fea0003800000ULL, 0x00009000ff347b82ULL, 0x000e620000000a00ULL,
0x0000000207377836ULL, 0x000fe20000000000ULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x000001003c3c7824ULL, 0x000fe400078e025bULL, 0x0000000481817c24ULL, 0x010fe2000f8e02ffULL,
0x000000703700720cULL, 0x000fe40003f06070ULL, 0x000000203c377812ULL, 0x000fe200078ec0ffULL,
0x0000004081817824ULL, 0x000fc800078e00ffULL, 0x000000015a427824ULL, 0x000fe400078e0237ULL,
0x0000008081347825ULL, 0x002fc800078e0034ULL, 0x0000000000f88947ULL, 0x000fea0003800000ULL,
0x0000003c76377248ULL, 0x000fe20007fe0000ULL, 0x00000010713d7824ULL, 0x000fc800078e00ffULL,
0x0000000137377824ULL, 0x000fe200078e0a3cULL, 0x000000103d3c7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff3d7819ULL, 0x000fe40000011609ULL, 0x000000373c377248ULL, 0x000fc60007fe0000ULL,
0x000000043d3e7836ULL, 0x000fe40000000000ULL, 0x0000000137377824ULL, 0x100fe400078e0a3cULL,
0x000000083d3f7836ULL, 0x000fe40000000000ULL, 0x0000000c3d417836ULL, 0x000fe20000000000ULL,
0x000000373d00720cULL, 0x0c0fe20003f86070ULL, 0x000000013d3d7824ULL, 0x100fe200078e023cULL,
0x000000373e00720cULL, 0x0c0fe20003f66070ULL, 0x000000013e407824ULL, 0x000fe200078e023cULL,
0x000000373f00720cULL, 0x080fe20003f46070ULL, 0x000000013d3e7824ULL, 0x000fe200078e0242ULL,
0x000000374100720cULL, 0x000fe20003f06070ULL, 0x000000013f437824ULL, 0x000fc400078e023cULL,
0x0000000141597824ULL, 0x000fe400078e023cULL, 0x00000001403c7824ULL, 0x040fe400078e0209ULL,
0x00000008405f7824ULL, 0x040fe400078e00ffULL, 0x0000000140407824ULL, 0x000fe400078e0242ULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fc600078ee23cULL,
0x000000013d377824ULL, 0x140fe400078e0209ULL, 0x000000083d5c7824ULL, 0x000fe400078e00ffULL,
0x00000001433d7824ULL, 0x040fe400078e0209ULL, 0x00000008435e7824ULL, 0x000fe200078e00ffULL,
0xfffffff85c5d7812ULL, 0x000fe200078ee237ULL, 0x0000008040407825ULL, 0x000fc600078e00ffULL,
0xfffffff85e617812ULL, 0x000fe200078ee23dULL, 0x00000001433c7824ULL, 0x100fe200078e0242ULL,
0x000000693e437212ULL, 0x080fe200078efcffULL, 0x0000000159427824ULL, 0x000fe200078e0242ULL,
0x0000006940377212ULL, 0x000fe200078efcffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x00000043343e7210ULL, 0x000fe40007fbe0ffULL, 0x0000003734407210ULL, 0x000fe20007fde0ffULL,
0x0000008042427825ULL, 0x000fc800078e00ffULL, 0x00000001595c7824ULL, 0x040fe200078e0209ULL,
0x0000006942377212ULL, 0x080fe200078efcffULL, 0x0000000859637824ULL, 0x000fe200078e00ffULL,
0x000000693c597212ULL, 0x000fe200078efcffULL, 0x00000001353f7824ULL, 0x040fe400028e063fULL,
0x0000000135417824ULL, 0x000fe200030e0641ULL, 0x00000059343c7210ULL, 0x000fe20007fbe0ffULL,
0x000000105d5d7824ULL, 0x100fe200078e027eULL, 0xfffffff863637812ULL, 0x000fe200078ee25cULL,
0x000000105f5f7824ULL, 0x100fe200078e027eULL, 0x0000003734347210ULL, 0x000fe20007fde0ffULL,
0x0000001061617824ULL, 0x000fe200078e027eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e5d7faeULL, 0x0003e2000e101c46ULL, 0x00000001353d7824ULL, 0x000fc400028e063dULL,
0x0000001063637824ULL, 0x000fe200078e027eULL, 0x00000000405f7faeULL, 0x0003e2000d901c46ULL,
0x0000000135357824ULL, 0x000fc600030e0643ULL, 0x000000003c617faeULL, 0x0003e8000d101c46ULL,
0x0000000034637faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x0000001071377824ULL, 0x000fca00078e00ffULL, 0x00000010373c7812ULL, 0x000fc800078ec0ffULL,
0x0000003c09377211ULL, 0x000fca00078fe8ffULL, 0x00000001373d7824ULL, 0x040fe400078e0209ULL,
0x00000008373e7824ULL, 0x040fe400078e00ffULL, 0x00000001373c7824ULL, 0x000fe400078e0242ULL,
0x00000004373f7836ULL, 0x000fe20000000000ULL, 0xfffffff83e597812ULL, 0x000fe200078ee23dULL,
0x0000000837437836ULL, 0x000fe40000000000ULL, 0x000000803c3c7825ULL, 0x000fc800078e00ffULL,
0x0000000c375c7836ULL, 0x000fe20000000000ULL, 0x000000693c377212ULL, 0x000fe200078efcffULL,
0x000000013f3e7824ULL, 0x140fe400078e0242ULL, 0x000000013f417824ULL, 0x140fe200078e0209ULL,
0x00000037343c7210ULL, 0x000fe20007f1e0ffULL, 0x000000083f5e7824ULL, 0x000fe400078e00ffULL,
0x0000000143407824ULL, 0x040fe400078e0242ULL, 0x00000001433f7824ULL, 0x040fe200078e0209ULL,
0xfffffff85e377812ULL, 0x000fe200078ee241ULL, 0x0000000843607824ULL, 0x000fc400078e00ffULL,
0x000000015c427824ULL, 0x040fe400078e0242ULL, 0x000000015c437824ULL, 0x040fe200078e0209ULL,
0xfffffff860637812ULL, 0x000fe200078ee23fULL, 0x000000085c5c7824ULL, 0x000fe400078e00ffULL,
0x000000803e3e7825ULL, 0x000fc600078e00ffULL, 0xfffffff85c657812ULL, 0x000fe200078ee243ULL,
0x0000008040407825ULL, 0x000fe200078e00ffULL, 0x000000693e5d7212ULL, 0x000fc600078efcffULL,
0x0000008042427825ULL, 0x000fc800078e00ffULL, 0x00000010595f7824ULL, 0x100fe200078e027eULL,
0x0000006940597212ULL, 0x080fe200078efcffULL, 0x0000001037617824ULL, 0x100fe200078e027eULL,
0x0000006942377212ULL, 0x000fe200078efcffULL, 0x00000001353d7824ULL, 0x000fe200000e063dULL,
0x0000005d343e7210ULL, 0x000fe20007f1e0ffULL, 0x0000001063637824ULL, 0x100fe200078e027eULL,
0x0000005934407210ULL, 0x000fe20007f5e0ffULL, 0x0000001065657824ULL, 0x000fe200078e027eULL,
0x0000003734347210ULL, 0x000fe20007f7e0ffULL, 0x00000001353f7824ULL, 0x040fe200000e063fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c5f7faeULL, 0x0003e2000b901c46ULL,
0x0000000135417824ULL, 0x000fc400010e0641ULL, 0x0000000135357824ULL, 0x000fe200018e0643ULL,
0x000000003e617faeULL, 0x0003e8000b901c46ULL, 0x0000000040637faeULL, 0x0003e8000b901c46ULL,
0x0000000034657faeULL, 0x0003e4000b901c46ULL, 0x000000046c597836ULL, 0x000fe40000000000ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x000000745900720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00009200ff347b82ULL, 0x002e620000000a00ULL,
0x0000000108377824ULL, 0x000fc800078e0259ULL, 0x0000000437347825ULL, 0x002fca00078e0034ULL,
0x0000000634817981ULL, 0x000324000c1e1900ULL, 0x0000000871347824ULL, 0x002fe200078e00ffULL,
0x000000086a357c11ULL, 0x000fe2000f8e28ffULL, 0x00000001ff407424ULL, 0x000fc600078e00ffULL,
0xfffffff0343c7812ULL, 0x000fe200078ec0ffULL, 0x0000001058377824ULL, 0x000fe200078e0235ULL,
0x00000008343e7812ULL, 0x000fc600078ec0ffULL, 0x000000083c3d7c36ULL, 0x000fe20008000000ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x000000003d0472caULL, 0x000fda00000e0000ULL,
0x0001a6a804047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01a6a8403d3479a7ULL, 0x000e62000850003fULL,
0x000000013e377824ULL, 0x000fc800078e0237ULL, 0x01a66840373e79a7ULL, 0x0004e4000850003fULL,
0x000000ffff797224ULL, 0x006fce00078e0035ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x01a6683f370075a7ULL, 0x008e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff407224ULL, 0x000fce00078e00ffULL, 0x000000104000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fce0000015200ULL,
0x0000003c34417210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e35ULL,
0x003d09004100780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404100780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc8000001143dULL, 0x000000413c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3d7224ULL, 0x000fca00000e063dULL, 0x000000023c3c7819ULL, 0x000fc8000000123dULL,
0x0000003c0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000140407836ULL, 0x000fce0000000000ULL, 0x01a6683f370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000836367c11ULL, 0x000fe2000f8e38ffULL,
0x00000001ff3c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff7e7224ULL, 0x000fe200078e0083ULL,
0x000000366e367210ULL, 0x000fca0007ffe069ULL, 0x01a00000363e7984ULL, 0x000e680000000800ULL,
0x01a2000036357984ULL, 0x0004a20000000800ULL, 0x000000833e00720bULL, 0x002fda0003f1d000ULL,
0x0000000000377806ULL, 0x000fc800000e0100ULL, 0x000000ff3700720cULL, 0x000fda0003f05270ULL,
0x0000000400948947ULL, 0x004fea0003800000ULL, 0x000000036a347836ULL, 0x000fe20000000000ULL,
0x000000833e00720bULL, 0x0c0fe40003f14000ULL, 0x000000833e7e7209ULL, 0x000fe40007810000ULL,
0x000000713400720cULL, 0x000fd20003f45270ULL, 0x0000000000367806ULL, 0x000fc800000e0100ULL,
0x000000087134ac11ULL, 0x000fe4000f8e38ffULL, 0x000000ff3600720cULL, 0x000fe40003f05270ULL,
0x000000346e69a210ULL, 0x000fca0007ffe069ULL, 0x01a4007e6900a388ULL, 0x0003ec0000000800ULL,
0x0000000400508947ULL, 0x000fea0003800000ULL, 0x000000837e347221ULL, 0x000fe20000010100ULL,
0x000000ff36ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0036ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL, 0x00ff000036ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000036ff7812ULL, 0x000fe2000788c0ffULL, 0x00000034003d7308ULL, 0x0004ec0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x004fcc0000011609ULL,
0x00001f343d347589ULL, 0x008ea400000e0000ULL, 0x0000005434547220ULL, 0x044fe20000410000ULL,
0x0000005534557220ULL, 0x040fe20000410000ULL, 0x0000004834487220ULL, 0x040fe20000410000ULL,
0x0000004934497220ULL, 0x040fe20000410000ULL, 0x0000004c344c7220ULL, 0x040fe20000410000ULL,
0x0000004d344d7220ULL, 0x040fe20000410000ULL, 0x0000005034507220ULL, 0x040fe20000410000ULL,
0x0000005134517220ULL, 0x040fe20000410000ULL, 0x0000003034307220ULL, 0x040fe20000410000ULL,
0x0000003134317220ULL, 0x040fe20000410000ULL, 0x0000002c342c7220ULL, 0x040fe20000410000ULL,
0x0000002d342d7220ULL, 0x040fe20000410000ULL, 0x0000002834287220ULL, 0x040fe20000410000ULL,
0x0000002934297220ULL, 0x040fe20000410000ULL, 0x0000002434247220ULL, 0x040fe20000410000ULL,
0x0000002534257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000000809347811ULL, 0x004fcc00078ff0ffULL, 0x00001f343d347589ULL, 0x008ea400000e0000ULL,
0x0000005634567220ULL, 0x044fe20000410000ULL, 0x0000005734577220ULL, 0x040fe20000410000ULL,
0x0000004a344a7220ULL, 0x040fe20000410000ULL, 0x0000004b344b7220ULL, 0x040fe20000410000ULL,
0x0000004e344e7220ULL, 0x040fe20000410000ULL, 0x0000004f344f7220ULL, 0x040fe20000410000ULL,
0x0000005234527220ULL, 0x040fe20000410000ULL, 0x0000005334537220ULL, 0x040fe20000410000ULL,
0x0000003234327220ULL, 0x040fe20000410000ULL, 0x0000003334337220ULL, 0x040fe20000410000ULL,
0x0000002e342e7220ULL, 0x040fe20000410000ULL, 0x0000002f342f7220ULL, 0x040fe20000410000ULL,
0x0000002a342a7220ULL, 0x040fe20000410000ULL, 0x0000002b342b7220ULL, 0x040fe20000410000ULL,
0x0000002634267220ULL, 0x040fe20000410000ULL, 0x0000002734277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x0000001009347811ULL, 0x004fcc00078ff0ffULL,
0x00001f343d347589ULL, 0x008ea400000e0000ULL, 0x0000000c340c7220ULL, 0x044fe20000410000ULL,
0x0000000d340d7220ULL, 0x040fe20000410000ULL, 0x0000001034107220ULL, 0x040fe20000410000ULL,
0x0000001134117220ULL, 0x040fe20000410000ULL, 0x0000001434147220ULL, 0x040fe20000410000ULL,
0x0000001534157220ULL, 0x040fe20000410000ULL, 0x0000001834187220ULL, 0x040fe20000410000ULL,
0x0000001934197220ULL, 0x040fe20000410000ULL, 0x0000001c341c7220ULL, 0x040fe20000410000ULL,
0x0000001d341d7220ULL, 0x040fe20000410000ULL, 0x0000002034207220ULL, 0x040fe20000410000ULL,
0x0000002134217220ULL, 0x040fe20000410000ULL, 0x0000003834387220ULL, 0x040fe20000410000ULL,
0x0000003934397220ULL, 0x040fe20000410000ULL, 0x0000004434447220ULL, 0x040fe20000410000ULL,
0x0000004534457220ULL, 0x000fce0000410000ULL, 0x0000003d82827220ULL, 0x008fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x0000001809347811ULL, 0x004fcc00078ff0ffULL,
0x00001f343d347589ULL, 0x000ea400000e0000ULL, 0x0000000e340e7220ULL, 0x044fe20000410000ULL,
0x0000000f340f7220ULL, 0x040fe20000410000ULL, 0x0000001234127220ULL, 0x040fe20000410000ULL,
0x0000001334137220ULL, 0x040fe20000410000ULL, 0x0000001634167220ULL, 0x040fe20000410000ULL,
0x0000001734177220ULL, 0x040fe20000410000ULL, 0x0000001a341a7220ULL, 0x040fe20000410000ULL,
0x0000001b341b7220ULL, 0x040fe20000410000ULL, 0x0000001e341e7220ULL, 0x040fe20000410000ULL,
0x0000001f341f7220ULL, 0x040fe20000410000ULL, 0x0000002234227220ULL, 0x040fe20000410000ULL,
0x0000002334237220ULL, 0x040fe20000410000ULL, 0x0000003a343a7220ULL, 0x040fe20000410000ULL,
0x0000003b343b7220ULL, 0x040fe20000410000ULL, 0x0000004634467220ULL, 0x040fe20000410000ULL,
0x0000004734477220ULL, 0x000fce0000410000ULL, 0x0000003637ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff3c7424ULL, 0x000fd800078e00ffULL, 0x0000003e7e340221ULL, 0x004fe20000010100ULL,
0x00007610ff3c0816ULL, 0x000fc6000000003cULL, 0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL,
0x0000003400040308ULL, 0x000ea40000000800ULL, 0x0000000435350220ULL, 0x004fce0000410000ULL,
0x0000008235827221ULL, 0x000fce0000010000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000000871367824ULL, 0x000fca00078e00ffULL, 0xfffffff036377812ULL, 0x000fc800078ec0ffULL,
0x01a6b085370075a7ULL, 0x000ea20008000148ULL, 0x00000008373f7c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x004fec0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a6b0853f0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x00000004ff357819ULL, 0x000fe20000011609ULL, 0x000000036a367836ULL, 0x000fe20000000000ULL,
0x000099103c347816ULL, 0x000fe200000000ffULL, 0x00000008683d7824ULL, 0x000fe400078e00ffULL,
0x0000000458357824ULL, 0x000fe200078e0235ULL, 0x000000ff3400720cULL, 0x000fe20003f05270ULL,
0x00000008783c7824ULL, 0x000fe200078e00ffULL, 0x0000000836367c11ULL, 0x000fe2000f8e60ffULL,
0x0000000168347824ULL, 0x100fe400078e0235ULL, 0x0000000178357824ULL, 0x000fc400078e0235ULL,
0x0000000471377824ULL, 0x000fe200078e00ffULL, 0xfffffff83d347812ULL, 0x000fe200078ee234ULL,
0x00012000367d7836ULL, 0x000fe20000000000ULL, 0xfffffff83c367812ULL, 0x000fe200078ee235ULL,
0x000000106d357824ULL, 0x000fe200078e027aULL, 0x0000000437377812ULL, 0x000fe200078ec0ffULL,
0x0000001034347824ULL, 0x100fe400078e027dULL, 0x0000001036367824ULL, 0x000fe200078e027dULL,
0x00000002373c7812ULL, 0x000fe200078efcffULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff3e7819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x000000083e027836ULL, 0x000fe20000000000ULL, 0x0000541000377816ULL, 0x000fe20000000000ULL,
0x000000103e407836ULL, 0x000fe40000000000ULL, 0x000000183e427836ULL, 0x000fe40000000000ULL,
0x00001f0237027589ULL, 0x0004e800000e0000ULL, 0x00001f4037057589ULL, 0x00046800000e0000ULL,
0x00001f3e37037589ULL, 0x00046800000e0000ULL, 0x00001f4237007589ULL, 0x00046400000e0000ULL,
0x00000000345c783bULL, 0x000ae80000000200ULL, 0x000000003640783bULL, 0x0044620000000200ULL,
0x0000000000200947ULL, 0x020fea0003800000ULL, 0x000000035c5c7232ULL, 0x08afe40000200000ULL,
0x000000035e5e7232ULL, 0x000fe40000200000ULL, 0x000000025d5d7232ULL, 0x080fe40000200000ULL,
0x000000025f5f7232ULL, 0x000fe40000200000ULL, 0x0000000540407232ULL, 0x080fe40000200000ULL,
0x0000000542427232ULL, 0x000fc40000200000ULL, 0x0000000041417232ULL, 0x080fe40000200000ULL,
0x0000000043437232ULL, 0x000fce0000200000ULL, 0x0000003c097b7211ULL, 0x000fe200078fe0ffULL,
0x00000008683d7824ULL, 0x040fe200078e00ffULL, 0x000000003534783bULL, 0x004ea20000004200ULL,
0x000000106f7f7824ULL, 0x000fe400078e027dULL, 0x0000000168687824ULL, 0x000fe400078e027bULL,
0x00000010727d7824ULL, 0x000fc600078e027dULL, 0xfffffff83d3d7812ULL, 0x000fca00078ee268ULL,
0x000000103d3d7824ULL, 0x000fcc00078e027aULL, 0x000000003d3c783bULL, 0x000f620000004200ULL,
0x00000018ff627819ULL, 0x104fe40000011635ULL, 0x00000018ff607819ULL, 0x000fe40000011634ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000010ff877819ULL, 0x000fe40000011635ULL,
0x000000ff35637812ULL, 0x040fe200078ec0ffULL, 0x20000062ff657230ULL, 0x000fe20000004100ULL,
0x0000ffff35867812ULL, 0x000fc400078ec0ffULL, 0x00000010ff857819ULL, 0x100fe40000011636ULL,
0x000000ff36647812ULL, 0x040fe400078ec0ffULL, 0x00000018ff357819ULL, 0x000fe40000011636ULL,
0x0000ffff36847812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6c7819ULL, 0x028fe4000001163cULL,
0x000000ff3c8a7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff887819ULL, 0x000fe40000011634ULL,
0x000000ff34617812ULL, 0x040fe400078ec0ffULL, 0x00000018ff367819ULL, 0x100fe40000011637ULL,
0x0000ffff34347812ULL, 0x000fe400078ec0ffULL, 0x00000010ff807819ULL, 0x000fe40000011637ULL,
0x000000ff37897812ULL, 0x000fc400078ec0ffULL, 0x0000ffff37837812ULL, 0x000fe400078ec0ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001163fULL,
0x00000018ff377819ULL, 0x000fe2000001163cULL, 0x20000060ff697230ULL, 0x002fe20000004100ULL,
0x0000ffff3c6f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff6c6c7812ULL, 0x000fc400078ec0ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000010ff6e7819ULL, 0x100fe4000001163dULL,
0x000000ff3d8b7812ULL, 0x040fe200078ec0ffULL, 0x20000063ff687230ULL, 0x000fe20000004100ULL,
0x00000018ff3c7819ULL, 0x000fe4000001163dULL, 0x0000ffff3d737812ULL, 0x000fe400078ec0ffULL,
0x000000ff3e8d7812ULL, 0x000fc400078ec0ffULL, 0x0000008aff62723eULL, 0x000fe400020006ffULL,
0x00000010ff3d7819ULL, 0x000fe4000001163fULL, 0x00000036ff36723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8a7819ULL, 0x000fe20000011686ULL, 0x20000036ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fc4000001163eULL, 0x00000018ff8c7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e667812ULL, 0x000fe400078ec0ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000008ff347819ULL, 0x000fe40000011634ULL, 0x000000ff85857812ULL, 0x000fe400078ec0ffULL,
0x00000061ff61723eULL, 0x000fc400020006ffULL, 0x000000ff3f3e7812ULL, 0x000fe400078ec0ffULL,
0x00000037ff37723eULL, 0x000fe200020006ffULL, 0x20000061ff677230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000089ff60723eULL, 0x000fe400020006ffULL,
0x00000035ff35723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000087ff89723eULL, 0x000fe200020006ffULL,
0x20000035ff617230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fc400020006ffULL,
0x00000008ff6f7819ULL, 0x000fe2000001166fULL, 0x20000089ff867230ULL, 0x000fe20000004100ULL,
0x000000ff3d3d7812ULL, 0x000fe400078ec0ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000034ff87723eULL, 0x000fe200020006ffULL, 0x2000008eff347230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x2000006cff8e7230ULL, 0x000fe20000004100ULL,
0x0000003eff36723eULL, 0x000fe200020006ffULL, 0x20000037ff3e7230ULL, 0x000fe20000004100ULL,
0x000000ff88887812ULL, 0x000fe200078ec0ffULL, 0x2000008dff377230ULL, 0x000fe20000004100ULL,
0x00000008ff847819ULL, 0x000fe20000011684ULL, 0x2000008aff8d7230ULL, 0x000fe20000004100ULL,
0x00000008ff837819ULL, 0x000fe20000011683ULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff667819ULL, 0x000fe20000011666ULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x0000003dff6c723eULL, 0x000fc400020006ffULL, 0x0000008cff35723eULL, 0x000fe200020006ffULL,
0x20000085ff8c7230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000006fff857230ULL, 0x000fe20000004100ULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000066ff3d723eULL, 0x000fe200020006ffULL, 0x2000006cff667230ULL, 0x000fe20000004100ULL,
0x0000ffff3f6d7812ULL, 0x000fe200078ec0ffULL, 0x20000084ff897230ULL, 0x000fe20000004100ULL,
0x000000ff80807812ULL, 0x000fc400078ec0ffULL, 0x000000ff72727812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6c7819ULL, 0x000fe40000011665ULL, 0x00000010ff6f7819ULL, 0x000fe4000001168dULL,
0x0000008bff3f723eULL, 0x000fe200020006ffULL, 0x20000088ff8b7230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x20000083ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fe2000001168cULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fc400020006ffULL, 0x00000008ff6d7819ULL, 0x000fe4000001166dULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x20000080ff8a7230ULL, 0x000fe20000004100ULL,
0x000010546c6f7816ULL, 0x000fe4000000006fULL, 0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL,
0x20000072ff807230ULL, 0x000fe20000004100ULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x00001054656c7816ULL, 0x000fc40000000064ULL, 0x00000010ff657819ULL, 0x000fe40000011662ULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff647819ULL, 0x000fe40000011663ULL, 0x00000010ff627819ULL, 0x000fe40000011689ULL,
0x00000010ff637819ULL, 0x000fc40000011688ULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe20000011667ULL,
0x2000003dff677230ULL, 0x000fe20000004100ULL, 0x0000105461627816ULL, 0x000fe20000000062ULL,
0x2000006dff3d7230ULL, 0x000fe20000004100ULL, 0x0000105464637816ULL, 0x000fe20000000063ULL,
0x2000006eff837230ULL, 0x000fe20000004100ULL, 0x00000010ff617819ULL, 0x000fe2000001163fULL,
0x20000073ff847230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fc40000011660ULL,
0x00000010ff6d7819ULL, 0x000fe2000001168aULL, 0x000000624018723cULL, 0x000fe20000041818ULL,
0x00000010ff3f7819ULL, 0x000fe4000001163eULL, 0x00000010ff647819ULL, 0x000fe40000011685ULL,
0x00000010ff8e7819ULL, 0x000fe2000001168eULL, 0x000000625c50723cULL, 0x000fe20000041850ULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff697819ULL, 0x000fc40000011669ULL,
0x00000010ff737819ULL, 0x000fe40000011686ULL, 0x00000010ff6e7819ULL, 0x000fe40000011687ULL,
0x00000010ff377819ULL, 0x000fe40000011637ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x000010546d6d7816ULL, 0x000fe40000000060ULL, 0x000010543f647816ULL, 0x000fc40000000064ULL,
0x000010548e607816ULL, 0x000fe40000000065ULL, 0x00000010ff3f7819ULL, 0x000fe20000011666ULL,
0x0000006c4014723cULL, 0x000fe20000041814ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x0000105473737816ULL, 0x000fe40000000068ULL, 0x00001054696e7816ULL, 0x000fe2000000006eULL,
0x0000006c5c4c723cULL, 0x000fe2000004184cULL, 0x00000010ff3e7819ULL, 0x000fc40000011683ULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff657819ULL, 0x000fe20000011684ULL,
0x0000006e4010723cULL, 0x000fe20000041810ULL, 0x00000010ff367819ULL, 0x000fe40000011636ULL,
0x0000105480667816ULL, 0x000fe40000000037ULL, 0x00000010ff357819ULL, 0x000fe20000011635ULL,
0x0000006e5c48723cULL, 0x000fe20000041848ULL, 0x00000010ff687819ULL, 0x000fc40000011667ULL,
0x00000010ff807819ULL, 0x000fe40000011634ULL, 0x00000010ff697819ULL, 0x000fe4000001163dULL,
0x000010548b727816ULL, 0x000fe40000000072ULL, 0x000010543e617816ULL, 0x000fe40000000061ULL,
0x000010543c657816ULL, 0x000fe40000000065ULL, 0x000010543f677816ULL, 0x000fe20000000036ULL,
0x00000072400c723cULL, 0x000fe2000004180cULL, 0x0000105435687816ULL, 0x000fe20000000068ULL,
0x000000007f3c783bULL, 0x0002620000000200ULL, 0x0000105480697816ULL, 0x000fc60000000069ULL,
0x00000060401c723cULL, 0x000fe2000004181cULL, 0x000000007d34783bULL, 0x00026a0000000200ULL,
0x000000644020723cULL, 0x000fec0000041820ULL, 0x000000664038723cULL, 0x000fec0000041838ULL,
0x000000725c54723cULL, 0x000fec0000041854ULL, 0x000000605c30723cULL, 0x000fec0000041830ULL,
0x000000645c2c723cULL, 0x000fec000004182cULL, 0x000000665c28723cULL, 0x000fec0000041828ULL,
0x000000685c24723cULL, 0x000fec0000041824ULL, 0x000000684040723cULL, 0x000fe20000041844ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000200947ULL, 0x002fde0003800000ULL,
0x000000033c3c7232ULL, 0x080fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x080fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x080fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x00000001787b7824ULL, 0x040fe200078e027bULL, 0x000000007c44783bULL, 0x000e620000004200ULL,
0x0000000878787824ULL, 0x000fe400078e00ffULL, 0x0000000107077836ULL, 0x000fc60000000000ULL,
0xfffffff8787b7812ULL, 0x000fca00078ee27bULL, 0x000000107b5c7824ULL, 0x000fcc00078e027aULL,
0x000000005c5c783bULL, 0x000ea20000004200ULL, 0x00000018ff687819ULL, 0x002fe40000011645ULL,
0x00000010ff7d7819ULL, 0x100fe40000011644ULL, 0x000000ff44617812ULL, 0x040fe400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe40000011644ULL, 0x0000ffff44837812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7b7819ULL, 0x000fc40000011647ULL, 0x00000010ff7f7819ULL, 0x000fe40000011645ULL,
0x000000ff45447812ULL, 0x040fe400078ec0ffULL, 0x0000ffff45857812ULL, 0x000fe400078ec0ffULL,
0x00000010ff697819ULL, 0x104fe4000001165cULL, 0x000000ff5c6f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff457819ULL, 0x000fc4000001165cULL, 0x0000ffff5c667812ULL, 0x000fe400078ec0ffULL,
0x000000ff47807812ULL, 0x000fe400078ec0ffULL, 0x00000010ff677819ULL, 0x100fe4000001165dULL,
0x000000ff5d5c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff637819ULL, 0x000fe4000001165dULL,
0x0000ffff5d657812ULL, 0x000fc400078ec0ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x0000007bff5d723eULL, 0x000fe400020006ffULL, 0x00000044ff6c723eULL, 0x000fe200020006ffULL,
0x20000068ff7b7230ULL, 0x000fe20000004100ULL, 0x00000018ff6d7819ULL, 0x100fe20000011646ULL,
0x2000005dff687230ULL, 0x000fe20000004100ULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000010ff847819ULL, 0x000fc40000011646ULL, 0x00000061ff64723eULL, 0x000fe400020006ffULL,
0x00000060ff73723eULL, 0x000fe400020006ffULL, 0x00000010ff607819ULL, 0x100fe2000001165eULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x000000ff5e447812ULL, 0x040fe200078ec0ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000018ff727819ULL, 0x000fe4000001165eULL,
0x0000ffff5e617812ULL, 0x000fe200078ec0ffULL, 0x2000006cff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff7f7f7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff5d7819ULL, 0x000fe40000011683ULL,
0x0000006dff6c723eULL, 0x000fe200020006ffULL, 0x20000080ff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x00000008ff807819ULL, 0x000fe20000011685ULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x0000ffff477a7812ULL, 0x000fc400078ec0ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7c7819ULL, 0x000fe40000011647ULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000080ff83723eULL, 0x000fe200020006ffULL,
0x2000007fff807230ULL, 0x000fe20000004100ULL, 0x00000008ff7a7819ULL, 0x000fe2000001167aULL,
0x2000005dff7f7230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000000ff7c5d7812ULL, 0x000fe200078ec0ffULL,
0x20000084ff7c7230ULL, 0x000fe20000004100ULL, 0x0000007aff84723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x0000006fff85723eULL, 0x000fe200020006ffULL, 0x20000084ff6f7230ULL, 0x000fe20000004100ULL,
0x0000005cff86723eULL, 0x000fe200020006ffULL, 0x2000005dff7a7230ULL, 0x000fe20000004100ULL,
0x000000ff466e7812ULL, 0x000fe200078ec0ffULL, 0x20000085ff5c7230ULL, 0x000fe20000004100ULL,
0x00000045ff84723eULL, 0x000fe200020006ffULL, 0x20000086ff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff457819ULL, 0x000fc4000001165eULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x0000ffff46787812ULL, 0x000fe400078ec0ffULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000044ff86723eULL, 0x000fe400020006ffULL, 0x000010547d447816ULL, 0x000fe20000000064ULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x0000105480457816ULL, 0x000fe20000000045ULL,
0x20000086ff647230ULL, 0x000fe20000004100ULL, 0x00000008ff787819ULL, 0x000fc40000011678ULL,
0x000000ff5f477812ULL, 0x000fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe2000001165fULL,
0x000000443c54723cULL, 0x000fe20000041854ULL, 0x00000072ff7d723eULL, 0x000fe400020006ffULL,
0x00000010ff727819ULL, 0x000fe40000011673ULL, 0x00000010ff807819ULL, 0x000fe2000001167bULL,
0x00000044340c723cULL, 0x000fe2000004180cULL, 0x00000010ff7f7819ULL, 0x000fc4000001167fULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000047ff73723eULL, 0x000fe400020006ffULL, 0x00000046ff7b723eULL, 0x000fe200020006ffULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x0000105472467816ULL, 0x000fe2000000007fULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x0000105480477816ULL, 0x000fe20000000083ULL,
0x2000007bff727230ULL, 0x000fe20000004100ULL, 0x00000010ff447819ULL, 0x000fe2000001166eULL,
0x2000007dff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff457819ULL, 0x000fc4000001167cULL,
0x000000ff69697812ULL, 0x000fe200078ec0ffULL, 0x000000463c48723cULL, 0x000fe20000041848ULL,
0x0000105445447816ULL, 0x000fe40000000044ULL, 0x00000010ff627819ULL, 0x000fe4000001165fULL,
0x00000010ff457819ULL, 0x000fe2000001166dULL, 0x000000463410723cULL, 0x000fe20000041810ULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x0000ffff5f5f7812ULL, 0x000fc400078ec0ffULL,
0x00000069ff6d723eULL, 0x000fe400020006ffULL, 0x00000008ff657819ULL, 0x000fe40000011665ULL,
0x000000ff60607812ULL, 0x000fe200078ec0ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff697819ULL, 0x000fe4000001166cULL,
0x00000010ff787819ULL, 0x000fc40000011678ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff477819ULL, 0x000fe4000001166fULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000063ff85723eULL, 0x000fe200020006ffULL, 0x20000084ff637230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x20000085ff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff5f7819ULL, 0x000fe2000001165fULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x000010547a457816ULL, 0x000fe20000000045ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x0000105469467816ULL, 0x000fc40000000078ULL, 0x0000105468477816ULL, 0x000fe40000000047ULL,
0x00000008ff617819ULL, 0x000fe20000011661ULL, 0x000000443c4c723cULL, 0x000fe2000004184cULL,
0x00000008ff667819ULL, 0x000fe40000011666ULL, 0x000000ff62627812ULL, 0x000fe400078ec0ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x000000443414723cULL, 0x000fe20000041814ULL,
0x00000061ff61723eULL, 0x000fc400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x000000463c50723cULL, 0x000fe20000041850ULL,
0x00000010ff5d7819ULL, 0x000fe2000001165dULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff447819ULL, 0x000fe20000011667ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x000000463418723cULL, 0x000fe20000041818ULL,
0x00000010ff457819ULL, 0x000fe20000011660ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00001054445d7816ULL, 0x000fc4000000005dULL, 0x0000105445447816ULL, 0x000fe40000000064ULL,
0x2000005fff477230ULL, 0x000fe20000004100ULL, 0x00000010ff467819ULL, 0x000fe4000001165eULL,
0x00000010ff5f7819ULL, 0x000fe40000011665ULL, 0x00000010ff457819ULL, 0x000fe4000001166eULL,
0x00001054465f7816ULL, 0x000fe4000000005fULL, 0x00000010ff467819ULL, 0x000fc40000011661ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff5e7819ULL, 0x000fe40000011666ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff627819ULL, 0x000fc40000011662ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x0000105445467816ULL, 0x000fe40000000046ULL, 0x000010546d5c7816ULL, 0x000fe4000000005cULL,
0x00001054635e7816ULL, 0x000fe4000000005eULL, 0x0000105462457816ULL, 0x000fc40000000073ULL,
0x0000105472477816ULL, 0x000fe20000000047ULL, 0x0000005c3c30723cULL, 0x000fec0000041830ULL,
0x0000005e3c2c723cULL, 0x000fec000004182cULL, 0x000000443c28723cULL, 0x000fec0000041828ULL,
0x000000463c24723cULL, 0x000fec0000041824ULL, 0x0000005c341c723cULL, 0x000fe2000004181cULL,
0x00000001ff3f7424ULL, 0x000fc800078e00ffULL, 0x0000003f063c79a7ULL, 0x0002a2000850003fULL,
0x0000005e3420723cULL, 0x000fec0000041820ULL, 0x000000443438723cULL, 0x000fe20000041838ULL,
0x000000086a067c11ULL, 0x002fca000f8e18ffULL, 0x000000463434723cULL, 0x000fe20000041840ULL,
0x01a6a03f06ff79a7ULL, 0x0003ec000850003fULL, 0x000000ffff407224ULL, 0x004fe200078e003dULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0xffffff3c00dc9947ULL, 0x002fde000383ffffULL,
0x000000ff7000720cULL, 0x000fda0003f05270ULL, 0x0000000400648947ULL, 0x000fea0003800000ULL,
0x0180000082007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000e29000047802ULL, 0x000fce0000000f00ULL,
0x000000b800547944ULL, 0x01efea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000008200037308ULL, 0x008ee40000001000ULL, 0xbf80000003007423ULL, 0x008fc80000000082ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fce0000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009a00ff027b82ULL, 0x000f640000000a00ULL,
0x0000000602037981ULL, 0x02aee2000c1e9900ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000001805077811ULL, 0x042fe400078ff0ffULL, 0x00000002ff097819ULL, 0x000fe40000011605ULL,
0x00000008053d7811ULL, 0x040fe400078ff0ffULL, 0x00000010053f7811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x00cfca0000410000ULL, 0x00001f0900047589ULL, 0x000e6800000e0000ULL,
0x00001f3d00067589ULL, 0x000ea800000e0000ULL, 0x00001f3f00057589ULL, 0x000ee800000e0000ULL,
0x00001f0700077589ULL, 0x000f6200000e0000ULL, 0x0000005404547220ULL, 0x042fe20000410000ULL,
0x0000005504557220ULL, 0x040fe20000410000ULL, 0x0000004804487220ULL, 0x040fe20000410000ULL,
0x0000004904497220ULL, 0x040fe20000410000ULL, 0x0000004c044c7220ULL, 0x040fe20000410000ULL,
0x0000004d044d7220ULL, 0x040fe20000410000ULL, 0x0000005004507220ULL, 0x040fe20000410000ULL,
0x0000005104517220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x000fe20000410000ULL, 0x0000005606567220ULL, 0x044fe20000410000ULL,
0x0000005706577220ULL, 0x040fe20000410000ULL, 0x0000004a064a7220ULL, 0x040fe20000410000ULL,
0x0000004b064b7220ULL, 0x040fe20000410000ULL, 0x0000004e064e7220ULL, 0x040fe20000410000ULL,
0x0000004f064f7220ULL, 0x040fe20000410000ULL, 0x0000005206527220ULL, 0x040fe20000410000ULL,
0x0000005306537220ULL, 0x040fe20000410000ULL, 0x0000003206327220ULL, 0x040fe20000410000ULL,
0x0000003306337220ULL, 0x040fe20000410000ULL, 0x0000002e062e7220ULL, 0x040fe20000410000ULL,
0x0000002f062f7220ULL, 0x040fe20000410000ULL, 0x0000002a062a7220ULL, 0x040fe20000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000002706277220ULL, 0x000fe20000410000ULL, 0x0000000c050c7220ULL, 0x048fe20000410000ULL,
0x0000000d050d7220ULL, 0x040fe20000410000ULL, 0x0000001005107220ULL, 0x040fe20000410000ULL,
0x0000001105117220ULL, 0x040fe20000410000ULL, 0x0000001405147220ULL, 0x040fe20000410000ULL,
0x0000001505157220ULL, 0x040fe20000410000ULL, 0x0000001805187220ULL, 0x040fe20000410000ULL,
0x0000001905197220ULL, 0x040fe20000410000ULL, 0x0000001c051c7220ULL, 0x040fe20000410000ULL,
0x0000001d051d7220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000002105217220ULL, 0x040fe20000410000ULL, 0x0000003805387220ULL, 0x040fe20000410000ULL,
0x0000003905397220ULL, 0x040fe20000410000ULL, 0x0000003405347220ULL, 0x040fe20000410000ULL,
0x0000003505357220ULL, 0x000fe20000410000ULL, 0x0000000e070e7220ULL, 0x060fe20000410000ULL,
0x0000000f070f7220ULL, 0x040fe20000410000ULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x0000001607167220ULL, 0x040fe20000410000ULL,
0x0000001707177220ULL, 0x040fe20000410000ULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x0000001b071b7220ULL, 0x040fe20000410000ULL, 0x0000001e071e7220ULL, 0x040fe20000410000ULL,
0x0000001f071f7220ULL, 0x040fe20000410000ULL, 0x0000002207227220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000003a073a7220ULL, 0x040fe20000410000ULL,
0x0000003b073b7220ULL, 0x040fe20000410000ULL, 0x0000003607367220ULL, 0x040fe20000410000ULL,
0x0000003707377220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000f620000000000ULL,
0x0000000171717812ULL, 0x000fe400078ec0ffULL, 0x000000303130723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002c2d2c723eULL, 0x000fc400000010ffULL,
0x000000282928723eULL, 0x000fe400000010ffULL, 0x000000242524723eULL, 0x000fe400000010ffULL,
0x000000565757723eULL, 0x000fe400000010ffULL, 0x0000004a4b4a723eULL, 0x000fe400000010ffULL,
0x0000004e4f4e723eULL, 0x000fe400000010ffULL, 0x000000525352723eULL, 0x000fc400000010ffULL,
0x0000541057567816ULL, 0x140fe4000000004aULL, 0x0000763257577816ULL, 0x000fe4000000004aULL,
0x000000323332723eULL, 0x000fe400000010ffULL, 0x0000002e2f2e723eULL, 0x000fe400000010ffULL,
0x0000000800057811ULL, 0x062fe200078ff0ffULL, 0x000000015b5b7824ULL, 0x000fe200078e0200ULL,
0x0000000200027812ULL, 0x008fc400078ec0ffULL, 0x00000002ff077819ULL, 0x000fe20000011600ULL,
0x0000000805407824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x000fe400078ff8ffULL,
0x0000001000057811ULL, 0x040fe200078ff0ffULL, 0x00000008073e7824ULL, 0x000fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fe400078ee203ULL, 0x0000001800097811ULL, 0x000fe200078ff0ffULL,
0x00000008053d7824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x000fc400078ff8ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x0000000809447824ULL, 0x000fe200078e00ffULL,
0x0000000902057211ULL, 0x000fe200078ff8ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0xfffffff83d427812ULL, 0x000fe200078ee204ULL, 0x0000000203027836ULL, 0x000fe20000000000ULL,
0xfffffff844447812ULL, 0x000fe200078ee205ULL, 0x0000000807047824ULL, 0x000fe200078e00ffULL,
0x0000002a2b2a723eULL, 0x000fe200000010ffULL, 0x0000000403067836ULL, 0x000fe20000000000ULL,
0xfffffff809087812ULL, 0x000fe200078ee202ULL, 0x0000000603077836ULL, 0x000fe20000000000ULL,
0x0000000871027c11ULL, 0x000fe2000f8e68ffULL, 0x0000000800057824ULL, 0x000fe200078e00ffULL,
0xfffffff804047812ULL, 0x000fc400078ee203ULL, 0xfffffff8093c7812ULL, 0x000fe200078ee206ULL,
0x000010006b037824ULL, 0x100fe200078e0202ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee207ULL,
0x000000105b5b7824ULL, 0x000fe200078e0202ULL, 0x0000000805067812ULL, 0x000fe200078ec0ffULL,
0x0000001004057824ULL, 0x100fe200078e0203ULL, 0x000000484904723eULL, 0x000fe200000010ffULL,
0x00000010403f7824ULL, 0x100fe200078e0203ULL, 0x000000262726723eULL, 0x000fe200000010ffULL,
0x0000001042417824ULL, 0x100fe200078e0203ULL, 0x0000000c0d0c723eULL, 0x000fe200000010ffULL,
0x0000001044437824ULL, 0x100fe200078e0203ULL, 0x000000141514723eULL, 0x000fe200000010ffULL,
0x0000001008077824ULL, 0x100fe200078e0203ULL, 0x000000181918723eULL, 0x000fe200000010ffULL,
0x000000103c097824ULL, 0x100fe200078e0203ULL, 0x0000001c1d1c723eULL, 0x000fe200000010ffULL,
0x000000103e3d7824ULL, 0x000fe200078e0203ULL, 0x000000545503723eULL, 0x000fe200000010ffULL,
0x0000000105057824ULL, 0x000fe200078e0206ULL, 0x000000202120723eULL, 0x000fe200000010ffULL,
0x00000001063f7824ULL, 0x040fe200078e023fULL, 0x0000541003447816ULL, 0x140fe20000000004ULL,
0x0000000106417824ULL, 0x040fe200078e0241ULL, 0x0000763203457816ULL, 0x000fe20000000004ULL,
0x0000000106437824ULL, 0x040fe200078e0243ULL, 0x0000004c4d03723eULL, 0x000fe200000010ffULL,
0x0000000106087824ULL, 0x040fe200078e0207ULL, 0x000000505104723eULL, 0x000fe200000010ffULL,
0x0000000106097824ULL, 0x040fe200078e0209ULL, 0x0000004405007388ULL, 0x0003e20000000a00ULL,
0x00000001063d7824ULL, 0x000fe200078e023dULL, 0x0000541003067816ULL, 0x000fc40000000004ULL,
0x0000763203077816ULL, 0x000fe40000000004ULL, 0x0000541030047816ULL, 0x140fe2000000002cULL,
0x000000ff00037306ULL, 0x000ee20000202400ULL, 0x000000383938723eULL, 0x000fe200000010ffULL,
0x0000000608007388ULL, 0x000be20000000a00ULL, 0x000000343534723eULL, 0x000fe400000010ffULL,
0x0000763230057816ULL, 0x002fe4000000002cULL, 0x0000000e0f0e723eULL, 0x000fc400000010ffULL,
0x000000161716723eULL, 0x000fe200000010ffULL, 0x0000000409007388ULL, 0x0003e20000000a00ULL,
0x0000001a1b1a723eULL, 0x000fe400000010ffULL, 0x0000001e1f1e723eULL, 0x000fe400000010ffULL,
0x000000101106723eULL, 0x024fe400000010ffULL, 0x000000121307723eULL, 0x000fe400000010ffULL,
0x00000022230f723eULL, 0x000fc400000010ffULL, 0x00007632160d7816ULL, 0x000fe4000000001aULL,
0x0000541028047816ULL, 0x142fe40000000024ULL, 0x0000763228057816ULL, 0x000fe40000000024ULL,
0x000076321e217816ULL, 0x000fe4000000000fULL, 0x0000003a3b3a723eULL, 0x000fe200000010ffULL,
0x000000043d007388ULL, 0x0003e20000000a00ULL, 0x00000036371d723eULL, 0x000fc400000010ffULL,
0x000000ff6b00720cULL, 0x000fe20003f05270ULL, 0x000000563f007388ULL, 0x000fe20000000a00ULL,
0x000054104e047816ULL, 0x142fe40000000052ULL, 0x000076324e057816ULL, 0x000fca0000000052ULL,
0x0004000408007388ULL, 0x0003e40000000a00ULL, 0x0000541032047816ULL, 0x142fe4000000002eULL,
0x0000763232057816ULL, 0x000fca000000002eULL, 0x0004000409007388ULL, 0x0003e40000000a00ULL,
0x000054102a047816ULL, 0x142fe40000000026ULL, 0x000076322a057816ULL, 0x000fca0000000026ULL,
0x000400043d007388ULL, 0x0003e40000000a00ULL, 0x000054100c047816ULL, 0x142fe40000000006ULL,
0x000076320c057816ULL, 0x000fe40000000006ULL, 0x000054100e067816ULL, 0x140fe40000000007ULL,
0x000076320e077816ULL, 0x000fe20000000007ULL, 0x0000000441007388ULL, 0x0003e20000000a00ULL,
0x00005410160c7816ULL, 0x000fc4000000001aULL, 0x0000541014047816ULL, 0x142fe40000000018ULL,
0x0000763214057816ULL, 0x000fca0000000018ULL, 0x0008000408007388ULL, 0x0003e40000000a00ULL,
0x000054101c047816ULL, 0x142fe40000000020ULL, 0x000076321c057816ULL, 0x000fe40000000020ULL,
0x000054101e207816ULL, 0x000fc6000000000fULL, 0x0008000409007388ULL, 0x0003e40000000a00ULL,
0x0000541038047816ULL, 0x142fe40000000034ULL, 0x0000763238057816ULL, 0x000fca0000000034ULL,
0x000800043d007388ULL, 0x000fe80000000a00ULL, 0x0000000643007388ULL, 0x000fe80000000a00ULL,
0x000c000c08007388ULL, 0x0003e80000000a00ULL, 0x000c002009007388ULL, 0x0005e20000000a00ULL,
0x000054103a087816ULL, 0x002fc4000000001dULL, 0x000076323a097816ULL, 0x004fca000000001dULL,
0x000c00083d007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000005b047984ULL, 0x000ee80000000c00ULL, 0x000400005b107984ULL, 0x000e680000000c00ULL,
0x000800005b187984ULL, 0x000ea80000000c00ULL, 0x000c00005b207984ULL, 0x000f680000000c00ULL,
0x001000005b0c7984ULL, 0x000ea80000000c00ULL, 0x001400005b147984ULL, 0x000f680000000c00ULL,
0x001800005b1c7984ULL, 0x000f680000000c00ULL, 0x001c00005b247984ULL, 0x000f620000000c00ULL,
0x0000000703077230ULL, 0x008fc40000200800ULL, 0x0000000603067230ULL, 0x040fe40000200800ULL,
0x0000000503057230ULL, 0x040fe40000200800ULL, 0x0000000403047230ULL, 0x040fe40000200800ULL,
0x0000001303137230ULL, 0x042fe40000200800ULL, 0x0000001203127230ULL, 0x040fe40000200800ULL,
0x0000001103117230ULL, 0x000fc40000200800ULL, 0x0000001003107230ULL, 0x040fe40000200800ULL,
0x0000001b031b7230ULL, 0x044fe40000200800ULL, 0x0000001a031a7230ULL, 0x040fe40000200800ULL,
0x0000001903197230ULL, 0x040fe40000200800ULL, 0x0000001803187230ULL, 0x040fe40000200800ULL,
0x0000002303237230ULL, 0x020fc40000200800ULL, 0x0000002203227230ULL, 0x040fe40000200800ULL,
0x0000002103217230ULL, 0x040fe40000200800ULL, 0x0000002003037230ULL, 0x000fe40000200800ULL,
0x0000000f07077230ULL, 0x000fe40000200000ULL, 0x0000000e06067230ULL, 0x000fe40000200000ULL,
0x0000000d05057230ULL, 0x000fc40000200000ULL, 0x0000000c04047230ULL, 0x000fe40000200000ULL,
0x0000001713137230ULL, 0x000fe40000200000ULL, 0x0000001612127230ULL, 0x000fe20000200000ULL,
0x000000045b007388ULL, 0x0003e20000000c00ULL, 0x0000001511117230ULL, 0x000fe40000200000ULL,
0x0000001410107230ULL, 0x000fe40000200000ULL, 0x0000001f1b1b7230ULL, 0x000fc40000200000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000200000ULL, 0x000400105b007388ULL, 0x0003e20000000c00ULL,
0x0000001d19197230ULL, 0x000fe40000200000ULL, 0x0000001c18187230ULL, 0x000fe40000200000ULL,
0x0000002723237230ULL, 0x000fe40000200000ULL, 0x0000002622227230ULL, 0x000fe20000200000ULL,
0x000800185b007388ULL, 0x0003e20000000c00ULL, 0x0000002521217230ULL, 0x000fc40000200000ULL,
0x0000002403207230ULL, 0x000fca0000200000ULL, 0x000c00205b007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff0c7819ULL, 0x000fc80000011600ULL, 0x0000000b0c00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x000000ffff047224ULL, 0x002fe200078e00ffULL, 0x0000000800037d06ULL, 0x000e620008209000ULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000700127812ULL, 0x000fca00078ec0ffULL, 0x0000000300037308ULL, 0x002e640000001000ULL,
0x0ffffffe03097836ULL, 0x002fe40000000000ULL, 0x000000010c037824ULL, 0x000fc800078e0200ULL,
0x0000000900057305ULL, 0x000e62000021f000ULL, 0x0000000703037812ULL, 0x000fc800078ec0ffULL,
0x0ffffff803037812ULL, 0x000fe200078ef800ULL, 0x000000ffff077224ULL, 0x002fc800078e0a05ULL,
0x0000000807077c24ULL, 0x000fc8000f8e02ffULL, 0x0000000705047227ULL, 0x000fc800078e0004ULL,
0x0000000175057824ULL, 0x000fc800078e020cULL, 0x0000000504067227ULL, 0x000fc800078e00ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a06ULL, 0x0000000808077c24ULL, 0x000fe4000f8e0205ULL,
0x0000001003087824ULL, 0x000fe200078e0202ULL, 0x00000008ff037c12ULL, 0x000fe4000f8e33ffULL,
0x0000000807007c0cULL, 0x000fe4000bf06070ULL, 0x00000000080c7984ULL, 0x0002a40000000c00ULL,
0x0000002000087836ULL, 0x002fd20000000000ULL, 0x8000000807070c36ULL, 0x000fe40008000000ULL,
0x0000000106060836ULL, 0x000fe20000000000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x0000000106061836ULL, 0x000fca0000000000ULL,
0x0000000603067207ULL, 0x000fca0004000000ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fc8000f8e0205ULL,
0x0000000806057c24ULL, 0x000fca000f8e0205ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405067c11ULL, 0x000fc8000f8240ffULL,
0x0000000505077c11ULL, 0x000fe200088f4410ULL, 0x0000000871057824ULL, 0x000fe200078e0212ULL,
0x00000003ff107819ULL, 0x000fc60000011608ULL, 0x0000001005067825ULL, 0x000fe200078e0006ULL,
0x0000000b1000720cULL, 0x000fc80003f26070ULL, 0x0000000c06007986ULL, 0x0043f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000175057824ULL, 0x100fe400078e0210ULL,
0x0000000108107824ULL, 0x000fe400078e0210ULL, 0x0000000504067227ULL, 0x002fc800078e00ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0000000710077812ULL, 0x000fc800078ec0ffULL, 0x0ffffff807077812ULL, 0x000fe400078ef808ULL,
0x0000000708087812ULL, 0x000fc600078ec0ffULL, 0x0000001007097824ULL, 0x000fe400078e0202ULL,
0x0000000106062836ULL, 0x000fc60000000000ULL, 0x00000000090c7984ULL, 0x0002a40000000c00ULL,
0x0000000603067207ULL, 0x000fca0004000000ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fe4000f8e0205ULL,
0x0000004000097836ULL, 0x002fe40000000000ULL, 0x0000000806057c24ULL, 0x000fca000f8e0205ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405067c11ULL, 0x000fc8000f8240ffULL, 0x0000000505077c11ULL, 0x000fe200088f4410ULL,
0x0000000871057824ULL, 0x000fe200078e0208ULL, 0x00000003ff087819ULL, 0x000fc60000011609ULL,
0x0000001005067825ULL, 0x000fe200078e0006ULL, 0x0000000b0800720cULL, 0x000fc80003f26070ULL,
0x0000000c06007986ULL, 0x0043f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000175057824ULL, 0x100fe400078e0208ULL, 0x0000000109087824ULL, 0x000fe400078e0208ULL,
0x0000000504067227ULL, 0x002fc600078e00ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff808077812ULL, 0x000fca00078ef809ULL, 0x0000001007087824ULL, 0x000fca00078e0202ULL,
0x00000000080c7984ULL, 0x0002a20000000c00ULL, 0x0000000106062836ULL, 0x000fca0000000000ULL,
0x0000000603067207ULL, 0x000fe20004000000ULL, 0x0000006000087836ULL, 0x002fc80000000000ULL,
0x000000ffff107224ULL, 0x000fe400078e0a06ULL, 0x0000000906067c24ULL, 0x000fe4000f8e0277ULL,
0x0000000810057c24ULL, 0x000fe2000f8e0205ULL, 0x0000000709107812ULL, 0x000fc600078ec0ffULL,
0x0000000806057c24ULL, 0x000fca000f8e0205ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405067c11ULL, 0x000fc8000f8240ffULL,
0x0000000505077c11ULL, 0x000fe200088f4412ULL, 0x0000000871057824ULL, 0x000fe200078e0210ULL,
0x00000003ff107819ULL, 0x000fc60000011608ULL, 0x0000001005067825ULL, 0x000fe200078e0006ULL,
0x0000000b1000720cULL, 0x000fc80003f26070ULL, 0x0000000c06007986ULL, 0x0043f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000175057824ULL, 0x100fe400078e0210ULL,
0x0000000108107824ULL, 0x000fe400078e0210ULL, 0x0000000504067227ULL, 0x002fc800078e00ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0000000710077812ULL, 0x000fc800078ec0ffULL, 0x0ffffff807077812ULL, 0x000fe400078ef808ULL,
0x0000000708087812ULL, 0x000fc600078ec0ffULL, 0x0000001007097824ULL, 0x000fe400078e0202ULL,
0x0000000106062836ULL, 0x000fc60000000000ULL, 0x00000000090c7984ULL, 0x0002a40000000c00ULL,
0x0000000603067207ULL, 0x000fca0004000000ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fe4000f8e0205ULL,
0x0000008000097836ULL, 0x002fe40000000000ULL, 0x0000000806057c24ULL, 0x000fca000f8e0205ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405067c11ULL, 0x000fc8000f8240ffULL, 0x0000000505077c11ULL, 0x000fe200088f4410ULL,
0x0000000871057824ULL, 0x000fe200078e0208ULL, 0x00000003ff087819ULL, 0x000fc60000011609ULL,
0x0000001005067825ULL, 0x000fe200078e0006ULL, 0x0000000b0800720cULL, 0x000fc80003f26070ULL,
0x0000000c06007986ULL, 0x0043f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000175057824ULL, 0x100fe400078e0208ULL, 0x0000000109087824ULL, 0x000fe400078e0208ULL,
0x0000000504067227ULL, 0x002fc600078e00ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff808077812ULL, 0x000fca00078ef809ULL, 0x0000001007087824ULL, 0x000fca00078e0202ULL,
0x00000000080c7984ULL, 0x0002a20000000c00ULL, 0x0000000106062836ULL, 0x000fca0000000000ULL,
0x0000000603067207ULL, 0x000fe20004000000ULL, 0x000000a000087836ULL, 0x002fc80000000000ULL,
0x000000ffff107224ULL, 0x000fe400078e0a06ULL, 0x0000000906067c24ULL, 0x000fe4000f8e0277ULL,
0x0000000810057c24ULL, 0x000fe2000f8e0205ULL, 0x0000000709107812ULL, 0x000fc600078ec0ffULL,
0x0000000806057c24ULL, 0x000fca000f8e0205ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405067c11ULL, 0x000fc8000f8240ffULL,
0x0000000505077c11ULL, 0x000fe200088f4412ULL, 0x0000000871057824ULL, 0x000fe200078e0210ULL,
0x00000003ff107819ULL, 0x000fc60000011608ULL, 0x0000001005067825ULL, 0x000fe200078e0006ULL,
0x0000000b1000720cULL, 0x000fc80003f26070ULL, 0x0000000c06007986ULL, 0x0043f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000175057824ULL, 0x100fe400078e0210ULL,
0x0000000108107824ULL, 0x000fe400078e0210ULL, 0x0000000504067227ULL, 0x002fc800078e00ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a06ULL, 0x000000080c077c24ULL, 0x000fca000f8e0205ULL,
0x0000000807007c0cULL, 0x000fda000bf26070ULL, 0x8000000807071c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000807007c0cULL, 0x000fe4000bf46070ULL,
0x0000000710077812ULL, 0x000fc800078ec0ffULL, 0x0ffffff807077812ULL, 0x000fe400078ef808ULL,
0x0000000708087812ULL, 0x000fc600078ec0ffULL, 0x0000001007097824ULL, 0x000fe400078e0202ULL,
0x0000000106062836ULL, 0x000fc60000000000ULL, 0x00000000090c7984ULL, 0x0002a40000000c00ULL,
0x0000000603067207ULL, 0x000fca0004000000ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fe4000f8e0205ULL,
0x000000c000097836ULL, 0x002fe40000000000ULL, 0x0000000806057c24ULL, 0x000fca000f8e0205ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405067c11ULL, 0x000fc8000f8240ffULL, 0x0000000505077c11ULL, 0x000fe200088f4410ULL,
0x0000000871057824ULL, 0x000fe200078e0208ULL, 0x00000003ff087819ULL, 0x000fc60000011609ULL,
0x0000001005067825ULL, 0x000fe200078e0006ULL, 0x0000000b0800720cULL, 0x000fc80003f26070ULL,
0x0000000c06007986ULL, 0x0043f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000175057824ULL, 0x100fe400078e0208ULL, 0x0000000109087824ULL, 0x000fe400078e0208ULL,
0x0000000504067227ULL, 0x002fc600078e00ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a06ULL, 0x000000e000007836ULL, 0x000fe40000000000ULL,
0x000000080c077c24ULL, 0x000fca000f8e0205ULL, 0x0000000807007c0cULL, 0x000fda000bf26070ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000106061836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff808077812ULL, 0x000fca00078ef809ULL,
0x0000001007087824ULL, 0x000fca00078e0202ULL, 0x00000000080c7984ULL, 0x0002a20000000c00ULL,
0x0000000106062836ULL, 0x000fca0000000000ULL, 0x0000000603067207ULL, 0x000fe40004000000ULL,
0x00000003ff087819ULL, 0x002fc60000011600ULL, 0x000000ffff107224ULL, 0x000fe400078e0a06ULL,
0x0000000906067c24ULL, 0x000fe4000f8e0277ULL, 0x0000000810057c24ULL, 0x000fe2000f8e0205ULL,
0x0000000709107812ULL, 0x000fe200078ec0ffULL, 0x0000000175757824ULL, 0x000fe400078e0208ULL,
0x0000000806057c24ULL, 0x000fca000f8e0205ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405067c11ULL, 0x000fc8000f8240ffULL,
0x0000000505077c11ULL, 0x000fe200088f4412ULL, 0x0000000871057824ULL, 0x000fe200078e0210ULL,
0x0000000b0800720cULL, 0x000fc60003f26070ULL, 0x0000001005067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x00000075040c7227ULL, 0x002fc800078e00ffULL, 0x000000ffff047224ULL, 0x000fe400078e0a0cULL,
0x0000000100087824ULL, 0x000fe400078e0208ULL, 0x0000000804047c24ULL, 0x000fc6000f8e0275ULL,
0x0000000708057812ULL, 0x000fe400078ec0ffULL, 0x0000000804007c0cULL, 0x000fe4000bf26070ULL,
0xfffffff805057812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001005057824ULL, 0x000fe400078e0202ULL, 0x0000000871717824ULL, 0x000fc800078e0200ULL,
0x8000000804041c36ULL, 0x000fe40008000000ULL, 0x000000010c0c1836ULL, 0x000fc60000000000ULL,
0x0000000804007c0cULL, 0x000fe4000bf46070ULL, 0x0000000005047984ULL, 0x000e760000000c00ULL,
0x000000010c0c2836ULL, 0x000fca0000000000ULL, 0x0000000c030c7207ULL, 0x000fca0004000000ULL,
0x000000ffff027224ULL, 0x000fe400078e0a0cULL, 0x000000090c0c7c24ULL, 0x000fe4000f8e0277ULL,
0x0000000802757c24ULL, 0x000fc8000f8e0275ULL, 0x000000080c757c24ULL, 0x000fca000f8e0275ULL,
0x000000750a757210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000475027c11ULL, 0x000fc8000f8040ffULL, 0x0000000575037c11ULL, 0x000fc600080f4408ULL,
0x0000001071027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000747100720cULL, 0x000fe20003f06070ULL,
0x00009a00ff6c7b82ULL, 0x000e620000000a00ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0xffffffffff0f7424ULL, 0x000fca00078e00ffULL, 0x00009000ff0a7b82ULL, 0x000ea80000000a00ULL,
0x0000000273028824ULL, 0x000fc800078e00ffULL, 0x00009600ff078b82ULL, 0x000ef00000000800ULL,
0x00009200ff0c8b82ULL, 0x000f620000000a00ULL, 0x000000066c6c7981ULL, 0x002322000c1e9900ULL,
0x0000000702078224ULL, 0x008fc800078e0271ULL, 0x00000004070c8825ULL, 0x020fe400078e000cULL,
0x01a60006ff0679a7ULL, 0x000e660008500008ULL, 0x000000060c0f8981ULL, 0x000ee2000c1e1900ULL,
0x000001ff0500780cULL, 0x000fe20003f04070ULL, 0x0000004000007824ULL, 0x000fe400078e00ffULL,
0x0000004071057824ULL, 0x000fe400078e00ffULL, 0x0000004077027824ULL, 0x000fc400078e00ffULL,
0x0000000f000f7224ULL, 0x008fc800078e02ffULL, 0x000000800f0a7825ULL, 0x004fe400078e000aULL,
0x0000000c00200947ULL, 0x002fea0003800000ULL, 0x00000003ff2e7819ULL, 0x000fe40000011609ULL,
0x00000005760c7248ULL, 0x000fc60007fe0000ULL, 0x000000042e0d7836ULL, 0x000fe40000000000ULL,
0x000000010c227824ULL, 0x000fe400078e0a05ULL, 0x000000010d0c7824ULL, 0x140fe400078e0209ULL,
0x000000080d0f7824ULL, 0x040fe200078e00ffULL, 0x000000220d00720cULL, 0x080fe20003f86070ULL,
0x000000082e0d7836ULL, 0x000fe40000000000ULL, 0x0000004077777824ULL, 0x000fe200078e022eULL,
0xfffffff80f247812ULL, 0x000fe200078ee20cULL, 0x000000010d127824ULL, 0x040fe200078e0209ULL,
0x000000220d00720cULL, 0x040fe20003f06070ULL, 0x000000080d157824ULL, 0x000fc400078e00ffULL,
0x00000080770c7825ULL, 0x000fc600078e00ffULL, 0xfffffff815267812ULL, 0x000fe200078ee212ULL,
0x0000000c2e0f7836ULL, 0x000fe20000000000ULL, 0x000000700c1b7812ULL, 0x000fe200078ef804ULL,
0x00000004770e7836ULL, 0x000fe40000000000ULL, 0x000000010f137824ULL, 0x040fe200078e0209ULL,
0x000000220f00720cULL, 0x040fe20003f26070ULL, 0x000000080f287824ULL, 0x000fe200078e00ffULL,
0x0000001b0a1a7210ULL, 0x000fe20007f5e0ffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee213ULL, 0x0000000c770c7836ULL, 0x000fe20000000000ULL,
0x000000700e1d7812ULL, 0x000fe200078ef804ULL, 0x000000010b1b7824ULL, 0x000fe400010e060dULL,
0x0000000877107836ULL, 0x000fe20000000000ULL, 0x0000001d0a1c7210ULL, 0x000fe20007f5e0ffULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700c1f7812ULL, 0x000fe400078ef804ULL, 0x00000008710c7c11ULL, 0x000fe2000f8e70ffULL,
0x00000010770e7836ULL, 0x000fe20000000000ULL, 0x0000007010177812ULL, 0x000fe200078ef804ULL,
0x0000001c77187836ULL, 0x000fe40000000000ULL, 0x000000010b1d7824ULL, 0x000fe200010e060fULL,
0x0000001f0a1e7210ULL, 0x000fe20007f5e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000170a167210ULL, 0x000fc60007f7e0ffULL, 0x0000001877127836ULL, 0x000fe20000000000ULL,
0x000000700e157812ULL, 0x000fe200078ef804ULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x000000010b1f7824ULL, 0x040fe200010e060dULL,
0x00000070180d7812ULL, 0x000fe200078ef804ULL, 0x0000001477107836ULL, 0x000fe20000000000ULL,
0x000000150a0e7210ULL, 0x000fe20007f5e0ffULL, 0x000000010b177824ULL, 0x000fe200018e0611ULL,
0x0000007012157812ULL, 0x000fe200078ef804ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000d0a127210ULL, 0x000fe40007fbe0ffULL, 0x000000150a147210ULL, 0x000fe20007f7e0ffULL,
0x000000012e0d7824ULL, 0x000fe200078e0209ULL, 0x0000007010217812ULL, 0x000fe200078ef804ULL,
0x000020000c237836ULL, 0x000fc40000000000ULL, 0x00000020770c7836ULL, 0x000fe20000000000ULL,
0x000000070d2a7812ULL, 0x000fe200078ec0ffULL, 0x000000010b0f7824ULL, 0x000fe200010e060fULL,
0x000000210a107210ULL, 0x000fe20007f5e0ffULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000102e187836ULL, 0x000fe20000000000ULL, 0x000000700c217812ULL, 0x000fe200078ef804ULL,
0x000000142e207836ULL, 0x000fe40000000000ULL, 0x000000010b157824ULL, 0x040fe400018e0613ULL,
0x000000010b137824ULL, 0x000fe200028e0619ULL, 0x000000222000720cULL, 0x080fe20003f66070ULL,
0x0000000118197824ULL, 0x000fe200078e0209ULL, 0x000000222e00720cULL, 0x000fe20003fa6070ULL,
0x00000008182c7824ULL, 0x000fc400078e00ffULL, 0x00000001200c7824ULL, 0x040fe400078e0209ULL,
0x0000000820277824ULL, 0x000fe200078e00ffULL, 0x000000210a207210ULL, 0x000fe20007fde0ffULL,
0x000000010b117824ULL, 0x040fe200010e0611ULL, 0x000000221800720cULL, 0x000fe20003f46070ULL,
0x0000001c2e2b7836ULL, 0x000fe20000000000ULL, 0x0ffffff82a187812ULL, 0x000fe200078ef809ULL,
0x000000010b217824ULL, 0x000fe200030e060dULL, 0xfffffff82c2a7812ULL, 0x000fe400078ee219ULL,
0xfffffff8272c7812ULL, 0x000fe200078ee20cULL, 0x00000024770c7836ULL, 0x000fc40000000000ULL,
0x0000001018257824ULL, 0x100fe400078e0223ULL, 0x0000002877187836ULL, 0x000fe40000000000ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a257faeULL, 0x0003e6000e901c46ULL, 0x0000001024277824ULL, 0x000fe200078e0223ULL,
0x000000700c2d7812ULL, 0x000fe200078ef804ULL, 0x000000182e247836ULL, 0x000fc40000000000ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x000000001c277faeULL, 0x0005e2000e101c46ULL,
0x000000222b00720cULL, 0x0c0fe40003f86070ULL, 0x000000222400720cULL, 0x040fe20003fa6070ULL,
0x0000000124297824ULL, 0x140fe200078e0209ULL, 0x0000002d0a1a7210ULL, 0x002fe20007fde0ffULL,
0x0000000824247824ULL, 0x000fe200078e00ffULL, 0x0000007018257812ULL, 0x000fe200078ef804ULL,
0x000000012b187824ULL, 0x040fe400078e0209ULL, 0x000000082b2b7824ULL, 0x000fc400078e00ffULL,
0x000000010b1b7824ULL, 0x040fe200030e060dULL, 0x000000250a0c7210ULL, 0x000fe20007fde0ffULL,
0x00000010261d7824ULL, 0x004fe200078e0223ULL, 0xfffffff8241c7812ULL, 0x000fe200078ee229ULL,
0x000000202e267836ULL, 0x000fe20000000000ULL, 0xfffffff82b247812ULL, 0x000fe200078ee218ULL,
0x0000002c77187836ULL, 0x000fe20000000000ULL, 0x00000000161d7faeULL, 0x0003e2000c101c46ULL,
0x000000010b0d7824ULL, 0x000fe200030e0619ULL, 0x000000222600720cULL, 0x000fe20003f06070ULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x0000001028257824ULL, 0x000fe200078e0223ULL,
0x0000007018297812ULL, 0x000fe200078ef804ULL, 0x000000242e287836ULL, 0x000fe40000000000ULL,
0x0000000126277824ULL, 0x000fe200078e0209ULL, 0x000000290a167210ULL, 0x002fe20007fde0ffULL,
0x000000102a1d7824ULL, 0x000fe200078e0223ULL, 0x000000001e257faeULL, 0x0003e2000c901c46ULL,
0x0000000826307824ULL, 0x000fe200078e00ffULL, 0x000000222800720cULL, 0x040fe20003f26070ULL,
0x0000000128267824ULL, 0x040fe200078e0209ULL, 0x000000000e1d7faeULL, 0x0005e2000d101c46ULL,
0x0000000828177824ULL, 0x000fe200078e00ffULL, 0xfffffff830187812ULL, 0x000fc800078ee227ULL,
0xfffffff817267812ULL, 0x000fe200078ee226ULL, 0x000000010b177824ULL, 0x000fe400030e0619ULL,
0x000000102c197824ULL, 0x100fe400078e0223ULL, 0x000000101c1f7824ULL, 0x102fe400078e0223ULL,
0x00000030770e7836ULL, 0x004fe20000000000ULL, 0x0000000010197faeULL, 0x0003e2000d901c46ULL,
0x0000001024257824ULL, 0x100fe400078e0223ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x00000000141f7faeULL, 0x000fe6000e901c46ULL, 0x0000001018277824ULL, 0x000fe200078e0223ULL,
0x0000000012257faeULL, 0x0005e2000e101c46ULL, 0x000000282e187836ULL, 0x000fc40000000000ULL,
0x0000001026297824ULL, 0x000fe200078e0223ULL, 0x000000700e117812ULL, 0x002fe200078ef804ULL,
0x0000003477107836ULL, 0x000fe20000000000ULL, 0x000000221800720cULL, 0x080fe20003fa6070ULL,
0x0000002c2e1c7836ULL, 0x000fe20000000000ULL, 0x0000000020277faeULL, 0x000fe2000c101c46ULL,
0x000000302e1d7836ULL, 0x000fe40000000000ULL, 0x000000011c0e7824ULL, 0x100fe200078e0209ULL,
0x000000110a127210ULL, 0x004fe20007fde0ffULL, 0x0000000118137824ULL, 0x040fe200078e0209ULL,
0x000000001a297faeULL, 0x0003e2000c901c46ULL, 0x0000000818187824ULL, 0x000fe200078e00ffULL,
0x000000221c00720cULL, 0x080fe20003f86070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000221d00720cULL, 0x000fc40003f66070ULL, 0xfffffff818187812ULL, 0x000fe200078ee213ULL,
0x000000010b137824ULL, 0x000fe200030e060fULL, 0x0000007010157812ULL, 0x000fe200078ef804ULL,
0x000000011d0f7824ULL, 0x040fe400078e0209ULL, 0x0000003877107836ULL, 0x000fe20000000000ULL,
0x000000150a147210ULL, 0x000fe20007fde0ffULL, 0x000000081c1b7824ULL, 0x002fe400078e00ffULL,
0x000000081d1c7824ULL, 0x000fe400078e00ffULL, 0x000000342e197836ULL, 0x000fe20000000000ULL,
0xfffffff81b1a7812ULL, 0x000fe200078ee20eULL, 0x000000382e1e7836ULL, 0x000fe20000000000ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20fULL, 0x00000080100e7825ULL, 0x000fe200078e00ffULL,
0x000000221900720cULL, 0x000fc40003f46070ULL, 0x000000221e00720cULL, 0x080fe20003f26070ULL,
0x0000003c2e1f7836ULL, 0x000fe20000000000ULL, 0x000000700e1d7812ULL, 0x000fe200078ef804ULL,
0x0000003c77107836ULL, 0x000fe40000000000ULL, 0x000000010b157824ULL, 0x000fe200030e0611ULL,
0x000000221f00720cULL, 0x000fe20003f06070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001d0a0e7210ULL, 0x000fc60007fde0ffULL, 0x00000001191b7824ULL, 0x140fe200078e0209ULL,
0x00000070101d7812ULL, 0x000fe200078ef804ULL, 0x0000000819207824ULL, 0x000fe400078e00ffULL,
0x000000011e197824ULL, 0x140fe400078e0209ULL, 0x000000081e227824ULL, 0x000fe200078e00ffULL,
0xfffffff8201e7812ULL, 0x000fe200078ee21bULL, 0x000000011f097824ULL, 0x040fe400078e0209ULL,
0x000000081f247824ULL, 0x000fe200078e00ffULL, 0xfffffff822207812ULL, 0x000fe200078ee219ULL,
0x000000010b0f7824ULL, 0x000fe200030e060fULL, 0x0000001d0a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000101a197824ULL, 0x100fe200078e0223ULL, 0xfffffff824227812ULL, 0x000fe200078ee209ULL,
0x0000001018097824ULL, 0x000fc400078e0223ULL, 0x000000101c1b7824ULL, 0x100fe400078e0223ULL,
0x000000101e1d7824ULL, 0x100fe200078e0223ULL, 0x000000000c097faeULL, 0x0003e2000e901c46ULL,
0x00000010201f7824ULL, 0x100fe400078e0223ULL, 0x0000001022237824ULL, 0x000fe200078e0223ULL,
0x0000000016197faeULL, 0x0003e2000e101c46ULL, 0x000000010b0b7824ULL, 0x000fc600030e0611ULL,
0x00000000121b7faeULL, 0x0003e8000d901c46ULL, 0x00000000141d7faeULL, 0x0003e8000d101c46ULL,
0x000000000e1f7faeULL, 0x0003e8000c901c46ULL, 0x000000000a237faeULL, 0x0003e2000c101c46ULL,
0x0000000800d07947ULL, 0x000fea0003800000ULL, 0x00000004090f7811ULL, 0x040fe400078fe8ffULL,
0x0000000c09147811ULL, 0x040fe400078fe8ffULL, 0x0000000809127811ULL, 0x000fe200078fe8ffULL,
0x000000010f0c7824ULL, 0x100fe200078e0209ULL, 0x0000001009167811ULL, 0x000fe200078fe8ffULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0x0000001c091c7811ULL, 0x040fe200078fe8ffULL,
0x00000001140d7824ULL, 0x140fe200078e0209ULL, 0x0000001409187811ULL, 0x040fe200078fe8ffULL,
0x00000008141a7824ULL, 0x000fe200078e00ffULL, 0xfffffff811117812ULL, 0x000fe200078ee20cULL,
0x00000001120c7824ULL, 0x140fe200078e0209ULL, 0x00000020091e7811ULL, 0x040fe200078fe8ffULL,
0x0000000812137824ULL, 0x000fe200078e00ffULL, 0xfffffff81a157812ULL, 0x000fe200078ee20dULL,
0x00000001160e7824ULL, 0x140fe200078e0209ULL, 0x00000018091a7811ULL, 0x040fe200078fe8ffULL,
0x0000000816177824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee20cULL,
0x000000011c0d7824ULL, 0x100fe200078e0209ULL, 0x0000002809237811ULL, 0x040fe200078fe8ffULL,
0x000000011a0c7824ULL, 0x140fe200078e0209ULL, 0x0000002c09247811ULL, 0x040fe200078fe8ffULL,
0x000000081a1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fe200078ee20eULL,
0x000000081c227824ULL, 0x000fe200078e00ffULL, 0x0000002409207811ULL, 0x040fe200078fe8ffULL,
0x0000000118107824ULL, 0x140fe200078e0209ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20cULL,
0x0000000818197824ULL, 0x000fe200078e00ffULL, 0xfffffff8221d7812ULL, 0x000fe200078ee20dULL,
0x000000011e0e7824ULL, 0x140fe200078e0209ULL, 0x00000030092c7811ULL, 0x000fe200078fe8ffULL,
0x000000081e1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee210ULL,
0x00000001230c7824ULL, 0x100fe200078e0209ULL, 0x00000034092e7811ULL, 0x000fe200078fe8ffULL,
0x0000000823257824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20eULL,
0x00000001240d7824ULL, 0x140fe200078e0209ULL, 0x0000003809307811ULL, 0x040fe200078fe8ffULL,
0x0000000824267824ULL, 0x000fe200078e00ffULL, 0xfffffff825227812ULL, 0x000fe200078ee20cULL,
0x0000000120107824ULL, 0x140fe200078e0209ULL, 0x0000003c09327811ULL, 0x040fe200078fe8ffULL,
0x0000000820217824ULL, 0x000fe200078e00ffULL, 0xfffffff826257812ULL, 0x000fe200078ee20dULL,
0x000000012c0e7824ULL, 0x140fe200078e0209ULL, 0x00000009090d7211ULL, 0x040fe200078fe8ffULL,
0x000000082c277824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee210ULL,
0x000000012e107824ULL, 0x140fe200078e0209ULL, 0x00000002090c7211ULL, 0x000fe200078fe8ffULL,
0x000000082e297824ULL, 0x000fe200078e00ffULL, 0xfffffff827267812ULL, 0x000fe200078ee20eULL,
0x0000000130287824ULL, 0x000fe200078e0209ULL, 0x000000070d0e7812ULL, 0x000fe200078ec0ffULL,
0x00000001020f7824ULL, 0x000fe200078e020fULL, 0xfffffff829277812ULL, 0x000fe200078ee210ULL,
0x00000008302b7824ULL, 0x000fe200078e00ffULL, 0x0000000871297c11ULL, 0x000fe2000f8e70ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0ffffff80e107812ULL, 0x000fc400078ef809ULL,
0xfffffff82b287812ULL, 0x000fe200078ee228ULL, 0x0000000132097824ULL, 0x040fe200078e0209ULL,
0x000000700c2b7812ULL, 0x000fe200078ef804ULL, 0x00000008320e7824ULL, 0x000fe400078e00ffULL,
0x00002000292a7836ULL, 0x000fe20000000000ULL, 0x0000002b0a0c7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff80e297812ULL, 0x000fe200078ee209ULL, 0x000000800f0e7825ULL, 0x000fc800078e00ffULL,
0x00000010112d7824ULL, 0x100fe200078e022aULL, 0x000000700e117812ULL, 0x000fe200078ef804ULL,
0x0000001010097824ULL, 0x000fe400078e022aULL, 0x0000000102107824ULL, 0x040fe200078e0212ULL,
0x000000110a0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000102127824ULL, 0x000fe400078e0214ULL,
0x00000010132f7824ULL, 0x000fe400078e022aULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000102147824ULL, 0x000fe400078e0216ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000102167824ULL, 0x000fe400078e0218ULL, 0x000000101f3b7824ULL, 0x100fe200078e022aULL,
0x00000070101f7812ULL, 0x000fe200078ef804ULL, 0x0000001017337824ULL, 0x100fe400078e022aULL,
0x000000101b377824ULL, 0x000fe200078e022aULL, 0x00000070121b7812ULL, 0x000fe200078ef804ULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x000000010b0d7824ULL, 0x040fe200000e060dULL,
0x0000001f0a107210ULL, 0x000fe20007f1e0ffULL, 0x0000000102187824ULL, 0x000fe400078e021aULL,
0x000000010b0f7824ULL, 0x000fe200008e060fULL, 0x0000001b0a127210ULL, 0x000fe20007f3e0ffULL,
0x0000001019357824ULL, 0x100fe200078e022aULL, 0x00000070161b7812ULL, 0x000fe200078ef804ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c097faeULL, 0x0003e6000b901c46ULL, 0x000000010b117824ULL, 0x000fe200000e0611ULL,
0x0000001b0a167210ULL, 0x000fe20007f1e0ffULL, 0x00000010223f7824ULL, 0x100fe200078e022aULL,
0x00000070181b7812ULL, 0x000fe200078ef804ULL, 0x0000001015317824ULL, 0x000fe200078e022aULL,
0x000000000e2d7faeULL, 0x0003e2000b901c46ULL, 0x000000010b177824ULL, 0x000fe200000e0617ULL,
0x0000001b0a227210ULL, 0x000fe20007f1e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x00000000102f7faeULL, 0x0003e6000b901c46ULL, 0x00000001021a7824ULL, 0x000fc400078e021cULL,
0x0000000102187824ULL, 0x040fe400078e021eULL, 0x00000001021e7824ULL, 0x000fe400078e0223ULL,
0x000000101d397824ULL, 0x000fe200078e022aULL, 0x00000070141d7812ULL, 0x000fe200078ef804ULL,
0x000000801a1a7825ULL, 0x000fc600078e00ffULL, 0x0000001d0a147210ULL, 0x000fe20007f5e0ffULL,
0x000000010b237824ULL, 0x000fe400000e0619ULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x00000001021c7824ULL, 0x000fe400078e0220ULL, 0x0000001025417824ULL, 0x100fe200078e022aULL,
0x000000701a257812ULL, 0x000fe200078ef804ULL, 0x0000001027457824ULL, 0x000fe200078e022aULL,
0x0000007018277812ULL, 0x000fe200078ef804ULL, 0x000000801c1c7825ULL, 0x000fc800078e00ffULL,
0x00000001021a7824ULL, 0x000fe200078e0224ULL, 0x000000250a247210ULL, 0x000fe20007f1e0ffULL,
0x0000001026437824ULL, 0x100fe400078e022aULL, 0x000000010b137824ULL, 0x000fe200008e0613ULL,
0x000000270a267210ULL, 0x000fe20007f3e0ffULL, 0x0000001029497824ULL, 0x100fe200078e022aULL,
0x000000701c297812ULL, 0x000fe200078ef804ULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000000012317faeULL, 0x0003e6000b901c46ULL, 0x0000001028477824ULL, 0x000fe200078e022aULL,
0x000000701e2b7812ULL, 0x000fe200078ef804ULL, 0x000000010b257824ULL, 0x040fe200000e061bULL,
0x000000290a287210ULL, 0x000fe20007f1e0ffULL, 0x000000010b277824ULL, 0x000fc400008e0619ULL,
0x000000801a187825ULL, 0x000fc800078e00ffULL, 0x00000010213d7824ULL, 0x000fe400078e022aULL,
0x000000010b157824ULL, 0x040fe200010e0615ULL, 0x0000002b0a2a7210ULL, 0x000fe20007f5e0ffULL,
0x000000010b297824ULL, 0x000fe200000e061dULL, 0x00000070181d7812ULL, 0x000fe200078ef804ULL,
0x00000001021a7824ULL, 0x040fe200078e022cULL, 0x0000000014337faeULL, 0x0003e2000b901c46ULL,
0x00000001021c7824ULL, 0x040fe200078e022eULL, 0x0000001d0a187210ULL, 0x000fe20007f1e0ffULL,
0x00000001021e7824ULL, 0x040fe200078e0230ULL, 0x0000000016357faeULL, 0x0003e2000b901c46ULL,
0x0000000102207824ULL, 0x000fc400078e0232ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000022377faeULL, 0x0003e6000b901c46ULL, 0x000000010b2b7824ULL, 0x040fe200010e061fULL,
0x000000701a517812ULL, 0x000fe200078ef804ULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000000024397faeULL, 0x0003e6000b901c46ULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x000000701c4f7812ULL, 0x000fe200078ef804ULL, 0x00000000263b7faeULL, 0x0003e4000b901c46ULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x000000701e4d7812ULL, 0x000fe200078ef804ULL,
0x00000000283d7faeULL, 0x0003e2000b901c46ULL, 0x0000004f0a1c7210ULL, 0x000fe20007f3e0ffULL,
0x000000010b197824ULL, 0x040fe200000e0619ULL, 0x00000070204b7812ULL, 0x000fe200078ef804ULL,
0x000000002a3f7faeULL, 0x0003e2000b901c46ULL, 0x000000510a1a7210ULL, 0x000fe20007f1e0ffULL,
0x000000010b1d7824ULL, 0x040fe200008e061dULL, 0x0000004d0a1e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000018417faeULL, 0x0003e2000b901c46ULL, 0x0000004b0a0a7210ULL, 0x000fe20007f7e0ffULL,
0x000000010b1b7824ULL, 0x000fc400000e061bULL, 0x000000010b1f7824ULL, 0x040fe400010e061fULL,
0x000000010b0b7824ULL, 0x000fe200018e0621ULL, 0x000000001a437faeULL, 0x0003e8000b901c46ULL,
0x000000001c457faeULL, 0x0003e8000b901c46ULL, 0x000000001e477faeULL, 0x0003e8000b901c46ULL,
0x000000000a497faeULL, 0x0003e4000b901c46ULL, 0x00000004717b7836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff797424ULL, 0x000fe200078e00ffULL,
0x0000840000047ab9ULL, 0x000fe40000000800ULL, 0x000000747b00720cULL, 0x000fda0003f06070ULL,
0x00009600ff098b82ULL, 0x002e620000000800ULL, 0x0000000273048824ULL, 0x000fce00078e00ffULL,
0x00009200ff0a8b82ULL, 0x000ea20000000a00ULL, 0x0000000904098224ULL, 0x002fc800078e027bULL,
0x00000004090a8825ULL, 0x004fca00078e000aULL, 0x000000060a798981ULL, 0x000322000c1e1900ULL,
0x0000001f04047890ULL, 0x000fc8000fffe03fULL, 0x000000053f047899ULL, 0x000fd80008011604ULL,
0x00000000000a7805ULL, 0x002fce0000015200ULL, 0x01a60007ff0075a7ULL, 0x000e620008000148ULL,
0x00000001765b7824ULL, 0x000fe400078e0a03ULL, 0x0000000408097c24ULL, 0x000fc6000f8e02ffULL,
0x00000008ff5b7819ULL, 0x000fe2000001165bULL, 0x00008e00ff907b82ULL, 0x000ea40000000a00ULL,
0x0000000409907825ULL, 0x004fe200078e0090ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fce0000015200ULL,
0x000000080a0d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e0bULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011409ULL, 0x0000000d04047211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000204047819ULL, 0x000fc80000001209ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x01a60007ff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000047919ULL, 0x000e640000000000ULL,
0x0000002071047824ULL, 0x002fc800078e0204ULL, 0x0000000104087836ULL, 0x000fe20000000000ULL,
0x00000004ff067819ULL, 0x000fc80000011604ULL, 0x0ffffffe06077812ULL, 0x000fe400078ec0ffULL,
0x0000001f04067812ULL, 0x000fc600078ec0ffULL, 0x00000001070a7824ULL, 0x000fe400078e0208ULL,
0x0000000104097824ULL, 0x000fe400078e0207ULL, 0x00000010060b7824ULL, 0x000fe200078e00ffULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x00000010060c7824ULL, 0x040fe200078e00ffULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x0000000807077836ULL, 0x000fe20000000000ULL,
0x000001f00b0a7812ULL, 0x000fe200078ee20aULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x000001f00c097812ULL, 0x000fe200078ee209ULL, 0x0000000104047824ULL, 0x100fe200078e0207ULL,
0x000000080a0a7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000108077824ULL, 0x000fe200078e0207ULL,
0x0000000809097c11ULL, 0x000fc4000f8e20ffULL, 0x0000000f04047812ULL, 0x000fe200078ec0ffULL,
0x000000000a0c7984ULL, 0x000e620000000c00ULL, 0x0000000f07077812ULL, 0x000fe400078ec0ffULL,
0x000001f00b047812ULL, 0x000fe200078ee204ULL, 0x0000000009107984ULL, 0x000ea20000000c00ULL,
0x000001f006077812ULL, 0x000fe400078ee207ULL, 0x0000000804047c11ULL, 0x000fe4000f8e20ffULL,
0x0000000807077c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff167224ULL, 0x002fc400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff147224ULL, 0x004fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fe200078e000fULL, 0x0000001409007388ULL, 0x000fe20000000c00ULL,
0x000000ffff187224ULL, 0x000fc400078e0011ULL, 0x000000ffff197224ULL, 0x000fca00078e0013ULL,
0x000000180a007388ULL, 0x0003e80000000c00ULL, 0x00000000070c7984ULL, 0x000ea80000000c00ULL,
0x0000000004107984ULL, 0x000ee20000000c00ULL, 0x00000001ff0a7424ULL, 0x002fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x004fc400078e000eULL, 0x000000ffff1e7224ULL, 0x000fe400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1c7224ULL, 0x008fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000001c04007388ULL, 0x0003e80000000c00ULL,
0x0000000c07007388ULL, 0x0003e20000000c00ULL, 0x01a6000aff0a79a7ULL, 0x000ea40008500008ULL,
0x0000000000067805ULL, 0x002fce0000015200ULL, 0x01a6000bff0075a7ULL, 0x004e640008000148ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000000100c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fce0000015200ULL, 0x00000008060d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011409ULL,
0x0000000d04047211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000204047819ULL, 0x000fc80000001209ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010c0c7836ULL, 0x000fce0000000000ULL,
0x01a6000bff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ff7000720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00009600ff067b82ULL, 0x000e620000000800ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x3db504f36c6c7820ULL, 0x010fe20000410000ULL, 0x0000010005777836ULL, 0x000fe20000000000ULL,
0x0000000871727c11ULL, 0x000fe2000f8e28ffULL, 0xffffffff03077836ULL, 0x000fe20000000000ULL,
0x00000000006e7805ULL, 0x000fe2000001ff00ULL, 0x0000000903587836ULL, 0x000fe20000000000ULL,
0x0000000104057899ULL, 0x000fe2000800063fULL, 0x0000000673737224ULL, 0x002fe200078e02ffULL,
0x0000000871067c11ULL, 0x000fd4000f8e18ffULL, 0x00009000ff087b82ULL, 0x002e620000000a00ULL,
0x000000026e0b7836ULL, 0x000fe20000000000ULL, 0x000000016f597812ULL, 0x000fe200078e0cffULL,
0x0000007900797224ULL, 0x010fc600078e02ffULL, 0x000000700b00720cULL, 0x000fe20003f06070ULL,
0x0000008079087825ULL, 0x002fd800078e0008ULL, 0x0000000c00308947ULL, 0x000fea0003800000ULL,
0x000001006e0b7824ULL, 0x000fe200078e0277ULL, 0x00000003ff0d7819ULL, 0x004fe40000011604ULL,
0x00000008715a7c11ULL, 0x000fe4000f8e70ffULL, 0x0000000b760a7248ULL, 0x000fe20007fe0000ULL,
0x000000040d0f7836ULL, 0x000fe40000000000ULL, 0x0000000c0d197836ULL, 0x000fe40000000000ULL,
0x000000010a0b7824ULL, 0x000fc400078e0a0bULL, 0x000000010f0a7824ULL, 0x140fe400078e0204ULL,
0x000000080f217824ULL, 0x040fe200078e00ffULL, 0x0000000b0f00720cULL, 0x080fe20003f46070ULL,
0x00000001190e7824ULL, 0x040fe200078e0204ULL, 0x0000000b1900720cULL, 0x040fe20003fa6070ULL,
0x0000000819257824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee20aULL,
0x00000010040a7824ULL, 0x000fe400078e00ffULL, 0x0000000102107824ULL, 0x040fe200078e020fULL,
0xfffffff825257812ULL, 0x000fe200078ee20eULL, 0x00000001020e7824ULL, 0x000fe200078e020dULL,
0x000000700a0a7812ULL, 0x000fe200078ec0ffULL, 0x000000180d2d7836ULL, 0x000fc40000000000ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x000000080d137836ULL, 0x000fe20000000000ULL,
0x0000000a0e157212ULL, 0x000fe200078efcffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x0000001508147210ULL, 0x000fe20007f1e0ffULL, 0x000000012d0e7824ULL, 0x140fe200078e0204ULL,
0x0000000a10177212ULL, 0x000fe200078efcffULL, 0x000000082d2f7824ULL, 0x000fe200078e00ffULL,
0x0000000b1300720cULL, 0x0c0fe20003f66070ULL, 0x00000001130c7824ULL, 0x140fe200078e0204ULL,
0x0000001708167210ULL, 0x000fe20007f3e0ffULL, 0x0000000813237824ULL, 0x000fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee20eULL, 0x000000100d1b7836ULL, 0x000fe40000000000ULL,
0x00000001020e7824ULL, 0x000fe200078e0213ULL, 0xfffffff823237812ULL, 0x000fe200078ee20cULL,
0x000000011b0c7824ULL, 0x040fe200078e0204ULL, 0x0000000b1b00720cULL, 0x040fe20003f86070ULL,
0x000000081b277824ULL, 0x000fc400078e00ffULL, 0x0000000109157824ULL, 0x000fe400000e060fULL,
0x0000000102107824ULL, 0x000fe200078e0219ULL, 0xfffffff827277812ULL, 0x000fe200078ee20cULL,
0x000000140d297836ULL, 0x000fe40000000000ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000000109177824ULL, 0x000fe200008e0611ULL, 0x0000000a0e197212ULL, 0x080fe200078efcffULL,
0x000000010d137824ULL, 0x140fe200078e0204ULL, 0x0000000b0d00720cULL, 0x000fe20003f26070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000001908187210ULL, 0x000fe40007f1e0ffULL,
0x00000007131f7812ULL, 0x000fe200078ec0ffULL, 0x00000001290c7824ULL, 0x040fe400078e0204ULL,
0x00000008292b7824ULL, 0x000fe200078e00ffULL, 0x0ffffff81f1f7812ULL, 0x000fe200078ef804ULL,
0x0000000102127824ULL, 0x000fe200078e021bULL, 0x0000000a101b7212ULL, 0x000fe200078efcffULL,
0x00000001020e7824ULL, 0x000fe200078e0229ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee20cULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000001b081a7210ULL, 0x000fc60007fde0ffULL,
0x00002000590c7824ULL, 0x000fe200078e025aULL, 0x0000000a121d7212ULL, 0x000fe200078efcffULL,
0x0000000109197824ULL, 0x000fe200000e060fULL, 0x0000000b2900720cULL, 0x000fe20003f06070ULL,
0x000020000c0c7836ULL, 0x000fe40000000000ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x00000001091b7824ULL, 0x000fe200030e0611ULL, 0x0000001d08127210ULL, 0x000fe20007fde0ffULL,
0x000000101f117824ULL, 0x000fe200078e020cULL, 0x0000000a0e1d7212ULL, 0x000fe200078efcffULL,
0x000000200d317836ULL, 0x000fe40000000000ULL, 0x0000000109137824ULL, 0x000fe200030e0613ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014117faeULL, 0x0003e2000c901c46ULL,
0x00000001310e7824ULL, 0x000fe200078e0204ULL, 0x0000000b2d00720cULL, 0x000fe20003f26070ULL,
0x0000000831337824ULL, 0x000fc400078e00ffULL, 0x0000000102107824ULL, 0x000fe400078e022dULL,
0x0000001c0d297836ULL, 0x000fe20000000000ULL, 0xfffffff833337812ULL, 0x000fe200078ee20eULL,
0x00000010211f7824ULL, 0x000fe400078e020cULL, 0x00000001291c7824ULL, 0x040fe200078e0204ULL,
0x0000001d08147210ULL, 0x002fe20007fde0ffULL, 0x00000008292d7824ULL, 0x000fe200078e00ffULL,
0x00000000161f7faeULL, 0x0003e2000d101c46ULL, 0x0000001023217824ULL, 0x000fe200078e020cULL,
0x0000000b2900720cULL, 0x080fe20003f46070ULL, 0x0000000109157824ULL, 0x000fe200030e060fULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee21cULL, 0x00000080100e7825ULL, 0x000fe200078e00ffULL,
0x0000000018217faeULL, 0x0005e2000d901c46ULL, 0x0000000b3100720cULL, 0x000fc40003f66070ULL,
0x0000000102107824ULL, 0x000fe200078e0229ULL, 0x0000000a0e1d7212ULL, 0x000fe200078efcffULL,
0x00000001020e7824ULL, 0x000fe400078e0231ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001d081c7210ULL, 0x000fc60007fde0ffULL, 0x000000240d237836ULL, 0x000fe20000000000ULL,
0x0000000a10177212ULL, 0x002fe200078efcffULL, 0x00000001091d7824ULL, 0x000fe400030e060fULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000001708167210ULL, 0x000fc60007fde0ffULL,
0x0000000102107824ULL, 0x000fe200078e0223ULL, 0x0000000a0e197212ULL, 0x004fe200078efcffULL,
0x0000000109177824ULL, 0x000fe400030e0611ULL, 0x00000010251f7824ULL, 0x000fe200078e020cULL,
0x0000001908187210ULL, 0x000fe20007fde0ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x000000001a1f7faeULL, 0x0003e2000e901c46ULL, 0x0000000109197824ULL, 0x000fe200030e060fULL,
0x0000000b2300720cULL, 0x080fe20003fa6070ULL, 0x000000280d0f7836ULL, 0x000fe40000000000ULL,
0x0000001027217824ULL, 0x000fe400078e020cULL, 0x00000001020e7824ULL, 0x000fe400078e020fULL,
0x000000080f277824ULL, 0x040fe200078e00ffULL, 0x0000000012217faeULL, 0x0005e2000e101c46ULL,
0x0000000b0f00720cULL, 0x000fe20003f86070ULL, 0x00000001231e7824ULL, 0x100fe200078e0204ULL,
0x0000000a101b7212ULL, 0x002fe200078efcffULL, 0x000000010f107824ULL, 0x000fc400078e0204ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000001b081a7210ULL, 0x000fe40007fde0ffULL,
0xfffffff827277812ULL, 0x000fe200078ee210ULL, 0x0000000823257824ULL, 0x000fe400078e00ffULL,
0x0000002c0d237836ULL, 0x000fe40000000000ULL, 0x00000001091b7824ULL, 0x000fe200030e0611ULL,
0x0000000a0e117212ULL, 0x000fe200078efcffULL, 0x0000000102107824ULL, 0x000fe200078e0223ULL,
0xfffffff825257812ULL, 0x000fe200078ee21eULL, 0x000000102b1f7824ULL, 0x000fe200078e020cULL,
0x00000011080e7210ULL, 0x000fe20007fde0ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x00000000141f7faeULL, 0x0003e2000c101c46ULL, 0x000000102f217824ULL, 0x004fe200078e020cULL,
0x0000000b2300720cULL, 0x0c0fe20003f06070ULL, 0x000000300d2b7836ULL, 0x000fe40000000000ULL,
0x0000000123137824ULL, 0x140fe200078e0204ULL, 0x000000001c217faeULL, 0x0005e2000c901c46ULL,
0x00000008231e7824ULL, 0x000fe200078e00ffULL, 0x0000000b2b00720cULL, 0x040fe20003f26070ULL,
0x0000000102127824ULL, 0x000fe400078e022bULL, 0x000000340d2f7836ULL, 0x000fe20000000000ULL,
0x0000000a10157212ULL, 0x002fe200078efcffULL, 0x000000012b107824ULL, 0x040fe200078e0204ULL,
0xfffffff81e297812ULL, 0x000fe200078ee213ULL, 0x000000082b2b7824ULL, 0x000fc400078e00ffULL,
0x00000001090f7824ULL, 0x000fe200030e060fULL, 0x0000001508147210ULL, 0x000fe20007fde0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fc600078ee210ULL,
0x0000000102107824ULL, 0x000fe200078e022fULL, 0x0000000a121f7212ULL, 0x000fe200078efcffULL,
0x0000000109157824ULL, 0x000fe400030e0611ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001f081e7210ULL, 0x000fc60007fde0ffULL, 0x0000001025217824ULL, 0x104fe200078e020cULL,
0x0000000a101d7212ULL, 0x000fe200078efcffULL, 0x000000380d257836ULL, 0x000fe40000000000ULL,
0x00000001091f7824ULL, 0x000fe200030e0613ULL, 0x0000001d081c7210ULL, 0x000fe20007fde0ffULL,
0x000000102d237824ULL, 0x100fe400078e020cULL, 0x0000000102107824ULL, 0x000fe400078e0225ULL,
0x0000001033137824ULL, 0x000fe200078e020cULL, 0x0000000016237faeULL, 0x0003e2000d101c46ULL,
0x0000003c0d2d7836ULL, 0x000fc40000000000ULL, 0x00000001091d7824ULL, 0x000fe200030e0611ULL,
0x0000000018137faeULL, 0x0005e2000d901c46ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000b2500720cULL, 0x080fe40003f66070ULL, 0x000000001a217faeULL, 0x0007e2000e901c46ULL,
0x0000000102127824ULL, 0x000fe200078e022dULL, 0x0000000b2f00720cULL, 0x0c0fe20003fa6070ULL,
0x000000012f0d7824ULL, 0x100fe200078e0204ULL, 0x0000000b2d00720cULL, 0x000fe20003f46070ULL,
0x0000000125167824ULL, 0x102fe200078e0204ULL, 0x0000000a100b7212ULL, 0x000fe200078efcffULL,
0x000000012d177824ULL, 0x000fc400078e0204ULL, 0x0000008012127825ULL, 0x004fe200078e00ffULL,
0x0000000b08107210ULL, 0x000fc60007fde0ffULL, 0x000000082f187824ULL, 0x000fe200078e00ffULL,
0x0000000a12197212ULL, 0x000fe200078efcffULL, 0x0000000825217824ULL, 0x008fe400078e00ffULL,
0x000000082d1a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8181b7812ULL, 0x000fe200078ee20dULL,
0x0000000109117824ULL, 0x000fe200030e0611ULL, 0xfffffff821217812ULL, 0x000fe200078ee216ULL,
0x00000010270b7824ULL, 0x100fe200078e020cULL, 0xfffffff81a237812ULL, 0x000fe200078ee217ULL,
0x00000010290d7824ULL, 0x100fe200078e020cULL, 0x0000001908087210ULL, 0x000fe20007fde0ffULL,
0x000000102b177824ULL, 0x100fe200078e020cULL, 0x000000000e0b7faeULL, 0x0003e2000e101c46ULL,
0x000000101b197824ULL, 0x000fc400078e020cULL, 0x00000010211b7824ULL, 0x100fe200078e020cULL,
0x00000000140d7faeULL, 0x0003e2000c101c46ULL, 0x0000001023217824ULL, 0x000fe400078e020cULL,
0x0000000109097824ULL, 0x000fe200030e0613ULL, 0x000000001e177faeULL, 0x0003e8000c901c46ULL,
0x000000001c197faeULL, 0x0003e8000e901c46ULL, 0x00000000101b7faeULL, 0x0003e8000d901c46ULL,
0x0000000008217faeULL, 0x0003e2000d101c46ULL, 0x0000000800dc7947ULL, 0x000fea0003800000ULL,
0x00000004040f7811ULL, 0x044fe200078fe8ffULL, 0x00000010041a7824ULL, 0x040fe200078e00ffULL,
0x0000000804117811ULL, 0x040fe400078fe8ffULL, 0x0000000c04137811ULL, 0x040fe200078fe8ffULL,
0x000000010f0a7824ULL, 0x140fe200078e0204ULL, 0x0000001004157811ULL, 0x040fe200078fe8ffULL,
0x000000080f1d7824ULL, 0x000fe200078e00ffULL, 0x0000001804197811ULL, 0x040fe200078fe8ffULL,
0x00000001110b7824ULL, 0x140fe200078e0204ULL, 0x0000001404177811ULL, 0x040fe200078fe8ffULL,
0x00000008110c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20aULL,
0x00000001130a7824ULL, 0x140fe200078e0204ULL, 0x0000001c04237811ULL, 0x040fe200078fe8ffULL,
0x0000000813317824ULL, 0x000fe200078e00ffULL, 0xfffffff80c2f7812ULL, 0x000fe200078ee20bULL,
0x00000001150b7824ULL, 0x140fe200078e0204ULL, 0x0000002004257811ULL, 0x040fe200078fe8ffULL,
0x00000008150e7824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee20aULL,
0x00000001190d7824ULL, 0x140fe200078e0204ULL, 0x0000002804297811ULL, 0x040fe200078fe8ffULL,
0x0000000819107824ULL, 0x000fe200078e00ffULL, 0xfffffff80e337812ULL, 0x000fe200078ee20bULL,
0x00000001170c7824ULL, 0x140fe200078e0204ULL, 0x0000002404277811ULL, 0x040fe200078fe8ffULL,
0x0000000817357824ULL, 0x000fe200078e00ffULL, 0x0000002c042b7811ULL, 0x040fe200078fe8ffULL,
0x00000001230a7824ULL, 0x140fe200078e0204ULL, 0x00000030042d7811ULL, 0x040fe200078fe8ffULL,
0x0000000823397824ULL, 0x000fe200078e00ffULL, 0xfffffff810377812ULL, 0x000fe200078ee20dULL,
0x00000001250b7824ULL, 0x140fe200078e0204ULL, 0xfffffff835357812ULL, 0x000fe200078ee20cULL,
0x00000008250e7824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee20aULL,
0x00000001290d7824ULL, 0x140fe200078e0204ULL, 0x00000038044d7811ULL, 0x040fe200078fe8ffULL,
0x0000000829107824ULL, 0x000fe200078e00ffULL, 0xfffffff80e3b7812ULL, 0x000fe200078ee20bULL,
0x00000001270c7824ULL, 0x140fe200078e0204ULL, 0x00000034044b7811ULL, 0x040fe200078fe8ffULL,
0x00000008273d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8103f7812ULL, 0x000fe200078ee20dULL,
0x000000012b0a7824ULL, 0x100fe200078e0204ULL, 0x00000008715a7c11ULL, 0x000fe2000f8e70ffULL,
0x000000082b417824ULL, 0x000fe200078e00ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee20cULL,
0x000000012d0b7824ULL, 0x140fe200078e0204ULL, 0x0000003c044f7811ULL, 0x040fe200078fe8ffULL,
0x000000082d0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee20aULL,
0x000000014d0d7824ULL, 0x140fe200078e0204ULL, 0x00000002040a7211ULL, 0x040fe200078fe8ffULL,
0x000000084d107824ULL, 0x000fe200078e00ffULL, 0xfffffff80e437812ULL, 0x000fe200078ee20bULL,
0x000000014b0c7824ULL, 0x140fe200078e0204ULL, 0x00000004040b7211ULL, 0x000fe200078fe8ffULL,
0x000000084b457824ULL, 0x000fe200078e00ffULL, 0xfffffff810477812ULL, 0x000fe200078ee20dULL,
0x000000014f127824ULL, 0x000fe200078e0204ULL, 0x000000070b0d7812ULL, 0x000fe200078ec0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fc400078ee20cULL,
0x000000701a1a7812ULL, 0x000fe200078ec0ffULL, 0x00002000590c7824ULL, 0x000fe200078e025aULL,
0x0ffffff80d1b7812ULL, 0x000fe200078ef804ULL, 0x000000084f497824ULL, 0x000fe400078e00ffULL,
0x0000000102107824ULL, 0x000fe200078e020fULL, 0x0000001a0a0f7212ULL, 0x000fe200078efcffULL,
0x000020000c0e7836ULL, 0x000fe20000000000ULL, 0xfffffff849497812ULL, 0x000fe200078ee212ULL,
0x00000080100c7825ULL, 0x000fe200078e00ffULL, 0x0000000f080a7210ULL, 0x000fc60007f1e0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e020eULL, 0x0000001a0c0f7212ULL, 0x000fe200078efcffULL,
0x000000101d1d7824ULL, 0x100fe400078e020eULL, 0x000000102f2f7824ULL, 0x100fe200078e020eULL,
0x0000000f080c7210ULL, 0x000fe20007f3e0ffULL, 0x0000001031317824ULL, 0x100fe400078e020eULL,
0x0000001033337824ULL, 0x100fe400078e020eULL, 0x0000001035357824ULL, 0x000fc400078e020eULL,
0x0000001037377824ULL, 0x100fe400078e020eULL, 0x0000001039397824ULL, 0x100fe400078e020eULL,
0x000000103b3b7824ULL, 0x100fe400078e020eULL, 0x000000103d3d7824ULL, 0x100fe400078e020eULL,
0x000000103f3f7824ULL, 0x100fe400078e020eULL, 0x0000001041417824ULL, 0x000fc400078e020eULL,
0x0000001043437824ULL, 0x100fe400078e020eULL, 0x0000001045457824ULL, 0x100fe400078e020eULL,
0x0000001047477824ULL, 0x100fe400078e020eULL, 0x0000001049497824ULL, 0x000fe400078e020eULL,
0x00000001020e7824ULL, 0x040fe400078e0211ULL, 0x0000000102147824ULL, 0x000fc400078e0217ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000000102167824ULL, 0x000fe200078e0219ULL,
0x0000001a0e197212ULL, 0x000fe200078efcffULL, 0x0000000102127824ULL, 0x000fe400078e0215ULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x000000010b0b7824ULL, 0x100fe200000e0609ULL,
0x00000019080e7210ULL, 0x000fe20007f1e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000001a14197212ULL, 0x080fe400078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a1b7faeULL, 0x0003e2000b901c46ULL, 0x000000010f0f7824ULL, 0x000fe200000e0609ULL,
0x0000001908147210ULL, 0x000fe20007f1e0ffULL, 0x0000000102107824ULL, 0x000fe200078e0213ULL,
0x0000001a16197212ULL, 0x000fe200078efcffULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000102187824ULL, 0x000fe200078e0223ULL, 0x0000001a12217212ULL, 0x000fe200078efcffULL,
0x0000000115157824ULL, 0x000fe200000e0609ULL, 0x0000001908167210ULL, 0x000fe20007f1e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000002108127210ULL, 0x000fc60007f5e0ffULL,
0x0000000102207824ULL, 0x040fe400078e0227ULL, 0x00000001021e7824ULL, 0x000fe200078e0225ULL,
0x0000001a18257212ULL, 0x000fe200078efcffULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000001a101f7212ULL, 0x000fc600078efcffULL,
0x0000000102227824ULL, 0x000fe400078e0229ULL, 0x0000000117177824ULL, 0x000fe200000e0609ULL,
0x0000002508187210ULL, 0x000fe20007f1e0ffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000001a20257212ULL, 0x000fc600078efcffULL, 0x0000000102247824ULL, 0x000fe200078e022bULL,
0x0000001a22297212ULL, 0x080fe200078efcffULL, 0x000000010d0d7824ULL, 0x100fe200008e0609ULL,
0x0000001f08107210ULL, 0x000fe20007f3e0ffULL, 0x0000000119197824ULL, 0x100fe200000e0609ULL,
0x0000002508207210ULL, 0x000fe20007f1e0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x000000000c1d7faeULL, 0x0003e6000b901c46ULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000001a1e277212ULL, 0x080fe200078efcffULL, 0x000000000e2f7faeULL, 0x0003e4000b901c46ULL,
0x0000000113137824ULL, 0x000fe200010e0609ULL, 0x0000002908227210ULL, 0x000fe20007f5e0ffULL,
0x0000000102267824ULL, 0x000fe200078e022dULL, 0x0000001a24297212ULL, 0x000fe200078efcffULL,
0x0000000102287824ULL, 0x000fc400078e024bULL, 0x0000000111117824ULL, 0x000fe200008e0609ULL,
0x00000027081e7210ULL, 0x000fe20007f3e0ffULL, 0x00000001022a7824ULL, 0x040fe400078e024dULL,
0x0000000121217824ULL, 0x000fe200000e0609ULL, 0x0000002908247210ULL, 0x000fe20007f1e0ffULL,
0x00000001022c7824ULL, 0x000fe200078e024fULL, 0x0000000010317faeULL, 0x0003e2000b901c46ULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0x0000000012337faeULL, 0x0003e2000b901c46ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000001a264b7212ULL, 0x080fe400078efcffULL,
0x0000000014357faeULL, 0x0003e2000b901c46ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000001a284d7212ULL, 0x080fe400078efcffULL, 0x0000000016377faeULL, 0x0003e2000b901c46ULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000001a2a4f7212ULL, 0x000fc400078efcffULL,
0x0000000018397faeULL, 0x0003e2000b901c46ULL, 0x0000000125257824ULL, 0x100fe200000e0609ULL,
0x0000001a2c517212ULL, 0x000fe200078efcffULL, 0x000000011f1f7824ULL, 0x100fe200008e0609ULL,
0x0000004b08267210ULL, 0x000fe20007f1e0ffULL, 0x0000000123237824ULL, 0x100fe200010e0609ULL,
0x0000004d08287210ULL, 0x000fe40007f3e0ffULL, 0x0000004f082a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000127277824ULL, 0x100fe200000e0609ULL, 0x0000005108087210ULL, 0x000fe20007f7e0ffULL,
0x0000000129297824ULL, 0x100fe200008e0609ULL, 0x000000001e3b7faeULL, 0x0003e2000b901c46ULL,
0x000000012b2b7824ULL, 0x000fc400010e0609ULL, 0x000000012d097824ULL, 0x000fe200018e0609ULL,
0x00000000203d7faeULL, 0x0003e8000b901c46ULL, 0x00000000223f7faeULL, 0x0003e8000b901c46ULL,
0x0000000024417faeULL, 0x0003e8000b901c46ULL, 0x0000000026437faeULL, 0x0003e8000b901c46ULL,
0x0000000028457faeULL, 0x0003e8000b901c46ULL, 0x000000002a477faeULL, 0x0003e8000b901c46ULL,
0x0000000008497faeULL, 0x0003e4000b901c46ULL, 0x000000047b7b7836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff797424ULL, 0x000fc600078e00ffULL,
0x000000747b00720cULL, 0x000fda0003f06070ULL, 0x00009200ff088b82ULL, 0x002e620000000a00ULL,
0x00000002730b8824ULL, 0x000fe200078e027bULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff6d7224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fc4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fc4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x000000040b088825ULL, 0x002fe200078e0008ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fc4000001ff00ULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000608798981ULL, 0x000322000c1e1900ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fc4000001ff00ULL, 0x0000000000527805ULL, 0x000fe4000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000087805ULL, 0x002fce000001ff00ULL, 0xfffffff804117812ULL, 0x000fe200078ec0ffULL,
0x000020006f6a7824ULL, 0x000fe400078e025aULL, 0x000000016d6b7836ULL, 0x000fe20000000000ULL,
0x0000000711127812ULL, 0x000fe200078ef804ULL, 0x000020006a6a7836ULL, 0x000fe40000000000ULL,
0x0000002004137836ULL, 0x000fe40000000000ULL, 0x0000000112107824ULL, 0x040fe400078e026dULL,
0x0000000812117824ULL, 0x040fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ec0ffULL,
0x0000000812157824ULL, 0x000fc400078e00ffULL, 0x0000000112127824ULL, 0x000fe200078e026bULL,
0xfffffff811117812ULL, 0x000fe400078ee210ULL, 0x00000004ff107819ULL, 0x000fe40000011604ULL,
0xfffffff815157812ULL, 0x000fe200078ee212ULL, 0x00000010115c7824ULL, 0x000fe200078e026aULL,
0x0000000804117812ULL, 0x000fe200078ec0ffULL, 0x000000026d107824ULL, 0x000fe200078e0210ULL,
0x0000000713787812ULL, 0x000fe200078ef804ULL, 0x0000001015607824ULL, 0x000fe200078e026aULL,
0x0000000711167812ULL, 0x000fe200078ef804ULL, 0x000000005c5c783bULL, 0x000e640000000200ULL,
0x0000000178137824ULL, 0x000fe200078e026dULL, 0x0000001016647812ULL, 0x040fe200078efcffULL,
0x000000006060783bULL, 0x000ea20000000200ULL, 0x0000000116117824ULL, 0x000fc400078e0210ULL,
0x0000001016147824ULL, 0x000fe400078e00ffULL, 0x0000000164127824ULL, 0x040fe400078e0210ULL,
0x0000001064157824ULL, 0x000fe200078e00ffULL, 0xfffffff014117812ULL, 0x000fe200078ee211ULL,
0x0000001016177824ULL, 0x000fe400078e00ffULL, 0x0000000878147824ULL, 0x040fe200078e00ffULL,
0xfffffff015127812ULL, 0x000fe200078ee212ULL, 0x0000000210157836ULL, 0x000fe20000000000ULL,
0x0000000811117c11ULL, 0x000fe2000f8e20ffULL, 0x00000001786b7824ULL, 0x000fe200078e026bULL,
0xfffffff814137812ULL, 0x000fe200078ee213ULL, 0x0000000116167824ULL, 0x100fe200078e0215ULL,
0x0000000812127c11ULL, 0x000fe2000f8e20ffULL, 0x000000001154783bULL, 0x0007620000000200ULL,
0x0000000164157824ULL, 0x000fc400078e0215ULL, 0xfffffff017167812ULL, 0x000fe200078ee216ULL,
0x000000001218783bULL, 0x000f620000000200ULL, 0x0000001064647824ULL, 0x000fe400078e00ffULL,
0x0000000878787824ULL, 0x000fe200078e00ffULL, 0x0000000816167c11ULL, 0x000fe2000f8e20ffULL,
0x000000026d6d7836ULL, 0x000fe20000000000ULL, 0xfffffff064157812ULL, 0x000fe200078ee215ULL,
0x0000001013647824ULL, 0x000fe200078e026aULL, 0xfffffff8786b7812ULL, 0x000fe400078ee26bULL,
0x000000086d00780cULL, 0x000fc40003f05270ULL, 0x00000010ff107819ULL, 0x102fe2000001165fULL,
0x000000106b6b7824ULL, 0x000fe200078e026aULL, 0x0000ffff5f177812ULL, 0x040fe200078ec0ffULL,
0x000000006464783bULL, 0x000e620000000200ULL, 0x000000ff10107812ULL, 0x000fe400078ec0ffULL,
0x00000018ff147819ULL, 0x000fe4000001165fULL, 0x00000010ff10723eULL, 0x000fe400020006ffULL,
0x000000ff5f5f7812ULL, 0x000fc400078ec0ffULL, 0x00000014ff14723eULL, 0x000fe200020006ffULL,
0x20000010ff117230ULL, 0x008fe20000004100ULL, 0x00000008ff107819ULL, 0x000fe40000011617ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x00000010ff10723eULL, 0x000fe400020006ffULL, 0x0000ffff637d7812ULL, 0x004fe200078ec0ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff147819ULL, 0x000fe20000011614ULL,
0x20000010ff107230ULL, 0x000fe20000004100ULL, 0x00000010ff117819ULL, 0x000fc40000011611ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff687819ULL, 0x000fe40000011610ULL,
0x0000105414697816ULL, 0x000fe40000000011ULL, 0x0000105468687816ULL, 0x000fe4000000005fULL,
0x00000018ff5f7819ULL, 0x000fe40000011663ULL, 0x0000000815117c11ULL, 0x000fc4000f8e20ffULL,
0x0000005fff7a723eULL, 0x000fe200020006ffULL, 0x00000068540c723cULL, 0x020fe2000004180cULL,
0x00000010ff5f7819ULL, 0x000fe20000011663ULL, 0x000000001614783bULL, 0x000ea20000000200ULL,
0x000000ff63637812ULL, 0x000fe200078ec0ffULL, 0x2000007aff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff5f7a7812ULL, 0x000fe200078ec0ffULL, 0x000000681808723cULL, 0x000fe20000041808ULL,
0x00000008ff5f7819ULL, 0x000fe2000001167dULL, 0x000000001110783bULL, 0x000ee20000000200ULL,
0x00000063ff63723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff7d7819ULL, 0x000fe2000001167cULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000018ff7f7819ULL, 0x000fe40000011660ULL, 0x00000010ff637819ULL, 0x000fe20000011663ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000010ff687819ULL, 0x000fc4000001165fULL,
0x0000007fff9f723eULL, 0x000fe400020006ffULL, 0x00001054687c7816ULL, 0x000fe40000000063ULL,
0x000000006b68783bULL, 0x000f620000000200ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff637819ULL, 0x002fe40000011664ULL, 0x000010547d7d7816ULL, 0x000fe4000000007aULL,
0x00000018ff7a7819ULL, 0x000fc4000001165cULL, 0x00000018ff5f7819ULL, 0x000fe40000011664ULL,
0x000000ff648e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff64977812ULL, 0x000fe200078ec0ffULL,
0x0000007c140c723cULL, 0x004fe2000004180cULL, 0x00000010ff647819ULL, 0x100fe40000011666ULL,
0x00000018ff967819ULL, 0x000fe40000011666ULL, 0x000000ff66937812ULL, 0x040fe200078ec0ffULL,
0x0000007c1008723cULL, 0x008fe20000041808ULL, 0x0000ffff66997812ULL, 0x000fc400078ec0ffULL,
0x000000ff629e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff947819ULL, 0x100fe40000011662ULL,
0x000000ff5c7c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff607d7812ULL, 0x000fe400078ec0ffULL,
0x0000007cff7e723eULL, 0x000fe400020006ffULL, 0x00000018ff987819ULL, 0x000fc40000011662ULL,
0x0000ffff62667812ULL, 0x000fe400078ec0ffULL, 0x0000007aff62723eULL, 0x000fe400020006ffULL,
0x00000010ff857819ULL, 0x120fe40000011668ULL, 0x00000018ff8b7819ULL, 0x000fe20000011668ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x000000ff688a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff687f7812ULL, 0x000fc400078ec0ffULL, 0x0000007dff68723eULL, 0x000fe200020006ffULL,
0x2000009fff7d7230ULL, 0x000fe20000004100ULL, 0x00000010ff807819ULL, 0x100fe40000011669ULL,
0x00000018ff8d7819ULL, 0x000fe40000011669ULL, 0x000000ff698c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff69837812ULL, 0x000fe200078ec0ffULL, 0x2000007eff697230ULL, 0x000fe20000004100ULL,
0x00000010ff847819ULL, 0x000fe2000001166aULL, 0x20000068ff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff687819ULL, 0x000fc4000001165cULL, 0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x00000018ff877819ULL, 0x000fe4000001166aULL,
0x000000ff6a867812ULL, 0x040fe400078ec0ffULL, 0x0000ffff6a7a7812ULL, 0x000fe400078ec0ffULL,
0x0000009eff6a723eULL, 0x000fc400020006ffULL, 0x00000008ff5c7819ULL, 0x000fe4000001165cULL,
0x00000098ff9f723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x000000ff65927812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8f7819ULL, 0x000fe40000011665ULL,
0x0000005fff98723eULL, 0x000fe200020006ffULL, 0x2000006aff5f7230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x20000068ff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff9a7819ULL, 0x100fe20000011667ULL, 0x20000098ff987230ULL, 0x000fe20000004100ULL,
0x00000018ff827819ULL, 0x000fc40000011667ULL, 0x000000ff67817812ULL, 0x040fe400078ec0ffULL,
0x0000ffff679b7812ULL, 0x000fe400078ec0ffULL, 0x0000005cff9e723eULL, 0x000fe200020006ffULL,
0x2000009fff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe40000011660ULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x2000009eff9e7230ULL, 0x000fe20000004100ULL,
0x0000008fff68723eULL, 0x000fc400020006ffULL, 0x00000093ff9f723eULL, 0x000fe200020006ffULL,
0x20000092ff937230ULL, 0x000fe20000004100ULL, 0x00000096ff8f723eULL, 0x000fe200020006ffULL,
0x2000008eff967230ULL, 0x000fe20000004100ULL, 0x00000010ff9d7819ULL, 0x000fe20000011661ULL,
0x2000009fff927230ULL, 0x000fe20000004100ULL, 0x000000ff678e7812ULL, 0x000fe200078ec0ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x000000ff9d9f7812ULL, 0x000fc400078ec0ffULL,
0x0000008eff9d723eULL, 0x000fe200020006ffULL, 0x20000081ff8e7230ULL, 0x000fe20000004100ULL,
0x0000ffff609c7812ULL, 0x000fe400078ec0ffULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x2000009dff817230ULL, 0x000fe20000004100ULL, 0x00000010ffa07819ULL, 0x000fe40000011662ULL,
0x00000018ff607819ULL, 0x000fe20000011661ULL, 0x20000082ff677230ULL, 0x000fe20000004100ULL,
0x000000ff61787812ULL, 0x000fc400078ec0ffULL, 0x00000008ff9c7819ULL, 0x000fe4000001169cULL,
0x000000ff639d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff627819ULL, 0x000fe40000011669ULL,
0x0000ffff61617812ULL, 0x000fe400078ec0ffULL, 0x00000008ff977819ULL, 0x000fe40000011697ULL,
0x00000010ff637819ULL, 0x000fc4000001166aULL, 0x00000010ff697819ULL, 0x000fe4000001169eULL,
0x00000010ff957819ULL, 0x000fe40000011665ULL, 0x0000009cff82723eULL, 0x000fe400020006ffULL,
0x00000008ff9c7819ULL, 0x000fe40000011661ULL, 0x00000097ff97723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00001054a0637816ULL, 0x000fc40000000063ULL,
0x0000105469627816ULL, 0x000fe40000000062ULL, 0x000000ff959e7812ULL, 0x000fe200078ec0ffULL,
0x20000097ff957230ULL, 0x000fe20000004100ULL, 0x0000009cff9c723eULL, 0x000fe400020006ffULL,
0x0000009fff9f723eULL, 0x000fe200020006ffULL, 0x000000625450723cULL, 0x000fe20000041850ULL,
0x0000009eff97723eULL, 0x000fe200020006ffULL, 0x2000009cff6a7230ULL, 0x000fe20000004100ULL,
0x0000009dff9d723eULL, 0x000fe200020006ffULL, 0x2000009fff617230ULL, 0x000fe20000004100ULL,
0x00000018ff9e7819ULL, 0x000fe2000001165eULL, 0x00000062184c723cULL, 0x000fe2000004184cULL,
0x0000ffff65657812ULL, 0x000fe200078ec0ffULL, 0x2000009dff697230ULL, 0x000fe20000004100ULL,
0x00000018ff9c7819ULL, 0x000fe2000001165dULL, 0x20000097ff977230ULL, 0x000fe20000004100ULL,
0x0000ffff5da27812ULL, 0x000fc400078ec0ffULL, 0x00000010ff627819ULL, 0x000fe4000001165dULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x000000ff5d637812ULL, 0x000fe400078ec0ffULL,
0x000000ff5e9f7812ULL, 0x000fe400078ec0ffULL, 0x0000009effa1723eULL, 0x000fe400020006ffULL,
0x000000ff629e7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff9d7819ULL, 0x000fe40000011665ULL,
0x0000009cff65723eULL, 0x000fe400020006ffULL, 0x00000008ff627819ULL, 0x000fe400000116a2ULL,
0x00000064ff9c723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x0000009fffa0723eULL, 0x000fc400020006ffULL, 0x0000ffff5e647812ULL, 0x000fe400078ec0ffULL,
0x0000009eff9f723eULL, 0x000fe400020006ffULL, 0x00000010ff5d7819ULL, 0x000fe2000001165eULL,
0x20000065ff5e7230ULL, 0x000fe20000004100ULL, 0x00000062ff9e723eULL, 0x000fe200020006ffULL,
0x20000063ff657230ULL, 0x000fe20000004100ULL, 0x00000008ff647819ULL, 0x000fe20000011664ULL,
0x2000009fff9f7230ULL, 0x000fe20000004100ULL, 0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL,
0x200000a0ff627230ULL, 0x000fe20000004100ULL, 0x00000064ffa0723eULL, 0x000fe200020006ffULL,
0x2000009eff9e7230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe20000011665ULL,
0x200000a1ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff5e7819ULL, 0x000fc4000001165eULL,
0x00000010ff657819ULL, 0x000fe2000001169fULL, 0x200000a0ff9f7230ULL, 0x000fe20000004100ULL,
0x0000005dffa1723eULL, 0x000fe400020006ffULL, 0x00000010ff5d7819ULL, 0x000fe4000001169eULL,
0x000010545e657816ULL, 0x000fe20000000065ULL, 0x200000a1ff9e7230ULL, 0x000fe20000004100ULL,
0x00000008ff5e7819ULL, 0x000fe20000011699ULL, 0x2000009cff997230ULL, 0x000fe20000004100ULL,
0x000010545d647816ULL, 0x000fc40000000064ULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000010ff9c7819ULL, 0x000fe40000011663ULL, 0x000000ff9a5d7812ULL, 0x000fe200078ec0ffULL,
0x000000645448723cULL, 0x000fe20000041848ULL, 0x00000008ff9b7819ULL, 0x000fe4000001169bULL,
0x00000010ff637819ULL, 0x000fe4000001169eULL, 0x00000010ff627819ULL, 0x000fe20000011662ULL,
0x000000641844723cULL, 0x000fe20000041844ULL, 0x00000010ff9f7819ULL, 0x000fc4000001169fULL,
0x00000010ff967819ULL, 0x000fe40000011696ULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x0000009dff9d723eULL, 0x000fe200020006ffULL, 0x2000005eff647230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000009bff9b723eULL, 0x000fe200020006ffULL,
0x2000009dff9a7230ULL, 0x000fe20000004100ULL, 0x000010549c637816ULL, 0x000fc40000000063ULL,
0x000010549f627816ULL, 0x000fe20000000062ULL, 0x2000009bff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff9c7819ULL, 0x000fe40000011668ULL, 0x0000105495687816ULL, 0x000fe40000000096ULL,
0x00000010ff967819ULL, 0x000fe2000001168fULL, 0x000000625440723cULL, 0x000fe20000041840ULL,
0x000000ff94657812ULL, 0x000fe200078ec0ffULL, 0x2000005dff947230ULL, 0x000fe20000004100ULL,
0x00000010ff927819ULL, 0x000fc40000011692ULL, 0x00000010ff8f7819ULL, 0x000fe20000011664ULL,
0x00000062183c723cULL, 0x000fe2000004183cULL, 0x00000065ff5d723eULL, 0x000fe400020006ffULL,
0x000010548f647816ULL, 0x000fe40000000092ULL, 0x00000010ff657819ULL, 0x000fe2000001169aULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fe40000011693ULL,
0x00000010ff927819ULL, 0x000fc40000011667ULL, 0x00000010ff987819ULL, 0x000fe40000011698ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff977819ULL, 0x000fe40000011697ULL,
0x00000010ff997819ULL, 0x000fe40000011699ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff677819ULL, 0x000fc40000011694ULL, 0x00000010ff8f7819ULL, 0x000fe4000001165eULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x0000105465627816ULL, 0x000fe20000000062ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000008ff5e7819ULL, 0x000fe20000011666ULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x0000105498697816ULL, 0x000fc40000000069ULL, 0x000010549c637816ULL, 0x000fe40000000097ULL,
0x0000105496657816ULL, 0x000fe40000000099ULL, 0x0000105492677816ULL, 0x000fe20000000067ULL,
0x000000681828723cULL, 0x000fe20000041828ULL, 0x000010548f667816ULL, 0x000fe4000000008eULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7c7819ULL, 0x000fe2000001166bULL,
0x000000621824723cULL, 0x000fe20000041824ULL, 0x00000084ff84723eULL, 0x000fc400020006ffULL,
0x00000018ff897819ULL, 0x000fe4000001166bULL, 0x000000ff6b887812ULL, 0x040fe200078ec0ffULL,
0x000000641820723cULL, 0x000fe20000041820ULL, 0x000000ff80807812ULL, 0x000fe400078ec0ffULL,
0x0000ffff6b6b7812ULL, 0x000fe400078ec0ffULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x00000066181c723cULL, 0x000fe2000004181cULL, 0x0000005eff5e723eULL, 0x000fc400020006ffULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000008ff7f7819ULL, 0x000fe2000001167fULL,
0x000000625434723cULL, 0x000fe20000041834ULL, 0x00000010ff187819ULL, 0x000fe40000011660ULL,
0x00000010ff1a7819ULL, 0x000fe40000011678ULL, 0x00000010ff1b7819ULL, 0x000fe20000011661ULL,
0x000000645430723cULL, 0x000fe20000041830ULL, 0x00000010ff197819ULL, 0x000fc4000001166aULL,
0x00000080ff63723eULL, 0x000fe400020006ffULL, 0x00001054181b7816ULL, 0x000fe2000000001bULL,
0x000000685438723cULL, 0x000fe20000041838ULL, 0x20000084ff647230ULL, 0x000fe20000004100ULL,
0x00001054191a7816ULL, 0x000fe2000000001aULL, 0x20000063ff657230ULL, 0x000fe20000004100ULL,
0x000000ff85857812ULL, 0x000fe400078ec0ffULL, 0x00000008ff837819ULL, 0x000fe20000011683ULL,
0x00000066542c723cULL, 0x000fe2000004182cULL, 0x00000008ff847819ULL, 0x000fc4000001167aULL,
0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6b7819ULL, 0x000fe2000001166bULL,
0x0000001a1448723cULL, 0x000fe20000041848ULL, 0x0000008bff8f723eULL, 0x000fe200020006ffULL,
0x2000008dff547230ULL, 0x000fe20000004100ULL, 0x0000008aff8e723eULL, 0x000fe200020006ffULL,
0x2000005eff8b7230ULL, 0x000fe20000004100ULL, 0x00000089ff57723eULL, 0x000fe200020006ffULL,
0x2000008cff557230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x0000001a1044723cULL, 0x000fe20000041844ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x2000008eff567230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000088ff5e723eULL, 0x000fe200020006ffULL,
0x2000007fff807230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x2000008fff8a7230ULL, 0x000fe20000004100ULL, 0x00000083ff62723eULL, 0x000fe200020006ffULL,
0x20000087ff697230ULL, 0x000fe20000004100ULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x20000086ff687230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x20000085ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff187819ULL, 0x000fe2000001165cULL,
0x20000062ff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x20000084ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff1a7819ULL, 0x000fe20000011654ULL,
0x2000007cff607230ULL, 0x000fe20000004100ULL, 0x00000010ff547819ULL, 0x000fe20000011655ULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff557819ULL, 0x000fc40000011665ULL,
0x00001054185d7816ULL, 0x000fe4000000005dULL, 0x00000010ff187819ULL, 0x000fe40000011656ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167dULL, 0x00000010ff5c7819ULL, 0x000fe4000001165fULL,
0x00000010ff1b7819ULL, 0x000fe40000011680ULL, 0x000010541a557816ULL, 0x000fc40000000055ULL,
0x00000010ff567819ULL, 0x000fe40000011657ULL, 0x00000010ff637819ULL, 0x000fe40000011681ULL,
0x00000010ff627819ULL, 0x000fe4000001167eULL, 0x00000010ff7d7819ULL, 0x000fe40000011682ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff8a7819ULL, 0x000fc4000001168aULL,
0x00000010ff197819ULL, 0x000fe40000011683ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff1a7819ULL, 0x000fe40000011668ULL, 0x00000010ff577819ULL, 0x000fc40000011666ULL,
0x00000010ff5f7819ULL, 0x000fe40000011660ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x000010541b187816ULL, 0x000fe40000000018ULL,
0x000010547a637816ULL, 0x000fe40000000063ULL, 0x000010547d627816ULL, 0x000fc40000000062ULL,
0x000010548b5c7816ULL, 0x000fe4000000005cULL, 0x000010548a197816ULL, 0x000fe40000000019ULL,
0x000010547f547816ULL, 0x000fe20000000054ULL, 0x000000621450723cULL, 0x000fe20000041850ULL,
0x00001054691b7816ULL, 0x000fe40000000064ULL, 0x00001054571a7816ULL, 0x000fe4000000001aULL,
0x00001054565f7816ULL, 0x000fe2000000005fULL, 0x00000062104c723cULL, 0x000fe2000004184cULL,
0x000010546b5e7816ULL, 0x000fca000000005eULL, 0x0000005c1440723cULL, 0x000fec0000041840ULL,
0x0000005c103c723cULL, 0x000fec000004183cULL, 0x000000181438723cULL, 0x000fec0000041838ULL,
0x000000541434723cULL, 0x000fec0000041834ULL, 0x0000001a1430723cULL, 0x000fec0000041830ULL,
0x0000005e142c723cULL, 0x000fec000004182cULL, 0x000000181028723cULL, 0x000fec0000041828ULL,
0x000000541024723cULL, 0x000fec0000041824ULL, 0x0000001a1020723cULL, 0x000fec0000041820ULL,
0x0000005e101c723cULL, 0x000fe2000004181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffe400980947ULL, 0x000fde000383ffffULL, 0x00000001ff177424ULL, 0x000fe400078e00ffULL,
0x0000006c08107220ULL, 0x080fe20000410000ULL, 0x0000006c09127220ULL, 0x080fe20000410000ULL,
0x0000006c50117220ULL, 0x080fe20000410000ULL, 0x01a68817060879a7ULL, 0x000262000850003fULL,
0x0000006c51517220ULL, 0x080fe20000410000ULL, 0x0000006c52527220ULL, 0x080fe20000410000ULL,
0x0000006c53537220ULL, 0x080fe20000410000ULL, 0x0000006c48487220ULL, 0x080fe20000410000ULL,
0x0000006c49497220ULL, 0x080fe20000410000ULL, 0x0000006c4a4a7220ULL, 0x080fe20000410000ULL,
0x0000006c4b4b7220ULL, 0x080fe20000410000ULL, 0x0000006c40407220ULL, 0x080fe20000410000ULL,
0x0000006c41417220ULL, 0x080fe20000410000ULL, 0x0000006c42427220ULL, 0x080fe20000410000ULL,
0x0000006c43437220ULL, 0x080fe20000410000ULL, 0x0000006c0c0c7220ULL, 0x080fe20000410000ULL,
0x0000006c0d0d7220ULL, 0x080fe20000410000ULL, 0x0000006c0e0e7220ULL, 0x080fe20000410000ULL,
0x0000006c0f0f7220ULL, 0x080fe20000410000ULL, 0x0000006c38387220ULL, 0x080fe20000410000ULL,
0x0000006c39397220ULL, 0x080fe20000410000ULL, 0x0000006c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000006c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000006c34347220ULL, 0x080fe20000410000ULL,
0x0000006c35357220ULL, 0x080fe20000410000ULL, 0x0000006c36367220ULL, 0x080fe20000410000ULL,
0x0000006c37377220ULL, 0x080fe20000410000ULL, 0x0000006c30307220ULL, 0x080fe20000410000ULL,
0x0000006c31317220ULL, 0x080fe20000410000ULL, 0x0000006c32327220ULL, 0x080fe20000410000ULL,
0x0000006c33337220ULL, 0x080fe20000410000ULL, 0x0000006c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000006c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000006c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000006c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000006c4c137220ULL, 0x080fe20000410000ULL,
0x0000006c4d4d7220ULL, 0x080fe20000410000ULL, 0x0000006c4e4e7220ULL, 0x080fe20000410000ULL,
0x0000006c4f4f7220ULL, 0x080fe20000410000ULL, 0x0000006c44447220ULL, 0x080fe20000410000ULL,
0x0000006c45457220ULL, 0x080fe20000410000ULL, 0x0000006c46467220ULL, 0x080fe20000410000ULL,
0x0000006c47477220ULL, 0x080fe20000410000ULL, 0x0000006c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000006c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000006c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000006c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000006c0a147220ULL, 0x080fe20000410000ULL,
0x0000006c0b157220ULL, 0x080fe20000410000ULL, 0x0000006c28287220ULL, 0x080fe20000410000ULL,
0x0000006c29297220ULL, 0x080fe20000410000ULL, 0x0000006c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000006c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000006c24247220ULL, 0x080fe20000410000ULL,
0x0000006c25257220ULL, 0x080fe20000410000ULL, 0x0000006c26267220ULL, 0x080fe20000410000ULL,
0x0000006c27277220ULL, 0x080fe20000410000ULL, 0x0000006c20207220ULL, 0x080fe20000410000ULL,
0x0000006c21217220ULL, 0x080fe20000410000ULL, 0x0000006c22227220ULL, 0x080fe20000410000ULL,
0x0000006c23237220ULL, 0x080fe20000410000ULL, 0x0000006c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000006c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000006c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000006c1f1f7220ULL, 0x000fe20000410000ULL, 0x0000000704167812ULL, 0x002fce00078ec0ffULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x01a68809060075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fce0000015200ULL, 0x0000000a18177210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e19ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x000000170a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01a68809060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000404087824ULL, 0x000fe200078e00ffULL, 0x0000000871177c11ULL, 0x000fe4000f8e38ffULL,
0x0000005b6e00720cULL, 0x000fe40003f06070ULL, 0xfffffff008087812ULL, 0x000fca00078ec0ffULL,
0x0000000117177824ULL, 0x000fca00078e0208ULL, 0x01a4000017087984ULL, 0x0002a20000000c00ULL,
0x0000002000648947ULL, 0x000fea0003800000ULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x00000004004c7d06ULL, 0x000ee20008209000ULL,
0x00000075041a7211ULL, 0x000fe200078ff0ffULL, 0x000001006eb17824ULL, 0x000fe400078e0205ULL,
0x0000000204af7824ULL, 0x000fe400078e00ffULL, 0x000000181a547836ULL, 0x000fc60000000000ULL,
0x00000006afaf7812ULL, 0x000fca00078ec0ffULL, 0x00000001afae7824ULL, 0x000fe200078e0203ULL,
0x0000004c004c7308ULL, 0x008ee40000001000ULL, 0x0ffffffe4c197836ULL, 0x008fe40000000000ULL,
0x000000101a4c7836ULL, 0x000fc80000000000ULL, 0x0000001900197305ULL, 0x000ee4000021f000ULL,
0x000000ffff1b7224ULL, 0x008fc800078e0a19ULL, 0x000000041b1b7c24ULL, 0x000fc8000f8e02ffULL,
0x0000001b195d7227ULL, 0x000fc800078e0018ULL, 0x000000081a187836ULL, 0x000fe40000000000ULL,
0x0000001a5d197227ULL, 0x000fc800078e00ffULL, 0x000000185d1b7227ULL, 0x000fc800078e00ffULL,
0x000000ffff557224ULL, 0x000fe400078e0a1bULL, 0x000000ffff577224ULL, 0x000fe400078e0a19ULL,
0x0000000455187c24ULL, 0x000fe4000f8e0218ULL, 0x00000004571a7c24ULL, 0x000fe4000f8e021aULL,
0x0000004c5d507227ULL, 0x040fe200078e00ffULL, 0x0000000418007c0cULL, 0x000fe4000bf06070ULL,
0x000000041a007c0cULL, 0x000fe2000bfa6070ULL, 0x000000545d557227ULL, 0x000fc800078e00ffULL,
0x000000ffff5d7224ULL, 0x000fe400078e0a50ULL, 0x000000ffff577224ULL, 0x000fe400078e0a55ULL,
0x000000045d4c7c24ULL, 0x000fe4000f8e024cULL, 0x0000000457547c24ULL, 0x000fe4000f8e0254ULL,
0x8000000418180c36ULL, 0x000fe20008000000ULL, 0x000000044c007c0cULL, 0x000fe2000bf46070ULL,
0x800000041a1a5c36ULL, 0x000fe20008000000ULL, 0x0000000454007c0cULL, 0x000fe2000bf66070ULL,
0x000000011b1b0836ULL, 0x000fe20000000000ULL, 0x0000000418007c0cULL, 0x000fe2000bfc6070ULL,
0x0000000119195836ULL, 0x000fe20000000000ULL, 0x000000041a007c0cULL, 0x000fe2000bf86070ULL,
0x00000001581a7824ULL, 0x000fe200078e02afULL, 0x000000b176187248ULL, 0x000fca0007fe0000ULL,
0x800000044c4c2c36ULL, 0x000fe40008000000ULL, 0x8000000454543c36ULL, 0x000fe40008000000ULL,
0x0000000118b17824ULL, 0x000fe200078e0ab1ULL, 0x000000044c007c0cULL, 0x000fe2000bf26070ULL,
0x000000011b1b6836ULL, 0x000fe20000000000ULL, 0x0000000454007c0cULL, 0x000fe2000bf06070ULL,
0x0000000119194836ULL, 0x000fe20000000000ULL, 0x00000004ff007c0cULL, 0x000fe2000bfc5070ULL,
0x000000ffff5a7224ULL, 0x000fe200078e0ab1ULL, 0x00000004ff547c12ULL, 0x000fe2000f8e33ffULL,
0x0000000150502836ULL, 0x000fe20000000000ULL, 0x000000b11a00720cULL, 0x000fe20003fa6070ULL,
0x0000000155553836ULL, 0x000fe20000000000ULL, 0x0000001954187207ULL, 0x000fc40007000000ULL,
0x0000005a1a1a7246ULL, 0x000fe20003800007ULL, 0x0000000150501836ULL, 0x000fe20000000000ULL,
0x0000001807187248ULL, 0x000fe20003fe0000ULL, 0x0000000155550836ULL, 0x000fe20000000000ULL,
0x0000001b544c7207ULL, 0x000fe40007000000ULL, 0x000000b1ae00720cULL, 0x000fe20003f86070ULL,
0x0000000518637c24ULL, 0x000fe2000f8e02ffULL, 0x0000005aae9e7246ULL, 0x000fe40003800007ULL,
0x00000004ff1a7819ULL, 0x000fc4000001161aULL, 0x0000004c07857248ULL, 0x000fe40003fe0000ULL,
0x000000ff9e9e7207ULL, 0x000fe40002000000ULL, 0x000000ff1a4c7207ULL, 0x000fe20002800000ULL,
0x0000000585857c24ULL, 0x000fe2000f8e02ffULL, 0x0000005054507207ULL, 0x000fe40007000000ULL,
0x000000639e1b7211ULL, 0x000fe200078fe0ffULL, 0x0000000163197824ULL, 0x000fe200078e024cULL,
0x0000005007507248ULL, 0x000fc40003fe0000ULL, 0x0000005554547207ULL, 0x000fe20007000000ULL,
0x0000000219187825ULL, 0x100fe200078e0090ULL, 0x000000859e617211ULL, 0x000fe400078fe0ffULL,
0x00000054078d7248ULL, 0x000fe20003fe0000ULL, 0x000000021b1a7825ULL, 0x000fe200078e0090ULL,
0x0000000618ad7981ULL, 0x0044e6000c1e9500ULL, 0x0000000550877c24ULL, 0x000fe2000f8e02ffULL,
0x000000061aac7981ULL, 0x000ee2000c1e9500ULL, 0x000000014c557824ULL, 0x000fc400078e0285ULL,
0x000000014c5d7824ULL, 0x000fe200078e0287ULL, 0x000000879e5f7211ULL, 0x000fe200078fe0ffULL,
0x0000000255547825ULL, 0x000fe200078e0090ULL, 0x00000010af7f7812ULL, 0x000fc600078efcffULL,
0x000000025d187825ULL, 0x104fe200078e0090ULL, 0x0000000654577981ULL, 0x000566000c1e9500ULL,
0x0000000261607825ULL, 0x100fe400078e0090ULL, 0x0000000618187981ULL, 0x000f64000c1e9500ULL,
0x000000025f5e7825ULL, 0x000fe400078e0090ULL, 0x0000000660547981ULL, 0x004564000c1e9500ULL,
0x000000058d8d7c24ULL, 0x000fc4000f8e02ffULL, 0x0000000158507824ULL, 0x000fe200078e027fULL,
0x000000065e7d7981ULL, 0x000f62000c1e9500ULL, 0x000000017f8c7824ULL, 0x000fe200078e0203ULL,
0x0000008d9e657211ULL, 0x000fe200078fe0ffULL, 0x000000014c677824ULL, 0x000fe200078e028dULL,
0x0000005a50567246ULL, 0x000fe40003800007ULL, 0x000000b15000720cULL, 0x080fe20003f26070ULL,
0x00000002675c7825ULL, 0x000fe200078e0090ULL, 0x000000b18c00720cULL, 0x000fe40003f06070ULL,
0x00000004ff567819ULL, 0x000fe20000011656ULL, 0x00000002651a7825ULL, 0x002fe200078e0090ULL,
0x0000005a8c9a7246ULL, 0x000fe20003800007ULL, 0x000000065c4c7981ULL, 0x000f62000c1e9500ULL,
0x000000ff56567207ULL, 0x000fc40000800000ULL, 0x000000ff9a9a7207ULL, 0x000fe20000000000ULL,
0x000000061a557981ULL, 0x000364000c1e9500ULL, 0x0000000156937824ULL, 0x000fe200078e0285ULL,
0x000000639a957211ULL, 0x040fe400078fe0ffULL, 0x000000859a617211ULL, 0x004fe200078fe0ffULL,
0x0000000293927825ULL, 0x000fe200078e0090ULL, 0x00000020af657812ULL, 0x000fc600078efcffULL,
0x00000001631b7824ULL, 0x002fe400078e0256ULL, 0x0000000295947825ULL, 0x100fe200078e0090ULL,
0x0000000692927981ULL, 0x000ea6000c1e9500ULL, 0x000000021b1a7825ULL, 0x100fe400078e0090ULL,
0x0000000694947981ULL, 0x000ea4000c1e9500ULL, 0x0000000261607825ULL, 0x000fc400078e0090ULL,
0x000000061a6f7981ULL, 0x0002a4000c1e9500ULL, 0x00000001565f7824ULL, 0x040fe400078e0287ULL,
0x00000001565d7824ULL, 0x000fe200078e028dULL, 0x0000000660837981ULL, 0x000ea2000c1e9500ULL,
0x0000000158567824ULL, 0x000fe200078e0265ULL, 0x000000879a8f7211ULL, 0x040fe200078fe0ffULL,
0x00000001657e7824ULL, 0x000fe200078e0203ULL, 0x0000008d9a197211ULL, 0x000fe400078fe0ffULL,
0x0000005a56627246ULL, 0x000fe20003800007ULL, 0x000000028f8e7825ULL, 0x000fe200078e0090ULL,
0x000000b17e00720cULL, 0x000fc40003f06070ULL, 0x0000005a7e987246ULL, 0x000fe20003800007ULL,
0x000000025f5e7825ULL, 0x000fe200078e0090ULL, 0x000000b15600720cULL, 0x000fe20003f26070ULL,
0x000000068e8e7981ULL, 0x000ea2000c1e9500ULL, 0x00000004ff627819ULL, 0x000fe20000011662ULL,
0x000000025d5c7825ULL, 0x000fe200078e0090ULL, 0x000000ff98987207ULL, 0x000fc60000000000ULL,
0x00000002191a7825ULL, 0x002fe200078e0090ULL, 0x000000ff62627207ULL, 0x000fe20000800000ULL,
0x000000065e197981ULL, 0x000ea2000c1e9500ULL, 0x00000085986b7211ULL, 0x000fc600078fe0ffULL,
0x000000065c507981ULL, 0x0002a8000c1e9500ULL, 0x000000061a817981ULL, 0x0002a2000c1e9500ULL,
0x000000026b6a7825ULL, 0x000fc800078e0090ULL, 0x00000001625d7824ULL, 0x002fe200078e0285ULL,
0x00000063985f7211ULL, 0x040fe200078fe0ffULL, 0x0000000163617824ULL, 0x000fe200078e0262ULL,
0x000000066a6b7981ULL, 0x000ea2000c1e9500ULL, 0x000000025d5c7825ULL, 0x000fe200078e0090ULL,
0x0000008798697211ULL, 0x000fc800078fe0ffULL, 0x000000065c807981ULL, 0x0002a2000c1e9500ULL,
0x0000000261607825ULL, 0x000fe200078e0090ULL, 0x0000008d98677211ULL, 0x000fc600078fe0ffULL,
0x000000025f5e7825ULL, 0x000fe200078e0090ULL, 0x0000000660827981ULL, 0x0002a6000c1e9500ULL,
0x00000001621b7824ULL, 0x040fe200078e0287ULL, 0x00000030af5d7812ULL, 0x002fe200078efcffULL,
0x0000000162897824ULL, 0x000fe200078e028dULL, 0x000000065e6d7981ULL, 0x0002a2000c1e9500ULL,
0x000000021b1a7825ULL, 0x000fc800078e0090ULL, 0x0000000269687825ULL, 0x100fe400078e0090ULL,
0x000000061a1a7981ULL, 0x000ea4000c1e9500ULL, 0x0000000289607825ULL, 0x100fe400078e0090ULL,
0x0000000668697981ULL, 0x000ea4000c1e9500ULL, 0x00000002675e7825ULL, 0x002fe400078e0090ULL,
0x0000000660567981ULL, 0x0002a4000c1e9500ULL, 0x00000001585c7824ULL, 0x000fc400078e025dULL,
0x000000065e677981ULL, 0x0002a2000c1e9500ULL, 0x000000015d627824ULL, 0x000fe400078e0203ULL,
0x0000005a5c647246ULL, 0x000fe40003800007ULL, 0x000000b15c00720cULL, 0x080fe40003f26070ULL,
0x00000004ff647819ULL, 0x000fe40000011664ULL, 0x000000b16200720cULL, 0x000fe40003f06070ULL,
0x0000005a629c7246ULL, 0x000fc40003800007ULL, 0x000000ff64647207ULL, 0x000fe40000800000ULL,
0x000000ff9c9c7207ULL, 0x000fc60000000000ULL, 0x0000000164897824ULL, 0x000fe200078e0285ULL,
0x000000859c617211ULL, 0x042fe200078fe0ffULL, 0x00000001638b7824ULL, 0x000fe200078e0264ULL,
0x000000639c5f7211ULL, 0x000fe200078fe0ffULL, 0x00000001641b7824ULL, 0x000fe200078e0287ULL,
0x000000879c857211ULL, 0x000fe200078fe0ffULL, 0x000000028b8a7825ULL, 0x000fc800078e0090ULL,
0x000000025f5e7825ULL, 0x100fe200078e0090ULL, 0x000000068a6a7981ULL, 0x000ea6000c1e9500ULL,
0x000000021b867825ULL, 0x100fe200078e0090ULL, 0x000000065e637981ULL, 0x0002a6000c1e9500ULL,
0x0000000285847825ULL, 0x100fe200078e0090ULL, 0x00000006861b7981ULL, 0x000ea8000c1e9500ULL,
0x0000000684667981ULL, 0x0002a2000c1e9500ULL, 0x0000000261607825ULL, 0x000fc800078e0090ULL,
0x0000000289887825ULL, 0x000fe400078e0090ULL, 0x0000000660617981ULL, 0x000ea2000c1e9500ULL,
0x0000008d9c5f7211ULL, 0x002fc600078fe0ffULL, 0x0000000688687981ULL, 0x0002a2000c1e9500ULL,
0x0000000164977824ULL, 0x000fe400078e028dULL, 0x000000025f5e7825ULL, 0x000fc800078e0090ULL,
0x0000000297967825ULL, 0x000fe400078e0090ULL, 0x000000065e5f7981ULL, 0x0002a8000c1e9500ULL,
0x0000000696647981ULL, 0x0002a2000c1e9500ULL, 0xfffffff09e9e7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff5a7424ULL, 0x000fc800078e00ffULL, 0x00000001b1bd7824ULL, 0x000fc800078e029eULL,
0x00000001aeab7824ULL, 0x000fe200078e0abdULL, 0x00000001afaa7812ULL, 0x000fc800078efcffULL,
0x000000ab5aab7219ULL, 0x000fe200000006ffULL, 0x00000001aaa97824ULL, 0x000fe200078e0203ULL,
0x00000008afa87812ULL, 0x000fc600078efcffULL, 0x00000001a9a77824ULL, 0x000fe200078e0abdULL,
0x00000009af8a7812ULL, 0x000fe200078efcffULL, 0x00000001a8a67824ULL, 0x000fc600078e0203ULL,
0x000000a75aa77219ULL, 0x000fe200000006ffULL, 0x000000018a857824ULL, 0x000fe200078e0203ULL,
0x00000011af887812ULL, 0x042fe400078efcffULL, 0x00000018af867812ULL, 0x040fe400078efcffULL,
0x00000019af847812ULL, 0x040fe400078efcffULL, 0x00000021af7c7812ULL, 0x040fe400078efcffULL,
0x00000028af7a7812ULL, 0x000fc400078efcffULL, 0x00000029af787812ULL, 0x000fe400078efcffULL,
0xfffffff09a9a7812ULL, 0x000fe400078ec0ffULL, 0xfffffff098987812ULL, 0x000fe200078ec0ffULL,
0x00000001a6bf7824ULL, 0x000fe400078e0abdULL, 0x0000000188877824ULL, 0x100fe400078e0203ULL,
0x0000000186897824ULL, 0x100fe400078e0203ULL, 0x00000001848b7824ULL, 0x000fc400078e0203ULL,
0x000000017c8d7824ULL, 0x100fe400078e0203ULL, 0x000000017a8f7824ULL, 0x100fe400078e0203ULL,
0x0000000178937824ULL, 0x000fe400078e0203ULL, 0x00000001b19a7824ULL, 0x040fe400078e029aULL,
0x00000001b1987824ULL, 0x000fe400078e0298ULL, 0x0000000185bd7824ULL, 0x000fc400078e0abdULL,
0x000000018c9b7824ULL, 0x100fe400078e0a9aULL, 0x0000000187bb7824ULL, 0x100fe400078e0a9aULL,
0x00000001899d7824ULL, 0x000fe200078e0a9aULL, 0x00005410acac7816ULL, 0x008fc800000000adULL,
0x000000acabff7212ULL, 0x000fc800078ac0ffULL, 0x000000b1ae00720cULL, 0x000fc80002fa1470ULL,
0x000000b1af00720cULL, 0x000fe40002fa1070ULL, 0x000000aca7ff7212ULL, 0x000fe4000782c0ffULL,
0xff80000011117808ULL, 0x000fe40002800000ULL, 0x0000541054547816ULL, 0x020fe40000000057ULL,
0x000054107d187816ULL, 0x000fe40000000018ULL, 0x00000054abff7212ULL, 0x000fc4000784c0ffULL,
0x00000018abff7212ULL, 0x000fe4000788c0ffULL, 0x00000054a7ff7212ULL, 0x000fe400078ac0ffULL,
0x000000b1ae00720cULL, 0x0c0fe40001741470ULL, 0x000000b1ae00720cULL, 0x080fe40002781470ULL,
0x000000b1a900720cULL, 0x0c0fe40000f21470ULL, 0x000000b1a900720cULL, 0x080fe20002fa1470ULL,
0x000000018bb97824ULL, 0x000fe200078e0a9aULL, 0x000000b1af00720cULL, 0x0c0fe20001741070ULL,
0x000000017e9f7824ULL, 0x100fe200078e0a98ULL, 0x000000b1af00720cULL, 0x080fe20002781070ULL,
0x000000018db77824ULL, 0x100fe200078e0a98ULL, 0x000000b1aa00720cULL, 0x0c0fe20000f21070ULL,
0x000000018fa17824ULL, 0x100fe200078e0a98ULL, 0x000000b1aa00720cULL, 0x000fe20002fa1070ULL,
0x0000000193b57824ULL, 0x000fe200078e0a98ULL, 0x000000bf5a987219ULL, 0x000fc400000006ffULL,
0x000000bd5a9a7219ULL, 0x000fe400000006ffULL, 0x00005410554c7816ULL, 0x000fe4000000004cULL,
0xff80000052527808ULL, 0x000fe40001000000ULL, 0xff80000013137808ULL, 0x000fe40002000000ULL,
0xff80000051517808ULL, 0x000fe40000800000ULL, 0xff80000053537808ULL, 0x000fc40002800000ULL,
0x000000ac98ff7212ULL, 0x000fe4000786c0ffULL, 0x0000004cabff7212ULL, 0x000fe4000780c0ffULL,
0x00000018a7ff7212ULL, 0x040fe4000784c0ffULL, 0x0000004ca7ff7212ULL, 0x000fe4000788c0ffULL,
0x000000549aff7212ULL, 0x000fe4000782c0ffULL, 0x0000001898ff7212ULL, 0x000fc400078ac0ffULL,
0xfffffff09c9c7812ULL, 0x000fe400078ec0ffULL, 0x000000b1ae00720cULL, 0x080fe40000701470ULL,
0x000000b1a900720cULL, 0x0c0fe40001741470ULL, 0x000000b1a900720cULL, 0x080fe40002781470ULL,
0x000000b1a600720cULL, 0x0c0fe40001f61470ULL, 0x000000b1a600720cULL, 0x000fc40002fa1470ULL,
0x000000b18500720cULL, 0x080fe20000f21470ULL, 0x00000001b1997824ULL, 0x000fe200078e029cULL,
0x000000b1af00720cULL, 0x080fe40000701070ULL, 0x000000b1aa00720cULL, 0x0c0fe40001741070ULL,
0x000000b1aa00720cULL, 0x080fe40002781070ULL, 0x000000b1a800720cULL, 0x0c0fe40001f61070ULL,
0x000000b1a800720cULL, 0x000fc40002fa1070ULL, 0x000000b18a00720cULL, 0x000fe40000f21070ULL,
0x0000009b5a9b7219ULL, 0x040fe400000006ffULL, 0x000000bb5a9c7219ULL, 0x000fe400000006ffULL,
0x00005410946f7816ULL, 0x004fe4000000006fULL, 0x0000541083837816ULL, 0x000fe40000000092ULL,
0xff8000004e4e7808ULL, 0x000fc40000000000ULL, 0xff8000004d4d7808ULL, 0x000fe40001000000ULL,
0xff8000004f4f7808ULL, 0x000fe40002000000ULL, 0xff80000048487808ULL, 0x000fe40001800000ULL,
0xff80000044447808ULL, 0x000fe40002800000ULL, 0xff8000004b4b7808ULL, 0x000fe40000800000ULL,
0x0000005498ff7212ULL, 0x000fc4000780c0ffULL, 0x000000189aff7212ULL, 0x000fe4000784c0ffULL,
0x0000004c98ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004c9aff7212ULL, 0x000fe4000786c0ffULL,
0x0000006f9cff7212ULL, 0x000fe400078ac0ffULL, 0x000000839bff7212ULL, 0x000fe4000782c0ffULL,
0x000000b1a600720cULL, 0x000fc40000701470ULL, 0x000000b1a600720cULL, 0x080fe40002781470ULL,
0x000000b18500720cULL, 0x0c0fe40001741470ULL, 0x000000b18500720cULL, 0x080fe40001f61470ULL,
0x000000b18c00720cULL, 0x080fe40000f21470ULL, 0x000000b18700720cULL, 0x080fe40002fa1470ULL,
0x000000b1a800720cULL, 0x000fc40000701070ULL, 0x000000b1a800720cULL, 0x080fe40002781070ULL,
0x000000b18a00720cULL, 0x0c0fe40001741070ULL, 0x000000b18a00720cULL, 0x080fe40001f61070ULL,
0x000000b17f00720cULL, 0x080fe40000f21070ULL, 0x000000b18800720cULL, 0x000fe40002fa1070ULL,
0x0000009d5a9d7219ULL, 0x000fc400000006ffULL, 0x000000b95a9e7219ULL, 0x000fe400000006ffULL,
0x000054108e197816ULL, 0x000fe40000000019ULL, 0x0000541081507816ULL, 0x000fe40000000050ULL,
0xff8000004a4a7808ULL, 0x000fe40000000000ULL, 0xff80000046467808ULL, 0x000fe40002000000ULL,
0xff80000045457808ULL, 0x000fc40001000000ULL, 0xff80000047477808ULL, 0x000fe40001800000ULL,
0xff80000042427808ULL, 0x000fe40000800000ULL, 0xff80000041417808ULL, 0x000fe40002800000ULL,
0x0000006f9bff7212ULL, 0x080fe4000780c0ffULL, 0x0000006f9dff7212ULL, 0x000fe4000788c0ffULL,
0x000000199bff7212ULL, 0x000fc4000784c0ffULL, 0x000000509bff7212ULL, 0x000fe4000786c0ffULL,
0x000000199cff7212ULL, 0x000fe4000782c0ffULL, 0x000000839eff7212ULL, 0x000fe400078ac0ffULL,
0x000000b18c00720cULL, 0x0c0fe40000701470ULL, 0x000000b18c00720cULL, 0x0c0fe40001741470ULL,
0x000000b18c00720cULL, 0x000fc40001f61470ULL, 0x000000b18700720cULL, 0x080fe40000f21470ULL,
0x000000b18900720cULL, 0x080fe40002781470ULL, 0x000000b18b00720cULL, 0x080fe40002fa1470ULL,
0x000000b17f00720cULL, 0x0c0fe40000701070ULL, 0x000000b17f00720cULL, 0x0c0fe40001741070ULL,
0x000000b17f00720cULL, 0x000fc40001f61070ULL, 0x000000b18800720cULL, 0x080fe40000f21070ULL,
0x000000b18600720cULL, 0x080fe40002781070ULL, 0x000000b18400720cULL, 0x000fe40002fa1070ULL,
0x0000009f5a9f7219ULL, 0x000fe400000006ffULL, 0x000054106b6b7816ULL, 0x000fe40000000080ULL,
0xff80000040407808ULL, 0x000fc40000000000ULL, 0xff8000003c3c7808ULL, 0x000fe40001000000ULL,
0xff8000003e3e7808ULL, 0x000fe40001800000ULL, 0xff8000003d3d7808ULL, 0x000fe40000800000ULL,
0xff8000000c0c7808ULL, 0x000fe40002000000ULL, 0xff8000000f0f7808ULL, 0x000fe40002800000ULL,
0x000000839cff7212ULL, 0x000fc4000780c0ffULL, 0x000000509cff7212ULL, 0x080fe4000784c0ffULL,
0x000000839dff7212ULL, 0x000fe4000786c0ffULL, 0x000000199eff7212ULL, 0x040fe4000782c0ffULL,
0x000000509eff7212ULL, 0x000fe4000788c0ffULL, 0x0000006b9fff7212ULL, 0x000fe400078ac0ffULL,
0x000000b18700720cULL, 0x000fc40000701470ULL, 0x000000b18700720cULL, 0x080fe40001741470ULL,
0x000000b18900720cULL, 0x080fe40001f61470ULL, 0x000000b18b00720cULL, 0x0c0fe40000f21470ULL,
0x000000b18b00720cULL, 0x080fe40002781470ULL, 0x000000b17e00720cULL, 0x080fe40002fa1470ULL,
0x000000b18800720cULL, 0x000fc40000701070ULL, 0x000000b18800720cULL, 0x080fe40001741070ULL,
0x000000b18600720cULL, 0x080fe40001f61070ULL, 0x000000b18400720cULL, 0x0c0fe40000f21070ULL,
0x000000b18400720cULL, 0x080fe40002781070ULL, 0x000000b16500720cULL, 0x000fe40002fa1070ULL,
0x000000b75aa07219ULL, 0x000fc400000006ffULL, 0x000054106d6d7816ULL, 0x000fe40000000082ULL,
0x00005410691a7816ULL, 0x000fe4000000001aULL, 0x0000541067567816ULL, 0x000fe40000000056ULL,
0xff80000043437808ULL, 0x000fe40000000000ULL, 0xff8000003f3f7808ULL, 0x000fe40001000000ULL,
0xff8000000e0e7808ULL, 0x000fc40001800000ULL, 0xff80000012127808ULL, 0x000fe40000800000ULL,
0xff80000015157808ULL, 0x000fe40002000000ULL, 0xff8000003a3a7808ULL, 0x000fe40002800000ULL,
0x000000ac9aff7212ULL, 0x000fe400078cc0ffULL, 0x000000199dff7212ULL, 0x040fe4000780c0ffULL,
0x000000509dff7212ULL, 0x000fc4000784c0ffULL, 0x0000006d9fff7212ULL, 0x040fe4000786c0ffULL,
0x0000001a9fff7212ULL, 0x040fe4000782c0ffULL, 0x000000569fff7212ULL, 0x000fe4000788c0ffULL,
0x0000001aa0ff7212ULL, 0x000fe400078ac0ffULL, 0x000000b18500720cULL, 0x080fe400037c1470ULL,
0x000000b18900720cULL, 0x000fc40000701470ULL, 0x000000b18900720cULL, 0x080fe40001741470ULL,
0x000000b17e00720cULL, 0x0c0fe40001f61470ULL, 0x000000b17e00720cULL, 0x0c0fe40000f21470ULL,
0x000000b17e00720cULL, 0x080fe40002781470ULL, 0x000000b18d00720cULL, 0x080fe40002fa1470ULL,
0x000000b18a00720cULL, 0x000fc400037c1070ULL, 0x000000b18600720cULL, 0x0c0fe40000701070ULL,
0x000000b18600720cULL, 0x080fe40001741070ULL, 0x000000b16500720cULL, 0x0c0fe40001f61070ULL,
0x000000b16500720cULL, 0x0c0fe40000f21070ULL, 0x000000b16500720cULL, 0x080fe40002781070ULL,
0x000000b17c00720cULL, 0x000fc40002fa1070ULL, 0x000000a15aa17219ULL, 0x040fe400000006ffULL,
0x000000b55aa27219ULL, 0x000fe400000006ffULL, 0xff80000049497808ULL, 0x000fe40003000000ULL,
0xff80000010107808ULL, 0x000fe40000000000ULL, 0xff80000014147808ULL, 0x000fe40001000000ULL,
0xff80000038387808ULL, 0x000fc40001800000ULL, 0xff80000028287808ULL, 0x000fe40000800000ULL,
0xff8000002a2a7808ULL, 0x000fe40002000000ULL, 0xff80000029297808ULL, 0x000fe40002800000ULL,
0x0000006f9eff7212ULL, 0x000fe400078cc0ffULL, 0x0000006da0ff7212ULL, 0x080fe4000780c0ffULL,
0x0000006da1ff7212ULL, 0x000fc4000784c0ffULL, 0x0000006ba0ff7212ULL, 0x0c0fe4000786c0ffULL,
0x00000056a0ff7212ULL, 0x000fe4000782c0ffULL, 0x0000006ba1ff7212ULL, 0x000fe4000788c0ffULL,
0x0000001aa2ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000162a37824ULL, 0x000fe200078e0a99ULL,
0x000000b18b00720cULL, 0x080fe400037c1470ULL, 0x000000b18d00720cULL, 0x000fc40000701470ULL,
0x000000b18d00720cULL, 0x0c0fe40001f61470ULL, 0x000000b18d00720cULL, 0x080fe40000f21470ULL,
0x000000b18f00720cULL, 0x0c0fe40001741470ULL, 0x000000b18f00720cULL, 0x080fe40002781470ULL,
0x000000b19300720cULL, 0x000fe40002fa1470ULL, 0x00000031af607812ULL, 0x000fc400078efcffULL,
0x00000038af5e7812ULL, 0x040fe400078efcffULL, 0x00000039af5c7812ULL, 0x000fe400078efcffULL,
0x000000b18400720cULL, 0x080fe400037c1070ULL, 0x000000b17c00720cULL, 0x0c0fe40000701070ULL,
0x000000b17c00720cULL, 0x0c0fe40001f61070ULL, 0x000000b17c00720cULL, 0x000fc40000f21070ULL,
0x000000b17a00720cULL, 0x0c0fe40001741070ULL, 0x000000b17a00720cULL, 0x080fe40002781070ULL,
0x000000b17800720cULL, 0x000fe40002fa1070ULL, 0x000000a35aa37219ULL, 0x000fe400000006ffULL,
0x00005410636a7816ULL, 0x000fe4000000006aULL, 0x0000541066667816ULL, 0x000fe2000000001bULL,
0x0000000160957824ULL, 0x100fe200078e0203ULL, 0xff8000000d0d7808ULL, 0x000fe20003000000ULL,
0x000000015e967824ULL, 0x100fe200078e0203ULL, 0xff80000039397808ULL, 0x000fe20000000000ULL,
0x000000015c977824ULL, 0x000fe200078e0203ULL, 0xff8000003b3b7808ULL, 0x000fc40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40000800000ULL, 0xff80000034347808ULL, 0x000fe40001000000ULL,
0xff80000036367808ULL, 0x000fe40002000000ULL, 0xff80000025257808ULL, 0x000fe40002800000ULL,
0x0000006da2ff7212ULL, 0x040fe400078cc0ffULL, 0x0000006ba2ff7212ULL, 0x000fc4000780c0ffULL,
0x0000001aa1ff7212ULL, 0x040fe4000786c0ffULL, 0x00000056a1ff7212ULL, 0x080fe4000782c0ffULL,
0x00000056a2ff7212ULL, 0x000fe4000784c0ffULL, 0x0000006aa3ff7212ULL, 0x040fe4000788c0ffULL,
0x00000066a3ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000195b37824ULL, 0x100fe200078e0a99ULL,
0x000000b18f00720cULL, 0x0c0fe20001f61470ULL, 0x0000000196a57824ULL, 0x100fe200078e0a99ULL,
0x000000b18f00720cULL, 0x080fe20000f21470ULL, 0x0000000197997824ULL, 0x000fe200078e0a99ULL,
0x000000b19300720cULL, 0x000fc400037c1470ULL, 0x000000b19300720cULL, 0x0c0fe40000701470ULL,
0x000000b19300720cULL, 0x080fe40001741470ULL, 0x000000b16200720cULL, 0x0c0fe40002781470ULL,
0x000000b16200720cULL, 0x080fe40002fa1470ULL, 0x000000b17a00720cULL, 0x0c0fe40001f61070ULL,
0x000000b17a00720cULL, 0x000fc40000f21070ULL, 0x000000b17800720cULL, 0x0c0fe400037c1070ULL,
0x000000b17800720cULL, 0x0c0fe40000701070ULL, 0x000000b17800720cULL, 0x080fe40001741070ULL,
0x000000b15d00720cULL, 0x0c0fe40002781070ULL, 0x000000b15d00720cULL, 0x000fe40002fa1070ULL,
0x000000b35aa47219ULL, 0x000fc400000006ffULL, 0x000000a55aa57219ULL, 0x040fe400000006ffULL,
0x000000995a997219ULL, 0x000fe400000006ffULL, 0x0000541061687816ULL, 0x000fe40000000068ULL,
0xff80000024247808ULL, 0x000fe40001800000ULL, 0xff80000026267808ULL, 0x000fe40000800000ULL,
0xff80000035357808ULL, 0x000fc40003000000ULL, 0xff80000037377808ULL, 0x000fe40000000000ULL,
0xff80000027277808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fe40002000000ULL,
0xff80000020207808ULL, 0x000fe40002800000ULL, 0x0000006aa4ff7212ULL, 0x080fe4000786c0ffULL,
0x0000006aa5ff7212ULL, 0x000fc4000782c0ffULL, 0x0000006a99ff7212ULL, 0x000fe400078cc0ffULL,
0x00000068a3ff7212ULL, 0x080fe4000780c0ffULL, 0x00000068a4ff7212ULL, 0x0c0fe4000784c0ffULL,
0x00000068a5ff7212ULL, 0x000fe4000788c0ffULL, 0x00000066a4ff7212ULL, 0x000fe400078ac0ffULL,
0x000000b16200720cULL, 0x000fc40000701470ULL, 0x000000b19500720cULL, 0x0c0fe40001f61470ULL,
0x000000b19500720cULL, 0x0c0fe40001741470ULL, 0x000000b19500720cULL, 0x080fe40002fa1470ULL,
0x000000b19600720cULL, 0x0c0fe40000f21470ULL, 0x000000b19700720cULL, 0x080fe400037c1470ULL,
0x000000b19600720cULL, 0x000fc40002781470ULL, 0x000000b15d00720cULL, 0x080fe40000701070ULL,
0x000000b16000720cULL, 0x0c0fe40001f61070ULL, 0x000000b16000720cULL, 0x0c0fe40001741070ULL,
0x000000b16000720cULL, 0x080fe40002fa1070ULL, 0x000000b15e00720cULL, 0x080fe40000f21070ULL,
0x000000b15c00720cULL, 0x000fc400037c1070ULL, 0x000000b15e00720cULL, 0x000fe40002781070ULL,
0x000054105f647816ULL, 0x000fe40000000064ULL, 0xff80000032327808ULL, 0x000fe40000000000ULL,
0xff80000031317808ULL, 0x000fe40001800000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff80000021217808ULL, 0x000fc40002800000ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff8000002d2d7808ULL, 0x000fe40003000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002000000ULL,
0x0000006899ff7212ULL, 0x000fe4000780c0ffULL, 0x00000066a5ff7212ULL, 0x080fe4000786c0ffULL,
0x0000006699ff7212ULL, 0x000fc4000784c0ffULL, 0x00000064a3ff7212ULL, 0x080fe400078ac0ffULL,
0x00000064a4ff7212ULL, 0x080fe4000782c0ffULL, 0x00000064a5ff7212ULL, 0x080fe400078cc0ffULL,
0x0000006499ff7212ULL, 0x000fe4000788c0ffULL, 0x000000b16200720cULL, 0x080fe40002fa1470ULL,
0x000000b19500720cULL, 0x000fc40000f21470ULL, 0x000000b19600720cULL, 0x0c0fe40001f61470ULL,
0x000000b19600720cULL, 0x080fe400037c1470ULL, 0x000000b19700720cULL, 0x0c0fe40000701470ULL,
0x000000b19700720cULL, 0x0c0fe40001741470ULL, 0x000000b19700720cULL, 0x080fe40002781470ULL,
0x000000b15d00720cULL, 0x000fc40002fa1070ULL, 0x000000b16000720cULL, 0x080fe40000f21070ULL,
0x000000b15c00720cULL, 0x080fe40000701070ULL, 0x000000b15e00720cULL, 0x0c0fe40001f61070ULL,
0x000000b15e00720cULL, 0x080fe400037c1070ULL, 0x000000b15c00720cULL, 0x0c0fe40001741070ULL,
0x000000b15c00720cULL, 0x000fc40002781070ULL, 0xff8000002f2f7808ULL, 0x000fe40000000000ULL,
0xff8000001c1c7808ULL, 0x000fe40001800000ULL, 0xff8000001d1d7808ULL, 0x000fe40001000000ULL,
0xff80000022227808ULL, 0x000fe40002800000ULL, 0xff80000023237808ULL, 0x000fe40000800000ULL,
0xff8000001e1e7808ULL, 0x000fc40003000000ULL, 0xff8000001f1f7808ULL, 0x000fce0002000000ULL,
0x000000110800720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x00000003ff5f7819ULL, 0x000fe20000011604ULL, 0x000000016e6e7836ULL, 0x000fe20000000000ULL,
0x0000000811087208ULL, 0x000fe20004000000ULL, 0x000000ffff6f7224ULL, 0x000fc600078e0059ULL,
0x000000510800720bULL, 0x000fc80003f1e000ULL, 0x0000000851197208ULL, 0x000fc80004000000ULL,
0x000000481900720bULL, 0x000fc80003f1e000ULL, 0x0000001948087208ULL, 0x000fc80004000000ULL,
0x000000490800720bULL, 0x000fc80003f1e000ULL, 0x0000000849197208ULL, 0x000fc80004000000ULL,
0x000000401900720bULL, 0x000fc80003f1e000ULL, 0x0000001940087208ULL, 0x000fc80004000000ULL,
0x000000410800720bULL, 0x000fc80003f1e000ULL, 0x0000000841197208ULL, 0x000fc80004000000ULL,
0x0000000c1900720bULL, 0x000fc80003f1e000ULL, 0x000000190c087208ULL, 0x000fc80004000000ULL,
0x0000000d0800720bULL, 0x000fc80003f1e000ULL, 0x000000080d197208ULL, 0x000fc80004000000ULL,
0x000000381900720bULL, 0x000fc80003f1e000ULL, 0x0000001938087208ULL, 0x000fc80004000000ULL,
0x000000390800720bULL, 0x000fc80003f1e000ULL, 0x0000000839197208ULL, 0x000fc80004000000ULL,
0x000000341900720bULL, 0x000fc80003f1e000ULL, 0x0000001934087208ULL, 0x000fc80004000000ULL,
0x000000350800720bULL, 0x000fc80003f1e000ULL, 0x0000000835197208ULL, 0x000fc80004000000ULL,
0x000000301900720bULL, 0x000fc80003f1e000ULL, 0x0000001930087208ULL, 0x000fc80004000000ULL,
0x000000310800720bULL, 0x000fc80003f1e000ULL, 0x0000000831197208ULL, 0x000fc80004000000ULL,
0x0000002c1900720bULL, 0x000fc80003f1e000ULL, 0x000000192c087208ULL, 0x000fe40004000000ULL,
0x000000520900720bULL, 0x000fe40003f1e000ULL, 0x0000002d0800720bULL, 0x000fc80003f3e000ULL,
0x000000082d187208ULL, 0x000fe40004800000ULL, 0x0000000952087208ULL, 0x000fc60004000000ULL,
0x0c401f0018197f89ULL, 0x000ea200000e0000ULL, 0x000000530800720bULL, 0x000fc80003f1e000ULL,
0x0000000853097208ULL, 0x000fc80004000000ULL, 0x0000004a0900720bULL, 0x000fc80003f1e000ULL,
0x000000094a087208ULL, 0x000fc80004000000ULL, 0x0000004b0800720bULL, 0x000fc80003f1e000ULL,
0x000000084b097208ULL, 0x000fe40004000000ULL, 0x000000191800720bULL, 0x004fe40003f3e000ULL,
0x000000420900720bULL, 0x000fe40003f1e000ULL, 0x0000001819197208ULL, 0x000fe40004800000ULL,
0x0000000942087208ULL, 0x000fc60004000000ULL, 0x0c201f0019187f89ULL, 0x000ea200000e0000ULL,
0x000000430800720bULL, 0x000fc80003f1e000ULL, 0x0000000843097208ULL, 0x000fc80004000000ULL,
0x0000000e0900720bULL, 0x000fc80003f1e000ULL, 0x000000090e087208ULL, 0x000fc80004000000ULL,
0x0000000f0800720bULL, 0x000fc80003f1e000ULL, 0x000000080f097208ULL, 0x000fe40004000000ULL,
0x000000181900720bULL, 0x004fe40003f3e000ULL, 0x0000003a0900720bULL, 0x000fe40003f1e000ULL,
0x0000001918087208ULL, 0x000fe40004800000ULL, 0x000000093a187208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b08547820ULL, 0x000fe20000410000ULL, 0x0000003b1800720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b48197823ULL, 0x100fe20000010854ULL, 0x000000183b097208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b401b7823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b414c7823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b0c507823ULL, 0x100fe20000010854ULL, 0x000000360900720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b51187823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010854ULL, 0x00000009361a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010854ULL, 0x000000371a00720bULL, 0x000fe20003f1e000ULL,
0x0000005000507308ULL, 0x000fe60000000800ULL, 0x0000001a37097208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b491a7823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b39497823ULL, 0x000fc40000010854ULL,
0x000000320900720bULL, 0x000fe20003f1e000ULL, 0x0000000d000d7308ULL, 0x000fe60000000800ULL,
0x0000000932487208ULL, 0x000fc80004000000ULL, 0x000000334800720bULL, 0x000fe20003f1e000ULL,
0x0000001100117308ULL, 0x000fe60000000800ULL, 0x0000004833097208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b38487823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b2c387823ULL, 0x000fe40000010854ULL,
0x0000002e0900720bULL, 0x000fe20003f1e000ULL, 0x0000001800187308ULL, 0x000fe60000000800ULL,
0x000000092e407208ULL, 0x000fc80004000000ULL, 0x0000002f4000720bULL, 0x000fe20003f1e000ULL,
0x0000001900197308ULL, 0x000fe60000000800ULL, 0x000000402f407208ULL, 0x000fe40004000000ULL,
0x000000130a00720bULL, 0x000fc60003f1e000ULL, 0x0c401f0040417f89ULL, 0x000ea200000e0000ULL,
0x0000000a130a7208ULL, 0x000fe20004000000ULL, 0x0000001a001a7308ULL, 0x000fe60000000800ULL,
0x0000004d0a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a4d097208ULL, 0x000fe20004000000ULL,
0x0000001b001b7308ULL, 0x000fe60000000800ULL, 0x000000440900720bULL, 0x000fc80003f1e000ULL,
0x00000009440a7208ULL, 0x000fe20004000000ULL, 0x0000004c004c7308ULL, 0x000fe60000000800ULL,
0x000000450a00720bULL, 0x000fe40003f1e000ULL, 0x000000414000720bULL, 0x004fe40003f3e000ULL,
0x0000000a45097208ULL, 0x000fe20004000000ULL, 0x0000004800487308ULL, 0x000fe20000000800ULL,
0x00000040410c7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b35417823ULL, 0x000fe20000010854ULL,
0x0000003c0900720bULL, 0x000fc60003f1e000ULL, 0x0c201f000c397f89ULL, 0x000ea200000e0000ULL,
0x000000093c0a7208ULL, 0x000fe20004000000ULL, 0x0000003400407308ULL, 0x0007e60000000800ULL,
0x0000003d0a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a3d097208ULL, 0x000fe20004000000ULL,
0x0000004900497308ULL, 0x000fe60000000800ULL, 0x000000100900720bULL, 0x000fc80003f1e000ULL,
0x0000000910097208ULL, 0x000fe20004000000ULL, 0x0000004100417308ULL, 0x000fe60000000800ULL,
0x000000120900720bULL, 0x000fe40003f1e000ULL, 0x000000390c00720bULL, 0x004fe40003f3e000ULL,
0x0000000912357208ULL, 0x000fe20004000000ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x0000000c39097208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b2d397823ULL, 0x000fe20000010854ULL,
0x000000283500720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b09557820ULL, 0x000fe20000410000ULL,
0x00000035280a7208ULL, 0x000fe20004000000ULL, 0x0000003100317308ULL, 0x000ea40000000800ULL,
0x3fb8aa3b522c7823ULL, 0x100fe20000010855ULL, 0x000000290a00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b43527823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b0f547823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b4a347823ULL, 0x108fe20000010855ULL, 0x0000000a292d7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b4b4a7823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010855ULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x000000242d00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b424b7823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b3a427823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b2f3a7823ULL, 0x100fe20000010855ULL, 0x0000002d240a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3b3b7823ULL, 0x000fe20000010855ULL, 0x000000303130723eULL, 0x004fe200000010ffULL,
0x0000003400347308ULL, 0x000fe20000000800ULL, 0x000000250a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a25357208ULL, 0x000fe40004000000ULL, 0x0000004e0b00720bULL, 0x000fe20003f1e000ULL,
0x00000053002d7308ULL, 0x000fe20000000800ULL, 0x000000203500720bULL, 0x000fe40003f3e000ULL,
0x0000000b4e0a7208ULL, 0x000fe40004000000ULL, 0x00000035200c7208ULL, 0x000fe40004800000ULL,
0x0000004f0a00720bULL, 0x000fe20003f1e000ULL, 0x0000004a00357308ULL, 0x0004e20000000800ULL,
0x000000210c00720bULL, 0x000fc40003f3e000ULL, 0x0000000a4f0b7208ULL, 0x000fe40004000000ULL,
0x0000000c21517208ULL, 0x000fe40004800000ULL, 0x000000460b00720bULL, 0x000fe20003f1e000ULL,
0x0000005400547308ULL, 0x000fe20000000800ULL, 0x0000001c5100720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b374a7823ULL, 0x104fe20000010855ULL, 0x0000000b460a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b33377823ULL, 0x100fe20000010855ULL, 0x000000511c0c7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b0e517823ULL, 0x100fe20000010855ULL, 0x000000470a00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b360e7823ULL, 0x100fe20000010855ULL, 0x0000001d0c00720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b2e337823ULL, 0x100fe20000010855ULL, 0x0000000a470b7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b32367823ULL, 0x000fe20000010855ULL, 0x0000000c1d0c7208ULL, 0x000fe20004800000ULL,
0x0000005100517308ULL, 0x000ea20000000800ULL, 0x0000003e0b00720bULL, 0x000fc60003f1e000ULL,
0x0c401f000c437f89ULL, 0x000f6200000e0000ULL, 0x0000000b3e0a7208ULL, 0x000fc60004000000ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x0000003f0a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a3f0b7208ULL, 0x000fc60004000000ULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x000000140b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b140a7208ULL, 0x000fc60004000000ULL,
0x0000004200427308ULL, 0x000fe20000000800ULL, 0x000000150a00720bULL, 0x000fe40003f1e000ULL,
0x000000430c00720bULL, 0x022fe40003f3e000ULL, 0x0000000a150b7208ULL, 0x000fe40004000000ULL,
0x0000000c430c7208ULL, 0x000fe20004800000ULL, 0x0000003b003b7308ULL, 0x000fe20000000800ULL,
0x0000002a0b00720bULL, 0x000fc60003f1e000ULL, 0x0c201f000c0f7f89ULL, 0x000e6200000e0000ULL,
0x0000000b2a0a7208ULL, 0x000fc60004000000ULL, 0x0000000e00437308ULL, 0x000be20000000800ULL,
0x0000002b0a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a2b0b7208ULL, 0x000fc60004000000ULL,
0x0000004a004a7308ULL, 0x000fe20000000800ULL, 0x000000260b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b260a7208ULL, 0x000fc60004000000ULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x000000270a00720bULL, 0x000fe40003f1e000ULL, 0x0000000f0c00720bULL, 0x002fe40003f3e000ULL,
0x0000000a270b7208ULL, 0x000fe40004000000ULL, 0x0000000c0f0a7208ULL, 0x000fe20004800000ULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x000000220b00720bULL, 0x000fe40003f1e000ULL,
0x00000034350f723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b0a0e7820ULL, 0x020fe20000410000ULL,
0x0000000b220c7208ULL, 0x000fe20004000000ULL, 0x00000004ff347e24ULL, 0x000fc4000f8e00ffULL,
0x3fb8aa3b44447823ULL, 0x100fe2000001080eULL, 0x000000230c00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe2000001080eULL,
0x00000044005d7308ULL, 0x0007e20000000800ULL, 0x0000000c230b7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b45457823ULL, 0x100fe2000001080eULL, 0x3f8000003434783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b3c327823ULL, 0x100fe2000001080eULL, 0x0000001e0b00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b3d557823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b125c7823ULL, 0x100fe2000001080eULL,
0x00000013002e7308ULL, 0x000fe20000000800ULL, 0x0000000b1e0c7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b1c447823ULL, 0x108fe2000001080eULL, 0x3fb8aa3b10577823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b28537823ULL, 0x100fe2000001080eULL, 0x0000001f0c00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b295a7823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b25567823ULL, 0x100fe2000001080eULL,
0x0000004d002f7308ULL, 0x0007e20000000800ULL, 0x0000000c1f0c7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b203c7823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b213d7823ULL, 0x000fe2000001080eULL,
0x000000500d12723eULL, 0x000fe200000010ffULL, 0x000000ffff357224ULL, 0x000fe200078e0034ULL,
0x0c401f000c0b7f89ULL, 0x000f6200000e0000ULL, 0x0000002c2d0d723eULL, 0x000fe200000010ffULL,
0x00000045005e7308ULL, 0x0002620000000800ULL, 0x3fb8aa3b244d7823ULL, 0x008fe2000001080eULL,
0x0000001b4c10723eULL, 0x000fc400000010ffULL, 0x000000515413723eULL, 0x004fe400000010ffULL,
0xfffffff8ff517812ULL, 0x000fe400078ee216ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1d457823ULL, 0x002fe2000001080eULL, 0x000000191a0e723eULL, 0x000fe200000010ffULL,
0x0000001051547836ULL, 0x000fe20000000000ULL, 0x0000000404167810ULL, 0x000fe40007ffe05fULL,
0x000000363731723eULL, 0x000fe200000010ffULL, 0x000000ffff367224ULL, 0x000fe200078e0034ULL,
0x0000005d5e1a723eULL, 0x000fe200000010ffULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x00000018515d7836ULL, 0x000fc40000000000ULL, 0x000000ffff377224ULL, 0x000fe200078e0034ULL,
0x0000000b0c00720bULL, 0x020fe20003f1e000ULL, 0x000000085d507824ULL, 0x000fc600078e00ffULL,
0x0000005700577308ULL, 0x000fe20000000800ULL, 0x0000000c0b0b7208ULL, 0x000fca0004000000ULL,
0x0c201f000b0c7f89ULL, 0x000e6400000e0000ULL, 0x0000005c005c7308ULL, 0x000ff00000000800ULL,
0x0000005300537308ULL, 0x000ff00000000800ULL, 0x0000005a005a7308ULL, 0x000fe20000000800ULL,
0x0000000c0b00720bULL, 0x002fce0003f1e000ULL, 0x0000004d004d7308ULL, 0x000fe20000000800ULL,
0x0000000b0c0b7208ULL, 0x000fe40004000000ULL, 0x00000011180c723eULL, 0x000fe400000010ffULL,
0x0000002e2f18723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b0b1c7820ULL, 0x000fe20000410000ULL,
0x0000004b5211723eULL, 0x000fe200000010ffULL, 0x0000000851527836ULL, 0x000fe20000000000ULL,
0x0000005600567308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b46467823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b47477823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001081cULL, 0x000000340c2c723cULL, 0x000fe200000418ffULL,
0x0000004600467308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b2b207823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b234b7823ULL, 0x000fe2000001081cULL,
0x0000004700477308ULL, 0x000e620000000800ULL, 0x000000434a23723eULL, 0x000fe200000010ffULL,
0x000000ffff437224ULL, 0x100fe200078e0034ULL, 0x0000000304ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff4a7224ULL, 0x000fc800078e0034ULL, 0x0000004e004e7308ULL, 0x000fe20000000800ULL,
0x00000046471b723eULL, 0x002fce00000010ffULL, 0x0000004f004f7308ULL, 0x000e620000000800ULL,
0x0000000716477812ULL, 0x000fe200078ec0ffULL, 0x0000000852167824ULL, 0x000fe200078e00ffULL,
0x00000034102c723cULL, 0x000fe8000004182cULL, 0xfffffff816167812ULL, 0x000fe200078ee247ULL,
0x0000001400217308ULL, 0x0005e20000000800ULL, 0x0000004e4f19723eULL, 0x002fce00000010ffULL,
0x0000001500467308ULL, 0x0002e20000000800ULL, 0x000000ffff147224ULL, 0x004fe400078e0034ULL,
0x3fb8aa3b1e4f7823ULL, 0x000fe2000001081cULL, 0x00000008544e7824ULL, 0x000fe200078e00ffULL,
0x000000575c1e723eULL, 0x000fc600000010ffULL, 0x0000002a00257308ULL, 0x0005e20000000800ULL,
0x000000ffff157224ULL, 0x002fce00078e0034ULL, 0x0000003e001d7308ULL, 0x0003e20000000800ULL,
0x000000141828723cULL, 0x004fee00000418ffULL, 0x0000003f00247308ULL, 0x000ea20000000800ULL,
0x00000008513e7824ULL, 0x002fe200078e00ffULL, 0xfffffff84e157812ULL, 0x000fc400078ee247ULL,
0xfffffff850147812ULL, 0x000fe200078ee247ULL, 0x3fb8aa3b1f507823ULL, 0x100fe2000001081cULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee247ULL, 0x3fb8aa3b22477823ULL, 0x000fe2000001081cULL,
0x00000032551c723eULL, 0x000fe200000010ffULL, 0x00000020004c7308ULL, 0x0003620000000800ULL,
0x00000021461f723eULL, 0x008fe200000010ffULL, 0x0000000851327824ULL, 0x000fe200078e00ffULL,
0x000000423b21723eULL, 0x000fe200000010ffULL, 0x000000ffff427224ULL, 0x000fe200078e0034ULL,
0x000000404122723eULL, 0x000fe200000010ffULL, 0x0000000854467824ULL, 0x000fe200078e00ffULL,
0x0000001d241d723eULL, 0x004fe200000010ffULL, 0x00000026003f7308ULL, 0x0005e20000000800ULL,
0x000000484920723eULL, 0x002fe200000010ffULL, 0x000000085d487824ULL, 0x000fe200078e00ffULL,
0x000000535a24723eULL, 0x000fc600000010ffULL, 0x000000341c28723cULL, 0x000fe20000041828ULL,
0x000000254c25723eULL, 0x020fe200000010ffULL, 0x00000027004e7308ULL, 0x000e620000000800ULL,
0x0000004d5626723eULL, 0x004fc600000010ffULL, 0x00000042202c723cULL, 0x000fe2000004182cULL,
0x000000035f357812ULL, 0x000fc600078ec0ffULL, 0x0000004b00407308ULL, 0x0005e40000000800ULL,
0x0000000135357824ULL, 0x000fe400078e0204ULL, 0x0000000852427824ULL, 0x000fe200078e00ffULL,
0x0000003f4e27723eULL, 0x002fc600000010ffULL, 0x0000003800387308ULL, 0x000fe20000000800ULL,
0x000000ffff4b7224ULL, 0x004fe200078e0034ULL, 0x0000000735357812ULL, 0x000fe200078ec0ffULL,
0x000000ffff347224ULL, 0x000fe400078e0020ULL, 0x000000ffff207224ULL, 0x000fe200078e0018ULL,
0xfffffff8323f7812ULL, 0x000fe200078ee235ULL, 0x000000ffff187224ULL, 0x000fe200078e0019ULL,
0x0000003900397308ULL, 0x000e620000000800ULL, 0x0000004a2428723cULL, 0x000fe20000041828ULL,
0xfffffff842427812ULL, 0x000fe200078ee235ULL, 0x000000ffff197224ULL, 0x000fe200078e001bULL,
0xfffffff846467812ULL, 0x000fe200078ee235ULL, 0x000000ffff1b7224ULL, 0x000fe200078e001fULL,
0xfffffff848487812ULL, 0x000fc400078ee235ULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0x0000000871357c11ULL, 0x000fca000f8e60ffULL, 0x0001200035357836ULL, 0x000fe20000000000ULL,
0x000000383932723eULL, 0x002fe200000010ffULL, 0x0000003a003a7308ULL, 0x000e640000000800ULL,
0x0000001016167824ULL, 0x100fe400078e0235ULL, 0x0000001014147824ULL, 0x100fe400078e0235ULL,
0x0000001042427824ULL, 0x100fe400078e0235ULL, 0x0000003c003c7308ULL, 0x000fe20000000800ULL,
0x0000001046467824ULL, 0x000fc400078e0235ULL, 0x0000001048487824ULL, 0x000fe200078e0235ULL,
0x000000333a33723eULL, 0x002fc800000010ffULL, 0x0000003d003d7308ULL, 0x000e660000000800ULL,
0x00000036302c723cULL, 0x000fea000004182cULL, 0x0000004400447308ULL, 0x000fe20000000800ULL,
0x0000003c3d38723eULL, 0x002fce00000010ffULL, 0x0000004500457308ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fe400078e000cULL, 0x000000ffff3d7224ULL, 0x000fe400078e000eULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff0d7224ULL, 0x000fe200078e000fULL,
0x0000004700477308ULL, 0x000ea20000000800ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0011ULL,
0x00000010152f7824ULL, 0x000fc400078e0235ULL, 0x000000103e2d7824ULL, 0x100fe200078e0235ULL,
0x00000044453a723eULL, 0x002fe400000010ffULL, 0x0000004f003b7308ULL, 0x000fe20000000800ULL,
0x000000103f157824ULL, 0x000fe400078e0235ULL, 0x000000ffff3e7224ULL, 0x000fe400078e0010ULL,
0x000000ffff3f7224ULL, 0x000fe200078e0012ULL, 0x000000474039723eULL, 0x004fe400000010ffULL,
0x0000005000507308ULL, 0x000e620000000800ULL, 0x000000ffff357224ULL, 0x000fe200078e0022ULL,
0x0000003c15007844ULL, 0x000fe20000000200ULL, 0x000000ffff0f7224ULL, 0x000fc400078e0013ULL,
0x000000ffff107224ULL, 0x000fe400078e0021ULL, 0x000000ffff117224ULL, 0x000fe400078e0023ULL,
0x000000ffff127224ULL, 0x000fe400078e0031ULL, 0x000000ffff137224ULL, 0x000fe400078e0033ULL,
0x000000ffff217224ULL, 0x000fe200078e001aULL, 0x0000003b503b723eULL, 0x002fe200000010ffULL,
0x000000ffff227224ULL, 0x000fc400078e001cULL, 0x000000ffff237224ULL, 0x000fe400078e001eULL,
0x000000ffff317224ULL, 0x000fe400078e0026ULL, 0x000000363828723cULL, 0x000fec0000041828ULL,
0x000000ffff337224ULL, 0x000fc400078e003aULL, 0x000000ffff1a7224ULL, 0x000fe400078e001dULL,
0x000000ffff1c7224ULL, 0x000fe400078e0025ULL, 0x000000ffff367224ULL, 0x000fe400078e0030ULL,
0x000000ffff377224ULL, 0x000fe400078e0032ULL, 0x000000ffff307224ULL, 0x000fe400078e0024ULL,
0x000000ffff327224ULL, 0x000fe200078e0038ULL, 0x000000342d007844ULL, 0x0003e20000000200ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0027ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0039ULL,
0x0000000c42007844ULL, 0x0005e20000000200ULL, 0x000000ffff1f7224ULL, 0x000fc600078e003bULL,
0x0000001016007844ULL, 0x000fe80000000200ULL, 0x0000002046007844ULL, 0x000fe80000000200ULL,
0x000000302f007844ULL, 0x0007e20000000200ULL, 0x000000ffff2d7224ULL, 0x002fe400078e002eULL,
0x000000ffff2e7224ULL, 0x000fe200078e0028ULL, 0x0000001848007844ULL, 0x0003e20000000200ULL,
0x00000001ff0d7424ULL, 0x004fc600078e00ffULL, 0x0000001c14007844ULL, 0x0003e80000000200ULL,
0x01a0000817008388ULL, 0x0003e20000000c00ULL, 0x000000ffff2f7224ULL, 0x008fca00078e002aULL,
0x01a2002c17008388ULL, 0x0003e20000000c00ULL, 0x000000706e00720cULL, 0x000fe20003f06070ULL,
0x01a6080d72ff79a7ULL, 0x0003e2000850003fULL, 0x01a6100d72ff79a7ULL, 0x0003e2000850003fULL,
0x01a6180d72ff79a7ULL, 0x0003e2000850003fULL, 0x01a6200d72ff79a7ULL, 0x0003f2000850003fULL,
0xffffff8800288947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000082007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000008200008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff82ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000082027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000008200007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffe6002a87950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004ebULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000668ULL, 0x0000000000000228ULL,
0x0000001500000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000890ULL, 0x00000000000000e0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000970ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000009c4ULL, 0x0000000000000710ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010d8ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010d8ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001120ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000019e00ULL,
0x0000001500000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001af80ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001afc0ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000001afc0ULL, 0x0000000000000278ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x000000000001b5b8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001b5b8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001120ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000019e00ULL, 0x0000000000019e00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x000000000001af80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001afc0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000278ULL, 0x0000000000000278ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_32_sm_90_cubin_len = 112392;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
