/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_32_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001c640ULL, 0x000000000001c2c0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL,
0x326d735f61647563ULL, 0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL,
0x746e695f5f240068ULL, 0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL,
0x66625f636e79736cULL, 0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL,
0x5f30376d735f6164ULL, 0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL,
0x5f5f245f335f6c61ULL, 0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL,
0x2e616c65722e0074ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL,
0x766e2e0066754265ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL,
0x65642e006d617261ULL, 0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL,
0x616c65722e00656dULL, 0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL,
0x00000000006e6f69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000037fULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000003cdULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b002200000413ULL,
0x000000000001a6a0ULL, 0x0000000000000180ULL, 0x000b002200000446ULL, 0x000000000001a820ULL,
0x0000000000000040ULL, 0x000b002200000471ULL, 0x000000000001a860ULL, 0x0000000000000050ULL,
0x000b00220000049bULL, 0x000000000001a8b0ULL, 0x0000000000000150ULL, 0x000a000300000509ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000529ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000559ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001aa00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001a6a000000000ULL, 0x0000040400000000ULL, 0x810c000001880400ULL, 0x0068140400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001a6a000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080830828ULL,
0x2880808d08288080ULL, 0x8094082880809308ULL, 0x0828808095082880ULL, 0x8080970828808096ULL,
0xa5082880809c0828ULL, 0x288080a708288080ULL, 0x80f008288080ec08ULL, 0x08288080f1082880ULL,
0x80808808288080f2ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808892ULL,
0x0000001cffffffffULL, 0x000000f000000000ULL, 0x0001a82000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080830828ULL,
0x2880808d08288080ULL, 0x8094082880809308ULL, 0x0828808095082880ULL, 0x8080970828808096ULL,
0xa6082880809c0828ULL, 0x288080a708288080ULL, 0x80f008288080ec08ULL, 0x08288080f1082880ULL,
0x8080a508288080f2ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080a592ULL,
0x0000002cffffffffULL, 0x000001b000000000ULL, 0x0001a86000000000ULL, 0x0000005000000000ULL,
0x0000040400000000ULL, 0x80ec288080a50900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8508288080830828ULL, 0x2880808d08288080ULL, 0x8094082880809308ULL,
0x0828808095082880ULL, 0x8080970828808096ULL, 0xa5082880809c0828ULL, 0x288080a708288080ULL,
0x80f008288080ec08ULL, 0x08288080f1082880ULL, 0x8080a608288080f2ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080a692ULL, 0x0000001cffffffffULL, 0x0000028000000000ULL,
0x0001a8b000000000ULL, 0x0000015000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL,
0x00082304000000e0ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL,
0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL,
0x0000001600080a04ULL, 0x0068190300680160ULL, 0x00000000000c1704ULL, 0x0021f0000060000aULL,
0x00000000000c1704ULL, 0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0011f00000500008ULL,
0x00000000000c1704ULL, 0x0081f00000300007ULL, 0x00000000000c1704ULL, 0x0021f00000280006ULL,
0x00000000000c1704ULL, 0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL,
0x00000000000c1704ULL, 0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL,
0x00000000000c1704ULL, 0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400ff1b03ULL, 0x019c290400000eb0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x019c2804ffffffffULL, 0x0000032000000150ULL, 0x00002ce0000005a0ULL,
0x00002ea000002d90ULL, 0x0000318000003010ULL, 0x00003730000032e0ULL, 0x0000378000003770ULL,
0x000061c0000037b0ULL, 0x0000637000006250ULL, 0x00006650000064e0ULL, 0x00006c30000067b0ULL,
0x00006c8000006c70ULL, 0x000094a000006cb0ULL, 0x0000966000009540ULL, 0x00009940000097d0ULL,
0x00009f2000009aa0ULL, 0x00009f7000009f60ULL, 0x0000c86000009fa0ULL, 0x0000ca100000c900ULL,
0x0000ccf00000cb80ULL, 0x0000d2d00000ce50ULL, 0x0000d3200000d310ULL, 0x0000efc00000d350ULL,
0x0000efe00000efd0ULL, 0x000183200000eff0ULL, 0x0001837000018360ULL, 0x000183d000018380ULL,
0x00018410000183f0ULL, 0x0001981000018420ULL, 0x000198b000019860ULL, 0x00019930000198f0ULL,
0x000199c000019970ULL, 0x00019a6000019a10ULL, 0x00019b0000019ab0ULL, 0x00019ba000019b50ULL,
0x00019c2000019be0ULL, 0x00019cb000019c60ULL, 0x00019d5000019d00ULL, 0x00019df000019da0ULL,
0x00019e9000019e40ULL, 0x00019f1000019ed0ULL, 0x00019fa000019f50ULL, 0x0001a04000019ff0ULL,
0x0001a0e00001a090ULL, 0x0001a1800001a130ULL, 0x0001a2000001a1c0ULL, 0x0001a2900001a240ULL,
0x0001a3300001a2e0ULL, 0x0001a3e00001a380ULL, 0x0001a4a00001a440ULL, 0x0001a5600001a500ULL,
0x0001a6200001a5c0ULL, 0x044039040001a680ULL, 0x000000ff00000410ULL, 0x003f010000012600ULL,
0x0000000f00000450ULL, 0x003f012000012608ULL, 0x0000000f000004e0ULL, 0x003f012000012688ULL,
0x0000000f00000510ULL, 0x003f0120000126a8ULL, 0x0000000f00000530ULL, 0x003f0120000126c8ULL,
0x000000ff00000ec0ULL, 0x003f010700012600ULL, 0x00000003000010c0ULL, 0x003f010200000004ULL,
0x0000000300001180ULL, 0x003f010100000000ULL, 0x000000ff00001b60ULL, 0x0004010700000000ULL,
0x000000ff00001be0ULL, 0x0004010100000000ULL, 0x0000000200001c40ULL, 0x003f0101000126c8ULL,
0x0000001900001dc0ULL, 0x003f0105000126ccULL, 0x0000001900001fb0ULL, 0x003f0105000126ccULL,
0x00000019000028d0ULL, 0x003f0107000126b0ULL, 0x0000001900002980ULL, 0x003f0101000126b0ULL,
0x00000003000029e0ULL, 0x003f010100012608ULL, 0x0000000300002a00ULL, 0x003f01050001260cULL,
0x0000000300002bd0ULL, 0x003f01050001260cULL, 0x0000001900003490ULL, 0x003f0105000126acULL,
0x0000001900003660ULL, 0x003f0105000126acULL, 0x0000006c00005360ULL, 0x003f010100000000ULL,
0x00000025000053c0ULL, 0x003f010100012688ULL, 0x00000004000053f0ULL, 0x003f010500000004ULL,
0x00000004000055b0ULL, 0x003f010500000004ULL, 0x000000ff00005e20ULL, 0x00040107000126a8ULL,
0x000000ff00005ea0ULL, 0x00040101000126a8ULL, 0x0000000300005f00ULL, 0x003f010100012628ULL,
0x0000000300005f20ULL, 0x003f01050001262cULL, 0x00000003000060f0ULL, 0x003f01050001262cULL,
0x0000006c000069a0ULL, 0x003f0105000126b4ULL, 0x0000006c00006b70ULL, 0x003f0105000126b4ULL,
0x0000006e00008630ULL, 0x003f010100000000ULL, 0x0000002600008690ULL, 0x003f010100012690ULL,
0x00000004000086c0ULL, 0x003f010500000004ULL, 0x0000000400008880ULL, 0x003f010500000004ULL,
0x00000025000090b0ULL, 0x003f0107000126b0ULL, 0x0000002500009180ULL, 0x003f0101000126b0ULL,
0x00000003000091e0ULL, 0x003f010100012648ULL, 0x0000000300009200ULL, 0x003f01050001264cULL,
0x00000003000093d0ULL, 0x003f01050001264cULL, 0x0000007000009c90ULL, 0x003f0105000126acULL,
0x0000007000009e60ULL, 0x003f0105000126acULL, 0x000000250000b920ULL, 0x003f010100000000ULL,
0x0000001a0000b980ULL, 0x003f010100012698ULL, 0x000000250000b9b0ULL, 0x003f010500000004ULL,
0x000000250000bb90ULL, 0x003f010500000004ULL, 0x000000200000c4c0ULL, 0x003f0107000126a8ULL,
0x000000200000c550ULL, 0x003f0101000126a8ULL, 0x000000050000c5b0ULL, 0x003f010100012668ULL,
0x000000050000c5e0ULL, 0x003f01050001266cULL, 0x000000050000c7b0ULL, 0x003f01050001266cULL,
0x0000001f0000d030ULL, 0x003f0105000126b4ULL, 0x0000001f0000d200ULL, 0x003f0105000126b4ULL,
0x000000040000ed70ULL, 0x003f010100000000ULL, 0x000000020000edf0ULL, 0x003f010100000000ULL,
0x000000ff00011060ULL, 0x003f010100012600ULL, 0x000000ff00011c90ULL, 0x003f010500012604ULL,
0x000000ff00011ea0ULL, 0x003f010500012604ULL, 0x000000ff00012220ULL, 0x003f010100012600ULL,
0x000000ff00012250ULL, 0x003f010500012604ULL, 0x000000ff00012410ULL, 0x003f010500012604ULL,
0x0000006a00015590ULL, 0x003f010100000000ULL, 0x0000006a00015680ULL, 0x003f010500000004ULL,
0x0000006a00015850ULL, 0x003f010500000004ULL, 0x0000006d00019670ULL, 0x003f010100000000ULL,
0x0000006d000196d0ULL, 0x003f010100000008ULL, 0x0000006d00019730ULL, 0x003f010100000010ULL,
0x0000006d000197a0ULL, 0x003f010100000018ULL, 0x00301c0400053803ULL, 0x0000ff800000ff50ULL,
0x0001041000010220ULL, 0x000107f000010600ULL, 0x00010bd0000109e0ULL, 0x00010f8000010dd0ULL,
0x000197e000012470ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000032cULL,
0x0000001900000002ULL, 0x000000000000025cULL, 0x0000001900000002ULL, 0x000000000000019cULL,
0x0000001900000002ULL, 0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL,
0x0000001900000002ULL, 0x0000000000000308ULL, 0x0000001900000002ULL, 0x0000000000000238ULL,
0x0000001900000002ULL, 0x0000000000000178ULL, 0x0000001900000002ULL, 0x00000000000000a8ULL,
0x0000001900000002ULL, 0x0000000000012700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff030424ULL, 0x000fe200078e00ffULL,
0x0000000104060810ULL, 0x002fca0007ffe0ffULL, 0x00005c0006060625ULL, 0x000fc800078e0003ULL,
0x00005c0004020625ULL, 0x000fe200078e0003ULL, 0x0000000606000981ULL, 0x0002aa000c1e1900ULL,
0x0000000602030981ULL, 0x0006a2000c1e1900ULL, 0x0000590000057b06ULL, 0x000f220000209000ULL,
0x00005900ff657624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000107919ULL, 0x000e680000002600ULL, 0x0000000000147919ULL, 0x000e680000002300ULL,
0x00000000000a7919ULL, 0x000e620000002100ULL, 0x0000000500057308ULL, 0x010f240000001000ULL,
0x0ffffffe05087810ULL, 0x010fc40007ffe0ffULL, 0x00000005ff117819ULL, 0x002fc8000001160aULL,
0x0000000800097305ULL, 0x000324000021f000ULL, 0x00001fff11117589ULL, 0x000fe200000e0000ULL,
0x000000ffff087224ULL, 0x002fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x010fc800078e0a09ULL,
0x000059000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b09097227ULL, 0x000fcc00078e0008ULL,
0x00000400090b7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff027224ULL, 0x008fc800078e0a0bULL,
0x0000040002027624ULL, 0x000fca00078e0265ULL, 0x0000590002007a0cULL, 0x000fda0003f26070ULL,
0x8000590002021a10ULL, 0x000fe40007ffe0ffULL, 0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL,
0x0000590002007a0cULL, 0x000fda0003f46070ULL, 0x000000010b0b2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0bba12ULL, 0x000fc800078e33ffULL, 0x0000000b00027306ULL, 0x000e620000209000ULL,
0x000000ff0b00720cULL, 0x000fce0003f85070ULL, 0x0000000200027308ULL, 0x002e640000001000ULL,
0x0ffffffe02067810ULL, 0x002fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x0002e4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000070b057224ULL, 0x008fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a05ULL, 0x0000000507077227ULL, 0x000fe400078e0006ULL,
0x0000000000057919ULL, 0x000e680000002200ULL, 0x0000001007127227ULL, 0x000fc800078e00ffULL,
0x000000ffff027224ULL, 0x000fc800078e0a12ULL, 0x000000020b027224ULL, 0x000fca00078e0210ULL,
0x0000000b0200720cULL, 0x000fe20003fa6070ULL, 0x0000010014057a24ULL, 0x002fe400078e0205ULL,
0x00001fff14147589ULL, 0x000e6400000e0000ULL, 0x00000000050f7a24ULL, 0x000fd000078e020aULL,
0x0000000102025824ULL, 0x000fe200078e0a0bULL, 0x0000000112125810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0f00720cULL, 0x040fe40003f65270ULL, 0x0000000b0200720cULL, 0x000fe40003fc6070ULL,
0x0000000f0f00780cULL, 0x040fe40003f24070ULL, 0x0000007f0f00780cULL, 0x040fe40003f44070ULL,
0x000000030f00780cULL, 0x000fca0003fa4070ULL, 0x3fffff80ff06b424ULL, 0x000fe400078e00ffULL,
0x0000000112126810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff07b424ULL, 0x000fe200078e00ffULL,
0x0000000bff12c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff089424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL, 0x01260006ff00b388ULL, 0x0007e20000000a00ULL,
0x000000ffff027224ULL, 0x000fe200078e0a12ULL, 0x000000010f00780cULL, 0x000fe20003f64070ULL,
0xff317217ff0ea424ULL, 0x000fe200078e00ffULL, 0x012608080f009388ULL, 0x000fe20000008a00ULL,
0x000000020b107224ULL, 0x000fc400078e0210ULL, 0x3fffff80ff0ad424ULL, 0x000fe200078e00ffULL,
0x0124000e0f00a388ULL, 0x0009e20000004800ULL, 0x0000002010107824ULL, 0x000fe400078e00ffULL,
0x3fffff60ff06d424ULL, 0x008fe400078e00ffULL, 0x7fffff60ff07d424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0bd424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL,
0x012688060f00d388ULL, 0x000fe20000008a00ULL, 0x00005a00ff0e7624ULL, 0x010fc400078e00ffULL,
0x7fffffc0ff0db424ULL, 0x000fe200078e00ffULL, 0x0126a80a0f00d388ULL, 0x000fe20000008a00ULL,
0x000059000e0e7a24ULL, 0x000fc600078e02ffULL, 0x0126c80c0f00b388ULL, 0x000fe20000008a00ULL,
0x0000000100130824ULL, 0x004fe400078e0a03ULL, 0x00005800ff138624ULL, 0x000fe400078e00ffULL,
0x0000580004038a24ULL, 0x000fe400078e02ffULL, 0x00005a0013057a24ULL, 0x000fe400078e02ffULL,
0x0000000e037b7224ULL, 0x000fe400078e02ffULL, 0x0000000105007824ULL, 0x040fe200078e0a10ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000100500720cULL, 0x000fe20003f26070ULL,
0x00005a0012177a24ULL, 0x000fe200078e027bULL, 0x0000002000007817ULL, 0x000fc80003800000ULL,
0x000000ff007a7207ULL, 0x000fe20000800000ULL, 0x0000000414007824ULL, 0x002fc600078e0211ULL,
0x000000207a00780cULL, 0x000fe20003f05270ULL, 0x0000000400007824ULL, 0x000fd800078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a0000057b06ULL, 0x000e620000209000ULL,
0x00000000000f7919ULL, 0x000ea20000000000ULL, 0x000000ffff067224ULL, 0x000fcc00078e00ffULL,
0x0000000500057308ULL, 0x002e620000001000ULL, 0x00000004ff027819ULL, 0x004fc8000001160fULL,
0x0000000202097810ULL, 0x000fe20007ffe0ffULL, 0x00000001000a7824ULL, 0x000fe200078e0202ULL,
0x0ffffffe05077810ULL, 0x002fc60007ffe0ffULL, 0x00000001000b7824ULL, 0x000fc600078e0209ULL,
0x0000000700077305ULL, 0x000e62000021f000ULL, 0x00000001100c7824ULL, 0x000fe400078e020bULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d07057227ULL, 0x000fc800078e0006ULL, 0x0000000110067824ULL, 0x000fe400078e020aULL,
0x0000000c050d7227ULL, 0x000fc800078e00ffULL, 0x0000000605077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a07ULL, 0x000000ffff157224ULL, 0x000fe400078e0a0dULL,
0x00005a0005057a24ULL, 0x000fe400078e0206ULL, 0x00005a0015087a24ULL, 0x000fc600078e020cULL,
0x00005a0005007a0cULL, 0x000fe40003f06070ULL, 0x00005a0008007a0cULL, 0x000fd60003f46070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x00005a0008007a0cULL, 0x000fe40003f66070ULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff087a12ULL, 0x000fe400078e33ffULL,
0x000000007a057217ULL, 0x000fe40007800000ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x000000010d0d3810ULL, 0x000fe20007ffe0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a00ULL,
0x0000000708077207ULL, 0x000fe20004000000ULL, 0x000000010a007824ULL, 0x000fe200078e020fULL,
0x0000000d08087207ULL, 0x000fc40004000000ULL, 0x000000050200720cULL, 0x080fe20003f06070ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0a07ULL, 0x000000050900720cULL, 0x000fe20003f26070ULL,
0x000000ffff157224ULL, 0x000fe400078e0a08ULL, 0x00005a000d067a24ULL, 0x000fe400078e0206ULL,
0x00005a00150c7a24ULL, 0x000fe400078e020cULL, 0x0000000117067824ULL, 0x040fe400078e0206ULL,
0x00000001170d7824ULL, 0x000fc400078e020cULL, 0x0000000e07067224ULL, 0x080fe400078e0206ULL,
0x000000100f027824ULL, 0x000fe400078e00ffULL, 0x0000000e08087224ULL, 0x000fe400078e020dULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x000000f002057812ULL, 0x000fc600078ec0ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000000506067212ULL, 0x000fc600078efcffULL,
0x000000100a0d7824ULL, 0x000fe200078e00ffULL, 0x0000000508057212ULL, 0x000fe200078efcffULL,
0x000000010b0a7824ULL, 0x040fe200078e020fULL, 0x0000600006067a10ULL, 0x000fe20007f5e0ffULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00d007812ULL, 0x000fe400078ee200ULL,
0x0000600005087a10ULL, 0x000fe40007f7e0ffULL, 0xfffffff00b0a7812ULL, 0x000fe200078ee20aULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0x0000610007077a10ULL, 0x000fc400017fe4ffULL,
0x0000610009097a10ULL, 0x000fe20001ffe4ffULL, 0x000000100a0b7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e8000c101c46ULL,
0x00000000080b7faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a0000027b06ULL, 0x000e620000209000ULL, 0x00000000000f7919ULL, 0x000eae0000000000ULL,
0x0000000200027308ULL, 0x002e620000001000ULL, 0x000000000f007211ULL, 0x004fc800078fe0ffULL,
0x00000002000a7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe02067810ULL, 0x002fe20007ffe0ffULL,
0x0000000110027824ULL, 0x000fc600078e0200ULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fc800078e02ffULL, 0x0000000507087227ULL, 0x000fc800078e0006ULL,
0x0000000110077824ULL, 0x000fe400078e020aULL, 0x0000000208057227ULL, 0x000fc800078e00ffULL,
0x0000000708087227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x00005a0009067a24ULL, 0x000fe400078e0202ULL,
0x00005a000c097a24ULL, 0x000fe400078e0207ULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x00005a0006007a0cULL, 0x000fe40003f06070ULL, 0x00005a0009007a0cULL, 0x000fd60003f46070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x00005a0009007a0cULL, 0x000fe40003f66070ULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x0000000108082810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff067a12ULL, 0x000fc600078e33ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x0000000108083810ULL, 0x000fe40007ffe0ffULL,
0x0000000506057207ULL, 0x040fe40004000000ULL, 0x0000000806087207ULL, 0x000fc60004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a05ULL, 0x000000ffff067224ULL, 0x000fe400078e0a08ULL,
0x00005a0009027a24ULL, 0x000fe400078e0202ULL, 0x00005a0006077a24ULL, 0x000fe400078e0207ULL,
0x0000000117067824ULL, 0x040fe400078e0202ULL, 0x0000000117077824ULL, 0x000fc400078e0207ULL,
0x000000100f027824ULL, 0x000fe400078e00ffULL, 0x0000000e05067224ULL, 0x080fe400078e0206ULL,
0x0000000e08087224ULL, 0x000fe200078e0207ULL, 0x000000f0020b7812ULL, 0x000fe200078ec0ffULL,
0x0000010006067825ULL, 0x000fc800078e00ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000b06067212ULL, 0x000fc600078efcffULL, 0x0000000100057824ULL, 0x100fe200078e020fULL,
0x0000000b08087212ULL, 0x000fe200078efcffULL, 0x000000010a007824ULL, 0x000fe200078e020fULL,
0x0000600006067a10ULL, 0x000fe20007f1e0ffULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff00c057812ULL, 0x000fe400078ee205ULL, 0x0000600008087a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00b007812ULL, 0x000fe200078ee200ULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x0000610007077a10ULL, 0x000fc400007fe4ffULL, 0x0000610009097a10ULL, 0x000fe20000ffe4ffULL,
0x00000010000b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e8000b901c46ULL, 0x00000000080b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x0000000000007806ULL, 0x000fc600038e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000057300ULL, 0x000e7000000e0000ULL,
0x0000000000077309ULL, 0x000ea20000000000ULL, 0x000000060500720cULL, 0x002fe20003f02070ULL,
0x00000004ff057424ULL, 0x000fc400078e00ffULL, 0x000000ffff087224ULL, 0x004fe400078e0a07ULL,
0x0000680004067625ULL, 0x000fd000078e0005ULL, 0x01260408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01260000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006060e7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff1400720cULL, 0x000fe40003f05270ULL,
0x0000003f0e0d7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff0e147810ULL, 0x000fc40007ffe0ffULL,
0x00000006ff0d7819ULL, 0x000fe4000001160dULL, 0x00000008ff0c7819ULL, 0x000fca0000011614ULL,
0x0000ff8000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011611ULL,
0x00000003ff0a7424ULL, 0x000fe200078e00ffULL, 0x0001268811037811ULL, 0x000fe400078e18ffULL,
0x03ffffff0b087812ULL, 0x002fc800078ec0ffULL, 0x0000000d0800720cULL, 0x000fda0003f06070ULL,
0x0000000204008824ULL, 0x000fe400078e00ffULL, 0x00006a00ff078624ULL, 0x000fc800078e00ffULL,
0x00006a0000078624ULL, 0x000fe400078e0207ULL, 0xffffffffff007424ULL, 0x000fe400078e00ffULL,
0x0000000108068824ULL, 0x000fe200078e0207ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040a03ff738cULL, 0x0003e20000000000ULL, 0x0000660006068625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000606008981ULL, 0x000ea2000c1e1900ULL,
0x000001ff1400780cULL, 0x000fe20003f04070ULL, 0x0000004012097824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x002fe20000011611ULL, 0x00000080ff1b7424ULL, 0x000fe200078e00ffULL,
0x0000000003ff7f8cULL, 0x0003e6000c80043fULL, 0x000000200a847824ULL, 0x000fca00078e00ffULL,
0x0000002009137812ULL, 0x000fe200078ef884ULL, 0x0000590000007a24ULL, 0x004fc800078e02ffULL,
0x00000040001a7824ULL, 0x000fe200078e00ffULL, 0x0000000111007812ULL, 0x000fc600078ec0ffULL,
0x000064001a1a7625ULL, 0x000fe200078e001bULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x000000840e037217ULL, 0x002fe20007800000ULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x00000003ff067819ULL, 0x000fc6000001160fULL, 0x0000000103037824ULL, 0x000fe200078e0a84ULL,
0x0000000406157810ULL, 0x000fe20007ffe0ffULL, 0x0000000100147824ULL, 0x000fe200078e0206ULL,
0x0000000c06177810ULL, 0x000fe40007ffe0ffULL, 0x0000000003037217ULL, 0x000fe20007800000ULL,
0x0000000114077824ULL, 0x040fe400078e020fULL, 0x00000008141c7824ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fc400078e0a00ULL, 0x0000000100187824ULL, 0x000fe200078e0217ULL,
0xfffffff81c1c7812ULL, 0x000fe400078ee207ULL, 0x0000000806077810ULL, 0x040fe40007ffe0ffULL,
0x000000030600720cULL, 0x080fe20003f66070ULL, 0x0000000113067824ULL, 0x000fe200078e0214ULL,
0x000000030700720cULL, 0x080fe20003f26070ULL, 0x0000000100167824ULL, 0x000fe200078e0207ULL,
0x000000031500720cULL, 0x080fe20003f46070ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000000031700720cULL, 0x000fc60003f06070ULL, 0x0000000100147824ULL, 0x000fe200078e0215ULL,
0x0000007006197812ULL, 0x000fe200078ef802ULL, 0x0000000113177824ULL, 0x040fe400078e0218ULL,
0x0000000118067824ULL, 0x140fe400078e020fULL, 0x0000000818157824ULL, 0x000fe200078e00ffULL,
0x000000191a187210ULL, 0x000fe20007f9e0ffULL, 0x0000000113007824ULL, 0x000fe400078e0214ULL,
0x0000000114037824ULL, 0x040fe200078e020fULL, 0xfffffff815227812ULL, 0x000fe200078ee206ULL,
0x00000008141e7824ULL, 0x000fc400078e00ffULL, 0x0000000113147824ULL, 0x000fe400078e0216ULL,
0x000000011b197824ULL, 0x000fe200020e0607ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee203ULL,
0x0000008000067825ULL, 0x000fe200078e00ffULL, 0x0000e0000a037811ULL, 0x000fc600078e68ffULL,
0x0000000116137824ULL, 0x000fe200078e020fULL, 0x0000007006257812ULL, 0x000fe200078ef802ULL,
0x0000000816207824ULL, 0x000fe400078e00ffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee213ULL, 0x0000008017167825ULL, 0x000fe200078e00ffULL,
0x0000007014237812ULL, 0x000fc600078ef802ULL, 0x000000101c137824ULL, 0x100fe200078e0203ULL,
0x0000007016217812ULL, 0x000fe200078ef802ULL, 0x000000101e1d7824ULL, 0x100fe200078e0203ULL,
0x000000251a027210ULL, 0x000fe20007f9e0ffULL, 0x00000010201f7824ULL, 0x100fe200078e0203ULL,
0x000000231a067210ULL, 0x040fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018137faeULL, 0x0003e2000d901c46ULL, 0x000000211a147210ULL, 0x000fe20007fde0ffULL,
0x0000001022217824ULL, 0x000fe400078e0203ULL, 0x000000011b037824ULL, 0x000fc400020e0607ULL,
0x000000011b077824ULL, 0x040fe400028e0615ULL, 0x000000011b157824ULL, 0x000fe200030e0617ULL,
0x00000000021d7faeULL, 0x0003e8000d101c46ULL, 0x00000000061f7faeULL, 0x0003e8000c901c46ULL,
0x0000000014217faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001000007824ULL, 0x002fe200078e00ffULL, 0x0000e0000a257811ULL, 0x000fc800078e68ffULL,
0x000000000f007211ULL, 0x000fc800078fe8ffULL, 0x0000000c00187810ULL, 0x040fe20007ffe0ffULL,
0x0000000113067824ULL, 0x000fe200078e0200ULL, 0x0000000400147810ULL, 0x040fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e020fULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x0000000800167824ULL, 0x000fe200078e00ffULL, 0x0000007006197812ULL, 0x000fe200078ef802ULL,
0x0000000113177824ULL, 0x000fe400078e0218ULL, 0x0000000118067824ULL, 0x000fe200078e020fULL,
0xfffffff816037812ULL, 0x000fe200078ee203ULL, 0x00000008181d7824ULL, 0x000fe200078e00ffULL,
0x0000000800167810ULL, 0x000fe20007ffe0ffULL, 0x0000000114157824ULL, 0x000fe200078e020fULL,
0x000000191a187210ULL, 0x000fe20007f1e0ffULL, 0x00000008141c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d207812ULL, 0x000fe200078ee206ULL, 0x0000000113007824ULL, 0x000fc400078e0214ULL,
0x0000000113147824ULL, 0x000fe200078e0216ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee215ULL,
0x000000011b197824ULL, 0x000fe400000e0607ULL, 0x0000000116137824ULL, 0x040fe400078e020fULL,
0x00000008161e7824ULL, 0x000fe400078e00ffULL, 0x0000008000067825ULL, 0x000fc600078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee213ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000007006237812ULL, 0x000fc600078ef802ULL, 0x0000008017167825ULL, 0x000fe200078e00ffULL,
0x0000007014217812ULL, 0x000fc600078ef802ULL, 0x0000001003137824ULL, 0x100fe200078e0225ULL,
0x0000007016037812ULL, 0x000fe200078ef802ULL, 0x000000101c1d7824ULL, 0x100fe200078e0225ULL,
0x000000231a027210ULL, 0x000fe20007f1e0ffULL, 0x000000101e1f7824ULL, 0x100fe200078e0225ULL,
0x000000211a067210ULL, 0x000fe20007f3e0ffULL, 0x0000001020217824ULL, 0x000fe200078e0225ULL,
0x000000031a147210ULL, 0x000fe20007f5e0ffULL, 0x000000011b037824ULL, 0x040fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018137faeULL, 0x0003e2000b901c46ULL,
0x000000011b077824ULL, 0x000fc400008e0615ULL, 0x000000011b157824ULL, 0x000fe200010e0617ULL,
0x00000000021d7faeULL, 0x0003e8000b901c46ULL, 0x00000000061f7faeULL, 0x0003e8000b901c46ULL,
0x0000000014217faeULL, 0x0003e4000b901c46ULL, 0x0000000108087810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff227424ULL, 0x000fc600078e00ffULL, 0x0000000d0800720cULL, 0x000fda0003f06070ULL,
0x0000006000000947ULL, 0x000fea0003800000ULL, 0x0000000204007824ULL, 0x000fe400078e00ffULL,
0x00006a00ff037624ULL, 0x002fc800078e00ffULL, 0x00006a0000037624ULL, 0x000fc800078e0203ULL,
0x0000000103227824ULL, 0x000fc800078e0208ULL, 0x0000660022227625ULL, 0x000fcc00078e0005ULL,
0x0000000622227981ULL, 0x000324000c1e1900ULL, 0x000000000a0473c2ULL, 0x000ea200000e0000ULL,
0x000000ff0c00720cULL, 0x000fe20003f05270ULL, 0x000000080a027824ULL, 0x002fe200078e00ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x000126a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3d7224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff187f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126c80002027f8cULL, 0x000ea2000c80043fULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000d14000008947ULL, 0x000fea0003800000ULL, 0x0000000204077824ULL, 0x000fe200078e00ffULL,
0x000000010a797812ULL, 0x000fe200078ec0ffULL, 0x00006a00ff007624ULL, 0x000fc400078e00ffULL,
0x000000ffff187224ULL, 0x002fe400078e0019ULL, 0x000000ffff177224ULL, 0x004fe400078e0003ULL,
0x00006a0007077624ULL, 0x000fe400078e0200ULL, 0xff317217ff1a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff067224ULL, 0x000fe400078e00ffULL, 0x000000ffff6b7224ULL, 0x000fc400078e00ffULL,
0x000000ffff057224ULL, 0x004fca00078e0008ULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x0000000411047824ULL, 0x000fca00078e00ffULL, 0xfffffff804197812ULL, 0x000fca00078ec0ffULL,
0x0126cc0019047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804817ULL,
0x000126c819047810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000ff00000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c021c7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e03ULL, 0x003d09001c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1b7819ULL, 0x000fc8000001141dULL,
0x0000001c1b1b7211ULL, 0x000fca00078110ffULL, 0x000000ffff1c7224ULL, 0x000fca00000e061dULL,
0x000000021b1b7819ULL, 0x000fc8000000121cULL, 0x0000001b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126cc00191c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001011177824ULL, 0x000fe200078e00ffULL,
0x0000000106197810ULL, 0x000fe20007ffe0ffULL, 0x0000590022227a24ULL, 0x010fc600078e02ffULL,
0xffffffe017037812ULL, 0x000fe200078ec0ffULL, 0x0000004022027824ULL, 0x000fe200078e00ffULL,
0x0000000c1900720cULL, 0x000fc60003f26070ULL, 0x0000010006037824ULL, 0x000fca00078e0203ULL,
0x0000004003197810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff037424ULL, 0x000fc600078e00ffULL,
0x00000020191c7812ULL, 0x000fe200078ec0ffULL, 0x0000640002027625ULL, 0x000fc800078e0003ULL,
0x0000000109217824ULL, 0x000fe200078e021cULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x00000010171c7812ULL, 0x000fe200078ec0ffULL, 0x000000100f1d7824ULL, 0x000fe200078e00ffULL,
0x000000190e177217ULL, 0x000fe40007800000ULL, 0x00000003ff1b7819ULL, 0x000fe4000001160fULL,
0x000000701d2b7812ULL, 0x000fe200078ec0ffULL, 0x0000000117177824ULL, 0x000fe200078e0a19ULL,
0x000000041b207810ULL, 0x040fe20007ffe0ffULL, 0x000000011b1e7824ULL, 0x040fe200078e021cULL,
0x0000000c1b1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000001c17177217ULL, 0x000fe20007800000ULL,
0x000000011e197824ULL, 0x040fe400078e020fULL, 0x000000081e227824ULL, 0x000fe400078e00ffULL,
0x0000000117177824ULL, 0x100fe400078e0a1cULL, 0x000000011f267824ULL, 0x000fe200078e021cULL,
0xfffffff822197812ULL, 0x000fe400078ee219ULL, 0x000000081b227810ULL, 0x000fe20007ffe0ffULL,
0x0000000121237824ULL, 0x000fe200078e0226ULL, 0x000000172000720cULL, 0x0c0fe20003f66070ULL,
0x0000000120207824ULL, 0x100fe200078e021cULL, 0x000000172200720cULL, 0x0c0fe20003f46070ULL,
0x0000000122227824ULL, 0x000fe200078e021cULL, 0x000000171b00720cULL, 0x080fe20003f86070ULL,
0x00000001211c7824ULL, 0x000fe200078e021eULL, 0x000000171f00720cULL, 0x000fe20003f06070ULL,
0x00000001201b7824ULL, 0x000fc400078e020fULL, 0x0000000820287824ULL, 0x000fe400078e00ffULL,
0x00000001211e7824ULL, 0x040fe400078e0220ULL, 0x0000000121207824ULL, 0x000fe200078e0222ULL,
0xfffffff8281b7812ULL, 0x000fe200078ee21bULL, 0x0000000126217824ULL, 0x000fe400078e020fULL,
0x000000801c1c7825ULL, 0x000fc800078e00ffULL, 0x0000000122177824ULL, 0x000fe200078e020fULL,
0x0000002b1c297212ULL, 0x000fe200078efcffULL, 0x0000000826267824ULL, 0x000fe400078e00ffULL,
0x0000000822227824ULL, 0x000fe200078e00ffULL, 0x00000029021c7210ULL, 0x000fe20007fbe0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0xfffffff826257812ULL, 0x000fe400078ee221ULL,
0xfffffff822177812ULL, 0x000fe200078ee217ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000002b1e277212ULL, 0x000fc400078efcffULL, 0x0000f0000a267811ULL, 0x000fe200078e68ffULL,
0x0000008023227825ULL, 0x000fe200078e00ffULL, 0x00000027021e7210ULL, 0x000fe40007fde0ffULL,
0x0000002b20297212ULL, 0x080fe200078efcffULL, 0x00000001031d7824ULL, 0x040fe200028e061dULL,
0x0000002b22277212ULL, 0x000fe200078efcffULL, 0x00000001031f7824ULL, 0x000fe200030e061fULL,
0x0000002902207210ULL, 0x040fe20007fbe0ffULL, 0x0000001019197824ULL, 0x100fe200078e0226ULL,
0x0000002702027210ULL, 0x000fe20007fde0ffULL, 0x000000101b1b7824ULL, 0x000fc400078e0226ULL,
0x0000001017177824ULL, 0x100fe200078e0226ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c197faeULL, 0x0003e2000e101c46ULL, 0x0000000103217824ULL, 0x000fe400028e0621ULL,
0x0000001025257824ULL, 0x000fe200078e0226ULL, 0x000000001e1b7faeULL, 0x0003e2000d901c46ULL,
0x0000000103037824ULL, 0x000fc600030e0623ULL, 0x0000000020177faeULL, 0x0003e8000d101c46ULL,
0x0000000002257faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010171c7812ULL, 0x000fe200078ec0ffULL, 0x000000100f197824ULL, 0x040fe200078e00ffULL,
0x0000f0000a287811ULL, 0x000fe400078e68ffULL, 0x0000001c0f1c7211ULL, 0x000fe400078fe8ffULL,
0x00000070192b7812ULL, 0x000fc400078ec0ffULL, 0x000000081c207810ULL, 0x040fe20007ffe0ffULL,
0x000000011c177824ULL, 0x040fe200078e020fULL, 0x0000000c1c227810ULL, 0x040fe20007ffe0ffULL,
0x000000081c1e7824ULL, 0x000fe400078e00ffULL, 0x00000001211d7824ULL, 0x000fe400078e021cULL,
0x0000000822277824ULL, 0x000fe200078e00ffULL, 0xfffffff81e177812ULL, 0x000fe200078ee217ULL,
0x00000001201f7824ULL, 0x000fe200078e020fULL, 0x000000041c1e7810ULL, 0x000fe20007ffe0ffULL,
0x000000801d1c7825ULL, 0x000fc800078e00ffULL, 0x0000000121197824ULL, 0x040fe200078e021eULL,
0x0000002b1c237212ULL, 0x000fe200078efcffULL, 0x000000011e1b7824ULL, 0x040fe400078e020fULL,
0x000000081e267824ULL, 0x000fe400078e00ffULL, 0x00000001211e7824ULL, 0x040fe400078e0220ULL,
0x0000000121217824ULL, 0x000fe200078e0222ULL, 0xfffffff8261b7812ULL, 0x000fe200078ee21bULL,
0x00000001221c7824ULL, 0x000fe200078e020fULL, 0x0000002302227210ULL, 0x000fe20007f1e0ffULL,
0x0000000820207824ULL, 0x000fc400078e00ffULL, 0x0000001017177824ULL, 0x000fe200078e0228ULL,
0xfffffff827267812ULL, 0x000fe200078ee21cULL, 0x0000000103237824ULL, 0x000fe200000e061dULL,
0xfffffff820257812ULL, 0x000fe200078ee21fULL, 0x00000080191c7825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022177faeULL, 0x0003e2000b901c46ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000002b1c297212ULL, 0x000fc600078efcffULL,
0x0000008021207825ULL, 0x000fe200078e00ffULL, 0x0000002b1e277212ULL, 0x000fe400078efcffULL,
0x00000029021c7210ULL, 0x000fe20007f1e0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0228ULL,
0x0000002b20197212ULL, 0x000fe200078efcffULL, 0x0000001025257824ULL, 0x100fe200078e0228ULL,
0x00000027021e7210ULL, 0x040fe20007f5e0ffULL, 0x00000001031d7824ULL, 0x000fe200000e061dULL,
0x0000001902027210ULL, 0x000fe20007f7e0ffULL, 0x0000001026197824ULL, 0x000fc400078e0228ULL,
0x00000001031f7824ULL, 0x040fe200010e061fULL, 0x000000001c1b7faeULL, 0x0003e2000b901c46ULL,
0x0000000103037824ULL, 0x000fc600018e0621ULL, 0x000000001e257faeULL, 0x0003e8000b901c46ULL,
0x0000000002197faeULL, 0x0003e4000b901c46ULL, 0x0000000811287824ULL, 0x000fe200078e00ffULL,
0x00000001081c7810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff227424ULL, 0x000fc600078e00ffULL,
0xfffffff028197812ULL, 0x000fe400078ec0ffULL, 0x0000000d1c00720cULL, 0x000fe40003f06070ULL,
0x00000000190473c2ULL, 0x000e6200000e0000ULL, 0x0000001028027812ULL, 0x040fe400078ec0ffULL,
0xffffffe028037812ULL, 0x040fe400078ec0ffULL, 0x0000000828177812ULL, 0x000fcc00078ec0ffULL,
0x00000001071c8824ULL, 0x000fe400078e021cULL, 0x00000004ff1d8424ULL, 0x000fe200078e00ffULL,
0x0000000317037210ULL, 0x000fe40007ffe002ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000066001c1c8625ULL, 0x000fca00078e001dULL, 0x000000061c228981ULL, 0x000522000c1e1900ULL,
0x000126b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0126b000196e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126080003207f8cULL, 0x000664000c80043fULL, 0x00000000001c7805ULL, 0x000fc40000015200ULL,
0x01260c0003177984ULL, 0x000ee40000000800ULL, 0x8000000017ff7812ULL, 0x00afe40007804821ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c177210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1e7824ULL, 0x000fe200000e0e1dULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1e00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1e00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001141eULL,
0x0000001702027211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e061eULL,
0x0000000202027819ULL, 0x000fc80000001217ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011b1b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260c0003177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100f027824ULL, 0x000fe200078e00ffULL, 0x00000001ff787819ULL, 0x000fe2000001160fULL,
0x0000002011177824ULL, 0x000fe400078e00ffULL, 0xffffffffff857424ULL, 0x000fe200078e00ffULL,
0x0000007002027812ULL, 0x000fc400078ec0ffULL, 0xffffff8017177812ULL, 0x000fe400078ec0ffULL,
0x0000000c78787812ULL, 0x000fc800078ec0ffULL, 0x0000001778177210ULL, 0x000fca0007ffe002ULL,
0x01200000171b7984ULL, 0x000e680000000800ULL, 0x01220000171d7984ULL, 0x0006a20000000800ULL,
0x0000001a1b00720bULL, 0x002fe20003f1d000ULL, 0x00016b127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000177806ULL, 0x008fc800000e0100ULL, 0x000000ff1700720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fc400078e001aULL, 0x0000001fff877424ULL, 0x000fe400078e00ffULL,
0xffffffffff867424ULL, 0x000fca00078e00ffULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x000000110b00720cULL, 0x000fe40003f05270ULL, 0x0000001a1b00720bULL, 0x000fe20003f54000ULL,
0x00016ab27f007947ULL, 0x000fd8000b800000ULL, 0x00000000001c7806ULL, 0x000fc400010e0100ULL,
0x00000080111f8824ULL, 0x000fe200078e0202ULL, 0x0000001a1b237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000178208824ULL, 0x000fca00078e021fULL,
0x0124002320008388ULL, 0x0003e20000000800ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000001a231a7221ULL, 0x002fe20000010100ULL,
0x000000ff1cff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b1a1a7820ULL, 0x000fcc0000410000ULL, 0x0000001a001a7308ULL, 0x000e640000000800ULL,
0x0000001a24247220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x000fe2000001160fULL, 0x000169f27f007947ULL, 0x000fea000b800000ULL,
0x00001f271a267589ULL, 0x0002e400000e0000ULL, 0x000000262c2c7220ULL, 0x08cfe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x0000002644447220ULL, 0x080fe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080f277811ULL, 0x002fe200078ff0ffULL,
0x000168c27f007947ULL, 0x000fea000b800000ULL, 0x00001f271a267589ULL, 0x0002e400000e0000ULL,
0x000000262e2e7220ULL, 0x08cfe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x0000002646467220ULL, 0x080fe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00001cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000100f277811ULL, 0x002fe200078ff0ffULL, 0x000167927f007947ULL, 0x000fea000b800000ULL,
0x00001f271a267589ULL, 0x0002e400000e0000ULL, 0x000000264c4c7220ULL, 0x08cfe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x0000002664647220ULL, 0x080fe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002668687220ULL, 0x080fe20000410000ULL,
0x0000002669697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000001cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000180f277811ULL, 0x002fe200078ff0ffULL, 0x000166727f007947ULL, 0x000fea000b800000ULL,
0x00001f271a267589ULL, 0x0002e400000e0000ULL, 0x000000264e4e7220ULL, 0x08cfe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x0000002666667220ULL, 0x080fe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x000000266a6a7220ULL, 0x080fe20000410000ULL,
0x000000266b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000001c17ff7212ULL, 0x000fda00078030ffULL, 0x800000231b1b0221ULL, 0x000fe20000010000ULL,
0x00007610ff1e0816ULL, 0x000fc6000000001eULL, 0x3fb8aa3b1b1b0820ULL, 0x000fc80000410000ULL,
0x0000001b00000308ULL, 0x000e640000000800ULL, 0x000000001d1d0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000241d247221ULL, 0x004fc20000010000ULL,
0x00000000001a7805ULL, 0x000fcc0000015200ULL, 0x0126ac0019177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804818ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c1a1c7210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e1bULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff177819ULL, 0x000fc8000001141dULL, 0x0000001c17177211ULL, 0x000fca00078110ffULL,
0x000000ffff1c7224ULL, 0x000fca00000e061dULL, 0x0000000217177819ULL, 0x000fc8000000121cULL,
0x000000170000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126ac0019177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099101e177816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff1700720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000ff13723eULL, 0x000fe400000010ffULL,
0x00000002ff177819ULL, 0x000fe4000001160fULL, 0x0000541013167816ULL, 0x000fe20000000013ULL,
0x000162627f007947ULL, 0x000fea000b800000ULL, 0x00001f1716137589ULL, 0x0002a400000e0000ULL,
0x0000000817277810ULL, 0x002fe20007ffe0ffULL, 0x000162927f007947ULL, 0x000fea000b800000ULL,
0x0000001017157810ULL, 0x000fe20007ffe0ffULL, 0x00001f2716147589ULL, 0x0002ea00000e0000ULL,
0x00001f1516157589ULL, 0x0002a400000e0000ULL, 0x0000001817277810ULL, 0x002fe20007ffe0ffULL,
0x000162e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2716167589ULL, 0x0002e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000211257824ULL, 0x000fe200078e00ffULL,
0x000000080f187812ULL, 0x000fe200078ec0ffULL, 0x0000000411207824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000400111b7824ULL, 0x000fe200078e00ffULL,
0x00000004251e7812ULL, 0x000fe200078ec0ffULL, 0x00001000111c7824ULL, 0x000fe200078e00ffULL,
0x0000000718177812ULL, 0x000fe200078ef80fULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x0000001e0f1a7211ULL, 0x000fc400078fe0ffULL, 0x0000000420207812ULL, 0x000fe200078ec0ffULL,
0x0000000817197824ULL, 0x000fe200078e00ffULL, 0xfffff0001b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000117187824ULL, 0x000fe200078e021aULL, 0x000000200f207211ULL, 0x000fe200078fe0ffULL,
0x0000000817277824ULL, 0x002fe200078e00ffULL, 0x0000a0001b217810ULL, 0x000fe40007ffe0ffULL,
0xfffffff819187812ULL, 0x000fe400078ee218ULL, 0x0000001017197812ULL, 0x000fc400078efcffULL,
0xffffe0001c1d7812ULL, 0x000fe200078ec0ffULL, 0x00000001171c7824ULL, 0x000fe400078e0220ULL,
0x000000011a1a7824ULL, 0x000fe200078e0219ULL, 0x0000e0001d1d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008191f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8271b7812ULL, 0x000fe200078ee21cULL,
0x0000001018747824ULL, 0x000fc600078e0221ULL, 0xfffffff81f1a7812ULL, 0x000fe200078ee21aULL,
0x000000101b7c7824ULL, 0x000fe400078e021dULL, 0x000000007474783bULL, 0x000e640000000200ULL,
0x000000101a707824ULL, 0x000fcc00078e0221ULL, 0x000000007070783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001374747231ULL, 0x086fe400003400ffULL,
0x0000001376767231ULL, 0x000fe400003400ffULL, 0x0000001475757231ULL, 0x088fe400003400ffULL,
0x0000001477777231ULL, 0x000fe400003400ffULL, 0x0000001570707231ULL, 0x080fe400003400ffULL,
0x0000001572727231ULL, 0x000fc400003400ffULL, 0x0000001671717231ULL, 0x080fe400003400ffULL,
0x0000001673737231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0x000000021c1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x000000021e1e7812ULL, 0x000fe200078efcffULL,
0x00000ce000007945ULL, 0x000fe20003800000ULL, 0xfffffff81f1c7812ULL, 0x000fe400078ee21cULL,
0x0000001e0f1e7211ULL, 0x000fc600078fe0ffULL, 0x000000101c807824ULL, 0x000fcc00078e021dULL,
0x000000008080783bULL, 0x000ea20000004200ULL, 0x00000018ff6d7819ULL, 0x008fe4000001167eULL,
0x000000ff7d297812ULL, 0x000fe400078ec0ffULL, 0x00000018ff277819ULL, 0x000fe4000001167dULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x00000010ff1d7819ULL, 0x000fe4000001167cULL,
0x000000ff7c267812ULL, 0x000fc400078ec0ffULL, 0x00000018ff1f7819ULL, 0x000fe4000001167cULL,
0x0000ffff7c967812ULL, 0x000fe400078ec0ffULL, 0x00000010ff947819ULL, 0x104fe40000011682ULL,
0x000000ff82907812ULL, 0x040fe400078ec0ffULL, 0x00000018ff917819ULL, 0x000fe40000011682ULL,
0x0000ffff829c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff2a7819ULL, 0x000fe4000001167dULL,
0x0000ffff7d977812ULL, 0x000fe400078ec0ffULL, 0x00000010ff887819ULL, 0x000fe4000001167eULL,
0x000000ff7e7c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff7e987812ULL, 0x000fe400078ec0ffULL,
0x00000029ff29723eULL, 0x000fc400020006ffULL, 0x00000018ff827819ULL, 0x000fe40000011683ULL,
0x00000010ff897819ULL, 0x100fe2000001167fULL, 0x20000029ff6c7230ULL, 0x000fe20000004100ULL,
0x000000ff7f7e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001167fULL,
0x0000ffff7f997812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x000fc40000011680ULL,
0x000000ff808a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7f7819ULL, 0x000fe40000011680ULL,
0x0000ffff809a7812ULL, 0x000fe200078ec0ffULL, 0x2000006dff807230ULL, 0x000fe20000004100ULL,
0x00000027ff27723eULL, 0x000fe400020006ffULL, 0x000000ff1d1d7812ULL, 0x000fe400078ec0ffULL,
0x00000082ff6d723eULL, 0x000fc400020006ffULL, 0x0000007dff29723eULL, 0x000fe200020006ffULL,
0x20000027ff7d7230ULL, 0x000fe20000004100ULL, 0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL,
0x0000001fff1f723eULL, 0x000fe200020006ffULL, 0x20000029ff8b7230ULL, 0x000fe20000004100ULL,
0x0000001dff27723eULL, 0x000fe200020006ffULL, 0x2000006dff1d7230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x2000001fff2b7230ULL, 0x000fe20000004100ULL,
0x0000002aff6d723eULL, 0x000fe200020006ffULL, 0x20000027ff277230ULL, 0x000fe20000004100ULL,
0x00000008ff2a7819ULL, 0x000fc40000011696ULL, 0x00000026ff26723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x0000007eff1f723eULL, 0x000fe200020006ffULL,
0x2000007cff7e7230ULL, 0x000fe20000004100ULL, 0x0000002aff2a723eULL, 0x000fe200020006ffULL,
0x20000026ff267230ULL, 0x000fe20000004100ULL, 0x00000008ff7c7819ULL, 0x000fe40000011697ULL,
0x000000ff88887812ULL, 0x000fe200078ec0ffULL, 0x2000002aff2a7230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fc400020006ffULL, 0x000000ff83927812ULL, 0x000fe400078ec0ffULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff818f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8d7819ULL, 0x000fe20000011681ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fe40000011626ULL,
0x00000010ff277819ULL, 0x000fc40000011627ULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff2b7819ULL, 0x000fe2000001162bULL,
0x20000092ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff2a7819ULL, 0x000fe4000001162aULL, 0x00000010ff8e7819ULL, 0x000fc40000011681ULL,
0x0000ffff819b7812ULL, 0x000fe200078ec0ffULL, 0x2000001fff817230ULL, 0x000fe20000004100ULL,
0x000000ff89897812ULL, 0x000fe400078ec0ffULL, 0x00000010ff957819ULL, 0x000fe40000011683ULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x0000008dff1f723eULL, 0x000fc400020006ffULL, 0x0000105427267816ULL, 0x000fe40000000026ULL,
0x000010546d277816ULL, 0x000fe2000000006cULL, 0x2000001fff937230ULL, 0x000fe20000004100ULL,
0x000010542b2a7816ULL, 0x000fe4000000002aULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x00000026742c723cULL, 0x082f62000004182cULL,
0x00000010ff6c7819ULL, 0x000fe2000001167dULL, 0x2000008aff8d7230ULL, 0x000fe20000004100ULL,
0x00000010ff2b7819ULL, 0x000fe2000001167cULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00000090ff29723eULL, 0x000fe200020006ffULL, 0x2000008fff907230ULL, 0x000fe20000004100ULL,
0x00000008ff927819ULL, 0x000fe2000001169bULL, 0x2000007fff8f7230ULL, 0x000fe20000004100ULL,
0x00000010ff7e7819ULL, 0x000fe2000001167eULL, 0x20000029ff297230ULL, 0x000fe20000004100ULL,
0x00000010ff6d7819ULL, 0x000fe20000011688ULL, 0x00000026704c723cULL, 0x000b62000004184cULL,
0x000000ff95957812ULL, 0x000fc400078ec0ffULL, 0x0000ffff83837812ULL, 0x000fe400078ec0ffULL,
0x00000091ff1f723eULL, 0x000fe400020006ffULL, 0x00000008ff7f7819ULL, 0x000fe20000011698ULL,
0x0000000119267824ULL, 0x060fe200078e0220ULL, 0x000010546c2b7816ULL, 0x000fe2000000002bULL,
0x2000001fff1f7230ULL, 0x000fe20000004100ULL, 0x000000ff8c8c7812ULL, 0x000fe200078ec0ffULL,
0x0000000819277824ULL, 0x000fe200078e00ffULL, 0x000000ff8e917812ULL, 0x000fc400078ec0ffULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x0000002a7430723cULL, 0x080f620000041830ULL,
0x000010546d6c7816ULL, 0x000fe4000000007eULL, 0x00000095ff95723eULL, 0x000fe200020006ffULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000008ff8a7819ULL, 0x000fe40000011699ULL,
0x00000008ff8e7819ULL, 0x000fe2000001169aULL, 0x20000095ff957230ULL, 0x000fe20000004100ULL,
0x000000ff94947812ULL, 0x000fe200078ec0ffULL, 0x0000002a7050723cULL, 0x000b620000041850ULL,
0x00000008ff7e7819ULL, 0x000fc4000001169cULL, 0x00000008ff837819ULL, 0x000fe40000011683ULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x00000008172a7824ULL, 0x020fe200078e00ffULL, 0x00000010ff7d7819ULL, 0x000fe20000011680ULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fc400020006ffULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x20000091ff917230ULL, 0x000fe20000004100ULL,
0x00000010ff817819ULL, 0x000fe20000011681ULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fe20000011689ULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x0000007eff80723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fc400020006ffULL,
0x000010547c6d7816ULL, 0x000fe20000000081ULL, 0x20000080ff897230ULL, 0x000fe20000004100ULL,
0x00000010ff887819ULL, 0x000fe20000011693ULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000010ff817819ULL, 0x000fe40000011692ULL, 0x00000010ff827819ULL, 0x000fe20000011682ULL,
0x0000006c7434723cULL, 0x000f620000041834ULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x00000010ff7c7819ULL, 0x000fc4000001167fULL, 0x00000010ff7e7819ULL, 0x000fe4000001168dULL,
0x00000010ff7f7819ULL, 0x000fe2000001168cULL, 0x0000006c7054723cULL, 0x000f620000041854ULL,
0x0000105488817816ULL, 0x000fe40000000081ULL, 0x0000105495957816ULL, 0x000fe40000000082ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff8a7819ULL, 0x000fc4000001168aULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000010ff917819ULL, 0x000fe40000011691ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff807819ULL, 0x000fe4000001168eULL,
0x00000010ff297819ULL, 0x000fe40000011629ULL, 0x00000010ff947819ULL, 0x000fc40000011694ULL,
0x00000010ff827819ULL, 0x000fe2000001161fULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000010ff887819ULL, 0x000fe2000001161dULL,
0x00000001171d7824ULL, 0x100fe200078e021eULL, 0x00000010ff837819ULL, 0x000fe20000011683ULL,
0x00000001191e7824ULL, 0x000fe200078e021eULL, 0x000010547d7c7816ULL, 0x000fe4000000007cULL,
0x000010547f7e7816ULL, 0x000fc4000000007eULL, 0x000010548b7d7816ULL, 0x000fe4000000008aULL,
0x00001054917f7816ULL, 0x000fe40000000090ULL, 0x000010548f807816ULL, 0x000fe40000000080ULL,
0x0000105494947816ULL, 0x000fe20000000029ULL, 0x0000007c7438723cULL, 0x000f620000041838ULL,
0x0000105482827816ULL, 0x000fe40000000089ULL, 0x0000105488837816ULL, 0x000fc40000000083ULL,
0xfffffff82a1d7812ULL, 0x000fe400078ee21dULL, 0xfffffff81f1e7812ULL, 0x000fe200078ee21eULL,
0x0000007e743c723cULL, 0x000f62000004183cULL, 0x0000e0000a1f7811ULL, 0x000fe400078e68ffULL,
0xfffffff827207812ULL, 0x000fca00078ee226ULL, 0x000000807440723cULL, 0x040f700000041840ULL,
0x000000947444723cULL, 0x040f700000041844ULL, 0x000000827448723cULL, 0x000b6e0000041848ULL,
0x000000101d747824ULL, 0x120fe200078e0221ULL, 0x0000007c7058723cULL, 0x000b620000041858ULL,
0x000000101e217824ULL, 0x000fc800078e0221ULL, 0x000000007474783bULL, 0x000e640000000200ULL,
0x00000010207c7824ULL, 0x020fe200078e021fULL, 0x0000007e705c723cULL, 0x040f70000004185cULL,
0x000000807060723cULL, 0x040f700000041860ULL, 0x000000947064723cULL, 0x040f700000041864ULL,
0x000000827068723cULL, 0x000b640000041868ULL, 0x000000002170783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000001374747231ULL, 0x082fe400003400ffULL, 0x0000001376767231ULL, 0x000fc400003400ffULL,
0x0000001475757231ULL, 0x080fe400003400ffULL, 0x0000001477777231ULL, 0x000fe400003400ffULL,
0x0000001570707231ULL, 0x088fe400003400ffULL, 0x0000001572727231ULL, 0x000fe400003400ffULL,
0x0000001671717231ULL, 0x080fe400003400ffULL, 0x0000001673737231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007c7c783bULL, 0x000ea20000004200ULL,
0x00000008192a7824ULL, 0x000fe200078e00ffULL, 0x0000000226217810ULL, 0x004fc40007ffe0ffULL,
0xfffffff825257812ULL, 0x000fe400078ec0ffULL, 0xfffffff82a217812ULL, 0x000fca00078ee221ULL,
0x0000001021807824ULL, 0x000fcc00078e021fULL, 0x000000008080783bULL, 0x000ea20000004200ULL,
0x00000010ff267819ULL, 0x100fe4000001167cULL, 0x000000ff7d2a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff277819ULL, 0x000fe4000001167cULL, 0x000000ff26267812ULL, 0x000fe400078ec0ffULL,
0x0000002aff6c723eULL, 0x000fe400020006ffULL, 0x00000027ff2a723eULL, 0x000fc400020006ffULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x00000010ff2b7819ULL, 0x100fe4000001167dULL,
0x00000018ff6d7819ULL, 0x000fe4000001167dULL, 0x0000ffff7d9c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff7c297812ULL, 0x040fe400078ec0ffULL, 0x0000ffff7c9b7812ULL, 0x000fe200078ec0ffULL,
0x2000006cff7c7230ULL, 0x000fe20000004100ULL, 0x00000010ff7d7819ULL, 0x100fe2000001167eULL,
0x2000002aff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff7e897812ULL, 0x000fe200078ec0ffULL,
0x20000026ff2a7230ULL, 0x000fe20000004100ULL, 0x00000018ff887819ULL, 0x000fc4000001167eULL,
0x0000ffff7e9d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001167fULL,
0x000000ff2b2b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff267819ULL, 0x000fe4000001169bULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fc400020006ffULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x2000007eff907230ULL, 0x000fe20000004100ULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x000000ff81937812ULL, 0x004fe400078ec0ffULL,
0x00000010ff8b7819ULL, 0x000fe4000001167fULL, 0x000000ff7f8a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7f9e7812ULL, 0x000fe200078ec0ffULL, 0x2000006dff7f7230ULL, 0x000fe20000004100ULL,
0x00000010ff8f7819ULL, 0x000fc40000011680ULL, 0x000000ff80917812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8e7819ULL, 0x000fe40000011680ULL, 0x0000ffff809f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff7d7e7812ULL, 0x000fe200078ec0ffULL, 0x2000002bff7d7230ULL, 0x000fe20000004100ULL,
0x00000018ff807819ULL, 0x000fe20000011681ULL, 0x20000026ff2b7230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fc4000001169cULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000008ff267819ULL, 0x000fe2000001169eULL,
0x20000093ff957230ULL, 0x000fe20000004100ULL, 0x00000010ff927819ULL, 0x000fe20000011681ULL,
0x2000008aff8d7230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000080ff80723eULL, 0x000fc400020006ffULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x2000008eff947230ULL, 0x000fe20000004100ULL, 0x00000018ff967819ULL, 0x000fe40000011682ULL,
0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL, 0x00000026ff26723eULL, 0x000fe400020006ffULL,
0x0000ffff81a07812ULL, 0x000fe400078ec0ffULL, 0x000000ff92937812ULL, 0x000fc400078ec0ffULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x00000010ff987819ULL, 0x000fe40000011682ULL,
0x000000ff82817812ULL, 0x040fe200078ec0ffULL, 0x20000029ff277230ULL, 0x000fe20000004100ULL,
0x0000ffff82a17812ULL, 0x000fe200078ec0ffULL, 0x20000080ff827230ULL, 0x000fe20000004100ULL,
0x0000007eff8a723eULL, 0x000fe200020006ffULL, 0x2000006dff7e7230ULL, 0x000fe20000004100ULL,
0x00000008ff927819ULL, 0x000fc4000001169fULL, 0x00000018ff977819ULL, 0x000fe20000011683ULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000096ff80723eULL, 0x000fe400020006ffULL,
0x000000ff8b8e7812ULL, 0x000fe400078ec0ffULL, 0x0000008fff6d723eULL, 0x000fe200020006ffULL,
0x20000026ff8f7230ULL, 0x000fe20000004100ULL, 0x00000008ff8b7819ULL, 0x000fe2000001169dULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000008ff967819ULL, 0x000fc400000116a0ULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x00000092ff26723eULL, 0x000fe200020006ffULL,
0x2000006dff927230ULL, 0x000fe20000004100ULL, 0x00000097ff29723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x00000096ff97723eULL, 0x000fe200020006ffULL,
0x20000093ff967230ULL, 0x000fe20000004100ULL, 0x00000010ff997819ULL, 0x000fe20000011683ULL,
0x20000026ff937230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fe20000011627ULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff277819ULL, 0x000fe2000001162aULL,
0x20000097ff977230ULL, 0x000fe20000004100ULL, 0x00000010ff7c7819ULL, 0x000fe2000001167cULL,
0x20000088ff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff7d7819ULL, 0x000fc4000001167dULL,
0x000000ff839a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff98987812ULL, 0x000fe400078ec0ffULL,
0x000000ff99997812ULL, 0x000fe400078ec0ffULL, 0x0000ffff83837812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6d7819ULL, 0x000fe4000001166cULL, 0x00000010ff2a7819ULL, 0x000fc4000001162bULL,
0x0000105427267816ULL, 0x000fe40000000026ULL, 0x000010547d277816ULL, 0x000fe4000000007cULL,
0x00000010ff6c7819ULL, 0x000fe4000001167fULL, 0x00000010ff2b7819ULL, 0x000fe4000001167eULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x00000026742c723cULL, 0x002f62000004182cULL,
0x0000009aff88723eULL, 0x000fc400020006ffULL, 0x00000098ff98723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff897819ULL, 0x000fe20000011689ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fe2000001168aULL,
0x20000098ff987230ULL, 0x000fe20000004100ULL, 0x00000010ff7c7819ULL, 0x000fe2000001168bULL,
0x00000026704c723cULL, 0x008f62000004184cULL, 0x00000099ff99723eULL, 0x000fe400020006ffULL,
0x00000008ff7e7819ULL, 0x000fc400000116a1ULL, 0x00000008ff8b7819ULL, 0x000fe20000011683ULL,
0x20000099ff997230ULL, 0x000fe20000004100ULL, 0x000010546c2b7816ULL, 0x000fe4000000002bULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x000010548a6c7816ULL, 0x000fe40000000089ULL,
0x0000007eff89723eULL, 0x000fe200020006ffULL, 0x20000091ff917230ULL, 0x000fe20000004100ULL,
0x0000008bff8b723eULL, 0x000fc400020006ffULL, 0x00000010ff817819ULL, 0x000fe20000011681ULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff987819ULL, 0x000fe20000011698ULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff997819ULL, 0x000fe40000011699ULL, 0x00000010ff7d7819ULL, 0x000fe4000001168cULL,
0x00000010ff7e7819ULL, 0x000fc40000011691ULL, 0x00000010ff7f7819ULL, 0x000fe40000011692ULL,
0x0000105498987816ULL, 0x000fe40000000081ULL, 0x0000105499997816ULL, 0x000fe40000000088ULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000010ff957819ULL, 0x000fe20000011695ULL, 0x000000987444723cULL, 0x000f620000041844ULL,
0x00000010ff967819ULL, 0x000fc40000011696ULL, 0x00000010ff947819ULL, 0x000fe40000011694ULL,
0x00000010ff937819ULL, 0x000fe40000011693ULL, 0x00000010ff8a7819ULL, 0x000fe20000011682ULL,
0x000000987064723cULL, 0x000f620000041864ULL, 0x00000010ff837819ULL, 0x000fe40000011697ULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff897819ULL, 0x000fc40000011689ULL,
0x00000010ff887819ULL, 0x000fe40000011629ULL, 0x00000010ff817819ULL, 0x000fe4000001168bULL,
0x000010547d7c7816ULL, 0x000fe4000000007cULL, 0x000010547f7e7816ULL, 0x000fe4000000007eULL,
0x000010546d2a7816ULL, 0x000fe4000000002aULL, 0x00001054907d7816ULL, 0x000fc4000000008fULL,
0x00001054967f7816ULL, 0x000fe40000000095ULL, 0x0000105494827816ULL, 0x000fe20000000093ULL,
0x0000002a7430723cULL, 0x040f620000041830ULL, 0x000010548a837816ULL, 0x000fe40000000083ULL,
0x0000105480807816ULL, 0x000fe40000000089ULL, 0x0000105488817816ULL, 0x000fe40000000081ULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x0000007c7438723cULL, 0x000f620000041838ULL,
0x00000010ff6d7819ULL, 0x000fc6000001168dULL, 0x2000008eff8e7230ULL, 0x000fc80000004100ULL,
0x0000007e743c723cULL, 0x000f62000004183cULL, 0x00000010ff8e7819ULL, 0x000fc8000001168eULL,
0x000010548e6d7816ULL, 0x000fc6000000006dULL, 0x000000827440723cULL, 0x040f700000041840ULL,
0x000000807448723cULL, 0x000f700000041848ULL, 0x0000002a7050723cULL, 0x040f700000041850ULL,
0x0000007c7058723cULL, 0x040f700000041858ULL, 0x0000007e705c723cULL, 0x040f70000004185cULL,
0x000000827060723cULL, 0x040f700000041860ULL, 0x000000807068723cULL, 0x000f700000041868ULL,
0x0000006c7434723cULL, 0x080f700000041834ULL, 0x0000006c7054723cULL, 0x000b6e0000041854ULL,
0x000126c80a6c7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006c6c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126880025ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff297224ULL, 0x000fc600078e00ffULL,
0x0000000000267805ULL, 0x000fc80000015200ULL, 0x0000040004257984ULL, 0x004ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fc4000780486dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a262a7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e27ULL, 0x003d09002a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001142bULL,
0x0000002a25257211ULL, 0x000fca00078110ffULL, 0x000000ffff2a7224ULL, 0x000fca00000e062bULL,
0x0000000225257819ULL, 0x000fc8000000122aULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040004257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001011297824ULL, 0x000fe400078e00ffULL, 0x0000590022227a24ULL, 0x010fe400078e02ffULL,
0x00000080ff277424ULL, 0x000fe200078e00ffULL, 0xffffffe029257812ULL, 0x000fe200078ec0ffULL,
0x0000004022267824ULL, 0x000fc800078e00ffULL, 0x0000010006257824ULL, 0x000fe400078e0225ULL,
0x0000640026267625ULL, 0x000fc600078e0027ULL, 0x0000008025257810ULL, 0x000fc80007ffe0ffULL,
0x0000002025227812ULL, 0x000fca00078ec0ffULL, 0x0000000109727824ULL, 0x000fe200078e0222ULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x000000250e227217ULL, 0x000fe40007800000ULL,
0x0000001029297812ULL, 0x000fe400078ec0ffULL, 0x00000003ff2a7819ULL, 0x000fe2000001160fULL,
0x0000000122227824ULL, 0x000fc600078e0a25ULL, 0x000000042a6c7810ULL, 0x040fe20007ffe0ffULL,
0x000000012a257824ULL, 0x040fe200078e0229ULL, 0x0000002229227217ULL, 0x000fe40007800000ULL,
0x0000000c2a707810ULL, 0x000fe20007ffe0ffULL, 0x00000001252b7824ULL, 0x040fe400078e020fULL,
0x0000000825747824ULL, 0x000fe400078e00ffULL, 0x0000000122227824ULL, 0x100fe400078e0a29ULL,
0x0000000170757824ULL, 0x000fe200078e0229ULL, 0xfffffff874747812ULL, 0x000fc400078ee22bULL,
0x000000082a2b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000175777824ULL, 0x000fe200078e020fULL,
0x000000226c00720cULL, 0x0c0fe20003f66070ULL, 0x000000016c6c7824ULL, 0x000fe200078e0229ULL,
0x000000222a00720cULL, 0x080fe20003f86070ULL, 0x00000001252a7824ULL, 0x000fe200078e0272ULL,
0x000000222b00720cULL, 0x0c0fe20003f46070ULL, 0x000000016c257824ULL, 0x000fe200078e020fULL,
0x000000227000720cULL, 0x000fe20003f06070ULL, 0x000000086c767824ULL, 0x000fe400078e00ffULL,
0x000000012b6d7824ULL, 0x000fc400078e0229ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0xfffffff876227812ULL, 0x000fc600078ee225ULL, 0x000000016c6c7824ULL, 0x100fe200078e0272ULL,
0x000000022a257212ULL, 0x000fe200078efcffULL, 0x000000016d707824ULL, 0x040fe400078e0272ULL,
0x000000016d297824ULL, 0x040fe200078e020fULL, 0x00000025262a7210ULL, 0x000fe20007fbe0ffULL,
0x000000086d767824ULL, 0x000fe400078e00ffULL, 0x000000806c6c7825ULL, 0x000fc600078e00ffULL,
0xfffffff876767812ULL, 0x000fe200078ee229ULL, 0x0000000175727824ULL, 0x000fe200078e0272ULL,
0x000000026c257212ULL, 0x000fe200078efcffULL, 0x0000008070707825ULL, 0x000fc800078e00ffULL,
0x0000008072727825ULL, 0x000fe200078e00ffULL, 0x0000000270297212ULL, 0x000fc600078efcffULL,
0x00000001272b7824ULL, 0x000fe200028e062bULL, 0x00000025266c7210ULL, 0x000fe40007fbe0ffULL,
0x0000000272257212ULL, 0x000fe200078efcffULL, 0x0000000875727824ULL, 0x000fe400078e00ffULL,
0x00000001276d7824ULL, 0x040fe200028e066dULL, 0x0000002926707210ULL, 0x000fe20007fbe0ffULL,
0x0000001022297824ULL, 0x100fe200078e021fULL, 0x0000002526267210ULL, 0x000fe20007fde0ffULL,
0x0000001074257824ULL, 0x000fe200078e021fULL, 0xfffffff872727812ULL, 0x000fe200078ee277ULL,
0x0000000127717824ULL, 0x000fc400028e0671ULL, 0x0000000127277824ULL, 0x000fe200030e0673ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a257faeULL, 0x0003e2000e101c46ULL,
0x0000001076737824ULL, 0x100fe400078e021fULL, 0x0000001072757824ULL, 0x000fe200078e021fULL,
0x000000006c297faeULL, 0x0003e8000d901c46ULL, 0x0000000070737faeULL, 0x0003e8000d101c46ULL,
0x0000000026757faeULL, 0x0003e2000c101c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001029227812ULL, 0x000fc800078ec0ffULL, 0x000000220f227211ULL, 0x000fc800078fe8ffULL,
0x0000000822707810ULL, 0x040fe20007ffe0ffULL, 0x00000001222a7824ULL, 0x040fe200078e0272ULL,
0x00000004226c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000122257824ULL, 0x100fe400078e020fULL,
0x00000001702b7824ULL, 0x140fe400078e020fULL, 0x00000008707c7824ULL, 0x000fe400078e00ffULL,
0x0000000822747824ULL, 0x040fe200078e00ffULL, 0x0000000c22227810ULL, 0x000fe20007ffe0ffULL,
0x000000016c297824ULL, 0x000fe200078e020fULL, 0xfffffff87c7c7812ULL, 0x000fe200078ee22bULL,
0x000000086c767824ULL, 0x000fe200078e00ffULL, 0xfffffff874747812ULL, 0x000fe200078ee225ULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0xfffffff876767812ULL, 0x000fe200078ee229ULL,
0x000000016c6c7824ULL, 0x100fe200078e0272ULL, 0x000000022a257212ULL, 0x000fe200078efcffULL,
0x0000000170707824ULL, 0x100fe400078e0272ULL, 0x0000000122727824ULL, 0x000fe200078e0272ULL,
0x00000025262a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000122297824ULL, 0x040fe400078e020fULL,
0x0000000822227824ULL, 0x000fe400078e00ffULL, 0x000000806c6c7825ULL, 0x000fc600078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee229ULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000026c757212ULL, 0x000fc600078efcffULL, 0x0000008072727825ULL, 0x000fe200078e00ffULL,
0x0000000270297212ULL, 0x080fe400078efcffULL, 0x00000075266c7210ULL, 0x000fe20007f5e0ffULL,
0x00000001272b7824ULL, 0x040fe200000e062bULL, 0x0000000272257212ULL, 0x000fe200078efcffULL,
0x0000001022757824ULL, 0x000fe200078e021fULL, 0x0000002926707210ULL, 0x040fe20007f1e0ffULL,
0x00000001276d7824ULL, 0x000fe200010e066dULL, 0x0000002526267210ULL, 0x000fe20007f7e0ffULL,
0x0000001074257824ULL, 0x000fc400078e021fULL, 0x0000000127717824ULL, 0x040fe400000e0671ULL,
0x0000000127277824ULL, 0x000fe200018e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a257faeULL, 0x0003e2000b901c46ULL, 0x0000001076297824ULL, 0x100fe400078e021fULL,
0x000000107c737824ULL, 0x000fc600078e021fULL, 0x000000006c297faeULL, 0x0003e8000b901c46ULL,
0x0000000070737faeULL, 0x0003e8000b901c46ULL, 0x0000000026757faeULL, 0x0003e4000b901c46ULL,
0x00000000280473c2ULL, 0x000ea200000e0000ULL, 0x0000000208267810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff227424ULL, 0x000fc600078e00ffULL, 0x0000000d2600720cULL, 0x000fda0003f06070ULL,
0x0000000107268824ULL, 0x000fe400078e0226ULL, 0x00000004ff278424ULL, 0x000fe200078e00ffULL,
0xfffffff004047892ULL, 0x004fc6000f8ec03fULL, 0x0000660026268625ULL, 0x000fe200078e0027ULL,
0x000126a804057890ULL, 0x000fc8000fffe03fULL, 0x0000000626228981ULL, 0x000328000c1e1900ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126a800ff2a7f8cULL, 0x000ea2000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01262800036c7f8cULL, 0x000664000c80043fULL, 0x0000000000267805ULL, 0x002fc40000015200ULL,
0x01262c0003257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011429ULL,
0x0000002825257211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x0000000225257819ULL, 0x000fc80000001228ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01262c0003257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002011257824ULL, 0x000fca00078e00ffULL, 0xffffff8025257812ULL, 0x000fc800078ec0ffULL,
0x0000008002257810ULL, 0x000fca0007ffe025ULL, 0x0000000178257824ULL, 0x000fca00078e0225ULL,
0x0120000025287984ULL, 0x000e680000000800ULL, 0x0122000025297984ULL, 0x0006a20000000800ULL,
0x000000232800720bULL, 0x002fe20003f1d000ULL, 0x000139227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000707806ULL, 0x008fc800000e0100ULL, 0x000000ff7000720cULL, 0x000fe20003f05270ULL,
0x0000077000007945ULL, 0x000fe20003800000ULL, 0x00000001ff257424ULL, 0x000fd600078e00ffULL,
0x0000074000008947ULL, 0x000fea0003800000ULL, 0x000000010b267810ULL, 0x000fe40007ffe0ffULL,
0x000000232800720bULL, 0x000fe40003f54000ULL, 0x000000112600720cULL, 0x000fe20003f05270ULL,
0x000138e27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000717806ULL, 0x000fc400010e0100ULL,
0x0000008011278824ULL, 0x000fe200078e0202ULL, 0x0000002328258209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x0000000178268824ULL, 0x000fca00078e0227ULL,
0x0124002526008388ULL, 0x0003e20000000800ULL, 0x000000ff7100720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000002328267209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff71ff7812ULL, 0x000fc6000780c0ffULL,
0x0000002326257221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL,
0x0000002500737308ULL, 0x000e640000000800ULL, 0x0000007324247220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe2000001160fULL,
0x000138127f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000262c2c7220ULL, 0x08cfe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x0000002644447220ULL, 0x080fe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0071ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080f277811ULL, 0x002fe200078ff0ffULL, 0x000136e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2773267589ULL, 0x0002e400000e0000ULL, 0x000000262e2e7220ULL, 0x08cfe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x0000002646467220ULL, 0x080fe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000071ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000100f277811ULL, 0x002fe200078ff0ffULL,
0x000135b27f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000264c4c7220ULL, 0x08cfe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x0000002664647220ULL, 0x080fe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002668687220ULL, 0x080fe20000410000ULL, 0x0000002669697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000071ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000180f277811ULL, 0x002fe200078ff0ffULL,
0x000134927f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000264e4e7220ULL, 0x08cfe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x0000002666667220ULL, 0x080fe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x000000266a6a7220ULL, 0x080fe20000410000ULL, 0x000000266b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000007170ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff257424ULL, 0x000fe200078e00ffULL, 0x0000002328237209ULL, 0x000fd60007810000ULL,
0x8000002328280221ULL, 0x000fe20000010000ULL, 0x00007610ff250816ULL, 0x000fc60000000025ULL,
0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL, 0x0000002800000308ULL, 0x000e640000000800ULL,
0x0000000029290220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002429247221ULL, 0x004fc20000010000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000000811287824ULL, 0x000fca00078e00ffULL, 0xfffffff0286c7812ULL, 0x000fca00078ec0ffULL,
0x0126b4006c297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028266d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09006d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff287819ULL, 0x000fc80000011429ULL,
0x0000006d28287211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000228287819ULL, 0x000fc80000001229ULL, 0x000000280000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b4006c297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991025257816ULL, 0x000fc800000000ffULL, 0x000000ff2500720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000ff13723eULL, 0x000fe400000010ffULL,
0x00000002ff297819ULL, 0x000fe4000001160fULL, 0x0000541013167816ULL, 0x000fe20000000013ULL,
0x000130527f007947ULL, 0x000fea000b800000ULL, 0x00001f2916137589ULL, 0x0002a400000e0000ULL,
0x0000000829277810ULL, 0x002fe20007ffe0ffULL, 0x000130827f007947ULL, 0x000fea000b800000ULL,
0x0000001029157810ULL, 0x000fe20007ffe0ffULL, 0x00001f2716147589ULL, 0x0002ea00000e0000ULL,
0x00001f1516157589ULL, 0x0002a400000e0000ULL, 0x0000001829277810ULL, 0x002fe20007ffe0ffULL,
0x000130d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2716167589ULL, 0x0002e400000e0000ULL,
0x0000040011257824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100011267824ULL, 0x000fe200078e00ffULL, 0x0000013000007945ULL, 0x000fe40003800000ULL,
0xfffff00025257812ULL, 0x000fc400078ec0ffULL, 0xffffe00026267812ULL, 0x000fe400078ec0ffULL,
0x0000b00025257810ULL, 0x000fe40007ffe0ffULL, 0x0000f00026267810ULL, 0x000fc60007ffe0ffULL,
0x0000001018707824ULL, 0x100fe400078e0225ULL, 0x000000101a6c7824ULL, 0x000fe400078e0225ULL,
0x000000101b747824ULL, 0x000fe400078e0226ULL, 0x000000007070783bULL, 0x000e680000000200ULL,
0x000000006c6c783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000001370707231ULL, 0x086fe400003400ffULL, 0x0000001372727231ULL, 0x000fc400003400ffULL,
0x0000001471717231ULL, 0x088fe400003400ffULL, 0x0000001473737231ULL, 0x000fe400003400ffULL,
0x000000156c6c7231ULL, 0x080fe400003400ffULL, 0x000000156e6e7231ULL, 0x000fe400003400ffULL,
0x000000166d6d7231ULL, 0x080fe400003400ffULL, 0x000000166f6f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007474783bULL, 0x000ee20000004200ULL,
0x000000101c7c7824ULL, 0x000fe200078e0226ULL, 0x00000c2000007945ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000ea20000004200ULL, 0x00000018ff277819ULL, 0x00afc40000011674ULL,
0x000000ff778a7812ULL, 0x000fe400078ec0ffULL, 0x00000027ff27723eULL, 0x000fe400020006ffULL,
0x00000018ff837819ULL, 0x000fe40000011676ULL, 0x00000010ff267819ULL, 0x000fe40000011674ULL,
0x000000ff74287812ULL, 0x040fe400078ec0ffULL, 0x0000ffff74957812ULL, 0x000fe200078ec0ffULL,
0x20000027ff747230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fc400020006ffULL,
0x00000083ff27723eULL, 0x000fe400020006ffULL, 0x000000ff7d8f7812ULL, 0x004fe200078ec0ffULL,
0x2000008aff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff26267812ULL, 0x000fe200078ec0ffULL,
0x20000027ff8a7230ULL, 0x000fe20000004100ULL, 0x0000008fff27723eULL, 0x000fe400020006ffULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x00000010ff297819ULL, 0x000fe20000011675ULL,
0x20000027ff937230ULL, 0x000fe20000004100ULL, 0x000000ff75817812ULL, 0x000fe200078ec0ffULL,
0x20000026ff277230ULL, 0x000fe20000004100ULL, 0x00000010ff827819ULL, 0x000fc40000011676ULL,
0x000000ff76887812ULL, 0x040fe400078ec0ffULL, 0x0000ffff769a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff897819ULL, 0x100fe40000011677ULL, 0x00000018ff767819ULL, 0x000fe40000011677ULL,
0x0000ffff779b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff777819ULL, 0x000fc4000001167cULL,
0x000000ff29297812ULL, 0x000fe400078ec0ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000008ff267819ULL, 0x000fe40000011695ULL, 0x000000ff7e927812ULL, 0x000fe400078ec0ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000077ff77723eULL, 0x000fc400020006ffULL,
0x00000029ff29723eULL, 0x000fe200020006ffULL, 0x20000076ff8e7230ULL, 0x000fe20000004100ULL,
0x00000018ff807819ULL, 0x000fe40000011675ULL, 0x0000ffff75997812ULL, 0x000fe200078ec0ffULL,
0x20000081ff757230ULL, 0x000fe20000004100ULL, 0x00000026ff26723eULL, 0x000fe400020006ffULL,
0x00000010ff8d7819ULL, 0x000fe4000001167cULL, 0x000000ff7c8c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff7c9c7812ULL, 0x000fe400078ec0ffULL, 0x00000092ff81723eULL, 0x000fe200020006ffULL,
0x20000077ff927230ULL, 0x000fe20000004100ULL, 0x00000018ff7c7819ULL, 0x000fe2000001167dULL,
0x20000029ff777230ULL, 0x000fe20000004100ULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x20000026ff297230ULL, 0x000fe20000004100ULL, 0x00000008ff767819ULL, 0x000fe20000011699ULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000018ff917819ULL, 0x000fc4000001167eULL,
0x00000008ff267819ULL, 0x000fe4000001169bULL, 0x00000010ff907819ULL, 0x000fe4000001167dULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x0000ffff7d9d7812ULL, 0x000fe200078ec0ffULL,
0x20000080ff7d7230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000007cff967230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fc400020006ffULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000088ff837230ULL, 0x000fe20000004100ULL,
0x000000ff7f947812ULL, 0x000fe200078ec0ffULL, 0x2000008cff8f7230ULL, 0x000fe20000004100ULL,
0x00000091ff80723eULL, 0x000fe200020006ffULL, 0x20000076ff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL, 0x00000026ff26723eULL, 0x000fe200020006ffULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x000000ff90917812ULL, 0x000fc400078ec0ffULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000008ff907819ULL, 0x000fe4000001169cULL,
0x00000094ff88723eULL, 0x000fe200020006ffULL, 0x20000028ff287230ULL, 0x000fe20000004100ULL,
0x000000ff82827812ULL, 0x000fe400078ec0ffULL, 0x000000ff898c7812ULL, 0x000fe200078ec0ffULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x0000008dff76723eULL, 0x000fe200020006ffULL,
0x20000026ff8d7230ULL, 0x000fe20000004100ULL, 0x00000008ff947819ULL, 0x000fc4000001169dULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000090ff26723eULL, 0x000fe200020006ffULL,
0x20000076ff907230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000094ff95723eULL, 0x000fe200020006ffULL,
0x20000091ff947230ULL, 0x000fe20000004100ULL, 0x00000010ff977819ULL, 0x000fe2000001167eULL,
0x20000026ff917230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fe20000011628ULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff767819ULL, 0x000fe20000011675ULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff277819ULL, 0x000fe20000011627ULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x0000ffff7e9e7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff897819ULL, 0x000fe4000001169aULL, 0x00000010ff757819ULL, 0x000fe40000011674ULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff287819ULL, 0x000fe40000011629ULL,
0x00000010ff987819ULL, 0x100fe4000001167fULL, 0x00000018ff7e7819ULL, 0x000fc4000001167fULL,
0x000000ff97977812ULL, 0x000fe400078ec0ffULL, 0x0000ffff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x0000105427267816ULL, 0x000fe40000000026ULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x0000105477277816ULL, 0x000fe40000000076ULL, 0x0000105475287816ULL, 0x000fe20000000028ULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff747819ULL, 0x000fc4000001167dULL,
0x00000010ff297819ULL, 0x000fe2000001167cULL, 0x00000026702c723cULL, 0x080f62000004182cULL,
0x00000097ff97723eULL, 0x000fe400020006ffULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff757819ULL, 0x000fe2000001168bULL, 0x20000097ff977230ULL, 0x000fe20000004100ULL,
0x00000010ff827819ULL, 0x000fe20000011682ULL, 0x000000266c4c723cULL, 0x000f62000004184cULL,
0x00000010ff8c7819ULL, 0x000fc4000001168cULL, 0x00000010ff777819ULL, 0x000fe4000001168aULL,
0x000000ff98987812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7c7819ULL, 0x000fe4000001169eULL,
0x00000008ff8a7819ULL, 0x000fe4000001167fULL, 0x0000105474297816ULL, 0x000fe40000000029ULL,
0x0000105482747816ULL, 0x000fc40000000083ULL, 0x000010548c757816ULL, 0x000fe40000000075ULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x000000287030723cULL, 0x040f620000041830ULL,
0x00000098ff98723eULL, 0x000fe400020006ffULL, 0x0000007cff82723eULL, 0x000fe200020006ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x0000008aff8c723eULL, 0x000fe200020006ffULL,
0x20000098ff987230ULL, 0x000fe20000004100ULL, 0x00000010ff767819ULL, 0x000fe20000011689ULL,
0x20000082ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff817819ULL, 0x000fe20000011681ULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fe20000011697ULL,
0x000000747034723cULL, 0x000f620000041834ULL, 0x00000010ff7c7819ULL, 0x000fc4000001168fULL,
0x00000010ff7d7819ULL, 0x000fe40000011690ULL, 0x000010548a8a7816ULL, 0x000fe40000000081ULL,
0x00000010ff8e7819ULL, 0x000fe2000001168eULL, 0x000000286c50723cULL, 0x000b620000041850ULL,
0x00000010ff8d7819ULL, 0x000fe4000001168dULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff947819ULL, 0x000fc40000011694ULL, 0x00000010ff7f7819ULL, 0x000fe20000011692ULL,
0x000000746c54723cULL, 0x000f620000041854ULL, 0x00000010ff827819ULL, 0x000fe40000011691ULL,
0x00000010ff967819ULL, 0x000fe40000011696ULL, 0x00000010ff837819ULL, 0x000fe40000011695ULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff8b7819ULL, 0x000fc40000011698ULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff817819ULL, 0x000fe4000001168cULL,
0x0000105477767816ULL, 0x000fe40000000076ULL, 0x000010547d7c7816ULL, 0x000fc4000000007cULL,
0x000010548e777816ULL, 0x000fe4000000008dULL, 0x00001054947d7816ULL, 0x000fe40000000093ULL,
0x000010547f827816ULL, 0x000fe40000000082ULL, 0x0000105496837816ULL, 0x000fe20000000083ULL,
0x000000767038723cULL, 0x000f620000041838ULL, 0x000010548b8b7816ULL, 0x000fe40000000088ULL,
0x0000105480807816ULL, 0x000fc40000000089ULL, 0x000010547e817816ULL, 0x000fe40000000081ULL,
0x000010001f287810ULL, 0x020fe20007ffe0ffULL, 0x0000007c703c723cULL, 0x000f68000004183cULL,
0x0000001020297824ULL, 0x000fc800078e0228ULL, 0x000000827040723cULL, 0x040f700000041840ULL,
0x0000008a7044723cULL, 0x040f700000041844ULL, 0x000000807048723cULL, 0x000b6e0000041848ULL,
0x000000101d707824ULL, 0x120fe200078e0225ULL, 0x000000766c58723cULL, 0x000f620000041858ULL,
0x000000101e257824ULL, 0x000fc800078e0225ULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x0000007c6c5c723cULL, 0x040f70000004185cULL, 0x000000826c60723cULL, 0x040f700000041860ULL,
0x0000008a6c64723cULL, 0x040f700000041864ULL, 0x000000806c68723cULL, 0x000b640000041868ULL,
0x00000000256c783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000001370707231ULL, 0x082fe400003400ffULL,
0x0000001372727231ULL, 0x000fc400003400ffULL, 0x0000001471717231ULL, 0x080fe400003400ffULL,
0x0000001473737231ULL, 0x000fe400003400ffULL, 0x000000156c6c7231ULL, 0x088fe400003400ffULL,
0x000000156e6e7231ULL, 0x000fe400003400ffULL, 0x000000166d6d7231ULL, 0x080fe400003400ffULL,
0x000000166f6f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000002974783bULL, 0x000ea20000004200ULL, 0x00000010217c7824ULL, 0x000fcc00078e0228ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000018ff267819ULL, 0x104fe40000011674ULL,
0x00000010ff257819ULL, 0x000fe40000011674ULL, 0x000000ff74277812ULL, 0x040fe400078ec0ffULL,
0x0000ffff74977812ULL, 0x000fe400078ec0ffULL, 0x00000010ff747819ULL, 0x000fe40000011675ULL,
0x000000ff75817812ULL, 0x000fc400078ec0ffULL, 0x00000018ff807819ULL, 0x000fe40000011675ULL,
0x0000ffff759a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff757819ULL, 0x000fe40000011676ULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x00000010ff8b7819ULL, 0x000fe40000011677ULL,
0x000000ff77887812ULL, 0x000fc400078ec0ffULL, 0x00000018ff837819ULL, 0x000fe40000011677ULL,
0x0000ffff779c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff7d917812ULL, 0x008fe400078ec0ffULL,
0x00000010ff8f7819ULL, 0x100fe4000001167cULL, 0x000000ff7c8e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff777819ULL, 0x000fc4000001167cULL, 0x0000ffff7c9d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff897819ULL, 0x000fe40000011676ULL, 0x000000ff76827812ULL, 0x040fe400078ec0ffULL,
0x0000ffff769b7812ULL, 0x000fe200078ec0ffULL, 0x20000026ff767230ULL, 0x000fe20000004100ULL,
0x00000010ff927819ULL, 0x100fe4000001167dULL, 0x00000018ff7c7819ULL, 0x000fc4000001167dULL,
0x0000ffff7d9e7812ULL, 0x000fe400078ec0ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000010ff987819ULL, 0x100fe4000001167eULL, 0x000000ff7e937812ULL, 0x040fe200078ec0ffULL,
0x20000075ff8c7230ULL, 0x000fe20000004100ULL, 0x00000018ff7d7819ULL, 0x000fe4000001167eULL,
0x0000ffff7e9f7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001167fULL,
0x00000091ff26723eULL, 0x000fe400020006ffULL, 0x000000ff25257812ULL, 0x000fe400078ec0ffULL,
0x0000007eff75723eULL, 0x000fe200020006ffULL, 0x20000026ff957230ULL, 0x000fe20000004100ULL,
0x00000025ff26723eULL, 0x000fe400020006ffULL, 0x000000ff74747812ULL, 0x000fe200078ec0ffULL,
0x20000075ff257230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fc400020006ffULL,
0x00000074ff75723eULL, 0x000fe200020006ffULL, 0x20000026ff747230ULL, 0x000fe20000004100ULL,
0x00000008ff267819ULL, 0x000fe20000011697ULL, 0x20000088ff8d7230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x00000026ff26723eULL, 0x000fe200020006ffULL, 0x20000077ff947230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x2000007cff887230ULL, 0x000fe20000004100ULL,
0x00000008ff777819ULL, 0x000fe2000001169aULL, 0x20000075ff7c7230ULL, 0x000fe20000004100ULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x20000026ff757230ULL, 0x000fe20000004100ULL,
0x00000008ff267819ULL, 0x000fe2000001169cULL, 0x20000082ff8a7230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x2000007dff7e7230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fc400020006ffULL, 0x000000ff7f967812ULL, 0x000fe200078ec0ffULL,
0x20000083ff907230ULL, 0x000fe20000004100ULL, 0x00000093ff82723eULL, 0x000fe200020006ffULL,
0x20000077ff7d7230ULL, 0x000fe20000004100ULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x00000026ff26723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x000000ff92937812ULL, 0x000fe400078ec0ffULL, 0x00000027ff27723eULL, 0x000fc400020006ffULL,
0x00000008ff927819ULL, 0x000fe4000001169dULL, 0x00000096ff83723eULL, 0x000fe200020006ffULL,
0x20000027ff277230ULL, 0x000fe20000004100ULL, 0x0000008fff77723eULL, 0x000fe200020006ffULL,
0x20000026ff8f7230ULL, 0x000fe20000004100ULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000000ff89897812ULL, 0x000fe400078ec0ffULL,
0x00000008ff967819ULL, 0x000fe2000001169eULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fc400020006ffULL, 0x00000092ff26723eULL, 0x000fe200020006ffULL,
0x20000077ff927230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000096ff97723eULL, 0x000fe200020006ffULL,
0x20000093ff967230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000026ff937230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fe20000011627ULL,
0x2000008eff917230ULL, 0x000fe20000004100ULL, 0x000000ff8b8e7812ULL, 0x000fe200078ec0ffULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff277819ULL, 0x000fe20000011674ULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000008ff8b7819ULL, 0x000fe2000001169bULL,
0x20000097ff977230ULL, 0x000fe20000004100ULL, 0x00000010ff747819ULL, 0x000fc40000011675ULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff757819ULL, 0x000fe4000001167dULL,
0x00000010ff997819ULL, 0x000fe4000001167fULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000010ff777819ULL, 0x000fe40000011676ULL, 0x00000010ff767819ULL, 0x000fe2000001168aULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff897819ULL, 0x000fc40000011689ULL,
0x0000105480757816ULL, 0x000fe40000000075ULL, 0x00000008ff807819ULL, 0x000fe4000001169fULL,
0x000000ff98987812ULL, 0x000fe400078ec0ffULL, 0x000000ff99997812ULL, 0x000fe400078ec0ffULL,
0x0000ffff7f7f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff817819ULL, 0x000fc40000011681ULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x0000105489767816ULL, 0x000fe40000000076ULL,
0x00000080ff89723eULL, 0x000fe400020006ffULL, 0x00000098ff98723eULL, 0x000fe400020006ffULL,
0x00000099ff99723eULL, 0x000fe400020006ffULL, 0x0000105427267816ULL, 0x000fe20000000026ULL,
0x20000098ff987230ULL, 0x000fe20000004100ULL, 0x00000008ff7f7819ULL, 0x000fe2000001167fULL,
0x20000099ff997230ULL, 0x000fe20000004100ULL, 0x000010547c277816ULL, 0x000fc40000000081ULL,
0x00000010ff7c7819ULL, 0x000fe2000001168bULL, 0x20000089ff8b7230ULL, 0x000fe20000004100ULL,
0x00000010ff7d7819ULL, 0x000fe4000001168cULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x00000026702c723cULL, 0x002f62000004182cULL, 0x00000010ff8a7819ULL, 0x000fe40000011688ULL,
0x00000010ff897819ULL, 0x000fe20000011697ULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x0000007fff8c723eULL, 0x000fc400020006ffULL, 0x000010548a897816ULL, 0x000fe20000000089ULL,
0x000000266c4c723cULL, 0x000b62000004184cULL, 0x00000010ff827819ULL, 0x000fe20000011682ULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff7f7819ULL, 0x000fe40000011698ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff8a7819ULL, 0x000fe40000011699ULL,
0x0000105477747816ULL, 0x000fc40000000074ULL, 0x00000010ff807819ULL, 0x000fe40000011691ULL,
0x00000010ff817819ULL, 0x000fe40000011692ULL, 0x000010547f827816ULL, 0x000fe20000000082ULL,
0x000000747030723cULL, 0x000f620000041830ULL, 0x000010548a837816ULL, 0x000fe40000000083ULL,
0x00000010ff777819ULL, 0x000fe4000001168dULL, 0x00000010ff8e7819ULL, 0x000fc4000001168eULL,
0x00000010ff907819ULL, 0x000fe20000011690ULL, 0x000000827044723cULL, 0x000f620000041844ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x00000010ff967819ULL, 0x000fe40000011696ULL, 0x00000010ff947819ULL, 0x000fe20000011694ULL,
0x000000746c50723cULL, 0x000f620000041850ULL, 0x00000010ff937819ULL, 0x000fc40000011693ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff8a7819ULL, 0x000fe20000011625ULL, 0x0000000211257824ULL, 0x000fe200078e00ffULL,
0x00000010ff7f7819ULL, 0x000fe2000001168cULL, 0x000000826c64723cULL, 0x000f620000041864ULL,
0x000010547d7c7816ULL, 0x000fe4000000007cULL, 0x0000105481807816ULL, 0x000fc40000000080ULL,
0x000010548e777816ULL, 0x000fe40000000077ULL, 0x00001054907d7816ULL, 0x000fe4000000008fULL,
0x0000105496817816ULL, 0x000fe40000000095ULL, 0x0000105494887816ULL, 0x000fe20000000093ULL,
0x000000767034723cULL, 0x000f620000041834ULL, 0x000010547e7e7816ULL, 0x000fe4000000008bULL,
0x000010548a7f7816ULL, 0x000fc4000000007fULL, 0xfffffff825267812ULL, 0x020fc600078ec0ffULL,
0x0000007c7038723cULL, 0x040f700000041838ULL, 0x00000080703c723cULL, 0x040f70000004183cULL,
0x000000887040723cULL, 0x040f700000041840ULL, 0x0000007e7048723cULL, 0x000f700000041848ULL,
0x000000766c54723cULL, 0x040f700000041854ULL, 0x0000007c6c58723cULL, 0x040f700000041858ULL,
0x000000806c5c723cULL, 0x040f70000004185cULL, 0x000000886c60723cULL, 0x040f700000041860ULL,
0x0000007e6c68723cULL, 0x000b6e0000041868ULL, 0x000126c80a6e7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006e6e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126900026ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff257224ULL, 0x000fc600078e00ffULL, 0x0000000000267805ULL, 0x004fc80000015200ULL,
0x00000400046d7984ULL, 0x000ea40000000800ULL, 0x800000006dff7812ULL, 0x006fc4000780486fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c26717210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6d7824ULL, 0x000fe200000e0e27ULL,
0x003d09007100780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c407100780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff6c7819ULL, 0x000fc8000001146dULL, 0x000000716c6c7211ULL, 0x000fca00078110ffULL,
0x000000ffff6d7224ULL, 0x000fca00000e066dULL, 0x000000026c6c7819ULL, 0x000fc8000000126dULL,
0x0000006c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400046d7984ULL, 0x000e640000000800ULL, 0x800000006dff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010116c7824ULL, 0x000fe400078e00ffULL,
0x0000590022227a24ULL, 0x010fe400078e02ffULL, 0x00000080ff277424ULL, 0x000fe200078e00ffULL,
0xffffffe06c257812ULL, 0x000fe200078ec0ffULL, 0x0000004022267824ULL, 0x000fc800078e00ffULL,
0x0000010006257824ULL, 0x000fe400078e0225ULL, 0x0000640026267625ULL, 0x000fc600078e0027ULL,
0x000000c025257810ULL, 0x000fc80007ffe0ffULL, 0x0000002025227812ULL, 0x000fca00078ec0ffULL,
0x0000000109727824ULL, 0x000fe200078e0222ULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x000000250e227217ULL, 0x000fe40007800000ULL, 0x000000106c6d7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff6c7819ULL, 0x000fe2000001160fULL, 0x0000000122227824ULL, 0x000fc600078e0a25ULL,
0x000000046c6f7810ULL, 0x040fe20007ffe0ffULL, 0x000000016c257824ULL, 0x040fe200078e026dULL,
0x000000226d227217ULL, 0x000fe40007800000ULL, 0x000000086c707810ULL, 0x040fe20007ffe0ffULL,
0x00000001256e7824ULL, 0x040fe200078e020fULL, 0x0000000c6c717810ULL, 0x000fe20007ffe0ffULL,
0x0000000825777824ULL, 0x000fe400078e00ffULL, 0x0000000122227824ULL, 0x100fe400078e0a6dULL,
0x0000000171747824ULL, 0x100fe200078e026dULL, 0xfffffff877777812ULL, 0x000fe200078ee26eULL,
0x000000016f6e7824ULL, 0x000fe200078e026dULL, 0x000000226c00720cULL, 0x080fe20003f86070ULL,
0x00000001256c7824ULL, 0x000fe200078e0272ULL, 0x000000226f00720cULL, 0x080fe20003f66070ULL,
0x000000016e257824ULL, 0x000fe200078e020fULL, 0x000000227000720cULL, 0x080fe20003f46070ULL,
0x000000086e767824ULL, 0x000fe200078e00ffULL, 0x000000227100720cULL, 0x000fe20003f06070ULL,
0x00000001706f7824ULL, 0x000fc400078e026dULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0xfffffff8767d7812ULL, 0x000fc600078ee225ULL, 0x000000016e6e7824ULL, 0x100fe200078e0272ULL,
0x000000026c257212ULL, 0x000fe200078efcffULL, 0x000000016f707824ULL, 0x040fe400078e0272ULL,
0x000000016f227824ULL, 0x040fe200078e020fULL, 0x00000025266c7210ULL, 0x000fe20007fbe0ffULL,
0x000000086f7f7824ULL, 0x000fe400078e00ffULL, 0x000000806e6e7825ULL, 0x000fc600078e00ffULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee222ULL, 0x0000000174727824ULL, 0x000fe200078e0272ULL,
0x000000026e257212ULL, 0x000fe200078efcffULL, 0x0000008070707825ULL, 0x000fc800078e00ffULL,
0x0000008072727825ULL, 0x000fe200078e00ffULL, 0x0000000270757212ULL, 0x000fc600078efcffULL,
0x00000001276d7824ULL, 0x040fe200028e066dULL, 0x00000025266e7210ULL, 0x000fe20007fbe0ffULL,
0x0000000174227824ULL, 0x000fe200078e020fULL, 0x0000000272257212ULL, 0x000fe200078efcffULL,
0x0000000874817824ULL, 0x000fe400078e00ffULL, 0x00000001276f7824ULL, 0x000fe200028e066fULL,
0x0000007526707210ULL, 0x040fe20007fbe0ffULL, 0x000000107f757824ULL, 0x100fe200078e0228ULL,
0x0000002526267210ULL, 0x000fe20007fde0ffULL, 0x0000001077257824ULL, 0x000fe200078e0228ULL,
0xfffffff881817812ULL, 0x000fe200078ee222ULL, 0x0000000127717824ULL, 0x000fc400028e0671ULL,
0x0000000127277824ULL, 0x000fe200030e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c257faeULL, 0x0003e2000e101c46ULL, 0x000000107d737824ULL, 0x100fe400078e0228ULL,
0x0000001081777824ULL, 0x000fc600078e0228ULL, 0x000000006e737faeULL, 0x0003e8000d901c46ULL,
0x0000000070757faeULL, 0x0003e8000d101c46ULL, 0x0000000026777faeULL, 0x0003e2000c101c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x000000106c6c7812ULL, 0x000fc800078ec0ffULL,
0x0000006c0f227211ULL, 0x000fc800078fe8ffULL, 0x00000004226e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000122257824ULL, 0x140fe200078e020fULL, 0x0000000822707810ULL, 0x040fe20007ffe0ffULL,
0x0000000822747824ULL, 0x000fe400078e00ffULL, 0x000000016e6c7824ULL, 0x040fe400078e020fULL,
0x000000086e7f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8747d7812ULL, 0x000fe200078ee225ULL,
0x00000001706d7824ULL, 0x040fe400078e020fULL, 0x0000000870767824ULL, 0x000fe200078e00ffULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee26cULL, 0x00000001226c7824ULL, 0x140fe200078e0272ULL,
0x0000000c22227810ULL, 0x000fe20007ffe0ffULL, 0x000000016e6e7824ULL, 0x000fe200078e0272ULL,
0xfffffff876817812ULL, 0x000fe200078ee26dULL, 0x000000806c6c7825ULL, 0x000fc800078e00ffULL,
0x0000000170707824ULL, 0x100fe200078e0272ULL, 0x000000026c257212ULL, 0x000fe200078efcffULL,
0x0000000122727824ULL, 0x000fe400078e0272ULL, 0x000000806e6e7825ULL, 0x000fe200078e00ffULL,
0x00000025266c7210ULL, 0x000fc60007f1e0ffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000026e777212ULL, 0x000fc600078efcffULL, 0x0000008072727825ULL, 0x000fe200078e00ffULL,
0x0000000270757212ULL, 0x080fe400078efcffULL, 0x00000077266e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000122747824ULL, 0x000fe200078e020fULL, 0x0000000272257212ULL, 0x000fe200078efcffULL,
0x0000000822837824ULL, 0x000fe400078e00ffULL, 0x00000001276d7824ULL, 0x040fe200000e066dULL,
0x0000007526707210ULL, 0x040fe20007f1e0ffULL, 0x00000001276f7824ULL, 0x000fe200010e066fULL,
0x0000002526267210ULL, 0x000fe20007f7e0ffULL, 0x000000107d257824ULL, 0x000fe200078e0228ULL,
0xfffffff883837812ULL, 0x000fe200078ee274ULL, 0x0000000127717824ULL, 0x000fc400000e0671ULL,
0x0000000127277824ULL, 0x000fe200018e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c257faeULL, 0x0003e2000b901c46ULL, 0x000000107f737824ULL, 0x100fe400078e0228ULL,
0x0000001081757824ULL, 0x100fe400078e0228ULL, 0x0000001083777824ULL, 0x000fe200078e0228ULL,
0x000000006e737faeULL, 0x0003e8000b901c46ULL, 0x0000000070757faeULL, 0x0003e8000b901c46ULL,
0x0000000026777faeULL, 0x0003e4000b901c46ULL, 0x0000000811257824ULL, 0x002fe200078e00ffULL,
0x0000000308267810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff227424ULL, 0x000fc600078e00ffULL,
0xfffffff025257812ULL, 0x000fe400078ec0ffULL, 0x0000000d2600720cULL, 0x000fe40003f06070ULL,
0x00000000250473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000000107268824ULL, 0x000fc400078e0226ULL, 0x00000004ff278424ULL, 0x000fc800078e00ffULL,
0x0000660026268625ULL, 0x000fca00078e0027ULL, 0x0000000626228981ULL, 0x000522000c1e1900ULL,
0x000126b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0126b000256e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126480003707f8cULL, 0x000664000c80043fULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x01264c0003257984ULL, 0x002e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006c7805ULL, 0x000fcc0000015200ULL, 0x0000006c266c7210ULL, 0x000fca0007f1e1ffULL,
0x000000016d6d7824ULL, 0x000fe200000e0e27ULL, 0x003d09006c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc8000001146dULL,
0x0000006c25257211ULL, 0x000fca00078110ffULL, 0x000000ffff6c7224ULL, 0x000fca00000e066dULL,
0x0000000225257819ULL, 0x000fc8000000126cULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01264c0003257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002011037824ULL, 0x008fca00078e00ffULL, 0xffffff8003037812ULL, 0x000fc800078ec0ffULL,
0x0000010002037810ULL, 0x000fca0007ffe003ULL, 0x0000000178037824ULL, 0x000fca00078e0203ULL,
0x0120000003707984ULL, 0x000e680000000800ULL, 0x0122000003717984ULL, 0x0006a20000000800ULL,
0x000000237000720bULL, 0x002fe20003f1d000ULL, 0x000109327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000727806ULL, 0x008fc800000e0100ULL, 0x000000ff7200720cULL, 0x000fe20003f05270ULL,
0x0000078000007945ULL, 0x000fe20003800000ULL, 0x00000001ff257424ULL, 0x000fe400078e00ffULL,
0x000000ffff037224ULL, 0x000fd200078e0023ULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x000000020b267810ULL, 0x000fe40007ffe0ffULL, 0x000000237000720bULL, 0x000fe40003f54000ULL,
0x000000112600720cULL, 0x000fe20003f05270ULL, 0x000108e27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000037806ULL, 0x000fc400010e0100ULL, 0x0000008011278824ULL, 0x000fe200078e0202ULL,
0x0000002370258209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000178268824ULL, 0x000fca00078e0227ULL, 0x0124002526008388ULL, 0x0003e20000000800ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002370267209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff03ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002326257221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL, 0x0000002500737308ULL, 0x000e640000000800ULL,
0x0000007324247220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x000fe2000001160fULL, 0x000108127f007947ULL, 0x000fea000b800000ULL,
0x00001f2773267589ULL, 0x0002e400000e0000ULL, 0x000000262c2c7220ULL, 0x08cfe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x0000002644447220ULL, 0x080fe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0003ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080f277811ULL, 0x002fe200078ff0ffULL,
0x000106e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000262e2e7220ULL, 0x08cfe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x0000002646467220ULL, 0x080fe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000003ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000100f277811ULL, 0x002fe200078ff0ffULL, 0x000105b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2773267589ULL, 0x0002e400000e0000ULL, 0x000000264c4c7220ULL, 0x08cfe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x0000002664647220ULL, 0x080fe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002668687220ULL, 0x080fe20000410000ULL,
0x0000002669697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000003ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000180f277811ULL, 0x002fe200078ff0ffULL, 0x000104927f007947ULL, 0x000fea000b800000ULL,
0x00001f2773267589ULL, 0x0002e400000e0000ULL, 0x000000264e4e7220ULL, 0x08cfe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x0000002666667220ULL, 0x080fe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x000000266a6a7220ULL, 0x080fe20000410000ULL,
0x000000266b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000000372ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff257424ULL, 0x000fe200078e00ffULL,
0x0000002370037209ULL, 0x000fd60007810000ULL, 0x8000000370700221ULL, 0x000fe20000010000ULL,
0x00007610ff250816ULL, 0x000fc60000000025ULL, 0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL,
0x0000007000000308ULL, 0x000e640000000800ULL, 0x0000000071710220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002471247221ULL, 0x004fc20000010000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000000811237824ULL, 0x000fca00078e00ffULL,
0xfffffff023707812ULL, 0x000fca00078ec0ffULL, 0x0126ac0070237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c266c7210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6d7824ULL, 0x000fe200000e0e27ULL,
0x003d09006c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc8000001146dULL, 0x0000006c23237211ULL, 0x000fca00078110ffULL,
0x000000ffff6c7224ULL, 0x000fca00000e066dULL, 0x0000000223237819ULL, 0x000fc8000000126cULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000171717810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126ac0070237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991025237816ULL, 0x000fc800000000ffULL,
0x000000ff2300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000000ff13723eULL, 0x000fe400000010ffULL, 0x00000002ff237819ULL, 0x000fe4000001160fULL,
0x0000541013167816ULL, 0x000fe20000000013ULL, 0x000100527f007947ULL, 0x000fea000b800000ULL,
0x00001f2316137589ULL, 0x0002a400000e0000ULL, 0x0000000823277810ULL, 0x002fe20007ffe0ffULL,
0x000100827f007947ULL, 0x000fea000b800000ULL, 0x0000001023157810ULL, 0x000fe20007ffe0ffULL,
0x00001f2716147589ULL, 0x0002ea00000e0000ULL, 0x00001f1516157589ULL, 0x0002a400000e0000ULL,
0x0000001823277810ULL, 0x002fe20007ffe0ffULL, 0x000100d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2716167589ULL, 0x0002e400000e0000ULL, 0x0000040011237824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100011257824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00023237812ULL, 0x000fc400078ec0ffULL,
0xffffe00025257812ULL, 0x000fe400078ec0ffULL, 0x0000c00023237810ULL, 0x000fe40007ffe0ffULL,
0x0000e00025257810ULL, 0x000fc60007ffe0ffULL, 0x0000001018187824ULL, 0x100fe400078e0223ULL,
0x000000101a1a7824ULL, 0x000fe400078e0223ULL, 0x000000101b7c7824ULL, 0x000fe200078e0225ULL,
0x000000001874783bULL, 0x0002e80000000200ULL, 0x000000001a70783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001374747231ULL, 0x08cfe400003400ffULL,
0x0000001376767231ULL, 0x000fc400003400ffULL, 0x0000001475757231ULL, 0x080fe400003400ffULL,
0x0000001477777231ULL, 0x000fe400003400ffULL, 0x0000001570707231ULL, 0x080fe400003400ffULL,
0x0000001572727231ULL, 0x000fe400003400ffULL, 0x0000001671717231ULL, 0x080fe400003400ffULL,
0x0000001673737231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000e620000004200ULL, 0x000000101c807824ULL, 0x000fe200078e0225ULL,
0x00000c1000007945ULL, 0x000fea0003800000ULL, 0x000000008080783bULL, 0x000ee20000004200ULL,
0x000000ff7c1c7812ULL, 0x002fc400078ec0ffULL, 0x000000ff7d257812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001167eULL, 0x0000001cff1c723eULL, 0x000fe400020006ffULL,
0x00000010ff187819ULL, 0x100fe4000001167cULL, 0x00000018ff1a7819ULL, 0x000fe4000001167cULL,
0x0000ffff7c967812ULL, 0x000fc400078ec0ffULL, 0x00000010ff277819ULL, 0x100fe4000001167dULL,
0x00000018ff267819ULL, 0x000fe4000001167dULL, 0x0000ffff7d977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6d7819ULL, 0x000fe4000001167eULL, 0x000000ff7e7c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7e987812ULL, 0x000fc400078ec0ffULL, 0x00000018ff7d7819ULL, 0x100fe4000001167fULL,
0x00000010ff887819ULL, 0x000fe4000001167fULL, 0x000000ff7f7e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7f997812ULL, 0x000fe400078ec0ffULL, 0x00000025ff2a723eULL, 0x000fe200020006ffULL,
0x2000001cff257230ULL, 0x000fe20000004100ULL, 0x00000018ff7f7819ULL, 0x008fc40000011680ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x2000002aff2b7230ULL, 0x000fe20000004100ULL,
0x0000007dff1c723eULL, 0x000fe400020006ffULL, 0x000000ff27277812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8b7819ULL, 0x000fe20000011680ULL, 0x2000001cff8a7230ULL, 0x000fe20000004100ULL,
0x000000ff80897812ULL, 0x040fe400078ec0ffULL, 0x0000ffff809a7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8d7819ULL, 0x100fe40000011681ULL, 0x000000ff818c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff807819ULL, 0x000fe40000011681ULL, 0x0000ffff819b7812ULL, 0x000fe200078ec0ffULL,
0x2000006cff817230ULL, 0x000fe20000004100ULL, 0x000000ff828e7812ULL, 0x000fe400078ec0ffULL,
0x0000007fff7f723eULL, 0x000fc400020006ffULL, 0x0000001aff1a723eULL, 0x000fe400020006ffULL,
0x00000027ff6c723eULL, 0x000fe400020006ffULL, 0x0000008eff1c723eULL, 0x000fe200020006ffULL,
0x2000007fff8e7230ULL, 0x000fe20000004100ULL, 0x000000ff6d7f7812ULL, 0x000fe200078ec0ffULL,
0x2000001aff2a7230ULL, 0x000fe20000004100ULL, 0x00000026ff26723eULL, 0x000fe200020006ffULL,
0x2000006cff6d7230ULL, 0x000fe20000004100ULL, 0x0000007eff1a723eULL, 0x000fe200020006ffULL,
0x2000001cff1c7230ULL, 0x000fe20000004100ULL, 0x00000008ff6c7819ULL, 0x000fe20000011698ULL,
0x20000026ff7d7230ULL, 0x000fe20000004100ULL, 0x000000ff18187812ULL, 0x000fc400078ec0ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000010ff937819ULL, 0x100fe40000011682ULL,
0x00000018ff907819ULL, 0x000fe20000011682ULL, 0x20000080ff927230ULL, 0x000fe20000004100ULL,
0x0000ffff829c7812ULL, 0x000fe200078ec0ffULL, 0x2000001aff827230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000018ff26723eULL, 0x000fc400020006ffULL,
0x0000008cff1a723eULL, 0x000fe200020006ffULL, 0x2000006cff807230ULL, 0x000fe20000004100ULL,
0x00000018ff917819ULL, 0x000fe20000011683ULL, 0x20000026ff267230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x2000001aff8f7230ULL, 0x000fe20000004100ULL,
0x00000008ff277819ULL, 0x000fe40000011696ULL, 0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL,
0x2000007cff7e7230ULL, 0x000fe20000004100ULL, 0x00000008ff6c7819ULL, 0x000fc4000001169aULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000090ff1a723eULL, 0x000fe400020006ffULL,
0x00000027ff27723eULL, 0x000fe200020006ffULL, 0x20000091ff187230ULL, 0x000fe20000004100ULL,
0x00000008ff7c7819ULL, 0x000fe20000011697ULL, 0x2000001aff1a7230ULL, 0x000fe20000004100ULL,
0x00000008ff907819ULL, 0x000fe2000001169bULL, 0x20000027ff277230ULL, 0x000fe20000004100ULL,
0x0000008dff8d723eULL, 0x000fc400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000010ff947819ULL, 0x000fe20000011683ULL,
0x20000089ff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff83957812ULL, 0x000fe400078ec0ffULL,
0x00000010ff257819ULL, 0x000fe40000011625ULL, 0x00000010ff267819ULL, 0x000fc40000011626ULL,
0x0000ffff83837812ULL, 0x000fe400078ec0ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x00000090ff91723eULL, 0x000fe200020006ffULL, 0x2000008dff907230ULL, 0x000fe20000004100ULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x2000006cff8d7230ULL, 0x000fe20000004100ULL,
0x0000105426267816ULL, 0x000fe20000000025ULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff88887812ULL, 0x000fe200078ec0ffULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00000008ff897819ULL, 0x000fe20000011699ULL, 0x20000091ff917230ULL, 0x000fe20000004100ULL,
0x000000ff8b8b7812ULL, 0x000fc400078ec0ffULL, 0x000000ff93937812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6c7819ULL, 0x000fe4000001162bULL, 0x00000008ff257819ULL, 0x000fe4000001169cULL,
0x000000ff94947812ULL, 0x000fe400078ec0ffULL, 0x00000008ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff2b7819ULL, 0x000fc4000001162aULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff2a7819ULL, 0x000fe40000011627ULL, 0x00000095ff95723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000025ff25723eULL, 0x000fe200020006ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00000094ff94723eULL, 0x000fe200020006ffULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x20000025ff257230ULL, 0x000fe20000004100ULL, 0x000010546d277816ULL, 0x000fe2000000006cULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x000010542b2a7816ULL, 0x000fe2000000002aULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff6c7819ULL, 0x000fc4000001167dULL,
0x00000010ff2b7819ULL, 0x000fe2000001167cULL, 0x00000026742c723cULL, 0x080f62000004182cULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff7c7819ULL, 0x000fe20000011680ULL,
0x00000026704c723cULL, 0x004f62000004184cULL, 0x000010546c2b7816ULL, 0x000fc4000000002bULL,
0x000010547f6c7816ULL, 0x000fe4000000007eULL, 0x00001054817c7816ULL, 0x000fe4000000007cULL,
0x00000010ff7f7819ULL, 0x000fe2000001168fULL, 0x0000002a7430723cULL, 0x000f620000041830ULL,
0x00000010ff6d7819ULL, 0x000fe40000011682ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff8a7819ULL, 0x000fc4000001168aULL, 0x00000010ff7d7819ULL, 0x000fe20000011689ULL,
0x0000002a7050723cULL, 0x000f620000041850ULL, 0x00000010ff7e7819ULL, 0x000fe4000001168cULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff907819ULL, 0x000fe40000011690ULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x00000010ff8d7819ULL, 0x000fc4000001168dULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff8f7819ULL, 0x000fe40000011691ULL,
0x00000010ff1c7819ULL, 0x000fe4000001161cULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff817819ULL, 0x000fe40000011695ULL, 0x00000010ff947819ULL, 0x000fc40000011694ULL,
0x00000010ff1a7819ULL, 0x000fe4000001161aULL, 0x00000010ff257819ULL, 0x000fe40000011625ULL,
0x00000010ff187819ULL, 0x000fe40000011618ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00001054886d7816ULL, 0x000fe4000000006dULL, 0x000010548a7d7816ULL, 0x000fc4000000007dULL,
0x000010548b7e7816ULL, 0x000fe4000000007eULL, 0x00001054907f7816ULL, 0x000fe2000000007fULL,
0x0000006c7434723cULL, 0x040f620000041834ULL, 0x000010548e8e7816ULL, 0x000fe4000000008dULL,
0x00001054928f7816ULL, 0x000fe4000000008fULL, 0x0000105493807816ULL, 0x000fe4000000001cULL,
0x0000105494817816ULL, 0x000fe20000000081ULL, 0x0000007c7438723cULL, 0x000f620000041838ULL,
0x000010541a827816ULL, 0x000fc40000000025ULL, 0x0000105418837816ULL, 0x000fca0000000083ULL,
0x0000007e743c723cULL, 0x040f70000004183cULL, 0x0000008e7440723cULL, 0x040f700000041840ULL,
0x000000807444723cULL, 0x040f700000041844ULL, 0x000000827448723cULL, 0x000b6e0000041848ULL,
0x000000101d747824ULL, 0x120fe200078e0223ULL, 0x0000006c7054723cULL, 0x000f620000041854ULL,
0x000000101e237824ULL, 0x000fc800078e0223ULL, 0x000000007474783bULL, 0x000e660000000200ULL,
0x0000007c7058723cULL, 0x040b6e0000041858ULL, 0x00000010207c7824ULL, 0x020fe200078e021fULL,
0x0000007e705c723cULL, 0x040f70000004185cULL, 0x0000008e7060723cULL, 0x040f700000041860ULL,
0x000000807064723cULL, 0x040f700000041864ULL, 0x000000827068723cULL, 0x000b640000041868ULL,
0x000000002370783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000001374747231ULL, 0x082fe400003400ffULL,
0x0000001376767231ULL, 0x000fc400003400ffULL, 0x0000001475757231ULL, 0x080fe400003400ffULL,
0x0000001477777231ULL, 0x000fe400003400ffULL, 0x0000001570707231ULL, 0x088fe400003400ffULL,
0x0000001572727231ULL, 0x000fe400003400ffULL, 0x0000001671717231ULL, 0x080fe400003400ffULL,
0x0000001673737231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007c7c783bULL, 0x000ea20000004200ULL, 0x0000001021807824ULL, 0x000fcc00078e021fULL,
0x000000008080783bULL, 0x000ee20000004200ULL, 0x000000ff7c1c7812ULL, 0x004fe400078ec0ffULL,
0x000000ff7d207812ULL, 0x000fe400078ec0ffULL, 0x0000001cff1c723eULL, 0x000fe400020006ffULL,
0x00000018ff277819ULL, 0x000fe4000001167eULL, 0x00000018ff6c7819ULL, 0x000fe4000001167fULL,
0x00000010ff237819ULL, 0x000fc4000001167dULL, 0x00000010ff187819ULL, 0x100fe4000001167cULL,
0x00000018ff1a7819ULL, 0x000fe4000001167cULL, 0x0000ffff7c937812ULL, 0x000fe400078ec0ffULL,
0x00000020ff25723eULL, 0x000fe200020006ffULL, 0x2000001cff207230ULL, 0x000fe20000004100ULL,
0x000000ff818b7812ULL, 0x008fe400078ec0ffULL, 0x00000018ff7c7819ULL, 0x000fe20000011680ULL,
0x20000025ff267230ULL, 0x000fe20000004100ULL, 0x00000027ff27723eULL, 0x000fc400020006ffULL,
0x0000006cff1c723eULL, 0x000fe400020006ffULL, 0x000000ff23237812ULL, 0x000fe400078ec0ffULL,
0x00000010ff887819ULL, 0x000fe40000011680ULL, 0x000000ff80897812ULL, 0x040fe400078ec0ffULL,
0x0000ffff80977812ULL, 0x000fe400078ec0ffULL, 0x000000ff828c7812ULL, 0x000fc400078ec0ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000010ff2a7819ULL, 0x000fe4000001167eULL,
0x000000ff7e2b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff7e957812ULL, 0x000fe200078ec0ffULL,
0x20000027ff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x100fe40000011681ULL,
0x00000018ff807819ULL, 0x000fc40000011681ULL, 0x0000ffff81987812ULL, 0x000fe400078ec0ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x00000010ff907819ULL, 0x100fe40000011682ULL,
0x00000018ff817819ULL, 0x000fe40000011682ULL, 0x0000ffff82997812ULL, 0x000fe200078ec0ffULL,
0x2000001cff827230ULL, 0x000fe20000004100ULL, 0x00000018ff217819ULL, 0x000fc4000001167dULL,
0x0000ffff7d947812ULL, 0x000fe400078ec0ffULL, 0x00000023ff27723eULL, 0x000fe400020006ffULL,
0x00000010ff7d7819ULL, 0x000fe4000001167fULL, 0x0000008cff1c723eULL, 0x000fe200020006ffULL,
0x2000008bff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff7d7d7812ULL, 0x000fe200078ec0ffULL,
0x2000007cff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff2a7c7812ULL, 0x000fe200078ec0ffULL,
0x20000027ff2a7230ULL, 0x000fe20000004100ULL, 0x0000001aff1a723eULL, 0x000fe200020006ffULL,
0x2000001cff1c7230ULL, 0x000fe20000004100ULL, 0x00000008ff277819ULL, 0x000fc40000011695ULL,
0x000000ff7f6d7812ULL, 0x000fe200078ec0ffULL, 0x2000001aff257230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x20000080ff8f7230ULL, 0x000fe20000004100ULL,
0x00000027ff27723eULL, 0x000fe200020006ffULL, 0x2000007dff807230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x20000021ff6c7230ULL, 0x000fe20000004100ULL,
0x0000006dff1a723eULL, 0x000fe200020006ffULL, 0x20000027ff7d7230ULL, 0x000fe20000004100ULL,
0x000000ff18187812ULL, 0x000fe200078ec0ffULL, 0x2000002bff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff838e7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff237819ULL, 0x000fe40000011693ULL,
0x00000018ff8d7819ULL, 0x000fe40000011683ULL, 0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff7f967812ULL, 0x000fe200078ec0ffULL, 0x2000001aff7f7230ULL, 0x000fe20000004100ULL,
0x00000018ff21723eULL, 0x000fe400020006ffULL, 0x00000008ff277819ULL, 0x000fc40000011697ULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x20000021ff217230ULL, 0x000fe20000004100ULL,
0x00000023ff23723eULL, 0x000fe400020006ffULL, 0x0000008dff1a723eULL, 0x000fe200020006ffULL,
0x2000008eff927230ULL, 0x000fe20000004100ULL, 0x00000008ff2b7819ULL, 0x000fe20000011694ULL,
0x20000023ff237230ULL, 0x000fe20000004100ULL, 0x00000008ff8d7819ULL, 0x000fe20000011698ULL,
0x2000001aff1a7230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fc400020006ffULL,
0x00000027ff27723eULL, 0x000fe400020006ffULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x0000008dff8e723eULL, 0x000fe200020006ffULL,
0x2000008aff8d7230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000027ff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff207819ULL, 0x000fe20000011620ULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x00000010ff277819ULL, 0x000fe20000011626ULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x000fe20000011621ULL,
0x20000081ff187230ULL, 0x000fe20000004100ULL, 0x00000010ff267819ULL, 0x000fe20000011625ULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x00000010ff2a7819ULL, 0x000fc4000001162aULL,
0x00000010ff237819ULL, 0x000fe40000011623ULL, 0x00000010ff917819ULL, 0x000fe40000011683ULL,
0x000000ff88887812ULL, 0x000fe400078ec0ffULL, 0x0000ffff83837812ULL, 0x000fe400078ec0ffULL,
0x0000105421207816ULL, 0x000fe40000000020ULL, 0x000010542a217816ULL, 0x000fc40000000027ULL,
0x0000105426267816ULL, 0x000fe40000000023ULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000008ff817819ULL, 0x000fe20000011696ULL, 0x00000020742c723cULL, 0x082b62000004182cULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff2a7819ULL, 0x000fe2000001166dULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff277819ULL, 0x000fe2000001162bULL,
0x00000020704c723cULL, 0x000b62000004184cULL, 0x00000010ff237819ULL, 0x000fc4000001167cULL,
0x000000ff91917812ULL, 0x000fe400078ec0ffULL, 0x000000ff90907812ULL, 0x000fe400078ec0ffULL,
0x00000008ff257819ULL, 0x000fe40000011699ULL, 0x00000008ff837819ULL, 0x000fe40000011683ULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x000010546c277816ULL, 0x000fc40000000027ULL,
0x00001054232a7816ULL, 0x000fe2000000002aULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x000000267430723cULL, 0x000b620000041830ULL, 0x00000010ff237819ULL, 0x000fe2000001167eULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x00000010ff6c7819ULL, 0x000fe2000001167dULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x00000025ff25723eULL, 0x000fc400020006ffULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x000000267050723cULL, 0x000b620000041850ULL,
0x00000010ff7f7819ULL, 0x000fe2000001167fULL, 0x20000025ff257230ULL, 0x000fe20000004100ULL,
0x00000010ff807819ULL, 0x000fe20000011680ULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00001054236c7816ULL, 0x000fe4000000006cULL, 0x00000010ff7c7819ULL, 0x000fe40000011689ULL,
0x00000010ff237819ULL, 0x000fc40000011688ULL, 0x00001054802b7816ULL, 0x000fe4000000007fULL,
0x00000010ff6d7819ULL, 0x000fe40000011681ULL, 0x00000010ff7d7819ULL, 0x000fe4000001168cULL,
0x00000010ff7e7819ULL, 0x000fe2000001168dULL, 0x0000002a7434723cULL, 0x000b620000041834ULL,
0x00001054237c7816ULL, 0x000fe4000000007cULL, 0x00000010ff8b7819ULL, 0x000fc4000001168bULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff7f7819ULL, 0x000fe20000011692ULL,
0x0000002a7054723cULL, 0x000b620000041854ULL, 0x00000010ff807819ULL, 0x000fe40000011691ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000010ff8e7819ULL, 0x000fc4000001168eULL, 0x00000010ff1c7819ULL, 0x000fe4000001161cULL,
0x00000010ff237819ULL, 0x000fe40000011690ULL, 0x00000010ff187819ULL, 0x000fe40000011618ULL,
0x00000010ff257819ULL, 0x000fe40000011625ULL, 0x00000010ff1a7819ULL, 0x000fe4000001161aULL,
0x00000010ff817819ULL, 0x000fc40000011683ULL, 0x000010547e7d7816ULL, 0x000fe4000000007dULL,
0x000010548b8a7816ULL, 0x000fe4000000008aULL, 0x00001054807f7816ULL, 0x000fe4000000007fULL,
0x00001054826d7816ULL, 0x000fe2000000006dULL, 0x0000007c743c723cULL, 0x000b62000004183cULL,
0x000010548f8b7816ULL, 0x000fe4000000008eULL, 0x00001054237e7816ULL, 0x000fc4000000001cULL,
0x0000105418807816ULL, 0x000fe20000000025ULL, 0x0000000211187824ULL, 0x000fe200078e00ffULL,
0x000010541a817816ULL, 0x000fe20000000081ULL, 0x0000006c7438723cULL, 0x000b620000041838ULL,
0x000126c80a257811ULL, 0x000fe400078e18ffULL, 0xfffffff8181a7812ULL, 0x000fca00078ec0ffULL,
0x0000008a7440723cULL, 0x040b700000041840ULL, 0x0000007e7444723cULL, 0x040b700000041844ULL,
0x000000807448723cULL, 0x000b700000041848ULL, 0x0000006c7058723cULL, 0x040b700000041858ULL,
0x0000007c705c723cULL, 0x040b70000004185cULL, 0x0000008a7060723cULL, 0x040b700000041860ULL,
0x0000007e7064723cULL, 0x040b700000041864ULL, 0x000000807068723cULL, 0x000b620000041868ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x00000000252a7f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x012698001aff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff187224ULL, 0x000fc600078e00ffULL,
0x0000000000207805ULL, 0x000fc80000015200ULL, 0x0000040025237984ULL, 0x000e620000000800ULL,
0x000000030b1a7810ULL, 0x008fc40007ffe0ffULL, 0x8000000023ff7812ULL, 0x006fe2000780482bULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002620237210ULL, 0x000fca0007f1e1ffULL,
0x0000000127267824ULL, 0x000fe200000e0e21ULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc80000011426ULL,
0x000000231c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e0626ULL,
0x000000021c1c7819ULL, 0x000fc80000001223ULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000040025237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000106237810ULL, 0x000fe40007ffe0ffULL,
0x0000000308087810ULL, 0x000fe40007ffe0ffULL, 0x0000000c2300720cULL, 0x000fda0003f06070ULL,
0x0000083000000947ULL, 0x000fea0003800000ULL, 0x0000000206217810ULL, 0x000fe20007ffe0ffULL,
0x0000010023237824ULL, 0x000fe400078e0284ULL, 0x0000590022227a24ULL, 0x010fe200078e02ffULL,
0x0000000c2100720cULL, 0x000fe20003f06070ULL, 0x00000080ff217424ULL, 0x000fe200078e00ffULL,
0x0000002023087812ULL, 0x000fe200078ec0ffULL, 0x0000004022207824ULL, 0x000fc800078e00ffULL,
0x00000001096c7824ULL, 0x000fe400078e0208ULL, 0x0000640020207625ULL, 0x000fc800078e0021ULL,
0x000003e000008947ULL, 0x000fea0003800000ULL, 0x000000230e087217ULL, 0x000fe20007800000ULL,
0x0000001011187824ULL, 0x000fc800078e00ffULL, 0x0000000108087824ULL, 0x000fe200078e0a23ULL,
0x0000001018237812ULL, 0x000fe400078ec0ffULL, 0x00000003ff187819ULL, 0x000fe4000001160fULL,
0x0000000823087217ULL, 0x000fe40007800000ULL, 0x0000000818227810ULL, 0x040fe40007ffe0ffULL,
0x00000004181c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000108087824ULL, 0x100fe200078e0a23ULL,
0x0000000c18257810ULL, 0x000fe20007ffe0ffULL, 0x00000001222a7824ULL, 0x000fc600078e0223ULL,
0x000000081800720cULL, 0x0c0fe20003f86070ULL, 0x0000000118187824ULL, 0x100fe200078e0223ULL,
0x000000081c00720cULL, 0x0c0fe20003f66070ULL, 0x000000011c1c7824ULL, 0x100fe200078e0223ULL,
0x000000082200720cULL, 0x080fe20003f46070ULL, 0x00000001252b7824ULL, 0x040fe200078e0223ULL,
0x000000082500720cULL, 0x000fe20003f06070ULL, 0x000000012a237824ULL, 0x040fe400078e020fULL,
0x000000082a707824ULL, 0x000fe400078e00ffULL, 0x0000000118227824ULL, 0x000fc400078e026cULL,
0x0000000118087824ULL, 0x140fe400078e020fULL, 0x0000000818257824ULL, 0x000fe400078e00ffULL,
0x000000011c187824ULL, 0x040fe400078e020fULL, 0x000000081c277824ULL, 0x040fe200078e00ffULL,
0xfffffff825087812ULL, 0x000fe200078ee208ULL, 0x000000011c267824ULL, 0x000fe200078e026cULL,
0xfffffff8701c7812ULL, 0x000fe200078ee223ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0xfffffff827187812ULL, 0x000fc600078ee218ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x00000002226d7212ULL, 0x000fc600078efcffULL, 0x000000012a2a7824ULL, 0x100fe200078e026cULL,
0x0000000226257212ULL, 0x000fe200078efcffULL, 0x000000012b6c7824ULL, 0x040fe200078e026cULL,
0x0000006d20227210ULL, 0x040fe20007fbe0ffULL, 0x000000012b707824ULL, 0x040fe200078e020fULL,
0x0000002520267210ULL, 0x000fe20007fde0ffULL, 0x000000082b717824ULL, 0x000fe400078e00ffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0xfffffff871707812ULL, 0x000fe200078ee270ULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x000000022a717212ULL, 0x000fc600078efcffULL,
0x0000000121237824ULL, 0x040fe200028e0623ULL, 0x000000026c257212ULL, 0x000fe200078efcffULL,
0x0000000121277824ULL, 0x040fe200030e0627ULL, 0x00000071202a7210ULL, 0x000fe20007fbe0ffULL,
0x0000001008737824ULL, 0x100fe200078e021fULL, 0x0000002520207210ULL, 0x000fe20007fde0ffULL,
0x0000001018757824ULL, 0x100fe400078e021fULL, 0x000000101c257824ULL, 0x000fe200078e021fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022737faeULL, 0x0003e2000e101c46ULL,
0x00000001212b7824ULL, 0x000fc400028e062bULL, 0x00000010701f7824ULL, 0x000fe200078e021fULL,
0x0000000026757faeULL, 0x0003e2000d901c46ULL, 0x0000000121217824ULL, 0x000fc600030e066dULL,
0x000000002a257faeULL, 0x0003e8000d101c46ULL, 0x00000000201f7faeULL, 0x0003e2000c101c46ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001011087824ULL, 0x000fca00078e00ffULL,
0x0000001008087812ULL, 0x000fc800078ec0ffULL, 0x000000080f087211ULL, 0x000fc800078fe8ffULL,
0x00000004081c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000108187824ULL, 0x040fe200078e020fULL,
0x0000000808277810ULL, 0x040fe20007ffe0ffULL, 0x0000000808237824ULL, 0x040fe200078e00ffULL,
0x0000000c08707810ULL, 0x040fe20007ffe0ffULL, 0x0000000108227824ULL, 0x100fe400078e026cULL,
0x000000011c087824ULL, 0x000fe200078e026cULL, 0xfffffff823187812ULL, 0x000fe200078ee218ULL,
0x0000008022227825ULL, 0x000fc800078e00ffULL, 0x0000000127267824ULL, 0x140fe200078e026cULL,
0x00000002226d7212ULL, 0x000fe200078efcffULL, 0x00000001702a7824ULL, 0x000fe400078e026cULL,
0x00000001272b7824ULL, 0x140fe200078e020fULL, 0x0000006d206c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000827727824ULL, 0x000fe400078e00ffULL, 0x0000000170227824ULL, 0x040fe400078e020fULL,
0x0000000870277824ULL, 0x000fe200078e00ffULL, 0xfffffff872707812ULL, 0x000fe200078ee22bULL,
0x00000001216d7824ULL, 0x000fc400000e0623ULL, 0x000000011c257824ULL, 0x000fe200078e020fULL,
0xfffffff827727812ULL, 0x000fe200078ee222ULL, 0x0000008008227825ULL, 0x000fc800078e00ffULL,
0x000000081c1c7824ULL, 0x000fe200078e00ffULL, 0x0000000222737212ULL, 0x000fe200078efcffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee225ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000000226717212ULL, 0x080fe400078efcffULL,
0x0000007320227210ULL, 0x000fe20007f1e0ffULL, 0x0000001018757824ULL, 0x100fe200078e021fULL,
0x000000022a257212ULL, 0x000fe200078efcffULL, 0x000000101c777824ULL, 0x000fe200078e021fULL,
0x0000007120267210ULL, 0x040fe20007f5e0ffULL, 0x0000000121237824ULL, 0x040fe200000e0623ULL,
0x0000002520207210ULL, 0x000fe20007f7e0ffULL, 0x00000010707d7824ULL, 0x000fe200078e021fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006c757faeULL, 0x0003e2000b901c46ULL,
0x0000000121277824ULL, 0x000fc400010e0627ULL, 0x00000010721f7824ULL, 0x000fe200078e021fULL,
0x0000000022777faeULL, 0x0003e2000b901c46ULL, 0x0000000121217824ULL, 0x000fc600018e062bULL,
0x00000000267d7faeULL, 0x0003e8000b901c46ULL, 0x00000000201f7faeULL, 0x0003e4000b901c46ULL,
0x0000000405087810ULL, 0x000fe20007ffe0ffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0xffffffffff227424ULL, 0x002fe400078e00ffULL, 0x0000000d0800720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000107227824ULL, 0x000fe400078e0208ULL,
0x00000004ff237424ULL, 0x000fc800078e00ffULL, 0x0000660022227625ULL, 0x000fcc00078e0023ULL,
0x0000000622227981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000811187824ULL, 0x000fe400078e00ffULL, 0x000000020b057824ULL, 0x000fc600078e0279ULL,
0xfffffff018207812ULL, 0x040fe400078ec0ffULL, 0x0000000818187812ULL, 0x000fe400078ec0ffULL,
0x00000000200473c2ULL, 0x000ea600000e0000ULL, 0x0000001005057824ULL, 0x000fe400078e0018ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000126a804047890ULL, 0x004fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126a80020207f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01266800052a7f8cULL, 0x000662000c80043fULL,
0x000000ffff187224ULL, 0x004fc600078e0021ULL, 0x0000000000207805ULL, 0x000fc80000015200ULL,
0x01266c00051f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x006fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026201f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127267824ULL, 0x000fe200000e0e21ULL, 0x003d09001f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc80000011426ULL,
0x0000001f1c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e0626ULL,
0x000000021c1c7819ULL, 0x000fc8000000121fULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000123237810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01266c00051f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000801a057824ULL, 0x008fc800078e0202ULL, 0x0000000178057824ULL, 0x000fca00078e0205ULL,
0x0120000005207984ULL, 0x000e680000000800ULL, 0x01220000051f7984ULL, 0x0004e20000000800ULL,
0x000000032000720bULL, 0x002fe20003f1d000ULL, 0x0000d8627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000057806ULL, 0x004fc800000e0100ULL, 0x000000ff0500720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1a7224ULL, 0x000fd200078e0003ULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x000000030b1a7810ULL, 0x000fe40007ffe0ffULL, 0x000000032000720bULL, 0x000fe40003f54000ULL,
0x000000111a00720cULL, 0x000fe20003f05270ULL, 0x0000d8127f007947ULL, 0x000fd4000b800000ULL,
0x00000000001c7806ULL, 0x000fc400010e0100ULL, 0x0000008011218824ULL, 0x000fe200078e0202ULL,
0x00000003201a7209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000178218824ULL, 0x000fca00078e0221ULL, 0x0124001a21008388ULL, 0x0003e20000000800ULL,
0x000000ff1c00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x000000031a027221ULL, 0x002fe20000010100ULL, 0x000000ff1cff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b02027820ULL, 0x000fc80000410000ULL,
0x0000000200037308ULL, 0x000e640000000800ULL, 0x0000000324247220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe2000001160fULL,
0x0000d7527f007947ULL, 0x000fea000b800000ULL, 0x00001f2703267589ULL, 0x0002a400000e0000ULL,
0x000000262c2c7220ULL, 0x084fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x0000002644447220ULL, 0x080fe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080f277811ULL, 0x002fe200078ff0ffULL, 0x0000d6227f007947ULL, 0x000fea000b800000ULL,
0x00001f2703267589ULL, 0x0002a400000e0000ULL, 0x000000262e2e7220ULL, 0x084fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x0000002646467220ULL, 0x080fe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00001cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000100f277811ULL, 0x002fe200078ff0ffULL,
0x0000d4f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2703267589ULL, 0x0002a400000e0000ULL,
0x000000264c4c7220ULL, 0x084fe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x0000002664647220ULL, 0x080fe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002668687220ULL, 0x080fe20000410000ULL, 0x0000002669697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000001cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000180f277811ULL, 0x002fe200078ff0ffULL,
0x0000d3d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2703267589ULL, 0x0002a400000e0000ULL,
0x000000264e4e7220ULL, 0x084fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x0000002666667220ULL, 0x080fe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x000000266a6a7220ULL, 0x080fe20000410000ULL, 0x000000266b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000001c05ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff1c7424ULL, 0x000fd800078e00ffULL, 0x000000201a020221ULL, 0x000fe20000010100ULL,
0x00007610ff1c0816ULL, 0x000fc6000000001cULL, 0x3fb8aa3b02020820ULL, 0x000fc80000410000ULL,
0x0000000200000308ULL, 0x000e640000000800ULL, 0x000000001f1f0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000241f247221ULL, 0x008fc20000010000ULL,
0x0000000000027805ULL, 0x000fcc0000015200ULL, 0x0000000811057824ULL, 0x000fca00078e00ffULL,
0xfffffff0051f7812ULL, 0x000fca00078ec0ffULL, 0x0126b4001f057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x0000002002207210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e03ULL,
0x003d09002000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc80000011421ULL, 0x0000002005057211ULL, 0x000fca00078110ffULL,
0x000000ffff207224ULL, 0x000fca00000e0621ULL, 0x0000000205057819ULL, 0x000fc80000001220ULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000123237810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126b4001f057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099101c027816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000ff02723eULL, 0x000fe400000010ffULL,
0x00000002ff037819ULL, 0x000fe4000001160fULL, 0x0000541002027816ULL, 0x000fe20000000002ULL,
0x0000cf927f007947ULL, 0x000fea000b800000ULL, 0x00001f0302137589ULL, 0x0002a400000e0000ULL,
0x0000000803277810ULL, 0x002fe20007ffe0ffULL, 0x0000cfc27f007947ULL, 0x000fea000b800000ULL,
0x0000001003157810ULL, 0x000fe20007ffe0ffULL, 0x00001f2702147589ULL, 0x0002ea00000e0000ULL,
0x00001f1502157589ULL, 0x0002a400000e0000ULL, 0x0000001803277810ULL, 0x002fe20007ffe0ffULL,
0x0000d0127f007947ULL, 0x000fea000b800000ULL, 0x00001f2702167589ULL, 0x0002e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff027819ULL, 0x002fe2000001160fULL,
0x0000000817207824ULL, 0x000fe200078e00ffULL, 0x000000030b1c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000819267824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000479027824ULL, 0x000fe200078e0202ULL, 0x0000017000007945ULL, 0x000fe20003800000ULL,
0x00000004111f7824ULL, 0x000fc400078e00ffULL, 0x0000000117037824ULL, 0x100fe400078e0202ULL,
0x0000000119057824ULL, 0x000fe200078e0202ULL, 0x000000041f1f7812ULL, 0x000fe200078ec0ffULL,
0x000000101b747824ULL, 0x000fe200078e0228ULL, 0xfffffff820027812ULL, 0x000fe400078ee203ULL,
0x0000a0001c037811ULL, 0x000fe400078e60ffULL, 0xfffffff8261c7812ULL, 0x000fe400078ee205ULL,
0x000000021f207812ULL, 0x000fe200078efcffULL, 0x0000001002027824ULL, 0x000fc400078e0203ULL,
0x000000101c1c7824ULL, 0x000fc600078e0203ULL, 0x000000000270783bULL, 0x0002e80000000200ULL,
0x000000001c6c783bULL, 0x0002a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000001370707231ULL, 0x08cfe400003400ffULL, 0x0000001372727231ULL, 0x000fe400003400ffULL,
0x0000001471717231ULL, 0x080fe400003400ffULL, 0x0000001473737231ULL, 0x000fc400003400ffULL,
0x000000156c6c7231ULL, 0x080fe400003400ffULL, 0x000000156e6e7231ULL, 0x000fe400003400ffULL,
0x000000166d6d7231ULL, 0x080fe400003400ffULL, 0x000000166f6f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000200f027211ULL, 0x002fe200078fe0ffULL,
0x00000008171c7824ULL, 0x040fe200078e00ffULL, 0x000000007474783bULL, 0x000e620000004200ULL,
0x000000101e1e7824ULL, 0x000fe200078e0203ULL, 0x00000c2000007945ULL, 0x000fe20003800000ULL,
0x0000000117177824ULL, 0x000fca00078e0202ULL, 0xfffffff81c177812ULL, 0x000fca00078ee217ULL,
0x0000001017177824ULL, 0x000fca00078e0228ULL, 0x00000000177c783bULL, 0x0006a20000004200ULL,
0x00000018ff207819ULL, 0x002fe40000011675ULL, 0x000000ff76257812ULL, 0x000fe400078ec0ffULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x0000ffff758e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff772b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff237819ULL, 0x000fc40000011676ULL,
0x00000025ff26723eULL, 0x000fe200020006ffULL, 0x20000020ff257230ULL, 0x000fe20000004100ULL,
0x00000018ff277819ULL, 0x100fe40000011677ULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x00000008ff207819ULL, 0x000fe4000001168eULL, 0x00000018ff177819ULL, 0x008fe40000011676ULL,
0x00000010ff2a7819ULL, 0x000fc40000011677ULL, 0x000000ff23237812ULL, 0x000fe400078ec0ffULL,
0x00000010ff057819ULL, 0x100fe40000011674ULL, 0x000000ff741c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff1b7819ULL, 0x000fe40000011674ULL, 0x0000ffff748d7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff768f7812ULL, 0x000fe200078ec0ffULL, 0x2000002bff767230ULL, 0x000fe20000004100ULL,
0x00000018ff787819ULL, 0x004fc4000001167cULL, 0x00000027ff74723eULL, 0x000fe200020006ffULL,
0x20000026ff277230ULL, 0x000fe20000004100ULL, 0x00000020ff20723eULL, 0x000fe400020006ffULL,
0x00000017ff17723eULL, 0x000fe400020006ffULL, 0x00000023ff26723eULL, 0x000fe200020006ffULL,
0x20000020ff237230ULL, 0x000fe20000004100ULL, 0x000000ff2a2b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff817819ULL, 0x000fc4000001167dULL, 0x000000ff7d837812ULL, 0x040fe400078ec0ffULL,
0x00000018ff827819ULL, 0x000fe4000001167dULL, 0x0000ffff7d927812ULL, 0x000fe400078ec0ffULL,
0x000000ff7f8a7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff77907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7d7819ULL, 0x000fc4000001167eULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000010ff1f7819ULL, 0x000fe40000011675ULL, 0x000000ff75217812ULL, 0x000fe200078ec0ffULL,
0x20000017ff757230ULL, 0x000fe20000004100ULL, 0x00000010ff777819ULL, 0x000fe4000001167cULL,
0x0000002bff20723eULL, 0x000fe200020006ffULL, 0x20000026ff2b7230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fc400020006ffULL, 0x00000082ff17723eULL, 0x000fe200020006ffULL,
0x20000078ff827230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x2000008aff8b7230ULL, 0x000fe20000004100ULL, 0x00000008ff267819ULL, 0x000fe20000011690ULL,
0x20000017ff877230ULL, 0x000fe20000004100ULL, 0x00000008ff2a7819ULL, 0x000fe2000001168fULL,
0x2000007dff8a7230ULL, 0x000fe20000004100ULL, 0x000000ff77787812ULL, 0x000fe200078ec0ffULL,
0x20000020ff777230ULL, 0x000fe20000004100ULL, 0x000000ff05057812ULL, 0x000fc400078ec0ffULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x0000002aff2a723eULL, 0x000fe400020006ffULL,
0x00000078ff20723eULL, 0x000fe200020006ffULL, 0x20000026ff787230ULL, 0x000fe20000004100ULL,
0x00000008ff7d7819ULL, 0x000fe40000011692ULL, 0x0000ffff7c917812ULL, 0x000fe400078ec0ffULL,
0x000000ff1f1f7812ULL, 0x000fc400078ec0ffULL, 0x0000001cff1c723eULL, 0x000fe400020006ffULL,
0x000000ff7c807812ULL, 0x000fe200078ec0ffULL, 0x20000074ff7c7230ULL, 0x000fe20000004100ULL,
0x00000010ff857819ULL, 0x000fe2000001167eULL, 0x2000002aff747230ULL, 0x000fe20000004100ULL,
0x00000005ff05723eULL, 0x000fe200020006ffULL, 0x2000001cff1c7230ULL, 0x000fe20000004100ULL,
0x000000ff7e867812ULL, 0x040fe400078ec0ffULL, 0x0000ffff7e937812ULL, 0x000fe200078ec0ffULL,
0x20000005ff057230ULL, 0x000fe20000004100ULL, 0x00000008ff177819ULL, 0x000fc4000001168dULL,
0x0000001bff1b723eULL, 0x000fe400020006ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001167fULL,
0x0000007dff26723eULL, 0x000fe200020006ffULL, 0x20000020ff7d7230ULL, 0x000fe20000004100ULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x2000001bff1b7230ULL, 0x000fe20000004100ULL,
0x0000001fff1f723eULL, 0x000fe400020006ffULL, 0x00000008ff2a7819ULL, 0x000fe20000011691ULL,
0x20000021ff217230ULL, 0x000fe20000004100ULL, 0x000000ff85207812ULL, 0x000fe200078ec0ffULL,
0x2000001fff1f7230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fc400020006ffULL,
0x00000017ff17723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x20000086ff887230ULL, 0x000fe20000004100ULL, 0x0000002aff2a723eULL, 0x000fe200020006ffULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x00000020ff20723eULL, 0x000fe200020006ffULL,
0x2000007eff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff81817812ULL, 0x000fe200078ec0ffULL,
0x20000026ff867230ULL, 0x000fe20000004100ULL, 0x00000010ff1c7819ULL, 0x000fe2000001161cULL,
0x2000002aff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff057819ULL, 0x000fc40000011605ULL,
0x00000010ff267819ULL, 0x000fe2000001161bULL, 0x20000020ff1b7230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe40000011621ULL, 0x00000010ff2a7819ULL, 0x000fe4000001161fULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x0000105405207816ULL, 0x000fe2000000001cULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe2000001167fULL, 0x20000081ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff177819ULL, 0x000fc40000011617ULL, 0x00000010ff1c7819ULL, 0x000fe40000011625ULL,
0x00000010ff237819ULL, 0x000fe40000011623ULL, 0x0000ffff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x000010542a217816ULL, 0x000fe40000000021ULL, 0x00000010ff2a7819ULL, 0x000fe40000011627ULL,
0x0000105426267816ULL, 0x000fc40000000017ULL, 0x000010541c277816ULL, 0x000fe20000000023ULL,
0x000000206c4c723cULL, 0x040f62000004184cULL, 0x000000ff89897812ULL, 0x000fe400078ec0ffULL,
0x00000008ff177819ULL, 0x000fe40000011693ULL, 0x00000008ff237819ULL, 0x000fe4000001167fULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x000000266c50723cULL, 0x000f620000041850ULL,
0x00000089ff89723eULL, 0x000fc400020006ffULL, 0x00000017ff17723eULL, 0x000fe200020006ffULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000010ff817819ULL, 0x000fe20000011683ULL,
0x20000089ff1f7230ULL, 0x000fe20000004100ULL, 0x00000010ff1c7819ULL, 0x000fe20000011685ULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x00000023ff23723eULL, 0x000fe200020006ffULL,
0x00000020702c723cULL, 0x000f62000004182cULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff747819ULL, 0x000fe20000011674ULL, 0x20000023ff237230ULL, 0x000fe20000004100ULL,
0x000010541c817816ULL, 0x000fc40000000081ULL, 0x00000010ff057819ULL, 0x000fe2000001167cULL,
0x000000267030723cULL, 0x000f620000041830ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff1c7819ULL, 0x000fe40000011687ULL, 0x00000010ff7f7819ULL, 0x000fe40000011686ULL,
0x0000105475747816ULL, 0x000fe40000000074ULL, 0x00000010ff2b7819ULL, 0x000fc4000001162bULL,
0x0000105405757816ULL, 0x000fe40000000078ULL, 0x000010541c7f7816ULL, 0x000fe4000000007fULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff777819ULL, 0x000fe20000011677ULL,
0x000000746c58723cULL, 0x000f620000041858ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x00000010ff7d7819ULL, 0x000fc4000001167dULL, 0x00000010ff057819ULL, 0x000fe40000011682ULL,
0x00000010ff7e7819ULL, 0x000fe2000001167eULL, 0x000000747038723cULL, 0x000f620000041838ULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff1b7819ULL, 0x000fe4000001161bULL,
0x00000010ff897819ULL, 0x000fe4000001168bULL, 0x00000010ff1c7819ULL, 0x000fc4000001161fULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff177819ULL, 0x000fe40000011617ULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff237819ULL, 0x000fe40000011623ULL,
0x000010542b2a7816ULL, 0x000fe4000000002aULL, 0x00001054772b7816ULL, 0x000fc40000000076ULL,
0x000010547d807816ULL, 0x000fe40000000080ULL, 0x00001054057e7816ULL, 0x000fe2000000007eULL,
0x000000101d057824ULL, 0x000fe200078e0203ULL, 0x000010541b887816ULL, 0x000fe20000000088ULL,
0x0000002a6c54723cULL, 0x000f620000041854ULL, 0x000010541c897816ULL, 0x000fe40000000089ULL,
0x000010548a8a7816ULL, 0x000fe20000000017ULL, 0x000000001e1c783bULL, 0x000e620000000200ULL,
0x000010548c8b7816ULL, 0x000fc60000000023ULL, 0x000000806c5c723cULL, 0x040f70000004185cULL,
0x0000007e6c60723cULL, 0x040f700000041860ULL, 0x000000886c64723cULL, 0x040f700000041864ULL,
0x0000008a6c68723cULL, 0x000b640000041868ULL, 0x00000000056c783bULL, 0x0204ec0000000200ULL,
0x0000002a7034723cULL, 0x040b700000041834ULL, 0x00000080703c723cULL, 0x040b70000004183cULL,
0x0000007e7040723cULL, 0x040b700000041840ULL, 0x000000887044723cULL, 0x040b700000041844ULL,
0x0000008a7048723cULL, 0x000b620000041848ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x000000136c6c7231ULL, 0x08efe400003400ffULL,
0x000000136e6e7231ULL, 0x000fc400003400ffULL, 0x000000146d6d7231ULL, 0x080fe400003400ffULL,
0x000000146f6f7231ULL, 0x000fe400003400ffULL, 0x000000151c1c7231ULL, 0x080fe400003400ffULL,
0x000000151e1e7231ULL, 0x000fe400003400ffULL, 0x000000161d1d7231ULL, 0x080fe400003400ffULL,
0x000000161f1f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x006fea0003800000ULL,
0x0000000819037824ULL, 0x040fe200078e00ffULL, 0x000000002970783bULL, 0x020e620000004200ULL,
0x0000000119027824ULL, 0x000fca00078e0202ULL, 0xfffffff803037812ULL, 0x000fca00078ee202ULL,
0x0000001003037824ULL, 0x000fca00078e0228ULL, 0x000000000374783bULL, 0x0002a40000004200ULL,
0x00000018ff037819ULL, 0x002fe40000011672ULL, 0x000000ff71197812ULL, 0x000fe400078ec0ffULL,
0x00000003ff03723eULL, 0x000fe400020006ffULL, 0x00000018ff057819ULL, 0x100fe40000011670ULL,
0x00000010ff027819ULL, 0x000fe20000011670ULL, 0x20000003ff2a7230ULL, 0x000fe20000004100ULL,
0x00000019ff19723eULL, 0x000fc400020006ffULL, 0x00000005ff05723eULL, 0x000fe400020006ffULL,
0x000000ff72257812ULL, 0x000fe200078ec0ffULL, 0x20000019ff217230ULL, 0x000fe20000004100ULL,
0x000000ff767e7812ULL, 0x004fe200078ec0ffULL, 0x20000005ff197230ULL, 0x000fe20000004100ULL,
0x000000ff77807812ULL, 0x000fe400078ec0ffULL, 0x0000007eff03723eULL, 0x000fe400020006ffULL,
0x000000ff02027812ULL, 0x000fc400078ec0ffULL, 0x00000018ff207819ULL, 0x000fe20000011671ULL,
0x20000003ff7f7230ULL, 0x000fe20000004100ULL, 0x00000080ff03723eULL, 0x000fe400020006ffULL,
0x000000ff73277812ULL, 0x000fe400078ec0ffULL, 0x00000025ff05723eULL, 0x000fe200020006ffULL,
0x20000003ff827230ULL, 0x000fe20000004100ULL, 0x00000002ff02723eULL, 0x000fe400020006ffULL,
0x0000ffff70857812ULL, 0x000fc400078ec0ffULL, 0x0000ffff71867812ULL, 0x000fe200078ec0ffULL,
0x20000002ff037230ULL, 0x000fe20000004100ULL, 0x00000018ff267819ULL, 0x000fe40000011673ULL,
0x00000010ff237819ULL, 0x000fe40000011672ULL, 0x00000020ff20723eULL, 0x000fe400020006ffULL,
0x00000027ff29723eULL, 0x000fe200020006ffULL, 0x20000005ff277230ULL, 0x000fe20000004100ULL,
0x00000026ff26723eULL, 0x000fe200020006ffULL, 0x20000020ff257230ULL, 0x000fe20000004100ULL,
0x00000008ff027819ULL, 0x000fe20000011685ULL, 0x20000029ff2b7230ULL, 0x000fe20000004100ULL,
0x00000008ff057819ULL, 0x000fc40000011686ULL, 0x00000010ff287819ULL, 0x000fe40000011673ULL,
0x0000ffff72877812ULL, 0x000fe200078ec0ffULL, 0x20000026ff727230ULL, 0x000fe20000004100ULL,
0x000000ff23237812ULL, 0x000fe400078ec0ffULL, 0x000000ff70177812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1b7819ULL, 0x000fe40000011671ULL, 0x0000ffff73887812ULL, 0x000fc400078ec0ffULL,
0x00000010ff707819ULL, 0x100fe40000011674ULL, 0x000000ff74737812ULL, 0x040fe400078ec0ffULL,
0x00000018ff717819ULL, 0x000fe40000011674ULL, 0x0000ffff74897812ULL, 0x000fe400078ec0ffULL,
0x00000002ff02723eULL, 0x000fe400020006ffULL, 0x00000005ff20723eULL, 0x000fc400020006ffULL,
0x00000010ff747819ULL, 0x100fe20000011675ULL, 0x20000002ff057230ULL, 0x000fe20000004100ULL,
0x000000ff757c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff787819ULL, 0x000fe40000011675ULL,
0x0000ffff758a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff28297812ULL, 0x000fe400078ec0ffULL,
0x00000018ff757819ULL, 0x000fc40000011676ULL, 0x00000023ff26723eULL, 0x000fe200020006ffULL,
0x20000020ff237230ULL, 0x000fe20000004100ULL, 0x00000008ff287819ULL, 0x000fe40000011687ULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000028ff02723eULL, 0x000fe200020006ffULL, 0x20000026ff287230ULL, 0x000fe20000004100ULL,
0x00000008ff207819ULL, 0x000fe20000011688ULL, 0x20000075ff807230ULL, 0x000fe20000004100ULL,
0x000000ff70267812ULL, 0x000fe200078ec0ffULL, 0x20000029ff707230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000002ff297230ULL, 0x000fe20000004100ULL,
0x000000ff1b1b7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff7d7819ULL, 0x000fe40000011676ULL,
0x0000ffff768b7812ULL, 0x000fe400078ec0ffULL, 0x00000020ff20723eULL, 0x000fe400020006ffULL,
0x00000018ff767819ULL, 0x000fe40000011677ULL, 0x00000017ff17723eULL, 0x000fe400020006ffULL,
0x00000026ff26723eULL, 0x000fc400020006ffULL, 0x000000ff74747812ULL, 0x000fe200078ec0ffULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x00000008ff027819ULL, 0x000fe40000011689ULL,
0x00000008ff757819ULL, 0x000fe4000001168aULL, 0x00000010ff817819ULL, 0x000fe40000011677ULL,
0x0000ffff778c7812ULL, 0x000fe200078ec0ffULL, 0x20000071ff777230ULL, 0x000fe20000004100ULL,
0x0000001bff1b723eULL, 0x000fe200020006ffULL, 0x20000020ff717230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fc400020006ffULL, 0x00000074ff20723eULL, 0x000fe200020006ffULL,
0x20000026ff747230ULL, 0x000fe20000004100ULL, 0x00000002ff02723eULL, 0x000fe200020006ffULL,
0x2000001bff1b7230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000076ff837230ULL, 0x000fe20000004100ULL, 0x000000ff7d267812ULL, 0x000fe200078ec0ffULL,
0x20000002ff767230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000075ff7d7230ULL, 0x000fe20000004100ULL, 0x00000026ff75723eULL, 0x000fc400020006ffULL,
0x00000010ff027819ULL, 0x000fe20000011617ULL, 0x20000078ff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff037819ULL, 0x000fe20000011603ULL, 0x20000020ff787230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe20000011621ULL, 0x20000075ff177230ULL, 0x000fe20000004100ULL,
0x00000010ff267819ULL, 0x000fe4000001161bULL, 0x0000105403027816ULL, 0x000fe40000000002ULL,
0x0000105426037816ULL, 0x000fc40000000021ULL, 0x00000010ff267819ULL, 0x000fe40000011625ULL,
0x00000010ff217819ULL, 0x000fe40000011623ULL, 0x00000010ff207819ULL, 0x000fe20000011619ULL,
0x000000026c2c723cULL, 0x008b62000004182cULL, 0x00000010ff057819ULL, 0x000fe40000011605ULL,
0x00000010ff277819ULL, 0x000fe40000011627ULL, 0x00000010ff287819ULL, 0x000fc40000011628ULL,
0x0000105426217816ULL, 0x000fe20000000021ULL, 0x000000021c4c723cULL, 0x000b62000004184cULL,
0x0000105420207816ULL, 0x000fe40000000005ULL, 0x0000105428267816ULL, 0x000fe40000000027ULL,
0x000000ff81817812ULL, 0x000fe400078ec0ffULL, 0x00000010ff057819ULL, 0x000fe2000001162aULL,
0x000000206c30723cULL, 0x000b620000041830ULL, 0x00000010ff287819ULL, 0x000fc40000011629ULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x0000105405287816ULL, 0x000fe40000000028ULL,
0x00000008ff197819ULL, 0x000fe2000001168bULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000008ff057819ULL, 0x000fe2000001168cULL, 0x000000201c50723cULL, 0x000b620000041850ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fc400020006ffULL,
0x00000010ff2b7819ULL, 0x000fe2000001162bULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe20000011670ULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000019ff19723eULL, 0x000fe400020006ffULL, 0x00000005ff05723eULL, 0x000fe400020006ffULL,
0x0000105470277816ULL, 0x000fe2000000002bULL, 0x20000019ff197230ULL, 0x000fe20000004100ULL,
0x00000010ff2b7819ULL, 0x000fe20000011682ULL, 0x20000005ff057230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fc40000011681ULL, 0x00000010ff777819ULL, 0x000fe20000011677ULL,
0x000000266c34723cULL, 0x080b620000041834ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00001054702b7816ULL, 0x000fe4000000002bULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff297819ULL, 0x000fe20000011671ULL, 0x000000261c54723cULL, 0x000b620000041854ULL,
0x00000010ff737819ULL, 0x000fc40000011673ULL, 0x00000010ff757819ULL, 0x000fe4000001167cULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff7f7819ULL, 0x000fc4000001167fULL, 0x00000010ff2a7819ULL, 0x000fe40000011617ULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff197819ULL, 0x000fe40000011619ULL,
0x00000010ff707819ULL, 0x000fe40000011683ULL, 0x00000010ff057819ULL, 0x000fe40000011605ULL,
0x0000105477767816ULL, 0x000fc40000000076ULL, 0x0000105472297816ULL, 0x000fe40000000029ULL,
0x0000105474747816ULL, 0x000fe40000000073ULL, 0x0000105478757816ULL, 0x000fe40000000075ULL,
0x000010547e777816ULL, 0x000fe2000000007dULL, 0x000000286c38723cULL, 0x000b620000041838ULL,
0x000010542a2a7816ULL, 0x000fe4000000007fULL, 0x0000105480807816ULL, 0x000fc40000000019ULL,
0x0000105470817816ULL, 0x000fc60000000005ULL, 0x000000746c3c723cULL, 0x040b70000004183cULL,
0x000000766c40723cULL, 0x040b700000041840ULL, 0x0000002a6c44723cULL, 0x040b700000041844ULL,
0x000000806c48723cULL, 0x000b700000041848ULL, 0x000000281c58723cULL, 0x040b700000041858ULL,
0x000000741c5c723cULL, 0x040b70000004185cULL, 0x000000761c60723cULL, 0x040b700000041860ULL,
0x0000002a1c64723cULL, 0x040b700000041864ULL, 0x000000801c68723cULL, 0x000b620000041868ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000004047f8cULL, 0x000e62000c80043fULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x000126a00b027811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000002ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff177224ULL, 0x002fe200078e0005ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff2f5000007947ULL, 0x000fea000383ffffULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0180000024007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000eec000047802ULL, 0x000fc40000000f00ULL, 0x0000b7e000007944ULL, 0x016fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002400037308ULL, 0x004ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc80000000024ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006f00ff037624ULL, 0x000fe400078e00ffULL, 0x00006e00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000087919ULL, 0x000ea80000000000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x0000001808057811ULL, 0x044fe400078ff0ffULL,
0x0000000808097811ULL, 0x000fc400078ff0ffULL, 0x00000002ff077819ULL, 0x002fe40000011604ULL,
0x00000010080b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003067220ULL, 0x008fca0000410000ULL,
0x00001f0706007589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea800000e0000ULL,
0x00001f0906047589ULL, 0x000ee800000e0000ULL, 0x00001f0b06027589ULL, 0x000ea200000e0000ULL,
0x0000002c002c7220ULL, 0x042fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000003400347220ULL, 0x040fe20000410000ULL, 0x0000003500357220ULL, 0x040fe20000410000ULL,
0x0000003800387220ULL, 0x040fe20000410000ULL, 0x0000003900397220ULL, 0x040fe20000410000ULL,
0x0000003c003c7220ULL, 0x040fe20000410000ULL, 0x0000003d003d7220ULL, 0x040fe20000410000ULL,
0x0000004000407220ULL, 0x040fe20000410000ULL, 0x0000004100417220ULL, 0x040fe20000410000ULL,
0x0000004400447220ULL, 0x040fe20000410000ULL, 0x0000004500457220ULL, 0x040fe20000410000ULL,
0x0000004800487220ULL, 0x040fe20000410000ULL, 0x0000004900497220ULL, 0x000fe20000410000ULL,
0x0000004e054e7220ULL, 0x044fe20000410000ULL, 0x0000004f054f7220ULL, 0x040fe20000410000ULL,
0x0000005205527220ULL, 0x040fe20000410000ULL, 0x0000005305537220ULL, 0x040fe20000410000ULL,
0x0000005605567220ULL, 0x040fe20000410000ULL, 0x0000005705577220ULL, 0x040fe20000410000ULL,
0x0000005a055a7220ULL, 0x040fe20000410000ULL, 0x0000005b055b7220ULL, 0x040fe20000410000ULL,
0x0000005e055e7220ULL, 0x040fe20000410000ULL, 0x0000005f055f7220ULL, 0x040fe20000410000ULL,
0x0000006205627220ULL, 0x040fe20000410000ULL, 0x0000006305637220ULL, 0x040fe20000410000ULL,
0x0000006605667220ULL, 0x040fe20000410000ULL, 0x0000006705677220ULL, 0x040fe20000410000ULL,
0x0000006a056a7220ULL, 0x040fe20000410000ULL, 0x0000006b056b7220ULL, 0x000fe20000410000ULL,
0x000000042e2e7220ULL, 0x088fe20000410000ULL, 0x000000042f2f7220ULL, 0x080fe20000410000ULL,
0x0000000432327220ULL, 0x080fe20000410000ULL, 0x0000000433337220ULL, 0x080fe20000410000ULL,
0x0000000436367220ULL, 0x080fe20000410000ULL, 0x0000000437377220ULL, 0x080fe20000410000ULL,
0x000000043a3a7220ULL, 0x080fe20000410000ULL, 0x000000043b3b7220ULL, 0x080fe20000410000ULL,
0x000000043e3e7220ULL, 0x080fe20000410000ULL, 0x000000043f3f7220ULL, 0x080fe20000410000ULL,
0x0000000442427220ULL, 0x080fe20000410000ULL, 0x0000000443437220ULL, 0x080fe20000410000ULL,
0x0000000446467220ULL, 0x080fe20000410000ULL, 0x0000000447477220ULL, 0x080fe20000410000ULL,
0x000000044a4a7220ULL, 0x080fe20000410000ULL, 0x000000044b4b7220ULL, 0x000fe20000410000ULL,
0x000000024c4c7220ULL, 0x080fe20000410000ULL, 0x000000024d4d7220ULL, 0x080fe20000410000ULL,
0x0000000250507220ULL, 0x080fe20000410000ULL, 0x0000000251517220ULL, 0x080fe20000410000ULL,
0x0000000254547220ULL, 0x080fe20000410000ULL, 0x0000000255557220ULL, 0x080fe20000410000ULL,
0x0000000258587220ULL, 0x080fe20000410000ULL, 0x0000000259597220ULL, 0x080fe20000410000ULL,
0x000000025c5c7220ULL, 0x080fe20000410000ULL, 0x000000025d5d7220ULL, 0x080fe20000410000ULL,
0x0000000260607220ULL, 0x080fe20000410000ULL, 0x0000000261617220ULL, 0x080fe20000410000ULL,
0x0000000264647220ULL, 0x080fe20000410000ULL, 0x0000000265657220ULL, 0x080fe20000410000ULL,
0x0000000268687220ULL, 0x080fe20000410000ULL, 0x0000000269697220ULL, 0x000fc20000410000ULL,
0x0000000000037919ULL, 0x004ea20000000000ULL, 0x0000002e2f2e723eULL, 0x000fc400000010ffULL,
0x000000323317723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000363736723eULL, 0x000fe400000010ffULL, 0x0000003a3b1b723eULL, 0x000fe400000010ffULL,
0x0000003e3f3e723eULL, 0x000fc400000010ffULL, 0x00000042431f723eULL, 0x000fe400000010ffULL,
0x000000464746723eULL, 0x000fe400000010ffULL, 0x0000004a4b23723eULL, 0x000fe400000010ffULL,
0x0000004c4d4c723eULL, 0x000fe400000010ffULL, 0x0000000803057811ULL, 0x044fe200078ff0ffULL,
0x0000000184847824ULL, 0x000fe200078e0203ULL, 0x0000000203007812ULL, 0x000fc400078ec0ffULL,
0x0000001803097811ULL, 0x000fe200078ff0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x0000000500027211ULL, 0x040fe400078ff8ffULL, 0x0000001003057811ULL, 0x000fe200078ff0ffULL,
0x0000000809187824ULL, 0x002fe200078e00ffULL, 0xfffffff8070e7812ULL, 0x000fe400078ee202ULL,
0x00000002ff077819ULL, 0x000fe20000011603ULL, 0x00000008050b7824ULL, 0x000fe200078e00ffULL,
0x0000000500047211ULL, 0x000fc400078ff8ffULL, 0x0000000700027211ULL, 0x040fe200078ff8ffULL,
0x00000008070c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b167812ULL, 0x000fe200078ee204ULL,
0x0000200011047824ULL, 0x000fe200078e00ffULL, 0x0000000900057211ULL, 0x000fe200078ff8ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0x0000000202007810ULL, 0x000fe20007ffe0ffULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe400078ee205ULL,
0x0000200004057812ULL, 0x000fc400078ee2ffULL, 0xfffffff809067812ULL, 0x040fe400078ee200ULL,
0xfffffff809007812ULL, 0x000fe200078ee202ULL, 0x000010000a077824ULL, 0x100fe200078e0205ULL,
0x0000000402047810ULL, 0x000fe20007ffe0ffULL, 0x0000001084847824ULL, 0x000fe200078e0205ULL,
0x0000000602097810ULL, 0x000fe20007ffe0ffULL, 0x0000000803027824ULL, 0x000fe200078e00ffULL,
0xfffffff80b087812ULL, 0x000fe200078ee204ULL, 0x0000001000047824ULL, 0x000fe200078e0207ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL, 0x000000100e147824ULL, 0x100fe200078e0207ULL,
0x0000000802097812ULL, 0x000fe200078ec0ffULL, 0x0000001016167824ULL, 0x100fe200078e0207ULL,
0x0000002c2d00723eULL, 0x000fe200000010ffULL, 0x0000001018187824ULL, 0x100fe200078e0207ULL,
0x000000303102723eULL, 0x000fe200000010ffULL, 0x0000001006067824ULL, 0x100fe200078e0207ULL,
0x000000505126723eULL, 0x000fe200000010ffULL, 0x0000001008087824ULL, 0x100fe200078e0207ULL,
0x00005410001c7816ULL, 0x100fe20000000002ULL, 0x000000100c0e7824ULL, 0x000fe200078e0207ULL,
0x00007632001d7816ULL, 0x000fe20000000002ULL, 0x0000000104077824ULL, 0x000fe200078e0209ULL,
0x000000343500723eULL, 0x000fe200000010ffULL, 0x00000001090b7824ULL, 0x000fe200078e0206ULL,
0x000000383902723eULL, 0x000fe200000010ffULL, 0x00000001090c7824ULL, 0x000fe200078e0208ULL,
0x0000001c07007388ULL, 0x0003e20000000a00ULL, 0x0000003c3d04723eULL, 0x000fe200000010ffULL,
0x00000001090e7824ULL, 0x000fe200078e020eULL, 0x000000404106723eULL, 0x000fe200000010ffULL,
0x0000000109147824ULL, 0x000fe200078e0214ULL, 0x000000484908723eULL, 0x000fe200000010ffULL,
0x0000000109167824ULL, 0x040fe200078e0216ULL, 0x00005410361a7816ULL, 0x000fe2000000001bULL,
0x0000000109187824ULL, 0x000fe200078e0218ULL, 0x000000545554723eULL, 0x000fc400000010ffULL,
0x00000058592a723eULL, 0x000fe400000010ffULL, 0x00005410001c7816ULL, 0x142fe40000000002ULL,
0x00007632001d7816ULL, 0x000fe40000000002ULL, 0x000000444507723eULL, 0x000fe400000010ffULL,
0x00007632361b7816ULL, 0x000fe2000000001bULL, 0x0000001c0b007388ULL, 0x0003e20000000a00ULL,
0x000054103e1e7816ULL, 0x000fc4000000001fULL, 0x000076323e1f7816ULL, 0x000fe4000000001fULL,
0x0000541046227816ULL, 0x150fe40000000023ULL, 0x0000763246237816ULL, 0x000fe40000000023ULL,
0x0000763254097816ULL, 0x000fe4000000002aULL, 0x0000005c5d5c723eULL, 0x000fe400000010ffULL,
0x00005410041c7816ULL, 0x002fc40000000006ULL, 0x00007632041d7816ULL, 0x000fe40000000006ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x0000001c0c007388ULL, 0x000fe20000000a00ULL, 0x0000541054087816ULL, 0x000fe4000000002aULL,
0x000000606160723eULL, 0x000fe200000010ffULL, 0x000000060e007388ULL, 0x0003e20000000a00ULL,
0x000000646564723eULL, 0x000fc400000010ffULL, 0x000000686932723eULL, 0x000fe400000010ffULL,
0x0000004e4f00723eULL, 0x000fe400000010ffULL, 0x000000525302723eULL, 0x000fe400000010ffULL,
0x000000565704723eULL, 0x000fe400000010ffULL, 0x000054102e067816ULL, 0x142fe40000000017ULL,
0x000076322e077816ULL, 0x000fca0000000017ULL, 0x0000000614007388ULL, 0x0003e80000000a00ULL,
0x0004001a0b007388ULL, 0x000fe80000000a00ULL, 0x0004001e0c007388ULL, 0x000fe20000000a00ULL,
0x000054104c067816ULL, 0x002fc60000000026ULL, 0x000400220e007388ULL, 0x000fe20000000a00ULL,
0x000076324c077816ULL, 0x000fca0000000026ULL, 0x0000000616007388ULL, 0x0003e80000000a00ULL,
0x000800080b007388ULL, 0x0005e20000000a00ULL, 0x0000005a5b06723eULL, 0x002fe200000010ffULL,
0x000000ff00077306ULL, 0x000fe20000209400ULL, 0x000054105c087816ULL, 0x144fe40000000060ULL,
0x000076325c097816ULL, 0x000fca0000000060ULL, 0x000800080c007388ULL, 0x0003e40000000a00ULL,
0x0000541064087816ULL, 0x142fe40000000032ULL, 0x0000763264097816ULL, 0x000fca0000000032ULL,
0x000800080e007388ULL, 0x0003e40000000a00ULL, 0x0000541000087816ULL, 0x142fe40000000002ULL,
0x0000763200097816ULL, 0x000fe40000000002ULL, 0x0000005e5f00723eULL, 0x000fe400000010ffULL,
0x000000626302723eULL, 0x000fe200000010ffULL, 0x0000000818007388ULL, 0x0003e40000000a00ULL,
0x0000541004087816ULL, 0x002fc40000000006ULL, 0x0000763204097816ULL, 0x000fe40000000006ULL,
0x000000666704723eULL, 0x000fe400000010ffULL, 0x0000006a6b06723eULL, 0x000fe200000010ffULL,
0x000c00080b007388ULL, 0x0003e40000000a00ULL, 0x0000541000087816ULL, 0x142fe40000000002ULL,
0x0000763200097816ULL, 0x000fe40000000002ULL, 0x000000ff00007306ULL, 0x000e660000205400ULL,
0x000c00080c007388ULL, 0x0005e40000000a00ULL, 0x0000541004087816ULL, 0x004fc40000000006ULL,
0x0000763204097816ULL, 0x000fe40000000006ULL, 0x000000000700720bULL, 0x002fe40003f1d000ULL,
0x000000ff00007245ULL, 0x000fe2000020d400ULL, 0x000c00080e007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000084147984ULL, 0x000e620000000c00ULL,
0x0000000100000812ULL, 0x000fc400078efcffULL, 0x000000ff0a00720cULL, 0x000fe20003f05270ULL,
0x00040000841c7984ULL, 0x000ea20000000c00ULL, 0x00000000000b723eULL, 0x000fc600000010ffULL,
0x0008000084247984ULL, 0x000ee80000000c00ULL, 0x000c0000842c7984ULL, 0x000ee80000000c00ULL,
0x0010000084187984ULL, 0x000ee80000000c00ULL, 0x0014000084207984ULL, 0x000ee80000000c00ULL,
0x0018000084287984ULL, 0x000ee80000000c00ULL, 0x001c0000840c7984ULL, 0x000ee20000000c00ULL,
0x3f803f800b177831ULL, 0x002fc40000200017ULL, 0x3f803f800b167831ULL, 0x040fe40000200016ULL,
0x3f803f800b157831ULL, 0x040fe40000200015ULL, 0x3f803f800b147831ULL, 0x040fe40000200014ULL,
0x3f803f800b1f7831ULL, 0x044fe4000020001fULL, 0x3f803f800b1e7831ULL, 0x040fe4000020001eULL,
0x3f803f800b1d7831ULL, 0x000fc4000020001dULL, 0x3f803f800b1c7831ULL, 0x040fe4000020001cULL,
0x3f803f800b277831ULL, 0x048fe40000200027ULL, 0x3f803f800b267831ULL, 0x040fe40000200026ULL,
0x3f803f800b257831ULL, 0x040fe40000200025ULL, 0x3f803f800b247831ULL, 0x040fe40000200024ULL,
0x3f803f800b2f7831ULL, 0x000fc4000020002fULL, 0x3f803f800b2e7831ULL, 0x040fe4000020002eULL,
0x3f803f800b2d7831ULL, 0x040fe4000020002dULL, 0x3f803f800b2c7831ULL, 0x000fe4000020002cULL,
0x3f803f8017177831ULL, 0x000fe4000020001bULL, 0x3f803f8016167831ULL, 0x000fe4000020001aULL,
0x3f803f8015157831ULL, 0x000fc40000200019ULL, 0x3f803f8014147831ULL, 0x000fe40000200018ULL,
0x3f803f801f1f7831ULL, 0x000fe40000200023ULL, 0x3f803f801e1e7831ULL, 0x000fe20000200022ULL,
0x0000001484007388ULL, 0x000fe20000000c00ULL, 0x3f803f801d1d7831ULL, 0x000fe40000200021ULL,
0x3f803f801c1c7831ULL, 0x000fe40000200020ULL, 0x3f803f8027277831ULL, 0x000fc4000020002bULL,
0x3f803f8026267831ULL, 0x000fe2000020002aULL, 0x0004001c84007388ULL, 0x000fe20000000c00ULL,
0x3f803f8025257831ULL, 0x000fe40000200029ULL, 0x3f803f8024247831ULL, 0x000fe40000200028ULL,
0x3f803f802f2f7831ULL, 0x000fe4000020000fULL, 0x3f803f802e2e7831ULL, 0x000fe2000020000eULL,
0x0008002484007388ULL, 0x000fe20000000c00ULL, 0x3f803f802d2d7831ULL, 0x000fc4000020000dULL,
0x3f803f802c2c7831ULL, 0x000fca000020000cULL, 0x000c002c84007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fc80000011603ULL, 0x0000007a0900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000027b06ULL, 0x000e620000209000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00005a00ff157a12ULL, 0x000fe200078e33ffULL,
0x0000000110007824ULL, 0x000fe200078e0209ULL, 0x0000000111117812ULL, 0x000fc800078ec0ffULL,
0x0000000200027308ULL, 0x002e640000001000ULL, 0x0ffffffe02087810ULL, 0x002fe20007ffe0ffULL,
0x0000000109027824ULL, 0x000fca00078e0203ULL, 0x0000000800077305ULL, 0x000e62000021f000ULL,
0x0000000702027812ULL, 0x000fc800078ec0ffULL, 0x0ffffff802027812ULL, 0x000fca00078ef803ULL,
0x0000001002027824ULL, 0x000fe400078e0205ULL, 0x000000ffff0b7224ULL, 0x002fc800078e0a07ULL,
0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b07137227ULL, 0x000fe400078e0006ULL,
0x0000000002087984ULL, 0x0002a80000000c00ULL, 0x0000000013047227ULL, 0x000fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fe200078e0a04ULL, 0x0000000703027812ULL, 0x002fc600078ec0ffULL,
0x00005a0007067a24ULL, 0x000fca00078e0200ULL, 0x00005a0006007a0cULL, 0x000fda0003f06070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104040810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x00005a00ff007a0cULL, 0x000fd60003f05070ULL,
0x0000000104041810ULL, 0x000fc80007ffe0ffULL, 0x0000000415077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0212ULL,
0x00005a000d007a24ULL, 0x000fe400078e0200ULL, 0x00000008110d7824ULL, 0x000fe400078e0202ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x000000007b047210ULL, 0x000fe40007f3e0ffULL,
0x0000002003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0004067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011600ULL,
0x00005f0004077a11ULL, 0x000fe400008f4407ULL, 0x0000007a0f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000110027824ULL, 0x100fe400078e020fULL,
0x00000001000f7824ULL, 0x000fe400078e020fULL, 0x0000000213067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000615077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0212ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x00000008110d7824ULL, 0x000fe400078e0200ULL, 0x00005a0007027a24ULL, 0x000fca00078e0202ULL,
0x000000027b077210ULL, 0x000fe40007f3e0ffULL, 0x0000004003027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011602ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x0000007a0f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000110007824ULL, 0x100fe400078e020fULL, 0x00000001020f7824ULL, 0x000fe400078e020fULL,
0x0000000013067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0200ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef802ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000615077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0212ULL,
0x00005a000d007a24ULL, 0x000fe400078e0200ULL, 0x00000008110d7824ULL, 0x000fe400078e0202ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x000000007b077210ULL, 0x000fe40007f3e0ffULL,
0x0000006003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011600ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x0000007a0f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000110027824ULL, 0x100fe400078e020fULL,
0x00000001000f7824ULL, 0x000fe400078e020fULL, 0x0000000213067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000615077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0212ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x00000008110d7824ULL, 0x000fe400078e0200ULL, 0x00005a0007027a24ULL, 0x000fca00078e0202ULL,
0x000000027b077210ULL, 0x000fe40007f3e0ffULL, 0x0000008003027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011602ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x0000007a0f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000110007824ULL, 0x100fe400078e020fULL, 0x00000001020f7824ULL, 0x000fe400078e020fULL,
0x0000000013067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0200ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef802ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000615077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0212ULL,
0x00005a000d007a24ULL, 0x000fe400078e0200ULL, 0x00000008110d7824ULL, 0x000fe400078e0202ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x000000007b077210ULL, 0x000fe40007f3e0ffULL,
0x000000a003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011600ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x0000007a0f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000110027824ULL, 0x100fe200078e020fULL,
0x000000c0030c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001000f7824ULL, 0x000fe400078e020fULL,
0x0000000213067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef800ULL, 0x00000003ff0f7819ULL, 0x000fe4000001160cULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000615077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0212ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x00000008110d7824ULL, 0x000fe400078e0200ULL, 0x00005a0007027a24ULL, 0x000fca00078e0202ULL,
0x000000027b027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0002067a11ULL, 0x000fc800078240ffULL, 0x00005f0002077a11ULL, 0x000fe400008f4407ULL,
0x0000007a0f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000110007824ULL, 0x100fe400078e020fULL, 0x000000010c0f7824ULL, 0x000fe400078e020fULL,
0x0000000013067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007027a24ULL, 0x000fca00078e0200ULL,
0x00005a0002007a0cULL, 0x000fda0003f26070ULL, 0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0002007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f027812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001002047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000615077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0212ULL,
0x00005a000d007a24ULL, 0x000fc800078e0200ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x000000007b067210ULL, 0x000fe40007f3e0ffULL, 0x000000e003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0006027a11ULL, 0x040fe400078240ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011600ULL, 0x00005f0006037a11ULL, 0x000fe200008f4407ULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x0000007a0d00720cULL, 0x000fe20003f26070ULL,
0x0000000110107824ULL, 0x000fe400078e020dULL, 0x0000001007027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000001013037227ULL, 0x002fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e0a03ULL,
0x00000001000d7824ULL, 0x000fe400078e020dULL, 0x00005a0007027a24ULL, 0x000fc600078e0210ULL,
0x000000070d0d7812ULL, 0x000fe400078ec0ffULL, 0x00005a0002007a0cULL, 0x000fda0003f26070ULL,
0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103031810ULL, 0x000fe40007ffe0ffULL,
0x00005a0002007a0cULL, 0x000fe40003f46070ULL, 0xfffffff80d027812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001002057824ULL, 0x000fca00078e0205ULL,
0x0000000005087984ULL, 0x0002a20000000c00ULL, 0x0000000103032810ULL, 0x000fc80007ffe0ffULL,
0x0000000315037207ULL, 0x000fe20004000000ULL, 0x0000000811057824ULL, 0x002fc800078e0200ULL,
0x000000ffff077224ULL, 0x000fe400078e0a03ULL, 0x0000590003037a24ULL, 0x000fe400078e0212ULL,
0x00005a0007107a24ULL, 0x000fc800078e0210ULL, 0x00005a0003107a24ULL, 0x000fca00078e0210ULL,
0x000000107b107210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005e0010027a11ULL, 0x000fc800078040ffULL, 0x00005f0010037a11ULL, 0x000fca00000f4403ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x004fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000d1100720cULL, 0x000fe20003f06070ULL,
0xffffffffff007424ULL, 0x000fd800078e00ffULL, 0x0000000204088824ULL, 0x002fc800078e00ffULL,
0x00006a0008088a24ULL, 0x000fc800078e0211ULL, 0x0000660008088625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000608008981ULL, 0x000ea2000c1e1900ULL,
0x00006e00ff687624ULL, 0x000fe400078e00ffULL, 0x00006f00ff697624ULL, 0x000fe200078e00ffULL,
0x01260000ff067f8cULL, 0x000e68000c80043fULL, 0x0000000668687981ULL, 0x000722000c1e9900ULL,
0x000001ff1400780cULL, 0x000fe20003f04070ULL, 0x00005800ff667624ULL, 0x000fc400078e00ffULL,
0x0000004065657824ULL, 0x000fe400078e00ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000001f66667810ULL, 0x000fe20007ffe0ffULL, 0x0000004011677824ULL, 0x000fe400078e00ffULL,
0x0000004012647824ULL, 0x000fe200078e00ffULL, 0x00000005ff667819ULL, 0x000fe20000011666ULL,
0x00000065000a7224ULL, 0x004fc800078e02ffULL, 0x000064000a087625ULL, 0x000fe200078e000bULL,
0x0000060000000947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x00afe4000001160fULL,
0x0000000f0f1c7211ULL, 0x000fe400078fe8ffULL, 0x0000200011227811ULL, 0x000fe200078e68ffULL,
0x0000004012217824ULL, 0x000fe200078e0229ULL, 0x000000031c207812ULL, 0x000fe400078ec0ffULL,
0x0000000829237810ULL, 0x000fe20007ffe0ffULL, 0x00000080210a7825ULL, 0x040fe200078e00ffULL,
0x0000001021167810ULL, 0x000fc40007ffe0ffULL, 0x0000000821147810ULL, 0x000fe40007ffe0ffULL,
0x000000300a1d7812ULL, 0x100fe200078ef802ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000670e0a7217ULL, 0x000fe40007800000ULL, 0x0000001d08187210ULL, 0x000fe20007f1e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000003016197812ULL, 0x000fe400078ef802ULL,
0x0ffffffc200f7812ULL, 0x000fe200078ef80fULL, 0x000000010a127824ULL, 0x000fe200078e0a67ULL,
0x0000001908167210ULL, 0x000fe20007f5e0ffULL, 0x0000000109197824ULL, 0x000fe200000e060bULL,
0x00000018210b7810ULL, 0x000fe20007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0222ULL,
0x00000030141b7812ULL, 0x000fe200078ef802ULL, 0x0000000109177824ULL, 0x000fe200010e0617ULL,
0x0000002021147810ULL, 0x000fe20007ffe0ffULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000001b081a7210ULL, 0x000fc40007f3e0ffULL, 0x000000122900720cULL, 0x080fe40003f06070ULL,
0x000000300a1d7812ULL, 0x100fe200078ef802ULL, 0x00000001091b7824ULL, 0x000fe200008e0615ULL,
0x00000028210a7810ULL, 0x000fe20007ffe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000001d081c7210ULL, 0x000fe40007f5e0ffULL, 0x000000122300720cULL, 0x040fe20003f26070ULL,
0x0000000423237824ULL, 0x000fe200078e00ffULL, 0x00000030141f7812ULL, 0x000fe200078ef802ULL,
0x00000001091d7824ULL, 0x000fe200010e060bULL, 0x0000002829257810ULL, 0x000fe20007ffe0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001f081e7210ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000180f7faeULL, 0x0003e2000c101c46ULL,
0xfffffffc23237812ULL, 0x000fc400078ee220ULL, 0x000000300a2b7812ULL, 0x000fe200078ef802ULL,
0x00000001091f7824ULL, 0x000fe200018e0615ULL, 0x00000030210a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001023237824ULL, 0x000fe200078e0222ULL, 0x0000002029157810ULL, 0x040fe40007ffe0ffULL,
0x00000010292d7810ULL, 0x040fe40007ffe0ffULL, 0x00000018292f7810ULL, 0x000fe20007ffe0ffULL,
0x000000001a237faeULL, 0x0005e2000c901c46ULL, 0x0000002b08187210ULL, 0x002fe20007fde0ffULL,
0x000000042d0f7824ULL, 0x000fe200078e00ffULL, 0x0000003029277810ULL, 0x000fc40007ffe0ffULL,
0x000000121500720cULL, 0x080fe20003f66070ULL, 0x0000000109197824ULL, 0x000fe200030e060bULL,
0x0000003829297810ULL, 0x000fe20007ffe0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000003821147810ULL, 0x000fe40007ffe0ffULL, 0x000000122500720cULL, 0x080fe20003f46070ULL,
0x0000000415157824ULL, 0x000fe200078e00ffULL, 0x000000122700720cULL, 0x080fe20003f26070ULL,
0x0000000425257824ULL, 0x000fe200078e00ffULL, 0x000000300a237812ULL, 0x004fe200078ef802ULL,
0x0000000427277824ULL, 0x000fe200078e00ffULL, 0x000000122900720cULL, 0x0c0fe20003f06070ULL,
0x0000000429297824ULL, 0x000fe200078e00ffULL, 0xfffffffc15217812ULL, 0x000fe200078ee220ULL,
0x000000042f1b7824ULL, 0x000fe200078e00ffULL, 0x000000122d00720cULL, 0x000fe20003fa6070ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x00000023080a7210ULL, 0x000fc40007fde0ffULL,
0x000000122f00720cULL, 0x000fe20003f86070ULL, 0x0000001021217824ULL, 0x000fe200078e0222ULL,
0xfffffffc25237812ULL, 0x100fe200078ee220ULL, 0x00000001090b7824ULL, 0x000fe200030e060bULL,
0xfffffffc27257812ULL, 0x100fe400078ee220ULL, 0xfffffffc0f0f7812ULL, 0x000fe200078ee220ULL,
0x0000001023237824ULL, 0x000fe200078e0222ULL, 0xfffffffc29277812ULL, 0x000fe200078ee220ULL,
0x0000001025257824ULL, 0x000fe200078e0222ULL, 0xfffffffc1b1b7812ULL, 0x000fe200078ee220ULL,
0x000000100f0f7824ULL, 0x000fe200078e0222ULL, 0x0000003014297812ULL, 0x000fe200078ef802ULL,
0x0000001027277824ULL, 0x000fc400078e0222ULL, 0x000000101b1b7824ULL, 0x000fe200078e0222ULL,
0x0000002908087210ULL, 0x000fe20007fde0ffULL, 0x00000000160f7faeULL, 0x0003e8000e901c46ULL,
0x0000000109097824ULL, 0x000fe200030e0615ULL, 0x000000001c1b7faeULL, 0x0003e8000e101c46ULL,
0x000000001e217faeULL, 0x0003e8000d901c46ULL, 0x0000000018237faeULL, 0x0003e8000d101c46ULL,
0x000000000a257faeULL, 0x0003e8000c901c46ULL, 0x0000000008277faeULL, 0x0003e2000c101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x000000080f157811ULL, 0x04afe400078ff0ffULL,
0x000000100f177811ULL, 0x000fc400078ff0ffULL, 0x0000000f0f0b7211ULL, 0x000fe200078fe8ffULL,
0x00000004151d7824ULL, 0x000fe200078e00ffULL, 0x000000180f237811ULL, 0x000fe200078ff0ffULL,
0x00000004171f7824ULL, 0x000fe200078e00ffULL, 0x000000200f197811ULL, 0x040fe200078ff0ffULL,
0x0000000164167824ULL, 0x000fe200078e0217ULL, 0x000000280f1b7811ULL, 0x000fe200078ff0ffULL,
0x0000000423217824ULL, 0x000fe200078e00ffULL, 0x000000300f2b7811ULL, 0x000fe200078ff0ffULL,
0x0000000419257824ULL, 0x000fe200078e00ffULL, 0x000000380f2f7811ULL, 0x000fe200078ff0ffULL,
0x000000041b277824ULL, 0x000fe200078e00ffULL, 0x000000030b147812ULL, 0x000fe200078ec0ffULL,
0x000000042b297824ULL, 0x000fe200078e00ffULL, 0x000000640f0a7211ULL, 0x000fe200078ff0ffULL,
0x000000042f2d7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc14207812ULL, 0x000fe200078ef80fULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0xfffffffc1d0f7812ULL, 0x000fc400078ee214ULL,
0xfffffffc1f127812ULL, 0x100fe200078ee214ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffffc21187812ULL, 0x100fe400078ee214ULL, 0xfffffffc251a7812ULL, 0x100fe400078ee214ULL,
0xfffffffc271d7812ULL, 0x100fe400078ee214ULL, 0xfffffffc291e7812ULL, 0x100fe400078ee214ULL,
0xfffffffc2d1f7812ULL, 0x000fe200078ee214ULL, 0x0000000164147824ULL, 0x000fe200078e0215ULL,
0x0000200011317811ULL, 0x000fc400078e68ffULL, 0x000000300a217812ULL, 0x000fe200078ef802ULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0x00000021081c7210ULL, 0x000fe20007f1e0ffULL,
0x000000101d297824ULL, 0x000fe200078e0231ULL, 0x00000030141d7812ULL, 0x100fe200078ef802ULL,
0x00000001640a7824ULL, 0x000fe200078e0223ULL, 0x0000003016217812ULL, 0x000fe200078ef802ULL,
0x000000101e2d7824ULL, 0x100fe200078e0231ULL, 0x0000001d081e7210ULL, 0x000fe20007f3e0ffULL,
0x0000001020377824ULL, 0x000fe200078e0231ULL, 0x0000002108207210ULL, 0x000fe20007f5e0ffULL,
0x00000001091d7824ULL, 0x000fe400000e060bULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c377faeULL, 0x0003e2000b901c46ULL,
0x0000000109217824ULL, 0x000fe200010e0617ULL, 0x000000300a177812ULL, 0x000fe200078ef802ULL,
0x0000000164147824ULL, 0x000fe400078e0219ULL, 0x000000100f0f7824ULL, 0x100fe200078e0231ULL,
0x00000017080a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001012237824ULL, 0x100fe400078e0231ULL,
0x0000001018257824ULL, 0x100fe400078e0231ULL, 0x000000101a277824ULL, 0x000fc400078e0231ULL,
0x0000000164167824ULL, 0x040fe400078e021bULL, 0x000000101f317824ULL, 0x000fe400078e0231ULL,
0x0000000164187824ULL, 0x040fe400078e022bULL, 0x00000001091f7824ULL, 0x000fe400008e0615ULL,
0x00000001641a7824ULL, 0x000fe400078e022fULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000001e0f7faeULL, 0x0003e6000b901c46ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003014357812ULL, 0x100fe200078ef802ULL, 0x0000000020237faeULL, 0x0003e4000b901c46ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000003016337812ULL, 0x000fc600078ef802ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x00000030182f7812ULL, 0x100fe400078ef802ULL,
0x0000003308167210ULL, 0x000fe20007f3e0ffULL, 0x00000001090b7824ULL, 0x040fe200000e060bULL,
0x000000301a2b7812ULL, 0x000fe400078ef802ULL, 0x0000003508147210ULL, 0x040fe20007f1e0ffULL,
0x0000000109177824ULL, 0x040fe200008e0617ULL, 0x0000002f08187210ULL, 0x040fe20007f5e0ffULL,
0x000000000a257faeULL, 0x0003e2000b901c46ULL, 0x0000002b08087210ULL, 0x000fe20007f7e0ffULL,
0x0000000109157824ULL, 0x000fc400000e0615ULL, 0x0000000109197824ULL, 0x040fe400010e0619ULL,
0x0000000109097824ULL, 0x000fe200018e061bULL, 0x0000000014277faeULL, 0x0003e8000b901c46ULL,
0x0000000016297faeULL, 0x0003e8000b901c46ULL, 0x00000000182d7faeULL, 0x0003e8000b901c46ULL,
0x0000000008317faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x01260400ff0b7984ULL, 0x000e620000000800ULL,
0x0000006603027224ULL, 0x000fc400078e02ffULL, 0x000000010e0f7824ULL, 0x000fe400078e0a13ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x800000000bff7812ULL, 0x002fe20007804807ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620002027625ULL, 0x000fe200078e0005ULL, 0x00000008ff0f7819ULL, 0x000fe2000001160fULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e640000000000ULL,
0x0000002011057824ULL, 0x002fca00078e0206ULL, 0x00000004ff067819ULL, 0x000fe40000011605ULL,
0x0000000105077810ULL, 0x040fe40007ffe0ffULL, 0x0ffffffe06087812ULL, 0x000fe400078ec0ffULL,
0x0000001f05067812ULL, 0x000fc600078ec0ffULL, 0x00000001080a7824ULL, 0x040fe400078e0207ULL,
0x0000000105097824ULL, 0x000fe200078e0208ULL, 0x0000000808087810ULL, 0x000fe20007ffe0ffULL,
0x00000010060b7824ULL, 0x000fe200078e00ffULL, 0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000001006127824ULL, 0x000fe200078e00ffULL, 0x0000000f09097812ULL, 0x000fe200078ec0ffULL,
0x0000000107077824ULL, 0x000fe200078e0208ULL, 0x000001f00b0a7812ULL, 0x000fe200078ee20aULL,
0x0000000105057824ULL, 0x000fe200078e0208ULL, 0x000001f012097812ULL, 0x000fe200078ee209ULL,
0x0000001006087824ULL, 0x040fe200078e00ffULL, 0x0000000f07077812ULL, 0x000fe200078ec0ffULL,
0x000000000a147984ULL, 0x000e62000000cc00ULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x0000000f05057812ULL, 0x000fc400078ec0ffULL, 0x0000000009187984ULL, 0x000ea4000000cc00ULL,
0x000001f006077812ULL, 0x000fe400078ee207ULL, 0x000001f008057812ULL, 0x000fe200078ee205ULL,
0x000000ffff1e7224ULL, 0x002fe400078e0014ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0016ULL,
0x000000ffff1c7224ULL, 0x004fe400078e0018ULL, 0x000000ffff1d7224ULL, 0x000fc400078e001aULL,
0x000000ffff227224ULL, 0x000fe400078e0015ULL, 0x000000ffff237224ULL, 0x000fe200078e0017ULL,
0x0000001c09007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff207224ULL, 0x000fe400078e0019ULL,
0x000000ffff217224ULL, 0x000fca00078e001bULL, 0x000000200a007388ULL, 0x000fe8000000cc00ULL,
0x0000000007147984ULL, 0x000e68000000cc00ULL, 0x0000000005187984ULL, 0x000ea2000000cc00ULL,
0x000000ffff277224ULL, 0x002fe400078e0016ULL, 0x000000ffff267224ULL, 0x000fc400078e0014ULL,
0x000000ffff167224ULL, 0x000fe400078e0015ULL, 0x000000ffff247224ULL, 0x004fe400078e0018ULL,
0x000000ffff257224ULL, 0x000fe400078e001aULL, 0x000000ffff147224ULL, 0x000fe400078e0019ULL,
0x000000ffff157224ULL, 0x000fe200078e001bULL, 0x0000002405007388ULL, 0x0003e8000000cc00ULL,
0x0000001407007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01260000ff0a7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff127224ULL, 0x000fc600078e00ffULL,
0x0000000000067805ULL, 0x002fc80000015200ULL, 0x01260400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x006fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011409ULL,
0x0000000805057211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000205057819ULL, 0x000fc80000001208ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000697919ULL, 0x000e620000000000ULL, 0x00006a0004127a24ULL, 0x000fe200078e02ffULL,
0x3db504f368687820ULL, 0x010fe20000410000ULL, 0x0000000266667824ULL, 0x000fe200078e00ffULL,
0x00012688116a7811ULL, 0x000fe200078e18ffULL, 0x000000ffff6e7224ULL, 0x000fe200078e00ffULL,
0xffffffff136b7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x00000009136c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff6f7224ULL, 0x000fe200078e0011ULL,
0x00012608116d7811ULL, 0x000fc400078e28ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e0070ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x008fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x014fc4000001ff00ULL,
0x000000017100780cULL, 0x040fe20003f25270ULL, 0x00000080ff187424ULL, 0x020fe200078e00ffULL,
0x000000016e1a7810ULL, 0x000fe20007ffe0ffULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x0000000171147810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff737224ULL, 0x000fe200078e0071ULL,
0x0000000172707812ULL, 0x000fc400078e0cffULL, 0x000000021400780cULL, 0x040fe20003f06070ULL,
0x000000ffff717224ULL, 0x000fe200078e0014ULL, 0x000000ff14167207ULL, 0x000fc60000800000ULL,
0x000000ffff1a1224ULL, 0x000fca00078e026eULL, 0x000000011a157810ULL, 0x000fc80007ffe0ffULL,
0x0000000c1500720cULL, 0x000fe20003f46070ULL, 0x0000006500157224ULL, 0x010fc800078e02ffULL,
0x0000640015147625ULL, 0x000fd000078e0018ULL, 0x000005e00000a947ULL, 0x000fea0003800000ULL,
0x0000001069177824ULL, 0x002fe200078e00ffULL, 0x00000002ff627819ULL, 0x000fe20000011669ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x0000000211607824ULL, 0x000fe200078e0270ULL,
0x0000003017177812ULL, 0x000fe200078ec0ffULL, 0x00000001641b7824ULL, 0x000fe200078e0262ULL,
0x00000008625d7810ULL, 0x040fe40007ffe0ffULL, 0x0000001062637810ULL, 0x000fe20007ffe0ffULL,
0x0000004016187824ULL, 0x000fe200078e0217ULL, 0x0000001862767810ULL, 0x000fe20007ffe0ffULL,
0x000001001a177824ULL, 0x000fe200078e0267ULL, 0x0000002062787810ULL, 0x000fe20007ffe0ffULL,
0x000000801b1a7825ULL, 0x000fe200078e0018ULL, 0x0000200060607811ULL, 0x000fc400078e60ffULL,
0x000000170e567217ULL, 0x000fe20007800000ULL, 0x0000000164557824ULL, 0x000fe200078e025dULL,
0x0000001a14587210ULL, 0x000fe20007f3e0ffULL, 0x0000000164577824ULL, 0x000fe200078e0263ULL,
0x00000069691a7211ULL, 0x000fe200078fe8ffULL, 0x0000008055547825ULL, 0x000fe200078e0018ULL,
0x0000002862797810ULL, 0x000fe40007ffe0ffULL, 0x000000031a747812ULL, 0x000fe200078ec0ffULL,
0x0000000156177824ULL, 0x000fe200078e0a17ULL, 0x00000054145a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000115597824ULL, 0x000fe200008e061bULL, 0x0ffffffc74617812ULL, 0x000fe200078ef869ULL,
0x0000008057567825ULL, 0x000fe200078e0018ULL, 0x00000030627a7810ULL, 0x000fc40007ffe0ffULL,
0x000000177600720cULL, 0x080fe20003fa6070ULL, 0x00000001641b7824ULL, 0x000fe200078e0276ULL,
0x0000005614567210ULL, 0x000fe20007f3e0ffULL, 0x00000001155b7824ULL, 0x000fe200010e0655ULL,
0x000000175d00720cULL, 0x000fe20003f46070ULL, 0x000000801b1a7825ULL, 0x000fc800078e0018ULL,
0x0000000164557824ULL, 0x000fe200078e0278ULL, 0x0000001a145c7210ULL, 0x000fe20007f7e0ffULL,
0x0000000115577824ULL, 0x000fe200008e0657ULL, 0x000000176200720cULL, 0x040fe20003f26070ULL,
0x0000008055547825ULL, 0x000fe200078e0018ULL, 0x0000003862627810ULL, 0x000fc60007ffe0ffULL,
0x000000045d757824ULL, 0x000fe200078e00ffULL, 0x00000054145e7210ULL, 0x000fe20007f9e0ffULL,
0x00000001155d7824ULL, 0x000fe200018e061bULL, 0x000000176300720cULL, 0x080fe20003f66070ULL,
0x00000010611b7824ULL, 0x000fe400078e0260ULL, 0x0000000463617824ULL, 0x000fe400078e00ffULL,
0x00000001155f7824ULL, 0x000fe200020e0655ULL, 0xfffffffc75557812ULL, 0x100fe200078ee274ULL,
0x0000000164637824ULL, 0x040fe200078e0279ULL, 0xfffffffc61617812ULL, 0x000fe200078ee274ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000581b7faeULL, 0x0003e2000c901c46ULL,
0x0000000164757824ULL, 0x000fe200078e027aULL, 0x000000177800720cULL, 0x080fe20003f86070ULL,
0x0000001055557824ULL, 0x100fe200078e0260ULL, 0x000000176200720cULL, 0x000fe20003f26070ULL,
0x0000001061617824ULL, 0x000fc400078e0260ULL, 0x0000000164777824ULL, 0x000fe200078e0262ULL,
0x000000005a557faeULL, 0x0005e2000d101c46ULL, 0x000000177a00720cULL, 0x080fe20003f46070ULL,
0x00000080631a7825ULL, 0x102fe400078e0018ULL, 0x0000000056617faeULL, 0x0003e2000d901c46ULL,
0x000000177900720cULL, 0x040fe20003f66070ULL, 0x0000000476177824ULL, 0x000fe200078e00ffULL,
0x0000001a141a7210ULL, 0x000fe20007fde0ffULL, 0x0000000479597824ULL, 0x000fe400078e00ffULL,
0x0000008075547825ULL, 0x004fe200078e0018ULL, 0xfffffffc17177812ULL, 0x000fc400078ee274ULL,
0xfffffffc59597812ULL, 0x000fe200078ee274ULL, 0x00000001151b7824ULL, 0x000fe200030e061bULL,
0x0000005414547210ULL, 0x000fe20007fde0ffULL, 0x0000000478577824ULL, 0x002fe400078e00ffULL,
0x000000047a5b7824ULL, 0x000fe400078e00ffULL, 0x0000008077187825ULL, 0x000fe200078e0018ULL,
0xfffffffc57577812ULL, 0x100fe400078ee274ULL, 0xfffffffc5b5b7812ULL, 0x000fe200078ee274ULL,
0x0000000462617824ULL, 0x000fc400078e00ffULL, 0x0000000115557824ULL, 0x000fe200030e0655ULL,
0x0000001814147210ULL, 0x000fe20007fde0ffULL, 0x0000001017177824ULL, 0x000fe200078e0260ULL,
0xfffffffc61617812ULL, 0x000fe200078ee274ULL, 0x0000001057577824ULL, 0x100fe400078e0260ULL,
0x0000001059597824ULL, 0x100fe200078e0260ULL, 0x000000005c177faeULL, 0x0003e2000e901c46ULL,
0x000000105b5b7824ULL, 0x100fe400078e0260ULL, 0x0000001061617824ULL, 0x000fe200078e0260ULL,
0x000000005e577faeULL, 0x0003e2000e101c46ULL, 0x0000000115157824ULL, 0x000fc600030e0619ULL,
0x000000001a597faeULL, 0x0003e8000d901c46ULL, 0x00000000545b7faeULL, 0x0003e8000d101c46ULL,
0x0000000014617faeULL, 0x0003e2000c901c46ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x0000000211197824ULL, 0x000fe200078e0270ULL, 0x00000008691b7811ULL, 0x002fc400078ff0ffULL,
0x0000001069557811ULL, 0x040fe400078ff0ffULL, 0x0000001869577811ULL, 0x040fe400078ff0ffULL,
0x0000002069597811ULL, 0x000fe200078ff0ffULL, 0x0000000455617824ULL, 0x000fe200078e00ffULL,
0x00000028695b7811ULL, 0x000fe200078ff0ffULL, 0x0000000457637824ULL, 0x000fe200078e00ffULL,
0x00000030695d7811ULL, 0x000fe200078ff0ffULL, 0x0000000459757824ULL, 0x000fe200078e00ffULL,
0x00000038697f7811ULL, 0x000fe200078ff0ffULL, 0x000000045b777824ULL, 0x000fe200078e00ffULL,
0x0000006969177211ULL, 0x000fe200078fe8ffULL, 0x000000045d797824ULL, 0x000fe200078e00ffULL,
0x00002000191a7811ULL, 0x000fe200078e60ffULL, 0x000000041b197824ULL, 0x000fe200078e00ffULL,
0x0000000317187812ULL, 0x000fe200078ec0ffULL, 0x000000047f7b7824ULL, 0x000fc400078e00ffULL,
0x00000001641b7824ULL, 0x040fe200078e021bULL, 0xfffffffc19197812ULL, 0x100fe200078ee218ULL,
0x0000000164557824ULL, 0x040fe200078e0255ULL, 0xfffffffc61617812ULL, 0x100fe200078ee218ULL,
0x0000000164577824ULL, 0x040fe200078e0257ULL, 0xfffffffc63637812ULL, 0x100fe200078ee218ULL,
0x0000000164597824ULL, 0x000fe200078e0259ULL, 0xfffffffc75757812ULL, 0x000fe200078ee218ULL,
0x0000001061617824ULL, 0x000fe200078e021aULL, 0xfffffffc77777812ULL, 0x000fe200078ee218ULL,
0x0000001063637824ULL, 0x100fe200078e021aULL, 0x0ffffffc18177812ULL, 0x000fe200078ef869ULL,
0x0000001075757824ULL, 0x000fe200078e021aULL, 0xfffffffc79797812ULL, 0x000fe200078ee218ULL,
0x0000001077777824ULL, 0x000fe200078e021aULL, 0xfffffffc7b7b7812ULL, 0x000fe200078ee218ULL,
0x0000001069187824ULL, 0x000fc400078e00ffULL, 0x00000010177d7824ULL, 0x100fe400078e021aULL,
0x0000001019177824ULL, 0x100fe200078e021aULL, 0x00000030185f7812ULL, 0x000fe200078ec0ffULL,
0x0000001079797824ULL, 0x100fe200078e021aULL, 0x0000006469197211ULL, 0x000fe200078ff0ffULL,
0x000000107b7b7824ULL, 0x000fe400078e021aULL, 0x00000040165e7824ULL, 0x000fe400078e025fULL,
0x000000ffff5f7224ULL, 0x000fc400078e00ffULL, 0x00000001645b7824ULL, 0x000fe400078e025bULL,
0x0000008019187825ULL, 0x000fc800078e005eULL, 0x000000801b1a7825ULL, 0x000fe200078e005eULL,
0x0000001814187210ULL, 0x000fc60007f3e0ffULL, 0x0000008055547825ULL, 0x000fe200078e005eULL,
0x0000001a141a7210ULL, 0x000fc60007f5e0ffULL, 0x0000008057567825ULL, 0x000fe200078e005eULL,
0x0000005414547210ULL, 0x000fc60007f7e0ffULL, 0x00000001645d7824ULL, 0x000fe200078e025dULL,
0x0000005614567210ULL, 0x000fe20007f9e0ffULL, 0x00000001647f7824ULL, 0x000fe400078e027fULL,
0x0000008059587825ULL, 0x000fc800078e005eULL, 0x000000805b5a7825ULL, 0x000fc800078e005eULL,
0x000000805d5c7825ULL, 0x000fc800078e005eULL, 0x000000807f5e7825ULL, 0x000fc800078e005eULL,
0x0000000115197824ULL, 0x040fe200008e0619ULL, 0x0000005814587210ULL, 0x040fe20007f3e0ffULL,
0x00000001151b7824ULL, 0x040fe200010e061bULL, 0x0000005a145a7210ULL, 0x040fe20007f5e0ffULL,
0x0000000115557824ULL, 0x040fe200018e0655ULL, 0x0000005c145c7210ULL, 0x040fe20007f7e0ffULL,
0x0000000115577824ULL, 0x040fe200020e0657ULL, 0x0000005e14147210ULL, 0x000fe20007f9e0ffULL,
0x0000000115597824ULL, 0x040fe200008e0659ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000187d7faeULL, 0x0003e2000b901c46ULL, 0x00000001155b7824ULL, 0x000fc400010e065bULL,
0x00000001155d7824ULL, 0x040fe200018e065dULL, 0x000000001a177faeULL, 0x0003e2000b901c46ULL,
0x0000000115157824ULL, 0x000fc600020e065fULL, 0x0000000054617faeULL, 0x0003e8000b901c46ULL,
0x0000000056637faeULL, 0x0003e8000b901c46ULL, 0x0000000058757faeULL, 0x0003e8000b901c46ULL,
0x000000005a777faeULL, 0x0003e8000b901c46ULL, 0x000000005c797faeULL, 0x0003e8000b901c46ULL,
0x00000000147b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000011600780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x000000046f6f7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff007424ULL, 0x000fc600078e00ffULL, 0x0000000d6f00720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000212147824ULL, 0x002fe400078e026fULL,
0x00000004ff157424ULL, 0x000fc800078e00ffULL, 0x0000660014147625ULL, 0x000fca00078e0015ULL,
0x0000000614007981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000008737b7824ULL, 0x002fe400078e00ffULL,
0x000000ffff147224ULL, 0x000fe400078e00ffULL, 0x00000010ff7a7424ULL, 0x000fe200078e00ffULL,
0x000000127b797810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff787224ULL, 0x000fe200078e00ffULL,
0x000000027b7b7810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff869167812ULL, 0x000fe200078ec0ffULL, 0x0000000211607824ULL, 0x000fe200078e0272ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008691a7812ULL, 0x020fc400078ec0ffULL,
0x0000000716177812ULL, 0x000fe400078ef869ULL, 0x0000200060607811ULL, 0x000fe400078e60ffULL,
0x00000001ff197819ULL, 0x000fe20000011617ULL, 0x0000000417167824ULL, 0x000fe200078e00ffULL,
0x0000000769187812ULL, 0x000fe200078ec0ffULL, 0x0000000417547824ULL, 0x000fe200078e00ffULL,
0x0000000178827810ULL, 0x000fe20007ffe0ffULL, 0x0000000119157824ULL, 0x000fe200078e0278ULL,
0x000000071a1b7812ULL, 0x000fc600078ef869ULL, 0x0000000119197824ULL, 0x000fe200078e0282ULL,
0xfffffffc16157812ULL, 0x000fe200078ee215ULL, 0x0000000873167824ULL, 0x000fe200078e0214ULL,
0x000000101b177812ULL, 0x040fe200078efcffULL, 0x000000101b557824ULL, 0x000fe200078e00ffULL,
0xfffffffc54197812ULL, 0x000fe200078ee219ULL, 0x00000010155c7824ULL, 0x000fe200078e0260ULL,
0x0000001a69157211ULL, 0x000fe200078fe0ffULL, 0x000000101b1b7824ULL, 0x000fe400078e00ffULL,
0x0000001017547824ULL, 0x000fc400078e00ffULL, 0x000000005c5c783bULL, 0x000e620000000200ULL,
0x0000000118157824ULL, 0x000fe400078e0215ULL, 0x0000000873187824ULL, 0x000fe400078e027aULL,
0x0000000115167824ULL, 0x040fe200078e0216ULL, 0x0000007b151a7210ULL, 0x040fe20007ffe014ULL,
0x0000000115187824ULL, 0x040fe200078e0218ULL, 0x0000007915157210ULL, 0x000fe20007ffe014ULL,
0x0000001019747824ULL, 0x000fe200078e0260ULL, 0x0000002069147810ULL, 0x000fe20007ffe0ffULL,
0x0000001017577824ULL, 0x000fe200078e00ffULL, 0xfffffff055167812ULL, 0x000fc400078ee216ULL,
0xfffffff814147812ULL, 0x000fe200078ec0ffULL, 0x000000007474783bULL, 0x000ea20000000200ULL,
0xfffffff01b1a7812ULL, 0x000fe200078ee21aULL, 0x0000001016167824ULL, 0x000fe200078e00ffULL,
0x0000000714617812ULL, 0x000fe400078ef869ULL, 0xfffffff0541b7812ULL, 0x000fe200078ee215ULL,
0x000000101a627824ULL, 0x000fe200078e00ffULL, 0x00000001ff637819ULL, 0x000fe20000011661ULL,
0x000000001658783bULL, 0x0006a20000000200ULL, 0x00000004617d7824ULL, 0x000fe200078e00ffULL,
0xfffffff057187812ULL, 0x000fe200078ee218ULL, 0x0000000461847824ULL, 0x000fc400078e00ffULL,
0x000000101b1b7824ULL, 0x000fe400078e00ffULL, 0x0000001018187824ULL, 0x000fca00078e00ffULL,
0x000000001854783bULL, 0x000fe20000000200ULL, 0x00000018ff147819ULL, 0x102fe4000001165fULL,
0x0000ffff5f157812ULL, 0x000fe400078ec0ffULL, 0x00000014ff19723eULL, 0x000fe400020006ffULL,
0x00000010ff147819ULL, 0x000fe4000001165fULL, 0x00000008ff157819ULL, 0x000fe20000011615ULL,
0x20000019ff197230ULL, 0x000fe20000004100ULL, 0x000000ff14167812ULL, 0x008fe200078ec0ffULL,
0x0000000163147824ULL, 0x040fe200078e0278ULL, 0x00000018ff8e7819ULL, 0x000fe2000001165cULL,
0x0000000163637824ULL, 0x000fe200078e0282ULL, 0x00000016ff17723eULL, 0x000fc400020006ffULL,
0x00000015ff16723eULL, 0x000fe400020006ffULL, 0xfffffffc7d157812ULL, 0x000fe200078ee214ULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x00000010ff8c7819ULL, 0x000fe2000001165cULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x0000ffff5c977812ULL, 0x000fe200078ec0ffULL,
0x00000010157c7824ULL, 0x000fe200078e0260ULL, 0x00000018ff8f7819ULL, 0x004fe40000011674ULL,
0x0000008eff95723eULL, 0x000fc400020006ffULL, 0x000000ff5c5c7812ULL, 0x000fe200078ec0ffULL,
0x000000007c7c783bULL, 0x000e620000000200ULL, 0x000000ff8c8e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8c7819ULL, 0x000fe20000011697ULL, 0x20000095ff977230ULL, 0x000fe20000004100ULL,
0x0000008fffa2723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000008eff8f723eULL, 0x000fc400020006ffULL, 0x0000008cff8e723eULL, 0x000fe200020006ffULL,
0x2000005cff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff749a7812ULL, 0x000fe200078ec0ffULL,
0x2000008fff957230ULL, 0x000fe20000004100ULL, 0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL,
0x200000a2ff5c7230ULL, 0x000fe20000004100ULL, 0x0000009affa2723eULL, 0x000fe200020006ffULL,
0x2000008eff8f7230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff8e7819ULL, 0x000fe2000001168cULL, 0x200000a2ff8c7230ULL, 0x000fe20000004100ULL,
0x00000010ff167819ULL, 0x000fe20000011616ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fc40000011619ULL, 0x00000010ff177819ULL, 0x000fe20000011617ULL,
0x000000001b18783bULL, 0x000fe20000000200ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x0000105414817816ULL, 0x000fe40000000017ULL, 0x0000105416807816ULL, 0x000fe4000000005fULL,
0x00000010ff5f7819ULL, 0x000fe20000011677ULL, 0x000000006214783bULL, 0x0004e20000000200ULL,
0x0000ffff5ea47812ULL, 0x000fc400078ec0ffULL, 0xfffffffc84637812ULL, 0x000fe200078ee263ULL,
0x000000805804723cULL, 0x080f620000041804ULL, 0x00000018ff987819ULL, 0x002fe4000001167cULL,
0x00000018ff9b7819ULL, 0x000fe2000001167dULL, 0x0000001063637824ULL, 0x000fe200078e0260ULL,
0x00000098ff9a723eULL, 0x000fe400020006ffULL, 0x00000010ff987819ULL, 0x000fe20000011697ULL,
0x000000805408723cULL, 0x000f620000041808ULL, 0x00000010ff977819ULL, 0x000fe20000011695ULL,
0x2000009aff9a7230ULL, 0x000fe20000004100ULL, 0x00000010ff957819ULL, 0x000fc4000001168fULL,
0x00001054988f7816ULL, 0x000fe40000000097ULL, 0x00001054958e7816ULL, 0x000fe4000000008eULL,
0x000000ff7c997812ULL, 0x000fe400078ec0ffULL, 0x0000009bff95723eULL, 0x000fe400020006ffULL,
0x000000ff7e9e7812ULL, 0x000fe200078ec0ffULL, 0x0000008e581c723cULL, 0x000fe2000004181cULL,
0x00000099ff99723eULL, 0x000fe200020006ffULL, 0x20000095ffa37230ULL, 0x000fe20000004100ULL,
0x000000ff7d9c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff9d7819ULL, 0x000fe2000001167eULL,
0x20000099ff977230ULL, 0x000fe20000004100ULL, 0x0000009eff98723eULL, 0x000fe200020006ffULL,
0x0000008e5438723cULL, 0x000be20000041838ULL, 0x00000018ff957819ULL, 0x100fe4000001165dULL,
0x0000ffff5d9e7812ULL, 0x000fe200078ec0ffULL, 0x20000098ff987230ULL, 0x000fe20000004100ULL,
0x0000009cff9b723eULL, 0x000fe400020006ffULL, 0x00000010ff8e7819ULL, 0x020fc4000001165dULL,
0x000000ff5d8f7812ULL, 0x000fe200078ec0ffULL, 0x2000009bff9b7230ULL, 0x000fe20000004100ULL,
0x00000018ff5d7819ULL, 0x100fe4000001165eULL, 0x0000009dff99723eULL, 0x000fe400020006ffULL,
0x00000010ff9c7819ULL, 0x000fe4000001165eULL, 0x000000ff5e9d7812ULL, 0x000fe200078ec0ffULL,
0x20000099ff997230ULL, 0x000fe20000004100ULL, 0x0000005dff5e723eULL, 0x000fc400020006ffULL,
0x000000ff5f627812ULL, 0x004fe400078ec0ffULL, 0x00000008ff5d7819ULL, 0x000fe4000001169eULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x000000ff8e8e7812ULL, 0x000fe200078ec0ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000018ff9f7819ULL, 0x000fc4000001167fULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000095ff95723eULL, 0x000fe400020006ffULL,
0x000000ff9c9e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff9c7819ULL, 0x000fe200000116a4ULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x0000009fffa2723eULL, 0x000fe200020006ffULL,
0x2000005eff9f7230ULL, 0x000fe20000004100ULL, 0x00000010ff817819ULL, 0x000fe20000011662ULL,
0x2000008eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ffa07819ULL, 0x000fe2000001167cULL,
0x000000006360783bULL, 0x000e620000000200ULL, 0x0000009dff9d723eULL, 0x000fc400020006ffULL,
0x0000009eff9e723eULL, 0x000fe400020006ffULL, 0x0000009cff9c723eULL, 0x000fe200020006ffULL,
0x2000009dff9d7230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x000fe2000001168fULL,
0x2000009eff9e7230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x2000009cff9c7230ULL, 0x000fe20000004100ULL, 0x0000ffff7ca57812ULL, 0x000fe400078ec0ffULL,
0x000000ff7fa17812ULL, 0x000fc400078ec0ffULL, 0x000010545d8e7816ULL, 0x000fe4000000008eULL,
0x000000ffa0a07812ULL, 0x000fe400078ec0ffULL, 0x00000010ff947819ULL, 0x000fe4000001167dULL,
0x00000010ff957819ULL, 0x000fe40000011695ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000008ff5d7819ULL, 0x000fe200000116a5ULL, 0x200000a2ffa57230ULL, 0x000fe20000004100ULL,
0x000000a1ffa4723eULL, 0x000fc400020006ffULL, 0x0000ffff7d967812ULL, 0x000fe400078ec0ffULL,
0x000000a0ffa1723eULL, 0x000fe200020006ffULL, 0x200000a4ffa47230ULL, 0x000fe20000004100ULL,
0x0000ffff7e927812ULL, 0x000fe400078ec0ffULL, 0x00001054958f7816ULL, 0x000fe2000000005eULL,
0x200000a1ffa17230ULL, 0x000fe20000004100ULL, 0x0000005dffa0723eULL, 0x000fe400020006ffULL,
0x000000ff94a27812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5e7819ULL, 0x000fe2000001169fULL,
0x200000a0ffa07230ULL, 0x000fe20000004100ULL, 0x00000010ff957819ULL, 0x000fe2000001169eULL,
0x0000008e5820723cULL, 0x080fe20000041820ULL, 0x00000010ff947819ULL, 0x000fe4000001169dULL,
0x00000010ff5d7819ULL, 0x000fe4000001169cULL, 0x00000018ff827819ULL, 0x000fe40000011677ULL,
0x000000ff77837812ULL, 0x040fe200078ec0ffULL, 0x0000008e543c723cULL, 0x000fe2000004183cULL,
0x0000ffff77777812ULL, 0x000fc400078ec0ffULL, 0x00000010ff937819ULL, 0x000fe4000001167fULL,
0x00000008ff967819ULL, 0x000fe40000011696ULL, 0x00000010ff917819ULL, 0x000fe4000001167eULL,
0x00000008ff927819ULL, 0x000fe40000011692ULL, 0x000010545e957816ULL, 0x000fe40000000095ULL,
0x000010545d947816ULL, 0x000fc40000000094ULL, 0x00000008ff5f7819ULL, 0x000fe40000011677ULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x000000ff93937812ULL, 0x000fe200078ec0ffULL,
0x000000945824723cULL, 0x080f620000041824ULL, 0x000000a2ffa2723eULL, 0x000fe200020006ffULL,
0x20000096ff967230ULL, 0x000fe20000004100ULL, 0x000000ff91917812ULL, 0x000fe400078ec0ffULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x200000a2ffa27230ULL, 0x000fe20000004100ULL,
0x0000ffff7f907812ULL, 0x000fe200078ec0ffULL, 0x000000945440723cULL, 0x000b620000041840ULL,
0x00000082ff82723eULL, 0x000fc400020006ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x20000092ff947230ULL, 0x020fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe200020006ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000008ff927819ULL, 0x000fe20000011690ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x000fe20000011697ULL, 0x20000093ff9c7230ULL, 0x000fe20000004100ULL,
0x00000010ff937819ULL, 0x000fe20000011696ULL, 0x20000091ff957230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fc400000116a3ULL, 0x00000010ff5d7819ULL, 0x000fe400000116a0ULL,
0x00000010ff907819ULL, 0x000fe4000001169bULL, 0x00000010ff917819ULL, 0x000fe400000116a2ULL,
0x00000092ff96723eULL, 0x000fe400020006ffULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff837819ULL, 0x000fe20000011683ULL, 0x20000096ff967230ULL, 0x000fe20000004100ULL,
0x00000010ff807819ULL, 0x000fc4000001165fULL, 0x00000010ff887819ULL, 0x000fe40000011676ULL,
0x0000ffff76897812ULL, 0x000fe400078ec0ffULL, 0x000010545d8e7816ULL, 0x000fe4000000008eULL,
0x000010545e917816ULL, 0x000fe40000000091ULL, 0x0000105493907816ULL, 0x000fe40000000090ULL,
0x00000010ff5e7819ULL, 0x000fc40000011699ULL, 0x00000010ff927819ULL, 0x000fe40000011698ULL,
0x00000010ff937819ULL, 0x000fe20000011695ULL, 0x00000090582c723cULL, 0x080fe2000004182cULL,
0x00000010ff5d7819ULL, 0x000fe40000011694ULL, 0x0000105482817816ULL, 0x000fe40000000081ULL,
0x0000105480807816ULL, 0x000fe40000000083ULL, 0x00000018ff8d7819ULL, 0x000fe20000011676ULL,
0x000000905448723cULL, 0x000fe20000041848ULL, 0x000000ff768b7812ULL, 0x000fc400078ec0ffULL,
0x000000ff88887812ULL, 0x000fe400078ec0ffULL, 0x00000008ff897819ULL, 0x000fe40000011689ULL,
0x000010545e937816ULL, 0x000fe20000000093ULL, 0x000000801404723cULL, 0x008fe20000041804ULL,
0x000010545d927816ULL, 0x000fe40000000092ULL, 0x00000010ff9a7819ULL, 0x000fe4000001169aULL,
0x00000010ff8f7819ULL, 0x000fc400000116a1ULL, 0x00000010ff5e7819ULL, 0x000fe200000116a5ULL,
0x000000801808723cULL, 0x000be20000041808ULL, 0x00000010ff947819ULL, 0x000fe400000116a4ULL,
0x00000010ff957819ULL, 0x000fe4000001169cULL, 0x00000010ff5d7819ULL, 0x000fe40000011696ULL,
0x0000008dff8d723eULL, 0x000fe200020006ffULL, 0x000000925830723cULL, 0x000fe20000041830ULL,
0x0000008bff8b723eULL, 0x000fc400020006ffULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000008dff967230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fe20000011674ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x0000ffff74877812ULL, 0x000fe200078ec0ffULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x100fe20000011675ULL,
0x00000092544c723cULL, 0x000fe2000004184cULL, 0x00000018ff777819ULL, 0x000fc40000011675ULL,
0x000000ff75747812ULL, 0x040fe400078ec0ffULL, 0x0000ffff757c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff767819ULL, 0x102fe40000011660ULL, 0x00000018ff847819ULL, 0x000fe40000011660ULL,
0x000000ff60837812ULL, 0x040fe400078ec0ffULL, 0x0000ffff607e7812ULL, 0x000fc400078ec0ffULL,
0x000010549a8f7816ULL, 0x000fe4000000008fULL, 0x000010545e957816ULL, 0x000fe40000000095ULL,
0x000010545d947816ULL, 0x000fe40000000094ULL, 0x00000010ff7d7819ULL, 0x100fe20000011661ULL,
0x0000008e5828723cULL, 0x000f620000041828ULL, 0x00000018ff857819ULL, 0x000fe40000011661ULL,
0x000000ff61867812ULL, 0x000fc400078ec0ffULL, 0x00000010ff607819ULL, 0x100fe40000011662ULL,
0x00000018ff817819ULL, 0x020fe20000011662ULL, 0x000000945834723cULL, 0x000f620000041834ULL,
0x000000ff62827812ULL, 0x000fe400078ec0ffULL, 0x00000010ff757819ULL, 0x100fe40000011663ULL,
0x00000018ff807819ULL, 0x000fe40000011663ULL, 0x000000ff637f7812ULL, 0x000fe200078ec0ffULL,
0x0000008e5444723cULL, 0x000f620000041844ULL, 0x0000ffff61617812ULL, 0x000fc400078ec0ffULL,
0x0000ffff62627812ULL, 0x000fe400078ec0ffULL, 0x0000ffff63637812ULL, 0x000fe400078ec0ffULL,
0x00000008ff877819ULL, 0x000fe20000011687ULL, 0x000000945450723cULL, 0x000b620000041850ULL,
0x00000008ff7e7819ULL, 0x000fe4000001167eULL, 0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5f5f7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff7c7819ULL, 0x000fe4000001167cULL,
0x000000ff76767812ULL, 0x000fe400078ec0ffULL, 0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x000000ff60607812ULL, 0x000fe400078ec0ffULL,
0x00000008ff627819ULL, 0x000fc40000011662ULL, 0x000000ff75757812ULL, 0x000fe400078ec0ffULL,
0x00000008ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff967819ULL, 0x000fe40000011696ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff557819ULL, 0x020fe40000011688ULL,
0x00000010ff547819ULL, 0x000fc40000011689ULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000077ff77723eULL, 0x000fe200020006ffULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fc400020006ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x0000105496557816ULL, 0x000fe20000000055ULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x0000105454547816ULL, 0x000fe2000000008bULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff8d7819ULL, 0x000fe2000001165cULL, 0x2000007fff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff8c7819ULL, 0x000fc4000001168cULL, 0x00000010ff877819ULL, 0x000fe20000011687ULL,
0x000000541424723cULL, 0x080f620000041824ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff587819ULL, 0x000fe20000011677ULL, 0x000000541840723cULL, 0x000b620000041840ULL,
0x00000010ff5b7819ULL, 0x000fc4000001165fULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff597819ULL, 0x000fe4000001167cULL, 0x00000010ff7f7819ULL, 0x000fe40000011684ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff547819ULL, 0x020fe40000011685ULL,
0x00000010ff7d7819ULL, 0x000fc4000001167dULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff557819ULL, 0x000fc40000011662ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x00000010ff5d7819ULL, 0x000fe40000011675ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00001054878c7816ULL, 0x000fe4000000008cULL,
0x000010547e7e7816ULL, 0x000fc40000000083ULL, 0x000010548d8d7816ULL, 0x000fe4000000008aULL,
0x00001054585b7816ULL, 0x000fe4000000005bULL, 0x00001054595a7816ULL, 0x000fe40000000074ULL,
0x000010547f7f7816ULL, 0x000fe20000000076ULL, 0x0000008c141c723cULL, 0x000f62000004181cULL,
0x0000105454877816ULL, 0x000fe4000000007dULL, 0x0000105461867816ULL, 0x000fc40000000086ULL,
0x0000105481837816ULL, 0x000fe40000000060ULL, 0x0000105455827816ULL, 0x000fe20000000082ULL,
0x0000005a1420723cULL, 0x000f620000041820ULL, 0x00001054805d7816ULL, 0x000fe4000000005dULL,
0x00001054635c7816ULL, 0x000fe4000000005cULL, 0x0000000278787810ULL, 0x000fc60007ffe0ffULL,
0x0000007e1428723cULL, 0x040f700000041828ULL, 0x00000086142c723cULL, 0x040f70000004182cULL,
0x000000821430723cULL, 0x040f700000041830ULL, 0x0000005c1434723cULL, 0x000b6e0000041834ULL,
0x000000047a157810ULL, 0x060fe20007ffe0ffULL, 0x0000008c1838723cULL, 0x000b620000041838ULL,
0xfffffff47a147810ULL, 0x000fc40007ffe0ffULL, 0x000000181500780cULL, 0x000fe20003f25270ULL,
0x000000ffff7a7224ULL, 0x000fc800078e0015ULL, 0x0000005a183c723cULL, 0x040b70000004183cULL,
0x0000007e1844723cULL, 0x040b700000041844ULL, 0x000000861848723cULL, 0x040b700000041848ULL,
0x00000082184c723cULL, 0x040b70000004184cULL, 0x0000005c1850723cULL, 0x000b620000041850ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe5e000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff727224ULL, 0x000fe200078e0070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd86000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x000000681c5d7220ULL, 0x0a0fe20000410000ULL,
0x0000006825577220ULL, 0x080fe20000410000ULL, 0x000000682e2e7220ULL, 0x080fe20000410000ULL,
0x000000682f2f7220ULL, 0x080fe20000410000ULL, 0x0000006831317220ULL, 0x080fe20000410000ULL,
0x00000068045a7220ULL, 0x080fe20000410000ULL, 0x0000006805587220ULL, 0x080fe20000410000ULL,
0x0000006830307220ULL, 0x080fe20000410000ULL, 0x0000006832327220ULL, 0x080fe20000410000ULL,
0x0000006833337220ULL, 0x080fe20000410000ULL, 0x0000006834347220ULL, 0x080fe20000410000ULL,
0x0000006835357220ULL, 0x080fe20000410000ULL, 0x0000006836367220ULL, 0x080fe20000410000ULL,
0x0000006837377220ULL, 0x080fe20000410000ULL, 0x0000006838387220ULL, 0x080fe20000410000ULL,
0x0000006839397220ULL, 0x080fe20000410000ULL, 0x000000683d3d7220ULL, 0x080fe20000410000ULL,
0x000000680a1c7220ULL, 0x080fe20000410000ULL, 0x000000680b257220ULL, 0x080fe20000410000ULL,
0x000000681e1e7220ULL, 0x080fe20000410000ULL, 0x000000681f1f7220ULL, 0x080fe20000410000ULL,
0x00000068205c7220ULL, 0x080fe20000410000ULL, 0x0000006822227220ULL, 0x080fe20000410000ULL,
0x0000006823237220ULL, 0x080fe20000410000ULL, 0x0000006826267220ULL, 0x080fe20000410000ULL,
0x0000006827277220ULL, 0x080fe20000410000ULL, 0x0000006806067220ULL, 0x080fe20000410000ULL,
0x0000006807077220ULL, 0x080fe20000410000ULL, 0x000000682a2a7220ULL, 0x080fe20000410000ULL,
0x000000682b2b7220ULL, 0x080fe20000410000ULL, 0x000000682c2c7220ULL, 0x080fe20000410000ULL,
0x000000682d2d7220ULL, 0x080fe20000410000ULL, 0x000000683b197220ULL, 0x080fe20000410000ULL,
0x000000683c3c7220ULL, 0x080fe20000410000ULL, 0x0000006840047220ULL, 0x080fe20000410000ULL,
0x0000006841057220ULL, 0x080fe20000410000ULL, 0x0000006808087220ULL, 0x080fe20000410000ULL,
0x0000006809097220ULL, 0x080fe20000410000ULL, 0x00000068440a7220ULL, 0x080fe20000410000ULL,
0x00000068450b7220ULL, 0x080fe20000410000ULL, 0x0000006848147220ULL, 0x080fe20000410000ULL,
0x0000006849157220ULL, 0x080fe20000410000ULL, 0x000000684c167220ULL, 0x080fe20000410000ULL,
0x000000684a207220ULL, 0x080fe20000410000ULL, 0x00000068503b7220ULL, 0x080fe20000410000ULL,
0x000000681d557220ULL, 0x080fe20000410000ULL, 0x0000006821567220ULL, 0x080fe20000410000ULL,
0x00000068245b7220ULL, 0x080fe20000410000ULL, 0x0000006828597220ULL, 0x080fe20000410000ULL,
0x0000006829547220ULL, 0x080fe20000410000ULL, 0x000000683a187220ULL, 0x080fe20000410000ULL,
0x000000683e1a7220ULL, 0x080fe20000410000ULL, 0x000000683f1b7220ULL, 0x080fe20000410000ULL,
0x000000684e5e7220ULL, 0x080fe20000410000ULL, 0x000000684f5f7220ULL, 0x080fe20000410000ULL,
0x0000006851177220ULL, 0x080fe20000410000ULL, 0x000000ffff507224ULL, 0x000fe200078e0031ULL,
0x0000006842297220ULL, 0x080fe20000410000ULL, 0x000000ffff487224ULL, 0x000fe200078e002eULL,
0x0000006843287220ULL, 0x080fe20000410000ULL, 0x000000ffff4a7224ULL, 0x000fe200078e002fULL,
0x00000068461d7220ULL, 0x080fe20000410000ULL, 0x0000006847247220ULL, 0x080fe20000410000ULL,
0x000000684b217220ULL, 0x080fe20000410000ULL, 0x000000684d3a7220ULL, 0x080fe20000410000ULL,
0x0000006852607220ULL, 0x080fe20000410000ULL, 0x0000006853617220ULL, 0x000fe20000410000ULL,
0x000000ffff517224ULL, 0x000fc400078e0030ULL, 0x000000ffff4f7224ULL, 0x000fe400078e0034ULL,
0x000000ffff4e7224ULL, 0x000fe400078e0035ULL, 0x000000ffff497224ULL, 0x000fe400078e0032ULL,
0x000000ffff407224ULL, 0x000fe400078e0033ULL, 0x000000ffff3f7224ULL, 0x000fe400078e0036ULL,
0x000000ffff3e7224ULL, 0x000fc400078e0037ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0038ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0039ULL, 0x000000ffff317224ULL, 0x000fe400078e003dULL,
0x000000ffff537224ULL, 0x000fe400078e002cULL, 0x000000ffff527224ULL, 0x000fe400078e002dULL,
0x000000ffff427224ULL, 0x000fc400078e001eULL, 0x000000ffff4d7224ULL, 0x000fe400078e001fULL,
0x000000ffff417224ULL, 0x000fe400078e0022ULL, 0x000000ffff447224ULL, 0x000fe400078e0023ULL,
0x000000ffff437224ULL, 0x000fe400078e0026ULL, 0x000000ffff4b7224ULL, 0x000fe400078e0027ULL,
0x000000ffff457224ULL, 0x000fc400078e0006ULL, 0x000000ffff477224ULL, 0x000fe400078e0007ULL,
0x000000ffff467224ULL, 0x000fe400078e002aULL, 0x000000ffff4c7224ULL, 0x000fe400078e002bULL,
0x000000ffff307224ULL, 0x000fe400078e003cULL, 0x000000ffff327224ULL, 0x000fe400078e0004ULL,
0x000000ffff337224ULL, 0x000fc400078e0005ULL, 0x000000ffff347224ULL, 0x000fe400078e0008ULL,
0x000000ffff357224ULL, 0x000fe400078e0009ULL, 0x000000ffff367224ULL, 0x000fe400078e000aULL,
0x000000ffff377224ULL, 0x000fe400078e000bULL, 0x000000ffff387224ULL, 0x000fe400078e0014ULL,
0x000000ffff397224ULL, 0x000fc400078e0015ULL, 0x000000ffff3d7224ULL, 0x000fe200078e0016ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000006a087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff237224ULL, 0x000fe400078e0020ULL, 0x000000ffff227224ULL, 0x000fe400078e0021ULL,
0x000000ffff3c7224ULL, 0x000fe400078e0017ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0018ULL,
0x000000ffff2a7224ULL, 0x000fc400078e0019ULL, 0x000000ffff2b7224ULL, 0x000fe400078e001aULL,
0x000000ffff2d7224ULL, 0x000fe400078e001bULL, 0x000000ffff277224ULL, 0x000fe400078e001cULL,
0x000000ffff267224ULL, 0x000fe400078e001dULL, 0x000000ffff217224ULL, 0x000fe400078e005eULL,
0x000000ffff207224ULL, 0x000fc400078e005fULL, 0x000000ffff1f7224ULL, 0x000fe400078e0060ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0061ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x000004006a077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004006a077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004691d7824ULL, 0x000fe200078e00ffULL, 0x0000000f6e00720cULL, 0x000fc80003f06070ULL,
0xfffffff01d1c7812ULL, 0x000fca00078ec0ffULL, 0x00000080111c7824ULL, 0x000fca00078e021cULL,
0x012400001c047984ULL, 0x0002a20000000c00ULL, 0x000021f000008947ULL, 0x000fea0003800000ULL,
0x00005a00000b7b06ULL, 0x000ee20000209000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x00000010690a7211ULL, 0x040fe200078ff0ffULL, 0x00000002695f7824ULL, 0x000fc600078e00ffULL,
0x000000100a167810ULL, 0x000fe40007ffe0ffULL, 0x000000065f5f7812ULL, 0x000fca00078ec0ffULL,
0x000000015f617824ULL, 0x000fe200078e0213ULL, 0x0000000b000b7308ULL, 0x008ee40000001000ULL,
0x0ffffffe0b147810ULL, 0x008fcc0007ffe0ffULL, 0x0000001400097305ULL, 0x000ee4000021f000ULL,
0x000000ffff157224ULL, 0x008fc800078e0a09ULL, 0x00005a0015157a24ULL, 0x000fc800078e02ffULL,
0x0000001509197227ULL, 0x000fe200078e0008ULL, 0x000000080a097810ULL, 0x000fca0007ffe0ffULL,
0x0000000919157227ULL, 0x000fc800078e00ffULL, 0x0000000a19087227ULL, 0x000fc800078e00ffULL,
0x000000ffff147224ULL, 0x000fe400078e0a15ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a08ULL,
0x00005a0014147a24ULL, 0x000fe400078e0209ULL, 0x00005a000b0b7a24ULL, 0x000fe200078e020aULL,
0x000000180a0a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001619177227ULL, 0x000fe200078e00ffULL,
0x00005a0014007a0cULL, 0x000fe40003fa6070ULL, 0x00005a000b007a0cULL, 0x000fe20003f06070ULL,
0x000000ffff097224ULL, 0x000fc400078e0a17ULL, 0x0000000a19187227ULL, 0x000fc800078e00ffULL,
0x00005a0009167a24ULL, 0x000fe400078e0216ULL, 0x000000ffff197224ULL, 0x000fe400078e0a18ULL,
0x000001006e097824ULL, 0x000fe200078e0267ULL, 0x00005a0016007a0cULL, 0x000fe20003f26070ULL,
0x00005a0019197a24ULL, 0x000fe200078e020aULL, 0x80005a0014145a10ULL, 0x000fe40007ffe0ffULL,
0x80005a000b0b0a10ULL, 0x000fe40007ffe0ffULL, 0x000000090e5e7217ULL, 0x000fc40007800000ULL,
0x00005a0014007a0cULL, 0x000fe40003fc6070ULL, 0x00005a000b007a0cULL, 0x000fe20003f46070ULL,
0x000000015e5e7824ULL, 0x000fe200078e0a09ULL, 0x00005a0019007a0cULL, 0x000fe20003f66070ULL,
0x000000016c097824ULL, 0x000fe200078e025fULL, 0x80005a0016161a10ULL, 0x000fe20007ffe0ffULL,
0x00000001610a7824ULL, 0x100fe200078e0a5eULL, 0x0000000115155810ULL, 0x000fe20007ffe0ffULL,
0x0000000109147824ULL, 0x000fe200078e0a5eULL, 0x0000000108080810ULL, 0x000fc40007ffe0ffULL,
0x00005a0016007a0cULL, 0x000fe40003f86070ULL, 0x0000000115156810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL, 0x00005a00ff167a12ULL, 0x000fe400078e33ffULL,
0x0000005e6100720cULL, 0x000fe40003fc6070ULL, 0x80005a0019193a10ULL, 0x000fc40007ffe0ffULL,
0x0000000108082810ULL, 0x000fe40007ffe0ffULL, 0x0000000a6b0a7217ULL, 0x000fe40003800000ULL,
0x00005a0019007a0cULL, 0x000fe40003f46070ULL, 0x0000000816087207ULL, 0x000fe40006800000ULL,
0x000000ff0a7c7207ULL, 0x000fe40003000000ULL, 0x000000146b147217ULL, 0x000fc40003800000ULL,
0x00000015160a7207ULL, 0x000fe40006800000ULL, 0x0000005e0900720cULL, 0x000fe40003f06070ULL,
0x000000086b097217ULL, 0x000fe40003800000ULL, 0x00000004ff147819ULL, 0x000fe40000011614ULL,
0x0000000117171810ULL, 0x000fe20007ffe0ffULL, 0x0000000966917224ULL, 0x000fe200078e02ffULL,
0x0000000a6b0b7217ULL, 0x000fc40003800000ULL, 0x0000000118183810ULL, 0x000fe40007ffe0ffULL,
0x000000ff14147207ULL, 0x000fe20000000000ULL, 0x0000000b66937224ULL, 0x000fe200078e02ffULL,
0x0000000117174810ULL, 0x000fe40007ffe0ffULL, 0x0000000118182810ULL, 0x000fe20007ffe0ffULL,
0x00000001910b7824ULL, 0x000fe200078e0214ULL, 0x0000001716087207ULL, 0x000fe20006800000ULL,
0x0000000114177824ULL, 0x000fe200078e0293ULL, 0x000000917c097211ULL, 0x000fe200078fe0ffULL,
0x000000020b0a7825ULL, 0x000fe200078e0002ULL, 0x0000001816187207ULL, 0x000fc40006800000ULL,
0x000000086b157217ULL, 0x000fe20003800000ULL, 0x0000000217167825ULL, 0x100fe200078e0002ULL,
0x000000105f777812ULL, 0x000fe200078efcffULL, 0x000000060a607981ULL, 0x0046a2000c1e9500ULL,
0x000000186b197217ULL, 0x000fe20003800000ULL, 0x0000000209087825ULL, 0x000fe400078e0002ULL,
0x0000000616627981ULL, 0x0002a4000c1e9500ULL, 0x0000001566957224ULL, 0x040fe400078e02ffULL,
0x0000000608637981ULL, 0x0006a2000c1e9500ULL, 0x0000001966977224ULL, 0x000fe200078e02ffULL,
0x000000937c157211ULL, 0x000fe200078fe0ffULL, 0x000000016c177824ULL, 0x002fe200078e0277ULL,
0x000000957c1b7211ULL, 0x000fe200078fe0ffULL, 0x0000000114197824ULL, 0x000fc400078e0295ULL,
0x0000000117167824ULL, 0x000fe200078e0a5eULL, 0x000000977c717211ULL, 0x000fe200078fe0ffULL,
0x0000000114737824ULL, 0x000fe400078e0297ULL, 0x0000000215147825ULL, 0x000fe200078e0002ULL,
0x000000166b767217ULL, 0x000fc60003800000ULL, 0x0000000219187825ULL, 0x000fc800078e0002ULL,
0x000000021b0a7825ULL, 0x008fe200078e0002ULL, 0x0000000618727981ULL, 0x0002e6000c1e9500ULL,
0x0000000177757824ULL, 0x000fe200078e0213ULL, 0x0000005e1700720cULL, 0x000fe20003f26070ULL,
0x00000002731a7825ULL, 0x000fe200078e0002ULL, 0x00000004ff767819ULL, 0x000fe20000011676ULL,
0x000000060a737981ULL, 0x0002e4000c1e9500ULL, 0x0000000271087825ULL, 0x000fc400078e0002ULL,
0x0000000614717981ULL, 0x0002e4000c1e9500ULL, 0x0000000175167824ULL, 0x040fe200078e0a5eULL,
0x0000005e7500720cULL, 0x000fe20003f06070ULL, 0x000000061a747981ULL, 0x0002e6000c1e9500ULL,
0x000000166b167217ULL, 0x000fe20003800000ULL, 0x0000000608797981ULL, 0x0002e4000c1e9500ULL,
0x000000ff76147207ULL, 0x002fc40000800000ULL, 0x000000ff16827207ULL, 0x000fc60000000000ULL,
0x0000000114177824ULL, 0x000fe200078e0293ULL, 0x000000205f817812ULL, 0x000fe400078efcffULL,
0x0000009182097211ULL, 0x040fe200078fe0ffULL, 0x0000000217167825ULL, 0x000fe200078e0002ULL,
0x0000009382157211ULL, 0x000fc600078fe0ffULL, 0x00000001910b7824ULL, 0x000fe200078e0214ULL,
0x0000000616787981ULL, 0x0002e2000c1e9500ULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x00000097827d7211ULL, 0x000fc600078fe0ffULL, 0x00000001141b7824ULL, 0x040fe200078e0295ULL,
0x00000006087b7981ULL, 0x0002e2000c1e9500ULL, 0x00000001147f7824ULL, 0x000fe400078e0297ULL,
0x000000016c177824ULL, 0x002fe400078e0281ULL, 0x000000020b0a7825ULL, 0x000fc800078e0002ULL,
0x0000000215147825ULL, 0x000fe200078e0002ULL, 0x000000060a767981ULL, 0x0002e6000c1e9500ULL,
0x0000000117167824ULL, 0x000fe400078e0a5eULL, 0x000000027d087825ULL, 0x000fe400078e0002ULL,
0x00000006147d7981ULL, 0x0002e4000c1e9500ULL, 0x0000000181837824ULL, 0x000fe200078e0213ULL,
0x000000166b807217ULL, 0x000fe20003800000ULL, 0x000000027f0a7825ULL, 0x002fe200078e0002ULL,
0x0000009582197211ULL, 0x000fe200078fe0ffULL, 0x0000000608857981ULL, 0x0002e4000c1e9500ULL,
0x0000000183167824ULL, 0x000fe200078e0a5eULL, 0x0000005e1700720cULL, 0x000fc40003f26070ULL,
0x00000004ff807819ULL, 0x000fe20000011680ULL, 0x000000021b1a7825ULL, 0x100fe200078e0002ULL,
0x0000005e8300720cULL, 0x000fe20003f06070ULL, 0x000000060a7e7981ULL, 0x0002e2000c1e9500ULL,
0x000000166b167217ULL, 0x000fe20003800000ULL, 0x0000000219187825ULL, 0x000fe400078e0002ULL,
0x000000061a7a7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff16887207ULL, 0x000fc60000000000ULL,
0x00000006187f7981ULL, 0x0002e4000c1e9500ULL, 0x000000ff800a7207ULL, 0x002fca0000800000ULL,
0x000000010a877824ULL, 0x000fe400078e0293ULL, 0x0000000191097824ULL, 0x000fe200078e020aULL,
0x0000009388197211ULL, 0x040fe200078fe0ffULL, 0x0000000287867825ULL, 0x100fe200078e0002ULL,
0x00000091881b7211ULL, 0x040fe400078fe0ffULL, 0x00000097888b7211ULL, 0x000fe200078fe0ffULL,
0x0000000209087825ULL, 0x100fe400078e0002ULL, 0x0000000686867981ULL, 0x0002e4000c1e9500ULL,
0x0000000219187825ULL, 0x000fc400078e0002ULL, 0x0000000608807981ULL, 0x0002e4000c1e9500ULL,
0x000000021b1a7825ULL, 0x100fe200078e0002ULL, 0x0000009588157211ULL, 0x000fe200078fe0ffULL,
0x0000000618877981ULL, 0x0022e4000c1e9500ULL, 0x000000028b087825ULL, 0x000fe200078e0002ULL,
0x000000305f8b7812ULL, 0x000fe200078efcffULL, 0x000000061a897981ULL, 0x0002e4000c1e9500ULL,
0x000000010a177824ULL, 0x000fc400078e0295ULL, 0x000000010a0b7824ULL, 0x000fe200078e0297ULL,
0x0000000608db7981ULL, 0x0002e2000c1e9500ULL, 0x0000000217167825ULL, 0x000fc800078e0002ULL,
0x000000016c1b7824ULL, 0x002fe200078e028bULL, 0x0000000616847981ULL, 0x0002e2000c1e9500ULL,
0x0000000215147825ULL, 0x000fc800078e0002ULL, 0x000000020b0a7825ULL, 0x000fe200078e0002ULL,
0x00000006148f7981ULL, 0x0002e6000c1e9500ULL, 0x000000011b1a7824ULL, 0x000fe200078e0a5eULL,
0x000000060a967981ULL, 0x0002e2000c1e9500ULL, 0x000000018b8d7824ULL, 0x000fc600078e0213ULL,
0x0000001a6b8a7217ULL, 0x000fe20003800000ULL, 0x000000018d1a7824ULL, 0x000fe200078e0a5eULL,
0x0000005e1b00720cULL, 0x080fe40003f26070ULL, 0x00000004ff8a7819ULL, 0x000fe4000001168aULL,
0x0000005e8d00720cULL, 0x000fe40003f06070ULL, 0x0000001a6b1a7217ULL, 0x000fe40003800000ULL,
0x000000ff8a8c7207ULL, 0x000fc40000800000ULL, 0x000000ff1a8a7207ULL, 0x000fc60000000000ULL,
0x0000000191197824ULL, 0x000fe200078e028cULL, 0x000000918a1b7211ULL, 0x000fe200078fe0ffULL,
0x000000018c157824ULL, 0x002fe200078e0295ULL, 0x000000958a177211ULL, 0x000fe200078fe0ffULL,
0x0000000219187825ULL, 0x000fc800078e0002ULL, 0x000000021b1a7825ULL, 0x100fe200078e0002ULL,
0x00000006188e7981ULL, 0x0002e6000c1e9500ULL, 0x0000000215147825ULL, 0x100fe200078e0002ULL,
0x000000061ac17981ULL, 0x0002e6000c1e9500ULL, 0x0000000217167825ULL, 0x000fe200078e0002ULL,
0x0000000614947981ULL, 0x0002e2000c1e9500ULL, 0x000000938a0b7211ULL, 0x000fc600078fe0ffULL,
0x0000000616d97981ULL, 0x0002e2000c1e9500ULL, 0x000000018c097824ULL, 0x000fe400078e0293ULL,
0x000000020b0a7825ULL, 0x000fc800078e0002ULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x000000060ad77981ULL, 0x0002e4000c1e9500ULL, 0x000000978a197211ULL, 0x002fe400078fe0ffULL,
0x0000000608927981ULL, 0x0002e2000c1e9500ULL, 0x000000018c1b7824ULL, 0x000fe400078e0297ULL,
0x0000000219187825ULL, 0x000fc800078e0002ULL, 0x000000021b1a7825ULL, 0x000fe200078e0002ULL,
0x0000000618dd7981ULL, 0x0002e8000c1e9500ULL, 0x000000061a987981ULL, 0x0002e4000c1e9500ULL,
0xfffffff07c097812ULL, 0x002fe200078ec0ffULL, 0x00000001ffd57424ULL, 0x000fc800078e00ffULL,
0x000000015e087824ULL, 0x000fc800078e0209ULL, 0x0000000161097824ULL, 0x000fe200078e0a08ULL,
0x000000015f917812ULL, 0x000fc800078efcffULL, 0x00000009d5097219ULL, 0x000fe200000006ffULL,
0x00000001910b7824ULL, 0x000fe200078e0213ULL, 0xfffffff082157812ULL, 0x000fc600078ec0ffULL,
0x000000010b0a7824ULL, 0x100fe200078e0a08ULL, 0x000000085f937812ULL, 0x040fe200078efcffULL,
0x000000015e167824ULL, 0x000fe200078e0215ULL, 0x000000095f957812ULL, 0x000fe400078efcffULL,
0x0000000ad5157219ULL, 0x000fe200000006ffULL, 0x0000000193177824ULL, 0x100fe400078e0213ULL,
0x00000001951b7824ULL, 0x000fe200078e0213ULL, 0xfffffff088197812ULL, 0x000fe200078ec0ffULL,
0x0000000117147824ULL, 0x100fe200078e0a08ULL, 0xfffffff08a977812ULL, 0x000fe200078ec0ffULL,
0x000000011b087824ULL, 0x000fe200078e0a08ULL, 0x000000115f9b7812ULL, 0x000fe200078efcffULL,
0x000000015e187824ULL, 0x040fe200078e0219ULL, 0x00000014d5197219ULL, 0x040fe200000006ffULL,
0x000000015e887824ULL, 0x000fe200078e0297ULL, 0x00000008d5977219ULL, 0x000fe200000006ffULL,
0x000000019b9d7824ULL, 0x000fc400078e0213ULL, 0x0000000175087824ULL, 0x100fe400078e0a16ULL,
0x000000019d0a7824ULL, 0x000fe200078e0a16ULL, 0x0000541063607816ULL, 0x004fc80000000060ULL,
0x0000006009ff7212ULL, 0x000fc800078ac0ffULL, 0x0000005e6100720cULL, 0x000fc80002fa1470ULL,
0x0000005e5f00720cULL, 0x000fe40002fa1070ULL, 0x0000006015ff7212ULL, 0x000fe4000782c0ffULL,
0xff8000005d5d7808ULL, 0x000fe40002800000ULL, 0x0000005e0b00720cULL, 0x000fe40000f21470ULL,
0x0000541073727816ULL, 0x008fe40000000072ULL, 0x0000541071627816ULL, 0x000fc40000000062ULL,
0x0000007209ff7212ULL, 0x040fe4000788c0ffULL, 0x0000006209ff7212ULL, 0x080fe4000784c0ffULL,
0x0000006215ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005e6100720cULL, 0x0c0fe40001741470ULL,
0x0000005e6100720cULL, 0x080fe40002781470ULL, 0x0000005e0b00720cULL, 0x000fc40002fa1470ULL,
0x0000005e5f00720cULL, 0x0c0fe40001741070ULL, 0x0000005e5f00720cULL, 0x080fe40002781070ULL,
0x0000005e9100720cULL, 0x0c0fe40000f21070ULL, 0x0000005e9100720cULL, 0x000fe40002fa1070ULL,
0x0000541079747816ULL, 0x000fe40000000074ULL, 0xff80000042427808ULL, 0x000fc40001000000ULL,
0xff8000002f2f7808ULL, 0x000fe40002000000ULL, 0xff80000055557808ULL, 0x000fe40000800000ULL,
0xff8000004d4d7808ULL, 0x000fe40002800000ULL, 0x0000006019ff7212ULL, 0x000fe4000786c0ffULL,
0x0000007409ff7212ULL, 0x000fe4000780c0ffULL, 0x0000007215ff7212ULL, 0x000fc4000784c0ffULL,
0x0000007415ff7212ULL, 0x000fe4000788c0ffULL, 0x0000006297ff7212ULL, 0x000fe4000782c0ffULL,
0x0000007219ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005e6100720cULL, 0x080fe40000701470ULL,
0x0000005e0b00720cULL, 0x0c0fe40001741470ULL, 0x0000005e0b00720cULL, 0x000fc40002781470ULL,
0x0000005e1700720cULL, 0x0c0fe40001f61470ULL, 0x0000005e1700720cULL, 0x080fe40002fa1470ULL,
0x0000005e1b00720cULL, 0x080fe40000f21470ULL, 0x000000185fa17812ULL, 0x040fe400078efcffULL,
0x000000195fa77812ULL, 0x040fe400078efcffULL, 0x0000005e5f00720cULL, 0x000fc40000701070ULL,
0x0000005e9100720cULL, 0x0c0fe40001741070ULL, 0x0000005e9100720cULL, 0x080fe40002781070ULL,
0x0000005e9300720cULL, 0x0c0fe40001f61070ULL, 0x0000005e9300720cULL, 0x080fe40002fa1070ULL,
0x0000005e9500720cULL, 0x000fe40000f21070ULL, 0x00000008d5997219ULL, 0x000fc400000006ffULL,
0x0000000ad59f7219ULL, 0x000fe400000006ffULL, 0x000054107b767816ULL, 0x000fe40000000076ULL,
0x000054107d787816ULL, 0x000fe20000000078ULL, 0x00000001a1a37824ULL, 0x100fe200078e0213ULL,
0xff8000002c2c7808ULL, 0x000fe20000000000ULL, 0x00000001a7a97824ULL, 0x000fe200078e0213ULL,
0xff8000002e2e7808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fc40002000000ULL,
0xff8000005c5c7808ULL, 0x000fe40001800000ULL, 0xff80000030307808ULL, 0x000fe40002800000ULL,
0xff80000044447808ULL, 0x000fe40000800000ULL, 0x0000006219ff7212ULL, 0x000fe4000780c0ffULL,
0x0000007297ff7212ULL, 0x000fe4000784c0ffULL, 0x0000007419ff7212ULL, 0x000fc4000788c0ffULL,
0x0000007497ff7212ULL, 0x000fe4000786c0ffULL, 0x000000769fff7212ULL, 0x000fe400078ac0ffULL,
0x0000007899ff7212ULL, 0x000fe2000782c0ffULL, 0x00000001a3147824ULL, 0x100fe200078e0a16ULL,
0x0000005e1700720cULL, 0x080fe20000701470ULL, 0x00000001a9167824ULL, 0x000fe200078e0a16ULL,
0x0000005e1700720cULL, 0x080fe40002781470ULL, 0x0000005e1b00720cULL, 0x000fc40001741470ULL,
0x0000005e1b00720cULL, 0x080fe40001f61470ULL, 0x0000005e7500720cULL, 0x080fe40000f21470ULL,
0x0000005e9d00720cULL, 0x080fe40002fa1470ULL, 0x0000005e9300720cULL, 0x0c0fe40000701070ULL,
0x0000005e9300720cULL, 0x080fe40002781070ULL, 0x0000005e9500720cULL, 0x000fc40001741070ULL,
0x0000005e9500720cULL, 0x080fe40001f61070ULL, 0x0000005e7700720cULL, 0x080fe40000f21070ULL,
0x0000005e9b00720cULL, 0x000fe40002fa1070ULL, 0x00000014d5a57219ULL, 0x040fe400000006ffULL,
0x00000016d5ab7219ULL, 0x000fe400000006ffULL, 0x000054107f7a7816ULL, 0x000fc4000000007aULL,
0x00005410857e7816ULL, 0x000fe4000000007eULL, 0xff80000041417808ULL, 0x000fe40000000000ULL,
0xff8000002b2b7808ULL, 0x000fe40002000000ULL, 0xff80000031317808ULL, 0x000fe40001000000ULL,
0xff8000002d2d7808ULL, 0x000fe40001800000ULL, 0xff80000043437808ULL, 0x000fc40000800000ULL,
0xff80000057577808ULL, 0x000fe40002800000ULL, 0x0000007699ff7212ULL, 0x080fe4000780c0ffULL,
0x00000076a5ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007a99ff7212ULL, 0x040fe4000784c0ffULL,
0x0000007e99ff7212ULL, 0x000fe4000786c0ffULL, 0x0000007a9fff7212ULL, 0x000fc4000782c0ffULL,
0x00000078abff7212ULL, 0x000fe200078ac0ffULL, 0x00000001831a7824ULL, 0x000fe200078e0a18ULL,
0x0000005e7500720cULL, 0x0c0fe40000701470ULL, 0x0000005e7500720cULL, 0x0c0fe40001741470ULL,
0x0000005e7500720cULL, 0x080fe40001f61470ULL, 0x0000005e9d00720cULL, 0x080fe40000f21470ULL,
0x0000005ea300720cULL, 0x000fc40002781470ULL, 0x0000005ea900720cULL, 0x080fe40002fa1470ULL,
0x000000215faf7812ULL, 0x000fe400078efcffULL, 0x0000005e7700720cULL, 0x0c0fe40000701070ULL,
0x0000005e7700720cULL, 0x0c0fe40001741070ULL, 0x0000005e7700720cULL, 0x080fe40001f61070ULL,
0x0000005e9b00720cULL, 0x000fc40000f21070ULL, 0x0000005ea100720cULL, 0x080fe40002781070ULL,
0x0000005ea700720cULL, 0x000fe40002fa1070ULL, 0x0000001ad5ad7219ULL, 0x000fe400000006ffULL,
0x0000541087867816ULL, 0x000fe20000000086ULL, 0x00000001afb17824ULL, 0x000fe200078e0213ULL,
0xff8000005b5b7808ULL, 0x000fe40000000000ULL, 0xff80000032327808ULL, 0x000fc40001000000ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff80000033337808ULL, 0x000fe40000800000ULL,
0xff8000005a5a7808ULL, 0x000fe40002000000ULL, 0xff80000047477808ULL, 0x000fe40002800000ULL,
0x000000789fff7212ULL, 0x040fe4000780c0ffULL, 0x0000007e9fff7212ULL, 0x000fc4000784c0ffULL,
0x00000078a5ff7212ULL, 0x000fe4000786c0ffULL, 0x0000007aabff7212ULL, 0x040fe4000782c0ffULL,
0x0000007eabff7212ULL, 0x000fe4000788c0ffULL, 0x00000086adff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b17c7824ULL, 0x000fe200078e0a18ULL, 0x0000005e9d00720cULL, 0x0c0fe40000701470ULL,
0x0000005e9d00720cULL, 0x000fc40001741470ULL, 0x0000005ea300720cULL, 0x080fe40001f61470ULL,
0x0000005ea900720cULL, 0x0c0fe40000f21470ULL, 0x0000005ea900720cULL, 0x080fe40002781470ULL,
0x0000005e8300720cULL, 0x000fe40002fa1470ULL, 0x000000285fb57812ULL, 0x040fe400078efcffULL,
0x000000295fbb7812ULL, 0x000fc400078efcffULL, 0x0000005e9b00720cULL, 0x0c0fe40000701070ULL,
0x0000005e9b00720cULL, 0x080fe40001741070ULL, 0x0000005ea100720cULL, 0x080fe40001f61070ULL,
0x0000005ea700720cULL, 0x0c0fe40000f21070ULL, 0x0000005ea700720cULL, 0x080fe40002781070ULL,
0x0000005e8100720cULL, 0x000fc40002fa1070ULL, 0x0000007cd5b37219ULL, 0x000fe400000006ffULL,
0x0000541089807816ULL, 0x000fe40000000080ULL, 0x000054108f847816ULL, 0x000fe40000000084ULL,
0x00005410db967816ULL, 0x000fe20000000096ULL, 0x00000001b5b77824ULL, 0x100fe200078e0213ULL,
0xff8000004b4b7808ULL, 0x000fe20000000000ULL, 0x00000001bbbd7824ULL, 0x000fe200078e0213ULL,
0xff80000028287808ULL, 0x000fc40001000000ULL, 0xff80000045457808ULL, 0x000fe40001800000ULL,
0xff80000035357808ULL, 0x000fe40000800000ULL, 0xff80000025257808ULL, 0x000fe40002000000ULL,
0xff80000046467808ULL, 0x000fe40002800000ULL, 0x0000006097ff7212ULL, 0x000fe400078cc0ffULL,
0x0000007aa5ff7212ULL, 0x000fc4000780c0ffULL, 0x0000007ea5ff7212ULL, 0x000fe4000784c0ffULL,
0x00000080adff7212ULL, 0x040fe4000786c0ffULL, 0x00000084adff7212ULL, 0x040fe4000782c0ffULL,
0x00000096adff7212ULL, 0x000fe4000788c0ffULL, 0x00000084b3ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b7827824ULL, 0x100fe200078e0a18ULL, 0x0000005e1b00720cULL, 0x080fe200037c1470ULL,
0x00000001bd187824ULL, 0x000fe200078e0a18ULL, 0x0000005ea300720cULL, 0x000fc40000701470ULL,
0x0000005ea300720cULL, 0x080fe40001741470ULL, 0x0000005e8300720cULL, 0x0c0fe40001f61470ULL,
0x0000005e8300720cULL, 0x0c0fe40000f21470ULL, 0x0000005e8300720cULL, 0x080fe40002781470ULL,
0x0000005eb100720cULL, 0x080fe40002fa1470ULL, 0x0000005e9500720cULL, 0x000fc400037c1070ULL,
0x0000005ea100720cULL, 0x0c0fe40000701070ULL, 0x0000005ea100720cULL, 0x080fe40001741070ULL,
0x0000005e8100720cULL, 0x0c0fe40001f61070ULL, 0x0000005e8100720cULL, 0x0c0fe40000f21070ULL,
0x0000005e8100720cULL, 0x080fe40002781070ULL, 0x0000005eaf00720cULL, 0x000fc40002fa1070ULL,
0x00000082d5b97219ULL, 0x040fe400000006ffULL, 0x00000018d5bf7219ULL, 0x000fe400000006ffULL,
0xff80000056567808ULL, 0x000fe40003000000ULL, 0xff80000034347808ULL, 0x000fe40000000000ULL,
0xff80000027277808ULL, 0x000fe40001000000ULL, 0xff80000059597808ULL, 0x000fc40001800000ULL,
0xff80000036367808ULL, 0x000fe40000800000ULL, 0xff80000026267808ULL, 0x000fe40002000000ULL,
0xff80000037377808ULL, 0x000fe40002800000ULL, 0x00000076abff7212ULL, 0x000fe400078cc0ffULL,
0x00000080b3ff7212ULL, 0x080fe4000780c0ffULL, 0x00000080b9ff7212ULL, 0x000fc4000784c0ffULL,
0x00000086b3ff7212ULL, 0x040fe4000786c0ffULL, 0x00000096b3ff7212ULL, 0x000fe4000782c0ffULL,
0x00000086b9ff7212ULL, 0x000fe4000788c0ffULL, 0x00000084bfff7212ULL, 0x000fe200078ac0ffULL,
0x000000018d8a7824ULL, 0x000fe200078e0a88ULL, 0x0000005ea900720cULL, 0x080fe400037c1470ULL,
0x0000005eb100720cULL, 0x000fc40000701470ULL, 0x0000005eb100720cULL, 0x0c0fe40001f61470ULL,
0x0000005eb100720cULL, 0x080fe40000f21470ULL, 0x0000005eb700720cULL, 0x0c0fe40001741470ULL,
0x0000005eb700720cULL, 0x080fe40002781470ULL, 0x0000005ebd00720cULL, 0x000fe40002fa1470ULL,
0x000000315fc57812ULL, 0x000fc400078efcffULL, 0x000000385fcb7812ULL, 0x040fe400078efcffULL,
0x000000395fd17812ULL, 0x000fe400078efcffULL, 0x0000005ea700720cULL, 0x080fe400037c1070ULL,
0x0000005eaf00720cULL, 0x0c0fe40000701070ULL, 0x0000005eaf00720cULL, 0x0c0fe40001f61070ULL,
0x0000005eaf00720cULL, 0x000fc40000f21070ULL, 0x0000005eb500720cULL, 0x0c0fe40001741070ULL,
0x0000005eb500720cULL, 0x080fe40002781070ULL, 0x0000005ebb00720cULL, 0x000fe40002fa1070ULL,
0x0000008ad5c37219ULL, 0x000fe400000006ffULL, 0x00005410c18e7816ULL, 0x000fe4000000008eULL,
0x00005410d9947816ULL, 0x000fe20000000094ULL, 0x00000001c5c77824ULL, 0x100fe200078e0213ULL,
0xff80000058587808ULL, 0x000fe20003000000ULL, 0x00000001cbcd7824ULL, 0x100fe200078e0213ULL,
0xff80000054547808ULL, 0x000fe20000000000ULL, 0x00000001d1d37824ULL, 0x000fe200078e0213ULL,
0xff8000004c4c7808ULL, 0x000fc40001800000ULL, 0xff80000024247808ULL, 0x000fe40000800000ULL,
0xff80000053537808ULL, 0x000fe40001000000ULL, 0xff80000048487808ULL, 0x000fe40002000000ULL,
0xff80000039397808ULL, 0x000fe40002800000ULL, 0x00000080bfff7212ULL, 0x040fe400078cc0ffULL,
0x00000086bfff7212ULL, 0x000fc4000780c0ffULL, 0x00000084b9ff7212ULL, 0x040fe4000786c0ffULL,
0x00000096b9ff7212ULL, 0x080fe4000782c0ffULL, 0x00000096bfff7212ULL, 0x000fe4000784c0ffULL,
0x0000008ec3ff7212ULL, 0x040fe4000788c0ffULL, 0x00000094c3ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c78c7824ULL, 0x100fe200078e0a88ULL, 0x0000005eb700720cULL, 0x080fe20001f61470ULL,
0x00000001cd907824ULL, 0x100fe200078e0a88ULL, 0x0000005eb700720cULL, 0x080fe20000f21470ULL,
0x00000001d3887824ULL, 0x000fe200078e0a88ULL, 0x0000005ebd00720cULL, 0x000fc400037c1470ULL,
0x0000005ebd00720cULL, 0x0c0fe40000701470ULL, 0x0000005ebd00720cULL, 0x080fe40001741470ULL,
0x0000005e8d00720cULL, 0x0c0fe40002781470ULL, 0x0000005e8d00720cULL, 0x000fe40002fa1470ULL,
0x0000008cd5c97219ULL, 0x040fe400000006ffULL, 0x00000090d5cf7219ULL, 0x000fc400000006ffULL,
0x0000005eb500720cULL, 0x0c0fe40001f61070ULL, 0x0000005eb500720cULL, 0x080fe40000f21070ULL,
0x0000005ebb00720cULL, 0x0c0fe400037c1070ULL, 0x0000005ebb00720cULL, 0x0c0fe40000701070ULL,
0x0000005ebb00720cULL, 0x080fe40001741070ULL, 0x0000005e8b00720cULL, 0x000fc40002781070ULL,
0x0000005e8b00720cULL, 0x000fe40002fa1070ULL, 0x00000088d5d57219ULL, 0x000fe400000006ffULL,
0x00005410d7927816ULL, 0x000fe40000000092ULL, 0xff80000038387808ULL, 0x000fe40001800000ULL,
0xff80000023237808ULL, 0x000fe40000800000ULL, 0xff80000052527808ULL, 0x000fc40003000000ULL,
0xff8000004a4a7808ULL, 0x000fe40000000000ULL, 0xff80000022227808ULL, 0x000fe40001000000ULL,
0xff80000051517808ULL, 0x000fe40002000000ULL, 0xff8000003d3d7808ULL, 0x000fe40002800000ULL,
0x0000008ec9ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008ecfff7212ULL, 0x000fc4000782c0ffULL,
0x0000008ed5ff7212ULL, 0x000fe400078cc0ffULL, 0x00000092c3ff7212ULL, 0x080fe4000780c0ffULL,
0x00000092c9ff7212ULL, 0x080fe4000784c0ffULL, 0x00000092cfff7212ULL, 0x000fe4000788c0ffULL,
0x00000094c9ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005e8d00720cULL, 0x000fc40000701470ULL,
0x0000005ec700720cULL, 0x0c0fe40001f61470ULL, 0x0000005ec700720cULL, 0x0c0fe40001741470ULL,
0x0000005ec700720cULL, 0x080fe40002fa1470ULL, 0x0000005ecd00720cULL, 0x080fe40000f21470ULL,
0x0000005ed300720cULL, 0x080fe400037c1470ULL, 0x0000005ecd00720cULL, 0x000fc40002781470ULL,
0x0000005e8b00720cULL, 0x080fe40000701070ULL, 0x0000005ec500720cULL, 0x0c0fe40001f61070ULL,
0x0000005ec500720cULL, 0x0c0fe40001741070ULL, 0x0000005ec500720cULL, 0x080fe40002fa1070ULL,
0x0000005ecb00720cULL, 0x080fe40000f21070ULL, 0x0000005ed100720cULL, 0x000fc400037c1070ULL,
0x0000005ecb00720cULL, 0x000fe40002781070ULL, 0x00005410dd987816ULL, 0x000fe40000000098ULL,
0xff80000049497808ULL, 0x000fe40000000000ULL, 0xff80000050507808ULL, 0x000fe40001800000ULL,
0xff80000040407808ULL, 0x000fe40001000000ULL, 0xff8000003a3a7808ULL, 0x000fc40002800000ULL,
0xff8000004f4f7808ULL, 0x000fe40000800000ULL, 0xff8000004e4e7808ULL, 0x000fe40003000000ULL,
0xff8000003f3f7808ULL, 0x000fe40002000000ULL, 0x00000092d5ff7212ULL, 0x000fe4000780c0ffULL,
0x00000094cfff7212ULL, 0x080fe4000786c0ffULL, 0x00000094d5ff7212ULL, 0x000fc4000784c0ffULL,
0x00000098c3ff7212ULL, 0x080fe400078ac0ffULL, 0x00000098c9ff7212ULL, 0x080fe4000782c0ffULL,
0x00000098cfff7212ULL, 0x080fe400078cc0ffULL, 0x00000098d5ff7212ULL, 0x000fe4000788c0ffULL,
0x0000005e8d00720cULL, 0x080fe40002fa1470ULL, 0x0000005ec700720cULL, 0x000fc40000f21470ULL,
0x0000005ecd00720cULL, 0x0c0fe40001f61470ULL, 0x0000005ecd00720cULL, 0x080fe400037c1470ULL,
0x0000005ed300720cULL, 0x0c0fe40000701470ULL, 0x0000005ed300720cULL, 0x0c0fe40001741470ULL,
0x0000005ed300720cULL, 0x080fe40002781470ULL, 0x0000005e8b00720cULL, 0x000fc40002fa1070ULL,
0x0000005ec500720cULL, 0x080fe40000f21070ULL, 0x0000005ed100720cULL, 0x080fe40000701070ULL,
0x0000005ecb00720cULL, 0x0c0fe40001f61070ULL, 0x0000005ecb00720cULL, 0x080fe400037c1070ULL,
0x0000005ed100720cULL, 0x0c0fe40001741070ULL, 0x0000005ed100720cULL, 0x000fc40002781070ULL,
0xff8000003e3e7808ULL, 0x000fe40000000000ULL, 0xff8000003b3b7808ULL, 0x000fe40001800000ULL,
0xff8000003c3c7808ULL, 0x000fe40001000000ULL, 0xff80000021217808ULL, 0x000fe40002800000ULL,
0xff80000020207808ULL, 0x000fe40000800000ULL, 0xff8000001f1f7808ULL, 0x000fc40003000000ULL,
0xff8000001e1e7808ULL, 0x000fc40002000000ULL, 0x0000005d0400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff187424ULL, 0x000fe200078e00ffULL, 0x000000420500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x0000002f0600720bULL, 0x000fe40003f5e000ULL,
0x0000002c0700720bULL, 0x000fe40003f7e000ULL, 0x000000045d047208ULL, 0x000fe40004000000ULL,
0x0000000542087208ULL, 0x000fc40004800000ULL, 0x000000062f057208ULL, 0x000fe40005000000ULL,
0x000000072c077208ULL, 0x000fe40005800000ULL, 0x000000550400720bULL, 0x000fe40003f1e000ULL,
0x0000002e0500720bULL, 0x000fe40003f5e000ULL, 0x0000004d0800720bULL, 0x000fe40003f3e000ULL,
0x0000002a0700720bULL, 0x000fc40003f7e000ULL, 0x0000000455097208ULL, 0x000fe40004000000ULL,
0x000000052e057208ULL, 0x000fe40005000000ULL, 0x000000084d087208ULL, 0x000fe40004800000ULL,
0x000000072a047208ULL, 0x000fe40005800000ULL, 0x0000005c0900720bULL, 0x000fe40003f1e000ULL,
0x000000300500720bULL, 0x000fc40003f5e000ULL, 0x000000410800720bULL, 0x000fe40003f3e000ULL,
0x0000002b0400720bULL, 0x000fe40003f7e000ULL, 0x000000095c097208ULL, 0x000fe40004000000ULL,
0x0000000530067208ULL, 0x000fe40005000000ULL, 0x0000000841077208ULL, 0x000fe40004800000ULL,
0x000000042b047208ULL, 0x000fc40005800000ULL, 0x000000560900720bULL, 0x000fe40003f1e000ULL,
0x000000310600720bULL, 0x000fe40003f5e000ULL, 0x000000440700720bULL, 0x000fe40003f3e000ULL,
0x0000002d0400720bULL, 0x000fe40003f7e000ULL, 0x0000000956087208ULL, 0x000fe40004000000ULL,
0x0000000631057208ULL, 0x000fc40005000000ULL, 0x00000007440a7208ULL, 0x000fe40004800000ULL,
0x000000042d047208ULL, 0x000fe40005800000ULL, 0x0000005b0800720bULL, 0x000fe40003f1e000ULL,
0x000000320500720bULL, 0x000fe40003f5e000ULL, 0x000000430a00720bULL, 0x000fe40003f3e000ULL,
0x000000290400720bULL, 0x000fc40003f7e000ULL, 0x000000085b087208ULL, 0x000fe40004000000ULL,
0x0000000532067208ULL, 0x000fe40005000000ULL, 0x0000000a430a7208ULL, 0x000fe40004800000ULL,
0x0000000429057208ULL, 0x000fe40005800000ULL, 0x000000570800720bULL, 0x000fe40003f1e000ULL,
0x000000330600720bULL, 0x000fc40003f5e000ULL, 0x0000004b0a00720bULL, 0x000fe40003f3e000ULL,
0x000000280500720bULL, 0x000fe40003f7e000ULL, 0x0000000857077208ULL, 0x000fe40004000000ULL,
0x0000000633097208ULL, 0x000fe40005000000ULL, 0x0000000a4b0a7208ULL, 0x000fe40004800000ULL,
0x0000000528047208ULL, 0x000fc40005800000ULL, 0x0000005a0700720bULL, 0x000fe40003f1e000ULL,
0x000000340900720bULL, 0x000fe40003f5e000ULL, 0x000000450a00720bULL, 0x000fe40003f3e000ULL,
0x000000270400720bULL, 0x000fe40003f7e000ULL, 0x000000075a077208ULL, 0x000fe40004000000ULL,
0x0000000934067208ULL, 0x000fc40005000000ULL, 0x0000000a450a7208ULL, 0x000fe40004800000ULL,
0x0000000427047208ULL, 0x000fe40005800000ULL, 0x000000580700720bULL, 0x000fe40003f1e000ULL,
0x000000350600720bULL, 0x000fe40003f5e000ULL, 0x000000470a00720bULL, 0x000fe40003f3e000ULL,
0x000000250400720bULL, 0x000fc40003f7e000ULL, 0x0000000758087208ULL, 0x000fe40004000000ULL,
0x0000000635077208ULL, 0x000fe40005000000ULL, 0x0000000a47057208ULL, 0x000fe40004800000ULL,
0x0000000425097208ULL, 0x000fe40005800000ULL, 0x000000590800720bULL, 0x000fe40003f1e000ULL,
0x000000360700720bULL, 0x000fc40003f5e000ULL, 0x000000460500720bULL, 0x000fe40003f3e000ULL,
0x000000260900720bULL, 0x000fe40003f7e000ULL, 0x00000008590b7208ULL, 0x000fe40004000000ULL,
0x0000000736047208ULL, 0x000fe40005000000ULL, 0x0000000546057208ULL, 0x000fe40004800000ULL,
0x0000000926097208ULL, 0x000fc40005800000ULL, 0x000000540b00720bULL, 0x000fe40003f1e000ULL,
0x000000370400720bULL, 0x000fe40003f5e000ULL, 0x0000004c0500720bULL, 0x000fe40003f3e000ULL,
0x000000240900720bULL, 0x000fe40003f7e000ULL, 0x0000000b54067208ULL, 0x000fe40004000000ULL,
0x0000000437077208ULL, 0x000fc40005000000ULL, 0x000000054c057208ULL, 0x000fe40004800000ULL,
0x0000000924047208ULL, 0x000fe40005800000ULL, 0x000000530600720bULL, 0x000fe40003f1e000ULL,
0x000000380700720bULL, 0x000fe40003f5e000ULL, 0x000000480500720bULL, 0x000fe40003f3e000ULL,
0x000000230400720bULL, 0x000fc40003f7e000ULL, 0x0000000653097208ULL, 0x000fe40004000000ULL,
0x0000000738067208ULL, 0x000fe40005000000ULL, 0x0000000548057208ULL, 0x000fe40004800000ULL,
0x0000000423077208ULL, 0x000fe40005800000ULL, 0x000000520900720bULL, 0x000fe40003f1e000ULL,
0x0000004a0500720bULL, 0x000fc40003f3e000ULL, 0x000000390600720bULL, 0x000fe40003f5e000ULL,
0x000000220700720bULL, 0x000fe40003f7e000ULL, 0x0000000952047208ULL, 0x000fe40004000000ULL,
0x000000054a087208ULL, 0x000fe40004800000ULL, 0x0000000639067208ULL, 0x000fe40005000000ULL,
0x00000007220a7208ULL, 0x000fc40005800000ULL, 0x000000510400720bULL, 0x000fe40003f1e000ULL,
0x000000490800720bULL, 0x000fe40003f3e000ULL, 0x0000003d0600720bULL, 0x000fe40003f5e000ULL,
0x000000210a00720bULL, 0x000fe40003f7e000ULL, 0x0000000451057208ULL, 0x000fe40004000000ULL,
0x0000000849077208ULL, 0x000fc40004800000ULL, 0x000000063d097208ULL, 0x000fe40005000000ULL,
0x0000000a210b7208ULL, 0x000fe40005800000ULL, 0x000000500500720bULL, 0x000fe40003f1e000ULL,
0x000000400700720bULL, 0x000fe40003f3e000ULL, 0x0000003a0900720bULL, 0x000fe40003f5e000ULL,
0x000000200b00720bULL, 0x000fc40003f7e000ULL, 0x0000000550047208ULL, 0x000fe40004000000ULL,
0x0000000740067208ULL, 0x000fe40004800000ULL, 0x000000093a087208ULL, 0x000fe40005000000ULL,
0x0000000b200a7208ULL, 0x000fe40005800000ULL, 0x0000004f0400720bULL, 0x000fe40003f1e000ULL,
0x0000003f0600720bULL, 0x000fc40003f3e000ULL, 0x0000003b0800720bULL, 0x000fe40003f5e000ULL,
0x0000001f0a00720bULL, 0x000fe40003f7e000ULL, 0x000000044f057208ULL, 0x000fe40004000000ULL,
0x000000063f077208ULL, 0x000fe40004800000ULL, 0x000000083b097208ULL, 0x000fe40005000000ULL,
0x0000000a1f0b7208ULL, 0x000fc40005800000ULL, 0x0000004e0500720bULL, 0x000fe40003f1e000ULL,
0x0000003e0700720bULL, 0x000fe40003f3e000ULL, 0x0000003c0900720bULL, 0x000fe40003f5e000ULL,
0x0000001e0b00720bULL, 0x000fe40003f7e000ULL, 0x000000054e057208ULL, 0x000fe40004000000ULL,
0x000000073e0a7208ULL, 0x000fc40004800000ULL, 0x000000093c167208ULL, 0x000fe40005000000ULL,
0x0000000b1e157208ULL, 0x000fe20005800000ULL, 0x000020927f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x0004e400000e0000ULL, 0x000000040500720bULL, 0x008fc80003f1e000ULL,
0x0000000504177208ULL, 0x000fe20004000000ULL, 0x000020b27f007947ULL, 0x000fea000b800000ULL,
0x0c401f000a047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0016057f89ULL, 0x004ea800000e0000ULL,
0x0c401f0015067f89ULL, 0x000e6200000e0000ULL, 0x000000040a00720bULL, 0x008fc40003f1e000ULL,
0x000000051600720bULL, 0x004fe40003f3e000ULL, 0x0000000a04077208ULL, 0x002fe40004000000ULL,
0x0000001605087208ULL, 0x000fe20004800000ULL, 0x0c201f0017047f89ULL, 0x000e6200000e0000ULL,
0x000000061500720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007147f89ULL, 0x000ea200000e0000ULL,
0x00000015060a7208ULL, 0x000fc60004000000ULL, 0x0c201f0008097f89ULL, 0x000ee800000e0000ULL,
0x0c201f000a0b7f89ULL, 0x0002e400000e0000ULL, 0x000000041700720bULL, 0x002fe40003f1e000ULL,
0x000000140700720bULL, 0x004fe40003f3e000ULL, 0x0000001704047208ULL, 0x000fc40004000000ULL,
0x000000090800720bULL, 0x008fe40003f5e000ULL, 0x0000000714057208ULL, 0x000fe40004800000ULL,
0x0000000809067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x00000002ff5e7819ULL, 0x000fe20000011669ULL, 0x3fb8aa3b55557823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b5d5d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b5c5c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b56567823ULL, 0x100fe20000010807ULL, 0x0000005500097308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b5b5b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b57577823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b5a5a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b58587823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b54547823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b51517823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b59557823ULL, 0x102fe20000010807ULL, 0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4e4e7823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b05077820ULL, 0x000fe20000410000ULL, 0x0000005a00167308ULL, 0x000fe20000000800ULL,
0x000000085e5f7824ULL, 0x000fc400078e00ffULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010807ULL,
0x0000004100187308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b49417823ULL, 0x102fe20000010807ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3e3e7823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b06077820ULL, 0x000fe20000410000ULL, 0x0000005d00087308ULL, 0x0002a20000000800ULL,
0x000000085e637824ULL, 0x000fc400078e00ffULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b38387823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3c3c7823ULL, 0x000fe20000010807ULL, 0x0000000a0b077208ULL, 0x000fe20004000000ULL,
0x0000005c005c7308ULL, 0x000fe20000000800ULL, 0x000000035e0b7810ULL, 0x040fe20007ffe0ffULL,
0x000000085e5d7824ULL, 0x042fe200078e00ffULL, 0x000000015e0a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b075a7820ULL, 0x000fe20000410000ULL, 0x000000080908723eULL, 0x004fc400000010ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee20aULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001085aULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001085aULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001085aULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001085aULL, 0x0000005600157308ULL, 0x000e620000000800ULL,
0x000000025e0a7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001085aULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001085aULL, 0x3fb8aa3b25257823ULL, 0x000fe2000001085aULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee20aULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001085aULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001085aULL, 0x0000004400197308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001085aULL, 0x3fb8aa3b23237823ULL, 0x000fe2000001085aULL,
0x0000000369ff7812ULL, 0x000fca000780c0ffULL, 0x0000003400497308ULL, 0x0007e20000000800ULL,
0x0000005c150a723eULL, 0x002fce00000010ffULL, 0x0000004200427308ULL, 0x000fe20000000800ULL,
0x000000085e347824ULL, 0x008fca00078e00ffULL, 0xfffffff834617812ULL, 0x000fe200078ee20bULL,
0x00000004ff347e24ULL, 0x000fe2000f8e00ffULL, 0x0000004d004d7308ULL, 0x000e620000000800ULL,
0x00000018190b723eULL, 0x004fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x3f8000003434783eULL, 0x000fc800000010ffULL, 0x0000004300437308ULL, 0x000fe20000000800ULL,
0x000000ffff727224ULL, 0x100fe400078e0034ULL, 0x000000ffff737224ULL, 0x000fca00078e0034ULL,
0x0000004b001a7308ULL, 0x000ea20000000800ULL, 0x000000424d09723eULL, 0x002fe200000010ffULL,
0x000000085e427824ULL, 0x000fcc00078e00ffULL, 0x0000002c002c7308ULL, 0x000ff00000000800ULL,
0x0000002a001b7308ULL, 0x000e620000000800ULL, 0x000000431a15723eULL, 0x004fe200000010ffULL,
0x000000085e437824ULL, 0x000fca00078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee25eULL,
0x0000002f002f7308ULL, 0x000ff00000000800ULL, 0x0000002e002e7308ULL, 0x000ea20000000800ULL,
0x0000002c1b19723eULL, 0x002fce00000010ffULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000e620000000800ULL, 0x0000002f2e18723eULL, 0x004fce00000010ffULL,
0x0000002b002b7308ULL, 0x000ff00000000800ULL, 0x0000002d002a7308ULL, 0x000ea20000000800ULL,
0x00000030311a723eULL, 0x002fce00000010ffULL, 0x0000004a004b7308ULL, 0x000ff00000000800ULL,
0x00000035004a7308ULL, 0x0003e20000000800ULL, 0x0000002b2a1b723eULL, 0x004fe400000010ffULL,
0x000000065e2b7810ULL, 0x000fc40007ffe0ffULL, 0x000000055e2a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8424d7812ULL, 0x000fe200078ee22bULL, 0x0000005800177308ULL, 0x000ea20000000800ULL,
0x000000ffff357224ULL, 0x002fe200078e0034ULL, 0x3fb8aa3b1f427823ULL, 0x000fcc000001085aULL,
0x0000005b00147308ULL, 0x000fe20000000800ULL, 0x00000034082c723cULL, 0x000f6e00000418ffULL,
0x0000005700577308ULL, 0x000e620000000800ULL, 0x000000161716723eULL, 0x004fce00000010ffULL,
0x0000004500457308ULL, 0x000ff00000000800ULL, 0x0000004700567308ULL, 0x000ea20000000800ULL,
0x000000145714723eULL, 0x002fe200000010ffULL, 0x000000085e577824ULL, 0x000fcc00078e00ffULL,
0x0000003200447308ULL, 0x0003f00000000800ULL, 0x0000003c005b7308ULL, 0x000fe20000000800ULL,
0x000000045e327810ULL, 0x002fe40007ffe0ffULL, 0x000000455617723eULL, 0x004fe200000010ffULL,
0x000000085e457824ULL, 0x000fe200078e00ffULL, 0xfffffff863637812ULL, 0x000fc600078ee232ULL,
0x0000004c00597308ULL, 0x000fe20000000800ULL, 0xfffffff845457812ULL, 0x000fe200078ee22aULL,
0x00000072142c723cULL, 0x020fe2000004182cULL, 0x000000494a2a723eULL, 0x000fe400000010ffULL,
0x000000105e497810ULL, 0x000fc60007ffe0ffULL, 0x0000003300477308ULL, 0x0003f00000000800ULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x000000341830723cULL, 0x002f6e00000418ffULL,
0x00000025003c7308ULL, 0x0002b00000000800ULL, 0x0000003a004c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b22257823ULL, 0x002fce000001085aULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x000000273c2b723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b203c7823ULL, 0x000fe2000001085aULL,
0x000000ffff207224ULL, 0x000fca00078e0034ULL, 0x00000028003a7308ULL, 0x0002b00000000800ULL,
0x0000003b00587308ULL, 0x0007e20000000800ULL, 0xffffffff5e287810ULL, 0x002fc80007ffe0ffULL,
0xfffffff857577812ULL, 0x000fe400078ee228ULL, 0x000000444728723eULL, 0x000fe200000010ffULL,
0x0000005500557308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b213b7823ULL, 0x008fe2000001085aULL,
0x000000293a29723eULL, 0x004fe200000010ffULL, 0x000000ffff217224ULL, 0x000fe200078e0034ULL,
0x3fb8aa3b1e5a7823ULL, 0x000fe2000001085aULL, 0x000000085e477810ULL, 0x040fe40007ffe0ffULL,
0x000000185e5e7810ULL, 0x000fe20007ffe0ffULL, 0x0000005400547308ULL, 0x000e640000000800ULL,
0x000000202830723cULL, 0x020b620000041830ULL, 0x0000000847447824ULL, 0x000fca00078e00ffULL,
0x0000005300537308ULL, 0x000fe20000000800ULL, 0xfffffff844477812ULL, 0x000fce00078ee247ULL,
0x0000005200527308ULL, 0x000ea20000000800ULL, 0x000000555420723eULL, 0x022fe200000010ffULL,
0x000000ffff547224ULL, 0x100fe400078e0034ULL, 0x000000ffff557224ULL, 0x000fc800078e0034ULL,
0x0000004600467308ULL, 0x000e700000000800ULL, 0x0000004800487308ULL, 0x000fe20000000800ULL,
0x000000535222723eULL, 0x004fe200000010ffULL, 0x000000085e537824ULL, 0x000fcc00078e00ffULL,
0x0000002600357308ULL, 0x0005e20000000800ULL, 0x000000465921723eULL, 0x002fce00000010ffULL,
0x00000024003a7308ULL, 0x000fe20000000800ULL, 0x0000000849267824ULL, 0x004fca00078e00ffULL,
0xfffffff826497812ULL, 0x000fe400078ee249ULL, 0x0000003600367308ULL, 0x000ff00000000800ULL,
0x0000003700377308ULL, 0x000e700000000800ULL, 0x0000003800387308ULL, 0x000ff00000000800ULL,
0x0000003900397308ULL, 0x000ea20000000800ULL, 0x000000363724723eULL, 0x002fce00000010ffULL,
0x0000002300277308ULL, 0x0003f00000000800ULL, 0x00000025001e7308ULL, 0x0006e20000000800ULL,
0x000000484b23723eULL, 0x002fe400000010ffULL, 0x000000383926723eULL, 0x004fc400000010ffULL,
0xfffffff8534b7812ULL, 0x000fc600078ee25eULL, 0x0000003f003f7308ULL, 0x000fe20000000800ULL,
0x000000353a25723eULL, 0x008fe200000010ffULL, 0x000000ffff357224ULL, 0x000fe200078e0034ULL,
0x00000054202c723cULL, 0x000f6a000004182cULL, 0x0000003e003e7308ULL, 0x000e620000000800ULL,
0x000000271e27723eULL, 0x000fe400000010ffULL, 0x0000a000111e7811ULL, 0x000fca00078e60ffULL,
0x0000004100417308ULL, 0x000fe20000000800ULL, 0x000000342430723cULL, 0x000fe20000041830ULL,
0x0000001043437824ULL, 0x100fe400078e021eULL, 0x000000105d5d7824ULL, 0x100fe400078e021eULL,
0x000000105f5f7824ULL, 0x100fe400078e021eULL, 0x0000004000407308ULL, 0x000ea20000000800ULL,
0x0000001061617824ULL, 0x100fe400078e021eULL, 0x0000001063637824ULL, 0x000fc400078e021eULL,
0x0000001045457824ULL, 0x100fe400078e021eULL, 0x000000104d4d7824ULL, 0x100fe200078e021eULL,
0x0000003b001f7308ULL, 0x0003e20000000800ULL, 0x0000001057577824ULL, 0x100fe400078e021eULL,
0x0000001047477824ULL, 0x100fe400078e021eULL, 0x0000001049497824ULL, 0x100fe400078e021eULL,
0x000000104b4b7824ULL, 0x000fe200078e021eULL, 0x0000005100517308ULL, 0x000fe20000000800ULL,
0x0000003f3e3b723eULL, 0x002fc400000010ffULL, 0x000000414039723eULL, 0x004fe400000010ffULL,
0x0000000c1d407812ULL, 0x000fe400078ec0ffULL, 0x000000585b3e723eULL, 0x000fe200000010ffULL,
0x0000005000507308ULL, 0x000e640000000800ULL, 0x0000000143437824ULL, 0x000fe400078e0240ULL,
0x00000001405d7824ULL, 0x040fe400078e025dULL, 0x00000001405f7824ULL, 0x040fe200078e025fULL,
0x0000000843007388ULL, 0x0005e20000000800ULL, 0x0000004f004f7308ULL, 0x000fe20000000800ULL,
0x0000000140617824ULL, 0x000fc400078e0261ULL, 0x0000000140637824ULL, 0x040fe200078e0263ULL,
0x0000000a5d007388ULL, 0x0007e20000000800ULL, 0x0000000140457824ULL, 0x040fe400078e0245ULL,
0x00000001404d7824ULL, 0x000fe200078e024dULL, 0x0000004e004e7308ULL, 0x000ee20000000800ULL,
0x000000515038723eULL, 0x002fe200000010ffULL, 0x0000000140577824ULL, 0x040fe200078e0257ULL,
0x000000145f007388ULL, 0x0003e20000000800ULL, 0x0000000140087824ULL, 0x044fe400078e0247ULL,
0x0000000140497824ULL, 0x040fe200078e0249ULL, 0x0000001661007388ULL, 0x0003e20000000800ULL,
0x0000003d003d7308ULL, 0x000ea20000000800ULL, 0x0000000140407824ULL, 0x000fc400078e024bULL,
0x0000002063007388ULL, 0x0003e80000000800ULL, 0x0000002245007388ULL, 0x0003e20000000800ULL,
0x0000003c00367308ULL, 0x0004620000000800ULL, 0x0000004f4e3a723eULL, 0x008fe400000010ffULL,
0x000000384d007388ULL, 0x0007e80000000800ULL, 0x0000003a57007388ULL, 0x0007e20000000800ULL,
0x0000004200427308ULL, 0x000fe20000000800ULL, 0x0000003d4c3c723eULL, 0x004fe200000010ffULL,
0x00000034382c723cULL, 0x020f62000004182cULL, 0x0000000908007388ULL, 0x0007e80000000800ULL,
0x0004000b5d007388ULL, 0x0007e20000000800ULL, 0x0000005a003f7308ULL, 0x000ea20000000800ULL,
0x0000001f363d723eULL, 0x002fc400000010ffULL, 0x000400155f007388ULL, 0x0007e80000000800ULL,
0x0004001761007388ULL, 0x0007e80000000800ULL, 0x0004002163007388ULL, 0x0007e80000000800ULL,
0x0004002345007388ULL, 0x0007e20000000800ULL, 0x000000423f3f723eULL, 0x004fc400000010ffULL,
0x000000ffff2d7224ULL, 0x020fe200078e002eULL, 0x000400394d007388ULL, 0x0007e80000000800ULL,
0x000000343c30723cULL, 0x000f620000041830ULL, 0x0004003b57007388ULL, 0x0007e80000000800ULL,
0x0000001849007388ULL, 0x0007e80000000800ULL, 0x0008001a5d007388ULL, 0x0007e80000000800ULL,
0x000800285f007388ULL, 0x0007e80000000800ULL, 0x0008002a61007388ULL, 0x0007e80000000800ULL,
0x0008002463007388ULL, 0x0007e60000000800ULL, 0x000000ffff2e7224ULL, 0x020fe200078e0030ULL,
0x0008002645007388ULL, 0x0007e20000000800ULL, 0x000000ffff2f7224ULL, 0x000fc600078e0032ULL,
0x0008003c4d007388ULL, 0x0007e80000000800ULL, 0x0008003e57007388ULL, 0x0007e80000000800ULL,
0x0000001940007388ULL, 0x0007e80000000800ULL, 0x000c001b5d007388ULL, 0x0007e80000000800ULL,
0x000c00295f007388ULL, 0x0007e80000000800ULL, 0x000c002b61007388ULL, 0x0007e80000000800ULL,
0x000c002563007388ULL, 0x0007e80000000800ULL, 0x000c002745007388ULL, 0x0007e80000000800ULL,
0x000c003d4d007388ULL, 0x0007e80000000800ULL, 0x000c003f57007388ULL, 0x0007e80000000800ULL,
0x012000041c008388ULL, 0x0007e80000000c00ULL, 0x0122002c1c008388ULL, 0x0007e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000006dff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008006dff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010006dff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000016e6e7810ULL, 0x000fe20007ffe0ffULL,
0x000018006dff7f8cULL, 0x0003e6000c80043fULL, 0x0000000c6e00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff8d5000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x0001982000267802ULL, 0x000fc40000000f00ULL, 0x0000109000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff177224ULL, 0x000fe200078e0025ULL, 0xfffe94b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005000000ULL, 0x0001987000267802ULL, 0x000fc40000000f00ULL,
0x0000104000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0025ULL,
0xfffe951000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001aULL,
0x000198c000257802ULL, 0x000fc40000000f00ULL, 0x00000fa000007944ULL, 0x014fea0003c00000ULL,
0xfffe95e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001aULL,
0x0001990000257802ULL, 0x000fc40000000f00ULL, 0x00000f6000007944ULL, 0x014fea0003c00000ULL,
0xfffe971000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001aULL,
0x0001994000257802ULL, 0x000fc40000000f00ULL, 0x00000f2000007944ULL, 0x014fea0003c00000ULL,
0xfffe984000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001aULL,
0x0001998000257802ULL, 0x000fc40000000f00ULL, 0x00000ee000007944ULL, 0x014fea0003c00000ULL,
0xfffe996000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x000199d000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0017ULL,
0x00000e9000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xfffe9d5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x00019a2000257802ULL, 0x000fc40000000f00ULL, 0x00000e4000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0026ULL, 0x0000001017277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x00019a7000257802ULL, 0x000fc40000000f00ULL,
0x00000df000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0026ULL,
0xfffe9d0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x00019ac000257802ULL, 0x000fc40000000f00ULL, 0x00000da000007944ULL, 0x01cfea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0026ULL, 0xfffe9ce000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x00019b1000267802ULL, 0x000fc40000000f00ULL,
0x00000da000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff707224ULL, 0x000fe200078e0025ULL,
0xfffec6a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005000000ULL,
0x00019b6000267802ULL, 0x000fc40000000f00ULL, 0x00000d5000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff717224ULL, 0x000fe200078e0025ULL, 0xfffec6e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0073ULL, 0x00019bb000257802ULL, 0x000fc40000000f00ULL,
0x00000cb000007944ULL, 0x014fea0003c00000ULL, 0xfffec7c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0073ULL, 0x00019bf000257802ULL, 0x000fc40000000f00ULL,
0x00000c7000007944ULL, 0x014fea0003c00000ULL, 0xfffec8f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0073ULL, 0x00019c3000257802ULL, 0x000fc40000000f00ULL,
0x00000c3000007944ULL, 0x014fea0003c00000ULL, 0xfffeca2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0073ULL, 0x00019c7000257802ULL, 0x000fc40000000f00ULL,
0x00000bf000007944ULL, 0x014fea0003c00000ULL, 0xfffecb4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x00019cc000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0029ULL, 0x00000ba000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xfffecf6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x00019d1000257802ULL, 0x000fc40000000f00ULL,
0x00000b5000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0026ULL,
0x0000001029277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x00019d6000257802ULL, 0x000fc40000000f00ULL, 0x00000b0000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0026ULL, 0xfffecf1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x00019db000257802ULL, 0x000fc40000000f00ULL,
0x00000ab000007944ULL, 0x01cfea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0026ULL,
0xfffecef000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x00019e0000267802ULL, 0x000fc40000000f00ULL, 0x00000ab000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff727224ULL, 0x000fe200078e0025ULL, 0xfffef69000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005000000ULL, 0x00019e5000267802ULL, 0x000fc40000000f00ULL,
0x00000a6000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e0025ULL,
0xfffef6e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x00019ea000257802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x014fea0003c00000ULL,
0xfffef7c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x00019ee000257802ULL, 0x000fc40000000f00ULL, 0x0000098000007944ULL, 0x014fea0003c00000ULL,
0xfffef8f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x00019f2000257802ULL, 0x000fc40000000f00ULL, 0x0000094000007944ULL, 0x014fea0003c00000ULL,
0xfffefa2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x00019f6000257802ULL, 0x000fc40000000f00ULL, 0x0000090000007944ULL, 0x014fea0003c00000ULL,
0xfffefb4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x00019fb000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0023ULL,
0x000008b000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xfffeff6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001a00000257802ULL, 0x000fc40000000f00ULL, 0x0000086000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0026ULL, 0x0000001023277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001a05000257802ULL, 0x000fc40000000f00ULL,
0x0000081000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0026ULL,
0xfffeff1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001a0a000257802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x01cfea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0026ULL, 0xfffefef000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x004fe40004000000ULL, 0x0001a0f000267802ULL, 0x000fc40000000f00ULL,
0x000007c000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff057224ULL, 0x000fe200078e0025ULL,
0xffff276000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005000000ULL,
0x0001a14000267802ULL, 0x000fc40000000f00ULL, 0x0000077000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0025ULL, 0xffff27b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0003ULL, 0x0001a19000257802ULL, 0x000fc40000000f00ULL,
0x000006d000007944ULL, 0x018fea0003c00000ULL, 0xffff288000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0003ULL, 0x0001a1d000257802ULL, 0x000fc40000000f00ULL,
0x0000069000007944ULL, 0x018fea0003c00000ULL, 0xffff29b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0003ULL, 0x0001a21000257802ULL, 0x000fc40000000f00ULL,
0x0000065000007944ULL, 0x018fea0003c00000ULL, 0xffff2ae000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0003ULL, 0x0001a25000257802ULL, 0x000fc40000000f00ULL,
0x0000061000007944ULL, 0x018fea0003c00000ULL, 0xffff2c0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x0001a2a000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0003ULL, 0x000005c000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xffff302000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x0001a2f000257802ULL, 0x000fc40000000f00ULL,
0x0000057000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0026ULL,
0x0000001003277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x0001a34000257802ULL, 0x000fc40000000f00ULL, 0x0000052000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0026ULL, 0xffff2fd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x0001a39000257802ULL, 0x000fc40000000f00ULL,
0x000004d000007944ULL, 0x01cfea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0026ULL,
0xffff2fb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x000fe200078e0005ULL,
0x0001a3f000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff147424ULL, 0x000fc400078e00ffULL,
0x0000043000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000bULL,
0xffffdf2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x002fe200078e000aULL,
0x0001a45000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff147424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x014fea0003c00000ULL, 0x0000000b0a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0016ULL, 0x0001a4b000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff147424ULL, 0x000fe200078e00ffULL, 0x0000000a0b067208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0015ULL, 0x0001a51000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff147424ULL, 0x000fe200078e00ffULL, 0x000000160b167208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0017ULL, 0x0001a57000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000150b0a7208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0006ULL, 0x0001a5d000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000170b047208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0016ULL, 0x0001a63000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000060b057208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x0000000b1600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000aULL, 0x0001a69000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x000000160b067208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffddf000007947ULL, 0x000fea000383ffffULL,
0x0180000024007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002400008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff24ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000024027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002400007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe57e002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000001900007348ULL, 0x000fe80003800000ULL,
0x0c000014070b7389ULL, 0x0002a200000e0018ULL, 0xfffe57a008007950ULL, 0x000fea0003c3ffffULL,
0x000000ffff6c7224ULL, 0x000fe200078e0025ULL, 0x0000008600007348ULL, 0x000fe80003800000ULL,
0x00000000ff6d7424ULL, 0x000fe200078e00ffULL, 0x0000002726267389ULL, 0x0002a600000e0087ULL,
0xfffe57506c007950ULL, 0x000fea0003c3ffffULL, 0x000000012500780cULL, 0x000fe20003f45070ULL,
0x00000000ff277424ULL, 0x000fe200078e00ffULL, 0x0000008500007348ULL, 0x000ff60003800000ULL,
0x0000000000257806ULL, 0x000fc800050e0100ULL, 0x0000008525257212ULL, 0x000fe200078ec0ffULL,
0xfffe56f026007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000568ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000340ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c78ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d38ULL,
0x00000000000008acULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001688ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000168cULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x000000000001aa00ULL, 0xe000001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c280ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c2c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001c640ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001688ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001abf8ULL,
0x000000000001abf8ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001c280ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001c640ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_32_sm_89_cubin_len = 116512;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
