/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000170c8ULL, 0x0000000000016d48ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x326a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x000000676e696469ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x616c65722e006168ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000020cULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b000100000253ULL, 0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000299ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b000100000383ULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003d1ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000417ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000465ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004c0ULL,
0x00000000000156d0ULL, 0x0000000000000230ULL, 0x0004000300000536ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000015900ULL,
0x000d000300000566ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000156d000000000ULL, 0x0001380400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL,
0x0000002cffffffffULL, 0x0000006000000000ULL, 0x000156d000000000ULL, 0x0000023000000000ULL,
0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL,
0x0008230400000080ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000000000017ULL,
0x0000001700081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL, 0x0060000a00000000ULL,
0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL,
0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00801b030011f000ULL, 0xffffffff00942904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000018000942804ULL, 0x000009f0000004b0ULL, 0x00002bc000002b50ULL, 0x00002dd000002c90ULL,
0x0000334000003330ULL, 0x000057d000005770ULL, 0x00005a10000058d0ULL, 0x00005e2000005e10ULL,
0x000081c000008160ULL, 0x00008400000082c0ULL, 0x0000881000008800ULL, 0x0000ac100000abb0ULL,
0x0000ae500000ad10ULL, 0x0000b2a00000b290ULL, 0x0000cbd00000cbc0ULL, 0x00014b5000014aa0ULL,
0x00014e2000014d70ULL, 0x00015120000150a0ULL, 0x000152a000015240ULL, 0x0000053004303904ULL,
0x00017600000000ffULL, 0x0000061000040100ULL, 0x0001760800000009ULL, 0x00000720003f0100ULL,
0x0001768800000009ULL, 0x00000860003f0100ULL, 0x000176a800000005ULL, 0x00000960003f0100ULL,
0x000176c800000004ULL, 0x00001090003f0100ULL, 0x000176000000000dULL, 0x00001210003f0107ULL,
0x0001768800000000ULL, 0x00001ae0003f0101ULL, 0x0000000000000049ULL, 0x00001be000040107ULL,
0x0000000000000049ULL, 0x00001c6000040101ULL, 0x0000002000000002ULL, 0x00001db0003f0101ULL,
0x000176c800000035ULL, 0x00001f30003f0109ULL, 0x000176c800000035ULL, 0x00002810003f0109ULL,
0x000176b000000056ULL, 0x000028d0003f0107ULL, 0x000176b000000056ULL, 0x000028e0003f0101ULL,
0x0001760800000051ULL, 0x00002900003f0101ULL, 0x0001760800000051ULL, 0x00002a70003f0109ULL,
0x0001760800000051ULL, 0x00002fc0003f0109ULL, 0x000176a800000036ULL, 0x00003130003f0109ULL,
0x000176a800000036ULL, 0x00004ad0003f0109ULL, 0x000176c800000034ULL, 0x00004ae0003f0101ULL,
0x0001768800000052ULL, 0x00004b10003f0101ULL, 0x0000000000000004ULL, 0x00004c80003f0109ULL,
0x0000000000000004ULL, 0x000054c0003f0109ULL, 0x000176a800000016ULL, 0x00005530003f0107ULL,
0x000176a800000016ULL, 0x00005540003f0101ULL, 0x0001762800000051ULL, 0x00005560003f0101ULL,
0x0001762800000051ULL, 0x000056d0003f0109ULL, 0x0001762800000051ULL, 0x00005bf0003f0109ULL,
0x000176b000000037ULL, 0x00005d60003f0109ULL, 0x000176b000000037ULL, 0x000074c0003f0109ULL,
0x000176c800000034ULL, 0x000074d0003f0101ULL, 0x000176900000003cULL, 0x00007500003f0101ULL,
0x0000000000000004ULL, 0x00007670003f0109ULL, 0x0000000000000004ULL, 0x00007eb0003f0109ULL,
0x000176b000000016ULL, 0x00007f20003f0107ULL, 0x000176b000000016ULL, 0x00007f30003f0101ULL,
0x0001764800000051ULL, 0x00007f50003f0101ULL, 0x0001764800000051ULL, 0x000080c0003f0109ULL,
0x0001764800000051ULL, 0x000085e0003f0109ULL, 0x000176a800000037ULL, 0x00008750003f0109ULL,
0x000176a800000037ULL, 0x00009ea0003f0109ULL, 0x000176c800000034ULL, 0x00009ec0003f0101ULL,
0x000176980000003eULL, 0x00009ef0003f0101ULL, 0x0000000000000004ULL, 0x0000a060003f0109ULL,
0x0000000000000004ULL, 0x0000a930003f0109ULL, 0x000176a800000014ULL, 0x0000a970003f0107ULL,
0x000176a800000014ULL, 0x0000a980003f0101ULL, 0x0001766800000007ULL, 0x0000a9b0003f0101ULL,
0x0001766800000007ULL, 0x0000ab20003f0109ULL, 0x0001766800000007ULL, 0x0000b030003f0109ULL,
0x000176b000000037ULL, 0x0000b1a0003f0109ULL, 0x000176b000000037ULL, 0x0000c960003f0109ULL,
0x0000000000000004ULL, 0x0000ca00003f0101ULL, 0x000176a000000004ULL, 0x0000dd90003f0101ULL,
0x000176000000000dULL, 0x0000f6c0003f0101ULL, 0x000176000000000dULL, 0x0000f880003f0109ULL,
0x000176000000000dULL, 0x0000fa60003f0109ULL, 0x000176000000000dULL, 0x0000fa80003f0101ULL,
0x000176000000000dULL, 0x0000fbf0003f0109ULL, 0x000176000000000dULL, 0x00012f70003f0109ULL,
0x000176880000000bULL, 0x00013140003f0101ULL, 0x000176880000000bULL, 0x000132b0003f0109ULL,
0x000176880000000bULL, 0x00015670003f0109ULL, 0x000176080000000fULL, 0x00015680003f0101ULL,
0x000176100000000fULL, 0x00015690003f0101ULL, 0x000176180000000fULL, 0x000156a0003f0101ULL,
0x000176200000000fULL, 0x00053803003f0101ULL, 0x0000d44000201c04ULL, 0x0000d7300000d470ULL,
0x0000db200000d920ULL, 0x0000fc200000dcd0ULL, 0x000c0504000156c0ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0068190300000000ULL, 0x0000001800080a04ULL, 0x0000000000680210ULL,
0x00000000000000bcULL, 0x0000001700000002ULL, 0x00000000000156d0ULL, 0x0000000000000044ULL,
0x0000001700000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001700000002ULL,
0x0000000000000000ULL, 0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000077919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fe20000000a00ULL,
0x000000ff0200720cULL, 0x004fca0003f45070ULL, 0x00008500ff027b82ULL, 0x000ea20000000800ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff042b82ULL, 0x000f220000000a00ULL,
0x0000000107032836ULL, 0x008fe40000000000ULL, 0x0000000407082825ULL, 0x010fc800078e0004ULL,
0x0000000403042825ULL, 0x000fe200078e0004ULL, 0x0000000608062981ULL, 0x000728000c1e1900ULL,
0x0000000604032981ULL, 0x000b22000c1e1900ULL, 0x0000000200007306ULL, 0x004ea20000209000ULL,
0x00000400ff0c7b82ULL, 0x000f620000000800ULL, 0x000000ff0200720cULL, 0x000fe20003f65070ULL,
0x0000010000047ab9ULL, 0x000fe20000000800ULL, 0x0000046000007945ULL, 0x000fe20003800000ULL,
0x0000000000097919ULL, 0x008ee60000002100ULL, 0x0000000000007308ULL, 0x004ea40000001000ULL,
0x0ffffffe000a7836ULL, 0x004fcc0000000000ULL, 0x0000000a000b7305ULL, 0x000562000021f000ULL,
0x00000005ff407819ULL, 0x008fe20000011609ULL, 0x000000ffff0a7224ULL, 0x004fca00078e00ffULL,
0x00001fff40407589ULL, 0x000f2200000e0000ULL, 0x000000ffff0d7224ULL, 0x022fc800078e0a0bULL,
0x000000020d0d7224ULL, 0x000fc800078e02ffULL, 0x0000000d0b0b7227ULL, 0x000fe400078e000aULL,
0x00000000000d7919ULL, 0x000e680000002200ULL, 0x0000000c0b0b7227ULL, 0x000fe200078e00ffULL,
0x00000000000a7919ULL, 0x000ea60000002600ULL, 0x000000ffff057224ULL, 0x000fc800078e0a0bULL,
0x0000000502057224ULL, 0x000fe400078e020cULL, 0x00000000000c7919ULL, 0x000e660000002300ULL,
0x000000020500720cULL, 0x000fda0003f06070ULL, 0x0000000105050824ULL, 0x000fe400078e0a02ULL,
0x000000010b0b0836ULL, 0x000fc60000000000ULL, 0x000000020500720cULL, 0x000fda0003f26070ULL,
0x000000010b0b1836ULL, 0x000fe20000000000ULL, 0x00000002ff0bb212ULL, 0x000fc800078e33ffULL,
0x0000000b00007306ULL, 0x000ee20000209000ULL, 0x000000ff0b00720cULL, 0x000fce0003f65070ULL,
0x0000000000007308ULL, 0x008ee40000001000ULL, 0x0ffffffe00047836ULL, 0x008fe40000000000ULL,
0x000000040c007c24ULL, 0x002fe2000f8e020dULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000400057305ULL, 0x0002e4000021f000ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000050b087224ULL, 0x008fc800078e02ffULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a08ULL,
0x00008400ff08ab82ULL, 0x000e640000000800ULL, 0x0000000f05057227ULL, 0x000fc800078e0004ULL,
0x0000000400047c24ULL, 0x000fe4000f8e0209ULL, 0x0000000a05437227ULL, 0x004fc600078e00ffULL,
0x0000007f0400780cULL, 0x040fe20003fa4070ULL, 0x000000ffff057224ULL, 0x000fe200078e0a43ULL,
0x000000030400780cULL, 0x000fc60003f84070ULL, 0x000000050b007224ULL, 0x000fca00078e020aULL,
0x0000000b0000720cULL, 0x000fc60003f06070ULL, 0x00000000000ed919ULL, 0x000eb40000008800ULL,
0x0000000100000824ULL, 0x000fc400078e0a0bULL, 0x0000000143430836ULL, 0x000fe20000000000ULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x0000000b0000720cULL, 0x000fda0003f26070ULL,
0x0000000143431836ULL, 0x000fe20000000000ULL, 0x0000000bff43b212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x040fe40003f24070ULL, 0x000000010400780cULL, 0x000fe20003f64070ULL,
0x000000ffff417224ULL, 0x000fc800078e0a43ULL, 0x000000410b417224ULL, 0x000fe400078e020aULL,
0xff317217ff0ad424ULL, 0x000fe400078e00ffULL, 0x0000000103002824ULL, 0x010fe200078e0a06ULL,
0x000004000003d802ULL, 0x000fc80000000f00ULL, 0x000006540e05d816ULL, 0x004fe20000000003ULL,
0x00008400ff00ab82ULL, 0x000ea20000000800ULL, 0x00001fff0c037589ULL, 0x00066600000e0000ULL,
0x000000040405d824ULL, 0x000fe200078e0205ULL, 0x0000000000240947ULL, 0x002fec0003800000ULL,
0x00000000000579c3ULL, 0x000f220000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x010fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000f340000000000ULL, 0x01760008043f75b2ULL, 0x0009240008000100ULL,
0x0000000000007918ULL, 0x01cfe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000f220000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x010fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404097c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000090812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000f240000000000ULL,
0x01760804083f75b2ULL, 0x0009300008000100ULL, 0xfffffffd00e81947ULL, 0x01cfea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404097c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000090812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000f240000000000ULL, 0x01768804083f75b2ULL, 0x0009300008000100ULL,
0xfffffffd00e81947ULL, 0x01cfea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0174000a0500d388ULL, 0x0007e20000000800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000001041417824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000404057c11ULL, 0x008fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000050912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x0176a804093f75b2ULL, 0x0006f00008000100ULL,
0xfffffffd00e81947ULL, 0x00cfea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x008fca0000000000ULL, 0x00000000040912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x0176c804093f75b2ULL, 0x0006f00008000100ULL,
0xfffffffd00e81947ULL, 0x00cfea000393ffffULL, 0x0000000800047c24ULL, 0x004fe2000f8e02ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0a41ULL, 0x000000410400720cULL, 0x000fe20003f06070ULL,
0x000000080706a224ULL, 0x002fc400078e02ffULL, 0x0000000802117c24ULL, 0x000fe2000f8e02ffULL,
0x00000010040f7446ULL, 0x000fe2000380000fULL, 0x0000000403047824ULL, 0x000fe400078e0240ULL,
0x00000011060e7224ULL, 0x000fe200078e02ffULL, 0x000000ff0f0f7207ULL, 0x000fe20000000000ULL,
0x0000000204087824ULL, 0x000fe400078e00ffULL, 0x0000000843137c24ULL, 0x000fe2000f8e020eULL,
0x000000100f00780cULL, 0x000fda0003f05270ULL, 0x0000000000c08947ULL, 0x000fea0003800000ULL,
0x0000000800097d06ULL, 0x000e620008209000ULL, 0x00000000000c7919ULL, 0x008ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00000008ff007c0cULL, 0x000fe2000bf45070ULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000107919ULL, 0x000ee60000008800ULL,
0x0000000900097308ULL, 0x002e640000001000ULL, 0x0ffffffe09057836ULL, 0x002fe20000000000ULL,
0x00000004ff0b7819ULL, 0x004fca000001160cULL, 0x0000000500057305ULL, 0x000e62000021f000ULL,
0x00000001080a7824ULL, 0x000fe400078e020bULL, 0x000000ffff0d7224ULL, 0x002fc800078e0a05ULL,
0x000000080d0d7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000d050d7227ULL, 0x000fc800078e0004ULL,
0x0000000141047824ULL, 0x000fc800078e020aULL, 0x000000040d0d7227ULL, 0x000fc800078e00ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a0dULL, 0x0000000809057c24ULL, 0x000fe2000f8e0204ULL,
0x000000080f097248ULL, 0x000fc80007fe0000ULL, 0x0000000805007c0cULL, 0x000fda000bf06070ULL,
0x8000000805050c36ULL, 0x000fe40008000000ULL, 0x000000010d0d0836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x000000010d0d1836ULL, 0x000fe20000000000ULL,
0x00000008ff0dac12ULL, 0x000fca000f8e33ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a0dULL,
0x0000000805047c24ULL, 0x000fe4000f8e0204ULL, 0x000000100c057824ULL, 0x000fe400078e00ffULL,
0x0000000113047824ULL, 0x000fc800078e0204ULL, 0x000000110d0d7224ULL, 0x000fe400078e0204ULL,
0x0000000109047824ULL, 0x000fe400078e0a08ULL, 0x000001000d087825ULL, 0x000fe200078e00ffULL,
0x000000f0050d7812ULL, 0x000fe400078ec0ffULL, 0x000000040b00720cULL, 0x000fe20003f06070ULL,
0x000000010a047824ULL, 0x040fe200078e020cULL, 0x00000400000b7802ULL, 0x000fe20000000f00ULL,
0x000000100a117824ULL, 0x000fe200078e00ffULL, 0x0000000d08087212ULL, 0x000fc400078efcffULL,
0x00000654100d7816ULL, 0x008fe4000000000bULL, 0xfffffff011047812ULL, 0x000fe400078ee204ULL,
0x0000000408087c10ULL, 0x000fc6000ff3e0ffULL, 0x00000010040b7824ULL, 0x000fe200078e020dULL,
0x0000000509097c10ULL, 0x000fca0008ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x0000000000ac7947ULL, 0x000fea0003800000ULL,
0x0000000800097d06ULL, 0x000e620008209000ULL, 0x00000000000c7919ULL, 0x008ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00000008ff007c0cULL, 0x000fe2000bf45070ULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000107919ULL, 0x000ee60000008800ULL,
0x0000000900097308ULL, 0x002e640000001000ULL, 0x0ffffffe090b7836ULL, 0x002fe20000000000ULL,
0x000000080c0a7211ULL, 0x004fca00078fe0ffULL, 0x0000000b00057305ULL, 0x000e64000021f000ULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a05ULL, 0x000000080d0d7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000d05057227ULL, 0x000fe200078e0004ULL, 0x00000400000d7802ULL, 0x000fc60000000f00ULL,
0x0000000141047824ULL, 0x000fe200078e020aULL, 0x00000654100d7816ULL, 0x008fc6000000000dULL,
0x0000000405057227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a05ULL,
0x0000000809087c24ULL, 0x000fca000f8e0204ULL, 0x0000000808007c0cULL, 0x000fda000bf06070ULL,
0x8000000808080c36ULL, 0x000fe40008000000ULL, 0x0000000105050836ULL, 0x000fc60000000000ULL,
0x0000000808007c0cULL, 0x000fda000bf26070ULL, 0x0000000105051836ULL, 0x000fe20000000000ULL,
0x00000008ff05ac12ULL, 0x000fca000f8e33ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a05ULL,
0x0000000809047c24ULL, 0x000fc8000f8e0204ULL, 0x0000000113047824ULL, 0x000fc800078e0204ULL,
0x0000001105047224ULL, 0x000fe400078e0204ULL, 0x000000100c057824ULL, 0x000fe400078e00ffULL,
0x0000010004087825ULL, 0x000fc600078e00ffULL, 0x000000f0050b7812ULL, 0x000fe200078ec0ffULL,
0x000000010a047824ULL, 0x000fc600078e020cULL, 0x0000000b08087212ULL, 0x000fe200078efcffULL,
0x000000100a0b7824ULL, 0x000fc600078e00ffULL, 0x0000000408087c10ULL, 0x000fe4000ff1e0ffULL,
0xfffffff00b047812ULL, 0x000fe400078ee204ULL, 0x0000000509097c10ULL, 0x000fc600087fe4ffULL,
0x00000010040b7824ULL, 0x000fca00078e020dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e4000b901c46ULL, 0x000000000d0472caULL, 0x000fe200000e0000ULL,
0x00009400ff087b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0001760004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000407087825ULL, 0x002fe200078e0008ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000006083b7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x0000003f3b3a7836ULL, 0x004fe40000000000ULL,
0x000000ff3b037836ULL, 0x000fc60000000000ULL, 0x00000006ff3a7819ULL, 0x000fe4000001163aULL,
0x00000008ff397819ULL, 0x000fca0000011603ULL, 0x000000c800e08947ULL, 0x000fea0003800000ULL,
0x00000002ff0a7819ULL, 0x000fe20000011640ULL, 0x00000004ff137424ULL, 0x000fc600078e00ffULL,
0x03ffffff0a097812ULL, 0x000fc800078ec0ffULL, 0x0000003a0900720cULL, 0x000fda0003f06070ULL,
0x00009600ff0b8b82ULL, 0x000e620000000800ULL, 0x0000000207008824ULL, 0x000fce00078e00ffULL,
0x00009200ff108b82ULL, 0x000ea20000000a00ULL, 0x0000000b00008224ULL, 0x002fc800078e020bULL,
0x00000001090b8824ULL, 0x000fe400078e0200ULL, 0x0000000840007824ULL, 0x000fe400078e020dULL,
0x000000040b108825ULL, 0x004fe400078e0010ULL, 0x0176881300ff79a7ULL, 0x0003e4000850003fULL,
0xffffffffff0b7424ULL, 0x000fcc00078e00ffULL, 0x00000006100b8981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0300780cULL, 0x000fe40003f04070ULL, 0x00000001ff387819ULL, 0x000fe40000011640ULL,
0x0000000140007812ULL, 0x002fe200078ec0ffULL, 0x00009000ff127b82ULL, 0x000e640000000a00ULL,
0x0000002038087824ULL, 0x000fe400078e00ffULL, 0x000000020b0b7224ULL, 0x004fc800078e02ffULL,
0x000000400b157824ULL, 0x000fe400078e00ffULL, 0x00000040430b7824ULL, 0x000fe400078e00ffULL,
0x0000008015027825ULL, 0x002fc600078e0012ULL, 0x000000200b047812ULL, 0x000fe200078ef808ULL,
0x0000000000fc0947ULL, 0x000fec0003800000ULL, 0x000000083b117248ULL, 0x000fe20007fe0000ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000003ff107819ULL, 0x000fc6000001160cULL,
0x0000000111117824ULL, 0x000fe400078e0a08ULL, 0x0000000106137824ULL, 0x000fe400078e0210ULL,
0x0000000410147836ULL, 0x000fe20000000000ULL, 0x0000000611117248ULL, 0x000fe20007fe0000ULL,
0x0000000113127824ULL, 0x040fe400078e020cULL, 0x0000000813157824ULL, 0x000fe400078e00ffULL,
0x0000000111117824ULL, 0x000fc400078e0a06ULL, 0x0000000810167836ULL, 0x000fe20000000000ULL,
0xfffffff815187812ULL, 0x000fe200078ee212ULL, 0x0000000106157824ULL, 0x000fe200078e0214ULL,
0x000000111400720cULL, 0x080fe20003f46070ULL, 0x0000000c10147836ULL, 0x000fe20000000000ULL,
0x000000111000720cULL, 0x080fe20003f66070ULL, 0x0000000104107824ULL, 0x000fe200078e0213ULL,
0x000000111600720cULL, 0x080fe20003f26070ULL, 0x0000000115127824ULL, 0x040fe200078e020cULL,
0x000000111400720cULL, 0x000fe20003f06070ULL, 0x0000000815197824ULL, 0x000fc400078e00ffULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000000106137824ULL, 0x040fe400078e0216ULL,
0x0000000106177824ULL, 0x000fe200078e0214ULL, 0xfffffff819067812ULL, 0x000fe200078ee212ULL,
0x0000000104127824ULL, 0x040fe200078e0213ULL, 0x0000007010197812ULL, 0x000fe200078ef805ULL,
0x00000001041b7824ULL, 0x000fe400078e0217ULL, 0x0000000117107824ULL, 0x040fe200078e020cULL,
0x0000001902167210ULL, 0x000fe20007f9e0ffULL, 0x0000000817177824ULL, 0x000fc400078e00ffULL,
0x0000000113147824ULL, 0x040fe400078e020cULL, 0x0000000813137824ULL, 0x000fe200078e00ffULL,
0xfffffff8171c7812ULL, 0x000fe200078ee210ULL, 0x0000000104157824ULL, 0x000fe400078e0215ULL,
0x0000000103177824ULL, 0x000fe200020e0611ULL, 0xfffffff8131a7812ULL, 0x000fe200078ee214ULL,
0x0000008015107825ULL, 0x000fc800078e00ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000007010237812ULL, 0x000fc600078ef805ULL, 0x000000801b147825ULL, 0x000fe200078e00ffULL,
0x0000007012217812ULL, 0x000fc600078ef805ULL, 0x0000200038047824ULL, 0x000fe200078e020dULL,
0x0000007014057812ULL, 0x000fe400078ef805ULL, 0x0000002102107210ULL, 0x000fe20007fbe0ffULL,
0x0001300004197836ULL, 0x000fe20000000000ULL, 0x0000002302047210ULL, 0x000fe40007f9e0ffULL,
0x0000000502027210ULL, 0x000fe20007fde0ffULL, 0x00000010181b7824ULL, 0x100fe400078e0219ULL,
0x00000010061d7824ULL, 0x000fc400078e0219ULL, 0x0000000103057824ULL, 0x040fe200020e0611ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000161b7faeULL, 0x0003e2000d901c46ULL,
0x000000101a1f7824ULL, 0x000fe400078e0219ULL, 0x0000000103117824ULL, 0x040fe200028e0613ULL,
0x00000000041d7faeULL, 0x0003e2000d101c46ULL, 0x000000101c197824ULL, 0x000fe400078e0219ULL,
0x0000000103037824ULL, 0x000fe200030e0615ULL, 0x00000000101f7faeULL, 0x0003e8000c901c46ULL,
0x0000000002197faeULL, 0x0003e2000c101c46ULL, 0x0000000000c87947ULL, 0x000fea0003800000ULL,
0x0000001000117824ULL, 0x000fca00078e00ffULL, 0x000000110c117211ULL, 0x000fca00078fe8ffULL,
0x0000000411137836ULL, 0x000fe40000000000ULL, 0x0000000111067824ULL, 0x140fe400078e020cULL,
0x0000000811157824ULL, 0x000fe400078e00ffULL, 0x0000000113127824ULL, 0x040fe400078e020cULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0xfffffff815067812ULL, 0x000fe200078ee206ULL,
0x0000000104107824ULL, 0x000fc400078e0211ULL, 0x0000000811157836ULL, 0x000fe20000000000ULL,
0xfffffff817187812ULL, 0x000fe200078ee212ULL, 0x0000000c11177836ULL, 0x000fe40000000000ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000000104147824ULL, 0x040fe200078e0217ULL,
0x0000007010197812ULL, 0x000fe200078ef805ULL, 0x0000000117107824ULL, 0x140fe400078e020cULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0x0000001902167210ULL, 0x000fe20007f1e0ffULL,
0x0000000104137824ULL, 0x040fe400078e0213ULL, 0x0000000104127824ULL, 0x000fe200078e0215ULL,
0xfffffff8171a7812ULL, 0x000fe200078ee210ULL, 0x0000000115047824ULL, 0x000fc400078e020cULL,
0x00000008151b7824ULL, 0x000fe400078e00ffULL, 0x0000200038157824ULL, 0x000fe400078e020dULL,
0x0000000103177824ULL, 0x000fe200000e0611ULL, 0xfffffff81b047812ULL, 0x000fe200078ee204ULL,
0x0000008013107825ULL, 0x000fc800078e00ffULL, 0x0001300015237836ULL, 0x000fe20000000000ULL,
0x0000007010217812ULL, 0x000fe200078ef805ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x00000070121f7812ULL, 0x000fc600078ef805ULL,
0x00000010041d7824ULL, 0x100fe200078e0223ULL, 0x0000007014057812ULL, 0x000fe200078ef805ULL,
0x0000001006197824ULL, 0x100fe200078e0223ULL, 0x0000002102047210ULL, 0x000fe20007f1e0ffULL,
0x00000010181b7824ULL, 0x100fe200078e0223ULL, 0x0000001f02107210ULL, 0x000fe20007f3e0ffULL,
0x000000101a1f7824ULL, 0x000fe200078e0223ULL, 0x0000000502027210ULL, 0x000fe20007f5e0ffULL,
0x0000000103057824ULL, 0x040fe200000e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016197faeULL, 0x0003e2000b901c46ULL, 0x0000000103117824ULL, 0x000fc400008e0613ULL,
0x0000000103037824ULL, 0x000fe200010e0615ULL, 0x00000000041b7faeULL, 0x0003e8000b901c46ULL,
0x00000000101d7faeULL, 0x0003e8000b901c46ULL, 0x00000000021f7faeULL, 0x0003e4000b901c46ULL,
0x0000000109097836ULL, 0x000fe40000000000ULL, 0xffffffffff537424ULL, 0x000fc600078e00ffULL,
0x0000003a0900720cULL, 0x000fe20003f06070ULL, 0x000176a80d497836ULL, 0x000fe20000000000ULL,
0x00000000380472caULL, 0x000fd600000e0000ULL, 0x00009600ff058b82ULL, 0x002e620000000800ULL,
0x00000000490572caULL, 0x000fe200000e0000ULL, 0x0000000207048824ULL, 0x000fcc00078e00ffULL,
0x00009200ff028b82ULL, 0x000ea20000000a00ULL, 0x0000000404047899ULL, 0x000fca000800063fULL,
0x0000000504057290ULL, 0x000fe2000fffe03fULL, 0x0000000504048224ULL, 0x002fc800078e0205ULL,
0x0000000104058824ULL, 0x000fc800078e0209ULL, 0x0000000405028825ULL, 0x004fe200078e0002ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000602538981ULL, 0x000322000c1e1900ULL,
0x000000ff3900720cULL, 0x000fe20003f05270ULL, 0x00000001ff047424ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x000000ffff547224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff257224ULL, 0x000fe400078e00ffULL,
0x0000000838027824ULL, 0x002fe200078e0249ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000004494879a7ULL, 0x0002a20008500004ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00002004020279a7ULL, 0x0002e2000850003fULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x000000ac00748947ULL, 0x000fec0003800000ULL,
0x00009600ff137b82ULL, 0x000f620000000800ULL, 0x00000004ff057e24ULL, 0x000fe4000f8e00ffULL,
0x000000200a027824ULL, 0x008fe400078e020dULL, 0x0000000207067824ULL, 0x000fe200078e00ffULL,
0x0000001005057812ULL, 0x000fe200078ec0ffULL, 0x000000ffff347224ULL, 0x000fe400078e0003ULL,
0xff317217ff557424ULL, 0x000fe400078e00ffULL, 0x0000000102057824ULL, 0x000fc800078e0205ULL,
0x0000000800077824ULL, 0x000fe400078e0205ULL, 0x000000ffff057224ULL, 0x000fe400078e00ffULL,
0x0000001306067224ULL, 0x022fe400078e0213ULL, 0x000000ffff137224ULL, 0x000fce00078e00ffULL,
0x000000ffff457224ULL, 0x000fce00078e0009ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x0000000440047824ULL, 0x000fca00078e00ffULL, 0xfffffff804047812ULL, 0x000fca00078ec0ffULL,
0x000000010d357824ULL, 0x000fc800078e0204ULL, 0x0176c834350075a7ULL, 0x000e62000800017fULL,
0x000176c835047836ULL, 0x000fe20000000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176c834350075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009000ff147b82ULL, 0x000e620000000a00ULL,
0x0000001040167824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x0000000105367836ULL, 0x000fe40000000000ULL, 0x0000000453537c24ULL, 0x010fe2000f8e02ffULL,
0xffffffe016347812ULL, 0x000fe400078ec0ffULL, 0x000000393600720cULL, 0x000fe20003f26070ULL,
0x0000004053537824ULL, 0x000fe400078e00ffULL, 0x0000010005347824ULL, 0x000fc800078e0234ULL,
0x0000004034357836ULL, 0x000fca0000000000ULL, 0x0000002035347812ULL, 0x000fe200078ec0ffULL,
0x0000008053147825ULL, 0x002fc800078e0014ULL, 0x000000010b3c7824ULL, 0x000fe200078e0234ULL,
0x0000000400049947ULL, 0x000fec0003800000ULL, 0x0000001016177812ULL, 0x000fe200078ec0ffULL,
0x000000100c427824ULL, 0x000fe200078e00ffULL, 0x000000353b167248ULL, 0x000fe40007fe0000ULL,
0x00000003ff367819ULL, 0x100fe4000001160cULL, 0x00000070424d7812ULL, 0x000fe200078ec0ffULL,
0x0000000116167824ULL, 0x000fe400078e0a35ULL, 0x0000000136357824ULL, 0x000fe400078e0217ULL,
0x00000008363d7836ULL, 0x000fe20000000000ULL, 0x0000001716167248ULL, 0x000fe20007fe0000ULL,
0x0000000135347824ULL, 0x000fc400078e020cULL, 0x0000000835377824ULL, 0x000fe400078e00ffULL,
0x0000000116167824ULL, 0x000fc600078e0a17ULL, 0xfffffff8373e7812ULL, 0x000fe200078ee234ULL,
0x0000000436377836ULL, 0x000fe20000000000ULL, 0x000000163600720cULL, 0x080fe20003f86070ULL,
0x0000000c36367836ULL, 0x000fe20000000000ULL, 0x000000163d00720cULL, 0x0c0fe20003f46070ULL,
0x000000013d3d7824ULL, 0x100fe200078e0217ULL, 0x000000163700720cULL, 0x0c0fe20003f66070ULL,
0x0000000137377824ULL, 0x100fe200078e0217ULL, 0x000000163600720cULL, 0x040fe20003f06070ULL,
0x00000001363f7824ULL, 0x000fe400078e0217ULL, 0x000000013c167824ULL, 0x000fc400078e0235ULL,
0x000000013c367824ULL, 0x040fe400078e0237ULL, 0x000000013c357824ULL, 0x040fe400078e023dULL,
0x000000013c467824ULL, 0x000fe400078e023fULL, 0x000000013d3c7824ULL, 0x140fe400078e020cULL,
0x000000083d4b7824ULL, 0x000fe400078e00ffULL, 0x0000000137347824ULL, 0x000fc400078e020cULL,
0x0000000837477824ULL, 0x000fe200078e00ffULL, 0xfffffff84b447812ULL, 0x000fe200078ee23cULL,
0x000000013f3d7824ULL, 0x040fe400078e020cULL, 0x000000083f487824ULL, 0x004fe200078e00ffULL,
0xfffffff847427812ULL, 0x000fe200078ee234ULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff848487812ULL, 0x000fe200078ee23dULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000004d363d7212ULL, 0x000fc600078efcffULL, 0x0000008035347825ULL, 0x000fe200078e00ffULL,
0x0000004d163f7212ULL, 0x080fe400078efcffULL, 0x0000003d14367210ULL, 0x000fe20007fde0ffULL,
0x00000080463c7825ULL, 0x000fe200078e00ffULL, 0x0000003f14167210ULL, 0x000fe40007fbe0ffULL,
0x0000004d344f7212ULL, 0x080fe200078efcffULL, 0x0000200038477824ULL, 0x000fe200078e020dULL,
0x0000004d3c4d7212ULL, 0x000fe200078efcffULL, 0x0000000115177824ULL, 0x000fe200028e0617ULL,
0x0000004f14347210ULL, 0x000fe20007fbe0ffULL, 0x00014000473f7836ULL, 0x000fc40000000000ULL,
0x0000000115377824ULL, 0x040fe200030e0637ULL, 0x0000004d14147210ULL, 0x000fe20007fde0ffULL,
0x000000103e477824ULL, 0x100fe400078e023fULL, 0x00000010424b7824ULL, 0x100fe400078e023fULL,
0x00000010444d7824ULL, 0x000fe200078e023fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016477faeULL, 0x0003e2000e101c46ULL, 0x0000000115357824ULL, 0x040fe400028e0635ULL,
0x00000010483f7824ULL, 0x000fe200078e023fULL, 0x00000000364b7faeULL, 0x0003e2000d901c46ULL,
0x0000000115157824ULL, 0x000fc600030e063dULL, 0x00000000344d7faeULL, 0x0003e8000d101c46ULL,
0x00000000143f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000d07947ULL, 0x000fea0003800000ULL,
0x0000001016177812ULL, 0x000fe200078ec0ffULL, 0x000000100c367824ULL, 0x000fc600078e00ffULL,
0x000000170c177211ULL, 0x000fe400078fe8ffULL, 0x00000070364d7812ULL, 0x000fc600078ec0ffULL,
0x0000000417357836ULL, 0x000fe40000000000ULL, 0x0000000117167824ULL, 0x140fe400078e020cULL,
0x0000000817377824ULL, 0x000fe400078e00ffULL, 0x0000000135347824ULL, 0x040fe400078e020cULL,
0x00000008353d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8373e7812ULL, 0x000fe200078ee216ULL,
0x000000013c167824ULL, 0x000fc400078e0217ULL, 0x0000000817377836ULL, 0x000fe20000000000ULL,
0xfffffff83d427812ULL, 0x000fe200078ee234ULL, 0x0000000c173d7836ULL, 0x000fe40000000000ULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x000000013c367824ULL, 0x000fe200078e0237ULL,
0x0000004d163f7212ULL, 0x000fe200078efcffULL, 0x0000000137347824ULL, 0x140fe400078e020cULL,
0x0000000837477824ULL, 0x000fe200078e00ffULL, 0x0000003f14167210ULL, 0x000fe20007f1e0ffULL,
0x000000013c357824ULL, 0x000fe400078e0235ULL, 0x000000013d377824ULL, 0x040fe200078e020cULL,
0xfffffff847447812ULL, 0x000fe200078ee234ULL, 0x000000083d467824ULL, 0x000fc400078e00ffULL,
0x000000013c3c7824ULL, 0x000fe400078e023dULL, 0x00002000383d7824ULL, 0x000fe200078e020dULL,
0xfffffff846467812ULL, 0x000fe200078ee237ULL, 0x0000008035347825ULL, 0x000fc800078e00ffULL,
0x000140003d537836ULL, 0x000fe20000000000ULL, 0x0000004d34517212ULL, 0x000fe200078efcffULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000004d364f7212ULL, 0x000fc600078efcffULL, 0x0000000115177824ULL, 0x040fe200000e0617ULL,
0x0000004d3c4d7212ULL, 0x000fe200078efcffULL, 0x000000103e3f7824ULL, 0x100fe200078e0253ULL,
0x0000005114347210ULL, 0x000fe20007f1e0ffULL, 0x0000001042477824ULL, 0x100fe200078e0253ULL,
0x0000004f14367210ULL, 0x000fe20007f5e0ffULL, 0x00000010444b7824ULL, 0x000fe200078e0253ULL,
0x0000004d14147210ULL, 0x000fe20007f7e0ffULL, 0x0000000115357824ULL, 0x040fe200000e0635ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000163f7faeULL, 0x0003e2000b901c46ULL,
0x0000000115377824ULL, 0x000fc400010e0637ULL, 0x00000010464d7824ULL, 0x000fe200078e0253ULL,
0x0000000034477faeULL, 0x0003e2000b901c46ULL, 0x0000000115157824ULL, 0x000fc600018e063dULL,
0x00000000364b7faeULL, 0x0003e8000b901c46ULL, 0x00000000144d7faeULL, 0x0003e4000b901c46ULL,
0x0000000109177836ULL, 0x002fe40000000000ULL, 0xffffffffff4c7424ULL, 0x000fc600078e00ffULL,
0x0000003a1700720cULL, 0x000fe20003f06070ULL, 0x0000000840167824ULL, 0x000fca00078e00ffULL,
0xfffffff016347812ULL, 0x000fca00078ec0ffULL, 0x000000010d567824ULL, 0x000fe400078e0234ULL,
0x00009200ff148b82ULL, 0x000e620000000a00ULL, 0x0000000106178824ULL, 0x000fe400078e0217ULL,
0x00000000560472caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000176b004047890ULL, 0x000fe2000fffe03fULL, 0x0000000417148825ULL, 0x002fd000078e0014ULL,
0x00000000ff0079b0ULL, 0x000fe80008000a44ULL, 0x00000006144c8981ULL, 0x000322000c1e1900ULL,
0xffffffe016347812ULL, 0x040fe400078ec0ffULL, 0x0000001016177812ULL, 0x040fe400078ec0ffULL,
0x0000000816167812ULL, 0x000fe400078ec0ffULL, 0x0000000d17177210ULL, 0x000fe20007ffe034ULL,
0x00000001ff347424ULL, 0x000fc800078e00ffULL, 0x0000000117517824ULL, 0x000fe200078e0216ULL,
0x0000000000007918ULL, 0x002fcc0000000000ULL, 0x0176b034565679a7ULL, 0x0002e4000850003fULL,
0x01760834513479a7ULL, 0x0022a4000850003fULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x01760835510075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01760835510075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x000000100c447824ULL, 0x000fe200078e00ffULL,
0x00000001ff477819ULL, 0x000fe2000001160cULL, 0x0000002040147824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000007044447812ULL, 0x000fe400078ec0ffULL,
0xffffff8014147812ULL, 0x000fe400078ec0ffULL, 0x0000000c47477812ULL, 0x000fe400078ec0ffULL,
0x0000000d44147210ULL, 0x000fca0007ffe014ULL, 0x0000000114147824ULL, 0x000fca00078e0247ULL,
0x0170000014167984ULL, 0x000ea80000000800ULL, 0x0172000014177984ULL, 0x000b620000000800ULL,
0x000000551600720bULL, 0x004fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15357812ULL, 0x000fda000780c0ffULL, 0x0000000000fc8947ULL, 0x02afea0003800000ULL,
0x000000400a00720cULL, 0x000fe40003f45270ULL, 0x000000551600720bULL, 0x0c0fe40003f14000ULL,
0x0000005516377209ULL, 0x000fd20007810000ULL, 0x000000804014a824ULL, 0x000fe400078e020dULL,
0x0000000000347806ULL, 0x000fc600000e0100ULL, 0x000000144714a210ULL, 0x000fe40007ffe044ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400371400a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x8000003755557221ULL, 0x000fe20000010000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b55557820ULL, 0x000fcc0000410000ULL,
0x0000005500557308ULL, 0x000e680000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x000fcc000001160cULL, 0x00001f1455147589ULL, 0x002e6400000e0000ULL,
0x0000001418187220ULL, 0x082fe20000410000ULL, 0x0000001419197220ULL, 0x080fe20000410000ULL,
0x0000001428287220ULL, 0x080fe20000410000ULL, 0x0000001429297220ULL, 0x080fe20000410000ULL,
0x000000142c2c7220ULL, 0x080fe20000410000ULL, 0x000000142d2d7220ULL, 0x080fe20000410000ULL,
0x0000001430307220ULL, 0x080fe20000410000ULL, 0x0000001431317220ULL, 0x080fe20000410000ULL,
0x0000001424247220ULL, 0x080fe20000410000ULL, 0x0000001425257220ULL, 0x080fe20000410000ULL,
0x0000001420207220ULL, 0x080fe20000410000ULL, 0x0000001421217220ULL, 0x080fe20000410000ULL,
0x000000141c1c7220ULL, 0x080fe20000410000ULL, 0x000000141d1d7220ULL, 0x080fe20000410000ULL,
0x0000001410107220ULL, 0x080fe20000410000ULL, 0x0000001411117220ULL, 0x000fce0000410000ULL,
0x0000005554547220ULL, 0x002fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080c147811ULL, 0x000fcc00078ff0ffULL, 0x00001f1455147589ULL, 0x000e6400000e0000ULL,
0x000000141a1a7220ULL, 0x082fe20000410000ULL, 0x000000141b1b7220ULL, 0x080fe20000410000ULL,
0x000000142a2a7220ULL, 0x080fe20000410000ULL, 0x000000142b2b7220ULL, 0x080fe20000410000ULL,
0x000000142e2e7220ULL, 0x080fe20000410000ULL, 0x000000142f2f7220ULL, 0x080fe20000410000ULL,
0x0000001432327220ULL, 0x080fe20000410000ULL, 0x0000001433337220ULL, 0x080fe20000410000ULL,
0x0000001426267220ULL, 0x080fe20000410000ULL, 0x0000001427277220ULL, 0x080fe20000410000ULL,
0x0000001422227220ULL, 0x080fe20000410000ULL, 0x0000001423237220ULL, 0x080fe20000410000ULL,
0x000000141e1e7220ULL, 0x080fe20000410000ULL, 0x000000141f1f7220ULL, 0x080fe20000410000ULL,
0x0000001412127220ULL, 0x080fe20000410000ULL, 0x0000001413137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x000000ffff557224ULL, 0x000fd400078e0037ULL, 0x8000003716160221ULL, 0x100fe20000010000ULL,
0x000000ffff550224ULL, 0x000fe200078e0037ULL, 0x00007610ff340816ULL, 0x000fe40000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000e640000000800ULL,
0x0000000217170220ULL, 0x002fce0000410000ULL, 0x0000005417547221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x0000000840167824ULL, 0x000fca00078e00ffULL,
0xfffffff016167812ULL, 0x000fca00078ec0ffULL, 0x000000010d367824ULL, 0x000fc800078e0216ULL,
0x0176a849360075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff377224ULL, 0x000fce00078e00ffULL, 0x000000103700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000137377836ULL, 0x000fce0000000000ULL, 0x0176a849360075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034157816ULL, 0x000fe200000000ffULL,
0x0000000240527824ULL, 0x000fe200078e00ffULL, 0x000000070c4a7812ULL, 0x000fe200078ec0ffULL,
0x0000000440587824ULL, 0x040fe200078e00ffULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x0000020040147824ULL, 0x000fe200078e00ffULL, 0x0000000452157812ULL, 0x000fe200078ec0ffULL,
0x00002000384e7824ULL, 0x000fe200078e020dULL, 0x000000084a537812ULL, 0x000fe400078ef80cULL,
0x000000150c427211ULL, 0x040fe200078fe0ffULL, 0x000130004e487836ULL, 0x000fe20000000000ULL,
0x000000080c497812ULL, 0x000fe200078ec0ffULL, 0x0000000853157824ULL, 0x040fe200078e00ffULL,
0x00000004ff597819ULL, 0x000fe2000001160cULL, 0x0000000153427824ULL, 0x000fe200078e0242ULL,
0x0000000458587812ULL, 0x000fc400078ec0ffULL, 0x0000004a493d7212ULL, 0x000fe400078efcffULL,
0xfffff80014147812ULL, 0x000fe200078ec0ffULL, 0x0000000159587824ULL, 0x000fe200078e0258ULL,
0xfffffff815467812ULL, 0x000fe200078ee242ULL, 0x000000083d4f7824ULL, 0x040fe400078e00ffULL,
0x000000013d3c7824ULL, 0x000fe400078e0258ULL, 0x000000010d4b7824ULL, 0x000fc600078e0214ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee23cULL, 0x0000001046507824ULL, 0x000fe200078e024bULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160cULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514007589ULL, 0x0002e400000e0000ULL, 0x011000005014783bULL, 0x0022e20000000200ULL,
0x000000104f347824ULL, 0x000fe200078e0248ULL, 0x0000000000100947ULL, 0x000fec0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000083d3e7824ULL, 0x000fe200078e00ffULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x000000023c4d7836ULL, 0x000fe20000000000ULL, 0x0000001049497812ULL, 0x000fe200078efe4aULL,
0x00000004385a7824ULL, 0x000fc600078e0259ULL, 0xfffffff83e4d7812ULL, 0x000fe200078ee24dULL,
0x0000000158587824ULL, 0x000fe200078e0249ULL, 0x000000025a5a7810ULL, 0x000fe20007ffe053ULL,
0x0000000853537824ULL, 0x000fe400078e00ffULL, 0x000000104d3c7824ULL, 0x000fc600078e0248ULL,
0xfffffff8534a7812ULL, 0x000fc600078ee25aULL, 0x000000003c3c783bULL, 0x000f640000004200ULL,
0x000000104a4a7824ULL, 0x000fe200078e024bULL, 0x000000ff35657812ULL, 0x022fe400078ec0ffULL,
0x00000018ff5a7819ULL, 0x100fe40000011634ULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000010ff537819ULL, 0x000fe40000011634ULL, 0x000000ff345c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff346b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff37707812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6c7819ULL, 0x100fe40000011635ULL, 0x00000018ff637819ULL, 0x000fe40000011635ULL,
0x00000018ff627819ULL, 0x108fe4000001163cULL, 0x00000010ff697819ULL, 0x000fc4000001163cULL,
0x000000ff3c717812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3c607812ULL, 0x000fe400078ec0ffULL,
0x0000ffff356d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6e7819ULL, 0x100fe40000011636ULL,
0x000000ff36667812ULL, 0x000fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fc40000011636ULL,
0x0000ffff36347812ULL, 0x000fe400078ec0ffULL, 0x00000010ff677819ULL, 0x100fe4000001163dULL,
0x000000ff3d727812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001163dULL,
0x0000ffff3d6a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5f7819ULL, 0x000fc4000001163eULL,
0x000000ff3e5e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e647812ULL, 0x000fe400078ec0ffULL, 0x00000010ff367819ULL, 0x100fe4000001163fULL,
0x000000ff3f3e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3d7819ULL, 0x000fc4000001163fULL,
0x0000ffff3f617812ULL, 0x000fe400078ec0ffULL, 0x0000005aff35723eULL, 0x000fe200020006ffULL,
0x20000065ff5a7230ULL, 0x000fe20000004100ULL, 0x00000062ff3f723eULL, 0x000fe400020006ffULL,
0x00000070ff65723eULL, 0x000fe200020006ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x0000005dff70723eULL, 0x000fe200020006ffULL, 0x2000003fff5d7230ULL, 0x000fe20000004100ULL,
0x0000005eff3f723eULL, 0x000fe200020006ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000018ff6f7819ULL, 0x000fe20000011637ULL, 0x20000070ff5e7230ULL, 0x000fe20000004100ULL,
0x0000003eff70723eULL, 0x000fc400020006ffULL, 0x0000003cff3e723eULL, 0x000fe200020006ffULL,
0x2000003fff3c7230ULL, 0x000fe20000004100ULL, 0x0000003dff3f723eULL, 0x000fe200020006ffULL,
0x20000070ff3d7230ULL, 0x000fe20000004100ULL, 0x0000006fff70723eULL, 0x000fe200020006ffULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x000000ff536f7812ULL, 0x000fe200078ec0ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL,
0x20000070ff537230ULL, 0x000fe20000004100ULL, 0x00000010ff687819ULL, 0x000fc40000011637ULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000071ff627230ULL, 0x000fe20000004100ULL,
0x00000008ff707819ULL, 0x000fe2000001166dULL, 0x2000006fff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x000000ff6e717812ULL, 0x000fe200078ec0ffULL,
0x2000006cff6e7230ULL, 0x000fe20000004100ULL, 0x000000ff696f7812ULL, 0x000fc400078ec0ffULL,
0x00000070ff6c723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000008ff607819ULL, 0x000fe20000011660ULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x0000ffff375b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff707819ULL, 0x000fe2000001166aULL,
0x20000068ff6a7230ULL, 0x000fe20000004100ULL, 0x0000005cff37723eULL, 0x000fc400020006ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x000000ff67677812ULL, 0x000fe200078ec0ffULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000008ff6b7819ULL, 0x000fe4000001166bULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000067ff68723eULL, 0x000fe200020006ffULL, 0x2000006fff677230ULL, 0x000fe20000004100ULL,
0x000000ff5f6f7812ULL, 0x000fe200078ec0ffULL, 0x20000060ff5f7230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000070ff607230ULL, 0x000fe20000004100ULL,
0x00000063ff5c723eULL, 0x000fe200020006ffULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x000000ff36707812ULL, 0x000fe200078ec0ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe20000011637ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fc4000001165aULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x000010546e377816ULL, 0x000fe20000000037ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x000010546d367816ULL, 0x000fe20000000036ULL,
0x20000071ff697230ULL, 0x000fe20000004100ULL, 0x00000008ff6e7819ULL, 0x000fc40000011634ULL,
0x00000010ff357819ULL, 0x000fe40000011635ULL, 0x00000010ff347819ULL, 0x000fe2000001166bULL,
0x000000361418723cULL, 0x000fe20000041818ULL, 0x00000010ff6d7819ULL, 0x000fe4000001165cULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000072ff63723eULL, 0x000fe400020006ffULL,
0x0000105435347816ULL, 0x000fc40000000034ULL, 0x000010546d357816ULL, 0x000fe2000000006cULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe40000011666ULL,
0x00000010ff377819ULL, 0x000fe40000011665ULL, 0x00000010ff697819ULL, 0x000fe20000011669ULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x0000105469367816ULL, 0x000fc40000000036ULL, 0x000010546a377816ULL, 0x000fe40000000037ULL,
0x00000010ff347819ULL, 0x000fe40000011662ULL, 0x00000010ff357819ULL, 0x000fe40000011663ULL,
0x00000010ff677819ULL, 0x000fe20000011667ULL, 0x00000036142c723cULL, 0x000fe2000004182cULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x0000006fff6f723eULL, 0x000fc400020006ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x0000105467347816ULL, 0x000fe20000000034ULL,
0x2000006fff5a7230ULL, 0x000fe20000004100ULL, 0x0000105468357816ULL, 0x000fe20000000035ULL,
0x20000070ff5c7230ULL, 0x000fe20000004100ULL, 0x00000008ff5b7819ULL, 0x000fe4000001165bULL,
0x00000008ff6b7819ULL, 0x000fe40000011664ULL, 0x00000008ff657819ULL, 0x000fe20000011661ULL,
0x000000341424723cULL, 0x000fe20000041824ULL, 0x00000010ff5d7819ULL, 0x000fc4000001165dULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff367819ULL, 0x000fe4000001165fULL,
0x00000010ff377819ULL, 0x000fe40000011660ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x2000006eff647230ULL, 0x000fe20000004100ULL, 0x000010545d367816ULL, 0x000fe20000000036ULL,
0x2000006bff617230ULL, 0x000fe20000004100ULL, 0x000010545e377816ULL, 0x000fe20000000037ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fc4000001163cULL,
0x00000010ff3d7819ULL, 0x000fe4000001163dULL, 0x00000010ff357819ULL, 0x000fe2000001165aULL,
0x000000361420723cULL, 0x000fe20000041820ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00001054353c7816ULL, 0x000fe4000000003cULL, 0x000010545c3d7816ULL, 0x000fe4000000003dULL,
0x00000010ff367819ULL, 0x000fc40000011653ULL, 0x00000010ff357819ULL, 0x000fe4000001165bULL,
0x00000010ff597819ULL, 0x000fe20000011659ULL, 0x0000003c141c723cULL, 0x000fe2000004181cULL,
0x00000010ff347819ULL, 0x000fe40000011664ULL, 0x00000010ff3e7819ULL, 0x000fe4000001163eULL,
0x00000010ff5a7819ULL, 0x000fe4000001163fULL, 0x00000010ff617819ULL, 0x000fe20000011661ULL,
0x00000008493d7824ULL, 0x000fe200078e00ffULL, 0x00000010ff377819ULL, 0x000fc40000011665ULL,
0x0000105436357816ULL, 0x000fe40000000035ULL, 0x0000105459347816ULL, 0x000fe40000000034ULL,
0x000010543e367816ULL, 0x000fe40000000061ULL, 0x000010545a377816ULL, 0x000fe40000000037ULL,
0xfffffff83d4b7812ULL, 0x000fe200078ee258ULL, 0x000000341430723cULL, 0x000fec0000041830ULL,
0x000000361410723cULL, 0x000fe20000041810ULL, 0x000000104b347824ULL, 0x000fe200078e0248ULL,
0x011000004a14783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x00000008493c7824ULL, 0x000fe200078e00ffULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x0000000258497836ULL, 0x000fe20000000000ULL,
0xfffffff852527812ULL, 0x000fc800078ec0ffULL, 0xfffffff83c497812ULL, 0x000fe200078ee249ULL,
0x000000010d527824ULL, 0x000fc800078e0252ULL, 0x00000010493c7824ULL, 0x000fcc00078e0248ULL,
0x000000003c3c783bULL, 0x000f640000004200ULL, 0x000000ff34587812ULL, 0x062fe400078ec0ffULL,
0x00000010ff6c7819ULL, 0x100fe40000011634ULL, 0x00000018ff537819ULL, 0x000fe40000011634ULL,
0x0000ffff346d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff347819ULL, 0x000fc40000011635ULL,
0x000000ff365f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fe40000011636ULL,
0x00000058ff69723eULL, 0x000fe400020006ffULL, 0x000000ff355a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff587819ULL, 0x008fe2000001163cULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000018ff6f7819ULL, 0x000fc4000001163dULL, 0x00000010ff657819ULL, 0x000fe40000011636ULL,
0x0000ffff36637812ULL, 0x000fe400078ec0ffULL, 0x00000034ff68723eULL, 0x000fe400020006ffULL,
0x000000ff3c617812ULL, 0x000fe400078ec0ffULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000010ff6e7819ULL, 0x000fc40000011635ULL,
0x0000ffff35647812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6b7819ULL, 0x100fe40000011637ULL,
0x000000ff37607812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011637ULL,
0x0000ffff37667812ULL, 0x000fe400078ec0ffULL, 0x00000053ff67723eULL, 0x000fc400020006ffULL,
0x00000010ff347819ULL, 0x000fe4000001163cULL, 0x0000ffff3c367812ULL, 0x000fe200078ec0ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000005aff6a723eULL, 0x000fe400020006ffULL, 0x00000010ff357819ULL, 0x000fe4000001163dULL,
0x000000ff3d5c7812ULL, 0x040fe200078ec0ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x0000ffff3d377812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5d7819ULL, 0x100fe4000001163eULL,
0x000000ff3e707812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e537812ULL, 0x000fe400078ec0ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000010ff5e7819ULL, 0x000fc4000001163fULL, 0x000000ff3f3e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001163fULL, 0x0000ffff3f5a7812ULL, 0x000fe400078ec0ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x00000061ff3f723eULL, 0x000fe200020006ffULL,
0x2000005fff617230ULL, 0x000fe20000004100ULL, 0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL,
0x20000059ff5f7230ULL, 0x000fe20000004100ULL, 0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL,
0x20000058ff597230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x2000006fff587230ULL, 0x000fe20000004100ULL, 0x000000ff65657812ULL, 0x000fc400078ec0ffULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x20000060ff627230ULL, 0x000fe20000004100ULL,
0x00000008ff647819ULL, 0x000fe40000011664ULL, 0x00000008ff637819ULL, 0x000fe20000011663ULL,
0x2000005bff607230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x2000003fff5b7230ULL, 0x000fe20000004100ULL, 0x0000006eff6f723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x2000006cff6e7230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fc400020006ffULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000065ff6c7230ULL, 0x000fe20000004100ULL, 0x00000008ff6d7819ULL, 0x000fe4000001166dULL,
0x000000ff34347812ULL, 0x000fe200078ec0ffULL, 0x20000063ff657230ULL, 0x000fe20000004100ULL,
0x000000ff35357812ULL, 0x000fe400078ec0ffULL, 0x0000003eff3f723eULL, 0x000fe200020006ffULL,
0x20000070ff3e7230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x20000064ff707230ULL, 0x000fe20000004100ULL, 0x00000034ff63723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000035ff64723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x000000ff6b6b7812ULL, 0x000fe200078ec0ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe20000011669ULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fc4000001166eULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x000010546f357816ULL, 0x000fe2000000006aULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000008ff667819ULL, 0x000fc40000011666ULL, 0x00000008ff697819ULL, 0x000fe40000011636ULL,
0x00000008ff6a7819ULL, 0x000fe20000011637ULL, 0x000000341418723cULL, 0x000fe20000041818ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff367819ULL, 0x000fe4000001166dULL, 0x00000010ff377819ULL, 0x000fc40000011670ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x0000105467367816ULL, 0x000fe40000000036ULL,
0x0000105468377816ULL, 0x000fe20000000037ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fe40000011661ULL, 0x00000010ff357819ULL, 0x000fe4000001166cULL,
0x00000010ff677819ULL, 0x000fe20000011662ULL, 0x000000361428723cULL, 0x000fe20000041828ULL,
0x00000010ff687819ULL, 0x000fc4000001166bULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x0000105468357816ULL, 0x000fe20000000067ULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff367819ULL, 0x000fe20000011665ULL,
0x00000034142c723cULL, 0x000fe2000004182cULL, 0x00000010ff377819ULL, 0x000fc40000011666ULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x20000069ff617230ULL, 0x000fe20000004100ULL,
0x000000ff5e5e7812ULL, 0x000fe200078ec0ffULL, 0x2000006aff627230ULL, 0x000fe20000004100ULL,
0x000010545f367816ULL, 0x000fe40000000036ULL, 0x0000105460377816ULL, 0x000fc40000000037ULL,
0x00000010ff347819ULL, 0x000fe4000001165bULL, 0x00000010ff357819ULL, 0x000fe4000001165cULL,
0x00000010ff637819ULL, 0x000fe20000011663ULL, 0x000000361430723cULL, 0x000fe20000041830ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fc400020006ffULL, 0x0000105463347816ULL, 0x000fe20000000034ULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x0000105464357816ULL, 0x000fe20000000035ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff537819ULL, 0x000fe40000011653ULL,
0x00000008ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff597819ULL, 0x000fe20000011659ULL,
0x000000341424723cULL, 0x000fe20000041824ULL, 0x00000010ff587819ULL, 0x000fc40000011658ULL,
0x00000010ff367819ULL, 0x000fe40000011661ULL, 0x00000010ff377819ULL, 0x000fe40000011662ULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x0000003dff3d723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x0000105459367816ULL, 0x000fe20000000036ULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x0000105458377816ULL, 0x000fe20000000037ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fc4000001163eULL, 0x00000010ff357819ULL, 0x000fe4000001163fULL,
0x00000010ff5d7819ULL, 0x000fe2000001165dULL, 0x000000361420723cULL, 0x000fe20000041820ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x000010545d347816ULL, 0x000fe40000000034ULL,
0x000010545e357816ULL, 0x000fe40000000035ULL, 0x00000010ff377819ULL, 0x000fc4000001163cULL,
0x00000010ff367819ULL, 0x000fe40000011653ULL, 0x00000010ff3d7819ULL, 0x000fe2000001163dULL,
0x00000034141c723cULL, 0x000fe2000004181cULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x000010543d377816ULL, 0x000fe2000000005aULL,
0x00000001ff3d7424ULL, 0x000fe400078e00ffULL, 0x0000000838347824ULL, 0x000fc800078e020dULL,
0x000000361410723cULL, 0x000fe40000041810ULL, 0x0176c83d343479a7ULL, 0x0002e2000850003fULL,
0x0176883d52ff79a7ULL, 0x0003de000850003fULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x00000035040075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035040075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x00009000ff147b82ULL, 0x000ee20000000a00ULL, 0x0000001040357824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x000000044c4c7c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe035167812ULL, 0x000fe400078ec0ffULL, 0x000000404c177824ULL, 0x000fc600078e00ffULL,
0x0000010005167824ULL, 0x000fc800078e0216ULL, 0x0000008016347836ULL, 0x000fca0000000000ULL,
0x0000002034167812ULL, 0x000fe200078ec0ffULL, 0x0000008017147825ULL, 0x008fc800078e0014ULL,
0x000000010b377824ULL, 0x000fe200078e0216ULL, 0x0000000000f49947ULL, 0x000fec0003800000ULL,
0x000000343b167248ULL, 0x000fe40007fe0000ULL, 0x0000001035357812ULL, 0x000fe400078ec0ffULL,
0x00000003ff177819ULL, 0x000fe2000001160cULL, 0x0000000116167824ULL, 0x000fc800078e0a34ULL,
0x0000000117347824ULL, 0x140fe200078e0235ULL, 0x0000001635167248ULL, 0x000fe20007fe0000ULL,
0x00000004173c7836ULL, 0x000fe40000000000ULL, 0x0000000134367824ULL, 0x140fe400078e020cULL,
0x0000000834537824ULL, 0x000fe400078e00ffULL, 0x0000000116167824ULL, 0x100fe400078e0a35ULL,
0x0000000c173d7836ULL, 0x002fe20000000000ULL, 0xfffffff853537812ULL, 0x000fe200078ee236ULL,
0x0000000817367836ULL, 0x000fe20000000000ULL, 0x000000163c00720cULL, 0x0c0fe20003f66070ULL,
0x000000013c3c7824ULL, 0x100fe200078e0235ULL, 0x000000161700720cULL, 0x080fe20003f86070ULL,
0x000000013d3e7824ULL, 0x140fe200078e0235ULL, 0x000000163600720cULL, 0x0c0fe20003f46070ULL,
0x0000000136367824ULL, 0x000fe200078e0235ULL, 0x000000163d00720cULL, 0x000fe20003f06070ULL,
0x000000013c177824ULL, 0x000fc400078e020cULL, 0x000000083c4c7824ULL, 0x040fe400078e00ffULL,
0x000000013c3c7824ULL, 0x100fe400078e0237ULL, 0x0000000136357824ULL, 0x040fe200078e020cULL,
0xfffffff84c5d7812ULL, 0x000fe200078ee217ULL, 0x0000000836527824ULL, 0x000fe400078e00ffULL,
0x0000000134347824ULL, 0x000fe400078e0237ULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0xfffffff8525f7812ULL, 0x000fc600078ee235ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x000000443c177212ULL, 0x000fc600078efcffULL, 0x0000000136367824ULL, 0x100fe200078e0237ULL,
0x00000044343f7212ULL, 0x000fe200078efcffULL, 0x000000013e167824ULL, 0x000fe200078e0237ULL,
0x00000017143c7210ULL, 0x000fe20007fde0ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000003f14347210ULL, 0x000fc60007fbe0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000044365b7212ULL, 0x000fc600078efcffULL, 0x000000013e4c7824ULL, 0x000fe200078e020cULL,
0x0000004416597212ULL, 0x000fe200078efcffULL, 0x000000083e617824ULL, 0x000fe400078e00ffULL,
0x0000000115357824ULL, 0x040fe200028e0635ULL, 0x0000005b14367210ULL, 0x000fe20007fbe0ffULL,
0x00000001153d7824ULL, 0x000fe200030e063dULL, 0xfffffff861617812ULL, 0x000fe200078ee24cULL,
0x00000010533f7824ULL, 0x100fe200078e0248ULL, 0x0000005914147210ULL, 0x000fe20007fde0ffULL,
0x000000105d537824ULL, 0x000fc400078e0248ULL, 0x000000105f597824ULL, 0x100fe200078e0248ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000343f7faeULL, 0x0003e2000e101c46ULL,
0x0000000115377824ULL, 0x000fe400028e0637ULL, 0x00000010615b7824ULL, 0x000fe200078e0248ULL,
0x000000003c537faeULL, 0x0003e2000d901c46ULL, 0x0000000115157824ULL, 0x000fc600030e0617ULL,
0x0000000036597faeULL, 0x0003e8000d101c46ULL, 0x00000000145b7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c07947ULL, 0x000fea0003800000ULL, 0x0000001035357812ULL, 0x000fc800078ec0ffULL,
0x000000350c357211ULL, 0x000fca00078fe8ffULL, 0x0000000135177824ULL, 0x040fe400078e020cULL,
0x0000000835367824ULL, 0x040fe400078e00ffULL, 0x0000000135167824ULL, 0x000fe400078e0237ULL,
0x0000000435347836ULL, 0x000fe20000000000ULL, 0xfffffff8363f7812ULL, 0x000fe200078ee217ULL,
0x00000008353e7836ULL, 0x000fe40000000000ULL, 0x0000000c354c7836ULL, 0x000fc40000000000ULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x0000000134367824ULL, 0x100fe200078e0237ULL,
0x0000004416357212ULL, 0x000fe200078efcffULL, 0x00000001343d7824ULL, 0x142fe400078e020cULL,
0x0000000834527824ULL, 0x000fe200078e00ffULL, 0x0000003514167210ULL, 0x000fe20007f1e0ffULL,
0x000000013e3c7824ULL, 0x100fe400078e0237ULL, 0x000000014c347824ULL, 0x000fe200078e0237ULL,
0xfffffff852537812ULL, 0x000fe200078ee23dULL, 0x000000013e377824ULL, 0x000fc400078e020cULL,
0x000000083e587824ULL, 0x000fe400078e00ffULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0xfffffff858597812ULL, 0x000fe200078ee237ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000000443c5d7212ULL, 0x000fc600078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x00000044365f7212ULL, 0x080fe400078efcffULL, 0x0000005d143c7210ULL, 0x000fe20007f5e0ffULL,
0x000000014c3e7824ULL, 0x000fe200078e020cULL, 0x00000044345b7212ULL, 0x000fe200078efcffULL,
0x000000084c617824ULL, 0x000fe400078e00ffULL, 0x0000000115177824ULL, 0x000fe200000e0617ULL,
0x0000005f14367210ULL, 0x000fe20007f1e0ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0248ULL,
0xfffffff861617812ULL, 0x000fe200078ee23eULL, 0x0000001053537824ULL, 0x100fe200078e0248ULL,
0x0000005b14147210ULL, 0x000fe20007f7e0ffULL, 0x0000000115377824ULL, 0x000fe200000e0637ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000163f7faeULL, 0x0003e2000b901c46ULL,
0x0000001059597824ULL, 0x000fc400078e0248ULL, 0x00000001153d7824ULL, 0x000fe200010e063dULL,
0x0000000036537faeULL, 0x0003e2000b901c46ULL, 0x00000010615b7824ULL, 0x000fe400078e0248ULL,
0x0000000115157824ULL, 0x000fe200018e0635ULL, 0x000000003c597faeULL, 0x0003e8000b901c46ULL,
0x00000000145b7faeULL, 0x0003e4000b901c46ULL, 0x0000000209177836ULL, 0x002fe40000000000ULL,
0xffffffffff537424ULL, 0x000fc600078e00ffULL, 0x0000003a1700720cULL, 0x000fe20003f06070ULL,
0x0000000840167824ULL, 0x000fca00078e00ffULL, 0xfffffff016167812ULL, 0x000fca00078ec0ffULL,
0x000000010d167824ULL, 0x000fe400078e0216ULL, 0x00009200ff148b82ULL, 0x000e620000000a00ULL,
0x0000000106178824ULL, 0x000fe400078e0217ULL, 0x00000000160472caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000176a804047890ULL, 0x000fe2000fffe03fULL,
0x0000000417148825ULL, 0x002fd000078e0014ULL, 0x00000000ff0079b0ULL, 0x000fe80008000a44ULL,
0x0000000614538981ULL, 0x000322000c1e1900ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0176a817165879a7ULL, 0x000764000850003fULL,
0x01762817511479a7ULL, 0x022664000850003fULL, 0x0000000000167805ULL, 0x008fce0000015200ULL,
0x01762815510075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003416377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e17ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01762815510075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002040147824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0xffffff8014147812ULL, 0x000fc800078ec0ffULL,
0x000000800d147810ULL, 0x000fc80007ffe014ULL, 0x0000001447147210ULL, 0x000fca0007ffe044ULL,
0x0170000014167984ULL, 0x000e680000000800ULL, 0x0172000014177984ULL, 0x0006e20000000800ULL,
0x000000551600720bULL, 0x002fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15357812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x00cfea0003800000ULL,
0x000000010a157836ULL, 0x000fe20000000000ULL, 0x000000551600720bULL, 0x000fc80003f14000ULL,
0x000000401500720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x000000804015a824ULL, 0x000fe200078e020dULL, 0x000000551614a209ULL, 0x000fc80007810000ULL,
0x000000154737a210ULL, 0x000fe40007ffe044ULL, 0x0000991034157816ULL, 0x000fc600000000ffULL,
0x017400143700a388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005516147209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x0000005514147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400157308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x002fcc000001160cULL, 0x00001f1415147589ULL, 0x004e6400000e0000ULL,
0x0000001814187220ULL, 0x042fe20000410000ULL, 0x0000001914197220ULL, 0x040fe20000410000ULL,
0x0000002814287220ULL, 0x040fe20000410000ULL, 0x0000002914297220ULL, 0x040fe20000410000ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000002d142d7220ULL, 0x040fe20000410000ULL,
0x0000003014307220ULL, 0x040fe20000410000ULL, 0x0000003114317220ULL, 0x040fe20000410000ULL,
0x0000002414247220ULL, 0x040fe20000410000ULL, 0x0000002514257220ULL, 0x040fe20000410000ULL,
0x0000002014207220ULL, 0x040fe20000410000ULL, 0x0000002114217220ULL, 0x040fe20000410000ULL,
0x0000001c141c7220ULL, 0x040fe20000410000ULL, 0x0000001d141d7220ULL, 0x040fe20000410000ULL,
0x0000001014107220ULL, 0x040fe20000410000ULL, 0x0000001114117220ULL, 0x000fce0000410000ULL,
0x0000001554547220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080c147811ULL, 0x002fcc00078ff0ffULL, 0x00001f1415147589ULL, 0x000e6400000e0000ULL,
0x0000001a141a7220ULL, 0x042fe20000410000ULL, 0x0000001b141b7220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000003214327220ULL, 0x040fe20000410000ULL, 0x0000003314337220ULL, 0x040fe20000410000ULL,
0x0000002614267220ULL, 0x040fe20000410000ULL, 0x0000002714277220ULL, 0x040fe20000410000ULL,
0x0000002214227220ULL, 0x040fe20000410000ULL, 0x0000002314237220ULL, 0x040fe20000410000ULL,
0x0000001e141e7220ULL, 0x040fe20000410000ULL, 0x0000001f141f7220ULL, 0x040fe20000410000ULL,
0x0000001214127220ULL, 0x040fe20000410000ULL, 0x0000001314137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000005516557209ULL, 0x000fd60007810000ULL, 0x8000005516160221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL,
0x0000001600020308ULL, 0x000ea40000000800ULL, 0x0000000217170220ULL, 0x004fce0000410000ULL,
0x0000005417547221ULL, 0x000fce0000010000ULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x0000000840167824ULL, 0x000fca00078e00ffULL, 0xfffffff016167812ULL, 0x000fca00078ec0ffULL,
0x000000010d377824ULL, 0x000fc800078e0216ULL, 0x0176b057370075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176b057370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991034147816ULL, 0x000fe200000000ffULL, 0x000140004e487836ULL, 0x000fc60000000000ULL,
0x000000ff1400720cULL, 0x000fe20003f05270ULL, 0x000000104f4c7824ULL, 0x000fd800078e0248ULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160cULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514007589ULL, 0x0002e400000e0000ULL, 0x011800005014783bULL, 0x0022e20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000104d3c7824ULL, 0x000fe200078e0248ULL,
0x000000004c34783bULL, 0x000f6a0000004200ULL, 0x000000003c3c783bULL, 0x000f640000004200ULL,
0x00000010ff527819ULL, 0x022fe40000011634ULL, 0x000000ff345a7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff577819ULL, 0x000fe40000011634ULL, 0x0000ffff34687812ULL, 0x000fe400078ec0ffULL,
0x000000ff35347812ULL, 0x000fe400078ec0ffULL, 0x000000ff3c5b7812ULL, 0x008fe400078ec0ffULL,
0x00000010ff5d7819ULL, 0x000fe4000001163dULL, 0x000000ff3d707812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001163dULL, 0x0000ffff3d677812ULL, 0x000fe400078ec0ffULL,
0x000000ff3e3d7812ULL, 0x000fe400078ec0ffULL, 0x00000034ff65723eULL, 0x000fe400020006ffULL,
0x00000010ff347819ULL, 0x100fe4000001163fULL, 0x000000ff3f6e7812ULL, 0x000fe200078ec0ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000018ff6d7819ULL, 0x000fc4000001163fULL,
0x0000ffff3f617812ULL, 0x000fe400078ec0ffULL, 0x00000018ff607819ULL, 0x000fe4000001163cULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x0000006fff3f723eULL, 0x000fe400020006ffULL,
0x00000010ff6c7819ULL, 0x100fe40000011637ULL, 0x000000ff37727812ULL, 0x000fe200078ec0ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000018ff717819ULL, 0x000fc40000011637ULL,
0x0000ffff37667812ULL, 0x000fe400078ec0ffULL, 0x0000003dff6f723eULL, 0x000fe400020006ffULL,
0x00000010ff6a7819ULL, 0x100fe40000011636ULL, 0x000000ff36637812ULL, 0x040fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011636ULL, 0x0000ffff366b7812ULL, 0x000fc400078ec0ffULL,
0x00000057ff37723eULL, 0x000fe400020006ffULL, 0x00000010ff5c7819ULL, 0x100fe4000001163eULL,
0x00000018ff577819ULL, 0x000fe2000001163eULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x0000ffff3e367812ULL, 0x000fe400078ec0ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000060ff3e723eULL, 0x000fe200020006ffULL, 0x2000005bff607230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x000fe20000011635ULL, 0x2000006fff5b7230ULL, 0x000fe20000004100ULL,
0x000000ff52527812ULL, 0x000fe200078ec0ffULL, 0x20000070ff3d7230ULL, 0x000fe20000004100ULL,
0x0000006eff6f723eULL, 0x000fe200020006ffULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x000000ff566e7812ULL, 0x000fc400078ec0ffULL, 0x0000006dff70723eULL, 0x000fe400020006ffULL,
0x00000052ff6d723eULL, 0x000fe200020006ffULL, 0x2000006fff527230ULL, 0x000fe20000004100ULL,
0x00000008ff687819ULL, 0x000fe40000011668ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x000000ff6a6f7812ULL, 0x000fe400078ec0ffULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x2000006eff6a7230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fc400020006ffULL, 0x00000010ff647819ULL, 0x000fe4000001163cULL,
0x00000008ff6e7819ULL, 0x000fe2000001166bULL, 0x20000068ff6b7230ULL, 0x000fe20000004100ULL,
0x0000ffff3c5e7812ULL, 0x000fe200078ec0ffULL, 0x2000006fff687230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x000000ff646f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5f7819ULL, 0x000fe20000011635ULL, 0x2000006eff647230ULL, 0x000fe20000004100ULL,
0x0000ffff35697812ULL, 0x000fc400078ec0ffULL, 0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL,
0x0000005aff35723eULL, 0x000fe400020006ffULL, 0x00000008ff5e7819ULL, 0x000fe4000001165eULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000008ff677819ULL, 0x000fe40000011667ULL, 0x0000005dff6e723eULL, 0x000fc400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000008ff697819ULL, 0x000fe40000011669ULL,
0x0000005eff5d723eULL, 0x000fe200020006ffULL, 0x20000057ff567230ULL, 0x000fe20000004100ULL,
0x00000067ff5e723eULL, 0x000fe200020006ffULL, 0x2000006fff677230ULL, 0x000fe20000004100ULL,
0x000000ff5c6f7812ULL, 0x000fe200078ec0ffULL, 0x2000006eff5c7230ULL, 0x000fe20000004100ULL,
0x0000005fff5a723eULL, 0x000fe200020006ffULL, 0x20000070ff577230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff346e7812ULL, 0x000fe200078ec0ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fe20000011635ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff6c707812ULL, 0x000fe200078ec0ffULL, 0x20000069ff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fc40000011665ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000070ff69723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x000010546a357816ULL, 0x000fc40000000035ULL,
0x000010546d347816ULL, 0x000fe20000000034ULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000008ff6a7819ULL, 0x000fe40000011636ULL, 0x00000008ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff377819ULL, 0x000fe20000011637ULL, 0x000000341418723cULL, 0x000fe20000041818ULL,
0x00000010ff367819ULL, 0x000fe4000001166bULL, 0x00000010ff6d7819ULL, 0x000fc4000001165aULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000062ff3c723eULL, 0x000fe200020006ffULL,
0x20000072ff627230ULL, 0x000fe20000004100ULL, 0x00000071ff5f723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x0000105437367816ULL, 0x000fe20000000036ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x000010546d377816ULL, 0x000fe2000000006cULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fc40000011663ULL, 0x00000010ff357819ULL, 0x000fe40000011668ULL,
0x00000010ff627819ULL, 0x000fe20000011662ULL, 0x000000361428723cULL, 0x000fe20000041828ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x0000105469357816ULL, 0x000fe40000000062ULL, 0x00000008ff6b7819ULL, 0x000fc40000011661ULL,
0x00000010ff377819ULL, 0x000fe4000001163cULL, 0x00000010ff367819ULL, 0x000fe20000011664ULL,
0x00000034142c723cULL, 0x000fe2000004182cULL, 0x00000010ff637819ULL, 0x000fe4000001165fULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000006fff6f723eULL, 0x000fc400020006ffULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x2000006aff617230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x2000006fff657230ULL, 0x000fe20000004100ULL, 0x0000105437367816ULL, 0x000fe20000000036ULL,
0x2000006eff5a7230ULL, 0x000fe20000004100ULL, 0x0000105463377816ULL, 0x000fe20000000066ULL,
0x2000006bff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe4000001163eULL,
0x00000010ff3e7819ULL, 0x000fc4000001165dULL, 0x00000010ff347819ULL, 0x000fe2000001163fULL,
0x000000361430723cULL, 0x000fe20000041830ULL, 0x00001054353e7816ULL, 0x000fe4000000003eULL,
0x00000010ff3f7819ULL, 0x000fe4000001165eULL, 0x00000010ff357819ULL, 0x000fe40000011652ULL,
0x00000010ff377819ULL, 0x000fe40000011656ULL, 0x00000010ff367819ULL, 0x000fc40000011661ULL,
0x00000010ff3c7819ULL, 0x000fe40000011660ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff3d7819ULL, 0x000fe4000001163dULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff5e7819ULL, 0x000fc40000011665ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff527819ULL, 0x000fe40000011657ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00001054343f7816ULL, 0x000fe4000000003fULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x00001054673c7816ULL, 0x000fc4000000003cULL,
0x000010545c3d7816ULL, 0x000fe2000000003dULL, 0x0000003e1420723cULL, 0x000fe20000041820ULL,
0x000010545e347816ULL, 0x000fe4000000005bULL, 0x000010545a357816ULL, 0x000fe40000000035ULL,
0x0000105452377816ULL, 0x000fe2000000005fULL, 0x0000003c1424723cULL, 0x000fe20000041824ULL,
0x000000104b527824ULL, 0x000fca00078e0248ULL, 0x00000034141c723cULL, 0x000fec000004181cULL,
0x000000361410723cULL, 0x000fe20000041810ULL, 0x011800004a14783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x00000010493c7824ULL, 0x000fe200078e0248ULL, 0x000000005234783bULL, 0x000f6a0000004200ULL,
0x000000003c3c783bULL, 0x000f640000004200ULL, 0x00000010ff6d7819ULL, 0x022fe40000011634ULL,
0x000000ff34577812ULL, 0x000fc400078ec0ffULL, 0x00000018ff567819ULL, 0x000fe40000011634ULL,
0x0000ffff346e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff355a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff347819ULL, 0x000fe40000011635ULL, 0x000000ff36607812ULL, 0x000fe400078ec0ffULL,
0x000000ff37617812ULL, 0x000fc400078ec0ffULL, 0x0000ffff35657812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x100fe40000011636ULL, 0x00000018ff5b7819ULL, 0x000fe40000011637ULL,
0x00000010ff687819ULL, 0x000fe40000011636ULL, 0x0000ffff36647812ULL, 0x000fe400078ec0ffULL,
0x0000005aff6b723eULL, 0x000fc400020006ffULL, 0x00000034ff67723eULL, 0x000fe400020006ffULL,
0x000000ff3c627812ULL, 0x008fe200078ec0ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff6f7819ULL, 0x000fe20000011635ULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000010ff697819ULL, 0x000fe40000011637ULL, 0x0000ffff376c7812ULL, 0x000fe400078ec0ffULL,
0x00000056ff66723eULL, 0x000fc400020006ffULL, 0x00000010ff347819ULL, 0x100fe4000001163cULL,
0x00000018ff5a7819ULL, 0x000fe2000001163cULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000ffff3c367812ULL, 0x000fe400078ec0ffULL, 0x00000057ff6a723eULL, 0x000fe400020006ffULL,
0x00000010ff357819ULL, 0x100fe4000001163dULL, 0x000000ff3d5d7812ULL, 0x000fe200078ec0ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000018ff707819ULL, 0x000fc4000001163dULL,
0x0000ffff3d377812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5e7819ULL, 0x100fe4000001163eULL,
0x000000ff3e717812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e567812ULL, 0x000fe400078ec0ffULL, 0x00000060ff60723eULL, 0x000fc400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000010ff5f7819ULL, 0x100fe4000001163fULL,
0x000000ff3f3e7812ULL, 0x040fe200078ec0ffULL, 0x20000061ff637230ULL, 0x000fe20000004100ULL,
0x00000018ff3d7819ULL, 0x000fe4000001163fULL, 0x0000ffff3f577812ULL, 0x000fe400078ec0ffULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000008ff657819ULL, 0x000fe40000011665ULL, 0x00000062ff3f723eULL, 0x000fe200020006ffULL,
0x20000060ff627230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x2000005cff607230ULL, 0x000fe20000004100ULL, 0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL,
0x2000005bff617230ULL, 0x000fe20000004100ULL, 0x000000ff6f6f7812ULL, 0x000fe200078ec0ffULL,
0x2000003fff5c7230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fc400020006ffULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x000000ff69697812ULL, 0x000fe400078ec0ffULL,
0x00000070ff5b723eULL, 0x000fe400020006ffULL, 0x00000008ff647819ULL, 0x000fe40000011664ULL,
0x00000008ff6c7819ULL, 0x000fe2000001166cULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000003eff3f723eULL, 0x000fe200020006ffULL, 0x20000071ff3e7230ULL, 0x000fe20000004100ULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000065ff717230ULL, 0x000fe20000004100ULL,
0x0000006fff70723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000008ff6e7819ULL, 0x000fe2000001166eULL, 0x2000006dff6f7230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fc400020006ffULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x20000068ff6d7230ULL, 0x000fe20000004100ULL, 0x0000006cff65723eULL, 0x000fe200020006ffULL,
0x20000069ff6c7230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000064ff687230ULL, 0x000fe20000004100ULL, 0x000000ff34347812ULL, 0x000fe200078ec0ffULL,
0x20000065ff697230ULL, 0x000fe20000004100ULL, 0x000000ff35357812ULL, 0x000fe200078ec0ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000034ff64723eULL, 0x000fc400020006ffULL,
0x00000035ff65723eULL, 0x000fe400020006ffULL, 0x00000010ff347819ULL, 0x000fe2000001166aULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe2000001166bULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fe4000001166fULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000008ff6a7819ULL, 0x000fc40000011636ULL,
0x00000008ff6b7819ULL, 0x000fe40000011637ULL, 0x000010546f347816ULL, 0x000fe40000000034ULL,
0x0000105470357816ULL, 0x000fe40000000035ULL, 0x00000010ff377819ULL, 0x000fe40000011666ULL,
0x00000010ff367819ULL, 0x000fe4000001166eULL, 0x00000010ff667819ULL, 0x000fe20000011667ULL,
0x000000341418723cULL, 0x000fe20000041818ULL, 0x00000010ff717819ULL, 0x000fc40000011671ULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x0000105466377816ULL, 0x000fe40000000071ULL,
0x00000010ff347819ULL, 0x000fe40000011662ULL, 0x00000010ff357819ULL, 0x000fe40000011663ULL,
0x00000010ff6d7819ULL, 0x000fe2000001166dULL, 0x000000361428723cULL, 0x000fe20000041828ULL,
0x00000010ff6c7819ULL, 0x000fc4000001166cULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x000010546d347816ULL, 0x000fe40000000034ULL, 0x000010546c357816ULL, 0x000fe20000000035ULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff5e667812ULL, 0x000fe400078ec0ffULL,
0x00000010ff377819ULL, 0x000fe40000011660ULL, 0x00000010ff367819ULL, 0x000fe20000011668ULL,
0x00000034142c723cULL, 0x000fe2000004182cULL, 0x00000010ff5e7819ULL, 0x000fc40000011661ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x0000105437367816ULL, 0x000fe20000000036ULL,
0x2000006aff627230ULL, 0x000fe20000004100ULL, 0x000010545e377816ULL, 0x000fe20000000069ULL,
0x2000006bff637230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fc4000001165cULL,
0x00000010ff357819ULL, 0x000fe40000011664ULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x000000361430723cULL, 0x000fe20000041830ULL, 0x00000010ff5c7819ULL, 0x000fe40000011665ULL,
0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x00000066ff66723eULL, 0x000fc400020006ffULL, 0x000010545c357816ULL, 0x000fe4000000005dULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000008ff5c7819ULL, 0x000fe40000011656ULL, 0x00000010ff377819ULL, 0x000fe2000001165aULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011662ULL,
0x000000341424723cULL, 0x000fe20000041824ULL, 0x00000008ff577819ULL, 0x000fc40000011657ULL,
0x00000010ff567819ULL, 0x000fe4000001165bULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x0000105437367816ULL, 0x000fe20000000036ULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000105456377816ULL, 0x000fc40000000063ULL, 0x00000010ff347819ULL, 0x000fe2000001163eULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe40000011666ULL,
0x00000010ff3f7819ULL, 0x000fe2000001163fULL, 0x000000361420723cULL, 0x000fe20000041820ULL,
0x00000010ff3e7819ULL, 0x000fe4000001165fULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x000010543e357816ULL, 0x000fc4000000003fULL, 0x00000010ff377819ULL, 0x000fe4000001163cULL,
0x00000010ff3c7819ULL, 0x000fe2000001163dULL, 0x00000002403d7824ULL, 0x000fe200078e00ffULL,
0x00000010ff367819ULL, 0x000fe2000001165cULL, 0x00000034141c723cULL, 0x000fe2000004181cULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x000010543c377816ULL, 0x000fc40000000057ULL, 0xfffffff83d3c7812ULL, 0x000fe200078ec0ffULL,
0x0000000838347824ULL, 0x000fe400078e020dULL, 0x00000001ff3d7424ULL, 0x000fe400078e00ffULL,
0x000000010d3c7824ULL, 0x000fe200078e023cULL, 0x000000361410723cULL, 0x000fe20000041810ULL,
0x0176c83d343479a7ULL, 0x0002e4000850003fULL, 0x0176903d3cff79a7ULL, 0x0003de000850003fULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000035040075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035040075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x00009000ff147b82ULL, 0x000ee20000000a00ULL,
0x0000001040167824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x0000000453537c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe016347812ULL, 0x000fe400078ec0ffULL,
0x0000004053537824ULL, 0x000fc600078e00ffULL, 0x0000010005177824ULL, 0x000fc800078e0234ULL,
0x000000c017177836ULL, 0x000fca0000000000ULL, 0x0000002017347812ULL, 0x000fe200078ec0ffULL,
0x0000008053147825ULL, 0x008fc800078e0014ULL, 0x000000010b347824ULL, 0x000fe200078e0234ULL,
0x0000000000f49947ULL, 0x000fec0003800000ULL, 0x0000001016357812ULL, 0x000fe400078ec0ffULL,
0x000000173b167248ULL, 0x000fe40007fe0000ULL, 0x00000003ff367819ULL, 0x000fc6000001160cULL,
0x0000000116167824ULL, 0x000fe400078e0a17ULL, 0x0000000136177824ULL, 0x100fe400078e0235ULL,
0x00000004363c7836ULL, 0x002fe20000000000ULL, 0x0000001635167248ULL, 0x000fe20007fe0000ULL,
0x0000000117377824ULL, 0x040fe400078e020cULL, 0x00000008173e7824ULL, 0x000fe400078e00ffULL,
0x0000000116167824ULL, 0x000fc400078e0a35ULL, 0x00000008363d7836ULL, 0x000fe20000000000ULL,
0xfffffff83e577812ULL, 0x000fe200078ee237ULL, 0x000000013c377824ULL, 0x140fe200078e0235ULL,
0x000000163c00720cULL, 0x080fe20003f66070ULL, 0x0000000c363c7836ULL, 0x000fe20000000000ULL,
0x000000163600720cULL, 0x080fe20003f86070ULL, 0x0000000117177824ULL, 0x000fe200078e0234ULL,
0x000000163d00720cULL, 0x0c0fe20003f46070ULL, 0x000000013d3d7824ULL, 0x000fe200078e0235ULL,
0x000000163c00720cULL, 0x000fe20003f06070ULL, 0x0000008017167825ULL, 0x000fc800078e00ffULL,
0x000000013c5f7824ULL, 0x000fe400078e0235ULL, 0x00000001373c7824ULL, 0x040fe400078e0234ULL,
0x0000000137367824ULL, 0x040fe400078e020cULL, 0x00000008375b7824ULL, 0x000fe200078e00ffULL,
0x0000004416377212ULL, 0x000fe200078efcffULL, 0x000000013d357824ULL, 0x040fe400078e0234ULL,
0x000000013d3e7824ULL, 0x040fe200078e020cULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee236ULL,
0x000000083d5d7824ULL, 0x000fe200078e00ffULL, 0x0000003714167210ULL, 0x000fe20007fbe0ffULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee23eULL,
0x000000015f367824ULL, 0x000fe200078e0234ULL, 0x000000443c3f7212ULL, 0x000fe200078efcffULL,
0x0000008035347825ULL, 0x000fc800078e00ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004434537212ULL, 0x000fc600078efcffULL, 0x0000000115177824ULL, 0x000fe200028e0617ULL,
0x0000003f143c7210ULL, 0x000fe20007fbe0ffULL, 0x000000015f3e7824ULL, 0x040fe200078e020cULL,
0x00000044363f7212ULL, 0x000fe200078efcffULL, 0x000000085f5f7824ULL, 0x000fe400078e00ffULL,
0x00000001153d7824ULL, 0x000fe200028e063dULL, 0x0000005314347210ULL, 0x000fe20007fbe0ffULL,
0x0000001057577824ULL, 0x100fe200078e0248ULL, 0x0000003f14147210ULL, 0x000fe20007fde0ffULL,
0x000000105b5b7824ULL, 0x100fe200078e0248ULL, 0xfffffff85f3f7812ULL, 0x000fe200078ee23eULL,
0x0000000115357824ULL, 0x000fe200028e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016577faeULL, 0x0003e2000e101c46ULL, 0x000000105d5d7824ULL, 0x000fc400078e0248ULL,
0x0000000115157824ULL, 0x000fe200030e0637ULL, 0x000000003c5b7faeULL, 0x0003e2000d901c46ULL,
0x000000103f3f7824ULL, 0x000fc600078e0248ULL, 0x00000000345d7faeULL, 0x0003e8000d101c46ULL,
0x00000000143f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c07947ULL, 0x000fea0003800000ULL,
0x0000001016177812ULL, 0x000fc800078ec0ffULL, 0x000000170c177211ULL, 0x000fca00078fe8ffULL,
0x0000000417357836ULL, 0x000fe40000000000ULL, 0x0000000817377836ULL, 0x000fe40000000000ULL,
0x0000000135367824ULL, 0x140fe400078e020cULL, 0x00000008355d7824ULL, 0x000fe400078e00ffULL,
0x0000000117167824ULL, 0x140fe400078e020cULL, 0x00000008175b7824ULL, 0x000fe200078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee236ULL, 0x00000001373c7824ULL, 0x002fc400078e020cULL,
0x00000008375f7824ULL, 0x000fe200078e00ffULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee216ULL,
0x0000000117367824ULL, 0x100fe400078e0234ULL, 0x0000000c17177836ULL, 0x000fe20000000000ULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee23cULL, 0x0000000137167824ULL, 0x000fe400078e0234ULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x00000001353c7824ULL, 0x100fe200078e0234ULL,
0x00000044363f7212ULL, 0x000fe200078efcffULL, 0x0000000117347824ULL, 0x040fe400078e0234ULL,
0x00000001173e7824ULL, 0x040fe200078e020cULL, 0x0000003f14367210ULL, 0x000fe20007f1e0ffULL,
0x0000000817617824ULL, 0x000fe400078e00ffULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0xfffffff861617812ULL, 0x000fe200078ee23eULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000443c577212ULL, 0x000fc600078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000004416537212ULL, 0x080fe400078efcffULL, 0x00000057143c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000115377824ULL, 0x000fe200000e0637ULL, 0x00000044343f7212ULL, 0x000fe200078efcffULL,
0x000000105b5b7824ULL, 0x100fe200078e0248ULL, 0x0000005314167210ULL, 0x000fe20007f1e0ffULL,
0x00000001153d7824ULL, 0x000fe200010e063dULL, 0x0000003f14147210ULL, 0x000fe20007f7e0ffULL,
0x000000105d5d7824ULL, 0x000fe200078e0248ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000365b7faeULL, 0x0003e2000b901c46ULL, 0x0000000115177824ULL, 0x000fc400000e0617ULL,
0x000000105f5f7824ULL, 0x100fe200078e0248ULL, 0x000000003c5d7faeULL, 0x0003e2000b901c46ULL,
0x0000000115157824ULL, 0x000fe400018e0635ULL, 0x0000001061617824ULL, 0x000fe200078e0248ULL,
0x00000000165f7faeULL, 0x0003e8000b901c46ULL, 0x0000000014617faeULL, 0x0003e4000b901c46ULL,
0x0000000309177836ULL, 0x002fe40000000000ULL, 0xffffffffff537424ULL, 0x000fc600078e00ffULL,
0x0000003a1700720cULL, 0x000fe20003f06070ULL, 0x0000000840167824ULL, 0x000fca00078e00ffULL,
0xfffffff016167812ULL, 0x000fca00078ec0ffULL, 0x000000010d167824ULL, 0x000fe400078e0216ULL,
0x00009200ff148b82ULL, 0x000e620000000a00ULL, 0x0000000106178824ULL, 0x000fe400078e0217ULL,
0x00000000160472caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000176b004047890ULL, 0x000fe2000fffe03fULL, 0x0000000417148825ULL, 0x002fd000078e0014ULL,
0x00000000ff0079b0ULL, 0x000fe80008000a44ULL, 0x0000000614538981ULL, 0x000322000c1e1900ULL,
0x00000001ff177424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0176b017165679a7ULL, 0x000764000850003fULL, 0x01764817511479a7ULL, 0x022664000850003fULL,
0x0000000000167805ULL, 0x008fce0000015200ULL, 0x01764815510075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000003416377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e17ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01764815510075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000002040147824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x000001000d147810ULL, 0x000fc80007ffe014ULL,
0x0000001447147210ULL, 0x000fca0007ffe044ULL, 0x0170000014167984ULL, 0x000e680000000800ULL,
0x0172000014177984ULL, 0x0006e20000000800ULL, 0x000000551600720bULL, 0x002fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x00cfea0003800000ULL, 0x000000020a157836ULL, 0x000fe20000000000ULL,
0x000000551600720bULL, 0x000fc80003f14000ULL, 0x000000401500720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000804015a824ULL, 0x000fe200078e020dULL,
0x000000551614a209ULL, 0x000fc80007810000ULL, 0x000000154737a210ULL, 0x000fe40007ffe044ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400143700a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005516147209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005514147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160cULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000001554547220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080c147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005516557209ULL, 0x000fd60007810000ULL,
0x8000005516160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005417547221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x0000000840167824ULL, 0x000fca00078e00ffULL,
0xfffffff016167812ULL, 0x000fca00078ec0ffULL, 0x000000010d377824ULL, 0x000fc800078e0216ULL,
0x0176a859370075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176a859370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034147816ULL, 0x000fe200000000ffULL,
0x000130004e4e7836ULL, 0x000fc60000000000ULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x000000104f357824ULL, 0x000fd800078e024eULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160cULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x012000005014783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000104d3c7824ULL, 0x000fe200078e024eULL, 0x000000003534783bULL, 0x000f6a0000004200ULL,
0x000000003c3c783bULL, 0x000f640000004200ULL, 0x000000ff34517812ULL, 0x022fe400078ec0ffULL,
0x00000018ff507819ULL, 0x000fc40000011634ULL, 0x00000018ff587819ULL, 0x000fe40000011635ULL,
0x00000018ff5d7819ULL, 0x100fe40000011637ULL, 0x00000010ff647819ULL, 0x000fe40000011637ULL,
0x000000ff376c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff375f7812ULL, 0x000fe400078ec0ffULL,
0x00000051ff62723eULL, 0x000fc400020006ffULL, 0x00000010ff667819ULL, 0x100fe40000011636ULL,
0x000000ff365c7812ULL, 0x040fe200078ec0ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000018ff5a7819ULL, 0x000fe40000011636ULL, 0x0000ffff36657812ULL, 0x000fe400078ec0ffULL,
0x00000050ff37723eULL, 0x000fe400020006ffULL, 0x000000ff3c6d7812ULL, 0x008fc400078ec0ffULL,
0x00000010ff607819ULL, 0x100fe2000001163dULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x000000ff3d6e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff517819ULL, 0x000fe4000001163dULL,
0x0000ffff3d677812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5e7819ULL, 0x000fe4000001163eULL,
0x000000ff3e3d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff507819ULL, 0x000fe4000001163eULL,
0x0000ffff3e367812ULL, 0x000fe400078ec0ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000005dff3e723eULL, 0x000fe400020006ffULL, 0x00000010ff687819ULL, 0x100fe4000001163cULL,
0x00000018ff597819ULL, 0x000fc4000001163cULL, 0x0000ffff3c637812ULL, 0x000fe400078ec0ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x0000005aff3c723eULL, 0x000fe200020006ffULL,
0x20000058ff5a7230ULL, 0x000fe20000004100ULL, 0x00000018ff6b7819ULL, 0x000fe2000001163fULL,
0x2000003eff587230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff4d7819ULL, 0x000fc40000011635ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x2000005cff5d7230ULL, 0x000fe20000004100ULL,
0x0000ffff34617812ULL, 0x000fe400078ec0ffULL, 0x00000059ff3e723eULL, 0x000fe200020006ffULL,
0x2000006dff597230ULL, 0x000fe20000004100ULL, 0x000000ff3f6a7812ULL, 0x000fe200078ec0ffULL,
0x2000006cff5c7230ULL, 0x000fe20000004100ULL, 0x0000006bff6d723eULL, 0x000fe200020006ffULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x000000ff4d6b7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x0000006aff6c723eULL, 0x000fe400020006ffULL,
0x000000ff66667812ULL, 0x000fe400078ec0ffULL, 0x0000ffff35697812ULL, 0x000fe200078ec0ffULL,
0x2000006cff4d7230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x000000ff64647812ULL, 0x000fc400078ec0ffULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000008ff657819ULL, 0x000fe40000011665ULL,
0x00000008ff6c7819ULL, 0x000fe20000011669ULL, 0x2000006bff697230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000061ff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff4f7819ULL, 0x000fc40000011634ULL, 0x00000008ff5f7819ULL, 0x000fe4000001165fULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x00000065ff61723eULL, 0x000fe200020006ffULL,
0x20000066ff657230ULL, 0x000fe20000004100ULL, 0x000000ff35347812ULL, 0x000fe200078ec0ffULL,
0x20000064ff667230ULL, 0x000fe20000004100ULL, 0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fc400020006ffULL,
0x00000068ff64723eULL, 0x000fe400020006ffULL, 0x000000ff60687812ULL, 0x000fe400078ec0ffULL,
0x00000008ff607819ULL, 0x000fe20000011663ULL, 0x2000005fff637230ULL, 0x000fe20000004100ULL,
0x00000034ff35723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000008ff677819ULL, 0x000fe40000011667ULL, 0x0000004fff6a723eULL, 0x000fe200020006ffULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x00000060ff5f723eULL, 0x000fe200020006ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000050ff4f7230ULL, 0x000fe20000004100ULL,
0x00000067ff60723eULL, 0x000fe200020006ffULL, 0x2000006dff507230ULL, 0x000fe20000004100ULL,
0x000000ff5e677812ULL, 0x000fe200078ec0ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fe2000001163fULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x0000ffff3f5b7812ULL, 0x000fc400078ec0ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000051ff3f723eULL, 0x000fe400020006ffULL, 0x0000003dff51723eULL, 0x000fe200020006ffULL,
0x2000006eff3d7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000068ff5e7230ULL, 0x000fe20000004100ULL, 0x00000067ff6d723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x000000ff346e7812ULL, 0x000fe200078ec0ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe20000011635ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe20000011662ULL,
0x2000006dff627230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fc4000001166aULL,
0x00000010ff687819ULL, 0x000fe40000011669ULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x0000105468357816ULL, 0x000fe40000000067ULL, 0x00000008ff687819ULL, 0x000fe40000011636ULL,
0x00000010ff377819ULL, 0x000fe40000011637ULL, 0x00000010ff367819ULL, 0x000fe2000001166bULL,
0x000000341418723cULL, 0x000fe20000041818ULL, 0x00000010ff677819ULL, 0x000fc4000001165aULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x0000105467377816ULL, 0x000fe4000000006cULL, 0x00000010ff347819ULL, 0x000fe4000001165dULL,
0x00000010ff357819ULL, 0x000fe4000001165cULL, 0x00000010ff657819ULL, 0x000fe20000011665ULL,
0x000000361428723cULL, 0x000fe20000041828ULL, 0x00000010ff667819ULL, 0x000fc40000011666ULL,
0x00000008ff677819ULL, 0x000fe4000001165bULL, 0x0000105465347816ULL, 0x000fe40000000034ULL,
0x0000105466357816ULL, 0x000fe40000000035ULL, 0x00000010ff377819ULL, 0x000fe4000001163cULL,
0x00000010ff367819ULL, 0x000fe40000011661ULL, 0x00000010ff587819ULL, 0x000fe20000011658ULL,
0x00000034142c723cULL, 0x000fe2000004182cULL, 0x00000010ff637819ULL, 0x000fc40000011663ULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x2000006eff5a7230ULL, 0x000fe20000004100ULL,
0x0000105437367816ULL, 0x000fe20000000036ULL, 0x20000068ff5b7230ULL, 0x000fe20000004100ULL,
0x0000105458377816ULL, 0x000fe20000000063ULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fc4000001163eULL, 0x00000010ff3e7819ULL, 0x000fe4000001165fULL,
0x00000010ff347819ULL, 0x000fe2000001163fULL, 0x000000361430723cULL, 0x000fe20000041830ULL,
0x00000010ff3c7819ULL, 0x000fe40000011659ULL, 0x00000010ff3f7819ULL, 0x000fe40000011660ULL,
0x00001054353e7816ULL, 0x000fe4000000003eULL, 0x00000010ff597819ULL, 0x000fc40000011664ULL,
0x00000010ff3d7819ULL, 0x000fe4000001163dULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff357819ULL, 0x000fe4000001164dULL, 0x00000010ff4f7819ULL, 0x000fc4000001164fULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff367819ULL, 0x000fe4000001165bULL,
0x00000010ff507819ULL, 0x000fe40000011650ULL, 0x00000010ff377819ULL, 0x000fe40000011667ULL,
0x00001054343f7816ULL, 0x000fe4000000003fULL, 0x00001054593c7816ULL, 0x000fc4000000003cULL,
0x000010545e3d7816ULL, 0x000fe4000000003dULL, 0x0000105462347816ULL, 0x000fe20000000051ULL,
0x0000003e1420723cULL, 0x000fe20000041820ULL, 0x000010545a357816ULL, 0x000fe40000000035ULL,
0x000010544f367816ULL, 0x000fe40000000036ULL, 0x0000105450377816ULL, 0x000fe20000000037ULL,
0x0000003c1424723cULL, 0x000fec0000041824ULL, 0x00000034141c723cULL, 0x000fec000004181cULL,
0x000000361410723cULL, 0x000fe20000041810ULL, 0x000000104b357824ULL, 0x000fe200078e024eULL,
0x012000004a14783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000003534783bULL, 0x000f620000004200ULL,
0x00000010493c7824ULL, 0x000fcc00078e024eULL, 0x000000003c3c783bULL, 0x000f640000004200ULL,
0x00000010ff677819ULL, 0x022fe40000011635ULL, 0x00000010ff5d7819ULL, 0x000fe40000011636ULL,
0x000000ff344a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff67677812ULL, 0x000fe400078ec0ffULL,
0x000000ff5d5d7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff687819ULL, 0x000fe40000011634ULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x0000ffff34667812ULL, 0x000fe400078ec0ffULL,
0x000000ff354b7812ULL, 0x000fe200078ec0ffULL, 0x2000004aff647230ULL, 0x000fe20000004100ULL,
0x00000018ff6a7819ULL, 0x008fe4000001163dULL, 0x00000067ff67723eULL, 0x000fc400020006ffULL,
0x000000ff36507812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011636ULL,
0x00000010ff617819ULL, 0x100fe40000011637ULL, 0x000000ff375a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff597819ULL, 0x000fe40000011637ULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x0000ffff355e7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff36367812ULL, 0x000fe400078ec0ffULL,
0x0000ffff37377812ULL, 0x000fe400078ec0ffULL, 0x000000ff68687812ULL, 0x000fe400078ec0ffULL,
0x00000010ff627819ULL, 0x000fe4000001163cULL, 0x00000018ff497819ULL, 0x000fc40000011634ULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x00000010ff637819ULL, 0x000fe4000001163dULL,
0x0000006aff4a723eULL, 0x000fe200020006ffULL, 0x20000067ff6a7230ULL, 0x000fe20000004100ULL,
0x00000008ff667819ULL, 0x000fe20000011666ULL, 0x2000005dff677230ULL, 0x000fe20000004100ULL,
0x00000018ff347819ULL, 0x000fe20000011635ULL, 0x2000004bff657230ULL, 0x000fe20000004100ULL,
0x000000ff61617812ULL, 0x000fe200078ec0ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000018ff697819ULL, 0x000fc4000001163cULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000008ff5e7819ULL, 0x000fe4000001165eULL, 0x00000008ff367819ULL, 0x000fe40000011636ULL,
0x00000008ff377819ULL, 0x000fe40000011637ULL, 0x000000ff625d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3c5b7812ULL, 0x000fc400078ec0ffULL, 0x00000050ff50723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x000000ff63637812ULL, 0x000fe400078ec0ffULL,
0x00000049ff60723eULL, 0x000fe400020006ffULL, 0x00000034ff5f723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x0000ffff3c347812ULL, 0x000fe200078ec0ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff3d6b7812ULL, 0x000fc400078ec0ffULL, 0x00000069ff4b723eULL, 0x000fe200020006ffULL,
0x20000068ff697230ULL, 0x000fe20000004100ULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x20000066ff687230ULL, 0x000fe20000004100ULL, 0x00000036ff36723eULL, 0x000fe200020006ffULL,
0x20000061ff667230ULL, 0x000fe20000004100ULL, 0x00000037ff37723eULL, 0x000fe200020006ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x100fe2000001163eULL,
0x20000036ff617230ULL, 0x000fe20000004100ULL, 0x000000ff3e6c7812ULL, 0x000fe200078ec0ffULL,
0x20000037ff627230ULL, 0x000fe20000004100ULL, 0x00000018ff3c7819ULL, 0x000fc4000001163eULL,
0x0000ffff3e497812ULL, 0x000fe400078ec0ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000005bff3e723eULL, 0x000fe200020006ffULL, 0x20000050ff5b7230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x0000ffff3d357812ULL, 0x000fe400078ec0ffULL,
0x0000006bff50723eULL, 0x000fe200020006ffULL, 0x2000005eff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe20000011664ULL, 0x2000005dff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe20000011665ULL, 0x20000063ff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff697819ULL, 0x000fe20000011669ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000010ff6a7819ULL, 0x000fc4000001166aULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000008ff637819ULL, 0x000fe40000011634ULL, 0x00000008ff647819ULL, 0x000fe20000011635ULL,
0x2000005aff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe40000011660ULL,
0x00000010ff347819ULL, 0x000fe40000011668ULL, 0x0000105469367816ULL, 0x000fc40000000036ULL,
0x000010546a377816ULL, 0x000fe40000000037ULL, 0x00000010ff607819ULL, 0x000fe4000001165fULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x000000361418723cULL, 0x000fe20000041818ULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000105435347816ULL, 0x000fe20000000034ULL, 0x2000004fff5a7230ULL, 0x000fe20000004100ULL,
0x0000105460357816ULL, 0x000fe2000000006bULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe2000001165bULL, 0x2000003eff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fc4000001165cULL, 0x00000010ff677819ULL, 0x000fe20000011667ULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x0000105467367816ULL, 0x000fe40000000036ULL, 0x0000105466377816ULL, 0x000fe40000000037ULL,
0x00000010ff357819ULL, 0x000fe4000001165aULL, 0x00000010ff347819ULL, 0x000fc40000011661ULL,
0x00000010ff597819ULL, 0x000fe20000011659ULL, 0x00000036142c723cULL, 0x000fe2000004182cULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff587819ULL, 0x000fe4000001163fULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x0000105435347816ULL, 0x000fe20000000034ULL, 0x20000063ff5c7230ULL, 0x000fe20000004100ULL,
0x0000105459357816ULL, 0x000fe20000000062ULL, 0x20000064ff5b7230ULL, 0x000fe20000004100ULL,
0x000000ff3f6d7812ULL, 0x000fc400078ec0ffULL, 0x000000ff51517812ULL, 0x000fe400078ec0ffULL,
0x000000ff58587812ULL, 0x000fe200078ec0ffULL, 0x000000341430723cULL, 0x000fe20000041830ULL,
0x0000ffff3f4d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff367819ULL, 0x000fe4000001164fULL,
0x00000010ff377819ULL, 0x000fe4000001165eULL, 0x00000010ff507819ULL, 0x000fc40000011650ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000018ff3d7819ULL, 0x000fe4000001163fULL,
0x0000006cff3e723eULL, 0x000fe400020006ffULL, 0x0000006dff3f723eULL, 0x000fe400020006ffULL,
0x00000051ff51723eULL, 0x000fe200020006ffULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x0000105437367816ULL, 0x000fe20000000036ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000008ff4d7819ULL, 0x000fe2000001164dULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x000010545d377816ULL, 0x000fc40000000050ULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff347819ULL, 0x000fe2000001165cULL,
0x000000361424723cULL, 0x000fe20000041824ULL, 0x00000010ff357819ULL, 0x000fe4000001165bULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000008ff497819ULL, 0x000fc40000011649ULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x000010544b347816ULL, 0x000fe40000000034ULL, 0x000010544a357816ULL, 0x000fe20000000035ULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x00000010ff367819ULL, 0x000fe2000001163eULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe2000001163fULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe20000011651ULL,
0x000000341420723cULL, 0x000fe20000041820ULL, 0x00000010ff587819ULL, 0x000fe20000011658ULL,
0x00000002403e7824ULL, 0x000fe200078e00ffULL, 0x0000105451367816ULL, 0x000fc40000000036ULL,
0x0000105458377816ULL, 0x000fe40000000037ULL, 0x00000010ff347819ULL, 0x000fe4000001163dULL,
0x00000010ff3d7819ULL, 0x000fe4000001164dULL, 0x00000010ff357819ULL, 0x000fe2000001163cULL,
0x00000036141c723cULL, 0x000fe2000004181cULL, 0x00000010ff3c7819ULL, 0x000fe40000011649ULL,
0xfffffff83e3e7812ULL, 0x000fc400078ec0ffULL, 0x00001054343d7816ULL, 0x000fe2000000003dULL,
0x0000000838347824ULL, 0x000fe200078e020dULL, 0x00001054353c7816ULL, 0x000fe2000000003cULL,
0x00000001ff377424ULL, 0x000fe400078e00ffULL, 0x000000010d3e7824ULL, 0x000fe400078e023eULL,
0x0176c837343479a7ULL, 0x0002e4000850003fULL, 0x0000003c1410723cULL, 0x000fe20000041810ULL,
0x017698373eff79a7ULL, 0x0003de000850003fULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x00000035040075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x002fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035040075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x0000000105347836ULL, 0x000fe40000000000ULL, 0x0000000309097836ULL, 0x000fc60000000000ULL,
0x000000393400720cULL, 0x000fda0003f06070ULL, 0x0000000800080947ULL, 0x000fea0003800000ULL,
0x00009000ff147b82ULL, 0x000ee20000000a00ULL, 0x0000000205167836ULL, 0x000fe20000000000ULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x0000010034347824ULL, 0x000fe400078e0208ULL,
0x0000000453537c24ULL, 0x010fe2000f8e02ffULL, 0x000000391600720cULL, 0x000fe40003f06070ULL,
0x0000002034167812ULL, 0x000fe200078ec0ffULL, 0x0000004053537824ULL, 0x000fc800078e00ffULL,
0x000000010b3c7824ULL, 0x000fe400078e0216ULL, 0x0000008053147825ULL, 0x008fc800078e0014ULL,
0x0000000000f88947ULL, 0x000fea0003800000ULL, 0x000000343b097248ULL, 0x000fe20007fe0000ULL,
0x0000001040167824ULL, 0x000fe200078e00ffULL, 0x00000003ff177819ULL, 0x000fc6000001160cULL,
0x0000000109097824ULL, 0x000fe200078e0a34ULL, 0x0000001016167812ULL, 0x000fe200078ec0ffULL,
0x0000000417347836ULL, 0x000fe40000000000ULL, 0x0000000817367836ULL, 0x000fe20000000000ULL,
0x0000000916097248ULL, 0x000fe20007fe0000ULL, 0x0000000c17377836ULL, 0x002fe40000000000ULL,
0x0000000134357824ULL, 0x100fe400078e0216ULL, 0x0000000109097824ULL, 0x000fc400078e0a16ULL,
0x00000001363d7824ULL, 0x100fe400078e0216ULL, 0x00000001373f7824ULL, 0x100fe200078e0216ULL,
0x000000091700720cULL, 0x0c0fe20003f86070ULL, 0x0000000117177824ULL, 0x000fe200078e0216ULL,
0x000000093400720cULL, 0x080fe20003f66070ULL, 0x0000000135167824ULL, 0x000fe200078e020cULL,
0x000000093600720cULL, 0x080fe20003f46070ULL, 0x0000000117347824ULL, 0x000fe200078e023cULL,
0x000000093700720cULL, 0x000fe20003f06070ULL, 0x00000008354b7824ULL, 0x000fc400078e00ffULL,
0x0000000135367824ULL, 0x000fe400078e023cULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0xfffffff84b4b7812ULL, 0x000fc600078ee216ULL, 0x0000000117097824ULL, 0x140fe400078e020cULL,
0x00000008173e7824ULL, 0x000fe400078e00ffULL, 0x000000013d177824ULL, 0x040fe400078e020cULL,
0x000000083d4a7824ULL, 0x000fe200078e00ffULL, 0xfffffff83e497812ULL, 0x000fe200078ee209ULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff84a4d7812ULL, 0x000fe200078ee217ULL,
0x000000013d167824ULL, 0x100fe200078e023cULL, 0x00000044343d7212ULL, 0x080fe200078efcffULL,
0x000000013f3c7824ULL, 0x000fe200078e023cULL, 0x0000004436097212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000003d14347210ULL, 0x000fe40007fbe0ffULL,
0x0000000914367210ULL, 0x000fe20007fde0ffULL, 0x000000803c3c7825ULL, 0x000fc800078e00ffULL,
0x000000013f3e7824ULL, 0x040fe200078e020cULL, 0x000000443c097212ULL, 0x080fe200078efcffULL,
0x000000083f4f7824ULL, 0x000fe200078e00ffULL, 0x00000044163f7212ULL, 0x000fe200078efcffULL,
0x0000000115357824ULL, 0x040fe400028e0635ULL, 0x0000000115377824ULL, 0x000fe200030e0637ULL,
0x0000003f14167210ULL, 0x000fe20007fbe0ffULL, 0x0000001049497824ULL, 0x100fe200078e024eULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee23eULL, 0x000000104b4b7824ULL, 0x100fe200078e024eULL,
0x0000000914147210ULL, 0x000fe20007fde0ffULL, 0x000000104d4d7824ULL, 0x000fe200078e024eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034497faeULL, 0x0003e2000e101c46ULL,
0x0000000115177824ULL, 0x000fc400028e0617ULL, 0x000000104f4f7824ULL, 0x000fe200078e024eULL,
0x00000000364b7faeULL, 0x0003e2000d901c46ULL, 0x0000000115157824ULL, 0x000fc600030e063dULL,
0x00000000164d7faeULL, 0x0003e8000d101c46ULL, 0x00000000144f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001040097824ULL, 0x000fca00078e00ffULL,
0x0000001009097812ULL, 0x000fc800078ec0ffULL, 0x000000090c097211ULL, 0x000fca00078fe8ffULL,
0x0000000109177824ULL, 0x040fe400078e020cULL, 0x0000000809347824ULL, 0x040fe400078e00ffULL,
0x0000000109167824ULL, 0x000fe400078e023cULL, 0x0000000409357836ULL, 0x000fe20000000000ULL,
0xfffffff8343f7812ULL, 0x000fe200078ee217ULL, 0x00000008093d7836ULL, 0x000fe40000000000ULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x0000000c09497836ULL, 0x000fe20000000000ULL,
0x0000004416097212ULL, 0x000fe200078efcffULL, 0x0000000135347824ULL, 0x040fe400078e023cULL,
0x0000000135377824ULL, 0x142fe200078e020cULL, 0x0000000914167210ULL, 0x000fe20007f1e0ffULL,
0x00000008353e7824ULL, 0x000fe400078e00ffULL, 0x000000013d357824ULL, 0x040fe400078e020cULL,
0x000000083d4a7824ULL, 0x040fe200078e00ffULL, 0xfffffff83e097812ULL, 0x000fe200078ee237ULL,
0x000000013d367824ULL, 0x000fc400078e023cULL, 0x00000001493d7824ULL, 0x040fe200078e020cULL,
0xfffffff84a4f7812ULL, 0x000fe200078ee235ULL, 0x0000000849507824ULL, 0x040fe400078e00ffULL,
0x00000001493c7824ULL, 0x000fe400078e023cULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0xfffffff850517812ULL, 0x000fc600078ee23dULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004434497212ULL, 0x000fc600078efcffULL, 0x000000803c3c7825ULL, 0x000fc800078e00ffULL,
0x000000103f4b7824ULL, 0x100fe200078e024eULL, 0x00000044363f7212ULL, 0x080fe200078efcffULL,
0x00000010094d7824ULL, 0x100fe200078e024eULL, 0x000000443c097212ULL, 0x000fe200078efcffULL,
0x0000000115177824ULL, 0x000fe200000e0617ULL, 0x0000004914347210ULL, 0x000fe20007f1e0ffULL,
0x000000104f4f7824ULL, 0x100fe200078e024eULL, 0x0000003f14367210ULL, 0x000fe20007f5e0ffULL,
0x0000001051517824ULL, 0x000fe200078e024eULL, 0x0000000914147210ULL, 0x000fe20007f7e0ffULL,
0x0000000115357824ULL, 0x040fe200000e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000164b7faeULL, 0x0003e2000b901c46ULL, 0x0000000115377824ULL, 0x000fc400010e0637ULL,
0x0000000115157824ULL, 0x000fe200018e063dULL, 0x00000000344d7faeULL, 0x0003e8000b901c46ULL,
0x00000000364f7faeULL, 0x0003e8000b901c46ULL, 0x0000000014517faeULL, 0x0003e4000b901c46ULL,
0x0000000445097836ULL, 0x000fe40000000000ULL, 0xffffffffff537424ULL, 0x000fc600078e00ffULL,
0x0000003a0900720cULL, 0x000fda0003f06070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x00009200ff147b82ULL, 0x002e620000000a00ULL, 0x0000000106177824ULL, 0x000fc800078e0209ULL,
0x0000000417147825ULL, 0x002fca00078e0014ULL, 0x0000000614537981ULL, 0x000324000c1e1900ULL,
0x0000000840147824ULL, 0x002fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0xfffffff014147812ULL, 0x000fca00078ec0ffULL, 0x000000010d147824ULL, 0x000fca00078e0214ULL,
0x00000000140472caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000176a804047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0176a834141479a7ULL, 0x0002e4000850003fULL,
0x01766834073479a7ULL, 0x0022a4000850003fULL, 0x000000ffff497224ULL, 0x00afce00078e0015ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x01766835070075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01766835070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000800a157824ULL, 0x000fe400078e020dULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0x0000018044147810ULL, 0x000fca0007ffe015ULL, 0x0000000147147824ULL, 0x000fca00078e0214ULL,
0x0170000014167984ULL, 0x000e680000000800ULL, 0x0172000014177984ULL, 0x0004a20000000800ULL,
0x000000551600720bULL, 0x002fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15357812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x004fea0003800000ULL,
0x000000030a157836ULL, 0x000fe20000000000ULL, 0x000000551600720bULL, 0x000fc80003f14000ULL,
0x000000401500720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x000000804015a824ULL, 0x000fe200078e020dULL, 0x000000551614a209ULL, 0x000fc80007810000ULL,
0x000000154747a210ULL, 0x000fe40007ffe044ULL, 0x0000991034157816ULL, 0x000fc600000000ffULL,
0x017400144700a388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005516147209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x0000005514147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400157308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x002fcc000001160cULL, 0x00001f1415147589ULL, 0x004e6400000e0000ULL,
0x0000001814187220ULL, 0x042fe20000410000ULL, 0x0000001914197220ULL, 0x040fe20000410000ULL,
0x0000002814287220ULL, 0x040fe20000410000ULL, 0x0000002914297220ULL, 0x040fe20000410000ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000002d142d7220ULL, 0x040fe20000410000ULL,
0x0000003014307220ULL, 0x040fe20000410000ULL, 0x0000003114317220ULL, 0x040fe20000410000ULL,
0x0000002414247220ULL, 0x040fe20000410000ULL, 0x0000002514257220ULL, 0x040fe20000410000ULL,
0x0000002014207220ULL, 0x040fe20000410000ULL, 0x0000002114217220ULL, 0x040fe20000410000ULL,
0x0000001c141c7220ULL, 0x040fe20000410000ULL, 0x0000001d141d7220ULL, 0x040fe20000410000ULL,
0x0000001014107220ULL, 0x040fe20000410000ULL, 0x0000001114117220ULL, 0x000fce0000410000ULL,
0x0000001554547220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080c147811ULL, 0x002fcc00078ff0ffULL, 0x00001f1415147589ULL, 0x000e6400000e0000ULL,
0x0000001a141a7220ULL, 0x042fe20000410000ULL, 0x0000001b141b7220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000003214327220ULL, 0x040fe20000410000ULL, 0x0000003314337220ULL, 0x040fe20000410000ULL,
0x0000002614267220ULL, 0x040fe20000410000ULL, 0x0000002714277220ULL, 0x040fe20000410000ULL,
0x0000002214227220ULL, 0x040fe20000410000ULL, 0x0000002314237220ULL, 0x040fe20000410000ULL,
0x0000001e141e7220ULL, 0x040fe20000410000ULL, 0x0000001f141f7220ULL, 0x040fe20000410000ULL,
0x0000001214127220ULL, 0x040fe20000410000ULL, 0x0000001314137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000005516557209ULL, 0x000fd60007810000ULL, 0x8000005516160221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL,
0x0000001600020308ULL, 0x000ea40000000800ULL, 0x0000000217170220ULL, 0x004fce0000410000ULL,
0x0000005417547221ULL, 0x000fce0000010000ULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x0000000840167824ULL, 0x000fca00078e00ffULL, 0xfffffff016167812ULL, 0x000fca00078ec0ffULL,
0x000000010d377824ULL, 0x000fc800078e0216ULL, 0x0176b057370075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176b057370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991034147816ULL, 0x000fe200000000ffULL, 0x0000000440167824ULL, 0x000fe200078e00ffULL,
0x000000080c457812ULL, 0x000fe200078ec0ffULL, 0x000008000a157824ULL, 0x000fe200078e020dULL,
0x000000ff1400720cULL, 0x000fe40003f05270ULL, 0x0000000416167812ULL, 0x000fe200078ec0ffULL,
0x0000001046157824ULL, 0x000fc600078e0215ULL, 0x00000002163d7812ULL, 0x000fce00078efcffULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160cULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803177836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1714007589ULL, 0x0002e400000e0000ULL, 0x012800001514783bULL, 0x002e620000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x086fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x088fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x0000000745457812ULL, 0x000fe200078ef80cULL,
0x000000004c34783bULL, 0x000f620000004200ULL, 0x0000003d0c447211ULL, 0x040fe200078fe0ffULL,
0x0000000242427836ULL, 0x000fe20000000000ULL, 0x000000070c477812ULL, 0x000fe200078ec0ffULL,
0x00000008453d7824ULL, 0x040fe400078e00ffULL, 0x00000001453c7824ULL, 0x000fe200078e0244ULL,
0x0000000847477812ULL, 0x000fe200078ef80cULL, 0x000000030a467836ULL, 0x000fc60000000000ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee23cULL, 0x0000000847477824ULL, 0x000fc800078e00ffULL,
0x000000103d3d7824ULL, 0x000fe200078e0248ULL, 0xfffffff847427812ULL, 0x000fe200078ee242ULL,
0x0000080046477824ULL, 0x000fc800078e020dULL, 0x000000003d3c783bULL, 0x000f620000004200ULL,
0x0000001042427824ULL, 0x000fe200078e0247ULL, 0x00000018ff467819ULL, 0x128fe40000011634ULL,
0x000000ff364f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4b7819ULL, 0x000fe40000011634ULL,
0x000000ff34477812ULL, 0x040fe400078ec0ffULL, 0x0000ffff34617812ULL, 0x000fc400078ec0ffULL,
0x000000ff37587812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4a7819ULL, 0x100fe40000011635ULL,
0x000000ff35347812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011635ULL,
0x0000ffff35607812ULL, 0x000fe400078ec0ffULL, 0x00000018ff507819ULL, 0x000fc40000011637ULL,
0x00000046ff35723eULL, 0x000fe400020006ffULL, 0x00000010ff597819ULL, 0x104fe4000001163cULL,
0x000000ff3c637812ULL, 0x040fe200078ec0ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000018ff467819ULL, 0x000fe4000001163cULL, 0x0000ffff3c5c7812ULL, 0x000fe400078ec0ffULL,
0x0000004fff4f723eULL, 0x000fc400020006ffULL, 0x00000010ff5f7819ULL, 0x100fe40000011636ULL,
0x00000018ff4d7819ULL, 0x000fe40000011636ULL, 0x0000ffff36567812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5d7819ULL, 0x100fe4000001163dULL, 0x000000ff3d657812ULL, 0x000fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fc4000001163dULL, 0x0000ffff3d5e7812ULL, 0x000fe400078ec0ffULL,
0x00000058ff3c723eULL, 0x000fe400020006ffULL, 0x00000010ff367819ULL, 0x100fe4000001163fULL,
0x000000ff3f677812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001163fULL,
0x0000ffff3f4e7812ULL, 0x000fc400078ec0ffULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x00000050ff3f723eULL, 0x000fe200020006ffULL, 0x2000004fff507230ULL, 0x000fe20000004100ULL,
0x00000008ff567819ULL, 0x000fe20000011656ULL, 0x2000003cff4f7230ULL, 0x000fe20000004100ULL,
0x00000018ff627819ULL, 0x000fe2000001163eULL, 0x2000004cff587230ULL, 0x000fe20000004100ULL,
0x00000065ff3c723eULL, 0x000fe200020006ffULL, 0x2000003fff4c7230ULL, 0x000fe20000004100ULL,
0x00000010ff577819ULL, 0x000fc40000011637ULL, 0x00000034ff5b723eULL, 0x000fe200020006ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL,
0x0000003dff65723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000ffff37377812ULL, 0x000fe400078ec0ffULL, 0x00000010ff517819ULL, 0x000fe4000001163eULL,
0x000000ff3e667812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3e347812ULL, 0x000fe400078ec0ffULL,
0x00000046ff3f723eULL, 0x000fe400020006ffULL, 0x0000004dff3e723eULL, 0x000fe400020006ffULL,
0x00000064ff46723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000063ff4d723eULL, 0x000fe200020006ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x00000062ff64723eULL, 0x000fc400020006ffULL, 0x0000004bff62723eULL, 0x000fe200020006ffULL,
0x20000065ff4b7230ULL, 0x000fe20000004100ULL, 0x000000ff4a637812ULL, 0x000fe200078ec0ffULL,
0x20000064ff4a7230ULL, 0x000fe20000004100ULL, 0x00000008ff617819ULL, 0x000fe20000011661ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000008ff377819ULL, 0x000fe20000011637ULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x00000008ff607819ULL, 0x000fe40000011660ULL,
0x000000ff59657812ULL, 0x000fe200078ec0ffULL, 0x20000056ff597230ULL, 0x000fe20000004100ULL,
0x000000ff57577812ULL, 0x000fc400078ec0ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000008ff567819ULL, 0x000fe4000001165cULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000063ff647230ULL, 0x000fe20000004100ULL, 0x00000037ff37723eULL, 0x000fe400020006ffULL,
0x00000008ff5e7819ULL, 0x000fe2000001165eULL, 0x20000061ff637230ULL, 0x000fe20000004100ULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x20000037ff5c7230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x20000047ff5a7230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x20000060ff617230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000057ff607230ULL, 0x000fe20000004100ULL, 0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x000000ff51377812ULL, 0x000fe200078ec0ffULL,
0x20000056ff517230ULL, 0x000fe20000004100ULL, 0x0000005dff57723eULL, 0x000fe200020006ffULL,
0x20000065ff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL,
0x2000005eff567230ULL, 0x000fe20000004100ULL, 0x00000037ff5e723eULL, 0x000fe200020006ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x000000ff36657812ULL, 0x000fc400078ec0ffULL,
0x00000010ff367819ULL, 0x000fe2000001165aULL, 0x2000005eff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe40000011662ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000105437367816ULL, 0x000fc40000000036ULL, 0x0000105464377816ULL, 0x000fe2000000005bULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff5b7819ULL, 0x000fe40000011634ULL,
0x00000010ff357819ULL, 0x000fe40000011635ULL, 0x00000010ff347819ULL, 0x000fe20000011663ULL,
0x000000361418723cULL, 0x002fe20000041818ULL, 0x00000010ff5e7819ULL, 0x000fe40000011658ULL,
0x00000010ff617819ULL, 0x000fc40000011661ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff367819ULL, 0x000fe40000011650ULL, 0x00000010ff377819ULL, 0x000fe4000001164fULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x00000066ff47723eULL, 0x000fc400020006ffULL, 0x000010545e357816ULL, 0x000fe40000000061ULL,
0x000010545f367816ULL, 0x000fe20000000036ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x0000105460377816ULL, 0x000fe40000000037ULL, 0x00000008ff5e7819ULL, 0x000fe2000001164eULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x20000067ff3d7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe2000001163eULL,
0x20000065ff587230ULL, 0x000fe20000004100ULL, 0x00000010ff4f7819ULL, 0x000fe2000001164cULL,
0x2000005bff4e7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe2000001163fULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff3e7819ULL, 0x000fc4000001164dULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff3f7819ULL, 0x000fe40000011657ULL,
0x00000010ff347819ULL, 0x000fe40000011659ULL, 0x00000010ff4c7819ULL, 0x000fe40000011647ULL,
0x00000010ff4d7819ULL, 0x000fe4000001165aULL, 0x00000010ff5c7819ULL, 0x000fc4000001165cULL,
0x000010543f3f7816ULL, 0x000fe4000000003cULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x000010544d3c7816ULL, 0x000fe4000000004cULL, 0x000010544f357816ULL, 0x000fe4000000005cULL,
0x00000010ff367819ULL, 0x000fe40000011646ULL, 0x00000010ff4d7819ULL, 0x000fc4000001164aULL,
0x00000010ff5d7819ULL, 0x000fe2000001165dULL, 0x000000341430723cULL, 0x000fe20000041830ULL,
0x00000010ff467819ULL, 0x000fe40000011651ULL, 0x00000010ff477819ULL, 0x000fe40000011656ULL,
0x00000010ff3d7819ULL, 0x000fe4000001163dULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff4e7819ULL, 0x000fc4000001164eULL, 0x00000010ff4a7819ULL, 0x000fe4000001164bULL,
0x00000010ff4f7819ULL, 0x000fe4000001165eULL, 0x000010545d3e7816ULL, 0x000fe4000000003eULL,
0x0000105437467816ULL, 0x000fe40000000046ULL, 0x0000105436477816ULL, 0x000fe40000000047ULL,
0x00001054583d7816ULL, 0x000fe2000000003dULL, 0x011000004234783bULL, 0x0002a20000000200ULL,
0x000010544d4e7816ULL, 0x000fe2000000004eULL, 0x0000003e1424723cULL, 0x000fe20000041824ULL,
0x000010544a4f7816ULL, 0x000fca000000004fULL, 0x000000461420723cULL, 0x000fec0000041820ULL,
0x0000003c141c723cULL, 0x000fec000004181cULL, 0x0000004e1410723cULL, 0x000fe20000041810ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000100947ULL, 0x002fde0003800000ULL,
0x0000000334347232ULL, 0x084fe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x0000001045457812ULL, 0x000fe200078efcffULL, 0x000000005214783bULL, 0x000e620000004200ULL,
0x0000000105057836ULL, 0x000fc60000000000ULL, 0x0000000145447824ULL, 0x040fe400078e0244ULL,
0x00000008453d7824ULL, 0x000fca00078e00ffULL, 0xfffffff83d3d7812ULL, 0x000fca00078ee244ULL,
0x000000103d3d7824ULL, 0x000fcc00078e0248ULL, 0x000000003d3c783bULL, 0x000ee20000004200ULL,
0x000000ff15527812ULL, 0x002fe400078ec0ffULL, 0x00000010ff4e7819ULL, 0x100fe40000011614ULL,
0x000000ff14507812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011614ULL,
0x0000ffff145f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff517819ULL, 0x000fc40000011615ULL,
0x00000018ff567819ULL, 0x000fe40000011615ULL, 0x0000ffff15607812ULL, 0x000fe400078ec0ffULL,
0x00000010ff597819ULL, 0x100fe40000011616ULL, 0x000000ff16577812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fe40000011616ULL, 0x0000ffff16587812ULL, 0x000fc400078ec0ffULL,
0x00000010ff5a7819ULL, 0x100fe40000011617ULL, 0x000000ff175e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011617ULL, 0x0000ffff17157812ULL, 0x000fe400078ec0ffULL,
0x00000010ff477819ULL, 0x008fe4000001163cULL, 0x000000ff3c147812ULL, 0x000fc400078ec0ffULL,
0x00000018ff167819ULL, 0x000fe4000001163cULL, 0x0000ffff3c427812ULL, 0x000fe400078ec0ffULL,
0x00000010ff487819ULL, 0x100fe4000001163dULL, 0x000000ff3d177812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001163dULL, 0x0000ffff3d447812ULL, 0x000fc400078ec0ffULL,
0x00000052ff3d723eULL, 0x000fe400020006ffULL, 0x00000057ff5c723eULL, 0x000fe400020006ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x0000004fff52723eULL, 0x000fe200020006ffULL,
0x2000003dff4f7230ULL, 0x000fe20000004100ULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x2000005cff3d7230ULL, 0x000fe20000004100ULL, 0x000000ff4e4e7812ULL, 0x000fe200078ec0ffULL,
0x20000050ff577230ULL, 0x000fe20000004100ULL, 0x000000ff515c7812ULL, 0x000fe200078ec0ffULL,
0x2000005bff517230ULL, 0x000fe20000004100ULL, 0x0000005eff50723eULL, 0x000fe200020006ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x0000005dff5e723eULL, 0x000fc400020006ffULL,
0x000000ff59597812ULL, 0x000fe200078ec0ffULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL, 0x0000004eff5b723eULL, 0x000fe200020006ffULL,
0x2000005eff4e7230ULL, 0x000fe20000004100ULL, 0x0000005cff5d723eULL, 0x000fe400020006ffULL,
0x00000008ff587819ULL, 0x000fe20000011658ULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000008ff5c7819ULL, 0x000fe2000001165fULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x0000005aff5f723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x20000059ff5a7230ULL, 0x000fe20000004100ULL,
0x00000008ff157819ULL, 0x000fe40000011615ULL, 0x00000008ff5e7819ULL, 0x000fe20000011660ULL,
0x2000005fff607230ULL, 0x000fe20000004100ULL, 0x00000015ff59723eULL, 0x000fe200020006ffULL,
0x20000058ff5f7230ULL, 0x000fe20000004100ULL, 0x00000014ff61723eULL, 0x000fc400020006ffULL,
0x00000010ff147819ULL, 0x000fe20000011657ULL, 0x20000059ff577230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe2000001164fULL, 0x20000061ff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff587819ULL, 0x000fe4000001165dULL,
0x000010545b147816ULL, 0x000fe40000000014ULL, 0x0000105458157816ULL, 0x000fc40000000015ULL,
0x00000016ff58723eULL, 0x000fe400020006ffULL, 0x00000017ff5b723eULL, 0x000fe400020006ffULL,
0x00000010ff177819ULL, 0x000fe20000011652ULL, 0x20000058ff527230ULL, 0x000fe20000004100ULL,
0x0000003cff58723eULL, 0x000fe200020006ffULL, 0x000000143418723cULL, 0x004fe20000041818ULL,
0x00000010ff3c7819ULL, 0x000fe4000001163dULL, 0x00000056ff56723eULL, 0x000fc400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000010ff157819ULL, 0x000fe2000001165aULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff47477812ULL, 0x000fe400078ec0ffULL,
0x000000ff48487812ULL, 0x000fe200078ec0ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00001054153c7816ULL, 0x000fc4000000003cULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff147819ULL, 0x000fe4000001165fULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff157819ULL, 0x000fe40000011657ULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000048ff48723eULL, 0x000fc400020006ffULL, 0x0000105451147816ULL, 0x000fe20000000014ULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x000010544e157816ULL, 0x000fe20000000015ULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000008ff447819ULL, 0x000fe40000011644ULL, 0x00000010ff597819ULL, 0x000fe20000011656ULL,
0x2000005bff567230ULL, 0x000fe20000004100ULL, 0x00000010ff3d7819ULL, 0x000fe20000011650ULL,
0x000000143430723cULL, 0x000fe20000041830ULL, 0x00000010ff607819ULL, 0x000fe20000011660ULL,
0x20000058ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff167819ULL, 0x000fc4000001165cULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x00000010ff457819ULL, 0x100fe2000001163eULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x000000ff3e4b7812ULL, 0x000fe200078ec0ffULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x00000018ff4c7819ULL, 0x000fc4000001163eULL,
0x00001054603d7816ULL, 0x000fe4000000003dULL, 0x0000ffff3e3e7812ULL, 0x000fe400078ec0ffULL,
0x0000105417167816ULL, 0x000fe40000000016ULL, 0x0000105459177816ULL, 0x000fe2000000005eULL,
0x0000003c342c723cULL, 0x000fe2000004182cULL, 0x00000010ff147819ULL, 0x000fe4000001164fULL,
0x00000010ff157819ULL, 0x000fc40000011656ULL, 0x00000010ff477819ULL, 0x000fe20000011647ULL,
0x000000163428723cULL, 0x000fe20000041828ULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff467819ULL, 0x100fe4000001163fULL, 0x000000ff3f4d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001163fULL, 0x0000ffff3f3f7812ULL, 0x000fc400078ec0ffULL,
0x000000ff45457812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3e7819ULL, 0x000fe4000001163eULL,
0x0000105447147816ULL, 0x000fe40000000014ULL, 0x0000105448157816ULL, 0x000fe40000000015ULL,
0x00000008ff477819ULL, 0x000fe4000001163fULL, 0x00000010ff3d7819ULL, 0x000fc40000011652ULL,
0x00000010ff3c7819ULL, 0x000fe20000011642ULL, 0x000000143424723cULL, 0x000fe20000041824ULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000010ff3f7819ULL, 0x000fe40000011650ULL,
0x00000010ff447819ULL, 0x000fe20000011644ULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x0000004bff4b723eULL, 0x000fc400020006ffULL,
0x0000004cff16723eULL, 0x000fe200020006ffULL, 0x2000003eff157230ULL, 0x000fe20000004100ULL,
0x000010543d3c7816ULL, 0x000fe2000000003cULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x000010543f3d7816ULL, 0x000fe20000000044ULL, 0x20000016ff167230ULL, 0x000fe20000004100ULL,
0x000000ff46467812ULL, 0x000fe400078ec0ffULL, 0x00000010ff147819ULL, 0x000fe40000011645ULL,
0x00000010ff157819ULL, 0x000fe20000011615ULL, 0x0000003c3420723cULL, 0x000fe20000041820ULL,
0x0000004dff17723eULL, 0x000fc400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000010ff4b7819ULL, 0x000fe2000001164bULL, 0x20000017ff177230ULL, 0x000fe20000004100ULL,
0x00000010ff167819ULL, 0x000fe20000011616ULL, 0x00000001ff3d7424ULL, 0x000fe200078e00ffULL,
0x00001054143e7816ULL, 0x000fe2000000004bULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x0000105416167816ULL, 0x000fe40000000015ULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x0000003d041479a7ULL, 0x0002a2000850003fULL, 0x00000047ff47723eULL, 0x000fc400020006ffULL,
0x00000010ff177819ULL, 0x000fe20000011617ULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff467819ULL, 0x000fe20000011646ULL, 0x20000047ff477230ULL, 0x000fc60000004100ULL,
0x00001054463f7816ULL, 0x000fe20000000017ULL, 0x000000080a047824ULL, 0x002fe200078e020dULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff177819ULL, 0x000fe20000011647ULL,
0x0176a03d04ff79a7ULL, 0x0003e4000850003fULL, 0x0000003e341c723cULL, 0x000fe2000004181cULL,
0x000010544a177816ULL, 0x000fce0000000017ULL, 0x000000163410723cULL, 0x000fee0000041810ULL,
0x000000ffff347224ULL, 0x004fe200078e0015ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0xffffff5000bc9947ULL, 0x002fde000383ffffULL, 0x000000ff3900720cULL, 0x000fda0003f05270ULL,
0x0000000000d48947ULL, 0x000fea0003800000ULL, 0x0180000054007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000cb0000047802ULL, 0x002fce0000000f00ULL, 0x0000008800f47944ULL, 0x01cfea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000005400037308ULL, 0x008ee40000001000ULL,
0xbf80000003007423ULL, 0x008fc80000000054ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009a00ff027b82ULL, 0x000f640000000a00ULL, 0x0000000602037981ULL, 0x02aee2000c1e9900ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x00cfca0000410000ULL,
0x00001f0700047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea200000e0000ULL,
0x0000001804187220ULL, 0x042fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000001004107220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x000fe20000410000ULL,
0x0000001a051a7220ULL, 0x044fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000001305137220ULL, 0x000fce0000410000ULL,
0x0000000000037919ULL, 0x008ee20000000000ULL, 0x0000000140407812ULL, 0x000fe400078ec0ffULL,
0x000000202120723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00001000400d7824ULL, 0x000fe200078e020dULL, 0x0000001c1d1c723eULL, 0x000fc400000010ffULL,
0x000000101110723eULL, 0x000fe400000010ffULL, 0x0000002e2f2e723eULL, 0x000fe400000010ffULL,
0x000000262726723eULL, 0x000fe400000010ffULL, 0x000000222322723eULL, 0x000fe400000010ffULL,
0x0000001e1f1e723eULL, 0x000fe400000010ffULL, 0x000000121312723eULL, 0x000fc400000010ffULL,
0x00007632261d7816ULL, 0x000fe40000000022ULL, 0x000076321e217816ULL, 0x000fe40000000012ULL,
0x000000ff3800720cULL, 0x000fe40003f05270ULL, 0x00000002ff057819ULL, 0x108fe20000011603ULL,
0x0000000108087824ULL, 0x000fe200078e0203ULL, 0x0000000203007812ULL, 0x040fe400078ec0ffULL,
0x0000000803077811ULL, 0x000fe200078ff0ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000500027211ULL, 0x000fe200078ff8ffULL, 0x0000001008087824ULL, 0x000fe200078e020dULL,
0x0000000700047211ULL, 0x002fe200078ff8ffULL, 0x0000000807097824ULL, 0x000fc400078e00ffULL,
0x0000000805077824ULL, 0x040fe400078e00ffULL, 0x0000000202007836ULL, 0x000fe20000000000ULL,
0xfffffff809147812ULL, 0x000fe200078ee204ULL, 0x0000000805097824ULL, 0x000fe400078e00ffULL,
0x0000000402047836ULL, 0x000fe20000000000ULL, 0xfffffff807067812ULL, 0x000fe200078ee200ULL,
0x0000080038057824ULL, 0x000fe200078e020dULL, 0xfffffff807007812ULL, 0x000fe200078ee202ULL,
0x0000000602077836ULL, 0x000fe20000000000ULL, 0xfffffff8090a7812ULL, 0x000fe200078ee204ULL,
0x0000000803027824ULL, 0x000fc400078e00ffULL, 0x0000001000047824ULL, 0x100fe200078e0205ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x0000001014147824ULL, 0x100fe200078e0205ULL,
0x0000000802077812ULL, 0x000fe200078ec0ffULL, 0x0000001006067824ULL, 0x100fe200078e0205ULL,
0x000000181900723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x100fe200078e0205ULL,
0x000000282902723eULL, 0x000fe200000010ffULL, 0x000000100c0c7824ULL, 0x000fe400078e0205ULL,
0x0000000104057824ULL, 0x000fe200078e0207ULL, 0x0000541000167816ULL, 0x040fe20000000002ULL,
0x0000000107067824ULL, 0x040fe200078e0206ULL, 0x0000763200177816ULL, 0x000fe20000000002ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x0000002c2d00723eULL, 0x000fe200000010ffULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x000000303102723eULL, 0x000fe200000010ffULL,
0x0000001605007388ULL, 0x0003e20000000a00ULL, 0x000000242504723eULL, 0x000fe200000010ffULL,
0x0000000107147824ULL, 0x000fc600078e0214ULL, 0x0000541004187816ULL, 0x140fe40000000020ULL,
0x0000763204197816ULL, 0x000fe40000000020ULL, 0x000054101c047816ULL, 0x000fe40000000010ULL,
0x000054101e207816ULL, 0x000fe40000000012ULL, 0x0000541000167816ULL, 0x142fe40000000002ULL,
0x0000763200177816ULL, 0x000fc40000000002ULL, 0x000076321c057816ULL, 0x000fe40000000010ULL,
0x0000001a1b00723eULL, 0x000fe200000010ffULL, 0x0000001606007388ULL, 0x0003e20000000a00ULL,
0x0000002a2b02723eULL, 0x000fe400000010ffULL, 0x00005410261c7816ULL, 0x000fe20000000022ULL,
0x000000180a007388ULL, 0x000fe80000000a00ULL, 0x000000040c007388ULL, 0x0007e20000000a00ULL,
0x000000323317723eULL, 0x002fc800000010ffULL, 0x000054102e167816ULL, 0x140fe40000000017ULL,
0x000076322e177816ULL, 0x000fe40000000017ULL, 0x0000541000047816ULL, 0x148fe40000000002ULL,
0x0000763200057816ULL, 0x000fe40000000002ULL, 0x000000ff00007306ULL, 0x000e660000202400ULL,
0x0000000414007388ULL, 0x000fe80000000a00ULL, 0x0004001606007388ULL, 0x000fe80000000a00ULL,
0x0004001c0a007388ULL, 0x000fe80000000a00ULL, 0x000400200c007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000008107984ULL, 0x000e680000000c00ULL,
0x0004000008147984ULL, 0x000ee80000000c00ULL, 0x0008000008047984ULL, 0x000f680000000c00ULL,
0x000c000008187984ULL, 0x000f620000000c00ULL, 0x0000001300137230ULL, 0x002fc40000200800ULL,
0x0000001200127230ULL, 0x040fe40000200800ULL, 0x0000001100117230ULL, 0x040fe40000200800ULL,
0x0000001000107230ULL, 0x040fe40000200800ULL, 0x0000001700177230ULL, 0x048fe40000200800ULL,
0x0000001600167230ULL, 0x040fe40000200800ULL, 0x0000001500157230ULL, 0x000fc40000200800ULL,
0x0000001400007230ULL, 0x000fe40000200800ULL, 0x0000000713137230ULL, 0x024fe40000200000ULL,
0x0000000612127230ULL, 0x000fe40000200000ULL, 0x0000000511117230ULL, 0x000fe40000200000ULL,
0x0000000410107230ULL, 0x000fe40000200000ULL, 0x0000001b17177230ULL, 0x000fc40000200000ULL,
0x0000001a16167230ULL, 0x000fe20000200000ULL, 0x0000001008007388ULL, 0x0003e20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000200000ULL, 0x0000001800147230ULL, 0x000fca0000200000ULL,
0x0004001408007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff027819ULL, 0x000fc80000011603ULL,
0x0000000f0200720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x0000000800067d06ULL, 0x000ea20008209000ULL, 0x0000000141007824ULL, 0x000fe200078e0202ULL,
0x00000008ff137c12ULL, 0x002fe2000f8e33ffULL, 0x0000000102027824ULL, 0x000fe200078e0203ULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x00008a0000047ab9ULL, 0x000fc60000000a00ULL,
0x0000000702027812ULL, 0x000fc800078ec0ffULL, 0x0ffffff802027812ULL, 0x000fe200078ef803ULL,
0x0000000600067308ULL, 0x004e680000001000ULL, 0x0000001002027824ULL, 0x000fe400078e020dULL,
0x0ffffffe06077836ULL, 0x002fc80000000000ULL, 0x0000000700057305ULL, 0x000e64000021f000ULL,
0x000000ffff097224ULL, 0x002fc800078e0a05ULL, 0x0000000809097c24ULL, 0x000fc8000f8e02ffULL,
0x0000000905117227ULL, 0x000fe400078e0004ULL, 0x0000000002087984ULL, 0x0002a80000000c00ULL,
0x0000000011047227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a04ULL,
0x0000000805057c24ULL, 0x000fca000f8e0200ULL, 0x0000000805007c0cULL, 0x000fda000bf06070ULL,
0x8000000805050c36ULL, 0x000fe40008000000ULL, 0x0000000104040836ULL, 0x000fe20000000000ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05070ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x0000000104041836ULL, 0x000fca0000000000ULL, 0x0000000413047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000000904057c24ULL, 0x000fe4000f8e0243ULL,
0x0000000807007c24ULL, 0x000fe2000f8e0200ULL, 0x0000000703077812ULL, 0x000fc600078ec0ffULL,
0x0000000805057c24ULL, 0x000fe4000f8e0200ULL, 0x0000002003007836ULL, 0x000fe40000000000ULL,
0x0000000840077824ULL, 0x000fe200078e0207ULL, 0x000000050e057210ULL, 0x000fe40007f3e0ffULL,
0x00000003ff027819ULL, 0x002fc60000011600ULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4406ULL,
0x0000000f0200720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000141047824ULL, 0x102fe400078e0202ULL, 0x0000000100027824ULL, 0x000fe400078e0202ULL,
0x0000000411067227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a06ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x8000000805051c36ULL, 0x000fe40008000000ULL, 0x0000000106061836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fe4000bf46070ULL, 0x0000000702057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805027812ULL, 0x000fca00078ef800ULL, 0x0000001002027824ULL, 0x000fe400078e020dULL,
0x0000000106062836ULL, 0x000fc60000000000ULL, 0x0000000002087984ULL, 0x0002a40000000c00ULL,
0x0000000613067207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x0000000906057c24ULL, 0x000fe4000f8e0243ULL, 0x0000000807047c24ULL, 0x000fe2000f8e0204ULL,
0x0000000700077812ULL, 0x000fe200078ec0ffULL, 0x0000004003007836ULL, 0x000fe40000000000ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000840077824ULL, 0x000fe200078e0207ULL,
0x00000003ff027819ULL, 0x002fc40000011600ULL, 0x000000050e057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4406ULL, 0x0000000f0200720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000141047824ULL, 0x102fe400078e0202ULL,
0x0000000100027824ULL, 0x000fe400078e0202ULL, 0x0000000411067227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a06ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x8000000805051c36ULL, 0x000fe40008000000ULL,
0x0000000106061836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fe4000bf46070ULL,
0x0000000702057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805027812ULL, 0x000fca00078ef800ULL,
0x0000001002027824ULL, 0x000fe400078e020dULL, 0x0000000106062836ULL, 0x000fc60000000000ULL,
0x0000000002087984ULL, 0x0002a40000000c00ULL, 0x0000000613067207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a06ULL, 0x0000000906057c24ULL, 0x000fe4000f8e0243ULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x0000000700077812ULL, 0x000fe200078ec0ffULL,
0x0000006003007836ULL, 0x000fe40000000000ULL, 0x0000000805057c24ULL, 0x000fe4000f8e0204ULL,
0x0000000840037824ULL, 0x000fc600078e0207ULL, 0x000000050e057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4406ULL, 0x00000003ff067819ULL, 0x000fe20000011600ULL,
0x0000001003027825ULL, 0x002fc600078e0004ULL, 0x0000000f0600720cULL, 0x000fe20003f26070ULL,
0x0000000141417824ULL, 0x000fe200078e0206ULL, 0x0000000802007986ULL, 0x0043f6000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000004111047227ULL, 0x000fe200078e00ffULL,
0x0000000700057812ULL, 0x000fc600078ec0ffULL, 0x000000ffff027224ULL, 0x002fe400078e0a04ULL,
0x0000000100067824ULL, 0x000fe400078e0206ULL, 0x0000000802027c24ULL, 0x000fe4000f8e0241ULL,
0x0000000840057824ULL, 0x000fe200078e0205ULL, 0x0000000706037812ULL, 0x000fe400078ec0ffULL,
0x0000000802007c0cULL, 0x000fda000bf26070ULL, 0x8000000802021c36ULL, 0x000fe40008000000ULL,
0x0000000104041836ULL, 0x000fc60000000000ULL, 0x0000000802007c0cULL, 0x000fe4000bf46070ULL,
0xfffffff803027812ULL, 0x000fca00078ef800ULL, 0x00000010020d7824ULL, 0x000fca00078e020dULL,
0x000000000d087984ULL, 0x000e620000000c00ULL, 0x0000000104042836ULL, 0x000fca0000000000ULL,
0x0000000413047207ULL, 0x000fca0004000000ULL, 0x000000ffff027224ULL, 0x000fe400078e0a04ULL,
0x0000000904047c24ULL, 0x000fe4000f8e0243ULL, 0x0000000802417c24ULL, 0x000fc8000f8e0241ULL,
0x0000000804417c24ULL, 0x000fca000f8e0241ULL, 0x000000410e417210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x0000000441027c11ULL, 0x000fc8000f8040ffULL,
0x0000000541037c11ULL, 0x000fc600080f4404ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000003a4000720cULL, 0x000fe20003f06070ULL, 0x00009a00ff0e7b82ULL, 0x000e620000000a00ULL,
0x00000001ff087424ULL, 0x000fe400078e00ffULL, 0xffffffffff137424ULL, 0x000fca00078e00ffULL,
0x00009000ff0a7b82ULL, 0x000ea80000000a00ULL, 0x0000000207098824ULL, 0x000fc800078e00ffULL,
0x00009600ff048b82ULL, 0x000ef00000000800ULL, 0x00009200ff108b82ULL, 0x000f620000000a00ULL,
0x000000060e0e7981ULL, 0x002322000c1e9900ULL, 0x0000000409098224ULL, 0x008fc800078e0240ULL,
0x0000000409108825ULL, 0x020fe400078e0010ULL, 0x017600080d0879a7ULL, 0x000266000850003fULL,
0x0000000610138981ULL, 0x000ee2000c1e1900ULL, 0x000001ff0300780cULL, 0x000fe20003f04070ULL,
0x0000004002027824ULL, 0x000fe400078e00ffULL, 0x0000004040047824ULL, 0x000fe400078e00ffULL,
0x0000004043037824ULL, 0x000fc400078e00ffULL, 0x0000001302137224ULL, 0x008fc800078e02ffULL,
0x00000080130a7825ULL, 0x004fe400078e000aULL, 0x0000000c00200947ULL, 0x002fea0003800000ULL,
0x00000003ff227819ULL, 0x000fe2000001160cULL, 0x0000400040207824ULL, 0x000fe200078e020dULL,
0x000000043b0f7248ULL, 0x000fc60007fe0000ULL, 0x0000000422117836ULL, 0x000fe40000000000ULL,
0x000000010f0f7824ULL, 0x000fe400078e0a04ULL, 0x0000000111107824ULL, 0x040fe400078e020cULL,
0x0000000811237824ULL, 0x040fe200078e00ffULL, 0x0000000f1100720cULL, 0x080fe20003f86070ULL,
0x0000000822117836ULL, 0x000fe40000000000ULL, 0x0000004043437824ULL, 0x000fe200078e0222ULL,
0xfffffff823237812ULL, 0x000fe200078ee210ULL, 0x0000000111167824ULL, 0x040fe200078e020cULL,
0x0000000f1100720cULL, 0x040fe20003f06070ULL, 0x00000008112b7824ULL, 0x000fc400078e00ffULL,
0x0000000c22137836ULL, 0x000fe40000000000ULL, 0x0000008043107825ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe400078ee216ULL, 0x0000000f1300720cULL, 0x040fe20003f26070ULL,
0x0000000843147836ULL, 0x000fe20000000000ULL, 0x0000007010257812ULL, 0x000fe200078ef805ULL,
0x0000000443127836ULL, 0x000fe40000000000ULL, 0x0000000113177824ULL, 0x040fe200078e020cULL,
0x000000250a247210ULL, 0x000fe20007f5e0ffULL, 0x0000000813187824ULL, 0x000fc400078e00ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff8182d7812ULL, 0x000fe200078ee217ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000007014177812ULL, 0x000fc600078ef805ULL,
0x0000000c43167836ULL, 0x000fe20000000000ULL, 0x00000070121f7812ULL, 0x000fe200078ef805ULL,
0x000000010b257824ULL, 0x000fe200010e0611ULL, 0x000000170a107210ULL, 0x000fe20007f7e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000001f0a1e7210ULL, 0x000fc60007f5e0ffULL,
0x0000001043127836ULL, 0x000fe20000000000ULL, 0x0000007016197812ULL, 0x000fe200078ef805ULL,
0x000000010b1f7824ULL, 0x000fe400010e0613ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000190a187210ULL, 0x000fc60007f5e0ffULL, 0x00000018431a7836ULL, 0x000fe20000000000ULL,
0x0000007012217812ULL, 0x000fe200078ef805ULL, 0x0000001c431c7836ULL, 0x000fe40000000000ULL,
0x000000801a1a7825ULL, 0x000fc800078e00ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000701a277812ULL, 0x000fc600078ef805ULL, 0x000000010b197824ULL, 0x040fe200010e0617ULL,
0x000000210a167210ULL, 0x000fe20007f5e0ffULL, 0x0000001443147836ULL, 0x000fe20000000000ULL,
0x000000701c217812ULL, 0x000fe200078ef805ULL, 0x000000010b117824ULL, 0x000fe200018e0615ULL,
0x000000270a127210ULL, 0x000fe20007f7e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000210a1a7210ULL, 0x000fc60007fbe0ffULL, 0x000000010b177824ULL, 0x040fe200010e0613ULL,
0x0000007014297812ULL, 0x000fe200078ef805ULL, 0x000000010b137824ULL, 0x040fe400018e061bULL,
0x000000010b1b7824ULL, 0x000fe200028e061dULL, 0x000000290a147210ULL, 0x000fe20007f5e0ffULL,
0x0000001022217836ULL, 0x000fe20000000000ULL, 0x0000000f2200720cULL, 0x040fe20003fa6070ULL,
0x00000001221d7824ULL, 0x000fe400078e020cULL, 0x00000020431c7836ULL, 0x000fc40000000000ULL,
0x0000000121267824ULL, 0x100fe200078e020cULL, 0x000000071d297812ULL, 0x000fe200078ec0ffULL,
0x00000008212f7824ULL, 0x000fe400078e00ffULL, 0x0000001422277836ULL, 0x000fe20000000000ULL,
0x0ffffff829297812ULL, 0x000fe200078ef80cULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe400078ee226ULL, 0x0000000f2700720cULL, 0x080fe20003f66070ULL,
0x000000010b157824ULL, 0x000fe200010e0615ULL, 0x0000000f2100720cULL, 0x000fe20003f46070ULL,
0x0000000127287824ULL, 0x040fe200078e020cULL, 0x000000701c217812ULL, 0x000fe200078ef805ULL,
0x0000000827317824ULL, 0x000fc400078e00ffULL, 0x0000002443267836ULL, 0x000fe20000000000ULL,
0x000000210a1c7210ULL, 0x000fe20007fde0ffULL, 0x0000100020207836ULL, 0x000fe20000000000ULL,
0xfffffff831317812ULL, 0x000fe200078ee228ULL, 0x0000008026267825ULL, 0x000fc800078e00ffULL,
0x0000002843287836ULL, 0x000fe20000000000ULL, 0x0000007026337812ULL, 0x000fe200078ef805ULL,
0x0000001029217824ULL, 0x000fe400078e0220ULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024217faeULL, 0x0003e2000e901c46ULL,
0x00000018222a7836ULL, 0x000fe40000000000ULL, 0x000000010b1d7824ULL, 0x000fe400030e061dULL,
0x0000001023237824ULL, 0x000fe200078e0220ULL, 0x0000000f2a00720cULL, 0x0c0fe20003fa6070ULL,
0x0000001c222c7836ULL, 0x000fe40000000000ULL, 0x000000012a267824ULL, 0x040fe200078e020cULL,
0x000000001e237faeULL, 0x0005e2000e101c46ULL, 0x000000082a357824ULL, 0x000fe200078e00ffULL,
0x000000330a247210ULL, 0x002fe20007fde0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0220ULL,
0x0000007028217812ULL, 0x000fe200078ef805ULL, 0x000000012c287824ULL, 0x040fe200078e020cULL,
0x0000000f2c00720cULL, 0x000fe20003f86070ULL, 0x000000010b257824ULL, 0x000fe200030e0627ULL,
0x00000000102b7faeULL, 0x0003e2000c101c46ULL, 0x000000102d2d7824ULL, 0x000fc400078e0220ULL,
0x00000024222a7836ULL, 0x000fe20000000000ULL, 0x000000210a1e7210ULL, 0x004fe20007fde0ffULL,
0x000000082c237824ULL, 0x000fe200078e00ffULL, 0xfffffff835217812ULL, 0x000fe200078ee226ULL,
0x0000002c43267836ULL, 0x000fe20000000000ULL, 0x00000000182d7faeULL, 0x0005e2000c901c46ULL,
0x000000102f2f7824ULL, 0x100fe200078e0220ULL, 0xfffffff823237812ULL, 0x000fe200078ee228ULL,
0x0000002022287836ULL, 0x000fe20000000000ULL, 0x0000000f2a00720cULL, 0x080fe20003f26070ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x00000000162f7faeULL, 0x000fe4000d101c46ULL,
0x0000000f2800720cULL, 0x000fe20003f06070ULL, 0x000000010b1f7824ULL, 0x000fe200030e0629ULL,
0x0000007026337812ULL, 0x000fe200078ef805ULL, 0x0000001031317824ULL, 0x000fc400078e0220ULL,
0x0000000128297824ULL, 0x140fe200078e020cULL, 0x000000330a107210ULL, 0x002fe20007fde0ffULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0x0000000014317faeULL, 0x0003e2000d901c46ULL,
0x000000012a267824ULL, 0x040fe400078e020cULL, 0x000000082a117824ULL, 0x000fe200078e00ffULL,
0xfffffff828297812ULL, 0x000fe200078ee229ULL, 0x0000001021217824ULL, 0x100fe400078e0220ULL,
0x0000001023237824ULL, 0x100fe200078e0220ULL, 0xfffffff811197812ULL, 0x004fe200078ee226ULL,
0x0000001029297824ULL, 0x000fe200078e0220ULL, 0x0000000012217faeULL, 0x0005e2000e901c46ULL,
0x0000002822187836ULL, 0x000fc40000000000ULL, 0x0000003043147836ULL, 0x002fe20000000000ULL,
0x000000001a237faeULL, 0x000fe2000e101c46ULL, 0x0000001019197824ULL, 0x000fe200078e0220ULL,
0x0000000f1800720cULL, 0x080fe20003fa6070ULL, 0x000000010b117824ULL, 0x000fe200030e0627ULL,
0x000000001c297faeULL, 0x000fe2000c101c46ULL, 0x0000002c22177836ULL, 0x000fe40000000000ULL,
0x0000003022267836ULL, 0x000fe20000000000ULL, 0x0000000024197faeULL, 0x0003e2000c901c46ULL,
0x0000008014127825ULL, 0x004fe200078e00ffULL, 0x0000000f1700720cULL, 0x000fc40003f86070ULL,
0x0000000f2600720cULL, 0x080fe20003f66070ULL, 0x0000003443147836ULL, 0x000fe20000000000ULL,
0x0000007012157812ULL, 0x000fe200078ef805ULL, 0x0000003422277836ULL, 0x000fe40000000000ULL,
0x0000003822217836ULL, 0x000fe20000000000ULL, 0x000000150a127210ULL, 0x000fe20007fde0ffULL,
0x0000003c22227836ULL, 0x000fe20000000000ULL, 0x0000000f2700720cULL, 0x080fe20003f46070ULL,
0x0000000118167824ULL, 0x040fe200078e020cULL, 0x0000000f2100720cULL, 0x080fe20003f26070ULL,
0x0000000818197824ULL, 0x002fe200078e00ffULL, 0x0000000f2200720cULL, 0x000fe20003f06070ULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff8190f7812ULL, 0x000fe200078ee216ULL,
0x000000010b137824ULL, 0x000fe200030e0613ULL, 0x0000007014197812ULL, 0x000fe200078ef805ULL,
0x0000000126147824ULL, 0x140fe400078e020cULL, 0x00000008261d7824ULL, 0x000fe200078e00ffULL,
0x000000190a187210ULL, 0x000fe20007fde0ffULL, 0x0000000117167824ULL, 0x040fe400078e020cULL,
0x00000008171b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee214ULL,
0x0000003843177836ULL, 0x000fc40000000000ULL, 0x000000010b197824ULL, 0x000fe200030e0615ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee216ULL, 0x0000008017147825ULL, 0x000fc800078e00ffULL,
0x0000003c43167836ULL, 0x000fe40000000000ULL, 0x00000001211c7824ULL, 0x040fe400078e020cULL,
0x0000000821237824ULL, 0x000fe200078e00ffULL, 0x0000007014217812ULL, 0x000fe200078ef805ULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0x000000210a147210ULL, 0x000fe20007fde0ffULL,
0x00000001271a7824ULL, 0x140fe200078e020cULL, 0x0000007016057812ULL, 0x000fe200078ef805ULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee21cULL,
0x00000001220c7824ULL, 0x040fe400078e020cULL, 0x0000000822257824ULL, 0x000fe200078e00ffULL,
0xfffffff827217812ULL, 0x000fe200078ee21aULL, 0x000000010b157824ULL, 0x000fe200030e0615ULL,
0x000000050a0a7210ULL, 0x000fe20007fde0ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0220ULL,
0xfffffff825257812ULL, 0x000fe200078ee20cULL, 0x000000101b1b7824ULL, 0x000fc400078e0220ULL,
0x000000101d1d7824ULL, 0x100fe200078e0220ULL, 0x000000001e0f7faeULL, 0x0003e2000e901c46ULL,
0x0000001021217824ULL, 0x100fe400078e0220ULL, 0x0000001023237824ULL, 0x100fe200078e0220ULL,
0x00000000101b7faeULL, 0x0003e2000e101c46ULL, 0x0000001025257824ULL, 0x000fe400078e0220ULL,
0x000000010b0b7824ULL, 0x000fe200030e0617ULL, 0x00000000121d7faeULL, 0x0003e8000d901c46ULL,
0x0000000018217faeULL, 0x0003e8000d101c46ULL, 0x0000000014237faeULL, 0x0003e8000c901c46ULL,
0x000000000a257faeULL, 0x0003e2000c101c46ULL, 0x0000000800d07947ULL, 0x000fea0003800000ULL,
0x000000040c117811ULL, 0x040fe400078fe8ffULL, 0x000000080c147811ULL, 0x040fe400078fe8ffULL,
0x0000000c0c157811ULL, 0x040fe200078fe8ffULL, 0x00000001110f7824ULL, 0x140fe200078e020cULL,
0x000000180c1a7811ULL, 0x040fe200078fe8ffULL, 0x0000000811107824ULL, 0x000fe200078e00ffULL,
0x0000001c0c1b7811ULL, 0x000fe200078fe8ffULL, 0x0000000814167824ULL, 0x000fe200078e00ffULL,
0x000000100c177811ULL, 0x000fe200078fe8ffULL, 0x0000000815237824ULL, 0x040fe200078e00ffULL,
0xfffffff8101f7812ULL, 0x000fe200078ee20fULL, 0x00000001140f7824ULL, 0x100fe200078e020cULL,
0x000000140c197811ULL, 0x040fe200078fe8ffULL, 0x0000000115107824ULL, 0x100fe200078e020cULL,
0x000000200c1c7811ULL, 0x000fe200078fe8ffULL, 0x000000081b2b7824ULL, 0x040fe200078e00ffULL,
0xfffffff816217812ULL, 0x000fe200078ee20fULL, 0x000000011a0f7824ULL, 0x140fe200078e020cULL,
0xfffffff823237812ULL, 0x000fe200078ee210ULL, 0x000000081a167824ULL, 0x000fe200078e00ffULL,
0x000000240c1d7811ULL, 0x040fe200078fe8ffULL, 0x000000011b107824ULL, 0x100fe200078e020cULL,
0x0000002c0c2a7811ULL, 0x040fe200078fe8ffULL, 0x0000000117127824ULL, 0x140fe200078e020cULL,
0xfffffff816297812ULL, 0x000fe200078ee20fULL, 0x0000000817257824ULL, 0x000fe200078e00ffULL,
0xfffffff82b167812ULL, 0x000fe200078ee210ULL, 0x0000000119137824ULL, 0x140fe200078e020cULL,
0x000000280c2b7811ULL, 0x000fe200078fe8ffULL, 0x0000000819187824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee212ULL, 0x000000011c127824ULL, 0x100fe200078e020cULL,
0x000000300c227811ULL, 0x000fe200078fe8ffULL, 0x000000081c2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff818277812ULL, 0x000fe200078ee213ULL, 0x000000012b0f7824ULL, 0x140fe200078e020cULL,
0x000000340c207811ULL, 0x040fe200078fe8ffULL, 0x000000082b267824ULL, 0x000fe200078e00ffULL,
0xfffffff82d1e7812ULL, 0x000fe200078ee212ULL, 0x000000011d137824ULL, 0x140fe200078e020cULL,
0x000000380c287811ULL, 0x000fe200078fe8ffULL, 0x000000081d247824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee20fULL, 0x000000012a107824ULL, 0x100fe200078e020cULL,
0x0000000c0c0f7211ULL, 0x000fe200078fe8ffULL, 0x000000082a2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee213ULL, 0x0000000122127824ULL, 0x100fe200078e020cULL,
0x0000003c0c2c7811ULL, 0x000fe200078fe8ffULL, 0x00000008222f7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee210ULL, 0x0000000120137824ULL, 0x140fe200078e020cULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x0000000820187824ULL, 0x000fe200078e00ffULL,
0x000000030c107211ULL, 0x000fe200078fe8ffULL, 0x0000000828307824ULL, 0x000fe200078e00ffULL,
0xfffffff82f2e7812ULL, 0x000fe200078ee212ULL, 0x0000000103127824ULL, 0x000fe200078e0211ULL,
0xfffffff8182f7812ULL, 0x000fe200078ee213ULL, 0x0000400040187824ULL, 0x000fe200078e020dULL,
0x0ffffff80f0f7812ULL, 0x000fe200078ef80cULL, 0x0000000128137824ULL, 0x000fc400078e020cULL,
0x000000012c0c7824ULL, 0x040fe400078e020cULL, 0x000000082c357824ULL, 0x000fe200078e00ffULL,
0xfffffff830337812ULL, 0x000fe200078ee213ULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff835327812ULL, 0x000fe200078ee20cULL, 0x0000100018187836ULL, 0x000fe20000000000ULL,
0x0000007010317812ULL, 0x000fe200078ef805ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x000000310a107210ULL, 0x000fe20007f1e0ffULL, 0x00000010160c7824ULL, 0x000fe200078e0218ULL,
0x0000007012317812ULL, 0x000fe200078ef805ULL, 0x0000000103147824ULL, 0x040fe400078e0214ULL,
0x0000000103167824ULL, 0x000fe200078e0215ULL, 0x000000310a127210ULL, 0x000fe20007f3e0ffULL,
0x000000100f0f7824ULL, 0x100fe400078e0218ULL, 0x000000101f1f7824ULL, 0x100fe400078e0218ULL,
0x0000001021217824ULL, 0x000fc400078e0218ULL, 0x0000001023237824ULL, 0x100fe400078e0218ULL,
0x0000001025257824ULL, 0x100fe400078e0218ULL, 0x0000001027277824ULL, 0x100fe400078e0218ULL,
0x0000001029297824ULL, 0x100fe400078e0218ULL, 0x000000101e1e7824ULL, 0x100fe400078e0218ULL,
0x0000001024247824ULL, 0x000fc400078e0218ULL, 0x0000001026267824ULL, 0x100fe400078e0218ULL,
0x000000102d2d7824ULL, 0x100fe400078e0218ULL, 0x000000102e2e7824ULL, 0x100fe400078e0218ULL,
0x000000102f2f7824ULL, 0x100fe400078e0218ULL, 0x0000001033337824ULL, 0x100fe400078e0218ULL,
0x0000001032327824ULL, 0x000fc400078e0218ULL, 0x0000000103187824ULL, 0x000fe400078e0217ULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000070143f7812ULL, 0x000fc600078ef805ULL, 0x0000000103307824ULL, 0x000fe200078e0219ULL,
0x0000007016377812ULL, 0x000fe200078ef805ULL, 0x000000010b117824ULL, 0x000fe200000e0611ULL,
0x0000003f0a147210ULL, 0x000fe20007f1e0ffULL, 0x0000008030307825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100f7faeULL, 0x0003e2000b901c46ULL,
0x0000000103347824ULL, 0x000fe400078e021aULL, 0x000000010b137824ULL, 0x040fe200008e0613ULL,
0x000000370a167210ULL, 0x000fe20007f3e0ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000007030377812ULL, 0x000fe400078ef805ULL, 0x00000000121f7faeULL, 0x0003e2000b901c46ULL,
0x000000010b157824ULL, 0x000fe200000e0615ULL, 0x000000370a1a7210ULL, 0x000fe20007f1e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000007034377812ULL, 0x000fc400078ef805ULL,
0x0000000014217faeULL, 0x0003e2000b901c46ULL, 0x0000000103307824ULL, 0x000fe200078e021bULL,
0x00000070183d7812ULL, 0x000fe200078ef805ULL, 0x000000010b1b7824ULL, 0x000fe400000e0631ULL,
0x0000000103347824ULL, 0x000fe200078e021cULL, 0x000000370a1c7210ULL, 0x000fe20007f1e0ffULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0x0000003d0a187210ULL, 0x000fc60007f5e0ffULL,
0x00000001033c7824ULL, 0x040fe200078e022bULL, 0x00000070303f7812ULL, 0x000fe200078ef805ULL,
0x0000000103367824ULL, 0x000fe400078e021dULL, 0x000000010b1d7824ULL, 0x000fe400000e0635ULL,
0x000000803c3c7825ULL, 0x000fc800078e00ffULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x00000070342b7812ULL, 0x000fc600078ef805ULL,
0x00000001033e7824ULL, 0x000fe200078e022aULL, 0x0000003f0a2a7210ULL, 0x000fe20007f1e0ffULL,
0x000000010b197824ULL, 0x040fe200010e0619ULL, 0x000000703c3f7812ULL, 0x000fe200078ef805ULL,
0x000000010b177824ULL, 0x000fe200008e0617ULL, 0x0000007036437812ULL, 0x000fe200078ef805ULL,
0x00000001033c7824ULL, 0x000fe200078e0222ULL, 0x0000003f0a367210ULL, 0x000fe20007f5e0ffULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x0000002b0a307210ULL, 0x000fe20007f3e0ffULL,
0x0000000016237faeULL, 0x0003e4000b901c46ULL, 0x000000010b2b7824ULL, 0x040fe200000e0631ULL,
0x000000430a347210ULL, 0x000fe20007f1e0ffULL, 0x000000010b317824ULL, 0x000fe200008e0635ULL,
0x000000703e437812ULL, 0x000fe200078ef805ULL, 0x0000000103427824ULL, 0x000fe200078e0220ULL,
0x0000000018257faeULL, 0x0003e2000b901c46ULL, 0x000000010b357824ULL, 0x000fe200000e0637ULL,
0x000000430a3e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000103447824ULL, 0x000fe200078e0228ULL,
0x000000001a277faeULL, 0x0003e2000b901c46ULL, 0x000000010b377824ULL, 0x000fc400010e063dULL,
0x0000000103467824ULL, 0x000fe200078e022cULL, 0x000000001c297faeULL, 0x0003e2000b901c46ULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0x000000002a0c7faeULL, 0x0003e2000b901c46ULL,
0x0000008042427825ULL, 0x000fe200078e00ffULL, 0x000000703c4d7812ULL, 0x000fe400078ef805ULL,
0x00000000301e7faeULL, 0x0003e2000b901c46ULL, 0x0000008044447825ULL, 0x000fe200078e00ffULL,
0x00000070424b7812ULL, 0x000fe400078ef805ULL, 0x0000000034247faeULL, 0x0003e2000b901c46ULL,
0x0000008046467825ULL, 0x000fe200078e00ffULL, 0x0000007044497812ULL, 0x000fc400078ef805ULL,
0x0000004b0a427210ULL, 0x000fe20007f3e0ffULL, 0x000000010b3f7824ULL, 0x040fe200000e063fULL,
0x0000007046057812ULL, 0x000fe200078ef805ULL, 0x0000000036267faeULL, 0x0003e2000b901c46ULL,
0x0000004d0a3c7210ULL, 0x000fe20007f1e0ffULL, 0x000000010b437824ULL, 0x040fe200008e0643ULL,
0x000000490a447210ULL, 0x000fe20007f5e0ffULL, 0x000000003e2d7faeULL, 0x0003e2000b901c46ULL,
0x000000050a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000010b3d7824ULL, 0x040fe400000e063dULL,
0x000000010b457824ULL, 0x000fc400010e0645ULL, 0x000000010b0b7824ULL, 0x000fe200018e0647ULL,
0x000000003c2e7faeULL, 0x0003e8000b901c46ULL, 0x00000000422f7faeULL, 0x0003e8000b901c46ULL,
0x0000000044337faeULL, 0x0003e8000b901c46ULL, 0x000000000a327faeULL, 0x0003e4000b901c46ULL,
0x00000004403f7836ULL, 0x002fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff057424ULL, 0x000fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe40000000800ULL,
0x0000003a3f00720cULL, 0x000fda0003f06070ULL, 0x00009600ff0f8b82ULL, 0x000e620000000800ULL,
0x00000002070c8824ULL, 0x000fce00078e00ffULL, 0x00009200ff0a8b82ULL, 0x000ea20000000a00ULL,
0x0000000f0c0f8224ULL, 0x002fc800078e023fULL, 0x000000040f0a8825ULL, 0x004fca00078e000aULL,
0x000000060a058981ULL, 0x000322000c1e1900ULL, 0x0000001f04047890ULL, 0x000fc8000fffe03fULL,
0x000000053f047899ULL, 0x000fd80008011604ULL, 0x00000000000a7805ULL, 0x002fce0000015200ULL,
0x017600090d0075a7ULL, 0x000e62000800017fULL, 0x00000004060f7c24ULL, 0x000fe4000f8e02ffULL,
0x000000013b067824ULL, 0x000fca00078e0a00ULL, 0x00000008ff067819ULL, 0x000fe20000011606ULL,
0x00008e00ff447b82ULL, 0x000ea40000000a00ULL, 0x000000040f447825ULL, 0x004fe200078e0044ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff127224ULL, 0x000fce00078e00ffULL,
0x000000101200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fce0000015200ULL, 0x000000100a0f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000111107824ULL, 0x000fe200000e0e0bULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1000720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1000720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011410ULL,
0x0000000f0c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e0610ULL,
0x000000020c0c7819ULL, 0x000fc8000000120fULL, 0x0000000c0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000112127836ULL, 0x000fce0000000000ULL,
0x017600090d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000097919ULL, 0x000e640000000000ULL, 0x0000002040087824ULL, 0x002fca00078e0209ULL,
0x00000003ff097819ULL, 0x000fc80000011608ULL, 0x1ffffffe090b7812ULL, 0x000fe400078ec0ffULL,
0x0000000f08097812ULL, 0x000fc600078ec0ffULL, 0x00000001080b7824ULL, 0x000fe400078e020bULL,
0x00000010090a7824ULL, 0x000fe400078e00ffULL, 0x000000010b087836ULL, 0x000fe20000000000ULL,
0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL, 0x00000010090c7824ULL, 0x000fc600078e00ffULL,
0x0000000f08097812ULL, 0x000fe400078ec0ffULL, 0x000000f00a087812ULL, 0x000fe400078ee20bULL,
0x000000f00c0a7812ULL, 0x000fc600078ee209ULL, 0x0000001008087824ULL, 0x100fe400078e020dULL,
0x000000100a0a7824ULL, 0x000fc600078e020dULL, 0x0000000008147984ULL, 0x000e680000000c00ULL,
0x000000000a107984ULL, 0x000ea20000000c00ULL, 0x000000ffff187224ULL, 0x002fe400078e0014ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff157224ULL, 0x000fc400078e0017ULL, 0x000000ffff1a7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0012ULL, 0x000000ffff167224ULL, 0x000fe400078e0011ULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x0000001808007388ULL, 0x0003e20000000c00ULL,
0x00000001ff107424ULL, 0x000fc600078e00ffULL, 0x000000140a007388ULL, 0x0003e60000000c00ULL,
0x017600100d1079a7ULL, 0x0002a4000850003fULL, 0x0000000000087805ULL, 0x002fce0000015200ULL,
0x017600110d0075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a080f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000000f0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x017600110d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff3900720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00009600ff0a7b82ULL, 0x000e620000000800ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x3db504f30e097820ULL, 0x010fe20000410000ULL,
0x00000008400b7824ULL, 0x140fe200078e020dULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0xffffffff000c7836ULL, 0x000fe40000000000ULL, 0x00000009000e7836ULL, 0x000fe40000000000ULL,
0x00000020400f7824ULL, 0x000fe400078e020dULL, 0x000000ffff3d7224ULL, 0x000fc400078e00ffULL,
0x000000ffff1e7224ULL, 0x000fe400078e00ffULL, 0x0000000a07077224ULL, 0x002fe400078e02ffULL,
0x00000100040a7836ULL, 0x000fce0000000000ULL, 0x00009000ff107b82ULL, 0x004e620000000a00ULL,
0x000000023d127836ULL, 0x000fe20000000000ULL, 0x000000011e387812ULL, 0x000fe200078e0cffULL,
0x0000000502057224ULL, 0x010fc600078e02ffULL, 0x000000391200720cULL, 0x000fe20003f06070ULL,
0x0000008005107825ULL, 0x002fd800078e0010ULL, 0x0000000c00308947ULL, 0x000fea0003800000ULL,
0x000001003d127824ULL, 0x000fe200078e020aULL, 0x00000003ff167819ULL, 0x004fe20000011608ULL,
0x00004000401f7824ULL, 0x000fc600078e020dULL, 0x000000123b157248ULL, 0x000fe20007fe0000ULL,
0x0000000416187836ULL, 0x000fe40000000000ULL, 0x0000000c161c7836ULL, 0x000fe40000000000ULL,
0x0000000816147836ULL, 0x000fe40000000000ULL, 0x0000000118057824ULL, 0x140fe400078e0208ULL,
0x00000008181a7824ULL, 0x000fe400078e00ffULL, 0x000000011c137824ULL, 0x000fc400078e0208ULL,
0x000000081c207824ULL, 0x000fe200078e00ffULL, 0xfffffff81a2d7812ULL, 0x000fe200078ee205ULL,
0x0000000115157824ULL, 0x000fe400078e0a12ULL, 0x0000000114127824ULL, 0x140fe200078e0208ULL,
0xfffffff820317812ULL, 0x000fe200078ee213ULL, 0x00000008142f7824ULL, 0x000fe200078e00ffULL,
0x000000151800720cULL, 0x080fe20003f46070ULL, 0x0000001016267836ULL, 0x000fe20000000000ULL,
0x000000151c00720cULL, 0x080fe20003fa6070ULL, 0x0000001008057824ULL, 0x000fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee212ULL, 0x0000000126137824ULL, 0x040fe200078e0208ULL,
0x000000152600720cULL, 0x0c0fe20003f86070ULL, 0x00000008261a7824ULL, 0x000fe200078e00ffULL,
0x0000007005057812ULL, 0x000fe200078ec0ffULL, 0x0000000103127824ULL, 0x040fe200078e0216ULL,
0x000000151400720cULL, 0x000fe20003f66070ULL, 0x0000000103187824ULL, 0x000fe200078e0218ULL,
0xfffffff81a337812ULL, 0x000fe200078ee213ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000005121b7212ULL, 0x000fc600078efcffULL,
0x0000001816287836ULL, 0x000fe20000000000ULL, 0x0000000518177212ULL, 0x000fe200078efcffULL,
0x0000001416247836ULL, 0x000fe20000000000ULL, 0x0000001b101a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000128127824ULL, 0x040fe200078e0208ULL, 0x0000001710187210ULL, 0x000fe20007f3e0ffULL,
0x00000008281d7824ULL, 0x000fe400078e00ffULL, 0x00000001031c7824ULL, 0x000fe400078e021cULL,
0x0000000124257824ULL, 0x040fe200078e0208ULL, 0xfffffff81d177812ULL, 0x000fe200078ee212ULL,
0x0000000824207824ULL, 0x000fc400078e00ffULL, 0x000000801c1c7825ULL, 0x000fc600078e00ffULL,
0xfffffff820257812ULL, 0x000fe200078ee225ULL, 0x0000000103127824ULL, 0x040fe200078e0214ULL,
0x000000051c217212ULL, 0x000fe200078efcffULL, 0x0000000103267824ULL, 0x000fe400078e0226ULL,
0x0000000116207824ULL, 0x000fe400078e0208ULL, 0x00000001111b7824ULL, 0x000fe400000e0613ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000007202b7812ULL, 0x000fc400078ec0ffULL,
0x0000002110207210ULL, 0x000fe20007fde0ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000512237212ULL, 0x000fe400078efcffULL, 0x0ffffff82b2b7812ULL, 0x000fe200078ef808ULL,
0x0000000111197824ULL, 0x000fe200008e0619ULL, 0x000000151600720cULL, 0x000fe20003f26070ULL,
0x0000200038147824ULL, 0x000fe200078e021fULL, 0x0000000526297212ULL, 0x000fe200078efcffULL,
0x00000001031c7824ULL, 0x000fe200078e0224ULL, 0x0000002310227210ULL, 0x000fe20007f1e0ffULL,
0x0000000111217824ULL, 0x000fe200030e061dULL, 0x0000002910127210ULL, 0x000fe20007fde0ffULL,
0x0000100014147836ULL, 0x000fc40000000000ULL, 0x000000801c1c7825ULL, 0x000fc800078e00ffULL,
0x0000000111237824ULL, 0x000fe200000e0613ULL, 0x000000152400720cULL, 0x000fe20003f06070ULL,
0x000000102b297824ULL, 0x000fe400078e0214ULL, 0x0000000111137824ULL, 0x000fe200030e0627ULL,
0x000000051c277212ULL, 0x000fe200078efcffULL, 0x00000020162a7836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a297faeULL, 0x0003e2000c901c46ULL,
0x0000000103247824ULL, 0x000fe200078e0228ULL, 0x000000152800720cULL, 0x000fe20003f26070ULL,
0x000000012a1c7824ULL, 0x000fc400078e0208ULL, 0x000000082a377824ULL, 0x000fe400078e00ffULL,
0x0000001c16267836ULL, 0x000fe40000000000ULL, 0x000000102f2b7824ULL, 0x000fe200078e0214ULL,
0xfffffff837377812ULL, 0x000fe200078ee21cULL, 0x0000000126287824ULL, 0x040fe200078e0208ULL,
0x00000027101a7210ULL, 0x002fe20007fde0ffULL, 0x000000102d297824ULL, 0x000fe400078e0214ULL,
0x0000000826357824ULL, 0x000fc400078e00ffULL, 0x00000001111b7824ULL, 0x000fe200030e061dULL,
0x0000000018297faeULL, 0x0003e2000d101c46ULL, 0x00000080241c7825ULL, 0x000fe200078e00ffULL,
0x000000152600720cULL, 0x000fe40003f46070ULL, 0xfffffff835357812ULL, 0x000fe200078ee228ULL,
0x0000000103267824ULL, 0x040fe200078e0226ULL, 0x000000051c277212ULL, 0x000fe200078efcffULL,
0x0000000103287824ULL, 0x000fe200078e022aULL, 0x00000000222b7faeULL, 0x0005e2000d901c46ULL,
0x00000010312d7824ULL, 0x000fe200078e0214ULL, 0x00000027101c7210ULL, 0x000fe20007fde0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x000000152a00720cULL, 0x000fc40003f66070ULL,
0x00000000202d7faeULL, 0x0007e2000e901c46ULL, 0x00000001111d7824ULL, 0x000fe200030e061dULL,
0x0000000526197212ULL, 0x002fe200078efcffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0x0000001910187210ULL, 0x000fe20007fde0ffULL, 0x0000002416247836ULL, 0x000fe20000000000ULL,
0x00000005282b7212ULL, 0x004fe200078efcffULL, 0x0000003016287836ULL, 0x000fe40000000000ULL,
0x0000000103237824ULL, 0x000fe200078e0224ULL, 0x000000152400720cULL, 0x040fe20003fa6070ULL,
0x0000000111197824ULL, 0x000fe200030e0627ULL, 0x0000002b10227210ULL, 0x000fe20007fde0ffULL,
0x0000000124267824ULL, 0x040fe400078e0208ULL, 0x00000008242f7824ULL, 0x000fc400078e00ffULL,
0x0000001033277824ULL, 0x000fe400078e0214ULL, 0x0000002816247836ULL, 0x000fe20000000000ULL,
0xfffffff82f2b7812ULL, 0x000fe200078ee226ULL, 0x0000008023207825ULL, 0x008fe200078e00ffULL,
0x0000000012277faeULL, 0x0003e4000e101c46ULL, 0x000000152400720cULL, 0x040fe20003f86070ULL,
0x0000000124267824ULL, 0x040fe400078e0208ULL, 0x00000008242d7824ULL, 0x000fc400078e00ffULL,
0x0000000111237824ULL, 0x000fe200030e0629ULL, 0x0000000520297212ULL, 0x000fe200078efcffULL,
0x0000000103247824ULL, 0x000fe200078e0224ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee226ULL,
0x0000002c16267836ULL, 0x000fe20000000000ULL, 0x0000002910207210ULL, 0x000fe20007fde0ffULL,
0x0000008024127825ULL, 0x002fc800078e00ffULL, 0x0000001025297824ULL, 0x000fe200078e0214ULL,
0x0000000512257212ULL, 0x000fe200078efcffULL, 0x0000000103247824ULL, 0x000fe400078e0226ULL,
0x0000000126277824ULL, 0x040fe200078e0208ULL, 0x000000001a297faeULL, 0x0003e2000c101c46ULL,
0x00000008262a7824ULL, 0x040fe200078e00ffULL, 0x000000152600720cULL, 0x000fe20003f06070ULL,
0x0000000111217824ULL, 0x000fe200030e0621ULL, 0x0000002510127210ULL, 0x000fe20007fde0ffULL,
0x0000000103267824ULL, 0x000fe200078e0228ULL, 0xfffffff82a2f7812ULL, 0x000fe200078ee227ULL,
0x0000008024247825ULL, 0x000fc800078e00ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x00000005241b7212ULL, 0x002fc600078efcffULL, 0x0000001017177824ULL, 0x000fe200078e0214ULL,
0x0000000526297212ULL, 0x000fe200078efcffULL, 0x0000000111137824ULL, 0x040fe200030e0613ULL,
0x0000001b101a7210ULL, 0x000fe20007fde0ffULL, 0x0000003416267836ULL, 0x000fe20000000000ULL,
0x000000001c177faeULL, 0x0003e2000c901c46ULL, 0x00000001282a7824ULL, 0x040fe200078e0208ULL,
0x000000152800720cULL, 0x040fe20003f26070ULL, 0x0000000828317824ULL, 0x000fe400078e00ffULL,
0x00000001111b7824ULL, 0x000fe200030e0625ULL, 0x0000002910247210ULL, 0x000fe20007fde0ffULL,
0x0000003816287836ULL, 0x000fe20000000000ULL, 0xfffffff831317812ULL, 0x000fe200078ee22aULL,
0x0000001035297824ULL, 0x000fc400078e0214ULL, 0x0000003c162a7836ULL, 0x000fe40000000000ULL,
0x00000001031c7824ULL, 0x002fe200078e0226ULL, 0x0000000018297faeULL, 0x0003e2000d101c46ULL,
0x0000001037177824ULL, 0x000fe200078e0214ULL, 0x000000152a00720cULL, 0x000fe20003f46070ULL,
0x000000801c1c7825ULL, 0x000fc600078e00ffULL, 0x0000000022177faeULL, 0x0005e2000d901c46ULL,
0x0000000103167824ULL, 0x000fe200078e0228ULL, 0x000000152800720cULL, 0x000fe20003f66070ULL,
0x0000000111257824ULL, 0x000fe400030e0627ULL, 0x000000102b277824ULL, 0x000fe200078e0214ULL,
0x000000051c2b7212ULL, 0x000fe200078efcffULL, 0x0000000103187824ULL, 0x002fe400078e022aULL,
0x0000000828297824ULL, 0x000fe200078e00ffULL, 0x0000000020277faeULL, 0x0003e2000e901c46ULL,
0x0000002b101c7210ULL, 0x000fe20007fde0ffULL, 0x0000008016167825ULL, 0x004fe200078e00ffULL,
0x000000152600720cULL, 0x000fc60003fa6070ULL, 0x0000000126227824ULL, 0x000fe200078e0208ULL,
0x0000000516157212ULL, 0x000fe200078efcffULL, 0x0000000826237824ULL, 0x000fe400078e00ffULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0xfffffff823277812ULL, 0x002fe200078ee222ULL,
0x00000001111d7824ULL, 0x040fe200030e061dULL, 0x0000001510167210ULL, 0x000fe20007fde0ffULL,
0x0000000128207824ULL, 0x100fe200078e0208ULL, 0x0000000518237212ULL, 0x000fe200078efcffULL,
0x000000012a217824ULL, 0x040fe400078e0208ULL, 0x000000082a2a7824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee220ULL, 0x0000000111177824ULL, 0x000fe200030e0617ULL,
0x0000002310107210ULL, 0x000fe20007fde0ffULL, 0x000000102d057824ULL, 0x100fe200078e0214ULL,
0xfffffff82a2b7812ULL, 0x000fe200078ee221ULL, 0x000000102f157824ULL, 0x000fc400078e0214ULL,
0x0000001031217824ULL, 0x100fe200078e0214ULL, 0x0000000012057faeULL, 0x0003e2000e101c46ULL,
0x0000001027237824ULL, 0x100fe400078e0214ULL, 0x0000001029277824ULL, 0x100fe200078e0214ULL,
0x000000001a157faeULL, 0x0003e2000c101c46ULL, 0x000000102b297824ULL, 0x000fe400078e0214ULL,
0x0000000111117824ULL, 0x000fe200030e0619ULL, 0x0000000024217faeULL, 0x0003e8000c901c46ULL,
0x000000001c237faeULL, 0x0003e8000e901c46ULL, 0x0000000016277faeULL, 0x0003e8000d901c46ULL,
0x0000000010297faeULL, 0x0003e2000d101c46ULL, 0x0000000800dc7947ULL, 0x000fea0003800000ULL,
0x0000000808187811ULL, 0x004fe200078fe8ffULL, 0x00004000401f7824ULL, 0x000fe200078e020dULL,
0x0000000408147811ULL, 0x040fe400078fe8ffULL, 0x00000018081a7811ULL, 0x000fe200078fe8ffULL,
0x0000000118127824ULL, 0x100fe200078e0208ULL, 0x00000010081b7811ULL, 0x000fe200078fe8ffULL,
0x0000000818517824ULL, 0x000fe200078e00ffULL, 0x00000014081c7811ULL, 0x000fe200078fe8ffULL,
0x0000000114057824ULL, 0x100fe200078e0208ULL, 0x0000000c08197811ULL, 0x000fe200078fe8ffULL,
0x0000000814167824ULL, 0x000fe200078e00ffULL, 0x0000002808237811ULL, 0x000fe200078fe8ffULL,
0x000000011a157824ULL, 0x140fe200078e0208ULL, 0xfffffff851517812ULL, 0x000fe200078ee212ULL,
0x000000081a227824ULL, 0x000fe200078e00ffULL, 0xfffffff816317812ULL, 0x000fe200078ee205ULL,
0x000000011b127824ULL, 0x140fe200078e0208ULL, 0x0000002008257811ULL, 0x000fe200078fe8ffULL,
0x000000081b4d7824ULL, 0x000fe200078e00ffULL, 0xfffffff822497812ULL, 0x000fe200078ee215ULL,
0x000000011c137824ULL, 0x100fe200078e0208ULL, 0x0000002408247811ULL, 0x000fe200078fe8ffULL,
0x000000081c207824ULL, 0x000fe200078e00ffULL, 0x0000001c08267811ULL, 0x040fe200078fe8ffULL,
0x0000000119057824ULL, 0x140fe200078e0208ULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee212ULL,
0x0000000819167824ULL, 0x000fe200078e00ffULL, 0xfffffff8204b7812ULL, 0x000fe200078ee213ULL,
0x0000000123157824ULL, 0x140fe200078e0208ULL, 0x00000030082c7811ULL, 0x040fe200078fe8ffULL,
0x0000000823227824ULL, 0x000fe200078e00ffULL, 0xfffffff8164f7812ULL, 0x000fe200078ee205ULL,
0x0000000125127824ULL, 0x140fe200078e0208ULL, 0x00000034082d7811ULL, 0x000fe200078fe8ffULL,
0x0000000825437824ULL, 0x000fe200078e00ffULL, 0xfffffff822357812ULL, 0x000fe200078ee215ULL,
0x0000000124137824ULL, 0x100fe200078e0208ULL, 0x0000002c08227811ULL, 0x000fe200078fe8ffULL,
0x0000000824207824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee212ULL,
0x0000000126057824ULL, 0x100fe200078e0208ULL, 0x0000003808367811ULL, 0x000fe200078fe8ffULL,
0x0000000826167824ULL, 0x000fe200078e00ffULL, 0xfffffff820377812ULL, 0x000fe200078ee213ULL,
0x000000012c127824ULL, 0x100fe200078e0208ULL, 0x0000003c083c7811ULL, 0x000fe200078fe8ffULL,
0x000000082c1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff816477812ULL, 0x000fe200078ee205ULL,
0x000000012d137824ULL, 0x000fc400078e0208ULL, 0x000000082d207824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee212ULL, 0x0000000122057824ULL, 0x100fe200078e0208ULL,
0x0000000308127211ULL, 0x000fe200078fe8ffULL, 0x0000000822167824ULL, 0x000fe200078e00ffULL,
0xfffffff820217812ULL, 0x000fe200078ee213ULL, 0x0000000136157824ULL, 0x000fe200078e0208ULL,
0x0000000808137211ULL, 0x000fe200078fe8ffULL, 0x0000000836287824ULL, 0x000fe200078e00ffULL,
0xfffffff816337812ULL, 0x000fe200078ee205ULL, 0x0000001008057824ULL, 0x000fc400078e00ffULL,
0x0000000103167824ULL, 0x000fe200078e0214ULL, 0xfffffff828277812ULL, 0x000fe200078ee215ULL,
0x0000200038147824ULL, 0x000fe200078e021fULL, 0x0000000713157812ULL, 0x000fe200078ec0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000007005057812ULL, 0x000fe400078ec0ffULL,
0x0ffffff8152f7812ULL, 0x000fe200078ef808ULL, 0x0000100014347836ULL, 0x000fe20000000000ULL,
0x0000000512177212ULL, 0x000fe200078efcffULL, 0x0000008016147825ULL, 0x000fc600078e00ffULL,
0x0000001710127210ULL, 0x000fe20007f1e0ffULL, 0x0000000103167824ULL, 0x000fe200078e0218ULL,
0x0000000514177212ULL, 0x000fe200078efcffULL, 0x000000013c207824ULL, 0x040fe400078e0208ULL,
0x000000083c297824ULL, 0x000fe200078e00ffULL, 0x0000001710147210ULL, 0x000fe20007f3e0ffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee220ULL,
0x00000001031c7824ULL, 0x000fe400078e021cULL, 0x00000010272e7824ULL, 0x100fe200078e0234ULL,
0x0000000516277212ULL, 0x000fe200078efcffULL, 0x000000101d327824ULL, 0x000fe400078e0234ULL,
0x00000001031b7824ULL, 0x000fe400078e021bULL, 0x000000801c1c7825ULL, 0x000fc800078e00ffULL,
0x0000000113137824ULL, 0x000fe200000e0611ULL, 0x0000002710167210ULL, 0x000fe20007f1e0ffULL,
0x0000000103207824ULL, 0x040fe200078e021aULL, 0x000000051c277212ULL, 0x000fe200078efcffULL,
0x0000000103197824ULL, 0x000fe400078e0219ULL, 0x000000801b1a7825ULL, 0x000fc800078e00ffULL,
0x0000001021307824ULL, 0x000fe200078e0234ULL, 0x000000051a2b7212ULL, 0x000fe200078efcffULL,
0x0000008020207825ULL, 0x000fc600078e00ffULL, 0x0000002b101a7210ULL, 0x000fe20007f5e0ffULL,
0x0000008019187825ULL, 0x000fc800078e00ffULL, 0x0000000117177824ULL, 0x000fe200000e0611ULL,
0x00000027101c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000103267824ULL, 0x040fe200078e0226ULL,
0x0000000520277212ULL, 0x000fe200078efcffULL, 0x00000001032a7824ULL, 0x000fe400078e0225ULL,
0x000000102f2f7824ULL, 0x100fe400078e0234ULL, 0x0000001031317824ULL, 0x100fe400078e0234ULL,
0x0000001051517824ULL, 0x100fe200078e0234ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000122f7faeULL, 0x0003e2000b901c46ULL, 0x000000104f4f7824ULL, 0x000fc400078e0234ULL,
0x000000104d4d7824ULL, 0x100fe400078e0234ULL, 0x000000104b4b7824ULL, 0x100fe400078e0234ULL,
0x0000001049497824ULL, 0x100fe400078e0234ULL, 0x0000001047477824ULL, 0x100fe400078e0234ULL,
0x0000001043437824ULL, 0x100fe400078e0234ULL, 0x0000001037377824ULL, 0x000fc400078e0234ULL,
0x0000001035357824ULL, 0x100fe400078e0234ULL, 0x0000001033337824ULL, 0x100fe400078e0234ULL,
0x0000001029347824ULL, 0x000fe200078e0234ULL, 0x0000000518297212ULL, 0x000fe200078efcffULL,
0x0000000103287824ULL, 0x000fe400078e0224ULL, 0x0000008026247825ULL, 0x000fc800078e00ffULL,
0x000000802a2a7825ULL, 0x000fc800078e00ffULL, 0x000000011d1d7824ULL, 0x100fe200000e0611ULL,
0x0000002710207210ULL, 0x000fe20007f1e0ffULL, 0x0000000115157824ULL, 0x000fe200008e0611ULL,
0x0000002910187210ULL, 0x000fe20007f3e0ffULL, 0x0000000103267824ULL, 0x000fe200078e0223ULL,
0x0000000524237212ULL, 0x080fe200078efcffULL, 0x0000000121217824ULL, 0x100fe200000e0611ULL,
0x000000052a537212ULL, 0x080fe200078efcffULL, 0x00000001033e7824ULL, 0x000fe200078e0222ULL,
0x0000002310227210ULL, 0x000fe20007f1e0ffULL, 0x0000000119197824ULL, 0x100fe200008e0611ULL,
0x0000005310247210ULL, 0x000fe20007f3e0ffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000000014317faeULL, 0x0003e6000b901c46ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000528557212ULL, 0x080fe200078efcffULL, 0x0000000016517faeULL, 0x0003e4000b901c46ULL,
0x0000000125237824ULL, 0x100fe200000e0611ULL, 0x0000000526577212ULL, 0x000fe200078efcffULL,
0x000000012b257824ULL, 0x000fe200008e0611ULL, 0x0000005510287210ULL, 0x000fe20007f1e0ffULL,
0x000000803e2a7825ULL, 0x000fe200078e00ffULL, 0x00000000184f7faeULL, 0x0003e6000b901c46ULL,
0x0000000103547824ULL, 0x000fc400078e022cULL, 0x0000000103567824ULL, 0x040fe200078e022dULL,
0x000000052a2d7212ULL, 0x080fe200078efcffULL, 0x0000000103527824ULL, 0x000fe400078e0236ULL,
0x000000011b1b7824ULL, 0x100fe200010e0611ULL, 0x0000005710267210ULL, 0x000fe20007f5e0ffULL,
0x00000001032c7824ULL, 0x000fe400078e023cULL, 0x0000008054547825ULL, 0x000fe200078e00ffULL,
0x000000001a4d7faeULL, 0x0003e6000b901c46ULL, 0x0000000129297824ULL, 0x100fe200000e0611ULL,
0x0000002d102a7210ULL, 0x000fe20007f1e0ffULL, 0x0000008056567825ULL, 0x000fe200078e00ffULL,
0x0000000554597212ULL, 0x080fe200078efcffULL, 0x000000001c4b7faeULL, 0x0003e4000b901c46ULL,
0x0000008052527825ULL, 0x000fe200078e00ffULL, 0x00000005565b7212ULL, 0x080fe200078efcffULL,
0x0000000020497faeULL, 0x0003e4000b901c46ULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x00000005525d7212ULL, 0x080fe200078efcffULL, 0x0000000022477faeULL, 0x0003e2000b901c46ULL,
0x0000005b10567210ULL, 0x000fe20007f3e0ffULL, 0x000000012b2b7824ULL, 0x100fe200000e0611ULL,
0x000000052c057212ULL, 0x000fe200078efcffULL, 0x0000000127277824ULL, 0x100fe200010e0611ULL,
0x0000005910547210ULL, 0x000fe20007f1e0ffULL, 0x0000000157577824ULL, 0x100fe200008e0611ULL,
0x0000005d10527210ULL, 0x000fe20007f5e0ffULL, 0x0000000024437faeULL, 0x0003e2000b901c46ULL,
0x0000000510107210ULL, 0x000fe20007f7e0ffULL, 0x0000000155557824ULL, 0x000fc400000e0611ULL,
0x0000000153537824ULL, 0x100fe200010e0611ULL, 0x0000000028377faeULL, 0x0003e2000b901c46ULL,
0x000000012d117824ULL, 0x000fc600018e0611ULL, 0x0000000026357faeULL, 0x0003e8000b901c46ULL,
0x000000002a337faeULL, 0x0003e8000b901c46ULL, 0x0000000054327faeULL, 0x0003e8000b901c46ULL,
0x0000000056307faeULL, 0x0003e8000b901c46ULL, 0x00000000522e7faeULL, 0x0003e8000b901c46ULL,
0x0000000010347faeULL, 0x0003e4000b901c46ULL, 0x000000043f3f7836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff057424ULL, 0x002fc600078e00ffULL,
0x0000003a3f00720cULL, 0x000fda0003f06070ULL, 0x00009200ff148b82ULL, 0x000e620000000a00ULL,
0x0000000207118824ULL, 0x000fe400078e023fULL, 0x0000002008167836ULL, 0x000fe20000000000ULL,
0xfffffff808177812ULL, 0x000fe200078ec0ffULL, 0x000020001e427824ULL, 0x000fe200078e021fULL,
0x0000000708437812ULL, 0x000fe200078ec0ffULL, 0x000000ffff497224ULL, 0x000fe200078e00ffULL,
0x00000004ff3e7819ULL, 0x000fe40000011608ULL, 0x0000000000127805ULL, 0x000fc4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000411148825ULL, 0x002fe200078e0014ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000614058981ULL, 0x000322000c1e1900ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000100042427836ULL, 0x000fe20000000000ULL, 0x0000000717467812ULL, 0x000fe400078ef808ULL,
0x0000000843477812ULL, 0x000fe400078ef808ULL, 0xfffffff816157812ULL, 0x002fc800078ec0ffULL,
0x00000007153c7812ULL, 0x000fce00078ef808ULL, 0x0000000146147824ULL, 0x140fe400078e0249ULL,
0x0000000846157824ULL, 0x000fe400078e00ffULL, 0x00000001494b7836ULL, 0x000fe40000000000ULL,
0x0000000249487824ULL, 0x000fe200078e023eULL, 0xfffffff815157812ULL, 0x000fe200078ee214ULL,
0x000000013c147824ULL, 0x000fe400078e0249ULL, 0x0000000846517824ULL, 0x000fe200078e00ffULL,
0x0000000247507810ULL, 0x000fe20007ffe048ULL, 0x0000001015187824ULL, 0x000fc400078e0242ULL,
0x000000083c157824ULL, 0x000fe400078e00ffULL, 0x00000001464c7824ULL, 0x000fe400078e024bULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0xfffffff815157812ULL, 0x000fe200078ee214ULL,
0x00000010474d7824ULL, 0x040fe200078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee24cULL,
0x00000001474a7824ULL, 0x000fe400078e0248ULL, 0x0000001015157824ULL, 0x000fc400078e0242ULL,
0x000000013c717824ULL, 0x040fe200078e024bULL, 0xfffffff04d487812ULL, 0x000fe200078ee24aULL,
0x00000010474f7824ULL, 0x000fe400078e00ffULL, 0x000000001514783bULL, 0x000ea20000000200ULL,
0x000000083c4e7824ULL, 0x000fe400078e00ffULL, 0xfffffff04f507812ULL, 0x000fe200078ee250ULL,
0x0000000249497836ULL, 0x000fe40000000000ULL, 0xfffffff84e717812ULL, 0x000fc600078ee271ULL,
0x000000084900780cULL, 0x000fe40003f05270ULL, 0x00000010ff4a7819ULL, 0x102fe40000011618ULL,
0x00000018ff4b7819ULL, 0x000fe40000011618ULL, 0x000000ff184d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff18547812ULL, 0x000fe200078ec0ffULL, 0x0000001051187824ULL, 0x000fe200078e0242ULL,
0x00000010ff4e7819ULL, 0x000fc40000011619ULL, 0x00000018ff4f7819ULL, 0x000fe40000011619ULL,
0x000000ff19777812ULL, 0x040fe400078ec0ffULL, 0x0000ffff196f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4c7819ULL, 0x100fe4000001161aULL, 0x00000018ff767819ULL, 0x000fe4000001161aULL,
0x000000ff1a747812ULL, 0x000fc400078ec0ffULL, 0x0000ffff1a727812ULL, 0x000fe400078ec0ffULL,
0x00000010ff537819ULL, 0x100fe4000001161bULL, 0x00000018ff757819ULL, 0x000fe4000001161bULL,
0x000000ff1b527812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1b5c7812ULL, 0x000fe400078ec0ffULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0x00000010ff617819ULL, 0x004fc40000011614ULL,
0x00000018ff737819ULL, 0x000fe40000011614ULL, 0x000000ff14707812ULL, 0x040fe400078ec0ffULL,
0x0000ffff14667812ULL, 0x000fe400078ec0ffULL, 0x00000008ff147819ULL, 0x000fe40000011654ULL,
0x000000ff4e4e7812ULL, 0x000fe400078ec0ffULL, 0x00000014ff14723eULL, 0x000fc400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x00000010ff687819ULL, 0x100fe40000011615ULL,
0x00000018ff6e7819ULL, 0x000fe40000011615ULL, 0x000000ff156d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff15677812ULL, 0x000fe200078ec0ffULL, 0x20000014ff157230ULL, 0x000fe20000004100ULL,
0x000000ff4a4a7812ULL, 0x000fe200078ec0ffULL, 0x0000001048147824ULL, 0x000fe200078e020dULL,
0x00000010ff647819ULL, 0x000fc40000011616ULL, 0x00000018ff6b7819ULL, 0x000fe40000011616ULL,
0x000000ff166a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff16627812ULL, 0x000fe200078ec0ffULL,
0x2000004eff167230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x100fe20000011617ULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000018ff6c7819ULL, 0x000fe20000011617ULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x000000ff17697812ULL, 0x000fc400078ec0ffULL,
0x0000ffff17657812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4e7819ULL, 0x000fe40000011615ULL,
0x00000010ff487819ULL, 0x000fe40000011616ULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000010ff4a7819ULL, 0x000fc4000001164aULL, 0x00000010ff517819ULL, 0x000fe4000001164fULL,
0x00000008ff6f7819ULL, 0x000fe4000001166fULL, 0x000010544e4e7816ULL, 0x000fe4000000004dULL,
0x000010544b4f7816ULL, 0x000fe4000000004aULL, 0x00001054514d7816ULL, 0x000fe40000000048ULL,
0x00000010ff4a7819ULL, 0x002fc40000011618ULL, 0x00000018ff607819ULL, 0x000fe40000011618ULL,
0x000000ff185f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff18487812ULL, 0x000fe400078ec0ffULL,
0x0000006fff18723eULL, 0x000fe400020006ffULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000010ff4b7819ULL, 0x100fe20000011619ULL, 0x20000018ff187230ULL, 0x000fe20000004100ULL,
0x00000018ff5e7819ULL, 0x000fe20000011619ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x000000ff195d7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff195a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff557819ULL, 0x100fe4000001161aULL, 0x00000018ff5b7819ULL, 0x000fe2000001161aULL,
0x0000004e1434723cULL, 0x004fe20000041834ULL, 0x000000ff1a587812ULL, 0x040fe400078ec0ffULL,
0x0000ffff1a597812ULL, 0x000fe400078ec0ffULL, 0x00000074ff19723eULL, 0x000fc400020006ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000075ff1a723eULL, 0x000fe200020006ffULL,
0x20000019ff757230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x20000076ff747230ULL, 0x000fe20000004100ULL, 0x00000010ff197819ULL, 0x000fe20000011618ULL,
0x2000001aff6f7230ULL, 0x000fe20000004100ULL, 0x00000073ff1a723eULL, 0x000fe200020006ffULL,
0x0000001071187824ULL, 0x000fe200078e0242ULL, 0x000000ff4c767812ULL, 0x000fc400078ec0ffULL,
0x00000010ff4c7819ULL, 0x000fe40000011677ULL, 0x00000070ff73723eULL, 0x000fe200020006ffULL,
0x20000052ff707230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x100fe2000001161bULL,
0x2000001aff527230ULL, 0x000fe20000004100ULL, 0x00000018ff577819ULL, 0x000fe4000001161bULL,
0x000000ff1b567812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1b547812ULL, 0x000fc400078ec0ffULL,
0x00001054194c7816ULL, 0x000fe4000000004cULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0x00000008ff727819ULL, 0x000fe40000011672ULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x000000ff534e7812ULL, 0x000fe200078ec0ffULL, 0x20000073ff537230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00000008ff5c7819ULL, 0x000fe2000001165cULL, 0x0000004c1430723cULL, 0x000fe20000041830ULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x000000ff61617812ULL, 0x000fc400078ec0ffULL, 0x0000005cff73723eULL, 0x000fe400020006ffULL,
0x00000061ff5c723eULL, 0x000fe200020006ffULL, 0x2000004eff617230ULL, 0x000fe20000004100ULL,
0x00000008ff667819ULL, 0x000fe20000011666ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe20000011674ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff4e7819ULL, 0x000fe40000011675ULL, 0x00000010ff4f7819ULL, 0x000fc40000011676ULL,
0x00000010ff717819ULL, 0x000fe40000011672ULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00001054744f7816ULL, 0x000fe4000000004fULL, 0x00001054714e7816ULL, 0x000fe2000000004eULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe4000001166fULL,
0x00000010ff4c7819ULL, 0x000fc40000011670ULL, 0x00000010ff4d7819ULL, 0x000fe20000011661ULL,
0x0000004e142c723cULL, 0x000fe2000004182cULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00001054724d7816ULL, 0x000fe4000000004dULL, 0x00001054734c7816ULL, 0x000fe4000000004cULL,
0x00000010ff4e7819ULL, 0x000fe40000011652ULL, 0x00000010ff527819ULL, 0x000fc40000011653ULL,
0x00000010ff4f7819ULL, 0x000fe20000011666ULL, 0x0000004c1428723cULL, 0x000fe20000041828ULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff537819ULL, 0x000fe4000001165cULL, 0x000010544f527816ULL, 0x000fe40000000052ULL,
0x00000010ff617819ULL, 0x002fc4000001161bULL, 0x00000018ff4f7819ULL, 0x000fe4000001161bULL,
0x000000ff1b787812ULL, 0x040fe400078ec0ffULL, 0x0000ffff1b5c7812ULL, 0x000fe400078ec0ffULL,
0x00000068ff1b723eULL, 0x000fe200020006ffULL, 0x2000005fff687230ULL, 0x000fe20000004100ULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000057ff5f723eULL, 0x000fe200020006ffULL,
0x2000001bff1b7230ULL, 0x000fe20000004100ULL, 0x00000018ff4d7819ULL, 0x000fc4000001161aULL,
0x00000008ff677819ULL, 0x000fe40000011667ULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000056ff57723eULL, 0x000fe200020006ffULL, 0x2000005fff567230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x20000064ff727230ULL, 0x000fe20000004100ULL,
0x0000004dff5f723eULL, 0x000fe200020006ffULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x20000067ff777230ULL, 0x000fe20000004100ULL,
0x000010544e537816ULL, 0x000fc40000000053ULL, 0x000000ff63637812ULL, 0x000fe200078ec0ffULL,
0x20000060ff677230ULL, 0x000fe20000004100ULL, 0x000000ff1a4e7812ULL, 0x000fe400078ec0ffULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x000000521424723cULL, 0x000fe20000041824ULL,
0x0000004fff64723eULL, 0x000fe200020006ffULL, 0x2000005fff4f7230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x2000006bff717230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fc400020006ffULL, 0x000000ff4a5f7812ULL, 0x000fe200078ec0ffULL,
0x2000006cff6b7230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x20000063ff6c7230ULL, 0x000fe20000004100ULL, 0x0000004eff60723eULL, 0x000fe400020006ffULL,
0x000000ff55557812ULL, 0x000fe200078ec0ffULL, 0x2000005dff637230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000060ff4a7230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x00000010ff767819ULL, 0x100fe40000011618ULL,
0x00000018ff7b7819ULL, 0x000fe20000011618ULL, 0x2000005bff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff187a7812ULL, 0x040fe400078ec0ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x0000ffff18187812ULL, 0x000fc400078ec0ffULL,
0x000000ff194c7812ULL, 0x040fe400078ec0ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000010ff757819ULL, 0x100fe40000011619ULL,
0x00000018ff797819ULL, 0x000fe40000011619ULL, 0x0000ffff196f7812ULL, 0x000fe200078ec0ffULL,
0x2000006eff197230ULL, 0x000fe20000004100ULL, 0x000000ff4b607812ULL, 0x000fe200078ec0ffULL,
0x20000069ff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fe2000001161aULL,
0x2000005fff697230ULL, 0x000fe20000004100ULL, 0x0000ffff1a667812ULL, 0x000fe200078ec0ffULL,
0x2000006dff1a7230ULL, 0x000fe20000004100ULL, 0x0000004cff5b723eULL, 0x000fe200020006ffULL,
0x20000055ff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff597819ULL, 0x000fc40000011659ULL,
0x00000008ff187819ULL, 0x000fe20000011618ULL, 0x2000005bff4e7230ULL, 0x000fe20000004100ULL,
0x000000ff51517812ULL, 0x000fe400078ec0ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x000000ff75557812ULL, 0x000fe400078ec0ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x00000018ff75723eULL, 0x000fc400020006ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x00000010ff187819ULL, 0x000fe20000011619ULL, 0x0000001050197824ULL, 0x000fe200078e020dULL,
0x00000008ff5b7819ULL, 0x000fe20000011648ULL, 0x20000064ff487230ULL, 0x000fe20000004100ULL,
0x00000010ff1b7819ULL, 0x000fe2000001161bULL, 0x20000060ff647230ULL, 0x000fe20000004100ULL,
0x00000010ff1a7819ULL, 0x000fe2000001161aULL, 0x20000059ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff777819ULL, 0x000fe20000011677ULL, 0x20000051ff597230ULL, 0x000fe20000004100ULL,
0x0000105418517816ULL, 0x000fc4000000001bULL, 0x0000105477507816ULL, 0x000fe4000000001aULL,
0x000000001918783bULL, 0x000e620000000200ULL, 0x00000008ff657819ULL, 0x000fe40000011665ULL,
0x00000008ff627819ULL, 0x000fe40000011662ULL, 0x00000008ff5a7819ULL, 0x000fe2000001165aULL,
0x000000501420723cULL, 0x000fe20000041820ULL, 0x00000008ff547819ULL, 0x000fe40000011654ULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x20000065ff6d7230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x2000006aff747230ULL, 0x000fe20000004100ULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x20000062ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff537819ULL, 0x000fe20000011672ULL, 0x2000005aff657230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fe20000011674ULL, 0x20000054ff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe20000011673ULL, 0x20000075ff547230ULL, 0x000fe20000004100ULL,
0x000000ff70757812ULL, 0x000fc400078ec0ffULL, 0x00000010ff707819ULL, 0x000fe40000011671ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x0000105470537816ULL, 0x000fe40000000053ULL,
0x0000105473527816ULL, 0x000fe20000000052ULL, 0x2000005bff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe4000001166bULL, 0x00000010ff507819ULL, 0x000fc4000001166eULL,
0x00000010ff517819ULL, 0x000fe2000001166cULL, 0x00000052141c723cULL, 0x000fe2000004181cULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x0000105470517816ULL, 0x000fe40000000051ULL,
0x000010546d507816ULL, 0x000fe40000000050ULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000010ff527819ULL, 0x000fc40000011667ULL, 0x00000010ff687819ULL, 0x000fe20000011668ULL,
0x000000501410723cULL, 0x000fe20000041810ULL, 0x00000010ff697819ULL, 0x000fe20000011669ULL,
0x2000005eff627230ULL, 0x000fe20000004100ULL, 0x00000010ff537819ULL, 0x000fe4000001166aULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x0000105452177816ULL, 0x000fe40000000069ULL,
0x0000105453167816ULL, 0x000fe20000000068ULL, 0x20000058ff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fc40000011662ULL, 0x00000010ff147819ULL, 0x000fe40000011663ULL,
0x00000010ff157819ULL, 0x000fe20000011664ULL, 0x000000161834723cULL, 0x002fe20000041834ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000008ff6f7819ULL, 0x000fe4000001166fULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000010ff507819ULL, 0x000fc4000001165dULL,
0x00000010ff167819ULL, 0x000fe2000001165eULL, 0x2000007aff4c7230ULL, 0x000fe20000004100ULL,
0x00000010ff177819ULL, 0x000fe4000001165fULL, 0x00000010ff517819ULL, 0x000fe40000011660ULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x0000105462157816ULL, 0x000fe40000000015ULL,
0x0000105465147816ULL, 0x000fe20000000014ULL, 0x20000079ff4d7230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fc400020006ffULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x000000ff76767812ULL, 0x000fe200078ec0ffULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x00000008ff667819ULL, 0x000fe20000011666ULL, 0x2000006fff6c7230ULL, 0x000fe20000004100ULL,
0x000000ff61617812ULL, 0x000fe200078ec0ffULL, 0x000000141830723cULL, 0x000fe20000041830ULL,
0x00000008ff5c7819ULL, 0x000fe4000001165cULL, 0x0000105450177816ULL, 0x000fc40000000017ULL,
0x0000105451167816ULL, 0x000fe40000000016ULL, 0x0000007bff58723eULL, 0x000fe400020006ffULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000076ff5b723eULL, 0x000fe200020006ffULL,
0x00000016182c723cULL, 0x000fe2000004182cULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x20000078ff4b7230ULL, 0x000fe20000004100ULL, 0x00000061ff53723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000075ff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff147819ULL, 0x000fe2000001164cULL,
0x20000066ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff4c7819ULL, 0x000fe2000001164eULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000010ff167819ULL, 0x000fe2000001164dULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff4e7819ULL, 0x000fc4000001164fULL,
0x00000010ff4d7819ULL, 0x000fe40000011655ULL, 0x00000010ff4f7819ULL, 0x000fe4000001166cULL,
0x00000010ff507819ULL, 0x000fe40000011657ULL, 0x00000010ff157819ULL, 0x000fe4000001165aULL,
0x00000010ff177819ULL, 0x000fe40000011654ULL, 0x00001054164d7816ULL, 0x000fc4000000004dULL,
0x000010544f4c7816ULL, 0x000fe4000000004cULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff517819ULL, 0x000fe20000011659ULL,
0x0000004c1820723cULL, 0x000fe20000041820ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff6b7819ULL, 0x000fc4000001166bULL, 0x00000010ff167819ULL, 0x000fe4000001164aULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff4f7819ULL, 0x000fe40000011652ULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000010ff5c7819ULL, 0x000fc4000001165cULL, 0x0000105415507816ULL, 0x000fe40000000050ULL,
0x0000105417147816ULL, 0x000fe40000000014ULL, 0x0000105456517816ULL, 0x000fe40000000051ULL,
0x0000105458157816ULL, 0x000fe4000000005bULL, 0x000010544e177816ULL, 0x000fe4000000006bULL,
0x000010544f167816ULL, 0x000fe20000000016ULL, 0x000000501828723cULL, 0x000fe20000041828ULL,
0x00001054485d7816ULL, 0x000fc40000000053ULL, 0x000010545c5c7816ULL, 0x000fc6000000004bULL,
0x000000141824723cULL, 0x000fec0000041824ULL, 0x00000016181c723cULL, 0x000fec000004181cULL,
0x0000005c1810723cULL, 0x000fe20000041810ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffe800300947ULL, 0x000fde000383ffffULL, 0x00000001ff147424ULL, 0x000fe400078e00ffULL,
0x0000000934177220ULL, 0x080fe20000410000ULL, 0x00000009273c7220ULL, 0x080fe20000410000ULL,
0x0000000924347220ULL, 0x080fe20000410000ULL, 0x00000009253e7220ULL, 0x080fe20000410000ULL,
0x0000000926427220ULL, 0x080fe20000410000ULL, 0x017688140b1479a7ULL, 0x000262000850003fULL,
0x0000000923277220ULL, 0x080fe20000410000ULL, 0x0000000935357220ULL, 0x080fe20000410000ULL,
0x0000000936367220ULL, 0x080fe20000410000ULL, 0x0000000937377220ULL, 0x080fe20000410000ULL,
0x0000000930167220ULL, 0x080fe20000410000ULL, 0x0000000931317220ULL, 0x080fe20000410000ULL,
0x0000000932327220ULL, 0x080fe20000410000ULL, 0x0000000933337220ULL, 0x080fe20000410000ULL,
0x000000092c1a7220ULL, 0x080fe20000410000ULL, 0x000000092d2d7220ULL, 0x080fe20000410000ULL,
0x000000092e2e7220ULL, 0x080fe20000410000ULL, 0x000000092f2f7220ULL, 0x080fe20000410000ULL,
0x0000000928287220ULL, 0x080fe20000410000ULL, 0x0000000929297220ULL, 0x080fe20000410000ULL,
0x000000092a2a7220ULL, 0x080fe20000410000ULL, 0x000000092b2b7220ULL, 0x080fe20000410000ULL,
0x0000000920207220ULL, 0x080fe20000410000ULL, 0x0000000921217220ULL, 0x080fe20000410000ULL,
0x0000000922227220ULL, 0x080fe20000410000ULL, 0x000000091c237220ULL, 0x080fe20000410000ULL,
0x000000091d467220ULL, 0x080fe20000410000ULL, 0x000000091e257220ULL, 0x080fe20000410000ULL,
0x000000091f247220ULL, 0x080fe20000410000ULL, 0x0000000910477220ULL, 0x080fe20000410000ULL,
0x0000000911487220ULL, 0x080fe20000410000ULL, 0x00000009121b7220ULL, 0x080fe20000410000ULL,
0x0000000913267220ULL, 0x002fce0000410000ULL, 0x0000000000107805ULL, 0x000fce0000015200ULL,
0x017688150b0075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff187224ULL, 0x000fce00078e00ffULL, 0x000000101800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fce0000015200ULL,
0x0000001210197210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001912127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000118187836ULL, 0x000fce0000000000ULL, 0x017688150b0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000408107824ULL, 0x000fe200078e00ffULL,
0x000000063d00720cULL, 0x000fe20003f06070ULL, 0x0000008040117824ULL, 0x000fc600078e020dULL,
0xfffffff010107812ULL, 0x000fca00078ec0ffULL, 0x0000000111307824ULL, 0x000fca00078e0210ULL,
0x01740000301c7984ULL, 0x0002a20000000c00ULL, 0x0000001400248947ULL, 0x000fea0003800000ULL,
0x0000860000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x0000000400137d06ULL, 0x000ee20008209000ULL, 0x000001003d2c7824ULL, 0x000fe200078e0204ULL,
0x00000004ff007c0cULL, 0x000fe2000bf85070ULL, 0x0000000208497824ULL, 0x000fe200078e00ffULL,
0x00000004ff187c12ULL, 0x000fc8000f8e33ffULL, 0x0000000649497812ULL, 0x000fca00078ec0ffULL,
0x00000001494b7824ULL, 0x000fe200078e0200ULL, 0x0000001300137308ULL, 0x008ee40000001000ULL,
0x0ffffffe13147836ULL, 0x008fcc0000000000ULL, 0x0000001400117305ULL, 0x000ee4000021f000ULL,
0x000000ffff157224ULL, 0x008fc800078e0a11ULL, 0x0000000415157c24ULL, 0x000fc8000f8e02ffULL,
0x0000001511157227ULL, 0x000fe200078e0010ULL, 0x0000004108107211ULL, 0x000fca00078ff0ffULL,
0x0000001015127227ULL, 0x000fc800078e00ffULL, 0x000000ffff117224ULL, 0x000fc800078e0a12ULL,
0x0000000411117c24ULL, 0x000fe4000f8e0210ULL, 0x0000000810107836ULL, 0x000fc60000000000ULL,
0x0000000411007c0cULL, 0x000fe2000bf06070ULL, 0x0000001015157227ULL, 0x000fc800078e00ffULL,
0x000000ffff137224ULL, 0x000fc800078e0a15ULL, 0x0000000413107c24ULL, 0x000fe4000f8e0210ULL,
0x000000010e137824ULL, 0x000fe400078e0249ULL, 0x8000000411110c36ULL, 0x000fe20008000000ULL,
0x0000000410007c0cULL, 0x000fe2000bf46070ULL, 0x0000000112120836ULL, 0x000fc60000000000ULL,
0x0000000411007c0cULL, 0x000fe4000bf26070ULL, 0x0000002c3b117248ULL, 0x000fca0007fe0000ULL,
0x00000001112c7824ULL, 0x000fe400078e0a2cULL, 0x8000000410102c36ULL, 0x000fe40008000000ULL,
0x000000ffff637224ULL, 0x000fe200078e0a2cULL, 0x0000002c1300720cULL, 0x000fe20003f66070ULL,
0x0000000112121836ULL, 0x000fe20000000000ULL, 0x0000000410007c0cULL, 0x000fe2000bf06070ULL,
0x0000000115152836ULL, 0x000fe20000000000ULL, 0x0000006313137246ULL, 0x000fe4000380000cULL,
0x0000001218117207ULL, 0x000fc40006000000ULL, 0x00000004ff137819ULL, 0x000fe40000011613ULL,
0x000000110c117248ULL, 0x000fe40003fe0000ULL, 0x000000ff13147207ULL, 0x000fe40001800000ULL,
0x0000002c4b00720cULL, 0x000fe20003f26070ULL, 0x0000000511657c24ULL, 0x000fe2000f8e02ffULL,
0x000000634b567246ULL, 0x000fe2000380000cULL, 0x0000000115150836ULL, 0x000fe40000000000ULL,
0x0000000165117824ULL, 0x000fe200078e0214ULL, 0x000000ff56567207ULL, 0x000fc40000800000ULL,
0x00000010494d7812ULL, 0x000fe200078efcffULL, 0x0000000211107825ULL, 0x100fe200078e0044ULL,
0x0000006556137211ULL, 0x000fe400078fe0ffULL, 0x0000001518157207ULL, 0x000fe40006000000ULL,
0x00000006105a7981ULL, 0x0044e2000c1e9500ULL, 0x0000000213127825ULL, 0x000fe200078e0044ULL,
0x000000150c157248ULL, 0x000fc80003fe0000ULL, 0x0000000612617981ULL, 0x000ae2000c1e9500ULL,
0x000000010e117824ULL, 0x004fe400078e024dULL, 0x0000000515677c24ULL, 0x000fc6000f8e02ffULL,
0x0000006311107246ULL, 0x000fe4000380000cULL, 0x0000002c1100720cULL, 0x000fe40003f26070ULL,
0x00000004ff107819ULL, 0x000fe20000011610ULL, 0x0000000114157824ULL, 0x000fe200078e0267ULL,
0x0000006756197211ULL, 0x000fe400078fe0ffULL, 0x000000ff104e7207ULL, 0x000fe40000800000ULL,
0x0000002049537812ULL, 0x000fe200078efcffULL, 0x0000000215147825ULL, 0x000fc800078e0044ULL,
0x0000000219187825ULL, 0x000fe200078e0044ULL, 0x0000000614587981ULL, 0x0004e6000c1e9500ULL,
0x000000014d4f7824ULL, 0x000fe200078e0200ULL, 0x0000000618697981ULL, 0x0004e2000c1e9500ULL,
0x0000000165117824ULL, 0x000fe400078e024eULL, 0x000000010e577824ULL, 0x000fe200078e0253ULL,
0x0000002c4f00720cULL, 0x000fe20003f06070ULL, 0x0000000211107825ULL, 0x000fe200078e0044ULL,
0x000000634f4a7246ULL, 0x000fc4000380000cULL, 0x0000006357507246ULL, 0x000fe4000380000cULL,
0x000000ff4a4a7207ULL, 0x000fe20000000000ULL, 0x00000006104c7981ULL, 0x0004e2000c1e9500ULL,
0x0000002c5700720cULL, 0x000fe20003f26070ULL, 0x0000000153557824ULL, 0x000fe200078e0200ULL,
0x000000654a137211ULL, 0x022fe200078fe0ffULL, 0x000000014e157824ULL, 0x004fe200078e0267ULL,
0x000000674a197211ULL, 0x000fe400078fe0ffULL, 0x00000004ff107819ULL, 0x000fc40000011650ULL,
0x0000003049597812ULL, 0x000fe400078efcffULL, 0x000000ff10547207ULL, 0x000fe20000800000ULL,
0x0000000213127825ULL, 0x100fe200078e0044ULL, 0x0000002c5500720cULL, 0x000fe40003f06070ULL,
0x0000006355507246ULL, 0x000fe2000380000cULL, 0x0000000215147825ULL, 0x100fe200078e0044ULL,
0x0000000612517981ULL, 0x0002a6000c1e9500ULL, 0x0000000219187825ULL, 0x000fe200078e0044ULL,
0x000000ff50507207ULL, 0x000fe20000000000ULL, 0x00000006144e7981ULL, 0x000aa4000c1e9500ULL,
0x0000000165117824ULL, 0x000fc400078e0254ULL, 0x000000010e6b7824ULL, 0x000fe200078e0259ULL,
0x0000000618577981ULL, 0x000aa2000c1e9500ULL, 0x0000000211107825ULL, 0x000fe200078e0044ULL,
0x0000006550137211ULL, 0x002fe400078fe0ffULL, 0x000000636b5c7246ULL, 0x000fe2000380000cULL,
0x00000001595d7824ULL, 0x000fe200078e0200ULL, 0x0000000610527981ULL, 0x0002a2000c1e9500ULL,
0x0000000154157824ULL, 0x020fe200078e0267ULL, 0x0000006750197211ULL, 0x000fe200078fe0ffULL,
0x0000000213127825ULL, 0x000fe200078e0044ULL, 0x0000002c6b00720cULL, 0x000fc40003f26070ULL,
0x0000002c5d00720cULL, 0x000fe40003f06070ULL, 0x00000004ff107819ULL, 0x002fe2000001165cULL,
0x0000000215147825ULL, 0x100fe200078e0044ULL, 0x000000635d5c7246ULL, 0x000fe2000380000cULL,
0x00000006125b7981ULL, 0x000364000c1e9500ULL, 0x0000000219187825ULL, 0x000fe200078e0044ULL,
0x000000ff105e7207ULL, 0x000fe20000800000ULL, 0x0000000614547981ULL, 0x000362000c1e9500ULL,
0x000000ff5c5c7207ULL, 0x000fc60000000000ULL, 0x00000006185f7981ULL, 0x000362000c1e9500ULL,
0x0000000165117824ULL, 0x000fe200078e025eULL, 0x000000655c137211ULL, 0x002fc600078fe0ffULL,
0x0000000211107825ULL, 0x000fc800078e0044ULL, 0x0000000213127825ULL, 0x000fe400078e0044ULL,
0x0000000610107981ULL, 0x000362000c1e9500ULL, 0x000000675c157211ULL, 0x000fc600078fe0ffULL,
0x0000000612137981ULL, 0x000362000c1e9500ULL, 0x000000015e197824ULL, 0x000fe400078e0267ULL,
0x0000000215147825ULL, 0x000fc800078e0044ULL, 0x0000000219187825ULL, 0x000fe400078e0044ULL,
0x0000000614147981ULL, 0x000f68000c1e9500ULL, 0x0000000618197981ULL, 0x000362000c1e9500ULL,
0xfffffff056637812ULL, 0x000fe200078ec0ffULL, 0x00000001ff567424ULL, 0x000fc800078e00ffULL,
0x000000012c5e7824ULL, 0x000fc800078e0263ULL, 0x000000014b6b7824ULL, 0x000fe200078e0a5eULL,
0x0000000149117812ULL, 0x042fe400078efcffULL, 0x0000000949637812ULL, 0x000fe400078efcffULL,
0x0000006b566b7219ULL, 0x000fe200000006ffULL, 0x0000000111657824ULL, 0x100fe400078e0200ULL,
0x0000000163677824ULL, 0x000fe400078e0200ULL, 0x00000001656d7824ULL, 0x000fc400078e0a5eULL,
0x0000000167717824ULL, 0x000fc600078e0a5eULL, 0x0000006d566d7219ULL, 0x040fe400000006ffULL,
0x0000007156717219ULL, 0x000fe400000006ffULL, 0x0000001849797812ULL, 0x000fca00078efcffULL,
0x0000000179127824ULL, 0x000fe200078e0200ULL, 0x00000011497b7812ULL, 0x040fe400078efcffULL,
0x0000001949777812ULL, 0x000fc600078efcffULL, 0x000000017b187824ULL, 0x100fe400078e0200ULL,
0x00000001777d7824ULL, 0x000fe200078e0200ULL, 0x0000002149737812ULL, 0x000fe400078efcffULL,
0xfffffff05c5c7812ULL, 0x000fc600078ec0ffULL, 0x0000000173757824ULL, 0x000fe400078e0200ULL,
0x000000012c627824ULL, 0x000fc800078e025cULL, 0x000000015d6e7824ULL, 0x000fca00078e0a62ULL,
0x0000006e566e7219ULL, 0x000fe400000006ffULL, 0x00005410615a7816ULL, 0x008fe4000000005aULL,
0x0000000849617812ULL, 0x000fe400078efcffULL, 0x0000005a6bff7212ULL, 0x000fc6000780c0ffULL,
0x0000000161157824ULL, 0x000fe200078e0200ULL, 0x0000002c4b00720cULL, 0x000fc60000701470ULL,
0x00000001156f7824ULL, 0x000fe200078e0a5eULL, 0x0000002c4900720cULL, 0x000fc800007a1070ULL,
0x0000006f566f7219ULL, 0x000fe400000006ffULL, 0xff80000017177808ULL, 0x000fe40002800000ULL,
0x0000541069587816ULL, 0x000fc80000000058ULL, 0x000000586bff7212ULL, 0x080fe4000784c0ffULL,
0x000000586dff7212ULL, 0x080fe4000780c0ffULL, 0x000000586fff7212ULL, 0x080fe400078cc0ffULL,
0x0000005871ff7212ULL, 0x000fe400078ac0ffULL, 0xfffffff04a587812ULL, 0x000fca00078ec0ffULL,
0x000000012c587824ULL, 0x000fe200078e0258ULL, 0x0000002c4b00720cULL, 0x080fe40001741470ULL,
0x0000002c1500720cULL, 0x080fe200037c1470ULL, 0x000000014f647824ULL, 0x100fe200078e0a58ULL,
0x0000002c6700720cULL, 0x000fe20002fa1470ULL, 0x0000000112687824ULL, 0x000fe200078e0a58ULL,
0x0000005a6dff7212ULL, 0x080fe4000782c0ffULL, 0x0000005a6fff7212ULL, 0x080fe4000786c0ffULL,
0x0000005a71ff7212ULL, 0x000fc4000788c0ffULL, 0xfffffff0505a7812ULL, 0x000fe400078ec0ffULL,
0x0000002c4900720cULL, 0x080fe40001741070ULL, 0x0000002c6100720cULL, 0x080fe400037c1070ULL,
0x0000002c6300720cULL, 0x000fe40002fa1070ULL, 0x0000006456647219ULL, 0x040fe400000006ffULL,
0x0000006856687219ULL, 0x000fc400000006ffULL, 0x0000541051517816ULL, 0x004fe4000000004cULL,
0x0000541057577816ULL, 0x000fe2000000004eULL, 0x000000012c5a7824ULL, 0x000fe200078e025aULL,
0xff80000036367808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40003000000ULL,
0xff80000033337808ULL, 0x000fe40002800000ULL, 0x0000005164ff7212ULL, 0x000fc4000784c0ffULL,
0x0000005764ff7212ULL, 0x080fe400078cc0ffULL, 0x0000005768ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000118667824ULL, 0x100fe200078e0a58ULL, 0x0000002c6500720cULL, 0x080fe20000f21470ULL,
0x000000017d6a7824ULL, 0x000fe200078e0a58ULL, 0x0000002c6500720cULL, 0x080fe20000701470ULL,
0x00000001556c7824ULL, 0x000fe200078e0a5aULL, 0x0000002c1500720cULL, 0x080fe40001f61470ULL,
0x0000002c6700720cULL, 0x000fc40002781470ULL, 0x0000002c4f00720cULL, 0x0c0fe40001741470ULL,
0x0000002c4f00720cULL, 0x080fe400037c1470ULL, 0x0000002c1200720cULL, 0x080fe40002fa1470ULL,
0x0000002849717812ULL, 0x040fe400078efcffULL, 0x00000029496f7812ULL, 0x000fe400078efcffULL,
0x0000002c1100720cULL, 0x000fc40000f21070ULL, 0x0000002c1100720cULL, 0x080fe40000701070ULL,
0x0000002c6100720cULL, 0x080fe40001f61070ULL, 0x0000002c6300720cULL, 0x080fe40002781070ULL,
0x0000002c4d00720cULL, 0x0c0fe40001741070ULL, 0x0000002c4d00720cULL, 0x080fe400037c1070ULL,
0x0000002c7900720cULL, 0x000fc40002fa1070ULL, 0x0000006656667219ULL, 0x040fe400000006ffULL,
0x0000006a566a7219ULL, 0x040fe400000006ffULL, 0x0000006c566c7219ULL, 0x000fe400000006ffULL,
0x000054105b5b7816ULL, 0x020fe40000000052ULL, 0x000054105f5f7816ULL, 0x000fe20000000054ULL,
0x00000001714a7824ULL, 0x100fe200078e0200ULL, 0xff80000035357808ULL, 0x000fe20000800000ULL,
0x000000016f507824ULL, 0x000fe200078e0200ULL, 0xff80000037377808ULL, 0x000fc40000000000ULL,
0xff80000016167808ULL, 0x000fe40001800000ULL, 0xff80000031317808ULL, 0x000fe40002000000ULL,
0xff8000001a1a7808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40003000000ULL,
0xff8000002a2a7808ULL, 0x000fe40002800000ULL, 0x0000005166ff7212ULL, 0x000fc4000782c0ffULL,
0x0000005168ff7212ULL, 0x080fe4000780c0ffULL, 0x000000516aff7212ULL, 0x000fe4000786c0ffULL,
0x0000005766ff7212ULL, 0x080fe4000788c0ffULL, 0x000000576aff7212ULL, 0x000fe4000784c0ffULL,
0x0000005b6cff7212ULL, 0x040fe400078cc0ffULL, 0x0000005f6cff7212ULL, 0x000fe200078ac0ffULL,
0x0000000175727824ULL, 0x100fe200078e0a5aULL, 0x0000002c1800720cULL, 0x080fe20000f21470ULL,
0x000000014a747824ULL, 0x100fe200078e0a5aULL, 0x0000002c1800720cULL, 0x080fe20002781470ULL,
0x0000000150707824ULL, 0x000fe200078e0a5aULL, 0x0000002c1200720cULL, 0x000fc40000701470ULL,
0x0000002c7d00720cULL, 0x0c0fe40001f61470ULL, 0x0000002c7d00720cULL, 0x080fe40001741470ULL,
0x0000002c5500720cULL, 0x0c0fe400037c1470ULL, 0x0000002c5500720cULL, 0x000fe40002fa1470ULL,
0x00000031496d7812ULL, 0x040fe400078efcffULL, 0x00000038496b7812ULL, 0x000fc400078efcffULL,
0x0000003949697812ULL, 0x000fe400078efcffULL, 0x0000002c7b00720cULL, 0x0c0fe40000f21070ULL,
0x0000002c7b00720cULL, 0x080fe40002781070ULL, 0x0000002c7900720cULL, 0x080fe40000701070ULL,
0x0000002c7700720cULL, 0x0c0fe40001f61070ULL, 0x0000002c7700720cULL, 0x000fc40001741070ULL,
0x0000002c5300720cULL, 0x0c0fe400037c1070ULL, 0x0000002c5300720cULL, 0x000fe40002fa1070ULL,
0x0000007256727219ULL, 0x040fe400000006ffULL, 0x0000007456747219ULL, 0x040fe400000006ffULL,
0x0000007056707219ULL, 0x000fe400000006ffULL, 0x0000541013137816ULL, 0x000fe20000000010ULL,
0x000000016d587824ULL, 0x100fe200078e0200ULL, 0xff8000002d2d7808ULL, 0x000fe20000800000ULL,
0x000000016b5a7824ULL, 0x100fe200078e0200ULL, 0xff8000002f2f7808ULL, 0x000fe20002000000ULL,
0x00000001695c7824ULL, 0x000fe200078e0200ULL, 0xff80000028287808ULL, 0x000fc40000000000ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff8000002b2b7808ULL, 0x000fe40001000000ULL,
0xff80000034347808ULL, 0x000fe40003000000ULL, 0xff80000042427808ULL, 0x000fe40002800000ULL,
0x0000005b72ff7212ULL, 0x080fe4000782c0ffULL, 0x0000005b74ff7212ULL, 0x000fc4000788c0ffULL,
0x0000005b70ff7212ULL, 0x000fe4000780c0ffULL, 0x0000005f72ff7212ULL, 0x080fe4000786c0ffULL,
0x0000005f74ff7212ULL, 0x080fe4000784c0ffULL, 0x0000005f70ff7212ULL, 0x000fe400078cc0ffULL,
0x000000136eff7212ULL, 0x000fe200078ac0ffULL, 0x00000001585e7824ULL, 0x100fe200078e0a62ULL,
0x0000002c7500720cULL, 0x0c0fe20000f21470ULL, 0x000000015a607824ULL, 0x100fe200078e0a62ULL,
0x0000002c7500720cULL, 0x080fe20001f61470ULL, 0x000000015c627824ULL, 0x000fe200078e0a62ULL,
0x0000002c4a00720cULL, 0x000fc40002781470ULL, 0x0000002c4a00720cULL, 0x080fe40001741470ULL,
0x0000002c5000720cULL, 0x0c0fe40000701470ULL, 0x0000002c5000720cULL, 0x080fe400037c1470ULL,
0x0000002c5d00720cULL, 0x080fe40002fa1470ULL, 0x0000002c7300720cULL, 0x0c0fe40000f21070ULL,
0x0000002c7300720cULL, 0x000fc40001f61070ULL, 0x0000002c7100720cULL, 0x0c0fe40002781070ULL,
0x0000002c7100720cULL, 0x080fe40001741070ULL, 0x0000002c6f00720cULL, 0x0c0fe40000701070ULL,
0x0000002c6f00720cULL, 0x080fe400037c1070ULL, 0x0000002c5900720cULL, 0x000fe40002fa1070ULL,
0x0000005e565e7219ULL, 0x000fc400000006ffULL, 0x0000006056607219ULL, 0x040fe400000006ffULL,
0x0000006256627219ULL, 0x000fe400000006ffULL, 0x0000541014197816ULL, 0x000fe40000000019ULL,
0xff8000003e3e7808ULL, 0x000fe40000800000ULL, 0xff8000003c3c7808ULL, 0x000fe40001800000ULL,
0xff80000020207808ULL, 0x000fc40002000000ULL, 0xff80000022227808ULL, 0x000fe40001000000ULL,
0xff80000021217808ULL, 0x000fe40000000000ULL, 0xff80000027277808ULL, 0x000fe40003000000ULL,
0xff80000023237808ULL, 0x000fe40002800000ULL, 0x000000135eff7212ULL, 0x080fe4000782c0ffULL,
0x0000001360ff7212ULL, 0x000fc4000786c0ffULL, 0x0000001362ff7212ULL, 0x000fe4000788c0ffULL,
0x000000196eff7212ULL, 0x080fe4000784c0ffULL, 0x000000195eff7212ULL, 0x080fe4000780c0ffULL,
0x0000001960ff7212ULL, 0x080fe400078cc0ffULL, 0x0000001962ff7212ULL, 0x000fe400078ac0ffULL,
0x0000002c5d00720cULL, 0x000fc40001741470ULL, 0x0000002c5800720cULL, 0x0c0fe40000f21470ULL,
0x0000002c5800720cULL, 0x080fe40000701470ULL, 0x0000002c5a00720cULL, 0x0c0fe40001f61470ULL,
0x0000002c5a00720cULL, 0x080fe400037c1470ULL, 0x0000002c5c00720cULL, 0x0c0fe40002781470ULL,
0x0000002c5c00720cULL, 0x000fc40002fa1470ULL, 0x0000002c5900720cULL, 0x080fe40001741070ULL,
0x0000002c6d00720cULL, 0x0c0fe40000f21070ULL, 0x0000002c6d00720cULL, 0x080fe40000701070ULL,
0x0000002c6b00720cULL, 0x0c0fe40001f61070ULL, 0x0000002c6b00720cULL, 0x080fe400037c1070ULL,
0x0000002c6900720cULL, 0x000fc40002781070ULL, 0x0000002c6900720cULL, 0x000fe40002fa1070ULL,
0xff80000046467808ULL, 0x000fe40000800000ULL, 0xff80000047477808ULL, 0x000fe40001800000ULL,
0xff80000048487808ULL, 0x000fe40002000000ULL, 0xff80000025257808ULL, 0x000fe40001000000ULL,
0xff80000024247808ULL, 0x000fc40000000000ULL, 0xff8000001b1b7808ULL, 0x000fe40003000000ULL,
0xff80000026267808ULL, 0x000fce0002800000ULL, 0x000000171c00720bULL, 0x004fe20003f1e000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0xfffffff8ff437812ULL, 0x000fe200078ee243ULL,
0x000000013d3d7836ULL, 0x000fe20000000000ULL, 0x0000001c171c7208ULL, 0x000fc80004000000ULL,
0x000000351c00720bULL, 0x000fc80003f1e000ULL, 0x0000001c35117208ULL, 0x000fc80004000000ULL,
0x000000161100720bULL, 0x000fc80003f1e000ULL, 0x0000001116107208ULL, 0x000fc80004000000ULL,
0x000000311000720bULL, 0x000fc80003f1e000ULL, 0x0000001031117208ULL, 0x000fc80004000000ULL,
0x0000001a1100720bULL, 0x000fc80003f1e000ULL, 0x000000111a107208ULL, 0x000fc80004000000ULL,
0x0000002d1000720bULL, 0x000fc80003f1e000ULL, 0x000000102d117208ULL, 0x000fc80004000000ULL,
0x000000281100720bULL, 0x000fc80003f1e000ULL, 0x0000001128107208ULL, 0x000fc80004000000ULL,
0x000000291000720bULL, 0x000fc80003f1e000ULL, 0x0000001029117208ULL, 0x000fc80004000000ULL,
0x000000341100720bULL, 0x000fc80003f1e000ULL, 0x0000001134117208ULL, 0x000fc80004000000ULL,
0x0000003e1100720bULL, 0x000fc80003f1e000ULL, 0x000000113e117208ULL, 0x000fc80004000000ULL,
0x000000201100720bULL, 0x000fc80003f1e000ULL, 0x0000001120107208ULL, 0x000fe40004000000ULL,
0x000000361d00720bULL, 0x000fe40003f1e000ULL, 0x000000211000720bULL, 0x000fc80003f3e000ULL,
0x0000001021127208ULL, 0x000fe40004800000ULL, 0x0000001d36107208ULL, 0x000fe40004000000ULL,
0x000000231200720bULL, 0x000fe40003f3e000ULL, 0x000000371000720bULL, 0x000fe40003f1e000ULL,
0x0000001223137208ULL, 0x000fe40004800000ULL, 0x0000001037117208ULL, 0x000fc40004000000ULL,
0x000000461300720bULL, 0x000fe40003f3e000ULL, 0x000000321100720bULL, 0x000fe40003f1e000ULL,
0x0000001346127208ULL, 0x000fe40004800000ULL, 0x0000001132107208ULL, 0x000fe40004000000ULL,
0x000000471200720bULL, 0x000fe40003f3e000ULL, 0x000000331000720bULL, 0x000fc40003f1e000ULL,
0x0000001247137208ULL, 0x000fe40004800000ULL, 0x0000001033117208ULL, 0x000fe40004000000ULL,
0x000000481300720bULL, 0x000fe40003f3e000ULL, 0x0000002e1100720bULL, 0x000fe40003f1e000ULL,
0x0000001348137208ULL, 0x000fe40004800000ULL, 0x000000112e107208ULL, 0x000fc60004000000ULL,
0x0c401f0013127f89ULL, 0x000ea200000e0000ULL, 0x0000002f1000720bULL, 0x000fc80003f1e000ULL,
0x000000102f117208ULL, 0x000fc80004000000ULL, 0x0000002a1100720bULL, 0x000fc80003f1e000ULL,
0x000000112a107208ULL, 0x000fc80004000000ULL, 0x0000002b1000720bULL, 0x000fc80003f1e000ULL,
0x000000102b117208ULL, 0x000fe40004000000ULL, 0x000000121300720bULL, 0x004fe40003f3e000ULL,
0x000000421100720bULL, 0x000fe40003f1e000ULL, 0x0000001312127208ULL, 0x000fe40004800000ULL,
0x0000001142117208ULL, 0x000fc60004000000ULL, 0x0c201f0012137f89ULL, 0x000ea200000e0000ULL,
0x0000003c1100720bULL, 0x000fc80003f1e000ULL, 0x000000113c117208ULL, 0x000fc80004000000ULL,
0x000000221100720bULL, 0x000fc80003f1e000ULL, 0x0000001122107208ULL, 0x000fc80004000000ULL,
0x000000271000720bULL, 0x000fc80003f1e000ULL, 0x0000001027107208ULL, 0x000fe40004000000ULL,
0x000000131200720bULL, 0x004fe40003f3e000ULL, 0x000000251000720bULL, 0x000fe40003f1e000ULL,
0x00000012132c7208ULL, 0x000fe40004800000ULL, 0x0000001025117208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b2c127820ULL, 0x000fe20000410000ULL, 0x000000241100720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b2d157823ULL, 0x100fe20000010812ULL, 0x0000001124107208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b34187823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b47347823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010812ULL, 0x0000001b1000720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010812ULL, 0x000000101b117208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b1a147823ULL, 0x100fe20000010812ULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b201a7823ULL, 0x100fe20000010812ULL, 0x000000261100720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b3e197823ULL, 0x100fe20000010812ULL, 0x0000001126117208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b231c7823ULL, 0x100fe20000010812ULL, 0x0000003100137308ULL, 0x0004e20000000800ULL,
0x3fb8aa3b461d7823ULL, 0x000fc40000010812ULL, 0x0c401f0011107f89ULL, 0x000f6a00000e0000ULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b21317823ULL, 0x004fce0000010812ULL,
0x00000035004a7308ULL, 0x0005f00000000800ULL, 0x0000002800497308ULL, 0x000be20000000800ULL,
0x3fb8aa3b48357823ULL, 0x004fe20000010812ULL, 0x000000161312723eULL, 0x008fc400000010ffULL,
0x000000101100720bULL, 0x022fc80003f1e000ULL, 0x0000001110107208ULL, 0x000fe20004000000ULL,
0x00000004ff287e24ULL, 0x000fe2000f8e00ffULL, 0x00000029004c7308ULL, 0x0002a60000000800ULL,
0x0c201f00102d7f89ULL, 0x000ee200000e0000ULL, 0x3f8000002828783eULL, 0x000fc800000010ffULL,
0x0000001400147308ULL, 0x000fe20000000800ULL, 0x000000ffff297224ULL, 0x002fe200078e0028ULL,
0x000000494c16723eULL, 0x004fcc00000010ffULL, 0x0000001500157308ULL, 0x000e700000000800ULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x0000002d1000720bULL, 0x008fc80003f1e000ULL,
0x000000102d2d7208ULL, 0x000fc60004000000ULL, 0x0000001900197308ULL, 0x000ea20000000800ULL,
0x000000174a10723eULL, 0x000fe400000010ffULL, 0x000000141514723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b2d477820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010847ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010847ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010847ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010847ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010847ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010847ULL, 0x0000003600117308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010847ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010847ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010847ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010847ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe20000010847ULL, 0x000000181918723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010847ULL, 0x0000003700207308ULL, 0x000e620000000800ULL,
0x3fb8aa3b26267823ULL, 0x000fce0000010847ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x000000112011723eULL, 0x002fce00000010ffULL, 0x0000003300337308ULL, 0x000e700000000800ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x000000323313723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b22327823ULL, 0x000fcc0000010847ULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x000000ffff337224ULL, 0x000fe200078e0028ULL, 0x000000281020723cULL, 0x000fec00000418ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b25297823ULL, 0x000fe40000010847ULL,
0x0c401f001e257f89ULL, 0x000ea200000e0000ULL, 0x0000002e2f15723eULL, 0x002fc800000010ffULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x000000ffff2e7224ULL, 0x100fe400078e0028ULL,
0x000000ffff2f7224ULL, 0x000fca00078e0028ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x0000002a2b17723eULL, 0x002fce00000010ffULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x0c401f001f2a7f89ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b1b2b7823ULL, 0x000fe20000010847ULL,
0x0000002e1420723cULL, 0x000fe20000041820ULL, 0x000000251e00720bULL, 0x004fc80003f1e000ULL,
0x0000001a001a7308ULL, 0x000fe40000000800ULL, 0x0000001e252e7208ULL, 0x000fe20004000000ULL,
0x0000080040257824ULL, 0x000fe200078e020dULL, 0x00000032271b723eULL, 0x002fc800000010ffULL,
0x0000003100317308ULL, 0x000e620000000800ULL, 0x000000ffff327224ULL, 0x000fe400078e0028ULL,
0x0000000843277836ULL, 0x000fc80000000000ULL, 0x0000000827367824ULL, 0x000fe200078e00ffULL,
0x0000004200427308ULL, 0x000fe20000000800ULL, 0x0000002a1f00720bULL, 0x008fc80003f3e000ULL,
0x0000001f2a2f7208ULL, 0x000fe20004800000ULL, 0x00000008272a7824ULL, 0x000fe200078e00ffULL,
0x0000001a311a723eULL, 0x002fe200000010ffULL, 0x0000003c00377308ULL, 0x000e620000000800ULL,
0x0c201f002e317f89ULL, 0x000eae00000e0000ULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x000000423719723eULL, 0x002fce00000010ffULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x000000321820723cULL, 0x000fee0000041820ULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x0c201f002f327f89ULL, 0x000ee200000e0000ULL, 0x000000312e00720bULL, 0x004fe20003f1e000ULL,
0x0001100025337836ULL, 0x000fc60000000000ULL, 0x0000002e312e7208ULL, 0x000fe20004000000ULL,
0x000000ffff257224ULL, 0x000fe200078e0012ULL, 0x0000003500357308ULL, 0x000ea20000000800ULL,
0x0000001c1d1c723eULL, 0x002fe200000010ffULL, 0x000000ffff127224ULL, 0x000fe200078e0015ULL,
0x0000000308ff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff157224ULL, 0x000fc800078e001bULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x00000034351e723eULL, 0x004fce00000010ffULL,
0x0000002400247308ULL, 0x000e620000000800ULL, 0x000000ffff347224ULL, 0x100fe200078e0028ULL,
0x000000322f00720bULL, 0x008fe20003f3e000ULL, 0x000000ffff357224ULL, 0x000fc600078e0028ULL,
0x0000002f322f7208ULL, 0x000fe40004800000ULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x00000029241d723eULL, 0x002fce00000010ffULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x00000003ff247819ULL, 0x000fc80000011608ULL, 0x0000000324247812ULL, 0x000fca00078ec0ffULL,
0x0000000124297824ULL, 0x000fe400078e0227ULL, 0x000000ffff277224ULL, 0x000fe400078e0016ULL,
0x000000ffff167224ULL, 0x000fe200078e001dULL, 0x0000002b261f723eULL, 0x002fe200000010ffULL,
0x0000000843267824ULL, 0x040fe200078e00ffULL, 0xfffffff82a287812ULL, 0x000fe200078ee229ULL,
0x00000008432b7824ULL, 0x000fe400078e00ffULL, 0x0000000124437824ULL, 0x000fc400078e0243ULL,
0x000000341c20723cULL, 0x000fe20000041820ULL, 0x000000ffff297224ULL, 0x000fe400078e001aULL,
0xfffffff826247812ULL, 0x000fe200078ee243ULL, 0x0000000443267836ULL, 0x000fe40000000000ULL,
0x0000000c43437836ULL, 0x000fe40000000000ULL, 0x0000001028347824ULL, 0x000fe200078e0233ULL,
0xfffffff82b267812ULL, 0x000fe200078ee226ULL, 0x000000ffff287224ULL, 0x000fe200078e0018ULL,
0xfffffff836367812ULL, 0x000fe200078ee243ULL, 0x000000ffff2a7224ULL, 0x000fc400078e001cULL,
0x000000ffff2b7224ULL, 0x000fe400078e001eULL, 0x0000001036367824ULL, 0x100fe400078e0233ULL,
0x00000001ff187424ULL, 0x000fe400078e00ffULL, 0x0000001024217824ULL, 0x100fe400078e0233ULL,
0x0000001026237824ULL, 0x000fe400078e0233ULL, 0x000000ffff247224ULL, 0x000fc400078e0010ULL,
0x000000ffff267224ULL, 0x000fe400078e0014ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff117224ULL, 0x000fe200078e0013ULL, 0x0000002421007844ULL, 0x0003e20000000200ULL,
0x000000ffff137224ULL, 0x000fe400078e0017ULL, 0x000000ffff147224ULL, 0x000fe200078e0019ULL,
0x0000002823007844ULL, 0x0005e20000000200ULL, 0x000000ffff177224ULL, 0x000fc400078e001fULL,
0x000000ffff1e7224ULL, 0x000fe200078e0038ULL, 0x0000001034007844ULL, 0x0005e80000000200ULL,
0x0000001436007844ULL, 0x0005e20000000200ULL, 0x000000ffff217224ULL, 0x002fc600078e0022ULL,
0x0170002c30008388ULL, 0x0005e80000000c00ULL, 0x0172002030008388ULL, 0x0005e20000000a00ULL,
0x000000393d00720cULL, 0x000fe20003f06070ULL, 0x017608180fff79a7ULL, 0x0005e2000850003fULL,
0x017610180fff79a7ULL, 0x0005e2000850003fULL, 0x017618180fff79a7ULL, 0x0005e2000850003fULL,
0x017620180fff79a7ULL, 0x0005f2000850003fULL, 0xffffffa4008c8947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000054007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000005400008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff54ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000054027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000005400007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffea402ec7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x000000000000057fULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000700ULL, 0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000958ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a38ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a8cULL, 0x0000000000000670ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001100ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001100ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000001148ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001180ULL, 0x0000000000015900ULL, 0x0000001700000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000016a80ULL, 0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000016ad0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000016ad0ULL, 0x0000000000000278ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x00000000000170c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x00000000000170c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000001148ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000015900ULL, 0x0000000000015900ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000016a80ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000016ad0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000278ULL, 0x0000000000000278ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_90_cubin_len = 94744;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
